﻿USE sofia;
DROP TABLE IF EXISTS sofia.tamtcv_vpl;
CREATE TABLE tamtcv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tamtcv_vpl WRITE;
INSERT INTO tamtcv_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ஆரம்பத்தில் இறைவன் வானங்களையும் பூமியையும் படைத்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","பூமி உருவமற்று வெறுமையாய் இருந்தது. ஆழத்தின் மேற்பரப்பில் இருள் பரவியிருந்தது. இறைவனின் ஆவியானவர் தண்ணீரின்மேல் அசைவாடிக்கொண்டிருந்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","அதன்பின் இறைவன், “ஒளி உண்டாகட்டும்” என்று சொன்னார்; ஒளி உண்டாயிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","ஒளி நல்லது என்று இறைவன் கண்டார், அவர் இருளிலிருந்து ஒளியைப் பிரித்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","இறைவன் ஒளிக்குப் “பகல்” என்றும் இருளுக்கு “இரவு” என்றும் பெயரிட்டார். மாலையும் காலையுமாகி முதலாம் நாள் ஆயிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","அதன்பின் இறைவன், “தண்ணீர்திரளுக்கு இடையில் ஒரு வானவெளி உண்டாகட்டும்; அந்த வானவெளி கீழே இருக்கிற தண்ணீரிலிருந்து வானவெளிக்கு மேலே இருக்கிற தண்ணீரைப் பிரிக்கட்டும்” என்று சொன்னார். ");
INSERT INTO tamtcv_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","இவ்வாறு இறைவன் இந்த வானவெளியை உண்டாக்கி, கீழேயுள்ள தண்ணீரை, மேலேயுள்ள தண்ணீரிலிருந்து பிரித்தார். அது அப்படியே ஆயிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","இறைவன் வானவெளிக்கு “ஆகாயம்” என்று பெயரிட்டார். அப்பொழுது மாலையும் காலையுமாகி இரண்டாம் நாள் ஆயிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","அதன்பின் இறைவன், “ஆகாயத்தின் கீழுள்ள தண்ணீர் ஓரிடத்தில் சேர்ந்து, உலர்ந்த தரை தோன்றட்டும்” என்று சொன்னார். அது அப்படியே ஆயிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","இறைவன் உலர்ந்த தரைக்கு “நிலம்” என்றும், சேர்ந்த தண்ணீருக்கு “கடல்” என்றும் பெயரிட்டார். அது நல்லது என்று இறைவன் கண்டார். ");
INSERT INTO tamtcv_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","அதன்பின் இறைவன், “நிலம் தாவர வகைகளை முளைப்பிக்கட்டும்: விதை தரும் பயிர்களையும், விதையுள்ள பழங்களைக் கொடுக்கும் மரங்களையும் தன்தன் வகைகளின்படியே முளைப்பிக்கட்டும்” என்று சொன்னார். அது அப்படியே ஆயிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","நிலம் தாவரங்களை முளைப்பித்தது: விதையை பிறப்பிக்கும் பயிர்களை அவற்றின் வகைகளின்படியும், விதையுள்ள பழங்களைக் கொடுக்கும் மரங்களை அவற்றின் வகைகளின்படியும் முளைப்பித்தது. அது நல்லது என்று இறைவன் கண்டார். ");
INSERT INTO tamtcv_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","அப்பொழுது மாலையும் காலையுமாகி மூன்றாம் நாள் ஆயிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","அதன்பின் இறைவன், “வானவெளியில் ஒளிச்சுடர்கள் உண்டாகட்டும், அவை இரவிலிருந்து பகலைப் பிரிக்கட்டும்; அவை பூமியில் பருவகாலங்களையும், நாட்களையும், வருடங்களையும் குறிக்கும் அடையாளங்களாகவும், ");
INSERT INTO tamtcv_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","அவை பூமிக்கு ஒளி கொடுக்கும்படி, வானவெளியில் ஒளிச்சுடர்களாய் இருக்கட்டும்” என்று சொன்னார். அது அப்படியே ஆயிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","பகலை ஆளுவதற்குப் பெரிய சுடரும், இரவை ஆளுவதற்குச் சிறிய சுடருமாக, இறைவன் இரு பெரும் ஒளிச்சுடர்களை உண்டாக்கினார். அவர் நட்சத்திரங்களையும் உண்டாக்கினார். ");
INSERT INTO tamtcv_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","இறைவன் அவற்றைப் பூமிக்கு வெளிச்சம் கொடுப்பதற்காக வானவெளியில் வைத்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","பகலையும் இரவையும் ஆளுவதற்காகவும், இருளிலிருந்து ஒளியைப் பிரிப்பதற்காகவும் அவற்றை வைத்தார். அது நல்லது என்று இறைவன் கண்டார். ");
INSERT INTO tamtcv_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","அப்பொழுது மாலையும் காலையுமாகி, நான்காம் நாள் ஆயிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","அதன்பின் இறைவன், “தண்ணீரில் நீந்தும் உயிரினங்கள் பெருகட்டும், பூமிக்கு மேலாக வானவெளியெங்கும் பறவைகள் பறக்கட்டும்” என்று சொன்னார். ");
INSERT INTO tamtcv_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","இவ்வாறு இறைவன் பெரிய கடல் விலங்குகளையும், நீரில் நீந்தி வாழும் எல்லா உயிரினங்களையும் அவற்றின் வகைகளின்படியும், சிறகுள்ள எல்லா பறவைகளையும் அதினதின் வகைகளின்படியும் படைத்தார். அது நல்லது என்று இறைவன் கண்டார். ");
INSERT INTO tamtcv_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","இறைவன் அவற்றை ஆசீர்வதித்து, “பலுகி எண்ணிக்கையில் பெருகி, கடல்நீரை நிரப்புங்கள், பூமியில் பறவைகளும் பெருகட்டும்” என்று சொன்னார். ");
INSERT INTO tamtcv_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","அப்பொழுது மாலையும் காலையுமாகி, ஐந்தாம் நாள் ஆயிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","அதன்பின் இறைவன், “நிலம் உயிரினங்களை அவற்றின் வகைகளின்படி உண்டாக்கட்டும்: வளர்ப்பு மிருகங்களையும், ஊரும் பிராணிகளையும், காட்டு மிருகங்களையும் அதினதின் வகையின்படி உண்டாக்கட்டும்” என்று சொன்னார். அது அப்படியே ஆயிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","இறைவன் காட்டு மிருகங்களை அவற்றின் வகைகளின்படியும், வளர்ப்பு மிருகங்களை அவற்றின் வகைகளின்படியும், தரையில் ஊரும் உயிரினங்கள் எல்லாவற்றையும் அவற்றின் வகைகளின்படியும் உண்டாக்கினார். அது நல்லது என்று இறைவன் கண்டார். ");
INSERT INTO tamtcv_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","அதன்பின் இறைவன், “நமது உருவிலும் நமது சாயலின்படியும் மனிதனை உண்டாக்குவோம்; அவர்கள் கடலின் மீன்களையும், ஆகாயத்துப் பறவைகளையும், வளர்ப்பு மிருகங்களையும், எல்லா காட்டு மிருகங்களையும், தரையெங்கும் ஊரும் எல்லா உயிரினங்களையும் ஆளுகை செய்யட்டும்” என்று சொன்னார். ");
INSERT INTO tamtcv_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","அப்படியே இறைவன் தமது சாயலில் மனிதனைப் படைத்தார், இறைவனின் சாயலிலேயே அவர் அவர்களைப் படைத்தார். அவர் அவர்களை ஆணும் பெண்ணுமாகப் படைத்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","அதன்பின் இறைவன் அவர்களை ஆசீர்வதித்து, “நீங்கள் பலுகி எண்ணிக்கையில் பெருகி, பூமியை நிரப்பி, அதைக் கீழ்ப்படுத்துங்கள். கடலின் மீன்களையும், ஆகாயத்துப் பறவைகளையும், தரையில் நடமாடும் எல்லா உயிரினங்களையும் ஆண்டு நடத்துங்கள்” எனக் கூறினார். ");
INSERT INTO tamtcv_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","அதன்பின் இறைவன், “பூமி முழுவதும் மேற்பரப்பிலுள்ள விதை தரும் தாவரங்களையும், விதையுள்ள பழங்களைக் கொடுக்கும் எல்லா மரங்களையும் உங்களுக்குக் கொடுக்கிறேன். அவை உங்களுக்கு உணவாயிருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","பூமியிலுள்ள எல்லா மிருகங்களுக்கும், ஆகாயத்துப் பறவைகளுக்கும், தரையில் நடமாடும் எல்லா உயிரினங்களுக்கும், அதாவது தன்னில் உயிர்மூச்சு உள்ள எல்லா உயிரினங்களுக்கும் நான் பச்சைத் தாவரங்கள் எல்லாவற்றையும் உணவாகக் கொடுக்கிறேன்” என்று சொன்னார். அது அப்படியே ஆயிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","இறைவன் தாம் உண்டாக்கிய எல்லாவற்றையும் பார்த்தார், அது மிக நன்றாயிருந்தது. அப்பொழுது மாலையும் காலையுமாகி, ஆறாம் நாள் ஆயிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","இவ்வாறு வானமும் பூமியும், அவற்றில் உள்ள எல்லாம் உண்டாக்கப்பட்டு முடிந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ஏழாம்நாள் ஆகும்போது இறைவன் தான் செய்துகொண்டிருந்த வேலையை முடித்தார்; ஆதலால் அவர், ஏழாம்நாளில் எல்லா வேலையிலிருந்தும் ஓய்ந்திருந்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","இறைவன் தாம் செய்துமுடித்த படைப்பின் வேலைகள் எல்லாவற்றிலுமிருந்து ஏழாம்நாளில் ஓய்ந்திருந்தபடியால், அந்த நாளை ஆசீர்வதித்து, அதைப் பரிசுத்தமாக்கினார். ");
INSERT INTO tamtcv_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","இறைவனாகிய யெகோவா வானத்தையும் பூமியையும் உண்டாக்கியபோது, வானமும் பூமியும் படைக்கப்பட்ட வரலாறு இவைகளே. ");
INSERT INTO tamtcv_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","இறைவனாகிய யெகோவா பூமியில் மழையை அனுப்பாதிருந்ததினால், பூமியில் எந்தப் புதரும் இன்னும் காணப்படவுமில்லை, எந்த செடிகளும் இன்னும் முளைத்திருக்கவும் இல்லை; நிலத்தைப் பண்படுத்தவும் யாரும் இருக்கவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ஆனாலும், பூமியிலிருந்து மூடுபனி மேலெழும்பி நிலத்தின் மேற்பரப்பு முழுவதையும் நனைத்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","இறைவனாகிய யெகோவா நிலத்தின் மண்ணினால் மனிதனை உருவாக்கி, அவனுடைய நாசியில் உயிர்மூச்சை ஊதினார்; அப்பொழுது மனிதன் உயிருள்ளவனானான். ");
INSERT INTO tamtcv_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","இறைவனாகிய யெகோவா, கிழக்குத் திசையிலுள்ள ஏதேனில் ஒரு தோட்டத்தை அமைத்து, தாம் உருவாக்கிய மனிதனை அங்கே குடியமர்த்தினார். ");
INSERT INTO tamtcv_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","இறைவனாகிய யெகோவா பார்வைக்கு இனியதும் உணவுக்கு ஏற்றதுமான எல்லா வகையான மரங்களையும் அத்தோட்டத்தில் வளரச்செய்தார். தோட்டத்தின் நடுவில் வாழ்வளிக்கும் மரமும் நன்மை தீமையின் அறிவைத் தரும் மரமும் இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ஏதேனிலிருந்து ஒரு ஆறு ஓடி, தோட்டத்திற்கு தண்ணீர் பாய்ச்சியது. அங்கிருந்து அது நான்கு ஆறுகளாகப் பிரிந்து ஓடியது. ");
INSERT INTO tamtcv_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","முதலாம் ஆற்றின் பெயர் பைசோன்; அது தங்கம் விளையும் தேசமான ஆவிலா நாடு முழுவதின் வழியாகவும் வளைந்து ஓடியது. ");
INSERT INTO tamtcv_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","அந்த நாட்டின் தங்கம் மிகத் தரமானது; அங்கே நறுமணமுள்ள சாம்பிராணியும் கோமேதகக் கல்லும் இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","இரண்டாம் ஆற்றின் பெயர் கீகோன். அது எத்தியோப்பியா நாடு முழுவதின் வழியாகவும் வளைந்து ஓடியது. ");
INSERT INTO tamtcv_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","மூன்றாம் ஆற்றின் பெயர் திக்ரீசு என்ற இதெக்கேல். இது அசீரியா நாட்டின் கிழக்குப் பக்கம் ஓடியது. நான்காம் ஆற்றுக்கு ஐபிராத்து என்று பெயர். ");
INSERT INTO tamtcv_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","இறைவனாகிய யெகோவா, மனிதனைக் கொண்டுபோய், ஏதேன் தோட்டத்தைப் பண்படுத்தவும், பாதுகாக்கவும் அவனை அங்கு குடியமர்த்தினார். ");
INSERT INTO tamtcv_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","பின்பு இறைவனாகிய யெகோவா கட்டளையிட்டு, “நீ தோட்டத்திலுள்ள எந்த மரத்திலிருந்தும் சாப்பிடலாம்; ");
INSERT INTO tamtcv_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ஆனால் நீ நன்மை தீமையின் அறிவைத் தரும் மரத்திலிருந்து மட்டும் சாப்பிடக்கூடாது, ஏனெனில் அதிலிருந்து சாப்பிடும் நாளில் நிச்சயமாய் நீ சாகவே சாவாய்” என்று சொன்னார். ");
INSERT INTO tamtcv_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","பின்பு இறைவனாகிய யெகோவா, “மனிதன் தனிமையாக இருப்பது நல்லதல்ல; அவனுக்குத் தகுந்த ஒரு துணையை உண்டாக்குவேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","அப்பொழுது இறைவனாகிய யெகோவா எல்லா காட்டு மிருகங்களையும், எல்லா ஆகாயத்துப் பறவைகளையும் மண்ணிலிருந்து உருவாக்கியிருந்தார். மனிதன் அவற்றுக்கு என்ன பெயரிடுவான் என்று பார்க்கும்படி அவர் அவற்றை அவனிடம் கொண்டுவந்தார்; மனிதன் ஒவ்வொரு உயிரினத்தையும் எப்படி அழைத்தானோ அதுவே அதற்குப் பெயராயிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","இவ்வாறு மனிதன் எல்லா வளர்ப்பு மிருகங்கள், ஆகாயத்துப் பறவைகள், காட்டு மிருகங்கள் அனைத்திற்கும் பெயரிட்டான். ஆனால் ஆதாமுக்கோ தகுந்த துணை இன்னமும் காணப்படவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","எனவே இறைவனாகிய யெகோவா மனிதனுக்கு ஆழ்ந்த நித்திரையை வரப்பண்ணினார்; அவன் நித்திரையாய் இருந்தபோது, அவர் அவனுடைய விலா எலும்புகளில் ஒன்றை எடுத்து அந்த இடத்தைச் சதையினால் மூடினார். ");
INSERT INTO tamtcv_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","பின்பு இறைவனாகிய யெகோவா, தான் மனிதனிலிருந்து எடுத்த விலா எலும்பிலிருந்து ஒரு பெண்ணை உண்டாக்கி, அவளை மனிதனிடம் கொண்டுவந்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","அப்பொழுது மனிதன் சொன்னான்: “இவள் என் எலும்பின் எலும்பாகவும் என் சதையின் சதையாகவும் இருக்கிறாள்; இவள் மனிதனிலிருந்து எடுக்கப்பட்டபடியால், ‘மனுஷி’ என்று அழைக்கப்படுவாள்.” ");
INSERT INTO tamtcv_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","இதனாலேயே மனிதன் தன் தகப்பனையும் தாயையும் விட்டு, தனது மனைவியுடன் இணைந்திருப்பான்; இருவரும் ஒரே உடலாயிருப்பார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","ஆதாமும் அவன் மனைவியும் நிர்வாணமாய் இருந்தார்கள். ஆனாலும் அவர்கள் வெட்கப்படவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","இறைவனாகிய யெகோவா உண்டாக்கியிருந்த காட்டு மிருகங்கள் எல்லாவற்றையும்விட, பாம்பு அதிக தந்திரமுள்ளதாய் இருந்தது. பாம்பு அப்பெண்ணிடம், “தோட்டத்தில் உள்ள எந்த ஒரு மரத்திலிருந்தும் சாப்பிடவேண்டாம் என்று இறைவன் உங்களுக்குச் சொன்னாரோ?” எனக் கேட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","அதற்கு அந்தப் பெண் பாம்பிடம், “தோட்டத்திலுள்ள மரங்களின் பழங்களை நாங்கள் சாப்பிடலாம்; ");
INSERT INTO tamtcv_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ஆனால் இறைவன், ‘நீங்கள் தோட்டத்தின் நடுவிலுள்ள மரத்திலிருந்து பழத்தை சாப்பிடக்கூடாது, அதைத் தொடவும் கூடாது, மீறினால் சாவீர்கள்’ என்று சொல்லியிருக்கிறார்” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","அதற்குப் பாம்பு அந்தப் பெண்ணிடம், “நிச்சயமாக நீங்கள் சாகவே மாட்டீர்கள்” என்று சொன்னது. ");
INSERT INTO tamtcv_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","“ஏனெனில் அந்த மரத்திலிருந்து சாப்பிடும் நாளிலே, உங்கள் கண்கள் திறக்கப்படும். நீங்கள் இறைவனைப் போலாகி, நன்மையையும் தீமையையும் அறிவீர்கள் என்பது இறைவனுக்குத் தெரியும்” என்றது. ");
INSERT INTO tamtcv_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","அப்பொழுது அந்தப் பெண், அந்த மரத்தின் பழம் சாப்பிடுவதற்கு நல்லதாயும், பார்வைக்கு அழகானதாயும் இருந்ததுடன், அது அறிவைப் பெறுவதற்கு விரும்பத்தக்கதாயும் இருக்கக் கண்டாள்; அவள் அதின் பழத்தைப் பறித்துச் சாப்பிட்டாள். பின்பு அதைத் தன்னுடனிருந்த தன் கணவனுக்கும் சாப்பிடக் கொடுத்தாள், அவனும் அதைச் சாப்பிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","பிறகு அவர்கள் இருவருடைய கண்களும் திறக்கப்பட்டு, முன்னர் அறிந்திராத விஷயங்களை அறிந்துகொண்டார்கள்; அப்பொழுது தாங்கள் இருவரும் நிர்வாணிகளாய் இருப்பதை அவர்கள் உணர்ந்தார்கள். எனவே அவர்கள் அத்தியிலைகளைத் தைத்துத் தங்களை மூடிக்கொண்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","அன்று மாலை தென்றல் காற்று வீசிய வேளையில், இறைவனாகிய யெகோவா தோட்டத்தில் உலாவிக் கொண்டிருக்கும் சத்தத்தை மனிதனும் அவன் மனைவியும் கேட்டார்கள்; உடனே அவர்கள் தோட்டத்தின் மரங்களுக்கு இடையில் இறைவனாகிய யெகோவாவிடமிருந்து ஒளிந்துகொண்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","ஆனாலும் இறைவனாகிய யெகோவா மனிதனைக் கூப்பிட்டு, “நீ எங்கே இருக்கிறாய்?” என்று கேட்டார். ");
INSERT INTO tamtcv_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","அதற்கு அவன், “நான் தோட்டத்தில் உமது சத்தத்தைக் கேட்டேன்; நான் நிர்வாணியாய் இருந்தபடியால் பயந்து, ஒளிந்துகொண்டேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","அதற்கு யெகோவா, “நீ நிர்வாணி என்று உனக்குச் சொன்னது யார்? சாப்பிட வேண்டாமென்று நான் உனக்குக் கட்டளையிட்ட மரத்திலிருந்து நீ சாப்பிட்டாயோ?” என்று கேட்டார். ");
INSERT INTO tamtcv_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","அதற்கு மனிதன், “என்னுடன் இங்கு இருப்பதற்கு நீர் எனக்குத் தந்த பெண்ணே, அந்த மரத்தின் பழத்தை எனக்குக் கொடுத்தாள்; நான் சாப்பிட்டேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","பின்பு இறைவனாகிய யெகோவா அந்த பெண்ணிடம், “நீ செய்திருக்கும் இந்தக் காரியம் என்ன?” என்று கேட்டார். அதற்கு அந்தப் பெண், “பாம்பு என்னை ஏமாற்றியது, அதனால்தான் நான் சாப்பிட்டேன்” என்று சொன்னாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","அதனால் இறைவனாகிய யெகோவா பாம்பிடம் சொன்னதாவது: “நீ இவ்வாறு செய்திருக்கிறபடியால், “வளர்ப்பு மிருகங்கள், காட்டு மிருகங்கள் எல்லாவற்றைப் பார்க்கிலும் அதிகமாய் சபிக்கப்பட்டிருப்பாய்! நீ வயிற்றினால் ஊர்ந்து திரிவாய்; உன் உயிருள்ள நாளெல்லாம் புழுதியைத் தின்பாய். ");
INSERT INTO tamtcv_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","உனக்கும் பெண்ணுக்கும் இடையிலும், உன்னுடைய சந்ததிக்கும் அவளுடைய சந்ததிக்கும் இடையிலும் நான் பகையை உண்டாக்குவேன்; அவர் உன் தலையை நசுக்குவார், நீ அவரது குதிங்காலை நசுக்குவாய்.” ");
INSERT INTO tamtcv_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","அதன்பின்பு அவர் பெண்ணிடம் சொன்னதாவது: “உன் குழந்தைபேற்றின் வேதனையை அதிகமாய்க் கூட்டுவேன்; வேதனையோடு நீ குழந்தைகளைப் பெறுவாய்; உன் ஆசை உன் கணவன் மேலேயே இருக்கும், அவன் உன்னை ஆண்டு நடத்துவான்.” ");
INSERT INTO tamtcv_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","அவர் ஆதாமிடம் சொன்னதாவது: “ ‘நீ சாப்பிடவேண்டாம்,’ என நான் உனக்குக் கட்டளையிட்ட மரத்திலிருந்து நீ உன் மனைவியின் சொல்லைக் கேட்டுச் சாப்பிட்டபடியினால், “உன் நிமித்தம் பூமி சபிக்கப்பட்டிருக்கும்; உன் வாழ்நாளெல்லாம் நீ வருந்தி உழைத்தே பூமியின் பலனைச் சாப்பிடுவாய். ");
INSERT INTO tamtcv_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","பூமி முற்களையும் முற்புதர்களையும் உனக்கு விளைவிக்கும், வயலின் பயிர்களையே நீ சாப்பிடுவாய். ");
INSERT INTO tamtcv_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","நீ புழுதியிலிருந்து எடுக்கப்பட்டபடியால், நீ புழுதிக்குத் திரும்பும்வரை, நெற்றி வியர்வை சிந்தியே உன் உணவைச் சாப்பிடுவாய்; நீ புழுதியிலிருந்து உண்டாக்கப்பட்டதால் புழுதிக்கே திரும்புவாய்.” ");
INSERT INTO tamtcv_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","ஆதாம் தன் மனைவிக்கு ஏவாள் என்று பெயரிட்டான், ஏனெனில் பூமியில் வாழ்வோருக்கெல்லாம் தாயாவாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","இறைவனாகிய யெகோவா தோலினால் உடைகளைச் செய்து, ஆதாமுக்கும் அவன் மனைவிக்கும் உடுத்தினார். ");
INSERT INTO tamtcv_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","அதன்பின் இறைவனாகிய யெகோவா, “மனிதன் இப்பொழுது நன்மையையும் தீமையையும் அறிந்து, நம்மில் ஒருவரைப்போல் ஆகிவிட்டான். அவன் தன் கையை நீட்டி, வாழ்வளிக்கும் மரத்திலிருந்து பறித்துச் சாப்பிட்டு, என்றென்றைக்கும் உயிர்வாழ இடமளிக்கக் கூடாது” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","எனவே இறைவனாகிய யெகோவா, நிலத்திலிருந்து எடுக்கப்பட்ட அவனை நிலத்தையே பண்படுத்திப் பயிர்செய்யும்படி, ஏதேன் தோட்டத்திலிருந்து வெளியே துரத்தினார். ");
INSERT INTO tamtcv_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","அவர் மனிதனை வெளியே துரத்திவிட்டபின், ஏதேன் தோட்டத்தின் கிழக்குப் பக்கமாக கேருபீன்களையும், சுற்றிச் சுழலும் சுடரொளி வாளையும் வாழ்வளிக்கும் மரத்திற்குப் போகும் வழியைக் காவல் காக்கும்படி வைத்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","ஆதாம் தன் மனைவி ஏவாளுடன் உறவுகொண்டான்; அவள் கர்ப்பவதியாகி காயீனைப் பெற்று, “நான் யெகோவாவின் உதவியால் ஒரு மகனைப் பெற்றேன்” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","பின்பு அவள் காயீனின் சகோதரனான ஆபேலைப் பெற்றாள். ஆபேல் மந்தை மேய்த்தான், காயீன் விவசாயம் செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","சிறிது காலத்தின்பின் காயீன் தன் நிலத்தின் விளைச்சலில் சிலவற்றை யெகோவாவுக்குக் காணிக்கையாகக் கொண்டுவந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ஆபேலும் தன் மந்தையின் கொழுத்தத் தலையீற்றுகளில் சிலவற்றைக் காணிக்கையாகக் கொண்டுவந்தான். யெகோவா ஆபேலையும் அவன் காணிக்கையையும் தயவுடன் ஏற்றுக்கொண்டார், ");
INSERT INTO tamtcv_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ஆனால் காயீனையும் அவன் காணிக்கையையும் ஏற்றுக்கொள்ளவில்லை. இதனால் காயீன் கடுங்கோபங்கொண்டான், கோபத்தால் அவன் முகம் சோர்ந்திருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","அப்பொழுது யெகோவா காயீனிடம், “நீ ஏன் கோபமாய் இருக்கிறாய்? உன் முகம் ஏன் சோர்ந்திருக்கிறது? ");
INSERT INTO tamtcv_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","நீ சரியானதைச் செய்தால், நீ உயர்வு பெறுவாய் அல்லவா? நீ சரியானதைச் செய்யாவிட்டால், உன் கதவடியில் பதுங்கிக் கிடக்கும் பாவம் உன்னைப் பற்றிப் பிடித்துக்கொள்ளுமே; நீயோ அதை மேற்கொள்ளவேண்டும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","அதன்பின்பு காயீன் தன் சகோதரன் ஆபேலிடம், “நாம் வயல்வெளிக்குப் போவோம்” என்றான். அவர்கள் வயலில் இருக்கையில் காயீன் தன் சகோதரன் ஆபேலைத் தாக்கிக் கொன்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","அப்பொழுது யெகோவா காயீனிடம், “உன் சகோதரன் ஆபேல் எங்கே?” என்று கேட்டார். அதற்குக் காயீன், “எனக்குத் தெரியாது; நான் என் சகோதரனுக்குக் காவல்காரனோ?” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","அதற்கு யெகோவா, “நீ என்ன செய்துவிட்டாய்? கேள், உன் சகோதரனின் இரத்தம் நிலத்தில் இருந்து என்னை நோக்கிக் கதறுகிறது! ");
INSERT INTO tamtcv_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","இப்பொழுது நீ சபிக்கப்பட்டிருக்கிறாய், உன் சகோதரனுடைய இரத்தத்தை உன் கையிலிருந்து வாங்க தன் வாயைத் திறந்த, இந்த நிலத்திலிருந்து நீ துரத்தப்பட்டும் இருக்கிறாய். ");
INSERT INTO tamtcv_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","நீ நிலத்தைப் பண்படுத்திப் பயிரிடும்போது அது உனக்கு விளைச்சலைத் தராது. நீ பூமியில் நிம்மதியின்றி அலைந்து திரிகிறவனாய் இருப்பாய்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","அதற்கு காயீன் யெகோவாவிடம், “இந்த தண்டனை என்னால் தாங்க முடியாததாய் இருக்கிறது. ");
INSERT INTO tamtcv_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","இன்று நீர் என்னை இவ்விடத்திலிருந்து துரத்திவிடுகிறீர்; நான் உமது முன்னிலையிலிருந்து மறைக்கப்பட்டு, பூமியில் நிம்மதியின்றி அலைந்து திரிகிறவனாவேன்; என்னைக் காண்கிற எவனும் என்னைக் கொன்றுபோடுவானே” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","அதற்கு யெகோவா, “அப்படியல்ல; காயீனைக் கொல்பவன் எவனிடமும் ஏழுமடங்கு பழிவாங்கப்படும்” என்று அவனுக்குச் சொன்னார். பின்பு யெகோவா அவனைக் காண்பவர்கள் அவனைக் கொன்றுவிடாதபடி, அவன்மேல் ஓர் அடையாளத்தை வைத்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","அப்பொழுது காயீன் யெகோவாவின் முன்னிலையிலிருந்து சென்று, ஏதேனுக்குக் கிழக்கேயுள்ள நோத் என்னும் நாட்டில் குடியிருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","பின்பு காயீன் தன் மனைவியுடன் உறவுகொண்டான்; அவள் கர்ப்பவதியாகி, ஏனோக்கைப் பெற்றாள். பின்பு காயீன் ஒரு பட்டணத்தைக் கட்டிக்கொண்டிருந்தான்; அதற்கு தன் மகனின் பெயரின்படி ஏனோக் என்று பெயரிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ஏனோக்கிற்கு ஈராத் பிறந்தான், ஈராத் மெகுயயேலின் தகப்பனும், மெகுயயேல் மெத்தூசயேலின் தகப்பனும், மெத்தூசயேல் லாமேக்கின் தகப்பனும் ஆனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","லாமேக் இரு பெண்களைத் திருமணம் செய்தான். ஒருத்தியின் பெயர் ஆதாள், மற்றவள் சில்லாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ஆதாள் யாபாலைப் பெற்றாள்; முதன்முதலில் கூடாரங்களில் வசித்து, மந்தை மேய்த்தவன் அவனே. ");
INSERT INTO tamtcv_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","அவனுடைய சகோதரனின் பெயர் யூபால்; அவன் முதன்முதலில் வீணை, புல்லாங்குழல் ஆகிய இசைக்கருவிகளை இசைத்தவன் ஆனான். ");
INSERT INTO tamtcv_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","சில்லாளும், தூபால்காயீன் என்னும் ஒரு மகனைப் பெற்றாள்; அவன் வெண்கலம், இரும்பு ஆகியவற்றால் கருவிகளைச் செய்யும் தொழிலாளி ஆனான். தூபால்காயீனுடைய சகோதரி நாமாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","லாமேக் தன் இரு மனைவிகளிடம் சொன்னதாவது: “ஆதாளே, சில்லாளே, எனக்குச் செவிகொடுங்கள்; லாமேக்கின் மனைவிகளே, என் வார்த்தைகளைக் கேளுங்கள். என்னைக் காயப்படுத்தியபடியால் ஒரு மனிதனைக் கொன்றேன், எனக்குத் தீங்கு செய்தபடியாலேயே அந்த வாலிபனைக் கொன்றேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","காயீனைக் கொல்பவனிடம் ஏழுமடங்கு பழிவாங்கப்படும் என்றால், லாமேக்கிற்காக எழுபத்தேழு மடங்கு பழிவாங்கப்படும்.” ");
INSERT INTO tamtcv_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","ஆதாம் மீண்டும் தன் மனைவியுடன் உறவுகொண்டான், அவள் ஒரு மகனைப் பெற்றாள், “காயீன் கொலைசெய்த ஆபேலுக்குப் பதிலாக இறைவன் வேறொரு பிள்ளையைக் கொடுத்தார்” என்று சொல்லி, அவனுக்கு சேத் என்று பெயரிட்டாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","சேத்தும் ஒரு மகனைப் பெற்றான்; அவன் தன் மகனுக்கு ஏனோஸ் என்று பெயரிட்டான். அக்காலத்தில் மக்கள் யெகோவாவின் பெயரைக் கூப்பிட்டு அவரை ஆராதிக்க ஆரம்பித்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ஆதாமின் வம்சவரலாறு இதுவே: இறைவன் மனிதரைப் படைத்தபோது, அவனை இறைவனின் சாயலிலேயே உண்டாக்கினார். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","அவர் அவர்களை ஆணும் பெண்ணுமாகப் படைத்து, அவர்களை ஆசீர்வதித்தார். அவர் அவர்களைப் படைத்தபோது அவர்களை, “மனிதர்” என்று அழைத்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","ஆதாம் 130 வருடங்கள் வாழ்ந்தபின், ஆதாமுக்கு தன்னுடைய சாயலிலும், தன்னுடைய உருவிலும் ஒரு மகன் பிறந்தான்; அவனுக்கு “சேத்” என்று பெயரிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","சேத் பிறந்தபின் ஆதாம் 800 வருடங்கள் வாழ்ந்து, இன்னும் பல மகன்களையும் மகள்களையும் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ஆதாம் மொத்தம் 930 வருடங்கள் வாழ்ந்தபின் இறந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","சேத் தனது 105 வயதில் ஏனோஸுக்குத் தகப்பனானான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","சேத் ஏனோஸைப் பெற்றபின் 807 வருடங்கள் வாழ்ந்து இன்னும் பல மகன்களையும் மகள்களையும் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","சேத் மொத்தம் 912 வருடங்கள் வாழ்ந்தபின் இறந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ஏனோஸ் தனது 90 வயதில் கேனானுக்குத் தகப்பனானான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","கேனான் பிறந்த பிறகு ஏனோஸ் 815 வருடங்கள் வாழ்ந்து, இன்னும் பல மகன்களையும் மகள்களையும் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ஏனோஸ் மொத்தம் 905 வருடங்கள் வாழ்ந்தபின் இறந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","கேனான் தனது 70 வயதில் மகலாலெயேலுக்குத் தகப்பனானான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","மகலாலெயேல் பிறந்த பிறகு, கேனான் 840 வருடங்கள் வாழ்ந்து, இன்னும் பல மகன்களையும் மகள்களையும் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","கேனான் மொத்தம் 910 வருடங்கள் வாழ்ந்தபின் இறந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","மகலாலெயேல் தனது 65 வயதில் யாரேத்திற்குத் தகப்பனானான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","யாரேத் பிறந்த பிறகு மகலாலெயேல் 830 வருடங்கள் வாழ்ந்து, இன்னும் பல மகன்களையும் மகள்களையும் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","மகலாலெயேல் மொத்தம் 895 வருடங்கள் வாழ்ந்தபின் இறந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","யாரேத் தனது 162 வயதில் ஏனோக்குக்குத் தகப்பனானான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ஏனோக்கு பிறந்த பிறகு யாரேத் 800 வருடங்கள் வாழ்ந்து, இன்னும் பல மகன்களையும் மகள்களையும் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","யாரேத் மொத்தம் 962 வருடங்கள் வாழ்ந்தபின் இறந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ஏனோக்கு தனது 65 வயதில் மெத்தூசலாவுக்குத் தகப்பனானான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","மெத்தூசலா பிறந்த பிறகு ஏனோக்கு 300 வருடங்கள் இறைவனுடன் நெருங்கிய உறவுடன் அர்ப்பணிப்போடு வாழ்ந்தான். அவன் இன்னும் பல மகன்களையும் மகள்களையும் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ஏனோக்கு மொத்தம் 365 வருடங்கள் வாழ்ந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ஏனோக்கு இறைவனுடன் நெருங்கிய உறவுடன் அர்ப்பணிப்போடு வாழ்ந்தான்; இறைவன் அவனை எடுத்துக்கொண்டதனால், அதன்பின் அவன் காணப்படவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","மெத்தூசலா தனது 187 வயதில் லாமேக்குக்குத் தகப்பனானான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","லாமேக்கு பிறந்த பிறகு மெத்தூசலா 782 வருடங்கள் வாழ்ந்து, இன்னும் பல மகன்களையும் மகள்களையும் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","மெத்தூசலா மொத்தம் 969 வருடங்கள் வாழ்ந்தபின் இறந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","லாமேக்கு தனது 182 வயதில் ஒரு மகனுக்குத் தகப்பனானான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","அவன், “யெகோவா சபித்த நிலத்தில் நாம் பாடுபட்டு உழைக்கும்போது, இவன் நமக்கு ஆறுதலாயிருப்பான்” என்று சொல்லி, அவனுக்கு நோவா என்று பெயரிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","நோவா பிறந்த பிறகு, லாமேக்கு 595 வருடங்கள் வாழ்ந்து, இன்னும் பல மகன்களையும் மகள்களையும் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","லாமேக்கு மொத்தம் 777 வருடங்கள் வாழ்ந்தபின் இறந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","நோவாவுக்கு 500 வயதான பின்பு சேம், காம், யாப்பேத் என்னும் மகன்களுக்குத் தகப்பனானான். ");
INSERT INTO tamtcv_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","பூமியில் மனிதர் பெருகத் தொடங்கியபோது, அவர்களுக்கு மகள்கள் பிறந்தார்கள்; ");
INSERT INTO tamtcv_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","இறைவனின் மகன்கள் எனப்பட்டவர்கள் மனிதர்களுடைய மகள்கள் அழகுள்ளவர்களென்று கண்டு, அவர்களுக்குள் தாங்கள் விரும்பியவர்களைத் திருமணம் செய்துகொண்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","அப்பொழுது யெகோவா, “என்னுடைய ஆவி என்றைக்கும் மனிதரோடு போராடுவதில்லை, அவர்கள் அழிவுக்குரிய மாம்சமே; அவர்களின் வாழ்நாள் நூற்று இருபது வருடங்களே” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","அதே நாட்களில், நெபிலிம் என்னும் இராட்சதர்கள் பூமியில் இருந்தார்கள்; இறைவனின் மகன்கள் எனப்பட்டவர்கள் மனுக்குலப் பெண்களுடன் உறவுகொண்டு பிள்ளைகளைப் பெற்ற காலத்தில் அவர்கள் இருந்தார்கள். அதற்கு பின்பும் அவர்கள் இருந்தார்கள். அவர்களே முற்காலத்தில் புகழ்பெற்ற மனிதரான மாவீரர்களாய் இருந்தவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","பூமியில் மனிதனின் கொடுமைகள் எவ்வளவாய்ப் பெருகியிருக்கின்றன என்பதையும், அவன் எப்பொழுதும் தன் இருதய சிந்தனைகள் ஒவ்வொன்றிலும் தீமையின் பக்கம் மட்டுமே சாய்கிறான் என்பதையும் யெகோவா கண்டார். ");
INSERT INTO tamtcv_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","அதனால் யெகோவா பூமியில் மனிதனை உண்டாக்கியதைக் குறித்து வருத்தப்பட்டார்; அவருடைய இருதயம் வேதனையால் நிறைந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","அப்பொழுது யெகோவா, “நான் படைத்த இந்த மனுக்குலத்தைப் பூமியிலிருந்து அழித்துவிடுவேன்; மனிதரோடு விலங்குகளையும், நிலத்தில் ஊரும் உயிரினங்களையும், ஆகாயத்துப் பறவைகளையும் அழித்துப்போடுவேன்; அவர்களை உண்டாக்கியதைக் குறித்து எனக்கு மனவேதனையாக இருக்கிறது” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","ஆனால் நோவாவுக்கு யெகோவாவினுடைய பார்வையில் தயவு கிடைத்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","நோவாவின் வம்சவரலாறு இதுவே: நோவா நீதியான மனிதனும் தன் காலத்தில் வாழ்ந்த மக்களில் குற்றமற்றவனுமாய் இருந்தான்; அவன் இறைவனுடன் நெருங்கிய உறவுடன் அர்ப்பணிப்போடு வாழ்ந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","நோவாவுக்கு சேம், காம், யாப்பேத் என்னும் மூன்று மகன்கள் இருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","பூமி, இறைவனின் பார்வையில் சீர்கெட்டதாகவும் வன்முறையால் நிறைந்ததாகவும் இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","பூமியில் உள்ள மனிதர் எல்லோரும் சீர்கெட்ட வழியில் நடந்ததால், பூமி எவ்வளவாய் சீர்கெட்டுவிட்டது என்று இறைவன் கண்டார். ");
INSERT INTO tamtcv_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","எனவே இறைவன் நோவாவிடம், “நான் எல்லா உயிரினங்களையும் அழிக்க முடிவு செய்துள்ளேன். ஏனெனில், பூமி மனிதர்களின் வன்முறையால் நிறைந்துவிட்டது. அதனால் நான் அவர்களையும் பூமியையும் நிச்சயமாய் அழிக்கப்போகிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","ஆகவே நீ கொப்பேர் மரத்தால் ஒரு பேழையைச் செய்து, அதில் அறைகளை அமைத்து அதன் உட்புறமும், வெளிப்புறமும் நிலக்கீல் பூசு. ");
INSERT INTO tamtcv_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","அந்தப் பேழையைச் செய்யவேண்டிய விதம்: நீளம் முந்நூறு முழமாகவும், அகலம் ஐம்பது முழமாகவும், உயரம் முப்பது முழமாகவும் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","பேழையின் மேல்தட்டிலிருந்து ஒரு முழம் உயரத்தில் அதற்கு ஒரு கூரையைச் செய், பேழையின் ஒரு பக்கத்தில் கதவு ஒன்றை வை; பேழையில் கீழ்த்தளம், நடுத்தளம், மேல்தளம் ஆகியவற்றை அமைத்துக்கொள். ");
INSERT INTO tamtcv_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","வானத்தின் கீழுள்ள எல்லா உயிர்களையும், அதாவது உயிர்மூச்சுள்ள உயிரினங்கள் எல்லாவற்றையும் அழிப்பதற்கு, நான் பூமியின்மேல் பெருவெள்ளத்தைக் கொண்டுவரப் போகிறேன். அதனால் பூமியிலுள்ள எல்லாமே அழிந்துபோகும். ");
INSERT INTO tamtcv_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","ஆனால், நான் என் உடன்படிக்கையை உன்னுடன் நிலைநிறுத்துவேன்; நீ பேழைக்குள் செல்வாய்; உன்னுடன் உன் மகன்கள், உன் மனைவி, உன் மகன்களின் மனைவிகள் ஆகியோரை அழைத்துக்கொண்டு பேழைக்குள் செல். ");
INSERT INTO tamtcv_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","உயிரினங்கள் எல்லாவற்றிலும் ஆணும் பெண்ணுமாக ஒவ்வொரு வகையிலும், ஒரு ஜோடியை உன்னுடன் சேர்ந்து உயிர்வாழும்படி பேழைக்குள் அழைத்துச் செல். ");
INSERT INTO tamtcv_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","பறவைகளின் ஒவ்வொரு வகையிலும் ஒவ்வொரு ஜோடியும், விலங்குகளில் ஒவ்வொரு வகையிலும் ஒவ்வொரு ஜோடியும், நிலத்தில் ஊர்வனவற்றின் ஒவ்வொரு வகையிலும் ஒவ்வொரு ஜோடியும் உயிருடன் வாழும்படி உன்னுடன் வரும். ");
INSERT INTO tamtcv_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","சாப்பிடக்கூடிய எல்லா வகையான உணவுப் பொருட்களையும் உன்னுடன் எடுத்துச்செல்ல வேண்டும். உனக்கும் அவற்றுக்கும் உணவாகும்படி இவற்றைச் சேமித்து வை” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","இறைவன் தனக்குக் கட்டளையிட்டபடியே நோவா எல்லாவற்றையும் செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","அதன்பின் யெகோவா நோவாவிடம், “நீயும் உன் முழுக் குடும்பமும் பேழைக்குள் போங்கள், ஏனெனில், உன்னையே நான் இந்த சந்ததியில் நீதியானவனாகக் கண்டேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","மேலும், நீ சுத்தமான விலங்குகளில் ஒவ்வொரு வகையிலுமிருந்து ஆணும் பெண்ணுமாக ஏழு ஜோடிகளையும், சுத்தமில்லாத விலங்குகளில் ஒவ்வொரு வகையிலுமிருந்து ஆணும் பெண்ணுமாக ஒரு ஜோடியையும், ");
INSERT INTO tamtcv_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","பறவைகளில் ஒவ்வொரு வகையிலுமிருந்து ஆணும் பெண்ணுமாக ஏழு ஜோடிகளையும் உன்னுடன் எடுத்துக்கொள்; ஏனெனில் பூமி முழுவதிலும் அவைகளின் பல்வேறு வகைகள் தொடர்ந்து உயிர் வாழவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","இன்னும் ஏழு நாட்களில், நாற்பது இரவுகளும் நாற்பது பகல்களும் தொடர்ந்து பூமியின்மேல் மழையை அனுப்பி, நான் உண்டாக்கிய எல்லா உயிரினங்களையும் பூமியின் மேற்பரப்பிலிருந்து அழித்துப்போடுவேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","யெகோவா தனக்குக் கட்டளையிட்ட எல்லாவற்றையும் நோவா செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","பூமியின்மேல் பெருவெள்ளம் உண்டானபோது, நோவாவுக்கு 600 வயதாய் இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","பெருவெள்ளத்துக்குத் தப்பும்படி நோவாவும், அவன் மனைவியும், அவனுடைய மகன்களும், அவர்களின் மனைவிமாரும் பேழைக்குள் போனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","சுத்தமானதும், அசுத்தமானதுமான மிருகங்கள், பறவைகள், நிலத்தில் ஊரும் உயிரினங்கள் யாவும் ஜோடி ஜோடியாக, ");
INSERT INTO tamtcv_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","இறைவன் நோவாவுக்குக் கட்டளையிட்டபடியே, ஆணும் பெண்ணுமாக நோவாவிடம் வந்து பேழைக்குள் சென்றன. ");
INSERT INTO tamtcv_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ஏழு நாட்களுக்குப்பின், பூமியின்மேல் பெருவெள்ளம் வந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","நோவாவுக்கு 600 வயதான அந்த வருடம், இரண்டாம் மாதம், பதினேழாம் நாள் பூமியின் அதிக ஆழத்திலிருந்த ஊற்றுகள் எல்லாம் வெடித்துப் பீறிட்டன; வானத்தின் மதகுகளும் திறக்கப்பட்டன. ");
INSERT INTO tamtcv_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","நாற்பது பகல்களும் நாற்பது இரவுகளும் பூமியில் அடைமழை பெய்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","மழை தொடங்கிய அன்றே நோவாவும், அவன் மனைவியும், சேம், காம், யாப்பேத் என்னும் அவனுடைய மகன்களும், அவர்களுடைய மனைவிமாரும் பேழைக்குள் போனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","எல்லாவித காட்டு மிருகங்களும் அதினதின் வகைகளின்படியும், எல்லாவித வளர்ப்பு மிருகங்களும் அதினதின் வகைகளின்படியும், தரையில் ஊரும் எல்லாவித உயிரினங்களும் அதினதின் வகைகளின்படியும், எல்லாவித பறவைகளும் அதினதின் வகைகளின்படியும், சிறகுகளுடைய யாவும் அவர்களோடு இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","பூமியிலுள்ள உயிர்மூச்சுள்ள எல்லா உயிரினங்களும் ஜோடி ஜோடியாக நோவாவிடம் வந்து பேழைக்குள் சென்றன. ");
INSERT INTO tamtcv_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","இறைவன் நோவாவுக்குக் கட்டளையிட்டபடியே, உட்சென்ற எல்லா விலங்குகளும் ஒவ்வொரு உயிரினத்தையும் சேர்ந்த ஆணும் பெண்ணுமாகவே இருந்தன. யெகோவா நோவாவை உள்ளேவிட்டுக் கதவை அடைத்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","வெள்ளம் நாற்பது நாட்களாகப் பூமியின்மேல் பெருகிக்கொண்டே இருந்தது, வெள்ளம் பெருகியபோது அது பேழையை நிலத்திற்கு மேலாக உயர்த்தியது. ");
INSERT INTO tamtcv_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","பூமியின்மேல் வெள்ளம் உயர்ந்து, பேழை நீரின்மேல் மிதந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","வெள்ளம் பூமியின்மேல் அதிகமாய்ப் பெருகியதால், வானத்தின் கீழுள்ள உயர்ந்த மலைகளெல்லாம் மூடப்பட்டன. ");
INSERT INTO tamtcv_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","வெள்ளம் மலைகளுக்கு மேலாக பதினைந்து முழத்திற்கு மேல் உயர்ந்து அவைகளை மூடியது. ");
INSERT INTO tamtcv_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","அப்பொழுது பூமியில் நடமாடிய பறவைகள், காட்டு மிருகங்கள், வளர்ப்பு மிருகங்கள் ஆகிய எல்லா உயிரினங்களும், பூமியில் கூட்டமாய்த் திரியும் எல்லா பிராணிகளும் அழிந்துபோயின; அத்துடன் மனுக்குலம் முழுவதும் அழிந்துபோனது. ");
INSERT INTO tamtcv_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","நிலத்தில் வாழ்ந்த தங்களது நாசியில் உயிர்மூச்சுள்ள யாவும் மாண்டுபோயின. ");
INSERT INTO tamtcv_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","பூமியிலிருந்த எல்லா உயிரினங்களும் அழிக்கப்பட்டன; மனிதர்களுடன், மிருகங்கள், தரையில் ஊரும் உயிரினங்கள், ஆகாயத்துப் பறவைகள் ஆகிய எல்லாமே பூமியிலிருந்து அழிக்கப்பட்டன. நோவாவும் அவனுடன் பேழைக்குள் இருந்தவர்களும் மாத்திரம் உயிர் தப்பினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","பெருவெள்ளம் நூற்று ஐம்பது நாட்களாக பூமியை மூடியிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","இறைவன் நோவாவையும், பேழைக்குள் அவனுடன் இருந்த காட்டு மிருகங்களையும், வளர்ப்பு மிருகங்களையும் நினைவுகூர்ந்தார்; அவர் பூமிக்கு மேலாக ஒரு காற்றை அனுப்பினார், அப்பொழுது வெள்ளம் வற்றத் தொடங்கியது. ");
INSERT INTO tamtcv_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","நிலத்தின் ஆழத்திலிருந்த நீரூற்றுக்களும், வானத்தின் மதகுகளும் மூடப்பட்டன. வானத்திலிருந்து மழை பெய்வது நின்றுபோயிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","படிப்படியாக தண்ணீர் வற்றத் தொடங்கியது. நூற்று ஐம்பது நாட்களுக்குப்பின் தண்ணீர் மட்டம் குறைந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ஏழாம் மாதம் பதினேழாம் நாள் பேழை அரராத் என்னும் மலையின்மேல் தங்கியது. ");
INSERT INTO tamtcv_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","பத்தாம் மாதம்வரை தொடர்ந்து வெள்ளம் வற்றிக்கொண்டிருந்தது. பத்தாம் மாதம் முதலாம் நாள் மலைகளின் உச்சிகள் தெரிந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","அதிலிருந்து நாற்பது நாட்கள் சென்றபின், நோவா பேழையில் தான் செய்திருந்த ஜன்னலைத் திறந்து, ");
INSERT INTO tamtcv_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ஒரு காகத்தை வெளியே அனுப்பினான், அது தரையில் தண்ணீர் வற்றும்வரை போவதும் வருவதுமாய் இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","பின்பு அவன் நிலத்தின் மேலிருந்து தண்ணீர் வற்றிவிட்டதோ என்று பார்க்கும்படி ஒரு புறாவை அனுப்பினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","பூமியின் மேற்பரப்பெங்கும் வெள்ளமாய் இருந்தபடியால், அதற்கு காலூன்றி நிற்க இடம் இருக்கவில்லை; எனவே அது பேழைக்குத் திரும்பி நோவாவிடம் வந்தது. அவன் தன் கையை நீட்டிப் புறாவைப் பிடித்து, பேழைக்குள் தன்னிடம் எடுத்துக்கொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","அவன் மேலும் ஏழு நாட்கள் பொறுத்திருந்து, திரும்பவும் பேழையிலிருந்து புறாவை வெளியே அனுப்பினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","அன்று மாலையில் அந்தப் புறா அவனிடத்தில் திரும்பிவந்தபோது, அதன் அலகில் புதிதாகக் கொத்தியெடுத்த ஒலிவ இலையொன்று இருந்தது. அதனால் பூமியில் தண்ணீர் வற்றிவிட்டது என்று நோவா அறிந்துகொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","அவன் மேலும் ஏழு நாட்கள் பொறுத்திருந்து புறாவை மறுபடியும் வெளியே அனுப்பினான், ஆனால் இம்முறை அது அவனிடம் திரும்பி வரவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","நோவாவுக்கு 601 வயதாகிய வருடத்தின் முதலாம் மாதம் முதலாம் நாள் நிலத்தின் மேலிருந்து தண்ணீர் வற்றிவிட்டது. நோவா பேழையின் மேல்தட்டு மூடியைத் திறந்து பார்த்தான், நிலம் உலர்ந்திருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","இரண்டாம் மாதம் இருபத்தி ஏழாம்நாளில் பூமி முழுவதும் காய்ந்து போயிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","அப்பொழுது இறைவன் நோவாவிடம், ");
INSERT INTO tamtcv_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“நீ உன் மனைவியுடனும், உன் மகன்களுடனும் அவர்களுடைய மனைவிகளுடனும் பேழையைவிட்டு வெளியே வா. ");
INSERT INTO tamtcv_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","உன்னுடன் இருக்கும் எல்லா விதமான உயிரினங்களாகிய பறவைகள், விலங்குகள், தரையில் ஊரும் உயிரினங்கள் ஆகிய எல்லாவற்றையும் வெளியே கொண்டுவா. அவை பூமியில் பலுகி, எண்ணிக்கையில் பெருகட்டும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","அப்படியே நோவா தன்னுடைய மகன்களோடும், தன் மனைவியோடும், மகன்களின் மனைவிகளோடும் வெளியே வந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","எல்லா மிருகங்களும், தரையில் ஊரும் எல்லா உயிரினங்களும், எல்லா பறவைகளும் பூமியில் நடமாடும் உயிரினங்கள் அனைத்தும் வகை வகையாகப் பேழையிலிருந்து வெளியே வந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","அப்பொழுது நோவா யெகோவாவுக்கு ஒரு பலிபீடத்தைக் கட்டி, அதன்மேல் அவன் சுத்தமான மிருகங்கள், சுத்தமான பறவைகள் எல்லாவற்றிலுமிருந்து சிலவற்றைத் தகன காணிக்கைகளாகப் பலியிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","மகிழ்ச்சியூட்டும் அந்த நறுமணத்தை யெகோவா முகர்ந்து, தன் உள்ளத்தில் சொல்லிக் கொண்டதாவது: “மனிதனின் இருதயமோ பிள்ளைப் பருவத்திலிருந்தே, தீமையில்தான் நாட்டம் கொண்டிருக்கிறது; ஆனாலும், மனிதனின் நிமித்தம் நான் இனி ஒருபோதும் நிலத்தைச் சபிக்கமாட்டேன்.” இப்பொழுது செய்ததுபோல், இனி ஒருபோதும் உயிரினங்கள் எல்லாவற்றையும் அழிக்கமாட்டேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“விதைப்பும் அறுப்பும், குளிரும் வெப்பமும், கோடைகாலமும் குளிர்காலமும், இரவும் பகலும் பூமி நிலைத்திருக்கும்வரை இனி ஒருபோதும் ஒழியாது.” ");
INSERT INTO tamtcv_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","பின்பு இறைவன் நோவாவையும் அவன் மகன்களையும் ஆசீர்வதித்து சொன்னதாவது, “நீங்கள் பலுகி, எண்ணிக்கையில் பெருகி பூமியை நிரப்புங்கள்.” ");
INSERT INTO tamtcv_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","உங்களைப்பற்றிய பயமும், பீதியும் பூமியிலுள்ள எல்லா விலங்குகளுக்கும், ஆகாயத்துப் பறவைகளுக்கும், தரையில் ஊரும்பிராணிகளுக்கும், கடல்வாழ் மீன்களுக்கும் இருக்கும்; அவை உங்கள் அதிகாரத்தின்கீழ் கொடுக்கப்பட்டிருக்கிறது. ");
INSERT INTO tamtcv_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","நடமாடும் உயிரினங்கள் யாவும் உங்களுக்கு உணவாகும். தாவரங்களை உங்களுக்கு உணவாகக் கொடுத்ததுபோல, இப்பொழுது இவை எல்லாவற்றையும் உங்களுக்கு உணவாகக் கொடுக்கிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“ஆனாலும், இறைச்சியை அதன் உயிருள்ளபோது அதாவது இரத்தம் அதில் இருக்கும்போது சாப்பிடவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","உங்கள் உயிராகிய இரத்தத்திற்கு நான் நிச்சயமாக ஈடு கேட்பேன். ஒவ்வொரு மிருகத்திடமும் ஒவ்வொரு மனிதரிடமும் ஈடு கேட்பேன். மனிதரின் உயிருக்காக அவர்களோடிருக்கும் சக மனிதரிடம் உயிரை நான் ஈடாகக் கேட்பேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“யாராவது மனித இரத்தத்தைச் சிந்தினால், அவர்களுடைய இரத்தமும் மனிதராலேயே சிந்தப்பட வேண்டும்; ஏனெனில், இறைவன் மனிதரை இறைவனின் சாயலிலேயே படைத்திருக்கிறார். ");
INSERT INTO tamtcv_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","நீங்களோ, இனவிருத்தியில் பெருகி எண்ணிக்கையில் அதிகரியுங்கள்; பூமியில் பெருகி, விருத்தியடையுங்கள்.” ");
INSERT INTO tamtcv_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","பின்பு இறைவன் நோவாவிடமும், அவனுடனிருந்த அவன் மகன்களிடமும்: ");
INSERT INTO tamtcv_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“நான் உங்களுடனும், உங்களுக்குப் பின்வரும் உங்கள் சந்ததியுடனும் இப்பொழுது என்னுடைய உடன்படிக்கையை ஏற்படுத்துகிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","உங்களுடன் பேழையிலிருந்து வெளியேறிய உயிரினங்களான பறவைகள், வளர்ப்பு மிருகங்கள், காட்டு மிருகங்கள் ஆகிய பூமியின் எல்லா உயிரினங்களுடனும் என் உடன்படிக்கையை ஏற்படுத்துகிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","‘வெள்ளத்தினால் இனி ஒருபோதும் எல்லா உயிர்களும் அழிக்கப்படமாட்டாது; பூமியை அழிக்க இனி ஒருபோதும் வெள்ளப்பெருக்கு உண்டாகாது’ என்று உங்களோடு என் உடன்படிக்கையை ஏற்படுத்துகிறேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","மேலும் இறைவன், “நான் உங்களோடும், உங்களோடிருக்கும் எல்லா உயிரினங்களோடும், வரப்போகும் எல்லா சந்ததிகளோடும் ஏற்படுத்தும் உடன்படிக்கையின் அடையாளம் இதுவே: ");
INSERT INTO tamtcv_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","நான், என் வானவில்லை மேகங்களில் அமைத்திருக்கிறேன், பூமிக்கும் எனக்கும் இடையிலான உடன்படிக்கையின் அடையாளம் இதுவே. ");
INSERT INTO tamtcv_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","நான் பூமிக்கு மேலாக மேகங்களை வரப்பண்ணுகையில், அம்மேகங்களில் வானவில் தோன்றும்போதெல்லாம், ");
INSERT INTO tamtcv_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","உங்களோடும் எல்லாவித உயிரினங்களோடும் நான் செய்துகொண்ட என் உடன்படிக்கையை நினைவுகூருவேன். இனி ஒருபோதும் எல்லா உயிர்களையும் அழிக்கும்படி தண்ணீர் வெள்ளமாய் பெருகாது. ");
INSERT INTO tamtcv_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","மேகங்களில் வானவில் தோன்றும்போதெல்லாம் நான் அதைப் பார்த்து, இறைவனுக்கும் பூமியிலுள்ள எல்லாவித உயிரினங்களுக்கும் இடையே உள்ள நித்திய உடன்படிக்கையை நினைவுகூருவேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","இப்படியாக இறைவன் நோவாவிடம், “எனக்கும் பூமியிலுள்ள எல்லா உயிர்களுக்கும் இடையே நான் ஏற்படுத்திய உடன்படிக்கையின் அடையாளம் இதுவே” என்று சொன்னார். ");
INSERT INTO tamtcv_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","பேழையிலிருந்து வெளியேறிய நோவாவின் மகன்கள் சேம், காம், யாப்பேத் என்பவர்களாவர். காம் கானானின் தகப்பன். ");
INSERT INTO tamtcv_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","நோவாவின் மூன்று மகன்கள் இவர்களே; இவர்களிலிருந்தே பூமி எங்கும் பரந்திருக்கும் மக்கள் வந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","நோவா நிலத்தைப் பயிரிடுகிறவனாகி, திராட்சைத் தோட்டமொன்றை உண்டாக்கத் தொடங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","அவன் ஒரு நாள் தோட்டத்தின் திராட்சை இரசத்தைக் குடித்து, வெறிகொண்டு, தன் கூடாரத்தினுள்ளே உடை விலகிய நிலையில் கிடந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","அப்பொழுது கானானின் தகப்பனான காம், தன் தகப்பனின் நிர்வாணத்தைக் கண்டு, வெளியே போய் தன் இரு சகோதரருக்கும் அதைத் தெரியப்படுத்தினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","ஆனால் சேமும் யாப்பேத்தும் ஓர் உடையை எடுத்துத் தம் இருவர் தோளிலும் போட்டவாறு, பின்னிட்டுச் சென்று தங்கள் தகப்பனின் நிர்வாணத்தை மூடினார்கள். அவர்கள் தங்கள் தகப்பனின் நிர்வாணத்தைக் காணாதபடிக்குத் தங்கள் முகங்களை மறுபக்கமாகத் திருப்பிக்கொண்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","நோவா வெறி தெளிந்து எழுந்தபோது, தன் இளையமகன் தனக்குச் செய்ததை அறிந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","எனவே அவன், “கானான் சபிக்கப்படட்டும்! அவன் தன் சகோதரர்களிலும் அடிமைகளிலும் கீழ்ப்பட்டவனாய் இருக்கட்டும்.” ");
INSERT INTO tamtcv_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","மேலும் நோவா சொன்னதாவது: “சேமின் இறைவனாகிய யெகோவாவுக்குத் துதி உண்டாவதாக! கானான் சேமுக்கு அடிமையாய் இருப்பானாக. ");
INSERT INTO tamtcv_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","இறைவன் யாப்பேத்தின் எல்லையை விரிவுபடுத்துவாராக; யாப்பேத் சேமின் கூடாரங்களில் குடியிருப்பானாக, கானான் யாப்பேத்துக்கு அடிமையாய் இருப்பானாக.” ");
INSERT INTO tamtcv_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","பெருவெள்ளத்திற்கு பிறகு நோவா முந்நூற்று ஐம்பது வருடங்கள் வாழ்ந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","நோவா மொத்தம் 950 வருடங்கள் வாழ்ந்தபின் இறந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","பெருவெள்ளத்திற்கு பிறகு நோவாவின் மகன்களாகிய சேம், காம், யாப்பேத் என்பவர்களுக்கு, பிறந்த மகன்களின் வம்சவரலாறு. ");
INSERT INTO tamtcv_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","யாப்பேத்தின் மகன்கள்: கோமர், மாகோகு, மாதாய், யாவான், தூபால், மேசேக்கு, தீராஸ். ");
INSERT INTO tamtcv_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","கோமரின் மகன்கள்: அஸ்கினாஸ், ரீப்பாத்து, தொகர்மா. ");
INSERT INTO tamtcv_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","யாவானின் மகன்கள்: எலீஷா, தர்ஷீஸ், கித்தீம், தொதானீம். ");
INSERT INTO tamtcv_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","இவர்களிலிருந்து கடற்கரை ஓரங்களில் வசிக்கும் மக்கள், தங்கள் வம்சங்களின்படியே, அவரவருக்குரிய சொந்த மொழிகளுடன், தங்கள் பிரதேசங்களுக்குள் பரவினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","காமின் மகன்கள்: கூஷ், மிஸ்ராயீம், பூத், கானான். ");
INSERT INTO tamtcv_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","கூஷின் மகன்கள்: சேபா, ஆவிலா, சப்தா, ராமா, சப்திகா. ராமாவின் மகன்கள்: சேபா, திதான். ");
INSERT INTO tamtcv_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","கூஷின் மகன் நிம்ரோத்; இவன் பூமியில் வலிமையுள்ள வீரனாக விளங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","அவன் யெகோவாவின் பார்வையில் மிகவும் வலிமைவாய்ந்த வேட்டைக்காரனாய் இருந்தான்; அதனால்தான், “யெகோவா முன்னிலையில் வலிமையுள்ள வேட்டைக்காரன் நிம்ரோதைப்போல்” என்ற வழக்கச்சொல் உண்டாயிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","சிநெயார் நாட்டிலுள்ள பாபேல், ஏரேக், அக்காத், கல்னே ஆகிய இடங்களே அவனுடைய அரசாட்சியின் முக்கிய இடங்களாயிருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","அவன் அந்நாட்டிலிருந்து அசீரியாவுக்குப் போய், அங்கே நினிவே, ரெகொபோத் ஈர், காலாகு என்னும் பட்டணங்களைக் கட்டினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","நினிவேக்கும், காலாகுக்கும் இடையில் ரெசேன் பட்டணத்தையும் கட்டினான்; இது பிரதான நகரம். ");
INSERT INTO tamtcv_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","மிஸ்ராயீமின் சந்ததிகள்: லூதீமியர், ஆனாமியர், லெகாபியர், நப்தூகியர், ");
INSERT INTO tamtcv_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","பத்ரூசீயர், பெலிஸ்தியரின் சந்ததிக்கு தலைவனான கஸ்லூகியர், கப்தோரியர். ");
INSERT INTO tamtcv_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","கானானின் சந்ததிகள்: மூத்த மகன் சீதோன், கேத்து, ");
INSERT INTO tamtcv_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","எபூசியர், எமோரியர், கிர்காசியர், ");
INSERT INTO tamtcv_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ஏவியர், அர்கீயர், சீனியர், ");
INSERT INTO tamtcv_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","அர்வாதியர், செமாரியர், காமாத்தியர். பின்பு கானானிய வம்சத்தினர் பல இடங்களிலும் குடியேறினர். ");
INSERT INTO tamtcv_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","கானானியரின் எல்லை சீதோன் முதல் கேரார் வழியாகக் காசாவரைக்கும், பின்பு சோதோம், கொமோரா, அத்மா, செபோயீம் வழியாக லாசாவரைக்கும் பரந்திருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","அவரவர் வம்சங்களின்படியும், மொழிகளின்படியும், தங்கள் நாடுகளுக்குள்ளும் எல்லைகளுக்குள்ளும் குடியிருந்த காமின் மகன்கள் இவர்களே. ");
INSERT INTO tamtcv_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","சேமுக்கு மகன்கள் பிறந்தார்கள், அவனுடைய மூத்த சகோதரன் யாப்பேத்; சேம் ஏபேரின் மகன்கள் எல்லாருக்கும் முற்பிதாவாய் இருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","சேமின் மகன்கள்: ஏலாம், அசூர், அர்பக்சாத், லூத், ஆராம். ");
INSERT INTO tamtcv_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","ஆராமின் மகன்கள்: ஊத்ஸ், கூல், கேத்தெர், மாஸ். ");
INSERT INTO tamtcv_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","அர்பக்சாத் சேலாவின் தகப்பன், சேலா ஏபேரின் தகப்பன். ");
INSERT INTO tamtcv_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ஏபேருக்கு இரண்டு மகன்கள் பிறந்தார்கள். ஒருவன் பெயர் பேலேகு, ஏனெனில், அவன் காலத்தில் பூமியிலுள்ள மக்கள் வெவ்வேறு மொழி குழுக்களாக பிரிக்கப்பட்டனர்; அவனுடைய சகோதரன் பெயர் யொக்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","யொக்தான் என்பவன், அல்மோதாத், செலேப், அசர்மாவேத், யேராகு, ");
INSERT INTO tamtcv_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","அதோராம், ஊசால், திக்லா, ");
INSERT INTO tamtcv_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ஓபால், அபிமாயேல், சேபா, ");
INSERT INTO tamtcv_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ஓப்பீர், ஆவிலா, யோபாப் ஆகியோரின் தகப்பன். இவர்களே யொக்தானின் மகன்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","இவர்கள் குடியிருந்த பிரதேசம் மேசாவிலிருந்து, கிழக்கு மலைப் பகுதியிலுள்ள செப்பார்வரை பரவியிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","அவரவர் வம்சங்களின்படியும், மொழிகளின்படியும் தங்கள் பிரதேசங்களிலும் நாடுகளிலும் வாழ்ந்த சேமுடைய சந்ததியினர் இவர்களே. ");
INSERT INTO tamtcv_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","தங்கள் நாடுகளிலுள்ள நோவாவுடைய மகன்களின் வழிவந்த குடும்பவாரியான வம்சங்களின் சந்ததிகள் இவையே. இவர்களிலிருந்தே பெருவெள்ளத்திற்கு பிறகு பூமியெங்கும் நாடுகள் பரவின. ");
INSERT INTO tamtcv_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","அக்காலத்தில் முழு உலகமும் ஒரே மொழியையும், பொதுவான ஒரே பேச்சு வழக்கையும் உடையதாய் இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","மக்கள் கிழக்குநோக்கி இடம்பெயர்ந்து சென்றபோது, சிநெயார் நாட்டிலே ஒரு சமவெளியைக் கண்டு, அங்கே குடியேறினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","அங்கே அவர்கள், “நாம் செங்கல் செய்து, அவற்றை நன்றாகச் சுடுவோம் வாருங்கள்” என்று ஒருவரோடு ஒருவர் பேசிக்கொண்டார்கள். அவர்கள் கல்லுக்குப் பதிலாகச் செங்கல்லையும், சாந்துக்குப் பதிலாக நிலக்கீலையும் உபயோகித்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","பின்னும் அவர்கள், “வாருங்கள், நாம் வானத்தைத் தொடும்படியான கோபுரத்தைக் கொண்ட ஒரு பட்டணத்தைக் கட்டுவோம்; அதனால் நமக்குப் புகழ் உண்டாகும்படி செய்து, நாம் பூமியெங்கிலும் சிதறிப் போகாமல் இருப்போம்” என்றும் சொல்லிக்கொண்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","மனிதர் கட்டிக்கொண்டிருந்த நகரத்தையும் கோபுரத்தையும் பார்க்க, யெகோவா இறங்கி வந்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","யெகோவா, “அவர்கள் ஒரே மொழி பேசும் ஒரே மக்களாய் இருப்பதால் இதைச் செய்யத்தொடங்கி இருக்கிறார்கள்; ஆகவே அவர்கள் திட்டமிடும் எதையும் அவர்களால் செய்யமுடியாமல் போகாது. ");
INSERT INTO tamtcv_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","ஆதலால் நாம் அங்கே இறங்கிப்போய், ஒருவர் பேசுவதை மற்றவர் விளங்கிக்கொள்ளாதபடி, அவர்களுடைய மொழியைக் குழப்பிவிடுவோம் வாருங்கள்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","அப்படியே யெகோவா அவர்களை அங்கிருந்து பூமியெங்கும் சிதறப்பண்ணி, அவர்கள் பட்டணத்தைக் கட்டுவதை நிறுத்தினார். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","முழு உலகத்தினுடைய மொழியையும் யெகோவா குழப்பினபடியால், அந்த இடம் பாபேல் என்று அழைக்கப்பட்டது. யெகோவா அங்கிருந்து அவர்களைப் பூமியெங்கும் சிதறப்பண்ணினார். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","சேமின் வம்சவரலாறு இதுவே: பெருவெள்ளம் ஏற்பட்டு இரண்டு வருடங்கள் சென்றபின், சேம் 100 வயதாய் இருக்கும்போது, அர்பக்சாத்தைப் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","அர்பக்சாத் பிறந்த பிறகு, சேம் 500 வருடங்கள் வாழ்ந்து, இன்னும் வேறு மகன்களையும் மகள்களையும் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","அர்பக்சாத் 35 வயதாய் இருக்கும்போது, சேலாவைப் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","சேலா பிறந்த பிறகு அர்பக்சாத் 403 வருடங்கள் வாழ்ந்து, இன்னும் வேறு மகன்களையும் மகள்களையும் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","சேலா 30 வயதாய் இருக்கும்போது, ஏபேரைப் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ஏபேர் பிறந்த பிறகு, சேலா 403 வருடங்கள் வாழ்ந்து, இன்னும் வேறு மகன்களையும் மகள்களையும் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ஏபேர் 34 வயதாய் இருக்கும்போது, பேலேகைப் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","பேலேகு பிறந்த பிறகு, ஏபேர் 430 வருடங்கள் வாழ்ந்து, இன்னும் வேறு மகன்களையும் மகள்களையும் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","பேலேகு 30 வயதாய் இருக்கும்போது ரெகூவைப் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ரெகூ பிறந்த பிறகு, பேலேகு 209 வருடங்கள் வாழ்ந்து இன்னும் வேறு மகன்களையும் மகள்களையும் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","ரெகூ 32 வயதாய் இருக்கும்போது செரூகுவைப் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","செரூகு பிறந்த பிறகு ரெகூ 207 வருடங்கள் வாழ்ந்து, இன்னும் வேறு மகன்களையும் மகள்களையும் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","செரூகு 30 வயதாய் இருக்கும்போது நாகோரைப் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","நாகோர் பிறந்த பிறகு செரூகு 200 வருடங்கள் வாழ்ந்து, இன்னும் வேறு மகன்களையும் மகள்களையும் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","நாகோர் 29 வயதாய் இருக்கும்போது தேராகுவைப் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","தேராகு பிறந்த பிறகு நாகோர் 119 வருடங்கள் வாழ்ந்து, இன்னும் வேறு மகன்களையும் மகள்களையும் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","தேராகு 70 வயதாய் இருக்கும்போது ஆபிராம், நாகோர், ஆரான் என்பவர்களைப் பெற்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","தேராகின் வம்சவரலாறு இதுவே: ஆபிராம், நாகோர், ஆரான் ஆகியோருக்குத் தேராகு தகப்பனானான். ஆரான் லோத்துக்குத் தகப்பனானான். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","தன் தகப்பன் தேராகு உயிரோடிருக்கும்போதே, ஆரான் தனது பிறப்பிடமான கல்தேயர் நாட்டிலுள்ள ஊர் என்னும் இடத்தில் இறந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","ஆபிராமும் நாகோரும் திருமணம் செய்தார்கள். ஆபிராமின் மனைவி சாராய், நாகோரின் மனைவி மில்க்காள்; மில்க்காள் ஆரானின் மகள், ஆரான் மில்க்காள், இஸ்காள் ஆகிய இருவரின் தகப்பன். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","சாராய் குழந்தை இல்லாமல் மலடியாய் இருந்தாள், ஏனெனில் அவளுக்குப் பிள்ளைகள் இல்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","தேராகு, தன் மகன் ஆபிராமையும், ஆரானின் மகனான தன் பேரன் லோத்தையும், ஆபிராமின் மனைவியான தன் மருமகள் சாராயையும், அழைத்துக்கொண்டு கல்தேயரின் நாட்டிலுள்ள ஊர் என்னும் பட்டணத்தைவிட்டு, கானான் நாட்டுக்குப் போகப் புறப்பட்டான். ஆனால் அவர்கள் ஆரான் என்னும் இடத்திற்கு வந்தபோது, அங்கேயே குடியிருந்துவிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","தேராகு 205 வருடங்கள் வாழ்ந்தபின் ஆரானிலே இறந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","யெகோவா ஆபிராமிடம் சொன்னார்: “நீ உன் நாட்டையும், உன் உறவினரையும், உன் தகப்பன் குடும்பத்தாரையும் விட்டு, நான் உனக்குக் காண்பிக்கும் நாட்டிற்குப் போ. ");
INSERT INTO tamtcv_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“நான் உன்னை ஒரு பெரிய நாடாக்குவேன், உன்னை ஆசீர்வதிப்பேன்; உன் பெயரை மேன்மைப்படுத்துவேன், நீ ஆசீர்வாதமாயிருப்பாய். ");
INSERT INTO tamtcv_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","உன்னை ஆசீர்வதிப்பவர்களை நான் ஆசீர்வதிப்பேன், உன்னை சபிக்கும் எவரையும் நான் சபிப்பேன். பூமியின் எல்லா மக்கள் கூட்டங்களும் உன் மூலமாய் ஆசீர்வதிக்கப்படுவார்கள்.” ");
INSERT INTO tamtcv_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","யெகோவா ஆபிராமுக்குச் சொன்னபடியே, ஆபிராம் புறப்பட்டுப் போனான்; லோத்தும் அவனுடன் போனான். ஆபிராம் ஆரானிலிருந்து புறப்படும்போது, அவனுக்கு எழுபத்தைந்து வயதாயிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ஆபிராம் தன் மனைவி சாராய், தன் சகோதரனின் மகன் லோத்து, ஆரான் நாட்டில் தாங்கள் சம்பாதித்தவைகள், தங்களுடன் இருந்த வேலைக்காரர்கள் எல்லாவற்றையும் கூட்டிக்கொண்டு கானான் நாட்டிற்குப் போகப் புறப்பட்டு, அங்கு போய்ச்சேர்ந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ஆபிராம் அந்நாட்டின் வழியாகப் பயணம் செய்து, சீகேமில் உள்ள மோரேயின் கருவாலி மரத்தடிக்கு வந்துசேர்ந்தான். அப்பொழுது கானானியர் அங்கே வசித்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","யெகோவா ஆபிராமுக்குக் காட்சியளித்து, “உன் சந்ததிக்கு நான் இத்தேசத்தைக் கொடுப்பேன்” என்று சொன்னார். அதனால் ஆபிராம் அங்கே தனக்குக் காட்சியளித்த யெகோவாவுக்கு, ஒரு பலிபீடத்தைக் கட்டினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","அவன் அங்கிருந்து பெத்தேலுக்குக் கிழக்கேயுள்ள மலைப்பக்கமாய்ப் போய், பெத்தேல் மேற்கிலும், ஆயி கிழக்கிலும் இருக்கத்தக்கதாக தன் கூடாரத்தை அமைத்தான். அங்கே யெகோவாவுக்கு ஒரு பலிபீடத்தைக் கட்டி, யெகோவாவின் பெயரைக் கூப்பிட்டு வழிபட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","பின்பு ஆபிராம் அங்கிருந்து புறப்பட்டு, நெகேப் என்னும் தென்தேசத்தை நோக்கிச் சென்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","அந்நாட்களில், அந்த நாட்டிலே பஞ்சம் ஏற்பட்டது; பஞ்சம் மிகவும் கொடியதாய் இருந்தபடியால், ஆபிராம் சிலகாலம் எகிப்தில் குடியிருப்பதற்காகப் போனான். ");
INSERT INTO tamtcv_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","அவன் எகிப்தின் அருகே வந்தபோது, தன் மனைவி சாராயிடம், “நீ மிகவும் அழகிய பெண் என்பது எனக்குத் தெரியும். ");
INSERT INTO tamtcv_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","எகிப்தியர் உன்னைக் காணும்போது, ‘இவள் அவனுடைய மனைவி’ என்று சொல்லி, என்னைக் கொன்றுவிடுவார்கள் ஆனால் உன்னையோ உயிரோடு விட்டுவிடுவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","அதனால் நீ, உன்னை என் சகோதரி என்று சொல், அப்பொழுது அவர்கள் உனக்காக என்னை நன்றாக நடத்துவார்கள்; நானும் உன் நிமித்தம் உயிர் தப்புவேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","ஆபிராம் எகிப்திற்கு வந்தபோது, சாராய் மிகவும் அழகானவள் என்பதை எகிப்தியர் கண்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","பார்வோனின் அதிகாரிகள் அவளைக் கண்டதும், அவளுடைய அழகைப்பற்றிப் பார்வோனிடம் புகழ்ந்தார்கள்; அதனால் சாராய் பார்வோனின் அரண்மனைக்குக் கொண்டு செல்லப்பட்டாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","பார்வோன் சாராயின் நிமித்தம் ஆபிராமை நன்றாக நடத்தினான்; ஆபிராம் செம்மறியாடுகளையும், மாடுகளையும், ஆண் பெண் கழுதைகளையும், ஒட்டகங்களையும், வேலைக்காரரையும், வேலைக்காரிகளையும் பெற்றுக்கொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","ஆனால் யெகோவா ஆபிராமின் மனைவி சாராயின் நிமித்தம், பார்வோனையும் அவனுடைய வீட்டாரையும் கொடிய வியாதியால் தாக்கினார். ");
INSERT INTO tamtcv_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","அப்பொழுது பார்வோன் ஆபிராமை அழைத்து, “நீ எனக்கு என்ன செய்துவிட்டாய்? இவள் உன் மனைவி என்று ஏன் எனக்குச் சொல்லவில்லை? ");
INSERT INTO tamtcv_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","‘இவள் என் சகோதரி’ என்று ஏன் எனக்குச் சொன்னாய்? அதனால் அல்லவா அவளை என் மனைவியாக்கிக் கொள்ளும்படி எடுத்தேன்? இதோ, உன் மனைவி; அவளைக் கூட்டிக்கொண்டு போய்விடு!” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","பார்வோன் ஆபிராமைக் குறித்துத் தன் வேலைக்காரருக்கு கட்டளையிட்டான், அவர்கள் அவனை அவன் மனைவியுடனும் அவனுக்குச் சொந்தமான எல்லாவற்றுடனும் அவனை நாட்டிற்கு வெளியே அனுப்பிவிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","ஆகையால், ஆபிராம் தன் மனைவியுடனும் தன் எல்லா உடைமைகளுடனும், எகிப்திலிருந்து நெகேப்புக்குப் போனான்; லோத்தும் அவனுடன் போனான். ");
INSERT INTO tamtcv_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","ஆபிராம் வளர்ப்பு மிருகங்களையும், தங்கத்தையும் வெள்ளியையும் கொண்ட பெரிய செல்வந்தனாக இருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","அவன் நெகேப்பிலிருந்து இடம்விட்டு இடம்பெயர்ந்து பெத்தேலுக்கு வந்து, அங்கே பெத்தேலுக்கும் ஆயிக்கும் இடையில் தான் முன்பு கூடாரம் போட்டிருந்த இடத்துக்கு வந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","அவன் தான் முதலாவதாகப் பலிபீடத்தைக் கட்டியிருந்த இடத்துக்குச் சென்று, அங்கே ஆபிராம் யெகோவாவினுடைய பெயரைக் கூப்பிட்டு வழிபட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","ஆபிராமுடன் பயணம் செய்த லோத்துக்கும் ஆடுமாடுகளும் கூடாரங்களும் இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","அவர்கள் இருவரது உடைமைகளும் ஏராளமாய் இருந்தபடியால், அவர்கள் சேர்ந்து வாழ அங்கிருந்த நிலவளம் போதாமல் இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","அதனால் ஆபிராமின் மந்தை மேய்ப்பர்களுக்கும், லோத்தின் மந்தை மேய்ப்பர்களுக்கும் இடையில் சச்சரவுகள் உண்டாயின. அக்காலத்தில் கானானியரும், பெரிசியரும் அதே நாட்டில் குடியிருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","இதனால் ஆபிராம் லோத்திடம், “எனக்கும் உனக்கும் இடையிலோ அல்லது எனது மந்தை மேய்ப்பருக்கும் உனது மந்தை மேய்ப்பருக்கும் இடையிலோ சச்சரவுகள் வேண்டாம்; ஏனெனில் நாம் நெருங்கிய உறவினர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","இதோ நாடு முழுவதும் உனக்கு முன்பாக இருக்கிறது அல்லவா? நாம் இருவரும் பிரிந்து போவோம். நீ இடது பக்கம் போனால், நான் வலதுபக்கம் போவேன்; நீ வலதுபக்கம் போனால் நான் இடது பக்கம் போவேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","லோத்து சுற்றிலும் பார்த்தபோது, சோவார் வரையுள்ள யோர்தான் சமபூமி முழுவதும் நீர்வளம் நிறைந்திருந்ததைக் கண்டான்; அது யெகோவாவினுடைய தோட்டத்தைப் போலவும், எகிப்து தேசத்தைப் போலவும் இருந்தது. யெகோவா சோதோமையும் கொமோராவையும் அழிக்குமுன் அவ்வாறு இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","எனவே லோத்து, யோர்தான் சமபூமி முழுவதையும் தனக்காகத் தெரிந்துகொண்டு, கிழக்குப் பக்கமாகப் போனான். அவர்கள் இருவரும், ஒருவரைவிட்டு ஒருவர் பிரிந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","ஆபிராம் கானான் நாட்டில் குடியிருந்தான், லோத்து யோர்தான் சமபூமியின் பட்டணங்கள் நடுவில் குடியிருந்து, சோதோமுக்கு அருகே தன் கூடாரங்களைப் போட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","சோதோமின் மனிதர் கொடியவர்களாய், யெகோவாவுக்கு விரோதமாகப் பெரும் பாவம் செய்துகொண்டிருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","லோத்து ஆபிராமைவிட்டுப் பிரிந்தபின் யெகோவா ஆபிராமிடம், “நீ இருக்கிற இடத்திலிருந்து உன் கண்களை உயர்த்தி, வடக்கேயும் தெற்கேயும், கிழக்கேயும் மேற்கேயும் பார். ");
INSERT INTO tamtcv_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","நீ காண்கிற இடம் முழுவதையும், உனக்கும் உன் சந்ததிக்கும் நான் என்றென்றைக்கும் கொடுப்பேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","நான் உன் சந்ததியைப் பூமியின் புழுதியைப்போல் பெருகப்பண்ணுவேன், பூமியின் புழுதியை ஒருவனால் எண்ண முடியுமானால், உன் சந்ததியையும் எண்ணலாம். ");
INSERT INTO tamtcv_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","நீ நாட்டின் நீளமும் அகலமும் எவ்வளவோ அதுவரை நடந்து செல், ஏனெனில் நான் அதை உனக்குத் தருவேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","ஆபிராம் தன் கூடாரங்களைக் கழற்றிக்கொண்டு, எப்ரோனில் இருக்கும் மம்ரேயின் கருவாலி மரங்களின் அருகே குடியிருக்கச் சென்றான். அங்கே அவன் யெகோவாவுக்கு ஒரு பலிபீடத்தைக் கட்டினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","அந்நாட்களில் சிநெயாரின் அரசன் அம்ராப்பேல், ஏலாசாரின் அரசன் அரியோகு, ஏலாமின் அரசன் கெதர்லாகோமேர், கோயீமின் அரசன் திதியால் ");
INSERT INTO tamtcv_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ஆகிய இவர்கள் சோதோமின் அரசன் பேரா, கொமோராவின் அரசன் பிர்சா, அத்மாவின் அரசன் சினாபு, செபோயீமின் அரசன் செமேபர், பேலா என்னும் சோவாரை ஆண்ட அரசன் ஆகியோருடன் யுத்தம்செய்யப் புறப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","இந்த பிந்தைய அரசர்கள், தங்கள் படைகளை உப்புக்கடல் என்னும் சித்தீம் பள்ளத்தாக்கில் ஒன்றுகூடி அணிவகுத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","பன்னிரண்டு வருடங்களாக கெதர்லாகோமேரின் ஆதிக்கத்திற்குள் இருந்த இவர்கள், பதிமூன்றாம் வருடத்தில் அவனை எதிர்த்துக் கலகம் பண்ணினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","பதினாலாவது வருடத்தில், கெதர்லாகோமேரும் அவனுடன் கூட்டுச்சேர்ந்த அரசர்களும் ஒன்றுசேர்ந்து, அஸ்தரோத் கர்னாயீமில் இருந்த ரெப்பாயீமியரையும், காமிலிருந்த சூசிமியரையும், சாவே கீரியாத்தாயீமிலே இருந்த ஏமியரையும், ");
INSERT INTO tamtcv_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","பாலைவனத்துக்கு அருகே எல்பாரான் வரையுள்ள, சேயீர் மலைநாட்டில் வாழ்ந்த ஓரியரையும் தோற்கடித்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","பின்பு அவர்கள் மற்றப் பக்கமாகத் திரும்பி, காதேஸ் எனப்படும் என்மிஸ்பாத்துக்கு வந்து, அமலேக்கியரின் முழுப் பிரதேசத்தையும் கைப்பற்றிக்கொண்டார்கள். அதோடு அத்சாத்சோன் தாமாரில் இருந்த எமோரியரையும் வெற்றிகொண்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","அப்பொழுது அவர்களை எதிர்க்க சோதோம், கொமோரா, அத்மா, செபோயீம் (அது சோவார்), பேலா ஆகிய நாடுகளின் அரசர்கள் அணிவகுத்துச்சென்று, சித்தீம் பள்ளத்தாக்கில் ");
INSERT INTO tamtcv_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ஏலாமின் அரசன் கெதர்லாகோமேர், கோயீமின் அரசன் திதியால், சிநெயாரின் அரசன் அம்ராப்பேல், ஏலாசாரின் அரசன் அரியோகு ஆகிய நான்கு அரசர்களும், மற்ற ஐந்து அரசர்களையும் எதிர்த்துப் போரிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","சித்தீம் பள்ளத்தாக்கில் பல நிலக்கீல் குழிகள் இருந்தன; அந்த போரில் சோதோம், கொமோரா நாட்டு அரசர்கள் தோல்வியடைந்து தப்பி ஓடியபோது, அவர்கள் அக்குழிகளில் விழுந்தார்கள்; மற்றவர்கள் மலைகளுக்கு ஓடிப்போனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","வெற்றியடைந்த நான்கு அரசர்களும், சோதோமிலும் கொமோராவிலும் இருந்த எல்லா பொருட்களையும், உணவுப் பொருட்களையும் கொள்ளையடித்துக்கொண்டு வீடு திரும்பினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","அத்துடன், சோதோமில் குடியிருந்த ஆபிராமுடைய சகோதரனின் மகனான லோத்தையும், அவனது உடைமைகளையும் கொண்டுபோய்விட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","தப்பியோடிய ஒருவன், எபிரெயனாகிய ஆபிராமிடம் வந்து அச்செய்தியை அறிவித்தான். அப்பொழுது ஆபிராம், எமோரியனாகிய மம்ரேக்குச் சொந்தமான கருவாலி மரங்களின் அருகே குடியிருந்தான்; மம்ரே என்பவன் ஆபிராமுடன் நட்பு உடன்படிக்கை செய்திருந்த எஸ்கோல், ஆநேர் என்போரின் சகோதரன். ");
INSERT INTO tamtcv_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","தன் உறவினனான லோத்து கைதியாகக் கொண்டு போகப்பட்டதைக் கேள்விப்பட்ட ஆபிராம், தன் வீட்டில் பிறந்தவர்களான முந்நூற்றுப் பதினெட்டு பயிற்சி பெற்ற மனிதருடன் அவர்களை தாண்வரை துரத்திச்சென்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","அன்றிரவு ஆபிராம், தன் ஆட்களை அணிகளாகப் பிரித்து, எதிரிகளைத் தாக்கினான்; அவன் அவர்களை தமஸ்குவுக்கு வடக்கே ஓபாவரை துரத்தி முறியடித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","அவன் லோத்தையும், அவனுடைய எல்லா உடைமைகளையும், பெண்களையும், மற்றவர்களையும் மீட்டுக்கொண்டு திரும்பினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","ஆபிராம், கெதர்லாகோமேரையும், அவனுடைய நண்பர்களாகிய அரசர்களையும் தோற்கடித்துத் திரும்பி வந்தபின், சோதோமின் அரசன், ஆபிராமைச் சந்திப்பதற்காக அரச பள்ளத்தாக்கு எனப்படும் சாவே பள்ளத்தாக்கிற்கு வந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","அப்பொழுது சாலேமின் அரசனான மெல்கிசேதேக்கு அப்பமும் திராட்சை இரசமும் கொண்டுவந்தான். மெல்கிசேதேக்கு என்பவன் மகா உன்னதமான இறைவனின் ஆசாரியனாய் இருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","அவன் ஆபிராமை ஆசீர்வதித்து சொன்னது: “வானத்தையும், பூமியையும் உண்டாக்கிய மகா உன்னதமான இறைவனால் ஆபிராம் ஆசீர்வதிக்கப்படட்டும். ");
INSERT INTO tamtcv_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","உன் பகைவரை உன் கையில் ஒப்படைத்த, மகா உன்னதமான இறைவன், துதிக்கப்படுவாராக.” ஆபிராம் தன்னிடமிருந்த எல்லாவற்றிலும் பத்தில் ஒரு பங்கை அவனுக்குக் கொடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","அதன்பின் சோதோமின் அரசன் ஆபிராமிடம், “ஆட்களை என்னிடம் கொடும், பொருட்களை நீர் எடுத்துக்கொள்ளும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","ஆனால் ஆபிராம் சோதோமின் அரசனிடம், “நான் வானத்தையும் பூமியையும் உண்டாக்கிய மகா உன்னதமான யெகோவாவுக்கு என் கைகளை உயர்த்தி சத்தியம் செய்கிறதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","‘ஆபிராமை நானே செல்வந்தன் ஆக்கினேன்’ என்று நீ சொல்லாதபடி, உன்னிடமிருந்து ஒரு நூலையோ, செருப்பின் வாரையோ அல்லது உனக்குச் சொந்தமான பொருள் எதையுமோ நான் எடுத்துக்கொள்ளமாட்டேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","என் ஆட்கள் சாப்பிட்டதையும் என்னுடன் வந்த ஆநேர், எஸ்கோல், மம்ரே ஆகிய மனிதரின் பங்கையும் தவிர, வேறொன்றையும் நான் ஏற்றுக்கொள்ளமாட்டேன். அவர்களுக்குச் சேரவேண்டிய பங்கை அவர்கள் எடுத்துக்கொள்ளட்டும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","அதற்குபின் ஒரு தரிசனத்தில் யெகோவாவின் வார்த்தை ஆபிராமுக்கு வந்தது: “ஆபிராமே, பயப்படாதே. நானே உன் கேடயம், நானே உன் மகா பெரிய வெகுமதி.” ");
INSERT INTO tamtcv_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","அதற்கு ஆபிராம், “ஆண்டவராகிய யெகோவாவே, நான் பிள்ளையில்லாதவனாய் இருக்க, எனக்கு நீர் எதைத் தரப்போகிறீர்? என் சொத்துக்களை உரிமையாக்கிக் கொள்ளப்போகிறவன் தமஸ்கு பட்டணத்தைச் சேர்ந்த எலியேசர்தானே?” ");
INSERT INTO tamtcv_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","பின்னும் ஆபிராம், “நீர் எனக்குப் பிள்ளைகளைக் கொடுக்கவில்லையே; ஆதலால், என் வீட்டு வேலைக்காரன் என் வாரிசாகப் போகிறான்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","அப்பொழுது ஆபிராமுக்கு யெகோவாவினுடைய வார்த்தை வந்தது: “இந்த மனிதன் உன் வாரிசாய் இருக்கமாட்டான், உன் சதையும் உன் இரத்தமுமாய் உன்னிலிருந்து பிறக்கும் உன் மகனே உன் வாரிசாய் இருப்பான்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","பின்பு யெகோவா ஆபிராமை வெளியே கூட்டிக்கொண்டுவந்து, “வானத்தை அண்ணாந்து பார், நட்சத்திரங்களை உன்னால் எண்ண முடியுமானால் எண்ணு; உன் சந்ததியும் அவற்றைப் போலவே இருக்கும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","ஆபிராம் யெகோவாவை விசுவாசித்தான், அந்த விசுவாசத்தை அவர் அவனுக்கு நீதியாக எண்ணினார். ");
INSERT INTO tamtcv_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","பின்னும் யெகோவா ஆபிராமிடம், “இந்த நாட்டை நீ உடைமையாக்கிக்கொள்ளும்படி இதை உனக்குக் கொடுப்பதற்காக, கல்தேயரின் ஊர் பட்டணத்திலிருந்து உன்னைக் கொண்டுவந்த யெகோவா நானே” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","அதற்கு ஆபிராம், “ஆண்டவராகிய யெகோவாவே, நான் இதை உரிமையாக்கிக்கொள்வேன் என்பதை எப்படி அறிவேன்?” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","யெகோவா அவனிடம், “ஒரு இளம் பசுவையும், ஒரு வெள்ளாட்டையும், ஒரு செம்மறியாட்டுக் கடாவையும் என்னிடம் கொண்டுவா, அவை ஒவ்வொன்றும் மூன்று வயதுடையதாய் இருக்கவேண்டும்; அத்துடன் ஒரு காட்டுப்புறாவையும் ஒரு புறாக்குஞ்சையும் கொண்டுவா” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","அப்பொழுது ஆபிராம் அவை எல்லாவற்றையும் அவரிடம் கொண்டுவந்து, மிருகங்களை இரண்டாகப் பிளந்து, அவைகளை ஒன்றுக்கொன்று எதிராக ஒழுங்குபடுத்தி வைத்தான்; பறவைகளையோ அவன் இரண்டாக வெட்டவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","அப்பொழுது மாமிசம் தின்னிப் பறவைகள், வெட்டி வைத்த உடல்களை உண்பதற்கு இறங்கின, ஆபிராம் அவைகளைத் துரத்திவிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","சூரியன் மறைந்துகொண்டிருக்கும்போது, ஆபிராம் ஆழ்ந்த நித்திரை அடைந்தான்; பயங்கரமான காரிருள் அவனை மூடிக்கொண்டது. ");
INSERT INTO tamtcv_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","அவ்வேளையில் யெகோவா ஆபிராமிடம், “நீ நன்கு அறிந்துகொள்: உன் சந்ததிகள் தங்களுக்குச் சொந்தமில்லாத ஒரு நாட்டிலே அந்நியர்களாக இருப்பார்கள், அவர்கள் நானூறு வருடங்களுக்கு அடிமைப்படுத்தப்பட்டு துன்புறுத்தப்படுவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","ஆனால் அவர்கள் அடிமைகளாய் இருந்து பணிசெய்கிற அந்த நாட்டையோ நான் நியாயந்தீர்ப்பேன்; அதன்பின் அவர்கள் அதிக உடைமைகளுடன் அங்கிருந்து வெளியேறுவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","நீயோ, மன சமாதானத்துடன் உன் முன்னோருடன் சேருவாய், முதிர்வயதில் இறந்து அடக்கம்பண்ணப்படுவாய். ");
INSERT INTO tamtcv_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","உன் சந்ததிகள் நான்காம் தலைமுறையில் மறுபடியும் இங்கே திரும்பி வருவார்கள்; ஏனெனில், எமோரியருடைய பாவம் இன்னும் முழு அளவை அடையவில்லை” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","சூரியன் மறைந்து இருள் உண்டானபோது, எரிகின்ற தீப்பந்தமும், புகையும் நெருப்பு ஜாடியும் தோன்றி, வெட்டிவைத்த துண்டுகளிடையே சென்றது. ");
INSERT INTO tamtcv_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","அந்நாளிலே யெகோவா ஆபிராமுடன் ஒரு உடன்படிக்கை செய்து, “எகிப்தின் நதிக்கும் ஐபிராத்து நதிக்கும் இடையிலுள்ள ");
INSERT INTO tamtcv_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","கேனியர், கெனிசியர், கத்மோனியர் ");
INSERT INTO tamtcv_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ஏத்தியர், பெரிசியர், ரெப்பாயீமியர், ");
INSERT INTO tamtcv_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","எமோரியர், கானானியர், கிர்காசியர், எபூசியர் என்பவர்களின் நாட்டை உன் சந்ததிக்குக் கொடுக்கிறேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","ஆபிராமின் மனைவி சாராய் அவனுக்குப் பிள்ளைகளைப் பெறவில்லை. ஆனால் அவளுக்கு ஆகார் என்னும் பெயருடைய எகிப்திய பணிப்பெண் ஒருத்தி இருந்தாள்; ");
INSERT INTO tamtcv_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","எனவே சாராய் ஆபிராமிடம், “யெகோவா என்னைப் பிள்ளை பெறாதபடி ஆக்கியிருக்கிறார். ஆகவே நீர் என் பணிப்பெண்ணுடன் உறவுகொள்ளும்; ஒருவேளை அவள் மூலமாயினும் நான் ஒரு குடும்பத்தை உருவாக்கக் கூடியதாய் இருக்கும்” என்றாள். ஆபிராம் சாராயின் சொல்லுக்கு இணங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","எனவே ஆபிராம் கானானில் பத்து வருடங்கள் குடியிருந்தபின் அவன் மனைவி சாராய், தன் எகிப்திய பணிப்பெண்ணான ஆகாரைத் தன் கணவனுக்கு மனைவியாகக் கொடுத்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","ஆபிராம் அவளோடு உறவுகொண்டபோது, அவள் கர்ப்பவதியானாள். தான் கர்ப்பவதியானதை ஆகார் அறிந்தபோது, தன் எஜமாட்டியான சாராயை இகழ்ச்சியுடன் பார்க்கத் தொடங்கினாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","சாராய் அதைக்கண்டு ஆபிராமிடம், “நான் வேதனைப்படுவதற்கான அநியாயத்திற்குப் பொறுப்பு நீரே. என் பணிப்பெண்ணை நான் உமக்குக் கொடுத்தேன், இப்பொழுது அவள் தான் கர்ப்பவதியாய் இருப்பதை அறிந்து, என்னை இகழ்ச்சி செய்கிறாள். உமக்கும் எனக்கும் இடையில், யெகோவாவே நியாயந்தீர்க்கட்டும்” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","அதற்கு ஆபிராம், “உன் பணிப்பெண், உன் பொறுப்பில்தானே இருக்கிறாள், எது நல்லது என்று நீ நினைக்கிறாயோ, அதை அவளுக்குச் செய்” என்றான். அதன்பின் சாராய் ஆகாரைக் கொடுமைப்படுத்தினாள்; அதனால் ஆகார் அவளைவிட்டு ஓடிப்போனாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","யெகோவாவின் தூதனானவர் வனாந்திரத்தில் சூருக்குப் போகும் வழியில் இருந்த நீரூற்றுக்கு அருகே ஆகாரைக் கண்டார். ");
INSERT INTO tamtcv_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","அவர் அவளிடம், “ஆகாரே, சாராயின் பணிப்பெண்ணே, நீ எங்கிருந்து வந்திருக்கிறாய், எங்கே போகிறாய்?” என்று கேட்டார். அதற்கு அவள், “என் எஜமாட்டியாகிய சாராயைவிட்டு நான் ஓடிப்போகிறேன்” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","அப்பொழுது யெகோவாவின் தூதனானவர், “நீ உன் எஜமாட்டியிடம் திரும்பிப்போய், அவளுக்குக் கீழ்ப்படிந்திரு” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","மேலும் யெகோவாவினுடைய தூதனானவர், “உன் சந்ததிகளை எண்ணமுடியாத அளவு பெருகப்பண்ணுவேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","மறுபடியும் யெகோவாவின் தூதனானவர் அவளிடம் சொன்னது: “நீ இப்பொழுது கர்ப்பவதியாயிருக்கிறாய், உனக்கு ஒரு மகன் பிறப்பான். நீ அவனுக்கு இஸ்மயேல் என்று பெயரிட வேண்டும். ஏனெனில் யெகோவா உன் அழுகுரலைக் கேட்டிருக்கிறார். ");
INSERT INTO tamtcv_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","அவன் காட்டுக் கழுதையைப் போல் வாழ்கிற மனிதனாயிருப்பான்; அவனுடைய கை எல்லோருக்கும் விரோதமாகவும் எல்லோருடைய கைகளும் அவனுக்கு விரோதமாக இருக்கும்; அவன் தன் சகோதரர்கள் எல்லோருக்கும் எதிராக வெளிப்படையான விரோதத்துடன் வாழ்வான்.” ");
INSERT INTO tamtcv_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","அப்பொழுது அவள், “என்னைக் காண்கிறவரை நானும் இங்கே கண்டேன்” என்று சொல்லி, தன்னுடன் பேசிய யெகோவாவுக்கு, “நீர் என்னைக் காண்கிற இறைவன்” என்று பெயரிட்டாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","அதனால் அக்கிணறு, பீர்லகாய்ரோயீ எனப் பெயரிடப்பட்டது; அது காதேசுக்கும், பாரேத்திற்கும் இடையே இன்னும் இருக்கிறது. ");
INSERT INTO tamtcv_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ஆகார், ஆபிராமுக்கு ஒரு மகனைப் பெற்றாள், அவனுக்கு ஆபிராம் இஸ்மயேல் என்று பெயரிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","ஆகார் இஸ்மயேலைப் பெற்றபோது, ஆபிராம் எண்பத்தாறு வயதுடையவனாய் இருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","ஆபிராம் தொண்ணூற்றொன்பது வயதாயிருந்தபோது, யெகோவா அவனுக்குத் தோன்றி, “நான் எல்லாம் வல்ல இறைவன்; நீ எனக்கு முன்பாக உண்மையாய் நடந்து குற்றமற்றவனாய் இரு. ");
INSERT INTO tamtcv_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","நான் உனக்கும் எனக்கும் இடையில் என் உடன்படிக்கையை ஏற்படுத்தி, மேலும் உறுதிப்படுத்துவேன், உன்னை மிகவும் பெருகப்பண்ணுவேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","ஆபிராம் முகங்குப்புற விழுந்தான், இறைவன் அவனுடன் பேசி, ");
INSERT INTO tamtcv_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“என்னைப் பொறுத்தமட்டில் நான் உன்னுடன் செய்யும் உடன்படிக்கை இதுவே: நீ பல நாடுகளுக்குத் தகப்பனாவாய். ");
INSERT INTO tamtcv_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","நான் உன்னை அநேக நாடுகளுக்குத் தகப்பனாக்கியிருப்பதால், இனி நீ ஆபிராம் என்று அழைக்கப்படாமல், ஆபிரகாம் என்றே அழைக்கப்படுவாய். ");
INSERT INTO tamtcv_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","நான் உன்னை மிகவும் இனவிருத்தி உள்ளவனாக்குவேன்; உன்னிலிருந்து பல நாடுகளை உருவாக்குவேன், அரசர்கள் உன்னிலிருந்து தோன்றுவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","நான் உன் இறைவனாகவும் உனக்குப்பின் உன் சந்ததிகளுடைய இறைவனாகவும் இருப்பேன்; இந்த என் உடன்படிக்கையை, எனக்கும் உனக்கும் இடையில் ஒரு நித்திய உடன்படிக்கையாக உன்னுடனும் உனக்குப்பின் தலைமுறைதோறும் உன் சந்ததிகளுடனும் ஏற்படுத்துவேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","நீ இப்பொழுது அந்நியனாய் வாழும் இந்தக் கானான் நாடு முழுவதையும், உனக்கும் உனக்குப்பின் உன் சந்ததிகளுக்கும் ஒரு நித்திய உடைமையாகக் கொடுப்பேன்; நானே அவர்களுக்கு இறைவனாய் இருப்பேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","அதன்பின் இறைவன் ஆபிரகாமிடம், “உன்னைப் பொறுத்தமட்டில், என் உடன்படிக்கையை நீயும் உனக்குப்பின் உன் சந்ததியும் தலைமுறை தலைமுறையாக அதைக் கடைபிடிக்க வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","நான் உன்னோடும், உனக்குப் பின்வரும் உன் சந்ததிகளோடும் செய்துகொள்ளும் என் உடன்படிக்கையில் நீங்கள் கைக்கொள்ளவேண்டிய பங்காவது: உங்கள் மத்தியில் உள்ள ஒவ்வொரு ஆணும் விருத்தசேதனம் செய்துகொள்ள வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","நீயும் நுனித்தோலின் மாம்சத்தை விருத்தசேதனம் செய்துகொள்ள வேண்டும், அது எனக்கும் உனக்கும் இடையிலான உடன்படிக்கையின் அடையாளமாயிருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","தலைமுறைதோறும், ஒவ்வொரு ஆண் குழந்தைக்கும் பிறந்து எட்டாவது நாள் விருத்தசேதனம் செய்யப்படவேண்டும். உங்கள் குடும்பத்தில் பிறந்தவர்களுக்கும், உங்கள் சந்ததியாய் இராமல், அந்நியரிடமிருந்து பணத்துக்கு வாங்கப்பட்டவர்களுக்கும் விருத்தசேதனம் செய்யப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","அவர்கள் உன் குடும்பத்தில் பிறந்தவர்களாய் இருந்தாலென்ன, பணத்திற்கு வாங்கப்பட்டவர்களாய் இருந்தாலென்ன, அவர்களுக்கும் கட்டாயம் விருத்தசேதனம் செய்யவேண்டும். இவ்வாறு இது உங்கள் உடலில் என் நித்திய உடன்படிக்கையின் அடையாளமாக இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","எந்த ஆணுக்கும் தன் உடலில் நுனித்தோலின் மாம்சம் விருத்தசேதனம் செய்யப்படாதிருந்தால், அவன் தன் சொந்த மக்களிலிருந்து விலக்கப்படுவான்; ஏனெனில், அவன் என் உடன்படிக்கையை நிராகரித்துவிட்டான்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","மேலும் இறைவன் ஆபிரகாமிடம், “உன் மனைவி சாராயை இனிமேல் நீ சாராய் என்று அழைக்கவேண்டாம்; சாராள் என்பதே அவள் பெயராகும். ");
INSERT INTO tamtcv_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","நான் அவளை ஆசீர்வதித்து, நிச்சயமாக அவள் மூலம் உனக்கு ஒரு மகனைக் கொடுப்பேன். நான் அவளை ஆசீர்வதிப்பதனால், அவள் நாடுகளுக்குத் தாயாவாள்; மக்கள் கூட்டங்களின் அரசர்களும் அவளிலிருந்து தோன்றுவார்கள்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","அப்பொழுது ஆபிரகாம் முகங்குப்புற விழுந்து சிரித்து, “நூறு வயதுள்ள மனிதனுக்குப் பிள்ளை பிறக்குமோ? தொண்ணூறு வயதில் சாராள் பிள்ளை பெறுவாளோ?” என்று தனக்குள்ளே சொல்லிக்கொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","மேலும் ஆபிரகாம் இறைவனிடம், “இஸ்மயேல் உம்முடைய ஆசீர்வாதத்தில் வாழ்ந்தாலே போதும்!” என்று சொன்னான். ");
INSERT INTO tamtcv_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","அதற்கு இறைவன், “ஆம்; ஆனாலும், சாராள் உனக்கு ஒரு மகனைப் பெறுவாள்; நீ அவனுக்கு ஈசாக்கு என்று பெயரிடு. என் உடன்படிக்கையை நான் அவனுடன் ஏற்படுத்துவேன்; அது அவனுக்குப்பின் அவனுடைய சந்ததிகளுக்கு ஒரு நித்திய உடன்படிக்கையாக இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","இஸ்மயேலைப் பொறுத்தமட்டில், நான் உன் விண்ணப்பத்தைக் கேட்டேன்: நான் அவனை நிச்சயமாக ஆசீர்வதிப்பேன்; நான் அவனை இனவிருத்தி உள்ளவனாக்கி, அவனுடைய சந்ததியையும் பலுகிப் பெருகப்பண்ணுவேன். அவன் பன்னிரண்டு ஆளுநர்களுக்குத் தகப்பனாயிருப்பான், நான் அவனை ஒரு பெரிய நாடாக்குவேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","ஆனால், அடுத்த வருடம் இதே காலத்தில், சாராள் உனக்குப் பெறப்போகும் ஈசாக்குடனேயே என் உடன்படிக்கையை ஏற்படுத்துவேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","இறைவன் ஆபிரகாமுடன் பேசி முடித்தபின் மேலெழுந்து போனார். ");
INSERT INTO tamtcv_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ஆபிரகாம், இறைவன் தனக்குச் சொன்னபடி அந்த நாளிலேயே, இஸ்மயேலுக்கும், தன் வீட்டில் பிறந்தவர்களும், பணத்திற்கு வாங்கப்பட்டவர்களுமான தன் வீட்டிலுள்ள எல்லா ஆண்களுக்கும் நுனித்தோலின் மாம்சத்தை விருத்தசேதனம் செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","ஆபிரகாமுடைய நுனித்தோலின் மாம்சம் விருத்தசேதனம் செய்யப்படும்போது அவன் தொண்ணூற்றொன்பது வயதுடையவனாய் இருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","அவனுடைய மகன் இஸ்மயேலுடைய நுனித்தோலின் மாம்சம் விருத்தசேதனம் செய்யப்படும்போது அவன் பதின்மூன்று வயதுடையவனாய் இருந்தான்; ");
INSERT INTO tamtcv_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","ஆபிரகாமும் அவன் மகன் இஸ்மயேலும் ஒரே நாளில் விருத்தசேதனம் செய்யப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ஆபிரகாமின் வீட்டில் பிறந்தவர்களும், அவனால் பணங்கொடுத்து அந்நியரிடம் வாங்கப்பட்டவர்களுமான அவனுடைய குடும்பத்தைச் சேர்ந்த எல்லா ஆண்களும் ஆபிரகாமுடன் விருத்தசேதனம் செய்யப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","வெப்பமான பகற்பொழுதிலே, ஆபிரகாம் தன்னுடைய கூடாரவாசலில் உட்கார்ந்திருக்கையில், மம்ரேயின் மரச்சோலையருகே, யெகோவா இன்னும் ஒருமுறை அவனுக்குத் தரிசனமானார். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","ஆபிரகாம் நிமிர்ந்து பார்த்தபோது, சிறிது தொலைவில் மூன்று மனிதர் நிற்கிறதைக் கண்டான். அவன் அவர்களைக் கண்டபோது, அவர்களைச் சந்திக்கும்படியாக, தன் கூடாரவாசலில் இருந்து விரைந்து சென்று தரைமட்டும் தலைகுனிந்து வணங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","அவன், “என் ஆண்டவரே, உம்முடைய கண்களில் எனக்குத் தயவு கிடைத்திருந்தால், உமது அடியானிடம் வராமல் போய்விடாதேயும். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","என் வேலைக்காரர் கொஞ்சம் தண்ணீர் கொண்டுவரட்டும், நீங்கள் யாவரும் உங்கள் கால்களைக் கழுவி இம்மரத்தின் கீழ் இளைப்பாறலாம். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","இப்பொழுது நீங்கள் அடியேனிடம் வந்திருக்கிறபடியால், சாப்பிடுவதற்கு ஏதாவது கொண்டுவருகிறேன்; பின்பு நீங்கள் இளைப்பாறி, உங்கள் வழியே போகலாம்” என்றான். அதற்கு அவர்கள், “நல்லது, நீ சொன்னபடியே செய்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","உடனே ஆபிரகாம் கூடாரத்துக்குள் சாராளிடம் விரைந்து சென்று, “சீக்கிரமாய் மூன்றுபடி அளவு சிறந்த மாவை எடுத்துப் பிசைந்து கொஞ்சம் அப்பங்கள் சுடு” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","ஆபிரகாம் தன் மாட்டு மந்தைக்கு விரைந்து சென்று, ஒரு நல்ல இளங்கன்றைத் தெரிந்தெடுத்து, அதை ஒரு வேலைக்காரனிடம் கொடுத்தான்; அவன் அதைச் சமைப்பதற்கு விரைந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","பின்பு ஆபிரகாம், வெண்ணெயையும் பாலையும், சமைத்த இளங்கன்றின் இறைச்சியையும் கொண்டுவந்து அந்த மனிதர்கள் முன்பாக வைத்தான். அவர்கள் சாப்பிடும்போது, அவன் அவர்களுக்கு அருகே மரத்தின்கீழ் நின்றுகொண்டிருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","அவர்கள் ஆபிரகாமிடம், “உன் மனைவி சாராள் எங்கே?” என்று கேட்டார்கள். “அவள் கூடாரத்தில் இருக்கிறாள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","அப்பொழுது அம்மூவரில் ஒருவர், “அடுத்த வருடம் ஏறக்குறைய இதே காலத்தில் நான் நிச்சயமாகத் திரும்பவும் உன்னிடம் வருவேன், அப்பொழுது உன் மனைவி சாராளுக்கு ஒரு மகன் இருப்பான்” என்றார். சாராள், அவர்களுக்குப் பின்னால் இருந்த கூடாரத்தின் வாசலிலே நின்று அதைக்கேட்டுக் கொண்டிருந்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","ஆபிரகாமும் சாராளும் வயது முதிர்ந்தவர்களாய் இருந்தார்கள், சாராளும் பிள்ளைபெறும் வயதைத் தாண்டினவளாக இருந்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","எனவே சாராள், “என் உடல் தளர்ந்துவிட்டது, என் கணவரும் வயது சென்றவராகிவிட்டார், இப்பொழுது இந்த இன்பம் எனக்கு இருக்குமோ?” என நினைத்துத் தனக்குள்ளே சிரித்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","அப்பொழுது யெகோவா ஆபிரகாமிடம், “ ‘நான் வயது முதிர்ந்தவளாய் இருக்கையில் உண்மையாய்ப் பிள்ளை பெறுவேனோ என சாராள் கூறிச் சிரித்தது ஏன்?’ ");
INSERT INTO tamtcv_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","யெகோவாவுக்கு செய்யமுடியாத கடினமானது ஏதேனும் உண்டோ? நான் அடுத்த வருடம் நியமிக்கப்பட்ட காலத்தில் திரும்பவும் உன்னிடம் வருவேன், அப்பொழுது சாராளுக்கு ஒரு மகன் இருப்பான்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","சாராள் பயந்ததினால், “நான் சிரிக்கவில்லை” என்று பொய் சொன்னாள். அதற்கு அவர், “ஆம், நீ உண்மையாய்ச் சிரித்தாய்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","பின்பு அந்த மனிதர் புறப்படுவதற்கு எழுந்தபோது, சோதோமை நோக்கிப் பார்த்தார்கள்; ஆபிரகாம் அவர்களை வழியனுப்பும்படி அவர்களோடுகூடப் போனான். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","அப்பொழுது யெகோவா, “நான் செய்யப்போவதை ஆபிரகாமுக்கு மறைக்கலாமா? ");
INSERT INTO tamtcv_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","நிச்சயமாகவே ஆபிரகாம் பெரிதும் வலிமைமிக்கதுமான ஒரு நாடாக வருவான், அவன்மூலம் பூமியின் எல்லா நாடுகளும் ஆசீர்வதிக்கப்படும். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","ஏனெனில் நானே ஆபிரகாமைத் தெரிந்தெடுத்தேன், அவன் தனக்குப்பின் தனது பிள்ளைகளும், தனது குடும்பமும் சரியானதையும் நீதியானதையும் செய்து, யெகோவாவின் வழியைக் கடைப்பிடிப்பதற்கு அவர்களை வழிநடத்துவான். அப்பொழுது யெகோவா ஆபிரகாமுக்குக் கொடுத்த வாக்குறுதியை நிறைவேற்றுவார்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","அதன்பின் யெகோவா, “சோதோம், கொமோராவின் பாவம் மிகவும் கொடியதாய் இருக்கிறது, அவர்களுக்கு விரோதமான கூக்குரலும் அதிகமாய் எழும்பியிருக்கின்றது. ");
INSERT INTO tamtcv_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","அவர்களின் செய்கைகள், எனக்கு எட்டிய கூக்குரலுக்கேற்ப கொடியதாய் இருக்கின்றனவோ என்று நான் போய்ப்பார்ப்பேன். அப்படியில்லையென்றால், அதையும் அறிவேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","பின்பு அந்த மனிதர் அவ்விடத்தைவிட்டுச் சோதோமை நோக்கிப் போனார்கள், ஆனால் ஆபிரகாம் யெகோவாவுக்கு முன்பாக நின்றுகொண்டிருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","ஆபிரகாம் யெகோவாவை அணுகி, “கொடியவர்களுடன் நீதிமான்களையும் அழிப்பீரோ? ");
INSERT INTO tamtcv_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","ஒருவேளை பட்டணத்தில் நீதிமான்கள் ஐம்பதுபேர் இருந்தால் அதை அழித்து விடுவீரோ? நீதிமானான அந்த ஐம்பது பேர்களுக்காகிலும் அதை அழியாமல் விடமாட்டீரோ? ");
INSERT INTO tamtcv_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","கொடியவர்களுடன் நீதிமான்களையும் கொல்லுவதும், கொடியவர்களையும் நீதிமான்களையும் ஒரேவிதமாக நடத்துவதும் உமக்கு ஒருபோதும் ஏற்றதல்ல. அது உமக்குத் தூரமாயிருப்பதாக! பூமி முழுவதற்கும் நீதிபதியானவர் நியாயத்தைச் செய்யமாட்டாரோ?” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","அதற்கு யெகோவா ஆபிரகாமிடம், “நீதிமான்கள் ஐம்பது பேரை சோதோம் பட்டணத்தில் நான் காண்பேனாகில், அவர்களுக்காக அந்த முழு இடத்தையும் தப்பவிடுவேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","மறுபடியும் ஆபிரகாம் யெகோவாவிடம், “புழுதியும் சாம்பலுமான நான் யெகோவாவுடன் பேசத் துணிவுகொண்டேன், ");
INSERT INTO tamtcv_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ஒருவேளை நீதிமான்கள் நாற்பத்தைந்து பேர் மட்டும் இருந்தால், ஐந்துபேர் குறைவாக இருப்பதனால் அந்த முழுப்பட்டணத்தையும் அழிப்பீரோ?” எனக் கேட்டான். அதற்கு யெகோவா, “நீதிமான்கள் நாற்பத்தைந்து பேர் அங்கிருந்தாலும் அதை அழிக்கமாட்டேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","மேலும் ஆபிரகாம் அவரிடம், “ஒருவேளை நீதிமான்கள் நாற்பது பேர் மட்டும் இருந்தால்?” என்றான். அதற்கு அவர், “நாற்பது பேர் இருந்தாலும் நான் அழிக்கமாட்டேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","பின்பு ஆபிரகாம், “நான் மறுபடியும் பேசுவதற்காக யெகோவா கோபிக்காதிருப்பாராக, முப்பது பேர் மட்டும் இருப்பார்களானால் என்ன செய்வீர்?” என்றான். அதற்கு அவர், “முப்பது பேர் அங்கிருந்தாலும் அதை அழிக்கமாட்டேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","ஆபிரகாம், “நான் இப்பொழுது யெகோவாவுடன் பேசத்துணிந்தேன், ஒருவேளை இருபது பேர் மட்டும் அங்கிருந்தால் என்ன செய்வீர்?” என்றான். அதற்கு அவர், “அந்த இருபது பேருக்காகவும் அதை அழிக்கமாட்டேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","மறுபடியும் ஆபிரகாம், “நான் இன்னும் ஒருமுறை பேசுவதற்கு யெகோவா என்னோடு கோபிக்காதிருப்பாராக. பத்துப்பேர் மட்டும் அங்கிருந்தால் என்ன செய்வீர்?” என்றான். அதற்கு யெகோவா, “அந்த பத்துப்பேருக்காகவும் அதை நான் அழிக்கமாட்டேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","யெகோவா ஆபிரகாமோடு பேசியபின், அவ்விடத்தைவிட்டுப் போனார். ஆபிரகாமும் தன் இருப்பிடத்திற்குத் திரும்பிச்சென்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","அன்று மாலை, சோதோம் பட்டணத்து வாசலிலே லோத்து உட்கார்ந்திருந்தபோது, அவ்விரு தூதர்களும் அவ்விடம் வந்தார்கள். லோத்து அவர்களைக் கண்டவுடன், அவர்களைச் சந்திப்பதற்காக எழுந்துபோய் தரைமட்டும் குனிந்து வணங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","லோத்து அவர்களிடம், “ஐயாமார்களே” நீங்கள் இருவரும், அடியேனுடைய வீட்டிற்கு வாருங்கள். “நீங்கள் உங்கள் கால்களைக் கழுவி இன்றிரவு என்னுடன் தங்கி, அதிகாலையில் உங்கள் பயணத்தைத் தொடரலாம்” என்றான். அதற்கு அவர்கள், “வேண்டாம், நாங்கள் இன்றிரவு நகரச் சதுக்கத்திலே தங்குவோம்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","அவன் அவர்களை வற்புறுத்தி அழைத்ததால், அவர்கள் அவனுடைய வீட்டிற்குள் போனார்கள். லோத்து புளிப்பில்லாத அப்பங்களைச் சுட்டு, அவர்களுக்கு உணவு தயாரித்தான். அவர்கள் அதைச் சாப்பிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","அவர்கள் படுக்கைக்குப் போகுமுன், சோதோம் பட்டணத்தின் எல்லா பகுதிகளிலிருந்தும் வாலிபர்முதல் முதியோர்வரை எல்லா ஆண்களும் வந்து லோத்தின் வீட்டைச் சூழ்ந்துகொண்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","அவர்கள் லோத்தைக் கூப்பிட்டு, “இன்றிரவு, உன்னிடம் வந்த மனிதர் எங்கே? நாங்கள் அவர்களுடன் பாலுறவுகொள்ளும்படி அவர்களை வெளியே கொண்டுவா” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","உடனே லோத்து, வீட்டுக்கு வெளியே வந்து, கதவைத் தனக்குப் பின்னால் பூட்டிக்கொண்டு ");
INSERT INTO tamtcv_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","அவர்களிடம், “வேண்டாம் நண்பர்களே! இந்தக் கொடுமையான செயலைச் செய்யவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","இதோ, எனக்குக் கன்னியரான இரு மகள்கள் இருக்கிறார்கள். அவர்களை உங்களிடம் கொண்டுவருகிறேன். உங்களுக்கு விருப்பமானபடி அவர்களுடன் நடவுங்கள். ஆனால் இந்த மனிதரை ஒன்றும் செய்யவேண்டாம். ஏனெனில், அவர்கள் பாதுகாப்புக்காக என் வீட்டுக்கு வந்திருக்கிறார்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","அதற்கு அவர்கள், “அப்பாலே போ; அந்நியனாக இவ்விடத்திற்கு வந்த இவன் இப்பொழுது எங்களுக்கு நீதிபதியாக இருக்கப் பார்க்கிறான். அவர்களைவிட இப்பொழுது உன்னை மோசமாக நடத்துவோம்” என்று சொல்லி, லோத்தைத் தள்ளி கதவை உடைக்கப் போனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","ஆனால், வீட்டுக்குள் இருந்த இரு மனிதரும் தங்கள் கைகளை வெளியே நீட்டி, லோத்தை வீட்டிற்குள்ளே இழுத்துக் கதவைப் பூட்டினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","பின்பு அந்த மனிதர், வீட்டுக்கு வெளியே நின்ற வாலிபர்முதல் முதியோர்வரை எல்லோருடைய கண்களையும் குருடாக்கினார்கள். அதனால் அவர்களால் வீட்டு வாசலைக் கண்டுபிடிக்க முடியவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","அவ்விருவரும் லோத்திடம், “இங்கு உனக்கு வேறு யாராவது இருக்கிறார்களா? உன் மகன்களோ, மகள்களோ, மருமகன்களோ அல்லது உனக்குச் சொந்தமான வேறு யாரேனும் இந்தப் பட்டணத்தில் இருந்தால், அவர்களையும் கூட்டிக்கொண்டு இவ்விடத்திலிருந்து வெளியே போ. ");
INSERT INTO tamtcv_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ஏனெனில், நாங்கள் இவ்விடத்தை அழிக்கப்போகிறோம்; இங்கு உள்ளவர்களுக்கு எதிராக யெகோவாவின் முன்னிலையில் எட்டியுள்ள கூக்குரல் மிகவும் அதிகமாக இருக்கிறது. அதனால், இப்பட்டணத்தை அழிக்கும்படி அவர் எங்களை அனுப்பியிருக்கிறார்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","உடனே லோத்து வெளியே போய், தன் மகள்களுக்கு திருமணம் செய்ய நியமிக்கப்பட்டிருந்த மருமகன்களிடம், “விரைவாய் இந்த இடத்தைவிட்டு வெளியேறுங்கள். ஏனெனில், யெகோவா இப்பட்டணத்தை அழிக்கப்போகிறார்” என்றான். ஆனால் அவனுடைய மருமகன்களோ, அவன் கேலிசெய்கிறான் என்று நினைத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","பொழுது விடியும்போது, தூதர்கள் லோத்தைப் பார்த்து, “இங்கே இருக்கும் உன் மனைவியையும், உன் இரு மகள்களையும் கூட்டிக்கொண்டு, விரைவாக வெளியேறு; இல்லாவிட்டால் இப்பட்டணம் தண்டிக்கப்படும்போது நீயும் அழிந்துபோவாய்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","லோத்து வெளியேபோகத் தயங்கியபோது, யெகோவா லோத்தின் குடும்பத்தார்மேல் இரக்கமாயிருந்தபடியால், அந்த மனிதர் அவனுடைய கையையும், அவன் மனைவி மற்றும் இரு மகள்களுடைய கைகளையும் பிடித்துப் பட்டணத்திற்கு வெளியே பாதுகாப்பாய்க் கொண்டுபோய்விட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","அவர்கள் வெளியே வந்ததும், அவர்களில் ஒருவன் அவர்களிடம், “உயிர்தப்பும்படி ஓடிப்போங்கள்! திரும்பிப் பார்க்கவே வேண்டாம்; சமபூமியில் எந்த இடத்திலும் தங்காமல் மலைகளுக்கே ஓடிப்போங்கள்; இல்லாவிட்டால் நீங்களும் அழிந்துபோவீர்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","அதற்கு லோத்து அவர்களிடம், “ஐயாமார்களே, தயவுசெய்து அப்படி வேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","நான் உங்கள் கண்களிலே தயவு பெற்றிருக்கிறேன். எனக்குப் பெரிதான தயவுகாட்டி என்னுயிரைக் காப்பாற்றினீர்கள். ஆனால் மலைகளுக்குத் தப்பியோட என்னாலோ முடியாது. இந்த பேராபத்து என்னை மேற்கொண்டு நான் இறந்து விடுவேனே. ");
INSERT INTO tamtcv_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","இதோ நான் ஓடிப்போகக் கூடிய அளவுக்கு அருகாமையில் ஒரு சிறிய பட்டணம் இருக்கிறதே. அங்கே நான் தப்பியோட என்னை விடுங்கள். அது மிகவும் சிறிய பட்டணம்தானே. அப்பொழுது நான் உயிர்பிழைப்பேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","அதற்கு அந்த தூதன் லோத்திடம், “நல்லது, இந்த வேண்டுகோளையும் நான் உனக்குக் கொடுக்கிறேன். நீ சொன்ன அப்பட்டணத்தை நான் அழிக்கமாட்டேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","ஆனால் நீ விரைவாக அங்கே தப்பியோடு, ஏனென்றால், நீ அங்கேபோய்ச் சேரும்வரை என்னால் எதுவுமே செய்யமுடியாது” என்றார். அதனால் அப்பட்டணம் சோவார் என அழைக்கப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","லோத்து சோவாருக்குப் போய்ச் சேர்ந்தபோது, அந்த நாட்டின் மேலாகச் சூரியன் உதித்திருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","அப்பொழுது யெகோவா எரியும் கந்தகத்தை சோதோமின் மேலும், கொமோராவின் மேலும் பொழியப்பண்ணினார். அது யெகோவாவிடமிருந்து வானத்திலிருந்தே வந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","இவ்வாறு அவர் அந்தப் பட்டணங்களை அதில் வாழ்ந்த எல்லோருடனும் சேர்த்து, சமபூமி முழுவதையும் அழித்தார். அந்த நாட்டிலுள்ள தாவரங்களையும் அழித்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","ஆனாலும் லோத்தின் மனைவியோ போகும்போது திரும்பிப் பார்த்ததினால், உப்புத்தூண் ஆனாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","அடுத்தநாள் அதிகாலையில் ஆபிரகாம் எழுந்து, தான் முன்பு யெகோவாவின் முன்னிலையில் நின்ற இடத்திற்குத் திரும்பிப்போனான். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","அங்கிருந்து அவன் சோதோம், கொமோரா பட்டணங்களையும், சமபூமி முழுவதையும் நோக்கிப் பார்த்தபோது, சூளையிலிருந்து எழும்பும் புகையைப்போல் அந்த நாட்டிலிருந்து பெரும்புகை எழும்புவதைக் கண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","இவ்வாறு இறைவன் சமபூமியிலுள்ள பட்டணங்களை அழித்தபோது, ஆபிரகாமை நினைவில்கொண்டார். எனவே லோத்து குடியிருந்த பட்டணங்களை அழித்தபோது, அந்த பேரழிவிலிருந்து அவனை வெளியே கொண்டுவந்து தப்புவித்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","அதன்பின், லோத்து சோவாரிலே குடியிருக்கப் பயந்ததினால், தன் இரு மகள்களுடன் சோவாரைவிட்டுப் புறப்பட்டு, மலைநாட்டுக்குப் போய், ஒரு குகையில் வசித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ஒரு நாள், மூத்த மகள் இளையவளிடம், “நம் தகப்பன் வயது முதிர்ந்தவரானார்; உலக வழக்கத்தின்படி, நம்மை திருமணம் செய்து நம்முடன் உறவுகொள்ள இப்பகுதியில் ஆண்கள் யாரும் இல்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","நமது தகப்பனை திராட்சை மதுவைக் குடிக்கப்பண்ணி அவருடன் உறவுகொண்டு, அவர் மூலமாய் நமது குடும்ப வம்சாவழியைப் பாதுகாப்போம்” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","அப்படியே அவர்கள் அன்றிரவு தங்கள் தகப்பனுக்குத் திராட்சை மதுவைக் குடிக்கக் கொடுத்தார்கள். மூத்த மகள் போய் அவனுடன் உறவுகொண்டாள். அவள் தன்னுடன் உறவு கொண்டதையோ, எழுந்து போனதையோ அவன் அறியவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","மறுநாள் மூத்த மகள் இளையவளிடம், “நேற்றிரவு நம்முடைய தகப்பனுடன் நான் உறவுகொண்டேன். இன்றிரவு மறுபடியும் நாம் அவருக்குக் குடிக்கக் கொடுப்போம். இன்றிரவு நீ அவருடன் போய் உறவுகொள். இவ்விதமாய் நம் தகப்பன் மூலமாய், நாம் நமது குடும்ப வம்சாவழியைப் பாதுகாப்போம்” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","அப்படியே அன்றிரவும் தங்கள் தகப்பனுக்குத் திராட்சை மதுவைக் குடிக்கக் கொடுத்தார்கள். இளையவள் போய் அவனுடன் உறவுகொண்டாள். அவள் தன்னுடன் உறவு கொண்டதையோ, எழுந்து போனதையோ இம்முறையும் அவன் அறியவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","இவ்விதமாக லோத்தின் மகள்கள் இருவரும் தங்கள் தகப்பனால் கர்ப்பமானார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","மூத்த மகள் ஒரு மகனைப் பெற்று அவனுக்கு மோவாப் என்று பெயரிட்டாள். இக்காலத்து மோவாபியரின் தகப்பன் இவனே. ");
INSERT INTO tamtcv_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","இளையமகள் ஒரு மகனைப் பெற்று அவனுக்கு பென்னமி என்று பெயரிட்டாள். இக்காலத்திலுள்ள அம்மோனியரின் தகப்பன் இவனே. ");
INSERT INTO tamtcv_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ஆபிரகாம் அவ்விடம் விட்டு நெகேப் பிரதேசத்திற்குப் போய் அங்கே காதேஷ், சூர் என்னும் இடங்களுக்கு இடையே வசித்தான். சிறிதுகாலம் அவன் கேராரில் தங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","ஆபிரகாம் அங்கே தன் மனைவி சாராளைத், “தன் சகோதரி” என்று சொல்லியிருந்தான். அப்பொழுது கேராரின் அரசன் அபிமெலேக்கு தன் ஆட்களை அனுப்பி, சாராளை எடுத்துக்கொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","ஆனால் இறைவன் ஒரு இரவில் அபிமெலேக்குவுக்கு கனவில் தோன்றி, “நீ கொண்டுவந்திருக்கும் பெண்ணின் காரணமாக நீ செத்து அழியப்போகிறாய்; அவள் இன்னொருவனுடைய மனைவியாய் இருக்கிறாள்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","அபிமெலேக்கு அதுவரை சாராளை நெருங்கவில்லை; அதனால் அவன், “யெகோவாவே, குற்றமற்ற மக்களை நீர் அழிப்பீரோ? ");
INSERT INTO tamtcv_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","‘அவள் என் சகோதரி’ என்று அவன் எனக்குச் சொல்லவில்லையா? அவளும், ‘அவன் என் சகோதரன்’ என்று சொல்லவில்லையா? அதனால் சுத்த மனசாட்சியுடனும், குற்றமற்ற கைகளுடனுமே நான் இதைச் செய்தேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","இறைவன் அந்த கனவில் அவனிடம், “ஆம், சுத்த மனசாட்சியுடனே நீ இதைச் செய்தாய் என்பது எனக்குத் தெரியும். அதனால்தான் நீ எனக்கு விரோதமாய்ப் பாவம் செய்யாதபடிக்கு உன்னைக் காத்துக்கொண்டேன். நீ அவளைத் தொட நான் உன்னை விடவில்லை ");
INSERT INTO tamtcv_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","அந்தப் பெண்ணை அவளுடைய கணவனிடமே திருப்பி அனுப்பிவிடு, அவன் ஒரு இறைவாக்கினன்; அவன் உனக்காக மன்றாடுவான், நீயும் பிழைப்பாய். நீ அவளைத் திருப்பி அனுப்பாவிட்டால், நீயும் உன்னைச் சேர்ந்தவர்களும் சாகிறது நிச்சயம்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","அடுத்தநாள் அதிகாலையிலே அபிமெலேக்கு எழுந்து, தன் அலுவலர்கள் அனைவரையும் அழைப்பித்து, நடந்த யாவற்றையும் அவர்களுக்குச் சொன்னான்; அப்போது அவர்கள் மிகவும் பயந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","அதன்பின்பு அபிமெலேக்கு ஆபிரகாமை அழைத்து, “நீ எங்களுக்குச் செய்திருப்பது என்ன? நீ என்மேலும் என் அரசின்மேலும் இத்தகைய குற்றத்தைச் சுமத்துவதற்கு நான் உனக்கு என்ன தீங்கு செய்தேன்? செய்யத் தகாதவற்றை நீ எனக்குச் செய்துவிட்டாயே!” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","மேலும் அபிமெலேக்கு, “நீ இதைச் செய்ததன் காரணமென்ன?” என்று ஆபிரகாமிடம் கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","ஆபிரகாம் அதற்குப் மறுமொழியாக, “இந்த இடத்தில் நிச்சயமாக இறைவனைப்பற்றிய பயம் இல்லையென்றும், அதனால் என் மனைவியை அபகரிப்பதற்காக என்னைக் கொலைசெய்துவிடுவார்கள் என்றும் நினைத்தேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","அவள் என் சகோதரி என்பது உண்மையே. அவள் என் தாய்க்குப் பிறக்காவிட்டாலும், என் தகப்பனின் மகளாய் இருக்கிறாள்; ஆனால் இப்பொழுது அவள் என் மனைவி. ");
INSERT INTO tamtcv_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","இறைவன் என்னை என் தந்தையின் குடும்பத்தைவிட்டு அலைந்து திரியப்பண்ணியபோது, நான் அவளிடம், ‘நாம் எங்கு சென்றாலும், என்னை உன் சகோதரன் என்றே நீ சொல்லவேண்டும். நீ என்மேல் கொண்டிருக்கும் அன்பை இவ்விதமாகவே காண்பிக்கவேண்டும்’ என்று சொல்லியிருந்தேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","அப்பொழுது அபிமெலேக்கு, செம்மறியாடுகளையும், மாடுகளையும், ஆண், பெண் அடிமைகளையும் ஆபிரகாமுக்குக் கொடுத்து, அவன் மனைவி சாராளையும் அவனிடத்தில் திரும்ப ஒப்படைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","அபிமெலேக்கு ஆபிரகாமிடம், “என் தேசம் உனக்கு முன்பாக இருக்கிறது. நீ விரும்பிய இடத்தில் குடியிரு” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","அவன் சாராளைப் பார்த்து, “உன் சகோதரனுக்கு ஆயிரம் சேக்கல் வெள்ளிக்காசைக் கொடுக்கிறேன். உனக்கு விரோதமான குற்றத்திற்கு ஈடாக இங்கு உன்னுடன் நிற்கிறவர்களுக்கு முன்பாக நான் இவற்றைக் கொடுக்கிறேன். நீ குற்றமற்றவள் என்று முழுவதுமாய் நிரூபிக்கப்பட்டிருக்கிறாய்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","ஆபிரகாம் இறைவனிடம் வேண்டுதல் செய்தபோது, அவர் அபிமெலேக்கையும், அவன் மனைவியையும், அவனுடைய வீட்டிலுள்ள பணிப்பெண்களையும் குணமாக்கி, அவர்கள் மீண்டும் பிள்ளைப்பேறு உள்ளவர்களாகும்படிச் செய்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","ஏனெனில், ஆபிரகாமின் மனைவி சாராளின் நிமித்தம், யெகோவா அபிமெலேக்கின் வீட்டுப்பெண்களின் கருப்பைகளை எல்லாம் அடைத்திருந்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","யெகோவா தாம் சொல்லியிருந்தபடியே, சாராளுக்குக் கருணை காட்டினார்; தாம் கொடுத்திருந்த வாக்கை நிறைவேற்றினார். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","ஆபிரகாமின் முதிர்வயதில் சாராள் கர்ப்பவதியாகி, இறைவன் வாக்குப்பண்ணியிருந்த அந்த குறித்த காலத்திலேயே, அவனுக்கு ஒரு மகனைப் பெற்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","சாராள் தனக்குப் பெற்ற மகனுக்கு ஈசாக்கு என்று ஆபிரகாம் பெயரிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","தன் மகன் ஈசாக்குப் பிறந்த எட்டாம் நாளில், இறைவன் தனக்குக் கட்டளையிட்டபடியே, ஆபிரகாம் அவனுக்கு விருத்தசேதனம் செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","ஆபிரகாமின் மகன் ஈசாக்கு பிறந்தபோது, அவன் நூறு வயதுடையவனாய் இருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","அப்பொழுது சாராள், “இறைவன் என்னைச் சிரிக்க வைத்தார், இதைக் கேட்கும் யாவரும் என்னுடன் சேர்ந்து சிரிப்பார்கள்; ");
INSERT INTO tamtcv_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","சாராள் பிள்ளைகளைப் பாலூட்டி வளர்ப்பாள் என்று ஆபிரகாமுக்கு யார் சொல்லியிருப்பார்? அப்படியிருந்தும் அவரது முதிர்வயதில் நான் அவருக்கு ஒரு மகனைப் பெற்றேனே” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","அந்தக் குழந்தை வளர்ந்து பால்குடி மறந்தது. ஈசாக்கு பால் மறந்த நாளன்று ஆபிரகாம் ஒரு பெரிய விருந்து கொடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ஆனாலும், எகிப்தியப் பெண்ணான ஆகார் ஆபிரகாமுக்குப் பெற்ற மகன், தன் மகனைக் கேலி பண்ணுகிறதை சாராள் கண்டாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","அப்பொழுது அவள் ஆபிரகாமிடம், “இந்த அடிமைப் பெண்ணையும் அவள் மகனையும் வெளியே அனுப்பிவிடும்; உரிமைச்சொத்தில் இந்த அடிமைப்பெண்ணின் மகன் என் மகன் ஈசாக்குடன் சொத்துரிமையை ஒருபோதும் பகிர்ந்துகொள்ளக் கூடாது” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","தன் மகனைக் குறித்த இந்தக் காரியம் ஆபிரகாமை வெகுவாய்த் துயரப்படுத்தியது. ");
INSERT INTO tamtcv_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","அப்பொழுது இறைவன் ஆபிரகாமிடம், “அந்தச் சிறுவனையும், உன் பணிப்பெண்ணையும் குறித்து அதிகம் கவலைப்படாதே. சாராள் சொல்வதை எல்லாம் கேள், ஏனெனில் ஈசாக்கின் மூலமே உனக்கு சந்ததிகள் உண்டாகும். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","பணிப்பெண்ணின் மகனும் உன் சந்ததியானபடியால், அவனையும் ஒரு நாடாக்குவேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","மறுநாள் அதிகாலையில் ஆபிரகாம் கொஞ்சம் உணவையும், ஒரு தோல் குடுவையில் தண்ணீரையும் எடுத்து ஆகாரிடம் கொடுத்தான். அவன் அவற்றை அவளுடைய தோளில் வைத்து, மகனுடன் அவளை அனுப்பிவிட்டான். அவள் தன் வழியே போய் பெயெர்செபாவின் வனாந்திரத்தில் அலைந்து திரிந்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","தோல் குடுவையின் தண்ணீர் முடிந்ததும், அவள் புதர்ச்செடிகள் ஒன்றின்கீழ் தன் மகனை விட்டு, ");
INSERT INTO tamtcv_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","“பிள்ளை சாகிறதை என்னால் பார்க்க முடியாது” என்று சொல்லி அவன் இருக்கும் இடத்திலிருந்து ஒரு அம்பு பாயும் தூரத்தில் போய் உட்கார்ந்து, அவள் சத்தமாய் அழத்தொடங்கினாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","இறைவன் பிள்ளை அழும் சத்தத்தைக் கேட்டார், இறைவனின் தூதன் வானத்திலிருந்து ஆகாரைக் கூப்பிட்டு, “ஆகாரே, நடந்தது என்ன? பயப்படாதே; அங்கே உன் மகன் அழும் சத்தத்தை இறைவன் கேட்டார். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","அவனைத் தூக்கி, அவனைக் கையில் பிடித்துக்கொண்டு போ. அவனை ஒரு பெரிய நாடாக்குவேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","பின்பு இறைவன் அவளுடைய கண்களைத் திறந்தார், அப்போது அவள் தண்ணீருள்ள ஒரு கிணற்றைக் கண்டாள். அவள் தன் குடுவையில் நீரை நிரப்பி தன் மகனுக்குக் குடிக்கக் கொடுத்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","அவன் வளரும்போது இறைவன் அவனுடன் இருந்தார். அவன் பாலைவனத்தில் வசித்து, வில் வீரனானான். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","இஸ்மயேல் பாரான் பாலைவனத்தில் குடியிருக்கையில், அவனுடைய தாய் எகிப்தியப் பெண் ஒருத்தியை அவனுக்குத் திருமணம் செய்து கொடுத்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","அக்காலத்தில் அபிமெலேக்கும் அவனுடைய படைத்தளபதி பிகோலும் ஆபிரகாமிடம், “நீர் செய்யும் எல்லாவற்றிலும் இறைவன் உம்முடனேகூட இருக்கிறார். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","ஆகையால் நீர் எனக்கோ, என் பிள்ளைகளுக்கோ, எனது சந்ததிகளுக்கோ எவ்விதத் தீங்கும் செய்யமாட்டேன் என்று, இறைவனுக்குமுன் எனக்கு ஆணையிட்டுக்கொடும். நான் உமக்குத் தயவுகாட்டியதுபோல், எனக்கும் நீர் அந்நியனாய் வாழும் இந்நாட்டிற்கும் எப்பொழுதும் தயவுகாட்டும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","அதற்கு ஆபிரகாம், “அப்படியே ஆணையிட்டுக் கொடுக்கிறேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","பின்பு அபிமெலேக்கின் வேலைக்காரர் கைப்பற்றிய கிணற்றைப்பற்றி, ஆபிரகாம் அபிமெலேக்கிடம் முறையிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","அதற்கு அபிமெலேக்கு, “இதைச் செய்தவன் யாரென்று எனக்குத் தெரியாது. நீரும் எனக்கு இதை அறிவிக்கவில்லை; நான் இன்றுதான் இதைப்பற்றிக் கேள்விப்பட்டேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","அப்பொழுது ஆபிரகாம், செம்மறியாடுகளையும் மாடுகளையும் கொண்டுவந்து, அபிமெலேக்குக்குக் கொடுத்தான். அவர்கள் இருவரும் ஒரு உடன்படிக்கை செய்துகொண்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","ஆபிரகாம் ஏழு பெண் செம்மறியாட்டுக் குட்டிகளை மந்தையிலிருந்து பிரித்தெடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","அப்பொழுது அபிமெலேக்கு, “இந்த ஏழு செம்மறியாட்டுக் குட்டிகளையும் பிரித்து வைப்பதன் பொருள் என்ன?” என்று ஆபிரகாமைக் கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","அதற்கு ஆபிரகாம், “நானே இந்தக் கிணற்றை வெட்டினேன் என்பதற்குச் சாட்சியாக, நீர் இந்த ஏழு பெண் செம்மறியாட்டுக் குட்டிகளையும் என்னிடமிருந்து ஏற்றுக்கொள்ளவேண்டும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","அவர்கள் இருவரும் அந்த இடத்தில் ஆணையிட்டு உறுதியளித்தபடியால், அந்த இடம் பெயெர்செபா என்று அழைக்கப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","பெயெர்செபாவிலே உடன்படிக்கை செய்தபின், அபிமெலேக்கும் அவன் படைத்தளபதி பிகோலும், பெலிஸ்திய நாட்டிலுள்ள வீடுகளுக்குத் திரும்பிப் போனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","ஆபிரகாம் பெயெர்செபாவிலே தமரிஸ்கு மரத்தை நட்டு, அங்கே நித்திய இறைவனான யெகோவாவினுடைய பெயரைக் கூப்பிட்டு வழிபட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ஆபிரகாம் பெலிஸ்தியருடைய நாட்டில் அநேக நாட்கள் தங்கியிருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","சிறிது காலத்தின்பின் இறைவன், ஆபிரகாமைச் சோதித்தார். அவர், “ஆபிரகாமே!” என்று அவனைக் கூப்பிட்டார். அதற்கு அவன், “இதோ இருக்கிறேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","இறைவன் அவனிடம், “உன் மகனை, நீ நேசிக்கும் உன் ஒரே மகன் ஈசாக்கை, மோரியா பிரதேசத்திற்குக் கூட்டிக்கொண்டுபோ. அங்கே நான் உனக்குச் சொல்லும் மலைகள் ஒன்றின்மேல் அவனைத் தகன காணிக்கையாகப் பலியிடு” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","ஆபிரகாம் அடுத்தநாள் அதிகாலையில் எழுந்து, தன் கழுதைக்குச் சேணம் கட்டினான். அவன் தன் வேலைக்காரரில் இருவரையும் தன் மகன் ஈசாக்கையும் கூட்டிக்கொண்டுபோக ஆயத்தமானான். அதன்பின் தகனபலிக்கு வேண்டிய விறகுகளை வெட்டி எடுத்துக்கொண்டு, இறைவன் தனக்குக் குறிப்பிட்டிருந்த இடத்திற்குப் புறப்பட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","மூன்றாம் நாள் ஆபிரகாம் ஏறிட்டுப் பார்த்து, தூரத்தில் அந்த இடத்தைக் கண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","அப்பொழுது ஆபிரகாம் தன் வேலைக்காரரிடம், “நீங்கள் கழுதையுடன் இங்கே நில்லுங்கள்; நானும் என் மகனும் அவ்விடத்திற்குப் போய் வழிபாடு செய்துவிட்டு பின்பு, உங்களிடத்திற்குத் திரும்பிவருவோம்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","ஆபிரகாம் தகனபலிக்குரிய விறகுகளைத் தன் மகன் ஈசாக்கின்மேல் வைத்து, நெருப்பையும் கத்தியையும் தானே கொண்டுபோனான். அவர்கள் இருவரும் போய்க்கொண்டிருக்கும்போது, ");
INSERT INTO tamtcv_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ஈசாக்கு தன் தகப்பனாகிய ஆபிரகாமிடம், “அப்பா?” என்றான். ஆபிரகாம் அதற்குப் மறுமொழியாக, “என்ன மகனே?” என்றான். “விறகும் நெருப்பும் இருக்கின்றன, தகனபலிக்கான செம்மறியாட்டுக் குட்டி எங்கே?” என்று ஈசாக்கு கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","அதற்கு ஆபிரகாம், “என் மகனே, தகனபலிக்கான செம்மறியாட்டுக் குட்டியை இறைவனே நமக்குக் கொடுப்பார்” என்றான். அவர்கள் இருவரும் தொடர்ந்து சென்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","அவர்கள் இறைவன் குறித்த இடத்திற்கு வந்தபொழுது, ஆபிரகாம் ஒரு பலிபீடத்தைக் கட்டி, அதன்மேல் விறகுகளை அடுக்கினான். அவன் தன் மகன் ஈசாக்கைக் கட்டி, அவனைப் பலிபீடத்தில் உள்ள விறகின்மேல் கிடத்தினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","பின்பு ஆபிரகாம் தன் கையை நீட்டி தன் மகனை வெட்டுவதற்குக் கத்தியை எடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","அப்பொழுது யெகோவாவின் தூதனானவர் வானத்திலிருந்து, “ஆபிரகாம்! ஆபிரகாம்!” என்று அவனைக் கூப்பிட்டார். உடனே அவன், “இதோ இருக்கிறேன்” என்று பதிலளித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","அவர், “சிறுவன்மேல் கைவைக்காதே, அவனுக்கு ஒன்றும் செய்யாதே; நீ உன் மகனை, ஒரே மகன் என்றும் பாராமல், எனக்குப் பலியிட உடன்பட்டபடியால், நீ இறைவனுக்குப் பயந்து நடக்கிறவன் என்பதை நான் இப்போது அறிந்துகொண்டேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","ஆபிரகாம் நிமிர்ந்து பார்த்தபோது, முட்செடியில் கொம்புகள் சிக்குண்டிருந்த ஒரு செம்மறியாட்டுக் கடாவைக் கண்டான். அவன் அங்குபோய், அந்த செம்மறியாட்டுக் கடாவைப் பிடித்து தன் மகன் ஈசாக்கிற்குப் பதிலாக அதை இறைவனுக்குத் தகன காணிக்கையாகப் பலியிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","ஆபிரகாம் அந்த இடத்திற்கு யெகோவாயீரே எனப் பெயரிட்டான். அதனால், “யெகோவாவின் மலையில் கொடுக்கப்படும்” என இன்றுவரை சொல்லப்படுகிறது. ");
INSERT INTO tamtcv_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","யெகோவாவின் தூதனானவர் இரண்டாம் முறையும் வானத்திலிருந்து ஆபிரகாமைக் கூப்பிட்டு, ");
INSERT INTO tamtcv_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“நீ உன் மகனை, உன் ஒரே மகனைக் கொடுக்க மறுக்காமல் இதைச் செய்தபடியால், யெகோவா தம் பெயரில் ஆணையிட்டு அறிவிக்கிறதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","நான் நிச்சயமாய் உன்னை ஆசீர்வதித்து, உன் சந்ததியை வானத்தின் எண்ணற்ற நட்சத்திரங்களைப்போலவும், கடற்கரை மணலைப்போலவும் பெருகப்பண்ணுவேன். உன் சந்ததியினரோ அவர்களுடைய பகைவரின் பட்டணங்களைக் கைப்பற்றுவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","நீ எனக்குக் கீழ்ப்படிந்தபடியால், உன் சந்ததிகள் மூலம் பூமியின் எல்லா நாடுகளும் ஆசீர்வதிக்கப்படும்” என்கிறார், என்று சொன்னார். ");
INSERT INTO tamtcv_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","அதன்பின் ஆபிரகாம் தன் வேலைக்காரரிடம் திரும்பிச்சென்று, அவர்களுடன் பெயெர்செபாவுக்குப் போனான். ஆபிரகாம் பெயெர்செபாவிலே தங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","சிறிது காலத்திற்கு பின்பு, “மில்க்காளும் தாயாகி இருக்கிறாள்; உன் சகோதரனாகிய நாகோருக்கு அவள் மகன்களைப் பெற்றிருக்கிறாள் என்று ஆபிரகாமுக்குச் சொல்லப்பட்டது; அவர்கள்: ");
INSERT INTO tamtcv_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","அவள் தன் முதற்பேறான மகன் ஊஸ், அவன் சகோதரன் பூஸ், ஆராமின் தகப்பனான கேமுயேல், ");
INSERT INTO tamtcv_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","கேசேத், ஆசோ, பில்தாஸ், இத்லாப், பெத்துயேல்” என ஆபிரகாமுக்கு அறிவிக்கப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","பெத்துயேல் ரெபெக்காளுக்குத் தகப்பன் ஆனான். மில்க்காள் இந்த எட்டு மகன்களையும் ஆபிரகாமின் சகோதரன் நாகோருக்குப் பெற்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ரேயுமாள் என்னும் நாகோரின் வைப்பாட்டியும் தேபா, காஹாம், தாகாஷ், மாகா என்னும் நான்கு மகன்களைப் பெற்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","சாராள் நூற்று இருபத்தேழு வயதுவரை உயிரோடிருந்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","அவள் கானானில் எப்ரோன் என்று அழைக்கப்பட்ட, கீரியாத் அர்பா என்னும் ஊரில் இறந்தாள்; அங்கே ஆபிரகாம் சாராளுக்காகத் துக்கித்து, அழுது புலம்பினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","அதன்பின்பு ஆபிரகாம், இறந்த தன் மனைவியின் அருகிலிருந்து எழுந்து, ஏத்தியருடன் பேசினான். அவன் அவர்களிடம், ");
INSERT INTO tamtcv_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“நான் இங்கு உங்கள் மத்தியில் அந்நியனும், வெளிநாட்டவனுமாய் இருக்கிறேன். இறந்த என் மனைவியைப் புதைப்பதற்கான ஒரு நிலத்தை விலைக்குத் தாருங்கள்” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","அதற்கு ஏத்திய மக்கள் ஆபிரகாமிடம், ");
INSERT INTO tamtcv_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“ஐயா, நாங்கள் சொல்வதைக் கேளும். நீர் எங்கள் மத்தியில் வல்லமையுள்ள பிரபுவாய் இருக்கிறீர். எங்கள் கல்லறைகளில் நீர் விரும்பும் சிறந்த கல்லறை ஒன்றில் உமது மனைவியை அடக்கம்பண்ணும். நீர் அடக்கம்பண்ணுவதற்கு எங்களில் ஒருவனும் தன் கல்லறையைத் தர மறுக்கமாட்டான்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","அப்பொழுது ஆபிரகாம் எழுந்து, அந்த நாட்டு மக்களான ஏத்தியருக்கு முன்பாகத் தலைவணங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","அவன் அவர்களிடம், “இறந்த என் மனைவியை இங்கு அடக்கம்பண்ணுவதற்கு அனுமதிக்க உங்களுக்குச் சம்மதமானால், நான் சொல்வதை நீங்கள் கேளுங்கள். சோகாரின் மகன் எப்ரோனிடம் எனக்காகப் பரிந்துபேசுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","அவனுடைய நிலத்தின் எல்லையில், அவனுக்குச் சொந்தமாக இருக்கும் மக்பேலா என்னும் குகையை எனக்கு விற்கும்படி சொல்லுங்கள். அது உங்கள் மத்தியில் என் குடும்பத்தின் புதைக்கும் இடமாக இருக்க, அதை முழு விலைக்கு எனக்கு விற்கும்படி கேளுங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","அப்பொழுது ஏத்தியனான எப்ரோன் தன் மக்கள் மத்தியில் உட்கார்ந்திருந்தான்; அவன் தன் பட்டண வாசலுக்கு வந்திருந்த ஏத்தியர் அனைவரும் கேட்கத்தக்கதாக ஆபிரகாமுக்குப் பதிலளித்து, ");
INSERT INTO tamtcv_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“இல்லை ஐயா, நான் சொல்வதைக் கேளும்; நீர் கேட்கும் நிலத்தையும், அதிலுள்ள குகையையும் என் மக்கள் முன்னிலையில் உமக்குச் சொந்தமாகத் தருகிறேன். உமது இறந்த மனைவியை அதிலே அடக்கம்பண்ணும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","ஆபிரகாம் அந்நாட்டு மக்களுக்கு மறுபடியும் வணக்கம் செலுத்தி, ");
INSERT INTO tamtcv_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","அவர்கள் கேட்கும்படியாக எப்ரோனிடம், “விரும்பினால் நான் சொல்வதைக் கேளும், நிலத்தின் மதிப்பை நான் உமக்குக் தருகிறேன். இறந்த என் மனைவியை நான் அங்கு அடக்கம்பண்ணும்படி பணத்தை என்னிடமிருந்து ஏற்றுக்கொள்ளும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","அதற்கு எப்ரோன் ஆபிரகாமிடம், ");
INSERT INTO tamtcv_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“ஐயா, நான் சொல்வதைக் கேளும்; அந்த நிலம் நானூறு சேக்கல் வெள்ளி மதிப்பாகும். ஆனால் எனக்கும் உமக்கும் இடையில் அது எம்மாத்திரம்? நீர் உமது இறந்த மனைவியை இந்த நிலத்தில் அடக்கம் செய்யும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","ஏத்தியருக்குக் கேட்கத்தக்கதாக எப்ரோன் சொன்ன விலைக்கு ஆபிரகாம் சம்மதித்தான். அவன் வியாபாரிகளின் நடைமுறையில் இருந்த எடையின்படி, நானூறு சேக்கல் வெள்ளியை நிறுத்து அவனுக்குக் கொடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","இவ்வாறு மம்ரேக்கு அருகே மக்பேலாவிலுள்ள எப்ரோனின் வயல், அதாவது வயலும் அதிலுள்ள குகையும், அதன் எல்லைகளுக்குட்பட்ட மரங்களும் விற்கப்பட்டன. ");
INSERT INTO tamtcv_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","அது ஆபிரகாமின் சொத்தாக, பட்டணத்தின் வாசலுக்குள் வந்த எல்லா ஏத்தியருக்கு முன்பாகவும் உறுதிப்படுத்தப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","அதற்குப்பின் ஆபிரகாம் கானான் நாட்டில், எப்ரோனிலுள்ள மம்ரேக்கு அருகே, மக்பேலா வயலில் உள்ள குகையில் தன் மனைவி சாராளை அடக்கம் செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","இவ்வாறு அந்த வயலும், அதிலுள்ள குகையும் ஆபிரகாமுக்குச் சொந்தமான அடக்க நிலமாக ஏத்தியரால் உறுதிப்படுத்தப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ஆபிரகாம் இப்பொழுது வயது முதிர்ந்தவன் ஆனான்; யெகோவா எல்லாவிதத்திலும் அவனை ஆசீர்வதித்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","ஆபிரகாம் தன் வீட்டிலுள்ள யாவற்றுக்கும் பொறுப்பாயிருந்த தலைமைப் பணியாளனிடம், “நீ என் தொடையின்கீழ் உன் கையை வைத்து, ");
INSERT INTO tamtcv_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","பரலோகத்துக்கு இறைவனும், பூமிக்கு இறைவனுமாகிய யெகோவாவின் பெயரால் எனக்குச் சத்தியம் செய்யவேண்டும். நான் கானானியர் மத்தியில் வாழ்வதால் அவர்களுடைய மகள்களில் ஒருத்தியையும் என் மகனுக்கு மனைவியாக நீ எடுக்கமாட்டாய் என்றும், ");
INSERT INTO tamtcv_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","என் நாட்டிற்கும், என் உறவினரிடத்திற்கும் போய், என் மகன் ஈசாக்கிற்கு ஒரு மனைவியை எடுப்பாய் என்றும் சத்தியம் செய்யவேண்டும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","அப்பொழுது அவ்வேலைக்காரன், “நான் தெரிந்தெடுக்கும் பெண் என்னுடன் வர விரும்பவில்லையென்றால், உம்முடைய மகன் ஈசாக்கை நீர் விட்டுவந்த நாட்டுக்கு அழைத்துப் போகவேண்டுமோ?” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","அதற்கு ஆபிரகாம், “என் மகனை திரும்பவும் அவ்விடத்திற்கு அழைத்துப் போகாதபடி கவனமாயிரு. ");
INSERT INTO tamtcv_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","என் தகப்பன் வீட்டிலிருந்தும், நான் பிறந்த நாட்டிலிருந்தும் என்னை அழைத்த பரலோகத்தின் இறைவனாகிய யெகோவா, என்னிடம் பேசி, எனக்கு ஆணையிட்டு, ‘உனக்கும் உன் சந்ததிக்கும் இந்நாட்டைக் கொடுப்பேன்’ என்று வாக்களித்திருக்கிறார். ஆதலால் அவர், நீ அங்கிருந்து என் மகனுக்கு ஒரு பெண்ணைக் கொண்டுவர உனக்கு முன்பாக தமது தூதனை அனுப்புவார். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","அந்தப் பெண் இவ்விடம் வர விரும்பவில்லையென்றால், நீ எனக்குச் செய்து கொடுத்த ஆணையிலிருந்து விடுபடுவாய். என் மகனை மட்டும் அங்கே அழைத்துக்கொண்டு போகாதே” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","அப்படியே அவ்வேலைக்காரன் தன் கையை தன் எஜமான் ஆபிரகாமின் தொடையின்கீழ் வைத்து, அவன் இந்தக் காரியத்தைக்குறித்து ஆணையிட்டுச் சத்தியம் செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","பின்பு அவ்வேலைக்காரன் ஆபிரகாமிடமிருந்து எல்லா வகையான நல்ல பொருட்களையும், அவனுடைய பத்து ஒட்டகங்கள்மீது ஏற்றிக்கொண்டு போனான். அவன் மெசொப்பொத்தாமியா வழியாகப்போய், நாகோர் பட்டணத்தை வந்தடைந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","அவன் பட்டணத்திற்கு வெளியே இருந்த ஒரு கிணற்றருகே தன் ஒட்டகங்களுக்குத் தண்ணீர் கொடுப்பதற்காக மண்டியிடச் செய்தான்; அது பெண்கள் தண்ணீர் எடுக்கவரும் மாலை வேளையாக இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","அப்பொழுது அவன், “யெகோவாவே, என் எஜமான் ஆபிரகாமின் இறைவனே, இன்று எனக்கு வெற்றியைத் தந்து, என் எஜமான் ஆபிரகாமுக்கு இரக்கம் காட்டும். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","இதோ நான் இந்த நீரூற்றண்டையில் நிற்கிறேன், இந்த நகரத்து மக்களின் இளம்பெண்கள் தண்ணீர் மொள்ள வருகிறார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","நான் இங்கு வரும் ஒரு பெண்ணிடம், ‘உன் குடத்தைச் சரித்து நான் குடிக்கும்படி தண்ணீர் ஊற்று’ என்று சொல்வேன். அப்பொழுது, ‘குடியும், உமது ஒட்டகங்களுக்கும் தண்ணீர் ஊற்றுவேன்’ என்று சொல்கிறவள் எவளோ, அவளே உமது அடியானாகிய ஈசாக்குக்கு நீர் தெரிந்துகொண்ட பெண்ணாயிருக்கட்டும். இதனால் என் எஜமான் ஆபிரகாமுக்கு இரக்கம் காட்டினீர் என்பதை நான் அறிந்துகொள்வேன்” என்று மன்றாடினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","அவன் மன்றாடி முடிக்குமுன்பே, ரெபெக்காள் தன் குடத்தைத் தோளில் வைத்தபடி வந்தாள். அவள் ஆபிரகாமின் சகோதரன் நாகோருக்கும், அவன் மனைவி மில்க்காளுக்கும் மகனான பெத்துயேலின் மகள். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","அவள் மிகவும் அழகுடையவளும், ஒருவனுடனும் உறவுகொள்ளாத கன்னியாகவும் இருந்தாள். அவள் நீரூற்றண்டைக்குப் போய் தன் குடத்தை நிரப்பிக்கொண்டு மேலே ஏறிவந்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","வேலைக்காரன் அவளை சந்திக்கும்படி விரைந்து, “தயவுசெய்து உன் குடத்திலிருந்து எனக்குக் கொஞ்சம் தண்ணீர் கொடு” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","உடனே அவள், “ஐயா, குடியுங்கள்” என்று சொல்லி, குடத்தை விரைவாய் இறக்கிக் கையில் பிடித்து, அவனுக்குக் குடிக்கக் கொடுத்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","அவள் அவனுக்குக் குடிக்கக் கொடுத்தபின், “உமது ஒட்டகங்கள் குடித்துத் தீருமட்டும் அவைகளுக்கும் தண்ணீர் இறைத்துக் கொடுப்பேன்” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","அவள் தன் குடத்திலிருந்த தண்ணீரை விரைவாய்த் தொட்டிக்குள் ஊற்றிவிட்டு, மேலும் தண்ணீர் இறைப்பதற்காக ஊற்றண்டைக்கு ஓடினாள். அவனுடைய ஒட்டகங்களுக்குப் போதுமான அளவு தண்ணீரை இறைத்து ஊற்றினாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","யெகோவா தான் வந்த பயணத்தை வெற்றியடையச் செய்தாரோ இல்லையோ என்று அறிவதற்காக, அவன் ஒன்றும் பேசாமல் அவளைக் கூர்ந்து கவனித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ஒட்டகங்கள் தண்ணீர் குடித்து முடிந்தபின், அந்த மனிதன் ஒரு பெக்கா நிறையுள்ள தங்க மூக்குத்தியையும், பத்து சேக்கல் நிறையுள்ள இரண்டு தங்க வளையல்களையும் அவளுக்குக் கொடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","பின்பு அவளிடம், “நீ யாருடைய மகள்? இரவு தங்குவதற்காக உன் தகப்பன் வீட்டில் எங்களுக்கு இடமுண்டா? தயவுசெய்து எனக்குச் சொல்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","அவள் அவனுக்குப் பதிலளித்து, “நான், நாகோருக்கு மில்க்காள் பெற்ற மகனான பெத்துயேலின் மகள்” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","மேலும் அவள், “எங்களிடத்தில் வைக்கோலும், ஒட்டகத்திற்குத் தீனியும் வேண்டியளவு இருக்கின்றன. உங்களுக்கு இரவில் தங்குவதற்கு இடமும் உண்டு” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","உடனே அந்த வேலைக்காரன் தலைதாழ்த்தி யெகோவாவை வழிபட்டு, ");
INSERT INTO tamtcv_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“என் எஜமான் ஆபிரகாமின் இறைவனாகிய யெகோவாவுக்குத் துதி உண்டாகட்டும். என் எஜமானுக்கு அவர் தமது இரக்கத்தையும் உண்மையையும் காட்டாமல் இருக்கவில்லை. யெகோவா என்னையோ, என் எஜமானின் உறவினர் வீட்டுக்கே வழிநடத்தி வந்திருக்கிறார்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","அப்பெண் ஓடிப்போய், நடந்தவற்றைத் தன் தாயின் வீட்டாரிடம் சொன்னாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","ரெபெக்காளுக்கு லாபான் என்னும் பெயருடைய ஒரு சகோதரன் இருந்தான். அவன் நீரூற்றருகே நின்ற அம்மனிதனிடம் விரைந்து போனான். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","லாபான் தன் சகோதரியின் மூக்குத்தியையும், கைகளிலிருந்த வளையல்களையும் கண்டான். அத்துடன் அம்மனிதன் சொன்னவற்றையும் ரெபெக்காள் சொல்லக் கேட்டவுடனே, லாபான் போய் நீரூற்றின் அருகே அம்மனிதன் ஒட்டகங்கள் அண்டையில் நிற்கக் கண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","அவன் அந்த மனிதனிடம், “யெகோவாவினால் ஆசீர்வதிக்கப்பட்டவரே, வாரும்; நீர் ஏன் இங்கே வெளியே நிற்கிறீர்? உமக்காக வீட்டையும், ஒட்டகங்களுக்கு இடத்தையும் ஆயத்தப்படுத்தியிருக்கிறேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","இதனால் அந்த மனிதன் லாபானுடன் வீட்டிற்குப் போனான், ஒட்டகங்களின் சுமைகள் இறக்கப்பட்டன. ஒட்டகங்களுக்கு வைக்கோலும் தீனியும் கொண்டுவரப்பட்டன. பின்பு அம்மனிதனுக்கும் அவனோடு வந்தவர்களுக்கும் கால்களைக் கழுவத் தண்ணீர் கொண்டுவரப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","அதன்பின்பு அவனுக்கு முன்பாக உணவு வைக்கப்பட்டது. ஆனால் அவனோ, “நான் சொல்ல வேண்டியதைச் சொல்லி முடிக்கும்வரை சாப்பிடமாட்டேன்” என்றான். அதற்கு லாபான், “அப்படியானால் அதை எங்களுக்குச் சொல்லும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","அதற்கு அவன், “நான் ஆபிரகாமின் வேலைக்காரன்.” ");
INSERT INTO tamtcv_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","யெகோவா என் எஜமானை நிறைவாக ஆசீர்வதித்ததினால், அவர் செல்வந்தனாக இருக்கிறார். யெகோவா அவருக்கு அநேக செம்மறியாடுகளையும், மாடுகளையும், ஒட்டகங்களையும், கழுதைகளையும், வேலைக்காரர்களையும், வேலைக்காரிகளையும், வெள்ளியையும், தங்கத்தையும் கொடுத்திருக்கிறார். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","என் எஜமானின் மனைவி சாராள் தன் முதிர்வயதில் அவருக்கு ஒரு மகனைப் பெற்றாள், அவர் தமக்குச் சொந்தமான எல்லாவற்றையும் தன் மகனுக்கே கொடுத்திருக்கிறார். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","என் எஜமான் என்னை ஆணையிட்டுச் சத்தியம் செய்யப்பண்ணி, “நான் வசிக்கும் நாட்டிலுள்ள கானானியரின் மகள்களில் இருந்து, நீ என் மகனுக்கு மனைவியை எடுக்கக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ஆனால் என் தகப்பன் குடும்பத்திற்கும், என் சொந்த வம்சத்திற்கும் போய் என் மகனுக்கு ஒரு மனைவியை எடுக்கவேண்டும்” என்று என்னிடம் சொன்னார். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“அப்பொழுது நான் என் எஜமானிடம், ‘அந்தப் பெண் என்னுடன் வரச் சம்மதியாவிட்டால் என்ன செய்வது?’ எனக் கேட்டேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“அதற்கு அவர், ‘நான் யெகோவாவுக்குமுன் உண்மையாய் நடக்கிறேன், அவர் தமது தூதனை உன்னுடன் அனுப்பி, உன்னுடைய பயணத்தை வெற்றியடையப் பண்ணுவார். என் தகப்பனின் குடும்பத்தைச் சேர்ந்த என் சொந்த வம்சத்திலிருந்தே, நீ என் மகனுக்கு ஒரு பெண்ணை எடுப்பாய். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","நீ என் வம்சத்தாரிடம் போகும்போது, என் ஆணையிலிருந்து விடுபடுவாய்; அவர்கள் பெண் கொடுக்க மறுத்தாலும், நீ எனக்குக் கொடுத்த ஆணையிலிருந்து விடுபடுவாய்’ என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“இன்று நான் நீரூற்றருகே வந்தபோது, ‘யெகோவாவே, என் எஜமான் ஆபிரகாமின் இறைவனே, உமக்கு விருப்பமானால் நான் வந்த பயணத்தை வெற்றியடையச் செய்யும். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","இதோ, நான் இந்த நீரூற்றருகே நிற்கிறேன். தண்ணீர் எடுப்பதற்காக ஒரு இளம்பெண் வருவாளானால், நான் அவளிடம், “உன் குடத்திலிருந்து குடிக்கக் கொஞ்சம் தண்ணீர் தா” என்று கேட்பேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","அதற்கு அவள், “குடியும், உமது ஒட்டகங்களுக்கும் தண்ணீர் இறைத்துக் கொடுப்பேன்” என்று சொல்வாளானால், அவளே என் எஜமானின் மகனுக்கு யெகோவா நியமித்த பெண்ணாயிருக்கட்டும்’ என்று மன்றாடினேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“இவ்வாறு நான் என் இருதயத்தில் மன்றாடி முடிக்குமுன்னே, ரெபெக்காள் தன் குடத்தைத் தோளில் வைத்தபடி வந்து, நீருற்றுக்குப் போய் தண்ணீர் இறைத்தாள். அப்பொழுது நான் அவளிடம், ‘எனக்குக் குடிக்கத் தண்ணீர் தா’ என்று கேட்டேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“அவள் விரைவாக தன் தோளிலிருந்த குடத்தை இறக்கி, ‘குடியும், உமது ஒட்டகங்களுக்கும் தண்ணீர் கொடுப்பேன்’ என்று சொன்னாள். அப்படியே நான் குடித்தேன், என் ஒட்டகங்களுக்கும் அவள் தண்ணீர் கொடுத்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“அப்பொழுது நான் அவளிடம், ‘நீ யாருடைய மகள்?’ என்று கேட்டேன். “அதற்கு அவள், ‘நாகோருக்கு மில்க்காள் பெற்ற மகனான, பெத்துயேலின் மகள்’ என்றாள். “அப்பொழுது நான் அவளுக்கு மூக்குத்தியையும் வளையல்களையும் கொடுத்தேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","பின்பு நான் தலைகுனிந்து, யெகோவாவை வழிபட்டேன். என் எஜமான் ஆபிரகாமின் இறைவனைத் துதித்தேன்; என் எஜமானின் சகோதரனுடைய பேத்தியை அவருடைய மகனுக்கு மனைவியாக எடுக்க, சரியான வழியில் என்னை நடத்திய யெகோவாவைத் துதித்தேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ஆகவே, நீங்கள் என் எஜமானுக்குத் தயவாகவும், உண்மையாகவும் நடக்க விரும்பினால் எனக்குச் சொல்லுங்கள்; இல்லையென்றால் அதையும் எனக்குச் சொல்லுங்கள், அப்பொழுது எப்பக்கம் திரும்பவேண்டும் என்பதை நான் அறிந்துகொள்வேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","அதற்கு லாபானும் பெத்துயேலும், “இது யெகோவாவினால் வந்திருக்கிறது; இதில் நாங்கள் குறுக்கிட்டு ஒன்றுமே சொல்லமுடியாது. ");
INSERT INTO tamtcv_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","ரெபெக்காள் இதோ இருக்கிறாள்; அவளை நீ கூட்டிக்கொண்டுபோ, யெகோவா நடத்தியபடியே இவள் உனது எஜமானின் மகனுக்கு மனைவியாகட்டும்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ஆபிரகாமின் வேலைக்காரன் அவர்கள் சொன்னதைக் கேட்டதும், யெகோவாவுக்கு முன்பாக தரைமட்டும் குனிந்து வழிபட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","அதன்பின் அந்த வேலைக்காரன் தங்கம் மற்றும் வெள்ளி நகைகளையும், உடை வகைகளையும் கொண்டுவந்து ரெபெக்காளுக்குக் கொடுத்தான். அவளது சகோதரனுக்கும், தாய்க்கும் பெரும் மதிப்புமிக்க அன்பளிப்புகளைக் கொடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","பின்பு அவனும் அவனோடு வந்த மனிதர்களும் சாப்பிட்டுக் குடித்து, அன்றிரவு அங்கே தங்கினார்கள். மறுநாள் காலையில் அவன் எழுந்ததும், “என் எஜமானிடத்திற்கு என்னை வழியனுப்பி வையுங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","ஆனால் ரெபெக்காளின் சகோதரனும், தாயும், “பத்து நாட்களுக்காவது பெண் எங்களுடன் தங்கியிருக்கட்டும்; அதன்பின் போகலாம்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","அதற்கு அவன், “யெகோவா என் பயணத்தின் நோக்கத்தை நிறைவேறச் செய்தபடியால், என்னைத் தடைசெய்ய வேண்டாம். என் எஜமானிடம் நான் போவதற்கு என்னை வழியனுப்பி வையுங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","அப்பொழுது அவர்கள், “நாம் பெண்ணைக் கூப்பிட்டு இதைப்பற்றி அவளிடம் கேட்போம்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","பின் ரெபெக்காளைக் கூப்பிட்டு, “நீ இந்த மனிதனுடன் போகிறாயா?” என்று கேட்டார்கள். அதற்கு அவள், “ஆம் போகிறேன்” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","எனவே அவர்கள், தமது சகோதரி ரெபெக்காளை, அவளது தாதியோடும், ஆபிரகாமின் வேலைக்காரனோடும், அவனுடன் வந்த மனிதரோடும் வழியனுப்பி வைத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","அவர்கள் ரெபெக்காளை ஆசீர்வதித்து சொன்னது: “எங்கள் சகோதரியே, நீ ஆயிரம் பதினாயிரமாய்ப் பெருகுவாயாக; உன் சந்ததியினர் தங்கள் பகைவரின் பட்டண வாசல்களைத் தங்கள் உரிமையாக்கிக் கொள்வார்களாக.” ");
INSERT INTO tamtcv_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","பின்பு ரெபெக்காளும் அவள் தோழியரும் ஆயத்தமாகி, தங்கள் ஒட்டகங்களில் ஏறி, அந்த மனிதருடன் போனார்கள். இவ்விதம் அந்த வேலைக்காரன் ரெபெக்காளை அழைத்துக்கொண்டு புறப்பட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","அந்நாட்களில் ஈசாக்கு பீர்லகாய்ரோயீ என்ற இடத்திலிருந்து வந்து, நெகேவ் பகுதியில் தங்கியிருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ஒரு மாலை நேரத்தில் தியானம் செய்வதற்காக ஈசாக்கு வெளியே வயலுக்குப் போனான். அவன் நிமிர்ந்து பார்த்தபோது, ஒட்டகங்கள் வருவதைக் கண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","ரெபெக்காளும் நிமிர்ந்து பார்த்து, ஈசாக்கைக் கண்டாள். உடனே அவள் ஒட்டகத்திலிருந்து கீழே இறங்கினாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","அவள் அந்த வேலைக்காரனிடம், “நம்மைச் சந்திக்கும்படி வயல்வெளியில் வந்துகொண்டிருக்கும் அம்மனிதன் யார்?” என்று கேட்டாள். அதற்கு அவன், “அவர்தான் என் எஜமான்” என்றான். உடனே அவள் முகத்திரையை எடுத்துத் தன்னை மூடிக்கொண்டாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","வேலைக்காரன் தான் செய்த எல்லாவற்றையும் ஈசாக்கிடம் சொன்னான். ");
INSERT INTO tamtcv_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ஈசாக்கு ரெபெக்காளைத் தன் தாய் சாராளின் கூடாரத்திற்குக் கூட்டிக்கொண்டுவந்து, அவளைத் திருமணம் செய்தான். அவள் அவனுக்கு மனைவியானாள், அவன் அவளை நேசித்தான். தன் தாயின் மரணத்திற்குப்பின் அவனுக்குத் துக்கத்திலிருந்து இப்படி ஆறுதல் கிடைத்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","ஆபிரகாம் கேத்தூராள் என்னும் பெயருடைய இன்னொரு பெண்ணைத் திருமணம் செய்திருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","அவள் ஆபிரகாமுக்குச் சிம்ரான், யக்க்ஷான், மேதான், மீதியான், இஸ்பாக், சூவா என்னும் மகன்களைப் பெற்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","யக்க்ஷான் என்பவன் சேபா, தேதான் ஆகியோரின் தகப்பன். தேதானின் சந்ததிகள் அசூரிம், லெத்தூசீம், லெயூமீம் ஆகியோர். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","ஏப்பா, ஏப்பேர், ஆனோக்கு, அபிதா, எல்தாகா என்பவர்கள் மீதியானின் மகன்கள். இவர்கள் அனைவரும் கேத்தூராளின் சந்ததிகள். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","ஆபிரகாம் தனக்குரிய யாவற்றையும் ஈசாக்கிற்குக் கொடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ஆனால் அவன் உயிரோடிருக்கும்போதே, ஆபிரகாம் தன் வைப்பாட்டிகளின் மகன்களுக்கு அன்பளிப்புகளைக் கொடுத்து, தன் மகன் ஈசாக்கிடமிருந்து விலக்கி, அவர்களைக் கிழக்கு நாட்டுக்கு அனுப்பிவிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","ஆபிரகாம் நூற்று எழுபத்தைந்து வருடங்கள் வாழ்ந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","ஆபிரகாம் பூரண ஆயுசுள்ள கிழவனாய், நல்ல முதிர்வயதில் தன் இறுதி மூச்சைவிட்டு இறந்து, தன் முன்னோருடன் சேர்க்கப்பட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","அவனுடைய மகன்களான ஈசாக்கும் இஸ்மயேலும் ஏத்தியனான சோகாரின் மகன் எப்ரோனின் வயலில், மம்ரேக்கு அருகேயுள்ள மக்பேலா எனப்படும் குகையில் அவனை அடக்கம்பண்ணினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","அந்த வயலை ஆபிரகாம் ஏத்தியரிடமிருந்து வாங்கியிருந்தான். அங்கே ஆபிரகாம் அவன் மனைவி சாராளுடன் அடக்கம்பண்ணப்பட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ஆபிரகாம் இறந்தபின் அவனுடைய மகன் ஈசாக்கை இறைவன் ஆசீர்வதித்தார். அப்போது அவன், பீர்லகாய்ரோயீ என்ற இடத்திற்கு அருகில் குடியிருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","சாராளின் பணிப்பெண்ணான எகிப்தியப் பெண் ஆகார், ஆபிரகாமுக்குப் பெற்ற மகன் இஸ்மயேலின் வம்சவரலாறு இதுவே: ");
INSERT INTO tamtcv_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","பிறப்பின் வரிசைப்படி இஸ்மயேலின் மகன்களின் பெயர்களாவன: நெபாயோத் இஸ்மயேலின் மூத்த மகன். பின்பு கேதார், அத்பியேல், மிப்சாம், ");
INSERT INTO tamtcv_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","மிஷ்மா, தூமா, மாசா, ");
INSERT INTO tamtcv_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ஆதாத், தேமா, யெத்தூர், நாபீஸ், கேத்மா. ");
INSERT INTO tamtcv_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ஆகியோரும் இஸ்மயேலின் மகன்களாவர். அவர்களுடைய குடியிருப்புகளின்படியும், முகாம்களின்படியும் பன்னிரண்டு கோத்திர ஆளுநர்களின் பெயர்களும் இவையே. ");
INSERT INTO tamtcv_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","இஸ்மயேல் நூற்று முப்பத்தேழு வருடங்கள் வாழ்ந்தான். அவன் தன் இறுதி மூச்சைவிட்டு இறந்து, தன் முன்னோருடன் சேர்க்கப்பட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","அவனுடைய சந்ததிகள் ஆவிலா தொடங்கி, சூர் வரைக்கும் குடியிருந்தார்கள். அது அசீரியாவுக்குப் போகிற வழியில் எகிப்தின் எல்லைக்கு அருகேயிருந்தது. அவர்கள் தங்கள் சகோதரர் எல்லோருடனும் பகைமையுடனேயே வாழ்ந்துவந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","ஆபிரகாமின் மகன் ஈசாக்கின் வம்சவரலாறு இதுவே: ஆபிரகாம் ஈசாக்கின் தகப்பன் ஆனான். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ஈசாக்கு ரெபெக்காளைத் திருமணம் செய்தபோது, நாற்பது வயதுடையவனாய் இருந்தான். ரெபெக்காள் பதான் அராமில் வாழ்ந்துவந்த அரமேயி தேசத்தானாகிய பெத்துயேலின் மகளும், லாபானின் சகோதரியுமாவாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","தன் மனைவி மலடியாய் இருந்தபடியால், ஈசாக்கு யெகோவாவிடத்தில் அவளுக்காக மன்றாடினான். யெகோவா அவன் மன்றாட்டைக் கேட்டார். அவன் மனைவி ரெபெக்காள் கர்ப்பவதியானாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","அவள் வயிற்றிலிருந்த குழந்தைகள் ஒன்றோடொன்று மோதிக்கொண்டன. அப்பொழுது அவள், “எனக்கு ஏன் இப்படி நடக்கிறது?” என்று சொல்லி, யெகோவாவிடம் விசாரிக்கப் போனாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","அப்பொழுது யெகோவா ரெபெக்காளிடம் சொன்னது: “உன் கர்ப்பத்தில் இரண்டு தேசங்கள் இருக்கின்றன; உன் வயிற்றிலிருந்து இரண்டு மக்கள் கூட்டங்கள் பிரிக்கப்படும். ஒரு மக்கள் கூட்டம் மற்றதைவிட வலிமையுள்ளதாய் இருக்கும், மூத்தவன் இளையவனுக்குப் பணிசெய்வான்.” ");
INSERT INTO tamtcv_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","பிரசவகாலம் வந்தபோது, அவள் கருப்பையில் இரட்டை ஆண் குழந்தைகள் இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","முதலில் பிறந்த குழந்தை சிவந்த நிறமும், அதன் முழு உடலும் உரோமம் நிறைந்ததாயும் இருந்தது. ஆகவே அவனுக்கு ஏசா என்று பெயரிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","அதன்பின் அவனுடைய சகோதரன், தன் கையினால் ஏசாவின் குதிங்காலைப் பிடித்துக்கொண்டு வெளியே வந்தான். அதனால் அவன் யாக்கோபு என்று பெயரிடப்பட்டான். ரெபெக்காள் இவர்களைப் பெற்றபோது ஈசாக்கு அறுபது வயதுடையவனாயிருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","அச்சிறுவர்கள் வளர்ந்தபோது, ஏசா வேட்டையில் திறமையுள்ளவனாயும், காடுகளில் தங்குபவனாயும் இருந்தான். ஆனால் யாக்கோபோ, பண்புள்ளவனாய் கூடாரங்கள் மத்தியில் வாழ்ந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","வேட்டையாடும் இறைச்சியை விரும்பிய ஈசாக்கு, ஏசாவை நேசித்தான். ஆனால் ரெபெக்காளோ யாக்கோபை நேசித்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ஒரு நாள் யாக்கோபு கூழ் காய்ச்சிக் கொண்டிருக்கும்போது, ஏசா காட்டு வெளியிலிருந்து மிகவும் களைத்தவனாக வந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","அப்பொழுது அவன் யாக்கோபிடம், “நான் களைத்துப் போயிருக்கிறேன்! சீக்கிரமாய் அந்தச் சிவப்புக் கூழில் எனக்குக் கொஞ்சம் தா!” என்று கேட்டான். அதினாலேயே ஏசாவுக்கு ஏதோம் என்கிற பெயர் உண்டாயிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","யாக்கோபோ அவனிடம், “நீ முதலில் உனது மூத்த மகனுக்குரிய பிறப்புரிமையை எனக்கு விற்று விடு” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","அதற்கு ஏசா, “என்னைப் பார், நான் சாகப்போகிறேன். இந்த மூத்த மகனுக்குரிய பிறப்புரிமையினால் எனக்கு என்ன பயன்?” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","ஆனால் யாக்கோபு ஏசாவிடம், “முதலில் எனக்கு சத்தியம் செய்துகொடு” என்றான். அவ்வாறே ஏசா ஆணையிட்டுச் சத்தியம் செய்து, தன் மூத்த மகனுக்குரிய பிறப்புரிமையை யாக்கோபுக்கு விற்றுப்போட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","அதன்பின் யாக்கோபு ஏசாவுக்குக் கொஞ்சம் அப்பமும், பயற்றங்கூழும் கொடுத்தான். அவன் அதைச் சாப்பிட்டுக் குடித்து எழுந்து போய்விட்டான். இப்படியாக ஏசா தனக்குரிய மூத்த மகனுக்குரிய பிறப்புரிமையை உதாசீனம் செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ஆபிரகாம் காலத்திலிருந்த பஞ்சத்தைவிட நாட்டில் இன்னுமொரு பஞ்சம் உண்டானது. அதனால் ஈசாக்கு கேராரிலுள்ள பெலிஸ்திய அரசனான அபிமெலேக்கிடம் போனான். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","அப்பொழுது யெகோவா ஈசாக்கிற்குத் தோன்றி, “நீ எகிப்திற்குப் போகவேண்டாம்; நான் உன்னைக் குடியிருக்கச் சொல்லும் நாட்டில் குடியிரு. ");
INSERT INTO tamtcv_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","சிறிதுகாலம் இந்நாட்டில் தங்கியிரு, நான் உன்னுடன் இருந்து உன்னை ஆசீர்வதிப்பேன். இந்த நாடுகள் எல்லாவற்றையும் உனக்கும் உன் சந்ததிக்கும் தந்து, நான் உன் தகப்பன் ஆபிரகாமுக்கு ஆணையிட்டுக்கொடுத்த சத்தியத்தை உறுதிப்படுத்துவேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","நான் உன் சந்ததியை வானத்து நட்சத்திரங்களைப்போல் பெருகப்பண்ணி, இந்நாடுகள் எல்லாவற்றையும் அவர்களுக்குக் கொடுப்பேன். உன் சந்ததியின் மூலமாக பூமியில் உள்ள எல்லா நாடுகளும் ஆசீர்வதிக்கப்படும். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ஏனெனில், ஆபிரகாம் எனக்குக் கீழ்ப்படிந்து, நான் ஒப்படைத்தவற்றையும், கட்டளைகளையும், விதிமுறைகளையும், சட்ட விதிகளையும் நிறைவேற்றினான்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","இதனால் ஈசாக்கு கேராரிலே தங்கியிருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","அவ்விடத்து மனிதர் அவனுடைய மனைவியைப் பற்றி யாரென்று விசாரித்தபோது, அவளைத், “தன் மனைவி” என்று சொல்லப் பயந்ததினால், “தன் சகோதரி” என்று சொன்னான். ஏனெனில், “ரெபெக்காள் மிகவும் அழகுள்ளவளாய் இருந்தபடியால், அவ்விடத்து மனிதர் அவளை அபகரிப்பதற்காகத் தன்னைக் கொன்றுவிடுவார்கள்” என்று அவன் நினைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","ஈசாக்கு நீண்டநாட்களாய் அங்கே குடியிருக்கையில், பெலிஸ்திய அரசன் அபிமெலேக்கு ஒரு நாள் ஜன்னல் வழியாகப் பார்த்தபோது, ஈசாக்கு தன் மனைவி ரெபெக்காளோடே தழுவிக் கொண்டிருப்பதைக் கண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","அப்பொழுது அபிமெலேக்கு ஈசாக்கைக் கூப்பிட்டு அவனிடம், “உண்மையிலேயே அவள் உன்னுடைய மனைவி! அப்படியிருக்க, அவள் உன் சகோதரியென்று நீ ஏன் சொன்னாய்?” என்று கேட்டான். அதற்கு ஈசாக்கு, “அவளின் நிமித்தம் நான் என் உயிரை இழந்துவிடுவேன் என்று நினைத்தபடியால் அப்படிச் சொன்னேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","அதற்கு அபிமெலேக்கு ஈசாக்கிடம், “நீ எங்களுக்குச் செய்திருப்பது என்ன? எங்கள் மனிதரில் யாராவது ஒருவன் உன் மனைவியுடன் உறவுகொண்டிருந்தால், நீ எங்கள்மேல் குற்றத்தைக் கொண்டுவந்திருப்பாயே” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","பின்பு அபிமெலேக்கு எல்லா மனிதருக்கும் சொன்னதாவது: “இந்த மனிதனையோ அல்லது இவன் மனைவியையோ தொந்தரவு செய்யும் எவனும், நிச்சயமாகக் கொல்லப்படுவான்” என உத்தரவிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ஈசாக்கு அந்த நிலத்தில் பயிரிட்டான், யெகோவா அவனை ஆசீர்வதித்தபடியால், அதே வருடத்தில் அவன் நூறுமடங்கு அறுவடை செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","அவன் பணக்காரன் ஆனான், அவன் மிகவும் செல்வந்தனாகும்வரை அவனுடைய செல்வம் தொடர்ந்து பெருகியது. ");
INSERT INTO tamtcv_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","அவனுக்கு அநேக ஆட்டு மந்தைகளும், மாட்டு மந்தைகளும், அநேக வேலைக்காரரும் இருந்தார்கள். அதனால் பெலிஸ்தியர் அவன்மேல் பொறாமை கொண்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","அவனுடைய தகப்பனான ஆபிரகாமின் காலத்தில் அவனுடைய வேலைக்காரர் வெட்டிய கிணறுகளையெல்லாம், பெலிஸ்தியர் மண்ணைப்போட்டு மூடினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","எனவே அபிமெலேக்கு ஈசாக்கிடம், “நீ இவ்விடத்தைவிட்டுப் போய்விடு; நீ எங்களைவிட மிகவும் வல்லமையுள்ளவனாகி விட்டாய்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","ஆகவே, ஈசாக்கு அவ்விடத்தைவிட்டு அகன்று, கேராரின் பள்ளத்தாக்குக்குப் போய், அங்கே கூடாரம்போட்டுத் தங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","தன் தகப்பன் ஆபிரகாமின் காலத்தில் வெட்டப்பட்டு, ஆபிரகாம் இறந்தபின் பெலிஸ்தியரினால் மூடப்பட்டிருந்த கிணறுகளை ஈசாக்கு மீண்டும் தோண்டினான். அவற்றிற்குத் தன் தகப்பன் கொடுத்திருந்த அதே பெயர்களையே இட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ஈசாக்கின் வேலைக்காரர் அந்தப் பள்ளத்தாக்கிலே கிணற்றைத் தோண்டிய போது, அங்கே புதிய நன்னீர் ஊற்றைக் கண்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ஆனால், கேராரின் மேய்ப்பர்கள், “அந்த நீரூற்று தங்களுடையது என்று சொல்லி ஈசாக்கின் மேய்ப்பருடன் வாக்குவாதம் செய்தார்கள். அவர்கள் தன்னோடு வாக்குவாதம் செய்தபடியால், ஈசாக்கு அக்கிணற்றுக்கு ஏசேக்கு எனப் பெயரிட்டான்.” ");
INSERT INTO tamtcv_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","அதற்குப்பின் வேறொரு கிணற்றைத் தோண்டினார்கள். அதைக் குறித்தும் அவர்கள் வாக்குவாதம் பண்ணினார்கள். அதனால் அவன் அதற்கு சித்னா என்று பெயரிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","பின் அவன் அவ்விடம் விட்டு வேறு இடத்திற்குப் போய், அங்கேயும் ஒரு கிணறு தோண்டினான். அதைக்குறித்து ஒருவரும் வாக்குவாதம் செய்யவில்லை. அப்பொழுது ஈசாக்கு, “யெகோவா எனக்கு இப்பொழுது ஒரு இடத்தைக் கொடுத்திருக்கிறார், இந்த நிலத்திலே நாம் செழித்து வாழ்வோம்” என்று சொல்லி அந்த இடத்திற்கு ரெகொபோத் என்று பெயரிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","அவன் அங்கிருந்து பெயெர்செபாவுக்குப் போனான். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","அன்று இரவு யெகோவா ஈசாக்கிற்குத் தோன்றி, “நான் உன் தகப்பன் ஆபிரகாமின் இறைவன்; நீ பயப்படாதே, நான் உன்னுடனேகூட இருக்கிறேன். நான் என் பணியாளன் ஆபிரகாமின் நிமித்தம் உன்னை ஆசீர்வதித்து, உன் சந்ததியைப் பெருகப்பண்ணுவேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","அங்கே ஈசாக்கு ஒரு பலிபீடத்தைக் கட்டி, யெகோவாவின் பெயரைக் கூப்பிட்டு அவரை வழிபட்டான். அங்கே தனக்கு ஒரு கூடாரத்தையும் அமைத்தான், அவனுடைய வேலைக்காரர் அவ்விடத்தில் ஒரு கிணற்றையும் தோண்டினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","அக்காலத்தில் அபிமெலேக்கு தன் ஆலோசகன் அகுசாத்துடனும், தன் படைத்தளபதி பிகோலுடனும் கேராரிலிருந்து ஈசாக்கிடம் வந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ஈசாக்கு அவர்களிடம், “என்னுடன் பகைமை பாராட்டி, என்னை வெளியே துரத்தி விட்டீர்களே, இப்பொழுது ஏன் என்னிடம் வந்தீர்கள்?” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","அதற்கு அவர்கள், “யெகோவா உம்மோடு இருக்கிறார் என்பதை நாங்கள் தெளிவாகக் காண்கிறோம்; ‘எனவே, நமக்கிடையில் சத்தியம் செய்யப்பட்ட ஒரு ஒப்பந்தம் இருக்கட்டும்.’ நாங்கள் உம்முடன் ஒரு உடன்படிக்கை செய்துகொள்வோம். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","அதாவது, நாங்கள் உம்மைத் தொந்தரவு செய்யாமல், எப்பொழுதும் உம்மை நன்றாக நடத்தி, சமாதானத்தோடே அனுப்பியதுபோல், நீரும் எங்களுக்கு ஒரு தீமையும் செய்யாது இருப்பீர் என்று ஆணையிட்டுக் கொள்வோம். நீர் இப்பொழுது யெகோவாவினால் ஆசீர்வதிக்கப்பட்டிருக்கிறீர்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","பின்பு ஈசாக்கு அவர்களுக்கு ஒரு விருந்து கொடுத்தான். அவ்விருந்தில் அவர்களெல்லாரும் சாப்பிட்டு, குடித்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","மறுநாள் அதிகாலை எழுந்து, ஒருவரோடொருவர் ஆணையிட்டு சபதம் செய்துகொண்டார்கள். ஈசாக்கு அவர்களை வழியனுப்பினான், அவர்கள் சமாதானத்துடன் அவனைவிட்டுப் புறப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","அந்த நாளில், ஈசாக்கின் வேலைக்காரர் வந்து, தாங்கள் தோண்டிய கிணற்றைப்பற்றி அவனிடம் சொன்னார்கள். அவர்கள் அவனிடம், “நாங்கள் தண்ணீரைக் கண்டோம்!” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","அவன் அக்கிணற்றிற்கு சிபா என்று பெயரிட்டான். இன்றுவரை அப்பட்டணம் பெயெர்செபா என்றே அழைக்கப்படுகிறது. ");
INSERT INTO tamtcv_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ஏசாவுக்கு நாற்பது வயதானபோது ஏத்தியனான பெயேரியினுடைய மகள் யூதீத்தையும், ஏத்தியனான ஏலோனின் மகள் பஸ்மாத்தையும் திருமணம் செய்துகொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","அவர்கள் ஈசாக்குக்கும் ரெபெக்காளுக்கும் மனவேதனையை உண்டாக்குகிறவர்களாய் இருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ஈசாக்கு முதிர்வயதானதால், அவனுடைய கண்பார்வை மங்கிப்போயிருந்தன. அவன் தன் மூத்த மகன் ஏசாவைக் கூப்பிட்டு, “என் மகனே” என்றான். அதற்கு அவன், “இதோ நான் இருக்கிறேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ஈசாக்கு அவனிடம், “இப்பொழுது நான் கிழவனாகிவிட்டேன். எந்த நாளில் மரணம் வருமோ? எனக்குத் தெரியாது. ");
INSERT INTO tamtcv_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ஆகையால், நீ உன் ஆயுதங்களான வில்லையும், அம்புக் கூட்டையும் எடுத்துக்கொண்டு, உடனே காட்டு வெளிக்குப்போய் வேட்டையாடி, எனக்கு இறைச்சி கொண்டுவா. ");
INSERT INTO tamtcv_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","நான் விரும்பும் சுவையுள்ள உணவை நீ சமைத்து, நான் அதைச் சாப்பிடுவதற்கு என்னிடம் கொண்டுவா. நான் இறப்பதற்குமுன் என்னுடைய ஆசீர்வாதத்தை உனக்குக் கொடுப்பேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ஈசாக்கு தன் மகன் ஏசாவுடன் பேசியதை, ரெபெக்காள் கேட்டுக்கொண்டிருந்தாள். ஏசா மிருகங்களை வேட்டையாடிக் கொண்டுவருவதற்காகக் காட்டு பகுதிக்குப் போனான். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","அப்பொழுது ரெபெக்காள் தன் மகன் யாக்கோபிடம், “பார், உன் தகப்பன் உன் சகோதரன் ஏசாவிடம் பேசுவதை நான் கேட்டேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","அவர், ‘நீ வேட்டையாடி, இறைச்சியைக் கொண்டுவந்து, நான் சாப்பிடுவதற்கு சுவையுள்ள உணவைத் தயாரித்து கொண்டுவா; நான் இறப்பதற்குமுன், யெகோவாவின் முன்னிலையில் என்னுடைய ஆசீர்வாதத்தை உனக்குக் கொடுக்கவேண்டும்’ என்றார், என்று சொன்னாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","இப்பொழுதும் என் மகனே, நான் சொல்வதைக் கவனமாய்க் கேட்டு நான் உனக்குச் சொல்வதைச் செய்: ");
INSERT INTO tamtcv_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","நீ உடனே ஆட்டு மந்தைக்குப் போய் நல்ல வெள்ளாட்டுக் குட்டிகள் இரண்டை என்னிடம் கொண்டுவா; உன் தகப்பன் விரும்புகிற விதமாகவே சுவையுள்ள உணவை நான் சமைத்துத் தருவேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","அதைக் கொண்டுபோய் அவர் சாப்பிடுவதற்குக் கொடு. அவர் இறப்பதற்குமுன் தன் ஆசீர்வாதத்தை உனக்குத் தரட்டும்” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","அதற்கு யாக்கோபு, தன் தாய் ரெபெக்காளிடம், “என் சகோதரன் ஏசா உடலில் உரோமம் நிறைந்தவன்; என் உடலோ மிருதுவானது. ");
INSERT INTO tamtcv_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","என் தகப்பன் என்னைத் தொட்டால் என்ன செய்வது? அவரை ஏமாற்றுகிறவனாகக் காணப்பட்டு, ஆசீர்வதிப்பதற்குப் பதிலாக சாபத்தையே என்மேல் கொண்டுவருவேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","அவன் தாய் அவனிடம், “என் மகனே, அந்தச் சாபம் என்மேல் வரட்டும்; நான் சொல்லுகிறபடி நீ போய், ஆட்டுக்குட்டிகளைக் கொண்டுவா” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","அப்படியே யாக்கோபு போய் அவற்றைப் பிடித்துத் தன் தாயிடம் கொண்டுவந்தான். அவள் அவற்றை அவனுடைய தகப்பனுக்கு விருப்பமான சுவையுள்ள உணவாகச் சமைத்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","பின்பு ரெபெக்காள், வீட்டிலிருந்த தன் மூத்த மகன் ஏசாவின் மிகச்சிறந்த உடைகளை எடுத்து, அவற்றைத் தன் இளையமகன் யாக்கோபுக்கு உடுத்தினாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","அவனுடைய கைகளையும், கழுத்தின் மிருதுவான பகுதியையும் வெள்ளாட்டுத் தோல்களினால் மறைத்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","பின்பு அவள் தயாரித்த சுவையுள்ள உணவையும் அப்பங்களையும் தன் மகன் யாக்கோபிடம் கொடுத்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","அவன் தன் தகப்பனிடம் போய், “அப்பா” என்று அழைத்தான். அதற்கு அவன், “என் மகனே, நீ யார்?” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","அதற்கு யாக்கோபு தன் தகப்பனிடம், “நான் உங்கள் மூத்த மகன் ஏசா; நீங்கள் சொன்னபடியே நான் செய்திருக்கிறேன். எழுந்திருந்து நான் வேட்டையாடிக் கொண்டுவந்த இறைச்சியைச் சாப்பிட்டு, உங்கள் ஆசீர்வாதத்தை எனக்குத் தாருங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ஈசாக்கு தன் மகனிடம், “மகனே, இது உனக்கு இவ்வளவு சீக்கிரத்தில் எப்படிக் கிடைத்தது?” என்று கேட்டான். அதற்கு அவன், “உங்கள் இறைவனாகிய யெகோவாவே எனக்கு வெற்றியைத் தந்தார்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","அப்பொழுது ஈசாக்கு யாக்கோபிடம், “என் மகனே, உண்மையாகவே நீ என் மகன் ஏசாதானோ அல்லவோ என தொட்டுப் பார்க்கும்படி, என் அருகில் வா” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","யாக்கோபு தன் தகப்பன் ஈசாக்கின் அருகில் வந்தபோது, ஈசாக்கு அவனைத் தடவிப்பார்த்து, “குரலோ யாக்கோபின் குரல்; கைகளோ ஏசாவின் கைகள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","அவனுடைய கைகள் மூத்தவன் ஏசாவின் கைகளைப்போல் உரோமம் அடர்ந்ததாய் இருந்தபடியால், அவனுடைய தகப்பன் அவனை இன்னாரென்று அறியவில்லை; எனவே அவன் யாக்கோபை ஆசீர்வதித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ஈசாக்கு யாக்கோபிடம், “உண்மையாகவே நீ என் மகன் ஏசாதானா?” என்று கேட்டான். அவனும், “ஆம், நான்தான்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","அப்பொழுது ஈசாக்கு அவனிடம், “மகனே, நீ வேட்டையாடிக் கொண்டுவந்த இறைச்சியில் கொஞ்சத்தை நான் சாப்பிடும்படி என்னிடம் கொண்டுவா; நான் உன்னை ஆசீர்வதிப்பேன்” என்றான். யாக்கோபு அதைக் கொண்டுவந்தான். அவன் அதைச் சாப்பிட்டான்; அத்துடன் அவன் திராட்சை இரசத்தையும் கொண்டுவந்தான், ஈசாக்கு அதைக் குடித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","அதன்பின் அவன் தகப்பன் ஈசாக்கு அவனிடம், “மகனே, நீ எனக்கு அருகில் வந்து என்னை முத்தமிடு” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","யாக்கோபு தன் தகப்பனருகில் போய் அவனை முத்தமிட்டான். ஈசாக்கு யாக்கோபினுடைய உடையின் மணத்தை முகர்ந்து பார்த்து, அவனை ஆசீர்வதித்து சொன்னது: “ஆஹா, என் மகனின் மணம் யெகோவா ஆசீர்வதித்த வயலின் மணத்தைப்போல் இருக்கிறது. ");
INSERT INTO tamtcv_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","இறைவன் உனக்கு வானத்தின் பனியையும், மண்ணின் வளத்தையும் கொடுப்பாராக. தானியத்தையும், திராட்சை இரசத்தையும் நிறைவாய் தருவாராக. ");
INSERT INTO tamtcv_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","நாடுகள் உனக்குப் பணி செய்வார்களாக. மக்கள் கூட்டங்கள் உன்னைத் தலைதாழ்த்தி வணங்குவார்களாக. உன் சகோதரரின்மேல் நீ முதன்மையானவனாய் இருப்பாய், உன் தாயின் மகன்கள் உன்னைத் தலைதாழ்த்தி வணங்குவார்கள். உன்னைச் சபிக்கிறவர்கள் சபிக்கப்படுவார்களாக. உன்னை ஆசீர்வதிக்கிறவர்கள் ஆசீர்வதிக்கப்படுவார்களாக.” ");
INSERT INTO tamtcv_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ஈசாக்கு அவனை ஆசீர்வதித்து முடிந்தபோது, யாக்கோபு தன் தகப்பன் முன்னிருந்து போன மாத்திரத்தில், வேட்டையாடப் போன ஏசா திரும்பிவந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","அவனும் இறைச்சியைச் சுவையுள்ள உணவாகச் சமைத்து தன் தகப்பனிடம் கொண்டுவந்தான். அவன், “அப்பா எழுந்திருந்து நான் வேட்டையாடிக் கொண்டுவந்த உணவைச் சாப்பிட்டு, உங்கள் ஆசீர்வாதத்தை எனக்குக் கொடுங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","அப்பொழுது ஈசாக்கு, “நீ யார்?” என்று அவனிடம் கேட்டான். அதற்கு அவன், “நான் உம்முடைய மகன்; மூத்த மகனான ஏசா” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ஈசாக்கு வெகுவாய் நடுங்கி, “அப்படியானால் வேட்டையாடிச் சமைத்த உணவை என்னிடம் கொண்டுவந்தவன் யார்? நீ வருவதற்குச் சிறிது நேரத்திற்குமுன் நான் சாப்பிட்டு அவனை ஆசீர்வதித்தேனே! நிச்சயமாய் அவனே ஆசீர்வதிக்கப்பட்டவனாய் இருப்பான்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","தன் தகப்பனின் வார்த்தைகளைக் கேட்டவுடனே ஏசா மனங்கசந்து, சத்தமிட்டுக் கதறி அழுது தன் தகப்பனிடம், “அப்பா என்னையும் ஆசீர்வதியுங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","அப்பொழுது ஈசாக்கு, “உன் சகோதரன் யாக்கோபு தந்திரமாய் வந்து, உன்னுடைய ஆசீர்வாதத்தைப் பெற்றுக்கொண்டான்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","அதைக்கேட்ட ஏசா தகப்பனிடம், “அவன் யாக்கோபு என சரியாகவல்லவோ பெயரிடப்பட்டிருக்கிறான்? அவன் என்னை இரண்டுமுறை ஏமாற்றிவிட்டான்: அன்று என் பிறப்புரிமையை எடுத்துக்கொண்டான், இன்று என் ஆசீர்வாதத்தையும் எடுத்துக்கொண்டான்!” என்றான். பின்பு அவன், “நீங்கள் எனக்காக எந்த ஆசீர்வாதத்தையும் ஒதுக்கி வைக்கவில்லையா?” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","அதற்கு ஈசாக்கு ஏசாவிடம், “நான் யாக்கோபை உனக்குத் தலைவனாகவும், அவனுடைய எல்லா உறவினரையும் அவனுக்கு வேலைக்காரராகவும் கொடுத்து, தானியத்தினாலும், புதிய திராட்சை இரசத்தினாலும் அவனை நிறைவாக்கியிருக்கிறேன். அவ்வாறிருக்க, என் மகனே, உனக்காக நான் என்ன செய்வேன்?” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","அப்பொழுது ஏசா தகப்பனிடம், “அப்பா, ஒரேயொரு ஆசீர்வாதம் மட்டும்தானா உங்களிடம் உண்டு? என்னையும் ஆசீர்வதியுங்கள்!” என்று கூறி சத்தமிட்டு அழுதான். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","அவனுடைய தகப்பனாகிய ஈசாக்கு அவனிடம் சொன்னது: “பூமியின் செழிப்புக்கும் வானத்தின் பனிக்கும் தூரமாகவே உன் குடியிருப்பு இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","நீ உன் வாளினால் வாழ்ந்து, உன் சகோதரனுக்குப் பணிசெய்வாய். நீ கட்டுக்கடங்காது போகும்போது, அவன் உன் கழுத்தின்மேல் வைத்த நுகத்தை நீ எடுத்து எறிந்துபோடுவாய்.” ");
INSERT INTO tamtcv_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","தன் தகப்பன், யாக்கோபுக்குக் கொடுத்த ஆசீர்வாதத்தின் நிமித்தம், ஏசா யாக்கோபின்மேல் வன்மம் கொண்டிருந்தான். “என் தகப்பனுக்காக துக்கங்கொண்டாடும் நாட்கள் சமீபமாய் இருக்கின்றன. அப்பொழுது நான் என் சகோதரன் யாக்கோபைக் கொன்றுவிடுவேன்” என்று அவன் தனக்குள் சொல்லிக்கொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","மூத்த மகன் ஏசாவின் திட்டம் ரெபெக்காளுக்குச் சொல்லப்பட்டபோது, அவள் தன் இளையமகன் யாக்கோபைக் கூப்பிட்டு, அவனிடம், “உன் சகோதரன் ஏசா உன்னைக் கொல்லும் நினைப்பில் தன்னைத் தேற்றிக்கொண்டிருக்கிறான். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ஆகையால் மகனே, இப்பொழுது நான் சொல்வதுபோல் செய்: உடனடியாக ஆரானிலிருக்கும் என் சகோதரன் லாபானிடம் ஓடிப்போ. ");
INSERT INTO tamtcv_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","உன் சகோதரனின் மூர்க்கம் தணியுமட்டும் நீ அங்கே தங்கியிரு. ");
INSERT INTO tamtcv_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","உன் சகோதரன் கோபம் தணிந்து, நீ அவனுக்குச் செய்ததை மறக்கும்போது, நீ அங்கிருந்து திரும்பிவரும்படி நான் உனக்குச் சொல்லி அனுப்புவேன். ஒரே நாளில் உங்கள் இருவரையும் நான் ஏன் இழந்துபோக வேண்டும்?” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","பின்பு ரெபெக்காள் ஈசாக்கிடம் போய், “இந்த ஏத்தியப் பெண்களால் எனக்கு வாழ்க்கையே வெறுத்துவிட்டது. யாக்கோபும் இந்த நாட்டுப் பெண்களிலிருந்து ஒரு ஏத்தியப் பெண்ணை மனைவியாகக் கொண்டால், நான் உயிர்வாழ்ந்தும் பயனில்லை” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","அப்பொழுது ஈசாக்கு யாக்கோபைக் கூப்பிட்டு, அவனை ஆசீர்வதித்து, அவனுக்குக் கட்டளையிட்டதாவது: “நீ கானானியப் பெண்ணைத் திருமணம் செய்யாதே. ");
INSERT INTO tamtcv_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","உடனே பதான் அராமிலுள்ள உன் தாயின் தந்தை பெத்துயேலின் வீட்டுக்குப்போ. அங்கே உன் தாயின் சகோதரன் லாபானின் மகள்களில் ஒருத்தியை உன் மனைவியாக்கிக்கொள். ");
INSERT INTO tamtcv_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","எல்லாம் வல்ல இறைவன் உன்னை ஆசீர்வதித்து, உன்னை இனவிருத்தியுள்ளவனாக்கி, நீ ஒரு மக்கள் கூட்டமாகும் வரைக்கும் அவர் உன்னைப் பெருகப்பண்ணுவாராக. ");
INSERT INTO tamtcv_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ஆபிரகாமுக்குக் கொடுக்கப்பட்ட ஆசீர்வாதத்தை இறைவன் உனக்கும், உன் சந்ததிக்கும் கொடுப்பாராக. எனவே இறைவன் ஆபிரகாமுக்குக் கொடுத்ததும், இப்பொழுது நீ அந்நியனாய் வாழ்கின்றதுமான இந்த நாட்டை, நீ உரிமையாக்கிக்கொள்வாய்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","அதன்பின் ஈசாக்கு, யாக்கோபை வழியனுப்பினான்; அவன் பதான் அராமிலிருந்த அரமேயனான பெத்துயேலின் மகன் லாபானிடம் போனான். லாபான் யாக்கோபு, ஏசா ஆகியோரின் தாயாகிய ரெபெக்காளின் சகோதரன். ");
INSERT INTO tamtcv_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","ஈசாக்கு யாக்கோபை ஆசீர்வதித்து, பதான் அராமிலிருந்து ஒரு பெண்ணை எடுக்கும்படி அவனை அங்கு அனுப்பியதை ஏசா அறிந்தான். அவனை ஆசீர்வதிக்கும்பொழுது, “நீ கானானியப் பெண்ணைத் திருமணம் செய்யாதே” என்று அவனுக்குக் கட்டளையிட்டதையும் கேள்விப்பட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","அத்துடன், யாக்கோபு தன் தகப்பனுக்கும் தாய்க்கும் கீழ்ப்படிந்து, பதான் அராமுக்குப் போய்விட்டதையும் ஏசா அறிந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","அப்பொழுது தன் தகப்பன் ஈசாக்கு கானானியப் பெண்களில் எவ்வளவு வெறுப்பாய் இருக்கிறார் என்பதை ஏசா உணர்ந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","எனவே ஏசா ஆபிரகாமின் மகனான இஸ்மயேலிடம் போய், அவன் மகள் மகலாத்தைத் திருமணம் செய்தான். நெபாயோத்தின் சகோதரியான அவளை ஏற்கெனவே தனக்கிருந்த மனைவிகளுடன் சேர்த்துக்கொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","யாக்கோபு பெயெர்செபாவைவிட்டு ஆரானுக்குப் புறப்பட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","அவன் ஒரு குறிப்பிட்ட இடத்தை அடைந்தபோது, சூரியன் மறைந்ததால் அந்த இடத்திலே இரவு தங்கினான். அவன் அங்கிருந்த கற்களில் ஒன்றை எடுத்துத் தலையின்கீழ் வைத்து, அங்கே படுத்து உறங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","அப்பொழுது அவன் ஒரு ஏணி பூமியிலிருந்து வானத்தைத் தொட்டுக் கொண்டிருப்பதாகக் கனவு கண்டான்; அதிலே இறைவனின் தூதர்கள் ஏறுவதும் இறங்குவதுமாய் இருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","யெகோவா அதற்கு மேலாக நின்று அவனிடம், “உன் தகப்பன் ஆபிரகாமின் இறைவனும், ஈசாக்கின் இறைவனுமாகிய யெகோவா நானே. உனக்கும் உன் சந்ததிக்கும், நீ படுத்திருக்கிற இந்த நாட்டைத் தருவேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","உன் சந்ததிகள் பூமியின் புழுதியைப்போல் பெருகுவார்கள். நீ மேற்கு நோக்கியும், கிழக்கு நோக்கியும், வடக்கு நோக்கியும், தெற்கு நோக்கியும் பரவுவாய். உன்னாலும், உன் சந்ததியினாலும், பூமியிலுள்ள மக்கள் கூட்டங்கள் எல்லாம் ஆசீர்வதிக்கப்படும். ");
INSERT INTO tamtcv_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","நான் உன்னுடனே இருக்கிறேன், நீ போகும் இடமெல்லாம் உன்னைப் பாதுகாத்து, உன்னைத் திரும்பவும் இந்த நாட்டிற்குக் கொண்டுவருவேன்; நான் உனக்கு வாக்குப்பண்ணியதை நிறைவேற்றும்வரை, உன்னைவிட்டு விலகவேமாட்டேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","யாக்கோபு நித்திரையை விட்டெழுந்தபோது, “யெகோவா நிச்சயமாய் இந்த இடத்தில் இருக்கிறார்; இதை நான் அறியாதிருந்தேனே” என்று நினைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","அவன் பயந்து, “இந்த இடம் எவ்வளவு பிரமிப்புக்குரியது! இது இறைவனுடைய வீடேயன்றி வேறல்ல; இது பரலோகத்தின் வாசல்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","மறுநாள் அதிகாலையில், யாக்கோபு தன் தலையின்கீழ் வைத்திருந்த கல்லை எடுத்து, அதைத் தூணாக நிறுத்தி, அதன்மேல் எண்ணெய் ஊற்றினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","அந்த இடத்திற்கு அவன் பெத்தேல் என்று பெயரிட்டான், முன்பு அந்தப் பட்டணம் லூஸ் என்று அழைக்கப்பட்டிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","பின்பு யாக்கோபு ஒரு பொருத்தனை செய்து, சொன்னதாவது: “இறைவன் என்னோடிருந்து, நான் போகும் பயணத்தில் என்னைக் காப்பாற்றி, சாப்பிட உணவும், உடுக்க உடையும் தந்து, ");
INSERT INTO tamtcv_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","பாதுகாப்புடன் என் தகப்பன் வீட்டுக்குத் திரும்பி வரப்பண்ணுவாரானால், யெகோவாவே என் இறைவனாயிருப்பார். ");
INSERT INTO tamtcv_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","நான் தூணாக நிறுத்திய இந்தக் கல் இறைவனின் வீடாக இருக்கும். நீர் எனக்குக் கொடுக்கும் எல்லாவற்றிலும் பத்தில் ஒன்றை உமக்குக் கொடுப்பேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","பின்பு யாக்கோபு தன் பயணத்தைத் தொடர்ந்து, கிழக்குத் திசையாரின் நாட்டிற்குப் போனான். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","அங்குள்ள வயல்வெளியில் ஒரு கிணற்றையும், அதன் அருகே மூன்று ஆட்டுமந்தைகள் படுத்திருப்பதையும் அவன் கண்டான்; அக்கிணற்றில் இருந்தே அவற்றுக்குத் தண்ணீர் கொடுக்கப்படும். கிணற்றின் வாயை மூடியிருந்த கல் பெரிதாயிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","எல்லா மந்தைகளும் சேர்ந்தவுடன் மேய்ப்பர்கள் கிணற்றின் வாயிலிருக்கும் கல்லைப் புரட்டி, செம்மறியாடுகளுக்குத் தண்ணீர் கொடுப்பார்கள். அதன்பின் திரும்பவும் அக்கல்லைக் கிணற்றின் வாயின்மேல் முன்பிருந்த இடத்தில் புரட்டி வைப்பார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","யாக்கோபு அந்த மேய்ப்பர்களிடம், “என் சகோதரரே, நீங்கள் எங்கிருந்து வருகிறீர்கள்?” என்று கேட்டான். அதற்கு அவர்கள், “நாங்கள் ஆரான் ஊரிலிருந்து வருகிறோம்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","யாக்கோபு அவர்களிடம், “உங்களுக்கு நாகோரின் பேரன் லாபானைத் தெரியுமா?” என்று கேட்டான். அதற்கு அவர்கள், “ஆம்; எங்களுக்குத் தெரியும்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","“அவர் சுகமாயிருக்கிறாரா?” என்று யாக்கோபு விசாரித்தான். “சுகமாயிருக்கிறார்; இதோ அவருடைய மகள் ராகேல் ஆடுகளை ஓட்டிக்கொண்டு வருகிறாள்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","அதற்கு யாக்கோபு அவர்களிடம், “இன்னும் சூரியன் மறையவில்லையே; இது மந்தைகளைச் சேர்க்கிற நேரமும் இல்லை. ஆடுகளுக்குத் தண்ணீர் கொடுத்து மறுபடியும் மேயவிடலாம்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","அதற்கு அவர்கள், “எல்லா மந்தைகளும் சேரும்வரை அப்படிச் செய்யமுடியாது. சேர்ந்ததும் கிணற்றின் வாயிலிருக்கும் கல் புரட்டப்படும். அப்பொழுது ஆடுகளுக்குத் தண்ணீர் காட்டுவோம்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","அவன் அவர்களுடன் பேசிக்கொண்டிருக்கையில், ராகேல் மந்தை மேய்ப்பவளாய் இருந்தபடியால், தன் தகப்பனின் ஆடுகளுடன் அங்கே வந்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","யாக்கோபு தன் தாயின் சகோதரன் லாபானின் மகள் ராகேலையும், லாபானின் செம்மறியாடுகளையும் கண்டவுடனே, அவன் கிணற்றண்டை போய் அதன் வாயிலிருந்த கல்லை உருட்டி, தன் மாமனின் செம்மறியாடுகளுக்குத் தண்ணீர் காட்டினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","பின்பு யாக்கோபு ராகேலை முத்தஞ்செய்து சத்தமிட்டு அழத்தொடங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","அவன் ராகேலிடம், “நான் உன் தகப்பனின் உறவினன்; ரெபெக்காளின் மகன்” என்று சொன்னான். உடனே அவள் ஓடிப்போய் அதைத் தன் தகப்பனுக்குச் சொன்னாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","தன் சகோதரியின் மகன் யாக்கோபைப் பற்றிய செய்தியைக் கேட்ட லாபான் அவனைச் சந்திப்பதற்காக விரைவாய் வந்தான். அவன் அவனைக் கட்டி அணைத்து, முத்தமிட்டு, தன் வீட்டுக்கு அழைத்துச் சென்றான். நடந்த எல்லாவற்றையும் யாக்கோபு தன் மாமன் லாபானுக்கு சொன்னான். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","அப்பொழுது லாபான் யாக்கோபிடம், “நீ என் சொந்த இரத்த சம்மந்தமான உறவினன்” என்றான். யாக்கோபு லாபானுடன் ஒரு மாதம் தங்கியிருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","அதன்பின்பு லாபான் யாக்கோபிடம், “நீ எனக்கு உறவினன் என்பதால், கூலியில்லாமல் எனக்கு வேலைசெய்ய வேண்டுமோ? நீ விரும்பும் கூலியைக் கேள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","லாபானுக்கு இரண்டு மகள்கள் இருந்தார்கள். மூத்தவள் பெயர் லேயாள், இளையவள் பெயர் ராகேல். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","லேயாள் பார்வை குறைந்த கண்களை உடையவள். ராகேலோ நல்ல உடலமைப்பும் அழகும் உடையவள். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","யாக்கோபு ராகேலை நேசித்தான். எனவே அவன் லாபானிடம், “உமது இளையமகள் ராகேலுக்காக நான் உம்மிடம் ஏழு வருடங்கள் வேலை செய்வேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","அதற்கு லாபான், “நான் அவளை வேறொருவனுக்குக் கொடுப்பதைப் பார்க்கிலும் உனக்குக் கொடுப்பது நல்லது; நீ என்னுடன் இங்கேயே தங்கியிரு” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","அப்படியே யாக்கோபு ராகேலை அடைவதற்காக லாபானிடம் ஏழு வருடங்கள் வேலைசெய்தான். அவன் ராகேலின்மேல் வைத்திருந்த நேசத்தினால், அந்த ஏழு வருடங்களும் அவனுக்கு சிலநாட்கள் போலவே இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","பின்பு யாக்கோபு லாபானிடம், “நான் உம்மிடம் உடன்பட்ட காலம் நிறைவாகிவிட்டது; நான் ராகேலை திருமணம் செய்துகொள்ளும்படி அவளை எனக்குக் கொடும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","அப்பொழுது லாபான், அந்த இடத்தின் மக்களையெல்லாம் ஒன்றாய்க் கூட்டி, ஒரு விருந்து கொடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","ஆனால் அன்று இரவு லாபான், தன் மகள் லேயாளை அழைத்துக் கொண்டுபோய், யாக்கோபிடம் கொடுத்தான். யாக்கோபு அவளுடன் உறவுகொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","லாபான் தன் வீட்டுப் பணிப்பெண் சில்பாளை தன் மகள் லேயாளுக்குப் பணிப்பெண்ணாக அனுப்பினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","பொழுது விடிந்ததும், யாக்கோபு தன்னுடன் இருந்தவள் லேயாள் என்பதைக் கண்டான். அப்பொழுது யாக்கோபு லாபானிடம், “எனக்கு நீர் செய்திருப்பது என்ன? நான் ராகேலுக்காக அல்லவோ உம்மிடம் வேலைசெய்தேன்; நீர் ஏன் என்னை ஏமாற்றினீர்?” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","அதற்கு லாபான், “மூத்தவள் இருக்க இளைய மகளைத் திருமணம் செய்து கொடுப்பது இங்கு எங்கள் வழக்கமல்ல. ");
INSERT INTO tamtcv_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","மணமகளுக்குரிய ஏழு நாட்களை நீ நிறைவேற்று. பின்பு உனக்கு இளைய மகளையும் கொடுப்போம், அவளுக்காகவும் இன்னும் ஏழு வருடங்கள் நீ என்னிடத்தில் வேலைசெய்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","யாக்கோபு அப்படியே செய்தான். லேயாளுக்குரிய ஏழு நாட்களையும் அவன் நிறைவேற்றியதும் லாபான் தன் மகள் ராகேலையும் அவனுக்கு மனைவியாகக் கொடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","லாபான் தன் வீட்டுப் பணிப்பெண் பில்காளை தன் மகள் ராகேலுக்குப் பணிப்பெண்ணாகக் கொடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","யாக்கோபு ராகேலுடன் உறவுகொண்டான், யாக்கோபு லேயாளைவிட ராகேலை அதிகமாக நேசித்தான். அவன் ராகேலுக்காக மேலும் ஏழு வருடங்கள் லாபானிடம் வேலைசெய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","லேயாள் நேசிக்கப்படாமல் இருந்ததை யெகோவா கண்டபோது, அவள் கருத்தரிக்கும்படி செய்தார். ராகேலோ மலடியாய் இருந்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","லேயாள் கருத்தரித்து ஒரு மகனைப் பெற்றாள். “யெகோவா என் துன்பத்தைக் கண்டார்; நிச்சயம் என் கணவர் இப்பொழுது என்னிடம் அன்பாயிருப்பார்” என்று அவள் சொல்லி அவனுக்கு ரூபன் என்று பெயரிட்டாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","மறுபடியும் அவள் கருத்தரித்து, ஒரு மகனைப் பெற்றாள். “நான் நேசிக்கப்படவில்லை என்பதை யெகோவா கண்டு இந்த மகனையும் எனக்குக் கொடுத்தார்” என்று சொல்லி அவனுக்கு சிமியோன் என்று பெயரிட்டாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","திரும்பவும் அவள் கருத்தரித்து, ஒரு மகனைப் பெற்றாள். “நான் என் கணவனுக்கு மூன்று மகன்களைப் பெற்றபடியால், அவர் இப்பொழுது என்னுடன் ஒன்றிணைந்திருப்பார்” என்று சொன்னாள். அதனால் அவன் லேவி என்று பெயரிடப்பட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","மீண்டும் அவள் கர்ப்பந்தரித்து, ஒரு மகனைப் பெற்றாள். “இப்பொழுது நான் யெகோவாவைத் துதிப்பேன்” என்று சொல்லி அவனுக்கு யூதா என்று பெயரிட்டாள். அதன்பின்பு அவள் பிள்ளைகள் பெறவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","யாக்கோபுக்கு ராகேல் பிள்ளைகள் எதையும் பெறாததினால், ராகேல் தன் சகோதரியின்மேல் பொறாமை கொண்டாள். எனவே அவள் யாக்கோபிடம், “நீர் எனக்கு பிள்ளைகளைக் கொடும்; இல்லாவிட்டால் நான் சாகப்போகிறேன்” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","அப்பொழுது யாக்கோபு ராகேலின்மேல் கோபங்கொண்டு, “நான் என்ன இறைவனா? அவர் அல்லவா உன்னைப் பிள்ளைப்பேறு அற்றவளாக்கி இருக்கிறார்!” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","அதற்கு அவள், “இதோ என் பணிப்பெண் பில்காள் இருக்கிறாள், அவளுடன் உறவுகொள்ளும். அவள் எனக்காகப் பிள்ளைகளைப் பெறட்டும், அவள் மூலம் நானும் ஒரு குடும்பத்தைக் கட்டலாமே” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","அப்படியே அவள் தன் பணிப்பெண் பில்காளை யாக்கோபுக்கு மனைவியாகக் கொடுத்தாள். யாக்கோபு அவளுடன் உறவுகொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","பில்காள் கருத்தரித்து, அவனுக்கு ஒரு மகனைப் பெற்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","அப்பொழுது ராகேல், “இறைவன் எனக்கு நியாயம் செய்து, என் வேண்டுதலைக் கேட்டு, எனக்கொரு மகனைத் தந்தார்” என்றாள். அதனால் அவனுக்கு, தாண் என்று பெயரிட்டாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","மறுபடியும் ராகேலின் பணிப்பெண் பில்காள் கருத்தரித்து, யாக்கோபுக்கு இரண்டாவது மகனைப் பெற்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","அப்பொழுது ராகேல், “என் சகோதரியுடன் எனக்கிருந்த பெரிய போராட்டத்தில் நான் வெற்றியடைந்தேன்” என்று சொல்லி, அவனுக்கு நப்தலி எனப் பெயரிட்டாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","லேயாள் தனக்குப் பிள்ளைப்பேறு நின்றுபோனதைக் கண்டு, தன் பணிப்பெண் சில்பாளை யாக்கோபுக்கு மனைவியாகக் கொடுத்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","லேயாளின் பணிப்பெண் சில்பாள் யாக்கோபுக்கு ஒரு மகனைப் பெற்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","அப்பொழுது லேயாள், “நான் எவ்வளவு அதிர்ஷ்டசாலி” என்று சொல்லி அவனுக்கு காத் என்று பெயரிட்டாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","லேயாளின் பணிப்பெண் சில்பாள் யாக்கோபுக்கு இரண்டாவது மகனையும் பெற்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","அப்பொழுது லேயாள், “நான் எவ்வளவு மகிழ்ச்சியாய் இருக்கிறேன்! பெண்கள் எல்லாரும் என்னை, மகிழ்ச்சி உள்ளவள் என அழைப்பார்கள்” என்றாள். அதனால் அவனுக்கு ஆசேர் என்று பெயரிட்டாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","கோதுமை அறுவடைக்காலத்தில் ரூபன் வயல்வெளிக்குப் போனான். அங்கே தூதாயீம் மூலிகைச் செடியைக் கண்டு அவற்றைக் கொண்டுவந்து தன் தாய் லேயாளிடம் கொடுத்தான். ராகேல் லேயாளிடம், “உன் மகன் கொண்டுவந்த மூலிகைகளில் எனக்கும் கொஞ்சம் தா” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","அதற்கு லேயாள், “நீ என் கணவனை என்னிடமிருந்து எடுத்துக்கொண்டது போதாதோ? என் மகன் கொண்டுவந்த தூதாயீம் மூலிகையையும் அபகரிக்கப் பார்க்கிறாயோ?” என்று கேட்டாள். அதற்கு ராகேல், “அப்படியானால், உன் மகன் கொண்டுவந்த தூதாயீம் மூலிகைக்குப் பதிலாக, அவர் இன்றிரவை உன்னுடன் கழிக்கட்டுமே” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","அப்படியே மாலைவேளையில் யாக்கோபு வயல்வெளியிலிருந்து திரும்பிவந்தபோது, லேயாள் அவனைச் சந்திக்கும்படி வெளியே போய், “என் மகன் ரூபன் கொண்டுவந்த தூதாயீம் மூலிகையைக் கொடுத்து நான் உம்மை வாங்கிக் கொண்டேன். எனவே இன்றிரவு நீர் என்னுடன் தங்கவேண்டும்” என்றாள். அப்படியே அவன் அன்றிரவு அவளுடன் உறவுகொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","இறைவன் லேயாளின் வேண்டுதலைக் கேட்டார். அவள் கருத்தரித்து யாக்கோபுக்கு ஐந்தாவது மகனைப் பெற்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","அப்பொழுது லேயாள், “நான் என் பணிப்பெண் சில்பாளை என் கணவனுக்குக் கொடுத்ததற்காக இறைவன் எனக்கு வெகுமதி அளித்தார்” என்று சொல்லி அவனுக்கு இசக்கார் என்று பெயரிட்டாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","லேயாள் மறுபடியும் கர்ப்பந்தரித்து, யாக்கோபுக்கு ஆறாவது மகனைப் பெற்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","அப்பொழுது லேயாள், “இறைவன் எனக்கு ஒரு விலையேறப்பெற்ற வெகுமதியைப் பரிசாகக் கொடுத்தார். நான் ஆறு மகன்களைப் பெற்றபடியால், என் கணவர் இப்பொழுது என்னை மதிப்புடன் நடத்துவார்” என்று சொல்லி அவனுக்குச் செபுலோன் என்று பெயரிட்டாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","சில காலத்திற்குப் பின்பு அவள் ஒரு மகளையும் பெற்று அவளுக்குத் தீனாள் என்று பெயரிட்டாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","பின்பு இறைவன் ராகேலையும் நினைவுகூர்ந்தார்; அவளுடைய வேண்டுதலைக் கேட்டு அவளுக்கும் பிள்ளைப்பேற்றைக் கொடுத்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","அவள் கருத்தரித்து ஒரு மகனைப் பெற்று, “இறைவன் என் அவமானத்தை நீக்கிவிட்டார்” என்று சொன்னாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","அவள் அவனுக்கு யோசேப்பு எனப் பெயரிட்டு, “யெகோவா இன்னும் ஒரு மகனை எனக்குக் கொடுப்பாராக” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","ராகேல் யோசேப்பைப் பெற்றபின், யாக்கோபு லாபானிடம், “நான் என் சொந்த நாட்டிற்குத் திரும்பிப் போவதற்காக என்னை வழியனுப்பிவிடும். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","என் மனைவிகளையும், என் பிள்ளைகளையும் என்னுடன் அனுப்பிவிடும்; அவர்களுக்காகவே உம்மிடம் நான் வேலைசெய்தேன், நான் போகப்போகிறேன். உமக்காக எவ்வளவு வேலைசெய்தேன் என்பது உமக்குத் தெரியும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","ஆனால் லாபானோ அவனிடம், “உன் கண்களில் எனக்குத் தயவு கிடைக்குமானால், நீ இங்கேயே தங்கியிரு. உன் நிமித்தமாக யெகோவா என்னையும் ஆசீர்வதித்தார் என்பதை நான் குறிபார்த்து அறிந்துகொண்டேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","மேலும் அவன், “நீ உன் கூலியைச் சொல்; அதை நான் உனக்குக் கொடுப்பேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","யாக்கோபு அவனிடம், “நான் உம்மிடத்தில் எப்படி வேலைசெய்தேன் என்பதையும், என் பராமரிப்பில் உமது மந்தை எப்படி நலமாய் இருந்தன என்பதையும் நீர் அறிவீர். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","நான் வருமுன் உம்மிடத்திலிருந்த சிறிய மந்தை, இப்போது எவ்வளவாய் பெருகியிருக்கிறது. நான் இருந்த இடங்களில் எல்லாம் யெகோவா உம்மை ஆசீர்வதித்திருக்கிறார். ஆனால் நான் எப்பொழுது என் சொந்த குடும்பத்திற்கு சம்பாதிக்கப் போகிறேன்?” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","அதற்கு லாபான், “நான் உனக்கு என்ன தரவேண்டும்?” என்று கேட்டான். அதற்கு யாக்கோபு, “எனக்கு எதையும் தரவேண்டாம். எனக்காக இந்த ஒரு காரியத்தை மட்டும் நீர் செய்வீரானால் நான் இங்கேயே தங்கி தொடர்ந்து உமது மந்தையை மேய்த்து, அவற்றைப் பராமரிப்பேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","அதாவது, நான் உமது ஆட்டுத் தொழுவத்துக்குச் சென்று, அவற்றில் கலப்பு நிறமும் புள்ளிகளும் உள்ள செம்மறியாடுகளையும், கருப்புநிறச் செம்மறியாட்டுக் குட்டிகளையும், புள்ளிகளும் கலப்பு நிறமும் உள்ள வெள்ளாடுகளையும் பிரித்து எடுத்துக்கொள்கிறேன். அவை என் கூலியாக இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","எதிர்காலத்தில் நீர் எனக்குக் கூலியாய் கொடுத்திருக்கிற இவற்றைப் பார்க்கும் போதெல்லாம், என் நேர்மையே எனக்காக சாட்சியிடும். நீர் சோதித்துப் பார்க்கும்போது என்னிடம் கலப்பு நிறமும், புள்ளிகளும் இல்லாத வெள்ளாடுகளும், கருப்பு நிறமல்லாத செம்மறியாட்டுக் குட்டிகளும் இருக்குமானால், அவை திருடப்பட்டவைகளாகக் கருதப்படும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","அதற்கு லாபான், “சம்மதிக்கிறேன்; நீ சொன்னபடியே ஆகட்டும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","ஆனால் அன்றே லாபான் தன் மந்தையிலிருந்து வரிகளும், புள்ளிகளுமுள்ள எல்லா வெள்ளாட்டுக் கடாக்களையும், வெள்ளைநிறப் புள்ளியுடன் கலப்பு நிறமும் புள்ளிகளுமுள்ள எல்லா வெள்ளாடுகளையும், கருப்பு நிற செம்மறியாட்டுக் குட்டிகளையும் பிரித்தெடுத்து, அவற்றைத் தன் மகன்களின் பராமரிப்பில் விட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","மேலும் லாபான் தனக்கும் யாக்கோபுக்கும் இடையே மூன்றுநாள் பயணத்தூரம் இருக்கும்படி செய்தான். மீதமுள்ள லாபானின் மந்தைகளை யாக்கோபு மேய்த்து வந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","ஆனாலும் யாக்கோபு புன்னை, வாதுமை, அர்மோன் மரங்களில் இருந்து பசுமையான கொப்புகளை வெட்டி, இடையிடையே உள்ளே உள்ள வெண்மை தோன்றும்படி பட்டைகளை உரித்து, வெள்ளை நிறக்கோடுகளை உண்டாக்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","மந்தை தண்ணீர் குடிக்க வரும்போது பட்டை உரிக்கப்பட்ட அக்கொப்புகள் மந்தைக்கு நேரே இருக்கும்படி தொட்டிகளுக்குள் வைத்தான். அவை கருத்தரிக்கப்படும் காலத்தில் தண்ணீர் குடிக்க வரும்போது, அக்கொப்புகளை அவைகளுக்கு எதிராக வைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","இதனால் அவை வரிகளை அல்லது கலப்பு நிறத்தை அல்லது புள்ளிகளையுடைய குட்டிகளையே ஈன்றன. ");
INSERT INTO tamtcv_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","யாக்கோபு அக்குட்டிகளை வேறுபிரித்து, லாபானுக்குரிய மந்தையை வரியும் கருப்புமான மந்தைக்கு எதிராக நிறுத்தினான். இவ்வாறு அவன் தனக்கு மந்தையை உண்டாக்கினான். அவற்றை லாபானின் மந்தையோடு அவன் சேர்க்கவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","பலமான ஆடுகள் கருத்தரிக்கப்படும் காலத்தில், அவை அந்த மரக்கொப்புகளுக்கு அருகே கருத்தரிக்கும்படி யாக்கோபு அவற்றைத் தண்ணீர்த் தொட்டிகளுக்குள் வைப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","பலவீனமான ஆடுகளானால், அவன் கொப்புகளை அங்கே வைக்கமாட்டான். அதனால் பலவீனமான ஆடுகள் லாபானுக்கும், பலமான ஆடுகள் யாக்கோபுக்கும் சொந்தமாயின. ");
INSERT INTO tamtcv_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","இவ்வாறு யாக்கோபு பெரிய செல்வந்தனாகி, திரளான மந்தைக்கும், வேலைக்காரருக்கும், வேலைக்காரிகளுக்கும், ஒட்டகங்களுக்கும், கழுதைகளுக்கும் உரிமையாளன் ஆனான். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","“யாக்கோபு எங்கள் தகப்பனின் சொத்துக்களையெல்லாம் எடுத்துக்கொண்டான் என்றும், எங்கள் தகப்பனுக்குச் சொந்தமானவற்றிலிருந்தே யாக்கோபு செல்வந்தனாகிவிட்டான்” என்றும் லாபானின் மகன்கள் பேசிக்கொள்வதை யாக்கோபு கேள்விப்பட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","அத்துடன் தன்னைக் குறித்த லாபானின் அணுகுமுறை முன்புபோல் இல்லாதிருப்பதையும் யாக்கோபு கவனித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","அப்பொழுது யெகோவா யாக்கோபிடம், “நீ உன் தந்தையரின் நாட்டிற்கும் உன் உறவினரிடத்திற்கும் திரும்பிப்போ; நான் உன்னுடன் இருப்பேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","எனவே யாக்கோபு ராகேலையும், லேயாளையும் தன் மந்தைகள் இருக்கும் வயல்வெளிக்கு வரும்படி சொல்லியனுப்பினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","அவன் அவர்களிடம், “உங்கள் தகப்பனின் அணுகுமுறை என்னிடம் முன்போல் இல்லையென நான் காண்கிறேன்; ஆனால் என் தந்தையின் இறைவன் என்னுடன் இருக்கிறார். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","நான் உங்கள் தகப்பனுக்காக என் முழுப்பெலத்துடனும் வேலைசெய்தேன் என்பது உங்களுக்குத் தெரியும். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ஆனால் உங்கள் தகப்பனோ பத்துமுறை என் கூலியை மாற்றி என்னை ஏமாற்றினார். அப்படியிருந்தும், அவர் எனக்குத் தீங்குசெய்ய இறைவன் அவரை அனுமதிக்கவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","‘கலப்பு நிற ஆடுகள் உன்னுடைய கூலியாயிருக்கும்’ என்று அவர் சொன்னபோது, மந்தையிலுள்ள ஆடுகளெல்லாம் கலப்புநிறக் குட்டிகளை ஈன்றன. ‘வரியுடைய ஆடுகள் உன்னுடைய கூலியாயிருக்கும்’ என்று அவர் சொன்னபோது, மந்தையிலுள்ள ஆடுகளெல்லாம் வரியுள்ள குட்டிகளையே ஈன்றன. ");
INSERT INTO tamtcv_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","இவ்விதமாக இறைவன் உங்கள் தகப்பனின் வளர்ப்பு மிருகங்களை எல்லாம் எடுத்து அவற்றை எனக்குக் கொடுத்துவிட்டார். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“ஒருமுறை ஆடுகள் சினைப்படும் காலத்தில் நான் ஒரு கனவு கண்டேன்; அதில் நான் ஏறெடுத்துப் பார்க்கும்பொழுது மந்தையிலுள்ள ஆடுகளுடன் புணரும் ஆட்டுக்கடாக்கள் வரியும், கலப்பு நிறமும், புள்ளிகளும் உள்ளதாயிருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","இறைவனின் தூதன் அந்தக் கனவில், ‘யாக்கோபே’ என்று என்னைக் கூப்பிட்டார். ‘இதோ, நான் இருக்கிறேன்’ என்று நான் பதிலளித்தேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","அப்பொழுது அவர் என்னிடம், ‘இதோ பார், மந்தையிலுள்ள ஆடுகளுடன் புணரும் ஆட்டுக்கடாக்கள் எல்லாம் வரிகளும், கலப்பு நிறமும், புள்ளிகளுமுள்ளனவாய் இருக்கின்றன. ஏனெனில் உனக்கு லாபான் செய்வதெல்லாவற்றையும் நான் கண்டேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","நீ ஒரு தூணை அபிஷேகம் செய்து, என்னுடன் பொருத்தனை செய்துகொண்ட இடமான, பெத்தேலின் இறைவன் நானே; உடனே இந்த நாட்டைவிட்டுப் புறப்பட்டு, உன் சொந்த நாட்டிற்குத் திரும்பிப்போ’ என்றார்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","அதற்கு ராகேலும் லேயாளும் யாக்கோபிடம், “எங்கள் தகப்பனுடைய குடும்பச் சொத்தின் உரிமையிலே எங்களுக்கு இன்னும் பங்கு உண்டோ? ");
INSERT INTO tamtcv_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","அவர் எங்களை அந்நியராய் நினைக்கவில்லையா? எங்களை விற்றது மட்டுமல்ல; எங்களுக்காகச் செலுத்தப்பட்ட கூலியையும் அபகரித்து விட்டாரே! ");
INSERT INTO tamtcv_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","இறைவன் எங்கள் தகப்பனிடமிருந்து எடுத்துக்கொண்ட செல்வங்களெல்லாம், நிச்சயமாக எங்களுக்கும் எங்கள் பிள்ளைகளுக்குமே சொந்தம். ஆகையால் இறைவன் உமக்குச் சொன்னவற்றையெல்லாம் செய்யும்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","பின்பு யாக்கோபு தன் பிள்ளைகளையும் மனைவிகளையும் ஒட்டகங்களில் ஏற்றி, ");
INSERT INTO tamtcv_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","தனக்குச் சொந்தமான வளர்ப்பு மிருகங்களையும் தனக்கு முன்னால் ஓட்டிக்கொண்டு, தான் பதான் அராமிலே சம்பாதித்த தன் பொருட்களையும் எடுத்துக்கொண்டு, கானான் நாட்டிலுள்ள தன் தகப்பன் ஈசாக்கிடம் போகப் புறப்பட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","லாபான் தன் செம்மறியாடுகளுக்கு மயிர்கத்தரிக்கச் சென்றிருந்த வேளை, ராகேல் தன் தகப்பன் வீட்டு சிலைகளைத் திருடி மறைத்து வைத்துக்கொண்டாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","அதுமட்டுமல்ல, யாக்கோபு அரமேயனான லாபானுக்குச் சொல்லாமலே ஓடிப்போனதினால் அவனை ஏமாற்றினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","இவ்வாறு யாக்கோபு தனக்குச் சொந்தமான எல்லாவற்றையும் எடுத்துக்கொண்டு ஐபிராத்து ஆற்றைக் கடந்து தப்பியோடி, கீலேயாத் மலைநாட்டை நோக்கிப் போனான். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","யாக்கோபு தப்பி ஓடிவிட்டான் என்று மூன்றாம் நாளில் லாபானுக்குச் சொல்லப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","லாபான் தன் உறவினர்களோடு ஏழு நாட்களாக யாக்கோபைப் பின்தொடர்ந்து சென்று கீலேயாத் மலையில் அவனிருந்த இடத்தை அடைந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","அன்றிரவு இறைவன் அரமேயனான லாபானின் கனவிலே தோன்றி, “நீ யாக்கோபுடன் நன்மையானவற்றையோ தீமையானவற்றையோ பேசக்கூடாது” என எச்சரித்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","லாபான் யாக்கோபைக் கண்டபோது, அவன் கீலேயாத் மலைநாட்டிலே கூடாரம் அமைத்துத் தங்கியிருந்தான். லாபானும் அவன் உறவினர்களும் அங்கேயே கூடாரம் அமைத்துத் தங்கினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","அப்பொழுது லாபான் யாக்கோபிடம், “நீ என்ன செய்துவிட்டாய்? நீ என்னை ஏமாற்றி, என் மகள்களை போர் கைதிகளைப்போல் கொண்டு வந்திருக்கிறாயே! ");
INSERT INTO tamtcv_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","எனக்கு அறிவிக்காமல் திருட்டுத்தனமாய் ஓடிவந்து என்னை ஏமாற்றியது ஏன்? நீ ஏன் எனக்குச் சொல்லவில்லை? சொல்லியிருந்தால் மேளதாளம், யாழிசையோடு கூடிய பாடலுடனும் மகிழ்ச்சியாய் உன்னை வழியனுப்பியிருப்பேனே. ");
INSERT INTO tamtcv_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","என் பேரப்பிள்ளைகளையும், மகள்களையும் முத்தமிட்டு வழியனுப்பக்கூட நீ விடவில்லை. நீ மூடத்தனமாய் நடந்துகொண்டாய். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","உனக்குத் தீங்குசெய்ய என்னால் இயலும்; ஆனால், கடந்த இரவு உன் தகப்பனுடைய இறைவன், ‘நீ யாக்கோபுடன் நன்மையானவற்றையோ, தீமையானவற்றையோ பேசாதபடி கவனமாயிரு’ என்று எனக்குச் சொன்னார். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","நீ உன் தகப்பனுடைய வீட்டிற்குப் போவதற்கு ஆவலாயிருந்தபடியாலேயே இப்படிப் புறப்பட்டு வந்துவிட்டாய். ஆனால், ஏன் என் வீட்டுச் சிலைகளைத் திருடினாய்?” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","அதற்கு யாக்கோபு லாபானிடம், “உம்முடைய மகள்களை என்னிடமிருந்து பலாத்காரமாய் எடுத்துப்போடுவீரென்று பயந்தே இப்படிச் செய்தேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ஆனால் உம்முடைய வீட்டுச் சிலைகளை வைத்திருப்பவன் எவனையாவது நீர் கண்டுபிடித்தால், அவன் உயிரோடிருக்கமாட்டான். உம்முடைய பொருள்களில் ஏதாவது என்னிடத்திலிருக்கிறதா என்று நீர் எனது உறவினர் முன்னிலையில் சோதித்துப்பாரும்; அப்படியிருந்தால், அவற்றை எடுத்துக்கொள்ளும்” என்றான். ராகேல் வீட்டுச் சிலைகளைத் திருடியதை யாக்கோபு அறியாதிருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","அப்பொழுது லாபான் யாக்கோபின் கூடாரத்துக்குள்ளும், லேயாளின் கூடாரத்துக்குள்ளும், இரண்டு பணிப்பெண்களின் கூடாரத்துக்குள்ளும் தேடிப்பார்த்தும் ஒன்றையும் காணவில்லை. அவன் லேயாளின் கூடாரத்துக்குள்ளிருந்து வெளியே வந்து, பின் ராகேலின் கூடாரத்துக்குள் போனான். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","அங்கு ராகேல், லாபானின் வீட்டுச் சிலைகளை ஒட்டகத்தின் சேணத்திற்குள் வைத்து அதன்மேல் உட்கார்ந்திருந்தாள். லாபான் கூடாரம் முழுதும் தேடியும் ஒன்றையும் கண்டுபிடிக்க முடியவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","ராகேல் தன் தகப்பனிடம், “ஐயா, உமக்குமுன் நான் எழுந்து நிற்கவில்லையென்று கோபிக்க வேண்டாம்; பெண்களுக்குரிய மாதவிடாய் எனக்கு உண்டாயிருக்கிறது” என்றாள். ஆகவே அவன் தேடியும் வீட்டுச் சிலைகளைக் கண்டுபிடிக்க முடியவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","யாக்கோபு கோபமடைந்து லாபானுடன் வாதாடி, “நான் செய்த குற்றமென்ன? நீர் என்னைத் துரத்தி வருவதற்கு நான் செய்த பாவமென்ன? ");
INSERT INTO tamtcv_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","இப்பொழுது என் வீட்டுப் பொருட்களை எல்லாம் சோதித்துப் பார்த்தீரே; உமது வீட்டுக்குரிய பொருட்களில் எதையேனும் கண்டெடுத்தீரோ? அவற்றை உமக்கும் எனக்கும் உறவினர்களான, இவர்கள்முன் இங்கே வையும்; இவர்கள் நம் இருவருக்கும் இடையில் நியாயம் தீர்க்கட்டும். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“நான் உம்முடன் இருபது வருடங்கள் இருந்துவிட்டேன். உம்முடைய செம்மறியாடுகளும், வெள்ளாடுகளும், சினையழியவில்லை; உமது மந்தையிலிருந்த கடாக்களை நான் சாப்பிடவுமில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","காட்டு மிருகங்களால் கிழித்துக் கொல்லப்பட்டவற்றை உம்மிடத்தில் கொண்டுவராமல், அந்த அழிவை நானே ஈடுசெய்தேன்; ஆனால் நீரோ இரவிலோ, பகலிலோ திருட்டுப்போன எவ்வேளையிலும் என்னிடமிருந்தே நஷ்டஈட்டைக் கேட்டு வாங்கிக்கொண்டீர். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","பகலில் வெப்பமும், இரவில் குளிரும் என்னை வாட்டின, என் கண்கள் நித்திரையின்றி இருந்தன. இதுவே என் நிலைமையாய் இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","இவ்விதமாக நான் உமது வீட்டில் இருபது வருடங்கள் இருந்தேன். உமது இரு மகள்களுக்காக பதினாலு வருடங்களும், உம்முடைய மந்தைக்காக ஆறு வருடங்களும் உம்மிடம் வேலைசெய்தேன். நீரோ என் கூலியை பத்துமுறை மாற்றினீர். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","என் தகப்பனின் இறைவனும், ஆபிரகாமின் இறைவனும், ஈசாக்கின் பயபக்திக்கு உரியவருமானவர் என்னோடு இருந்திராவிட்டால், நீர் என்னை நிச்சயமாய் வெறுங்கையுடனேயே அனுப்பியிருப்பீர். ஆனால் இறைவனோ என் கஷ்டங்களையும், என் கையின் வேலைகளையும் கண்டு, நேற்றிரவு உம்மைக் கண்டித்தார்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","அதற்கு லாபான் யாக்கோபிடம், “இந்தப் பெண்கள் என் மகள்கள், இந்தப் பிள்ளைகள் என் பிள்ளைகள், இந்த மந்தையும் என்னுடையதே. நீ காண்பவையெல்லாம் என்னுடையவை. ஆனாலும் என் மகள்களுக்காகவும், அவர்கள் பெற்ற பிள்ளைகளுக்காகவும் நான் என்ன செய்யமுடியும்? ");
INSERT INTO tamtcv_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","இப்பொழுது நீ வா; நீயும் நானும் ஒரு உடன்படிக்கை செய்துகொள்வோம். அது நம் இருவருக்கும் இடையே சாட்சியாக இருக்கட்டும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","எனவே யாக்கோபு ஒரு கல்லை எடுத்து அதை ஒரு தூணாக நிறுத்தினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","அவன் தன் உறவினரிடம், “கற்களைக் குவியுங்கள்” என்றான்; அப்படியே அவர்கள் கற்களை எடுத்து ஒரு குவியலாய்க் குவித்து, அதனருகில் அமர்ந்து சாப்பிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","அவ்விடத்திற்கு லாபான், ஜெகர் சகதூதா என்றும், யாக்கோபு, கலயெத் என்றும் பெயரிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","அப்பொழுது லாபான் யாக்கோபிடம், “இக்குவியல் உனக்கும் எனக்குமிடையே இன்று சாட்சியாக இருக்கிறது” என்றான். அதினாலேயே அது கலயெத் என அழைக்கப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","அது மிஸ்பா என்றும் அழைக்கப்பட்டது. ஏனெனில் அவன் யாக்கோபிடம், “நாம் ஒருவரையொருவர் விட்டுத் தூரமாய் போகும்போது, யெகோவா எனக்கும் உனக்கும் இடையே கண்காணிப்பாராக. ");
INSERT INTO tamtcv_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","நீ என் மகள்களைத் துன்பப்படுத்தினாலோ அல்லது அவர்களைவிட்டு வேறு பெண்களைத் திருமணம் செய்தாலோ, அதற்கு வேறு யாரும் சாட்சியாக இல்லாவிட்டாலும், இறைவனே உனக்கும் எனக்கும் இடையில் சாட்சியாயிருக்கிறார் என்று நினைவில் வைத்துக்கொள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","மேலும் லாபான் யாக்கோபிடம், “இதோ இக்குவியலும், எனக்கும் உனக்கும் இடையில் நான் வைத்த தூணும் இங்கே இருக்கின்றன. ");
INSERT INTO tamtcv_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","நான் இக்குவியலைக் கடந்து உனக்குத் தீங்குசெய்ய உன் பக்கம் வரமாட்டேன் என்பதற்கும், நீயும் இக்குவியலையும், தூணையும் கடந்து என் பக்கமாய் எனக்குத் தீங்குசெய்ய வரமாட்டாய் என்பதற்கும் இக்குவியல் ஒரு சாட்சி; இந்தத் தூணும் ஒரு சாட்சி. ");
INSERT INTO tamtcv_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","ஆபிரகாமின் இறைவனும், நாகோரின் இறைவனும், அவர்கள் தகப்பனின் இறைவனுமாய் இருக்கிறவர் நமக்கிடையில் நியாயம் தீர்ப்பாராக” என்றான். அப்படியே யாக்கோபும் தன் தகப்பனாகிய ஈசாக்கின் பயபக்திக்குரியவரின் பெயரால் ஆணையிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","பின்பு யாக்கோபு அந்த மலைநாட்டில் பலிசெலுத்தி, தன் உறவினர்களைச் சாப்பாட்டுக்கு அழைத்தான். அவர்கள் சாப்பிட்டபின் அன்றிரவு அவ்விடத்தில் தங்கினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","லாபான் மறுநாள் காலையில் தன் பேரப்பிள்ளைகளையும், மகள்களையும் முத்தமிட்டு ஆசீர்வதித்தான். பின்பு அவன் புறப்பட்டுத் தன் வீட்டிற்குத் திரும்பிப்போனான். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","யாக்கோபும் தன் பயணத்தைத் தொடர்ந்தான். அப்பொழுது இறைவனின் தூதர்கள் அவனைச் சந்தித்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","யாக்கோபு அவர்களைக் கண்டபோது, “இது இறைவனின் சேனை!” என்று சொல்லி, அந்த இடத்திற்கு மக்னாயீம் என்று பெயரிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","பின்பு யாக்கோபு, ஏதோம் நாட்டிலுள்ள சேயீர் என்னும் இடத்தில் வசிக்கும் தன் சகோதரன் ஏசாவிடம், தனக்கு முன்பாகத் தூதுவரை அனுப்பினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","அவன் அவர்களுக்கு அறிவுறுத்தி, “நீங்கள் என் ஆண்டவனாகிய ஏசாவிடம் போய், ‘உமது பணியாளன் யாக்கோபு சொல்வது இதுவே: நான் லாபானுடன் இருந்தேன், இதுவரையும் அங்கேயே தங்கியிருந்தேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","என்னிடம் மாடுகளும், கழுதைகளும், செம்மறியாடுகளும், வெள்ளாடுகளும் உண்டு. வேலைக்காரரும் வேலைக்காரிகளும் இருக்கிறார்கள். உமது கண்களில் எனக்குத் தயவு கிடைக்கும்படியாக, இந்த செய்தியை என் எஜமானாகிய உமக்கு அனுப்புகிறேன்’ என்று சொல்லுங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","தூதுவர்கள் யாக்கோபிடம் திரும்பிவந்து, “நாங்கள் உமது சகோதரன் ஏசாவிடம் போனோம், அவர் உம்மைச் சந்திக்க வருகிறார்; அவருடன் நானூறு மனிதரும் வருகிறார்கள்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","அதைக்கேட்ட யாக்கோபு பயமும் மனக்கலக்கமும் அடைந்து, தன்னுடன் இருந்த மனிதரை இரண்டு குழுக்களாகப் பிரித்தான்; ஆட்டு மந்தையையும், மாட்டு மந்தையையும், ஒட்டகங்களையும் இரண்டு குழுக்களாகப் பிரித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","“ஏசா வந்து ஒரு குழுவைத் தாக்கினால் மற்றக் குழுவாவது தப்பும்” என அவன் நினைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","பின்பு யாக்கோபு, “என் தகப்பனான ஆபிரகாமின் இறைவனே, என் தகப்பனான ஈசாக்கின் இறைவனே, ‘நீ உன் நாட்டிற்கும், உன் உறவினரிடத்திற்கும் போ; நான் உன் வாழ்வை வளம்பெறச் செய்வேன்’ என்று சொன்ன யெகோவாவே, ");
INSERT INTO tamtcv_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","உமது பணியாளனாகிய எனக்கு நீர் காட்டிய எல்லாவித இரக்கத்திற்கும், சத்தியத்திற்கும் நான் தகுதியற்றவன். நான் யோர்தான் நதியைக் கடக்கும்போது, ஒரு கோல் மட்டுமே என்னிடம் இருந்தது; ஆனால் இப்பொழுதோ இரு பெரும் மக்கள் கூட்டமாகிவிட்டேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","என் சகோதரன் ஏசாவின் கையிலிருந்தும் என்னைக் காப்பாற்றும் என்று மன்றாடுகிறேன். ஏனெனில், அவன் வந்து என்னையும் என் பிள்ளைகளையும், அவர்கள் தாய்மாரையும் தாக்குவான் என்று பயப்படுகிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","ஆனாலும் நீர், ‘நிச்சயமாகவே நான் உன்னை வளம்பெறச் செய்வேன், உன் சந்ததிகளை எண்ணமுடியாத கடற்கரை மணலைப்போல பெருகப்பண்ணுவேன்’ என்று சொல்லியிருக்கிறீரே” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","அன்றிரவு அவன் அங்கேயே தங்கினான்; பின் தன்னிடம் உள்ளவற்றிலிருந்து தன் சகோதரன் ஏசாவுக்கு அன்பளிப்பாக, ");
INSERT INTO tamtcv_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","இருநூறு வெள்ளாடுகள், இருபது வெள்ளாட்டுக் கடாக்கள், இருநூறு செம்மறியாடுகள், இருபது செம்மறியாட்டுக் கடாக்கள், ");
INSERT INTO tamtcv_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","முப்பது பெண் ஒட்டகங்களுடன் அதன் குட்டிகள், நாற்பது பசுக்கள், பத்து காளைகள், இருபது பெண் கழுதைகள், பத்து ஆண் கழுதைகள் ஆகியவற்றைப் பிரித்தெடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","அவன் ஒவ்வொரு மந்தையையும் தனித்தனியே தன் வேலைக்காரரிடம் ஒப்படைத்து, “மந்தைகளுக்கு இடையில் சிறிது இடம்விட்டு, எனக்கு முன்னே போங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","அவன் முன்னே செல்பவனிடம் அறிவுறுத்திச் சொன்னதாவது: “என் சகோதரன் ஏசா உன்னைச் சந்தித்து, ‘நீ யாருக்குச் சொந்தமானவன்? எங்கே போகிறாய்? உனக்கு முன்னே போகும் இந்த மிருகங்களுக்குச் சொந்தக்காரன் யார்?’ என்று கேட்டால், ");
INSERT INTO tamtcv_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","‘இவை உமது பணியாளன் யாக்கோபுக்குச் சொந்தமானவை; இவற்றைத் தன் ஆண்டவன் ஏசாவுக்கு அன்பளிப்பாக அனுப்பியிருக்கிறார், அவரும் எங்கள் பின்னே வருகிறார்’ என்று சொல்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","“ஏசாவைச் சந்திக்கும்போது இதேவிதமாகவே சொல்லவேண்டும்” என்று இரண்டாவதாகவும், மூன்றாவதாகவும் மந்தைகளைப் பின்தொடர்ந்து சென்ற மற்றவர்களுக்கும் அவன் அறிவுறுத்தினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","“ ‘உமது பணியாளனாகிய யாக்கோபும் எங்கள் பின்னால் வருகிறான்’ என்பதைத் தவறாமல் சொல்லுங்கள்” என்றான். பின்பு, “எனக்கு முன்னால் நான் அனுப்பும் இந்த அன்பளிப்புகளால் நான் அவனைச் சமாதானப்படுத்துவேன்; பிறகு, நான் அவனைக் காணும்போது ஒருவேளை அவன் என்னை ஏற்றுக்கொள்வான்” என நினைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","அப்படியே யாக்கோபின் அன்பளிப்புகள் அவனுக்கு முன்னே கொண்டுபோகப்பட்டன; அவனோ அன்றிரவு கூடாரத்திலேயே தங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","அன்றிரவு யாக்கோபு எழுந்து தன் இரண்டு மனைவிகளையும், இரண்டு பணிப்பெண்களையும், தன் பதினொன்று மகன்களையும் கூட்டிக்கொண்டு யாப்போக்கு ஆற்றின் துறையைக் கடந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","அவன் அவர்களை ஆற்றுக்கு அப்பால் அனுப்பியபின் தனது உடைமைகள் எல்லாவற்றையும் அனுப்பிவைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","அதன்பின் யாக்கோபு தனிமையில் இருந்தான், அப்பொழுது ஒரு மனிதர் வந்து பொழுது விடியும்வரை அவனுடன் போராடினார். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","யாக்கோபை மேற்கொள்ள முடியாதென்பதைக் கண்ட அவர் தொடர்ந்து போராடுகையில், யாக்கோபின் தொடைச்சந்தைத் தொட்டவுடனே தொடைச்சந்து இடம் விலகியது. ");
INSERT INTO tamtcv_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","அப்பொழுது அந்த மனிதர், “என்னைப் போகவிடு; பொழுது விடிகிறது” என்றார். அதற்கு யாக்கோபு, “நீர் என்னை ஆசீர்வதித்தாலன்றி உம்மைப் போகவிடமாட்டேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","அவர், “உன் பெயர் என்ன?” என்று யாக்கோபிடம் கேட்டார். அவன், “யாக்கோபு” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","அப்பொழுது அவர், “உன் பெயர் இனிமேல் யாக்கோபு எனப்படாமல் இஸ்ரயேல் எனப்படும். ஏனெனில், நீ இறைவனோடும் மனிதரோடும் போராடி வெற்றி கொண்டாய்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","அப்பொழுது யாக்கோபு அவரிடம், “தயவுசெய்து உம்முடையப் பெயரை எனக்குச் சொல்லும்” என்றான். அதற்கு அவர், “நீ ஏன் என் பெயரைக் கேட்கிறாய்?” என்று கேட்டு, அவனை ஆசீர்வதித்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","உடனே யாக்கோபு, “நான் இறைவனை முகமுகமாய்க் கண்டும் இன்னும் என் உயிர் தப்பியிருக்கிறது” என்று சொல்லி, அவ்விடத்திற்குப் பெனியேல் என்று பெயரிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","அவன் பெனியேலைக் கடந்து போகையில், அவனுக்கு மேலாகச் சூரியன் உதித்தது. அவனுடைய தொடைச்சந்து இடம்விலகி இருந்ததால், அவன் நொண்டிக்கொண்டு நடந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","யாக்கோபின் தொடைச்சந்து அருகேயிருந்த தசைநார் தொடப்பட்டபடியால், இஸ்ரயேலர் இந்நாள்வரை தொடைச்சந்துடன் இணைந்திருக்கும் தசைநாரைச் சாப்பிடுவதில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","யாக்கோபு நிமிர்ந்து பார்த்தபோது, தொலைவில் ஏசா நானூறு பேருடன் வருவதைக் கண்டான்; ஆகவே அவன் லேயாளிடமும், ராகேலிடமும், இரு பணிப்பெண்களிடமும் பிள்ளைகளைப் பிரித்துக்கொடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","இருபணிப் பெண்களையும் அவர்கள் பிள்ளைகளையும், முன்னால் நிறுத்தினான். அடுத்தாக லேயாளையும் அவள் பிள்ளைகளையும், கடைசியில் ராகேலையும் யோசேப்பையும் நிறுத்தினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","அவர்களுக்கு முன்பாகச் சென்ற யாக்கோபு, தன் சகோதரனாகிய ஏசா நெருங்கிவந்து கொண்டிருப்பதைக் கண்டு, ஏழுமுறை தரைமட்டும் குனிந்து அவனை வாழ்த்தினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","ஆனால் ஏசாவோ, யாக்கோபைக் கண்டதும் ஓடிப்போய், அவனைத் தழுவி, அவன் கழுத்தைக் கட்டிப்பிடித்து முத்தமிட்டான். இருவருமே அழுதார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","பின்பு ஏசா நிமிர்ந்து பார்த்து, பெண்களையும் பிள்ளைகளையும் கண்டபோது, “உன்னோடிருக்கும் இவர்கள் யார்?” என்று யாக்கோபிடம் கேட்டான். அதற்கு அவன், “இவர்கள் உமது அடியவனாகிய எனக்கு இறைவன் கிருபையாய்த் தந்த பிள்ளைகள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","அப்பொழுது பணிப்பெண்களும் அவர்களுடைய பிள்ளைகளும் வந்து குனிந்து வணங்கினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","அடுத்ததாக லேயாளும் தன் பிள்ளைகளுடன் வந்து வணங்கினாள். கடைசியாக ராகேலும் யோசேப்பும் வந்து வணங்கினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","அப்பொழுது ஏசா, “நான் வழியிலே சந்தித்த மிருகக் கூட்டங்களை நீ அனுப்பியதன் காரணம் என்ன?” என்று கேட்டான். அதற்கு யாக்கோபு, “ஆண்டவனே! அது உம்முடைய கண்களில் தயவு கிடைக்கவேண்டும் என்பதற்காகவே” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","அதற்கு ஏசா, “என் சகோதரனே, ஏற்கெனவே என்னிடம் ஏராளம் இருக்கின்றன. உன்னிடம் உள்ளவற்றை நீயே வைத்துக்கொள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","அதற்கு யாக்கோபு, “அப்படியல்ல, உம்முடைய கண்களில் எனக்குத் தயவு கிடைக்குமானால், என்னிடமிருந்து இந்த அன்பளிப்பை ஏற்றுக்கொள்ளும். இப்பொழுது என்னை நீர் தயவாய் ஏற்றுக்கொண்டிருக்கிறபடியால், நான் உமது முகத்தைப் பார்ப்பது இறைவனுடைய முகத்தைப் பார்ப்பதுபோல் இருக்கிறது. ");
INSERT INTO tamtcv_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","இறைவன் என்மேல் இரக்கமுடையவராயிருக்கிறார், எனக்குத் தேவையானவை எல்லாம் என்னிடம் இருக்கின்றன. எனவே உமக்குக் கொண்டுவரப்பட்ட அன்பளிப்புகளைத் தயவுசெய்து ஏற்றுக்கொள்ளும்” என்று சொன்னான். அவ்வாறு அவன் வற்புறுத்தியபடியால் ஏசா அவற்றை ஏற்றுக்கொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","அதன்பின்பு ஏசா, “வா, நாம் புறப்பட்டுச் செல்வோம்; நான் உன்முன் செல்கிறேன்” என்று யாக்கோபைக் கூப்பிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","அதற்கு யாக்கோபு ஏசாவிடம், “எனது பிள்ளைகளோ சிறு குழந்தைகள், அதோடு பால் கொடுக்கும் ஆடுகளையும், பசுக்களையும் நான் கவனிக்க வேண்டும் என்றும் என் ஆண்டவனுக்குத் தெரியும். அவற்றை ஒரே நாளில் வருத்தி ஓட்டிக்கொண்டு போனால் எல்லா மிருகங்களும் இறந்துவிடும். ");
INSERT INTO tamtcv_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ஆகையால் என் ஆண்டவனாகிய நீர் உமது அடியானுக்கு முன்னே செல்லும்; நான் உமக்குப் பின்னால் என் பிள்ளைகளுடைய மந்தைகளுடைய நடையின் வேகத்திற்குத் தக்கதாக நடந்து, உமது இருப்பிடமாகிய சேயீரை வந்து சேருவேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","அப்பொழுது ஏசா, “அப்படியானால் என்னுடைய ஆட்களில் சிலரை உன்னுடன் விட்டுப் போகிறேன்” என்றான். அதற்கு யாக்கோபு, “அப்படிச் செய்வானேன்? என் ஆண்டவனுடைய கண்களில் எனக்குத் தயவு கிடைத்தால் மட்டும் போதும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","எனவே ஏசா, அன்றைக்கே சேயீருக்குத் திரும்பிப் போகப் புறப்பட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","ஆனால் யாக்கோபு, சுக்கோத்துக்குப் போய் அங்கே தனக்கு ஒரு இடத்தை அமைத்து, தன் வளர்ப்பு மிருகங்களுக்கும் குடில்களைப் போட்டான், அதினாலேயே அந்த இடத்திற்குச் சுக்கோத் என்னும் பெயர் வந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","பின்பு யாக்கோபு பதான் அராமிலிருந்து புறப்பட்டு, பாதுகாப்பாக கானான் நாட்டிலுள்ள சீகேம் பட்டணத்திற்கு வந்து, அங்கே அந்த பட்டணம் தெரியக்கூடிய இடத்தில் கூடாரம் அமைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","யாக்கோபு தான் கூடாரம் அமைத்த அந்த நிலத்தை, ஏமோரின் மகன்களிடமிருந்து நூறு வெள்ளிக்காசுக்கு வாங்கினான். இந்த ஏமோர் சீகேமின் தகப்பன். ");
INSERT INTO tamtcv_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","அங்கே யாக்கோபு ஒரு பலிபீடத்தைக் கட்டி அதற்கு, ஏல்எல்லோகே இஸ்ரயேல் என்று பெயரிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","ஒரு நாள், லேயாள் யாக்கோபுக்குப் பெற்ற மகள் தீனாள், அந்த நாட்டுப் பெண்களைச் சந்திப்பதற்காகப் போனாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","அவ்வேளை அந்நாட்டின் ஆளுநனான ஏமோரின் மகன் சீகேம் என்னும் ஏவியன் அவளைக் கண்டு, அவளைப் பலவந்தமாய்க் கொண்டுபோய்க் கற்பழித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","யாக்கோபின் மகள் தீனாளின் பக்கமாய் அவன் உள்ளம் கவரப்பட்டிருந்தது; அவன் அவளை நேசித்து அவளுடைய உள்ளத்தைக் கவரும்படி பேசினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","எனவே சீகேம் தன் தகப்பன் ஏமோரிடம், “இந்தப் பெண்ணை எனக்கு மனைவியாகத் தாரும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","தன் மகள் தீனாள் கறைப்பட்டதை யாக்கோபு கேள்விப்படுகையில், அவனுடைய மகன்கள் வயல்வெளியில் மந்தைகளுடன் இருந்தார்கள்; எனவே அவர்கள் வீட்டுக்கு வரும்வரை, யாக்கோபு அமைதியாய் இருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","அப்பொழுது சீகேமின் தகப்பனான ஏமோர் யாக்கோபிடம் பேசுவதற்காகப் போனான். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","நடந்ததைக் கேள்விப்பட்டதுமே, யாக்கோபின் மகன்கள் வயலில் இருந்து வீட்டுக்குத் திரும்பி வந்தனர். சீகேம் யாக்கோபின் மகளுடன் உறவுகொண்டு, செய்யத்தகாத அவமானமான காரியத்தை இஸ்ரயேலிலே செய்தான். அதனால் அவர்கள் அதிர்ச்சியும் ஆத்திரமும் அடைந்தனர். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","ஆனால் ஏமோர் அவர்களிடம், “என் மகன் சீகேம் உங்கள் மகளிடம் தன் உள்ளத்தைப் பறிகொடுத்து விட்டான். ஆகையால் தயவுசெய்து அவளை அவனுக்கு மனைவியாகக் கொடுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","நீங்கள் எங்களுடன் கலப்புத்திருமணம் செய்துகொள்ளுங்கள்; உங்கள் மகள்களை எங்களுக்குக் கொடுத்து, எங்கள் மகள்களை உங்களுக்கு எடுத்துக்கொள்ளுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","நீங்கள் எங்கள் மத்தியில் குடியிருக்கலாம்; எங்கள் நாடு உங்களுக்கு முன்னால் இருக்கிறது. அதில் வாழ்ந்து, வியாபாரம் செய்து அதிலே சொத்துக்களைச் சொந்தமாக்கிக் கொள்ளுங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","பின்பு சீகேம், தீனாளின் தகப்பனிடமும் அவள் சகோதரரிடமும், “உங்கள் கண்களில் எனக்குத் தயை கிடைக்கட்டும், நீங்கள் கேட்பது எதுவோ, அதை நான் உங்களுக்குக் கொடுப்பேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","மணப்பெண்ணுக்குரிய சீதனத்தையும், நான் கொண்டுவரவேண்டிய நன்கொடையையும் எவ்வளவு என எனக்குச் சொல்லுங்கள்; எவ்வளவு அதிகமானாலும் நீங்கள் கேட்பதை நான் உங்களுக்குக் கொடுப்பேன். அந்தப் பெண்ணை மட்டும் எனக்கு மனைவியாகக் கொடுங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","சீகேம் தங்கள் சகோதரி தீனாளைக் கறைப்படுத்தியதால், யாக்கோபின் மகன்கள் சீகேமிடமும் அவன் தகப்பன் ஏமோரிடமும் பேசுகையில், வஞ்கமாகப் பதிலளித்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","யாக்கோபின் மகன்கள் அவர்களிடம், “நாங்கள் இப்படிப்பட்ட செயலைச் செய்யமாட்டோம்; ஏனெனில், விருத்தசேதனம் செய்யப்படாத ஒருவனுக்கு எங்கள் சகோதரியைக் கொடுக்க முடியாது. அது எங்களுக்குப் பெரிய அவமானமாய் இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","உங்கள் ஆண்கள் யாவரும் எங்களைப்போல் விருத்தசேதனம் செய்யவேண்டும் என்கிற இந்த நிபந்தனைக்கு நீங்கள் ஒத்துக்கொண்டால் மாத்திரமே நாங்கள் இதற்கு உடன்படுவோம். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","அதன்பின் நாங்கள் எங்கள் மகள்களை உங்களுக்குக் கொடுத்து, உங்கள் மகள்களை எங்களுக்காக எடுத்துக்கொள்வோம். நாங்கள் உங்கள் மத்தியில் குடியிருந்து, உங்களுடன் ஒரே மக்கள் கூட்டமாகலாம். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","விருத்தசேதனம் செய்வதற்கு நீங்கள் சம்மதிக்காவிட்டால், எங்கள் சகோதரியைக் கூட்டிக்கொண்டு போய்விடுவோம்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","அவர்கள் கேட்டுக்கொண்ட இக்கோரிக்கை ஏமோருக்கும் சீகேமுக்கும் நலமானதாய்த் தோன்றியது. ");
INSERT INTO tamtcv_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","வாலிபனான சீகேம் யாக்கோபின் மகள் தீனாள்மீது அதிக ஆசை கொண்டபடியால், அவர்கள் கேட்டதைச் செய்யத் தாமதிக்கவில்லை. சீகேம் தனது தந்தையின் வீட்டிலுள்ள எல்லோருக்குள்ளும் மதிப்புக்குரியவனாய் இருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","அப்படியே ஏமோரும் அவன் மகன் சீகேமும் தங்கள் பட்டணத்து மனிதருடன் பேசுவதற்குத் தங்கள் பட்டணத்து வாசலுக்கு வந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","அவர்களிடம், “இந்த மனிதர் நம்முடன் நட்பாயிருக்கிறார்கள்; இவர்கள் நம் நாட்டில் வாழ்ந்து வியாபாரம் செய்யட்டும். நாட்டில் அவர்களுக்கும் போதிய இடமுண்டு. அவர்கள் நம்முடைய மகள்களைத் திருமணம் செய்யலாம், நாம் அவர்களின் மகள்களைத் திருமணம் செய்யலாம். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","ஆனால் அவர்களைப் போலவே நம் மத்தியிலுள்ள ஆண்களும் விருத்தசேதனம் செய்யப்படவேண்டும் என்ற நிபந்தனையை நாம் ஏற்றுக்கொண்டால் மட்டுமே அவர்கள் நம்முடன் ஒரே மக்கள் கூட்டமாக வாழ உடன்படுவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","அவர்களுடைய சொத்துக்களும், வளர்ப்பு மிருகங்களும், மற்ற எல்லா மிருகங்களும் நமக்குச் சொந்தமாகும் அல்லவா? ஆகையால் நாம் நமது சம்மதத்தைத் தெரிவிப்போம். அவர்கள் நம் மத்தியில் குடியிருப்பார்கள்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","பட்டணத்து வாசலுக்கு வெளியே போன மனிதர் எல்லோரும் ஏமோரும் அவன் மகன் சீகேமும் சொன்னவற்றை ஏற்றுக்கொண்டார்கள்; அவ்வாறே பட்டணத்திலுள்ள எல்லா ஆண்களும் விருத்தசேதனம் செய்யப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","மூன்று நாட்களுக்குப்பின் அவர்கள் யாவரும் இன்னும் நோவுடன் இருக்கையில், தீனாளின் சகோதரர்களான சிமியோன், லேவி என்னும் யாக்கோபின் இரு மகன்களும் வாள்களுடன் போய், பட்டணத்து மக்கள் எதிர்பாராத வேளையில் அதைத் தாக்கி, எல்லா ஆண்களையும் கொன்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ஏமோரையும் அவன் மகன் சீகேமையும் வாளால் வெட்டிக் கொன்றபின், சீகேமின் வீட்டிலிருந்த தீனாளைத் தங்களுடன் கூட்டிக்கொண்டு போனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","பட்டணத்து மனிதர் கொலைசெய்யப்பட்டுக் கிடக்கையில் யாக்கோபின் மகன்கள் அந்த உடல்களின்மேல் நடந்து வந்து, தங்கள் சகோதரியைக் கறைப்படுத்திய அந்தப் பட்டணத்தைக் கொள்ளையடித்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","அவர்கள் ஆடுமாடுகளையும், கழுதைகளையும் மற்றும் பட்டணத்திலும் வயல்வெளிகளிலும் உள்ள அவர்களுக்குச் சொந்தமான எல்லாவற்றையும் அபகரித்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","அவர்கள் அங்கிருந்த எல்லா செல்வத்தையும், பெண்கள் பிள்ளைகள் எல்லோரையும், வீடுகளிலிருந்த எல்லாவற்றையும் கொள்ளையாகக் கொண்டுபோனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","அப்பொழுது யாக்கோபு தன் மகன்களான சிமியோன், லேவி ஆகியோரிடம், “இந்நாட்டில் வாழும் கானானியரிடத்திலும், பெரிசியரிடத்திலும் என் பெயரை நாசமாக்கி, எனக்குக் கஷ்டத்தை உண்டு பண்ணிவிட்டீர்களே! நாமோ மிகச் சிலர், அவர்கள் எல்லோரும் ஒன்றுசேர்ந்து நம்மைத் தாக்கினால், நானும் என் குடும்பமும் அழிந்துபோவோமே!” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","அதற்கு அவர்கள், “அப்படியானால் எங்கள் சகோதரி தீனாளை அவன் ஒரு வேசியைப்போல் நடத்தியது சரியோ?” என்று கேட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","அதன்பின் இறைவன் யாக்கோபிடம், “நீ பெத்தேலுக்குப் போய் அங்கே குடியிரு, நீ உன் சகோதரன் ஏசாவுக்குப் பயந்து ஓடிப்போகிற வழியில், உனக்குத் தோன்றிய இறைவனுக்கு அவ்விடத்தில் ஒரு பலிபீடத்தைக் கட்டு” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","எனவே யாக்கோபு தன் குடும்பத்தாரிடமும், தன்னோடிருந்த எல்லோரிடமும், “நீங்கள் வைத்திருக்கும் அந்நிய தெய்வங்களை விலக்கிப் போடுங்கள்; உங்களைத் தூய்மைப்படுத்தி, உங்கள் உடைகளை மாற்றுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","அதன்பின் வாருங்கள், எல்லோரும் பெத்தேலுக்குப் போவோம். என் துயர நாட்களில் என் மன்றாட்டைக் கேட்டு, நான் போன இடமெல்லாம் என்னுடன் இருந்த இறைவனுக்கு, அங்கே ஒரு பலிபீடத்தைக் கட்டுவேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","அப்பொழுது அவர்கள் தங்களிடமிருந்த அந்நிய தெய்வங்கள் எல்லாவற்றையும், தங்கள் காதணிகளையும் யாக்கோபிடம் கொடுத்தார்கள்; அவன் அவற்றையெல்லாம் சீகேமில் ஒரு பெரிய கர்வாலி மரத்தின்கீழ் புதைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","அதன்பின் அவர்கள் அவ்விடத்தைவிட்டுப் புறப்பட்டார்கள்; அப்பொழுது அவர்களைச் சூழ இருந்த பட்டணத்தின் மக்களின்மேல் இறைவனின் பயங்கரம் இறங்கியது. அதனால் அவர்கள் ஒருவரும் அவர்களைப் பின்தொடரவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","யாக்கோபும் அவனுடன் இருந்த மக்கள் எல்லோரும், கானான் நாட்டிலுள்ள லூஸ் என அழைக்கப்பட்ட பெத்தேலுக்கு வந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","அங்கே அவன் ஒரு பலிபீடத்தைக் கட்டி, அந்த இடத்தை ஏல்பெத்தேல் என அழைத்தான். ஏனெனில், அவன் தன் சகோதரனுக்குப் பயந்து ஓடியபோது அவ்விடத்திலேயே இறைவன் தம்மை அவனுக்கு வெளிப்படுத்தினார். ");
INSERT INTO tamtcv_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","ரெபெக்காளின் மருத்துவச்சி தெபோராள் இறந்து, பெத்தேலுக்கு அருகிலுள்ள கர்வாலி மரத்தின்கீழ் அடக்கம்பண்ணப்பட்டாள். அந்த இடத்திற்கு அல்லோன் பாகூத் எனப் பெயரிடப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","யாக்கோபு பதான் அராமிலிருந்து திரும்பி வருகையில், இறைவன் மறுபடியும் அவனுக்குத் தோன்றி, அவனை ஆசீர்வதித்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","இறைவன் அவனிடம், “உன் பெயர் யாக்கோபு, ஆனால் நீ இனிமேல் யாக்கோபு என்று அழைக்கப்படாமல் இஸ்ரயேல் என்றே அழைக்கப்படுவாய்” என்று சொல்லி, அவனுக்கு இஸ்ரயேல் என்று பெயரிட்டார். ");
INSERT INTO tamtcv_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","மேலும் இறைவன், “எல்லாம் வல்ல இறைவன் நானே; நீ பலுகி, எண்ணிக்கையில் பெருகுவாயாக. உன்னிலிருந்து ஒரு நாடும், நாடுகளின் கூட்டமும் தோன்றும்; உன் சந்ததியிலிருந்து அரசர்களும் தோன்றுவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","ஆபிரகாமுக்கும் ஈசாக்குக்கும் நான் கொடுத்த நாட்டை உனக்கும் கொடுக்கிறேன்; உனக்குப்பின் உன் சந்ததிக்கும் இதைக் கொடுப்பேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","இதன்பின் இறைவன் அவனுடன் பேசிக்கொண்டிருந்த இடத்திலிருந்து மேலே போய்விட்டார். ");
INSERT INTO tamtcv_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","இறைவன் தன்னுடன் பேசிய அந்த இடத்தில் யாக்கோபு ஒரு கல்தூணை நிறுத்தினான்; அதன்மேல் பானகாணிக்கையையும் எண்ணெயையும் ஊற்றினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","இறைவன் தன்னுடன் பேசிய அவ்விடத்துக்கு யாக்கோபு பெத்தேல் என்று பெயரிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","அதன்பின் அவர்கள் பெத்தேலில் இருந்து புறப்பட்டுப் போனார்கள். எப்பிராத்தாவிற்கு வர சற்றுத் தூரத்தில் இருக்கும்போதே, ராகேல் பிரசவ வேதனையால் மிகவும் கஷ்டப்பட்டாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","அவள் பிரசவத்தில் கஷ்டப்பட்டுக் கொண்டிருக்கையில் மருத்துவச்சி அவளிடம், “பயப்படாதே, உனக்கு இன்னுமொரு மகன் பிறந்திருக்கிறான்” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","மரணத் தருவாயில் அவள் கடைசிமூச்சு விடும்போது பிறந்த மகனுக்கு பெனொனி என்று பெயரிட்டாள். ஆனால் அவன் தகப்பனோ, அவனுக்கு பென்யமீன் என்று பெயரிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ராகேல் இறந்து பெத்லெகேம் என்னும் எப்பிராத்தாவுக்குப் போகும் வழியிலே அடக்கம்பண்ணப்பட்டாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","யாக்கோபு அவள் கல்லறைக்குமேல் ஒரு தூணை நிறுத்தினான். இந்நாள்வரை அத்தூண் ராகேலின் கல்லறையின் அடையாளமாக இருக்கிறது. ");
INSERT INTO tamtcv_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","இஸ்ரயேல் திரும்பவும் தொடர்ந்து பயணம் செய்து, மிக்தால் ஏதேருக்கு அப்பால் தன் கூடாரத்தை அமைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","யாக்கோபு அப்பிரதேசத்தில் குடியிருக்கையில், ரூபன் தன் தகப்பனின் வைப்பாட்டி பில்காளுடன் உறவுகொண்டான்; அதை இஸ்ரயேல் கேள்விப்பட்டான். யாக்கோபுக்கு பன்னிரண்டு மகன்கள் இருந்தார்கள்: ");
INSERT INTO tamtcv_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","லேயாளின் மகன்கள்: யாக்கோபின் மூத்த மகனான ரூபன், சிமியோன், லேவி, யூதா, இசக்கார், செபுலோன் என்பவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","ராகேலின் மகன்கள்: யோசேப்பு, பென்யமீன் என்பவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","ராகேலின் பணிப்பெண் பில்காள் பெற்ற மகன்கள்: தாண், நப்தலி என்பவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","லேயாளின் பணிப்பெண் சில்பாள் பெற்ற மகன்கள்: காத், ஆசேர் என்பவர்கள். பதான் அராமில் யாக்கோபுக்குப் பிறந்த மகன்கள் இவர்களே. ");
INSERT INTO tamtcv_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","யாக்கோபு கீரியாத் அர்பாவுக்கு அருகேயிருந்த எப்ரோன் எனப்படும் மம்ரேயில் வசித்த தன் தகப்பன் ஈசாக்கின் வீட்டுக்குத் திரும்பிவந்தான். ஆபிரகாமும் ஈசாக்கும் முன்பு அவ்விடத்திலேயே குடியிருந்தனர். ");
INSERT INTO tamtcv_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ஈசாக்கு நூற்று எண்பது வருடங்கள் உயிரோடிருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","பின்பு ஈசாக்கு தன் இறுதி மூச்சைவிட்டு இறந்தான்; பூரண ஆயுள் உள்ளவனாய் தன் முன்னோருடன் சேர்க்கப்பட்டான். அவனுடைய மகன்களான ஏசாவும், யாக்கோபும் அவனை அடக்கம்பண்ணினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","ஏதோம் என்று அழைக்கப்படும் ஏசாவின் வம்சவரலாறு: ");
INSERT INTO tamtcv_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","ஏசா கானான் நாட்டுப் பெண்களிலிருந்து மனைவிகளை எடுத்தான்: ஏத்தியனான ஏலோனின் மகள் ஆதாளையும், ஏவியனான சிபியோனின் பேத்தியும் ஆனாகின் மகளுமான அகோலிபாமாளையும் திருமணம் செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","அத்துடன் இஸ்மயேலின் மகளும் நெபாயோத்தின் சகோதரியுமான பஸ்மாத்தையும் மனைவியாக்கிக் கொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","ஆதாள் ஏசாவுக்கு எலிப்பாஸைப் பெற்றாள், பஸ்மாத் ரெகுயேலைப் பெற்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","அகோலிபாமாள் எயூஷ், யாலாம், கோராகு ஆகியோரைப் பெற்றாள். கானானில் ஏசாவுக்கு பிறந்த மகன்கள் இவர்களே. ");
INSERT INTO tamtcv_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ஏசா தன் மனைவிகள், மகன்கள், மகள்களோடு, தன் வீட்டிலுள்ள எல்லோரையும் அழைத்துக்கொண்டு போனான். அவர்களுடன் தன் வளர்ப்பு மிருகங்களையும், மற்ற மிருகங்கள் எல்லாவற்றையும், கானானில் தான் சம்பாதித்த பொருட்கள் யாவற்றையும் எடுத்துக்கொண்டு, தன் சகோதரன் யாக்கோபை விட்டுச் சற்றுத் தூரமான நாட்டுக்குப் போனான். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","அவர்களுடைய உடைமைகள் அதிகமாய் இருந்தபடியால், அவர்களால் ஒரே இடத்தில் சேர்ந்து வாழ முடியவில்லை; அவர்களுடைய வளர்ப்பு மிருகங்கள் அதிகமாய் இருந்தபடியால், அவர்கள் இருந்த நிலப்பகுதி அவர்களுக்கு போதுமானதாக இல்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","ஆதலால் ஏதோம் என்னும் ஏசா, சேயீர் மலைநாட்டில் குடியேறினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","சேயீர் மலைநாட்டில் குடியிருந்த ஏதோமியரின் தகப்பனான ஏசாவின் வம்சவரலாறு. ");
INSERT INTO tamtcv_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ஏசாவின் மகன்களின் பெயர்கள் இவையே: ஏசாவின் மனைவியான ஆதாளின் மகன் எலிப்பாஸ், ஏசாவின் மனைவியான பஸ்மாத்தின் மகன் ரெகுயேல். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","எலிப்பாஸின் மகன்கள்: தேமான், ஓமார், செப்போ, கத்தாம், கேனாஸ் என்பவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ஏசாவின் மகன் எலிப்பாஸுக்கு திம்னாள் என்னும் வைப்பாட்டி இருந்தாள்; அவள் அவனுக்கு அமலேக்கைப் பெற்றாள். இவர்கள் ஏசாவின் மனைவி ஆதாளின் பேரன்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","ரெகுயேலின் மகன்கள்; நாகாத், செராகு, சம்மா, மீசா. இவர்கள் ஏசாவின் மனைவி பஸ்மாத்தின் பேரன்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","சிபியோனின் பேத்தியும் ஆனாகின் மகளுமான அகோலிபாமாள் ஏசாவுக்குப் பெற்ற மகன்கள்: எயூஷ், யாலாம், கோராகு என்பவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ஏசாவின் சந்ததிகளில் வந்த வம்சத்தலைவர்கள்: ஏசாவின் மூத்த மகனான எலிப்பாஸின் மகன்கள்: தேமான், ஓமார், செப்போ, கேனாஸ், ");
INSERT INTO tamtcv_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","கோராகு, கத்தாம், அமலேக்கு என்பவர்கள். ஏதோம் நாட்டிலுள்ள எலிப்பாஸின் வழிவந்த வம்சத்தலைவர்கள் இவர்களே. இவர்கள் ஆதாளின் பேரன்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","ஏசாவின் மகன் ரெகுயேலின் மகன்கள்: நகாத், செராகு, சம்மா, மீசா ஆகியோரும் வம்சத்தலைவர்களே. இவர்கள் ஏதோம் நாட்டிலுள்ள ரெகுயேலின் வழிவந்த வம்சத்தலைவர்கள்; இவர்கள் ஏசாவின் மனைவி பஸ்மாத்தின் பேரன்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","ஏசாவின் மனைவி அகோலிபாமாளின் மகன்கள்: எயூஷ், யாலாம், கோராகு ஆகியோரும் வம்சத்தலைவர்களே. இவர்கள் ஆனாகின் மகளும் ஏசாவின் மனைவியுமான அகோலிபாமாளின் வழிவந்தவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","ஏதோம் என்னும் ஏசாவின் மகன்கள் இவர்களே. இவர்கள் அவர்களின் வம்சத்தலைவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","அந்த நிலப்பரப்பில் வாழ்ந்துகொண்டிருந்த ஓரியரான சேயீரின் மகன்கள்: லோத்தான், சோபால், சிபியோன், ஆனாகு, ");
INSERT INTO tamtcv_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","திஷோன், ஏசேர், திஷான். ஏதோமிலிருந்த சேயீரின் இந்த மகன்கள் ஓரியரின் வம்சத்தலைவர்கள் ஆவர். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","லோத்தானின் மகன்கள்: ஓரி, ஓமாம். திம்னாள் லோத்தானின் சகோதரி. ");
INSERT INTO tamtcv_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","சோபாலின் மகன்கள்: அல்வான், மானகாத், ஏபால், செப்போ, ஓனாம். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","சிபியோனின் மகன்கள்: அயா, ஆனாகு என்பவர்கள். இந்த ஆனாகுவே, தன் தகப்பன் சிபியோனின் கழுதைகளை மேய்த்துக் கொண்டிருக்கும்போது, பாலைவனத்திலே வெந்நீரூற்றுக்களைக் கண்டுபிடித்தவன். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","ஆனாகின் பிள்ளைகள்: திஷோன், ஆனாகின் மகளான அகோலிபாமாள் என்பவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","திஷோனுடைய மகன்கள்: எம்தான், எஸ்பான், இத்ரான், கெரான் என்பவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","ஏசேருடைய மகன்கள்: பில்கான், சகவான், அக்கான் என்பவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","திஷானுடைய மகன்கள். ஊத்ஸ், அரான் என்பவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","ஓரியரின் வம்சத்தலைவர்கள்: லோத்தான், சோபால், சிபியோன், ஆனாகு, ");
INSERT INTO tamtcv_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","திஷோன், ஏசேர், திஷான் என்பவர்கள். இவர்கள் சேயீர் நாட்டில் தங்கள் ஓரியர் வம்சப் பிரிவுகளின்படி வம்சத்தலைவர்களாய் இருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","இஸ்ரயேல் மக்களை ஒரு அரசர் ஆட்சி செய்யுமுன், ஏதோம் நாட்டில் அரசாண்ட அரசர்கள்: ");
INSERT INTO tamtcv_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","பேயோரின் மகன் பேலா ஏதோமில் அரசனானான். அவனுடைய பட்டணம் தின்காபா எனப் பெயரிடப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","பேலா இறந்தபின்பு, போஸ்றாவைச் சேர்ந்த சேராகின் மகன் யோபாப் அவனுக்குப்பின் அரசனானான். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","யோபாப் இறந்தபின்பு, அவனுடைய இடத்தில் தேமான் நாட்டைச் சேர்ந்த உஷாம் அரசனானான். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","உஷாம் இறந்தபின்பு, மோவாப் நாட்டிலே மீதியானியரை முறியடித்த பேதாதின் மகன் ஆதாத் அவனுடைய இடத்தில் அரசனானான். இவனுடைய பட்டணம் ஆவீத் எனப் பெயரிடப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ஆதாத் இறந்தபின்பு அவனுடைய இடத்தில் மஸ்ரேக்கா என்னும் இடத்தைச் சேர்ந்த சம்லா அரசனானான். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","சம்லா இறந்தபின்பு, ஆற்றின் அருகில் உள்ள ரெகொபோத் என்னுமிடத்தைச் சேர்ந்த சாவூல் அவனுடைய இடத்தில் அரசனானான். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","சாவூல் இறந்தபின்பு அவனுடைய இடத்தில் அக்போரின் மகன் பாகால்கானான் அரசனானான். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","அக்போருடைய மகனாகிய பாகால்கானான் இறந்தபின்பு, அவனுடைய இடத்தில் ஆதாத் அரசனானான். இவனது பட்டணம் பாகு எனப் பெயரிடப்பட்டது. இவனது மனைவியின் பெயர் மெகேதபேல்; இவள் மத்ரேத்தின் மகளும் மேசகாபின் பேத்தியுமாவாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","பெயரின்படியும், வம்சத்தின்படியும், நிலப்பரப்பின்படியும் ஏசாவின் வழிவந்த வம்சத்தலைவர்கள்: திம்னா, அல்வா, ஏதேத், ");
INSERT INTO tamtcv_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","அகோலிபாமா, ஏலா, பினோன், ");
INSERT INTO tamtcv_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","கேனாஸ், தேமான், மிப்சார், ");
INSERT INTO tamtcv_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","மக்தியேல், ஈராம் என்பவர்களாகும். அவர்கள் குடியேறிய நாட்டில் அவர்களின் குடியிருப்புகளின்படி ஏதோமின் வம்சத்தலைவர்கள் இவர்களே. இவையே ஏசாவின் வம்சவரலாறு, இவன் ஏதோமியருக்குத் தகப்பன். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","யாக்கோபு தன் தகப்பன் தங்கியிருந்த கானான் நாட்டிற்குத் திரும்பவும் வந்து அங்கே வாழ்ந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","யாக்கோபின் வம்சவரலாறு இதுவே: யோசேப்பு பதினேழு வயது வாலிபனாய் இருந்தபோது, தன் தகப்பனின் மனைவிகளான பில்காள், சில்பாள் ஆகியோரின் மகன்களாகிய தனது சகோதரருடன் மந்தை மேய்ப்பது வழக்கம். அவர்களின் கெட்டசெயல்களைப் பற்றி யோசேப்பு தன் தகப்பனுக்கு அறிவித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","இஸ்ரயேல் வயது முதிர்ந்தவனாய் இருக்கையில் யோசேப்பு தனக்குப் பிறந்ததினால், அவனைத் தன் மற்ற மகன்களைவிட அதிகமாக நேசித்தான்; இதனால் சிறப்பாக அலங்கரிக்கப்பட்ட ஒரு மேலுடையை அவனுக்காக செய்வித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","தங்கள் தகப்பன் தங்களைப்பார்க்கிலும் யோசேப்பை அதிகமாக நேசித்ததை அவன் சகோதரர் கண்டார்கள்; அதனால் அவர்கள் அவனுடன் தயவாய்ப் பேசாமல் அவனை வெறுத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","யோசேப்பு ஒரு கனவு கண்டான், அதை அவன் தன் சகோதரருக்குச் சொன்னபோது, அவர்கள் அவனை இன்னும் அதிகமாக வெறுத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","அவன் தன் சகோதரரிடம், “நான் கண்ட கனவைக் கேளுங்கள்: ");
INSERT INTO tamtcv_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","நாம் வயலில் அறுவடை செய்த கதிர்களைக் கட்டிக்கொண்டிருந்தோம், அப்பொழுது திடீரென எனது கதிர்க்கட்டு எழுந்து நிமிர்ந்து நின்றது; அந்நேரம் உங்கள் கதிர்க்கட்டுகள் என் கதிர்க்கட்டைச் சுற்றி நின்று குனிந்து வணங்கின” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","அப்பொழுது அவன் சகோதரர் அவனிடம், “நீ எங்கள்மேல் ஆளுகைசெய்ய எண்ணம் கொண்டிருக்கிறாயோ? நீ உண்மையாகவே எங்களை ஆளப்போகிறாயோ?” என்று கேட்டார்கள். அவர்கள் அவனுடைய கனவின் நிமித்தமும், அவன் சொன்னவற்றின் நிமித்தமும் அவனை மேலும் வெறுத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","யோசேப்பு இன்னுமொரு கனவு கண்டான், அதையும் அவன் தன் சகோதரரிடம் சொன்னான். “கேளுங்கள், நான் இன்னுமொரு கனவு கண்டேன்; இம்முறை சூரியனும், சந்திரனும், பதினோரு நட்சத்திரங்களும் என்னைக் குனிந்து வணங்கின” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","இதை அவன் தன் தகப்பனுக்கும், தனது சகோதரருக்கும் சொன்னான். அப்பொழுது அவனுடைய தகப்பன், “நீ என்ன கனவு கண்டிருக்கிறாய்? உன் தாயும் நானும் உன் சகோதரரும் உனக்கு முன்பாக தரையில் வீழ்ந்து உன்னை வணங்குவோம் என்று நினைக்கிறாயா?” என்று அவனைக் கடிந்துகொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","அவன் சகோதரர் அவன்மீது பொறாமை கொண்டார்கள், அவன் தகப்பனோ அவன் சொன்னதை மனதில் வைத்துக்கொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","யோசேப்பின் சகோதரர் தங்கள் தகப்பனின் மந்தையை மேய்ப்பதற்காகச் சீகேமுக்கு அருகே போயிருந்தார்கள்; ");
INSERT INTO tamtcv_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","அப்பொழுது இஸ்ரயேல் யோசேப்பிடம், “உன் சகோதரர் சீகேமுக்கு அருகே மந்தை மேய்த்துக் கொண்டிருப்பது உனக்குத் தெரியும்தானே, வா இப்பொழுது நான் உன்னை அவர்களிடத்திற்கு அனுப்பப்போகிறேன்” என்றான். அதற்கு அவன், “நல்லது, நான் போகிறேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","எனவே, அவன் யோசேப்பிடம், “நீ போய் உன் சகோதரர் நலமாயிருக்கிறார்களா என்றும், மந்தைகள் எப்படியிருக்கின்றன என்றும் பார்த்து எனக்கு வந்து சொல்” என்றான். அப்படியே யோசேப்பை எப்ரோன் பள்ளத்தாக்கிலிருந்து வழியனுப்பினான். யோசேப்பு சீகேமுக்கு வந்துபோது, ");
INSERT INTO tamtcv_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","அவன் வயல்வெளியில் அலைந்து கொண்டிருப்பதை ஒரு மனிதன் கண்டு, “நீ என்ன தேடுகிறாய்?” என்று அவனிடம் கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","அதற்கு யோசேப்பு, “நான் என் சகோதரரைத் தேடுகிறேன். அவர்கள் எங்கே மந்தை மேய்த்துக் கொண்டிருக்கிறார்கள் என்று உம்மால் சொல்லமுடியுமா?” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","அதற்கு அவன், “அவர்கள் இவ்விடத்திலிருந்து போய்விட்டார்கள், ‘தோத்தானுக்குப் போவோம்’ என்று அவர்கள் பேசிக்கொண்டதை நான் கேட்டேன்” என்றான். யோசேப்பு தன் சகோதரரைத் தேடிச்சென்று, தோத்தானுக்கு அருகே அவர்களைக் கண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","ஆனால் அவர்களோ, அவனைத் தூரத்திலேயே கண்டார்கள், அவன் அவர்கள் அருகே வருவதற்கு முன்பு அவர்கள் அவனைக் கொல்வதற்குச் சதித்திட்டம் போட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","அவர்கள், “இதோ, கனவுக்காரன் வருகிறான்!” என்று ஒருவருக்கொருவர் சொல்லிக்கொண்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","அவர்கள், “வாருங்கள், இப்பொழுது அவனைக் கொன்று, இங்குள்ள குழிகள் ஒன்றில் போட்டுவிடுவோம்; கொடிய மிருகம் அவனைத் தின்றுவிட்டது என்று சொல்வோம். அதன்பின் அவனுடைய கனவுகள் எப்படி நிறைவேறுமென்று பார்ப்போம்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","ரூபன் அதைக் கேட்டபோது, அவனை அவர்களுடைய கைகளிலிருந்து தப்புவிக்க முயற்சித்தான். அவன், “நாம் அவனைக் கொல்லாமல் விடுவோம். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","நீங்கள் இரத்தத்தைச் சிந்தாமல் காடுகளிலுள்ள இந்தக் கிணற்றில் அவனைப் போட்டுவிடுவோம், அவன்மேல் கைவைக்க வேண்டாம்” என்றான். யோசேப்பை அவர்களிடமிருந்து தப்புவித்துத் தன் தகப்பனிடத்திற்கு மறுபடியும் கூட்டிச்செல்லவே ரூபன் அவ்வாறு சொன்னான். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","யோசேப்பு தன் சகோதரரிடம் வந்தவுடனே அவர்கள் அவன் அணிந்திருந்த, சிறப்பாக அலங்கரிக்கப்பட்ட அங்கியை உரிந்து போட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","அவர்கள் அவனைத் தூக்கி, அங்கே இருந்த கிணற்றிலே போட்டார்கள். அப்பொழுது அந்தக் கிணறு தண்ணீர் இல்லாமல் வெறுமையாயிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","பின்பு அவர்கள் சாப்பிட உட்கார்ந்தார்கள், அவர்கள் நிமிர்ந்து பார்த்தபோது, இஸ்மயேலரின் வியாபாரிகளின் கூட்டமொன்று கீலேயாத்திலிருந்து வந்துகொண்டிருந்ததைக் கண்டார்கள். அவர்களுடைய ஒட்டகங்களிலே வாசனைப் பொருட்களும், தைல வகைகளும், வெள்ளைப்போளமும் ஏற்றப்பட்டிருந்தன. அவர்கள் அவற்றை எகிப்திற்குக் கொண்டுசெல்லும்படி பயணம் செய்துகொண்டிருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","அப்பொழுது யூதா தன் சகோதரரிடம், “நம்முடைய சகோதரனைக் கொன்று, அவனுடைய இரத்தத்தை மறைப்பதினால் நமக்கு என்ன லாபம்? ");
INSERT INTO tamtcv_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","வாருங்கள், அவன்மேல் நமது கையை வைக்காமல், அவனை இந்த இஸ்மயேலருக்கு விற்போம்; எப்படியும் அவன் நம்முடைய சகோதரனும், நமது சொந்த இரத்தமுமாய் இருக்கிறானே” என்றான். அதற்கு அவன் சகோதரர்கள் சம்மதித்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","மீதியான் நாட்டு இஸ்மயேல் வியாபாரிகள் அங்கே வந்தபோது, யோசேப்பின் சகோதரர், கிணற்றிலிருந்து அவனை வெளியே எடுத்து, இருபது சேக்கல் வெள்ளிக்கு இஸ்மயேலரிடம் அவனை விற்றார்கள், அவர்கள் யோசேப்பை எகிப்திற்குக் கொண்டுபோனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","ரூபன் அந்தக் கிணற்றுக்குத் திரும்பிப்போய், யோசேப்பு அங்கே இல்லை என்பதைக் கண்டு, அவன் தன் உடைகளைக் கிழித்துக்கொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","அவன் தன் சகோதரரிடம் திரும்பிப்போய், “யோசேப்பு அங்கே இல்லையே! நான் எங்கே போய் தேடுவேன்?” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","பின்பு அவர்கள் ஒரு வெள்ளாட்டை வெட்டி, அதன் இரத்தத்தில் யோசேப்பின் மேலுடையைத் தோய்த்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","அலங்கரிக்கப்பட்ட அந்த மேலுடையைத் தங்கள் தகப்பனிடம் கொண்டுபோய், “இந்த உடையை நாங்கள் வழியில் கண்டெடுத்தோம். இது உமது மகனுடையதா என்று பாரும்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","யாக்கோபு அதைக்கண்டு, “இது என் மகனுடைய மேலுடைதான்! ஏதோ ஒரு கொடிய மிருகம் அவனைக் கொன்று தின்றிருக்க வேண்டும், யோசேப்பு நிச்சயமாகத் துண்டுதுண்டாகக் கிழிக்கப்பட்டிருப்பான்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","யாக்கோபு தன் உடையைக் கிழித்து, துக்கவுடை உடுத்தி, தன் மகனுக்காகப் பல நாட்கள் துக்கமாயிருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","அவனுடைய மகன்கள், மகள்கள் எல்லோருமே அவனுக்கு ஆறுதல் சொல்ல வந்தார்கள். ஆனால் அவனோ ஆறுதலடைய மறுத்து, “இல்லை, நான் என் மகனிடத்தில் கல்லறையில் சேரும்வரை துக்கித்துக் கொண்டேயிருப்பேன்” என்றான். இவ்வாறாக அவனுடைய தகப்பன் அவனுக்காக அழுது புலம்பினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","இதற்கிடையில், மீதியானிய வியாபாரிகள் எகிப்திலே பார்வோனின் அலுவலர்களில் ஒருவனும், மெய்க்காவலர் தலைவனுமான போத்திபாருக்கு யோசேப்பை விற்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","அக்காலத்தில் யூதா தன் சகோதரரை விட்டுப் புறப்பட்டு, அதுல்லாம் ஊரைச்சேர்ந்த ஈரா என்பவனிடம் தங்கும்படி போனான். ");
INSERT INTO tamtcv_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","அங்கே யூதா கானானியனான சூவா என்பவனின் மகளைச் சந்தித்து, அவளைத் திருமணம் செய்து, அவளுடன் உறவுகொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","அவள் கர்ப்பந்தரித்து, ஒரு மகனைப் பெற்றாள். அவனுக்கு ஏர் என்று பெயரிடப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","மீண்டும் அவள் கர்ப்பந்தரித்து, இன்னும் ஒரு மகனைப் பெற்று, அவனுக்கு ஓனான் எனப் பெயரிட்டாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","பின்னும் அவள் கர்ப்பந்தரித்து, இன்னும் ஒரு மகனைப் பெற்று அவனுக்கு சேலா எனப் பெயரிட்டாள். அவள் அவனை கெசீப் என்னும் இடத்தில் பெற்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","யூதா, தன் மூத்த மகனான ஏர் என்பவனுக்குத் தாமார் என்ற பெண்ணைத் திருமணம் செய்துகொடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","ஆனால் யூதாவின் மூத்த மகன் ஏர் யெகோவாவின் பார்வையில் கொடியவனாய் இருந்தபடியால், யெகோவா அவனை அழித்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","அப்பொழுது யூதா ஓனானிடம், “உன் சகோதரனின் மனைவியுடன் கூடிவாழ்ந்து, உன் சகோதரனுக்குச் சந்ததி உண்டாகும்படி, ஒரு மைத்துனனுக்குரிய கடமையை அவளுக்கு நிறைவேற்று” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ஆனால் ஓனானுக்கோ தன் மூலம் தாமாருக்குப் பிறக்கும் பிள்ளைகள் தன் சந்ததியாய் இராது என்பது தெரியும்; எனவே அவன் அவளுடன் உறவுகொள்ளும்போதெல்லாம், தன் சகோதரனுக்குப் பிள்ளைகள் உண்டாகாதபடி, தன் விந்தைத் தரையிலே சிந்தப்பண்ணினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","இந்த செயல் யெகோவாவின் பார்வையிலே கொடியதாய் இருந்தபடியால், அவனையும் அவர் அழித்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","அப்பொழுது யூதா, தன் மருமகள் தாமாரிடம், “என் மகன் சேலா பெரியவனாகுமட்டும், நீ ஒரு விதவையாக உன் தகப்பன் வீட்டிற்குப்போய்க் குடியிரு” என்றான். “தன் மகன் சேலாவும் அவனுடைய சகோதரர்போல் இறந்துபோவான்” என்று எண்ணியே அப்படிச் சொன்னான். எனவே தாமார் தன் தகப்பன் வீட்டில் குடியிருக்கும்படி போனாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","அநேக நாட்களுக்குப்பின் சூவாவின் மகளான யூதாவின் மனைவி இறந்துபோனாள். யூதா அவளுக்காகத் துக்கம் அனுசரித்து முடித்தபின், திம்னாவில் தன்னுடைய செம்மறியாடுகளுக்கு மயிர் கத்தரிக்கும் மனிதரிடம் போனான், அதுல்லாமியனாகிய அவனுடைய சிநேகிதன் ஈராவும் அவனுடன் போனான். ");
INSERT INTO tamtcv_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","“தன் செம்மறியாடுகளுக்கு மயிர் கத்தரிப்பதற்காக உன் மாமனார் திம்னாவுக்குப் போகிறார்” என தாமாருக்கு அறிவிக்கப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","சேலா பெரியவனாகியும், தான் அவனுக்கு மனைவியாகக் கொடுக்கப்படவில்லை என்பதை அவள் அறிந்தாள். எனவே அவள் விதவைக்குரிய தன் உடைகளைக் களைந்து, தன்னை மறைப்பதற்காக முகத்திரையினால் தன்னை மூடிக்கொண்டு, திம்னாவுக்குப் போகிற வழியில் உள்ள ஏனாயீம் ஊர்வாசலிலே உட்கார்ந்திருந்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","யூதா அவளைக் கண்டபோது, அவள் ஒரு வேசி என எண்ணினான்; ஏனெனில் அவள் தன் முகத்தை மூடியிருந்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","அவளைத் தன் மருமகள் என அறியாத யூதா வீதியோரமாய் இருந்த அவளிடம் போய், “நீ என்னுடன் உறவுகொள்ள வா” என்றான். அதற்கு அவள், “நான் உம்முடன் வந்தால் நீர் எனக்கு என்ன தருவீர்?” என்று கேட்டாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","அதற்கு அவன், “என் மந்தையிலிருந்து ஒரு வெள்ளாட்டுக்குட்டியை அனுப்புவேன்” என்றான். அவளோ, “அதை அனுப்பும்வரை ஏதாவதொரு பொருளை அடைமானமாகத் தருவீரா?” என்று கேட்டாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","அதற்கு யூதா, “உனக்கு அடைமானமாக நான் என்ன தரவேண்டும்?” என்று கேட்டான். அதற்குத் தாமார், “உம்முடைய முத்திரை மோதிரத்தையும், அதன் கயிற்றையும், உமது கையிலிருக்கும் கோலையும் தாரும்” என்றாள். அவன் அவற்றைக் கொடுத்து, அவளுடன் உறவுகொண்டான்; அவனால் அவள் கர்ப்பவதியானாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","அவள் அவ்விடத்தை விட்டுப்போய், தன் முகத்திரையைக் கழற்றிவிட்டு, மறுபடியும் தனது விதவைக்குரிய உடைகளை உடுத்திக்கொண்டாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","அதேவேளை யூதா அதுல்லாம் ஊரானாகிய தன் சிநேகிதனிடம் ஒரு வெள்ளாட்டுக்குட்டியைக் கொடுத்து, தான் அப்பெண்ணிடம் அடைமானமாகக் கொடுத்திருந்த பொருட்களை வாங்கிவரும்படி அனுப்பினான்; ஆனால் அவனால் அவளைக் கண்டுபிடிக்க முடியவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","அவன் அங்குள்ள மனிதரிடம், “ஏனாயீம் வழியருகே இருந்த கோயில் வேசி எங்கே?” என்று கேட்டான். அதற்கு அவர்கள், “அப்படியொரு கோயில் வேசி இங்கே இல்லை” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","ஆகவே, அவன் யூதாவிடம், “திரும்பிப்போய், நான் அவளைக் காணவில்லை; அதுவுமல்லாமல் அங்குள்ள மனிதரும், ‘அப்படியொரு கோயில் வேசி அங்கிருக்கவில்லை’ என்று சொன்னார்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","யூதா அவனிடம், “அவளிடம் இருப்பதை அவளே வைத்துக்கொள்ளட்டும்; திரும்பிப் போனால் நாம் கேலிப் பொருளாவோம். எப்படியும் நான் இந்த ஆட்டுக்குட்டியை அவளிடம் அனுப்பினேன், ஆனால் நீயோ அவளைக் காண முடியவில்லை” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ஏறக்குறைய மூன்று மாதம் சென்றபின், “உமது மருமகள் தாமார், வேசித்தனம் செய்து, அதன் பலனாகக் கருவுற்றிருக்கிறாள்” என யூதாவுக்கு அறிவிக்கப்பட்டது. அதற்கு யூதா, “அவளை வெளியே கொண்டுவந்து எரித்துக் கொல்லுங்கள்!” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","அவள் வெளியே கொண்டுவரப்படும்போது, தன் மாமனுக்கு ஒரு செய்தியை அனுப்பினாள். அதாவது: “இந்தப் பொருளுக்குரியவராலேயே நான் கருவுற்றிருக்கிறேன். இந்த முத்திரை மோதிரமும், இடைவாரும், கைக்கோலும் யாருடையது என்று உம்மால் சொல்லமுடியுமா பாரும்” என்று கேட்கும்படி அனுப்பினாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","யூதா அவற்றை அடையாளம் கண்டு, “என் மகன் சேலாவை நான் அவளுக்குக் கொடுக்க மறுத்தபடியால், அவள் என்னைவிட நீதியானவளே” என்றான். அதன்பின் யூதா அவளுடன் உறவுகொள்ளவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","அவளுக்குப் பேறுகாலம் வந்தபோது, அவளது கர்ப்பத்தில் இரட்டைக் குழந்தைகள் இருப்பதாகத் தெரிந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","அவள் பிள்ளை பெறுகிறபோது ஒரு குழந்தை தன் கையை வெளியே நீட்டியது. உடனே மகப்பேற்றுத் மருத்துவச்சி கருஞ்சிவப்பு நூலை எடுத்து, அதன் கையில் கட்டி, “இதுவே முதலில் வெளிப்பட்டது” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","ஆனால், அக்குழந்தை மறுபடியும் கையை உள்ளே இழுத்துக் கொண்டபோது, அவனுடைய சகோதரன் வெளியே வந்தான். அப்பொழுது மகப்பேற்றுத் தாதி, “நீ, மீறி முதலாவதாக வெளியே வந்ததென்ன?” என்றாள். அவனுக்கு பாரேஸ் எனப் பெயரிடப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","அதன்பின் கையில் நூல் கட்டப்பட்ட அவன் சகோதரன் வெளியே வந்தான். அவனுக்குச் சேரா எனப் பெயரிடப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","யோசேப்பு எகிப்திற்குக் கொண்டுபோகப்பட்டிருந்தான். பார்வோனுடைய அதிகாரிகளில் ஒருவனும், காவல் அதிகாரியுமாகிய போத்திபார் என்னும் எகிப்தியன், யோசேப்பைக் கொண்டுசென்ற இஸ்மயேலரிடம் அவனை விலைக்கு வாங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","யெகோவா யோசேப்புடன் இருந்தார், அதனால் அவன் செய்த எல்லாவற்றிலும் வெற்றிபெற்றான்; அவன் எகிப்திய எஜமானுடைய வீட்டில் தங்கியிருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","யெகோவா அவனோடு இருக்கிறார் என்றும், அவன் செய்யும் எல்லாவற்றிலும் யெகோவா அவனுக்கு வெற்றியைக் கொடுக்கிறார் என்றும் அவன் எஜமான் கண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","அப்போது யோசேப்புக்கு அவனுடைய எஜமானின் கண்களில் தயவு கிடைத்தால், அவன் அவனுடைய எஜமானின் தனிப்பட்ட உதவியாளன் ஆனான். போத்திபார் அவனைத் தன் வீட்டுக்குப் பொறுப்பாக வைத்து, தனக்குச் சொந்தமான எல்லாவற்றையும் அவன் பொறுப்பில் கொடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","இவ்வாறாக அவனுடைய வீட்டுக்கும், அவனுக்குச் சொந்தமான எல்லாவற்றிற்கும் பொறுப்பாக யோசேப்பை அவன் நியமித்ததுமுதல், யோசேப்பின் நிமித்தம் அந்த எகிப்தியனின் வீட்டை யெகோவா ஆசீர்வதித்தார். போத்திபாருக்கு அவனுடைய வீட்டிலும், வயல்வெளியிலும் உள்ள எல்லாவற்றிலும் யெகோவாவினுடைய ஆசீர்வாதம் இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","அதனால் அவன் தனக்குள்ள எல்லாவற்றையும் யோசேப்பிடம் ஒப்படைத்து, அவனை அதிகாரியாக நியமித்தான். போத்திபாரோ தான் உண்ணும் உணவைத் தவிர வேறெதிலும் கவனம் செலுத்தவில்லை. யோசேப்பு நல்ல உடற்கட்டும் அழகிய தோற்றமும் உடையவனாய் இருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","சிலநாள் சென்றபின் போத்திபாரின் மனைவி யோசேப்பின்மீது ஆசைகொண்டு, “என்னுடன் உறவுகொள்ள வா!” என அழைத்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","அவனோ அதை மறுத்தான். அவன் அவளிடம், “என் எஜமான் தன் வீட்டிலுள்ள எதைக் குறித்தும் கவனிப்பதில்லை; தனக்குச் சொந்தமாயுள்ள அனைத்தையும் என்னுடைய பராமரிப்பில் ஒப்புவித்துள்ளார். ");
INSERT INTO tamtcv_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","இந்த வீட்டில் என்னைவிடப் பெரியவன் ஒருவனும் இல்லை. நீ அவருடைய மனைவி என்பதால் உன்னைத்தவிர, வேறொன்றையும் அவர் என்னிடமிருந்து விலக்கி வைக்கவில்லை. அப்படியிருக்க, இவ்வாறான கொடுமையான செயலைச் செய்து, இறைவனுக்கு விரோதமாகப் பாவஞ்செய்ய என்னால் எப்படி முடியும்?” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","அவள் நாளுக்குநாள் யோசேப்பைக் கட்டாயப்படுத்திய போதிலும், அவளோடு படுக்கைக்குச் செல்லவோ, அவளோடு இருக்கவோ அவன் உடன்படவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ஒரு நாள் யோசேப்பு தன் கடமைகளைச் செய்வதற்காக வீட்டுக்குள் போனான், வீட்டு வேலைக்காரர் யாரும் உள்ளே இருக்கவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","அப்பொழுது அவள் யோசேப்பின் மேலுடையைப் பிடித்துக்கொண்டு, “என்னுடன் படுக்கைக்கு வா” என்றாள். அவனோ தன் மேலுடையை அவள் கையிலேயே விட்டு, வீட்டுக்கு வெளியே ஓடிவிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","அவன் தன்னுடைய மேலுடையைத் தன் கையிலே விட்டுவிட்டு, வீட்டுக்கு வெளியே ஓடிப்போனதை அவள் கண்டபோது, ");
INSERT INTO tamtcv_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","தன் வீட்டு வேலைக்காரரைக் கூப்பிட்டு, “இதோ பாருங்கள், இந்த எபிரெயன் நம்மை அவமானப்படுத்தும்படி இங்கு கொண்டுவரப்பட்டிருக்கிறான்! அவன் என்னுடன் உறவுகொள்ளும்படி உள்ளே வந்தான். நான் கூச்சலிட்டேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","நான் உதவிகேட்டுக் கூச்சலிட்டதை அவன் கேட்டவுடன், தன் மேலுடையை இங்கே விட்டுவிட்டு வெளியே ஓடிவிட்டான்” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","அவள் அவனுடைய எஜமான் வீட்டுக்கு வரும்வரை அந்த மேலுடையை தன்னருகிலேயே வைத்திருந்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","அவன் வந்ததும் அவனிடம் இந்தக் கதையைச் சொன்னாள்: “நீர் நம்மிடம் கொண்டுவந்த அந்த எபிரெய அடிமை என்னை அவமானப்படுத்தும்படி இங்கு வந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","நான் உதவிக்காகக் கூச்சலிட, உடனே அவன் தன் மேலுடையை என் அருகே விட்டுவிட்டு, வீட்டுக்கு வெளியே ஓடிவிட்டான்” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","“இப்படித்தான் உம்முடைய அடிமை என்னை நடத்தினான்” என்று தன் மனைவி தனக்குச் சொன்ன வார்த்தைகளை அவனுடைய எஜமான் கேட்டதும், அவனுடைய கோபம் பற்றி எரிந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","யோசேப்பின் எஜமான் அவனைக் கைதுசெய்து, அரச கைதிகளை அடைத்துவைக்கும் சிறையில் போட்டான். யோசேப்பு சிறையில் இருக்கும்போதும், ");
INSERT INTO tamtcv_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","யெகோவா யோசேப்போடே இருந்தார்; அவர் அவனுக்கு இரக்கங்காட்டி, சிறைச்சாலைத் தலைவனின் கண்களில் அவனுக்குத் தயவு கிடைக்கச்செய்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","அதனால் சிறைக்காவல் அதிகாரி யோசேப்பைச் சிறையில் அடைக்கப்பட்டிருந்த எல்லோருக்கும் அதிகாரியாக்கினான்; அங்கு செய்யப்படவேண்டிய எல்லாவற்றுக்கும் அவனையே பொறுப்பாகவும் வைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","யெகோவா யோசேப்போடு இருந்து, அவன் செய்த அனைத்திலும் வெற்றியைக் கொடுத்தார்; அதனால் சிறைச்சாலைத் தலைவன் யோசேப்பின் பொறுப்பிலிருந்த எதையும் மேற்பார்வை செய்யவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","சிலகாலம் சென்றபின், எகிப்திய அரசனுக்கு பானம் பரிமாறுகிறவனும், அப்பம் சுடுகிறவனுமான இருவரும் எகிப்தின் அரசனான தங்கள் எஜமானுக்கு எதிராகக் குற்றம் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ஆதலால் பார்வோன், பானம் பரிமாறுவோருக்குத் தலைவனும் அப்பம் சுடுவோருக்குத் தலைவனுமாயிருந்த அந்த இரு அலுவலர்கள் மேலும் கோபமடைந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","எனவே யோசேப்பு அடைக்கப்பட்டிருந்த காவலர் தலைவன் வீட்டிலுள்ள சிறையிலேயே பார்வோன் அவர்களையும் அடைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","காவலர் தலைவன் அவர்களை யோசேப்பிடம் ஒப்படைக்க, அவன் அவர்களைப் பொறுப்பேற்றான். அவர்கள் அங்கே சிலகாலம் இருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","எகிப்திய அரசனுக்குப் பானம் பரிமாறுவோரின் தலைவனும், அப்பம் சுடுவோரின் தலைவனும் சிறையிலிருக்கும் போது, ஒரே இரவில் இருவரும் கனவு கண்டார்கள்; ஒவ்வொரு கனவும் வெவ்வேறு கருத்துடையனவாய் இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","மறுநாள் காலை யோசேப்பு அவர்களிடம் வந்தபோது, அவர்கள் கலங்கியிருப்பதைக் கண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","அவன் தன் தலைவனது வீட்டிலே, தன்னோடு காவலில் வைக்கப்பட்டிருந்த பார்வோனின் அலுவலர்களிடம், “உங்கள் முகம் இன்று ஏன் வாடியிருக்கிறது?” எனக் கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","அதற்கு அவர்கள், “நாங்கள் இருவரும் கனவு கண்டோம்; அவற்றுக்கு விளக்கம் தர ஒருவருமில்லை” என்றார்கள். அதற்கு யோசேப்பு, “விளக்கங்கள் இறைவனுக்குரியதல்லவா? உங்கள் கனவுகளை என்னிடம் சொல்லுங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","பானம் பரிமாறுவோருக்குப் பொறுப்பாயிருந்தவன் தன் கனவை யோசேப்புக்குச் சொன்னான். “என் கனவில் எனக்கு முன்பாக ஒரு திராட்சைக்கொடி இருப்பதைக் கண்டேன்; ");
INSERT INTO tamtcv_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","அக்கொடியில் மூன்று கிளைகள் இருந்தன. அவை துளிர்த்த உடனே பூ பூத்து, அதன் குலைகள் பழுத்துத் திராட்சைப் பழங்களாயின. ");
INSERT INTO tamtcv_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","பார்வோனுடைய பாத்திரம் என் கையில் இருந்தது, நான் திராட்சைப் பழங்களை எடுத்து, அவற்றை அப்பாத்திரத்தில் பிழிந்து, பார்வோனின் கையிலே கொடுத்தேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","அப்பொழுது யோசேப்பு, “கனவின் விளக்கம் இதுவே: மூன்று கிளைகளும் மூன்று நாட்களாகும். ");
INSERT INTO tamtcv_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","பார்வோன் மூன்று நாட்களுக்குள் உன்னை விடுவித்து, உன்னை உன் பழைய பதவியில் அமர்த்துவான்; நீ பானம் பரிமாறுகிறவனாய் இருந்தபோது செய்தவாறே, பார்வோனின் பாத்திரத்தை அவன் கையில் கொடுப்பாய்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","மேலும் அவன், “மீண்டும் நீ நல்ல நிலையில் இருக்கும்போது, என்னை நினைவில் வைத்து, எனக்குத் தயவுகாட்டு; பார்வோனிடம் என்னைப்பற்றிச் சொல்லி, இந்த சிறையிலிருந்து என்னை விடுதலையாக்கு. ");
INSERT INTO tamtcv_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ஏனெனில், நான் எபிரெயருடைய நாட்டிலிருந்து பலவந்தமாய் இங்கு கொண்டுவரப்பட்டேன், இங்கேயும் இந்தக் காவல் கிடங்கில் வைக்கப்படுவதற்கு ஏதுவான குற்றம் எதையும் நான் செய்யவில்லை” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","யோசேப்பு அவனுக்கு நல்ல விளக்கம் சொன்னதைக் கேட்ட, அப்பம் சுடுவோரின் பொறுப்பாளன் யோசேப்பிடம், “நானும் ஒரு கனவு கண்டேன்: என் தலையில் அப்பமுள்ள மூன்று கூடைகள் இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","மேலேயிருந்த கூடையில் பார்வோனுக்காகத் தயாரிக்கப்பட்ட பல வகையான உணவுகள் இருந்தன, ஆனால் பறவைகள் என் தலையின் மேலிருந்த கூடையிலிருந்து அப்பங்களைத் தின்றன” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","அதற்கு யோசேப்பு, “உன் கனவுக்குரிய விளக்கம் இதுவே: மூன்று கூடைகளும் மூன்று நாட்களாகும். ");
INSERT INTO tamtcv_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","இன்னும் மூன்று நாட்களில் பார்வோன் உன் தலையை வெட்டி, உன்னை மரத்திலே தூக்கிலிடுவான். பறவைகள் உன் சதையைக் கொத்தித் தின்னும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","மூன்றாம் நாள் வந்தது, அது பார்வோனின் பிறந்தநாளாய் இருந்தபடியால், அவன் தன் அதிகாரிகளுக்கெல்லாம் ஒரு விருந்து கொடுத்தான். அப்பொழுது அவன், பானம் பரிமாறுவோரின் பொறுப்பாளனையும், அப்பம் சுடுபவர்களின் பொறுப்பாளனையும் வெளியே கொண்டுவந்து, தான் விருந்துக்கு அழைத்திருந்த அதிகாரிகளின்முன் நிறுத்தினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","பானம் பரிமாறுவோரின் பொறுப்பாளனை மீண்டும் அவனுடைய பதவியில் அமர்த்தினான்; அவன் முன்போலவே பார்வோனுக்குப் பானம் பரிமாறினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ஆனால் யோசேப்பு அவர்களுக்குச் சொன்ன விளக்கத்தின்படியே, அப்பம் சுடுபவர்களின் பொறுப்பாளனை அவன் தூக்கிலிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","ஆனாலும், பானம் பரிமாறுவோரின் பொறுப்பாளன் யோசேப்பை நினைவில்கொள்ளவில்லை; அவனை மறந்துபோனான். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","இரண்டு முழு வருடங்கள் சென்றபின் பார்வோன் ஒரு கனவு கண்டான். அக்கனவில் அவன், நைல் நதி அருகே நின்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","அப்பொழுது கொழுத்ததும், செழிப்பானதுமான ஏழு பசுக்கள் நதியிலிருந்து வெளியேறி, நாணல்களுக்கிடையில் மேய்ந்து கொண்டிருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","அவற்றின் பிறகே அவலட்சணமும், மெலிந்ததுமான ஏழு பசுக்கள் நைல் நதியிலிருந்து வெளியேறி வந்து, நதிக்கரையில் மற்ற பசுக்களின் அருகில் நின்றன. ");
INSERT INTO tamtcv_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","அதன்பின் அவலட்சணமும் மெலிந்ததுமான ஏழு பசுக்களும், கொழுத்ததும் செழிப்பானதுமான ஏழு பசுக்களையும் தின்றுவிட்டன. அப்பொழுது பார்வோன் நித்திரையிலிருந்து விழித்துக்கொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","மீண்டும் அவன் நித்திரை செய்தபோது, இன்னுமொரு கனவு கண்டான். அக்கனவில் நன்கு விளைந்து முற்றிய ஏழு நெற்கதிர்கள் ஒரே தாளிலிருந்து வளர்ந்து வந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","பின்பு மெல்லியதும், கீழ்க்காற்றினால் கருகிப்போனதுமான ஏழு நெற்கதிர்கள் முளைத்து வந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","அந்த ஏழு மெலிந்த நெற்கதிர்களும், நன்கு விளைந்து முற்றிய ஏழு நெற்கதிர்களையும் விழுங்கிவிட்டன. பார்வோன் நித்திரையிலிருந்து விழித்தெழுந்தபோது, அது கனவு என அறிந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","காலையில் பார்வோனுடைய மனம் குழப்பமடைந்தது, அதனால் அவன் எகிப்திலுள்ள மந்திரவாதிகள், ஞானிகள் எல்லோரையும் வரவழைத்து, தான் கண்ட கனவுகளை அவர்களுக்குச் சொன்னான். ஆனால், அவர்கள் ஒருவராலும் அக்கனவுகளுக்கு விளக்கங்கூற முடியவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","அப்பொழுது பானம் பரிமாறுவோரின் பொறுப்பாளன் பார்வோனிடம், “நான் செய்த தவறொன்று இன்றுதான் எனக்கு நினைவு வருகிறது. ");
INSERT INTO tamtcv_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","பார்வோன் ஒருமுறை தமது பணியாட்களில் கோபங்கொண்டு, என்னையும் அப்பம் சுடுவோரின் பொறுப்பாளனையும் காவல் அதிகாரியின் வீடாகிய சிறையில் வைத்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","நாங்கள் இருவரும் ஒரே இரவில் கனவு கண்டோம், அவை ஒவ்வொன்றும் வெவ்வேறு விளக்கமுடையதாய் இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","அங்கே காவலர் அதிகாரிக்குப் பணியாளனாயிருந்த, எபிரெய இளைஞன் ஒருவனும் எங்களோடிருந்தான். நாங்கள் அவனிடம் எங்கள் கனவுகளைச் சொன்னோம், அவன் எங்கள் ஒவ்வொருவருடைய கனவின் அர்த்தத்தைச் சொல்லி, அவற்றை எங்களுக்கு விளக்கிக் கூறினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","அவன் எங்களுக்குச் சொன்னவாறே எல்லாம் நிறைவேறின: நான் மறுபடியும் எனது பதவியில் நியமிக்கப்பட்டேன், மற்றவனோ தூக்கிலிடப்பட்டான்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","எனவே பார்வோன் யோசேப்பை அழைத்துவரச் செய்தான், அவன் காவல் கிடங்கிலிருந்து உடனே கொண்டுவரப்பட்டான். அவன் சவரம்செய்து, உடைமாற்றி பார்வோன் முன்வந்து நின்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","பார்வோன் யோசேப்பிடம், “நான் ஒரு கனவு கண்டேன், அதற்குரிய விளக்கத்தை யாராலும் சொல்ல முடியவில்லை. யாராவது உனக்கு ஒரு கனவைச் சொன்னால், நீ அதற்கு விளக்கம் கூறுவாய் என நான் கேள்விப்பட்டேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","அதற்கு யோசேப்பு பார்வோனிடம், “என்னால் அதைச் செய்யமுடியாது, ஆனால் பார்வோன் விரும்பும் பதிலை இறைவன் அவருக்குத் தருவார்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","பார்வோன் யோசேப்பிடம், “என் கனவில் நான் நைல் நதிக்கரையில் நின்று கொண்டிருந்தேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","அப்பொழுது கொழுத்ததும் செழிப்புமான ஏழு பசுக்கள் நதியிலிருந்து வெளியேறி, நாணல்களுக்கு இடையே மேய்ந்து கொண்டிருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","அவற்றின்பின் எலும்பும் தோலுமான, மெலிந்த அவலட்சணமான வேறு ஏழு பசுக்கள் நதியிலிருந்து வெளியேறின. இதைப்போன்ற அவலட்சணமான பசுக்களை எகிப்து நாடெங்கும் நான் ஒருபோதும் கண்டதில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","அந்த மெலிந்த அவலட்சணமுள்ள ஏழு பசுக்களும், முதலில் வெளியேறிய ஏழு கொழுத்த பசுக்களையும் தின்றுவிட்டன. ");
INSERT INTO tamtcv_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","அவற்றைத் தின்ற பின்பும், அவை அவற்றைத் தின்றன என யாராலும் சொல்ல முடியாதிருந்தது; அவை முன்புபோலவே அவலட்சணமாய் இருந்தன. அதன்பின் நான் விழித்துக்கொண்டேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“மேலும், நான் இன்னும் ஒரு கனவைக் கண்டேன். அதில், நன்கு விளைந்து முற்றிய ஏழு நெற்கதிர்கள், ஒரே தாளில் ஓங்கி வளர்ந்ததைக் கண்டேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","அதன்பின் வாடிய, மெலிந்த, கீழ்க்காற்றினால் கருகிப்போன வேறு ஏழு கதிர்கள் முளைத்து வந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","இந்த மெலிந்த ஏழு நெற்கதிர்களும், மற்ற ஏழு விளைந்த கதிர்களையும் விழுங்கிவிட்டன. நான் இந்தக் கனவுகளை மந்திரவாதிகளிடம் சொன்னேன். ஆனால் அவற்றின் விளக்கத்தை ஒருவனாலும் சொல்ல முடியவில்லை” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","அப்பொழுது யோசேப்பு, “பார்வோனின் இரு கனவுகளுமே ஒன்றுதான். இறைவன் செய்யப்போவதைப் பார்வோனுக்கு வெளிப்படுத்தியிருக்கிறார். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","நல்ல ஏழு பசுக்களும் ஏழு வருடங்கள், நல்ல ஏழு கதிர்களும் ஏழு வருடங்கள்; இவை இரண்டும் ஒரே கனவுதான். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","அவற்றின்பின் வந்த மெலிந்த அவலட்சணமுள்ள ஏழு பசுக்களும், அப்படியே கீழ்க்காற்றினால் கருகிப்போன பயனற்ற ஏழு கதிர்களும் பஞ்சமுள்ள ஏழு வருடங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“பார்வோனுக்கு நான் சொன்னதுபோல், இறைவன் தாம் செய்யப்போவதைப் பார்வோனுக்குக் காண்பித்திருக்கிறார். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","எகிப்து நாடெங்கும் நிறைவான விளைச்சலுள்ள ஏழு வருடங்கள் வரப்போகின்றன. ");
INSERT INTO tamtcv_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ஆனால் அதைத் தொடர்ந்து பஞ்சம் நிறைந்த ஏழு வருடங்கள் வரும். அப்பொழுது எகிப்தின் நிறைவான விளைச்சல் மறக்கப்படும், பஞ்சம் எகிப்து நாடு முழுவதையும் பாழாக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","நாட்டின் நிறைவான விளைச்சலுக்குப் பின் வரப்போகும் பஞ்சம் மிகவும் கொடியதாகையால், அந்த நிறைவான காலம் நினைக்கப்படமாட்டாது. ");
INSERT INTO tamtcv_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","இது இறைவனால் உறுதியாகத் தீர்மானிக்கப்பட்டபடியாலும், இதை இறைவன் விரைவில் நிறைவேற்றுவார் என்பதாலுமே, இறைவன் இவற்றைப் பார்வோனுக்கு இரண்டு விதத்தில் கனவுகளால் வெளிப்படுத்தியுள்ளார். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“ஆதலால் பார்வோன் விவேகமும், ஞானமுமுள்ள ஒரு மனிதனைத் தேடி, எகிப்து நாட்டுக்கு அவனைப் பொறுப்பாக நியமிப்பாராக. ");
INSERT INTO tamtcv_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","பார்வோன் ஏழு வருட நிறைவான விளைச்சல் காலங்களில் எகிப்தின் அறுவடையில் ஐந்தில் ஒரு பங்கைச் சேகரித்து வைப்பதற்காக, நிலத்தின் மேற்பார்வையாளர்களையும் நியமிப்பாராக. ");
INSERT INTO tamtcv_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","அவர்கள் வரப்போகிற வளமான வருடங்களில் விளையும் தானியங்கள் எல்லாவற்றையும் சேகரித்து, பார்வோனின் அதிகாரத்தின்கீழ் அந்த தானியங்களை பட்டணங்களில் உணவுக்காக அதைப் பாதுகாக்க வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","எகிப்து பஞ்சத்தினால் அழிந்துபோகாதபடி, அதன்மேல் வரப்போகும் ஏழு வருட பஞ்சகாலத்தில் பயன்படுத்துவதற்காக, அந்த தானியம் ஒதுக்கி வைக்கப்பட வேண்டும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","அந்த திட்டம் பார்வோனுக்கும் அவனுடைய அலுவலர்களுக்கும் நலமாய்க் காணப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","பார்வோன் தம்முடைய அலுவலர்களிடம், “இறைவனின் ஆவியையுடைய இந்த மனிதனைப்போல் ஒருவனை நாம் காணக்கூடுமோ?” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","பின்பு பார்வோன் யோசேப்பிடம், “இவை எல்லாவற்றையும் இறைவன் உனக்கு தெரிவித்திருப்பதால், உன்னைப்போல் விவேகமும் ஞானமும் உள்ளவன் வேறொருவனும் இல்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","எனவே, நான் உன்னை என் அரண்மனைக்கு அதிகாரி ஆக்குகிறேன்; என் மக்கள் யாவரும் உன் கட்டளைக்குக் கீழ்ப்படிந்து நடப்பார்கள். என் அரியணையில் மட்டுமே நான் உன்னிலும் பெரியவனாயிருப்பேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","மேலும் பார்வோன் யோசேப்பிடம், “உன்னை எகிப்து நாடு முழுவதற்கும் பொறுப்பதிகாரியாக நியமிக்கிறேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","பின்பு பார்வோன் தன் விரலில் அணிந்திருந்த தன் முத்திரை மோதிரத்தைக் கழற்றி, யோசேப்பின் விரலில் போட்டான். அவன் சிறந்த மென்பட்டு அங்கியை அவனுக்கு உடுத்தி, கழுத்தில் ஒரு தங்கச்சங்கிலியையும் அணிவித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","அதிகாரத்தில் தனக்கு அடுத்தவனாக அவனை தேரில் ஏற்றி பவனி வரச்செய்தான். அவனுக்கு முன்சென்ற மனிதர், “மண்டியிட்டுப் பணியுங்கள்!” என்று சத்தமிட்டார்கள். இவ்வாறு பார்வோன் அவனை எகிப்து நாடு முழுவதற்கும் அதிகாரியாக நியமித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","மேலும் பார்வோன் யோசேப்பிடம், “நான் பார்வோன்; ஆனாலும் எகிப்திலுள்ள யாரும் உனது உத்தரவின்றி கையையோ, காலையோ உயர்த்தக் கூடாது” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","பார்வோன் யோசேப்பின் பெயரை சாப்நாத்பன்னேயா என மாற்றி, போத்திபிரா என்னும் ஓன் பட்டண ஆசாரியனின் மகள் ஆஸ்நாத்தை அவனுக்கு மனைவியாகக் கொடுத்தான். பின்பு யோசேப்பு எகிப்து நாடு முழுவதையும் சுற்றிப்பார்க்கச் சென்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","யோசேப்பு எகிப்தின் அரசனாகிய பார்வோனுக்கு பணிபுரியத் தொடங்கியபோது, அவன் முப்பது வயதுடையவனாய் இருந்தான். யோசேப்பு பார்வோன் முன்னிலையில் இருந்து புறப்பட்டுப்போய், எகிப்து முழுவதையும் சுற்றிப் பயணம் செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","அப்படியே செழிப்பான ஏழு வருடங்களில் நாடு மிகுதியான விளைச்சலைக் கொடுத்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","செழிப்பான அந்த ஏழு வருடங்களில் எகிப்தில் விளைந்த தானியங்களை, யோசேப்பு பட்டணங்களில் சேகரித்து வைத்தான். ஒவ்வொரு பட்டணத்திலும் அதன் சுற்றுப்புறங்களிலுள்ள வயல்களில் விளைந்த தானியங்களைச் சேர்த்துவைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","யோசேப்பு தானியத்தைக் கடலின் மணலைப்போல் பெருமளவாகச் சேர்த்துவைத்தான். அது கணக்கிட முடியாதபடி மிக அதிகமாக இருந்தபடியால், பின்பு அவன் பதிவுசெய்வதை நிறுத்திவிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","பஞ்சமுள்ள வருடங்கள் தொடங்குவதற்கு முன்பே யோசேப்புக்கும் ஓன் பட்டணத்தின் ஆசாரியனாகிய போத்திபிராவின் மகள் ஆஸ்நாத்துக்கும் இரண்டு மகன்கள் பிறந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","அப்பொழுது யோசேப்பு, “இறைவன் என் தொல்லைகளையும், என் தகப்பன் வீட்டையும் மறக்கச்செய்தார்” என்று சொல்லி, தன் மூத்த மகனுக்கு மனாசே எனப் பெயரிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","“நான் துன்பப்பட்ட நாட்டிலே இறைவன் என்னைச் செழிக்கப்பண்ணினார் என்று சொல்லி, தன் இரண்டாவது மகனுக்கு எப்பிராயீம் எனப் பெயரிட்டான்.” ");
INSERT INTO tamtcv_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","எகிப்தின் செழிப்பான வளம் நிறைந்த ஏழு வருடங்களும் முடிவுற்றன. ");
INSERT INTO tamtcv_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","அதன்பின் யோசேப்பு சொல்லியிருந்தது போலவே, பஞ்சம் நிறைந்த ஏழு வருடங்கள் ஆரம்பமாகின. மற்ற எல்லா நாடுகளிலும் பஞ்சம் உண்டானது, ஆனால் எகிப்து முழுவதிலும் உணவு இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","எகிப்தியர் எல்லோரும் பஞ்சத்தை அனுபவிக்கத் தொடங்கியபோது, பார்வோனிடம் உணவு கேட்டு அழுதார்கள். பார்வோன் எல்லா எகிப்தியரிடமும், “நீங்கள் யோசேப்பிடம் போய், அவன் சொல்லுகிறபடி செய்யுங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","எகிப்து முழுவதிலும் பஞ்சம் பரவியபோது, யோசேப்பு எல்லா களஞ்சியங்களையும் திறந்து, தானியத்தை எகிப்தியருக்கு விற்றான். ஏனெனில், பஞ்சம் எகிப்து முழுவதும் கொடியதாயிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","உலகெங்கும் பஞ்சம் கொடியதாய் இருந்தபடியால், எல்லா நாட்டினரும் யோசேப்பிடம் தானியம் வாங்குவதற்காக எகிப்திற்கு வந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","எகிப்திலே தானியம் இருக்கிறதாக யாக்கோபு அறிந்தான். அவன் தன் மகன்களிடம், “நீங்கள் ஒருவரை ஒருவர் பார்த்துக்கொண்டு ஏன் சும்மா இருக்கிறீர்கள்? ");
INSERT INTO tamtcv_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","எகிப்திலே தானியம் இருப்பதாகக் கேள்விப்படுகிறேன். நாம் சாகாமல் உயிர்வாழும்படி, அங்குபோய் நமக்குத் தானியம் வாங்கி வாருங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","அப்பொழுது யோசேப்பின் பத்து சகோதரரும் தானியம் வாங்குவதற்காக எகிப்திற்குப் போனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ஆனால் யோசேப்பின் தம்பியான பென்யமீனுக்குத் தீங்கு நேரிடலாம் எனப் பயந்த யாக்கோபு, அவனை அவர்களோடு அனுப்பவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","கானான் நாட்டிலும் பஞ்சம் ஏற்பட்டபடியால், தானியம் வாங்குவதற்காக எகிப்திற்குப் போனவர்களுடன் இஸ்ரயேலின் மகன்களும் போனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","இப்பொழுது யோசேப்பு எகிப்து நாட்டின் ஆளுநனாக இருந்தான், மக்கள் யாவருக்கும் அவனே தானியம் விற்றான். யோசேப்பின் சகோதரர் அங்கு வந்ததும், தரையிலே முகங்குப்புற விழுந்து அவனை வணங்கினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","யோசேப்பு சகோதரர்களைக் கண்டவுடனே, அவர்களை இன்னார் என அறிந்துகொண்டான். ஆனால் அவன் அவர்களை அறியாத ஒரு அந்நியனைப்போல் பாசாங்கு செய்து கடுமையாய்ப் பேசி, “நீங்கள் எங்கேயிருந்து வருகிறீர்கள்?” என்று கேட்டான். அதற்கு அவர்கள், “நாங்கள் தானியம் வாங்கும்படி கானான் நாட்டிலிருந்து வந்திருக்கிறோம்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","யோசேப்பு தன் சகோதரர்களை யாரென்று அறிந்திருந்தாலும் அவர்களோ அவனை இன்னாரென்று அறிந்துகொள்ளவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","பின்பு யோசேப்பு, தான் முன்னர் அவர்களைக் குறித்துக் கண்ட கனவுகளை நினைத்துத் தன் சகோதரர்களிடம், “நீங்கள் உளவாளிகள்! எங்கள் நாட்டில் பாதுகாப்புக் குறைவு எங்கிருக்கின்றது என அறியவே இங்கு வந்தீர்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","அதற்கு அவர்கள், “இல்லை ஆண்டவனே, உம்முடைய அடியவர்களாகிய நாங்கள் உணவு வாங்குவதற்காகவே இங்கு வந்திருக்கிறோம். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","நாங்கள் எல்லோரும் ஒரே தகப்பனின் பிள்ளைகள். உமது அடியார்கள் உண்மையானவர்கள், உளவாளிகள் அல்ல” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","யோசேப்போ, “இல்லை! நீங்களோ எங்கள் நாடு எங்கே பாதுகாப்பற்று இருக்கிறது எனப் பார்க்கவே வந்தீர்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","அதற்கு அவர்கள், “உம்முடைய அடியார்களாகிய நாங்கள் பன்னிரண்டு சகோதரர்கள், கானான் நாட்டில் வாழும் ஒரே தகப்பனின் மகன்கள். கடைசி மகன் இப்பொழுது எங்கள் தகப்பனோடு இருக்கிறான், மற்றவன் இறந்துபோனான்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","யோசேப்பு அவர்களிடம், “நான் சொன்னபடியே நீங்கள் உளவாளிகள்தான்! ");
INSERT INTO tamtcv_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","நான் உங்களைச் சோதிக்கப்போகிறேன். பார்வோன் வாழ்வது நிச்சயம்போல, உங்கள் இளைய சகோதரன் இங்கு வந்தாலன்றி, நீங்கள் இவ்விடத்தைவிட்டுப் போகமாட்டீர்கள் என்பதும் நிச்சயம். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","உங்கள் இளைய சகோதரனை அழைத்துவர இப்பொழுது நீங்கள் உங்களில் ஒருவனை அனுப்பவேண்டும்; மற்றவர்கள் சிறையில் வைக்கப்படுவீர்கள், நீங்கள் சொன்னவை உண்மையோ எனப் பார்ப்பதற்கு உங்கள் வார்த்தைகள் இவ்வாறு சோதிக்கப்படும். இல்லாவிட்டால் பார்வோன் வாழ்வது நிச்சயம்போல நீங்கள் உளவாளிகள் என்பதும் நிச்சயமே!” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","அவன் அவர்களை மூன்று நாட்கள் தடுப்புக் காவலில் வைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","மூன்றாம் நாள் யோசேப்பு தன் சகோதரரிடம், “நான் இறைவனுக்குப் பயப்படுகிறவன், நீங்கள் இதைச் செய்யுங்கள்; அப்பொழுது உயிர் வாழ்வீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","நீங்கள் உண்மையானவர்களானால், உங்கள் சகோதரர்களில் ஒருவன் இங்கே சிறையில் இருக்கட்டும், மற்றவர்கள் பட்டினியாய் இருக்கும் உங்கள் குடும்பத்துக்குத் தானியத்தைக் கொண்டுபோங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","உங்கள் வார்த்தை நிரூபிக்கப்படும்படியும், நீங்கள் சாகாமல் இருக்கும்படியும், உங்களுடைய இளைய சகோதரனை என்னிடம் கொண்டுவர வேண்டும்” என்றான். அவர்கள் அவ்வாறு செய்யும்படி புறப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","பின்பு அவர்கள் ஒருவரை ஒருவர் பார்த்து, “நிச்சயமாய் நாம் நம்முடைய சகோதரனுக்குச் செய்த தீமைக்காகவே இப்பொழுது தண்டிக்கப்படுகிறோம். அவன் தன் உயிருக்காக மன்றாடி, துன்பப்பட்டதைக் கண்டும், நாம் அவனுக்குச் செவிகொடுக்கவில்லை. அதனால்தான் இத்துன்பம் நமக்கு நேரிட்டது” என்று சொல்லிக்கொண்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","அப்பொழுது ரூபன், “அச்சிறுவனுக்கு விரோதமாய்ப் பாவம்செய்ய வேண்டாமென நான் சொல்லவில்லையா? ஆனால் நீங்கள் கேட்கவில்லை! இப்பொழுது அவனுடைய இரத்தத்திற்கு நாம் கணக்குக் கொடுத்தேயாக வேண்டும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","யோசேப்பு மொழி பெயர்ப்பாளன் மூலம் பேசியதால், தாங்கள் அவ்வாறு பேசியது அவனுக்கு விளங்கும் என்பதை அவர்கள் உணரவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","யோசேப்பு அவர்களைவிட்டு அப்பாலே போய் அழத்தொடங்கினான். அதன்பின் திரும்பவும் வந்து, அவர்களுடன் பேசினான். அவன் அவர்களோடிருந்த சிமியோனைப் பிடித்து, மற்றச் சகோதரரின் முன்பாகக் கட்டுவித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","பின்பு யோசேப்பு அவர்களுடைய சாக்குகளில் தானியத்தை நிரப்பும்படியும், ஒவ்வொருவருடைய வெள்ளியையும் திரும்ப அவனவன் சாக்கில் வைக்கும்படியும், அவர்கள் பயணத்திற்குத் தேவையான உணவுகளைக் கொடுக்கும்படியும் கட்டளையிட்டான். அவ்வாறே செய்து முடிந்ததும், ");
INSERT INTO tamtcv_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","அவர்கள் தானியப் பொதிகளைத் தங்கள் கழுதைகளின்மேல் ஏற்றிக்கொண்டு, அங்கிருந்து புறப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","இரவுக்காக தங்கிய இடத்தில் அவர்களில் ஒருவன் கழுதைக்குத் தீனி போடுவதற்காகத் தன் சாக்கைத் திறந்தான், அப்பொழுது சாக்கின் வாயில் தன் வெள்ளிக்காசு இருப்பதைக் கண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","அவன் தன் சகோதரரிடம், “என் வெள்ளிக்காசு திருப்பிக் கொடுக்கப்பட்டிருக்கிறது, இதோ என் சாக்கில் அது இருக்கிறது பாருங்கள்” என்றான். அவர்கள் பயந்து மனங்கலங்கி, ஒருவரையொருவர் நடுக்கத்துடன் பார்த்து, “இறைவன் எங்களுக்குச் செய்திருப்பது என்ன?” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","அவர்கள் கானான் நாட்டுக்குத் தங்கள் தகப்பன் யாக்கோபிடம் வந்தபோது, தங்களுக்கு நடந்ததையெல்லாம் அவனுக்குச் சொன்னார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“எகிப்தில் அதிகாரியாய் இருப்பவன் எங்களுடன் மிகவும் கடுமையாகப் பேசி, எங்களை உளவு பார்ப்பவர்களைப் போல் நடத்தினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","ஆனால் நாங்கள் அவனிடம், ‘நாங்கள் நீதியானவர்கள்; உளவாளிகள் அல்ல. ");
INSERT INTO tamtcv_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","நாங்கள் பன்னிரண்டு சகோதரர், ஒரே தகப்பனின் பிள்ளைகள், ஒருவன் இறந்துவிட்டான்; இப்பொழுது இளையவன் எங்கள் தகப்பனோடு கானான் நாட்டில் இருக்கிறான்’ என்று சொன்னோம். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“அப்பொழுது அந்நாட்டின் அதிபதியானவன் எங்களிடம், ‘நீங்கள் நீதியானவர்கள் என்று நான் அறிய உங்கள் சகோதரரில் ஒருவனை இங்கே என்னுடன் விட்டுவிட்டு, மற்றவர்கள் பட்டினியாய் இருக்கும் உங்கள் குடும்பத்துக்குத் தானியத்தை எடுத்துக்கொண்டு போங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","ஆனால், நீங்கள் உளவாளிகள் அல்ல, நீதியானவர்கள் என நான் அறியும்படி, உங்கள் இளைய சகோதரனை என்னிடம் கொண்டுவாருங்கள். அப்பொழுது உங்கள் சகோதரனை உங்களிடம் திருப்பி ஒப்படைப்பேன், நீங்களும் இந்நாட்டில் வியாபாரம் செய்யலாம் என்று சொன்னான்’ ” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","அவர்கள் தங்கள் சாக்குகளிலுள்ள தானியத்தைக் கொட்டியபோது, ஒவ்வொருவனுடைய சாக்கிலும் அவனவனுடைய பணப்பை இருந்தது! அவர்களும், அவர்கள் தகப்பனும் அவற்றைக் கண்டபோது பயந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","அவர்கள் தகப்பன் யாக்கோபு அவர்களிடம், “நீங்கள் எனக்கு என் பிள்ளைகளை இல்லாமல் செய்துவிட்டீர்கள். யோசேப்பும் இல்லை, சிமியோனும் இல்லை, இப்போது பென்யமீனையும் கொண்டு போகப்போகிறீர்கள். எல்லாமே எனக்கு விரோதமாய் இருக்கின்றதே!” என்று சொல்லிக் கலங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","அப்பொழுது ரூபன் தன் தகப்பனிடம், “நான் பென்யமீனை உம்மிடம் மறுபடியும் கொண்டுவராவிட்டால், என்னுடைய இரண்டு மகன்களையும் நீர் கொன்றுவிடலாம். அவனை என்னுடைய பாதுகாப்பிலேயே விட்டுவிடும், அவனை மறுபடியும் உம்மிடம் கொண்டுவருவேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","ஆனால் யாக்கோபு, “என் மகன் உங்களுடன் அங்கு வரமாட்டான்; அவன் சகோதரன் இறந்துபோனான், இவன் ஒருவன் மட்டுமே எஞ்சியிருக்கிறான். நீங்கள் போகும் பயணத்தில் இவனுக்கும் தீமையேதும் சம்பவித்தால், நரைத்த கிழவனாகிய என்னைத் துக்கத்துடனேயே சவக்குழிக்குள் போகச்செய்வீர்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","நாட்டிலே பஞ்சம் இன்னும் மிகக் கொடுமையாயிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","அதனால் எகிப்திலிருந்து கொண்டுவந்த தானியமெல்லாம் முடிந்தபின், அவர்கள் தகப்பன் யாக்கோபு தன் மகன்களிடம், “நீங்கள் மறுபடியும்போய் இன்னும் கொஞ்சம் தானியம் வாங்கிக் கொண்டுவாருங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","அப்பொழுது யூதா தன் தகப்பனிடம், “ ‘உங்களுடன் உங்கள் சகோதரனும் வராவிட்டால் என் முகத்தில் நீங்கள் விழிக்க முடியாது என்று எகிப்தின் அதிபதி கண்டிப்பாக எச்சரிக்கை செய்தான்.’ ");
INSERT INTO tamtcv_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","எங்கள் சகோதரனை எங்களுடன் அனுப்பினால்தான் நாங்கள் போய் உங்களுக்குத் தானியம் வாங்கிவருவோம். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","நீர் அவனை எங்களுடன் அனுப்பாவிட்டால் நாங்கள் அங்கே போகமாட்டோம்; ஏனெனில், ‘உங்கள் சகோதரனும் உங்களுடன் வந்தாலன்றி, நீங்கள் என் முகத்தில் விழிக்க முடியாது’ என்று அந்த அதிகாரி சொல்லியிருக்கிறான்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","அப்பொழுது இஸ்ரயேல், “உங்களுக்கு இன்னுமொரு சகோதரன் இருக்கிறான் என்று சொல்லி, ஏன் இந்தத் துன்பத்தை எனக்கு வருவித்தீர்கள்?” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","அதற்கு அவர்கள், “அந்த மனிதன் எங்களைப் பற்றியும், எங்கள் குடும்பத்தைப்பற்றியும் விபரமாய் விசாரித்தான். ‘உங்களுடைய தகப்பன் இன்னும் உயிரோடிருக்கிறாரா?’ என்றும், ‘உங்களுக்கு இன்னுமொரு சகோதரன் இருக்கிறானா?’ என்றும் கேட்டான். நாங்கள் அவனுடைய கேள்விகளுக்கு மட்டுமே பதில் சொன்னோம். ‘உங்கள் சகோதரனை இங்கே கூட்டிக்கொண்டு வாருங்கள்’ என்று சொல்வான் என்று எங்களுக்கு எப்படித் தெரியும்?” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","பின்பு யூதா தன் தகப்பனாகிய இஸ்ரயேலிடம், “நீங்களும் நாங்களும், எங்கள் பிள்ளைகளும் சாகாமல் வாழும்படி, நீர் அவனை என்னுடன் அனுப்பும். நாங்கள் உடனேயே போவோம். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","அவனுடைய பாதுகாப்புக்கு நானே பொறுப்பாய் இருப்பேன்; தனிப்பட்ட விதத்தில் அவனுக்காக நீர் என்னை உத்தரவாதியாக வைத்திருக்கலாம். அவனை மறுபடியும் உமது முன் கொண்டுவந்து நிறுத்தாவிட்டால், அந்தப் பழியை என் வாழ்நாள் முழுவதும் உமக்கு முன்பாக நான் சுமப்பேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","நாங்கள் தாமதியாமல் இருந்திருந்தால், இதுவரை நாங்கள் இரண்டுமுறை போய்த் திரும்பியிருக்கலாம்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","அதன்பின் அவர்களின் தகப்பனாகிய இஸ்ரயேல் அவர்களிடம், “அப்படியானால் நான் சொல்வதுபோல் செய்யுங்கள். நாட்டின் சிறந்த பொருட்களில் கொஞ்சம் தைலம், கொஞ்சம் தேன், கொஞ்சம் நறுமணப் பொருட்கள், வெள்ளைப்போளம், கொஞ்சம் பிஸ்தா கொட்டைகள், வாதுமைக் கொட்டைகள் ஆகியவற்றை உங்கள் சாக்குகளில் வைத்து, அந்த மனிதனுக்கு அன்பளிப்பாகக் கொண்டுபோங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","இரண்டு மடங்கு வெள்ளிக்காசையும் உங்களுடன் கொண்டுபோங்கள், ஏனெனில், சென்றமுறை உங்கள் சாக்குகளில் வைக்கப்பட்ட வெள்ளிக்காசையும் நீங்கள் திருப்பிக் கொடுக்கவேண்டும். இப்பணம் ஒருவேளை தவறுதலாக வந்திருக்குமோ தெரியாது. ");
INSERT INTO tamtcv_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","உங்கள் தம்பியையும் உங்களுடன் அழைத்துக்கொண்டு, உடனே அந்த மனிதனிடம் போங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","எல்லாம் வல்ல இறைவன் சிறையிலிருக்கும் உங்கள் சகோதரனையும், தம்பி பென்யமீனையும் மறுபடியும் இவ்விடம் அனுப்பும்படி அந்த மனிதன் உங்களுக்கு இரக்கம் காட்டச்செய்வாராக. நானோ பிள்ளைகளை இழக்க வேண்டுமென்றால், பிள்ளைகளை இழந்தவனாவேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","அவ்வாறே அவர்கள் அன்பளிப்பையும் இரண்டு மடங்கு வெள்ளிக்காசையும் எடுத்துக்கொண்டு, பென்யமீனையும் தங்களுடன் கூட்டிக்கொண்டு போனார்கள். அவர்கள் எகிப்திற்கு விரைந்து சென்று, அங்கே யோசேப்பின் முன்னிலையில் போய் நின்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","பென்யமீன் அவர்களுடன் வந்திருப்பதைக் கண்ட யோசேப்பு, தன் வீட்டு மேற்பார்வையாளனிடம், “இவர்களை என் வீட்டுக்கு அழைத்துக்கொண்டு போ, இவர்கள் இன்று மத்தியானம் என்னுடன் சாப்பிடுவதற்காக, ஒரு மிருகத்தை அடித்து ஆயத்தம் செய்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","யோசேப்பு கட்டளையிட்டபடியே அந்த அதிகாரி அவர்களை யோசேப்பின் வீட்டுக்கு அழைத்துச் சென்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","அவர்கள் யோசேப்பின் வீட்டுக்குக் கொண்டு செல்லப்பட்டபோது பயந்தார்கள். அவர்கள், “முதல்முறை நாம் வந்தபோது, நமது சாக்குகளில் மீண்டும் வைக்கப்பட்டிருந்த வெள்ளிக்காசின் நிமித்தமே நாம் இங்கு கொண்டுவரப்பட்டிருக்கிறோம். நம்மைத் தாக்கி, அடக்கி, நம்மை அடிமைகளாகப் பிடித்து, நமது கழுதைகளையும் எடுத்துக்கொள்ளவே அவன் விரும்புகிறான்” என்று நினைத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","அதனால் அவர்கள் யோசேப்பின் மேற்பார்வையாளனிடம் போய், வீட்டு வாசலில் இருந்த அவனுடன் பேசினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","அவர்கள் அவனிடம், “ஆண்டவனே, முதல்முறை தானியம் வாங்க நாங்கள் இங்கே வந்தோம். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ஆனால், போகும் வழியில் நாங்கள் இரவு தங்கிய இடத்தில், எங்கள் சாக்குகளைத் திறந்தோம். அப்பொழுது எங்கள் ஒவ்வொருவருடைய சாக்கின் வாயிலும், நாங்கள் கொடுத்த வெள்ளிக்காசு குறையாது அப்படியே இருக்கக் கண்டோம். எனவே அவற்றைத் திரும்பவும் கொண்டுவந்திருக்கிறோம். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","அத்துடன் இம்முறையும் தானியம் வாங்குவதற்கு கூடுதலாக வெள்ளிக்காசைக் கொண்டுவந்திருக்கிறோம். யார் அந்த வெள்ளிக்காசை மறுபடியும் எங்கள் சாக்குகளில் வைத்தார்கள் என்பது எங்களுக்குத் தெரியாது” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","அதற்கு மேற்பார்வையாளன் அவர்களிடம், “பரவாயில்லை, நீங்கள் ஒன்றுக்கும் பயப்பட வேண்டியதில்லை. உங்கள் இறைவனான உங்கள் தகப்பனுடைய இறைவனே, உங்கள் சாக்குகளில் உங்களுக்குச் செல்வத்தை வைத்திருக்கிறார்; உங்கள் வெள்ளிக்காசை நான் பெற்றுக்கொண்டேன்” என்றான். பின்பு சிமியோனை வெளியே அவர்களிடம் கொண்டுவந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","மேற்பார்வையாளன் யோசேப்பின் சகோதரரை வீட்டுக்கு அழைத்துச்சென்று, அவர்கள் கால்களைக் கழுவுவதற்குத் தண்ணீர் கொடுத்தான். அத்துடன் அவர்கள் கழுதைகளுக்குத் தீனியும் கொடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","அவர்கள் யோசேப்புடன் சாப்பிடப் போவதாகக் கேள்விப்பட்டதால், மத்தியானம் யோசேப்பு வரும்போது கொடுப்பதற்காகத் தங்கள் அன்பளிப்புகளை ஆயத்தம் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","யோசேப்பு வீட்டுக்கு வந்தபொழுது, அவர்கள் வீட்டுக்குள் கொண்டுவந்திருந்த தங்கள் அன்பளிப்புகளைக் கொடுத்துத் தரைமட்டும் விழுந்து, அவனை வணங்கினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","யோசேப்பு அவர்கள் சுகசெய்திகளை விசாரித்து, “முன்பு நீங்கள் உங்கள் வயதுசென்ற தகப்பனைப் பற்றிச் சொன்னீர்களே, அவர் எப்படியிருக்கிறார்? இன்னும் அவர் உயிரோடிருக்கிறாரா?” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","அதற்கு அவர்கள், “உமது அடியவனாகிய எங்கள் தகப்பன் இன்னும் உயிரோடு சுகமாக இருக்கிறார்” என்று சொன்னார்கள். அவனுக்கு மதிப்புக் கொடுக்கும்படி குனிந்து வணங்கினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","யோசேப்பு அவர்களைப் பார்த்து, தன் சொந்தத் தாயின் மகனான, தன் சகோதரன் பென்யமீனைக் கண்டதும், நீங்கள் சொன்ன உங்கள் இளைய சகோதரன் இவன்தானா? என்று கேட்டான். பின்பு, “என் மகனே, இறைவன் உனக்குக் கிருபை செய்வாராக” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","யோசேப்பு தன் தம்பியைக் கண்டதும் உணர்ச்சி வசப்பட்டவனாய், விரைந்து வெளியே சென்று அழுவதற்கு இடம் தேடினான். அவன் தன்னுடைய அறைக்குள் சென்று அங்கே அழுதான். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","பின்பு அவன் தன் முகத்தைக் கழுவி, வெளியே வந்து தன்னை அடக்கிக்கொண்டு, “உணவு பரிமாறுங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","எபிரெயருடன் சாப்பிடுவது எகிப்தியருக்கு அருவருப்பாய் இருந்தபடியால், எகிப்தியர் எபிரெயருடன் அமர்ந்து சாப்பிடுவதில்லை. அதனால் யோசேப்புக்கு வேறாகவும், அவன் சகோதரர்களுக்கு வேறாகவும், அவனுடன் சாப்பிட்ட எகிப்தியருக்கு வேறாகவும் உணவு பரிமாறப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","யோசேப்புக்கு முன்பாக மூத்தவன் தொடங்கி இளையவன் வரைக்கும் அவர்கள் வயதின்படியே பந்தியில் அமர்த்தப்பட்டார்கள்: யோசேப்பின் சகோதரர் அதைக்குறித்து ஆச்சரியப்பட்டு, ஒருவரையொருவர் பார்த்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","யோசேப்பின் மேஜையிலிருந்து அவர்களுக்கு உணவு பரிமாறப்பட்டபோது, மற்றவர்களுடைய பங்குகளைப் பார்க்கிலும் பென்யமீனின் பங்கு ஐந்து மடங்கு அதிகமாக இருந்தது. அவர்கள் யோசேப்புடன் தாராளமாக விருந்துண்டு குடித்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","அதன்பின் யோசேப்பு, தன் வீட்டு மேற்பார்வையாளனிடம், “இந்த மனிதருடைய சாக்குகளை அவர்கள் தூக்கிச் சுமக்கக்கூடிய அளவு தானியத்தால் நிரப்பி, ஒவ்வொருவரின் சாக்குகளின் வாயிலும் அவனவன் வெள்ளிக்காசை வைத்துக் கட்டு. ");
INSERT INTO tamtcv_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","இளையவன் பென்யமீனுடைய சாக்கின் வாயிலே என் வெள்ளிக்கிண்ணத்தையும் தானியத்துக்கான வெள்ளிக்காசையும் வைத்துக் கட்டு” என்று கட்டளையிட்டான். யோசேப்பு சொன்னபடியே அவன் செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","காலை விடிந்தபோது, அவர்கள் தங்கள் கழுதைகளுடன் வழியனுப்பப்பட்டனர். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","அவர்கள் பட்டணத்திலிருந்து அதிக தூரம் போகுமுன் யோசேப்பு தன் வீட்டு மேற்பார்வையாளனிடம், “நீ உடனே அவர்களைப் பின்தொடர்ந்து போ; அவர்களைப் பிடித்தவுடன் அவர்களிடம், ‘நீங்கள் நன்மைக்குப் பதிலாகத் தீமை செய்தது ஏன்? ");
INSERT INTO tamtcv_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","இது என் எஜமான் பானம் பண்ணுவதற்கும் எதிர்காலத்தை கணிக்கவும் பயன்படுத்தும் பாத்திரமல்லவா? நீங்கள் செய்திருப்பது கொடிய செயல்’ என்று சொல்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","அவன் அவர்களைச் சென்றடைந்தபோது, அவ்வார்த்தைகளை அப்படியே சொன்னான். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","ஆனால் அவர்கள் அவனிடம், “ஏன் ஐயா இப்படியானவற்றைச் சொல்கிறீர்? இப்படிப்பட்ட எதையும் செய்ய உமது அடியாராகிய நாங்கள் எண்ணியும் பார்க்கவில்லை! ");
INSERT INTO tamtcv_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","முன்பு எங்கள் சாக்குகளில் நாங்கள் கண்ட பணத்தைக்கூட கானானிலிருந்து மீண்டும் கொண்டுவந்தோம். அப்படியிருக்க, உமது எஜமானின் வீட்டிலிருந்து வெள்ளியையோ தங்கத்தையோ நாங்கள் ஏன் திருடவேண்டும்? ");
INSERT INTO tamtcv_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","உமது அடியாரில் எவராவது அதை வைத்திருப்பதை நீர் கண்டால் அவன் சாகவேண்டும்; மற்றவர்கள் என் எஜமானின் அடிமைகளாவோம்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","அதற்கு அவன், “அப்படியானால் சரி; நீங்கள் சொன்னபடியே ஆகட்டும். உங்களில் எவனுடைய சாக்கில் அந்த வெள்ளிப் பாத்திரம் இருக்கிறதோ, அவன் எனக்கு அடிமையாவான்; மற்றவர்கள் குற்றத்திலிருந்து விடுவிக்கப்படுவீர்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","அவர்கள் ஒவ்வொருவரும் தன்தன் சாக்கைக் கீழே இறக்கி, அதை அவிழ்த்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","அப்பொழுது மேற்பார்வையாளன் மூத்தவனுடைய சாக்கிலிருந்து இளையவனுடைய சாக்குவரை சோதிக்கத் தொடங்கினான். அந்தப் பாத்திரம் பென்யமீனுடைய சாக்கில் இருக்கக் காணப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","அதைக் கண்டவுடனே அவர்கள் தங்கள் உடைகளைக் கிழித்துக்கொண்டார்கள். பின்பு, அவர்கள் எல்லோரும் தங்கள் கழுதைகளில் சுமைகளை ஏற்றிக்கொண்டு பட்டணத்திற்குத் திரும்பி வந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","யூதாவும் அவன் சகோதரரும் திரும்பிவந்தபோது, யோசேப்பு இன்னும் தன் வீட்டிலேயே இருந்தான். அவர்கள் யோசேப்பின் முன் தரையில் முகங்குப்புற விழுந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","யோசேப்பு அவர்களிடம், “நீங்கள் செய்திருப்பது என்ன? என்னைப்போன்ற ஒரு மனிதன், சம்பவிக்கப் போவதை முன்பே கணித்துவிடுவான் என்று உங்களுக்குத் தெரியாதா?” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","அதற்கு யூதா, “ஆண்டவனே, உமக்கு நாங்கள் என்ன சொல்வோம்? நாங்கள் குற்றமற்றவர்கள் என்பதை எப்படி நிரூபிப்போம்? இறைவன் உமது அடியாரின் குற்றத்தை வெளிப்படுத்திவிட்டார். நாங்களும் உமது பாத்திரத்தை வைத்திருப்பவனும் இப்பொழுது என் எஜமானுக்கு அடிமைகள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","ஆனால் யோசேப்போ, “அப்படிப்பட்ட செயலைச் செய்வதை என்னால் எண்ணிப்பார்க்கவும் முடியாது! கிண்ணத்தை வைத்திருக்கக் காணப்பட்டவன் மட்டுமே எனக்கு அடிமையாவான். மற்றவர்கள் உங்கள் தகப்பனிடம் சமாதானத்துடன் திரும்பிப்போங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","யூதா யோசேப்பிடம் சென்று, “ஆண்டவனே, உமது அடியானாகிய நான், உம்மிடம் ஒரு வார்த்தை சொல்ல அனுமதியும். நீர் பார்வோனுக்குச் சமமாய் இருக்கிறபோதிலும், உமது அடியவன்மேல் கோபிக்க வேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","ஆண்டவனே, நீர் உமது அடியார்களிடம், ‘உங்களுக்குத் தகப்பனாவது சகோதரராவது இருக்கிறார்களா?’ என்று கேட்டீர். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","அதற்கு நாங்கள் எங்கள் ஆண்டவனிடம், ‘ஆம், எங்களுக்கு வயதுசென்ற தகப்பனும், அவருக்கு முதிர்வயதில் பிறந்த ஒரு இளம் மகனும் இருக்கிறான். அவனுடைய சகோதரன் இறந்துபோனான், அவனுடைய தாயின் பிள்ளைகளில் அவன் ஒருவனே உயிரோடிருக்கிறான்; அவனுடைய தகப்பன் அவனை நேசிக்கிறார்’ என்று சொன்னோம். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“அப்பொழுது நீர் உமது அடியாரிடம், ‘நான் அவனைப் பார்ப்பதற்கு அவனை என்னிடம் இங்கு கொண்டுவாருங்கள்’ என்றீர். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","அதற்கு நாங்கள் உம்மிடம், ‘ஐயா, அவன் தகப்பனைவிட்டு வரமுடியாது; அப்படி அவன் பிரிந்து வந்தால், அவனுடைய தகப்பன் இறந்து போவார்’ என்றோம். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ஆனால் நீரோ, ‘உங்கள் இளைய சகோதரன் உங்களுடன் வராவிட்டால், மீண்டும் என் முகத்தை உங்களால் பார்க்க முடியாது’ என்று உமது அடியாராகிய எங்களிடம் சொன்னீர். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","நாங்கள் உமது அடியவனாகிய எங்கள் தகப்பனிடம் போனபோது, ஐயா, நீர் சொல்லியிருந்தவற்றை அவரிடம் சொன்னோம். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“எங்கள் தகப்பனோ, ‘நீங்கள் மறுபடியும்போய் இன்னும் கொஞ்சம் தானியம் வாங்கி வாருங்கள்’ என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","அப்போது நாங்கள் அவரிடம், ‘நாங்கள் அங்கே போகமுடியாது; எங்கள் இளைய சகோதரன் எங்களுடன் வந்தால்தான் நாங்கள் அங்கே போவோம். எங்கள் இளைய சகோதரன் எங்களோடு வராவிட்டால், நாங்கள் அந்த மனிதனின் முகத்தைப் பார்க்கவே முடியாது’ என்று சொன்னோம். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“அப்பொழுது உமது அடியானாகிய எங்கள் தகப்பன் எங்களிடம், ‘என் மனைவி இரண்டு மகன்களைப் பெற்றாள் என்பதை நீங்கள் அறிவீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","அவர்களில் ஒருவன் என்னைவிட்டுப் போய்விட்டான், “நிச்சயமாய் அவனை ஒரு கொடிய மிருகம் கிழித்துக் கொன்றிருக்க வேண்டும்.” அன்றிலிருந்து அவனை நான் காணவேயில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","நீங்கள் இவனையும் என்னிடமிருந்து கொண்டுபோய், இவனுக்குத் தீங்கு ஏதும் ஏற்பட்டுவிட்டால், முதியவனாகிய என்னைத் துக்கத்தோடே சவக்குழியில் இறங்கப் பண்ணுவீர்கள்’ என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“இந்த சிறுவனுடைய உயிருடன் என் தகப்பனின் உயிர் ஒன்றிணைந்து இருக்கின்றது. அதனால் இப்பொழுது நான் உமது அடியானாகிய என் தகப்பனிடம் போகும்போது, ");
INSERT INTO tamtcv_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","இந்த சிறுவன் அங்கு இல்லாததைக் கண்டால், அவர் இறந்துவிடுவார். அதனால் உமது அடியாராகிய நாங்கள், எங்கள் முதிர்வயதான தகப்பனைத் துக்கத்துடன் சவக்குழியில் இறங்கச் செய்வோம். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","உமது அடியானாகிய நானே இந்த சிறுவனின் பாதுகாப்புக்கு உத்தரவாதம் அளித்தேன். நான் என் தகப்பனிடம், ‘என் தகப்பனே, இவனை மறுபடியும் உம்மிடம் கொண்டுவராவிட்டால், உமக்கு முன்பாக என் வாழ்நாளெல்லாம் அந்தப் பழியை நானே சுமப்பேன்’ என்றும் சொல்லியிருக்கிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“ஆகையால் இப்பொழுது இந்த சிறுவனுக்குப் மறுமொழியாக, ஐயா, உமது அடியானாகிய நான் உமது அடிமையாக இங்கே இருப்பேன், இவன் தன் சகோதரருடன் திரும்பிச் செல்லட்டும். ");
INSERT INTO tamtcv_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","இவன் என்னுடன் இல்லாவிட்டால், நான் எப்படித் திரும்பிப் போகமுடியும்? முடியாது! என் தகப்பனுக்கு வரும் அவலத்தை என்னைப் பார்க்க விடாதேயும்” என்று சொன்னான். ");
INSERT INTO tamtcv_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","அங்கு நின்ற தன் உதவியாளர்களுக்கு முன்னால் யோசேப்பினால் அதற்குமேல் தன்னை அடக்கிக்கொள்ள முடியவில்லை. அதனால் அவன் அவர்களிடம், “எல்லோரையும் என் முன்னிருந்து போகச்செய்யுங்கள்” என்று சத்தமிட்டான். யோசேப்பு தன் சகோதரருக்குத் தன்னை வெளிப்படுத்தும்போது, வேறு ஒருவரும் அவனோடிருக்கவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","அவன் மிகச் சத்தமிட்டு அழுததினால் அது வெளியே நின்ற எகிப்தியருக்குக் கேட்டது; பார்வோனின் வீட்டாரும் அதைப்பற்றிக் கேள்விப்பட்டனர். ");
INSERT INTO tamtcv_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","யோசேப்பு தன் சகோதரரிடம், “நான்தான் யோசேப்பு; என் தந்தை இன்னும் உயிரோடிருக்கிறாரா?” என்று கேட்டான். ஆனால் அவன் சகோதரர்களால் பதிலேதும் சொல்ல முடியவில்லை. ஏனெனில் அவன் முன்னிலையில் அவர்கள் திகிலடைந்திருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","யோசேப்பு தன் சகோதரரிடம், “என் அருகே வாருங்கள்” என்று கூப்பிட்டான். அவர்கள் வந்தவுடன் அவன் அவர்களிடம், “எகிப்திற்குப் போகிறவர்களிடத்தில் நீங்கள் விற்ற உங்கள் சகோதரன் யோசேப்பு நான்தான்! ");
INSERT INTO tamtcv_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","இப்பொழுது நீங்கள் என்னை விற்றதற்காக கலங்கவும், உங்கள்மேல் கோபங்கொள்ளவும் வேண்டாம். ஏனெனில், உயிர்களைக் காப்பதற்காகவே இறைவன் என்னை உங்களுக்கு முன்பாகவே இங்கு அனுப்பினார். ");
INSERT INTO tamtcv_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","இரு வருடங்களாக நாடெங்கும் பஞ்சம் உண்டாயிருக்கிறது, உழுதலும், அறுவடை செய்தலும் இன்னும் ஐந்து வருடங்களுக்கு இருக்காது. ");
INSERT INTO tamtcv_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","பூமியில் மிஞ்சியுள்ள உங்கள் சந்ததியைப் பாதுகாத்து வைக்கவும், உங்கள் உயிர்களைப் பெரும் மீட்பினால் காப்பாற்றவுமே, இறைவன் என்னை உங்களுக்கு முன்பாக இங்கு அனுப்பியுள்ளார். ");
INSERT INTO tamtcv_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“ஆகையால் நீங்களல்ல, இறைவனே என்னை இங்கு அனுப்பினார். அவரே என்னைப் பார்வோனுக்குத் தந்தையாகவும், அவன் குடும்பம் முழுவதற்கும் தலைவனாகவும், எகிப்து முழுவதற்கும் ஆளுநனாகவும் ஏற்படுத்தினார். ");
INSERT INTO tamtcv_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","நீங்கள் என் தகப்பனிடம் விரைவாகத் திரும்பிப்போய், உமது மகன் யோசேப்பு சொல்வது இதுவே: ‘இறைவன் என்னை எகிப்து முழுவதற்கும் தலைவனாக்கியிருக்கிறார். தாமதிக்காமல், என்னிடம் வாருங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","நீங்களும், உங்கள் பிள்ளைகளும், பேரப்பிள்ளைகளும் உங்களுடைய, ஆட்டு மந்தை, மாட்டு மந்தைகளோடும் உங்களுக்குரிய எல்லாவற்றோடும் எனக்கு அருகிலேயே கோசேன் பிரதேசத்தில் குடியிருக்கலாம். ");
INSERT INTO tamtcv_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","இன்னும் ஐந்து வருடங்கள் தொடர்ந்து பஞ்சம் நீடிக்கப்போகிறது. நான் உங்களுக்குத் தேவையானவற்றைத் தருவேன். இல்லாவிட்டால், நீங்களும் உங்கள் வீட்டாரும், உங்களுக்குரிய எல்லாரும் ஆதரவு அற்றவர்களாகிவிடுவீர்கள்’ என்கிறான் என்று சொல்லுங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","மேலும் யோசேப்பு, “உங்களுடன் பேசுகிறவன் உண்மையாகவே நானே என்பதை, நீங்களும் என் தம்பி பென்யமீனும் காண்கிறீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","எகிப்திலே எனக்குக் கொடுக்கப்பட்டுள்ள எல்லா கனத்தையும், நீங்கள் கண்ட எல்லாவற்றையும் என் தகப்பனுக்குச் சொல்லுங்கள். நீங்கள் விரைவாய் போய் என் தகப்பனை இங்கே கூட்டிக்கொண்டு வாருங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","பின்பு தன் தம்பி பென்யமீனைக் கட்டிப்பிடித்து அழுதான், அப்படியே பென்யமீனும் யோசேப்பைக் கட்டிப்பிடித்து அழுதான். ");
INSERT INTO tamtcv_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","பின்பு அவன் தன் சகோதரர் எல்லோரையும் முத்தமிட்டு அழுதான். அதன்பின் அவன் சகோதரரும் அவனுடன் பேசினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","யோசேப்பின் சகோதரர் வந்திருக்கிறார்கள் என்ற செய்தி பார்வோனின் அரண்மனைக்கு எட்டியபோது, அவனும் அவனுடைய அதிகாரிகள் எல்லோரும் மகிழ்ச்சி அடைந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","அப்பொழுது பார்வோன் யோசேப்பிடம் சொன்னதாவது: “நீ உன் சகோதரரிடம், ‘நீங்கள் உங்கள் மிருகங்களில் பொதிகளை ஏற்றிக்கொண்டு கானானுக்குத் திரும்பிப்போங்கள், ");
INSERT INTO tamtcv_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","அங்கிருந்து உங்கள் தகப்பனையும் உங்கள் குடும்பங்களையும் இங்கே என்னிடம் கூட்டிக்கொண்டு வாருங்கள். நான் எகிப்து நாட்டின் சிறந்ததை உங்களுக்குக் கொடுப்பேன்; நீங்கள் நாட்டின் செழிப்பை அனுபவிக்கலாம்.’ ");
INSERT INTO tamtcv_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“மேலும், நீ அவர்களுக்கு அறிவுறுத்திச் சொல்லவேண்டியதாவது: ‘எகிப்திலிருந்து சில வண்டிகளைக் கொண்டுபோய் உங்கள் பிள்ளைகளையும், மனைவிகளையும், உங்கள் தகப்பனோடுகூட இங்கே கூட்டிக்கொண்டு வாருங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","உங்களுக்குள்ள உடைமைகளைக் குறித்து கவலைப்பட வேண்டாம். ஏனெனில், எகிப்தின் சிறந்த பொருட்களெல்லாம் உங்களுடையதாகும்’ என்று சொல்” என்று பார்வோன் சொன்னான். ");
INSERT INTO tamtcv_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","இஸ்ரயேலின் மகன்கள் அவ்வாறே செய்தார்கள். யோசேப்பு பார்வோன் கட்டளையிட்டபடியே அவர்களுக்கு வண்டிகளையும், அவர்களுடைய பயணத்திற்குத் தேவையான உணவுகளையும் கொடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","அவர்கள் ஒவ்வொருவருக்கும் புதிய உடைகளையும் கொடுத்தான், பென்யமீனுக்கோ முந்நூறு சேக்கல் வெள்ளியையும், ஐந்து உடைகளையும் கொடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","யோசேப்பு தன் தகப்பனுக்கு பத்துக் கழுதைகளின்மேல் எகிப்தின் சிறந்த பொருட்கள், பத்துப் பெண் கழுதைகளின்மேல் தானியம், அப்பம் அவருடைய பயணத்திற்குத் தேவையான பொருட்கள் ஆகியவற்றை அனுப்பினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","அதன்பின் அவன் தன் சகோதரர்களை வழியனுப்பினான். அவர்கள் புறப்பட்டுப் போகும்போது அவர்களிடம், “நீங்கள் வழியில் வாக்குவாதம் செய்யவேண்டாம்!” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","அவர்கள் எகிப்திலிருந்து புறப்பட்டு கானானில் வசிக்கும் தங்கள் தகப்பன் யாக்கோபிடம் வந்து சேர்ந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","அவர்கள் தங்கள் தகப்பனிடம், “யோசேப்பு இன்னும் உயிரோடிருக்கிறான்! உண்மையில், அவனே எகிப்து முழுவதற்கும் ஆளுநனாகவும் இருக்கிறான்” என்றார்கள். அதைக் கேட்டதும் யாக்கோபு திகைத்துப் போனான்; அவன் அவர்களை நம்பவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","ஆனால் அவர்கள் யோசேப்பு சொன்ன எல்லாவற்றையும் தங்கள் தகப்பனுக்குச் சொன்னபோதும், யாக்கோபை எகிப்திற்கு அழைத்துப் போவதற்காக யோசேப்பு அனுப்பிய வண்டிகளைக் கண்டபோதும் அவனுடைய ஆவி புத்துயிர் பெற்றது. ");
INSERT INTO tamtcv_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","அப்பொழுது இஸ்ரயேல், “என் மகன் யோசேப்பு இன்னும் உயிரோடிருக்கிறான் என இப்பொழுது நான் நம்புகிறேன்! நான் சாகிறதற்கு முன் அவனைப் போய் பார்ப்பேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","இஸ்ரயேல் தன் உடைமைகளுடன் புறப்பட்டுப் பெயெர்செபாவை அடைந்தபோது, அங்கே தன் தகப்பன் ஈசாக்கின் இறைவனுக்குப் பலிகளைச் செலுத்தினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","அன்றிரவே இறைவன் இஸ்ரயேலுடன் தரிசனத்தில் பேசி, “யாக்கோபே! யாக்கோபே!” என்று கூப்பிட்டார். அதற்கு அவன், “இதோ இருக்கிறேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","அப்பொழுது அவர், “நான் இறைவன், நானே உன் தகப்பனின் இறைவன். நீ எகிப்திற்குப் போகப் பயப்படாதே, அங்கே நான் உன்னை ஒரு பெரிய நாடாக்குவேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","நீ எகிப்திற்குப் போகையில் உன்னுடன்கூட வருவேன், நிச்சயமாக உன்னை மறுபடியும் இங்கே கொண்டுவருவேன். யோசேப்பே தன் கையினால் உன் கண்களை மூடுவான்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","பின்பு யாக்கோபு பெயெர்செபாவை விட்டுப் புறப்பட்டான்; இஸ்ரயேலின் மகன்கள் தங்களுடைய தகப்பன் யாக்கோபையும், தங்கள் பிள்ளைகளையும், தங்கள் மனைவிகளையும் பார்வோன் அனுப்பிய வண்டிகளில் ஏற்றிச் சென்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","அத்துடன் தங்களுடைய வளர்ப்பு மிருகங்களுடனும், கானானில் சம்பாதித்த எல்லா பொருட்களுடனும், யாக்கோபும் அவன் சந்ததிகளும் எகிப்திற்குப் போனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","யாக்கோபு தன்னுடன் தன் சந்ததிகளான மகன்களையும், பேரன்களையும், மகள்களையும், பேத்திகளையும் அழைத்துக்கொண்டு எகிப்திற்குப் போனான். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","யாக்கோபுடன் எகிப்திற்குப்போன அவனுடைய சந்ததிகளான, இஸ்ரயேலரின் பெயர்களாவன: யாக்கோபின் முதற்பேறானவன் ரூபன். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ரூபனின் மகன்கள்: ஆனோக், பல்லூ, எஸ்ரோன், கர்மீ என்பவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","சிமியோனின் மகன்கள்: எமுயேல், யாமின், ஓகாத், யாகீன், சோகார், கானானியப் பெண்ணின் மகன் சாவூல் என்பவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","லேவியின் மகன்கள்: கெர்சோன், கோகாத், மெராரி என்பவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","யூதாவின் மகன்கள்: ஏர், ஓனான், சேலா, பாரேஸ், சேரா என்பவர்கள். கானான் நாட்டில் ஏர், ஓனான் என்பவர்கள் இறந்துபோனார்கள். பேரேஸின் மகன்கள்: எஸ்ரோன், ஆமூல் என்பவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","இசக்காருடைய மகன்கள்: தோலா, பூவா, யாசுப், சிம்ரோன் என்பவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","செபுலோனுடைய மகன்கள்: செரேத், ஏலோன், யக்லேல் என்பவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","பதான் அராமிலே மகள் தீனாளைத் தவிர யாக்கோபுக்கு லேயாள் பெற்றெடுத்த மகன்கள் இவர்களே. அவனுடைய மகன்களும் மகள்களும் எல்லாரும் முப்பத்து மூன்றுபேர். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","காத்துடைய மகன்கள்: சிப்பியோன், அகி, சூனி, எஸ்போன், ஏரி, அரோதி, அரேலி என்பவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","ஆசேருடைய மகன்கள்: இம்னா, இஸ்வா, இஸ்வி, பெரீயா என்பவர்கள். இவர்களுடைய சகோதரி செராக்கு என்பவள். பெரீயாவின் மகன்கள்: ஏபேர், மல்கியேல் என்பவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","லாபான் தன்னுடைய மகள் லேயாளுக்குக் கொடுத்த பெண்ணான, சில்பாள் மூலம் யாக்கோபுக்குக் கிடைத்த பிள்ளைகள் இவர்களே. அவர்கள் எல்லாரும் பதினாறுபேர். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","யாக்கோபின் மனைவி ராகேலின் மகன்கள்: யோசேப்பு, பென்யமீன் என்பவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","எகிப்திலே யோசேப்புக்கு மனாசேயும் எப்பிராயீமும் பிறந்தார்கள். இவர்களை ஓன் பட்டணத்து ஆசாரியனான போத்திபிராவின் மகள் ஆஸ்நாத் யோசேப்புக்குப் பெற்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","பென்யமீனின் மகன்கள்: பேலா, பெகேர், அஸ்பேல், கேரா, நாகமான், ஏகி, ரோஷ், முப்பீம், உப்பீம், ஆர்த் என்பவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","யாக்கோபுக்கு ராகேல் பெற்றெடுத்த மகன்கள் இவர்களே. அவர்கள் எல்லாமாக பதினாலு பேர். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","தாணுடைய மகன்: ஊசிம். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","நப்தலியின் மகன்கள்: யாத்சியேல், கூனி, எத்சேர், சில்லேம் என்பவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","லாபான் தன் மகள் ராகேலுக்குக் கொடுத்த பெண் பில்காள் யாக்கோபுக்கு பெற்றெடுத்த மகன்கள் இவர்களே. அவர்கள் எல்லாரும் ஏழுபேர். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","யாக்கோபுடன் எகிப்திற்குப்போன மகன்களின் மனைவிகளைத் தவிர, நேரடியான சந்ததிகள் எல்லோரும் அறுபத்தாறு பேர். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","யோசேப்புக்கு எகிப்தில் பிறந்த இரண்டு மகன்கள் இருந்தார்கள். அவர்களுடன் யாக்கோபின் குடும்ப அங்கத்தினர்களும் சேர்த்து எல்லாருமாக எழுபதுபேர். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","அதன்பின் யாக்கோபு கோசேனுக்குப் போகும் வழியை அறியும்படி, யூதாவைத் தனக்கு முன் யோசேப்பிடம் அனுப்பினான். அவர்கள் கோசேன் பிரதேசத்துக்கு வந்தபோது, ");
INSERT INTO tamtcv_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","யோசேப்பு தன் தகப்பன் இஸ்ரயேலைச் சந்திக்க தனது தேரை ஆயத்தப்படுத்தி, கோசேனுக்குப் போனான். யோசேப்பு தன் தகப்பன் முன் போனதுமே தன் தகப்பனைக் கட்டிப்பிடித்து வெகுநேரம் அழுதான். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","இஸ்ரயேல் யோசேப்பிடம், “நான் உன் முகத்தைக் கண்டதால், நீ உயிரோடிருக்கிறாய் என்பதை அறிந்துகொண்டேன்; இனி நான் சாகவும் ஆயத்தமாயிருக்கிறேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","பின்பு யோசேப்பு தன் சகோதரரிடமும் தன் தகப்பன் குடும்பத்தாரிடமும், “நான் பார்வோனிடம் போய், ‘கானான் நாட்டில் வாழ்ந்த என் சகோதரரும் என் தகப்பனின் குடும்பத்தாரும் என்னிடம் வந்திருக்கிறார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","அவர்கள் மேய்ப்பர்கள்; அவர்கள் கால்நடைகளை கவனித்துக்கொள்கிறார்கள்; அவர்கள் தங்கள் ஆட்டு மந்தைகளுடனும் மாட்டு மந்தைகளுடனும், தங்களுக்குச் சொந்தமான எல்லாவற்றுடனும் வந்திருக்கிறார்கள்’ என்று சொல்வேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","பார்வோன் உங்களைக் கூப்பிட்டு, ‘உங்கள் தொழில் என்ன?’ என்று கேட்கும்போது, ");
INSERT INTO tamtcv_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","நீங்கள், ‘உமது அடியாராகிய நாங்களும் எங்கள் முற்பிதாக்களைப் போலவே, சிறுவயதுமுதல் மந்தை மேய்ப்பவர்கள்’ என்று சொல்லுங்கள். அப்போது நீங்கள் கோசேன் நாட்டில் குடியிருக்க அனுமதிக்கப்படுவீர்கள். ஏனெனில், எகிப்தியருக்கு மேய்ப்பர்கள் அருவருப்பானவர்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","யோசேப்பு பார்வோனிடம் சென்று, “என் தகப்பனும் என் சகோதரரும் தங்களுடைய ஆட்டு மந்தைகளுடனும், மாட்டு மந்தைகளுடனும், அவர்களுக்குச் சொந்தமான எல்லாவற்றுடனும் கானான் நாட்டிலிருந்து வந்து, இப்பொழுது கோசேனில் தங்கியிருக்கிறார்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","அவன் தன் சகோதரரில் ஐந்துபேரைத் தெரிந்தெடுத்து, அவர்களைப் பார்வோனுக்கு முன்பாக நிறுத்தினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","அப்பொழுது பார்வோன் அந்தச் சகோதரர்களிடம், “உங்கள் தொழில் என்ன?” என்று கேட்டான். அதற்கு அவர்கள், “உமது அடியார்களாகிய நாங்கள் எங்கள் முற்பிதாக்களைப் போலவே மந்தை மேய்ப்பவர்கள்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","மேலும் அவர்கள் பார்வோனிடம், “கானான் நாட்டில் பஞ்சம் கொடியதாய் இருப்பதால், உமது அடியாரின் மந்தைக்கு மேய்ச்சல் நிலம் இல்லை. ஆகையால், தயவுசெய்து உமது அடியாராகிய எங்களைக் கோசேனில் குடியிருக்க அனுமதியும்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","அதற்குப் பார்வோன் யோசேப்பிடம், “உன் தகப்பனும் சகோதரரும் உன்னிடம் வந்திருக்கிறார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","இதோ, எகிப்து நாடு உனக்கு முன்பாக இருக்கிறது; உன் தகப்பனையும், சகோதரரையும் நாட்டின் சிறந்த இடத்தில் குடியமர்த்து. அவர்கள் கோசேனில் குடியிருக்கட்டும். அவர்களில் திறமையுள்ளவர்கள் இருப்பார்களானால், அவர்கள் என் வளர்ப்பு மிருகங்களுக்குப் பொறுப்பாய் இருக்கட்டும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","பின்பு யோசேப்பு தன் தகப்பன் யாக்கோபைப் பார்வோனுக்கு முன்பாகக் கூட்டிக்கொண்டு வந்தான். யாக்கோபு பார்வோனை ஆசீர்வதித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","பார்வோன் யாக்கோபிடம், “உம்முடைய வயது என்ன?” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","அதற்கு யாக்கோபு பார்வோனிடம், “என் வாழ்க்கைப் பயணம் நூற்று முப்பது வருடங்கள். என் வருடங்கள் என் முற்பிதாக்களின் வாழ்க்கைப் பயணத்தின் வருடங்களுக்குச் சமமானது அல்ல; அவை குறைவானதும், கஷ்டமானதுமாய் இருந்தன” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","பின்பு யாக்கோபு பார்வோனை ஆசீர்வதித்து, அவனிடமிருந்து விடைபெற்றுச் சென்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","பார்வோன் கட்டளையிட்டபடியே, யோசேப்பு தன் தகப்பனையும், சகோதரரையும் எகிப்தில் குடியேற்றி, நாட்டின் சிறந்த இடமான ராமசேஸ் என்னும் மாவட்டத்தில் அவர்களுக்கு நிலம் கொடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","யோசேப்பு தன் தகப்பனுக்கும், சகோதரருக்கும், தன் தகப்பன் வீட்டார் அனைவருக்கும் அவர்களுடைய பிள்ளைகளின் எண்ணிக்கைக்கு ஏற்றபடி உணவையும் வழங்கி வந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","ஆனாலும் பஞ்சம் மிகவும் கொடியதாக இருந்தபடியால், முழு நாட்டிலும் உணவு இல்லாமற்போயிற்று; எகிப்தும் கானானும் பஞ்சத்தினால் வெகுவாகப் பாதிக்கப்பட்டன. ");
INSERT INTO tamtcv_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","யோசேப்பு எகிப்திய மக்களுக்கும் கானானிய மக்களுக்கும் தானியத்தை விற்ற பணத்தையெல்லாம் சேர்த்து, பார்வோனின் அரண்மனைக்குக் கொண்டுவந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","எகிப்திலும் கானானிலும் உள்ள மக்களின் பணமெல்லாம் செலவழிந்து போயிற்று. அப்பொழுது எகிப்திய மக்கள் எல்லோரும் யோசேப்பிடம் வந்து, “எங்களுக்கு உணவு தாரும். உமது கண்களுக்கு முன்பாக நாங்கள் எல்லோரும் ஏன் சாகவேண்டும்? எங்களுடைய பணமெல்லாம் செலவழிந்து விட்டது” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","அதற்கு யோசேப்பு, “அப்படியானால் உங்கள் வளர்ப்பு மிருகங்களைக் கொண்டுவாருங்கள். பணம் செலவழிந்து போனபடியால், உங்கள் வளர்ப்பு மிருகங்களுக்குப் பதிலாக நான் உணவு விற்பேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","அப்படியே அவர்கள் தங்கள் வளர்ப்பு மிருகங்களை யோசேப்பிடம் கொண்டுவந்தார்கள்; அவன் அவர்களுடைய குதிரைகள், செம்மறியாடுகள், வெள்ளாடுகள், மாடுகள், கழுதைகள் முதலியவற்றை அவர்களிடமிருந்து பெற்றுக்கொண்டு, அதற்கு பதிலாகத் தானியம் கொடுத்தான். இவ்வாறு அந்த வருடம் முழுவதும் அவர்களுடைய வளர்ப்பு மிருகங்களுக்குப் பதிலாகத் தானியம் கொடுத்துவந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","அந்த வருடம் கழிந்தபோது, அடுத்த வருடம் அவர்கள் திரும்பவும் யோசேப்பிடம் வந்து, “ஐயா, நாங்கள் ஏன் உண்மையை உம்மிடம் மறைக்கவேண்டும்? எங்களிடமிருந்த பணமெல்லாம் முடிந்து, எங்கள் வளர்ப்பு மிருகங்களும் உமக்கு உரியதாகிவிட்டன. எங்கள் ஆண்டவனுக்குக் கொடுப்பதற்கு எங்கள் உடல்களையும் நிலங்களையும் தவிர வேறொன்றுமில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","நாங்களும் எங்கள் நிலங்களும் உம்முடைய கண்களுக்கு முன்பாக ஏன் அழியவேண்டும்? உணவுக்குப் பதிலாக எங்களையும் எங்கள் நிலத்தையும் நீர் வாங்கிக்கொள்ளும்; நாங்கள் எங்கள் நிலத்துடன் பார்வோனின் அடிமைகளாவோம். நாங்கள் சாகாமல் வாழ்வதற்கும், எங்கள் நிலம் பாழாய்ப் போகாதிருக்கவும் எங்களுக்கு விதையும் தானியமும் தாரும்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","ஆகவே யோசேப்பு எகிப்திலுள்ள நிலங்கள் அனைத்தையும் பார்வோனுக்காக வாங்கினான். எகிப்தியருக்கும் பஞ்சம் கொடியதாய் இருந்ததால், எகிப்தியர் அனைவரும் மொத்தமாகத் தங்கள் நிலங்களை விற்றார்கள். நிலங்கள் பார்வோனுக்குச் சொந்தமாயின. ");
INSERT INTO tamtcv_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","யோசேப்பு எகிப்தின் ஒரு எல்லை தொடங்கி மறு எல்லைவரையும் உள்ள மக்களை வெவ்வேறு பட்டணங்களில் அடிமைகளாகக் கீழ்ப்படுத்தினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","ஆனாலும் ஆசாரியருடைய நிலத்தை அவன் வாங்கவில்லை; ஏனெனில், பார்வோனிடமிருந்து ஆசாரியர்கள் நேரடியாக மானியத்தைப் பெற்றுக்கொண்டதால், கிடைத்த தானியம் அவர்களுக்குப் போதுமானதாய் இருந்தது. அதினாலேயே அவர்கள் தங்கள் நிலத்தை விற்கவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","அப்பொழுது யோசேப்பு மக்களிடம், “இன்று உங்களையும் உங்கள் நிலங்களையும் நான் பார்வோனுக்காக வாங்கிவிட்டேன். இதோ உங்களுக்கு விதைத்தானியம், நீங்கள் போய் நிலத்தில் பயிரிடுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","ஆனால் நீங்கள் உங்கள் விளைச்சலில் ஐந்தில் ஒரு பங்கைப் பார்வோனுக்குக் கொடுக்கவேண்டும். மீதி நான்கு பங்கை வயல்களின் விதைத் தானியத்திற்காகவும், உங்களுக்கும் உங்கள் குடும்பங்களுக்கும், உங்கள் பிள்ளைகளுக்கும் உணவுக்காகவும் வைத்துக்கொள்ளுங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","அதற்கு அவர்கள், “ஆண்டவனே, நீர் எங்கள் உயிரைக் காப்பாற்றியிருக்கிறீர்; நாங்கள் பார்வோனுக்கு அடிமைகளாயிருப்போம்; உம்முடைய கண்களில் தொடர்ந்து தயவு கிடைத்தாலே போதும்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","எனவே யோசேப்பு, “நிலத்தின் விளைச்சலில் ஐந்தில் ஒரு பங்கு பார்வோனுக்குரியது” என்ற எகிப்தின் நிலச்சட்டத்தை ஏற்படுத்தினான். அது இன்றுவரை அமுலில் இருக்கிறது. ஆசாரியர்களுடைய நிலங்கள் மட்டும் பார்வோனுக்குச் சொந்தமாகாமல் இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","இஸ்ரயேலர் எகிப்திலுள்ள கோசேன் பிரதேசத்தில் குடியிருந்தார்கள். அங்கே அவர்கள் தமக்குச் சொத்துக்களைச் சம்பாதித்து இனவிருத்தியில் பெருகி எண்ணிக்கையில் மிக அதிகமானார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","யாக்கோபு எகிப்தில் பதினேழு வருடங்கள் வாழ்ந்தான். அவனுடைய வாழ்நாட்கள் நூற்றுநாற்பத்தேழு வருடங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","இஸ்ரயேல் மரணநேரம் நெருங்கியபோது, அவன் தன் மகன் யோசேப்பை அழைத்து அவனிடம், “எனக்கு உன்னிடத்தில் தயவு கிடைக்குமானால், நீ உன் கையை என் தொடையின்கீழ் வைத்து, நீ எனக்குத் தயவும், உண்மையுமுள்ளவனாயிருப்பாய் என சத்தியம் செய். என்னை எகிப்திலே நீ அடக்கம்பண்ணவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","நான் என் முற்பிதாக்களுடன் இளைப்பாறும்போது, எகிப்திலிருந்து என்னைக் கொண்டுபோய், அவர்கள் அடக்கம்பண்ணப்பட்ட இடத்திலேயே என்னையும் அடக்கம் செய்” என்றான். அதற்கு யோசேப்பு, “நீங்கள் சொல்கிறபடியே நான் செய்வேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","இஸ்ரயேல், “நீ எனக்குச் சத்தியம் செய்துகொடு” என்றதும், யோசேப்பு சத்தியம் செய்துகொடுத்தான். அப்பொழுது இஸ்ரயேல் தனது கட்டிலின் தலைப்பக்கம் சாய்ந்துகொண்டு வழிபட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","சிறிது காலத்தின் பின்னர், “உம்முடைய தகப்பன் உடல் நலமில்லாமல் இருக்கிறார்” என்று யோசேப்புக்கு அறிவிக்கப்பட்டது. அவன் தன் இரு மகன்களான மனாசேயையும் எப்பிராயீமையும் தன்னுடன் கூட்டிக்கொண்டு போனான். ");
INSERT INTO tamtcv_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","“உம்முடைய மகன் யோசேப்பு வந்திருக்கிறான்” என்று யாக்கோபுக்கு அறிவிக்கப்பட்டது. உடனே இஸ்ரயேல் தன் பலத்தை ஒன்றுசேர்த்து எழுந்து கட்டிலில் உட்கார்ந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","யாக்கோபு யோசேப்பிடம், “கானானிலுள்ள லூஸ் என்னும் இடத்திலே எல்லாம் வல்ல இறைவன் எனக்குமுன் தோன்றி, என்னை ஆசீர்வதித்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","அவர் என்னிடம், ‘நான் உன்னை இனவிருத்தியில் பெருகப்பண்ணி எண்ணிக்கையில் அதிகரிப்பேன். அத்துடன் நான் உன்னை பல மக்கள் கூட்டமாக்கி, இந்த நாட்டை உனக்குப்பின் உன் சந்ததிகளுக்கும் நித்திய உடைமையாகக் கொடுப்பேன்’ என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“எனவே, நான் இங்கே உன்னிடம் எகிப்திற்கு வருவதற்குமுன், உனக்குப் பிறந்த இரண்டு பிள்ளைகளும் இப்பொழுதிலிருந்து என்னுடைய மகன்களாக எண்ணப்படுவார்கள்; ரூபனும், சிமியோனும் என் மகன்களாய் இருப்பதுபோல், எப்பிராயீமும் மனாசேயும் என் மகன்களாய் இருப்பார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","அவர்களுக்குப்பின் உனக்குப் பிறக்கும் பிள்ளைகள் எல்லோரும் உன்னுடையவர்களாய் இருப்பார்கள்; அந்த பிள்ளைகள் சொத்துரிமையாகப் பெற்றுக்கொள்ளும் இடங்கள், தங்கள் சகோதரரான மனாசே, எப்பிராயீம் ஆகியோரின் இடங்களிலிருந்தே கிடைக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","நான் பதானைவிட்டுத் திரும்பி வருகையில், எப்பிராத்தாவுக்குச் சற்று தூரத்தில், கானான் நாட்டில் நாங்கள் வழியில் இருக்கும்போதே, ராகேல் இறந்தாள்; பெத்லெகேம் எனப்படும் எப்பிராத்தாவுக்குப் போகும் வழியின் அருகே நான் அவளை அடக்கம் செய்தேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","இஸ்ரயேல் யோசேப்பின் மகன்களை கண்டபோது, “இவர்கள் யார்?” என்று அவனிடம் கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","அதற்கு யோசேப்பு தன் தகப்பனிடம், “இவர்கள்தான் இறைவன் எனக்குக் கொடுத்த பிள்ளைகள்” என்றான். அப்பொழுது இஸ்ரயேல் யோசேப்பிடம், “நான் அவர்களை ஆசீர்வதிக்கும்படி அவர்களை என்னிடம் கொண்டுவா” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","வயது சென்றபடியால் இஸ்ரயேலின் கண்பார்வை மங்கியிருந்தது, அதனால் தெளிவாகப் பார்க்க முடியவில்லை. ஆகையால் யோசேப்பு அவர்களை அவனுக்கு அருகில் கொண்டுவந்தான்; யாக்கோபு அவர்களைக் கட்டி அணைத்து முத்தமிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","அதன்பின் இஸ்ரயேல் யோசேப்பிடம், “திரும்பவும் உன் முகத்தைப் பார்ப்பேனென்று நான் ஒருபோதும் எதிர்பார்க்கவில்லை. இப்பொழுதோ இறைவன் நான் உன்னுடைய பிள்ளைகளையும் காணும்படி செய்தாரே” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","யோசேப்பு இஸ்ரயேலின் முழங்கால்கள் நடுவிலிருந்த தன் பிள்ளைகளை விலக்கிவிட்டு செய்து தரைமட்டும் குனிந்து தன் தகப்பனை வணங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","பின்பு யோசேப்பு அவர்கள் இருவரையும் பிடித்து, எப்பிராயீமை தன் வலதுகையினால் இஸ்ரயேலின் இடப்பக்கத்திலும், மனாசேயைத் தன் இடது கையினால் இஸ்ரயேலின் வலதுபக்கத்திலுமாகத் தன் தகப்பன் அருகே கொண்டுவந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","ஆனால் இஸ்ரயேல், தன் இரு கைகளையும் குறுக்காக நீட்டி, எப்பிராயீம் இளையவனாயிருந்தபோதிலும் அவன் தலையின்மேல் தன் வலதுகையை வைத்தான்; மனாசே மூத்தவனாய் இருந்தபோதிலும், அவன் தலையின்மேல் இடதுகையை வைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","அதன்பின் இஸ்ரயேல் யோசேப்பை ஆசீர்வதித்து சொன்னது: “என் தந்தையர்களான ஆபிரகாம், ஈசாக்கு ஆகியோர் வழிபட்ட இறைவனும், என் வாழ்நாள் முழுவதும் இன்றுவரை என் மேய்ப்பராயிருந்த இறைவனும், ");
INSERT INTO tamtcv_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","எல்லா தீங்குகளிலிருந்தும் என்னை விடுவித்த தூதனுமானவர் இந்தப் பிள்ளைகளை ஆசீர்வதிப்பாராக. இவர்கள் என்னுடைய பெயராலும், என் தந்தையர்களான ஆபிரகாமினுடைய, ஈசாக்கினுடைய பெயர்களாலும் அழைக்கப்படுவார்களாக. இவர்கள் பூமியில் மிகுதியாய்ப் பெருகுவார்களாக.” ");
INSERT INTO tamtcv_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","தனது தகப்பன் அவருடைய வலதுகையை எப்பிராயீமுடைய தலையில் வைத்ததை யோசேப்பு கண்டான், அது அவனுக்கு விருப்பமில்லாதிருந்தது; அதனால் எப்பிராயீமுடைய தலையிலிருந்த யாக்கோபின் வலதுகையை மனாசேயின் தலையில் வைப்பதற்காகப் பிடித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","யோசேப்பு தன் தகப்பனிடம், “அப்படியல்ல அப்பா, இவனே என் மூத்த மகன்; இவன் தலைமேல் உங்களுடைய வலதுகையை வையுங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","ஆனால் யாக்கோபோ அப்படிச் செய்ய மறுத்து, “எனக்குத் தெரியும், என் மகனே, எனக்குத் தெரியும். மனாசேயும் ஒரு பெரிய மக்கள் கூட்டமாவான், இவனும் பெரியவனாவான். எனினும் இவனுடைய இளைய சகோதரன் இவனிலும் பெரியவனாவான்; இவனுடைய சந்ததி பெருகி பல நாடுகளின் கூட்டமாகும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","அன்றையதினம் அவன் அவர்களை ஆசீர்வதித்துச் சொன்னது: “ ‘எப்பிராயீம், மனாசேயைப்போல் உங்களையும் இறைவன் பெருகப்பண்ணுவாராக’ என்று இஸ்ரயேலர் உங்கள் பெயரால் ஆசீர்வாதத்தைச் சொல்வார்கள்.” இவ்வாறு அவன் மனாசேயைவிட எப்பிராயீமுக்கு முதலிடம் கொடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","பின்பு இஸ்ரயேல் யோசேப்பிடம், “நான் சாகும் தருவாயில் இருக்கிறேன்; ஆனால் இறைவன் உங்களுடன் இருந்து, அவர் உங்களை உங்கள் முற்பிதாக்களின் நாட்டிற்குத் திரும்பவும் கூட்டிக்கொண்டு போவார். ");
INSERT INTO tamtcv_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","உன் சகோதரருக்கு மேலானவனாக இருக்கிற உனக்கோ, எமோரியரிடமிருந்து நான் வாளினாலும் வில்லினாலும் கைப்பற்றிய மேட்டு நிலத்தைக் கொடுக்கிறேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","பின்பு யாக்கோபு தன் மகன்களைக் கூப்பிட்டு அவர்களிடம் சொன்னதாவது: “நீங்கள் எல்லோரும் என்னைச் சுற்றி நில்லுங்கள், இனிவரப்போகும் நாட்களில் நடக்கப்போவதை நான் உங்களுக்குச் சொல்லப்போகிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“யாக்கோபின் மகன்களே, கூடிவந்து கேளுங்கள்; உங்கள் தகப்பன் இஸ்ரயேல் சொல்வதைக் கேளுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“ரூபன், நீ என் முதற்பேறானவன், நீ வலிமையும் என் பெலனின் முதல் அடையாளமுமானவன், நீ மதிப்பில் சிறந்தவன், நீ வல்லமையிலும் சிறந்தவன். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","தண்ணீரைப்போல் தளம்புகிறவனே, நீ இனிமேல் மேன்மை அடையமாட்டாய்; ஏனெனில், நீ உன்னுடைய தகப்பனின் படுக்கைக்குப்போய், என் கட்டிலைத் தீட்டுப்படுத்தினாய். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“சிமியோனும், லேவியும் சகோதரர்கள். அவர்களின் வாள்கள் வன்முறையின் ஆயுதங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","நான் அவர்களுடைய ஆலோசனைக்கு உடன்படாமலும், அவர்களுடைய கூட்டத்தில் சேராமலும் இருப்பேனாக. ஏனெனில், அவர்கள் தங்கள் கோபத்தினால் மனிதரைக் கொன்றார்கள், தாங்கள் விரும்பியவாறு எருதுகளை முடமாக்கினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","அவர்களுடைய பயங்கரமான கோபமும், கொடூரமான மூர்க்கமும் சபிக்கப்படுவதாக; நான் அவர்களை யாக்கோபிலே பிரியச்செய்து, இஸ்ரயேலிலே சிதறப்பண்ணுவேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“யூதா, உன் சகோதரர் உன்னைப் புகழ்வார்கள்; உன் பகைவர்களின் கழுத்தின்மேல் உன்னுடைய கை இருக்கும்; உன் தகப்பனின் மகன்கள் உன்முன் பணிவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","யூதா, நீ ஒரு சிங்கக்குட்டி; என் மகனே, நீ இரைதின்று திரும்புகிறாய். அவன் சிங்கத்தைப்போலும் பெண் சிங்கத்தைப்போலும் மடங்கிப் படுக்கிறான்; அவனை எழுப்பத் துணிபவன் யார்? ");
INSERT INTO tamtcv_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","செங்கோலுக்குரியவர் வரும்வரை செங்கோல் யூதாவைவிட்டு நீங்காது, ஆளுநரின் கோல் அவனுடைய பாதங்களைவிட்டு விலகாது; நாடுகளின் கீழ்ப்படிதல் அவருக்கே உரியது. ");
INSERT INTO tamtcv_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","அவன் தன் கழுதையை திராட்சைச் செடியிலும், தன் கழுதைக் குட்டியைச் சிறந்த திராட்சைக் கொடியிலும் கட்டுவான்; அவன் தன் உடைகளைத் திராட்சை இரசத்திலும், அங்கிகளைத் திராட்சைப்பழச் சாற்றிலும் கழுவுவான். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","அவனுடைய கண்கள் திராட்சை இரசத்தைவிட கருமையும், பற்கள் பாலைவிட வெண்மையுமாய் இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“செபுலோன் கடற்கரையில் குடியிருந்து, கப்பல் துறைமுகமாய் இருப்பான்; அவனுடைய எல்லை சீதோன்வரை பரந்திருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“இசக்கார் இரண்டு பொதிகளுக்கிடையே படுத்திருக்கும் பலமுள்ள கழுதை. ");
INSERT INTO tamtcv_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","அவன் தன் இளைப்பாறும் இடம் எவ்வளவு நல்லதென்றும், தனது நாடு எத்தகைய மகிழ்ச்சிக்குரியது என்றும் கண்டு, சுமைக்குத் தன் தோளை சாய்ப்பான்; கட்டாய வேலைக்கும் இணங்குவான். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“தாண் இஸ்ரயேலின் கோத்திரங்களில் ஒரு கோத்திரமாயிருந்து, தன் மக்களுக்கு நீதி வழங்குவான். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","தாண், குதிரைமீது போகிறவன் இடறிவிழும்படி பாதையோரம் கிடந்து, குதிரைகளின் குதிங்காலைக் கடிக்கிற பாம்பைப்போலவும், வழியிலே கிடக்கும் விரியன் பாம்பைப்போலவும் இருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“யெகோவாவே, நான் உம்முடைய மீட்புக்காகக் காத்திருக்கிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“காத் கொள்ளைக் கூட்டத்தாரால் தாக்கப்படுவான், ஆனாலும் இறுதியில் அவன் அவர்களைத் தாக்குவான். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“ஆசேருடைய உணவு கொழுமையானதாய் இருக்கும்; அரசனுக்குத் தகுந்த சுவையான உணவை அவன் கொடுப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“நப்தலி அழகான குட்டிகளை ஈனும் விடுதலை பெற்ற பெண்மான். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“யோசேப்பு கனிதரும் செடி; அவன் நீரூற்றருகில் கனிதரும் திராட்சைக்கொடி. அவனுடைய கிளைகள், மதில்களில் ஓங்கி வளரும். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","வில்வீரர் அவனைக் கொடூரமாகத் தாக்கினார்கள்; பகைமையுடன் அவன்மேல் எய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ஆனால், அவனுடைய வில் உறுதியாய் நின்றது; அவனுடைய பெலமுள்ள புயங்கள் சுறுசுறுப்பாயிருந்தன; யாக்கோபின் வல்லவரின் கரத்தினாலும், மேய்ப்பராலும், இஸ்ரயேலுடைய கற்பாறையாலும், ");
INSERT INTO tamtcv_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","உனக்கு உதவிசெய்யும் உன் தகப்பனின் இறைவனாலும் இப்படியாகும். அவர் மேலேயுள்ள வானங்களின் ஆசீர்வாதங்களினாலும், கீழேயுள்ள ஆழங்களின் ஆசீர்வாதங்களினாலும், மார்பகங்களின், கருப்பையின் ஆசீர்வாதங்களினாலும் உன்னை ஆசீர்வதிக்கும் எல்லாம் வல்லவராய் இருக்கிறார். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","உன் தகப்பனின் ஆசீர்வாதங்கள் நித்திய மலைகளின் ஆசீர்வாதங்களைப் பார்க்கிலும், பழைமை வாய்ந்த குன்றுகளின் செழிப்பைப் பார்க்கிலும் பெரிதானவை. இவைகளெல்லாம் யோசேப்பின் தலையின்மேலும், தன் சகோதரருக்குள் பிரபுவாய் இருக்கிறவனின் நெற்றியிலும் தங்குவதாக. ");
INSERT INTO tamtcv_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“பென்யமீன் ஒரு பீறுகிற ஓநாய்; காலையில் தன் இரையைப் பேராவலுடன் பட்சிப்பான். மாலையில் தான் கொள்ளையிட்டதைப் பங்கிடுவான்.” ");
INSERT INTO tamtcv_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","இஸ்ரயேலின் பன்னிரு கோத்திரங்களும் இவர்களே, அவர்களுடைய தகப்பன் அவனவனுக்குத் தகுந்த ஆசீர்வாதங்களைச் சொல்லி, அவர்களை ஆசீர்வதிக்கும்போது சொன்னவை இவையே. ");
INSERT INTO tamtcv_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","பின்பு அவன் அவர்களுக்கு அறிவுறுத்திச் சொன்னதாவது: “நான் என் முன்னோர்களுடன் சேர்த்துக்கொள்ளப்படப் போகிறேன். ஏத்தியனான எப்ரோனிடமிருந்து வாங்கிய நிலத்திலே, என் தந்தையர்களை அடக்கம்பண்ணிய குகையிலேயே என்னையும் அடக்கம்பண்ணுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","அந்தக் குகை கானானிலுள்ள மம்ரேக்கு அருகில் மக்பேலா என்னும் வயல்வெளியில் இருக்கிறது; ஆபிரகாம் அதை ஏத்தியனான எப்ரோனிடமிருந்து வயலையும் சேர்த்து கல்லறை நிலமாக வாங்கினார். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","அங்கேயே ஆபிரகாமும் அவர் மனைவி சாராளும், ஈசாக்கும் அவர் மனைவி ரெபெக்காளும் அடக்கம்பண்ணப்பட்டார்கள்; என் மனைவி லேயாளையும் நான் அங்கேயே அடக்கம்பண்ணினேன். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","அந்த நிலமும் குகையும் ஏத்தியரிடமிருந்து வாங்கப்பட்டவை” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","யாக்கோபு தன் மகன்களுக்கு அறிவுரை கூறிமுடித்ததும், அவன் தன் கால்களைக் கட்டிலின்மேல் தூக்கிவைத்து, இறுதி மூச்சை விட்டான். இவ்வாறு அவன் தனது முன்னோருடன் சேர்க்கப்பட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","அப்பொழுது யோசேப்பு தன் தகப்பனது உடலின்மேல் விழுந்து அழுது, அவனை முத்தமிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","பின்பு யோசேப்பு தன் தகப்பனான இஸ்ரயேலின் உடலை நறுமணமிட்டுப் பக்குவப்படுத்தும்படி, தன் சேவையிலிருந்த வைத்தியர்களுக்குக் கட்டளையிட்டான். வைத்தியர்கள் அப்படியே செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","இவ்வாறு நறுமணமிட்டு உடலைப் பதப்படுத்துவதற்கு நாற்பது நாட்கள்வரை செல்லும். எகிப்தியர் யாக்கோபுக்காக எழுபது நாட்கள் துக்கங்கொண்டாடினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","துக்ககாலம் முடிந்தபின் யோசேப்பு பார்வோனின் அரண்மனையிலிருந்து வந்தவர்களிடம், “உங்கள் கண்களில் எனக்குத் தயவு கிடைக்குமானால் நீங்கள் பார்வோனிடம் எனக்காக ஒரு விண்ணப்பம் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","என் தகப்பன் என்னிடம், ‘நான் சாகப்போகிறேன். கானானில் நான் வெட்டி வைத்திருக்கும் என்னுடைய கல்லறையிலேயே என்னை அடக்கம்பண்ணவேண்டும்’ என்று சத்தியம் வாங்கியிருந்தார். ஆகவே, இப்பொழுது நான் போய், என் தகப்பனை அடக்கம்பண்ணித் திரும்பிவர எனக்கு அனுமதி கொடுக்கும்படி கேளுங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","பார்வோன், “உன் தகப்பன் உன்னிடம் சத்தியம் வாங்கியபடி, நீ போய் உன் தகப்பனை அடக்கம் செய்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","எனவே யோசேப்பு தன் தகப்பனை அடக்கம் செய்யப்போனான். அவனுடன் பார்வோனுடைய அரண்மனைப் பெரியவர்களும், எகிப்திலுள்ள பெரியோர்களுமான எல்லா அலுவலர்களும் போனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","அவர்களோடு யோசேப்பின் வீட்டாரும், அவனுடைய சகோதரரும், அவன் தகப்பன் வீட்டாரும் போனார்கள். அவர்களுடைய பிள்ளைகளையும், ஆட்டுமந்தைகளையும், மாட்டு மந்தைகளையும் மாத்திரம் கோசேனிலே விட்டுச் சென்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","தேர்களுடன் குதிரைவீரர்களும் அவர்களோடு போனார்கள். அது மிகப்பெரிய ஒரு கூட்டமாய் இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","அவர்கள் யோர்தானுக்கு அப்பாலுள்ள ஆதாத் என்னும் சூடடிக்கும் களத்தை அடைந்தபோது, மனங்கசந்து சத்தமிட்டு அழுதார்கள். அங்கே யோசேப்பு தன் தகப்பனுக்காக ஏழு நாட்கள் துக்கங்கொண்டாடினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","ஆதாத்தின் சூடடிக்கும் களத்தில் அவர்கள் துக்கங்கொண்டாடுவதை அங்கு வாழ்ந்த கானானியர் கண்டபோது, “இங்கே எகிப்தியர் பெரிய துக்கங்கொண்டாடலை நடத்துகிறார்கள்” என்றார்கள். அதினாலேயே யோர்தானுக்கு அருகிலுள்ள அந்த இடத்திற்கு ஆபேல் மிஸ்ராயீம் என்ற பெயர் உண்டாயிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","யாக்கோபு தங்களுக்குக் கட்டளையிட்டபடியே அவனுடைய மகன்கள் செய்தார்கள்: ");
INSERT INTO tamtcv_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","அவனுடைய உடலைக் கானான் நாட்டிற்குக் கொண்டுபோய், அங்கே மம்ரேக்கு அருகிலிருக்கும் மக்பேலா வெளியிலுள்ள குகையிலே அடக்கம் செய்தார்கள்; ஆபிரகாம் அந்த நிலத்தை வயலுடன் சேர்த்து, ஏத்தியனான எப்ரோனிடமிருந்து கல்லறை நிலமாக வாங்கியிருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","யோசேப்பு தன் தகப்பனை அடக்கம் செய்தபின், தன் சகோதரரோடும், தன் தகப்பனை அடக்கம் செய்வதற்காக அவனுடன் வந்திருந்த மற்ற எல்லாரோடும் எகிப்திற்குத் திரும்பிப்போனான். ");
INSERT INTO tamtcv_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","தங்கள் தகப்பன் மரணமடைந்தபின் யோசேப்பின் சகோதரர், “யோசேப்பு எங்கள்மேல் பழிவாங்க எண்ணங்கொண்டு, முன்பு நாம் யோசேப்புக்குச் செய்த எல்லாத் தீமைகளுக்காக தீங்கு செய்தால் என்ன செய்வது?” என்று ஒருவரோடொருவர் பேசிக்கொண்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","அதனால் அவர்கள் யோசேப்பிடம், “உம்முடைய தகப்பன் இறப்பதற்குமுன் இந்த அறிவுறுத்தல்களைக் கொடுத்தார். ");
INSERT INTO tamtcv_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","அதாவது, நீங்கள் யோசேப்பிடம் போய் நான் இப்படிச் சொன்னதாகச் சொல்லுங்கள். உன் சகோதரரின் பாவங்களையும், அவர்கள் உன்னைக் கொடுமையாக நடத்தியதன் மூலம் அவர்கள் உனக்குச் செய்த அநியாயங்களையும் நீ அவர்களுக்கு மன்னிக்க வேண்டும் என, நான் கேட்டுக்கொள்கிறேன் என்றார்” என்றார்கள். “உமது தகப்பனுடைய இறைவனின் அடியாராகிய நாங்கள் செய்த பாவங்களை இப்பொழுது எங்களுக்குத் தயவாய் மன்னியும்” என்று செய்தி அனுப்பினார்கள். அச்செய்தி யோசேப்புக்குக் கிடைத்ததும் அவன் அழுதான். ");
INSERT INTO tamtcv_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","யோசேப்பின் சகோதரர் அவனிடம் வந்து, அவனுக்கு முன்பாகத் தரையில் முகங்குப்புற விழுந்து வணங்கி, “நாங்கள் உமது அடிமைகள்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","யோசேப்பு அவர்களிடம், “பயப்படவேண்டாம்; நான் என்ன இறைவனா? ");
INSERT INTO tamtcv_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","நீங்கள் எனக்குத் தீமைசெய்ய எண்ணம் கொண்டீர்கள். ஆனால், இறைவனோ இப்பொழுது நடந்து வருகிறபடியே, பல உயிர்களைக் காக்கும் நோக்கத்தை நிறைவேற்றுவதற்காக, அதை நன்மையாக மாற்றினார். ");
INSERT INTO tamtcv_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ஆகையால் பயப்படவேண்டாம். உங்களுக்கும் உங்கள் பிள்ளைகளுக்கும் தேவையானவற்றை எல்லாம் நான் கொடுப்பேன்” என உறுதியளித்துத் தயவாகப் பேசினான். ");
INSERT INTO tamtcv_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","யோசேப்பு தன் தகப்பனின் குடும்பத்தார் எல்லோருடனும் எகிப்தில் வாழ்ந்து வந்தான். அவன் நூற்றுப்பத்து வயதுவரை உயிர் வாழ்ந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","யோசேப்பு, எப்பிராயீமின் பிள்ளைகளுடைய மூன்றாம் தலைமுறையையும் கண்டான். அப்பிள்ளைகள் எல்லோரும், மனாசேயின் மகன் மாகீரின் பிள்ளைகளும் யோசேப்பின் மடியிலே வளர்ந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","பின்பு யோசேப்பு தன் சகோதரரிடம், “எனக்கு மரணம் நெருங்கிவிட்டது. இறைவன் உங்களுக்கு நிச்சயமாய் உதவி செய்வார்; ஆபிரகாமுக்கும், ஈசாக்குக்கும், யாக்கோபுக்கும் வாக்குப்பண்ணப்பட்டிருக்கும் நாட்டுக்கு அவர் உங்களை இவ்விடத்திலிருந்து கொண்டுபோவார்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","பின்னும் யோசேப்பு அவர்களிடம், “நிச்சயமாய் இறைவன் உங்களுக்கு உதவி செய்வார். அப்பொழுது நீங்கள் என்னுடைய எலும்புகளை இவ்விடத்திலிருந்து எடுத்துக்கொண்டு போகவேண்டும்” என்று இஸ்ரயேலின் மகன்களிடம் சத்தியம் பெற்றுக்கொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","யோசேப்பு தனது நூற்றுப்பத்தாம் வயதில் மரணமடைந்தான். அவனுடைய உடல் நறுமணப்பொருட்களால் பதப்படுத்தப்பட்டு, எகிப்திலே ஒரு சவப்பெட்டிக்குள் வைக்கப்பட்டது.");
INSERT INTO tamtcv_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","யாக்கோபுடனும் அவனுடைய குடும்பங்களுடனும் எகிப்திற்குப்போன இஸ்ரயேலுடைய மகன்களின் பெயர்களாவன: ");
INSERT INTO tamtcv_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","ரூபன், சிமியோன், லேவி, யூதா, ");
INSERT INTO tamtcv_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","இசக்கார், செபுலோன், பென்யமீன், ");
INSERT INTO tamtcv_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","தாண், நப்தலி, காத், ஆசேர். ");
INSERT INTO tamtcv_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","யாக்கோபின் சந்ததிகள் மொத்தம் எழுபதுபேர். யோசேப்பு ஏற்கெனவே எகிப்தில் இருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","இப்பொழுது யோசேப்பும், அவனுடைய சகோதரர்கள் எல்லோரும், அந்த தலைமுறையினர் யாவரும் இறந்துபோனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","இஸ்ரயேல் என அழைக்கப்பட்ட, யாக்கோபின் சந்ததிகள் வளம்பெற்று, அதிகமாய்ப் பெருகினார்கள்; நாடு அவர்களால் நிரம்பும் அளவுக்கு அவர்கள் எண்ணிக்கையில் மிகவும் பெருகினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","பின்பு யோசேப்பைப்பற்றி அறியாத ஒரு புதிய அரசன் எகிப்தில் ஆட்சிக்கு வந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","அவன் தன் மக்களிடம், “பாருங்கள், இஸ்ரயேலரோ நம்மைவிட எண்ணிக்கையில் அதிகமாயும், பலமுள்ளவர்களுமாய் இருக்கிறார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","வாருங்கள், நாம் அவர்களுடன் விவேகமாய் நடந்துகொள்ள வேண்டும், இல்லையென்றால் அவர்கள் இன்னும் எண்ணிக்கையில் அதிகமாய்ப் பெருகிவிடுவார்கள், யுத்தம் ஒன்று உண்டானால் அவர்கள் நம் பகைவர்களோடு சேர்ந்து, நமக்கு விரோதமாகப் போரிட்டு நாட்டைவிட்டுப் போய்விடுவார்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","எனவே இஸ்ரயேலர்களைக் கட்டாய வேலைக்கு உட்படுத்தி ஒடுக்குவதற்கு, அடிமைகளை நடத்தும் அதிகாரிகளை அவர்களுக்கு மேலாக நியமித்தார்கள்; இவ்வாறு அவர்கள் பித்தோம், ராமசேஸ் என்னும் களஞ்சியப் பட்டணங்களைப் பார்வோனுக்காகக் கட்டினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","ஆனால் இஸ்ரயேலர் எவ்வளவு அதிகமாய் ஒடுக்கப்பட்டார்களோ, அவ்வளவு அதிகமாய் அவர்கள் பெருகிப் பரவினார்கள்; இதனால் எகிப்தியர் இஸ்ரயேலர்களுக்குப் பயந்து, ");
INSERT INTO tamtcv_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","அவர்கள் இஸ்ரயேலரைக் கொடூரமாய் நடத்தி வேலை வாங்கினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","செங்கல்லும் சாந்தும் செய்யும் கடினமான வேலைகளினாலும், வயல்களில் செய்யும் எல்லா விதமான வேலைகளினாலும், எகிப்தியர் அவர்களுடைய வாழ்க்கையைக் கசப்பாக்கினார்கள்; இரக்கமின்றி அவர்களுடைய எல்லாக் கடின வேலைகளிலும் அவர்களைக் கொடூரமாய் நடத்தினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","எகிப்திய அரசன், சிப்பிராள், பூவாள் என்னும் எபிரெய மருத்துவச்சிகளிடம், ");
INSERT INTO tamtcv_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“எபிரெய பெண்களின் பிரசவ நேரத்தில் அவர்கள் மணையின்மேல் இருக்கையில் நீங்கள் பார்த்து, பிறக்கும் பிள்ளை ஆண் குழந்தையானால், அதைக் கொன்றுபோடுங்கள்; பெண் குழந்தையானால் அதை வாழவிடுங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","ஆனாலும் மருத்துவச்சிகளோ இறைவனுக்குப் பயந்து, எகிப்திய அரசன் தங்களுக்குச் செய்யச் சொல்லியிருந்ததைச் செய்யவில்லை; அவர்கள் ஆண்பிள்ளைகளையும் வாழவிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","இதை அறிந்த எகிப்திய அரசன் மருத்துவச்சிகளை அழைப்பித்து, “நீங்கள் ஏன் இதைச் செய்தீர்கள்? ஆண் பிள்ளைகளை ஏன் வாழ விட்டிருக்கிறீர்கள்?” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","மருத்துவச்சிகள் பார்வோனுக்குப் பதிலளித்து, “எபிரெய பெண்கள் எகிப்திய பெண்களைப் போன்றவர்களல்ல; அவர்கள் பலமுள்ளவர்கள், அதனால் மருத்துவச்சிகள் வந்து சேருமுன்பே அவர்கள் குழந்தைகளைப் பெற்றுவிடுகிறார்கள்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","இறைவன் மருத்துவச்சிகளுக்குத் தயவு காட்டினார்; இஸ்ரயேல் மக்கள் பெருகி எண்ணிக்கையில் இன்னும் அதிகரித்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","மருத்துவச்சிகள் இறைவனுக்குப் பயந்தபடியால், அவர் அவர்களுடைய சொந்தக் குடும்பங்களை விருத்தியடையச் செய்தார். ");
INSERT INTO tamtcv_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","பின்பு பார்வோன் தன் மக்கள் எல்லோருக்கும் கட்டளை கொடுத்து, “எபிரெயருக்குப் பிறக்கும் ஒவ்வொரு ஆண் குழந்தையையும் நீங்கள் நைல் நதியில் எறிந்துவிடவேண்டும்; ஆனால், எல்லா பெண் குழந்தைகளையும் வாழவிடுங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","லேவி வம்சத்திலுள்ள ஒரு மனிதன் ஒரு லேவியப் பெண்ணைத் திருமணம் செய்திருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","அவள் கர்ப்பவதியாகி ஒரு மகனைப் பெற்றாள்; அவன் ஒரு அழகான குழந்தையென அவள் கண்டபோது, அவனை மூன்று மாதங்களாக ஒளித்து வைத்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","ஆனால் அதற்கு மேலும் அவனை மறைத்துவைக்க முடியாமல், அவள் ஒரு நாணல் பெட்டியை எடுத்து அதற்கு தார் மற்றும் நிலக்கீல் பூசினாள். குழந்தையை அதற்குள் கிடத்தி, நைல் நதியோரமாக நாணலுக்குள்ளே வைத்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","அந்த குழந்தையின் சகோதரி அதற்கு என்ன நடக்குமென அறியும்படி, தூரத்திலே நின்று பார்த்துக்கொண்டிருந்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","அப்பொழுது பார்வோனின் மகள் குளிப்பதற்காக நைல் நதிக்குப் போனாள்; அவளுடன் வந்த தோழியர்கள் நதிக்கரையில் உலாவினார்கள். பார்வோனின் மகள், நாணல்களுக்கிடையில் கிடந்த கூடையைக் கண்டு, அதை எடுத்துவரும்படி தன் வேலைக்காரப் பெண்ணை அனுப்பினாள். ");
INSERT INTO tamtcv_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","அவள் அக்கூடையைத் திறந்தபோது, ஒரு குழந்தையைக் கண்டாள். அது அழுது கொண்டிருந்தது, அவள் அக்குழந்தைமேல் அனுதாபப்பட்டாள். அவள், “இது எபிரெயக் குழந்தைகளில் ஒன்று” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","அந்நேரத்தில் அங்கு வந்த குழந்தையின் சகோதரி பார்வோனின் மகளிடம், “உமக்காக இந்தப் பிள்ளைக்குப் பால்கொடுத்து வளர்க்க, எபிரெயப் பெண்களில் ஒருத்தியை போய்க்கூட்டிக்கொண்டு வரட்டுமா?” என்று கேட்டாள். ");
INSERT INTO tamtcv_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","அதற்குப் பார்வோனின் மகள், “ஆம், போய் அழைத்து வா” என்றாள். அவள் உடனேபோய் குழந்தையின் தாயையே அழைத்து வந்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","பார்வோனின் மகள் அவளிடம், “இக்குழந்தையை எடுத்துக்கொண்டுபோய் அதை எனக்காகப் பாலூட்டி வளர்த்து வா; நான் உனக்குச் சம்பளம் கொடுப்பேன்” என்றாள். எனவே அப்பெண் அவனைக் கொண்டுபோய்ப் பாலூட்டி வளர்த்தாள். ");
INSERT INTO tamtcv_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","குழந்தை வளர்ந்து பெரியவனானபோது, அவன் தாய் அவனைப் பார்வோனின் மகளிடம் ஒப்படைத்தாள்; அவன் அவளுடைய மகனானான். பார்வோனின் மகள் இவனை நான் தண்ணீரிலிருந்து எடுத்தேன் என்று சொல்லி, அவனுக்கு மோசே என்று பெயரிட்டாள். ");
INSERT INTO tamtcv_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","மோசே வளர்ந்தபின் ஒரு நாள், தன் சொந்த எபிரெய மக்கள் இருக்கும் இடத்திற்குப் போய், அங்கு அவர்கள் கடினமான வேலைசெய்வதைப் பார்த்தான். அவன் தன் சொந்த மக்களில் ஒருவனான ஒரு எபிரெயனை ஒரு எகிப்தியன் அடிப்பதையும் கண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","அவன் இங்கும் அங்கும் சுற்றி பார்த்துவிட்டு, ஒருவரையும் காணாததினால், அந்த எகிப்தியனைக் கொன்று மணலில் புதைத்துவிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","மோசே மறுநாளும் வெளியே போனபோது, எபிரெயர் இருவர் சண்டையிடுவதைக் கண்டான். அப்பொழுது அவன் தவறு செய்தவனிடம், “நீ உன் சகோதரனான எபிரெயனை ஏன் அடிக்கிறாய்?” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","அதற்கு அந்த மனிதன், “எங்களுக்கு மேலாக உன்னை அதிகாரியாகவும் நீதிபதியாகவும் ஏற்படுத்தியது யார்? நீ அந்த எகிப்தியனைக் கொன்றதுபோல, என்னையும் கொல்ல நினைக்கிறாயோ?” என்று கேட்டான். மோசே, “நான் செய்தது மற்றவர்களுக்குத் தெரிந்துவிட்டதே” என்று அறிந்து பயந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","பார்வோன் இதைப்பற்றி கேள்விப்பட்டதும் மோசேயைக் கொலைசெய்ய முயன்றான்; ஆனால் மோசே பார்வோனிடம் இருந்து தப்பியோடி, மீதியானில் வாழும்படி போய், அங்கே ஒரு கிணற்றருகே உட்கார்ந்திருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","மீதியானிலுள்ள ஒரு ஆசாரியருக்கு ஏழு மகள்கள் இருந்தனர்; அவர்கள் தங்கள் தகப்பனின் மந்தைகளுக்குத் தண்ணீர் கொடுக்கும்படி தண்ணீரை எடுத்துத் தொட்டிகளை நிரப்புவதற்காக அங்கே வந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","அப்பொழுது சில மேய்ப்பர்கள் அங்கே வந்து அவர்களைத் துரத்தினார்கள். மோசே எழுந்துவந்து, அவர்களைக் காப்பாற்றி அவர்களுடைய மந்தைக்குத் தண்ணீர் அள்ளிக்கொடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","அப்பெண்கள் தங்கள் தகப்பனாகிய ரெகுயேலிடம் வந்தபோது, அவன் அவர்களிடம், “ஏன் இன்றைக்கு இவ்வளவு சீக்கிரம் வந்துவிட்டீர்கள்” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","அதற்கு அவர்கள், “எகிப்தியன் ஒருவன் எங்களை மேய்ப்பரிடமிருந்து காப்பாற்றினான்; அவன் எங்களுக்காகத் தண்ணீரும் அள்ளி, எங்கள் மந்தைக்கும் தண்ணீர் கொடுத்தான்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","அப்பொழுது அவன் தன் மகள்களிடம், “அவன் எங்கே? ஏன் அவனை விட்டுவிட்டு வந்தீர்கள்?” என்று கேட்டு, “ஏதாவது சாப்பிடும்படி அவனை இங்கே அழைத்து வாருங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","மோசே அந்த மனிதனுடன் தங்கியிருப்பதற்குச் சம்மதித்தான்; சிறிது காலத்தின்பின் அவன் தன் மகள் சிப்போராளை மோசேக்கு திருமணம் செய்துகொடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","சிப்போராள் ஒரு மகனைப் பெற்றாள். அப்பொழுது மோசே, “நான் வேற்று நாட்டில் பிறநாட்டினனாய் இருக்கிறேன்” என்று சொல்லி அவனுக்கு கெர்சோம் என்று பெயரிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","அந்த நீண்ட காலப்பகுதிக்குள் எகிப்திய அரசன் இறந்தான்; இஸ்ரயேலர் தங்கள் அடிமைத்தனத்தில் வேதனைப்பட்டுக் கதறினார்கள். தங்கள் அடிமைத்தனத்தின் நிமித்தம் உதவிவேண்டிய அவர்களுடைய அழுகுரல் இறைவனுக்கு எட்டியது. ");
INSERT INTO tamtcv_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","இறைவன் அவர்களுடைய அழுகையைக் கேட்டார், ஆபிரகாமுடனும் ஈசாக்குடனும் யாக்கோபுடனும் தான் செய்துகொண்ட உடன்படிக்கையை நினைவுகூர்ந்தார். ");
INSERT INTO tamtcv_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","எனவே இறைவன் இஸ்ரயேலரின் பரிதாப நிலையைக் கண்டு, அவர்களைக் குறித்துக் கரிசனைகொண்டார். ");
INSERT INTO tamtcv_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","மோசே மீதியான் நாட்டு ஆசாரியரான தன் மாமன் எத்திரோவின் ஆடுகளை மேய்த்துக்கொண்டிருந்தான்; ஒரு நாள் அவன் மந்தையை ஓட்டிக்கொண்டு பாலைவனத்தின் தூரமான பகுதிக்கு, ஓரேப் என்னும் இறைவனின் மலைக்கு வந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","அப்பொழுது அங்கே புதரிலிருந்து வந்த ஒரு அக்கினி ஜூவாலையில், யெகோவாவின் தூதனானவர் அவனுக்குக் காட்சியளித்தார்; அந்தப் புதரில் நெருப்பு பற்றியிருந்தும் எரிந்து போகாதிருந்ததை மோசே கண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","எனவே மோசே, “புதர் எரிந்து போகாதிருக்கும் இந்த ஆச்சரியமான காட்சியை நான் போய்ப்பார்ப்பேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","அவன் அதைப் பார்ப்பதற்காக அங்கு போயிருந்ததை யெகோவா கண்டபோது, இறைவன் புதரின் நடுவிலிருந்து, “மோசே! மோசே!” என்று அவனைக் கூப்பிட்டார். அதற்கு அவன், “இதோ நான் இருக்கிறேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","இறைவன் அவனிடம், “இதற்குமேல் நெருங்கி வராதே, உன் காலிலுள்ள செருப்பைக் கழற்றிப்போடு; நீ நிற்கின்ற இந்த இடம் பரிசுத்தமான நிலமாய் இருக்கிறது” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","மேலும் அவர், “நான் உன் முற்பிதாக்களின் இறைவனாகிய ஆபிரகாமின் இறைவன், ஈசாக்கின் இறைவன், யாக்கோபின் இறைவன்” என்றார். அதைக் கேட்டதும் மோசே இறைவனைப் பார்க்கப் பயந்ததினால், தன் முகத்தை மூடிக்கொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","பின்னும் யெகோவா, “எகிப்தில் என் மக்களின் துன்பத்தை நான் உண்மையாகவே கண்டேன்; அடிமைகளை நடத்தும் கண்காணிகளின் நிமித்தம் அவர்கள் அழுவதைக் கேட்டேன்; அவர்களுடைய துன்பங்களைக்குறித்து கரிசனையாயிருக்கிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","அதனால் அவர்களை எகிப்தியரின் கையிலிருந்து விடுவித்து, அந்த நாட்டிலிருந்து அவர்களை வெளியே கொண்டுவரவே வந்திருக்கிறேன்; அவர்களைப் பாலும் தேனும் வழிந்தோடுகிற, நலமும் விசாலமுமான நாட்டுக்குக் கொண்டுபோய்ச் சேர்ப்பேன். அந்நாடு கானானியர், ஏத்தியர், எமோரியர், பெரிசியர், ஏவியர், எபூசியர் ஆகியோர் வாழும் நாடாகும். ");
INSERT INTO tamtcv_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","இப்பொழுதும் இஸ்ரயேலரின் அழுகுரல் எனக்கு எட்டியிருக்கிறது; எகிப்தியர் அவர்களை ஒடுக்கும் விதத்தைக் கண்டிருக்கிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ஆகையால் நீ இப்பொழுதே போ. நான் என் மக்களான இஸ்ரயேலரை எகிப்திலிருந்து வெளியே கொண்டுவருவதற்கு உன்னைப் பார்வோனிடம் அனுப்புகிறேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","ஆனால் மோசேயோ இறைவனிடம், “பார்வோனிடம் போய், இஸ்ரயேலரை எகிப்திலிருந்து வெளியே கொண்டுவருவதற்கு நான் யார்?” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","அதற்கு இறைவன், “நான் உன்னோடு இருப்பேன். நானே உன்னை அனுப்பினேன் என்பதற்கு இதுவே உனக்கு அடையாளம்: நீ எகிப்திலிருந்து மக்களை வெளியே கொண்டுவந்ததும் நீங்கள் இந்த மலையிலேயே இறைவனை வழிபடுவீர்கள்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","அப்பொழுது மோசே இறைவனிடம், “நான் இஸ்ரயேலரிடம் போய், ‘உங்கள் முற்பிதாக்களின் இறைவன் என்னை உங்களிடம் அனுப்பியிருக்கிறார்’ என்று சொன்னால், அவர்கள் என்னிடம், ‘அவருடைய பெயர் என்ன?’ என்று கேட்பார்கள். அப்பொழுது நான் அவர்களுக்கு என்ன பதில் சொல்வேன்?” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","அதற்கு இறைவன் மோசேயிடம், “நானே என்றென்றும் இருக்கின்ற அவர்” என்றார். “நீ இஸ்ரயேல் மக்களிடம் சொல்லவேண்டியதாவது: ‘என்றென்றும் இருக்கின்ற அவர் என்னை உங்களிடம் அனுப்பினார்.’ ” ");
INSERT INTO tamtcv_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","மேலும் இறைவன் மோசேயிடம், “ ‘ஆபிரகாமின் இறைவனும், ஈசாக்கின் இறைவனும், யாக்கோபின் இறைவனுமான உங்கள் முற்பிதாக்களின் இறைவனாகிய யெகோவா, என்னை உங்களிடம் அனுப்பியிருக்கிறார்’ என்று இஸ்ரயேல் மக்களுக்குச் சொல்” என்றார். “இதுவே என்றென்றும் என் பெயராய் இருக்கிறது, இந்தப் பெயராலேயே நான் தலைமுறை தலைமுறையாக அழைக்கப்பட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“நீ போய், இஸ்ரயேலின் சபைத்தலைவர்களைக் கூட்டி அவர்களிடம், ‘ஆபிரகாம், ஈசாக்கு, யாக்கோபு ஆகியோரின் இறைவனான, உங்கள் முற்பிதாக்களின் இறைவனாகிய யெகோவா எனக்குக் காட்சியளித்துச் சொன்னதாவது: நான் உங்களில் கண்ணோக்கமாயிருந்து, எகிப்தில் உங்களுக்கு செய்யப்பட்டதைக் கண்டேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","உங்களை எகிப்திலுள்ள அவலத்திலிருந்து விடுவித்து, கானானியர், ஏத்தியர், எமோரியர், பெரிசியர், ஏவியர், எபூசியர் என்பவர்களின் நாடான, பாலும் தேனும் நிரம்பிவழியும் செழிப்புள்ள நாட்டிற்குக் கொண்டுவருவதாக வாக்குத்தத்தம் பண்ணியிருக்கிறேன்’ என்று சொல். ");
INSERT INTO tamtcv_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“இஸ்ரயேலருடைய சபைத்தலைவர்கள் உனக்குச் செவிகொடுப்பார்கள். அதன்பின் நீயும் சபைத்தலைவர்களும் எகிப்தின் அரசனிடம் போய், ‘எபிரெயரின் இறைவனாகிய யெகோவா எங்களைச் சந்தித்திருக்கிறார். இறைவனாகிய யெகோவாவுக்குப் பலிகளை செலுத்துவதற்கு நாங்கள் மூன்று நாட்கள் பயணம் செய்து, பாலைவனத்துக்குப்போக எங்களுக்கு அனுமதி தாரும்’ என்று சொல்லுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","ஆனால் வல்லமையான ஒரு கரம் எகிப்தின் அரசனைப் பலவந்தப்படுத்தினால் ஒழிய, அவன் உங்களைப் போகவிடமாட்டான் என்று எனக்குத் தெரியும். ");
INSERT INTO tamtcv_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","ஆதலால் நான் என் கரத்தை நீட்டி, எகிப்தியர் மத்தியில் செய்யப்போகும் எல்லா விதமான அதிசய செயல்களினால் அவர்களை வாதிப்பேன். அதன்பின் அவன் உங்களைப் போகவிடுவான். ");
INSERT INTO tamtcv_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“எகிப்தியர்கள் இந்த இஸ்ரயேல் மக்களுக்குத் தயவுகாட்டும்படி நான் செய்வேன்; அதனால் நீங்கள் புறப்பட்டுப் போகும்போது, வெறுங்கையுடன் போகமாட்டீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","ஒவ்வொரு பெண்ணும் தன் அண்டை வீட்டாரிடமும், தன் வீட்டில் தங்கியிருக்கும் அந்நியப் பெண்ணிடமும் வெள்ளி நகைகளையும், தங்க நகைகளையும் உடைகளையும் கேட்டு வாங்கவேண்டும்; அவற்றை உங்கள் மகன்களுக்கும் மகள்களுக்கும் அணிவிக்கவேண்டும். இவ்வாறு நீங்கள் எகிப்தியரைக் கொள்ளையிடுவீர்கள்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","மோசே மறுமொழியாக, “அவர்கள் என்னை நம்பாமலும், நான் சொல்லும் வார்த்தைகளைக் கேளாமலும், ‘யெகோவா உனக்கு காட்சி அளிக்கவில்லை’ என்று சொல்வார்களானால் நான் என்ன செய்வேன்?” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","அதற்கு யெகோவா அவனிடம், “உன் கையில் இருப்பது என்ன?” என்று கேட்டார். “ஒரு கோல்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","“அதைத் தரையில் எறிந்துவிடு” என்று யெகோவா சொன்னார். மோசே அதைத் தரையில் எறிந்தபோது அது பாம்பாக மாறியது, மோசே விலகி ஓடினான். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","அப்பொழுது யெகோவா, “உன் கையை நீட்டி அதன் வாலைப் பிடித்துத் தூக்கு” என்று சொன்னார். மோசே கையை நீட்டி பாம்பைப் பிடித்தான்; அது அவன் கையில் கோலாக மாறியது. ");
INSERT INTO tamtcv_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“ஆபிரகாமின் இறைவனும், ஈசாக்கின் இறைவனும், யாக்கோபின் இறைவனுமான அவர்களின் முற்பிதாக்களின் இறைவனாகிய யெகோவா, உனக்கு காட்சியளித்திருக்கிறார் என்பதை அவர்கள் நம்பும்படி இதுவே அடையாளம்” என்று யெகோவா சொன்னார். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","மேலும் யெகோவா மோசேயிடம், “உன் கையை உன் மேலங்கியினுள் வை” என்றார். எனவே மோசே தன் கையை மேலங்கிக்குள் வைத்தான்; அவன் அதை வெளியே எடுத்தபோது, அவனுடைய கை உறைபனியைப்போல் குஷ்டமாகியிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","“இப்பொழுது திரும்ப உனது கையை மேலங்கிக்குள் வை” என்றார். அப்படியே மோசே, மறுபடியும் அங்கிக்குள் கையை வைத்தான். திரும்பவும் கையை வெளியே எடுத்தபோது, அது சுகமடைந்து உடலின் மற்ற பகுதிகளைப்போல் மாறினது. ");
INSERT INTO tamtcv_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","பின்பு யெகோவா, “அவர்கள் உன்னை நம்பாமல் அல்லது முதல் அற்புத அடையாளத்தைக் கவனிக்காமல் விட்டிருந்தாலும், இரண்டாவதை நம்பக்கூடும். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","இந்த இரண்டு அடையாளங்களையும் அவர்கள் நம்பாமல் அல்லது உனக்குச் செவிகொடுக்காமல் போனால், நைல் நதியிலிருந்து கொஞ்சம் தண்ணீர் எடுத்து, அதைக் காய்ந்த தரையில் ஊற்று; நீ நதியிலிருந்து எடுக்கிற தண்ணீர் தரையில் இரத்தமாய் மாறிவிடும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","அதற்கு மோசே யெகோவாவிடம், “யெகோவாவே, கடந்த காலத்திலோ அல்லது நீர் உமது அடியானுடன் பேசியதிலிருந்தோ, நான் ஒருபோதும் பேச்சுத்திறன் உடையவனாய் இருக்கவில்லை; என் வாய் திக்கும், என் நாவு குழறும்.” ");
INSERT INTO tamtcv_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","அப்பொழுது யெகோவா அவனிடம், “மனிதனுக்கு வாயை உண்டாக்கியவர் யார்? அவனை ஊமையாகவோ செவிடாகவோ ஆக்குகிறவர் யார்? அவனுக்கு பார்வையைக் கொடுப்பதோ, அவனைக் குருடனாக்குவதோ யார்? யெகோவாவாகிய நான் அல்லவா? ");
INSERT INTO tamtcv_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","இப்பொழுதே நீ போ; பேசுவதற்கு நான் உனக்கு உதவிசெய்து, நீ சொல்ல வேண்டியதையும் உனக்குப் போதிப்பேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","அதற்கு மோசேயோ, “யெகோவாவே, தயவுசெய்து இதைச் செய்வதற்கு வேறொருவனை அனுப்பும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","அதனால் மோசேக்கு எதிராக யெகோவாவின் கடுங்கோபம் மூண்டது; அவர், “அப்படியானால் லேவியனாகிய உன் சகோதரன் ஆரோன் இருக்கிறான் அல்லவா? அவன் நன்றாகப் பேசுவான் என்பதை நான் அறிவேன். அவன் உன்னைச் சந்திப்பதற்கு வந்துகொண்டிருக்கிறான், உன்னைக் கண்டதும் மகிழ்ச்சியடைவான். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","நீ அவனுடன் பேசி, அவன் சொல்லவேண்டிய வார்த்தைகளை அவனுக்குச் சொல்வாய்; அப்பொழுது நான் உங்கள் இருவருக்கும் பேசுவதற்கு உதவிசெய்து, நீங்கள் செய்யவேண்டியதையும் உங்களுக்குப் போதிப்பேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","அவன் உனக்காக மக்களிடம் பேசுவான், அவன் உனக்கு வாய் போலிருப்பான்; நீ அவனுக்கு இறைவன்போல் இருப்பாய். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","ஆனாலும் நீ இந்தக் கோலை கையில் கொண்டுபோ; இதைக்கொண்டு அற்புத அடையாளங்களை உன்னால் செய்யமுடியும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","அதன்பின் மோசே தன் மாமனார் எத்திரோவிடம் திரும்பிப்போய் அவனிடம், “நான் எகிப்திலுள்ள என் சொந்த மக்களிடம் மறுபடியும்போய், அவர்களில் யாராவது இன்னும் உயிரோடிருக்கிறார்களா, என்று பார்க்க என்னைப் போகவிடும்” என்றான். அதற்கு எத்திரோ, “என் நல்வாழ்த்துகள்; நீ போய்வா” என்று சொல்லி அவனை அனுப்பிவைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","மீதியான் தேசத்தில் யெகோவா மோசேயிடம், “உன்னைக் கொலைசெய்ய எண்ணியிருந்தவர்களான எல்லோரும் இறந்துவிட்டார்கள். ஆகையால், நீ எகிப்திற்குத் திரும்பவும் போ” என்று சொல்லியிருந்தார். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","எனவே மோசே தன் மனைவியையும், மகன்களையும் கழுதையின்மேல் ஏற்றிக்கொண்டு எகிப்திற்குப் போகப் புறப்பட்டான். மோசே இறைவனின் கோலை தன்னுடன் எடுத்துச் சென்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","அப்பொழுது யெகோவா மோசேயிடம், “நீ எகிப்திற்குத் திரும்பிப் போனபின்பு, நான் உனக்குக் கொடுத்த அற்புதங்களை எல்லாம் என் வல்லமையைக்கொண்டு, பார்வோனுக்கு முன்பாகச் செய்துகாட்டு; ஆனால் நானோ பார்வோனின் இருதயத்தைக் கடினப்படுத்துவேன். அதனால் அவன் மக்களைப் போகவிடமாட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","அப்பொழுது நீ பார்வோனிடம், ‘யெகோவா சொல்வது இதுவே: இஸ்ரயேல் எனது முதற்பேறான மகன், ");
INSERT INTO tamtcv_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","என் மகனை என்னை வழிபடும்படி போகவிடு என்று நான் உனக்குச் சொன்னேன்; ஆனால் நீயோ, அவனைப் போகவிட மறுத்தாய்; ஆகையால் நான் உன்னுடைய முதற்பேறான மகனைக் கொல்லுவேன்’ என்கிறார் என்று சொல்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","மோசே பயணம் செய்யும் வழியில் அவர்கள் தங்கியிருந்த இடத்தில் யெகோவா மோசேயை எதிர்த்து, அவனைக் கொல்ல முயன்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","உடனே சிப்போராள் ஒரு கூர்மையானக் கல்லை எடுத்து, தன் மகனுக்கு விருத்தசேதனம் செய்து, அதனால் மோசேயின் பாதங்களைத் தொட்டு, “நிச்சயமாக நீர் எனக்கு இரத்தத்தினால் உரிமையான மணமகன்” என்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","எனவே யெகோவா அவனை விட்டுவிட்டார். “இரத்தத்தினால் உரிமையான மணமகன்” என்று விருத்தசேதனத்தைக் குறித்தே அந்நேரத்தில் அவள் சொன்னாள். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","யெகோவா ஆரோனிடம், “மோசேயைச் சந்திப்பதற்காகப் பாலைவனத்திற்குப் போ” என்றார். அதன்படியே ஆரோன் இறைவனின் மலையில் மோசேயைச் சந்தித்து, அவனை முத்தமிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","அப்பொழுது மோசே யெகோவா தன்னை அனுப்பிச் சொல்லும்படிச் சொன்ன எல்லாவற்றையும் ஆரோனிடம் கூறினான். அத்துடன் அவர் தனக்குச் செய்யும்படி கட்டளையிட்ட அற்புத அடையாளங்களைப் பற்றியும் சொன்னான். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","மோசேயும் ஆரோனும் இஸ்ரயேலின் சபைத்தலைவர்கள் எல்லோரையும் கூடிவரச் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","அப்பொழுது யெகோவா மோசேக்குச் சொல்லியிருந்த எல்லாவற்றையும் ஆரோன் அவர்களிடம் கூறினான், அவன் அந்த அடையாளங்களையும் மக்களுக்குமுன் செய்துகாட்டினான். ");
INSERT INTO tamtcv_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","அவர்கள் நம்பினார்கள். யெகோவா இஸ்ரயேலர்களில் கரிசனையாய் இருக்கிறார் என்றும், தங்கள் அவலத்தைக் கண்டிருக்கிறார் என்றும் அவர்கள் கேள்விப்பட்டபோது, அவர்கள் தலைகுனிந்து வழிபட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","அதன்பின் மோசேயும் ஆரோனும் பார்வோனிடம் போய், “பாலைவனத்தில் ஒரு பண்டிகை கொண்டாடுவதற்கு, என் மக்களைப் போகவிடு என்று இஸ்ரயேலின் இறைவனாகிய யெகோவா சொல்கிறார்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","அதற்குப் பார்வோன், “நான் யெகோவாவுக்குக் கீழ்ப்படிந்து இஸ்ரயேல் மக்களைப் போகவிட அவர் யார்? எனக்கு யெகோவாவைத் தெரியாது, நான் இஸ்ரயேலரைப் போகவிடமாட்டேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","அப்பொழுது அவர்கள், “எபிரெயரின் இறைவன் எங்களைச் சந்தித்திருக்கிறார். இப்பொழுது நாங்கள் பாலைவனத்தில் மூன்று நாட்கள் பயணம் செய்து, இறைவனாகிய யெகோவாவுக்குப் பலிசெலுத்தும்படி எங்களைப் போகவிடும். இல்லாவிட்டால் கொள்ளைநோயினாலோ வாளினாலோ அவர் எங்களைத் தண்டிப்பார்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","அதற்கு எகிப்தின் அரசன், “மோசே, ஆரோன் நீங்கள் ஏன் மக்களை வேலைசெய்வதிலிருந்து குழப்புகிறீர்கள்? உங்கள் வேலைக்குத் திரும்பிப்போங்கள்!” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","மேலும் பார்வோன், “பாருங்கள், இப்பொழுது இந்த நாட்டில் உங்கள் மக்கள் பெருகியிருக்கிறார்கள்; அப்படியிருக்க நீங்கள் அவர்கள் வேலைசெய்வதைத் தடுக்கிறீர்களே!” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","அன்றைய தினமே பார்வோன், அடிமைகளை நடத்தும் கண்காணிகளிடமும், மக்களுக்குப் பொறுப்பாயிருந்த தலைவர்களிடமும் கொடுத்த உத்தரவு இதுவே: ");
INSERT INTO tamtcv_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“நீங்கள் இனிமேல் செங்கல் சுடுவதற்கு மக்களுக்கு வைக்கோல் கொடுக்கக்கூடாது; அவர்களே போய் வைக்கோலைச் சேகரித்து வரட்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ஆனால் நீங்கள் அவர்களிடம் முன்பு செய்த அளவு செங்கற்களைச் செய்யும்படி கேட்டுக்கொள்ளுங்கள்; அந்த அளவைக் குறைக்கவேண்டாம், அவர்கள் சோம்பேறிகள்; அதனால்தான் அவர்கள், ‘நாங்கள் போய் எங்கள் இறைவனுக்குப் பலிசெலுத்த அனுமதியும்’ என்று கூக்குரலிடுகிறார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","அந்த மனிதர்கள் தொடர்ந்து வேலைசெய்யும்படிக்கும், பொய்களை நம்பாதபடிக்கும் அவர்களுடைய வேலையை இன்னும் கடினமாக்குங்கள்.” ");
INSERT INTO tamtcv_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","அப்பொழுது அடிமைகளை நடத்தும் கண்காணிகளும், தலைவர்களும் மக்களிடம்போய், “பார்வோன், ‘இனிமேல் வைக்கோல் கொடுக்கமாட்டேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","நீங்களே வைக்கோல் கிடைக்கும் இடங்களுக்குப் போய், உங்களுக்கான வைக்கோலை எங்கேயாவது தேடிக்கொள்ளுங்கள்; ஆனாலும் உங்கள் வேலை கொஞ்சமும் குறைக்கப்படமாட்டாது’ என்று சொல்கிறான்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","எனவே மக்கள் வைக்கோலுக்குப் பதிலாக வயலில் விடப்பட்ட பயிரின் அடித்தாழ்களை சேகரிப்பதற்கு எகிப்து முழுவதும் சிதறிப்போனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","அடிமை நடத்தும் அதிகாரிகள் அவர்களிடம், “வைக்கோல் இருக்கும்போது செய்ததுபோலவே, ஒவ்வொரு நாளுக்கும் குறிக்கப்பட்ட அளவின்படியே வேலைசெய்யவேண்டும்” என வற்புறுத்தினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","தலைவர்களாய் இருந்த இஸ்ரயேலரை, அடிமைகளை நடத்தும் பார்வோனின் கண்காணிகள் அடித்து, “நீங்கள் ஏன் உங்களுக்குக் குறித்த செங்கற்களை முன்பு செய்ததுபோல நேற்றும் இன்றும் செய்யவில்லை” என்றும் கேட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","அப்பொழுது இஸ்ரயேல் மக்களின் தலைவர்கள் பார்வோனிடம் சென்று, “நீங்கள் ஏன் உங்கள் பணியாளர்களான எங்களை இவ்விதமாய் நடத்துகிறீர்கள்? ");
INSERT INTO tamtcv_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","உமது பணியாளர்களுக்கு வைக்கோல் கொடுக்கப்படவில்லை; அப்படியிருந்தும் செங்கல் சுடும்படி கேட்கப்பட்டு உங்கள் பணியாளர்களால் அடிக்கப்படுகிறோம்; ஆனால், குற்றம் உமது சொந்த மக்களிலேயே இருக்கிறது” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","அதற்குப் பார்வோன், “சோம்பேறிகளே, நீங்கள் சோம்பேறிகளாய் இருப்பதனால்தான், ‘நாங்கள் போய் யெகோவாவுக்குப் பலியிட எங்களை விடுங்கள்’ என்று கேட்டுக்கொண்டே இருக்கிறீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","இப்பொழுதே வேலைக்குப் போங்கள். உங்களுக்கு வைக்கோல் கொடுக்கப்படமாட்டாது, ஆனாலும் நீங்கள் உங்களுக்குக் கொடுக்கப்பட்ட முழு எண்ணிக்கையின்படி செங்கற்களைச் செய்தே ஆகவேண்டும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","“ஒவ்வொரு நாளும் செய்யவேண்டிய செங்கற்களின் எண்ணிக்கையை நீங்கள் குறைக்கக்கூடாது” என்று இஸ்ரயேல் மக்களின் தலைவர்களுக்குச் சொல்லப்பட்டபோது, தாம் பெரும் பிரச்சனைக்கு உட்பட்டிருப்பதை அவர்கள் உணர்ந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","அவர்கள் பார்வோனிடம் இருந்து திரும்பி வரும்போது, மோசேயும் ஆரோனும் தங்களைச் சந்திக்கக் காத்துக்கொண்டிருப்பதைக் கண்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","அப்பொழுது அவர்கள் மோசேயையும் ஆரோனையும் நோக்கி, “யெகோவாவே உங்களைப் பார்த்து நியாயந்தீர்ப்பாராக! நீங்கள் எங்களைப் பார்வோனுக்கும், அவனுடைய அலுவலர்களுக்கும் அருவருப்பானவர்களாக்கி, எங்களைக் கொல்லும்படி அவர்களின் கைகளில் வாளையும் கொடுத்திருக்கிறீர்கள்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","மோசே யெகோவாவிடம் திரும்பிப்போய், “யெகோவாவே, இந்த மக்கள்மேல் ஏன் பிரச்சனையைக் கொண்டுவந்திருக்கிறீர்? இதற்காகவா என்னை அனுப்பினீர்? ");
INSERT INTO tamtcv_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","பார்வோனிடம் சென்று உம்முடைய பெயரைச் சொல்லிப் பேசியதுமுதல், அவன் இந்த மக்கள்மேல் தொல்லையையே கொண்டுவந்திருக்கிறான். நீர் உமது மக்களை எவ்விதத்திலும் விடுதலையாக்கவில்லையே” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","அப்பொழுது யெகோவா மோசேயிடம், “இப்பொழுது நான் பார்வோனுக்குச் செய்யப்போவதை நீ காண்பாய்: என் பலத்த கரத்தின் நிமித்தம் அவன் அவர்களைப் போகவிடுவான்; அவன் என் கரத்தின் வல்லமையின் நிமித்தம் அவர்களைத் தன் நாட்டிலிருந்து துரத்தியே விடுவான்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","பின்னும் இறைவன் மோசேயிடம், “நானே யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ஆபிரகாமிற்கும், ஈசாக்கிற்கும், யாக்கோபிற்கும் எல்லாம் வல்ல இறைவனாக நானே காட்சியளித்தேன். ஆனாலும் யெகோவா என்ற என் பெயரால் நான் என்னை அவர்களுக்கு அறியச்செய்யவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","அத்துடன், ‘இஸ்ரயேல் மக்கள் பிறநாட்டினராய் வாழ்ந்த கானான் நாட்டை அவர்களுக்குக் கொடுப்பேன்’ என்று அவர்களுடன் ஒரு உடன்படிக்கையையும் ஏற்படுத்தினேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","மேலும், எகிப்தியர் அடிமைப்படுத்துகிற இஸ்ரயேலரின் அழுகுரலைக் கேட்டிருக்கிறேன்; என்னுடைய உடன்படிக்கையை நினைவுகூர்ந்தேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“ஆகையால், நீ இஸ்ரயேல் மக்களிடம் சொல்லவேண்டியதாவது; ‘நானே யெகோவா, நான் எகிப்தியரின் நுகத்தின் கீழிருந்து உங்களை வெளியே கொண்டுவருவேன். நீங்கள் அவர்களுக்கு அடிமைகளாய் இருப்பதிலிருந்து உங்களை விடுதலையாக்குவேன்; நான் பலத்த கரத்தினாலும், தண்டனைத் தீர்ப்பளிக்கும் வல்ல செயல்களினாலும் உங்களை மீட்பேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","உங்களை என் சொந்த மக்களாக்கி, நான் உங்கள் இறைவனாயிருப்பேன். அப்பொழுது எகிப்திய நுகத்தின் கீழிருந்து, உங்களை விடுவித்த உங்கள் இறைவனாகிய யெகோவா நானே என்று அறிந்துகொள்வீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","ஆபிரகாமிற்கும், ஈசாக்கிற்கும், யாக்கோபிற்கும் கொடுப்பேன் என்று, உயர்த்திய கரத்தினால் நான் ஆணையிட்ட நாட்டிற்கு உங்களைக் கொண்டுவருவேன். அதை உங்களுக்கு உடைமையாகக் கொடுப்பேன். நானே யெகோவா’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","மோசே இஸ்ரயேலருக்கு இவற்றை அறிவித்தான், ஆனால் அவர்களோ மனச்சோர்வினாலும் கொடூரமான அடிமைத்தனத்தினாலும் துன்பப்பட்டதனால் அவனுக்குச் செவிகொடுக்கவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","அப்பொழுது யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“எகிப்திய அரசனாகிய பார்வோனிடம் நீ போ, அவனுடைய நாட்டிலிருந்து இஸ்ரயேலரைப் போகவிடும்படிச் சொல்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","ஆனால் மோசே யெகோவாவிடம், “இஸ்ரயேலரே எனக்குச் செவிகொடுக்கவில்லை என்றால், பார்வோன் ஏன் செவிகொடுக்கவேண்டும்? நானோ பண்படாத உதடுகளுள்ளவன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","யெகோவா மோசேயிடமும் ஆரோனிடமும் இஸ்ரயேலரைப் பற்றியும், எகிப்திய அரசன் பார்வோனைப் பற்றியும் பேசி, எகிப்திலிருந்து இஸ்ரயேலரை வெளியே கொண்டுவரும்படி அவர்களுக்குக் கட்டளையிட்டார். ");
INSERT INTO tamtcv_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","இஸ்ரயேலரின் குடும்பங்களின் தலைவர்கள் இவர்களே: யாக்கோபின் முதற்பேறான மகனாகிய ரூபனின் மகன்கள்: ஆனோக்கு, பல்லூ, எஸ்ரோன், கர்மீ என்பவர்கள். ரூபனின் வம்சங்கள் இவையே. ");
INSERT INTO tamtcv_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","சிமியோனின் மகன்கள்: எமுயேல், யாமின், ஓகாத், யாகீன், சோகார், கானானியப் பெண்ணின் மகனான சாவூல் என்பவர்கள் ஆவர். சிமியோனுடைய வம்சங்கள் இவையே. ");
INSERT INTO tamtcv_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","பதிவேட்டின்படி லேவியின் மகன்களின் பெயர்கள்: கெர்சோன், கோகாத், மெராரி என்பவர்கள் ஆவர். லேவி 137 வருடங்கள் வாழ்ந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","லிப்னீயும் சீமேயியும் கெர்சோனின் வம்சத்தின் மகன்கள் ஆவர். ");
INSERT INTO tamtcv_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","அம்ராம், இத்சேயார், எப்ரோன், ஊசியேல் ஆகியோர் கோகாத்தின் மகன்கள் ஆவர். கோகாத் 133 வருடங்கள் வாழ்ந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","மெராரியின் மகன்கள் மகேலி, மூஷி என்பவர்கள். அவர்களுடைய பதிவேட்டின்படி லேவியின் வம்சங்கள் இவையே. ");
INSERT INTO tamtcv_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","அம்ராம் தன் தகப்பனின் சகோதரியான யோகெபேத்தைத் திருமணம் செய்தான்; அவள் அவனுக்கு ஆரோனையும், மோசேயையும் பெற்றாள். அம்ராம் 137 வருடங்கள் வாழ்ந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","இத்சேயாரின் மகன்கள் கோராகு, நெப்பேக், சிக்ரி என்பவர்கள் ஆவர். ");
INSERT INTO tamtcv_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","ஊசியேலின் மகன்கள்: மீசயேல், எல்சாபான், சித்ரி என்பவர்கள் ஆவர். ");
INSERT INTO tamtcv_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","அம்மினதாபின் மகளும், நகசோனின் சகோதரியுமான எலிசபாளை ஆரோன் திருமணம் செய்தான்; அவள் அவனுக்கு நாதாபையும், அபியூவையும், எலெயாசாரையும், இத்தாமாரையும் பெற்றாள். ");
INSERT INTO tamtcv_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","கோராகியரின் மகன்கள்: ஆசீர், எல்க்கானா, அபியாசாப் என்பவர்கள் ஆவர். கோராகிய வம்சங்கள் இவையே. ");
INSERT INTO tamtcv_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","ஆரோனின் மகன் எலெயாசார் பூத்தியேலுடைய மகள்களில் ஒருத்தியைத் திருமணம் செய்தான். அவள் அவனுக்குப் பினெகாசைப் பெற்றாள். வம்சம் வம்சமாக லேவிய குடும்பங்களின் தலைவர்கள் இவர்களே. ");
INSERT INTO tamtcv_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","இதே ஆரோனுக்கும், மோசேக்குமே, “இஸ்ரயேலருடைய கோத்திரப்பிரிவின்படி அவர்களை எகிப்திலிருந்து வெளியே கொண்டுவாருங்கள்” என்று யெகோவா சொல்லியிருந்தார். ");
INSERT INTO tamtcv_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","இதே மோசேயும் ஆரோனுமே எகிப்திலிருந்து இஸ்ரயேலரை வெளியே கொண்டுவருவது பற்றி, எகிப்திய அரசன் பார்வோனிடம் பேசினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","யெகோவா எகிப்தில் மோசேயுடன் பேசியபோது, ");
INSERT INTO tamtcv_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","யெகோவா மோசேயிடம், “நானே யெகோவா. நான் உனக்குச் சொல்லும் எல்லாவற்றையும் எகிப்திய அரசன் பார்வோனுக்குச் சொல்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","ஆனால் மோசேயோ யெகோவாவிடம், “நான் திக்குவாயுள்ளவன். பார்வோன் எப்படி எனக்குச் செவிகொடுப்பான்?” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","அப்பொழுது யெகோவா மோசேயிடம், “பார், நான் உன்னைப் பார்வோனுக்கு இறைவனைப்போல் ஆக்கியிருக்கிறேன், உன் சகோதரன் ஆரோன் உன் இறைவாக்கினனாக இருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","நான் உனக்குக் கட்டளையிடும் யாவற்றையும் நீ சொல்லவேண்டும், உன் சகோதரன் ஆரோன் பார்வோனிடம் இஸ்ரயேலரை அவனுடைய நாட்டிலிருந்து வெளியே போகவிடும்படிச் சொல்லவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","ஆனாலும் நான் பார்வோனின் இருதயத்தைக் கடினப்படுத்துவேன், எகிப்தில் என் அற்புத அடையாளங்களையும் அதிசயங்களையும் அதிகமாக்கினாலும், ");
INSERT INTO tamtcv_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","பார்வோன் உனக்குச் செவிகொடுக்கமாட்டான். அப்பொழுது நான் எகிப்தின்மேல் என் கரத்தை வைத்து, தண்டனைத் தீர்ப்பளிக்கும் வல்ல செயல்களால், என் மக்களாகிய இஸ்ரயேலரை வெளியே கொண்டுவருவேன்; அவர்களைக் கோத்திரப் பிரிவுகளாக கொண்டுவருவேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","நான் எகிப்தின்மேல் என் கையை நீட்டி இஸ்ரயேலரை எகிப்திலிருந்து வெளியே கொண்டுவரும்போது, நானே யெகோவா என்று எகிப்தியர் அறிந்துகொள்வார்கள்.” ");
INSERT INTO tamtcv_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","மோசேயும் ஆரோனும் யெகோவா தமக்குக் கட்டளையிட்டதையே செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","அவர்கள் பார்வோனிடம் பேசின நாட்களில், மோசே 80 வயதுடையவனாகவும், ஆரோன் 83 வயதுடையவனாகவும் இருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","யெகோவா மோசேயிடமும் ஆரோனிடமும் கூறியதாவது, ");
INSERT INTO tamtcv_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“பார்வோன் உங்களிடம் ஒரு அற்புதத்தைக் கேட்பான். அப்பொழுது நீ ஆரோனிடம், ‘உன் கோலை எடுத்து அதைப் பார்வோனுக்கு முன்பாகக் கீழே எறிந்துவிடு’ என்று சொல், அது பாம்பாக மாறும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","அப்படியே மோசேயும் ஆரோனும் பார்வோனிடம் போய் யெகோவாவின் கட்டளைப்படி செய்தார்கள். பார்வோனுக்கும் அவன் அதிகாரிகளுக்கும் முன்பாக ஆரோன் தன் கோலைக் கீழே எறிந்தபோது, அது பாம்பாக மாறியது. ");
INSERT INTO tamtcv_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","அப்பொழுது பார்வோன், ஞானிகளையும் சூனியக்காரரையும் அழைத்தான். எகிப்திய மந்திரவாதிகளாகிய அவர்களும் தங்கள் மாயவித்தைகளினால் அவ்வாறே செய்தார்கள்: ");
INSERT INTO tamtcv_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","அவர்கள் ஒவ்வொருவரும் தன்தன் கோலைக் கீழே போட்டபோது அவை பாம்பாக மாறின. ஆனால் ஆரோனின் கோலோ அவர்களுடைய கோல்களை விழுங்கிவிட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ஆனாலும், யெகோவா சொல்லியிருந்தபடியே, பார்வோனுடைய இருதயம் கடினமாகியது; அவன் அவர்களுக்குச் செவிகொடுக்கவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","அப்பொழுது யெகோவா மோசேயிடம், “பார்வோனின் இருதயம் கடினமாகிவிட்டது; அவன் இஸ்ரயேலரை போகவிட மறுக்கிறான். ");
INSERT INTO tamtcv_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","காலையில் பார்வோன் ஆற்றுக்குப் போகும்போது நீ அவனிடம் போ. பாம்பாக மாறிய கோலை உன் கையில் எடுத்துக்கொண்டு நைல் நதிக்கரையிலே அவனைச் சந்திக்கக் காத்து நில். ");
INSERT INTO tamtcv_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","அவன் வந்ததும் நீ அவனிடம், ‘எபிரெயரின் இறைவனாகிய யெகோவா என்னை உன்னிடம் அனுப்பி, பாலைவனத்திலே என்னை வழிபடும்படி என்னுடைய மக்களைப் போகவிடு’ என்று சொல்லியிருந்தார். ஆனாலும் இதுவரை நீர் அதைக் கேட்கவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","அதனால் யெகோவா உனக்குச் சொல்வது இதுவே: ‘நானே யெகோவா என்பதை இதனால் நீ அறிந்துகொள்வாய்: என் கையிலுள்ள கோலினால் நைல் நதியின் தண்ணீரை அடிப்பேன், உடனே அது இரத்தமாக மாறும். ");
INSERT INTO tamtcv_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","நைல் நதியிலுள்ள மீன்கள் செத்து, நதியோ நாற்றமெடுக்கும்; எகிப்தியரால் அதன் தண்ணீரைக் குடிக்கமுடியாமல் போகும்’ என்று சொல்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","பின்னும் யெகோவா மோசேயிடம், “நீ ஆரோனிடம் சொல்லவேண்டியதாவது, ‘எகிப்திலே தண்ணீருள்ள இடங்களான ஆறுகள், அருவிகள், குளங்கள், நீர்த்தேக்கங்கள் உள்ள எல்லா இடங்களின் மேலும் உன் கோலை எடுத்து, உன் கையை நீட்டு’ என்று சொல். அவை இரத்தமாக மாறிவிடும். எகிப்து எங்கும் இரத்தம் இருக்கும், மரத்தினால் மற்றும் கல்லினாலான பாத்திரங்களிலும் உள்ள தண்ணீரும் இரத்தமாக மாறும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","மோசேயும் ஆரோனும் யெகோவா கட்டளையிட்டபடியே செய்தார்கள். ஆரோன் பார்வோனுக்கும் அவன் அதிகாரிகளுக்கும் முன்பாக தன் கோலை நீட்டி, நைல் நதியிலிருந்த தண்ணீரின்மேல் அடித்தான்; தண்ணீர் முழுவதும் இரத்தமாக மாறிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","நைல் நதியிலுள்ள மீன்களெல்லாம் செத்துப்போயின; எகிப்தியர் நைல் நதியின் தண்ணீரைக் குடிக்க முடியாதபடி நைல் நதி துர்நாற்றமெடுத்தது. எகிப்தில் எங்கும் இரத்தமாயிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","எகிப்தின் மந்திரவாதிகளும் தங்கள் மாயவித்தைகளினால் அவ்வாறே செய்தார்கள், அதனால் பார்வோனுடைய இருதயம் கடினப்பட்டது. யெகோவா மோசேக்குச் சொல்லியிருந்தபடியே, அவன் மோசேக்கும் ஆரோனுக்கும் செவிகொடுக்கவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","அதற்குப் பதிலாக பார்வோன் திரும்பி, தன் அரண்மனைக்குள் போய்விட்டான், அவன் யெகோவா செய்ததைக்கூட பொருட்படுத்தவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ஆற்றுத் தண்ணீரைக் குடிக்க முடியாதிருந்ததால், எகிப்தியர் குடிநீருக்காக நைல் நதியோரமெங்கும் தோண்டினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","யெகோவா நைல் நதியை இரத்தமாக மாற்றி ஏழு நாட்கள் கடந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","அதன்பின் யெகோவா மோசேயிடம் சொன்னதாவது, “நீ பார்வோனிடம் போய், ‘யெகோவா சொல்வது இதுவே: என்னை வழிபடுவதற்கு என் மக்களைப் போகவிடு. ");
INSERT INTO tamtcv_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","நீ அவர்களைப் போகவிட மறுத்தால், உன் நாடு முழுவதையும் தவளைகளினால் வாதிப்பேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","நைல் நதி தவளைகளால் நிரம்பும். அவை உன் அரண்மனைக்குள்ளும் உன் படுக்கையறைக்குள்ளும், உன் கட்டிலின்மேலும், உன் அதிகாரிகளின் வீடுகளுக்குள்ளும், உன் மக்கள்மேலும், உன் அடுப்புகளுக்குள்ளும், மாப்பிசையும் பாத்திரங்களுக்குள்ளும் வந்து ஏறும். ");
INSERT INTO tamtcv_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","தவளைகள் உன்மேலும், உன் நாட்டு மக்கள்மேலும், உன் அதிகாரிகள்மேலும் வந்து ஏறும்’ என்று சொல்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","பின்னும் யெகோவா மோசேயிடம், “நீ ஆரோனிடம் சொல்லவேண்டியதாவது, ‘நீ உன் கோலை எடுத்து, உனது கையை நீரோடைகள்மேலும் வாய்க்கால்கள்மேலும் குளங்கள்மேலும் நீட்டி, எகிப்து நாட்டின்மேல் தவளைகளை வரும்படி செய்’ என்று சொல்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","அப்படியே ஆரோன் எகிப்திலுள்ள நீர் நிலைகள்மேல் தன் கையை நீட்டினான். அப்போது தவளைகள் வந்து, நாட்டை மூடிக்கொண்டன. ");
INSERT INTO tamtcv_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","ஆனால் எகிப்திய மந்திரவாதிகளும் தங்கள் மாயவித்தைகளினால் அவ்வாறே செய்து, எகிப்து நாட்டின்மேல் தவளைகளை வரச்செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","அப்பொழுது பார்வோன் மோசேயையும் ஆரோனையும் அழைப்பித்து, “இந்தத் தவளைகள் என்னையும் என் நாட்டு மக்களையும் விட்டு நீங்கும்படி யெகோவாவிடம் வேண்டிக்கொள்ளுங்கள். அப்பொழுது நான் யெகோவாவுக்குப் பலிகளைச் செலுத்த உங்கள் மக்களைப் போகவிடுவேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","மோசே பார்வோனிடம், “தவளைகள் உம்மிடத்திலிருந்தும் உமது வீடுகளிலிருந்தும் நீங்கும்படி, உமக்காகவும் உமது அதிகாரிகளுக்காகவும் உமது மக்களுக்காகவும் நான் மன்றாடுவேன். ஆனால் அதற்கான நேரத்தை நீரே தீர்மானித்து எனக்குத் தெரியப்படுத்தும். நைல் நதியில் மட்டும் தவளைகள் இருக்கும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","அதற்குப் பார்வோன், “நாளைக்கே மன்றாடு” என்றான். அதற்கு மோசே, “நீர் சொன்னபடியே ஆகும். அப்பொழுது எங்கள் இறைவனாகிய யெகோவாவுக்கு நிகரானவர் யாரும் இல்லையென்று நீர் அறிந்துகொள்வீர். ");
INSERT INTO tamtcv_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","தவளைகள் உம்மையும், உமது வீடுகளையும், அதிகாரிகளையும், மக்களையும் விட்டு நீங்கிவிடும்; ஆனால் நைல் நதியில் மட்டும் இருக்கும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","மோசேயும் ஆரோனும் பார்வோனிடமிருந்து போனபின், பார்வோன்மேல் யெகோவா கொண்டுவந்த தவளைகளைக் குறித்து, மோசே அவரை நோக்கி மன்றாடினான். ");
INSERT INTO tamtcv_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","யெகோவா மோசே கேட்டபடியே செய்தார். வீடுகளிலும், முற்றங்களிலும், வயல்களிலுமுள்ள தவளைகளெல்லாம் செத்துப்போயின. ");
INSERT INTO tamtcv_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","தவளைகள் குவியலாகக் குவிக்கப்பட்டன. அதனால் நாடெங்கும் துர்நாற்றமெடுத்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","துயரம் நீங்கியதை பார்வோன் கண்டதும், யெகோவா மோசேக்குச் சொல்லியிருந்தபடியே, அவன் தன் இருதயத்தைக் கடினப்படுத்தி, மோசேக்கும் ஆரோனுக்கும் செவிகொடுக்கவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","பின்பு யெகோவா மோசேயிடம், “நீ ஆரோனிடம், நீ உன் கோலை நீட்டி நிலத்தின் புழுதியை அடி. அப்பொழுது எகிப்து நாடு எங்குமுள்ள புழுதி பேன்களாக மாறும் என்று சொல்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","அவர்கள் அப்படியே செய்தார்கள். ஆரோன் கோலைப் பிடித்திருந்த தன் கையை நீட்டி நிலத்தின் புழுதியை அடித்ததும், மனிதர்மேலும் மிருகங்கள்மேலும் பேன்கள் வந்தன. எகிப்து நாட்டின் புழுதியெல்லாம் பேன்களாக மாறிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","ஆனால் மந்திரவாதிகள், தங்கள் மாயவித்தைகளினால் பேன்களை உண்டுபண்ண முயன்றபோது, அவர்களால் முடியாது போயிற்று. மனிதர்மேலும் மிருகங்கள்மேலும் பேன்கள் இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","அப்பொழுது மந்திரவாதிகள் பார்வோனிடம், “இது இறைவனின் விரலேதான்” என்றார்கள். ஆனாலும் யெகோவா சொல்லியிருந்தபடியே பார்வோனின் இருதயம் கடினமாகி, அவர்களுக்கு அவன் செவிகொடுக்கவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","அதன்பின் யெகோவா மோசேயிடம் சொன்னதாவது: “நீ அதிகாலையில் எழுந்து பார்வோன் ஆற்றுக்குப் போகும்போது அவனுக்கு முன்பாக நின்று அவனிடம், ‘யெகோவா சொல்வது இதுவே: என்னை வழிபடுவதற்கு, என் மக்களைப் போகவிடு. ");
INSERT INTO tamtcv_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","என் மக்களைப் போகவிடாவிட்டால் உன்மேலும், உன் அதிகாரிகள்மேலும், உன் மக்கள்மேலும், உன் வீட்டிற்குள்ளும் வண்டுகளை அனுப்புவேன். எகிப்தியருடைய வீடுகள் வண்டுகளால் நிறைந்திருக்கும். அவர்கள் வாழும் நிலமும் அவைகளால் நிறைந்திருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘ஆனாலும் என் மக்கள் வாழும் கோசேன் நாட்டையோ, அந்த நாளில் நான் வித்தியாசமாக நடத்துவேன்; அங்கு வண்டுகள் இராது, அதனால் யெகோவாவாகிய நான் இந்த நாட்டில் இருக்கிறேன் என்பதை நீ அறிந்துகொள்வாய். ");
INSERT INTO tamtcv_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","இவ்வாறு என் மக்களுக்கும், உன் மக்களுக்கும் இடையில் வித்தியாசம் ஏற்படுத்துவேன். இந்த அற்புத அடையாளம் நாளைக்கே நிகழும்’ என்று சொல்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","யெகோவா அவ்வாறே செய்தார். பார்வோனின் அரண்மனைக்குள்ளும், அவனுடைய அதிகாரிகளின் வீடுகளுக்குள்ளும் திரளான வண்டுகள் நிறைந்தன. எகிப்து நாடு முழுவதும் வண்டுகளால் அழிக்கப்பட்டுப் போயிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","அப்பொழுது பார்வோன் மோசேயையும் ஆரோனையும் அழைப்பித்து, “நீங்கள் போய் உங்கள் இறைவனுக்கு பலி செலுத்துங்கள். இந்த நாட்டிலேயே அதைச் செலுத்துங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","அதற்கு மோசே, “நாங்கள் அப்படிச் செய்வது சரியல்ல; ஏனெனில் எங்கள் இறைவனாகிய யெகோவாவுக்கு நாங்கள் செலுத்தும் பலிகள் எகிப்தியருக்கு அருவருப்பாயிருக்கும். அப்படி அவர்கள் பார்வையில் அருவருப்பாயிருக்கிற பலிகளை நாங்கள் செலுத்தினால், அவர்கள் எங்கள்மேல் கல்லெறியாமல் விடுவார்களோ? ");
INSERT INTO tamtcv_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","எங்கள் இறைவனாகிய யெகோவா எங்களுக்குக் கட்டளையிட்டபடியே, அவருக்குப் பலிகளைச் செலுத்துவதற்கு நாங்கள் மூன்று நாட்கள் பிரயாணமாய்ப் பாலைவனத்திற்குப் போகவேண்டும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","அப்பொழுது பார்வோன், “உங்கள் இறைவனாகிய யெகோவாவுக்கு பாலைவனத்தில் பலிசெலுத்தும்படி, நான் உங்களைப் போகவிடுவேன். ஆனால் நீங்கள் அதிக தூரம் போகக்கூடாது. இப்பொழுது எனக்காக வேண்டிக்கொள்ளுங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","அதற்கு மோசே, “நான் இங்கிருந்து போனவுடனேயே யெகோவாவிடம் மன்றாடுவேன்; நாளைக்கு வண்டுகள் பார்வோனையும், அவன் அதிகாரிகளையும், அவன் மக்களையும் விட்டு நீங்கிவிடும். யெகோவாவுக்குப் பலிகளைச் செலுத்த மக்களைப் போகவிடாதபடி பார்வோனாகிய நீர் மீண்டும் வஞ்சனையாய் நடக்காதிரும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","பின்பு மோசே பார்வோனைவிட்டுப் போய், யெகோவாவிடம் மன்றாடினான். ");
INSERT INTO tamtcv_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","மோசே கேட்டுக்கொண்டபடியே யெகோவா செய்தார். வண்டுகள் பார்வோனையும், அவன் அதிகாரிகளையும், நாட்டு மக்களையும் விட்டு நீங்கிற்று; ஒரு வண்டும் மிஞ்சியிருக்கவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","ஆனாலும் இம்முறையும் பார்வோன் தன் மனதைக் கடினப்படுத்தி இஸ்ரயேல் மக்களைப் போகவிடவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","அதன்பின் யெகோவா மோசேயிடம் சொன்னதாவது: “நீ பார்வோனிடம் போய் எபிரெயரின் இறைவனாகிய யெகோவா சொல்வது இதுவே: ‘என் மக்கள் என்னை வழிபடுவதற்கு போகவிடு. ");
INSERT INTO tamtcv_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","நீ அவர்களைப் போகவிட மறுத்து, அவர்களைத் தொடர்ந்து தடுத்து வைத்திருந்தால், ");
INSERT INTO tamtcv_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","வயல்வெளிகளிலுள்ள உங்கள் குதிரைகள், கழுதைகள், ஒட்டகங்கள், மந்தைகள், செம்மறியாடுகள், வெள்ளாடுகள் ஆகிய எல்லா வளர்ப்பு மிருகங்கள்மேலும் கொடிய வாதையை யெகோவாவினுடைய கரம் கொண்டுவரும். ");
INSERT INTO tamtcv_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","இஸ்ரயேலருடைய வளர்ப்பு மிருகங்களுக்கும், எகிப்தியருடைய வளர்ப்பு மிருகங்களுக்கும் இடையில் யெகோவா வித்தியாசம் காட்டுவார். அதனால் இஸ்ரயேலரின் மிருகங்களில் ஒன்றாகிலும் சாகாது’ என்று அவனுக்குச் சொல்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","“யெகோவா நாளைக்கே இதை இந்த நாட்டில் செய்வார்” என்று சொல்லி யெகோவா ஒரு காலத்தைக் குறிப்பிட்டார். ");
INSERT INTO tamtcv_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","மறுநாள் அப்படியே யெகோவா செய்தார்: எகிப்தியரின் வளர்ப்பு மிருகங்கள் எல்லாம் செத்துப்போனது; ஆனால் இஸ்ரயேலருக்குச் சொந்தமான மிருகம் ஒன்றாயினும் சாகவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","பார்வோன் அதுபற்றி விசாரிக்க ஆட்களை அனுப்பி, இஸ்ரயேலரின் மிருகங்களில் ஒன்றாகிலும் சாகவில்லை என்பதை அறிந்தான். ஆனாலும் அவனுடைய இருதயம் தொடர்ந்தும் கடினமாகவே இருந்தது, அவன் மக்களைப் போகவிடவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","அப்பொழுது யெகோவா மோசேயிடமும், ஆரோனிடமும் சொன்னதாவது: “நீங்கள் சூளையில் இருந்து கைநிறையப் புகையின் கரித்தூளை அள்ளிக்கொள்ளுங்கள். மோசே அதைப் பார்வோனுக்கு முன்பாக ஆகாயத்தில் வீசட்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","அது எகிப்து நாடு முழுவதிலும் தூசியாகி, நாடெங்குமுள்ள மனிதர்கள்மேலும், மிருகங்கள்மேலும் எரிச்சலூட்டும் கொப்புளங்களை உண்டாக்கும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","அப்படியே அவர்கள் சூளையிலிருந்து புகையின் கரித்தூளை அள்ளிக்கொண்டு, பார்வோனுக்குமுன் போய் நின்றார்கள். மோசே அதை ஆகாயத்தை நோக்கி வீசினான். உடனே மனிதர்மேலும் மிருகங்கள்மேலும் எரிச்சலூட்டும் கொப்புளங்கள் உண்டாயின. ");
INSERT INTO tamtcv_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","அவை மந்திரவாதிகள், எகிப்தியர் எல்லோர்மேலும் உண்டானதால், மந்திரவாதிகளால் மோசேக்கு முன்பாக நிற்க முடியவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","யெகோவா மோசேக்குச் சொல்லியிருந்தபடியே, பார்வோனின் இருதயத்தை மேலும் கடினப்படுத்தினார். அவன் மோசேக்கும் ஆரோனுக்கும் செவிகொடுக்கவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","அதன்பின் யெகோவா மோசேயிடம் சொன்னதாவது, “நீ அதிகாலையில் எழுந்து பார்வோனின் எதிரில் போய் அவனிடம், எபிரெயரின் இறைவனாகிய யெகோவா சொல்வது இதுவே: ‘என் மக்கள் என்னை வழிபடுவதற்கு அவர்களைப் போகவிடு. ");
INSERT INTO tamtcv_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","இல்லையென்றால் இம்முறை உனக்கும், உன் அதிகாரிகளுக்கும், உன் நாட்டு மக்களுக்கும் எதிராக எனது வாதைகளின் முழு தாக்கத்தையும் அனுப்புவேன். இதனால் பூமியெங்கும் எனக்கு நிகரானவர் யாருமே இல்லை என்பதை நீ அறிந்துகொள்வாய். ");
INSERT INTO tamtcv_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","ஏனெனில், நான் நினைத்திருந்தால் என் கரத்தை நீட்டி, பூமியிலிருந்து உங்களை முற்றிலும் அழித்துப்போடும் வாதை ஒன்றினால் உன்னையும் உன் மக்களையும் அப்பொழுதே அடித்திருப்பேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","ஆனாலும் நான் என் வல்லமையை உனக்குக் காட்டி, பூமியெங்கும் என்னுடைய பெயரை அறிவிக்கும் ஒரே நோக்கத்திற்காகவே நான் உன்னை உயர்த்தினேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","நீயோ இன்னும் என்னுடைய மக்களுக்கு விரோதமாய் இருந்து, அவர்களைப் போகவிடாமல் இருக்கிறாய். ");
INSERT INTO tamtcv_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","ஆதலால் நாளை இதே நேரத்தில், எகிப்து நாடு உண்டானதுமுதல் இன்றுவரை அங்கே ஒருபோதும் விழுந்திராத மிகக் கடுமையான ஆலங்கட்டி மழையை அனுப்புவேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","ஆகையால், இப்பொழுதே உன் வளர்ப்பு மிருகங்களையும், வயல்வெளியிலிருக்கும் உனக்குச் சொந்தமான மற்ற யாவற்றையும் ஒரு பாதுகாப்பான இடத்திற்குக் கொண்டுவரும்படி உத்தரவு கொடு. ஏனெனில் உள்ளே சேர்க்கப்படாமல் வெளியிலிருக்கும் எல்லா மனிதர்மேலும், மிருகங்கள்மேலும் பனிக்கட்டிகள் விழும். அவர்கள் இறந்துவிடுவார்கள்’ என்று சொல்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","யெகோவாவின் வார்த்தைக்குப் பயந்த பார்வோனின் அதிகாரிகள் தங்கள் அடிமைகளையும், வளர்ப்பு மிருகங்களையும் உள்ளே கொண்டுவருவதற்கு விரைந்து சென்றனர். ");
INSERT INTO tamtcv_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","யெகோவாவினுடைய வார்த்தையை அலட்சியப் படுத்தியவர்களோ, தங்கள் அடிமைகளையும், வளர்ப்பு மிருகங்களையும் வெளியிலே விட்டுவிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","அப்பொழுது யெகோவா மோசேயிடம், “எகிப்து நாடெங்கும் ஆலங்கட்டி மழை விழும்படி உன் கையை ஆகாயத்துக்கு நேராக நீட்டு. அப்பொழுது மனிதர்மேலும், மிருகங்கள்மேலும், எகிப்தின் வயல்வெளியில் வளர்கின்ற எல்லாவற்றின்மேலும் பனிக்கட்டி விழும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","மோசே அவ்விதமே ஆகாயத்தை நோக்கித் தன் கோலை நீட்டியபோது, யெகோவா இடிமுழக்கத்தையும், ஆலங்கட்டி மழையையும் அனுப்பினார். மின்னல் தரைமட்டும் மின்னிப் பாய்ந்தது. இவ்வாறு யெகோவா பனிக்கட்டிகளை எகிப்து நாட்டின்மேல் பொழிந்தார். ");
INSERT INTO tamtcv_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","பனிக்கட்டிகள் விழுந்தன. மின்னல் முன்னும் பின்னுமாக மின்னியது. எகிப்து ஒரு நாடான காலமுதல் ஒருபோதும் ஏற்படாத, கடுமையான புயலாய் அது இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ஆலங்கட்டி மழை எகிப்து நாடெங்கும் பெய்து, வயல்வெளியிலுள்ள மனிதர்களும் மிருகங்களுமான எல்லாவற்றின்மேலும் விழுந்தது; வயல்வெளிகளில் முளைத்த பயிர்களையும் அடித்தது, மரங்களின் இலைகளும் உதிர்க்கப்பட்டன. ");
INSERT INTO tamtcv_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","இஸ்ரயேல் மக்கள் வாழ்ந்த கோசேன் பிரதேசம் மாத்திரமே ஆலங்கட்டி மழை விழாத இடமாயிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","அப்பொழுது பார்வோன் மோசேயையும் ஆரோனையும் அழைத்தான். அவன் அவர்களிடம், “நான் இம்முறை பாவம் செய்துவிட்டேன். யெகோவா நியாயமானவர். நானும் என் மக்களுமே தவறு செய்திருக்கிறோம். ");
INSERT INTO tamtcv_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","யெகோவாவிடம் மன்றாடுங்கள். இந்த இடிமுழக்கமும், ஆலங்கட்டி மழையுமே எங்களுக்குப் போதும். நான் உங்களைப் போகவிடுவேன். இனியும் நீங்கள் இங்கிருக்க வேண்டியதில்லை” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","அதற்கு மோசே, “நான் பட்டணத்தைவிட்டுப் போனவுடன் என் கைகளை உயர்த்தி, யெகோவாவிடம் மன்றாடுவேன். அப்பொழுது இடிமுழக்கம் ஓய்ந்து பனிக்கட்டியும் நின்றுபோகும். பூமி யெகோவாவினுடையது என்று நீர் அறிந்துகொள்வீர். ");
INSERT INTO tamtcv_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","ஆனால் நீரும், உமது அதிகாரிகளும் இறைவனாகிய யெகோவாவுக்கு இன்னும் பயப்படவில்லை என்பதை நான் அறிவேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","சணலும் வாற்கோதுமையும் அழிக்கப்பட்டன. அவ்வேளையில் வாற்கோதுமை கதிர்விட்டிருந்தது, சணல் பூத்திருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","கோதுமையும், கம்பும் முற்றாதிருந்தபடியால் அவை அழிக்கப்படவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","பின்பு மோசே பார்வோனை விட்டு பட்டணத்துக்கு வெளியே வந்தான். அவன் யெகோவாவை நோக்கித் தன் கைகளை உயர்த்தினான்; உடனே இடிமுழக்கமும் ஆலங்கட்டி மழையும் நின்றுவிட்டன. மழையும் தொடர்ந்து தரையில் பெய்யாமல் ஓய்ந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","மழையும், பனிக்கட்டியும், இடிமுழக்கமும் நின்றதைப் பார்வோன் கண்டபோது, அவன் திரும்பவும் பாவம் செய்தான். அவனும் அவனுடைய அதிகாரிகளும் தங்களுடைய இருதயங்களை இன்னும் கடினப்படுத்தினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","யெகோவா மோசேக்குச் சொல்லியிருந்தபடியே பார்வோனின் இருதயம் கடினப்பட்டது. அவன் இஸ்ரயேல் மக்களைப் போகவிடவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","அதன்பின் யெகோவா மோசேயிடம் சொன்னதாவது: “நீ பார்வோனிடம் போ; நான் இந்த அற்புத அடையாளங்களை அவர்கள் மத்தியில் செய்வதற்காகத்தான் அவன் இருதயத்தையும், அவன் அதிகாரிகளுடைய இருதயங்களையும் கடினப்படுத்தியிருக்கிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","மேலும், நான் எப்படி எகிப்தியர்களைக் கடினமாய் நடத்தினேன் என்றும், எப்படி என் அடையாளங்களை அவர்கள் மத்தியில் செய்து காட்டினேன் என்றும் நீங்கள் உங்கள் பிள்ளைகளுக்கும், உங்கள் பேரப்பிள்ளைகளுக்கும் சொல்லும்படியும், இதனால் நானே யெகோவா என்று நீங்கள் அறிந்துகொள்ளும்படியுமே இப்படிச் செய்தேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","எனவே, மோசேயும் ஆரோனும் பார்வோனிடம் போய் அவனிடம், “எபிரெயரின் இறைவனாகிய யெகோவா சொல்வது இதுவே: ‘நீ எவ்வளவு காலத்திற்கு எனக்கு முன்பாக உன்னைத் தாழ்த்த மறுப்பாய்? என்னை வழிபடுவதற்கு என் மக்களைப் போகவிடு. ");
INSERT INTO tamtcv_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","நீ அவர்களைப் போகவிட மறுத்தால், நாளைக்கு உன் நாட்டிற்குள் வெட்டுக்கிளிகளைக் கொண்டுவருவேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","அவை நிலமே தெரியாதபடி தரையின் மேற்பரப்பு முழுவதையும் மூடும். அவை வயல்வெளியில் பனிக்கட்டிக்குத் தப்பியிருக்கும் தாவரங்கள் உட்பட, முளைக்கும் எல்லா மரங்களையும் தின்றுவிடும். ");
INSERT INTO tamtcv_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","அவை உன் வீடுகளையும், உன் அதிகாரிகளின் வீடுகளையும், எகிப்தியருடைய எல்லா வீடுகளையும் நிரப்பும். உன் தந்தையரோ, முற்பிதாக்களோ அவர்கள் இங்கு குடியேறிய காலத்திலிருந்து இன்றுவரை அப்படிப்பட்டதை ஒருபோதும் கண்டதில்லை’ என்று சொல்லி” மோசே பார்வோனை விட்டுத் திரும்பிப்போனான். ");
INSERT INTO tamtcv_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","பார்வோனின் அதிகாரிகள் அவனிடம், “எதுவரை இந்த மனிதன் நமக்குக் கண்ணியாயிருப்பான்? தங்கள் இறைவனாகிய யெகோவாவுக்கு வழிபாடு செய்ய அந்த மனிதரைப் போகவிடும். எகிப்து நாடு பாழாய் போனதை நீர் இன்னும் உணரவில்லையா?” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","எனவே மோசேயும் ஆரோனும் திரும்பவும் பார்வோனிடம் அழைத்துவரப்பட்டார்கள். அவன் அவர்களிடம், “நீங்கள் போய் உங்கள் இறைவனாகிய யெகோவாவுக்கு வழிபாடு செய்யுங்கள். ஆனால் போகிறவர்கள் யார்?” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","அதற்கு மோசே, “எங்கள் வாலிபரோடும், முதியோரோடும், எங்கள் மகன்கள், மகள்கள் எங்கள் ஆட்டு மந்தைகளோடும், மாட்டு மந்தைகளோடும் நாங்கள் போவோம். எங்கள் யெகோவாவுக்கு நாங்கள் பண்டிகை கொண்டாடவேண்டும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","அதற்குப் பார்வோன் அவனிடம், “என்ன! உங்கள் பெண்களோடும், பிள்ளைகளோடும் உங்களைப் போகவிட்டு, ‘யெகோவா உங்களோடுகூட இருப்பாராக’ என்று சொல்லச் சொல்கிறாயா? நிச்சயமாக நீ தீயநோக்கமே கொண்டுள்ளாய். ");
INSERT INTO tamtcv_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","இல்லை! ஆண்கள் மட்டும் போகட்டும்; போய் உங்கள் யெகோவாவை வழிபடட்டும். அதைத்தானே நீங்கள் கேட்டுக்கொண்டிருந்தீர்கள்” என்றான். பின்பு மோசேயும் ஆரோனும் பார்வோன் முன்னிலையிலிருந்து துரத்திவிடப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","அப்பொழுது யெகோவா மோசேயிடம், “எகிப்தின்மேல் உன் கையை நீட்டு. அப்பொழுது நாட்டின்மேல் வெட்டுக்கிளிக் கூட்டம் வந்து ஆலங்கட்டி மழைக்குத் தப்பி, வயல்வெளிகளில் முளைக்கும் எல்லாவற்றையும் தின்றுவிடும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","மோசே தன் கோலை எகிப்தின்மேல் நீட்டினான். அப்பொழுது யெகோவா, அன்று பகலும் இரவும் கொண்டல் காற்றை கிழக்கிலிருந்து நாட்டின்மேல் வீசச்செய்தார். காலையில் அக்காற்று வெட்டுக்கிளிகளைக் கொண்டுவந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","அவை எகிப்தின்மேல் படையாக வந்து, நாட்டின் எல்லாப் பகுதிகளிலும் பெருந்தொகையாக இறங்கின. வெட்டுக்கிளிகளினால் உண்டான இப்படிப்பட்ட வாதை இதற்குமுன் இருந்ததுமில்லை, இனிமேல் இருக்கப் போவதுமில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","அவை நாட்டின் மேற்பரப்பு முழுவதையும் மூடியதனால் நிலம் கருமையாயிற்று. ஆலங்கட்டி மழைக்குப்பின், தப்பிய எல்லா பயிர்களையும், மரங்களிலுள்ள பழங்களையும் அவை தின்றுவிட்டன. எகிப்து நாடு முழுவதிலும் உள்ள மரங்களிலோ, செடிகளிலோ பச்சையானது ஒன்றும் மீந்திருக்கவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","அப்பொழுது பார்வோன் மோசேயையும் ஆரோனையும் அவசரமாய் அழைப்பித்து, அவர்களிடம், “நான் உங்கள் இறைவனாகிய யெகோவாவுக்கும் உங்களுக்கும் விரோதமாய்ப் பாவம் செய்துவிட்டேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","ஆகையால் இன்னொருமுறை என் பாவத்தை மன்னித்து, இந்த மரண வாதையை என்னைவிட்டு எடுத்துப்போடும்படி உங்கள் இறைவனாகிய யெகோவாவிடம் மன்றாடுங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","அப்பொழுது மோசே பார்வோனைவிட்டுப் போய், யெகோவாவிடம் மன்றாடினான். ");
INSERT INTO tamtcv_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","யெகோவா காற்றைப் பலத்த காற்றாக மேற்கு பக்கத்திற்குத் திருப்பி வீசச்செய்தார். அக்காற்று வெட்டுக்கிளிகளை வாரிக் கொண்டுபோய் செங்கடலுக்குள் சேர்த்தது. எகிப்தின் எல்லைக்குள் ஒரு வெட்டுக்கிளியாகிலும் மீந்திருக்கவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","ஆனாலும் யெகோவா பார்வோனின் மனதைக் கடினப்படுத்தினார். அவன் இஸ்ரயேலரைப் போகவிடவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","அப்பொழுது யெகோவா மோசேயிடம் சொன்னதாவது: “உன் கையை வானத்துக்கு நேராக நீட்டு. அப்பொழுது எல்லோரும் உணரக்கூடிய இருள் எகிப்தின்மேல் உண்டாகும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","மோசே தன் கையை வானத்தை நோக்கி நீட்டினான். அப்பொழுது மூன்று நாட்கள் முழுமையான இருள் எகிப்து முழுவதையும் மூடியது. ");
INSERT INTO tamtcv_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","மூன்று நாட்களுக்கு யாரும் வேறொருவரைப் பார்க்கவோ அல்லது தங்கள் இடத்திலிருந்து புறப்படவோ முடியாதிருந்தது. ஆனாலும் இஸ்ரயேல் மக்கள் வாழ்ந்த இடங்களிலெல்லாம் அவர்களுக்கு வெளிச்சம் இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","அப்பொழுது பார்வோன் மோசேயை அழைப்பித்து அவனிடம், “நீங்கள் போய் உங்கள் யெகோவாவுக்கு வழிபாடு செய்யுங்கள். உங்களுடன் உங்கள் பெண்களும், பிள்ளைகளும் போகலாம். ஆனால் ஆட்டு மந்தைகளையும், மாட்டு மந்தைகளையும் இங்கே விட்டுவிட்டுப் போங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","அதற்கு மோசே, “எங்கள் இறைவனாகிய யெகோவாவுக்கு பலிகளையும், தகன காணிக்கைகளையும் நாம் எடுத்துச்செல்ல நீர் எங்களை அனுமதிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","எங்கள் மிருகங்களும் எங்களோடு வரவேண்டும். ஒரு மிருகத்தையாவது விட்டுச்செல்லக் கூடாது. எங்கள் இறைவனாகிய யெகோவாவை வழிபடுவதற்கு அவைகளிலிருந்து சிலவற்றை எடுக்கவேண்டும். நாங்கள் அங்கேபோய்ச் சேருமட்டும், நாங்கள் எதைக்கொண்டு யெகோவாவை வழிபடுவோம் என்று எங்களுக்குத் தெரியாது” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","யெகோவாவோ பார்வோனின் இருதயத்தைக் கடினப்படுத்தினார், அவன் அவர்களைப் போகவிட விரும்பவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","பார்வோன் மோசேயிடம், “நீ என் கண்முன் நில்லாதே, போ! திரும்பவும் என் முகத்தில் விழிக்காதபடி எச்சரிக்கையாயிரு! நீ என் முகத்தைப் பார்க்கும் நாளில் சாவாய்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","அதற்கு மோசே, “நீர் சொன்னபடியே இனி ஒருபோதும் நான் உமது முகத்தில் விழிக்கப்போவதில்லை” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","அப்பொழுது யெகோவா மோசேயிடம் சொன்னதாவது, “நான் பார்வோன்மேலும், எகிப்தின்மேலும் இன்னுமொரு வாதையைக் கொண்டுவருவேன். அதன்பின் அவன் உங்களை இங்கிருந்து போகவிடுவான்; அதுவுமன்றி, உங்களை முழுவதும் துரத்தியும் விடுவான். ");
INSERT INTO tamtcv_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","ஆண்களும் பெண்களும் வேறுபாடின்றி தங்களுடைய அயலவர்களிடத்தில் தங்க நகைகளையும், வெள்ளி நகைகளையும் கேட்டு வாங்கிக்கொள்ள வேண்டும் என்று நீ இஸ்ரயேல் மக்களுக்குச் சொல்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","யெகோவா இஸ்ரயேல் மக்களுக்கு எகிப்தியரின் கண்களில் தயவு கிடைக்கும்படி செய்தார். அதுவுமன்றி, மோசே எகிப்திலே பார்வோனின் அதிகாரிகளாலும், எகிப்திய மக்களாலும் பெரிதும் மதிக்கப்பட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","அப்பொழுது மோசே பார்வோனிடம், “யெகோவா சொல்வது இதுவே: ‘நான் நடு இராத்திரியளவில் எகிப்து எங்கும் கடந்துபோவேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","எகிப்தில் முதற்பேறான ஒவ்வொரு மகனும் சாவான். அரியணையில் இருக்கும் பார்வோனின் முதல் ஆண்பிள்ளைமுதல், திரிகை ஆட்டும் அடிமைப்பெண்ணின் முதல் ஆண்பிள்ளை வரையுள்ள முதல் பிறந்த எல்லா மகன்களும் சாவார்கள்; அத்துடன் மிருகங்களின் தலையீற்றுகள் அனைத்தும் சாகும். ");
INSERT INTO tamtcv_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","எகிப்து நாடெங்கும் முன்பும் பின்பும் இனி ஒருபோதும் இருக்காத பெரிய அழுகுரல் உண்டாகும். ");
INSERT INTO tamtcv_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","ஆனால் இஸ்ரயேலர் மத்தியில் மனிதரையோ, மிருகங்களையோ பார்த்து ஒரு நாயாவது குரைக்கமாட்டாது.’ இதனால் யெகோவா எகிப்தியருக்கும் இஸ்ரயேலருக்கும் இடையே வித்தியாசத்தைக் காட்டுகிறார் என்பதை நீ அறிந்துகொள்வாய். ");
INSERT INTO tamtcv_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","அப்பொழுது உம்முடைய அதிகாரிகள் எல்லோரும் என்முன் பணிந்து, ‘நீயும் உன்னைப் பின்பற்றுகிறவர்கள் யாவரும் எங்களைவிட்டுப் புறப்பட்டுப் போங்கள்!’ என்று சொல்வார்கள். அதன்பின் நான் புறப்படுவேன்” என்று சொல்லி மோசே கடுங்கோபத்துடன் பார்வோனைவிட்டுப் புறப்பட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","அப்பொழுது யெகோவா மோசேயிடம், “பார்வோன் உங்களுக்குச் செவிகொடுக்க மறுப்பான். இதினிமித்தம் எகிப்தில் என்னுடைய அதிசயங்கள் அதிகரிக்கும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","இப்படியாக மோசேயும் ஆரோனும் இந்த அதிசயங்களையெல்லாம் பார்வோனுக்கு முன்பாகச் செய்தார்கள், ஆனாலும் பார்வோனின் இருதயத்தை யெகோவா கடினப்படுத்தினார், அவன் இஸ்ரயேலரைத் தன் நாட்டிலிருந்து போகவிடவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","யெகோவா எகிப்திலே மோசேயிடமும் ஆரோனிடமும் சொன்னதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“இம்மாதம் உங்களுக்கு முதல் மாதம், உங்கள் வருடத்தின் முதலாம் மாதம். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","நீங்கள், இம்மாதத்தின் பத்தாம்நாள் ஒவ்வொரு குடும்பத்தலைவனும் தன்தன் குடும்பத்திற்காக வீட்டுக்கு ஒரு ஆட்டுக்குட்டியைத் தெரிந்தெடுக்க வேண்டும் என்று முழு இஸ்ரயேல் சமுதாயத்திற்கும் நீங்கள் சொல்லுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","எந்த குடும்பமாவது ஒரு முழு ஆட்டுக்குட்டியை சாப்பிட முடியாத அளவுக்குச் சிறியதாயிருந்தால், அவர்கள் தங்களுக்கு மிக அருகிலுள்ள அண்டை வீட்டாருடன் சேர்ந்து, அவர்களின் எண்ணிக்கைக்கு ஏற்றபடி அக்குட்டியைப் பகிர்ந்துகொள்ள வேண்டும். ஒவ்வொருவரும் சாப்பிடும் அளவுக்கு ஏற்ப ஆட்டுக்குட்டியின் அளவு தீர்மானிக்கப்பட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","நீ தெரிந்தெடுக்கும் மிருகங்களோ, ஒரு வயதுடைய பழுதற்ற கடாக்களாக இருக்கவேண்டும். இவற்றைச் செம்மறியாடுகளிலிருந்தோ, வெள்ளாடுகளிலிருந்தோ தெரிந்தெடுக்கலாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","அவற்றை மாதத்தின் பதினான்காம் தேதிவரை, வீட்டில் கவனமாகப் பராமரிக்க வேண்டும். பின்பு இஸ்ரயேல் சமுதாயத்தைச் சேர்ந்த மக்கள் எல்லோரும் தங்கள் ஆட்டுக்குட்டியை சாயங்கால வேளையில் கொல்லவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","அதன்பின் அவர்கள் அதன் இரத்தத்தில் கொஞ்சத்தை எடுத்து, அதை சாப்பிடும் வீட்டுக்கதவின் நிலைக்கால் இரண்டிலும், மேற்சட்டத்திலும் பூசவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","அன்று இரவு இறைச்சியை நெருப்பில் சுட்டு, புளிப்பில்லாத அப்பங்களோடும், கசப்பான கீரையோடும் சாப்பிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","இறைச்சியைப் பச்சையாகவோ அல்லது நீரில் சமைத்தோ சாப்பிடக்கூடாது. அதன் தலை, கால்கள், உள் உறுப்புகள் ஆகிய எல்லாவற்றையும் நெருப்பில் சுட்டே சாப்பிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","அவற்றில் எதையும் விடியும்வரை மீதியாக வைக்கவேண்டாம்; காலையில் ஏதும் மிஞ்சியிருந்தால் அவற்றை நெருப்பில் எரிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","இவ்விதமாகவே நீங்கள் அதைச் சாப்பிடவேண்டும்: உங்கள் அங்கிகளை இடுப்புப்பட்டியால் கட்டிக்கொண்டு, கால்களில் செருப்புகளைப் போட்டுக்கொண்டு, உங்கள் கோலை உங்கள் கையில் பிடித்தபடி, அதை அவசரமாக சாப்பிடவேண்டும். இதுவே யெகோவாவின் கடந்துசெல்லுதல், யெகோவாவின் பஸ்கா. ");
INSERT INTO tamtcv_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“அதே இரவில் நான் எகிப்து வழியாகக் கடந்துசென்று, அங்குள்ள மனிதர் மற்றும் மிருகங்களின் தலையீற்றுகளையும் சாகடிப்பேன். எகிப்திய தெய்வங்கள் எல்லாவற்றின் மீதும் நியாயத்தீர்ப்பைக் கொண்டுவருவேன். நானே யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","இந்த இரத்தம் நீங்கள் இருக்கும் வீடுகளின்மேல் உங்களுக்கான ஒரு அடையாளமாயிருக்கும். நான் அந்த இரத்தத்தைக் காணும்போது, உங்களைக் கடந்துபோவேன்; நான் எகிப்தியரைச் சாகடிக்கும்போது, அழிவின் வாதை எதுவும் உங்களைத் தொடமாட்டாது. ");
INSERT INTO tamtcv_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“இது நீங்கள் நினைவுகூரவேண்டிய ஒரு நாள்; தலைமுறைதோறும் யெகோவாவுக்குரிய பண்டிகையாக நீங்கள் இதைக் கொண்டாடவேண்டும்; இது ஒரு நிரந்தர நியமம். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","புளிப்பில்லாத அப்பத்தை ஏழுநாட்களுக்கு நீங்கள் சாப்பிடவேண்டும். முதலாம் நாளில் புளிப்பாக்கும் பொருட்கள் எல்லாவற்றையும் வீட்டிலிருந்து அகற்றவேண்டும். ஏனெனில், முதலாம் நாள் தொடங்கி, ஏழாம் நாள்வரை புளிப்பூட்டப்பட்ட எதையாவது சாப்பிடுகிறவன் எவனோ, அவன் இஸ்ரயேலில் இருந்து அகற்றப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","முதலாம் நாள் ஒரு பரிசுத்த சபையையும், ஏழாம்நாளில் இன்னுமொரு பரிசுத்த சபையையும் கூட்டுங்கள். அந்நாட்களில் எந்தவித வேலையும் செய்யக்கூடாது. நீங்கள் ஒவ்வொருவரும் சாப்பிடுவதற்குத் தேவையான உணவைத் தயாரிக்கும் வேலையை மட்டும் செய்யலாம். இதை மட்டுமே நீங்கள் செய்யலாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“புளிப்பில்லாத அப்பப்பண்டிகையை நீங்கள் கொண்டாடவேண்டும். ஏனெனில், அந்நாளில்தான் உங்கள் கோத்திரப்பிரிவுகளை எகிப்திலிருந்து வெளியே கொண்டுவந்தேன். நீங்களும், உங்கள் தலைமுறைதோறும் நிரந்தரமாக அந்நாளைக் கொண்டாடுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","முதலாம் மாதம் பதினான்காம் நாள் மாலைமுதல், அம்மாதத்தின் இருபத்தோராம் நாள் மாலைவரை புளிப்பில்லாத அப்பத்தை நீங்கள் சாப்பிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","புளிப்பூட்டும் பொருட்கள் எதுவும் ஏழுநாட்களுக்கு உங்கள் வீடுகளில் காணப்படக்கூடாது. புளிப்பூட்டப்பட்ட எதையாவது சாப்பிடும் எவனும், அவன் பிறநாட்டினனானாலும் சொந்த இஸ்ரயேலரானாலும் இஸ்ரயேல் சமுதாயத்திலிருந்து அகற்றப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","புளிப்பூட்டப்பட்ட எதையும் நீங்கள் சாப்பிடவேண்டாம். நீங்கள் எங்கே வாழ்ந்தாலும் புளிப்பில்லாத அப்பத்தையே சாப்பிடவேண்டும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","அப்பொழுது மோசே இஸ்ரயேலின் சபைத்தலைவர்கள் யாவரையும் அழைத்து, அவர்களிடம் சொன்னதாவது: “நீங்கள் உடனேபோய் உங்கள் குடும்பங்களுக்கான மிருகங்களைத் தெரிந்துகொண்டு பஸ்கா ஆட்டுக்குட்டியைக் கொல்லுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","பின்பு ஒரு கட்டு ஈசோப்புக் குழையை எடுத்து, அதைக் கிண்ணத்திலுள்ள இரத்தத்தில் தோய்த்து, அதில் சிறிதளவு இரத்தத்தைக் கதவு நிலையின் மேற்சட்டத்திலும், அதன் இரண்டு நிலைக்கால்களிலும் பூசுங்கள். காலைவரை உங்களில் ஒருவரும் வீட்டு வாசலைக் கடந்து வெளியே போகக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","யெகோவா எகிப்தியரை அழிப்பதற்காகத் தேசத்தின் வழியாகக் கடந்துசெல்வார்; அப்பொழுது உங்கள் கதவின், மேல்சட்டத்திலும், நிலைக்கால்கள் இரண்டிலும் இரத்தத்தைக் காணும்போது, அவர் அந்த வாசலைக் கடந்துபோவார், அழிப்பவன் உங்கள் வீடுகளில் புகுந்து உங்களை அழிக்க அவர் அனுமதிக்கமாட்டார். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“உங்களுக்கும் உங்கள் சந்ததிகளுக்குமான இந்த அறிவுறுத்தல்களை நிரந்தரமாகக் கைக்கொள்ளுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","யெகோவா உங்களுக்குக் கொடுப்பதாக வாக்களித்த நாட்டிற்குள் நீங்கள் செல்லும்போது, இந்த வழிபாட்டைக் கைக்கொள்ளுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","உங்கள் பிள்ளைகள் உங்களிடம், ‘இந்த வழிபாடு எதைக் குறிக்கின்றது?’ என்று கேட்பார்கள், ");
INSERT INTO tamtcv_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","அப்பொழுது நீங்கள் அவர்களிடம், ‘யெகோவா எகிப்தியரை அழிக்கும்போது எகிப்திலுள்ள இஸ்ரயேலரின் வீடுகளைக் கடந்துசென்று எங்கள் வீடுகளைத் தப்பவிட்டார். எனவே இது யெகோவாவுக்குச் செலுத்தும் பஸ்கா பலி’ என்று சொல்லுங்கள்” என்று மோசே சொன்னான். அப்பொழுது இஸ்ரயேல் மக்கள் எல்லோரும் தலைகுனிந்து இறைவனை வழிபட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","யெகோவா மோசேக்கும் ஆரோனுக்கும் கட்டளையிட்டபடியே இஸ்ரயேலர் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","அன்று நள்ளிரவு எகிப்திலுள்ள முதற்பிறந்த மகன்கள் எல்லாவற்றையும் யெகோவா அழித்தார்; அரியணையில் அமர்ந்திருந்த பார்வோனின் தலைப்பிள்ளை முதல், காவற்கிடங்கிலிருந்த கைதியின் தலைப்பிள்ளைவரை முதற்பேறுகள் அனைத்தையும், மிருகங்களின் தலையீற்றுகளையும் அழித்தார். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","பார்வோனும், அவன் அதிகாரிகள் யாவரும், எகிப்தியர் அனைவரும் அன்றிரவில் விழித்து எழுந்தனர். எகிப்தில் ஒரு பெரிய ஓலம் உண்டாயிற்று. ஏனெனில் சாவு இல்லாத ஒரு வீடும் இருக்கவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","இரவிலேயே பார்வோன் மோசேயையும் ஆரோனையும் அழைப்பித்து அவர்களிடம், “எழும்புங்கள்! என் மக்களை விட்டுவிடுங்கள், உடனே போங்கள். நீங்களும், இஸ்ரயேலரும் நீங்கள் கேட்டுக்கொண்டபடியே போய் யெகோவாவை வழிபடுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","நீங்கள் கேட்டுக்கொண்டபடியே உங்கள் ஆட்டு மந்தைகளையும் மாட்டு மந்தைகளையும் ஓட்டிக்கொண்டு போங்கள். என்னையும் ஆசீர்வதியுங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","இஸ்ரயேலரைத் தம் நாட்டைவிட்டு விரைவாய்ப் போகும்படி எகிப்தியரும் அவசரப்படுத்தினார்கள். “இல்லாவிட்டால் நாங்கள் எல்லோரும் இறந்துவிடுவோம்!” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","மக்கள் புளிப்பில்லாத பிசைந்த மாவையும், மாப்பிசையும் பாத்திரங்களையும் தங்கள் துணிகளால் சுற்றி, தங்கள் தோள்கள்மேல் சுமந்துகொண்டு போனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","மோசே அறிவுறுத்தியபடியே இஸ்ரயேலர் தங்க நகைகளையும், வெள்ளி நகைகளையும், உடைகளையும் எகிப்தியரிடம் கேட்டு வாங்கினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","யெகோவா இஸ்ரயேலருக்கு எகிப்தியரிடத்தில் தயவு கிடைக்கும்படி செய்தபடியால், அவர்கள் கேட்டதையெல்லாம் எகிப்தியர் கொடுத்தார்கள். இவ்விதமாக இஸ்ரயேலர் எகிப்தியரைக் கொள்ளையிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","அன்று இஸ்ரயேல் மக்கள் ராமசேஸை விட்டு சுக்கோத்துக்குப் புறப்பட்டுப் போனார்கள். பெண்களையும் பிள்ளைகளையும் தவிர, ஆண்கள் மட்டும் ஆறுலட்சம் பேர் இருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","அவர்களுடன் அநேக வேறு மக்கள் கூட்டமும் போனார்கள்; ஏராளமான ஆட்டு மந்தைகளும், மாட்டு மந்தைகளும் அவர்களுடன் சென்றன. ");
INSERT INTO tamtcv_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","எகிப்திலிருந்து கொண்டுவந்த பிசைந்த மாவினால் புளிப்பில்லாத அப்பங்களைச் சுட்டார்கள். அந்த மாவு புளிப்பில்லாதிருந்தது, ஏனெனில் அவர்கள் தங்களுக்கான உணவைத் தயாரிக்கும் முன்பே எகிப்திலிருந்து துரத்தப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","இஸ்ரயேலர் எகிப்தில் வாழ்ந்த காலம் நானூற்று முப்பது வருடங்களாகும். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","நானூற்று முப்பதாவது வருடம் முடிவடையும் கடைசி நாளிலே, யெகோவாவின் எல்லா கோத்திரப்பிரிவுகளும் எகிப்தைவிட்டு வெளியேறின. ");
INSERT INTO tamtcv_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","எகிப்திலிருந்து இஸ்ரயேலரை வெளியே கொண்டுவருவதற்கு, அந்த இரவு யெகோவா விழித்திருந்தபடியால், யெகோவாவை மகிமைப்படுத்தும்படி, இந்த இரவில் தலைமுறைதோறும் இஸ்ரயேலர் விழித்திருக்க வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","யெகோவா மோசேயிடமும் ஆரோனிடமும் கூறியதாவது: “பஸ்காவுக்கான விதிமுறைகள் இவையே: “பிறநாட்டினன் ஒருவனும் அதைச் சாப்பிடக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","எனினும், நீ விலைக்கு வாங்கிய எந்த அடிமையும் விருத்தசேதனம் செய்யப்பட்டபின் அதை சாப்பிடலாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","தற்காலிக குடியிருப்பாளனும் கூலியாளும் அதை சாப்பிடக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“அது ஒரு வீட்டிற்குள்ளே சாப்பிடப்பட வேண்டும்; அந்த இறைச்சியில் சிறிதளவைக்கூட வீட்டுக்கு வெளியே கொண்டுபோகக்கூடாது. எலும்புகளில் எதையாவது முறிக்கவும் கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","இஸ்ரயேல் சமுதாயம் முழுவதும் அதைக் கொண்டாடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“யெகோவாவின் பஸ்காவைக் கொண்டாட விரும்பும் உங்களுடன் வாழும் பிறநாட்டினன், தன் வீட்டிலுள்ள ஆண்களையெல்லாம் விருத்தசேதனம் செய்விக்க வேண்டும்; அதன்பின் அந்நாட்டு குடிமகனைப்போல், அதில் பங்குபெறலாம். ஆனால் விருத்தசேதனம் செய்யப்படாத எந்த ஒரு ஆணும் அதைச் சாப்பிடக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","நாட்டுக் குடிமக்களுக்கும், உங்களுடன் குடியிருக்கும் பிறநாட்டினனுக்கும் ஒரே சட்டமே இருக்கவேண்டும்.” ");
INSERT INTO tamtcv_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","யெகோவா மோசேக்கும், ஆரோனுக்கும் கட்டளையிட்டபடி இஸ்ரயேலர் எல்லோரும் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","யெகோவா அந்த நாளிலேயே இஸ்ரயேலரை அவர்களின் கோத்திரப்பிரிவுகளின்படியே, எகிப்திலிருந்து வெளியே கொண்டுவந்தார். ");
INSERT INTO tamtcv_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“முதற்பேறான எல்லா ஆண்களையும் எனக்கு அர்ப்பணம் செய்யவேண்டும். எந்த மனிதனானாலும், மிருகமானாலும் இஸ்ரயேலருக்குள் கர்ப்பத்திலிருந்து வரும் ஒவ்வொரு முதற்பேறும் எனக்குரியது” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","பின்பு மோசே இஸ்ரயேல் மக்களிடம் சொன்னதாவது, “நீங்கள் அடிமைத்தன நாடான எகிப்திலிருந்து வெளியேவந்த இந்த நாளை நினைவுபடுத்திக் கொண்டாடுங்கள். ஏனெனில் யெகோவா தமது வல்லமையான கரத்தினால் அவ்விடத்திலிருந்து உங்களை வெளியே கொண்டுவந்தார். புளிப்பூட்டப்பட்ட எதையும் சாப்பிடவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","இன்று ஆபீப் மாதத்தில் நீங்கள் புறப்படுகிறீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","யெகோவா உங்கள் முற்பிதாக்களுக்குக் கொடுப்பேன் என வாக்குப்பண்ணிய, பாலும் தேனும் வழிந்தோடும் செழிப்பான நாடான கானானியர், ஏத்தியர், எமோரியர், ஏவியர், எபூசியர் என்பவர்களுடைய நாட்டுக்கு யெகோவா உங்களைக் கொண்டுவருவார். அப்போது இந்தப் பண்டிகையை வருடந்தோறும் இதே மாதத்தில் நீங்கள் கொண்டாடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","புளிப்பில்லாத அப்பத்தை ஏழுநாட்களுக்குச் சாப்பிட்டு, ஏழாவதுநாள் யெகோவாவுக்கு பண்டிகையைக் கொண்டாடுவீர்களாக. ");
INSERT INTO tamtcv_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ஏழுநாட்களும் புளிப்பில்லாத அப்பம் சாப்பிடவேண்டும்; உங்கள் வீட்டிலோ அல்லது நாட்டின் எல்லைக்குள்ளோ புளித்தது எதுவும் காணப்படக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","அன்றையதினம் நீங்கள் உங்கள் மகன்களிடம், ‘நான் எகிப்திலிருந்து வந்தபோது யெகோவா எனக்குச் செய்தற்காகவே இதைச் செய்கிறேன்’ என்று சொல்லுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","யெகோவாவின் சட்டம் உங்கள் வாயில் இருக்கவேண்டும் என்பதற்காக, இந்த கொண்டாட்டம் உங்கள் கையில் ஒரு அடையாளம் போலவும், உங்கள் நெற்றியில் ஒரு நினைவுச்சின்னம் போலவும் இருக்கும். ஏனெனில், யெகோவா தன் பலத்த கரத்தால் உங்களை எகிப்திலிருந்து வெளியே கொண்டுவந்தார். ");
INSERT INTO tamtcv_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","ஆதலால் நீங்கள் வருடந்தோறும், குறித்த காலத்தில் இந்த நியமத்தைக் கைக்கொள்ளவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“யெகோவா உங்களுக்கும் உங்கள் முற்பிதாக்களுக்கும் கொடுப்பேன் என்று வாக்குப்பண்ணியபடி, கானானியருடைய நாட்டுக்கு உங்களைக் கொண்டுவந்து, அதை உங்களுக்குக் கொடுத்தபின்பு, ");
INSERT INTO tamtcv_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","யெகோவாவுக்கு நீங்கள் ஒவ்வொரு கர்ப்பத்தின் முதற்பிறப்புகளை கொடுக்கவேண்டும். உங்கள் கால்நடைகளில் ஆண் தலையீற்றுகளெல்லாம் யெகோவாவுக்கு உரியவை. ");
INSERT INTO tamtcv_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","கழுதையின் தலையீற்றுகளையெல்லாம் ஒரு செம்மறியாட்டுக் குட்டியால் மீட்டுக்கொள்ள வேண்டும்; மீட்காவிட்டால், அதன் கழுத்தை முறித்துப்போடுங்கள். உங்கள் மகன்களில் முதற்பேறானவனை மீட்டுக்கொள்ள வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“இனிவரும் காலத்தில் உங்கள் மகன்கள் உங்களிடம், ‘இதன் பொருள் என்ன?’ என்று கேட்கும்போது அவர்களிடம், ‘யெகோவா தமது பலத்த கரத்தினால் அடிமைத்தன நாடான எகிப்திலிருந்து எங்களை வெளியே கொண்டுவந்தார். ");
INSERT INTO tamtcv_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","பார்வோன் எங்களைப் போகவிடாமல் பிடிவாதமாய் மறுத்தபோது, யெகோவா எகிப்திலுள்ள மனிதருடைய ஒவ்வொரு முதற்பேறானதையும், மிருகத்தினுடைய ஒவ்வொரு தலையீற்றையும் கொன்றுபோட்டார். அதனால்தான் நாங்களும் ஒவ்வொரு கர்ப்பத்தின் தலையீற்றான ஆணையும் யெகோவாவுக்குப் பலியிட்டு, என் முதற்பேறான மகன்களை மீட்டுக்கொள்கிறோம்.’ ");
INSERT INTO tamtcv_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","யெகோவா தமது பலத்த கரத்தினால் எங்களை எகிப்து நாட்டிலிருந்து வெளியே கொண்டுவந்தார் என்பதற்கு, இப்பண்டிகை உங்கள் கையில் ஒரு அடையாளம் போலவும், உங்கள் நெற்றியில் ஒரு நினைவுச்சின்னம் போலவும் இருக்கும் என்று சொல்லுங்கள்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","பார்வோன் இஸ்ரயேலரைப் போகவிட்டபின்பு, பெலிஸ்தியரின் நாட்டின் வழி குறுகியதாக இருந்தபோதிலும், இறைவன் அவர்களை அதன் வழியாக நடத்திச் செல்லவில்லை. ஏனெனில், “அவர்கள் யுத்தத்தை எதிர்கொண்டால், தங்கள் மனதை மாற்றி எகிப்திற்குத் திரும்பிவிடுவார்கள்” என இறைவன் சொன்னார். ");
INSERT INTO tamtcv_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","அதனால் இறைவன் மக்களை பாலைவனப் பாதைவழியே சுற்றி, செங்கடலை நோக்கி வழிநடத்தினார். இஸ்ரயேலர் ஆயுதம் அணிந்தவர்களாய், எகிப்திலிருந்து புறப்பட்டு யுத்தத்திற்கு ஆயத்தமாய் சென்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","மோசே யோசேப்பின் எலும்புகளைத் தன்னுடன் எடுத்துச் சென்றான். ஏனெனில், யோசேப்பு இஸ்ரயேலின் மகன்களிடம் இவ்வாறு செய்யும்படி சத்தியம் வாங்கியிருந்தான். அவன் அவர்களிடம், “இறைவன் நிச்சயமாய் உங்களுக்கு உதவிக்கு வருவார்; அப்பொழுது நீங்கள் எனது எலும்புகளை இந்த இடத்திலிருந்து உங்களுடன் எடுத்துச்செல்ல வேண்டும்” என்று சொல்லியிருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","அவர்கள் சுக்கோத்திலிருந்து வெளியேறிய பின்பு, பாலைவனத்தின் அருகிலுள்ள ஏத்தாமிலே முகாமிட்டிருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","பகலில் அவர்கள் போகும் வழியாய் அவர்களுக்கு வழிகாட்ட, ஒரு மேகத்தூணாய் அவர்களுக்குமுன் யெகோவா சென்றார். இரவில் அவர்களுக்கு வெளிச்சம் கொடுப்பதற்காக, நெருப்புத்தூணாய் அவர்களுக்குமுன் சென்றார். இப்படியாக அவர்களால் இரவும் பகலும் பயணம் செய்ய முடிந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","பகலில் மேகத்தூணும், இரவில் நெருப்புத்தூணும் மக்களுக்குமுன் தன் இடத்தைவிட்டு விலகவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","பின்பு யெகோவா மோசேயிடம் சொன்னதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“நீங்கள் திரும்பிவந்து மிக்தோலுக்கும், கடலுக்கும் இடையேயுள்ள பிகாஈரோத் அருகே முகாமிடுங்கள் என்று இஸ்ரயேலருக்குச் சொல். அவர்கள் கடலருகே பாகால் செபோனுக்கு நேரெதிராக முகாமிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","‘இஸ்ரயேலர் மனங்குழம்பி நாட்டைச் சுற்றி அலைந்து திரிகிறார்கள். பாலைவனம் அவர்களைச் சூழ்ந்துகொண்டது’ என்று பார்வோன் நினைப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","எனவே, நான் பார்வோனின் மனதைக் கடினப்படுத்துவேன். அவன் உங்களைப் பின்தொடர்ந்து வருவான். நானோ பார்வோனாலும், அவனுடைய படைகள் எல்லாவற்றினாலும் மகிமையடைவேன். அப்பொழுது நானே யெகோவா என்று எகிப்தியர் அறிந்துகொள்வார்கள்” என்றார். இஸ்ரயேலர் அவ்வாறே செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","இஸ்ரயேலர் ஓடிப்போய்விட்டார்கள் என்று எகிப்திய அரசன் பார்வோனுக்கு அறிவிக்கப்பட்டபோது, அவனும் அவனுடைய அதிகாரிகளும் இஸ்ரயேலரைக் குறித்து தங்கள் மனங்களை மாற்றிக்கொண்டார்கள். அவர்கள், “நாம் என்ன செய்துவிட்டோம்? இஸ்ரயேலரை போகவிட்டு, அவர்களுடைய வேலையை இழந்துவிட்டோமே!” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","எனவே பார்வோன், தன் தேரை ஆயத்தப்படுத்தி, தன் இராணுவவீரரையும் தன்னுடன் கூட்டிச்சென்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","அவன் எகிப்திலுள்ள மற்ற எல்லா தேர்களோடு, மிகச்சிறந்த அறுநூறு தேர்களையும் மற்றும் அதிகாரிகளையும் கூட்டிக்கொண்டு போனான். ");
INSERT INTO tamtcv_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","யெகோவா எகிப்திய அரசன் பார்வோனின் மனதைக் கடினப்படுத்தினபடியால், அவன் இஸ்ரயேலரைப் பின்தொடர்ந்து சென்றான். ஆனால் இஸ்ரயேலரோ துணிவுடன் அணிவகுத்துப் போய்க்கொண்டிருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","எகிப்தியர் பார்வோனின் குதிரைகளோடும், தேர்களோடும், குதிரைவீரர்களோடும், இராணுவப்படைகளோடும் இஸ்ரயேலரைப் பின்தொடர்ந்து சென்றனர். பாகால் செபோனுக்கு எதிரே, பிகாஈரோத்துக்கு அருகே கடல் பக்கத்தில் இஸ்ரயேலர் முகாமிட்டிருந்தபோது, அவர்களை எகிப்தியர் பின்தொடர்ந்து வந்துசேர்ந்தனர். ");
INSERT INTO tamtcv_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","பார்வோன் நெருங்கி வந்தபொழுது இஸ்ரயேலர் நோக்கிப்பார்த்து, தங்களுக்குப்பின் எகிப்தியர் அணிவகுத்து வருவதைக் கண்டார்கள். அப்பொழுது அவர்கள் பயந்து, யெகோவாவை நோக்கிக் கதறினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","அவர்கள் மோசேயிடம், “எகிப்தில் பிரேதக்குழிகள் இல்லையென்று எங்களைச் சாகும்படி பாலைவனத்திற்குக் கொண்டுவந்தீரோ? எகிப்திலிருந்து எங்களைக் கொண்டுவந்து எங்களுக்கு என்ன செய்திருக்கிறீர்? ");
INSERT INTO tamtcv_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","‘எங்களைச் சும்மாவிடும்; நாங்கள் எகிப்தியருக்கு வேலைசெய்வோம்’ என்று, நாங்கள் எகிப்திலிருக்கும்போதே உமக்குச் சொல்லவில்லையா? பாலைவனத்தில் நாங்கள் சாகிறதைவிட, எகிப்தியருக்கு வேலை செய்வது நலமாயிருந்திருக்குமே!” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","மோசே இஸ்ரயேல் மக்களிடம், “பயப்படாதிருங்கள். உறுதியாய் நில்லுங்கள்; யெகோவா இன்று உங்களுக்குக் கொண்டுவரப்போகும் விடுதலையைக் காண்பீர்கள். நீங்கள் இன்று காணும் எகிப்தியரை இனி ஒருபோதும் காணமாட்டீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","யெகோவா உங்களுக்காகப் போராடுவார்; நீங்கள் அமைதியாய் மட்டும் இருங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","அப்பொழுது யெகோவா மோசேயிடம், “நீ என்னிடம் முறையிட்டு அழுவது ஏன்? இஸ்ரயேலரை முன்னேறிப்போகச்சொல். ");
INSERT INTO tamtcv_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","நீ உன் கோலை உயர்த்தி, தண்ணீரைப் பிரிக்கும்படி கடலின்மேல் உன் கையை நீட்டு. அப்பொழுது இஸ்ரயேலர் கடலின் நடுவாகக் காய்ந்த தரையில் நடந்து போகக்கூடியதாய் இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","நான் எகிப்தியரின் உள்ளத்தைக் கடினப்படுத்துவேன். அதனால் அவர்கள் இஸ்ரயேலரைப் பின்தொடருவார்கள். நானோ பார்வோனாலும், அவனுடைய எல்லா படைகள், தேர்கள், குதிரைவீரர் முதலியவற்றாலும் மகிமையடைவேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","இப்படியாக நான் பார்வோனாலும், அவன் தேர்கள், குதிரைகளாலும் மகிமையடையும்போது நானே யெகோவா என்பதை எகிப்தியர் அறிந்துகொள்வார்கள்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","அப்பொழுது இஸ்ரயேலரின் படைக்கு முன்னாகச் சென்றுகொண்டிருந்த இறைவனின் தூதனானவர், அவ்விடத்தைவிட்டு அவர்களுக்குப் பின்னாகப் போனார். அவர்களுக்கு முன்பாக இருந்த மேகத்தூணும் விலகி, அவர்களுக்குப் பின்னாக வந்துநின்றது. ");
INSERT INTO tamtcv_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","அது எகிப்திய படைகளுக்கும் இஸ்ரயேலருக்கும் இடையில் வந்துநின்றது. அந்த மேகம் இரவு முழுவதும் ஒரு பக்கத்துக்கு இருளையும், மற்றொரு பக்கத்துக்கு வெளிச்சத்தையும் கொடுத்தது. இதனால் இஸ்ரயேலரோ, எகிப்தியரோ இரவு முழுவதும் ஒருவரையொருவர் நெருங்கவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","பின்பு மோசே, கடலின்மேல் தன் கையை நீட்டினான். யெகோவா இரவு முழுவதும் பலத்த கீழ்காற்றினால் கடல்நீரைப் பின்வாங்கச்செய்து, அதை வறண்ட நிலமாக மாற்றினார். தண்ணீர் இரண்டாகப் பிரிந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","இஸ்ரயேலர் கடல் வழியாகக் காய்ந்த தரையில் நடந்து சென்றார்கள். அவர்களுடைய வலது பக்கத்திலும், இடது பக்கத்திலும் தண்ணீர் மதில்போல எழுந்து நின்றது. ");
INSERT INTO tamtcv_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","எகிப்தியர் அவர்களைத் துரத்திக்கொண்டு வந்தார்கள். பார்வோனின் எல்லா குதிரைகளும், தேர்களும், குதிரைவீரரும், இஸ்ரயேலரைப் பின்தொடர்ந்து கடலுக்குள் வந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","யெகோவா விடியற்காலையில் நெருப்புத்தூணிலும், மேகத்தூணிலுமிருந்து எகிப்திய படையைப் பார்த்து அவர்களைக் கலங்கப்பண்ணினார். ");
INSERT INTO tamtcv_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","யெகோவா அவர்களுடைய தேர்களின் சக்கரங்களைக் கழறப்பண்ணியதால், தேரை ஓட்டுவதற்கு அவர்களுக்குக் கஷ்டமாயிருந்தது. எனவே எகிப்தியர், “நாம் இஸ்ரயேலரைவிட்டு ஓடிப்போவோம், யெகோவா எகிப்தை எதிர்த்து அவர்களுக்காகப் போராடுகிறார்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","அப்பொழுது யெகோவா மோசேயிடம், “கடல் தண்ணீர் எகிப்தியர்மேலும் அவர்களுடைய தேர்கள், குதிரைவீரர்மேலும் வரும்படி நீ உன் கையை கடல்மேல் நீட்டு” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","அப்படியே மோசே தன் கையை கடலுக்கு மேலாக நீட்டினான். அதிகாலையில் கடல் தண்ணீர் திரும்பி, அதன் இடத்திற்கு வந்தது. ஆனால் எகிப்தியரோ கடலை நோக்கியே ஓடிக்கொண்டிருந்தார்கள். யெகோவா அவர்களைக் கடலின் நடுவே அமிழ்த்திவிட்டார். ");
INSERT INTO tamtcv_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","கடல் தண்ணீர் திரும்பிவந்து, தேர்களையும், குதிரைவீரர்களையும், அவர்களைப் பின்தொடர்ந்து வந்த பார்வோனின் படை முழுவதையும் கடலுக்குள் மூடிவிட்டது. அவர்களில் ஒருவனாகிலும் தப்பவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","இஸ்ரயேலரோ கடலின் நடுவேயுள்ள காய்ந்த நிலத்தின் வழியாக நடந்துபோனார்கள். அவர்களுடைய வலதுபக்கத்திலும், இடது பக்கத்திலும் தண்ணீர் மதில்போல நின்றது. ");
INSERT INTO tamtcv_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","இவ்விதமாக யெகோவா அன்றையதினம் எகிப்தியரின் கைகளிலிருந்து இஸ்ரயேலரைக் காப்பாற்றினார். கடற்கரையிலே எகிப்தியர் இறந்துகிடப்பதை இஸ்ரயேலர் கண்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","எகிப்தியருக்கு எதிராகக் காண்பிக்கப்பட்ட யெகோவாவின் வல்லமையை இஸ்ரயேலர் கண்டபோது, அவர்கள் யெகோவாவுக்குப் பயந்து, கர்த்தரிடத்திலும், அவருடைய அடியானாகிய மோசேயினிடத்திலும் நம்பிக்கை வைத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","அப்பொழுது மோசேயும் இஸ்ரயேலரும் யெகோவாவுக்குப் பாடிய பாடலாவது: “நான் யெகோவாவைப் பாடுவேன், அவர் மிகவும் புகழ்ந்து உயர்த்தப்பட்டிருக்கிறார். குதிரையையும், அதை ஓட்டியவனையும் அவர் கடலுக்குள் வீசியெறிந்தார். ");
INSERT INTO tamtcv_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","“யெகோவா என் பெலனும், என் பாடலுமாயிருக்கிறார், அவரே என் இரட்சிப்புமானார். அவர் என் இறைவன், அவரைத் துதிப்பேன். அவர் என் தந்தையின் இறைவன், அவரை நான் உயர்த்துவேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","யெகோவா யுத்தத்தில் வீரர்; யெகோவா என்பதே அவரது பெயர். ");
INSERT INTO tamtcv_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","அவர் பார்வோனின் தேர்களையும், அவனுடைய இராணுவத்தையும் கடலுக்குள் தள்ளிவிட்டார். பார்வோனின் அதிகாரிகளில் சிறந்தவர்கள் செங்கடலில் அழிந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","ஆழமான தண்ணீர் அவர்களை மூடியது; ஒரு கல்லைப்போல் ஆழத்திலே அவர்கள் அமிழ்ந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","யெகோவாவே, உமது வலதுகரம் வல்லமையில் மாட்சிமையாய் இருந்தது. யெகோவாவே, உமது வலதுகரமே எதிரியை நொறுக்கியது. ");
INSERT INTO tamtcv_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","“உமது மாட்சிமையின் மகத்துவத்தினால் உம்மை எதிர்த்தவர்களை கீழே விழத்தள்ளினீர். உமது எரியும் கோபத்தைக் கட்டவிழ்த்தீர்; அது அவர்களை வைக்கோலைப்போல் எரித்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","உமது நாசியின் சுவாசத்தினால் தண்ணீர் குவிந்தது. பொங்கியெழும் வெள்ளங்கள் மதிலைப்போல உறுதியாய் நின்றன; ஆழத்தின் தண்ணீர் கடலின் அடியில் உறைந்துபோயிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","பகைவன் பெருமையாக, ‘நான் பின்தொடர்வேன், அவர்களைப் பிடிப்பேன். நான் கொள்ளையைப் பங்கிடுவேன்; அவர்களில் என் ஆசையைத் தீர்த்துக்கொள்வேன். என் வாளை உருவுவேன், என் கை அவர்களை அழிக்கும்’ என பேசினான். ");
INSERT INTO tamtcv_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","ஆனால், நீரோ உமது சுவாசத்தை ஊதினீர், கடல் அவர்களை மூடியது. அவர்கள் ஈயத்தைப் போல் பெரும் தண்ணீர்களுக்குள் அமிழ்ந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","யெகோவாவே, தெய்வங்களுக்குள் உம்மைப்போல் யார் உண்டு? பரிசுத்தத்தில் மாட்சிமையும், மகிமையில் வியக்கத்தக்கவரும், அதிசயங்களையும் செய்கிற உம்மைப்போல் யார் உண்டு? ");
INSERT INTO tamtcv_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","“உமது வலது கரத்தை நீட்டினீர், பூமி அவர்களை விழுங்கிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","நீர் மீட்டுக்கொண்ட மக்களை உமது நேர்மையான அன்பினால் வழிநடத்துவீர். நீர் வசிக்கும் பரிசுத்த இடத்திற்கு, உமது வல்லமையினால் அவர்களுக்கு வழிகாட்டுவீர். ");
INSERT INTO tamtcv_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","மக்கள் அதைக்கேட்டு நடுங்குவார்கள்; பெலிஸ்திய மக்களை வேதனை பற்றிக்கொள்ளும். ");
INSERT INTO tamtcv_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ஏதோமின் தலைவர்கள் திகிலடைவார்கள், மோவாபின் தலைவர்களை நடுக்கம் பிடிக்கும், கானானின் மக்களும் கரைந்து போவார்கள்; ");
INSERT INTO tamtcv_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","பயமும் திகிலும் அவர்கள்மேல் வரும். யெகோவாவே, உமது மக்கள் கடந்துபோகும்வரை, நீர் கொண்டுவந்த மக்கள் கடந்துபோகும்வரை, உமது கரத்தின் வல்லமையால் அவர்கள் கல்லைப்போல் அசைவில்லாமல் கிடப்பார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","யெகோவாவே, உமது உரிமைச்சொத்தான மலையில் நீர் அவர்களைக் கொண்டுவந்து நிலைநாட்டுவீர்; அந்த இடத்தையே நீர் உமது தங்குமிடமாக்கினீர், யெகோவாவே, உமது கைகளே அதைப் பரிசுத்த இடமாக ஏற்படுத்தியது. ");
INSERT INTO tamtcv_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“யெகோவா என்றென்றைக்கும் அரசாளுவார்.” ");
INSERT INTO tamtcv_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","பார்வோனின் குதிரைகள் தேர்களோடும், குதிரைவீரர்களோடும் கடலுக்குள் சென்றன. அப்பொழுது யெகோவா கடல் தண்ணீரைத் திருப்பி அவர்கள்மேல் கொண்டுவந்தார்; ஆனால் இஸ்ரயேலரோ கடல் வழியாகக் காய்ந்த தரையில் நடந்துபோனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","அப்பொழுது இறைவாக்கினளான ஆரோனின் சகோதரி மிரியாம், தன் கையில் ஒரு தம்புராவை எடுத்துக்கொண்டாள்; மற்ற எல்லா பெண்களும் தம்புராவோடும் நடனத்தோடும் அவளைப் பின்தொடர்ந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","அப்பொழுது மிரியாம் அவர்களுக்குப் பதிலளித்துப் பாடியது: “யெகோவாவைப் பாடுங்கள், ஏனெனில் அவர் உன்னதத்தில் புகழ்ந்து உயர்த்தப்பட்டிருக்கிறார். குதிரையையும் அதை ஓட்டியவனையும் கடலிலே வீசியெறிந்தார்.” ");
INSERT INTO tamtcv_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","அதன்பின் மோசே இஸ்ரயேலரைச் செங்கடலிலிருந்து சூர் பாலைவனத்திற்கு நடத்திச் சென்றான். அவர்கள் மூன்று நாட்களாக பாலைவனத்தில் பயணம் செய்தார்கள், அவர்களுக்குத் தண்ணீர் கிடைக்கவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","அவர்கள் மாரா என்னும் இடத்திற்கு வந்தபோது, அவ்விடத்திலுள்ள தண்ணீர் கசப்பாயிருந்தபடியால், அவர்களால் அதைக் குடிக்க முடியவில்லை. அதனால்தான் அந்த இடம் மாரா என அழைக்கப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","எனவே இஸ்ரயேல் மக்கள், “நாங்கள் எதைக் குடிப்போம்?” என்று கேட்டு மோசேக்கு எதிராக முறுமுறுத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","மோசே யெகோவாவிடம் அழுது விண்ணப்பித்தான், அப்பொழுது யெகோவா மோசேக்கு ஒரு மரத்தைக் காட்டினார். அவன் அதைத் தண்ணீருக்குள் எறிந்தபோது, தண்ணீர் இனிமையாக மாறியது. பின்பு யெகோவா ஒரு விதிமுறையையும், ஒரு சட்டத்தையும் ஏற்படுத்தி, அங்கே அவர்களைச் சோதித்தார். ");
INSERT INTO tamtcv_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","அவர், “நீங்கள் உங்கள் இறைவனாகிய யெகோவாவின் குரலுக்குக் கவனமாய்ச் செவிகொடுத்து, அவருடைய பார்வையில் சரியானதைச் செய்து, அவருடைய கட்டளைகளைக் கவனித்து, அவருடைய எல்லா விதிமுறைகளையும் கைக்கொண்டு நடப்பீர்களானால், நான் எகிப்தியர்மேல் கொண்டுவந்த வியாதிகளில் எதையும் உங்கள்மேல் கொண்டுவரமாட்டேன்; ஏனெனில் நானே உங்களைச் சுகமாக்குகிற யெகோவா” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","அதன்பின் அவர்கள் ஏலிமுக்கு வந்தார்கள், அங்கே பன்னிரண்டு நீரூற்றுக்களும் எழுபது பேரீச்சமரங்களும் இருந்தன; அவர்கள் அங்கே தண்ணீர் அருகே முகாமிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","அதன் பின்னர் முழு இஸ்ரயேல் சமுதாயமும் ஏலிமிலிருந்து புறப்பட்டு, அவர்கள் எகிப்திலிருந்து வெளியேறிய இரண்டாம் மாதம் பதினைந்தாம்நாள் ஏலிமுக்கும் சீனாய்க்கும் இடையேயுள்ள சீன் பாலைவனத்தை வந்தடைந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","அப்பாலைவனத்திலே இஸ்ரயேல் சமுதாயம் முழுவதும் மோசேக்கும் ஆரோனுக்கும் விரோதமாக முறுமுறுத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","இஸ்ரயேலர் அவர்களிடம், “நாங்கள் யெகோவாவின் கையால் எகிப்திலே இறந்திருக்கலாமே! நாங்களோ அங்கே இறைச்சிப் பானைகளைச் சுற்றி உட்கார்ந்து, விரும்பிய உணவையெல்லாம் சாப்பிட்டோம்; ஆனால் நீங்கள், இந்த முழு மக்கள் கூட்டமும் பட்டினியாய்ச் சாகும்படி இந்தப் பாலைவனத்திற்குள் எங்களைக் கொண்டுவந்திருக்கிறீர்கள்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","அப்பொழுது யெகோவா மோசேயிடம் சொன்னதாவது: “நான் வானத்திலிருந்து உங்களுக்கு அப்பத்தைப் பொழிவேன். இந்த மக்கள் ஒவ்வொரு நாளும் வெளியே போய் அந்நாளுக்குப் போதுமானதைச் சேர்க்கவேண்டும். அதன்மூலம் அவர்கள் என் அறிவுறுத்தலின்படி நடப்பார்களோ இல்லையோ என்று அவர்களைப் சோதித்துப் பார்ப்பேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ஆறாம்நாளிலோ, மற்றநாட்களில் சேர்ப்பதுபோல் இருமடங்கு சேர்க்கவேண்டும். அந்த நாளிலே அவர்கள் எடுத்துவந்ததைத் தயாரித்து வைக்கவேண்டும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","ஆகவே, மோசேயும் ஆரோனும் இஸ்ரயேலரிடம், “யெகோவாவே உங்களை எகிப்திலிருந்து கொண்டுவந்தார் என்பதை இன்று மாலையில் நீங்கள் அறிந்துகொள்வீர்கள், ");
INSERT INTO tamtcv_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","காலையிலோ யெகோவாவின் மகிமையைக் காண்பீர்கள்; ஏனெனில் அவருக்கு விரோதமான உங்கள் முறுமுறுப்பை அவர் கேட்டார். நீங்கள் எங்களுக்கு விரோதமாய் முறுமுறுப்பதற்கு நாங்கள் யார்?” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","மேலும் மோசே அவர்களிடம், “மாலையில் நீங்கள் சாப்பிடுவதற்கு இறைச்சியையும், காலையில் வேண்டிய அளவு அப்பத்தையும் தருவார்; ஏனெனில் அவருக்கு எதிரான உங்கள் முறுமுறுப்பை யெகோவா கேட்டிருக்கிறார். அப்பொழுது நீங்கள் யெகோவாவே இதைத் தருகிறார் என்பதை அறிந்துகொள்வீர்கள். நீங்கள் எங்களுக்கு எதிராக அல்ல, யெகோவாவுக்கு எதிராகவே முறுமுறுக்கிறீர்கள். எங்களுக்கு எதிராய் முறுமுறுக்க நாங்கள் யார்?” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","அதன்பின் மோசே ஆரோனிடம் சொன்னதாவது: “நீ முழு இஸ்ரயேல் சமுதாயத்தினரிடமும், ‘எல்லோரும் யெகோவாவுக்கு முன்பாக வாருங்கள். ஏனெனில் அவர் உங்கள் முறுமுறுப்புகளைக் கேட்டிருக்கிறார்’ என்று சொல்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","ஆரோன் முழு இஸ்ரயேல் சமுதாயத்தோடும் பேசிக்கொண்டிருக்கும் வேளையில், அவர்கள் பாலைவனத்தை நோக்கிப் பார்த்தபோது, யெகோவாவின் மகிமை மேகத்திலே தோன்றியது. ");
INSERT INTO tamtcv_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","அப்பொழுது யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“நான் இஸ்ரயேலருடைய முறுமுறுப்புகளைக் கேட்டேன். நீ அவர்களிடம், ‘நீங்கள் மாலையில் இறைச்சியைச் சாப்பிட்டு, காலையில் அப்பத்தினால் திருப்தியாவீர்கள். அப்பொழுது நானே உங்கள் இறைவனாகிய யெகோவா என்று அறிந்துகொள்வீர்கள்’ என்று சொல்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","அந்த மாலை வேளையிலேயே காடைகள் வந்து அவர்கள் முகாமை மூடிக்கொண்டன. காலையில் முகாமைச் சுற்றி ஒரு பனிப்படலம் படிந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","பனி விலகிய பின்பு, தரையின்மீது உறைபனி போன்ற மெல்லிய துகள்கள் பாலைவனத்தில் காணப்பட்டன. ");
INSERT INTO tamtcv_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","அதை இஸ்ரயேலர் கண்டபோது, ஒருவரையொருவர் பார்த்து, “இது என்ன?” என்றார்கள். ஏனெனில், அது என்ன என்பது அவர்களுக்குத் தெரியாதிருந்தது. அப்பொழுது மோசே அவர்களிடம், “இதுதான் நீங்கள் உண்பதற்காக யெகோவா கொடுத்திருக்கும் அப்பம். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","யெகோவா கட்டளையிட்டிருப்பது இதுவே: ‘ஒவ்வொருவரும் தான் சாப்பிடக்கூடியதைச் சேர்த்துக்கொள்ளவேண்டும். உங்கள் கூடாரத்தில் உள்ளவர்களில் ஒருவருக்கு ஒரு ஓமர் அளவுப்படி, ஒவ்வொருவரும் எடுத்துக்கொள்ளுங்கள்’ ” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","இஸ்ரயேலர் தங்களுக்குச் சொல்லப்பட்டபடியே செய்தார்கள். சிலர் அதிகமாகவும், சிலர் குறைவாகவும் சேர்த்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","அவர்கள் சேர்த்தவற்றை ஓமரால் அளந்த போது அதிகமாகச் சேர்த்தவனிடம் தேவைக்கதிகமாக இருந்ததில்லை, குறைவாகச் சேர்த்தவனிடம் போதாமல் இருக்கவுமில்லை. ஒவ்வொருவரும் தனக்குவேண்டிய அளவையே சேர்த்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","அப்பொழுது மோசே அவர்களிடம், “ஒருவரும் மறுநாள் காலைவரை அதில் எதையும் வைத்திருக்கக்கூடாது” என்று சொன்னான். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","ஆனாலும் சிலர் மோசே சொன்னதைப் பொருட்படுத்தவில்லை. அவர்கள் காலைவரை அதிலொரு பகுதியை வைத்திருந்தார்கள். அது புழுப்பிடித்து நாற்றமெடுத்தது. மோசே அவர்கள்மீது கோபங்கொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","காலைதோறும் ஒவ்வொருவனும் தனக்குத் தேவையான அளவைச் சேர்த்தான். வெயில் ஏறினபோது அது உருகிப்போனது. ");
INSERT INTO tamtcv_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ஆறாம்நாளில் ஒவ்வொருவரும் ஒருவனுக்கு இரண்டு ஓமர் வீதம் இருமடங்கு உணவைச் சேர்த்தார்கள். சமுதாயத்தின் தலைவர்கள் இதை மோசேக்கு அறிவித்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","அப்பொழுது மோசே அவர்களிடம், “யெகோவா உங்களுக்குக் கட்டளையிட்டது இதுவே: நாளைய தினம் ஓய்ந்திருக்கும் ஒரு நாளாக யெகோவாவுக்குப் பரிசுத்த ஓய்வுநாளாய் இருக்கவேண்டும். எனவே, இன்றே சுடவேண்டியதை சுட்டு, அவிக்கவேண்டியதை அவித்துக்கொள்ளுங்கள். நீங்கள் சாப்பிட்டபின் மீதியானதை காலைவரை வையுங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","மோசே கட்டளையிட்டபடியே காலைவரை அதைச் சேமித்து வைத்தார்கள். அது நாற்றமெடுக்கவோ, புழுப்பிடிக்கவோ இல்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","அப்பொழுது மோசே இஸ்ரயேலரிடம், “இன்றைக்கே அதைச் சாப்பிடுங்கள். ஏனெனில் இன்றைய நாள் யெகோவாவுக்குரிய ஓய்வுநாளாய் இருக்கிறது. இன்று நீங்கள் எதையும் நிலத்திலே காணமாட்டீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","நீங்கள் ஆறு நாட்களும் அதைச் சேர்க்கவேண்டும். ஓய்வுநாளாகிய ஏழாம் நாளிலே அது கிடைக்காது” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ஆனாலும் மக்களில் சிலர் ஏழாம்நாள் அவற்றைச் சேர்ப்பதற்குப் போனபோது, அவர்கள் ஒன்றையும் காணவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","அப்பொழுது யெகோவா மோசேயிடம், “நீங்கள் எவ்வளவு காலத்திற்கு என் கட்டளைகளையும், அறிவுறுத்தல்களையும் கைக்கொள்ள மறுப்பீர்கள்? ");
INSERT INTO tamtcv_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","யெகோவா உங்களுக்கு ஓய்வுநாளைக் கொடுத்திருப்பதை மனதில் வைத்திருங்கள். அதனால்தான் ஆறாம்நாளில் இரண்டு நாட்களுக்குரிய அப்பத்தை அவர் உங்களுக்குக் கொடுக்கிறார். ஆகையால் ஏழாம்நாளில் நீங்கள் ஒவ்வொருவரும் இருக்கும் இடத்திலேயே இருக்கவேண்டும், ஒருவரும் வெளியே போகக்கூடாது” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","எனவே மக்கள் ஏழாம்நாளில் ஓய்ந்திருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","இஸ்ரயேல் மக்கள் அந்த அப்பத்தை மன்னா என்று அழைத்தார்கள். அது கொத்தமல்லி விதையைப்போல வெள்ளையாகவும், தேனில் தயாரித்த பணியாரத்தின் சுவையுள்ளதாகவும் இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","அப்பொழுது மோசே இஸ்ரயேல் மக்களிடம், “யெகோவா உங்களுக்குக் கட்டளையிட்டிருப்பது இதுவே: நான் உங்களை எகிப்திலிருந்து வெளியே கொண்டுவந்தபோது, நான் உங்களுக்குப் பாலைவனத்தில் சாப்பிடக்கொடுத்த அப்பத்தை, வரப்போகும் உங்கள் தலைமுறையினருக்குக் காட்டுவதற்காக, அந்த மன்னாவில் ஒரு ஓமர் அளவு எடுத்து வைத்துக்கொள்ளுங்கள் என்கிறார்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","மேலும் மோசே ஆரோனிடம், “நீ ஒரு ஜாடியை எடுத்து, ஒரு ஓமர் அளவு மன்னாவை அதற்குள் போடு. பின், வரப்போகும் தலைமுறையினருக்காக யெகோவாவுக்கு முன்பாக அதை வை” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","யெகோவா மோசேக்குக் கட்டளையிட்டபடியே ஆரோன் வரப்போகும் காலங்களுக்காக மன்னாவை எடுத்து சாட்சிப்பெட்டியின் முன் வைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","இஸ்ரயேலர் தாங்கள் குடியேறவேண்டிய நாட்டிற்கு வரும்வரைக்கும் நாற்பது வருடமாக மன்னாவையே சாப்பிட்டார்கள். கானானின் எல்லைக்கு வரும்வரை மன்னாவையே சாப்பிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","ஒரு ஓமர் என்பது எப்பா அளவின் பத்தில் ஒரு பங்கு ஆகும். ");
INSERT INTO tamtcv_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","இஸ்ரயேல் சமுதாயம் முழுவதும் சீன் பாலைவனத்திலிருந்து புறப்பட்டு, யெகோவாவின் கட்டளைப்படி ஒரு இடத்திலிருந்து இன்னொரு இடத்திற்கு பயணம் செய்தார்கள். பின்பு ரெவிதீம் என்னும் இடத்திற்கு வந்து அங்கே முகாமிட்டார்கள். அங்கே அவர்களுக்குக் குடிப்பதற்குத் தண்ணீர் கிடைக்கவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","அதனால் இஸ்ரயேலர் மோசேயுடன் வாக்குவாதம் செய்து, “குடிப்பதற்கு எங்களுக்குத் தண்ணீர் தாரும்” என்றார்கள். அப்பொழுது மோசே அவர்களிடம், “என்னோடு ஏன் வாக்குவாதம் செய்கிறீர்கள்? யெகோவாவை ஏன் சோதிக்கிறீர்கள்?” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","ஆனால் மக்கள் மிகவும் தாகமாயிருந்ததினால் மோசேக்கு விரோதமாய் முறுமுறுத்தார்கள். அவர்கள் அவனிடம், “எங்களையும், எங்கள் பிள்ளைகளையும், எங்கள் வளர்ப்பு மிருகங்களையும் தாகத்தினால் சாகும்படி, ஏன் எங்களை எகிப்திலிருந்து வெளியே கொண்டுவந்தீர்?” என்று கேட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","அப்பொழுது மோசே யெகோவாவை நோக்கிக் கூப்பிட்டு, “நான் இந்த மக்களுக்கு என்ன செய்வேன்? அவர்கள் என்னைக் கல்லெறிய ஆயத்தமாயிருக்கிறார்களே” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","அப்பொழுது யெகோவா மோசேயிடம், “இஸ்ரயேலின் சபைத்தலைவர்களில் சிலரை உன்னுடன் கூட்டிக்கொண்டு மக்களுக்கு முன்பாக நட. நீ நைல் நதியை அடித்த கோலை கையில் எடுத்துக்கொண்டு போ. ");
INSERT INTO tamtcv_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","நான் ஓரேபிலுள்ள கற்பாறையின் அருகே உனக்கு முன்பாக அங்கே நிற்பேன். நீ கற்பாறையை அடி. அப்பொழுது மக்கள் குடிப்பதற்கு அதிலிருந்து தண்ணீர் வெளிவரும்” என்றார். மோசே அவ்விதமே இஸ்ரயேலின் சபைத்தலைவர்கள் முன்னிலையில் செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","இஸ்ரயேலர்கள், “யெகோவா எங்களுடன் இருக்கிறாரா? இல்லையா?” என்று கேட்டு யெகோவாவைப் சோதித்தபடியால் அந்த இடத்திற்கு மாசா என்றும், அவர்கள் வாதாடினபடியால் மேரிபா என்றும் மோசே பெயரிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","அதன்பின் அமலேக்கியர் வந்து ரெவிதீமிலே இஸ்ரயேலரைத் தாக்கினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","அப்பொழுது மோசே யோசுவாவிடம், “எங்கள் மனிதரில் சிலரைத் தெரிந்துகொண்டு அமலேக்கியரோடு சண்டை செய்ய வெளியே போ. நான் நாளை என் கையில் இறைவனின் கோலைப் பிடித்துக்கொண்டு மலையுச்சியில் நிற்பேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","மோசே உத்தரவிட்டபடியே யோசுவா அமலேக்கியருடன் போரிட்டான். மோசேயும், ஆரோனும், ஊர் என்பவனும் மலையுச்சிக்குப் போனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","மோசே தன் கைகளை உயர்த்திக்கொண்டிருக்கும்வரை, இஸ்ரயேலர் வென்றுகொண்டிருந்தார்கள். ஆனால் மோசே தன் கைகளைக் கீழே விடும்பொழுதோ, அமலேக்கியர் வெல்லத்தொடங்கினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","மோசேயின் கைகள் தளர்ந்துபோயின. அப்போது ஆரோனும், ஊரும் ஒரு கல்லை எடுத்து அவனுக்குக் கீழே வைத்தார்கள். அவன் அதன்மேல் உட்கார்ந்தான். ஆரோனும், ஊரும் ஒரு பக்கம் ஒருவனும், மறுபக்கம் மற்றவனுமாக அவனுடைய கைகளை உயர்த்தித் தாங்கிப் பிடித்துக்கொண்டார்கள். அதனால் சூரியன் மறையும்வரை அவன் கைகள் உறுதியாயிருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","எனவே யோசுவா வாளினால் அமலேக்கியப் படையை மேற்கொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","அதன்பின் யெகோவா மோசேயிடம், “இன்று நடந்தது நினைவிற்கொள்வதற்காக இதை ஒரு புத்தகச்சுருளில் எழுதி, அதை யோசுவா கேட்கும்படி சொல். ஏனெனில், நான் வானத்தின் கீழிருந்து அமலேக்கியரைப் பற்றிய நினைவையே இல்லாது போகும்படி அழித்துவிடுவேன் என்று சொல்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","மோசே அங்கே ஒரு பலிபீடத்தைக் கட்டி அவ்விடத்திற்கு யெகோவா என் வெற்றிக்கொடி என்று பெயரிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","பின்பு மோசே, “யெகோவாவினுடைய அரியணைக்கு விரோதமாக அமலேக்கின் கரங்கள் உயர்த்தப்பட்டிருந்தபடியால், தலைமுறை தலைமுறைதோறும் யெகோவா அமலேக்கியருக்கு எதிராக யுத்தம் செய்வார்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","இறைவன் மோசேக்கும் தம் மக்களான இஸ்ரயேலருக்கும் செய்தவற்றை மீதியானின் ஆசாரியனான மோசேயின் மாமன் எத்திரோ கேள்விப்பட்டான். அத்துடன் எகிப்திலிருந்து யெகோவா அவர்களை எவ்வாறு வெளியே கொண்டுவந்தார் என்பதையும் கேள்விப்பட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","மோசேயின் மாமன் எத்திரோ, மோசேயால் அனுப்பிவிடப்பட்டிருந்த அவன் மனைவி சிப்போராளையும், ");
INSERT INTO tamtcv_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","அவனுடைய இரு மகன்களையும் ஏற்றுக்கொண்டான். மோசே, நான் அயல்நாட்டில் ஒரு அயல்நாட்டினர் என்று சொல்லி ஒரு மகனுக்கு கெர்சோம் என்று பெயரிட்டிருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","என் முற்பிதாக்களின் இறைவன் எனக்குத் துணைநின்று பார்வோனின் வாளுக்கு என்னைத் தப்புவித்தார் என்று சொல்லி மற்றவனுக்கு எலியேசர் என்று பெயரிட்டிருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","இப்பொழுது மோசேயின் மாமனாகிய எத்திரோ, மோசேயின் மகன்களையும் மனைவியையும் கூட்டிக்கொண்டு பாலைவனத்துக்கு வந்தான். மோசே இறைவனின் மலையருகே முகாமிட்டிருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","“உம்முடைய மாமனாகிய எத்திரோவாகிய நான் உம்முடைய மனைவியுடனும், அவளுடைய இரு மகன்களுடனும் உம்மிடத்திற்கு வருகிறேன்” என்று எத்திரோ மோசேக்குச் சொல்லியனுப்பினான். ");
INSERT INTO tamtcv_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","எனவே மோசே தன் மாமனைச் சந்திப்பதற்காக போய், அவனை வணங்கி முத்தமிட்டான். அவர்கள் ஒருவரை ஒருவர் வாழ்த்தி, பின்பு மோசேயின் கூடாரத்திற்குள் போனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","அப்பொழுது யெகோவா இஸ்ரயேலருக்காக பார்வோனுக்கும், எகிப்தியருக்கும் செய்த எல்லாவற்றையும் மோசே தன் மாமனுக்குச் சொன்னான். வழியிலே தாங்கள் அனுபவித்த கஷ்டங்களையும், யெகோவா எப்படித் தங்களைக் காப்பாற்றினார் என்பதையும் சொன்னான். ");
INSERT INTO tamtcv_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","இஸ்ரயேலரை எகிப்தியரின் கைகளிலிருந்து தப்புவித்து, அவர்களுக்கு யெகோவா செய்த நன்மைகள் எல்லாவற்றையும் கேள்விப்பட்ட எத்திரோ மகிழ்ச்சியடைந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","அப்பொழுது எத்திரோ, “யெகோவாவுக்குத் துதி உண்டாவதாக. அவர் உன்னையும் இஸ்ரயேலரையும் எகிப்தியரின் கைகளிலிருந்தும், பார்வோனின் கைகளிலிருந்தும் தப்புவித்தாரே. ");
INSERT INTO tamtcv_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","‘எல்லா தெய்வங்களையும்விட யெகோவாவே பெரியவர்’ என்பதை நான் இப்பொழுது அறிந்துகொண்டேன். ஏனெனில், இஸ்ரயேலரை இறுமாப்பாய் நடத்தியவர்களுக்கு அவர் இப்படிச் செய்தாரே” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","மோசேயின் மாமன் எத்திரோ இறைவனுக்குத் தகன காணிக்கையையும் மற்றப் பலிகளையும் கொண்டுவந்தான். அப்பொழுது ஆரோனும் இஸ்ரயேலின் சபைத்தலைவர்களும் இறைவனுக்கு முன்பாக மோசேயின் மாமனுடன் அப்பம் சாப்பிடும்படி வந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","மறுநாள் மோசே இஸ்ரயேலரின் நீதிபதியாகப் பணிசெய்ய தனது இருக்கையில் உட்கார்ந்தான். காலையிலிருந்து, மாலைவரை மக்கள் மோசேயைச் சுற்றி நின்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","மோசே இஸ்ரயேலருக்குச் செய்யும் எல்லாவற்றையும் கண்ட மோசேயின் மாமன் அவனிடம், “மக்களுக்கு நீ செய்யும் காரியம் என்ன? மக்கள் காலைமுதல் மாலைவரை உன்னைச் சுற்றி நிற்க நீ ஏன் தனியாக நீதிபதியாய் இருக்கிறாய்?” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","அதற்கு மோசே தன் மாமனிடம், “மக்கள் தங்கள் பிரச்சனைக்கு இறைவனின் திட்டத்தை அறிந்துகொள்ளவே என்னிடம் வருகிறார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","அவர்களுக்குள் ஏதாவது பிரச்சனைகள் ஏற்பட்டால், அதை என்னிடத்தில் கொண்டுவருகிறார்கள். அப்பொழுது நான் இரு பகுதியினருக்கும் இடையில் நியாயந்தீர்த்து இறைவனின் விதிமுறைகளையும், அவருடைய சட்டங்களையும் அவர்களுக்குத் தெரிவிப்பேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","அதற்கு மோசேயின் மாமன், “நீ செய்வது நல்லதல்ல; ");
INSERT INTO tamtcv_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","இப்படிச் செய்வதினால் நீயும், உன்னிடத்தில்வரும் இந்த மக்களும் களைத்துச் சோர்ந்து போவீர்கள். இந்த வேலை உனக்கு மிகவும் கடினமானது. இதைத் தனியே செய்ய உன்னால் முடியாது. ");
INSERT INTO tamtcv_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","இப்பொழுது நான் சொல்வதைக் கேள். நான் உனக்கு சில புத்திமதிகளைச் சொல்வேன். இறைவன் உன்னோடு இருப்பாராக. நீ இறைவனுக்கு முன்பாக இந்த மக்களின் பிரதிநிதியாக இருந்து, அவர்களுடைய வழக்குகளை அவரிடம் கொண்டுபோக வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","நீ அவர்களுக்கு இறைவனின் விதிமுறைகளையும், சட்டங்களையும் போதிக்கவேண்டும். அவர்கள் வாழவேண்டிய வழியையும், அவர்கள் செய்யவேண்டிய கடமைகளையும் அவர்களுக்குக் காட்டவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","ஆகவே இஸ்ரயேலருக்குள் திறமையுள்ள மனிதரைத் தெரிந்தெடுத்து, அவர்களை ஆயிரம்பேருக்கும், நூறுபேருக்கும், ஐம்பதுபேருக்கும், பத்துப்பேருக்கும் மேலாக அதிகாரிகளாக நியமிக்கவேண்டும். இவர்கள் இறைவனுக்குப் பயப்படுகிறவர்களாகவும், நீதியற்ற ஆதாயத்தை வெறுக்கிற நம்பத்தகுந்தவர்களாகவும் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","இவர்களை எல்லா வேளைகளிலும் மக்களுக்கு நீதிபதிகளாக பணிசெய்யும்படி ஏற்படுத்து. ஆனால் ஒவ்வொரு கஷ்டமான வழக்குகளையும் அவர்கள் உன்னிடத்தில் கொண்டுவர ஏற்பாடு செய்யவேண்டும். இலகுவான வழக்குகளை அவர்கள் தாங்களே நியாயந்தீர்க்கலாம். அவர்கள் உன்னோடு உன் பொறுப்பைப் பகிர்ந்து கொள்வதால் உனது சுமை இலகுவாகும். ");
INSERT INTO tamtcv_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","இறைவன் கட்டளையிடுகிறவிதமாக இதை நீ செய்தால், அந்த வேலைப்பளுவை உன்னால் சமாளிக்க முடியும். இந்த மக்களும் திருப்தியுடன் தங்கள் வீடுகளுக்குப் போவார்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","மோசேயும் தன் மாமனுக்கு செவிகொடுத்து, அவன் சொன்ன எல்லாவற்றையும் செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","மோசே இஸ்ரயேலரின் திறமையுள்ள மனிதரைத் தெரிந்து, அவர்களை மக்களுக்குத் தலைவர்களாகவும் ஆயிரம்பேருக்கும், நூறுபேருக்கும், ஐம்பதுபேருக்கும், பத்துப்பேருக்கும் அதிகாரிகளாகவும் நியமித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","எல்லா வேளைகளிலும் அவர்கள் மக்களுக்கு நீதிபதிகளாகப் பணிசெய்தார்கள். கஷ்டமான வழக்குகளை அவர்கள் மோசேயிடம் கொண்டுவந்தார்கள். இலகுவான வழக்குகளை தாங்களே தீர்த்துக் கொண்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","பின் மோசே தன் மாமன் எத்திரோவை வழியனுப்பினான், எத்திரோ தன் நாட்டுக்குத் திரும்பிப்போனான். ");
INSERT INTO tamtcv_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","இஸ்ரயேலர் எகிப்தைவிட்டு வெளியேறிய மூன்றாம் மாதம் முடிந்த அதே நாளில், அவர்கள் சீனாய் பாலைவனத்தை வந்தடைந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ரெவிதீமைவிட்டுப் புறப்பட்டபின் அவர்கள் சீனாய் பாலைவனத்துக்குள் வந்தார்கள். இஸ்ரயேலர் மலைக்கு முன்பாக உள்ள அந்த பாலைவனத்தில் முகாமிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","அப்பொழுது மோசே மேலே ஏறி இறைவனிடம் போனான். மலையிலிருந்து யெகோவா அவனைக் கூப்பிட்டுச் சொன்னதாவது: “யாக்கோபின் குடும்பத்தாருக்கும், இஸ்ரயேல் மக்களுக்கும் நீ சொல்லவேண்டியது இதுவே: ");
INSERT INTO tamtcv_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘நான் எகிப்திற்குச் செய்தவற்றை நீங்கள் கண்டிருக்கிறீர்கள். கழுகு தன் குஞ்சுகளைத் தன் சிறகுகளின்மேல் சுமந்து வருவதுபோல், நானும் உங்களை என்னிடத்தில் சேர்த்துக்கொண்டதையும் நீங்களே கண்டிருக்கிறீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","ஆகையால் இப்பொழுது நீங்கள் எனக்கு முழுவதும் கீழ்ப்படிந்து, என் உடன்படிக்கையை கைக்கொண்டால், எல்லா நாட்டினருக்குள்ளும் நீங்களே எனது அரும்பெரும் செல்வமாய் இருப்பீர்கள். பூமி முழுவதும் என்னுடையதாயிருந்தாலும் கூட, ");
INSERT INTO tamtcv_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","நீங்களோ எனக்கான ஒரு ஆசாரியர்களின் அரசாகவும், ஒரு பரிசுத்த ஜனமாகவும் இருப்பீர்கள்.’ இஸ்ரயேலரோடு நீ பேசவேண்டிய வார்த்தைகள் இவையே” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","எனவே மோசே திரும்பிப்போய் இஸ்ரயேலரின் சபைத்தலைவர்களை வரவழைத்தான். யெகோவா அவர்களுக்குச் சொல்லும்படி அவனுக்குக் கட்டளையிட்ட எல்லா வார்த்தைகளையும் அவர்கள் முன்னிலையில் எடுத்துச்சொன்னான். ");
INSERT INTO tamtcv_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","அப்பொழுது அதைக்கேட்ட மக்களெல்லோரும் ஒருமித்து, “யெகோவா கட்டளையிட்ட எல்லாவற்றையும் நாங்கள் செய்வோம்” என்று பதிலளித்தார்கள். மோசே யெகோவாவினிடத்திற்குத் திரும்பிப்போய் அவர்களுடைய பதிலை அவருக்கு அறிவித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","அப்பொழுது யெகோவா மோசேயிடம், “நான் உன்னோடு பேசுவதை மக்கள் கேட்டு, அவர்கள் எப்போதும் உன்மேல் நம்பிக்கை வைக்கும்படி, நான் கார்மேகத்தில் உன்னிடம் வரப்போகிறேன்” என்றார். மக்கள் சொன்னவற்றை மோசே யெகோவாவுக்குச் சொன்னான். ");
INSERT INTO tamtcv_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","பின்னும் யெகோவா மோசேயிடம், “நீ இஸ்ரயேல் மக்களிடம்போய், இன்றும் நாளையும் அவர்களை பரிசுத்தப்படுத்து. அவர்கள் தங்கள் உடைகளைக் கழுவும்படியும் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","அவர்கள் மூன்றாம் நாளில் ஆயத்தமாயிருக்கும்படி செய்யவேண்டும். ஏனெனில், அன்று மக்கள் அனைவரின் கண்கள் முன்பாக யெகோவா சீனாய் மலையின்மேல் இறங்குவார். ");
INSERT INTO tamtcv_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","மலையை அணுகாதவாறு அதைச் சுற்றி ஒரு எல்லையைப் போட்டு, அவர்களிடம், ‘நீங்கள் மலைக்கு ஏறிப்போகாமலும், அதன் அடிவாரத்தைத் தொடாமலும் இருக்கும்படி எச்சரிக்கையாயிருங்கள். மலையைத் தொடுகிறவன் எவனும் கொல்லப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","அப்படி மீறுகிறவனை கைகளால் தாக்காமல் கல்லால் எறிந்தோ, அம்புகளால் எய்தோ அவனைக் கொல்லவேண்டும். இதை மீறுகிற மிருகத்தையோ, மனிதனையோ உயிரோடிருக்க அனுமதிக்கக் கூடாது’ என்று சொல். செம்மறியாட்டுக் கடாவின் கொம்பு வாத்தியத்தால் நீண்ட சத்தம் எழுப்பப்படும்போது மாத்திரமே, அவர்கள் மலைக்குப் போகலாம்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","மோசே மலையிலிருந்து இறங்கி இஸ்ரயேல் மக்களிடம் வந்து, அவர்களை பரிசுத்தப்படுத்தினான். அவர்களும் தங்கள் உடைகளைக் கழுவினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","அதன்பின் மோசே மக்களிடம், “மூன்றாம் நாளுக்காக உங்களை ஆயத்தப்படுத்திக் கொள்ளுங்கள். பாலுறவுகளிலிருந்து விலகியிருங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","மூன்றாம் நாள் காலையில் இடிமுழக்கமும், மின்னலும் உண்டாகி, மலையைக் கார்மேகம் மூடியது. பலமாய் எக்காள சத்தம் தொனித்தது. முகாமிலிருந்த மக்கள் எல்லோரும் நடுங்கினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","அப்பொழுது மோசே இறைவனைச் சந்திக்கும்படி, மக்களை முகாமுக்கு வெளியே கொண்டுவந்தான். அவர்கள் மலையடிவாரத்தில் நின்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","யெகோவா சீனாய் மலையின்மேல் அக்கினியில் இறங்கியபடியால், மலை முழுவதும் புகையால் மூடப்பட்டிருந்தது. சூளையிலிருந்து புகை எழும்பியதுபோல் அப்புகை எழும்பிற்று. மலை முழுவதும் பலமாய் அதிர்ந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","எக்காள சத்தம் மேன்மேலும் பலமாய்த் தொனித்தது. அப்போது மோசே பேசினான். இறைவனின் குரல் அவனுக்குப் பதிலளித்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","யெகோவா சீனாய் மலை உச்சியில் இறங்கி, மோசேயை அந்த மலை உச்சிக்கு வரும்படி அழைத்தார். அப்படியே மோசே மேலே ஏறிப்போனான். ");
INSERT INTO tamtcv_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","அப்பொழுது யெகோவா மோசேயிடம், “யெகோவாவைப் பார்க்கும்படி எல்லையைத் தாண்டி மக்கள் வந்து, அவர்களில் அநேகர் அழிந்துபோகாதபடிக்கு, நீ கீழே இறங்கிப்போய் அவர்களை எச்சரிக்கை செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","யெகோவாவுக்கு அருகே வரும் ஆசாரியரும் தங்களை பரிசுத்தப்படுத்த வேண்டும். இல்லையெனில் யெகோவா அவர்களையும் அழித்துவிடுவார்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","அப்பொழுது மோசே யெகோவாவிடம், “மக்களால் சீனாய் மலைக்கு ஏறி வரமுடியாது. ஏனெனில் மலையைச் சுற்றி எல்லை போட்டு அதைப் பரிசுத்தப்படுத்தி பிரித்து வைக்கவேண்டும் என்று நீரே எங்களுக்கு எச்சரிக்கை கொடுத்திருக்கிறீர்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","அதற்கு யெகோவா மோசேயிடம், “இப்பொழுது நீ இறங்கிப்போய் ஆரோனை அழைத்துக்கொண்டு மேலே ஏறி வா. ஆனால் ஆசாரியரும், மக்களும் பலவந்தமாய் எல்லையைக் கடந்து யெகோவாவிடம் மேலே வரக்கூடாது. வந்தால் யெகோவா அவர்களை அழித்துவிடுவார்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","அவ்வாறே மோசே இறங்கி மக்களிடம்போய் யெகோவா கட்டளையிட்டவைகளைச் சொன்னான். ");
INSERT INTO tamtcv_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","இறைவன் இந்த வார்த்தைகள் எல்லாவற்றையும் பேசினார்: ");
INSERT INTO tamtcv_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“அடிமைத்தன நாடாகிய எகிப்திலிருந்து உன்னை வெளியே அழைத்துக்கொண்டுவந்த உன் இறைவனாகிய யெகோவா நானே. ");
INSERT INTO tamtcv_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“நீ என்னைத்தவிர வேறு தெய்வங்களை உனக்காக வைத்திருக்காதே. ");
INSERT INTO tamtcv_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","நீ உனக்காக ஒரு விக்கிரகத்தைச் செய்யாதே. மேலே வானத்திலும், கீழே பூமியிலும், பூமியின்கீழ் தண்ணீரிலும் உள்ள எதனுடைய உருவத்திலும் விக்கிரகத்தைச் செய்யாதே. ");
INSERT INTO tamtcv_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","நீ அவற்றை வணங்கவோ வழிபடவோ வேண்டாம். ஏனெனில், உன் இறைவனான யெகோவாவாகிய நான் எனக்குரிய வழிபாட்டைக் குறித்து வைராக்கியமுடைய இறைவன். என்னை வெறுக்கிறவர்கள் மத்தியில் பெற்றோரின் பாவத்திற்காக மூன்றாம், நான்காம் தலைமுறை மட்டும் அவர்களுடைய பிள்ளைகளைத் தண்டிக்கிறவராயும் இருக்கிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ஆனால் என்னிடம் அன்பாயிருந்து, என் கட்டளைகளைக் கைக்கொள்கிறவர்களுக்கோ, ஆயிரம் தலைமுறைகளுக்கும் அன்பு காட்டுகிறவராயும் இருக்கிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","உன் இறைவனாகிய யெகோவாவின் பெயரைத் தவறாகப் பயன்படுத்த வேண்டாம். ஏனெனில், யெகோவா தனது பெயரை தவறாகப் பயன்படுத்துகிற ஒருவனையும் தண்டிக்காமல் விடுவதில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","ஓய்வுநாளைப் பரிசுத்தமாய்க் கைக்கொள்ளும்படி அதை நினைவில் வைத்துக்கொள். ");
INSERT INTO tamtcv_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ஆறு நாட்களும் உழைத்து உன் வேலையை எல்லாம் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ஏழாம்நாளோ உன் இறைவனாகிய யெகோவாவின் ஓய்வுநாள். அந்த நாளில் நீ எந்த வேலையையும் செய்யக்கூடாது, நீயோ, உன் மகனோ, உன் மகளோ, உன் வேலைக்காரனோ, வேலைக்காரியோ எந்த வேலையையும் செய்யக்கூடாது. உன் மிருகங்களோ, உன் பட்டணங்களுக்குள் வாழும் பிறநாட்டினனோ எந்த வேலையும் செய்யக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","ஏனெனில், யெகோவா வானத்தையும் பூமியையும், கடலையும் அவற்றிலுள்ள எல்லாவற்றையும் ஆறு நாட்களில் படைத்தார். ஏழாம் நாளிலோ அவர் ஓய்ந்திருந்தார். அதனால் ஓய்வுநாளை ஆசீர்வதித்து, அதைப் பரிசுத்தமாக்கினார். ");
INSERT INTO tamtcv_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","உன் தகப்பனையும் தாயையும் கனம்பண்ணு. அப்பொழுது உன் இறைவனாகிய யெகோவா உனக்குக் கொடுக்கும் நாட்டிலே நீ நீடித்து வாழ்வாய். ");
INSERT INTO tamtcv_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","கொலைசெய்ய வேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","விபசாரம் செய்யவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","களவு செய்யவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","உன் அயலானுக்கு எதிராகப் பொய்ச்சாட்சி சொல்லாதே. ");
INSERT INTO tamtcv_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","உன் அயலானுடைய வீட்டை அபகரிக்க ஆசைகொள்ளாதே. உன் அயலானின் மனைவியையோ, அவனுடைய வேலைக்காரனையோ, வேலைக்காரியையோ, அவனுடைய எருதையோ, கழுதையையோ, அவனுக்குரிய எதையும் அபகரிக்க ஆசைகொள்ளாதே.” ");
INSERT INTO tamtcv_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","மக்கள் இடிமுழக்கத்தையும், மின்னலையும் கண்டு, எக்காள சத்தத்தையும் கேட்டு, மலை புகையால் சூழப்பட்டதைக் கண்டபோது பயத்தினால் நடுங்கினார்கள். அவர்கள் தூரத்திலே நின்று, ");
INSERT INTO tamtcv_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","மோசேயிடம், “நீரே எங்களுடன் பேசும்; நாங்கள் கேட்போம். இறைவனை எங்களுடன் பேச விடவேண்டாம். இல்லையெனில் நாங்கள் சாவோம்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","அப்பொழுது மோசே மக்களிடம், “பயப்படவேண்டாம். பாவம் செய்வதிலிருந்து உங்களை விலக்கிக் காக்கும்படி, இறைவனைப்பற்றிய பயம் உங்களோடிருக்க வேண்டும் என்பதற்காகவே, இறைவன் உங்களைப் சோதிக்க வந்திருக்கிறார்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","இறைவன் இருந்த காரிருளை நோக்கி மோசே போகையில், மக்கள் தூரத்திலே நின்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","அப்பொழுது யெகோவா மோசேயிடம், “நீ இஸ்ரயேல் மக்களுக்குச் சொல்லவேண்டியது இதுவே: ‘நான் வானத்திலிருந்து உங்களோடு பேசியதை நீங்களே பார்த்திருக்கிறீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","ஆகவே என்னோடு சேர்த்து வழிபடும்படி வேறொரு தெய்வத்தையும் செய்யவேண்டாம். வெள்ளியினால் தெய்வங்களையும், தங்கத்தினால் தெய்வங்களையும் உங்களுக்காக செய்யவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘எனக்காக மண்ணினாலே ஒரு பலிபீடத்தைக் கட்டி, அதன்மேல் எனக்கு செம்மறியாடுகளையும், வெள்ளாடுகளையும், மாடுகளையும் தகன காணிக்கையாகவும், சமாதான காணிக்கையாகவும் பலி செலுத்துங்கள். எங்கெல்லாம் என் பெயரை கனமடையும்படி நான் செய்கிறேனோ, அங்கெல்லாம் நான் உங்களிடத்தில் வந்து உங்களை ஆசீர்வதிப்பேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","எனக்குக் கல்லினால் ஒரு பலிபீடத்தைக் கட்டவேண்டுமானால், அதை வெட்டப்பட்ட கற்களினால் கட்டவேண்டாம். ஏனெனில் அதன்மேல் ஒரு ஆயுதத்தைப் பயன்படுத்தும்போது நீங்கள் அதைக் கறைப்படுத்துவீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","உங்கள் நிர்வாணம் காணப்படாதபடி, நீங்கள் என் பலிபீடத்திற்கு படிகளில் ஏறிப்போகவேண்டாம்’ என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“நீ அவர்களுக்கு முன்பாக வைக்கவேண்டிய சட்டங்கள் இவையே: ");
INSERT INTO tamtcv_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“ஒரு எபிரெய அடிமையை நீங்கள் விலைக்கு வாங்கினால், அவன் ஆறு வருடங்கள் மட்டுமே உங்களுக்கு வேலைசெய்யவேண்டும். ஏழாம் வருடத்திலோ, எந்தவித பணத்தையும் கொடுக்காமல் அவன் விடுதலையாகிப் போகவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","அவன் தனிமையாய் வந்திருந்தால், தனிமையாகவே விடுதலையாகிப் போகவேண்டும். அவன் வருகிறபோது அவனுக்கு ஒரு மனைவியிருந்தால், அவளும் அவனோடுகூடப் போகவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","ஒரு எஜமான் தனது அடிமைக்கு ஒரு பெண்ணை மனைவியாகக் கொடுத்து, அவள் அவனுக்கு மகன்களையும் மகள்களையும் பெற்றிருந்தால், அந்தப் பெண்ணும் அவள் பிள்ளைகளும் எஜமானுக்கே சொந்தம். அந்த மனிதன் மட்டுமே விடுதலையாகிப் போகவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“ஆனால் அந்த அடிமையோ, ‘நான் என் எஜமானையும் என் மனைவியையும் என் பிள்ளைகளையும் நேசிக்கிறேன். அதனால் விடுதலையாகிப்போக நான் விரும்பவில்லை’ என்று அறிவித்தால், ");
INSERT INTO tamtcv_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","அவனுடைய எஜமான் அவனை நீதிபதிகளின் முன்பாக கொண்டுபோக வேண்டும். அவன் இவனை கதவின் அருகேயோ அல்லது கதவு நிலையின் அருகேயோ கொண்டுபோய் ஒரு குத்தூசியினால் அவன் காதைத் துளையிடவேண்டும். அதன்பின் அவன் வாழ்நாள் முழுவதும் அவனுக்கு அடிமையாயிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“ஒருவன் தன் மகளை அடிமையாக விற்றால், ஆண் அடிமைகள் போவதுபோல் அவள் போகக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","எஜமான் அவளை தனக்காக தெரிந்தெடுத்திருந்து, அவள் அவனைப் பிரியப்படுத்தாதவளாய்க் காணப்பட்டால், அவள் மீட்கப்பட அவன் அனுமதிக்கவேண்டும். அவளை பிறநாட்டினனுக்கு விற்பதற்கு அவனுக்கு உரிமையில்லை. ஏனெனில் அவன் அவளுக்கு நம்பிக்கை துரோகம் செய்துள்ளான். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","அவன் அவளைத் தன் மகனுக்குத் தெரிந்தெடுத்திருந்தால், அவளுக்கு ஒரு மகளுக்குரிய உரிமைகளைக் கொடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","எஜமான் இன்னும் ஒரு பெண்ணை திருமணம் செய்தால், முதல் பெண்ணுக்கும் உரிய உடை, உணவு, திருமண உரிமைகள் ஆகியவற்றைக் கொடுக்காமல் விடக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","அம்மூன்றையும் எஜமான் அவளுக்குக் கொடுக்காவிட்டால், அவள் அவனுக்குப் பணம் ஒன்றும் கொடுக்காமல் விடுதலையாகிப்போகலாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“ஒரு மனிதனை அடித்துக் கொலை செய்கிறவன் நிச்சயமாக கொலைசெய்யப்பட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","ஆனாலும், அவன் அதைத் திட்டமிட்டுச் செய்யாமல், அது நடைபெற இறைவன் இடங்கொடுத்திருந்தால், நான் நியமிக்கப்போகிற ஒரு இடத்திற்கு அவன் ஓடிப்போய் தப்பித்துக்கொள்ளவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","ஒருவன் சதிசெய்து இன்னொருவனைக் கொலை செய்தால், அவன் என் பலிபீடத்திலிருந்தாலும் அவனைக் கொண்டுபோய் கொலைசெய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“தன் தகப்பனையோ தாயையோ தாக்குகிறவன் கொலைசெய்யப்பட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“ஒருவன் இன்னொருவனைக் கடத்திச்சென்று அவனை விற்றாலோ அல்லது அவனைத் தன்னுடன் வைத்திருந்ததாலோ, கடத்திச்சென்றவன் பிடிக்கப்படும்பொழுது கொல்லப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“தன் தகப்பனையோ, தன் தாயையோ சபிப்பவன் கொல்லப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“மனிதர் வாக்குவாதம் செய்து, ஒருவன் மற்றவனைக் கல்லாலோ அல்லது தன் கருவியினாலோ அடித்ததினால் அவன் சாகாமல் படுக்கையாகவே இருந்து, ");
INSERT INTO tamtcv_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","பின்பு எழுந்திருந்து ஒரு கோலை ஊன்றியாவது நடமாடமுடியுமானால், அவனை அடித்தவன் அக்குற்றத்திற்குப் பொறுப்பாளியாகமாட்டான். ஆனாலும் அவன், காயப்பட்டவனுக்கு வேலைசெய்ய முடியாத காலத்திற்குரிய இழந்துபோன கூலியைச் செலுத்தவேண்டும். அவன் முற்றிலும் குணப்படும்படி பார்த்துக்கொள்ளவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“ஒரு மனிதன் தன் ஆண் அடிமையை அல்லது பெண் அடிமையை கோலினால் அடித்து, அதனால் அந்த அடிமை இறந்தால், அடித்தவன் தண்டிக்கப்பட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","ஆனால் அடிபட்ட அடிமை ஓரிரு நாட்களில் எழுந்திருந்தால், எஜமான் தண்டிக்கப்பட வேண்டியதில்லை. ஏனெனில் அடிமை எஜமானின் உடைமை. ");
INSERT INTO tamtcv_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“மனிதர் சண்டையிடுகிறபொழுது கர்ப்பவதியான ஒரு பெண்ணை அடித்ததினால், பெரியகாயமேதுமில்லாமல் அவளுக்கு குறைப்பிரசவம் ஏற்பட்டால், அடித்தவனிடம் அபராதம் வசூலிக்க வேண்டும். அவளுடைய கணவன் கேட்கும் பணத்தைக் கருத்திற்கொண்டு, நீதிமன்றம் அனுமதிப்பதை அபராதமாகச் செலுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","அவளுக்குக் கடுமையான காயமேதும் ஏற்பட்டால், உயிருக்குப்பதில் உயிரை நீங்கள் எடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","கண்ணுக்குக் கண், பல்லுக்குப் பல், கைக்குக் கை, காலுக்குக் கால், ");
INSERT INTO tamtcv_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","சூட்டுக்குப் பதில் சூடும், காயத்துக்குப்பதில் காயமும், தழும்புக்குப்பதில் தழும்புமாக தண்டிக்கப்பட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“ஒரு மனிதன் தன் ஆண் அடிமையையோ, பெண் அடிமையையோ கண்ணில் அடித்து அழித்துப்போட்டால், அக்கண்ணின் இழப்பை ஈடுசெய்வதற்கு அவர்களை அவன் விடுதலை செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","ஆண் அடிமையின் பல்லையோ அல்லது பெண் அடிமையின் பல்லையோ அவன் அடித்து உடைத்தால், பல்லுக்கு இழப்பீடாக அவர்களை விடுதலை செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“ஒரு மனிதனையோ அல்லது ஒரு பெண்ணையோ, ஒரு எருது தன் கொம்பினால் குத்திக்கொன்றால், அந்த எருது கல்லெறிந்து கொல்லப்படவேண்டும். அதன் இறைச்சியைச் சாப்பிடக்கூடாது. எருதின் உரிமையாளன் அக்குற்றத்திற்குப் பொறுப்பாளியாகமாட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","ஆனாலும் அந்த எருது வழக்கமாக முட்டுகிறதாயிருந்து, அவனுக்கு அதைக்குறித்து எச்சரித்திருந்தும், அவன் அதைக் கட்டிவைக்காததினால் அது ஒரு மனிதனையோ, பெண்ணையோ முட்டிக்கொன்றால், எருது கல்லெறிந்து கொல்லப்படவேண்டும். எருதின் உரிமையாளனும் கொல்லப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","ஆனாலும் அபராதம் கொடுக்கும்படி அவன் கேட்கப்பட்டால், கேட்கப்பட்ட அபராதத்தைச் செலுத்தித் தன் உயிரை மீட்டுக்கொள்ளலாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","ஒருவனுடைய மகனையோ, மகளையோ எருது குத்திக்கொன்றால் அதற்குரிய சட்டமும் இதுவே: ");
INSERT INTO tamtcv_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","அந்த எருது ஒரு ஆண் அடிமையையோ, பெண் அடிமையையோ குத்தினால், எருதின் சொந்தக்காரன் அடிமையின் எஜமானுக்கு முப்பது சேக்கல் வெள்ளிக்காசு கொடுக்கவேண்டும். எருதும் கல்லெறிந்து கொல்லப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“ஒரு மனிதன் ஒரு குழியைத் திறந்துவைத்ததாலோ அல்லது ஒரு குழியைவெட்டி அதை மூடுவதற்கு தவறியதாலோ, ஒரு எருது அல்லது கழுதை அதற்குள் விழுந்தால், ");
INSERT INTO tamtcv_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","குழிக்குரியவன் செத்தப்போன மிருகத்துக்கு இழப்பீட்டை, அந்த மிருகத்தின் உரிமையாளனுக்கு கொடுக்கவேண்டும். செத்தப்போன மிருகமோ குழிக்குரியவனுடையதாகும். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“ஒரு மனிதனுடைய எருது, மற்றவனுடைய எருதைக் காயப்படுத்துவதினால் அது இறந்தால், உயிரோடிருக்கிற எருதை விற்று, பணத்தை இருவரும் பங்கிடவேண்டும். செத்தப்போன எருதையும் சமமாகப் பங்கிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","ஆனாலும் அது வழக்கமாக முட்டுகிற எருது என்று உரிமையாளன் அறிந்திருந்தும் அதைக் கட்டிவைக்காதிருந்ததால், உரிமையாளன் எருதுக்கு எருது கொடுக்கவேண்டும். செத்தப்போன எருதோ தண்டம் செலுத்தியவனுக்குரியதாகும். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“ஒரு மனிதன் ஒரு எருதையோ அல்லது செம்மறியாட்டையோ திருடி, அதைக் கொன்றாலோ அல்லது விற்றாலோ அவன் அந்த எருதுக்குப் பதிலாக ஐந்து எருதுகளையும், அந்த செம்மறியாட்டுக்குப் பதிலாக நான்கு செம்மறியாடுகளையும் கொடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“திருடன் ஒருவன், வீட்டை உடைத்துத் திருடுகையில் பிடிக்கப்பட்டு, அடிபட்டு இறந்தால், அடித்தவன் இரத்தத்தைச் சிந்தியதற்கான குற்றவாளி அல்ல. ");
INSERT INTO tamtcv_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","ஆனால் அது சூரியன் உதித்தபின் நடந்திருந்தால் இரத்தத்தைச் சிந்திய குற்றம் அவன்மேல் இருக்கும். “திருடன் தன் திருட்டிற்காகப் பதிலீடு செய்யவேண்டும். அவனிடம் ஒன்றுமில்லையானால் அபராதத்தைச் செலுத்துவதற்காக அவன் விற்கப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","அவன் திருடிய எருதோ, கழுதையோ, செம்மறியாடோ அவனிடத்தில் உயிரோடிருக்கக் கண்டுபிடிக்கப்பட்டால், அவன் இரண்டு மடங்கு அபராதத்தைச் செலுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“ஒருவன் தன் வளர்ப்பு மிருகங்களை ஒரு வயலிலோ, திராட்சைத்தோட்டத்திலோ மேய்க்கிறபோது, அவற்றைக் கட்டாமல் இன்னொருவனுடைய வயலில் மேயவிட்டால், அவன் தன்னுடைய வயலிலிருந்தும், தோட்டத்திலிருந்தும் அதற்குப் பதிலீடாக மிகச்சிறந்ததைக் கொடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“நெருப்பு மூண்டு முட்செடிகளில் பற்றிப்பரவி, தானியக்கட்டுகளையோ, விளைந்து நிற்கும் தானியக்கதிர்களையோ அல்லது முழு வயலையோ எரித்துப்போட்டால், நெருப்பை மூட்டியவன் அதற்காகப் பதிலீடு செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“ஒரு மனிதன் தன் அயலானிடம் வெள்ளியையோ, பொருட்களையோ பாதுகாப்பாக வைப்பதற்குக் கொடுக்கையில், அந்த அயலானுடைய வீட்டிலிருந்து அவை திருடப்பட்டு, அந்த திருடன் பிடிக்கப்பட்டால் அவன் இரண்டு மடங்கு அபராதம் செலுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","ஆனால், அத்திருடன் அகப்படாவிட்டால், வீட்டின் உரிமையாளன் தன்னிடம் ஒப்புவிக்கப்பட்ட பொருட்களை தான் எடுக்கவில்லை என்பதை நிரூபிப்பதற்காக அவன் நீதிபதிகள் முன் வரவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","ஒருவன் தன்னுடையதல்லாத எருதையோ, கழுதையையோ, செம்மறியாட்டையோ, உடையையோ, காணாமற்போன எந்தப் பொருளையோ வைத்திருக்கும்போது, அதை இன்னொருவன் கண்டு, ‘இது என்னுடையது’ என்று சொன்னால், அவர்கள் இருவரும் நீதிபதியின் முன்பாக தங்கள் வழக்குகளை கொண்டுவர வேண்டும். நீதிபதியால் குற்றவாளியென்று தீர்க்கப்படுகிறவன் மற்றவனுக்கு இரண்டு மடங்காகக் கொடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“ஒருவன் தன் கழுதையையோ, எருதையோ, செம்மறியாட்டையோ, வேறொரு மிருகத்தையோ தன் அயலானிடத்தில் பாதுகாப்பாக வைத்திருக்கும்படி கொடுத்திருக்கும்போது, அது இறந்தால் அல்லது காயமடைந்தால் அல்லது ஒருவரும் பார்க்காத வேளையில் காணாமற்போனால், ");
INSERT INTO tamtcv_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","அந்த மிருகங்களை வைத்திருந்த மனிதன் அவற்றைத் தான் திருடவில்லை என யெகோவா முன்னிலையில் சத்தியம் செய்யவேண்டும். அப்பொழுது அவர்கள் இருவருக்கும் இடையில் இப்பிரச்சனை தீர்க்கப்படும். மிருகங்களின் உரிமையாளன் அந்த ஆணையை ஏற்றுக்கொள்ளவேண்டும். பதிலீடு எதுவும் வேண்டியதில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","ஆனால் அந்த மிருகம் அயலானிடத்திலிருந்து களவுபோயிருந்தால், அவன் அதன் உரிமையாளனுக்கு அதற்காகப் பதிலீடு செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","கொடிய மிருகங்களால் அது துண்டுகளாகக் கிழிக்கப்பட்டிருந்தால், அதன் உடலில் மீதியானவற்றைச் உரிமையாளனிடம் சாட்சியமாகக் கொண்டுவர வேண்டும். கிழிக்கப்பட்ட அந்த மிருகத்திற்காக அவன் பணம் செலுத்தும்படி கேட்கப்படமாட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“ஒருவன் தன் அயலானிடம் ஒரு மிருகத்தை இரவலாக வாங்கியிருக்கையில், அதன் உரிமையாளர் இல்லாத வேளையில் அது காயப்பட்டால் அல்லது இறந்துபோனால், அவன் அதற்கு ஈடுசெய்ய வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","ஆனால் மிருகத்தின் உரிமையாளர் அதனுடன் இருந்தால், இரவல் வாங்கியவன் அதற்காக ஈடுசெய்ய வேண்டியதில்லை. அந்த மிருகம் கூலிக்கு எடுக்கப்பட்டிருந்தால், கூலியாகச் செலுத்தப்பட்ட பணம் அந்த நஷ்டத்தை ஈடுசெய்கிறது. ");
INSERT INTO tamtcv_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“திருமணத்திற்காக நிச்சயிக்கப்படாத ஒரு கன்னிப்பெண்ணை ஒருவன் வஞ்சித்து, அவளுடன் உறவுகொண்டால், அவன் அவளுக்கான சீதனத்தை அவளுடைய தகப்பனுக்குக் கொடுக்கவேண்டும். அவள் அவனுக்கு மனைவியாயிருப்பாள். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","அப்பெண்ணின் தகப்பன் அவளை அவனுக்குக் கொடுக்க முற்றிலுமாக மறுத்தால், கன்னிகைகளுக்காகக் கொடுக்கப்படும் சீதனப் பணத்தை கண்டிப்பாக அவன் கொடுத்தாகவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“சூனியக்காரியை உயிரோடு இருக்கவிடவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“மிருகத்தோடு பாலுறவுகொள்பவன் எவனும் கொல்லப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“யெகோவாவைத்தவிர வேறு தெய்வங்களுக்குப் பலியிடுகிறவன் எவனும் அழிக்கப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“பிறநாட்டினனைத் துன்புறுத்தவோ, ஒடுக்கவோ வேண்டாம். ஏனெனில் நீங்களும் எகிப்திலே பிறநாட்டினராயிருந்தீர்களே. ");
INSERT INTO tamtcv_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“விதவைகளையும், அனாதைப் பிள்ளைகளையும் தன்னலத்துக்காக சுரண்டவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","அப்படிச் செய்தால் அவர்கள் என்னிடம் அழும்போது, நான் நிச்சயமாக அவர்கள் அழுகையைக் கேட்பேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","அதனால் நான் கோபமடைந்து, உங்களை வாளினால் கொல்லுவேன். அப்பொழுது உங்கள் மனைவிகள் விதவைகளாவார்கள். உங்கள் பிள்ளைகள் தந்தையற்றவர்கள் ஆவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“என் மக்களில் வறுமையான ஒருவனுக்கு யாராவது பணம் கொடுத்திருந்தால், வட்டிக்குப் பணம் கொடுப்பவனைப்போல அவனிடம் வட்டியை வாங்கக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","உங்கள் அயலானுடைய மேலங்கியை அடகுப்பொருளாக வாங்கியிருந்தால், சூரியன் மறையும் முன்பே அதை அவனுக்குத் திருப்பிக் கொடுத்துவிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ஏனெனில், அதுமட்டுமே அவனுடைய உடலை மூடும் போர்வையாயிருக்கிறது. அவன் படுக்கும்போது, வேறு எதனால் அவன் தன்னை மூடிக்கொள்வான்? அவன் என்னிடம் அழும்போது நான் கேட்பேன். ஏனெனில் நான் கருணையுள்ளவர். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“இறைவனை நிந்திக்கவேண்டாம். உங்கள் மக்களின் ஆளுநனை சபிக்கவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“உங்கள் தானியக் களஞ்சியங்களிலிருந்தும், திராட்சை இரசத் தொட்டிகளிலிருந்தும் காணிக்கைகளைக் கொடுக்காமல் வைத்திருக்கவேண்டாம். “உங்கள் மகன்களில் முதற்பேறானவனை நீங்கள் எனக்குக் கொடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","நீங்கள் உங்கள் ஆடுமாடுகளிலிருந்தும் செம்மறியாடுகளிலிருந்தும் அப்படியே செய்யவேண்டும். அவை தங்களுடைய தாய்களுடன் ஏழுநாட்களுக்கு இருக்கட்டும். எட்டாம் நாளிலே அவற்றை எனக்குக் கொடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“நீங்கள் என் பரிசுத்த மக்களாக இருக்கவேண்டும். ஆகையால், காட்டு மிருகங்களினால் கிழிக்கப்பட்ட மிருகத்தின் இறைச்சியைச் சாப்பிடவேண்டாம். அதை நாய்களுக்கு எறிந்துவிடுங்கள்.” ");
INSERT INTO tamtcv_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“பொய் வதந்திகளைப் பரப்பவேண்டாம். தீயநோக்கமுள்ள சாட்சியாய் இருந்து கொடியவனுக்கு உதவவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“பிழையானதைச் செய்யும் மக்கள் கூட்டத்தைப் பின்பற்றவேண்டாம். ஒரு வழக்கில் நீங்கள் சாட்சி கொடுக்கும்போது, அதிகமான மக்களுக்கு சார்பாக இருந்து நீதியைப் புரட்டவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","ஒரு ஏழையின் வழக்கிலே அவனுக்கு பட்சபாதம் காட்டவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“உங்கள் பகைவனுடைய மாட்டையோ அல்லது கழுதையையோ வழிதப்பி திரிகிறதை நீங்கள் காணநேரிட்டால், அதைத் திரும்பவும் அவனிடம் கொண்டுபோய்விடத் தவறவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","உங்களை வெறுக்கிறவனுடைய கழுதை சுமையோடே விழுந்துகிடக்கக் கண்டால், அதை அங்கேயே விட்டுவிட்டுப் போகவேண்டாம். அவனுக்கு உதவிசெய்யவும் தவறவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“உங்களிடத்தில் இருக்கும் ஏழை மக்களுக்கு அவர்களுடைய வழக்கில் நீதிவழங்க மறுக்கவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","பொய்க்குற்றச்சாட்டுடன் சம்பந்தப்படவேண்டாம். குற்றமற்றவனையும், உண்மையுள்ளவனையும் கொலைசெய்ய வேண்டாம். ஏனெனில் நான் குற்றவாளியைத் தண்டியாமல் விடமாட்டேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“இலஞ்சம் வாங்கவேண்டாம், இலஞ்சம் பார்வையுள்ளவர்களைக் குருடராக்கி, நீதிமான்களின் வார்த்தைகளைப் புரட்டுகிறது. ");
INSERT INTO tamtcv_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“பிறநாட்டினனை ஒடுக்கவேண்டாம்; பிறநாட்டினராய் இருப்பது எப்படி இருக்கும் என்று உங்களுக்குத் தெரியுமே. ஏனெனில், நீங்களும் எகிப்தில் பிறநாட்டினராய் இருந்தீர்களே. ");
INSERT INTO tamtcv_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“நீங்கள் ஆறு வருடங்களுக்கு உங்கள் வயல்களை விதைத்து விளைச்சலை அறுவடை செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ஆனால் ஏழாவது வருடமோ, நிலமானது உழப்படாமலும் பயன்படுத்தப்படாமலும் விட்டுவிட வேண்டும். உங்கள் மத்தியிலுள்ள ஏழைகள் அதிலிருந்து வளரும் தானியங்களை உணவாகப் பெற்றுக்கொள்ளலாம். அவர்கள் விட்டதைக் காட்டு மிருகங்கள் தின்னலாம். உங்கள் திராட்சைத் தோட்டத்திற்கும், ஒலிவத்தோப்பிற்கும் அப்படியே செய்யுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“நீங்கள் ஆறு நாட்களுக்கு உங்கள் வேலையைச் செய்யுங்கள். ஏழாம்நாளோ வேலைசெய்யவேண்டாம். அதனால் உங்கள் எருதும், கழுதையும் இளைப்பாறட்டும். பிறநாட்டினனும் உங்கள் வீட்டில் பிறந்த அடிமையும் இளைப்பாறி, புதுபெலன் பெறட்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“நான் உங்களுக்குச் சொன்ன எல்லாவற்றையும் செய்யக் கவனமாயிருங்கள். பிற நாட்டு தெய்வங்களின் பெயரைச்சொல்லிக் கூப்பிடவேண்டாம். அவற்றின் பெயரை உங்கள் உதடுகளினால் உச்சரிக்கவும் வேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“வருடத்தில் மூன்றுமுறை நீங்கள் எனக்குப் பண்டிகை கொண்டாடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“முதலாவதாக புளிப்பில்லாத அப்பப்பண்டிகையைக் கொண்டாடுங்கள். நான் உங்களுக்குக் கட்டளையிட்டபடி, ஏழுநாட்களுக்கு புளிப்பில்லாத அப்பத்தைச் சாப்பிடுங்கள். ஆபீப் மாதத்தில், குறிக்கப்பட்ட காலத்தில் இதைச் செய்யுங்கள். ஏனெனில் அந்த மாதத்தில்தான் நீங்கள் எகிப்திலிருந்து புறப்பட்டு வெளியேவந்தீர்கள். “ஒருவரும் வெறுங்கையுடன் என்முன் வரக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“நீங்கள் விதைத்த உங்கள் வயலின் விளைச்சலின் முதற்பலனைக் கொண்டு, அறுவடைப் பண்டிகையைக் கொண்டாடுங்கள். “பின்பு ஒவ்வொரு வருடத்தின் முடிவிலும், உங்கள் வயலின் விளைச்சலைச் சேர்க்கிற சேர்ப்பின் பண்டிகையைக் கொண்டாடுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“இவ்வாறாக வருடத்தில் மூன்றுமுறை எல்லா ஆண்களும் ஆண்டவராகிய யெகோவா முன்பாக வரவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“பலியின் இரத்தத்தை புளிப்பூட்டப்பட்ட எதனுடனும் சேர்த்து எனக்குச் செலுத்தவேண்டாம். “எனது பண்டிகைக் காணிக்கைகளின் கொழுப்பை மறுநாள் காலைவரை பலியிடாமல் வைத்திருக்கக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“உங்கள் நிலத்திலுள்ள முதற்பலன்களில் சிறந்தவற்றையே உங்கள் இறைவனாகிய யெகோவாவின் ஆலயத்துக்குக் கொண்டுவர வேண்டும். “வெள்ளாட்டுக்குட்டியை அதன் தாயின் பாலிலே சமைக்கவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“பாருங்கள், வழியெல்லாம் உங்களைப் பாதுகாத்து நான் ஆயத்தப்படுத்தியிருக்கிற இடத்திற்கு உங்களைக் கொண்டுவருவதற்காக, நான் உங்களுக்கு முன்னால் ஒரு தூதனை அனுப்புகிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","அவர் சொல்வதை கவனித்துக் கேளுங்கள். அவருக்கு விரோதமாகக் கலகம் செய்யவேண்டாம். ஏனெனில் என் பெயர் அவரில் இருப்பதால் உங்கள் கலகத்தை அவர் மன்னிக்கமாட்டார். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","அவர் சொல்வதை நீங்கள் கவனமாகக் கேட்டு, நான் சொல்வதையெல்லாம் செய்வீர்களானால், நான் உங்கள் பகைவர்களுக்குப் பகைவராய் இருப்பேன். உங்களை எதிர்ப்பவர்களை நானும் எதிர்ப்பேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","என் தூதன் உங்களுக்கு முன்சென்று, எமோரியர், ஏத்தியர், பெரிசியர் கானானியர், ஏவியர், எபூசியர் வாழும் இடத்திற்கு உங்களைக் கொண்டுபோவார். நானும் அவர்களை அழித்தொழிப்பேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","நீங்கள் அவர்களுடைய தெய்வங்களை வணங்கவோ, வழிபடவோ, அவர்களின் பழக்கவழக்கங்களைப் பின்பற்றவோ வேண்டாம். நீங்கள் அவற்றை அழித்து அவர்களின் தெய்வச்சிலைகளையும் துண்டுகளாக நொறுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","நீங்கள் உங்கள் இறைவனாகிய யெகோவாவையே வழிபடுங்கள், அவருடைய ஆசீர்வாதம் உங்கள் உணவிலும், தண்ணீரிலும் இருக்கும். உங்களிடமிருந்து நோயை நீக்கிவிடுவேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","உங்கள் நாட்டில் ஒருவரும் கருச்சிதைவடையவோ, மலட்டுத்தன்மை உடையவர்களாகவோ இருக்கமாட்டார்கள். உங்களுக்கு முழுமையான ஆயுள் காலத்தை நான் கொடுப்பேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“நான் உங்களுக்கு முன்பாக என் பயங்கரத்தை அனுப்பி, நீங்கள் எதிர்கொள்ளும் ஒவ்வொரு நாட்டினரையும் கலங்கப்பண்ணுவேன். உங்கள் பகைவரையெல்லாம் புறமுதுகு காட்டி ஓடச்செய்வேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","ஏவியரையும் கானானியரையும் ஏத்தியரையும் உங்கள் வழியைவிட்டுத் துரத்திவிட உங்களுக்கு முன்னே குளவிகளை அனுப்புவேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","ஆனால் நான் அவர்களை ஒரு வருடத்திற்குள்ளாகவே துரத்திவிடமாட்டேன். அப்படிச் செய்தால், நாடு பாழாய்ப் போய்விடும், காட்டு விலங்குகளும் உங்களால் சமாளிக்க முடியாத அளவு பெருகிவிடும். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","நீங்கள் அந்நாட்டை உரிமையாக்கிக்கொள்ளும் அளவுக்குப் பெருகுகிறவரைக்கும், நான் கொஞ்சம் கொஞ்சமாய் அவர்களை உங்கள் முன்னின்று துரத்துவேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“செங்கடல் தொடங்கி பெலிஸ்தியரின் கடல் வரைக்கும், பாலைவனம்தொடங்கி யூப்பிரடீஸ் நதிவரைக்கும் உங்கள் எல்லையை நிலைப்படுத்துவேன். அந்நாட்டில் வாழும் மக்களை உங்கள் கையில் ஒப்புக்கொடுப்பேன். அப்பொழுது நீங்கள் அவர்களை உங்கள் முன்னிலையில் இருந்து வெளியே துரத்திவிடுவீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","அவர்களுடனோ, அவர்களின் தெய்வங்களுடனோ ஒரு உடன்படிக்கையையும் செய்யவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","உங்கள் நாட்டில் அவர்களை வாழவிடவேண்டாம். இல்லையெனில் நீங்கள் எனக்கு விரோதமாய் பாவம் செய்வதற்கு அவர்கள் காரணமாயிருப்பார்கள். அவர்கள் தங்கள் தெய்வங்களுக்குச் செய்யும் வழிபாடு நிச்சயமாக உங்களுக்கு ஒரு கண்ணியாக இருக்கும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","மேலும் யெகோவா மோசேயிடம் சொன்னதாவது: “நீயும், ஆரோனும், நாதாபும், அபியூவும், இஸ்ரயேலின் சபைத்தலைவர்கள் எழுபது பேரும் யெகோவாவிடம் மேலே வாருங்கள். நீங்கள் தூரத்திலிருந்தே வழிபடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","ஆனால் மோசே மட்டுமே யெகோவாவுக்கு அருகில் வரவேண்டும். மற்றவர்கள் அருகில் வரக்கூடாது. இஸ்ரயேல் மக்களும் மோசேயுடன் வரக்கூடாது.” ");
INSERT INTO tamtcv_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","மோசே மக்களிடம்போய் யெகோவாவினுடைய எல்லா வார்த்தைகளையும், சட்டங்களையும் அவர்களுக்குச் சொன்னான். அவர்கள் அனைவரும் ஒரே குரலில், “யெகோவா சொன்ன எல்லாவற்றையும் நாங்கள் செய்வோம்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","அப்பொழுது யெகோவா சொன்ன எல்லாவற்றையும் மோசே எழுதிவைத்தான். மறுநாள் அதிகாலையில் அவன் எழுந்து, மலையடிவாரத்தில் ஒரு பலிபீடத்தைக் கட்டி, இஸ்ரயேலின் பன்னிரண்டு கோத்திரங்களைக் குறிக்கும் விதமாக பன்னிரண்டு கல் தூண்களை நிறுத்தினான். ");
INSERT INTO tamtcv_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","அதன்பின் அவன் இஸ்ரயேலில் இளைஞர்களை அனுப்பினான். அவர்கள் தகன காணிக்கைகளைச் செலுத்தி, சமாதான காணிக்கையாக இளங்காளைகளை யெகோவாவுக்குப் பலியிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","அப்பொழுது மோசே இரத்தத்தில் அரைப்பங்கை எடுத்துக் கிண்ணங்களில் வைத்தான். மற்ற அரைப்பங்கைப் பலிபீடத்தின்மேல் தெளித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","பின்பு மோசே உடன்படிக்கைப் புத்தகத்தை எடுத்து மக்கள் கேட்கும்படி வாசித்தான். அவர்கள் அதைக்கேட்டு, “யெகோவா சொன்னபடியெல்லாம் நாங்கள் செய்வோம்; நாங்கள் கீழ்ப்படிவோம்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","அப்பொழுது மோசே இரத்தத்தை எடுத்து மக்கள்மேல் தெளித்து அவர்களிடம், “இந்த எல்லா வார்த்தைகளுக்கும் இணங்க யெகோவா உங்களோடு செய்துகொண்ட உடன்படிக்கையின் இரத்தம் இதுவே” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","அதன்பின், ஆரோனும், நாதாபும், அபியூவும், இஸ்ரயேலரின் சபைத்தலைவர்களில் எழுபது பேரும் மோசேயுடன் ஏறிப்போனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","அவர்கள் இஸ்ரயேலரின் இறைவனை அங்கே கண்டார்கள். அவருடைய பாதத்தின்கீழ் ஆகாயத்தைப்போல் தெளிவான நீலக்கல்லினால் அமைக்கப்பட்ட நடைபாதை போன்ற ஒன்று இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","அவர்கள் இறைவனைக் கண்டார்கள். அப்படியிருந்தும் இறைவன் இஸ்ரயேலின் தலைவர்களுக்கு விரோதமாகத் தன் கரத்தை உயர்த்தவில்லை. அவர்கள் இறைவன் முன்னிலையில் சாப்பிட்டுக் குடித்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","அப்பொழுது யெகோவா மோசேயிடம், “நீ மலையின்மேல் என்னிடத்திற்கு ஏறி வந்து இங்கேயே இரு. நான் அவர்களுடைய அறிவுறுத்தலுக்காக எழுதிய சட்டமும், கட்டளைகளும் அடங்கிய கற்பலகைகளை உனக்குக் கொடுப்பேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","பின்பு மோசே தன் உதவியாளனான யோசுவாவுடன் புறப்பட்டான். மோசே இறைவனுடைய மலைக்கு ஏறிப்போனான். ");
INSERT INTO tamtcv_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","அப்பொழுது மோசே இஸ்ரயேலின் சபைத்தலைவர்களிடம், “நாங்கள் மறுபடியும் உங்களிடம் திரும்பி வரும்வரை நீங்கள் இங்கேயே காத்திருங்கள். ஆரோனும், ஊரும் உங்களோடு இருக்கிறார்கள். யாராவது ஒரு வழக்கில் ஈடுபட்டால் அவன் அவர்களிடம் போகலாம்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","மோசே மலையின்மேல் ஏறிப்போனான். அப்பொழுது மேகம் மலையை மூடிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","யெகோவாவின் மகிமையும், சீனாய் மலையின்மேல் தங்கியிருந்தது. மேகம் மலையை ஆறு நாட்களுக்கு மூடியிருந்தது. ஏழாம்நாள் யெகோவா மேகத்துக்குள் இருந்து மோசேயைக் கூப்பிட்டார். ");
INSERT INTO tamtcv_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","மலையின் உச்சியில் காணப்பட்ட யெகோவாவினுடைய மகிமை இஸ்ரயேலருக்கு பட்சிக்கும் நெருப்பைப்போல் தெரிந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","திரும்பவும் மோசே மலையின்மேல் ஏறிப்போகும்போது மேகத்திற்குள் புகுந்தான். அந்த மலையிலே அவன் நாற்பது பகலும் நாற்பது இரவும் தங்கியிருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","யெகோவா மோசேயிடம் சொன்னதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“எனக்குக் காணிக்கை கொண்டுவரும்படி இஸ்ரயேல் மக்களுக்குச் சொல். உள்ளத்தில் ஆர்வத்துடன் கொடுக்கும் ஒவ்வொருவனிடமிருந்தும் காணிக்கையை எனக்காக நீ ஏற்றுக்கொள்ளவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","“நீ அவர்களிடம் வாங்க வேண்டிய காணிக்கைகள் இவையே: “தங்கம், வெள்ளி, வெண்கலம்; ");
INSERT INTO tamtcv_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","நீலம், ஊதா, கருஞ்சிவப்புநூல், மென்பட்டுத் துணி; வெள்ளாட்டு உரோமம், ");
INSERT INTO tamtcv_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","சிவப்புச் சாயம் தோய்ந்த செம்மறியாட்டுக் கடாவின் தோல், கடல்பசுவின் தோல்; சித்தீம் மரம்; ");
INSERT INTO tamtcv_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","வெளிச்சத்திற்கான ஒலிவ எண்ணெய்; அபிஷேக எண்ணெய்க்கும் நறுமண தூபத்திற்குமான வாசனைப் பொருட்கள்; ");
INSERT INTO tamtcv_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ஏபோத்திலும், மார்புப் பதக்கத்திலும் பதிப்பதற்கான கோமேதகக் கற்கள் மற்றும் இரத்தினக் கற்கள் ஆகியவையே. ");
INSERT INTO tamtcv_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“அதன்பின் அவர்கள் எனக்காக ஒரு பரிசுத்த இடத்தை அமைக்கட்டும். நான் அவர்கள் மத்தியில் குடியிருப்பேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","இந்த இறைசமுகக் கூடாரத்தையும், அதன் எல்லா பணிமுட்டுகளையும் நான் உனக்குக் காட்டும் மாதிரியின்படியே செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“அவர்கள் சித்தீம் மரத்தால் ஒரு பெட்டியைச் செய்யவேண்டும். அதன் நீளம் இரண்டரை முழமும், அகலம் ஒன்றரை முழமும், உயரம் ஒன்றரை முழமுமாக இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","நீ அந்தப் பெட்டியை, உள்ளேயும் வெளியேயும் சுத்தத் தங்கத்தகட்டால் மூடவேண்டும். அதைச் சுற்றிலும் தங்கத்தினாலான ஒரு விளிம்புச்சட்டத்தைச் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","தங்கத்தினால் நான்கு வளையங்கள் வார்ப்பித்து, அவற்றை அதன் நான்கு கால்களிலும் பொருத்து. அவைகள் ஒரு பக்கத்தில் இரண்டும், மறுபக்கத்தில் இரண்டும் பொருத்தப்பட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","சித்தீம் மரத்தினால் கம்புகளைச் செய்து, அவற்றைச் சுத்தத் தங்கத் தகட்டினால் மூடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","பெட்டியைச் சுமப்பதற்கு, அந்தக் கம்புகளை பெட்டியின் பக்கங்களில் இருக்கும் வளையங்களில் மாட்டிவை. ");
INSERT INTO tamtcv_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","பெட்டியின் வளையங்களிலேயே அந்தக் கம்புகள் இருக்கவேண்டும். அவைகள் அகற்றப்படாமல் அப்படியே இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","நான் உனக்குத் தரப்போகும் சாட்சிப்பிரமாணத்தை அந்தப் பெட்டிக்குள் வை. ");
INSERT INTO tamtcv_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“சுத்தத் தங்கத்தினால் ஒரு கிருபாசனத்தைச் செய்யவேண்டும். அது இரண்டரை முழம் நீளமும், ஒன்றரை முழம் அகலமுமாயிருக்க வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","அதன் இரு முனைகளிலும் தங்கத்தகட்டால் இரண்டு கேருபீன்களைச் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ஒரு கேருபீனை ஒரு முனையிலும், இன்னொன்றை மறு முனையிலும் செய்யவேண்டும். கிருபாசனத்தின் இரண்டு முனைகளிலும் கேருபீன்கள் அமையும்படி, ஒரே தகட்டினாலேயே அவற்றைச் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","அந்தக் கேருபீன்களின் சிறகுகள் கிருபாசனத்தை மூடியபடி மேல்நோக்கி விரிந்திருக்க வேண்டும். அந்த கேருபீன்கள் கிருபாசனத்தைப் பார்த்தபடி ஒன்றுக்கொன்று எதிரெதிராக இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","கிருபாசனத்தைப் பெட்டியின்மேல் வை. நான் உனக்குக் கொடுக்கப்போகும் சாட்சியத்தை பெட்டிக்குள் வை. ");
INSERT INTO tamtcv_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","அங்கே கிருபாசனத்தின் மேலும் சாட்சிப்பெட்டியின்மேலும் இருக்கும் இரண்டு கேருபீன்களுக்கிடையில் நான் உன்னைச் சந்தித்து, இஸ்ரயேலருக்கான எல்லா கட்டளைகளையும் உன்னிடம் கொடுப்பேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“மேலும் சித்தீம் மரத்தினால் ஒரு மேஜையைச் செய்யவேண்டும். அது இரண்டு முழம் நீளமும், ஒரு முழம் அகலமும், ஒன்றரை முழம் உயரமுமாய் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","அதைச் சுத்தமான தங்கத்தகட்டால் மூடி, அதைச் சுற்றிலும் தங்க விளிம்புச்சட்டத்தைச் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","அத்துடன் அதைச் சுற்றிலும் நான்கு விரலளவு அகலமான ஒரு சட்டத்தைச் செய்து, அதன்மேல் தங்க விளிம்புச்சட்டத்தை இணை. ");
INSERT INTO tamtcv_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","மேஜைக்காக நான்கு தங்க வளையங்களைச் செய்து, கால்கள் இருக்கும் நான்கு மூலைகளிலும் பொருத்து. ");
INSERT INTO tamtcv_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","மேஜையைத் தூக்குவதற்காகப் பயன்படுத்தப்படும் கம்புகளைப் பிடிக்கும்படி, அந்த வளையங்கள் விளிம்புச் சட்டத்தின் அருகே இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","அக்கம்புகளை சித்தீம் மரத்தால் செய்து, தங்கத்தகட்டால் மூடவேண்டும். அவற்றினாலேயே இந்த மேஜையைச் சுமக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","மேஜையின் தட்டுகளையும், கிண்ணங்களையும் சுத்தத் தங்கத்தினால் செய்யவேண்டும். அத்துடன் பானகாணிக்கைகளை ஊற்றுவதற்கான கிண்ணங்களையும், ஜாடிகளையும் தங்கத் தகட்டினாலேயே செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","இறைசமுக அப்பம் எப்பொழுதும் எனக்கு முன்னாக இருக்கும்படி அதை இந்த மேஜையின்மேல் வை. ");
INSERT INTO tamtcv_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“சுத்தத் தங்கத்தினால் ஒரு குத்துவிளக்கைச் செய்யவேண்டும். அதன் அடிப்பாகமும், தண்டும், பூ வடிவமான அதன் கிண்ணங்களும், மொட்டுகளும், பூக்களும் அடிக்கப்பட்ட சுத்தத் தங்கத்தினாலேயே செய்யப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","ஆறு கிளைகள் குத்துவிளக்கின் பக்கங்களிலிருந்து விரிந்து தோன்றவேண்டும். மூன்று கிளைகள் ஒரு பக்கத்திலும், மூன்று கிளைகள் மறுபக்கத்திலும் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ஒரு கிளையில் வாதுமை பூக்கள் வடிவமான மூன்று கிண்ணங்கள் அதன் மொட்டுகளுடனும், மலர்களுடனும் இருக்கவேண்டும். அப்படியே அடுத்த கிளையிலும் மூன்று கிண்ணங்கள் இருக்கவேண்டும். இவ்விதமாக அந்த குத்துவிளக்கிலிருந்து விரிந்துபோகும் ஆறுகிளைகளிலும் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","குத்துவிளக்கின் உச்சியில் வாதுமைப் பூக்களைப் போன்ற நான்கு கிண்ணங்கள் அவற்றின் மொட்டுகளோடும், மலர்களோடும் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","குத்துவிளக்கிலிருந்து விரியும், முதல் ஜோடிக்கிளைகளுக்குக் கீழே, ஒரு மொட்டு இருக்கவேண்டும். இரண்டாவது ஜோடிக்கிளைகளுக்குக் கீழே இரண்டாவது மொட்டு இருக்கவேண்டும். மூன்றாவது ஜோடிக்கிளைகளுக்குக் கீழே மூன்றாவது மொட்டு இருக்கவேண்டும். எல்லாமுமாக ஆறு கிளைகள் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","மொட்டுகளும், கிளைகளும் குத்துவிளக்குடன் சுத்தத் தங்கத்தின் ஒரே தகட்டிலிருந்து அடித்துச் செய்யப்பட்டிருக்க வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“பின்பு அதற்கு ஏழு அகல் விளக்குகளைச் செய்து, குத்துவிளக்கின் முன்பக்கத்தில் வெளிச்சம் தரக்கூடியதாக, அவற்றை குத்துவிளக்கின் மேல் வை. ");
INSERT INTO tamtcv_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","விளக்குத்திரி கத்தரிகளும், தட்டுகளும் சுத்தத் தங்கத்தினால் செய்யப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","குத்துவிளக்கையும், அதற்குரிய உபகரணங்கள் யாவற்றையும் செய்ய ஒரு தாலந்து சுத்தத்தங்கத்தைப் பயன்படுத்த வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","இங்கே மலையின்மேல் உனக்குக் காண்பிக்கப்பட்ட மாதிரியின்படியே, இவைகளையெல்லாம் செய்யும்படி நீ கவனமாயிரு.” ");
INSERT INTO tamtcv_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","இறைசமுகக் கூடாரத்தைப் பத்து மூடுதிரைகளைக் கொண்டு செய்யவேண்டும். அத்திரைகள் தரமாகத் திரித்த மென்பட்டு, நீலநூல், ஊதாநூல், கருஞ்சிவப்புநூல் ஆகியவற்றைக்கொண்டு நெய்யப்பட்டிருக்க வேண்டும். சிறந்த தொழில் வல்லுநரால் அதில் கேருபீன்களின் உருவம் சித்திர வேலையாய் செய்யப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","எல்லா திரைகளும் ஒரே அளவாக இருக்கவேண்டும். ஒவ்வொன்றும் இருபத்தெட்டு முழம் நீளமும், நான்கு முழம் அகலமும் அளவுள்ளதாய் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","அதில் ஐந்து திரைகளை ஒன்றாக இணை, மற்ற ஐந்து திரைகளுக்கும் அப்படியே செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","இணைக்கப்பட்ட ஒரு தொகுப்புத் திரையின் கடைசி விளிம்பில் நீலநிறத் துணியினால் வளையங்களைச் செய்யவேண்டும். மற்ற தொகுப்புத் திரையின் கடைசி விளிம்பிலும் அப்படியே செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","ஒரு திரையில் ஐம்பது வளையங்களைச் செய்; மற்றத் தொகுப்பு திரையின் கடைசியிலும் ஐம்பது வளையங்களைச் செய்யவேண்டும். அந்த வளையங்கள் ஒன்றுக்கொன்று எதிரெதிராய் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","பின்பு தங்கத்தினால் ஐம்பது கொக்கிகளைச் செய், இந்த இறைசமுகக் கூடாரம் ஒரே இணைப்பாக இருக்கும்படி, இரண்டு தொகுப்பு திரைகளையும் ஒன்றாக இணைப்பதற்கு இக்கொக்கிகளைப் பயன்படுத்து. ");
INSERT INTO tamtcv_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","இறைசமுகக் கூடாரத்திற்கு மேலாகக் கூடாரம் அமைப்பதற்கு வெள்ளாட்டு மயிரினால் பதினோரு திரைகளைச் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","அந்த பதினோரு திரைகளும் ஒரே அளவாய் இருக்கவேண்டும். ஒவ்வொன்றும் முப்பது முழம் நீளமும் நான்கு முழம் அகலமும் உடையதாய் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","இவற்றில் ஐந்து திரைகளை ஒரு தொகுப்பாகவும், மற்ற ஆறு திரைகளையும் இன்னொரு தொகுப்பாக ஒன்றிணைக்கவேண்டும். ஆறாவது திரையை கூடாரத்தின் முன்பகுதியில் இரண்டாக மடித்துப்போடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","ஒரு தொகுப்பு திரையில் கடைசி திரையின் விளிம்பு நெடுகிலும், ஐம்பது வளையங்கள் செய்யவேண்டும். மற்ற தொகுப்பு திரையின் கடைசி விளிம்பு நெடுகிலும் அப்படியே செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","அதன்பின் ஐம்பது வெண்கலக் கொக்கிகளைச் செய்து, கூடாரத்தை ஒரே பகுதியாக இணைப்பதற்கு அந்த வளையங்களில் அந்தக் கொக்கிகளைப் போடு. ");
INSERT INTO tamtcv_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","கூடாரத்திரைகளின் மீதமுள்ள கூடுதலான நீளத்தைப் பொறுத்தவரையில், விடப்பட்ட பாதி திரையை இறைசமுகக் கூடாரத்தின் பின்பக்கத்தில் தொங்கவிட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","கூடாரத்திரைகளின் நீளம் இரண்டு பக்கங்களிலும் ஒவ்வொரு முழம் கூடுதலாக இருக்கும். மீதமிருப்பது இறைசமுகக் கூடாரத்தை மூடும்படியாக இரண்டு பக்கங்களிலும் தொங்கும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","அக்கூடாரத்திற்காக மூடுதிரையை, சிவப்புச் சாயம் தோய்த்த செம்மறியாட்டுக் கடாவின் தோலினால் செய்யவேண்டும். அதற்கு மேலாகப் போடுவதற்காக, கடல்பசுத் தோலினால் மற்றொரு மூடுதிரையைச் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","இறைசமுகக் கூடாரத்திற்காக சித்தீம் மரத்தினால் நிமிர்ந்து நிற்கும் மரச்சட்டங்களைச் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","ஒவ்வொரு மரச்சட்டமும் பத்து முழம் நீளமும், ஒன்றரை முழம் அகலமுமாய் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","ஒவ்வொரு மரச்சட்டத்திலும் ஒன்றுக்கொன்று இணைந்ததாக அமைக்கப்பட்ட, இரண்டு முளைகள் இருக்கவேண்டும். இவ்விதமாக இறைசமுகக் கூடாரத்தின் எல்லா மரச்சட்டங்களும் செய்யப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","இறைசமுகக் கூடாரத்தின் தெற்கு பக்கத்தில் நிறுத்துவதற்காக இருபது மரச்சட்டங்களைச் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","அந்த இருபது மரச்சட்டங்களை வைப்பதற்கு வெள்ளியினால் நாற்பது அடித்தளங்களைச் செய்யவேண்டும். ஒவ்வொரு முளைக்கும் கீழே ஒரு அடித்தளமாக ஒவ்வொரு மரச்சட்டத்துக்கும் இரண்டு அடித்தளங்களைச் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","மற்ற பக்கத்திற்கு, இறைசமுகக் கூடாரத்தின் வடக்குப் பக்கத்துக்கு அப்படியே இருபது மரச்சட்டங்களைச் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ஒவ்வொரு மரச்சட்டத்துக்கும் இரண்டு அடித்தளங்களாக நாற்பது வெள்ளி அடித்தளங்களையும் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","இறைசமுகக் கூடாரத்தின் மேற்குப் பக்கமான கடைசியில் நிறுத்துவதற்கு ஆறு மரச்சட்டங்களைச் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","கடைசியில் உள்ள இரண்டு மூலைகளிலும் நிறுத்துவதற்கு இரண்டு மரச்சட்டங்களைச் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","இந்த இரண்டு மூலைகளிலும் அவை கீழேயிருந்து மேலேவரை இரட்டைப் பலகைகளாக இணைக்கப்பட வேண்டும். அவைகள் ஒரு வளையத்திலே இணைக்கப்பட வேண்டும். இரண்டும் அவ்வாறே இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","அப்பொழுது அந்த எட்டு மரச்சட்டங்களும் ஒவ்வொரு மரச்சட்டத்தின் கீழும், இரண்டிரண்டு வெள்ளி அடித்தளங்களாக, பதினாறு வெள்ளி அடித்தளங்களும் இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","அத்துடன் சித்தீம் மரத்தால் குறுக்குச் சட்டங்களைச் செய்யவேண்டும். இறைசமுகக் கூடாரத்தின் ஒரு பக்கத்திலுள்ள மரச்சட்டங்களுக்காக ஐந்து குறுக்குச் சட்டங்களையும், ");
INSERT INTO tamtcv_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","மறுபக்கத்திலுள்ள மரச்சட்டங்களுக்காக இன்னும் ஐந்து குறுக்குச் சட்டங்களையும், இறைசமுகக் கூடாரத்தின் பின்பக்கமான மேற்குப் பக்கத்திலுள்ள மரச்சட்டங்களுக்காக இன்னும் ஐந்து குறுக்குச் சட்டங்களையும் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","நடுவிலுள்ள குறுக்குச் சட்டம், மரச்சட்டங்களின் நடுவிலே ஒரு முனையிலிருந்து மறுமுனைவரை நீண்டிருக்க வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","அந்த மரச்சட்டங்களைத் தங்கத்தகட்டால் மூடி, குறுக்குச் சட்டங்களை மாட்டுவதற்காக தங்க வளையங்களையும் செய்யவேண்டும். குறுக்குச் சட்டங்களையும் தங்கத்தகட்டால் மூடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","மலையின்மேல் உனக்குக் காண்பிக்கப்பட்ட மாதிரியின்படியே இறைசமுகக் கூடாரத்தை அமைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","நீலம், ஊதா, சிவப்பு நூல்களினாலும், திரித்த மென்பட்டினாலும் ஒரு திரைச்சீலையைச் செய்து, அதில் திறமையான கலைஞரைக்கொண்டு கேருபீன்களின் சித்திரவேலையைச் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","அந்தத் திரையைத் தங்கத்தகட்டால் மூடப்பட்ட சித்தீம் மரத்தாலான நான்கு கம்பங்களில், தங்கக் கொக்கிகளால் தொங்கவிட வேண்டும். அந்த நான்கு கம்பங்களும் நான்கு வெள்ளி அடித்தளங்களில் நிறுத்தி வைக்கப்பட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","கொக்கிகளிலிருந்து திரையைத் தொங்கவிட்டுச் சாட்சிப்பெட்டியை திரைக்குப் பின்பாக வை. அத்திரை பரிசுத்த இடத்தையும், மகா பரிசுத்த இடத்தையும் பிரிக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","மகா பரிசுத்த இடத்திலே சாட்சிப்பெட்டியின்மேல் கிருபாசனத்தை வை. ");
INSERT INTO tamtcv_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","திரைக்கு வெளியே இறைசமுகக் கூடாரத்தின் வடக்குப் பக்கத்தில் மேஜையையும், மேஜைக்கு எதிரே தென்புறமாகக் குத்துவிளக்கையும் வை. ");
INSERT INTO tamtcv_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","கூடாரத்தின் வாசலுக்கு நீலநூல், ஊதாநூல், கருஞ்சிவப்புநூல், திரித்த மென்பட்டு ஆகியவற்றால் ஒரு திரைச்சீலையைச் செய்யவேண்டும். அது ஒரு சித்திரத்தையற்காரனின் வேலையாய் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","அத்திரைக்குத் தங்கக் கொக்கிகளையும், சித்தீம் மரத்தால் ஐந்து கம்பங்களையும் செய்து, அதைத் தங்கத்தகட்டால் மூடவேண்டும். அந்தக் கம்பங்களுக்கு வெண்கலத்தால் ஐந்து அடித்தளங்களையும் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“சித்தீம் மரத்தினால் மூன்று முழம் உயரமான ஒரு பலிபீடத்தைச் செய்யவேண்டும். அது ஐந்து முழம் நீளமும், ஐந்து முழம் அகலமுமுள்ள சதுரமாய் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","அதன் நான்கு மூலைகளிலும் மூலைக்கு ஒவ்வொன்றாக நான்கு கொம்புகளைச் செய்யவேண்டும். கொம்புகளும், பலிபீடமும் ஒரே அமைப்பாய் இருக்கவேண்டும். பலிபீடத்தை வெண்கலத் தகட்டினால் மூடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","அதற்குரிய எல்லா பாத்திரங்களையும், வெண்கலத்தினாலேயே செய்யவேண்டும். சாம்பலை அகற்றுவதற்கான பானைகளும், சாம்பல் அள்ளும் வாரிகளும், தெளிப்பதற்கான கிண்ணங்களும், இறைச்சியைக் குத்தும் முட்கரண்டிகளும், நெருப்புச் சட்டிகளும் வெண்கலத்தால் செய்யப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","வெண்கலப் பின்னல் வேலைப்பாடான ஒரு கிராதியைச் செய்து, அதன் நான்கு மூலைகளிலும் ஒவ்வொரு வெண்கல வளையத்தை அமைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","பலிபீடத்தின் விளிம்பின் கீழ் அந்தக் கிராதியை வை. அது பலிபீடத்தின் அடியிலிருந்து பாதி உயரத்தில் இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","சித்தீம் மரத்தினால் பலிபீடத்திற்குத் தண்டுகளைச் செய்து, அவற்றை வெண்கலத் தகடுகளால் மூடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","பலிபீடத்தைக் கொண்டுசெல்லும்போது, அதன் இரண்டு பக்கங்களிலும் இருக்கத்தக்கதாக அந்தத் தண்டுகள் வளையங்களிலே மாட்டப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","பலிபீடத்தை மரப்பலகைகளினால் செய்யவேண்டும். அதன் உட்புறம் இடைவெளிவிட்டு வெறுமையாய் இருக்கவேண்டும். உனக்கு மலையில் காண்பிக்கப்பட்டபடியே அது செய்யப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“இறைசமுகக் கூடாரத்திற்கு ஒரு முற்றத்தை அமைக்கவேண்டும். முற்றத்தின் தெற்குப் பக்கம் நூறுமுழம் நீளமாய் இருக்கவேண்டும். திரித்த மென்பட்டு நூலினால் நெய்யப்பட்ட திரைகள் அங்கு இடப்பட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","அங்கே இருபது கம்பங்களும், அவற்றுக்கான இருபது வெண்கல அடித்தளங்களும் அமைக்கப்பட வேண்டும். அந்தக் கம்பங்களில் வெள்ளிக் கொக்கிகளும், பூண்களும் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","அப்படியே வடக்குப் பக்கமும் நூறுமுழம் நீளமாய் இருக்கவேண்டும். அங்கேயும் திரைகள் இருக்கவேண்டும். அவற்றுடன் இருபது கம்பங்களும், அவற்றுக்கான இருபது வெண்கல அடித்தளங்களும் அமைக்கப்பட வேண்டும். அந்தக் கம்பங்களில் வெள்ளிக் கொக்கிகளும், பூண்களும் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“முற்றத்தின் மேற்குப் பக்கமும் ஐம்பது முழம் அகலமாய் இருக்கவேண்டும். அங்கே பத்து கம்பங்களுடனும், பத்து அடித்தளங்களுடனும் திரைகள் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","சூரியன் உதிக்கும் திசையை நோக்கியிருக்கிற முற்றத்தின் கிழக்குப் பக்கமும் ஐம்பது முழம் அகலமாய் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","வாசலின் ஒரு பக்கத்தில் பதினைந்து முழம் நீளமான திரைகள் இருக்கவேண்டும். அவற்றுடன் மூன்று கம்பங்களும், மூன்று அடித்தளங்களும் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","வாசலின் மறுபக்கத்திலும், பதினைந்து முழம் நீளமான திரைகள் இருக்கவேண்டும். அவற்றிற்கும் மூன்று கம்பங்களும், மூன்று அடித்தளங்களும் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“முற்றத்தின் நுழைவு வாசலுக்கு இருபது முழம் நீளமான ஒரு திரையைச் செய்யவேண்டும். நீலநூல், ஊதாநூல், கருஞ்சிவப்புநூல், திரிக்கப்பட்ட மென்பட்டு ஆகியவற்றைக்கொண்டு சித்திரத்தையற்காரனின் வேலையாய் அது செய்யப்படவேண்டும். நான்கு கம்பங்களும், நான்கு அடித்தளங்களும் அதற்கு இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","முற்றத்தைச் சுற்றியுள்ள கம்பங்கள் எல்லாம் வெள்ளிப் பூண்களும், கொக்கிகளும் வெண்கல அடித்தளங்களும் உடையதாய் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","முற்றத்தின் நீளம் நூறு முழமாகவும், அகலம் ஐம்பது முழமாகவும் இருக்கவேண்டும். அதைச் சுற்றிலும் திரித்த மென்பட்டினாலான ஐந்து முழம் உயரமான திரைகளும் அவற்றின் வெண்கல அடித்தளங்களும் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","இறைசமுகக் கூடாரத்திற்கான முளைகளும், முற்றத்திற்கான முளைகளும், எல்லா உபயோகத்திற்காகவும் அங்கு பயன்படுத்தப்படும் எல்லா பொருட்களும் வெண்கலத்தினாலேயே செய்யப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“விளக்குகள் தொடர்ந்து எரிந்து ஒளி கொடுக்கும்படியாக, ஒலிவ விதைகளை இடித்துப் பிழிந்தெடுத்த தெளிந்த எண்ணெயைக் கொண்டுவரும்படி இஸ்ரயேலருக்குக் கட்டளையிடு. ");
INSERT INTO tamtcv_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","சபைக் கூடாரத்தில் சாட்சிப்பெட்டியின் முன்னால் இருக்கும் திரைக்கு வெளியே, ஆரோனும் அவன் மகன்களும் விளக்குகளை மாலைவேளை தொடங்கி விடியும்வரை யெகோவாவுக்கு முன்னால் எரிந்துகொண்டிருக்கச் செய்யவேண்டும். இது தலைமுறைதோறும் இஸ்ரயேலர் மத்தியில் நிரந்தர நியமமாய் இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“உன் சகோதரன் ஆரோனையும், அவன் மகன்களான நாதாப், அபியூ, எலெயாசார், இத்தாமார் ஆகியோரையும் இஸ்ரயேலர் மத்தியிலிருந்து உன்னிடம் அழைத்துக்கொள்ள வேண்டும். அவர்கள் ஆசாரியர்களாக எனக்கு ஊழியம் செய்யும்படி இதைச் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","உன் சகோதரனாகிய ஆரோனுக்கு மதிப்பும், கனமும் கொடுக்கும்படி அவனுக்குப் பரிசுத்த உடைகளைச் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","இவ்விதமான காரியங்களில், நான் ஞானத்தைக் கொடுத்திருக்கும் எல்லா திறமையுள்ள மனிதரிடமும் நீ பேசவேண்டும். ஆரோன் ஆசாரியனாக எனக்கு ஊழியம் செய்யும்படி அவனுடைய அர்ப்பணிப்புக்காக அவனுக்கான உடைகளைச் செய்யும்படி அவர்களுக்குச் சொல்லவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","அவர்கள் செய்யவேண்டிய உடைகள்: ஒரு மார்பு அணி, ஒரு ஏபோத், ஒரு மேலங்கி, நெய்யப்பட்ட ஒரு உள் அங்கி, ஒரு தலைப்பாகை, ஒரு இடைப்பட்டி ஆகியவையே. உன் சகோதரன் ஆரோனும், அவன் மகன்களும் எனக்கு ஆசாரியர்களாக ஊழியம் செய்யும்படி, திறமையுள்ளவர்கள் இந்த பரிசுத்த உடைகளைத் தயாரிக்க வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","அவர்கள் தங்கம், நீலம், ஊதா, கருஞ்சிவப்பு, மென்பட்டு நூல்களை பயன்படுத்த வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“தங்கத்தையும், நீலநூலையும், ஊதா நூலையும், கருஞ்சிவப்பு நூலையும், திரிக்கப்பட்ட மென்பட்டையும் கொண்டு திறமையான கைவினைக் கலைஞனின் வேலைப்பாடாய் ஏபோத்தைச் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","அதை அணிந்துகொள்ளத்தக்க விதமாய் அதன் இரண்டு முனைகளிலும் தோளுக்கான இரண்டு பட்டிகள் அதில் இணைக்கப்பட்டிருக்க வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","அதன் நுட்பமாக நெய்யப்பட்ட அதன் இடைப்பட்டியும் அதைப் போலவே இருக்கவேண்டும். அது ஏபோத்துடன் ஒரே இணைப்பாக தங்கம், நீலநூல், ஊதாநூல், கருஞ்சிவப்புநூல், திரித்த மென்பட்டு ஆகியவற்றால் செய்யப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“இரண்டு கோமேதகக் கற்களை எடுத்து அவற்றில் இஸ்ரயேலின் மகன்களின் பெயர்களைச் செதுக்கு. ");
INSERT INTO tamtcv_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","அவர்கள் பிறந்த வரிசையின்படியே ஆறு மகன்களின் பெயர்கள் ஒரு கல்லிலும், மற்ற ஆறு மகன்களின் பெயர்கள் மற்றொரு கல்லிலும் செதுக்கப்பட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","இரத்தினங்களில் முத்திரையை வெட்டிச் செய்வதுபோல், அந்த இரண்டு கற்களிலும் இஸ்ரயேலின் மகன்களின் பெயர்களைச் செதுக்கி வைக்கவேண்டும். பின்பு அந்தக் கற்களை தங்கச்சரிகை வேலைப்பாடுகளில் பதிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","பின்பு அவற்றை இஸ்ரயேலின் மகன்களின் ஞாபகார்த்தக் கற்களாக ஏபோத்தின் தோள் துண்டுகளில் கட்டவேண்டும். ஆரோன் இந்தப் பெயர்களை யெகோவாவுக்கு முன்பாக ஒரு ஞாபகார்த்தமாய் தன் தோள்களில் சுமக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","தங்கச்சரிகை வேலைப்பாடுகளைச் செய்து, ");
INSERT INTO tamtcv_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","அத்துடன் சுத்தத் தங்கத்தினால் கயிறுபோல பின்னப்பட்ட இரண்டு சங்கிலிகளைச் செய்து, அவற்றை அந்தச் சரிகை வேலைப்பாட்டுடன் தொடுத்துக்கொள்ள வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“திறமையான கைவினைக் கலைஞனின் வேலைப்பாடாக தீர்மானங்கள் எடுப்பதற்கான ஒரு மார்பு அணியைச் செய்யவேண்டும். ஏபோத்தைப்போலவே அதைத் தங்கம், நீலநூல், ஊதாநூல், கருஞ்சிவப்புநூல், திரித்த மென்பட்டு ஆகியவற்றைக்கொண்டு அதைச் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","அது ஒரு சாண் நீளம், ஒரு சாண் அகலம் கொண்ட சதுரமாகவும், இரண்டாக மடிக்கப்பட்டதாகவும் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","அதன்மேல் நான்கு வரிசைகளில் இரத்தினக் கற்களைப் பதிக்கவேண்டும். முதல் வரிசையில் பத்மராகம், புஷ்பராகம், மாணிக்கம்; ");
INSERT INTO tamtcv_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","இரண்டாம் வரிசையில் மரகதம், இந்திரநீலம், வைரம்; ");
INSERT INTO tamtcv_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","மூன்றாம் வரிசையில் கெம்பு, வைடூரியம், சுகந்தி; ");
INSERT INTO tamtcv_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","நான்காம் வரிசையில் படிகப்பச்சை, கோமேதகம், யஸ்பி ஆகியவை இருக்கவேண்டும். அவற்றைத் தங்கச்சரிகை வேலையாக பதித்து வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","இஸ்ரயேலின் மகன்களின் பெயர்கள் ஒவ்வொன்றுக்கும் ஒவ்வொரு கற்களாக, பன்னிரண்டு கற்கள் இருக்கவேண்டும். பன்னிரண்டு கோத்திரங்களின் பெயர்களும் ஒவ்வொரு கல்லிலும் முத்திரையைப்போல் பொறிக்கப்பட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“மார்பு அணிக்காக கயிறுபோல் பின்னப்பட்ட ஒரு சங்கிலியைச் சுத்தத் தங்கத்தினால் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","அதற்காக இரண்டு தங்க வளையங்களைச் செய்து மார்பு அணியின் இரண்டு மூலைகளிலும் தொடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","அந்த இரண்டு தங்கச்சங்கிலிகளையும் மார்பு அணியின் மூலைகளிலுள்ள இரண்டு வளையங்களோடு தொடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","சங்கிலிகளின் மற்ற இரண்டு முனைகளையும் ஏபோத்தின் முன்பக்கத்தில் உள்ள தோள்பட்டியுடன் இணைந்திருக்கும் சரிகை வேலைப்பாடுகளுடன் தொடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","இரண்டு தங்க வளையங்களைச் செய்து, அவற்றை ஏபோத்துடன் ஒட்டியிருக்கும் மார்பு அணியின் உட்புற விளிம்பில், இரண்டு மூலைகளிலும் தொடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","வேறு இரண்டு தங்க வளையங்களைச் செய்து, ஏபோத்திலுள்ள இடைப்பட்டிக்கு மேலாக உள்ள இணைப்புக்குச் சமீபமாய், ஏபோத்தின் முன்பக்கத்தில் இருக்கிற தோள்பட்டிகளின் அடிப்பக்கத்தில் தொடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","மார்பு அணி ஏபோத்தில் இருந்து விலகாதபடி, அதை இடைப்பட்டியுடன் இணைத்து, மார்பு அணியின் வளையங்களை ஏபோத்தின் வளையங்களுடன் நீலநிற நாடாவினால் இணைத்துக் கட்டவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“ஆரோன் பரிசுத்த இடத்திற்குள் போகும்போதெல்லாம், இஸ்ரயேலின் மகன்களின் பெயர்களை தன் இருதயத்திற்கு மேலுள்ள தீர்மானத்திற்கான மார்பு அணியின்மேல் நிரந்தரமான ஒரு ஞாபகச்சின்னமாக, யெகோவாவுக்குமுன் சுமப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","யெகோவா முன்னிலையில் ஆரோன் வரும்போதெல்லாம், அவனுடைய இருதயத்தின்மேல் இருக்கும்படி ஊரீம், தும்மீம் ஆகியவற்றை அந்த மார்பு அணியில் வைக்கவேண்டும். இவ்வாறு ஆரோன் இஸ்ரயேலருக்கான தீர்மானங்களைச் செய்யும் சாதனங்களை எப்பொழுதும் யெகோவா முன்னிலையில் தன் இருதயத்திற்கு மேல் சுமப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“ஏபோத்துடன் அணியும் மேலங்கி முழுவதும், நீலநிறத் துணியினாலேயே செய்யப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","அதன் நடுப்பகுதியில் தலை நுழையும் துவாரம் இருக்கவேண்டும். அந்த துவாரம் கிழிந்து போகாதபடி, அதைச் சுற்றிலும் கழுத்துப்பட்டியைப் போன்ற ஒரு நெய்யப்பட்ட விளிம்பு இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","மேலங்கிக்குக் கீழே ஓரத்தைச் சுற்றிலும் நீலநூல், ஊதாநூல், சிவப்புநூல் ஆகியவற்றால் மாதுளம் பழங்களைச் செய்து, அவைகளுக்கு இடையிடையே தங்க மணிகளைத் தொங்கவிட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","மேலங்கிக்குக் கீழே ஓரத்தைச் சுற்றிலும் தங்க மணியும், மாதுளம் பழமும் மாறிமாறித் தொங்கவிட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","ஆரோன் தன் ஆசாரிய ஊழியத்தைச் செய்யப்போகும்போது இந்த அங்கியை அணிந்துகொள்ள வேண்டும். யெகோவாவுக்குமுன் பரிசுத்த இடத்திற்குள் போகும்போதும், அங்கிருந்து வரும்போதும், அந்த மணியின் சத்தம் கேட்கும். எனவே அவன் சாகாதிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“சுத்தத் தங்கத்தினால் தகடு ஒன்றைச் செய்து அதில், யெகோவாவுக்குப் பரிசுத்தம் என்று ஒரு முத்திரையைப்போல பொறிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","“அதைத் தலைப்பாகையுடன் சேர்த்துக் கட்டும்படி ஒரு நீலநிற நாடாவை அதில் இணைக்க வேண்டும். அது தலைப்பாகையின் முன்பக்கத்தில் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","அது ஆரோனுடைய நெற்றியில் இருக்கவேண்டும். இஸ்ரயேலர் அர்ப்பணிக்கும் பரிசுத்த கொடைகள் எதுவானாலும், அவற்றுடன் சம்பந்தப்பட்ட குற்றத்தை அவன் சுமப்பான். அந்தக் கொடைகள் யெகோவாவினால் ஏற்றுக்கொள்ளப்படும்படி, அந்தத்தகடு அவனுடைய நெற்றியின்மேல் தொடர்ந்து இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“மென்பட்டு நூலினால் உள் அங்கியை நெய்து, மென்பட்டினால் தலைப்பாகையையும் செய்யவேண்டும். இடைப்பட்டி சித்திரத்தையற்காரனின் வேலையாய் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","ஆரோனுடைய மகன்களுக்கு மதிப்பையும், கனத்தையும் கொடுப்பதற்கு அவர்களுக்கும் உள் அங்கிகளையும், இடைப்பட்டிகளையும், அத்துடன் குல்லாக்களையும் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","நீ அந்த உடைகளை உன் சகோதரன் ஆரோனுக்கும், அவன் மகன்களுக்கும் அணிவித்தபின், அவர்களை அபிஷேகித்து நியமனம் செய்யவேண்டும். அவர்கள் எனக்கு ஆசாரியர்களாக ஊழியம் செய்யும்படி, அவர்களை அர்ப்பணம் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“அவர்களுடைய உடலை மூடுவதற்கான கால் சட்டையை மென்பட்டினால் செய்யவேண்டும். அவை இடுப்பிலிருந்து தொடைவரை இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","ஆரோனும், அவன் மகன்களும் சபைக் கூடாரத்திற்குள் போகும்போதோ அல்லது பரிசுத்த இடத்தில் ஆசாரிய ஊழியம் செய்யும்படி பலிபீடத்தை நெருங்கும்போதோ, குற்றம் உள்ளவர்களாகிச் சாகாதபடி, அவற்றை அணிந்திருக்க வேண்டும். “இது ஆரோனுக்கும், அவனுக்குப் பின்வரும் அவன் சந்ததிகளுக்கும் நிரந்தர நியமமாய் இருக்கும்.” ");
INSERT INTO tamtcv_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“அவர்கள் ஆசாரியர்களாக எனக்கு ஊழியம் செய்யும்படி, அவர்களை அர்ப்பணம் செய்வதற்கு நீ செய்யவேண்டியது இதுவே: குறைபாடற்ற ஒரு இளங்காளையையும், இரண்டு செம்மறியாட்டுக் கடாக்களையும் எடுத்துக்கொள்ளவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","சிறந்த கோதுமை மாவினால் புளிப்பில்லாத அப்பத்தையும், எண்ணெய் சேர்த்துப் பிசைந்த அடை அப்பங்களையும், எண்ணெய் கலந்த அதிரசங்களையும் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","அவற்றை ஒரு கூடையில் வைத்து, அந்தக் காளையுடனும் இரண்டு செம்மறியாட்டுக் கடாக்களுடனும் காணிக்கையாகக் கொடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","பின்பு ஆரோனையும், அவன் மகன்களையும் சபைக் கூடாரத்தின் வாசலுக்கு முன்பாக வரச்செய்து, அவர்களைத் தண்ணீரால் கழுவவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","உடைகளை எடுத்து, உள் அங்கி, ஏபோத்துடன் அணியும் அங்கி, ஏபோத், மார்பு அணி ஆகியவற்றை ஆரோனுக்கு உடுத்தவேண்டும். அத்துடன் திறமையாய் நெய்யப்பட்ட இடைப்பட்டியினால் ஏபோத்தை அவனுக்குக் கட்டவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","அவனுடைய தலையில் தலைப்பாகையையும் அணிவித்து, அதன்மேல் பரிசுத்த தங்கக்கீரிடத்தையும் வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","பின்பு அபிஷேக எண்ணெயை எடுத்து, அவன் தலையின்மேல் ஊற்றி, அவனை அபிஷேகம் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","அதன்பின், அவனுடைய மகன்களை வரவழைத்து, அவர்களுக்கும் உள் அங்கிகளை அணிவிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","அவர்களுக்கும் குல்லாக்களை அணியவேண்டும். பின் இடைப்பட்டிகளை ஆரோனுக்கும் அவன் மகன்களுக்கும் கட்டவேண்டும். ஆசாரியத்துவம் ஒரு நிரந்தர நியமத்தினால் அவர்களுக்கு உரியதாயிருக்கிறது. “இவ்விதமாக ஆரோனையும், அவன் மகன்களையும் நீ அர்ப்பணிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“அதன்பின் சபைக் கூடாரத்தின் முன்பாக காளையைக் கொண்டுவர வேண்டும். ஆரோனும் அவனுடைய மகன்களும் தங்கள் கைகளைக் காளையின் தலைமேல் வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","பின் சபைக் கூடாரத்தின் வாசலில் யெகோவா முன்னிலையில் அக்காளையை கொல்லவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","அந்தக் காளையின் இரத்தத்தில் கொஞ்சத்தை எடுத்து, உன் கை விரலினால் பலிபீடத்தின் கொம்புகளின்மேல் பூசி, மிஞ்சிய இரத்தத்தைப் பலிபீடத்தின் அடியிலே ஊற்றவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","பின்பு அதன் உள் உறுப்புகளை மூடியுள்ள கொழுப்புகள் அனைத்தையும், ஈரலை மூடியுள்ள கொழுப்பையும், இரண்டு சிறுநீரகங்களையும், அதன் மேலுள்ள கொழுப்பையும் எடுத்து பலிபீடத்தின்மேல் எரிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","ஆனால் காளையின் இறைச்சியும், தோலும், குடலும் முகாமுக்கு வெளியே எரிக்கப்படவேண்டும். இது பாவநிவாரண காணிக்கை. ");
INSERT INTO tamtcv_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“அதன்பின் செம்மறியாட்டுக் கடாக்களில் ஒன்றைக் கொண்டுவர வேண்டும். அதன் தலைமேல் ஆரோனும், அவன் மகன்களும் தங்கள் கைகளை வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","பின்பு அதைக் கொன்று, அதன் இரத்தத்தைப் பலிபீடத்தின் எல்லா பக்கங்களிலும் தெளிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","அந்த செம்மறியாட்டுக் கடாவை துண்டங்களாக வெட்டி, அதன் உட்பாகங்களையும், கால்களையும் கழுவி, அவற்றை மற்ற இறைச்சித் துண்டுகளுடனும், அதன் தலையுடனும் வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","அதன்பின் செம்மறியாடுகள் முழுவதையும் பலிபீடத்தில் எரிக்கவேண்டும். இது யெகோவாவுக்கு நெருப்பினால் செலுத்தப்படும் மகிழ்ச்சியூட்டும் தகன காணிக்கையாகும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“பின்பு மற்ற செம்மறியாட்டுக் கடாவையும் கொண்டுவர வேண்டும். ஆரோனும் அவன் மகன்களும் அதன்மேல் தங்கள் கைகளை வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","அந்தக் கடாவையும் வெட்டிக்கொன்று, அதன் இரத்தத்தில் கொஞ்சத்தை ஆரோனுடைய, அவன் மகன்களுடைய வலது காது மடலிலும், வலது கையின் பெருவிரலிலும், வலது காலின் பெருவிரலிலும் பூசவேண்டும். பின்பு இரத்தத்தைப் பலிபீடத்தின் எல்லா பக்கங்களிலும் தெளிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","பலிபீடத்திலுள்ள இரத்தத்திலும், அபிஷேக எண்ணெயிலும் கொஞ்சம் எடுத்து, ஆரோன் மேலும் அவன் உடைகளின்மேலும், அவன் மகன்கள்மேலும், அவர்களுடைய உடைகள்மேலும் தெளிக்கவேண்டும். அதன்பின் அவனும், அவன் மகன்களும் அர்ப்பணிக்கப்படுவார்கள். அவர்களுடைய உடைகளும் அர்ப்பணிக்கப்படும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“அந்தச் செம்மறியாட்டின் கொழுப்பையும், அதன் கொழுத்த வாலையும், அதன் உள் உறுப்புகளை மூடியுள்ள கொழுப்பையும், ஈரலின் மேலுள்ள கொழுப்பையும், இரு சிறுநீரகங்களையும், அவற்றை மூடியுள்ள கொழுப்பையும், வலது தொடையையும் எடுக்கவேண்டும். இதுவே ஆரோனுடைய அவன் மகன்களுடைய அர்ப்பணிப்பிற்கான செம்மறியாட்டுக் கடா. ");
INSERT INTO tamtcv_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","அவற்றுடன் யெகோவா முன்பாக வைக்கப்பட்டிருந்த புளிப்பில்லாத அப்பங்களுள்ள கூடையிலிருந்து ஒரு அப்பத்தையும், எண்ணெய் சேர்த்து சுடப்பட்ட ஒரு அடை அப்பத்தையும், ஒரு அதிரசத்தையும் எடுத்துக்கொள்ளவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","அவற்றையெல்லாம் ஆரோனுடைய, அவன் மகன்களுடைய கைகளில் கொடுத்து, அவற்றை யெகோவா முன்பாக அசைவாட்டும் காணிக்கையாக அசைவாட்டவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","பின்பு அவற்றை அவர்களின் கைகளிலிருந்து வாங்கி, பலிபீடத்தின் மேலுள்ள தகன காணிக்கைகளுடன் யெகோவாவுக்கு நெருப்பினால் செலுத்தப்படும் மகிழ்ச்சியூட்டும் நறுமண காணிக்கையாக எரிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","ஆரோனின் அர்ப்பணிப்பிற்கான செம்மறியாட்டுக் கடாவின் நெஞ்சுப்பகுதியை எடுத்து, பின்பு அதை யெகோவா முன்னிலையில் அசைவாட்டும் காணிக்கையாக அசைவாட்டவேண்டும். இது உன் பங்காயிருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“ஆரோனுடைய, அவன் மகன்களுடைய அர்ப்பணிப்பிற்குரிய செம்மறியாட்டுக் கடாவின் பாகங்களாகிய அசைவாட்டப்பட்ட நெஞ்சுப்பகுதியையும், செலுத்தப்பட்ட தொடையையும் மிகவும் பரிசுத்தமான பங்காக வேறுபிரித்து வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","இஸ்ரயேலர்கள் சமாதான காணிக்கைகளையும், நன்றியறிதல் காணிக்கைகளையும் யெகோவாவுக்குச் செலுத்தும் போதெல்லாம் இந்தப் பாகங்கள் ஆரோனுக்கும் அவன் மகன்களுக்கும் கொடுக்கப்படவேண்டிய பங்கு ஆகும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“ஆரோனின் பரிசுத்த உடைகள் அவனுடைய சந்ததிக்கு, அவர்கள் அவற்றை உடுத்தி அபிஷேகம் பண்ணப்பட்டு, அர்ப்பணிக்கப்படும்படி அவர்களுக்கே சொந்தமாகும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","அவனுக்குப்பின் அவனுக்குரிய இடத்தில் ஆசாரியராக பரிசுத்த இடத்தில் ஊழியம் செய்வதற்கு சபைக் கூடாரத்திற்குள் வரும், அவனுடைய மகன் அந்த உடைகளை ஏழு நாட்கள் உடுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“ஆசாரியரின் அர்ப்பணிப்பிற்கான செம்மறியாட்டுக் கடாவை எடுத்து, அதன் இறைச்சியைப் பரிசுத்த இடத்திலே சமைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","ஆரோனும் அவன் மகன்களும், அந்த இறைச்சியையும், கூடையிலுள்ள அப்பங்களையும் சபைக்கூடார வாசலில் சாப்பிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","பரிசுத்தப்படுத்துவதற்கும் அர்ப்பணிப்புக்கும் பாவநிவிர்த்தியாக செலுத்தப்பட்ட அக்காணிக்கைகளை அவர்களே சாப்பிடவேண்டும். அவைகளை வேறு யாரும் சாப்பிடக்கூடாது, ஏனெனில் அவைகள் பரிசுத்தமானவை. ");
INSERT INTO tamtcv_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","அர்ப்பணிப்பிற்கான அந்த செம்மறியாட்டுக் கடாவின் இறைச்சியிலோ அல்லது அப்பங்களிலோ காலைவரை ஏதாவது மீதமிருந்தால், அவற்றை எரித்துவிடவேண்டும். ஏனெனில் அவை பரிசுத்தமானது, அவற்றைச் சாப்பிடக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“ஆரோனையும், அவன் மகன்களையும் அர்ப்பணம் செய்யும்படி, நான் உனக்குக் கட்டளையிட்ட எல்லாவற்றையும் அவர்களுக்குச் செய்யவேண்டும். அதைச் செய்வதற்கு ஏழு நாட்கள் எடுத்துக்கொள். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","ஒவ்வொரு நாளும் பாவநிவிர்த்தி செய்யும்படி, பாவநிவாரண காணிக்கையாக ஒரு காளையைப் பலியிடவேண்டும். பலிபீடத்திற்காகவும் பாவநிவிர்த்தி செய்து அதைப் பரிசுத்தப்படுத்து. அதை அர்ப்பணம் செய்வதற்காக எண்ணெயால் அபிஷேகம் செய்து பரிசுத்தப்படுத்து. ");
INSERT INTO tamtcv_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","பலிபீடத்திற்காக ஏழுநாட்களுக்கு பாவநிவிர்த்தி செய்து அதை அர்ப்பணம் செய்யவேண்டும். அப்பொழுது பலிபீடம் மகா பரிசுத்தமுள்ளதாயிருக்கும். அதைத் தொடுவது எதுவானாலும் அது பரிசுத்தமாகும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“ஒவ்வொரு நாளும் தொடர்ச்சியாக ஒரு வயதுடைய இரண்டு செம்மறியாட்டுக் குட்டிகளை பலிபீடத்தில் பலியாகச் செலுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","காலையில் ஒரு செம்மறியாட்டுக் குட்டியையும், பொழுது மறையும்போது மற்ற செம்மறியாட்டுக் குட்டியையும் செலுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","முதல் செம்மறியாட்டுக் குட்டியுடன் பத்தில் ஒரு எப்பா அளவான சிறந்த மாவை, நான்கில் ஒரு பங்கு ஹின் அளவான இடித்துப் பிழிந்த ஒலிவ எண்ணெயிலே பிசைந்து, அதையும் நான்கில் ஒரு ஹின் அளவான திராட்சை இரசத்தையும் பானகாணிக்கையாகச் செலுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","சூரியன் மறையும் வேளையிலும் காலையில் எடுத்த அதே தானியக் காணிக்கையுடனும், அதற்குரிய பானகாணிக்கையுடனும், மற்ற செம்மறியாட்டுக் குட்டியை, யெகோவாவுக்கு நெருப்பினால் செலுத்தப்படும் மகிழ்ச்சியூட்டும் நறுமண காணிக்கையாக பலியிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“நீங்கள் இந்த தகன காணிக்கையை தலைமுறைதோறும் சபைக் கூடாரத்தின் வாசலிலே யெகோவாவுக்கு முன்பாக என்றென்றும் தொடர்ச்சியாகச் செலுத்தவேண்டும். அங்கே நான் உன்னைச் சந்தித்து உன்னோடு பேசுவேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","நான் இஸ்ரயேல் மக்களையும் அங்கேயே சந்திப்பேன். அந்த இடம் எனது மகிமையால் அர்ப்பணிக்கப்படும். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“இவ்வாறு சபைக் கூடாரத்தையும், பலிபீடத்தையும் நான் அர்ப்பணம் செய்வேன். ஆசாரியர்களாக எனக்கு ஊழியம் செய்யும்படி ஆரோனையும், அவன் மகன்களையும் அர்ப்பணம் செய்வேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","இப்படிச் செய்து இஸ்ரயேலர் மத்தியில் நான் குடியிருந்து அவர்களின் இறைவனாயிருப்பேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","அவர்கள் மத்தியில் குடியிருக்கும்படி, அவர்களை எகிப்திலிருந்து வெளியே கொண்டுவந்த, அவர்களுடைய இறைவனாகிய யெகோவா நானே என்பதை அவர்கள் அறிந்துகொள்வார்கள். அவர்களுடைய இறைவனாகிய யெகோவா நானே. ");
INSERT INTO tamtcv_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“நறுமணத்தூளை எரிப்பதற்கு ஒரு தூபபீடத்தை சித்தீம் மரத்தினால் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","அது ஒரு முழம் நீளமும் ஒரு முழம் அகலமுமுள்ள சதுர வடிவில், இரண்டு முழம் உயரமுள்ளதாய் இருக்கவேண்டும். அதன் கொம்புகள் அதனுடன் இணைந்ததாய் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","அதன் மேல்பகுதியையும், அதன் எல்லா பக்கங்களையும், கொம்புகளையும் சுத்தத் தங்கத்தகட்டால் மூடி, அதைச் சுற்றிலும் தங்க விளிம்புச்சட்டத்தை அமைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","தூபபீடத்தின் தங்க விளிம்புச்சட்டத்துக்குக் கீழே இரண்டு தங்க வளையங்களை இரண்டு பக்கங்களிலும் அமைக்கவேண்டும். அதைச் சுமப்பதற்கான கம்புகளை அதற்குள் மாட்டும்படி எதிரெதிராக அவைகளை அமைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","அந்தக் கம்புகளையும் சித்தீம் மரத்தினால் செய்து, தங்கத்தகட்டால் மூடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","தூபபீடத்தை சாட்சிப்பெட்டியின் முன் இருக்கும் திரைக்கு முன்னால் வைக்கவேண்டும். அது நான் உன்னைச் சந்திக்கும் இடமான, சாட்சிப்பெட்டியை மூடியிருக்கும் கிருபாசனத்தின் முன்னே இருக்குமிடம். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“ஆரோன் காலைதோறும் விளக்குகளை ஆயத்தப்படுத்தும்போது நறுமணத்தூளை எரிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","பொழுதுபடும் நேரத்தில் அவன் விளக்கேற்றும்போது, திரும்பவும் நறுமணத்தூளை எரிக்கவேண்டும். இவ்விதமாக தலைமுறைதோறும் இந்த நறுமணத்தூள் யெகோவாவுக்குமுன் ஒவ்வொரு நாளும் தொடர்ச்சியாக எரிந்துகொண்டிருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","இவைகளைத்தவிர வேறெந்த நறுமணத்தூளையோ, தகன காணிக்கையையோ, தானியக் காணிக்கையையோ இப்பீடத்தின்மேல் செலுத்தாதே. அதன்மேல் பானகாணிக்கையை ஊற்றவும் வேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","ஆரோன் வருடத்திற்கு ஒருமுறை இப்பீடத்தின் கொம்புகளின்மேல் பாவநிவிர்த்தி செய்யவேண்டும். இந்த வருடாந்திர பாவநிவிர்த்தி, பாவநிவாரண பலியின் இரத்தத்தினால் தலைமுறைதோறும் செய்யப்படவேண்டும். இந்தத் தூபபீடம் யெகோவாவுக்கு மகா பரிசுத்தமானது” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","மேலும் யெகோவா மோசேயிடம் சொன்னதாவது, ");
INSERT INTO tamtcv_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“நீ இஸ்ரயேலரை மக்கள் தொகை கணக்கெடுப்பு செய்கையில், அவர்கள் ஒவ்வொருவரும் தன் உயிருக்காக ஒரு மீட்புப் பணத்தை யெகோவாவுக்குச் செலுத்தவேண்டும். அப்பொழுது நீ அவர்களைக் கணக்கிடுகையில் அவர்கள்மேல் ஒரு கொள்ளைநோயும் வராது. ");
INSERT INTO tamtcv_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","எண்ணப்படுகிறவன் ஏற்கெனவே எண்ணப்பட்டவர்களிடம் கடந்துபோகும்போது, பரிசுத்த இடத்தின் அளவின்படி அரைச்சேக்கல் கொடுக்கவேண்டும். ஒரு சேக்கல் இருபது கேரா நிறையுள்ளது. இந்த அரைச்சேக்கல் யெகோவாவுக்கான ஒரு காணிக்கையாகும். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","இருபது வயதுடையவர்களும், அதற்கு மேற்பட்டவர்களும் இவ்வாறு கடந்துபோகும் எல்லோரும் யெகோவாவுக்கு ஒரு காணிக்கையைக் கொடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","உங்கள் உயிர்களுக்குப் பாவநிவிர்த்தி செய்வதற்காக நீங்கள் யெகோவாவுக்கு காணிக்கை செலுத்தும்போது, செல்வந்தர்கள் அரைச்சேக்கலுக்கு அதிகமாகக் கொடுக்கவும் கூடாது, ஏழைகள் அதைவிடக் குறைவாகக் கொடுக்கவும் கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","நீயோ அந்த பாவநிவிர்த்திப் பணத்தை இஸ்ரயேலரிடம் இருந்து வாங்கி, சபைக் கூடாரப் பணிக்காக அதைப் பயன்படுத்த வேண்டும். அது உங்கள் உயிர்களுக்குப் பாவநிவிர்த்தி செய்யும்படி, யெகோவா முன்பாக இஸ்ரயேலருக்கான ஒரு ஞாபகார்த்தமாய் இருக்கும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","பின்னும் யெகோவா மோசேயிடம் சொன்னதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“நீ கழுவுவதற்காக ஒரு வெண்கலத் தொட்டியையும் அதன் வெண்கலக் கால்களையும் செய்யவேண்டும். அதைச் சபைக் கூடாரத்திற்கும் பலிபீடத்திற்கும் இடையில் வைத்து அதில் தண்ணீர் ஊற்றி வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","அதிலுள்ள தண்ணீரால் ஆரோனும், அவன் மகன்களும் தங்கள் கைகளையும் கால்களையும் கழுவவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","அவர்கள் சபைக் கூடாரத்திற்குள் போகும்போதெல்லாம் தாங்கள் சாகாதபடிக்குத் தண்ணீரினால் கழுவவேண்டும். அத்துடன், நெருப்பினால் யெகோவாவுக்கு செலுத்தப்படும் காணிக்கையைக் கொண்டுவந்து ஆசாரிய ஊழியம் செய்வதற்காக பலிபீடத்தை அணுகும்போதும், ");
INSERT INTO tamtcv_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","அவர்கள் சாகாதபடிக்குத் தங்கள் கைகளையும், கால்களையும் கழுவவேண்டும். இது ஆரோனுக்கும், அவன் சந்ததியினருக்கும் தலைமுறைதோறும் நிரந்தர நியமமாயிருக்கும்.” ");
INSERT INTO tamtcv_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","மேலும் யெகோவா மோசேயிடம் சொன்னதாவது, ");
INSERT INTO tamtcv_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“நீ பின்வரும் சிறந்த வாசனைப் பொருட்களை எடுக்கவேண்டும். திரவ வெள்ளைப்போளம் 500 சேக்கல், சுகந்த கறுவாப்பட்டை 250 சேக்கல், நறுமண வசம்பு 250 சேக்கல், ");
INSERT INTO tamtcv_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","இலவங்கப்பட்டை 500 சேக்கல் ஆகிய இவையெல்லாம் பரிசுத்த இடத்தின் சேக்கல் அளவின்படி இருக்கவேண்டும். அத்துடன் ஒரு ஹின் அளவு ஒலிவ எண்ணெயையும் எடுத்துக்கொள்ளவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","இவற்றைக்கொண்டு வாசனை தைலம் தயாரிப்பவன் செய்வதுபோல், வாசனைக் கலவையாக பரிசுத்த அபிஷேக எண்ணெயைச் செய்யவேண்டும். இது பரிசுத்த அபிஷேக எண்ணெயாயிருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","இந்த எண்ணெயை உபயோகித்து சபைக் கூடாரத்தையும், சாட்சிப்பெட்டியையும் அபிஷேகம் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","மேஜையையும், அதிலுள்ள பொருட்களையும், குத்துவிளக்குகளையும், அதின் உபகரணங்களையும், தூபபீடத்தையும் அபிஷேகம் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","தகன பலிபீடத்தையும், அதிலுள்ள எல்லா பாத்திரங்களையும், தொட்டியையும், அதன் கால்களையும் அபிஷேகம் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","அவை மகா பரிசுத்தமாயிருக்கும்படியும், அவற்றைத் தொடும் எதுவும் பரிசுத்தமாயிருக்கும்படியும் அவற்றை அர்ப்பணம் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“அத்துடன் ஆரோனும் அவன் மகன்களும், ஆசாரியர்களாக எனக்கு ஊழியம் செய்யும்படி, அவர்களை அபிஷேகம் செய்து அர்ப்பணம் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","இஸ்ரயேலருக்குச் சொல்லவேண்டியதாவது: தலைமுறைதோறும் இது எனக்கு பரிசுத்த அபிஷேக எண்ணெயாய் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","இதை ஒரு மனிதனுடைய உடலின்மேல் ஊற்றவோ, இந்தக் கலவை முறைப்படி வேறொரு எண்ணெயைத் தயார்செய்யவோ வேண்டாம். இது பரிசுத்தமானது. நீங்களும் இதைப் பரிசுத்தமாய் எண்ணவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","இதேபோல் வாசனைத் தைலத்தைச் செய்கிறவனோ அல்லது ஆசாரியரைத் தவிர வேறு யார்மேலாவது இந்த எண்ணெயைப் பூசுகிறவனோ தன் மக்களிடத்திலிருந்து அகற்றப்படவேண்டும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","பின்னும் யெகோவா மோசேயிடம் சொன்னதாவது: “பிசின் கலந்த குங்கிலியம், சாம்பிராணி, அல்பான்பிசின், சுத்தமான நறுமணமுள்ள குங்கிலியம் ஆகிய வாசனைப் பொருட்களை சமமான அளவு எடுத்துக்கொண்டு, ");
INSERT INTO tamtcv_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","இவற்றை வாசனை தைலம் தயாரிப்பவனின் வேலையைப் போல் வாசனைக் கலவையாக நறுமணத்தூளைச் செய்யவேண்டும். அது உப்பிடப்பட்டு, தூய்மையும், பரிசுத்தமுமாய் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","அதில் கொஞ்சத்தை அரைத்துத் தூளாக்கி, நான் உன்னைச் சந்திக்கும் இடமான சபைக் கூடாரத்திலுள்ள சாட்சிப்பெட்டிக்கு முன் வைக்கவேண்டும். அது உங்களுக்கு மகா பரிசுத்தமுள்ளதாய் இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","இந்தக் கலவை முறையைக் கொண்டு உங்களுக்காக வேறெந்த நறுமணத்தூளையும் தயாரிக்கக்கூடாது. இதை யெகோவாவுக்குப் பரிசுத்தமானதாக எண்ணிக்கொள்ளுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","அதன் வாசனையை அனுபவிக்கும்படி இதுபோன்ற எதையாவது செய்யும் எவனும், தன் மக்களிடத்திலிருந்து அகற்றப்படவேண்டும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","பின்னும் யெகோவா மோசேயிடம் சொன்னதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“பார், நான் யூதா கோத்திரத்தைச் சேர்ந்த ஊர் என்பவனுடைய பேரனும் ஊரியின் மகனுமான பெசலெயேலைத் தெரிந்திருக்கிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","நான் அவனை இறைவனுடைய ஆவியானவரால் நிரப்பியிருக்கிறேன். அத்துடன் எல்லா வகையான வேலைகளையும் பற்றிய ஞானத்தையும், புரிந்துகொள்ளுதலையும், அறிவையும் கொடுத்திருக்கிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","நான் அவனுக்குத் தங்கத்தினாலும், வெள்ளியினாலும், வெண்கலத்தினாலும், சித்திர வேலைப்பாடுகளைச் செய்வதற்கும், ");
INSERT INTO tamtcv_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","இரத்தினக் கற்களை வெட்டிப் பதிப்பதற்கும், மரத்தைச் செதுக்கி வேலை செய்வதற்கும், இன்னும் பல வகையான வேலைப்பாடுகளில் ஈடுபடுவதற்கும் திறமைகளைக் கொடுத்திருக்கிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","மேலும் தாண் கோத்திரத்து அகிசாமாகின் மகன் அகோலியாபை அவனுக்கு உதவியாக நியமித்திருக்கிறேன்.” அத்துடன் நான் உனக்குக் கட்டளையிட்டிருக்கும் யாவற்றையும் செய்யும்படி எல்லா கலைஞர்களுக்கும் வேண்டிய திறமையையும் அவர்களுக்குக் கொடுத்திருக்கிறேன்: ");
INSERT INTO tamtcv_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","“சபைக் கூடாரத்தையும், சாட்சிப்பெட்டியையும், அதன் மேலுள்ள கிருபாசனத்தையும், சபைக் கூடாரத்தின் சகல பணிமுட்டுகளையும், ");
INSERT INTO tamtcv_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","மேஜையையும், அதன் பொருட்களையும், சுத்தத் தங்கக்குத்துவிளக்கையும், அதன் எல்லா உபகரணங்களையும், தூபபீடத்தையும், ");
INSERT INTO tamtcv_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","தகன பலிபீடத்தையும், அதன் எல்லா பாத்திரங்களையும், தொட்டிகளையும், அதன் கால்களையும், ");
INSERT INTO tamtcv_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","அத்துடன் ஆசாரியனான ஆரோனும் அவன் மகன்களும், ஆசாரிய ஊழியத்திற்காக பயன்படுத்தும் பரிசுத்த உடைகளான நெய்யப்பட்ட உடைகளையும், ");
INSERT INTO tamtcv_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","அபிஷேக எண்ணெயையும், பரிசுத்த இடத்திற்குத் தேவையான நறுமணத்தூளையும் செய்ய அவர்களுக்குத் திறமையையும் கொடுத்திருக்கிறேன். “நான் உனக்குக் கட்டளையிட்டபடியே அவர்கள் அவற்றைச் செய்யவேண்டும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","பின்னும் யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“நீ இஸ்ரயேலரிடம் சொல்லவேண்டியது இதுவே: நீங்கள் என் ஓய்வுநாட்களைக் கைக்கொள்ளவேண்டும். உங்களைப் பரிசுத்தப்படுத்துகிற யெகோவா நானே என்பதை நீங்கள் தலைமுறைதோறும் அறியும்படி, இது உங்களுக்கும் எனக்கும் இடையில் ஒரு அடையாளமாய் இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘இந்த ஓய்வுநாள், உங்களுக்குப் பரிசுத்த நாள் என்பதால் அதைக் கைக்கொள்ளுங்கள். அதைத் தூய்மைக்கேடாக்கும் எவனும் கொல்லப்படவேண்டும். அந்த நாளில் வேலைசெய்யும் எவனும் தன் மக்களிலிருந்து அகற்றப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ஆறுநாட்கள் வேலைசெய்யவேண்டும். ஆனால் ஏழாம்நாளோ, யெகோவாவுக்கு பரிசுத்தமான ஓய்வுநாள். இந்த ஓய்வுநாளில் எந்தவித வேலையைச் செய்கிற எவனும் கொல்லப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","இஸ்ரயேலர் தலைமுறைதோறும், ஓய்வுநாளை கைக்கொண்டு நிரந்தர உடன்படிக்கையாக அதைக் கொண்டாடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","அது என்றென்றைக்கும் எனக்கும், இஸ்ரயேலருக்கும் இடையில் ஒரு அடையாளமாய் இருக்கும். ஏனெனில், யெகோவா வானங்களையும், பூமியையும் ஆறு நாட்களில் படைத்து, ஏழாம்நாளில் வேலைசெய்யாமல் ஓய்ந்திருந்தார்.’ ” ");
INSERT INTO tamtcv_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","இவ்வாறு சீனாய் மலையில் யெகோவா மோசேயோடு பேசி முடித்தபின், இறைவனின் விரலால் எழுதப்பட்ட கற்பலகைகளாலான இரண்டு சாட்சிப்பலகைகளை அவனிடம் கொடுத்தார். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","மோசே மலையிலிருந்து இறங்கிவரத் தாமதித்ததை மக்கள் கண்டபோது, அவர்கள் ஆரோனைச் சுற்றி ஒன்றுகூடி அவனிடம், “எங்களை எகிப்திலிருந்து வெளியே கொண்டுவந்த மோசேக்கு என்ன நடந்ததென்று தெரியவில்லை. ஆகையால் நீர் வந்து, எங்களை வழிநடத்தும்படி தெய்வங்களை எங்களுக்காகச் செய்யும்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","அப்பொழுது ஆரோன் அவர்களிடம், “உங்கள் மனைவிகளும், மகன்களும், மகள்களும் அணிந்திருக்கும் தங்கக் காதணிகளைக் கழற்றி என்னிடம் கொண்டுவாருங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","அப்படியே அனைவரும் தங்கள் காதணிகளைக் கழற்றி ஆரோனிடம் கொண்டுவந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","அவர்கள் தன்னிடம் கொடுத்ததை அவன் எடுத்து கன்றுக்குட்டி வடிவில் அதை வார்ப்பித்து, ஒரு கருவியினால் அதை வடிவமைத்து அதை ஒரு விக்கிரகமாகச் செய்தான். அப்பொழுது அவர்கள், “இஸ்ரயேலரே! இவையே உங்கள் தெய்வங்கள். இவைகளே உங்களை எகிப்திலிருந்து வெளியே கொண்டுவந்தன” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","அதைக்கண்ட ஆரோன் அந்தக் கன்றுக்குட்டிக்கு முன்பாக ஒரு பலிபீடத்தைக் கட்டி, “நாளைக்கு யெகோவாவுக்கு ஒரு பண்டிகை கொண்டாடப்படும்” என அறிவித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","மறுநாள் அதிகாலையில் மக்கள் எழுந்து தகன காணிக்கைகளைப் பலியிட்டு, சமாதான காணிக்கைகளைச் செலுத்தினார்கள். அதன்பின் மக்கள் சாப்பிடுவதற்கும் குடிப்பதற்கும் உட்கார்ந்து களியாட்டத்தில் ஈடுபட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","அப்பொழுது யெகோவா மோசேயிடம், “நீ கீழே இறங்கிப்போ. ஏனெனில், எகிப்திலிருந்து நீ வெளியே கொண்டுவந்த உன் மக்கள் சீர்கெட்டுப் போனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","நான் அவர்களுக்குக் கட்டளையிட்டபடி நடக்காமல், விரைவில் வழிதவறி கன்றுக்குட்டி உருவமுடைய ஒரு விக்கிரகத்தைத் தங்களுக்காக செய்திருக்கிறார்கள். அவர்கள் அதை வணங்கி, பலிசெலுத்தி, ‘இஸ்ரயேலரே! இவையே உங்கள் தெய்வங்கள், இவையே உங்களை எகிப்திலிருந்து வெளியே கொண்டுவந்தன’ என்று சொல்லியிருக்கிறார்கள்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","மேலும் யெகோவா மோசேயிடம், “இந்த மக்களை நான் கவனித்துப் பார்த்தேன். அவர்களோ பிடிவாத குணமுள்ளவர்களாய் இருக்கிறார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","அவர்களுக்கு எதிராக என் கோபம் எரியும்படியும், நான் அவர்களை அழிக்கும்படியும் என்னை விட்டுவிடு; அதன்பின் நான் உன்னை ஒரு பெரிய நாடாக்குவேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","ஆனால் மோசேயோ தன் இறைவனாகிய யெகோவாவின் தயவை நாடினான். அவன் அவரிடம், “யெகோவாவே, நீர் மகா வல்லமையினாலும், பலமுள்ள கரத்தினாலும், எகிப்திலிருந்து வெளியே கொண்டுவந்த உம்முடைய மக்களுக்கு எதிராக உமது கோபம் ஏன் எரியவேண்டும்? ");
INSERT INTO tamtcv_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","‘இஸ்ரயேலரை மலைகளில் கொன்று, பூமியின் மேற்பரப்பிலிருந்து அழித்து ஒழிக்கும்படியான தீய நோக்கத்துடனே, அவர் அவர்களை வெளியே கொண்டுவந்தார்’ என எகிப்தியர் ஏன் சொல்லவேண்டும்? ஆகவே உமது கோபத்தின் உக்கிரத்தைத் தணித்து, மனமிரங்கி, மக்கள்மேல் பேராபத்தைக் கொண்டுவராதிரும். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","உமது அடியார்களான ஆபிரகாம், ஈசாக்கு, இஸ்ரயேல் ஆகியோரை நினைவிற்கொள்ளும். ‘உங்கள் சந்ததியை வானத்து நட்சத்திரங்களைப்போல் பெருகப்பண்ணி, நான் உங்கள் சந்ததியினருக்கு வாக்குப்பண்ணிய இந்த நாடு முழுவதையும் அவர்களுக்குக் கொடுப்பேன். அந்த நாடு என்றும் அவர்களுக்கு உரிமைச்சொத்தாய் இருக்கும்’ என்று நீர் உம்மைக் கொண்டு அவர்களுக்கு ஆணையிட்டுச் சொன்னீரே” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","அப்பொழுது யெகோவா மனமிரங்கி, தன் மக்கள்மேல் தான் கொண்டுவருவதாக அச்சுறுத்திய பேராபத்தைக் கொண்டுவரவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","மோசே மலையிலிருந்து தனது கைகளில் இரண்டு சாட்சி கற்பலகைகளுடன் கீழே இறங்கிப் போனான். அந்தக் கற்பலகைகளில் முன்னும் பின்னுமாக இரண்டு பக்கங்களிலும் எழுதப்பட்டிருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","அந்தக் கற்பலகைகள் இறைவனின் கைவேலையாயிருந்தன. அதில் இறைவனால் எழுதப்பட்டிருந்த எழுத்துக்கள் பொறிக்கப்பட்டிருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","ஆரவாரம் செய்யும் மக்களின் சத்தத்தை யோசுவா கேட்டபோது, அவன் மோசேயிடம், “முகாமில் யுத்த சத்தம் கேட்கிறது” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","அதற்கு மோசே சொன்னது: “அது வெற்றியின் சத்தமும் அல்ல; தோல்வியின் சத்தமும் அல்ல; நாம் கேட்பது பாடலின் சத்தம்.” ");
INSERT INTO tamtcv_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","மோசே முகாமுக்குக் கிட்டவந்தபோது, கன்றுக்குட்டியையும் மக்களின் ஆட்டத்தையும் கண்டான். அதைக்கண்ட மோசே கடுங்கோபம் கொண்டு, தன் கையில் இருந்த கற்பலகைகளை மலையடிவாரத்தில் எறிந்து துண்டுகளாக உடைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","அத்துடன் அவர்கள் செய்துவைத்திருந்த கன்றுக்குட்டியை எடுத்து, அதை நெருப்பில்போட்டு எரித்து தூளாக அரைத்து, தண்ணீரின்மேல் தூவி, இஸ்ரயேலரைக் குடிக்கச் செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","அதன்பின் மோசே ஆரோனிடம், “இந்த மக்கள் உனக்கு என்ன செய்தார்கள்? நீ அவர்களை இவ்வளவு பெரிய பாவத்தைச்செய்ய வழிநடத்துவதற்கு அவர்கள் உனக்கு என்ன செய்தார்கள்?” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","அதற்கு ஆரோன், “என் ஆண்டவனே, கோபங்கொள்ள வேண்டாம். இவர்கள் எவ்வளவாய் தீமையின் பக்கம் சார்ந்து நடக்கின்ற மக்கள் என்பதை நீர் அறிவீர்தானே! ");
INSERT INTO tamtcv_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","அவர்கள் என்னிடம், ‘எகிப்திலிருந்து எங்களைக் கொண்டுவந்த மோசேக்கு என்ன நடந்ததென்று எங்களுக்குத் தெரியவில்லை. ஆகையால் எங்களை வழிநடத்த எங்களுக்கு தெய்வங்களைச் செய்துகொடும்’ என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","ஆகவே நான் அவர்களிடம், ‘தங்க நகைகள் இருப்பவர்கள் அதைக் கழற்றுங்கள்’ என்றேன். அப்படியே அவர்கள் அந்த தங்க நகைகளை என்னிடம் கொடுத்தார்கள். நான் அதை நெருப்பில் போட்டேன். அதிலிருந்து இந்த கன்றுக்குட்டி வந்தது” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","மக்கள் கட்டுக்கடங்காமல் திரிவதையும், அவர்களுடைய பகைவர்களுக்கு முன்பாக அவர்கள் கேலிப்பொருளாகும்படி, ஆரோன் அவர்களை கட்டுப்பாடின்றி விட்டுவிட்டதையும் மோசே கண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","அப்பொழுது மோசே முகாமின் வாசலில் நின்று, “யெகோவாவின் பக்கத்தில் இருப்பவர்கள் என்னிடம் வாருங்கள்” என்றான். லேவியர் எல்லோரும் அவனிடம் வந்து சேர்ந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","மோசே அவர்களிடம், “இஸ்ரயேலின் இறைவனாகிய யெகோவா சொல்வது இதுவே: ஒவ்வொருவரும் உங்கள் இடுப்பில் ஒரு வாளைக் கட்டிக்கொள்ளுங்கள். முகாமெங்கும் ஒரு முனையிலிருந்து மறுமுனைவரை அங்குமிங்குமாகச் சென்று ஒவ்வொருவனும் தன்தன் சகோதரனையும், நண்பனையும், அயலானையும் கொல்லுங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","லேவியர்கள் மோசே கட்டளையிட்டபடியே செய்தார்கள். அன்று மக்களில் மூவாயிரம்பேர்வரை செத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","அப்பொழுது மோசே அவர்களிடம், “நீங்கள் ஒவ்வொருவரும் தன்தன் சொந்த மகன்களுக்கும், சகோதரர்களுக்கும் விரோதமாய் இருந்தபடியால், இன்று நீங்கள் யெகோவாவினுடைய பணிக்கென்று வேறுபிரிக்கப்பட்டிருக்கிறீர்கள். யெகோவா இன்றைக்கு உங்களை ஆசீர்வதித்திருக்கிறார்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","மறுநாள் மோசே மக்களிடம், “நீங்கள் பெரிய பாவம் செய்திருக்கிறீர்கள். இப்பொழுது நான் யெகோவாவிடம் ஏறிப்போவேன். ஒருவேளை உங்களுடைய பாவத்திற்காக நான் பாவநிவிர்த்தி செய்யலாம்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","அவ்வாறே மோசே திரும்பவும் யெகோவாவிடம் போய், “இந்த மக்கள் எவ்வளவு பெரிய பாவத்தைச் செய்திருக்கிறார்கள். அவர்கள் தங்களுக்காக தங்கத்தினால் தெய்வங்களைச் செய்திருக்கிறார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ஆனாலும் அவர்களுடைய பாவத்தை இப்பொழுது மன்னியும்; இல்லாவிட்டால் நீர் எழுதிய புத்தகத்திலிருந்து என் பெயரை அழித்துவிடும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","அப்பொழுது யெகோவா மோசேயிடம், “எனக்கு விரோதமாய்ப் பாவம் செய்தவன் எவனோ, அவனுடைய பெயரையே என் புத்தகத்திலிருந்து அழிப்பேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","இப்பொழுது நீ போய் நான் உனக்கு சொன்ன இடத்துக்கு மக்களை அழைத்துக்கொண்டு போ. இதோ! என் தூதன் உனக்குமுன் செல்வான். ஆனாலும், நான் தண்டிக்கும் காலம் வரும்போது, அவர்கள் பாவத்திற்காக நான் அவர்களைத் தண்டிப்பேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","ஆரோன் செய்து கொடுத்த கன்றுக்குட்டியை வணங்கியதற்காக யெகோவா மக்களைப் பெரும் கொள்ளைநோயினால் வாதித்தார். ");
INSERT INTO tamtcv_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","பின்பு யெகோவா மோசேயிடம், “நீயும், எகிப்திலிருந்து நீ அழைத்துவந்த மக்களும் இவ்விடத்தைவிட்டுப் புறப்பட்டு, ‘உங்கள் சந்ததிக்குக் கொடுப்பேன்’ என்று நான் ஆபிரகாம், ஈசாக்கு, யாக்கோபு ஆகியோருக்கு ஆணையிட்டு வாக்குப்பண்ணிய நாட்டிற்குப் போங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","நான் உங்களுக்கு முன்னே ஒரு இறைத்தூதனை அனுப்பி கானானியர், எமோரியர், ஏத்தியர், பெரிசியர், ஏவியர், எபூசியர் ஆகியோரை வெளியே துரத்திவிடுவேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","பாலும் தேனும் ஓடும் நாட்டிற்குப் போங்கள். ஆனால் நானோ உங்களோடு வரமாட்டேன். ஏனெனில், நீங்கள் பிடிவாத குணமுள்ளவர்கள். அதனால் நான் உங்களை வழியிலேயே அழித்துவிட நேரிடலாம்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","மிகவும் துயரமான இவ்வார்த்தைகளை மக்கள் கேட்டவுடன் அவர்கள் துக்கமடைய தொடங்கினார்கள். அவர்கள் ஒருவரும் தங்கள் நகைகளை அணிந்து கொள்ளவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","ஏனெனில் யெகோவா மோசேயிடம், “நீ இஸ்ரயேல் மக்களிடம், ‘நீங்கள் பிடிவாத குணமுள்ள மக்கள். ஆகையால், உங்களுடன் ஒரு நொடிப்பொழுது நான் வந்தாலும் உங்களை அழித்துவிட நேரிடும். இப்பொழுது நீங்கள் நகைகளைக் கழற்றுங்கள். நான் உங்களுக்கு என்ன செய்யவேண்டும் என்று தீர்மானிப்பேன்’ எனச் சொல்” என்று சொல்லியிருந்தார். ");
INSERT INTO tamtcv_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","ஆகவே இஸ்ரயேலர் ஓரேப் மலையில் தங்கள் நகைகளைக் கழற்றிப் போட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","மோசே ஒரு கூடாரத்தை எடுத்துக்கொண்டுபோய் முகாமுக்கு வெளியே சற்றுத் தொலைவில் அதை அமைப்பது வழக்கம். அதை அவன், “சபைக் கூடாரம்” என அழைத்தான். யெகோவாவிடம் விசாரித்து அறியவரும் யாரும், முகாமுக்கு வெளியே அந்தக் கூடாரத்திற்குப் போவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","மோசே வெளியே அந்தக் கூடாரத்திற்குப் போகும்போதெல்லாம், எல்லா மக்களும் தங்களுடைய கூடாரவாசலில் எழுந்து, மோசே கூடாரத்திற்குள் போகும்வரை பார்த்துக்கொண்டு நிற்பார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","மோசே கூடாரத்திற்குள் போனதும், மேகத்தூண் கீழே இறங்கி, வாசலில் வந்து நிற்கும். அப்பொழுது யெகோவா மோசேயுடன் பேசுவார். ");
INSERT INTO tamtcv_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","மேகத்தூண் கூடாரவாசலில் நிற்பதை மக்கள் காணும்போதெல்லாம், எல்லோரும் தங்களுடைய கூடாரவாசலில் நின்று வழிபடுவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","ஒரு மனிதன் தன் நண்பனோடு பேசுவதைப்போல் யெகோவா மோசேயுடன் முகமுகமாய் பேசுவார். அதன்பின் மோசே திரும்பி முகாமுக்குள் போவான். ஆனால் மோசேயின் பணியாளனான நூனின் மகன் யோசுவா என்ற வாலிபன், கூடாரத்தைவிட்டுப் போவதேயில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","மோசே யெகோவாவிடம் சொன்னதாவது: “நீ இந்த மக்களை வழிநடத்து என்று நீர் என்னிடம் சொல்லிக் கொண்டிருக்கிறீர். ஆனாலும் என்னோடு யாரை அனுப்புவீர் என்று எனக்கு அறிவிக்கவில்லை. நான் உன்னைப் பெயர்சொல்லி அழைத்து அறிந்திருக்கிறேன்; நீ என்னிடம் தயவு பெற்றிருக்கிறாய் என்றும் நீர் சொல்லியிருந்தீர். ");
INSERT INTO tamtcv_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","அவ்வாறு உம்முடைய கண்களில் எனக்குத் தயவு கிடைத்ததினால், நான் உம்மை இன்னும் அதிகம் அறிவதற்கும், உம்முடைய கண்களில் தொடர்ந்து தயவைப் பெற்றுக்கொள்வதற்கும், உம்முடைய வழிகளை எனக்குப் போதியும். இந்த நாடு உம்முடைய மக்கள் என்பதையும் நினைவிற்கொள்ளும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","அதற்கு யெகோவா, “எனது சமுகம் உன்னோடு போகும்; நான் உனக்கு ஆறுதலைத் தருவேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","அப்பொழுது மோசே யெகோவாவிடம், “உமது சமுகம் எங்களுடன் வராவிட்டால் எங்களை இவ்விடத்திலிருந்து அனுப்பவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","நீர் எங்களுடன் வராவிட்டால், என்மேலும் உம்முடைய மக்கள்மேலும் நீர் பிரியமாயிருக்கிறீர் என்பதை யாராவது எப்படி அறிவார்கள்? இதையல்லாமல் என்னையும், உமது மக்களையும் பூமியின் மேற்பரப்பிலிருக்கும் மக்களிடமிருந்து வித்தியாசப்படுத்திக் காட்டுவது எது?” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","அதற்கு யெகோவா மோசேயிடம், “நீ கேட்டுக்கொண்ட அதையே நான் செய்வேன். ஏனெனில் நான் உன்னிடம் பிரியமாய் இருக்கிறேன். நான் உன்னைப் பெயர்சொல்லி அழைத்து அறிந்திருக்கிறேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","அப்பொழுது மோசே, “உம்முடைய மகிமையை எனக்கு இப்பொழுது காண்பியும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","அதற்கு யெகோவா, “என் நன்மை எல்லாவற்றையும் நான் உனக்கு முன்பாகக் கடந்துபோகச் செய்வேன். யெகோவா என்ற என் பெயரை உனக்கு முன்பாக பிரசித்தப்படுத்துவேன். நான் யாருக்கு இரக்கம் காட்ட விருப்பமாயிருக்கிறேனோ, அவர்களுக்கு இரக்கம் காட்டுவேன். யாரிடம் மனதுருக்கமாய் இருக்க விரும்புகிறேனோ அவர்களிடம் மனதுருகுவேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","ஆனால், என்னுடைய முகத்தை உன்னால் காணமுடியாது; ஏனெனில் என் முகத்தைக் கண்டு ஒருவனும் உயிரோடிருக்கமுடியாது” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","பின்பு யெகோவா, “எனக்கு அருகே இருக்கும் கற்பாறையின்மேல் நீ நில். ");
INSERT INTO tamtcv_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","என் மகிமை கடந்து செல்லும்போது, நான் உன்னைக் கற்பாறை வெடிப்பில் வைப்பேன். நான் கடந்துசெல்லும்வரை என் கையால் உன்னை மூடுவேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","அதன்பின் நான் என் கையை விலக்குவேன். நீ என் முதுகைக் காண்பாய்; ஆனால் என் முகமோ காணப்படக்கூடாது” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","மேலும் யெகோவா மோசேயிடம், “நீ முந்தினவைகளைப்போன்ற இரண்டு கற்பலகைகளைச் செதுக்கி எடுத்துக்கொள். நீ உடைத்துப்போட்ட முந்தின கற்பலகைகளில் இருந்த வார்த்தைகளை நான் இந்தக் கற்பலகைகளில் எழுதுவேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","நாளை காலையில் நீ ஆயத்தமாகி, சீனாய் மலைக்குமேல் ஏறி வா. மலை உச்சியில் எனது முன்னிலையில் வந்து நில். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","உன்னுடன் வேறெவரும் வரக்கூடாது. மலையின் எந்தப்பகுதியிலும் எங்காவது காணப்படவும் கூடாது. ஆடுமாடுகளும் அந்த மலைக்கு முன்னால் மேயக்கூடாது” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","மோசே யெகோவா தனக்குக் கட்டளையிட்டபடியே, முந்தின கற்பலகைகளைப்போன்ற இரண்டு கற்பலகைகளையும் செதுக்கி, அதிகாலையில் எழுந்து, அந்த இரண்டு கற்பலகைகளையும் தன் கைகளில் எடுத்துக்கொண்டு, சீனாய் மலைக்கு ஏறிப்போனான். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","அப்பொழுது யெகோவா மேகத்தில் இறங்கி அங்கே மோசேயுடன் நின்று, யெகோவா என்ற தமது பெயரைப் பிரசித்தப்படுத்தினார். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","அவர் மோசேயின் முன்னால் கடந்து போகையில், “யெகோவா! யெகோவா! மன இரக்கமும், கிருபையும் உள்ள இறைவன். கோபப்படுவதற்குத் தாமதிக்கிறவர். அன்பிலும், உண்மையிலும் நிறைந்தவர். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ஆயிரம் தலைமுறைகளுக்கு அசையாத அன்பைக் காட்டுகிறவர். கொடுமையையும், கலகத்தையும், பாவத்தையும் மன்னிக்கிறவர். அப்படியிருந்தும் அவர் குற்றவாளிகளைத் தண்டியாமல் தப்பவிடுகிறவர் அல்ல. பெற்றோரின் பாவத்திற்காக பிள்ளைகளையும், பிள்ளைகளின் பிள்ளைகளையும் அவர்களின் மூன்றாம், நான்காம் தலைமுறைவரைக்கும் தண்டிக்கிறவர்” என்று பிரசித்தப்படுத்தினார். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","உடனே மோசே, தரையில் விழுந்து வழிபட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","அவன், “யெகோவாவே, நான் உம்முடைய கண்களில் தயவு பெற்றிருந்தேன் என்றால், யெகோவாவாகிய நீர் எங்களுடன் வாரும். மக்கள் பிடிவாத குணமுள்ளவர்களாய் இருந்தாலும் எங்கள் கொடுமைகளையும், பாவத்தையும் மன்னித்து, எங்களை உமது உரிமைச்சொத்தாக ஏற்றுக்கொள்ளும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","அதற்கு யெகோவா, “நான் உன்னுடன் ஒரு உடன்படிக்கை செய்கிறேன். முழு உலகத்திலும், எந்த நாட்டினரின் மத்தியிலும் முன் ஒருபோதும் செய்யப்படாத அதிசயங்களை உன் மக்களுக்கு முன்பாகச் செய்வேன். யெகோவாவாகிய நான் உனக்காகச் செய்யப்போகும் செயல் எவ்வளவு பிரமிப்புக்குரியதாய் இருக்கும் என்பதை உன்னோடுகூட வாழும் மக்கள் காண்பார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","இன்று நான் உனக்குக் கட்டளையிடுகிறதற்கு நீ கீழ்ப்படி. நான் எமோரியர், கானானியர், ஏத்தியர், பெரிசியர், ஏவியர், எபூசியர் ஆகியோரை உனக்கு முன்பாக வெளியே துரத்திவிடுவேன். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","நீ போய்ச்சேரும் நாட்டிலுள்ள மக்களோடு எந்த விதமான உடன்படிக்கையையும் செய்யாதிருக்கக் கவனமாயிரு. மீறினால் அவர்கள் உங்கள் மத்தியில் கண்ணியாயிருப்பார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","நீயோ அவர்களுடைய பலிபீடங்களை இடித்து, விக்கிரகங்களை உடைத்து, அவர்களுடைய அசேரா விக்கிரகக் கம்பங்களை வெட்டி அழித்துவிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","நீ வேறெந்த தெய்வத்தையும் வணங்காதே. வைராக்கியமுடையவர் என்ற பெயருடைய யெகோவா, தமக்குரிய வழிபாட்டைக் குறித்து வைராக்கியமுடைய இறைவன். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“நீ அந்நாட்டிலுள்ள மக்களோடு உடன்படிக்கை செய்யாமலிருக்க கவனமாயிரு. ஏனெனில், அவர்கள் தங்கள் தெய்வங்களுக்குப் பலிசெலுத்திப் பாவம் செய்யும்போது, பலிகளைச் சாப்பிடும்படி உங்களை அழைத்தால், ஒருவேளை நீங்கள் அவர்களுடன் சேர்ந்து அதைச் சாப்பிடுவீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","நீங்கள் உங்கள் மகன்களுக்கு அவர்களுடைய மகள்களை மனைவிகளாகத் தெரிந்துகொள்ளும்போது, அவர்களுடைய மகள்கள் தங்கள் தெய்வங்களுக்குப் பலிகளைச் செலுத்தி பாவம் செய்து, அதைச் செய்யும்படி உங்கள் மகன்களையும் தூண்டுவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“வார்க்கப்பட்ட விக்கிரகங்களைச் செய்யவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“புளிப்பில்லாத அப்பப்பண்டிகையைக் கொண்டாடுங்கள். நான் உனக்குக் கட்டளையிட்டபடியே ஏழுநாட்களுக்குப் புளிப்பில்லாத அப்பங்களைச் சாப்பிடவேண்டும். குறித்த காலமான ஆபீப் மாதத்திலே இதைச் செய்யுங்கள். ஏனெனில், அந்த மாதத்திலேயே நீங்கள் எகிப்திலிருந்து புறப்பட்டு வந்தீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“கர்ப்பத்திலிருந்து வரும் முதற்பேறானவைகள் எல்லாம் எனக்கே சொந்தம். உனக்குரிய கால்நடையில் உள்ள ஆட்டு மந்தையிலிருந்தோ மாட்டு மந்தையிலிருந்தோ பிறக்கும் தலையீற்றான எல்லா கடாக்களும் காளைகளும் எனக்கே உரியவை. ");
INSERT INTO tamtcv_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","ஒரு செம்மறியாட்டுக் குட்டியைக் கொடுத்து கழுதையின் தலையீற்றை மீட்டுக்கொள்ள வேண்டும். அப்படி அதை மீட்காவிட்டால் அதன் கழுத்தை முறித்து விடவேண்டும். உன் மகன்களில் முதற்பேறான எல்லோரையும் மீட்டுக்கொள்ள வேண்டும். “ஒருவரும் வெறுங்கையோடு என்முன் வரக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“ஆறுநாட்கள் வேலைசெய், ஆனால் ஏழாம் நாளிலோ ஓய்ந்திருக்க வேண்டும். உழவு காலத்திலும், அறுப்புக் காலத்திலும் அப்படியே ஓய்ந்திருக்க வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“கோதுமை அறுவடையின் முதற்பலன்களை கொண்டு, வாரங்களின் பண்டிகையையும், வருட முடிவில் தானிய சேர்ப்பின் பண்டிகையையும் கொண்டாடுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","ஒரு வருடத்தில் மூன்றுமுறை உங்கள் எல்லா ஆண்களும் இஸ்ரயேலின் இறைவனான ஆண்டவராகிய யெகோவாவுக்குமுன் வரவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","நான் நாடுகளை உங்களுக்கு முன்பாக வெளியே துரத்தி, உங்கள் நிலப்பரப்பை விரிவுபடுத்துவேன். ஒவ்வொரு வருடமும் மூன்றுமுறை நீங்கள் உங்கள் இறைவனாகிய யெகோவாவுக்கு முன்பாக நிற்கப் போகும்போது, ஒருவனும் உங்கள் நாட்டை அபகரிக்க ஆசைகொள்ளமாட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“புளிப்புள்ள எதனுடனும் ஒரு பலியின் இரத்தத்தை எனக்குச் செலுத்தவேண்டாம். பஸ்கா பண்டிகையின் பலியிலுள்ள எதையும் மறுநாள் காலைவரை வைக்கவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“உங்கள் நிலத்திலுள்ள முதற்பலன்களில் சிறந்தவற்றையே உங்கள் இறைவனாகிய யெகோவாவின் ஆலயத்துக்குக் கொண்டுவர வேண்டும். “வெள்ளாட்டுக்குட்டியை அதன் தாயின் பாலிலே சமைக்கவேண்டாம்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","அதன்பின் யெகோவா மோசேயிடம், “இந்த வார்த்தைகளை எழுது. ஏனெனில் இந்த வார்த்தைகளின்படியே உன்னோடும் இஸ்ரயேலரோடும் நான் உடன்படிக்கை செய்திருக்கிறேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","அங்கே மோசே இரவும் பகலும் அப்பம் சாப்பிடாமலும், தண்ணீர் குடியாமலும் நாற்பது நாட்கள் யெகோவாவோடு இருந்தான். அவர் பத்துக் கட்டளைகளான உடன்படிக்கையின் வார்த்தைகளைக் கற்பலகைகளில் எழுதினார். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","மோசே, சாட்சியின் பலகைகளைத் தனது கையில் வைத்துக்கொண்டு, சீனாய் மலையிலிருந்து கீழே இறங்கி வந்தான். அவன் யெகோவாவோடு பேசியதனால் அவனுடைய முகம் பிரகாசமாயிருந்தது. ஆனால் அவனோ அதை அறியாதிருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","ஆரோனும், இஸ்ரயேலர் எல்லோரும் மோசேயைப் பார்த்தபோது, அவனுடைய முகம் பிரகாசமாயிருந்தது. அதனால் அவர்கள் அவனுக்கு அருகில் வருவதற்குப் பயந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","ஆனால் மோசேயோ அவர்களை அழைத்தான். அப்பொழுது ஆரோனும், சமுதாயத்தின் எல்லா தலைவர்களும் அவனிடம் திரும்பி வந்தார்கள். அவன் அவர்களுடன் பேசினான். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","அதன்பின் இஸ்ரயேலர் எல்லோரும் அவனை நெருங்கி வந்தார்கள். யெகோவா சீனாய் மலையில் கொடுத்த கட்டளைகள் எல்லாவற்றையும் அவன் அவர்களுக்குக் கொடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","மோசே அவர்களுடன் பேசி முடிந்ததும், அவன் தன் முகத்தை முகத்திரையால் மூடிக்கொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","ஆனாலும் மோசே, யெகோவாவுடன் பேசும்படி அவர் முன்னிலையில் போகும்போதெல்லாம், அவன் அங்கிருந்து திரும்பி வரும்வரை முகத்திரையை நீக்கிவிடுவான். அவன் தனக்குக் கட்டளையிடப்பட்டதை வெளியே வந்து இஸ்ரயேலருக்குச் சொல்லும்போது, ");
INSERT INTO tamtcv_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","இஸ்ரயேலர் அவன் முகம் பிரகாசிப்பதைக் கண்டார்கள். எனவே மோசே, தான் யெகோவாவுடன் பேசுவதற்கு உள்ளே போகும்வரை, அந்த முகத்திரையைத் திரும்பவும் தன் முகத்தின்மேல் போட்டுக்கொள்வான். ");
INSERT INTO tamtcv_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","பின்பு மோசே முழு இஸ்ரயேல் சமுதாயத்தையும் கூடிவரச்செய்து அவர்களிடம், “நீங்கள் செய்யவேண்டுமென்று யெகோவா கட்டளையிட்டவைகள் இவையே: ");
INSERT INTO tamtcv_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","நீங்கள் ஆறு நாட்களுக்கு வேலைசெய்யவேண்டும். ஆனால் ஏழாம்நாளோ உங்களுக்குப் பரிசுத்த நாள். அது யெகோவாவுக்கான ஓய்வுநாள். அந்த நாளிலே வேலைசெய்பவன் எவனும் கொலைசெய்யப்படுவான். ");
INSERT INTO tamtcv_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","ஓய்வுநாளில் நீங்கள் வசிக்கும் எந்தக் குடியிருப்புகளிலும் நெருப்பு மூட்டக்கூடாது” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","பின்னும் மோசே முழு இஸ்ரயேல் சமுதாயத்திடமும், யெகோவா கட்டளையிட்டிருப்பது இதுவே: ");
INSERT INTO tamtcv_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","உங்களிடம் இருப்பதிலிருந்து யெகோவாவுக்காக ஒரு காணிக்கையை எடுங்கள். யெகோவாவுக்குக் காணிக்கை கொண்டுவர விரும்பும் ஒவ்வொருவனும் கொண்டுவர வேண்டியதாவன: “தங்கம், வெள்ளி, வெண்கலம், ");
INSERT INTO tamtcv_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","நீலம், ஊதா, கருஞ்சிவப்புநூல்; மென்பட்டுத் துணி, வெள்ளாட்டு உரோமம், ");
INSERT INTO tamtcv_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","சிவப்புச் சாயம் தோய்ந்த செம்மறியாட்டுக் கடாவின் தோல், கடல்பசுவின் தோல், சித்தீம் மரம், ");
INSERT INTO tamtcv_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","வெளிச்சத்திற்கான ஒலிவ எண்ணெய், அபிஷேக எண்ணெய்க்கும், நறுமண தூபத்திற்குமான வாசனைப் பொருட்கள்; ");
INSERT INTO tamtcv_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ஏபோத்திலும், மார்புப் பதக்கத்திலும் பதிப்பதற்கான கோமேதகக் கற்கள் மற்றும் இரத்தினக் கற்கள் ஆகியவையே.” ");
INSERT INTO tamtcv_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","உங்களில் தொழில் திறமையுள்ளவர்கள் எல்லோரும் வந்து, யெகோவா கட்டளையிட்ட வேலைகளையெல்லாம் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","“அவையாவன: இறைசமுகக் கூடாரமும் அதற்குரிய மூடுதிரையும், கொக்கிகளும், மரச்சட்டங்களும், குறுக்குச் சட்டங்களும், கம்பங்களுடன் அதன் அடித்தளங்களும், ");
INSERT INTO tamtcv_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","அத்துடன் சாட்சிப்பெட்டி, அதற்குரிய கம்புகள், கிருபாசனம், சாட்சிப்பெட்டியை மறைக்கும் திரை, ");
INSERT INTO tamtcv_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","மேஜை, அதற்குரிய கம்புகள், மேஜைக்குரிய பொருட்கள், இறைசமுக அப்பம், ");
INSERT INTO tamtcv_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","வெளிச்சத்திற்கான குத்துவிளக்கு, அதற்குரிய உபகரணங்கள், விளக்குகள், வெளிச்சத்திற்கான எண்ணெய், ");
INSERT INTO tamtcv_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","தூபபீடம், அதற்குரிய கம்புகள், அபிஷேக எண்ணெய், நறுமணத் தூபம், இறைசமுகக் கூடார நுழைவு வாசலுக்கான திரைச்சீலை, ");
INSERT INTO tamtcv_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","தகன பலிபீடம், அதற்குரிய வெண்கலச் சல்லடை, அதற்குரிய கம்புகள், அதற்குரிய எல்லா பாத்திரங்கள், வெண்கலத் தொட்டி, அதற்குரிய கால், ");
INSERT INTO tamtcv_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","முற்றத்திற்கான திரைகள், அதற்குரிய கம்புகள், அடித்தளங்கள், முற்ற வாசலுக்கான திரைகள், ");
INSERT INTO tamtcv_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","இறைசமுகக் கூடாரத்திற்கும், முற்றத்திற்கும் வேண்டிய கூடார முளைகள், அதற்குரிய கயிறுகள், ");
INSERT INTO tamtcv_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","பரிசுத்த இடத்தின் ஆசாரியப் பணிசெய்ய உடுத்தப்படும் நெய்யப்பட்ட உடைகள், ஆசாரியனாகிய ஆரோனுக்கு வேண்டிய பரிசுத்த உடைகள், அவனுடைய மகன்கள் ஆசாரியராகப் பணிசெய்யும்போது அவர்களுக்கு வேண்டிய உடைகள் ஆகியனவாகும்.” ");
INSERT INTO tamtcv_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","அதன்பின் முழு இஸ்ரயேல் சமுதாயமும் மோசேயின் முன்னின்று விலகிப்போனது. ");
INSERT INTO tamtcv_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","அவர்களில் விருப்பமுடையவர்களும், இருதயத்தில் ஏவப்பட்டவர்களும், சபைக்கூடார வேலைக்கும் அதன் எல்லா பணிகளுக்கும், பரிசுத்த உடைகளுக்கும் வேண்டிய காணிக்கைகளை யெகோவாவுக்குக் கொண்டுவந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","விருப்பமுள்ள எல்லா ஆண்களும் பெண்களும் ஒரேவிதமாகவே உடையலங்கார ஊசிகள், காதணிகள், மோதிரங்கள், ஆபரணங்கள் முதலிய எல்லாவித தங்க நகைகளையும் கொண்டுவந்தார்கள். அவர்கள் எல்லோரும் தமது தங்கத்தை யெகோவாவுக்கு அசைவாட்டும் காணிக்கையாகச் செலுத்தினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","அத்துடன் ஒவ்வொருவரும் தங்களிடமிருந்த நீலநூல், ஊதாநூல், கருஞ்சிவப்புநூல், மென்பட்டுத் துணி, வெள்ளாட்டு உரோமம், சிவப்புச் சாயம் தோய்க்கப்பட்ட ஆட்டுக்கடா தோல், கடல்பசுத் தோல் ஆகியவற்றையும் கொண்டுவந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","வெள்ளியையும், வெண்கலத்தையும் காணிக்கையாகக் கொடுக்க விரும்பியவர்கள் அதை யெகோவாவுக்குக் காணிக்கையாகக் கொண்டுவந்தார்கள். மற்றெந்த வேலைகளுக்கும் பயன்படக்கூடிய சித்தீம் மரத்தை வைத்திருந்தவர்களும் அதைக் கொண்டுவந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","திறமையுள்ள பெண்கள் தங்கள் கைகளினால் நீலம், ஊதா, கருஞ்சிவப்பு நூல்களையும், மென்பட்டுத் துணிகளையும் திரித்துக் கொண்டுவந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","திறமையுள்ள ஊக்கமான பெண்கள் யாவரும் வெள்ளாட்டு உரோமத்தையும் திரித்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","மக்களின் தலைவர்கள் ஏபோத்திற்கும், மார்பு அணிக்கும் பதிப்பதற்கான கோமேதகக் கற்களையும், இரத்தினக் கற்களையும் கொண்டுவந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","அவர்கள் வெளிச்சத்திற்கும், அபிஷேக எண்ணெய்க்கும், நறுமணத்தூளுக்கும் தேவையான ஒலிவ எண்ணெயையும், வாசனைப் பொருட்களையும் கொண்டுவந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","யெகோவா மோசே மூலமாக அவர்கள் செய்யும்படி கட்டளையிட்ட எல்லா விதமான வேலைகளுக்காகவும் மனதில் விருப்பமுள்ள எல்லா இஸ்ரயேல் ஆண்களும், பெண்களும் சுயவிருப்பக் காணிக்கைகளை யெகோவாவுக்குக் கொண்டுவந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","பின்பு மோசே இஸ்ரயேல் மக்களிடம் சொன்னதாவது: “பாருங்கள், யெகோவா யூதா கோத்திரத்தைச் சேர்ந்த ஊர் என்பவனுடைய பேரனும் ஊரியின் மகனுமான பெசலெயேலைத் தெரிந்தெடுத்திருக்கிறார். ");
INSERT INTO tamtcv_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","அவர் அவனை இறைவனுடைய ஆவியானவரால் நிரப்பி, எல்லா வகையான வேலைகளையும் செய்யக்கூடிய ஞானத்தையும், புரிந்துகொள்ளுதலையும், அறிவையும் கொடுத்திருக்கிறார். ");
INSERT INTO tamtcv_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","தங்கத்தினாலும், வெள்ளியினாலும், வெண்கலத்தினாலும், சித்திர வேலைப்பாடுகளைச் செய்வதற்கும், ");
INSERT INTO tamtcv_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","இரத்தினக் கற்களை வெட்டவும், அவற்றைப் பதிக்கவும், மரத்தைச் செதுக்கி வெவ்வேறு வினோதமான வேலைகளைச் செய்யவும் ஆற்றலைக் கொடுத்திருக்கிறார். ");
INSERT INTO tamtcv_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","அவனுக்கும் தாண் கோத்திரத்து அகிசாமாகின் மகன் அகோலியாபுக்கும் மற்றவர்களுக்குப் போதிக்கும் ஆற்றலைக் கொடுத்தார். ");
INSERT INTO tamtcv_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","அவர்களுடைய கைவினைஞர்களும், சித்திரக்காரர்களும் நீலம், ஊதா, கருஞ்சிவப்பு, மென்பட்டு ஆகியவற்றைக்கொண்டு அழகான தையல் வேலைகளைச் செய்யக்கூடியவர்களாகவும், நெசவாளர்களாகவும் ஆகும்படி அவர்களை ஆற்றலினால் நிரப்பினார். அவர்கள் தலைச்சிறந்த கைவினைஞரும், சித்திரக்காரருமாய் இருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","அப்படியே பெசலெயேலுடனும், அகோலியாபுடனும் பரிசுத்த இடத்தை அமைக்கும் எல்லா வேலைகளையும் எப்படிச் செய்வது என அறியும் ஆற்றலையும், திறமையையும், யெகோவா கொடுத்திருந்த ஒவ்வொரு திறமைசாலியும், யெகோவாவின் கட்டளைப்படியே அவ்வேலைகளைச் செய்யவேண்டும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","பின்பு மோசே பெசலெயேலையும், அகோலியாபையும், யெகோவாவினால் ஆற்றல் வழங்கப்பட்டு, வந்து வேலைசெய்வதற்கு மனவிருப்பமுள்ள திறமைசாலிகள் எல்லோரையும் வரவழைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","பரிசுத்த இடத்தை அமைக்கும் வேலைகளைச் செய்வதற்கு, இஸ்ரயேல் மக்கள் கொண்டுவந்திருந்த காணிக்கைகளை எல்லாம், மோசேயிடமிருந்து அவர்கள் பெற்றுக்கொண்டார்கள். மக்கள் சுயவிருப்பக் காணிக்கைகளைத் தொடர்ந்து காலைதோறும் கொண்டுவந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","அதனால் பரிசுத்த இடத்தின் வேலையைச் செய்துகொண்டிருந்த திறமையான கலைஞர்கள் தங்கள் வேலையைவிட்டு, ");
INSERT INTO tamtcv_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","மோசேயிடம் வந்து, “யெகோவா செய்யும்படி கட்டளையிட்ட வேலைக்கு, தேவைக்கு அதிகமான பொருட்களை மக்கள் கொண்டுவருகிறார்கள்” என்று சொன்னார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","அப்பொழுது மோசே, “இனிமேல் எந்த ஒரு ஆணோ, பெண்ணோ பரிசுத்த இடத்தின் வேலைக்கான காணிக்கையாக எதையும் கொண்டுவர வேண்டாம்” என உத்தரவிட்டான். அது முகாமெங்கும் உள்ள மக்களுக்கு அறிவிக்கப்பட்டது. இவ்விதமாக மக்கள் கூடுதலாகப் பொருட்களைக் கொண்டுவருவது நிறுத்தப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","ஏனெனில், எல்லா வேலைகளையும் செய்து முடிப்பதற்குத் தேவையானவற்றைவிட அதிகமான பொருட்கள் ஏற்கெனவே அவர்களிடம் இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","வேலையாட்களில் திறமையானவர்கள் எல்லோரும், தரமாய் திரித்த மென்பட்டு, நீலநூல், ஊதாநூல், கருஞ்சிவப்புநூல் ஆகியவற்றைக்கொண்டு பத்து மூடுதிரைகளைச் செய்தார்கள். அதில் கேருபீன்களை சித்திரத் தையல்காரனுடைய வேலையால் அலங்கரித்து, அவற்றால் இறைசமுகக் கூடாரத்தை அமைத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","எல்லா திரைகளும் இருபத்தெட்டு முழம் நீளமும், நான்கு முழம் அகலமும் உள்ள ஒரே அளவுள்ளதாய் இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","பின்பு ஐந்து திரைகளை ஒன்றாக இணைத்து, மற்ற ஐந்து திரைகளையும் அதேவிதமாகவே இணைத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","இணைக்கப்பட்ட ஒரு தொகுப்பு திரையின் கடைசி திரையின் விளிம்பு நெடுகிலும், நீலநிறத் துணியினால் வளையங்களைச் செய்தார்கள். அவ்விதமே இணைக்கப்பட்ட மற்றத்திரையின் தொகுப்பின் விளிம்பு நெடுகிலும் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","வளையங்கள் ஒன்றுக்கொன்று எதிராய் இருக்கும்படி, ஒரு தொகுப்பு திரையின் கடைசி திரையின் ஒரு விளிம்பில் ஐம்பது வளையங்களையும், மறு தொகுப்பு திரையின், ஒரு விளிம்பில் ஐம்பது வளையங்களையும் அமைத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","பின் ஐம்பது தங்கக்கொக்கிகளைச் செய்து, இரண்டு தொகுப்புத் திரைகளையும் ஒன்றாய் இணைத்தார்கள். இவ்வாறு இறைசமுகக் கூடாரம் ஒரே அமைப்பாய் ஆக்கப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","இறைசமுகக் கூடாரத்தின் மேலாக ஒரு கூடாரத்தைப் போடுவதற்கு ஆட்டு உரோமத்தினால் பதினோரு திரைகளைச் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","அந்த பதினொரு திரைகளும், ஒவ்வொன்றும் முப்பது முழம் நீளமும், நான்கு முழம் அகலமும் உள்ள ஒரே அளவுள்ளதாய் இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","அவர்கள் ஐந்து திரைகளை ஒரு தொகுப்பாகவும், மற்ற ஆறு திரைகளை இன்னொரு தொகுப்பாகவும் இணைத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","பின்பு அவர்கள் ஒரு தொகுப்பு திரையில் கடைசி திரையின் விளிம்பு நெடுகிலும் ஐம்பது வளையங்களை அமைத்தார்கள். மற்ற தொகுப்பு கடைசி திரையின் ஒரு விளிம்பு நெடுகிலும் அவ்வாறே அமைத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","அவர்கள் அந்தக் கூடாரத்தை ஒன்றாய் இணைப்பதற்காக ஐம்பது வெண்கலக் கொக்கிகளைச் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","பின்பு சிவப்புச் சாயம் தோய்த்த செம்மறியாட்டுக் கடாவின் தோலினால் அக்கூடாரத்திற்கு ஒரு மூடுதிரையைச் செய்தார்கள். அந்த மூடுதிரைக்கு மேலாகப் போடுவதற்குக் கடல்பசுத் தோலினால் மற்றொரு மூடுதிரையையும் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","இறைசமுகக் கூடாரத்திற்காக நிமிர்ந்து நிற்கும் மரச்சட்டங்களைச் சித்தீம் மரத்தினால் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ஒவ்வொரு மரச்சட்டமும் பத்து முழம் நீளமும், ஒன்றரை முழம் அகலமுமாயிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","அவை ஒன்றுக்கொன்று இணைந்ததாய் இருக்கும்படி இரண்டு முளைகள் அமைக்கப்பட்டிருந்தன. இறைசமுகக் கூடாரத்தின் மரச்சட்டங்களையெல்லாம் அவர்கள் இவ்விதமாகவே செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","இறைசமுகக் கூடாரத்தின் தெற்கு பக்கத்திற்காக அவர்கள் இருபது மரச்சட்டங்களைச் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ஒவ்வொரு முளை முனையையும் தாங்கி நிற்க ஒரு அடித்தளமாக ஒவ்வொரு மரச்சட்டத்திற்கும் கீழே இரு அடித்தளங்களாக நாற்பது வெள்ளி அடித்தளங்களைச் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","இறைசமுகக் கூடாரத்தின் வடக்குப் பக்கமான மறுபக்கத்திற்கும் அவர்கள் இருபது மரச்சட்டங்களைச் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ஒவ்வொரு மரச்சட்டத்திற்குக் கீழும் இரண்டு அடித்தளங்களாக நாற்பது வெள்ளி அடித்தளங்களை செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","இவ்வாறு அவர்கள் இறைசமுகக் கூடாரத்தின் கடைசியான மேற்குப் பக்கத்திற்கு ஆறு மரச்சட்டங்களைச் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","இறைசமுகக் கூடாரத்தின் கடைசியில் உள்ள இரு பக்கத்து மூலைகளுக்கும் இரண்டு சட்டப்பலகைகள் செய்யப்பட்டன. ");
INSERT INTO tamtcv_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","அந்த இரு மூலைகளிலும் சட்டப்பலகைகள் இரட்டையாக நிறுத்தப்பட்டு, அடியிலிருந்து நுனிவரை ஒரே வளையத்தினால் இணைக்கப்பட்டன. இரு மூலைகளும் ஒரேவிதமாகவே அமைக்கப்பட்டன. ");
INSERT INTO tamtcv_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","இவ்விதமாக பின்புறத்தில் எட்டு இணைப்புப் பலகைகள் நிறுத்தப்பட்டன. ஒவ்வொரு இணைப்பு பலகையின் கீழும் இரு அடித்தளங்களாக பதினாறு வெள்ளி அடித்தளங்களும் வைக்கப்பட்டன. ");
INSERT INTO tamtcv_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","அத்துடன் சித்தீம் மரத்தினால் குறுக்குச் சட்டங்களைச் செய்தார்கள். இறைசமுகக் கூடாரத்தின் ஒரு பக்கத்திலுள்ள மரச்சட்டங்களுக்கு ஐந்து குறுக்குச் சட்டங்களையும், ");
INSERT INTO tamtcv_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","மற்றப் பக்கத்திலுள்ள மரச்சட்டங்களுக்கு ஐந்து குறுக்குச் சட்டங்களையும், இறைசமுகக் கூடாரத்தின் கடைசியான மேற்குப் பக்கத்திலுள்ள மரச்சட்டங்களுக்காக ஐந்து குறுக்குச் சட்டங்களையும் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","நடுக்குறுக்குச் சட்டம் மரச்சட்டங்களின் நடுவே ஒரு முனை தொடங்கி மறுமுனைவரை நீண்டிருக்கும்படி செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","மரச்சட்டங்களைத் தங்கத்தகட்டால் மூடி, குறுக்குச் சட்டங்களை மாட்டுவதற்காக, தங்க வளையங்களையும் அதில் செய்தார்கள். குறுக்குச் சட்டங்களையும், தங்கத்தகட்டால் மூடினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","நீலம், ஊதா, சிவப்பு நூல்களினாலும், திரித்த மென்பட்டினாலும் ஒரு திரைச்சீலையைச் செய்து, அதில் திறமையான கலைஞர்கள் கேருபீன்களின் சித்திரவேலையைச் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","அந்தத் திரையைத் தொங்கவிடுவதற்கு சித்தீம் மரத்தினால் நான்கு கம்பங்களைச் செய்து, தங்கத்தகட்டால் அவற்றை மூடினார்கள். அவற்றுக்குத் தங்கத்தால் கொக்கிகளைச் செய்து, வெள்ளியினால் அதன் நான்கு அடித்தளங்களையும் வார்த்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","கூடாரத்தின் வாசலுக்கு நீலநூல், ஊதாநூல், கருஞ்சிவப்புநூல், திரித்த மென்பட்டு ஆகியவற்றால் சித்திரத்தையற்காரனின் வேலையாய் ஒரு திரைச்சீலையைச் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","இந்த திரைக்குக் கொக்கிகளை உடைய ஐந்து கம்பங்களைச் செய்தார்கள். கம்பங்களின் மேற்பகுதிகளையும், பூண்களையும் தங்கத்தகட்டால் மூடினார்கள். அவற்றுக்காக ஐந்து வெண்கல அடித்தளங்களையும் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","அதன்பின் பெசலெயேல் சித்தீம் மரத்தினால் ஒரு பெட்டியைச் செய்தான். அது இரண்டரை முழம் நீளமும், ஒன்றரை முழம் அகலமும், ஒன்றரை முழம் உயரமும் உடையதாயிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","அதை உள்ளேயும் வெளியேயும் சுத்தத் தங்கத்தகட்டால் மூடி, அதைச் சுற்றிலும் தங்கத்தினாலான ஒரு விளிம்புச்சட்டத்தை அமைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","அவன் அதற்காக நான்கு தங்க வளையங்களைச் செய்து, ஒரு பக்கத்திற்கு இரண்டு வளையங்களும், மற்றப் பக்கத்துக்கு இரண்டு வளையங்களுமாக அதன் நான்கு கால்களிலும் இணைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","சித்தீம் மரத்தினால் கம்புகளைச் செய்து, அவற்றைத் தங்கத்தகட்டால் மூடினான். ");
INSERT INTO tamtcv_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","பெட்டியைச் சுமப்பதற்கு அதன் பக்கங்களிலுள்ள வளையங்களில் கம்புகளை மாட்டிவைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","அவன் கிருபாசனத்தை சுத்தத் தங்கத்தினால் செய்தான். அது இரண்டரை முழம் நீளமும், ஒன்றரை முழம் அகலமுமாயிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","கிருபாசனத்தின் முனைகளிலும், அடித்துச் செய்யப்பட்ட தங்கத்தகட்டால் இரண்டு கேருபீன்களைச் செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","ஒரு பக்கத்தில் ஒரு கேருபீனையும், மறுபக்கத்தில் இன்னொரு கேருபீனையும் செய்தான். அவைகள் கிருபாசனத்தின் இரண்டு பக்கங்களிலும் ஒரே தகடாக இருக்கும்படிச் செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","அந்தக் கேருபீன்கள் தங்கள் சிறகுகளை மேல்நோக்கி விரித்து, அவற்றால் கிருபாசனத்தை மூடிக்கொண்டு நின்றன. அவை ஒன்றுக்கொன்று எதிராக நின்று கிருபாசனத்தை நோக்கிப் பார்த்துக்கொண்டு நின்றன. ");
INSERT INTO tamtcv_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","அவர்கள் சித்தீம் மரத்தினால் ஒரு மேஜையைச் செய்தார்கள். அது இரண்டு முழம் நீளமும், ஒரு முழம் அகலமும், ஒன்றரை முழம் உயரமுமாய் இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","பின்பு அவர்கள் அதைச் சுத்தத் தங்கத்தகட்டால் மூடி, சுற்றிலும் தங்க விளிம்புச்சட்டத்தை அமைத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","அதைச் சுற்றிலும் நான்கு விரலளவு அகலமான ஒரு சட்டத்தைச் செய்து, அதன்மேல் தங்க விளிம்புச்சட்டத்தை அமைத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","பின்பு மேஜைக்காக நான்கு தங்க வளையங்களைச் செய்து, அவற்றை அதன் கால்கள் இருக்கும் நான்கு மூலைகளிலும் பொருத்தினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","மேஜையைத் தூக்கும் கம்புகளை மாட்டுவதற்காகவே இந்த வளையங்கள் மேஜையின் சட்டத்திற்கு அருகே இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","மேஜையைச் சுமப்பதற்கான கம்புகளை சித்தீம் மரத்தினால் செய்து அவற்றைத் தங்கத்தகட்டால் மூடினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","மேஜையில் இருக்கும் பாத்திரங்களான தட்டங்கள், தட்டுகள், கிண்ணங்கள், பானகாணிக்கைகள் வார்ப்பதற்கான ஜாடிகள் ஆகியவற்றைச் சுத்தத் தங்கத்தினால் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","சுத்தத் தங்கத்தினால் ஒரு குத்துவிளக்கைச் செய்தார்கள். அதன் அடிப்பாகமும், தண்டும், பூ வடிவமான அதன் கிண்ணங்களும், மொட்டுகளும், பூக்களும் அடிக்கப்பட்ட சுத்தத் தங்கத்தினாலேயே அவர்கள் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","குத்துவிளக்கின் ஒரு பக்கத்தில் மூன்று கிளைகளும், மறுபக்கத்தில் மூன்று கிளைகளுமாக ஆறு கிளைகள் பிரிந்து சென்றன. ");
INSERT INTO tamtcv_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","அதன் ஒரு கிளையின் மேல் வாதுமை வடிவமான மூன்று கிண்ணங்கள் மொட்டுகளுடனும், பூக்களுடனும் இருந்தன. மற்றக் கிளையின் மேலும் அவ்வாறே அமைக்கப்பட்டிருந்தன. அவ்விதமாகவே குத்துவிளக்கிலிருந்து பிரிந்து செல்லுகிற அதன் ஆறுகிளைகளிலும் அமைக்கப்பட்டிருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","குத்துவிளக்கின் மேல் உச்சியில் வாதுமைப் பூ வடிவமான நான்கு கிண்ணங்கள் மொட்டுகளுடனும், பூக்களுடனும் அமைக்கப்பட்டிருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","குத்துவிளக்கிலிருந்து விரிகின்ற முதலாவது ஜோடிக்கிளைகளுக்குக் கீழே ஒரு மொட்டும் இரண்டாவது ஜோடிக்கிளைகளுக்குக் கீழே இரண்டாவது மொட்டும், மூன்றாவது ஜோடிக்கிளைகளுக்குக் கீழே மூன்றாவது மொட்டுமாக அமைக்கப்பட்டிருந்தன. அதற்கு எல்லாமுமாக ஆறு கிளைகள் இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","மொட்டுகளும், கிளைகளும் குத்துவிளக்குடன் ஒரே சுத்தத் தங்கத்தகட்டால் அடித்துச் செய்யப்பட்டிருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","அதன் ஏழு அகல் விளக்குகளையும், அதன் விளக்குத்திரி கத்தரிகளையும், அவற்றை வைப்பதற்கான தட்டங்களையும் சுத்த தங்கத்தினால் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","குத்துவிளக்கையும் அதற்கான எல்லா உபகரணங்களையும் ஒரு தாலந்து எடையுள்ள சுத்தத் தங்கத்தினால் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","அவர்கள் தூபபீடத்தை சித்தீம் மரத்தினால் செய்தார்கள். அது ஒரு முழம் நீளமும் ஒரு முழம் அகலமுமுள்ள சதுர வடிவில், இரண்டு முழம் உயரமுள்ளதாய் இருந்தது. அதன் கொம்புகள் அதனுடன் இணைந்ததாய் செய்யப்பட்டிருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","மேஜையின் மேல்பகுதியையும், அதன் எல்லா பகுதியையும், கொம்புகளையும் சுத்தத் தங்கத்தகட்டால் மூடி, சுற்றிலும் தங்கப்பட்டியை அமைத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","தூபபீடத்தைச் சுமப்பதற்கான கம்புகளை மாட்டுவதற்காக தங்கப்பட்டிக்குக் கீழே இரண்டு எதிரெதிர் பக்கங்களிலும் ஒவ்வொரு பக்கத்திற்கும் இரண்டிரண்டு தங்க வளையங்களை அமைத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","அக்கம்புகளை சித்தீம் மரத்தினால் செய்து, அவற்றைத் தங்கத்தகட்டால் மூடினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","அவர்கள் பரிசுத்த அபிஷேக எண்ணெயையும், சுத்தமான நறுமணத்தூளையும் வாசனை தைலம் தயாரிப்பவன் செய்வதுபோல் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","அவர்கள் சித்தீம் மரத்தினால் மூன்று முழம் உயரமான தகன பலிபீடத்தைச் செய்தார்கள். அது ஐந்து முழம் நீளமும், ஐந்து முழம் அகலமுமுள்ள சதுரமாய் இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","அதன் நான்கு மூலைகளிலும் ஒவ்வொரு கொம்பை வைத்து, பீடத்தோடு ஒரே அமைப்பாய் இருக்கும்படி அவற்றை அமைத்தார்கள். அப்பீடத்தை வெண்கலத் தகட்டால் மூடினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","பீடத்திற்குத் தேவையான சாம்பல் அள்ளும் பானைகள், வாரிகள், தெளிக்கும் கிண்ணங்கள், இறைச்சியை எடுக்கும் முட்கரண்டிகள், நெருப்புச் சட்டிகள் ஆகிய பாத்திரங்களையெல்லாம் வெண்கலத்தால் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","அதற்கு வெண்கலக் கம்பியினால் சல்லடையைச் செய்து, அதை அதன் விளிம்புக்குக் கீழே, பீடத்தின் உள்ளே அதன் பாதி உயரத்தில் இருக்கும்படி வைத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","அந்த வெண்கலச் சல்லடையின் நான்கு மூலைகளிலும், கம்புகள் மாட்டுவதற்கு நான்கு வெண்கல வளையங்களைச் செய்து பொருத்தினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","கம்புகளை சித்தீம் மரத்தினால் செய்து, அவற்றை வெண்கலத் தகட்டால் மூடினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","அந்தக் கம்புகள் பீடத்தை தூக்கிச் சுமப்பதற்காக இரண்டு பக்கங்களிலும் இருக்கும்படி அவற்றை மாட்டினார்கள். அந்த பீடம் நான்கு பக்கமும் பலகையால் செய்யப்பட்டிருந்தது. அதன் உட்புறம் இடைவெளிவிட்டு வெறுமையாய் இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","சபைக் கூடாரத்தின் வாசலில், கூடி நின்று பணிசெய்த பெண்கள் கண்ணாடியாகப் பயன்படுத்தும் வெண்கலத்தை அவர்களிடமிருந்து பெற்று, வெண்கலத் தொட்டியையும் அதன் வெண்கலக் கால்களையும் உண்டாக்கினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","அதன்பின் அவர்கள் முற்றத்தை அமைத்தார்கள். அது தெற்குப் பக்கம் நூறுமுழம் நீளமாய் இருந்தது. அதற்கு திரித்த மென்பட்டு நூலினால் நெய்யப்பட்ட திரைகள் இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","அத்திரையைத் தொங்கவிடுவதற்கு இருபது கம்பங்களும், அதற்கு இருபது வெண்கல அடித்தளங்களும் இருந்தன. அவற்றுக்கு வெள்ளிக் கொக்கிகளும், பூண்களும் இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","அதன் வடக்குப் பக்கமும் நூறுமுழம் நீளமாய் இருந்தது. அதற்கும் திரைகள் இருந்ததால், இருபது கம்பங்களும், இருபது வெண்கல அடித்தளங்களும் இருந்தன. அவற்றிற்கும் வெள்ளிக் கொக்கிகளும், பூண்களும் இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","முற்றத்தின் மேற்குப் பக்கமும் ஐம்பது முழம் அகலமாய் இருந்தது. அதற்குத் திரைகளும் இருந்தன. அவற்றைத் தொங்கவிடுவதற்கான பத்து கம்பங்களும், பத்து அடித்தளங்களும் இருந்தன. அத்துடன் அவற்றுக்கு வெள்ளிக் கொக்கிகளும், கம்பங்களில் பூண்களும் இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","சூரியன் உதிக்கும் திசையை நோக்கியிருக்கிற கிழக்குப் பக்கமும் ஐம்பது முழம் அகலமாய் இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","வாசலின் ஒரு பக்கத்திற்கு பதினைந்து முழம் நீளமான திரைகள் இருந்தன. அவற்றைத் தொங்கவிடுவதற்கான மூன்று கம்பங்களும், மூன்று அடித்தளங்களும் இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","முற்றத்து வாசலின் மற்றப் பக்கத்திற்கு பதினைந்து முழம் நீளமான திரைகள் இருந்தன. அவற்றைத் தொங்கவிடுவதற்கு மூன்று கம்பங்களும் மூன்று அடித்தளங்களும் இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","முற்றத்தைச் சுற்றிலும் இருந்த திரைகளெல்லாம் திரிக்கப்பட்ட மென்பட்டுநூலால் நெய்யப்பட்டிருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","அங்கிருந்த எல்லா கம்பங்களின் அடித்தளங்களும் வெண்கலத்தாலும், அக்கம்பங்களின் கொக்கிகளும் பூண்களும் வெள்ளியாலும் செய்யப்பட்டிருந்தன. அவற்றின் மேற்பகுதிகள் வெள்ளித் தகட்டால் மூடப்பட்டிருந்தன. இவ்வாறு முற்றத்தின் எல்லா கம்பங்களும் வெள்ளிப் பூண்கள் உடையதாய் இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","முற்றத்தின் நுழைவு வாசலுக்கு போடப்பட்ட திரை, நீலநூல், ஊதாநூல், கருஞ்சிவப்புநூல், திரிக்கப்பட்ட மென்பட்டுத் துணியினால் நெய்யப்பட்ட சித்திரத்தையற்காரனின் வேலையாய் இருந்தது. அது இருபது முழம் நீளமும், முற்றத்தின் திரைகளைப்போல் ஐந்து முழம் உயரம் உடையதுமாய் இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","அதைத் தொங்கவிடுவதற்கு நான்கு கம்பங்களும், நான்கு வெண்கல அடித்தளங்களும் இருந்தன. அவற்றின் கொக்கிகளும், பூண்களும் வெள்ளியால் செய்யப்பட்டிருந்தன. அவற்றின் மேற்பகுதிகளும் வெள்ளித் தகட்டால் மூடப்பட்டிருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","இறைசமுகக் கூடாரத்தையும், அதன் முற்றத்தையும் சுற்றியிருந்த கூடார முளைகள் வெண்கலத்தினாலேயே செய்யப்பட்டிருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","சாட்சிக் கூடாரமான இறைசமுகக் கூடாரத்தின் வேலைகளுக்காக பயன்படுத்தப்பட்ட பொருட்களின் தொகைகள் இவையே: அவைகள் மோசேயின் கட்டளைப்படி, ஆசாரியன் ஆரோனின் மகன் இத்தாமாரின் மேற்பார்வையின்கீழ் லேவியர்களால் பதிவுசெய்யப்பட்டிருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","யூதா கோத்திரத்தைச் சேர்ந்த ஊரின் பேரனும் ஊரியின் மகனுமான பெசலெயேல் யெகோவா மோசேக்குக் கட்டளையிட்டதை எல்லாம் செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","தாண் கோத்திரத்தைச் சேர்ந்த அகிசாமாகின் மகன் அகோலியாபும் அவனோடு இருந்தான். அவன் கலைஞனும், ஓவியனும், நீலநூல், ஊதாநூல், கருஞ்சிவப்புநூல், திரிக்கப்பட்ட மென்பட்டுத் துணியினால் வேலைசெய்யும் சித்திரத் தையல்காரனுமாயிருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","பரிசுத்த இடத்தின் எல்லா வேலைக்கும் என்று, அசைவாட்டும் காணிக்கையிலிருந்து பயன்படுத்தப்பட்ட தங்கத்தின் மொத்தத்தொகை, பரிசுத்த இடத்தின் சேக்கல் நிறைப்படி 29 தாலந்துகளும் 730 சேக்கலுமாயிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","மக்கள் தொகை கணக்கெடுப்பின்போது, எண்ணப்பட்ட மக்கள் சமுதாயத்திலிருந்து பெறப்பட்ட வெள்ளி, பரிசுத்த இடத்தின் நிறையின்படி 100 தாலந்துகளும், 1,775 சேக்கலுமாயிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","இருபது வயதிற்கும் அதற்கு மேற்பட்டவர்களும் கணக்கிடப்பட்டு கடந்து செல்லும்போது ஒவ்வொருவரிடமிருந்தும் ஆளுக்கு ஒரு பெக்கா வசூலிக்கப்பட்டது. ஒரு பெக்கா என்பது பரிசுத்த இடத்தின் சேக்கல் அளவின்படி அரைச்சேக்கலாகும். எண்ணப்பட்ட மனிதரின் மொத்தத்தொகை 6,03,550 பேர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","கொடுக்கப்பட்ட அந்த 100 தாலந்து வெள்ளியும் பரிசுத்த இடத்திற்கான அடித்தளங்களையும், திரைக்கான அடித்தளங்களையும் செய்ய உபயோகப்படுத்தப்பட்டது. ஒவ்வொரு அடித்தளத்துக்கும் ஒரு அடித்தளத்துக்கு ஒரு தாலந்து என்ற கணக்கின்படி 100 அடித்தளங்களுக்கு 100 தாலந்துகள் பயன்படுத்தப்பட்டன. ");
INSERT INTO tamtcv_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","அவர்கள் 1,775 சேக்கல் வெள்ளியை கம்பங்களுக்கான கொக்கிகளைச் செய்வதற்கும் அவற்றுக்கான மேற்பரப்பைத் தகட்டால் மூடுவதற்கும், கம்பங்களுக்கான பூண்களைச் செய்வதற்கும் உபயோகித்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","அசைவாட்டும் காணிக்கையிலிருந்து பெறப்பட்ட வெண்கலத்தின் அளவு 70 தாலந்துகளும், 2,400 சேக்கலுமாகும். ");
INSERT INTO tamtcv_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","அந்த வெண்கலத்தை சபைக் கூடாரத்தின் நுழைவு வாசலின் அடித்தளங்களையும், வெண்கலபீடத்தையும், அதற்கான வெண்கலச் சல்லடையையும், பீடத்திற்குரிய எல்லா பாத்திரங்களையும் செய்ய உபயோகித்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","அத்துடன் முற்றத்தைச் சுற்றியிருந்த அடித்தளங்களையும், வாசலின் அடித்தளத்தையும், இறைசமுகக் கூடாரத்திற்கும் அதைச் சுற்றியிருந்த முற்றத்திற்குமான கூடார முளைகளையும் செய்ய உபயோகித்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","பரிசுத்த இடத்தில் ஊழியம் செய்வதற்காக நீலநூல், ஊதாநூல், கருஞ்சிவப்பு நூல்களினால் நெய்யப்பட்ட உடைகளைச் செய்தார்கள். யெகோவா மோசேக்குக் கட்டளையிட்டபடியே ஆரோனுக்குப் பரிசுத்த உடைகளையும் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","ஏபோத்தைத் தங்கத்தினாலும், நீலம், ஊதா, கருஞ்சிவப்பு ஆகிய நூல்களினாலும் திரித்த மென்பட்டுத் துணியினாலும் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","தங்கத்தை மெல்லிய தகடுகளாக அடித்து, அதைச் சரிகை நூலாக வெட்டி, நீலம், ஊதா, கருஞ்சிவப்புநூல், மென்பட்டுத் துணிகளுடன் நெய்து திறமையான சித்திரத்தையல் வேலையாகச் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","ஏபோத்தின் இரண்டு மூலைகளிலும் தொடுக்கப்படுவதற்கு, இணைக்கக்கூடிய ஏபோத்தின் தோள்பட்டிகளைச் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","அதன் நுட்பமாக நெய்யப்பட்ட இடைப்பட்டியும் அதைப் போலவே செய்யப்பட்டு, அதுவும் ஏபோத்துடன் ஒரே இணைப்பாக தங்கம், நீலநூல், ஊதாநூல், கருஞ்சிவப்புநூல், திரித்த மென்பட்டு ஆகியவற்றைக்கொண்டு இணைத்து, யெகோவா மோசேக்குக் கட்டளையிட்டபடியே செய்யப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","கோமேதகக் கற்களைத் தங்கச்சரிகை வேலைப்பாடுகளில் பதித்து, அவற்றின்மேல் இஸ்ரயேலின் மகன்களின் பெயர்களை ஒரு முத்திரையைப்போல் பொறித்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","பின்பு அவற்றை இஸ்ரயேலின் மகன்களுக்கான நினைவுச்சின்னக் கற்களாக ஏபோத்தின் தோள்பட்டியில் இணைத்தார்கள். இவை யெகோவா மோசேக்குக் கட்டளையிட்டபடியே செய்யப்பட்டன. ");
INSERT INTO tamtcv_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","அவர்கள் ஒரு திறமையான கைவினைக் கலைஞனின் வேலைப்பாடாக மார்பு அணியைச் செய்தார்கள். ஏபோத்தைப்போலவே அதைத் தங்கம், நீலநூல், ஊதாநூல், கருஞ்சிவப்புநூல், திரித்த மென்பட்டு ஆகியவற்றைக்கொண்டு செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","மார்பு அணி ஒரு சாண் நீளமும், ஒரு சாண் அகலமும் உடைய இரண்டாக மடிக்கப்பட்ட சதுரத்துண்டாயிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","அதில் நான்கு வரிசைகளில் இரத்தினக் கற்களைப் பதித்தார்கள். முதல் வரிசையில் பத்மராகம், புஷ்பராகம், மாணிக்கம்; ");
INSERT INTO tamtcv_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","இரண்டாம் வரிசையில் மரகதம், இந்திரநீலம், வைரம்; ");
INSERT INTO tamtcv_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","மூன்றாம் வரிசையில் கெம்பு, வைடூரியம், சுகந்தி; ");
INSERT INTO tamtcv_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","நான்காம் வரிசையில் படிகப்பச்சை, கோமேதகம், யஸ்பி ஆகியவை இருந்தது. அவற்றைத் தங்கச்சரிகை வேலையாக பதித்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","இஸ்ரயேலின் மகன்களின் பெயர்கள் ஒவ்வொன்றுக்கும் ஒவ்வொரு கற்களாக, பன்னிரண்டு கற்கள் இருந்தன. பன்னிரண்டு கோத்திரங்களின் பெயர்களும் ஒவ்வொரு கல்லிலும் முத்திரையைப்போல் பொறிக்கப்பட்டிருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","மார்பு அணிக்காக கயிறுபோல் பின்னப்பட்ட ஒரு சங்கிலியைச் சுத்தத் தங்கத்தினால் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","அவர்கள் இரண்டு தங்கச்சரிகை நூல் வேலைகளையும், இரண்டு தங்க வளையங்களையும் செய்தார்கள். அந்த இரண்டு வளையங்களையும் மார்பு அணியின் இரண்டு மூலைகளிலும் பொருத்தினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","மார்பு அணியின் இரண்டு பக்கங்களிலும் உள்ள வளையங்களில் தங்கச்சங்கிலிகளைத் தொடுத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","சங்கிலிகளின் மற்ற நுனிகளைச் சரிகை நூல் வேலைகளுடன் தொடுத்து, அவற்றைத் தோள்பட்டிகளுடன் ஏபோத்தின் முன்பக்கத்தில் இணைத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","அவர்கள் தங்கத்தால் இன்னும் இரண்டு வளையங்களைச் செய்து, அவற்றை ஏபோத்தை ஒட்டியுள்ள மார்பு அணியின் கீழ் விளிம்பின் இரண்டு மூலைகளில் உட்பக்கத்தில் வைத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","அவர்கள் வேறு இரண்டு தங்க வளையங்களையும் செய்து, ஏபோத்தின் முன்பக்கத்தில் அதன் இடைப்பட்டிகளுக்கு மேல் இருந்த மூட்டுக்கு அடுத்துள்ள பொருத்தில், தோள்பட்டிகளின் அடிப்பாகத்துடன் அவற்றைப் பொருத்தினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","மார்பு அணியை இடைப்பட்டியுடன் இணைக்கும்படியாகவும், அது ஏபோத்திலிருந்து விலகாமல் இருக்கும்படியாகவும், ஏபோத்தின் வளையங்களுடன் மார்பு அணியின் வளையங்களை நீல நாடாவால் கட்டினார்கள். இவற்றை யெகோவா மோசேக்குக் கட்டளையிட்டபடியே செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","அவர்கள் ஏபோத்தின் மேலங்கி முழுவதையும் நீலநிறத் துணியினால் ஒரு நெசவாளியின் வேலையாகச் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","அந்த அங்கியின் நடுவில் கழுத்துப்பட்டியின் திறப்பைப் போன்ற ஒரு திறப்பை அமைத்தார்கள். கழுத்துத் துவாரம் கிழியாதபடி சுற்றிலும் ஒரு பட்டியை வைத்துத் தைத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","அந்த அங்கியின் கீழ்ப்பக்க ஓரத்தைச் சுற்றிலும், நீலம், ஊதா, கருஞ்சிவப்பு நூல்களினாலும், திரித்த மென்பட்டுத் துணியினாலும் மாதுளம் பழங்களைச் செய்து அலங்கரித்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","அங்கியின் ஓரங்களைச் சுற்றிலும் மாதுளம் பழங்களின் இடையிடையே இருக்கத்தக்கதாக சுத்தத் தங்கத்தினால் மணிகளைச் செய்து தொங்கவிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","யெகோவா மோசேக்குக் கட்டளையிட்டபடியே, ஆசாரியப் பணியைச் செய்வதற்காக ஆரோன் உடுத்தியிருக்கும் அங்கியின் கீழ்ப்பக்க ஓரத்தைச் சுற்றிலும் ஒரு மாதுளம் பழமும், ஒரு மணியுமாக, மாறிமாறி அலங்கரிக்கப்பட்டிருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","ஆரோனுக்காகவும், அவனுடைய மகன்களுக்காகவும் மென்பட்டு நூலினால் ஒரு நெசவாளியின் வேலையாக உள் அங்கிகளைச் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","மென்பட்டினால் தலைப்பாகையையும், அதன் கச்சையையும், திரித்த மென்பட்டுத் துணியினால் கால் சட்டைகளையும் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","திரித்த மென்பட்டுத் துணி, நீலநூல், ஊதாநூல், கருஞ்சிவப்புநூல் ஆகியவற்றால் சித்திரத்தையற்காரனின் வேலையாய் ஒரு இடைப்பட்டியையும் செய்தார்கள். இவை யெகோவா மோசேக்குக் கட்டளையிட்டபடியே செய்யப்பட்டன. ");
INSERT INTO tamtcv_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","மேலும் அவர்கள் சுத்தத் தங்கத்தினால் தகடு ஒன்றைச் செய்து, முத்திரையைப்போல அதில் இதைப் பொறித்தார்கள்: “யெகோவாவுக்குப் பரிசுத்தம்” ");
INSERT INTO tamtcv_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","அதில் ஒரு நீலநிற நாடாவைக் கட்டி தலைப்பாகையோடு இருக்கும்படி அதை இணைத்தார்கள். இவை யெகோவா மோசேக்குக் கட்டளையிட்டபடியே செய்யப்பட்டன. ");
INSERT INTO tamtcv_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","சபைக் கூடாரமான இறைசமுகக் கூடாரத்தின் வேலைகளெல்லாம் செய்துமுடிக்கப்பட்டன. யெகோவா மோசேக்குக் கட்டளையிட்டபடியே இஸ்ரயேல் மக்கள் எல்லாவற்றையும் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","அதன்பின் இறைசமுகக் கூடாரத்தை மோசேயிடம் கொண்டுவந்தார்கள்: கூடாரமும், அதன் எல்லா பணிமுட்டுகளும், கொக்கிகள், சட்டப்பலகைகள், குறுக்குச் சட்டங்கள், கம்பங்கள், அடித்தளங்கள், ");
INSERT INTO tamtcv_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","அத்துடன் சிவப்புச் சாயம் தோய்க்கப்பட்ட ஆட்டுக்கடாத் தோலினால் செய்யப்பட்ட மூடுதிரை, கடல்பசுத் தோலினால் செய்யப்பட்ட மூடுதிரை, மறைக்கும் திரை, ");
INSERT INTO tamtcv_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","சாட்சிப்பெட்டியுடன் அதன் கம்புகள், அதன் கிருபாசனம், ");
INSERT INTO tamtcv_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","மேஜையுடன் அதற்குரிய எல்லா பொருட்கள், இறைசமுக அப்பம், ");
INSERT INTO tamtcv_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","சுத்தத் தங்கத்தாலான குத்துவிளக்கு, அதில் வரிசையாக உள்ள அகல்விளக்குகள், அதன் உபகரணங்கள், வெளிச்சத்துக்கான எண்ணெய், ");
INSERT INTO tamtcv_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","தங்கத் தூபபீடம், அபிஷேக எண்ணெய், நறுமணத்தூள், கூடார வாசலின் திரை, ");
INSERT INTO tamtcv_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","வெண்கலப் பலிபீடம், அதன் வெண்கலச் சல்லடை, அதன் கம்புகள், அதன் எல்லா பாத்திரங்கள், தொட்டி, அதன் கால்கள், ");
INSERT INTO tamtcv_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","முற்றத்திற்கான திரைகள், அதற்குரிய கம்புகள், அடித்தளங்கள், முற்ற வாசலுக்கான திரைகள், அதன் கயிறுகள், முற்றத்திலுள்ள முளைகள், சபைக் கூடாரமான இறைசமுகக் கூடாரத்தின் எல்லா பொருட்கள்; ");
INSERT INTO tamtcv_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","உட்பட ஆசாரியனான ஆரோனுக்கான பரிசுத்த உடைகளும், அவன் மகன்கள் பரிசுத்த இடத்தில் ஆசாரியப் பணிசெய்யும்போது உடுத்தும் உடைகளுமான நெய்யப்பட்ட உடைகளையும் கொண்டுவந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","யெகோவா மோசேக்குக் கட்டளையிட்டபடியே இஸ்ரயேல் மக்கள் எல்லா வேலைகளையும் செய்திருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","மோசே அவைகளையெல்லாம் பார்வையிட்டான். அப்பொழுது யெகோவா கட்டளையிட்டபடியே அவைகளைச் செய்திருக்கிறார்கள் என்று மோசே கண்டான். எனவே மோசே அவர்களை ஆசீர்வதித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","பின்பு யெகோவா மோசேயிடம் சொன்னதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“நீ சபைக் கூடாரமான இறைசமுகக் கூடாரத்தை, முதலாம் மாதம், முதலாம் நாளில் நிறுவவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","அதில் சாட்சிப்பெட்டியை வைத்து அதைத் திரையினால் மறைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","மேஜையைக் கொண்டுவந்து, அதற்குரியவற்றை மேஜையின்மேல் வைக்கவேண்டும். அதன்பின் குத்துவிளக்குகளைக் கொண்டுவந்து அதன் அகல்விளக்குகளை வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","தங்கத் தூபபீடத்தைச் சாட்சிப்பெட்டியின் முன் வைத்து, இறைசமுகக் கூடாரத்தின் வாசலில் திரையைப்போட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“பின்பு தகன பலிபீடத்தை சபைக் கூடாரமான இறைசமுகக் கூடாரத்தின், வாசலுக்கு முன் வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","தொட்டியை சபைக் கூடாரத்திற்கும் பலிபீடத்திற்கும் இடையில் வைத்து, அதில் தண்ணீரை ஊற்றவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","அவற்றைச் சுற்றிலும் முற்றத்தை அமைத்து முற்றத்தின் வாசலுக்குத் திரையைப்போட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“பின்பு அபிஷேக எண்ணெயை எடுத்து, இறைசமுகக் கூடாரத்தையும், அங்குள்ள எல்லாவற்றையும் அபிஷேகம்பண்ணு. அதையும் அதன் பணிமுட்டுகளையும் அர்ப்பணம் செய்யவேண்டும். அப்பொழுது அது பரிசுத்தமாயிருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","பின்பு தகன பலிபீடத்தையும், அதன் பாத்திரங்களையும் அபிஷேகம் செய்து, பீடத்தை அர்ப்பணம் செய்யவேண்டும். அப்பொழுது பலிபீடம் மகா பரிசுத்தமுள்ளதாயிருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","பின்பு தொட்டியையும், அதன் கால்களையும் அபிஷேகம்பண்ணி, அவற்றை அர்ப்பணம் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“அதன்பின்பு ஆரோனையும், அவன் மகன்களையும் சபைக் கூடாரத்தின் நுழைவுவாசலில் கொண்டுவந்து, அவர்களை தண்ணீரால் கழுவவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","ஆரோனுக்குப் பரிசுத்த உடைகளை உடுத்தி, அவன் ஆசாரியராக எனக்குப் பணிசெய்வதற்கு அவனை அபிஷேகம்பண்ணி, அர்ப்பணம் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","அவனுடைய மகன்களையும் அழைத்துவந்து, அவர்களுக்கு உள் அங்கிகளை உடுத்து. ");
INSERT INTO tamtcv_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","அவர்கள் எனக்கு ஆசாரியப் பணிசெய்யும்படி, அவர்களுடைய தகப்பனை அபிஷேகம் செய்ததுபோலவே அவர்களையும் அபிஷேகம் செய்யவேண்டும். அவர்கள் பெற்ற இந்த, ‘அபிஷேகம்’ தலைமுறைதோறும் நீடித்திருக்கும் ஆசாரியத்துவத்திற்கான அபிஷேகமாய் இருக்கும்.” ");
INSERT INTO tamtcv_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","யெகோவா தனக்குக் கட்டளையிட்டபடியே மோசே எல்லாவற்றையும் செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","இவ்விதமாக எகிப்திலிருந்து புறப்பட்ட இரண்டாம் வருடம் முதலாம் மாதம் முதல் நாளன்று, இறைசமுகக் கூடாரம் அமைக்கப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","மோசே இறைசமுகக் கூடாரத்தை அமைத்தபோது, அதன் அடித்தளங்களை அதனிடங்களில் பொருத்தி சட்டப்பலகைகளை நிறுத்தி, அதன் குறுக்குச் சட்டங்களையும் மாட்டி, அதன் கம்பங்களை நிறுத்தினான். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","யெகோவா கட்டளையிட்டபடியே மோசே இறைசமுகக் கூடாரத்திற்கு மேலாகக் கூடாரத்தை விரித்து, கூடாரத்தின்மேல் மூடுதிரையைப் போட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","பின்பு சாட்சிக் கற்பலகைகளை எடுத்து அவற்றைப் பெட்டிக்குள் வைத்தான். பின்பு அதைத் தூக்கும் கம்புகளைப் பெட்டியில் மாட்டி, கிருபாசனத்தைப் பெட்டியின் மேலே வைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","இவ்வாறு மோசே யெகோவா தனக்குக் கட்டளையிட்டபடியே, பெட்டியை இறைசமுகக் கூடாரத்திற்குள் கொண்டுவந்து, மூடுதிரையைத் தொங்கவிட்டு சாட்சிப்பெட்டியை மறைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","அதன்பின் மோசே மேஜையை சபைக் கூடாரத்தில் திரைக்கு வெளியே, இறைசமுகக் கூடாரத்தின் வடக்குத் திசையில் வைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","யெகோவாவின் கட்டளைப்படியே யெகோவாவின் முன்பாக மேஜையில் அப்பங்களை வைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","பின்பு குத்துவிளக்கை சபைக் கூடாரத்தில், மேஜைக்கு எதிரே இறைசமுகக் கூடாரத்தின் தெற்கு பக்கத்தில் வைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","யெகோவா தனக்குக் கட்டளையிட்டபடியே மோசே விளக்குகளை யெகோவா முன்னிலையில் வைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","தங்கப் பலிபீடத்தைச் சபைக் கூடாரத்தின் திரைக்கு முன்னால் வைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","யெகோவா தனக்குக் கட்டளையிட்டபடியே, மோசே நறுமணத்தூளை அதன்மேல் எரித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","இறைசமுகக் கூடாரத்தின் வாசலில் திரையைத் தொங்கவிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","யெகோவா அவனுக்குக் கட்டளையிட்டபடியே, சபைக் கூடாரமான இறைசமுகக் கூடாரத்தின் நுழைவு வாசலுக்கு அருகே தகன பலிபீடத்தை வைத்து, அதன்மேல் தகன காணிக்கையையும், தானியக் காணிக்கையையும் செலுத்தினான். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","பின்பு சபைக் கூடாரத்திற்கும் பீடத்திற்கும் இடையில் தொட்டியை வைத்து, கழுவுவதற்கு அதற்குள் தண்ணீரை ஊற்றினான். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","மோசேயும், ஆரோனும், அவன் மகன்களும், தங்கள் கைகளையும், கால்களையும் கழுவுவதற்கு அதை உபயோகித்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","யெகோவா மோசேக்குக் கட்டளையிட்டபடியே, அவர்கள் சபைக் கூடாரத்திற்குள் போகும்போதும் அல்லது பீடத்திற்கு அருகே வரும்போதும் தங்களைக் கழுவிக்கொள்வார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","பின்பு மோசே இறைசமுகக் கூடாரத்தையும், பலிபீடத்தையும் சுற்றி முற்றத்தை அமைத்து, முற்றத்தின் வாசலில் திரையைத் தொங்கவிட்டான். இவ்வாறு மோசே எல்லா வேலைகளையும் செய்துமுடித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","அப்பொழுது சபைக் கூடாரத்தை ஒரு மேகம் மூடியது. யெகோவாவின் மகிமை இறைசமுகக் கூடாரத்தை நிரப்பியது. ");
INSERT INTO tamtcv_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","மேகம் சபைக் கூடாரத்தின்மேல் தங்கியிருந்தபடியாலும், யெகோவாவின் மகிமை இறைசமுகக் கூடாரத்தை நிரப்பியிருந்தபடியாலும் மோசேயினால் சபைக் கூடாரத்திற்குள் போகமுடியாதிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","இஸ்ரயேலரின் பயணங்கள் எல்லாவற்றிலும், இறைசமுகக் கூடாரத்திற்கு மேலுள்ள மேகம் மேலே எழும்பும்போது, அவர்கள் புறப்படுவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","மேகம் மேலே எழும்பாதிருந்தால், அது மேலே எழும்பும்வரை புறப்படாதிருப்பார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","இஸ்ரயேல் மக்கள் பயணம் செய்த காலமெல்லாம் இஸ்ரயேல் குடும்பத்தாரின் பார்வையில் யெகோவாவின் மேகம் பகல் வேளையில் இறைசமுகக் கூடாரத்தின் மேலாகக் காணப்பட்டது. இரவுவேளையில் அந்த மேகத்தில் நெருப்பும் இருக்கக் காணப்பட்டது.");
INSERT INTO tamtcv_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","யெகோவா சபைக் கூடாரத்திலிருந்து மோசேயைக் கூப்பிட்டு, அவனுடன் பேசினார். ");
INSERT INTO tamtcv_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“நீ இஸ்ரயேலருடன் பேசிச் சொல்லவேண்டியதாவது: ‘உங்களில் யாராவது யெகோவாவுக்கு ஒரு காணிக்கையைக் கொண்டுவரும்போது, ஆட்டு மந்தையிலிருந்தோ, மாட்டு மந்தையிலிருந்தோ ஒரு மிருகத்தை உங்கள் காணிக்கையாகக் கொண்டுவாருங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘அக்காணிக்கை மாட்டு மந்தையிலிருந்து கொடுக்கப்படும் தகன காணிக்கையானால், அவன் குறைபாடற்ற ஒரு காளையை காணிக்கையாகக் கொடுக்கவேண்டும். அது யெகோவாவினால் ஏற்றுக்கொள்ளப்படும்படி, அவன் அதைச் சபைக்கூடார வாசலில் கொண்டுவந்து ஒப்படைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","அவன் அந்த தகன காணிக்கை மிருகத்தின் தலையின்மேல் தன் கையை வைக்கவேண்டும். அது அவனுடைய பாவங்களை நிவிர்த்தி செய்வதற்கு அவன் சார்பில் ஏற்றுக்கொள்ளப்படும். ");
INSERT INTO tamtcv_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","யெகோவாவின் முன்னிலையில் அவன் அந்த இளங்காளையை வெட்டிக் கொல்லவேண்டும். ஆரோனின் மகன்களான ஆசாரியர்கள் அந்தக் காளையின் இரத்தத்தைக் கொண்டுவந்து, சபைக்கூடார வாசலில் இருக்கும் பலிபீடத்தின் எல்லா பக்கங்களிலும் தெளிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","பின்பு அந்தக் காணிக்கையைக் கொண்டுவந்தவன், தகன காணிக்கை மிருகத்தைத் தோலுரித்துத் துண்டுகளாக வெட்டவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","ஆரோனின் மகன்களான ஆசாரியர்கள், பலிபீடத்தின்மேல் நெருப்பை மூட்டி, அந்த நெருப்பின்மேல் விறகுகளை அடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","அதன்பின் ஆரோனின் மகன்களான ஆசாரியர்கள் அந்தத் துண்டுகளை, தலையும் கொழுப்பும் உட்பட பலிபீடத்தில் எரிகின்ற விறகுகளின்மேல் அடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","ஆகிலும், உள்ளுறுப்புகளையும், கால்களையும் காணிக்கையைக் கொண்டுவந்தவன் தண்ணீரால் கழுவவேண்டும். ஆசாரியர், அவையெல்லாவற்றையும் பலிபீடத்தின்மேல் எரித்துவிடவேண்டும். இது ஒரு தகன காணிக்கை. இது யெகோவாவுக்கு மகிழ்ச்சியூட்டும் நறுமணமாக, நெருப்பினால் செலுத்தப்படும் ஒரு காணிக்கை. ");
INSERT INTO tamtcv_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘அந்தக் காணிக்கை செம்மறியாட்டு மந்தையிலிருந்தோ, வெள்ளாட்டு மந்தையிலிருந்தோ எடுக்கப்படும் தகன காணிக்கையாக இருந்தால், அவன் குறைபாடற்ற ஒரு கடாவைச் செலுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","அவன் அதைப் பலிபீடத்தின் வடக்குப் பக்கத்தில் யெகோவாவுக்கு முன்பாக வெட்டிக் கொல்லவேண்டும். அதன் இரத்தத்தை ஆரோனின் மகன்களான ஆசாரியர்கள், பலிபீடத்தின் எல்லா பக்கங்களிலும் தெளிப்பார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","அவன் அதைத் துண்டுகளாக வெட்டவேண்டும். அந்தத் துண்டங்களை தலையும், கொழுப்பும் உட்பட பலிபீடத்தில் எரிகின்ற விறகுகளின்மேல் ஆசாரியர் அடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","காணிக்கை கொண்டுவந்தவன் அதன் உள்ளுறுப்புகளையும், கால்களையும் தண்ணீரால் கழுவவேண்டும். ஆசாரியர் அவற்றையெல்லாம் கொண்டுவந்து, பலிபீடத்தின்மேல் எரிக்கவேண்டும். இது ஒரு தகன காணிக்கை; இது யெகோவாவுக்கு மகிழ்ச்சியூட்டும் நறுமணமாக, நெருப்பினால் செலுத்தப்படும் ஒரு காணிக்கை. ");
INSERT INTO tamtcv_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘யெகோவாவுக்கான தகன காணிக்கை பறவைகளானால், அவன் ஒரு புறாவையோ அல்லது ஒரு மாடப்புறாக் குஞ்சையோ செலுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","ஆசாரியர் அப்பறவையைப் பலிபீடத்திற்குக் கொண்டுவந்து, அதன் தலையைத் திருகி, அதைப் பலிபீடத்தில் எரிக்கவேண்டும். அதன் இரத்தம் பலிபீடத்தின் ஒரு பக்கத்தில் வடியவிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","அவன் அதன் இரைப்பையையும் அதற்குள் இருப்பதையும் அகற்றி, பலிபீடத்தின் கிழக்குப் பக்கத்தில் சாம்பல் இருக்கும் இடத்தில் எறியவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","அதன்பின் ஆசாரியர் அதை முற்றிலும் பிளக்காமல், சிறகுகளைப் பிடித்துக் கிழித்து, அதைப் பலிபீடத்தின் நெருப்பின் மேலுள்ள விறகுகளின்மேல் போட்டு எரிக்கவேண்டும். இது ஒரு தகன காணிக்கை, இது யெகோவாவுக்கு மகிழ்ச்சியூட்டும் நறுமணமாக, நெருப்பினால் செலுத்தப்படும் ஒரு காணிக்கை. ");
INSERT INTO tamtcv_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘யாராவது ஒருவன் யெகோவாவுக்கு ஒரு தானியக் காணிக்கையைக் கொண்டுவரும்போது, அவனுடைய காணிக்கை சிறந்த மாவினால் செய்யப்பட்டதாக இருக்கவேண்டும். அவன் அதன்மேல் எண்ணெய் ஊற்றி அதன்மேல் நறுமணத்தூளைப் போடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","அந்தக் காணிக்கையை ஆரோனின் மகன்களான ஆசாரியர்களிடம் கொண்டுவர வேண்டும். ஆசாரியர் நறுமணத்தூளுடன் சேர்த்து, சிறந்த மாவையும் எண்ணெயையும், ஒரு கைப்பிடியளவு எடுக்கவேண்டும். இதை ஒரு ஞாபகார்த்தப் பங்காக பலிபீடத்தின்மேல் எரிக்கவேண்டும். இது யெகோவாவுக்கு மகிழ்ச்சியூட்டும் நறுமணமாக, நெருப்பினால் செலுத்தப்படும் ஒரு காணிக்கை. ");
INSERT INTO tamtcv_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","மீதமுள்ள தானியக் காணிக்கை ஆரோனுக்கும் அவன் மகன்களுக்கும் சொந்தமானது; யெகோவாவுக்கு நெருப்பினால் செலுத்தப்பட்ட காணிக்கைகளில் இது ஒரு மகா பரிசுத்தமான பங்கு. ");
INSERT INTO tamtcv_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘நீங்கள் அடுப்பில் சுடப்பட்ட ஒரு தானியக் காணிக்கையைக் கொண்டுவந்தால், அது சிறந்த மாவினால் செய்யப்பட்டதாக இருக்கவேண்டும். அது புளிப்பில்லாமல் எண்ணெய் கலந்து சுடப்பட்ட அடை அப்பமாகவோ அல்லது புளிப்பில்லாமல் எண்ணெய் தடவி சுடப்பட்ட அதிரசமாகவோ இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","நீ கொடுக்கும் தானியக் காணிக்கை தட்டையான இரும்பு வலைத்தட்டியில் சுடப்படுவதானால் அது புளிப்பில்லாமல் எண்ணெய் கலந்து, சிறந்த மாவினால் செய்யப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","அதை நொறுக்கி அதன்மேல் எண்ணெய் ஊற்று. இது ஒரு தானியக் காணிக்கை. ");
INSERT INTO tamtcv_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","உனது தானியக் காணிக்கை, தட்டையான சட்டியில் சமைக்கப்பட்டதானால், அது சிறந்த மாவினாலும், எண்ணெயினாலும் செய்யப்பட்டிருக்க வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","இந்தப் பொருட்களினால் செய்யப்பட்ட தானியக் காணிக்கையை யெகோவாவிடத்தில் கொண்டுவாருங்கள்; அதை நீங்கள் ஆசாரியரிடம் கொடுக்கவேண்டும். அவன் அதைப் பலிபீடத்திற்குக் கொண்டுபோவான். ");
INSERT INTO tamtcv_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","ஆசாரியன் தானியக் காணிக்கையிலிருந்து ஞாபகார்த்தப் பங்கை தனியாக எடுத்து அதைப் பலிபீடத்தின்மேல் எரிப்பான். இது யெகோவாவுக்கு மகிழ்ச்சியூட்டும் நறுமணமாக, நெருப்பினால் செலுத்தப்படும் ஒரு காணிக்கை. ");
INSERT INTO tamtcv_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","மீதமுள்ள தானியக் காணிக்கை ஆரோனுக்கும், அவன் மகன்களுக்கும் சொந்தமானது. யெகோவாவுக்கு நெருப்பினால் செலுத்தப்படும் காணிக்கைகளில் இது ஒரு மகா பரிசுத்தமான பங்கு. ");
INSERT INTO tamtcv_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘யெகோவாவிடத்தில் நீங்கள் கொண்டுவரும் ஒவ்வொரு தானியக் காணிக்கையும் புளிப்பில்லாமல் செய்யப்படவேண்டும். ஏனெனில் யெகோவாவுக்கு நெருப்பினால் செலுத்தப்படும் காணிக்கையில், புளிப்பூட்டும் பதார்த்தத்தையோ தேனையோ எரிக்கக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","நீ அவற்றை உன் முதற்பலனின் காணிக்கையாக யெகோவாவிடம் கொண்டுவரலாம். ஆனால் அவை பலிபீடத்தின்மேல் மகிழ்ச்சியூட்டும் நறுமணமாகச் செலுத்தப்படக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","உங்கள் தானியக் காணிக்கைகளையெல்லாம் உப்பினால் சாரமாக்குங்கள். உங்கள் இறைவனின் உடன்படிக்கையின் நித்தியத்தைக் காண்பிக்க உப்பை உங்கள் தானியக் காணிக்கைகளிலிருந்து விலக்கவேண்டாம். உங்களுடைய எல்லா காணிக்கைகளோடும் உப்பைச் சேர்த்துக்கொள்ளுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘முதற்பலன்களின் தானியக் காணிக்கையை யெகோவாவிடம் கொண்டுவருவதானால், நெருப்பில் வாட்டப்பட்டு கசக்கப்பட்ட புதிய தானிய கதிர்களைச் செலுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","அதன்மேல் எண்ணெயையும், நறுமணத்தூளையும் போடுங்கள். இது ஒரு தானியக் காணிக்கை. ");
INSERT INTO tamtcv_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","ஆசாரியர் அதை நறுமணத்தூளுடன் சேர்த்து, கசக்கப்பட்ட தானியத்திலும், எண்ணெயிலும் ஞாபகார்த்தப் பங்கை யெகோவாவுக்கு நெருப்பினால் செலுத்தப்படும் காணிக்கையாக எரிப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘யாராவது ஒருவனுடைய காணிக்கை சமாதான காணிக்கையாக இருந்து, அவன் மாட்டு மந்தையிலிருந்து காளையையோ அல்லது பசுவையோ செலுத்துவதானால், அவன் யெகோவாவுக்கு முன்பாக குறைபாடற்ற ஒரு மிருகத்தை ஒப்படைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","அந்த பலி மிருகத்தின் தலையின்மேல் அவன் தன் கையை வைத்து, சபைக்கூடார வாசலில் அதை வெட்டிக் கொல்லவேண்டும். அதன் இரத்தத்தை ஆரோனின் மகன்களான ஆசாரியர்கள், பலிபீடத்தின் எல்லா பக்கங்களிலும் தெளிப்பார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","சமாதான காணிக்கையிலிருந்து நெருப்பினால் யெகோவாவுக்குச் செலுத்தப்படும் பலியாக அவன் கொண்டுவர வேண்டியன: உள்ளுறுப்புகளை மூடியுள்ள கொழுப்பு முழுவதும், அவற்றை இணைக்கிற கொழுப்பு, ");
INSERT INTO tamtcv_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","விலாவுக்குக் கீழ்ப்புறமாக இருக்கிற இரண்டு சிறுநீரகங்களும், அவற்றைச் சுற்றியுள்ள கொழுப்பும், சிறுநீரகங்களுடன் அவன் அகற்றும் ஈரலை மூடியுள்ள கொழுப்புமாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","ஆரோனின் மகன்கள் இவற்றைப் பலிபீடத்தில் எரிகிற விறகின் மேலேயுள்ள தகன காணிக்கையின்மேல் வைத்து எரிப்பார்கள். இது யெகோவாவுக்கு மகிழ்ச்சியூட்டும் நறுமணமாக, நெருப்பினால் செலுத்தப்படும் ஒரு காணிக்கை. ");
INSERT INTO tamtcv_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘அவன் ஆட்டு மந்தையிலிருந்து ஒரு மிருகத்தை சமாதான பலியாக யெகோவாவுக்குச் செலுத்துவானாகில், அவன் குறைபாடற்ற ஒரு ஆணையோ, பெண்ணையோ செலுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","அவன் ஒரு செம்மறியாட்டுக் குட்டியைச் செலுத்துவதானால், அதை யெகோவாவுக்கு முன்பாகக் கொண்டுவந்து செலுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","அவன் தன் காணிக்கை மிருகத்தின் தலையின்மேல் தன் கையை வைத்து, சபைக்கூடார வாசலில் அதை வெட்டிக் கொல்லவேண்டும். அதன் இரத்தத்தை ஆரோனின் மகன்கள் பலிபீடத்தின் எல்லா பக்கங்களிலும் தெளிப்பார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","சமாதான காணிக்கையிலிருந்து நெருப்பினால் யெகோவாவுக்குச் செலுத்தப்படும் பலியாக அவன் கொண்டுவர வேண்டியன: அதன் கொழுப்பும், முதுகெலும்புக்கு அருகே வெட்டியெடுக்கப்பட்ட கொழுப்பான வால் முழுவதும், உள்ளுறுப்புகளை மூடியிருக்கும் அல்லது இணைத்திருக்கும் கொழுப்பு முழுவதும், ");
INSERT INTO tamtcv_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","விலாவுக்குக் கீழ்ப்புறத்தின் அருகேயிருக்கிற இரண்டு சிறுநீரகங்களும், அவற்றைச் சுற்றியுள்ள கொழுப்பும், சிறுநீரகங்களுடன் அவன் அகற்றும் ஈரலை மூடியுள்ள கொழுப்புமாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","ஆசாரியன் அவற்றைப் பலிபீடத்தின்மேல் உணவாகவும், யெகோவாவுக்கு நெருப்பினால் செலுத்தப்படும் காணிக்கையாகவும் எரிப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘அவனுடைய காணிக்கை ஒரு வெள்ளாடாக இருக்குமானால், அவன் அதை யெகோவாவுக்கு முன்பாகக் கொண்டுவந்து ஒப்படைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","அவன் அதனுடைய தலைமேல் தன் கையை வைத்து, சபைக் கூடாரத்திற்கு முன்பாக அதை வெட்டிக் கொல்லவேண்டும். ஆரோனின் மகன்கள் அதன் இரத்தத்தைப் பலிபீடத்தின் எல்லா பக்கங்களிலும் தெளிப்பார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","அவன் தான் செலுத்தும் காணிக்கையிலிருந்து யெகோவாவுக்கு நெருப்பினால் செலுத்தவேண்டிய காணிக்கையாவன: உள்ளுறுப்புகளை மூடியிருக்கும் அல்லது இணைத்திருக்கும் கொழுப்பு முழுவதும், ");
INSERT INTO tamtcv_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","விலாவுக்குக் கீழ்ப்புறத்தின் அருகேயிருக்கிற இரண்டு சிறுநீரகங்களும், அவைகளைச் சுற்றியுள்ள கொழுப்பும், சிறுநீரகங்களுடன் அவன் அகற்றும் ஈரலை மூடியுள்ள கொழுப்புமேயாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","ஆசாரியன் இவைகள் எல்லாவற்றையும் பலிபீடத்தின்மேல் உணவாக எரிக்கவேண்டும். இது யெகோவாவுக்கு மகிழ்ச்சியூட்டும் நறுமணமாக, நெருப்பினால் செலுத்தப்படும் ஒரு காணிக்கை. கொழுப்பு முழுவதும் யெகோவாவுக்கே உரியது. ");
INSERT INTO tamtcv_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ ‘கொழுப்பையாவது இரத்தத்தையாவது நீங்கள் சாப்பிடக்கூடாது. நீங்கள் வாழும் இடமெல்லாம் தலைமுறைதோறும் இது உங்களுக்கு ஒரு நிரந்தர நியமமாயிருக்கும்’ என்றார்.” ");
INSERT INTO tamtcv_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","மேலும் யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“நீ இஸ்ரயேலருக்குச் சொல்லவேண்டியது என்னவென்றால், ‘யாராவது தவறுதலாகப் பாவம் செய்து, யெகோவாவினுடைய கட்டளைகளால் தடைசெய்யப்பட்ட எதையேனும் செய்தால், கடைபிடிக்க வேண்டிய விதிமுறைகளாவன: ");
INSERT INTO tamtcv_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘அபிஷேகம் பண்ணப்பட்ட தலைமை ஆசாரியன் மக்கள்மேல் குற்றம் சுமரும்படி பாவஞ்செய்தால், அவன் தான் செய்த பாவத்திற்கான பாவநிவாரண காணிக்கையாக, குறைபாடற்ற ஒரு இளங்காளையை யெகோவாவிடம் கொண்டுவர வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","அவன் அந்தக் காளையைச் சபைக்கூடார வாசலில், யெகோவா முன்னிலையில் கொண்டுவர வேண்டும். அவன் அதன் தலையின்மேல் தன் கையை வைத்து, யெகோவா முன்பாக அதை வெட்டிக் கொல்லவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","பின்பு அபிஷேகம் பண்ணப்பட்ட ஆசாரியன், பலியிடப்பட்ட காளையின் இரத்தத்தில் கொஞ்சத்தை, சபைக் கூடாரத்திற்குள் எடுத்துச்செல்ல வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","அவன் தன் விரலை இரத்தத்தில் தோய்த்து, பரிசுத்த இடத்தில் இருக்கும் திரைச்சீலைக்கு முன்பாக, யெகோவாவின் முன்னிலையில் அதில் கொஞ்சத்தை ஏழுமுறை தெளிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","பின்பு சபைக் கூடாரத்தில் யெகோவாவுக்கு முன்பாக இருக்கும் நறுமண தூபபீடத்தின் கொம்புகளின்மேல், ஆசாரியன் கொஞ்சம் இரத்தத்தைப் பூசவேண்டும். காளையின் மீதமுள்ள இரத்தத்தை, சபைக்கூடார வாசலில் இருக்கும் தகன பலிபீடத்தின் அடியிலே ஊற்றவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","அவன் பாவநிவாரண காணிக்கைக்கான காளையிலிருந்து கொழுப்பு முழுவதையும் அகற்றவேண்டும்: உள்ளுறுப்புகளை மூடியிருக்கிற அல்லது அவற்றை இணைத்திருக்கிற கொழுப்பையும், ");
INSERT INTO tamtcv_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","விலாவுக்குக் கீழ்புறத்தின் அருகேயிருக்கிற இரண்டு சிறுநீரகங்களையும், அவற்றின் மேலுள்ள கொழுப்பையும், சிறுநீரகங்களுடன் அவன் அகற்றும் ஈரலை மூடியுள்ள கொழுப்பையும் அகற்றவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","சமாதான காணிக்கையாகச் செலுத்தப்பட்ட மாட்டிலிருந்து கொழுப்பு அகற்றப்பட்டது போலவே, இதிலிருந்தும் அகற்றப்படவேண்டும். பின்பு ஆசாரியன் அவற்றைத் தகன பலிபீடத்தின்மேல் எரிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","ஆனாலும் அக்காளையின் தோலையும், இறைச்சி முழுவதையும், தலையையும், கால்களையும், உள்ளுறுப்புகளையும், குடலையும், ");
INSERT INTO tamtcv_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","அதாவது, காளையின் மீதமுள்ள பாகங்கள் யாவற்றையும் அவன் முகாமுக்கு வெளியே சம்பிரதாய முறைப்படி சுத்தமாக எண்ணப்படுகிற சாம்பல் கொட்டுகிற இடத்திற்கு கொண்டுவந்து, சாம்பல் குவியலின்மேல், விறகினால் எரிக்கப்பட்ட நெருப்பில்போட்டு எரிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘இஸ்ரயேலின் முழு சமுதாயத்தினரும் தவறுதலாகப் பாவஞ்செய்து, யெகோவாவினுடைய கட்டளைகளினால் தடைசெய்யப்பட்ட எதையாகிலும் செய்யக்கூடும். அப்படிச் செய்திருந்தால் அந்தச் செயலைக்குறித்து அச்சமுதாயத்தினர் அறியாதிருந்தாலும், அவர்கள் குற்றவாளிகளே. ");
INSERT INTO tamtcv_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","தாங்கள் செய்த பாவத்தை அவர்கள் அறியவரும்போது, சபையார் ஒரு இளங்காளையைப் பாவநிவாரண காணிக்கையாக சபைக் கூடாரத்துக்கு முன்பாகக் கொண்டுவந்து ஒப்படைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","சபையின் தலைவர்கள் யெகோவாவின் முன்னிலையில் அந்தக் காளையின் தலையின்மேல் தங்கள் கைகளை வைக்கவேண்டும். பின்பு அந்தக் காளை யெகோவாவுக்கு முன்பாக வெட்டிக் கொல்லப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","பின்பு அபிஷேகம் பண்ணப்பட்ட ஆசாரியன் காளையின் இரத்தத்தில் கொஞ்சத்தை சபைக் கூடாரத்திற்குள் எடுத்துச்செல்ல வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","ஆசாரியன் தன் விரலை இரத்தத்தில் தோய்த்து, திரைச்சீலைக்கு எதிரே யெகோவாவின் முன்னிலையில் ஏழுமுறை தெளிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","அவன் அந்த இரத்தத்தில் கொஞ்சத்தை, சபைக் கூடாரத்தில் யெகோவாவுக்கு முன்பாக இருக்கும் பலிபீடத்தின் கொம்புகளில் பூசவேண்டும். மீதமுள்ள இரத்தத்தை அவன் சபைக்கூடார வாசலில் உள்ள தகன பலிபீடத்தின் அடியில் ஊற்றிவிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","அவன் அதிலிருந்து எல்லா கொழுப்பையும் அகற்றி, அதைப் பலிபீடத்தின்மேல் எரிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","தனது பாவநிவாரண காணிக்கைக்கான காளைக்குச் செய்ததுபோலவே, இந்தக் காளைக்கும் செய்யவேண்டும். இவ்விதமாய், ஆசாரியர் அவர்களுக்காகப் பாவநிவிர்த்தி செய்யவேண்டும். அப்பொழுது அவர்கள் மன்னிக்கப்படுவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","பின்பு காளையின் மீதமுள்ள பாகங்களை முகாமுக்கு வெளியே கொண்டுபோய், அங்கே ஆசாரியனின் பாவநிவாரணப் பலியைச் சுட்டெரித்ததுபோல் இதையும் எரிக்கவேண்டும். இதுவே சமுதாயத்தினருக்கான பாவநிவாரண காணிக்கை. ");
INSERT INTO tamtcv_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘ஒரு தலைவன் தவறுதலாகப் பாவஞ்செய்து, தன் இறைவனாகிய யெகோவாவின் கட்டளைகளினால் தடைசெய்யப்பட்ட எதையாவது செய்தால், அவன் குற்றவாளி. ");
INSERT INTO tamtcv_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","அவன் செய்த பாவத்தை அவனுக்குத் தெரிவிக்கும்போது, அவன் குறைபாடற்ற ஒரு வெள்ளாட்டுக்கடாவை தன் காணிக்கையாகக் கொண்டுவர வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","அவன் அந்த வெள்ளாட்டுக்கடாவின் தலையில் தன் கையை வைத்து, யெகோவா முன்னிலையில் தகன காணிக்கை வெட்டப்படும் இடத்தில் அதை வெட்டிக் கொல்லவேண்டும். இது ஒரு பாவநிவாரண காணிக்கை. ");
INSERT INTO tamtcv_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","பின்பு ஆசாரியன், பாவநிவாரண காணிக்கையின் இரத்தத்தில் கொஞ்சத்தைத் தன் விரலினால் எடுத்து, அதைத் தகன காணிக்கை பலிபீடத்தின் கொம்புகளின்மேல் பூசவேண்டும். மீதமுள்ள இரத்தத்தை, அந்தப் பலிபீடத்தின் அடியில் ஊற்றிவிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","சமாதான காணிக்கையின் கொழுப்பை எரித்ததுபோலவே, கொழுப்பு முழுவதையும் அவன் பீடத்தின்மேல் எரிக்கவேண்டும். இவ்விதமாய், ஆசாரியன் அந்த மனிதனின் பாவத்திற்கான பாவநிவிர்த்தியைச் செய்யவேண்டும். அவனும் மன்னிக்கப்படுவான். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘சமுதாய அங்கத்தினரில் ஒருவன் தவறுதலாகப் பாவம் செய்து, யெகோவாவின் கட்டளைகளினால் தடைசெய்யப்பட்ட எதையாவது செய்தால், அவன் குற்றவாளி. ");
INSERT INTO tamtcv_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","அவன் செய்த பாவத்தை அவனுக்குத் தெரிவிக்கும்போது, அவன் தான் செய்த பாவத்திற்கான தன் காணிக்கையாக குறைபாடற்ற ஒரு வெள்ளாட்டு பெண்குட்டியைக் கொண்டுவர வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","அவன் தன் கையைப் பாவநிவாரண காணிக்கை மிருகத்தின் தலைமேல் வைத்து, தகன காணிக்கைக்கான இடத்தில் அதை வெட்டிக் கொல்லவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","பின்பு ஆசாரியன் இரத்தத்தில் கொஞ்சத்தைத் தன் விரலினால் எடுத்து, அதைத் தகன காணிக்கை பலிபீடத்தின் கொம்புகளின்மேல் பூசவேண்டும். மீதமுள்ள இரத்தத்தைப் பலிபீடத்தின் அடியில் ஊற்றிவிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","சமாதான காணிக்கையின் கொழுப்பு அகற்றப்பட்டது போலவே, அதன் கொழுப்பு முழுவதையும் அகற்றவேண்டும். ஆசாரியன் அதைப் பலிபீடத்தில் யெகோவாவுக்கு மகிழ்ச்சியூட்டும் நறுமணமாக எரிக்கவேண்டும். இவ்விதம் ஆசாரியன் அவனுக்காக பாவநிவிர்த்தி செய்வான். அவனும் மன்னிக்கப்படுவான். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘அவன் பாவநிவாரண காணிக்கையாக ஒரு செம்மறியாட்டுக் குட்டியைக் கொண்டுவருவானேயாகில், அவன் குறைபாடற்ற பெண்ணாட்டுக்குட்டியையே கொண்டுவர வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","அவன் அதன் தலைமேல் தன் கையை வைத்து, தகன காணிக்கை வெட்டப்படும் இடத்தில் பாவநிவாரண காணிக்கையாக அதை வெட்டிக் கொல்லவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","பின்பு ஆசாரியன், பாவநிவாரண காணிக்கையின் இரத்தத்தில் கொஞ்சத்தைத் தன் விரலினால் எடுத்து, தகன பலிபீடத்தின் கொம்புகளின்மேல் அதைப் பூசவேண்டும். மீதமுள்ள இரத்தத்தைப் பலிபீடத்தின் அடியில் ஊற்றிவிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","சமாதான பலியின் செம்மறியாட்டுக் குட்டியிலிருந்து கொழுப்பு அகற்றப்பட்டது போலவே, கொழுப்பு முழுவதையும் அவன் அகற்றவேண்டும். ஆசாரியன் அதைப் பலிபீடத்தில் நெருப்பினால் யெகோவாவுக்கு செலுத்தப்படும் காணிக்கைகளின்மேல் வைத்து எரிக்கவேண்டும். இவ்விதமாய், ஆசாரியன் அவன் செய்த பாவத்திற்காக, அவனுக்காகப் பாவநிவிர்த்தி செய்யவேண்டும். அவனும் மன்னிக்கப்படுவான். ");
INSERT INTO tamtcv_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘ஒருவன் தான் கண்டிருந்த அல்லது அறிந்திருந்த ஏதாவது ஒன்றைப்பற்றி சாட்சி சொல்லும்படியாக பிறப்பிக்கப்பட்ட பகிரங்கக் கட்டளையைக் கேள்விப்பட்டிருந்தும், அவன் அதைப் சொல்லத்தவறி பாவம்செய்தால், அவன் அதற்கு பொறுப்பேற்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘அசுத்தமான காட்டு மிருகங்கள், அசுத்தமான வீட்டு மிருகங்கள், தரையில் வாழும் அசுத்தமான பிராணிகள் ஆகியவற்றின் உயிரற்ற உடல்களை தொடுகிறவன் எவனும் அதை அறியாதிருந்தாலும், அவன் அசுத்தமாகி, குற்றவாளியாகிறான். ");
INSERT INTO tamtcv_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","அல்லது எந்த அசுத்தத்தினாலாவது தீட்டுப்பட்ட ஒரு மனிதனை ஒருவன் தொட்டால், அவன் அதை அறியாதிருந்தாலும், அவன் அதை அறிந்துகொள்ளுகிறபோது குற்றவாளியாவான். ");
INSERT INTO tamtcv_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","ஒருவன் கவலையீனமாய், வாயில் வந்தபடி முன்யோசனையின்றி, நன்மையான அல்லது தீமையான எதையாவது செய்வதாக சத்தியம் செய்திருந்தால், அவன் அதை அறியாதிருந்தாலும், அவன் அதை அறிந்துகொள்ளுகிறபோது குற்றவாளியாவான். ");
INSERT INTO tamtcv_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","யாராவது ஒருவன் இவ்விதமான ஒன்றில் குற்றமுள்ளவனாகும்போது, தான் எவ்வகையில் பாவம் செய்தான் என்பதை அவன் அறிக்கை செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","அவன், தான் செய்த பாவத்திற்குத் தண்டனையாக மந்தையிலிருந்து செம்மறியாட்டு பெண்குட்டியையோ அல்லது வெள்ளாட்டு பெண்குட்டியையோ பாவநிவாரண காணிக்கையாக யெகோவாவிடத்தில் கொண்டுவர வேண்டும். ஆசாரியன் அவனுக்காக அவனுடைய பாவத்திற்காக பாவநிவிர்த்தி செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘அவன் ஒரு செம்மறியாட்டுக் குட்டியைக் கொடுக்க இயலாதவனாயிருந்தால், அவன் இரண்டு புறாக்களையோ அல்லது இரண்டு மாடப்புறாக் குஞ்சுகளையோ தன் பாவத்திற்கான தண்டனையாக யெகோவாவிடத்தில் கொண்டுவர வேண்டும். அவற்றில் ஒன்றைப் பாவநிவாரண காணிக்கையாகவும், இன்னொன்றைத் தகன காணிக்கையாகவும் கொண்டுவர வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","அவன் அவைகளை ஆசாரியனிடம் கொண்டுவர வேண்டும். ஆசாரியன் முதலாவது, ஒன்றைப் பாவநிவாரண காணிக்கையாகச் செலுத்தவேண்டும். அவன் அதன் கழுத்திலிருந்து தலையைத் திருகவேண்டும். அதை முழுமையாக துண்டித்துப்போடக் கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","பாவநிவாரண காணிக்கையின் இரத்தத்தில் கொஞ்சத்தைப் பலிபீடத்தின் ஒரு பக்கத்தில் தெளிக்கவேண்டும். மீதமுள்ள இரத்தத்தைப் பலிபீடத்தின் அடியில் வடியவிடவேண்டும். இது பாவநிவாரண காணிக்கை. ");
INSERT INTO tamtcv_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","விதிக்கப்பட்ட விதிமுறைப்படியே, ஆசாரியன் மற்றப் பறவையைத் தகன காணிக்கையாகச் செலுத்தி, அவன் செய்த பாவத்திற்காக அவனுக்காகப் பாவநிவிர்த்தி செய்யவேண்டும். அவனும் மன்னிக்கப்படுவான். ");
INSERT INTO tamtcv_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘ஆனாலும், இரண்டு புறாக்களையாவது, இரண்டு மாடப்புறாக் குஞ்சுகளையாவது கொண்டுவர அவன் இயலாதவனானால், அவன் தன் பாவத்திற்கான காணிக்கையாக, எப்பா அளவான சிறந்த மாவில் பத்தில் ஒரு பங்கை பாவநிவாரண காணிக்கையாகக் கொண்டுவர வேண்டும். அது பாவநிவாரண காணிக்கையாக இருப்பதால், அந்த மாவின்மேல் எண்ணெயை ஊற்றவோ, நறுமணத்தூளைப் போடவோ கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","அவன் அதை ஆசாரியனிடம் கொண்டுவர வேண்டும். ஆசாரியன் அந்த மாவிலிருந்து கைப்பிடி அளவுள்ள மாவை ஞாபகார்த்தப் பங்காக எடுத்து, நெருப்பினால் யெகோவாவுக்குச் செலுத்தப்படும் காணிக்கைகளின்மேல் அதை எரிக்கவேண்டும். இது பாவநிவாரண காணிக்கை. ");
INSERT INTO tamtcv_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","இவ்விதமாய் ஆசாரியன் அவன் செய்த இந்தப் பாவங்களில் எதற்கானாலும் அவனுக்காகப் பாவநிவிர்த்தி செய்யவேண்டும். அப்பொழுது அவனும் மன்னிக்கப்படுவான். மீதமுள்ள காணிக்கை தானியக் காணிக்கையைப்போலவே ஆசாரியனுக்கு உரியதாகும்.’ ” ");
INSERT INTO tamtcv_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","மேலும் யெகோவா மோசேயிடம் சொன்னதாவது, ");
INSERT INTO tamtcv_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“ஒருவன் யெகோவாவுக்குரிய பரிசுத்தமானவைகளில் தவறிழைத்து தெரியாமல் பாவம் செய்கிறபோது, அவன் அதற்கான தண்டனையாக ஆட்டு மந்தையிலிருந்து ஒரு செம்மறியாட்டுக் கடாவை யெகோவாவிடத்தில் கொண்டுவர வேண்டும். அது குறைபாடற்றதாகவும், பரிசுத்த இடத்தின், ‘சேக்கல்’ நிறையின்படி வெள்ளியில் சரியான மதிப்பு உடையதாகவும் இருக்கவேண்டும். இது ஒரு குற்றநிவாரண காணிக்கை. ");
INSERT INTO tamtcv_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","பரிசுத்தமானவைகளின் காரியத்தில் அவன் செய்த தவறுக்கு அவன் ஈடுசெய்ய வேண்டும். அவன் அதன் மதிப்புடன், ஐந்தில் ஒரு பங்கையும் சேர்த்து, அதையெல்லாம் ஆசாரியனிடம் செலுத்தவேண்டும். குற்றநிவாரண காணிக்கையான அந்த செம்மறியாட்டுக் கடாவை, ஆசாரியன் அவனுக்காகப் பாவநிவிர்த்தி செய்வான். அவனும் மன்னிக்கப்படுவான். ");
INSERT INTO tamtcv_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“ஒருவன் பாவம் செய்து, யெகோவாவின் கட்டளைகளினால் தடைசெய்யப்பட்ட எதையாவது செய்தால், அவன் அதை அறியாதிருந்தாலும்கூட, அவன் குற்றவாளியாகிறான். அவன் அதற்குக் கணக்குக் கொடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","அவன் குற்றநிவாரண காணிக்கையாக, ஆட்டு மந்தையிலுள்ள ஒரு செம்மறியாட்டுக் கடாவை ஆசாரியனிடம் கொண்டுவர வேண்டும். அது குறைபாடற்றதாகவும், தகுந்த மதிப்பு உடையதாகவும் இருக்கவேண்டும். இவ்விதமாய் அவன் தவறுதலாக செய்த பிழைக்காக, ஆசாரியன் அவனுக்காக பாவநிவிர்த்தி செய்வான். அவனும் மன்னிக்கப்படுவான். ");
INSERT INTO tamtcv_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","இது ஒரு குற்றநிவாரண காணிக்கை. அவன் யெகோவாவுக்கு விரோதமாக பிழை செய்தபடியால் குற்றவாளியாய் இருந்தான்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","யெகோவா மோசேயிடம் சொன்னதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“யாராவது ஒருவன் தன்னிடம் ஒப்படைக்கப்பட்ட பொருளையோ அல்லது அவனுடைய கவனிப்பில் விடப்பட்ட பொருளையோ வஞ்சிப்பதினாலாவது, திருடுவதினாலாவது, அவனை ஏமாற்றுவதினாலாவது தன் அயலானுக்கு எதிராகப் பாவஞ்செய்து, யெகோவாவுக்கு உண்மையற்றவனாயிருக்கக்கூடும். ");
INSERT INTO tamtcv_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","அல்லது அவன் தொலைந்த பொருட்களைக் கண்டெடுத்தும் அதைக் குறித்துப் பொய் சொல்வதினாலாவது, பொய்யாய் சத்தியம் செய்வதினாலாவது, மக்கள் செய்யக்கூடிய இப்படியான எந்த ஒரு பாவத்தையும் அவன் செய்வதினால் யெகோவாவுக்கு உண்மையற்றவனாய் இருக்கக்கூடும். ");
INSERT INTO tamtcv_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","இவ்வாறு அவன் பாவங்களைச் செய்து குற்றவாளியாகிறான். அவன் தான் திருடியதையோ அல்லது பலவந்தமாய் எடுத்துக்கொண்டதையோ அல்லது தன்னிடத்தில் ஒப்படைக்கப்பட்டதையோ அல்லது தான் கண்டெடுத்த தொலைந்த பொருளையோ ");
INSERT INTO tamtcv_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","அல்லது அவன் பொய்யாய் சத்தியம் செய்துகொண்ட எதையுமோ அவன் கட்டாயமாக திருப்பிக் கொடுக்கவேண்டும். அதன் மதிப்பில் ஐந்தில் ஒரு பங்கையும், அதனுடன் சேர்த்துத் தன் குற்றநிவாரண பலியைச் செலுத்தும் நாளில், அதன் சொந்தக்காரனுக்கு அது முழுவதையும் ஒப்படைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","தனக்கான தண்டனையாக தன் குற்றநிவாரண காணிக்கையை ஆசாரியனிடத்தில், அதாவது யெகோவாவிடத்தில் கொண்டுவர வேண்டும். மந்தையிலிருந்து எடுக்கப்பட்ட அந்தச் செம்மறியாட்டுக் கடா உரிய மதிப்பு உடையதாகவும் குறைபாடு அற்றதாகவும் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","இவ்விதம் ஆசாரியன் யெகோவாவுக்கு முன்பாக அவனுக்காகப் பாவநிவிர்த்தி செய்யவேண்டும். அப்பொழுது எவைகளைச் செய்து அவன் குற்றவாளியானானோ அவைகளினின்று அவன் மன்னிக்கப்படுவான்.” ");
INSERT INTO tamtcv_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","மீண்டும் யெகோவா மோசேயிடம் சொன்னதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“நீ ஆரோனுக்கும் அவன் மகன்களுக்கும் இந்தக் கட்டளையைக் கொடு. ‘தகன காணிக்கைக்குரிய ஒழுங்குமுறைகள் இவையே: தகன காணிக்கை இரவு முழுவதும் மறுநாள் காலைவரை பலிபீடத்தின் அடுப்பின்மேல் இருக்கவேண்டும். பலிபீடத்தின்மேல் நெருப்பு எரிந்துகொண்டே இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","ஆசாரியன் மென்பட்டு உள் உடைகளைத் தன் உடலோடு ஒட்டிக்கொள்ளும்படி உடுத்தி, அதன் மேலாக தன் மென்பட்டு உடைகளையும் உடுத்திக்கொள்ளவேண்டும். அதன்பின் பலிபீடத்தின் மேலுள்ள நெருப்பினால் எரிந்துபோன தகன காணிக்கையின் சாம்பலை அகற்றி, பலிபீடத்தின் பக்கத்தில் அதை வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","அதன்பின் ஆசாரியன் அந்த உடைகளைக் கழற்றி, மற்ற உடைகளை உடுத்திக்கொண்டு, சாம்பலை எடுத்து முகாமுக்கு வெளியே, சம்பிரதாய முறைப்படி சுத்தமாக எண்ணப்பட்ட இடத்திற்குக் கொண்டுசெல்ல வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","பலிபீடத்திலுள்ள நெருப்பு எரிந்துகொண்டே இருக்கவேண்டும். அது அணைந்துபோகக் கூடாது, ஆசாரியன் ஒவ்வொரு காலையிலும் இன்னும் விறகுகளைப் போட்டு, தகன காணிக்கையை நெருப்பின்மேல் ஒழுங்குபடுத்தி, அதன்மேல் சமாதான காணிக்கையின் கொழுப்பைப் போட்டு எரிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","பலிபீடத்தின்மேல் நெருப்பு தொடர்ந்து எரிந்துகொண்டே இருக்கவேண்டும். அது அணைந்துபோகக் கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘தானியக் காணிக்கையின் ஒழுங்குமுறைகள் இவையே: ஆரோனின் மகன்கள் யெகோவாவிடம் பலிபீடத்துக்கு முன்பாக அதைக் கொண்டுவர வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","ஆசாரியன் தானியக் காணிக்கையிலுள்ள நறுமணத்தூளுடன் சேர்த்து, ஒரு கைப்பிடி சிறந்த மாவையும் எண்ணெயையும் எடுக்கவேண்டும். அந்த ஞாபகார்த்தப் பங்கை யெகோவாவுக்கு மகிழ்ச்சியூட்டும் நறுமணமாக பலிபீடத்தின்மேல் எரிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","அதன் மீதியானதை ஆரோனும் அவன் மகன்களும் சாப்பிடவேண்டும். ஆனால் அதை ஒரு பரிசுத்த இடத்திலே, புளிப்பில்லாததாகச் சாப்பிடவேண்டும். அவர்கள் அதைச் சபைக்கூடார முற்றத்தில் சாப்பிடவேண்டும்; ");
INSERT INTO tamtcv_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","ஆனால் அது புளிப்பு சேர்த்துத் தயாரிக்கப்படக் கூடாது. எனக்கு நெருப்பினால் செலுத்தப்பட்ட காணிக்கைகளில், அவர்களுடைய பங்காக நான் அதை அவர்களுக்குக் கொடுக்கிறேன். பாவநிவாரண காணிக்கையைப் போலவும், குற்றநிவாரண காணிக்கையைப் போலவும் இதுவும் மகா பரிசுத்தமானது. ");
INSERT INTO tamtcv_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","அதை ஆரோனின் சந்ததிகளில் ஆண்மகன் எவனும் சாப்பிடலாம். தலைமுறைதோறும் நெருப்பினால் யெகோவாவுக்குச் செலுத்தப்படுகிற காணிக்கைகளில், இதுவே அவனுடைய நிரந்தரமான பங்காக இருக்கும். இவற்றைத் தொடும் எதுவும் பரிசுத்தமாகும்’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","யெகோவா தொடர்ந்து மோசேயிடம் சொன்னதாவது, ");
INSERT INTO tamtcv_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“ஆரோனும் அவன் மகன்களும் தாங்கள் அபிஷேகம் பண்ணப்படுகிற நாளிலே யெகோவாவுக்குக் கொண்டுவரவேண்டிய காணிக்கை இதுவே: ஒரு எப்பா அளவான சிறந்த மாவில் பத்தில் ஒரு பங்கை தானியக் காணிக்கையாக காலையில் அரைப்பங்கையும், மாலையில் அரைப்பங்கையும் கொண்டுவர வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","அதை எண்ணெயுடன் சேர்த்து, இரும்பு வலைத்தட்டியில் தயாரிக்க வேண்டும். நன்றாகப் பிசைந்து தயாரித்த அதைத் துண்டுகளாக நொறுக்கி, யெகோவாவுக்கு மகிழ்ச்சியூட்டும் நறுமணமான தானியக் காணிக்கையாகச் செலுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","ஆரோனுக்குப்பின் அவனுடைய இடத்தில் அபிஷேகம் பண்ணப்பட்ட ஆசாரியனாக வரப்போகும் அவனுடைய மகனே அதைத் தயாரிக்க வேண்டும். இது யெகோவாவினுடைய நிரந்தரமான பங்கு. அது முழுவதும் எரிக்கப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","ஆசாரியனின் எல்லா தானியக் காணிக்கையும், முழுவதுமாய் எரிக்கப்படவேண்டும். அதை ஒருபோதும் சாப்பிடக்கூடாது.” ");
INSERT INTO tamtcv_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“நீ ஆரோனுக்கும், அவன் மகன்களுக்கும் சொல்லவேண்டியதாவது: பாவநிவாரண காணிக்கைக்கான ஒழுங்குமுறைகள் இவையே: தகன காணிக்கைக்கான மிருகம் வெட்டிக் கொல்லப்படும் இடத்திலேயே பாவநிவாரண காணிக்கைக்கான மிருகமும் யெகோவாவுக்கு முன்பாக வெட்டிக் கொல்லப்படவேண்டும். இது மகா பரிசுத்தமானது. ");
INSERT INTO tamtcv_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","அதைச் செலுத்தும் ஆசாரியன் அதைச் சாப்பிடவேண்டும். அதை சபைக்கூடார முற்றத்தில் உள்ள ஒரு பரிசுத்த இடத்திலேயே சாப்பிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","காணிக்கை இறைச்சியைத் தொடுகிற எதுவும் பரிசுத்தமாகும். அதன் இரத்தம் ஏதேனும் உடையில் தெறித்திருந்தால், அதை நீங்கள் பரிசுத்த இடத்திலே கழுவவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","அது சமைக்கப்பட்ட மண்சட்டி உடைக்கப்பட வேண்டும். ஆனால் அது வெண்கலப் பானையில் சமைக்கப்பட்டால், அந்தப் பானையை நன்கு தேய்த்து தண்ணீரால் அலசவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","ஆசாரியர்களின் குடும்பத்திலுள்ள எந்த ஆணும் அதைச் சாப்பிடலாம். அது மகா பரிசுத்தமானது. ");
INSERT INTO tamtcv_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","ஆனால் எந்தவொரு பாவநிவாரண காணிக்கையின் இரத்தமும், பரிசுத்த இடத்தில் பாவநிவிர்த்தி செய்யப்படுவதற்காக சபைக் கூடாரத்திற்குள் கொண்டுவரப்பட்டால், அக்காணிக்கையைச் சாப்பிடக்கூடாது; அது எரிக்கப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘குற்றநிவாரண காணிக்கைக்கான ஒழுங்குமுறைகள் இவையே: அது மகா பரிசுத்தமானது. ");
INSERT INTO tamtcv_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","தகன காணிக்கை மிருகம் வெட்டிக் கொல்லப்படும் இடத்திலேயே, குற்றநிவாரண காணிக்கைக்கான மிருகமும் வெட்டிக் கொல்லப்படவேண்டும். அதன் இரத்தம் பலிபீடத்தின் எல்லா பக்கங்களிலும் தெளிக்கப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","அதன் கொழுப்பு முழுவதும் காணிக்கையாகச் செலுத்தப்பட வேண்டும். கொழுப்பான வாலும், உள்ளுறுப்புகளை மூடியுள்ள கொழுப்பும் பலியாகச் செலுத்தப்பட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","விலாவுக்குக் கீழ்ப்புறமாக இருக்கிற இரண்டு சிறுநீரகங்களும், அவற்றைச் சுற்றியுள்ள கொழுப்பும், சிறுநீரகங்களுடன் அகற்றப்பட வேண்டிய ஈரலை மூடியுள்ள கொழுப்பும் பலியாகச் செலுத்தப்பட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","ஆசாரியன் அவற்றை யெகோவாவுக்கு நெருப்பினால் செலுத்தப்படும் காணிக்கையாக பலிபீடத்தின்மேல் எரிக்கவேண்டும். இது குற்றநிவாரண காணிக்கை. ");
INSERT INTO tamtcv_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","ஆசாரியனின் குடும்பத்திலுள்ள எந்த ஆணும் அதைச் சாப்பிடலாம். ஆனால் அதை ஒரு பரிசுத்த இடத்திலேயே சாப்பிடவேண்டும்; அது மகா பரிசுத்தமானது. ");
INSERT INTO tamtcv_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“ ‘பாவநிவாரண காணிக்கையும், குற்றநிவாரண காணிக்கையும் ஒரே விதிமுறைப்படியே செய்யப்படவேண்டும். அவற்றைக் கொண்டு பாவநிவிர்த்தி செய்யும் ஆசாரியனுக்கே அவை சொந்தமாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","யாருக்காகிலும் தகன காணிக்கையைச் செலுத்தும் ஆசாரியன் அதன் தோலை தனக்காக எடுத்துக்கொள்ளலாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","அடுப்பில் தயாரிக்கப்பட்டதும், சட்டியில் சமைக்கப்பட்டதும், இரும்பு வலைத்தட்டியில் சுடப்பட்டதுமான தானியக் காணிக்கைகள் எல்லாம், அவற்றைச் செலுத்தும் ஆசாரியருக்கே உரியன. ");
INSERT INTO tamtcv_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","எண்ணெய் சேர்க்கப்பட்டதாயினும், சேர்க்கப்படாத உலர்ந்ததாயினும், எல்லா தானியக் காணிக்கையும் ஆரோனின் மகன்கள் எல்லோருக்கும் சமமாக உரியதாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘ஒருவன் யெகோவாவுக்குக் கொடுக்கும் சமாதான காணிக்கையின் ஒழுங்குமுறைகள் இவையே: ");
INSERT INTO tamtcv_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“ ‘அவன் தன் நன்றியுணர்வை வெளிப்படுத்த அதைச் செலுத்துவானாகில், இந்த நன்றிக் காணிக்கையுடன், புளிப்பில்லாமல் எண்ணெயில் பிசைந்து செய்யப்பட்ட அடை அப்பங்களையும், புளிப்பில்லாமல் செய்யப்பட்டு எண்ணெய் தடவப்பட்ட அதிரசங்களையும், சிறந்த மாவுடன் எண்ணெய் கலந்து நன்கு பிசைந்து சுடப்பட்ட அடைகளையும் அவன் செலுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","நன்றி செலுத்துவதற்கான தன் சமாதான காணிக்கையுடன், புளிப்பூட்டிச் சுடப்பட்ட அடை அப்பங்களையும் அவன் காணிக்கையாகச் செலுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","அவன் ஒவ்வொரு வகையான அப்பத்திலும் ஒவ்வொன்றை யெகோவாவுக்கு அன்பளிப்பான காணிக்கையாகக் கொண்டுவர வேண்டும். சமாதான காணிக்கையின் இரத்தத்தைத் தெளிக்கும் ஆசாரியருக்கே இது உரியது. ");
INSERT INTO tamtcv_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","நன்றி செலுத்தும் சமாதான காணிக்கையின் இறைச்சியானது அது செலுத்தப்பட்ட நாளிலேயே, சாப்பிடப்பட வேண்டும். அவன் அதில் ஒன்றையும் காலைவரை விட்டுவைக்கக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘எனினும், அவனுடைய காணிக்கை ஒரு நேர்த்திக்கடனாகவோ அல்லது சுயவிருப்பக் காணிக்கையாகவோ இருந்தால், அவன் பலிசெலுத்தும் நாளிலேயே அதைச் சாப்பிடவேண்டும். ஆனால் ஏதாவது மீதமிருந்தால் அடுத்தநாள் சாப்பிடலாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","ஆனாலும், மூன்றாம் நாள்வரை விட்டுவைக்கப்பட்ட பலியின் இறைச்சி எதுவும் எரிக்கப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","சமாதான காணிக்கையின் இறைச்சி எதையும் மூன்றாம் நாளில் சாப்பிட்டால், அது ஏற்றுக்கொள்ளப்படமாட்டாது. அது காணிக்கை செலுத்துபவருக்கு பலனளிக்காது. ஏனெனில், அது அசுத்தமானது. அதில் எதையாவது சாப்பிடுபவன் அக்குற்றத்திற்குப் பொறுப்பாளியாவான். ");
INSERT INTO tamtcv_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘சம்பிரதாய முறைப்படி அசுத்தமாக எண்ணப்படும் எதிலாவது இறைச்சி பட்டுவிட்டால், அந்த இறைச்சியைச் சாப்பிடக்கூடாது. அது எரிக்கப்படவேண்டும். மற்ற இறைச்சியைப் பொறுத்தமட்டில், அதை சம்பிரதாய முறைப்படி சுத்தமாய் இருப்பவன் எவனும் சாப்பிடலாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ஆனால் யெகோவாவுக்குச் சொந்தமான சமாதான காணிக்கையின் இறைச்சி எதையும், அசுத்தமாயிருக்கிற யாராவது சாப்பிட்டால், அவன் தன் மக்களிலிருந்து அகற்றப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","மனித அசுத்தத்தையோ அல்லது அசுத்த மிருகத்தையோ அல்லது அசுத்தமும் அருவருப்புமான ஏதாகிலும் பொருளையோ, இவ்வாறான அசுத்தமான எதையாவது ஒருவன் தொட்டு, பின்பு யெகோவாவுக்குரிய சமாதான காணிக்கையின் இறைச்சியைச் சாப்பிட்டால், அவன் தன் மக்களிலிருந்து அகற்றப்படவேண்டும் என்றார்.’ ” ");
INSERT INTO tamtcv_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“நீ இஸ்ரயேலருக்குச் சொல்லவேண்டியதாவது, மாடுகளின் கொழுப்பையோ, செம்மறியாட்டின் கொழுப்பையோ, வெள்ளாட்டின் கொழுப்பையோ சாப்பிடவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","செத்துக் கிடக்கக் காணப்பட்ட ஒரு மிருகத்தின் கொழுப்பையோ அல்லது காட்டு மிருகங்களால் கிழித்துப்போடப்பட்ட மிருகத்தின் கொழுப்பையோ வேறு ஏதாவது தேவைக்குப் பயன்படுத்தலாம். ஆனால் நீங்கள் அதைச் சாப்பிடக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","யெகோவாவுக்கு நெருப்பினால் செலுத்தப்படும் காணிக்கைக்கான மிருகத்தின் கொழுப்பைச் சாப்பிடும் எவனும், தன் மக்களிலிருந்து அகற்றப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","நீங்கள் எங்கே வாழ்ந்தாலும், பறவையின் இரத்தத்தையோ, மிருகத்தின் இரத்தத்தையோ சாப்பிடக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","யாராவது இரத்தத்தைச் சாப்பிட்டால், அவன் தன் மக்களிலிருந்து அகற்றப்படவேண்டும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“நீ இஸ்ரயேலருக்கு சொல்லவேண்டியதாவது: யெகோவாவுக்குச் சமாதான காணிக்கை கொண்டுவரும் எவனும் அதன் ஒரு பங்கைத் தனது பலியாக யெகோவாவுக்குக் கொண்டுவர வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","நெருப்பினால் யெகோவாவுக்குச் செலுத்தப்படும் காணிக்கையைத் தன் சொந்தக் கைகளினாலேயே கொண்டுவர வேண்டும். அதன் நெஞ்சுப்பகுதியுடன் அதன் கொழுப்பையும் கொண்டுவந்து, நெஞ்சுப்பகுதியை யெகோவாவுக்குமுன் அசைவாட்டும் காணிக்கையாக, அசைவாட்டவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","ஆசாரியன் கொழுப்பை பலிபீடத்தின்மேல் எரிக்கவேண்டும். ஆனால் நெஞ்சுப்பகுதியோ ஆரோனுக்கும், அவன் மகன்களுக்கும் உரியது. ");
INSERT INTO tamtcv_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","நீங்கள் சமாதான காணிக்கை மிருகத்தின் வலது தொடையை ஆசாரியனுக்கு அன்பளிப்பாகக் கொடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","சமாதான காணிக்கை மிருகத்தின் இரத்தத்தையும், கொழுப்பையும் செலுத்தும் ஆரோனின் மகன், மிருகத்தின் வலது தொடையை தனது பங்காக எடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","இஸ்ரயேலரின் சமாதான காணிக்கையிலிருந்து அசைவாட்டப்பட்ட நெஞ்சுப்பகுதியையும், செலுத்தப்பட்ட தொடையையும் நான் எடுத்துக்கொண்டேன். நான் அவைகளை இஸ்ரயேலரிடமிருந்து ஆசாரியன் ஆரோனுக்கும், அவன் மகன்களுக்கும் நிரந்தரமான பங்காகக் கொடுத்திருக்கிறேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","நெருப்பினால் யெகோவாவுக்குச் செலுத்தப்பட்ட காணிக்கையின் இப்பங்கு, ஆரோனுக்கும் அவன் மகன்களுக்கும் ஒதுக்கப்பட்டது. அவர்கள் ஆசாரியர்களாக யெகோவாவுக்குப் பணிசெய்ய ஒப்புக்கொடுக்கப்பட்ட நாளிலேயே, இப்பங்கு அவர்களுக்காக ஒதுக்கப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","அவர்கள் அபிஷேகம் பண்ணப்பட்ட அந்த நாளிலே, “தலைமுறைதோறும் இஸ்ரயேலர் தங்களுடைய ஒழுங்கான பங்காக இதை ஆசாரியருக்குக் கொடுக்கவேண்டும்” என யெகோவா கட்டளையிட்டிருந்தார். ");
INSERT INTO tamtcv_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","தகன காணிக்கை, தானியக் காணிக்கை, பாவநிவாரண காணிக்கை, குற்றநிவாரண காணிக்கை, அர்ப்பணிப்பு காணிக்கை, சமாதான காணிக்கை ஆகியவற்றிற்கான ஒழுங்குமுறைகள் இவையே. ");
INSERT INTO tamtcv_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","இஸ்ரயேலர் யெகோவாவுக்குக் காணிக்கைகள் கொண்டுவர வேண்டுமென, யெகோவா சீனாய் பாலைவனத்தில் கட்டளையிட்ட நாளிலே, அவர் சீனாய் மலையில் இந்த ஒழுங்குமுறைகளை மோசேக்குக் கொடுத்தார். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","யெகோவா மோசேயிடம் சொன்னதாவது, ");
INSERT INTO tamtcv_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“நீ ஆரோனையும் அவன் மகன்களையும் அவர்களுடைய உடைகளுடனும், அபிஷேக எண்ணெயுடனும் கொண்டுவா. அத்துடன் பாவநிவாரண காணிக்கைக்கான காளையையும், இரண்டு செம்மறியாட்டுக் கடாக்களையும், புளிப்பில்லாத அப்பங்களுள்ள கூடையையும் கொண்டுவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","முழு சபையையும் சபைக்கூடார வாசலில் கூடிவரச்செய்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","யெகோவா தனக்குக் கட்டளையிட்டபடியே மோசே செய்தான். சபையாரும் சபைக்கூடார வாசலில் ஒன்றுகூடினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","மோசே சபையைப் பார்த்து, “யெகோவா செய்யும்படி கட்டளையிட்டது இதுவே” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","பின்பு மோசே ஆரோனையும் அவன் மகன்களையும் சபைக்கு முன்பாக அழைத்துவந்து, அவர்களைத் தண்ணீரால் கழுவினான். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","அவன் ஆரோனுக்கு உள்ளுடையை உடுத்தி, இடுப்பில் இடைப்பட்டியைக் கட்டி, மேல் அங்கியை உடுத்தி, ஏபோத்தையும் போட்டான். திறமையாக, அழகாகப் பின்னப்பட்ட இடைப்பட்டியினால் ஏபோத்தை அவனுக்குக் கட்டினான். இவ்வாறாக, அது அவன்மேல் கட்டப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","பின்பு மார்பு அணியை அவனுக்குப் போட்டு, அந்த மார்பு அணியிலே ஊரீம், தும்மீம் என்பவைகளையும் வைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","பின்பு அவன் தலைப்பாகையை ஆரோனின் தலையில் வைத்து, அதன் முன்பக்கத்தில் பரிசுத்த மகுடமான தங்கப்பட்டியை வைத்தான். இவற்றை யெகோவா மோசேக்குக் கட்டளையிட்டபடியே அவன் செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","பின்பு மோசே, அபிஷேக எண்ணெயை எடுத்து இறைசமுகக் கூடாரத்தையும், அதனுள் இருந்த எல்லாவற்றையும் அபிஷேகித்து அர்ப்பணம் செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","அந்த எண்ணெயில் கொஞ்சம் எடுத்து, பலிபீடத்தின்மேல் ஏழுமுறை தெளித்து, பலிபீடத்தையும், அதிலுள்ள பாத்திரங்களையும், தொட்டியையும், அதன் காலையும் அர்ப்பணிக்கும்படி அபிஷேகித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","பின்பு ஆரோனின் தலையில் அபிஷேக எண்ணெயை ஊற்றி, அவனை அர்ப்பணம் செய்வதற்காக அபிஷேகித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","மோசே ஆரோனின் மகன்களை முன்னால் கொண்டுவந்து, உள்ளுடையை உடுத்தி, இடைப்பட்டியைக் கட்டி, குல்லாக்களையும் அணிவித்தான். இவற்றை மோசே யெகோவா தனக்குக் கட்டளையிட்டபடியே செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","அதன்பின் பாவநிவாரண காணிக்கையாக, ஒரு காளையை அவன் கொண்டுவந்து ஒப்படைத்தான். ஆரோனும் அவனுடைய மகன்களும் தங்கள் கைகளைக் காளையின் தலைமேல் வைத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","மோசே அந்தக் காளையை வெட்டிக்கொன்று, அதன் இரத்தத்தில் கொஞ்சத்தைத் தன் விரலில் தொட்டு, பலிபீடத்தைச் சுத்திகரிப்பதற்காக, பலிபீடத்தின் கொம்புகளின்மேல் பூசினான். மீதமுள்ள இரத்தத்தைப் பலிபீடத்தின் அடியில் ஊற்றினான். இவ்விதமாக பலிபீடத்திற்காக பாவநிவிர்த்தி செய்து அதை அர்ப்பணம் செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","மேலும் மோசே, உள்ளுறுப்புகளைச் சுற்றியிருந்த கொழுப்பு முழுவதையும், ஈரலை மூடியிருந்த கொழுப்பையும், இரண்டு சிறுநீரகங்களையும், அதில் இருந்த கொழுப்பையும் எடுத்து அவற்றைப் பலிபீடத்தின்மேல் எரித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","ஆனால் மோசே வெட்டப்பட்ட காளையை தோலுடனும், அதன் இறைச்சியுடனும், அதன் குடல்களுடனும் முகாமுக்கு வெளியே எரித்தான். இவற்றை யெகோவா கட்டளையிட்டபடியே செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","அதன்பின், தகன காணிக்கைக்கான செம்மறியாட்டுக் கடாவைக் கொண்டுவந்து ஒப்படைத்தான். ஆரோனும் அவன் மகன்களும் அதன் தலைமேல் தங்கள் கைகளை வைத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","அப்பொழுது அந்தக்கடா கொல்லப்பட்டது, மோசே அதன் இரத்தத்தைப் பலிபீடத்தின் எல்லா பக்கங்களிலும் தெளித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","மோசே அந்தக்கடாவை துண்டங்களாக வெட்டி தலையையும், துண்டங்களையும் கொழுப்பையும் எரித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","அவன் அதன் உள்ளுறுப்புகளையும், கால்களையும் தண்ணீரினால் கழுவி, முழு கடாவையும் பலிபீடத்தின்மேல் தகன காணிக்கையாக எரித்தான். இது யெகோவாவுக்கு மகிழ்ச்சியூட்டும் நறுமணமாக நெருப்பினால் எரிக்கப்படும் ஒரு காணிக்கையாக இருந்தது. இவற்றை மோசே, யெகோவா தனக்குக் கட்டளையிட்டபடியே செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","பின்பு மோசே அர்ப்பணிப்புக்கான மற்ற செம்மறியாட்டுக் கடாவைக் கொண்டுவந்து ஒப்படைத்தான். ஆரோனும் அவன் மகன்களும் அதன் தலையின்மேல் தங்கள் கைகளை வைத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","மோசே அந்த செம்மறியாட்டுக் கடாவை வெட்டிக்கொன்று, அதன் இரத்தத்தில் கொஞ்சம் எடுத்து, ஆரோனின் வலது காது மடலிலும், வலதுகை பெருவிரலிலும், வலதுகால் பெருவிரலிலும் பூசினான். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","ஆரோனுடைய மகன்களையும் மோசே முன்பாக அழைத்துவந்து, இரத்தத்தில் கொஞ்சத்தை எடுத்து அவர்களின் வலது காது மடல்களிலும், வலதுகை பெருவிரல்களிலும், வலதுகால் பெருவிரல்களிலும் பூசினான். பின்பு இரத்தத்தைப் பலிபீடத்தின் எல்லா பக்கங்களிலும் தெளித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","மோசே கொழுப்பையும், கொழுத்த வாலையும், உள்ளுறுப்புகளைச் சுற்றியுள்ள கொழுப்பு முழுவதையும், ஈரலை மூடியுள்ள கொழுப்பையும், இரண்டு சிறுநீரகங்களையும் அவற்றின் கொழுப்பையும் வலது தொடையையும் எடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","பின்பு அவன் யெகோவா முன்வைக்கப்பட்ட புளிப்பில்லாத அப்பங்களுள்ள கூடையிலிருந்து, ஒரு அடை அப்பத்தையும், எண்ணெய் சேர்த்துச் சுடப்பட்ட ஒரு அடை அப்பத்தையும், ஒரு அதிரசத்தையும் எடுத்து, அக்கொழுப்புகளின்மேலும், வலது தொடையின்மேலும் வைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","அவை எல்லாவற்றையும் ஆரோனின் கைகளிலும், அவனுடைய மகன்களின் கைகளிலும் கொடுத்து யெகோவாவுக்கு முன்பாக அசைவாட்டும் காணிக்கையாக அசைவாட்டினான். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","மோசே அவைகளை அவர்களின் கைகளிலிருந்து எடுத்து, பலிபீடத்தில் இருந்த காணிக்கையின்மேல் அதை அர்ப்பணிப்பு காணிக்கையாக எரித்தான். அது யெகோவாவுக்கு மகிழ்ச்சியூட்டும் நறுமணமாக நெருப்பினால் செலுத்தப்பட்ட ஒரு காணிக்கையாக இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","அர்ப்பணிப்பு காணிக்கைக்கான செம்மறியாட்டுக் கடாவில், மோசே தன் பங்கான நெஞ்சுப்பகுதியை எடுத்து, அதை யெகோவாவுக்கு முன்பாக அசைவாட்டும் காணிக்கையாக அசைவாட்டினான். இவற்றை யெகோவா தனக்குக் கட்டளையிட்டபடியே செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","பின்பு மோசே, அபிஷேக எண்ணெயில் கொஞ்சமும், பலிபீடத்திலிருந்து சிறிது இரத்தத்தையும் எடுத்து, ஆரோனின்மேலும், அவன் உடையின்மேலும், அவனுடைய மகன்கள்மேலும், அவர்களுடைய உடைகள்மேலும் தெளித்தான். இவ்வாறு ஆரோனையும், அவனுடைய உடைகளையும், அவன் மகன்களையும், அவர்களுடைய உடைகளையும் அர்ப்பணம் செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","பின்பு மோசே, ஆரோனுக்கும் அவன் மகன்களுக்கும் சொன்னதாவது, “ஆரோனும், அவன் மகன்களும் சாப்பிடவேண்டும் என நான் கட்டளையிட்டபடி நீங்கள் இறைச்சியைச் சபைக்கூடார வாசலில் சமைத்து, அங்கே அர்ப்பணிப்பு காணிக்கை கூடையிலுள்ள அப்பத்துடன் சாப்பிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","மீதமுள்ள இறைச்சியையும், அப்பத்தையும் எரித்துவிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","உங்கள் அர்ப்பணிப்பு நாட்கள் முடியும்வரை ஏழுநாட்களுக்கு சபைக்கூடார வாசலைவிட்டுப் போகாதீர்கள். ஏனென்றால், உங்கள் நியமனம் ஏழு நாட்கள்வரை நீடிக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","இன்று செய்யப்பட்டிருப்பது உங்களுக்காகப் பாவநிவிர்த்தி செய்யும்படி யெகோவாவினால் கட்டளையிடப்பட்டதாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","நீங்கள் இந்த ஏழுநாட்களும் இரவும் பகலும் சபைக்கூடார வாசலில் தங்கியிருந்து, யெகோவா கேட்டுக்கொள்கிறபடி செய்யுங்கள். அப்பொழுது நீங்கள் சாகமாட்டீர்கள். ஏனெனில், இதுதான் எனக்குக் கட்டளையாகக் கொடுக்கப்பட்டது.” ");
INSERT INTO tamtcv_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","இப்படியாக யெகோவா மோசேயின் மூலம் கட்டளையிட்ட அனைத்தையும் ஆரோனும் அவன் மகன்களும் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","மோசே எட்டாம் நாளில் ஆரோனையும் அவன் மகன்களையும், இஸ்ரயேலின் சபைத்தலைவர்களையும் அழைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","அவன் ஆரோனிடம், “நீ உன்னுடைய பாவநிவாரண காணிக்கைக்காக ஒரு குறைபாடற்ற இளங்காளையையும், உன்னுடைய தகன காணிக்கைக்காக குறைபாடற்ற ஒரு ஆட்டுக் கடாவையும் எடுத்து, அவற்றை யெகோவாவுக்கு முன்பாக கொண்டுவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","பின்பு இஸ்ரயேலரிடம் நீ சொல்லவேண்டியதாவது, ‘பாவநிவாரண காணிக்கைக்காக வெள்ளாட்டுக்கடாவையும், தகன காணிக்கைக்காக கன்றுக்குட்டியையும், ஒரு செம்மறியாட்டுக் குட்டியையும் எடுத்துக்கொள்ளுங்கள்; அவை இரண்டும் குறைபாடற்றதாயும், ஒரு வயதுடையதாயும் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","சமாதான காணிக்கைக்காக ஒரு மாட்டையும், ஒரு செம்மறியாட்டுக் கடாவையும், எண்ணெய் கலந்து பிசைந்த தானியக் காணிக்கையுடன் யெகோவாவுக்கு முன்பாகச் செலுத்தும்படி கொண்டுவாருங்கள். ஏனெனில் இன்று யெகோவா உங்களுக்குக் காட்சியளிப்பார்’ என்று சொல்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","அவர்கள் மோசே கட்டளையிட்ட பொருட்களை சபைக் கூடாரத்திற்கு முன்பாகக் கொண்டுவந்தார்கள். சபையார் அனைவரும் நெருங்கிவந்து, யெகோவா முன்னிலையில் நின்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","அப்பொழுது மோசே, “யெகோவாவின் மகிமை உங்களுக்குத் தோன்றும்படி, நீங்கள் செய்யவேண்டுமென யெகோவா கட்டளையிட்டது இதுவே” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","மோசே ஆரோனிடம், “நீ பலிபீடத்தின் அருகில் வந்து பாவநிவாரண காணிக்கையையும், தகன காணிக்கையையும் பலியிட்டு, உனக்காகவும், மக்களுக்காகவும் பாவநிவிர்த்தி செய்யவேண்டும். மக்களுக்கான காணிக்கையைப் பலியிட்டு, அவர்களுக்காகவும் பாவநிவிர்த்தி செய்யவேண்டும். யெகோவா கட்டளையிட்டபடியே இவற்றைச் செய்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","அப்படியே ஆரோன் பலிபீடத்திற்கு வந்து, தனது பாவநிவாரண காணிக்கையாக கன்றுக்குட்டியை வெட்டிக்கொன்றான். ");
INSERT INTO tamtcv_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","ஆரோனுடைய மகன்கள் இரத்தத்தை அவனிடத்தில் கொண்டுவந்தார்கள். ஆரோன் தன் விரலை இரத்தத்தில் தோய்த்து, பலிபீடத்தின் கொம்புகளில் பூசினான். மீதமுள்ள இரத்தத்தைப் பலிபீடத்தின் அடியில் ஊற்றினான். ");
INSERT INTO tamtcv_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","பாவநிவாரண காணிக்கை மிருகத்தின் கொழுப்பையும், சிறுநீரகங்களையும், ஈரலை மூடியுள்ள கொழுப்பையும் பலிபீடத்தில் அவன் எரித்தான். யெகோவா மோசேக்குக் கட்டளையிட்டபடியே இது செய்யப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","இறைச்சியையும், தோலையும் முகாமுக்கு வெளியே எரித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","அதன்பின் தகன காணிக்கை மிருகத்தை அவன் வெட்டிக்கொன்றான். ஆரோனின் மகன்கள் இரத்தத்தை அவனிடம் கொடுத்தார்கள். அவன் அதை பலிபீடத்தின் எல்லா பக்கங்களிலும் தெளித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","அவர்கள் தகன காணிக்கையை, தலை உட்பட துண்டம் துண்டமாக அவனிடம் கொடுத்தார்கள். அவன் அவைகளைப் பலிபீடத்தின்மேல் எரித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","அவன் உள்ளுறுப்புகளையும், கால்களையும் கழுவி அவற்றைப் பலிபீடத்தில் இருந்த தகன காணிக்கையின்மேல் வைத்து எரித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","பின்பு ஆரோன், மக்களுக்கான காணிக்கையைக் கொண்டுவந்தான். அவன் மக்களுக்கான பாவநிவாரண காணிக்கையான வெள்ளாட்டை எடுத்து, அதை வெட்டிக்கொன்று, முன்பு பலியிட்ட மிருகத்தைப்போலவே பாவநிவாரண காணிக்கையாக அதைச் செலுத்தினான். ");
INSERT INTO tamtcv_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","அவன் தகனகாணிக்கையைக் கொண்டுவந்து, விதிக்கப்பட்டிருந்த முறைப்படியே அதைச் செலுத்தினான். ");
INSERT INTO tamtcv_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","அத்துடன் அவன் தானியக் காணிக்கையையும் கொண்டுவந்து, அதில் ஒரு கைநிறைய எடுத்து, காலையில் செலுத்திய தகன காணிக்கையுடன் அதையும் பலிபீடத்தின்மேல் எரித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","பின்பு அவன் மக்களுக்கான சமாதான காணிக்கையாக, மாட்டையும், செம்மறியாட்டுக் கடாவையும் வெட்டிக்கொன்றான். ஆரோனின் மகன்கள் இரத்தத்தை அவனிடம் கொடுத்தார்கள். அவன் அதைப் பலிபீடத்தின் எல்லா பக்கங்களிலும் தெளித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","ஆரோனின் மகன்கள் மாட்டினுடைய, செம்மறியாட்டுக் கடாவினுடைய கொழுப்பான பாகங்களை, அதாவது கொழுத்த வால், கொழுப்புப்படை, சிறுநீரகங்கள், ஈரலை மூடியுள்ள கொழுப்பு ஆகியவற்றை எடுத்து, ");
INSERT INTO tamtcv_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","மிருகங்களின் நெஞ்சுப்பகுதியில் வைத்தார்கள். பின்பு ஆரோன் அந்தக் கொழுப்பை பலிபீடத்தின்மேல் எரித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","நெஞ்சுப்பகுதிகளையும், வலது தொடையையும் ஆரோன், மோசே கட்டளையிட்டபடி யெகோவாவுக்கு முன்பாக அசைவாட்டும் காணிக்கையாக அசைவாட்டினான். ");
INSERT INTO tamtcv_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","அதன்பின் ஆரோன் மக்களை நோக்கி தன் கைகளை உயர்த்தி, அவர்களை ஆசீர்வதித்தான். பாவநிவாரண காணிக்கையையும், தகன காணிக்கையையும், சமாதான காணிக்கையையும் பலியிட்டு முடித்துக் கீழே இறங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","அதன்பின் மோசேயும் ஆரோனும் சபைக் கூடாரத்திற்குள்ளே போனார்கள். அவர்கள் வெளியே வந்து, மக்களை ஆசீர்வதித்தபொழுது, யெகோவாவினுடைய மகிமை மக்கள் அனைவருக்கும் முன் தோன்றியது. ");
INSERT INTO tamtcv_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","யெகோவாவிடமிருந்து நெருப்பு புறப்பட்டு, பலிபீடத்தின்மேல் இருந்த தகன காணிக்கையையும், கொழுப்பான பாகங்களையும் பட்சித்தது. மக்கள் அனைவரும் அதைக் கண்டபோது, மகிழ்ச்சியினால் ஆர்ப்பரித்து, முகங்குப்புற விழுந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","ஆரோனின் மகன்களான நாதாபும், அபியூவும் தங்கள் தூபகிண்ணங்களில் நெருப்பைப்போட்டு, நறுமணத்தூளை அதில் போட்டார்கள். அவர்கள் யெகோவாவின் கட்டளைக்கு முரண்பாடாக, அங்கீகரிக்கப்படாத நெருப்பை யெகோவாவுக்கு முன்பாகச் செலுத்தினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","உடனே யெகோவாவின் முன்னிருந்து நெருப்பு புறப்பட்டுவந்து அவர்களை எரித்துப்போட்டது. அவர்கள் யெகோவாவுக்கு முன்பாகச் செத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","அப்பொழுது மோசே ஆரோனிடம் சொன்னது: “ ‘என்னை நெருங்கி வருகிறவர்களிடையே நான் என்னைப் பரிசுத்தராகக் காண்பிப்பேன். எல்லா மக்களின் பார்வையிலும் நான் மகிமைப்படுவேன்’ என்று யெகோவா சொன்னபோது அவர் குறிப்பிட்டது இதுவே.” ஆரோனோ ஒன்றும் பேசாமல் இருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","பின்பு மோசே ஆரோனின் சிறிய தகப்பனான ஊசியேலின் மகன்களான மீசயேலையும், எல்சாபானையும் அழைத்து, “இங்கே வாருங்கள்; உங்கள் சகோதரர்களின் உடல்களை முகாமுக்கு வெளியே பரிசுத்த இடத்திலிருந்து கொண்டுபோங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","மோசே உத்தரவிட்டபடியே அவர்கள் வந்து, இறந்தவர்களை அவர்களின் அங்கிகளுடன் தூக்கி, முகாமுக்கு வெளியே கொண்டுபோனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","மோசே ஆரோனிடமும், அவனுடைய மகன்களான எலெயாசார், இத்தாமார் என்பவர்களிடமும், “நீங்கள் துக்கம் அநுசரிப்பதற்காக உங்கள் தலைமயிரைக் குலையவிடவும், உடைகளைக் கிழித்துக்கொள்ளவும் வேண்டாம். அப்படிச் செய்தால் நீங்கள் சாவீர்கள். யெகோவா முழு சமுதாயத்தின்மேலும் கோபங்கொள்வார். ஆனால் உங்கள் உறவினரான இஸ்ரயேல் குடும்பத்தார் அனைவரும், யெகோவா நெருப்பினால் அழித்தவர்களுக்காக துக்கம் அநுசரிக்கலாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","நீங்கள் சபைக்கூடார வாசலைவிட்டுப் புறப்படவேண்டாம். அப்படிப் புறப்பட்டால் யெகோவாவினுடைய அபிஷேக எண்ணெய் உங்கள்மேல் இருப்பதால் நீங்கள் சாவீர்கள்” என்றான். மோசே சொன்னபடியே அவர்கள் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","யெகோவா ஆரோனுக்குச் சொன்னதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“நீயும் உன் மகன்களும் சபைக் கூடாரத்திற்குள் போகும்பொழுது, திராட்சை இரசத்தையோ அல்லது வேறு மதுபானத்தையோ குடிக்கவேண்டாம். குடித்தால் நீங்கள் சாவீர்கள். தலைமுறைதோறும் இது ஒரு நிரந்தரமான நியமம். ");
INSERT INTO tamtcv_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","நீ பரிசுத்தமானதற்கும், சாதாரணமானதற்கும் இடையில் வித்தியாசத்தைக் காட்டவேண்டும். சுத்தத்திற்கும், அசுத்தத்திற்கும் இடையிலும் வித்தியாசத்தைக் காட்டவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","அத்துடன் யெகோவா மோசேயின் மூலமாக இஸ்ரயேலருக்குக் கொடுத்திருக்கிற விதிமுறைகள் எல்லாவற்றையும் நீ அவர்களுக்குப் போதிக்கவேண்டும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","அப்பொழுது மோசே, ஆரோனிடமும் அவனுடைய தப்பியிருந்த மகன்களான எலெயாசாரிடமும், இத்தாமாரிடமும் சொன்னதாவது: “யெகோவாவுக்கு நெருப்பினால் செலுத்தப்பட்ட காணிக்கையிலிருந்து மீதியாய் விடப்பட்ட தானியக் காணிக்கையை எடுத்துக்கொள்ளுங்கள். அதைப் பலிபீடத்திற்கு அருகே புளிப்பில்லாமல் தயாரித்துச் சாப்பிடுங்கள். ஏனெனில், அது மகா பரிசுத்தமானது. ");
INSERT INTO tamtcv_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","யெகோவாவுக்கு நெருப்பினால் செலுத்தப்படுகிற காணிக்கைகளில் இது உனக்கும் உன் மகன்களுக்கும் உரிய பங்காக இருப்பதால், அதை ஒரு பரிசுத்த இடத்தில் சாப்பிடுங்கள். இப்படியாக நான் கட்டளை பெற்றிருக்கிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","ஆனாலும் அசைவாட்டப்பட்ட நெஞ்சுப்பகுதியையும், படைக்கப்பட்ட தொடையையும் நீயும் உன் மகன்களும், மகள்களும் சாப்பிடலாம். அவற்றை சம்பிரதாய முறைப்படி சுத்தமானது என எண்ணப்பட்ட இடத்திலேயே சாப்பிடலாம். இஸ்ரயேலரின் சமாதான காணிக்கைகளில் ஏற்படுத்தப்பட்ட உங்கள் பங்காக அவை உனக்கும், உன் பிள்ளைகளுக்கும் கொடுக்கப்பட்டிருக்கின்றன. ");
INSERT INTO tamtcv_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","படைக்கப்பட்ட தொடையும், அசைவாட்டப்பட்ட நெஞ்சுப்பகுதியும் நெருப்பினால் செலுத்தப்பட்ட காணிக்கைகளின் கொழுப்பான பாகங்களுடன், அசைவாட்டும் காணிக்கையாக யெகோவாவுக்கு முன்பாக அசைவாட்டும்படி கொண்டுவர வேண்டும். யெகோவா கட்டளையிட்டபடியே இது உனக்கும், உன் பிள்ளைகளுக்கும் நிரந்தர பங்காயிருக்கும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","பிறகு பாவநிவாரண காணிக்கைக்கான வெள்ளாட்டுக் கடாவைப்பற்றி மோசே தேடிப்பார்த்தபோது, அது ஏற்கெனவே எரிக்கப்பட்டிருப்பதைக் கண்டான். அப்பொழுது அவன் ஆரோனின் மற்ற மகன்களான எலெயாசார்மேலும், இத்தாமார்மேலும் கோபங்கொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","ஆகவே மோசே அவர்களிடம், “நீங்கள் ஏன் பாவநிவாரண காணிக்கையை பரிசுத்த இடத்தில் சாப்பிடவில்லை? அது மகா பரிசுத்தமானது. யெகோவா முன்னிலையில் இஸ்ரயேல் சமுதாயத்தினருக்காக பாவநிவர்த்தி செய்வதின்மூலம் அவர்களுடைய குற்றத்தை நீக்கும்படி அது உங்களுக்குக் கொடுக்கப்பட்டதே. ");
INSERT INTO tamtcv_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","அதன் இரத்தம் பரிசுத்த இடத்திற்குள் கொண்டுவரப்படாதபடியால், உங்களுக்கு நான் கட்டளையிட்டபடி நீங்கள் அந்த வெள்ளாட்டைப் பரிசுத்த இடத்தில் சாப்பிட்டிருக்க வேண்டுமே” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","அதற்கு ஆரோன் மோசேயிடம், “இன்றுதானே அவர்கள் பாவநிவாரண காணிக்கையையும், தகன காணிக்கையையும் யெகோவா முன்னிலையில் பலியிட்டார்கள். ஆனாலும் இப்படிப்பட்ட வேதனையான நிகழ்வுகள் எனக்கு நேரிட்டிருக்கிறதே. இன்று நான் பாவநிவாரண காணிக்கையைச் சாப்பிட்டிருந்தால் யெகோவா மகிழ்ச்சியடைந்திருப்பாரோ?” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","அந்தப் பதில் மோசேக்குத் திருப்தியைக் கொடுத்தது. ");
INSERT INTO tamtcv_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","மீண்டும் யெகோவா மோசேயுடனும் ஆரோனுடனும் பேசி, ");
INSERT INTO tamtcv_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“நீங்கள் இஸ்ரயேலருக்குச் சொல்லவேண்டியதாவது: ‘பூமியில் வாழும் எல்லா மிருகங்களுக்குள்ளும் நீங்கள் சாப்பிடக் கூடியவைகள் இவையே: ");
INSERT INTO tamtcv_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","முழுவதும் விரிந்த குளம்புடையதும், இரையை அசைப்போடுகிறதுமான எந்த மிருகத்தையும் நீங்கள் சாப்பிடலாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“ ‘சில மிருகங்கள் இரையை அசைப்போடுகிறதாய் மட்டும் இருக்கின்றன, சில மிருகங்கள் விரிந்த குளம்பு உடையதாய் மட்டும் இருக்கின்றன, அவற்றை நீங்கள் சாப்பிடக்கூடாது. ஒட்டகம் இரையை அசைப்போடுகிறதாய் இருந்தாலும் அதற்கு விரிந்த குளம்பு இல்லாதபடியால், அது சம்பிரதாய முறைப்படி உங்களுக்கு அசுத்தமாயிருக்கிறது. ");
INSERT INTO tamtcv_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","அதேபோல், குழிமுயலானது இரையை அசைப்போடுகிறதாய் இருந்தாலும், விரிந்த குளம்பு இல்லாதபடியால், அதுவும் உங்களுக்கு அசுத்தமாயிருக்கிறது. ");
INSERT INTO tamtcv_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","முயல் இரையை அசைப்போடுகிறதாய் இருந்தும், விரிந்த குளம்பு இல்லாதபடியால், அதுவும் உங்களுக்கு அசுத்தமாயிருக்கிறது. ");
INSERT INTO tamtcv_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","பன்றி, விரிந்த குளம்புடையதாயிருந்தாலும், இரையை அசைப்போடுகிறதில்லை; ஆதலால் அதுவும் உங்களுக்கு அசுத்தமாயிருக்கிறது. ");
INSERT INTO tamtcv_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","நீங்கள் அவற்றின் இறைச்சியைச் சாப்பிடக்கூடாது. அவற்றின் பிணங்களைத் தொடவும் கூடாது. அவை உங்களுக்கு அசுத்தமாயிருக்கிறது. ");
INSERT INTO tamtcv_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘கடல்களும் ஆறுகளுமாகிய தண்ணீரில் வாழ்கின்ற உயிரினங்களில் துடுப்புகளும் செதில்களும் உள்ள எதையும் நீங்கள் சாப்பிடலாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","கடல்களும் ஆறுகளுமாகிய தண்ணீரில் வாழ்கின்ற உயிரினங்களுக்குள்ளே துடுப்புகளும், செதில்களும் இல்லாத எல்லாவற்றையும் நீங்கள் அருவருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","நீங்கள் அவற்றை அருவருக்கவேண்டும் என்பதால், அவைகளின் இறைச்சியைச் சாப்பிடக்கூடாது. அவற்றின் செத்த உடல்களை நீங்கள் அருவருத்து ஒதுக்க வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","நீரில் வாழ்கின்ற துடுப்புகளும், செதில்களும் இல்லாதவையெல்லாம் உங்களுக்கு அருவருப்பாய் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘பறவைகளில் நீங்கள் அருவருக்கவேண்டியதும், அருவருப்பாய் இருப்பதால் சாப்பிடாமல் தவிர்க்கவேண்டியதும் இவையே: கழுகு, கருடன், கடலூராஞ்சி, ");
INSERT INTO tamtcv_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","செம்பருந்து எல்லாவித வல்லூறுகள், ");
INSERT INTO tamtcv_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","எல்லாவித அண்டங்காக்கைகள், ");
INSERT INTO tamtcv_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","கொம்பு ஆந்தை, அலறும் ஆந்தை, கடல் பறவை, எல்லாவித பருந்துகள், ");
INSERT INTO tamtcv_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","சின்ன ஆந்தை, நீர்க்காகம், பெரிய ஆந்தை, ");
INSERT INTO tamtcv_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","வெள்ளை ஆந்தை, பாலைவன ஆந்தை, மீன்கொத்தும் பெரிய பறவை, ");
INSERT INTO tamtcv_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","கொக்கு, எல்லாவித நாரைகள், புழுக்கொத்தி, வவ்வால் என்பனவாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘பறக்கும் பூச்சி வகைகளில் நான்கு கால்களால் நடக்கின்ற யாவும் உங்களுக்கு அருவருப்பானவை. ");
INSERT INTO tamtcv_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","ஆனாலும், நீங்கள் சாப்பிடக்கூடிய நான்கு கால்களால் நடக்கும் சிறகுகளை உடைய சில உயிரினங்களாவன: தரையில் தத்திப்பாயக்கூடிய இணைக்கப்பட்ட கால்களையுடையவை. ");
INSERT INTO tamtcv_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","இவைகளில் நீங்கள், எல்லா வகையான வெட்டுக்கிளிகளையும், பச்சை வெட்டுக்கிளிகளையும், சில்வண்டுகளையும், விட்டில்களையும் சாப்பிடலாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","ஆனால் நான்கு கால்களையும், சிறகுகளையும் உடைய மற்ற எல்லா பூச்சிகளையும் நீங்கள் அருவருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘இவற்றால் உங்களை நீங்கள் அசுத்தமாக்கிக்கொள்வீர்கள். அவற்றின் செத்த உடல்களைத் தொடுகிற எவனும் மாலைவரை அசுத்தமாயிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","அவற்றின் செத்த உடலை எடுக்கிறவன் எவனும் தன் உடைகளைக் கழுவவேண்டும். மாலைவரை அவன் அசுத்தமாயிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ ‘விரிந்த குளம்பு இல்லாததும், இரையை அசைப்போடுகிறதுமான மிருகங்கள் உங்களுக்கு அசுத்தமாயிருக்கும். அவற்றின் பிணங்களைத் தொடுகிற எவனும் அசுத்தமாயிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","நான்கு கால்களால் நடக்கும் எல்லா மிருகங்களுக்குள்ளும் பாதங்களை ஊன்றி நடக்கின்ற யாவும் உங்களுக்கு அசுத்தமாயிருக்க வேண்டும்; அவற்றின் பிணங்களைத் தொடுகிறவன் எவனும் மாலைவரை அசுத்தமாயிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","அவற்றின் பிணங்களைத் தூக்குகிற எவனும், தன் உடைகளைக் கழுவவேண்டும். அவன் மாலைவரை அசுத்தமாயிருப்பான். அவை உங்களுக்கு அசுத்தமானவை. ");
INSERT INTO tamtcv_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘தரையில் ஊரும்பிராணிகளில் உங்களுக்கு அசுத்தமானவைகள்: மரநாய், எலி, எல்லா வகையான ஓணான், ");
INSERT INTO tamtcv_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","மரப்பல்லி, உடும்பு, பல்லி, அரணை, பச்சோந்தி என்பனவாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","ஊரும்பிராணிகளில் இவையெல்லாம் உங்களுக்கு அசுத்தமானவை. இவற்றிலும் செத்ததைத் தொடுகிறவன் சூரியன் மறையும்வரை அசுத்தமாயிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","அவைகளில் ஒன்று செத்து மரப்பாத்திரத்திலோ, உடையிலோ, தோலிலோ, சாக்குப்பையிலோ, பயன்படுத்தும் எந்தப் பாத்திரத்திலாவது விழுந்தால், அவை அசுத்தமாயிருக்கும். அதை தண்ணீரில் போடுங்கள். அவை மாலைவரை அசுத்தமாயிருக்கும். பின்பு அவை சுத்தமாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","அவைகளில் ஒன்று மண்பானைக்குள் விழுமானால், அதிலுள்ள அனைத்தும் அசுத்தமாகும். எனவே அந்தப் பானையை உடைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","அந்தப் பானையிலிருந்து தண்ணீர் எந்த உணவிலாவது பட்டுவிட்டால், அது அசுத்தமாயிருக்கும். அதிலிருந்து குடிக்கும் எந்தவித பானமும் அசுத்தமாயிருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","செத்தவைகளில் ஒன்று எதில் விழுந்தாலும், அது அசுத்தமாயிருக்கும். அடுப்பிலோ அல்லது சட்டியிலோ விழுந்தால், அவை உடைக்கப்பட வேண்டும். அவை அசுத்தமானவை. அவற்றை நீங்கள் அசுத்தமாக எண்ணவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","ஆனாலும் செத்ததில் ஒன்று நீரூற்றிலோ, தண்ணீர் சேமிக்கும் தொட்டியிலோ விழுந்தால், அவை அசுத்தமாகாது. அதற்குள் செத்துக்கிடப்பதைத் தொடுகிறவன் அசுத்தமாய் இருக்கிறான். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","அது விதைக்க வைத்திருக்கும் எந்தத் தானியத்தின்மேல் விழுந்தாலும் சுத்தமாகவே இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","ஆகிலும் தானியம் நீரில் நனைக்கப்பட்டிருக்கும் போது, அது தானியத்தின்மேல் விழுந்தால், அந்தத் தானியம் உங்களுக்கு அசுத்தமாயிருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘ஆகிலும், நீங்கள் சாப்பிடும்படி அனுமதிக்கப்பட்ட ஒரு மிருகம் இறந்தால், அந்தப் பிணத்தைத் தொடுகிறவன் எவனும் மாலைவரை அசுத்தமாய் இருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","அந்தப் பிணத்தில் எதையாவது சாப்பிடுகிறவன் எவனும் தன் உடைகளைக் கழுவவேண்டும். மாலைவரை அவன் அசுத்தமாயிருப்பான். அந்தப் பிணத்தைத் தூக்குகிற எவனும் தன் உடைகளைக் கழுவவேண்டும். அவன் மாலைவரை அசுத்தமாயிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘தரையில் ஊரும்பிராணிகள் எல்லாம் அருவருப்பானவை. அவற்றைச் சாப்பிடக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","தரையில் ஊரும் எந்தப் பிராணியும் அவை வயிற்றினால் ஊர்ந்தாலும் சரி, நான்கு கால்களாலோ அநேகம் கால்களாலோ நகர்ந்தாலும் சரி, அவை அருவருப்பானவையே. அவற்றை நீங்கள் சாப்பிடக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","இந்த ஊரும்பிராணிகளில் எதினாலாவது நீங்கள் உங்களை அசுத்தப்படுத்திக்கொள்ள வேண்டாம். நீங்கள் அவற்றினாலாவது அவற்றின் மூலமாவது உங்களை அசுத்தமாக்கிக்கொள்ள வேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","நான் உங்கள் இறைவனாகிய யெகோவா. ஆகையால் நீங்கள் உங்களை அர்ப்பணம் செய்து பரிசுத்தராயிருங்கள். ஏனெனில், நான் பரிசுத்தர். நீங்கள் தரையில் ஊர்ந்து திரியும் எந்தவித பிராணியாலும் உங்களை அசுத்தப்படுத்திக்கொள்ள வேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","உங்கள் இறைவனாயிருக்கும்படி உங்களை எகிப்திலிருந்து வெளியே கொண்டுவந்த யெகோவா நானே. ஆகையால் நீங்கள் பரிசுத்தமாயிருங்கள். ஏனெனில், நான் பரிசுத்தர். ");
INSERT INTO tamtcv_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘மிருகங்கள், பறவைகள், நீரில் நீந்தும் உயிரினங்கள், தரையில் ஊரும்பிராணிகள் அனைத்தையும் பற்றிய ஒழுங்குவிதிகள் இவையே. ");
INSERT INTO tamtcv_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","அசுத்தமானதற்கும், சுத்தமானதற்கும் இடையில் வித்தியாசத்தைக் காட்டவும், சாப்பிடக்கூடிய உயிரினங்களுக்கும், சாப்பிடக்கூடாத உயிரினங்களுக்கும் இடையில் உள்ள வேறுபாட்டை காட்டவுமே இந்த ஒழுங்குவிதிகள் கொடுக்கப்பட்டுள்ளன’ என்றார்.” ");
INSERT INTO tamtcv_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“நீ இஸ்ரயேலருக்குச் சொல்லவேண்டியதாவது, ‘ஒரு பெண் கர்ப்பவதியாகி ஒரு ஆண்குழந்தையைப் பெற்றால், மாதவிடாய் நாட்களில் அசுத்தமாயிருப்பதுபோல், அவள் சம்பிரதாய முறைப்படி ஏழுநாட்களுக்கு அசுத்தமாய் இருப்பாள். ");
INSERT INTO tamtcv_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","எட்டாம் நாளிலோ, அந்த ஆண் குழந்தை விருத்தசேதனம் செய்யப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","இரத்தப்போக்கிலிருந்து சுத்திகரிக்கப்படும்வரை அவள் முப்பத்துமூன்று நாட்கள் பொறுத்திருக்க வேண்டும். அவளுடைய சுத்திகரிப்பு நாட்கள் முடியும்வரை அவள் பரிசுத்தமான எந்தப் பொருளையும் தொடவும், பரிசுத்த இடத்திற்குப் போகவும் கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","அவள் ஒரு பெண் குழந்தையைப் பெற்றால், மாதவிடாய் நாட்களின்போது அசுத்தமாயிருப்பதுபோல் இரண்டு வாரங்களுக்கு அசுத்தமாயிருப்பாள். அதன்பின் இரத்தப்போக்கிலிருந்து சுத்திகரிக்கப்படும்வரை, அறுபத்தாறு நாட்கள் பொறுத்திருக்க வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘அவளுடைய மகனுக்கான அல்லது மகளுக்கான சுத்திகரிப்பின் நாட்கள் முடிந்தவுடன், சபைக்கூடார வாசலில் இருக்கும் ஆசாரியனிடம் அவள் ஒரு வயதுடைய ஒரு செம்மறியாட்டுக் கடாக்குட்டியைத் தகன காணிக்கையாகவும், ஒரு புறாக்குஞ்சை அல்லது ஒரு மாடப்புறாவை பாவநிவாரண காணிக்கையாகவும் கொண்டுவர வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","ஆசாரியன் அவளுக்காகப் பாவநிவிர்த்தி செய்ய, அவற்றை யெகோவா முன்னிலையில் பலியாகச் செலுத்தவேண்டும். அப்பொழுது அவள் சம்பிரதாய முறைப்படி தன் இரத்தப்போக்கிலிருந்து சுத்தமாயிருப்பாள். “ ‘ஆண் குழந்தையையோ, பெண் குழந்தையையோ பெறுகிற பெண்ணைப் பற்றிய விதிமுறைகளாவன: ");
INSERT INTO tamtcv_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","ஒரு செம்மறியாட்டுக் குட்டியைச் செலுத்த வசதியற்றவளானால், இரண்டு புறாக்களை அல்லது இரண்டு மாடப்புறாக் குஞ்சுகளைக் கொண்டுவரலாம். அவற்றில் ஒன்றைத் தகன காணிக்கையாகவும், இன்னொன்றைப் பாவநிவாரண காணிக்கையாகவும் செலுத்தவேண்டும். இவ்விதமாக ஆசாரியன் அவளுக்காகப் பாவநிவிர்த்தி செய்யவேண்டும். அப்பொழுது அவள் சுத்தமாவாள்.’ ” ");
INSERT INTO tamtcv_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","மோசேயிடமும் ஆரோனிடமும் யெகோவா கூறியதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“ஒருவனுக்கு உடம்பில் வீக்கமோ, கொப்பளமோ அல்லது தோலில் வெண்புள்ளிகளோ இருந்து, அது தொற்றும் தோல்வியாதியானால், அவன் ஆசாரியனான ஆரோனிடம் அல்லது ஆசாரியராய் இருக்கும் அவனுடைய மகன்களில் ஒருவனிடம் அழைத்துச்செல்லப்பட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","ஆசாரியன் அவனுடைய தோலில் உள்ள புண்ணைச் சோதித்துப் பார்க்கவேண்டும். புண்ணிலுள்ள உரோமம் வெண்மையாக மாறி, அந்தப்புண் தோலின் கீழ் ஆழமாகக் காணப்படுமானால், அது தொற்றும் தோல்வியாதியாகும். எனவே ஆசாரியன் அவனைப் பரிசோதிக்கிறபோது, அவனை சம்பிரதாயப்படி அசுத்தமானவன் என தீர்க்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","ஆனால் தோலிலுள்ள புண் வெண்மையாக இருந்து, தோலைவிட ஆழமாகக் காணப்படாமலும், அதில் இருக்கும் உரோமம் வெள்ளையாக மாறாமலும் இருந்தால், ஆசாரியன் நோயுள்ளவனை ஏழு நாட்களுக்குத் தனிமைப்படுத்தி வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ஏழாம்நாளில் ஆசாரியன் அவனைத் திரும்பவும் பரிசோதிக்க வேண்டும். அப்பொழுது அந்தப்புண் மாறாமலும், தோலில் பரவாமலும் இருக்கக் கண்டால், இன்னும் ஏழுநாட்களுக்கு அவனைத் தனிமையிலேயே வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","திரும்பவும் ஏழாம்நாளில் ஆசாரியன் அவனைப் பரிசோதிக்க வேண்டும். அப்பொழுது புண் ஆறி, தோலில் பரவாமல் இருந்தால், ஆசாரியன் அவனைச் சுத்தமானவன் என அறிவிக்கவேண்டும். அது ஒரு சிரங்கு மட்டுமே. அவன் தன் உடைகளைக் கழுவவேண்டும். அப்பொழுது அவன் சுத்தமாயிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","ஆனாலும், அவன் ஆசாரியனிடம் தன்னைக் காண்பித்து சுத்தமானவன் என தீர்க்கப்பட்டபின், அச்சிரங்கு தோலில் பரவுமானால், அவன் திரும்பவும் ஆசாரியனுக்கு முன்பாக வரவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","ஆசாரியன் அவனைப் பரிசோதிக்க வேண்டும். அந்த சிரங்கு தோலில் பரவியிருந்தால், ஆசாரியன் அவனை அசுத்தமானவன் என அறிவிக்கவேண்டும். அது ஒரு தொற்று வியாதியாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“எவனுக்காவது தொற்றும் தோல்வியாதி இருக்குமானால், அவன் ஆசாரியனிடம் கொண்டுவரப்பட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","ஆசாரியன் அவனைப் பரிசோதிக்க வேண்டும். அவன் தோலில் வெண்மையான வீக்கம் காணப்பட்டு, அது உரோமத்தையும் வெண்மையாக்கி, அந்த வீக்கத்தில் வெடிப்பு ஏற்பட்டு சதை காணப்பட்டால், ");
INSERT INTO tamtcv_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","அது நாள்பட்ட ஒரு தோல்வியாதியாகும். எனவே ஆசாரியன் அவனை அசுத்தமானவன் என தீர்க்கவேண்டும். ஆசாரியன் அவனைத் தனிமைப்படுத்த வேண்டியதில்லை. ஏனெனில், அவன் ஏற்கெனவே அசுத்தமானவன். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“ஆனால் ஆசாரியன் பார்க்கக்கூடிய அளவு அந்த வியாதி நோயுற்றவனின் தலைமுதல் கால்வரை, தோல் முழுவதும் பரவியிருக்குமானால், ");
INSERT INTO tamtcv_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ஆசாரியன் அவனைப் பரிசோதிக்க வேண்டும். அந்த நோய் அவனுடைய உடல் முழுவதும் பரவியிருந்தால், அவன் சுத்தமானவன் என அறிவிக்கப்பட வேண்டும். அவன் உடல் முழுவதும் வெண்மையாக மாறியிருந்தால் அவன் சுத்தமாவான். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","எப்பொழுதாவது அவனுடைய தோல் வெடித்துச் சதை காணப்பட்டால் அவன் அசுத்தமானவனாய் இருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","ஆசாரியன் சதை தெரிவதைக் காணும்போது, அவனை அசுத்தமானவன் என அறிவிக்கவேண்டும். சதை தெரிவது அசுத்தமாகும்; அவனுக்கு இருப்பது தொற்று வியாதியாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","அந்த தெரியும் சதை மாறி வெண்மையாகினால், அவன் ஆசாரியனிடம் போகவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","ஆசாரியன் அவனைப் பரிசோதிக்க வேண்டும். அந்தப்புண் வெண்மையாக மாறியிருந்தால், நோயுற்றவன் சுத்தமானவன் என ஆசாரியன் அறிவிக்கவேண்டும். அப்பொழுது அவன் சுத்தமாவான். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“ஒரு மனிதனின் தோலில் கட்டி உண்டாகி, அது குணமடையும்போது, ");
INSERT INTO tamtcv_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","அந்தக் கட்டி இருந்த இடத்தில் வெண்மையான வீக்கமோ அல்லது சிவப்பும் வெண்மையுமான புள்ளியோ தோன்றினால், அவன் தன்னை ஆசாரியனிடம் காண்பிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","ஆசாரியன் அதைப் பரிசோதிக்க வேண்டும். அது தோலைவிட ஆழமாகவும், அதிலுள்ள உரோமம் வெண்மையாகவும் மாறியிருக்கக் காணப்பட்டால், ஆசாரியன் அந்த மனிதனை அசுத்தமானவன் என்று அறிவிக்கவேண்டும். இதுவும் கட்டி இருந்த இடத்தில் தோன்றிய தொற்றும் தோல்வியாதியாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","ஆசாரியன் அதைப் பரிசோதிக்கும்போது, அதில் வெண்மையான உரோமம் இல்லாமலும், தோலைவிட ஆழமில்லாமலும், புண் ஆறியுமிருந்தால், அவனை ஏழுநாட்களுக்கு தனிமைப்படுத்த வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","அது தோலில் பரவுகிறதாய் இருந்தால் ஆசாரியன் அவனை அசுத்தமானவன் என அறிவிக்கவேண்டும். அது தொற்றும் தோல்வியாதியாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","ஆனால் புள்ளி மாறாமலும் பரவாமலும் இருந்தால், அது கொப்பளத்திலிருந்து உண்டான தழும்பு மாத்திரமே. ஆசாரியன் அவனைச் சுத்தமானவன் என அறிவிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“ஒருவனது தோல் வெந்து, வெந்ததினால் வெடித்தசதையில் வெண்சிவப்பான அல்லது வெண்மையான புள்ளி தோன்றினால், ");
INSERT INTO tamtcv_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ஆசாரியன் அந்தப் புள்ளியைப் பரிசோதிக்க வேண்டும். அதிலுள்ள உரோமம் வெண்மையாகி, அந்தப்புண் தோலைவிட ஆழமாகக் காணப்பட்டால், அதுவும் வெந்துபோனதிலிருந்து தோன்றிய தொற்று வியாதியாகும். எனவே ஆசாரியன் அவனை அசுத்தமானவன் என்று அறிவிக்கவேண்டும். அது தொற்றும் தோல்வியாதி ஆகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","ஆனால் ஆசாரியன் அதைப் பரிசோதித்துப் பார்த்து, அந்தப் புள்ளியில் வெண்மையான உரோமம் இல்லாமலும், அது தோலைவிட ஆழமில்லாமலிருந்து, புண் ஆறியிருக்கக் காணப்பட்டால், ஆசாரியன் அவனை ஏழுநாட்களுக்கு தனிமைப்படுத்தி வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ஏழாம்நாளில் ஆசாரியன் அவனை மறுபடியும் பரிசோதிக்க வேண்டும். அப்பொழுது அந்த வியாதி தோலில் பரவியிருக்குமானால், ஆசாரியன் அவனை அசுத்தமானவன் என அறிவிக்கவேண்டும். அது தொற்றும் தோல்வியாதியாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","ஆனாலும் அந்தப் புள்ளி மாறாமலும், தோலில் படராமலும் புண் ஆறியிருந்தால், அது வெந்துபோனதினால் உண்டான ஒரு வீக்கமாகும். ஆசாரியன் அவனைச் சுத்தமானவன் என்று அறிவிக்கவேண்டும். ஏனெனில், அது வெந்துபோனதினால் உண்டான தழும்பு மாத்திரமே. ");
INSERT INTO tamtcv_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“ஒரு ஆணுக்கோ அல்லது பெண்ணுக்கோ தலையில் அல்லது நாடியில் புண் ஏற்பட்டால், ");
INSERT INTO tamtcv_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ஆசாரியன் அந்தப் புண்ணைப் பரிசோதிக்க வேண்டும். அது தோலைவிட ஆழமாகக் காணப்பட்டு, அதிலுள்ள உரோமம் மஞ்சள் நிறமாகவும், மெல்லியதாகவும் இருந்தால், அவர்களை அசுத்தமானவர் என ஆசாரியன் அறிவிக்கவேண்டும். அது ஒரு சொறி. தலையிலும், நாடியிலும் உண்டாகிய ஒரு தொற்று வியாதி. ");
INSERT INTO tamtcv_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","ஆனாலும் ஆசாரியன் இந்த விதமான புண்ணை சோதிக்கும்போது, அது தோலைவிட ஆழமில்லாமலும், கருப்பு உரோமம் அவ்விடத்தில் இல்லாமலும் இருந்தால், ஆசாரியன் அந்த நோயுற்றவனை ஏழு நாட்களுக்குத் தனிமைப்படுத்த வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ஏழாம் நாளிலே ஆசாரியன் திரும்பவும் அந்தப் புண்ணைப் பார்வையிட வேண்டும். அந்த சொறி தோலில் பரவாமலும், மஞ்சள் நிறமான உரோமம் காணப்படாமலும், தோலைவிட ஆழமாகக் காணப்படாமலும் இருந்தால், ");
INSERT INTO tamtcv_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","அவன் சொறியுள்ள பகுதி தவிர மற்றப்பகுதிகளை எல்லாம் சிரைத்துக்கொள்ள வேண்டும். பின் ஆசாரியன் பரிசோதனைக்காக இன்னும் ஏழுநாட்களுக்கு அவனைத் தனிமைப்படுத்த வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ஏழாம் நாளிலே ஆசாரியன் அந்த சொறியைப் பரிசோதிக்க வேண்டும். அது தோலில் பரவாமலும், தோலைவிட ஆழமில்லாமலும் காணப்பட்டால், ஆசாரியன் அவனை சுத்தமானவன் என அறிவிக்கவேண்டும். அவன் தன் உடைகளைக் கழுவவேண்டும். அவன் சுத்தமாயிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","ஆனாலும் அவன் சுத்தமானவன் என அறிவிக்கப்பட்ட பின்னும் சொறி தோலில் பரவினால், ");
INSERT INTO tamtcv_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ஆசாரியன் அவனைப் பரிசோதிக்க வேண்டும். சொறி தோலில் பரவியிருந்தால், ஆசாரியன் மஞ்சள் நிற உரோமத்தைத் தேடிப்பார்க்க வேண்டியதில்லை. அந்த ஆள் அசுத்தமானவனே. ");
INSERT INTO tamtcv_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","ஆனாலும் ஆசாரியன் பார்க்கும்போது, அவனுடைய எண்ணப்படி சொறி மாற்றமடையாமல் அவ்விடத்தில் கருப்பு உரோமம் வளர்ந்திருந்தால், அந்த சொறி குணமாயிற்று. அவன் சுத்தமாய் இருக்கிறான். அவனைச் சுத்தமானவன் என அறிவிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“ஒரு ஆணுக்கோ அல்லது பெண்ணுக்கோ அவர்களுடைய தோலில் வெண்மையான புள்ளிகள் இருக்கிறபோது, ");
INSERT INTO tamtcv_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ஆசாரியன் அவர்களைப் பரிசோதிக்க வேண்டும். அப்பொழுது அப்புள்ளிகளின் நிறம், மங்கிய வெள்ளையாய் இருந்தால் அது தோலில் உண்டான ஒரு தீங்கற்ற ஒரு சிரங்கு வியாதியாகும். அவன் சுத்தமாய் இருக்கிறான். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“ஒரு மனிதன் தலைமயிரை இழந்து மொட்டையாய் இருக்கும்போது அவன் சுத்தமானவன். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","அவனுடைய உச்சந்தலையின் முன் பகுதியிலிருந்து மயிர் உதிர்ந்தால், அவனுக்கு இருப்பது மொட்டையான முன்னந்தலை. அவன் சுத்தமானவன். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","ஆனால் அவனுடைய மொட்டைத்தலையில் அல்லது நெற்றியில் வெண்சிவப்பான புண் இருந்தால், அது அவனுடைய தலையில் அல்லது நெற்றியில் உண்டான தொற்று வியாதியாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","ஆசாரியன் அதைப் பரிசோதிக்க வேண்டும். அப்பொழுது அவனுடைய தலையிலோ நெற்றியிலோ உள்ள வீங்கிய புண், ஒரு தொற்றும் தோல்வியாதிபோல் வெண்சிவப்பு நிறமாக இருந்தால், ");
INSERT INTO tamtcv_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","அவன் நோயுற்று அசுத்தமாய் இருக்கிறான். அவனுடைய புண்ணின் நிமித்தம் ஆசாரியன் அவனை அசுத்தமானவன் என அறிவிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“அப்படிப்பட்ட தொற்று வியாதியுடைய ஆள், கிழிந்த உடைகளை உடுத்தவேண்டும். அவன் தன் தலைமயிரைக் குழப்பி, தன் முகத்தின் கீழ்ப்பகுதியை மூடிக்கொண்டு, ‘அசுத்தம், அசுத்தம்’ என சத்தமிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","அந்தத் தொற்று வியாதி அவனுக்கு இருக்குமட்டும் அவன் அசுத்தமானவனாய் இருப்பான். அவன் தனிமையாய் வாழவேண்டும். முகாமுக்கு வெளியே வசிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“ஏதாவது பூஞ்சணத்தினால் உடை கறைப்பட்டால், அதாவது கம்பளியாவது, மென்பட்டு உடையாவது, ");
INSERT INTO tamtcv_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","மென்பட்டினாலோ கம்பளியினாலோ நெய்யப்பட்ட உடையாவது, தோலாவது, தோலினால் செய்யப்பட்ட ஏதாவது பொருளாவது கறைப்பட்டிருந்தால், ");
INSERT INTO tamtcv_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","அந்த உடையிலோ, தோலிலோ, நெய்யப்பட்ட துணியிலோ அல்லது தோலினால் செய்யப்பட்ட பொருளிலோ, உள்ள கறை பச்சையாகவோ, சிவப்பாகவோ இருந்தால் அது பரவும் பூஞ்சணமாகும். அதை ஆசாரியனிடம் காண்பிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","ஆசாரியன் அந்த பூஞ்சணத்தைப் பரிசோதித்து, பாதிக்கப்பட்ட பொருட்களை ஏழுநாட்களுக்குப் புறம்பாக்கி வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","ஏழாம்நாளில் அவன் அதைப் பரிசோதிக்க வேண்டும். உடையிலோ, நெய்யப்பட்ட துணியிலோ, தோலினால் செய்யப்பட்ட பொருட்களிலோ, தோலிலோ அவை எதற்கு பயன்படுத்தப்பட்டாலும் அவற்றில் பூஞ்சணம் படர்ந்திருந்தால், அது அழிவை ஏற்படுத்தக்கூடிய பூஞ்சணமாகும். அப்பொருள் அசுத்தமானது. ");
INSERT INTO tamtcv_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","எனவே ஆசாரியன் கறைப்பட்ட உடையையோ, கம்பளியினால் அல்லது மென்பட்டினால் நெய்யப்பட்டதையோ அல்லது பின்னப்பட்ட உடையையோ, தோல் பொருட்களோ அவைகளை எரிக்கவேண்டும். ஏனெனில், அந்த பூஞ்சணம் அழிவை ஏற்படுத்தக் கூடியது. எனவே அப்பொருள்கள் எரிக்கப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“ஆசாரியன் அதைப் பரிசோதிக்கும்போது, உடையிலோ அல்லது நெய்யப்பட்ட துணியிலோ அல்லது தோலிலோ பூஞ்சணம் படராதிருந்தால், ");
INSERT INTO tamtcv_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","கறைபட்ட அப்பொருள் கழுவப்படும்படி ஆசாரியன் உத்தரவு கொடுக்கவேண்டும். அதன்பின் இன்னும் ஏழுநாட்களுக்கு அவன் அதைப் புறம்பாக்கி வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","பாதிக்கப்பட்ட பொருள் கழுவப்பட்ட பின், ஆசாரியன் அதைப் பரிசோதிக்க வேண்டும். அந்த பூஞ்சணம் படராதிருந்தாலும், அதனுடைய தோற்றத்தில் மாற்றமடையாதிருந்தால் அது அசுத்தமானதே. அந்த பூஞ்சணம் எந்த ஒரு பக்கத்தைப் பாதித்திருந்தாலும், அது நெருப்பினால் எரிக்கப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","ஆசாரியன் அதைப் பரிசோதிக்கும்போது, அப்பொருள் கழுவப்பட்ட பின்பு பூஞ்சணம் மங்கியிருந்தால், அது காணப்பட்ட அந்த இடத்தை தோல் பொருளிலிருந்தோ, உடையிலிருந்தோ, நெய்யப்பட்ட அல்லது பின்னப்பட்ட துணியிலிருந்தோ அவன் அதை கிழித்தெடுக்க வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","ஆனால் அந்தப் பூஞ்சணம் உடையிலோ, நெய்யப்பட்ட அல்லது பின்னப்பட்ட பொருளிலோ, அல்லது தோல் பொருளிலோ திரும்பவும் தோன்றினால், அது படருகின்றது. எனவே பூஞ்சணம் பிடித்த எதுவும் நெருப்பினால் எரிக்கப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","உடையோ, நெய்யப்பட்ட அல்லது பின்னப்பட்ட துணியோ, தோல் பொருளோ கழுவப்பட்டுப் பூஞ்சணம் நீக்கப்பட்டதாயிருந்தால், அது திரும்பவும் கழுவப்பட வேண்டும். அப்பொழுது அது சுத்தமாயிருக்கும்.” ");
INSERT INTO tamtcv_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","கம்பளியினால் அல்லது மென்பட்டினாலான உடையோ, நெய்யப்பட்ட அல்லது பின்னப்பட்ட துணியோ அல்லது ஏதாவது ஒரு தோல் பொருளோ பூஞ்சணத்தினால் கறைப்பிடித்திருந்தால், அவை சுத்தமோ, அசுத்தமோ என தீர்மானிப்பதற்கான விதிமுறைகள் இவைகளே என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","யெகோவா மோசேயுடன் பேசிச் சொன்னதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“நோயுற்ற ஒருவன் ஆசாரியனிடம் கொண்டுவரப்படும்போது, சம்பிரதாய முறைப்படி அவன் சுத்திகரிக்கப்படும் வேளையில் கடைபிடிக்க வேண்டிய விதிமுறைகள் இவையே: ");
INSERT INTO tamtcv_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ஆசாரியன் முகாமுக்கு வெளியே சென்று அவனைப் பரிசோதிக்க வேண்டும். அந்த நோயாளி தனது தொற்றும் தோல்வியாதியிலிருந்து குணமடைந்திருந்தால், ");
INSERT INTO tamtcv_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ஆசாரியன் சுத்திகரிக்கப்பட வேண்டியவனுக்காக இரண்டு சுத்தமான உயிருள்ள பறவைகளையும், சில கேதுருமரத்தின் கட்டைகளையும், சிவப்புநூல் கற்றைகளையும், ஈசோப்புக் குழையையும் கொண்டுவரும்படி உத்தரவிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","பின்பு ஒரு மண்பானையிலுள்ள நல்ல தண்ணீரின் மேலாக அந்த பறவைகளில் ஒன்று கொல்லப்படும்படி ஆசாரியன் உத்தரவிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","அவன் கேதுருமரக்கட்டை, சிவப்புநூல் கற்றை, ஈசோப்புக்குழை ஆகியவற்றுடன் உயிரோடிருக்கும் மற்றப் பறவையையும் எடுத்து, நல்ல தண்ணீரின் மேலாகக் கொல்லப்பட்ட பறவையின் இரத்தத்தில் அதைத் தோய்க்க வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","ஆசாரியன், தொற்று வியாதியிலிருந்து சுத்திகரிக்கப்பட வேண்டியவன்மேல், ஏழுமுறை இரத்தத்தைத் தெளித்து, அவனைச் சுத்தமானவன் என அறிவிக்கவேண்டும். அதன்பின் அந்த உயிருள்ள பறவையைத் திறந்த வெளியிலே விட்டுவிட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“சுத்தமாக்கப்பட வேண்டியவன் தன் உடைகளைக் கழுவி, தலைமயிர் முழுவதையும் சிரைத்து, தண்ணீரில் முழுகவேண்டும். அப்பொழுது அவன் சம்பிரதாய முறைப்படி சுத்தமாயிருப்பான். இதன்பின் அவன் தனது முகாமுக்கு வரலாம். ஆனாலும் ஏழுநாட்களுக்கு அவன் தன் கூடாரத்துக்கு வெளியே தங்கியிருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","அவன் ஏழாம்நாளில் தன் மயிர் முழுவதையும் சிரைக்கவேண்டும். தலை, தாடி, புருவம் ஆகியவற்றிலுள்ள உரோமங்களையும், மற்ற இடங்களிலுள்ள உரோமங்களையும் சிரைக்கவேண்டும். தன் உடைகளைத் தண்ணீரில் கழுவி, முழுகவேண்டும். அப்பொழுது அவன் சுத்தமாவான். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“எட்டாம் நாளிலே அவன் குறைபாடற்ற இரண்டு ஆண் செம்மறியாட்டுக் குட்டிகளையும், ஒரு வயதுடைய குறைபாடற்ற ஒரு பெண் செம்மறியாட்டுக் குட்டியையும், ஒரு எப்பா அளவையில் பத்தில் மூன்று பங்கு சிறந்த மாவை எண்ணெய் சேர்த்துப் பிசைந்து அத்துடன் தானியக் காணிக்கையாக ஒரு ஆழாக்கு ஒலிவ எண்ணெயையும் கொண்டுவர வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","அவனைச் சுத்தமானவன் என அறிவிக்கும் ஆசாரியன் சுத்திகரிக்கப்பட வேண்டியவனையும், அவனுடைய காணிக்கைகளையும் சபைக்கூடார வாசலில் யெகோவா முன்னிலையில் கொண்டுவர வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“பின்பு ஆசாரியன் இரண்டு ஆண் செம்மறியாட்டுக் குட்டிகளில் ஒன்றை ஒரு ஆழாக்கு எண்ணெயுடன் குற்றநிவாரண காணிக்கையாகச் செலுத்தவேண்டும். அவன் அதை யெகோவா முன்னிலையில் அசைவாட்டும் காணிக்கையாக அசைவாட்டவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","பாவநிவாரண காணிக்கை மிருகமும், தகன காணிக்கை மிருகமும் கொல்லப்பட்ட பரிசுத்த இடத்திலேயே, ஆசாரியன் அந்தச் செம்மறியாட்டுக் குட்டியை வெட்டிக் கொல்லவேண்டும். பாவநிவாரண காணிக்கையைப்போலவே குற்றநிவாரண காணிக்கையும் ஆசாரியனுக்கே உரியது. அது மிகவும் பரிசுத்தமானது. ");
INSERT INTO tamtcv_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","ஆசாரியன் குற்றநிவாரண காணிக்கையின் இரத்தத்தில் கொஞ்சம் எடுத்து, அதைச் சுத்திகரிக்கப்பட வேண்டியவனுடைய வலது காதின் மடலிலும், வலதுகை பெருவிரலிலும், வலதுகால் பெருவிரலிலும் பூசவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","பின்பு ஆசாரியன் அந்த ஆழாக்கு எண்ணெயில் இருந்து கொஞ்சத்தை எடுத்து தன் இடது உள்ளங்கையில் ஊற்றி, ");
INSERT INTO tamtcv_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","தன் வலது ஆள்காட்டி விரலை, இடது உள்ளங்கையில் இருக்கும் எண்ணெயில் தோய்த்து, யெகோவா முன்னிலையில் ஏழுமுறை தெளிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","ஆசாரியன் தன் உள்ளங்கையில் மீதமுள்ள எண்ணெயை, சுத்திகரிக்கப்பட வேண்டியவனின் வலது காது மடலிலும், அவனுடைய வலதுகை பெருவிரலிலும், வலதுகால் பெருவிரலிலும், ஏற்கெனவே பூசப்பட்டிருக்கும் குற்றநிவாரண காணிக்கை இரத்தத்தின் மேலாக பூசவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","ஆசாரியன் தனது உள்ளங்கையிலுள்ள மீதமுள்ள எண்ணெயை சுத்திகரிக்கப்பட வேண்டியவனின் தலையில் தடவி, அவனுக்காக யெகோவாவுக்குமுன், பாவநிவிர்த்தி செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“பின்பு ஆசாரியன் பாவநிவாரண காணிக்கையைப் பலியிட்டு தன் அசுத்தத்திலிருந்து சுத்திகரிக்கப்பட வேண்டியவனுக்காக பாவநிவிர்த்தி செய்யவேண்டும். அதன்பின் ஆசாரியன் தகன காணிக்கை மிருகத்தை வெட்டிக் கொல்லவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","ஆசாரியன் அதைத் தானியக் காணிக்கையுடன் பலிபீடத்தின்மேல் செலுத்தி, அவனுக்காக பாவநிவிர்த்தி செய்யவேண்டும். அப்பொழுது அவன் சுத்தமாவான். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“ஆனாலும், அவன் ஏழையாய் இருந்து இவற்றை அவன் செலுத்த முடியாதவனானால், தனக்குப் பாவநிவிர்த்தி செய்வதற்கு அசைவாட்டப்படும்படி குற்றநிவாரண காணிக்கையாக ஒரு ஆண் செம்மறியாட்டுக் குட்டியையாவது எடுத்துக்கொள்ளவேண்டும். அத்துடன் ஒரு எப்பா அளவையில் பத்தில் ஒரு பங்கு சிறந்த மாவை எண்ணெய் கலந்து பிசைந்து அதைத் தானியக் காணிக்கையாகவும், ஒரு ஆழாக்கு ஒலிவ எண்ணெயையும் கொண்டுவர வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","அத்துடன் அவன் தன்னால் செலுத்தக்கூடிய இரண்டு புறாக்களையோ, இரண்டு மாடப்புறாக் குஞ்சுகளையோ, ஒன்றைப் பாவநிவாரண காணிக்கையாகவும், இன்னொன்றைத் தகன காணிக்கையாகவும் செலுத்துவதற்கு எடுத்துக்கொள்ளவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“எட்டாம் நாளிலே அவன் அவைகளை தனது சுத்திகரிப்புக்காக யெகோவா முன்னிலையில், சபைக் கூடாரவாசலுக்கு ஆசாரியனிடம் கொண்டுவர வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","ஆசாரியன் ஒரு ஆழாக்கு எண்ணெயுடன் குற்றநிவாரண செம்மறியாட்டுக் குட்டியையும் காணிக்கையாக எடுத்து, அவற்றை யெகோவாவுக்கு முன்பாக அசைவாட்டும் காணிக்கையாக அசைவாட்டவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ஆசாரியன், குற்றநிவாரண காணிக்கைக்கான செம்மறியாட்டுக் குட்டியை வெட்டிக்கொன்று, அதன் இரத்தத்தில் கொஞ்சம் எடுத்து, சுத்திகரிக்கப்பட வேண்டியவனின் வலது காது மடலிலும், வலதுகை பெருவிரலிலும், வலதுகால் பெருவிரலிலும் அதைப் பூசவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","அத்துடன் ஆசாரியன், தன் இடது உள்ளங்கையில் கொஞ்சம் எண்ணெயை ஊற்றி, ");
INSERT INTO tamtcv_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","தன் வலதுகை ஆள்காட்டி விரலால் இடது உள்ளங்கையில் இருக்கும் எண்ணெயில் சிறிதளவை யெகோவா முன்னிலையில் ஏழுமுறை தெளிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","ஆசாரியன் தன் இடது உள்ளங்கையில் இருக்கும் எண்ணெயில் கொஞ்சத்தை எடுத்து, சுத்திகரிக்கப்பட வேண்டியவனின் உடலில் குற்றநிவாரண காணிக்கை இரத்தம் பூசப்பட்ட இடங்களிலெல்லாம் அதாவது, வலது காது மடலிலும், வலதுகை பெருவிரலிலும், வலதுகால் பெருவிரலிலும் பூசவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","மேலும், யெகோவாவுக்கு முன்பாக சுத்திகரிக்கப்பட வேண்டியவனுக்காகப் பாவநிவிர்த்தி செய்யும்படி, ஆசாரியன் தன் உள்ளங்கையில் இருக்கும் மீதமுள்ள எண்ணெயை அவனுடைய தலையில் பூசவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","பின்பு ஆசாரியன் சுத்திகரிக்கப்பட வேண்டியவனால் செலுத்தக்கூடிய புறாக்களையோ அல்லது மாடப்புறாக் குஞ்சுகளையோ பலியிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","அவன் ஒன்றைப் பாவநிவாரண காணிக்கையாகவும், இன்னொன்றைத் தானியக் காணிக்கையுடன் தகன காணிக்கையாகவும் செலுத்தவேண்டும். இவ்விதமாய் ஆசாரியன் சுத்திகரிக்கப்பட வேண்டியவனுக்காக யெகோவா முன்னிலையில் பாவநிவிர்த்தி செய்யவேண்டும்.” ");
INSERT INTO tamtcv_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","தொற்றும் தோல்வியாதியை உடையவனாயிருந்து, தன் சுத்திகரிப்புக்கான வழக்கமான காணிக்கைகளைச் செலுத்தமுடியாமல் போகும் ஒருவனுக்குரிய விதிமுறைகள் இவையே என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","யெகோவா மோசேக்கும் ஆரோனுக்கும் சொன்னதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“நான் உங்களுக்கு உரிமையாய்க் கொடுக்கிற கானான் நாட்டிற்குள் நீங்கள் போகும்போது, அங்கே நான், படரும் பூஞ்சணத்தை ஒரு வீட்டில் வரச்செய்தால், ");
INSERT INTO tamtcv_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","அந்த வீட்டிற்குச் சொந்தக்காரன் ஆசாரியனிடம் சென்று, ‘என் வீட்டிலே பூஞ்சணம்போல் காணப்படுகிற ஒன்றைக் கண்டேன்’ என்று அறிவிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","ஆசாரியன் பூஞ்சணத்தை பரிசோதிக்க உள்ளேபோகும் முன் அந்த வீடு வெறுமையாக்கப்பட உத்தரவிடவேண்டும். அப்பொழுது அவ்வீட்டிலுள்ள பொருட்கள் அசுத்தம் என அறிவிக்கப்படமாட்டாது. அதன்பின் ஆசாரியன் உள்ளே போய், அந்த வீட்டைப் பரிசோதனையிட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","அவன் சுவர்களிலுள்ள பூஞ்சணத்தைப் பரிசோதிக்க வேண்டும். அங்கு சுவரின் மேற்பரப்பைவிட ஆழமான பச்சைநிற அல்லது சிவப்புநிற குழிகள் காணப்பட்டால், ");
INSERT INTO tamtcv_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","உடனே ஆசாரியன் வீட்டின் வாசலைவிட்டு வெளியே போய், அந்த வீட்டை ஏழுநாட்களுக்குப் பூட்டிவைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","ஏழாம்நாளில் அந்த வீட்டைச் சோதனையிடும்படி ஆசாரியன் திரும்பிப் போகவேண்டும். அந்த பூஞ்சணம் சுவர்களில் படர்ந்திருந்தால், ");
INSERT INTO tamtcv_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","கறைப்படிந்த கற்களைப் பெயர்த்தெடுத்து, பட்டணத்திற்கு வெளியே அசுத்தமான இடத்திலே எறியும்படி ஆசாரியன் உத்தரவிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","வீட்டின் உட்புறச் சுவர்கள் முழுவதையும் சுரண்டி எடுத்து, சுரண்டி எடுத்ததை பட்டணத்திற்கு வெளியே அசுத்தமான இடத்தில் கொட்டிவிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","அதன்பின் அவர்கள் பெயர்த்தெடுத்த கற்களுக்குப் பதிலாக வேறே கற்களை வைத்து, வீட்டைப் புதிய சாந்தைக்கொண்டு பூசவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“கற்கள் பெயர்க்கப்பட்டு, வீடு சுரண்டப்பட்டு, பூசப்பட்ட பின்பும் வீட்டில் பூஞ்சணங்கள் திரும்பவும் தோன்றுமானால், ");
INSERT INTO tamtcv_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ஆசாரியன் அங்குபோய் அவ்வீட்டைப் பரிசோதனையிட வேண்டும். அந்த பூஞ்சணம் வீட்டிலே படர்ந்திருந்தால், அது அழிவு ஏற்படுத்தக்கூடிய பூஞ்சணமாகும். அந்த வீடு அசுத்தமானது. ");
INSERT INTO tamtcv_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","எனவே அது இடிக்கப்பட்டு, அதன் கற்கள், மரங்கள், சாந்துப் பூச்சுகள் யாவும் அகற்றப்பட்டு பட்டணத்திற்கு வெளியே ஒரு அசுத்தமான இடத்திற்கு எடுத்துச்செல்லப்பட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“அந்த வீடு பூட்டிவைக்கப்பட்டிருக்கும் காலத்தில் அதற்குள் செல்லும் எவனும் மாலைவரை அசுத்தமாயிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","அதேபோல் அவ்வீட்டினுள் நித்திரை செய்கிற அல்லது சாப்பிடுகிற எவனும், தன் உடைகளைக் கழுவவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“வீடு பூசப்பட்டபின், ஆசாரியன் திரும்பவும் அதைப் பரிசோதிக்க வருகிறபோது, அங்கே பூஞ்சணங்கள் படராதிருந்தால், அந்த வீட்டைச் சுத்தமானது என்று அவன் அறிவிக்கவேண்டும். ஏனெனில், பூஞ்சணம் போய்விட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","அதன்பின் வீட்டைச் சுத்திகரிப்பதற்கு ஆசாரியன் இரண்டு பறவைகளையும், ஒருசில கேதுரு விறகுகளையும், சிவப்புநூல் கற்றையையும், ஈசோப்புக் குழையையும் எடுத்துக்கொள்ளவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","அந்த பறவைகளில் ஒன்றை மண்பானையிலுள்ள சுத்தமான தண்ணீரின் மேலாகக் கொல்லவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","பின்பு கேதுரு விறகையும், ஈசோப்புக் குழையையும், சிவப்புநூல் கற்றையையும், உயிரோடிருக்கும் பறவையையும் எடுத்து, கொல்லப்பட்ட பறவையின் இரத்தத்திலும், சுத்தமான தண்ணீரிலும் தோய்த்து, வீட்டின்மேல் ஏழுமுறை தெளிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","இவ்விதமாய், கொல்லப்பட்ட பறவையின் இரத்தத்தினாலும், சுத்தமான தண்ணீரினாலும், உயிரோடிருக்கும் பறவையினாலும், கேதுரு விறகினாலும், ஈசோப்புக் குழையினாலும், சிவப்புநூல் கற்றையாலும் அவ்வீட்டைச் சுத்திகரிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","பின்பு அவன் உயிரோடிருக்கும் பறவையை பட்டணத்திற்கு வெளியேயுள்ள பரந்த வெளியில் பறக்கவிடவேண்டும். இவ்விதமாய் அவன் அந்த வீட்டிற்காகப் பாவநிவிர்த்தி செய்யவேண்டும். அது சுத்தமாகும்.” ");
INSERT INTO tamtcv_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","எந்த விதமான தொற்றும் தோல்வியாதிக்கும் உரிய விதிமுறைகள் இவையே: சொறி, ");
INSERT INTO tamtcv_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","உடையிலுள்ள அல்லது வீட்டிலுள்ள பூஞ்சணம், ");
INSERT INTO tamtcv_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","வீக்கம், கொப்பளம், வெண்புள்ளி ");
INSERT INTO tamtcv_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ஆகியவை சுத்தமானதோ, அசுத்தமானதோ என தீர்மானிப்பதற்கான விதிமுறைகளும் இவையே. தோல்வியாதி, பூஞ்சணம் ஆகியவற்றிற்குரிய ஒழுங்குவிதிகள் இவையே என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","யெகோவா மோசேயிடமும் ஆரோனிடமும் பேசி, ");
INSERT INTO tamtcv_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“நீங்கள் இஸ்ரயேலருடன் பேசிச் சொல்லவேண்டியதாவது, ‘தன் உடலிலிருந்து ஒருவனுக்கு கசிவு ஏற்பட்டால் அது அசுத்தமானது. ");
INSERT INTO tamtcv_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","அக்கசிவு அவன் உடலிலிருந்து தொடர்ந்து வடிந்தாலும், தடைப்பட்டாலும், அது அவனை அசுத்தப்படுத்தும். அவனுடைய உடற்கசிவு அசுத்தத்தை உண்டாக்கும் விதமாவது: ");
INSERT INTO tamtcv_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ ‘அவன் படுக்கின்ற எந்தக் கட்டிலும், அவன் உட்காருகிற எந்த இடமும் அசுத்தமாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","யாராவது ஒருவன் அந்தக் கட்டிலைத் தொட்டால் அவன் தன் உடைகளைக் கழுவி, தண்ணீரில் முழுகவேண்டும். மாலைவரை அவன் அசுத்தமாயிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","கசிவு உள்ள அந்த மனிதன் உட்கார்ந்த இடத்தில் யாராவது உட்கார்ந்தால், அவன் தன் உடைகளைக் கழுவி, தண்ணீரில் முழுகவேண்டும். அவன் மாலைவரை அசுத்தமாயிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ ‘கசிவுள்ளவனைத் தொடுகிறவனும் தன் உடைகளைக் கழுவி, தண்ணீரில் முழுகவேண்டும். அவன் மாலைவரை அசுத்தமாயிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ ‘கசிவுள்ள அந்த மனிதன் சுத்தமுள்ள ஒருவன்மேல் துப்பினால், அவன் தன் உடைகளைக் கழுவி தண்ணீரில் முழுகவேண்டும். அவன் மாலைவரை அசுத்தமாயிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ ‘அவன் ஏறி இருந்து சவாரி செய்த எல்லாமே அசுத்தமானதாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","அவன் உட்கார்ந்த எந்தப் பொருளையும் தொடுகிறவன், மாலைவரை அசுத்தமாயிருப்பான். அப்படிப்பட்ட பொருளை எடுத்துக்கொண்டு போகிறவன் தன் உடைகளைக் கழுவி, தண்ணீரில் முழுகவேண்டும். அவன் மாலைவரை அசுத்தமாயிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ ‘கசிவு உள்ளவன், தன் கைகளைக் கழுவாமல் வேறொருவனைத் தொட்டால், தொடப்பட்டவன் தன் உடைகளைக் கழுவி, தண்ணீரில் முழுகவேண்டும். அவன் மாலைவரை அசுத்தமாயிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ ‘அவன் ஒரு மண்பாத்திரத்தைத் தொடுவானானால், அப்பாத்திரம் உடைக்கப்பட வேண்டும். மரப்பாத்திரங்களை எல்லாம் தண்ணீரால் அலசவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘அந்தக் கசிவு அவனைவிட்டு நீங்கும்போது, சம்பிரதாய முறைப்படி அவன் சுத்தமாவதற்கு ஏழுநாள் பொறுத்து, ஏழாம்நாள் தன் உடைகளைக் கழுவி சுத்தமான தண்ணீரில் முழுகவேண்டும். அப்பொழுது அவன் சுத்தமாவான். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","எட்டாம் நாளிலே, இரண்டு புறாக்களை அல்லது இரண்டு மாடப்புறாக்குஞ்சுகளை அவன் யெகோவா முன்னிலையில் கொண்டுவர வேண்டும். அவற்றை சபைக்கூடார வாசலில் ஆசாரியனிடம் கொடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","ஆசாரியன் ஒன்றைப் பாவநிவாரண காணிக்கையாகவும், இன்னொன்றைத் தகன காணிக்கையாகவும் பலிசெலுத்தவேண்டும். இவ்விதம் யெகோவா முன்னிலையில் அந்தக் கசிவின் நிமித்தம் அவனுக்காக ஆசாரியன் பாவநிவிர்த்தி செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘ஒருவனிலிருந்து விந்து வெளியேறினால், அவன் தண்ணீரில் உடல் முழுவதையும் கழுவி முழுகவேண்டும். அவன் மாலைவரை அசுத்தமுள்ளவனாயிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","விந்துபட்ட எந்த உடையும், தோல் பொருளும் தண்ணீரினால் கழுவப்பட வேண்டும். அது மாலைவரை அசுத்தமாயிருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","ஒரு மனிதன் ஒரு பெண்ணுடன் உறவுகொண்டு விந்து வெளிப்பட்டால், அவர்கள் இருவரும் தண்ணீரில் முழுகவேண்டும். அவர்கள் மாலைவரை அசுத்தமுள்ளவர்களாய் இருப்பார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘ஒழுங்கான இரத்தப்போக்கு உள்ள பெண் மாதவிடாய் காலத்தில் ஏழுநாட்களுக்கு அசுத்தமுள்ளவளாய் இருப்பாள். அவளைத் தொடுகிற எவனும், மாலைவரை அசுத்தமுள்ளவனாய் இருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ ‘அந்நாட்களில் அவள் படுக்கின்ற படுக்கையும், அவள் உட்காரும் இடமும் அசுத்தமுள்ளதாயிருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","யாராவது அவளின் படுக்கையைத் தொட்டால், அவன் தன் உடைகளைக் கழுவி தண்ணீரில் முழுகவேண்டும். அவன் மாலைவரை அசுத்தமுள்ளவனாய் இருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","அவள் உட்காரும் எதையாவது யாராவது ஒருவன் தொட்டால், அவன் தன் உடைகளைக் கழுவி, தண்ணீரில் முழுகவேண்டும். அவன் மாலைவரை அசுத்தமுள்ளவனாய் இருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","அவள் படுக்கையை அல்லது, அவள் உட்கார்ந்த எதையாவது ஒருவன் தொட்டால், அவன் மாலைவரை அசுத்தமுள்ளவனாய் இருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ ‘அந்நாட்களில் ஒருவன் அவளுடன் உறவுகொள்வதினால், அவளுடைய மாதவிடாய் அவனில் படும்போது அவன் ஏழுநாட்களுக்கு அசுத்தமுள்ளவனாய் இருப்பான். அவன் பயன்படுத்தும் எந்தப் படுக்கையும் அசுத்தமாயிருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘ஒரு பெண்ணுக்கு உடலின் இரத்தப்போக்கு மாதவிடாயைவிட வழக்கத்திற்கு மாறாக வந்தால் அல்லது மாதவிடாய் காலம் நீடித்தால், அவள் அந்த மாதவிடாய் காலத்தில் இருந்ததுபோல், இரத்தப்போக்கு இருக்கும்வரைக்கும் அசுத்தமாயிருப்பாள். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","அவள் இந்த நாட்களில் படுக்கின்ற கட்டிலும், அவள் உட்காரும் எதுவும், முன்பு மாதவிடாய் நாட்களில் அசுத்தமுள்ளதாய் இருந்ததுபோல, இப்பொழுதும் அசுத்தமுள்ளதாய் இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","யாராவது ஒருவன் அவைகளைத் தொட்டால், அவன் அசுத்தமுள்ளவனாவான். அவன் தன் உடைகளைக் கழுவி தண்ணீரில் முழுகவேண்டும். அவன் மாலைவரை அசுத்தமுள்ளவனாவான். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ ‘அவள் தன் மாதவிடாயிலிருந்து சுத்திகரிக்கப்படும்போது, அவள் ஏழு நாட்களை எண்ணவேண்டும். அதன்பின் சம்பிரதாய முறைப்படி அவள் சுத்தமாவாள். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","எட்டாம் நாள் அவள் இரண்டு புறாக்களை அல்லது இரண்டு மாடப்புறாக் குஞ்சுகளைச் சபைக்கூடார வாசலில் ஆசாரியனிடம் கொண்டுவர வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","ஆசாரியன் அதில் ஒன்றைப் பாவநிவாரண காணிக்கையாகவும், இன்னொன்றைத் தகன காணிக்கையாகவும் பலிசெலுத்தவேண்டும். இவ்விதம் ஆசாரியன் அவளுடைய இரத்தப்போக்கின் அசுத்தத்திற்காக யெகோவா முன்பாக பாவநிவிர்த்தி செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘நீ இஸ்ரயேலரை அவர்களை அசுத்தப்படுத்தும் பொருட்களிலிருந்து வேறுபடுத்தவேண்டும். ஏனெனில் அவர்கள் மத்தியில் இருக்கும் என் வசிப்பிடத்தை அசுத்தப்படுத்துவதால், இஸ்ரயேலர் தங்கள் அசுத்தத்தில் சாகாதபடி, இப்படிச் செய்யவேண்டும்.’ ” ");
INSERT INTO tamtcv_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","ஆகவே உடலில் கசிவு உள்ளவனுக்கும், விந்து கழிவதினால் அசுத்தமுள்ளவனுக்கும், ");
INSERT INTO tamtcv_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","மாதவிடாய் உள்ள பெண்ணுக்கும், உடல் கசிவுள்ள ஆணுக்கும், பெண்ணுக்கும், சம்பிரதாய முறைப்படி அசுத்தமாயிருக்கிற பெண்ணுடன் உடலுறவு கொள்ளும் மனிதனுக்கும் கொடுக்கப்பட்ட ஒழுங்குவிதிகள் இவையே என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","ஆரோனின் இரண்டு மகன்களும் யெகோவாவின் சந்நிதியை நெருங்கியபோது இறந்துபோன பின்பு, யெகோவா மோசேயிடம் பேசினார். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","யெகோவா மோசேயிடம் சொன்னதாவது, “உன் சகோதரன் ஆரோன் திரைக்குப் பின்னால் உள்ள மகா பரிசுத்த இடத்தில் இருக்கும் பெட்டியின்மேல் மூடியிருக்கும் கிருபாசனத்திற்கு முன்னால், தான் நினைத்தபோதெல்லாம் வரக்கூடாது என்று அவனிடம் சொல்; மீறினால் அவன் சாவான். ஏனெனில், கிருபாசனத்தின்மேல் நான் ஒரு மேகத்தில் தோன்றுவேன். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“ஆரோன் பரிசுத்த இடத்திற்குள் போகவேண்டிய விதம் இதுவே: பாவநிவாரண காணிக்கையாக ஒரு இளங்காளையோடும், தகன காணிக்கையாக ஒரு செம்மறியாட்டுக்கடாவோடும் அவன் வரவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","அப்பொழுது அவன் தன் உடலோடு ஒட்டிக்கொள்ளும் மென்பட்டு உடையையும், பரிசுத்த மென்பட்டு உள் அங்கியையும் உடுத்திக்கொள்ளவேண்டும். மென்பட்டுக் கச்சையை இடையில் கட்டி, மென்பட்டு தலைப்பாகையையும் அணிந்துகொள்ள வேண்டும். இவையே பரிசுத்த உடைகள். எனவே அவன் இவற்றை உடுத்திக்கொள்ளும் முன், தன்னைச் சுத்தப்படுத்துவதற்காக தண்ணீரில் முழுகவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","அதன்பின் அவன் இஸ்ரயேல் சமுதாயத்தினரிடமிருந்து பாவநிவாரண காணிக்கைக்காக இரண்டு வெள்ளாட்டுக் கடாக்களையும், தகன காணிக்கைக்காக ஒரு செம்மறியாட்டுக் கடாவையும் எடுத்துக்கொண்டு உள்ளே வரவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“ஆரோன் தனக்காகவும் தன் குடும்பத்தாருக்காகவும் பாவநிவிர்த்தி செய்யும்படி, தன் சொந்தப் பாவநிவாரண காணிக்கையாக அக்காளையைச் செலுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","பின்பு அந்த இரண்டு வெள்ளாட்டுக் கடாக்களையும் சபைக்கூடார வாசலில், யெகோவா முன்னிலையில் நிறுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","ஆரோன் இரண்டு வெள்ளாட்டுக் கடாக்களின் மேலும் சீட்டுப்போட்டு ஒன்றை யெகோவாவுக்காகவும், இன்னொன்றைப் பாவச்சுமை ஆடாகவும் வேறுபிரிக்க வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","யெகோவாவுக்காக சீட்டு விழுந்த வெள்ளாட்டுக்கடாவை ஆரோன் கொண்டுவந்து பாவநிவாரண காணிக்கையாகப் பலியிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","சீட்டின் மூலம் பாவச்சுமை ஆடாக தேர்ந்தெடுக்கப்பட்ட வெள்ளாட்டை, யெகோவா முன்னிலையில் உயிரோடே நிறுத்தவேண்டும். அது பாவநிவிர்த்தி செய்வதற்காக பாலைவனத்தில் தப்பிப்போக விடப்படவேண்டிய ஆடு. ");
INSERT INTO tamtcv_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“பின்பு ஆரோன் தனக்காகவும், தன் குடும்பத்திற்காகவும் பாவநிவிர்த்தி செய்யும்படி, தன்னுடைய சொந்த பாவநிவாரண காணிக்கையாக அக்காளையைக் கொண்டுவர வேண்டும். அவன் தன் சொந்தப் பாவநிவாரண காணிக்கையாக அக்காளையை வெட்டிக் கொல்லவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","அவன் யெகோவா முன்னிலையில் இருக்கும் பலிபீடத்திலிருந்து நெருப்புத்தணல் நிறைந்த ஒரு தூபகிண்ணத்தை எடுத்துக்கொண்டு, இரண்டு கைநிறைய நன்றாக அரைக்கப்பட்ட நறுமணத்தூளையும் எடுத்துக்கொண்டு திரைக்குப் பின்னால் வரவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","அவன் அந்த நறுமணத்தூளை யெகோவாவுக்கு முன்பாக நெருப்பில் போடவேண்டும். அந்த நறுமணப்புகை சாட்சிப்பெட்டியின் மேலிருக்கும் கிருபாசனத்தை மூடும். அப்பொழுது அவன் சாகமாட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","அவன் தனது விரலினால் அக்காளையின் இரத்தத்தில் சிறிதளவு எடுத்து, கிருபாசனத்தின் முன்பக்கத்தில் தெளிக்கவேண்டும். அதன்பின் அதில் சிறிதளவு எடுத்து கிருபாசனத்தின் முன்னால் ஏழுமுறை தன் விரலினால் தெளிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“பின்பு மக்களுக்கான பாவநிவாரண காணிக்கையாக வெள்ளாட்டுக் கடாவைக் கொல்லவேண்டும். அதன் இரத்தத்தை திரைக்குப் பின்னால் எடுத்துச்சென்று, காளையின் இரத்தத்தைக்கொண்டு செய்ததுபோல, இதைக்கொண்டும் செய்யவேண்டும். அதாவது அந்த இரத்தத்தை கிருபாசனத்தின் மேலும், அதன் முன்பக்கத்திலும் தெளிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","இவ்வாறாக அவன் மகா பரிசுத்த இடத்திற்காகப் பாவநிவிர்த்தி செய்யவேண்டும். இஸ்ரயேலரின் பாவம் எதுவாயினும், அவர்களுடைய அசுத்தத்திற்காகவும், கலகத்திற்காகவும் இவ்வாறு செய்யவேண்டும். அவர்களுடைய அசுத்தத்தின் மத்தியில் அவர்களிடையே இருக்கும் சபைக் கூடாரத்திற்காகவும், இவ்விதமாகவே செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","ஆரோன் பாவநிவிர்த்தி செய்யும்படி, மகா பரிசுத்த இடத்திற்குள் போகிற நேரந்தொடங்கி, அவன் தனக்காகவும், தன் குடும்பத்தினருக்காகவும், முழு இஸ்ரயேல் சமுதாயத்தினருக்காகவும் பாவநிவிர்த்தி செய்து வெளியே வரும்வரை, சபைக் கூடாரத்தில் ஒருவரும் இருக்கக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“பின்பு அவன் வெளியே வந்து யெகோவாவுக்கு முன்பாக உள்ள பலிபீடத்திற்காக பாவநிவிர்த்தி செய்யவேண்டும். அவன் காளையின் இரத்தத்தில் கொஞ்சமும், வெள்ளாட்டின் இரத்தத்தில் கொஞ்சமும் எடுத்து, பலிபீடத்தின் எல்லா கொம்புகளின்மேலும் பூசவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","அவன் இஸ்ரயேலரின் அசுத்தத்திலிருந்து பலிபீடத்தைச் சுத்திகரித்து, அதை அர்ப்பணம் செய்யும்படி அந்த இரத்தத்தில் கொஞ்சத்தை தன் விரல்களினால் அதன்மேல் ஏழுமுறை தெளிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“ஆரோன் மகா பரிசுத்த இடத்திற்காகவும், சபைக் கூடாரத்திற்காகவும், பலிபீடத்திற்காகவும் பாவநிவிர்த்தி செய்து முடித்தபின், அவன் அந்த உயிருள்ள ஆட்டை முன்பாக கொண்டுவர வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","ஆரோன் தன் இரண்டு கைகளையும் அந்த உயிருள்ள ஆட்டின் தலையின்மேல் வைத்து, இஸ்ரயேலரின் எல்லா பாவங்களான எல்லா கொடுமையையும், கலகத்தையும் அந்த ஆட்டின் மேலாக அறிக்கையிட்டு, அவற்றை அந்த ஆட்டின் தலையின்மேல் சுமத்தவேண்டும். அவன் அந்த வெள்ளாட்டைப் பாலைவனத்திற்கு அனுப்பிவிடும்படி அதற்காக நியமிக்கப்பட்ட ஒருவனின் பொறுப்பில் அதைக்கொடுத்து அனுப்பிவிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","அந்த வெள்ளாடு அவர்களுடைய எல்லா பாவங்களையும் தன்மேல் சுமந்துகொண்டு, தனிமையான ஒரு இடத்திற்குப் போகும். அந்த மனிதன் அதை பாலைவனத்தில் விட்டுவிட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“பின்பு ஆரோன் சபைக் கூடாரத்திற்குப் போய், தான் மகா பரிசுத்த இடத்திற்குப் போகுமுன் உடுத்திக்கொண்ட மென்பட்டு உடைகளைக் களைந்து, அவற்றை அங்கே வைத்துவிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","அவன் ஒரு தூய்மையான இடத்திலே முழுகி, மீண்டும் தனது உடைகளை உடுத்திக்கொள்ளவேண்டும். பின் அவன் வெளியே வந்து, தனக்காகவும், மக்களுக்காகவும் பாவநிவிர்த்தி செய்யும்படி, தனக்கான தகன காணிக்கையையும், மக்களுக்கான தகன காணிக்கையையும் செலுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","பாவநிவாரண காணிக்கை பலியின் கொழுப்பையும் அவன் பலிபீடத்தின்மேல் எரிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“பாவச்சுமை ஆடான வெள்ளாட்டைப் பாலைவனத்தில் போகவிடும் மனிதன், தன் உடைகளைக் கழுவி தண்ணீரில் முழுகவேண்டும். அதன்பின் அவன் முகாமுக்குள் வரலாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","பாவநிவாரண காணிக்கையாக வெட்டப்பட்டதும், இரத்தம் பாவநிவிர்த்தி செய்யும்படி மகா பரிசுத்த இடத்திற்கு கொண்டுவரப்பட்டதுமான, காளையினுடைய, வெள்ளாட்டினுடைய மீதமுள்ள பாகங்கள் முகாமுக்கு வெளியே எடுத்துச்செல்லப்பட வேண்டும். அவற்றின் தோல்களையும், இறைச்சியையும், குடல்களையும் எரிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","இவைகளை எரிக்கிறவன் தன் உடைகளைக் கழுவி, தானும் தண்ணீரில் முழுகவேண்டும். அதன்பின் அவன் முகாமுக்குள் வரலாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“இது உங்களுக்கு நிரந்தரமான கட்டளை. ஏழாம் மாதம் பத்தாம் நாளிலே உங்களை ஒடுக்கி உபவாசம் இருக்கவேண்டும். நீங்கள் எந்தவித வேலையையும் செய்யக்கூடாது. தன் நாட்டினனானாலும், உங்கள் மத்தியில் வாழும் பிறநாட்டினனானாலும் வேலைசெய்யக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","ஏனெனில் இந்த நாளில் உங்களைச் சுத்திகரிக்கும்படி உங்களுக்காகப் பாவநிவிர்த்தி செய்யப்படும். அப்பொழுது நீங்கள் யெகோவா முன்னிலையில் உங்கள் பாவங்கள் எல்லாம் நீக்கப்பட்டு சுத்தமுள்ளவர்களாய் இருப்பீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","இது உங்களுக்கு முழுமையாக இளைப்பாறும் ஓய்வுநாள். இந்நாளில், நீங்கள் உங்களை ஒடுக்கி உபவாசம் இருக்கவேண்டும். இது ஒரு நிரந்தர கட்டளை. ");
INSERT INTO tamtcv_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","அபிஷேகம் பெற்றவனும், தன் தகப்பனின் இடத்துக்குத் தலைமை ஆசாரியனாக நியமிக்கப்பட்ட ஆசாரியனும் பாவநிவிர்த்தி செய்யவேண்டும். அவன் பரிசுத்தமான மென்பட்டு உடைகளை உடுத்திக்கொண்டு, ");
INSERT INTO tamtcv_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","மகா பரிசுத்த இடத்திற்காகவும், சபைக் கூடாரத்திற்காகவும், பலிபீடத்திற்காகவும், ஆசாரியருக்காகவும், சமுதாயத்தின் மக்கள் அனைவருக்காகவும் பாவநிவிர்த்தி செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“இது உங்களுக்கு ஒரு நிரந்தர கட்டளையாய் இருக்கவேண்டும். வருடத்தில் ஒருமுறை இஸ்ரயேலருடைய எல்லா பாவங்களுக்காகவும் பாவநிவிர்த்தி செய்யப்படவேண்டும்” என்றார். யெகோவா மோசேக்குக் கட்டளையிட்டபடியே அது செய்யப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“நீ ஆரோனிடமும் அவன் மகன்களிடமும், இஸ்ரயேலரிடமும் பேசி, அவர்களுக்குச் சொல்லவேண்டியதாவது, ‘யெகோவா கட்டளையிட்டது இதுவே: ");
INSERT INTO tamtcv_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","இஸ்ரயேலன் எவனும் பலி செலுத்துவதற்காக, முகாமுக்குள் அல்லது முகாமுக்கு வெளியே ஒரு மாட்டையோ, செம்மறியாட்டுக் குட்டியையோ, வெள்ளாட்டையோ வெட்டிக் கொன்றால் அது ஏற்றுக்கொள்ளப்படமாட்டாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ஏனெனில் அந்த மிருகங்களை யெகோவாவுக்குக் காணிக்கையாகச் செலுத்தும்படி, யெகோவாவின் இறைசமுகக் கூடாரத்திற்கு முன்பாக சபைக் கூடாரவாசலுக்கு கொண்டுவந்து வெட்டவில்லை. அதனால் அவன் இரத்தம் சிந்திய குற்றவாளியாக எண்ணப்படுவான். அவன் இரத்தம் சிந்தியிருக்கிறான். அவன் தன் மக்கள் மத்தியில் இருந்து அகற்றப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","இதனால் இஸ்ரயேலர் தாம் இப்பொழுது திறந்தவெளிகளில் செலுத்தும் பலிகளை யெகோவாவிடத்தில் கொண்டுவர வேண்டும். அவர்கள் அவற்றை ஆசாரியனிடம், அதாவது யெகோவாவிடம், சபைக்கூடார வாசலுக்குக் கொண்டுவந்து, சமாதான காணிக்கையாகப் பலியிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","ஆசாரியன், சபைக்கூடார வாசலில் இருக்கும் யெகோவாவின் பலிபீடத்தில் இரத்தத்தைத் தெளித்து, கொழுப்பை யெகோவாவுக்கு மகிழ்ச்சியூட்டும் நறுமணமாக எரிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","அவர்கள் எந்த ஆட்டின் உருவமுடைய விக்கிரங்களைப் பின்பற்றி வேசித்தனம் பண்ணுகிறார்களோ, அவைகளுக்கு இனிமேலும் அவர்கள் பலிகளைச் செலுத்தக்கூடாது. இது அவர்களுக்கும், அவர்களுடைய தலைமுறைகளுக்கும் ஒரு நிரந்தர நியமமாய் இருக்கவேண்டும்.’ ");
INSERT INTO tamtcv_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“மேலும் நீ அவர்களிடம் சொல்லவேண்டியதாவது: ‘எந்த ஒரு இஸ்ரயேலனோ அல்லது அவர்கள் மத்தியில் வாழும் எந்த பிறநாட்டினனோ, ஒரு தகன காணிக்கையையாவது பலியையாவது செலுத்தும்போது, ");
INSERT INTO tamtcv_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","அதை யெகோவாவுக்குப் பலியிடுவதற்காக, சபைக்கூடார வாசலுக்குக் கொண்டுவராவிட்டால், அவன் தன் மக்களிலிருந்து அகற்றப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘எந்த ஒரு இஸ்ரயேலனாவது அல்லது அவர்களுக்குள் வாழும் ஒரு பிறநாட்டினனாவது, எந்த இரத்தத்தையாகிலும் சாப்பிடுவானாகில், இரத்தத்தைச் சாப்பிட்டவனுக்கு விரோதமாக நான் என் முகத்தைத் திருப்பி, அவனை அவனுடைய மக்களிலிருந்து அகற்றிவிடுவேன். ");
INSERT INTO tamtcv_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","ஏனெனில் ஒரு உயிரினத்தின் உயிர் இரத்தத்தில் உள்ளது. பலிபீடத்தின்மேல் உங்களுக்காகப் பாவநிவிர்த்தி செய்யும்படி நான் அதை உங்களுக்குக் கொடுத்திருக்கிறேன். ஒருவனது வாழ்வுக்காகப் பாவநிவிர்த்தி செய்வது இரத்தமே. ");
INSERT INTO tamtcv_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","ஆகவே நான் இஸ்ரயேலரிடம், “உங்களில் ஒருவனும் இரத்தத்தைச் சாப்பிடக்கூடாது, உங்கள் மத்தியில் தங்கும் பிறநாட்டினனும் இரத்தத்தைச் சாப்பிடக்கூடாது” என்று சொல்லியிருக்கிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘சாப்பிடக்கூடிய மிருகத்தையோ, பறவையையோ வேட்டையாடுகிற எந்த இஸ்ரயேலனாவது அல்லது உங்கள் மத்தியில் வாழும் எந்த பிறநாட்டினனாவது அதன் இரத்தத்தை வெளியே வடியவிட்டு அதை மண்ணால் மூடிவிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","ஏனெனில், ஒவ்வொரு உயிரினத்தின் உயிரும் அதன் இரத்தமே. ஆகவேதான் நான் இஸ்ரயேலரிடம், “நீங்கள் எந்த உயிரினத்தின் இரத்தத்தையும் சாப்பிடவேண்டாம். ஏனெனில், ஒவ்வொரு உயிரினத்தின் உயிரும் அதன் இரத்தமே; அதைச் சாப்பிடுகிற எவனும் அகற்றப்படவேண்டும் என்றேன்.” ");
INSERT INTO tamtcv_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘தன் நாட்டினனோ அல்லது பிறநாட்டினனோ, இறந்துகிடக்கக் காணப்பட்டதை அல்லது காட்டு மிருகங்களால் கிழிக்கப்பட்டுச் செத்ததை ஒருவன் சாப்பிட்டால், அவன் தன் உடைகளைக் கழுவி தண்ணீரில் முழுகவேண்டும். அவன் சம்பிரதாய முறைப்படி மாலைவரை அசுத்தமானவன். அதன்பின் அவன் சுத்தமாவான். ");
INSERT INTO tamtcv_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","ஆனால் அவன் உடைகளைக் கழுவி முழுகாவிட்டால், அந்தக் குற்றத்திற்கு அவனே பொறுப்பாளியாவான்’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“நீ இஸ்ரயேலரிடம் பேசி அவர்களுக்குச் சொல்லவேண்டியதாவது: ‘நான் உங்கள் இறைவனாகிய யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","நீங்கள் முன்பு வாழ்ந்துவந்த எகிப்தில், உள்ளவர்கள் செய்ததுபோல் நீங்களும் செய்யவேண்டாம். நான் உங்களை அழைத்துச் செல்லும் கானான் நாட்டில் உள்ளவர்கள் செய்கிறதுபோலவும் செய்யவேண்டாம். அவர்களின் நடைமுறைகளைப் பின்பற்றவும் வேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","நீங்களோ என்னுடைய சட்டங்களுக்குக் கீழ்ப்படிந்து, என் கட்டளைகளைப் பின்பற்றக் கவனமாயிருங்கள். நான் உங்கள் இறைவனாகிய யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","ஆகவே நீங்கள் என்னுடைய கட்டளைகளையும் சட்டங்களையும் கைக்கொள்ளுங்கள். ஏனெனில் அவற்றிற்குக் கீழ்ப்படிகிறவன் எவனும் அவற்றால் வாழ்வு பெறுவான். நானே யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘பாலுறவுகொள்ளும்படி யாரும் நெருங்கிய உறவினரை அணுகக்கூடாது. நானே யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘நீ உன் தாயுடன் பாலுறவுகொண்டு, உன் தகப்பனை கனவீனப்படுத்தாதே. அவள் உன் தாய். அவளுடன் பாலுறவு கொள்ளாதே. ");
INSERT INTO tamtcv_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘நீ உன் தகப்பனின் மனைவியுடன் பாலுறவு கொள்ளாதே. அது உன் தகப்பனைக் கனவீனப்படுத்தும். ");
INSERT INTO tamtcv_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘நீ உன் சகோதரியுடன் பாலுறவு கொள்ளாதே. உன் தகப்பனின் மகளோடு அல்லது உன் தாயின் மகளோடு பாலுறவு கொள்ளாதே. அவள் உன் வீட்டிலோ அல்லது வேறு இடத்திலோ பிறந்திருந்தாலும் சரி, அவளுடன் பாலுறவு கொள்ளாதே. ");
INSERT INTO tamtcv_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘உன் மகனுடைய மகளோடு, உன் மகளின் மகளோடு பாலுறவு கொள்ளாதே. அதுவும் உன்னைக் கனவீனப்படுத்தும். ");
INSERT INTO tamtcv_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘உன் தகப்பனுக்குப் பிறந்த, உன் தகப்பனின் மனைவியின் மகளுடன் பாலுறவு கொள்ளாதே. அவளும் உனக்குச் சகோதரிதான். ");
INSERT INTO tamtcv_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘உன் தகப்பனுடைய சகோதரியுடன் பாலுறவு கொள்ளாதே. அவள் உன் தகப்பனுடைய நெருங்கிய உறவினள். ");
INSERT INTO tamtcv_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘உன் தாயின் சகோதரியுடன் பாலுறவு கொள்ளாதே; ஏனெனில் அவள் உன் தாயினுடைய நெருங்கிய உறவினள். ");
INSERT INTO tamtcv_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘உன் தகப்பனுடைய சகோதரனின் மனைவியுடன் பாலுறவு கொள்வதற்காக, அவளை நெருங்குவதினால் அவனைக் கனவீனப்படுத்தாதே. அவள் உன்னுடைய சிறியதாய். ");
INSERT INTO tamtcv_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘உன் மருமகளுடன் பாலுறவு கொள்ளாதே. அவள் உன் மகனின் மனைவி; அவளுடனும் பாலுறவு கொள்ளாதே. ");
INSERT INTO tamtcv_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘உன் சகோதரனுடைய மனைவியுடன் பாலுறவு கொள்ளாதே. அது உன் சகோதரனைக் கனவீனப்படுத்தும். ");
INSERT INTO tamtcv_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘தாயும் மகளுமான இருவருடனும் பாலுறவு கொள்ளாதே. அவளுடைய மகனின் மகளோடு, மகளின் மகளோடு பாலுறவு கொள்ளாதே. இவர்களும் அவளுக்கு நெருங்கிய உறவுள்ளவர்கள். இது ஒரு கொடுமையான செயல். ");
INSERT INTO tamtcv_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘உன் மனைவி உயிரோடிருக்கையில், அவளுக்குப் போட்டியாக, அவள் சகோதரியை உனக்கு மனைவியாக்கி அவளுடன் பாலுறவு கொள்ளலாகாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘ஒரு பெண் மாதவிடாய் காலத்தில் அசுத்தமாய் இருக்கும்போது, பாலுறவுகொள்ளும்படி அவளை நெருங்காதே. ");
INSERT INTO tamtcv_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘உங்கள் அயலானின் மனைவியுடன் பாலுறவுகொண்டு அவளால் உங்களை அசுத்தப்படுத்த வேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘நீங்கள் உங்கள் பிள்ளைகள் ஒருவரையும், மோளேக்கு தெய்வத்திற்குப் பலியிடப்படுவதற்காகக் கொடுத்து, உங்கள் இறைவனுடைய பெயரை இழிவுபடுத்த வேண்டாம். நானே யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘நீங்கள் ஒரு பெண்ணோடு பாலுறவு கொள்வதுபோல், ஆணோடு பாலுறவுகொள்ள வேண்டாம். அது அருவருப்பானது. ");
INSERT INTO tamtcv_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘எந்தவொரு மிருகத்தோடும் நீங்கள் பாலுறவுகொண்டு அதினாலே உங்களை அசுத்தப்படுத்த வேண்டாம். எந்த ஒரு பெண்ணும் மிருகத்தோடு பாலுறவுகொள்ளும்படி, தன்னை ஒப்புவிக்கக் கூடாது. அது இயல்பிற்கு முரணான பாலுறவாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘இவ்வாறான தீயசெயல்களினால் உங்களை அசுத்தப்படுத்தாதீர்கள். ஏனெனில், நான் உங்களுக்கு முன்பாகத் துரத்திவிடப்போகும் நாட்டினர் இவ்விதமாகவே அசுத்தமாகினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","இவ்விதமாய் நாடும் அசுத்தப்பட்டது. எனவே அதன் பாவத்திற்காக நான் அதைத் தண்டித்தேன். நாடும் அதன் குடிகளை வாந்திபண்ணியது. ");
INSERT INTO tamtcv_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","ஆனால் நீங்களோ எனது சட்டங்களையும், கட்டளைகளையும் கைக்கொள்ளவேண்டும். தன் நாட்டினனானாலும், உங்களுக்குள் வாழும் பிறநாட்டினனானாலும், யாரும் இந்த அருவருப்பான ஒன்றையும் செய்யக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","ஏனெனில், உங்களுக்கு முன்னே இந்நாட்டில் வாழ்ந்த மக்கள் இந்தச் செயல்களையெல்லாம் செய்தார்கள். நாடும் அசுத்தமடைந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","நாட்டை நீங்கள் அசுத்தப்படுத்தினால், உங்களுக்கு முன்னே அங்கே வாழ்ந்த நாட்டினரை அது வாந்திபண்ணியதுபோல, உங்களையும் அது வாந்திபண்ணிவிடும். ");
INSERT INTO tamtcv_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘யாராவது இந்த அருவருப்பான செயல்களில் எதையாவது செய்தால், அப்படிப்பட்டவர்கள் தங்கள் மக்களிலிருந்து அகற்றப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","ஆகவே நீங்கள் என் கட்டளையைக் கைக்கொள்ளுங்கள். நீங்கள் வரும் முன்பு அங்கு நடைமுறைப்படுத்தப்பட்ட இந்த அருவருப்பான வழக்கங்களில் எதையாவது பின்பற்றி, அவற்றால் உங்களை அசுத்தப்படுத்த வேண்டாம். நானே உங்கள் இறைவனாகிய யெகோவா’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“நீ இஸ்ரயேல் மக்கள் அனைவரிடமும் பேசி, அவர்களுக்குச் சொல்லவேண்டியதாவது: ‘உங்கள் இறைவனாகிய யெகோவாவான நான் பரிசுத்தர், நீங்களும் பரிசுத்தராய் இருங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘நீங்கள் ஒவ்வொருவரும் உங்கள் தகப்பனுக்கும், தாய்க்கும் மரியாதை கொடுக்கவேண்டும். என்னுடைய ஓய்வுநாளைக் கைக்கொள்ளவேண்டும். நானே உங்கள் இறைவனாகிய யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘நீங்கள் விக்கிரகங்களிடம் திரும்பவேண்டாம். வார்க்கப்படும் உலோகத்தினால் உங்களுக்காக தெய்வங்களைச் செய்யவும் வேண்டாம். நானே உங்கள் இறைவனாகிய யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘நீங்கள் யெகோவாவுக்குச் சமாதான காணிக்கையைப் பலியிடும்போது, அது உங்கள் சார்பாக ஏற்றுக்கொள்ளப்படும் விதத்தில் அதைப் பலியிடுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","அது பலியிடப்படுகிற நாளிலும், அதற்கு அடுத்த நாளிலுமே அதைச் சாப்பிடவேண்டும். மூன்றாம் நாள்வரை மீதமிருக்கும் எதையும் எரித்துவிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","மூன்றாம் நாளில் அதில் எதையும் சாப்பிட்டால் அது அசுத்தமானது. அக்காணிக்கை ஏற்றுக்கொள்ளப்படமாட்டாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","அதைச் சாப்பிடுகிற எவனும், யெகோவாவுக்குப் பரிசுத்தமானதைத் தூய்மைக்கேடாக்கினபடியால், அக்குற்றத்திற்கு அவனே பொறுப்பாளி. அவன் தன் மக்களிலிருந்து அகற்றப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘நீங்கள் உங்கள் வயலின் விளைச்சலை அறுவடை செய்யும்போது, வயலின் ஓரங்களில் இருக்கும் கதிர்களை முற்றிலுமாக அறுவடை செய்யாமலும், சிந்திக் கிடக்கும் கதிரையும் பொறுக்காமலும் விட்டுவிடுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","அப்படியே உங்கள் திராட்சைத்தோட்டத்திலும், இரண்டாம்முறை பறிக்காமலும், விழுந்ததைப் பொறுக்காமலும் விடுங்கள். அவைகளை ஏழைகளுக்கும் பிறநாட்டினருக்கும் விட்டுவிடுங்கள். நானே உங்கள் இறைவனாகிய யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘களவு செய்யவேண்டாம். “ ‘பொய் சொல்லவேண்டாம். “ ‘ஒருவரையொருவர் ஏமாற்றவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘என் பெயரைக்கொண்டு பொய்யாய் ஆணையிடுவதினால் உங்கள் இறைவனின் பெயருக்கு இழிவு உண்டாக்க வேண்டாம். நானே யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘நீங்கள் உங்கள் அயலானை மோசடி செய்து, அவனைக் கொள்ளையிடாதீர்கள். “ ‘கூலிக்காரனுடைய கூலியை அடுத்தநாள்வரை கொடுக்காமல் வைத்திருக்கவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘செவிடனை சபிக்காமலும், குருடனின் வழியில் தடையேதும் போடாமலும் உங்கள் இறைவனுக்குப் பயந்து நடவுங்கள். நானே யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘நீதியைப் புரட்டவேண்டாம்; ஏழையை ஒடுக்கவேண்டாம். செல்வந்தர்களுக்குச் சலுகைகாட்ட வேண்டாம். ஆனால் உங்கள் அயலானுக்கு நியாயமாகத் தீர்ப்பு வழங்குங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘நீங்கள் உங்கள் மக்களுக்குள் அவதூறு பேசுகிறவர்களாகத் திரியாதீர்கள். “ ‘உங்கள் அயலானின் உயிருக்கு ஆபத்து உண்டாக்கும் எதையும் செய்யவேண்டாம். நானே யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘உங்கள் இருதயத்தில் உங்கள் சகோதரனை வெறுக்க வேண்டாம். உங்கள் அயலானின் குற்றத்தில் நீங்களும் பங்குகொள்ளாதபடி அவனை வெளிப்படையாகக் கடிந்துகொள்ளுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘பழிவாங்கத் தேடவேண்டாம். உங்கள் மக்களில் யாருக்கெதிராகவும் வன்மங்கொள்ள வேண்டாம். நீ உன்னில் அன்பாயிருப்பதுபோல் உன் அயலானிடத்திலும் அன்பாய் இரு. நானே யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘நீங்கள் என் கட்டளைகளைக் கைக்கொள்ளவேண்டும். “ ‘வெவ்வேறு வகையான மிருகங்களை ஒன்றோடு ஒன்று புணரவிடவேண்டாம். “ ‘இரண்டு வகையான விதைகளை ஒன்றாய் கலந்து வயலில் விதைக்கவும் வேண்டாம். “ ‘இரண்டு வகையான நூல்களைக்கொண்டு நெய்யப்பட்ட உடைகளை உடுத்தவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘மீட்டுக்கொள்ளப்படாமலும், விடுதலை அடையாமலும் ஒருவனுக்கு நியமிக்கப்பட்டிருக்கும் ஒரு அடிமைப் பெண்ணுடன் வேறு யாராவது உறவுகொண்டால், அதற்குத் தகுந்த தண்டனை கொடுக்கப்படவேண்டும். ஆனாலும் அவர்கள் கொல்லப்படக்கூடாது. ஏனெனில், அவள் விடுதலை பெற்றிருக்கவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","ஆனாலும் அவன் தான் செய்த குற்றத்திற்காக ஒரு செம்மறியாட்டுக் கடாவை குற்றநிவாரண காணிக்கையாக யெகோவா முன்னிலையில் சபைக்கூடார வாசலுக்குக் கொண்டுவர வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","ஆசாரியன் அக்குற்றநிவாரண காணிக்கைக்கான செம்மறியாட்டுக் கடாவைக் கொண்டு அவன் செய்த பாவத்திற்காக யெகோவா முன்னிலையில், பாவநிவிர்த்தி செய்யவேண்டும். அப்பொழுது அவன் செய்த பாவம் அவனுக்கு மன்னிக்கப்படும். ");
INSERT INTO tamtcv_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘நீங்கள் உங்கள் நாட்டிற்குள்போய் கனிகொடுக்கும் மரங்களை நாட்டும்போது, அதன் பழங்களை உண்பதற்கு, முதல் மூன்று வருடங்களும் தடை செய்யப்பட்டவைகளாக எண்ணிக்கொள்ளுங்கள்; அவற்றைச் சாப்பிடக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","நான்காம் வருடத்தில் அதன் பழங்கள் எல்லாம் பரிசுத்தமாய் இருக்கும். அவை யெகோவாவுக்குத் துதியின் காணிக்கையாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","ஆனால் ஐந்தாம் வருடத்தில் உண்டாகும் பழங்களை நீங்கள் சாப்பிடலாம். இவ்வாறாக உங்கள் அறுவடை பெருகும். நானே உங்கள் இறைவனாகிய யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘எந்த இறைச்சியையும் அதன் இரத்தத்துடன் சாப்பிடவேண்டாம். “ ‘குறி கேட்கவோ, சகுனம் பார்க்கவோ வேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘உங்கள் தலைமுடியின் ஓரங்களை வெட்டாமலும், உங்கள் தாடியின் ஓரங்களைக் கத்தரியாமலும் இருங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘இறந்தவர்களுக்காக உங்கள் உடல்களைக் கீறி காயப்படுத்தவேண்டாம். உங்கள் உடல்களில் பச்சை குத்தவும் வேண்டாம். நான் யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘நீங்கள் உங்கள் மகளை வேசியாக்குவதினால், அவளை இழிவுபடுத்தாதீர்கள். மீறினால், நாடு வேசித்தனத்திற்குத் திரும்பி, கொடுமையினால் நிறையும். ");
INSERT INTO tamtcv_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘நீங்கள் என்னுடைய ஓய்வுநாட்களை அனுசரித்து, என் பரிசுத்த இடத்தைக் குறித்து பயபக்தியாயிருங்கள். நான் யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘அஞ்சனம் பார்க்கிறவர்களின் பக்கம் போகவேண்டாம். குறிசொல்லுகிறவர்களை தேடவும் வேண்டாம். ஏனெனில், இவற்றால் நீங்கள் அசுத்தமடைவீர்கள். நானே உங்கள் இறைவனாகிய யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘வயதானவர்களின் முன் எழுந்து நில்லுங்கள். முதியோருக்கு மரியாதை செலுத்துங்கள். உங்கள் இறைவனிடத்தில் பயபக்தியாயிருங்கள். நானே யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘ஒரு பிறநாட்டினன் உங்கள் நாட்டில் உங்களுடன் தங்கியிருந்தால், அவனை ஒடுக்காதீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","உங்களோடு வாழும் எந்த பிறநாட்டினனும் உங்களுடைய நாட்டினனைப்போல நடத்தப்படவேண்டும். உங்களைப்போல் அவனிலும் அன்பு செலுத்துங்கள். ஏனெனில் முன்பு ஒருகாலத்தில் நீங்களும் எகிப்து நாட்டில் பிறநாட்டினராய் இருந்தீர்கள். நானே உங்கள் இறைவனாகிய யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘நீளம், நிறை, கொள்ளளவு ஆகியவற்றை அளக்கும்போது, நீதியற்ற அளவுகளைப் பயன்படுத்த வேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","சரியான தராசையும், சரியான படிக்கற்களையும், சரியான எப்பா அளவையும் சரியான ஹின் அளவையும் பயன்படுத்த வேண்டும். உங்களை எகிப்து நாட்டிலிருந்து வெளியே கொண்டுவந்த நானே உங்கள் இறைவனாகிய யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘ஆகவே நீங்கள் என்னுடைய எல்லா கட்டளைகளையும், என்னுடைய எல்லா சட்டங்களையும் கைக்கொண்டு அவற்றைப் பின்பற்றுங்கள். நானே யெகோவா’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“மேலும் நீ இஸ்ரயேல் மக்களுக்கு சொல்லவேண்டியதாவது, ‘இஸ்ரயேலனாவது, இஸ்ரயேலில் வாழும் பிறநாட்டினனாவது, தங்கள் பிள்ளைகளை மோளேக்கு தெய்வத்திற்குக் கொடுத்தால், அவன் கொல்லப்படவேண்டும். மக்கள் சமுதாயம் அவனைக் கல்லெறிந்து கொல்லவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","நான் என் முகத்தை அவனுக்கு விரோதமாக்கி, அவனுடைய மக்களிலிருந்து அவனை அகற்றுவேன். ஏனெனில், தன் பிள்ளைகளை மோளேக்கு தெய்வத்திற்குக் கொடுத்ததினால் அவன் என் பரிசுத்த இடத்தை அசுத்தப்படுத்தி, என் பரிசுத்த பெயரையும் இழிவுபடுத்தினான். ");
INSERT INTO tamtcv_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","அவன் தன் பிள்ளைகளில் ஒன்றை மோளேக்கு தெய்வத்திற்குக் கொடுக்கிறபோது மக்கள் சமுதாயம் அவனைக் கொலைசெய்யத் தவறி, தங்கள் கண்களை மூடிக்கொண்டால், ");
INSERT INTO tamtcv_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","நான் என் முகத்தை அவனுக்கு விரோதமாகவும், அவன் குடும்பத்திற்கு விரோதமாகவும் திருப்புவேன். நான் அவனையும், எனக்கெதிராக மோளேக்கு தெய்வத்திடம் வேசித்தனத்திற்குத் தங்களை ஒப்புக்கொடுத்த, அவனைப் பின்பற்றுகிற யாவரையும் அவர்களுடைய மக்களிலிருந்து அகற்றுவேன். ");
INSERT INTO tamtcv_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘ஜோதிடம் பார்க்கிறவர்களையும், குறிசொல்லுகிறவர்களையும், பின்பற்றி, எனக்கெதிராக வேசித்தனம் செய்ய தன்னை ஒப்புக்கொடுக்கிறவனுக்கு விரோதமாக நான் என் முகத்தைத் திருப்புவேன். நான் அவனுடைய மக்களிலிருந்து அவனை அகற்றிவிடுவேன். ");
INSERT INTO tamtcv_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘நீங்கள் உங்களை அர்ப்பணித்துக் கொண்டு பரிசுத்தராயிருங்கள். ஏனெனில் உங்கள் இறைவனாகிய யெகோவா நானே. ");
INSERT INTO tamtcv_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","நீங்கள் என் கட்டளைகளைக் கைக்கொண்டு அவற்றைப் பின்பற்றுங்கள். நானே உங்களைப் பரிசுத்தமாக்கும் யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘யாராவது தன் தகப்பனையோ, தாயையோ சபித்தால், அவன் கொலைசெய்யப்பட வேண்டும். அவன் தன் தகப்பனையோ, தன் தாயையோ சபித்துவிட்டால், அவனுடைய இரத்தப்பழி அவன் தலையிலேயே இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘ஒருவன் தன் அயலானாகிய ஒருவனுடைய மனைவியோடே விபசாரம் பண்ணினால், அவனும் விபசாரியுமான, அந்த இருவருமே கொல்லப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘ஒருவன் தன் தகப்பனுடைய மனைவியோடே உறவுகொண்டால், அவன் தன் தகப்பனைக் கனவீனப்படுத்திவிட்டான். எனவே அந்த மனிதனும், அந்தப் பெண்ணும் கொலைசெய்யப்பட வேண்டும். அவர்களின் இரத்தப்பழி அவர்கள் தலைகளிலேயே இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘ஒருவன் தன் மருமகளோடு உறவுகொண்டால், இருவரும் கொல்லப்படவேண்டும். அவர்கள் செய்திருப்பது இயல்புக்கு முரணான பாலுறவு. அவர்களுடைய இரத்தப்பழி அவர்கள் தலையிலேயே இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘ஒரு மனிதன் ஒரு பெண்ணுடன் உடலுறவு கொள்வதுபோல், ஒரு ஆணுடன் உறவுகொண்டால், அவர்கள் அருவருப்பானதைச் செய்திருக்கிறார்கள். அவர்கள் இருவருமே கொல்லப்படவேண்டும். அவர்களுடைய இரத்தப்பழி அவர்கள் தலைகளிலேயே இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘ஒருவன் ஒரு பெண்ணையும், அவளுடைய தாயையும் திருமணம் செய்தால் அது கொடுமை. அவனும், அவர்களும் நெருப்பில் எரிக்கப்படவேண்டும். அப்பொழுது உங்களுக்குள் கொடுமை இராது. ");
INSERT INTO tamtcv_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘ஒருவன் ஒரு மிருகத்தோடு பாலுறவு கொண்டால், அவன் கொல்லப்படவேண்டும். அந்த மிருகத்தையும் நீங்கள் கொல்லவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘ஒரு பெண் ஒரு மிருகத்துடன் பாலுறவுகொள்ளும்படி அதை நெருங்கினால், அவளையும், அந்த மிருகத்தையும் கொன்றுவிடுங்கள். அவர்கள் கொல்லப்படவேண்டும். அவர்களுடைய இரத்தப்பழி அவர்கள் தலைகளிலேயே இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘ஒருவன் தன் தகப்பனின் மகளான அல்லது தாயின் மகளான தன் சகோதரியை திருமணம் செய்து, அவர்கள் பாலுறவு கொண்டால் அது அவமானம். அவர்கள் தங்கள் மக்களின் பார்வையிலிருந்து அகற்றப்படவேண்டும். அவன் தன் சகோதரியை அவமானப்படுத்திவிட்டான். அக்குற்றத்திற்கு அவனே பொறுப்பாளி. ");
INSERT INTO tamtcv_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘ஒரு மனிதன் ஒரு பெண்ணின் மாதவிடாய் காலத்தில் அவளுடன் பாலுறவு கொண்டால், அவன் அவளுடைய இரத்தப்போக்கை வெளிப்படுத்தினான். அவளும் அதை நிர்வாணமாக்கினாள். அவர்கள் இருவருமே தங்கள் மக்களிலிருந்து அகற்றப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘ஒருவன் தன் தாயின் சகோதரியுடனோ, தன் தகப்பனுடைய சகோதரியுடனோ பாலுறவு கொள்ளக்கூடாது. ஏனெனில், அது அவனுடைய நெருங்கிய உறவினனைக் கனவீனப்படுத்தும். அவர்கள் இருவருமே அக்குற்றத்திற்குப் பொறுப்பாளிகள். ");
INSERT INTO tamtcv_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘ஒருவன் தன் சிறிய தாயுடன் உறவுகொண்டால், அவன் தன் சிறிய தகப்பனைக் கனவீனப்படுத்தினான். அக்குற்றத்திற்கு அவர்களே பொறுப்பாளிகள். அவர்கள் பிள்ளைப்பேறு அற்றவர்களாய்ச் சாவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘ஒரு மனிதன் தன் சகோதரனுடைய மனைவியைத் திருமணம் செய்தால், அது ஒரு அசுத்தமான செயல். அவன் தன் சகோதரனை கனவீனப்படுத்திவிட்டான். எனவே அவர்கள் இருவரும் பிள்ளைப்பேறு இல்லாதிருப்பார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘என் கட்டளைகளையும், சட்டங்களையும் கடைப்பிடித்து, அவற்றைப் பின்பற்றுங்கள். அப்பொழுது, நீங்கள் வாழும்படி நான் உங்களைக் கொண்டுவந்து சேர்க்கும் நாடு, உங்களை வாந்திபண்ணாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","நான் உங்கள் முன்னிலையிலிருந்து துரத்திவிடப் போகிற நாட்டினருடைய பழக்கவழக்கங்களின்படி நீங்கள் வாழக்கூடாது. அவர்கள் இந்தச் செயல்களைச் செய்ததினால், நான் அவர்களை அருவருத்து வெறுத்துவிட்டேன். ");
INSERT INTO tamtcv_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","நீங்கள் அவர்களுடைய நாட்டை உரிமையாக்கிக்கொள்வீர்கள். “பாலும் தேனும் ஓடும் அந்நாட்டை உங்களுக்கு உரிமைச்சொத்தாகக் கொடுப்பேன்” என்று உங்களுக்குச் சொன்னேன். மற்ற நாடுகளிலிருந்து உங்களைப் பிரித்தெடுத்திருக்கிற உங்கள் இறைவனாகிய யெகோவா நானே. ");
INSERT INTO tamtcv_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘ஆகையால் நீங்கள் சுத்தமான மிருகங்களுக்கும், அசுத்தமான மிருகங்களுக்கும் இடையிலும், சுத்தமான பறவைகளுக்கும், அசுத்தமான பறவைகளுக்கும் இடையிலும் வித்தியாசம் ஏற்படுத்துங்கள். உங்களுக்கு அசுத்தமென்று நான் விலக்கி வைத்த மிருகத்தினாலாவது, பறவையினாலாவது அல்லது தரையில் ஊரும் எதினாலாவது உங்களை அசுத்தப்படுத்த வேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","நீங்கள் எனக்குப் பரிசுத்தமுள்ளவர்களாய் இருக்கவேண்டும். ஏனெனில், யெகோவாவாகிய நான் பரிசுத்தராய் இருக்கிறேன். நீங்கள் என்னுடையவர்களாய் இருக்கும்படி, நான் நாடுகளிலிருந்து உங்களைப் பிரித்து வைத்திருக்கிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘அஞ்சனம் பார்க்கிற அல்லது குறிசொல்லுகிற ஒரு ஆணோ, பெண்ணோ உங்களுக்குள் இருந்தால், அவர்கள் கொலைசெய்யப்பட வேண்டும். நீங்கள் அவர்களைக் கல்லெறிந்து கொல்லவேண்டும். அவர்களின் இரத்தப்பழி அவர்கள் தலைகளிலேயே இருக்கும்’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","யெகோவா மோசேயிடம், “ஆரோனின் மகன்களான ஆசாரியர்களிடம் நீ பேசிச் சொல்லவேண்டியதாவது: ‘ஆசாரியனானவன் தன் மக்களில் சாகும் யாருக்காகவும் சம்பிரதாயப்படி தன்னை அசுத்தமாக்கிக்கொள்ளக் கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","நெருங்கிய உறவினரான தன் தகப்பன், தாய், தன் மகன், மகள், தன் சகோதரன் ஆகியோருக்காகத் தன்னை அசுத்தப்படுத்தலாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","அல்லது கணவன் இல்லாத காரணத்தால் தன்னில் தங்கி வாழ்கின்ற, திருமணமாகாத தனது சகோதரிக்காகத் தன்னை அசுத்தப்படுத்திக் கொள்ளலாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","திருமணத்தின்மூலம் தனக்கு உறவினரானோருக்காகத் தன்னை அசுத்தப்படுத்திக் கறைப்படுத்திக்கொள்ளக் கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘ஆசாரியர்கள் தங்கள் தலைகளை மொட்டையடிக்கவோ, தங்கள் தாடிகளின் ஓரத்தைக் கத்தரிக்கவோ, தங்கள் உடல்களைக் கீறிக்கொள்ளவோ கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","அவர்கள் தங்கள் இறைவனுக்குப் பரிசுத்தமாய் இருக்கவேண்டும். தங்களுடைய இறைவனின் பெயருக்குத் தூய்மைக்கேடு உண்டாக்கக்கூடாது. ஏனெனில் அவர்கள் தங்கள் இறைவனின் உணவை நெருப்பினால் யெகோவாவுக்குக் காணிக்கையாகச் செலுத்துகிறபடியால், அவர்கள் பரிசுத்தமாயிருக்க வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘அவர்கள் வேசித்தனத்தால் கறைப்பட்ட பெண்களையோ அல்லது தங்கள் கணவர்களிடமிருந்து விவாகரத்துப் பெற்றவர்களையோ திருமணம் செய்யக்கூடாது. ஏனெனில் ஆசாரியர்கள் தங்கள் இறைவனுக்குப் பரிசுத்தமானவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","ஆசாரியர்கள் உங்கள் இறைவனின் உணவைப் பலியாகச் செலுத்துகிறபடியால், அவர்களைப் பரிசுத்தமானவர்களாக மதியுங்கள். உங்களைப் பரிசுத்தமாக்குகிற யெகோவாவாகிய நான் பரிசுத்தராய் இருக்கிறபடியால், அவர்களையும் பரிசுத்தமானவர்களாக எண்ணிக்கொள்ளுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ ‘ஒரு ஆசாரியனின் மகள் வேசியாகி அதினால் தன்னைக் கறைப்படுத்தினால், அவள் தன் தகப்பனை அவமானப்படுத்துகிறாள். அவள் நெருப்பிலே எரிக்கப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘தன் சகோதரர்கள் மத்தியில் தன் தலையின்மேல் அபிஷேக எண்ணெய் ஊற்றப்பட்டவனும், ஆசாரியனுக்கான உடைகளை அணிவதற்கு நியமிக்கப்பட்டவனுமான தலைமை ஆசாரியன் தன் தலைமயிரைக் குலைக்கவோ, தன் உடைகளைக் கிழிக்கவோ கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","அவன் ஒரு இறந்த உடல் கிடக்கும் இடத்திற்குப் போகக்கூடாது. அவனுடைய தகப்பனோ, தாயோ இறந்தாலும் அவன் தன்னை அசுத்தப்படுத்தக் கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","அவன் தன் இறைவனின் பரிசுத்த இடத்தைவிட்டுப் புறப்படவோ, அதைத் தூய்மைக்கேடாக்கவோ கூடாது. ஏனெனில் அவன் தன் இறைவனின் அபிஷேக எண்ணெயால் அர்ப்பணிக்கப்பட்டிருக்கிறான். நானே யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ ‘தலைமை ஆசாரியன் திருமணம் செய்யும் பெண், ஒரு கன்னிகையாகவே இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","அவன் ஒரு விதவையையோ, விவாகரத்து செய்யப்பட்டவளையோ, வேசித்தனத்தினால் கறைப்பட்ட ஒரு பெண்ணையோ திருமணம் செய்யக்கூடாது. தன் சொந்த மக்கள் மத்தியில் உள்ள கன்னிகையை மட்டுமே திருமணம் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","இவ்வாறாக அவன் தன் மக்கள் மத்தியில் தன் சந்ததிகளை மாசுப்படுத்தாமல் இருக்கவேண்டும். அவனைப் பரிசுத்தமாக்குகிற யெகோவா நானே’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“நீ ஆரோனிடம் சொல்லவேண்டியதாவது, ‘தலைமுறைதோறும் உன் சந்ததிகளில் அங்கவீனம் உள்ள எவனும் தன் இறைவனின் உணவைச் செலுத்தும்படிக்கு அருகில் வரக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","எத்தகைய அங்கவீனமுள்ளவனும் சமீபத்தில் வரக்கூடாது. குருடன், முடவன், உருவம் சிதைந்தவன், உருவக் குறைபாடுள்ளவன், ");
INSERT INTO tamtcv_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","கை அல்லது கால் முடமானவன், ");
INSERT INTO tamtcv_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","கூன்முதுகன், வளர்ச்சி குன்றியவன், கண்ணில் குறைபாடுள்ளவன், சொறி அல்லது சீழ்வடியும் புண்ணுள்ளவன், விதைகள் சேதப்பட்டவன் ஆகிய எவனுமே அவ்வாறு வரக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","ஆசாரியனான ஆரோனின் சந்ததிகளில் ஊனமுடைய யாராவது, நெருப்பினால் யெகோவாவுக்கு காணிக்கை செலுத்த சமீபத்தில் வரக்கூடாது. அவன் ஊனமுள்ளவனாகையால், தன் இறைவனின் உணவைச் செலுத்தும்படி சமீபமாய் வரக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","அவன் தன் இறைவனின் மகா பரிசுத்தமான உணவையும், மற்ற பரிசுத்தமான உணவையும் சாப்பிடலாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","ஆனாலும் அவன் தன் அங்கவீனத்தினிமித்தம் திரைக்குச் சமீபமாய்ப் போகவோ, பலிபீடத்தை அணுகவோ கூடாது. இவ்வாறாக என் பரிசுத்த இடத்தைத் தூய்மைக்கேடாக்கக் கூடாது. ஆசாரியர்களைப் பரிசுத்தமாக்கும் யெகோவா நானே’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","மோசே இவற்றை ஆரோனுக்கும், அவன் மகன்களுக்கும், இஸ்ரயேலர் அனைவருக்கும் சொன்னான். ");
INSERT INTO tamtcv_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","யெகோவா மோசேயிடம் சொன்னதாவது, ");
INSERT INTO tamtcv_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“நீ ஆரோனுக்கும் அவன் மகன்களுக்கும், இஸ்ரயேலர் எனக்கு அர்ப்பணிக்கும் பரிசுத்த காணிக்கைகளை மதித்து நடக்கும்படிச் சொல். இவ்விதமாய் அவர்கள் என் பரிசுத்த பெயருக்குத் தூய்மைக்கேடு உண்டாக்காமல் இருப்பார்கள். நானே யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“நீ அவர்களிடம் சொல்லவேண்டியதாவது: தலைமுறைதோறும் உன் சந்ததிகளில் எவனும், சம்பிரதாயப்படி அசுத்தமாய் இருந்தும், இஸ்ரயேலர் யெகோவாவுக்கு அர்ப்பணிக்கும் பரிசுத்த காணிக்கைக்குச் சமீபமாய் வருவானாகில், அவன் என் சமுகத்திலிருந்து அகற்றப்படவேண்டும். நானே யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ ‘ஆரோனின் சந்ததிகளில் யாராவது, தொற்றும் தோல்வியாதி உள்ளவனாகவோ, உடல் கசிவு உள்ளவனாகவோ இருந்தால், அவன் சுத்திகரிக்கப்படும்வரை பரிசுத்த காணிக்கைகளை சாப்பிடக்கூடாது. சடலத்தால் கறைபட்ட ஏதாவதொன்றைத் தொடுவதினாலும், விந்து கசிவுள்ள ஒருவனைத் தொடுவதினாலும் அவன் அசுத்தமாயிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","அவன் தன்னை அசுத்தப்படுத்தக்கூடிய ஊரும்பிராணி ஒன்றைத் தொடுவதினாலும், எவ்வித அசுத்தத்தினாலும் தன்னை அசுத்தப்படுத்துகிற எவனையாவது தொடுவதினாலும் அசுத்தமாயிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","இப்படிப்பட்ட எதையும் தொடுபவன் மாலைவரை அசுத்தமாயிருப்பான். அவன் தான் தண்ணீரில் முழுகினாலொழிய பரிசுத்த காணிக்கை எதையும் சாப்பிடக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","சூரியன் மறையும்போது அவன் சுத்தமாவான். அதன்பின் அவன் பரிசுத்த காணிக்கைகளைச் சாப்பிடலாம். ஏனெனில், அவை அவனுடைய உணவாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","செத்ததாகக் கண்டெடுக்கப்பட்ட எதையாவது அல்லது காட்டு மிருகங்களினால் கொல்லப்பட்ட எதையாவது சாப்பிடுவதினால் அவன் அசுத்தமாகக் கூடாது. நானே யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘ஆசாரியர்கள் என் நியமங்களை அவமதித்து குற்றவாளிகளாகி சாகாதபடிக்கு, அவர்கள் அவற்றைக் கைக்கொள்ளவேண்டும். அவர்களைப் பரிசுத்தமாக்குகிற யெகோவா நானே. ");
INSERT INTO tamtcv_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘ஆசாரியனின் குடும்பத்துக்குப் புறம்பான ஒருவனோ அல்லது ஆசாரியனின் விருந்தாளியோ அல்லது கூலியாளோ பரிசுத்த காணிக்கையைச் சாப்பிடக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","ஆனால் ஆசாரியன் ஒரு அடிமையைப் பணம் கொடுத்து வாங்கினாலோ அல்லது ஒரு அடிமை அவன் வீட்டில் பிறந்தாலோ, அந்த அடிமை ஆசாரியனின் உணவைச் சாப்பிடலாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","ஆசாரியனின் மகள் ஆசாரியன் அல்லாத ஒருவனை திருமணம் செய்தால், அவளும் பரிசுத்த கொடைகளில் எதையும் சாப்பிடக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","ஆனால், ஒரு ஆசாரியனின் மகள் விதவையாக இருந்தாலோ அல்லது விவாகரத்து செய்யப்பட்டவளாய் இருந்தாலோ, அவள் பிள்ளைகள் அற்றவளாய், தான் இளமையில் இருந்ததுபோலவே தன் தகப்பன் வீட்டில் வசிக்கும்படி திரும்பிவந்திருந்தால், அவள் தன் தகப்பனின் உணவைச் சாப்பிடலாம். அங்கீகரிக்கப்படாத யாராவது அதில் எதையும் சாப்பிடக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘யாரேனும் ஒருவன் தவறுதலாக பரிசுத்தமான காணிக்கையைச் சாப்பிட்டால், அக்காணிக்கைக்காக அவன் ஆசாரியனுக்குப் பதிலீடு செய்வதுடன், அதன் மதிப்பில் ஐந்தில் ஒரு பங்கையும் சேர்த்துக் கொடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","இஸ்ரயேலர் யெகோவாவுக்குச் செலுத்தும் பரிசுத்த காணிக்கைகளை ஆசாரியர்கள் தூய்மைக்கேடாக்கக் கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","அப்பரிசுத்த காணிக்கைகளை அங்கீகரிக்கப்படாதவர்கள் சாப்பிட அனுமதிப்பதின் மூலம், அவர்கள்மேல் தண்டனைக்குரிய குற்றத்தை சுமத்தாமல் இருக்கவேண்டும். நானே யெகோவா, அவர்களைப் பரிசுத்தமாக்குகிறவர்’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“நீ ஆரோனோடும், அவன் மகன்களோடும், இஸ்ரயேலர் அனைவரோடும் பேசிச் சொல்லவேண்டியதாவது: ‘இஸ்ரயேலனோ, இஸ்ரயேலில் வசிக்கும் பிறநாட்டினனோ, யாராவது தன் நேர்த்திக்கடனைச் செலுத்தும்படியாகவோ அல்லது சுயவிருப்பக் காணிக்கையாகவோ யெகோவாவுக்கு ஒரு தகனகாணிக்கையைக் கொடையாகக் கொண்டுவரலாம். அவ்வாறு கொண்டுவருவதானால், ");
INSERT INTO tamtcv_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","அது உங்கள் சார்பாக அங்கீகரிக்கப்படும்படி மாட்டு மந்தையிலிருந்தோ, ஆட்டு மந்தையிலிருந்தோ அல்லது வெள்ளாட்டு மந்தையிலிருந்தோ குறைபாடற்ற ஒரு ஆண் மிருகமாக இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","குறைபாடுள்ள எதையும் கொண்டுவர வேண்டாம். ஏனெனில் அது உங்கள் சார்பாக ஏற்றுக்கொள்ளப்படமாட்டாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","ஒருவன் ஒரு விசேஷ நேர்த்திக்கடனை நிறைவேற்றுவதற்காகவோ அல்லது சுயவிருப்பக் காணிக்கைக்காகவோ தன் மாட்டு மந்தையில் இருந்தாவது, ஆட்டு மந்தையில் இருந்தாவது யெகோவாவுக்கு ஒரு சமாதான காணிக்கையைக் கொண்டுவந்தால், அது ஏற்கத்தக்கதாக இருக்கும்படி, குறைபாடற்றதாகவும், பழுதற்றதாகவும் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","குருடானதையோ, காயமடைந்ததையோ, முடமானதையோ அல்லது தோலில் மருவுள்ளதையோ, சொறி அல்லது சீழ்வடியும் புண்ணுள்ளதையோ யெகோவாவுக்குச் செலுத்தவேண்டாம். இவைகளில் எதையும், நெருப்பினால் யெகோவாவுக்குச் செலுத்தப்படும் காணிக்கையாக, பலிபீடத்தின்மேல் வைக்கவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","ஆனாலும் வளர்ச்சி குன்றிய அல்லது உருவம் சிதைவுற்ற ஒரு மாட்டையோ, செம்மறியாட்டையோ நீங்கள் சுயவிருப்பக் காணிக்கையாகச் செலுத்தலாம்; ஆனால் அவை நேர்த்திக்கடனை நிறைவேற்றுவதற்காக ஏற்றுக்கொள்ளப்படமாட்டாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","விதைகள் காயப்பட்ட, நசுக்கப்பட்ட, கிழிக்கப்பட்ட அல்லது வெட்டப்பட்ட எந்தவொரு மிருகத்தையும், நீங்கள் யெகோவாவுக்குக் காணிக்கையாகச் செலுத்தக்கூடாது. உங்கள் சொந்த நாட்டில் இதைச் செய்யக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","இப்படிப்பட்ட மிருகங்களை நீங்கள் அந்நிய நாட்டினரின் கையிலிருந்து ஏற்றுக்கொள்ளவும், அவற்றை உங்கள் இறைவனின் உணவாகச் செலுத்தவும் வேண்டாம். உங்கள் சார்பில் அவை ஏற்றுக்கொள்ளப்படமாட்டாது. ஏனெனில், அவை உருவம் சிதைந்தவைகளாயும், குறைபாடுள்ளவைகளாயும் இருக்கின்றன.’ ” ");
INSERT INTO tamtcv_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","யெகோவா மோசேயிடம் சொன்னதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“கன்றுக்குட்டியோ, செம்மறியாட்டு குட்டியோ அல்லது வெள்ளாட்டு குட்டியோ பிறக்கும்போது அது தன் தாயுடன் ஏழு நாட்கள் தொடர்ந்து இருக்கவேண்டும். எட்டாம் நாளிலிருந்து யெகோவாவுக்கு நெருப்பினால் செலுத்தப்படும் காணிக்கையாக அது ஏற்றுக்கொள்ளப்படும். ");
INSERT INTO tamtcv_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","பசுவை அதன் கன்றுடனும், ஆட்டை அதன் குட்டியுடனும் ஒரே நாளில் வெட்டிக் கொல்லவேண்டாம்.” ");
INSERT INTO tamtcv_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“நீங்கள் யெகோவாவுக்கு நன்றிக் காணிக்கை ஒன்றைப் பலியிடும்போது, அது உங்கள் சார்பாக ஏற்றுக்கொள்ளப்படும் விதத்தில் அதைப் பலியிடுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","அந்த நாளிலேயே நீங்கள் அதைச் சாப்பிடவேண்டும். காலைவரை ஒன்றையும் விட்டுவைக்கவேண்டாம். நானே யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“என் கட்டளைகளைக் கைக்கொண்டு அவற்றைப் பின்பற்றுங்கள். நானே யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","என் பரிசுத்த பெயரை அசுத்தமாக்க வேண்டாம். இஸ்ரயேலரால் நான் பரிசுத்தர் என்று அங்கீகரிக்கப்பட வேண்டும். உங்களைப் பரிசுத்தமாக்குகிற யெகோவா நானே. ");
INSERT INTO tamtcv_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","உங்கள் இறைவனாயிருக்கும்படி நானே உங்களை எகிப்து நாட்டிலிருந்து கொண்டுவந்தேன். நானே யெகோவா” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“இஸ்ரயேலருடன் நீ பேசி, அவர்களுக்கு சொல்லவேண்டியதாவது: இவை நியமிக்கப்பட்ட எனது பண்டிகைகள். யெகோவாவுக்குரிய நியமிக்கப்பட்ட பண்டிகைகள் இவையே. இவைகளை நீங்கள் பரிசுத்த சபை கூட்டங்களாகப் பிரசித்தப்படுத்த வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘நீங்கள் ஆறுநாட்கள் வேலை செய்யலாம். ஆனால் ஏழாம்நாளோ இளைப்பாறுதலுக்குரிய ஒரு ஓய்வுநாள். அது பரிசுத்த சபைக்கூடும் நாள். அந்த நாளில் நீங்கள் எந்த ஒரு வேலையையும் செய்யக்கூடாது. நீங்கள் எங்கு வாழ்ந்தாலும் அது யெகோவாவுக்குரிய ஓய்வுநாளாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘யெகோவாவினால் நியமிக்கப்பட்ட பண்டிகைகள் இவையே: அவைகளுக்காக நியமிக்கப்பட்ட காலங்களில், நீங்கள் அவைகளைப் பரிசுத்த சபை கூடுதல்களாகப் பிரசித்தப்படுத்த வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","முதலாம் மாதம் பதினான்காம் நாள் பொழுதுபடும் வேளையில் யெகோவாவின் பஸ்கா பண்டிகை ஆரம்பமாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","அதே மாதம் பதினைந்தாம் நாளில் யெகோவாவின் புளிப்பில்லாத அப்பப்பண்டிகை ஆரம்பமாகும். ஏழுநாட்களுக்கு நீங்கள் புளிப்பில்லாமல் செய்யப்பட்ட அப்பங்களைச் சாப்பிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","முதலாம் நாள் நீங்கள் பரிசுத்த சபையைக் கூட்டவேண்டும். அந்த நாளில் வழக்கமான வேலைகள் எதையும் செய்யவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","யெகோவாவுக்கு நெருப்பினால் செலுத்தப்படும் காணிக்கையை ஏழுநாட்களுக்குக் கொண்டுவர வேண்டும். ஏழாம்நாளில் பரிசுத்த சபையைக் கூட்டவேண்டும். அந்த நாளில் வழக்கமான வேலைகள் எதையும் செய்யக்கூடாது’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“நீ இஸ்ரயேல் மக்களிடம் பேசி, அவர்களிடம் சொல்லவேண்டியதாவது: ‘நான் உங்களுக்குக் கொடுக்கப்போகும் நாட்டிற்குள் நீங்கள் போய், அதன் விளைச்சலை அறுவடை செய்யும்போது, உங்கள் அறுவடையின் முதலாவது தானியக் கதிர்க்கட்டை ஆசாரியனிடம் கொண்டுவர வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","அது உங்கள் சார்பாக ஏற்றுக்கொள்ளப்படும்படி ஆசாரியன் அந்தக் கதிர்க்கட்டை யெகோவாவுக்கு முன்பாக அசைவாட்டவேண்டும். ஓய்வுநாளுக்கு அடுத்தநாள் ஆசாரியன் அதை அசைவாட்டவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","அந்தக் கதிர்க்கட்டை அசைவாட்டும் அந்நாளிலே ஒரு வயதுடைய குறைபாடற்ற செம்மறியாட்டுக் குட்டியை யெகோவாவுக்குத் தகன காணிக்கையாகப் பலியிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","அதனுடன் அதற்குரிய தானியக் காணிக்கையாக, ஒரு எப்பாவின் பத்தில் இரண்டு பங்கு அளவு எண்ணெய்விட்டுப் பிசைந்த சிறந்த மாவாக அதைச் செலுத்தவேண்டும். அது மகிழ்ச்சியூட்டும் நறுமணமாக யெகோவாவுக்கு நெருப்பினால் செலுத்தப்படும் காணிக்கையாகும். அத்துடன் நான்கில் ஒரு பங்கு ஹின் அளவான திராட்சை இரசத்தை, அதற்குரிய பானகாணிக்கையாகவும் செலுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","நீங்கள் உங்கள் இறைவனுக்கு முதற்பலனில் இக்காணிக்கையைக் கொண்டுவரும் அந்த நாள்வரை, அதிலிருந்து எந்தவொரு அப்பத்தையோ, வறுத்த தானியத்தையோ, பச்சைத் தானியத்தையோ சாப்பிடக்கூடாது. நீங்கள் எங்கே வாழ்ந்தாலும், தலைமுறைதோறும் இது உங்களுக்கு நிரந்தர நியமமாய் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘நீங்கள் அசைவாட்டும் காணிக்கையாகக் கதிர்க்கட்டைக் கொண்டுவந்த நாளான ஓய்வுநாளுக்கு அடுத்த நாளிலிருந்து, முழுமையாக ஏழு வாரங்களை எண்ணுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ஏழாவது ஓய்வுநாளுக்கு அடுத்தநாளான ஐம்பதாவது நாள்வரை எண்ணுங்கள். அதன்பின் யெகோவாவுக்குப் புதிய தானியக் காணிக்கையைக் கொண்டுவாருங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","நீங்கள் எங்கு வாழ்ந்தாலும் பத்தில் இரண்டு எப்பா அளவான சிறந்த மாவினால் புளிப்பூட்டப்பட்டுத் தயாரிக்கப்பட்ட இரண்டு அப்பங்களை, யெகோவாவுக்கான முதற்பலன்களின் அசைவாட்டும் காணிக்கையாகக் கொண்டுவாருங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","இந்த அப்பத்துடன், ஏழு செம்மறியாட்டுக் கடாக்குட்டிகளைக் கொண்டுவர வேண்டும். ஒவ்வொன்றும் ஒரு வயதுடையதும், குறைபாடற்றதுமாய் இருக்கவேண்டும். அவற்றுடன் ஒரு காளையையும், இரண்டு செம்மறியாட்டுக் கடாக்களையும் கொண்டுவாருங்கள். இவை அவர்களுடைய தானியக் காணிக்கைகளோடும், பானகாணிக்கைகளோடும் யெகோவாவுக்குரிய தகன காணிக்கையாக இருக்கும். இது யெகோவாவுக்கு மகிழ்ச்சியூட்டும் ஒரு நறுமணமாக நெருப்பினால் செலுத்தப்படும் காணிக்கையாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","அதன்பின் பாவநிவாரண காணிக்கையாக ஒரு வெள்ளாட்டுக்கடாவையும், சமாதான காணிக்கையாக, ஒவ்வொன்றும் ஒரு வயதுடையதாயிருக்கிற இரண்டு செம்மறியாட்டுக் குட்டிகளையும் பலியிடுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","ஆசாரியன் இந்த இரண்டு செம்மறியாட்டுக் குட்டிகளையும் முதற்பலன்களின் அப்பத்துடன் யெகோவாவின் முன்னிலையில் அசைவாட்டும் காணிக்கையாக அசைவாட்டவேண்டும். யெகோவாவுக்குப் பரிசுத்தமான இந்தக் காணிக்கை பொருட்கள் ஆசாரியனுக்குச் சொந்தமாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","அதே நாளில் பரிசுத்த சபைக்கூடுதலை நீங்கள் அறிவிக்கவேண்டும். அந்நாளில் வழக்கமாக நீங்கள் செய்யும் எந்த வேலையையும் செய்யவேண்டாம். நீங்கள் எங்கே வாழ்ந்தாலும் தலைமுறைதோறும் இது உங்களுக்கு நிரந்தர நியமமாயிருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘நீங்கள் உங்கள் நிலத்தில் அறுவடை செய்யும்போது, வயலின் ஓரங்களில் உள்ளவைகளை அறுவடை செய்யாமலும், அறுவடையில் சிந்தியதைப் பொறுக்காமலும் விட்டுவிடுங்கள். இவைகளை ஏழைகளுக்கும், பிறநாட்டினருக்கும் விட்டுவிடுங்கள். உங்கள் இறைவனாகிய யெகோவா நானே’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“நீ இஸ்ரயேலரிடம் சொல்லவேண்டியதாவது: ‘ஏழாம் மாதத்தின் முதலாம் நாள் உங்களுக்கு ஒரு ஓய்வுநாளாயிருக்க வேண்டும். அந்த நாள் எக்காளம் முழங்கி, நினைவு விழாவாகக் கொண்டாடப்படும் ஒரு பரிசுத்த சபைக்கூடுதலாக இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","அந்த நாளில் வழக்கமாகச் செய்யும் வேலைகளைச் செய்யாமல் யெகோவாவுக்கு நெருப்பினால் செலுத்தப்படும் காணிக்கையை கொண்டுவர வேண்டும்’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“ஏழாம் மாதத்தின் பத்தாம்நாள் பாவநிவிர்த்தி செய்யும் நாளாகும். அந்த நாளில் பரிசுத்த சபையைக் கூட்டி உபவாசித்து, உங்களை ஒடுக்கி, யெகோவாவுக்கு நெருப்பினால் செலுத்தப்படும் காணிக்கையைக் கொண்டுவாருங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","அந்த நாளிலே எந்தவொரு வேலையையும் செய்யவேண்டாம். ஏனெனில், அதுவே உங்கள் இறைவனாகிய யெகோவாவுக்கு முன்பாக உங்களுக்காகப் பாவநிவிர்த்தி செய்யப்படும் பாவநிவிர்த்தி நாள். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","அந்த நாளில் உபவாசித்து தன்னை ஒடுக்காத எவனும் தன் மக்களில் இருந்து அகற்றப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","அந்த நாளில் வேலைசெய்யும் எவனையும், அவனுடைய மக்கள் மத்தியிலிருந்து நான் அழித்துப்போடுவேன். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","நீங்கள் எந்தவொரு வேலையுமே செய்யக்கூடாது. நீங்கள் எங்கு வாழ்ந்தாலும் தலைமுறைதோறும் இது உங்களுக்கு ஒரு நிரந்தர நியமமாய் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","இந்நாள் உங்களுக்கான ஓய்வுநாள். அதில் உபவாசித்து உங்களையே நீங்கள் ஒடுக்கவேண்டும். மாதத்தின் ஒன்பதாம்நாள் மாலையிலிருந்து மறுநாள் மாலைவரை நீங்கள் உங்கள் ஓய்வுநாளை அனுசரிக்கவேண்டும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“நீ இஸ்ரயேலரிடம் சொல்லவேண்டியதாவது, ‘ஏழாம் மாதம் பதினைந்தாம் நாளிலே யெகோவாவின் கூடாரப்பண்டிகை ஆரம்பமாகி, தொடர்ந்து ஏழு நாட்கள் நடைபெறும். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","முதலாம் நாள் பரிசுத்த சபைக்கூடும் நாள். அந்நாளில் வழக்கமான வேலையொன்றையும் செய்யவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","யெகோவாவுக்கு நெருப்பினால் செலுத்தப்படும் காணிக்கையை ஏழுநாட்களுக்குக் கொண்டுவாருங்கள். எட்டாவது நாள் பரிசுத்த சபையைக் கூட்டி நெருப்பினால் யெகோவாவுக்குக் காணிக்கையைச் செலுத்துங்கள். அதுவே சபைக்கூடுதல் முடிவடையும் நாள். அந்நாளில் வழக்கமாகச் செய்யும் வேலையொன்றையும் செய்யக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“ ‘யெகோவாவுக்கு நெருப்பினால் செலுத்தப்படும் காணிக்கைகளைக் கொண்டுவருவதற்காக, பரிசுத்த சபைக்கூடுதல்களாக நீங்கள் பிரசித்தப்படுத்தும்படி யெகோவாவினால் நியமிக்கப்பட்ட பண்டிகைகள் இவையே. இப்பண்டிகைகளில் ஒவ்வொரு நாளுக்கும் தேவையான தகன காணிக்கைகளும், தானியக் காணிக்கைகளும், பலிகளும், பான காணிக்கைகளும் கொண்டுவரப்பட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","இக்காணிக்கைகள் யாவும், யெகோவாவின் ஓய்வுநாள் காணிக்கைகளோடு கூடுதலாகக் கொடுக்க வேண்டியவையாகும். இவை உங்கள் கொடைகளோடும். நீங்கள் நேர்ந்துகொண்ட எதனோடும், நீங்கள் யெகோவாவுக்குக் கொடுக்கும் உங்கள் சுயவிருப்பக் காணிக்கைகள் அனைத்தோடும் கூடுதலாகக் கொடுக்கப்பட வேண்டியவைகளாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘ஆகவே நீங்கள் நாட்டின் விளைச்சலைத் சேர்த்தபின், ஏழாம் மாதம் பதினைந்தாம்நாள் தொடங்கி, ஏழுநாட்களுக்கு யெகோவாவுக்கான இப்பண்டிகையைக் கொண்டாடுங்கள். முதலாம் நாள் ஓய்வுநாளாகும். எட்டாம் நாளும் ஓய்வுநாளாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","முதலாம் நாளிலே உங்கள் மரங்களிலிருந்து சிறந்த பழங்களையும், ஓலைகளையும், இலைகளுள்ள கொப்புகளையும், ஆற்றலறியையும் எடுத்துக்கொண்டு, ஏழு நாட்கள் உங்கள் இறைவனாகிய யெகோவா முன்னிலையில் களிகூருங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","ஒவ்வொரு வருடமும் ஏழுநாட்களுக்கு யெகோவாவுக்குரிய பண்டிகையாக இதைக் கொண்டாடுங்கள். இது தலைமுறைதோறும் நிரந்தர நியமமாக இருக்கும். ஏழாம் மாதத்தில் இதைக் கொண்டாடுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","நீங்கள் ஏழுநாட்களுக்குக் கூடாரங்களில் வசியுங்கள். ஊரில் பிறந்த இஸ்ரயேலர் யாவரும் கூடாரங்களில் வசிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","இவ்விதமாய் நான் இஸ்ரயேலரை எகிப்திலிருந்து வெளியே கொண்டுவந்தபோது, அவர்களைக் கூடாரங்களில் வசிக்கச்செய்தேன் என்று உங்கள் சந்ததிகள் அறிந்துகொள்வார்கள். உங்கள் இறைவனாகிய யெகோவா நானே’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","இவ்வாறு மோசே, யெகோவாவினால் நியமிக்கப்பட்ட பண்டிகைகளை இஸ்ரயேலருக்கு அறிவித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“விளக்குகள் தொடர்ந்து எரிந்து ஒளி கொடுக்கும்படியாக, ஒலிவ விதைகளை இடித்துப் பிழிந்தெடுத்த தெளிந்த எண்ணெயைக் கொண்டுவரும்படி இஸ்ரயேலருக்குக் கட்டளையிடு. ");
INSERT INTO tamtcv_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","சபைக் கூடாரத்திலே, சாட்சிப்பெட்டியின் திரைக்கு வெளியே, இந்த விளக்குகளை ஆரோன் யெகோவா முன்னிலையில் மாலைவேளை தொடங்கி விடியும்வரை தொடர்ந்து எரியும்படிச் செய்யவேண்டும். இது தலைமுறைதோறும் ஒரு நிரந்தர நியமமாக இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","சுத்தத் தங்கத்தினாலான குத்துவிளக்கின் மேலுள்ள விளக்குகள் யெகோவா முன்னிலையில் தொடர்ந்து எரியும்படி அவன் பார்த்துக்கொள்ளவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“சிறந்த மாவை எடுத்து, ஒவ்வொரு அப்பத்திற்கும் பத்தில் இரண்டு எப்பா அளவு மாவைப் பயன்படுத்தி, பன்னிரண்டு அப்பங்களைச் சுடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","ஒவ்வொரு வரிசையிலும் ஆறு அப்பங்களாக, யெகோவா முன்னிலையில் காணப்படும் சுத்தத் தங்கத்தினாலான மேஜையின்மேல் இரண்டு வரிசைகளில் அவற்றை வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","ஒவ்வொரு வரிசையிலும் அப்பத்திற்கான ஞாபகார்த்தப் பங்காகவும், நெருப்பினால் யெகோவாவுக்குச் செலுத்தப்படும் ஒரு காணிக்கையாகவும் இருக்கும்படி, கொஞ்சம் சுத்தமான நறுமணத்தூளையும் போடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","ஒவ்வொரு ஓய்வுநாளிலும் இஸ்ரயேலர் சார்பான, நிரந்தர உடன்படிக்கையாக இந்த அப்பம் யெகோவாவுக்கு முன்பாக நித்தமும் வைக்கப்பட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","இது ஆரோனுக்கும் அவன் மகன்களுக்கும் உரியது. அவர்கள் இதை ஒரு பரிசுத்த இடத்தில் சாப்பிடவேண்டும். ஏனெனில், இது யெகோவாவுக்கு நெருப்பினால் செலுத்தப்படும் காணிக்கைகளில் அவர்களுடைய நிரந்தரமான உரிமையில் மகா பரிசுத்தமான பங்கு.” ");
INSERT INTO tamtcv_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","ஒரு எகிப்திய மனிதனுக்கும், இஸ்ரயேல் பெண்ணுக்கும் மகனான ஒரு மனிதன் இஸ்ரயேல் மக்களுக்குள் போனான். அவனுக்கும் ஒரு இஸ்ரயேலனுக்கும் இடையில் முகாமுக்குள் சண்டை மூண்டது. ");
INSERT INTO tamtcv_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","அந்த நேரத்தில் இஸ்ரயேல் பெண்ணின் மகனான அவன், யெகோவாவின் பெயரை தூஷண வார்த்தைகளால் நிந்தித்தான். எனவே அவர்கள் அவனை மோசேயிடம் கொண்டுவந்தார்கள். அவனுடைய தாய் தாண் கோத்திரத்து திப்ரியின் மகளான செலோமித். ");
INSERT INTO tamtcv_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","அவனைப்பற்றி யெகோவாவின் விருப்பம் தெளிவாகும் வரை, அவனை அவர்கள் காவலில் வைத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","அப்பொழுது யெகோவா மோசேயுடன் பேசிச் சொன்னதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“நீ நிந்தித்தவனை முகாமுக்கு வெளியே கொண்டுபோக வேண்டும். அவன் நிந்தித்ததைக் கேட்டவர்கள் எல்லோரும் தங்கள் கைகளை அவன் தலையில் வைக்கவேண்டும். பின்பு சபையார் அனைவரும் அவனைக் கல்லெறிந்து கொல்லவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","நீ இஸ்ரயேலரிடம் சொல்லவேண்டியதாவது: யாராவது தன் இறைவனை நிந்தித்தால், அக்குற்றத்திற்கு அவன் பொறுப்பாளியாவான். ");
INSERT INTO tamtcv_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","யெகோவாவின் பெயரை நிந்திக்கிற எவனும் கொல்லப்படவேண்டும். சபையார் அனைவரும் அவனைக் கல்லெறிந்து கொல்லவேண்டும். அவன் பிறநாட்டினனோ, தன் நாட்டினனோ யெகோவாவின் பெயரை நிந்தித்தால் அவன் கொல்லப்படவேண்டும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘யாராவது ஒருவன் ஒரு மனித உயிரைக் கொலை செய்தால், அவன் கொல்லப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","யாராவது ஒருவன் இன்னொருவனுடைய மிருகத்தைக் கொன்றால், அவன் உயிருக்குப்பதில், உயிராகப் பதிலீடு செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","யாராவது ஒருவன் தன் அயலானை காயப்படுத்தினால், அவன் செய்தபடியே, அவனுக்கும் திருப்பிச் செய்யப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","முறிவுக்கு முறிவு, கண்ணுக்குக் கண், பல்லுக்குப் பல் பதிலீடு செய்யப்படவேண்டும். மற்றவனைக் காயப்படுத்தியது போலவே இவனும் அவ்விதமாய் காயப்படுத்தப்பட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","மிருகத்தைக் கொல்லுகிற எவனும் அதற்காகப் பதிலீடு செய்யவேண்டும். ஆனால் மனிதனைக் கொல்லுகிறவனோ கொல்லப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","உங்களிடம் தன் நாட்டினனுக்கும், பிறநாட்டினனுக்கும் ஒரேவிதமான சட்டம் இருக்கவேண்டும். உங்கள் இறைவனாகிய யெகோவா நானே’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","மோசே இஸ்ரயேலருடன் பேசினான். அவர்கள் இறைவனை நிந்தனை செய்தவனை முகாமுக்கு வெளியே கொண்டுபோய் கல்லெறிந்து கொன்றார்கள். இவ்விதமாய் மோசேக்கு யெகோவா கட்டளையிட்டபடியே இஸ்ரயேலர் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","யெகோவா சீனாய் மலையில் மோசேயுடன் பேசினார், ");
INSERT INTO tamtcv_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“நீ இஸ்ரயேலருடன் பேசிச் சொல்லவேண்டியதாவது: ‘நான் உங்களுக்குக் கொடுக்கப்போகும் நாட்டிற்குள் நீங்கள் செல்லும்போது, அந்த நாடும் யெகோவாவுக்காக ஓய்வை கடைபிடிக்க வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ஆறு வருடங்கள் உங்கள் வயல்களை விதைத்து, ஆறு வருடங்கள் திராட்சைத் தோட்டத்தின் கொடிகளின் கிளைகளைத்தரித்து சுத்தம்செய்து, அவற்றின் பலனை அறுவடை செய்யுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ஆனால் ஏழாம் வருடத்தில், நிலம் ஓய்வு பெறவேண்டும். அது யெகோவாவுக்கான ஓய்வு. அந்த வருடத்தில் நீங்கள் வயலை விதைக்கவும், திராட்சைத்தோட்டத்து கிளைகளைத் தரிக்கவும் வேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","தானாய் முளைத்து விளையும் பயிரை, அறுவடை செய்யவும் வேண்டாம். பராமரிக்கப்படாத திராட்சைக் கொடியிலிருந்து பழங்களைப் பறிக்கவும் வேண்டாம். நிலத்திற்கு ஓய்வு வருடம் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","நாட்டின் ஓய்வு வருடத்தில் விளைகிறது உனக்கு உணவாகும். அது உனக்கும், உன் வேலைக்காரனுக்கும், வேலைக்காரிக்கும், கூலியாளுக்கும், உங்கள் மத்தியில் வசிக்கும் தற்காலிக குடியிருப்பாளனுக்கும் உணவாகும், ");
INSERT INTO tamtcv_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","உன் வீட்டு மிருகங்களுக்கும், வயல்களிலுள்ள மிருகங்களுக்கும் அது உணவாயிருக்கும். நிலத்தின் விளைச்சல் எதையும் சாப்பிடலாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘ஏழு ஓய்வு வருடங்களை எண்ணுங்கள். ஏழுமுறை ஏழு வருடங்களாக நாற்பத்தொன்பது வருடங்கள் வரும்வரை ஏழு ஓய்வு வருடங்களை எண்ணுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","பின்பு ஏழாம் மாதம் பத்தாம் தேதியிலே, நாடெங்கிலும் எக்காளம் ஊதுங்கள். பாவநிவிர்த்தி நாளிலே, எக்காளத்தை நாடெங்கும் ஊதுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","ஐம்பதாம் வருடத்தை அர்ப்பணம் செய்து, நாட்டு மக்கள் அனைவருக்கும், விடுதலையைப் பிரசித்தப்படுத்துங்கள். அது உங்களுக்கான யூபிலி வருடமாயிருக்கும். உங்களில் ஒவ்வொருவனும் தன்தன் குடும்பச் சொத்து உரிமைக்கும், தன்தன் கோத்திரத்திற்கும் திரும்பிச் செல்லவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","ஐம்பதாம் வருடம் உங்களுக்கு ஒரு யூபிலி வருடம். நீங்கள் விதைக்கவோ, தானாய் விளைந்த தானியத்தையாகிலும் திராட்சைப் பழங்களையாகிலும் அறுவடை செய்யவோ வேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","ஏனெனில் அது யூபிலி வருடம்; அது உங்களுக்குப் பரிசுத்தமாயிருக்க வேண்டும். அந்த வருடம் வயல்களில் தானாய் விளைந்தவற்றை மட்டுமே சாப்பிடுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘இந்த யூபிலி வருடத்தில் நீங்கள் ஒவ்வொருவரும் உங்கள் முற்பிதாக்களின் இடங்களுக்குத் திரும்பிச் செல்லவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘நீங்கள் உங்கள் நாட்டவனுக்கு ஒரு நிலத்தை விற்றாலோ அல்லது அவனிடமிருந்து வாங்கினாலோ ஒருவருக்கொருவர் அநியாயம் செய்யக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","நீங்கள் உங்கள் நாட்டினரிடமிருந்து நிலத்தை வாங்கும்போது, சென்ற யூபிலி வருடத்திலிருந்து கழிந்த வருடங்களின் எண்ணிக்கையின் அடிப்படையில் வாங்கவேண்டும். அவன் உங்களுக்கு விற்கும்போது விளைச்சலை அறுவடை செய்யவேண்டிய வருடங்களின் எண்ணிக்கையின் அடிப்படையிலேயே அதை விற்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","அறுவடை வருடங்கள் அதிகமாக இருந்தால், நீங்கள் விலையையும் அதிகரிக்கவேண்டும். வருடங்கள் குறைவாக இருந்தால் விலையையும் குறைக்கவேண்டும். ஏனெனில், அவன் உங்களுக்கு உண்மையாக விற்பது அறுவடையின் எண்ணிக்கையின் மதிப்பையே. ");
INSERT INTO tamtcv_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","ஆகவே நீங்கள் ஒருவருக்கொருவர் அநியாயம் செய்யாமல் உங்கள் இறைவனுக்குப் பயந்து நடவுங்கள். நானே உங்கள் இறைவனாகிய யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘நீங்கள் என்னுடைய விதிமுறைகளைப் பின்பற்றி, என் சட்டங்களுக்குக் கீழ்ப்படிய கவனமாயிருங்கள். அப்பொழுது நீங்கள் உங்கள் நாட்டிலே பாதுகாப்புடன் வாழ்வீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","அப்பொழுது நாடு தன் பலனைக் கொடுக்கும். நீங்கள் திருப்தியாகச் சாப்பிட்டு, அதில் பாதுகாப்புடன் வாழ்வீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","நீங்கள் ஏழாம் வருடத்தில் விதையாமலும், அறுவடை செய்யாமலும் இருந்து, எதைச் சாப்பிடுவோம் என்று கேட்பீர்களானால், ");
INSERT INTO tamtcv_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","ஆறாம் வருடத்தில் நான் உங்களுக்கு அதிக விளைச்சலுள்ள ஆசீர்வாதத்தை அனுப்புவேன். அவ்வருடத்தில் மூன்று வருடங்களுக்கு போதுமான பலனை அந்நிலம் தரும். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","நீங்கள் எட்டாம் வருடத்தில் விதைக்கும் காலத்தில் பழைய விளைச்சலிலிருந்து சாப்பிடுவீர்கள். ஒன்பதாம் வருடத்தில் அறுவடை செய்யும்வரை நீங்கள் அதில் தொடர்ந்து சாப்பிடுவீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘நிலம் நிரந்தரமாய் விற்கப்படக்கூடாது. நிலம் என்னுடையது. நீங்களோ, பிறநாட்டினரும் குத்தகைக்காரருமாக இருக்கிறீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","நீங்கள் சொத்துரிமையாகக் கொண்டிருக்கும் நாடெங்கும் அந்த நிலங்களை மீட்டுக்கொள்வதற்கான முன்னேற்பாடுகளைச் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘உன் நாட்டினருக்குள் ஒருவன் ஏழையாகி தன் சொத்து நிலத்தில் கொஞ்சத்தை விற்றால், அவனுடைய நெருங்கிய உறவினன் முன்வந்து, தன் நாட்டினன் விற்றுப்போட்டதை மீட்டுக்கொள்ள வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","ஆனாலும், ஒருவனுக்கு அவ்வாறு மீட்கக்கூடிய நெருங்கிய உறவினன் இல்லாமல் இருந்து, அவன் தானே செல்வந்தனாகி, அதை மீட்கத்தக்க வசதியைப் பெற்றிருந்தால், ");
INSERT INTO tamtcv_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","அவன் விற்றதிலிருந்து கழிந்த வருடங்களுக்கான மதிப்பை நிர்ணயித்து, தான் ஏற்கெனவே விற்ற விலையிலிருந்து அதைக் கழித்து, மிகுதியை தன்னிடம் வாங்கியவனிடம் திருப்பிக் கொடுக்கவேண்டும். அப்பொழுது அவன் தன் சொத்து நிலத்திற்குத் திரும்பிப்போகலாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","ஆனால் தான் விற்றதைத் திருப்பிவாங்க வசதி இல்லாதுபோனால், யூபிலி வருடம் மட்டும் அது வாங்கியவனுக்கு உரிமையாயிருக்கும். ஆனால், யூபிலி வருடத்தில் அது விற்றவனுக்குத் திருப்பிக்கொடுக்கப்பட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘ஒருவன் மதில் சூழ்ந்த பட்டணத்திலுள்ள ஒரு வீட்டை விற்றால், அதை விற்றபின் ஒரு வருடம் நிறைவடைவதற்குள் அதை மீட்க அவனுக்கு உரிமை உண்டு. அந்தக் காலத்திற்குள் அவன் அதை மீட்கலாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","ஒரு வருடம் நிறைவடையுமுன் அவன் அதைத் திருப்பி மீட்காவிட்டால், மதில் சூழ்ந்த பட்டணத்தில் இருக்கும் அவ்வீடு வாங்கியவனுக்கும், அவன் பின்வரும் சந்ததிக்கும் நிரந்தர உரிமையாகும். அது யூபிலி வருடத்தில் திருப்பிக்கொடுக்கப்பட வேண்டியதில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","ஆனால் மதில் சூழப்படாத கிராமப் பகுதிகளிலுள்ள வீடுகள், நாட்டின் நிலங்களைப்போல் கருதப்படும். அவை மீட்கப்படலாம். யூபிலி வருடத்தில் அவை திருப்பி கொடுக்கப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘ஆனால் லேவியர்களோ, லேவியருடைய நகரங்களிலிருக்கிற தங்களுடைய வீடுகளை மீட்க எப்பொழுதும் உரிமையுடையவர்களாய் இருக்கிறார்கள். அவை அவர்களுடைய உரிமைச்சொத்துக்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","எனவே லேவியருடைய சொத்து மீட்கக்கூடியது. அதாவது அவர்களுக்குரிய எந்தப் பட்டணத்திலாவது ஒரு வீடு விற்கப்பட்டால், அது யூபிலி வருடத்தில் திருப்பிக்கொடுக்கப்பட வேண்டும். ஏனெனில், இஸ்ரயேலர் மத்தியில் லேவியர்களுடைய பட்டணங்களிலுள்ள வீடுகள் மட்டுமே அவர்களுடைய சொத்தாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","ஆனால் அவர்களுடைய பட்டணங்களுக்குரிய மேய்ச்சல் நிலமோ, விற்கப்படக்கூடாது. ஏனெனில், அவை அவர்களின் நிரந்தர சொத்துரிமை. ");
INSERT INTO tamtcv_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘உங்கள் நாட்டினருக்குள் ஒருவன் ஏழையாகி, தன்னைத்தானே பராமரிக்க இயலாத வேளையில், ஒரு பிறநாட்டினனுக்கோ, தற்காலிக குடியிருப்பாளனுக்கோ உதவுவதுபோல் நீங்கள் அவனுக்கு உதவிசெய்யுங்கள். அவ்வாறு உங்கள் மத்தியில் அவன் தொடர்ந்து வாழலாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","அவனிடம் எவ்வித வட்டியையும் வாங்கவேண்டாம். ஆனால் உங்கள் இறைவனுக்குப் பயந்து நடவுங்கள். இப்படியாக உங்கள் நாட்டினன் உங்கள் மத்தியில் தொடர்ந்து வாழலாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","நீங்கள் அவனுக்கு வட்டிக்குக் கடன் கொடுக்கக்கூடாது. இலாபத்திற்கு அவனுக்கு உணவும் விற்கக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","உங்களுக்குக் கானான் நாட்டைக் கொடுக்கவும், உங்கள் இறைவனாயிருக்கவும் உங்களை எகிப்து நாட்டிலிருந்து வெளியே கொண்டுவந்த, உங்கள் இறைவனாகிய யெகோவா நானே. ");
INSERT INTO tamtcv_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘உங்கள் நாட்டவரில் ஒருவன் உங்களுக்குள் ஏழையாகி தன்னை விற்றால், அவனை அடிமையாக வேலைசெய்ய வைக்கவேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","அவன் ஒரு கூலிக்காரனைப் போலவும், உங்களிடம் வந்த தற்காலிக குடியிருப்பாளனைப் போலவும் நடத்தப்படவேண்டும். யூபிலி வருடம்வரை அவன் உங்களுக்குப் பணிசெய்ய வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","அதன்பின் அவனும் அவன் பிள்ளைகளும் விடுவிக்கப்பட வேண்டும். அவன் தன் சொந்தக் கோத்திரத்திற்கும் முற்பிதாக்களின் சொத்து நிலத்திற்கும் திரும்பிப் போகவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","எகிப்து நாட்டிலிருந்து நான் வெளியே கொண்டுவந்த இஸ்ரயேலர் என் பணியாட்களாய் இருப்பதால், அவர்கள் அடிமைகளாக விற்கப்படக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","அவர்களை நீங்கள் கொடூரமாய் ஆளுகை செய்யாமல் உங்கள் இறைவனுக்குப் பயந்து நடவுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘உங்களைச் சுற்றியிருக்கிற நாடுகளிடமிருந்தே உங்களுக்கு ஆண் அடிமைகளும், பெண் அடிமைகளும் வரவேண்டும். அவர்களிடமிருந்தே நீங்கள் அடிமைகளை வாங்கலாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","உங்கள் மத்தியில் வசிக்கும் தற்காலிக குடியிருப்பாளர்களில் சிலரை அடிமைகளாக வாங்கலாம். உங்கள் நாட்டில் பிறந்த அவர்களின் வம்சத்தைச் சேர்ந்த அங்கத்தினர்களையும் வாங்கலாம். அவர்கள் உங்கள் சொத்துக்களாவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","நீங்கள் அவர்களை உங்கள் பிள்ளைகளுக்கு உரிமைச்சொத்தாக எழுதிக்கொடுத்து, அவர்களை ஆயுட்கால அடிமைகளாக்கலாம். ஆனால் உங்கள் சகோதரராகிய இஸ்ரயேலரைக் கொடூரமாய் ஆளுகை செய்யக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘உங்களுக்குள் வாழும் பிறநாட்டினனோ அல்லது தற்காலிக குடியிருப்பாளனோ செல்வந்தனாயிருக்கையில் உங்கள் நாட்டவரில் ஒருவன் ஏழையாகி, அந்த பிறநாட்டினனுக்கோ அல்லது பிற நாட்டு வம்சத்தைச் சேர்ந்த அங்கத்தினருக்கோ தன்னை விற்றால், ");
INSERT INTO tamtcv_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","தன்னை விற்றுவிட்ட பின்பும் தன்னை மீட்டுக்கொள்ளும் உரிமையுடையவனாய் இருக்கிறான். அவனுடைய உறவினருக்குள் ஒருவன் அவனை மீட்கலாம்: ");
INSERT INTO tamtcv_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","அவனுடைய சிறிய தகப்பனோ அல்லது சிறிய தகப்பனுடைய மகனோ அல்லது அவனுடைய வம்சத்தைச் சேர்ந்த இரத்த உறவினனோ அவனை மீட்டுக்கொள்ளலாம். அல்லது அவன் செழிப்படையும்போது தன்னைத்தானே மீட்டுக்கொள்ளவும் முடியும். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","அவனும், அவனை வாங்கியவனும் அவன் தன்னை விற்ற வருடத்திலிருந்து யூபிலி வருடம் வரையுள்ள காலத்தைக் கணக்கிடவேண்டும். ஒரு கூலியாளுக்குச் செலுத்தப்படுகின்ற கூலி அளவை அடிப்படையாகக்கொண்டு அவனுக்குரிய விடுதலைக்கான விலை அமையவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","இன்னும் அநேக வருடங்கள் இருக்குமானால், தனக்காகச் செலுத்தப்பட்ட விலைமதிப்பின் ஒரு பெரிய பங்கை அவன் தன்னுடைய மீட்புக்காகச் செலுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","யூபிலி வருடத்திற்கு இன்னும் சில வருடங்கள் மட்டுமே இருக்குமானால், அவன் அதைக் கணக்கிட்டு, அதற்கேற்ப தன் மீட்புக்கான பணத்தைக் கொடுக்கலாம். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","அவன் வருடத்திற்கு வருடம் கூலிக்கு அமர்த்தப்பட்டவன்போல் நடத்தப்படவேண்டும். அவனுடைய எஜமான் அவனைக் கொடூரமாய் நடத்தாதபடி நீங்கள் பார்த்துக்கொள்ளவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘இவ்விதமாக, எந்த வழிகளிலாவது அவன் மீட்கப்படாவிட்டாலும், அவனும் அவனுடைய பிள்ளைகளும், யூபிலி வருடத்தில் விடுதலையாக்கப்பட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","ஏனெனில், இஸ்ரயேலர் என் பணியாட்களாக எனக்கு சொந்தமாயிருக்கிறார்கள். அவர்கள் நான் எகிப்து நாட்டிலிருந்து வெளியே கொண்டுவந்த பணியாட்கள். நானே உங்கள் இறைவனாகிய யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘நீங்கள் விக்கிரகங்களைச் செய்யவேண்டாம். உருவச்சிலையையோ, உங்களுக்காக புனிதக் கல்லையோ அமைக்கவேண்டாம். உங்கள் நாட்டில் தலைகுனிந்து வணங்குவதற்காக ஒரு செதுக்கப்பட்ட கல்லை வைக்கக்கூடாது. நானே உங்கள் இறைவனாகிய யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ ‘நீங்கள் என்னுடைய ஓய்வுநாட்களை அனுசரித்து, என் பரிசுத்த இடத்தைக் குறித்து பயபக்தியாயிருங்கள். நான் யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘நீங்கள் என் விதிமுறைகளைப் பின்பற்றி, என் கட்டளைகளுக்குக் கீழ்ப்படிய கவனமாயிருந்தால், ");
INSERT INTO tamtcv_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","மழையை அதன் பருவகாலத்தில் அனுப்புவேன். பூமி தனது விளைச்சலையும், வயல்களின் மரங்கள் தங்கள் பழங்களையும் கொடுக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","உங்கள் சூடுமிதிக்கும் காலம், திராட்சைப்பழம் பறிக்குங்காலம்வரை நீடிக்கும். திராட்சைப்பழம் பறிக்குங்காலம், நடுகைக்காலம்வரை நீடிக்கும். ஆகையால் நீங்கள் விரும்பிய எல்லா உணவையும் சாப்பிட்டு உங்கள் நாட்டிலே பாதுகாப்புடன் வாழ்வீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ ‘நாட்டில் சமாதானத்தைத் தருவேன். நீங்கள் பயமில்லாமல் படுத்திருப்பீர்கள். உங்களை ஒருவரும் பயமுறுத்தமாட்டார்கள். நாட்டிலிருந்து கொடிய மிருகங்களைத் துரத்திவிடுவேன். உங்கள் நாட்டை வாள் கடந்துவராது. ");
INSERT INTO tamtcv_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","நீங்கள் உங்கள் பகைவர்களைப் பின்தொடர்ந்து துரத்துவீர்கள். அவர்கள் உங்கள் முன்பாக வாளால் வெட்டுண்டு விழுவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","உங்களில் ஐந்துபேர், நூறுபேரைத் துரத்துவீர்கள். நூறுபேர், பத்தாயிரம்பேரைத் துரத்துவீர்கள். இவ்விதம் உங்கள் பகைவர்கள் வாளினால் உங்கள்முன் விழுவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“ ‘நான் உங்களைத் தயவுடன் பார்த்து, உங்களை வளம்பெறச்செய்து பலுகிப் பெருகப்பண்ணுவேன். நான் உங்களோடு பண்ணின உடன்படிக்கையைக் காத்துக்கொள்வேன். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","நீங்கள் இன்னும் கடந்த வருட விளைச்சலைச் சாப்பிட்டுக் கொண்டிருக்கும்போதே புதிய விளைச்சலுக்கு இடம் ஒதுக்கும்படியாக பழையதை அகற்றவேண்டியதாயிருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","நான் என் வசிப்பிடத்தை உங்கள் மத்தியில் வைப்பேன். உங்களைப் புறக்கணிக்கமாட்டேன். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","நான் உங்கள் மத்தியில் நடந்து, உங்கள் இறைவனாயிருப்பேன். நீங்களும் என் மக்களாயிருப்பீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","இனிமேலும் நீங்கள் எகிப்தியருக்கு அடிமைகளாயிராதபடிக்கு உங்களை எகிப்திலிருந்து வெளியே கொண்டுவந்த நானே உங்கள் இறைவனாகிய யெகோவா. உங்கள் நுகத்தின் தடிகளை முறித்து உங்களைத் தலைநிமிர்ந்து நடக்கும்படிச் செய்தேன். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘ஆனால் நீங்கள் எனக்குச் செவிகொடாமலும், இந்த எல்லா கட்டளைகளையும் கைக்கொள்ளாமலும், ");
INSERT INTO tamtcv_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","என் விதிமுறைகளைப் புறக்கணித்து, என் சட்டங்களை வெறுத்து, என் கட்டளைகள் எல்லாவற்றையும் செய்யத்தவறி, என் உடன்படிக்கையை மீறுவீர்களானால், ");
INSERT INTO tamtcv_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","அப்பொழுது நான் உங்களுக்குச் செய்வதாவது: உங்கள்மேல் திடீர் பயங்கரத்தையும் அழிக்கும் வியாதிகளையும் கொண்டுவருவேன். உங்கள் கண் பார்வையை அற்றுப்போகச்செய்து, உங்கள் உயிரைக் குடிக்கும் காய்ச்சலையும் கொண்டுவருவேன். நீங்கள் தானியத்தை வீணாகவே விதைப்பீர்கள். ஏனெனில், உங்கள் பகைவர்களே அதைச் சாப்பிடுவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","நான் என் முகத்தை உங்களுக்கு விரோதமாகத் திருப்புவேன். அப்பொழுது நீங்கள் உங்கள் பகைவர்களால் தோற்கடிக்கப்படுவீர்கள். உங்களை வெறுக்கிறவர்கள் உங்களை ஆளுவார்கள். ஒருவரும் உங்களைத் துரத்தாமலே நீங்கள் பயந்து ஓடுவீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ ‘இவைகளெல்லாம் நடந்த பின்பும் நீங்கள் எனக்குச் செவிகொடாமற்போனால், நான் உங்களை உங்கள் பாவத்தின் நிமித்தம் ஏழுமடங்கு அதிகமாகத் தண்டிப்பேன். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","உங்கள் பிடிவாதமான பெருமையை உடைப்பேன். உங்கள் மேலிருக்கும் வானத்தை இரும்பைப்போலவும், கீழிருக்கும் நிலத்தை வெண்கலத்தைப்போலவும் ஆக்குவேன். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","உங்கள் பெலன் வீணாகப் போகும். ஏனெனில், உங்கள் மண், விளைச்சலைக் கொடுக்காது. உங்கள் நாட்டின் மரங்கள் பழங்களைக் கொடுக்காது. ");
INSERT INTO tamtcv_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ ‘நீங்கள் என்னுடன் பகைமை பாராட்டி, தொடர்ந்து எனக்குச் செவிகொடுக்க மறுத்தால், உங்கள் பாவத்திற்குத்தக்கதாக உங்கள் வாதைகளை ஏழுமடங்காக அதிகரிப்பேன். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","காட்டு மிருகங்களை உங்களுக்கு எதிராக அனுப்புவேன். அவை உங்கள் பிள்ளைகளை உங்களிடமிருந்து கொள்ளையிட்டு, உங்கள் மந்தைகளை அழிக்கும். அவை உங்கள் எண்ணிக்கையை வெகுவாய்க் குறைக்கும். அப்பொழுது உங்கள் வீதிகள் வெறிச்சோடிக் கிடக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ ‘இப்படியிருக்க, நீங்கள் என் கண்டிப்பை ஏற்றுக்கொள்ளாமல் தொடர்ந்து என்னுடன் பகைமை பாராட்டினால், ");
INSERT INTO tamtcv_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","நானும் உங்களுடன் பகைமை பாராட்டி, உங்கள் பாவத்திற்காக உங்களை ஏழுமடங்காகத் துன்புறுத்துவேன். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","என்னுடைய உடன்படிக்கையை நீங்கள் மீறினதினால் உங்களைப் பழிவாங்குவதற்காக வாளை உங்கள்மேல் வரப்பண்ணுவேன். நீங்கள் உங்கள் பட்டணத்திற்குள் பின்வாங்கும்போது உங்களுக்குள் கொள்ளைநோயை அனுப்புவேன். நீங்கள் உங்கள் பகைவரின் கைகளில் ஒப்புக்கொடுக்கப்படுவீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","உங்களுக்கு அன்றாடம் கிடைக்கும் உணவை அகற்றிப்போடுவேன். அப்பொழுது பத்துப் பெண்கள் உங்களுக்கான அப்பத்தை ஒரே அடுப்பிலேயே சுடக்கூடியதாய் இருக்கும். அவர்கள் அப்பத்தை நிறைப்படி பங்கிட்டுக் கொஞ்சமாகக் கொடுப்பார்கள். நீங்கள் சாப்பிடுவீர்கள். ஆனால் திருப்தியடையமாட்டீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ ‘இது இப்படியிருந்தும், நீங்கள் இன்னும் எனக்குச் செவிகொடுக்காமல் தொடர்ந்து என்னுடன் பகைமை பாராட்டினால், ");
INSERT INTO tamtcv_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","அப்பொழுது நானும் என் கோபத்தில் உங்களுடன் பகைமை பாராட்டி, உங்கள் பாவத்திற்காக ஏழுமடங்கு நானே உங்களைத் தண்டிப்பேன். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","நீங்கள் உங்கள் மகன்களுடைய, மகள்களுடைய சதையைச் சாப்பிடுவீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","உங்கள் மேடைகளை நான் அழித்து, உங்கள் தூபபீடங்களை இடித்து, உங்கள் இறந்த உடல்களை அச்சிலைகளின் உயிரற்ற உருவங்களின்மேல் வைப்பேன். உங்களை நான் அருவருப்பேன். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","உங்கள் பட்டணங்களை இடிபாடுகளாக்குவேன். உங்கள் பரிசுத்த இடங்களைப் பாழாக்கிப்போடுவேன். உங்கள் காணிக்கைகளின் மகிழ்ச்சியூட்டும் நறுமணத்தில் நான் மகிழ்ச்சியாக இருக்கமாட்டேன். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","நான் உங்கள் நாட்டை பாழாக்கிப்போடுவேன். அப்பொழுது அங்கு வாழும் உங்கள் பகைவர்கள் திகைப்படைவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","நாடுகளுக்குள் உங்களை சிதறப்பண்ணி, என் வாளை உருவி உங்களைப் பின்தொடர்ந்து துரத்துவேன். உங்கள் நாடு பாழாக்கப்படும். பட்டணங்களும் இடிபாடுகளாய்க் கிடக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","நீங்கள் உங்கள் பகைவருடைய நாட்டில் இருக்கையில், நாடு பாழாய்க்கிடக்கும். காலமெல்லாம் அது தன் ஓய்வு வருடங்களை அனுபவிக்கும். அப்பொழுது நாடு ஓய்ந்திருந்து, தனது ஓய்வுநாட்களைக் கொண்டாடும். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","நாடு பாழாய்க்கிடக்கும் காலமெல்லாம் முன்பு நீங்கள் அதில் வாழ்ந்தபோது, நாடு பெற்றுக்கொள்ளாத ஓய்வு அது இப்பொழுது பெற்றுக்கொள்ளும். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ ‘உங்களில் மீதமிருப்போரைக் குறித்தோவெனில், அவர்களுடைய பகைவர்களின் நாடுகளில், அவர்களுடைய இருதயங்களைப் பயம் நிறைந்ததாக்குவேன். அப்பொழுது காற்றினால் அடிக்கப்படும் ஒரு இலையின் சத்தங்கூட அவர்களைப் பயந்தோடப்பண்ணும். அவர்கள் வாளுக்குத் தப்பி ஓடுகிறவர்கள்போல் ஓடுவார்கள். அவர்களை ஒருவரும் துரத்தாதபோதும் அவர்கள் விழுவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","அவர்களை ஒருவரும் துரத்தாதிருந்தும் வாளுக்குத் தப்பி ஓடுகிறவர்களைப்போல் ஓடி, ஒருவர்மேல் ஒருவர் இடறி விழுவார்கள். இப்படியாக உங்களுக்கு உங்கள் பகைவர்களை எதிர்த்துநிற்க முடியாதிருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","நீங்கள் நாடுகளுக்குள் அழிந்துபோவீர்கள். உங்கள் பகைவர்களின் நாடு உங்களை விழுங்கும். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","உங்களில் மீதமுள்ளவர்கள் தங்கள் பாவத்திற்காகவும், தங்கள் முற்பிதாக்களின் பாவத்திற்காகவும் தங்கள் பகைவர்களின் நாட்டில் உருக்குலைந்து போவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ ‘எனவே அவர்கள் அவர்களுடைய பாவத்தையும், தங்கள் முற்பிதாக்களின் பாவங்களையும் அவர்களின் எனக்கெதிரான துரோகங்களையும், என்னுடனிருந்த பகைமையையும் அறிக்கையிடுவார்கள், ");
INSERT INTO tamtcv_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","கடைசியாக நான் என் கோபத்தினால் அவர்களை அவர்களுடைய பகைவர்களின் நாடுகளுக்குக் கொண்டுவரும்போது, அவர்களின் விருத்தசேதனம் செய்யப்படாத இருதயங்கள் தாழ்த்தப்பட்டு, அவர்களின் பாவங்களுக்கு அவர்கள் தண்டனையை அனுபவிப்பார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","அப்பொழுது நான் யாக்கோபுடன் செய்துகொண்ட என் உடன்படிக்கையையும், ஈசாக்குடன் செய்துகொண்ட என் உடன்படிக்கையையும், ஆபிரகாமுடன் செய்துகொண்ட என் உடன்படிக்கையையும், நினைவுகூருவேன். நாட்டையும் நான் நினைவுகூருவேன். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","நாடு அவர்களால் கைவிடப்பட்டு, அவர்கள் யாரும் இல்லாமல் பாழாய்க் கிடக்கும்போது அது தன் ஓய்வை கொண்டாடும். ஆனால் அவர்கள் என்னுடைய சட்டங்களைப் புறக்கணித்து, என் கட்டளைகளை வெறுத்தால், தங்கள் பாவத்திற்கான தண்டனையை அனுபவிப்பார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","இப்படியெல்லாமிருந்தும், தங்கள் பகைவர்களின் நாட்டில் அவர்கள் வாழும்போது, அவர்களுடனான என் உடன்படிக்கையை அவர்கள் உடைத்தாலும், நான் அவர்களை முற்றிலும் புறக்கணிக்கவோ, அவர்களை முற்றிலும் அழிக்கும்படி வெறுக்கவோமாட்டேன். ஏனெனில், அவர்களின் இறைவனாகிய யெகோவா நானே. ");
INSERT INTO tamtcv_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","நான் அவர்களுக்கு இறைவனாயிருக்கும்படி, நாடுகளுக்கு முன்பாக எகிப்திலிருந்து வெளியே கொண்டுவந்த அவர்களின் முன்னோர்களோடு, நான் பண்ணின உடன்படிக்கையை, அவர்களுக்காக நினைவுகூருவேன். நானே யெகோவா’ என்றார்.” ");
INSERT INTO tamtcv_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","சீனாய் மலையில் யெகோவா தமக்கும், இஸ்ரயேலருக்கும் இடையில் மோசேயின் மூலம் ஏற்படுத்திய விதிமுறைகளும், சட்டங்களும், ஒழுங்குவிதிகளும் இவையே. ");
INSERT INTO tamtcv_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","மீண்டும் யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“நீ இஸ்ரயேலருடன் பேசிச் சொல்லவேண்டியதாவது: ‘ஒருவன் ஆட்களுக்குரிய சரியான மதிப்பைச் செலுத்துவதின்மூலம், அவர்களை யெகோவாவுக்கு அர்ப்பணிப்பதற்காக, ஒரு விசேஷ நேர்த்திக்கடனை செய்தால், கொடுக்கவேண்டிய மதிப்பாவது: ");
INSERT INTO tamtcv_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","இருபது வயதிற்கும் அறுபது வயதிற்கும் இடைப்பட்ட, ஆணுக்குரிய மதிப்பு பரிசுத்த இடத்தின் சேக்கல் நிறைப்படி ஐம்பது சேக்கல் வெள்ளிக்காசு ஆகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","அது ஒரு பெண்ணாயிருந்தால் அவளுக்குரிய மதிப்பு முப்பது சேக்கல் வெள்ளிக்காசு ஆகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","ஐந்து வயதிற்கும் இருபது வயதிற்கும் இடைப்பட்ட ஒரு நபராயிருந்தால், ஆணுக்குரிய மதிப்பு இருபது சேக்கலும், பெண்ணுக்குரிய மதிப்பு பத்து சேக்கலும் ஆகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ஒரு மாதத்திற்கும், ஐந்து வருடத்திற்கும் இடைப்பட்ட ஆண் பிள்ளைக்குரிய மதிப்பு ஐந்து சேக்கல் வெள்ளிக்காசும், பெண் பிள்ளைக்குரிய மதிப்பு மூன்று சேக்கல் வெள்ளிக்காசும் ஆகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","அறுபது வயதிற்கும் அதற்கும் மேற்பட்ட நபராயிருந்தால், ஆணுக்குரிய மதிப்பு பதினைந்து சேக்கல் வெள்ளிக்காசும், பெண்ணுக்குரிய மதிப்பு பத்து சேக்கல் வெள்ளிக்காசும் ஆகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","நேர்த்திக்கடனை செய்கிறவன் குறிப்பிடப்பட்ட தொகையைச் செலுத்தமுடியாத அளவு ஏழையாயிருந்தால், அவன் அந்த நபரை ஆசாரியனிடம் கொண்டுவர வேண்டும். நேர்த்திக்கடனைச் செய்கிற மனிதனின் தகுதிக்கேற்ப அவனுடைய மதிப்பை ஆசாரியன் நிர்ணயிப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘ஒருவன் நேர்த்திக்கடன் செய்தது யெகோவாவுக்குக் காணிக்கையாக ஏற்றுக்கொள்ளத்தக்க ஒரு மிருகமானால், யெகோவாவுக்குக் கொடுக்கப்பட்ட அந்த மிருகம் பரிசுத்தமாயிருக்கிறது. ");
INSERT INTO tamtcv_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","அவன் அதை மாற்றி எடுக்கக்கூடாது. கெட்டவைக்காக நல்லதையோ, நல்லவைக்காக கெட்டதையோ பதிலீடு செய்யக்கூடாது. ஒரு மிருகத்திற்காக வேறொரு மிருகத்தை பதிலீடு செய்தால், அதுவும் பதிலீடு செய்யப்பட்ட மிருகமான இரண்டும் பரிசுத்தமாகின்றன. ");
INSERT INTO tamtcv_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","ஆனாலும், யெகோவாவுக்குக் காணிக்கையாக நேர்த்திக்கடன் செய்யப்பட்ட மிருகம் ஏற்றுக்கொள்ளத் தகாததானால், சம்பிரதாயப்படி அசுத்தமான அது, அவனால் ஆசாரியன் முன் கொண்டுவந்து நிறுத்தப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ஆசாரியன் அது நல்லதோ, கெட்டதோ என்று அதன் தன்மையை மதிப்பிடவேண்டும். ஆசாரியன் தீர்மானிக்கும் மதிப்பே அதற்குரிய மதிப்பாயிருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","அதன் உரிமையாளன் அந்த மிருகத்தை மீட்டுக்கொள்ள விரும்பினால், அதன் மதிப்புடன் ஐந்தில் ஒரு பங்கையும் சேர்த்துக் கொடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘ஒருவன் தன் வீட்டை யெகோவாவுக்குப் பரிசுத்தமானதாக அர்ப்பணித்தால், அது நல்லதோ, கெட்டதோ என அதன் தரத்தை ஆசாரியன் மதிப்பிடவேண்டும். ஆசாரியன் தீர்மானிக்கும் மதிப்பே அதற்குரிய மதிப்பாயிருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","தன் வீட்டை அர்ப்பணிக்கிற மனிதன் அதை மீட்டுக்கொள்வதானால், அதன் மதிப்புடன் ஐந்தில் ஒரு பங்கையும் சேர்த்துக் கொடுக்கவேண்டும். அப்பொழுது அந்த வீடு திரும்பவும் அவனுக்குரியதாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘ஒருவன் தன் குடும்ப நிலத்தின் ஒரு பகுதியை யெகோவாவுக்கு அர்ப்பணித்தால், அதற்குத் தேவையான விதைத் தானியத்தின் அளவுக்கேற்றபடி அதன் மதிப்பைத் தீர்மானிக்கவேண்டும். ஒரு ஓமர் அளவு வாற்கோதுமை விதைக்கு ஐம்பது சேக்கல் வெள்ளிக்காசுகள் என மதிக்கப்பட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","அவன் தனது வயலை யூபிலி வருடத்தில் அர்ப்பணிப்பதானால், தீர்மானிக்கப்பட்ட மதிப்பு அப்படியே இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","ஆனால் அவன் தன் வயலை யூபிலி வருடத்திற்குப்பின் அர்ப்பணிப்பதானால், அடுத்த யூபிலி வருடம்வரை மீதமுள்ள வருடங்களின் எண்ணிக்கைக்கு ஏற்ப ஆசாரியன் அதன் மதிப்பைத் தீர்மானிக்கப்பட்ட மதிப்பிலிருந்து குறைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","அந்த வயலை அர்ப்பணிக்கிறவன் அதை மீட்க விரும்பினால், அதன் மதிப்புடன் ஐந்தில் ஒரு பங்கையும் சேர்த்துக் கொடுக்கவேண்டும். அப்பொழுது அந்த வயல் திரும்பவும் அவனுக்குரியதாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","ஆனாலும் அவன் அந்த வயலை மீட்டுக்கொள்ளாவிட்டால் அல்லது வேறொருவனுக்கு விற்றால், அந்த வயலை ஒருபோதும் மீட்கமுடியாது. ");
INSERT INTO tamtcv_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","யூபிலி, வருடத்தில் அந்த வயல் திருப்பிக் கொடுக்கப்படும்பொழுது, யெகோவாவுக்கு அர்ப்பணிக்கப்பட்ட வயலைப்போல அது பரிசுத்தமாகும். அது ஆசாரியர்களின் சொத்தாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘ஒருவன் தன் குடும்ப நிலத்தின் பங்கு அல்லாத வயலை வாங்கி, அதை யெகோவாவுக்கு அர்ப்பணித்தால், ");
INSERT INTO tamtcv_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ஆசாரியன் அதன் மதிப்பை யூபிலி வருடம் வரைக்கும் தீர்மானிப்பான். அந்த மனிதன் அந்த நாளிலே அதன் மதிப்பை யெகோவாவுக்கு பரிசுத்தமானதாகச் செலுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","அந்த வயல் யாருக்குச் சொந்தமாய் இருந்து, யாரிடத்தில் வாங்கப்பட்டதோ அது யூபிலி வருடத்தில் அவனுக்கே திரும்பவும் சேரும். ");
INSERT INTO tamtcv_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","எல்லா மதிப்பும் பரிசுத்த இடத்தின் சேக்கலுக்கு ஏற்ப தீர்மானிக்கப்பட வேண்டும். இருபது கேரா ஒரு சேக்கல். ");
INSERT INTO tamtcv_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘தலையீற்று ஏற்கெனவே யெகோவாவுக்கு சொந்தமாய் இருக்கிறது. ஆகையால் ஒருவனும் ஒரு மிருகத்தின் தலையீற்றை அர்ப்பணிக்கக் கூடாது. அது மாடானாலும் சரி, செம்மறியாடானாலும் சரி, அது யெகோவாவுக்கே உரியது. ");
INSERT INTO tamtcv_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","அது அசுத்த மிருகங்களில் ஒன்றானால், அதற்காக மதிப்பிடப்பட்ட மதிப்பையும், அதன் ஐந்தில் ஒரு பங்கையும் சேர்த்துக் கொடுத்து, அவன் அதைத் திரும்ப வாங்கலாம். அவன் மீட்காவிட்டால் அதற்காக தீர்மானித்த மதிப்புக்கு அது விற்கப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘மனிதனானாலும், மிருகமானாலும், குடும்ப நிலமானாலும் ஒரு மனிதனுக்கு உரிமையாயிருப்பது அர்ப்பணிக்கப்பட்டால், அது விற்கப்படவோ, மீட்கப்படவோ கூடாது. அவை ஒவ்வொன்றும் யெகோவாவுக்கு மிகவும் பரிசுத்தமானது. ");
INSERT INTO tamtcv_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ ‘அழிவுக்காக நியமிக்கப்பட்ட எவனும் மீட்கப்படக்கூடாது. அவன் கொல்லப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘மண்ணின் தானியமும், மரங்களின் பழங்களுமான நிலத்தின் எல்லா பலனிலும் பத்தில் ஒரு பங்கு யெகோவாவுக்குச் சொந்தமானது. இது யெகோவாவுக்குப் பரிசுத்தமானது. ");
INSERT INTO tamtcv_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","யாராவது தனது பத்தில் ஒரு பங்கை மீட்டுக்கொள்வதானால், அதன் மதிப்புடன் ஐந்தில் ஒரு பங்கையும் சேர்த்துக்கொடுத்தே அதை மீட்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","மேய்ப்பனின் கோலின்கீழ் கடந்துபோகிற ஒவ்வொரு பத்தாவது மிருகமும், மாட்டு மந்தையிலிருந்தும், ஆட்டு மந்தையிலிருந்தும் எடுக்கப்படும் முழுமையான பத்தில் ஒரு பங்காக யெகோவாவுக்கு பரிசுத்தமாகும். ");
INSERT INTO tamtcv_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","அவன் கெட்டதிலிருந்து நல்லதைத் தெரிந்தெடுக்கவோ அல்லது பதிலீடு எதையும் செய்யவோ கூடாது. அப்படி அவன் பதிலீடு செய்தால், அந்த மிருகமும், பதிலீடு செய்யப்பட்ட மிருகமான இரண்டும் பரிசுத்தமானதாகும். அவற்றை மீட்கமுடியாது’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","யெகோவா இஸ்ரயேலருக்காக, சீனாய் மலையில் மோசேக்குக் கொடுத்த கட்டளைகள் இவையே.");
INSERT INTO tamtcv_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","இஸ்ரயேலர் எகிப்திலிருந்து வந்த இரண்டாம் வருடம் இரண்டாம் மாதம் முதலாம் நாள், சீனாய் பாலைவனத்தில், சபைக் கூடாரத்தில் யெகோவா மோசேயுடன் பேசினார். அவர் சொன்னதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“நீ இஸ்ரயேலின் முழு சமுதாயத்தையும், வம்சங்களின்படியும், குடும்பங்களின்படியும் கணக்கிடவேண்டும். ஒவ்வொருவரையும் பெயர் பெயராகப் பதிவு செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","நீயும், ஆரோனும் படையில் பணிபுரியக்கூடிய இருபது வயதையும், அதற்கு மேற்பட்ட வயதையும் உடைய எல்லா இஸ்ரயேல் மனிதர்களையும், அவர்களுடைய பிரிவுகளின்படி கணக்கிடுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","இதற்காக ஒவ்வொரு கோத்திரத்திலிருந்தும், குடும்பத்தின் தலைவன் உனக்கு உதவிசெய்ய வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“உனக்கு உதவியாய் இருக்கவேண்டியவர்களின் பெயர்களாவன: “ரூபன் கோத்திரத்திலிருந்து சேதேயூரின் மகன் எலிசூர்; ");
INSERT INTO tamtcv_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","சிமியோன் கோத்திரத்திலிருந்து சூரிஷதாயின் மகன் செலூமியேல், ");
INSERT INTO tamtcv_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","யூதா கோத்திரத்திலிருந்து அம்மினதாபின் மகன் நகசோன், ");
INSERT INTO tamtcv_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","இசக்கார் கோத்திரத்திலிருந்து சூவாரின் மகன் நெதனெயேல், ");
INSERT INTO tamtcv_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","செபுலோன் கோத்திரத்திலிருந்து ஏலோனின் மகன் எலியாப், ");
INSERT INTO tamtcv_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","யோசேப்பின் மகன்களான எப்பிராயீமின் கோத்திரத்திலிருந்து அம்மியூதின் மகன் எலிஷாமா, மனாசே கோத்திரத்திலிருந்து பெதாசூரின் மகன் கமாலியேல், ");
INSERT INTO tamtcv_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","பென்யமீன் கோத்திரத்திலிருந்து கீதியோனியின் மகன் அபீதான், ");
INSERT INTO tamtcv_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","தாண் கோத்திரத்திலிருந்து அம்மிஷதாயின் மகன் அகியேசேர், ");
INSERT INTO tamtcv_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","ஆசேர் கோத்திரத்திலிருந்து ஓகிரானின் மகன் பாகியேல், ");
INSERT INTO tamtcv_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","காத் கோத்திரத்திலிருந்து தேகுயேலின் மகன் எலியாசாப், ");
INSERT INTO tamtcv_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","நப்தலி கோத்திரத்திலிருந்து ஏனானின் மகன் அகீரா.” ");
INSERT INTO tamtcv_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","தங்களுடைய முற்பிதாக்களின் கோத்திரங்களின் தலைவர்களாக, இஸ்ரயேல் சமுதாயத்திலிருந்து நியமிக்கப்பட்ட மனிதர்கள் இவர்களே. இஸ்ரயேல் வம்சங்களின் தலைவர்களும் இவர்களே. ");
INSERT INTO tamtcv_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","மோசேயும், ஆரோனும் பெயர் கொடுக்கப்பட்ட இம்மனிதரைச் சேர்த்துக்கொண்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","இரண்டாம் மாதம் முதலாம் நாளில், இஸ்ரயேலின் முழு சமுதாயத்தையும் ஒன்றுகூட்டினார்கள். மக்கள் தங்கள் பரம்பரையைத் தங்கள் வம்சங்களின்படியும், குடும்பங்களின்படியும் குறிப்பிட்டார்கள். இருபது வயதையும், அதற்கு மேற்பட்ட வயதையும் உடைய மனிதர்கள் ஒவ்வொருவரும், பெயர் பெயராகப் பதிவு செய்யப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","யெகோவா மோசேக்குக் கட்டளையிட்டபடியே அவர்கள் செய்தார்கள். இப்படியாக சீனாய் பாலைவனத்தில் அவன் அவர்களைக் கணக்கிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","இஸ்ரயேலின் முதற்பேறான ரூபன் சந்ததியிலிருந்து, இராணுவத்தில் பணிபுரியக்கூடிய, இருபது வயதையும், அதற்கு மேற்பட்ட வயதையும் உடைய எல்லோரும் பதிவு செய்யப்பட்டார்கள். அவர்கள் ஒவ்வொருவரும், தங்களுடைய வம்ச பதிவின்படியும், குடும்ப பதிவின்படியும் பெயர் பெயராகப் பதிவு செய்யப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","ரூபன் கோத்திரத்திலிருந்த எண்ணிக்கை 46,500 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","சிமியோனின் சந்ததிகளிலிருந்து, இராணுவத்தில் பணிபுரியக்கூடிய, இருபது வயதையும் அதற்கு மேற்பட்ட வயதையும் உடைய எல்லோரும் பதிவு செய்யப்பட்டார்கள். அவர்கள் ஒவ்வொருவரும், தங்களுடைய வம்ச பதிவின்படியும், குடும்ப பதிவின்படியும், பெயர் பெயராகப் பதிவு செய்யப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","சிமியோன் கோத்திரத்திலிருந்த எண்ணிக்கை 59,300 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","காத்தின் சந்ததிகளிலிருந்து, இராணுவத்தில் பணிபுரியக்கூடிய இருபது வயதையும், அதற்கு மேற்பட்ட வயதையும் உடைய எல்லோரும் பதிவு செய்யப்பட்டார்கள். அவர்கள் ஒவ்வொருவரும், தங்களுடைய வம்ச பதிவின்படியும், குடும்ப பதிவின்படியும், பெயர் பெயராகப் பதிவு செய்யப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","காத் கோத்திரத்திலிருந்த எண்ணிக்கை 45,650 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","யூதாவின் சந்ததிகளிலிருந்து, இராணுவத்தில் பணிபுரியக்கூடிய இருபது வயதையும், அதற்கு மேற்பட்ட வயதையும் உடைய எல்லோரும் பதிவு செய்யப்பட்டார்கள். அவர்கள் ஒவ்வொருவரும், தங்களுடைய வம்ச பதிவின்படியும், குடும்ப பதிவின்படியும், பெயர் பெயராகப் பதிவு செய்யப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","யூதாவின் கோத்திரத்திலிருந்த எண்ணிக்கை 74,600 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","இசக்கார் சந்ததிகளிலிருந்து, இராணுவத்தில் பணிபுரியக்கூடிய இருபது வயதையும், அதற்கு மேற்பட்ட வயதையும் உடைய எல்லோரும் பதிவு செய்யப்பட்டார்கள். அவர்கள் ஒவ்வொருவரும், தங்களுடைய வம்ச பதிவின்படியும், குடும்ப பதிவின்படியும், பெயர் பெயராகப் பதிவு செய்யப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","இசக்காரின் கோத்திரத்திலிருந்த எண்ணிக்கை 54,400 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","செபுலோனின் சந்ததிகளிலிருந்து, இராணுவத்தில் பணிபுரியக்கூடிய இருபது வயதையும், அதற்கு மேற்பட்ட வயதையும் உடைய எல்லோரும் பதிவு செய்யப்பட்டார்கள். அவர்கள் ஒவ்வொருவரும், தங்களுடைய வம்ச பதிவின்படியும், குடும்ப பதிவின்படியும் பெயர் பெயராகப் பதிவு செய்யப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","செபுலோனின் கோத்திரத்திலிருந்த எண்ணிக்கை 57,400 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","யோசேப்பின் மகனான எப்பிராயீமின் சந்ததிகளிலிருந்து, இராணுவத்தில் பணிபுரியக்கூடிய இருபது வயதையும், அதற்கு மேற்பட்ட வயதையும் உடைய எல்லோரும் பதிவு செய்யப்பட்டார்கள். அவர்கள் ஒவ்வொருவரும், தங்களுடைய வம்ச பதிவின்படியும், குடும்ப பதிவின்படியும் பெயர் பெயராகப் பதிவு செய்யப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","எப்பிராயீமின் கோத்திரத்திலிருந்த எண்ணிக்கை 40,500 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","யோசேப்பின் மகனான மனாசேயின் சந்ததிகளிலிருந்து, இராணுவத்தில் பணிபுரியக்கூடிய இருபது வயதையும், அதற்கு மேற்பட்ட வயதையும் உடைய எல்லோரும் பதிவு செய்யப்பட்டார்கள். அவர்கள் ஒவ்வொருவரும், தங்களுடைய வம்ச பதிவின்படியும், குடும்ப பதிவின்படியும் பெயர் பெயராகப் பதிவு செய்யப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","மனாசேயின் கோத்திரத்திலிருந்த எண்ணிக்கை 32,200 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","பென்யமீனின் சந்ததிகளிலிருந்து, இராணுவத்தில் பணிபுரியக்கூடிய இருபது வயதையும், அதற்கு மேற்பட்ட வயதையும் உடைய எல்லோரும் பதிவு செய்யப்பட்டார்கள். அவர்கள் ஒவ்வொருவரும் தங்களுடைய வம்ச பதிவின்படியும், குடும்ப பதிவின்படியும் பெயர் பெயராகப் பதிவு செய்யப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","பென்யமீனின் கோத்திரத்திலிருந்த எண்ணிக்கை 35,400 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","தாணின் சந்ததிகளிலிருந்து, இராணுவத்தில் பணிபுரியக்கூடிய இருபது வயதையும், அதற்கு மேற்பட்ட வயதையும் உடைய எல்லோரும் பதிவு செய்யப்பட்டார்கள். அவர்கள் ஒவ்வொருவரும், தங்களுடைய வம்ச பதிவின்படியும், குடும்ப பதிவின்படியும், பெயர் பெயராகப் பதிவு செய்யப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","தாணின் கோத்திரத்திலிருந்த எண்ணிக்கை 62,700 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","ஆசேரின் சந்ததிகளிலிருந்து, இராணுவத்தில் பணிபுரியக்கூடிய இருபது வயதையும், அதற்கு மேற்பட்ட வயதையும், உடைய எல்லோரும் பதிவு செய்யப்பட்டார்கள். அவர்கள் ஒவ்வொருவரும், தங்களுடைய வம்ச பதிவின்படியும், குடும்ப பதிவின்படியும் பெயர் பெயராகப் பதிவு செய்யப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","ஆசேரின் கோத்திரத்திலிருந்த எண்ணிக்கை 41,500 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","நப்தலியின் சந்ததிகளிலிருந்து, இராணுவத்தில் பணிபுரியக்கூடிய இருபது வயதையும், அதற்கு மேற்பட்ட வயதையும் உடைய எல்லோரும் பதிவு செய்யப்பட்டார்கள். அவர்கள் ஒவ்வொருவரும், தங்களுடைய வம்ச பதிவின்படியும், குடும்ப பதிவின்படியும் பெயர் பெயராகப் பதிவு செய்யப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","நப்தலியின் கோத்திரத்திலிருந்த எண்ணிக்கை 53,400 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","மோசேயினாலும், ஆரோனாலும், தன்தன் குடும்பத்தைப் பிரதிநிதித்துவப்படுத்திய இஸ்ரயேலரின் பன்னிரண்டு தலைவர்களினாலும் எண்ணப்பட்ட மனிதர்கள் இவர்களே. ");
INSERT INTO tamtcv_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","இஸ்ரயேலின் இராணுவத்தில் பணிசெய்யக்கூடிய இருபது வயதையும், அதற்கு மேற்பட்ட வயதையும் உடைய இஸ்ரயேலர் எல்லோரும் அவர்களுடைய குடும்பங்களின்படியே எண்ணப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","மொத்த எண்ணிக்கை 6,03,550 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","ஆனால், மற்றவர்களோடு லேவி கோத்திரத்தின் குடும்பங்கள் கணக்கிடப்படவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","யெகோவா மோசேயிடம் சொல்லியிருந்ததாவது: ");
INSERT INTO tamtcv_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“நீ லேவி கோத்திரத்தைக் கணக்கிடவோ, அவர்களை மற்ற இஸ்ரயேலருடன் மக்கள் தொகை கணக்கெடுக்கவோ வேண்டாம். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","ஆனால் நீ லேவியரை சாட்சிபகரும் இறைசமுகக் கூடாரத்திற்கும், அதன் எல்லா பணிப்பொருட்களுக்கும், அதற்குரிய எல்லாவற்றிற்கும்மேல் பொறுப்பாக நியமிக்கவேண்டும். இறைசமுகக் கூடாரத்தையும், அதன் பணிமுட்டுகளையும் அவர்களே சுமக்கவேண்டும். அவர்களே அதைப் பராமரித்து, அதைச் சுற்றிலும் முகாமிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","எப்பொழுதாவது இறைசமுகக் கூடாரத்தை நகர்த்தவேண்டுமானால், லேவியரே அதைக் கழற்றவேண்டும். இறைசமுகக் கூடாரத்தை அமைக்கவேண்டுமென்றாலும் அதை லேவியரே செய்யவேண்டும். அதற்கு அருகில் செல்லும் வேறு எவனும் கொல்லப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","இஸ்ரயேலர் தங்கள் பிரிவுகளின்படியே கூடாரங்களை அமைக்கவேண்டும். ஒவ்வொருவனும் தன் சொந்தக் கூடாரத்தில் தன் சொந்தக் கொடியின்கீழ் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","ஆனாலும், இஸ்ரயேல் சமுதாயத்தின்மேல் கோபம் வராதபடிக்கு லேவியர்கள் உடன்படிக்கைக் கூடாரத்தைச் சுற்றி தங்கள் முகாமிடவேண்டும். உடன்படிக்கைக் கூடாரத்தின் பராமரிப்புக்கு லேவியரே பொறுப்பாயிருக்க வேண்டும்.” ");
INSERT INTO tamtcv_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","யெகோவா மோசேக்குக் கட்டளையிட்டபடியே இஸ்ரயேலர் இவற்றையெல்லாம் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","யெகோவா மோசேயிடமும் ஆரோனிடமும் சொன்னதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“இஸ்ரயேலர் சபைக் கூடாரத்தைச் சுற்றி சற்றுத் தொலைவில் தங்கள் முகாம்களை அமைக்கவேண்டும். ஒவ்வொருவனும் தன்தன் சின்னத்தின்கீழ் குடும்பத்தின் கொடியுடன் இருக்கவேண்டும்.” ");
INSERT INTO tamtcv_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","சூரிய உதயத்தை நோக்கிய கிழக்குப் பக்கத்தில், யூதாவின் முகாம் பிரிவுகள் தங்கள் சின்னத்தின்கீழ் முகாமிடவேண்டும். அம்மினதாபின் மகன் நகசோன், யூதா மக்களின் தலைவன். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","அவனுடைய பிரிவின் தொகை 74,600 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","இசக்காரின் கோத்திரத்தார் அவர்களுக்கு அருகில் முகாமிடவேண்டும். சூவாரின் மகன் நெதனெயேல், இசக்கார் மக்களுக்குத் தலைவன். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","அவனுடைய பிரிவின் தொகை 54,400 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","செபுலோனின் கோத்திரம் அடுத்ததாக இருக்கும். ஏலோனின் மகன் எலியாப், செபுலோன் மக்களுக்குத் தலைவன். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","அவனுடைய பிரிவின் தொகை 57,400 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","யூதாவின் பக்கத்துக்கு அவர்களுடைய பிரிவுகளின்படி நியமிக்கப்பட்ட எல்லா மனிதரும் 1,86,400 பேர். அவர்களே முதலில் புறப்படுவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","தென்புறத்தில் ரூபனின் முகாம் பிரிவுகள், தங்கள் சின்னத்தின்கீழ் இருக்கும். சேதேயூரின் மகன் எலிசூர், ரூபன் மக்களுக்குத் தலைவன். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","அவனுடைய பிரிவின் தொகை 46,500 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","சிமியோன் கோத்திரம் அவர்களை அடுத்து முகாமிடவேண்டும். சூரிஷதாயின் மகன் செலூமியேல் சிமியோன் மக்களுக்குத் தலைவன். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","அவனுடைய பிரிவின் தொகை 59,300 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","காத் கோத்திரம் அடுத்ததாக இருக்கும். தேகுயேலின் மகன் எலியாசாப், காத் மக்களுக்குத் தலைவன். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","அவனுடைய பிரிவின் தொகை 45,650 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","ரூபனுடைய பக்கத்துக்கு அவர்களுடைய பிரிவுகளின்படி நியமிக்கப்பட்ட எல்லா மனிதரும் 1,51,450 பேர். அவர்கள் இரண்டாவதாகப் புறப்படுவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","சபைக் கூடாரமும், லேவியரின் முகாமும் மற்ற முகாம்களுக்கு நடுவிலிருந்து புறப்படும். அவர்கள் தாம் முகாமிட்ட அதே ஒழுங்கின்படி ஒவ்வொருவரும் தன்தன் சின்னத்தின் கீழாகப் போவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","மேற்குப் பக்கத்தில் எப்பிராயீமின் முகாமின் பிரிவுகள், தங்கள் கொடியின்கீழ் இருக்கும். அம்மியூதின் மகன் எலிஷாமா, எப்பிராயீம் மக்களுக்குத் தலைவன். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","அவனுடைய பிரிவின் தொகை 40,500 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","மனாசே கோத்திரம் அவர்களுக்கு அடுத்ததாக இருக்கும். பெதாசூரின் மகன் கமாலியேல், மனாசே மக்களுக்குத் தலைவன். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","அவனுடைய பிரிவின் தொகை 32,200 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","பென்யமீன் கோத்திரம் அதற்கு அடுத்ததாக இருக்கும். கீதெயோனின் மகன் அபீதான், பென்யமீன் மக்களுக்குத் தலைவன். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","அவனுடைய பிரிவின் தொகை 35,400 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","எப்பிராயீமின் பக்கத்திற்கு அவர்களுடைய பிரிவுகளின்படி நியமிக்கப்பட்ட எல்லா மனிதரும் 1,08,100 பேர். அவர்கள் மூன்றாவதாகப் புறப்படுவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","வடக்குப் பக்கத்தில் தாண் முகாமின் பிரிவுகள் தங்கள் சின்னத்தின்கீழ் இருக்கும். அம்மிஷதாயின் மகன் அகியேசேர், தாண் மக்களுக்குத் தலைவன். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","அவனுடைய பிரிவின் தொகை 62,700 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","ஆசேர் கோத்திரம் அவர்களை அடுத்ததாக முகாமிடவேண்டும். ஓகிரானின் மகன் பாகியேல், ஆசேர் மக்களுக்குத் தலைவன். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","அவனுடைய பிரிவின் தொகை 41,500 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","நப்தலி கோத்திரம் அடுத்ததாக இருக்கும். ஏனானின் மகன் அகீரா, நப்தலி மக்களுக்குத் தலைவன். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","அவனுடைய பிரிவின் தொகை 53,400 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","தாணின் பக்கத்திற்கு நியமிக்கப்பட்ட மனிதர்களின் மொத்தத்தொகை 1,57,600 பேர். அவர்கள் கடைசியாக தங்கள் கொடிகளின் கீழ் புறப்படுவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","அவரவருடைய குடும்பங்களின்படி கணக்கிடப்பட்ட இஸ்ரயேலர்கள் இவர்களே. அவர்களுடைய பிரிவுகளின்படி முகாம்களில் இருந்த எல்லோருடைய எண்ணிக்கை 6,03,550 பேர். ");
INSERT INTO tamtcv_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","ஆனாலும், யெகோவா மோசேக்குக் கட்டளையிட்டபடி, லேவியர் மற்ற இஸ்ரயேலருடன் கணக்கிடப்படவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","அப்படியே யெகோவா மோசேக்குக் கட்டளையிட்ட எல்லாவற்றையும் இஸ்ரயேலர் செய்தார்கள். அந்த முறையாக அவர்கள் தங்கள் கொடிகளின் கீழே முகாமிட்டு இருந்தார்கள். அவ்விதமாகவே அவர்கள் போகும்போது ஒவ்வொருவரும் தன் வம்சத்துடனும், குடும்பத்துடனும் புறப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","யெகோவா சீனாய் மலையின்மேல் மோசேயுடன் பேசிய காலத்திலிருந்த, ஆரோன் மோசே ஆகியோரின் குடும்ப வம்சவரலாறு: ");
INSERT INTO tamtcv_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","ஆரோனின் மகன்களின் பெயர்களாவன: மூத்த மகனான நாதாப், பின்பு அபியூ, எலெயாசார், இத்தாமார் ஆகியோர். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","இவர்கள் எல்லோரும் ஆசாரியர்களாகப் பணிசெய்வதற்கு நியமிக்கப்பட்டு, அபிஷேகம் பண்ணப்பட்ட ஆரோனின் மகன்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","ஆனால் நாதாபும், அபியூவும் சீனாய் பாலைவனத்தில் யெகோவாவுக்கு முன்பாக அங்கீகரிக்கப்படாத நெருப்பினால், காணிக்கையைச் செலுத்தியபோது, அவருக்கு முன்னால் செத்து விழுந்தார்கள். அவர்களுக்கு மகன்கள் இல்லை. அதனால் எலெயாசாரும், இத்தாமாரும் மட்டுமே தங்கள் தந்தையான ஆரோனின் வாழ்நாட்களில் ஆசாரியர்களாகப் பணிசெய்து வந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","யெகோவா மோசேயிடம் சொன்னதாவது, ");
INSERT INTO tamtcv_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“ஆசாரியன் ஆரோனுக்கு உதவிசெய்யும்படி லேவி கோத்திரத்தாரை அவனுக்கு முன் அழைத்து வா. ");
INSERT INTO tamtcv_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","அவர்கள் சபைக் கூடாரத்தில், இறைசமுகக் கூடாரத்தின் வேலைகளைச் செய்து, அவனுக்காகவும், முழு சமுதாயத்திற்காகவும் கடமைகளைச் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","அவர்கள் சபைக் கூடாரத்தின் பொருட்கள் எல்லாவற்றையும் பராமரித்து, இறைசமுகக் கூடாரத்தின் வேலைகளைச் செய்வதினால் இஸ்ரயேலின் கடமைகளையும் நிறைவேற்றவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","ஆரோனுக்கும், அவன் மகன்களுக்கும் உதவியாக லேவியரைக் கொடுக்கவேண்டும். அவனுக்கு அர்ப்பணமாய்க் கொடுக்கப்படவேண்டிய இஸ்ரயேலர்கள் இவர்களே. ");
INSERT INTO tamtcv_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","ஆரோனையும், அவன் மகன்களையும் குருத்துவப் பணிசெய்யும்படி நியமிக்கவேண்டும். பரிசுத்த இடத்தை நெருங்கும் வேறு எவனும் கொல்லப்படவேண்டும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","மேலும் யெகோவா மோசேயிடம் சொன்னதாவது, ");
INSERT INTO tamtcv_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“ஒவ்வொரு இஸ்ரயேல் பெண்களுக்கும் கர்ப்பந்திறந்து பிறக்கும் மூத்த ஆண்பிள்ளைக்குப் பதிலாக இஸ்ரயேலருக்குள் இருந்து நான் லேவியரைத் தெரிந்துகொண்டேன். இந்த லேவியர் எனக்குரியவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","ஏனெனில் முதற்பேறுகள் எல்லாம் என்னுடையவை. எகிப்தில் எல்லா முதற்பேறுகளையும் அழித்தபோது, நான் இஸ்ரயேலின் முதற்பேறான மனிதர்களையும், மிருகங்களின் தலையீற்றுகளையும் எனக்காகப் பிரித்தெடுத்தேன். அவை என்னுடையதாய் இருக்கவேண்டும். நான் யெகோவா” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","சீனாய் பாலைவனத்தில் யெகோவா மோசேயிடம் சொன்னதாவது, ");
INSERT INTO tamtcv_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“நீ லேவியரைக் குடும்பங்களாகவும், வம்சங்களாகவும் கணக்கிடு. ஒரு மாதமும், அதற்கு மேற்பட்ட வயதையும் உடைய ஒவ்வொரு ஆணையும் கணக்கிடு” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","யெகோவாவின் வார்த்தையினால் கட்டளையிடப்பட்டபடியே மோசே அவர்களைக் கணக்கிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","லேவியின் மகன்களின் பெயர்களாவன: கெர்சோன், கோகாத், மெராரி, ");
INSERT INTO tamtcv_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","கெர்சோன் வம்சத்தைச் சேர்ந்தவர்கள் லிப்னி, சீமேயி என்பவர்கள் ஆவர். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","கோகாத் வம்சத்தைச் சேர்ந்தவர்கள் அம்ராம், இத்சேயார், எப்ரோன், ஊசியேல் என்பவர்கள் ஆவர். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","மெராரி வம்சத்தைச் சேர்ந்தவர்கள் மகேலி, மூஷி என்பவர்கள் ஆவர். தங்களுடைய குடும்பங்களின்படி லேவிய வம்சத்தினர் இவர்களே. ");
INSERT INTO tamtcv_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","லிப்னீ வம்சமும், சீமேயி வம்சமும் கெர்சோனுக்கு உரியவர்கள். இவர்கள் கெர்சோனிய வம்சத்தினர். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","ஒரு மாதமும் அதற்கு மேற்பட்ட வயதையும் உடைய எண்ணப்பட்ட ஆண்களின் தொகை 7,500 பேர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","கெர்சோனிய வம்சங்கள் இறைசமுகக் கூடாரத்திற்குப் பின்னே மேற்குப் பக்கத்தில் முகாமிட வேண்டியதாயிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","லாயேலின் மகன் எலியாசாப் கெர்சோனிய குடும்பங்களின் தலைவனாய் இருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","சபைக் கூடாரத்தில், இறைசமுகக் கூடாரத்திற்கும், அதன் கூடாரத்திற்கும், அதன் மூடு திரைகளுக்கும், சபைக்கூடார வாசல் திரைக்கும் கெர்சோனியரே பொறுப்பாயிருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","முற்றத்தின் திரைகளுக்கும், இறைசமுகக் கூடாரத்தையும், பலிபீடத்தையும் சுற்றியிருந்த முற்றத்தின் வாசல் திரைகளுக்கும், கயிறுகளுக்கும், அதன் பயன்பாட்டோடு சம்பந்தப்பட்ட எல்லாவற்றிற்கும் அவர்களே பொறுப்பாயிருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","அம்ராமிய வம்சமும், இத்சேயார் வம்சமும், எப்ரோனின் வம்சமும், ஊசியேலின் வம்சமும் கோகாத்திற்கு உரியவர்கள். இவர்கள் கோகாத்திய வம்சத்தினர் ஆவர். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","ஒரு மாதமும், அதற்கு மேற்பட்ட வயதையும் உடைய ஆண்களின் தொகை 8,600 பேர்கள். பரிசுத்த இடத்தின் பராமரிப்புக்கு கோகாத்தியர் பொறுப்பாயிருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","இறைசமுகக் கூடாரத்திற்குத் தெற்கு பக்கத்தில், கோகாத்திய வம்சங்கள் முகாமிட வேண்டியதாயிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","ஊசியேலின் மகன் எலிசாபான், கோகாத்திய வம்சங்களின் தலைவனாய் இருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","சாட்சிப்பெட்டி, மேஜை, விளக்குத்தாங்கி, பலிபீடங்கள், குருத்துவப் பணிக்கு பரிசுத்த இடத்தில் பயன்படுத்தும் பொருட்கள், திரை மற்றும் அவற்றின் பயன்பாட்டிற்குச் சம்பந்தப்பட்ட பொருட்கள் எல்லாவற்றிற்கும் அவர்களே பொறுப்பாயிருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","ஆசாரியனான ஆரோனின் மகன் எலெயாசார் லேவியரின் பிரதான தலைவனாக இருந்தான். பரிசுத்த இடத்தின் பராமரிப்புக்குப் பொறுப்பாயிருந்தவர்களுக்கு மேற்பார்வை செய்ய அவன் நியமிக்கப்பட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","மகேலிய வம்சமும், மூசிய வம்சமும் மெராரிக்கு உரியவர்கள். மெராரி வம்சத்தினர் இவர்களே. ");
INSERT INTO tamtcv_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","ஒரு மாதமும் அதற்கு மேற்பட்டதுமான கணக்கிடப்பட்ட எல்லா ஆண்களின் தொகை 6,200 பேர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","அபியாயேலின் மகன் சூரியேல், மெராரி வம்சங்களின் குடும்பங்களுக்குத் தலைவனாயிருந்தான். இறைசமுகக் கூடாரத்தின் வடபகுதியில் அவர்கள் முகாமிட வேண்டியிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","இறைசமுகக் கூடாரத்தின் சட்டப்பலகைகள், குறுக்குச் சட்டங்கள், கம்பங்கள், அடித்தளங்கள், அதற்குரிய எல்லா உபகரணங்களும், அதன் பயன்பாட்டோடு சம்பந்தப்பட்ட எல்லாவற்றின் பராமரிப்புக்காக மெராரியர் நியமிக்கப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","அதேபோல், அதைச் சுற்றியிருந்த முற்றத்தின் கம்பங்கள், அடித்தளங்கள், கூடார முளைகள், கயிறுகள் ஆகியவற்றின் பராமரிப்புக்காகவும் அவர்கள் நியமிக்கப்பட்டிருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","மோசேயும், ஆரோனும், அவன் மகன்களும், கூடாரத்தின் கிழக்கே சபைக் கூடாரத்தின் முன்னே, சூரிய உதயத்தை நோக்கி முகாமிட வேண்டியிருந்தது. இஸ்ரயேலரின் சார்பாகப் பரிசுத்த இடத்தின் பராமரிப்புக்கு அவர்களே பொறுப்பாய் இருந்தார்கள். பரிசுத்த இடத்தை நெருங்கும் வேறு எவனும் கொல்லப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","யெகோவாவின் கட்டளைப்படியே மோசேயும், ஆரோனும் லேவியரைக் கணக்கிட்டார்கள். அவ்வாறு கணக்கிட்ட அவர்களுடைய வம்சங்களின்படி ஒரு மாதமும் அதற்கு மேற்பட்ட வயதையும் உடைய ஒவ்வொரு ஆண்களும் உட்பட மொத்தம் 22,000 பேர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","யெகோவா மோசேயிடம் சொன்னதாவது, “ஒரு மாதமும் அதற்கு மேற்பட்ட வயதையும் உடைய முதற்பேறான இஸ்ரயேலின் ஆண்கள் எல்லோரையும் கணக்கிட்டு, அவர்களின் பெயர்கள் அடங்கிய ஒரு பட்டியலை தயார்செய்ய வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","இஸ்ரயேலரின் முதற்பேறானவர்களுக்குப் பதிலாக லேவியரை எனக்காக எடுத்துக்கொள்ளவேண்டும். இஸ்ரயேலரின் கால்நடைகளின் தலையீற்றுகளுக்குப் பதிலாக லேவியரின் வளர்ப்பு மிருகங்களின் தலையீற்றுகளை எடுத்துக்கொள்ளவேண்டும். நான் யெகோவா” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","யெகோவா தனக்குக் கட்டளையிட்டபடியே மோசே இஸ்ரயேலரின் முதற்பேறுகளைக் கணக்கிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","பெயர் பதிவு செய்யப்பட்ட ஒரு மாதமும், அதற்கு மேற்பட்ட வயதையும் உடைய முதற்பேறான ஆண்களின் மொத்தத்தொகை 22,273 பேர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","மேலும் யெகோவா மோசேயிடம் சொன்னதாவது, ");
INSERT INTO tamtcv_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“இஸ்ரயேலின் முதற்பேறான எல்லா ஆண் பிள்ளைகளுக்குப் பதிலாக லேவியரையும், அவர்களின் மந்தைகளுக்குப் பதிலாக லேவியரின் மந்தைகளையும் பிரித்தெடு. லேவியர் எனக்குரியவர்கள். நான் யெகோவா. ");
INSERT INTO tamtcv_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","ஆனால் லேவியரின் எண்ணிக்கையிலும் அதிகமாயிருக்கிற இஸ்ரயேலரின் முதற்பேறான 273 பேர்களை மீட்பதற்கு, ");
INSERT INTO tamtcv_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","பரிசுத்த இடத்தின் சேக்கல் நிறையின்படி ஒவ்வொருவனுக்கும் ஐந்து சேக்கலை வசூலிக்க வேண்டும். ஒரு சேக்கல் இருபது கேரா. ");
INSERT INTO tamtcv_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","கூடுதலாக இருக்கும் இஸ்ரயேலரின் மீட்புப் பணத்தை ஆரோனுக்கும், அவன் மகன்களுக்கும் கொடுக்கவேண்டும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","எனவே, லேவியரால் மீட்கப்பட்டவர்களின் எண்ணிக்கையைவிட கூடுதலாயிருந்த இஸ்ரயேலரின் முதற்பேறானவர்களிடமிருந்து மீட்புப் பணத்தை மோசே வசூலித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","பரிசுத்த இடத்தின் சேக்கல் நிறையின்படி, 1,365 சேக்கல் எடையுள்ள வெள்ளியை, இஸ்ரயேலரின் முதற்பேறானவர்களிடமிருந்து வசூலித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","மோசே, யெகோவாவின் வார்த்தையால் தனக்குக் கட்டளையிடப்பட்டபடியே, அந்த மீட்புப் பணத்தை ஆரோனுக்கும், அவன் மகன்களுக்கும் கொடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","யெகோவா மோசேயிடமும், ஆரோனிடமும் சொன்னதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“லேவியரில் உள்ள கோகாத்திய வம்சத்தின் கிளையை, அவர்களின் வம்சங்களின்படியும், குடும்பங்களின்படியும் கணக்கிடுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","சபைக் கூடாரத்திலே வேலைசெய்யவரும் முப்பது வயதுதொடங்கி ஐம்பது வயதுவரையுள்ள எல்லா ஆண்களையும் கணக்கிடுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“சபைக் கூடாரத்திலுள்ள மகா பரிசுத்த இடத்தின் பொருட்களைப் பராமரிப்பதே கோகாத்தியர் செய்யவேண்டிய வேலையாகும். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","முகாம் நகர்த்தப்படும்போது, முதலில் ஆரோனும் அவன் மகன்களும் சபைக் கூடாரத்திற்குள் நின்று, மறைக்கும் திரையைக் கழற்றி, அதனால் சாட்சிப்பெட்டியை மூடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","பின்பு அவர்கள் அதைக் கடல்பசுத் தோலினால் மூடி, தனி நீலநிறத் துணியொன்றை அதன்மேல் விரித்து, கம்புகளை அவற்றுக்குரிய இடங்களில் வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“அடுத்ததாக, இறைப்பிரசன்ன மேஜையின்மேல் நீலநிறத் துணியை விரித்து, அதன்மேல் தட்டங்கள், தட்டுகள், கிண்ணங்கள், பானகாணிக்கை ஜாடிகள் ஆகியவற்றை வைக்கவேண்டும். மேஜையின்மேல் தொடர்ந்து வைக்கும் அப்பம் அதிலே இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","அப்பொருட்களின் மேல் சிவப்புநிறத் துணியை விரித்து, அவை எல்லாவற்றையும் கடல்பசுத் தோலினால் மூடி, அதன் கம்புகளை அதற்குரிய இடங்களில் வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“பின்பு ஒரு நீலநிறத் துணியை எடுத்து, வெளிச்சத்திற்குரிய குத்துவிளக்கு, அதனுடன் இருக்கும் அகல்விளக்குகள், விளக்குத்திரி கத்தரிகள், தட்டங்கள், எண்ணெய் விடுவதற்குப் பயன்படுத்தும் ஜாடிகள் ஆகியவற்றை மூடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","அவற்றையும் அவற்றிற்குரிய உபகரணங்கள் அனைத்தையும் ஒன்றுசேர்த்து, அந்த கடல்பசுத் தோலினால் சுற்றிக்கட்டி, சுமக்குந்தடிகளில் அதை வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“அதன்பின் தங்கத்தூபபீடத்தின்மேல் நீலநிறத் துணியை விரித்து, அதனை கடல்பசுத் தோலினால் மூடி, அதன் கம்புகளை அதற்குரிய இடத்தில் வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“அத்துடன் பரிசுத்த இடத்தில் குருத்துவப் பணிக்கு பயன்படுத்தத் தேவையான எல்லா பொருட்களையும், ஒரு நீலநிறத்துணியில் வைத்துச் சுற்றிக்கட்டி, கடல்பசுத் தோலினால் மூடி, சுமக்குந்தடிகளில் அவற்றை வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“அவர்கள் வெண்கலப் பீடத்திலிருந்து சாம்பலை அகற்றி, அதற்குமேல் ஊதாநிறத் துணியை விரிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","பலிபீடத்தில் குருத்துவப் பணிக்காகப் பயன்படுத்தும் எல்லா பாத்திரங்களையும் அதன்மேல் வைக்கவேண்டும். அவையாவன: நெருப்புச் சட்டி, இறைச்சியை குத்தும் முட்கரண்டிகள், சாம்பல் அள்ளும் வாரிகள் மற்றும் தெளிக்கும் கிண்ணங்கள் ஆகும். அவற்றின்மேல் கடல்பசுத் தோலை விரித்து கம்புகளை அவற்றுக்குரிய இடத்தில் வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“ஆரோனும் அவன் மகன்களும் பரிசுத்த பணிமுட்டுகளையும் பரிசுத்த பொருட்கள் எல்லாவற்றையும் மூடவேண்டும். முகாம் நகருவதற்கு ஆயத்தமாகும்போது, கோகாத்தியர் வந்து அதைச் சுமக்கவேண்டும். ஆனால் கோகாத்தியர் அப்பரிசுத்த பொருட்களைத் தொடக்கூடாது. தொட்டால் சாவார்கள். சபைக் கூடாரத்தில் இருக்கும் பொருட்களை கோகாத்தியரே சுமக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“ஆரோனின் மகன் ஆசாரியன் எலெயாசார், வெளிச்சத்திற்கான எண்ணெய், நறுமண தூபம், வழக்கமான தானிய காணிக்கை, அபிஷேக எண்ணெய் ஆகியவற்றிற்குப் பொறுப்பாயிருக்க வேண்டும். அவன் முழு இறைசமுகக் கூடாரத்திற்கும் அதன் பரிசுத்த பணிமுட்டுகள், பொருட்கள் உட்பட அதிலுள்ள எல்லாவற்றிற்கும் பொறுப்பாயிருக்க வேண்டும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","பின்பு யெகோவா மோசேயிடமும், ஆரோனிடமும் சொன்னதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“லேவியரிடமிருந்து கோகாத்திய கோத்திர வம்சங்கள் அழிந்துபோகாதபடி நீங்கள் பார்த்துக்கொள்ளுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","மகா பரிசுத்த பொருட்களை அணுகும்போது, அவர்கள் சாகாமல் வாழும்படி, நீங்கள் செய்யவேண்டியதாவது: ஆரோனும் அவன் மகன்களும் பரிசுத்த இடத்திற்குள் போய், அவனவனுக்குரிய வேலையையும், அவனவன் சுமக்க வேண்டியது என்ன என்பதையும் நியமிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","ஆனால் கோகாத்தியர் பரிசுத்த இடத்துப் பொருட்களைப் பார்க்கும்படி ஒரு வினாடியேனும் உள்ளே போவார்களானால் அவர்கள் சாவார்கள்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","யெகோவா மோசேயிடம் சொன்னதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“கெர்சோனியரை, அவர்கள் குடும்பங்களின்படியும், வம்சங்களின்படியும் கணக்கிடு. ");
INSERT INTO tamtcv_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","சபைக் கூடாரத்தின் வேலைகளைச் செய்யவரும் முப்பது வயதுதொடங்கி ஐம்பது வயதுவரையுள்ள எல்லா ஆண்களையும் கணக்கிடு. ");
INSERT INTO tamtcv_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“கெர்சோனிய வம்சங்கள் வேலைசெய்யும்போதும், சுமை சுமக்கும்போதும் அவர்களுக்குரிய பணி என்னவென்றால்: ");
INSERT INTO tamtcv_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","சபைக் கூடாரமான இறைசமுகக் கூடாரத்தின் திரைகள், கூடாரம், அதன் மூடுதிரை, கடல்பசுத் தோலினால் செய்யப்பட்ட அதன் வெளிப்புற மூடுதிரை, சபைக்கூடார நுழைவாசலுக்கான திரைகள் ஆகியவற்றை அவர்கள் சுமக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","அத்துடன், இறைசமுகக் கூடாரத்தையும், பலிபீடத்தையும் சுற்றியுள்ள முற்றத்தின் திரைகள், முற்றத்தின் வாசல் திரை, அதன் கயிறுகள் மற்றும் அதன் பணியில் பயன்படுத்தும் உபகரணங்கள் எல்லாவற்றையும் அவர்கள் சுமக்கவேண்டும். அவை தொடர்பாகச் செய்யப்படவேண்டிய எல்லாவற்றையும் கெர்சோனியரே செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","தூக்குவதானாலும், வேறு எந்த வேலைசெய்வதானாலும் அவர்களுடைய எல்லா பணிகளும் ஆரோனுடைய அவன் மகன்களுடைய வழிகாட்டலிலேயே செய்யப்படவேண்டும். அவர்கள் சுமக்கவேண்டிய அவர்களுடைய பொறுப்பை நீ அவர்களுக்கு நியமிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","சபைக் கூடாரத்தில் கெர்சோனிய வம்சங்களின் பணி இதுவே. அவர்களுடைய கடமைகள் ஆசாரியனான ஆரோனின் மகன் இத்தாமாரின் வழிநடத்துதலிலேயே செய்யப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“மெராரியரை அவர்களின் வம்சங்களின்படியும், குடும்பங்களின்படியும் கணக்கிடு. ");
INSERT INTO tamtcv_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","சபைக்கூடார வேலைகளைச் செய்யவரும் முப்பது வயதிலிருந்து ஐம்பது வயதுவரையுள்ள எல்லா ஆண்களையும் கணக்கிடு. ");
INSERT INTO tamtcv_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","சபைக் கூடாரத்தில் பணிசெய்யும்போது, அவர்களுடைய கடமை என்னவென்றால், இறைசமுகக் கூடாரத்தின் சட்டப்பலகைகள், அதன் குறுக்குச் சட்டங்கள், அதன் கம்பங்கள், அடித்தளங்கள், ");
INSERT INTO tamtcv_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","சுற்றியுள்ள முற்றத்தின் கம்பங்கள், அடித்தளங்கள், கூடார முளைகள், கயிறுகள், அவற்றின் உபயோகத்திற்கான முழு உபகரணங்கள் ஆகியவற்றைச் சுமப்பதாகும். ஒவ்வொரு மனிதனுக்கும் அவனவன் சுமக்கவேண்டியதை நியமிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","ஆசாரியன் ஆரோனின் மகன் இத்தாமாரின் வழிகாட்டலில், மெராரி வம்சத்தார் சபைக் கூடாரத்தின் வேலையைச் செய்கையில், அவர்களுடைய பணி இதுவே” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","மோசேயும், ஆரோனும், சமுதாயத்தின் தலைவர்களும் கோகாத்தியரை அவர்கள் வம்சங்களின்படியும், குடும்பங்களின்படியும் கணக்கிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","சபைக் கூடாரத்தில் பணிசெய்ய வந்த முப்பது வயதிலிருந்து ஐம்பது வயதுவரையுள்ள ஆண்களையெல்லாம் வம்சம் வம்சமாகக் கணக்கிட்டபோது, ");
INSERT INTO tamtcv_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","அவர்கள் 2,750 பேராய் இருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","சபைக் கூடாரத்தில் பணிசெய்த கோகாத்திய வம்சங்கள் எல்லோருடைய மொத்தத்தொகை இதுவே. யெகோவா மோசே மூலம் கட்டளையிட்டிருந்தபடியே, மோசேயும் ஆரோனும் அவர்களை எண்ணினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","கெர்சோனியர் தங்கள் வம்சங்களின்படியும், குடும்பங்களின்படியும் கணக்கிடப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","சபைக்கூடார வேலைகளைச் செய்யவந்த முப்பது வயதிலிருந்து ஐம்பது வயதுவரையுள்ள எல்லா ஆண்களும் ");
INSERT INTO tamtcv_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","அவர்கள் வம்சங்களின்படியும் குடும்பங்களின்படியும் எண்ணப்பட்டபோது, 2,630 பேராய் இருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","சபைக் கூடாரத்தில் பணிசெய்த கெர்சோன் வம்சத்தைச் சேர்ந்தவர்களின் மொத்தத்தொகை இதுவே. மோசேயும் ஆரோனும் யெகோவாவின் கட்டளைப்படியே, அவர்களை எண்ணினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","மெராரியர் தங்கள் வம்சங்களின்படியும், குடும்பங்களின்படியும் கணக்கிடப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","சபைக்கூடார வேலைகளைச் செய்யவந்த முப்பது வயதிலிருந்து ஐம்பது வயதுவரையுள்ள எல்லா ஆண்களும், ");
INSERT INTO tamtcv_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","அவர்களுடைய வம்சங்களின்படி எண்ணப்பட்டபோது, அவர்கள் 3,200 பேராய் இருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","மெராரிய வம்சங்களைச் சேர்ந்தவர்களின் மொத்தத்தொகை இதுவே. யெகோவா மோசே மூலம் கட்டளையிட்டபடியே மோசேயும், ஆரோனும் அவர்களைக் கணக்கிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","இப்படியாக மோசேயும் ஆரோனும், இஸ்ரயேல் தலைவர்களும் லேவியர்கள் எல்லோரையும் அவர்கள் வம்சங்களின்படியும், குடும்பங்களின்படியும் கணக்கிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","பணிசெய்யும்படி சபைக் கூடாரத்தைச் சுமக்கும் வேலையைச் செய்யவந்த முப்பது வயதிலிருந்து ஐம்பது வயதுவரையுள்ள எல்லா ஆண்களும் எண்ணப்பட்டபோது, ");
INSERT INTO tamtcv_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","அவர்கள் 8,580 பேராய் இருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","மோசேயின் மூலம் யெகோவா கட்டளையிட்டபடியே ஒவ்வொருவனுக்கும் அவனவனுடைய வேலையும், அவனவன் எதைச் சுமப்பது என்பதும் நியமிக்கப்பட்டது. இப்படியாக யெகோவா மோசேக்குக் கட்டளையிட்டபடி அவர்கள் எண்ணப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","மேலும் யெகோவா மோசேயிடம் சொன்னதாவது, ");
INSERT INTO tamtcv_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“நீ இஸ்ரயேலரிடம், முகாமில் தொற்றும் தோல்வியாதி உள்ளவர்களோ, உடலில் கசிவு உள்ளவர்களோ அல்லது பிணத்தைத் தொட்டதினால் சம்பிரதாய முறைப்படி அசுத்தமுள்ளவர்களோ இருந்தால், அவர்களை முகாமுக்கு வெளியே அனுப்பிவிடும்படி கட்டளையிடு. ");
INSERT INTO tamtcv_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","அவர்கள் ஆண்களோ பெண்களோ யாராயிருந்தாலும், அவர்கள் மத்தியில் நான் வாழும் முகாமை அவர்கள் அசுத்தப்படுத்தாதபடி, அவர்களை வெளியே அனுப்பிவிடும்படி கட்டளையிடு” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","இஸ்ரயேலர் அவ்வாறே அவர்களை முகாமைவிட்டு வெளியே அனுப்பினார்கள். யெகோவா மோசேக்கு அறிவுறுத்தியபடியே இஸ்ரயேலர் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","யெகோவா மோசேயிடம் பேசி, ");
INSERT INTO tamtcv_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“நீ இஸ்ரயேலரிடம் சொல்லவேண்டியதாவது: ‘ஒரு ஆணோ, பெண்ணோ வேறொருவனுக்கு எந்த வழியிலாவது குற்றம் செய்து யெகோவாவுக்கு உண்மையற்றவர்களாய் இருந்தால், அந்த நபர் குற்றவாளி. ");
INSERT INTO tamtcv_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","ஆகையால் அவர்கள் தாங்கள் செய்த பாவத்தை அறிக்கையிட வேண்டும். பின்னர், தாங்கள் செய்த குற்றத்திற்காக முழு நஷ்டஈட்டையும், அத்துடன் அதின் ஐந்திலொரு பங்கையும் சேர்த்துத் தன்னால் தீங்கிழைக்கப்பட்ட நபருக்குக் கொடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","ஆனால் தீங்கிழைக்கப்பட்ட நபருக்கு நஷ்டஈடு வழங்கக்கூடிய நெருங்கிய உறவினர்கள் இல்லாமலிருந்தால், செய்த குற்றத்திற்கான அந்த நஷ்டஈடு யெகோவாவுக்கே உரியது. அதை அவன் ஆசாரியனுக்குக் கொடுக்கவேண்டும். அத்துடன் அவனுக்குப் பாவநிவிர்த்தி செய்யப்படுவதற்கான செம்மறியாட்டுக் கடாவையும் கொடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","இஸ்ரயேலர் ஆசாரியனிடம் கொண்டுவரும் பரிசுத்த அன்பளிப்புகள் எல்லாம் அவனுக்கே உரியன. ");
INSERT INTO tamtcv_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","ஒவ்வொருவனுடைய பரிசுத்த கொடைகளும் அவனுக்கே சொந்தம், ஆனால் அவன் ஆசாரியனிடம் கொடுப்பது ஆசாரியனுக்கு உரியதாகும்’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","பின்பு யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“நீ இஸ்ரயேலருடன் பேசிச் சொல்லவேண்டியதாவது: ‘ஒரு மனிதனுடைய மனைவி முறைதவறி அவனுக்கு உண்மையற்றவளாகி, ");
INSERT INTO tamtcv_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","இன்னொருவனுடன் உறவுகொள்ளக்கூடும். இது அவளுடைய கணவனுக்குத் தெரியாமலும், அவளுக்கு விரோதமான சாட்சி இல்லாமலும், அதில் அவள் கையும் மெய்யுமாய் பிடிபடாமலும், அவளுடைய கெட்டநடத்தை கண்டுபிடிக்கப்படாமலும் இருக்கக்கூடும். ");
INSERT INTO tamtcv_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","அப்படியிருக்கும்போது அவளுடைய கணவன் தனது மனைவியின் கெட்ட நடத்தையைப்பற்றிச் சந்தேகங்கொண்டு எரிச்சல் அடையலாம். அல்லது அவள் கெட்டநடத்தை அற்றவளாய் இருக்கும்போதும் அவன் எரிச்சலடைந்து சந்தேகங்கொள்ளக்கூடும். ");
INSERT INTO tamtcv_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","அவ்வாறு நடந்தால், அவன் தன் மனைவியை ஆசாரியனிடம் அழைத்துச்செல்ல வேண்டும். அத்துடன் அவன் பத்தில் ஒரு பங்கு எப்பா அளவான வாற்கோதுமை மாவை அவளுக்கான காணிக்கையாகக் கொண்டுபோக வேண்டும். அதன்மேல் எண்ணெயை ஊற்றவோ, நறுமணத்தூளைப் போடவோ கூடாது. ஏனெனில், அது எரிச்சலுக்கான தானிய காணிக்கை. அது ஒருவனின் குற்றத்தை எடுத்துக்காட்டும் நினைவூட்டும் காணிக்கை. ");
INSERT INTO tamtcv_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘ஆசாரியன் அவளை யெகோவாவுக்குமுன் கொண்டுவந்து நிறுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","பின்பு அவன், பரிசுத்த தண்ணீரை ஒரு மண் பாத்திரத்தினுள் ஊற்றி, இறைசமுகக் கூடாரத்தின் தரையிலிருந்து கொஞ்சம் புழுதியை எடுத்து அதற்குள் போடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","ஆசாரியன் அப்பெண்ணை யெகோவா முன்பாக நிறுத்திய பின், அவளுடைய தலைமயிரை விரித்துவிடவேண்டும். சாபத்தைக் கொண்டுவரும் கசப்புத் தண்ணீரை ஆசாரியன் தன் கையில் வைத்துக்கொண்டிருக்கையில், எரிச்சலுக்கான தானிய காணிக்கையான நினைவூட்டும் காணிக்கையை அவளுடைய கைகளில் வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","பின் ஆசாரியன் அவளைச் சத்தியம் செய்யப்பண்ணி, அவளிடம் சொல்லவேண்டியதாவது: “நீ உன் கணவனுடன் திருமணத்தால் இணைக்கப்பட்டிருக்கையில், வேறு ஒரு மனிதனுடன் உறவுகொள்ளாமலும், முறைதவறி நடந்து உன்னைக் கறைப்படுத்தாமலும் இருந்தால், சாபத்தைக் கொண்டுவரும் இக்கசப்பு தண்ணீர் உனக்குத் தீங்கு செய்யாதிருப்பதாக. ");
INSERT INTO tamtcv_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","ஆனால் நீ உன் கணவனுடன் திருமணத்தால் இணைக்கப்பட்டிருக்கையில், ஒழுங்கீனமாக நடந்து வேறு ஒரு மனிதனுடன் உறவுகொண்டு உன்னை அசுத்தப்படுத்தியிருந்தால்” ");
INSERT INTO tamtcv_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","யெகோவா உன் தொடையை அழுகப்பண்ணி, உன் வயிற்றை வீங்கப்பண்ணுகிறபோது, உன் மக்கள் உன்னைச் சபித்து, பகிரங்கமாக உன்னை நிந்திக்கும்படி செய்வாராக’ என்ற இந்த சாபத்தின் சத்தியத்திற்கு ஆசாரியன் அவளை உட்படுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","இந்த சாபத்தைக் கொண்டுவரும் தண்ணீர் உன் உடலுக்குள் போய் உன் வயிற்றை வீங்கவும், உன் தொடையை அழுகவும் செய்வதாக என்றும் சொல்லவேண்டும்.” “ ‘அப்பொழுது அப்பெண், “ஆமென், அப்படியே ஆகட்டும்” என்று சொல்லவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘பின்பு ஆசாரியன் இந்த சாபங்களை ஒரு புத்தகச்சுருளில் எழுதி, அவற்றை அந்தக் கசப்புத் தண்ணீருக்குள் கழுவிவிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","அதன்பின் சாபத்தைக் கொண்டுவரும் அக்கசப்புத் தண்ணீரை அவள் குடிக்கும்படி செய்யவேண்டும். அத்தண்ணீர் அவளின் உடலுக்குள் போய் கசப்பான வேதனையை உண்டுபண்ணும். ");
INSERT INTO tamtcv_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","ஆசாரியன் அப்பெண்ணின் கையில் இருந்து எரிச்சலுக்கான தானிய காணிக்கையை வாங்கி, அதை யெகோவாவுக்கு முன்பாக அசைவாட்டி, அதைப் பலிபீடத்திற்குக் கொண்டுவர வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","அத்தானிய காணிக்கையில் ஆசாரியன் ஒரு கைப்பிடி எடுத்து, ஞாபகார்த்தக் காணிக்கையாக பலிபீடத்தில் எரிக்கவேண்டும். அதன்பின் அப்பெண் அத்தண்ணீரைக் குடிக்கும்படிச் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","அவள் தன்னை அசுத்தப்படுத்தி, தன் கணவனுக்கு உண்மையற்றவளாய் இருந்தால், சாபத்தைக் கொண்டுவரும் கசப்பான தண்ணீரை அவள் குடிக்கும்போது, அது அவளுக்குள்போய், கசப்பான வேதனையைக் கொண்டுவரும். அப்பொழுது அவள் வயிறு வீங்கி, அவளுடைய தொடையும் அழுகிப்போகும். அவளும் தன் மக்கள் மத்தியில் சபிக்கப்பட்டவளாவாள். ");
INSERT INTO tamtcv_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","ஆனாலும், அவள் கறைப்படாமல் கெட்டநடத்தை அற்றவளாக சுத்தமாக இருந்தால், அவள் அக்குற்றங்களுக்கு நீங்கலாகிப் பிள்ளைகளைப் பெறுவாள். ");
INSERT INTO tamtcv_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ ‘ஒரு பெண் தன் கணவனுடன் திருமணத்தில் இணைக்கப்பட்டிருக்கையில், ஒழுங்கீனமாக நடந்து தன்னைக் கறைப்படுத்தினால், எரிச்சலுக்கான சட்டம் இதுவே. ");
INSERT INTO tamtcv_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","அல்லது ஒருவன் தன் மனைவியின்மேல் சந்தேகப்படுவதால், அவனுக்கு எரிச்சல் உணர்வு வரும்போது, அதற்கான சட்டமும் இதுவே. அவன் அவளை யெகோவாவுக்கு முன்பாக நிறுத்தி, ஆசாரியன் இந்த முழு சட்டத்தின்படியும் அவளுக்குச் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","கணவனோ எந்தக் குற்றத்திற்கும் நீங்கலாயிருப்பான். தன் பாவத்தினால் வந்த விளைவுகளை அப்பெண்ணே அனுபவிக்கவேண்டும்’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","யெகோவா மோசேயுடன் பேசி, ");
INSERT INTO tamtcv_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“நீ இஸ்ரயேலருக்குச் சொல்லவேண்டியதாவது: ஒரு ஆணோ, பெண்ணோ நசரேய விரதத்தின் மூலம் தங்களை யெகோவாவுக்கு வேறுபிரிக்கும் விசேஷ நேர்த்தி செய்யவிரும்பினால், ");
INSERT INTO tamtcv_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","அவர்கள் திராட்சை இரசத்தையோ, மதுபானத்தையோ குடிக்காமல் தவிர்க்கவேண்டும். அத்துடன் திராட்சை இரசத்திலிருந்தோ, வேறு எவ்வகையான மதுபானத்திலிருந்தோ செய்யப்பட்ட புளித்த காடியையும் குடிக்கக்கூடாது. அத்துடன் அவர்கள் திராட்சைப் பழச்சாற்றையும் குடிக்கக்கூடாது. திராட்சைப் பழங்களையோ, திராட்சை வற்றலையோ சாப்பிடவும் கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","அவ்வாறு அவன் நசரேய விரதத்தினால் பிரிந்திருக்கும்வரை திராட்சையிலிருந்து வரும் ஒன்றையும், அதாவது அதன் விதை, தோல் எதையுமே சாப்பிடக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘அவ்வாறு வேறுபிரிந்திருப்பதற்காக நேர்த்திக்கடன் செய்திருக்கும் காலம் முழுவதும் அவனுடைய தலையில் சவரக்கத்தி படக்கூடாது. தன்னை யெகோவாவுக்காக வேறுபிரித்துக்கொண்ட காலம் முடியும்வரை, அவன் பரிசுத்தமாகவே இருக்கவேண்டும். அவன் தன் தலைமயிரையும் நீளமாக வளரவிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“ ‘தன்னை யெகோவாவுக்காக வேறுபிரித்துக்கொண்ட காலத்தில், செத்த உடலின் அருகில் அவன் போகக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","அவன் தன் சொந்தத் தகப்பனோ, தாயோ, சகோதரனோ, சகோதரியோ இறந்தாலும், சம்பிரதாய முறைப்படி அந்த உடலின் அருகில் போய் தன்னை அசுத்தப்படுத்தக் கூடாது. ஏனெனில், அவன் இறைவனுக்காக தன்னை வேறுபிரித்துக்கொண்ட அடையாளச்சின்னம் அவன் தலையின்மேல் இருக்கிறது. ");
INSERT INTO tamtcv_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","அவன் தன்னை வேறுபிரித்திருக்கும் காலம் முழுவதும் அவன் யெகோவாவுக்காக அர்ப்பணம் செய்தவனாயிருக்கிறான். ");
INSERT INTO tamtcv_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘ஆனால் யாராவது ஒருவன் அவன் முன்னிலையில் திடீரென இறந்து, அதனால் அவன் அர்ப்பணம் செய்திருந்த அவனுடைய தலைமயிரை அசுத்தப்படுத்தினால், தன் சுத்திகரிப்பின் நாளான ஏழாம் நாளிலே அவன் தன் தலைமயிரைச் சவரம் செய்துகொள்ள வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","அவன் எட்டாம் நாளில் இரண்டு புறாக்களையாவது, இரண்டு மாடப்புறாக் குஞ்சுகளையாவது சபைக்கூடார வாசலில் ஆசாரியனிடம் கொண்டுவர வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","அவன் செத்த உடலருகில் இருந்ததினால் பாவம் செய்தபடியால், ஆசாரியன் அவற்றில் ஒன்றைப் பாவநிவாரண காணிக்கையாகவும், மற்றொன்றை அவனுக்காகப் பாவநிவிர்த்தி செய்வதற்குத் தகன காணிக்கையாகவும் செலுத்தவேண்டும். அதே நாளிலேயே அவன் தலையையும் பரிசுத்தப்படுத்த வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","அவன் தன்னை வேறுபிரித்துக்கொண்ட காலத்திற்கு என தன்னைத் திரும்பவும் யெகோவாவுக்கு அர்ப்பணம் செய்து, குற்றநிவாரண காணிக்கையாக ஒரு வயதுடைய செம்மறியாட்டுக் கடாக்குட்டியைக் கொண்டுவர வேண்டும். அவன் தன்னை வேறுபிரித்துக்கொண்ட காலத்தில் அசுத்தமடைந்தபடியினால், அதற்கு முந்தின நாட்கள் கணக்கிடப்படுவதில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘தன்னை நசரேய விரதத்தினால் வேறுபிரித்த காலம் முடியும்போது, அவனுக்கான சட்டமாவது: அவனைச் சபைக் கூடாரத்தின் நுழைவாசலுக்குக் கொண்டுவர வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","அங்கே அவன் தன் காணிக்கைகளை யெகோவாவுக்கு ஒப்படைக்கவேண்டும். குறைபாடற்ற ஒரு வயதுடைய செம்மறியாட்டுக் கடாக்குட்டியை தகன காணிக்கையாகவும், குறைபாடற்ற ஒரு வயதுடைய பெண் செம்மறியாட்டுக் குட்டியைப் பாவநிவாரண காணிக்கையாகவும், குறைபாடற்ற ஒரு செம்மறியாட்டுக் கடாவைச் சமாதான காணிக்கையாகவும் செலுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","இன்னும் அவற்றிற்கான தானிய காணிக்கைகளையும், பானகாணிக்கைகளையும், ஒரு கூடை புளிப்பில்லாத அப்பத்தையும் கொண்டுவர வேண்டும். அந்த அப்பங்கள் சிறந்த மாவில் எண்ணெய் கலந்து சுடப்பட்ட அடை அப்பங்களாகவும், எண்ணெய் தடவி சுடப்பட்ட அதிரசங்களாகவும் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘ஆசாரியன் அவற்றை யெகோவாவுக்கு முன்பாகக் கொண்டுவந்து, பாவநிவாரண காணிக்கையாகவும், தகன காணிக்கையாகவும் செலுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","அவன் புளிப்பில்லாத அப்பங்கள் இருக்கும் கூடையைக் கொண்டுவந்து, அந்த செம்மறியாட்டுக் கடாவை தானிய காணிக்கையுடனும், பானகாணிக்கையுடனும், யெகோவாவுக்குச் சமாதான காணிக்கையாகச் செலுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ ‘பின்பு அந்த நசரேய விரதம் செய்து கொண்டவன் தான் அர்ப்பணித்த தலைமயிரை சபைக்கூடார வாசலில் சவரம் செய்யவேண்டும். அவன் அந்த மயிரை எடுத்து, சமாதான காணிக்கை பலியின் கீழே எரியும் நெருப்பில் போடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘நசரேய விரதம் செய்து கொண்டவன் தான் அர்ப்பணித்த தலைமயிரைச் சவரம் செய்தபின், ஆசாரியன் செம்மறியாட்டுக் கடாவின் அவித்த முன்னந்தொடையையும், புளிப்பில்லாமல் செய்யப்பட்டுக் கூடையில் வைக்கப்பட்டிருக்கும் அடை அப்பத்திலிருந்து ஒன்றையும், அதிரசத்திலிருந்து ஒன்றையும் அவனுடைய கைகளில் வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","அவற்றை ஆசாரியன் யெகோவா முன்பாக அசைவாட்டும் காணிக்கையாக அசைவாட்டவேண்டும். அவை பரிசுத்தமானவை. அவை ஆசாரியனுக்கே உரியவை. அத்துடன் அசைவாட்டிய நெஞ்சுப்பகுதியும், செலுத்தப்பட்ட தொடையும் ஆசாரியனுக்கே உரியவை. அதன்பின் நசரேயன் திராட்சை இரசத்தைக் குடிக்கலாம். ");
INSERT INTO tamtcv_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘யெகோவாவுக்காக நசரேய விரதத்தினால் தன்னை வேறுபிரித்துக்கொண்டவனுக்குரிய சட்டம் இதுவே. அவன் தன் வேறுபிரித்தலுக்கேற்ற காணிக்கைகளையும், அத்துடன் தன்னால் கொடுக்க இயன்ற அளவு கொடுப்பவைகளைக் குறித்ததான சட்டம் இதுவே. நசரேய விரதத்திற்கான சட்டப்படி தான் செய்துகொண்ட நேர்த்திக்கடனை அவன் நிறைவேற்றவேண்டும்’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","பின்பு யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“நீ ஆரோனுடனும், அவன் மகன்களுடனும் பேசிச் சொல்லவேண்டியதாவது: ‘நீங்கள் இஸ்ரயேலரை ஆசீர்வதிக்கவேண்டிய விதம் இதுவே, நீங்கள் அவர்களிடம் சொல்லவேண்டியதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘ “யெகோவா உங்களை ஆசீர்வதித்து, உங்களைக் காப்பாராக; ");
INSERT INTO tamtcv_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","யெகோவா உங்கள்மேல் தமது முகத்தைப் பிரகாசிக்கப்பண்ணி, உங்களுடன் கிருபையாய் இருப்பாராக. ");
INSERT INTO tamtcv_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","யெகோவா தமது முகத்தை உங்கள் பக்கமாய் திருப்பி, உங்களுக்குச் சமாதானம் கொடுப்பாராக.” ’ ");
INSERT INTO tamtcv_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“இவ்விதமாக அவர்கள் இஸ்ரயேலர்மேல் என் பெயரை வைப்பார்கள். நானும் அவர்களை ஆசீர்வதிப்பேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","மோசே இறைசமுகக் கூடாரத்தை அமைத்து முடித்தபின், அதையும் அதன் பொருட்களையும், அபிஷேகித்து அர்ப்பணம் செய்தான். அத்துடன் அவன் பலிபீடத்தையும், அதன் பாத்திரங்களையும் அபிஷேகம்பண்ணி அர்ப்பணம் செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","பின்பு இஸ்ரயேலரின் தலைவர்களான, எண்ணப்பட்டவர்களுக்குப் பொறுப்பாயிருந்த கோத்திரங்களின் தலைவர்களான குடும்பத் தலைவர்கள், தங்கள் காணிக்கைகளைச் செலுத்தினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","அவர்கள் ஆறு கூண்டு வண்டிகளையும், பன்னிரண்டு எருதுகளையும் ஒரு தலைவனுக்கு ஒரு எருதும், இரண்டு தலைவனுக்கு ஒரு வண்டியுமாக யெகோவாவுக்கு முன்பாகத் தங்கள் கொடைகளாகக் கொண்டுவந்தார்கள். இவற்றை அவர்கள் இறைசமுகக் கூடாரத்திற்குமுன் வைத்து கொடுத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","அப்பொழுது யெகோவா மோசேயிடம் சொன்னதாவது, ");
INSERT INTO tamtcv_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“சபைக்கூடார வேலைக்கு பயன்படுத்தும்படியாக அவற்றை நீ அவர்களிடமிருந்து ஏற்றுக்கொள்ளவேண்டும். அவற்றை ஒவ்வொருவனுடைய வேலைகளுக்கும் வேண்டியபடி லேவியரிடம் கொடு” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","எனவே மோசே அந்த வண்டிகளையும், எருதுகளையும் லேவியரிடம் கொடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","அவன் இரண்டு வண்டிகளையும், நாலு எருதுகளையும் கெர்சோனியருக்கு அவர்களுடைய வேலைக்குத் தேவையான அளவு கொடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","மெராரியருக்கு அவர்களுடைய வேலைக்குத் தேவையானபடி நாலு வண்டிகளையும் இரண்டு எருதுகளையும் கொடுத்தான். அவர்கள் எல்லோரும் ஆசாரியனாகிய ஆரோனின் மகனாகிய இத்தாமாரின் வழிகாட்டலின் கீழ் இருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","ஆனால் மோசே கோகாத்தியருக்கு வண்டிகளையோ எருதுகளையோ கொடுக்கவில்லை. ஏனெனில், அவர்கள் தாங்கள் பொறுப்பாயிருந்த பரிசுத்த பொருட்களைத் தங்கள் தோள்களிலேயே சுமக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","பலிபீடம் அபிஷேகம் பண்ணப்பட்ட போது, தலைவர்கள் தங்கள் காணிக்கைகளை அதன் அர்ப்பணிப்பிற்காகக் கொண்டுவந்து பலிபீடத்திற்கு முன்னால் வைத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","ஏனெனில், “பலிபீடத்தின் அர்ப்பணிப்பிற்காக ஒரு நாளைக்கு ஒரு தலைவனாக தன் காணிக்கையைக் கொண்டுவர வேண்டும்” என்று யெகோவா மோசேயிடம் சொல்லியிருந்தார். ");
INSERT INTO tamtcv_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","முதலாம் நாள், யூதா கோத்திரத்தைச் சேர்ந்த அம்மினதாபின் மகன் நகசோன் தன் காணிக்கையைக் கொண்டுவந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","அவனுடைய காணிக்கையாக நூற்று முப்பது சேக்கல் எடையுள்ள ஒரு வெள்ளித்தட்டும், எழுபது சேக்கல் எடையுள்ள ஒரு தெளிக்கும் வெள்ளிக்கிண்ணமும் இருந்தன. அவை இரண்டுமே பரிசுத்த இடத்தின் சேக்கல் நிறைப்படி இருந்தன. அவை ஒவ்வொன்றிலும் தானிய காணிக்கைக்காக எண்ணெயுடன் பிசைந்த சிறந்த மாவு நிரப்பப்பட்டு இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","அத்துடன் பத்து சேக்கல் எடையுள்ள ஒரு தங்கக் கிண்ணமும் இருந்தது. அது நறுமணத்தூளினால் நிரப்பப்பட்டிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","அத்துடன் தகன காணிக்கைக்காக ஒரு இளங்காளை, ஒரு செம்மறியாட்டு கடா, ஒரு வயதுடைய செம்மறியாட்டுக் கடாக்குட்டி ஆகியவை இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","பாவநிவாரண காணிக்கைக்காக ஒரு வெள்ளாட்டுக் கடாவும், ");
INSERT INTO tamtcv_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","சமாதான காணிக்கையாகப் பலியிடுவதற்கு இரண்டு எருதுகளும், ஐந்து செம்மறியாட்டுக் கடாக்களும், ஐந்து வெள்ளாட்டுக் கடாக்களும் ஐந்து ஒரு வயதுடைய செம்மறியாட்டுக் கடாக்குட்டிகளும் இருந்தன. அம்மினதாபின் மகன் நகசோனின் காணிக்கை இதுவே. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","இரண்டாம் நாள் இசக்கார் கோத்திரத் தலைவனான சூவாரின் மகன் நெதனெயேல் தன் காணிக்கையைக் கொண்டுவந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","அவனுடைய காணிக்கையாக நூற்று முப்பது சேக்கல் எடையுள்ள ஒரு வெள்ளித்தட்டும், எழுபது சேக்கல் எடையுள்ள ஒரு தெளிக்கும் வெள்ளிக்கிண்ணமும் இருந்தன. அவை இரண்டுமே பரிசுத்த இடத்தின் சேக்கல் நிறைப்படி இருந்தன. அவை ஒவ்வொன்றிலும் தானிய காணிக்கைக்காக எண்ணெயுடன் பிசைந்த சிறந்த மாவு நிரப்பப்பட்டிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","அத்துடன் பத்து சேக்கல் எடையுள்ள ஒரு தங்கக் கிண்ணமும் இருந்தது. அது நறுமணத்தூளினால் நிரப்பப்பட்டிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","அத்துடன் தகன காணிக்கையாக ஒரு இளங்காளை, ஒரு செம்மறியாட்டுக் கடா, ஒரு வயதுடைய செம்மறியாட்டுக் கடாக்குட்டி ஆகியவை இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","பாவநிவாரண காணிக்கைக்காக ஒரு வெள்ளாட்டுக் கடாவும், ");
INSERT INTO tamtcv_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","சமாதான காணிக்கையாகப் பலியிடுவதற்கு இரண்டு எருதுகளும், ஐந்து செம்மறியாட்டுக் கடாக்களும், ஐந்து வெள்ளாட்டுக் கடாக்களும் ஒரு வயதுடைய ஐந்து செம்மறியாட்டுக் கடாக்குட்டிகளும் இருந்தன. சூவாரின் மகன் நெதனெயேலின் காணிக்கை இதுவே. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","மூன்றாம் நாள் செபுலோன் கோத்திர மக்களின் தலைவனான ஏலோனின் மகன் எலியாப் தன் காணிக்கையைக் கொண்டுவந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","அவனுடைய காணிக்கையாக நூற்று முப்பது சேக்கல் எடையுள்ள ஒரு வெள்ளித்தட்டும், எழுபது சேக்கல் எடையுள்ள ஒரு தெளிக்கும் வெள்ளிக்கிண்ணமும் இருந்தன. அவை இரண்டுமே பரிசுத்த இடத்தின் சேக்கல் நிறைப்படி இருந்தன. அவை ஒவ்வொன்றிலும் தானிய காணிக்கைக்காக எண்ணெயுடன் பிசைந்த சிறந்த மாவு நிரப்பப்பட்டு இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","அத்துடன் பத்து சேக்கல் எடையுள்ள ஒரு தங்கக் கிண்ணமும் இருந்தது. அது நறுமணத்தூளினால் நிரப்பப்பட்டிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","அத்துடன் தகன காணிக்கையாக ஒரு இளங்காளை, ஒரு செம்மறியாட்டுக் கடா, ஒரு வயதுடைய செம்மறியாட்டுக் கடாக்குட்டி ஆகியவை இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","பாவநிவாரண காணிக்கைக்காக ஒரு வெள்ளாட்டுக் கடாவும்; ");
INSERT INTO tamtcv_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","சமாதான காணிக்கையாகப் பலியிடுவதற்கு இரண்டு எருதுகளும், ஐந்து செம்மறியாட்டுக் கடாக்களும், ஐந்து வெள்ளாட்டுக் கடாக்களும் ஒரு வயதுடைய ஐந்து செம்மறியாட்டுக் கடாக்குட்டிகளும் இருந்தன. ஏலோனின் மகன் எலியாபின் காணிக்கை இதுவே. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","நான்காம் நாள் ரூபன் கோத்திர மக்களின் தலைவனான சேதேயூரின் மகன் எலிசூர் தன் காணிக்கையைக் கொண்டுவந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","அவனுடைய காணிக்கையாக நூற்று முப்பது சேக்கல் எடையுள்ள ஒரு வெள்ளித்தட்டும், எழுபது சேக்கல் எடையுள்ள ஒரு தெளிக்கும் வெள்ளிக்கிண்ணமும் இருந்தன. அவை இரண்டுமே பரிசுத்த இடத்தின் சேக்கல் நிறைப்படி இருந்தன. அவை ஒவ்வொன்றிலும் தானிய காணிக்கைக்காக எண்ணெயுடன் பிசைந்த சிறந்த மாவு நிரப்பப்பட்டு இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","அத்துடன் பத்து சேக்கல் எடையுள்ள ஒரு தங்கக் கிண்ணமும் இருந்தது. அது நறுமணத்தூளினால் நிரப்பப்பட்டிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","அத்துடன் தகன காணிக்கையாக ஒரு இளங்காளை, ஒரு செம்மறியாட்டுக் கடா, ஒரு வயதுடைய செம்மறியாட்டுக் கடாக்குட்டி ஆகியவை இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","பாவநிவாரண காணிக்கைக்காக ஒரு வெள்ளாட்டுக் கடாவும், ");
INSERT INTO tamtcv_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","சமாதான காணிக்கையாகப் பலியிடுவதற்கு இரண்டு எருதுகளும், ஐந்து செம்மறியாட்டுக் கடாக்களும், ஐந்து வெள்ளாட்டுக் கடாக்களும், ஒரு வயதுடைய ஐந்து செம்மறியாட்டுக் கடாக்குட்டிகளும் இருந்தன. சேதேயூரின் மகன் எலிசூரின் காணிக்கை இதுவே. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","ஐந்தாம் நாள் சிமியோன் கோத்திர மக்களின் தலைவனான சூரிஷதாயின் மகன் செலூமியேல் தன் காணிக்கையைக் கொண்டுவந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","அவனுடைய காணிக்கையாக நூற்று முப்பது சேக்கல் எடையுள்ள ஒரு வெள்ளித்தட்டும், எழுபது சேக்கல் எடையுள்ள ஒரு தெளிக்கும் வெள்ளிக்கிண்ணமும் இருந்தன. அவை இரண்டுமே பரிசுத்த இடத்தின் சேக்கல் நிறைப்படி இருந்தன. அவை ஒவ்வொன்றிலும் தானிய காணிக்கைக்காக எண்ணெயுடன் பிசைந்த சிறந்த மாவு நிரப்பப்பட்டு இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","அத்துடன் பத்து சேக்கல் எடையுள்ள ஒரு தங்கக் கிண்ணமும் இருந்தது. அது நறுமணத்தூளினால் நிரப்பப்பட்டிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","அத்துடன் தகன காணிக்கையாக ஒரு இளங்காளை, ஒரு செம்மறியாட்டுக் கடா, ஒரு வயதுடைய செம்மறியாட்டுக் கடாக்குட்டி ஆகியவை இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","பாவநிவாரண காணிக்கைக்காக ஒரு வெள்ளாட்டுக் கடாவும், ");
INSERT INTO tamtcv_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","சமாதான காணிக்கையாகப் பலியிடுவதற்கு இரண்டு எருதுகளும், ஐந்து செம்மறியாட்டுக் கடாக்களும், ஐந்து வெள்ளாட்டுக் கடாக்களும் ஒரு வயதுடைய ஐந்து செம்மறியாட்டுக் கடாக்குட்டிகளும் இருந்தன. சூரிஷதாயின் மகன் செலூமியேலின் காணிக்கை இதுவே. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ஆறாம் நாள் காத் கோத்திர மக்களின் தலைவனான தேகுயேலின் மகன் எலியாசாப் தன் காணிக்கையைக் கொண்டுவந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","அவனுடைய காணிக்கையாக நூற்று முப்பது சேக்கல் எடையுள்ள ஒரு வெள்ளித்தட்டும், எழுபது சேக்கல் எடையுள்ள ஒரு தெளிக்கும் வெள்ளிக்கிண்ணமும் இருந்தன. அவை இரண்டுமே பரிசுத்த இடத்தின் சேக்கல் நிறைப்படி இருந்தன. அவை ஒவ்வொன்றிலும் தானிய காணிக்கைக்காக எண்ணெயுடன் பிசைந்த சிறந்த மாவு நிரப்பப்பட்டு இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","அத்துடன் பத்து சேக்கல் எடையுள்ள ஒரு தங்கக் கிண்ணமும் இருந்தது. அது நறுமணத்தூளினால் நிரப்பப்பட்டிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","அத்துடன் தகன காணிக்கையாக ஒரு இளங்காளை, ஒரு செம்மறியாட்டுக் கடா, ஒரு வயதுடைய செம்மறியாட்டுக் கடாக்குட்டி ஆகியவை இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","பாவநிவாரண காணிக்கைக்காக ஒரு வெள்ளாட்டுக் கடாவும், ");
INSERT INTO tamtcv_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","சமாதான காணிக்கையாகப் பலியிடுவதற்கு இரண்டு எருதுகளும், ஐந்து செம்மறியாட்டுக் கடாக்களும், ஐந்து வெள்ளாட்டுக் கடாக்களும், ஒரு வயதுடைய ஐந்து செம்மறியாட்டுக் கடாக்குட்டிகளும் இருந்தன. தேகுயேலின் மகன் எலியாசாபின் காணிக்கை இதுவே. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","ஏழாம்நாள் எப்பிராயீம் கோத்திர மக்களின் தலைவனான அம்மியூதின் மகன் எலிஷாமா தன் காணிக்கையைக் கொண்டுவந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","அவனுடைய காணிக்கையாக நூற்று முப்பது சேக்கல் எடையுள்ள ஒரு வெள்ளித்தட்டும், எழுபது சேக்கல் எடையுள்ள ஒரு தெளிக்கும் வெள்ளிக்கிண்ணமும் இருந்தன. அவை இரண்டுமே பரிசுத்த இடத்தின் சேக்கல் நிறைப்படி இருந்தன. அவை ஒவ்வொன்றிலும் தானிய காணிக்கைக்காக எண்ணெயுடன் பிசைந்த சிறந்த மாவு நிரப்பப்பட்டிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","அத்துடன் பத்து சேக்கல் எடையுள்ள ஒரு தங்கக் கிண்ணமும் இருந்தது. அது நறுமணத்தூளினால் நிரப்பப்பட்டிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","அத்துடன் தகன காணிக்கையாக ஒரு இளங்காளை, ஒரு செம்மறியாட்டுக் கடா, ஒரு வயதுடைய செம்மறியாட்டுக் கடாக்குட்டி ஆகியவை இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","பாவநிவாரண காணிக்கைக்காக ஒரு வெள்ளாட்டுக் கடாவும்; ");
INSERT INTO tamtcv_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","சமாதான காணிக்கையாகப் பலியிடுவதற்கு இரண்டு எருதுகளும், ஐந்து செம்மறியாட்டுக் கடாக்களும், ஐந்து வெள்ளாட்டுக் கடாக்களும், ஒரு வயதுடைய ஐந்து செம்மறியாட்டுக் கடாக்குட்டிகளும் இருந்தன. அம்மியூதின் மகன் எலிஷாமாவின் காணிக்கை இதுவே. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","எட்டாம் நாள் மனாசே கோத்திரத் தலைவன் பெதாசூரின் மகன் கமாலியேல் தன் காணிக்கையைக் கொண்டுவந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","அவனுடைய காணிக்கையாக நூற்று முப்பது சேக்கல் எடையுள்ள ஒரு வெள்ளித்தட்டும், எழுபது சேக்கல் எடையுள்ள ஒரு தெளிக்கும் வெள்ளிக்கிண்ணமும் இருந்தன. இவை இரண்டுமே பரிசுத்த இடத்தின் சேக்கல் நிறைப்படி இருந்தன. அவை ஒவ்வொன்றிலும் தானிய காணிக்கைக்காக எண்ணெயுடன் பிசைந்த சிறந்த மாவு நிரப்பப்பட்டிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","அத்துடன் பத்து சேக்கல் எடையுள்ள ஒரு தங்கக் கிண்ணமும் இருந்தது. அது நறுமணத்தூளினால் நிரப்பப்பட்டிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","அத்துடன் தகன காணிக்கையாக ஒரு இளங்காளை, ஒரு செம்மறியாட்டுக் கடா, ஒரு வயதுடைய செம்மறியாட்டுக் கடாக்குட்டி ஆகியவை இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","பாவநிவாரண காணிக்கைக்காக ஒரு வெள்ளாட்டுக் கடாவும்; ");
INSERT INTO tamtcv_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","சமாதான காணிக்கையாகப் பலியிடுவதற்கு இரண்டு எருதுகளும், ஐந்து செம்மறியாட்டுக் கடாக்களும், ஐந்து வெள்ளாட்டுக் கடாக்களும், ஒரு வயதுடைய ஐந்து செம்மறியாட்டுக் கடாக்குட்டிகளும் இருந்தன. பெதாசூரின் மகன் கமாலியேலின் காணிக்கை இதுவே. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","ஒன்பதாம்நாள் பென்யமீன் கோத்திரத் தலைவன் கீதெயோனின் மகன் அபீதான் தன் காணிக்கையைக் கொண்டுவந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","அவனுடைய காணிக்கையாக நூற்று முப்பது சேக்கல் எடையுள்ள ஒரு வெள்ளித்தட்டும், எழுபது சேக்கல் எடையுள்ள ஒரு தெளிக்கும் வெள்ளிக்கிண்ணமும் இருந்தன. அவை இரண்டுமே பரிசுத்த இடத்தின் சேக்கல் நிறைப்படி இருந்தன. அவை ஒவ்வொன்றிலும் தானிய காணிக்கைக்காக எண்ணெயுடன் பிசைந்த சிறந்த மாவு நிரப்பப்பட்டு இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","அத்துடன் பத்து சேக்கல் எடையுள்ள ஒரு தங்கக் கிண்ணமும் இருந்தது. அது நறுமணத்தூளினால் நிரப்பப்பட்டிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","அத்துடன் தகன காணிக்கையாக ஒரு இளங்காளை, ஒரு செம்மறியாட்டுக் கடா, ஒரு வயதுடைய செம்மறியாட்டுக் கடாக்குட்டி ஆகியவை இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","பாவநிவாரண காணிக்கையாக ஒரு வெள்ளாட்டுக் கடாவும், ");
INSERT INTO tamtcv_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","சமாதான காணிக்கையாகப் பலியிடுவதற்கு இரண்டு எருதுகளும், ஐந்து செம்மறியாட்டுக் கடாக்களும், ஐந்து வெள்ளாட்டுக் கடாக்களும், ஒரு வயதுடைய ஐந்து செம்மறியாட்டுக் கடாக்குட்டிகளும் இருந்தன. கீதெயோனின் மகன் அபீதானின் காணிக்கை இதுவே. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","பத்தாம்நாள் தாண் கோத்திர மக்களின் தலைவன் அம்மிஷதாயின் மகன் அகியேசேர் தன் காணிக்கையைக் கொண்டுவந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","அவனுடைய காணிக்கையாக நூற்று முப்பது சேக்கல் எடையுள்ள ஒரு வெள்ளித்தட்டும், எழுபது சேக்கல் எடையுள்ள ஒரு தெளிக்கும் வெள்ளிக்கிண்ணமும் இருந்தன. அவை இரண்டுமே பரிசுத்த இடத்தின் சேக்கல் நிறைப்படி இருந்தன. அவை ஒவ்வொன்றிலும் தானிய காணிக்கைக்காக எண்ணெயுடன் பிசைந்த சிறந்த மாவு நிரப்பப்பட்டு இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","அத்துடன் பத்து சேக்கல் எடையுள்ள ஒரு தங்கக் கிண்ணமும் இருந்தது. அது நறுமணத்தூளினால் நிரப்பப்பட்டிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","அத்துடன் தகன காணிக்கையாக ஒரு இளங்காளை, ஒரு செம்மறியாட்டுக் கடா, ஒரு வயதுடைய செம்மறியாட்டுக் கடாக்குட்டி ஆகியவை இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","பாவநிவாரண காணிக்கையாக ஒரு வெள்ளாட்டுக் கடாவும், ");
INSERT INTO tamtcv_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","சமாதான காணிக்கையாகப் பலியிடுவதற்கு இரண்டு எருதுகளும், ஐந்து செம்மறியாட்டுக் கடாக்களும், ஐந்து வெள்ளாட்டுக் கடாக்களும், ஒரு வயதுடைய ஐந்து செம்மறியாட்டுக் கடாக்குட்டிகளும் இருந்தன. அம்மிஷதாயின் மகன் அகியேசேரின் காணிக்கை இதுவே. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","பதினோராம் நாள் ஆசேர் கோத்திர மக்களின் தலைவன் ஓகிரானின் மகன் பாகியேல் தன் காணிக்கையைக் கொண்டுவந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","அவனுடைய காணிக்கையாக நூற்று முப்பது சேக்கல் எடையுள்ள ஒரு வெள்ளித்தட்டும், எழுபது சேக்கல் எடையுள்ள ஒரு தெளிக்கும் வெள்ளிக்கிண்ணமும் இருந்தன. அவை இரண்டுமே பரிசுத்த இடத்தின் சேக்கல் நிறைப்படி இருந்தன. அவை ஒவ்வொன்றும் தானிய காணிக்கைக்காக எண்ணெயுடன் பிசைந்த சிறந்த மாவு நிரப்பப்பட்டு இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","அத்துடன் பத்து சேக்கல் எடையுள்ள ஒரு தங்கக் கிண்ணமும் இருந்தது. அது நறுமணத்தூளினால் நிரப்பப்பட்டிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","அத்துடன் தகன காணிக்கையாக ஒரு இளங்காளை, ஒரு செம்மறியாட்டுக் கடா, ஒரு வயதுடைய செம்மறியாட்டுக் கடாக்குட்டி ஆகியவை இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","பாவநிவாரண காணிக்கையாக ஒரு வெள்ளாட்டுக் கடாவும், ");
INSERT INTO tamtcv_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","சமாதான காணிக்கையாகப் பலியிடுவதற்கு இரண்டு எருதுகளும், ஐந்து செம்மறியாட்டுக் கடாக்களும், ஐந்து வெள்ளாட்டுக் கடாக்களும், ஒரு வயதுடைய ஐந்து செம்மறியாட்டுக் கடாக்குட்டிகளும் இருந்தன. ஓகிரானின் மகன் பாகியேலின் காணிக்கை இதுவே. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","பன்னிரண்டாம் நாள் நப்தலி கோத்திர மக்களின் தலைவன் ஏனானின் மகன் அகீரா தன் காணிக்கையைக் கொண்டுவந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","அவனுடைய காணிக்கையாக நூற்று முப்பது சேக்கல் எடையுள்ள ஒரு வெள்ளித்தட்டும், எழுபது சேக்கல் எடையுள்ள தெளிக்கும் வெள்ளிக்கிண்ணமும் இருந்தன. அவை இரண்டுமே பரிசுத்த இடத்தின் சேக்கல் நிறைப்படி இருந்தன. அவை ஒவ்வொன்றிலும் தானிய காணிக்கைக்காக எண்ணெயுடன் பிசைந்த சிறந்த மாவு நிரப்பப்பட்டு இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","அத்துடன் பத்து சேக்கல் எடையுள்ள ஒரு தங்கக் கிண்ணமும் இருந்தது. அது நறுமணத்தூளினால் நிரப்பப்பட்டிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","அத்துடன் தகன காணிக்கையாக ஒரு இளங்காளை, ஒரு செம்மறியாட்டுக் கடா, ஒரு வயதுடைய செம்மறியாட்டுக் கடாக்குட்டி ஆகியவை இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","பாவநிவாரண காணிக்கையாக ஒரு வெள்ளாட்டுக் கடாவும்; ");
INSERT INTO tamtcv_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","சமாதான காணிக்கையாகப் பலியிடுவதற்கு இரண்டு எருதுகளும், ஐந்து செம்மறியாட்டுக் கடாக்களும், ஐந்து வெள்ளாட்டுக் கடாக்களும், ஒரு வயதுடைய ஐந்து செம்மறியாட்டுக் கடாக்குட்டிகளும் இருந்தன. ஏனானின் மகன் அகீராவின் காணிக்கை இதுவே. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","பலிபீடம் அபிஷேகம் பண்ணப்பட்ட போது, அதன் அர்ப்பணிப்பிற்காகக் கொடுக்கப்பட்ட இஸ்ரயேல் தலைவர்களின் காணிக்கைகளாவன: பன்னிரண்டு வெள்ளி தட்டங்கள், பன்னிரண்டு தெளிக்கும் வெள்ளிக் கிண்ணங்கள், பன்னிரண்டு தங்கத் தட்டுகள். ");
INSERT INTO tamtcv_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ஒவ்வொரு வெள்ளித்தட்டங்களும் நூற்று முப்பது சேக்கல் எடையுள்ளதாயும், ஒவ்வொரு தெளிக்கும் கிண்ணமும் எழுபது சேக்கல் எடையுள்ளதாயும் இருந்தன. எல்லா வெள்ளித்தட்டுகளும் பரிசுத்த இடத்தின் சேக்கல் நிறையின்படி இரண்டாயிரத்து நானூறு சேக்கல் எடையுள்ளதாயிருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","நறுமணத்தூளினால் நிரப்பப்பட்ட பன்னிரண்டு தங்கத் தட்டுகளும், பரிசுத்த இடத்தின் சேக்கல் நிறையின்படி பத்து சேக்கல் நிறையுடையதாய் இருந்தன. தங்கத் தட்டுகள் எல்லாம் நூற்றியிருபது சேக்கல் நிறையுடையதாய் இருந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","தகன காணிக்கைக்கான மிருகங்களின் மொத்த எண்ணிக்கை பன்னிரண்டு இளம் காளைகளும், பன்னிரண்டு செம்மறியாட்டுக் கடாக்களும், ஒரு வயதுடைய பன்னிரண்டு செம்மறியாட்டுக் கடாக்குட்டிகளுமாய் இருந்தன. அதோடு அவற்றுடன் தானிய காணிக்கையும் இருந்தது. பாவநிவாரண காணிக்கையாக பன்னிரண்டு வெள்ளாட்டுக் கடாக்கள் செலுத்தப்பட்டன. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","சமாதான காணிக்கையாகப் பலி செலுத்துவதற்கான மிருகங்களின் மொத்த எண்ணிக்கை இருபத்து நான்கு எருதுகள், அறுபது செம்மறியாட்டுக் கடாக்கள், அறுபது வெள்ளாட்டுக் கடாக்கள், ஒரு வயதுடைய அறுபது செம்மறியாட்டு கடாக்குட்டிகளுமாய் இருந்தன. பலிபீடம் அபிஷேகம் பண்ணப்பட்டபின் அதன் அர்ப்பணிப்பிற்கான காணிக்கைகள் இவையே. ");
INSERT INTO tamtcv_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","மோசே யெகோவாவுடன் பேசுவதற்காகச் சபைக் கூடாரத்திற்குள் சென்றபோது, சாட்சிப்பெட்டியின் மேலுள்ள கிருபாசனத்திற்கு மேலாக இருக்கும், இரண்டு கேருபீன்களுக்கும் இடையில் இருந்து தன்னோடு பேசுகிற குரலைக் கேட்டான். இவ்விதமாக யெகோவா மோசேயோடு பேசினார். ");
INSERT INTO tamtcv_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“நீ ஆரோனிடம் பேசிச் சொல்லவேண்டியதாவது: ‘நீ அந்த ஏழு விளக்குகளையும் வைக்கும்போது, அவை விளக்குத்தண்டிற்கு முன்னுள்ள பகுதிக்கு வெளிச்சம் கொடுக்கவேண்டும்’ என்று சொல்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","ஆரோனும் அப்படியே செய்தான். யெகோவா மோசேக்குக் கட்டளையிட்டபடியே ஆரோன் விளக்குத்தாங்கியின் விளக்குகளின் முன்பக்கம் பார்க்கும்படி அவற்றை வைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","அந்த குத்துவிளக்கு செய்யப்பட்டிருந்த விதமாவது: அதன் அடிப்பாகத்திலிருந்து நுனியிலுள்ள பூக்கள்வரை அது அடிக்கப்பட்ட தங்கத்தால் செய்யப்பட்டிருந்தது. யெகோவா மோசேக்குக் காட்டிய குத்துவிளக்கின் வடிவத்தைப் போலவே அது செய்யப்பட்டிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","திரும்பவும் யெகோவா மோசேயிடம் சொன்னதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“நீ மற்ற இஸ்ரயேலருக்குள்ளிருந்து லேவியரைப் பிரித்தெடுத்து, சம்பிரதாய முறைப்படி அவர்களைத் தூய்மைப்படுத்து. ");
INSERT INTO tamtcv_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","அவர்களைச் சுத்திகரிக்கும்படி செய்யவேண்டியதாவது, நீ சுத்திகரிக்கும் தண்ணீரை அவர்கள்மேல் தெளிக்கவேண்டும். பின் அவர்கள் தங்கள் உடல் முழுவதையும் சவரம்செய்து தங்களது உடைகளைக் கழுவும்படி செய்யவேண்டும். இவ்வாறு அவர்கள் தங்களைச் சுத்தப்படுத்தட்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","ஒரு இளங்காளையையும், அதனுடன் அதற்கான தானிய காணிக்கையாக எண்ணெய் கலந்து பிசைந்த சிறந்த மாவையும் அவர்களை எடுக்கும்படி செய்யவேண்டும். அதன்பின் நீயும், பாவநிவாரண காணிக்கையாக இரண்டாவது காளையை எடுத்துக்கொள்ளவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","நீ லேவியரை சபைக் கூடாரத்திற்குமுன் அழைத்துவந்து, முழு இஸ்ரயேல் சமுதாயத்தையும் அங்கே கூடிவரச்செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","நீ லேவியரை யெகோவாவுக்கு முன்பாகக் கொண்டுவர வேண்டும். இஸ்ரயேலர் தங்கள் கைகளை அவர்கள்மேல் வைக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","ஆரோன், லேவியரை இஸ்ரயேலரின் அசைவாட்டும் காணிக்கையாக யெகோவாவுக்கு முன்பாகக் கொண்டுவர வேண்டும். அப்பொழுது அவர்கள் யெகோவாவின் வேலையைச் செய்வதற்கு ஆயத்த மாவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“லேவியர் அக்காளைகளின் தலையில் தங்கள் கைகளை வைக்கவேண்டும். அதன்பின் ஒரு காளையைப் பாவநிவாரண காணிக்கையாக யெகோவாவுக்குச் செலுத்தி, இன்னொன்றை லேவியருக்கான பாவநிவிர்த்தி செய்யும்படி, தகன காணிக்கையாகச் செலுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","ஆரோனுக்கும், அவன் மகன்களுக்கும் முன்பாக லேவியரை நிறுத்தி, யெகோவாவுக்கு அவர்களை அசைவாட்டும் காணிக்கையாக ஒப்புக்கொடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","இவ்விதம் நீ லேவியரை இஸ்ரயேலருக்குள் இருந்து வேறுபிரிக்க வேண்டும். லேவியர் எனக்குரியவர்களாக இருப்பார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“நீ லேவியரைச் சுத்திகரித்து, அவர்களை அசைவாட்டும் காணிக்கையாக ஒப்புக்கொடுத்தபின், அவர்கள் சபைக் கூடாரத்தில் தங்கள் வேலையைச் செய்வதற்கு வரவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","முழுவதுமாக எனக்காகக் கொடுக்கப்படவேண்டிய இஸ்ரயேலர் அவர்களே. ஒவ்வொரு இஸ்ரயேல் பெண்ணும் பெற்றெடுக்கும் முதற்பேறான ஆண் பிள்ளைகளுக்குப் பதிலாக நான் லேவியர்களை எனக்குச் சொந்தமாக எடுத்துக்கொண்டேன். ");
INSERT INTO tamtcv_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","இஸ்ரயேலின் முதற்பேறான ஒவ்வொரு ஆணும் எனக்குரியவன். மனிதனின் முதற்பேறும், மிருகத்தின் தலையீற்றும் எனக்குரியவை. எகிப்தில் முதற்பேறானவற்றையெல்லாம் நான் அழித்தபோது, அவர்களை எனக்காக நான் வேறுபிரித்தேன். ");
INSERT INTO tamtcv_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","எனவே நான் இஸ்ரயேலரின் முதற்பேறான எல்லா ஆண்களுக்கும் பதிலாக இப்பொழுது லேவியரை தெரிந்துகொண்டேன். ");
INSERT INTO tamtcv_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","இஸ்ரயேலர் எல்லோருக்குள்ளும் இருந்து நான் லேவியரை பிரித்தெடுத்து, அவர்களை ஆரோனுக்கும், அவனுடைய மகன்களுக்கும் கொடைகளாகக் கொடுத்திருக்கிறேன். லேவியர் இஸ்ரயேலரின் சார்பாக சபைக் கூடாரத்தில் வேலை செய்வதற்காகவும், இஸ்ரயேலர் பரிசுத்த இடத்திற்கு அருகே போகும்போது, அவர்கள் கொள்ளைநோயினால் வாதிக்கப்படாதபடி, அவர்களுக்காகப் பாவநிவிர்த்தி செய்வதற்காகவுமே கொடுத்திருக்கிறேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","யெகோவா மோசேக்குக் கட்டளையிட்டபடியே மோசேயும், ஆரோனும், முழு இஸ்ரயேலின் சமுதாயமும் லேவியருக்கு எல்லாவற்றையும் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","லேவியரும் தங்களைச் சுத்திகரித்துத் தங்கள் உடைகளைக் கழுவினார்கள். அதன்பின் ஆரோன் அவர்களை அசைவாட்டும் காணிக்கையாக யெகோவாவுக்கு முன்பாக நிறுத்தி, அவர்களைச் சுத்திகரிக்கும்படி அவர்களுக்காகப் பாவநிவிர்த்தி செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","அதன்பின் லேவியர் ஆரோனுடைய, அவன் மகன்களுடைய மேற்பார்வையின்கீழ், சபைக் கூடாரத்தில் தங்கள் வேலையை நிறைவேற்றுவதற்காக வந்தார்கள். யெகோவா மோசேக்குக் கட்டளையிட்டபடியே அவர்கள் லேவியருக்குச் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","யெகோவா மோசேயிடம் சொன்னதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“இது லேவியர்களுக்குரிய விதிமுறையாகும்: இருபத்தைந்து வயது உடையவர்களும் அதற்கு மேற்பட்டவர்களுமான ஆண்கள், சபைக்கூடார வேலையில் பங்கெடுக்க வரவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ஆனால் ஐம்பது வயதில் அவர்கள் தங்கள் வழக்கமான பணியிலிருந்து ஓய்வு பெறவேண்டும். அதற்குமேல் வேலைசெய்யக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","எனினும் அவர்கள் சபைக் கூடாரத்தில் கடமை செய்வதில் தங்கள் சகோதரர்களுக்கு உதவிசெய்யலாம். ஆனால் அவர்கள் தாங்களாகவே அந்த வேலையைச் செய்யக்கூடாது. இவ்விதமாகவே லேவியர்களின் பொறுப்பை நீ அவர்களுக்கு நியமித்துக் கொடுக்கவேண்டும்.” ");
INSERT INTO tamtcv_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","இஸ்ரயேலர் எகிப்திலிருந்து புறப்பட்ட இரண்டாம் வருடம் முதலாம் மாதத்தில், யெகோவா சீனாய் பாலைவனத்தில் மோசேயுடன் பேசினார். அவர் அவனிடம், ");
INSERT INTO tamtcv_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“இஸ்ரயேலர் நியமிக்கப்பட்ட காலத்தில் பஸ்கா பண்டிகையைக் கொண்டாடும்படி செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","நியமிக்கப்பட்ட காலமான இம்மாதம் பதினாலாம்தேதி பொழுதுபடும் நேரத்தில், அப்பண்டிகைக்குரிய எல்லா சட்டங்களின்படியும், ஒழுங்கு முறைப்படியும் அதைக் கொண்டாடுங்கள் என்று சொல்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","அப்படியே மோசே, பஸ்கா பண்டிகையைக் கொண்டாடும்படி இஸ்ரயேலரிடம் சொன்னான். ");
INSERT INTO tamtcv_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","அவ்வாறே அவர்கள், முதலாம் மாதம் பதினாலாம்தேதி பொழுதுபடும் நேரத்தில், சீனாய் பாலைவனத்தில் பஸ்காவைக் கொண்டாடினார்கள். யெகோவா மோசேக்குக் கட்டளையிட்ட எல்லாவற்றையும் இஸ்ரயேலர் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","ஆனால் அந்த நாளில் சிலர் பிரேதத்தைத் தொட்டதினால், சம்பிரதாய முறைப்படி அசுத்தமாக இருந்தார்கள். எனவே அவர்களால் அந்த நாளில் பஸ்காவைக் கொண்டாட முடியவில்லை. அவர்கள் அன்றைய தினமே மோசேயிடமும், ஆரோனிடமும் வந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","அவர்கள் மோசேயிடம், “ஒரு பிரேதத்தைத் தொட்டதினால் நாங்கள் அசுத்தமாகிவிட்டோம். மற்ற இஸ்ரயேலரோடு குறிப்பிட்ட காலத்தில் யெகோவாவுக்குக் காணிக்கையைக் கொடுப்பதிலிருந்து நாங்கள் விலக்கி வைக்கப்பட்டிருப்பதால் என்ன செய்யவேண்டும்?” எனக் கேட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","அதற்கு மோசே, “உங்களைப்பற்றி யெகோவா என்ன கட்டளை கொடுக்கிறார் என நான் அவரிடமிருந்து அறிந்து வரும்வரை பொறுத்திருங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","அப்பொழுது யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“நீ இஸ்ரயேலரிடம் சொல்லவேண்டியதாவது: ‘உங்களிலோ அல்லது உங்கள் சந்ததியிலோ, யாராவது பிரேதத்தைத் தொட்டு அசுத்தமாயிருந்தாலும் அல்லது பயணம் போயிருந்தாலும், அவர்கள் யெகோவாவின் பஸ்காவைக் கொண்டாடலாம். ");
INSERT INTO tamtcv_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","அவர்கள் இரண்டாம் மாதம் பதினாலாம்தேதி பொழுதுபடும் வேளையிலேயே, பஸ்காவைக் கொண்டாடவேண்டும். அவர்கள் புளிப்பில்லாத அப்பத்துடனும், கசப்புள்ள கீரையுடனும் பஸ்கா செம்மறியாட்டுக் குட்டியைச் சாப்பிடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","காலைவரை அதில் எதையும் மீதியாக வைக்கக்கூடாது; அதன் எலும்புகளை முறிக்கவும் கூடாது. அவர்களும் பஸ்காவைக் கொண்டாடும்போது, இந்த எல்லா விதிமுறைகளையும் கைக்கொள்ளவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","ஆனால் ஒரு மனிதன் சம்பிரதாய முறைப்படி சுத்தமாகவும், பயணம் போகாமலும் இருந்து, பஸ்காவைக் கொண்டாடத் தவறினால், அம்மனிதன் தன் மக்கள் மத்தியில் இருந்து அகற்றப்படவேண்டும். ஏனெனில், அவன் நியமிக்கப்பட்ட காலத்தில் யெகோவாவுக்குக் காணிக்கையைக் கொண்டுவரவில்லை. எனவே அவன் தன் பாவத்தினால் வந்த விளைவைத் தானே சுமக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘அத்துடன் உங்கள் மத்தியில் வாழும் அந்நியன் ஒருவன், யெகோவாவின் பஸ்காவைக் கொண்டாட விரும்பினால், அவன் சட்டங்களின்படியும், விதிமுறைகளின்படியும் அதைக் கொண்டாடவேண்டும். தன் நாட்டினனுக்கும், பிறநாட்டினனுக்கும் ஒரேவிதமான விதிமுறைகளையே நீங்கள் வைத்திருக்கவேண்டும்’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","சாட்சிபகரும் கூடாரமான இறைசமுகக் கூடாரம் அமைக்கப்பட்ட நாளிலே மேகம் அதை மூடியது. மாலையிலிருந்து காலைவரை இரவு முழுவதும் அம்மேகம் இறைசமுகக் கூடாரத்திற்கு மேலாக நெருப்பைப்போல் காணப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","அப்படியே அது தொடர்ந்து இருந்ததால் மேகத்தால் மூடப்பட்டு இரவில் நெருப்பைப்போல் காணப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","அந்த மேகம் கூடாரத்தின் மேலிருந்து எழும்பும் போதெல்லாம், இஸ்ரயேலர் புறப்பட்டார்கள். மேகம் எங்கெல்லாம் நின்றதோ, அங்கெல்லாம் இஸ்ரயேலர் முகாமிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","இவ்வாறு இஸ்ரயேலர் யெகோவாவின் கட்டளையின்படியே புறப்பட்டு, அவருடைய கட்டளையின்படியே முகாமை அமைத்தார்கள். மேகம் இறைசமுகக் கூடாரத்தின் மேலாக இருக்கும்வரை அவர்களும் முகாமில் தங்கியிருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","மேகம் இறைசமுகக் கூடாரத்தின்மேல் நீண்டகாலம் தங்கியிருந்தால், இஸ்ரயேலர் யெகோவாவினுடைய உத்தரவுக்காகக் கீழ்ப்படிந்து புறப்படாதிருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","ஆனால் சிலவேளைகளில் அந்த மேகம் இறைசமுகக் கூடாரத்தின் மேலாக ஒருசில நாட்கள் மட்டுமே இருந்தது. யெகோவாவின் கட்டளைப்படியே அவர்கள் முகாமிட்டு, பின்பு அவருடைய கட்டளைப்படியே புறப்படுவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","சிலவேளைகளில் அந்த மேகம் மாலையிலிருந்து காலைவரை மட்டுமே தங்கியிருந்தது. அது காலையில் மேலே எழுந்தபோது, அவர்கள் புறப்பட்டார்கள். பகலானாலும், இரவானாலும் அந்த மேகம் மேலெழுந்தபோதெல்லாம் அவர்கள் புறப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","அந்த மேகம் இரண்டு நாட்களுக்கோ, ஒரு மாதத்திற்கோ அல்லது ஒரு வருடத்திற்கோ இறைசமுகக் கூடாரத்திற்கு மேலாகத் தங்கியிருந்தால், இஸ்ரயேலரும் முகாமில் தங்கியிருப்பார்கள்; புறப்படாதிருப்பார்கள். ஆனால் அது மேலே எழும்பும்போதோ அவர்கள் புறப்படுவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","யெகோவாவின் கட்டளைப்படியே அவர்கள் முகாமிட்டார்கள், யெகோவாவின் கட்டளைப்படியே அவர்கள் புறப்பட்டார்கள். யெகோவா மோசேயின் வழியாகக் கொடுத்த கட்டளைப்படியே அவர்கள் அவருடைய உத்தரவுக்குக் கீழ்ப்படிந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","யெகோவா மோசேயிடம் சொன்னதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“வெள்ளியை அடித்து இரண்டு எக்காளங்களைச் செய்யவேண்டும். மக்களை ஒன்றுகூட்டி அழைப்பதற்கும், முகாமில் உள்ளவர்களை புறப்படச்செய்வதற்கும் அவற்றைச் செய்யப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","அந்த இரண்டு எக்காளங்களும் ஊதப்படுகின்றபோது, எல்லா மக்களும் சபைக்கூடார வாசலில் உனக்கு முன்பாகக் கூடிவரவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","ஆனால் ஒரு எக்காளம் மட்டும் ஊதப்படும்போது தலைவர்கள், இஸ்ரயேல் வம்சத்தலைவர்கள் மாத்திரமே உனக்கு முன்பாகக் கூடிவரவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","எக்காளத்தின் சத்தம் பெரிதாய் தொனிக்கும்போது, கிழக்குப் பக்கத்தில் முகாமிட்டிருக்கும் கோத்திரங்கள் புறப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","இரண்டாந்தரமும் எக்காள சத்தம் பெரிதாய் தொனிக்கும்போது, தெற்கே முகாமிட்டிருக்கிறவர்கள் புறப்படவேண்டும். எக்காளத்தின் பெருந்தொனி புறப்படுவதற்கு அடையாளமாயிருக்க வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","மக்களை ஒன்று கூட்டுவதற்காக எக்காளம் ஊதவேண்டும். ஊதப்படும் தொனி வித்தியாசமாயிருக்க வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“ஆசாரியர்களான ஆரோனின் மகன்களே எக்காளங்களை ஊதவேண்டும். இது உனக்கும், உன் சந்ததிக்கும் தலைமுறைதோறும் ஒரு நித்திய நியமமாய் இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","உங்களை ஒடுக்குகிற உங்கள் பகைவர்களுக்கு எதிராக உங்கள் சொந்த நாட்டிலே நீங்கள் போருக்குச் செல்லும்போது, நீ எக்காளங்களினால் பெருந்தொனியை எழுப்பவேண்டும். அப்பொழுது நீங்கள் உங்கள் இறைவனாகிய யெகோவாவினால் நினைவுகூரப்பட்டு, உங்கள் பகைவர்களிடமிருந்து தப்புவிக்கப்படுவீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","அத்துடன் உங்களுக்கு நியமிக்கப்பட்ட பண்டிகைகளையும், அமாவாசைப் பண்டிகைகளையும் கொண்டாடி மகிழும் காலங்களில், உங்கள் தகன காணிக்கைகளுக்கும், சமாதான காணிக்கைகளுக்கும் மேலாக எக்காளங்களை ஊதவேண்டும். அவை உங்கள் இறைவனுக்கு முன்பாக உங்களை ஞாபகப்படுத்தும் அடையாளமாயிருக்கும். நான் உங்கள் இறைவனாகிய யெகோவா” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","இஸ்ரயேலர் எகிப்திலிருந்து வெளியேறிய பிறகு இரண்டாம் வருடம், இரண்டாம் மாதம், இருபதாம் நாளில் சாட்சியின் கூடாரத்தின் மேலாக இருந்த மேகம் மேலெழுந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","அப்பொழுது இஸ்ரயேலர் சீனாய் பாலைவனத்தை விட்டுப் புறப்பட்டு, ஒரு இடத்திலிருந்து இன்னோர் இடத்திற்குப் பயணம்பண்ணி, அந்த மேகம் பாரான் பாலைவனத்தில் தங்கும்வரை போய்க்கொண்டிருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","யெகோவா மோசேயின் மூலம் கொடுத்த கட்டளையின்படியே, இவ்விதம் முதல்முறையாக அவர்கள் புறப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","முதலாவதாக, யூதாவின் முகாம் பிரிவுகள் தங்கள் கொடியின்கீழ் சென்றன. அம்மினதாபின் மகன் நகசோன் அவர்களுக்குத் தலைமை தாங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","சூவாரின் மகன் நெதனெயேல் இசக்கார் கோத்திரப் பிரிவுக்குத் தலைமை தாங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ஏலோனின் மகன் எலியாப், செபுலோன் கோத்திரப் பிரிவுக்குத் தலைமை தாங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","அப்பொழுது இறைசமுக கூடாரமும் கழற்றப்பட்டது. கெர்சோனியரும், மெராரியரும் அதைச் சுமந்துகொண்டு புறப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","அடுத்ததாக, ரூபனின் முகாம் பிரிவுகள் தங்கள் கொடியின்கீழ் புறப்பட்டன. சேதேயூரின் மகன் எலிசூர் அவர்களுக்குத் தலைமை வகித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","சூரிஷதாயின் மகன் செலூமியேல் சிமியோன் கோத்திரப் பிரிவுக்குத் தலைமை தாங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","தேகுயேலின் மகன் எலியாசாப், காத் கோத்திரப் பிரிவுக்குத் தலைமை தாங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","அதன்பின் கோகாத்தியர் பரிசுத்த பொருட்களைச் சுமந்துகொண்டு புறப்பட்டார்கள். அவர்கள் போய்ச்சேருமுன் இறைசமுகக் கூடாரம் அமைக்கப்பட வேண்டியிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","அடுத்ததாக, எப்பிராயீமின் முகாம் பிரிவுகள் தங்கள் கொடியின்கீழ் புறப்பட்டன. அவர்களுக்கு அம்மியூதின் மகன் எலிஷாமா தலைமை தாங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","பெதாசூரின் மகன் கமாலியேல், மனாசே கோத்திரப் பிரிவுக்குத் தலைமை தாங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","கீதெயோனின் மகன் அபீதான், பென்யமீன் கோத்திரப் பிரிவுக்குத் தலைமை தாங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","கடைசியாக, தாணின் முகாம் பிரிவுகள் எல்லாப் பிரிவுகளுக்கும் பின்னணிக் காவலாக, தங்கள் கொடியின்கீழ் புறப்பட்டன. அம்மிஷதாயின் மகன் அகியேசேர் அவர்களுக்குத் தலைமை தாங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","ஓகிரானின் மகன் பாகியேல், ஆசேர் கோத்திரப் பிரிவுக்குத் தலைமை தாங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ஏனானின் மகன் அகீரா, நப்தலி கோத்திரப் பிரிவுக்குத் தலைமை தாங்கினான். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","இஸ்ரயேலரின் பிரிவுகள் புறப்பட்டபோது, இவ்விதமாய் அவர்களின் அணிவகுப்பு ஒழுங்காய் அமைந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","அதன்பின் மோசே மீதியானியனான தன் மாமன் ரெகுயேலின் மகன் ஒபாவிடம், “இப்பொழுது நாங்கள் யெகோவா எங்களுக்குத் தருவேன் என வாக்குக்கொடுத்த இடத்திற்குப் போகிறோம். நீயும் எங்களுடன் வா. நாங்கள் உன்னை நன்றாக நடத்துவோம். ஏனெனில், யெகோவா இஸ்ரயேலருக்கு நன்மைகளைத் தருவதாக வாக்குத்தத்தம் செய்திருக்கிறார்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","ஆனால் ஒபாவோ, “நான் உங்களுடன் வரமாட்டேன்; நான் என் சொந்த நாட்டிற்கும், என் சொந்த மக்களிடத்திற்கும் போகப்போகிறேன்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","அதற்கு மோசே, “தயவுசெய்து நீ எங்களைவிட்டுப் போகவேண்டாம். நாங்கள் பாலைவனத்தில் எங்கே முகாமிடவேண்டும் என்பது உனக்குத் தெரியும். நீ எங்கள் வழிகாட்டியாயிரு. ");
INSERT INTO tamtcv_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","நீ எங்களுடன் வந்தால், யெகோவா எங்களுக்குத் தரப்போகிற எல்லா நன்மைகளையும் நாங்கள் உன்னோடு பகிர்ந்துகொள்வோம்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","அப்படியே அவர்கள் யெகோவாவினுடைய மலையை விட்டுப் புறப்பட்டு மூன்று நாட்கள் பயணம் செய்தார்கள். தங்கும் இடம் ஒன்றைக் கண்டுகொள்வதற்காக அந்த மூன்றுநாட்களும் யெகோவாவின் உடன்படிக்கைப்பெட்டி அவர்களுக்கு முன்னால் சென்றது. ");
INSERT INTO tamtcv_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","அவர்கள் முகாமைவிட்டுப் புறப்பட்டபோது, பகலில் யெகோவாவின் மேகம் அவர்களுக்கு மேலாக இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","உடன்படிக்கைப்பெட்டி புறப்பட்டபோதெல்லாம் மோசே சொன்னது: “யெகோவாவே, எழுந்தருளும்! உமது பகைவர் சிதறடிக்கப்படுவார்களாக; உமது எதிரிகள் உமக்கு முன்பாகப் பயந்து ஓடுவார்களாக.” ");
INSERT INTO tamtcv_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","உடன்படிக்கைப்பெட்டி தங்கும்போதெல்லாம் மோசே சொன்னது: “யெகோவாவே, எண்ணிலடங்கா பல்லாயிரக்கணக்கான இஸ்ரயேலரிடம் திரும்பி வாரும்.” ");
INSERT INTO tamtcv_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","இப்பொழுது மக்கள் தங்கள் கஷ்டங்களை யெகோவா கேட்கும்படி முறையிட்டார்கள். அவர் அதைக் கேட்டபோது, அவருடைய கோபம் மூண்டது. யெகோவாவின் கோபம் அவர்கள் மத்தியில் நெருப்பாய் எரிந்து, முகாமின் சுற்றுப்புறங்களை அழித்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","அவ்வேளையில் மக்கள் மோசேயை நோக்கிக் கதறினார்கள். மோசே அவர்களுக்காக யெகோவாவிடம் மன்றாடினான். அப்பொழுது நெருப்பு அணைந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","அங்கே யெகோவாவின் நெருப்பு அவர்கள் மத்தியில் எரிந்தபடியால், அந்த இடம், தபேரா என அழைக்கப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","இஸ்ரயேலருடன் இருந்த அந்நியர்கள் எகிப்தின் உணவுக்காக ஆசைகொண்டவர்களானார்கள். இஸ்ரயேலரும் அவர்களுடன் சேர்ந்து புலம்பத் தொடங்கினார்கள். அவர்கள், “சாப்பிட எங்களுக்கு இறைச்சி மட்டுமாவது கிடைக்காதா! ");
INSERT INTO tamtcv_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","எகிப்தில் செலவின்றி நாம் சாப்பிட்ட மீனையும், அத்துடன் வெள்ளரிக்காய், கொம்மட்டிக்காய், கீரை, வெங்காயம், வெள்ளைப்பூண்டு ஆகியவற்றையும் நினைத்துப் பார்க்கிறோம். ");
INSERT INTO tamtcv_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","இப்பொழுது நமக்குச் சாப்பிடவே மனமில்லாமல் போனோம். மன்னாவைத் தவிர வேறொன்றையும் காணோமே” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","மன்னா கொத்தமல்லி விதையைப் போன்றும், பார்வைக்கு வெளிர்மஞ்சள் நிறமாகவும் இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","மக்கள் சுற்றித்திரிந்து அதைப்பொறுக்கி, அவற்றைத் திரிகையினால் திரித்தோ, உரலில் இடித்தோ மாவாக்கிப் பாத்திரத்திலிட்டு சமைப்பார்கள் அல்லது அடை அப்பங்களாகச் சுடுவார்கள். அதன் சுவை ஒலிவ எண்ணெயில் தயாரிக்கப்பட்ட உணவைப்போல் இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","இரவில் முகாமின்மேல் பனிபெய்து அது படியும்போதெல்லாம் அதனுடன் மன்னாவும் கீழே விழும். ");
INSERT INTO tamtcv_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","ஒவ்வொரு குடும்பமும் தங்கள் முந்திய உணவில் விருப்பங்கொண்டு, தங்கள் கூடாரவாசலில் நின்று இவ்வாறு அழுவதை மோசே கேட்டான். யெகோவா மிகவும் கோபம்கொண்டார். மோசேயும் கலக்கம் அடைந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","எனவே மோசே யெகோவாவிடம், “உமது அடியேன்மேல் ஏன் இவ்வளவு கஷ்டத்தைச் சுமத்தினீர். இந்த மக்கள் எல்லோரினது பாரத்தையும் என்மேல் சுமத்துவதற்கு நான் உமக்கு விரோதமாக எதைச்செய்தேன்? ");
INSERT INTO tamtcv_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","இந்த மக்களையெல்லாம் நானா கர்ப்பந்தரித்தேன்? இவர்களை நானா பெற்றெடுத்தேன்? ஒரு தாதி ஒரு குழந்தையைச் சுமப்பதுபோல், இவர்கள் முற்பிதாக்களுக்கு நீர் வாக்குக்கொடுத்த நாட்டிற்கு இவர்களை என் கைகளினால் சுமந்துகொண்டுச் செல்லும்படி ஏன் சொல்கிறீர்? ");
INSERT INTO tamtcv_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","இந்த மக்கள் எல்லோருக்கும் இறைச்சிகொடுக்க நான் எங்கே போவேன்? ‘எங்களுக்குச் சாப்பிட இறைச்சியைக் கொடு’ என இவர்கள் என்னிடம் கேட்டு, அழுகிறார்களே. ");
INSERT INTO tamtcv_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","இந்த மக்கள் எல்லோரையும் தனியே சுமக்க என்னால் முடியாது. இந்தச் சுமை எனக்கு அதிக பாரமாயிருக்கிறது. ");
INSERT INTO tamtcv_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","இவ்விதமாகவே நீர் என்னை நடத்துவீர் என்றால் என்னை இப்பொழுது கொன்றுவிடும். உமது கண்களில் எனக்குத் தயவு கிடைக்குமானால் நானே என் சொந்த அழிவைக் காணாதபடி என்னைக் கொன்றுபோடும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","அதற்கு யெகோவா மோசேயிடம்: “இஸ்ரயேலரின் சபைத்தலைவர்களாகவும், அதிகாரிகளாகவும் உனக்குத் தெரிந்திருக்கும் இஸ்ரயேலின் முதியவர்களில் எழுபதுபேரை என்னிடம் கூட்டிக்கொண்டு வா. அவர்கள் உன்னுடன் சபைக் கூடாரத்தில் நிற்கும்படி அங்கு அவர்களை வரச்சொல். ");
INSERT INTO tamtcv_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","நான் கீழே வந்து உன்னோடு பேசுவேன். பின்பு நான் உன்மேல் இருக்கிற ஆவியானவரை அவர்கள்மேலும் வைப்பேன். மக்களின் பாரத்தைச் சுமப்பதற்கு அவர்கள் உதவி செய்வார்கள். அப்பொழுது நீ அப்பாரத்தைத் தனிமையாய் சுமக்க வேண்டியிராது. ");
INSERT INTO tamtcv_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“எனவே நீ மக்களிடம்: ‘நீங்கள் நாளைய தினத்திற்கு ஆயத்தமாக உங்களை அர்ப்பணம் செய்யுங்கள், நாளைக்கே நீங்கள் இறைச்சியைச் சாப்பிடுவீர்கள். “நாங்கள் சாப்பிடுவதற்கு எங்களுக்கு இறைச்சி கிடைக்காதோ? எகிப்தில் நாங்கள் சந்தோஷமாய் இருந்தோமே என்று சொல்லி நீங்கள் அழுததை யெகோவா கேட்டார்!” இப்பொழுது யெகோவா உங்களுக்கு இறைச்சி தருவார். நீங்கள் அதைச் சாப்பிடுவீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","நீங்கள் அதை ஒன்றிரண்டு நாட்களுக்கோ, ஐந்து பத்து இருபது நாட்களுக்கு மட்டுமோ சாப்பிடமாட்டீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ஒரு முழு மாதமும் சாப்பிடுவீர்கள். நீங்கள் அதை மூக்குமுட்ட தின்று, அதை அருவருக்கும்வரை சாப்பிடுவீர்கள். ஏனெனில், நீங்கள் உங்களோடிருக்கிற யெகோவாவைப் புறக்கணித்து, “நாங்கள் ஏன் எகிப்தைவிட்டு வந்தோம்?” என்று சொல்லி அவருக்கு முன்பாக அழுதிருக்கிறீர்கள் என்று சொல்’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","அதற்கு மோசே: “என்னுடன் ஆறு இலட்சம் மனிதர் இருக்கிறார்கள், ‘நீரோ ஒரு மாதத்திற்கு அவர்களுக்கு இறைச்சி தருவதாகச் சொல்கிறீர்!’ ");
INSERT INTO tamtcv_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","அவர்களுக்காக எங்களிடமுள்ள ஆட்டு மந்தைகளும், மாட்டு மந்தைகளும் வெட்டப்பட்டாலும் அவையும் போதாது? கடலிலுள்ள எல்லா மீன்களையும் பிடித்தாலும் அவையும் அவர்களுக்குப் போதாதே?” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","அதற்கு யெகோவா மோசேயிடம், “யெகோவாவினுடைய கரம் குறுகியிருக்கிறதோ? நான் உனக்குச் சொன்னது உண்மையாய் நடக்குமோ, நடக்காதோ என இருந்து பார்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","யெகோவா சொன்னவற்றையெல்லாம் மோசே வெளியே போய் மக்களுக்குச் சொன்னான். அதன்பின் அவன் அவர்களில் எழுபது சபைத்தலைவர்களை ஒன்றுசேர்த்து சபைக் கூடாரத்தைச் சுற்றி நிறுத்தினான். ");
INSERT INTO tamtcv_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","அப்பொழுது யெகோவா மேகத்தில் இறங்கி, மோசேயுடன் பேசினார். பின் அவனில் இருந்த ஆவியானவரை அந்த சபைத்தலைவர்கள் எழுபதுபேர் மேலும் வைத்தார். ஆவியானவர் அவர்கள்மேல் வந்தவுடன், அவர்கள் இறைவாக்குரைத்தனர். ஆனால் அவர்கள் திரும்ப இறைவாக்கு உரைக்கவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","எல்தாத், மேதாத் என்னும் இரண்டு மனிதர்கள் தங்கள் முகாமிலேயே தங்கி இருந்தார்கள். அவர்களும் அந்தச் சபைத்தலைவர்களுடன் குறிக்கப்பட்டிருந்தார்கள். ஆனாலும் அவர்கள் சபைக் கூடாரத்திற்குப் போகவில்லை. அவர்கள்மேலும் அந்த ஆவியானவர் இறங்கியபோது, அவர்கள் தங்கள் முகாம்களுக்குள்ளே இறைவாக்கு உரைத்தனர். ");
INSERT INTO tamtcv_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","ஒரு வாலிபன் மோசேயிடம் ஓடிப்போய், “எல்தாத்தும், மேதாத்தும் முகாமில் இறைவாக்கு உரைக்கிறார்கள்” என்று சொன்னான். ");
INSERT INTO tamtcv_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","அப்பொழுது நூனின் மகனும் மோசேயின் உதவியாளனுமான யோசுவா என்னும் வாலிபன் மோசேயிடம், “என் ஆண்டவனே அவர்கள் பேசுவதை நிறுத்தும்!” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","ஆனால் மோசேயோ, அவனிடம், “நீ எனக்காகப் பொறாமைகொண்டு இதைச் சொல்கிறாய்? யெகோவாவின் மக்கள் எல்லாம் இறைவாக்குரைப்போராய் இருக்கவேண்டும் என்றும், யெகோவா அவர்கள்மேல் தமது ஆவியானவரை வைக்கவேண்டும் என்றுமே நான் விரும்புகிறேன்!” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","பின்பு மோசேயும் இஸ்ரயேலரின் சபைத்தலைவர்களும் முகாமுக்குத் திரும்பினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","அப்பொழுது யெகோவாவிடமிருந்து ஒரு காற்றுப் புறப்பட்டு, கடலில் இருந்து காடைகளை அடித்துக்கொண்டு வந்தது. அவை முகாமைச் சுற்றிலும் நிலத்திலிருந்து மூன்றடி உயரத்திற்குப் போடப்பட்டன. முகாமிலிருந்து எப்பக்கம் போனாலும் ஒரு நாள் பயணதூரம்வரை அவை கிடந்தன. ");
INSERT INTO tamtcv_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","அன்று பகல் முழுவதும், இரவு முழுவதும், அடுத்தநாள் முழுவதும் மக்கள் வெளியே போய், காடைகளைச் சேர்த்தார்கள். பத்து ஓமருக்குக் குறைவாக ஒருவனுமே காடைகளைச் சேர்க்கவில்லை. அவர்கள் அவற்றை முகாமைச் சுற்றிப் பரப்பிவைத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","அவர்கள் அந்த இறைச்சியை மென்று கொண்டிருக்கும்போதே, அதை விழுங்குவதற்கு முன்னே அவர்கள்மேல் யெகோவாவின் கோபம் மூண்டது. யெகோவா அவர்களை மிகக் கொடிய கொள்ளைநோயினால் வாதித்தார். ");
INSERT INTO tamtcv_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","மற்ற உணவில் அடங்கா ஆசைகொண்டதனால் செத்த மக்களை அங்கே புதைத்தார்கள்; அதனால் அந்த இடம் கிப்ரோத் அத்தாவா எனப் பெயரிடப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","பின்பு மக்கள் கிப்ரோத் அத்தாவாவை விட்டுப் புறப்பட்டுபோய் ஆஸ்ரோத்திலே தங்கினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","மோசே ஒரு எத்தியோப்பியப் பெண்ணைத் திருமணம் செய்திருந்தான். அந்த எத்தியோப்பியப் பெண்ணின் நிமித்தம் மிரியாமும் ஆரோனும் அவனுக்கு விரோதமாகப் பேசத் தொடங்கினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","அவர்கள், “யெகோவா மோசே மூலம் மட்டும்தான் பேசியிருக்கிறாரோ? எங்கள் மூலமாகவும் அவர் பேசவில்லையோ?” என்றார்கள். யெகோவா அதைக் கேட்டார். ");
INSERT INTO tamtcv_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","மோசே மிகவும் தாழ்மையுள்ளவன். அவன் பூமியிலுள்ள எல்லா மனிதரைப் பார்க்கிலும் தாழ்மையுள்ளவனாயிருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","உடனே யெகோவா மோசே, ஆரோன், மிரியாம் ஆகியோரிடம், “நீங்கள் மூவரும் வெளியே சபைக் கூடாரத்திற்கு வாருங்கள்” என்றார். மூவரும் வெளியே வந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","அப்பொழுது யெகோவா மேகத்தூணில் இறங்கிவந்து, சபைக் கூடாரத்தின் வாசலில் நின்றார். அவர் ஆரோனையும், மிரியாமையும் அழைத்தார். அவர்கள் இருவரும் முன்னே வந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","அப்பொழுது யெகோவா அவர்களிடம் சொன்னது: “என் வார்த்தைகளைக் கேளுங்கள்: “உங்களுக்குள் இறைவாக்குரைப்பவன் ஒருவன் இருந்தால், யெகோவாவாகிய நான் அவனுக்குத் தரிசனங்களில் என்னை வெளிப்படுத்துவேன், கனவுகளில் அவனோடு பேசுவேன். ");
INSERT INTO tamtcv_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","ஆனால் என் அடியவன் மோசேயுடனோ அப்படியல்ல; என் முழு வீட்டிலுமே அவன் உண்மையுள்ளவனாயிருக்கிறான். ");
INSERT INTO tamtcv_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","ஆகையால் நான் அவனோடு நேரடியாகவே பேசுகிறேன், புரியாதவிதமாக அல்ல தெளிவாகவே பேசுகிறேன்; அவன் யெகோவாவின் சாயலைக் காண்கிறான். அப்படியிருக்க, என் அடியான் மோசேக்கு விரோதமாய்ப் பேசுவதற்கு நீங்கள் ஏன் பயப்படவில்லை?” ");
INSERT INTO tamtcv_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","அப்பொழுது யெகோவாவின் கோபம் அவர்களுக்கெதிராக மூண்டது, அவர் அவர்களைவிட்டு விலகிப்போனார். ");
INSERT INTO tamtcv_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","அந்த மேகம் கூடாரத்திலிருந்து எழும்பியவுடன் மிரியாம் உறைபனியைப்போல் குஷ்டரோகியாய் நின்றாள். ஆரோன் அவளைத் திரும்பிப் பார்த்தபோது, அவளுக்குக் குஷ்டரோகம் இருப்பதைக் கண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","அப்பொழுது ஆரோன் மோசேயிடம், “என் ஆண்டவனே, தயவுசெய்து நாங்கள் மூடத்தனமாய் செய்த பாவத்திற்காக எங்களுக்கு விரோதமாயிராதேயும். ");
INSERT INTO tamtcv_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","தாயின் கருப்பையிலேயே பாதி சதை அழிந்து செத்துப்பிறந்த குழந்தையைப்போல் அவளை இருக்கவிடாதேயும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","அப்பொழுது மோசே யெகோவாவிடம், “இறைவனே, தயவுசெய்து அவளைக் குணமாக்கும்” என அழுது வேண்டிக்கொண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","அப்பொழுது யெகோவா மோசேயிடம், “அவள் தகப்பன் அவள் முகத்தில் காறித் துப்பியிருந்தால் ஏழுநாட்களுக்கேனும் அவள் அவமானத்துடன் இருக்கமாட்டாளோ? எனவே ஏழுநாட்களுக்கு அவளை முகாமுக்கு வெளியே வையுங்கள். அதற்குப்பின் திரும்பவும் அவளைச் சேர்த்துக்கொள்ளலாம்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","அப்படியே மிரியாம் முகாமுக்கு வெளியே ஏழு நாட்கள் அடைத்து வைக்கப்பட்டாள். அவள் திரும்பி வரும்வரை மக்கள் அவ்விடம் விட்டு அசையவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","அதன்பின் மக்கள் ஆஸ்ரோத்தை விட்டுப் பிரயாணமாகி, பாரான் பாலைவனத்தில் முகாமிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","யெகோவா மோசேயிடம் சொன்னதாவது, ");
INSERT INTO tamtcv_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“நான் இஸ்ரயேலருக்குக் கொடுக்கவிருக்கும் கானான் நாட்டை ஆராய்ந்து அறிவதற்கு சில மனிதரை அனுப்பு. ஒவ்வொரு கோத்திரத்திலிருந்தும் அதன் தலைவர்களில் ஒருவனை அனுப்பு” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","யெகோவா கட்டளையிட்டபடியே, மோசே அவர்களைப் பாரான் பாலைவனத்திலிருந்து அனுப்பினான். அவர்கள் எல்லோரும் இஸ்ரயேலரின் தலைவர்களாயிருந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","அவர்களுடைய பெயர்களாவன: ரூபன் கோத்திரத்திலிருந்து சக்கூரின் மகன் சம்முவா, ");
INSERT INTO tamtcv_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","சிமியோன் கோத்திரத்திலிருந்து ஓரியின் மகன் சாப்பாத், ");
INSERT INTO tamtcv_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","யூதா கோத்திரத்திலிருந்து எப்புன்னேயின் மகன் காலேப், ");
INSERT INTO tamtcv_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","இசக்கார் கோத்திரத்திலிருந்து யோசேப்பின் மகன் ஈகால், ");
INSERT INTO tamtcv_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","எப்பிராயீம் கோத்திரத்திலிருந்து நூனின் மகன் ஓசேயா, ");
INSERT INTO tamtcv_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","பென்யமீன் கோத்திரத்திலிருந்து ரப்பூவின் மகன் பல்த்தி, ");
INSERT INTO tamtcv_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","செபுலோன் கோத்திரத்திலிருந்து சோதியின் மகன் காதியேல், ");
INSERT INTO tamtcv_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","யோசேப்பு கோத்திரத்தானான மனாசேயின் கோத்திரத்திலிருந்து சூசியின் மகன் காதி, ");
INSERT INTO tamtcv_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","தாண் கோத்திரத்திலிருந்து கெமல்லியின் மகன் அம்மியேல், ");
INSERT INTO tamtcv_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","ஆசேர் கோத்திரத்திலிருந்து மிகாயேலின் மகன் சேத்தூர், ");
INSERT INTO tamtcv_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","நப்தலி கோத்திரத்திலிருந்து ஒப்பேசியின் மகன் நாகபி, ");
INSERT INTO tamtcv_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","காத் கோத்திரத்திலிருந்து மாகியின் மகன் கூயேல். ");
INSERT INTO tamtcv_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","நாட்டை ஆராய்ந்து அறிவதற்கு மோசே அனுப்பிய மனிதர்களின் பெயர்கள் இவையே. மோசே நூனின் மகன் ஒசேயாவுக்கு யோசுவா என்று பெயரிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","கானானை ஆராய்ந்து அறியும்படிக்கு மோசே அவர்களை அனுப்பியபோது, அவன் அவர்களிடம், “நீங்கள் தெற்கு பிரதேசத்தின் வழியாக மலைநாட்டிற்குப் போங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","போய், அந்த நாடு எப்படிப்பட்டதுதென்றும், அங்கே வாழும் மக்கள் பலசாலிகளா, பலவீனர்களா, அதிகமானவர்களா, குறைவானவர்களா என்றும் பாருங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","அவர்கள் வாழும் நிலம் எப்படிப்பட்டது? நல்லதோ? கெட்டதோ? அவர்கள் வாழும் பட்டணங்கள் எப்படிப்பட்டவை? அரண் அற்றவையோ? அரணுள்ளவையோ? ");
INSERT INTO tamtcv_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","மண் எப்படிப்பட்டது? அது வளமுள்ளதா, வளமற்றதா? மரங்கள் இருக்கின்றனவா, இல்லையா? என்றும் பாருங்கள். அந்த நாட்டின் பழங்களில் சிலவற்றைக் கொண்டுவரவும் முயற்சி செய்யுங்கள்” என்றான். அது திராட்சை முதற்பழம் பழுக்கும் காலமாய் இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","அவர்கள் போய் சீன் பாலைவனம்தொடங்கி, லேபோ ஆமாத்துக்கு முன்பாக உள்ள ரேகோப் வரையும் நாட்டை ஆராய்ந்து பார்த்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","அவர்கள் தெற்கு பக்கத்தின் வழியாகப்போய் எப்ரோனுக்கு வந்தார்கள். அங்கே அகீமான், சேசாய், தல்மாய் ஆகிய ஏனாக்கின் சந்ததியினர் வாழ்ந்தார்கள். எப்ரோன் எகிப்திலுள்ள சோவான் கட்டப்படுவதற்கு ஏழு வருடத்திற்கு முன்பே கட்டப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","அவர்கள் எஸ்கோல் பள்ளத்தாக்கை வந்தடைந்தபோது, ஒரு தனி திராட்சைப்பழக் குலையுடைய ஒரு கிளையை வெட்டினார்கள். அதனுடன் சில மாதுளம் பழங்களையும், அத்திப்பழங்களையும் ஒரு தடியில்போட்டு, இரண்டுபேர் தூக்கிக்கொண்டு போனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","அங்கே இஸ்ரயேலர் திராட்சைக் குலையை வெட்டியதனால் அந்த இடம், “எஸ்கோல்” பள்ளத்தாக்கு என்று அழைக்கப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","அவர்கள் நாற்பது நாட்களுக்கு நாட்டை ஆராய்ந்துபார்த்து பின்பு திரும்பி வந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","அவர்கள் பாரான் பாலைவனத்திலுள்ள காதேசில் இருந்த மோசே, ஆரோன் மற்றும் இஸ்ரயேலின் முழு சமுதாயத்தினரிடமும் வந்தார்கள். தாம் ஆராய்ந்து அறிந்தவற்றை அவர்களுக்கும், சபையார் அனைவருக்கும் சொன்னதோடு, அந்நாட்டிலிருந்து கொண்டுவந்திருந்த பழங்களையும் அவர்களுக்குக் காட்டினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","அவர்கள் மோசேயிடம், “நீர் அனுப்பிய நாட்டிற்கு நாங்கள் போனோம். அது பாலும் தேனும் வழிந்தோடும் நாடு! இதோ அதன் பழங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","ஆனால் அங்குள்ள மக்களோ மிகவும் பலம் வாய்ந்தவர்கள். அத்துடன் நகரங்களும் அரணுள்ளவையும், விசாலமானவையுமாய் இருக்கின்றன. அங்கே ஏனாக்கின் சந்ததிகளைக்கூட நாங்கள் கண்டோம். ");
INSERT INTO tamtcv_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","அமலேக்கியர் நாட்டின் தெற்கு பகுதியில் வாழ்கிறார்கள். ஏத்தியர், எபூசியர், எமோரியர் ஆகியோர் மலைநாட்டில் வாழ்கிறார்கள். கடல் அருகேயும், யோர்தான் நதியோரம் கானானியர் வாழ்கிறார்கள்” என்று விவரமாய்ச் சொன்னார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","அப்பொழுது காலேப், மக்களை மோசேக்கு முன்பாக அமைதிப்படுத்தி, அவர்களிடம், “நாம் இப்பொழுதே போய் அந்நாட்டை நமக்கு உடைமையாக்கிக் கொள்ளவேண்டும். நிச்சயமாக நாம் அதைச் சொந்தமாக்கிக் கொள்ளலாம்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","ஆனால் காலேப்புடன் போன மனிதர்களோ, “அந்த மக்களை எதிர்க்க நம்மால் முடியாது. ஏனெனில், அவர்கள் எங்களைப்பார்க்கிலும் பலசாலிகள்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","அவர்கள் தாம் ஆராய்ந்து அறிந்து வந்த நாட்டைப்பற்றி இஸ்ரயேலர் மத்தியில் பிழையான செய்தியைப் பரப்பினார்கள். நாங்கள் ஆராய்ந்து அறிந்து வந்த நாடு அங்கு வாழ்கிறவர்களை அழித்தொழிக்கும் நாடு. நாங்கள் அங்கு கண்ட மக்களும் உருவத்தில் பெரியவர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","அரக்கர்களின் வழிவந்த ஏனாக்கின் சந்ததிகளான அரக்கர்களையும் அங்கு கண்டோம். நாங்கள் எங்கள் பார்வையில் அவர்களுக்கு முன்னால் வெட்டுக்கிளிகளைப்போல் காணப்பட்டோம். அவர்களுடைய பார்வையிலும் நாங்கள் அப்படியே காணப்பட்டோம் என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","அந்தச் சமுதாய மக்கள் அனைவரும் அன்றிரவு சத்தமாய்க் கூக்குரலிட்டு அழுதார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","இஸ்ரயேலர் எல்லோருமே மோசேக்கும் ஆரோனுக்கும் விரோதமாக முறுமுறுத்தார்கள். சபையார் அனைவரும் அவர்களிடம், “நாங்கள் எகிப்தில் இறந்திருக்கலாம் அல்லது இந்த பாலைவனத்திலேயே இறந்திருக்கலாமே! ");
INSERT INTO tamtcv_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","வாளுக்கு இரையாகும்படி யெகோவா ஏன் எங்களை இந்த நாட்டிற்குக் கொண்டுவருகிறார்? எங்கள் மனைவிகளும், பிள்ளைகளும் அவர்கள் கையில் பிடிபட்டுக் கைதிகளாகப் போகப்போகிறார்களே! அதைவிட நாங்கள் எகிப்து நாட்டிற்குத் திரும்பிப்போவது நலமாயிருக்காதோ?” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","மேலும், “நாம் நமக்கு ஒரு தலைவனைத் தெரிந்துகொண்டு எகிப்திற்குத் திரும்பிப் போகவேண்டும்” என்றும் அவர்கள் ஒருவரோடொருவர் சொல்லிக்கொண்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","அப்பொழுது மோசேயும், ஆரோனும் அங்கு கூடியிருந்த இஸ்ரயேல் சபைக்கு முன்பாக முகங்குப்புற விழுந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","நாட்டை ஆராய்ந்து அறியச்சென்றவர்களில் நூனின் மகன் யோசுவாவும், எப்புன்னேயின் மகன் காலேப்பும் தங்கள் உடைகளைக் கிழித்துக்கொண்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","அவர்கள் முழு இஸ்ரயேல் சபையையும் பார்த்து, “நாங்கள் கடந்துசென்று ஆராய்ந்து அறிந்த நாடு மிகமிக நல்ல நாடு. ");
INSERT INTO tamtcv_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","யெகோவா எங்களில் பிரியமாயிருந்தால், பாலும் தேனும் வழிந்தோடும் அந்த நாட்டிற்கு எங்களை வழிநடத்தி அதை எங்களுக்குத் தருவார். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","நீங்கள் யெகோவாவுக்கு விரோதமாக மட்டும் கலகம் செய்யாதீர்கள். அந்நாட்டு மக்களுக்குப் பயப்படவேண்டாம். ஏனெனில், நாங்கள் அவர்களை அழித்துவிடுவோம். அவர்களுடைய பாதுகாப்பு அவர்களைவிட்டுப் போய்விட்டது. யெகோவா எங்களோடிருக்கிறார். நீங்கள் அவர்களுக்குப் பயப்படவேண்டாம்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","ஆனால் முழுசபையாரும் அவர்களுக்குக் கல்லெறியவேண்டுமென பேசிக்கொண்டார்கள். அவ்வேளையில் யெகோவாவின் மகிமை சபைக் கூடாரத்தில் எல்லா இஸ்ரயேலருக்கும் முன்பாகத் தோன்றியது. ");
INSERT INTO tamtcv_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","அப்பொழுது யெகோவா மோசேயிடம், “இம்மக்கள் எவ்வளவு காலத்திற்கு என்னை அவமதித்து நடப்பார்கள்? நான் இத்தனை அற்புத அடையாளங்கள் அவர்கள் மத்தியில் செய்திருக்கும்போது, எவ்வளவு காலத்திற்கு அவர்கள் என்னை விசுவாசிக்க மறுப்பார்கள்? ");
INSERT INTO tamtcv_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","அவர்களை நான் கொள்ளைநோயினால் வாதித்து அழிப்பேன். உன்னையோ அவர்களைப்பார்க்கிலும் பெரியதும் வல்லமையுள்ளதுமான ஒரு நாடாக்குவேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","அதற்கு மோசே யெகோவாவிடம், “அப்பொழுது எகிப்தியர் இதைக்குறித்து கேள்விப்படுவார்களே! நீர் இந்த மக்களை உம்முடைய வல்லமையினால் எகிப்திலிருந்து இங்கே கொண்டுவந்தீர். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","எகிப்தியர் நாட்டு மக்களுக்கு அதைப்பற்றிச் சொல்வார்கள். யெகோவாவே, நீர் இந்த மக்கள் மத்தியில் இருக்கிறீர் என்றும், உமது மேகம் அவர்கள்மேல் இருக்கிறதென்றும், அவர்கள் உம்மை நேருக்குநேர் காணும்படி செய்தீர் என்றும், நீரே அவர்களுக்கு முன்பாக பகலில் மேகத்தூணாகவும், இரவில் நெருப்புத்தூணாகவும் போகிறீர் என்றும் அவர்கள் ஏற்கெனவே கேள்விப்பட்டிருக்கிறார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","நீர் இப்பொழுது இம்மக்களை ஒரேயடியாகக் கொன்றுபோடுவீரானால், உம்மைப் பற்றிய விவரத்தைக் கேள்விப்பட்ட பிறநாடுகள், ");
INSERT INTO tamtcv_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘தாம் ஆணையிட்டு வாக்குக்கொடுத்த நாட்டிற்குள் இந்த மக்களைக் கொண்டுவர யெகோவாவினால் முடியவில்லை. அதனால் அவர்களை பாலைவனத்திலேயே கொன்றுபோட்டார்’ என்பார்களே” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“யெகோவாவே, நீர் அறிவித்திருக்கிற உமது வல்லமையை இப்பொழுதே வெளிப்படுத்திக் காட்டுவீராக: ");
INSERT INTO tamtcv_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘யெகோவா கோபப்படுவதற்குத் தாமதிக்கிறவர், அன்பினால் நிறைந்தவராய் பாவத்தையும் கலகத்தையும் மன்னிக்கிறவர். ஆனாலும், குற்றவாளிகளைத் தண்டனையின்றி தப்பிப்போக விடாதவர். பெற்றோரின் பாவங்களுக்காக மூன்றாம் நான்காம் தலைமுறைவரைக்கும் பிள்ளைகளைத் தண்டிக்கிறவர்’ என்று அறிவித்திருக்கிறீரே. ");
INSERT INTO tamtcv_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","உமது மிகுந்த அன்பின்படியே, எகிப்திலிருந்து வந்தகாலம் தொடங்கி இன்றுவரை அவர்களை மன்னித்ததுபோல், இம்மக்களின் பாவத்தையும் இப்பொழுதும் மன்னியும்” என்று மன்றாடினான். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","அதற்கு யெகோவா, “நீ கேட்டபடியே நான் அவர்களை மன்னித்துவிட்டேன். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ஆனாலும் நான் வாழ்வது நிச்சயம்போலவும், யெகோவாவினுடைய மகிமை பூமியை நிரப்புவது நிச்சயம்போலவும், ");
INSERT INTO tamtcv_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","என் மகிமையையும், எகிப்திலுள்ள பாலைவனத்தில் நான் செய்த அற்புத அடையாளங்களையும் கண்டும், எனக்குக் கீழ்ப்படியாமல் என்னை பத்துமுறை சோதித்த எவனும், ");
INSERT INTO tamtcv_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","அவர்களுடைய முற்பிதாக்களுக்குத் தருவேன் என நான் ஆணையிட்டு வாக்குக்கொடுத்த நாட்டை ஒருபோதும் காணமாட்டான் என்பதும், என்னை அவமதித்து நடந்த எவனும் அதை ஒருபோதும் காணமாட்டான் என்பதும் நிச்சயம். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","ஆனால், என் பணியாளன் காலேப் ஒரு வித்தியாசமான ஆவி உடையவனாயும், தன் முழு இருதயத்தோடும் என்னைப் பின்பற்றுகிறவனாயும் இருப்பதால், அவன் போய்ப் பார்த்த அந்த நாட்டிற்குள் நான் அவனைக் கொண்டுவருவேன். அவனுடைய சந்ததிகளும் அதை உரிமையாக்கிக்கொள்வார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","அமலேக்கியரும், கானானியரும் பள்ளத்தாக்குகளில் வாழ்கிறார்கள். அதனால் நீங்கள் நாளைக்குச் செங்கடலுக்குப் போகிற வழியால் திரும்பவும் பாலைவனத்துக்குப் போங்கள்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","அத்துடன் யெகோவா மோசேயிடமும் ஆரோனிடமும் சொன்னதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“இந்த கொடுமையான சமுதாயம் எவ்வளவு காலத்திற்கு எனக்கு விரோதமாக முறுமுறுக்கும்? முறுமுறுக்கும் இந்த இஸ்ரயேலர்களின் முறையீட்டை நான் கேட்டிருக்கிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","எனவே நீ அவர்களிடம், ‘நான் வாழ்வது நிச்சயம்போலவே, எனக்கு கேட்கும்படி நீங்கள் முறுமுறுத்த அதே காரியங்களை நான் உங்களுக்குச் செய்வேன் என்பது நிச்சயம்’ என அவர்களுக்குச் சொல் என்று யெகோவா அறிவிக்கிறார். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","இப்பாலைவனத்திலே உங்கள் உடல்கள் விழும். குடிமதிப்பில் கணக்கெடுக்கப்பட்ட இருபது வயதையும், அதற்கு மேற்பட்ட வயதையும் உடையவர்களும், எனக்கு விரோதமாக முறுமுறுத்தவர்களுமான நீங்கள் ஒவ்வொருவரும் விழுவீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","நான் என் கைகளை உயர்த்தி, ஆணையிட்டு, ‘நீங்கள் குடியிருப்பதற்காக வாக்குப்பண்ணிக்கொடுத்த நாட்டிற்குள் எப்புன்னேயின் மகன் காலேப்பையும், நூனின் மகன் யோசுவாவையும் தவிர வேறு எவனும் போவதில்லை’ என்று சொல்கிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","‘சிறைபிடிக்கப்பட்டுப் போவார்களே’ என நீங்கள் சொன்ன உங்கள் பிள்ளைகளையோ, நீங்கள் புறக்கணித்த நாட்டின் பலனை அனுபவிப்பதற்கு அங்கு கொண்டுவருவேன். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","ஆனால் உங்களுக்கோவென்றால், உங்கள் உடல்கள் இப்பாலைவனத்திலேயே விழும். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","உங்கள் பிள்ளைகள் உங்கள் உண்மையற்ற தன்மையினால் உங்கள் கடைசி உடல் இப்பாலைவனத்தில் விழும் வரைக்கும், கஷ்டப்பட்டு, நாற்பது வருடங்களுக்கு இங்கு மேய்ப்பர்களாயிருப்பார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","நீங்கள் நாட்டை ஆராய்ந்த நாற்பது நாட்களிலும் உள்ள ஒவ்வொரு நாளுக்கும் ஒவ்வொரு வருடம் என்ற கணக்கின்படி, நாற்பது வருடங்களுக்கு உங்கள் பாவங்களுக்காக நீங்கள் கஷ்டப்பட்டு, என்னை எதிர்ப்பதால் வரும் விளைவு என்ன என்பதையும் அறிவீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","யெகோவாவாகிய நானே சொல்லியிருக்கிறேன். எனக்கெதிராக ஒன்றுகூடிய இக்கொடுமையான மனிதர்கள் அனைவருக்குமே நான் நிச்சயமாக இக்காரியங்களைச் செய்வேன். அவர்கள் தங்கள் முடிவை இப்பாலைவனத்திலேயே சந்திப்பார்கள். இங்கேயே அவர்கள் சாவார்கள் என்றும் சொல்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","எனவே நாட்டை ஆராய்ந்து அறியும்படி மோசேயினால் அனுப்பப்பட்டுத் திரும்பிவந்து, அதைப்பற்றிப் பிழையான செய்தியைப் பரப்பி, அதனால் முழு மக்கள் சமுதாயத்தையும் அவனுக்கு எதிராக முறுமுறுக்கப் பண்ணினவர்களை இறைவன் அடித்தார். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","அவ்விதமாய் அந்நாட்டைப் பற்றிய பிழையான செய்தியைப் பரப்பக் காரணமாய் இருந்த இந்த மனிதர்கள் யெகோவாவுக்கு முன்பாக ஒரு கொள்ளைநோயினால் வாதிக்கப்பட்டு இறந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","நாட்டை ஆராய்ந்து அறியச்சென்ற மனிதர்களில் நூனின் மகன் யோசுவா, எப்புன்னேயின் மகன் காலேப் ஆகியோர் மட்டும் உயிர்த்தப்பியிருந்தனர். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","மோசே இதை எல்லா இஸ்ரயேலர்களுக்கும் அறிவித்தபோது, அவர்கள் மனங்கசந்து துக்கித்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","அதன்பின் அவர்கள் அடுத்தநாள் அதிகாலமே எழுந்து உயரமான மலைநாட்டை நோக்கி ஏறிப்போனார்கள். “நாங்கள் பாவம்செய்தோம். நாங்கள் யெகோவா எங்களுக்குத் தருவதாக வாக்களித்த நாட்டுக்குப் போவோம்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","ஆனால் மோசே அவர்களிடம், “நீங்கள் ஏன் யெகோவாவின் கட்டளையை மீறுகிறீர்கள்? இந்த முயற்சி பலனளிக்காது. ");
INSERT INTO tamtcv_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","நீங்கள் மேலே ஏறிப்போகவேண்டாம். ஏனெனில் யெகோவா உங்களுடன் இல்லை. நீங்கள் பகைவர்களால் தோற்கடிக்கப்படுவீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","அங்கே அமலேக்கியரும், கானானியரும் உங்களை எதிர்கொள்வார்கள். நீங்கள் யெகோவாவைவிட்டு விலகிச்சென்றதால், யெகோவா உங்களுடன் இருக்கமாட்டார். நீங்கள் வாளால் வெட்டுண்டு விழுவீர்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","ஆனாலும் அவர்கள் உயரமான அந்த மலைநாட்டிற்கு துணிச்சலோடு ஏறிப்போனார்கள். மோசேயோ, யெகோவாவின் உடன்படிக்கைப் பெட்டியோ முகாமைவிட்டு நகரவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","அப்பொழுது மலைநாட்டில் வாழ்ந்த அமலேக்கியரும், கானானியரும் கீழே இறங்கிவந்து அவர்களைத் தாக்கி, ஓர்மாவரைக்கும் முறியடித்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“நீ இஸ்ரயேலரிடம் பேசிச் சொல்லவேண்டியதாவது: ‘நீங்கள் குடியிருக்கும்படி நான் உங்களுக்குக் கொடுக்கிற நாட்டிற்குள் நீங்கள் போய்ச் சேர்ந்தபின் தகன காணிக்கைகளைக் கொண்டுவருவீர்கள், ");
INSERT INTO tamtcv_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","அது உங்கள் ஆட்டு மந்தையிலிருந்தோ, மாட்டு மந்தையிலிருந்தோ யெகோவாவுக்கு மகிழ்ச்சியூட்டும் நறுமணமாக, நெருப்பினால் செலுத்தப்படும் காணிக்கையாயிருக்கும். அவை யெகோவாவுக்குத் தகன காணிக்கையாகவோ, பலிகளாகவோ, விசேஷ நேர்த்திக்கடனாகவோ அல்லது சுயவிருப்புக் காணிக்கையாகவோ அல்லது பண்டிகைக் காணிக்கையாகவோ இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","அப்பொழுது, மற்ற காணிக்கைகளைக் கொண்டுவருகிறவன் பத்தில் ஒரு பங்கு அளவு சிறந்த மாவுடன் நான்கில் ஒரு பங்கு ஹின் அளவு எண்ணெய்விட்டுப் பிசைந்து அதையும் யெகோவாவுக்குத் தானிய காணிக்கையாகக் கொண்டுவர வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","தகன காணிக்கையாக அல்லது பலியாகச் செலுத்தப்படும் ஒவ்வொரு செம்மறியாட்டுக் குட்டியுடனும், நாலில் ஒரு பங்கு ஹின் அளவு திராட்சை இரசத்தைப் பானகாணிக்கையாக ஆயத்தப்படுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘ஒரு செம்மறியாட்டுக் கடாவுடன் பத்தில் இரண்டு பங்கு எப்பா அளவான சிறந்த மாவுடன், மூன்றில் ஒரு பங்கு ஹின் அளவு எண்ணெய்விட்டுப் பிசைந்து, அதையும் தானிய காணிக்கையாக ஆயத்தப்படுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","அத்துடன் மூன்றில் ஒரு பங்கு ஹின் அளவு திராட்சை இரசத்தைப் பானகாணிக்கையாக ஆயத்தப்படுத்தவேண்டும். அதை யெகோவாவுக்கு மகிழ்ச்சியூட்டும் நறுமணமாகச் செலுத்துங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘யெகோவாவுக்கு விசேஷ நேர்த்திக்கடனுக்காகவோ அல்லது சமாதான காணிக்கைக்காகவோ நீ ஒரு இளங்காளையைத் தகன காணிக்கையாக அல்லது பலியாக ஆயத்தப்படுத்தும்போது, ");
INSERT INTO tamtcv_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","பத்தில் மூன்று பங்கு எப்பா அளவான சிறந்த மாவை இரண்டில் ஒரு பங்கு ஹின் அளவு எண்ணெயில் பிசைந்து, அதை அக்காளையுடன் தானிய காணிக்கையாகக் கொண்டுவர வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","அத்துடன் இரண்டில் ஒரு பங்கு ஹின் அளவு திராட்சை இரசத்தைப் பானகாணிக்கையாகவும் கொண்டுவர வேண்டும். அது யெகோவாவுக்கு மகிழ்ச்சியூட்டும் நறுமணமாக, நெருப்பினால் செலுத்தப்படும் ஒரு காணிக்கையாக இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","ஒவ்வொரு காளையும் அல்லது செம்மறியாட்டுக் கடாவும், ஒவ்வொரு செம்மறியாட்டுக் குட்டியும் அல்லது வெள்ளாட்டுக்குட்டியும் இவ்விதமாகவே ஆயத்தப்படுத்தப்பட வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","நீ ஆயத்தப்படுத்தும் காணிக்கை ஒவ்வொன்றுக்கும், இவ்வாறே செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘சொந்ததேசத்தில் பிறந்த ஒவ்வொருவனும் யெகோவாவுக்கு மகிழ்ச்சியூட்டும் நறுமணமாக, நெருப்பினால் செலுத்தப்படும் காணிக்கையைக் கொண்டுவரும்போது, இவை எல்லாவற்றையும் இவ்விதமாகவே செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","தலைமுறைதோறும் ஒரு அந்நியனாவது அல்லது உங்கள் மத்தியில் வாழும் வேறு யாராவது, யெகோவாவுக்கு மகிழ்ச்சியூட்டும் நறுமணமாக நெருப்பினால் செலுத்தப்படுகிற காணிக்கையைக் கொண்டுவரும்போது, அவனும் நீங்கள் செய்வதுபோலவே சரியாகச் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","மக்கள் சமுதாயத்தில் உங்களுக்கும், உங்கள் மத்தியில் வாழும் அந்நியருக்கும் ஒரே விதிமுறைகளையே நியமிக்கவேண்டும்; இது தலைமுறைதோறும் இருக்கவேண்டிய ஒரு நிரந்தர நியமமாகும். நீங்களும் அந்நியர்களும் யெகோவா முன்னிலையில் பாகுபாடின்றி ஒரேவிதமாகவே இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","உங்களுக்கும் உங்களோடிருக்கும் அந்நியருக்கும் அதே சட்டங்களும், விதிமுறைகளுமே நடைமுறைப்படுத்தப்பட வேண்டும்’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","பின்பு யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“நீ இஸ்ரயேலருடன் பேசி, அவர்களுக்கு சொல்லவேண்டியதாவது: ‘நான் உங்களைக் கூட்டிக்கொண்டுபோகும் நாட்டுக்கு நீங்கள் போய் ");
INSERT INTO tamtcv_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","அந்நாட்டின் உணவை நீங்கள் சாப்பிடும்போது, அதன் ஒரு பங்கை யெகோவாவுக்குக் காணிக்கையாகச் செலுத்துங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","நீங்கள் முதல் அரைக்கும் மாவினால் செய்யப்படும் ஒரு அடை அப்பத்தை, சூடடிக்கும் களத்திலிருந்து வரும் காணிக்கையாகச் செலுத்துங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","வரவிருக்கும் தலைமுறைகளிலெல்லாம், நீங்கள் முதல் அரைக்கும் மாவிலிருந்து இக்காணிக்கையை யெகோவாவுக்குக் கொடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘யெகோவா மோசேக்குக் கொடுத்த கட்டளைகளில் எதையாவது நீங்கள் தற்செயலாகக் கைக்கொள்ளத் தவறக்கூடும். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","அது மோசே மூலம் யெகோவா கொடுத்த கட்டளையாகவும், அது யெகோவா கொடுத்த நாளிலிருந்து வரப்போகும் தலைமுறைதோறும் கடைப்பிடிக்க வேண்டிய கட்டளையாகவும் இருக்கலாம். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","தவறி மக்கள் சமுதாயத்திற்குத் தெரியாமல் தற்செயலாகச் செய்யப்பட்டிருக்கலாம். அப்பொழுது மக்களின் முழு சமுதாயமும் யெகோவாவுக்கு மகிழ்ச்சியூட்டும் நறுமணமான தகன காணிக்கையாக ஒரு இளம்காளையைச் செலுத்தவேண்டும். அத்துடன் அதற்குரிய தானிய காணிக்கையையும், பானகாணிக்கையையும், பாவநிவாரண பலியாக ஒரு வெள்ளாட்டுக்கடாவையும் செலுத்தவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","ஆசாரியன் முழு இஸ்ரயேல் சமுதாயத்தினருக்காகவும், பாவநிவிர்த்தி செய்யவேண்டும். அப்பொழுது அவர்கள் மன்னிக்கப்படுவார்கள். ஏனெனில் அது தற்செயலாகச் செய்யப்பட்ட பாவமாகையாலும், அவர்கள் யெகோவாவுக்கு தங்களுடைய குற்றத்திற்காக நெருப்பினால் செலுத்தப்பட்ட ஒரு காணிக்கையையும் ஒரு பாவநிவாரண காணிக்கையையும் கொண்டுவந்திருந்தபடியாலும் அவர்கள் பாவம் அவர்களுக்கு மன்னிக்கப்படும். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","முழு இஸ்ரயேல் சமுதாயமும், அவர்களில் வாழும் அந்நியர்களும் மன்னிக்கப்படுவார்கள். ஏனெனில், எல்லா மக்களும் தற்செயலாக செய்யப்பட்ட குற்றத்திலேயே சம்பந்தப்பட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘ஆனால் ஒருவன் மட்டும் தற்செயலாகப் பாவம்செய்தால், பாவநிவாரண காணிக்கையாக அவன் ஒரு வயதுடைய பெண் வெள்ளாட்டுக்குட்டியைக் கொண்டுவர வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","ஆசாரியன், தற்செயலாகப் பாவம் செய்ததினால் தவறுசெய்த ஒருவனுக்காக, யெகோவாவுக்கு முன்பாகப் பாவநிவிர்த்தி செய்யவேண்டும். அவனுக்காகப் பாவநிவிர்த்தி செய்யப்பட்டபின் அவன் மன்னிக்கப்படுவான். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","ஊரில் பிறந்த இஸ்ரயேலனோ அல்லது அந்நியனோ தற்செயலாகப் பாவம் செய்கிற எவனுக்கும் இந்த ஒரேவிதமான சட்டத்தின்படியே செய்யப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘ஆனால் ஊரில் பிறந்தவனோ அல்லது அந்நியனோ யாராயிருந்தாலும், ஒருவன் அறிந்து துணிகரமாகப் பாவம்செய்தால் அவன் யெகோவாவை நிந்திக்கிறான். ஆகையால் அம்மனிதன் தன் மக்களிலிருந்து அகற்றப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","அவன் யெகோவாவின் வார்த்தையை அற்பமாய் எண்ணி, அவருடைய கட்டளைகளை மீறினபடியால், அம்மனிதன் நிச்சயமாக அகற்றப்படவேண்டும். அவன் குற்றம் அவன் மேலேயே இருக்கும் என்றார்.’ ” ");
INSERT INTO tamtcv_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","இஸ்ரயேலர் பாலைவனத்தில் இருக்கையில், ஓய்வுநாளில் ஒரு மனிதன் விறகு பொறுக்கிக்கொண்டிருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","அவன் விறகு பொறுக்குவதைக் கண்டவர்கள் அவனை மோசேயிடமும், ஆரோனிடமும், சபையார் அனைவரிடமும் கொண்டுவந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","அவனுக்கு என்ன செய்யப்பட வேண்டுமென்பது தெளிவாய் இல்லாதிருந்ததால், அவனைத் தடுப்புக் காவலில் வைத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","அப்பொழுது யெகோவா மோசேயிடம், “இந்த மனிதன் சாகவேண்டும். அவனை முகாமுக்கு வெளியே கொண்டுபோய் முழுசபையும் அவன்மேல் கல்லெறிய வேண்டும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","எனவே, கூடியிருந்த சபையார் அவனை முகாமுக்கு வெளியே கொண்டுவந்து யெகோவா மோசேக்குக் கட்டளையிட்டபடியே, அவனைக் கல்லெறிந்து கொன்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","பின்பு யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“நீ இஸ்ரயேலரிடம் பேசி, அவர்களுக்குச் சொல்லவேண்டியதாவது: ‘நீங்கள் தொங்கல்களைச் செய்து, அவை ஒவ்வொன்றையும் ஒவ்வொரு நீல நாடாவினால் கட்டி, உங்கள் உடைகளின் ஓரங்களில் தொங்கவிட வேண்டும். இதை தலைமுறைதோறும் நீங்கள் செய்யவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","நீங்கள் இந்தக் தொங்கல்களைப் பார்க்கும் போதெல்லாம் யெகோவாவின் கட்டளைகளை நினைவுபடுத்திக் கொள்வீர்கள். அதனால் நீங்கள் அவற்றிற்குக் கீழ்ப்படிவீர்கள். உங்களுடைய சொந்த இருதய ஆசைகளின்படியும், கண்களின் ஆசையின்படியும் போய் இறைவனை வழிபடாமல் உங்களை வேசித்தனத்திற்கு உள்ளாக்காதிருப்பீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","நீங்கள் எனது எல்லா கட்டளைகளுக்கும் கீழ்ப்படிய நினைவுகூர்ந்து உங்கள் இறைவனுக்கு அர்ப்பணிக்கப்பட்டு இருப்பீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","உங்கள் இறைவனாயிருக்கும்படி, எகிப்திலிருந்து உங்களைக் கொண்டுவந்த உங்கள் இறைவனாகிய யெகோவா நானே. நானே உங்கள் இறைவனாகிய யெகோவா’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","லேவி கோத்திரத்தைச் சேர்ந்த கோகாத்தின் பேரனும், இத்சேயாரின் மகனுமான கோராகு என்பவனும், ரூபன் கோத்திரத்தைச் சேர்ந்தவர்களான எலியாபின் மக்களான தாத்தான், அபிராம் என்பவர்களும், பேலேத்தின் மகன் ஓன் என்பவனும், ");
INSERT INTO tamtcv_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","இஸ்ரயேல் மக்களில் சபைக்குத் தலைவர்களும் சங்கத்திற்கு அழைக்கப்பட்டவர்களும் பிரபலமானவர்களுமாகிய 250 பேர்களோடும் கூட மோசேக்கு முன்பாக துணிகரமாய் எழும்பினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","அவர்கள் மோசேயையும் ஆரோனையும் எதிர்த்து ஒரு குழுவாகச் சேர்ந்துவந்து, அவர்களிடம், “நீங்கள் அளவுக்குமிஞ்சிப் போய்விட்டீர்கள். இந்த மக்கள் சமுதாயம் எல்லோரும், அதிலுள்ள ஒவ்வொருவரும் பரிசுத்தமாகவே இருக்கிறார்கள். யெகோவாவும் அவர்களுடன் இருக்கிறார். அப்படியிருக்க நீங்கள் யெகோவாவின் சபைக்கு மேலாக உங்களை ஏன் உயர்த்துகிறீர்கள்?” என்று கேட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","மோசே அதைக் கேட்டதும் முகங்குப்புற விழுந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","அப்பொழுது மோசே, கோராகிடமும் அவனைப் பின்பற்றி வந்த எல்லோரிடமும் யார் அவருடையவன்? யார் பரிசுத்தமானவன்? என்பதை நாளை காலையில் யெகோவா உங்களுக்குக் காண்பிப்பார். அப்படிப்பட்டவனை அவர் தம் அருகே வரப்பண்ணுவார். தாம் தெரிந்துகொள்ளும் மனிதனைத் தம் அருகே வரச்செய்வார். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","கோராகே! நீயும் உன்னைப் பின்பற்றும் எல்லோரும் செய்யவேண்டியதாவது, தூபகிண்ணங்களை எடுத்து, ");
INSERT INTO tamtcv_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","நாளைக்கு யெகோவா முன்னிலையில் அவற்றில் நெருப்புப் போட்டு, நறுமணத்தூளைப் போடுங்கள். அப்பொழுது யெகோவா தெரிந்துகொள்கிறவனே பரிசுத்தமானவனாய் இருப்பான். லேவியரே நீங்கள்தான் அளவுக்குமிஞ்சிப் போய்விட்டீர்கள்! என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","பின்பு மோசே கோராகிடம், “லேவியரே! நீங்கள் இப்பொழுது எனக்குச் செவிகொடுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","இஸ்ரயேலின் இறைவன் மற்ற இஸ்ரயேல் சமுதாயத்திலிருந்து உங்களை வேறுபிரித்து, யெகோவாவினுடைய இறைசமுக கூடாரத்தில் அவருடைய வேலையைச் செய்யவும், மக்கள் சமுதாயத்தின்முன் நிற்கவும், அவர்களுக்குப் பணிசெய்யவும், உங்களைத் தம் அருகே கொண்டுவந்தது உங்களுக்குப் போதாதோ? ");
INSERT INTO tamtcv_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","அவர் உங்களையும் உங்கள் உடன்சகோதரர் லேவியரையும் தம் அருகே கொண்டுவந்திருக்கிறார். ஆனால் இப்பொழுது நீங்களோ ஆசாரியப்பட்டத்தையும் எடுத்துக்கொள்ள முயற்சிக்கிறீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","நீங்களும் உங்களைப் பின்பற்றுகிறவர்களும் யெகோவாவுக்கு எதிராகவே கூட்டம் கூடியிருக்கிறீர்கள். ஆரோனுக்கு எதிராக நீங்கள் முறுமுறுப்பதற்கு அவன் யார்?” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","அதன்பின் மோசே, எலியாபின் பிள்ளைகளான தாத்தான், அபிராம் ஆகியோரை அழைத்தான். ஆனால் அவர்களோ, “நாங்கள் வரமாட்டோம்! ");
INSERT INTO tamtcv_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","பாலும் தேனும் ஓடுகிற ஒரு நாட்டிலிருந்து பாலைவனத்தில் சாகடிக்க நீ எங்களைக் கொண்டுவந்தது போதாதோ? இப்பொழுது நீ எங்கள்மேல் அதிகாரமும் செலுத்தப்பார்க்கிறாயோ? ");
INSERT INTO tamtcv_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","மேலும் நீ எங்களைப் பாலும் தேனும் ஓடுகிற நாட்டிற்குக் கொண்டுவரவுமில்லை, திராட்சைத் தோட்டங்களை உரிமையாகத் தரவுமில்லை. நீ இந்த மனிதரை கண்ணில்லாத குருடராக்க நினைத்தாயோ? நாங்கள் வரவேமாட்டோம்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","அப்பொழுது மோசே மிகவும் கோபமடைந்தான். அவன் யெகோவாவிடம், “நீர் அவர்களின் காணிக்கைகளை எற்றுக்கொள்ளவேண்டாம். நான் அவர்களிடமிருந்து கழுதையையேனும் எடுத்துக்கொள்ளவும் இல்லை. அவர்களில் ஒருவனுக்கும் அநியாயம் செய்ததுமில்லை” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","பின்பு மோசே கோராகிடம், “நீயும் உன்னைப் பின்பற்றுகிறவர்களும் நாளை யெகோவாவுக்கு முன்பாக வரவேண்டும். நீயும், அவர்களும், ஆரோனும் வரவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","ஒவ்வொருவரும் தன்தன் தூபகிண்ணத்தை எடுத்து, நறுமணத்தூளை அதற்குள்ளே போட்டு அதை யெகோவாவுக்கு முன்பாகக் கொண்டுவர வேண்டும். ஒவ்வொருவரும் ஆளுக்கு ஒவ்வொன்றாய் 250 தூபகிண்ணங்களுடன் வாருங்கள். நீயும், ஆரோனும், உங்கள் தூபகிண்ணங்களைக் கொண்டுவர வேண்டும்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","எனவே அவர்கள் ஒவ்வொருவரும் தங்களுடைய தூபகிண்ணங்களில் நெருப்பைப்போட்டு, அதில் நறுமணத்தூளையும் போட்டுக்கொண்டு சபைக்கூடார வாசலில் மோசேயுடனும், ஆரோனுடனும் நின்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","கோராகு அவர்களுக்கெதிராக சபைக்கூடார வாசலில் தன்னைப் பின்பற்றியவர்களைக் கூட்டிச் சேர்த்தபோது, யெகோவாவின் மகிமை சபையார் அனைவருக்கும் காணப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","அப்பொழுது யெகோவா மோசேயிடமும், ஆரோனிடமும், ");
INSERT INTO tamtcv_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“உடனடியாகவே நான் அவர்களை அழிக்கும்படி இந்தச் சபையாரிடமிருந்து உங்களை விலக்கிக்கொள்ளுங்கள்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","உடனே மோசேயும், ஆரோனும் முகங்குப்புற விழுந்து, “இறைவனே! எல்லா மனுக்குலத்தின் ஆவிகளுக்கும் இறைவனே! ஒருவன் மட்டும் பாவம்செய்கையில் நீர் சபையார் அனைவர்மேலும் கோபமாயிருப்பீரோ!” என்று கதறினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","அப்பொழுது யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“நீங்கள் கோராகு, தாத்தான், ‘அபிராம் ஆகியோரின் கூடாரங்களைவிட்டு அகன்றுபோங்கள் என்று நீ சபையாருக்குச் சொல்’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","மோசே எழுந்து தாத்தான், அபிராம் ஆகியோரின் கூடாரத்திற்கு விரைந்து போனான். அவனைத் தொடர்ந்து இஸ்ரயேலின் சபைத்தலைவர்களும் போனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","அவன் சபையாரைப் பார்த்து, “கொடுமையான இந்த மனிதர்களின் கூடாரங்களைவிட்டு அகன்றுபோங்கள். அவர்களுக்குரிய எதையும் தொடவேண்டாம். மீறினால் அவர்களுடைய பாவங்களினால் அவர்களுக்கு வரும் தண்டனையில் நீங்களும் அள்ளுண்டு போவீர்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","எனவே அவர்கள் கோராகு, தாத்தான், அபிராம் ஆகியோரின் கூடாரங்களைவிட்டு அகன்றுபோனார்கள். அப்பொழுது தாத்தானும், அபிராமும் வெளியே வந்து தங்கள் மனைவிகளுடனும், தங்கள் பிள்ளைகளுடனும், குழந்தைகளுடனும் அவர்களுடைய கூடாரங்களின் வாசலில் நின்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","மோசே அவர்களிடம், “இவற்றைச் செய்யும்படி யெகோவாவே என்னை அனுப்பியிருக்கிறார் என்பதையும், இது என்னுடைய சொந்த எண்ணம் அல்ல என்பதையும் இப்போது நடக்கப்போவதிலிருந்து நீங்கள் அறிந்துகொள்வீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","இந்த மனிதர் இயற்கை மரணத்தை அடைந்து, மனிதர்களுக்கு நேரிடுகிறதுபோல மட்டும் அனுபவிப்பார்களானால், யெகோவா என்னை அனுப்பவில்லை. ");
INSERT INTO tamtcv_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","ஆனால் யெகோவா முற்றிலும் புதுமையான ஒன்றைச் செய்து, பூமி தன் வாயைத் திறந்து, அம்மனிதர்களையும் அவர்களுடைய எல்லாவற்றையும் விழுங்கினால், அவர்கள் உயிரோடு பாதாளத்திற்குள் இறங்கினால், இந்த மனிதர் யெகோவாவை அவமதிப்பாய் நடத்தினார்கள் என்பதை நீங்கள் அறிந்துகொள்வீர்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","அவன் இவற்றைச் சொல்லி முடித்ததுமே அவர்களுக்குக் கீழே இருந்த நிலம் இரண்டாகப் பிளந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","பூமி தன் வாயைத் திறந்து அவர்களையும், அவர்களுடைய குடும்பங்களையும், கோராகின் ஆட்களையும், அவர்களின் உடைமைகளையும் விழுங்கிப்போட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","அவர்கள் தங்கள் உடைமைகள் அனைத்துடனும் உயிரோடு பாதாளத்திற்குள் போனார்கள். பூமி அவர்களின் மேலாக மூடிக்கொண்டது. அவர்கள் அழிந்து மக்கள் சமுதாயத்திலிருந்து இல்லாமற்போனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","அவர்கள் கூக்குரலைக் கேட்ட, சுற்றி நின்ற இஸ்ரயேலர் எல்லோரும், “பூமி எங்களையும் விழுங்கப்போகிறது” என்று சத்தமிட்டுக்கொண்டு விரைந்து ஓடினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","அத்துடன் யெகோவாவிடமிருந்து நெருப்பு புறப்பட்டுவந்து, தூபங்காட்டிக்கொண்டிருந்த அந்த 250 மனிதரையும் எரித்துப்போட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","பின்பு யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“நீ ஆரோனின் மகனான ஆசாரியன் எலெயாசாரிடம் சொல்லவேண்டியதாவது, எரிந்துகொண்டிருக்கும் நெருப்பில் இருந்து தூபகிண்ணங்களை வெளியே எடுத்து, அவற்றில் இருக்கும் தணல்களைச் சற்று தூரத்திற்கு அப்பால் சிதற எறிந்துவிடு. ஏனெனில், அத்தூபகிண்ணங்கள் பரிசுத்தமானவை. ");
INSERT INTO tamtcv_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","அவை தங்கள் உயிர்களையே இழக்கும்படி பாவம் செய்த அந்த மனிதர்களின் தூபகிண்ணங்களாயிருந்தும் அவை பரிசுத்தமானவை. அவை யெகோவா முன்பாக வைக்கப்பட்டதனால் பரிசுத்தமாயிருக்கின்றன. எனவே அவற்றைத் தகடுகளாக அடித்துப் பலிபீடத்தை மூடவேண்டும். அவை இஸ்ரயேலருக்கு ஒரு அடையாளமாக இருக்கட்டும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","அப்படியே எரியுண்ட மனிதர்களால் கொண்டுவரப்பட்டிருந்த வெண்கலத் தூபகிண்ணங்களை ஆசாரியன் எலெயாசார் சேர்த்தெடுத்தான். அவன் அதைப் பலிபீடத்தை மூடுவதற்கான தகடுகளாக அடித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","மோசேயின் மூலம் யெகோவா கட்டளையிட்டபடியே அவற்றைச் செய்தான். “ஆரோனின் சந்ததியில் வந்தவனைத்தவிர, வேறு எவனும் யெகோவாவுக்கு முன்பாகத் தூபங்காட்ட வரக்கூடாது. இதை மீறினால், அவன் கோராகையும், அவனைப் பின்பற்றியவர்களையும் போலாவான்” என்பதை இஸ்ரயேலருக்கு நினைவுபடுத்தவே இது செய்யப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","மறுநாள் இஸ்ரயேலரின் முழுசமூகமும் மோசேக்கும், ஆரோனுக்கும் விரோதமாகக் கூடியது. “யெகோவாவின் மக்களை நீங்கள் கொன்று விட்டீர்கள்” என்று அவர்கள் முறுமுறுத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","மோசேக்கும், ஆரோனுக்கும் விரோதமாகக் கூடிவந்த அந்த மக்கள்சபை, சபைக் கூடாரத்தை நோக்கித் திரும்பியபோது, திடீரென மேகம் சபைக் கூடாரத்தை மூடியது. யெகோவாவின் மகிமையும் அவர்களுக்குக் காணப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","அப்பொழுது மோசேயும், ஆரோனும் சபைக் கூடாரத்திற்குமுன் போனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","யெகோவா மோசேயிடம் சொன்னதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“நான் உடனே இவர்களை அழிக்கும்படி நீங்கள் இவர்களைவிட்டு விலகி அப்பால் போங்கள்” என்றார். ஆனால் அவர்களோ முகங்குப்புற விழுந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","அப்பொழுது மோசே ஆரோனிடம், “நீ உன் தூபகிண்ணத்தை எடுத்து, பலிபீடத்தின் நெருப்பையும், நறுமணத்தூளையும் அதில் போட்டு, சபையாருக்காகப் பாவநிவிர்த்தி செய்யும்படி அவர்களிடம் விரைந்து போ. யெகோவாவின் கோபம் வந்திருக்கிறது; கொள்ளைநோயும் தொடங்கிவிட்டது” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","மோசே சொன்னபடியே ஆரோன் செய்து, சபைக்குள் ஓடிப்போனான். அங்கே கொள்ளைநோய் மக்கள் மத்தியில் தொடங்கியிருந்தது. ஆனாலும் ஆரோன் தூபமிட்டு அவர்களுக்காகப் பாவநிவிர்த்தி செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","அவன் உயிரோடிருப்பவர்களுக்கும், இறந்தவர்களுக்கும் இடையிலே நின்றான். அப்பொழுது கொள்ளைநோய் நின்றுபோயிற்று. ");
INSERT INTO tamtcv_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","கோராகைப் பின்பற்றிச் செத்தவர்களைவிட 14,700 பேர் வாதையினால் செத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","கொள்ளைநோய் நின்றுவிட்டபடியால், ஆரோன் சபைக்கூடார வாசலில் இருந்து மோசேயிடம் திரும்பிவந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","யெகோவா மோசேயிடம் சொன்னதாவது, ");
INSERT INTO tamtcv_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“நீ இஸ்ரயேலரிடம் பேசி, அவர்கள் முற்பிதாக்களின் கோத்திரத் தலைவர்கள் ஒவ்வொருவரிடமிருந்தும் ஒவ்வொரு கோலாக, பன்னிரண்டு கோல்களைப் பெற்றுக்கொள். ஒவ்வொருவனுடைய கோலிலும் அவனவன் பெயரை எழுது. ");
INSERT INTO tamtcv_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","லேவி கோத்திரத்தின் கோலில் ஆரோனின் பெயரை எழுது. ஏனெனில், ஒவ்வொரு முற்பிதாக்களின் கோத்திரத் தலைவனுக்கும் கோல் இருக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","அவற்றை நான் உன்னைச் சந்திக்கும் இடமான சாட்சிப்பெட்டியின் முன்னால் சபைக் கூடாரத்தில் வை. ");
INSERT INTO tamtcv_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","அப்பொழுது நான் தெரிந்தெடுக்கும் மனிதனின் கோல் துளிர்க்கும். இவ்விதம் உனக்கெதிரான இஸ்ரயேலரின் தொடர்ச்சியான இந்த முறுமுறுப்பை நான் என்னை விட்டகற்றுவேன்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","அப்படியே மோசே, இஸ்ரயேலரிடம் சொன்னான். அவர்களின் தலைவர்கள் தங்கள் முற்பிதாக்களின் கோத்திர தலைவர்கள் ஒவ்வொருவருக்கும் ஒவ்வொன்றாக பன்னிரண்டு கோல்களைக் கொடுத்தார்கள். ஆரோனின் கோலும் அவற்றின் மத்தியில் இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","மோசே அந்தக் கோல்களை சாட்சிபகரும் கூடாரத்தில் யெகோவா முன்னிலையில் வைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","மறுநாள் மோசே சாட்சிபகரும் கூடாரத்திற்குள் வந்தபோது, அங்கே லேவி குடும்பத்தைப் பிரதிநிதித்துவப்படுத்திய ஆரோனின் கோல் துளிர்த்தது மட்டுமல்லாமல், மொட்டுவிட்டுப் பூத்து, வாதுமைக் காய்களையும் கொண்டிருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","பின்பு மோசே யெகோவா முன்னிருந்த கோல்களையெல்லாம் எடுத்து வெளியில் இருந்த இஸ்ரயேலர் அனைவரிடமும் கொண்டுவந்தான். அவர்கள் அவற்றைப் பார்த்து, ஒவ்வொருவரும் தன்தன் கோல்களை எடுத்துக்கொண்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","ஆனால் யெகோவா மோசேயிடம், “இக்கலகக்காரருக்கு ஒரு அடையாளமாக வைக்கப்படும்படி ஆரோனின் கோலைத் திரும்பவும் சாட்சிப்பெட்டியின் முன்னேவை. அது எனக்கு விரோதமான அவர்களின் முறுமுறுப்புக்கு ஒரு முடிவை உண்டாக்கும். அதனால் அவர்களும் சாகாதிருப்பார்கள்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","யெகோவா தனக்குக் கட்டளையிட்டபடியே மோசே செய்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","அப்பொழுது இஸ்ரயேலர் மோசேயிடம், “நாங்கள் செத்தோம்! நாங்கள் தொலைந்தோம்! நாங்கள் எல்லோருமே தொலைந்தோம்! ");
INSERT INTO tamtcv_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","யெகோவாவின் இறைசமுகக் கூடாரத்திற்கு அருகே வருபவன் எவனும் சாவான். நாங்கள் எல்லோரும் சாகப்போகிறோம்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","யெகோவா ஆரோனிடம் சொன்னதாவது, “நீயும், உன் மகன்களும் உன் தகப்பனின் குடும்பமும் பரிசுத்த இடத்திற்கு விரோதமாகச் செய்யப்படும் குற்றங்களுக்குரிய பொறுப்பை ஏற்றுக்கொள்ளவேண்டும். ஆசாரியத்துவப்பணியின் குற்றங்களுக்கான பொறுப்பை நீயும், உன் மகன்களும் மட்டுமே ஏற்றுக்கொள்ளவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","நீயும், உன் மகன்களும் சாட்சிபகரும் கூடாரத்திற்கு முன்பாகப் பணிசெய்யும்போது, உங்களுடன் சேர்ந்து உங்களுக்கு உதவிசெய்வதற்கு உங்கள் முற்பிதாக்களின் கோத்திரத்திலிருந்து, உங்கள் உடன் ஒத்த லேவியரை கொண்டுவர வேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","அவர்கள் கூடாரத்தின் கடமைகள் எல்லாவற்றையும் செய்வதில் உனக்கு உத்தரவாதமாயிருக்க வேண்டும். ஆனால் அவர்கள் பரிசுத்த இடத்தின் பணிப்பொருட்களுக்கோ, பலிபீடத்துக்கோ அருகில் போகக்கூடாது. மீறினால், அவர்களும் நீயும் சாவீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","அவர்கள் உன்னுடன் சேர்ந்து கூடாரத்தின் எல்லா வேலைகளையும் செய்து, சபைக் கூடாரத்தின் பராமரிப்புக்குப் பொறுப்பாயிருக்க வேண்டும். நீ இருக்கும் இடத்திற்கு எவனும் வரக்கூடாது. ");
INSERT INTO tamtcv_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“பரிசுத்த இடத்தினுடைய பலிபீடத்தினுடைய பராமரிப்புக்கு நீயே பொறுப்பாயிருக்க வேண்டும். அப்பொழுது என் கோபம் இஸ்ரயேலர்மேல் திரும்பவும் வராது. ");
INSERT INTO tamtcv_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","நான் நானே உன் உடன் ஒத்த லேவியரை இஸ்ரயேலருள் இருந்து தெரிந்தெடுத்து, உனக்குக் கொடையாகக் கொடுத்தேன். சபைக் கூடாரத்தின் வேலைகளைச் செய்வதற்காக அவர்கள் யெகோவாவுக்காக அர்ப்பணிக்கப்பட்டவர்களாக இருக்கிறார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","பலிபீடத்திலும், திரைக்குள்ளும் சம்பந்தப்பட்ட எல்லா வேலைகளிலும், நீயும் உன் மகன்களும் மட்டுமே ஆசாரியர்களாகப் பணிசெய்யலாம். நான் ஆசாரியப்பணியை உனக்கு ஒரு கொடையாகக் கொடுக்கிறேன். பரிசுத்த இடத்திற்குக் கிட்டவரும் வேறு எவனும் கொல்லப்படவேண்டும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","பின்னும் யெகோவா ஆரோனிடம் சொன்னதாவது, “எனக்குக் கொடுக்கப்படும் காணிக்கைகளுக்குப் பொறுப்பாக நானே உன்னை வைத்திருக்கிறேன். இஸ்ரயேலர் எனக்காகக் கொடுக்கும் பரிசுத்த காணிக்கைகள் எல்லாவற்றையும் உனக்கும், உன் மகன்களுக்கும், உங்கள் பங்காகவும், நிரந்தர பாகமாகவும் கொடுக்கிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","மகா பரிசுத்த காணிக்கைகளில் நெருப்பில் எரிக்கப்படாத அந்தப் பங்கு உனக்குச் சேரவேண்டும். தானிய காணிக்கை, பாவநிவாரண காணிக்கை, குற்றநிவாரண காணிக்கை எதுவானாலும் சரி, அவர்கள் மகா பரிசுத்தமான காணிக்கையாகக் கொண்டுவரும் எல்லா கொடைகளிலுமிருந்து எரிக்கப்படாத அப்பங்கு உனக்கும், உன் மகன்களுக்கும் சொந்தமாகும். ");
INSERT INTO tamtcv_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","அதை மகாபரிசுத்தமானதாக எண்ணி; அவற்றைச் சாப்பிடவேண்டும். ஒவ்வொரு ஆணும் அதைச் சாப்பிடவேண்டும். நீ அதைப் பரிசுத்தமானதாக மதிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“இஸ்ரயேலருடைய காணிக்கைகளின் கொடைகள் எல்லாவற்றிலுமிருந்து பிரித்து வைக்கப்படும் எதுவும் உங்களுக்கே உரியது. நான் இதை உனக்கும், உன் மகன்களுக்கும், உன் மகள்களுக்கும், உன் வழக்கமான பங்காகக் கொடுக்கிறேன். உன் வீட்டில் சம்பிரதாய முறைப்படி சுத்தமாயிருக்கிற எவனும் அதைச் சாப்பிடலாம். ");
INSERT INTO tamtcv_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“இஸ்ரயேலர் தங்கள் அறுவடையின் முதற்பலனாக யெகோவாவுக்குக் கொடுக்கும் சிறந்த ஒலிவ எண்ணெயையும், சிறந்த திராட்சைரசத்தையும், தானியத்தையும் நான் உனக்குக் கொடுத்தேன். ");
INSERT INTO tamtcv_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","அவர்கள் யெகோவாவுக்குக் கொண்டுவரும் நாட்டின் முதற்பலன் முழுவதும் உனக்குரியவை. உங்கள் குடும்பத்தில் சம்பிரதாய முறைப்படி சுத்தமாயிருக்கிற எவனும் அதைச் சாப்பிடலாம். ");
INSERT INTO tamtcv_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“இஸ்ரயேலின் யெகோவாவுக்காக அர்ப்பணிக்கப்பட்ட எல்லாமே உன்னுடையவை. ");
INSERT INTO tamtcv_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","யெகோவாவுக்காக கொண்டுவரப்படும் கர்ப்பத்தின் முதற்பேறான பிள்ளையும், மிருகமும் உன்னுடையவைகளே. ஆனால் ஒவ்வொரு முதற்பேறான மகனையும், அசுத்தமான மிருகங்களின் ஆண் தலையீற்றையும் நீ மீட்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","அவை ஒரு மாதமானவுடன், பரிசுத்த இடத்தின் சேக்கல் மதிப்பின்படி மீட்பின் கிரயமான ஐந்து சேக்கலைப் பெற்றுக்கொண்டு, நீ அவற்றை மீட்கவேண்டும். இருபது கேரா ஒரு சேக்கல். ");
INSERT INTO tamtcv_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“ஆனாலும், தலையீற்றான மாடுகள், செம்மறியாடு, வெள்ளாடு ஆகியவற்றை நீ மீட்கக்கூடாது. அவை பரிசுத்தமானவை. அவற்றின் இரத்தத்தைப் பலிபீடத்தில் தெளித்து அவற்றின் கொழுப்பை யெகோவாவுக்கு மகிழ்ச்சியூட்டும் நறுமணமாய், நெருப்பினால் செலுத்தப்படும் காணிக்கையாக எரித்துவிடு. ");
INSERT INTO tamtcv_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","அசைவாட்டும் காணிக்கையான நெஞ்சுப்பகுதியும், வலதுதொடையும் உன்னுடையவையாய் இருப்பதுபோல், அவற்றின் இறைச்சியும் உனக்கே உரியது. ");
INSERT INTO tamtcv_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","இஸ்ரயேலர் யெகோவாவுக்குக் கொண்டுவரும் பரிசுத்த காணிக்கைகளிலிருந்து பிரித்து எடுக்கும் எதையும் நான் உனக்கும், உன் மகன்களுக்கும், மகள்களுக்கும், உங்களுடைய நிரந்தர பாகமாகக் கொடுக்கிறேன். இது யெகோவாவுக்கு முன்பாக உனக்காகவும், உன் சந்ததியினருக்காகவும் உப்பினால் செய்யப்படும் ஒரு நிரந்தர உடன்படிக்கையாய் இருக்கும்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","பின்பு யெகோவா ஆரோனிடம் சொன்னதாவது, “உனக்கு அவர்கள் நாட்டில் உரிமைச்சொத்து இருக்காது. அவர்கள் மத்தியில் உனக்கு எந்தவித பங்கும் இருக்காது. இஸ்ரயேலர் மத்தியில் நானே உனது பங்கும், உரிமைச்சொத்துமாயிருக்கிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“லேவியர் சபைக் கூடாரத்தில் பணிசெய்கையில் அவர்கள் செய்யும் வேலைக்குக் கைமாறாக, இஸ்ரயேலிலுள்ள பத்தில் ஒன்றான காணிக்கைகளையெல்லாம் சொத்தாகக் கொடுக்கிறேன். ");
INSERT INTO tamtcv_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","இஸ்ரயேலர் இனிமேல் சபைக் கூடாரத்திற்கு அருகே போகக்கூடாது. மீறினால், தங்கள் பாவத்தின் விளைவுகளைத் தாங்களே அனுபவித்துச் சாவார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","சபைக் வேலைகளை லேவியர் மட்டுமே செய்யவேண்டும். அவ்வேலையில் ஏற்படும் குற்றங்களுக்கும் அவர்கள் பொறுப்பாளியாவார்கள். இது தலைமுறைதோறும் நிரந்தர நியமமாய் இருக்கும். இஸ்ரயேலருக்குள்ளும் லேவியர் உரிமைச்சொத்து எதையும் பெற்றுக்கொள்ள முடியாது. ");
INSERT INTO tamtcv_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","ஏனெனில், இஸ்ரயேலர் யெகோவாவுக்குக் காணிக்கையாகக் கொண்டுவரும் பத்தில் ஒரு பங்கை, நான் லேவியரின் உரிமைச்சொத்தாக அவர்களுக்குக் கொடுப்பேன். அதனால்தான் நான் ‘இஸ்ரயேலர் மத்தியில் அவர்களுக்கு நிரந்தரமான உரிமைச்சொத்து இருக்காது என்று அவர்களைக் குறித்துச் சொன்னேன்’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","பின்பு யெகோவா மோசேயிடம், ");
INSERT INTO tamtcv_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“நீ லேவியருடன் பேசி, அவர்களுக்குச் சொல்லவேண்டியதாவது: ‘நான் உங்களுக்கு உரிமைச்சொத்தாகக் கொடுக்கும் பத்தில் ஒரு பங்கை நீங்கள் இஸ்ரயேலரிடமிருந்து பெறும்போதெல்லாம் அந்த பத்தில் ஒரு பங்கில், பத்தில் ஒரு பங்கை, யெகோவாவுக்குக் காணிக்கையாகக் கொடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","நீங்கள் கொடுக்கும் காணிக்கை சூடடிக்கும் களத்தில் பெறப்படும் தானியம்போல் அல்லது திராட்சை ஆலையிலிருந்து வரும் திராட்சை இரசம்போல் உங்களுக்குக் கருதப்படும். ");
INSERT INTO tamtcv_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","அவ்வாறு நீங்களும், இஸ்ரயேலரிடமிருந்து பெற்றுக்கொள்ளும் எல்லா பத்தில் ஒரு பங்கிலுமிருந்தும் யெகோவாவுக்கு ஒரு காணிக்கையைக் கொடுப்பீர்கள். அந்த பத்தில் ஒரு பங்கிலிருந்து நீங்கள் யெகோவாவின் பங்கை ஆசாரியன் ஆரோனுக்குக் கொடுக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","நீங்கள் உங்களுக்குக் கொடுக்கப்படும் எல்லாவற்றிலுமிருந்தும் மிகத் திறமையானதையும், மிகப் பரிசுத்தமானதையும் யெகோவாவின் பாகமாகக் கொடுக்கவேண்டும்.’ ");
INSERT INTO tamtcv_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“நீ லேவியருக்குச் சொல்லவேண்டியதாவது: ‘நீங்கள் திறமையான பங்கைக் கொடுக்கும்போது, அது சூடடிக்கும் களத்திலுள்ள விளைபொருள்போல் அல்லது திராட்சை ஆலையில் இருந்து பெறப்படும் திராட்சை இரசம்போல் உங்களுக்கு கருதப்படும். ");
INSERT INTO tamtcv_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","அவற்றின் மிகுதியை நீங்களும், உங்கள் குடும்பமும் எந்த இடத்திலும் சாப்பிடலாம். ஏனெனில் அவை சபைக் கூடாரத்தில் உங்கள் பணிக்காக கொடுக்கப்படும் கூலியாகும். ");
INSERT INTO tamtcv_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","இவ்வாறு மிகத் திறமையானவற்றை நீங்கள் கொடுப்பதால் காணிக்கைபற்றிய விஷயத்தில் குற்றமற்றவர்களாயிருப்பீர்கள். அப்பொழுது நீங்கள் இஸ்ரயேலரின் பரிசுத்த காணிக்கையை அசுத்தப்படுத்தவுமாட்டீர்கள்; நீங்கள் சாகவுமாட்டீர்கள் என்று சொல்’ ” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","பின்பு யெகோவா மோசேயிடமும் ஆரோனிடமும் சொன்னதாவது: ");
INSERT INTO tamtcv_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“யெகோவா கட்டளையிட்டிருக்கிற சட்டத்தின் நியமம் இதுவே: குறைபாடற்றதும், ஊனமற்றதும், ஒருபோதும் நுகம் சுமக்காததுமான சிவப்புநிற கன்னிப்பசுவைக் கொண்டுவரும்படி இஸ்ரயேலரிடம் சொல்லுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","அதை ஆசாரியன் எலெயாசாரிடம் கொடுங்கள். அது முகாமுக்கு வெளியே கொண்டுபோகப்பட்டு, அவன் முன்னிலையில் கொல்லப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","பின்பு ஆசாரியன் எலெயாசார் அதன் இரத்தத்தைத் தன் விரலினால் தொட்டு, அதை சபைக் கூடாரத்திற்கு முன்பக்கத்தை நோக்கி ஏழுமுறை தெளிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","பின்பு, ஆசாரியன் பார்த்துக்கொண்டிருக்கையில் அதன் தோல், இறைச்சி, இரத்தம், குடல் உட்பட அந்தக் கன்னிப்பசு எரிக்கப்படவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","ஆசாரியன் கேதுருமரக்கட்டை, ஈசோப்புக்குழை, கருஞ்சிவப்புக் கம்பளிநூல் ஆகியவற்றில் கொஞ்சத்தை எடுத்து, எரிந்துகொண்டிருக்கும் கன்னிப்பசுவின்மேல் போடவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","அதன்பின், ஆசாரியன் தன் உடைகளைக் கழுவி முழுகவேண்டும். பின்பு அவன் முகாமுக்குள் போகலாம். ஆனாலும் அவன் மாலைவரை சம்பிரதாய முறைப்படி அசுத்தமாயிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","அந்தப் பசுவை எரித்த மனிதனும் தன் உடைகளைக் கழுவி முழுகவேண்டும். அவனும் மாலைவரை அசுத்தமாயிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“சுத்தமாயிருக்கும் ஒரு மனிதன் அந்தப் பசுவின் சாம்பலைச் சேர்த்து அள்ளி, முகாமுக்கு வெளியே சம்பிரதாய முறைப்படி சுத்தமான ஒரு இடத்தில் கொட்டவேண்டும். இஸ்ரயேல் சமுதாயத்தினர் சுத்திகரிக்கும் தண்ணீரில் உபயோகிப்பதற்காக அந்தச் சாம்பலை வைத்துக்கொள்ள வேண்டும். பாவத்திலிருந்து சுத்திகரிப்பதற்கு அது பயன்படுத்தப்படும். ");
INSERT INTO tamtcv_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","அந்தப் பசுவின் சாம்பலை அள்ளும் மனிதனும் தன் உடைகளைக் கழுவவேண்டும். அவன் மாலைவரை அசுத்தமுள்ளவனாயிருப்பான். இது இஸ்ரயேலருக்கும், அவர்களுடன் வாழும் அந்நியருக்கும் நிரந்தர நியமமாய் இருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“ஒரு மனிதனின் சடலத்தைத் தொடுகிற எவனும் ஏழுநாட்களுக்கு அசுத்தமுள்ளவனாய் இருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","அம்மனிதன் மூன்றாம் நாளும், ஏழாம் நாளும் அந்த தண்ணீரினால் தன்னைச் சுத்திகரிக்கவேண்டும். அப்பொழுது அவன் சுத்தமாவான். ஆனால் அவன் மூன்றாம் நாளும், ஏழாம் நாளும் தன்னைச் சுத்திகரியாவிட்டால் அவன் சுத்தமாகமாட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","ஒரு மனிதனின் சடலத்தைத் தொடுகிற எவனும் தன்னைச் சுத்திகரிக்கத் தவறினால், அவன் யெகோவாவின் இறைசமுகக் கூடாரத்தை அசுத்தப்படுத்துகிறான். அவன் இஸ்ரயேலில் இருந்து அகற்றப்படவேண்டும். அந்தச் சுத்திகரிப்பின் தண்ணீர் அவன்மேல் தெளிக்கப்படாதபடியால், அவன் அசுத்தமாய் இருக்கிறான். அவனுடைய அசுத்தம் அவன் மேலேயே இருக்கிறது. ");
INSERT INTO tamtcv_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“கூடாரம் ஒன்றில் ஒரு மனிதன் இறந்தால், அதற்குரிய சட்டம் இதுவே: கூடாரத்திற்குள் வரும் எவனும், கூடாரத்திற்குள் இருப்பவன் எவனும் ஏழுநாட்களுக்கு அசுத்தமாயிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","மூடியினால் பூட்டப்படாமல் திறந்தபடியே இருக்கும் கொள்கலன்கள் யாவும் அசுத்தமாயிருக்கும். ");
INSERT INTO tamtcv_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“வெளியில் இருப்பவன் யாராவது, வாளினால் வெட்டுண்டு இறந்தவனையோ அல்லது இயற்கையாக இறந்தவனையோ தொட்டாலும் அல்லது மனித எலும்பையோ, கல்லறையையோ தொட்டாலும் அவன் ஏழுநாட்களுக்கு அசுத்தமுள்ளவனாயிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“அசுத்தமான மனிதனுக்காக, எரிக்கப்பட்ட சுத்திகரிப்பின் காணிக்கையிலிருந்து கிடைத்த சாம்பலில் கொஞ்சத்தை எடுத்து, ஜாடியில் போட்டு, அதற்குள்ளே சுத்தமான தண்ணீரை ஊற்றவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","பின்பு சம்பிரதாயப்படி சுத்தமாயிருக்கும் ஒருவன் கொஞ்சம் ஈசோப்புக் குழையை எடுத்து, அந்த தண்ணீரில் தோய்த்து, அதை கூடாரத்திலும், அங்குள்ள பணிப்பொருட்களின்மேலும், அங்குள்ள மக்கள்மேலும் தெளிக்கவேண்டும். அப்படியே மனித எலும்பையோ, கல்லறையையோ, கொல்லப்பட்டவனையோ அல்லது இயற்கையாக இறந்தவனையோ யாராவது தொட்டிருந்தால் அவன் மேலும் அத்தண்ணீரை தெளிக்கவேண்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","இவ்வாறு சுத்தமாயிருக்கிறவன், சுத்தமில்லாதிருக்கிறவன்மேல் மூன்றாம் நாளும், ஏழாம் நாளும் அந்த தண்ணீரைத் தெளிக்கவேண்டும். ஏழாம்நாளில் அவன் இவனைச் சுத்திகரிக்கவேண்டும். சுத்திகரிக்கப்படுபவன் தன் உடைகளைக் கழுவி தண்ணீரில் முழுகவேண்டும். அன்று மாலை அவன் சுத்தமாவான். ");
INSERT INTO tamtcv_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","ஆனால் அசுத்தமான ஒருவன் தன்னைச் சுத்திகரியாமல்விட்டால், அவன் இஸ்ரயேலர் மத்தியிலிருந்து அகற்றப்படவேண்டும். ஏனெனில் அவன் யெகோவாவின் பரிசுத்த இடத்தை அசுத்தப்படுத்தினான். அந்த சுத்திகரிப்பின் தண்ணீர் அவன்மேல் தெளிக்கப்படாதபடியால், அவன் அசுத்தமுள்ளவனாயிருக்கிறான். ");
INSERT INTO tamtcv_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","இது அவர்களுக்கு ஒரு நித்திய நியமமாயிருக்கிறது. “சுத்திகரிப்புத் தண்ணீரைத் தெளிக்கிற மனிதனும், தன் உடைகளைக் கழுவவேண்டும். அந்த தண்ணீரைத் தொடுகிற எவனும் அன்று மாலைவரை அசுத்தமாயிருப்பான். ");
INSERT INTO tamtcv_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","அசுத்தமுள்ளவன் எவற்றைத் தொடுவானோ அவையும் அசுத்தமாயிருக்கும், அவற்றைத் தொடும் மனிதனும் மாலைவரை அசுத்தமுள்ளவனாய் இருப்பான்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","முதலாம் மாதத்தில் முழு இஸ்ரயேல் சமுதாயமும் சீன் பாலைவனத்தை அடைந்தது. அவர்கள் காதேசில் தங்கினார்கள். அங்கே மிரியாம் இறந்து, அடக்கம்பண்ணப்பட்டாள். ");
INSERT INTO tamtcv_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","இஸ்ரயேல் சமுதாயத்தினருக்கு அங்கே தண்ணீர் கிடைக்கவில்லை. எனவே மக்கள் மோசேக்கும், ஆரோனுக்கும் விரோதமாக ஒன்றுகூடினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","அவர்கள் மோசேயுடன் வாக்குவாதம்பண்ணிச் சொன்னதாவது, “எங்கள் சகோதரர்கள் யெகோவா முன்பாக செத்து விழுந்தபோது நாங்களும் செத்திருக்கலாமே! ");
INSERT INTO tamtcv_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","நாங்களும், எங்கள் கால்நடைகளும் சாகும்படியாக நீ ஏன் யெகோவாவின் மக்களை இந்தப் பாலைவனத்திற்குக் கொண்டுவந்தாய்? ");
INSERT INTO tamtcv_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","நீ ஏன் எங்களை எகிப்திலிருந்து வெளியே, இந்த அவலம் நிறைந்த இடத்திற்குக் கொண்டுவந்தாய்? இங்கே தானியமோ, அத்திப்பழங்களோ, திராட்சைக்கொடிகளோ, மாதுளம்பழங்களோ இல்லை. குடிப்பதற்குத் தண்ணீரும் இல்லை” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","அதைக்கேட்ட மோசேயும், ஆரோனும் மக்கள் கூட்டத்தைவிட்டு சபைக் கூடாரவாசலுக்கு வந்து முகங்குப்புற விழுந்தார்கள், அவ்வேளையில் யெகோவாவினுடைய மகிமை அவர்கள்முன் தோன்றியது. ");
INSERT INTO tamtcv_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","யெகோவா மோசேயிடம் சொன்னதாவது, ");
INSERT INTO tamtcv_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“நீ கோலை எடுத்துக்கொள். நீயும், உன் சகோதரன் ஆரோனும் மக்கள் சபையை ஒன்றுகூட்டுங்கள். அவர்கள் கண்களுக்கு முன்பாக நீ அக்கற்பாறையைப் பார்த்து பேசு. அதிலிருந்து அதன் தண்ணீர் பொங்கிவரும். நீ கற்பாறையிலிருந்து இந்த மக்கள் சமுதாயத்திற்குத் தண்ணீரை வரப்பண்ணுவாய். அவர்களும் அவர்களுடைய மிருகங்களும் குடிப்பார்கள்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","யெகோவா தனக்குக் கட்டளையிட்டபடியே, மோசே அவர் முன்னிருந்த கோலை எடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","அவனும், ஆரோனும் கற்பாறைக்கு முன்பாக மக்கள் சபையை ஒன்றுகூட்டினார்கள். மோசே அவர்களிடம், “கலகக்காரரே, கேளுங்கள், இந்தக் கற்பாறையிலிருந்து நாங்கள் உங்களுக்குத் தண்ணீரை வரப்பண்ணவேண்டுமோ?” என்று கேட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","பின்பு மோசே தன் கையை உயர்த்தி, தனது கோலினால் கற்பாறையை இரண்டுமுறை அடித்தான். அப்பொழுது தண்ணீர் பீறிட்டுப் பாய்ந்து வந்தது. மக்கள் கூட்டத்தினர் தாங்களும் குடித்து, தங்கள் வளர்ப்பு மிருகங்களுக்கும் குடிக்கக் கொடுத்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","ஆனால் யெகோவா மோசேயிடமும், ஆரோனிடமும் சொன்னதாவது, “நீங்கள் என்னைக் கனம்பண்ணும் அளவுக்கு என்னில் நம்பிக்கை வைக்கவில்லை. இஸ்ரயேலருக்கு முன்பாக என்னைப் பரிசுத்த இறைவனாகக் கனம்பண்ணவில்லை. எனவே நான் இந்த சமுதாயத்திற்குக் கொடுக்கும் நாட்டிற்கு நீங்கள் அவர்களைக் கொண்டுபோகமாட்டீர்கள்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","அவ்விடத்தில் இஸ்ரயேலர் யெகோவாவுடன் வாக்குவாதப்பட்டதாலும், அவர் தம்மை பரிசுத்தராகக் காண்பித்ததாலும், அது மேரிபாவின் தண்ணீர் எனப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","பின்பு மோசே காதேசிலிருந்து தூதுவர்களை ஏதோம் அரசனிடம் அனுப்பி: “உமது சகோதரனான இஸ்ரயேல் சொல்வதாவது, எங்களுக்கு நேரிட்ட கஷ்டங்களையெல்லாம் நீர் அறிந்திருக்கிறீர். ");
INSERT INTO tamtcv_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","எங்கள் முற்பிதாக்கள் எகிப்திற்குப் போனார்கள். நாங்களும் பல ஆண்டுகள் அங்கே குடியிருந்தோம். எகிப்தியர் எங்களையும், எங்கள் முற்பிதாக்களையும் துன்புறுத்தினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","ஆனாலும் நாங்கள் யெகோவாவிடம் அழுதபோது அவர் எங்கள் அழுகையைக் கேட்டு, ஒரு தூதனை அனுப்பி எங்களை எகிப்திலிருந்து வெளியே கொண்டுவந்தார். “இப்போது நாங்கள் உமது பிரதேசத்தின் எல்லையிலுள்ள காதேஸ் என்னும் பட்டணத்தில் இருக்கிறோம். ");
INSERT INTO tamtcv_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","தயவுசெய்து உமது நாட்டின் வழியாகக் கடந்துசெல்ல எங்களை அனுமதியும். நாங்கள் எந்தவொரு வயலின் வழியாகவோ, திராட்சைத் தோட்டத்தின் வழியாகவோ செல்லமாட்டோம். எந்தவொரு கிணற்றிலிருந்து தண்ணீர் குடிக்கவுமாட்டோம்; நாங்கள் அரசனின் பெருந்தெருவழியாகவே போவோம். உமது நாட்டைக் கடந்து முடிக்கும்வரை வலதுபக்கமோ, இடது பக்கமோ திரும்பமாட்டோம் என்று சொல்லுங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","அவ்வாறே அவர்கள் சொன்னபோது, ஏதோம் பதிலாக, “நீங்கள் நாட்டின் வழியாகக் கடந்துபோக முடியாது. அப்படிப்போக முயற்சித்தால், நாங்கள் அணிவகுத்து வந்து உங்களை வாளினால் தாக்குவோம்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","திரும்பவும் இஸ்ரயேலர் அவனிடம்: “நாங்கள் உமது பிரதான வீதியிலே மாத்திரம் போவோம். நாங்களோ, எங்கள் வளர்ப்பு மிருகங்களோ உங்கள் தண்ணீரைக் குடித்தால் அதற்குரிய பணத்தை நாங்கள் தருவோம். நாங்கள் எங்கள் கால்களால் நடந்து உமது நாட்டைக் கடந்துசெல்ல மட்டும் விரும்புகிறோமே தவிர வேறோன்றும் இல்லை” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","அதற்கு அவன்: “நீங்கள் என் நாட்டின் வழியாகக் கடந்துசெல்லவே முடியாது” என்று பதிலளித்தான். பின்பு ஏதோம் அவர்களுக்கு எதிராகப் பெரிதும் வலிமையுமான படையுடன் புறப்பட்டு வந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","ஏதோமியர் இஸ்ரயேலரைத் தங்கள் பிரதேசத்தின் வழியாகக் கடந்துபோகவிட மறுத்தபடியால், இஸ்ரயேலர் அங்கிருந்து திரும்பிப் போனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","முழு இஸ்ரயேல் சமுதாயமும் காதேஸை விட்டுப் புறப்பட்டு ஓர் என்னும் மலைக்கு வந்து சேர்ந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","ஏதோமின் எல்லைக்கு அருகிலுள்ள ஓர் என்னும் மலையிலே யெகோவா மோசேக்கும், ஆரோனுக்கும் சொன்னதாவது, ");
INSERT INTO tamtcv_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“ஆரோன் தன் முன்னோர்களுடன் சேர்க்கப்படப்போகிறான். நான் இஸ்ரயேலருக்குக் கொடுக்கப்போகும் நாட்டிற்குள் அவன் போவதில்லை. ஏனெனில் நீங்கள் இருவரும் மேரிபாவின் தண்ணீரண்டையில் எனது கட்டளைக்கு எதிராகக் கலகம் பண்ணினீர்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","ஆகையால் நீ ஆரோனையும், அவன் மகன் எலெயாசாரையும் கூட்டிக்கொண்டு ஓர் மலைக்கு வா. ");
INSERT INTO tamtcv_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","அங்கே ஆரோனின் உடைகளைக் கழற்றி அவன் மகன் எலெயாசாருக்கு உடுத்து. ஏனெனில் ஆரோன் அங்கே இறந்து தன் முன்னோர்களுடன் சேர்க்கப்படுவான்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","யெகோவா தனக்குக் கட்டளையிட்டபடியே மோசே செய்தான். மக்கள் கூட்டம் முழுவதும் பார்த்துக்கொண்டிருக்கையில் அவர்கள் ஓர் என்னும் மலைக்குப் போனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","அங்கே மோசே ஆரோனின் உடைகளைக் கழற்றி, அவன் மகன் எலெயாசாருக்கு உடுத்தினான். அங்கே அந்த மலை உச்சியில் ஆரோன் இறந்தான். மோசேயும், எலெயாசாரும் கீழே இறங்கிவந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","முழு இஸ்ரயேல் சமுதாயமும் ஆரோன் இறந்துவிட்டதை அறிந்தபோது, அவனுக்காக அழுது முப்பது நாட்கள் துக்கங்கொண்டாடினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","தெற்கு பகுதியில் வாழ்ந்த கானானியனான ஆராத் பட்டணத்து அரசன், இஸ்ரயேலர் அத்தரீமுக்குப் போகிறவழியாய் வருகிறதைக் கேள்விப்பட்டான். உடனே அவன் இஸ்ரயேலரைத் தாக்கி சிலரைச் சிறைப்பிடித்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","அப்பொழுது இஸ்ரயேலர் யெகோவாவிடம்: “நீர் இந்த மக்களை விடுவித்து எங்கள் கையில் கொடுத்தால், நாங்கள் அவர்கள் பட்டணத்தை முழுவதும் அழித்துப்போடுவோம்” என்று நேர்த்திக்கடன் செய்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","யெகோவா இஸ்ரயேலரின் வேண்டுதலுக்குச் செவிகொடுத்து, கானானியரை அவர்களிடம் ஒப்படைத்தார். அப்பொழுது இஸ்ரயேலர் அவர்களையும், அவர்கள் பட்டணங்களையும் முழுவதும் அழித்தார்கள். அதனால் அவ்விடம், ஓர்மா என்று அழைக்கப்பட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","அவர்கள் ஓர் என்னும் மலையிலிருந்து செங்கடலுக்குப் போகும் வழியாக ஏதோமைச் சுற்றிப்போகும்படி பயணம் செய்தார்கள். ஆனால் மக்களோ வழியில் பொறுமையை இழந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","அவர்கள் இறைவனுக்கும், மோசேக்கும் விரோதமாகப் பேசி, “பாலைவனத்தில் செத்துப்போகும்படி எங்களை எகிப்திலிருந்து வெளியே ஏன் கொண்டுவந்தீர்கள்? இங்கே அப்பமும் இல்லை, தண்ணீரும் இல்லை. இந்த கேவலமான உணவை நாங்கள் அருவருக்கிறோம்” என்றார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","அப்பொழுது யெகோவா அவர்களுக்குள்ளே விஷப்பாம்புகளை அனுப்பினார். அவை மக்களைக் கடித்ததினால் இஸ்ரயேலரில் பலர் இறந்தார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","எனவே மக்கள் மோசேயிடம் வந்து, “நாங்கள் யெகோவாவுக்கும், உமக்கும் விரோதமாய்ப் பேசியதனால் பாவம்செய்தோம். இந்தப் பாம்புகளை எங்களைவிட்டு அகற்றும்படி யெகோவாவிடம் மன்றாடும்” என்றார்கள். அப்பொழுது மோசே மக்களுக்காக மன்றாடினான். ");
INSERT INTO tamtcv_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","யெகோவா மோசேயிடம், “நீ ஒரு பாம்பைச் செய்து, ஒரு கம்பத்தின்மேல் வைத்து உயர்த்திவை. கடிக்கப்பட்டவன் எவனும் அதைப்பார்த்தால் பிழைப்பான்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","அவ்வாறே மோசே வெண்கலத்தினால் ஒரு பாம்பைச் செய்து, அதை ஒரு கம்பத்தின்மேல் உயர்த்திவைத்தான். பாம்பினால் கடிக்கப்பட்ட எவனும் வெண்கலப்பாம்பை நோக்கிப் பார்த்தபோது பிழைத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","இஸ்ரயேலர் தொடர்ந்து பயணம்பண்ணி ஒபோத்தில் முகாமிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","பின் ஒபோத்திலிருந்து புறப்பட்டு, சூரிய உதயதிசையில் மோவாபிற்கு எதிர்ப்புறமாயுள்ள பாலைவனத்தில் அபாரீம் மேடுகளில் முகாமிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","அங்கேயிருந்து அவர்கள் புறப்பட்டு சாரேத் பள்ளத்தாக்கில் முகாமிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","அவர்கள் அங்கிருந்து புறப்பட்டு பாலைவனத்தில் உள்ளதும், எமோரியரின் பிரதேசத்துக்குள் நீண்டு செல்கிறதுமான அர்னோன் ஆற்றின் அருகே முகாமிட்டார்கள். மோவாபுக்கும், எமோரியருக்கும் இடையில் மோவாபின் எல்லையாக அர்னோன் ஆறு ஓடுகிறது. ");
INSERT INTO tamtcv_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","அதனால்தான் யெகோவாவினுடைய யுத்தங்களின் புத்தகத்தில் எழுதியிருக்கிறதாவது: “சூப்பாவிலுள்ள வாகேபும் அர்னோனின் பள்ளத்தாக்கும் ");
INSERT INTO tamtcv_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ஆர் என்னும் பட்டணம்வரை சென்று மோவாபின் எல்லை ஓரமாக சாய்ந்திருக்கும் பள்ளத்தாக்கின் மலைச்சரிவும்.” ");
INSERT INTO tamtcv_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","அங்கிருந்து தொடர்ந்து அவர்கள் பேயேருக்குப் போனார்கள். “மக்களைக் கூடிவரச்செய்; அவர்களுக்கு நான் தண்ணீர் கொடுப்பேன்” என்று யெகோவா மோசேக்குச் சொன்ன கிணறு அங்குதான் இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","அப்பொழுது இஸ்ரயேலர் பாடிய பாடலாவது: “கிணற்றுத் தண்ணீரே, பொங்கி வா! அதைக் குறித்துப் பாடுங்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","பிரபுக்கள் வெட்டிய கிணற்றைக் குறித்தும், மக்களில் உயர்குடிப்பிறந்தோர் செங்கோல்களினாலும், கோல்களினாலும் தோண்டிய கிணற்றைக்குறித்துப் பாடுங்கள்.” அதன்பின் அவர்கள் பாலைவனத்திலிருந்து மத்தானாவுக்குப் போனார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","மத்தானாவிலிருந்து, நகாலியேலுக்கும், நகாலியேலிலிருந்து பாமோத்திற்கும், ");
INSERT INTO tamtcv_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","பாமோத்திலிருந்து மோவாபின் பள்ளத்தாக்கிற்கும் போனார்கள். அங்கே பாழ் நிலத்திற்கு எதிர்த்தாற்போல், பிஸ்காவின் உச்சி இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","பின்பு இஸ்ரயேலர் எமோரியரின் அரசன் சீகோனிடத்தில் தூதுவர்களை அனுப்பி, ");
INSERT INTO tamtcv_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“உங்களுடைய நாட்டை கடந்துசெல்ல எங்களை அனுமதியுங்கள். நாங்கள் எந்த வயல் வழியாகவோ, திராட்சைத் தோட்டத்தின் வழியாகவோ செல்லமாட்டோம்; எந்தவொரு கிணற்றிலிருந்தும் தண்ணீர்கூட குடிக்கமாட்டோம். நாங்கள் நாட்டைக் கடக்கும்வரைக்கும் அரசபாதையின் வழியாகவே செல்வோம்” என்று சொல்லச் சொன்னார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","ஆனால் சீகோன் தன் பிரதேசத்தின் வழியாக இஸ்ரயேலரைப் போகவிடாதிருந்தான். அவன் தன் முழு படையையும் திரட்டிக்கொண்டு இஸ்ரயேலருக்கு விரோதமாகப் பாலைவனத்திற்கு அணிவகுத்துச் சென்றான். அவன் யாகாசை அடைந்தபோது இஸ்ரயேலருடன் சண்டையிட்டான். ");
INSERT INTO tamtcv_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","ஆனால் இஸ்ரயேலரோ அவனை வாளுக்கு இரையாக்கி அர்னோன் முதல் யாப்போக்கு வரையுள்ள அவனுடைய நாட்டைக் கைப்பற்றிக்கொண்டார்கள். ஆனால் அம்மோனியரின் எல்லைவரை மட்டுமே கைப்பற்றினார்கள். ஏனெனில் அவர்களுடைய எல்லை அரண் செய்யப்பட்டு இருந்தது. ");
INSERT INTO tamtcv_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","இஸ்ரயேலர் எமோரியரின் எல்லா பட்டணங்களையும் கைப்பற்றி அவற்றில் குடியேறினார்கள். எஸ்போனும், அதைச் சுற்றியுள்ள எல்லா குடியிருப்புகளும் இவற்றுள் அடங்கும். ");
INSERT INTO tamtcv_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","எஸ்போன் எமோரிய அரசன் சீகோனின் பட்டணமாயிருந்தது. அவன் முன்னிருந்த மோவாபின் அரசனுடன் சண்டையிட்டு அர்னோன் வரையிலிருந்த அவனுடைய நாட்டை அவனிடமிருந்து எடுத்திருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","அதினாலே அவர்களுடைய கவிஞர்கள்: “எஸ்போனுக்கு வாருங்கள், அது திரும்பவும் கட்டப்படட்டும்; சீகோன் பட்டணம் புதுப்பிக்கப்படட்டும். ");
INSERT INTO tamtcv_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“எஸ்போனில் இருந்து நெருப்பு வெளியேறிற்று, சீகோன் பட்டணத்திலிருந்து சுவாலை வெளியேறிற்று. அது மோவாபின் ஆர் பட்டணத்தை எரித்தது அர்னோன் மேடுகளின் குடிகளையும் எரித்துப்போட்டது. ");
INSERT INTO tamtcv_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","மோவாபியரே உங்களுக்கு ஐயோ கேடு! கேமோஷின் மக்களே நீங்கள் அழிந்தீர்கள்! அவன் தன் மகன்களை அகதிகளாகவும், தன் மகள்களை சிறைக்கைதிகளாகவும் எமோரிய அரசன் சீகோனிடம் ஒப்புக்கொடுத்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“ஆனால், நாங்களோ அவர்களைத் தள்ளி வீழ்த்தினோம்; தீபோன்வரை எஸ்போன் அழிந்தது. மேதேபாவரை பரந்திருக்கும் நோப்பா பகுதிவரையும் அவர்களை அழித்தோம் என்று பாடுகிறார்கள்.” ");
INSERT INTO tamtcv_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","இப்படியாக இஸ்ரயேலர் எமோரியரின் நாட்டில் குடியேறினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","மோசே யாசேருக்கு உளவாளிகளை அனுப்பியபின், இஸ்ரயேலர் அதைச் சுற்றியுள்ள குடியிருப்புகளைக் கைப்பற்றி, அங்கு வாழ்ந்த எமோரியரை வெளியே துரத்திவிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","பின்பு இஸ்ரயேலர் திரும்பி பாசானுக்குப்போகும் வழியாய்ப் போனார்கள். அப்பொழுது பாசானின் அரசன் ஓக் என்பவன் இஸ்ரயேலரை எதிர்த்து யுத்தம் செய்ய தனது முழு படையுடன் எத்ரேயுக்குப் போனான். ");
INSERT INTO tamtcv_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","ஆனால் யெகோவா மோசேயிடம், “நீ அவனுக்குப் பயப்படவேண்டாம். அவனையும் அவனுடைய முழு படையையும், அவனுடைய நாட்டையும் நான் உன் கையில் ஒப்புவித்தேன். நீ எஸ்போனில் அரசாண்ட எமோரியரின் அரசன் சீகோனுக்குச் செய்ததுபோல இவனுக்கும் செய்” என்றார். ");
INSERT INTO tamtcv_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","அப்படியே இஸ்ரயேலர் அவனையும், அவன் மகன்களையும், அவனுடைய முழு படையையும் வெட்டி வீழ்த்தினார்கள். ஒருவரையும் தப்பிப்போக விடவில்லை. அவர்கள் அவனுடைய நாட்டைத் தங்கள் உடைமையாக்கிக்கொண்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","பின்பு இஸ்ரயேலர் மோவாபின் சமவெளியில் பயணம் செய்து, யோர்தான் நதிக்கு மறுகரையில் எரிகோவுக்கு எதிராக முகாமிட்டார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","இஸ்ரயேலர் எமோரியருக்குச் செய்த எல்லாவற்றையும் சிப்போரின் மகன் பாலாக் கண்டான். ");
INSERT INTO tamtcv_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","இஸ்ரயேலர் அநேகராயிருந்தபடியால் மோவாப் திகிலடைந்தான். அவன் இஸ்ரயேலர்களைக் கண்டு பயந்து, பீதி நிறைந்தவனாயிருந்தான். ");
INSERT INTO tamtcv_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","மோவாபியர் மீதியானின் சபைத்தலைவர்களிடம், “புல்வெளியிலே எருது புல் தின்பதுபோல, இந்தப் பெருங்கூட்டம் நம்மைச் சுற்றியுள்ள எல்லாவற்றையும் தின்றுவிடப்போகிறது” என்றார்கள். அந்நாட்களில் மோவாபியருக்கு அரசனாயிருந்த சிப்போரின் மகன் பாலாக், ");
INSERT INTO tamtcv_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","பேயோரின் மகன் பிலேயாமை அழைப்பிக்கத் தூதுவரை அனுப்பினான். பிலேயாம் தான் பிறந்த நாட்டில், ஐபிராத்து நதியருகேயிருந்த பெத்தூரில் இருந்தான். பாலாக் தூதுவர்களிடம், “எகிப்திலிருந்து ஒரு மக்கள் கூட்டம் வந்திருக்கிறது. அவர்கள் நாடெங்கும் நிரம்பி எனக்குப் பக்கத்தில் குடியேறியிருக்கிறார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","இப்பொழுது நீ வந்து இந்த மக்களின்மேல் ஒரு சாபத்தைப்போடு. ஏனென்றால் அவர்கள் என்னைவிட அதிக பலமுள்ளவர்களாயிருக்கிறார்கள். அப்படிச் சாபமிட்டால் ஒருவேளை அவர்களைத் தோற்கடித்து, இந்த நாட்டைவிட்டுத் துரத்திவிட என்னால் இயலும். ஏனெனில் நீ ஆசீர்வதிக்கிறவர்கள் ஆசீர்வதிக்கப்பட்டிருக்கிறார்கள் என்றும், நீ சபிக்கிறவர்கள் சபிக்கப்பட்டிருக்கிறார்கள் என்றும் நான் அறிந்திருக்கிறேன் என்று சொல்லுங்கள்” என்றான். ");
INSERT INTO tamtcv_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","மோவாபிய சபைத்தலைவர்களும், மீதியானிய தலைவர்களும் குறிகேட்பதற்கான கூலியை எடுத்துக்கொண்டு புறப்பட்டார்கள். அவர்கள் பிலேயாமிடம் வந்தபோது பாலாக் சொல்லியிருந்ததை அவனிடம் கூறினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","பிலேயாம் அவர்களிடம், “இன்று இரவு நீங்கள் இங்கே தங்குங்கள்; யெகோவா எனக்குத்தரும் பதிலை நான் உங்களுக்குத் தருவேன்” என்றான். எனவே மோவாபின் தலைவர்கள் அவனுடன் தங்கினார்கள். ");
INSERT INTO tamtcv_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","அப்பொழுது இறைவன் பிலேயாமிடம் வந்து, “உன்னுடன் இருக்கும் இந்த மனிதர்கள் யார்?” என்று கேட்டார். ");
INSERT INTO tamtcv_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","அதற்கு பிலேயாம் இறைவனிடம், “சிப்போரின் மகனான மோவாபின் அரசன் பாலாக் இவர்கள்மூலம் ஒரு செய்தியை எனக்கு அனுப்பியிருக்கிறான்: ")