﻿USE sofia;
DROP TABLE IF EXISTS sofia.tam2017_vpl;
CREATE TABLE tam2017_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tam2017_vpl WRITE;
INSERT INTO tam2017_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ஆதியிலே தேவன் வானத்தையும் பூமியையும் படைத்தார். ");
INSERT INTO tam2017_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","பூமியானது. ஒழுங்கற்றதாகவும் வெறுமையாகவும் இருந்தது; ஆழத்தின்மேல் இருள் இருந்தது; தேவ ஆவியானவர் தண்ணீரின்மேல் அசைவாடிக்கொண்டிருந்தார். ");
INSERT INTO tam2017_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","தேவன் “வெளிச்சம் உண்டாகட்டும்,” என்றார், வெளிச்சம் உண்டானது. ");
INSERT INTO tam2017_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","வெளிச்சம் நல்லது என்று தேவன் கண்டார்; வெளிச்சத்தையும் இருளையும் தேவன் வெவ்வேறாகப் பிரித்தார். ");
INSERT INTO tam2017_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","தேவன் வெளிச்சத்திற்குப் பகல் என்றும், இருளுக்கு இரவு என்றும் பெயரிட்டார்; சாயங்காலமும் விடியற்காலமுமாகி முதலாம் நாள் முடிந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","பின்பு தேவன்; “தண்ணீர்களின் மத்தியில் ஆகாயவிரிவு உண்டாகட்டும்,” என்றும், “அது தண்ணீரிலிருந்து தண்ணீரைப் பிரிக்கட்டும்” என்றும் சொன்னார். ");
INSERT INTO tam2017_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","தேவன் ஆகாயவிரிவை உருவாக்கி, ஆகாயவிரிவுக்குக் கீழே இருக்கிற தண்ணீருக்கும் ஆகாயவிரிவுக்கு மேலே இருக்கிற தண்ணீருக்கும் பிரிவை உண்டாக்கினார்; அது அப்படியே ஆனது. ");
INSERT INTO tam2017_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","தேவன் ஆகாயவிரிவுக்கு “வானம் என்று பெயரிட்டார்; சாயங்காலமும் விடியற்காலமுமாகி, இரண்டாம் நாள் முடிந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","பின்பு தேவன்: “வானத்தின் கீழே இருக்கிற தண்ணீர் ஓரிடத்தில் சேர்ந்து, வெட்டாந்தரை காணப்படுவதாக,” என்றார்; அது அப்படியே ஆனது. ");
INSERT INTO tam2017_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","தேவன் வெட்டாந்தரைக்கு “பூமி” என்றும், சேர்ந்த தண்ணீருக்கு “சமுத்திரம்” என்றும் பெயரிட்டார்; தேவன் அது நல்லது என்று கண்டார். ");
INSERT INTO tam2017_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","அப்பொழுது தேவன்: “பூமியானது புல்லையும், விதையைக் கொடுக்கும் தாவரங்களையும், பூமியின்மேல் தங்களில் தங்கள் விதையையுடைய பழங்களைத் தங்கள் தங்கள் வகையின்படியே கொடுக்கும் பழமரங்களையும் முளைப்பிக்கட்டும்” என்றார்; அது அப்படியே ஆனது. ");
INSERT INTO tam2017_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","பூமியானது புல்லையும், தங்கள் தங்கள் வகையின்படியே விதையைக் கொடுக்கும் தாவரங்களையும், தங்கள் தங்கள் வகைகளின்படியே தங்களில் தங்கள் விதையையுடைய பழங்களைக் கொடுக்கும் மரங்களையும் முளைப்பித்தது; தேவன் அது நல்லது என்று கண்டார். ");
INSERT INTO tam2017_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","சாயங்காலமும் விடியற்காலமுமாகி மூன்றாம் நாள் முடிந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","பின்பு தேவன்: “பகலுக்கும் இரவுக்கும் வித்தியாசம் உண்டாகும்படி வானம் என்கிற ஆகாயவிரிவிலே சுடர்கள் உண்டாகட்டும்” என்றார். மேலும் அவைகள் அடையாளங்களுக்காகவும், காலங்களையும் நாட்களையும் வருடங்களையும் குறிக்கிறதற்காகவும் இருப்பதாக” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","“அவைகள் பூமியின்மேல் பிரகாசிப்பதற்காக வானம் என்கிற ஆகாயவிரிவிலே சுடர்களாக இருக்கட்டும்” என்றார்; அது அப்படியே ஆனது. ");
INSERT INTO tam2017_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","தேவன், பகலை ஆளப் பெரிய சுடரும், இரவை ஆளச் சிறிய சுடரும் ஆகிய இரண்டு மகத்தான சுடர்களையும், நட்சத்திரங்களையும் உண்டாக்கினார். ");
INSERT INTO tam2017_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","அவைகள் பூமியின்மேல் பிரகாசிக்கவும், ");
INSERT INTO tam2017_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","பகலையும் இரவையும் ஆளவும், வெளிச்சத்திற்கும் இருளுக்கும் வித்தியாசம் உண்டாக்கவும், தேவன் அவைகளை வானம் என்கிற ஆகாயவிரிவிலே வைத்தார்; தேவன் அது நல்லது என்று கண்டார். ");
INSERT INTO tam2017_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","சாயங்காலமும் விடியற்காலமுமாகி நான்காம் நாள் முடிந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","பின்பு தேவன்: “நீந்தும் உயிரினங்களையும், பூமியின்மேல் வானம் என்கிற ஆகாயவிரிவிலே பறக்கும் பறவைகளையும், தண்ணீரானது திரளாக பிறப்பிக்கட்டும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","தேவன், மகா பெரிய கடலில் வாழும் உயிரினங்களையும், தண்ணீரில் தங்கள் தங்கள் வகையின்படியே திரளாகப் பிறப்பிக்கப்பட்ட அனைத்துவித நீரில்வாழும் உயிரினங்களையும், சிறகுள்ள வகைவகையான அனைத்துவிதப் பறவைகளையும் உருவாக்கினார்; தேவன் அது நல்லது என்று கண்டார். ");
INSERT INTO tam2017_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","தேவன் அவைகளை ஆசீர்வதித்து, “நீங்கள் பலுகிப் பெருகி, சமுத்திரத்தை நிரப்புங்கள் என்றும், பறவைகள் பூமியிலே பெருகட்டும்” என்றும் சொன்னார். ");
INSERT INTO tam2017_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","சாயங்காலமும் விடியற்காலமுமாகி ஐந்தாம் நாள் முடிந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","பின்பு தேவன்: “பூமியானது வகைவகையான உயிரினங்களாகிய நாட்டுமிருகங்களையும், ஊரும் பிராணிகளையும், காட்டுமிருகங்களையும், வகைவகையாகப் பிறப்பிக்கட்டும்” என்றார்; அது அப்படியே ஆனது. ");
INSERT INTO tam2017_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","தேவன் பூமியிலுள்ள வகைவகையான காட்டுமிருகங்களையும், வகைவகையான நாட்டுமிருகங்களையும், பூமியில் ஊரும் பிராணிகள் எல்லாவற்றையும் உண்டாக்கினார்; தேவன் அது நல்லது என்று கண்டார். ");
INSERT INTO tam2017_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","பின்பு தேவன்: “நமது சாயலாகவும் நமது தோற்றத்தின்படியேயும் மனிதனை உண்டாக்குவோமாக; அவர்கள் சமுத்திரத்தின் உயிரினங்களையும், ஆகாயத்துப் பறவைகளையும், மிருகஜீவன்களையும், பூமியனைத்தையும், பூமியின்மேல் ஊரும் அனைத்துப் பிராணிகளையும் ஆண்டுகொள்ளட்டும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","தேவன் தம்முடைய சாயலாக மனிதனை உருவாக்கினார், அவனைத் தேவசாயலாகவே உருவாக்கினார்; ஆணும் பெண்ணுமாக அவர்களை உருவாக்கினார். ");
INSERT INTO tam2017_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","பின்பு தேவன் அவர்களை நோக்கி: “நீங்கள் பலுகிப் பெருகி, பூமியை நிரப்பி, அதைக் கீழ்ப்படுத்தி, சமுத்திரத்தின் உயிரினங்களையும் ஆகாயத்துப் பறவைகளையும், பூமியின்மேல் நடமாடுகிற அனைத்து உயிரினங்களையும் ஆண்டுகொள்ளுங்கள்” என்று சொல்லி, தேவன் அவர்களை ஆசீர்வதித்தார். ");
INSERT INTO tam2017_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","பின்னும் தேவன்: “இதோ, பூமியின்மேல் எங்கும் விதை தரும் அனைத்துவிதத் தாவரங்களையும், விதை தரும் பழமரங்களாகிய அனைத்துவித மரங்களையும் உங்களுக்குக் கொடுத்தேன், அவைகள் உங்களுக்கு ஆகாரமாக இருப்பதாக; ");
INSERT INTO tam2017_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","பூமியிலுள்ள அனைத்து மிருகஜீவன்களுக்கும், ஆகாயத்திலுள்ள அனைத்து பறவைகளுக்கும், பூமியின்மேல் ஊரும் பிராணிகள் எல்லாவற்றிற்கும் பசுமையான அனைத்துவிதத் தாவரங்களையும் ஆகாரமாகக் கொடுத்தேன்” என்றார்; அது அப்படியே ஆனது. ");
INSERT INTO tam2017_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","அப்பொழுது தேவன் தாம் உண்டாக்கின எல்லாவற்றையும் பார்த்தார், அவைகள் மிகவும் நன்றாக இருந்தன; சாயங்காலமும் விடியற்காலமுமாகி ஆறாம் நாள் முடிந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","இந்தவிதமாக வானமும் பூமியும், அவைகளில் இருக்கிற அனைத்தயும் உண்டாக்கப்பட்டு முடிந்தன. பூமியையும் வானத்தையும் உண்டாக்கின நாளிலே, வானமும் பூமியும் உண்டாக்கப்பட்ட வரலாறு இவைகளே. ");
INSERT INTO tam2017_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","தேவன் தாம் செய்த தம்முடைய செயலை ஏழாம் நாளிலே நிறைவேற்றி, தாம் உருவாக்கும் தம்முடைய செயல்களையெல்லாம் முடித்தபின்பு, ஏழாம் நாளிலே ஓய்ந்திருந்தார். ");
INSERT INTO tam2017_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","தேவன் தாம் உருவாக்கும் தம்முடைய செயல்களையெல்லாம் முடித்தபின்பு அதிலே ஓய்ந்திருந்ததினால், தேவன் ஏழாம் நாளை ஆசீர்வதித்து, அதைப் பரிசுத்தமாக்கினார். ");
INSERT INTO tam2017_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","தேவனாகிய யெகோவா பூமியையும் வானத்தையும் உண்டாக்கின நாளிலே, வானமும் பூமியும் உண்டாக்கப்பட்ட வரலாறு இவைகளே. ");
INSERT INTO tam2017_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","நிலத்தினுடைய அனைத்துவிதச் செடிகளும் பூமியின்மேல் இன்னும் உண்டாகவில்லை, நிலத்தினுடைய அனைத்துவிதத் தாவரங்களும் இன்னும் முளைக்கவில்லை; ஏனென்றால் தேவனாகிய யெகோவா பூமியின்மேல் இன்னும் மழையைப் பெய்யச்செய்யவில்லை; நிலத்தைப் பண்படுத்த மனிதனும் இல்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","அப்பொழுது பூமியிலிருந்து நீரூற்று எழும்பி, பூமியையெல்லாம் நனைத்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","தேவனாகிய யெகோவா மனிதனை பூமியின் மண்ணினாலே உருவாக்கி, உயிரடையச்செய்யும் சுவாசத்தை அவனுடைய மூக்கின் துவாரத்திலே ஊதினார், மனிதன் உயிருள்ள ஆத்துமாவானான். ");
INSERT INTO tam2017_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","தேவனாகிய யெகோவா கிழக்கே ஏதேன் என்னும் ஒரு தோட்டத்தை உண்டாக்கி, தாம் உருவாக்கின மனிதனை அதிலே வைத்தார். ");
INSERT INTO tam2017_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","தேவனாகிய யெகோவா, பார்வைக்கு அழகும் சாப்பிடுவதற்கு ஏற்ற அனைத்துவித மரங்களையும், தோட்டத்தின் நடுவிலே வாழ்வளிக்கும் மரத்தையும், நன்மை தீமை அறியத்தக்க ஆற்றலைக் கொடுக்கும் மரத்தையும் பூமியிலிருந்து முளைக்கச்செய்தார். ");
INSERT INTO tam2017_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","தோட்டத்திற்குத் தண்ணீர் பாய ஏதேனிலிருந்து ஒரு நதி ஓடி, அங்கேயிருந்து பிரிந்து நான்கு பெரிய ஆறுகளானது. ");
INSERT INTO tam2017_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","முதலாம் ஆற்றுக்கு பைசோன் என்று பெயர், அது ஆவிலா தேசம் முழுவதையும் சுற்றி ஓடும்; அந்த இடத்திலே பொன் உண்டு. ");
INSERT INTO tam2017_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","அந்த தேசத்தின் பொன் நல்லது; அந்த இடத்திலே நறுமணப்பிசினும், விலையேறிய முத்துகளும் உண்டு. ");
INSERT INTO tam2017_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","ஆற்றுக்கு கீகோன் என்று பெயர், அது எத்தியோப்பியா தேசம் முழுவதையும் சுற்றி ஓடும். ");
INSERT INTO tam2017_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","மூன்றாம் ஆற்றுக்கு இதெக்கேல் என்று பெயர், அது அசீரியாவுக்குக் கிழக்கே ஓடும்; நான்காம் ஆற்றுக்கு ஐப்பிராத்து என்று பெயர். ");
INSERT INTO tam2017_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","தேவனாகிய யெகோவா மனிதனை ஏதேன் தோட்டத்திற்கு அழைத்துவந்து, அதைப் பண்படுத்தவும் காக்கவும் வைத்தார். ");
INSERT INTO tam2017_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","தேவனாகிய யெகோவா மனிதனை நோக்கி: “நீ தோட்டத்திலுள்ள அனைத்து மரங்களின் பழங்களையும் தாராளமாக சாப்பிடலாம். ");
INSERT INTO tam2017_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ஆனாலும் நன்மை தீமை அறியத்தக்க மரத்தின் பழத்தை சாப்பிடவேண்டாம்; அதை நீ சாப்பிடும் நாளில் சாகவே சாவாய்” என்று கட்டளையிட்டார். ");
INSERT INTO tam2017_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","பின்பு, தேவனாகிய யெகோவா: “மனிதன் தனிமையாக இருப்பது நல்லதல்ல, ஏற்ற துணையை அவனுக்கு உண்டாக்குவேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","தேவனாகிய யெகோவா பூமியிலுள்ள அனைத்துவித மிருகங்களையும், ஆகாயத்தின் அனைத்துவிதப் பறவைகளையும் மண்ணினாலே உருவாக்கி, ஆதாம் அவைகளுக்கு என்ன பெயரிடுவான் என்று பார்க்கும்படி அவைகளை அவனிடத்தில் கொண்டுவந்தார்; அந்தந்த உயிரினத்திற்கு ஆதாம் என்னென்ன பெயரிட்டானோ அதுவே அதற்குப் பெயரானது. ");
INSERT INTO tam2017_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","அப்படியே ஆதாம் அனைத்துவித நாட்டுமிருகங்களுக்கும், ஆகாயத்துப் பறவைகளுக்கும், அனைத்துவிதக் காட்டுமிருகங்களுக்கும் பெயரிட்டான்; ஆதாமுக்கோ ஏற்ற துணை இன்னும் காணப்படவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","அப்பொழுது தேவனாகிய யெகோவா ஆதாமுக்கு ஆழ்ந்த உறக்கத்தை வரச்செய்தார், அவன் ஆழ்ந்து உறங்கினான்; அவர் அவனுடைய விலா எலும்புகளில் ஒன்றை எடுத்து, அந்த இடத்தைச் சதையினால் அடைத்தார். ");
INSERT INTO tam2017_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","தேவனாகிய யெகோவா தாம் மனிதனிலிருந்து எடுத்த விலா எலும்பை மனுஷியாக உருவாக்கி, அவளை மனிதனிடத்தில் கொண்டுவந்தார். ");
INSERT INTO tam2017_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","அப்பொழுது ஆதாம்: “இவள் என் எலும்பில் எலும்பும், என் மாம்சத்தில் மாம்சமுமாக இருக்கிறாள்; இவள் மனிதனிலிருந்து எடுக்கப்பட்டதால் மனுஷி எனப்படுவாள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","இதன் காரணமாக மனிதன் தன் தகப்பனையும் தன் தாயையும் விட்டு, தன் மனைவியோடு இணைந்திருப்பான்; அவர்கள் ஒரே மாம்சமாக இருப்பார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","ஆதாமும் அவனுடைய மனைவியும் நிர்வாணிகளாக இருந்தும், வெட்கப்படாதிருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","தேவனாகிய யெகோவா படைத்த அனைத்து காட்டு உயிரினங்களைவிட பாம்பானது தந்திரமுள்ளதாக இருந்தது. அது பெண்ணை நோக்கி: “நீங்கள் தோட்டத்திலுள்ள அனைத்து மரங்களின் பழங்களையும் சாப்பிடக்கூடாது என்று தேவன் சொன்னாரா” என்றது. ");
INSERT INTO tam2017_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","பெண், பாம்பை நோக்கி: “நாங்கள் தோட்டத்திலுள்ள மரங்களின் பழங்களைச் சாப்பிடலாம்; ");
INSERT INTO tam2017_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ஆனாலும், தோட்டத்தின் நடுவில் இருக்கிற மரத்தின் பழத்தைக்குறித்து, தேவன்: நீங்கள் சாகாமலிருக்க அதை சாப்பிடவும் அதைத் தொடவும் வேண்டாம் என்று சொன்னார்” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","அப்பொழுது பாம்பு, பெண்ணை நோக்கி: “நீங்கள் சாகவே சாவதில்லை; ");
INSERT INTO tam2017_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","நீங்கள் இதை சாப்பிடும் நாளிலே உங்கள் கண்கள் திறக்கப்படும் என்றும், நீங்கள் நன்மை தீமை அறிந்து தேவர்களைப்போல இருப்பீர்கள் என்றும் தேவன் அறிவார்” என்றது. ");
INSERT INTO tam2017_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","அப்பொழுது அந்தப் பெண், அந்த மரத்தின் பழம் சாப்பிடுவதற்கு நல்லதும், பார்வைக்கு இன்பமும், புத்தியைத் தெளிவிக்கிறதற்கு ஆசைப்படத்தக்க பழமுமாக இருக்கிறது என்று கண்டு, அந்தப் பழத்தைப் பறித்து, சாப்பிட்டு, தன் கணவனுக்கும் கொடுத்தாள்; அவனும் சாப்பிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","அப்பொழுது அவர்கள் இருவருடைய கண்களும் திறக்கப்பட்டது; அவர்கள் தாங்கள் நிர்வாணிகள் என்று அறிந்து, அத்தி இலைகளைத் சேர்த்து, தங்களுடைய இடுப்புகளை மறைத்துக்கொண்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","பகலில் குளிர்ச்சியான வேளையிலே தோட்டத்தில் உலாவுகிற தேவனாகிய யெகோவாவுடைய சத்தத்தை அவர்கள் கேட்டார்கள். அப்பொழுது ஆதாமும் அவனுடைய மனைவியும் தேவனாகிய யெகோவாவுக்கு முன்பாக விலகி, தோட்டத்தின் மரங்களுக்குள்ளே ஒளிந்துகொண்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","அப்பொழுது தேவனாகிய யெகோவா ஆதாமைக் கூப்பிட்டு: “நீ எங்கே இருக்கிறாய்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","அதற்கு அவன்: “நான் தேவரீருடைய சத்தத்தைத் தோட்டத்திலே கேட்டு, நான் நிர்வாணியாக இருப்பதால் பயந்து, ஒளிந்துகொண்டேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","அப்பொழுது அவர்: “நீ நிர்வாணி என்று உனக்குச் சொன்னது யார்? சாப்பிடவேண்டாம் என்று நான் உனக்குச் சொன்ன மரத்தின் பழத்தை சாப்பிட்டாயோ” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","அதற்கு ஆதாம்: “என்னுடன் இருப்பதற்காக தேவரீர் தந்த பெண்ணே, அந்த மரத்தின் பழத்தை எனக்குக் கொடுத்தாள், நான் சாப்பிட்டேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","அப்பொழுது தேவனாகிய யெகோவா பெண்ணை நோக்கி: “நீ ஏன் இப்படிச் செய்தாய் என்றார். அந்தப் பெண்: “பாம்பு என்னை ஏமாற்றியது, நான் சாப்பிட்டேன்” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","அப்பொழுது தேவனாகிய யெகோவா பாம்பை நோக்கி: “நீ இதைச் செய்ததால் அனைத்து நாட்டுமிருகங்களிலும் அனைத்து காட்டுமிருகங்களிலும் சபிக்கப்பட்டிருப்பாய், நீ உன் வயிற்றினால் நகர்ந்து, உயிரோடிருக்கும் நாளெல்லாம் மண்ணைத் தின்பாய்; ");
INSERT INTO tam2017_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","உனக்கும் பெண்ணுக்கும், உன் சந்ததிக்கும் அவளுடைய சந்ததிக்கும் பகை உண்டாக்குவேன்; அவர் உன் தலையை நசுக்குவார், நீ அவர் குதிகாலை நசுக்குவாய்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","அவர் பெண்ணை நோக்கி: “நீ கர்ப்பவதியாக இருக்கும்போது உன் வேதனையை மிகவும் அதிகப்படுத்துவேன்; வேதனையோடு பிள்ளை பெறுவாய்; உன் ஆசை உன்னுடைய கணவனைப் பற்றியிருக்கும், அவன் உன்னை ஆண்டுகொள்ளுவான்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","பின்பு அவர் ஆதாமை நோக்கி: “நீ உன்னுடைய மனைவியின் வார்த்தைக்கு முக்கியத்துவம் கொடுத்து, சாப்பிடவேண்டாம் என்று நான் உனக்குச் சொன்ன மரத்தின் பழத்தை சாப்பிட்டதால், பூமி உன்னால் சபிக்கப்பட்டிருக்கும்; நீ உயிரோடிருக்கும் நாட்களெல்லாம் வருத்தத்தோடு அதின் பலனைச் சாப்பிடுவாய். ");
INSERT INTO tam2017_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","அது உனக்கு முட்செடிகளை முளைப்பிக்கும்; நிலத்தின் பயிர்வகைகளைச் சாப்பிடுவாய். ");
INSERT INTO tam2017_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","நீ மண்ணிலிருந்து எடுக்கப்பட்டதால், நீ மண்ணுக்குத் திரும்பும்வரைக்கும் உன் முகத்தின் வியர்வையைச் சிந்தி ஆகாரம் சாப்பிடுவாய்; நீ மண்ணாக இருக்கிறாய், மண்ணுக்குத் திரும்புவாய்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","ஆதாம் தன் மனைவிக்கு ஏவாள் என்று பெயரிட்டான்; ஏனென்றால், அவள் உயிருள்ள அனைவருக்கும் தாயானவள். ");
INSERT INTO tam2017_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","தேவனாகிய யெகோவா ஆதாமுக்கும் அவனுடைய மனைவிக்கும் தோல் உடைகளை உண்டாக்கி அவர்களுக்கு உடுத்தினார். ");
INSERT INTO tam2017_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","பின்பு தேவனாகிய யெகோவா: “இதோ, மனிதன் நன்மை தீமை அறியத்தக்கவனாகி நம்மில் ஒருவரைப்போல் ஆனான்; இப்பொழுதும் அவன் தன் கையை நீட்டி வாழ்வளிக்கும் மரத்தின் பழத்தையும் பறித்து சாப்பிட்டு, என்றைக்கும் உயிரோடு இல்லாதபடிச் செய்யவேண்டும்” என்று, ");
INSERT INTO tam2017_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","அவன் எடுக்கப்பட்ட மண்ணைப் பண்படுத்த தேவனாகிய யெகோவா அவனை ஏதேன் தோட்டத்திலிருந்து அனுப்பிவிட்டார். ");
INSERT INTO tam2017_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","அவர் மனிதனைத் துரத்திவிட்டு, வாழ்வளிக்கும் மரத்திற்குப் போகும் வழியைக் காவல்செய்ய ஏதேன் தோட்டத்திற்குக் கிழக்கே கேருபீன்களையும், வீசிக்கொண்டிருக்கிற சுடரொளிப் பட்டயத்தையும் வைத்தார். ");
INSERT INTO tam2017_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","ஆதாம் தன் மனைவியாகிய ஏவாளுடன் இணைந்தான்; அவள் கர்ப்பவதியாகி, காயீனைப் பெற்று, “யெகோவாவுடைய உதவியால் ஒரு மகனைப் பெற்றேன்” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","பின்பு அவனுடைய சகோதரனாகிய ஆபேலைப் பெற்றெடுத்தாள்; ஆபேல் ஆடுகளை மேய்க்கிறவனானான், காயீன் நிலத்தைப் பயிரிடுகிறவனானான். ");
INSERT INTO tam2017_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","சிலநாட்கள் சென்றபின்பு, காயீன் நிலத்தின் பழங்களைக் யெகோவாவுக்குக் காணிக்கையாகக் கொண்டுவந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ஆபேலும் தன் மந்தையின் தலையீற்றுகளிலும் அவைகளின் கொழுமையானவைகளிலும் சிலவற்றைக் கொண்டுவந்தான். ஆபேலையும் அவனுடைய காணிக்கையையும் யெகோவா ஏற்றுக்கொண்டார். ");
INSERT INTO tam2017_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","காயீனையும் அவனுடைய காணிக்கையையும் அவர் ஏற்றுக்கொள்ளவில்லை. அப்பொழுது காயீனுக்கு மிகவும் எரிச்சல் உண்டாகி, அவனுடைய முகத்தோற்றம் வேறுபட்டது. ");
INSERT INTO tam2017_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","அப்பொழுது யெகோவா காயீனை நோக்கி: “உனக்கு ஏன் எரிச்சல் உண்டானது? உன் முகத்தோற்றம் ஏன் வேறுபட்டது? ");
INSERT INTO tam2017_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","நீ நன்மைசெய்தால் மேன்மை இல்லையோ? நீ நன்மை செய்யாமலிருந்தால் பாவம் வாசற்படியில் படுத்திருக்கும்; அது உன்னை ஆளுகை செய்ய விரும்பும், ஆனால் நீ அதை ஆளுகை செய்யவேண்டும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","காயீன் தன்னுடைய சகோதரனாகிய ஆபேலோடு பேசினான்; அவர்கள் வயல்வெளியில் இருக்கும்போது, காயீன் தன்னுடைய சகோதரனாகிய ஆபேலுக்கு விரோதமாக எழும்பி, அவனைக் கொலைசெய்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","யெகோவா காயீனை நோக்கி: “உன் சகோதரனாகிய ஆபேல் எங்கே” என்றார்; அதற்கு அவன்: எனக்குத் தெரியாது; என் சகோதரனுக்கு நான் காவலாளியா” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","அதற்கு அவர்: “என்ன செய்தாய்? உன் சகோதரனுடைய இரத்தத்தின் சத்தம் பூமியிலிருந்து என்னை நோக்கிக் கூப்பிடுகிறது. ");
INSERT INTO tam2017_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","இப்பொழுது உன் சகோதரனுடைய இரத்தம் உன்னால் பூமியில் சிந்தப்பட்டதால் இந்த பூமியில் நீ சபிக்கப்பட்டிருப்பாய். ");
INSERT INTO tam2017_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","நீ நிலத்தில் பயிரிடும்போது, அது தன்னுடைய பலனை இனி உனக்குக் கொடுக்காது; நீ பூமியில் நிலையில்லாமல் அலைகிறவனாக இருப்பாய்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","அப்பொழுது காயீன் யெகோவாவை நோக்கி: “எனக்குக் கொடுக்கப்பட்ட தண்டனையை என்னால் தாங்கிக்கொள்ளமுடியாது. ");
INSERT INTO tam2017_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","இன்று என்னை இந்த தேசத்திலிருந்து துரத்திவிடுகிறீர்; நான் உமது சமுகத்திற்கு விலகி மறைந்து, பூமியில் நிலையில்லாமல் அலைகிறவனாக இருப்பேன்; என்னைக் கண்டுபிடிக்கிறவன் எவனும் என்னைக் கொன்றுபோடுவானே” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","அப்பொழுது யெகோவா அவனை நோக்கி: “காயீனைக் கொல்லுகிற எவன் மேலும் ஏழு பழி சுமரும்” என்று சொல்லி; காயீனைக் கண்டுபிடிக்கிறவன் எவனும் அவனைக் கொன்றுபோடாமலிருக்க யெகோவா அவன்மேல் ஒரு அடையாளத்தைப் போட்டார். ");
INSERT INTO tam2017_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","அப்படியே காயீன் யெகோவாவுடைய சந்நிதியைவிட்டுப் புறப்பட்டு, ஏதேனுக்குக் கிழக்கே நோத் என்னும் தேசத்தில் குடியிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","காயீன் தன்னுடைய மனைவியுடன் இணைந்தான்; அவள் கர்ப்பவதியாகி, ஏனோக்கைப் பெற்றெடுத்தாள்; அப்பொழுது அவன் ஒரு பட்டணத்தைக் கட்டி, அந்தப் பட்டணத்திற்குத் தன் மகனாகிய ஏனோக்குடைய பெயரை வைத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ஏனோக்குக்கு ஈராத் பிறந்தான்; ஈராத் மெகுயவேலைப் பெற்றெடுத்தான்; மெகுயவேல் மெத்தூசவேலைப் பெற்றெடுத்தான்; மெத்தூசவேல் லாமேக்கைப் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","லாமேக்கு இரண்டு பெண்களைத் திருமணம் செய்தான்; ஒருத்திக்கு ஆதாள் என்று பெயர், மற்றொருவளுக்குச் சில்லாள் என்று பெயர். ");
INSERT INTO tam2017_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ஆதாள் யாபாலைப் பெற்றெடுத்தாள்; அவன் கூடாரங்களில் குடியிருக்கிறவர்களுக்கும், மந்தை மேய்க்கிறவர்களுக்கும் தகப்பனானான். ");
INSERT INTO tam2017_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","அவனுடைய சகோதரனுடைய பெயர் யூபால்; அவன் கின்னரக்காரர்கள், நாதசுரக்காரர்கள் அனைவருக்கும் தகப்பனானான். ");
INSERT INTO tam2017_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","சில்லாளும், தூபால் காயீனைப் பெற்றெடுத்தாள்; அவன் பித்தளை, இரும்பு முதலியவற்றின் தொழிலாளர்கள் அனைவருக்கும் ஆசாரியனானான்; தூபால் காயீனுடைய சகோதரி நாமாள். ");
INSERT INTO tam2017_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","லாமேக்கு தன் மனைவிகளைப் பார்த்து: “ஆதாளே, சில்லாளே, நான் சொல்வதைக் கேளுங்கள்; லாமேக்கின் மனைவிகளே, நான் சொல்வதை மிகவும் கவனமாகக் கேளுங்கள்; எனக்குக் காயமுண்டாக்கிய ஒரு மனிதனைக் கொன்றேன்; எனக்குத் தழும்புண்டாக்கிய ஒரு வாலிபனைக் கொலைசெய்தேன்; ");
INSERT INTO tam2017_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","காயீனுக்காக ஏழு பழி சுமருமானால், லாமேக்குக்காக எழுபத்தேழு பழி சுமரும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","பின்னும் ஆதாம் தன் மனைவியுடன் இணைந்தான்; அவள் ஒரு மகனைப் பெற்று: “காயீன் கொலைசெய்த ஆபேலுக்கு பதிலாக, தேவன் எனக்கு வேறொரு மகனைக் கொடுத்தார்” என்று சொல்லி, அவனுக்கு சேத் என்று பெயரிட்டாள். ");
INSERT INTO tam2017_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","சேத்துக்கும் ஒரு மகன் பிறந்தான்; அவனுக்கு ஏனோஸ் என்று பெயரிட்டான்; அப்பொழுது மக்கள் யெகோவாவுடைய நாமத்தை வழிபட ஆரம்பித்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ஆதாமின் வம்சவரலாறு: தேவன் மனிதனை உருவாக்கின நாளிலே அவனை தேவசாயலாக உண்டாக்கினார். ");
INSERT INTO tam2017_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","அவர்களை ஆணும் பெண்ணுமாக உருவாக்கினார், அவர்களை ஆசீர்வதித்து, அவர்களை உருவாக்கின நாளிலே அவர்களுக்கு மனிதர்கள் என்று பெயரிட்டார். ");
INSERT INTO tam2017_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","ஆதாம் 130 வயதானபோது, தன் சாயலாகத் தன் உருவத்தைப்போல ஒரு மகனைப் பெற்றெடுத்து, அவனுக்கு சேத் என்று பெயரிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","ஆதாம் சேத்தைப் பெற்றபின், 800 வருடங்கள் உயிரோடிருந்து, மகன்களையும் மகள்களையும் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ஆதாம் உயிரோடிருந்த நாட்களெல்லாம் 930 வருடங்கள்; அவன் இறந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","சேத் 105 வயதானபோது, ஏனோசைப் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","சேத் ஏனோசைப் பெற்றபின், 807 வருடங்கள் உயிரோடிருந்து, மகன்களையும் மகள்களையும் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","சேத்துடைய நாட்களெல்லாம் 912 வருடங்கள்; அவன் இறந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ஏனோஸ் 90 வயதானபோது, கேனானைப் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","ஏனோஸ் கேனானைப் பெற்றபின்பு, 815 வருடங்கள் உயிரோடிருந்து, மகன்களையும் மகள்களையும் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ஏனோசுடைய நாட்களெல்லாம் 905 வருடங்கள், அவன் இறந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","கேனான் 70 வயதானபோது, மகலாலெயேலைப் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","கேனான் மகலாலெயேலைப் பெற்றபின், 840 வருடங்கள் உயிரோடிருந்து, மகன்களையும் மகள்களையும் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","கேனானுடைய நாட்களெல்லாம் 910 வருடங்கள்; அவன் இறந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","மகலாலெயேல் 65 வயதானபோது, யாரேதைப் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","மகலாலெயேல் யாரேதைப் பெற்றபின், 830 வருடங்கள் உயிரோடிருந்து, மகன்களையும், மகள்களையும் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","மகலாலெயேலுடைய நாட்களெல்லாம் 895 வருடங்கள்; அவன் இறந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","யாரேத் 162 வயதானபோது, ஏனோக்கைப் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","யாரேத் ஏனோக்கைப் பெற்றபின், 800 வருடங்கள் உயிரோடிருந்து, மகன்களையும் மகள்களையும் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","யாரேதுடைய நாட்களெல்லாம் 962 வருடங்கள்; அவன் இறந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ஏனோக்கு 65 வயதானபோது, மெத்தூசலாவைப் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","ஏனோக்கு மெத்தூசலாவைப் பெற்றபின், 300 வருடங்கள் தேவனோடு நெருங்கி உறவாடிக்கொண்டிருந்து, மகன்களையும், மகள்களையும் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ஏனோக்குடைய நாட்களெல்லாம் 365 வருடங்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ஏனோக்கு தேவனோடு நெருங்கி உறவாடிக்கொண்டிருக்கும்போது, காணப்படாமற்போனான்; தேவன் அவனை எடுத்துக்கொண்டார். ");
INSERT INTO tam2017_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","மெத்தூசலா 187 வயதானபோது, லாமேக்கைப் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","மெத்தூசலா லாமேக்கைப் பெற்றபின், 782 வருடங்கள் உயிரோடிருந்து, மகன்களையும் மகள்களையும் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","மெத்தூசலாவுடைய நாட்களெல்லாம் 969 வருடங்கள்; அவன் இறந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","லாமேக்கு 182 வயதானபோது, ஒரு மகனைப் பெற்றெடுத்து, ");
INSERT INTO tam2017_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","“யெகோவா சபித்த பூமியிலே நமக்கு உண்டான வேலையிலும், நம்முடைய கைகளின் பிரயாசத்திலும், இவன் நம்மைத் தேற்றுவான்” என்று சொல்லி, அவனுக்கு நோவா என்று பெயரிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","லாமேக்கு நோவாவைப் பெற்றபின், 595 வருடங்கள் உயிரோடிருந்து, மகன்களையும், மகள்களையும் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","லாமேக்குடைய நாட்களெல்லாம் 777 வருடங்கள்; அவன் இறந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","நோவா 500 வயதானபோது சேம், காம், யாப்பேத் என்பவர்களைப் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","மனிதர்கள் பூமியின்மேல் பெருகத்துவங்கி, அவர்களுக்கு மகள்கள் பிறந்தபோது: ");
INSERT INTO tam2017_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","தேவனுடைய மகன்கள் மனிதர்களுடைய மகள்களை மிகுந்த அழகுள்ளவர்களென்று கண்டு, அவர்களுக்குள்ளே தங்களுக்குப் பெண்களைத் தெரிந்துகொண்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","அப்பொழுது யெகோவா: “என் ஆவி என்றைக்கும் மனிதனோடு இருப்பதில்லை; அவன் மாம்சம்தானே, அவன் உயிரோடு இருக்கப்போகிற நாட்கள் 120 வருடங்கள்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","அந்நாட்களில் இராட்சதர்கள் பூமியிலே இருந்தார்கள்; பின்பு தேவனுடைய மகன்கள் மனிதர்களுடைய மகள்களோடு இணைகிறதினால், இவர்கள் அவர்களுக்குப் பிள்ளைகளைப் பெற்றபோது, இவர்களும் முற்காலத்தில் பிரசித்திபெற்ற மனிதர்களாகிய பலவான்களானார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","மனிதனுடைய அக்கிரமம் பூமியிலே பெருகினது என்றும், அவனுடைய இருதயத்தின் நினைவுகளின் தோற்றமெல்லாம் நித்தமும் பொல்லாததே என்றும், யெகோவா கண்டு, ");
INSERT INTO tam2017_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","தாம் பூமியிலே மனிதனை உண்டாக்கினதற்காகக் யெகோவா மனவேதனை அடைந்தார்; அது அவர் இருதயத்திற்கு வருத்தமாக இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","அப்பொழுது யெகோவா: “நான் உருவாக்கிய மனிதனை பூமியின்மேல் வைக்காமல், மனிதன் முதற்கொண்டு, மிருகங்கள், ஊரும் பிராணிகள், ஆகாயத்துப் பறவைகள்வரை உண்டாயிருக்கிறவைகளை அழித்துப்போடுவேன்; நான் அவர்களை உண்டாக்கினது எனக்கு மனவேதனையாக இருக்கிறது” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","நோவாவுக்கோ, யெகோவாவுடைய கண்களில் கிருபை கிடைத்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","நோவாவின் வம்சவரலாறு: நோவா தன் காலத்தில் இருந்தவர்களுக்குள்ளே நீதிமானும் உத்தமனுமாயிருந்தான்; நோவா தேவனோடு நெருங்கி உறவாடிக்கொண்டிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","நோவா சேம், காம், யாப்பேத் என்னும் மூன்று மகன்களைப் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","பூமியானது தேவனுக்கு முன்பாகச் சீர்கெட்டதாக இருந்தது; பூமி கொடுமையினால் நிறைந்திருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","தேவன் பூமியைப் பார்த்தார்; இதோ அது சீர்கெட்டதாக இருந்தது; மனிதர்கள் அனைவரும் பூமியின்மேல் தங்களுடைய வழிகளைக் கெடுத்துக்கொண்டிருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","அப்பொழுது தேவன் நோவாவை நோக்கி: ““மனிதர்களான எல்லோருடைய முடிவும் எனக்கு முன்பாக வந்தது; அவர்களாலே பூமி கொடுமையினால் நிறைந்தது; நான் அவர்களைப் பூமியோடு சேர்த்து அழித்துப்போடுவேன். ");
INSERT INTO tam2017_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","நீ கொப்பேர் மரத்தால் உனக்கு ஒரு கப்பலை உண்டாக்கு; அந்தக் கப்பலில் அறைகளை உண்டாக்கி, அதை உள்ளேயும் வெளியேயும் கீல் பூசு. ");
INSERT INTO tam2017_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","நீ அதைச் செய்யவேண்டிய முறை என்னவென்றால், கப்பலின் நீளம் 450 அடிகள், அதின் அகலம் 75 அடிகள், அதின் உயரம் 45 அடிகளாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","நீ கப்பலுக்கு ஒரு ஜன்னலை உண்டாக்கி, மேல் அடுக்குக்கு ஒரு முழம் இறக்கி அதைச் செய்துமுடித்து, கப்பலின் கதவை அதின் பக்கத்தில் வைத்து, கீழ் அறைகளையும், இரண்டாம் அடுக்கின் அறைகளையும், மூன்றாம் அடுக்கின் அறைகளையும் உண்டாக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","வானத்தின்கீழே உயிருள்ள அனைத்து உயிரினங்களையும் அழிக்க நான் பூமியின்மேல் மாபெரும் வெள்ளப்பெருக்கை வரச்செய்வேன்; பூமியிலுள்ள அனைத்தும் இறந்துபோகும். ");
INSERT INTO tam2017_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","ஆனாலும் உன்னோடு என்னுடைய உடன்படிக்கையை ஏற்படுத்துவேன்; நீயும், உன்னோடுகூட உன்னுடைய மகன்களும், உன்னுடைய மனைவியும், உன்னுடைய மகன்களின் மனைவிகளும், கப்பலுக்குள் செல்லுங்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","அனைத்துவித உயிரினங்களிலும் ஆணும் பெண்ணுமாக வகை ஒன்றுக்கு ஒவ்வொரு ஜோடி உன்னுடன் உயிரோடு காக்கப்படுவதற்கு, கப்பலுக்குள்ளே சேர்த்துக்கொள். ");
INSERT INTO tam2017_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","வகைவகையான பறவைகளிலும், வகைவகையான மிருகங்களிலும், பூமியிலுள்ள அனைத்து வகைவகையான ஊரும் பிராணிகளிலும், வகை ஒன்றுக்கு ஒவ்வொரு ஜோடி உயிரோடு காக்கப்படுவதற்கு உன்னிடத்திலே வரவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","உனக்கும் அவைகளுக்கும் ஆகாரமாகப் பலவித உணவுப்பொருட்களையும் சேர்த்து, உன்னிடத்தில் வைத்துக்கொள்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","நோவா அப்படியே செய்தான்; தேவன் தனக்குக் கட்டளையிட்டபடியெல்லாம் அவன் செய்து முடித்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","யெகோவா நோவாவை நோக்கி: “நீயும் உன் குடும்பத்தினர் அனைவரும் கப்பலுக்குள் செல்லுங்கள்; இந்தச் சந்ததியில் உன்னை எனக்கு முன்பாக நீதிமானாகக் கண்டேன். ");
INSERT INTO tam2017_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","பூமியின்மீதெங்கும் வித்தை உயிரோடு காக்கும்பொருட்டு, நீ சுத்தமான அனைத்து மிருகங்களிலும், ஆணும் பெண்ணுமாக ஏழு ஏழு ஜோடியும், சுத்தமில்லாத மிருகங்களில் ஆணும் பெண்ணுமாக ஒவ்வொரு ஜோடியும், ");
INSERT INTO tam2017_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ஆகாயத்துப் பறவைகளிலும், ஆணும் பெண்ணுமாக ஏழு ஏழு ஜோடியும் உன்னிடத்தில் சேர்த்துக்கொள். ");
INSERT INTO tam2017_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","இன்னும் ஏழுநாட்கள் சென்றபின்பு, 40 நாட்கள் இரவும் பகலும் பூமியின்மேல் மழையைப் பெய்யச்செய்து, நான் உண்டாக்கின உயிரினங்கள் அனைத்தையும் பூமியின்மேல் இல்லாமல் அழித்துப்போடுவேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","நோவா தனக்குக் யெகோவா கட்டளையிட்டபடியெல்லாம் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","வெள்ளப்பெருக்கு பூமியின்மேல் உண்டானபோது, நோவா 600 வயதுள்ளவனாயிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","வெள்ளப்பெருக்கிற்குத் தப்பும்படி நோவாவும் அவனோடு அவனுடைய மகன்களும், அவனுடைய மனைவியும், அவனுடைய மகன்களின் மனைவிகளும் கப்பலுக்குள் சென்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","தேவன் நோவாவுக்குக் கட்டளையிட்டபடியே, சுத்தமான மிருகங்களிலும், சுத்தமில்லாத மிருகங்களிலும், பூமியின்மேல் ஊரும் பிராணிகள் எல்லாவற்றிலும், ");
INSERT INTO tam2017_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ஆணும் பெண்ணும் ஜோடிஜோடியாக நோவாவிடத்திற்கு வந்து, கப்பலுக்குள் சென்றன. ");
INSERT INTO tam2017_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ஏழுநாட்கள் சென்றபின்பு பூமியின்மேல் வெள்ளப்பெருக்கு உண்டானது. ");
INSERT INTO tam2017_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","நோவாவுக்கு 600 வயதாகும் வருடம் இரண்டாம் மாதம் பதினேழாம் தேதியாகிய அந்த நாளிலே, மகா ஆழத்தின் ஊற்றுக்கண்களெல்லாம் பிளந்தன; வானத்தின் மதகுகளும் திறந்தன. ");
INSERT INTO tam2017_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","நாற்பது நாட்கள் இரவும் பகலும் பூமியின்மேல் பெருமழை பெய்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","அன்றையத்தினமே நோவாவும், நோவாவின் மகன்களாகிய சேமும் காமும் யாப்பேத்தும், அவர்களுடனேகூட நோவாவின் மனைவியும், அவனுடைய மகன்களின் மூன்று மனைவிகளும், கப்பலுக்குள் சென்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","அவர்களோடு வகைவகையான அனைத்துவிதக் காட்டுமிருகங்களும், வகைவகையான அனைத்துவித நாட்டுமிருகங்களும், பூமியின்மேல் ஊருகிற வகைவகையான அனைத்துவித ஊரும் பிராணிகளும், வகைவகையான அனைத்துவிதப் பறவைகளும், பலவிதமான சிறகுகளுள்ள அனைத்துவிதப் பறவைகளும் சென்றன. ");
INSERT INTO tam2017_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","இப்படியே ஜீவசுவாசமுள்ள உயிரினங்களெல்லாம் ஜோடிஜோடியாக நோவாவிடத்திற்கு வந்து கப்பலுக்குள் சென்றன. ");
INSERT INTO tam2017_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","தேவன் அவனுக்குக் கட்டளையிட்டபடியே, ஆணும் பெண்ணுமாக அனைத்துவித உயிரினங்களும் உள்ளே சென்றன; அப்பொழுது யெகோவா அவனை உள்ளே விட்டுக் கதவை அடைத்தார். ");
INSERT INTO tam2017_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","வெள்ளப்பெருக்கு 40 நாட்கள் பூமியின்மேல் இருந்தபோது தண்ணீர் பெருகி கப்பலை மேலே எழும்பச் செய்தது; அது பூமிக்குமேல் மிதந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","தண்ணீர் பெருவெள்ளமாகி பூமியின்மேல் மிகவும் பெருகியது; கப்பலானது தண்ணீரின்மேல் மிதந்துகொண்டிருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","தண்ணீர் பூமியின்மேல் மிகவும் அதிகமாகப் பெருகியதால், வானத்தின்கீழ் எங்குமுள்ள உயர்ந்த மலைகளெல்லாம் மூடப்பட்டன. ");
INSERT INTO tam2017_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","மூடப்பட்ட மலைகளுக்கு மேலாகப் 22 அடி உயரத்திற்குத் தண்ணீர் பெருகியது. ");
INSERT INTO tam2017_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","அப்பொழுது உயிரினங்களாகிய பறவைகளும், நாட்டுமிருகங்களும், காட்டுமிருகங்களும், பூமியின்மேல் ஊரும் பிராணிகள் அனைத்தும், எல்லா மனிதர்களும், பூமியின்மேல் வாழ்கிறவைகள் அனைத்தும் இறந்தன. ");
INSERT INTO tam2017_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","நிலப்பரப்பு எல்லாவற்றிலும் இருந்த உயிருள்ள அனைத்தும் இறந்துபோயின. ");
INSERT INTO tam2017_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","மனிதர்கள்முதல் மிருகங்கள், ஊரும் பிராணிகள், ஆகாயத்துப் பறவைகள்வரை, பூமியின்மீது இருந்த உயிருள்ள அனைத்தும் அழிக்கப்பட்டு, அவைகள் பூமியில் இல்லாமல் ஒழிந்தன; நோவாவும் அவனோடு கப்பலிலிருந்த உயிர்களும் மாத்திரம் காக்கப்பட்டன. ");
INSERT INTO tam2017_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","தண்ணீர் பூமியை 150 நாட்கள் மூடிக்கொண்டிருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","தேவன் நோவாவையும், அவனுடன் கப்பலிலிருந்த அனைத்து காட்டுமிருகங்களையும், அனைத்து நாட்டுமிருகங்களையும் நினைவுகூர்ந்து, பூமியின்மேல் காற்றை வீசச்செய்தார். அப்பொழுது தண்ணீர் குறையத் தொடங்கியது. ");
INSERT INTO tam2017_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ஆழத்தின் ஊற்றுக்கண்களும், வானத்தின் மதகுகளும் அடைபட்டன; வானத்து மழையும் நின்றுபோனது. ");
INSERT INTO tam2017_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","தண்ணீர் பூமியிலிருந்து நாளுக்குநாள் வற்றிக்கொண்டே வந்தது; 150 நாட்களுக்குப்பின்பு தண்ணீர் குறைந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ஏழாம் மாதம் பதினேழாம் தேதியிலே கப்பல் அரராத் என்னும் மலைகளின்மேல் தங்கினது. ");
INSERT INTO tam2017_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","பத்தாம் மாதம்வரைக்கும் தண்ணீர் குறைந்துகொண்டே வந்தது; பத்தாம் மாதம் முதல் தேதியிலே மலைச்சிகரங்கள் காணப்பட்டன. ");
INSERT INTO tam2017_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","40 நாட்களுக்குப் பிறகு, நோவா தான் கப்பலில் செய்திருந்த ஜன்னலைத் திறந்து, ");
INSERT INTO tam2017_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ஒரு காகத்தை வெளியே விட்டான்; அது புறப்பட்டு பூமியின்மேல் இருந்த தண்ணீர் வற்றிப்போகும்வரைக்கும் போகிறதும் வருகிறதுமாக இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","பின்பு பூமியின்மேல் தண்ணீர் குறைந்து போயிற்றோ என்று தெரிந்துகொள்ளும்படி, ஒரு புறாவை வெளியே விட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","பூமியின்மேலெங்கும் தண்ணீர் இருந்ததினால், அந்தப் புறா தன் உள்ளங்கால் வைத்து இளைப்பாற இடம் கிடைக்காததால், திரும்பிக் கப்பலிலே அவனிடத்திற்கு வந்தது; அவன் தன் கையை நீட்டி அதைப்பிடித்துத் தன்னிடமாகக் கப்பலுக்குள் சேர்த்துக்கொண்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","பின்னும் ஏழு நாட்களுக்குப் பிறகு, மறுபடியும் புறாவைக் கப்பலிலிருந்து வெளியே விட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","அந்தப் புறா சாயங்காலத்தில் அவனிடத்திற்கு வந்து சேர்ந்தது; இதோ, அது கொத்திக்கொண்டுவந்த ஒரு ஒலிவமரத்தின் இலை அதின் வாயில் இருந்தது; அதனால் நோவா பூமியின்மேல் தண்ணீர் குறைந்துபோயிற்று என்று தெரிந்து கொண்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","பின்னும் ஏழு நாட்களுக்குப் பிறகு, அவன் புறாவை வெளியே விட்டான்; அது அவனிடத்திற்குத் திரும்பி வரவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","அவனுக்கு 601 வயதாகும் வருடத்தில், முதல் மாதம் முதல் தேதியிலே பூமியின்மேல் இருந்த தண்ணீர் வற்றிப்போயிற்று; நோவா கப்பலின் மேல் அடுக்கை எடுத்துப்பார்த்தான்; பூமியின்மேல் தண்ணீர் இல்லாதிருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","இரண்டாம் மாதம் இருபத்தேழாம் தேதியிலே பூமி காய்ந்திருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","அப்பொழுது தேவன் நோவாவை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“நீயும், உன்னோடுகூட உன்னுடைய மனைவியும், மகன்களும், மகன்களின் மனைவிகளும் கப்பலைவிட்டுப் புறப்படுங்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","உன்னிடத்தில் இருக்கிற அனைத்துவித உயிரினங்களாகிய பறவைகளையும், மிருகங்களையும், பூமியின்மேல் ஊருகிற அனைத்து பிராணிகளையும் உன்னோடு வெளியே வரவிடு; அவைகள் பூமியிலே திரளாக ஈன்றெடுத்து, பூமியின்மேல் பலுகிப் பெருகட்டும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","அப்பொழுது நோவாவும், அவனுடைய மனைவியும், மகன்களும், மகன்களின் மனைவிகளும் வெளியே வந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","பூமியின்மேல் நடமாடுகிற அனைத்து மிருகங்களும், ஊருகிற அனைத்து பிராணிகளும், அனைத்து பறவைகளும் வகைவகையாகக் கப்பலிலிருந்து வெளியே வந்தன. ");
INSERT INTO tam2017_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","அப்பொழுது நோவா யெகோவாவுக்கு ஒரு பலிபீடத்தைக் கட்டி, சுத்தமான அனைத்து மிருகங்களிலும், சுத்தமான அனைத்து பறவைகளிலும் சிலவற்றைத் தெரிந்துகொண்டு, அவைகளைப் பலிபீடத்தின்மேல் தகனபலிகளாகப் பலியிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","சுகந்த வாசனையைக் யெகோவா முகர்ந்தார். அப்பொழுது யெகோவா: “இனி நான் மனிதனுக்காக பூமியை சபிப்பதில்லை; மனிதனுடைய இருதயத்தின் நினைவுகள் அவனுடைய சிறுவயது தொடங்கி பொல்லாததாக இருக்கிறது; நான் இப்பொழுது செய்ததுபோல, இனி அனைத்து உயிரினங்களையும் அழிப்பதில்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","பூமி இருக்கும்வரைக்கும் விதைப்பும் அறுப்பும், குளிர்ச்சியும் வெப்பமும், கோடைக்காலமும் மழைக்காலமும், பகலும் இரவும் ஒழிவதில்லை” என்று தம்முடைய உள்ளத்தில் சொன்னார். ");
INSERT INTO tam2017_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","பின்பு தேவன் நோவாவையும், அவனுடைய மகன்களையும் ஆசீர்வதித்து: “நீங்கள் பலுகிப் பெருகி, பூமியை நிரப்புங்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","உங்களைப்பற்றிய பயமும் அச்சமும் பூமியிலுள்ள அனைத்து மிருகங்களுக்கும், ஆகாயத்திலுள்ள அனைத்துப் பறவைகளுக்கும் உண்டாயிருக்கும்; பூமியிலே நடமாடுகிற அனைத்தும், சமுத்திரத்தின் மீன்வகைகள் அனைத்தும் உங்கள் கையில் கொடுக்கப்பட்டன. ");
INSERT INTO tam2017_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","நடமாடுகிற உயிரினங்கள் அனைத்தும் உங்களுக்கு உணவாக இருக்கட்டும்; பசுமையான தாவரங்களை உங்களுக்குக் கொடுத்ததுபோல, அவைகள் எல்லாவற்றையும் உங்களுக்குக் கொடுத்தேன். ");
INSERT INTO tam2017_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","இறைச்சியை அதின் உயிராகிய இரத்தத்துடன் சாப்பிடவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","உங்களுக்கு உயிராயிருக்கிற உங்கள் இரத்தத்திற்காகப் பழிவாங்குவேன்; அனைத்து உயிரினங்களிடத்திலும் மனிதனிடத்திலும் பழிவாங்குவேன்; மனிதனுடைய உயிருக்காக அவனவன் சகோதரனிடத்தில் பழிவாங்குவேன். ");
INSERT INTO tam2017_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","மனிதன் தேவசாயலில் உண்டாக்கப்பட்டதால், மனிதனுடைய இரத்தத்தை எவன் சிந்துகிறானோ, அவனுடைய இரத்தம் மனிதனாலே சிந்தப்படட்டும். ");
INSERT INTO tam2017_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","நீங்கள் பலுகிப் பெருகி, பூமியிலே திரளாகப் பெற்றெடுத்து பெருகுங்கள்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","பின்னும் தேவன் நோவாவையும், அவனுடைய மகன்களையும் நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“நான் உங்களோடும், உங்களுக்குப் பின்வரும் உங்கள் சந்ததியோடும், ");
INSERT INTO tam2017_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","உங்களுடன் கப்பலிலிருந்து புறப்பட்ட அனைத்து உயிரினங்கள்முதல் இனிப் பூமியில் பிறக்கப்போகிற அனைத்து உயிரினங்கள்வரை பறவைகளோடும், நாட்டுமிருகங்களோடும், உங்களிடத்தில் இருக்கிற பூமியிலுள்ள அனைத்து காட்டுமிருகங்களோடும் என் உடன்படிக்கையை ஏற்படுத்துகிறேன். ");
INSERT INTO tam2017_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","இனி உயிருள்ளவைகளெல்லாம் வெள்ளப்பெருக்கினால் அழிக்கப்படுவதில்லையென்றும், பூமியை அழிக்க இனி வெள்ளப்பெருக்கு உண்டாவதில்லையென்றும், உங்களோடு என் உடன்படிக்கையை ஏற்படுத்துகிறேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","மேலும் தேவன்: “எனக்கும் உங்களுக்கும், உங்களிடத்தில் இருக்கும் அனைத்து உயிரினங்களுக்கும், நித்திய தலை முறைகளுக்கென்று நான் செய்கிற உடன்படிக்கையின் அடையாளமாக: ");
INSERT INTO tam2017_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","நான் எனது வானவில்லை மேகத்தில் வைத்தேன்; அது எனக்கும் பூமிக்கும் உண்டான உடன்படிக்கைக்கு அடையாளமாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","நான் பூமிக்கு மேலாக மேகத்தை வரச்செய்யும்போது, அந்த வானவில் மேகத்தில் தோன்றும். ");
INSERT INTO tam2017_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","அப்பொழுது எல்லா உயிரினங்களையும் அழிக்க இனி தண்ணீரானது வெள்ளமாகப் பெருகாதபடி, எனக்கும் உங்களுக்கும் மாம்சமான அனைத்து உயிரினங்களுக்கும் உண்டான என் உடன்படிக்கையை நினைவுகூருவேன். ");
INSERT INTO tam2017_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","அந்த வானவில் மேகத்தில் தோன்றும்போது, தேவனுக்கும் பூமியின்மேலுள்ள அனைத்துவித உயிரினங்களுக்கும் உண்டான நித்திய உடன்படிக்கையை நான் நினைவுகூரும்படி அதைப் பார்ப்பேன். ");
INSERT INTO tam2017_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","இது எனக்கும், பூமியின்மேலுள்ள மாம்சமான அனைத்திற்கும் நான் ஏற்படுத்தின உடன்படிக்கையின் அடையாளம்” என்று நோவாவிடம் சொன்னார். ");
INSERT INTO tam2017_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","கப்பலிலிருந்து புறப்பட்ட நோவாவின் மகன்கள் சேம், காம், யாப்பேத் என்பவர்களே. காம் கானானுக்குத் தகப்பன். ");
INSERT INTO tam2017_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","இம்மூவரும் நோவாவின் மகன்கள்; இவர்களாலே பூமியெங்கும் மக்கள் பெருகினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","நோவா பயிரிடுகிறவனாகி, திராட்சைத்தோட்டத்தை நாட்டினான். ");
INSERT INTO tam2017_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","அவன் திராட்சைரசத்தைக் குடித்து வெறிகொண்டு, தன் கூடாரத்தில் ஆடை விலகிப் படுத்திருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","அப்பொழுது கானானுக்குத் தகப்பனாகிய காம், தன் தகப்பனுடைய நிர்வாணத்தைக் கண்டு, வெளியில் இருந்த தன் சகோதரர்கள் இருவருக்கும் சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","அப்பொழுது சேமும், யாப்பேத்தும் ஒரு ஆடையை எடுத்துத் தங்களுடைய தோள்களின்மேல் போட்டுக்கொண்டு, பின்முகமாக வந்து, தங்களுடைய தகப்பனின் நிர்வாணத்தை மூடினார்கள்; அவர்கள் எதிர்முகமாகப் போகாததால், தங்களுடைய தகப்பனின் நிர்வாணத்தைப் பார்க்கவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","நோவா திராட்சைரசத்தின் போதைதெளிந்து விழித்தபோது, தன் இளையமகன் தனக்குச் செய்ததை அறிந்து: ");
INSERT INTO tam2017_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","“கானான் சபிக்கப்பட்டவன், தன் சகோதாரர்களிடம் அடிமைகளுக்கு அடிமையாக இருப்பான்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","“சேமுடைய தேவனாகிய யெகோவாவிற்க்கு ஸ்தோத்திரம் உண்டாவதாக; கானான் அவனுக்கு அடிமையாக இருப்பான். ");
INSERT INTO tam2017_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","யாப்பேத்தை தேவன் பெருகச்செய்வார்; அவன் சேமுடைய கூடாரங்களில் குடியிருப்பான்; கானான் அவனுக்கு அடிமையாக இருப்பான்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","வெள்ளப்பெருக்கிற்குப் பிறகு நோவா 350 வருடங்கள் உயிரோடிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","நோவாவின் நாட்களெல்லாம் 950 வருடங்கள்; அவன் இறந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","நோவாவின் மகன்களாகிய சேம், காம், யாப்பேத் என்பவர்களின் வம்சவரலாறு: வெள்ளப்பெருக்குக்குப் பின்பு அவர்களுக்கு மகன்கள் பிறந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","யாப்பேத்தின் மகன்கள் கோமர், மாகோகு, மாதாய், யாவான், தூபால், மேசேக்கு, தீராஸ் என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","கோமரின் மகன்கள் அஸ்கினாஸ், ரீப்பாத்து, தொகர்மா என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","யாவானின் மகன்கள் எலீசா, தர்ஷீஸ், கித்தீம், தொதானீம் என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","இவர்களால் மத்திய தரைக்கடல் தீவுகள் அவனவன் மொழியினடிப்படையிலும், அவரவர்கள் கோத்திரத்தின்படியேயும், சந்ததியின்படியேயும் வெவ்வேறு தேசங்களாகப் பிரிக்கப்பட்டன. ");
INSERT INTO tam2017_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","காமுடைய மகன்கள் கூஷ், மிஸ்ராயீம், பூத், கானான் என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","கூஷூடைய மகன்கள் சேபா, ஆவிலா, சப்தா, ராமா, சப்திகா என்பவர்கள். ராமாவின் மகன்கள் சேபா, திதான் என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","கூஷ் நிம்ரோதைப் பெற்றெடுத்தான்; இவன் பூமியிலே பராக்கிரமசாலியானான். ");
INSERT INTO tam2017_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","இவன் யெகோவாவுக்கு முன்பாகப் பலத்த வேட்டைக்காரனாக இருந்தான்; ஆகையால், “யெகோவா முன்பாகப் பலத்த வேட்டைக்காரனான நிம்ரோதைப்போல” என்னும் வழக்கச்சொல் உண்டானது. ");
INSERT INTO tam2017_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","சிநெயார் தேசத்திலுள்ள பாபேல், ஏரேக், அக்காத், கல்னே என்னும் இடங்கள் அவன் ஆண்ட ராஜ்யத்திற்கு முதன்மையான இடங்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","அந்தத் தேசத்திலிருந்து அசூர் புறப்பட்டுப்போய், நினிவேயையும், ரெகொபோத் பட்டணத்தையும், காலாகையும், ");
INSERT INTO tam2017_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","நினிவேக்கும் காலாகுக்கும் நடுவாக ரெசேனையும் கட்டினான்; இது பெரிய பட்டணம். ");
INSERT INTO tam2017_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","மிஸ்ராயீம் லூதீமையும், அனாமீமையும், லெகாபீமையும், நப்தூகீமையும், ");
INSERT INTO tam2017_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","பத்ருசீமையும், பெலிஸ்தரின் சந்ததிக்குத் தலைவனாகிய கஸ்லூகிமையும், கப்தொரீமையும் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","கானான் தன் மூத்தமகனாகிய சீதோனையும், ஏத்தையும், ");
INSERT INTO tam2017_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","எபூசியர்களையும், எமோரியர்களையும், கிர்காசியர்களையும், ");
INSERT INTO tam2017_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ஈவியர்களையும், அர்கீரியர்களையும், சீனியர்களையும், ");
INSERT INTO tam2017_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","அர்வாதியர்களையும், செமாரியர்களையும், ஆமாத்தியர்களையும் பெற்றெடுத்தான்; பின்பு கானானியர்களின் வம்சத்தார்கள் எங்கும் பரவினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","கானானியர்களின் எல்லை சீதோன்முதல் கேரார் வழியாகக் காசாவரைக்கும், அங்கிருந்து சோதோம், கொமோரா, அத்மா, செபோயீம் வழியாக லாசாவரைக்கும் இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","இவர்களே தங்களுடைய தேசங்களிலும், மக்களிலுமுள்ள தங்களுடைய வம்சங்களின்படியேயும், மொழிகளின்படியேயும் காமுடைய சந்ததியினர். ");
INSERT INTO tam2017_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","சேமுக்கும் பிள்ளைகள் பிறந்தார்கள்; அவன் ஏபேருடைய சந்ததியினர் எல்லோருக்கும் தகப்பனும், மூத்தவனாகிய யாப்பேத்துக்குத் தம்பியுமாக இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","சேமுடைய மகன்கள் ஏலாம், அசூர், அர்பக்சாத், லூத், ஆராம் என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","ஆராமுடைய மகன்கள் ஊத்ஸ், கூல், கேத்தெர், மாஸ் என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","அர்பக்சாத் சாலாவைப் பெற்றெடுத்தான்; சாலா ஏபேரைப் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ஏபேருக்கு இரண்டு மகன்கள் பிறந்தார்கள்; ஒருவனுக்கு பேலேகு என்று பெயர்; ஏனெனில் அவனுடைய நாட்களில் பூமி பிரிக்கப்பட்டது; அவனுடைய சகோதரன் பெயர் யொக்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","யொக்தான் அல்மோதாதையும், சாலேப்பையும், அசர்மாவேத்தையும், யேராகையும், ");
INSERT INTO tam2017_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","அதோராமையும், ஊசாலையும், திக்லாவையும், ");
INSERT INTO tam2017_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ஓபாலையும், அபிமாவேலையும், சேபாவையும், ");
INSERT INTO tam2017_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ஓப்பீரையும், ஆவிலாவையும், யோபாபையும் பெற்றெடுத்தான்; இவர்கள் அனைவரும் யொக்தானுடைய மகன்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","இவர்களுடைய குடியிருப்பு மேசாதுவங்கி, கிழக்கேயுள்ள மலையாகிய செப்பாருக்குப் போகிற வழிவரைக்கும் இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","இவர்களே தங்களுடைய தேசங்களிலும், மக்களிலுமுள்ள தங்களுடைய வம்சங்களின்படியேயும், மொழிகளின்படியேயும் சேமுடைய சந்ததியினர். ");
INSERT INTO tam2017_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","தங்களுடைய மக்களிலுள்ள சந்ததிகளின்படியே நோவாவுடைய மகன்களின் வம்சங்கள் இவைகளே; வெள்ளப்பெருக்குக்குப் பிறகு இவர்களால் பூமியிலே மக்கள் பிரிந்தனர். ");
INSERT INTO tam2017_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","பூமியெங்கும் ஒரே மொழியும், ஒரே விதமான பேச்சும் இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","மக்கள் கிழக்கேயிருந்து பயணம்செய்யும்போது, சிநெயார் தேசத்தில் சமபூமியைக்கண்டு, அங்கே குடியிருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","அப்பொழுது அவர்கள்: “நாம் செங்கல் அறுத்து, அதை நன்றாகச் சுடுவோம் வாருங்கள்” என்று ஒருவரோடு ஒருவர் பேசிக்கொண்டார்கள்; கல்லுக்குப் பதிலாக செங்கலும், சாந்துக்குப் பதிலாக நிலக்கீலும் அவர்களுக்கு இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","பின்னும் அவர்கள்: “நாம் பூமியெங்கும் சிதறிப்போகாதபடி, நமக்கு ஒரு நகரத்தையும், வானத்தைத் தொடுமளவு ஒரு கோபுரத்தையும் கட்டி, நமக்குப் பெயர் உண்டாகச் செய்வோம் வாருங்கள்” என்று சொல்லிக்கொண்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","மனிதர்கள் கட்டுகிற நகரத்தையும் கோபுரத்தையும் பார்க்கிறதற்குக் யெகோவா இறங்கினார். ");
INSERT INTO tam2017_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","அப்பொழுது யெகோவா: “இதோ, மக்கள் ஒரே கூட்டமாக இருக்கிறார்கள்; அவர்கள் அனைவருக்கும் ஒரே மொழியும் இருக்கிறது; அவர்கள் இதைச் செய்யத்தொடங்கினார்கள்; இப்பொழுதும் தாங்கள் செய்ய நினைத்தது ஒன்றும் தடைபடாது என்று இருக்கிறார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","நாம் இறங்கிப்போய், ஒருவர் பேசுவதை மற்றொருவர் புரிந்துகொள்ளாதபடி, அங்கே அவர்கள் மொழியைத் தாறுமாறாக்குவோம்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","அப்படியே யெகோவா அவர்களை அந்த இடத்திலிருந்து பூமியெங்கும் சிதறிப்போகச் செய்தார்; அப்பொழுது நகரம் கட்டுவதை விட்டுவிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","பூமியெங்கும் பேசப்பட்ட மொழியைக் யெகோவா அந்த இடத்தில் தாறுமாறாக்கியதால், அதின் பெயர் பாபேல் எனப்பட்டது; யெகோவா அவர்களை அந்த இடத்திலிருந்து பூமியெங்கும் சிதறிப்போகச் செய்தார். ");
INSERT INTO tam2017_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","சேமுடைய வம்சவரலாறு: வெள்ளப்பெருக்கு ஏற்பட்டு 2 வருடங்களுக்குப் பிறகு, சேம் 100 வயதானபோது, அர்பக்சாத்தைப் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","சேம் அர்பக்சாத்தைப் பெற்றபின் 500 வருடங்கள் உயிரோடிருந்து மகன்களையும் மகள்களையும் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","அர்பக்சாத் 35 வயதானபோது சாலாவைப் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","சாலாவைப் பெற்றபின் அர்பக்சாத் 403 வருடங்கள் உயிரோடிருந்து மகன்களையும் மகள்களையும் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","சாலா 30 வயதானபோது ஏபேரைப் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ஏபேரைப் பெற்றபின் சாலா 403 வருடங்கள் உயிரோடிருந்து மகன்களையும் மகள்களையும் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ஏபேர் 34 வயதானபோது பேலேகைப் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","பேலேகைப் பெற்றபின் ஏபேர் 430 வருடங்கள் உயிரோடிருந்து மகன்களையும் மகள்களையும் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","பேலேகு 30 வயதானபோது ரெகூவைப் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ரெகூவைப் பெற்றபின் பேலேகு 209 வருடங்கள் உயிரோடிருந்து மகன்களையும் மகள்களையும் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","ரெகூ 32 வயதானபோது செரூகைப் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","செரூகைப் பெற்றபின் ரெகூ 207 வருடங்கள் உயிரோடிருந்து மகன்களையும் மகள்களையும் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","செரூகு முப்பது 30 நாகோரைப் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","நாகோரைப் பெற்றபின் செரூகு 200 வருடங்கள் உயிரோடிருந்து மகன்களையும் மகள்களையும் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","நாகோர் 29 வயதானபோது தேராகைப் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","தேராகைப் பெற்றபின் நாகோர் 119 வருடங்கள் உயிரோடிருந்து மகன்களையும் மகள்களையும் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","70 வயதானபோது ஆபிராம், நாகோர், ஆரான் என்பவர்களைப் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","தேராகுடைய வம்சவரலாறு: தேராகு ஆபிராம், நாகோர், ஆரான் என்பவர்களைப் பெற்றெடுத்தான்; ஆரான் லோத்தைப் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ஆரான் தன் பிறந்த இடமாகிய ஊர் என்கிற கல்தேயர் தேசத்துப் பட்டணத்திலே தன் தகப்பனாகிய தேராகு இறப்பதற்குமுன்னே இறந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","ஆபிராமும் நாகோரும் திருமணம் செய்தார்கள்; ஆபிராமுடைய மனைவிக்கு சாராய் என்று பெயர்; நாகோருடைய மனைவிக்கு மில்க்காள் என்று பெயர்; இவள் ஆரானுடைய மகள்; அந்த ஆரான் மில்க்காளுக்கும் இஸ்காளுக்கும் தகப்பன். ");
INSERT INTO tam2017_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","சாராய்க்குக் குழந்தையில்லை; மலடியாக இருந்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","தேராகு தன் மகனாகிய ஆபிராமையும், ஆரானுடைய மகனும், தன்னுடைய பேரனுமாயிருந்த லோத்தையும், ஆபிராமுடைய மனைவியாகிய தன்னுடைய மருமகள் சாராயையும் அழைத்துக்கொண்டு, அவர்களுடன் ஊர் என்கிற கல்தேயர்களுடைய பட்டணத்தைவிட்டு, கானான் தேசத்திற்குப் போகப் புறப்பட்டான்; அவர்கள் ஆரான்வரைக்கும் வந்தபோது, அங்கே தங்கிவிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","தேராகுடைய ஆயுசு நாட்கள் 205 வருடங்கள்; தேராகு ஆரானிலே இறந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","யெகோவா ஆபிராமை நோக்கி: “நீ உன் பிறந்த தேசத்தையும், உன் இனத்தையும், உன் தகப்பனுடைய வீட்டையும்விட்டுப் புறப்பட்டு, நான் உனக்குக் காண்பிக்கும் தேசத்திற்குப் போ. ");
INSERT INTO tam2017_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","நான் உன்னைப் பெரிய இனமாக்கி, உன்னை ஆசீர்வதித்து, உன் பெயரைப் பெருமைப்படுத்துவேன்; நீ ஆசீர்வாதமாக இருப்பாய். ");
INSERT INTO tam2017_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","உன்னை ஆசீர்வதிக்கிறவர்களை ஆசீர்வதிப்பேன், உன்னைச் சபிக்கிறவனைச் சபிப்பேன்; பூமியிலுள்ள வம்சங்களெல்லாம் உன்மூலம் ஆசீர்வதிக்கப்படும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","யெகோவா ஆபிராமுக்குச் சொன்னபடியே அவன் புறப்பட்டுப்போனான்; லோத்தும் அவனோடுகூடப் போனான். ஆபிராம் ஆரானைவிட்டுப் புறப்பட்டபோது, 75 வயதுள்ளவனாக இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ஆபிராம் தன் மனைவியாகிய சாராயையும், தன் சகோதரனுடைய மகனாகிய லோத்தையும், தாங்கள் சம்பாதித்திருந்த தங்கள் சொத்துக்கள் எல்லாவற்றையும், ஆரானிலே வாங்கியிருந்த மக்களையும் கூட்டிக்கொண்டு, அவர்கள் கானான் தேசத்திற்குப் புறப்பட்டுப்போய், கானான் தேசத்தைச் சென்றடைந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ஆபிராம் அந்த தேசத்தில் சுற்றித்திரிந்து சீகேம் என்னும் இடத்திற்கு அருகிலுள்ள மோரே என்னும் சமபூமிவரைக்கும் வந்தான்; அந்தக் காலத்திலே கானானியர்கள் அந்த தேசத்தில் இருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","யெகோவா ஆபிராமுக்குக் காட்சியளித்து: “உன் சந்ததிக்கு இந்த தேசத்தைக் கொடுப்பேன்” என்றார். அப்பொழுது அவன் தனக்குக் காட்சியளித்த யெகோவாவுக்கு அங்கே ஒரு பலிபீடத்தைக் கட்டினான். ");
INSERT INTO tam2017_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","பின்பு அவன் அந்த இடத்தைவிட்டு பெத்தேலுக்குக் கிழக்கே இருக்கும் மலைக்குப் போய், பெத்தேல் தனக்கு மேற்காகவும் ஆயீ கிழக்காகவும் இருக்கக் கூடாரம்போட்டு, அங்கே யெகோவாவுக்கு ஒரு பலிபீடத்தைக் கட்டி, யெகோவாவுடைய நாமத்தைத் தொழுதுகொண்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","அதற்குப் பிறகு ஆபிராம் புறப்பட்டு, தெற்கே பயணம் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","அந்த தேசத்திலே பஞ்சம் உண்டானது; தேசத்திலே பஞ்சம் கடுமையாக இருந்ததால், ஆபிராம் எகிப்து தேசத்திலே தங்குவதற்காக அந்த இடத்திற்குப் போனான். ");
INSERT INTO tam2017_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","அவன் எகிப்திற்கு அருகில் வந்தபோது, தன் மனைவி சாராயைப் பார்த்து: “நீ பார்ப்பதற்கு அழகுள்ள பெண் என்று எனக்குத் தெரியும். ");
INSERT INTO tam2017_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","எகிப்தியர்கள் உன்னைப் பார்க்கும்போது, நீ என்னுடைய மனைவி என்று சொல்லி, என்னைக் கொன்றுபோட்டு, உன்னை உயிரோடு வைப்பார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","ஆகையால், உன்னால் எனக்கு நன்மை உண்டாவதற்கும், உன்னாலே என் உயிர் பிழைப்பதற்கும், நீ உன்னை என்னுடைய சகோதரி என்று சொல்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","ஆபிராம் எகிப்திற்கு வந்தபோது, எகிப்தியர்கள் அந்தப் பெண்ணை மிகுந்த அழகுள்ளவளென்று கண்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","பார்வோனுடைய பிரபுக்களும் அவளைக்கண்டு, பார்வோனுக்கு முன்பாக அவளைப் புகழ்ந்தார்கள். அப்பொழுது அந்தப் பெண் பார்வோனுடைய அரண்மனைக்குக் கொண்டுபோகப்பட்டாள். ");
INSERT INTO tam2017_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","அவளால் அவன் ஆபிராமுக்குத் தயவு செய்தான்; அவனுக்கு ஆடுமாடுகளும், ஆண் கழுதைகளும், பெண் கழுதைகளும், வேலைக்காரர்களும், வேலைக்காரிகளும், ஒட்டகங்களும் கிடைத்தன. ");
INSERT INTO tam2017_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","ஆபிராமுடைய மனைவியாகிய சாராயிக்காகக் யெகோவா தேவன் பார்வோனையும், அவனுடைய வீட்டார்களையும் கொடிய வாதைகளால் வாதித்தார். ");
INSERT INTO tam2017_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","அப்பொழுது பார்வோன் ஆபிராமை அழைத்து: “நீ எனக்கு ஏன் இப்படிச் செய்தாய்? இவள் உன்னுடைய மனைவி என்று நீ எனக்குத் தெரிவிக்காமல் போனதென்ன? ");
INSERT INTO tam2017_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","இவளை உன்னுடைய சகோதரி என்று நீ ஏன் சொல்லவேண்டும்? இவளை நான் எனக்கு மனைவியாக்கிக் கொண்டிருப்பேனே; இதோ உன்னுடைய மனைவி; இவளை அழைத்துக்கொண்டுபோ” என்று சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","பார்வோன் அவனைக் குறித்துத் தன்னுடைய மனிதர்களுக்குக் கட்டளை கொடுத்தான்; அவர்கள் அவனையும், அவனுடைய மனைவியையும் அவனுக்கு உண்டான எல்லாவற்றையும் அனுப்பிவிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","ஆபிராமும், அவனுடைய மனைவியும், அவனுக்கு உண்டான அனைத்தும், அவனுடனே லோத்தும், எகிப்தை விட்டு தென்திசைக்கு வந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","ஆபிராம் மிருகஜீவன்களும் வெள்ளியும் பொன்னுமான சொத்துக்களையுடைய செல்வந்தனாக இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","அவன் தன்னுடைய பயணங்களில் தெற்கேயிருந்து பெத்தேல்வரைக்கும், பெத்தேலுக்கும் ஆயீக்கும் நடுவாகத் தான் முன்பு கூடாரம்போட்டதும், ");
INSERT INTO tam2017_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","தான் முதன்முதலில் ஒரு பலிபீடத்தை உண்டாக்கினதுமான இடம்வரைக்கும் போனான்; அங்கே ஆபிராம் யெகோவாவுடைய நாமத்தைத் தொழுதுகொண்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","ஆபிராமுடன் வந்த லோத்துக்கும் ஆடுமாடுகளும் ஜனங்களும் இருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","அவர்கள் ஒன்றாகக் குடியிருக்க அந்த இடம் அவர்களுக்குப் போதுமனதாக இல்லை; அவர்களுடைய சொத்துக்கள் அதிகமாக இருந்ததால், அவர்கள் ஒன்றாகக் குடியிருக்க வசதி இல்லாமற்போனது. ");
INSERT INTO tam2017_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ஆபிராமுடைய மேய்ப்பர்களுக்கும் லோத்துடைய மேய்ப்பர்களுக்கும் வாக்குவாதம் உண்டானது. அந்தக் காலத்தில் கானானியரும் பெரிசியரும் அந்த தேசத்தில் குடியிருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","ஆபிராம் லோத்தை நோக்கி: “எனக்கும் உனக்கும், என் மேய்ப்பருக்கும் உன் மேய்ப்பருக்கும் வாக்குவாதம் வேண்டாம்; நாம் சகோதரர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","இந்த தேசமெல்லாம் உனக்குமுன்பாக இருக்கிறது அல்லவா? நீ என்னைவிட்டுப் பிரிந்துபோகலாம்; நீ இடதுபுறம் போனால், நான் வலதுபுறம் போகிறேன்; நீ வலதுபுறம் போனால், நான் இடதுபுறம் போகிறேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","அப்பொழுது லோத்து சுற்றிலும் பார்த்து: யோர்தான் நதிக்கு அருகிலுள்ள சமபூமி முழுவதும் நீர்வளம் உள்ளதாக இருப்பதைக்கண்டான். யெகோவா சோதோமையும் கொமோராவையும் அழிக்கும்முன்னே, சோவாருக்குப் போகும் வழிவரைக்கும் அது யெகோவாவுடைய தோட்டத்தைப்போலவும் எகிப்து தேசத்தைப்போலவும் இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","அப்பொழுது லோத்து யோர்தானுக்கு அருகிலுள்ள சமபூமி முழுவதையும் தேர்ந்தெடுத்து, கிழக்கே புறப்பட்டுப்போனான். இப்படி அவர்கள் ஒருவரை ஒருவர் விட்டுப் பிரிந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","ஆபிராம் கானான் தேசத்தில் குடியிருந்தான்; லோத்து அந்த யோர்தானுக்கு அருகிலிருக்கும் சமபூமியிலுள்ள பட்டணங்களில் குடியிருந்து, சோதோமுக்குச் செல்லும் வழியில் கூடாரம் போட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","சோதோமின் மக்கள் பொல்லாதவர்களும் யெகோவாவுக்கு முன்பாக மகா பாவிகளுமாக இருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","லோத்து ஆபிராமைவிட்டுப் பிரிந்த பின்பு, யெகோவா ஆபிராமை நோக்கி: “உன் கண்களை ஏறெடுத்து, நீ இருக்கிற இடத்திலிருந்து வடக்கேயும், தெற்கேயும், கிழக்கேயும், மேற்கேயும் நோக்கிப் பார். ");
INSERT INTO tam2017_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","நீ பார்க்கிற இந்த பூமி முழுவதையும் நான் உனக்கும் உன் சந்ததிக்கும் என்றைக்கும் இருக்கும்படிக் கொடுத்து, ");
INSERT INTO tam2017_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","உன் சந்ததியை பூமியின் தூளைப்போலப் பெருகச்செய்வேன்; ஒருவன் பூமியின் தூளை எண்ணுவதற்கு முடியுமானால், உன் சந்ததியையும் எண்ணமுடியும். ");
INSERT INTO tam2017_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","நீ எழுந்து தேசத்தின் நீளமும் அகலமும் எதுவரையோ, அதுவரை நடந்து திரி; உனக்கு அதைத் தருவேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","அப்பொழுது ஆபிராம் கூடாரத்தைப் பெயர்த்துக்கொண்டுபோய், எபிரோனிலிருக்கும் மம்ரேயின் சமபூமிக்குப் போய் குடியிருந்து, அங்கே யெகோவாவுக்கு ஒரு பலிபீடத்தைக் கட்டினான். ");
INSERT INTO tam2017_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","சிநெயாரின் ராஜாவாகிய அம்ராப்பேலும், ஏலாசாரின் ராஜாவாகிய அரியோகும், ஏலாமின் ராஜாவாகிய கெதர்லா கோமேரும், கோயிமின் ராஜாவாகிய திதியாலும் இருந்த நாட்களில்; ");
INSERT INTO tam2017_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","அவர்கள் சோதோமின் ராஜாவாகிய பேராவோடும், கொமோராவின் ராஜாவாகிய பிர்சாவோடும், அத்மாவின் ராஜாவாகிய சிநெயாவோடும், செபோயீமின் ராஜாவாகிய செமேபரோடும், சோவார் என்னும் பேலாவின் ராஜாவோடும் யுத்தம் செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","இவர்கள் எல்லோரும் உப்புக்கடலாகிய சித்தீம் பள்ளத்தாக்கிலே கூடினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","இவர்கள் 12 வருடங்கள் கெதர்லாகோமேரைச் சேவித்து, 13 ஆம் வருடத்திலே கலகம் செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","14 ஆம் வருடத்திலே கெதர்லாகோமேரும், அவனோடு கூடியிருந்த ராஜாக்களும் வந்து, அஸ்தரோத்கர்னாயீமிலே இருந்த ரெப்பாயீமியரையும், காமிலே இருந்த சூசிமியரையும், சாவேகீரியத்தாயீமிலே இருந்த ஏமியரையும், ");
INSERT INTO tam2017_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","சேயீர் மலைகளில் இருந்த ஓரியரையும், வனாந்திரத்திற்கு அருகிலுள்ள எல்பாரான்வரை தோற்கடித்து, ");
INSERT INTO tam2017_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","திரும்பிக் காதேஸ் என்னும் என்மிஸ்பாத்துக்கு வந்து, அமலேக்கியர்களுடைய நாடு முழுவதையும், ஆசாசோன் தாமாரிலே குடியிருந்த எமோரியரையும் கூட அழித்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","அப்பொழுது சோதோமின் ராஜாவும், கொமோராவின் ராஜாவும், அத்மாவின் ராஜாவும், செபோயீமின் ராஜாவும், சோவார் என்னும் பேலாவின் ராஜாவும் புறப்பட்டு சித்தீம் பள்ளத்தாக்கிலே, ");
INSERT INTO tam2017_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ஏலாமின் ராஜாவாகிய கெதர்லாகோமேரோடும், கோயிமின் ராஜாவாகிய திதியாலோடும், சிநெயாரின் ராஜாவாகிய அம்ராப்பேலோடும், ஏலாசாரின் ராஜாவாகிய அரியோகோடும் யுத்தம்செய்யப் புறப்பட்டு, அந்த ஐந்து ராஜாக்களோடும் இந்த நான்கு ராஜாக்களும் யுத்தம் செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","அந்த சித்தீம் பள்ளத்தாக்கில் நிலக்கீல் உண்டாகும் கிணறுகள் இருந்தன. சோதோம் கொமோராவின் ராஜாக்கள் தோற்று ஓடி அங்கே விழுந்தார்கள்; மீதமுள்ளவர்கள் மலைகளுக்கு ஓடிப்போனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","அப்பொழுது அவர்கள் சோதோமிலும் கொமோராவிலுமுள்ள பொருட்கள் மற்றும் உணவுப்பொருட்கள் எல்லாவற்றையும் எடுத்துக்கொண்டு போய்விட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","ஆபிராமின் சகோதரனுடைய மகனாகிய லோத்து சோதோமிலே குடியிருந்ததால், அவனையும், அவனுடைய பொருட்களையும் கொண்டுபோய்விட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","தப்பியோடின ஒருவன் எபிரெயனாகிய ஆபிராமிடத்தில் வந்து அதைத் தெரிவித்தான்; ஆபிராம் தன்னுடன் உடன்படிக்கை செய்திருந்த மனிதர்களாகிய எஸ்கோலுக்கும், ஆநேருக்கும் சகோதரனாகிய மம்ரே என்னும் எமோரியனுடைய சமபூமியிலே அப்பொழுது குடியிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","தன் சகோதரன் சிறையாகக் கொண்டுபோகப்பட்டதை ஆபிராம் கேள்விப்பட்டபோது, அவன் தன் வீட்டிலே பிறந்த யுத்தப்பயிற்சி பெற்றவர்களாகிய 318 ஆட்களுக்கும் ஆயுதம் அணிவித்து, தாண் என்னும் ஊர்வரை அவர்களைத் தொடர்ந்துபோய், ");
INSERT INTO tam2017_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","இரவுநேரத்திலே அவனும், அவனுடைய வேலைக்காரரும் பிரிந்து, குழுக்களாக அவர்கள்மேல் விழுந்து, அவர்களைத் தோற்கடித்து, தமஸ்குவுக்கு இடதுபுறமான ஓபாவரைத் துரத்தி, ");
INSERT INTO tam2017_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","அனைத்து பொருட்களையும் திருப்பிக்கொண்டுவந்தான்; தன் சகோதரனாகிய லோத்தையும், அவனுடைய பொருட்களையும், பெண்களையும், மக்களையும் திருப்பிக்கொண்டுவந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","அவன் கெதர்லாகோமேரையும், அவனோடிருந்த ராஜாக்களையும் தோற்கடித்துத் திரும்பிவருகிறபோது, சோதோமின் ராஜா புறப்பட்டு, ராஜாவின் பள்ளத்தாக்கு என்னும் சாவே பள்ளத்தாக்குவரை அவனுக்கு எதிர்கொண்டுபோனான். ");
INSERT INTO tam2017_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","அன்றியும், உன்னதமான தேவனுடைய ஆசாரியனாயிருந்த சாலேமின் ராஜாவாகிய மெல்கிசேதேக்கு அப்பமும் திராட்சைரசமும் கொண்டுவந்து, ");
INSERT INTO tam2017_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","அவனை ஆசீர்வதித்து: “வானத்தையும் பூமியையும் உடையவராகிய உன்னதமான தேவனுடைய ஆசீர்வாதம் ஆபிராமுக்கு உண்டாவதாக. ");
INSERT INTO tam2017_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","உன் எதிரிகளை உன் கையில் ஒப்புக்கொடுத்த உன்னதமான தேவனுக்கு ஸ்தோத்திரம்” என்று சொன்னான். இவனுக்கு ஆபிராம் எல்லாவற்றிலும் தசமபாகம் கொடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","சோதோமின் ராஜா ஆபிராமை நோக்கி: “மக்களை எனக்குத் தாரும், பொருட்களை நீர் எடுத்துக்கொள்ளும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","அதற்கு ஆபிராம் சோதோமின் ராஜாவைப் பார்த்து; “ஆபிராமை செல்வந்தனாக்கினேன் என்று நீர் சொல்லாமலிருக்க நான் ஒரு நூலையாகிலும் காலணியின் வாரையாகிலும், உமக்கு உண்டானவைகளில் ஒன்றையாகிலும் எடுத்துக்கொள்ளமாட்டேன் என்று, ");
INSERT INTO tam2017_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","வானத்தையும் பூமியையும் உடையவராகிய உன்னதமான தேவனாகிய யெகோவாவுக்கு நேராக என் கையை உயர்த்துகிறேன். ");
INSERT INTO tam2017_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","வாலிபர்கள் சாப்பிட்டதுபோக, என்னுடன் வந்த ஆநேர், எஸ்கோல், மம்ரே என்னும் மனிதர்களுடைய பங்குமாத்திரமே வரவேண்டும்; இவர்கள் தங்களுடைய பங்குகளை எடுத்துக்கொள்ளட்டும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","இந்தக் காரியங்கள் நடந்தபின்பு, யெகோவாவுடைய வார்த்தை ஆபிராமுக்குத் தரிசனத்திலே உண்டாகி, அவர்: “ஆபிராமே, நீ பயப்படாதே; நான் உனக்குக் கேடகமும், உனக்கு மகா பெரிய பலனுமாக இருக்கிறேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","அதற்கு ஆபிராம்: “யெகோவா ஆண்டவரே, அடியேனுக்கு என்ன தருவீர்? நான் குழந்தையில்லாமல் இருக்கிறேனே; தமஸ்கு ஊரைச் சேர்ந்த இந்த எலியேசர் என் வீட்டைப் பராமரிக்கிறவனாக இருக்கிறானே” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","பின்னும் ஆபிராம்: “தேவரீர் எனக்கு வாரிசு அருளவில்லை; இதோ என் வீட்டிலே பிறந்த பிள்ளை எனக்கு வாரிசாக இருக்கிறான்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","அப்பொழுது யெகோவாவுடைய வார்த்தை அவனுக்கு உண்டாகி: “இவன் உனக்கு வாரிசு அல்ல, உனக்குப் பிறப்பவனே உனக்கு வாரிசு ஆவான்” என்று சொல்லி, ");
INSERT INTO tam2017_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","அவர் அவனை வெளியே அழைத்து: “நீ வானத்தை அண்ணாந்துபார், நட்சத்திரங்களை உன்னாலே எண்ணமுடியுமானால், அவைகளை எண்ணு என்று சொல்லி; பின்பு அவனை நோக்கி: “உன் சந்ததி இந்தவிதமாக இருக்கும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","அவன் யெகோவாவை விசுவாசித்தான், அதை அவர் அவனுக்கு நீதியாகக் கருதினார். ");
INSERT INTO tam2017_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","பின்னும் அவர் அவனை நோக்கி: “இந்த தேசத்தை உனக்குச் சொந்தமாகக் கொடுப்பதற்காக, உன்னை ஊர் என்கிற கல்தேயர்களுடைய பட்டணத்திலிருந்து அழைத்துவந்த யெகோவா நானே” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","அதற்கு அவன்: “யெகோவா ஆண்டவரே, நான் அதைச் சொந்தமாக்கிக்கொள்வேன் என்று எதினால் அறிவேன் என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","அதற்கு அவர்: “மூன்றுவயது இளங்கன்றையும், மூன்றுவயது வெள்ளாட்டையும், மூன்றுவயது ஆட்டுக்கடாவையும், ஒரு காட்டுப்புறாவையும், ஒரு புறாக்குஞ்சையும், என்னிடத்தில் கொண்டுவா” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","அவன் அவைகள் எல்லாவற்றையும் அவரிடத்தில் கொண்டுவந்து, அவைகளை நடுவாகத் துண்டித்து, இருபகுதிகளையும் ஒன்றுக்கொன்று எதிராக வைத்தான்; பறவைகளை அவன் துண்டிக்கவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","பறவைகள் அந்த உடல்களின்மேல் இறங்கின; அவைகளை ஆபிராம் துரத்தினான். ");
INSERT INTO tam2017_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","சூரியன் மறையும்போது, ஆபிராமுக்கு ஆழ்ந்த தூக்கம் வந்தது; பயமுண்டாக்கும் காரிருள் அவனை மூடிக்கொண்டது. ");
INSERT INTO tam2017_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","அப்பொழுது அவர் ஆபிராமை நோக்கி: உன் சந்ததியினர் தங்களுடையதல்லாத அந்நிய தேசத்திலே பரதேசிகளாக இருந்து, அந்த தேசத்தார்களுக்கு அடிமைகளாக இருப்பார்கள் என்றும், அவர்களால் 400 வருடங்கள் உபத்திரவப்படுவார்கள் என்றும், நீ நிச்சயமாக அறியவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","இவர்கள் அடிமையாக இருக்கும் தேசத்தை நான் நியாயந்தீர்ப்பேன்; பின்பு மிகுந்த பொருட்களுடனே புறப்பட்டு வருவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","நீ சமாதானத்தோடு உன் முன்னோர்களிடத்தில் சேருவாய்; நல்ல முதிர்வயதிலே அடக்கம்செய்யப்படுவாய். ");
INSERT INTO tam2017_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","நான்காம் தலை முறையிலே அவர்கள் இந்த இடத்திற்குத் திரும்ப வருவார்கள்; ஏனென்றால் எமோரியர்களுடைய அக்கிரமம் இன்னும் நிறைவாகவில்லை” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","சூரியன் மறைந்து காரிருள் உண்டானபின்பு, இதோ, புகைகிற சூளையும், அந்தத் துண்டுகளின் நடுவே கடந்துபோகிற அக்கினிஜூவாலையும் தோன்றின. ");
INSERT INTO tam2017_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","அந்த நாளிலே யெகோவா ஆபிராமோடு உடன்படிக்கைசெய்து, “எகிப்தின் நதிதுவங்கி ஐப்பிராத்து நதி என்னும் பெரிய நதிவரை உள்ளதும், ");
INSERT INTO tam2017_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","கேனியரும், கெனிசியரும், கத்மோனியரும், ");
INSERT INTO tam2017_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ஏத்தியரும், பெரிசியரும், ரெப்பாயீமியரும், ");
INSERT INTO tam2017_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","எமோரியரும், கானானியரும், கிர்காசியரும், எபூசியரும் என்பவர்கள் இருக்கிறதுமான இந்த தேசத்தை உன்னுடைய சந்ததிக்குக் கொடுத்தேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","ஆபிராமுடைய மனைவியாகிய சாராய்க்குக் குழந்தையில்லாமல் இருந்தது. எகிப்து தேசத்தைச் சேர்ந்த ஆகார் என்னும் பெயர்கொண்ட ஒரு அடிமைப்பெண் அவளுக்கு இருந்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","சாராய் ஆபிராமை நோக்கி: “நான் குழந்தைபெறாமலிருக்கக் யெகோவா என் கர்ப்பத்தை அடைத்திருக்கிறார்; என் அடிமைப்பெண்ணோடு சேரும், ஒருவேளை அவளால் என்னுடைய குடும்பம் கட்டப்படும்” என்றாள். சாராயின் வார்த்தையின்படி ஆபிராம் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","ஆபிராம் கானான்தேசத்தில் பத்து வருடங்கள் குடியிருந்தபின்பு, ஆபிராமின் மனைவியாகிய சாராய் எகிப்து தேசத்தாளான தன் அடிமைப்பெண்ணாகிய ஆகாரை அழைத்து, அவளைத் தன் கணவனாகிய ஆபிராமுக்கு மறுமனையாட்டியாகக் கொடுத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","அவன் ஆகாருடன் இணைந்தபோது, அவள் கர்ப்பந்தரித்தாள்; அவள், தான் கர்ப்பவதியானதைக் கண்டபோது, தன் எஜமானியை அற்பமாக நினைத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","அப்பொழுது சாராய் ஆபிராமை நோக்கி: “எனக்கு நேரிட்ட அநியாயம் உம்மேல் சுமரும்; என்னுடைய அடிமைப்பெண்ணை உம்முடைய மடியிலே கொடுத்தேன்; அவள் தான் கர்ப்பவதியானதைக் கண்டு என்னை அற்பமாக நினைக்கிறாள்; யெகோவா எனக்கும் உமக்கும் நடுநிலையாக நியாயந்தீர்ப்பாராக” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","அதற்கு ஆபிராம் சாராயை நோக்கி: “இதோ, உன் அடிமைப்பெண் உன் அதிகாரத்திற்குள் இருக்கிறாள்; உன் பார்வைக்கு நலமாகத் தோன்றுகிறபடி அவளுக்குச் செய் என்றான். அப்பொழுது சாராய் அவளைக் கடினமாக நடத்தியதால் அவள் அவளைவிட்டு ஓடிப்போனாள். ");
INSERT INTO tam2017_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","யெகோவாவுடைய தூதனானவர் அவளை வனாந்திரத்திலே சூருக்குப்போகிற வழியருகே இருக்கிற நீரூற்று அருகில் கண்டு: ");
INSERT INTO tam2017_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","“சாராயின் அடிமைப்பெண்ணாகிய ஆகாரே, எங்கேயிருந்து வருகிறாய்? எங்கே போகிறாய்? என்று கேட்டார்; அவள்: “நான் என் எஜமானியாகிய சாராயைவிட்டு ஓடிப்போகிறேன் என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","அப்பொழுது யெகோவாவுடைய தூதனானவர்: “நீ உன் எஜமானியிடத்திற்குத் திரும்பிப்போய், அவளுடைய அதிகாரத்திற்குள் அடங்கியிரு” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","பின்னும் யெகோவாவுடைய தூதனானவர் அவளை நோக்கி: “உன் சந்ததியை மிகவும் பெருகச்செய்வேன்; அது பெருகி, எண்ணிமுடியாததாக இருக்கும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","பின்னும் யெகோவாவுடைய தூதனானவர் அவளை நோக்கி: “நீ கர்ப்பவதியாக இருக்கிறாய், ஒரு மகனைப் பெற்றெடுப்பாய்; யெகோவா உன் அங்கலாய்ப்பைக் கேட்டதால், அவனுக்கு இஸ்மவேல் என்று பெயரிடுவாயாக. ");
INSERT INTO tam2017_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","அவன் கொடூரமான மனிதனாக இருப்பான்; அவனுடைய கை எல்லோருக்கும் விரோதமாகவும், எல்லோருடைய கையும் விரோதமாகவும் இருக்கும்; தன் சகோதரர்கள் எல்லோருக்கும் எதிராகக் குடியிருப்பான்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","அப்பொழுது அவள்: “என்னைக் காண்பவரை நானும் இந்த இடத்தில் கண்டேன் அல்லவா என்று சொல்லி, தன்னுடன் பேசின யெகோவாவுக்கு நீர் என்னைக்காண்கிற தேவன்” என்று பெயரிட்டாள். ");
INSERT INTO tam2017_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","ஆகையால், அந்தக் கிணற்றின் பெயர் லகாய்ரோயீ எனப்பட்டது; அது காதேசுக்கும் பேரேத்துக்கும் நடுவே இருக்கிறது. ");
INSERT INTO tam2017_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ஆகார் ஆபிராமுக்கு ஒரு மகனைப் பெற்றெடுத்தாள்; ஆபிராம் ஆகார் பெற்ற தன் மகனுக்கு இஸ்மவேல் பெயரிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","ஆகார் ஆபிராமுக்கு இஸ்மவேலைப் பெற்றெடுத்தபோது, ஆபிராம் 86 வயதாயிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","ஆபிராம் 99 வயதானபோது, யெகோவா ஆபிராமுக்குக் காட்சியளித்து: “நான் சர்வவல்லமையுள்ள தேவன்; நீ எனக்கு முன்பாக நடந்துகொண்டு உத்தமனாக இரு. ");
INSERT INTO tam2017_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","நான் உனக்கும் எனக்கும் நடுவாக என் உடன்படிக்கையை ஏற்படுத்தி, உன்னை மிகவும் திரளாகப் பெருகச்செய்வேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","அப்பொழுது ஆபிராம் முகங்குப்புற விழுந்து வணங்கினான். தேவன் அவனுடன் பேசி: ");
INSERT INTO tam2017_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“நான் உன்னுடன் செய்கிற என் உடன்படிக்கை என்னவென்றால், நீ திரளான தேசங்களுக்குத் தகப்பனாவாய். ");
INSERT INTO tam2017_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","இனி உன் பெயர் ஆபிராம் எனப்படாமல், நான் உன்னைத் திரளான தேசங்களுக்குத் தகப்பனாக ஏற்படுத்தியதால், உன் பெயர் ஆபிரகாம் எனப்படும். ");
INSERT INTO tam2017_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","உன்னை மிகவும் அதிகமாகப் பலுகச்செய்து, உன்னிலே தேசங்களை உண்டாக்குவேன்; உன்னிடத்திலிருந்து ராஜாக்கள் தோன்றுவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","உனக்கும் உனக்குப் பின்வரும் உன் சந்ததிக்கும் நான் தேவனாயிருப்பதற்காக எனக்கும் உனக்கும், உனக்குப்பின் தலை முறை தலை முறையாக வரும் உன் சந்ததிக்கும் நடுவே, என் உடன்படிக்கையை நித்திய உடன்படிக்கையாக நிலைப்படுத்துவேன். ");
INSERT INTO tam2017_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","நீ பரதேசியாகத் தங்கிவருகிற கானான் தேசம் முழுவதையும், உனக்கும் உனக்குப் பின்வரும் உன் சந்ததிக்கும் என்றென்றைக்கும் சொந்தமாகக் கொடுத்து, நான் அவர்களுக்குத் தேவனாக இருப்பேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","பின்னும் தேவன் ஆபிரகாமை நோக்கி: “இப்பொழுது நீயும், உனக்குப்பின் தலை முறை தலை முறையாக வரும் உன் சந்ததியும், என் உடன்படிக்கையைக் கைக்கொள்ளுங்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","எனக்கும் உங்களுக்கும், உனக்குப் பின்வரும் உன் சந்ததிக்கும் நடுவே உண்டாகிறதும், நீங்கள் கைக்கொள்ள வேண்டியதுமான என்னுடைய உடன்படிக்கை என்னவென்றால், உங்களுக்குள் பிறக்கும் அனைத்து ஆண்பிள்ளைகளும் விருத்தசேதனம் செய்யப்படவேண்டும்; ");
INSERT INTO tam2017_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","உங்கள் நுனித்தோலின் மாம்சத்தை விருத்தசேதனம் செய்யவேண்டும்; அது எனக்கும் உங்களுக்குமுள்ள உடன்படிக்கைக்கு அடையாளமாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","உங்களில் தலை முறை தலை முறையாகப் பிறக்கும் ஆண்பிள்ளைகளெல்லாம் எட்டாம் நாளிலே விருத்தசேதனம் செய்யப்படவேண்டும்; வீட்டிலே பிறந்த பிள்ளையும் உன் சந்ததியல்லாத அந்நியனிடத்தில் பணத்திற்கு வாங்கப்பட்ட எந்தப் பிள்ளையும், அப்படியே விருத்தசேதனம் செய்யப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","உன் வீட்டிலே பிறந்த பிள்ளையும், உன் பணத்திற்கு வாங்கப்பட்டவனும், விருத்தசேதனம் செய்யப்படவேண்டியது அவசியம்; இப்படி என்னுடைய உடன்படிக்கை உங்கள் சரீரத்திலே நித்திய உடன்படிக்கையாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","நுனித்தோலின் மாம்சம் விருத்தசேதனம் செய்யப்படாதிருக்கிற நுனித்தோலுள்ள ஆண்பிள்ளையாக இருந்தால், அந்த ஆத்துமா என்னுடைய உடன்படிக்கையை மீறினதால், தன் மக்களுடன் இல்லாதபடி நீக்கப்பட்டுப்போவான்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","பின்னும் தேவன் ஆபிரகாமை நோக்கி: “உன் மனைவி சாராயை இனி சாராய் என்று அழைக்காதே; சாராள் என்பது அவளுக்குப் பெயராக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","நான் அவளை ஆசீர்வதித்து, அவளாலே உனக்கு ஒரு மகனையும் தருவேன்; அவள் தேசங்களுக்குத் தாயாகவும், அவளாலே தேசங்களின் ராஜாக்கள் உண்டாகவும், அவளை ஆசீர்வதிப்பேன் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","அப்பொழுது ஆபிரகாம் முகங்குப்புற விழுந்து சிரித்து: “100 வயதானவனுக்குக் குழந்தை பிறக்குமோ? 90 வயதான சாராள் குழந்தை பெறுவாளோ? என்று தன் இருதயத்திலே சொல்லிக்கொண்டு, ");
INSERT INTO tam2017_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","“இஸ்மவேல் உமக்கு முன்பாகப் பிழைப்பானாக! என்று ஆபிரகாம் தேவனிடத்தில் விண்ணப்பம்செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","அப்பொழுது தேவன்: “உன் மனைவியாகிய சாராள் நிச்சயமாக உனக்கு ஒரு மகனைப் பெறுவாள், அவனுக்கு ஈசாக்கு என்று பெயரிடுவாயாக; என்னுடைய உடன்படிக்கையை அவனுக்கும் அவனுக்குப் பின்வரும் அவனுடைய சந்ததிக்கும் நித்திய உடன்படிக்கையாக நிலைப்படுத்துவேன். ");
INSERT INTO tam2017_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","இஸ்மவேலுக்காகவும் நீ செய்த விண்ணப்பத்தைக் கேட்டேன்; நான் அவனை ஆசீர்வதித்து, அவனை மிகவும் அதிகமாகப் பலுகவும் பெருகவும் செய்வேன்; அவன் பன்னிரண்டு கோத்திரத் தலைவர்களைப் பெறுவான்; அவனைப் பெரிய தேசமாக்குவேன். ");
INSERT INTO tam2017_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","வருகிற வருடத்தில் குறித்தகாலத்திலே சாராள் உனக்குப் பெறப்போகிற ஈசாக்கோடு நான் என்னுடைய உடன்படிக்கையை ஏற்படுத்துவேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","தேவன் ஆபிரகாமோடு பேசிமுடிந்தபின்பு, அவர் அவனைவிட்டுப் போனார். ");
INSERT INTO tam2017_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","அப்பொழுது ஆபிரகாம் தன் மகனாகிய இஸ்மவேலையும், தன் வீட்டில் பிறந்த அனைவரையும், தான் பணத்திற்கு வாங்கிய அனைவருமாகிய தன் வீட்டிலுள்ள ஆண்பிள்ளைகள் எல்லோரையும் சேர்த்து, தேவன் தனக்குச் சொன்னபடி, அவர்கள் நுனித்தோலின் மாம்சத்தை அந்த நாளிலேயே விருத்தசேதனம் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","ஆபிரகாமுடைய நுனித்தோலின் மாம்சம் விருத்தசேதனம் செய்யப்படும்போது, அவன் 99 வயதாக இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","அவனுடைய மகனாகிய இஸ்மவேலின் நுனித்தோலின் மாம்சம் விருத்தசேதனம் செய்யப்படும்போது, அவன் 13 வயதாக இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","ஒரே நாளில் ஆபிரகாமும் அவனுடைய மகன் இஸ்மவேலும் விருத்தசேதனம் செய்யப்பட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","வீட்டிலே பிறந்தவர்களும் அந்நியரிடத்திலே பணத்திற்கு வாங்கப்பட்டவர்களுமாகிய அவனுடைய வீட்டு மனிதர்கள் அனைவரும் அவனோடு விருத்தசேதனம் செய்யப்பட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","பின்பு யெகோவா மம்ரேயின் சமபூமியிலே அவனுக்குக் காட்சியளித்தார். அவன் பகலின் வெயில் நேரத்தில் கூடாரவாசலிலே உட்கார்ந்திருந்து, ");
INSERT INTO tam2017_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","தன் கண்களை ஏறெடுத்துப் பார்க்கும்போது, இதோ, மூன்று மனிதர்கள் அவனுக்கு எதிரே நின்றார்கள்; அவர்களைப் பார்த்தவுடனே, அவன் கூடாரவாசலிலிருந்து அவர்களுக்கு எதிர்கொண்டு ஓடித் தரைவரைக்கும் குனிந்து: ");
INSERT INTO tam2017_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","“ஆண்டவரே, உம்முடைய கண்களில் எனக்குக் கிருபை கிடைத்தால், நீர் உமது அடியேனைவிட்டுப் போகவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","கொஞ்சம் தண்ணீர் கொண்டுவருகிறேன், உங்கள் கால்களைக் கழுவி, மரத்தடியில் ஓய்வெடுத்துக்கொண்டிருங்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","நீங்கள் உங்கள் இருதயங்களைத் திடப்படுத்தக் கொஞ்சம் அப்பம் கொண்டுவருகிறேன்; பிறகு நீங்கள் உங்கள் வழியிலே போகலாம்; இதற்காகவே அடியேனுடைய இடம்வரைக்கும் வந்தீர்கள்” என்றான். அதற்கு அவர்கள்: “நீ சொன்னபடி செய்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","அப்பொழுது ஆபிரகாம் விரைவாகக் கூடாரத்தில் சாராளிடத்திற்குப் போய்: “நீ சீக்கிரமாக மூன்றுபடி மெல்லிய மாவு எடுத்துப் பிசைந்து, அப்பம் சுடு” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","ஆபிரகாம் மாட்டுமந்தைக்கு ஓடி, ஒரு நல்ல இளங்கன்றைப் பிடித்து, வேலைக்காரனுடைய கையில் கொடுத்தான்; அவன் அதைச் சீக்கிரத்தில் சமைத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ஆபிரகாம் வெண்ணெயையும் பாலையும் சமைக்கப்பட்ட கன்றையும் எடுத்து வந்து, அவர்களுக்கு முன்பாக வைத்து, அவர்கள் அருகே மரத்தடியில் நின்றுகொண்டிருந்தான்; அவர்கள் சாப்பிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","அவர்கள் அவனை நோக்கி: “உன் மனைவி சாராள் எங்கே” என்றார்கள். அதோ கூடாரத்தில் இருக்கிறாள் என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","அப்பொழுது அவர்: “ஒரு கர்ப்பகாலத்திட்டத்தில் நிச்சயமாக உன்னிடத்திற்குத் திரும்ப வருவேன்; அப்பொழுது உன் மனைவியாகிய சாராளுக்கு ஒரு மகன் இருப்பான்” என்றார். சாராள் அவருக்குப் பின்புறமாகக் கூடாரவாசலில் இதைக் கேட்டுக்கொண்டிருந்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","ஆபிரகாமும் சாராளும் வயது முதிர்ந்தவர்களாக இருந்தார்கள்; பெண்களுக்குரிய மாதவழிபாடு சாராளுக்கு நின்றுபோனது. ");
INSERT INTO tam2017_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","ஆகையால், சாராள் தன் உள்ளத்திலே சிரித்து: “நான் கிழவியும், என்னுடைய கணவன் முதிர்ந்த வயதுள்ளவருமாக இருக்கும்போது, எனக்கு இன்பம் உண்டாயிருக்குமோ” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","அப்பொழுது யெகோவா ஆபிரகாமை நோக்கி: “சாராள், நான் கிழவியாக இருக்கும்போது குழந்தைபெற்றெடுப்பது சாத்தியமோ என்று சொல்வதென்ன? ");
INSERT INTO tam2017_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","யெகோவாவால் ஆகாத காரியம் உண்டோ? கர்ப்பகாலத்திட்டத்தில் உன்னிடத்திற்குத் திரும்ப வருவேன்; அப்பொழுது சாராளுக்கு ஒரு மகன் இருப்பான்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","சாராள் பயந்து, நான் சிரிக்கவில்லை” என்று மறுத்தாள். அதற்கு அவர்: “இல்லை, நீ சிரித்தாய்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","பின்பு அந்த மனிதர்கள் எழுந்து அந்த இடத்தைவிட்டு, சோதோமை நோக்கிப் போனார்கள்; ஆபிரகாமும் அவர்களோடு போய் வழியனுப்பினான். ");
INSERT INTO tam2017_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","அப்பொழுது யெகோவா: “ஆபிரகாம் பெரிய பலத்த தேசமாவதாலும், அவனுக்குள் பூமியிலுள்ள அனைத்து தேசங்களும் ஆசீர்வதிக்கப்படுவதாலும், ");
INSERT INTO tam2017_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","நான் செய்யப்போகிறதை ஆபிரகாமுக்கு மறைப்பேனோ? ");
INSERT INTO tam2017_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","யெகோவா ஆபிரகாமுக்குச் சொன்னதை நிறைவேற்றுவதற்காக அவன் தன் பிள்ளைகளுக்கும், தனக்குப் பின்வரும் தன் வீட்டாருக்கும்: நீங்கள் நீதியையும் நியாயத்தையும் செய்து, யெகோவாவுடைய வழியைக் கைக்கொண்டு நடக்கவேண்டுமென்று கட்டளையிடுவான் என்பதை அறிந்திருக்கிறேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","பின்பு யெகோவா “சோதோம் கொமோராவைக்குறித்து ஏற்படும் கூக்குரல் பெரிதாக இருப்பதினாலும், அவைகளின் பாவம் மிகவும் கொடியதாக இருப்பதினாலும், ");
INSERT INTO tam2017_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","நான் இறங்கிப்போய், என்னிடத்தில் வந்து எட்டின அதின் கூக்குரலின்படியே அவர்கள் செய்திருக்கிறார்களோ இல்லையோ என்று பார்த்து அறிவேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","அப்பொழுது அந்த மனிதர்கள் அந்த இடத்தைவிட்டு சோதோமை நோக்கிப் போனார்கள்; ஆபிரகாமோ பின்னும் யெகோவாவுக்கு முன்பாக நின்றுகொண்டிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","அப்பொழுது ஆபிரகாம் அருகில் வந்து: “துன்மார்க்கனோடு நீதிமானையும் அழிப்பீரோ? ");
INSERT INTO tam2017_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","பட்டணத்திற்குள் ஒருவேளை ஐம்பது நீதிமான்கள் இருப்பார்கள், அங்கேயிருக்கும் அந்த ஐம்பது நீதிமான்களுக்காகக் காப்பாற்றாமல் அந்த இடத்தை அழிப்பீரோ? ");
INSERT INTO tam2017_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","துன்மார்க்கனோடு நீதிமானையும் அழிப்பது உமக்கு ஏற்றதல்ல; நீதிமானையும் துன்மார்க்கனையும் சமமாக நடத்துவது உமக்குத் தூரமாயிருப்பதாக; சர்வலோக நியாயாதிபதி நீதிசெய்யாமல் இருப்பாரோ” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","அதற்குக் யெகோவா: “நான் சோதோமில் ஐம்பது நீதிமான்களைக் கண்டால், அவர்களுக்காக அந்த இடம் முழுவதையும் காப்பாற்றுவேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","அப்பொழுது ஆபிரகாம் மறுமொழியாக: “இதோ, தூளும் சாம்பலுமாயிருக்கிற அடியேன் ஆண்டவரோடு பேசத்துணிந்தேன். ");
INSERT INTO tam2017_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","“ஒருவேளை ஐம்பது நீதிமான்களுக்கு ஐந்துபேர் குறைந்திருப்பார்கள்; அந்த ஐந்துபேருக்காக பட்டணம் முழுவதையும் அழிப்பீரோ” என்றான். அதற்கு அவர்: “நான் நாற்பத்தைந்து நீதிமான்களை அங்கே கண்டால், அதை அழிப்பதில்லை” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","அவன் பின்னும் அவரோடு பேசி: “நாற்பது நீதிமான்கள் அங்கே காணப்பட்டாலோ” என்றான். அதற்கு அவர்: “நாற்பது நீதிமான்களுக்காக அதை அழிப்பதில்லை” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","அப்பொழுது அவன்: “நான் இன்னும் பேசுகிறேன், ஆண்டவருக்குக் கோபம் வராமலிருப்பதாக; முப்பது நீதிமான்கள் அங்கே காணப்பட்டாலோ” என்றான். அதற்கு அவர்: “நான் முப்பது நீதிமான்களை அங்கே கண்டால், அதை அழிப்பதில்லை” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","அப்பொழுது அவன்: “இதோ, ஆண்டவரோடு பேசத்துணிந்தேன்; இருபது நீதிமான்கள் அங்கே காணப்பட்டாலோ” என்றான். அதற்கு அவர்: “இருபது நீதிமான்களுக்காக அதை அழிப்பதில்லை” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","அப்பொழுது அவன்: “ஆண்டவருக்குக் கோபம் வராமலிருப்பதாக; நான் இன்னும் இந்த ஒருமுறை மட்டும் பேசுகிறேன்; பத்து நீதிமான்கள் அங்கே காணப்பட்டாலோ என்றான். அதற்கு அவர்: “பத்து நீதிமான்களுக்காக அதை அழிப்பதில்லை” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","யெகோவா ஆபிரகாமோடு பேசி முடிந்தபின்பு போய்விட்டார்; ஆபிரகாமும் தன்னுடைய இடத்திற்குத் திரும்பினான். ");
INSERT INTO tam2017_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","அந்த இரண்டு தூதர்களும் சாயங்காலத்தில் சோதோமுக்கு வந்தார்கள். லோத்து சோதோமின் வாசலில் உட்கார்ந்திருந்தான். அவர்களைக் கண்டு, லோத்து எழுந்து எதிர்கொண்டு தரைவரைக்கும் குனிந்து: ");
INSERT INTO tam2017_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“ஆண்டவன்மார்களே, அடியேனுடைய வீட்டிற்கு நீங்கள் வந்து, உங்கள் கால்களைக் கழுவி, இரவில்தங்கி, காலையில் எழுந்து புறப்பட்டுப் போகலாம்” என்றான். அதற்கு அவர்கள்: “அப்படியல்ல, இரவில் வீதியிலே தங்குவோம்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","அவன் அவர்களை மிகவும் வருந்திக்கேட்டுக்கொண்டான்; அப்பொழுது அவனிடத்திற்குத் திரும்பி, அவனுடைய வீட்டிற்குச் சென்றார்கள். அவன் புளிப்பில்லாத அப்பங்களைச் சுட்டு, அவர்களுக்கு விருந்துசெய்தான், அவர்கள் சாப்பிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","அவர்கள் படுக்கும்முன்னே, சோதோம் பட்டணத்து மனிதர்களாகிய வாலிபர்கள்முதல் முதியவர்கள்வரையுள்ள மக்கள் அனைவரும் நான்கு திசைகளிலுமிருந்து வந்து, வீட்டைச் சூழ்ந்துகொண்டு, ");
INSERT INTO tam2017_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","லோத்தைக் கூப்பிட்டு: “இந்த இரவில் உன்னிடம் வந்த மனிதர்கள் எங்கே? நாங்கள் அவர்களுடன் உறவுகொள்ள அவர்களை எங்களிடம் வெளியே கொண்டுவா” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","அப்பொழுது லோத்து வாசலுக்கு வெளியே வந்து, தனக்குப் பின்னாலே கதவைப் பூட்டி, அவர்களிடம் போய்: ");
INSERT INTO tam2017_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“சகோதரர்களே, இந்த அக்கிரமத்தைச் செய்யவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","இதோ, கன்னிகைகளான இரண்டு மகள்கள் எனக்கு உண்டு; அவர்களை உங்களிடத்திற்கு வெளியே கொண்டுவருகிறேன், அவர்களுக்கு உங்களுடைய இஷ்டப்படி செய்யுங்கள்; இந்த மனிதர்கள் என்னுடைய கூரையின் நிழலிலே வந்ததால், இவர்களுக்கு மட்டும் ஒன்றும் செய்யவேண்டாம்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","அதற்கு அவர்கள்: “அப்பாலே போ; பரதேசியாக வந்த இவனா நியாயம் பேசுவது? இப்பொழுது அவர்களுக்குச் செய்வதைவிட உனக்கு அதிக பொல்லாப்புச் செய்வோம்” என்று சொல்லி, லோத்து என்பவனை மிகவும் நெருக்கிக் கதவை உடைக்க நெருங்கினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","அப்பொழுது அந்த மனிதர்கள் தங்கள் கைகளை வெளியே நீட்டி, லோத்தைத் தங்கள் பக்கம் வீட்டிற்குள் இழுத்துக்கொண்டு, கதவைப்பூட்டி, ");
INSERT INTO tam2017_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","தெருவாசலிலிருந்த சிறியோர்களும் பெரியோர்களுமாகிய மனிதர்களுக்குப் பார்வையற்றுப்போகச் செய்தார்கள்; அப்பொழுது அவர்கள் வாசலைத் தேடித்தேடி அலுத்துப்போனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","பின்பு அந்த மனிதர்கள் லோத்தை நோக்கி: “இந்த இடத்தில் இன்னும் உனக்கு யார் இருக்கிறார்கள்? உன்னுடைய மகன்களாவது, மகள்களாவது, மருமகன்களாவது பட்டணத்தில் உனக்குரியவர்கள் யாராவது இருந்தால், அவர்களை இந்த இடத்திலிருந்து வெளியே அழைத்துக்கொண்டு போ. ");
INSERT INTO tam2017_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","நாங்கள் இந்த இடத்தை அழிக்கப்போகிறோம்; இவர்களுக்கு எதிரான கூக்குரல் யெகோவாவுடைய சமூகத்தில் பெரிதாயிருக்கிறது; இதை அழிக்கக் யெகோவா எங்களை அனுப்பினார்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","அப்பொழுது லோத்து புறப்பட்டு, தன் மகள்களைத் திருமணம் செய்யப்போகிற தன் மருமகன்களோடு பேசி: “நீங்கள் எழுந்து இந்த இடத்தைவிட்டுப் புறப்படுங்கள்; யெகோவா இந்தப் பட்டணத்தை அழிக்கப்போகிறார்” என்றான்; அவனுடைய மருமகன்களின் பார்வைக்கு அவன் கேலிசெய்வதைப் போலிருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","விடியற்காலமானபோது அந்தத் தூதர்கள் லோத்தை நோக்கி: “பட்டணத்திற்கு வரும் தண்டனையில் நீ அழியாமலிருக்க எழுந்து, உன் மனைவியையும், இங்கே இருக்கிற உன் இரண்டு மகள்களையும் அழைத்துக்கொண்டுபோ” என்று சொல்லி, அவனை அவசரப்படுத்தினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","அவன் தாமதித்துக்கொண்டிருக்கும்போது, யெகோவா அவன்மேல் வைத்த இரக்கத்தினாலே, அந்த மனிதர்கள் அவனுடைய கையையும், அவனுடைய மனைவியின் கையையும், அவனுடைய இரண்டு மகள்களின் கையையும் பிடித்து, அவர்களைப் பட்டணத்திற்கு வெளியே கொண்டுபோய் விட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","அவர்களை வெளியே கொண்டுபோய்விட்டபின்பு, அவர்: “உன் உயிர் தப்ப ஓடிப்போ, திரும்பிப் பார்க்காதே; இந்தச் சமபூமியில் எங்கும் நிற்காதே; நீ அழியாமலிருக்க மலைக்கு ஓடிப்போ” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","அதற்கு லோத்து: “அப்படியல்ல ஆண்டவரே, ");
INSERT INTO tam2017_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","உமது கண்களில் உமது அடியேனுக்குக் கிருபை கிடைத்ததே; என்னுடைய உயிரைக் காக்கத் தேவரீர் எனக்குச் செய்த கிருபையைப் பெரிதாக தெரியச்செய்தீர்; மலைக்கு ஓடிப்போக என்னால் முடியாது, தீங்கு என்னைத் தொடரும், நான் இறந்துபோவேன். ");
INSERT INTO tam2017_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","அதோ, அந்த ஊர் இருக்கிறதே, நான் அங்கு ஓடிப்போக அது அருகில் இருக்கிறது, சிறியதாகவும் இருக்கிறது; என் உயிர்பிழைக்க நான் அங்கே ஓடிப்போகட்டும், அது சின்ன ஊர்தானே” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","அதற்கு அவர்: “நீ கேட்டுக்கொண்ட ஊரை நான் கவிழ்த்துப்போடாதபடி, இந்த விஷயத்திலும் உனக்கு தயவுசெய்தேன். ");
INSERT INTO tam2017_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","விரைவாக அங்கே ஓடித் தப்பித்துக்கொள்; நீ அங்கே போய்ச் சேரும்வரை நான் ஒன்றும் செய்யமுடியாது” என்றார்; ஆகையால் அந்த ஊர் சோவார் எனப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","லோத்து சோவாருக்குள் வரும்போது பூமியின்மேல் சூரியன் உதித்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","அப்பொழுது யெகோவா சோதோமின் மேலும் கொமோராவின்மேலும், யெகோவாவாலே வானத்திலிருந்து கந்தகத்தையும் அக்கினியையும் பொழியச்செய்து, ");
INSERT INTO tam2017_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","அந்தப் பட்டணங்களையும், அந்தச் சமபூமியனைத்தையும், அந்தப் பட்டணங்களின் அனைத்து மக்களையும், பூமியின் பயிரையும் அழித்துப்போட்டார். ");
INSERT INTO tam2017_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","அவனுடைய மனைவியோ திரும்பிப்பார்த்து, உப்புத்தூண் ஆனாள். ");
INSERT INTO tam2017_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","விடியற்காலத்தில் ஆபிரகாம் எழுந்து தான் யெகோவாவுக்கு முன்பாக நின்ற இடத்திற்குப் போய், ");
INSERT INTO tam2017_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","சோதோம் கொமோரா பட்டணங்களின் திசையையும், சமபூமியாகிய தேசம் முழுவதையும் நோக்கிப் பார்த்தான்; அந்தப் பூமியின் புகை, சூளையின் புகையைப்போல எழும்பினது. ");
INSERT INTO tam2017_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","தேவன் அந்தச் சமபூமியின் பட்டணங்களை அழிக்கும்போது, தேவன் ஆபிரகாமை நினைத்து, லோத்து குடியிருந்த பட்டணங்களைத் தாம் கவிழ்த்துப்போடும்போது, லோத்தை அந்த அழிவிலிருந்து தப்பிச்செல்லும்படி அனுப்பிவிட்டார். ");
INSERT INTO tam2017_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","பின்பு லோத்து சோவாரிலே குடியிருக்கப் பயந்து, சோவாரை விட்டுப்போய், அவனும் அவனோடுகூட அவனுடைய இரண்டு மகள்களும் மலையிலே தங்கினார்கள்; அங்கே அவனும் அவனுடைய இரண்டு மகள்களும் ஒரு குகையிலே குடியிருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","அப்பொழுது மூத்தவள் இளையவளைப் பார்த்து: “நம்முடைய தகப்பன் முதிர்வயதானார், பூமியெங்கும் நடக்கிற முறைமையின்படியே நம்மோடு இணைய பூமியிலே ஒரு மனிதனும் இல்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","நம்முடைய தகப்பனால் சந்ததி உண்டாக, அவருக்கு மதுவைக் குடிக்கக்கொடுத்து, அவரோடு உறவுகொள்வோம் வா” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","அப்படியே அன்று இரவிலே, தங்கள் தகப்பனுக்கு மதுவைக் குடிக்கக் கொடுத்தார்கள். மூத்தவள் போய், தன் தகப்பனோடு உறவுகொண்டாள்: அவள் உறவுகொண்டதையும் எழுந்திருந்ததையும் அவன் உணராதிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","மறுநாளிலே மூத்தவள் இளையவளைப் பார்த்து: “நேற்று ராத்திரி நான் தகப்பனோடு உறவுகொண்டேன்; இன்று இரவும் மதுவைக் குடிக்கக்கொடுப்போம், நம்முடைய தகப்பனால் சந்ததி உண்டாகும்படி நீயும் போய் அவரோடு உறவுகொள்” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","அப்படியே அன்று இரவிலும் தங்கள் தகப்பனுக்கு மதுவைக் குடிக்கக் கொடுத்தார்கள். அப்பொழுது இளையவள் எழுந்துபோய், அவனோடு உறவுகொண்டாள்; அவள் உறவுகொண்டதையும் எழுந்திருந்ததையும் அவன் உணராதிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","இந்த விதமாக லோத்தின் மகள்கள் இருவரும் தங்கள் தகப்பனாலே கர்ப்பவதியானார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","மூத்தவள் ஒரு மகனைப்பெற்று, அவனுக்கு மோவாப் என்று பெயரிட்டாள்; அவன் இந்த நாள்வரைக்கும் இருக்கிற மோவாபியருக்குத் தகப்பன். ");
INSERT INTO tam2017_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","இளையவளும் ஒரு மகனைப்பெற்று, அவனுக்குப் பென்னம்மி என்று பெயரிட்டாள்; அவன் இந்த நாள்வரைக்கும் இருக்கிற அம்மோன் வம்சத்தாருக்குத் தகப்பன். ");
INSERT INTO tam2017_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ஆபிரகாம் அந்த இடத்தைவிட்டு, தென்தேசத்திற்குப் பயணம் செய்து, காதேசுக்கும் சூருக்கும் நடுவாகக் குடியேறி, கேராரிலே தங்கினான். ");
INSERT INTO tam2017_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","அங்கே ஆபிரகாம் தன் மனைவியாகிய சாராளைத் “தன் சகோதரி” என்று சொன்னதால், கேராரின் ராஜாவாகிய அபிமெலேக்கு ஆள் அனுப்பி சாராளை வரவழைத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","தேவன் இரவிலே அபிமெலேக்குக்குக் கனவிலே தோன்றி: “நீ வரவழைத்த பெண்ணால் நீ செத்தாய்; அவள் ஒருவனுடைய மனைவியாக இருக்கிறாளே” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","அபிமெலேக்கு அவளுடன் இணையாதிருந்தான். ஆகையால் அவன்: “ஆண்டவரே, நீதியுள்ள மக்களை அழிப்பீரோ? ");
INSERT INTO tam2017_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","இவள் தன் சகோதரி” என்று அவன் என்னிடம் சொல்லவில்லையா? அவன் தன் சகோதரன் என்று இவளும் சொன்னாளே; உத்தம இருதயத்தோடும் சுத்தமான கைகளோடும் இதைச் செய்தேன் என்று சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","அப்பொழுது தேவன்: “உத்தம இருதயத்தோடு நீ இதைச் செய்தாய் என்று நான் அறிந்திருக்கிறேன்; நீ எனக்கு விரோதமாகப் பாவம் செய்யாமலிருக்க உன்னைத் தடுத்தேன்; ஆகையால், நீ அவளைத் தொட நான் உனக்கு இடங்கொடுக்கவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","அந்த மனிதனுடைய மனைவியை அவனிடத்திற்கு அனுப்பிவிடு; அவன் ஒரு தீர்க்கதரிசி; நீ பிழைப்பதற்கு அவன் உனக்காக வேண்டுதல் செய்வான்; நீ அவளை அனுப்பிவிடாதிருந்தால், நீயும் உன்னைச் சார்ந்த அனைவரும் சாகவே சாவீர்கள் என்று அறிந்துகொள்” என்று கனவிலே அவனுக்குச் சொன்னார். ");
INSERT INTO tam2017_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","அபிமெலேக்கு அதிகாலையில் எழுந்து, தன் வேலைக்காரரையெல்லாம் வரவழைத்து, இந்தச் செய்திகளையெல்லாம் அவர்கள் கேட்கும்படி சொன்னான்; அந்த மனிதர் மிகவும் பயந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","அப்பொழுது அபிமெலேக்கு ஆபிரகாமை வரவழைத்து: “நீ எங்களுக்கு என்ன காரியம் செய்தாய், நீ என்மேலும், என்னுடைய ராஜ்ஜியத்தின்மேலும் பெரும்பாவம் சுமரச் செய்வதற்கு உனக்கு நான் என்ன குற்றம் செய்தேன்? செய்யத்தகாத காரியங்களை என்னிடத்தில் செய்தாயே என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","பின்னும் அபிமெலேக்கு ஆபிரகாமை நோக்கி: “எதைக் கண்டு நீ இந்தக் காரியத்தைச் செய்தாய்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","அதற்கு ஆபிரகாம்: “இந்த இடத்தில் தெய்வபயம் இல்லையென்றும், என் மனைவியின்பொருட்டு என்னைக் கொன்றுபோடுவார்கள் என்றும் நான் நினைத்தேன். ");
INSERT INTO tam2017_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","அவள் என்னுடைய சகோதரி என்பதும் உண்மைதான்; அவள் என் தகப்பனுக்கு மகள், என் தாய்க்கு மகளல்ல; அவள் எனக்கு மனைவியானாள். ");
INSERT INTO tam2017_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","என் தகப்பன் வீட்டைவிட்டு தேவன் என்னைத் நாடோடியாகத் திரியச்செய்தபோது, நான் அவளை நோக்கி: நாம் போகும் இடமெங்கும், நீ என்னைச் சகோதரன் என்று சொல்வது நீ எனக்குச் செய்யவேண்டிய தயை என்று அவளிடத்தில் சொல்லியிருந்தேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","அப்பொழுது அபிமெலேக்கு ஆடுமாடுகளையும், வேலைக்காரரையும், வேலைக்காரிகளையும் ஆபிரகாமுக்குக் கொடுத்து, அவனுடைய மனைவியாகிய சாராளையும் அவனிடத்தில் திரும்ப ஒப்புவித்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","பின்னும் அபிமெலேக்கு: இதோ, “என் தேசம் உனக்கு முன்பாக இருக்கிறது; உன் பார்வைக்கு விருப்பமான இடத்தில் குடியிரு” என்று சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","பின்பு சாராளை நோக்கி: “உன் சகோதரனுக்கு ஆயிரம் வெள்ளிக்காசு கொடுத்தேன்; இதோ, உன்னோடிருக்கிற எல்லோருக்கும் முன்பாகவும், மற்ற அனைவருக்கும் முன்பாகவும், இது உன் முகத்தின் முக்காட்டுக்காக” என்றான்; இப்படி அவள் கடிந்துகொள்ளப்பட்டாள். ");
INSERT INTO tam2017_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","ஆபிரகாமுடைய மனைவியாகிய சாராளுக்காக யெகோவா அபிமெலேக்குடைய வீட்டாரின் கர்ப்பங்களையெல்லாம் அடைத்திருந்ததால், ");
INSERT INTO tam2017_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","ஆபிரகாம் தேவனை நோக்கி வேண்டிக்கொண்டான்; அப்பொழுது தேவன் அபிமெலேக்கையும், அவனுடைய மனைவியையும், வேலைக்காரிகளையும் குணமாக்கி, குழந்தைபெறும்படி தயவு செய்தார். ");
INSERT INTO tam2017_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","யெகோவா தாம் சொல்லியிருந்தபடி சாராளைக் கண்ணோக்கினார்; யெகோவா தாம் வாக்களித்தபடியே சாராளுக்குச் செய்தருளினார். ");
INSERT INTO tam2017_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","ஆபிரகாம் முதிர்வயதாக இருக்கும்போது, சாராள் கர்ப்பவதியாகி, தேவன் குறித்திருந்த காலத்தில் அவனுக்கு ஒரு மகனைப் பெற்றெடுத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","அப்பொழுது ஆபிரகாம் தனக்கு சாராள் பெற்ற மகனுக்கு ஈசாக்கு என்று பெயரிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","தன் மகனாகிய ஈசாக்கு பிறந்த எட்டாம் நாளில், ஆபிரகாம் தனக்குத் தேவன் கட்டளையிட்டிருந்தபடி அவனுக்கு விருத்தசேதனம் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","தன் மகனாகிய ஈசாக்கு பிறந்தபோது ஆபிரகாம் 100 வயதாயிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","அப்பொழுது சாராள்: “தேவன் என்னை மகிழச்செய்தார்; இதைக்கேட்கிற அனைவரும் என்னோடுகூட மகிழ்வார்கள்.” ");
INSERT INTO tam2017_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","“சாராள் குழந்தைகளுக்குப் பால்கொடுப்பாள் என்று ஆபிரகாமுக்கு யார் சொல்லுவான்? அவருடைய முதிர்வயதிலே அவருக்கு ஒரு மகனைப் பெற்றேனே” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","குழந்தை வளர்ந்து, பால் மறந்தது; ஈசாக்கு பால் மறந்த நாளிலே ஆபிரகாம் பெரிய விருந்து செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","பின்பு எகிப்து தேசத்தைச் சேர்ந்த ஆகார் ஆபிரகாமுக்குப் பெற்ற மகன் கேலி செய்கிறதை சாராள் கண்டு, ");
INSERT INTO tam2017_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ஆபிரகாமை நோக்கி: “இந்த அடிமைப்பெண்ணையும் அவளுடைய மகனையும் துரத்திவிடும்; இந்த அடிமைப்பெண்ணின் மகன் என் மகனாகிய ஈசாக்கோடு வாரிசாக இருப்பதில்லை” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","தன் மகனைக்குறித்துச் சொல்லப்பட்ட இந்தக் காரியம் ஆபிரகாமுக்கு மிகவும் துக்கமாக இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","அப்பொழுது தேவன் ஆபிரகாமை நோக்கி: “அந்தச் சிறுவனையும், உன் அடிமைப்பெண்ணையும் குறித்துச் சொல்லப்பட்டது உனக்குத் துக்கமாக இருக்கவேண்டாம்; ஈசாக்கின் வழியாக உன் சந்ததி தோன்றும்; ஆகவே சாராள் உனக்குச் சொல்வதெல்லாவற்றையும் கேள். ");
INSERT INTO tam2017_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","அடிமைப்பெண்ணின் மகனும் உன் வித்தாக இருப்பதால், அவனையும் ஒரு தேசமாக்குவேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","ஆபிரகாம் அதிகாலையில் எழுந்து, அப்பத்தையும் ஒரு தோல்பையில் தண்ணீரையும் எடுத்து, ஆகாருடைய தோளின்மேல் வைத்து, சிறுவனையும் ஒப்படைத்து, அவளை அனுப்பிவிட்டான்; அவள் புறப்பட்டுப்போய், பெயர்செபாவின் வனாந்திரத்திலே அலைந்து திரிந்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","தோல்பையிலிருந்த தண்ணீர் தீர்ந்தபின்பு, அவள் சிறுவனை ஒரு செடியின் கீழே விட்டு, ");
INSERT INTO tam2017_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","“சிறுவன் தாகத்தினால் சாகிறதை நான் பார்க்கமாட்டேன்” என்று, அவனைவிட்டு அம்பு பாயும் தூரத்திலே போய் உட்கார்ந்து சத்தமிட்டு அழுதாள். ");
INSERT INTO tam2017_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","தேவன் சிறுவனின் சத்தத்தைக் கேட்டார்; தேவதூதன் வானத்திலிருந்து ஆகாரைக் கூப்பிட்டு: “ஆகாரே, உனக்கு என்ன சம்பவித்தது, பயப்படாதே, சிறுவன் இருக்கும் இடத்தில் தேவன் அவனுடைய சத்தத்தைக் கேட்டார். ");
INSERT INTO tam2017_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","நீ எழுந்து சிறுவனை எடுத்து அவனை உன் கையினால் பிடித்துக்கொண்டுபோ, அவனைப் பெரிய தேசமாக்குவேன் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","தேவன் அவளுடைய கண்களைத் திறந்தார்; அப்பொழுது அவள் ஒரு கிணற்றைக் கண்டு, போய், தோல்பையில் தண்ணீரை நிரப்பி, சிறுவனுக்குக் குடிக்கக் கொடுத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","தேவன் சிறுவனுடனே இருந்தார்; அவன் வளர்ந்து வனாந்திரத்திலே குடியிருந்து வில்வித்தையிலே வல்லவனானான். ");
INSERT INTO tam2017_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","அவன் பாரான் வனாந்திரத்திலே குடியிருக்கும்போது, அவனுடைய தாய் எகிப்து தேசத்தைச் சேர்ந்த ஒரு பெண்ணை அவனுக்குத் திருமணம் செய்துவைத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","அந்தகாலத்தில் அபிமெலேக்கும் அவனுடைய படைத்தலைவனாகிய பிகோலும் ஆபிரகாமை நோக்கி: “நீ செய்கிற காரியங்கள் எல்லாவற்றிலும் தேவன் உன்னுடனே இருக்கிறார். ");
INSERT INTO tam2017_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","ஆகையால், நீ எனக்காவது, என் மகனுக்காவது, பேரனுக்காவது வஞ்சனை செய்யாமல், நான் உனக்குச் செய்த தயவின்படியே, நீ எனக்கும், நீ தங்கியிருக்கிற இந்தத் தேசத்திற்கும், தயவு செய்வேன் என்று இங்கே தேவன் பேரில் எனக்கு ஆணையிட்டுக்கொடு” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","அதற்கு ஆபிரகாம்: “நான் ஆணையிட்டுக்கொடுக்கிறேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","ஆனாலும், அபிமெலேக்குடைய வேலைக்காரர்கள் கைப்பற்றிக்கொண்ட கிணற்றிற்காக ஆபிரகாம் அபிமெலேக்கைக் கடிந்துகொண்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","அதற்கு அபிமெலேக்கு: “இந்தக் காரியத்தைச் செய்தவன் யார் என்று எனக்குத் தெரியாது, நீயும் எனக்குத் தெரிவிக்கவில்லை; இன்று நான் அதைக் கேட்டதைத்தவிர, இதற்குமுன் அதை நான் கேள்விப்படவே இல்லை” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","அப்பொழுது ஆபிரகாம் ஆடுமாடுகளைக் கொண்டுவந்து அபிமெலேக்குக்குக் கொடுத்தான்; அவர்கள் இருவரும் உடன்படிக்கை செய்துகொண்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","ஆபிரகாம் ஏழு பெண்ணாட்டுக்குட்டிகளைத் தனியே நிறுத்தினான். ");
INSERT INTO tam2017_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","அப்பொழுது அபிமெலேக்கு ஆபிரகாமை நோக்கி: “நீ தனியே நிறுத்தின இந்த ஏழு பெண்ணாட்டுக்குட்டிகள் எதற்கு?” என்று கேட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","அதற்கு அவன்: “நான் இந்தக் கிணறு தோண்டியதைக்குறித்து, நீர் சாட்சியாக இந்த ஏழு பெண்ணாட்டுக்குட்டிகளை என் கையில் பெற்றுக்கொள்ளவேண்டும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","அவர்கள் இருவரும் அந்த இடத்தில் ஆணையிட்டுக்கொண்டதால், அந்த இடம் பெயெர்செபா எனப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","அவர்கள் பெயெர்செபாவிலே உடன்படிக்கை செய்துகொண்டபின்பு அபிமெலேக்கும், அவனுடைய படைத்தலைவனாகிய பிகோலும் எழுந்து பெலிஸ்தருடைய தேசத்திற்குத் திரும்பிப்போனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","ஆபிரகாம் பெயெர்செபாவிலே ஒரு தோப்பை உண்டாக்கி, சதாகாலமுமுள்ள தேவனாகிய யெகோவாவுடைய நாமத்தை அந்த இடத்தில் தொழுதுகொண்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ஆபிரகாம் பெலிஸ்தருடைய தேசத்தில் அநேகநாட்கள் தங்கியிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","இந்தக் காரியங்கள் நடந்தபின்பு, தேவன் ஆபிரகாமைச் சோதித்தார்; எப்படியென்றால், அவர் அவனை நோக்கி: “ஆபிரகாமே” என்றார்; அவன்: “இதோ அடியேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","அப்பொழுது அவர்: “உன் மகனும், உனது ஒரேமகனும், உனக்குப் பிரியமான மகனுமாகிய ஈசாக்கை நீ இப்பொழுது அழைத்துக்கொண்டு, மோரியா தேசத்திற்குப் போய், அங்கே நான் உனக்குச் சொல்லும் மலைகள் ஒன்றின்மேல் அவனைத் தகனபலியாகப் பலியிடு” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","ஆபிரகாம் அதிகாலையில் எழுந்து, தன் கழுதையின்மேல் சேணங்கட்டி, தன் வேலைக்காரர்களில் இரண்டுபேரையும் தன் மகன் ஈசாக்கையும் கூட்டிக்கொண்டு, தகனபலிக்கு விறகுகளையும் எடுத்துக்கொண்டு, தேவன் தனக்குக் குறித்திருந்த இடத்திற்குப் புறப்பட்டுப்போனான். ");
INSERT INTO tam2017_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","மூன்றாம் நாளில் ஆபிரகாம் தன் கண்களை ஏறெடுத்துப்பார்த்து, தூரத்திலே அந்த இடத்தைக் கண்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","அப்பொழுது ஆபிரகாம் தன் வேலைக்காரர்களை நோக்கி: “நீங்கள் கழுதையுடன் இங்கே காத்திருங்கள், நானும் சிறுவனும் அந்த இடத்திற்குப் போய், தொழுதுகொண்டு, உங்களிடத்திற்குத் திரும்பி வருவோம்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","ஆபிரகாம் தகனபலிக்கு விறகுகளை எடுத்து, தன் மகனாகிய ஈசாக்கின்மேல் வைத்து, தன் கையிலே நெருப்பையும் கத்தியையும் எடுத்துக்கொண்டான்; அவர்கள் இருவரும் சேர்ந்துபோனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","அப்பொழுது ஈசாக்கு தன் தகப்பனாகிய ஆபிரகாமை நோக்கி: “என் தகப்பனே” என்றான்; அதற்கு அவன்: “என் மகனே, இதோ, இருக்கிறேன்” என்றான்; அப்பொழுது அவன்: “இதோ, நெருப்பும் விறகும் இருக்கிறது, தகனபலிக்கு ஆட்டுக்குட்டி எங்கே என்றான்”. ");
INSERT INTO tam2017_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","அதற்கு ஆபிரகாம்: “என் மகனே, தேவன் தகனபலிக்கான ஆட்டுக்குட்டியை அவரே கொடுப்பார்” என்றான்; அப்புறம் இருவரும் சேர்ந்துபோய், ");
INSERT INTO tam2017_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","தேவன் அவனுக்குச் சொல்லியிருந்த இடத்திற்கு வந்தார்கள்; அங்கே ஆபிரகாம் ஒரு பலிபீடத்தை உண்டாக்கி, விறகுகளை அடுக்கி, தன் மகனாகிய ஈசாக்கைக் கட்டி, அந்தப் பலிபீடத்தில் அடுக்கிய விறகுகளின்மேல் அவனைப் படுக்கவைத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","பின்பு ஆபிரகாம் தன் மகனை வெட்டுவதற்காக தன் கையை நீட்டிக் கத்தியை எடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","அப்பொழுது யெகோவாவுடைய தூதனானவர் வானத்திலிருந்து, “ஆபிரகாமே, ஆபிரகாமே என்று கூப்பிட்டார்; அவன்: இதோ, அடியேன் என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","அப்பொழுது அவர்: “சிறுவன்மேல் உன் கையைப் போடாதே, அவனுக்கு ஒன்றும் செய்யாதே; நீ அவனை உன் மகன் என்றும், உனது ஒரே மகன் என்றும் பார்க்காமல் எனக்காக ஒப்புக்கொடுத்ததால் நீ தேவனுக்குப் பயப்படுகிறவன் என்று இப்பொழுது தெரிந்துகொண்டேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","ஆபிரகாம் தன் கண்களை ஏறெடுத்துப் பார்க்கும்போது, இதோ, தனக்குப் பின்புறமாகப் புதரிலே தன் கொம்புகள் சிக்கிக்கொண்டிருந்த ஒரு ஆட்டுக்கடாவைக் கண்டான்; அப்பொழுது ஆபிரகாம் போய், கடாவைப் பிடித்து, அதைத் தன் மகனுக்குப் பதிலாகத் தகனபலியிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","ஆபிரகாம் அந்த இடத்திற்கு “யேகோவாயீரே என்று பெயரிட்டான்; அதனால் யெகோவாவுடைய மலையில் பார்த்துக்கொள்ளப்படும்” என்று இந்த நாள்வரைக்கும் சொல்லப்பட்டு வருகிறது. ");
INSERT INTO tam2017_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","யெகோவாவுடைய தூதனானவர் இரண்டாவது முறை வானத்திலிருந்து ஆபிரகாமைக் கூப்பிட்டு: ");
INSERT INTO tam2017_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“நீ உன் மகன் என்றும், உனது ஒரேமகன் என்றும் பார்க்காமல் அவனை ஒப்புக்கொடுத்து இந்தக் காரியத்தைச் செய்ததால்; ");
INSERT INTO tam2017_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","நான் உன்னை ஆசீர்வதிக்கவே ஆசீர்வதித்து, உன் சந்ததியை வானத்திலுள்ள நட்சத்திரங்களைப்போலவும், கடற்கரை மணலைப்போலவும் பெருகவே பெருகச்செய்வேன் என்றும், உன் சந்ததியார் தங்கள் எதிரிகளின் வாசல்களைச் சொந்தமாக்கிக் கொள்ளுவார்கள் என்றும், ");
INSERT INTO tam2017_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","நீ என்னுடைய சொல்லுக்குக் கீழ்ப்படிந்ததால், உன் சந்ததிக்குள் பூமியிலுள்ள அனைத்து தேசங்களும் ஆசீர்வதிக்கப்படும் என்றும் என்பேரில் ஆணையிட்டேன் என்று யெகோவா சொல்லுகிறார் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ஆபிரகாம் தன் வேலைக்காரர்களிடத்திற்குத் திரும்பிவந்தான்; அவர்கள் எழுந்து புறப்பட்டு, ஒன்றுசேர்ந்து பெயெர்செபாவுக்குப் போனார்கள்; ஆபிரகாம் பெயெர்செபாவிலே குடியிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","இந்தக் காரியங்கள் நடந்தபின்பு, ஒருவன் ஆபிரகாமிடத்தில் வந்து: “மில்க்காளும் உன் சகோதரனாகிய நாகோருக்கு குழந்தைகளைப் பெற்றெடுத்தாள்; ");
INSERT INTO tam2017_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","அவர்கள் யாரென்றால், முதற்பிறந்தவனான ஊத்ஸ், அவனுடைய தம்பியாகிய பூஸ், ஆராமுக்குத் தகப்பனாகிய கேமுவேல், ");
INSERT INTO tam2017_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","கேசேத், ஆசோ, பில்தாஸ், இத்லாப், பெத்துவேல் என்பவர்கள்; பெத்துவேல் ரெபெக்காளைப் பெற்றெடுத்தான்” என்று அறிவித்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","அந்த எட்டுப்பேரை மில்க்காள் ஆபிரகாமுடைய சகோதரனாகிய நாகோருக்குப் பெற்றெடுத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ரேயுமாள் என்று பெயர்கொண்ட அவனுடைய மறுமனையாட்டியும், தேபா, காகாம், தாகாஸ், மாகா என்பவர்களைப் பெற்றெடுத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","சாராள் 127 வருடங்கள் உயிரோடிருந்தாள்; சாராளுடைய வயது இவ்வளவுதான். ");
INSERT INTO tam2017_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","கானான் தேசத்திலுள்ள எபிரோன் என்னும் கீரியாத் அர்பாவிலே சாராள் இறந்தாள்; அப்பொழுது ஆபிரகாம், சாராளுக்காகப் புலம்பி அழுதான். ");
INSERT INTO tam2017_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","பின்பு ஆபிரகாம், இறந்த உடல் இருந்த இடத்திலிருந்து எழுந்துபோய், ஏத்தின் வம்சத்தாருடன் பேசி: ");
INSERT INTO tam2017_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“நான் உங்களிடத்தில் அந்நியனும் பரதேசியுமாக இருக்கிறேன்; என்னிடத்திலிருக்கிற இந்த இறந்த உடலை நான் அடக்கம்செய்வதற்கு, உங்களிடத்தில் எனக்குச் சொந்தமாக ஒரு கல்லறைநிலத்தைத் தரவேண்டும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","அதற்கு ஏத்தின் வம்சத்தார் ஆபிரகாமுக்கு மறுமொழியாக: ");
INSERT INTO tam2017_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“எங்கள் ஆண்டவனே, நாங்கள் சொல்லுகிறதைக் கேளும்; எங்களுக்குள்ளே நீர் மகா பிரபு; எங்களுடைய கல்லறைகளில் முக்கியமானதில் உடலை அடக்கம் செய்யும்; நீர் உடலை அடக்கம்செய்ய எங்களில் ஒருவனும் தன் கல்லறையை உமக்குத் தடைசெய்வதில்லை” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","அப்பொழுது ஆபிரகாம் எழுந்திருந்து, ஏத்தின் வம்சத்தாராகிய அந்தத் தேசத்தாருக்கு வணக்கம் சொல்லி, ");
INSERT INTO tam2017_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","அவர்களோடு பேசி: “என்னிடத்திலிருக்கிற உடலை அடக்கம்செய்ய உங்களுக்குச் சம்மதமானால், நீங்கள் என் வார்த்தையைக் கேட்டு, சோகாருடைய மகனாகிய எப்பெரோன், ");
INSERT INTO tam2017_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","தன் நிலத்தின் கடைசியிலே இருக்கிற மக்பேலா எனப்பட்ட குகையை எனக்குச் சொந்தமான கல்லறை நிலமாகத் தரவேண்டும் என்று, அவரிடத்தில் எனக்காக வேண்டிக்கொள்ளுங்கள்; அதற்குரிய விலைக்கு அவர் அதைத் தரட்டும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","எப்பெரோன் ஏத்தின் வம்சத்தார் மத்தியில் உட்கார்ந்திருந்தான்; அப்பொழுது ஏத்தியனான எப்பெரோன் தன் ஊர் வாசலுக்குள் பிரவேசிக்கிற ஏத்தின் வம்சத்தார் அனைவரும் கேட்க ஆபிரகாமுக்கு மறுமொழியாக: ");
INSERT INTO tam2017_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“அப்படியல்ல, என் ஆண்டவனே, என் வார்த்தையைக் கேளும்; அந்த நிலத்தை உமக்குக் கொடுக்கிறேன், அதிலிருக்கும் குகையையும் உமக்குக் கொடுக்கிறேன், என் இனத்தாரின் முன்னிலையில் அதை உமக்குக் கொடுக்கிறேன், உம்மிடத்திலிருக்கிற உடலை அடக்கம் செய்யும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","அப்பொழுது ஆபிரகாம் அந்தத் தேசத்தாருக்கு வணக்கம் சொல்லி, ");
INSERT INTO tam2017_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","தேசத்து மக்கள் கேட்க, எப்பெரோனை நோக்கி: “கொடுப்பதற்கு உமக்கு மனதிருந்தால் என் வார்த்தையைக் கேளும்; நிலத்தின் விலையைத் தருகிறேன்; என் கையில் அதை வாங்கிக்கொள்ளும்; அப்பொழுது என்னிடத்திலிருக்கிற உடலை அந்த இடத்தில் அடக்கம் செய்வேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","அதற்கு எப்பெரோன் ஆபிரகாமுக்கு மறுமொழியாக: ");
INSERT INTO tam2017_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“என் ஆண்டவனே, நான் சொல்லுகிறதைக் கேளும்; அந்த நிலத்தின் விலை நானூறு சேக்கல் நிறை வெள்ளி; எனக்கும் உமக்கும் அது சாதாரண காரியம்; நீர் உம்மிடத்திலிருக்கிற உடலை அடக்கம் செய்யும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","அப்பொழுது ஆபிரகாம் எப்பெரோனின் சொல்லைக் கேட்டு, ஏத்தின் வம்சத்தாரின் முன்னிலையில் எப்பெரோன் சொன்னபடியே, வியாபாரிகளிடத்தில் செல்லும்படியான 400 சேக்கல் நிறை வெள்ளியை அவனுக்கு நிறுத்துக்கொடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","இந்த விதமாக மம்ரேக்கு எதிரே மக்பேலாவிலுள்ள எப்பெரோனுடைய நிலமாகிய அந்த இடமும், அதிலுள்ள குகையும், நிலத்திலுள்ள அனைத்து மரங்களும், ");
INSERT INTO tam2017_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","அவனுடைய ஊர்வாசலுக்குள் பிரவேசிக்கும் ஏத்தின் வம்சத்தினர் அனைவரின் முன்னிலையிலும் ஆபிரகாமுக்குச் சொந்தமாக உறுதிப்படுத்தப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","அதற்குப்பின்பு ஆபிரகாம் தன் மனைவியாகிய சாராளைக் கானான் தேசத்தில் எப்ரோன் ஊர் பூமியான மம்ரேக்கு எதிரே இருக்கிற மக்பேலா என்னும் நிலத்தின் குகையிலே அடக்கம்செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","இப்படி ஏத்தின் வம்சத்தாரிடமிருந்து வாங்கப்பட்ட அந்த நிலமும், அதிலுள்ள குகையும், ஆபிரகாமுக்குச் சொந்த கல்லறை நிலமாக உறுதிப்படுத்தப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ஆபிரகாம் வயது முதிர்ந்தவனானான். யெகோவா ஆபிரகாமை அனைத்துக் காரியங்களிலும் ஆசீர்வதித்து வந்தார். ");
INSERT INTO tam2017_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","அப்பொழுது ஆபிரகாம் தன் வீட்டிலுள்ளவர்களில் வயதில் மூத்தவனும், தனக்கு உண்டான எல்லாவற்றிற்கும் அதிகாரியுமாகிய தன் வேலைக்காரனை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","“நான் குடியிருக்கிற கானானியர்களுடைய பெண்களில் நீ என் மகனுக்குப் பெண்ணைத் தேர்ந்தெடுக்காமல்; ");
INSERT INTO tam2017_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","நீ என்னுடைய தேசத்திற்கும் என்னுடைய இனத்தாரிடத்திற்கும் போய், என் மகனாகிய ஈசாக்குக்குப் பெண்ணைத் தேர்ந்தெடுப்பேன் என்று, வானத்திற்குத் தேவனும் பூமிக்குத் தேவனுமாகிய யெகோவாவை முன்னிட்டு எனக்கு ஆணையிட்டுக்கொடுக்க, நீ உன் கையை என் தொடையின்கீழ் வை” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","அதற்கு அந்த வேலைக்காரன்: “அந்த இடத்துப் பெண் என்னுடன் இந்தத் தேசத்திற்கு வர விருப்பமில்லாமல் இருந்தால், நீர் விட்டுவந்த தேசத்திற்கு உம்முடைய மகனை மறுபடியும் அழைத்துப்போகவேண்டுமோ”? என்று கேட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","அதற்கு ஆபிரகாம்: “நீ என் மகனை மறுபடியும் அங்கே அழைத்துக்கொண்டு போகாமலிருக்க எச்சரிக்கையாக இரு. ");
INSERT INTO tam2017_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","என்னை என்னுடைய தகப்பனுடைய வீட்டிலும் என் இனத்தார் இருக்கிற தேசத்திலுமிருந்து அழைத்துவந்தவரும், உன் சந்ததிக்கு இந்த தேசத்தைத் தருவேன் என்று எனக்குச் சொல்லி ஆணையிட்டவருமான வானத்திற்குத் தேவனாகிய யெகோவா, நீ அங்கேயிருந்து என் மகனுக்கு ஒரு பெண்ணை அழைத்துவர, தம்முடைய தூதனை உனக்கு முன்பாக அனுப்புவார். ");
INSERT INTO tam2017_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","பெண் உன்னுடன் வர விருப்பமில்லாமல் இருந்தால், அப்பொழுது நீ இந்த என் ஆணைக்கு உட்படாதிருப்பாய்; அங்கே மாத்திரம் என் மகனை மறுபடியும் அழைத்துக்கொண்டு போகவேண்டாம்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","அப்பொழுது அந்த வேலைக்காரன் தன் கையைத் தன் எஜமானாகிய ஆபிரகாமுடைய தொடையின்கீழ் வைத்து, இந்தக் காரியத்தைக்குறித்து அவனுக்கு ஆணையிட்டுக்கொடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","பின்பு அந்த வேலைக்காரன் தன் எஜமானுடைய ஒட்டகங்களில் பத்து ஒட்டகங்களைத் தன்னோடு கொண்டுபோனான்; தன் எஜமானுடைய அனைத்துவகையான விலையுயர்ந்த பொருட்களும் அவனுடைய கையில் இருந்தன; அவன் எழுந்து புறப்பட்டுப்போய், ஆரம்நாரஹி நாகோருடைய ஊருக்கு வந்து, ");
INSERT INTO tam2017_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","ஊருக்குப் வெளியே ஒரு கிணற்றினருகில், தண்ணீர் இறைக்க பெண்கள் வருகிற சாயங்கால நேரத்தில், ஒட்டகங்களை மடக்கி, தனக்குள்ளே சொல்லிக்கொண்டது என்னவென்றால்: ");
INSERT INTO tam2017_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","“என் எஜமானாகிய ஆபிரகாமுக்கு தேவனாயிருக்கிற யெகோவாவே, இன்றைக்கு நீர் எனக்குக் காரியம் நிறைவேறச்செய்து, என் எஜமானாகிய ஆபிரகாமுக்குத் தயவு செய்தருளும். ");
INSERT INTO tam2017_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","இதோ, நான் இந்தக் கிணற்றினருகில் நிற்கிறேன், இந்த ஊர்ப் பெண்கள் தண்ணீர் இறைக்க வருவார்களே. ");
INSERT INTO tam2017_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","நான் குடிக்க உன் குடத்தைச் சாய்க்கவேண்டும் என்று நான் சொல்லும்போது: குடி என்றும், உன் ஒட்டகங்களும் குடிக்கக் கொடுப்பேன் என்றும் சொல்லும் பெண்ணானவளே, நீர் உம்முடைய ஊழியக்காரனாகிய ஈசாக்குக்கு நியமித்தவளாக இருக்கவும், என் எஜமானுக்கு தயவுசெய்தீர் என்று நான் அதன்மூலம் தெரிந்துகொள்ளவும் உதவிசெய்யும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","அவன் இப்படிச் சொல்லி முடிப்பதற்கு முன்பே, இதோ, ஆபிரகாமுடைய சகோதரனாகிய நாகோரின் மனைவி மில்க்காளுடைய மகனாகிய பெத்துவேலுக்குப் பிறந்த ரெபெக்காள் குடத்தைத் தோள்மேல் வைத்துக்கொண்டு வந்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","அந்தப் பெண் மிகுந்த அழகுள்ளவளும், கன்னிகையுமாக இருந்தாள்; அவள் கிணற்றில் இறங்கி, தன் குடத்தை நிரப்பிக்கொண்டு ஏறிவந்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","அப்பொழுது அந்த வேலைக்காரன், அவளுக்கு நேராக ஓடி: “உன் குடத்திலிருக்கிற தண்ணீரில் கொஞ்சம் குடிக்கத் தரவேண்டும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","அதற்கு அவள்: “குடியும் என் ஆண்டவனே” என்று சீக்கிரமாகக் குடத்தைத் தன் கையிலிருந்து இறக்கி, அவனுக்குக் குடிக்கக் கொடுத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","கொடுத்தபின், “உம்முடைய ஒட்டகங்களும் குடித்து முடியும்வரைக்கும் அவைகளுக்கும் தண்ணீர் இறைத்துக் கொடுப்பேன்” என்றுசொல்லி; ");
INSERT INTO tam2017_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","சீக்கிரமாகத் தன் குடத்துத் தண்ணீரைத் தொட்டியிலே ஊற்றிவிட்டு, இன்னும் கொண்டுவர கிணற்றுக்கு ஓடி, அவனுடைய ஒட்டகங்களுக்கெல்லாம் குடிக்க ஊற்றினாள். ");
INSERT INTO tam2017_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","அந்த மனிதன் அவளைக்குறித்து ஆச்சரியப்பட்டு, யெகோவா தன் பயணத்தை வாய்க்கச்செய்தாரோ இல்லையோ என்று தெரிந்துகொள்ள மவுனமாயிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ஒட்டகங்கள் குடித்து முடிந்தபின், அந்த மனிதன் அரைச்சேக்கல் எடையுள்ள தங்கக் கம்மலையும், அவளுடைய கைகளுக்குப் பத்துச் சேக்கல் எடையுள்ள இரண்டு தங்க வளையல்களையும் கொடுத்து, ");
INSERT INTO tam2017_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","“நீ யாருடைய மகள் என்று எனக்குச் சொல்லவேண்டும்; நாங்கள் உன் தகப்பன் வீட்டில் இரவில் தங்க இடம் உண்டா” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","அதற்கு அவள்: “நான் நாகோருக்கு மில்க்காள் பெற்ற மகனாகிய பெத்துவேலின் மகள்” என்று சொன்னதுமல்லாமல், ");
INSERT INTO tam2017_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","“எங்களிடத்தில் வைக்கோலும் தீவனமும் போதிய அளவு இருக்கிறது; இரவில் தங்க இடமும் உண்டு” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","அப்பொழுது அந்த மனிதன் தலைகுனிந்து, யெகோவாவை பணிந்துகொண்டு, ");
INSERT INTO tam2017_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“என் எஜமானாகிய ஆபிரகாமின் தேவனாயிருக்கிற யெகோவாவுக்கு ஸ்தோத்திரம்; அவர் தம்முடைய கிருபையையும், தம்முடைய உண்மையையும் என் எஜமானை விட்டு நீக்கவில்லை; நான் பயணம் செய்துவரும்போது, யெகோவா என் எஜமானுடைய சகோதரர்களுடைய வீட்டிற்கு என்னை அழைத்துக்கொண்டு வந்தார்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","அந்தப் பெண் ஓடி, இந்தக் காரியங்களைத் தன் தாயின் வீட்டிலுள்ளவர்களுக்குத் தெரிவித்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","ரெபெக்காளுக்கு ஒரு சகோதரன் இருந்தான்; அவனுக்கு லாபான் என்று பெயர்; அந்த லாபான் வெளியே கிணற்றினருகில் இருந்த அந்த மனிதனிடம் ஓடினான். ");
INSERT INTO tam2017_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","அவன் தன் சகோதரி அணிந்திருந்த அந்தக் கம்மலையும், அவளுடைய கைகளில் போட்டிருந்த வளையல்களையும் பார்த்து, இவைகளையெல்லாம் அந்த மனிதன் என்னோடு பேசினானென்று தன் சகோதரி ரெபெக்காள் சொன்ன வார்த்தைகளைக் கேட்டவுடனே, அந்த மனிதனிடத்திற்கு வந்தான்; அவன் கிணற்றினருகே ஒட்டகங்களுக்கு அருகில் நின்றுகொண்டிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","அப்பொழுது அவன்: “யெகோவாவினால் ஆசீர்வதிக்கப்பட்டவரே, உள்ளே வாரும்; நீர் வெளியே நிற்பது என்ன? உமக்கு வீடும், ஒட்டகங்களுக்கு இடமும் ஆயத்தம் செய்திருக்கிறேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","அப்பொழுது அந்த மனிதன், வீட்டிற்குப் போனான். லாபான் ஒட்டகங்களின் கட்டவிழ்த்து, ஒட்டகங்களுக்கு வைக்கோலும் தீவனமும் போட்டு, அவனும், அவனோடு வந்தவர்களும் தங்கள் கால்களைக் கழுவிக்கொள்ளத் தண்ணீர் கொடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","பின்பு, அவனுக்கு முன்பாக உணவு வைக்கப்பட்டது. அப்பொழுது அவன்: “நான் வந்த காரியத்தைச் சொல்லுவதற்கு முன்பாகச் சாப்பிடமாட்டேன்” என்றான். அதற்கு அவன், “சொல்லும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","அப்பொழுது அவன்: “நான் ஆபிரகாமுடைய வேலைக்காரன். ");
INSERT INTO tam2017_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","யெகோவா என் எஜமானை மிகவும் ஆசீர்வதித்திருக்கிறார், அவர் செல்வந்தனாக இருக்கிறார்; யெகோவா அவருக்கு ஆடுமாடுகளையும், வெள்ளியையும், பொன்னையும், வேலைக்காரரையும், வேலைக்காரிகளையும், ஒட்டகங்களையும், கழுதைகளையும் கொடுத்திருக்கிறார். ");
INSERT INTO tam2017_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","என் எஜமானுடைய மனைவியாகிய சாராள் முதிர்வயதானபோது, என் எஜமானுக்கு ஒரு மகனைப் பெற்றெடுத்தாள்; அவர் தமக்கு உண்டான அனைத்தையும் அவனுக்குக் கொடுத்திருக்கிறார். ");
INSERT INTO tam2017_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","என் எஜமான் என்னை நோக்கி: நான் குடியிருக்கிற கானான் தேசத்தாருடைய பெண்களில் நீ என் மகனுக்குப் பெண்ணைத் தேர்ந்தெடுக்காமல், ");
INSERT INTO tam2017_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","நீ என் தகப்பன் வீட்டிற்கும், என் இனத்தாரிடத்திற்கும் போய், என் மகனுக்குப் பெண்ணைத் தேர்ந்தெடுக்கவேண்டும் என்று ஆணையிட்டுக்கொடுக்கச் சொன்னார். ");
INSERT INTO tam2017_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","அப்பொழுது நான் என் எஜமானை நோக்கி: ஒருவேளை அந்தப் பெண் என்னுடன் வராமல்போனாலோ என்று கேட்டதற்கு, ");
INSERT INTO tam2017_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","அவர்: நான் ஆராதிக்கும் யெகோவா உன்னோடு தம்முடைய தூதனை அனுப்பி, உன் பயணத்தை வாய்க்கச் செய்வார்; என் இனத்தாரிடத்திலும், என் தகப்பன் வீட்டிலும் நீ என் மகனுக்குப் பெண்ணைத் தேர்ந்தெடுப்பாய். ");
INSERT INTO tam2017_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","நீ என் இனத்தாரிடத்திற்குப்போனால், என் ஆணைக்கு உட்படாதிருப்பாய்; அவர்கள் உன்னோடு பெண்ணை அனுப்பாமல்போனாலும், நீ என் ஆணைக்கு உட்படாதிருப்பாய் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","அப்படியே நான் இன்று கிணற்றினருகில் வந்து: என் எஜமானாகிய ஆபிரகாமின் தேவனாகிய யெகோவாவே, என் பயணத்தை நீர் இப்பொழுது வாய்க்கச்செய்வீரானால், ");
INSERT INTO tam2017_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","இதோ, நான் கிணற்றினருகில் நிற்கிறேன், தண்ணீர் இறைக்க வரப்போகிற கன்னிகையை நான் நோக்கி: உன் குடத்திலிருக்கிற தண்ணீரில் கொஞ்சம் எனக்குக் குடிக்கத்தரவேண்டும் என்று கேட்கும்போது: ");
INSERT INTO tam2017_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","“நீ குடி என்றும், உன் ஒட்டகங்களுக்கும் தண்ணீர் கொடுப்பேன் என்றும் சொல்லும் பெண்ணே யெகோவா என் எஜமானுடைய மகனுக்கு நியமித்த பெண்ணாகவேண்டும்” என்றேன். ");
INSERT INTO tam2017_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","நான் இதை என் இருதயத்தில் சொல்லி முடிப்பதற்குமுன்னே, இதோ, ரெபெக்காள் தன் குடத்தைத் தோள்மேல் வைத்துக்கொண்டு புறப்பட்டுவந்து, கிணற்றில் இறங்கிப்போய்த் தண்ணீர் எடுத்தாள். அப்பொழுது நான்: எனக்குக் குடிக்கத்தரவேண்டும் என்றேன். ");
INSERT INTO tam2017_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","அவள் சீக்கிரமாகத் தன் தோள்மேலிருந்த குடத்தை இறக்கி, குடியும், உம்முடைய ஒட்டகங்களுக்கும் கொடுப்பேன் என்றாள். நான் குடித்தேன்; ஒட்டகங்களுக்கும் கொடுத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","அப்பொழுது: நீ யாருடைய மகள் என்று அவளைக் கேட்டேன்; அதற்கு அவள்: நான் மில்க்காள் நாகோருக்குப் பெற்ற மகனாகிய பெத்துவேலின் மகள் என்றாள்; அப்பொழுது அவளுக்குக் கம்மல்களையும், அவளுடைய கைகளிலே வளையல்களையும் போட்டு; ");
INSERT INTO tam2017_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","தலைகுனிந்து, யெகோவாவைப் பணிந்துகொண்டு, நான் என் எஜமானனின் சகோதரனுடைய மகளை அவருடைய மகனுக்கு மனைவியாக்கிக்கொள்ள என்னை சரியானவழியில் நடத்திவந்த என் எஜமானாகிய ஆபிரகாமின் தேவனாயிருக்கிற யெகோவவை ஸ்தோத்திரித்தேன். ");
INSERT INTO tam2017_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","இப்பொழுதும் நீங்களும் என் எஜமானுக்குத் தயையும் உண்மையும் உடையவர்களாக நடக்க மனதுள்ளவர்களானால், எனக்குச் சொல்லுங்கள்; இல்லையென்றால் அதையும் எனக்குச் சொல்லுங்கள், அப்பொழுது நான் வலதுபுறத்தையாகிலும் இடதுபுறத்தையாகிலும் நோக்கிப்போவேன் என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","அப்பொழுது லாபானும் பெத்துவேலும் மறுமொழியாக: “இந்தக் காரியம் யெகோவாவால் வந்தது, உமக்கு நாங்கள் நன்மையோ அல்லது தீமையோ ஒன்றும் சொல்லக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","இதோ, ரெபெக்காள் உமக்கு முன்பாக இருக்கிறாள்; யெகோவா சொன்னபடியே அவள் உமது எஜமானுடைய மகனுக்கு மனைவியாக்கிக்கொள்ள, அவளை அழைத்துக்கொண்டுசெல்லும்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ஆபிரகாமின் வேலைக்காரன் அவர்கள் வார்த்தைகளைக் கேட்டபோது, தரைவரைக்கும் குனிந்து, யெகோவாவைப் பணிந்துகொண்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","பின்பு அந்த வேலைக்காரன் வெள்ளிப் பொருட்களையும், தங்கத்தினால் செய்யப்பட்ட பொருட்களையும், ஆடைகளையும் எடுத்து, ரெபெக்காளுக்குக் கொடுத்ததுமல்லாமல், அவளுடைய சகோதரனுக்கும் தாய்க்கும் சில விலையுயர்ந்த பொருட்களையும் கொடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","பின்பு அவனும் அவனோடிருந்த மனிதர்களும் சாப்பிட்டுக் குடித்து, இரவில் தங்கினார்கள்; காலையிலே எழுந்திருந்து, அவன்: “என் எஜமானிடத்திற்கு என்னை அனுப்பிவிடுங்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","அப்பொழுது அவளுடைய சகோதரனும், தாயும், “பத்து நாட்களாவது பெண் எங்களோடு இருக்கட்டும், அதற்குப்பின்பு போகலாம்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","அதற்கு அவன்: “யெகோவா என் பயணத்தை வாய்க்கச்செய்திருக்க, நீங்கள் என்னைத் தடுக்காதிருங்கள்; நான் என் எஜமானிடத்திற்குப்போக என்னை அனுப்பிவிடவேண்டும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","அப்பொழுது அவர்கள்: “பெண்ணை அழைத்து, அவளது விருப்பத்தைக் கேட்போம்” என்று சொல்லி, ");
INSERT INTO tam2017_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","ரெபெக்காளை அழைத்து: “நீ இந்த மனிதனோடுகூடப் போகிறாயா” என்று கேட்டார்கள். அவள்: “போகிறேன்” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","அப்படியே அவர்கள் தங்கள் சகோதரியாகிய ரெபெக்காளையும், அவளுடைய வேலைக்காரிகளையும், ஆபிரகாமின் வேலைக்காரனையும், அவனுடைய மனிதர்களையும் வழியனுப்பி, ");
INSERT INTO tam2017_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","ரெபெக்காளை வாழ்த்தி: “எங்கள் சகோதரியே, நீ கோடாகோடியாகப் பெருகுவாயாக; உன் சந்ததியார் தங்கள் பகைஞருடைய வாசல்களைச் சொந்தமாக்கிக்கொள்வார்களாக” என்று ஆசீர்வதித்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","அப்பொழுது ரெபெக்காளும் அவளுடைய வேலைக்காரிகளும் எழுந்து ஒட்டகங்கள்மேல் ஏறி, அந்த மனிதனோடுகூடப் போனார்கள். வேலைக்காரன் ரெபெக்காளை அழைத்துக்கொண்டுபோனான். ");
INSERT INTO tam2017_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ஈசாக்கு தென்தேசத்தில் குடியிருந்தான். அப்பொழுது அவன்: லகாய்ரோயீ எனப்பட்ட கிணற்றின் வழியாகப் புறப்பட்டு வந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ஈசாக்கு சாயங்காலநேரத்தில் தியானம்செய்ய வயல்வெளிக்குப் போயிருந்தபோது தூரத்தில் ஒட்டகங்கள் வருவதைக்கண்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","ரெபெக்காளும் தூரத்தில் ஈசாக்கைக் கண்டபோது, ");
INSERT INTO tam2017_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","வேலைக்காரனை நோக்கி: “அங்கே வயல்வெளியிலே நம்மைநோக்கி நடந்துவருகிற அந்த மனிதன் யார்” என்று கேட்டாள். “அவர்தான் என் எஜமான்” என்று வேலைக்காரன் சொன்னான். அப்பொழுது அவள் ஒட்டகத்திலிருந்து இறங்கி முக்காடிட்டுக்கொண்டாள். ");
INSERT INTO tam2017_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","வேலைக்காரன் தான் செய்த அனைத்து காரியங்களையும் ஈசாக்குக்கு விபரமாகச் சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","அப்பொழுது ஈசாக்கு ரெபெக்காளைத் தன் தாய் சாராளுடைய கூடாரத்திற்கு அழைத்துக்கொண்டுபோய், அவளைத் தனக்கு மனைவியாக்கிக்கொண்டு, அவளை நேசித்தான். ஈசாக்கு தன் தாய்க்காகக் கொண்டிருந்த துக்கம் நீங்கி ஆறுதல் அடைந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","ஆபிரகாம் கேத்தூராள் என்னும் பெயர்கொண்ட ஒரு பெண்ணையும் திருமணம் செய்திருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","அவள் அவனுக்குச் சிம்ரானையும், யக்க்ஷானையும், மேதானையும், மீதியானையும், இஸ்பாக்கையும், சூவாகையும் பெற்றெடுத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","யக்க்ஷான் சேபாவையும், தேதானையும் பெற்றெடுத்தான்; தேதானுடைய மகன்கள் அசூரீம், லெத்தூசீம், லெயூமீம் என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","மீதியானுடைய மகன்கள் ஏப்பா, ஏப்பேர், ஆனோக்கு, அபீதா, எல்தாகா என்பவர்கள்; இவர்கள் எல்லோரும் கேத்தூராளின் பிள்ளைகள். ");
INSERT INTO tam2017_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","ஆபிரகாம் தனக்கு உண்டான அனைத்தையும் ஈசாக்குக்குக் கொடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ஆபிரகாமுக்கு இருந்த மறுமனையாட்டிகளின் பிள்ளைகளுக்கோ ஆபிரகாம் நன்கொடைகளைக் கொடுத்து, தான் உயிரோடிருக்கும்போதே அவர்களைத் தன் மகனாகிய ஈசாக்கைவிட்டுக் கிழக்கே போகக் கீழ்த்தேசத்திற்கு அனுப்பிவிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","ஆபிரகாம் உயிரோடிருந்த ஆயுசு நாட்கள் 175 வருடங்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","அதற்குப்பின்பு ஆபிரகாம் நல்ல நரைவயதிலும், முதிர்ந்த பூரண ஆயுசிலும் இறந்து, தன் இனத்தாருடன் சேர்க்கப்பட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","அவனுடைய மகன்களாகிய ஈசாக்கும் இஸ்மவேலும் மம்ரேக்கு எதிரே ஏத்தியனான சோகாரின் மகனாகிய எப்பெரோனின் நிலத்திலுள்ள மக்பேலா எனப்பட்ட குகையிலே அவனை அடக்கம்செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","அந்த நிலத்தை ஏத்தின் மகன்களின் கையிலே ஆபிரகாம் வாங்கியிருந்தான்; அங்கே ஆபிரகாமும் அவனுடைய மனைவியாகிய சாராளும் அடக்கம் செய்யப்பட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ஆபிரகாம் இறந்தபின்பு தேவன் அவனுடைய மகனாகிய ஈசாக்கை ஆசீர்வதித்தார். லகாய்ரோயீ என்னும் கிணற்றுக்குச் சமீபமாக ஈசாக்கு குடியிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","சாராளுடைய அடிமைப்பெண்ணாகிய எகிப்து தேசத்தாளான ஆகார் ஆபிரகாமுக்குப் பெற்ற மகனாகிய இஸ்மவேலின் வம்சவரலாறு: ");
INSERT INTO tam2017_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","பற்பல சந்ததிகளாகப் பிரிந்த இஸ்மவேலின் மகன்களுடைய பெயர்களாவன; இஸ்மவேலுடைய மூத்த மகன் நெபாயோத், பின்பு கேதார், அத்பியேல், மிப்சாம், ");
INSERT INTO tam2017_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","மிஷ்மா, தூமா, மாசா, ");
INSERT INTO tam2017_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ஆதாத், தேமா, யெத்தூர், நாபீஸ், கேத்மா என்பவைகளே. ");
INSERT INTO tam2017_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","தங்கள் கிராமங்களிலும் அரண்களிலும் குடியிருந்த தங்கள் மக்களுக்குப் பன்னிரண்டு பிரபுக்களாகிய இஸ்மவேலின் மகன்கள் இவர்களே, இவர்களுடைய பெயர்களும் இவைகளே. ");
INSERT INTO tam2017_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","இஸ்மவேலின் வயது 137. பின்பு அவன் இறந்து, தன் இனத்தாரோடு சேர்க்கப்பட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","அவர்கள் ஆவிலா துவங்கி எகிப்திற்கு நேராக அசீரியாவுக்குப் போகிற வழியிலிருக்கும் சூர் வரைக்கும் குடியிருந்தார்கள். இது அவனுடைய சகோதரர்கள் எல்லோருக்கும் முன்பாக அவன் குடியேறின பூமி. ");
INSERT INTO tam2017_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","ஆபிரகாமின் மகனாகிய ஈசாக்குடைய வம்சவரலாறு; ஆபிரகாம் ஈசாக்கைப் பெற்றெடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ஈசாக்கு ரெபெக்காளை திருமணம் செய்கிறபோது 40 வயதாயிருந்தான்; இவள் பதான் அராம் என்னும் சீரியா தேசத்தானாகிய பெத்துவேலுக்கு மகளும், சீரியா தேசத்தானாகிய லாபானுக்குச் சகோதரியுமானவள். ");
INSERT INTO tam2017_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","மலடியாயிருந்த தன் மனைவிக்காக ஈசாக்கு யெகோவாவை நோக்கி வேண்டுதல் செய்தான்; யெகோவா அவனுடைய வேண்டுதலைக் கேட்டருளினார்; அவனுடைய மனைவி ரெபெக்காள் கர்ப்பந்தரித்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","அவளது கர்ப்பத்தில் பிள்ளைகள் ஒன்றோடொன்று மோதிக்கொண்டிருந்தன; அப்பொழுது அவள்: “இப்படியிருந்தால் எனக்கு எப்படியாகுமோ” என்று சொல்லி, யெகோவாவிடத்தில் விசாரிக்கப் போனாள். ");
INSERT INTO tam2017_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","அதற்குக் யெகோவா: “இரண்டு இனத்தார்கள் உன் கர்ப்பத்தில் உண்டாயிருக்கிறது; இரண்டுவித இனங்கள் உன் வயிற்றிலிருந்து பிரியும், அவர்களில் ஒரு இனத்தார் மற்ற இனத்தாரைவிட பலத்திருப்பார்கள், மூத்தவன் இளையவனுக்குப் பணிந்திருப்பான்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","பிரசவநேரம் பூரணமானபோது, அவளது கர்ப்பத்தில் இரட்டைக் குழந்தைகள் இருந்தன. ");
INSERT INTO tam2017_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","மூத்தவன் சிவந்த நிறமுள்ளவனாகவும் உடல்முழுவதும் ரோமத்தாலான அங்கியைப் போர்த்தவன் போலவும் பிறந்தான்; அவனுக்கு ஏசா என்று பெயரிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","பின்பு, அவனுடைய சகோதரன் தன் கையினாலே ஏசாவின் குதிகாலைப் பிடித்துக்கொண்டு பிறந்தான்; அவனுக்கு யாக்கோபு என்று பெயரிட்டார்கள்; இவர்களை அவள் பெற்றபோது ஈசாக்கு 60 வயதாயிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","இந்தக் குழந்தைகள் பெரியவர்களானபோது, ஏசா வேட்டையில் வல்லவனும், காட்டில் வாழ்கிறவனாகவும் இருந்தான்; யாக்கோபு குணசாலியும் கூடாரவாசியுமாக இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ஏசா வேட்டையாடிக் கொண்டுவருகிறது ஈசாக்கினுடைய வாய்க்கு ருசிகரமாயிருந்ததினாலே ஏசாவின்மேல் பற்றுதலாக இருந்தான்; ரெபெக்காளோ யாக்கோபின்மேல் அன்பாயிருந்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ஒருநாள் ஏசா வெளியிலிருந்து களைத்து வந்தபோது, யாக்கோபு கூழ் சமைத்துக்கொண்டிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","அப்பொழுது ஏசா யாக்கோபை நோக்கி: “அந்தச் சிவப்பான கூழிலே நான் சாப்பிடக் கொஞ்சம் தா, களைத்திருக்கிறேன்” என்றான்; இதனாலே அவனுக்கு ஏதோம் என்கிற பெயர் உண்டானது. ");
INSERT INTO tam2017_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","அப்பொழுது யாக்கோபு: உன் பிறப்புரிமையை இன்று எனக்கு விற்றுப்போடு” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","அதற்கு ஏசா: “இதோ, நான் சாகப்போகிறேனே, இந்தப் பிறப்புரிமை எனக்கு எதற்கு” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","அப்பொழுது யாக்கோபு: “இன்று எனக்கு ஆணையிட்டுக்கொடு” என்றான்; அவன் யாக்கோபுக்கு ஆணையிட்டு, தன் பிறப்புரிமையை அவனுக்கு விற்றுப்போட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","அப்பொழுது யாக்கோபு ஏசாவுக்கு அப்பத்தையும் பயிற்றங்கூழையும் கொடுத்தான்; அவன் சாப்பிட்டுக் குடித்து எழுந்து போய்விட்டான். இப்படி ஏசா தன் பிறப்புரிமையை அலட்சியம் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ஆபிரகாமின் நாட்களில் உண்டான பஞ்சத்தை அல்லாமல், மேலும் ஒரு பஞ்சம் தேசத்தில் உண்டானது; அப்பொழுது ஈசாக்கு பெலிஸ்தருக்கு ராஜாவாகிய அபிமெலேக்கிடம் கேராருக்குப் போனான். ");
INSERT INTO tam2017_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","யெகோவா அவனுக்குக் காட்சியளித்து: “நீ எகிப்திற்குப் போகாமல், நான் உனக்குச் சொல்லும் தேசத்தில் குடியிரு. ");
INSERT INTO tam2017_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","இந்தத் தேசத்தில் குடியிரு; நான் உன்னோடுகூட இருந்து, உன்னை ஆசீர்வதிப்பேன்; நான் உனக்கும் உன் சந்ததிக்கும் இந்தத் தேசங்கள் அனைத்தையும் தந்து, உன் தகப்பனாகிய ஆபிரகாமுக்கு நான் கொடுத்த வாக்குறுதியை நிறைவேற்றுவேன். ");
INSERT INTO tam2017_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","ஆபிரகாம் என் சொல்லுக்குக் கீழ்ப்படிந்து, என் விதிகளையும், என் கற்பனைகளையும், என் நியமங்களையும், என் பிரமாணங்களையும் கைக்கொண்டதால், ");
INSERT INTO tam2017_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","நான் உன் சந்ததியை வானத்தின் நட்சத்திரங்களைப்போலப் பெருகச்செய்து, உன் சந்ததிக்கு இந்தத் தேசங்கள் அனைத்தையும் தருவேன்; உன் சந்ததிக்குள் பூமியிலுள்ள அனைத்து தேசங்களும் ஆசீர்வதிக்கப்படும் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","ஈசாக்கு கேராரிலே குடியிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","அந்த இடத்து மனிதர்கள் அவனுடைய மனைவியைக் குறித்து விசாரித்தபோது: “இவள் என் சகோதரி என்றான். ரெபெக்காள் பார்ப்பதற்கு அழகுள்ளவளானதால், அந்த இடத்து மனிதர்கள் அவள்நிமித்தம் தன்னைக் கொன்றுபோடுவார்கள் என்று எண்ணி, அவளைத் தன் மனைவி என்று சொல்லுவதற்குப் பயந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","அவன் அங்கே அநேகநாட்கள் குடியிருக்கும்போது, பெலிஸ்தருக்கு ராஜாவாகிய அபிமெலேக்கு ஜன்னல் வழியாகப் பார்க்கும்போது, ஈசாக்கு தன் மனைவியாகிய ரெபெக்காளோடு விளையாடிக்கொண்டிருக்கிறதைப் பார்த்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","அபிமெலேக்கு ஈசாக்கை அழைத்து: “அவள் உன் மனைவியாயிருக்கிறாளே! பின்பு ஏன் அவளை உனது சகோதரி என்று சொன்னாய்” என்றான். அதற்கு ஈசாக்கு: “அவள் நிமித்தம் நான் சாகாதபடி இப்படிச் சொன்னேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","அதற்கு அபிமெலேக்கு: “எங்களிடத்தில் ஏன் இப்படிச் செய்தாய்? மக்களில் யாராவது உன் மனைவியோடு உறவுகொள்ளவும், எங்கள்மேல் பழி சுமரவும் நீ இடமுண்டாக்கினாயே” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","பின்பு, அபிமெலேக்கு: “இந்த மனிதனையாகிலும் இவன் மனைவியையாகிலும் தொடுகிறவன் நிச்சயமாகக் கொலைசெய்யப்படுவான்” என்று எல்லா மக்களுக்கும் அறிவித்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ஈசாக்கு அந்தத் தேசத்தில் விதைவிதைத்தான்; யெகோவா அவனை ஆசீர்வதித்ததால் அந்த வருடத்தில் 100 மடங்கு பலனை அடைந்தான்; ");
INSERT INTO tam2017_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","அவன் செல்வந்தனாகி, வரவர விருத்தியடைந்து, மகா பெரியவனானான். ");
INSERT INTO tam2017_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","அவனுக்கு ஆட்டு மந்தையும், மாட்டு மந்தையும், அநேக வேலைக்காரரும் இருந்ததால் பெலிஸ்தர் அவன்மேல் பொறாமைகொண்டு, ");
INSERT INTO tam2017_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","அவனுடைய தகப்பனாகிய ஆபிரகாமின் நாட்களில் அவனுடைய வேலைக்காரர்கள் வெட்டின கிணறுகளையெல்லாம் மண்ணினால் மூடிப்போட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","அபிமெலேக்கு ஈசாக்கை நோக்கி: “நீ எங்களை விட்டுப் போய்விடு; எங்களைவிட மிகவும் பலத்தவனானாய்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","அப்பொழுது ஈசாக்கு அந்த இடத்தை விட்டுப் புறப்பட்டு, கேராரின் பள்ளத்தாக்கிலே கூடாரம் போட்டு, அங்கே குடியிருந்து, ");
INSERT INTO tam2017_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","தன் தகப்பனாகிய ஆபிரகாமின் நாட்களில் வெட்டப்பட்டவைகளும், ஆபிரகாம் இறந்தபின் பெலிஸ்தர் மூடிப்போட்டவைகளுமான கிணறுகளை மறுபடியும் தோண்டி, தன் தகப்பன் அவைகளுக்கு வைத்திருந்த பெயர்களின்படியே அவைகளுக்குப் பெயரிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ஈசாக்குடைய வேலைக்காரர்கள் பள்ளத்தாக்கிலே கிணறுவெட்டி, தண்ணீரைக் கண்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","கேராரூர் மேய்ப்பர்கள் “இந்தத் தண்ணீர் தங்களுடையது என்று சொல்லி”, ஈசாக்குடைய மேய்ப்பர்களுடனே வாக்குவாதம் செய்தார்கள்; அவர்கள் தன்னோடு வாக்குவாதம் செய்ததால், அந்தக் கிணற்றுக்கு ஏசேக்கு என்று பெயரிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","வேறொரு கிணற்றை வெட்டினார்கள்; அதைக்குறித்தும் வாக்குவாதம் செய்தார்கள்; ஆகையால் அதற்கு சித்னா என்று பெயரிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","பின்பு அந்த இடத்தைவிட்டுப் போய், வேறொரு கிணற்றை வெட்டினான்; அதைக்குறித்து அவர்கள் வாக்குவாதம் செய்யவில்லை; அப்பொழுது அவன்: “நாம் தேசத்தில் பெருகுவதற்காக, இப்பொழுது யெகோவா நமக்கு இடமுண்டாக்கினார்” என்று சொல்லி, அதற்கு ரெகொபோத் என்று பெயரிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","அங்கேயிருந்து பெயெர்செபாவுக்குப் போனான். ");
INSERT INTO tam2017_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","அன்று இரவிலே யெகோவா அவனுக்குக் காட்சியளித்து: “நான் உன் தகப்பனாகிய ஆபிரகாமுடைய தேவன், பயப்படாதே, நான் உன்னோடுகூட இருந்து, என் ஊழியக்காரனாகிய ஆபிரகாமின் பொருட்டு உன்னை ஆசீர்வதித்து, உன் சந்ததியைப் பெருகச் செய்வேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","அங்கே அவன் ஒரு பலிபீடத்தைக் கட்டி, யெகோவாவுடைய நாமத்தைத் தொழுதுகொண்டு, அங்கே தன் கூடாரத்தைப் போட்டான். அந்த இடத்தில் ஈசாக்கின் வேலைக்காரர்கள் ஒரு கிணற்றை வெட்டினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","அபிமெலேக்கும் அவனுடைய நண்பனாகிய அகுசாத்தும், படைத்தலைவனாகிய பிகோலும், கேராரிலிருந்து அவனிடத்திற்கு வந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","அப்பொழுது ஈசாக்கு அவர்களை நோக்கி: “ஏன் என்னிடத்தில் வந்தீர்கள்? நீங்கள் என்னைப் பகைத்து, என்னை உங்களிடத்தில் இருக்கவிடாமல் துரத்திவிட்டீர்களே” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","அதற்கு அவர்கள்: “நிச்சயமாக யெகோவா உம்மோடுகூட இருக்கிறார் என்று கண்டோம்; ஆகையால் எங்களுக்கும் உமக்கும் ஒரு ஒப்பந்தம் உண்டாகவேண்டும் என்று நாங்கள் தீர்மானம் செய்தோம். ");
INSERT INTO tam2017_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","நாங்கள் உம்மைத் தொடாமல், நன்மையையே உமக்குச் செய்து, உம்மைச் சமாதானத்தோடு அனுப்பிவிட்டதுபோல, நீரும் எங்களுக்குத் தீங்குசெய்யாமலிருக்க உம்மோடு ஒப்பந்தம் செய்துகொள்ள வந்தோம்; நீர் யெகோவாவினால் ஆசீர்வதிக்கப்பட்டவராமே” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","அவன் அவர்களுக்கு விருந்துசெய்தான், அவர்கள் சாப்பிட்டுக் குடித்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","அதிகாலையில் எழுந்து ஒருவருக்கொருவர் ஒப்பந்தம் செய்துகொண்டார்கள். பின்பு ஈசாக்கு அவர்களை அனுப்பிவிட்டான்; அவர்கள் அவனிடத்திலிருந்து சமாதானத்தோடு போய்விட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","அந்நாளில்தானே ஈசாக்கின் வேலைக்காரர்கள் வந்து, தாங்கள் கிணறு வெட்டின செய்தியை அவனுக்குத் தெரிவித்து, “தண்ணீர் கண்டோம்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","அதற்கு சேபா என்று பெயரிட்டான்; ஆகையால் அந்த ஊரின் பெயர் இந்த நாள்வரைக்கும் பெயெர்செபா எனப்படுகிறது. ");
INSERT INTO tam2017_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ஏசா 40 வயதானபோது, ஏத்தியர்களான பெயேரியினுடைய மகளாகிய யூதீத்தையும், ஏலோனுடைய மகளாகிய பஸ்மாத்தையும் திருமணம்செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","அவர்கள் ஈசாக்குக்கும் ரெபெக்காளுக்கும் மனஉளைச்சலைக் கொடுத்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ஈசாக்கு முதிர்வயதானதால் அவனுடைய கண்கள் பார்வையிழந்தபோது, அவன் தன் மூத்த மகனாகிய ஏசாவை அழைத்து, “என் மகனே” என்றான்; அவன், “இதோ இருக்கிறேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","அப்பொழுது அவன்: “நான் முதிர்வயதானேன், எப்போது இறப்பேனென்று எனக்குத் தெரியாது. ");
INSERT INTO tam2017_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ஆகையால், நீ உன் ஆயுதங்களாகிய உன் அம்புகளை வைக்கும் பையையும் உன் வில்லையும் எடுத்துக்கொண்டு காட்டுக்குப்போய், எனக்காக வேட்டையாடி, ");
INSERT INTO tam2017_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","அதை எனக்குப் பிரியமாயிருக்கிற ருசியுள்ள உணவுகளாகச் சமைத்து, நான் சாப்பிடவும், நான் இறப்பதற்குமுன்னே என் ஆத்துமா உன்னை ஆசீர்வதிக்கவும், என்னிடத்தில் கொண்டுவா” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ஈசாக்கு தன் மகனாகிய ஏசாவோடு பேசும்போது, ரெபெக்காள் கேட்டுக்கொண்டிருந்தாள். ஏசா வேட்டையாடிக்கொண்டுவர காட்டுக்குப் போனான். ");
INSERT INTO tam2017_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","அப்பொழுது ரெபெக்காள் தன் மகனாகிய யாக்கோபை நோக்கி: “உன் தகப்பன் உன் சகோதரனாகிய ஏசாவை அழைத்து: ");
INSERT INTO tam2017_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","நான் சாப்பிட்டு, எனக்கு மரணம் வருமுன்னே, யெகோவா முன்னிலையில் உன்னை ஆசீர்வதிக்க, நீ எனக்காக வேட்டையாடி, அதை எனக்கு ருசியுள்ள உணவுகளாகச் சமைத்துக்கொண்டுவா” என்று சொல்வதைக்கேட்டேன். ");
INSERT INTO tam2017_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","ஆகையால், என் மகனே, என் சொல்லைக் கேட்டு, நான் உனக்குச் சொல்கிறபடி செய். ");
INSERT INTO tam2017_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","நீ ஆட்டுமந்தைக்குப் போய், இரண்டு நல்ல வெள்ளாட்டுக்குட்டிகளைக் கொண்டுவா; நான் அவைகளை உன் தகப்பனுக்குப் பிரியமானபடி ருசியுள்ள உணவுகளாகச் சமைப்பேன். ");
INSERT INTO tam2017_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","உன் தகப்பன் தாம் இறப்பதற்குமுன்னே உன்னை ஆசீர்வதிப்பதற்கு, அவர் சாப்பிடுவதற்கு நீ அதை அவரிடத்தில் கொண்டுபோகவேண்டும் என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","அதற்கு யாக்கோபு தன் தாயாகிய ரெபெக்காளை நோக்கி: “என் சகோதரனாகிய ஏசா அதிக ரோமமுள்ளவன், நான் ரோமமில்லாதவன். ");
INSERT INTO tam2017_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","ஒருவேளை என் தகப்பன் என்னைத் தடவிப்பார்ப்பார்; அப்பொழுது நான் அவருக்கு ஏமாற்றுகிறவனாகக் காணப்பட்டு, என்மேல் ஆசீர்வாதத்தை அல்ல, சாபத்தையே வரவழைத்துக்கொள்வேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","அதற்கு அவனுடைய தாய்: “என் மகனே, உன்மேல் வரும் சாபம் என்மேல் வரட்டும்; என் சொல்லை மாத்திரம் கேட்டு, நீ போய், அவைகளை என்னிடத்தில் கொண்டுவா” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","அவன் போய் அவைகளைப் பிடித்து, தன் தாயினிடத்தில் கொண்டுவந்தான்; அவனுடைய தாய் அவனுடைய தகப்பனுக்குப் பிரியமான ருசியுள்ள உணவுகளைச் சமைத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","பின்பு ரெபெக்காள், வீட்டிலே தன்னிடத்தில் இருந்த தன் மூத்த மகனாகிய ஏசாவின் நல்ல ஆடைகளை எடுத்து, தன் இளைய மகனாகிய யாக்கோபுக்கு உடுத்தி, ");
INSERT INTO tam2017_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","வெள்ளாட்டுக்குட்டிகளின் தோலை அவனுடைய கைகளிலேயும் ரோமமில்லாத அவனுடைய கழுத்திலேயும் போட்டு; ");
INSERT INTO tam2017_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","தான் சமைத்த ருசியுள்ள உணவுகளையும் அப்பங்களையும் தன் மகனாகிய யாக்கோபின் கையில் கொடுத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","அவன் தன் தகப்பனிடத்தில் வந்து, “என் தகப்பனே” என்றான்; அதற்கு அவன்: “இதோ இருக்கிறேன்; நீ யார், என் மகனே” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","அப்பொழுது யாக்கோபு தன் தகப்பனை நோக்கி: “நான் உமது மூத்த மகனாகிய ஏசா; நீர் எனக்குச் சொன்னபடியே செய்தேன்; உம்முடைய ஆத்துமா என்னை ஆசீர்வதிக்க, நீர் எழுந்து உட்கார்ந்து, நான் வேட்டையாடிக் கொண்டுவந்ததைச் சாப்பிடும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","அப்பொழுது ஈசாக்கு தன் மகனை நோக்கி: “என் மகனே, இது உனக்கு இத்தனை சீக்கிரமாக எப்படி கிடைத்தது என்றான். அவன்: உம்முடைய தேவனாகிய யெகோவா எனக்குக் கிடைக்கச்செய்தார்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","அப்பொழுது ஈசாக்கு யாக்கோபை நோக்கி: “என் மகனே, நீ என் மகனாகிய ஏசாதானோ அல்லவோ என்று நான் உன்னைத் தடவிப்பார்க்க அருகில் வா” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","யாக்கோபு தன் தகப்பனாகிய ஈசாக்கினருகில் போனான்; அவன் இவனைத் தடவிப்பார்த்து: “சத்தம் யாக்கோபின் சத்தம், கைகளோ ஏசாவின் கைகள்” என்று சொல்லி, ");
INSERT INTO tam2017_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","அவனுடைய கைகள் அவனுடைய சகோதரனாகிய ஏசாவின் கைகளைப்போல ரோமமுள்ளவைகளாக இருந்ததால், யாரென்று தெரியாமல், அவனை ஆசீர்வதித்து, ");
INSERT INTO tam2017_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","“நீ என் மகனாகிய ஏசாதானோ” என்றான்; அவன்: “நான்தான்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","அப்பொழுது அவன்: “என் மகனே, நீ வேட்டையாடிக் கொண்டுவந்ததை நான் சாப்பிட்டு, என் ஆத்துமா உன்னை ஆசீர்வதிப்பதற்கு அதை என்னருகில் கொண்டுவா” என்றான்; அவன் அதை அருகில் கொண்டுபோனான்; அப்பொழுது அவன் சாப்பிட்டான்; பிறகு, திராட்சைரசத்தை அவனுக்குக் கொண்டுவந்து கொடுத்தான், அவன் குடித்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","அப்பொழுது அவனுடைய தகப்பனாகிய ஈசாக்கு அவனை நோக்கி: “என் மகனே, நீ அருகில் வந்து என்னை முத்தம்செய்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","அவன் அருகில் போய், அவனை முத்தம்செய்தான்; அப்பொழுது அவனுடைய ஆடைகளின் வாசனையை முகர்ந்து: “இதோ, என் மகனுடைய வாசனை யெகோவா ஆசீர்வதித்த வயல்வெளியின் வாசனையைப்போல் இருக்கிறது. ");
INSERT INTO tam2017_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","தேவன் உனக்கு வானத்துப் பனியையும் பூமியின் கொழுமையையும் கொடுத்து, மிகுந்த தானியத்தையும் திராட்சைரசத்தையும் தந்தருளுவாராக. ");
INSERT INTO tam2017_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","மக்கள் உன்னைச் சேவித்து தேசங்கள் உன்னை வணங்குவார்களாக; உன் சகோதரர்களுக்கு எஜமானாயிருப்பாய்; உன் தாயின் மகன்கள் உன்னை வணங்குவார்கள்; உன்னைச் சபிக்கிறவர்கள் சபிக்கப்பட்டவர்களும், உன்னை ஆசீர்வதிக்கிறவர்கள் ஆசீர்வதிக்கப்பட்டவர்களுமாக இருப்பார்கள்” என்று சொல்லி அவனை ஆசீர்வதித்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ஈசாக்கு யாக்கோபை ஆசீர்வதித்து முடிந்தபோது, யாக்கோபு தன் தகப்பனாகிய ஈசாக்கைவிட்டுப் புறப்பட்டவுடனே, அவனுடைய சகோதரனாகிய ஏசா வேட்டையாடி வந்து சேர்ந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","அவனும் ருசியுள்ள உணவுகளைச் சமைத்து, தன் தகப்பனிடம் கொண்டுவந்து, தகப்பனை நோக்கி: “உம்முடைய ஆத்துமா என்னை ஆசீர்வதிக்க, என் தகப்பனார் எழுந்திருந்து, உம்முடைய மகனாகிய நான் வேட்டையாடிக் கொண்டுவந்ததைச் சாப்பிடும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","அப்பொழுது அவனுடைய தகப்பனாகிய ஈசாக்கு: “நீ யார்” என்றான்; அதற்கு அவன்: “நான் உமது மூத்த மகனாகிய ஏசா” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","அப்பொழுது ஈசாக்கு மிகவும் அதிர்ச்சியடைந்து நடுங்கி: “வேட்டையாடி எனக்குக் கொண்டுவந்தானே, அவன் யார்? நீ வருவதற்குமுன்னே அவைகளையெல்லாம் நான் சாப்பிட்டு அவனை ஆசீர்வதித்தேனே, அவனே ஆசீர்வதிக்கப்பட்டவனாகவும் இருப்பான்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","ஏசா தன் தகப்பனுடைய வார்த்தைகளைக் கேட்டவுடனே, மிகவும் மனமுடைந்து அதிக சத்தமிட்டு அலறி, தன் தகப்பனை நோக்கி: “என் தகப்பனே, என்னையும் ஆசீர்வதியும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","அதற்கு அவன்: “உன் சகோதரன் தந்திரமாக வந்து, உன்னுடைய ஆசீர்வாதத்தைப் பெற்றுக்கொண்டான்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","அப்பொழுது அவன்: “அவனுடைய பெயர் யாக்கோபு என்பது சரியல்லவா? இதோடு இரண்டுமுறை என்னை ஏமாற்றினான்; என் பிறப்புரிமையை எடுத்துக்கொண்டான்; இதோ, இப்பொழுது என் ஆசீர்வாதத்தையும் வாங்கிக்கொண்டான்” என்று சொல்லி, “நீர் எனக்கு ஒரு ஆசீர்வாதத்தையாவது வைத்திருக்கவில்லையா” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ஈசாக்கு ஏசாவுக்கு மறுமொழியாக: “இதோ, நான் அவனை உனக்கு எஜமானாக வைத்தேன்; அவனுடைய சகோதரர்கள் எல்லோரையும் அவனுக்கு வேலைக்காரராகக் கொடுத்து, அவனைத் தானியத்தினாலும் திராட்சைரசத்தினாலும் ஆதரித்தேன்; இப்பொழுதும் என் மகனே, நான் உனக்கு என்னசெய்வேன் என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","ஏசா தன் தகப்பனை நோக்கி: “என் தகப்பனே, இந்த ஒரே ஆசீர்வாதம் மாத்திரமா உம்மிடத்தில் உண்டு? என் தகப்பனே, என்னையும் ஆசீர்வதியும் என்று சொல்லி”, ஏசா சத்தமிட்டு அழுதான். ");
INSERT INTO tam2017_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","அப்பொழுது அவனுடைய தகப்பனாகிய ஈசாக்கு அவனுக்கு மறுமொழியாக: “உன் குடியிருப்பு பூமியின் சாரத்தோடும் உயர வானத்திலிருந்து இறங்கும் பனியோடும் இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","உன் ஆயுதத்தால் நீ பிழைத்து, உன் சகோதரனுக்குப் பணிவிடை செய்வாய்; நீ மேற்கொள்ளும் காலம் வரும்போதோ, உன் மேலிருக்கிற அவனுடைய ஆளுகையை உடைத்துப்போடுவாய்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","யாக்கோபைத் தன் தகப்பன் ஆசீர்வதித்ததால் ஏசா யாக்கோபைப் பகைத்து: “என் தகப்பனுக்காகத் துக்கிக்கும் நாட்கள் சீக்கிரமாக வரும், அப்பொழுது என் சகோதரனாகிய யாக்கோபைக் கொன்றுபோடுவேன்” என்று ஏசா தன் இருதயத்திலே சொல்லிக்கொண்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","மூத்த மகனாகிய ஏசாவின் வார்த்தைகள் ரெபெக்காளுக்கு அறிவிக்கப்பட்டது; அப்பொழுது அவள் தன் இளைய மகனாகிய யாக்கோபை அழைத்து: “உன் சகோதரனாகிய ஏசா உன்னைக் கொன்றுபோட நினைத்து, தன்னைத் தேற்றிக்கொள்ளுகிறான். ");
INSERT INTO tam2017_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ஆகையால், என் மகனே, நான் சொல்வதைக் கேட்டு, எழுந்து புறப்பட்டு, ஆரானில் இருக்கிற என் சகோதரனாகிய லாபானிடத்திற்கு ஓடிப்போய், ");
INSERT INTO tam2017_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","உன் சகோதரன் உன்மேல் கொண்ட கோபம் தணியும்வரை சிலநாட்கள் அவனிடத்தில் இரு. ");
INSERT INTO tam2017_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","உன் சகோதரன் உன்மேல் கொண்ட கோபம் தணிந்து, நீ அவனுக்குச் செய்ததை அவன் மறந்தபின்பு, நான் ஆள் அனுப்பி, அந்த இடத்திலிருந்து உன்னை வரவழைப்பேன்; நான் ஒரே நாளில் உங்கள் இருவரையும் ஏன் இழந்துபோகவேண்டும்” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","பின்பு, ரெபெக்காள் ஈசாக்கை நோக்கி: “ஏத்தின் பெண்களால் என் வாழ்க்கை எனக்கு வெறுப்பாயிருக்கிறது; இந்தத் தேசத்துப் பெண்களாகிய ஏத்தின் பெண்களில் யாக்கோபு ஒரு பெண்ணைத் திருமணம் செய்தால் என் உயிர் இருந்து என்ன பயன்” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ஈசாக்கு யாக்கோபை அழைத்து, அவனை ஆசீர்வதித்து, “நீ கானானியர்களுடைய பெண்களைத் திருமணம் செய்யாமல், ");
INSERT INTO tam2017_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","எழுந்து புறப்பட்டு, பதான் அராமிலிருக்கும் உன் தாயினுடைய தகப்பனாகிய பெத்துவேலுடைய வீட்டிற்குப் போய், அந்த இடத்தில் உன் தாயின் சகோதரனாகிய லாபானின் மகள்களுக்குள் ஒருவளை மனைவியாக்கிக்கொள் என்று அவனுக்குக் கட்டளையிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","சர்வவல்லமையுள்ள தேவன் உன்னை ஆசீர்வதித்து, நீ பல மக்கள்கூட்டமாக உன்னைப் பலுகவும் பெருகவும்செய்து; ");
INSERT INTO tam2017_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","தேவன் ஆபிரகாமுக்குக் கொடுத்ததும் நீ பரதேசியாகத் தங்குகிறதுமான தேசத்தை நீ சொந்தமாக்கிக்கொள்ள ஆபிரகாமுக்கு அருளிய ஆசீர்வாதத்தை உனக்கும் உன் சந்ததிக்கும் அருளுவாராக என்று சொல்லி; ");
INSERT INTO tam2017_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ஈசாக்கு யாக்கோபை அனுப்பிவிட்டான். அப்பொழுது அவன் பதான் அராமிலிருக்கும் சீரியா தேசத்தானாகிய பெத்துவேலுடைய மகனும், தனக்கும் ஏசாவுக்கும் தாயாகிய ரெபெக்காளின் சகோதரனுமான லாபானிடத்திற்குப் போகப் புறப்பட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","ஈசாக்கு யாக்கோபை ஆசீர்வதித்து, ஒரு பெண்ணைத் திருமணம் செய்ய அவனைப் பதான் அராமுக்கு அனுப்பினதையும், அவனை ஆசீர்வதிக்கும்போது: “நீ கானானியர்களுடைய பெண்களைத் திருமணம் செய்யவேண்டாம் என்று அவனுக்குக் கட்டளையிட்டதையும், ");
INSERT INTO tam2017_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","யாக்கோபு தன் தகப்பனுக்கும் தன் தாய்க்கும் கீழ்ப்படிந்து, பதான் அராமுக்குப் புறப்பட்டுப்போனதையும் ஏசா கண்டதாலும், ஏசா இஸ்மவேலின் மகளும் நெபாயோத்தின் சகோதரியுமாகிய மகலாத்தையும் திருமணம் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","கானானியர்களுடைய பெண்கள் தன் தகப்பனாகிய ஈசாக்கின் பார்வைக்கு ஆகாதவர்கள் என்பதை ஏசா அறிந்ததாலும், ");
INSERT INTO tam2017_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ஏசா இஸ்மவேலிடத்திற்குப் போய், தனக்கு முன்னிருந்த மனைவிகளுமன்றி, ஆபிரகாமுடைய மகனாகிய இஸ்மவேலின் மகளும் நெபாயோத்தின் சகோதரியுமாகிய மகலாத்தையும் திருமணம் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","யாக்கோபு பெயெர்செபாவை விட்டு ஆரானுக்குப் போகப் பயணம்செய்து, ");
INSERT INTO tam2017_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","ஒரு இடத்திலே வந்து, சூரியன் மறைந்ததினால், அங்கே இரவில் தங்கி, அங்கேயிருந்த கற்களில் ஒன்றை எடுத்துத் தன் தலையின்கீழ் வைத்து, அங்கே படுத்துத் தூங்கினான். ");
INSERT INTO tam2017_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","அங்கே அவன் ஒரு கனவுகண்டான்; இதோ, ஒரு ஏணி பூமியிலே வைக்கப்பட்டிருந்தது, அதின் நுனி வானத்தை எட்டியிருந்தது, அதிலே தேவதூதர்கள் ஏறுகிறவர்களும் இறங்குகிறவர்களுமாக இருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","அதற்கு மேலாகக் யெகோவா நின்று: “நான் உன் தகப்பனாகிய ஆபிரகாமின் தேவனும் ஈசாக்கின் தேவனுமாகிய யெகோவா; நீ படுத்திருக்கிற பூமியை உனக்கும் உன் சந்ததிக்கும் தருவேன். ");
INSERT INTO tam2017_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","உன் சந்ததி பூமியின் தூளைப்போலிருக்கும்; நீ மேற்கேயும், கிழக்கேயும், வடக்கேயும், தெற்கேயும் பரவுவாய்; உனக்குள்ளும் உன் சந்ததிக்குள்ளும் பூமியின் வம்சங்களெல்லாம் ஆசீர்வதிக்கப்படும். ");
INSERT INTO tam2017_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","நான் உன்னோடு இருந்து, நீ போகிற இடத்திலெல்லாம் உன்னைக் காத்து, இந்தத் தேசத்திற்கு உன்னைத் திரும்பி வரச்செய்வேன்; நான் உனக்குச் சொன்னதைச் செய்யும்வரை உன்னைக் கைவிடுவதில்லை” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","யாக்கோபு தூக்கம் கலைந்து விழித்தபோது: “உண்மையாகவே யெகோவா இந்த இடத்தில் இருக்கிறார்; இதை நான் அறியாமலிருந்தேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","அவன் பயந்து, இந்த இடம் எவ்வளவு பயங்கரமாயிருக்கிறது! இது தேவனுடைய வீடேயல்லாமல் வேறல்ல, இது வானத்தின் வாசல்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","அதிகாலையில் யாக்கோபு எழுந்து, தன் தலையின்கீழ் வைத்திருந்த கல்லை எடுத்து, அதைத் தூணாக நிறுத்தி, அதின்மேல் எண்ணெய் ஊற்றி, ");
INSERT INTO tam2017_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","அந்த இடத்திற்குப் பெத்தேல் என்று பெயரிட்டான்; அதற்கு முன்னே அந்த ஊருக்கு லூஸ் என்னும் பெயர் இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","அப்பொழுது யாக்கோபு: “தேவன் என்னோடிருந்து, நான் போகிற இந்த வழியிலே என்னைக் காப்பாற்றி, உண்ண உணவும், உடுக்க உடையும் எனக்குத் தந்து, ");
INSERT INTO tam2017_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","என்னை என் தகப்பன் வீட்டிற்குச் சமாதானத்தோடு திரும்பிவரச் செய்வாரானால், யெகோவா எனக்குத் தேவனாயிருப்பார்; ");
INSERT INTO tam2017_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","நான் தூணாக நிறுத்தின இந்தக் கல் தேவனுக்கு வீடாகும்; தேவரீர் எனக்குத் தரும் எல்லாவற்றிலும் உமக்குத் தசமபாகம் செலுத்துவேன்” என்று சொல்லிப் பொருத்தனை செய்துகொண்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","யாக்கோபு பயணம்செய்து, கிழக்கு தேசத்தாரிடத்தில் போய்ச் சேர்ந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","அங்கே வயல்வெளியிலே ஒரு கிணற்றையும், அதின் அருகே சேர்க்கப்பட்டிருக்கிற மூன்று ஆட்டுமந்தைகளையும் கண்டான்; அந்தக் கிணற்றிலே மந்தைகளுக்குத் தண்ணீர் காட்டுவார்கள்; அந்தக் கிணறு ஒரு பெரிய கல்லினால் மூடப்பட்டிருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","அந்த இடத்தில் மந்தைகள் எல்லாம் சேர்ந்தபின் கிணற்றை மூடியிருக்கும் கல்லை மேய்ப்பர்கள் புரட்டி, ஆடுகளுக்குத் தண்ணீர் காட்டி, மறுபடியும் கல்லை முன்பிருந்ததுபோல கிணற்றை மூடிவைப்பார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","யாக்கோபு அவர்களைப் பார்த்து: “சகோதரர்களே, நீங்கள் எந்த ஊரைச் சேர்ந்தவர்கள்” என்றான்; அவர்கள், “நாங்கள் ஆரான் ஊரைச் சேர்ந்தவர்கள்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","அப்பொழுது அவன்: “நாகோரின் மகனாகிய லாபானை அறிவீர்களா” என்று கேட்டான்; “அறிவோம்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","“அவன் சுகமாயிருக்கிறானா” என்று விசாரித்தான்; அதற்கு அவர்கள்: “சுகமாயிருக்கிறான்; அவனுடைய மகளாகிய ராகேல், அதோ, ஆடுகளை ஓட்டிக்கொண்டு வருகிறாள்” என்று சொன்னார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","அப்பொழுது அவன்: “இன்னும் அதிக நேரமிருக்கிறதே; இது மந்தைகளைச் சேர்க்கிற நேரமல்லவே, ஆடுகளுக்குத் தண்ணீர் காட்டி, இன்னும் மேயவிடலாம்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","அதற்கு அவர்கள்: “எல்லா மந்தைகளும் சேருமுன்னே அப்படிச் செய்யக்கூடாது; சேர்ந்தபின் கிணற்றை மூடியிருக்கிற கல்லைப் புரட்டுவார்கள்; அப்பொழுது ஆடுகளுக்குத் தண்ணீர் காட்டுவோம்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","அவர்களோடு அவன் பேசிக்கொண்டிருக்கும்போதே, தன் தகப்பனுடைய ஆடுகளை மேய்த்துக்கொண்டிருந்த ராகேல் அந்த ஆடுகளை ஓட்டிக்கொண்டு வந்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","யாக்கோபு தன் தாயின் சகோதரனான லாபானுடைய மகளாகிய ராகேலையும், தன் தாயின் சகோதரனாகிய லாபானின் ஆடுகளையும் கண்டபோது, யாக்கோபு போய், கிணற்றை மூடியிருந்த கல்லைப் புரட்டி, தன் தாயின் சகோதரனாகிய லாபானின் ஆடுகளுக்குத் தண்ணீர் காட்டினான். ");
INSERT INTO tam2017_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","பின்பு யாக்கோபு ராகேலை முத்தம்செய்து, சத்தமிட்டு அழுது, ");
INSERT INTO tam2017_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","தான் அவள் தகப்பனுடைய மருமகனென்றும், ரெபெக்காளின் மகனென்றும் ராகேலுக்கு அறிவித்தான். அவள் ஓடிப்போய்த் தன் தகப்பனுக்கு அறிவித்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","லாபான் தன் சகோதரியின் மகனாகிய யாக்கோபுடைய செய்தியைக் கேட்டபோது, அவனுக்கு எதிர்கொண்டோடி, அவனைத் தழுவி முத்தம்செய்து, தன் வீட்டிற்கு அழைத்துக்கொண்டுபோனான்; அவன் தன் காரியங்களையெல்லாம் விவரமாக லாபானுக்குச் சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","அப்பொழுது லாபான்: “நீ என் எலும்பும் என் மாம்சமுமானவன்” என்றான். ஒரு மாதம்வரைக்கும் யாக்கோபு அவனிடத்தில் தங்கினான். ");
INSERT INTO tam2017_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","பின்பு லாபான் யாக்கோபை நோக்கி: “நீ என் மருமகனாயிருப்பதால், சும்மா எனக்கு வேலைசெய்யலாமா? சம்பளம் எவ்வளவு கேட்கிறாய்”, சொல் என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","லாபானுக்கு இரண்டு மகள்கள் இருந்தார்கள்; மூத்தவள் பெயர் லேயாள், இளையவள் பெயர் ராகேல். ");
INSERT INTO tam2017_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","லேயாளுடைய கண்கள் கூச்சப்பார்வையாயிருந்தது; ராகேலோ ரூபவதியும் பார்ப்பதற்கு அழகுள்ளவளாக இருந்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","யாக்கோபு ராகேல் மீது பிரியப்பட்டு: “உம்முடைய இளைய மகளாகிய ராகேலுக்காக உம்மிடத்தில் ஏழு வருடங்கள் வேலை செய்கிறேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","அதற்கு லாபான்: “நான் அவளை வேறொருவனுக்குக் கொடுக்கிறதைவிட, அவளை உனக்குக் கொடுக்கிறது உத்தமம், என்னிடத்தில் தங்கியிரு” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","அந்தப்படியே யாக்கோபு ராகேலுக்காக ஏழு வருடங்கள் வேலை செய்தான்; அவள் மேலிருந்த பிரியத்தினாலே அந்த வருடங்கள் அவனுக்குக் கொஞ்ச நாளாகத் தோன்றினது. ");
INSERT INTO tam2017_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","பின்பு யாக்கோபு லாபானை நோக்கி: “என் நாட்கள் நிறைவேறிவிட்டதால், என் மனைவியிடத்தில் நான் சேரும்படி அவளை எனக்குத் தரவேண்டும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","அப்பொழுது லாபான் அந்த இடத்து மனிதர்கள் எல்லோரையும் கூடிவரச்செய்து விருந்துசெய்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","அன்று இரவிலே அவன் தன் மகளாகிய லேயாளை அழைத்துக்கொண்டுபோய், அவனிடத்தில் விட்டான்; அவளை அவன் சேர்ந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","லாபான் தன் வேலைக்காரியாகிய சில்பாளைத் தன் மகளாகிய லேயாளுக்கு வேலைக்காரியாகக் கொடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","காலையிலே, இதோ, அவள் லேயாள் என்று யாக்கோபு கண்டு, லாபானை நோக்கி: “ஏன் எனக்கு இப்படிச் செய்தீர்? ராகேலுக்காக அல்லவா உம்மிடத்தில் வேலைசெய்தேன்; பின்பு ஏன் என்னை ஏமாற்றினீர்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","அதற்கு லாபான்: “மூத்தவள் இருக்க இளையவளைக் கொடுப்பது இந்த இடத்தின் வழக்கம் இல்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","இவளுடைய ஏழு நாட்களை நிறைவேற்று; அவளையும் உனக்குத் தருவேன்; அவளுக்காகவும் நீ இன்னும் ஏழு வருடங்கள் என்னிடத்திலே வேலைசெய்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","அப்படியே யாக்கோபு, இவளுடைய ஏழு நாட்களை நிறைவேற்றினான். அப்பொழுது தன் மகளாகிய ராகேலையும் அவனுக்கு மனைவியாகக் கொடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","மேலும் லாபான் தன் வேலைக்காரியாகிய பில்காளைத் தன் மகளாகிய ராகேலுக்கு வேலைக்காரியாகக் கொடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","யாக்கோபு ராகேலையும் சேர்ந்தான்; லேயாளைவிட ராகேலை அவன் அதிகமாக நேசித்து, பின்னும் ஏழு வருடங்கள் அவனிடத்தில் வேலை செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","லேயாள் அற்பமாக எண்ணப்பட்டாள் என்று யெகோவா கண்டு, அவள் கர்ப்பந்தரிக்கும்படி செய்தார்; ராகேலோ மலடியாயிருந்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","லேயாள் கர்ப்பவதியாகி ஒரு மகனைப் பெற்று: “யெகோவா என் சிறுமையைப் பார்த்தருளினார்; இப்பொழுது என் கணவன் என்னை நேசிப்பார்” என்று சொல்லி, அவனுக்கு ரூபன் என்று பெயரிட்டாள். ");
INSERT INTO tam2017_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","மறுபடியும் அவள் கர்ப்பவதியாகி ஒரு மகனைப் பெற்று: “நான் அற்பமாக எண்ணப்பட்டதைக் யெகோவா கேட்டருளி, இவனையும் எனக்குத் தந்தார்” என்று சொல்லி, அவனுக்கு சிமியோன் என்று பெயரிட்டாள். ");
INSERT INTO tam2017_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","பின்னும் அவள் கர்ப்பவதியாகி ஒரு மகனைப் பெற்று: “என் கணவனுக்கு மூன்று மகன்களைப் பெற்றதால் அவர் இப்பொழுது என்னோடு சேர்ந்திருப்பார்” என்று சொல்லி, அவனுக்கு லேவி என்று பெயரிட்டாள். ");
INSERT INTO tam2017_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","மறுபடியும் அவள் கர்ப்பவதியாகி ஒரு மகனைப் பெற்று: “இப்பொழுது யெகோவாவைத் துதிப்பேன்” என்று சொல்லி, அவனுக்கு யூதா என்று பெயரிட்டாள்; பின்பு அவளுக்குப் பிள்ளைப்பேறு நின்றுபோனது. ");
INSERT INTO tam2017_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","ராகேல் தான் யாக்கோபுக்குப் பிள்ளைகளைப் பெறாததைக்கண்டு, தன் சகோதரியின்மேல் பொறாமைப்பட்டு, யாக்கோபை நோக்கி: “எனக்குப் பிள்ளைகொடும், இல்லாவிட்டால் நான் சாகிறேன்” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","அப்பொழுது யாக்கோபு ராகேலின்மேல் கோபமடைந்து: “தேவனல்லவோ உன் கர்ப்பத்தை அடைத்திருக்கிறார், நான் தேவனா?” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","அப்பொழுது அவள்: “இதோ, என் வேலைக்காரியாகிய பில்காள் இருக்கிறாளே; நான் வளர்க்க அவள் பிள்ளைகளைப் பெறவும், அவள் மூலமாவது என் வீடு கட்டப்படவும் அவளிடத்தில் சேரும்” என்று சொல்லி, ");
INSERT INTO tam2017_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","அவனுக்குத் தன் வேலைக்காரியாகிய பில்காளை மனைவியாகக் கொடுத்தாள்; அப்படியே யாக்கோபு அவளைச் சேர்ந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","பில்காள் கர்ப்பவதியாகி, யாக்கோபுக்கு ஒரு மகனைப் பெற்றெடுத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","அப்பொழுது ராகேல்: “தேவன் என் வழக்கைத் தீர்த்து, என் சத்தத்தையும் கேட்டு, எனக்கு ஒரு மகனைக் கொடுத்தார்” என்று சொல்லி, அவனுக்குத் தாண் என்று பெயரிட்டாள். ");
INSERT INTO tam2017_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","மறுபடியும் ராகேலின் வேலைக்காரியாகிய பில்காள் கர்ப்பவதியாகி, யாக்கோபுக்கு இரண்டாம் மகனைப் பெற்றெடுத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","அப்பொழுது ராகேல்: “நான் மகா போராட்டமாக என் சகோதரியோடு போராடி மேற்கொண்டேன்” என்று சொல்லி, அவனுக்கு நப்தலி என்று பெயரிட்டாள். ");
INSERT INTO tam2017_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","லேயாள் தனது பிள்ளைபேறு நின்றுபோனதைக் கண்டு, தன் வேலைக்காரியாகிய சில்பாளை அழைத்து, அவளை யாக்கோபுக்கு மனைவியாகக் கொடுத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","லேயாளின் வேலைக்காரியாகிய சில்பாள் யாக்கோபுக்கு ஒரு மகனைப் பெற்றெடுத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","அப்பொழுது லேயாள்: “ஏராளமாகிறதென்று” சொல்லி, அவனுக்குக் காத் என்று பெயரிட்டாள். ");
INSERT INTO tam2017_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","பின்பு லேயாளின் வேலைக்காரியாகிய சில்பாள் யாக்கோபுக்கு இரண்டாம் மகனைப் பெற்றெடுத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","அப்பொழுது லேயாள்: “நான் பாக்கியவதி, பெண்கள் என்னைப் பாக்கியவதி என்பார்கள்” என்று சொல்லி, அவனுக்கு ஆசேர் என்று பெயரிட்டாள். ");
INSERT INTO tam2017_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","கோதுமை அறுப்பு நாட்களில் ரூபன் வயல்வெளிக்குப் போய், தூதாயீம் பழங்களைக் கண்டெடுத்து, அவைகளைக் கொண்டுவந்து தன் தாயாகிய லேயாளிடத்தில் கொடுத்தான். அப்பொழுது ராகேல் லேயாளை நோக்கி: “உன் மகனுடைய தூதாயீம் பழத்தில் எனக்குக் கொஞ்சம் தா” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","அதற்கு அவள்: “நீ என் கணவனை எடுத்துக்கொண்டது சாதாரணகாரியமா? என் மகனுடைய தூதாயீம் பழங்களையும் எடுத்துக்கொள்ளவேண்டுமோ என்றாள்;” அதற்கு ராகேல்: “உன் மகனுடைய தூதாயீம் பழங்களுக்கு ஈடாக இன்று இரவு அவர் உன்னோடு உறவுகொள்ளட்டும்” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","மாலையில் யாக்கோபு வெளியிலிருந்து வரும்போது லேயாள் புறப்பட்டு அவனுக்கு எதிர்கொண்டுபோய்: “என் மகனுடைய தூதாயீம் பழங்களால் உம்மை வாங்கினேன்; ஆகையால், நீர் என்னிடத்தில் வரவேண்டும்” என்றாள்; அவன் அன்று இரவு அவளோடு உறவுகொண்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","தேவன் லேயாளுக்குச் செவிகொடுத்தார். அவள் கர்ப்பவதியாகி யாக்கோபுக்கு ஐந்தாம் மகனைப் பெற்றெடுத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","அப்பொழுது லேயாள்: “நான் என் வேலைக்காரியை என் கணவனுக்குக் கொடுத்த பலனைத் தேவன் எனக்குத் தந்தார்” என்று சொல்லி, அவனுக்கு இசக்கார் என்று பெயரிட்டாள். ");
INSERT INTO tam2017_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","மேலும் லேயாள் கர்ப்பவதியாகி யாக்கோபுக்கு ஆறாம் மகனைப் பெற்றெடுத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","அப்பொழுது லேயாள்: “தேவன் எனக்கு நல்ல வெகுமதியைத் தந்தார்; என் கணவனுக்கு நான் ஆறு மகன்களைப் பெற்றதால், இப்பொழுது அவர் என்னுடனே தங்கியிருப்பார்” என்று சொல்லி, அவனுக்குச் செபுலோன் என்று பெயரிட்டாள். ");
INSERT INTO tam2017_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","பின்பு அவள் ஒரு மகளையும் பெற்று, அவளுக்குத் தீனாள் என்று பெயரிட்டாள். ");
INSERT INTO tam2017_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","தேவன் ராகேலை நினைத்தருளினார்; அவளுக்குத் தேவன் செவிகொடுத்து, அவள் கர்ப்பமடையச் செய்தார். ");
INSERT INTO tam2017_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","அவள் கர்ப்பவதியாகி ஒரு மகனைப் பெற்று: “தேவன் என் நிந்தையை நீக்கிவிட்டார் என்றும், ");
INSERT INTO tam2017_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","இன்னும் ஒரு மகனைக் யெகோவா எனக்குத் தருவார்” என்றும் சொல்லி, அவனுக்கு யோசேப்பு என்று பெயரிட்டாள். ");
INSERT INTO tam2017_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","ராகேல் யோசேப்பைப் பெற்றபின், யாக்கோபு லாபானை நோக்கி: “நான் என் வீட்டிற்கும் என் தேசத்திற்கும் போக என்னை அனுப்பிவிடும். ");
INSERT INTO tam2017_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","நான் உமக்கு வேலைசெய்து சம்பாதித்த என் மனைவிகளையும் என் பிள்ளைகளையும் எனக்குத் தாரும்; நான் போவேன், நான் உம்மிடத்தில் வேலை செய்த விதத்தை நீர் அறிந்திருக்கிறீர்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","அப்பொழுது லாபான்: “உன் கண்களில் எனக்குத் தயவு கிடைத்ததேயானால் நீ இரு; உன்னால் யெகோவா என்னை ஆசீர்வதித்தார் என்று அனுபவத்தில் அறிந்தேன். ");
INSERT INTO tam2017_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","உன் சம்பளம் எவ்வளவென்று எனக்குச் சொல், நான் அதைத் தருவேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","அதற்கு அவன்: “நான் உமக்கு வேலை செய்தவிதத்தையும், உம்முடைய மந்தை என்னிடத்தில் இருந்த விதத்தையும் அறிந்திருக்கிறீர். ");
INSERT INTO tam2017_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","நான் வருமுன்னே உமக்கு இருந்தது கொஞ்சம்; நான் வந்தபின் யெகோவா உம்மை ஆசீர்வதித்ததால் அது மிகவும் பெருகியிருக்கிறது; இனி நான் என் குடும்பத்திற்குச் சம்பாதிப்பது எப்பொழுது” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","அதற்கு அவன்: “நான் உனக்கு என்ன தரவேண்டும் என்றான்; யாக்கோபு: “நீர் எனக்கு ஒன்றும் தரவேண்டியதில்லை; நான் சொல்லுகிறபடி நீர் எனக்குச் செய்தால், உம்முடைய மந்தையைத் திரும்ப மேய்ப்பேன். ");
INSERT INTO tam2017_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","நான் இன்றைக்குப்போய், உம்முடைய மந்தைகளையெல்லாம் பார்வையிட்டு, அவைகளில் புள்ளியும் வரியும் கறுப்புமுள்ள செம்மறியாடுகளையும், வரியும் புள்ளியுமுள்ள வெள்ளாடுகளையும் பிரித்துவிடுகிறேன்; அப்படிப்பட்டவை இனி எனக்குச் சம்பளமாயிருக்கட்டும். ");
INSERT INTO tam2017_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","அப்படியே இனிமேல் என் சம்பளமாகிய இவற்றை நீர் பார்வையிடும்போது, என் நீதி விளங்கும்; புள்ளியும் வரியுமில்லாத வெள்ளாடுகளும், கறுப்பான செம்மறியாடுகளும் என்னிடத்தில் இருந்தால், அவையெல்லாம் என்னால் திருடப்பட்டவைகளாக எண்ணப்படட்டும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","அதற்கு லாபான்: “நீ சொன்னபடியே ஆகட்டும்” என்று சொல்லி, ");
INSERT INTO tam2017_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","அந்த நாளிலே கலப்பு நிறமும் வரியுமுள்ள வெள்ளாட்டுக் கடாக்களையும், புள்ளியும் வரியுமுள்ள வெள்ளாடுகள் அனைத்தையும், சற்று வெண்மையும் கருமையுமுள்ள செம்மறியாடுகள் அனைத்தையும் பிரித்து, தன் மகன்களிடத்தில் ஒப்புவித்து, ");
INSERT INTO tam2017_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","தனக்கும் யாக்கோபுக்கும் இடையிலே மூன்றுநாட்கள் பயணதூரத்தில் இருக்கும்படி வைத்தான். லாபானுடைய மற்ற ஆடுகளை யாக்கோபு மேய்த்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","பின்பு யாக்கோபு பச்சையாயிருக்கிற புன்னை, வாதுமை, அர்மோன் என்னும் மரங்களின் கிளைகளை வெட்டி, இடையிடையே வெண்மை தோன்றும்படி பட்டையை உரித்து, ");
INSERT INTO tam2017_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","தான் உரித்த கிளைகளை ஆடுகள் தண்ணீர் குடிக்க வரும் கால்வாய்களிலும் தொட்டிகளிலும் ஆடுகளுக்கு முன்பாகப் போட்டுவைப்பான்; ஆடுகள் தண்ணீர் குடிக்க வரும்போது சினையாவதுண்டு. ");
INSERT INTO tam2017_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ஆடுகள் அந்தக் கிளைகளுக்கு முன்பாகச் சினைப்பட்டதால், அவைகள் கலப்பு நிறமுள்ளதும் புள்ளியுள்ளதும் வரியுள்ளதுமான குட்டிகளைப் போட்டது. ");
INSERT INTO tam2017_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","அந்த ஆட்டுக்குட்டிகளை யாக்கோபு பிரித்துக்கொண்டு, ஆடுகளை லாபானுடைய மந்தையிலிருக்கும் கலப்பு நிறமானவைகளுக்கும் கறுப்பானவைகளெல்லாவற்றிற்கும் முன்பாக நிறுத்தி, தன் ஆடுகளை லாபானுடைய மந்தையுடன் சேர்க்காமல், தனியாக வைத்துக்கொள்வான். ");
INSERT INTO tam2017_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","பலத்த ஆடுகள் சினையாகும்போது, அந்தக் கிளைகளுக்கு முன்பாக சினையாகும்படி யாக்கோபு அவைகளை அந்த ஆடுகளின் கண்களுக்கு முன்பாகக் கால்வாய்களிலே போட்டுவைப்பான். ");
INSERT INTO tam2017_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","பலவீனமான ஆடுகள் சினைப்படும்போது, அவைகளைப் போடாமலிருப்பான்; இதனால் பலவீனமானவைகள் லாபானையும், பலமுள்ளவைகள் யாக்கோபையும் சேர்ந்தன. ");
INSERT INTO tam2017_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","இந்த விதமாக அந்த மனிதன் மிகவும் விருத்தியடைந்து, ஏராளமான ஆடுகளும், வேலைக்காரிகளும், வேலைக்காரரும், ஒட்டகங்களும், கழுதைகளும் உடையவனானான். ");
INSERT INTO tam2017_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","பின்பு, லாபானுடைய மகன்கள்: “எங்கள் தகப்பனுக்கு உண்டானவைகள் அனைத்தையும் யாக்கோபு எடுத்துக்கொண்டான்” என்றும், எங்கள் தகப்பனுடைய பொருட்களினாலே இந்த செல்வத்தையெல்லாம் அடைந்தான் என்றும் சொன்ன வார்த்தைகளை யாக்கோபு கேட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","லாபானின் முகத்தை யாக்கோபு பார்த்தபோது, அது நேற்று முந்தையநாள் இருந்ததுபோல இல்லாமல் வேறுபட்டிருந்ததைக் கண்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","யெகோவா யாக்கோபை நோக்கி: “உன் பிதாக்களுடைய தேசத்திற்கும் உன் இனத்தாரிடத்திற்கும் நீ திரும்பிப் போ; நான் உன்னோடுகூட இருப்பேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","அப்பொழுது யாக்கோபு, ராகேலையும் லேயாளையும் வெளியிலே தன் மந்தையினிடத்திற்கு வரவழைத்து, ");
INSERT INTO tam2017_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","அவர்களை நோக்கி “உங்கள் தகப்பனுடைய முகம் நேற்று முந்தையநாள் இருந்ததுபோல இருக்கவில்லை என்று எனக்குத் தோன்றுகிறது; ஆனாலும் என் தகப்பனுடைய தேவன் என்னோடுகூட இருக்கிறார்”. ");
INSERT INTO tam2017_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","என்னால் முடிந்தவரை நான் உங்களுடைய தகப்பனுக்கு வேலை செய்தேன் என்று நீங்கள் அறிந்திருக்கிறீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","உங்கள் தகப்பனோ, என்னை ஏமாற்றி, என் சம்பளத்தைப் பத்துமுறை மாற்றினான்; ஆனாலும் அவன் எனக்குத் தீங்குசெய்ய தேவன் அவனுக்கு இடம்கொடுக்கவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","புள்ளியுள்ளவைகள் உன் சம்பளமாயிருக்கும் என்று அவன் சொன்னபோது, ஆடுகளெல்லாம் புள்ளியுள்ள குட்டிகளைப் போட்டது; கலப்புநிறமானவைகள் உன் சம்பளமாயிருக்கும் என்று அவன் சொன்னபோது, ஆடுகளெல்லாம் கலப்பு நிறக் குட்டிகளைப் போட்டது. ");
INSERT INTO tam2017_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","இந்த விதமாகத் தேவன் உங்கள் தகப்பனுடைய ஆடுகளை எடுத்து, எனக்குத் தந்தார். ");
INSERT INTO tam2017_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","ஆடுகள் சினையாகும்போது, நான் கண்ட கனவில் என் கண்களை ஏறெடுத்துப் பார்க்கும்போது, ஆடுகளோடு இணையும் கடாக்கள் கலப்புநிறமும் புள்ளியும் வரியும் உள்ளவைகளாயிருக்கக் கண்டேன். ");
INSERT INTO tam2017_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","அன்றியும் தேவதூதன் ஒருவர் கனவில்: யாக்கோபே என்றார்; இதோ, இருக்கிறேன் என்றேன். ");
INSERT INTO tam2017_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","அப்பொழுது அவர்: உன் கண்களை ஏறெடுத்துப்பார்; ஆடுகளோடு இணையும் கடாக்களெல்லாம் கலப்புநிறமும் புள்ளியும் வரியுமுள்ளவைகளாக இருக்கிறது; லாபான் உனக்குச் செய்கிற அனைத்தையும் கண்டேன். ");
INSERT INTO tam2017_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","நீ தூணுக்கு அபிஷேகம் செய்து, எனக்கு ஒரு பொருத்தனையைச் செய்த பெத்தேலிலே உனக்குக் காட்சியளித்த தேவன் நானே; இப்பொழுது நீ எழுந்து, இந்த தேசத்தைவிட்டுப் புறப்பட்டு, உன் இனத்தார் இருக்கிற தேசத்திற்குத் திரும்பிப்போ என்று சொன்னார் என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","அதற்கு ராகேலும் லேயாளும்: “எங்கள் தகப்பனுடைய வீட்டிலே இனி எங்களுக்குப் பங்கும் சொத்தும் உண்டோ? ");
INSERT INTO tam2017_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","அவரால் நாங்கள் அந்நியராக கருதப்படவில்லையா? அவர் எங்களை விற்று, எங்களுடைய பணத்தையும் அபகரித்துக்கொண்டார். ");
INSERT INTO tam2017_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","ஆகையால் தேவன் எங்கள் தகப்பனிடத்திலிருந்து எடுத்த ஐசுவரியம் எல்லாம் நமக்கும் நம்முடைய பிள்ளைகளுக்கும் உரியது; இப்படியிருக்க, தேவன் உமக்குச் சொன்னபடியெல்லாம் செய்யும்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","அப்பொழுது யாக்கோபு எழுந்து, தன்னுடைய பிள்ளைகளையும், மனைவிகளையும் ஒட்டகங்கள்மேல் ஏற்றி, ");
INSERT INTO tam2017_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","பதான் அராமிலே தான் சம்பாதித்த மிருகஜீவன்களாகிய மந்தைகள் அனைத்தையும் தன் பொருட்கள் எல்லாவற்றையும் எடுத்துக்கொண்டு, கானான் தேசத்தில் இருக்கிற தன் தகப்பனாகிய ஈசாக்கிடம் போகப் புறப்பட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","லாபான், தன் ஆடுகளை மயிர்கத்தரிக்கப் போயிருந்தான்; அந்த சமயத்திலே ராகேல் தன் தகப்பனுடைய வீட்டிலிருந்த சிலைகளைத் திருடிக்கொண்டாள். ");
INSERT INTO tam2017_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","யாக்கோபு தான் ஓடிப்போகிறதை சீரியனாகிய லாபானுக்குத் தெரிவிக்காமல், திருட்டுத்தனமாகப் போய்விட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","இப்படியே அவன் தனக்கு உண்டானவைகளையெல்லாம் எடுத்துக்கொண்டு, ஆற்றைக் கடந்து, கீலேயாத் மலையை நோக்கி ஓடிப்போனான். ");
INSERT INTO tam2017_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","யாக்கோபு ஓடிப்போனது மூன்றாம் நாளிலே லாபானுக்கு தெரிவிக்கப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","அப்பொழுது அவன், தன் சகோதரர்களைக் கூட்டிக்கொண்டு, ஏழுநாட்கள் அவனைத் தொடர்ந்துபோய் பிரயாணம் செய்து, கீலேயாத் மலையிலே அவனைக் கண்டுபிடித்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","அன்று இரவு தேவன் சீரியா தேசத்தானாகிய லாபானுக்குக் கனவில் தோன்றி: “நீ யாக்கோபோடு நன்மையைத் தவிர தீமை ஒன்றும் பேசாதபடி எச்சரிக்கையாக இரு” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","லாபான் யாக்கோபினிடத்தில் வந்தான்; யாக்கோபு தன் கூடாரத்தை மலையிலே போட்டிருந்தான்; லாபானும் தன் சகோதரர்களோடுகூடக் கீலேயாத் மலையிலே கூடாரம் போட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","அப்பொழுது லாபான் யாக்கோபை நோக்கி: “நீ திருட்டுத்தனமாகப் புறப்பட்டு, என் மகள்களை யுத்தத்தில் பிடித்த கைதிகளைப்போலக் கொண்டுவந்தது என்ன செயல்? ");
INSERT INTO tam2017_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","நீ ஓடிப்போவதை எனக்குத் தெரிவிக்காமல், திருட்டுத்தனமாக என்னிடத்திலிருந்து வந்துவிட்டது என்ன? நான் உன்னை சந்தோஷமாக சங்கீதம், மேளதாளம், கின்னரமுழக்கத்துடனே அனுப்புவேனே. ");
INSERT INTO tam2017_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","என் பிள்ளைகளையும் என் மகள்களையும் நான் முத்தம் செய்யவிடாமல் போனதென்ன? இந்தச் செயலை நீ அறிவில்லாமல் செய்தாய். ");
INSERT INTO tam2017_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","உங்களுக்குப் பொல்லாப்புச்செய்ய எனக்கு வல்லமை உண்டு; ஆகிலும், உங்கள் தகப்பனுடைய தேவன்: நீ யாக்கோபோடு நன்மையைத் தவிர தீமை ஒன்றும் பேசாதபடி எச்சரிக்கையாக இரு என்று நேற்று இரவில் என்னோடு சொன்னார். ");
INSERT INTO tam2017_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","இப்பொழுதும் உன் தகப்பனுடைய வீட்டின்மேலுள்ள ஏக்கத்தால் நீ புறப்பட்டுப்போகிறதானால் போகலாம், என் தெய்வங்களை ஏன் திருடிக்கொண்டு போகிறாய்” என்று கேட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","யாக்கோபு லாபானுக்கு மறுமொழியாக: “உம்முடைய மகள்களைப் பலாத்காரமாகப் பிடித்து வைத்துக்கொள்வீர் என்று நான் பயப்பட்டதாலே இப்படி வந்துவிட்டேன். ");
INSERT INTO tam2017_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ஆனாலும் யாரிடத்தில் உம்முடைய தெய்வங்களைக் கண்டுபிடிக்கிறீரோ, அவனை உயிரோடு விடவேண்டாம்; உம்முடைய பொருட்கள் ஏதாவது என்னிடத்தில் இருக்குமானால் நீர் அதை நம்முடைய சகோதரர்களுக்கு முன்பாகத் தேடிப்பார்த்து, அதை எடுத்துக்கொள்ளும்” என்றான். ராகேல் அவைகளைத் திருடிக்கொண்டு வந்தது யாக்கோபுக்குத் தெரியாது. ");
INSERT INTO tam2017_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","அப்பொழுது லாபான் யாக்கோபின் கூடாரத்திலும், லேயாளின் கூடாரத்திலும், இரண்டு வேலைக்காரிகளின் கூடாரத்திலும் தேடிப் பார்த்தும் ஒன்றும் கண்டுபிடிக்கவில்லை; பின்பு, லேயாளின் கூடாரத்தைவிட்டு ராகேலின் கூடாரத்திற்குப் போனான். ");
INSERT INTO tam2017_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","ராகேல் அந்தச் சிலைகளை எடுத்து, ஒட்டகச் சேணத்தின்கீழ் வைத்து, அதின்மேல் உட்கார்ந்திருந்தாள். லாபான், கூடாரம் முழுவதிலும் தேடிப்பார்த்தும், அவைகளைக் கண்டுபிடிக்கவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","அவள் தன் தகப்பனை நோக்கி: “என் ஆண்டவனாகிய உமக்கு முன்பாக நான் எழுந்திருக்காததைக்குறித்துக் கோபப்பட வேண்டாம்; பெண்களுக்குரிய வழிபாடு எனக்கு உண்டாயிருக்கிறது” என்றாள்; அப்படியே அவன் அந்தச் சிலைகளைத் தேடியும் கண்டுபிடிக்க முடியவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","அப்பொழுது யாக்கோபுக்குக் கோபம் எழும்பி, லாபானோடு வாக்குவாதம்செய்து: “நீர் என்னை இவ்வளவு தீவிரமாகத் தொடர்ந்துவர நான் செய்த தவறு என்ன? நான் செய்த துரோகம் என்ன? ");
INSERT INTO tam2017_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","என் தட்டுமுட்டுகளையெல்லாம் தேடிப்பார்த்தீரே; உம்முடைய வீட்டுத் தட்டுமுட்டுகளில் என்னத்தைக் கண்டுபிடித்தீர்? அதை என்னுடைய சகோதரர்களுக்கும் உம்முடைய சகோதரர்களுக்கும் முன்பாக இங்கே வையும்; அவர்கள் எனக்கும் உமக்கும் நியாயம் தீர்க்கட்டும். ");
INSERT INTO tam2017_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","இந்த இருபது வருடகாலமாக நான் உம்மிடத்தில் இருந்தேன்; உம்முடைய செம்மறியாடுகளும் வெள்ளாடுகளும் சினை அழியவில்லை; உம்முடைய மந்தையின் கடாக்களை நான் சாப்பிடவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","காயப்பட்டதை நான் உம்மிடம் கொண்டுவராமல், அதற்காக நான் உத்திரவாதம்செய்தேன்; பகலில் திருடப்பட்டதையும், இரவில் திருடப்பட்டதையும் என் கையில் கேட்டு வாங்கினீர். ");
INSERT INTO tam2017_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","பகலிலே வெயிலும் இரவிலே குளிரும் என்னைத் தாக்கியது; தூக்கம் என் கண்களுக்குத் தூரமாயிருந்தது; இந்த விதமாகப் பாடுபட்டேன். ");
INSERT INTO tam2017_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","இந்த இருபது வருடகாலம் உம்முடைய வீட்டிலே இருந்தேன்; பதினான்கு வருடங்கள் உம்முடைய இரண்டு மகள்களுக்காகவும், ஆறு வருடங்கள் உம்முடைய மந்தைக்காகவும் உம்மிடத்தில் வேலைசெய்தேன்; பத்துமுறை என் சம்பளத்தை மாற்றினீர். ");
INSERT INTO tam2017_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","என் பிதாவின் தேவனாகிய ஆபிரகாமின் தேவனும் ஈசாக்கின் பயபக்திக்குரியவரும் என்னோடு இல்லாவிட்டால், நீர் இப்பொழுது என்னை வெறுமையாக அனுப்பிவிட்டிருப்பீர்; தேவன் என் சிறுமையையும் என் கடின உழைப்பையும் பார்த்து, நேற்று இரவு உம்மைக் கடிந்துகொண்டார்” என்று சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","அப்பொழுது லாபான் யாக்கோபுக்குப் மறுமொழியாக: “இந்த மகள்கள் என் மகள்கள், இந்தப் பிள்ளைகள் என் பிள்ளைகள், இந்த மந்தை என் மந்தை; நீ காண்கிற அனைத்தும் என்னுடையவைகள்; என் மகள்களாகிய இவர்களையும், இவர்கள் பெற்ற பிள்ளைகளையும் இன்று நான் என்ன செய்யமுடியும்? ");
INSERT INTO tam2017_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","இப்பொழுதும் எனக்கும் உனக்கும் சாட்சியாயிருப்பதற்காக, நீயும் நானும் உடன்படிக்கை செய்துகொள்ளலாம்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","அப்பொழுது யாக்கோபு ஒரு கல்லை எடுத்து, அதைத் தூணாக நிறுத்தினான். ");
INSERT INTO tam2017_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","பின்னும் யாக்கோபு தன் சகோதரர்களைப் பார்த்து, “கற்களைக் குவியலாகச் சேருங்கள்” என்றான்; அவர்கள் கற்களை எடுத்துக்கொண்டுவந்து, ஒரு குவியலாக்கி, அந்தக் குவியலின்மேல் உணவருந்தினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","லாபான் அதற்கு ஜெகர்சகதூதா என்று பெயரிட்டான்; யாக்கோபு அதற்குக் கலயெத் என்று பெயரிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","“இந்தக் குவியல் இன்று எனக்கும் உனக்கும் சாட்சி என்று லாபான் சொன்னதால், அதின் பெயர் கலயெத் எனப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","அல்லாமலும் அவன்: “நாம் ஒருவரை ஒருவர் விட்டுப்பிரிந்தபின், நீ என் மகள்களைத் துன்பப்படுத்தி, அவர்களையல்லாமல் வேறு பெண்களைத் திருமணம்செய்தால், யெகோவா எனக்கும் உனக்கும் நடுவில் நின்று கண்காணிப்பாராக; ");
INSERT INTO tam2017_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","நம்முடனே ஒருவரும் இல்லை; பார், தேவனே எனக்கும் உனக்கும் சாட்சி” என்று சொன்னதால், அது மிஸ்பா என்னும் பெயர்பெற்றது. ");
INSERT INTO tam2017_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","மேலும் லாபான் யாக்கோபை நோக்கி: “இதோ, இந்தக் குவியலையும் எனக்கும் உனக்கும் நடுவில் நான் நிறுத்தின தூணையும் பார். ");
INSERT INTO tam2017_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","தீங்குசெய்ய நான் இந்தக் குவியலைக் கடந்து உன்னிடத்திற்கு வராமலிருக்கவும், நீ இந்தக் குவியலையும் இந்தத் தூணையும் கடந்து என்னிடத்திற்கு வராமலிருக்கவும் இந்தக் குவியலும் சாட்சி, இந்தத் தூணும் சாட்சி. ");
INSERT INTO tam2017_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","ஆபிரகாமின் தேவனும் நாகோரின் தேவனும் அவர்கள் பிதாக்களின் தேவனுமாயிருக்கிறவர் நமக்கு நடுவில் நின்று நியாயந்தீர்ப்பாராக” என்றான். அப்பொழுது யாக்கோபு தன் தகப்பனாகிய ஈசாக்கின் பயபக்திக்குரியவர்மேல் ஆணையிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","பின்பு, யாக்கோபு மலையின்மேல் பலியிட்டு, ஆகாரம் சாப்பிடத் தன் சகோதரர்களை அழைத்தான்; அப்படியே அவர்கள் சாப்பிட்டு மலையிலே இரவில் தங்கினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","லாபான் அதிகாலையில் எழுந்திருந்து, தன் மகன்களையும் தன் மகள்களையும் முத்தம் செய்து, அவர்களை ஆசீர்வதித்தான். பின்பு லாபான் புறப்பட்டு, தன் இடத்திற்குத் திரும்பிப்போனான். ");
INSERT INTO tam2017_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","யாக்கோபு பயணம் செய்யும்போது, தேவதூதர்கள் அவனை சந்தித்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","யாக்கோபு அவர்களைக் கண்டபோது: “இது தேவனுடைய படை” என்று சொல்லி, அந்த இடத்திற்கு மகனாயீம் என்று பெயரிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","பின்பு, யாக்கோபு ஏதோமின் எல்லையாகிய சேயீர் தேசத்திலிருக்கிற தன் சகோதரனாகிய ஏசாவினிடம் போவதற்காக ஆட்களை வரவழைத்து: ");
INSERT INTO tam2017_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","“நீங்கள் என் ஆண்டவனாகிய ஏசாவினிடம் போய், நான் இதுவரை லாபானிடத்தில் தங்கியிருந்தேன் என்றும், ");
INSERT INTO tam2017_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","எனக்கு எருதுகளும், கழுதைகளும், ஆடுகளும், வேலைக்காரரும், வேலைக்காரிகளும் உண்டென்றும், உம்முடைய கண்களில் எனக்குத் தயவு கிடைக்கத்தக்கதாக ஆண்டவனாகிய உமக்கு இதை அறிவிக்கும்படி ஆட்களை அனுப்பினேன் என்றும் உம்முடைய தாசனாகிய யாக்கோபு சொல்லச்சொன்னான்” என்று சொல்லுவதற்குக் கட்டளைகொடுத்துத் தனக்கு முன்பாக அவர்களை அனுப்பினான். ");
INSERT INTO tam2017_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","அந்த ஆட்கள் யாக்கோபினிடத்திற்குத் திரும்பிவந்து: “நாங்கள் உம்முடைய சகோதரனாகிய ஏசாவினிடத்திற்குப் போய்வந்தோம்; அவரும் நானூறு பேரோடு உம்மை எதிர்கொள்ள வருகிறார் என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","அப்பொழுது யாக்கோபு மிகவும் பயந்து, கலக்கமடைந்து, தன்னிடத்திலிருந்த மக்களையும் ஆடுமாடுகளையும் ஒட்டகங்களையும் இரண்டு பகுதியாகப் பிரித்து: ");
INSERT INTO tam2017_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","ஏசா ஒரு பகுதியைத் தாக்கி அதை அழித்தாலும், மற்றப் பகுதி தப்பித்துக்கொள்ள முடியும் என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","பின்பு யாக்கோபு: “என் தகப்பனாகிய ஆபிரகாமின் தேவனும், என் தகப்பனாகிய ஈசாக்கின் தேவனுமாக இருக்கிறவரே: உன் தேசத்திற்கும் உன் இனத்தாரிடத்திற்கும் திரும்பிப்போ, உனக்கு நன்மை செய்வேன் என்று என்னுடன் சொல்லியிருக்கிற யெகோவாவே, ");
INSERT INTO tam2017_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","அடியேனுக்கு தேவரீர் காண்பித்த எல்லா தயவுக்கும் எல்லா உண்மைக்கும் நான் எவ்வளவேனும் தகுதியுள்ளவன் அல்ல, நான் கோலும் கையுமாக இந்த யோர்தானைக் கடந்துபோனேன்; இப்பொழுது இவ்விரண்டு பரிவாரங்களையும் உடையவனானேன். ");
INSERT INTO tam2017_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","என் சகோதரனாகிய ஏசாவின் கைக்கு என்னைத் தப்புவியும், அவன் வந்து என்னையும் பிள்ளைகளையும் தாய்மார்களையும் தாக்குவான் என்று அவனுக்கு நான் பயந்திருக்கிறேன். ");
INSERT INTO tam2017_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","தேவரீரோ: நான் உனக்கு மெய்யாகவே நன்மைசெய்து, உன் சந்ததியை எண்ணிமுடியாத கடற்கரை மணலைப்போல மிகவும் பெருகச் செய்வேன் என்று சொன்னீரே” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","அன்று இரவு அவன் அங்கே தங்கி, தன்னிடம் உள்ளவைகளில் தன் சகோதரனாகிய ஏசாவுக்கு வெகுமதியாக, ");
INSERT INTO tam2017_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","இருநூறு வெள்ளாடுகளையும், இருபது வெள்ளாட்டுக் கடாக்களையும், இருநூறு செம்மறியாடுகளையும், இருபது ஆட்டுக்கடாக்களையும், ");
INSERT INTO tam2017_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","பால் கொடுக்கிற முப்பது ஒட்டகங்களையும், அவைகளின் குட்டிகளையும், நாற்பது பசுக்களையும், பத்துக் காளைகளையும், இருபது பெண் கழுதைகளையும், பத்துக் கழுதைக்குட்டிகளையும் பிரித்தெடுத்து, ");
INSERT INTO tam2017_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","வேலைக்காரர்களிடம் ஒவ்வொரு மந்தையைத் தனித்தனியாக ஒப்படைத்து, நீங்கள் ஒவ்வொரு மந்தைக்கும் முன்னும் பின்னுமாக இடம்விட்டு எனக்கு முன்னாக ஓட்டிக்கொண்டுசெல்லுங்கள்” என்று தன் வேலைக்காரர்களுக்குச் சொல்லி, ");
INSERT INTO tam2017_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","முதலில் போகிறவனை நோக்கி: “என் சகோதரனாகிய ஏசா உனக்கு எதிர்ப்பட்டு: நீ யாருடையவன்? எங்கே போகிறாய்? உனக்குமுன் போகிற மந்தை யாருடையது? என்று உன்னைக் கேட்டால், ");
INSERT INTO tam2017_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","நீ: இது உமது அடியானாகிய யாக்கோபுடையது; இது என் ஆண்டவனாகிய ஏசாவுக்கு அனுப்பப்படுகிற வெகுமதி; இதோ, அவனும் எங்களுக்குப் பின்னே வருகிறான் என்று சொல்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","இரண்டாம் மூன்றாம் வேலைக்காரனையும், மந்தைகளின் பின்னாலே போகிற அனைவரையும் நோக்கி: நீங்களும் ஏசாவைக் காணும்போது, இந்தவிதமாகவே அவனிடம் சொல்லி, ");
INSERT INTO tam2017_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","“இதோ, உமது அடியானாகிய யாக்கோபு எங்களுக்குப் பின்னே வருகிறான் என்றும் சொல்லுங்கள் என்று கட்டளையிட்டான்; முன்னே வெகுமதியை அனுப்பி, அவனைச் சாந்தப்படுத்திவிட்டு, பின்பு அவனுடைய முகத்தைப் பார்ப்பேன், அப்பொழுது ஒருவேளை என்மீது தயவாயிருப்பான்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","அந்தப்படியே வெகுமதிகள் அவனுக்குமுன் போனது; அவனோ அன்று இரவில் முகாமிலே தங்கி, ");
INSERT INTO tam2017_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","இரவில் எழுந்திருந்து, தன்னுடைய இரண்டு மனைவிகளையும், இரண்டு மறுமனையாட்டிகளையும், பதினொரு மகன்களையும் கூட்டிக்கொண்டு, யாப்போக்கு என்ற ஆற்றை அதன் ஆழமில்லாத பகுதியில் கடந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","அவர்களையும், தனக்கு உண்டான அனைத்தையும் ஆற்றைக்கடக்க செய்து, அக்கரைப்படுத்தினான். ");
INSERT INTO tam2017_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","யாக்கோபு தன்னைத் தனிமைப்படுத்திக்கொண்டான்; அப்பொழுது ஒரு மனிதன் பொழுது விடியும்வரை அவனுடன் போராடி, ");
INSERT INTO tam2017_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","அவனை மேற்கொள்ள முடியாததைக்கண்டு, அவனுடைய தொடைச்சந்தைத் தொட்டார்; அதனால் அவருடன் போராடும்போது யாக்கோபின் தொடைச்சந்து சுளுக்கிற்று. ");
INSERT INTO tam2017_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","அவர்: “என்னைப் போகவிடு, பொழுது விடிகிறது என்றார். அதற்கு அவன்: “நீர் என்னை ஆசீர்வதித்தாலொழிய உம்மைப் போகவிடமாட்டேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","அவர்: “உன் பெயர் என்ன” என்று கேட்டார்; “யாக்கோபு” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","அப்பொழுது அவர்: “உன் பெயர் இனி யாக்கோபு எனப்படாமல் இஸ்ரவேல் எனப்படும்; தேவனோடும் மனிதர்களோடும் போராடி மேற்கொண்டாயே” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","அப்பொழுது யாக்கோபு: “உம்முடைய நாமத்தை எனக்கு தெரிவிக்கவேண்டும் என்று கேட்டான்; அதற்கு அவர்: “நீ என் நாமத்தைக் கேட்பதென்ன” என்று சொல்லி, அங்கே அவனை ஆசீர்வதித்தார். ");
INSERT INTO tam2017_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","அப்பொழுது யாக்கோபு: “நான் தேவனை முகமுகமாகக் கண்டேன், உயிர் தப்பிப் பிழைத்தேன்” என்று சொல்லி, அந்த இடத்திற்குப் பெனியேல் என்று பெயரிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","அவன் பெனியேலைக் கடந்துபோகும்போது, சூரியன் உதயமானது; அவனுடைய தொடை சுளுக்கியதாலே நொண்டி நொண்டி நடந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","அவர் யாக்கோபுடைய தொடைச்சந்து நரம்பைத் தொட்டதால், இஸ்ரவேல் வம்சத்தார் இந்த நாள்வரைக்கும் தொடைச்சந்து நரம்பைச் சாப்பிடுகிறதில்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","யாக்கோபு தன் கண்களை ஏறெடுத்து, இதோ, ஏசாவும் அவனோடுகூட நானூறு மனிதர்களும் வருகிறதைக் கண்டு, பிள்ளைகளை லேயாளிடத்திலும் ராகேலிடத்திலும் இரண்டு மறுமனையாட்டிகளிடத்திலும் தனிக்குழுக்களாகப் பிரித்துவைத்து, ");
INSERT INTO tam2017_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","மறுமனையாட்டிகளையும் அவர்களுடைய பிள்ளைகளையும் முதலிலும், லேயாளையும் அவளுடைய பிள்ளைகளையும் மத்தியிலும், ராகேலையும் யோசேப்பையும் கடைசியிலும் நிறுத்தி: ");
INSERT INTO tam2017_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","தான் அவர்களுக்கு முன்பாக நடந்து போய், ஏழுமுறை தரைவரைக்கும் குனிந்து வணங்கி, தன் சகோதரன் அருகில் போனான். ");
INSERT INTO tam2017_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","அப்பொழுது ஏசா எதிர்கொண்டு ஓடிவந்து, அவனைத் தழுவி, அவனுடைய கழுத்தைக் கட்டிக்கொண்டு முத்தம்செய்தான்; இருவரும் அழுதார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","அவன் தன் கண்களை ஏறெடுத்து, பெண்களையும் பிள்ளைகளையும் கண்டு: “உன்னோடிருக்கிற இவர்கள் யார்?” என்றான். அதற்கு அவன்: “தேவன் உமது அடியானுக்கு அருளின பிள்ளைகள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","அப்பொழுது மறுமனையாட்டிகளும் அவர்களுடைய பிள்ளைகளும் சேர்ந்துவந்து வணங்கினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","லேயாளும் அவளுடைய பிள்ளைகளும் சேர்ந்துவந்து வணங்கினார்கள்; பின்பு யோசேப்பும் ராகேலும் சேர்ந்துவந்து வணங்கினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","அப்பொழுது ஏசா: “எனக்கு எதிர்கொண்டுவந்த அந்த மந்தையெல்லாம் எதற்கு என்றான். அதற்கு யாக்கோபு: “என் ஆண்டவனுடைய கண்களில் எனக்கு தயவு கிடைப்பதற்காக” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","அதற்கு ஏசா: “என் சகோதரனே, எனக்குப் போதுமானது இருக்கிறது; உன்னுடையதை நீயே வைத்துக்கொள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","அதற்கு யாக்கோபு: “அப்படி அல்ல, உம்முடைய கண்களில் எனக்குத் தயவு கிடைத்ததேயானால், என் வெகுமதியை ஏற்றுக்கொள்ளும்; நீர் என்மேல் பிரியமானீர், நான் உம்முடைய முகத்தைக் கண்டது தேவனுடைய முகத்தைக் கண்டதுபோல இருக்கிறது. ");
INSERT INTO tam2017_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","தேவன் எனக்கு அநுக்கிரகம் செய்திருக்கிறார்; வேண்டியதெல்லாம் எனக்கு உண்டு; ஆகையால் உமக்குக் கொண்டுவரப்பட்ட என் காணிக்கையை ஏற்றுக்கொள்ளும்” என்று சொல்லி, அவனை வருந்திக் கேட்டுக்கொண்டான்; அப்பொழுது அவன் அதை ஏற்றுக்கொண்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","பின்பு ஏசா: “நாம் புறப்பட்டுப்போவோம் வா, நான் உனக்கு முன்னே நடப்பேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","அதற்கு யாக்கோபு: “பிள்ளைகள் இளவயதுள்ளவர்கள் என்றும், பால்கொடுக்கும் ஆடுமாடுகள் என்னிடத்தில் இருக்கிறது என்றும் என் ஆண்டவனுக்குத் தெரியும்; அவைகளை ஒரு நாளாவது வேகமாக ஓட்டினால், மந்தையெல்லாம் இறந்துபோகும். ");
INSERT INTO tam2017_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","என் ஆண்டவனாகிய நீர் உமது அடியானுக்கு முன்னே போம்; நான் சேயீருக்கு என் ஆண்டவனிடத்திற்கு வரும்வரைக்கும், எனக்குமுன் நடக்கிற மந்தைகளின் நடைக்கும் பிள்ளைகளின் நடைக்கும் ஏற்றபடி, மெதுவாக அவைகளை நடத்திக்கொண்டு வருகிறேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","அப்பொழுது ஏசா: “என்னிடத்திலிருக்கிற மனிதர்களில் சிலரை நான் உன்னிடத்தில் நிறுத்திவிட்டுப் போகட்டுமா என்றான். அதற்கு அவன்: “அது எதற்கு, என் ஆண்டவனுடைய கண்களில் எனக்கு தயவுகிடைத்தால் மாத்திரம் போதும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","அன்றைத்தினம் ஏசா திரும்பித் தான் வந்த வழியே சேயீருக்குப்போனான். ");
INSERT INTO tam2017_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","யாக்கோபு சுக்கோத்திற்குப் பயணம்செய்து, தனக்கு ஒரு வீடு கட்டி, தன் மிருகஜீவன்களுக்குக் கூடாரங்களைப் போட்டான்; அதனால் அந்த இடத்திற்கு சுக்கோத் என்று பெயரிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","யாக்கோபு பதான் அராமிலிருந்து வந்தபின் கானான்தேசத்திலிருக்கிற சாலேம் என்னும் சீகேமுடைய பட்டணத்திற்கு அருகே சென்று கூடாரம்போட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","தான் கூடாரம்போட்ட நிலத்தைச் சீகேமின் தகப்பனாகிய ஏமோரின் மகன்களிடம் 100 வெள்ளிக்காசுக்கு வாங்கி, ");
INSERT INTO tam2017_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","அங்கே ஒரு பலிபீடத்தைக் கட்டி, அதற்கு ஏல்எல்லோகே இஸ்ரவேல் என்று பெயரிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","லேயாள் யாக்கோபுக்குப் பெற்ற மகளாகிய தீனாள், தேசத்துப் பெண்களைப் பார்க்கப் புறப்பட்டாள். ");
INSERT INTO tam2017_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","அவளை ஏவியனான ஏமோரின் மகனும் அந்த தேசத்தின் இளவரசனுமாகிய சீகேம் என்பவன் கண்டு, அவளைக் கொண்டுபோய், அவளோடு உறவுகொண்டு, அவளைத் தீட்டுப்படுத்தினான். ");
INSERT INTO tam2017_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","அவனுடைய மனம், யாக்கோபின் மகளாகிய தீனாள்மேல் பற்றுதலாயிருந்தது; அவன் அந்தப் பெண்ணை நேசித்து, அவளுடைய மனதிற்கு இன்பமாகப் பேசினான். ");
INSERT INTO tam2017_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","சீகேம் தன் தகப்பனாகிய ஏமோரை நோக்கி: “இந்தப் பெண்ணை எனக்குத் திருமணம் செய்துவைக்கவேண்டும்” என்று சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","தன் மகளாகிய தீனாளை அவன் தீட்டுப்படுத்தினதை யாக்கோபு கேள்விப்பட்டபோது, அவனுடைய மகன்கள் அவனுடைய மந்தையினிடத்தில் வயல்வெளியிலே இருந்தார்கள்; அவர்கள் வரும்வரைக்கும் யாக்கோபு பேசாமலிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","அந்தநேரத்தில் சீகேமின் தகப்பனாகிய ஏமோர் புறப்பட்டு, யாக்கோபோடு பேசும்படி அவனிடத்திற்கு வந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","யாக்கோபின் மகன்கள் இந்தச் செய்தியைக் கேட்டவுடனே, வயல்வெளியிலிருந்து வந்தார்கள். அவன் யாக்கோபின் மகளோடு உறவுகொண்டு, செய்யத்தகாத புத்திகெட்ட காரியத்தை இஸ்ரவேலில் செய்ததினாலே, அந்த மனிதர்கள் மனம்கொதித்து மிகவும் கோபங்கொண்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","ஏமோர் அவர்களோடு பேசி: “என் மகனாகிய சீகேமின் மனது உங்கள் மகளின்மேல் பற்றுதலாயிருக்கிறது; அவளை அவனுக்கு மனைவியாகக் கொடுங்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","நீங்கள் எங்களோடு சம்பந்தங்கலந்து, உங்கள் மகள்களை எங்களுக்குக் கொடுத்து, எங்கள் மகள்களை உங்களுக்குக் கொண்டு, ");
INSERT INTO tam2017_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","எங்களோடு குடியிருங்கள்; தேசம் உங்களுக்கு முன்பாக இருக்கிறது; இதில் குடியிருந்து, வியாபாரம்செய்து, பொருள் சம்பாதித்து, அதைக் கையாண்டுகொண்டிருங்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","சீகேமும், அவளுடைய தகப்பனையும், சகோதரர்களையும் நோக்கி: “உங்களுடைய கண்களில் எனக்கு தயவு கிடைக்கவேண்டும்; நீங்கள் என்னிடத்தில் எதைக் கேட்டாலும் தருகிறேன்; ");
INSERT INTO tam2017_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","பெண்ணுக்குக் கொடுக்கவேண்டியவைகளையும் வெகுமதிகளையும் நீங்கள் எவ்வளவு கேட்டாலும், உங்கள் சொற்படி தருகிறேன்; அந்தப் பெண்ணை மாத்திரம் எனக்கு மனைவியாகக் கொடுக்கவேண்டும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","அப்பொழுது யாக்கோபின் மகன்கள் தங்கள் சகோதரியாகிய தீனாளை சீகேம் என்பவன் தீட்டுப்படுத்தினதால், அவனுக்கும் அவனுடைய தகப்பனாகிய ஏமோருக்கும் தந்திரமான மறுமொழியாக: ");
INSERT INTO tam2017_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“விருத்தசேதனமில்லாத மனிதனுக்கு நாங்கள் எங்களுடைய சகோதரியைக் கொடுக்கமுடியாது; அது எங்களுக்கு அவமானமாயிருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","நீங்களும், உங்களுக்குள்ளிருக்கும் ஆண்மக்கள் அனைவரும் விருத்தசேதனம் செய்யப்பட்டு எங்களைப்போல் ஆவீர்களானால், நாங்கள் சம்மதித்து, ");
INSERT INTO tam2017_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","உங்களுக்கு எங்கள் மகள்களைக் கொடுத்து, உங்கள் மகள்களை எங்களுக்குக் கொண்டு, உங்களோடு குடியிருந்து, ஒரே ஜனமாக இருப்போம். ");
INSERT INTO tam2017_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","விருத்தசேதனம் செய்துகொள்வதற்கு சம்மதிக்கவில்லை என்றால், நாங்கள் எங்களுடைய மகளை அழைத்துக்கொண்டு போய்விடுவோம்” என்று சொன்னார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","அவர்களுடைய வார்த்தைகள் ஏமோருக்கும் ஏமோரின் மகனாகிய சீகேமுக்கும் நன்றாகத் தோன்றியது. ");
INSERT INTO tam2017_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","அந்த வாலிபன் யாக்கோபுடைய மகளின்மேல் பிரியம் வைத்திருந்ததால், அந்தக் காரியத்தைச் செய்ய அவன் தாமதம்செய்யவில்லை. அவன் தன் தகப்பன் வீட்டார் அனைவருக்குள்ளும் மேன்மையுள்ளவனாக இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ஏமோரும் அவனுடைய மகன் சீகேமும் தங்கள் பட்டணத்து வாசலில் வந்து, தங்கள் பட்டணத்து மனிதர்களுடன் பேசி: ");
INSERT INTO tam2017_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“இந்த மனிதர் நம்முடன் சமாதானமாயிருக்கிறார்கள்; ஆகவே, அவர்கள் இந்தத் தேசத்தில் குடியிருந்து, இதிலே வியாபாரம் செய்யட்டும்; அவர்களும் குடியிருக்கிறதற்கு தேசம் விசாலமாக இருக்கிறது; அவர்களுடைய மகள்களை நமக்கு மனைவிகளாகக் கொண்டு, நம்முடைய மகள்களை அவர்களுக்குக் கொடுப்போம். ");
INSERT INTO tam2017_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","அந்த மனிதர் விருத்தசேதனம் செய்யப்பட்டவர்களாயிருக்கிறது போல, நம்மிலுள்ள ஆண்மக்கள் அனைவரும் விருத்தசேதனம் செய்யப்பட்டால், அவர்கள் ஏகஜனமாக நம்மோடு குடியிருக்கச் சம்மதிப்பார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","அவர்களுடைய ஆடுமாடுகள், சொத்துக்கள், மிருகஜீவன்கள் எல்லாம் நம்மைச் சேருமல்லவா? அவர்களுக்குச் சம்மதிப்போமானால், அவர்கள் நம்முடனே குடியிருப்பார்கள்” என்று சொன்னார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","அப்பொழுது ஏமோரின் பட்டணத்து வாசலில் புறப்பட்டுவரும் அனைவரும் அவனுடைய சொல்லையும், அவனுடைய மகனாகிய சீகேமின் சொல்லையும் கேட்டு, அவனுடைய பட்டணத்து வாசலில் புறப்பட்டுவரும் ஆண்மக்கள் அனைவரும் விருத்தசேதனம் செய்யப்பட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","மூன்றாம் நாளில் அவர்களுக்கு வலி அதிகமானபோது, யாக்கோபின் மகன்களும் தீனாளின் சகோதரர்களுமான சிமியோன் லேவி என்னும் இவ்விரண்டுபேரும் தன்தன் பட்டயத்தை எடுத்துக்கொண்டு, துணிகரமாகப் பட்டணத்தின்மேல் பாய்ந்து, ஆண்மக்கள் அனைவரையும் கொன்றுபோட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ஏமோரையும், அவனுடைய மகன் சீகேமையும் பட்டயத்தால் கொன்று, சீகேமின் வீட்டிலிருந்த தீனாளை அழைத்துக்கொண்டு போய்விட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","மேலும், யாக்கோபின் மற்ற மகன்கள் வெட்டப்பட்டவர்களிடத்தில் வந்து, தங்கள் சகோதரியை அவர்கள் தீட்டுப்படுத்தினதற்காகப் பட்டணத்தைக் கொள்ளையிட்டு, ");
INSERT INTO tam2017_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","அவர்களுடைய ஆடுமாடுகளையும், கழுதைகளையும், பட்டணத்திலும் வயல்வெளியிலும் இருந்தவைகள் அனைத்தையும், ");
INSERT INTO tam2017_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","அவர்களுடைய எல்லாத் தட்டுமுட்டுகளையும் எடுத்துக்கொண்டு, அவர்களுடைய எல்லாக் குழந்தைகளையும் பெண்களையும் சிறைபிடித்து, வீட்டிலிருந்த எல்லாவற்றையும் கொள்ளையிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","அப்பொழுது யாக்கோபு சிமியோனையும் லேவியையும் பார்த்து: “இந்த தேசத்தில் குடியிருக்கிற கானானியரிடத்திலும் பெரிசியரிடத்திலும் என் வாசனையை நீங்கள் கெடுத்ததினாலே என்னைக் கலங்கச்செய்தீர்கள்; நான் கொஞ்ச ஜனமுள்ளவன்; அவர்கள் எனக்கு விரோதமாக ஒன்றுசேர்ந்து, நானும் என் குடும்பமும் அழியும்படி என்னை வெட்டிப்போடுவார்களே” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","அதற்கு அவர்கள்: “எங்கள் சகோதரியை அவர்கள் ஒரு வேசியைப்போல நடத்தலாமோ” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","தேவன் யாக்கோபை நோக்கி: “நீ எழுந்து பெத்தேலுக்குப் போய், அங்கே குடியிருந்து, நீ உன் சகோதரனாகிய ஏசாவின் முகத்திற்கு விலகி ஓடிப்போகிறபோது, உனக்குக் காட்சியளித்த தேவனுக்கு அங்கே ஒரு பலிபீடத்தை உண்டாக்கு” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","அப்பொழுது யாக்கோபு தன் வீட்டாரையும் அவனுடன் இருந்த மற்ற அனைவரையும் நோக்கி: “உங்களிடத்தில் இருக்கிற அந்நிய தெய்வங்களை விலக்கிப்போட்டு, உங்களைச் சுத்தம்செய்துகொண்டு, உங்கள் ஆடைகளை மாற்றுங்கள்”. ");
INSERT INTO tam2017_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","நாம் எழுந்து பெத்தேலுக்குப் போவோம் வாருங்கள்; எனக்கு ஆபத்து நேரிட்ட நாளில் என் விண்ணப்பத்திற்கு பதில் கொடுத்து, நான் நடந்த வழியிலே என்னுடன் இருந்த தேவனுக்கு அங்கே ஒரு பலிபீடத்தை உண்டாக்குவேன் என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","அப்பொழுது அவர்கள் தங்கள் கையில் இருந்த எல்லா அந்நிய தெய்வங்களையும், தங்கள் காதணிகளையும் யாக்கோபிடத்தில் கொடுத்தார்கள்; யாக்கோபு அவைகளை சீகேம் ஊர் அருகே இருந்த ஒரு கர்வாலி மரத்தின்கீழே புதைத்துப்போட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","பின்பு பயணம் புறப்பட்டார்கள்; அவர்களைச் சுற்றிலும் இருந்த பட்டணத்தார்களுக்கு தேவனாலே பயங்கரம் உண்டானதால், அவர்கள் யாக்கோபின் மகன்களைப் பின்தொடரவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","யாக்கோபும் அவனுடன் இருந்த எல்லா மக்களும் கானான் தேசத்திலுள்ள பெத்தேல் என்னும் லூஸுக்கு வந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","அங்கே அவன் ஒரு பலிபீடத்தைக்கட்டி, தன் சகோதரனுடைய முகத்திற்குத் தப்பி ஓடிப்போனபோது, அங்கே தனக்கு தேவன் காட்சியளித்ததால், அந்த இடத்திற்கு ஏல்பெத்தேல் என்று பெயரிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","ரெபெக்காளின் தாதியாகிய தெபொராள் இறந்து, பெத்தேலுக்குச் சமீபமாயிருந்த ஒரு கர்வாலி மரத்தின்கீழ் அடக்கம் செய்யப்பட்டாள்; அதற்கு அல்லோன்பாகூத் என்னும் பெயர் உண்டானது. ");
INSERT INTO tam2017_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","யாக்கோபு பதான் அராமிலிருந்து வந்தபின்பு தேவன் அவனுக்கு மறுபடியும் காட்சியளித்து, அவனை ஆசீர்வதித்து: ");
INSERT INTO tam2017_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","“இப்பொழுது உன் பெயர் யாக்கோபு, இனி உன் பெயர் யாக்கோபு எனப்படாமல், இஸ்ரவேல் என்று உனக்குப் பெயராகும் என்று சொல்லி, அவனுக்கு இஸ்ரவேல்” என்று பெயரிட்டார். ");
INSERT INTO tam2017_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","பின்னும் தேவன் அவனை நோக்கி: “நான் சர்வவல்லமையுள்ள தேவன், நீ பலுகிப் பெருகுவாயாக; ஒரு தேசமும் பற்பல தேசங்களின் மக்களும் உன்னிலிருந்து உண்டாகும்; ராஜாக்களும் உன் சந்ததியில் பிறப்பார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","நான் ஆபிரகாமுக்கும் ஈசாக்குக்கும் கொடுத்த தேசத்தை உனக்குக் கொடுப்பேன்; உனக்குப்பின் உன் சந்ததிக்கும் இந்த தேசத்தைக் கொடுப்பேன்” என்று சொல்லி, ");
INSERT INTO tam2017_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","தேவன் அவனோடு பேசின இடத்திலிருந்து அவனைவிட்டு எழுந்தருளிப்போனார். ");
INSERT INTO tam2017_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","அப்பொழுது யாக்கோபு தன்னோடு அவர் பேசின இடத்திலே ஒரு கல்தூணை நிறுத்தி, அதின்மேல் பானபலியை ஊற்றி, எண்ணையையும் ஊற்றினான். ");
INSERT INTO tam2017_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","தேவன் தன்னோடு பேசின அந்த இடத்திற்கு யாக்கோபு பெத்தேல் என்று பெயரிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","பின்பு, பெத்தேலை விட்டுப் பயணம் புறப்பட்டார்கள். எப்பிராத்தாவுக்கு வர இன்னும் கொஞ்சம் தூரமிருக்கும்போது, ராகேல் பிள்ளைபெற்றாள்; பிரசவத்தில் அவளுக்குக் கடும்வேதனை உண்டானது. ");
INSERT INTO tam2017_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","அப்போது மருத்துவச்சி அவளைப் பார்த்து: “பயப்படாதே, இந்த முறையும் மகனைப் பெறுவாய்” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","மரணகாலத்தில் அவளுடைய உயிர் பிரியும்போது, அவள் அவனுக்கு பெனொனி என்று பெயரிட்டாள்; அவனுடைய தகப்பனோ, அவனுக்கு பென்யமீன் என்று பெயரிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ராகேல் இறந்து, பெத்லகேம் என்னும் எப்பிராத்தா ஊருக்குப் போகிற வழியிலே அடக்கம் செய்யப்பட்டாள். ");
INSERT INTO tam2017_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","அவளுடைய கல்லறையின்மேல் யாக்கோபு ஒரு தூணை நிறுத்தினான்; அதுவே இந்த நாள்வரைக்கும் இருக்கிற ராகேலுடைய கல்லறையின் தூண். ");
INSERT INTO tam2017_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","இஸ்ரவேல் பயணம்செய்து, ஏதேர் என்கிற கோபுரத்திற்கு அப்புறத்தில் கூடாரம் போட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","இஸ்ரவேல் அந்தத் தேசத்தில் தங்கிக் குடியிருக்கும்போது, ரூபன் போய், தன் தகப்பனுடைய மறுமனையாட்டியாகிய பில்காளோடு உறவுகொண்டான்; அதை இஸ்ரவேல் கேள்விப்பட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","யாக்கோபின் மகன்கள் பன்னிரண்டுபேர். யாக்கோபின் மூத்தமகனாகிய ரூபன், சிமியோன், லேவி, யூதா, இசக்கார், செபுலோன் என்பவர்கள் லேயாள் பெற்ற மகன்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","யோசேப்பு, பென்யமீன் என்பவர்கள் ராகேல் பெற்ற மகன்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","தாண், நப்தலி என்பவர்கள் ராகேலுடைய பணிவிடைக்காரியாகிய பில்காள் பெற்ற மகன்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","காத், ஆசேர் என்பவர்கள் லேயாளின் பணிவிடைக்காரியாகிய சில்பாள் பெற்ற மகன்கள்; இவர்களே யாக்கோபுக்குப் பதான் அராமிலே பிறந்த மகன்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","பின்பு, யாக்கோபு அர்பாவின் ஊராகிய மம்ரேக்கு தன் தகப்பனாகிய ஈசாக்கினிடத்தில் வந்தான்; அது ஆபிரகாமும் ஈசாக்கும் தங்கியிருந்த எபிரோன் என்னும் ஊர். ");
INSERT INTO tam2017_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ஈசாக்கு வயது முதிர்ந்தவனும் பூரண ஆயுசுமுள்ளவனாகி, 180 வருடங்கள் உயிரோடிருந்து, ");
INSERT INTO tam2017_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","உயிர்பிரிந்து இறந்து, தன் ஜனத்தாரோடு சேர்க்கப்பட்டான். அவனுடைய மகன்களாகிய ஏசாவும் யாக்கோபும் அவனை அடக்கம்செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","ஏதோமியரின் தகப்பனாகிய ஏசாவின் வம்சவரலாறு: ");
INSERT INTO tam2017_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","ஏசா கானான் தேசத்துப் பெண்களில் ஏத்தியனான ஏலோனின் மகளாகிய ஆதாளையும், ஏவியனாகிய சிபியோனின் மகளும் ஆனாகின் மகளுமாகிய அகோலிபாமாளையும், ");
INSERT INTO tam2017_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","இஸ்மவேலின் மகளும் நெபாயோத்தின் சகோதரியுமாகிய பஸ்மாத்தையும் திருமணம் செய்திருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","ஆதாள் ஏசாவுக்கு எலிப்பாசைப் பெற்றெடுத்தாள்; பஸ்மாத்து ரெகுவேலைப் பெற்றெடுத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","அகோலிபாமாள் எயூஷையும், யாலாமையும், கோராகையும் பெற்றெடுத்தாள்; இவர்களே ஏசாவுக்குக் கானான் தேசத்திலே பிறந்த மகன்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ஏசா தன்னுடைய மனைவிகளையும், மகன்களையும், மகள்களையும், வீட்டிலுள்ள அனைவரையும், ஆடுமாடுகளையும், மற்ற உயிரினங்கள் அனைத்தையும், தான் கானான் தேசத்திலே சம்பாதித்த சொத்து முழுவதையும் சேர்த்துக்கொண்டு, தன் சகோதரனாகிய யாக்கோபைவிட்டுப் பிரிந்து வேறு தேசத்திற்குப் போனான். ");
INSERT INTO tam2017_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","அவர்களுடைய சம்பத்து அதிகமாக இருந்ததால் அவர்கள் ஒன்றாக இணைந்து குடியிருக்க முடியாமற்போனது; அவர்களுடைய மந்தைகளின் காரணமாக அவர்கள் தங்கியிருந்த பூமி அவர்களைத் தாங்க முடியாததாயிருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","ஆதலால் ஏசா சேயீர்மலையில் குடியேறினான்; ஏசாவுக்கு ஏதோம் என்றும் பெயர். ");
INSERT INTO tam2017_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","சேயீர்மலையில் இருக்கிற ஏதோமியர்களுடைய தகப்பனாகிய ஏசாவின் சந்ததிகளும், ");
INSERT INTO tam2017_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ஏசாவின் மகன்களுடைய பெயர்களாவன: ஏசாவின் மனைவியாகிய ஆதாளுடைய மகனுக்கு எலிப்பாஸ் என்று பெயர்; ஏசாவின் மனைவியாகிய பஸ்மாத்துடைய மகனுக்கு ரெகுவேல் என்று பெயர். ");
INSERT INTO tam2017_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","எலிப்பாசின் மகன்கள் தேமான், ஓமார், செப்போ, கத்தாம், கேனாஸ் என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","திம்னாள் ஏசாவின் மகனாகிய எலிப்பாசுக்கு மறுமனையாட்டியாயிருந்து, எலீப்பாசுக்கு அமலேக்கைப் பெற்றெடுத்தாள்; இவர்களே ஏசாவின் மனைவியாகிய ஆதாளுடைய மகன்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","ரெகுவேலுடைய மகன்கள், நகாத், செராகு, சம்மா, மீசா என்பவர்கள்; இவர்களே ஏசாவின் மனைவியாகிய பஸ்மாத்தின் மகன்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","சிபியோனின் மகளும் ஆனாகின் மகளுமான அகோலிபாமாள் என்கிற ஏசாவின் மனைவி எயூஷ், யாலாம், கோராகு என்னும் மகன்களையும் ஏசாவுக்குப் பெற்றெடுத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ஏசாவின் மகன்களில் தோன்றிய பிரபுக்களாவன: ஏசாவுக்கு மூத்த மகனாகிய எலிப்பாசுடைய மகன்களில் தேமான் பிரபு, ஓமார் பிரபு, செப்போ பிரபு, கேனாஸ் பிரபு, ");
INSERT INTO tam2017_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","கோராகு பிரபு, கத்தாம் பிரபு, அமலேக்கு பிரபு என்பவர்கள்; இவர்கள் ஏதோம் தேசத்தில் எலிப்பாசின் சந்ததியும் ஆதாளின் மகன்களுமாயிருந்த பிரபுக்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","ஏசாவின் மகனாகிய ரெகுவேலின் மகன்களில் நகாத் பிரபு, செராகு பிரபு, சம்மா பிரபு, மீசா பிரபு என்பவர்கள்; இவர்கள் ஏதோம் தேசத்தில் ரெகுவேலின் சந்ததியும் ஏசாவின் மனைவியாகிய பஸ்மாத்தின் மகன்களுமாயிருந்த பிரபுக்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","ஏசாவின் மனைவியாகிய அகோலிபாமாளின் மகன்கள் எயூஷ் பிரபு, யாலாம் பிரபு, கோராகு பிரபு என்பவர்கள்; இவர்கள் ஆனாகின் மகளும் ஏசாவுடைய மனைவியுமாகிய அகோலிபாமாளின் சந்ததியாயிருந்த பிரபுக்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","இவர்களே ஏதோம் என்னும் ஏசாவின் சந்ததி; இவர்களே அவர்களிலிருந்த பிரபுக்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","அந்த தேசத்தின் குடிகளாகிய ஓரியனான சேயீரின் மகன்கள் லோத்தான், சோபால், சிபியோன், ஆனாகு, ");
INSERT INTO tam2017_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","திஷோன், ஏத்சேர், திஷான் என்பவர்கள்; இவர்களே ஏதோம் தேசத்தில் சேயீரின் மகன்களுமாகிய ஓரியர்களுடைய சந்ததியாயிருந்த பிரபுக்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","லோத்தானுடைய மகன்கள் ஓரி, ஏமாம் என்பவர்கள்; லோத்தானின் சகோதரி திம்னாள் என்பவள். ");
INSERT INTO tam2017_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","சோபாலின் மகன்கள் அல்வான், மானகாத், ஏபால், செப்போ, ஓனாம் என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","சிபியோனின் மகன்கள் அயா, ஆனாகு என்பவர்கள்; வனாந்திரத்திலே தன் தகப்பனாகிய சீபெயோனின் கழுதைகளை மேய்க்கும்போது, சூடான தண்ணிரைக் கண்டுபிடித்த ஆனாகு இவன்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","ஆனாகின் பிள்ளைகள் திஷோன், அகோலிபாமாள் என்பவர்கள்; இந்த அகோலிபாமாள் ஆனாகின் மகள். ");
INSERT INTO tam2017_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","திஷோனுடைய மகன்கள் எம்தான், எஸ்பான், இத்தரான், கெரான் என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","ஏத்சேருடைய மகன்கள் பில்கான், சகவான், அக்கான் என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","திஷானுடைய மகன்கள் ஊத்ஸ், அரான் என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","ஓரியரின் சந்ததியில் தோன்றிய பிரபுக்கள் லோத்தான் பிரபு, சோபால் பிரபு, சிபியோன் பிரபு, ஆனாகு பிரபு, ");
INSERT INTO tam2017_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","திஷோன் பிரபு, ஏத்சேர் பிரபு, திஷான் பிரபு என்பவர்கள்; இவர்களே சேயீர் தேசத்திலே தங்கள் தங்கள் இடங்களில் இருந்த ஓரியர் சந்ததியான பிரபுக்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","இஸ்ரவேல் வம்சத்தார்மேல் ராஜாக்கள் அரசாளுகிறதற்கு முன்னே, ஏதோம் தேசத்திலே ஆண்ட ராஜாக்களாவன: ");
INSERT INTO tam2017_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","பேயோருடைய மகனாகிய பேலா ஏதோமிலே ஆட்சிசெய்தான்; அவனுடைய பட்டணத்திற்குத் தின்காபா என்று பெயர். ");
INSERT INTO tam2017_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","பேலா இறந்தபின், போஸ்றா பட்டணத்தானாகிய சேராகுடைய மகனாகிய யோபாப் அவனுடைய பட்டத்திற்கு வந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","யோபாப் இறந்தபின், தேமானிய தேசத்தானாகிய ஊஷாம் அவனுடைய பட்டத்திற்கு வந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","ஊஷாம் இறந்தபின், மோவாபின் நாட்டிலே மீதியானியர்களை முறியடித்த பேதாதின் மகனாகிய ஆதாத் அவனுடைய பட்டத்திற்கு வந்தான்; அவனுடைய பட்டணத்திற்கு ஆவீத் என்று பெயர். ");
INSERT INTO tam2017_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ஆதாத் இறந்தபின், மஸ்ரேக்கா ஊரானாகிய சம்லா அவனுடைய பட்டத்திற்கு வந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","சம்லா இறந்தபின், அங்கே இருக்கிற நதிக்குச் சமீபமான ரெகொபோத் என்னும் ஊரானாகிய சவுல் அவனுடைய பட்டத்திற்கு வந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","சவுல் இறந்தபின், அக்போருடைய மகனாகிய பாகால்கானான் அவனுடைய பட்டத்திற்கு வந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","அக்போருடைய மகனாகிய பாகால்கானான் இறந்தபின், ஆதார் அவனுடைய பட்டத்திற்கு வந்தான். அவனுடைய பட்டணத்திற்குப் பாகு என்று பெயர்; அவனுடைய மனைவியின் பெயர் மெகேதபேல்; அவள் மத்ரேத்துடைய மகளும் மேசகாவின் மகளுமாக இருந்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","தங்கள் பற்பல வம்சங்களின்படியேயும், குடியிருப்புகளின்படியேயும், பெயர்களின்படியேயும் ஏசாவின் சந்ததியில் தோன்றிய பிரபுக்களுடைய பெயர்களாவன: திம்னா பிரபு, அல்வா பிரபு, எதேத் பிரபு, ");
INSERT INTO tam2017_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","அகோலிபாமா பிரபு, ஏலா பிரபு, பினோன் பிரபு, ");
INSERT INTO tam2017_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","கேனாஸ் பிரபு, தேமான் பிரபு, மிப்சார் பிரபு, ");
INSERT INTO tam2017_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","மக்தியேல் பிரபு, ஈராம் பிரபு; இவர்களே தங்கள் சொந்தமான தேசத்திலே பற்பல இடங்களில் குடியிருந்த ஏதோம் சந்ததிப் பிரபுக்கள்; இந்த ஏதோமியருக்குத் தகப்பன் ஏசா. ");
INSERT INTO tam2017_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","யாக்கோபு தன் தகப்பன் தங்கியிருந்த கானான் தேசத்திலே குடியிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","யாக்கோபுடைய சந்ததியின் வரலாறு: யோசேப்பு பதினேழு வயதிலே தன் சகோதரர்களுடனே ஆடுகளை மேய்த்துக்கொண்டிருந்தான்; அந்த இளைஞன் பில்காள் சில்பாள் என்னும் தன் தகப்பனுடைய மறுமனையாட்டிகளின் மகன்களோடு இருந்து, அவர்களுடைய துன்மார்க்கத்தைத் தன் தகப்பனுக்குச் சொல்லிவருவான். ");
INSERT INTO tam2017_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","இஸ்ரவேலின் முதிர்வயதிலே யோசேப்பு தனக்குப் பிறந்ததினால், இஸ்ரவேல் தன் மகன்கள் எல்லோரையும்விட அவனை அதிகமாக நேசித்து, அவனுக்குப் பலவர்ண அங்கியைச் செய்வித்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","அவனுடைய சகோதரர்கள் எல்லோரையும்விட அவனைத் தங்கள் தகப்பன் அதிகமாக நேசிக்கிறதை அவனுடைய சகோதரர்கள் கண்டபோது, அவனோடு ஆதரவாகப் பேசாமல் அவனைப் பகைத்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","யோசேப்பு ஒரு கனவு கண்டு, அதைத் தன் சகோதரர்களுக்குத் தெரிவித்தான்; அதனால் அவனை இன்னும் அதிகமாகப் பகைத்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","அவன் அவர்களை நோக்கி: “நான் கண்ட கனவைக் கேளுங்கள்: ");
INSERT INTO tam2017_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","நாம் வயலில் அறுத்த அரிகளைக் கட்டிக்கொண்டிருந்தோம்; அப்பொழுது என்னுடைய அரிக்கட்டு நிமிர்ந்திருந்தது; உங்களுடைய அரிக்கட்டுகள் என் அரிக்கட்டைச் சுற்றி வணங்கி நின்றது” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","அப்பொழுது அவனுடைய சகோதரர்கள் அவனைப் பார்த்து: “நீ எங்கள்மேல் ஆளுகை செய்வாயோ? நீ எங்களை ஆளப்போகிறாயோ”? என்று சொல்லி, அவனை அவனுடைய கனவுகளினாலும், அவனுடைய வார்த்தைகளினாலும் இன்னும் அதிகமாகப் பகைத்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","அவன் வேறொரு கனவு கண்டு, தன் சகோதரர்களை நோக்கி: “நான் இன்னும் ஒரு கனவைக் கண்டேன்; சூரியனும் சந்திரனும் பதினொரு நட்சத்திரங்களும் என்னை வணங்கினது” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","இதை அவன் தன்னுடைய தகப்பனுக்கும், சகோதரர்களுக்கும் சொன்னபோது, அவனுடைய தகப்பன் அவனைப் பார்த்து: “நீ கண்ட இந்தக் கனவு என்ன? நானும் உன்னுடைய தாயாரும், சகோதரர்களும் தரைவரைக்கும் குனிந்து உன்னை வணங்கவருவோமோ” என்று அவனைக் கடிந்துகொண்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","அவனுடைய சகோதரர்கள் அவன்மேல் பொறாமைகொண்டார்கள்; அவனுடைய தகப்பனோ அவன் சொன்னதை மனதிலே வைத்துக்கொண்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","பின்பு, அவனுடைய சகோதரர்கள் சீகேமிலே தங்கள் தகப்பனுடைய ஆடுகளை மேய்க்கப் போனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","அப்பொழுது இஸ்ரவேல் யோசேப்பை நோக்கி: “உன் சகோதரர்கள் சீகேமிலே ஆடுகளை மேய்க்கிறார்கள் அல்லவா? உன்னை அவர்களிடத்திற்கு அனுப்பப் போகிறேன், வா” என்றான். அவன்: “இதோ, போகிறேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","அப்பொழுது அவன்: “நீ போய், உன் சகோதரர்கள் எப்படி இருக்கிறார்கள் என்றும், ஆடுகள் எப்படி இருக்கிறது என்றும் பார்த்து, எனக்கு மறுசெய்தி கொண்டுவா என்று அவனுக்குச் சொல்லி, எபிரோன் பள்ளத்தாக்கிலே இருந்து அவனை அனுப்பினான்; அந்தப்படியே அவன் சீகேமுக்குப் போனான். ");
INSERT INTO tam2017_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","அப்பொழுது ஒரு மனிதன் அவன் வெளியிலே அலைந்து திரிவதைக் கண்டு, “என்ன தேடுகிறாய்”? என்று அவனைக் கேட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","அதற்கு அவன்: “என் சகோதரர்களைத் தேடுகிறேன், அவர்கள் எங்கே ஆடு மேய்க்கிறார்கள், சொல்லும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","அந்த மனிதன்: “அவர்கள் இந்த இடத்திலிருந்து போய்விட்டார்கள், தோத்தானுக்குப் போவோம் என்று அவர்கள் சொல்வதைக்கேட்டேன்” என்றான்; அப்பொழுது யோசேப்பு தன் சகோதரர்களைத் தொடர்ந்துபோய், அவர்களைத் தோத்தானிலே கண்டுபிடித்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","அவன் தூரத்தில் வருவதை அவர்கள் கண்டு, அவன் தங்களுக்கு அருகில் வருவதற்குமுன்னே, அவனைக் கொலைசெய்யும்படி சதியோசனைசெய்து, ");
INSERT INTO tam2017_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","ஒருவரை ஒருவர் நோக்கி: “இதோ, கனவுகாண்கிறவன் வருகிறான், ");
INSERT INTO tam2017_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","நாம் அவனைக் கொன்று, இந்தக் குழிகள் ஒன்றிலே அவனைப் போட்டு, ஒரு கொடியமிருகம் அவனைக் கொன்றது என்று சொல்லுவோம் வாருங்கள்; அவனுடைய கனவுகள் எப்படி நிறைவேறுமென்று பார்ப்போம்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","ரூபன் அதைக்கேட்டு, அவனை அவர்களுடைய கைக்குத் தப்புவித்து, அவனை அவனுடைய தகப்பனிடத்திற்குத் திரும்பவும் கொண்டுபோக மனதுள்ளவனாகி, ");
INSERT INTO tam2017_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","அவர்களை நோக்கி: “அவனைக் கொல்லவேண்டாம், நீங்கள் இரத்தம் சிந்தக்கூடாது; நீங்கள் அவன்மேல் கைகளை வைக்காமல், அவனை வனாந்திரத்திலுள்ள இந்தக் குழியிலே போட்டுவிடுங்கள்” என்று சொல்லி, இந்த விதமாக ரூபன் அவனை அவர்களிடமிருந்து தப்புவித்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","யோசேப்பு தன் சகோதரர்களிடத்தில் சேர்ந்தபோது யோசேப்பு அணிந்துகொண்டிருந்த பலவர்ண அங்கியை அவர்கள் கழற்றி, ");
INSERT INTO tam2017_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","அவனைத் தூக்கி, அந்தக் குழியிலே போட்டார்கள்; அது தண்ணீரில்லாத வெறுங்குழியாயிருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","பின்பு, அவர்கள் சாப்பிடுவதற்காக உட்கார்ந்தார்கள்; அவர்கள் தங்கள் கண்களை ஏறெடுக்கும்போது, இதோ, கீலேயாத்திலிருந்து வருகிற இஸ்மவேலருடைய கூட்டத்தைக் கண்டார்கள்; அவர்கள் எகிப்திற்குக் கொண்டுபோகும்படி கந்தவர்க்கங்களையும் பிசின்தைலத்தையும் வெள்ளைப்போளத்தையும் ஒட்டகங்கள்மேல் ஏற்றிக்கொண்டுவந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","அப்பொழுது யூதா தன் சகோதரர்களை நோக்கி: “நாம் நம்முடைய சகோதரனைக் கொன்று, அவனுடைய இரத்தத்தை மறைப்பதினால் லாபம் என்ன? ");
INSERT INTO tam2017_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","அவனை இந்த இஸ்மவேலருக்கு விற்றுப்போடுவோம் வாருங்கள்; நமது கை அவன்மேல் படாமலிருப்பதாக; அவன் நம்முடைய சகோதரனும் நம்முடைய சரீரமாக இருக்கிறானே” என்றான். அவனுடைய சகோதரர்கள் அவன் சொல்லுக்கு சம்மதித்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","அந்த வியாபாரிகளான மீதியானியர் கடந்துபோகிறபோது, அவர்கள் யோசேப்பை அந்தக் குழியிலிருந்து தூக்கியெடுத்து, அவனை இஸ்மவேலர் கையில் இருபது வெள்ளிக்காசுக்கு விற்றுப்போட்டார்கள். அவர்கள் யோசேப்பை எகிப்திற்குக் கொண்டுபோனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","பின்பு, ரூபன் அந்தக் குழியினிடத்திற்குத் திரும்பிப்போனபோது, யோசேப்பு குழியில் இல்லையென்று கண்டு, தன் ஆடைகளைக் கிழித்துக்கொண்டு, ");
INSERT INTO tam2017_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","தன் சகோதரரிடத்திற்குத் திரும்பி வந்து: “இளைஞன் இல்லையே, ஐயோ, நான் எங்கே போவேன் என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","அவர்கள் யோசேப்பின் அங்கியை எடுத்து, ஒரு வெள்ளாட்டுக்கடாவை அடித்து, அந்த அங்கியை இரத்தத்திலே நனைத்து, ");
INSERT INTO tam2017_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","அதைத் தங்கள் தகப்பனிடத்திற்கு அனுப்பி: “இதை நாங்கள் கண்டெடுத்தோம், இது உம்முடைய மகனின் அங்கியோ, அல்லவோ, பாரும்” என்று சொல்லச்சொன்னார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","யாக்கோபு அதைக் கண்டு, “இது என் மகனுடைய அங்கிதான், ஒரு கொடியமிருகம் அவனைக் கொன்றுபோட்டது, யோசேப்பு கிழிக்கப்பட்டுப் போனான்” என்று புலம்பி, ");
INSERT INTO tam2017_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","தன் ஆடைகளைக் கிழித்து, தன் இடுப்பில் சணல் ஆடையைக் கட்டிக்கொண்டு, அநேகநாட்கள் தன் மகனுக்காகத் துக்கித்துக்கொண்டிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","அவனுடைய மகன்கள், மகள்கள் எல்லோரும் அவனுக்கு ஆறுதல் சொல்ல வந்து நின்றார்கள்; ஆனாலும் அவன் ஆறுதலுக்கு இடம்கொடாமல், “நான் துக்கத்தோடு என் மகனிடத்திற்கு பாதாளத்தில் இறங்குவேன்” என்றான். இந்த விதமாக அவனுடைய தகப்பன் அவனுக்காக அழுதுகொண்டிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","அந்த மீதியானியர்கள் யோசேப்பை எகிப்திலே பார்வோனின் அதிகாரியும் மெய்க்காப்பாளர்களுக்கு தலைவனுமாகிய போத்திபார் என்பவனிடத்தில் விற்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","அக்காலத்திலே யூதா தன் சகோதரர்களை விட்டு, அதுல்லாம் ஊரானாகிய ஈரா என்னும் ஒரு மனிதனிடத்தில் போய்ச் சேர்ந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","அங்கே யூதா, சூவா என்னும் பேருள்ள ஒரு கானானியனுடைய மகளைக் கண்டு, அவளைத் திருமணம்செய்து, அவளோடு உறவுகொண்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","அவள் கர்ப்பவதியாகி ஒரு மகனைப் பெற்றெடுத்தாள்; அவனுக்கு ஏர் என்று பெயரிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","அவள் மறுபடியும் கர்ப்பவதியாகி ஒரு மகனைப் பெற்று, அவனுக்கு ஓனான் என்று பெயரிட்டாள். ");
INSERT INTO tam2017_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","அவள் மறுபடியும் கர்ப்பவதியாகி ஒரு மகனைப் பெற்று, அவனுக்கு சேலா என்று பெயரிட்டாள்; அவள் இவனைப் பெறுகிறபோது, அவன் கெசீபிலே இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","யூதா தன் மூத்த மகனாகிய ஏர் என்பவனுக்குத் தாமார் என்னும் பெயருள்ள ஒரு பெண்ணைத் திருமணம் செய்துவைத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","யூதாவின் மூத்த மகனாகிய ஏர் என்பவன் யெகோவாவின் பார்வைக்குப் பொல்லாதவனாக இருந்ததால், யெகோவா அவனை அழித்துப்போட்டார். ");
INSERT INTO tam2017_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","அப்பொழுது யூதா ஓனானை நோக்கி: “நீ உன் அண்ணன் மனைவியைச் சேர்ந்து, அவளுக்கு மைத்துனனுக்குரிய கடமையைச் செய்து, உன் அண்ணனுக்கு சந்ததியை உண்டாக்கு” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","அந்த சந்ததி தன் சந்ததியாக இருக்காதென்று ஓனான் அறிந்ததால், அவன் தன் அண்ணனுடைய மனைவியைச் சேரும்போது, தன் அண்ணனுக்கு சந்ததி உண்டாகாதபடித் தன் விந்தைத் தரையிலே விழவிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","அவன் செய்தது யெகோவாவுடைய பார்வைக்குப் பொல்லாததாக இருந்ததினால், அவனையும் அவர் அழித்துப்போட்டார். ");
INSERT INTO tam2017_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","அப்பொழுது யூதா, தன் மகனாகிய சேலாவும் அவனுடைய சகோதரர்கள் இறந்ததுபோல இறப்பான் என்று பயந்து, தன் மருமகளாகிய தாமாரை நோக்கி: “என் மகனாகிய சேலா பெரியவனாகும்வரைக்கும், நீ உன் தகப்பன் வீட்டில் விதவையாகத் தங்கியிரு” என்று சொன்னான்; அதன்படியே தாமார் போய்த் தன் தகப்பனுடைய வீட்டிலே தங்கியிருந்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","அநேகநாட்கள் சென்றபின், சூவாவின் மகளாகிய யூதாவின் மனைவி இறந்தாள். யூதாவினுடைய துக்கம் ஆறினபின், அவன் அதுல்லாம் ஊரானாகிய தன் சிநேகிதன் ஈராவுடனே திம்னாவிலே தன் ஆடுகளை மயிர்க் கத்தரிக்கிறவர்களிடத்திற்குப் போனான். ");
INSERT INTO tam2017_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","அப்பொழுது: “உன் மாமனார் தம்முடைய ஆடுகளை மயிர்க்கத்தரிக்கத் திம்னாவுக்குப் போகிறார்” என்று தாமாருக்குத் தெரிவிக்கப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","சேலா பெரியவனாகியும் தான் அவனுக்கு மனைவியாகக் கொடுக்கப்படவில்லை என்று அவள் கண்டதால், தன் விதவைக்குரிய ஆடைகளை மாற்றி, முக்காடிட்டுத் தன்னை மூடிக்கொண்டு, திம்னாவுக்குப் போகிற வழியிலிருக்கிற நீரூற்றுகளுக்கு முன்பாக உட்கார்ந்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","யூதா அவளைக் கண்டு, அவள் தன் முகத்தை மூடியிருந்ததால், அவள் ஒரு விலைமாது என்று நினைத்து, ");
INSERT INTO tam2017_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","அந்த வழியாக அவளிடத்தில் போய், அவள் தன் மருமகள் என்று அறியாமல்: “நான் உன்னிடத்தில் சேர வருவாயா” என்றான்; அதற்கு அவள்: “நீர் என்னிடத்தில் சேருவதற்கு, எனக்கு என்ன தருவீர்” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","அதற்கு அவன்: நான் மந்தையிலிருந்து ஒரு வெள்ளாட்டுக்குட்டியை அனுப்புகிறேன்” என்றான். அதற்கு அவள்: “நீர் அதை அனுப்பும்வரைக்கும் ஒரு அடைமானம் கொடுப்பீரா” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","அப்பொழுது அவன்: “நான் உனக்கு அடைமானமாக என்ன கொடுக்கவேண்டும்” என்று கேட்டான். அதற்கு அவள்: “உம்முடைய முத்திரை மோதிரமும், அதனுடைய கயிறும், உம்முடைய கைத்தடியையும் கொடுக்கவேண்டும்” என்றாள். அவன் அவைகளை அவளுக்குக் கொடுத்து, அவளிடத்தில் சேர்ந்தான்; அவள் அவனாலே கர்ப்பவதியாகி, ");
INSERT INTO tam2017_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","எழுந்துபோய், தன் முக்காட்டை மாற்றி, தன் விதவைக்குரிய ஆடைகளை அணிந்துகொண்டாள். ");
INSERT INTO tam2017_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","யூதா அந்த பெண்ணிடத்தில் இருந்த அடைமானத்தை வாங்கிக்கொண்டுவர அதுல்லாம் ஊரானாகிய தன் நண்பனிடம் ஒரு வெள்ளாட்டுக்குட்டியைக் கொடுத்தனுப்பினான்; அவன் அவளைக் காணாமல், ");
INSERT INTO tam2017_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","அந்த இடத்தின் மனிதர்களை நோக்கி: “வழியிலே நீரூற்றுகள் அருகே இருந்த விலைமாது எங்கே” என்று கேட்டான்; அதற்கு அவர்கள்: “இங்கே விலைமாது இல்லை” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","அவன் யூதாவினிடத்தில் திரும்பி வந்து: “அவளைக் காணவில்லை, அங்கே விலைமாது இல்லையென்று அந்த இடத்து மனிதர்களும் சொல்லுகிறார்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","அப்பொழுது யூதா: “இதோ, இந்த ஆட்டுக்குட்டியை அனுப்பினேன், நீ அவளைக் காணவில்லை; நமக்கு வெட்கம் உண்டாகாதபடி, அவள் அதைக் கொண்டுபோனால் போகட்டும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ஏறக்குறைய மூன்றுமாதம் சென்றபின்பு உன் மருமகளாகிய தாமார் வேசித்தனம்செய்தாள், அந்த வேசித்தனத்தினால் கர்ப்பவதியுமானாள் என்று யூதாவுக்கு தெரிவிக்கப்பட்டது. அப்பொழுது யூதா: “அவளை வெளியே கொண்டுவாருங்கள், அவள் சுட்டெரிக்கப்படவேண்டும் என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","அவள் வெளியே கொண்டுவரப்பட்டபோது, அவள் தன் மாமனிடத்திற்கு அந்த அடைமானத்தை அனுப்பி, இந்தப் பொருட்களை உடையவன் எவனோ அவனாலே நான் கர்ப்பவதியானேன்; இந்த முத்திரை மோதிரமும், கயிறும், இந்தக் கோலும் யாருடையவைகள் பாரும்” என்று சொல்லி அனுப்பினாள். ");
INSERT INTO tam2017_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","யூதா அவைகளை அடையாளம்கண்டு: “என்னிலும் அவள் நீதியுள்ளவள்; அவளை என் மகனாகிய சேலாவுக்குக் கொடுக்காமற்போனேனே” என்றான். அப்புறம் அவன் அவளைச் சேரவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","அவளுக்குப் பிரசவநேரம் வந்தபோது, அவளுடைய கர்ப்பத்தில் இரட்டைப்பிள்ளைகள் இருந்தன. ");
INSERT INTO tam2017_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","அவள் பிரசவிக்கும்போது, ஒரு குழந்தை கையை நீட்டினது; அப்பொழுது மருத்துவச்சி அதன் கையைப் பிடித்து, அதில் சிவப்புநூலைக் கட்டி, “இது முதலாவது வெளிப்பட்டது” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","அது தன் கையைத் திரும்ப உள்ளே வாங்கிக்கொண்டபோது, அதின் சகோதரன் வெளிப்பட்டான். அப்பொழுது அவள்: “நீ மீறிவந்தது என்ன, இந்த மீறுதல் உன்மேல் நிற்கும்” என்றாள்; அதனால் அவனுக்குப் பாரேஸ் என்று பெயரிடப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","பின்பு கையில் சிவப்புநூல் கட்டப்பட்டிருந்த அவனுடைய தம்பி வெளிப்பட்டான்; அவனுக்கு சேரா என்று பெயரிடப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","யோசேப்பு எகிப்திற்குக் கொண்டு போகப்பட்டான். பார்வோனுடைய அதிகாரியும் மெய்க்காப்பாளர்களுக்குத் தலைவனுமாகிய போத்திபார் என்னும் எகிப்து தேசத்தான் அவனை அந்த இடத்திற்குக் கொண்டுவந்த இஸ்மவேலரிடத்தில் விலைக்கு வாங்கினான். ");
INSERT INTO tam2017_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","யெகோவா யோசேப்போடு இருந்தார், அவன் காரியசித்தியுள்ளவனானான்; அவன் எகிப்தியனாகிய தன் எஜமானுடைய வீட்டிலே இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","யெகோவா அவனோடு இருக்கிறார் என்றும், அவன் செய்கிற அனைத்தையும் யெகோவா வாய்க்கச்செய்கிறார் என்றும், அவனுடைய எஜமான் கண்டு; ");
INSERT INTO tam2017_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","யோசேப்பினிடத்தில் தயவுவைத்து, அவனைத் தனக்கு வேலைக்காரனும் தன் வீட்டிற்கு விசாரணைக்காரனுமாக்கி, தனக்கு உண்டான அனைத்தையும் அவனுடைய கையில் ஒப்புவித்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","அவனைத் தன் வீட்டிற்கும் தனக்கு உண்டான எல்லாவற்றிற்கும் விசாரணைக்காரனாக்கினது முதற்கொண்டு, யெகோவா யோசேப்பின்மூலம் அந்த எகிப்தியன் வீட்டை ஆசீர்வதித்தார்; வீட்டிலும் வெளியிலும் அவனுக்கு உண்டானவைகள் எல்லாவற்றிலும் யெகோவாவுடைய ஆசீர்வாதம் இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","ஆகையால், அவன் தனக்கு உண்டானதையெல்லாம் யோசேப்பின் கையிலே ஒப்புக்கொடுத்துவிட்டு, தான் சாப்பிடுகிற உணவு தவிர தன்னிடத்திலிருந்த மற்றொன்றைக்குறித்தும் விசாரிக்காமல் இருந்தான். யோசேப்பு அழகான ரூபமும் சௌந்தரிய முகமும் உள்ளவனாயிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","சிலநாட்கள் சென்றபின், அவனுடைய எஜமானின் மனைவி யோசேப்பின்மேல் மோகம்கொண்டு, “என்னோடு உறவுகொள்” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","அவனோ தன் எஜமானுடைய மனைவியின் சொல்லுக்குச் சம்மதிக்காமல், அவளை நோக்கி: “இதோ, வீட்டிலே என்னிடத்தில் இருக்கிறவைகளில் ஒன்றைக்குறித்தும் என் ஆண்டவன் விசாரிக்காமல், தமக்கு உண்டான எல்லாவற்றையும் என்னுடைய கையில் ஒப்படைத்திருக்கிறார். ");
INSERT INTO tam2017_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","இந்த வீட்டிலே என்னிலும் பெரியவன் இல்லை; நீ அவருடைய மனைவியாக இருப்பதால் உன்னைத்தவிர வேறோன்றையும் அவர் எனக்கு விலக்கி வைக்கவில்லை; இப்படியிருக்கும்போது, நான் இத்தனை பெரிய பொல்லாங்குக்கு உடன்பட்டு, தேவனுக்கு விரோதமாகப் பாவம் செய்வது எப்படி” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","அவள் தொடர்ந்து யோசேப்போடு இப்படிப் பேசிக்கொண்டு வந்தும், அவன் அவளுடனே உறவுகொள்ளவும் அவளுடனே இருக்கவும் சம்மதிக்கவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","இப்படியிருக்கும்போது, ஒருநாள் அவன் தன் வேலையைச் செய்கிறதற்கு வீட்டிற்குள் போனான்; வீட்டு மனிதர்களில் ஒருவரும் வீட்டில் இல்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","அப்பொழுது அவள் அவனுடைய உடையைப் பற்றிப் பிடித்து, “என்னோடு உறவுகொள் என்றாள். அவனோ தன் உடையை அவள் கையிலே விட்டுவிட்டு வெளியே ஓடிப்போனான். ");
INSERT INTO tam2017_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","அவன் வெளியே ஓடிப்போனதை அவள் கண்டபோது, ");
INSERT INTO tam2017_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","அவள் தன் வீட்டு மனிதரைக் கூப்பிட்டு: “பாருங்கள், எபிரெய மனிதன் நம்மை பரியாசம்செய்ய, போத்திபார் அவனை நம்மிடத்தில் கொண்டுவந்தார், அவன் என்னோடு உறவுகொள்வதற்கு என்னிடத்தில் வந்தான்; நான் மிகுந்த சத்தமிட்டுக் கூப்பிட்டேன். ");
INSERT INTO tam2017_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","நான் சத்தமிட்டுக் கூப்பிடுகிறதை அவன் கேட்டு, தன் உடையை என்னிடத்தில் விட்டுவிட்டு, வெளியே ஓடிப்போய்விட்டான்” என்று சொன்னாள். ");
INSERT INTO tam2017_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","அவனுடைய எஜமான் வீட்டிற்கு வரும்வரைக்கும் அவனுடைய உடையைத் தன்னிடத்தில் வைத்திருந்து, ");
INSERT INTO tam2017_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","அவனை நோக்கி: “நீர் நம்மிடத்தில் கொண்டுவந்த அந்த எபிரெய வேலைக்காரன் தவறான எண்ணத்துடன் என்னிடத்தில் வந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","அப்பொழுது நான் சத்தமிட்டுக் கூப்பிட்டேன், அவன் தன் உடையை என்னிடத்தில் விட்டுவிட்டு வெளியே ஓடிப்போனான்” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","உம்முடைய வேலைக்காரன் எனக்கு இப்படிச் செய்தான் என்று தன் மனைவி தன்னிடம் சொன்ன வார்த்தைகளை அவனுடைய எஜமான் கேட்டபோது, அவன் கோபமடைந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","யோசேப்பின் எஜமான் அவனைப்பிடித்து, ராஜாவின் கட்டளையால் காவலில் வைக்கப்பட்டவர்கள் இருக்கும் சிறைச்சாலையிலே அவனை ஒப்புவித்தான். அந்தச் சிறைச்சாலையில் அவன் இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","யெகோவாவோ யோசேப்போடு இருந்து, அவன்மேல் கிருபைவைத்து, சிறைச்சாலைத் தலைவனுடைய தயவு அவனுக்குக் கிடைக்கச்செய்தார். ");
INSERT INTO tam2017_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","சிறைச்சாலைத் தலைவன் சிறைச்சாலையில் வைக்கப்பட்ட அனைவரையும் யோசேப்பின் பொறுப்பிலே ஒப்புவித்தான்; அங்கே அவர்கள் செய்வதெல்லாவற்றிற்கும் யோசேப்பு பொறுப்பாயிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","யெகோவா அவனோடு இருந்ததினாலும், அவன் எதைச் செய்தானோ அதைக் யெகோவா வாய்க்கச்செய்ததாலும், அவன் வசமாயிருந்த ஒன்றையும் குறித்துச் சிறைச்சாலைத் தலைவன் விசாரிக்கவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","இந்த சம்பவங்களுக்குப்பின்பு, எகிப்தின் ராஜாவுக்கு பானபாத்திரக்காரனும் அப்பம் சுடுகிறவனும் எகிப்தின் ராஜாவாகிய தங்கள் ஆண்டவனுக்கு விரோதமாகக் குற்றம் செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","பார்வோன் தன் பானபாத்திரக்காரர்களின் தலைவனும் அப்பம் சுடுகிறவர்களின் தலைவனுமாகிய இவ்விரண்டு அதிகாரிகள்மேல் கடுங்கோபம்கொண்டு, ");
INSERT INTO tam2017_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","அவர்களை யோசேப்பு வைக்கப்பட்டிருந்த இடமும் காவலாளிகளின் அதிபதியின் வீடுமாகிய சிறைச்சாலையிலே காவலில் வைத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","காவலாளிகளின் அதிபதி அவர்களை விசாரிக்கும்படி யோசேப்பின் வசத்தில் ஒப்புவித்தான்; அவன் அவர்களை விசாரித்துவந்தான்; அவர்கள் அநேகநாட்கள் காவலில் இருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","எகிப்தின் ராஜாவுக்குப் பானபாத்திரக்காரனும் அப்பம் சுடுகிறவனுமாகிய அந்த இரண்டுபேரும் சிறைச்சாலையில் இருக்கும்போது, ஒரே இரவில் வெவ்வேறு அர்த்தமுள்ள கனவு கண்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","காலையில் யோசேப்பு அவர்களிடத்தில் போய், அவர்களைப் பார்க்கும்போது, அவர்கள் கலங்கியிருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","அப்பொழுது அவன் தன் எஜமானுடைய வீட்டில் தன்னோடு காவலில் வைக்கப்பட்டிருந்த பார்வோனுடைய அதிகாரிகளை நோக்கி: “உங்கள் முகங்கள் இன்று துக்கமாயிருக்கிறது என்ன” என்று கேட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","அதற்கு அவர்கள்: “கனவு கண்டோம், அதற்கு அர்த்தம் சொல்லுகிறவன் ஒருவனும் இல்லை” என்றார்கள். அதற்கு யோசேப்பு: “கனவுக்கு அர்த்தம் சொல்லுவது தேவனுக்குரியதல்லவா? அவைகளை என்னிடத்தில் சொல்லுங்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","அப்பொழுது பானபாத்திரக்காரர்களின் தலைவன் யோசேப்பை நோக்கி: “என் கனவிலே ஒரு திராட்சைச்செடி எனக்கு முன்பாக இருக்கக்கண்டேன். ");
INSERT INTO tam2017_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","அந்தத் திராட்சைச்செடியிலே மூன்று கொடிகள் இருந்தது; அது துளிர்க்கிறதாயிருந்தது; அதில் பூக்கள் மலர்ந்திருந்தது; அதின் குலைகள் பழுத்த பழங்களாயிருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","பார்வோனுடைய பாத்திரம் என்னுடைய கையிலே இருந்தது; நான் அந்தப் பழங்களைப் பறித்து, அவைகளைப் பார்வோனுடைய பாத்திரத்தில் பிழிந்து, அந்தப் பாத்திரத்தைப் பார்வோனுடைய கையிலே கொடுத்தேன்” என்று தன் கனவைச் சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","அதற்கு யோசேப்பு: “அந்த மூன்று கொடிகளும் மூன்று நாட்களாம். ");
INSERT INTO tam2017_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","மூன்று நாட்களுக்குள்ளே பார்வோன் உன் தலையை உயர்த்தி, உன்னை மறுபடியும் உன் நிலையிலே நிறுத்துவார்; முன்னே அவருக்கு பானம் கொடுத்துவந்த வழக்கத்தின்படி பார்வோனின் பாத்திரத்தை அவருடைய கையிலே கொடுப்பாய்; ");
INSERT INTO tam2017_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","இதுதான் அதனுடைய அர்த்தம் என்று சொன்னதுமல்லாமல் நீ வாழ்வடைந்திருக்கும்போது, என்னை நினைத்து, என்மேல் தயவுவைத்து, என் காரியத்தைப் பார்வோனுக்குத் தெரிவித்து, இந்த இடத்திலிருந்து என்னை விடுதலையாக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","நான் எபிரெயர்களுடைய தேசத்திலிருந்து களவாகக் கொண்டுவரப்பட்டேன்; என்னை இந்தக் காவல்கிடங்கில் வைக்கும்படி நான் இந்த இடத்தில் ஒன்றும் செய்யவில்லை” என்றும் சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","அர்த்தம் நன்றாயிருக்கிறது என்று அப்பம் சுடுகிறவர்களின் தலைவன் கண்டு, யோசேப்பை நோக்கி: “நானும் என் கனவில் மூன்று வெள்ளைக் கூடைகள் என் தலையின்மேல் இருக்கக்கண்டேன்; ");
INSERT INTO tam2017_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","மேற்கூடையிலே பார்வோனுக்காக சமைக்கப்பட்ட அனைத்துவித பலகாரங்களிலும் கொஞ்சம் கொஞ்சம் இருந்தது; என் தலையின் மேற்கூடையில் இருந்தவைகளைப் பறவைகள் வந்து சாப்பிட்டுவிட்டது” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","அதற்கு யோசேப்பு: “அந்த மூன்று கூடைகளும் மூன்று நாட்களாம். ");
INSERT INTO tam2017_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","இன்னும் மூன்று நாட்களுக்குள்ளே பார்வோன் உன் தலையை உயர்த்தி, உன்னை மரத்திலே தூக்கிலிடுவார்; அப்பொழுது பறவைகள் உன் மாம்சத்தைத் தின்னும், இதுதான் அதனுடைய அர்த்தம்” என்று சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","மூன்றாம் நாள் பார்வோனுடைய பிறந்த நாளாயிருந்தது; அவன் தன் வேலைக்காரர்கள் எல்லோருக்கும் விருந்துசெய்து, பானபாத்திரக்காரர்களுடைய தலைவனையும் அப்பம் சுடுகிறவர்களின் தலைவனையும் தன் உத்தியோகஸ்தரின் நடுவே நிறுத்தி, ");
INSERT INTO tam2017_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","பானபாத்திரக்காரர்களின் தலைவனைப் பானம் கொடுக்கிற தன் உத்தியோகத்திலே மறுபடியும் வைத்தான்; அந்தப்படியே அவன் பார்வோனுடைய கையிலே பாத்திரத்தைக் கொடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","அப்பம் சுடுகிறவர்களின் தலைவனையோ தூக்கிலிட்டான். யோசேப்பு அவர்களுக்குச் சொன்ன அர்த்தத்தின்படியே சம்பவித்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","ஆனாலும் பானபாத்திரக்காரனின் தலைவன் யோசேப்பை நினைக்காமல் அவனை மறந்துவிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","இரண்டு வருடங்கள் சென்றபின்பு, பார்வோன் ஒரு கனவு கண்டான்; அது என்னவென்றால், அவன் நைல் நதியருகில் நின்றுகொண்டிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","அப்பொழுது அழகும் கொழுத்ததுமான ஏழு பசுக்கள் நதியிலிருந்து ஏறிவந்து புல் மேய்ந்தன. ");
INSERT INTO tam2017_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","அவைகளுக்குப்பின்பு அவலட்சணமும் கேவலமுமான வேறே ஏழு பசுக்கள் நதியிலிருந்து ஏறிவந்து, நதி ஓரத்தில் மற்ற பசுக்களுடன் நின்றன. ");
INSERT INTO tam2017_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","அவலட்சணமும் கேவலமுமான பசுக்கள் அழகும் கொழுத்ததுமான ஏழு பசுக்களையும் விழுங்கிப்போட்டது; இப்படிப் பார்வோன் கண்டு விழித்துக்கொண்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","மறுபடியும் அவன் தூங்கியபோது, இரண்டாம் முறை ஒரு கனவு கண்டான்; நல்ல செழுமையான ஏழு கதிர்கள் ஒரே செடியிலிருந்து ஓங்கி வளர்ந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","பின்பு, மெலிந்ததும் கீழ்காற்றினால் வறண்டதுமான ஏழு கதிர்கள் முளைத்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","மெலிந்த கதிர்கள் செழுமையும் நிறை மேனியுமான அந்த ஏழு கதிர்களையும் விழுங்கிப்போட்டது; அப்பொழுது பார்வோன் விழித்துக்கொண்டு, அது கனவு என்று அறிந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","காலையிலேயே பார்வோனுடைய மனம் கலக்கம் கொண்டிருந்தது; அப்பொழுது அவன் எகிப்திலுள்ள அனைத்து மந்திரவாதிகளையும் அனைத்து அறிஞர்களையும் அழைப்பித்து, அவர்களுக்குத் தன் கனவைச் சொன்னான்; ஒருவராலும் அதின் அர்த்தத்தைப் பார்வோனுக்குச் சொல்ல முடியாமல் போனது. ");
INSERT INTO tam2017_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","அப்பொழுது பானபாத்திரக்காரர்களின் தலைவன் பார்வோனை நோக்கி: “நான் செய்த குற்றம் இன்றுதான் என் ஞாபகத்தில் வந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","பார்வோன் தம்முடைய வேலைக்காரர்கள்மேல் கடுங்கோபங்கொண்டு, என்னையும் அப்பம் சுடுகிறவர்களின் தலைவனையும் காவலாளிகளின் அதிபதியின் வீடாகிய சிறைச்சாலையிலே வைத்திருந்த காலத்தில், ");
INSERT INTO tam2017_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","நானும் அவனும் ஒரே இரவிலே வெவ்வேறு அர்த்தம்கொண்ட கனவு கண்டோம். ");
INSERT INTO tam2017_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","அப்பொழுது காவலாளிகளின் அதிபதிக்கு வேலைக்காரனாகிய எபிரெய வாலிபன் ஒருவன் அங்கே எங்களோடு இருந்தான்; அவனிடத்தில் அவைகளைச் சொன்னோம், அவன் நாங்கள் கண்ட கனவுகளுக்குரிய வெவ்வேறு அர்த்தத்தின்படியே எங்கள் கனவுகளின் அர்த்தத்தைச் சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","அவன் எங்களுக்குச் சொல்லிய அர்த்தத்தின்படியே நடந்தது; என்னைத் திரும்ப என் நிலையிலே நிறுத்தி, அவனைத் தூக்கில் போட்டுவிட்டார்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","அப்பொழுது பார்வோன் யோசேப்பை அழைப்பித்தான்; அவனை அவசரமாகச் சிறைச்சாலையிலிருந்து அழைத்துவந்தார்கள். அவன் சவரம் செய்துகொண்டு, வேறு உடை அணிந்து, பார்வோனிடத்தில் வந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","பார்வோன் யோசேப்பை நோக்கி: “ஒரு கனவு கண்டேன்; அதின் அர்த்தத்தைச் சொல்ல ஒருவரும் இல்லை; நீ ஒரு கனவைக் கேட்டால், அதின் அர்த்தத்தைச் சொல்லுவாய் என்று உன்னைக்குறித்து நான் கேள்விப்பட்டேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","அப்பொழுது யோசேப்பு பார்வோனுக்கு மறுமொழியாக: “நான் அல்ல, தேவனே பார்வோனுக்கு மங்களமான உத்திரவு அருளிச்செய்வார்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","பார்வோன் யோசேப்பை நோக்கி: “என் கனவிலே, நான் நதியின் ஓரத்தில் நின்றுகொண்டிருந்தேன். ");
INSERT INTO tam2017_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","அழகும் கொழுத்ததுமான ஏழு பசுக்கள் நதியிலிருந்து ஏறிவந்து புல் மேய்ந்தன. ");
INSERT INTO tam2017_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","அவைகளுக்குப்பின்பு இளைத்ததும் மகா அவலட்சணமும் கேவலமுமான வேறே ஏழு பசுக்கள் ஏறிவந்தன; இவைகளைப்போல அவலட்சணமான பசுக்களை எகிப்து தேசமெங்கும் நான் கண்டதில்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","கேவலமும் அவலட்சணமுமான பசுக்கள், கொழுத்திருந்த முந்தின ஏழு பசுக்களையும் விழுங்கிப்போட்டன. ");
INSERT INTO tam2017_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","அவைகள் இவைகளின் வயிற்றுக்குள் போனபோதிலும், வயிற்றுக்குள் போயிற்றென்று தோன்றாமல், முன்பு இருந்தது போலவே அவலட்சணமாக இருந்தன; இப்படிக் கண்டு விழித்துக்கொண்டேன். ");
INSERT INTO tam2017_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","பின்னும் நான் என் கனவிலே, நிறை மேனியுள்ள ஏழு நல்ல கதிர்கள் ஒரே செடியிலிருந்து ஓங்கி வளரக்கண்டேன். ");
INSERT INTO tam2017_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","பின்பு மெலிந்தவைகளும் கீழ்காற்றினால் உலர்ந்து பதரானவைகளுமான ஏழு கதிர்கள் முளைத்தன. ");
INSERT INTO tam2017_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","மெலிந்த கதிர்கள் அந்த ஏழு நல்ல கதிர்களையும் விழுங்கிப்போட்டன”. இதை மந்திரவாதிகளிடத்தில் சொன்னேன்; இதின் அர்த்தத்தை எனக்கு சொல்லுகிறவன் ஒருவனும் இல்லை என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","அப்பொழுது யோசேப்பு பார்வோனை நோக்கி: “பார்வோனின் கனவு ஒன்று தான்; தேவன் தாம் செய்யப்போகிறது இன்னதென்று பார்வோனுக்கு தெரிவித்திருக்கிறார். ");
INSERT INTO tam2017_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","அந்த ஏழு நல்ல பசுக்களும் ஏழு வருடங்களாம்; அந்த ஏழு நல்ல கதிர்களும் ஏழு வருடங்களாம்; கனவு ஒன்றே. ");
INSERT INTO tam2017_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","அவைகளுக்குப்பின்பு ஏறிவந்த கேவலமும் அவலட்சணமுமான ஏழு பசுக்களும் ஏழு வருடங்களாம்; கீழ்காற்றினால் தீய்ந்து உலர்ந்ததுமான ஏழு கதிர்களும் ஏழு வருடங்களாம்; இவைகள் பஞ்சமுள்ள ஏழு வருடங்களாம். ");
INSERT INTO tam2017_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","பார்வோனுக்கு நான் சொல்லவேண்டிய காரியம் இதுவே; தேவன் தாம் செய்யப்போகிறதைப் பார்வோனுக்குக் காண்பித்திருக்கிறார். ");
INSERT INTO tam2017_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","எகிப்து தேசமெங்கும் பரிபூரணமான விளைச்சல் உண்டாயிருக்கும் ஏழு வருடங்கள் வரும். ");
INSERT INTO tam2017_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","அதன்பின்பு பஞ்சமுண்டாயிருக்கும் ஏழு வருடங்கள் வரும்; அப்பொழுது எகிப்துதேசத்தில் அந்தப் பரிபூரணமெல்லாம் மறக்கப்பட்டுப்போகும்; அந்தப் பஞ்சம் தேசத்தைப் பாழாக்கும். ");
INSERT INTO tam2017_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","வரப்போகிற மகா கொடுமையான பஞ்சத்தால் தேசத்தில் முன்னிருந்த பரிபூரணமெல்லாம் ஒழிந்துபோகும். ");
INSERT INTO tam2017_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","இந்தக் காரியம் தேவனால் நிச்சயிக்கப்பட்டிருக்கிறது என்பதையும், தேவன் இதைச் சீக்கிரத்தில் செய்வார் என்பதையும் குறிப்பதற்காக, இந்தக் கனவு பார்வோனுக்கு மீண்டும் வந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","ஆகையால், விவேகமும் ஞானமுமுள்ள ஒரு மனிதனைத் தேடி, அவனை எகிப்துதேசத்திற்கு அதிகாரியாகப் பார்வோன் ஏற்படுத்துவாராக. ");
INSERT INTO tam2017_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","இப்படிப் பார்வோன் செய்து, தேசத்தின்மேல் விசாரணைக்காரரை வைத்து, பரிபூரணமுள்ள ஏழு வருடங்களில் எகிப்துதேசத்திலே விளையும் விளைச்சலில் ஐந்தில் ஒரு பங்கை வாங்கும்படிச் செய்வாராக. ");
INSERT INTO tam2017_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","அவர்கள் வரப்போகிற நல்ல வருடங்களில் விளையும் தானியங்களையெல்லாம் சேர்த்து, பட்டணங்களில் ஆகாரம் உண்டாயிருப்பதற்கு, பார்வோனுடைய அதிகாரத்திற்குள்ளாகத் தானியங்களைப் பத்திரப்படுத்தி சேமித்துவைப்பார்களாக. ");
INSERT INTO tam2017_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","தேசம் பஞ்சத்தினால் அழிந்துபோகாமலிருக்க, அந்தத் தானியம் இனி எகிப்துதேசத்தில் உண்டாகும் பஞ்சமுள்ள ஏழு வருடங்களுக்காக தேசத்திற்கு ஒரு வைப்பாயிருப்பதாக” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","இந்த வார்த்தை பார்வோனுடைய பார்வைக்கும் அவனுடைய வேலைக்காரர்கள் எல்லோருடைய பார்வைக்கும் நன்றாகத் தோன்றியது. ");
INSERT INTO tam2017_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","அப்பொழுது பார்வோன் தன் ஊழியக்காரரை நோக்கி: “தேவ ஆவியைப் பெற்ற இந்த மனிதனைப்போல வேறொருவன் உண்டோ” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","பின்பு, பார்வோன் யோசேப்பை நோக்கி: “தேவன் இவையெல்லாவற்றையும் உனக்கு வெளிப்படுத்தியிருக்கிறதினால், உன்னைப்போல விவேகமும் ஞானமுமுள்ளவன் வேறொருவனும் இல்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","நீ என் அரண்மனைக்கு அதிகாரியாயிருப்பாய்; உன் வார்த்தைக்கு என் மக்கள் எல்லோரும் அடங்கி நடக்கக்கடவர்கள்; சிங்காசனத்தில் மாத்திரம் உன்னிலும் நான் பெரியவனாக இருப்பேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","பின்னும் பார்வோன் யோசேப்பை நோக்கி: “பார், முழு எகிப்துதேசத்திற்கும் உன்னை அதிகாரியாக்கினேன்” என்று சொல்லி, ");
INSERT INTO tam2017_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","பார்வோன் தன் கையில் போட்டிருந்த தன் முத்திரை மோதிரத்தைக் கழற்றி, அதை யோசேப்பின் கையிலே போட்டு, மெல்லிய ஆடைகளை அவனுக்கு அணிவித்து, தங்கச் சங்கிலியை அவனுடைய கழுத்திலே அணிவித்து, ");
INSERT INTO tam2017_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","தன்னுடைய இரண்டாம் இரதத்தின்மேல் அவனை ஏற்றி, குனிந்து பணியுங்கள் என்று அவனுக்கு முன்பாகக் கூறுவித்து, முழு எகிப்துதேசத்திற்கும் அவனை அதிகாரியாக்கினான்; ");
INSERT INTO tam2017_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","பின்னும் பார்வோன் யோசேப்பை நோக்கி: “நான் பார்வோன்; ஆனாலும் எகிப்துதேசத்திலுள்ளவர்களில் ஒருவனும் உன் உத்திரவில்லாமல் தன் கையையாவது தன் காலையாவது அசைக்கக்கூடாது” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","மேலும், பார்வோன் யோசேப்புக்கு சாப்நாத்பன்னேயா என்கிற பெயரையிட்டு; ஓன் பட்டணத்து ஆசாரியனாகிய போத்திபிராவின் மகளாகிய ஆஸ்நாத்தை அவனுக்கு மனைவியாகக் கொடுத்தான். யோசேப்பு எகிப்துதேசத்தைச் சுற்றிப்பார்க்கும்படிப் புறப்பட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","யோசேப்பு எகிப்தின் ராஜாவாகிய பார்வோனுக்கு முன்பாக நிற்கும்போது முப்பது வயதாயிருந்தான்; யோசேப்பு பார்வோனுடைய சந்நிதியிலிருந்து புறப்பட்டு, எகிப்துதேசம் எங்கும் போய்ச் சுற்றிப்பார்த்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","பரிபூரணமுள்ள ஏழு வருடங்களிலும் பூமி மிகுதியான பலனைக் கொடுத்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","அந்த ஏழு வருடங்களில் எகிப்துதேசத்தில் விளைந்த தானியங்களையெல்லாம் அவன் சேகரித்து, அந்தத் தானியங்களைப் பட்டணங்களில் சேமித்துவைத்தான்; அந்தந்தப் பட்டணத்தில் அதினதின் சுற்றுப்புறத்து தானியங்களைச் சேமித்துவைத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","இப்படி யோசேப்பு அளக்கமுடியாத அளவிற்குக் கடற்கரை மணலைப்போல மிகுதியாகத் தானியத்தைச் சேர்த்துவைத்தான்; அது அளவுக்கு அடங்காததாயிருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","பஞ்சமுள்ள வருடங்கள் வருவதற்கு முன்னே யோசேப்புக்கு இரண்டு மகன்கள் பிறந்தார்கள்; அவர்களை ஓன் பட்டணத்து ஆசாரியனாகிய போத்திபிராவின் மகளாகிய ஆஸ்நாத்து அவனுக்குப் பெற்றெடுத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","யோசேப்பு: என் வருத்தம் அனைத்தையும் என் தகப்பனுடைய குடும்பம் அனைத்தையும் நான் மறக்கும்படி தேவன் செய்தார் என்று சொல்லி, மூத்தவனுக்கு மனாசே என்று பெயரிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","நான் சிறுமைப்பட்டிருந்த தேசத்தில் தேவன் என்னைப் பலுகச்செய்தார் என்று சொல்லி, இளையவனுக்கு எப்பிராயீம் என்று பெயரிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","எகிப்துதேசத்தில் வந்த பரிபூரணமுள்ள ஏழு வருடங்களும் முடிந்தபின், ");
INSERT INTO tam2017_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","யோசேப்பு சொல்லியிருந்தபடி ஏழுவருட பஞ்சம் தொடங்கினது; அனைத்துதேசங்களிலும் பஞ்சம் உண்டானது; ஆனாலும் எகிப்துதேசமெங்கும் ஆகாரம் இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","எகிப்துதேசமெங்கும் பஞ்சம் உண்டானபோது, மக்கள் உணவுக்காகப் பார்வோனை நோக்கி முறையிட்டார்கள்; அதற்கு பார்வோன்: “நீங்கள் யோசேப்பிடம் போய், அவன் உங்களுக்குச் சொல்லுகிறபடி செய்யுங்கள்” என்று எகிப்தியர்கள் எல்லோருக்கும் சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","தேசமெங்கும் பஞ்சம் உண்டானதால், யோசேப்பு களஞ்சியங்களையெல்லாம் திறந்து, எகிப்தியருக்கு விற்றான்; பஞ்சம் எகிப்துதேசத்தில் வரவர அதிகமானது. ");
INSERT INTO tam2017_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","அனைத்து தேசங்களிலும் பஞ்சம் அதிகமாக இருந்ததால், அனைத்து தேசத்தார்களும் யோசேப்பிடம் தானியம் வாங்க எகிப்திற்கு வந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","எகிப்திலே தானியம் உண்டென்று யாக்கோபு அறிந்து, தன் மகன்களை நோக்கி: “நீங்கள் ஒருவர் முகத்தை ஒருவர் பார்த்துக்கொண்டிருக்கிறது என்ன? ");
INSERT INTO tam2017_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","எகிப்திலே தானியம் உண்டென்று கேள்விப்படுகிறேன்; நாம் சாகாமல் உயிரோடிருக்க நீங்கள் அங்கே போய், நமக்காகத் தானியத்தை வாங்குங்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","யோசேப்பின் சகோதரர்கள் பத்துப்பேர் தானியம் வாங்க எகிப்திற்குப் போனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","யோசேப்பின் தம்பியாகிய பென்யமீனுக்கு ஏதோ தீங்கு வரும் என்று சொல்லி, யாக்கோபு அவனை அவனுடைய சகோதரர்களோடு அனுப்பவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","கானான் தேசத்திலே பஞ்சம் உண்டாயிருந்ததால், தானியம் வாங்கப்போகிறவர்களுடனேகூட இஸ்ரவேலின் மகன்களும் போனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","யோசேப்பு அந்த தேசத்திற்கு அதிபதியாயிருந்து, தேசத்தின் மக்கள் அனைவருக்கும் தானியத்தை விற்றான். யோசேப்பின் சகோதரர்கள் வந்து, முகங்குப்புறத் தரையிலே விழுந்து அவனை வணங்கினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","யோசேப்பு அவர்களைப் பார்த்து, தன் சகோதரர்கள் என்று தெரிந்துகொண்டான்; தெரிந்தும் தெரியாதவன்போலக் கடினமாக அவர்களோடு பேசி: “நீங்கள் எங்கேயிருந்து வந்தீர்கள்” என்று கேட்டான்; அதற்கு அவர்கள்: “கானான் தேசத்திலிருந்து தானியம் வாங்கவந்தோம்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","யோசேப்பு அவர்களைத் தன் சகோதரர்கள் என்று தெரிந்தும், அவர்களுக்கு அவனைத் தெரியவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","யோசேப்பு அவர்களைக் குறித்துத் தான் கண்ட கனவுகளை நினைத்து, அவர்களை நோக்கி: “நீங்கள் உளவாளிகள், தேசம் எங்கே திறந்துகிடக்கிறது என்று பார்க்க வந்தீர்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","அதற்கு அவர்கள்: “அப்படியல்ல, ஆண்டவனே, உமது அடியாராகிய நாங்கள் தானியம் வாங்க வந்தோம். ");
INSERT INTO tam2017_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","நாங்கள் எல்லோரும் ஒரு தகப்பனுடைய பிள்ளைகள்; நாங்கள் நேர்மையானவர்கள்; உமது அடியார் உளவாளிகள் அல்ல” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","அதற்கு அவன்: “அப்படியல்ல, தேசம் எங்கே திறந்துகிடக்கிறது என்று பார்க்கவே வந்தீர்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","அப்பொழுது அவர்கள்: “உமது அடியாராகிய நாங்கள் பன்னிரண்டு சகோதரர்கள்; கானான் தேசத்தில் இருக்கிற ஒரு தகப்பனுடைய பிள்ளைகள்; இளையவன் இப்பொழுது எங்கள் தகப்பனிடத்தில் இருக்கிறான்; ஒருவன் காணாமற்போனான்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","யோசேப்பு அவர்களை நோக்கி: “உங்களை உளவாளிகள் என்று நான் சொன்னது சரி. ");
INSERT INTO tam2017_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","உங்களுடைய இளைய சகோதரன் இங்கே வந்தாலொழிய நீங்கள் இங்கேயிருந்து புறப்படுவது இல்லை என்று பார்வோனின் ஜீவனைக்கொண்டு ஆணையிட்டுச் சொல்லுகிறேன். ");
INSERT INTO tam2017_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","இதனால் நீங்கள் சோதிக்கப்படுவீர்கள்; உங்கள் சகோதரனை அழைத்து வரும்படி உங்களில் ஒருவனை அனுப்புங்கள்; உங்களிடத்தில் உண்மை உண்டோ இல்லையோ என்று உங்கள் வார்த்தைகள் சோதிக்கப்படும்வரைக்கும், நீங்கள் காவலில் இருக்கவேண்டும்; இல்லாவிட்டால், நீங்கள் உளவாளிகள்தான் என்று பார்வோனின் ஜீவனைக்கொண்டு ஆணையிட்டுச் சொல்லுகிறேன் என்று சொல்லி, ");
INSERT INTO tam2017_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","அவர்கள் எல்லோரையும் மூன்றுநாட்கள் காவலிலே வைத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","மூன்றாம் நாளிலே யோசேப்பு அவர்களை நோக்கி: “நான் தேவனுக்குப் பயப்படுகிறவன்; நீங்கள் உயிரோடு இருக்க ஒன்று செய்யுங்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","நீங்கள் நேர்மையானவர்களானால், சகோதரர்களாகிய உங்களில் ஒருவன் காவலில் கட்டப்பட்டிருக்கட்டும்; மற்றவர்கள் புறப்பட்டு, பஞ்சத்தினால் வருந்துகிற உங்கள் குடும்பத்திற்குத் தானியம் கொண்டுபோய்க் கொடுத்து, ");
INSERT INTO tam2017_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","உங்கள் இளைய சகோதரனை என்னிடத்திற்கு அழைத்துக்கொண்டு வாருங்கள்; அப்பொழுது உங்கள் வார்த்தைகள் உண்மையென்று விளங்கும்; நீங்கள் சாவதில்லை” என்றான். அவர்கள் அப்படிச்செய்கிறதற்குச் சம்மதித்து: ");
INSERT INTO tam2017_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","நம்முடைய சகோதரனுக்கு நாம் செய்த துரோகம் நம்மேல் சுமந்தது; அவன் நம்மைக் கெஞ்சி வேண்டிக்கொண்டபோது, அவனுடைய மனவேதனையை நாம் கண்டும், அவன் சொல்லைக் கேட்காமற்போனோமே; ஆகையால் இந்த ஆபத்து நமக்கு நேரிட்டது” என்று ஒருவரை ஒருவர் பார்த்துச் சொல்லிக்கொண்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","அப்பொழுது ரூபன் அவர்களைப் பார்த்து: “இளைஞனுக்கு விரோதமாகப் பாவம் செய்யாதிருங்கள் என்று நான் உங்களுக்குச் சொல்லவில்லையா? நீங்கள் கேட்காமற்போனீர்கள்; இப்பொழுது, இதோ, அவனுடைய இரத்தப்பழி நம்மிடத்தில் வாங்கப்படுகிறது” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","யோசேப்பு மொழிபெயர்ப்பாளரைக்கொண்டு அவர்களிடத்தில் பேசியதால், தாங்கள் சொன்னது அவனுக்குத் தெரியும் என்று அறியாதிருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","அவன் அவர்களைவிட்டு அப்புறம்போய் அழுது, திரும்ப அவர்களிடத்திற்கு வந்து, அவர்களோடு பேசி, அவர்களில் சிமியோனைப் பிடித்து, அவர்களுடைய கண்களுக்கு முன்பாகக் கட்டிவைத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","பின்பு, அவர்கள் சாக்குகளைத் தானியத்தால் நிரப்பவும், அவர்களுடைய பணத்தைத் திரும்ப அவனவன் சாக்கிலே போடவும், பயணத்திற்குத் தேவையான ஆகாரத்தைக் கொடுக்கவும் யோசேப்பு கட்டளையிட்டான்; அப்படியே அவர்களுக்குச் செய்யப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","அவர்கள் அந்தத் தானியத்தைத் தங்கள் கழுதைகள்மேல் ஏற்றிக்கொண்டு, அந்த இடம்விட்டுப் புறப்பட்டுப்போனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","தங்குகிற இடத்திலே அவர்களில் ஒருவன் தன் கழுதைக்குத் தீவனம் போடத் தன் சாக்கைத் திறந்தபோது, சாக்கிலே தன் பணம் இருக்கிறதைக் கண்டு, ");
INSERT INTO tam2017_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","தன் சகோதரர்களைப் பார்த்து, “என் பணம் திரும்ப வந்திருக்கிறது; இதோ, அது என் சாக்கிலே இருக்கிறது என்றான். அப்பொழுது அவர்களுடைய இருதயம் சோர்ந்துபோய், அவர்கள் பயந்து, ஒருவரை ஒருவர் பார்த்து, “தேவன் நமக்கு இப்படிச் செய்தது” என்ன என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","அவர்கள் கானான் தேசத்திலுள்ள தங்கள் தகப்பனாகிய யாக்கோபிடம் வந்து, தங்களுக்குச் சம்பவித்தவைகளையெல்லாம் அவனுக்கு அறிவித்து: ");
INSERT INTO tam2017_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“தேசத்திற்கு அதிபதியாயிருக்கிறவன் எங்களை தேசத்தை உளவுபார்க்க வந்தவர்கள் என்று நினைத்து எங்களோடு கடினமாகப் பேசினான். ");
INSERT INTO tam2017_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","நாங்களோ அவனை நோக்கி: நாங்கள் நேர்மையானவர்கள், உளவாளிகள் அல்ல. ");
INSERT INTO tam2017_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","நாங்கள் பன்னிரண்டு சகோதரர்கள், ஒரு தகப்பனுடைய பிள்ளைகள், ஒருவன் காணாமற்போனான், இளையவன் இப்பொழுது கானான்தேசத்தில் எங்கள் தகப்பனிடத்தில் இருக்கிறான்” என்றோம். ");
INSERT INTO tam2017_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","அப்பொழுது தேசத்தின் அதிபதியானவன்: நீங்கள் நேர்மையானவர்கள் என்பதை நான் அறியும்படி உங்கள் சகோதரர்களில் ஒருவனை நீங்கள் என்னிடத்தில் விட்டு, பஞ்சத்தினால் வருந்துகிற உங்கள் குடும்பத்திற்குத் தானியம் வாங்கிக்கொண்டுபோய்க் கொடுத்து, ");
INSERT INTO tam2017_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","உங்கள் இளைய சகோதரனை என்னிடத்தில் அழைத்துக்கொண்டு வாருங்கள்; அதனால் நீங்கள் உளவாளிகள் அல்ல, நேர்மையானவர்கள் என்பதை நான் அறிந்துகொண்டு, உங்கள் சகோதரனை விடுதலை செய்வேன்; நீங்கள் இந்தத் தேசத்திலே வியாபாரமும் செய்யலாம் என்றான் என்று சொன்னார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","அவர்கள் தங்கள் சாக்குகளிலுள்ள தானியத்தைக் கொட்டும்போது, இதோ, அவனவன் சாக்கிலே அவனவன் பணமுடிப்பு இருந்தது; அந்த பணமுடிப்புகளை அவர்களும் அவர்கள் தகப்பனும் கண்டு பயந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","அவர்கள் தகப்பனாகிய யாக்கோபு அவர்களை நோக்கி: “என்னைப் பிள்ளையற்றவனாக்குகிறீர்கள்; யோசேப்பும் இல்லை, சிமியோனும் இல்லை; பென்யமீனையும் கொண்டுபோகப் பார்க்கிறீர்கள்; இதெல்லாம் எனக்கு விரோதமாக நேரிடுகிறது” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","அப்பொழுது ரூபன் தன் தகப்பனைப் பார்த்து, “அவனை என் கையில் ஒப்புவியும், நான் அவனைத் திரும்ப உம்மிடத்தில் கொண்டுவருவேன்; அவனைக் கொண்டுவராவிட்டால், என் இரண்டு மகன்களையும் கொன்றுபோடும்” என்று சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","அதற்கு அவன்: “என் மகன் உங்களோடுகூடப் போவதில்லை; இவனுடைய அண்ணன் இறந்துபோனான், இவன் ஒருவன் மீதியாயிருக்கிறான்; நீங்கள் போகும் வழியில் இவனுக்குத் தீங்கு நேரிட்டால், நீங்கள் என் நரைமுடியைச் சஞ்சலத்தோடு பாதாளத்தில் இறங்கச்செய்வீர்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","தேசத்திலே பஞ்சம் கொடிதாயிருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","எகிப்திலிருந்து அவர்கள் கொண்டுவந்த தானியம் செலவழிந்தபோது, அவர்களுடைய தகப்பன் அவர்களை நோக்கி: “நீங்கள் திரும்பப் போய், நமக்குக் கொஞ்சம் தானியம் வாங்கிக்கொண்டு வாருங்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","அதற்கு யூதா: “உங்கள் சகோதரன் உங்களோடுகூட வராவிட்டால், நீங்கள் என் முகத்தைக் காண்பதில்லை என்று அந்த மனிதன் எங்களுக்குக் கண்டிப்பாகச் சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","எங்கள் சகோதரனை நீர் எங்களோடுகூட அனுப்பினால், நாங்கள் போய், உமக்குத் தானியம் வாங்கிக்கொண்டு வருவோம். ");
INSERT INTO tam2017_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","அனுப்பாவிட்டால். நாங்கள் போகமாட்டோம்; உங்கள் சகோதரன் உங்களோடுகூட வராவிட்டால், நீங்கள் என் முகத்தைக் காண்பதில்லை என்று அந்த மனிதன் எங்களோடு சொல்லியிருக்கிறான்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","அதற்கு இஸ்ரவேல்: “உங்களுக்கு இன்னும் ஒரு சகோதரன் உண்டென்று நீங்கள் அந்த மனிதனுக்குச் சொல்லி, ஏன் எனக்கு இந்தத் துன்பத்தை வருவித்தீர்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","அதற்கு அவர்கள்: “அந்த மனிதன், உங்கள் தகப்பன் இன்னும் உயிரோடிருக்கிறாரா? உங்களுக்கு இன்னும் ஒரு சகோதரன் உண்டா? என்று எங்களையும் எங்களுடைய வம்சத்தையும் குறித்து விபரமாக விசாரித்தான்; அந்தக் கேள்விகளுக்குத் தக்கதாக உள்ளபடி அவனுக்குச் சொன்னோம்; உங்கள் சகோதரனை உங்களோடுகூட இங்கே கொண்டுவாருங்கள் என்று அவன் சொல்லுவான் என்பதை நாங்கள் அறிந்திருந்தோமா” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","பின்னும், யூதா தன் தகப்பனாகிய இஸ்ரவேலை நோக்கி: “நீரும் நாங்களும் எங்களுடைய குழந்தைகளும் சாகாமல் உயிரோடிருக்க, நாங்கள் புறப்பட்டுப்போகிறோம், இளைய மகனை என்னோடு அனுப்பும். ");
INSERT INTO tam2017_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","அவனுக்காக நான் உத்திரவாதம் செய்வேன்; அவனை என்னிடத்திலே கேளும், நான் அவனை உம்மிடத்தில் கொண்டுவந்து, உமக்கு முன்பாக நிறுத்தாமற்போனால், எந்நாளும் அந்தக் குற்றம் என்மேல் இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","நாங்கள் தாமதிக்காமல் இருந்தோமானால், இதற்குள்ளே இரண்டுமுறை போய்த் திரும்பி வந்திருப்போமே” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","அதற்கு அவர்கள் தகப்பனாகிய இஸ்ரவேல்: அப்படியானால், ஒன்று செய்யுங்கள்; இந்த தேசத்தின் விலையுயர்ந்த பொருட்களில் கொஞ்சம் பிசின் தைலமும், கொஞ்சம் தேனும், கந்தவர்க்கங்களும், வெள்ளைப்போளமும், தெரபிந்து கொட்டைகளும், வாதுமைக்கொட்டைகளும் உங்கள் சாக்குகளில் போட்டு, அந்த மனிதனுக்குக் காணிக்கையாகக் கொண்டுபோய்க் கொடுங்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","பணத்தை இருமடங்கு உங்கள் கைகளில் கொண்டுபோங்கள், சாக்குகளின் வாயிலே திரும்பக் கொண்டுவந்த பணத்தையும் கொண்டுபோங்கள்; அது கை தவறி வந்திருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","உங்கள் சகோதரனையும் கூட்டிக்கொண்டு, அந்த மனிதனிடத்திற்கு மறுபடியும் போங்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","அந்த மனிதன், அங்கிருக்கிற உங்கள் மற்ற சகோதரனையும் பென்யமீனையும் உங்களுடனே அனுப்பிவிட, சர்வவல்லமையுள்ள தேவன் அவனுடைய சமுகத்தில் உங்களுக்கு இரக்கம் கிடைக்கச் செய்வாராக; நானோ பிள்ளையில்லாதவனைப்போல் இருப்பேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","அப்பொழுது அவர்கள் காணிக்கையையும் தங்கள் கைகளில் இருமடங்கு பணத்தையும் எடுத்துக்கொண்டு, பென்யமீனையும் கூட்டிக்கொண்டு, பயணப்பட்டு, எகிப்திற்குப்போய், யோசேப்புக்கு முன்பாக வந்து நின்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","பென்யமீன் அவர்களோடுகூட வந்திருக்கிறதை யோசேப்பு கண்டு, தன் வீட்டு விசாரணைக்காரனை நோக்கி: “நீ இந்த மனிதர்களை வீட்டிற்கு அழைத்துப்போய், சாப்பாட்டுக்கு வேண்டியவைகளை அடித்து, ஆயத்தம்செய், மத்தியானத்திலே இந்த மனிதர்கள் என்னோடு சாப்பிடுவார்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","அவன் தனக்கு யோசேப்பு சொன்னபடியே செய்து, அந்த மனிதர்களை யோசேப்பின் வீட்டிற்கு அழைத்துக்கொண்டு போனான். ");
INSERT INTO tam2017_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","தாங்கள் யோசேப்பின் வீட்டிற்குக் கொண்டுபோகப்படுகிறதை அவர்கள் கண்டு பயந்து, “முன்னே நம்முடைய சாக்குகளில் இருந்த பணத்திற்காக நம்மேல் குற்றம் சுமத்தி, நம்மைப் பிடித்துச் சிறைகளாக்கி, நம்முடைய கழுதைகளை எடுத்துக்கொள்ள நம்மைக்கொண்டுபோகிறார்கள்” என்று சொல்லி, ");
INSERT INTO tam2017_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","யோசேப்பின் வீட்டு விசாரணைக்காரனிடம் வந்து, வீட்டு வாசற்படியிலே அவனோடு பேசி: ");
INSERT INTO tam2017_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“ஆண்டவனே, நாங்கள் தானியம் வாங்க முன்னே வந்துபோனோமே; ");
INSERT INTO tam2017_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","நாங்கள் தங்கும் இடத்தில் போய் எங்களுடைய சாக்குகளைத் திறந்தபோது, நாங்கள் நிறுத்துக்கொடுத்த நிறையின்படியே அவனவன் பணம் அவனவன் சாக்கிலே இருந்ததைக் கண்டோம்; அதை நாங்கள் திரும்பவும் கொண்டுவந்திருக்கிறோம். ");
INSERT INTO tam2017_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","மேலும், தானியம் வாங்க வேறே பணமும் கொண்டு வந்திருக்கிறோம்; நாங்கள் முன் கொடுத்த பணத்தை எங்களுடைய சாக்குகளில் போட்டது யாரென்று அறியோம்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","அதற்கு அவன்: “உங்களுக்குச் சமாதானம்; பயப்படவேண்டாம்; உங்கள் தேவனும் உங்கள் தகப்பனுடைய தேவனுமாயிருக்கிறவர் உங்கள் சாக்குகளில் அதை உங்களுக்குப் புதையலாகக் கட்டளையிட்டார்; நீங்கள் கொடுத்த பணம் என்னிடத்தில் வந்து சேர்ந்தது” என்று சொல்லி, சிமியோனை வெளியே அழைத்து வந்து, அவர்களிடத்தில் விட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","மேலும், அந்த மனிதன் அவர்களை யோசேப்பின் வீட்டிற்குள்ளே கூட்டிக்கொண்டுபோய், அவர்கள் தங்கள் கால்களைக் கழுவும்படி தண்ணீர் கொடுத்து, அவர்களுடைய கழுதைகளுக்குத் தீவனம் போட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","தாங்கள் அங்கே சாப்பிடப்போகிறதை அவர்கள் கேள்விப்பட்டதால், மத்தியானத்தில் யோசேப்பு வரும்வரை காணிக்கையை ஆயத்தமாக வைத்துக் காத்துக்கொண்டிருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","யோசேப்பு வீட்டிற்கு வந்தபோது, அவர்கள் தங்கள் கையில் இருந்த காணிக்கையை வீட்டிற்குள் அவனிடத்தில் கொண்டுபோய் வைத்து, தரைவரைக்கும் குனிந்து, அவனை வணங்கினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","அப்பொழுது அவன்: “அவர்கள் சுகசெய்தியை விசாரித்து, நீங்கள் சொன்ன முதிர்வயதான உங்கள் தகப்பன் சுகமாயிருக்கிறாரா? அவர் இன்னும் உயிரோடிருக்கிறாரா”? என்று அவர்களிடத்தில் விசாரித்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","அதற்கு அவர்கள்: “எங்கள் தகப்பனாராகிய உமது அடியான் சுகமாயிருக்கிறார், இன்னும் உயிரோடிருக்கிறார்” என்று சொல்லி, குனிந்து வணங்கினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","அவன் தன் கண்களை ஏறெடுத்து, தன் தாய் பெற்ற மகனாகிய தன் சகோதரன் பென்யமீனைக் கண்டு, “நீங்கள் எனக்குச் சொன்ன உங்கள் இளைய சகோதரன் இவன்தானா என்று கேட்டு, மகனே, தேவன் உனக்குக் கிருபை செய்யக்கடவர்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","யோசேப்பின் உள்ளம் தன் சகோதரனுக்காகப் பொங்கினதால், அவன் அழுகிறதற்கு இடம் தேடி, வேகமாக அறைக்குள்ளே போய், அங்கே அழுதான். ");
INSERT INTO tam2017_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","பின்பு, அவன் தன் முகத்தைக் கழுவி வெளியே வந்து, தன்னை அடக்கிக்கொண்டு, “உணவு வையுங்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","எகிப்தியர்கள் எபிரெயரோடு சாப்பிடமாட்டார்கள்; அப்படிச் செய்வது எகிப்தியருக்கு அருவருப்பாயிருக்கும்; ஆகையால், அவனுக்குத் தனியாகவும், அவர்களுக்குத் தனியாகவும், அவனோடு சாப்பிடுகிற எகிப்தியருக்குத் தனியாகவும் வைத்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","அவனுக்கு முன்பாக, மூத்தவன்முதல் இளையவன்வரைக்கும் அவனவன் வயதின்படியே அவர்களை உட்காரவைத்தார்கள்; அதற்காக அவர்கள், ஒருவரை ஒருவர் பார்த்து ஆச்சரியப்பட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","அவன் தனக்குமுன் வைக்கப்பட்டிருந்த உணவில் அவர்களுக்குப் பங்கிட்டு அனுப்பினான்; அவர்கள் எல்லோருடைய பங்குகளைவிட பென்யமீனுடைய பங்கு ஐந்துமடங்கு அதிகமாயிருந்தது; அவர்கள் குடித்து, அவனோடு சந்தோஷமாயிருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","பின்பு, அவன் தன் வீட்டு விசாரணைக்காரனை நோக்கி: “நீ இந்த மனிதர்களுடைய சாக்குகளை அவர்கள் ஏற்றிக்கொண்டுபோகத்தக்க பாரமாகத் தானியத்தினாலே நிரப்பி, அவனவன் பணத்தை அவனவன் சாக்கிலே போட்டு, ");
INSERT INTO tam2017_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","இளையவனுடைய சாக்கிலே வெள்ளிப் பாத்திரமாகிய என் பானபாத்திரத்தையும் தானியத்திற்கு அவன் கொடுத்த பணத்தையும் போடு” என்று கட்டளையிட்டான்; யோசேப்பு சொன்னபடியே அவன் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","அதிகாலையிலே அந்த மனிதர்கள் தங்கள் கழுதைகளை ஓட்டிக்கொண்டுபோகும்படி அனுப்பிவிடப்பட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","அவர்கள் பட்டணத்தைவிட்டுப் புறப்பட்டு, வெகுதூரம் போவதற்கு முன்னே, யோசேப்பு தன் வீட்டு விசாரணைக்காரனை நோக்கி: “நீ புறப்பட்டுப்போய், அந்த மனிதர்களைப் பின்தொடர்ந்து, அவர்களைப் பிடித்து: நீங்கள் நன்மைக்குத் தீமை செய்தது என்ன? ");
INSERT INTO tam2017_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","அது என் எஜமான் பானம்பண்ணுகிற பாத்திரம் அல்லவா? அது போனவிதம் ஞானபார்வையினால் அவருக்குத் தெரியாதா? நீங்கள் செய்தது தகாதகாரியம் என்று அவர்களிடம் சொல்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","அவன் அவர்களைத் தொடர்ந்து பிடித்து, தன்னிடத்தில் சொல்லியிருந்த வார்த்தைகளை அவர்களுக்குச் சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","அதற்கு அவர்கள்: “எங்கள் ஆண்டவன் இப்படிப்பட்ட வார்த்தைகளைச் சொல்லுகிறது என்ன? இப்படிப்பட்ட காரியத்திற்கும் உம்முடைய அடியாராகிய எங்களுக்கும் வெகுதூரம். ");
INSERT INTO tam2017_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","எங்களுடைய சாக்குகளிலே நாங்கள் கண்ட பணத்தைக் கானான்தேசத்திலிருந்து திரும்பவும் உம்மிடத்திற்குக் கொண்டுவந்தோமே; நாங்கள் உம்முடைய எஜமானின் வீட்டிலிருந்து வெள்ளியையாகிலும், பொன்னையாகிலும் திருடிக்கொண்டு போவோமா? ");
INSERT INTO tam2017_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","உம்முடைய அடியாருக்குள்ளே அது எவனிடத்தில் காணப்படுமோ அவன் கொலை செய்யப்படுவானாக; நாங்களும் எங்கள் ஆண்டவனுக்கு அடிமைகளாவோம்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","அதற்கு அவன்: “நீங்கள் சொன்னபடியே ஆகட்டும்; எவனிடத்தில் அது காணப்படுமோ, அவன் எனக்கு அடிமையாவான்; நீங்கள் குற்றமில்லாதிருப்பீர்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","அப்பொழுது அவர்கள் வேகமாக அவனவன் தன்தன் சாக்கைத் தரையிலே இறக்கி, தங்கள் சாக்குகளைத் திறந்து வைத்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","மூத்தவன் சாக்குமுதல் இளையவன் சாக்குவரை அவன் சோதிக்கும்போது, அந்தப் பாத்திரம் பென்யமீனுடைய சாக்கிலே கண்டுபிடிக்கப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","அப்பொழுது அவர்கள் தங்கள் உடைகளைக் கிழித்துக்கொண்டு, அவனவன் கழுதையின்மேல் மூட்டையை ஏற்றிக்கொண்டு, பட்டணத்திற்குத் திரும்பினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","யூதாவும் அவனுடைய சகோதரர்களும் யோசேப்பின் வீட்டிற்குப் போனார்கள். யோசேப்பு அதுவரைக்கும் அங்கே இருந்தான்; அவனுக்கு முன்பாகத் தரையிலே விழுந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","யோசேப்பு அவர்களை நோக்கி: “நீங்கள் என்ன காரியம் செய்தீர்கள்? என்னைப் போன்ற மனிதனுக்கு ஞானப்பார்வையினால் காரியம் தெரியவரும் என்று அறியாமற்போனீர்களா” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","அதற்கு யூதா: “என் ஆண்டவனாகிய உம்மிடத்தில் நாங்கள் என்ன சொல்லுவோம்? எதைப் பேசுவோம்? எதினாலே எங்களுடைய நீதியை விளங்கச்செய்வோம்? உம்முடைய அடியாரின் அக்கிரமத்தை தேவன் விளங்கச்செய்தார்; பாத்திரத்தை வைத்திருக்கிறவனும் நாங்களும் என் ஆண்டவனுக்கு அடிமைகள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","அதற்கு அவன்: “அப்படிப்பட்ட செயல் எனக்குத் தூரமாயிருப்பதாக; யாரிடத்தில் பாத்திரம் கண்டுபிடிக்கப்பட்டதோ, அவனே எனக்கு அடிமையாயிருப்பான்; நீங்களோ சமாதானத்தோடு உங்கள் தகப்பனிடத்திற்குப் போங்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","அப்பொழுது யூதா அவனருகில் வந்து: “ஆ, என் ஆண்டவனே, உமது அடியேன் உம்முடைய செவிகள் கேட்க ஒரு வார்த்தை சொல்லுகிறேன் கேட்பீராக; அடியேன்மேல் உமது கோபம் வராதிருப்பதாக; நீர் பார்வோனுக்கு ஒப்பாயிருக்கிறீர். ");
INSERT INTO tam2017_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","உங்களுக்குத் தகப்பனாவது சகோதரனாவது உண்டா என்று என் ஆண்டவன் உம்முடைய அடியாரிடத்தில் கேட்டீர். ");
INSERT INTO tam2017_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","அதற்கு நாங்கள்: எங்களுக்கு முதிர்வயதுள்ள தகப்பனாரும், அவருக்கு முதிர்வயதிலே பிறந்த ஒரு இளைஞனும் உண்டு என்றும், அவனுடைய அண்ணன் இறந்துபோனான் என்றும், அவன் ஒருவன்மாத்திரமே அவனைப்பெற்ற தாயாருக்கு இருப்பதால் தகப்பனார் அவன்மேல் பாசமாயிருக்கிறார் என்றும் என் ஆண்டவனுக்குச் சொன்னோம். ");
INSERT INTO tam2017_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","அப்பொழுது நீர்: அவனை என்னிடத்திற்குக் கொண்டுவாருங்கள்; என் கண்களினால் அவனைப் பார்க்கவேண்டும் என்று உமது அடியாருக்குச் சொன்னீர். ");
INSERT INTO tam2017_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","நாங்கள் ஆண்டவனை நோக்கி: அந்த இளைஞன் தன் தகப்பனைவிட்டுப் பிரியக்கூடாது, பிரிந்தால் அவர் இறந்துபோவார் என்று சொன்னோம். ");
INSERT INTO tam2017_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","அதற்கு நீர்: உங்கள் இளைய சகோதரனைக் கொண்டுவராவிட்டால், நீங்கள் இனி என் முகத்தைக் காண்பதில்லை என்று உமது அடியாருக்குச் சொன்னீர். ");
INSERT INTO tam2017_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","நாங்கள் உமது அடியானாகிய என் தகப்பனாரிடத்திற்குப் போனபோது, என் ஆண்டவனுடைய வார்த்தைகளை அவருக்குத் தெரிவித்தோம். ");
INSERT INTO tam2017_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","எங்களுடைய தகப்பனார் எங்களை நோக்கி: நீங்கள் திரும்பப்போய், நமக்குக் கொஞ்சம் தானியம் வாங்குங்கள் என்று சொன்னார். ");
INSERT INTO tam2017_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","அதற்கு: நாங்கள் போகக்கூடாது; எங்கள் இளைய சகோதரன் எங்களோடு வந்தால் போவோம்; எங்கள் இளைய சகோதரன் எங்களோடு வராவிட்டால், நாங்கள் அந்த மனிதனுடைய முகத்தைக் காணமுடியாது என்றோம். ");
INSERT INTO tam2017_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","அப்பொழுது உம்முடைய அடியானாகிய என் தகப்பனார்: என் மனைவி எனக்கு இரண்டு பிள்ளைகளைப் பெற்றெடுத்தாள்; ");
INSERT INTO tam2017_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","அவர்களில் ஒருவன் என்னிடத்திலிருந்து போய்விட்டான், அவன் கிழிக்கப்பட்டிருப்பான் என்றிருந்தேன், இதுவரைக்கும் அவனைக் காணாதிருக்கிறேன், இதெல்லாம் நீங்கள் அறிந்திருக்கிறீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","நீங்கள் இவனையும் என்னை விட்டுப்பிரித்து அழைத்துப்போகுமிடத்தில் இவனுக்குத் தீங்கு நேரிட்டால், என் நரைமுடியை வியாகுலத்தோடு பாதாளத்தில் இறங்கச் செய்வீர்கள் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","ஆகையால் இளையவனைவிட்டு, நான் என் தகப்பனாகிய உமது அடியானிடத்திற்குப் போனால், அவருடைய ஜீவன் இவனுடைய ஜீவனோடு ஒன்றாக இணைந்திருப்பதால், ");
INSERT INTO tam2017_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","அவர் இளையவன் வரவில்லை என்று அறிந்தமாத்திரத்தில் இறந்துபோவார்; இப்படி உமது அடியாராகிய நாங்கள் உமது அடியானாகிய எங்கள் தகப்பனுடைய நரைமுடியை மனதுக்கத்துடனே பாதாளத்தில் இறங்கச்செய்வோம். ");
INSERT INTO tam2017_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","இந்த இளையவனுக்காக உமது அடியானாகிய நான் என் தகப்பனுக்கு உத்திரவாதி; மேலும், நான் இவனை உம்மிடத்திற்குக் கொண்டுவராவிட்டால், நான் எந்நாளும் உமக்கு முன்பாகக் குற்றவாளியாயிருப்பேன் என்று அவருக்குச் சொல்லியிருக்கிறேன். ");
INSERT INTO tam2017_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","இப்படியிருக்க, இளையவன் தன் சகோதரர்களோடுகூடப் போகவிடும்படி மன்றாடுகிறேன்; உம்முடைய அடியானாகிய நான் இளையவனுக்குப் பதிலாக இங்கே என் ஆண்டவனுக்கு அடிமையாக இருக்கிறேன். ");
INSERT INTO tam2017_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","இளையவனைவிட்டு, எப்படி என் தகப்பனிடத்திற்குப் போவேன்? போனால் என் தகப்பனுக்கு நேரிடும் தீங்கை நான் எப்படிக் காண்பேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","அப்பொழுது யோசேப்பு தன் அருகே நின்ற எல்லா வேலைக்காரர்களுக்கும் முன்பாகத் தன்னை அடக்கிக்கொண்டிருக்கமுடியாமல்: அனைவரையும் என்னைவிட்டு வெளியே போகச்செய்யுங்கள் என்று கட்டளையிட்டான். யோசேப்பு தன் சகோதரர்களுக்குத் தன்னை வெளிப்படுத்தும்போது, ஒருவரும் அவன் அருகில் நிற்கவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","அவன் சத்தமிட்டு அழுதான்; அதை எகிப்தியர்கள் கேட்டார்கள், பார்வோனின் வீட்டாரும் கேட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","யோசேப்பு தன் சகோதரர்களைப்பார்த்து: நான் யோசேப்பு; என் தகப்பனார் இன்னும் உயிரோடு இருக்கிறாரா என்றான். அவனுடைய சகோதரர்கள் அவனுக்கு முன்பாகக் கலக்கமடைந்திருந்ததினாலே, அவனுக்கு பதில் சொல்லமுடியாமல் இருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","அப்பொழுது யோசேப்பு தன் சகோதரர்களை நோக்கி: என்னருகில் வாருங்கள் என்றான். அவர்கள் அருகில்போனார்கள்; அப்பொழுது அவன்: நீங்கள் எகிப்திற்குப் போகிறவர்களிடத்தில் விற்றுப்போட்ட உங்கள் சகோதரனாகிய யோசேப்பு நான்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","என்னை இந்த இடத்திற்கு வருவதற்காக விற்றுப்போட்டதினால், நீங்கள் வருத்தப்படவேண்டாம்; அது உங்களுக்கு விசனமாயிருக்கவும் வேண்டாம்; உயிர்களைப் பாதுகாக்க தேவன் என்னை உங்களுக்கு முன்னே அனுப்பினார். ");
INSERT INTO tam2017_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","தேசத்தில் இப்பொழுது இரண்டு வருடங்களாகப் பஞ்சம் உண்டாயிருக்கிறது; இன்னும் ஐந்து வருடங்கள் விதைப்பும் அறுப்பும் இல்லாமல் பஞ்சம் இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","பூமியிலே உங்கள் வம்சம் அழியாமலிருக்க உங்களை ஆதரிப்பதற்காகவும், பெரிய ரட்சிப்பினால் உங்களை உயிரோடு காப்பதற்காகவும் தேவன் என்னை உங்களுக்கு முன்னே அனுப்பினார். ");
INSERT INTO tam2017_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","ஆதலால் நீங்கள் அல்ல, தேவனே என்னை இந்த இடத்திற்கு அனுப்பி, என்னைப் பார்வோனுக்குத் தகப்பனாகவும், அவருடைய குடும்பம் அனைத்திற்கும் கர்த்தனாகவும், முழு எகிப்துதேசத்திற்கும் அதிபதியாகவும் வைத்தார். ");
INSERT INTO tam2017_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","நீங்கள் சீக்கிரமாக என் தகப்பனிடத்தில் போய்: தேவன் என்னை எகிப்துதேசம் முழுவதிற்கும் அதிபதியாக வைத்தார்; என்னிடத்தில் வாரும், தாமதிக்க வேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","நீரும், உம்முடைய பிள்ளைகளும், அவர்களுடைய பிள்ளைகளும், உம்முடைய ஆடுமாடுகளோடும் உமக்கு உண்டாயிருக்கிற எல்லாவற்றோடும் கோசேன் நாட்டில் குடியிருந்து என் அருகில் இருக்கலாம். ");
INSERT INTO tam2017_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","உமக்கும் உம்முடைய குடும்பத்தாருக்கும் உமக்கு இருக்கிற எல்லாவற்றிற்கும் வறுமை வராதபடி, அங்கே உம்மைப் பராமரிப்பேன்; இன்னும் ஐந்து வருடங்கள் பஞ்சம் இருக்கும் என்று, உம்முடைய மகனாகிய யோசேப்பு சொல்லச்சொன்னான் என்று சொல்லுங்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","இதோ, உங்களோடு பேசுகிற வாய் என் வாய்தான் என்பதை உங்கள் கண்களும் என் தம்பியாகிய பென்யமீனின் கண்களும் காண்கிறதே. ");
INSERT INTO tam2017_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","எகிப்திலே எனக்கு உண்டாயிருக்கிற அனைத்து மகிமையையும், நீங்கள் கண்ட எல்லாவற்றையும் என் தகப்பனுக்கு அறிவித்து, அவர் சீக்கிரமாக இந்த இடத்திற்கு வரும்படிச் செய்யுங்கள் என்று சொல்லி; ");
INSERT INTO tam2017_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","தன் தம்பியாகிய பென்யமீனின் கழுத்தைக் கட்டிக்கொண்டு அழுதான்; பென்யமீனும் அவனுடைய கழுத்தைக் கட்டிக்கொண்டு அழுதான். ");
INSERT INTO tam2017_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","பின்பு தன் சகோதரர்கள் அனைவரையும் முத்தம்செய்து, அவர்களையும் கட்டிக்கொண்டு அழுதான். அதற்குப்பின் அவனுடைய சகோதரர்கள் அவனோடு உரையாடினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","யோசேப்பின் சகோதரர்கள் வந்தார்கள் என்ற செய்தி பார்வோன் அரண்மனையில் பரவியபோது, பார்வோனும் அவனுடைய ஊழியக்காரரும் சந்தோஷம் அடைந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","பார்வோன் யோசேப்பை நோக்கி: நீ உன் சகோதரர்களோடு சொல்லவேண்டியது என்னவென்றால்: உங்கள் கழுதைகளின்மேல் பாரமேற்றிக்கொண்டு புறப்பட்டு, கானான்தேசத்திற்குப் போய், ");
INSERT INTO tam2017_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","உங்கள் தகப்பனையும் உங்கள் குடும்பத்தாரையும் கூட்டிக்கொண்டு, என்னிடத்தில் வாருங்கள், நான் உங்களுக்கு எகிப்துதேசத்தின் நன்மையைத் தருவேன்; தேசத்தின் கொழுமையைச் சாப்பிடுவீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","நீங்கள் உங்கள் குழந்தைகளுக்காகவும் உங்கள் மனைவிகளுக்காகவும் வண்டிகளை எகிப்துதேசத்திலிருந்து கொண்டுபோய், அவர்களையும் உங்கள் தகப்பனுடனே ஏற்றிக்கொண்டு வாருங்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","உங்கள் வீட்டு உபயோகப்பொருட்களைக் குறித்துக் கவலைப்படவேண்டாம்; எகிப்துதேசமெங்குமுள்ள நன்மை உங்களுடையதாயிருக்கும் என்று சொல்லச் சொல்லி, உனக்கு நான் கொடுத்த கட்டளையின்படியே செய் என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","இஸ்ரவேலின் மகன்கள் அப்படியே செய்தார்கள், யோசேப்பு பார்வோனுடைய கட்டளையின்படியே அவர்களுக்கு வண்டிகளைக் கொடுத்ததுமன்றி, பயணத்திற்கு ஆகாரத்தையும், ");
INSERT INTO tam2017_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","அவர்களில் ஒவ்வொருவனுக்கும் மாற்று உடைகளையும் கொடுத்தான்; பென்யமீனுக்கோ முந்நூறு வெள்ளிக்காசையும் ஐந்து மாற்று உடைகளையும் கொடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","அப்படியே தன் தகப்பனுக்குப் பத்துக் கழுதைகளின்மேல் எகிப்தின் சிறப்பான பதார்த்தங்களும், பத்து கழுதைகளின்மேல் தன் தகப்பனுக்காக பயணத்திற்குத் தானியமும் அப்பமும் மற்றத் தின்பண்டங்களும் ஏற்றி அனுப்பினான். ");
INSERT INTO tam2017_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","மேலும், நீங்கள் போகும் வழியிலே சண்டையிட்டுக்கொள்ளாதிருங்கள் என்று அவன் தன் சகோதரர்களுக்குச் சொல்லி அனுப்பினான்; அவர்கள் புறப்பட்டுப்போனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","அவர்கள் எகிப்திலிருந்து போய், கானான்தேசத்திலே தங்கள் தகப்பனாகிய யாக்கோபினிடத்திற்கு வந்து: ");
INSERT INTO tam2017_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","யோசேப்பு உயிரோடிருக்கிறான், அவன் எகிப்துதேசத்திற்கெல்லாம் அதிபதியாக இருக்கிறான் என்று அவனுக்குத் தெரிவித்தார்கள். அவனுடைய இருதயம் அதிர்ச்சி அடைந்தது; அவன் அவர்களை நம்பவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","அவர்கள் யோசேப்பு தங்களுடனே சொன்ன வார்த்தைகள் எல்லாவற்றையும் அவனுக்குச் சொன்னபோதும், தன்னை ஏற்றிக்கொண்டு போகும்படி யோசேப்பு அனுப்பின வண்டிகளை அவன் கண்டபோதும், அவர்களுடைய தகப்பனாகிய யாக்கோபின் ஆவி உயிர்த்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","அப்பொழுது இஸ்ரவேல்: என் மகனாகிய யோசேப்பு இன்னும் உயிரோடிருக்கிறானே, இது போதும்; நான் மரணமடையுமுன்னே போய் அவனைப் பார்ப்பேன் என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","இஸ்ரவேல் தனக்கு உண்டான எல்லாவற்றையும் சேர்த்துக்கொண்டு புறப்பட்டுப் பெயெர்செபாவுக்குப் போய், தன் தகப்பனாகிய ஈசாக்குடைய தேவனுக்குப் பலியிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","அன்று இரவிலே தேவன் இஸ்ரவேலுக்குக் காட்சியளித்து: “யாக்கோபே, யாக்கோபே” என்று கூப்பிட்டார்; அவன் இதோ, “அடியேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","அப்பொழுது அவர்: “நான் தேவன், நான் உன் தகப்பனுடைய தேவன்; நீ எகிப்துதேசத்திற்குப்போகப் பயப்படவேண்டாம்; அங்கே உன்னைப் பெரிய தேசமாக்குவேன். ");
INSERT INTO tam2017_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","நான் உன்னுடனே எகிப்திற்கு வருவேன்; நான் உன்னைத் திரும்பவும் வரச்செய்வேன்; யோசேப்பு தன் கையால் உன் கண்களை மூடுவான்” என்று சொன்னார். ");
INSERT INTO tam2017_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","அதற்குப்பின்பு, யாக்கோபு பெயெர்செபாவிலிருந்து புறப்பட்டான். இஸ்ரவேலின் மகன்கள் தங்களுடைய தகப்பனாகிய யாக்கோபையும், குழந்தைகளையும், மனைவிகளையும் பார்வோன் அனுப்பின வண்டிகளின்மேல் ஏற்றிக்கொண்டு, ");
INSERT INTO tam2017_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","தங்கள் ஆடுமாடுகளையும் தாங்கள் கானான் தேசத்தில் சம்பாதித்த தங்கள் பொருட்களையும் சேர்த்துக்கொண்டு, யாக்கோபும் அவனுடைய சந்ததியினர் அனைவரும் எகிப்திற்குப் போனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","அவன் தன் மகன்களையும் தன் மகன்களின் மகன்களையும் தன் மகள்களையும் தன் மகன்களின் மகள்களையும் தன் சந்ததியார் அனைவரையும் எகிப்திற்குத் தன்னுடன் அழைத்துக்கொண்டுபோனான். ");
INSERT INTO tam2017_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","எகிப்திற்கு வந்த இஸ்ரவேலரின் பெயர்களாவன: யாக்கோபும் அவனுடைய மகன்களும்; யாக்கோபுடைய மூத்தமகனான ரூபன். ");
INSERT INTO tam2017_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ரூபனுடைய மகன்கள் ஆனோக்கு, பல்லூ, எஸ்ரோன், கர்மீ என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","சிமியோனுடைய மகன்கள் எமுவேல், யாமின், ஓகாத், யாகீன், சொகார், கானானிய பெண்ணின் மகனாகிய சவுல் என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","லேவியினுடைய மகன்கள் கெர்சோன், கோகாத், மெராரி என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","யூதாவினுடைய மகன்கள் ஏர், ஓனான், சேலா, பாரேஸ், சேரா என்பவர்கள்; அவர்களில் ஏரும் ஓனானும் கானான்தேசத்தில் இறந்துபோனார்கள்; பாரேசுடைய மகன்கள் எஸ்ரோன், ஆமூல் என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","இசக்காருடைய மகன்கள் தோலா, பூவா, யோபு, சிம்ரோன் என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","செபுலோனுடைய மகன்கள் சேரேத், ஏலோன், யக்லேல் என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","இவர்கள் லேயாளின் சந்ததியார்; அவள் இவர்களையும் தீனாள் என்னும் ஒரு மகளையும் பதான் அராமிலே யாக்கோபுக்குப் பெற்றெடுத்தாள்; அவனுடைய மகன்களும், மகள்களுமாகிய எல்லோரும் முப்பத்துமூன்றுபேர். ");
INSERT INTO tam2017_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","காத்துடைய மகன்கள், சிப்பியோன், அகி, சூனி, எஸ்போன், ஏரி, ஆரோதி, அரேலி என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","ஆசேருடைய மகன்கள் இம்னா, இஸ்வா, இஸ்வி, பெரீயா என்பவர்கள்; இவர்களுடைய சகோதரி சேராக்கு என்பவள்; பெரீயாவின் மகன்கள் ஏபேர், மல்கியேல் என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","இவர்கள் லாபான் தன் மகளாகிய லேயாளுக்குக் கொடுத்த சில்பாளுடைய பிள்ளைகள்; அவள் இந்தப் பதினாறுபேரையும் யாக்கோபுக்குப் பெற்றெடுத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","யாக்கோபின் மனைவியாகிய ராகேலுடைய மகன்கள் யோசேப்பு, பென்யமீன் என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","யோசேப்புக்கு எகிப்துதேசத்திலே மனாசேயும் எப்பிராயீமும் பிறந்தார்கள்; அவர்களை ஓன் பட்டணத்து ஆசாரியனாகிய போத்திபிராவின் மகளாகிய ஆஸ்நாத் அவனுக்குப் பெற்றெடுத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","பென்யமீனுடைய மகன்கள் பேலா, பெகேர், அஸ்பேல், கேரா, நாகமான், ஏகி, ரோஷ், முப்பிம், உப்பீம், ஆர்து என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","ராகேல் யாக்கோபுக்குப் பெற்ற மகன்களாகிய இவர்கள் எல்லோரும் பதினான்குபேர். ");
INSERT INTO tam2017_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","தாணுடைய மகன் உசீம் என்பவன். ");
INSERT INTO tam2017_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","நப்தலியின் மகன்கள் யாத்சியேல், கூனி, எத்செர், சில்லேம் என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","இவர்கள் லாபான் தன் மகளாகிய ராகேலுக்குக் கொடுத்த பில்காள் யாக்கோபுக்குப் பெற்றவர்கள்; இவர்கள் எல்லோரும் ஏழுபேர். ");
INSERT INTO tam2017_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","யாக்கோபுடைய மகன்களின் மனைவிகளைத் தவிர, அவனுடைய கர்ப்பப்பிறப்பாயிருந்து அவன் மூலமாக எகிப்திற்கு வந்தவர்கள் எல்லோரும் அறுபத்தாறுபேர். ");
INSERT INTO tam2017_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","யோசேப்புக்கு எகிப்திலே பிறந்த மகன்கள் இரண்டுபேர்; ஆக எகிப்திற்குப் போன யாக்கோபின் குடும்பத்தார் எழுபதுபேர். ");
INSERT INTO tam2017_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","கோசேன் நாட்டிலே தன்னை யோசேப்பு சந்திக்க வரும்படி சொல்ல, யூதாவைத் தனக்கு முன்னாக அவனிடத்திற்கு யாக்கோபு அனுப்பினான்; அவர்கள் கோசேனிலே சேர்ந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","யோசேப்பு தன் இரதத்தை ஆயத்தப்படுத்தி, அதின்மேல் ஏறி, தன் தகப்பனாகிய இஸ்ரவேலைச் சந்திக்கும்படி போய், அவனைக் கண்டு, அவனுடைய கழுத்தைக் கட்டிக்கொண்டு, வெகுநேரம் அவனுடைய கழுத்தை விடாமல் அழுதான். ");
INSERT INTO tam2017_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","அப்பொழுது இஸ்ரவேல் யோசேப்பைப் பார்த்து: “நீ இன்னும் உயிரோடிருக்கிறாயே, நான் உன் முகத்தைக் கண்டேன், எனக்கு இப்போது மரணம் வந்தாலும் வரட்டும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","பின்பு, யோசேப்பு தன் சகோதரர்களையும் தன் தகப்பனுடைய குடும்பத்தாரையும் நோக்கி: “நான் பார்வோனிடத்திற்குப் போய், கானான்தேசத்திலிருந்து என் சகோதரர்களும் என் தகப்பன் குடும்பத்தாரும் என்னிடத்தில் வந்திருக்கிறார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","அவர்கள் மேய்ப்பர்கள், ஆடுமாடுகளை மேய்க்கிறது அவர்களுடைய தொழில்; அவர்கள் தங்களுடைய ஆடுமாடுகளையும் தங்களுக்கு உண்டான எல்லாவற்றையும் கொண்டுவந்தார்கள் என்று அவருக்குச் சொல்லுகிறேன். ");
INSERT INTO tam2017_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","பார்வோன் உங்களை அழைத்து, உங்களுடைய தொழில் என்ன என்று கேட்டால், ");
INSERT INTO tam2017_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","நீங்கள், கோசேன் நாட்டிலே குடியிருக்க, அவனை நோக்கி: எங்கள் பிதாக்களைப்போல, உமது அடியாராகிய நாங்களும் எங்கள் சிறுவயதுமுதல் இதுவரைக்கும் மேய்ப்பர்களாக இருக்கிறோம் என்று சொல்லுங்கள்; மேய்ப்பர்கள் எல்லோரும் எகிப்தியருக்கு அருவருப்பாக இருக்கிறார்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","யோசேப்பு பார்வோனிடம் சென்று: “என்னுடைய தகப்பனும், சகோதரர்களும், தங்களுடைய ஆடுமாடுகளோடும் தங்களுக்கு உண்டான எல்லாவற்றோடும்கூடக் கானான்தேசத்திலிருந்து வந்தார்கள்; இப்பொழுது கோசேன் நாட்டில் இருக்கிறார்கள்” என்று சொல்லி; ");
INSERT INTO tam2017_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","தன் சகோதரர்களில் ஐந்துபேரைப் பார்வோனுக்கு முன்பாகக் கொண்டுபோய் நிறுத்தினான். ");
INSERT INTO tam2017_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","பார்வோன் அவனுடைய சகோதரர்களை நோக்கி: “உங்களுடைய தொழில் என்ன” என்று கேட்டான்; அதற்கு அவர்கள்: “உமது அடியாராகிய நாங்களும் எங்கள் பிதாக்களும் மந்தை மேய்க்கிறவர்கள் என்று பார்வோனிடத்தில் சொன்னதுமன்றி, ");
INSERT INTO tam2017_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","கானான் தேசத்திலே பஞ்சம் கொடிதாயிருக்கிறது; உமது அடியாரின் மந்தைகளுக்கு மேய்ச்சல் இல்லாததால், இந்த தேசத்திலே தங்கவந்தோம்; உமது அடியாராகிய நாங்கள் கோசேன் நாட்டிலே குடியிருக்க தயவுசெய்யவேண்டும்” என்று வேண்டிக்கொண்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","அப்பொழுது பார்வோன் யோசேப்பை நோக்கி: “உன்னுடைய தகப்பனும், சகோதரர்களும் உன்னிடத்தில் வந்திருக்கிறார்களே. ");
INSERT INTO tam2017_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","எகிப்துதேசம் உனக்கு முன்பாக இருக்கிறது; தேசத்திலுள்ள நல்ல இடத்திலே உன்னுடைய தகப்பனையும், சகோதரர்களையும் குடியேறும்படி செய்; அவர்கள் கோசேன் நாட்டிலே குடியிருக்கலாம்; அவர்களுக்குள்ளே திறமையுள்ளவர்கள் உண்டென்று உனக்குத் தெரிந்திருந்தால், அவர்களை என் ஆடுமாடுகளை விசாரிக்கிறதற்குத் தலைவராக ஏற்படுத்தலாம் என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","பின்பு, யோசேப்பு தன் தகப்பனாகிய யாக்கோபை அழைத்துக்கொண்டுவந்து, அவனைப் பார்வோனுக்கு முன்பாக நிறுத்தினான். யாக்கோபு பார்வோனை ஆசீர்வதித்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","பார்வோன் யாக்கோபை நோக்கி: “உமக்கு வயது என்ன” என்று கேட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","அதற்கு யாக்கோபு: “நான் பரதேசியாக வாழ்ந்த நாட்கள் 130 வருடங்கள்; என் ஆயுசு நாட்கள் கொஞ்சமும் வேதனை நிறைந்ததுமாக இருக்கிறது; அவைகள் பரதேசிகளாக வாழ்ந்த என் பிதாக்களுடைய ஆயுசு நாட்களுக்கு வந்து எட்டவில்லை” என்று பார்வோனுடனே சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","பின்னும் யாக்கோபு பார்வோனை ஆசீர்வதித்து, அவனிடத்திலிருந்து புறப்பட்டுப்போனான். ");
INSERT INTO tam2017_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","பார்வோன் கட்டளையிட்டபடியே, யோசேப்பு தன்னுடைய தகப்பனுக்கும், சகோதரர்களுக்கும் எகிப்துதேசத்திலே நல்ல நாடாகிய ராமசேஸ் என்னும் நாட்டைச் சொந்தமாகக் கொடுத்து, அவர்களைக் குடியேற்றினான். ");
INSERT INTO tam2017_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","யோசேப்பு தன்னுடைய தகப்பனையும், சகோதரர்களையும் தன் தகப்பனுடைய குடும்பத்தார் அனைவரையும், அவரவர்கள் குடும்பத்திற்குத்தக்கதாக ஆகாரம் கொடுத்து ஆதரித்துவந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","பஞ்சம் மிகவும் கொடிதாயிருந்தது; தேசமெங்கும் ஆகாரம் கிடைக்காமல்போனது; எகிப்துதேசமும் கானான்தேசமும் பஞ்சத்தினாலே நலிந்துபோனது. ");
INSERT INTO tam2017_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","யோசேப்பு எகிப்துதேசத்திலும் கானான்தேசத்திலுமுள்ள பணத்தையெல்லாம் தானியம் வாங்கியவர்களிடத்திலிருந்து பெற்று, அதைப் பார்வோன் அரண்மனையிலே கொண்டுபோய்ச் சேர்த்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","எகிப்துதேசத்திலும் கானான்தேசத்திலுமுள்ள பணம் செலவழிந்தபோது, எகிப்தியர்கள் எல்லோரும் யோசேப்பினிடத்தில் வந்து: “எங்களுக்கு ஆகாரம் தாரும்; பணம் இல்லை, அதினால் நாங்கள் உமக்கு முன்பாகச் சாகவேண்டுமோ” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","அதற்கு யோசேப்பு: “உங்களிடத்தில் பணம் இல்லாமல்போனால், உங்கள் ஆடுமாடுகளைக் கொடுங்கள்; அவைகளுக்குப் பதிலாக உங்களுக்குத் தானியம் கொடுக்கிறேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","அவர்கள் தங்கள் ஆடுமாடு முதலானவைகளை யோசேப்பினிடத்தில் கொண்டுவந்தார்கள்; யோசேப்பு குதிரைகளையும் ஆடுகளையும் மாடுகளையும் கழுதைகளையும் வாங்கிக்கொண்டு, அந்த வருடம் அவர்களுடைய ஆடுமாடு முதலான எல்லாவற்றிற்கும் பதிலாக அவர்களுக்கு ஆகாரம் கொடுத்து, அவர்களை ஆதரித்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","அந்த வருடம் முடிந்தபின், அடுத்தவருடத்திலே அவர்கள் அவனிடத்தில் வந்து: “பணமும் செலவழிந்துபோனது; எங்களுடைய ஆடுமாடு முதலானவைகளும் எங்கள் ஆண்டவனைச் சேர்ந்தது; எங்களுடைய சரீரமும், நிலமுமே அல்லாமல், எங்கள் ஆண்டவனுக்கு முன்பாக மீதியானது ஒன்றும் இல்லை; இது எங்கள் ஆண்டவனுக்குத் தெரியாத காரியம் அல்ல. ");
INSERT INTO tam2017_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","நாங்களும் எங்களுடைய நிலங்களும் உம்முடைய கண்களுக்கு முன்பாக அழிந்து போகலாமா? நீர் எங்களையும் எங்களுடைய நிலங்களையும் வாங்கிக்கொண்டு, ஆகாரம் கொடுக்கவேண்டும்; நாங்களும் எங்களுடைய நிலங்களும் பார்வோனுக்கு உடைமைகளாயிருப்போம்; நாங்கள் சாகாமல் உயிரோடிருக்கவும், நிலங்கள் பாழாகப் போகாமலிருக்கவும், எங்களுக்கு விதைத்தானியத்தைத் தாரும்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","அப்படியே எகிப்தியர்கள் தங்களுக்குப் பஞ்சம் அதிகமானதால் அவரவர் தங்கள் தங்கள் வயல் நிலங்களை விற்றார்கள்; யோசேப்பு எகிப்தின் நிலங்கள் எல்லாவற்றையும் பார்வோனுக்காக வாங்கினான்; இந்த விதமாக அந்த பூமி பார்வோனுடையதாயிற்று. ");
INSERT INTO tam2017_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","மேலும் அவன் எகிப்தின் ஒரு எல்லை முதல் மறு எல்லைவரைக்குமுள்ள மக்களை அந்தந்தப் பட்டணங்களில் குடிமாறிப்போகச்செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","ஆசாரியர்களுடைய நிலத்தை மாத்திரம் அவன் வாங்கவில்லை; அது பார்வோனாலே ஆசாரியர்களுக்கு மானியமாகக் கொடுக்கப்பட்டிருந்ததாலும், பார்வோன் அவர்களுக்குக் கொடுத்த மானியத்தினாலே அவர்கள் வாழ்க்கை நடத்திவந்ததாலும், அவர்கள் தங்கள் நிலத்தை விற்கவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","பின்னும் யோசேப்பு மக்களை நோக்கி: “இதோ, இன்று உங்களையும் உங்கள் நிலங்களையும் பார்வோனுக்காக வாங்கிக்கொண்டேன்; இதோ, உங்களுக்குக் கொடுக்கப்படுகிற விதைத் தானியம், இதை நிலத்தில் விதையுங்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","விளைச்சலில் ஐந்தில் ஒரு பங்கைப் பார்வோனுக்குக் கொடுக்கவேண்டும்; மற்ற நான்கு பங்கும் வயலுக்கு விதையாகவும் உங்களுக்கும் உங்கள் குடும்பத்தாருக்கும் உங்கள் குழந்தைகளுக்கும் ஆகாரமாகவும் உங்களுடையதாகவும் இருக்கட்டும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","அப்பொழுது அவர்கள்: “நீர் எங்களுடைய உயிரைக் காப்பாற்றினீர்; எங்கள் ஆண்டவனுடைய கண்களில் எங்களுக்குத் தயவு கிடைக்கவேண்டும்; நாங்கள் பார்வோனுக்கு அடிமைகளாயிருக்கிறோம்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","ஐந்தில் ஒன்று பார்வோனுக்குச் சேரும் வாரம் என்று யோசேப்பு விதித்த கட்டளையின்படி எகிப்து தேசத்திலே இந்த நாள்வரைக்கும் நடந்துவருகிறது; ஆசாரியரின் நிலம் மாத்திரம் பார்வோனைச் சேராமலிருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","இஸ்ரவேலர்கள் எகிப்து தேசத்திலுள்ள கோசேன் நாட்டிலே குடியிருந்தார்கள்; அங்கே நிலங்களை உரிமைபாராட்டி, மிகவும் பலுகிப் பெருகினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","யாக்கோபு எகிப்து தேசத்திலே பதினேழு வருடங்கள் இருந்தான்; யாக்கோபுடைய ஆயுசு நாட்கள் நூற்றுநாற்பத்தேழு வருடங்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","இஸ்ரவேல் மரணமடையும் காலம் நெருங்கியது. அப்பொழுது அவன் தன் மகனாகிய யோசேப்பை வரவழைத்து, அவனை நோக்கி: “என்மேல் உனக்குத் தயவுண்டானால், உன் கையை என் தொடையின்கீழ் வைத்து எனக்கு நம்பிக்கையும் உண்மையுமுள்ளவனாயிரு; என்னை எகிப்திலே அடக்கம் செய்யாதிருப்பாயாக. ");
INSERT INTO tam2017_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","நான் என் பிதாக்களோடு படுத்துக்கொள்ளவேண்டும்; ஆகையால், நீ என்னை எகிப்திலிருந்து எடுத்துக்கொண்டுபோய், அவர்களை அடக்கம்செய்திருக்கிற நிலத்திலே என்னையும் அடக்கம்செய்” என்றான். அதற்கு அவன்: “உமது சொற்படி செய்வேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","அப்பொழுது அவன்: “எனக்கு ஆணையிட்டுக்கொடு” என்றான்; அவனுக்கு ஆணையிட்டுக்கொடுத்தான். அப்பொழுது இஸ்ரவேல் கை கோலில் சாய்ந்து தொழுதுகொண்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","அதற்குப்பின்பு, உம்முடைய தகப்பனார் வியாதியாயிருக்கிறார்” என்று யோசேப்புக்குச் சொல்லப்பட்டது. அப்பொழுது அவன் தன் இரண்டு மகன்களாகிய மனாசேயையும் எப்பிராயீமையும் தன்னோடு அழைத்துப்போனான். ");
INSERT INTO tam2017_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","“இதோ, உம்முடைய மகனாகிய யோசேப்பு உம்மிடத்தில் வந்திருக்கிறார்” என்று யாக்கோபுக்கு தெரிவிக்கப்பட்டது; அப்பொழுது இஸ்ரவேல் தன்னை திடப்படுத்திக்கொண்டு, கட்டிலின்மேல் உட்கார்ந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","யாக்கோபு யோசேப்பை நோக்கி: “சர்வவல்லமையுள்ள தேவன் கானான் தேசத்திலுள்ள லூஸ் என்னும் இடத்தில் எனக்குக் காட்சியளித்து, என்னை ஆசீர்வதித்து: ");
INSERT INTO tam2017_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","நான் உன்னைப் பலுகவும் பெருகவும் செய்து, உன்னைப் பல ஜனக்கூட்டமாக்கி, உனக்குப் பின்வரும் உன் சந்ததிக்கு இந்த தேசத்தை என்றென்றைக்கும் சொந்தமாகக் கொடுப்பேன் என்று என்னோடு சொன்னார். ");
INSERT INTO tam2017_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","நான் உன்னிடத்தில் எகிப்திற்கு வருவதற்குமுன்னே உனக்கு எகிப்துதேசத்தில் பிறந்த உன் இரண்டு மகன்களும் என்னுடைய மகன்கள்; ரூபன் சிமியோன் என்பவர்களைப்போல, எப்பிராயீமும் மனாசேயும் என்னுடையவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","இவர்களுக்குப்பின், நீ பெறும் பிள்ளைகள் உன்னுடையவர்கள்; அவர்கள் தங்கள் தங்கள் சகோதரர்களுடைய பெயரால் அழைக்கப்பட்டு அவர்களுக்குரிய சொத்தில் பங்குபெறுவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","நான் பதானை விட்டு வருகையில், கானான்தேசத்தில் எப்பிராத்தாவுக்குக் கொஞ்சம் தூரம் இருக்கும்போது, வழியிலே ராகேல் என்னருகில் மரணமடைந்தாள்; அவளை அங்கே பெத்லகேம் என்னும் எப்பிராத்தா ஊருக்குப் போகிற வழியிலே அடக்கம்செய்தேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","இஸ்ரவேல் யோசேப்பின் மகன்களைப் பார்த்து: “இவர்கள் யார்” என்று கேட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","யோசேப்பு தன் தகப்பனை நோக்கி: “இவர்கள் இந்த இடத்தில் தேவன் எனக்கு அருளின மகன்கள்” என்றான். அப்பொழுது அவன்: “நான் அவர்களை ஆசீர்வதிக்க அவர்களை என் அருகில் கொண்டுவா” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","முதிர்வயதினால் இஸ்ரவேலின் கண்கள் மங்கலாயிருந்தால், அவன் நன்றாகப் பார்க்கமுடியாமலிருந்தது. அவர்களை அவனருகில் சேரச்செய்தான்; அப்பொழுது அவன் அவர்களை முத்தம்செய்து அணைத்துக்கொண்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","இஸ்ரவேல் யோசேப்பை நோக்கி: “உன் முகத்தைக் காண்பேன் என்று நான் நினைக்கவில்லை; ஆனாலும், இதோ, உன் சந்ததியையும் காணும்படி தேவன் எனக்கு அருள்செய்தார்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","அப்பொழுது அவனுடைய முழங்கால்கள் நடுவே இருந்த பிள்ளைகளை யோசேப்பு பின்னிடச்செய்து, அவனுடைய முகத்திற்கு முன்பாகத் தரைமட்டும் குனிந்து வணங்கினான். ");
INSERT INTO tam2017_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","பின்பு, யோசேப்பு அவ்விருவரையும் கொண்டுவந்து, எப்பிராயீமைத் தன் வலது கையினாலே இஸ்ரவேலின் இடது கைக்கு நேராகவும், மனாசேயைத் தன் இடது கையினாலே இஸ்ரவேலின் வலது கைக்கு நேராகவும் விட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","அப்பொழுது இஸ்ரவேல், மனமறிய, தன் வலது கையை நீட்டி, இளையவனாகிய எப்பிராயீமுடைய தலையின்மேலும், மனாசே மூத்தவனாயிருந்தும், தன் இடது கையை மனாசேயுடைய தலையின்மேலும் வைத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","அவன் யோசேப்பை ஆசீர்வதித்து: “என் பிதாக்களாகிய ஆபிரகாமும் ஈசாக்கும் வழிபட்டு வணங்கிய தேவனும், நான் பிறந்த நாள்முதல் இந்த நாள்வரைக்கும் என்னை ஆதரித்துவந்த தேவனும், ");
INSERT INTO tam2017_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","எல்லாத் தீமைக்கும் விலக்கி என்னை மீட்ட தூதனுமானவர் இந்தப் பிள்ளைகளை ஆசீர்வதிப்பாராக, என் பெயரும் என் பிதாக்களாகிய ஆபிரகாம் ஈசாக்கு என்பவர்களின் பெயரும் இவர்களுக்கு வைக்கப்படக்கடவது; பூமியில் இவர்கள் மிகுதியாகப் பெருகுவார்களாக” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","தகப்பன் தன் வலதுகையை எப்பிராயீமுடைய தலையின்மேல் வைத்ததை யோசேப்பு கண்டு, அது தனக்குப் பிரியமில்லாததால், எப்பிராயீமுடைய தலையின்மேல் இருந்த தன் தகப்பனுடைய கையை மனாசேயினுடைய தலையின்மேல் வைப்பதற்காக எடுத்து: ");
INSERT INTO tam2017_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","“என் தகப்பனே, அப்படியல்ல, இவன் மூத்தவன், இவனுடைய தலையின்மேல் உம்முடைய வலதுகையை வைக்கவேண்டும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","அவனுடைய தகப்பனோ தடுத்து: “அது எனக்குத் தெரியும், என் மகனே, எனக்குத் தெரியும்; இவனும் ஒரு ஜனக்கூட்டமாவான், இவனும் பெருகுவான்; இவனுடைய தம்பியோ இவனிலும் அதிகமாகப் பெருகுவான்; அவனுடைய சந்ததியார் திரளான மக்களாவார்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","இந்த விதமாக அவன் அன்றையதினம் அவர்களை ஆசீர்வதித்து: “தேவன் உன்னை எப்பிராயீமைப்போலவும் மனாசேயைப்போலவும் ஆக்குவாராக என்று இஸ்ரவேலர்கள் உன்னை முன்னிட்டு வாழ்த்துவார்கள்” என்று சொல்லி, எப்பிராயீமை மனாசேக்கு மேலாக வைத்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","பின்பு, இஸ்ரவேல் யோசேப்பை நோக்கி: “இதோ, நான் மரணமடையப்போகிறேன்; தேவன் உங்களோடு இருப்பார்; அவர் உங்கள் பிதாக்களின் தேசத்திற்கு உங்களைத் திரும்பவும் போகச் செய்வார் என்றும், ");
INSERT INTO tam2017_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","உன் சகோதரர்களுக்குக் கொடுத்ததைவிட, நான் என் பட்டயத்தாலும், என் வில்லினாலும், எமோரியர்கள் கையிலிருந்து சம்பாதித்த ஒரு நிலத்தை உனக்கு அதிகமான பங்காகக் கொடுத்தேன்” என்றும் சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","யாக்கோபு தன் மகன்களை அழைத்து: “நீங்கள் கூடிவாருங்கள், கடைசி நாட்களில் உங்களுக்குச் சம்பவிக்கும் காரியங்களை அறிவிப்பேன். ");
INSERT INTO tam2017_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","யாக்கோபின் மகன்களே, கூடிவந்து கேளுங்கள்; உங்கள் தகப்பனாகிய இஸ்ரவேலுக்குச் செவிகொடுங்கள்”. ");
INSERT INTO tam2017_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“ரூபனே, நீ என் முதற்பிறந்தவன்; நீ என் திறமையும், என் முதற்பெலனுமானவன்; நீ மேன்மையில் பிரதானமும் வல்லமையில் விசேஷமுமானவன். ");
INSERT INTO tam2017_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","தண்ணீரைப்போல தளம்பினவனே, நீ மேன்மை அடையமாட்டாய்; உன் தகப்பனுடைய படுக்கையின்மேல் ஏறினாய்; நீ அதைத் தீட்டுப்படுத்தினாய்; என் படுக்கையின்மேல் ஏறினானே. ");
INSERT INTO tam2017_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","சிமியோனும், லேவியும் சகோதரர்கள்; அவர்களுடைய பட்டயங்கள் கொடுமையின் கருவிகள். ");
INSERT INTO tam2017_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","என் ஆத்துமாவே, அவர்களுடைய இரகசிய ஆலோசனைக்கு உடன்படாதே; என் மேன்மையே, அவர்கள் கூட்டத்தில் நீ சேராதே; அவர்கள் தங்கள் கோபத்தினாலே ஒரு மனிதனைக் கொன்று, தங்கள் அகங்காரத்தினாலே அரண்களை அழித்தார்களே. ");
INSERT INTO tam2017_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","அவர்களுடைய கடுமையான கோபமும், கொடுமையான மூர்க்கமும் சபிக்கப்படுவதாக; யாக்கோபிலே அவர்களைப் பிரியவும், இஸ்ரவேலிலே அவர்களைச் சிதறவும் செய்வேன். ");
INSERT INTO tam2017_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","யூதாவே, சகோதரர்களால் புகழப்படுபவன் நீயே; உன் கை உன் எதிரிகளுடைய கழுத்தின்மேல் இருக்கும்; உன் தகப்பனுடைய மகன்கள் உன்னைப் பணிவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","யூதா பெரிய சிங்கம், நீ இரையை விரும்பி ஏறிப்போனாய்; என் மகனே, சிங்கம்போலும் கிழச்சிங்கம்போலும் மடங்கிப்படுத்தான்; அவனை எழுப்புகிறவன் யார்? ");
INSERT INTO tam2017_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","சமாதானக் யெகோவா வரும்வரைக்கும் செங்கோல் யூதாவைவிட்டு நீங்குவதும் இல்லை, ஆளுகை அவனுடைய பாதங்களைவிட்டு ஒழிவதும் இல்லை; மக்கள் அவரிடத்தில் சேருவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","அவன் தன் கழுதைக்குட்டியைத் திராட்சைச்செடியிலும், தன் பெண்கழுதையின் குட்டியை உயர்தர திராட்சைச்செடியிலும் கட்டுவான்; திராட்சை ரசத்திலே தன் ஆடையையும், திராட்சைப்பழங்களின் இரத்தத்திலே தன் அங்கியையும் வெளுப்பான். ");
INSERT INTO tam2017_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","அவனுடைய கண்கள் திராட்சைரசத்தினால் சிவப்பாகவும், அவனுடைய பற்கள் பாலினால் வெண்மையாகவும் இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","செபுலோன் கடற்கரை அருகே குடியிருப்பான்; அவன் கப்பல் துறைமுகமாக இருப்பான்; அவனுடைய எல்லை சீதோன்வரைக்கும் இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","இசக்கார் இரண்டு சுமைகளின் நடுவே படுத்துக்கொண்டிருக்கிற பலத்த கழுதை. ");
INSERT INTO tam2017_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","அவன், இளைப்பாறுதல் நல்லது என்றும், நாடு வசதியானது என்றும் கண்டு, சுமக்கிறதற்குத் தன் தோளைச் சாய்த்து, கூலிவேலை செய்கிறவனானான். ");
INSERT INTO tam2017_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","தாண் இஸ்ரவேல் கோத்திரங்களில் ஒரு கோத்திரமாகி, தன் ஜனத்தை நியாயம் விசாரிப்பான். ");
INSERT INTO tam2017_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","தாண், குதிரையின்மேல் ஏறியிருக்கிறவன் மல்லாந்து விழும்படியாக அதின் குதிகாலைக் கடிக்கிறதற்கு வழியில் கிடக்கிற பாம்பைப்போலவும், பாதையில் இருக்கிற விரியனைப்போலவும் இருப்பான். ");
INSERT INTO tam2017_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","யெகோவாவே, உம்மாலே விடுவிக்கப்படக் காத்திருக்கிறேன். ");
INSERT INTO tam2017_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","காத் என்பவன்மேல் ராணுவக்கூட்டம் பாய்ந்துவிழும்; அவனோ முடிவிலே அதின்மேல் பாய்ந்துவிழுவான். ");
INSERT INTO tam2017_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","ஆசேருடைய ஆகாரம் கொழுமையாயிருக்கும்; ராஜாக்களுக்கு வேண்டிய ருசிகரமானவைகளை அவன் தருவான். ");
INSERT INTO tam2017_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","நப்தலி விடுதலைபெற்ற பெண்மான்; இன்பமான வசனங்களை வசனிப்பான். ");
INSERT INTO tam2017_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","யோசேப்பு கனிதரும் செடி; அவன் நீரூற்றின் அருகில் உள்ள கனிதரும் செடி; அதின் கொடிகள் சுவரின்மேல் படரும். ");
INSERT INTO tam2017_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","வில்வீரர்கள் அவனை மனவருத்தமாக்கி, அவன்மேல் எய்து, அவனைப் பகைத்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ஆனாலும், அவனுடைய வில் உறுதியாக நின்றது; அவனுடைய புயங்கள் யாக்கோபுடைய வல்லவரின் கைகளால் பலமடைந்தன; இதினால் அவன் மேய்ப்பனும் இஸ்ரவேலின் கன்மலையும் ஆனான். ");
INSERT INTO tam2017_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","உன் தகப்பனுடைய தேவனாலே அப்படியாயிற்று, அவர் உனக்குத் துணையாயிருப்பார்; சர்வவல்லவராலே அப்படியாயிற்று, அவர் உயர வானத்திலிருந்து உண்டாகும் ஆசீர்வாதங்களினாலும், கீழே ஆழத்தில் உண்டாகும் ஆசீர்வாதங்களினாலும், மார்பகங்களுக்கும் கர்ப்பங்களுக்கும் உரிய ஆசீர்வாதங்களினாலும் உன்னை ஆசீர்வதிப்பார். ");
INSERT INTO tam2017_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","உன் தகப்பனுடைய ஆசீர்வாதங்கள் என் பிதாக்களுடைய ஆசீர்வாதங்களுக்கு மேற்பட்டதாயிருந்து, நித்திய பர்வதங்களின் முடிவுவரைக்கும் எட்டுகின்றன; அவைகள் யோசேப்புடைய தலையின் மேலும், தன் சகோதரர்களில் விசேஷித்தவனுடைய உச்சந்தலையின்மேலும் வருவதாக. ");
INSERT INTO tam2017_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","பென்யமீன் பீறுகிற ஓநாய்; காலையில் தன் இரையை அழிப்பான், மாலையில் தான் கொள்ளையிட்டதைப் பங்கிடுவான்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","இவர்கள் எல்லோரும் இஸ்ரவேலின் பன்னிரண்டு கோத்திரத்தார்; அவர்களுடைய தகப்பன் அவர்களை ஆசீர்வதிக்கும்போது, அவர்களுக்குச் சொன்னது இதுதான்; அவனவனுக்குரிய ஆசீர்வாதம் சொல்லி அவனவனை ஆசீர்வதித்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","பின்னும் அவன் அவர்களை நோக்கி: “நான் என் ஜனத்தாரோடு சேர்க்கப்படப்போகிறேன்; ஏத்தியனான எப்பெரோனின் நிலத்திலுள்ள குகையிலே என்னை என் பிதாக்களருகில் அடக்கம் செய்யுங்கள்” என்று கட்டளையிட்டு; ");
INSERT INTO tam2017_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","அந்தக் குகை கானான் தேசத்திலே மம்ரேக்கு எதிராக மக்பேலா எனப்பட்ட நிலத்தில் இருக்கிறது; அதை நமக்குச் சொந்தக் கல்லறைப் பூமியாக இருக்கும்படி, ஆபிரகாம் ஏத்தியனான எப்பெரோன் கையில் அதற்குரிய நிலத்துடனே வாங்கினார். ");
INSERT INTO tam2017_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","அங்கே ஆபிரகாமையும் அவர் மனைவியாகிய சாராளையும் அடக்கம்செய்தார்கள்; அங்கே ஈசாக்கையும் அவர் மனைவியாகிய ரெபெக்காளையும் அடக்கம்செய்தார்கள்; அங்கே லேயாளையும் அடக்கம்செய்தேன். ");
INSERT INTO tam2017_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","அந்த நிலமும் அதில் இருக்கிற குகையும் ஏத்தின் மகன்களிடமிருந்து வாங்கப்பட்டது” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","யாக்கோபு தன் மகன்களுக்குக் கட்டளையிட்டு முடிந்தபின்பு, அவன் தன் கால்களைக் கட்டிலின்மேல் மடக்கிக்கொண்டு உயிர்போய், தன் மக்களோடு சேர்க்கப்பட்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","அப்பொழுது யோசேப்பு தன் தகப்பனுடைய முகத்தின்மேல் விழுந்து, அழுது, அவனை முத்தம்செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","பின்பு, தன் தகப்பனுடைய உடலைப் பதப்படுத்தும்படி யோசேப்பு தன் வேலைக்காரர்களாகிய வைத்தியர்களுக்குக் கட்டளையிட்டான்; அப்படியே வைத்தியர்கள் இஸ்ரவேலைப் பதப்படுத்தினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","பதப்படுத்த 40 நாட்கள் ஆகும்; அப்படியே அந்த நாட்கள் நிறைவேறின. எகிப்தியர்கள் அவனுக்காக 70 நாட்கள் துக்கம் அனுசரித்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","துக்கம் அனுசரிக்கும் நாட்கள் முடிந்தபின், யோசேப்பு பார்வோனின் குடும்பத்தாரை நோக்கி: “உங்கள் கண்களில் எனக்கு தயவுகிடைத்ததானால், நீங்கள் பார்வோனுடைய காது கேட்க அவருக்கு தெரிவிக்கவேண்டியது என்னவென்றால், ");
INSERT INTO tam2017_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","என் தகப்பனார் என்னை நோக்கி: இதோ, நான் மரணமடையப்போகிறேன்; கானான் தேசத்திலே நான் எனக்காக வெட்டிவைத்திருக்கிற கல்லறையிலே என்னை அடக்கம் செய்யவேண்டும் என்று என்னிடத்தில் சொல்லி, உறுதிமொழி வாங்கிக்கொண்டார்; நான் அங்கே போய், என் தகப்பனை அடக்கம்செய்து வருவதற்கு அனுமதிகொடுக்க வேண்டிக்கொள்ளுகிறேன் என்று சொல்லுங்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","அதற்குப் பார்வோன்: “உன் தகப்பன் உன்னிடத்தில் உறுதிமொழி வாங்கிக்கொண்டபடியே, நீ போய், அவரை அடக்கம்செய்து வா” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","அப்படியே யோசேப்பு தன் தகப்பனை அடக்கம்செய்யப் போனான். பார்வோனுடைய அரண்மனையிலிருந்த பெரியவர்களாகிய அவனுடைய அனைத்து உயர் அதிகாரிகளும் எகிப்துதேசத்திலுள்ள அனைத்து பெரியோரும், ");
INSERT INTO tam2017_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","யோசேப்பின் வீட்டார் அனைவரும், அவனுடைய சகோதரர்களும், தகப்பன் வீட்டாரும் அவனோடுகூடப் போனார்கள். தங்கள் குழந்தைகளையும், தங்கள் ஆடுமாடுகளையும்மாத்திரம் கோசேன் நாட்டிலே விட்டுப் போனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","இரதங்களும் குதிரைவீரரும் அவனோடு போனதினால், மக்கள்கூட்டம் மிகவும் அதிகமாயிருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","அவர்கள் யோர்தானுக்கு மறுகரையில் இருக்கிற ஆத்தாத்தின் போர்க்களத்திற்கு வந்தபோது, அந்த இடத்திலே பெரும் புலம்பலாகப் புலம்பினார்கள். அங்கே தன் தகப்பனுக்காக ஏழுநாட்கள் துக்கம் அனுசரித்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","ஆத்தாத்தின் களத்திலே துக்கம் அனுசரிக்கிறதை அந்த தேசத்தின் குடிமக்களாகிய கானானியர்கள் கண்டு: “இது எகிப்தியருக்குப் பெரிய துக்கம் அனுசரித்தல்” என்றார்கள். அதனால் யோர்தானுக்கு அப்பால் இருக்கிற அந்த இடத்திற்கு ஆபேல்மிஸ்ராயீம் என்னும் பெயர் உண்டானது. ");
INSERT INTO tam2017_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","யாக்கோபின் மகன்கள், தங்களுக்குக் கட்டளையிட்டிருந்தபடியே, ");
INSERT INTO tam2017_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","அவனைக் கானான் தேசத்திற்குக் கொண்டுபோய், ஆபிரகாம் மம்ரேக்கு எதிரே இருக்கிற மக்பேலா என்னும் நிலத்திலே தனக்குச் சொந்தக் கல்லறைப் பூமியாக ஏத்தியனான எப்பெரோனிடத்தில் வாங்கின நிலத்திலுள்ள குகையிலே அவனை அடக்கம்செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","யோசேப்பு தன் தகப்பனை அடக்கம்செய்தபின்பு, அவனும் அவனுடைய சகோதரர்களும், அவனுடைய தகப்பனை அடக்கம்செய்வதற்கு அவனோடுகூடப் போனவர்கள் அனைவரும் எகிப்திற்குத் திரும்பினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","தங்களுடைய தகப்பன் மரணமடைந்ததை யோசேப்பின் சகோதரர்கள் கண்டு: “ஒரு வேளை யோசேப்பு நம்மைப் பகைத்து, நாம் அவனுக்குச் செய்த எல்லாப் பொல்லாங்குக்காகவும் நம்மை பழிவாங்குவான்” என்று சொல்லி, யோசேப்பினிடத்தில் ஆள் அனுப்பி, ");
INSERT INTO tam2017_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","“உம்முடைய சகோதரர்கள் உமக்குப் பொல்லாங்கு செய்திருந்தாலும், அவர்கள் செய்த துரோகத்தையும் பாதகத்தையும் நீர் தயவுசெய்து மன்னிக்கவேண்டும் என்று உம்முடைய தகப்பனார் மரணமடையுமுன்னே, உமக்குச் சொல்லும்படி கட்டளையிட்டார். ");
INSERT INTO tam2017_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","ஆகையால், உம்முடைய தகப்பனாருடைய தேவனுக்கு ஊழியக்காரராகிய நாங்கள் செய்த துரோகத்தை மன்னிக்கவேண்டும்” என்று அவனுக்குச் சொல்லச் சொன்னார்கள். அவர்கள் அதை யோசேப்புக்குச் சொன்னபோது, அவன் அழுதான். ");
INSERT INTO tam2017_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","பின்பு, அவனுடைய சகோதரர்களும் போய், அவனுக்கு முன்பாகத் தாழவிழுந்து: “இதோ, நாங்கள் உமக்கு அடிமைகள்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","யோசேப்பு அவர்களை நோக்கி: பயப்படாதிருங்கள்; “நான் தேவனா; ");
INSERT INTO tam2017_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","நீங்கள் எனக்குத் தீமைசெய்ய நினைத்தீர்கள்; தேவனோ, இப்பொழுது நடந்துவருகிறபடியே, திரளான மக்களை உயிரோடு காக்கும்படி, அதை நன்மையாக முடியச்செய்தார். ");
INSERT INTO tam2017_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ஆதலால், பயப்படாதிருங்கள்; நான் உங்களையும் உங்கள் குழந்தைகளையும் பராமரிப்பேன்” என்று, அவர்களுக்கு ஆறுதல் சொல்லி, அவர்களோடு ஆதரவாகப் பேசினான். ");
INSERT INTO tam2017_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","யோசேப்பும் அவனுடைய தகப்பன் குடும்பத்தாரும் எகிப்திலே குடியிருந்தார்கள். யோசேப்பு 110 வருடங்கள் உயிரோடிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","யோசேப்பு எப்பிராயீமுக்குப் பிறந்த மூன்றாம் தலைமுறைப் பிள்ளைகளையும் கண்டான்; மனாசேயின் மகனாகிய மாகீரின் பிள்ளைகளும் யோசேப்பின் மடியில் வளர்க்கப்பட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","யோசேப்பு தன் சகோதரர்களை நோக்கி: “நான் மரணமடையப்போகிறேன்; ஆனாலும் தேவன் உங்களை நிச்சயமாகச் சந்தித்து, நீங்கள் இந்த தேசத்தைவிட்டு, தாம் ஆபிரகாமுக்கும் ஈசாக்குக்கும் யாக்கோபுக்கும் ஆணையிட்டுக் கொடுத்திருக்கிற தேசத்திற்குப் போகச்செய்வார் என்று சொன்னதுமல்லாமல்; ");
INSERT INTO tam2017_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","தேவன் உங்களைச் சந்திக்கும்போது, என் எலும்புகளை இந்த இடத்திலிருந்து கொண்டுபோவீர்களாக” என்றும் சொல்லி; யோசேப்பு இஸ்ரவேல் வம்சத்தாரிடத்தில் உறுதிமொழி வாங்கிக்கொண்டான். ");
INSERT INTO tam2017_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","யோசேப்பு 110 வயதுள்ளவனாக இறந்தான். அவனுடைய உடலைப் பதப்படுத்தி, எகிப்து தேசத்தில் அவனை ஒரு பெட்டியிலே வைத்துவைத்தார்கள்.");
INSERT INTO tam2017_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","எகிப்திற்குப் போன இஸ்ரவேலுடைய மகன்களின் பெயர்கள்: ரூபன், சிமியோன், லேவி, யூதா, ");
INSERT INTO tam2017_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","இசக்கார், செபுலோன், பென்யமீன், ");
INSERT INTO tam2017_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","தாண், நப்தலி, காத், ஆசேர் என்பவைகளே. ");
INSERT INTO tam2017_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","இவர்கள் யாக்கோபுடன் தங்கள் தங்கள் குடும்பங்களோடு போனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","யோசேப்போ அதற்கு முன்பே எகிப்திற்கு போயிருந்தான். யாக்கோபின் சந்ததியார்கள் எல்லோரும் எழுபது பேர். ");
INSERT INTO tam2017_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","யோசேப்பும் அவனுடைய சகோதரர்கள் அனைவரும், அந்தத் தலைமுறையினர் எல்லோரும் மரணமடைந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","இஸ்ரவேலர்கள் அதிகமாக பலுகி, ஏராளமாகப் பெருகிப் பலத்திருந்தார்கள்; தேசம் அவர்களால் நிறைந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","யோசேப்பை அறியாத புதிய ராஜா ஒருவன் எகிப்தில் தோன்றினான். ");
INSERT INTO tam2017_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","அவன் தன்னுடைய மக்களை நோக்கி: “இதோ, இஸ்ரவேலர்களுடைய மக்கள் நம்மைவிட ஏராளமானவர்களும், பலத்தவர்களுமாக இருக்கிறார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","அவர்கள் பெருகாதபடியும், ஒரு யுத்தம் உண்டானால், அவர்களும் நம்முடைய பகைவரோடு கூடி, நமக்கு விரோதமாக யுத்தம்செய்து, தேசத்தைவிட்டுப் புறப்பட்டுப்போகாதபடியும், நாம் அவர்களைக்குறித்து ஒரு தீர்மானம் செய்யவேண்டும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","அப்படியே அவர்களைச் சுமை சுமக்கிற வேலையினால் ஒடுக்கும்படி, அவர்கள்மேல் மேற்பார்வையாளர்களை வைத்தார்கள்; அப்பொழுது அவர்கள் பார்வோனுக்காகப் பித்தோம், ராமசேஸ் என்னும் சேமிப்புக் கிடங்கு பட்டணங்களைக் கட்டினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","ஆனாலும் அவர்களை எவ்வளவு ஒடுக்கினார்களோ அவ்வளவாக அவர்கள் பலுகிப் பெருகினார்கள். ஆகையால் அவர்கள் இஸ்ரவேலர்களைக்குறித்து எரிச்சல் அடைந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","எகிப்தியர்கள் இஸ்ரவேர்களைக் கொடுமையாக வேலைவாங்கினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","கலவையும் செங்கலுமாகிய இவைகளைச் செய்யும் வேலையாலும், வயலில் செய்யும் எல்லாவித வேலையாலும், அவர்களுக்கு அவர்களுடைய வாழ்க்கையையும் கசப்பாக்கினார்கள்; அவர்களைக்கொண்டு செய்த எல்லா வேலைகளிலும், அவர்களைக் கொடுமையாக நடத்தினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","அதுமட்டுமில்லாமல், எகிப்தின் ராஜா சிப்பிராள், பூவாள் என்னும் பெயருடைய எபிரெய மருத்துவச்சிகளுடன் பேசி: ");
INSERT INTO tam2017_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“நீங்கள் எபிரெய பெண்களுக்கு பிரசவம் பார்க்கும்போது, அவர்கள் மணையின்மேல் உட்கார்ந்திருக்கும்போது பார்த்து, ஆண்பிள்ளையாக இருந்தால் கொன்றுபோடுங்கள், பெண்பிள்ளையாக இருந்தால் உயிரோடு இருக்கட்டும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","மருத்துவச்சிகளோ, தேவனுக்குப் பயந்ததால், எகிப்தின் ராஜா தங்களுக்கு இட்ட கட்டளைப்படி செய்யாமல், ஆண்பிள்ளைகளையும் உயிரோடு காப்பாற்றினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","அதினால் எகிப்தின் ராஜா மருத்துவச்சிகளை அழைத்து: “நீங்கள் ஆண்பிள்ளைகளை உயிரோடு காப்பாற்றுகிற காரியம் என்ன” என்று கேட்டான். ");
INSERT INTO tam2017_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","அதற்கு மருத்துவச்சிகள் பார்வோனை நோக்கி: “எபிரெய பெண்கள் எகிப்திய பெண்களைப்போல் இல்லை, அவர்கள் நல்ல பலமுள்ளவர்கள்; மருத்துவச்சி அவர்களிடம் போவதற்கு முன்பே அவர்கள் பிரசவித்துவிடுகிறார்கள்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","இதினால் தேவன் மருத்துவச்சிகளுக்கு நன்மைசெய்தார். மக்கள் பெருகி மிகுதியும் பலத்துப்போனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","மருத்துவச்சிகள் தேவனுக்குப் பயந்ததால், அவர்களுடைய குடும்பங்கள் செழிக்கும்படிச் செய்தார். ");
INSERT INTO tam2017_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","அப்பொழுது பார்வோன், “எபிரெயருக்கு பிறக்கும் ஆண்பிள்ளைகளையெல்லாம் நைல் நதியிலே போடவும், பெண்பிள்ளைகளையெல்லாம் உயிரோடு வைக்கவும்” தன்னுடைய மக்கள் எல்லோருக்கும் கட்டளையிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","லேவியின் கோத்திரத்தாரில் ஒருவன் லேவியின் மகள்களில் ஒருத்தியைத் திருமணம்செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","அந்த பெண் கர்ப்பவதியாகி, ஒரு ஆண்பிள்ளையைப் பெற்று, அது அழகுள்ளது என்று கண்டு, அதை மூன்று மாதங்கள் ஒளித்துவைத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","அதன்பின்பு அவள் பிள்ளையை ஒளித்துவைக்கமுடியாமல், ஒரு நாணல்பெட்டியை எடுத்து, அதற்குப் பிசினும் தாரும் பூசி, அதிலே பிள்ளையை வைத்து, நைல் நதியோரமாக நாணலுக்குள்ளே வைத்தாள். ");
INSERT INTO tam2017_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","அதற்கு என்ன சம்பவிக்கும் என்பதை அறியும்படி அதின் சகோதரி தூரத்திலே நின்றுகொண்டிருந்தாள். ");
INSERT INTO tam2017_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","அப்பொழுது பார்வோனுடைய மகள் நதியில் குளிக்க வந்தாள்; அவளுடைய பணிப்பெண்கள் நதியோரத்தில் உலாவினார்கள்; அவள் நாணலுக்குள்ளே இருக்கிற பெட்டியைக் கண்டு, தன்னுடைய பணிப்பெண்ணை அனுப்பி அதைக் கொண்டுவரும்படிச் செய்தாள். ");
INSERT INTO tam2017_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","அதைத் திறந்தபோது பிள்ளையைக்கண்டாள்; பிள்ளை அழுதது; அவள் அதின்மேல் இரக்கமுற்று, “இது எபிரெயர்களின் பிள்ளைகளில் ஒன்று” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","அப்பொழுது அப்பிள்ளையின் சகோதரி பார்வோனின் மகளை நோக்கி: “உமக்கு இந்தப் பிள்ளையை வளர்க்கும்படி எபிரெய பெண்களில் பால்கொடுக்கிற ஒருத்தியை நான் போய் உம்மிடத்தில் அழைத்துக்கொண்டு வரட்டுமா” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","அதற்குப் பார்வோனுடைய மகள்: “அழைத்துக்கொண்டுவா” என்றாள். இந்தப் பெண் போய்ப் பிள்ளையின் தாயையே அழைத்துக்கொண்டு வந்தாள். ");
INSERT INTO tam2017_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","பார்வோனுடைய மகள் அவளை நோக்கி: “நீ இந்தப் பிள்ளையை எடுத்துக்கொண்டுபோய், அதை எனக்காக வளர்த்திடு, நான் உனக்குச் சம்பளம் கொடுக்கிறேன்” என்றாள். அந்தப் பெண், பிள்ளையை எடுத்துக்கொண்டுபோய், அதை வளர்த்தாள். ");
INSERT INTO tam2017_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","பிள்ளை பெரிதானபோது, அவள் அதைப் பார்வோனுடைய மகளிடம் கொண்டுபோய் விட்டாள். அவளுக்கு அவன் மகனானான். அவள்: “அவனை தண்ணீரிலிருந்து எடுத்தேன்” என்று சொல்லி, அவனுக்கு மோசே என்று பெயரிட்டாள். ");
INSERT INTO tam2017_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","மோசே பெரியவனான காலத்தில், அவன் தன்னுடைய சகோதரர்களிடம் போய், அவர்கள் சுமைசுமக்கிறதைப் பார்த்து, தன்னுடைய சகோதரர்களாகிய எபிரெயர்களில் ஒருவனை ஒரு எகிப்தியன் அடிக்கிறதைக் கண்டு, ");
INSERT INTO tam2017_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","அங்கும் இங்கும் பார்த்து, ஒருவரும் இல்லை என்று அறிந்து, எகிப்தியனை வெட்டி, அவனை மணலிலே புதைத்துப்போட்டான். ");
INSERT INTO tam2017_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","அவன் மறுநாளிலும் வெளியே போனபோது, எபிரெய மனிதர்கள் இருவர் சண்டையிட்டுக்கொண்டிருந்தார்கள். அப்பொழுது அவன் அநியாயம் செய்கிறவனை நோக்கி: “நீ உன்னுடைய தோழனை அடிக்கிறது ஏன்” என்று கேட்டான். ");
INSERT INTO tam2017_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","அதற்கு அவன்: “எங்கள்மேல் உன்னை அதிகாரியாகவும் நியாயாதிபதியாகவும் ஏற்படுத்தினவன் யார்? நீ எகிப்தியனைக் கொன்றுபோட்டதுபோல, என்னையும் கொன்றுபோட நினைக்கிறாயோ” என்றான். அப்பொழுது மோசே காரியம் நிச்சயமாக வெளிப்பட்டது என்று பயந்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","பார்வோன் அந்தக் காரியத்தைக் கேள்விப்பட்டபோது, மோசேயைக் கொலைசெய்ய முயற்சித்தான். மோசே பார்வோனிடத்திலிருந்து தப்பியோடி, மீதியான் தேசத்தில் போய்த் தங்கி, ஒரு கிணற்றின் அருகில் உட்கார்ந்திருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","மீதியான் தேசத்து ஆசாரியனுக்கு ஏழு மகள்கள் இருந்தார்கள்; அவர்கள் தங்கள் தகப்பனுடைய ஆடுகளுக்குத் தண்ணீர் காட்டும்படி அங்கே வந்து, தண்ணீர் எடுத்து, தொட்டிகளை நிரப்பினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","அப்பொழுது மேய்ப்பர்கள் வந்து, அவர்களைத் துரத்தினார்கள்; மோசே எழுந்து, அவர்களுக்குத் துணை நின்று, அவர்களுடைய ஆடுகளுக்குத் தண்ணீர் காட்டினான். ");
INSERT INTO tam2017_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","அவர்கள் தங்களுடைய தகப்பனாகிய ரெகுவேலிடம் வந்தபோது, அவன்: “நீங்கள் இன்று இத்தனை சீக்கிரமாக வந்தது ஏன்” என்று கேட்டான். ");
INSERT INTO tam2017_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","அதற்கு அவர்கள்: “எகிப்தியன் ஒருவன் மேய்ப்பர்களின் கைகளுக்கு எங்களைத் தப்புவித்து, எங்களுக்குத் தண்ணீர் எடுத்துக் கொடுத்து, ஆடுகளுக்கும் தண்ணீர் காட்டினான்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","அப்பொழுது அவன் தன்னுடைய மகள்களைப் பார்த்து, “அவன் எங்கே? அந்த மனிதனை நீங்கள் விட்டுவந்தது ஏன்? சாப்பிடும்படி அவனை அழைத்துக்கொண்டு வாருங்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","மோசே அந்த மனிதனிடம் தங்கியிருக்கச் சம்மதித்தான். அவன் சிப்போராள் என்னும் தன்னுடைய மகளை மோசேக்குக் கொடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","அவள் ஒரு மகனைப் பெற்றாள். “நான் அந்நிய தேசத்தில் பரதேசியாக இருக்கிறேன்” என்று சொல்லி, அவனுக்கு கெர்சோம் என்று பெயரிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","சிலகாலம் சென்றபின்பு, எகிப்தின் ராஜா இறந்தான். இஸ்ரவேலர்கள் அடிமைத்தனத்தினால் தவித்து, முறையிட்டுக்கொண்டிருந்தார்கள்; அவர்கள் அடிமைத்தனத்திலிருந்து முறையிடும் சத்தம் தேவசந்நிதியில் எட்டினது. ");
INSERT INTO tam2017_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","தேவன் அவர்கள் பெருமூச்சைக்கேட்டு, தாம் ஆபிரகாமோடும், ஈசாக்கோடும் யாக்கோபோடும் செய்த உடன்படிக்கையை நினைவுகூர்ந்தார். ");
INSERT INTO tam2017_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","தேவன் இஸ்ரவேலர்களைப் பார்த்தார்; தேவன் அவர்களை நினைத்தருளினார். ");
INSERT INTO tam2017_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","மோசே மீதியான் தேசத்தின் ஆசாரியனாக இருந்த தன்னுடைய மாமனாகிய எத்திரோவின் ஆடுகளை மேய்த்துவந்தான். அவன் ஆடுகளை வனாந்திரத்தில் தூரமாக நடத்தி, தேவனுடைய மலையாகிய ஓரேப்வரை வந்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","அங்கே யெகோவாவுடைய தூதன் ஒரு முட்செடியின் நடுவிலிருந்து உண்டான அக்கினித்தழலில் நின்று அவனுக்கு தரிசனமானார். அப்பொழுது அவன் உற்றுப்பார்த்தான்; முட்செடி அக்கினியால் பற்றி எரிந்தும், அது வெந்துபோகாமல் இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","அப்பொழுது மோசே: “இந்த முட்செடி வெந்துபோகாமல் இருக்கிறது ஏன், நான் அருகில் போய் இந்த அற்புதக்காட்சியைப் பார்ப்பேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","அவன் பார்க்கும்படி அருகில் வருகிறதைக் யெகோவா கண்டார். முட்செடியின் நடுவிலிருந்து தேவன் அவனை நோக்கி: “மோசே, மோசே” என்று கூப்பிட்டார். அவன்: “இதோ, அடியேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","அப்பொழுது அவர்: “இங்கே அருகில் வராமல் இரு; உன்னுடைய கால்களில் இருக்கிற காலணியைக் கழற்றிப்போடு; நீ நிற்கிற இடம் பரிசுத்த பூமி” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","பின்னும் அவர்: “நான் ஆபிரகாமின் தேவனும் ஈசாக்கின் தேவனும் யாக்கோபின் தேவனுமாகிய உன் பிதாக்களுடைய தேவனாக இருக்கிறேன்” என்றார். மோசே தேவனை நோக்கிப்பார்க்க பயந்ததால், தன்னுடைய முகத்தை மூடிக்கொண்டான். ");
INSERT INTO tam2017_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","அப்பொழுது யெகோவா: “எகிப்திலிருக்கிற என்னுடைய மக்களின் உபத்திரவத்தை நான் பார்த்து, மேற்பார்வையாளர்களால் அவர்கள் இடுகிற கூக்குரலைக் கேட்டேன், அவர்கள் படுகிற வேதனைகளையும் அறிந்திருக்கிறேன். ");
INSERT INTO tam2017_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","அவர்களை எகிப்தியர்களின் கைகளுக்கு விடுதலையாக்கவும், அவர்களை அந்த தேசத்திலிருந்து நீக்கி, கானானியர்களும், ஏத்தியர்களும், எமோரியர்களும், பெரிசியர்களும், ஏவியர்களும், எபூசியர்களும் இருக்கிற இடமாகிய செழிப்பான நலமும் விசாலமுமான தேசத்தில் கொண்டுபோய்ச் சேர்க்கவும் இறங்கினேன். ");
INSERT INTO tam2017_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","இப்பொழுதும் இஸ்ரவேல் மக்களின் கூக்குரல் என்னுடைய சந்நிதியில் வந்து எட்டினது; எகிப்தியர்கள் அவர்களை ஒடுக்குகிற ஒடுக்குதலையும் கண்டேன். ");
INSERT INTO tam2017_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","நீ இஸ்ரவேல் மக்களாகிய என்னுடைய மக்களை எகிப்திலிருந்து அழைத்துவரும்படி உன்னை பார்வோனிடம் அனுப்புவேன் வா” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","அப்பொழுது மோசே தேவனை நோக்கி: “பார்வோனிடம் போகவும், இஸ்ரவேலர்களை எகிப்திலிருந்து அழைத்துவரவும், நான் எம்மாத்திரம் என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","அதற்கு அவர்: “நான் உன்னோடு இருப்பேன்; நீ மக்களை எகிப்திலிருந்து அழைத்துவந்தபின்பு, நீங்கள் இந்த மலையில் தேவனுக்கு ஆராதனை செய்வீர்கள்; நான் உன்னை அனுப்பினேன் என்பதற்கு இதுவே அடையாளம்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","அப்பொழுது மோசே தேவனை நோக்கி: “நான் இஸ்ரவேலர்களிடம் போய், உங்கள் முன்னோர்களுடைய தேவன் உங்களிடம் என்னை அனுப்பினார் என்று அவர்களுக்குச் சொல்லும்போது, அவருடைய நாமம் என்ன என்று அவர்கள் என்னிடத்தில் கேட்டால், நான் அவர்களுக்கு என்ன சொல்லுவேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","அதற்கு தேவன்: “இருக்கிறவராக இருக்கிறேன் என்று மோசேயுடன் சொல்லி, இருக்கிறேன் என்பவர் என்னை உங்களிடத்திற்கு அனுப்பினார் என்று இஸ்ரவேலர்களுடன் சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","மேலும், தேவன் மோசேயை நோக்கி: “ஆபிரகாமின் தேவனும், ஈசாக்கின் தேவனும், யாக்கோபின் தேவனுமாக இருக்கிற உங்கள் முன்னோர்களுடைய தேவனாகிய யெகோவா என்னை உங்களிடம் அனுப்பினார் என்று நீ இஸ்ரவேலர்களுக்கு சொல்; என்றைக்கும் இதுவே என்னுடைய நாமம், தலைமுறை தலைமுறைதோறும் இதுவே என்றென்றைக்கும் என்னுடைய நாமம். ");
INSERT INTO tam2017_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","நீ போய், இஸ்ரவேலின் மூப்பர்களைக்கூட்டி, அவர்களிடத்தில்: ஆபிரகாம், ஈசாக்கு, யாக்கோபு என்பவர்களுடைய தேவனாக இருக்கிற உங்கள் முன்னோர்களுடைய தேவனாகிய யெகோவா எனக்கு தரிசனமாகி, உங்களை நிச்சயமாக சந்தித்து, எகிப்தில் உங்களுக்குச் செய்யப்பட்டதைக் கண்டேன் என்றும், ");
INSERT INTO tam2017_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","நான் உங்களை எகிப்தின் சிறுமையிலிருந்து நீக்கி, நல்ல விளைச்சல் உள்ள செழிப்பான தேசமாகிய கானானியர்கள், ஏத்தியர்கள், எமோரியர்கள், பெரிசியர்கள், ஏவியர்கள், எபூசியர்களுடைய தேசத்திற்குக் கொண்டுபோவேன் என்றும் சொன்னேன் என்று சொல். ");
INSERT INTO tam2017_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","அவர்கள் உன்னுடைய வார்த்தையை கேட்பார்கள்; அப்பொழுது நீயும் இஸ்ரவேலின் மூப்பர்களும் எகிப்தின் ராஜாவினிடம் போய்: எபிரெயர்களுடைய தேவனாகிய யெகோவா எங்களைச் சந்தித்தார்; இப்பொழுதும் நாங்கள் வனாந்திரத்தில் மூன்று நாட்கள் பயணம்போய், எங்கள் தேவனாகிய யெகோவாவுக்குப் பலியிடும்படி எங்களைப் போகவிடவேண்டுமென்று சொல்லுங்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","ஆனாலும், எகிப்து ராஜா என்னுடைய கையின் வல்லமையைக் கண்டாலொழிய, உங்களைப் போகவிடமாட்டான் என்று நான் அறிவேன். ");
INSERT INTO tam2017_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","ஆகையால், நான் என்னுடைய கையை நீட்டி, எகிப்தின் நடுவில் நான் செய்யும் எல்லாவித அற்புதங்களாலும் அதை வாதிப்பேன்; அதற்குப்பின்பு அவன் உங்களைப் போகவிடுவான். ");
INSERT INTO tam2017_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","அப்பொழுது இந்த மக்களுக்கு எகிப்தியர்களின் கண்களில் தயவு கிடைக்கச்செய்வேன்; நீங்கள் போகும்போது வெறுமையாகப் போவதில்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","ஒவ்வொரு பெண்ணும், தன்தன் அயலகத்தாளிடத்திலும் தன்தன் வீட்டில் தங்குகிறவளிடத்திலும், வெள்ளியையும், பொன் நகைகளையும், ஆடைகளையும் கேட்டு வாங்குவாள்; அவைகளை உங்களுடைய மகன்களுக்கும் உங்களுடைய மகள்களுக்கும் அணிவித்து, எகிப்தியர்களைக் கொள்ளையிடுவீர்கள்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","அப்பொழுது மோசே: “அவர்கள் என்னை நம்பமாட்டார்கள்; என்னுடைய வார்த்தையை கேட்கமாட்டார்கள்; யெகோவா உனக்குத் தரிசனமாகவில்லை என்று சொல்லுவார்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","யெகோவா அவனை நோக்கி: “உன்னுடைய கையில் இருக்கிறது என்ன” என்றார். “ஒரு கோல்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","“அதைத் தரையிலே போடு” என்றார்; அவன் அதைத் தரையிலே போட்டபோது, அது பாம்பாக மாறியது; மோசே அதற்கு விலகி ஓடினான். ");
INSERT INTO tam2017_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","அப்பொழுது யெகோவா மோசேயை நோக்கி: “உன்னுடைய கையை நீட்டி, அதின் வாலைப் பிடி” என்றார்; அவன் தன்னுடைய கையை நீட்டி, அதைப் பிடித்தபோது, அது அவனுடைய கையிலே கோலானது. ");
INSERT INTO tam2017_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","ஆபிரகாமின் தேவனும் ஈசாக்கின் தேவனும் யாக்கோபின் தேவனுமாக இருக்கிற தங்கள் முன்னோர்களுடைய தேவனாகிய யெகோவா உனக்கு தரிசனமானதை அவர்கள் நம்புவதற்கு இதுவே அடையாளம் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","மேலும், யெகோவா அவனை நோக்கி: “உன் கையை உன்னுடைய மடியிலே போடு” என்றார்; அவன் தன் கையைத் தன்னுடைய மடியிலே போட்டு, அதை வெளியே எடுக்கும்போது, இதோ, அவனுடைய கை உறைந்த பனியைப்போல வெண்குஷ்டம் பிடித்திருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","அவர்: “உன்னுடைய கையைத் திரும்பவும் உன்னுடைய உன் மடியிலே போடு” என்றார். அவன் தன்னுடைய கையைத் திரும்பத் தன்னுடைய மடியிலே போட்டு, மீண்டும் வெளியே எடுத்தபோது, அது திரும்ப அவனுடைய மற்றச் சதையைப்போலானது. ");
INSERT INTO tam2017_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","அப்பொழுது அவர்: “முந்தின அடையாளத்தை அவர்கள் கண்டு, உன்னை நம்பாமலும் உன்னுடைய வார்த்தைகளைக் கேட்காமலும்போனால், பிந்தின அடையாளத்தைக் கண்டு நம்புவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","இந்த இரண்டு அடையாளங்களையும் அவர்கள் நம்பாமலும், உன்னுடைய வார்த்தையைக் கேட்காமலும் இருந்தால், அப்பொழுது நீ நதியின் தண்ணீரை எடுத்து நிலத்தில் ஊற்று; நதியில் எடுத்த தண்ணீர் காய்ந்த நிலத்தில் இரத்தமாகும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","அப்பொழுது மோசே யெகோவாவை நோக்கி: “ஆண்டவரே, இதற்கு முன்பாவது, தேவரீர் உமது அடியேனோடு பேசினதற்குப் பின்பாவது நான் பேச்சில் வல்லவன் இல்லை; நான் திக்குவாயும் மந்த நாவும் உள்ளவன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","அப்பொழுது யெகோவா அவனை நோக்கி: “மனிதனுக்கு வாயை உண்டாக்கியவர் யார்? ஊமையனையும், செவிடனையும், பார்வையுள்ளவனையும், பார்வையற்றவனையும் உண்டாக்கினவர் யார்? யெகோவாவாகிய நான் அல்லவா? ");
INSERT INTO tam2017_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","ஆதலால், நீ போ; நான் உன்னுடைய வாயோடு இருந்து, நீ பேசவேண்டியதை உனக்குப் போதிப்பேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","அதற்கு அவன்: “ஆண்டவரே. நீர் அனுப்ப விரும்புகிற யாரையாவது அனுப்பும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","அப்பொழுது யெகோவா மோசேயின்மேல் கோபப்பட்டு: “லேவியனாகிய ஆரோன் உன்னுடைய சகோதரன் அல்லவா? அவன் நன்றாக பேசுகிறவன் என்று அறிவேன்; அவன் உன்னைச் சந்திக்கப் புறப்பட்டு வருகிறான்; உன்னைக் காணும்போது அவனுடைய இருதயம் மகிழும். ");
INSERT INTO tam2017_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","நீ அவனுடன் பேசி, அவன் வாயில் வார்த்தைகளைப் போடு; நான் உன்னுடைய வாயிலும் அவனுடைய வாயிலும் இருந்து, நீங்கள் செய்யவேண்டியதை உங்களுக்குக் காட்டுவேன். ");
INSERT INTO tam2017_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","அவன் உனக்குப் பதிலாக மக்களோடு பேசுவான்; இந்தவிதமாக அவன் உனக்கு வாயாக இருப்பான்; நீ அவனுக்கு தேவனாக இருப்பாய். ");
INSERT INTO tam2017_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","இந்தக் கோலையும் உன்னுடைய கையிலே பிடித்துக்கொண்டுபோ, இதனால் நீ அடையாளங்களைச் செய்வாய்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","மோசே தன்னுடைய மாமனாகிய எத்திரோவிடம் வந்து: “நான் எகிப்திலிருக்கிற என்னுடைய சகோதரர்களிடத்திற்குத் திரும்பிப்போய், அவர்கள் இன்னும் உயிரோடு இருக்கிறார்களா என்று பார்க்கும்படிப் புறப்பட்டுப்போக உத்திரவு தரவேண்டும்” என்றான். அப்பொழுது எத்திரோ மோசேயை நோக்கி: “சுகமாகப் போய்வாரும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","பின்னும் யெகோவா மீதியானிலே மோசேயை நோக்கி: “நீ எகிப்திற்குத் திரும்பிப் போ, உன்னுடைய உயிரை எடுக்கத்தேடின மனிதர்கள் எல்லோரும் இறந்துபோனார்கள்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","அப்பொழுது மோசே தன்னுடைய மனைவியையும் தன்னுடைய பிள்ளைகளையும் கழுதையின் மேல் ஏற்றிக்கொண்டு, எகிப்து தேசத்திற்குத் திரும்பினான்; தேவனுடைய கோலையும் மோசே தன்னுடைய கையிலே பிடித்துக்கொண்டு போனான். ");
INSERT INTO tam2017_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","அப்பொழுது யெகோவா மோசேயை நோக்கி: “நீ எகிப்திலே திரும்பிப்போய்ச் சேர்ந்தபின்பு, நான் உன்னுடைய கையில் கொடுத்திருக்கிற அற்புதங்கள் யாவையும் பார்வோனுக்கு முன்பாக செய்யும்படி எச்சரிக்கையாக இரு; ஆனாலும், நான் அவனுடைய இருதயத்தைக் கடினப்படுத்துவேன்; அவன் மக்களைப் போகவிடமாட்டான். ");
INSERT INTO tam2017_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","அப்பொழுது நீ பார்வோனோடு சொல்லவேண்டியது என்னவென்றால்: இஸ்ரவேல் என்னுடைய மகன், என்னுடைய மூத்தமகன். ");
INSERT INTO tam2017_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","எனக்கு ஆராதனை செய்யும்படி என்னுடைய மகனை அனுப்பிவிடு என்று கட்டளையிடுகிறேன்; அவனை விடமாட்டேன் என்று சொன்னால் நான் உன்னுடைய மகனை, உன்னுடைய மூத்தமகனை கொல்லுவேன் என்று யெகோவா சொன்னார் என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","வழியிலே தங்கும் இடத்தில் யெகோவா மோசேக்கு எதிராக வந்து, அவனைக் கொல்லநினைத்தார். ");
INSERT INTO tam2017_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","அப்பொழுது சிப்போராள் ஒரு கூர்மையான கல்லை எடுத்து, தன் மகனுடைய நுனித்தோலை அறுத்து, அதை அவனுடைய கால்களுக்கு முன்பாக போட்டு: “நீர் எனக்கு இரத்தசம்பந்தமான கணவன்” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","பின்பு அவர் அவனைவிட்டு விலகினார். அப்பொழுது அவள்: “விருத்தசேதனத்தினால் நீர் எனக்கு இரத்தசம்பந்தமான கணவன்” என்றாள். ");
INSERT INTO tam2017_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","ஆரோனை நோக்கி: “நீ வனாந்திரத்தில் மோசேயை சந்திக்கப்போ” என்றார். அவன் போய், தேவனுடைய மலையில் அவனைச் சந்தித்து, அவனை முத்தமிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","அப்பொழுது மோசே தன்னை அனுப்பின யெகோவாவுடைய எல்லா வார்த்தைகளையும் அவர் தனக்குக் கட்டளையிட்ட எல்லா அடையாளங்களையும் ஆரோனுக்குத் தெரிவித்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","மோசேயும் ஆரோனும் போய், இஸ்ரவேலர்களுடைய மூப்பர்கள் எல்லோரையும் கூடிவரச் செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","யெகோவா மோசேக்குச் சொல்லிய எல்லா வார்த்தைகளையும் ஆரோன் சொல்லி, மக்களின் கண்களுக்கு முன்பாக அந்த அடையாளங்களையும் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","மக்கள் விசுவாசித்தார்கள்; யெகோவா இஸ்ரவேலர்களைச் சந்தித்தார் என்றும், அவர்களுடைய உபத்திரவங்களைக் கண்ணோக்கிப் பார்த்தார் என்றும், அவர்கள் கேட்டபோது, தலைகுனிந்து தொழுதுகொண்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","பின்பு, மோசேயும் ஆரோனும் பார்வோனிடம் போய்: “இஸ்ரவேலின் தேவனாகிய யெகோவா வனாந்திரத்திலே எனக்குப் பண்டிகை கொண்டாடும்படி என்னுடைய மக்களைப் போகவிடவேண்டும் என்று சொல்லுகிறார்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","அதற்குப் பார்வோன்: “நான் இஸ்ரவேலைப் போகவிடக் யெகோவாவின் வார்த்தையைக் கேட்கிறதற்கு அவர் யார்? எனக்கு யெகோவாவை தெரியாது; நான் இஸ்ரவேலைப் போகவிடமாட்டேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","அப்பொழுது அவர்கள்: “எபிரெயர்களுடைய தேவன் எங்களைச் சந்தித்தார்; நாங்கள் வனாந்திரத்தில் மூன்றுநாட்கள் பயணமாக போய், எங்கள் தேவனாகிய யெகோவாவிற்கு பலியிடும்படி போகவிடவேண்டும்; போகாமலிருந்தால், அவர் கொள்ளைநோயையும், பட்டயத்தையும் எங்கள்மேல் வரச்செய்வார்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","எகிப்தின் ராஜா அவர்களை நோக்கி: “மோசேயும் ஆரோனுமாகிய நீங்கள் மக்களைத் தங்களுடைய வேலைகளைவிட்டுக் கலையச்செய்கிறது என்ன? உங்கள் சுமைகளைச் சுமக்கப்போங்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","பின்னும் பார்வோன்: “இதோ, தேசத்தில் மக்கள் மிகுதியாக இருக்கிறார்கள்; அவர்கள் சுமை சுமக்கிறதைவிட்டு ஓய்ந்திருக்கும்படி செய்கிறீர்களே” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","அன்றியும், அந்த நாளிலே பார்வோன் மக்களின் மேற்பார்வையாளர்களையும் அவர்களுடைய தலைவர்களையும் நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“செங்கல் வேலைக்கு நீங்கள் முன்போல இனி மக்களுக்கு வைக்கோல் கொடுக்கவேண்டாம்; அவர்கள் தாங்களே போய்த் தங்களுக்கு வைக்கோல் சேர்க்கட்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","அவர்கள் முன்பு செய்துகொடுத்த கணக்கின்படியே செங்கல் செய்யும்படி சொல்லுங்கள்; அதிலே நீங்கள் ஒன்றும் குறைக்கவேண்டாம், அவர்கள் சோம்பேறிகளாக இருக்கிறார்கள்; அதினால் நாங்கள் போய் எங்களுடைய தேவனுக்குப் பலியிடுவோம் என்று கூக்குரலிடுகிறார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","அந்த மனிதர்கள்மேல் முன்பைவிட அதிக வேலையைச் சுமத்துங்கள், அதில் அவர்கள் கஷ்டப்படட்டும்; அவர்கள் வீண்வார்த்தைகளைக் கேட்கவிடாதீர்கள்” என்று கட்டளையிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","அப்பொழுது மக்களின் மேற்பார்வையாளர்களும் அவர்கள் தலைவர்களும் புறப்பட்டுப்போய் மக்களை நோக்கி: “உங்களுக்கு வைக்கோல் கொடுப்பதில்லை; ");
INSERT INTO tam2017_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","நீங்களே போய் உங்களுக்கு கிடைக்கிற இடங்களில் வைக்கோல் சேகரியுங்கள்; ஆனாலும் உங்களுடைய வேலையில் ஒன்றும் குறைக்கப்படுவதில்லை என்று பார்வோன் சொல்லுகிறார்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","அப்பொழுது வைக்கோலுக்குப் பதிலாக அதின் தாளடிகளைச் சேர்க்கும்படி மக்கள் எகிப்துதேசம் எங்கும் அலைந்து திரிந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","மேற்பார்வையாளர்கள் அவர்களை நோக்கி: வைக்கோல் இருந்த நாளில் செய்தபடியே உங்கள் வேலைகளை ஒவ்வொரு நாளிலும் செய்து முடியுங்கள் என்று சொல்லி, அவர்களைத் அவசரப்படுத்தினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","பார்வோனுடைய மேற்பார்வையாளர்கள் இஸ்ரவேலர்கள் மேல்வைத்த அவர்களுடைய தலைவர்களை நோக்கி: “செங்கல் வேலையில் நீங்கள் முன்பு செய்ததுபோல நேற்றும் இன்றும் ஏன் செய்யவில்லை” என்று கேட்டு, அவர்களை அடித்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","அப்பொழுது இஸ்ரவேலர்களின் தலைவர்கள் பார்வோனிடம் போய் கூக்குரலிட்டு: “உமது அடியார்களுக்கு நீர் இப்படிச் செய்கிறது என்ன? ");
INSERT INTO tam2017_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","உமது அடியார்களுக்கு வைக்கோல் கொடுக்காமல் இருந்தும், செங்கல் அறுக்கவேண்டும் என்று எங்களுக்குச் சொல்லுகிறார்கள்; உம்முடைய மக்களிடம் குற்றம் இருக்க, உமது அடியார்களாகிய நாங்கள் அடிக்கப்படுகிறோம்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","அதற்கு அவன்: “நீங்கள் சோம்பேறிகளாக இருக்கிறீர்கள்; அதினால்தான் போகவேண்டும், யெகோவாவுக்குப் பலியிடவேண்டும் என்கிறீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","போய், வேலை செய்யுங்கள், உங்களுக்கு வைக்கோல் கொடுக்கப்படுவதில்லை; ஆனாலும் கணக்கின்படியே நீங்கள் செங்கலை அறுத்துக் கொடுக்கவேண்டும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","நீங்கள் ஒவ்வொரு நாளிலும் அறுக்கவேண்டிய செங்கலிலே ஒன்றும் குறைக்கக்கூடாது என்று சொல்லப்பட்டதால், இஸ்ரவேலர்களின் தலைவர்கள் தங்களுக்கு இக்கட்டு வந்தது என்று கண்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","அவர்கள் பார்வோனுடைய சமுகத்தை விட்டுப் புறப்படும்போது, வழியில் நின்ற மோசேக்கும் ஆரோனுக்கும் எதிர்ப்பட்டு, ");
INSERT INTO tam2017_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","அவர்களை நோக்கி: “நீங்கள் பார்வோனின் கண்களுக்கு முன்பாகவும் அவருடைய வேலைக்காரர்களின் கண்களுக்கு முன்பாகவும் எங்களுடைய வாசனையைக் கெடுத்து, எங்களைக் கொல்லும்படி அவர்களுடைய கையிலே பட்டயத்தைக் கொடுத்ததால், யெகோவா உங்களைப் பார்த்து நியாயம் தீர்க்கக்கடவர்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","அப்பொழுது மோசே யெகோவாவிடம் திரும்பிப்போய்: “ஆண்டவரே, இந்த மக்களுக்குத் தீங்குவரச்செய்ததென்ன? ஏன் என்னை அனுப்பினீர்? ");
INSERT INTO tam2017_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","நான் உமது நாமத்தைக்கொண்டு பேசும்படி பார்வோனிடம் சென்றதுமுதல் அவன் இந்த மக்களை உபத்திரவப்படுத்துகிறான்; நீர் உம்முடைய மக்களை விடுதலையாக்கவில்லையே” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","அப்பொழுது யெகோவா மோசேயை நோக்கி: “நான் பார்வோனுக்குச் செய்வதை இப்பொழுது காண்பாய்; என் வலிமையான கையைக் கண்டு அவர்களைப் போகவிட்டு, அவர்களைத் தன்னுடைய தேசத்திலிருந்து துரத்திவிடுவான்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","மேலும், தேவன் மோசேயை நோக்கி: “நான் யேகோவா, ");
INSERT INTO tam2017_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","சர்வவல்லமையுள்ள தேவன் என்னும் நாமத்தினால் நான் ஆபிரகாமுக்கும் ஈசாக்குக்கும் யாக்கோபுக்கும் தரிசனமானேன்; ஆனாலும் யேகோவா என்னும் என்னுடைய நாமத்தினால் நான் அவர்களுக்கு அறியப்படவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","அவர்கள் பரதேசிகளாகத் தங்கின தேசமாகிய கானான்தேசத்தை அவர்களுக்குக் கொடுப்பேன் என்று நான் அவர்களோடு என்னுடைய உடன்படிக்கையையும் ஏற்படுத்தியிருக்கிறேன். ");
INSERT INTO tam2017_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","எகிப்தியர்கள் அடிமையாக வைத்திருக்கிற இஸ்ரவேலர்களின் பெருமூச்சையும் நான் கேட்டு, என்னுடைய உடன்படிக்கையை நினைத்தேன். ");
INSERT INTO tam2017_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","ஆதலால், இஸ்ரவேலர்களை நோக்கி: நானே யெகோவா, உங்கள்மேல் எகிப்தியர்கள் சுமத்தின சுமைகளை நீக்கி நான் உங்களை விடுவித்து, உங்களை அவர்கள் அடிமைத்தனத்திற்கு, நீங்கலாக்கி, பலத்த கையினாலும், மகா தண்டனைகளினாலும் உங்களை மீட்டு, ");
INSERT INTO tam2017_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","உங்களை எனக்கு மக்களாகச் சேர்த்துக்கொண்டு, உங்களுக்கு தேவனாக இருப்பேன்; உங்கள்மேல் எகிப்தியர்கள் சுமத்தின சுமைகளை நீக்கி உங்களை விடுவிக்கிற உங்களுடைய தேவனாகிய யெகோவா நான் என்று அறிவீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","ஆபிரகாமுக்கும் ஈசாக்குக்கும் யாக்கோபுக்கும் கொடுப்பேன் என்று நான் ஆணையிட்ட தேசத்தில் உங்களைக் கொண்டுபோய், அதை உங்களுக்குச் சொந்தமாகக் கொடுப்பேன்; நான் யெகோவா என்று அவர்களுக்குச் சொல் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","இப்படியாக மோசே இஸ்ரவேலர்களுக்குச் சொன்னான்; அவர்களோ மனவருத்தத்தாலும் கொடுமையான வேலையாலும் மோசேயின் வார்த்தைகளை கேட்காமற்போனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","பின்பு, யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“நீ எகிப்தின் ராஜாவாகிய பார்வோனிடம் போய், அவன் தன்னுடைய தேசத்திலிருந்து இஸ்ரவேல் மக்களைப் போகவிடும்படி அவனுடன் பேசு” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","மோசே யெகோவாவுடைய சந்நிதானத்தில் நின்று, “இஸ்ரவேலர்களே நான் சொல்வதைக் கேட்கவில்லை; பார்வோன் எப்படி நான் சொல்வதைக் கேட்பான்? நான் திக்கு வாயுள்ளவன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","யெகோவா மோசேயோடும் ஆரோனோடும் பேசி, இஸ்ரவேலர்களை எகிப்து தேசத்திலிருந்து அழைத்துக்கொண்டு போகும்படி, அவர்களை இஸ்ரவேலர்களிடத்திற்கும் எகிப்தின் ராஜாவாகிய பார்வோனிடத்திற்கும் கட்டளைக் கொடுத்து அனுப்பினார். ");
INSERT INTO tam2017_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","அவர்களுடைய தகப்பன்மார்களுடைய வீட்டார்களின் தலைவர்கள் யாரென்றால், இஸ்ரவேலுக்கு முதலில் பிறந்தவனாகிய ரூபனுடைய மகன்கள் ஆனோக்கு, பல்லூ, எஸ்ரோன், கர்மீ; இவர்கள் ரூபனுடைய வம்சங்களின் தலைவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","சிமியோனின் மகன்கள் எமுவேல், யாமின், ஓகாத், யாகீன், சோகார், கானானிய பெண்ணின் மகனாகிய சவுல்; சிமியோனுடைய வம்சங்களின் தலைவர்கள் இவர்களே. ");
INSERT INTO tam2017_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","வம்சப்பட்டியலின்படி பிறந்த லேவியின் மகன்களுடைய பெயர்கள், கெர்சோன், கோகாத், மெராரி என்பவைகள். லேவி நூற்றுமுப்பத்தேழு வருடங்கள் உயிரோடு இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","அவரவர் வம்சங்களின்படி பிறந்த கெர்சோனின் மகன்கள் லிப்னி, சீமேயி என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","கோகாத்தின் மகன்கள் அம்ராம், இத்சேயார், எப்ரோன், ஊசியேல் என்பவர்கள்; கோகாத் நூற்றுமுப்பத்துமூன்று வருடங்கள் உயிரோடு இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","மெராரியின் மகன்கள் மகேலி, மூசி என்பவர்கள்; அவரவர் சந்ததியின்படி லேவியினுடைய வம்சங்களின் தலைவர்கள் இவர்களே. ");
INSERT INTO tam2017_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","அம்ராம் தன்னுடைய அத்தையாகிய யோகெபேத்தைத் திருமணம் செய்தான்; அவள் அவனுக்கு ஆரோனையும் மோசேயையும் பெற்றாள்; அம்ராம் நூற்றுமுப்பத்தேழு வருடங்கள் உயிரோடு இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","இத்சேயாரின் மகன்கள் கோராகு, நெப்பேக், சிக்ரி என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","ஊசியேலின் மகன்கள் மீசாயேல், எல்சாபான், சித்ரி என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","ஆரோன் அம்மினதாபின் மகளும் நகசோனின் சகோதரியுமாகிய எலிசபாளை திருமணம் செய்தான்; இவள் அவனுக்கு நாதாபையும், அபியூவையும், எலெயசரையும், இத்தாமாரையும் பெற்றாள். ");
INSERT INTO tam2017_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","கோராகின் மகன்கள் ஆசீர், எல்க்கானா, அபியாசாப் என்பவர்கள்; கோராகியர்களின் வம்சத்தலைவர்கள் இவர்களே. ");
INSERT INTO tam2017_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","ஆரோனின் மகனாகிய எலெயாசார் பூத்தியேலுடைய மகள்களில் ஒருத்தியைத் திருமணம் செய்தான், அவள் அவனுக்குப் பினெகாசைப் பெற்றாள்; அவரவர் வம்சங்களின்படி லேவியர்களுடைய தகப்பன்மார்களாகிய தலைவர்கள் இவர்களே. ");
INSERT INTO tam2017_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","இஸ்ரவேலர்களை அணியணியாக எகிப்து தேசத்திலிருந்து நடத்திக்கொண்டு போவதற்குக் யெகோவால் கட்டளை” பெற்ற ஆரோனும் மோசேயும் இவர்களே. ");
INSERT INTO tam2017_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","இஸ்ரவேலர்களை எகிப்திலிருந்து நடத்திக்கொண்டு போவதற்கு, எகிப்தின் ராஜாவாகிய பார்வோனோடு பேசின மோசேயும் ஆரோனும் இவர்களே. ");
INSERT INTO tam2017_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","யெகோவா எகிப்துதேசத்தில் மோசேயோடு பேசின நாளில்; ");
INSERT INTO tam2017_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","யெகோவா மோசேயை நோக்கி: “நானே யெகோவா; நான் உன்னோடு சொல்லுகிறவைகளையெல்லாம் நீ எகிப்து ராஜாவாகிய பார்வோனுக்குச் சொல்” என்று சொன்னபோது, ");
INSERT INTO tam2017_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","மோசே யெகோவாவுடைய சந்நிதானத்தில்: “நான் விருத்தசேதனமில்லாத உதடுகளுள்ளவன்; பார்வோன் எப்படி என்னுடைய சொல்லைக் கேட்பான் என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","யெகோவா மோசேயை நோக்கி: “பார், உன்னை நான் பார்வோனுக்கு தேவனாக்கினேன்; உன் சகோதரனாகிய ஆரோன் உன்னுடைய தீர்க்கதரிசியாக இருப்பான். ");
INSERT INTO tam2017_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","நான் உனக்குக் கட்டளையிடும் யாவையும் நீ சொல்லவேண்டும்; பார்வோன் இஸ்ரவேல் மக்களைத் தன்னுடைய தேசத்திலிருந்து அனுப்பிவிடும்படி உன்னுடைய சகோதரனாகிய ஆரோன் அவனிடம் பேசவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","நான் பார்வோனின் இருதயத்தைக் கடினப்படுத்தி, எகிப்துதேசத்தில் என்னுடைய அடையாளங்களையும் அற்புதங்களையும் மிகுதியாக நடப்பிப்பேன். ");
INSERT INTO tam2017_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","பார்வோன் உங்களுடைய சொல்லைக்கேட்கமாட்டான்; ஆகையால் எகிப்திற்கு விரோதமாக நான் என்னுடைய கையை நீட்டி, கொடிய தண்டனையினால் என்னுடைய சேனைகளும் என்னுடைய மக்களுமாகிய இஸ்ரவேல் மக்களை எகிப்து தேசத்திலிருந்து புறப்படச்செய்வேன். ");
INSERT INTO tam2017_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","நான் எகிப்தின்மேல் என்னுடைய கையை நீட்டி, இஸ்ரவேலர்களை அவர்கள் நடுவிலிருந்து புறப்படச்செய்யும்போது, நானே யெகோவா என்று எகிப்தியர்கள் அறிவார்கள்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","மோசேயும் ஆரோனும் யெகோவா தங்களுக்குக் கட்டளையிட்டபடியே செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","அவர்கள் பார்வோனோடு பேசும்போது, மோசேக்கு எண்பது வயதும், ஆரோனுக்கு எண்பத்துமூன்று வயதுமாக இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","யெகோவா மோசேயையும் ஆரோனையும் நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“உங்களை ஒரு அற்புதம் காட்டுங்கள் என்று பார்வோன் உங்களோடு சொன்னால்; அப்பொழுது நீ ஆரோனை நோக்கி: உன்னுடைய கோலை எடுத்து அதைப் பார்வோனுக்கு முன்பாகப் போடு என்பாயாக; அது பாம்பாகும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","மோசேயும் ஆரோனும் பார்வோனிடம் போய், யெகோவா தங்களுக்குக் கட்டளையிட்டபடி செய்தார்கள். ஆரோன் பார்வோனுக்கு முன்பாகவும், அவனுடைய வேலைக்காரர்களுக்கு முன்பாகவும் தன்னுடைய கோலைப் போட்டான், அது பாம்பானது. ");
INSERT INTO tam2017_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","அப்பொழுது பார்வோன் ஞானிகளையும், சூனியக்காரர்களையும் அழைத்தான். எகிப்தின் மந்திரவாதிகளும் தங்கள் மந்திரவித்தையினால் அப்படிச் செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","அவர்கள் ஒவ்வொருவனாகத் தன் தன் கோலைப் போட்டபோது, அவைகள் பாம்புகளாயின; ஆரோனுடைய கோலோ அவர்களுடைய கோல்களை விழுங்கியது. ");
INSERT INTO tam2017_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","யெகோவா சொல்லியிருந்தபடி பார்வோனின் இருதயம் கடினப்பட்டது, அவர்களுடைய சொல்லைக் கேட்காமற்போனான். ");
INSERT INTO tam2017_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","அப்பொழுது யெகோவா மோசேயை நோக்கி: “பார்வோனின் இருதயம் கடினமானது; மக்களை விடமாட்டேன் என்கிறான். ");
INSERT INTO tam2017_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","காலையில் நீ பார்வோனிடம் போ, அவன் நதிக்குப் புறப்பட்டு வருவான்; நீ அவனுக்கு எதிராக நதியோரத்தில் நின்று, பாம்பாக மாறின கோலை உன்னுடைய கையிலே பிடித்துக்கொண்டு, ");
INSERT INTO tam2017_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","அவனை நோக்கி: வனாந்திரத்தில் எனக்கு ஆராதனைசெய்ய என்னுடைய மக்களை அனுப்பிவிடவேண்டும் என்று சொல்லும்படி எபிரெயர்களுடைய தேவனாகிய யெகோவா என்னை உம்மிடத்திற்கு அனுப்பியும், இது வரைக்கும் நீர் கேட்காமற்போனீர். ");
INSERT INTO tam2017_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","இதோ, என்னுடைய கையில் இருக்கிற கோலால் நதியில் இருக்கிற தண்ணீர்மேல் அடிப்பேன்; அப்பொழுது அது இரத்தமாக மாறி, ");
INSERT INTO tam2017_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","நதியில் இருக்கிற மீன்கள் செத்து, நதி நாறிப்போகும்; அப்பொழுது நதியில் இருக்கிற தண்ணீரை எகிப்தியர்கள் குடிக்கமுடியாமல் அருவருப்பார்கள்; இதினால் நானே யெகோவா என்பதை அறிந்துகொள்வாய் என்று யெகோவா சொல்லுகிறார்” என்று சொல் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","மேலும், யெகோவா மோசேயை நோக்கி: “நீ ஆரோனிடம் உன்னுடைய கோலை எடுத்துக்கொண்டு எகிப்தின் நீர்நிலைகளாகிய அவர்கள் வாய்க்கால்கள்மேலும், நதிகள்மேலும், குளங்கள்மேலும், தண்ணீர் நிற்கிற எல்லா இடங்கள்மேலும், அவைகள் இரத்தமாகும்படி, உன்னுடைய கையை நீட்டு; அப்பொழுது எகிப்து தேசம் எங்கும் மரப்பாத்திரங்களிலும், கற்பாத்திரங்களிலும் இரத்தம் உண்டாகும் என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","யெகோவா கட்டளையிட்டபடி மோசேயும் ஆரோனும் செய்தார்கள்; பார்வோனுடைய கண்களுக்கு முன்பாகவும், அவனுடைய வேலைக்காரர்களின் கண்களுக்கு முன்பாகவும் கோலை ஓங்கி, நதியிலுள்ள தண்ணீரை அடிக்க, நதியிலுள்ள தண்ணீரெல்லாம் இரத்தமாக மாறியது. ");
INSERT INTO tam2017_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","நதியின் மீன்கள் செத்து, நதி நாறிப்போனது; நதியின் தண்ணீரைக் குடிக்க எகிப்தியர்களுக்கு முடியாமற்போனது; எகிப்து தேசம் எங்கும் இரத்தமாக இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","எகிப்தின் மந்திரவாதிகளும் தங்கள் மந்திரவித்தையினால் அப்படிச் செய்தார்கள்; யெகோவா சொல்லியிருந்தபடி பார்வோனின் இருதயம் கடினப்பட்டது; அவர்களுடைய வார்த்தைகளை கேட்காமற்போனான். ");
INSERT INTO tam2017_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","பார்வோன் இதையும் சிந்திக்காமல், தன்னுடைய வீட்டிற்குத் திரும்பிப்போனான். ");
INSERT INTO tam2017_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","நதியின் தண்ணீர் குடிக்க உதவாதபடியால், குடிக்கத்தக்க தண்ணீருக்காக எகிப்தியர்கள் எல்லோரும் நதியோரத்தில் ஊற்று தோண்டினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","யெகோவா நதியை அடித்து ஏழுநாட்கள் ஆனது. ");
INSERT INTO tam2017_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","அப்பொழுது யெகோவா மோசேயை நோக்கி: “நீ பார்வோனிடம் போய்: “எனக்கு ஆராதனைசெய்ய என்னுடைய மக்களை அனுப்பிவிடு. ");
INSERT INTO tam2017_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","நீ அவர்களை அனுப்பிவிடமாட்டேன் என்று சொன்னால், உன்னுடைய எல்லை முழுவதும் தவளைகளால் வாதிப்பேன். ");
INSERT INTO tam2017_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","நதி தவளைகளைத் திரளாக பிறப்பிக்கும்; அவைகள் உன்னுடைய வீட்டிலும் படுக்கை அறையிலும், படுக்கையின்மேலும், வேலைக்காரர்களுடைய வீடுகளிலும், மக்களிடத்திலும், அடுப்புகளிலும், மாவுபிசைகிற உன்னுடைய பாத்திரங்களிலும் வந்து ஏறும். ");
INSERT INTO tam2017_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","அந்தத் தவளைகள் உன்மேலும், உன்னுடைய மக்கள்மேலும், வேலைக்காரர்கள் எல்லோர்மேலும் வந்து ஏறும் என்று யெகோவா சொல்லுகிறார் என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","மேலும் யெகோவா மோசேயிடம் நீ ஆரோனை நோக்கி:” நீ உன்னுடைய கையில் இருக்கிற கோலை நதிகள்மேலும், வாய்க்கால்கள்மேலும், குளங்கள்மேலும் நீட்டி, எகிப்துதேசத்தின்மேல் தவளைகளை வரும்படிச் செய் என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","அப்படியே ஆரோன் தன்னுடைய கையை எகிப்திலுள்ள தண்ணீர்கள்மேல் நீட்டினான்; அப்பொழுது தவளைகள் வந்து, எகிப்து தேசத்தை மூடிக்கொண்டது. ");
INSERT INTO tam2017_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","மந்திரவாதிகளும் தங்களுடைய மந்திரவித்தையினால் அப்படிச் செய்து, எகிப்து தேசத்தின்மேல் தவளைகளை வரச்செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","பார்வோன் மோசேயையும் ஆரோனையும் அழைத்து: “அந்தத் தவளைகள் என்னையும் என்னுடைய மக்களையும்விட்டு நீங்கும்படி யெகோவாவை நோக்கி வேண்டிக்கொள்ளுங்கள்; யெகோவாவுக்குப் பலியிடும்படி மக்களைப் போகவிடுவேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","அப்பொழுது மோசே பார்வோனை நோக்கி: “தவளைகள் நதியிலே மட்டும் இருக்கும்படி அவைகளை உம்மிடத்திலும் உம்முடைய வீட்டிலும் இல்லாமல் ஒழிந்துபோகும்படிச் செய்ய, உமக்காகவும் உம்முடைய வேலைக்காரர்களுக்காகவும் உம்முடைய மக்களுக்காகவும் நான் விண்ணப்பம் செய்யவேண்டிய காலத்தைக் குறிக்கும் மேன்மை உமக்கே இருப்பதாக” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","அதற்கு அவன்: “நாளைக்கு என்றான். அப்பொழுது இவன்: “எங்கள் தேவனாகிய யெகோவாவுக்கு ஒப்பானவர் இல்லை என்பதை நீர் அறியும்படி உம்முடைய வார்த்தையின்படி ஆகட்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","தவளைகள் உம்மையும், உம்முடைய வீட்டையும், உம்முடைய வேலைக்காரர்களையும், உம்முடைய மக்களையும்விட்டு நீங்கி, நதியிலே மட்டும் இருக்கும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","மோசேயும் ஆரோனும் பார்வோனைவிட்டுப் புறப்பட்டார்கள். பார்வோனுக்கு எதிராக வரச்செய்த தவளைகளினால் மோசே யெகோவாவை நோக்கிக் கூப்பிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","யெகோவா மோசேயின் சொற்படிச் செய்தார்; வீடுகளிலும் முற்றங்களிலும் வயல்களிலும் இருந்த தவளைகள் செத்துப்போனது. ");
INSERT INTO tam2017_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","அவைகளைக் குவியல் குவியலாகச் சேர்த்தார்கள்; அதினால் பூமியெங்கும் நாற்றம் எடுத்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","இலகுவுண்டாயிற்றென்று பார்வோன் கண்டபோதோ, தன்னுடைய இருதயத்தைக் கடினப்படுத்தி, அவர்களுடைய சொல்லைக் கேட்காமற்போனான்; யெகோவா சொல்லியிருந்தபடியே ஆனது. ");
INSERT INTO tam2017_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","அப்பொழுது யெகோவா மோசேயிடம் நீ ஆரோனை நோக்கி: “உன்னுடைய கோலை நீட்டி, பூமியின் புழுதியின்மேல் அடி; அப்பொழுது அது எகிப்து தேசம் முழுவதும் பேன்களாகப்போகும் என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","அப்படியே செய்தார்கள்; ஆரோன் தன்னுடைய கையில் இருந்த தன்னுடைய கோலை நீட்டி, பூமியின் புழுதியின்மேல் அடித்தான்; அப்பொழுது அது மனிதர்கள்மேலும், மிருகஜீவன்கள்மேலும், எகிப்து தேசம் எங்கும் பூமியின் புழுதியெல்லாம் பேன்களானது. ");
INSERT INTO tam2017_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","மந்திரவாதிகளும் தங்களுடைய மந்திரவித்தையினால் பேன்களை உருவாக்கும்படி முயற்சிசெய்தார்கள்; அப்படிச்செய்தும், அவர்களால் முடியாமற்போனது; பேன்கள் மனிதர்கள்மேலும் மிருகஜீவன்கள்மேலும் இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","அப்பொழுது மந்திரவாதிகள் பார்வோனை நோக்கி: “இது தேவனுடைய விரல்” என்றார்கள். ஆனாலும், யெகோவா சொல்லிருந்தபடி பார்வோனுடைய இருதயம் கடினப்பட்டது; அவர்களுடைய சொல்லைக் கேட்காமற்போனான். ");
INSERT INTO tam2017_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","அப்பொழுது யெகோவா மோசேயை நோக்கி: “நாளை அதிகாலையில் நீ எழுந்து போய், பார்வோன் நதிக்குப் புறப்பட்டு வரும்போது, அவனுக்கு முன்பாக நின்று: எனக்கு ஆராதனை செய்யும்படி என்னுடைய மக்களைப் போகவிடு. ");
INSERT INTO tam2017_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","என்னுடைய மக்களைப் போகவிடாமல் இருந்தால், நான் உன்மேலும், உன்னுடைய வேலைக்காரர்கள்மேலும், மக்கள்மேலும், வீடுகள்மேலும் பலவித வண்டுகளை அனுப்புவேன்; எகிப்தியர்களுடைய வீடுகளும் அவர்கள் இருக்கிற தேசமும் அந்த வண்டுகளால் நிறையும். ");
INSERT INTO tam2017_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","பூமியின் நடுவில் நானே யெகோவா என்பதை நீ அறியும்படி என்னுடைய மக்கள் இருக்கிற கோசேன் நாட்டில் அந்த நாட்களிலே வண்டுகள் வராதபடி, அந்த நாட்டை தனிப்படுத்தி, ");
INSERT INTO tam2017_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","என்னுடைய மக்களுக்கும் உன்னுடைய மக்களுக்கும் வித்தியாசம் உண்டாகும்படி செய்வேன்; இந்த அடையாளம் நாளைக்கு உண்டாகும் என்று யெகோவா சொல்லுகிறார்” என்று சொல் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","அப்படியே யெகோவா செய்தார்; வெகு திரளான வண்டுவகைகள் பார்வோனுடைய வீட்டிலும், அவனுடைய வேலைக்காரர்களுடைய வீடுகளிலும், எகிப்து தேசம் முழுவதிலும் வந்தது; வண்டுகளினாலே தேசம் கெட்டுப்போனது. ");
INSERT INTO tam2017_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","அப்பொழுது பார்வோன் மோசேயையும் ஆரோனையும் அழைத்து: “நீங்கள் போய், உங்கள் தேவனுக்கு இந்த தேசத்திலேயே பலியிடுங்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","அதற்கு மோசே: “அப்படிச் செய்யக்கூடாது; எங்களுடைய தேவனாகிய யெகோவாவுக்கு நாங்கள் எகிப்தியர்களுடைய அருவருப்பைப் பலியிடுகிறதாக இருக்குமே, எகிப்தியர்களுடைய அருவருப்பை நாங்கள் அவர்களுடைய கண்களுக்கு முன்பாகப் பலியிட்டால், எங்களைக் கல்லெறிவார்கள் அல்லவா? ");
INSERT INTO tam2017_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","நாங்கள் வனாந்திரத்தில் மூன்று நாட்கள் பயணமாக போய், எங்களுடைய தேவனாகிய யெகோவா எங்களுக்கு விதிக்கிறபடியே அவருக்குப் பலியிடுவோம்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","அப்பொழுது பார்வோன்: “நீங்கள் உங்களுடைய தேவனாகிய யெகோவாவுக்கு வனாந்திரத்தில் பலியிடும்படி, நான் உங்களைப் போகவிடுவேன்; ஆனாலும், நீங்கள் அதிக தூரமாகப் போகவேண்டாம்; எனக்காக வேண்டுதல் செய்யுங்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","அதற்கு மோசே: “நான் உம்மைவிட்டுப் புறப்பட்டபின்பு, நாளைக்கு வண்டுகள் பார்வோனையும் அவருடைய வேலைக்காரர்களையும் அவருடைய மக்களையும் விட்டு நீங்கும்படி, நான் யெகோவாவை நோக்கி வேண்டுதல் செய்வேன்; ஆனாலும், யெகோவாவுக்குப் பலியிடுகிறதற்கு மக்களைப் போகவிடாதபடிப் பார்வோன் இனி ஏமாற்றாதிருப்பாராக” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","மோசே பார்வோனைவிட்டுப் புறப்பட்டுப்போய், யெகோவா நோக்கி வேண்டுதல் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","அப்பொழுது யெகோவா மோசேயின் சொற்படி, வண்டுவகைகள் பார்வோனையும் அவனுடைய வேலைக்காரர்களையும், மக்களையும்விட்டு நீங்கும்படிச் செய்தார்; ஒன்றுகூட மீதியாக இருக்கவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","பார்வோனோ, இந்த முறையும் தன்னுடைய இருதயத்தைக் கடினப்படுத்தி, மக்களைப் போகவிடாமல் இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","பின்பு, யெகோவா மோசேயை நோக்கி: “நீ பார்வோனிடம் போய்: எனக்கு ஆராதனைசெய்ய என்னுடைய மக்களைப் போகவிடு. ");
INSERT INTO tam2017_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","நீ அவர்களை விடமாட்டேன் என்று இன்னும் நிறுத்திவைத்திருந்தால், ");
INSERT INTO tam2017_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","யெகோவாவுடைய கரம் வெளியில் இருக்கிற உன்னுடைய மிருகங்களாகிய குதிரைகளின்மேலும் கழுதைகளின்மேலும் ஒட்டகங்களின்மேலும் ஆடுமாடுகளின்மேலும் இருக்கும்; பெரிய கொடியதான கொள்ளை நோய் உண்டாகும். ");
INSERT INTO tam2017_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","யெகோவா இஸ்ரவேலின் மிருகஜீவன்களுக்கும் எகிப்தியர்களின் மிருகஜீவன்களுக்கும் வித்தியாசத்தை ஏற்படுத்துவார்; இஸ்ரவேலுக்கு உரியவைகள் எல்லாவற்றிலும் ஒன்றும் சாவதில்லை” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","மேலும், நாளைக்குக் யெகோவா இந்தக் காரியத்தை தேசத்தில் செய்வார் என்று சொல்லி, யெகோவா ஒரு காலத்தைக் குறித்தார் என்றும், எபிரெயர்களுடைய தேவனாகிய யெகோவா சொல்லுகிறார் என்றும் அவனிடம் சொல் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","மறுநாளில் யெகோவா அந்தக் காரியத்தைச் செய்தார்; எகிப்தியர்களுடைய மிருகஜீவன்கள் எல்லாம் செத்துப்போனது; இஸ்ரவேலர்களின் மிருகஜீவன்களில் ஒன்றுகூட சாகவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","பார்வோன் விசாரித்து, இஸ்ரவேல் மக்களின் மிருகஜீவன்களில் ஒன்றுகூட சாகவில்லை என்று அறிந்தான். பார்வோனுடைய இருதயமோ கடினப்பட்டது; அவன் மக்களைப் போகவிடவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","அப்பொழுது யெகோவா மோசேயையும் ஆரோனையும் நோக்கி: “உங்கள் கைப்பிடி அளவு சூளையின் சாம்பலை அள்ளிக்கொள்ளுங்கள்; மோசே அதைப் பார்வோனுடைய கண்களுக்குமுன்பு வானத்திற்கு நேராக தூவட்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","அது எகிப்து தேசம் முழுவதும் தூசியாகி, எகிப்து தேசமெங்கும் மனிதர்கள்மேலும் மிருகஜீவன்கள்மேலும் எரிபந்தமான கொப்புளங்களை எழும்பச்செய்யும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","அப்படியே அவர்கள் சூளையின் சாம்பலை அள்ளிக்கொண்டு, பார்வோனுக்கு முன்பாக வந்து நின்றார்கள். மோசே அதை வானத்திற்கு நேராக தூவினான்; அப்பொழுது மனிதர்மேலும் மிருகஜீவன்கள்மேலும் புண்கள் மற்றும் கொப்புளங்கள் வந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","அந்தக் கொப்புளங்கள் மந்திரவாதிகள்மேலும் எகிப்தியர்கள் எல்லோர்மேலும் உண்டானதால், அந்தக் கொப்புளங்களினால் மந்திரவாதிகளால் மோசேக்கு முன்பாக நிற்கமுடியாமல் இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","ஆனாலும், யெகோவா மோசேயோடு சொல்லியிருந்தபடியே, யெகோவா பார்வோனின் இருதயத்தைக் கடினப்படுத்தினார்; அவன் அவர்களுடைய சொல்லைக் கேட்கவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","அப்பொழுது யெகோவா மோசேயை நோக்கி: “நீ அதிகாலையில் எழுந்து போய், பார்வோனுக்கு முன்பாக நின்று: எனக்கு ஆராதனைசெய்ய என்னுடைய மக்களை அனுப்பிவிடு. ");
INSERT INTO tam2017_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","விடாமல் இருந்தால், பூமியெங்கும் என்னைப்போல் வேறொருவரும் இல்லை என்பதை நீ அறியும்படி, இந்தமுறை நான் எல்லாவித வாதைகளையும் உன்மேலும், உன்னுடைய வேலைக்காரர்கள்மேலும், உன்னுடைய மக்கள்மேலும் அனுப்புவேன். ");
INSERT INTO tam2017_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","நீ பூமியில் இல்லாமல் நாசமாகப்போகும்படி நான் என்னுடைய கையை நீட்டி, உன்னையும் உன்னுடைய மக்களையும் கொள்ளை நோயினால் வாதிப்பேன். ");
INSERT INTO tam2017_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","என்னுடைய வல்லமையை உன்னிடம் காண்பிக்கும்படியும், என்னுடைய நாமம் பூமி முழுவதும் பிரபலமாகும்படியும் உன்னை நிலைநிறுத்தினேன். ");
INSERT INTO tam2017_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","நீ என்னுடைய மக்களைப் போகவிடாமல், இன்னும் அவர்களுக்கு விரோதமாக உன்னை உயர்த்துகிறாயா? ");
INSERT INTO tam2017_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","எகிப்து தோன்றிய நாள்முதல் இதுவரைக்கும் அதில் பெய்யாத மிகவும் கொடிய கல்மழையை நாளை இந்த நேரத்தில் பெய்யச்செய்வேன். ");
INSERT INTO tam2017_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","இப்பொழுதே ஆள் அனுப்பி, உன்னுடைய மிருகஜீவன்களையும் வெளியில் உனக்கு இருக்கிற யாவையும் சேர்த்துக்கொள்; வீட்டில் சேர்த்துக்கொள்ளாமல் வெளியிலிருக்கும் ஒவ்வொரு மனிதனும் மிருகமும் செத்துப்போகும்படி அந்தக் கல்மழை பெய்யும் என்று எபிரெயர்களின் தேவனாகிய யெகோவா சொல்லுகிறார் என்று அவனுக்குச் சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","பார்வோனுடைய வேலைக்காரர்களில் எவன் யெகோவாவுடைய வார்த்தைக்குப் பயப்பட்டானோ, அவன் தன்னுடைய வேலைக்காரர்களையும் தன்னுடைய மிருகஜீவன்களையும் வீடுகளுக்கு ஓடிவரச்செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","எவன் யெகோவாவுடைய வார்த்தையை மதிக்காமல்போனானோ, அவன் தன்னுடைய வேலைக்காரர்களையும் தன்னுடைய மிருகஜீவன்களையும் வெளியிலே விட்டுவிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","அப்பொழுது யெகோவா மோசேயை நோக்கி: “எகிப்து தேசம் எங்கும் மனிதர்கள்மேலும் மிருகஜீவன்கள்மேலும் எகிப்து தேசத்திலிருக்கிற எல்லாவிதமான பயிர் வகைகள்மேலும் கல்மழை பெய்ய, உன்னுடைய கையை வானத்திற்கு நேராக நீட்டு” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","அப்படியே மோசே தன்னுடைய கோலை வானத்திற்கு நேராக நீட்டினான். அப்பொழுது யெகோவா இடிமுழக்கங்களையும் கல்மழையையும் அனுப்பினார்; அக்கினி தரையின்மேல் வேகமாக ஓடியது; எகிப்து தேசத்தின்மேல் யெகோவா கல்மழையைப் பெய்யச்செய்தார்; ");
INSERT INTO tam2017_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","கல்மழையும் கல்மழையோடு கலந்த அக்கினியும் மிகவும் கொடியதாக இருந்தது; எகிப்து தேசம் தோன்றிய நாள்முதல் அதில் அப்படி ஒருபோதும் உண்டானதில்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","எகிப்து தேசம் எங்கும் மனிதர்களையும் மிருகஜீவன்களையும், வெளியிலே இருந்தவைகள் எவைகளோ அவைகள் எல்லாவற்றையும் அந்தக் கல்மழை அழித்துப்போட்டது; அது வெளியின் பயிர்வகைகளையெல்லாம் அழித்து, வெளியின் மரங்களையெல்லாம் முறித்துப்போட்டது. ");
INSERT INTO tam2017_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","இஸ்ரவேலர்கள் இருந்த கோசேன் நாட்டில் மட்டும் கல்மழை பெய்யாமல் இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","அப்பொழுது பார்வோன் மோசேயையும் ஆரோனையும் அழைத்து: “நான் இந்தமுறை பாவம் செய்தேன்; யெகோவா நீதியுள்ளவர்; நானும் என்னுடைய மக்களும் துன்மார்க்கர்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","இது போதும்; இந்தப் பெரிய இடிமுழக்கங்களும் கல்மழையும் ஒழியும்படி, யெகோவாவை நோக்கி விண்ணப்பம் செய்யுங்கள்; நான் உங்களைப் போகவிடுவேன், இனி உங்களுக்குத் தடையில்லை” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","மோசே அவனை நோக்கி: “நான் பட்டணத்திலிருந்து புறப்பட்டவுடன், என்னுடைய கைகளைக் யெகோவாவுக்கு நேராக விரிப்பேன்; அப்பொழுது இடிமுழக்கங்கள் ஓய்ந்து கல்மழை நின்றுபோகும்; அதினால் பூமி யெகோவாவுடையது என்பதை நீர் அறிவீர். ");
INSERT INTO tam2017_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","இருந்தாலும் நீரும் உம்முடைய வேலைக்காரர்களும் இன்னும் தேவனாகிய யெகோவாவுக்குப் பயப்படமாட்டீர்கள் என்பதை அறிவேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","அப்பொழுது வாற்கோதுமை கதிர்விட்டும் கொள்ளுப்பயிரானது பூ பூத்திருந்தது; அதினால் கொள்ளும் வாற்கோதுமையும் அழிக்கப்பட்டுப்போனது. ");
INSERT INTO tam2017_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","கோதுமையும் கம்பும் கதிர்விடாமல் இருந்ததால், அவைகள் அழிக்கப்படவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","மோசே பார்வோனைவிட்டுப் பட்டணத்திலிருந்து புறப்பட்டு, தன்னுடைய கைகளைக் யெகோவாவுக்கு நேராக விரித்தான்; அப்பொழுது இடிமுழக்கமும் கல்மழையும் நின்றது; மழையும் பூமியில் பெய்யாமல் இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","மழையும் கல்மழையும் இடிமுழக்கமும் நின்றுபோனதை பார்வோன் கண்டபோது, அவனும் அவனுடைய வேலைக்காரர்களும் பின்னும் பாவம்செய்து, தங்களுடைய இருதயத்தைக் கடினப்படுத்தினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","யெகோவா மோசேயைக்கொண்டு சொல்லியிருந்தபடியே, பார்வோனின் இருதயம் கடினப்பட்டது; அவன் இஸ்ரவேல் மக்களைப் போகவிடவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","பின்பு யெகோவா மோசேயை நோக்கி: “நீ பார்வோனிடம் போ, அவர்களின் நடுவே நான் என்னுடைய இந்த அடையாளங்களைச் செய்யும்படி, ");
INSERT INTO tam2017_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","நான் எகிப்திலே நடப்பித்ததையும் நான் அவர்களுக்குள் செய்த என்னுடைய அடையாளங்களையும், நீ உன்னுடைய பிள்ளைகளின் காதுகள் கேட்கவும், உன்னுடைய பிள்ளைகளுடைய பிள்ளைகளின் காதுகள் கேட்கவும் விவரித்துச் சொல்லும்படியும், நானே யெகோவா என்பதை நீங்கள் அறியும்படியும், நான் அவனுடைய இருதயத்தையும் அவனுடைய வேலைக்காரர்களின் இருதயத்தையும் கடினப்படுத்தினேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","அப்படியே மோசேயும் ஆரோனும் பார்வோனிடம் வந்து: “நீ எதுவரைக்கும் உன்னைத் தாழ்த்த மனமில்லாமல் இருப்பாய்? என்னுடைய சமுகத்தில் எனக்கு ஆராதனைசெய்ய என்னுடைய மக்களைப் போகவிடு. ");
INSERT INTO tam2017_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","நீ என்னுடைய மக்களைப் போகவிடமாட்டேன் என்று சொன்னால், நான் நாளைக்கு உன்னுடைய எல்லைகளுக்குள்ளே வெட்டுக்கிளிகளை வரச்செய்வேன். ");
INSERT INTO tam2017_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","தரையை காணமுடியாதபடி அவைகள் பூமியின் முகத்தை மூடி, கல்மழைக்குத் தப்பி மீதியாக வைக்கப்பட்டதைச் சாப்பிட்டு, வெளியிலே துளிர்க்கிற செடிகளையெல்லாம் தின்றுபோடும். ");
INSERT INTO tam2017_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","உன்னுடைய வீடுகளும் உன்னுடைய வேலைக்காரர்களுடைய வீடுகளும் எகிப்தியர்களின் வீடுகளும் அவைகளால் நிரம்பும்; உன்னுடைய தகப்பன்களும் உன்னுடைய தகப்பன்களின் தகப்பன்களும் தாங்கள் பூமியில் தோன்றின நாள்முதல் இந்த நாள்வரைக்கும் அப்படிப்பட்டவைகளைக் கண்டதில்லை என்று எபிரெயர்களின் தேவனாகிய யெகோவா சொல்லுகிறார்” என்று சொல்லி, திரும்பி பார்வோனை விட்டுப் புறப்பட்டான். ");
INSERT INTO tam2017_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","அப்பொழுது பார்வோனுடைய வேலைக்காரர்கள் அவனை நோக்கி: “எதுவரைக்கும் இந்த மனிதன் நமக்குத் தொல்லை கொடுக்கிறவனாக இருப்பான்? தங்களுடைய தேவனாகிய யெகோவாவுக்கு ஆராதனைசெய்ய அந்த மனிதர்களைப் போகவிடும்; எகிப்து அழிந்துபோனதை நீர் இன்னும் அறியவில்லையா” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","அப்பொழுது மோசேயும் ஆரோனும் பார்வோனிடம் திரும்ப அழைக்கப்பட்டார்கள். அவன் அவர்களை நோக்கி: “நீங்கள் போய் உங்கள் தேவனாகிய யெகோவாவுக்கு ஆராதனை செய்யுங்கள் என்று சொல்லி, யார் யார் போகிறார்கள்” என்று கேட்டான். ");
INSERT INTO tam2017_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","அதற்கு மோசே: “எங்களுடைய வாலிபர்களோடும், எங்களுடைய முதியோர்களோடும், எங்களுடைய மகன்களோடும், எங்களுடைய மகள்களோடும், எங்களுடைய ஆடுகளையும், எங்களுடைய மாடுகளையும் கூட்டிக்கொண்டுபோவோம்; நாங்கள் யெகோவாவுக்குப் பண்டிகை கொண்டாடவேண்டும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","அப்பொழுது அவன்: “நான் உங்களையும் உங்களுடைய குழந்தைகளையும் எப்படி விடுவேனோ, அப்படியே யெகோவா உங்களுடன் இருப்பாராக; எச்சரிக்கையாக இருங்கள், உங்களுக்கு தீங்குநேரிடும்; ");
INSERT INTO tam2017_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","அப்படி வேண்டாம்; ஆண்களாகிய நீங்கள் போய், யெகோவாவுக்கு ஆராதனை செய்யுங்கள்; இதுதானே நீங்கள் விரும்பிக் கேட்டது” என்று சொன்னான். அவர்கள் பார்வோன் சமுகத்திலிருந்து துரத்திவிடப்பட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","அப்பொழுது யெகோவா மோசேயை நோக்கி: “வெட்டுக்கிளிகள் எகிப்து தேசத்தின்மேல் வந்து கல்மழையால் அழியாத பூமியின் பயிர்வகைகளையெல்லாம் சாப்பிடும்படி, எகிப்து தேசத்தின்மேல் உன்னுடைய கையை நீட்டு” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","அப்படியே மோசே தன்னுடைய கோலை எகிப்து தேசத்தின்மேல் நீட்டினான்; அப்பொழுது யெகோவா அன்று பகல் முழுவதும், அன்று இரவுமுழுவதும் கிழக்குக்காற்றை தேசத்தின்மேல் வீசச்செய்தார்; அதிகாலையில் கிழக்குக்காற்று வெட்டுக்கிளிகளைக் கொண்டுவந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","வெட்டுக்கிளிகள் எகிப்து தேசம் எங்கும் பரவி, எகிப்தின் எல்லையில் எங்கும் மிகவும் ஏராளமாக இறங்கியது; அப்படிப்பட்ட வெட்டுக்கிளிகள் அதற்கு முன்பு இருந்ததும் இல்லை, அதற்குப்பின்பு இருப்பதும் இல்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","அவைகள் பூமியின் மேற்பரப்பு முழுவதையும் மூடியது; தேசம் அவைகளால் இருளடைந்தது; கல்மழைக்குத் தப்பியிருந்த நிலத்தின் பயிர்வகைகள் எல்லாவற்றையும் மரங்களின் கனிகள் யாவையும் அவைகள் சாப்பிட்டது; எகிப்து தேசம் எங்குமுள்ள மரங்களிலும் வயல்வெளியின் பயிர்வகைகளிலும் ஒரு பச்சிலையைக் கூட மீதியாக வைக்கவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","அப்பொழுது பார்வோன் மோசேயையும், ஆரோனையும் விரைவாக அழைத்து: “உங்களுடைய தேவனாகிய யெகோவாவுக்கும் உங்களுக்கும் விரோதமாகப் பாவம் செய்தேன். ");
INSERT INTO tam2017_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","இந்த ஒருமுறைமட்டும் நீ என்னுடைய பாவத்தை மன்னிக்கவேண்டும்; உங்களுடைய தேவனாகிய யெகோவா இந்த மரணத்தைமட்டும் என்னைவிட்டு விலக்க அவரை நோக்கி விண்ணப்பம்செய்யுங்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","அவன் பார்வோனைவிட்டுப் புறப்பட்டுப்போய், யெகோவாவை நோக்கி விண்ணப்பம்செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","அப்பொழுது யெகோவா மகா பலத்த மேற்குக்காற்றை வீசும்படிச் செய்தார்; அது வெட்டுக்கிளிகளை அடித்துக்கொண்டுபோய் செங்கடலிலே போட்டது; எகிப்தின் எல்லையில் எங்கும் ஒரு வெட்டுக்கிளிகூட மீதியாக இருக்கவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","யெகோவாவோ பார்வோனின் இருதயத்தைக் கடினப்படுத்தினார்; அவன் இஸ்ரவேலர்களைப் போகவிடவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","அப்பொழுது யெகோவா மோசேயை நோக்கி: “தடவிக்கொண்டிருக்கும்படியான இருள் எகிப்து தேசத்தின்மேல் உண்டாகும்படி, உன்னுடைய கையை வானத்திற்கு நேராக நீட்டு” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","மோசே தன்னுடைய கையை வானத்திற்கு நேராக நீட்டினான்; அப்பொழுது எகிப்து தேசம் எங்கும் மூன்றுநாட்கள்வரை காரிருள் உண்டானது. ");
INSERT INTO tam2017_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","மூன்றுநாட்கள்வரை ஒருவரையொருவர் பார்க்கவும் இல்லை, ஒருவரும் தம்முடைய இடத்தைவிட்டு எழுந்திருக்கவும் இல்லை; இஸ்ரவேலர்கள் எல்லோருக்கும் அவர்கள் வாழ்ந்த இடத்திலே வெளிச்சம் இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","அப்பொழுது பார்வோன் மோசேயை அழைத்து; “நீங்கள் போய்க் யெகோவாவுக்கு ஆராதனை செய்யுங்கள்; உங்களுடைய ஆடுகளும் உங்களுடைய மாடுகளும் மட்டும் நிறுத்தப்படவேண்டும்; உங்களுடைய குழந்தைகள் உங்களுடன் போகலாம்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","அதற்கு மோசே: “நாங்கள் எங்களுடைய தேவனாகிய யெகோவாவிற்கு செலுத்தும் பலிகளையும் சர்வாங்க தகனபலிகளையும் நீர் எங்களுடைய கையிலே கொடுக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","எங்களுடைய மிருகஜீவன்களும் எங்களுடன் வரவேண்டும்; ஒரு குளம்பும் பின்வைக்கப்படுவதில்லை; எங்களுடைய தேவனாகிய யெகோவாவிற்கு ஆராதனை செய்வதற்கு அவைகளிலிருந்து எடுக்கவேண்டும்; இன்னதைக்கொண்டு யெகோவாவுக்கு ஆராதனை செய்வோம் என்பது நாங்கள் அங்கே போய்ச் சேரும்வரை எங்களுக்குத் தெரியாது” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","யெகோவா பார்வோனுடைய இருதயத்தைக் கடினப்படுத்தினார்; அவன் அவர்களைப் போகவிட மனதில்லாமல் இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","பார்வோன் அவனை நோக்கி: “என்னைவிட்டு அந்தப்பக்கம் போ; நீ இனி என்னுடைய முகத்தைப் பார்க்காதபடி எச்சரிக்கையாக இரு; நீ இனி என்னுடைய முகத்தைப் பார்க்கும் நாளில் சாவாய்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","அப்பொழுது மோசே: “நீர் சொன்னது சரி; இனி நான் உம்முடைய முகத்தைப் பார்க்கமாட்டேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","அப்பொழுது யெகோவா மோசேயை நோக்கி: “இன்னும் ஒரு வாதையைப் பார்வோன்மேலும் எகிப்தின்மேலும் வரச்செய்வேன்; அதற்குப்பின்பு அவன் உங்களை இந்த இடத்திலிருந்து போகவிடுவான்; முழுவதுமாக உங்களைப் போகவிடுவதும் மட்டுமின்றி, உங்களை இந்த இடத்திலிருந்து துரத்தியும் விடுவான். ");
INSERT INTO tam2017_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","இப்பொழுது ஒவ்வொருவனும் அவனவன் அயலானிடத்திலும், ஒவ்வொருத்தியும் அவளவள் அயலாளிடத்திலும் வெள்ளியுடைமைகளையும் பொன்னுடைமைகளையும் கேட்கும்படி மக்களுக்குச் சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","அப்படியே யெகோவா மக்களுக்கு எகிப்தியர்களின் கண்களில் தயவுகிடைக்கும்படிச் செய்தார். மோசே என்பவன் எகிப்து தேசத்தில் பார்வோனுடைய ஊழியக்காரர்களின் பார்வைக்கும் மக்களின் பார்வைக்கும் மிகவும் பெரியவனாக இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","அப்பொழுது மோசே: “யெகோவா உரைக்கிறதாவது, நடு இரவிலே நான் எகிப்திற்குள்ளே புறப்பட்டுப்போவேன். ");
INSERT INTO tam2017_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","அப்பொழுது சிங்காசனத்தின்மேல் அமர்ந்திருக்கும் பார்வோனுடைய தலைப்பிள்ளைமுதல் எந்திரம் அரைக்கும் அடிமைப்பெண்ணுடைய தலைப்பிள்ளைவரைக்கும், எகிப்து தேசத்திலிருக்கிற முதற்பேறனைத்தும் மிருகஜீவன்களின் தலையீற்றனைத்தும் சாகும் என்று சொன்னதுமன்றி, ");
INSERT INTO tam2017_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","அதினால் எகிப்து தேசம் எங்கும் முன்னும் பின்னும் ஒருபோதும் உண்டாகாத பெரிய கூக்குரல் உண்டாகும். ");
INSERT INTO tam2017_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","ஆனாலும் யெகோவா எகிப்தியர்களுக்கும் இஸ்ரவேலர்களுக்கும் செய்கிற வித்தியாசத்தை நீங்கள் அறியும்படி, இஸ்ரவேல் மக்கள் அனைவருக்குள்ளும் மனிதர்கள்முதல் மிருகஜீவன்கள் வரைக்கும் ஒரு நாய் கூட தன்னுடைய நாவை அசைப்பதில்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","அப்பொழுது உம்முடைய வேலைக்காரர்களாகிய இவர்கள் எல்லோரும் என்னிடம் வந்து, பணிந்து. நீயும் உன்னைப் பின்பற்றுகிறவர்கள் எல்லோரும் புறப்பட்டுப்போங்கள் என்று சொல்லுவார்கள்; அதின்பின்பு புறப்படுவேன்” என்று சொல்லி, கடுங்கோபத்தோடு பார்வோனை விட்டுப் புறப்பட்டான். ");
INSERT INTO tam2017_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","யெகோவா மோசேயை நோக்கி: “எகிப்து தேசத்தில் என்னுடைய அற்புதங்கள் அநேகமாகும்படி, பார்வோன் உங்களுக்குச் செவிகொடுக்கமாட்டான்” என்று சொல்லியிருந்தார். ");
INSERT INTO tam2017_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","மோசேயும் ஆரோனும் இந்த அற்புதங்களையெல்லாம் பார்வோனுக்கு முன்பாகச் செய்தார்கள். யெகோவா பார்வோனின் இருதயத்தைக் கடினப்படுத்தியதால், அவன் இஸ்ரவேல் மக்களைத் தன்னுடைய தேசத்திலிருந்து போகவிடவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","யெகோவா எகிப்து தேசத்தில் மோசேயையும், ஆரோனையும் நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“இந்த மாதம் உங்களுக்கு துவக்கமாதம்; இது உங்களுக்கு வருடத்தின் முதலாம் மாதமாக இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","நீங்கள் இஸ்ரவேல் சபையார்கள் எல்லோரையும் நோக்கி: இந்த மாதம் பத்தாம் தேதியில் வீட்டுத்தலைவர்கள், வீட்டுக்கு ஒரு ஆட்டுக்குட்டியாக, ஒவ்வொருவரும் ஒவ்வொரு ஆட்டுக்குட்டியைத் தெரிந்துகொள்ளட்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ஒரு வீட்டில் இருக்கிறவர்கள் ஒரு ஆட்டுக்குட்டியைப் சாப்பிடுவதற்குப் போதுமானவர்களாக இல்லாமற்போனால், அவனும் அவன் அருகிலிருக்கிற அவனுடைய அயல்வீட்டுக்காரனும், தங்களிடத்திலுள்ள நபர்களின் எண்ணிக்கைக்குத்தக்கதாக ஒரு ஆட்டுக்குட்டியைத் தெரிந்துகொள்ளவேண்டும்; அவனவன் சாப்பிடத்தக்கதாக எண்ணிக்கைபார்த்து, ஆட்டுக்குட்டியைத் தெரிந்துகொள்ளவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","அந்த ஆட்டுக்குட்டி பழுதற்றதும் ஆணும் ஒரு வயதுடையதுமாக இருக்கவேண்டும்; செம்மறியாடுகளிலோ வெள்ளாடுகளிலோ அதைத் தெரிந்துகொள்ளலாம். ");
INSERT INTO tam2017_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","அதை இந்த மாதம் பதினான்காம்தேதிவரையும் வைத்திருந்து, இஸ்ரவேல் சபையின் ஒவ்வொரு கூட்டத்தார்களும் மாலையில் அதை அடித்து, ");
INSERT INTO tam2017_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","அதின் இரத்தத்தில் கொஞ்சம் எடுத்து, தாங்கள் அதைச் சாப்பிடும் வீட்டுவாசல் நிலைக்கால்கள் இரண்டிலும் நிலையின் மேற்சட்டத்திலும் தெளித்து, ");
INSERT INTO tam2017_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","அன்று இரவிலே அதின் இறைச்சியை நெருப்பினால் சுட்டு, புளிப்பில்லா அப்பத்தோடும் கசப்பான கீரையோடும் அதைச் சாப்பிடட்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","பச்சையாயும் தண்ணீரில் அவிக்கப்பட்டதாயும் அல்ல; அதின் தலையையும் அதின் தொடைகளையும் அதற்குள்ள எல்லாவற்றையும் ஒன்றாக நெருப்பினால் சுட்டதாக அதைச் சாப்பிடுங்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","அதிலே ஒன்றையும் காலைவரை மீதியாக வைக்காமல், காலைவரை அதிலே மீதியாக இருப்பதை அக்கினியால் சுட்டெரியுங்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","அதைச் சாப்பிடவேண்டிய முறையாவது, நீங்கள் உங்களுடைய இடுப்பில் கச்சையைக் கட்டிக்கொண்டும், உங்களுடைய கால்களில் காலணியை அணிந்துகொண்டும், உங்களுடைய கையில் தடியைப் பிடித்துக்கொண்டும் அதை விரைவாக சாப்பிடுங்கள்; அது யெகோவாவுடைய பஸ்கா. ");
INSERT INTO tam2017_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","அந்த இரவிலே நான் எகிப்து தேசம் எங்கும் கடந்துபோய், எகிப்து தேசத்திலுள்ள மனிதர்கள்முதல் மிருகஜீவன்கள்வரை, முதலில் பிறந்திருக்கிறவைகளையெல்லாம் நாசம்செய்து, எகிப்து தெய்வங்களின்மேல் நீதியைச் செலுத்துவேன்; நானே யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","நீங்கள் இருக்கும் வீடுகளில் அந்த இரத்தம் உங்களுக்காக அடையாளமாக இருக்கும்; அந்த இரத்தத்தை நான் கண்டு, உங்களைக் கடந்துபோவேன்; நான் எகிப்து தேசத்தை அழிக்கும்போது, அழிக்கும் வாதை உங்களுக்குள்ளே வராமல் இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","அந்த நாள் உங்களுக்கு நினைவுகூருதலான நாளாக இருக்கட்டும்; அதைக் யெகோவாவுக்குப் பண்டிகையாக அனுசரியுங்கள்; அதை உங்களுடைய தலைமுறைதோறும் நிரந்தர கட்டளையாக அனுசரிக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","புளிப்பில்லா அப்பத்தை ஏழுநாட்கள்வரை சாப்பிடுவீர்களாக; முதலாம் நாளிலே புளித்தமாவை உங்கள் வீடுகளிலிருந்து நீக்கவேண்டும்; முதலாம்நாள்துவங்கி ஏழாம் நாள்வரையும் புளித்த அப்பம் சாப்பிடுகிறவன் எவனோ அவன் இஸ்ரவேலர்களிலிருந்து துண்டிக்கப்படுவான். ");
INSERT INTO tam2017_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","முதலாம் நாளில் பரிசுத்த சபைகூடுதலும், ஏழாம் நாளிலும் பரிசுத்த சபைகூடுதலும் இருக்கவேண்டும்; அவைகளில் ஒரு வேலையும் செய்யக்கூடாது; அவரவர் சாப்பிடுவதற்குத் தேவையானதுமட்டும் உங்களால் செய்யப்படலாம். ");
INSERT INTO tam2017_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","புளிப்பில்லா அப்பப்பண்டிகையை அனுசரியுங்கள்; இந்த நாளில்தான் நான் உங்களுடைய சேனைகளை எகிப்து தேசத்திலிருந்து புறப்படச்செய்தேன்; ஆகையால், உங்கள் தலைமுறைதோறும் நிரந்தரக் கட்டளையாக இந்த நாளை அனுசரிக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","முதலாம் மாதம் பதினான்காம் தேதி சாயங்காலந்தொடங்கி மாதத்தின் இருபத்தோராம் தேதி சாயங்காலம்வரைக்கும் புளிப்பில்லா அப்பம் சாப்பிடுவீர்களாக. ");
INSERT INTO tam2017_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","ஏழுநாட்கள்வரை உங்களுடைய வீடுகளில் புளித்தமாவு காணப்படக்கூடாது; எவனாவது புளிப்பிடப்பட்டதைச் சாப்பிட்டால், அவன் அந்நியனானாலும் சொந்த தேசப் பிறப்பானாலும், அந்த ஆத்துமா இஸ்ரவேல் சபையில் இல்லாமல் துண்டிக்கப்படுவான். ");
INSERT INTO tam2017_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","புளிப்பிடப்பட்ட எதையும் நீங்கள் சாப்பிடவேண்டாம்; நீங்கள் தங்குமிடங்களிலெல்லாம் புளிப்பில்லா அப்பம் சாப்பிடுங்கள் என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","அப்பொழுது மோசே இஸ்ரவேல் மூப்பர்கள் எல்லோரையும் அழைத்து: “நீங்கள் உங்களுடைய குடும்பங்களுக்குத் தகுந்தபடி உங்களுக்கு ஆட்டுக்குட்டியைத் தெரிந்தெடுத்துக்கொண்டு, பஸ்காவை அடித்து, ");
INSERT INTO tam2017_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","ஈசோப்புக் கொழுந்துகளின் கொத்தை எடுத்து கிண்ணத்தில் இருக்கும் இரத்தத்தில் தோய்த்து, அதில் இருக்கும் அந்த இரத்தத்தை வாசல் நிலைக்கால்களின் மேற்சட்டத்திலும் வாசலின் நிலைக்கால்கள் இரண்டிலும் தெளியுங்கள்; அதிகாலைவரைக்கும் உங்களில் ஒருவரும் வீட்டு வாசலைவிட்டுப் புறப்படவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","யெகோவா எகிப்தியர்களை நாசம் செய்வதற்குக் கடந்துவருவார்; நிலையின் மேற்சட்டத்திலும் வாசலின் நிலைக்கால்கள் இரண்டிலும் அந்த இரத்தத்தைக் காணும்போது, யெகோவா அழிக்கிறவனை உங்களுடைய வீடுகளில் உங்களை நாசம் செய்வதற்கு வரவிடாமல், வாசற்படியிலிருந்து விலகிக் கடந்துபோவார். ");
INSERT INTO tam2017_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","இந்தக் காரியத்தை உங்களுக்கும் உங்களுடைய பிள்ளைகளுக்கும் நிரந்தர கட்டளையாகக் கைக்கொள்ளுங்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","யெகோவா உங்களுக்குத் தாம் சொன்னபடி கொடுக்கப்போகிற தேசத்திலே நீங்கள் போய்ச் சேரும்போது, இந்த ஆராதனையைக் கைக்கொள்ளுங்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","அப்பொழுது உங்கள் பிள்ளைகள்: இந்த ஆராதனையின் கருத்து என்ன என்று உங்களைக் கேட்டால், ");
INSERT INTO tam2017_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","இது யெகோவாவுடைய பஸ்காவாகிய பலி; அவர் எகிப்தியர்களை நாசம் செய்து, நம்முடைய வீடுகளைத் தப்பிக்கச்செய்தபோது, எகிப்திலிருந்த இஸ்ரவேலர்களுடைய வீடுகளைக் கடந்துபோனார் என்று நீங்கள் சொல்லவேண்டும்” என்றான். அப்பொழுது மக்கள் தலைவணங்கிப் பணிந்துகொண்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","இஸ்ரவேலர்கள் போய் அப்படியே செய்தார்கள்; யெகோவா மோசேக்கும் ஆரோனுக்கும் கட்டளையிட்டபடியே செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","நடுஇரவிலே சிங்காசனத்தின்மேல் அமர்ந்திருக்கும் பார்வோனுடைய தலைப்பிள்ளைமுதல் காவல் கிடங்கிலிருக்கும் சிறைப்பட்டவனின் தலைப்பிள்ளைவரைக்கும், எகிப்து தேசத்தில் இருந்த முதற்பேறனைத்தையும், மிருகஜீவன்களின் தலையீற்றனைத்தையும் யெகோவா அழித்தார். ");
INSERT INTO tam2017_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","அப்பொழுது பார்வோனும் அவனுடைய எல்லா ஊழியக்காரர்களும் எகிப்தியர்கள் அனைவரும் இரவிலே எழுந்தார்கள்; கொடிய கூக்குரல் எகிப்திலே உண்டானது; சாவு இல்லாத ஒரு வீடும் இல்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","இரவிலே அவன் மோசேயையும் ஆரோனையும் அழைத்து: “நீங்களும் இஸ்ரவேலர்களும் எழுந்து, என்னுடைய மக்களைவிட்டுப் புறப்பட்டுப் போய், நீங்கள் சொன்னபடியே யெகோவாவுக்கு ஆராதனை செய்யுங்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","நீங்கள் சொன்னபடியே உங்களுடைய ஆடுமாடுகளையும் ஓட்டிக்கொண்டுபோங்கள்; என்னையும் ஆசீர்வதியுங்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","எகிப்தியர்கள்: “நாங்கள் எல்லோரும் சாகிறோமே” என்று சொல்லி, விரைவாக அந்த மக்களைத் தேசத்திலிருந்து அனுப்பிவிட அவர்களை மிகவும் அவசரப்படுத்தினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","பிசைந்தமாவு புளிப்பதற்குமுன்பு மக்கள் அதைப் பாத்திரத்துடன் தங்களுடைய ஆடைகளில் கட்டி, தங்களுடைய தோள்மேல் எடுத்துக்கொண்டு போனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","மோசே சொல்லியிருந்தபடி இஸ்ரவேல் மக்கள் எகிப்தியர்களிடம் வெள்ளி நகைகளையும் பொன் நகைகளையும் ஆடைகளையும் கேட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","யெகோவா மக்களுக்கு எகிப்தியர்களின் கண்களில் தயவு கிடைக்கும்படி செய்ததால், கேட்டதை அவர்களுக்குக் கொடுத்தார்கள்; இந்தவிதமாக அவர்கள் எகிப்தியர்களைக் கொள்ளையிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","இஸ்ரவேலர்கள் ராமசேசைவிட்டுக் கால்நடையாகப் பயணம்செய்து, சுக்கோத்திற்குப் போனார்கள்; அவர்கள், பிள்ளைகள் தவிர ஆறுலட்சம் ஆண்களாக இருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","அவர்களுடன் கூடப் பல இஸ்ரவேலர்கள் அல்லாத மக்கள் அநேகர் போனதுமட்டுமல்லால், திரளான ஆடுமாடுகள் முதலான மிருகஜீவன்களும் போனது. ");
INSERT INTO tam2017_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","எகிப்திலிருந்து அவர்கள் கொண்டுவந்த பிசைந்தமாவைப் புளிப்பில்லாத அப்பங்களாகச் சுட்டார்கள்; அவர்கள் எகிப்தில் இருக்கமுடியாதபடி துரத்திவிடப்பட்டதால், அது புளிக்காமல் இருந்தது; அவர்கள் தங்களுடைய பயணத்திற்கென்று ஒன்றும் ஆயத்தம்செய்யவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","இஸ்ரவேலர்கள் எகிப்திலே குடியிருந்த காலம் நானூற்றுமுப்பது வருடங்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","நானூற்றுமுப்பது வருடங்கள் முடிந்த அன்றைய நாளே யெகோவாவுடைய சேனைகள் எல்லாம் எகிப்து தேசத்திலிருந்து புறப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","யெகோவா அவர்களை எகிப்து தேசத்திலிருந்து புறப்படச்செய்ததால், இது அவருக்கென்று முக்கியமாக அனுசரிக்கத்தக்க இரவானது; இஸ்ரவேல் சந்ததியார் எல்லோரும் தங்கள் தலைமுறைதோறும் யெகோவாவுக்கு முக்கியமாக அனுசரிக்கவேண்டிய இரவு இதுவே. ");
INSERT INTO tam2017_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","மேலும், யெகோவா மோசேயையும் ஆரோனையும் நோக்கி: “பஸ்காவின் கட்டளையாவது, அந்நியனில் ஒருவனும் அதை சாப்பிடவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","பணத்தினால் வாங்கப்பட்ட அடிமையானவன் எவனும், நீ அவனுக்கு விருத்தசேதனம் செய்தபின்பு, அவன் அதைச் சாப்பிடலாம். ");
INSERT INTO tam2017_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","அந்நியனும் கூலியாளும் அதிலே சாப்பிடவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","அதை ஒவ்வொரு வீட்டிற்குள்ளும் சாப்பிடவேண்டும்; அந்த இறைச்சியில் கொஞ்சம்கூட வீட்டிலிருந்து வெளியே கொண்டுபோகக்கூடாது; அதில் ஒரு எலும்பையும் முறிக்கக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","இஸ்ரவேல் சபையார்கள் எல்லோரும் அதை அனுசரிக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","அந்நியன் ஒருவன் உன்னிடம் தங்கி, யெகோவாவுக்குப் பஸ்காவை அனுசரிக்கவேண்டுமென்று இருந்தால், அவனைச் சேர்ந்த ஆண்பிள்ளைகள் எல்லோரும் விருத்தசேதனம் செய்யப்படவேண்டும்; பின்பு அவன் சேர்ந்து அதை அனுசரிக்கவேண்டும்; அவன் சொந்த தேசத்தில் பிறந்தவனாக இருப்பான்; விருத்தசேதனம் இல்லாத ஒருவரும் அதில் சாப்பிடவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","சொந்த தேசத்தில் பிறந்தவனுக்கும் உங்களிடத்தில் தங்கும் அந்நியனுக்கும் ஒரே பிரமாணம் இருக்கட்டும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","இப்படியே இஸ்ரவேலர்கள் எல்லோரும் செய்தார்கள்; யெகோவா மோசேக்கும் ஆரோனுக்கும் கட்டளையிட்டபடியே செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","அன்றைக்கே யெகோவா இஸ்ரவேலை அணியணியாக எகிப்து தேசத்திலிருந்து புறப்படச்செய்தார். ");
INSERT INTO tam2017_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“இஸ்ரவேலர்களுக்குள் மனிதர்களிலும் மிருகஜீவன்களிலும் கர்ப்பம்திறந்து பிறக்கிற, முதற்பேறான அனைத்தையும் எனக்குப் பரிசுத்தப்படுத்து; அது என்னுடையது” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","அப்பொழுது மோசே மக்களை நோக்கி: “நீங்கள் அடிமைத்தன வீடாகிய எகிப்திலிருந்து புறப்பட்ட இந்த நாளை நினையுங்கள்; யெகோவா பலத்த கையினால் உங்களை இந்த இடத்திலிருந்து புறப்படச்செய்தார்; ஆகையால், நீங்கள் புளித்த அப்பம் சாப்பிடவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","ஆபீப் மாதத்தின் இந்த நாளிலே நீங்கள் புறப்பட்டீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","ஆகையால், யெகோவா உனக்குக் கொடுப்பேன் என்று உன்னுடைய முன்னோர்களுக்கு ஆணையிட்டதும், பாலும் தேனும் ஓடுகிறதுமான தேசமாகிய கானானியர்கள், ஏத்தியர்கள், எமோரியர்கள், ஏவியர்கள், எபூசியர்கள் என்பவர்களுடைய தேசத்திற்கு உன்னை வரச்செய்யும் காலத்தில், நீ இந்த மாதத்திலே இந்த ஆராதனையை செய்வாயாக. ");
INSERT INTO tam2017_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","புளிப்பில்லா அப்பத்தை ஏழுநாட்கள்வரை சாப்பிடவேண்டும்; ஏழாம்நாளிலே யெகோவாவுக்குப் பண்டிகை அனுசரிக்கப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","அந்த ஏழுநாட்களும் புளிப்பில்லா அப்பம் சாப்பிடவேண்டும்; புளிப்புள்ள அப்பம் உன்னிடத்திலே காணப்படவேண்டாம்; உன்னுடைய எல்லைக்குள் எங்கும் புளித்தமாவும் உன்னிடத்தில் காணப்படவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","அந்த நாளில் நீ உன்னுடைய பிள்ளைகளை நோக்கி: நான் எகிப்திலிருந்து புறப்படும்போது, யெகோவா எனக்குச் செய்ததற்காக இப்படி நடப்பிக்கப்படுகிறது என்று சொல். ");
INSERT INTO tam2017_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","யெகோவாவின் நியாயப்பிரமாணம் உன்னுடைய வாயிலிருக்கும்படி, இது உன்னுடைய கையிலே ஒரு அடையாளமாகவும் உன்னுடைய கண்களின் நடுவே நினைப்பூட்டுதலாகவும் இருப்பதாக; பலத்த கையினால் யெகோவா உன்னை எகிப்திலிருந்து புறப்படச்செய்தார்; ");
INSERT INTO tam2017_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","ஆகையால், நீ வருடந்தோறும் குறித்த காலத்தில் இந்த நியாயத்தை அனுசரித்து வரவும். ");
INSERT INTO tam2017_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","மேலும், “யெகோவா உனக்கும் உன்னுடைய முன்னோர்களுக்கும் ஆணையிட்டபடியே, உன்னைக் கானானியரின் தேசத்திலே வரச்செய்து, அதை உனக்குக் கொடுக்கும்போது, ");
INSERT INTO tam2017_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","கர்ப்பந்திறந்து பிறக்கும் அனைத்தையும், உனக்கு இருக்கும் மிருகஜீவன்களின் முதல்பிறப்பு அனைத்தையும், யெகோவாவுக்கு ஒப்புக்கொடுப்பாயாக; அவைகளிலுள்ள ஆண்கள் யெகோவாவுடையவைகள். ");
INSERT INTO tam2017_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","கழுதையின் முதற்பிறப்பையெல்லாம் ஒரு ஆட்டுக்குட்டியால் மீட்டுக்கொள்வாயாக; மீட்காவிட்டால், அதின் கழுத்தை உடைத்துப்போடு. உன்னுடைய பிள்ளைகளில் முதற்பேறான எல்லோரையும் மீட்டுக்கொள். ");
INSERT INTO tam2017_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","பிற்காலத்தில் உன்னுடைய மகன்: இது என்ன என்று உன்னைக் கேட்டால்; நீ அவனை நோக்கி: யெகோவா எங்களைப் பலத்த கையினால் அடிமைத்தன வீடாகிய எகிப்திலிருந்து புறப்படச்செய்தார். ");
INSERT INTO tam2017_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","எங்களை விடாதபடி, பார்வோன் கடினப்பட்டிருக்கும்போது, யெகோவா எகிப்து தேசத்தில் மனிதரின் முதல்பிள்ளைகள்முதல் மிருகஜீவன்களின் முதற்பிறப்புகள்வரையும் உண்டாயிருந்த முதற்பிறப்புகள் யாவையும் கொன்றுபோட்டார்; ஆகையால், கர்ப்பந்திறந்து பிறக்கும் ஆண்களையெல்லாம் நான் யெகோவாவுக்குப் பலியிட்டு, என்னுடைய பிள்ளைகளில் முதற்பிறப்புகள் அனைத்தையும் மீட்டுக்கொள்ளுகிறேன். ");
INSERT INTO tam2017_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","யெகோவா எங்களைப் பலத்த கையினால் எகிப்திலிருந்து புறப்படச்செய்வதற்கு, இது உன்னுடைய கையில் அடையாளமாகவும், உன்னுடைய கண்களின் நடுவே ஞாபகக்குறியாகவும் இருப்பதாக என்று சொல்வாயாக” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","பார்வோன் மக்களைப் போகவிட்டபின்பு: மக்கள் யுத்தத்தைக் கண்டால் மனமடிந்து, எகிப்திற்குத் திரும்புவார்கள் என்று சொல்லி; பெலிஸ்தர்களின் தேசத்தின் வழியாகப் போவது அருகாமையாக இருந்தாலும், தேவன் அவர்களை அந்த வழியாக நடத்தாமல், ");
INSERT INTO tam2017_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","செங்கடலின் வனாந்திர வழியாக மக்களைச் சுற்றிப் போகச்செய்தார். இஸ்ரவேல் மக்கள் எகிப்து தேசத்திலிருந்து கோத்திரம் கோத்திரமாக புறப்பட்டுப்போனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","மோசே தன்னோடு யோசேப்பின் எலும்புகளை எடுத்துக்கொண்டு போனான். தேவன் நிச்சயமாக உங்களைச் சந்திப்பார்; அப்பொழுது உங்களுடன் என்னுடைய எலும்புகளை இந்த இடத்திலிருந்து கொண்டுபோங்கள் என்று யோசேப்பு சொல்லி, இஸ்ரவேலர்களை உறுதியாக ஆணையிடும்படிச் செய்திருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","அவர்கள் சுக்கோத்திலிருந்து பயணப்பட்டு, வனாந்திரத்தின் ஓரமாக ஏத்தாமிலே முகாமிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","அவர்கள் இரவும் பகலும் வழிநடக்கக்கூடும்படி, யெகோவா பகலில் அவர்களை வழிநடத்த மேகத்தூணிலும், இரவில் அவர்களுக்கு வெளிச்சம் காட்ட அக்கினித்தூணிலும் அவர்களுக்கு முன்பு சென்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","பகலிலே மேகத்தூணிலும், இரவிலே அக்கினித்தூணிலும் மக்களிடத்திலிருந்து விலகிப்போகவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“நீங்கள் திரும்பி மிக்தோலுக்கும் கடலுக்கும் நடுவே பாகால்செபோனுக்கு முன்பாக இருக்கிற ஈரோத் பள்ளத்தாக்கின் முன்பாக முகாமிடவேண்டும் என்று இஸ்ரவேலர்களுக்குச் சொல்லு; அதற்கு எதிராக கடற்கரையில் முகாமிடுங்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","அப்பொழுது பார்வோன் இஸ்ரவேலர்களைக்குறித்து: அவர்கள் தேசத்திலே திகைத்துத் திரிகிறார்கள்; வனாந்திரம் அவர்களை அடைத்துப்போட்டது என்று சொல்லுவான். ");
INSERT INTO tam2017_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","ஆகையால், பார்வோன் அவர்களைப் பின்தொடரும்படி, நான் அவன் இருதயத்தைக் கடினப்படுத்தி, நானே யெகோவா என்பதை எகிப்தியர்கள் அறியும்படி, பார்வோனாலும் அவனுடைய எல்லா ராணுவத்தாலும் மகிமைப்படுவேன்” என்றார்; அவர்கள் அப்படியே செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","மக்கள் ஓடிப்போய்விட்டார்கள் என்று எகிப்தின் ராஜாவிற்கு அறிவிக்கப்பட்டபோது, மக்களுக்கு விரோதமாகப் பார்வோனும் அவனுடைய ஊழியக்காரர்களும் மனம் மாறி: “நமக்கு வேலை செய்யாதபடி நாம் இஸ்ரவேலர்களைப் போகவிட்டது என்ன காரியம்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","அவன் தன்னுடைய இரதத்தைப் பூட்டி, தன்னுடைய மக்களைக் கூட்டிக்கொண்டு, ");
INSERT INTO tam2017_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","முதல்தரமான அறுநூறு இரதங்களையும், எகிப்திலுள்ள மற்ற எல்லா இரதங்களையும், அவைகள் எல்லாவற்றிற்கும் அதிபதிகளான வீரர்களையும் கூட்டிக்கொண்டு போனான். ");
INSERT INTO tam2017_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","யெகோவா எகிப்தின் ராஜாவாகிய பார்வோனின் இருதயத்தைக் கடினப்படுத்தினார்; அவன் இஸ்ரவேலர்களைப் பின்தொடர்ந்தான், இஸ்ரவேலர்கள் பலத்த கையுடன் புறப்பட்டுப் போனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","எகிப்தியர்கள் பார்வோனுடைய எல்லாக் குதிரைகளுடனும், இரதங்களோடும் அவனுடைய குதிரைவீரர்களோடும் சேனைகளோடும் அவர்களைத் தொடர்ந்துபோய், கடலின் அருகிலே பாகால்செபோனுக்கு எதிரே இருக்கிற ஈரோத் பள்ளத்தாக்கின் முன்பாக முகாமிட்டிருக்கிற அவர்களை நெருங்கினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","பார்வோன் அருகில் வருகிறபோது, இஸ்ரவேலர்கள் தங்களுடைய கண்களை ஏறெடுத்துப்பார்த்து, எகிப்தியர்கள் தங்களுக்குப் பின்னே வருகிறதைக் கண்டு, மிகவும் பயந்தார்கள்; அப்பொழுது இஸ்ரவேலர்கள் யெகோவாவை நோக்கிக் கூப்பிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","அன்றியும் அவர்கள் மோசேயை நோக்கி: “எகிப்திலே கல்லறைகள் இல்லையென்றா வனாந்திரத்திலே சாகும்படி எங்களைக் கொண்டுவந்தீர்? நீர் எங்களை எகிப்திலிருந்து புறப்படச்செய்ததால், எங்களுக்கு இப்படிச் செய்தது ஏன்? ");
INSERT INTO tam2017_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","நாங்கள் எகிப்திலே இருக்கும்போது, எகிப்தியர்களுக்கு வேலை செய்ய எங்களைச் சும்மா விட்டுவிடும் என்று சொன்னோம் அல்லவா? நாங்கள் வனாந்திரத்திலே சாவதைவிட எகிப்தியர்களுக்கு வேலைசெய்கிறது எங்களுக்கு நலமாக இருக்குமே” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","அப்பொழுது மோசே மக்களை நோக்கி: “பயப்படாதிருங்கள்; நீங்கள் நின்றுகொண்டு இன்றைக்குக் யெகோவா உங்களுக்குச் செய்யும் இரட்சிப்பைப் பாருங்கள்; இன்றைக்கு நீங்கள் காண்கிற எகிப்தியர்களை இனி என்றைக்கும் காணமாட்டீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","யெகோவா உங்களுக்காக யுத்தம்செய்வார்; நீங்கள் சும்மாயிருப்பீர்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","அப்பொழுது யெகோவா மோசேயை நோக்கி: “நீ என்னிடம் முறையிடுகிறது என்ன? புறப்பட்டுப் போங்கள் என்று இஸ்ரவேலர்களுக்குச் சொல்லு. ");
INSERT INTO tam2017_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","நீ உன்னுடைய கோலை ஓங்கி, உன்னுடைய கையைக் கடலின்மேல் நீட்டி, கடலைப் பிளந்துவிடு; அப்பொழுது இஸ்ரவேல் மக்கள் கடலின் நடுவாக வறண்ட நிலத்தில் நடந்துபோவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","எகிப்தியர்கள் உங்களைப் பின்தொடர்ந்து வரும்படி நான் அவர்களின் இருதயத்தைக் கடினப்படுத்தி பார்வோனாலும் அவன் இரதங்கள் குதிரைவீரர்கள் முதலாகிய அவனுடைய எல்லா இராணுவத்தாலும் மகிமைப்படுவேன். ");
INSERT INTO tam2017_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","இப்படி நான் பார்வோனாலும் அவனுடைய இரதங்களாலும் அவனுடைய குதிரைவீரர்களாலும் மகிமைப்படும்போது, நானே யெகோவா என்பதை எகிப்தியர்கள் அறிவார்கள் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","அப்பொழுது இஸ்ரவேலர்களின் சேனைக்கு முன்னாக நடந்த தேவதூதனானவர் விலகி, அவர்களுக்குப் பின்னாக நடந்தார்; அவர்களுக்கு முன்பு இருந்த மேகத்தூணிலும் விலகி, அவர்கள் பின்னே நின்றது. ");
INSERT INTO tam2017_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","அது எகிப்தியர்களின் சேனையும் இஸ்ரவேலர்களின் சேனையும் இரவுமுழுவதும் ஒன்றோடொன்று சேராதபடி அவைகள் நடுவில் வந்தது; எகிப்தியர்களுக்கு அது மேகமும் இருளாகவும் இருந்தது, இஸ்ரவேலர்களுக்கோ அது இரவை வெளிச்சமாக்கிற்று. ");
INSERT INTO tam2017_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","மோசே தன்னுடைய கையைக் கடலின்மேல் நீட்டினான்; அப்பொழுது யெகோவா இரவுமுழுவதும் பலத்த கிழக்குக் காற்றினால் கடல் ஒதுங்கும்படிச் செய்து, அதை வறண்டுபோகச்செய்தார்; தண்ணீர் பிளந்து பிரிந்துபோனது. ");
INSERT INTO tam2017_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","இஸ்ரவேலர்கள் கடலின் நடுவாக வறண்ட நிலத்தில் நடந்துபோனார்கள்; அவர்களுடைய வலதுபுறத்திலும் அவர்களுடைய இடதுபுறத்திலும் தண்ணீர் அவர்களுக்கு மதிலாக நின்றது. ");
INSERT INTO tam2017_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","அப்பொழுது எகிப்தியர்கள் அவர்களைத் தொடர்ந்து, பார்வோனுடைய எல்லாக் குதிரைகளோடும் இரதங்களோடும் குதிரைவீரர்களோடும் அவர்கள் பின்னால் கடலின் நடுவே நடந்துபோனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","காலை நேரத்தில் யெகோவா அக்கினியும் மேகமுமான மண்டலத்திலிருந்து எகிப்தியர்களின் சேனையைப் பார்த்து, அவர்களுடைய சேனையைக் கலங்கடித்து, ");
INSERT INTO tam2017_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","அவர்களுடைய இரதங்களிலிருந்து சக்கரங்கள் கழன்றுபோகவும், அவர்கள் தங்களுடைய இரதங்களை வருத்தத்தோடு நடத்தவும் செய்தார்; அப்பொழுது எகிப்தியர்கள்: “இஸ்ரவேலர்களைவிட்டு ஓடிப்போவோம், யெகோவா அவர்களுக்குத் துணைநின்று எகிப்தியர்களுக்கு விரோதமாக யுத்தம்செய்கிறார்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","யெகோவா மோசேயை நோக்கி: “தண்ணீர் எகிப்தியர்கள்மேலும் அவர்களுடைய இரதங்களின்மேலும் அவர்களுடைய குதிரைவீரர்களின்மேலும் திரும்பும்படி, உன்னுடைய கையைக் கடலின்மேல் நீட்டு” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","அப்படியே மோசே தன்னுடைய கையைக் கடலின்மேல் நீட்டினான்; அதிகாலையில் கடல் பலமாகத் திரும்பி வந்தது; எகிப்தியர்கள் அதற்கு எதிராக ஓடும்போது, யெகோவா அவர்களைக் கடலின் நடுவே அமிழ்த்திப்போட்டார். ");
INSERT INTO tam2017_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","தண்ணீர் திரும்பிவந்து, இரதங்களையும் குதிரைவீரர்களையும், அவர்கள் பின்னாக கடலில் நுழைந்திருந்த பார்வோனுடைய இராணுவம் அனைத்தையும் மூடிக்கொண்டது; அவர்களில் ஒருவனாகிலும் தப்பவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","இஸ்ரவேலர்களோ கடலின் நடுவாக வறண்ட நிலத்தின் வழியாக நடந்துபோனார்கள்; அவர்களுடைய வலதுபுறத்திலும் அவர்களுடைய இடதுபுறத்திலும் தண்ணீர் அவர்களுக்கு மதிலாக நின்றது. ");
INSERT INTO tam2017_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","இப்படியாகக் யெகோவா அந்த நாளிலே இஸ்ரவேலர்களை எகிப்தியர்களின் கைக்குத் தப்புவித்தார்; கடற்கரையிலே எகிப்தியர்கள் செத்துக்கிடக்கிறதை இஸ்ரவேலர்கள் கண்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","யெகோவா எகிப்தியர்களில் செய்த அந்த மகத்தான செயல்களை இஸ்ரவேலர்கள் கண்டார்கள்; அப்பொழுது மக்கள் யெகோவாவுக்குப் பயந்து, யெகோவாவிடத்திலும் அவருடைய ஊழியக்காரனாகிய மோசேயினிடத்திலும் நம்பிக்கை வைத்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","அப்பொழுது மோசேயும் இஸ்ரவேல் மக்களும் யெகோவாவைப் புகழ்ந்துபாடின பாட்டு: யெகோவாவைப் பாடுவேன்; “அவர் மகிமையாக வெற்றி சிறந்தார்; குதிரையையும் குதிரைவீரனையும் கடலிலே தள்ளினார். ");
INSERT INTO tam2017_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","யெகோவா என்னுடைய பெலனும் என்னுடைய கீதமுமானவர்; அவர் எனக்கு இரட்சிப்புமானவர்; அவரே என்னுடைய தேவன், அவருக்கு வாசஸ்தலத்தை ஆயத்தம்செய்வேன்; அவரே என் தகப்பனுடைய தேவன், அவரை உயர்த்துவேன்; ");
INSERT INTO tam2017_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","யெகோவாவே யுத்தத்தில் வல்லவர்; என்பது யெகோவா அவருடைய நாமம். ");
INSERT INTO tam2017_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","பார்வோனின் இரதங்களையும் அவனுடைய சேனைகளையும் கடலிலே தள்ளிவிட்டார்; அவனுடைய முதன்மையான அதிகாரிகள் செங்கடலில் அமிழ்ந்துபோனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","ஆழம் அவர்களை மூடிக்கொண்டது; கல்லைப்போல ஆழங்களில் அமிழ்ந்துபோனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","யெகோவாவே, உம்முடைய வலதுகரம் பெலத்தினால் மகத்துவம் சிறந்திருக்கிறது; யெகோவாவே, உம்முடைய வலதுகரம் எதிரியை நொறுக்கிவிட்டது. ");
INSERT INTO tam2017_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","உமக்கு விரோதமாக எழும்பினவர்களை உமது பெரிய மகத்துவத்தினாலே அழித்துப்போட்டீர்; உம்முடைய கோபத்தை அனுப்பினீர், அது அவர்களை வைக்கோல்தாளடியைப்போல எரித்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","உமது நாசியின் சுவாசத்தினால் தண்ணீர் குவிந்து நின்றது; வெள்ளம் குவியலாக நிமிர்ந்து நின்றது; ஆழமான தண்ணீர் நடுக்கடலிலே உறைந்துபோனது. ");
INSERT INTO tam2017_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","தொடருவேன், பிடிப்பேன், கொள்ளையடித்துப் பங்கிடுவேன், என்னுடைய ஆசை அவர்களிடம் திருப்தியாகும், என்னுடைய பட்டயத்தை உருவுவேன், என்னுடைய கை அவர்களை அழிக்கும் என்று எதிரி சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","உம்முடைய காற்றை வீசச்செய்தீர், கடல் அவர்களை மூடிக்கொண்டது; திரளான தண்ணீர்களில் ஈயம்போல அமிழ்ந்துபோனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","யெகோவாவே, தெய்வங்களில் உமக்கு ஒப்பானவர் யார்? பரிசுத்தத்தில் மகத்துவமுள்ளவரும், துதிகளில் பயப்படத்தக்கவரும், அற்புதங்களைச் செய்கிறவருமாகிய உமக்கு ஒப்பானவர் யார்? ");
INSERT INTO tam2017_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","நீர் உமது வலதுகரத்தை நீட்டினீர்; பூமி அவர்களை விழுங்கிப்போட்டது. ");
INSERT INTO tam2017_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","நீர் மீட்டுக்கொண்ட இந்த மக்களை உமது கிருபையினாலே அழைத்து வந்தீர்; உம்முடைய பரிசுத்த வாசஸ்தலத்திற்கு நேராக அவர்களை உமது பெலத்தினால் வழிநடத்தினீர். ");
INSERT INTO tam2017_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","மக்கள் அதைக் கேட்டுத் தத்தளிப்பார்கள்; பெலிஸ்தியாவில் குடியிருப்பவர்களைத் திகில் பிடிக்கும். ");
INSERT INTO tam2017_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ஏதோமின் பிரபுக்கள் கலங்குவார்கள்; மோவாபின் பலசாலிகளை நடுக்கம் பிடிக்கும்; கானானில் குடியிருப்பவர்கள் யாவரும் கரைந்துபோவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","பயமும் திகிலும் அவர்கள்மேல் விழும். யெகோவாவே, உமது மக்கள் கடந்துபோகும்வரையும், நீர் மீட்ட மக்கள் கடந்துபோகும்வரையும், அவர்கள் உம்முடைய கரத்தின் மகத்துவத்தினால் கல்லைப்போல அசைவில்லாமல் இருப்பார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","நீர் அவர்களைக் கொண்டுபோய், யெகோவாவாகிய தேவரீர் தங்குவதற்கு நியமித்த இடமாகிய உம்முடைய சுதந்திரத்தின் பர்வதத்திலும், ஆண்டவராகிய தேவரீருடைய கரங்கள் உண்டாக்கிய பரிசுத்த ஸ்தலத்திலும் அவர்களை நாட்டுவீர். ");
INSERT INTO tam2017_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","யெகோவா சதாகாலங்களாகிய என்றென்றைக்கும் ராஜரிகம்செய்வார். ");
INSERT INTO tam2017_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","பார்வோனின் குதிரைகள் அவனுடைய இரதங்களோடும் குதிரைவீரர்களோடும் கடலில் நுழைந்தது; யெகோவா கடலின் தண்ணீரை அவர்கள்மேல் திரும்பச்செய்தார்; இஸ்ரவேலர்களோ கடலின் நடுவே காய்ந்த நிலத்திலே நடந்துபோனார்கள்” என்று பாடினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","ஆரோனின் சகோதரியாகிய மிரியாம் என்னும் தீர்க்கதரிசியானவளும் தன்னுடைய கையிலே தம்புரை எடுத்துக்கொண்டாள்; எல்லாப் பெண்களும் தம்புருக்களோடும் நடனத்தோடும் அவளுக்குப் பின்னே புறப்பட்டுப்போனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","மிரியாம் அவர்களுக்குப் பதிலாக: யெகோவாவைப் பாடுங்கள், அவர் மகிமையாக வெற்றிசிறந்தார்; குதிரையையும் குதிரைவீரனையும் கடலிலே தள்ளினார் என்று பாடினாள். ");
INSERT INTO tam2017_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","பின்பு மோசே இஸ்ரவேல் மக்களைச் செங்கடலிலிருந்து பயணமாக நடத்தினான். அவர்கள் சூர் வனாந்திரத்திற்குப் புறப்பட்டுப்போய், மூன்று நாட்கள் வனாந்திரத்தில் தண்ணீர் கிடைக்காமல் நடந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","அவர்கள் மாராவிற்கு வந்தபோது, மாராவின் தண்ணீர் கசப்பாக இருந்ததால் அதைக் குடிக்க அவர்களுக்கு முடியாமல் இருந்தது; அதினால் அந்த இடத்திற்கு மாரா என்று பெயரிடப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","அப்பொழுது மக்கள் மோசேக்கு விரோதமாக முறுமுறுத்து: என்னத்தைக் குடிப்போம் என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","மோசே யெகோவாவை நோக்கிக் கூப்பிட்டான்; அப்பொழுது யெகோவா மோசேக்கு ஒரு மரத்தைக் காண்பித்தார்; அதை அவன் தண்ணீரில் போட்டவுடன், அது இனிமையான தண்ணீரானது. அவர் அங்கே அவர்களுக்கு ஒரு கட்டளையையும், ஒரு நீதிநெறிகளையும் கட்டளையிட்டு, அங்கே அவர்களைச் சோதித்து: ");
INSERT INTO tam2017_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","நீ உன்னுடைய தேவனாகிய யெகோவாவின் சத்தத்தைக் கவனமாகக் கேட்டு, அவருடைய பார்வைக்குச் செம்மையானவைகளைச் செய்து, அவருடைய கட்டளைகளுக்குக் கவனித்து, அவருடைய கட்டளைகள் யாவையும் கைக்கொண்டால், நான் எகிப்தியர்களுக்கு வரச்செய்த வியாதிகளில் ஒன்றையும் உனக்கு வரச்செய்யாதிருப்பேன்; நானே உன்னை குணப்படுத்தும் யெகோவா” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","பின்பு அவர்கள் ஏலிமுக்கு வந்தார்கள்; அங்கே பன்னிரண்டு நீரூற்றுகளும் எழுபது பேரீச்சமரங்களும் இருந்தது; அங்கே தண்ணீர் அருகே முகாமிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","இஸ்ரவேலர்களாகிய சபையார்கள் எல்லோரும் ஏலிமைவிட்டு பயணம்செய்து, எகிப்து தேசத்திலிருந்து புறப்பட்ட இரண்டாம் மாதம் பதினைந்தாம் தேதியிலே, ஏலிமுக்கும் சீனாய்க்கும் நடுவே இருக்கிற சீன் வனாந்திரத்திற்கு வந்துசேர்ந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","அந்த வனாந்திரத்திலே இஸ்ரவேலர்களாகிய சபையார்கள் எல்லோரும் மோசேக்கும் ஆரோனுக்கும் விரோதமாக முறுமுறுத்து: ");
INSERT INTO tam2017_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","“நாங்கள் இறைச்சிப் பாத்திரங்களின் அருகிலே உட்கார்ந்து அப்பத்தைத் திருப்தியாகச் சாப்பிட்ட எகிப்து தேசத்தில், யெகோவாவின் கையால் செத்துப்போனால் பரவாயில்லை; இந்தக் கூட்டம் முழுவதையும் பட்டினியினால் கொல்லும்படி நீங்கள் எங்களைப் புறப்படச்செய்து, இந்த வனாந்திரத்திலே அழைத்துவந்தீர்களே” என்று அவர்களிடம் சொன்னார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","அப்பொழுது யெகோவா மோசேயை நோக்கி: “நான் உங்களுக்கு வானத்திலிருந்து அப்பம் வரச்செய்வேன்; மக்கள் போய், ஒவ்வொரு நாளுக்கு வேண்டியதை ஒவ்வொரு நாளிலும் சேர்த்துக்கொள்ளவேண்டும்; அதினால் அவர்கள் என்னுடைய கட்டளையின்படி நடப்பார்களோ நடக்கமாட்டார்களோ என்று அவர்களைச் சோதிப்பேன். ");
INSERT INTO tam2017_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ஆறாம் நாளிலோ, அவர்கள் தினந்தோறும் சேர்க்கிறதைவிட இரண்டுமடங்கு சேர்த்து, அதை ஆயத்தம்செய்து வைக்கவேண்டும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","அப்பொழுது மோசேயும் ஆரோனும் இஸ்ரவேல் மக்கள் எல்லோரையும் நோக்கி: “யெகோவாவே உங்களை எகிப்து தேசத்திலிருந்து புறப்படச்செய்தவர் என்பதை மாலையில் அறிவீர்கள்; ");
INSERT INTO tam2017_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","அதிகாலையில் யெகோவாடைய மகிமையையும் காண்பீர்கள்; யெகோவாவுக்கு விரோதமான உங்களுடைய முறுமுறுப்புகளை அவர் கேட்டார்; நீங்கள் எங்களுக்கு விரோதமாக முறுமுறுப்பதற்கு நாங்கள் எம்மாத்திரம்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","பின்னும் மோசே: “மாலையில் நீங்கள் சாப்பிடுவதற்குக் யெகோவா உங்களுக்கு இறைச்சியையும், அதிகாலையில் நீங்கள் திருப்தியடைவதற்கு அப்பத்தையும் கொடுக்கும்போது இது வெளிப்படும்; யெகோவாவுக்கு விரோதமாக நீங்கள் முறுமுறுத்த உங்களுடைய முறுமுறுப்புகளை அவர் கேட்டார்; நாங்கள் எம்மாத்திரம்? உங்களுடைய முறுமுறுப்புகள் எங்களுக்கு அல்ல, யெகோவாவுக்கே விரோதமாக இருக்கிறது” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","அப்பொழுது மோசே ஆரோனைப் பார்த்து: “நீ இஸ்ரவேல் மக்களாகிய சபையார்கள் எல்லோரையும் நோக்கி: யெகோவாவுக்கு முன்பாக சேருங்கள், அவர் உங்களுடைய முறுமுறுப்புகளைக் கேட்டார் என்று சொல்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","ஆரோன் இஸ்ரவேல் மக்களாகிய சபையார்களுக்கெல்லாம் இதைச் சொல்லுகிறபோது, அவர்கள் வனாந்திரதிசையாகத் திரும்பிப்பார்த்தார்கள்; அப்பொழுது யெகோவாவுடைய மகிமை மேகத்திலே காணப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“இஸ்ரவேல் மக்களின் முறுமுறுப்புகளைக் கேட்டிருக்கிறேன்; நீ அவர்களுடன் பேசி, நீங்கள் மாலையில் இறைச்சியைச் சாப்பிட்டு, அதிகாலையில் அப்பத்தால் திருப்தியாகி, நான் உங்களுடைய தேவனாகிய யெகோவா என்பதை அறிந்துகொள்வீர்கள் என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","மாலையில் காடைகள் வந்து விழுந்து முகாமை மூடிக்கொண்டது. அதிகாலையில் முகாமைச் சுற்றி பனி பெய்திருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","பெய்திருந்த பனி நீங்கினபின்பு, இதோ, வனாந்திரத்தின்மீது எங்கும் உருண்டையான ஒரு சிறிய பொருள் உறைந்த பனிக்கட்டிப் பொடியைப்போலத் தரையின்மேல் கிடந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","இஸ்ரவேல் மக்கள் அதைக் கண்டு, அது என்னவென்று அறியாமல் இருந்து, ஒருவரை ஒருவர் பார்த்து, “இது என்ன என்றார்கள்; அப்பொழுது மோசே அவர்களை நோக்கி: “இது யெகோவா உங்களுக்குச் சாப்பிடக்கொடுத்த அப்பம். ");
INSERT INTO tam2017_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","யெகோவா கட்டளையிடுகிறது என்னவென்றால், அவரவர் சாப்பிடும் அளவுக்குத் தகுந்தபடி அதில் எடுத்துச் சேர்க்கட்டும்; உங்களிலுள்ள நபர்களின் எண்ணிக்கையின்படி, அவனவன் தன் தன் கூடாரத்தில் இருக்கிறவர்களுக்காக தலைக்கு ஒரு ஓமர் அளவு எடுத்துக்கொள்ளட்டும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","இஸ்ரவேல் மக்கள் அப்படியே செய்து, சிலர் அதிகமாகவும் சிலர் குறைவாகவும் சேர்த்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","பின்பு, அதை ஓமரால் அளந்தார்கள்: அதிகமாகச் சேர்த்தவனுக்கு மீதியானதும் இல்லை, குறைவாகச் சேர்த்தவனுக்குக் குறைவானதும் இல்லை; அவரவர் தாங்கள் சாப்பிடும் அளவுக்குத்தகுந்தபடி சேர்த்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","மோசே அவர்களை நோக்கி: “ஒருவனும் அதிகாலைவரை அதில் ஒன்றும் வைக்கக்கூடாது என்று அவர்களுக்குச் சொல்லியும்; ");
INSERT INTO tam2017_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","மோசேயின் சொல் கேட்காமல், சிலர் அதில் அதிகாலைவரை சிறிதளவு மீதியாக வைத்தார்கள்; அது பூச்சி பிடித்து நாற்றமெடுத்தது. அவர்கள்மேல் மோசே கோபம்கொண்டான். ");
INSERT INTO tam2017_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","அதை அதிகாலைதோறும் அவரவர் சாப்பிடும் அளவுக்குத்தகுந்தபடி சேர்த்தார்கள், வெயில் ஏறஏற அது உருகிப்போகும். ");
INSERT INTO tam2017_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ஆறாம் நாளில் தலைக்கு இரண்டு ஓமர் வீதமாக இரண்டுமடங்காக ஆகாரம் சேர்த்தார்கள்; அப்பொழுது சபையின் தலைவர்கள் எல்லோரும் வந்து, அதை மோசேக்கு அறிவித்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","அவன் அவர்களை நோக்கி: “யெகோவா சொன்னது இதுதான்; நாளைக்குக் யெகோவாவுக்குறிய பரிசுத்த ஓய்வுநாளாகிய ஓய்வு; நீங்கள் சுடவேண்டியதைச் சுட்டு, வேகவைக்கவேண்டியதை வேகவைத்து, மீதியாக இருக்கிறதையெல்லாம் நாளைவரை உங்களுக்காக வைத்துவையுங்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","மோசே கட்டளையிட்டபடி, அதை மறுநாள்வரைக்கும் வைத்துவைத்தார்கள்; அப்பொழுது அது நாறவும் இல்லை, அதிலே பூச்சிபிடிக்கவும் இல்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","அப்பொழுது மோசே; “அதை இன்றைக்குச் சாப்பிடுங்கள்; இன்று யெகோவாவுக்குரிய ஓய்வுநாள்; இன்று நீங்கள் அதை வெளியிலே காணமாட்டீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ஆறுநாட்களும் அதைச் சேர்ப்பீர்களாக; ஏழாம்நாள் ஓய்வுநாளாக இருக்கிறது; அதிலே அது உண்டாகாது” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ஏழாம்நாளில் மக்களில் சிலர் அதைச் சேர்க்கப் புறப்பட்டார்கள்; அவர்கள் அதைப் பார்க்கவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","அப்பொழுது யெகோவா மோசேயை நோக்கி: “என்னுடைய கட்டளைகளையும் என்னுடைய சட்டங்களையும் கைக்கொள்ள எதுவரை மனம் இல்லாமல் இருப்பீர்கள்? ");
INSERT INTO tam2017_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","பாருங்கள், யெகோவா உங்களுக்கு ஓய்வுநாளை கொடுத்தபடியால், அவர் உங்களுக்கு ஆறாம்நாளில் இரண்டு நாளுக்கு வேண்டிய ஆகாரத்தைக் கொடுக்கிறார்; ஏழாம்நாளில் உங்களில் ஒருவனும் தன்தன் இடத்திலிருந்து புறப்படாமல், அவனவன் தன் தன் இடத்திலே இருக்கவேண்டும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","அப்படியே மக்கள் ஏழாம்நாளில் ஓய்ந்திருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","இஸ்ரவேல் மக்கள் அதற்கு மன்னா என்று பெயரிட்டார்கள்; அது கொத்துமல்லி அளவாகவும் வெண்மைநிறமாகவும் இருந்தது, அதின் ருசி தேனிட்ட பணியாரத்தைப்போல இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","அப்பொழுது மோசே: “யெகோவா கட்டளையிட்ட காரியம் என்னவென்றால், நான் உங்களை எகிப்து தேசத்திலிருந்து புறப்படச்செய்தபோது, வனாந்திரத்தில் உங்களுக்கு சாப்பிடக்கொடுத்த அப்பத்தை உங்கள் சந்ததியார்கள் பார்க்கும்படி, அவர்களுக்காக அதைப் பாதுகாப்பதற்கு, அதிலே ஒரு ஓமர் நிறைய எடுத்து வைக்கவேண்டும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","மேலும், மோசே ஆரோனை நோக்கி: “நீ ஒரு பாத்திரத்தை எடுத்து, அதிலே ஒரு ஓமர் அளவு மன்னாவைப் போட்டு, அதை உங்களுடைய சந்ததியார்களுக்காகப் பாதுகாப்பதற்குக் யெகோவாவுடைய சந்நிதியிலே வை” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","யெகோவா மோசேக்குக் கட்டளையிட்டபடியே அது காக்கப்படும்படி ஆரோன் அதைச் சாட்சி சந்நிதியில் வைத்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","இஸ்ரவேல் மக்கள் குடியிருப்பான தேசத்திற்கு வரும்வரை நாற்பது வருடங்கள் மன்னாவை சாப்பிட்டார்கள்; அவர்கள் கானான் தேசத்தின் எல்லையில் சேரும்வரையும் மன்னாவை சாப்பிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","ஒரு ஓமரானது எப்பாவிலே பத்தில் ஒரு பங்கு. ");
INSERT INTO tam2017_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","பின்பு இஸ்ரவேலர்களாகிய சபையார்கள் எல்லோரும் யெகோவாவுடைய கட்டளையின்படி சீன் வனாந்திரத்திலிருந்து புறப்பட்டு, பயணம்செய்து, ரெவிதீமிலே வந்து முகாமிட்டார்கள்; அங்கே மக்களுக்குக் குடிக்கத் தண்ணீர் இல்லாமல் இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","அப்பொழுது மக்கள் மோசேயோடு வாதாடி: “நாங்கள் குடிக்கிறதற்கு எங்களுக்குத் தண்ணீர் தரவேண்டும்” என்றார்கள். அதற்கு மோசே: “என்னோடு ஏன் வாதாடுகிறீர்கள், யெகோவாவை ஏன் பரீட்சை பார்க்கிறீர்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","மக்கள் அந்த இடத்தில் தண்ணீர்த் தாகமாக இருந்தபடியால், அவர்கள் மோசேக்கு விரோதமாக முறுமுறுத்து: “நீர் எங்களையும் எங்களுடைய பிள்ளைகளையும் எங்களுடைய ஆடுமாடுகளையும் தண்ணீர்த் தாகத்தினால் கொன்றுபோட எங்களை எகிப்திலிருந்து ஏன் கொண்டுவந்தீர்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","மோசே யெகோவாவை நோக்கிக் கூப்பிட்டு: “இந்த மக்களுக்கு நான் என்ன செய்வேன், இவர்கள் என்மேல் கல்லெறியப் பார்க்கிறார்களே” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","அப்பொழுது யெகோவா மோசேயை நோக்கி: “நீ இஸ்ரவேல் மூப்பர்களில் சிலரை உன்னோடு கூட்டிக்கொண்டு, நீ நதியை அடித்த உன்னுடைய கோலை உன்னுடைய கையில் பிடித்துக்கொண்டு, மக்களுக்கு முன்னே நடந்துபோ. ");
INSERT INTO tam2017_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","அங்கே ஓரேபிலே நான் உனக்கு முன்பாகக் கன்மலையின்மேல் நிற்பேன்; நீ அந்தக் கன்மலையை அடி; அப்பொழுது மக்கள் குடிக்க அதிலிருந்து தண்ணீர் புறப்படும்” என்றார்; அப்படியே மோசே இஸ்ரவேல் மூப்பர்களின் கண்களுக்கு முன்பாகச் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","இஸ்ரவேலர்கள் வாதாடினதற்காகவும், “யெகோவா எங்களுடைய நடுவில் இருக்கிறாரா இல்லையா” என்று அவர்கள் யெகோவாவை சோதித்துப் பார்த்ததினாலும், அவன் அந்த இடத்திற்கு மாசா என்றும், மேரிபா என்றும் பெயரிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","அமலேக்கியர்கள் வந்து ரெவிதீமிலே இஸ்ரவேலர்களோடு யுத்தம்செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","அப்பொழுது மோசே யோசுவாவை நோக்கி: “நீ நமக்காக மனிதர்களைத் தெரிந்துகொண்டு, புறப்பட்டு, அமலேக்கியர்களோடு யுத்தம்செய்; நாளைக்கு நான் மலைமேல் தேவனுடைய கோலை என்னுடைய கையில் பிடித்துக்கொண்டு நிற்பேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","யோசுவா தனக்கு மோசே சொன்னபடியே செய்து, அமலேக்கியர்களோடு யுத்தம்செய்தான். மோசேயும், ஆரோனும், ஊர் என்பவனும் மலைமேல் ஏறினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","மோசே தன்னுடைய கையை மேலே பிடித்திருக்கும்போது, இஸ்ரவேலர்கள் வெற்றிபெற்றார்கள்; அவன் தன்னுடைய கையைகீழே விடும்போது, அமலேக்கு வெற்றிபெற்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","மோசேயின் கைகள் சோர்ந்துபோனது, அப்பொழுது அவர்கள் ஒரு கல்லைக் கொண்டுவந்து அவன் கீழே வைத்தார்கள்; அதின்மேல் உட்கார்ந்தான்; ஆரோனும், ஊரும் ஒருவன் ஒரு பக்கத்திலும் ஒருவன் மறுபக்கத்திலும் இருந்து, அவனுடைய கைகளைத் தாங்கினார்கள்; இந்த விதமாக அவனுடைய கைகள் சூரியன் மறையும்வரையும் ஒரே நிலையாக இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","யோசுவா அமலேக்கையும் அவனுடைய மக்களையும் கூர்மையான பட்டயத்தாலே தோற்கடித்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","பின்பு யெகோவா மோசேயை நோக்கி: “இதை நினைவுகூரும்படி, நீ ஒரு புத்தகத்தில் எழுதி, யோசுவாவின் காதிலே கேட்கும்படி வாசி. அமலேக்கை வானத்தின் கீழே எங்கும் இல்லாதபடி நாசம் செய்வேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","மோசே ஒரு பலிபீடத்தைக் கட்டி, அதற்கு யேகோவாநிசி என்று பெயரிட்டு, ");
INSERT INTO tam2017_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","“அமலேக்கின் கை யெகோவாவுடைய சிங்காசனத்திற்கு விரோதமாக இருந்தபடியால், தலைமுறை தலைமுறைதோறும் அவனுக்கு விரோதமாக யெகோவாவின் யுத்தம் நடக்கும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","தேவன் மோசேக்கும் தமது மக்களாகிய இஸ்ரவேலர்களுக்கும் செய்த யாவையும், யெகோவா இஸ்ரவேலர்களை எகிப்திலிருந்து புறப்படச்செய்ததையும், மீதியானில் ஆசாரியனாக இருந்த மோசேயின் மாமனாகிய எத்திரோ கேள்விப்பட்டபோது, ");
INSERT INTO tam2017_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","மோசேயின் மாமனாகிய எத்திரோ, மோசேயினால் திரும்பி அனுப்பிவிடப்பட்டிருந்த அவனுடைய மனைவியாகிய சிப்போராளையும், ");
INSERT INTO tam2017_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","அவளுடைய இரண்டு மகன்களையும் அழைத்துக்கொண்டு பயணப்பட்டான். “நான் அந்நிய தேசத்திலே பரதேசியானேன்” என்று மோசே சொல்லி, ஒரு மகனுக்குக் கெர்சோம் என்று பெயரிட்டிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","“என்னுடைய பிதாவின் தேவன் எனக்குத் துணைநின்று பார்வோனின் பட்டயத்திற்கு என்னைத் தப்புவித்தார்” என்று சொல்லி, மற்றவனுக்கு எலியேசர் என்று பெயரிட்டிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","மோசேயின் மாமனாகிய எத்திரோ மோசேயின் மகன்களோடும் அவனுடைய மனைவியோடும், அவன் முகாமிட்டிருந்த தேவனுடைய மலையினிடத்தில் வனாந்திரத்திற்கு வந்து: ");
INSERT INTO tam2017_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","“எத்திரோ என்னும் உம்முடைய மாமனாகிய நானும், உம்முடைய மனைவியும், அவளுடன் அவளுடைய இரண்டு மகன்களும் உம்மிடம் வந்திருக்கிறோம்” என்று மோசேக்குச் சொல்லி அனுப்பினான். ");
INSERT INTO tam2017_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","அப்பொழுது மோசே தன்னுடைய மாமனுக்கு எதிராகப்போய், அவனை வணங்கி, முத்தம்செய்தான்; ஒருவரை ஒருவர் சுகசெய்தி விசாரித்துக்கொண்டு, கூடாரத்திற்குள் நுழைந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","பின்பு மோசே யெகோவா இஸ்ரவேலுக்காக பார்வோனுக்கும் எகிப்தியர்களுக்கும் செய்த எல்லாவற்றையும், வழியிலே தங்களுக்கு சம்பவித்த எல்லா வருத்தத்தையும், யெகோவா தங்களை விடுவித்து இரட்சித்ததையும் தன்னுடைய மாமனுக்கு விவரித்துச் சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","யெகோவா இஸ்ரவேலர்களை எகிப்தியர்களின் கைக்குத் தப்புவித்து, அவர்களுக்குச் செய்த எல்லா நன்மைகளையும்குறித்து எத்திரோ சந்தோஷப்பட்டு: ");
INSERT INTO tam2017_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","“உங்களை எகிப்தியர்களின் கைக்கும் பார்வோனின் கைக்கும் தப்புவித்து, எகிப்தியர்களுடைய கையின் கீழ் இருந்த மக்களை விடுவித்த யெகோவாவுக்கு ஸ்தோத்திரம். ");
INSERT INTO tam2017_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","யெகோவா எல்லா தெய்வங்களையும்விட பெரியவர் என்பதை இப்பொழுது அறிந்திருக்கிறேன்; அவர்கள் ஆணவமாக செய்த காரியத்தில் அவர்களை மேற்கொண்டார்” என்று சொல்லி; ");
INSERT INTO tam2017_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","மோசேயின் மாமனாகிய எத்திரோ சர்வாங்கதகனபலியையும் மற்ற பலிகளையும் தேவனுக்குக் கொண்டுவந்து செலுத்தினான். பின்பு ஆரோனும் இஸ்ரவேல் மூப்பர்கள் அனைவரும் வந்து, மோசேயின் மாமனுடனே தேவசமுகத்தில் சாப்பிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","மறுநாள் மோசே மக்களை நியாயம் விசாரிக்க உட்கார்ந்தான்; மக்கள் காலை துவங்கி மாலைவரை மோசேக்கு முன்பாக நின்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","மக்களுக்கு அவன் செய்த யாவையும் மோசேயின் மாமன் கண்டு: “நீர் மக்களுக்குச் செய்கிற இந்தக் காரியம் என்ன? நீர் தனியாக உட்கார்ந்திருக்கவும், மக்கள் எல்லோரும் காலை துவங்கி மாலைவரை உமக்கு முன்பாக நிற்கவும் வேண்டியது ஏன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","அப்பொழுது மோசே தன்னுடைய மாமனை நோக்கி: “தேவனிடம் விசாரிக்கும்படி மக்கள் என்னிடம் வருகிறார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","அவர்களுக்கு ஏதாவது காரியம் உண்டானால், என்னிடத்தில் வருகிறார்கள்; நான் அவர்களுக்குள்ள வழக்கைத் தீர்த்து, தேவகட்டளைகளையும் அவருடைய பிரமாணங்களையும் தெரிவிக்கிறேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","அதற்கு மோசேயின் மாமன்: “நீர் செய்கிற காரியம் நல்லதல்ல; ");
INSERT INTO tam2017_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","நீரும் உம்மோடே இருக்கிற மக்களும் களைத்துப்போவீர்கள்; இது உமக்கு மிகவும் பாரமான காரியம்; நீர் ஒருவராக அதைச் செய்ய உம்மாலே முடியாது. ");
INSERT INTO tam2017_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","இப்பொழுது என்னுடைய சொல்லைக்கேளும், உமக்கு ஒரு ஆலோசனை சொல்லுகிறேன்; தேவனும் உம்மோடு இருப்பார், நீர் தேவசந்நிதியிலே மக்களுக்காக இரும்; விசேஷித்தவைகளைத் தேவனிடம் கொண்டுபோய்; ");
INSERT INTO tam2017_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","கட்டளைகளையும் பிரமாணங்களையும் அவர்களுக்கு வெளிப்படுத்தி; அவர்கள் நடக்கவேண்டிய வழியையும், அவர்கள் செய்யவேண்டிய காரியத்தையும் அவர்களுக்குத் தெரியப்படுத்தும். ");
INSERT INTO tam2017_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","மக்கள் எல்லோருக்குள்ளும் தேவனுக்குப் பயந்தவர்களும் உண்மையுள்ளவர்களும் பொருளாசையை வெறுக்கிறவர்களுமான திறமையுள்ள மனிதர்களைத் தெரிந்துகொண்டு, அவர்களை ஆயிரம்பேருக்குத் தலைவர்களாகவும், நூறுபேருக்குத் தலைவர்களாகவும், ஐம்பதுபேருக்குத் தலைவர்களாகவும், பத்துபேருக்குத் தலைவர்களாகவும் ஏற்படுத்தும். ");
INSERT INTO tam2017_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","அவர்கள் எப்பொழுதும் மக்களை நியாயம் விசாரித்து, பெரிய காரியங்கள் எல்லாவற்றையும் உம்மிடம் கொண்டுவரட்டும், சிறிய காரியங்கள் யாவையும் தாங்களே தீர்க்கட்டும்; இப்படி அவர்கள் உம்மோடு இந்தப் பாரத்தைச் சுமந்தால், உமக்கு இலகுவாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","இப்படி நீர் செய்வதும், இப்படி தேவன் உமக்குக் கட்டளையிடுவதும் உண்டானால், உம்மாலே சுமக்கமுடியும்; இந்த மக்கள் எல்லோரும் தாங்கள் போகும் இடத்திற்குச் சுகமாகப் போய்ச் சேரலாம்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","மோசே தன்னுடைய மாமனுடைய சொல்லைக்கேட்டு, அவன் சொன்னபடியெல்லாம் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","மோசே இஸ்ரவேலர்கள் எல்லோரிலும் திறமையுள்ள மனிதர்களைத் தெரிந்துகொண்டு, அவர்களை ஆயிரம்பேருக்குத் தலைவர்களாகவும், நூறுபேருக்குத் தலைவர்களாகவும், ஐம்பதுபேருக்குத் தலைவர்களாகவும், பத்துபேருக்குத் தலைவர்களாகவும் மக்கள்மேல் தலைவர்களாக்கினான். ");
INSERT INTO tam2017_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","அவர்கள் எப்பொழுதும் மக்களை நியாயம் விசாரித்தார்கள்; வருத்தமான காரியங்களைமட்டும் மோசேயிடம் கொண்டுவந்தார்கள்; சிறிய காரியங்களையெல்லாம் தாங்களே தீர்த்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","பின்பு மோசே தன்னுடைய மாமனை அனுப்பிவிட்டான்; அவன் திரும்பத் தன்னுடைய தேசத்திற்குப் போய்விட்டான். ");
INSERT INTO tam2017_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","இஸ்ரவேல் மக்கள் எகிப்து தேசத்திலிருந்து புறப்பட்ட மூன்றாம் மாதம் முதலாம் நாளிலே, சீனாய் வனாந்திரத்திற்கு வந்துசேர்ந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","அவர்கள் ரெவிதீமிலிருந்து பயணம் புறப்பட்டு, சீனாய் வனாந்திரத்திற்கு வந்து, அந்த வனாந்திரத்தில் முகாமிட்டார்கள்; இஸ்ரவேலர்கள் அங்கே மலைக்கு எதிராக முகாமிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","மோசே தேவனிடம் ஏறிப்போனான்; யெகோவா மலையிலிருந்து அவனைக்கூப்பிட்டு: “நீ யாக்கோபு வம்சத்தார்களுக்குச் சொல்லவும், இஸ்ரவேல் மக்களுக்கு அறிவிக்கவும் வேண்டியது என்னவென்றால், ");
INSERT INTO tam2017_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","நான் எகிப்தியர்களுக்குச் செய்ததையும், நான் உங்களைக் கழுகுகளுடைய இறக்கைகளின்மேல் சுமந்து, உங்களை என் அருகிலே சேர்த்துக்கொண்டதையும், நீங்கள் கண்டிருக்கிறீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","இப்பொழுது நீங்கள் என்னுடைய வாக்கை உள்ளபடி கேட்டு, என்னுடைய உடன்படிக்கையைக் கைக்கொள்வீர்களானால், எல்லா மக்களையும்விட நீங்களே எனக்கு சிறந்த மக்களாக இருப்பீர்கள்; பூமியெல்லாம் என்னுடையது. ");
INSERT INTO tam2017_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","நீங்கள் எனக்கு ஆசாரிய ராஜ்ஜியமும் பரிசுத்த தேசமுமாக இருப்பீர்கள் என்று நீ இஸ்ரவேல் மக்களோடு சொல்லவேண்டிய வார்த்தைகள்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","மோசே வந்து மக்களின் மூப்பர்களை அழைத்து, யெகோவா தனக்குக் கற்பித்த வார்த்தைகளையெல்லாம் அவர்களுக்கு முன்பாகச் சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","அதற்கு மக்கள் எல்லோரும் ஒன்றாக, “யெகோவா சொன்னவைகளையெல்லாம் செய்வோம் என்று மறுமொழி சொன்னார்கள். மக்கள் சொன்ன வார்த்தைகளை மோசே யெகோவாவிடம் தெரிவித்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","அப்பொழுது யெகோவா மோசேயை நோக்கி: “நான் உன்னோடு பேசும்போது மக்கள் கேட்டு, உன்னை என்றைக்கும் விசுவாசிக்கும்படி, நான் கார்மேகத்தில் உன்னிடம் வருவேன்” என்றார். மக்கள் சொன்ன வார்த்தைகளை மோசே யெகோவாவுக்குச் சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","பின்னும் யெகோவா மோசேயை நோக்கி: “நீ மக்களிடம் போய், இன்றைக்கும் நாளைக்கும் அவர்களைப் பரிசுத்தப்படுத்து; அவர்கள் தங்கள் ஆடைகளைத் துவைத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","மூன்றாம் நாளுக்கு ஆயத்தப்பட்டிருக்கவேண்டும்; மூன்றாம் நாளில் யெகோவா எல்லா மக்களுக்கும் வெளிப்படையாக சீனாய் மலையின்மேல் இறங்குவார். ");
INSERT INTO tam2017_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","மலையைச்சுற்றிலும் நீ ஒரு எல்லையைக் குறித்து, மக்கள் மலையில் ஏறாதபடியும், அதின் அடிவாரத்தைத் தொடாதபடியும் எச்சரிக்கையாக இருங்கள் என்று அவர்களுக்குச் சொல்; மலையைத் தொடுகிறவன் எவனும் நிச்சயமாகவே கொல்லப்படுவான். ");
INSERT INTO tam2017_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","ஒரு கையும் அதைத் தொடலாகாது; தொட்டால், நிச்சயமாகக் கல்லெறியப்பட்டு, அல்லது வில் எய்யப்பட்டுச் சாகவேண்டும்; மிருகமானாலும் சரி, மனிதனானாலும் சரி, உயிரோடு வைக்கப்படலாகாது; எக்காளம் நெடுந்தொனியாகத் தொனிக்கும்போது, அவர்கள் மலையின் அடிவாரத்தில் வரவேண்டும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","மோசே மலையிலிருந்து இறங்கி, மக்களிடம் வந்து, அவர்களைப் பரிசுத்தப்படுத்தினான்; அவர்கள் தங்களுடைய ஆடைகளைத் துவைத்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","அவன் மக்களை நோக்கி: “மூன்றாம் நாளுக்கு ஆயத்தப்பட்டிருங்கள், மனைவியிடம் சேராமல் இருங்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","மூன்றாம் நாள் அதிகாலையில் இடிமுழக்கங்களும் மின்னல்களும், மலையின்மேல் கார்மேகமும் மகா பலத்த எக்காள சத்தமும் உண்டானது; முகாமிலிருந்த மக்கள் எல்லோரும் நடுங்கினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","அப்பொழுது மக்கள் தேவனுக்கு எதிராகபோக, மோசே அவர்களை முகாமிலிருந்து புறப்படச்செய்தான்; அவர்கள் மலையின் அடிவாரத்தில் நின்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","யெகோவா சீனாய்மலையின்மேல் அக்கினியில் இறங்கியதால், அது முழுவதும் புகைக்காடாக இருந்தது; அந்தப் புகை சூளையின் புகையைப்போல எழும்பியது; மலை முழுவதும் மிகவும் அதிர்ந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","எக்காளசத்தம் வரவர மிகவும் பலமாகத் தொனித்தது; மோசே பேசினான்; தேவன் அவனுக்கு வாக்கினால் மறுமொழி கொடுத்தார். ");
INSERT INTO tam2017_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","யெகோவா சீனாய்மலையிலுள்ள உச்சியில் இறங்கினபோது, யெகோவா மோசேயை மலையின் உச்சியில் வரவழைத்தார்; மோசே ஏறிப்போனான். ");
INSERT INTO tam2017_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","அப்பொழுது யெகோவா மோசேயை நோக்கி: “மக்கள் பார்ப்பதற்கு எல்லையைக் கடந்து கர்த்தரிடம் வராதபடியும், அவர்களில் அநேகர் அழிந்துபோகாதபடியும், நீ இறங்கிப்போய், அவர்களை உறுதியாக எச்சரி. ");
INSERT INTO tam2017_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","யெகோவாவின் சமுகத்தில் வருகிற ஆசாரியர்களும், யெகோவா தங்களை அழிக்காதபடி, தங்களைப் பரிசுத்தப்படுத்திக்கொள்ளவேண்டும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","அப்பொழுது மோசே யெகோவாவை நோக்கி: “மலையைச் சுற்றிலும் எல்லையைக் குறித்து, அதைப் பரிசுத்தப்படுத்துங்கள் என்று தேவரீர் எங்களை உறுதியாக எச்சரித்திருக்கிறீர்; ஆகையால், மக்கள் சீனாய்மலையின்மேல் ஏறிவரமாட்டார்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","யெகோவா மோசேயை நோக்கி: “நீ இறங்கிப்போ; பின்பு நீயும் ஆரோனும் கூடி ஏறிவாருங்கள்; ஆசாரியர்களும், மக்களும், யெகோவா தங்களை அழிக்காதபடி, எல்லையைக் கடந்து யெகோவாவிடம் வராமல் இருக்கவேண்டும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","அப்படியே மோசே இறங்கி மக்களிடம் போய், அதை அவர்களுக்குச் சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","தேவன் பேசிச் சொல்லிய எல்லா வார்த்தைகளாவன. ");
INSERT INTO tam2017_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“உன்னை அடிமைத்தன வீடாகிய எகிப்துதேசத்திலிருந்து புறப்படச்செய்த உன்னுடைய தேவனாகிய யெகோவா நானே. ");
INSERT INTO tam2017_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","என்னைத்தவிர உனக்கு வேறே தெய்வங்கள் உண்டாயிருக்கவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","மேலே வானத்திலும், கீழே பூமியிலும், பூமியின் கீழ்த் தண்ணீரிலும் உண்டாயிருக்கிறவைகளுக்கு ஒப்பான ஒரு சிலையையாவது, விக்கிரகத்தையாவது நீ உனக்கு உண்டாக்கவேண்டாம்; ");
INSERT INTO tam2017_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","நீ அவைகளை வணங்கி வழிபடவேண்டாம்; உன்னுடைய தேவனாகிய யெகோவாவாக இருக்கிற நான் எரிச்சலுள்ள தேவனாக இருந்து, என்னைப் பகைக்கிறவர்களைக்குறித்து தகப்பன்மார்களுடைய அக்கிரமத்தைப் பிள்ளைகளிடம் மூன்றாம் நான்காம் தலைமுறைவரை தண்டிக்கிறவராக இருக்கிறேன். ");
INSERT INTO tam2017_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","என்னிடம் அன்புகூர்ந்து, என்னுடைய கற்பனைகளைக் கைக்கொள்ளுகிறவர்களுக்கோ ஆயிரம் தலைமுறைவரை இரக்கம் செய்கிறவராக இருக்கிறேன். ");
INSERT INTO tam2017_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","உன்னுடைய தேவனாகிய யெகோவாடைய நாமத்தை வீணிலே வழங்காமல் இருப்பாயாக; யெகோவா தம்முடைய நாமத்தை வீணிலே வழங்குகிறவனைத் தண்டிக்காமல் விடமாட்டார். ");
INSERT INTO tam2017_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","ஓய்வுநாளைப் பரிசுத்தமாக அனுசரிக்க நினை; ");
INSERT INTO tam2017_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ஆறுநாட்களும் நீ வேலைசெய்து, உன்னுடைய செயல்களையெல்லாம் நடத்து; ");
INSERT INTO tam2017_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ஏழாம்நாளோ உன்னுடைய தேவனாகிய யெகோவாவுடைய ஓய்வுநாள்; அதிலே நீயானாலும், உன்னுடைய மகனானாலும், உன்னுடைய மகளானாலும், உன்னுடைய வேலைக்காரனானாலும், உன்னுடைய வேலைக்காரியானாலும், உன்னுடைய மிருகஜீவனானாலும், உன்னுடைய வாசல்களில் இருக்கிற அந்நியனானாலும், எந்த வேலையும் செய்யவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","யெகோவா ஆறுநாளைக்குள்ளே வானத்தையும் பூமியையும் சமுத்திரத்தையும் அவைகளிலுள்ள எல்லாவற்றையும் உண்டாக்கி, ஏழாம்நாளிலே ஓய்ந்திருந்தார்; ஆகையால், யெகோவா ஓய்வுநாளை ஆசீர்வதித்து, அதைப் பரிசுத்தமாக்கினார். ");
INSERT INTO tam2017_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","உன்னுடைய தேவனாகிய யெகோவா உனக்குக் கொடுக்கிற தேசத்திலே உன்னுடைய நாட்கள் நீடித்திருப்பதற்கு, உன்னுடைய தகப்பனையும் உன்னுடைய தாயையும் மதிப்பாயாக. ");
INSERT INTO tam2017_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","கொலை செய்யாதே. ");
INSERT INTO tam2017_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","விபசாரம் செய்யாதே. ");
INSERT INTO tam2017_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","களவு செய்யாதே. ");
INSERT INTO tam2017_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","பிறனுக்கு விரோதமாகப் பொய்ச்சாட்சி சொல்லாதே. ");
INSERT INTO tam2017_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","பிறனுடைய வீட்டின்மேல் ஆசைப்படாமல் இரு; பிறனுடைய மனைவியையும், அவனுடைய வேலைக்காரனையும், அவனுடைய வேலைக்காரியையும், அவனுடைய எருதையும், அவனுடைய கழுதையையும், பின்னும் பிறனுடைய எதின்மேலும் ஆசைப்படாமல் இரு” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","மக்கள் எல்லோரும் இடிமுழக்கங்களையும் மின்னல்களையும் எக்காளச் சத்தத்தையும் மலை புகைகிறதையும் கண்டார்கள்; அதைக் கண்டு, மக்கள் எல்லோரும் நடு நடுங்கி, தூரத்திலே நின்று, ");
INSERT INTO tam2017_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","மோசேயை நோக்கி: “நீர் எங்களோடு பேசும், நாங்கள் கேட்போம்; தேவன் எங்களோடே பேசாமல் இருக்கட்டும், பேசினால் நாங்கள் செத்துப்போவோம்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","மோசே மக்களை நோக்கி; “பயப்படாமல் இருங்கள்; உங்களைச் சோதிப்பதற்காகவும், நீங்கள் பாவம்செய்யாதபடி அவரைக்குறித்த பயம் உங்களுடைய முகத்திற்கு முன்பாக இருப்பதற்காகவும், தேவன் எழுந்தருளினார்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","மக்கள் தூரத்திலே நின்றார்கள்; மோசே, தேவன் இருந்த கார்மேகத்திற்கு அருகில் சேர்ந்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","அப்பொழுது யெகோவா மோசேயை நோக்கி: “நீ இஸ்ரவேலர்களோடு சொல்லவேண்டியது என்னவென்றால், நான் வானத்திலிருந்து உங்களோடு பேசினேன் என்று கண்டீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","நீங்கள் எனக்கு ஒப்பாக வெள்ளியினாலே தெய்வங்களையும் பொன்னினாலே தெய்வங்களையும் உங்களுக்கு உண்டாக்க வேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","மண்ணினாலே பலிபீடத்தை எனக்கு உண்டாக்கி, அதின்மேல் உன்னுடைய ஆடுகளையும் உன்னுடைய மாடுகளையும் சர்வாங்க தகனபலியாகவும் சமாதானபலியாகவும் செலுத்து; நான் என்னுடைய நாமத்தை மகிமைப்படுத்தும் எந்த இடத்திலும் உன்னிடம் வந்து, உன்னை ஆசீர்வதிப்பேன். ");
INSERT INTO tam2017_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","எனக்குக் கல்லினால் பலிபீடத்தை உண்டாக்கவேண்டுமானால், அதை வெட்டின கற்களால் கட்டவேண்டாம்; அதின்மேல் உளி பதித்தவுடன், அதை அசுத்தப்படுத்துவாய். ");
INSERT INTO tam2017_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","என்னுடைய பலிபீடத்தின்மேல் உன்னுடைய நிர்வாணம் காணப்படாதபடி, படிகளால் அதின்மேல் ஏறவும் வேண்டாம்”. ");
INSERT INTO tam2017_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","மேலும், நீ அவர்களுக்கு அறிவிக்கவேண்டிய கட்டளைகள்: ");
INSERT INTO tam2017_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“எபிரெயர்களில் ஒரு அடிமையை வாங்கினால், அவன் ஆறுவருடங்கள் வேலைசெய்து, ஏழாம் வருடத்திலே ஒன்றும் தராமல் விடுதலைப்பெற்றுப் போகவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","தனியாக வந்திருந்தால், தனியாகப்போகவேண்டும்; திருமணம் செய்தவனாக வந்திருந்தால், அவன் மனைவி அவனுடன் போகவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","அவனுடைய எஜமான் அவனுக்கு ஒரு பெண்ணை திருமணம்செய்துகொடுத்தும், அவள் அவனுக்கு ஆண்பிள்ளைகளையோ பெண்பிள்ளைகளையோ பெற்றும் இருந்தால், அந்தப் பெண்ணும் அவளுடைய பிள்ளைகளும் அவளுடைய எஜமானைச் சேரவேண்டும்; அவன் மட்டும் தனியாகப் போகவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","அந்த வேலைக்காரன்: என்னுடைய எஜமானையும் என்னுடைய மனைவியையும் என்னுடைய பிள்ளைகளையும் நேசிக்கிறேன்; நான் விடுதலை பெற்றுப்போக மனதில்லை என்று மனப்பூர்வமாகச் சொன்னால், ");
INSERT INTO tam2017_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","அவனுடைய எஜமான் அவனை நியாயாதிபதிகளிடம் அழைத்துக்கொண்டுபோய், அவனைக் கதவின் அருகிலாவது கதவுநிலையின் அருகிலாவது சேரச்செய்து, அங்கே அவனுடைய எஜமான் அவனுடைய காதைக் கம்பியினால் குத்தவேண்டும்; பின்பு அவன் என்றைக்கும் அவனிடம் வேலைசெய்துகொண்டிருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“ஒருவன் தன்னுடைய மகளை வேலைக்காரியாக விற்றுப்போட்டால், வேலைக்காரன் விடுதலைபெற்றுப் போவதுபோல அவள் போகக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","அவளைத் தனக்கு நியமித்துக்கொண்ட எஜமானின் பார்வைக்கு அவள் தகாதவளாகப் போனால், அவள் மீட்கப்படலாம்; அவன் அவளுக்குத் துரோகம்செய்து, அவளை அந்நியர்கள் கையில் விற்க அவனுக்கு அதிகாரம் இல்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","அவன் தன்னுடைய மகனுக்கு அவளை மனைவியாக நியமித்திருந்தால், தன்னுடைய மகள்களை நடத்துவதுபோல அவளையும் நடத்தவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","அவன் வேறொரு பெண்ணைத் தனக்கென்று நியமித்தால், இவளுக்குரிய உணவு, உடை, திருமண உரிமை ஆகிய இவைகளில் குறைவுசெய்யாமல் இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","இம்மூன்றும் அவன் அவளுக்குச் செய்யாமற்போனால், அவள் பணம் தராமல் விடுதலைபெற்றுப் போகவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“ஒரு மனிதனைச் சாகும்படி அடித்தவன், நிச்சயமாகக் கொலைசெய்யப்பட வேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","ஒருவன் மறைந்திருந்து கொல்லாமல், தேவசெயலாகத் தன்னுடைய கைக்கு நேரிட்டவனைக் கொன்றால், அவன் ஓடிப்போய்ச் சேரவேண்டிய இடத்தை உனக்கு நியமிப்பேன். ");
INSERT INTO tam2017_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","ஒருவன் பிறனுக்கு விரோதமாக சதிமோசம்செய்து, அவனைத் துணிகரமாகக் கொன்றுபோட்டால், அவனை என்னுடைய பலிபீடத்திலிருந்தும் பிடித்துக்கொண்டுபோய்க் கொலைசெய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“தன்னுடைய தகப்பனையாவது தன்னுடைய தாயையாவது அடிக்கிறவன் நிச்சயமாகக் கொலைசெய்யப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“ஒருவன் ஒரு மனிதனைத் திருடி விற்றுப்போட்டாலும், இவன் அவனிடம் கண்டுபிடிக்கப்பட்டாலும், அவன் நிச்சயமாகக் கொலைசெய்யப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“தன்னுடைய தகப்பனையோ தன்னுடைய தாயையோ சபிக்கிறவன் நிச்சயமாகக் கொலைசெய்யப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“மனிதர்கள் சண்டையிட்டு, ஒருவன் மற்றொருவனைக் கல்லால் எறிந்ததாலோ கையால் அடித்ததினாலோ அவன் சாகாமல் படுக்கையில் கிடந்து, ");
INSERT INTO tam2017_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","திரும்ப எழுந்து வெளியிலே தன்னுடைய ஊன்றுகோலைப் பிடித்துக்கொண்டு நடமாடினால், அடித்தவன் தண்டனைக்கு விலகியிருப்பான்; ஆனாலும் அவனுக்கு நஷ்டஈடு கொடுத்து, அவனை நன்றாகக் குணமாக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“ஒருவன் தனக்கு அடிமையானவனையோ தனக்கு அடிமையானவளையோ, கோலால் அடித்ததாலே, அவனுடைய கையால் இறந்துபோனால், பழிக்குப்பழி வாங்கப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","ஒரு நாளாவது இரண்டு நாட்களாவது உயிரோடு இருந்தால், அவர்கள் அவனுக்கு உரியவனாக இருப்பதால், பழிவாங்கவேண்டியதில்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“மனிதர்கள் சண்டையிட்டு, கர்ப்பவதியான ஒரு பெண்ணை அடித்ததால், அவளுக்கு வேறு சேதமில்லாமல் கர்ப்பம் கலைந்துபோனால், அடிபட்ட பெண்ணின் கணவன் அடித்தவன்மேல் சுமத்துகிறதற்குத்தகுந்தபடியும் நியாயாதிபதிகள் செய்யும் தீர்ப்பின்படியும் அபராதம் கொடுக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","வேறே சேதமுண்டானால், ஜீவனுக்கு ஜீவன், ");
INSERT INTO tam2017_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","கண்ணுக்குக் கண், பல்லுக்குப் பல், கைக்குக் கை, காலுக்குக் கால், ");
INSERT INTO tam2017_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","சூட்டுக்குச் சூடு, காயத்திற்குக் காயம், தழும்புக்குத் தழும்பு கொடுக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“ஒருவன் தன்னுடைய அடிமையின் கண்ணையோ தன்னுடைய அடிமைப்பெண்ணின் கண்ணையோ அடித்து அதைக் கெடுத்தால், அவனுடைய கண்ணுக்குப் பதிலாக அவனை விடுதலை செய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","அவன் தன்னுடைய அடிமையின் பல்லையோ தன்னுடைய அடிமைப்பெண்ணின் பல்லையோ விழும்படி அடித்தால், அவனுடைய பல்லுக்குப் பதிலாக அவனை விடுதலை செய்துவிடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“ஒரு மாடு ஒரு ஆணையோ ஒரு பெண்ணையோ முட்டியதால் சாவு உண்டானால், அந்த மாடு கல்லெறியப்படவேண்டும், அதின் இறைச்சி சாப்பிடப்படக்கூடாது; அப்பொழுது மாட்டின் எஜமான் தண்டனைக்கு விலகியிருப்பான். ");
INSERT INTO tam2017_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","தன்னுடைய மாடு வழக்கமாக முட்டுகிற மாடாக இருந்து, அது அதின் எஜமானுக்கு அறிவிக்கப்பட்டும், அவன் அதைக் கட்டிவைக்காததால், அது ஒரு ஆணையோ ஒரு பெண்ணையோ கொன்று போட்டால், மாடும் கல்லெறியப்படவேண்டும், அதின் எஜமானும் கொலை செய்யப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","அபராதம் கொடுக்கும்படி தீர்க்கப்பட்டதால், அவன் தன்னுடைய உயிரை மீட்கும் பொருளாக விதிக்கப்பட்ட அபராதத்தைக் கொடுக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","அது ஒருவனுடைய மகனை முட்டினாலும் சரி, ஒருவனுடைய மகளை முட்டினாலும் சரி, இந்தத் தீர்ப்பின்படியே அவனுக்குச் செய்யப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","அந்த மாடு ஒரு அடிமையையோ ஒரு அடிமைப்பெண்ணையோ முட்டினால், அதற்கு உடையவன் அவர்களுடைய எஜமானுக்கு முப்பது சேக்கல் நிறையான வெள்ளியைக் கொடுக்கவேண்டும்; மாடு கல்லெறியப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“ஒருவன் ஒரு குழியைத் திறந்து வைத்ததாலோ, ஒரு குழியை வெட்டி அதை மூடாமல் போனதாலோ, அதிலே ஒரு மாடோ ஒரு கழுதையோ விழுந்தால், ");
INSERT INTO tam2017_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","குழிக்கு உரியவன் அதற்கு ஈடாகப் பணத்தை மிருகத்தினுடைய எஜமானுக்குக் கொடுக்கவேண்டும்; செத்ததோ அவனுடையதாகவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“ஒருவனுடைய மாடு மற்றவனுடைய மாட்டை முட்டியதால் அது செத்தால், உயிரோடு இருக்கிற மாட்டை அவர்கள் விற்று, அதின் தொகையைப் பங்கிட்டு, செத்ததையும் பங்கிட்டுக்கொள்ளவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","அந்த மாடு முன்பே முட்டுகிற மாடென்று அதின் எஜமான் அறிந்தும், அதைக் கட்டிவைக்காமல் இருந்தால், அவன் மாட்டுக்கு மாட்டைக் கொடுக்கவேண்டும்; செத்ததோ அவனுடையதாக வேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“ஒருவன் ஒரு மாட்டையோ ஒரு ஆட்டையோ திருடி, அதைக் கொன்றால், அல்லது அதை விற்றால், அவன் அந்த மாட்டுக்கு ஐந்து மாடுகளையும், அந்த ஆட்டுக்கு நான்கு ஆடுகளையும் பதிலாகக் கொடுக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","திருடன் திருடும்போது கண்டுபிடிக்கப்பட்டு, அடிக்கப்பட்டுச் செத்தால், அவனுடைய இரத்தப்பழி அடித்தவனைச் சேராது. ");
INSERT INTO tam2017_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","சூரியன் அவன்மேல் உதித்தபின்பு, அவனுடைய இரத்தப்பழி சுமரும்; திருடன் பதில் கொடுத்துத் தீர்க்கவேண்டும்; அவனுடைய கையில் ஒன்றும் இல்லாமல் இருந்தால், தான் செய்த திருட்டுக்காக விற்கப்படுவான். ");
INSERT INTO tam2017_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","அவன் திருடின மாடோ, கழுதையோ, ஆடோ உயிருடன் அவன் கையில் கண்டுபிடிக்கப்பட்டால், இருமடங்காக அவன் கொடுக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“ஒருவன் மற்றவனுடைய வயலிலோ திராட்சைத்தோட்டத்திலோ தன்னுடைய மிருகஜீவனை மேயவிட்டால், அவன் தன்னுடைய சொந்தவயலிலும் திராட்சைத்தோட்டத்திலும் உள்ள பலனில் சிறந்ததை எடுத்து, பதிலுக்குக் கொடுக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","அக்கினி எழும்பி, முட்களில் பற்றி, தானியப்போரையோ, விளைந்த பயிரையோ, வயலிலுள்ள வேறு எதையாவது எரித்துப்போட்டால், அக்கினியைக் கொளுத்தினவன் அக்கினிச் சேதத்திற்கு ஈடு செய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","ஒருவன் பிறனிடம் பணத்தையோ, பொருட்களையோ பாதுகாப்பிற்காக வைத்திருக்கும்போது, அது அவனுடைய வீட்டிலிருந்து திருட்டுப்போனால், திருடன் அகப்பட்டால், அவன் அதற்கு இருமடங்காக கொடுக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","திருடன் அகப்படாவிட்டால், அந்த வீட்டுக்காரன் தான் பிறனுடைய பொருளை அபகரித்தானோ இல்லையோ என்று அறியும்படி நியாயாதிபதிகளிடம் அவனைக் கொண்டுபோகவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","காணாமல்போன மாடு, கழுதை, ஆடு, உடை முதலியவைகளில் ஏதாவது ஒன்றை வேறொருவன் தன்னுடையது என்று சொல்லி குற்றம்சொன்னால், இரண்டு பேர்களுடைய வழக்கும் நியாயாதிபதிகளிடம் வரவேண்டும்; நியாயாதிபதிகள் எவனைக் குற்றவாளி என்று தீர்க்கிறார்களோ, அவன் மற்றவனுக்கு இருமடங்கு கொடுக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","ஒருவன் தன்னுடைய கழுதையையோ மாட்டையோ ஆட்டையோ மற்ற ஏதாவதொரு மிருகஜீவனையோ ஒருவனிடம் விட்டிருக்கும்போது, அது செத்தாலும், காயப்பட்டாலும், ஒருவரும் காணாதபடி ஓட்டிக்கொண்டு போகப்பட்டாலும், ");
INSERT INTO tam2017_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","அவன் தான் பிறனுடைய பொருளை அபகரிக்கவில்லையென்று யெகோவாவின் நாமத்தில் ஆணையிட்டால் அவர்கள் இருவருக்கும் அதுவே நியாயம்தீர்க்கட்டும்; உடையவன் அதை அங்கீகரிக்கவேண்டும்; மற்றவன் பதிலளிக்கத்தேவையில்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","அது அவனிடமிருந்து திருடப்பட்டுப்போனால், அவன் அதனுடைய எஜமானுக்கு அதற்காக ஈடுகொடுக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","அது வேட்டையாடப்பட்டுப்போனால், அதற்கு சாட்சியை ஒப்புவிக்கவேண்டும். வேட்டையாடப்பட்டதற்காக அவன் ஈடுகொடுக்கத் தேவையில்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","ஒருவன் பிறனிடம் எதையாவது இரவலாக வாங்கியிருந்தால், அதற்குரியவன் கூட இல்லாதபோது, அது காயப்பட்டாலும், செத்துப்போனாலும், அவன் அதற்கு ஈடுசெய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","அதற்குரியவன் கூட இருந்தால், அவன் ஈடுகொடுக்கத் தேவையில்லை; அது வாடகைக்கு வாங்கப்பட்டிருந்தால், அது அவனுடைய வாடகைக்கு வந்த சேதம். ");
INSERT INTO tam2017_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","திருமணத்திற்கு நியமிக்கப்படாத ஒரு கன்னிகையை ஒருவன் மோசம்போக்கி அவளோடு உறவுகொண்டால், அவன் அவளுக்காகப் பரிசம்கொடுத்து, அவளைத் திருமணம்செய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","அவளுடைய தகப்பன் அவளை அவனுக்குக் கொடுக்கமாட்டேன் என்று சொன்னால், கன்னிகைகளுக்காகக் கொடுக்கப்படும் பரிசமுறையின்படி அவன் பணத்தை நிறுத்துக் கொடுக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","சூனியக்காரியை உயிரோடு வைக்கவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","மிருகத்தோடு உறவுவைக்கிற எவனும் கொல்லப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","யெகோவா ஒருவரைத்தவிர வேறு தெய்வங்களுக்குப் பலியிடுகிறவன் அழிக்கப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","அந்நியனைச் சிறுமைப்படுத்தாமலும் ஒடுக்காமலும் இருப்பீர்களாக; நீங்களும் எகிப்து தேசத்தில் அந்நியர்களாக இருந்தீர்களே. ");
INSERT INTO tam2017_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","விதவையையும் திக்கற்ற பிள்ளையையும் ஒடுக்காமல் இருப்பீர்களாக; ");
INSERT INTO tam2017_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","அவர்களை அதிகமாக ஒடுக்கும்போது, அவர்கள் என்னை நோக்கி முறையிட்டால், அவர்கள் முறையிடுதலை நான் நிச்சயமாகக் கேட்டு, ");
INSERT INTO tam2017_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","கோபமடைந்து, உங்களைப் பட்டயத்தால் கொலைசெய்வேன்; உங்களுடைய மனைவிகள் விதவைகளும், உங்களுடைய பிள்ளைகள் திக்கற்றப் பிள்ளைகளுமாவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","உங்களுக்குள் ஏழையாக இருக்கிற என்னுடைய மக்களில் ஒருவனுக்கு நீங்கள் பணம் கடனாகக் கொடுத்திருந்தால், வட்டிவாங்குகிறவர்கள்போல அவனிடம் வட்டி வாங்கவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","பிறனுடைய ஆடையை பதிலாக வாங்கினால், பொழுதுமறையும் முன்பே அதை அவனுக்குத் திரும்பக் கொடுத்துவிடுவாயாக. ");
INSERT INTO tam2017_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","அவன் ஆடை அதுதானே, அதுவே அவன் தன்னுடைய உடலை மூடிக்கொள்ளுகிற துணி; வேறு எதினாலே போர்த்திப் படுத்துக்கொள்ளுவான்? அவன் என்னை நோக்கி முறையிடும்போது, நான் அவனுடைய வார்த்தையைக் கேட்பேன், நான் இரக்கமுள்ளவராக இருக்கிறேன். ");
INSERT INTO tam2017_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","தேவனை நிந்திக்காமலும், உன்னுடைய மக்களை ஆளுகிறவர்களைச் சபிக்காமலும் இரு. ");
INSERT INTO tam2017_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","முதல் முதல் பழுக்கும் உன்னுடைய பழத்தையும், வடியும் உன்னுடைய ஆலையின் இரசத்தையும் காணிக்கையாகச் செலுத்தத் தாமதிக்கவேண்டாம். உன்னுடைய மகன்களில் முதலில் பிறந்தவனை எனக்குக் கொடுப்பாயாக. ");
INSERT INTO tam2017_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","உன்னுடைய மாடுகளிலும் உன்னுடைய ஆடுகளிலும் அப்படியே செய்வாயாக; குட்டியானது ஏழுநாட்கள் தன்னுடைய தாயோடு இருக்கட்டும்; எட்டாம் நாளிலே அதை எனக்குச் செலுத்துவாயாக. ");
INSERT INTO tam2017_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","நீங்கள் எனக்குப் பரிசுத்த மனிதர்களாக இருக்கவேண்டும்; வெளியிலே பீறுண்ட இறைச்சியைச் சாப்பிடாமல், அதை நாய்களுக்குப் போட்டுவிடுங்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“அபாண்டமான சொல்லை ஏற்றுக்கொள்ளாதே; கொடுமையுள்ள சாட்சிக்காரனாக இருக்க ஆகாதவனோடு சேராதே. ");
INSERT INTO tam2017_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","தீமைசெய்ய அநேகம்பேர்களின் வழியைப் பின்பற்றாதே; வழக்கிலே நியாயத்தைப் புரட்ட கூட்டத்தின் பக்கம் சாய்ந்து, தீர்ப்பு சொல்லாதே. ");
INSERT INTO tam2017_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","வழக்கிலே தரித்திரனுடைய முகத்தைப் பார்க்காதே. ");
INSERT INTO tam2017_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","உன்னுடைய எதிரியின் மாடோ அவனுடைய கழுதையோ தப்பிப்போவதைப் பார்த்தால், அதைத் திரும்ப அவனிடம் கொண்டுபோய் விடு. ");
INSERT INTO tam2017_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","உன்னைப் பகைக்கிறவனுடைய கழுதை சுமையோடு விழுந்திருப்பதைப் பார்த்தால், அதற்கு உதவிசெய்யாமல் இருக்கலாமா? அவசியமாக அவனுடன்கூட அதற்கு உதவிசெய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","உன்னிடத்தில் இருக்கிற எளியவனுடைய வழக்கிலே அவனுடைய நியாயத்தைப் புரட்டாதே. ");
INSERT INTO tam2017_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","தவறான காரியத்தை விட்டுவிலகு; குற்றமில்லாதவனையும் நீதிமானையும் கொலைசெய்யாதே; நான் துன்மார்க்கனை நீதிமான் என்று தீர்க்கமாட்டேன். ");
INSERT INTO tam2017_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","லஞ்சம் வாங்காதே; லஞ்சம் பார்வையுள்ளவர்களைக் குருடாக்கி, நீதிமான்களின் வார்த்தைகளைப் புரட்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","அந்நியனை ஒடுக்காதே; எகிப்துதேசத்தில் அந்நியர்களாக இருந்த நீங்கள் அந்நியனுடைய இருதயத்தை அறிந்திருக்கிறீர்களே. ");
INSERT INTO tam2017_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","ஆறுவருடங்கள் நீ உன்னுடைய நிலத்தில் பயிரிட்டு, அதின் பலனைச் சேர்த்துக்கொள். ");
INSERT INTO tam2017_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ஏழாம் வருடத்தில் உன்னுடைய மக்களிலுள்ள எளியவர்கள் சாப்பிடவும், மீதியானதை வெளியின் மிருகங்கள் சாப்பிடவும், அந்த நிலம் சும்மாகிடக்க விட்டுவிடு; உன்னுடைய திராட்சைத்தோட்டத்தையும் உன்னுடைய ஒலிவத்தோப்பையும் அப்படியே செய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","ஆறுநாட்கள் உன்னுடைய வேலையைச் செய்து, ஏழாம்நாளிலே உன்னுடைய மாடும் உன்னுடைய கழுதையும் இளைப்பாறவும், உன்னுடைய அடிமைப்பெண்ணின் பிள்ளையும் அந்நியனும் இளைப்பாறவும் ஓய்ந்திரு. ");
INSERT INTO tam2017_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","நான் உங்களுக்குச் சொன்னவைகள் எல்லாவற்றிலும் கவனமாக இருங்கள். அந்நிய தெய்வங்களின் பேரைச் சொல்லவேண்டாம்; அது உன்னுடைய வாயிலிருந்து பிறக்கக் கேட்கப்படவும் வேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","வருடத்தில் மூன்றுமுறை எனக்குப் பண்டிகை அனுசரி. ");
INSERT INTO tam2017_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","புளிப்பில்லா அப்பப்பண்டிகையைக் கொண்டாடி, நான் உனக்குக் கட்டளையிட்டபடி ஆபீப் மாதத்தின் குறித்தகாலத்தில் ஏழுநாட்கள் புளிப்பில்லா அப்பம் சாப்பிடவேண்டும்; அந்த மாதத்தில் எகிப்திலிருந்து புறப்பட்டாயே, என்னுடைய சந்நிதியில் வெறுங்கையுடன் வரவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","நீ வயலில் விதைத்த உன்னுடைய பயிர் வேலைகளின் முதற்பலனைச் செலுத்துகிற அறுப்புக்கால பண்டிகையையும், வருடமுடிவிலே நீ வயலில் உன்னுடைய வேலைகளின் பலனைச் சேர்த்து முடிந்தபோது, சேர்ப்புக்கால பண்டிகையையும் அனுசரி. ");
INSERT INTO tam2017_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","வருடத்தில் மூன்றுமுறை உன்னுடைய ஆண்மக்கள் எல்லோரும் யெகோவாவாகிய ஆண்டவருடைய சந்நிதியில் வரட்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","எனக்கு பலியிடும் இரத்தத்தைப் புளித்தமாவுடன் செலுத்தவேண்டாம், எனக்கு பலியிடும் கொழுப்பை அதிகாலைவரைக்கும் வைக்கவும் வேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","உன்னுடைய நிலத்தில் முதல் விளைச்சல்களின் முதல் கனியை உன்னுடைய தேவனாகிய யெகோவாவுடைய ஆலயத்திற்குக் கொண்டுவரவேண்டும்; வெள்ளாட்டுக்குட்டியை அதனுடைய தாயின் பாலோடு சமைக்கவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","வழியில் உன்னைக் காக்கிறதற்கும், நான் ஆயத்தம்செய்த இடத்திற்கு உன்னைக் கொண்டுபோய்ச் சேர்க்கிறதற்கும், இதோ, நான் ஒரு தூதனை உனக்கு முன்னே அனுப்புகிறேன். ");
INSERT INTO tam2017_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","அவருடைய சமுகத்தில் எச்சரிக்கையாக இருந்து, அவர் வாக்குக்குச் செவிகொடு; அவரைக் கோபப்படுத்தாதே; உங்களுடைய துரோகங்களை அவர் பொறுப்பதில்லை; என்னுடைய பெயர் அவருடைய உள்ளத்தில் இருக்கிறது. ");
INSERT INTO tam2017_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","நீ அவருடைய வாக்கை நன்றாகக் கேட்டு, நான் சொல்வதையெல்லாம் செய்தால், நான் உன்னுடைய எதிரிகளுக்கு எதிரியாகவும், உன்னுடைய விரோதிகளுக்கு விரோதியாகவும் இருப்பேன். ");
INSERT INTO tam2017_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","என்னுடைய தூதனானவர் உனக்கு முன்னேசென்று, எமோரியர்களும், ஏத்தியர்களும், பெரிசியர்களும், கானானியர்களும், ஏவியர்களும், எபூசியர்களும், இருக்கிற இடத்திற்கு உன்னை நடத்திக்கொண்டுபோவார்; அவர்களை நான் அழித்துப்போடுவேன். ");
INSERT INTO tam2017_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","நீ அவர்களுடைய தெய்வங்களைப் பணிந்துகொள்ளாமலும், தொழுதுகொள்ளாமலும், அவர்களுடைய செயல்களின்படி செய்யாமலும், அவர்களை முழுவதும் அழித்து, அவர்களுடைய சிலைகளை உடைத்துப்போடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","உங்களுடைய தேவனாகிய யெகோவாவையே ஆராதிக்கவேண்டும்; அவர் உன்னுடைய அப்பத்தையும் உன்னுடைய தண்ணீரையும் ஆசீர்வதிப்பார். வியாதியை உன்னிலிருந்து விலக்குவேன். ");
INSERT INTO tam2017_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","கர்ப்பம் களைகிறதும், மலடும் உன்னுடைய தேசத்தில் இருப்பதில்லை; உன்னுடைய ஆயுசு நாட்களை பூரணப்படுத்துவேன். ");
INSERT INTO tam2017_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","எனக்குப் பயப்படும் பயத்தை உனக்குமுன்பு செல்லும்படிச் செய்வேன். நீ செல்லும் இடமெங்கும் உள்ள மக்கள் எல்லோரையும் கொன்று, உன்னுடைய எதிரிகள் எல்லோரையும் முதுகு காட்டச்செய்வேன். ");
INSERT INTO tam2017_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","உன்னுடைய முகத்திற்கு முன்பாக ஏவியர்களையும், கானானியர்களையும், ஏத்தியர்களையும் துரத்திவிட குளவிகளை உனக்கு முன்னே அனுப்புவேன். ");
INSERT INTO tam2017_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","தேசம் பாழாகப்போகாமலும், காட்டுமிருகங்கள் உனக்கு விரோதமாகப் பெருகாமலும் இருக்கும்படி, நான் அவர்களை ஓராண்டிற்குள்ளே உனக்கு முன்பாக துரத்திவிடாமல், ");
INSERT INTO tam2017_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","நீ விருத்தியடைந்து, தேசத்தைச் சுதந்தரித்துக்கொள்ளும்வரைக்கும், அவர்களைக் கொஞ்சம் கொஞ்சமாக உனக்கு முன்பாக துரத்திவிடுவேன். ");
INSERT INTO tam2017_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","செங்கடல் துவங்கி பெலிஸ்தர்களின் மத்திய தரைக்கடல்வரைக்கும், வனாந்திரம் துவங்கி நதிவரைக்கும் உன்னுடைய எல்லையாக இருக்கும்படிச் செய்வேன்; நான் அந்த தேசத்தின் குடிகளை உங்களுடைய கையில் ஒப்புக்கொடுப்பேன்; நீ அவர்களை உனக்கு முன்பாக துரத்திவிடுவாய். ");
INSERT INTO tam2017_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","அவர்களோடும் அவர்களுடைய தெய்வங்களோடும் நீ உடன்படிக்கை செய்யாதே. ");
INSERT INTO tam2017_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","உன்னை எனக்கு விரோதமாகப் பாவம் செய்யவைக்காதபடி உன்னுடைய தேசத்திலே அவர்கள் குடியிருக்கவேண்டாம்; நீ அவர்களுடைய தெய்வங்களைத் தொழுதுகொண்டால், அது உனக்குக் கண்ணியாக இருக்கும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","பின்பு அவர் மோசேயை நோக்கி: “நீயும் ஆரோனும், நாதாபும் அபியூவும் இஸ்ரவேலின் மூப்பர்களில் எழுபதுபேர்களும் கர்த்தரிடம் ஏறிவந்து, தூரத்திலிருந்து தொழுதுகொள்ளுங்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","மோசே மட்டும் யெகோவாவுக்கு அருகில் வரலாம்; மற்றவர்கள் அருகில் வரக்கூடாது; மக்கள் அவனுடன் ஏறிவரவேண்டாம்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","மோசே வந்து, யெகோவாவுடைய வார்த்தைகள் யாவையும் நீதி சட்டங்கள் யாவையும் மக்களுக்கு அறிவித்தான்; “அப்பொழுது மக்கள் எல்லோரும் ஒரேசத்தமாக: யெகோவா அருளின எல்லா வார்த்தைகளின்படியும் செய்வோம்” என்று மறுமொழி சொன்னார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","மோசே யெகோவாவுடைய வார்த்தைகளையெல்லாம் எழுதிவைத்து, அதிகாலையில் எழுந்து, மலையின் அடியில் ஒரு பலிபீடத்தைக் கட்டி, இஸ்ரவேலுடைய பன்னிரண்டு கோத்திரங்களுடைய எண்ணிக்கையின்படி பன்னிரண்டு தூண்களை நிறுத்தினான். ");
INSERT INTO tam2017_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","இஸ்ரவேலின் வாலிபர்களை அனுப்பினான்; அவர்கள் சர்வாங்கதகனபலிகளைச் செலுத்தி, யெகோவாவுக்குச் சமாதானபலிகளாகக் காளைகளைப் பலியிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","அப்பொழுது மோசே அந்த இரத்தத்தில் பாதி எடுத்து, கிண்ணங்களில் ஊற்றி, பாதி இரத்தத்தைப் பலிபீடத்தின்மேல் தெளித்து, ");
INSERT INTO tam2017_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","உடன்படிக்கையின் புத்தகத்தை எடுத்து, மக்களின் காதுகளில் கேட்க வாசித்தான்; அவர்கள் யெகோவா சொன்னபடியெல்லாம் செய்து, கீழ்ப்படிந்து நடப்போம்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","அப்பொழுது மோசே இரத்தத்தை எடுத்து, மக்களின்மேல் தெளித்து, இந்த வார்த்தைகள் எல்லாவற்றையும்குறித்து யெகோவா உங்களோடு செய்த உடன்படிக்கையின் இரத்தம் இதுவே” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","பின்பு மோசேயும், ஆரோனும், நாதாபும் அபியூவும், இஸ்ரவேலுடைய மூப்பர்கள் எழுபதுபேர்களும் மலைக்கு ஏறிப்போய், ");
INSERT INTO tam2017_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","இஸ்ரவேலின் தேவனைத் தரிசித்தார்கள். அவருடைய பாதத்தின்கீழுள்ள இடமானது இழைத்த வேலைப்பாடு மிகுந்த நீலக்கல்லைப்போல தெளிந்த வானத்தின் சுடரொளிக்கு ஒப்பாகவும் இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","அவர் இஸ்ரவேலர்களுடைய தலைவர்கள்மேல் தம்முடைய கையை நீட்டவில்லை; அவர்கள் தேவனைத் தரிசித்து, பின்பு சாப்பிட்டுக் குடித்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","அப்பொழுது யெகோவா மோசேயை நோக்கி: “நீ மலையின்மேல் என்னிடத்திற்கு ஏறிவந்து, அங்கே இரு. நான் உனக்குக் கற்பலகைகளையும், நீ அவர்களுக்கு கற்றுக்கொடுப்பதற்கு, நான் எழுதின நியாயப்பிரமாணத்தையும் கற்பனைகளையும் கொடுப்பேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","அப்பொழுது மோசே தன்னுடைய ஊழியக்காரனாகிய யோசுவாவோடு எழுந்து போனான். மோசே தேவனுடைய மலையில் ஏறிப்போகும்போது, ");
INSERT INTO tam2017_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","அவன் மூப்பர்களை நோக்கி: “நாங்கள் உங்களிடம் திரும்பிவரும்வரை, நீங்கள் இங்கே எங்களுக்காகக் காத்திருங்கள்; ஆரோனும், ஊரும் உங்களிடம் இருக்கிறார்கள்; ஒருவனுக்கு ஏதாவது பிரச்சனை உண்டானால், அவன் அவர்களிடத்தில் போகலாம்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","மோசே மலையின்மேல் ஏறினபோது, ஒரு மேகம் மலையை மூடியது. ");
INSERT INTO tam2017_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","யெகோவாவுடைய மகிமை சீனாய்மலையின்மேல் தங்கியிருந்தது; மேகம் ஆறுநாட்கள் அதை மூடியிருந்தது; ஏழாம்நாளில் அவர் மேகத்தின் நடுவிலிருந்து மோசேயைக் கூப்பிட்டார். ");
INSERT INTO tam2017_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","மலையின் உச்சியிலே யெகோவாவுடைய மகிமையின் காட்சி இஸ்ரவேலர்களுடைய கண்களுக்கு சுட்டெரிக்கிற அக்கினியைப்போல் இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","மோசே மேகத்தின் நடுவிலே நுழைந்து, மலையின்மேல் ஏறி, இரவும் பகலும் நாற்பதுநாட்கள் மலையில் இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“இஸ்ரவேலர்கள் எனக்குக் காணிக்கையைக் கொண்டுவரும்படி அவர்களுக்குச் சொல்லு; மனப்பூர்வமாக உற்சாகத்துடன் கொடுப்பவன் எவனோ அவனிடம் எனக்குக் காணிக்கையை வாங்கிக்கொள். ");
INSERT INTO tam2017_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","நீங்கள் அவர்களிடம் வாங்க வேண்டிய காணிக்கைகள், பொன்னும், வெள்ளியும், வெண்கலமும், ");
INSERT INTO tam2017_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","இளநீலநூலும், இரத்தாம்பரநூலும், சிவப்பு நூலும், மெல்லிய பஞ்சு நூலும், வெள்ளாட்டு முடியும், ");
INSERT INTO tam2017_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","சிவப்பு வண்ணம் தீட்டப்பட்ட ஆட்டுக்கடாத்தோலும், மெல்லிய தோலும், சீத்திம் மரமும், ");
INSERT INTO tam2017_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","விளக்கெண்ணெயும், அபிஷேகத் தைலத்திற்குப் பரிமளத்தைலமும், தூபத்திற்கு நறுமண வாசனைப் பொருட்களும், ");
INSERT INTO tam2017_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ஏபோத்திலும் மார்ப்பதக்கத்திலும் பதிக்கும் கோமேதகக் கற்களும் இரத்தினங்களுமே. ");
INSERT INTO tam2017_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","அவர்கள் நடுவிலே நான் தங்கியிருக்க, எனக்கு ஒரு பரிசுத்த ஸ்தலத்தை உண்டாக்குங்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","நான் உனக்குக் காண்பிக்கும் ஆசரிப்புக்கூடாரத்தின் மாதிரியின்படியும், அதனுடைய எல்லாப்பொருட்களின் மாதிரியின்படியும் அதைச் செய்யுங்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“சீத்திம் மரத்தால் ஒரு பெட்டியைச் செய்யுங்கள்; அதின் நீளம் இரண்டரை முழமும், அதின் அகலம் ஒன்றரை முழமும், அதின் உயரம் ஒன்றரை முழமுமாக இருக்கட்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","அதை எங்கும் சுத்தப்பொன் தகட்டால் மூடு; நீ அதனுடைய உட்புறத்தையும் வெளிப்புறத்தையும் அதனால் மூடி, அதின்மேல் சுற்றிலும் பொன்னினால் விளிம்பு உண்டாக்கி, ");
INSERT INTO tam2017_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","அதற்கு நான்கு பொன் வளையங்களைச் செய்து, அவைகளை அதின் நான்கு மூலைகளிலும் போட்டு, ஒரு பக்கத்தில் இரண்டு வளையங்களும், மறுபக்கத்தில் இரண்டு வளையங்களும் இருக்கும்படித் தைத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","சீத்திம் மரத்தால் தண்டுகளைச் செய்து, அவைகளைப் பொன்தகட்டால் மூடி, ");
INSERT INTO tam2017_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","அந்தத் தண்டுகளால் பெட்டியைச் சுமக்கும்படி, அவைகளைப் பெட்டியின் பக்கங்களிலிருக்கும் வளையங்களிலே பாய்ச்சு. ");
INSERT INTO tam2017_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","அந்தத் தண்டுகள் பெட்டியிலிருந்து கழற்றப்படாமல், அதின் வளையங்களிலே இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","நான் உனக்குக் கொடுக்கும் உடன்படிக்கையின் கட்டளைகளை அந்தப் பெட்டியிலே வைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“சுத்தப்பொன்னினாலே கிருபாசனத்தைச் செய்; அது இரண்டரை முழ நீளமும் ஒன்றரை முழ அகலமுமாக இருக்கட்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","பொன்னினால் இரண்டு கேருபீன்களைச் செய்; பொன்னைத் தகடாக அடித்து, அவைகளைச் செய்து, கிருபாசனத்தின் இரண்டு ஓரங்களிலும் வைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ஒருபக்கத்து ஓரத்தில் ஒரு கேருபீனையும் மறுபக்கத்து ஓரத்தில் மற்றக் கேருபீனையும் செய்து வை; அந்தக் கேருபீன்கள் கிருபாசனத்தின் இரண்டு ஓரங்களிலும் அதனோடு இருக்கும்படி ஒரேவேலையாக, அவைகளைச் செய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","அந்தக் கேருபீன்கள் தங்களுடைய இறக்கைகளை உயர விரித்து, தங்களுடைய இறக்கைகளால் கிருபாசனத்தை மூடுகிறவைகளும் ஒன்றுக்கொன்று எதிர்முகமுள்ளவைகளுமாக இருக்கட்டும்; கேருபீன்களின் முகங்கள் கிருபாசனத்தை நோக்குகிறவைகளாக இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","கிருபாசனத்தைப் பெட்டியின்மீது வைத்து, பெட்டிக்குள்ளே நான் உனக்குக் கொடுக்கும் உடன்படிக்கையின் கட்டளைகளை வைப்பாயாக. ");
INSERT INTO tam2017_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","அங்கே நான் உன்னைச் சந்திப்பேன்; கிருபாசனத்தின்மீதிலும் சாட்சிப்பெட்டியின்மேல் நிற்கும் இரண்டு கேருபீன்களின் நடுவிலுமிருந்து நான் இஸ்ரவேலர்களுக்காக உனக்குக் கற்பிக்கப் போகிறவைகளையெல்லாம் உன்னோடு சொல்லுவேன். ");
INSERT INTO tam2017_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“சீத்திம் மரத்தால் ஒரு மேஜையையும் செய்; அது இரண்டு முழ நீளமும் ஒரு முழ அகலமும் ஒன்றரை முழ உயரமுமாக இருக்கட்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","அதைச் சுத்தப் பொன்தகட்டால் மூடி, சுற்றிலும் அதற்குப் பொன்னினால் விளிம்பை உண்டாக்கி, ");
INSERT INTO tam2017_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","சுற்றிலும் அதற்கு நான்கு விரலளவு உள்ள சட்டத்தையும், அதின் சட்டத்திற்குச் சுற்றிலும் பொன்னினால் விளிம்பையும் உண்டாக்கி, ");
INSERT INTO tam2017_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","அதற்கு நான்கு பொன்வளையங்களைச் செய்து, அவைகளை அதின் நான்கு கால்களுக்கு இருக்கும் நான்கு மூலைகளிலும் நீ தைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","அந்த வளையங்கள் மேஜையைச் சுமக்கும் தண்டுகளுக்கு இடங்கள் உண்டாயிருக்கும்படி, சட்டத்தின் அருகே இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","அந்தத் தண்டுகளைச் சீத்திம் மரத்தினால் செய்து, அவைகளைப் பொன்தகட்டால் மூடு; அவைகளால் மேஜை சுமக்கப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","அதற்குரிய தட்டுகளையும், தூபக்கரண்டிகளையும், கிண்ணங்களையும், பானபலிக்கான கிண்ணங்களையும் செய்யக்கடவாய்; அவைகளைப் சுத்தப்பொன்னினால் செய். ");
INSERT INTO tam2017_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","மேஜையின்மேல் எப்போதும் என்னுடைய சந்நிதியில் சமுகத்தப்பங்களை வைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“சுத்தப்பொன்னினால் ஒரு குத்துவிளக்கை உண்டாக்கு; அது பொன்னினால் அடிப்பு வேலையாகச் செய்யப்படவேண்டும்; அதின் தண்டும், கிளைகளும், மொக்குகளும், பழங்களும், பூக்களும் பொன்னினால் செய்யப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","ஆறு கிளைகள் அதின் பக்கங்களில் விடவேண்டும்; குத்துவிளக்கின் மூன்று கிளைகள் அதின் ஒரு பக்கத்திலும், குத்துவிளக்கின் மூன்று கிளைகள் அதின் மறுபக்கத்திலும் விடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ஒவ்வொரு கிளையிலே வாதுமைக்கொட்டைக்கு ஒப்பான மூன்று மொக்குகளும், ஒரு பழமும், ஒரு பூவும் இருப்பதாக; குத்துவிளக்கிலிருந்து புறப்படும் ஆறு கிளைகளிலும் அப்படியே இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","விளக்குத்தண்டிலோ, வாதுமைக் கொட்டைக்கு ஒப்பான நான்கு மொக்குகளும், பழங்களும், பூக்களும் இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","அதிலிருந்து புறப்படும் இரண்டு கிளைகளின்கீழ் ஒரு பழமும், வேறு இரண்டு கிளைகளின்கீழ் ஒரு பழமும், மற்ற இரண்டு கிளைகளின்கீழ் ஒரு பழமும் இருக்கட்டும்; விளக்குத்தண்டிலிருந்து புறப்படும் ஆறு கிளைகளுக்கும் அப்படியே இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","அவைகளின் பழங்களும் அவைகளின் கிளைகளும் பொன்னினால் உண்டானவைகளாக இருக்கட்டும்; அவையெல்லாம் தகடாக அடித்த சுத்தப்பொன்னால் செய்யப்பட்ட ஒரே வேலையாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","அதில் ஏழு அகல்களைச் செய்; அதற்கு நேர் எதிராக எரியும்படி அவைகள் ஏற்றப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","அதின் கத்தரிகளும் சாம்பல் பாத்திரங்களும் சுத்தப்பொன்னினால் செய்யப்படுவதாக. ");
INSERT INTO tam2017_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","அதையும், அதற்குரிய பணிப்பொருட்கள் யாவையும் ஒரு தாலந்து சுத்தப்பொன்னினால் செய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","மலையிலே உனக்குக் காண்பிக்கப்பட்ட மாதிரியின்படி அவைகளைச் செய்ய எச்சரிக்கையாக இரு. ");
INSERT INTO tam2017_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“மேலும் திரித்த மெல்லிய பஞ்சுநூலினாலும், இளநீலநூலினாலும், இரத்தாம்பரநூலினாலும், சிவப்பு நூலினாலும் நெய்யப்பட்ட பத்து மூடுதிரைகளால் ஆசரிப்பு கூடாரத்தை உண்டாக்கு; அவைகளில் விசித்திர பின்னல்வேலையாகக் கேருபீன்களைச் செய். ");
INSERT INTO tam2017_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ஒவ்வொரு மூடுதிரையும் இருபத்தெட்டு முழ நீளமும், நான்கு முழ அகலமுமாக இருப்பதாக; மூடுதிரைகளெல்லாம் ஒரே அளவாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","ஐந்து மூடுதிரைகள் ஒன்றோடொன்று இணைக்கப்பட்டிருக்கவேண்டும்; மற்ற ஐந்து மூடுதிரைகளும் ஒன்றோடொன்று இணைக்கப்பட்டிருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","இணைக்கப்பட்ட ஒரு மூடுதிரையின் கடைசி ஓரத்தில் இளநீலநூலால் காதுகளை உண்டாக்கு; இணைக்கப்பட்ட மற்ற மூடுதிரைகளின் ஓரத்திலும் அப்படியே செய். ");
INSERT INTO tam2017_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","காதுகள் ஒன்றோடொன்று இணையும்படி ஒரு மூடுதிரையில் ஐம்பது காதுகளையும், இணைக்கப்பட்ட மற்ற மூடுதிரையின் ஓரத்தில் ஐம்பது காதுகளையும் உண்டாக்கு. ");
INSERT INTO tam2017_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","ஐம்பது பொன் கொக்கிகளை செய்து, மூடுதிரைகளை ஒன்றோடொன்று அந்தக் கொக்கிகளால் இணைக்கப்படவேண்டும். அப்பொழுது ஆசரிப்பு கூடாரம் ஒன்றாகும். ");
INSERT INTO tam2017_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“ஆசரிப்பு கூடாரத்தின்மேல் கூடாரமாகப்போடும்படி ஆட்டு ரோமத்தால் பதினொரு மூடுதிரைகளை உண்டாக்கு. ");
INSERT INTO tam2017_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ஒவ்வொரு மூடுதிரைகளும் முப்பது முழ நீளமும், நான்கு முழ அகலமாக இருக்கவேண்டும்; பதினொரு மூடுதிரைகளும் ஒரே அளவாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","ஐந்து மூடுதிரைகளை ஒன்றாகவும், ஆறு மூடுதிரைகளை ஒன்றாகவும் இணைக்கவேண்டும்; ஆறாம் மூடுதிரையைக் கூடாரத்தின் முகப்பிற்கு முன்னே மடித்துப்போடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","இணைக்கப்பட்ட ஒரு மூடுதிரையின் கடைசி ஓரத்தில் ஐம்பது காதுகளையும், இணைக்கப்பட்ட மற்ற மூடுதிரையின் ஓரத்தில் ஐம்பது காதுகளையும் உண்டாக்கி, ");
INSERT INTO tam2017_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","ஐம்பது வெண்கலக் கொக்கிகளைச் செய்து, கொக்கிகளைக் காதுகளில் மாட்டி, ஒரே கூடாரமாகும்படி அதை இணைத்துவிடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","கூடாரத்தின் மூடுதிரைகளில் மீதமான பாதிமூடுதிரை ஆசரிப்பு கூடாரத்தின் பின்புறத்தில் தொங்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","கூடாரத்தினுடைய மூடுதிரைகளின் நீளத்தில் மீதியானதில், இந்தப்பக்கத்தில் ஒரு முழமும் அந்தப்பக்கத்தில் ஒரு முழமும் ஆசரிப்பு கூடாரத்தை மூடும்படி அதின் பக்கங்களிலே தொங்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","சிவப்பு வண்ணம் தீட்டப்பட்ட ஆட்டுக்கடாத் தோலால் கூடாரத்திற்கு ஒரு மூடியையும், அதின்மேல் மெல்லிய தோலால் ஒரு மூடியையும் உண்டாக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“ஆசரிப்பு கூடாரத்திற்கு நிமிர்ந்துநிற்கும் பலகைகளையும் சீத்திம் மரத்தால் உண்டாக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","ஒவ்வொரு பலகையும் பத்து முழ நீளமும் ஒன்றரை முழ அகலமுமாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","ஒவ்வொரு பலகைக்கும் ஒன்றோடொன்று இணைந்திருக்கும் இரண்டு பொருந்தும் முனை இருக்கவேண்டும்; ஆசரிப்புக் கூடாரங்களில் பலகைகளுக்கெல்லாம் இப்படியே செய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","ஆசரிப்புக் கூடாரத்திற்காக செய்யப்படுகிற பலகைகளில் இருபது பலகைகள் தெற்கே தென்திசைக்கு எதிராக நிற்கட்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","அந்த இருபது பலகைகளின்கீழே வைக்கும் நாற்பது வெள்ளிப் பாதங்களை உண்டாக்கவேண்டும்; ஒரு பலகையின் கீழ் அதின் இரண்டு பொருந்தும் முனைகளுக்கும் இரண்டு பாதங்களும், மற்றப் பலகையின் கீழ் அதின் இரண்டு பொருந்தும் முனைகளுக்கும் இரண்டு பாதங்களும் இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","ஆசரிப்பு கூடாரத்தின் மறுபக்கமாகிய வடபுறத்திலும் இருபது பலகைகளையும், ");
INSERT INTO tam2017_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","அவைகளின் கீழ் நாற்பது வெள்ளிப்பாதங்களையும் உண்டாக்கவேண்டும்; ஒரு பலகையின் கீழ் இரண்டு பாதங்களும், மற்றப் பலகையின் கீழ் இரண்டு பாதங்களும் இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","ஆசரிப்பு கூடாரத்தின் மேற்குப்பக்கத்திற்கு ஆறு பலகைகளையும், ");
INSERT INTO tam2017_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ஆசரிப்பு கூடாரத்தின் இருபக்கத்திலுமுள்ள மூலைகளுக்கு இரண்டு பலகைகளையும் உண்டாக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","அவைகள் கீழே சேர்க்கப்பட்டிருக்கவேண்டும்; மேலேயும் ஒரு வளையத்தினால் சேர்க்கப்பட்டிருக்கவேண்டும்; இரண்டு மூலைகளுக்கும் அப்படியே இருக்கவேண்டும்; அவைகள் இரண்டு மூலைகளுக்கு ஆகும். ");
INSERT INTO tam2017_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","அந்தப்படி எட்டுப் பலகைகள் இருக்கவேண்டும்; ஒவ்வொரு பலகையின் கீழ் இரண்டு இரண்டு பாதங்களாகப் பதினாறு வெள்ளிப் பாதங்களும் இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“சீத்திம் மரத்தால் ஆசரிப்பு கூடாரத்தின் ஒரு பக்கத்துப் பலகைகளுக்கு ஐந்து தாழ்ப்பாள்களையும், ");
INSERT INTO tam2017_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ஆசரிப்பு கூடாரத்தின் மறுபக்கத்துப் பலகைகளுக்கு ஐந்து தாழ்ப்பாள்களையும், ஆசரிப்பு கூடாரத்தின் மேற்புறமான பின்பக்கத்துப் பலகைகளுக்கு ஐந்து தாழ்ப்பாள்களையும் செய். ");
INSERT INTO tam2017_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","நடுத்தாழ்ப்பாள் ஒரு முனை தொடங்கி மறுமுனைவரை பலகைகளின் மையத்தில் ஊடுருவப் பாய்ச்சப்பட்டிருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","பலகைகளைப் பொன்தகட்டால் மூடி, தாழ்ப்பாள்களின் இடங்களாகிய அவைகளின் வளையங்களைப் பொன்னினால் செய்து, தாழ்ப்பாள்களைப் பொன் தகட்டால் மூடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","இப்படியாக மலையின்மேல் உனக்குக் காண்பிக்கப்பட்ட மாதிரியின்படி ஆசரிப்பு கூடாரத்தை அமைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“இளநீலநூலும் இரத்தாம்பரநூலும் சிவப்புநூலும் திரித்த மெல்லிய பஞ்சுநூலுமான இவற்றால் ஒரு மூடுதிரையைச் செய்யவேண்டும்; அதிலே வேலைப்பாடு செய்யப்பட்ட கேருபீன்கள் வைக்கப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","சீத்திம் மரத்தால் செய்து, பொன் தகட்டால் மூடப்பட்ட நான்கு தூண்களிலே அதைத் தொங்கவிடு; அந்தத் தூண்கள் நான்கு வெள்ளிப் பாதங்கள்மேல் நிற்கவும், அவைகளின் கொக்கிகள் பொன்னினால் செய்யப்படவும் வேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","கொக்கிகளின்கீழே அந்த மூடுதிரையைத் தொங்கவிட்டு, சாட்சிப்பெட்டியை அங்கே மூடுதிரைக்குள்ளாக வைக்கவேண்டும்; அந்த மூடுதிரை பரிசுத்த இடத்திற்கும் மகா பரிசுத்த இடத்திற்கும் பிரிவை உண்டாக்கும். ");
INSERT INTO tam2017_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","மகா பரிசுத்த இடத்திலே சாட்சிப்பெட்டியின்மேல் கிருபாசனத்தை வைப்பாயாக; ");
INSERT INTO tam2017_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","மூடுதிரைக்கு வெளியே மேஜையையும், மேஜைக்கு எதிரே ஆசரிப்பு கூடாரத்தின் தென்பக்கமாகக் குத்துவிளக்கை வைத்து, மேஜையை வடபக்கமாக வைப்பாயாக. ");
INSERT INTO tam2017_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","இளநீலநூலும் இரத்தாம்பரநூலும் சிவப்புநூலும் திரித்த மெல்லிய பஞ்சுநூலுமாகிய இவற்றால் சித்திரத் தையல் வேலையான ஒரு தொங்கு திரையும் கூடாரத்தின் வாசலுக்கு உண்டாக்கி, ");
INSERT INTO tam2017_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","அந்தத் தொங்கு திரைக்குச் சீத்திம் மரத்தால் ஐந்து தூண்களைச் செய்து, அவைகளைப் பொன்தகட்டால் மூடி, அவைகளுக்குப் பொன் கொக்கிகளை உண்டாக்கி, அவைகளுக்கு ஐந்து வெண்கலப்பாதங்களை வார்க்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“ஐந்து முழ நீளமும் ஐந்து முழ அகலமாக சீத்திம் மரத்தால் பலிபீடத்தையும் உண்டாக்கவேண்டும்; அது சதுரமும் மூன்று முழ உயரமுமாக இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","அதின் நான்கு மூலைகளிலும் நான்கு கொம்புகளை உண்டாக்கவேண்டும்; அதின் கொம்புகள் அதனோடு ஒன்றாக இருக்கவேண்டும்; அதை வெண்கலத் தகட்டால் மூடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","அதின் சாம்பலை எடுக்கத்தகுந்த சட்டிகளையும் கரண்டிகளையும் கிண்ணங்களையும் முள்துறடுகளையும் நெருப்புச்சட்டிகளையும் உண்டாக்கவேண்டும்; அதின் பணிப்பொருட்களையெல்லாம் வெண்கலத்தால் செய்வாயாக. ");
INSERT INTO tam2017_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","வலைப்பின்னல்போன்ற ஒரு வெண்கலச் சல்லடையைச் செய்து, அந்தச் சல்லடையின் நான்கு மூலைகளிலும் நான்கு வெண்கல வளையங்களை உண்டாக்கி, ");
INSERT INTO tam2017_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","அந்தச் சல்லடை பலிபீடத்தின் பாதிஉயரத்தில் இருக்கும்படி அதை பலிபீடத்தின் அடியில் சுற்றடைப்புக்குக் கீழே வைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","பலிபீடத்திற்குச் சீத்திம் மரத்தால் தண்டுகளைச் செய்து, அவைகளை வெண்கலத்தகட்டால் மூடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","பலிபீடத்தைச் சுமக்கும்படி அந்தத் தண்டுகள் அதின் இரண்டு பக்கங்களிலும் வளையங்களிலே மாட்டப்பட்டிருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","அதை உள்ளே மற்றும் வெளியேவிட்டுப் பலகைகளினாலே செய்யவேண்டும்; மலையில் உனக்குக் காண்பிக்கப்பட்டபடி அதைச் செய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“ஆசரிப்பு கூடாரத்திற்கு பிராகாரத்தையும் உண்டாக்கவேண்டும்; தெற்கே தென்திசைக்கு எதிரான பிராகாரத்திற்குத் திரித்த மெல்லிய பஞ்சுநூலால் செய்யப்பட்ட நூறுமுழ நீளமான தொங்கு திரைகள் இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","அவைகளுக்கு வெண்கலத்தினால் இருபது தூண்களும், இருபது பாதங்களும் இருக்கவேண்டும்; தூண்களின் கொக்கிகளும் அவைகளின் வளையங்களும் வெள்ளியால் செய்யப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","அப்படியே வடக்கு பக்கத்தின் நீளத்திற்கும் நூறுமுழ நீளமான தொங்கு திரைகள் இருக்கவேண்டும்; அவைகளுக்கு இருபது தூண்களும், அவைகளுக்கு இருபது பாதங்களும் வெண்கலமாக இருக்கவேண்டும்; தூண்களின் கொக்கிகளும் வளையங்களும் வெள்ளியால் செய்யப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","பிராகாரத்தின் மேற்கு பக்கமான அகலத்திற்கு ஐம்பது முழ நீளமான தொங்கு திரைகள் இருக்கவேண்டும்; அவைகளுக்குப் பத்துத் தூண்களும், அவைகளுக்குப் பத்துப் பாதங்களும் இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","சூரியன் உதிக்கிற திசையாகிய கிழக்குப்பக்கத்தின் பிராகாரம் ஐம்பது முழ அகலமாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","அங்கே ஒரு பக்கத்திற்குப் பதினைந்து முழ நீளமான தொங்கு திரைகளும், அவைகளுக்கு மூன்று தூண்களும், அவைகளுக்கு மூன்று பாதங்களும் இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","மறுபக்கத்திற்குப் பதினைந்து முழ நீளமான தொங்கு திரைகளும், அவைகளுக்கு மூன்று தூண்களும், அவைகளுக்கு மூன்று பாதங்களும் இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","பிராகாரத்தின் வாசலுக்கு இளநீலநூலாலும் இரத்தாம்பரநூலாலும் சிவப்புநூலாலும் திரித்த மெல்லிய பஞ்சுநூலாலும் சித்திரத் தையல்வேலையாகச் செய்யப்பட்ட இருபதுமுழ நீளமான ஒரு தொங்கு திரையும் அதற்கு நான்கு தூண்களும், அவைகளுக்கு நான்கு பாதங்களும் இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","சுற்று பிராகாரத்தின் தூண்களெல்லாம் வெள்ளியினால் வளையம் கட்டப்பட்டிருக்கவேண்டும்; அவைகளின் கொக்கிகள் வெள்ளியினாலும் அவைகளின் பாதங்கள் வெண்கலத்தினாலும் செய்யப்பட்டிருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","பிராகாரத்தின் நீளம் நூறுமுழமும், இருபக்கத்து அகலம் ஐம்பது ஐம்பது முழமும், உயரம் ஐந்து முழமுமாக இருப்பதாக; அதின் தொங்கல்கள் திரித்த மெல்லிய பஞ்சுநூலினால் செய்யப்பட்டு, அதின் தூண்களின் பாதங்கள் வெண்கலமாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","ஆசரிப்பு கூடாரத்தின் எல்லா பணிகளுக்குத் தேவையான எல்லா பணிப்பொருட்களும், அதின் எல்லா ஆப்புகளும், பிராகாரத்தின் எல்லா ஆப்புகளும் வெண்கலமாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","குத்துவிளக்கு எப்பொழுதும் எரிந்துகொண்டிருக்கும்படி இடித்துப் பிழிந்த தெளிவான ஒலிவ எண்ணெயை உன்னிடத்தில் கொண்டுவரும்படி இஸ்ரவேலர்களுக்குக் கட்டளையிடு. ");
INSERT INTO tam2017_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","கூடாரத்தில் சாட்சி சந்நிதிக்கு முன்னிருக்கும் திரைக்கு வெளியே ஆரோனும் அவனுடைய மகன்களும் மாலை துவங்கி அதிகாலைவரை யெகோவாவுடைய சந்நிதானத்தில் அந்த விளக்கை எரியவைக்கவேண்டும்; இது இஸ்ரவேலர்களின் தேசத்திற்கு தலைமுறை தலைமுறையாக நிரந்தர கட்டளையாக இருக்கட்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“உன்னுடைய சகோதரனாகிய ஆரோன் எனக்கு ஆசாரிய ஊழியம் செய்யும்படி, நீ ஆரோனையும் அவனுடன் அவனுடைய மகன்களாகிய நாதாப், அபியூ, எலெயாசார், இத்தாமார் என்னும் ஆரோனின் மகன்களையும் இஸ்ரவேலர்களிலிருந்து பிரித்து, உன்னிடம் சேர்த்துக்கொள். ");
INSERT INTO tam2017_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","உன்னுடைய சகோதரனாகிய ஆரோனுக்கு, மகிமையும் அலங்காரமுமாக இருக்கும்படி, பரிசுத்த ஆடைகளை உண்டாக்கு. ");
INSERT INTO tam2017_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","ஆரோன் எனக்கு ஆசாரிய ஊழியம் செய்ய அவனைப் பரிசுத்தப்படுத்தும்படி அவனுக்கு ஆடைகளை உண்டாக்க, நான் ஞானத்தின் ஆவியால் நிரப்பின விவேகமான இருதயமுள்ள எல்லாரோடும் நீ சொல்லு. ");
INSERT INTO tam2017_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","அவர்கள் உண்டாக்கவேண்டிய ஆடைகள்; மார்ப்பதக்கமும், ஏபோத்தும், அங்கியும், வேலைப்பாடுடன் நெய்யப்பட்ட உள்சட்டையும், தலைப்பாகையும், இடுப்புக்கச்சையுமே. உன்னுடைய சகோதரனாகிய ஆரோன் எனக்கு ஆசாரிய ஊழியம் செய்யும்படி, அவனுக்கும் அவனுடைய மகன்களுக்கும் பரிசுத்த ஆடைகளை உண்டாக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","அவர்கள் பொன்னும் இளநீலநூலும் இரத்தாம்பரநூலும் சிவப்புநூலும் மெல்லிய பஞ்சுநூலும் சேகரிக்கட்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“ஏபோத்தைப் பொன்னினாலும் இளநீலநூலாலும் இரத்தாம்பரநூலாலும் சிவப்புநூலாலும் திரித்த மெல்லிய பஞ்சுநூலாலும் விசித்திரவேலையாகச் செய்யட்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","அது ஒன்றாக இணைக்கப்படும்படி, இரண்டு தோள்துண்டுகளின்மேலும், அதின் இரண்டு முனைகளும் சேர்க்கப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","அந்த ஏபோத்தின்மேல் இருக்கவேண்டிய வேலைப்பாடு மிகுந்த வார்க்கச்சை அந்த வேலையைப்போலவே, பொன்னினாலும் இளநீலநூலாலும் இரத்தாம்பரநூலாலும் சிவப்புநூலாலும் திரித்த மெல்லிய பஞ்சுநூலாலும் செய்யப்பட்டு, அதனோடு ஒன்றாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","பின்னும் நீ இரண்டு கோமேதகக்கற்களை எடுத்து, இஸ்ரவேலின் பன்னிரண்டு மகன்களின் பெயர்களை அவைகளில் வெட்டுவாயாக. ");
INSERT INTO tam2017_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","அவர்கள் பிறந்த வரிசையின்படி, அவர்களுடைய பெயர்களில் ஆறு பெயர்கள் ஒரு கல்லிலும், மற்ற ஆறு பெயர்கள் மறுகல்லிலும் இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","இரத்தினங்களில் முத்திரை வெட்டுகிறவர்கள் செய்யும் வேலைக்கு ஒப்பாக அந்த இரண்டு கற்களிலும் இஸ்ரவேலின் பன்னிரண்டு மகன்களின் பெயர்களை வெட்டி, அவைகளைப் பொன் குவளைகளில் பதிப்பாயாக. ");
INSERT INTO tam2017_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","ஆரோன் யெகோவாவுக்கு முன்பாகத் தன்னுடைய இரண்டு தோள்களின்மேலும் இஸ்ரவேல் மகன்களின் பெயர்களை ஞாபகக்குறியாகச் சுமந்துவர, அந்த இரண்டு கற்களையும் ஏபோத்து தோள்களின்மேல் அவர்களை நினைக்கும்படி கற்களாக வைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","“பொன்னினால் வளையங்களைச்செய்து, ");
INSERT INTO tam2017_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","சரியான அளவுக்குப் பின்னல்வேலையான இரண்டு சங்கிலிகளையும், சுத்தப்பொன்னினால் உண்டாக்கி, அந்தச் சங்கிலிகளை அந்த வளையங்களில் பூட்டுவாயாக. ");
INSERT INTO tam2017_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“நியாயவிதி மார்ப்பதக்கத்தையும் விசித்திரவேலையாகச் செய்; அதை ஏபோத்து வேலைக்கு ஒப்பாகப் பொன்னினாலும் இளநீலநூலாலும் இரத்தாம்பரநூலாலும் திரித்த மெல்லிய பஞ்சுநூலாலும் செய்வாயாக. ");
INSERT INTO tam2017_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","அது சதுரமும் இரட்டையும், ஒரு சாண் நீளமும் ஒரு சாண் அகலமுமாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","அதிலே நான்கு வரிசை இரத்தினக்கற்களை நிறையப் பதிக்கவும்; முதலாம் வரிசை பத்மராகமும் புஷ்பராகமும் மாணிக்கமும், ");
INSERT INTO tam2017_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","இரண்டாம் வரிசை மரகதமும் இந்திரநீலமும் வைரமும், ");
INSERT INTO tam2017_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","மூன்றாம் வரிசை கெம்பும் வைடூரியமும் சுகந்தியும், ");
INSERT INTO tam2017_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","நான்காம் வரிசை படிகப்பச்சையும் கோமேதகமும் யஸ்பியுமாக இருக்கட்டும்; இவைகள் அந்தந்த வரிசையில் பொன்னினாலே பதித்திருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","இந்தக் கற்கள் இஸ்ரவேல் மகன்களின் பெயர்களின்படியே பன்னிரண்டும், அவர்களுடைய பெயர்கள் அவைகளில் வெட்டப்பட்டவைகளுமாக இருக்கவேண்டும்; பன்னிரண்டு கோத்திரங்களில் ஒவ்வொன்றினுடைய பெயர் ஒவ்வொன்றிலே முத்திரைவெட்டாக வெட்டியிருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","மார்ப்பதக்கத்திற்கு அதின் பக்கங்களிலே பின்னல்வேலையான சுத்தப்பொன் சங்கிலிகளையும் செய்து, ");
INSERT INTO tam2017_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","அந்த மார்ப்பதக்கத்திற்கு இரண்டு பொன் வளையங்களையும் செய்து, அந்த இரண்டு வளையங்களையும் மார்ப்பதக்கத்தின் இரண்டு பக்கங்களிலே வைத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","பொன்னினால் செய்த அந்த இரண்டு பின்னல் வேலையான சங்கிலிகளையும் மார்ப்பதக்கத்தின் பக்கங்களில் இருக்கிற இரண்டு வளையங்களில் மாட்டி, ");
INSERT INTO tam2017_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","அந்த இரண்டு பின்னல் வேலையான சங்கிலிகளின் இரண்டு முனைகளை ஏபோத்துத் தோள்துண்டின்மேல் அதின் முன்பக்கத்தில் இருக்கிற இரண்டு வளையங்களில் மாட்டவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","நீ இரண்டு பொன்வளையங்களை செய்து, அவைகளை ஏபோத்தின் கிழக்குபக்கத்திற்கு எதிரான மார்ப்பதக்கத்தினுடைய மற்ற இரண்டு பக்கங்களிலும் அதனுடைய ஓரத்திற்குள்ளாக வைத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","வேறு இரண்டு பொன்வளையங்களைச் செய்து, அவைகளை ஏபோத்தின் முன்பக்கத்து இரண்டு கீழ்ப்பக்கங்களில் அதின் இணைப்புக்கு எதிராகவும், ஏபோத்தின் வேலைப்பாடு மிகுந்த வார்க்கச்சைக்கு மேலாகவும் வைத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","மார்ப்பதக்கம் ஏபோத்தின் விசித்திரமான வார்க்கச்சைக்கு மேலாக இருக்கும்படி, அது ஏபோத்திலிருந்து நீங்காதபடி, அதை அதின் வளையங்களால் ஏபோத்து வளையங்களோடு இளநீல நாடாவினால் கட்டவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","ஆரோன் பரிசுத்த ஸ்தலத்திற்குள் நுழையும்போது, இஸ்ரவேலின் பன்னிரண்டு மகன்களின் பெயர்களைத் தன்னுடைய இருதயத்தின்மேல் இருக்கும் நியாயவிதி மார்ப்பதக்கத்திலே யெகோவாவுடைய சந்நிதானத்தில் ஞாபகக்குறியாக எப்பொழுதும் அணிந்துகொள்ளவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","நியாயவிதி மார்ப்பதக்கத்திலே ஊரீம் தும்மீம் என்பவைகளை வைக்கவேண்டும்; ஆரோன் யெகோவாவுடைய சந்நிதானத்தில் நுழையும்போது, அவைகள் அவனுடைய இருதயத்தின்மேல் இருக்கவேண்டும்; ஆரோன் தன்னுடைய இருதயத்தின்மேல் இஸ்ரவேலர்களுடைய நியாயவிதியைக் யெகோவாவுடைய சந்நிதானத்தில் எப்பொழுதும் அணிந்துகொள்ளவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“ஏபோத்தின் கீழ் அங்கியை முழுவதும் இளநீலநூலால் உண்டாக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","தலை நுழைகிற அதின் துவாரம் அதின் நடுவில் இருக்கவும், அதின் துவாரத்திற்கு நெய்யப்பட்ட வேலைப்பாடுள்ள ஒரு நாடா சுற்றிலும் இருக்கவேண்டும்; அது கிழியாதபடி மார்க்கவசத்தின் துவாரத்திற்கு ஏற்றதாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","அதின் கீழ் ஓரங்களில் இளநீலநூல் இரத்தாம்பரநூல் சிவப்புநூல் வேலையால் செய்யப்பட்ட மாதுளம்பழங்களையும், அவைகளுக்கு இடையிடையே சுற்றிலும் பொன்மணிகளையும் அதின் ஓரங்களில் சுற்றிலும் தொங்கும்படி செய்துவைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","அங்கியின் ஓரங்களில் சுற்றிலும் ஒரு பொன்மணியும் ஒரு மாதுளம்பழமும், ஒரு பொன்மணியும் ஒரு மாதுளம்பழமுமாகத் தொங்கட்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","ஆரோன் ஆராதனை செய்யக் யெகோவாவுடைய சந்நிதியில் பரிசுத்த இடத்திற்குள் நுழையும்போதும், வெளியே வரும்போதும், அவன் சாகாதபடி, அதின் சத்தம் கேட்கப்படும்படி அதை அணிந்துகொள்ளவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“சுத்தப்பொன்னினால் ஒரு தகட்டைச்செய்து, யெகோவாவுக்குப் பரிசுத்தம் என்று அதிலே முத்திரை வெட்டாக வெட்டி, ");
INSERT INTO tam2017_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","அது தலைப்பாகையில் இருக்கும்படி அதை இளநீல நாடாவினால் பாகையின் முகப்பிலே கட்டுவாயாக. ");
INSERT INTO tam2017_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","இஸ்ரவேலர்கள் தங்களுடைய பரிசுத்த காணிக்கைகளாகப் படைக்கும் பரிசுத்தமானவைகளின் அக்கிரமத்தை ஆரோன் சுமக்கும்படி, அது ஆரோனுடைய நெற்றியின்மேல் இருப்பதாக; யெகோவாவுடைய சந்நிதியில் அவர்கள் அங்கீகரிக்கப்படும்படி, அது எப்பொழுதும் அவனுடைய நெற்றியின்மேல் இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“மெல்லிய பஞ்சுநூலால் வேலைப்பாடு மிகுந்த உள்சட்டையும், மெல்லிய பஞ்சுநூலால் தலைப்பாகையையும் உண்டாக்கி, இடுப்புக்கச்சையை வேலைப்பாட்டுடன் செய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“ஆரோனுடைய மகன்களுக்கும், மகிமையும் அலங்காரமுமாக இருக்கும்படி, அங்கிகளையும், இடுப்புக்கச்சைகளையும், தலைப்பட்டைகளையும் உண்டாக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","உன்னுடைய சகோதரனாகிய ஆரோனும் அவனுடன் அவனுடைய மகன்களும் எனக்கு ஆசாரிய ஊழியம் செய்யும்படி, நீ அந்த ஆடைகளை அவர்களுக்கு அணிவித்து, அவர்களை அபிஷேகம்செய்து, அவர்களைப் பிரதிஷ்டைசெய்து, அவர்களைப் பரிசுத்தப்படுத்தவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","அவர்களுடைய நிர்வாணத்தை மூடும்படி, இடுப்புத்துவங்கி முழங்கால்வரை அணிய சணல்நூல் உள்ளாடைகளையும் உண்டாக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","ஆரோனும் அவனுடைய மகன்களும் பரிசுத்த இடத்திலே ஆராதனைசெய்ய ஆசரிப்புக்கூடாரத்திற்குள் நுழையும்போதும் பலிபீடத்தின் அருகில் சேரும்போதும், அக்கிரமம் சுமந்து அவர்கள் சாகாதபடி, அவைகளை அணிந்திருக்கவேண்டும்; இது அவனுக்கும் அவனுக்குப் பின்வரும் சந்ததிக்கும் நிரந்தர கட்டளை. ");
INSERT INTO tam2017_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“அவர்கள் எனக்கு ஆசாரிய ஊழியம் செய்ய அவர்களைப் பரிசுத்தப்படுத்தும்படி, நீ அவர்களுக்குச் செய்யவேண்டியது: ஒரு காளையையும் பழுதற்ற இரண்டு ஆட்டுக்கடாக்களையும் தெரிந்துகொள். ");
INSERT INTO tam2017_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","புளிப்பில்லா அப்பத்தையும், எண்ணெயிலே பிசைந்த புளிப்பில்லா அதிரசங்களையும், எண்ணெய் பூசப்பட்ட புளிப்பில்லா அடைகளையும் கோதுமையின் மெல்லியமாவினால் செய்து, ");
INSERT INTO tam2017_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","அவைகளை ஒரு கூடையிலே வைத்து, கூடையோடு அவைகளையும் காளையையும் இரண்டு ஆட்டுக்கடாக்களையும் கொண்டுவந்து, ");
INSERT INTO tam2017_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","ஆரோனையும் அவனுடைய மகன்களையும் ஆசரிப்புக்கூடாரத்தின் வாசல் முன்பாக வரச்செய்து, அவர்களைத் தண்ணீரால் கழுவி, ");
INSERT INTO tam2017_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","அந்த ஆடைகளை எடுத்து, ஆரோனுக்கு உள்சட்டையையும், ஏபோத்தின் கீழ் அங்கியையும், ஏபோத்தையும், மார்ப்பதக்கத்தையும் அணிந்து, ஏபோத்தின் விசித்திரமான இடுப்புக்கச்சையும் அவனுக்குக் கட்டி, ");
INSERT INTO tam2017_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","அவன் தலையிலே தலைப்பாகையையும் வைத்து, பரிசுத்த கிரீடத்தைத் தலைப்பாகையின்மேல் அணிந்து, ");
INSERT INTO tam2017_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","அபிஷேக தைலத்தை எடுத்து, அவனுடைய தலையின்மேல் ஊற்றி, அவனை அபிஷேகம் செய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","பின்பு அவனுடைய மகன்களை வரச்செய்து, ஆசாரிய ஊழியம் அவர்களுக்கு நிரந்தர கட்டளையாக இருக்கும்படி, அவர்களுக்கும் அங்கிகளை உடுத்து. ");
INSERT INTO tam2017_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ஆரோனுக்கும் அவனுடைய மகன்களுக்கும் இடுப்புக்கச்சைகளைக் கட்டி, அவனுடைய மகன்களுக்கு தொப்பிகளையும் அணிந்து, இப்படியாக ஆரோனையும் அவனுடைய மகன்களையும் பிரதிஷ்டை செய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“காளையை ஆசரிப்புக்கூடாரத்திற்கு முன்பாகக் கொண்டுவரவேண்டும்; அப்பொழுது ஆரோனும் அவனுடைய மகன்களும் தங்களுடைய கைகளைக் காளையினுடைய தலையின்மேல் வைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","பின்பு நீ அந்தக் காளையை ஆசரிப்புக்கூடாரத்து வாசலின் அருகில் யெகோவாவுடைய சந்நிதானத்தில் கொன்று, ");
INSERT INTO tam2017_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","அதனுடைய இரத்தத்தில் கொஞ்சம் எடுத்து, உன்னுடைய விரலினால் பலிபீடத்தின் கொம்புகள்மேல் பூசி, மற்ற இரத்தம் முழுவதையும் பலிபீடத்தின் அடியிலே ஊற்றி, ");
INSERT INTO tam2017_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","குடல்களை மூடிய கொழுப்பு யாவையும், கல்லீரலின்மேலுள்ள சவ்வையும், இரண்டு சிறுநீரகங்களையும், அவைகளின்மேலுள்ள கொழுப்பையும் எடுத்து, பலிபீடத்தின்மேல் எரித்து, ");
INSERT INTO tam2017_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","காளையின் இறைச்சியையும் அதின் தோலையும் அதின் சாணியையும் முகாமிற்கு வெளியே அக்கினியால் சுட்டெரிக்கவேண்டும்; இது பாவநிவாரணபலி. ");
INSERT INTO tam2017_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“பின்பு அந்த ஆட்டுக்கடாக்களில் ஒன்றைக் கொண்டுவந்து நிறுத்தவேண்டும்; அதனுடைய தலையின்மேல் ஆரோனும் அவனுடைய மகன்களும் தங்களுடைய கைகளை வைத்து. ");
INSERT INTO tam2017_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","அந்தக் கடாவை அடித்து, அதின் இரத்தத்தைப் பிடித்து, பலிபீடத்தின் மேல் சுற்றிலும் தெளித்து, ");
INSERT INTO tam2017_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","ஆட்டுக்கடாவைத் துண்டு துண்டாக வெட்டி, அதனுடைய குடல்களையும் அதனுடைய தொடைகளையும் கழுவி, அவைகளை அந்த வெட்டப்பட்ட இறைச்சித் துண்டுகளோடும் அதனுடைய தலையோடும் வைத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","ஆட்டுக்கடா முழுவதையும் பலிபீடத்தின்மேல் எரித்துவிடு; இது யெகோவாவுக்குச் செலுத்தும் சர்வாங்கதகனபலி; இது சுகந்த வாசனையும் யெகோவாவுக்குச் செலுத்தும் தகனபலியுமாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“பின்பு மற்ற ஆட்டுக்கடாவையும் கொண்டுவந்து நிறுத்தவேண்டும்; அதனுடைய தலையின்மேல் ஆரோனும் அவனுடைய மகன்களும் தங்களுடைய கைகளை வைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","அப்பொழுது அந்தக் கடாவைக் கொன்று, அதனுடைய இரத்தத்தில் கொஞ்சம் எடுத்து, ஆரோனின் வலது காதின் மடலிலும், அவனுடைய மகன்களின் வலது காதுகளின் மடலிலும், அவர்களுடைய வலது கைகளின் பெருவிரலிலும், அவர்களுடைய வலது கால்களின் பெருவிரலிலும் பூசி, மற்ற இரத்தத்தைப் பலிபீடத்தின்மேல் சுற்றிலும் தெளித்து, ");
INSERT INTO tam2017_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","பலிபீடத்தின்மேல் இருக்கும் இரத்தத்திலும் அபிஷேகத் தைலத்திலும் கொஞ்சம் எடுத்து, ஆரோனும் அவனுடைய ஆடைகளும் அவனுடைய மகன்களும் அவர்களுடைய ஆடைகளும் பரிசுத்தமாக்கப்படும்படி, அவன்மேலும் அவனுடைய ஆடைகள்மேலும் அவனுடைய மகன்கள்மேலும் அவர்களுடைய ஆடைகள்மேலும் தெளிக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","அந்த ஆட்டுக்கடா பிரதிஷ்டையின் ஆட்டுக்கடாவாக இருப்பதால், அதிலுள்ள கொழுப்பையும் வாலையும் குடல்களை மூடிய கொழுப்பையும் கல்லீரலின்மேலுள்ள சவ்வையும் இரண்டு சிறுநீரகங்களையும் அவைகளின்மேலுள்ள கொழுப்பையும் வலதுபக்கத்து முன்னந்தொடையையும், ");
INSERT INTO tam2017_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","யெகோவாவுடைய சந்நிதானத்தில் வைத்திருக்கிற புளிப்பில்லா அப்பங்களுள்ள கூடையில் ஒரு அப்பத்தையும் எண்ணெயிட்ட அப்பமாகிய ஒரு அதிரசத்தையும் ஒரு அடையையும் எடுத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","அவைகள் எல்லாவற்றையும் ஆரோனின் உள்ளங்கைகளிலும் அவனுடைய மகன்களின் உள்ளங்கைகளிலும் வைத்து, அவைகளைக் யெகோவாவுடைய சந்நிதானத்தில் அசைவாட்டப்படும் காணிக்கையாக அசைவாட்டி, ");
INSERT INTO tam2017_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","பின்பு அவைகளை அவர்கள் கைகளிலிருந்து எடுத்து, பலிபீடத்தின்மேல் சர்வாங்கதகனபலியோடு வைத்து, யெகோவாவுடைய சந்நிதானத்தில் சுகந்த வாசனையாகத் எரித்துப்போடு; இது யெகோவாவுக்குச் செலுத்தப்படும் தகனபலி. ");
INSERT INTO tam2017_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“ஆரோனுடைய பிரதிஷ்டையின் ஆட்டுக்கடாவிலே மார்புப்பகுதியை எடுத்து, அதைக் யெகோவாவுடைய சந்நிதானத்தில் அசைவாட்டப்படும் காணிக்கையாக அசைவாட்டு; அது உன்னுடைய பங்காக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","மேலும், ஆரோனுடைய பிரதிஷ்டைக்கும் அவனுடைய மகன்களுடைய பிரதிஷ்டைக்கும் நியமித்த ஆட்டுக்கடாவில் அசைவாட்டப்படுகிற மார்புப்பகுதியையும் உயர்த்திப் படைக்கப்படுகிற முன்னந்தொடையையும் பரிசுத்தப்படுத்துவாயாக. ");
INSERT INTO tam2017_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","அது ஏறெடுத்துப் படைக்கிற படைப்பானதால், இஸ்ரவேலர்கள் பலியிடுகிறவைகளில் அவைகளே நித்திய கட்டளையாக ஆரோனையும் அவனுடைய மகன்களையும் சேர்வதாக; இஸ்ரவேலர்கள் யெகோவாவுடைய சந்நிதானத்தில் உயர்த்திப் படைக்கிற சமாதானபலிகளில் அவைகளே உயர்த்திப் படைக்கும் படைப்பாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“ஆரோனின் பரிசுத்த ஆடைகள், அவனுக்குப்பின்பு, அவனுடைய மகன்களுக்கு சேரும்; அவர்கள் அவைகளை அணிந்துகொண்டு, அபிஷேகம்செய்யப்பட்டுப் பிரதிஷ்டையாக்கப்படுவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","அவனுடைய மகன்களில் அவனுடைய பட்டத்திற்கு வருகிற ஆசாரியன் பரிசுத்த இடத்தில் ஆராதனை செய்வதற்கு ஆசரிப்புக்கூடாரத்தில் நுழையும்போது, அவைகளை ஏழுநாட்கள்வரை அணிந்துகொள்ளவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“பிரதிஷ்டையின் ஆட்டுக்கடாவைக் கொண்டுவந்து, அதனுடைய இறைச்சியை பரிசுத்த இடத்தில் சமைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","அந்த ஆட்டுக்கடாவின் இறைச்சியையும், கூடையிலிருக்கிற அப்பத்தையும், ஆரோனும் அவனுடைய மகன்களும் ஆசரிப்புக்கூடாரத்தின் வாசலிலே சாப்பிடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","அவர்களைப் பிரதிஷ்டைச்செய்து பரிசுத்தப்படுத்தும்படி, அவைகளால் பாவநிவிர்த்தி செய்யப்பட்டபடியால், அவைகளை அவர்கள் சாப்பிடவேண்டும்; அந்நியனோ அவைகளை சாப்பிடக்கூடாது; அவைகள் பரிசுத்தமானவைகள். ");
INSERT INTO tam2017_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","பிரதிஷ்டையின் இறைச்சியிலும் அப்பத்திலும் ஏதாவது அதிகாலைவரை மீதியாக இருந்ததால், அதை அக்கினியால் சுட்டெரிக்கவேண்டும்; அது சாப்பிடப்படக்கூடாது, அது பரிசுத்தமானது. ");
INSERT INTO tam2017_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“இந்தபடி நான் உனக்குக் கட்டளையிட்ட எல்லாவற்றையும் நீ ஆரோனுக்கும் அவனுடைய மகன்களுக்கும் செய்யவேண்டும்; ஏழுநாட்கள்வரை நீ அவர்களைப் பிரதிஷ்டைசெய்து, ");
INSERT INTO tam2017_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","பாவநிவிர்த்திக்காக ஒவ்வொரு நாளிலும் ஒவ்வொரு காளையைப் பாவநிவாரண பலியாகப் பலியிட்டு; பலிபீடத்துக்காகப் பரிகாரம் செய்தபின்பு, அந்தப் பலிபீடத்தைச் சுத்திகரிக்கசெய்யவேண்டும்; அதைப் பரிசுத்தப்படுத்தும்படி அதை அபிஷேகம்செய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","ஏழுநாட்கள்வரை பலிபீடத்திற்காகப் பரிகாரம்செய்து, அதைப் பரிசுத்தமாக்கவேண்டும்; பலிபீடமானது மகா பரிசுத்தமாக இருக்கும்; பலிபீடத்தைத் தொடுகிறதெல்லாம் பரிசுத்தமாகும். ");
INSERT INTO tam2017_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“பலிபீடத்தின்மேல் நீ பலியிடவேண்டியது என்னவென்றால்; இடைவிடாமல் ஒவ்வொருநாளிலும் ஒருவயதுடைய இரண்டு ஆட்டுக்குட்டிகளைப் பலியிடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ஒரு ஆட்டுக்குட்டியைக் காலையிலும், மற்ற ஆட்டுக்குட்டியை மாலையிலும் பலியிடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","ஒரு மரக்காலிலே பத்தில் ஒரு பங்கானதும், இடித்துப் பிழிந்த காற்படி எண்ணெயிலே பிசைந்ததுமாகிய மெல்லிய மாவையும், பானபலியாகக் கால்படி திராட்சை ரசத்தையும், ஒரு ஆட்டுக்குட்டியுடன் படைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","மற்ற ஆட்டுக்குட்டியை மாலையிலே பலியிட்டு, காலையிலே செலுத்தின ஆகாரபலிக்கும் பானபலிக்கும் ஒரேமாதிரியாக அதைக் யெகோவாவுக்குச் சுகந்த வாசனையான தகனபலியாகப் படைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","உன்னுடனே பேசும்படி நான் உங்களைச் சந்திக்கும் இடமாயிருக்கிற ஆசரிப்புக்கூடாரத்தினுடைய வாசலாகிய யெகோவாவுடைய சந்நிதியிலே, உங்கள் தலைமுறைதோறும் செலுத்தப்படவேண்டிய நித்திய சர்வாங்க தகனபலி இதுவே. ");
INSERT INTO tam2017_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","அங்கே இஸ்ரவேலர்களைச் சந்திப்பேன்; அந்த இடம் என்னுடைய மகிமையினால் பரிசுத்தமாக்கப்படும். ");
INSERT INTO tam2017_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","ஆசரிப்புக்கூடாரத்தையும் பலிபீடத்தையும் நான் பரிசுத்தமாக்குவேன்; எனக்கு ஆசாரிய ஊழியம் செய்யும்படி, ஆரோனையும் அவனுடைய மகன்களையும் பரிசுத்தப்படுத்தி, ");
INSERT INTO tam2017_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","இஸ்ரவேலர்களின் நடுவே நான் தங்கி, அவர்களுக்குத் தேவனாக இருப்பேன். ");
INSERT INTO tam2017_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","தங்கள் நடுவே நான் தங்கும்படி, தங்களை எகிப்து தேசத்திலிருந்து புறப்படச்செய்த நான் தங்களுடைய தேவனாகிய யெகோவா என்று அவர்கள் அறிவார்கள்; நானே அவர்களுடைய தேவனாகிய யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“தூபங்காட்டுவதற்கு ஒரு தூபபீடத்தையும் சீத்திம் மரத்தால் உண்டாக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","அது ஒரு முழ நீளமும் ஒரு முழ அகலமுமான சதுரமும், இரண்டு முழ உயரமுமாக இருக்கவேண்டும், அதனுடைய கொம்புகள் அதனோடு ஒன்றாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","அதின் மேல்பக்கத்தையும் சுற்றுப்புறத்தையும் அதின் கொம்புகளையும் தகட்டால் மூடி, சுற்றிலும் அதற்குப் பொன்விளிம்பை உண்டாக்கி, ");
INSERT INTO tam2017_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","அந்த விளிம்பின்கீழே அதின் இரண்டு பக்கங்களிலும் அதைச் சுமக்கும் தண்டுகளின் இடங்களாகிய அதின் இரண்டு பக்கத்து இரண்டு மூலைகளிலும் இரண்டு பொன் வளையங்களை உண்டாக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","அந்தத் தண்டுகளையும் சீத்திம் மரத்தால் செய்து, அவைகளையும் பொன்தகட்டால் மூடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","சாட்சிப்பெட்டிக்கு முன்பாக இருக்கும் திரைச்சீலைக்கும், நான் உன்னைச் சந்திக்கும் இடமாகிய சாட்சி சந்நிதியின்மேலுள்ள கிருபாசனத்திற்கும் முன்பாக அதை வைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","ஆரோன் காலைதோறும் அதின்மேல் நறுமண தூபம்காட்டவேண்டும்; மாலையில் விளக்கேற்றும்போதும் அதின்மேல் தூபம்காட்டவேண்டும்; விளக்குகளை விளக்கும்போதும் அதின்மேல் தூபம்காட்டவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","உங்களுடைய தலைமுறைதோறும் யெகோவாவுடைய சந்நிதியில் காட்டவேண்டிய நிரந்தர தூபம் இதுவே. ");
INSERT INTO tam2017_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","அதின்மேல் அந்நிய தூபத்தையோ, தகனபலியையோ, ஆகாரபலியையோ படைக்கவேண்டாம்; அதின்மேல் பானபலியை ஊற்றவும் வேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","வருடத்தில் ஒருமுறை ஆரோன் பாவநிவாரணபலியின் இரத்தத்தால் அதின் கொம்புகளின்மேல் பரிகாரம் செய்யவேண்டும்; உங்களுடைய தலைமுறைதோறும் வருடத்தில் ஒருமுறை அதின்மேல் பரிகாரம் செய்யவேண்டும்; அது யெகோவாவுக்கு மகா பரிசுத்தமானது என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“நீ இஸ்ரவேலர்களை அவர்கள் எண்ணிக்கையின்படி கணக்குப்பார்க்க, அவர்களை எண்ணும்போது, அவர்களுக்குள்ளே ஒரு வாதை உண்டாகாதபடி, அவர்களில் ஒவ்வொருவனும் எண்ணப்படும் நேரத்தில் தன்தன் ஆத்துமாவுக்காகக் யெகோவாவுக்கு மீட்கும் பொருளைக் கொடுக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","எண்ணப்படுகிறவர்களின் கணக்கிலே சேருகிற ஒவ்வொருவனும் பரிசுத்த ஸ்தலத்தின் சேக்கல் கணக்கின்படி அரைச்சேக்கல் கொடுக்கவேண்டும்; ஒரு சேக்கலுக்கு இருபது கேரா; யெகோவாவுக்குச் செலுத்தப்படுவது அரைச்சேக்கல். ");
INSERT INTO tam2017_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","எண்ணப்படுகிறவர்களின் கணக்கிலே சேருகிற இருபது வயது முதற்கொண்டு அதற்கு மேற்பட்ட ஒவ்வொருவனும் அதைக் யெகோவாவுக்குச் செலுத்தவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","உங்கள் ஆத்துமாக்களுக்காகப் பாவநிவிர்த்திசெய்யும்படி நீங்கள் யெகோவாவுக்குக் காணிக்கை செலுத்தும்போது, செல்வந்தன் அரைச்சேக்கலுக்கு அதிகமாகக் கொடுக்கவும் வேண்டாம், தரித்திரன் அதற்குக் குறைவாகக் கொடுக்கவும் வேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","அந்த பாவநிவிர்த்தி பணத்தை நீ இஸ்ரவேலர்கள் கையில் வாங்கி, அதை ஆசரிப்புக்கூடாரத்தின் திருப்பணிக்குக் கொடுக்கவேண்டும்; அது யெகோவாவுடைய சந்நிதியில் உங்கள் ஆத்துமாக்களுக்காகப் பாவநிவிர்த்தி செய்வதற்கு, இஸ்ரவேலர்களுக்கு ஞாபகக்குறியாக இருக்கும் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“கழுவுவதற்கு வெண்கலத்தால் ஒரு தொட்டியையும், வெண்கலத்தால் அதின் பாதத்தையும் உண்டாக்கி, அதை ஆசரிப்புக்கூடாரத்திற்கும் பலிபீடத்திற்கும் நடுவே வைத்து, அதிலே தண்ணீர் ஊற்றவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","அதனிடம் ஆரோனும் அவனுடைய மகன்களும் தங்களுடைய கைகளையும் தங்களுடைய கால்களையும் கழுவவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","அவர்கள் ஆசரிப்புக்கூடாரத்திற்குள் நுழையும்போதும், யெகோவாவுக்குத் தகனத்தைக் கொளுத்தவும் பலிபீடத்தில் ஆராதனைசெய்ய சேரும்போதும், அவர்கள் சாகாதபடி தண்ணீரினால் தங்களைக் கழுவவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","அவர்கள் சாகாதபடி தங்களுடைய கைகளையும் தங்களுடைய கால்களையும் கழுவவேண்டும்; இது தலைமுறைதோறும் அவனுக்கும் அவனுடைய சந்ததியார்களுக்கும் நிரந்தர கட்டளையாக இருக்கும் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“மேன்மையான நறுமணப்பொருட்களாகிய சுத்தமான வெள்ளைப்போளத்தில் பரிசுத்த இடத்தின் சேக்கலின்படி ஐந்நூறு சேக்கல் எடையையும், நறுமணப்பட்டையிலே அதில் பாதியாகிய இருநூற்று ஐம்பது சேக்கல் எடையையும், சுகந்த வசம்பில் இருநூற்று ஐம்பது சேக்கல் எடையையும், ");
INSERT INTO tam2017_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","இலவங்கப்பட்டையில் ஐந்நூறு சேக்கல் எடையையும், ஒலிவ எண்ணெயில் ஒரு குடம் எண்ணெயையும் எடுத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","அதினால், பரிமளத்தைலக்காரன் செய்வதுபோல, கூட்டப்பட்ட பரிமளத்தைலமாகிய சுத்தமான அபிஷேக தைலத்தை உண்டாக்கு; அது பரிசுத்த அபிஷேக தைலமாக இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","அதினாலே ஆசரிப்புக்கூடாரத்தையும், சாட்சிப்பெட்டியையும், ");
INSERT INTO tam2017_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","மேஜையையும், அதின் பணிப்பொருட்கள் எல்லாவற்றையும், குத்துவிளக்கையும், அதின் கருவிகளையும், தூப பீடத்தையும், ");
INSERT INTO tam2017_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","தகன பலிபீடத்தையும் அதின் பணிப்பொருட்கள் எல்லாவற்றையும், தொட்டியையும், அதின் பாதத்தையும் அபிஷேகம்செய்து, ");
INSERT INTO tam2017_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","அவைகள் மகா பரிசுத்தமாக இருக்கும்படி, அவைகளைப் பரிசுத்தப்படுத்தவேண்டும்; அவைகளைத் தொடுகிறதெல்லாம் பரிசுத்தமாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","ஆரோனும் அவனுடைய மகன்களும் எனக்கு ஆசாரிய ஊழியம் செய்யும்படி, நீ அவர்களை அபிஷேகம்செய்து, அவர்களைப் பரிசுத்தப்படுத்தவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","இஸ்ரவேலர்களுடன் நீ பேசிச் சொல்லவேண்டியது: உங்களுடைய தலைமுறைதோறும் இது எனக்குரிய பரிசுத்த அபிஷேகத் தைலமாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","இது மனிதர்களுடைய சரீரத்தின்மேல் ஊற்றப்படக்கூடாது; இது செய்யப்பட்ட முறையின்படி அவர்கள் வேறொரு தைலத்தைச் செய்யவும்கூடாது; இது பரிசுத்தமானது, இது உங்களுக்குப் பரிசுத்தமாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","இந்த முறையின்படியே தைலங்கூட்டுகிறவனும், அதில் எடுத்து அந்நியன்மேல் ஊற்றுகிறவனும், தன்னுடைய மக்களில் இராதபடி அறுப்புண்டுபோகவேண்டும் என்று சொல் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","“பின்னும் யெகோவா மோசேயை நோக்கி: சுத்த வெள்ளைப்போளமும் குங்கிலியமும் அல்பான் பிசினுமாகிய கந்தவர்க்கங்களையும் சுத்தமான சாம்பிராணியையும் நீ சமஎடையாக எடுத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","தைலக்காரன் செய்கிறதுபோல அதற்குப் பரிமளமேற்றி, தூய்மையான பரிசுத்த தூபவர்க்கமாக்கி, ");
INSERT INTO tam2017_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","அதில் கொஞ்சம் எடுத்துப் பொடியாக இடித்து, நான் உன்னைச் சந்திக்கும் ஆசரிப்புக்கூடாரத்திலிருக்கும் சாட்சி சந்நிதியில் வைக்கவேண்டும்; அது உங்களுக்கு மகா பரிசுத்தமாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","இந்தத் தூபவர்க்கத்தை நீ செய்யவேண்டிய முறையின்படி உங்களுக்காகச் செய்துகொள்ளக்கூடாது; இது யேகோவாக்கென்று உனக்குப் பரிசுத்தமாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","இதற்கு ஒப்பானதை முகருகிறதற்காகச் செய்கிறவன் தன்னுடைய மக்களில் இல்லாதபடி துண்டிக்கப்படவேண்டும் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“நான் யூதாவின் கோத்திரத்தில் ஊருடைய மகனான ஊரியின் மகன் பெசலெயேலைப் பெயர்சொல்லி அழைத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","வித்தியாசமான வேலைகளை அவன் யோசித்துச் செய்கிறதற்கும், பொன்னிலும் வெள்ளியிலும் வெண்கலத்திலும் வேலைசெய்வதற்கும், ");
INSERT INTO tam2017_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","இரத்தினங்களை முத்திரைவெட்டாக வெட்டிப் பதிக்கிறதற்கும், மரத்தில் அலங்காரவேலைகளைச் செய்வதற்கும், ");
INSERT INTO tam2017_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","மற்றும் எல்லாவித வேலைகளையும் யூகித்துச் செய்வதற்கும் வேண்டிய ஞானமும், புத்தியும், அறிவும் அவனுக்கு உண்டாக, அவனை தேவஆவியினால் நிரப்பினேன். ");
INSERT INTO tam2017_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","மேலும், தாண் கோத்திரத்திலுள்ள அகிசாமாகின் மகனாகிய அகோலியாபையும் அவனுடன் துணையாகக் கூட்டினதுமட்டுமல்லாமல், ஞான இருதயமுள்ள யாவருடைய இருதயத்திலும் ஞானத்தை அருளினேன்; நான் உனக்குக் கட்டளையிட்ட எல்லாவற்றையும் அவர்கள் செய்வார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","ஆசரிப்புக்கூடாரத்தையும் சாட்சிப்பெட்டியையும் அதின்மேலுள்ள கிருபாசனத்தையும், கூடாரத்திலுள்ள எல்லா பணிப்பொருட்களையும், ");
INSERT INTO tam2017_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","மேஜையையும் அதின் பணிப்பொருட்களையும், சுத்தமான குத்துவிளக்கையும் அதின் எல்லா கருவிகளையும், தூபபீடத்தையும், ");
INSERT INTO tam2017_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","தகனபலிபீடத்தையும் அதின் எல்லா பணிப்பொருட்களையும், தொட்டியையும் அதின் பாதத்தையும், ");
INSERT INTO tam2017_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ஆராதனை ஆடைகளையும், ஆசாரிய ஊழியம் செய்வதற்கான ஆசாரியனாகிய ஆரோனின் பரிசுத்த ஆடைகளையும், அவனுடைய மகன்களின் ஆடைகளையும், ");
INSERT INTO tam2017_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","அபிஷேக தைலத்தையும், பரிசுத்த ஸ்தலத்திற்கு வாசனைப்பொருட்களாகிய தூபவர்க்கத்தையும், நான் உனக்குக் கட்டளையிட்டபடி, அவர்கள் செய்யவேண்டும் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","மேலும், யெகோவா மோசேயிடம்: ");
INSERT INTO tam2017_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“நீ இஸ்ரவேலர்களை நோக்கி, நீங்கள் என்னுடைய ஓய்வுநாட்களை அனுசரிக்க வேண்டும்; உங்களைப் பரிசுத்தப்படுத்துகிற யெகோவா நான் என்பதை நீங்கள் அறியும்படி, இது உங்கள் தலைமுறைதோறும் எனக்கும் உங்களுக்கும் அடையாளமாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","ஆகையால், ஓய்வுநாளை அனுசரிக்க வேண்டும்; அது உங்களுக்குப் பரிசுத்தமானது; அதின் பரிசுத்தத்தை கெடுக்கிறவன் கொலைசெய்யப்படவேண்டும்; அந்த நாளிலே வேலைசெய்கிற எந்த ஆத்துமாவும் தன்னுடைய மக்களின் நடுவில் இல்லாதபடி துண்டிக்கப்பட்டுபோவான். ");
INSERT INTO tam2017_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ஆறுநாட்களும் வேலைசெய்யலாம்; ஏழாம் நாளோ வேலை செய்யாமல் ஓய்ந்திருக்கும் ஓய்வுநாள்; அது யெகோவாவுக்குப் பரிசுத்தமானது; ஓய்வுநாளில் வேலைசெய்கிறவன் எவனும் கொலைசெய்யப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","ஆகையால், இஸ்ரவேலர்கள் தங்களுடைய தலைமுறைதோறும் ஓய்வுநாளை நித்திய உடன்படிக்கையாக அனுசரிக்கும்படி, அதைக் கைக்கொள்ளவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","அது என்றைக்கும் எனக்கும் இஸ்ரவேலர்களுக்கும் அடையாளமாக இருக்கும்; ஆறுநாட்களுக்குள்ளே யெகோவா வானத்தையும் பூமியையும் உண்டாக்கி, ஏழாம் நாளிலே வேலைகளை முடித்து ஓய்ந்திருந்தார் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","சீனாய்மலையில் அவர் மோசேயோடு பேசி முடிந்தபின்பு, தேவனுடைய விரலினால் எழுதப்பட்ட கற்பலகைகளாகிய இரண்டு சாட்சி பலகைகளை அவனிடம் கொடுத்தார். ");
INSERT INTO tam2017_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","மோசே மலையிலிருந்து இறங்கிவரத் தாமதிக்கிறதை மக்கள் கண்டபோது, அவர்கள் ஆரோனிடம் கூட்டம்கூடி. அவனை நோக்கி: “எகிப்துதேசத்திலிருந்து எங்களை அழைத்துக்கொண்டு வந்த அந்த மோசேக்கு என்ன நடந்ததோ அறியோம்; ஆதலால் நீர் எழுந்து எங்களுக்கு முன்னேசெல்லும் தெய்வங்களை எங்களுக்காக உண்டாக்கும்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","அதற்கு ஆரோன்: “உங்களுடைய மனைவிகள், மகன்கள் மற்றும் மகள்களுடைய காதுகளில் இருக்கிற தங்க ஆபரணங்களை கழற்றி, என்னிடம் கொண்டுவாருங்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","மக்கள் எல்லோரும் தங்களுடைய காதுகளில் இருந்த ஆபரணங்களைக் கழற்றி, ஆரோனிடம் கொண்டுவந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","அவர்களுடைய கையிலிருந்து அவன் அந்தப் தங்கங்களை வாங்கி, சிற்பக்கருவியைக் கூர்மையாக்கி, ஒரு கன்றுக்குட்டியை வார்ப்பித்தான். அப்பொழுது அவர்கள்: “இஸ்ரவேலர்களே, உங்களை எகிப்துதேசத்திலிருந்து அழைத்துக்கொண்டுவந்த உங்களுடைய தெய்வங்கள் இவைகளே” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","ஆரோன் அதைப் பார்த்து, அதற்கு முன்பாக ஒரு பலிபீடத்தைக் கட்டி, “நாளைக்குக் யெகோவாவுக்குப் பண்டிகை” என்று கூறினான். ");
INSERT INTO tam2017_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","மறுநாள் அவர்கள் அதிகாலையில் எழுந்து, சர்வாங்கதகனபலிகளையிட்டு, சமாதானபலிகளைச் செலுத்தினார்கள்; பின்பு, மக்கள் சாப்பிடவும், குடிக்கவும் உட்கார்ந்து, விளையாட எழுந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","அப்பொழுது யெகோவா மோசேயை நோக்கி: “நீ இறங்கிப்போ; எகிப்துதேசத்திலிருந்து நீ நடத்திக்கொண்டுவந்த உன்னுடைய மக்கள் தங்களைக் கெடுத்துக்கொண்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","அவர்களுக்கு நான் விதித்த வழியை அவர்கள் சீக்கிரமாக விட்டு விலகினார்கள்; அவர்கள் தங்களுக்கு ஒரு கன்றுக்குட்டியை வார்ப்பித்து, அதைப் பணிந்துகொண்டு, அதற்குப் பலியிட்டு: இஸ்ரவேலர்களே உங்களை எகிப்துதேசத்திலிருந்து அழைத்துக்கொண்டுவந்த உங்களுடைய தெய்வங்கள் இவைகளே என்று சொன்னார்கள்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","பின்னும் யெகோவா மோசேயை நோக்கி: “இந்த மக்களைப் பார்த்தேன்; இவர்கள் பிடிவாதமுள்ள மக்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","ஆகையால் என்னுடைய கோபம் இவர்கள்மேல் வரவும், நான் இவர்களை அழித்துப்போடவும் நீ என்னை விட்டுவிடு; உன்னை ஒரு பெரிய தேசமாக்குவேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","மோசே தன்னுடைய தேவனாகிய யெகோவாவை நோக்கி: “யெகோவாவே, தேவரீர் மகா பெலத்தினாலும் வல்லமையுள்ள கையினாலும் எகிப்து தேசத்திலிருந்து புறப்படச்செய்த உம்முடைய மக்களுக்கு விரோதமாக உம்முடைய கோபம் பற்றியெரிவது ஏன்? ");
INSERT INTO tam2017_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","மலைகளில் அவர்களைக் கொன்றுபோடவும், பூமியின்மேல் இல்லாதபடி அவர்களை அழிக்கவும், அவர்களுக்குத் தீங்குசெய்வதற்காகவே அவர்களைப் புறப்படச்செய்தார் என்று எகிப்தியர்கள் சொல்லுவானேன்? உம்முடைய கடுங்கோபத்தைவிட்டுத் திரும்பி, உமது மக்களுக்குத் தீங்குசெய்யாதபடி, அவர்கள்மேல் பரிதாபம்கொள்ளும். ");
INSERT INTO tam2017_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","உமது ஊழியக்காரர்களாகிய ஆபிரகாமையும், ஈசாக்கையும், இஸ்ரவேலையும் நினைத்தருளும்: உங்களுடைய சந்ததியை வானத்து நட்சத்திரங்களைப்போலப் பெருகச்செய்து, நான் சொன்ன இந்த தேசம் முழுவதையும் உங்கள் சந்ததியார்கள் என்றைக்கும் சுதந்தரித்துக்கொள்ளும்படி, அவர்களுக்குக் கொடுப்பேன் என்று உம்மைக்கொண்டு அவர்களுக்கு ஆணையிட்டுச் சொன்னீரே” என்று கெஞ்சிப் பிரார்த்தனை செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","அப்பொழுது யெகோவா தமது மக்களுக்குச் செய்ய நினைத்த தீங்கைச்செய்யாதபடி பரிதாபங்கொண்டார். ");
INSERT INTO tam2017_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","பின்பு மோசே மலையிலிருந்து இறங்கினான்; சாட்சிப்பலகைகள் இரண்டும் அவனுடைய கையில் இருந்தது; அந்தப் பலகைகள் இருபுறமும் எழுதப்பட்டிருந்தது, அவைகள் இந்தப்பக்கத்திலும் அந்தப்பக்கத்திலும் எழுதப்பட்டிருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","அந்தப் பலகைகள் தேவனால் செய்யப்பட்டதாகவும், அவைகளிலே பதிந்த எழுத்து தேவனால் எழுதப்பட்ட எழுத்தாகவும் இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","மக்கள் ஆரவாரம் செய்கிறதை யோசுவா கேட்டு, மோசேயை நோக்கி: “முகாமில் யுத்தத்தின் இரைச்சல் உண்டாயிருக்கிறது” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","அதற்கு மோசே: “அது வெற்றியின் சத்தமும் அல்ல, தோல்வியின் சத்தமும் அல்ல; பாடலின் சத்தம் எனக்குக் கேட்கிறது” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","அவன் முகாமிற்கு அருகே, அந்தக் கன்றுக்குட்டியையும் நடனத்தையும் கண்டபோது, மோசே கோபமடைந்தவனாய், தன்னுடைய கையிலே இருந்த பலகைகளை மலையின் அடியிலே வீசி உடைத்துப்போட்டு; ");
INSERT INTO tam2017_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","அவர்கள் உண்டாக்கின கன்றுக்குட்டியை எடுத்து, அக்கினியில் சுட்டெரித்து, அதைப் பொடியாக அரைத்து, தண்ணீரின்மேல் தூவி, அதை இஸ்ரவேல் மக்கள் குடிக்கும்படி செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","பின்பு, மோசே ஆரோனை நோக்கி: “நீ இந்த மக்கள்மேல் இந்தப் பெரிய பாவத்தைச் சுமத்துகிறதற்கு, இவர்கள் உனக்கு என்ன செய்தார்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","அதற்கு ஆரோன்: “என்னுடைய ஆண்டவனுக்குக் கோபம் வராமல் இருப்பதாக; இது பொல்லாத மக்கள் என்று நீர் அறிந்திருக்கிறீர். ");
INSERT INTO tam2017_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","இவர்கள் என்னை நோக்கி: எங்களுக்கு முன்னேசெல்லும் தெய்வங்களை எங்களுக்கு உண்டாக்கும்; எகிப்து தேசத்திலிருந்து எங்களை அழைத்துக்கொண்டுவந்த அந்த மோசேக்கு என்ன நடந்ததோ அறியோம்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","அப்பொழுது நான்: தங்கங்களை உடையவர்கள் எவர்களோ அவர்கள் அதைக் கழற்றித் தரவேண்டும் என்றேன்; அவர்கள் அப்படியே செய்தார்கள்; அதை அக்கினியிலே போட்டேன், அதிலிருந்து இந்தக் கன்றுக்குட்டி வந்தது என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","மக்கள் தங்களுடைய எதிரிகளுக்குள் அவமானப்படத்தக்கதாக ஆரோன் அவர்களை நிர்வாணமாக்கியிருந்தான். அவர்கள் நிர்வாணமாக இருக்கிறதை மோசே கண்டு, ");
INSERT INTO tam2017_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","முகாமின் வாசலில் நின்று: “யெகோவாவின் பக்கம் இருக்கிறவர்கள் யார்? அவர்கள் என்னிடம் சேரவேண்டும்” என்றான். அப்பொழுது லேவியர்கள் எல்லோரும் அவனிடம் கூடிவந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","அவன் அவர்களை நோக்கி: “உங்களில் ஒவ்வொருவனும் தன்னுடைய பட்டயத்தைத் தன்னுடைய இடுப்பிலே கட்டிக்கொண்டு, முகாமெங்கும் உள்ளும் வெளியும் வாசலுக்கு வாசல் போய், ஒவ்வொருவனும் தன் தன் சகோதரனையும், ஒவ்வொருவனும் தன் தன் நண்பர்களையும், ஒவ்வொருவனும் தன் தன் அயலானையும் கொன்றுபோடவேண்டும் என்று இஸ்ரவேலின் தேவனாகிய யெகோவா சொல்லுகிறார்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","லேவியர்கள் மோசே சொன்னபடியே செய்தார்கள்; அந்தநாளில் மக்களில் ஏறக்குறைய 3,000 பேர் இறந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","“யெகோவா இன்றைக்கு உங்களுக்கு ஆசீர்வாதம் அளிக்கும்படி, இன்றைக்கு நீங்கள் அவனவன் தன் தன் மகனுக்கும் சகோதரனுக்கும் விரோதமாக இருக்கிறதினால், யெகோவாவுக்கு உங்களைப் பிரதிஷ்டைசெய்யுங்கள்” என்று மோசே சொல்லியிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","மறுநாளில் மோசே மக்களை நோக்கி: “நீங்கள் மகா பெரிய பாவம் செய்தீர்கள்; உங்களுக்காகப் பாவநிவிர்த்தி செய்யக்கூடுமோ என்று அறிய இப்பொழுது நான் யெகோவாவினிடத்திற்கு ஏறிப்போகிறேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","அப்படியே மோசே யெகோவாவிடத்திற்குத் திரும்பிப்போய்: “ஐயோ, இந்த மக்கள் தங்கத்தினால் தங்களுக்குத் தெய்வங்களை உண்டாக்கி, மகா பெரியபாவம் செய்திருக்கிறார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ஆகிலும், தேவரீர் அவர்களுடைய பாவத்தை மன்னித்தருளுவீரானால் மன்னித்தருளும்; இல்லாவிட்டால் நீர் எழுதின உம்முடைய புத்தகத்திலிருந்து என்னுடைய பெயரைக் கிறுக்கிப்போடும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","அப்பொழுது யெகோவா மோசேயை நோக்கி: “எனக்கு விரோதமாகப் பாவம் செய்தவன் எவனோ, அவனுடைய பெயரை என்னுடைய புத்தகத்திலிருந்து கிறுக்கிப்போடுவேன். ");
INSERT INTO tam2017_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","இப்பொழுது நீ போய், நான் உனக்குச் சொன்ன இடத்திற்கு மக்களை அழைத்துக்கொண்டுபோ; என்னுடைய தூதனானவர் உனக்குமுன்பு செல்லுவார்; ஆகிலும், நான் விசாரிக்கும் நாளில் அவர்களுடைய பாவத்தை அவர்களிடத்தில் விசாரிப்பேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","ஆரோன் செய்த கன்றுக்குட்டியை மக்கள் செய்யவைத்ததால் யெகோவா அவர்களை வாதித்தார். ");
INSERT INTO tam2017_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","யெகோவா மோசேயை நோக்கி: “நீயும், எகிப்து தேசத்திலிருந்து நீ அழைத்துக்கொண்டு வந்த மக்களும் இந்த இடத்தைவிட்டுப் புறப்பட்டு. உன்னுடைய சந்ததிக்குக் கொடுப்பேன் என்று நான் ஆபிரகாமுக்கும், ஈசாக்குக்கும், யாக்கோபுக்கும் ஆணையிட்டுக்கொடுத்த செழிப்பான தேசத்திற்குப் போங்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","நான் ஒரு தூதனை உங்களுக்கு முன்பாக அனுப்பி, கானானியர்களையும், எமோரியர்களையும், ஏத்தியர்களையும், பெரிசியர்களையும் ஏவியர்களையும், எபூசியர்களையும் துரத்திவிடுவேன். ");
INSERT INTO tam2017_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","ஆனாலும், வழியிலே நான் உங்களை அழிக்காதபடி, நான் உங்களிடம் வரமாட்டேன், நீங்கள் பிடிவாதமுள்ள மக்கள்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","துக்கமான இவ்வார்த்தைகளை மக்கள் கேட்டபோது, ஒருவரும் தங்களுடைய ஆபரணங்களைப் போட்டுக்கொள்ளாமல் துக்கித்துக்கொண்டிருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","ஏனென்றால், “நீங்கள் பிடிவாதமுள்ள மக்கள், நான் ஒரு நிமிடத்தில் உங்கள் நடுவில் எழும்பி, உங்களை அழிப்பேன்; ஆகையால், நீங்கள் போட்டிருக்கிற உங்கள் ஆபரணங்களைக் கழற்றிப்போடுங்கள்; அப்பொழுது நான் உங்களுக்குச் செய்யவேண்டியதைக்குறித்துத் தீர்மானிப்பேன் என்று இஸ்ரவேலர்களுக்குச் சொல்” என்று யெகோவா மோசேயோடு சொல்லியிருந்தார். ");
INSERT INTO tam2017_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","ஆகையால், இஸ்ரவேலர்கள் ஓரேப் மலை அருகே தங்களுடைய ஆபரணங்களைக் கழற்றிப்போட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","மோசே கூடாரத்தை பெயர்த்து, அதை முகாமிற்கு வெளியே தூரத்திலே போட்டு, அதற்கு ஆசரிப்புக்கூடாரம் என்று பெயரிட்டான். யெகோவாவைத் தேடும் யாவரும் முகாமிற்குத் தூரமான கூடாரத்திற்குப் போவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","மோசே கூடாரத்திற்குப் போகும்போது, மக்கள் எல்லோரும் எழுந்து, தங்கள் தங்கள் கூடாரவாசலில் நின்றுகொண்டு, அவன் கூடாரத்திற்குள் நுழையும்வரை, அவனை பார்த்துக்கொண்டிருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","மோசே கூடாரத்திற்குள் நுழையும்போது, மேகமண்டலம் இறங்கி, கூடாரவாசலில் நின்றது; யெகோவா மோசேயோடு பேசினார். ");
INSERT INTO tam2017_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","மக்கள் எல்லோரும் மேகமண்டலம் கூடாரவாசலில் நிற்பதைப் பார்த்தார்கள்; மக்கள் எல்லோரும் எழுந்திருந்து, தங்கள் தங்கள் கூடாரவாசலில் பணிந்துகொண்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","ஒருவன் தன்னுடைய நண்பனோடு பேசுவதுபோல, யெகோவா மோசேயோடு முகமுகமாகப் பேசினார்; பின்பு, அவன் முகாமிற்குத் திரும்பினான்; நூனின் மகனாகிய யோசுவா என்னும் அவனுடைய பணிவிடைக்காரனாகிய வாலிபன் ஆசரிப்புக்கூடாரத்தைவிட்டுப் போகாமல் இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","மோசே யெகோவாவை நோக்கி: “தேவரீர் இந்த மக்களை அழைத்துக்கொண்டுபோ என்று சொன்னீர்; ஆகிலும், என்னோடுகூட இன்னாரை அனுப்புவேன் என்பதை எனக்கு நீர் அறிவிக்கவில்லை; என்றாலும், உன்னைப் பெயர்சொல்லி அழைத்து அறிந்திருக்கிறேன் என்றும், என்னுடைய கண்களில் உனக்குக் கிருபை கிடைத்தது என்றும், தேவரீர் சொன்னதுண்டு; ");
INSERT INTO tam2017_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","உம்முடைய கண்களில் இப்பொழுது எனக்குக் கிருபை கிடைத்ததானால் நான் உம்மை அறிவதற்கும், உம்முடைய கண்களில் எனக்குக் கிருபை கிடைப்பதற்கும், உம்முடைய வழியை எனக்கு அறிவியும்; இந்த தேசம் உம்முடைய மக்களென்று நினைத்தருளும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","அதற்கு அவர்: “என்னுடைய சமுகம் உனக்கு முன்பாகச் செல்லும், நான் உனக்கு இளைப்பாறுதல் தருவேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","அப்பொழுது அவன் அவரை நோக்கி: “உம்முடைய சமுகம் என்னோடு வராமற்போனால், எங்களை இந்த இடத்திலிருந்து கொண்டுபோகாமல் இரும். ");
INSERT INTO tam2017_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","எனக்கும் உமது மக்களுக்கும் உம்முடைய கண்களிலே கிருபை கிடைத்ததென்பது எதினால் தெரியவரும்; நீர் எங்களுடன் வருவதினால் அல்லவா? இப்படியே பூமியின்மேலுள்ள மக்கள் எல்லோரையும்விட, நானும் உம்முடைய மக்களும் விசேஷித்தவர்கள் என்று விளங்கும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","அப்பொழுது யெகோவா மோசேயை நோக்கி: “நீ சொன்ன இந்த வார்த்தையின்படி செய்வேன்; என்னுடைய கண்களில் உனக்குக் கிருபை கிடைத்தது; உன்னைப் பெயர்சொல்லி அழைத்து அறிந்திருக்கிறேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","அப்பொழுது அவன்: “உம்முடைய மகிமையை எனக்குக் காண்பித்தருளும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","அதற்கு அவர்: “என்னுடைய எல்லா தயவையும் நான் உனக்கு முன்பாகக் கடந்துபோகச்செய்து, யெகோவாவுடைய நாமத்தை உனக்கு முன்பாகக்கூறுவேன்; எவன்மேல் கிருபையாக இருக்க விருப்பமாக இருப்பேனோ, அவன்மேல் கிருபையாக இருப்பேன்; எவன்மேல் இரக்கமாக இருக்க விருப்பமாக இருப்பேனோ, அவன்மேல் இரக்கமாக இருப்பேன் என்று சொல்லி, ");
INSERT INTO tam2017_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","நீ என்னுடைய முகத்தைக் காணமாட்டாய், ஒரு மனிதனும் என்னைக் கண்டு உயிரோடிருக்கமுடியாது” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","பின்னும் யெகோவா: “இதோ, என் அருகில் ஒரு இடம் உண்டு; நீ அங்கே கன்மலையில் நில்லு. ");
INSERT INTO tam2017_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","என்னுடைய மகிமை கடந்துபோகும்போது, நான் உன்னை அந்தக் கன்மலையின் வெடிப்பிலே வைத்து, நான் கடந்துபோகும்வரை என்னுடைய கரத்தினால் உன்னை மூடுவேன்; ");
INSERT INTO tam2017_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","பின்பு, என்னுடைய கரத்தை எடுப்பேன்; அப்பொழுது என்னுடைய பின்பக்கத்தைக் காண்பாய்; என்னுடைய முகமோ காணப்படாது” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","யெகோவா மோசேயை நோக்கி: “முந்தினக் கற்பலகைகளை போன்ற இரண்டு கற்பலகைகளை இழைத்துக்கொள்; நீ உடைத்துப்போட்ட முந்தின பலகைகளில் இருந்த வார்த்தைகளை அவைகளில் எழுதுவேன். ");
INSERT INTO tam2017_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","அதிகாலையில் நீ ஆயத்தமாகி, சீனாய் மலையில் ஏறி, அங்கே மலையின் மேல் காலையில் என்னுடைய சமுகத்தில் வந்து நில். ");
INSERT INTO tam2017_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","உன்னோடு ஒருவனும் அங்கே வரக்கூடாது; மலையில் எங்கும் ஒருவனும் காணப்படவும்கூடாது; இந்த மலையின் அருகில் ஆடுமாடு மேயவும்கூடாது” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","அப்பொழுது மோசே முந்தின கற்பலகைகளைப் போன்ற இரண்டு கற்பலகைகளை இழைத்து, அதிகாலையில் எழுந்து, யெகோவா தனக்குக் கட்டளையிட்டபடியே அந்த இரண்டு கற்பலகைகளையும் தன்னுடைய கையிலே எடுத்துக்கொண்டு, சீனாய் மலையில் ஏறினான். ");
INSERT INTO tam2017_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","யெகோவா ஒரு மேகத்தில் இறங்கி, அங்கே அவன் அருகே நின்று, யெகோவாவுடைய நாமத்தைக் கூறினார். ");
INSERT INTO tam2017_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","யெகோவா அவனுக்கு முன்பாக கடந்துபோகிறபோது, அவர்: “யெகோவா, யெகோவா; இரக்கமும், கிருபையும், நீடிய சாந்தமும், மகா தயவும், சத்தியமுள்ள தேவன். ");
INSERT INTO tam2017_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ஆயிரம் தலைமுறைகளுக்கு இரக்கத்தைக் காக்கிறவர்; அக்கிரமத்தையும், மீறுதலையும், பாவத்தையும் மன்னிக்கிறவர்; குற்றவாளியைக் குற்றம் இல்லாதவனாக விடாமல், தகப்பன்மார்கள் செய்த அக்கிரமத்தைப் பிள்ளைகளிடத்திலும், பிள்ளைகளுடைய பிள்ளைகளிடத்திலும் மூன்றாம் நான்காம் தலைமுறைவரை தண்டிக்கிறவர்” என்று கூறினார். ");
INSERT INTO tam2017_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","மோசே உடனே தரைவரைக்கும் குனிந்து பணிந்துகொண்டு: ");
INSERT INTO tam2017_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“ஆண்டவரே, உம்முடைய கண்களில் எனக்குக் கிருபை கிடைத்ததானால், எங்கள் நடுவில் ஆண்டவர் எழுந்தருளவேண்டும்; இந்த மக்கள் பிடிவாதமுள்ளவர்கள்; நீரோ, எங்களுடைய அக்கிரமத்தையும் எங்களுடைய பாவத்தையும் மன்னித்து, எங்களை உமக்குச் சுதந்திரமாக ஏற்றுக்கொள்ளும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","அதற்கு அவர்: “இதோ, நான் ஒரு உடன்படிக்கை செய்கிறேன்; பூமியெங்கும் எந்த தேசங்களிடத்திலும் செய்யப்படாத அதிசயங்களை உன்னுடைய மக்கள் எல்லோருக்கும் முன்பாகவும் செய்வேன்; உன்னோடு இருக்கிற மக்கள் எல்லோரும் யெகோவாவுடைய செயல்களைக் காண்பார்கள்; உன்னோடு இருந்து, நான் செய்யும் காரியம் பயங்கரமாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","இன்று நான் உனக்குக் கட்டளையிடுகிறதைக் கைக்கொள்; எமோரியர்களையும், கானானியர்களையும், ஏத்தியர்களையும், பெரிசியர்களையும், ஏவியர்களையும், எபூசியர்களையும் உனக்கு முன்பாகத் துரத்திவிடுகிறேன். ");
INSERT INTO tam2017_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","நீ போய்ச் சேருகிற தேசத்தின் குடிகளோடு உடன்படிக்கை செய்யாதபடி எச்சரிக்கையாக இரு; செய்தால் அது உன்னுடைய நடுவில் கண்ணியாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","அவர்களுடைய பலிபீடங்களை இடித்து, சிலைகளைத் தகர்த்து, தோப்புகளை வெட்டிப்போடுங்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","யெகோவாவுடைய நாமம் எரிச்சலுள்ளவர் என்பது, அவர் எரிச்சலுள்ள தேவன்; ஆகையால், அந்நிய தேவனை நீ பணிந்துகொள்ளவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","அந்த தேசத்தின் குடிகளோடு உடன்படிக்கை செய்வாயானால், அவர்கள் தங்களுடைய தெய்வங்களைப் பின்பற்றி, விபசாரம் செய்வார்கள், தங்களுடைய தெய்வங்களுக்குப் பலியிடுவார்கள்; ஒருவன் உன்னை அழைக்கும்போது, நீ போய், அவனுடைய பலி செலுத்தியதில் சாப்பிடுவாய்; ");
INSERT INTO tam2017_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","அவர்கள் மகள்களில் உன்னுடைய மகன்களுக்கு பெண்களை எடுப்பாய்; அவர்கள் மகள்கள் தங்களுடைய தெய்வங்களை விபசார மார்க்கமாகப் பின்பற்றுவதும் இல்லாமல், உன்னுடைய மகன்களையும் தங்களுடைய தெய்வங்களை விபசார மார்க்கமாகப் பின்பற்றும்படி செய்வார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","வார்ப்பிக்கப்பட்ட தெய்வங்களை உங்களுக்கு உண்டாக்கவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","புளிப்பில்லாத அப்பப்பண்டிகையை நீங்கள் கைக்கொண்டு, நான் உங்களுக்குக் கட்டளையிட்டபடியே, ஆபீப் மாதத்தில் குறித்த காலத்தில் ஏழுநாட்கள் புளிப்பில்லாத அப்பம் சாப்பிடுவீர்கள்; ஆபீப் மாதத்தில் எகிப்திலிருந்து புறப்பட்டாயே. ");
INSERT INTO tam2017_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","கர்ப்பம்திறந்து பிறக்கிற அனைத்தும், உன்னுடைய ஆடுமாடுகளின் முதற்பிறப்பான ஆண்கள் யாவும் என்னுடையவைகள். ");
INSERT INTO tam2017_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","கழுதையின் முதற்பிறப்பை ஒரு ஆட்டுக்குட்டியால் மீட்டுக்கொள்வாயாக; அதை மீட்டுக்கொள்ளாமல் இருந்தால் அதின் கழுத்தை முறித்துப்போடு; உன்னுடைய பிள்ளைகளில் முதலில் பிறந்தவைகளையெல்லாம் மீட்டுக்கொள்ளவேண்டும். வெறுங்கையோடு என்னுடைய சந்நிதியில் ஒருவனும் வரக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","ஆறுநாட்கள் வேலைசெய்து, ஏழாம் நாளில் ஓய்ந்திரு; விதைப்புக் காலத்திலும் அறுப்புக் காலத்திலும் ஓய்ந்திரு. ");
INSERT INTO tam2017_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","கோதுமை அறுப்பின் முதற்பலனைச் செலுத்தும் ஏழு வாரங்களின் பண்டிகையையும், வருடமுடிவிலே சேர்ப்புக்கால பண்டிகையையும் அனுசரி. ");
INSERT INTO tam2017_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","வருடத்தில் மூன்றுமுறை உங்களுடைய ஆண்மக்கள் எல்லோரும் இஸ்ரவேலின் தேவனாக இருக்கிற யெகோவாகிய ஆண்டவரின் சந்நிதியில் வரவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","நான் தேசங்களை உங்களுக்கு முன்பாகத் துரத்திவிட்டு, உங்களுடைய எல்லைகளை விரிவாக்குவேன்; வருடத்தில் மூன்றுமுறை உங்களுடைய தேவனாகிய யெகோவாவுடைய சந்நிதிக்கு முன்பாக தோன்றும்போது ஒருவரும் உங்களுடைய தேசத்தின் மீது படையெடுக்க ஆசைப்படுவதில்லை. ");
INSERT INTO tam2017_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","எனக்கு செலுத்தும் பலியின் இரத்தத்தைப் புளித்தமாவுடன் செலுத்தவேண்டாம்; பஸ்கா பண்டிகையின் பலியை அதிகாலைவரை வைக்கவும் வேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","உங்களுடைய நிலத்தில் முதல் முதல் விளைந்த முதற்பலனை உங்களுடைய தேவனாகிய யெகோவாவின் ஆலயத்திற்குக் கொண்டுவாருங்கள். வெள்ளாட்டுக்குட்டியை அதினுடைய தாயின் பாலிலே சமைக்கவேண்டாம்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","பின்னும் யெகோவா மோசேயை நோக்கி: “இந்த வார்த்தைகளை நீ எழுது; இந்த வார்த்தைகளின்படி உன்னோடும் இஸ்ரவேலோடும் உடன்படிக்கை செய்தேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","அங்கே அவன் அப்பம் சாப்பிடாமலும் தண்ணீர் குடிக்காமலும் இரவும் பகலும் நாற்பதுநாட்கள் யெகோவாவோடு இருந்தான்; அவன் பத்துக்கற்பனைகளாகிய உடன்படிக்கையின் வார்த்தைகளைப் பலகைகளில் எழுதினான். ");
INSERT INTO tam2017_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","மோசே உடன்படிக்கையின் கட்டளைப் பலகைகள் இரண்டையும் தன்னுடைய கையில் எடுத்துக்கொண்டு, சீனாய் மலையிலிருந்து இறங்குகிறபோது, தன்னோடு அவர் பேசினதாலே தன்னுடைய முகம் பிரகாசமாக இருப்பதை அவன் அறியாமல் இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","ஆரோனும் இஸ்ரவேலர்கள் எல்லோரும் மோசேயைப் பார்க்கும்போது, அவன் முகம் பிரகாசமாக இருப்பதைக் கண்டு, அவன் அருகில் வரப்பயந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","மோசே அவர்களை அழைத்தான்; அப்பொழுது ஆரோனும் சபையிலுள்ள தலைவர்கள் அனைவரும் அவனிடத்திற்குத் திரும்பி வந்தார்கள்; மோசே அவர்களுடன் பேசினான். ");
INSERT INTO tam2017_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","பின்பு இஸ்ரவேல் மக்கள் எல்லோரும் அவனிடம் சேர்ந்தார்கள்; அப்பொழுது அவன் சீனாய் மலையில் யெகோவா தன்னோடு பேசினவைகளையெல்லாம் அவர்களுக்குக் கற்பித்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","மோசே அவர்களுடன் பேசி முடியும்வரை, தன்னுடைய முகத்தின்மேல் முக்காடு போட்டிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","மோசே யெகோவாவுடைய சந்நிதியில் அவரோடு பேசும்படி உள்ளே நுழைந்ததுமுதல் வெளியே புறப்படும்வரை முக்காடு போடாமல் இருந்தான்; அவன் வெளியே வந்து தனக்குக் கற்பிக்கப்பட்டதை இஸ்ரவேலர்களுடன் சொல்லும்போது, ");
INSERT INTO tam2017_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","இஸ்ரவேலர்கள் அவனுடைய முகம் பிரகாசமாக இருப்பதைக் கண்டார்கள். மோசே அவரோடு பேசும்படி உள்ளே நுழையும்வரை, முக்காட்டைத் திரும்பத் தன்னுடைய முகத்தின்மேல் போட்டுக்கொள்ளுவான். ");
INSERT INTO tam2017_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","மோசே இஸ்ரவேலர்களாகிய சபையார்கள் எல்லோரையும் கூடிவரச்செய்து, அவர்களை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","“நீங்கள் ஆறுநாட்கள் வேலைசெய்யவேண்டும், ஏழாம் நாளோ உங்களுக்குப் பரிசுத்த நாளாக இருப்பதாக; அது யெகோவாவுக்கென்று ஓய்ந்திருக்கும் ஓய்வுநாள்; அதிலே வேலைசெய்கிறவன் எவனும் கொலைசெய்யப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","ஓய்வுநாளில் உங்களுடைய வீடுகளில் நெருப்பு மூட்டாதிருங்கள் என்னும் இந்த வார்த்தைகளைக் கைக்கொள்ளும்படி யெகோவா கட்டளையிட்டார்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","பின்னும் மோசே இஸ்ரவேலர்களாகிய சபையார்கள் எல்லோரையும் நோக்கி, ");
INSERT INTO tam2017_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","“உங்களுக்கு இருப்பதிலே யெகோவாவுக்கு ஒரு காணிக்கையைக் கொண்டுவந்து செலுத்துங்கள்; மனமுள்ளவன் எவனோ, அவன் அதைக் கொண்டுவரட்டும்; யெகோவாவுக்குச் செலுத்தும் காணிக்கை என்னவென்றால், பொன்னும், வெள்ளியும், வெண்கலமும், ");
INSERT INTO tam2017_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","இளநீலநூலும், இரத்தாம்பரநூலும், சிவப்புநூலும், மெல்லிய பஞ்சுநூலும், வெள்ளாட்டு முடியும், ");
INSERT INTO tam2017_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","சிவப்பு வண்ணம் தீட்டப்பட்ட ஆட்டுக்கடாத்தோலும், மெல்லிய தோலும், சீத்திம் மரமும், ");
INSERT INTO tam2017_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","விளக்குக்கு எண்ணெயும், அபிஷேகத்தைலத்திற்கு பரிமளத்தைலமும், தூபத்திற்கு நறுமணப் பொருட்களும், ");
INSERT INTO tam2017_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ஆசாரியர்களுடைய ஏபோத்திலும் மார்ப்பதக்கத்திலும் பதிக்கவேண்டியது கோமேதகம் முதலிய இரத்தினங்களுமே. ");
INSERT INTO tam2017_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“உங்களில் ஞானஇருதயமுள்ள அனைவரும் வந்து, யெகோவா கட்டளையிட்டவைகளையெல்லாம் செய்வார்களாக. ");
INSERT INTO tam2017_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ஆசரிப்புக்கூடாரத்தையும், அதின் கூடாரத்தையும், அதின் மூடியையும், அதின் கொக்கிகளையும், அதின் பலகைகளையும், அதின் தாழ்ப்பாள்களையும், அதின் தூண்களையும், அதின் பாதங்களையும், ");
INSERT INTO tam2017_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","பெட்டியையும், அதின் தண்டுகளையும், கிருபாசனத்தையும், மறைவின் திரைச்சீலையையும், ");
INSERT INTO tam2017_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","மேஜையையும், அதின் தண்டுகளையும், அதின் எல்லாப் பணிப்பொருட்களையும், சமுகத்து அப்பங்களையும், ");
INSERT INTO tam2017_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","வெளிச்சம்கொடுக்கும் குத்துவிளக்கையும், அதின் கருவிகளையும், அதின் அகல்களையும், வெளிச்சத்திற்கு எண்ணெயையும், ");
INSERT INTO tam2017_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","தூபபீடத்தையும், அதின் தண்டுகளையும், அபிஷேகத் தைலத்தையும், நறுமணப் பொருட்களையும், ஆசரிப்புக்கூடார வாசலுக்குத் தொங்கு திரையையும், ");
INSERT INTO tam2017_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","தகனபலிபீடத்தையும், அதின் வெண்கலச் சல்லடையையும், அதின் தண்டுகளையும், அதின் எல்லா பணிப்பொருட்களையும், தொட்டியையும், அதின் பாதத்தையும், ");
INSERT INTO tam2017_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","பிராகாரத்தின் தொங்கு திரைகளையும், அதின் தூண்களையும், அதின் பாதங்களையும், பிராகாரத்து வாசலின் தொங்கு திரையையும், ");
INSERT INTO tam2017_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","கூடாரத்தின் முளைகளையும், ஆசரிப்புக்கூடாரத்தின் முளைகளையும், அவைகளின் கயிறுகளையும், ");
INSERT INTO tam2017_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","பரிசுத்த ஸ்தலத்திலே ஆராதனை செய்வதற்குரிய ஆடைகளையும், ஆசாரிய ஊழியம்செய்கிற ஆரோனின் பரிசுத்த ஆடைகளையும் அவனுடைய மகன்களின் ஆடைகளையும் அவர்கள் செய்யவேண்டும் என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","அப்பொழுது இஸ்ரவேலர்களாகிய சபையார்கள் எல்லோரும் மோசேயின் சமுகத்தைவிட்டுப் புறப்பட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","பின்பு எவர்களை அவர்களுடைய இருதயம் எழுப்பி, எவர்களை அவர்களுடைய ஆவி உற்சாகப்படுத்தினதோ, அவர்கள் எல்லோரும் ஆசரிப்புக்கூடாரத்தின் வேலைக்கும், அதின் எல்லா ஊழியத்திற்கும், பரிசுத்த ஆடைகளுக்கும் ஏற்றவைகளைக் யெகோவாவுக்குக் காணிக்கையாகக் கொண்டுவந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","மனப்பூர்வமுள்ள ஆண்கள் பெண்கள் அனைவரும், தங்கத்தினாலான ஊசிகள், காதணிகள், மோதிரங்கள், ஆரங்கள் முதலான எல்லாவித பொன் ஆபரணங்களையும் கொண்டுவந்தார்கள்; யெகோவாவுக்குக் காணிக்கை செலுத்தின ஒவ்வொருவனும் தங்கத்தைக் காணிக்கையாகச் செலுத்தினான். ");
INSERT INTO tam2017_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","இளநீலநூலையும் இரத்தாம்பரநூலையும் சிவப்புநூலையும் மெல்லிய பஞ்சுநூலையும் வெள்ளாட்டு முடியையும் சிவப்பு வண்ணம் தீட்டப்பட்ட ஆட்டுக்கடாத்தோலையும் மெல்லிய தோலையும் வைத்திருந்த எல்லோரும் அவைகளைக் கொண்டுவந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","வெள்ளியையும் வெண்கலத்தையும் கொடுக்கும் அனைவரும் அவைகளைக் யெகோவாவுக்குக் காணிக்கையாகக் கொண்டுவந்தார்கள். பற்பல வேலைகளுக்கு உதவும் சீத்திம் மரத்தை வைத்திருந்த யாவரும் அவைகளைக் கொண்டுவந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","ஞான இருதயமுள்ள பெண்கள் எல்லோரும் தங்கள் கைகளினால் பிண்ணி, தாங்கள் பிண்ணின இளநீலநூலையும் இரத்தாம்பரநூலையும் சிவப்புநூலையும் மெல்லிய பஞ்சுநூலையும் கொண்டுவந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","எந்த பெண்களுடைய இருதயம் ஞான எழுப்புதல் அடைந்ததோ, அவர்கள் எல்லோரும் வெள்ளாட்டு முடியைத் திரித்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","தலைவர்கள் ஏபோத்திலும் மார்ப்பதக்கத்திலும் பதிக்கும் கோமேதகம் முதலிய இரத்தினங்களையும், ");
INSERT INTO tam2017_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","நறுமணப் பொருட்களையும், விளக்கெண்ணெயையும், அபிஷேகத் தைலத்திற்கும் வாசனை தூபத்திற்கும் வேண்டியவைகளையும் கொண்டுவந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","செய்யப்படும்படி யெகோவா மோசேயைக்கொண்டு கற்பித்த வேலைக்குரிய யாவையும் கொண்டுவர, இஸ்ரவேலர்களுக்குள் தங்களுடைய இருதயத்தில் உற்சாகமடைந்த ஆண்கள் பெண்கள் அனைவரும் யெகோவாவுக்குக் காணிக்கையை மனப்பூர்வமாக கொண்டுவந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","பின்பு மோசே இஸ்ரவேலர்களை நோக்கி: “பாருங்கள், யெகோவா யூதாவின் கோத்திரத்தில் ஊரின் மகனான ஊரியின் மகன் பெசலெயேலைப் பெயர்சொல்லி அழைத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","அவன் மிகுந்த விசித்திரமான வேலைகளை யோசித்துச் செய்யவும், தங்கத்திலும் வெள்ளியிலும் வெண்கலத்திலும் வேலை செய்யவும், ");
INSERT INTO tam2017_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","இரத்தினங்களை முத்திரை வெட்டாக வெட்டிப் பதிக்கவும், மரத்தில் சித்திரவேலை செய்து எல்லா வித்தியாசமான வேலைகளைச் செய்யவும், ");
INSERT INTO tam2017_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","அவனுக்கு ஞானத்தையும் புத்தியையும் அறிவையும் அருளி, அவன் எல்லாவித வேலைகளையும் செய்யும்படி தேவ ஆவியினாலே அவனை நிரப்பினார். ");
INSERT INTO tam2017_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","அவனுடைய இருதயத்திலும், தாண் கோத்திரத்தின் அகிசாமாகின் மகனாகிய அகோலியாபின் இருதயத்திலும், போதிக்கும் வரத்தையும் அருளினார். ");
INSERT INTO tam2017_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","சித்திரவேலையையும் சிற்பவேலையையும், இளநீலநூலாலும் இரத்தாம்பரநூலாலும் சிவப்புநூலாலும் மெல்லிய பஞ்சுநூலாலும் செய்யப்படும் விசித்திரத் தையல் வேலையையும், எல்லா விசித்திர நெசவு வேலைகளையும் வித்தியாசமான வேலைகளை யூகிக்கிறவர்களும் செய்கிறவர்களும் நிறைவேற்றும் எல்லாவித வேலைகளையும் செய்யும்படி அவர்களுடைய இருதயத்தை ஞானத்தினால் நிரப்பினார்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","அப்பொழுது பரிசுத்த ஸ்தலத்தின் திருப்பணிகளைச் சேர்ந்த எல்லா வேலைகளையும், யெகோவா கற்பித்தபடியெல்லாம், பெசலெயேலும் அகோலியாபும், வேலை செய்யத்தெரிந்த யெகோவாவால் ஞானமும், புத்தியும் பெற்ற விவேக இருதயமுள்ள மற்ற அனைவரோடும் செய்யத்தொடங்கினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","பெசலெயேலையும், அகோலியாபையும் யெகோவாவால் ஞானமடைந்து அந்த வேலைகளைச் செய்யவரும்படி தங்களுடைய இருதயத்தில் எழுப்புதலடைந்த ஞான இருதயமுள்ளவர்களாகிய எல்லோரையும், மோசே வரவழைத்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","அவர்கள், இஸ்ரவேலர்கள் திருப்பணிகளின் எல்லா வேலைகளுக்காகவும் கொண்டுவந்த காணிக்கைப் பொருட்களையெல்லாம், மோசேயிடம் வாங்கிக்கொண்டார்கள். பின்னும் மக்கள் காலைதோறும் தங்களுக்கு விருப்பமான காணிக்கைகளை அவனிடம் கொண்டுவந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","அப்பொழுது பரிசுத்த ஸ்தலத்தின் வேலைகளைச் செய்கிற அனைவரும் அவரவர் செய்கிற வேலையின் காரியமாக வந்து, ");
INSERT INTO tam2017_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","மோசேயை நோக்கி: “யெகோவா செய்யும்படி கற்பித்த வேலைக்கு வேண்டியதற்கு அதிகமான பொருள்களை மக்கள் கொண்டுவருகிறார்கள்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","அப்பொழுது மோசே “இனி ஆண்களோ பெண்களோ பரிசுத்த ஸ்தலத்திற்கென்று காணிக்கையாக ஒரு வேலையும் செய்யவேண்டாம்” என்று முகாம் எங்கும் சொல்லும்படிக் கட்டளையிட்டான்; இப்படியாக மக்கள் கொண்டுவருகிறது நிறுத்தப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","செய்யவேண்டிய எல்லா வேலைகளுக்கும் போதுமான பொருள்கள் இருந்ததுமல்லாமல் அதிகமாகவும் இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","வேலை செய்கிறவர்களாகிய ஞான இருதயமுள்ள அனைவரும் ஆசரிப்புக்கூடாரத்தை உண்டாக்கினார்கள். அதற்குத் திரித்த மெல்லிய பஞ்சுநூலாலும் இளநீலநூலாலும் இரத்தாம்பரநூலாலும் சிவப்புநூலாலும், வித்தியாசமான நெசவுவேலையாகிய கேருபீன்களுள்ள பத்து மூடுதிரைகளைச் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","மூடுதிரை இருபத்தெட்டு முழ நீளமும் நான்கு முழ அகலமுமாக இருந்தது; மூடுதிரைகளெல்லாம் ஒரே அளவாக இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","ஐந்து மூடுதிரைகளை ஒன்றோடொன்று இணைத்து, மற்ற ஐந்து மூடுதிரைகளையும் ஒன்றோடொன்று இணைத்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","இணைக்கப்பட்ட ஒரு மூடுதிரையின் ஓரத்தில் இளநீலநூலால் ஐம்பது வளையங்களை உண்டாக்கி, அப்படியே இணைக்கப்பட்ட மற்ற மூடுதிரையின் ஓரத்திலும் உண்டாக்கினான். ");
INSERT INTO tam2017_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","வளையங்கள் ஒன்றோடொன்று இணைக்கப்பட்டவைகளாக இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","ஐம்பது பொன் கொக்கிகளையும் செய்து, அந்தக் கொக்கிகளால் மூடுதிரைகளை ஒன்றோடொன்று இணைத்துவிட்டான். இவ்விதமாக ஆசாரிப்புக்கூடாரம் ஒன்றானது. ");
INSERT INTO tam2017_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","ஆசரிப்புக்கூடாரத்தின்மேல் கூடாரமாகப் போடும்படி ஆட்டு ரோமத்தால் நெய்த பதினொரு மூடுதிரைகளையும் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","ஒவ்வொரு மூடுதிரையும் முப்பது முழ நீளமும் நான்கு முழ அகலமுமாக இருந்தது. பதினொரு மூடுதிரைகளும் ஒரே அளவாக இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","ஐந்து மூடுதிரைகளை ஒன்றாகவும், மற்ற ஆறு மூடுதிரைகளை ஒன்றாகவும் இணைத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","இணைக்கப்பட்ட ஒரு மூடுதிரையின் ஓரத்தில் ஐம்பது காதுகளையும், இணைக்கப்பட்ட மற்ற மூடுதிரையின் ஓரத்தில் ஐம்பது காதுகளையும் உண்டாக்கி, ");
INSERT INTO tam2017_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","கூடாரத்தை ஒன்றாக இணைத்துவிட, ஐம்பது வெண்கலக் கொக்கிகளையும் உண்டாக்கினான். ");
INSERT INTO tam2017_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","சிவப்பு வண்ணம் தீட்டப்பட்ட ஆட்டுக்கடாத்தோலினால் கூடாரத்திற்கு ஒரு மூடியையும் அதின்மேல் போட மெல்லிய தோலினால் ஒரு மூடியையும் உண்டாக்கினான். ");
INSERT INTO tam2017_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","ஆசரிப்புக்கூடாரத்தில் நிமிர்ந்துநிற்கும் பலகைகளையும் சீத்திம் மரத்தால் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ஒவ்வொரு பலகையும் பத்துமுழ நீளமும் ஒன்றரைமுழ அகலமுமாக இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","ஒவ்வொரு பலகைக்கும் ஒன்றுக்கொன்று சமதூரமான இரண்டு பொருந்தும் முனைகள் இருந்தது; ஆசரிப்புக்கூடாரத்தின் பலகைகளுக்கெல்லாம் இப்படியே செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","ஆசரிப்புக்கூடாரத்திற்காக செய்யப்பட்ட பலகைகளில் தெற்கே தெற்குதிசைக்கு இருபது பலகைகளை உண்டாக்கி, ");
INSERT INTO tam2017_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","அந்த இருபது பலகைகளின் கீழே வைக்கும் நாற்பது வெள்ளிப் பாதங்களையும் உண்டாக்கினான்; ஒரு பலகையின்கீழ் அதின் இரண்டு பொருந்தும் முனைகளுக்கும் இரண்டு பாதங்களையும், மற்றப் பலகையின்கீழ் அதின் இரண்டு பொருந்தும் முனைகளுக்கும் இரண்டு பாதங்களையும் செய்துவைத்து; ");
INSERT INTO tam2017_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","ஆசரிப்புக்கூடாரத்தின் மறுபக்கமாகிய வடபுறத்தில் இருபது பலகைகளையும், அவைகளுக்கு நாற்பது வெள்ளிப்பாதங்களையும் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ஒரு பலகையின்கீழ் இரண்டு பாதங்களும், மற்றப் பலகையின்கீழ் இரண்டு பாதங்களும் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","ஆசரிப்புக்கூடாரத்தின் மேற்கு பக்கத்திற்கு ஆறு பலகைகளையும், ");
INSERT INTO tam2017_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ஆசரிப்புக்கூடாரத்தின் இருபக்கங்களிலுள்ள மூலைகளுக்கு இரண்டு பலகைகளையும் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","அவைகள் கீழே இணைக்கப்பட்டிருந்தது, மேலேயும் ஒரு வளையத்தினால் இணைக்கப்பட்டிருந்தது; இரண்டு மூலைகளிலும் உள்ள அந்த இரண்டிற்கும் அப்படியே செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","அப்படியே எட்டுப் பலகைகளும், அவைகளுடைய ஒவ்வொரு பலகையின் கீழ் இரண்டிரண்டு பாதங்களாகப் பதினாறு வெள்ளிப்பாதங்களும் இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","சீத்திம் மரத்தால் ஆசரிப்புக்கூடாரத்தின் ஒரு பக்கத்துப் பலகைகளுக்கு ஐந்து தாழ்ப்பாள்களையும், ");
INSERT INTO tam2017_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ஆசரிப்புக்கூடாரத்தின் மறுபக்கத்துப் பலகைகளுக்கு ஐந்து தாழ்ப்பாள்களையும், வாசஸ்தலத்தின் மேற்கு புறமான பின்பக்கத்துப் பலகைகளுக்கு ஐந்து தாழ்ப்பாள்களையும் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","நடுத்தாழ்ப்பாள் ஒருமுனை துவங்கி மறுமுனைவரை பலகைகளின் மையத்தில் செல்லும்படி செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","பலகைகளைப் பொன்தகட்டால் மூடி, தாழ்ப்பாள்களின் இடங்களாகிய அவைகளின் வளையங்களைப் பொன்னினால்செய்து, தாழ்ப்பாள்களைப் பொன்தகட்டால் மூடினான். ");
INSERT INTO tam2017_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","இளநீலநூலாலும் இரத்தாம்பரநூலாலும், சிவப்புநூலாலும் திரித்த மெல்லிய பஞ்சுநூலாலும் செய்யப்பட்டதும், விசித்திரவேலையாகிய கேருபீன்கள் உள்ளதுமான ஒரு திரைச்சீலையை உண்டாக்கி, ");
INSERT INTO tam2017_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","அதற்குச் சீத்திம் மரத்தினால் நான்கு தூண்களைச் செய்து, அவைகளைப் பொன் தகட்டால் மூடி, அவைகளின் கொக்கிகளைப் பொன்னினால்செய்து, அவைகளுக்கு நான்கு வெள்ளிப்பாதங்களை வார்ப்பித்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","கூடாரவாசலுக்கு இளநீலநூலாலும் இரத்தாம்பரநூலாலும் சிவப்புநூலாலும் திரித்த மெல்லிய பஞ்சுநூலாலும் செய்த சித்திரத் தையல்வேலையான ஒரு தொங்கு திரையையும், ");
INSERT INTO tam2017_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","அதின் ஐந்து தூண்களையும், அவைகளின் வளைவான ஆணிகளையும் உண்டாக்கி, அவைகளின் குமிழ்களையும் வளையங்களையும் பொன்தகட்டால் மூடினான்; அவைகளின் ஐந்து பாதங்களும் வெண்கலமாக இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","பெசலெயேல் சீத்திம் மரத்தினால் பெட்டியை உண்டாக்கினான்; அதின் நீளம் இரண்டரை முழமும் அதின் அகலம் ஒன்றரை முழமும் அதின் உயரம் ஒன்றரை முழமுமானது. ");
INSERT INTO tam2017_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","அதை உள்ளும் வெளியும் சுத்தப்பொன் தகட்டால் மூடி, சுற்றிலும் அதற்குப் பொன் விளிம்பை உண்டாக்கி, ");
INSERT INTO tam2017_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","அதற்கு நான்கு பொன் வளையங்களை வார்ப்பித்து, அவைகளை அதின் நான்கு மூலைகளிலும் போட்டு, ஒரு பக்கத்தில் இரண்டு வளையங்களும் மறுபக்கத்தில் இரண்டு வளையங்களும் இருக்கும்படித் தைத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","சீத்திம் மரத்தினால் தண்டுகளைச் செய்து, அவைகளைப் பொன்தகட்டால் மூடி, ");
INSERT INTO tam2017_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","அந்தத் தண்டுகளால் பெட்டியைச் சுமக்கும்படி, அவைகளைப் பெட்டியின் பக்கங்களில் இருக்கும் வளையங்களிலே பாய்ச்சினான். ");
INSERT INTO tam2017_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","கிருபாசனத்தையும் சுத்தப்பொன்னினால் செய்தான்; அது இரண்டரை முழ நீளமும் ஒன்றரை முழ அகலமுமானது. ");
INSERT INTO tam2017_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","தகடாக அடிக்கப்பட்ட பொன்னினால் இரண்டு கேருபீன்களையும் உண்டாக்கி, கிருபாசனத்தின் இரண்டு ஓரங்களிலே, ");
INSERT INTO tam2017_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","ஒருபக்கத்து ஓரத்தில் ஒரு கேருபீனும் மறுபக்கத்து ஓரத்தில் மற்றக் கேருபீனுமாக அந்தக் கேருபீன்களைக் கிருபாசனத்தின் இரண்டு ஓரங்களிலும் அதனோடு ஒரே வேலைப்பாடாகவே செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","அந்தக் கேருபீன்கள் தங்களுடைய இறக்கைகளை உயர விரித்து, தங்களுடைய இறக்கைகளால் கிருபாசனத்தை மூடுகிறவைகளும், ஒன்றுக்கொன்று எதிர்முகமுள்ளவைகளாகவும் இருந்தது; கேருபீன்களின் முகங்கள் கிருபாசனத்தை நோக்கிக்கொண்டிருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","மேஜையையும் சீத்திம் மரத்தால் செய்தான்; அது இரண்டு முழ நீளமும் ஒரு முழ அகலமும் ஒன்றரை முழ உயரமுமானது. ");
INSERT INTO tam2017_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","அதைப் சுத்தப் பொன்தகட்டால் மூடி, சுற்றிலும் அதற்குப் பொன் விளிம்பை உண்டாக்கி, ");
INSERT INTO tam2017_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","சுற்றிலும் அதற்கு நான்கு விரல் அளவான சட்டத்தையும், அதின் சட்டத்திற்குச் சுற்றிலும் பொன் விளிம்பையும் உண்டாக்கி, ");
INSERT INTO tam2017_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","அதற்கு நான்கு பொன்வளையங்களை வார்ப்பித்து, அவைகளை அதின் நான்கு கால்களுக்கு இருக்கும் நான்கு மூலைகளிலும் தைத்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","அந்த வளையங்கள் மேஜையைச் சுமக்கும் தண்டுகளைப் பாய்ச்சும் இடங்களாக இருக்கும்படி சட்டத்தின் அருகே இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","மேஜையைச் சுமக்கும் அந்தத் தண்டுகளைச் சீத்திம் மரத்தால் செய்து, அவைகளைப் பொன்தகட்டால் மூடி, ");
INSERT INTO tam2017_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","மேஜையின்மேலிருக்கும் பாத்திரங்களாகிய அதின் பணிப்பொருட்களையும், அதின் தட்டுகளையும், தூபக்கரண்டிகளையும், அதின் பானபலி கரகங்களையும், மூடுகிறதற்கான அதின் கிண்ணங்களையும் சுத்தப்பொன்னினால் உண்டாக்கினான். ");
INSERT INTO tam2017_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","குத்துவிளக்கையும் சுத்தப்பொன்னினால் அடிப்பு வேலையாக உண்டாக்கினான்; அதின் தண்டும் கிளைகளும் மொக்குகளும் பழங்களும் பூக்களும் பொன்னினால் செய்யப்பட்டிருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","குத்துவிளக்கின் ஒருபக்கத்தில் மூன்று கிளைகளும் அதின் மறுபக்கத்தில் மூன்று கிளைகளுமாக அதின் பக்கங்களில் ஆறு கிளைகள் செய்யப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","ஒவ்வொரு கிளையிலே வாதுமைக்கொட்டைக்கு ஒப்பான மூன்று மொக்குகளும் ஒரு பழமும் ஒரு பூவும் இருந்தது; குத்துவிளக்கில் செய்யப்பட்ட ஆறு கிளைகளிலும் அப்படியே இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","விளக்குத்தண்டில் வாதுமைக்கொட்டைக்கு ஒப்பான நான்கு மொக்குகளும் பழங்களும் பூக்களும் இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","அதில் செய்யப்பட்ட இரண்டு கிளைகளின்கீழ் ஒரு பழமும், வேறு இரண்டு கிளைகளின்கீழ் ஒரு பழமும், மற்ற இரண்டு கிளைகளின்கீழ் ஒரு பழமும் இருந்தது; விளக்குத்தண்டில் செய்யப்பட்ட ஆறு கிளைகளுக்கும் அப்படியே இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","அவைகளின் பழங்களும் அவைகளின் கிளைகளும் சுத்தப்பொன்னினால் ஒரே அடிப்பு வேலையாகச் செய்யப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","அதின் ஏழு அகல்களையும், அதின் கத்தரிகளையும், சாம்பல் பாத்திரங்களையும் சுத்தப்பொன்னினால் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","அதையும் அதின் பணிப்பொருட்கள் யாவையும் ஒரு தாலந்து/ 35 கிலோ. சுத்தப்பொன்னினால் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","தூபபீடத்தையும் சீத்திம் மரத்தினால் உண்டாக்கினான்; அது ஒரு முழ நீளமும் ஒரு முழ அகலமுமான சதுரமும் இரண்டு முழ உயரமுமாக இருந்தது; அதின் கொம்புகள் அதனோடே ஒரே வேலைப்பாடாக இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","அதின் மேற்புறத்தையும், அதின் சுற்றுப்புறத்தையும், அதின் கொம்புகளையும், சுத்தப்பொன்தகட்டால் மூடி, சுற்றிலும் அதற்குப் பொன் விளிம்பை உண்டாக்கி, ");
INSERT INTO tam2017_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","அந்த விளிம்பின்கீழ் அதின் இரண்டு பக்கங்களில் இருக்கும் இரண்டு மூலைகளிலும் இரண்டு பொன்வளையங்களை செய்து, அதைச் சுமக்கும் தண்டுகளைப் பாய்ச்சும் இடங்களாகத் தைத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","சீத்திம் மரத்தால் அந்தத் தண்டுகளைச் செய்து, அவைகளைப் பொன்தகட்டால் மூடினான். ");
INSERT INTO tam2017_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","பரிசுத்த அபிஷேகத் தைலத்தையும், சுத்தமான வாசனைப்பொருட்களின் நறுமணங்களையும், தைலக்காரன் வேலைக்கு ஒப்பாக உண்டாக்கினான். ");
INSERT INTO tam2017_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","தகனபலிபீடத்தையும் சீத்திம் மரத்தால் உண்டாக்கினான்; அது ஐந்து முழநீளமும் ஐந்து முழ அகலமும் சதுரவடிவும் மூன்று முழ உயரமுமானது. ");
INSERT INTO tam2017_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","அதின் நான்கு மூலைகளிலும் அதனோடு ஒன்றாக அதின் நான்கு கொம்புகளையும் உண்டாக்கி, அதை வெண்கலத்தகட்டால் மூடி, ");
INSERT INTO tam2017_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","அந்தப் பீடத்தின் எல்லா பணிப்பொருட்களாகிய சாம்பல் எடுக்கும் சட்டிகளையும், கரண்டிகளையும், கிண்ணிகளையும், முள்துறடுகளையும், நெருப்புச் சட்டிகளையும் உண்டாக்கினான்; அதின் பணிப்பொருட்களையெல்லாம் வெண்கலத்தினால் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","வலைப்பின்னல்போன்ற ஒரு வெண்கலச் சல்லடையையும் பலிபீடத்திற்கு உண்டாக்கி, அதை அந்தப் பீடத்தின் சுற்றுக்குக் கீழே பாதி உயரத்தில் இருக்கும்படியாக வைத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","அந்த வெண்கலச் சல்லடையின் நான்கு மூலைகளிலும் தண்டுகளைப் பாய்ச்சுகிறதற்கு நான்கு வளையங்களை வார்ப்பித்து, ");
INSERT INTO tam2017_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","அந்தத் தண்டுகளைச் சீத்திம் மரத்தால் செய்து, அவைகளை வெண்கலத்தகட்டால் மூடி, ");
INSERT INTO tam2017_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","பலிபீடத்தை அவைகளால் சுமக்கும்படியாக, அதின் பக்கங்களிலுள்ள வளையங்களில் பாய்ச்சினான்; பலிபீடத்தை உள்வெளிவிட்டுப் பலகைகளால் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","ஆசரிப்புக்கூடாரத்தின் வாசலில் கூட்டம் கூட்டமாகக் கூடின பெண்கள் கண்ணாடியாக பயன்படுத்தின வெண்கலத்தாலே, வெண்கலத் தொட்டியையும் அதின் வெண்கலப் பாதத்தையும் உண்டாக்கினான். ");
INSERT INTO tam2017_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","பிராகாரத்தையும் உண்டாக்கினான். தெற்கே தென்திசைக்கு எதிரான பிராகாரத்திற்கு திரித்த மெல்லிய பஞ்சுநூலால் நெய்த நூறு முழ நீளமான தொங்கு திரைகளைச் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","அவைகளின் தூண்கள் இருபது; அவைகளின் வெண்கலப் பாதங்கள் இருபது; தூண்களின் கொக்கிகளும் அவைகளின் கம்பிகளும் வெள்ளி. ");
INSERT INTO tam2017_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","வடபக்கத்துத் தொங்கு திரைகள் நூறு முழம்; அவைகளின் தூண்கள் இருபது; அவைகளின் வெண்கலப் பாதங்கள் இருபது; தூண்களின் கொக்கிகளும் கம்பிகளும் வெள்ளி. ");
INSERT INTO tam2017_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","மேற்பக்கத்துத் தொங்கு திரைகள் ஐம்பது முழம்; அவைகளின் தூண்கள் பத்து; அவைகளின் பாதங்கள் பத்து; தூண்களின் கொக்கிகளும் அவைகளின் கம்பிகளும் வெள்ளி. ");
INSERT INTO tam2017_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","சூரியன் உதிக்கிற திசையாகிய கீழ்ப்பக்கத்துத் தொங்கு திரைகள் ஐம்பது முழம். ");
INSERT INTO tam2017_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","ஒருபுறத்துத் தொங்கு திரைகள் பதினைந்து முழம்; அவைகளின் தூண்கள் மூன்று; அவைகளின் பாதங்கள் மூன்று. ");
INSERT INTO tam2017_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","பிராகாரவாசலின் ஒருபுறத்திற்குச் சரியாக மறுபுறத்திலும் தொங்கு திரைகள் பதினைந்து முழம்; அவைகளின் தூண்கள் மூன்று; அவைகளின் பாதங்கள் மூன்று. ");
INSERT INTO tam2017_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","சுற்றுபிராகாரத்துத் தொங்கு திரைகளெல்லாம் மெல்லிய பஞ்சுநூலால் நெய்யப்பட்டிருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","தூண்களின் பாதங்கள் வெண்கலம்; தூண்களின் கொக்கிகளும், கம்பிகளும் வெள்ளி; அவைகளின் குமிழ்களை மூடிய தகடும் வெள்ளி; பிராகாரத்தின் தூண்களெல்லாம் வெள்ளிக்கம்பிகள் போடப்பட்டவைகளுமாக இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","பிராகாரத்தின் வாசலின் தொங்கு திரை இளநீலநூலாலும் இரத்தாம்பரநூலாலும் சிவப்புநூலாலும் திரித்த மெல்லிய பஞ்சுநூலாலும் செய்யப்பட்ட சித்திரத்தையல் வேலையாக இருந்தது; அதின் நீளம் இருபது முழம், அதின் அகலமும் உயரமும் பிராகாரத்தின் தொங்கு திரைகளைப்போல ஐந்து முழம். ");
INSERT INTO tam2017_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","அவைகளின் தூண்கள் நான்கு; அவைகளின் வெண்கலப் பாதங்கள் நான்கு; அவைகளின் கொக்கிகள் வெள்ளி; அவைகளின் குமிழ்களை மூடிய தகடும் அவைகளின் கம்பிகளும் வெள்ளி. ");
INSERT INTO tam2017_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","ஆசரிப்புக்கூடாரத்திற்கும் பிராகாரத்திற்கும் சுற்றிலும் இருந்த ஆப்புகளெல்லாம் வெண்கலம். ");
INSERT INTO tam2017_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","மோசேயின் கட்டளைப்படி ஆசாரியனான ஆரோனின் மகனாகிய இத்தாமாரின் கையிலே லேவியர்களின் ஊழியத்திற்கென்று எண்ணிக் கொடுக்கப்பட்ட சாட்சியின் ஆசரிப்புக்கூடாரத்தின் பொருள்களின் தொகை இதுவே. ");
INSERT INTO tam2017_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","யூதாவின் கோத்திரத்தில் ஊரின் மகனாகிய ஊரியின் மகன் பெசலெயேல் யெகோவா மோசேக்குக் கற்பித்ததை எல்லாம் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","அவனுடன் தாண் கோத்திரத்தின் அகிசாமாகின் மகனாகிய அகோலியாப் அலங்காரக் கொத்துவேலைக்காரனும், வித்தியாசமான வேலைகளைச்செய்கிற தொழிலாளியும், இளநீலநூலாலும் இரத்தாம்பரநூலாலும் சிவப்புநூலாலும் மெல்லிய பஞ்சுநூலாலும் சித்திரத்தையல் வேலை செய்கிறவனுமாக இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","பரிசுத்த ஸ்தலத்தின் வேலைகள் எல்லாவற்றிற்கும் காணிக்கையாகக் கொடுக்கப்பட்டுச் செலவான பொன்னெல்லாம் பரிசுத்த ஸ்தலத்தின் சேக்கலின்படி இருபத்தொன்பது தாலந்தும் எழுநூற்று முப்பது சேக்கல் நிறையுமாக இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","சபையில் எண்ணப்பட்டவர்கள் கொடுத்த வெள்ளி பரிசுத்த ஸ்தலத்தின் சேக்கலின்படி நூறு தாலந்தும், ஆயிரத்தெழுநூற்று எழுபத்தைந்து சேக்கல் நிறையுமாக இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","எண்ணப்பட்டவர்களின் தொகையில் சேர்ந்த இருபது வயதுமுதல் அதற்கு மேற்பட்ட ஆறுலட்சத்து மூவாயிரத்து ஐந்நூற்று ஐம்பதுபேர்களில் ஒவ்வொரு தலைக்கு பரிசுத்த ஸ்தலத்தின் சேக்கலின்படி அரைச்சேக்கலாகிய பெக்கா என்னும் விழுக்காடு சேர்ந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","அந்த வெள்ளியில் நூறு தாலந்து வெள்ளியினால் பரிசுத்த ஸ்தலத்தின் பாதங்களும் திரையின் பாதங்களும் வார்க்கப்பட்டது; பாதத்திற்கு ஒரு தாலந்து விழுக்காடு நூறு பாதங்களுக்கு நூறு தாலந்து செலவானது. ");
INSERT INTO tam2017_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","அந்த ஆயிரத்தெழுநூற்று எழுபத்தைந்து சேக்கலால் தூண்களுக்குக் கொக்கிகளைச்செய்து, அவைகளின் குமிழ்களைத் தகடுகளால் மூடி, அவைகளுக்குக் கம்பிகளை உண்டாக்கினான். ");
INSERT INTO tam2017_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","காணிக்கையாகச் செலுத்தப்பட்ட வெண்கலமானது எழுபது தாலந்தும் இரண்டாயிரத்து நானூறு சேக்கல் நிறையுமாக இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","அதினாலே ஆசரிப்புக்கூடாரத்தின் வாசல் மறைவின் பாதங்களையும், வெண்கலப் பலிபீடத்தையும், அதின் வெண்கலச் சல்லடையையும், பலிபீடத்தின் எல்லாப் பணிப்பொருட்களையும், ");
INSERT INTO tam2017_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","சுற்றுப் பிராகாரத்தின் பாதங்களையும், பிராகாரவாசல் மறைவின் பாதங்களையும், ஆசரிப்புக்கூடாரத்தின் எல்லா ஆப்புகளையும், சுற்றுப்பிராகாரத்தின் எல்லா ஆப்புகளையும் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","யெகோவா மோசேக்குக் கற்பித்தபடியே, அவர்கள் இளநீலநூலாலும் இரத்தாம்பரநூலாலும் சிவப்புநூலாலும் பரிசுத்த ஸ்தலத்தில் ஆராதனை செய்கிறதற்கு வேண்டிய ஆடைகளையும், ஆரோனுக்குப் பரிசுத்த ஆடைகளையும் செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","ஏபோத்தைப் பொன்னினாலும் இளநீலநூலாலும் இரத்தாம்பரநூலாலும் சிவப்புநூலாலும் திரித்த மெல்லிய பஞ்சுநூலாலும் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","அந்தப் பொன்னை, இளநீலநூலோடும் இரத்தாம்பர நூலோடும் சிவப்புநூலோடும் மெல்லிய பஞ்சுநூலோடும் சேர்த்து வித்தியாசமான வேலையாக நெய்யும்படி, மெல்லிய தகடுகளாக அடித்து, அவைகளை கம்பிகளாகச் செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","இரண்டு தோள்களின்மேலுள்ள அதின் இரண்டு முனைகளையும் சேர்த்தார்கள்; அது ஒன்றாக இணைக்கப்பட்டிருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","அந்த ஏபோத்தின்மேலிருக்கும் வித்தியாசமான வார்க்கச்சை, அந்த வேலைக்கு ஒப்பாகவே பொன்னினாலும் இளநீலநூலாலும் இரத்தாம்பரநூலாலும் சிவப்புநூலாலும், திரித்த மெல்லிய பஞ்சுநூலாலும், யெகோவா மோசேக்குக் கற்பித்தபடியே, செய்யப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","இஸ்ரவேலின் பன்னிரெண்டு மகன்களின் பெயர்களை முத்திரை வெட்டுவேலையாகக் கோமேதகக் கற்களில் வெட்டி, அவைகளைப் பொன் குவளைகளில் பதித்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","யெகோவா மோசேக்குக் கற்பித்தபடியே, அவைகள் இஸ்ரவேலின் பன்னிரண்டு மகன்களைக் குறித்து ஞாபகக்குறிக் கற்களாக இருக்கும்படி ஏபோத்துத் தோள்களின்மேல் அவைகளை வைத்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","மார்ப்பதக்கத்தை ஏபோத்தின் வேலைக்கு ஒத்த வித்தியாசமானவேலையாகப் பொன்னினாலும் இளநீலநூலாலும் இரத்தாம்பரநூலாலும் சிவப்புநூலாலும் திரித்த மெல்லிய பஞ்சுநூலாலும் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","அந்த மார்ப்பதக்கத்தைச் சதுரமும் இரட்டையுமாகச் செய்து, ஒரு ஜாண் நீளமும். ஒரு ஜாண் அகலமுமாக்கி, ");
INSERT INTO tam2017_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","அதிலே நான்கு வரிசை இரத்தினக்கற்களைப் பதித்தார்கள்; முதலாம் வரிசை பத்மராகமும் புஷ்பராகமும் மாணிக்கமும், ");
INSERT INTO tam2017_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","இரண்டாம் வரிசை மரகதமும் இந்திரநீலமும் வச்சிரமும், ");
INSERT INTO tam2017_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","மூன்றாம் வரிசை கெம்பும் வைடூரியமும் சுகந்தியும், ");
INSERT INTO tam2017_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","நாலாம் வரிசை படிகப்பச்சையும் கோமேதகமும் யஸ்பியுமானது. அவைகள் அந்தந்த இடங்களிலே பொன்குவளைகளில் பதிக்கப்பட்டிருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","இந்தக் கற்கள் இஸ்ரவேலின் மகன்களுடைய பெயர்களின்படியே பன்னிரண்டும், அவர்களுடைய பெயர்கள் உள்ளவைகளுமாக இருந்தது; பன்னிரண்டு கோத்திரங்களில் ஒவ்வொரு கோத்திரத்தின் பெயர் ஒவ்வொன்றில் முத்திரைவெட்டாக வெட்டியிருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","மார்ப்பதக்கத்திற்கு அதின் பக்கங்களிலே பின்னல் வேலையான சுத்தப்பொன் சங்கிலிகளையும் செய்து, ");
INSERT INTO tam2017_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","இரண்டு பொன் குவளைகளையும் இரண்டு பொன் வளையங்களையும் செய்து, அந்த இரண்டு வளையங்களை மார்ப்பதக்கத்தின் இரண்டு பக்கத்திலும் வைத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","பொன்னினால் செய்த பின்னல் வேலையான அந்த இரண்டு சங்கிலிகளையும் மார்ப்பதக்கத்தின் பக்கங்களில் இருக்கிற இரண்டு வளையங்களிலும் மாட்டி, ");
INSERT INTO tam2017_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","பின்னல் வேலையான அந்த இரண்டு சங்கிலிகளின் இரண்டு நுனிகளையும் ஏபோத்தின் தோள்புறத்துத் துண்டுகள்மேல் முன்புறத்தில் இருக்கிற இரண்டு குவளைகளிலும் மாட்டினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","பின்னும் இரண்டு வளையங்களைச்செய்து, அவைகளை ஏபோத்தின் கீழ்ப்பக்கத்திற்கு எதிரான மார்ப்பதக்கத்தின் மற்ற இரண்டு பக்கங்களிலும் அதின் ஓரத்தில் வைத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","வேறே இரண்டு பொன்வளையங்களையும் செய்து, அவைகளை ஏபோத்தின் முன்புறத்தின் இரண்டு கீழ்ப்பக்கங்களில் அதின் இணைப்புக்கு எதிராகவும், ஏபோத்தின் விசித்திரமான வார்க்கச்சைக்கு மேலாகவும் வைத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","மார்ப்பதக்கம் ஏபோத்தின் வித்தியாசமான வார்க்கச்சைக்கு மேலாக இருக்கும்படியும், ஏபோத்திலிருந்து நீங்கிப்போகாதபடியும், அதை அதின் வளையங்களால் ஏபோத்தின் வளையங்களோடு இளநீல நாடாவினாலே, யெகோவா மோசேக்குக் கற்பித்தப்படியே, கட்டினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","ஏபோத்தின் கீழ் அங்கியை முழுவதும் இளநீலநூலால் நெய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","அங்கியின் நடுவில் மார்க்கவசத் துவாரத்திற்கு ஒப்பாக ஒரு துவாரமும், அது கிழியாதபடி அந்தத் துவாரத்தைச் சுற்றிலும் ஒரு நாடாவும் தைத்திருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","அங்கியின் கீழ்ஓரங்களில் தொங்கும்படியாகத் திரித்த இளநீலநூலும் இரத்தாம்பரநூலும் சிவப்புநூலுமான வேலையாக மாதுளம்பழங்களைச் செய்து, ");
INSERT INTO tam2017_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","சுத்தப்பொன்னினால் மணிகளையும் செய்து, அந்த மணிகளை அங்கியின் ஓரங்களில் சுற்றிலும் மாதுளம்பழங்களின் இடையிடையே தொங்கவைத்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","யெகோவா மோசேக்குக் கற்பித்தபடியே ஆராதனைக்குரிய அங்கியின் ஓரத்தைச் சுற்றிலும், ஒரு மணியும் ஒரு மாதுளம்பழமும், ஒரு மணியும் ஒரு மாதுளம்பழமுமாக இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","ஆரோனுக்கும் அவனுடைய மகன்களுக்கும் மெல்லிய பஞ்சுநூலால் நெசவுவேலையான அங்கிகளையும், ");
INSERT INTO tam2017_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","மெல்லிய பஞ்சுநூலால் தலைப்பாகையையும், அலங்காரமான குல்லாக்களையும், திரித்த மெல்லிய சணல்நூலால் உள்ளாடைகளையும், ");
INSERT INTO tam2017_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","திரித்த மெல்லிய பஞ்சுநூலாலும் இளநீலநூலாலும் இரத்தாம்பரநூலாலும் சிவப்புநூலாலும் சித்திரத் தையல்வேலையான இடுப்புக்கச்சையையும், யெகோவா மோசேக்குக் கற்பித்தபடியே செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","பரிசுத்த கிரீடத்தின் பட்டத்தையும் சுத்தப்பொன்னினாலே செய்து, யெகோவாவுக்குப் பரிசுத்தம் என்னும் எழுத்துக்களை அதிலே முத்திரை வெட்டாகவெட்டி, ");
INSERT INTO tam2017_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","அதை உயர தலைப்பாகையின்மேல் கட்டும்படி, யெகோவா மோசேக்குக் கற்பித்தபடியே, இளநீல நாடாவினால் கட்டினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","இப்படியே ஆசரிப்புக்கூடாரமாகிய வாசஸ்தலத்தின் வேலையெல்லாம் முடிந்தது; யெகோவா மோசேக்குக் கற்பித்தபடியெல்லாம் இஸ்ரவேல் மக்கள் செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","பின்பு. வாசஸ்தலத்தை மோசேயினிடத்தில் கொண்டுவந்தார்கள்; கூடாரத்தையும், அதற்குரிய எல்லாப் பணிப்பொருட்களையும், அதின் துறடுகளையும், அதின் பலகைகளையும், அதின் தாழ்ப்பாள்களையும், அதின் தூண்களையும், அதின் பாதங்களையும், ");
INSERT INTO tam2017_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","சிவப்பு வண்ணம் தீட்டப்பட்ட ஆட்டுக்கடாத்தோல் மூடியையும், மெல்லிய தோல் மூடியையும், மறைவின் திரைச்சீலையையும், ");
INSERT INTO tam2017_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","சாட்சிப்பெட்டியையும், அதின் தண்டுகளையும், கிருபாசனத்தையும், ");
INSERT INTO tam2017_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","மேஜையையும், அதின் எல்லாப் பணிப்பொருட்களையும், சமுகத்து அப்பங்களையும், ");
INSERT INTO tam2017_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","சுத்தமான குத்துவிளக்கையும், வரிசையாக ஒழுங்குப்படுத்தப்பட்ட அதின் அகல்களையும், அதின் எல்லாப் பணிப்பொருட்களையும், வெளிச்சத்திற்கு எண்ணெயையும், ");
INSERT INTO tam2017_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","பொற்பீடத்தையும், அபிஷேகத் தைலத்தையும், நறுமணப் பொருட்களையும், வாசஸ்தலத்தின் வாசல் தொங்கு திரையையும், ");
INSERT INTO tam2017_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","வெண்கலப் பலிபீடத்தையும், அதின் வெண்கலச் சல்லடையையும், அதின் தண்டுகளையும், அதின் எல்லா பணிப்பொருட்களையும், தொட்டியையும், அதின் பாதத்தையும், ");
INSERT INTO tam2017_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","பிராகாரத்தின் தொங்கு திரைகளையும், அதின் தூண்களையும், அதின் பாதங்களையும், பிராகாரத்து வாசல் மறைவையும், அதின் கயிறுகளையும், அதின் ஆப்புகளையும், ஆசரிப்புக்கூடாரமான வாசஸ்தலத்தின் வேலையின் எல்லா பணிப்பொருட்களையும், ");
INSERT INTO tam2017_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","பரிசுத்த ஸ்தலத்திலே செய்யும் ஆராதனைக்குரிய ஆடைகளையும், ஆசாரிய ஊழியஞ்செய்கிற ஆரோனின் பரிசுத்த ஆடைகளையும், அவனுடைய மகன்களின் ஆடைகளையும் கொண்டுவந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","யெகோவா மோசேக்குக் கற்பித்தபடியெல்லாம் இஸ்ரவேல் மக்கள் எல்லா வேலைகளையும் செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","மோசே அந்த வேலைகளையெல்லாம் பார்த்தான்; யெகோவா கற்பித்தபடியே அதைச் செய்திருந்தார்கள். மோசே அவர்களை ஆசீர்வதித்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“நீ முதலாம் மாதம் முதல் தேதியில் ஆசரிப்புக்கூடாரத்தின் வாசஸ்தலத்தை பிரதிஷ்டைசெய். ");
INSERT INTO tam2017_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","அதிலே சாட்சிப்பெட்டியை வைத்து, பெட்டியைத் திரையினால் மறைத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","மேஜையைக் கொண்டுவந்து, அதில் வைக்கவேண்டியதை சரியாக வைத்து, குத்துவிளக்கைக் கொண்டுவந்து, அதின் விளக்குகளை ஏற்றி, ");
INSERT INTO tam2017_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","பொன் தூபபீடத்தைச் சாட்சிப்பெட்டிக்கு முன்னே வைத்து, வாசஸ்தலத்தின் வாசலின் தொங்கு திரையைத் தூக்கிவைக்கக்கடவாய். ");
INSERT INTO tam2017_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","பின்பு, தகன பலிபீடத்தை ஆசரிப்புக்கூடாரமாகிய வாசஸ்தலத்தின் வாசலுக்கு முன்பாக வைத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","தொட்டியை ஆசரிப்புக்கூடாரத்திற்கும் பலிபீடத்திற்கும் நடுவே வைத்து, அதிலே தண்ணீர் ஊற்றி, ");
INSERT INTO tam2017_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","சுற்று பிராகாரத்தை நிறுத்தி, பிராகாரவாசல் தொங்கு திரையைத் தூக்கிவைத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","அபிஷேக தைலத்தை எடுத்து, வாசஸ்தலத்தையும் அதிலுள்ள யாவையும் அபிஷேகம்செய்து, அதையும் அதிலுள்ள எல்லாப் பணிப்பொருட்களையும் பரிசுத்தப்படுத்து; அப்பொழுது பரிசுத்தமாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","தகனபலிபீடத்தையும், அதின் எல்லா பணிப்பொருட்களையும், அபிஷேகம்செய்து, அதைப் பரிசுத்தப்படுத்து; அப்பொழுது அது மகா பரிசுத்தமான பலிபீடமாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","தொட்டியையும் அதின் பாதத்தையும் அபிஷேகம்செய்து, பரிசுத்தப்படுத்து. ");
INSERT INTO tam2017_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","பின்பு ஆரோனையும் அவனுடைய மகன்களையும் ஆசரிப்புக்கூடாரத்தின் வாசலில் வரச்செய்து, அவர்களை தண்ணீரால் குளிக்கவைத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","ஆரோனுக்குப் பரிசுத்த ஆடைகளை உடுத்தி, எனக்கு ஆசாரிய ஊழியம் செய்யும்படி அவனை அபிஷேகம்செய்து, அவனைப் பரிசுத்தப்படுத்து. ");
INSERT INTO tam2017_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","அவன் மகன்களையும் வரச்செய்து, அவர்களுக்கு அங்கிகளை உடுத்தி, ");
INSERT INTO tam2017_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","அவர்கள் எனக்கு ஆசாரிய ஊழியம் செய்யும்படி, அவர்களையும், அவர்கள் தகப்பனை அபிஷேகம்செய்தபடியே, அபிஷேகம்செய்; அவர்கள் பெறும் அந்த அபிஷேகம் தலைமுறைதோறும் நிரந்தர ஆசாரியத்துவத்திற்கு ஏதுவாக இருக்கும் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","யெகோவா தனக்குக் கற்பித்தபடியெல்லாம் மோசே செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","இரண்டாம் வருடம் முதலாம் மாதம் முதல் தேதியில் வாசஸ்தலம் நிறுவப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","மோசே கூடாரத்தை எடுப்பித்தான்; அவன் அதின் பாதங்களை வைத்து, அதின் பலகைகளை நிறுத்தி, அதின் தாழ்ப்பாள்களைப் பாய்ச்சி, அதின் தூண்களை நாட்டி, ");
INSERT INTO tam2017_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","வாசஸ்தலத்தின்மேல் கூடாரத்தை விரித்து, அதின்மேல் கூடாரத்தின் மூடியை, யெகோவா தனக்குக் கற்பித்தபடியே போட்டான். ");
INSERT INTO tam2017_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","பின்பு, யெகோவா மோசேக்குக் கற்பித்தபடியே, சாட்சிப்பிரமாணத்தை எடுத்து, அதைப் பெட்டியிலே வைத்து, பெட்டியில் தண்டுகளைப்பாய்ச்சி, பெட்டியின்மேல் கிருபாசன மூடியை வைத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","பெட்டியை வாசஸ்தலத்திற்குள்ளே கொண்டுபோய், மறைவின் திரைச்சீலையைத் தொங்கவைத்து, சாட்சிப்பெட்டியை மறைத்துவைத்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","பின்பு, யெகோவா மோசேக்குக் கற்பித்தபடியே, மேஜையை ஆசரிப்புக்கூடாரத்தில் வாசஸ்தலத்தின் வடபுறமாகத் திரைக்குப் புறம்பாக வைத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","அதின்மேல் யெகோவாவுடைய சமுகத்தில் அப்பத்தை வரிசையாக அடுக்கிவைத்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","பின்பு, யெகோவா மோசேக்குக் கற்பித்தபடியே, குத்துவிளக்கை ஆசரிப்புக்கூடாரத்தில் மேஜைக்கு எதிராக வாசஸ்தலத்தின் தென்புறத்திலே வைத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","யெகோவாவுடைய சந்நிதியில் விளக்குகளை ஏற்றினான். ");
INSERT INTO tam2017_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","பின்பு, யெகோவா மோசேக்குக் கற்பித்தபடியே, ஆசரிப்புக்கூடாரத்தில் திரைக்கு முன்பாகப் பொற்பீடத்தை வைத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","அதின்மேல் நறுமணப்பொருட்களால் தூபம்காட்டினான். ");
INSERT INTO tam2017_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","பின்பு, யெகோவா மோசேக்குக் கற்பித்தபடியே, வாசஸ்தலத்தின் தொங்கு திரையைத் தூக்கிவைத்து, ");
INSERT INTO tam2017_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","தகனபலிபீடத்தை ஆசரிப்புக்கூடாரமான வாசஸ்தலத்தின் வாசலுக்கு முன்பாக வைத்து, அதின்மேல் சர்வாங்க தகனபலியையும் போஜனபலியையும் செலுத்தினான். ");
INSERT INTO tam2017_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","அவன் ஆசரிப்புக்கூடாரத்திற்கும் பலிபீடத்திற்கும் நடுவே தொட்டியை வைத்து, கழுவுகிறதற்கு அதிலே தண்ணீர் வார்த்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","அவ்விடத்திலே மோசேயும் ஆரோனும் அவனுடைய மகன்களும் தங்கள் கைகளையும் கால்களையும் கழுவினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","யெகோவா மோசேக்குக் கற்பித்தபடியே, அவர்கள் ஆசரிப்புக்கூடாரத்திற்குள்ளே நுழைகிறபோதும், பலிபீடத்தினருகில் சேருகிறபோதும், அவர்கள் கழுவிக்கொள்ளுவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","பின்பு, அவன் வாசஸ்தலத்தையும் பலிபீடத்தையும் சுற்றி பிராகாரத்தை அமைத்து, பிராகாரத்தின் தொங்கு திரையைத் தொங்கவைத்தான்; இவ்விதமாக மோசே வேலையை முடித்தான். ");
INSERT INTO tam2017_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","அப்பொழுது ஒரு மேகம் ஆசரிப்புக்கூடாரத்தை மூடினது; யெகோவாவுடைய மகிமை வாசஸ்தலத்தை நிரப்பியது. ");
INSERT INTO tam2017_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","மேகம் அதின்மேல் தங்கி, யெகோவாவுடைய மகிமை வாசஸ்தலத்தை நிரப்பினதினால், மோசே ஆசரிப்புக்கூடாரத்திற்குள் நுழையமுடியாமல் இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","வாசஸ்தலத்திலிருந்து மேகம் மேலே எழும்பும்போது, இஸ்ரவேல் மக்கள் பயணம்செய்யப் புறப்படுவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","மேகம் எழும்பாமல் இருந்தால், அது எழும்பும் நாள்வரைக்கும் பயணம் செய்யாமல் இருப்பார்கள். ");
INSERT INTO tam2017_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","இஸ்ரவேல் மக்கள் செய்யும் எல்லாப் பயணங்களிலும் அவர்களெல்லோருடைய கண்களுக்கும் நேரடியாக பகலில் யெகோவாவுடைய மேகமும், இரவில் அக்கினியும், வாசஸ்தலத்தின்மேல் தங்கியிருந்தது.");
INSERT INTO tam2017_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","யெகோவா ஆசரிப்புக்கூடாரத்திலிருந்து மோசேயை அழைத்து அவனை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“நீ இஸ்ரவேல் மக்களிடத்தில் சொல்லவேண்டியது என்னவென்றால், உங்களில் ஒருவன் யெகோவாவுக்குப் பலிசெலுத்த வந்தால், மாட்டுமந்தையிலாவது ஆட்டுமந்தையிலாவது ஒன்றைத் தேர்ந்தெடுத்து பலிசெலுத்தவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","அவன் செலுத்துவது மாட்டுமந்தையிலிருந்து எடுக்கப்பட்ட சர்வாங்க தகனபலியானால், அவன் பழுதற்ற ஒரு காளையைச் செலுத்துவானாக; யெகோவாவுடைய சந்நிதியில், தான் அங்கீகரிக்கப்படுவதற்கு, அவன் அதை ஆசரிப்புக்கூடாரத்தின் வாசலில் கொண்டுவந்து, ");
INSERT INTO tam2017_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","தன் பாவநிவிர்த்திக்கென்று அது அங்கீகரிக்கப்படுவதற்கு தன் கையை அதின் தலையின்மேல் வைத்து, ");
INSERT INTO tam2017_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","யெகோவாவுடைய சந்நிதியில் அந்தக் காளையைக் கொல்லக்கடவன்; அப்பொழுது ஆரோனின் மகன்களாகிய ஆசாரியர்கள் அதின் இரத்தத்தை எடுத்து, அதை ஆசரிப்புக்கூடாரத்தின் வாசலில் இருக்கிற பலிபீடத்தின்மேல் சுற்றிலும் தெளிக்கக்கடவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","பின்பு அவன் அந்தச் சர்வாங்க தகனபலியைத் தோலுரித்து, அதைத் துண்டுதுண்டாக வெட்டவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","அப்பொழுது ஆசாரியனாகிய ஆரோனின் மகன்கள் பலிபீடத்தின்மேல் நெருப்பை மூட்டி, நெருப்பின்மேல் கட்டைகளை அடுக்கி, ");
INSERT INTO tam2017_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","அவனுடைய மகன்களாகிய ஆசாரியர்கள், துண்டுகளையும், தலையையும், கொழுப்பையும் பலிபீடத்திலுள்ள நெருப்பில் இருக்கிற கட்டைகளின்மேல் அடுக்கிவைப்பார்களாக. ");
INSERT INTO tam2017_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","அதின் குடல்களையும் தொடைகளையும் அவன் தண்ணீரினால் கழுவுவானாக; அவைகளையெல்லாம் ஆசாரியன் பலிபீடத்தின்மேல் சர்வாங்க தகனபலியாக எரிக்கக்கடவன்; இது யெகோவாவுக்கு நறுமண வாசனையான தகனபலி. ");
INSERT INTO tam2017_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“அவன் செலுத்துவது செம்மறியாட்டு மந்தையிலுள்ள ஆடுகளிலாவது வெள்ளாட்டு மந்தையிலுள்ள ஆடுகளிலாவது எடுக்கப்பட்ட சர்வாங்க தகனபலியானால், பழுதற்ற ஒரு கடாவைக் கொண்டுவந்து, ");
INSERT INTO tam2017_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","யெகோவாவுடைய சந்நிதியில் பலிபீடத்தின் வடக்குப் பகுதியில் அதைக் கொல்லக்கடவன்; அப்பொழுது ஆரோனின் மகன்களாகிய ஆசாரியர்கள் அதின் இரத்தத்தைப் பலிபீடத்தின்மேல் சுற்றிலும் தெளிக்கக்கடவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","பின்பு அவன் அதைத் துண்டுகளாக வெட்டி, அதின் தலையையும் கொழுப்பையும் அதனுடன் வைப்பானாக; அவைகளை ஆசாரியன் பலிபீடத்திலுள்ள நெருப்பில் இருக்கிற கட்டைகளின்மேல் அடுக்கிவைப்பானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","குடல்களையும் தொடைகளையும் அவன் தண்ணீரினால் கழுவுவானாக; அவைகளையெல்லாம் ஆசாரியன் கொண்டுவந்து பலிபீடத்தின்மேல் எரிக்கக்கடவன்; இது சர்வாங்க தகனபலி; இது யெகோவாவுக்கு நறுமண வாசனையான தகனபலி. ");
INSERT INTO tam2017_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“அவன் யெகோவாவுக்குச் செலுத்துவது பறவைகளிலிருந்து எடுக்கப்பட்ட சர்வாங்க தகனபலியானால், காட்டுப் புறாக்களிலாவது புறாக்குஞ்சுகளிலாவது எடுத்து செலுத்தக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","அதை ஆசாரியன் பலிபீடத்தின் அருகில் கொண்டுவந்து, அதின் தலையைக் கிள்ளி, பலிபீடத்தில் எரித்து, அதின் இரத்தத்தைப் பலிபீடத்தின் அருகில் சிந்தவிட்டு, ");
INSERT INTO tam2017_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","அதின் இரைப்பையையும் அதின் உள்ளவைகளையும் எடுத்து, அதைப் பலிபீடத்தின் அருகில் கிழக்குப் பகுதியில் சாம்பல் இருக்கிற இடத்திலே எறிந்துவிட்டு, ");
INSERT INTO tam2017_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","பின்பு அதின் இறக்கைகளுடன் அதை இரண்டாக்காமல் பிளப்பானாக; பின்பு ஆசாரியன் அதைப் பலிபீடத்திலுள்ள நெருப்பில் இருக்கிற கட்டைகளின்மேல் எரிக்கக்கடவன்; இது சர்வாங்க தகனபலி; இது யெகோவாவுக்கு நறுமண வாசனையான தகனபலி. ");
INSERT INTO tam2017_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ஒருவன் உணவுபலியாகிய காணிக்கையைக் யெகோவாவுக்குச் செலுத்தவேண்டுமானால், அவனுடைய காணிக்கை மெல்லிய மாவாக இருப்பதாக; அவன் அதின்மேல் எண்ணெய் ஊற்றி, அதின்மேல் தூபவர்க்கம் போட்டு, ");
INSERT INTO tam2017_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","அதை ஆரோனின் மகன்களாகிய ஆசாரியர்களிடத்தில் கொண்டுவருவானாக; அப்பொழுது ஆசாரியன் அந்த மாவிலும் எண்ணெயிலும் ஒரு கைப்பிடி நிறைய தூபவர்க்கம் எல்லாவற்றோடும் எடுத்து, அதைப் பலிபீடத்தின்மேல் நன்றியின் அடையாளமாக எரிக்கக்கடவன்; அது யெகோவாவுக்கு நறுமண வாசனையான தகனபலி. ");
INSERT INTO tam2017_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","அந்த உணவுபலியில் மீதியாக இருப்பது ஆரோனையும் அவனுடைய மகன்களையும் சேரும்; யெகோவாவுக்குச் செலுத்தும் தகனபலிகளில் இது மகா பரிசுத்தமானது. ");
INSERT INTO tam2017_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“நீ படைப்பது அடுப்பில் சமைக்கப்பட்ட உணவுபலியானால், அது எண்ணெயிலே பிசைந்த மெல்லிய மாவினால் செய்யப்பட்ட புளிப்பில்லாத அதிரசங்களாகவோ, எண்ணெய் பூசப்பட்ட புளிப்பில்லாத அடைகளாகவோ இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","நீ படைப்பது அடுப்பில் தட்டையான பாத்திரத்தில் சமைக்கப்பட்ட உணவுபலியானால், அது எண்ணெயிலே பிசைந்த புளிப்பில்லாத மெல்லிய மாவினால் செய்யப்பட்டதாக இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","அதைத் துண்டுதுண்டாகப் பிட்டு, அதின்மேல் எண்ணெய் ஊற்றுவாயாக; இது ஒரு உணவுபலி. ");
INSERT INTO tam2017_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","நீ படைப்பது அடுப்பில் பொரிக்கும் பாத்திரத்தில் சமைக்கப்பட்ட உணவு பலியானால், அது எண்ணெயிலே பிசைந்த மெல்லிய மாவினால் செய்யப்படுவதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","இப்படிச் செய்யப்பட்ட உணவுபலியைக் யெகோவாவுக்குச் செலுத்துவாயாக; அது ஆசாரியனிடத்தில் கொண்டுவரப்படும்போது, அவன் அதைப் பலிபீடத்தின் அருகில் கொண்டுவந்து, ");
INSERT INTO tam2017_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","அந்த சமைக்கப்பட்ட உணவுபலியிலிருந்து ஆசாரியன் நன்றியின் அடையாளமாக ஒரு பங்கை எடுத்துப் பலிபீடத்தின்மேல் எரிக்கக்கடவன்; இது யெகோவாவுக்கு நறுமண வாசனையான தகனபலி. ");
INSERT INTO tam2017_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","இந்த உணவுபலியில் மீதியானது ஆரோனையும் அவனுடைய மகன்களையும் சேரும்; யெகோவாவுக்குச் செலுத்தும் தகனங்களில் இது மகா பரிசுத்தமானது. ");
INSERT INTO tam2017_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“நீங்கள் யெகோவாவுக்குச் செலுத்தும் எந்த உணவுபலியும் புளித்தமாவினால் செய்யப்படாதிருப்பதாக; புளித்தமாவு உள்ளவைகளையும் தேன் உள்ளவைகளையும் யெகோவாவுக்குத் தகனபலியாக எரிக்கவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","முதற்கனிகளைக் காணிக்கையாகக் கொண்டுவந்து, அவைகளைக் யெகோவாவுக்குச் செலுத்தலாம்; ஆனாலும், பலிபீடத்தின்மேல் அவைகளை நறுமண வாசனையாக எரிக்கக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","நீ படைக்கிற எந்த உணவுபலியிலும் உப்பு சேர்க்கப்படுவதாக; உன் தேவனுடைய உடன்படிக்கையின் உப்பை உன் உணவுபலியிலே குறையவிடாமல், நீ படைப்பது எல்லாவற்றோடும் உப்பையும் படைப்பாயாக. ");
INSERT INTO tam2017_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“முதற்பலன்களை உணவுபலியாக நீ யெகோவாவுக்குச் செலுத்தவந்தால், புதிய பச்சையான கதிர்களை நெருப்பிலே வாட்டி உதிர்த்து, அதை உன் முதற்பலனின் உணவுபலியாகக் கொண்டுவரக்கடவாய். ");
INSERT INTO tam2017_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","அதின்மேல் எண்ணெய் ஊற்றி அதின்மேல் தூபவர்க்கத்தைப் போடுவாயாக; இது ஒரு உணவுபலி. ");
INSERT INTO tam2017_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","பின்பு ஆசாரியன், உதிர்த்த தானியத்திலும் எண்ணெயிலும் எடுத்து, நன்றியின் அடையாளமான பங்கை அதின் தூபவர்க்கம் எல்லாவற்றுடன் எரிக்கக்கடவன்; இது யெகோவாவுக்கு செலுத்தும் தகனபலி. ");
INSERT INTO tam2017_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ஒருவன் சமாதானபலியைப் படைக்கவேண்டுமென்று, மாட்டுமந்தையிலிருந்து எடுத்துச் செலுத்துவானாகில், அது காளையானாலும் பசுவானாலும் சரி, பழுது இல்லாமலிருப்பதை யெகோவாவுடைய சந்நிதியில் செலுத்தக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","அவன் தன் பலியின் தலைமேல் தன் கையை வைத்து, ஆசரிப்புக்கூடாரத்தின் வாசலுக்கு முன்பாக அதைக் கொல்லக்கடவன்; அப்பொழுது ஆரோனின் மகன்களாகிய ஆசாரியர்கள் அதின் இரத்தத்தைப் பலிபீடத்தின்மேல் சுற்றிலும் தெளிக்கக்கடவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","பின்பு சமாதான பலியிலே குடல்களை மூடிய கொழுப்பையும், குடல்களிலுள்ள கொழுப்பு முழுவதையும், ");
INSERT INTO tam2017_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","இரண்டு சிறுநீரகங்களையும், அவைகளின்மேல் சிறு குடல்களினிடத்தில் இருக்கிற கொழுப்பையும், சிறுநீரகங்களோடேகூடக் கல்லீரலின்மேல் இருக்கிற ஜவ்வையும் எடுத்து, யெகோவாவுக்குத் தகனபலியாகச் செலுத்துவானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","அதை ஆரோனின் மகன்கள் பலிபீடத்தின் நெருப்பிலுள்ள கட்டைகளின்மேல் வைக்கப்பட்டிருக்கும் சர்வாங்க தகனபலியின்மேல் போட்டு எரிக்கக்கடவர்கள்; இது யெகோவாவுக்கு நறுமண வாசனையான தகனபலி. ");
INSERT INTO tam2017_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“அவன் யெகோவாவுக்குச் சமாதானபலியைப் படைக்கவேண்டுமென்று ஆட்டு மந்தையிலிருந்து எடுத்துச் செலுத்துவானாகில், அது ஆணாக இருந்தாலும், பெண்ணாக இருந்தாலும் சரி, பழுது இல்லாமலிருப்பதைச் செலுத்துவானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","அவன் ஆட்டுக்குட்டியைப் பலியாகச் செலுத்தவேண்டுமானால், அதைக் யெகோவாவுடைய சந்நிதியில் கொண்டுவந்து, ");
INSERT INTO tam2017_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","தன் பலியின் தலைமேல் தன் கையை வைத்து, ஆசரிப்புக்கூடாரத்திற்கு முன்பாக அதைக் கொல்லக்கடவன்; அப்பொழுது ஆரோனின் மகன்கள் அதின் இரத்தத்தைப் பலிபீடத்தின்மேல் சுற்றிலும் தெளிக்கக்கடவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","பின்பு அவன் சமாதானபலியிலே அதின் கொழுப்பையும், நடு எலும்பிலிருந்து எடுத்த முழு வாலையும், குடல்களை மூடிய கொழுப்பையும் அவைகளின்மேல் இருக்கிற கொழுப்பு முழுவதையும், ");
INSERT INTO tam2017_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","இரண்டு சிறுநீரகங்களையும், அவைகளின்மேல் சிறு குடல்களினிடத்தில் இருக்கிற கொழுப்பையும், சிறுநீரகங்களோடேகூடக் கல்லீரலின்மேல் இருக்கிற ஜவ்வையும் எடுத்து, யெகோவாவுக்குத் தகனபலியாகச் செலுத்தக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","அதை ஆசாரியன் பலிபீடத்தின்மேல் எரிக்கக்கடவன்; இது யெகோவாவுக்குச் செலுத்தும் தகன ஆகாரம். ");
INSERT INTO tam2017_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“அவன் செலுத்துவது வெள்ளாடாக இருக்குமானால், அவன் அதைக் யெகோவாவுடைய சந்நிதியில் கொண்டுவந்து, ");
INSERT INTO tam2017_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","அதின் தலைமேல் தன் கையை வைத்து, ஆசரிப்புக்கூடாரத்திற்கு முன்பாக அதைக் கொல்லக்கடவன்; அப்பொழுது ஆரோனின் மகன்கள் அதின் இரத்தத்தைப் பலிபீடத்தின்மேல் சுற்றிலும் தெளிக்கக்கடவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","அவன் அதிலே குடல்களை மூடிய கொழுப்பையும், அவைகள் மேலிருக்கிற கொழுப்பு முழுவதையும், ");
INSERT INTO tam2017_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","இரண்டு சிறுநீரகங்களையும், அவைகளின்மேல் சிறு குடல்களினிடத்தில் இருக்கிற கொழுப்பையும், சிறுநீரகங்களோடேகூடக் கல்லீரலின்மேல் இருக்கிற ஜவ்வையும் எடுத்து, யெகோவாவுக்குத் தகனபலியாகச் செலுத்தக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","ஆசாரியன் பலிபீடத்தின்மேல் அவைகளை எரிக்கக்கடவன்; இது நறுமண வாசனையான தகன ஆகாரம்; கொழுப்பு முழுவதும் யெகோவாவுடையது. ");
INSERT INTO tam2017_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","கொழுப்பையாவது இரத்தத்தையாவது நீங்கள் சாப்பிடக்கூடாது; இது உங்களுடைய குடியிருப்புகள் எங்கும் உங்கள் தலைமுறைதோறும் நிரந்தரமான கட்டளையாக இருக்கும் என்று சொல் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“நீ இஸ்ரவேல் மக்களிடத்தில் சொல்லவேண்டியது என்னவென்றால், ஒருவன் யெகோவாவுடைய கட்டளைகளில் யாதொன்றை அறியாமையினால் மீறி, செய்யத்தகாததைச் செய்து பாவத்திற்கு உட்பட்டால் அறியவேண்டியதாவது: ");
INSERT INTO tam2017_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","அபிஷேகம் பெற்ற ஆசாரியன், மக்கள் குற்றத்திற்கு உட்படத்தக்கதாகப் பாவம் செய்தால், தான் செய்த பாவத்திற்காக பழுதற்ற ஒரு இளங்காளையை பாவநிவாரணபலியாகக் யெகோவாவுடைய சந்நிதியில் கொண்டுவரக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","அவன் அந்தக் காளையை ஆசரிப்புக்கூடாரத்தின் வாசலில் யெகோவாவுடைய சந்நிதியில் கொண்டுவந்து, அதின் தலைமேல் தன் கையை வைத்து, யெகோவாவுடைய சந்நிதியில் அதைக் கொல்லக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","அப்பொழுது, அபிஷேகம் பெற்ற ஆசாரியன் அந்தக் காளையின் இரத்தத்தில் கொஞ்சம் எடுத்து, அதை ஆசரிப்புக்கூடாரத்தில் கொண்டுவந்து, ");
INSERT INTO tam2017_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","தன் விரலை இரத்தத்தில் தோய்த்து, பரிசுத்த ஸ்தலத்தின் திரைக்கு எதிரே யெகோவாவுடைய சந்நிதியில் ஏழுமுறை தெளிக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","பின்பு, ஆசாரியன் அந்த இரத்தத்தில் கொஞ்சம் எடுத்து, ஆசரிப்புக்கூடாரத்திலே யெகோவாவுடைய சந்நிதியில் இருக்கும் நறுமண தூபபீடத்துக் கொம்புகளின்மேல் பூசி, காளையினுடைய மற்ற இரத்தம் முழுவதையும் ஆசரிப்புக்கூடாரத்தின் வாசலுக்கு முன்பாக இருக்கிற தகனபலிபீடத்தின் அடியிலே ஊற்றிவிட்டு, ");
INSERT INTO tam2017_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","பாவநிவாரணபலியான காளையின் எல்லாக் கொழுப்புமாகிய குடல்களை மூடிய கொழுப்பையும், அவைகள்மேல் இருக்கிற கொழுப்பு முழுவதையும், ");
INSERT INTO tam2017_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","இரண்டு சிறுநீரகங்களையும், அவைகள்மேல் சிறு குடல்களினிடத்தில் இருக்கிற கொழுப்பையும், சிறுநீரகங்களோடேகூடக் கல்லீரலின்மேல் இருக்கிற ஜவ்வையும், ");
INSERT INTO tam2017_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","சமாதானபலியின் காளையிலிருந்து எடுக்கிறதுபோல அதிலிருந்து எடுத்து, அவைகளைத் தகனபலிபீடத்தின்மேல் எரிக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","காளையின் தோலையும், அதின் மாம்சம் முழுவதையும், அதின் தலையையும், தொடைகளையும், அதின் குடல்களையும், அதின் சாணியையும், ");
INSERT INTO tam2017_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","காளை முழுவதையும் முகாமிற்கு வெளியே சாம்பல் கொட்டுகிற சுத்தமான இடத்திலே கொண்டுபோய், கட்டைகளின்மேல் போட்டு, நெருப்பிலே சுட்டெரிக்கக்கடவன்; சாம்பல் கொட்டப்பட்டிருக்கிற இடத்திலே அதைச் சுட்டெரிக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“கூடி வந்த இஸ்ரவேல் சபையார் எல்லோரும் அறியாமையினால் பாவம்செய்து, அது தங்களுடைய கண்களுக்கு மறைவாக இருக்கிறதினால், யெகோவாவுடைய கட்டளைகளில் யாதொன்றை மீறி, செய்யத்தகாததைச் செய்து, பாவத்திற்குட்பட்டுக் குற்றவாளிகளானால், ");
INSERT INTO tam2017_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","அவர்கள் செய்த பாவம் தெரியவரும்போது, சபையார் அந்தப் பாவத்திற்காக ஒரு இளங்காளையை ஆசரிப்புக்கூடாரத்திற்கு முன்பாக பலியிடக் கொண்டுவரவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","சபையின் மூப்பர்கள் யெகோவாவுடைய சந்நிதியில் தங்களுடைய கைகளை அதின் தலைமேல் வைக்கக்கடவர்கள்; பின்பு யெகோவாவுடைய சந்நிதியில் அந்தக் காளையைக் கொல்லவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","அப்பொழுது, அபிஷேகம் பெற்ற ஆசாரியன் அதின் இரத்தத்தில் கொஞ்சம் எடுத்து, ஆசரிப்புக்கூடாரத்தில் கொண்டுவந்து, ");
INSERT INTO tam2017_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","தன் விரலை இரத்தத்தில் தோய்த்து, யெகோவாவுடைய சந்நிதியில் திரைக்கு எதிரே ஏழுமுறை தெளித்து, ");
INSERT INTO tam2017_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","ஆசரிப்புக்கூடாரத்தில் யெகோவாவுடைய சந்நிதியில் இருக்கும் பலிபீடத்தின் கொம்புகளின்மேல் அந்த இரத்தத்தில் கொஞ்சம் பூசி, மற்ற இரத்தத்தை ஆசரிப்புக்கூடாரத்தின் வாசலில் இருக்கிற தகனபலிபீடத்தின் அடியிலே ஊற்றிவிட்டு, ");
INSERT INTO tam2017_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","அதின் கொழுப்பு முழுவதையும் அதிலிருந்து எடுத்து, பலிபீடத்தின்மேல் எரித்து, ");
INSERT INTO tam2017_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","பாவநிவாரணபலியின் காளையைச் செய்ததுபோலவே இந்தக் காளையையும் செய்து, இப்படியே ஆசாரியன் அவர்களுக்குப் பாவநிவிர்த்தி செய்யக்கடவன்; அப்பொழுது அது அவர்களுக்கு மன்னிக்கப்படும். ");
INSERT INTO tam2017_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","பின்பு காளையை முகாமிற்கு வெளியே கொண்டுபோய், முந்தின காளையைச் சுட்டெரித்ததுபோலச் சுட்டெரிக்கக்கடவன்; இது சபைக்காகச் செய்யப்படும் பாவநிவாரணபலி. ");
INSERT INTO tam2017_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ஒரு பிரபு தன் தேவனாகிய யெகோவாவுடைய கட்டளைகளில் யாதொன்றை மீறி, அறியாமையினால் செய்யத்தகாததைச் செய்து, பாவத்திற்குட்பட்டுக் குற்றவாளியானால், ");
INSERT INTO tam2017_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","தான் செய்தது பாவம் என்று தனக்குத் தெரியவரும்போது, அவன் வெள்ளாடுகளில் பழுதற்ற ஒரு இளங்கடாவைப் பலியாகக் கொண்டுவந்து, ");
INSERT INTO tam2017_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","அந்தக் கடாவின் தலையின்மேல் தன் கையை வைத்து, யெகோவாவுடைய சந்நிதியில் சர்வாங்கதகனபலி கொல்லப்படும் இடத்தில் அதைக் கொல்வானாக; இது பாவநிவாரணபலி. ");
INSERT INTO tam2017_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","அப்பொழுது ஆசாரியன் அதின் இரத்தத்தில் கொஞ்சம் தன் விரலால் எடுத்து, தகனபலிபீடத்துக் கொம்புகளின்மேல் பூசி, மற்ற இரத்தத்தைத் தகனபலிபீடத்தின் அடியிலே ஊற்றிவிட்டு, ");
INSERT INTO tam2017_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","அதின் கொழுப்பு முழுவதையும், சமாதானபலியின் கொழுப்பைப்போல, பலிபீடத்தின்மேல் எரித்து, இந்தவிதமாக ஆசாரியன் அவன் செய்த பாவத்தைக்குறித்து அவனுக்காகப் பாவநிவிர்த்தி செய்யக்கடவன்; அப்பொழுது அது அவனுக்கு மன்னிக்கப்படும். ");
INSERT INTO tam2017_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“சாதாரண மக்களில் ஒருவன் அறியாமையினால் யெகோவாவின் கட்டளைகளில் யாதொன்றை மீறி, செய்யத்தகாததைச் செய்து, பாவத்திற்குட்பட்டுக் குற்றவாளியானால், ");
INSERT INTO tam2017_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","தான் செய்தது பாவம் என்று தனக்குத் தெரியவரும்போது அவன் தான் செய்த பாவத்திற்காக வெள்ளாடுகளில் பழுதற்ற ஒரு பெண்குட்டியைப் பலியாகக் கொண்டுவந்து, ");
INSERT INTO tam2017_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","பாவநிவாரணபலியின் தலைமேல் தன் கையை வைத்து, சர்வாங்கதகனபலியிடும் இடத்தில் அந்தப் பாவநிவாரணபலியைக் கொல்லக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","அப்பொழுது ஆசாரியன் அதின் இரத்தத்தில் கொஞ்சம் தன் விரலால் எடுத்து, தகனபலிபீடத்துக் கொம்புகளின்மேல் பூசி, மற்ற இரத்தத்தை பலிபீடத்தின் அடியிலே ஊற்றிவிட்டு, ");
INSERT INTO tam2017_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","சமாதானபலியிலிருந்து கொழுப்பை எடுப்பதுபோல, அதின் கொழுப்பு முழுவதையும் எடுத்து, ஆசாரியன் பலிபீடத்தின்மேல் யெகோவாவுக்கு நறுமண வாசனையாக எரித்து, இப்படியே அவனுக்குப் பாவநிவிர்த்தி செய்யக்கடவன்; அப்பொழுது அது அவனுக்கு மன்னிக்கப்படும். ");
INSERT INTO tam2017_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“அவன் பாவநிவாரணபலியாக ஒரு ஆட்டுகுட்டியைக் கொண்டுவருவானாகில், பழுதற்ற பெண்குட்டியைக் கொண்டுவந்து, ");
INSERT INTO tam2017_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","அந்தப் பாவநிவாரணபலியின் தலைமேல் தன் கையை வைத்து, சர்வாங்கதகனபலி கொல்லப்படும் இடத்தில் அதைப் பாவநிவாரணபலியாகக் கொல்லக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","அப்பொழுது ஆசாரியன் அந்தப் பாவநிவாரணபலியின் இரத்தத்தில் கொஞ்சம் தன் விரலால் எடுத்து, தகனபலிபீடத்துக் கொம்புகளின்மேல் பூசி, மற்ற இரத்தத்தை பலிபீடத்தின் அடியிலே ஊற்றிவிட்டு, ");
INSERT INTO tam2017_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","சமாதானபலியான ஆட்டுக்குட்டியின் கொழுப்பை எடுக்கிறதுபோல அதின் கொழுப்பு முழுவதையும் எடுத்து, யெகோவாவுக்குச் செலுத்தப்படும் தகனபலிகளைப்போல, பலிபீடத்தின்மேல் ஆசாரியன் எரிக்கவேண்டும்; இந்தவிதமாக அவன் செய்த பாவத்திற்கு ஆசாரியன் பாவநிவிர்த்தி செய்யக்கடவன்; அப்பொழுது அது அவனுக்கு மன்னிக்கப்படும். ");
INSERT INTO tam2017_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“சாட்சியாகிய ஒருவன், இடப்பட்ட ஆணையைக் கேட்டிருந்தும், தான் கண்டதையும் அறிந்ததையும் தெரிவிக்காமலிருந்து பாவம்செய்தால், அவன் தன் அக்கிரமத்தைச் சுமப்பான். ");
INSERT INTO tam2017_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","அசுத்தமான காட்டு மிருகத்தின் உடலையாவது, அசுத்தமான நாட்டு மிருகத்தின் உடலையாவது, அசுத்தமான ஊரும் பிராணிகளின் உடலையாவது, இந்தவித அசுத்தமான யாதொரு பொருளையாவது, ஒருவன் அறியாமல் தொட்டால், அவன் தீட்டும் குற்றமும் உள்ளவனாவான். ");
INSERT INTO tam2017_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","அல்லது எந்த அசுத்தத்தினாலாகிலும் தீட்டுப்பட்ட ஒரு மனிதனை ஒருவன் அறியாமல் தொட்டு, பின்பு அதை அறிந்துகொண்டால், அவன் குற்றமுள்ளவனாவான். ");
INSERT INTO tam2017_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","மனிதர்கள் பதறி ஆணையிடும் எந்தக் காரியத்திலானாலும், ஒருவன் தீமை செய்கிறதற்காவது நன்மை செய்கிறதற்காவது, தன் மனம் அறியாமல், தன் உதடுகளினால் பதறி ஆணையிட்டு, பின்பு அவன் அதை அறிந்துகொண்டால், அதைக்குறித்துக் குற்றமுள்ளவனாவான். ");
INSERT INTO tam2017_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","இப்படிப்பட்டவைகள் ஒன்றில், ஒருவன் குற்றமுள்ளவனாகும்போது, அவன், தான் செய்தது பாவம் என்று அறிக்கையிட்டு, ");
INSERT INTO tam2017_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","தான் செய்த பாவத்திற்குப் பாவநிவாரணபலியாக, ஆடுகளிலாவது வெள்ளாடுகளிலாவது, ஒரு பெண்குட்டியைக் குற்றநிவாரணபலியாகக் யெகோவாவுடைய சந்நிதியில் கொண்டுவரவேண்டும்; அதினாலே ஆசாரியன் அவன் செய்த பாவத்தைக்குறித்து அவனுக்காகப் பாவநிவிர்த்தி செய்யக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ஆட்டுக்குட்டியைக் கொண்டுவர அவனுக்குச் சக்தியில்லாதிருந்தால், அவன் செய்த குற்றத்திற்காக இரண்டு காட்டுப்புறாக்களையாவது, இரண்டு புறாக்குஞ்சுகளையாவது, ஒன்றைப் பாவநிவாரணபலியாகவும் மற்றொன்றைச் சர்வாங்க தகனபலியாகவும், யெகோவாவுடைய சந்நிதியில் கொண்டுவரக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","அவைகளை ஆசாரியனிடத்தில் கொண்டுவருவானாக; அவன் பாவநிவாரணபலிக்குரியதை முதலில் செலுத்தி, அதின் தலையை அதின் கழுத்திலிருந்து கிள்ளி, அதை இரண்டாக்காமல் வைத்து, ");
INSERT INTO tam2017_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","அதின் இரத்தத்தில் கொஞ்சம் எடுத்து, பலிபீடத்தின் பக்கத்தில் தெளித்து, மீதியான இரத்தத்தைப் பலிபீடத்தின் அடியிலே வடியவிடுவானாக; இது பாவநிவாரணபலி. ");
INSERT INTO tam2017_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","மற்றதை நியமத்தின்படியே அவன் தகனபலியாகச் செலுத்தக்கடவன்; இந்தவிதமாக அவன் செய்த பாவத்தை ஆசாரியன் நிவிர்த்தி செய்யக்கடவன்; அப்பொழுது அது அவனுக்கு மன்னிக்கப்படும். ");
INSERT INTO tam2017_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“இரண்டு காட்டுப்புறாக்களையாவது இரண்டு புறாக்குஞ்சுகளையாவது கொண்டுவர அவனுக்குச் சக்தியில்லாதிருந்தால், பாவம் செய்தவன் பாவநிவாரணத்திற்காக ஒரு கிலோ அளவான மெல்லிய மாவிலே பத்தில் ஒரு பங்கைத் தன் காணிக்கையாகக் கொண்டுவருவானாக; அது பாவநிவாரணபலியாக இருப்பதினால், அதின்மேல் எண்ணெய் ஊற்றாமலும் தூபவர்க்கம் போடாமலும் இருந்து, ");
INSERT INTO tam2017_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","அதை ஆசாரியனிடத்தில் கொண்டுவரவேண்டும்; அதிலே ஆசாரியன் நன்றியின் அடையாளமான பங்காகத் தன் கைப்பிடி நிறைய எடுத்து, யெகோவாவுக்குச் செலுத்தும் தகனபலிகளைப்போல, பலிபீடத்தின்மேல் எரிக்கக்கடவன்; இது பாவநிவாரணபலி. ");
INSERT INTO tam2017_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","இந்தவிதமாக மேற்சொல்லிய காரியங்கள் ஒன்றில் அவன் செய்த பாவத்திற்காக ஆசாரியன் பாவநிவிர்த்தி செய்யக்கடவன்; அப்பொழுது அது அவனுக்கு மன்னிக்கப்படும், மீதியானது உணவுபலியைப்போல ஆசாரியனைச் சேரும் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“ஒருவன் யெகோவாவுக்குரிய பரிசுத்தமானவைகளில் குற்றம்செய்து, அறியாமையினால் பாவத்திற்குட்பட்டால், அவன் தன் குற்றத்திற்காக பரிசுத்த ஸ்தலத்துச் சேக்கல் கணக்கின்படியே, நீ அவன்மேல் சுமத்தும் அபராதம் எவ்வளவோ, அவ்வளவு வெள்ளிச் சேக்கல் மதிப்புள்ள பழுதற்ற ஒரு ஆட்டுக்கடாவை குற்றநிவாரணபலியாகக் யெகோவாவுடைய சந்நிதியில் கொண்டுவந்து, ");
INSERT INTO tam2017_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","பரிசுத்தமானதைக்குறித்துத் தான் செய்த குற்றத்தினால் உண்டான நஷ்டத்தைச் செலுத்தி, அத்துடன் ஐந்தில் ஒரு பங்கை அதிகமாகக் கூட்டி, ஆசாரியனுக்குக் கொடுப்பானாக; குற்றநிவாரணபலியாகிய ஆட்டுக்கடாவினாலே அவனுக்காக ஆசாரியன் பாவநிவிர்த்தி செய்யக்கடவன்; அப்பொழுது அது அவனுக்கு மன்னிக்கப்படும். ");
INSERT INTO tam2017_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“ஒருவன் செய்யத்தகாததென்று யெகோவாவுடைய கட்டளைகளினால் விலக்கப்பட்ட யாதொன்றைச் செய்து பாவத்திற்குட்பட்டால், அதை அவன் அறியாமையினால் செய்தாலும், அவன் குற்றமுள்ளவனாக இருந்து, தன் அக்கிரமத்தைச் சுமப்பான். ");
INSERT INTO tam2017_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","அதினால் அவன் குற்றநிவாரணபலியாக, உன் மதிப்பிற்குச் சரியான பழுதற்ற ஒரு ஆட்டுக்கடாவை ஆசாரியனிடத்தில் கொண்டுவருவானாக; அவன் அறியாமல் செய்த குற்றத்தை ஆசாரியன் அவனுக்காக நிவிர்த்தி செய்யக்கடவன்; அப்பொழுது அது அவனுக்கு மன்னிக்கப்படும். ");
INSERT INTO tam2017_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","இது குற்றநிவாரணபலி; அவன் யெகோவாவுக்கு விரோதமாகக் குற்றம்செய்தான் என்பது நிச்சயம் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“ஒருவன் யெகோவாவுக்கு விரோதமாக அநியாயம் செய்து, தன்னிடத்தில் ஒப்புவிக்கப்பட்ட பொருளிலாவது, கொடுக்கல் வாங்கலிலாவது, தன் அயலானை ஏமாற்றி, அல்லது ஒரு பொருளை வலுக்கட்டாயமாகப் பறித்துக்கொண்டு, அல்லது தன் அயலானுக்கு இடையூறுசெய்து, ");
INSERT INTO tam2017_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","அல்லது காணாமற்போனதைக் கண்டுபிடித்து அதை மறுதலித்து, அதைக்குறித்துப் பொய்யாக சத்தியம் செய்து, மனிதர்கள் செய்யும் இதைப்போல யாதொரு காரியத்தில் பாவம்செய்தான் என்றால், ");
INSERT INTO tam2017_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","அவன் செய்த பாவத்தினாலே குற்றவாளியானதால், தான் வலுக்கட்டாயமாகப் பறித்துக்கொண்டதையும், இடையூறுசெய்து பெற்றுக்கொண்டதையும், தன்னிடத்தில் ஒப்புவிக்கப்பட்டதையும், காணாமற்போயிருந்து தான் கண்டெடுத்ததையும், ");
INSERT INTO tam2017_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","பொய்யாக சத்தியம் செய்து சம்பாதித்த பொருளையும் திரும்பக் கொடுக்கக்கடவன்; அந்த முதலைக் கொடுக்கிறதும் அல்லாமல், அதனுடன் ஐந்தில் ஒரு பங்கு அதிகமாகவும் சேர்த்து, அதைத் தான் குற்றநிவாரணபலியை செலுத்தும் நாளில், அதற்குரியவனுக்குக் கொடுத்துவிட்டு, ");
INSERT INTO tam2017_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","தன் குற்றநிவாரணபலியாக, உன் மதிப்பீட்டுக்குச் சரியான பழுதற்ற ஆட்டுக்கடாவைக் யெகோவாவுக்குச் செலுத்த, அதை ஆசாரியனிடத்தில் குற்றநிவாரணபலியாகக் கொண்டுவருவானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","யெகோவாவுடைய சந்நிதியில் அவனுடைய பாவத்தை ஆசாரியன் நிவிர்த்திசெய்வானாக; அப்பொழுது, அவனைக் குற்றவாளியாக்கிய அப்படிப்பட்ட எந்தக்காரியமும் அவனுக்கு மன்னிக்கப்படும் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“நீ ஆரோனுக்கும் அவனுடைய மகன்களுக்கும் கற்பிக்கவேண்டிய சர்வாங்க தகனபலிக்குரிய விதிமுறைகள் என்னவென்றால், சர்வாங்க தகனபலியானது இரவுமுதல் விடியற்காலம்வரை பலிபீடத்தின்மேல் எரியவேண்டும்; பலிபீடத்தின் மேலுள்ள நெருப்பு எரிந்துகொண்டே இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","ஆசாரியன் சணல்நூல் உள்ளாடையை தன் இடுப்பில் போட்டுக்கொண்டு, சணல்நூல் அங்கியை அணிந்து, பலிபீடத்தின்மேல் நெருப்பில் எரிந்த சர்வாங்க தகனபலியின் சாம்பலை எடுத்து, பலிபீடத்தின் அருகில் கொட்டி, ");
INSERT INTO tam2017_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","பின்பு தன் உடைகளைக் கழற்றி, வேறு உடைகளை அணிந்துகொண்டு, அந்தச் சாம்பலை முகாமிற்கு வெளியே சுத்தமான ஒரு இடத்திலே கொண்டுபோய்க் கொட்டக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","பலிபீடத்தின்மேலிருக்கிற நெருப்பு அணையாமல் எரிந்துகொண்டிருக்கவேண்டும்; ஆசாரியன் காலைதோறும் அதின்மேல் எரியும்படி கட்டைகளைப் போட்டு, அதின்மேல் சர்வாங்க தகனபலியை வரிசையாக வைத்து, அதின்மேல் சமாதானபலிகளின் கொழுப்பைப் போட்டு எரிக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","பலிபீடத்தின்மேல் நெருப்பு எப்பொழுதும் எரிந்துகொண்டிருக்கவேண்டும்; அது ஒருபோதும் அணைந்துபோகக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“உணவுபலியின் விதிமுறைகள் என்னவென்றால், ஆரோனின் மகன்கள் அதைக் யெகோவாவுடைய சந்நிதியில் பலிபீடத்திற்கு முன்னே படைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","அவன், உணவுபலியின் மெல்லிய மாவிலும் அதின் எண்ணெயிலும் தன் கைப்பிடி நிறைய எடுத்து, உணவுபலியின்மேலுள்ள தூபவர்க்கம் யாவற்றோடும் கூட அதை நன்றியின் அடையாளமாகப் பலிபீடத்தின்மேல் யெகோவாவுக்கு நறுமண வாசனையாக எரிக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","அதில் மீதியானதை ஆரோனும் அவனுடைய மகன்களும் சாப்பிடுவார்களாக; அதை புளிப்பில்லாத அப்பத்துடன் பரிசுத்த ஸ்தலத்தில் சாப்பிடவேண்டும்; ஆசரிப்புக்கூடாரத்தின் பிராகாரத்தில் அதைச் சாப்பிடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","அதைப் புளித்தமாவுள்ளதாக வேகவைக்கவேண்டாம்; அது எனக்கு செலுத்தப்படும் தகனங்களில் நான் அவர்களுக்குக் கொடுத்த அவர்களுடைய பங்கு; அது பாவநிவாரண பலியைப்போலவும் குற்றநிவாரணபலியைப் போலவும் மகா பரிசுத்தமானது. ");
INSERT INTO tam2017_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","ஆரோனின் சந்ததியில் ஆண்மக்கள் அனைவரும் அதைச் சாப்பிடுவார்களாக; யெகோவாவுக்கு செலுத்தப்படும் தகனபலிகளில் அது உங்கள் தலைமுறைதோறும் நிரந்தரமான கட்டளையாக இருப்பதாக; அவைகளைத் தொடுகிறவனெவனும் பரிசுத்தமாக இருப்பான்” என்று சொல் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“ஆரோன் அபிஷேகம் செய்யப்படும் நாளில், அவனும் அவனுடைய மகன்களும் யெகோவாவுக்குச் செலுத்தவேண்டிய படைப்பு என்னவென்றால், ஒரு எப்பா அளவான மெல்லிய மாவிலே பத்தில் ஒரு பங்கை, காலையில் பாதியும் மாலையில் பாதியும், நிரந்தரமான உணவுபலியாகச் செலுத்தக்கடவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","அது பாத்திரத்திலே எண்ணெய்விட்டு வேகவைக்கவேண்டும்; வேகவைத்தபின்பு அதைக் கொண்டுவந்து, உணவுபலியாக யெகோவாவுக்கு நறுமண வாசனையாகப் படைக்கக்கடவாய். ");
INSERT INTO tam2017_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","அவனுடைய மகன்களில் அவனுடைய இடத்திலே அபிஷேகம்செய்யப்படுகிற ஆசாரியனும் அப்படியே செய்யக்கடவன்; அது முழுவதும் எரிக்கப்படவேண்டும்; அது யெகோவா ஏற்படுத்தின நிரந்தரமான கட்டளை. ");
INSERT INTO tam2017_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","ஆசாரியனுக்காக செலுத்தப்படும் எந்த உணவுபலியும் சாப்பிடாமல், முழுவதும் எரிக்கப்படவேண்டும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“நீ ஆரோனோடும் அவனுடைய மகன்களோடும் சொல்லவேண்டியதாவது, பாவநிவாரணபலியின் விதிமுறைகள் என்னவென்றால், சர்வாங்கதகனபலி கொல்லப்படும் இடத்தில் பாவநிவாரணபலியும் யெகோவாவுடைய சந்நிதியில் கொல்லப்படக்கடவது; அது மகா பரிசுத்தமானது. ");
INSERT INTO tam2017_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","பாவநிவிர்த்திசெய்ய அதைப் பலியிடுகிற ஆசாரியன் அதைச் சாப்பிடுவானாக; ஆசரிப்புக்கூடாரத்தின் பிராகாரமாகிய பரிசுத்த ஸ்தலத்திலே அது சாப்பிடப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","அதின் மாம்சத்தில் படுகிறது எதுவும் பரிசுத்தமாக இருக்கும்; அதின் இரத்தத்திலே கொஞ்சம் ஒரு உடையில் தெறித்ததென்றால், இரத்தம்தெறித்த உடையைப் பரிசுத்த ஸ்தலத்தில் கழுவவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","அது சமைக்கப்பட்ட மண்பானை உடைக்கப்படவேண்டும்; செப்புப்பானையில் சமைக்கப்பட்டால், அது விளக்கப்பட்டுத் தண்ணீரில் கழுவப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","ஆசாரியர்களில் ஆண்மக்கள் அனைவரும் அதைச் சாப்பிடுவார்களாக; அது மகா பரிசுத்தமானது. ");
INSERT INTO tam2017_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","எந்தப் பாவநிவாரணபலியின் இரத்தத்தில் கொஞ்சம் பரிசுத்த ஸ்தலத்தில் பாவநிவிர்த்திக்காக ஆசரிப்புக்கூடாரத்திற்குள்ளே கொண்டுவரப்பட்டதோ, அந்தப் பலியைச் சாப்பிடக்கூடாது, அது நெருப்பிலே எரிக்கப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“குற்றநிவாரணபலியின் விதிமுறைகள் என்னவென்றால், அது மகா பரிசுத்தமானது. ");
INSERT INTO tam2017_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","சர்வாங்க தகனபலி கொல்லப்படும் இடத்தில், குற்றநிவாரணபலியும் கொல்லப்படவேண்டும்; அதின் இரத்தத்தைப் பலிபீடத்தின்மேல் சுற்றிலும் தெளித்து, ");
INSERT INTO tam2017_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","அதினுடைய கொழுப்பு முழுவதையும், அதின் வாலையும், குடல்களை மூடிய கொழுப்பையும், ");
INSERT INTO tam2017_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","இரண்டு சிறுநீரகங்களையும், அவைகளின்மேல் சிறுகுடல்களினிடத்திலிருக்கிற கொழுப்பையும், சிறுநீரகங்களோடேகூடக் கல்லீரலின்மேல் இருக்கிற ஜவ்வையும் எடுத்துச் செலுத்துவானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","இவைகளை ஆசாரியன் பலிபீடத்தின்மேல் யெகோவாவுக்குத் தகனபலியாக எரிக்கக்கடவன்; அது குற்றநிவாரணபலி. ");
INSERT INTO tam2017_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","ஆசாரியர்களில் ஆண்மக்கள் அனைவரும் அதைச் சாப்பிடுவார்களாக; அது பரிசுத்த ஸ்தலத்தில் சாப்பிடப்படவேண்டும்; அது மகா பரிசுத்தமானது. ");
INSERT INTO tam2017_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","பாவநிவாரணபலி எப்படியோ குற்றநிவாரணபலியும் அப்படியே; அந்த இரண்டிற்கும் விதிமுறை ஒன்றே; அதினாலே பாவநிவிர்த்தி செய்த ஆசாரியனை அது சேரும். ");
INSERT INTO tam2017_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","ஒருவருடைய சர்வாங்க தகனபலியைச் செலுத்தின ஆசாரியன் தான் செலுத்தின தகனபலியின் தோலைத் தனக்காக வைத்துக்கொள்ளவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","அடுப்பிலே வேகவைக்கப்பட்டதும், பாத்திரத்திலும் தட்டின்மேலும் சமைக்கப்பட்டதுமான உணவுபலி அனைத்தும் அதைச் செலுத்துகிற ஆசாரியனுடையவைகளாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","எண்ணெயிலே பிசைந்ததும் எண்ணெயிலே பிசையாததுமான சகல உணவுபலியும் ஆரோனுடைய மகன்கள் அனைவருக்கும் சரிபங்காகச் சேரவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“யெகோவாவுக்குச் செலுத்துகிற சமாதானபலிகளின் விதிமுறைகள் என்னவென்றால், ");
INSERT INTO tam2017_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","அதை நன்றிபலியாகச் செலுத்துவானானால், அவன் நன்றிபலியோடுகூட எண்ணெயிலே பிசைந்த புளிப்பில்லாத அதிரசங்களையும், எண்ணெய் பூசப்பட்ட புளிப்பில்லாத அடைகளையும், எண்ணெயிலே பிசைந்து வறுக்கப்பட்ட மெல்லிய மாவினால் செய்த அதிரசங்களையும் படைக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","அவைகளைப் படைக்கிறதும் அல்லாமல், புளித்தமாவினால் செய்த அப்பத்தையும், தன்னுடைய சமாதானபலியாகிய நன்றிபலியோடுகூட படைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","அந்தப் படைப்பு முழுவதிலும் வகைக்கு ஒவ்வொன்றை எடுத்துக் யெகோவாவுக்கு ஏறெடுத்துப் படைக்கும் பலியாகச் செலுத்துவானாக; அது சமாதானபலியின் இரத்தத்தைத் தெளித்த ஆசாரியனுடையதாகும். ");
INSERT INTO tam2017_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","சமாதானபலியாகிய நன்றிபலியின் மாம்சமானது செலுத்தப்பட்ட அன்றையதினமே சாப்பிடப்படவேண்டும்; அதில் ஒன்றும் விடியற்காலம்வரை வைக்கப்படக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","அவன் செலுத்தும் பலி பொருத்தனையாகவோ உற்சாகபலியாகவோ இருக்குமானால், அது செலுத்தப்படும் நாளிலும், அதில் மீதியானது மறுநாளிலும் சாப்பிடப்படலாம். ");
INSERT INTO tam2017_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","பலியின் மாம்சத்தில் மீதியாக இருக்கிறது மூன்றாம் நாளில் நெருப்பிலே சுட்டெரிக்கப்படக்கடவது. ");
INSERT INTO tam2017_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","சமாதானபலியின் மாம்சத்தில் மீதியானது மூன்றாம் நாளில் சாப்பிடப்படுமானால், அது அங்கீகரிக்கப்படாது; அதைச் செலுத்தினவனுக்கு அது பலிக்காது; அது அருவருப்பாயிருக்கும்; அதைச் சாப்பிடுகிறவன் தன் அக்கிரமத்தைச் சுமப்பான். ");
INSERT INTO tam2017_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“தீட்டான எந்த பொருளிலாவது அந்த மாம்சம் பட்டதானால் அது சாப்பிடப்படாமல் நெருப்பிலே சுட்டெரிக்கப்படக்கடவது; மற்ற மாம்சத்தையோ சுத்தமாக இருக்கிறவனெவனும் சாப்பிடலாம். ");
INSERT INTO tam2017_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ஒருவன் தீட்டுள்ளவனாக இருக்கும்போது யெகோவாவுடைய சமாதானபலியின் மாம்சத்தைச் சாப்பிட்டால், அவன் தன் மக்களுக்குள் இல்லாதபடி வெட்டுண்டுபோவான். ");
INSERT INTO tam2017_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","மனிதர்களுடைய தீட்டையாவது, தீட்டான மிருகத்தையாவது, அருவருக்கப்படத்தக்க தீட்டான மற்ற எந்த பொருளையாவது ஒருவன் தொட்டிருந்து, யெகோவாவுடைய சமாதானபலியின் மாம்சத்திலே சாப்பிட்டால், அவன் தன் மக்களுக்குள் இல்லாதபடி அறுப்புண்டுபோவான்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“நீ இஸ்ரவேல் மக்களிடம் சொல்லவேண்டியது என்னவென்றால், மாடு, ஆடு, வெள்ளாடு என்பவைகளின் கொழுப்பை நீங்கள் சாப்பிடக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","தானாகச் செத்த மிருகத்தின் கொழுப்பையும், தாக்கப்பட்ட மிருகத்தின் கொழுப்பையும் பலவித வேலைகளுக்குப் பயன்படுத்தலாம்; ஆனாலும் நீங்கள் அதை ஒருபோதும் சாப்பிடக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","யெகோவாவுக்குத் தகனபலியாகச் செலுத்தப்படும் மிருகத்தின் கொழுப்பைச் சாப்பிடுகிற எந்த ஆத்துமாவும் தன் மக்களுக்குள் இல்லாதபடி அறுப்புண்டுபோவான். ");
INSERT INTO tam2017_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","உங்கள் குடியிருப்புகளில் எங்கும் யாதொரு பறவையின் இரத்தத்தையாவது, யாதொரு மிருகத்தின் இரத்தத்தையாவது சாப்பிடக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","எவ்வித இரத்தத்தையாவது சாப்பிடுகிற எவனும் தன் மக்களில் இல்லாதபடி அறுப்புண்டுபோவான் என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“நீ இஸ்ரவேல் மக்களிடம் சொல்லவேண்டியது என்னவென்றால், யெகோவாவுக்குச் சமாதானபலி செலுத்துகிறவன் தான் செலுத்தும் சமாதானபலியைக் யெகோவாவுடைய சந்நிதியில் கொண்டுவருவானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","யெகோவாவுக்குத் தகனபலியாகப் படைப்பவைகளை அவனே கொண்டுவரவேண்டும்; மார்புப்பகுதியையும் அதனுடன் அதின்மேல் வைத்த கொழுப்பையும் யெகோவாவுடைய சந்நிதியில் அசைவாட்டும் பலியாக அசைவாட்டும்படிக் கொண்டுவரக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","அப்பொழுது ஆசாரியன் அந்தக் கொழுப்பைப் பலிபீடத்தின்மேல் எரிக்கவேண்டும்; மார்புப்பகுதி ஆரோனையும் அவனுடைய மகன்களையும் சேரும். ");
INSERT INTO tam2017_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","உங்கள் சமாதானபலிகளில் வலது முன்னந்தொடையை ஏறெடுத்துப்படைக்கும் பலியாகப் படைக்கும்படி ஆசாரியனிடத்தில் கொடுப்பீர்களாக. ");
INSERT INTO tam2017_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","ஆரோனுடைய மகன்களில், சமாதானபலியின் இரத்தத்தையும் கொழுப்பையும் செலுத்துகிறவனுக்கு, வலது முன்னந்தொடை பங்காகச் சேரும். ");
INSERT INTO tam2017_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","இஸ்ரவேல் மக்களின் சமாதானபலிகளில் அசைவாட்டும் மார்புப்பகுதியையும் ஏறெடுத்துப்படைக்கும் முன்னந்தொடையையும் நான் அவர்கள் கையில் வாங்கி, அவைகளை ஆசாரியனாகிய ஆரோனுக்கும் அவனுடைய மகன்களுக்கும் இஸ்ரவேல் மக்களுக்குள் இருக்கும் நிரந்தரமான கட்டளையாகக் கொடுத்தேன் என்று சொல் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","“யெகோவாவுக்கு ஆசாரிய ஊழியம் செய்யும்படி ஆரோனும் அவனுடைய மகன்களும் நியமிக்கப்பட்ட நாளிலே, இது அபிஷேகம் செய்யப்பட்ட அவர்களுக்குக் யெகோவாவுடைய தகனபலிகளில் கிடைக்கும்படி உண்டான கட்டளை. ");
INSERT INTO tam2017_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","இப்படி அவர்களுக்கு இஸ்ரவேல் மக்கள் தங்கள் தலைமுறைதோறும் நிரந்தரமான நியமமாகக் கொடுக்கும்படிக் யெகோவா அவர்களை அபிஷேகம்செய்த நாளிலே கட்டளையிட்டார். ");
INSERT INTO tam2017_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","சர்வாங்கதகனபலிக்கும் உணவுபலிக்கும் பாவநிவாரணபலிக்கும் குற்றநிவாரணபலிக்கும் பிரதிஷ்டைபலிகளுக்கும் சமாதானபலிகளுக்கும் உரிய விதிமுறைகள் இதுவே. ");
INSERT INTO tam2017_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","யெகோவாவுக்குத் தங்கள் பலிகளைச் செலுத்தவேண்டும் என்று அவர் இஸ்ரவேல் மக்களுக்குச் சீனாய் வனாந்திரத்திலே கற்பிக்கும்போது இவைகளை மோசேக்குச் சீனாய்மலையில் கட்டளையிட்டார். ");
INSERT INTO tam2017_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“நீ ஆரோனையும் அவனுடைய மகன்களையும் வரவழைத்து, உடைகளையும், அபிஷேகத் தைலத்தையும், பாவநிவாரணபலிக்கு ஒரு காளையையும், இரண்டு ஆட்டுக்கடாக்களையும், ஒரு கூடையில் புளிப்பில்லாத அப்பங்களையும் கொண்டுவந்து, ");
INSERT INTO tam2017_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","சபையையெல்லாம் ஆசரிப்புக்கூடாரத்தின் வாசலுக்கு முன்பாகக் கூடிவரச்செய்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","யெகோவா தனக்குக் கட்டளையிட்டபடியே மோசே செய்தான்; சபை ஆசரிப்புக்கூடாரத்தின் வாசலுக்கு முன்பாகக் கூடினபோது, ");
INSERT INTO tam2017_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","மோசே சபையை நோக்கி: “செய்யும்படி யெகோவா கட்டளையிட்ட காரியம் இதுவே என்று சொல்லி, ");
INSERT INTO tam2017_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","யெகோவா தனக்குக் கட்டளையிட்டபடியே மோசே, ஆரோனையும் அவனுடைய மகன்களையும் வரவழைத்து, அவர்களைத் தண்ணீரில் குளிக்கச்செய்து, ");
INSERT INTO tam2017_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","அவனுக்கு உள் அங்கியைப் போட்டு, இடுப்புக்கச்சையைக் கட்டி, மேலங்கியை உடுத்தி, ஏபோத்தை அணிவித்து, அதின்மேல் ஏபோத்தின் விசேஷமான கச்சையைக்கட்டி, ");
INSERT INTO tam2017_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","அவனுக்கு மார்ப்பதக்கத்தை அணிவித்து, மார்ப்பதக்கத்திலே ஊரீம், தும்மீம் என்பவைகளையும் வைத்து, ");
INSERT INTO tam2017_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","அவன் தலையிலே தலைப்பாகையை அணிவித்து, தலைப்பாகையின்மேல் அவன் நெற்றியிலே பரிசுத்த கிரீடம் என்னும் பொற்பட்டத்தைக் கட்டினான். ");
INSERT INTO tam2017_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","பின்பு மோசே, அபிஷேகத் தைலத்தை எடுத்து, வாசஸ்தலத்தையும் அதிலுள்ள அனைத்தையும் அபிஷேகம்செய்து, பரிசுத்தப்படுத்தி, ");
INSERT INTO tam2017_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","அதில் கொஞ்சம் எடுத்து, பலிபீடத்தின்மேல் ஏழுமுறை தெளித்து, பலிபீடத்தையும் அதின் சகல பொருட்களையும், தொட்டியையும் அதின் பாதத்தையும் பரிசுத்தப்படுத்தும்படி அபிஷேகம்செய்து, ");
INSERT INTO tam2017_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","அபிஷேகத் தைலத்திலே கொஞ்சம் ஆரோனுடைய தலையின்மேல் ஊற்றி அவனைப் பரிசுத்தப்படுத்தும்படி அபிஷேகம்செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","பின்பு மோசே, யெகோவா தனக்குக் கட்டளையிட்டபடியே, ஆரோனின் மகன்களை வரவழைத்து, அவர்களுக்கு அங்கிகளை உடுத்தி, இடுப்புக்கச்சைகளைக் கட்டி, குல்லாக்களை அணிவித்து, ");
INSERT INTO tam2017_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","பாவநிவாரணபலிக்கான காளையைக் கொண்டுவந்தான்; அதினுடைய தலையின்மேல் ஆரோனும் அவனுடைய மகன்களும் தங்கள் கைகளை வைத்தார்கள்; ");
INSERT INTO tam2017_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","அப்பொழுது அது கொல்லப்பட்டது; மோசே அதின் இரத்தத்தை எடுத்து, தன் விரலினால் பலிபீடத்தின் கொம்புகளின்மேல் சுற்றிலும் பூசி, பலிபீடத்திற்காக சுத்திகரிப்புசெய்து, மற்ற இரத்தத்தைப் பலிபீடத்தின் அடியில் ஊற்றிவிட்டு, அதின்மேல் பாவநிவிர்த்தி செய்வதற்காக அதைப் பரிசுத்தப்படுத்தினான். ");
INSERT INTO tam2017_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","பின்பு மோசே, யெகோவா தனக்குக் கட்டளையிட்டபடியே, குடல்களின்மேல் இருந்த கொழுப்பு முழுவதையும், கல்லீரலின்மேல் இருந்த ஜவ்வையும், இரண்டு சிறுநீரகங்களையும், அவைகளின் கொழுப்பையும் எடுத்து, பலிபீடத்தின்மேல் எரித்து, ");
INSERT INTO tam2017_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","காளையையும் அதின் தோலையும் மாம்சத்தையும் சாணியையும் முகாமிற்கு வெளியே நெருப்பிலே சுட்டெரித்தான். ");
INSERT INTO tam2017_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","பின்பு அவன் சர்வாங்க தகனபலிக்கு ஆட்டுக்கடாவைக் கொண்டுவந்தான்; அதின் தலையின்மேல் ஆரோனும் அவனுடைய மகன்களும் தங்கள் கைகளை வைத்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","அப்பொழுது அது கொல்லப்பட்டது; மோசே அதின் இரத்தத்தைப் பலிபீடத்தின்மேல் சுற்றிலும் தெளித்தான். ");
INSERT INTO tam2017_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","ஆட்டுக்கடா துண்டுதுண்டாக வெட்டப்பட்டது; யெகோவா தனக்குக் கட்டளையிட்டபடியே, மோசே அதின் தலையையும் துண்டுகளையும் கொழுப்பையும் எரித்தான். ");
INSERT INTO tam2017_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","குடல்களையும் தொடைகளையும் தண்ணீரால் கழுவினபின், மோசே ஆட்டுக்கடா முழுவதையும் பலிபீடத்தின்மேல் யெகோவாவுடைய நறுமண வாசனைக்கான சர்வாங்க தகனபலியாக எரித்தான். ");
INSERT INTO tam2017_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","பின்பு பிரதிஷ்டைப்படுத்துவதற்குரிய மற்ற ஆட்டுக்கடாவைக் கொண்டுவந்தான்; அதின் தலையின்மேல் ஆரோனும் அவனுடைய மகன்களும் தங்கள் கைகளை வைத்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","பின்பு அது கொல்லப்பட்டது; மோசே அதின் இரத்தத்தில் கொஞ்சம் எடுத்து, ஆரோனுடைய வலதுகாதின் மடலிலும் வலதுகையின் பெருவிரலிலும் வலதுகாலின் பெருவிரலிலும் பூசினான். ");
INSERT INTO tam2017_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","பின்பு ஆரோனுடைய மகன்களையும் அழைத்தான்; மோசே அந்த இரத்தத்திலே கொஞ்சம் அவர்களுடைய வலதுகாதின் மடலிலும் வலதுகையின் பெருவிரலிலும் வலதுகாலின் பெருவிரலிலும் பூசி, இரத்தத்தைப் பலிபீடத்தின்மேல் சுற்றிலும் தெளித்து, ");
INSERT INTO tam2017_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","கொழுப்பையும், வாலையும், குடல்களின்மேல் இருந்த கொழுப்பு முழுவதையும், கல்லீரலின்மேல் இருந்த ஜவ்வையும், இரண்டு சிறுநீரகங்களையும், அவைகளின் கொழுப்பையும், வலது முன்னந்தொடையையும் எடுத்து, ");
INSERT INTO tam2017_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","யெகோவாவுடைய சந்நிதியில் வைத்திருந்த புளிப்பில்லாத அப்பங்களின் கூடையிலுள்ள புளிப்பில்லாத அதிரசத்தில் ஒன்றையும், எண்ணெயிட்ட அப்பமாகிய அதிரசத்தில் ஒன்றையும், ஒரு அடையையும் எடுத்து, அந்தக் கொழுப்பின்மேலும், முன்னந்தொடையின்மேலும் வைத்து, ");
INSERT INTO tam2017_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","அவைகளையெல்லாம் ஆரோனுடைய உள்ளங்கைகளிலும் அவன் மகன்களுடைய உள்ளங்கைகளிலும் வைத்து, அசைவாட்டும் பலியாகக் யெகோவாவுடைய சந்நிதியில் அசைவாட்டி, ");
INSERT INTO tam2017_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","பின்பு மோசே அவைகளை அவர்கள் உள்ளங்கைகளிலிருந்து எடுத்து, பலிபீடத்தின்மேலிருக்கிற தகனபலியின்மேல் எரித்தான்; அவைகள் நறுமண வாசனையான பிரதிஷ்டை பலிகள்; இது யெகோவாவுக்குத் தகனபலியானது. ");
INSERT INTO tam2017_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","பின்பு மோசே மார்புப்பகுதியை எடுத்து, அதைக் யெகோவாவுடைய சந்நிதியில் அசைவாட்டும் பலியாக அசைவாட்டினான். யெகோவா மோசேக்குக் கட்டளையிட்டபடியே பிரதிஷ்டையின் ஆட்டுக்கடாவிலே அது மோசேயின் பங்கானது. ");
INSERT INTO tam2017_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","மோசே அபிஷேகத்தைலத்திலும், பலிபீடத்தின்மேல் இருந்த இரத்தத்திலும் கொஞ்சம் எடுத்து, ஆரோன்மேலும் அவனுடைய உடைகளின்மேலும், அவனுடைய மகன்கள்மேலும் அவர்களுடைய உடைகளின்மேலும் தெளித்து, ஆரோனையும் அவனுடைய உடைகளையும், அவனுடைய மகன்களையும், அவனுடைய மகன்களின் உடைகளையும் பரிசுத்தப்படுத்தினான். ");
INSERT INTO tam2017_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","பின்பு மோசே ஆரோனையும் அவனுடைய மகன்களையும் நோக்கி: “நீங்கள் அந்த மாம்சத்தை ஆசரிப்புக்கூடாரத்தின் வாசலிலே வேகவைத்து, ஆரோனும் அவனுடைய மகன்களும், அதைச் சாப்பிடுவார்களாக என்று கட்டளையிட்டிருக்கிறபடியே, அங்கே அதையும் உங்கள் பிரதிஷ்டைப் பலிகளுள்ள கூடையில் இருக்கிற அப்பத்தையும் சாப்பிட்டு, ");
INSERT INTO tam2017_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","மாம்சத்திலும் அப்பத்திலும் மீதியானதை நெருப்பிலே சுட்டெரித்து, ");
INSERT INTO tam2017_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","பிரதிஷ்டையின் நாட்கள் நிறைவேறும்வரைக்கும், ஏழுநாட்கள் ஆசரிப்புக்கூடாரத்தின் வாசலைவிட்டுப் புறப்படாதிருங்கள்; ஏழுநாட்களும் நீங்கள் பிரதிஷ்டை செய்யப்படுவீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","இன்று செய்ததுபோல, உங்கள் பாவநிவிர்த்திக்காக இனிமேலும் செய்யவேண்டும் என்று யெகோவா கட்டளையிட்டார். ");
INSERT INTO tam2017_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","நீங்கள் மரணமடையாதிருக்க ஏழுநாட்கள் இரவும் பகலும் ஆசரிப்புக்கூடாரத்தின் வாசலிலிருந்து யெகோவாவுடைய காவலைக் காக்கக்கடவீர்கள்; இப்படி நான் போதிக்கப்பட்டேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","யெகோவா மோசேயைக்கொண்டு கட்டளையிட்ட எல்லாக் காரியங்களையும் ஆரோனும் அவனுடைய மகன்களும் செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","எட்டாம் நாளிலே மோசே, ஆரோனையும் அவனுடைய மகன்களையும் இஸ்ரவேலின் மூப்பர்களையும் அழைத்து, ");
INSERT INTO tam2017_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","ஆரோனை நோக்கி: “நீ பாவநிவாரணபலியாக பழுதற்ற ஒரு கன்றுக்குட்டியையும், சர்வாங்க தகனபலியாக பழுதற்ற ஒரு ஆட்டுக்கடாவையும் தெரிந்துகொண்டு, யெகோவாவுடைய சந்நிதியில் பலியிடக்கடவாய். ");
INSERT INTO tam2017_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","மேலும் இஸ்ரவேல் மக்களை நோக்கி: யெகோவாவுடைய சந்நிதியில் பலியிடும்படி, நீங்கள் பாவநிவாரணபலியாக பழுதற்ற ஒரு வெள்ளாட்டுக்கடாவையும், சர்வாங்க தகனபலியாக ஒருவயதுடைய பழுதற்ற ஒரு கன்றுக்குட்டியையும், ஒரு ஆட்டுக்குட்டியையும், ");
INSERT INTO tam2017_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","சமாதானபலிகளாக ஒரு காளையையும், ஒரு ஆட்டுக்கடாவையும், எண்ணெயிலே பிசைந்த உணவுபலியையும் கொண்டுவாருங்கள்; இன்று யெகோவா உங்களுக்குக் காட்சியளிப்பார் என்று சொல்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","மோசே கட்டளையிட்டவைகளை அவர்கள் ஆசரிப்புக்கூடாரத்திற்கு முன்பாகக் கொண்டுவந்தார்கள். சபையார் எல்லோரும் சேர்ந்து, யெகோவாவுடைய சந்நிதியில் நின்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","அப்பொழுது மோசே: “யெகோவா கட்டளையிட்ட இந்தக் காரியத்தைச் செய்யுங்கள்; யெகோவாவுடைய மகிமை உங்களுக்குக் காணப்படும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","மோசே ஆரோனை நோக்கி: “நீ பலிபீடத்தின் அருகில் வந்து, யெகோவா கட்டளையிட்டபடியே, உன் பாவநிவாரணபலியையும் உன் சர்வாங்க தகனபலியையும் செலுத்தி, உனக்காகவும் மக்களுக்காகவும் பாவநிவிர்த்தி செய்து, மக்களுடைய பலியையும் செலுத்தி, அவர்களுக்காகவும் பாவநிவிர்த்தி செய்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","அப்பொழுது ஆரோன் பலிபீடத்தின் அருகில் வந்து, தன் பாவநிவாரணபலியாகிய கன்றுக்குட்டியைக் கொன்றான். ");
INSERT INTO tam2017_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","ஆரோனின் மகன்கள் அதின் இரத்தத்தை அவனிடத்தில் கொண்டுவந்தார்கள்; அவன் தன் விரலை அந்த இரத்தத்தில் நனைத்து, பலிபீடத்தின் கொம்புகளின் மேல் பூசி, மற்ற இரத்தத்தைப் பலிபீடத்தின் அடியிலே ஊற்றி, ");
INSERT INTO tam2017_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","பாவநிவாரணபலியின் கொழுப்பையும், சிறுநீரகங்களையும், கல்லீரலில் எடுத்த ஜவ்வையும், யெகோவா மோசேக்குக் கட்டளையிட்டபடியே, பலிபீடத்தின்மேல் எரித்து, ");
INSERT INTO tam2017_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","மாம்சத்தையும் தோலையும் முகாமிற்கு வெளியே நெருப்பிலே சுட்டெரித்தான். ");
INSERT INTO tam2017_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","பின்பு சர்வாங்கதகனபலியையும் கொன்றான்; ஆரோனின் மகன்கள் அதின் இரத்தத்தை அவனிடத்தில் கொண்டுவந்தார்கள்; அதை அவன் பலிபீடத்தின்மேல் சுற்றிலும் தெளித்தான். ");
INSERT INTO tam2017_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","சர்வாங்கதகனபலியின் துண்டுகளையும் தலையையும் அவனிடத்தில் கொண்டுவந்தார்கள்; அவன் அவைகளைப் பலிபீடத்தின்மேல் எரித்து, ");
INSERT INTO tam2017_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","குடல்களையும் தொடைகளையும் கழுவி, பலிபீடத்தின்மேல் இருந்த சர்வாங்க தகனபலியின்மேல் எரித்தான். ");
INSERT INTO tam2017_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","பின்பு அவன் மக்களின் பலியைக்கொண்டுவந்து, மக்களின் பாவநிவிர்த்திக்குரிய வெள்ளாட்டுக்கடாவைக் கொன்று, முந்தினதைப் பலியிட்டதுபோல, அதைப் பாவநிவாரணபலியாக்கி, ");
INSERT INTO tam2017_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","சர்வாங்கதகனபலியையும் கொண்டுவந்து, முறைப்படி அதைப் பலியிட்டு, ");
INSERT INTO tam2017_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","உணவுபலியையும் கொண்டுவந்து, அதில் கைநிறைய எடுத்து, அதைக் காலையில் செலுத்தும் சர்வாங்கதகனபலியுடனே பலிபீடத்தின்மேல் எரித்தான். ");
INSERT INTO tam2017_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","பின்பு மக்களின் சமாதானபலிகளாகிய காளையையும் ஆட்டுக்கடாவையும் கொன்றான்; ஆரோனின் மகன்கள் அதின் இரத்தத்தை அவனிடத்தில் கொண்டுவந்தார்கள்; அவன் அதைப் பலிபீடத்தின்மேல் சுற்றிலும் தெளித்து, ");
INSERT INTO tam2017_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","காளையிலும் ஆட்டுக்கடாவிலும் எடுத்த கொழுப்பையும், வாலையும், குடல்களை மூடிய ஜவ்வையும், சிறுநீரகங்களையும், கல்லீரலின்மேல் இருந்த ஜவ்வையும் கொண்டுவந்து, ");
INSERT INTO tam2017_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","கொழுப்பை மார்புப்பகுதிகளின்மேல் வைத்தார்கள்; அந்தக் கொழுப்பைப் பலிபீடத்தின்மேல் எரித்தான். ");
INSERT INTO tam2017_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","மார்புப்பகுதிகளையும் வலது முன்னந்தொடையையும், மோசே கட்டளையிட்டபடியே, ஆரோன் யெகோவாவுடைய சந்நிதியில் அசைவாட்டும் பலியாக அசைவாட்டினான். ");
INSERT INTO tam2017_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","பின்பு ஆரோன் மக்களுக்கு நேராகத் தன் கைகளை உயர்த்தி, அவர்களை ஆசீர்வதித்து, தான் பாவநிவாரணபலியையும், சர்வாங்கதகனபலியையும், சமாதானபலிகளையும் செலுத்தின இடத்திலிருந்து இறங்கினான். ");
INSERT INTO tam2017_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","பின்பு மோசேயும் ஆரோனும் ஆசரிப்புக்கூடாரத்திற்குள் நுழைந்து, வெளியே வந்து, மக்களை ஆசீர்வதித்தார்கள்; அப்பொழுது யெகோவாவுடைய மகிமை சகல மக்களுக்கும் காணப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","அன்றியும் யெகோவாவுடைய சந்நிதியிலிருந்து நெருப்பு புறப்பட்டு, பலிபீடத்தின்மேல் இருந்த சர்வாங்க தகனபலியையும் கொழுப்பையும் எரித்துவிட்டது; மக்களெல்லோரும் அதைக் கண்டபோது ஆர்ப்பரித்து, முகங்குப்புற விழுந்து யெகோவாவைப் பணிந்துகொண்டனர். ");
INSERT INTO tam2017_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","பின்பு ஆரோனின் மகன்களாகிய நாதாபும் அபியூவும் தன்தன் தூபகலசத்தை எடுத்து, அவைகளில் நெருப்பையும் அதின்மேல் தூபவர்க்கத்தையும் போட்டு, யெகோவா தங்களுக்குக் கட்டளையிடாத அந்நிய நெருப்பை அவருடைய சந்நிதியில் கொண்டுவந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","அப்பொழுது நெருப்பு யெகோவாவுடைய சந்நிதியிலிருந்து புறப்பட்டு, அவர்களை எரித்துவிட்டது; அவர்கள் யெகோவாவுடைய சந்நிதியில் மரணமடைந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","அப்பொழுது மோசே ஆரோனை நோக்கி: “என்னிடத்தில் சேருகிறவர்களால் நான் பரிசுத்தம் செய்யப்பட்டு, சகல மக்களுக்கும் முன்பாக நான் மகிமைப்படுவேன் என்று யெகோவா சொன்னது இதுதான் என்றான்; ஆரோன் பேசாதிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","பின்பு மோசே ஆரோனின் சிறிய தகப்பனான ஊசியேலின் மகன்களாகிய மீசாயேலையும் எல்சாபானையும் அழைத்து: “நீங்கள் அருகில் வந்து, உங்கள் சகோதரர்களைப் பரிசுத்த ஸ்தலத்திலிருந்து எடுத்து, முகாமிற்கு வெளியே கொண்டுபோங்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","மோசே சொன்னபடி அவர்கள் அருகில் வந்து, அவர்களை அவர்கள் அணிந்திருந்த உடைகளோடும் எடுத்து முகாமிற்கு வெளியே கொண்டுபோனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","மோசே ஆரோனையும் எலெயாசார் இத்தாமார் என்னும் அவனுடைய மகன்களையும் நோக்கி: “நீங்கள் மரணமடையாமல் இருக்கவும், சபையனைத்தின்மேலும் கடுங்கோபம் வராமல் இருக்கவும், நீங்கள் உங்கள் தலைப்பாகையை எடுத்துப்போடாமலும், உங்கள் உடைகளைக் கிழிக்காமலும் இருப்பீர்களாக; உங்கள் சகோதரர்களாகிய இஸ்ரவேல் குடும்பத்தார் அனைவரும் யெகோவா கொளுத்தின இந்த நெருப்பிற்காகப் புலம்புவார்களாக. ");
INSERT INTO tam2017_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","நீங்கள் சாகாமல் இருக்க ஆசரிப்புக்கூடாரத்தின் வாசலிலிருந்து புறப்படாதிருங்கள்; யெகோவாவுடைய அபிஷேகத்தைலம் உங்கள்மேல் இருக்கிறதே என்றான்; அவர்கள் மோசேயினுடைய வார்த்தையின்படியே செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","யெகோவா ஆரோனை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","நீயும் உன்னுடன் உன் மகன்களும் மரணமடையாமல் இருக்கவேண்டுமானால், ஆசரிப்புக்கூடாரத்திற்குள் நுழைகிறபோது, திராட்சை ரசத்தையும் மதுவையும் குடிக்கவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","பரிசுத்தமுள்ளதற்கும் பரிசுத்தமில்லாததற்கும், தீட்டுள்ளதற்கும் தீட்டில்லாததற்கும், வித்தியாசம் உண்டாக்கும்படிக்கும், ");
INSERT INTO tam2017_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","யெகோவா மோசேயைக்கொண்டு இஸ்ரவேல் மக்களுக்குச் சொன்ன சகலபிரமாணங்களையும் அவர்களுக்குப் போதிக்கும்படிக்கும், இது உங்கள் தலைமுறைதோறும் நிரந்தரமான கட்டளையாக இருக்கும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","மோசே ஆரோனையும் மீதியாக இருந்த அவனுடைய மகன்களாகிய எலெயாசாரையும் இத்தாமாரையும் நோக்கி: “நீங்கள் யெகோவாவுடைய தகனபலிகளில் மீதியான உணவுபலியை எடுத்து, பலிபீடத்தின் அருகில் புளிப்பில்லாததாக சாப்பிடுங்கள்; அது மகா பரிசுத்தமானது. ");
INSERT INTO tam2017_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","அதைப் பரிசுத்த ஸ்தலத்திலே சாப்பிடுங்கள்; அது யெகோவாவுடைய தகனபலிகளில் உனக்கும் உன் மகன்களுக்கும் ஏற்படுத்தப்பட்டதாக இருக்கிறது; இப்படிக் கட்டளை பெற்றிருக்கிறேன். ");
INSERT INTO tam2017_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","அசைவாட்டும் மார்புப்பகுதியையும், ஏறெடுத்துப் படைக்கும் முன்னந்தொடையையும், நீயும் உன்னோடேகூட உன் மகன்களும் மகள்களும் சுத்தமான இடத்திலே சாப்பிடுவீர்களாக; இஸ்ரவேல் மக்களுடைய சமாதானபலிகளில் அவைகள் உனக்கும் உன் பிள்ளைகளுக்கும் கிடைக்கும்படி ஏற்படுத்தப்பட்டிருக்கிறது. ");
INSERT INTO tam2017_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","கொழுப்பாகிய தகனபலிகளோடே அவர்கள் யெகோவாவுடைய சந்நிதியில் அசைவாட்டும் பலியாக அசைவாட்டும்படி ஏறெடுத்துப் படைக்கும் முன்னந்தொடையையும், அசைவாட்டும் மார்புப்பகுதியையும் கொண்டுவருவார்கள்; அது யெகோவா கட்டளையிட்டபடியே உனக்கும் உன் பிள்ளைகளுக்கும் நிரந்தரமான கட்டளையாக ஏற்படுத்தப்பட்டிருக்கிறது” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","பாவநிவாரணபலியாகச் செலுத்தப்பட்ட வெள்ளாட்டுக்கடாவை மோசே தேடிப்பார்த்தான்; அது எரிக்கப்பட்டிருந்தது; ஆகையால், மீதியாக இருந்த எலெயாசார் இத்தாமார் என்னும் ஆரோனின் மகன்கள்மேல் அவன் கோபம்கொண்டு: ");
INSERT INTO tam2017_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","பாவநிவாரணபலியை நீங்கள் பரிசுத்த ஸ்தலத்தில் சாப்பிடாமற்போனதென்ன? அது மகா பரிசுத்தமாக இருக்கிறதே; சபையின் அக்கிரமத்தைச் சுமந்து தீர்ப்பதற்குக் யெகோவாவுடைய சந்நிதியில் அவர்களுக்காகப் பாவநிவிர்த்தி செய்வதற்காக அதை உங்களுக்கு கொடுத்தாரே. ");
INSERT INTO tam2017_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","அதின் இரத்தம் பரிசுத்த ஸ்தலத்திற்குள்ளே கொண்டுவரப்படவில்லையே; நான் கட்டளையிட்டபடி நீங்கள் அதைப் பரிசுத்த ஸ்தலத்தில் சாப்பிடவேண்டியதாக இருந்ததே என்றான். ");
INSERT INTO tam2017_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","அப்பொழுது ஆரோன் மோசேயை நோக்கி: “அவர்கள் தங்கள் பாவநிவாரணபலியையும், தங்கள் சர்வாங்கதகனபலியையும் யெகோவாவுடைய சந்நிதியில் செலுத்தின இன்றுதானே எனக்கு இப்படி சம்பவித்ததே; பாவநிவாரணபலியை இன்று நான் சாப்பிட்டேன் என்றால், அது யெகோவாவின் பார்வைக்கு ஏற்றதாக இருக்குமோ” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","மோசே அதைக் கேட்டபோது அமைதலாயிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","யெகோவா மோசேயையும் ஆரோனையும் நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“நீங்கள் இஸ்ரவேல் மக்களிடம் சொல்லவேண்டியது என்னவென்றால், பூமியிலிருக்கிற சகல மிருகங்களிலும் நீங்கள் சாப்பிடத்தக்க உயிரினங்கள் எவைகள் என்றால்: ");
INSERT INTO tam2017_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","மிருகங்களில் விரிகுளம்புள்ளதாக இருந்து, குளம்புகள் இரண்டாகப் பிரிந்திருக்கிறதும் அசைபோடுகிற அனைத்தையும் நீங்கள் சாப்பிடலாம். ");
INSERT INTO tam2017_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","ஆனாலும், அசைபோடுகிறதும் விரிகுளம்புள்ளவைகளில் ஒட்டகமானது அசைபோடுகிறதாக இருந்தாலும், அதற்கு விரிகுளம்பில்லாததால், அது உங்களுக்கு அசுத்தமாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","குழிமுயலானது அசைபோடுகிறதாக இருந்தாலும், அதற்கு விரிகுளம்பில்லை; அது உங்களுக்கு அசுத்தமாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","முயலானது அசைபோடுகிறதாக இருந்தும், அதற்கு விரிகுளம்பில்லை; அது உங்களுக்கு அசுத்தமாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","பன்றியின் குளம்பு விரிகுளம்பும் இரண்டாகப் பிரிந்ததுமாக இருந்தும், அது அசைபோடாது; அது உங்களுக்கு அசுத்தமாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","இவைகளின் மாம்சத்தைச் சாப்பிடவும், இவைகளின் உடல்களைத் தொடவும் வேண்டாம்; இவைகள் உங்களுக்குத் தீட்டாயிருக்கக்கடவது. ");
INSERT INTO tam2017_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","தண்ணீரிலிருக்கிறவைகளில் நீங்கள் சாப்பிடத்தக்கது எதுவென்றால்: கடல்களும் ஆறுகளுமாகிய தண்ணீர்களிலே சிறகும் செதிளும் உள்ளவைகளையெல்லாம் நீங்கள் சாப்பிடலாம். ");
INSERT INTO tam2017_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","ஆனாலும், கடல்களும் ஆறுகளுமாகிய தண்ணீர்களில் நீந்துகிறதும் வாழ்கிறதுமான பிராணிகளில் சிறகும் செதிளும் இல்லாதவைகள் அனைத்தும் உங்களுக்கு அருவருப்பாயிருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","அவைகள் உங்களுக்கு அருவருப்பாயிருப்பதாக; அவைகளின் மாம்சத்தை சாப்பிடாமலிருந்து, அவைகளின் உடல்களை அருவருப்பீர்களாக. ");
INSERT INTO tam2017_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","தண்ணீர்களிலே சிறகும் செதிளும் இல்லாத அனைத்தும் உங்களுக்கு அருவருப்பாயிருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“பறவைகளில் நீங்கள் சாப்பிடாமல் அருவருக்க வேண்டியவைகள் எவைகள் என்றால்: கழுகும், கருடனும், கடலுராஞ்சியும், ");
INSERT INTO tam2017_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","பருந்தும், சகலவித வல்லூறும், ");
INSERT INTO tam2017_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","சகலவித காகங்களும், ");
INSERT INTO tam2017_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","தீக்குருவியும், கூகையும், செம்புகமும், சகலவித டேகையும், ");
INSERT INTO tam2017_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ஆந்தையும், நீர்க்காகமும், கோட்டானும், ");
INSERT INTO tam2017_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","நாரையும், கூழக்கடாவும், குருகும், ");
INSERT INTO tam2017_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","கொக்கும், சகலவித ராஜாளியும், புழுக்கொத்தியும், வௌவாலும் ஆகிய இவைகளே. ");
INSERT INTO tam2017_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“பறக்கிறவைகளில் நான்கு கால்களால் நடமாடுகிற ஊரும்பிராணிகள் அனைத்தும் உங்களுக்கு அருவருப்பாயிருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","ஆகிலும், பறக்கிறவைகளில் நான்கு கால்களால் நடமாடுகிற அனைத்திலும், நீங்கள் சாப்பிடத்தக்கது எதுவென்றால்: தரையிலே தத்துகிறதற்குக் கால்களுக்குமேல் தொடைகள் உண்டாயிருக்கிறவைகளிலே, ");
INSERT INTO tam2017_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","வெட்டுக்கிளி வகையாக இருக்கிறதையும், சோலையாம் என்னும் கிளிவகையாக இருக்கிறதையும், அர்கொல் என்னும் கிளிவகையாக இருக்கிறதையும், ஆகாபு என்னும் கிளிவகையாக இருக்கிறதையும் நீங்கள் சாப்பிடலாம். ");
INSERT INTO tam2017_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","பறக்கிறவைகளில் நான்கு கால்களால் நடமாடுகிற மற்ற அனைத்தும் உங்களுக்கு அருவருப்பாயிருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“அவைகளாலே தீட்டுப்படுவீர்கள்; அவைகளின் உடலைத் தொடுகிறவன் எவனும் மாலைவரைத் தீட்டுப்பட்டிருப்பான். ");
INSERT INTO tam2017_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","அவைகளின் உடலைச் சுமந்தவன் எவனும் தன் உடைகளைத் துவைக்கக்கடவன்; அவன் மாலைவரைத் தீட்டுப்பட்டிருப்பான். ");
INSERT INTO tam2017_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","விரிநகங்கள் உள்ளவைகளாக இருந்தும், இருபிளவான குளம்பில்லாமலும் அசைபோடாமலும் இருக்கிற மிருகங்கள் அனைத்தும் உங்களுக்கு அசுத்தமாக இருப்பதாக; அவைகளைத் தொடுகிறவன் எவனும் தீட்டுப்படுவான். ");
INSERT INTO tam2017_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","நான்கு கால்களால் நடக்கிற சகல உயிரினங்களிலும் தங்கள் உள்ளங்கால்களை ஊன்றி நடக்கிற அனைத்தும் உங்களுக்கு அசுத்தமாக இருப்பதாக; அவைகளின் உடலைத்தொடுகிறவன் எவனும் மாலைவரைத் தீட்டுப்பட்டிருப்பான். ");
INSERT INTO tam2017_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","அவைகளின் உடலைச் சுமந்தவன் தன் உடைகளைத் துவைக்கக்கடவன்; அவன் மாலைவரைத் தீட்டுப்பட்டிருப்பான்; இவைகள் உங்களுக்குத் தீட்டாயிருக்கக்கடவது. ");
INSERT INTO tam2017_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“தரையில் ஊருகிற பிராணிகளில் உங்களுக்கு அசுத்தமானவைகள் எவையென்றால்: பெருச்சாளியும், எலியும், சகலவிதமான ஆமையும், ");
INSERT INTO tam2017_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","உடும்பும், அழுங்கும், ஓணானும், பல்லியும், பச்சோந்தியும் ஆகிய இவைகளே. ");
INSERT INTO tam2017_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","சகல ஊரும் பிராணிகளிலும் இவைகள் உங்களுக்குத் தீட்டாயிருக்கக்கடவது; அவைகளில் செத்ததைத் தொடுகிறவன் எவனும் மாலைவரைத் தீட்டுப்பட்டிருப்பான். ");
INSERT INTO tam2017_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","அவைகளில் செத்தது, எதன்மேல் விழுந்தாலும் அது தீட்டுப்பட்டிருக்கும்; அது மரப்பாத்திரமானாலும், உடையானாலும், தோலானாலும், பையானாலும், வேலை செய்கிறதற்கேற்ற ஆயுதமானாலும் மாலைவரைத் தீட்டாயிருக்கும்; அது தண்ணீரில் போடப்படவேண்டும், அப்பொழுது சுத்தமாகும். ");
INSERT INTO tam2017_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","அவைகளில் ஒன்று மண்பாண்டத்திற்குள் விழுந்தால், அதற்குள் இருக்கிறவை அனைத்தும் தீட்டுப்பட்டிருக்கும்; அதை உடைத்துப்போடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","சாப்பிடத்தக்க உணவுபதார்த்தத்தின்மேல் அந்தத் தண்ணீர் பட்டால், அது தீட்டாகும்; குடிக்கத்தக்க எந்தப்பானமும் அப்படிப்பட்ட பாத்திரத்தினால் தீட்டுப்படும். ");
INSERT INTO tam2017_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","அவைகளின் உடலில் யாதொன்று எதின்மேல் விழுமோ, அதுவும் தீட்டுப்படும்; அடுப்பானாலும் மண்தொட்டியானாலும் தகர்க்கப்படுவதாக; அவைகள் தீட்டுப்பட்டிருக்கும்; ஆகையால், அவைகள் உங்களுக்குத் தீட்டாயிருக்கக்கடவது. ");
INSERT INTO tam2017_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","ஆனாலும், நீரூற்றும், மிகுந்த தண்ணீர் உண்டாகிய கிணறும், சுத்தமாக இருக்கும்; அவைகளிலுள்ள உடலைத் தொடுகிறவனோ தீட்டுப்படுவான். ");
INSERT INTO tam2017_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","மேற்சொல்லியவைகளின் உடலில் யாதொன்று விதைத்தானியத்தின்மேல் விழுந்தால், அது தீட்டுப்படாது. ");
INSERT INTO tam2017_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","அந்த உடலில் ஏதாவதொன்று தண்ணீர் ஊற்றப்பட்டிருக்கிற விதையின்மேல் விழுந்ததானால், அது உங்களுக்குத் தீட்டாயிருக்கக்கடவது. ");
INSERT INTO tam2017_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“உங்களுக்கு ஆகாரத்துக்கான ஒரு மிருகம் செத்தால், அதின் உடலைத்தொடுகிறவன் மாலைவரைத் தீட்டுப்பட்டிருப்பான். ");
INSERT INTO tam2017_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","அதின் மாம்சத்தைச் சாப்பிட்டவன் தன் உடைகளைத் துவைக்கக்கடவன்; அவன் மாலைவரைத் தீட்டுப்பட்டிருப்பான்; அதின் உடலை எடுத்துக்கொண்டுபோனவனும் தன் உடைகளைத் துவைக்கக்கடவன்; அவனும் மாலைவரைத் தீட்டுப்பட்டிருப்பான். ");
INSERT INTO tam2017_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“தரையில் ஊருகிற பிராணிகளெல்லாம் உங்களுக்கு அருவருப்பாயிருப்பதாக; அவை சாப்பிடப்படக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","தரையில் ஊருகிற சகல பிராணிகளிலும், வயிற்றினால் நகருகிறவைகளையும், நான்கு கால்களால் நடமாடுகிறவைகளையும் அநேகம் கால்களுள்ளவைகளையும் சாப்பிடாதிருப்பீர்களாக; அவைகள் அருவருப்பானவைகள். ");
INSERT INTO tam2017_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","ஊருகிற எந்தப் பிராணிகளாலும் உங்களை அருவருப்பாக்கிக் கொள்ளாமலும், அவைகளால் தீட்டுப்படாமலும் இருப்பீர்களாக; அவைகளாலே நீங்கள் தீட்டுப்படுவீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","நான் உங்கள் தேவனாகிய யெகோவா, நான் பரிசுத்தர்; ஆகையால், தரையில் ஊருகிற எந்தப் பிராணிகளிலும் உங்களைத் தீட்டுப்படுத்தாமல், உங்களைப் பரிசுத்தமாக்கிக்கொண்டு, பரிசுத்தராக இருப்பீர்களாக. ");
INSERT INTO tam2017_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","நான் உங்கள் தேவனாக இருப்பதற்கு உங்களை எகிப்து தேசத்திலிருந்து வரச்செய்த யெகோவா, நான் பரிசுத்தர்; ஆகையால். நீங்களும் பரிசுத்தராக இருப்பீர்களாக. ");
INSERT INTO tam2017_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","சுத்தமானதற்கும் அசுத்தமானதற்கும், சாப்பிடத்தக்க உயிரினங்களுக்கும் சாப்பிடத்தகாத உயிரினங்களுக்கும் வித்தியாசம் உண்டாக்குவதற்காக, ");
INSERT INTO tam2017_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","மிருகத்திற்கும், பறவைகளுக்கும், தண்ணீர்களில் நீந்துகிற சகல உயிரினங்களுக்கும், பூமியின்மேல் ஊருகிற சகல பிராணிகளுக்கும் உரிய விதிமுறைகள் இதுவே என்று சொல்லுங்கள் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“நீ இஸ்ரவேல் மக்களிடம் சொல்ல வேண்டியது என்னவென்றால்: ஒரு பெண் கர்ப்பவதியாகி ஆண்பிள்ளையைப் பெற்றால், அவள் மாதவிடாய் உள்ள பெண் விலக்கமாக இருக்கும் நாட்களுக்குச் சரியாக ஏழுநாட்கள் தீட்டாயிருப்பாள். ");
INSERT INTO tam2017_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","எட்டாம் நாளிலே அந்த குழந்தையினுடைய நுனித்தோலின் மாம்சம் விருத்தசேதனம் செய்யப்படக்கடவது. ");
INSERT INTO tam2017_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","பின்பு அவள் முப்பத்துமூன்று நாட்கள் தன் இரத்தச் சுத்திகரிப்பு நிலையிலே இருந்து, சுத்திகரிப்பின் நாட்கள் முடியும்வரை பரிசுத்தமான யாதொரு பொருளைத் தொடவும் பரிசுத்த ஸ்தலத்திற்குள் வரவும் கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","பெண்குழந்தையைப் பெறுவாளென்றால், அவள், இரண்டு வாரங்கள் மாதவிடாய் உள்ள பெண்ணைப்போலத் தீட்டாயிருந்து, பின்பு அறுபத்தாறு நாட்கள் இரத்தச் சுத்திகரிப்பு நிலையிலே இருப்பாளாக. ");
INSERT INTO tam2017_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“அவள் ஆண்குழந்தையையாவது பெண்குழந்தையையாவது பெற்றதற்காக அவளுடைய சுத்திகரிப்பின் நாட்கள் முடிந்தபின்பு, அவள் ஒருவயதுடைய ஆட்டுக்குட்டியை சர்வாங்கதகனபலியாகவும், ஒரு புறாக்குஞ்சையாவது காட்டுப்புறாவையாவது பாவநிவாரணபலியாகவும், ஆசரிப்புக்கூடாரத்தின் வாசலில் ஆசாரியனிடத்திற்குக் கொண்டுவரக்கடவள். ");
INSERT INTO tam2017_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","அதை அவன் யெகோவாவுடைய சந்நிதியில் பலியிட்டு, அவளுக்காகப் பாவநிவிர்த்தி செய்வானாக; அப்பொழுது அவள் தன் இரத்தப்போக்கின் தீட்டு நீங்கிச் சுத்தமாவாள். இது ஆண்குழந்தையையாவது பெண்குழந்தையையாவது பெற்றவளைக்குறித்த விதிமுறைகள். ");
INSERT INTO tam2017_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","ஆட்டுக்குட்டியைக் கொண்டுவர அவளுக்கு சக்தியில்லாதிருந்தால், இரண்டு காட்டுப்புறாக்களையாவது இரண்டு புறாக்குஞ்சுகளையாவது, ஏதாவது ஒன்றை சர்வாங்க தகனபலியாகவும் மற்றொன்றைப் பாவநிவாரணபலியாகவும் கொண்டுவரக்கடவள்; அதினால் ஆசாரியன் அவளுக்காகப் பாவநிவிர்த்தி செய்யக்கடவன்; அப்பொழுது அவள் சுத்தமாவாள் என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","பின்னும் யெகோவா மோசேயையும் ஆரோனையும் நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“ஒரு மனிதனுடைய உடலின்மேல் தொழுநோயைப்போலிருக்கிற ஒரு தடிப்பாவது, புண்ணின் தோலாவது, வெள்ளைப்படராவது உண்டானால், அவன் ஆசாரியனாகிய ஆரோனிடத்திலாகிலும், ஆசாரியர்களாகிய அவனுடைய மகன்களில் ஒருவனிடத்திலாகிலும் கொண்டுவரப்படக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","அப்பொழுது ஆசாரியன் அவனுடைய உடலின்மேல் இருக்கிற வியாதியைப் பார்க்கவேண்டும்; வியாதியுள்ள இடத்தில் முடி வெளுத்தும், வியாதியுள்ள இடம் அவனுடைய உடலின் மற்ற பகுதியைவிட அதிகமாகக் குழிந்தும் இருந்தால் அது தொழுநோய்; ஆசாரியன் அவனைப் பார்த்தபின்பு, அவனைத் தீட்டுள்ளவன் என்று தீர்மானிக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","அவனுடைய உடலின்மேல் வெள்ளைப்படர்ந்திருந்தாலும், அந்த இடம் அவனுடைய மற்றத் தோலைவிட அதிக பள்ளமாக இல்லாமலும், அதின் முடி வெள்ளையாக மாறாமலும் இருந்தால், ஆசாரியன் அவனை ஏழுநாட்கள் அடைத்துவைத்து, ");
INSERT INTO tam2017_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ஏழாம் நாளில் அவனைப் பார்க்கக்கடவன்; தோலில் வியாதி அதிகமாகாமல், அவன் பார்வைக்கு வியாதி நின்றிருந்தால், ஆசாரியன் இரண்டாவதுமுறை அவனை ஏழுநாட்கள் அடைத்துவைத்து, ");
INSERT INTO tam2017_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","இரண்டாவதுமுறை அவனை ஏழாம் நாளில் பார்க்கக்கடவன்; தோலில் வியாதி அதிகமாகாமல் சுருங்கியிருந்தால், ஆசாரியன் அவனைச் சுத்தமுள்ளவன் என்று தீர்மானிக்கக்கடவன்; அது தேமல்; அவன் தன் உடைகளைத் துவைத்துச் சுத்தமாக இருப்பானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","தன்னைச் சுத்தமுள்ளவன் என்று தீர்மானிக்கிறதற்கு அவன் தன்னை ஆசாரியனுக்குக் காண்பித்தபின்பு, தோலில் தேமல் அதிகமாகப் படர்ந்திருந்தால், அவன் மறுபடியும் ஆசாரியனுக்குத் தன்னைக் காண்பிக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","அப்பொழுது தோலிலே தேமல் படர்ந்தது என்று ஆசாரியன் கண்டால், ஆசாரியன் அவனைத் தீட்டுள்ளவன் என்று தீர்மானிக்கக்கடவன்; அது தொழுநோய். ");
INSERT INTO tam2017_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“ஒரு மனிதனுக்கு தொழுநோய் இருந்தால், அவனை ஆசாரியனிடத்தில் கொண்டுவரவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","அப்பொழுது ஆசாரியன் அவனைப் பார்த்து, தோலிலே வெள்ளையான தடிப்பிருந்து, அது முடியை வெண்மையாக மாறச்செய்தது என்றும், அந்தத் தடிப்புள்ள இடத்திலே புண் உண்டென்றும் கண்டால், ");
INSERT INTO tam2017_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","அது அவனுடைய உடலிலுள்ள நாள்பட்ட தொழுநோய்; அவன் தீட்டுள்ளவன். ஆதலால், ஆசாரியன் அவனை அடைத்துவைக்காமல், தீட்டுள்ளவன் என்று தீர்மானிக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","ஆசாரியன் பார்க்கிற இடங்களெங்கும் தோலிலே தொழுநோய் தோன்றி, அந்த வியாதியுள்ளவனுடைய தலைமுதல் கால்வரை அது உடல்முழுவதையும் மூடியிருக்கக்கண்டால், ");
INSERT INTO tam2017_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","அப்பொழுது ஆசாரியன் பார்த்து, தொழுநோய் அவன் உடல் முழுவதையும் மூடியிருந்தால், அவனைச் சுத்தமுள்ளவன் என்று தீர்மானிக்கக்கடவன்; அவன் உடல்முழுவதும் வெண்மையாகிவிட்டதால், அவன் சுத்தமுள்ளவன். ");
INSERT INTO tam2017_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","ஆனாலும், புண் அவனில் காணப்பட்டால், அவன் தீட்டுள்ளவன். ");
INSERT INTO tam2017_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","ஆகையால், புண்ணை ஆசாரியன் பார்க்கும்போது, அவனைத் தீட்டுள்ளவன் என்று தீர்மானிக்கக்கடவன்; புண் தீட்டுள்ளது; அது தொழுநோய். ");
INSERT INTO tam2017_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","அல்லது புண் மாறி வெண்மையானால், அவன் ஆசாரியனிடத்திற்கு வரவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","ஆசாரியன் அவனைப் பார்த்து, வியாதியுள்ள இடம் வெண்மையாக மாறினதென்று கண்டால், ஆசாரியன் அவனைச் சுத்தமுள்ளவன் என்று தீர்மானிக்கக்கடவன்; அவன் சுத்தமுள்ளவன். ");
INSERT INTO tam2017_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“உடலின்மேல் புண் உண்டாயிருந்து ஆறிப்போய், ");
INSERT INTO tam2017_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","அந்த இடத்திலே ஒரு வெள்ளைத்தடிப்பாவது சிவப்புக் கலந்த ஒரு வெள்ளைப்படராவது உண்டானால், அதை ஆசாரியனுக்குக் காண்பிக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","ஆசாரியன் அதைப் பார்த்து, அந்த இடம் மற்ற தோலைவிட குழிந்திருக்கவும், அதின் முடி வெள்ளையாக மாறியிருக்கவும் கண்டால், ஆசாரியன் அவனைத் தீட்டுள்ளவன் என்று தீர்மானிக்கவேண்டும்; அது புண்ணில் உண்டான தொழுநோய். ");
INSERT INTO tam2017_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","ஆசாரியன் அதைப் பார்த்து, அதில் வெள்ளைமுடி இல்லை என்றும், அது மற்ற தோலைவிட குழிந்திராமல் சுருங்கியிருக்கிறது என்றும் கண்டானாகில், அவனை ஏழுநாட்கள் அடைத்துவைத்து, ");
INSERT INTO tam2017_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","அது தோலில் அதிகமாகப் படர்ந்திருக்கக்கண்டால், அவனைத் தீட்டுள்ளவன் என்று தீர்மானிக்கக்கடவன்; அது தொழுநோய்தான். ");
INSERT INTO tam2017_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","அந்த வெள்ளைப்படர் அதிகமாகாமல், அந்த அளவில் நின்றிருக்குமானால், அது புண்ணின் தழும்பாயிருக்கும்; ஆகையால், ஆசாரியன் அவனைச் சுத்தமுள்ளவன் என்று தீர்மானிக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“ஒருவனுடைய உடலின்மேல் நெருப்புப்பட்டதினாலே வெந்து, அந்த தீக்காயம் ஆறிப்போன இடத்திலே சிவப்பான படராவது வெண்மையான படராவது உண்டானால், ");
INSERT INTO tam2017_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ஆசாரியன் அதைப் பார்க்கக்கடவன்; அந்தப் படரிலே முடி வெண்மையாக மாறி, அந்த இடம் மற்ற தோலைவிட பள்ளமாக இருந்தால், அது தீக்காயத்தினால் உண்டான தொழுநோய்; ஆகையால், ஆசாரியன் அவனைத் தீட்டுள்ளவன் என்று தீர்மானிக்கக்கடவன்; அது தொழுநோய்தான். ");
INSERT INTO tam2017_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","ஆசாரியன் அதைப் பார்க்கிறபோது, படரிலே வெள்ளைமுடி இல்லை என்றும், அது மற்ற தோலைவிட குழிந்திராமல், சுருங்கியிருக்கிறது என்றும் கண்டானாகில், அவனை ஏழுநாட்கள் அடைத்துவைத்து, ");
INSERT INTO tam2017_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ஏழாம்நாளில் அவனைப் பார்க்கக்கடவன்; அது தோலில் அதிகமாகப் படர்ந்திருந்தால், ஆசாரியன் அவனைத் தீட்டுள்ளவன் என்று தீர்மானிக்கக்கடவன்; அது தொழுநோய். ");
INSERT INTO tam2017_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","படரானது தோலில் அதிகமாகாமல், அந்த அளவில் நின்று சுருங்கியிருந்ததானால், அது தீக்காயத்தினால் உண்டான தழும்பு; ஆசாரியன் அவனைச் சுத்தமுள்ளவன் என்று தீர்மானிக்கக்கடவன்; அது சூட்டினால் வந்த தீக்காயம். ");
INSERT INTO tam2017_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“ஆணுக்காகிலும் பெண்ணுக்காகிலும் தலையிலாவது தாடியிலாவது ஒரு சொறி உண்டானால், ");
INSERT INTO tam2017_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ஆசாரியன் அதைப் பார்த்து, அந்த இடம் மற்ற தோலைவிட பள்ளமும் அதிலே முடி பொன் நிறமும் மிருதுவாகவும் இருக்கக்கண்டால், ஆசாரியன் அவனைத் தீட்டுள்ளவன் என்று தீர்மானிக்கக்கடவன்; அது தலையிலும் தாடியிலும் உண்டாகிற சொறிதொழுநோய். ");
INSERT INTO tam2017_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","ஆசாரியன் அந்தச் சொறிதொழுநோயைப் பார்க்கும்போது, அந்த இடம் மற்ற தோலைவிட பள்ளமாக இல்லாமலும், அதிலே கறுத்தமுடி இல்லாமலும் இருக்கக்கண்டால், ஆசாரியன் அவனை ஏழுநாட்கள் அடைத்துவைத்து, ");
INSERT INTO tam2017_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ஏழாம்நாளில் ஆசாரியன் அதைப் பார்ப்பானாக; அந்தச் சொறி படராமலும், அதிலே பொன்நிறமுடி இல்லாமலும், அந்த இடம் மற்றத் தோலைவிட பள்ளமில்லாமலும் இருந்தால், ");
INSERT INTO tam2017_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","அந்தச் சொறியுள்ள இடம்தவிர, மற்ற யாவையும் அவன் சிரைத்துக்கொள்ளவேண்டும்; பின்பு, ஆசாரியன் இரண்டாவதுமுறை அவனை ஏழுநாட்கள் அடைத்துவைத்து, ");
INSERT INTO tam2017_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ஏழாம்நாளில் அதைப் பார்க்கக்கடவன்; சொறி, தோலில் பரவாமலும், அந்த இடம் மற்றத் தோலைவிட பள்ளமில்லாமலும் இருந்தால், ஆசாரியன் அவனைச் சுத்தமுள்ளவன் என்று தீர்மானிக்கக்கடவன்; அவன் தன் உடைகளைத் துவைத்தபின் சுத்தமாக இருப்பான். ");
INSERT INTO tam2017_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","அவன் சுத்தமுள்ளவன் என்று தீர்க்கப்பட்டபின்பு, அந்தச் சொறி, தோலில் இடங்கொண்டதானால், ");
INSERT INTO tam2017_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ஆசாரியன் அவனைப் பார்க்கக்கடவன்; சொறி தோலில் பரவியிருந்தால், அப்பொழுது முடி பொன்நிறமா அல்லவா என்று ஆசாரியன் விசாரிக்க வேண்டியதில்லை; அவன் தீட்டுள்ளவனே. ");
INSERT INTO tam2017_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","அவன் பார்வைக்கு அந்தச் சொறி நீங்கி, அதில் கறுத்தமுடி முளைத்ததேயாகில், சொறி குணமாகிவிட்டது; அவன் சுத்தமுள்ளவன்; ஆசாரியன் அவனைச் சுத்தமுள்ளவன் என்று தீர்மானிக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“ஒரு ஆணுக்காகிலும் பெண்ணுக்காகிலும் அவர்கள் உடலின்மேல் வெள்ளைப் புள்ளிகள் உண்டாயிருந்தால், ");
INSERT INTO tam2017_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ஆசாரியன் பார்க்கக்கடவன்; அவர்களுடைய உடலிலே மங்கின வெள்ளைப் புள்ளிகள் இருந்தால், அது தோலில் எழும்புகிற வெள்ளைத்தேமல்; அவர்கள் சுத்தமுள்ளவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“ஒருவனுடைய தலைமுடி உதிர்ந்து, அவன் மொட்டையனானாலும், அவன் சுத்தமாக இருக்கிறான். ");
INSERT INTO tam2017_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","அவனுடைய முன்னந்தலை முடி உதிர்ந்தால், அவன் அரைமொட்டையன்; அவனும் சுத்தமாக இருக்கிறான். ");
INSERT INTO tam2017_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","மொட்டைத்தலையிலாவது அரைமொட்டைத்தலையிலாவது சிவப்புக்கலந்த வெண்மையான படர் உண்டானால், அது அதில் ஏற்படுகிற தொழுநோய். ");
INSERT INTO tam2017_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","ஆசாரியன் அவனைப் பார்க்கக்கடவன்; அவனுடைய மொட்டைத்தலையிலாவது அரைமொட்டைத்தலையிலாவது, மற்ற அங்கங்களின்மேல் உண்டாகும் குஷ்டத்தைப்போல, சிவப்புக்கலந்த வெண்மையான தடிப்பு இருக்கக்கண்டால், ");
INSERT INTO tam2017_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","அவன் தொழுநோயாளி, அவன் தீட்டுள்ளவன்; ஆசாரியன் அவனைத் தீட்டுள்ளவன் என்று தீர்மானிக்கக்கடவன்; அவன் வியாதி அவன் தலையிலே இருக்கிறது. ");
INSERT INTO tam2017_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“அந்த வியாதி உண்டாயிருக்கிற தொழுநோயாளி உடை கிழிந்தவனாகவும், தன் தலையை மூடாதவனாகவும் இருந்து, அவன் தன் தாடியை மூடிக்கொண்டு, தீட்டு, தீட்டு என்று சத்தமிடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","அந்த வியாதி அவனில் இருக்கும் நாட்கள்வரை தீட்டுள்ளவனாக கருதப்படக்கடவன்; அவன் தீட்டுள்ளவனே; ஆகையால், அவன் தனியே குடியிருக்கவேண்டும்; அவனுடைய குடியிருப்பு, முகாமிற்கு வெளியே இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“ஆட்டுரோம உடையிலாவது, பஞ்சுநூல் உடையிலாவது, ");
INSERT INTO tam2017_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","பஞ்சுநூல் அல்லது ஆட்டுரோமத்தினாலான நெய்யப்பட்ட, பின்னப்பட்ட பொருட்களிலாவது, ஒரு தோலிலாவது, தோலினால் செய்யப்பட்ட எந்தவித பொருளிலாவது பூசணம் தோன்றி, ");
INSERT INTO tam2017_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","உடையிலாவது, தோலிலாவது, நெய்யப்பட்ட, பின்னப்பட்ட பொருட்களிலாவது, தோலினால் செய்த எந்தவித பொருளிலாவது பூசணம் பச்சையாகவோ சிவப்பாகவோ காணப்பட்டால் அது தொழுநோயாக இருக்கும்; அதை ஆசாரியனுக்குக் காண்பிக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","ஆசாரியன் அதைப் பார்த்து, ஏழுநாட்கள் அடைத்துவைத்து, ");
INSERT INTO tam2017_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","ஏழாம் நாளிலே அதைப் பார்க்கக்கடவன்; உடையிலாவது, நெய்யப்பட்ட, பின்னப்பட்ட பொருட்களிலாவது, தோலிலாவது, தோலினால் செய்யப்பட்ட எந்தவித பொருளிலாவது அது பரவியிருந்தால், அது அரிக்கிற தொழுநோய்; அது தீட்டாயிருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","அந்த பூசணம் இருக்கிற ஆட்டுரோமத்தினாலும் பஞ்சுநூலினாலும் செய்யப்பட்ட உடையையும், நெய்யப்பட்ட மற்றும் பின்னப்பட்டவைகளையும், தோலினால் செய்யப்பட்ட எந்தவித பொருளையும் சுட்டெரிக்கக்கடவன்; அது அரிக்கிற தொழுநோய்; ஆகையால் நெருப்பில் சுட்டெரிக்கப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“உடையின் நெய்யப்பட்ட, பின்னப்பட்ட பொருட்களிலாவது, தோலினால் செய்யப்பட்ட எந்தவித பொருளிலாவது, அந்தப் பூசணம் பரவவில்லை என்று ஆசாரியன் கண்டால், ");
INSERT INTO tam2017_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","அப்பொழுது ஆசாரியன் அதைக் கழுவச்சொல்லி, இரண்டாவதுமுறை ஏழுநாட்கள் அடைத்துவைத்து, ");
INSERT INTO tam2017_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","அது கழுவப்பட்டபின்பு, அதைப் பார்க்கக்கடவன்; அந்தப் பூசணம் பரவாமல் இருந்தாலும், அது நிறம் மாறாததாக இருந்தால் தீட்டாயிருக்கும்; தீயில் அதை எரித்துவிடவேண்டும்; அது அந்த உடையின் உட்புறத்திலும் வெளிப்புறத்திலும் ஆழமாக அரிக்கும். ");
INSERT INTO tam2017_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","கழுவப்பட்டபின்பு அது குறைந்ததென்று ஆசாரியன் கண்டானேயாகில், அதை உடையிலாவது, தோலிலாவது, நெய்யப்பட்ட மற்றும் பின்னப்பட்டவைகளிலாவது இல்லாதபடி எடுத்துப்போடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","அது இன்னும் உடையிலாவது, நெய்யப்பட்ட மற்றும் பின்னப்பட்டவைகளிலாவது, தோலினால் செய்த எந்தவித பொருளிலாவது காணப்பட்டால், அது படருகிற பூசணம்; ஆகையினால் அது உள்ளதை தீயில் எரித்துவிடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","ஆடையின் பாவாவது, ஊடையாவது, தோலினால் செய்த எந்தவித பொருளாவது கழுவப்பட்டபின்பு, அந்தப் பூசணம் அதை விட்டுப் போயிற்றேயானால், இரண்டாவதுமுறை கழுவப்படவேண்டும்; அப்பொழுது சுத்தமாக இருக்கும்”. ");
INSERT INTO tam2017_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ஆட்டுரோமமாகிலும் பஞ்சுநூலாலாகிலும் நெய்த உடையையாவது, பாவையாவது, ஊடையையாவது, தோலினால் செய்த எந்தவித பொருளையாவது, சுத்தமென்றாவது தீட்டென்றாவது தீர்மானிக்கிறதற்கு, அதினுடைய தொழுநோய் தோஷத்திற்குரிய விதிமுறைகள் இதுவே என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“தொழுநோயாளியினுடைய சுத்திகரிப்பின் நாட்களில் அவனுக்குரிய விதிமுறைகள் என்னவென்றால்: அவன் ஆசாரியனிடத்தில் கொண்டுவரப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ஆசாரியன் முகாமிற்கு வெளியே போய்; அவனுடைய தொழுநோய் சுகமாகிவிட்டது என்று கண்டால், ");
INSERT INTO tam2017_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","சுத்திகரிக்கப்படவேண்டியவனுக்காக, உயிரோடிருக்கும் சுத்தமான இரண்டு குருவிகளையும், கேதுருக் கட்டையையும், சிவப்புநூலையும், ஈசோப்பையும் வாங்கிவரக் கட்டளையிடுவானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","பின்பு, ஆசாரியன் அந்தக் குருவிகளில் ஒன்றை ஒரு மண்பானையிலுள்ள சுத்தமான தண்ணீரின்மேல் கொல்லச்சொல்லி, ");
INSERT INTO tam2017_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","உயிருள்ள குருவியையும், கேதுருக்கட்டையையும், சிவப்புநூலையும், ஈசோப்பையும் எடுத்து, இவைகளையும் உயிருள்ள குருவியையும் சுத்தமான தண்ணீரின்மேல் கொல்லப்பட்ட குருவியின் இரத்தத்திலே நனைத்து, ");
INSERT INTO tam2017_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","தொழுநோய் நீங்கச் சுத்திரிக்கப்படுகிறவன்மேல் ஏழுமுறை தெளித்து, அவனைச் சுத்தம்செய்து, உயிருள்ள குருவியை வெளியிலே விட்டுவிடுவானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","சுத்திகரிக்கப்படுகிறவன் தன் உடைகளைத் துவைத்து, தன் முடி முழுவதையும் சிரைத்து, தான் சுத்தமாவதற்காக தண்ணீரில் குளித்து, பின்பு முகாமிற்கு வந்து, தன் கூடாரத்திற்கு வெளியே ஏழுநாட்கள் தங்கி, ");
INSERT INTO tam2017_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","ஏழாம் நாளிலே தன் தலையையும், தாடியையும், புருவங்களையும் தன்னுடைய முடிமுழுவதையும் சிரைத்து, தன் உடைகளைத் துவைத்து, தண்ணீரில் குளிக்கவேண்டும்; அப்பொழுது சுத்தமாக இருப்பான். ");
INSERT INTO tam2017_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“எட்டாம்நாளிலே அவன் பழுதற்ற இரண்டு ஆட்டுக்குட்டிகளையும், ஒருவயதுடைய பழுதற்ற ஒரு பெண்ணாட்டுக்குட்டியையும், உணவுபலிக்காக எண்ணெயிலே பிசைந்த ஒரு மரக்காலில் பத்தில் மூன்று பங்காகிய மெல்லிய மாவையும், ஒரு ஆழாக்கு எண்ணெயையும் கொண்டுவரக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","சுத்திகரிக்கிற ஆசாரியன் சுத்திகரிக்கப்படும் மனிதனையும் அப்பொருட்களையும் ஆசரிப்புக்கூடாரத்தின் வாசலிலே யெகோவாவுடைய சந்நிதியில் நிறுத்தக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","பின்பு, ஆசாரியன் ஒரு ஆட்டுக்குட்டியைப் பிடித்து, அதையும் அந்த ஆழாக்கு எண்ணெயையும் குற்றநிவாரணபலியாகக் கொண்டுவந்து, யெகோவாவுடைய சந்நிதியில் அசைவாட்டும் பலியாக அசைவாட்டி, ");
INSERT INTO tam2017_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","பாவநிவாரணபலியும் சர்வாங்கதகனபலியும் செலுத்தும் பரிசுத்த ஸ்தலத்திலே அந்த ஆட்டுக்குட்டியைக் கொல்லக்கடவன்; குற்றநிவாரணபலி பாவநிவாரணபலியைப்போல ஆசாரியனுக்கு உரியது; அது மகா பரிசுத்தமானது. ");
INSERT INTO tam2017_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","அந்த குற்றநிவாரணபலியின் இரத்தத்தில் ஆசாரியன் கொஞ்சம் எடுத்து, சுத்திகரிக்கப்படுகிறவன் வலதுகாதின் மடலிலும், அவன் வலதுகையின் பெருவிரலிலும், வலதுகாலின் பெருவிரலிலும் பூசுவானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","பின்பு, ஆசாரியன் அந்த ஆழாக்கு எண்ணெயிலே கொஞ்சம் தன் இடதுகையில் ஊற்றி ");
INSERT INTO tam2017_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","தன் இடதுகையிலுள்ள எண்ணெயில் தன் வலதுகையின் விரலை நனைத்து, தன் விரலினால் ஏழுமுறை அந்த எண்ணெயில் எடுத்து, யெகோவாவுடைய சந்நிதியில் தெளித்து, ");
INSERT INTO tam2017_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","தன் உள்ளங்கையில் இருக்கிற மீதியான எண்ணெயிலே கொஞ்சம் எடுத்து சுத்திகரிக்கப்படுகிறவனுடைய வலதுகாதின் மடலிலும், அவன் வலதுகையின் பெருவிரலிலும், வலதுகாலின் பெருவிரலிலும், ஏற்கனவே பூசியிருக்கிற குற்றநிவாரணபலியினுடைய இரத்தத்தின்மேல் பூசி, ");
INSERT INTO tam2017_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","தன் உள்ளங்கையில் இருக்கிற மீதியான எண்ணெயைச் சுத்திகரிக்கப்படுகிறவனுடைய தலையிலே ஊற்றி யெகோவாவுடைய சந்நிதியில் அவனுக்காகப் பாவநிவிர்த்தி செய்யக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","ஆசாரியன் பாவநிவாரணபலியையும் செலுத்தி, சுத்திகரிக்கப்படுகிறவனின் தீட்டு நீங்க, அவனுக்குப் பாவநிவிர்த்தி செய்து, பின்பு சர்வாங்கதகனபலியைக் கொன்று, ");
INSERT INTO tam2017_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","சர்வாங்கதகனபலியையும் உணவுபலியையும் பலிபீடத்தின்மேல் வைத்து, அவனுக்காகப் பாவநிவிர்த்தி செய்யக்கடவன்; அப்பொழுது அவன் சுத்தமாக இருப்பான். ");
INSERT INTO tam2017_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“அவன் இவ்விதம் செய்யமுடியாத ஏழையாக இருந்தால், அவன் தன் பாவநிவிர்த்திக்கென்று அசைவாட்டும் குற்றநிவாரணபலியாக ஒரு ஆட்டுக்குட்டியையும், உணவுபலிக்கு எண்ணெயில் பிசைந்த ஒரு மரக்கால் மெல்லிய மாவிலே பத்தில் ஒரு பங்கையும், ஆழாக்கு எண்ணெயையும், ");
INSERT INTO tam2017_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","தன் தகுதிக்குத் தக்கபடி இரண்டு காட்டுப்புறாக்களையாவது இரண்டு புறாக்குஞ்சுகளையாவது, ஒன்று பாவநிவாரணபலியாகவும், மற்றொன்று சர்வாங்கதகனபலியாகவும் செலுத்தும்படி வாங்கி, ");
INSERT INTO tam2017_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","தான் சுத்திகரிக்கப்படும்படி எட்டாம் நாளில் ஆசரிப்புக்கூடாரத்தின் வாசலிலே யெகோவாவுடைய சந்நிதியில் ஆசாரியனிடத்திற்குக் கொண்டுவருவானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","அப்பொழுது ஆசாரியன் குற்றநிவாரணபலிக்குரிய ஆட்டுக்குட்டியையும் அந்த ஆழாக்கு எண்ணெயையும் வாங்கி, யெகோவாவுடைய சந்நிதியில் அசைவாட்டும் உணவுபலியாக அசைவாட்டி, ");
INSERT INTO tam2017_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","குற்றநிவாரணபலிக்கான அந்த ஆட்டுக்குட்டியைக் கொன்று, குற்றநிவாரணபலியின் இரத்தத்தில் கொஞ்சம் எடுத்து, சுத்திகரிக்கப்படுகிறவனுடைய வலதுகாதின் மடலிலும், அவன் வலதுகையின் பெருவிரலிலும், வலதுகாலின் பெருவிரலிலும் பூசி, ");
INSERT INTO tam2017_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","அந்த எண்ணெயிலே கொஞ்சம் தன் இடதுகையில் ஊற்றி ");
INSERT INTO tam2017_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","தன் இடதுகையிலுள்ள எண்ணெயிலே தன் வலதுவிரலை நனைத்து, யெகோவாவுடைய சந்நிதியில் ஏழுமுறை தெளித்து, ");
INSERT INTO tam2017_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","தன் உள்ளங்கையில் இருக்கிற எண்ணெயில் கொஞ்சம் எடுத்துச் சுத்திகரிக்கப்படுகிறவனுடைய வலதுகாதின் மடலிலும், அவன் வலதுகையின் பெருவிரலிலும், வலதுகாலின் பெருவிரலிலும் குற்றநிவாரணபலியின் இரத்தம் பூசியிருக்கிற இடத்தின்மேல் பூசி, ");
INSERT INTO tam2017_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","தன் உள்ளங்கையில் இருக்கிற மற்ற எண்ணெயைச் சுத்திகரிக்கப்படுகிறவன் தலையின்மேல் அவனுக்காகக் யெகோவாவுடைய சந்நிதியில் பாவநிவிர்த்தி செய்யும்படி தடவி, ");
INSERT INTO tam2017_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","பின்பு, அவன் தன் பெலத்திற்கும் தகுதிக்கும் தக்கதாக காட்டுப்புறாக்களையாவது புறாக்குஞ்சுகளையாவது கொண்டுவந்து, ");
INSERT INTO tam2017_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","அவைகளில் ஒன்றைப் பாவநிவாரணபலியும், மற்றொன்றைச் சர்வாங்கதகனபலியுமாக, உணவுபலியோடேகூடச் செலுத்தி, இப்படியே ஆசாரியன் சுத்திகரிக்கப்படுகிறவனுக்காக, யெகோவாவுடைய சந்நிதியில் பாவநிவிர்த்தி செய்யக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","தன் சுத்திகரிப்புக்கு வேண்டியவைகளைச் சம்பாதிக்கமுடியாத தொழுநோயாளியைக் குறித்த விதிமுறைகள் இதுவே என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","பின்னும் யெகோவா மோசேயையும் ஆரோனையும் நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“நான் உங்களுக்குச் சொந்தமாகக் கொடுக்கும் கானான் தேசத்திலே நீங்கள் போய்ச் சேர்ந்தபின்பு, உங்கள் சொந்தமான தேசத்தில் ஒரு வீட்டிலே பூசணத்தை நான் வரச்செய்தால், ");
INSERT INTO tam2017_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","அந்த வீட்டிற்குச் சொந்தமானவன் வந்து, வீட்டிலே பூசணம் வந்திருக்கிறதாகத் தோன்றுகிறது என்று ஆசாரியனுக்கு அறிவிக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","அப்பொழுது வீட்டிலுள்ள அனைத்தும் தீட்டுப்படாதபடி, ஆசாரியன் அந்தப் பூசணத்தைப் பார்க்கப் போகும்முன்னே வீட்டை காலிசெய்துவைக்கச் சொல்லி, பின்பு வீட்டைப் பார்க்கும்படி போய், ");
INSERT INTO tam2017_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","அந்தப் பூசணம் இருக்கிற இடத்தைப் பார்க்கக்கடவன்; அப்பொழுது வீட்டுச் சுவர்களிலே கொஞ்சம் பச்சையும் கொஞ்சம் சிவப்புமான குழி விழுந்திருந்து, அவைகள் மற்ற சுவரைவிட பள்ளமாக இருக்கக்கண்டால், ");
INSERT INTO tam2017_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ஆசாரியன் வீட்டைவிட்டுப் புறப்பட்டு வாசற்படியிலே வந்து, வீட்டை ஏழுநாட்கள் அடைத்துவைத்து, ");
INSERT INTO tam2017_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","ஏழாம்நாளிலே திரும்பப் போய்ப்பார்த்து, பூசணம் வீட்டுச் சுவர்களில் படர்ந்ததென்று கண்டால், ");
INSERT INTO tam2017_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","பூசணம் இருக்கும் அந்த இடத்தின் கற்களைப் பெயர்க்கவும், பட்டணத்திற்கு வெளியே அசுத்தமான ஒரு இடத்திலே போடவும் அவன் கட்டளையிட்டு, ");
INSERT INTO tam2017_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","வீட்டின் உட்புறம் சுற்றிலும் செதுக்கச்சொல்லி, செதுக்கிப்போட்ட மண்ணைப் பட்டணத்திற்கு வெளியே அசுத்தமான ஒரு இடத்திலே கொட்டவும், ");
INSERT INTO tam2017_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","வேறே கற்களை எடுத்துவந்து, அந்தக் கற்களுக்குப் பதிலாகக் கட்டி, வேறே சாந்தை எடுத்து வீட்டைப் பூசவும் கட்டளையிடுவானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“கற்களைப் பெயர்த்து, வீட்டைச்செதுக்கி, புதிதாகப் பூசினபின்பும், அந்தப் பூசணம் மீண்டும் வீட்டில் வந்ததானால், ");
INSERT INTO tam2017_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ஆசாரியன் போய்ப் பார்க்கக்கடவன்; பூசணம் வீட்டில் படர்ந்ததானால், அது வீட்டை அரிக்கிற பூசணம்; அது தீட்டாயிருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","ஆகையால் வீடுமுழுவதையும் இடித்து, அதின் கற்களையும், மரங்களையும், அதின் சாந்து எல்லாவற்றையும் பட்டணத்திற்கு வெளியே அசுத்தமான இடத்திலே கொண்டுபோகவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","வீடு அடைக்கப்பட்டிருக்கும் நாட்களில் அதற்குள் பிரவேசிக்கிறவன் மாலைவரைத் தீட்டுப்பட்டிருப்பான். ");
INSERT INTO tam2017_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","அந்த வீட்டிலே உறங்கியவன் தன் உடைகளைத் துவைக்கக்கடவன்; அந்த வீட்டிலே சாப்பிட்டவனும் தன் உடைகளைத் துவைக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“ஆசாரியன் திரும்ப வந்து, வீடு பூசப்பட்டபின்பு வீட்டிலே அந்தப் பூசணம் படரவில்லை என்று கண்டானேயாகில், பூசணம் நீங்கிவிட்டதால், ஆசாரியன் அந்த வீட்டைச் சுத்தம் என்று தீர்மானிக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","அப்பொழுது வீட்டைச் சுத்திகரிக்க, இரண்டு குருவிகளையும், கேதுருக்கட்டையையும், சிவப்புநூலையும், ஈசோப்பையும் எடுத்து, ");
INSERT INTO tam2017_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","ஒரு குருவியை ஒரு மண்பாண்டத்திலுள்ள ஊற்றுநீரின்மேல் கொன்று, ");
INSERT INTO tam2017_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","கேதுருக்கட்டையையும், ஈசோப்பையும், சிவப்புநூலையும், உயிருள்ள குருவியையும் எடுத்து, இவைகளைக் கொல்லப்பட்ட குருவியின் இரத்தத்திலும் ஊற்று நீரிலும் நனைத்து, வீட்டின்மேல் ஏழுமுறை தெளித்து, ");
INSERT INTO tam2017_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","குருவியின் இரத்தத்தினாலும், ஊற்றுநீரினாலும், உயிருள்ள குருவியினாலும், கேதுருக்கட்டையினாலும் ஈசோப்பினாலும், சிவப்புநூலினாலும் வீட்டைச் சுத்திகரித்து, ");
INSERT INTO tam2017_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","உயிருள்ள குருவியைப் பட்டணத்திற்கு வெளியிலே விட்டுவிட்டு, இப்படி வீட்டிற்குப் பிராயச்சித்தம் செய்யக்கடவன்; அப்பொழுது அது சுத்தமாக இருக்கும்”. ");
INSERT INTO tam2017_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","இது சகலவித தொழுநோய்க்கும், சொறிக்கும், ");
INSERT INTO tam2017_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","உடைப் பூசணத்திற்கும், வீட்டுப்பூசணத்திற்கும், ");
INSERT INTO tam2017_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","தடிப்புக்கும், அசறுக்கும், வெள்ளைப்படருக்கும் உரிய விதிமுறை. ");
INSERT INTO tam2017_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","தொழுநோய் மற்றும் பூசணம், எப்பொழுது தீட்டுள்ளது என்றும், எப்பொழுது தீட்டில்லாதது என்றும் தெரிவிப்பதற்கு தொழுநோய்க்குரிய விதிமுறைகள் இதுவே என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","பின்னும் யெகோவா மோசேயையும் ஆரோனையும் நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“நீங்கள் இஸ்ரவேல் மக்களிடம் சொல்லவேண்டியது என்னவென்றால்: ஒருவனுக்கு விந்து கழிதல் உண்டானால், அதினாலே அவன் தீட்டானவன். ");
INSERT INTO tam2017_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","அவனுடைய மாம்சத்திலுள்ள விந்து ஊறிக்கொண்டிருந்தாலும், அவன் விந்து அடைபட்டிருந்தாலும், அதினால் அவனுக்குத் தீட்டுண்டாகும். ");
INSERT INTO tam2017_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","விந்து கழிதல் உள்ளவன் படுக்கிற எந்தப் படுக்கையும் தீட்டாகும்; அவன் எதின்மேல் உட்காருகிறானோ அதுவும் தீட்டாகும். ");
INSERT INTO tam2017_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","அவனுடைய படுக்கையைத் தொடுகிறவன் தன் உடைகளைத் துவைத்து, தண்ணீரில் குளிக்கவேண்டும்; மாலைவரைத் அவன் தீட்டுப்பட்டிருப்பானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","விந்து கழிதல் உள்ளவன் உட்கார்ந்த இடத்தில் உட்காருகிறவன் தன் உடைகளைத் துவைத்து, தண்ணீரில் குளித்து, மாலைவரைத் தீட்டுப்பட்டிருப்பானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","விந்து கழிதல் உள்ளவனின் உடலைத் தொடுகிறவன் தன் உடைகளைத் துவைத்து, தண்ணீரில் குளித்து, மாலைவரைத் தீட்டுப்பட்டிருப்பானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","விந்து கழிதல் உள்ளவன் சுத்தமாக இருக்கிற ஒருவன்மேல் துப்பினால், இவன் தன் உடைகளைத் துவைத்து, தண்ணீரில் குளித்து, மாலைவரைத் தீட்டுப்பட்டிருப்பானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","விந்து கழிதல் உள்ளவன் ஏறும் எந்தச் சேணமும் தீட்டாயிருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","அவனுக்குக் கீழிருந்த எதையாகிலும் தொடுகிறவன் மாலைவரைத் தீட்டுப்பட்டிருப்பான்; அதை எடுத்துக்கொண்டு போகிறவன் தன் உடைகளைத் துவைத்து, தண்ணீரில் குளித்து, மாலைவரைத் தீட்டுப்பட்டிருப்பானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","விந்து கழிதல் உள்ளவன் தன் கைகளைத் தண்ணீரினால் கழுவாமல் ஒருவனைத் தொட்டால், இவன் தன் உடைகளைத் துவைத்து, தண்ணீரில் குளித்து, மாலைவரைத் தீட்டுப்பட்டிருப்பானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","விந்து கழிதல் உள்ளவன் தொட்ட மண்பானை உடைக்கப்படவும், மரச்சாமான் அனைத்தும் தண்ணீரினால் கழுவப்படவும் வேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“விந்து கழிதல் உள்ளவன் தன் விந்து கழிதல் நீங்கிச் சுத்தமானால், தன் சுத்திகரிப்புக்கென்று ஏழுநாட்கள் எண்ணிக்கொண்டிருந்து, தன் உடைகளைத் துவைத்து, தன் உடலை ஊற்றுநீரில் கழுவுவானாக; அப்பொழுது சுத்தமாக இருப்பான். ");
INSERT INTO tam2017_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","எட்டாம்நாளிலே, அவன் இரண்டு காட்டுப்புறாக்களையாவது, இரண்டு புறாக்குஞ்சுகளையாவது, ஆசரிப்புக்கூடாரத்தின் வாசலிலே யெகோவாவுடைய சந்நிதியில் கொண்டுவந்து, ஆசாரியனிடத்தில் கொடுக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","ஆசாரியன் அவைகளில் ஒன்றை பாவநிவாரணபலியும் மற்றொன்றைச் சர்வாங்கதகனபலியுமாக, அவனுக்காகக் யெகோவாவுடைய சந்நிதியில் அவனுடைய விந்து கழிதலின் காரணமாக பாவநிவிர்த்தி செய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ஒருவனிலிருந்து விந்து கழிந்ததுண்டானால், அவன் தண்ணீரில் குளிக்கவேண்டும்; மாலைவரை அவன் தீட்டுப்பட்டிருப்பானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","கழிந்த விந்து பட்ட உடையும் தோலும் தண்ணீரினால் கழுவப்பட்டு, மாலைவரைத் தீட்டாயிருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","விந்து கழிந்தவனோடே பெண் படுத்துக்கொண்டிருந்தால், இருவரும் தண்ணீரில் குளித்து, மாலைவரைத் தீட்டுப்பட்டிருப்பார்களாக. ");
INSERT INTO tam2017_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“மாதவிடாய் உள்ள பெண் தன் உடலிலுள்ள இரத்தப்போக்கினிமித்தமாக ஏழுநாட்கள் தன் விலக்கத்தில் இருப்பாளாக; அவளைத் தொடுகிறவன் எவனும் மாலைவரைத் தீட்டுப்பட்டிருப்பானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","அவள் விலக்கத்தில் இருக்கும்போது, எதின்மேல் படுத்துக்கொள்ளுகிறாளோ எதின்மேல் உட்காருகிறாளோ அதெல்லாம் தீட்டாயிருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","அவளுடைய படுக்கையைத் தொடுகிறவன் எவனும் தன் உடைகளைத் துவைத்து, தண்ணீரில் குளித்து, மாலைவரைத் தீட்டுப்பட்டிருப்பானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","அவள் உட்கார்ந்த இருக்கையைத் தொடுகிறவன் எவனும் தன் உடைகளைத் துவைத்து, தண்ணீரில் குளித்து, மாலைவரைத் தீட்டுப்பட்டிருப்பானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","அவள் படுக்கையின்மேலாகிலும், அவள் உட்கார்ந்த இருக்கையின்மேலாகிலும் இருந்த எதையாகிலும் தொட்டவன், மாலைவரைத் தீட்டுப்பட்டிருப்பானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","ஒருவன் அவளோடே படுத்துக்கொண்டதும், அவளுடைய தீட்டு, அவன்மேல் பட்டிருந்தால், அவன் ஏழுநாட்கள் தீட்டாயிருப்பானாக; அவன் படுக்கிற படுக்கையும் தீட்டுப்படும். ");
INSERT INTO tam2017_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ஒரு பெண் விலகியிருக்க வேண்டியகாலம் அல்லாமல் அவளுடைய இரத்தம் அநேகநாட்கள் ஊறிக்கொண்டிருந்தால், அல்லது அந்தக் காலத்திற்கும் அதிகமாக அது இருக்கும் நாட்களெல்லாம் ஊறிக்கொண்டிருந்தால், தன் விலக்கத்தின் நாட்களிலிருந்ததுபோல அவள் தீட்டாயிருப்பாளாக. ");
INSERT INTO tam2017_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","அந்த நாட்களெல்லாம் அவள் படுக்கும் எந்தப் படுக்கையும், அவள் விலக்கத்தின் படுக்கையைப்போல, அவளுக்குத் தீட்டாயிருக்கும்; அவள் உட்கார்ந்த இருக்கையும், அவளுடைய விலக்கத்தின் தீட்டைப்போலவே தீட்டாயிருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","அப்படிப்பட்டவைகளைத் தொடுகிறவன் எவனும் தன் உடைகளைத் துவைத்து, தண்ணீரில் குளித்து, மாலைவரைத் தீட்டுப்பட்டிருப்பானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","அவள் தன் இரத்தப்போக்கு நின்று சுத்தமானபோது, அவள் ஏழுநாட்கள் எண்ணிக்கொள்வாளாக; அதின்பின்பு சுத்தமாக இருப்பாள். ");
INSERT INTO tam2017_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","எட்டாம்நாளிலே இரண்டு காட்டுப்புறாக்களையாவது, இரண்டு புறாக்குஞ்சுகளையாவது, ஆசரிப்புக்கூடாரத்தின் வாசலில் ஆசாரியனிடத்தில் கொண்டுவரக்கடவள். ");
INSERT INTO tam2017_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","ஆசாரியன் அவைகளில் ஒன்றைப் பாவநிவாரணபலியும், மற்றொன்றைச் சர்வாங்க தகனபலியுமாக, அவளுக்காகக் யெகோவாவுடைய சந்நிதியில் அவளுடைய இரத்தப்போக்கினிமித்தம் பாவநிவிர்த்தி செய்யக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“இஸ்ரவேல் மக்கள் தங்கள் நடுவே இருக்கிற என்னுடைய வாசஸ்தலத்தைத் தீட்டுப்படுத்தி, தங்கள் தீட்டுகளால் மரணமடையாமலிருக்க, இப்படி நீங்கள் அவர்களுடைய தீட்டுகளுக்கு அவர்களை விலக்கிவைப்பீர்களாக”. ");
INSERT INTO tam2017_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","விந்து கழிதல் உள்ளவனுக்கும், விந்து கழிந்ததினாலே தீட்டானவனுக்கும், ");
INSERT INTO tam2017_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","இரத்தப்போக்கு பலவீனமுள்ளவளுக்கும், விந்து கழிதல் உள்ள பெண்களுக்கும், ஆண்களுக்கும், தீட்டாயிருக்கிறவளோடே படுத்துக்கொண்டவனுக்கும் உரிய விதிமுறைகள் இதுவே என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","ஆரோனின் இரண்டு மகன்கள் யெகோவாவுடைய சந்நிதியிலே சேர்ந்து மரணமடைந்தபின்பு, யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","“கிருபாசனத்தின்மேல் ஒரு மேகத்தில் நான் காணப்படுவேன்; ஆதலால் உன் சகோதரனாகிய ஆரோன் மரணமடையாமலிருக்க, பரிசுத்த ஸ்தலத்திலே திரைக்கு உட்புறத்திலிருக்கிற பெட்டியின்மேலுள்ள கிருபாசன மூடிக்கு முன்பாக எல்லா நேரங்களிலும் வரவேண்டாம் என்று அவனுக்குச் சொல். ");
INSERT INTO tam2017_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","ஆரோன் பரிசுத்த ஸ்தலத்திற்குள் நுழையவேண்டிய விதமாவது: அவன் ஒரு காளையைப் பாவநிவாரணபலியாகவும், ஒரு ஆட்டுக்கடாவைச் சர்வாங்க தகனபலியாகவும் செலுத்தி நுழையவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","அவன் பரிசுத்தமான சணல்நூல்சட்டையை அணிந்து, தன் இடுப்பிற்குச் சணல்நூல் உள்ளாடையைப் போட்டு, சணல்நூல் இடுப்புக்கச்சையைக் கட்டி, சணல்நூல் தலைப்பாகையைத் அணிந்துகொண்டிருக்கவேண்டும்; அவைகள் பரிசுத்த உடைகள்; அவன் தண்ணீரில் குளித்து, அவைகளை அணிந்துகொண்டு, ");
INSERT INTO tam2017_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","இஸ்ரவேல் மக்களாகிய சபையாரிடத்திலே, பாவநிவாரணபலியாக இரண்டு வெள்ளாட்டுக்கடாக்களையும், சர்வாங்கதகனபலியாக ஒரு ஆட்டுகடாவையும் வாங்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","பின்பு ஆரோன் தனக்காகவும் தன் வீட்டாருக்காகவும் பாவநிவிர்த்தி செய்யும்படி, தன்னுடைய பாவநிவாரணபலியின் காளையைச் சேரச்செய்து, ");
INSERT INTO tam2017_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","அந்த இரண்டு வெள்ளாட்டுக்கடாக்களையும் கொண்டுவந்து, ஆசரிப்புக்கூடாரத்தின் வாசலிலே யெகோவாவுடைய சந்நிதியில் நிறுத்தி, ");
INSERT INTO tam2017_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","அந்த இரண்டு வெள்ளாட்டுக்கடாக்களையும் குறித்துக் யேகோவாக்கென்று ஒரு சீட்டும், போக்காடாக விடப்படும் வெள்ளாட்டுக்கடாவுக்கென்று ஒரு சீட்டும் போட்டு, ");
INSERT INTO tam2017_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","யெகோவாக்கென்று சீட்டு விழுந்த வெள்ளாட்டுக்கடாவைப் பாவநிவாரணபலியாகச் சேரச்செய்து, ");
INSERT INTO tam2017_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","போக்காடாக விடப்படச் சீட்டு விழுந்த வெள்ளாட்டுக்கடாவை, அதைக்கொண்டு பாவநிவிர்த்தி உண்டாக்கவும் அதைப் போக்காடாக வனாந்திரத்திலே போகவிடவும், யெகோவாவுடைய சந்நிதியில் உயிரோடே நிறுத்தி; ");
INSERT INTO tam2017_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“பின்பு ஆரோன் தனக்காகவும் தன் வீட்டாருக்காகவும் பாவநிவிர்த்தி செய்யும்படி, தன்னுடைய பாவநிவாரணத்திற்கான காளையைக் கொண்டுவந்து, அதைக் கொன்று, ");
INSERT INTO tam2017_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","யெகோவாவுடைய சந்நிதியிலிருக்கும் பலிபீடத்தின்மேலுள்ள நெருப்புத்தணலினால் தூபகலசத்தை நிரப்பி, பொடியாக்கப்பட்ட நறுமண தூபவர்க்கத்திலே தன் கைப்பிடிகள் நிறைய எடுத்து, திரைக்கு உட்புறமாகக் கொண்டுவந்து, ");
INSERT INTO tam2017_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","தான் மரணமடையாமலிருக்க தூபமேகமானது சாட்சிப்பெட்டியின்மேல் இருக்கும் கிருபாசனத்தை மூடத்தக்கதாக, யெகோவாவுவுடைய சந்நிதியில் நெருப்பின்மேல் தூபவர்க்கத்தைப் போடக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","பின்பு காளையின் இரத்தத்திலே கொஞ்சம் எடுத்து, கீழ்ப்புறமாக நின்று, தன் விரலினால் கிருபாசனத்தின்மேல் தெளித்து, அந்த இரத்தத்தில் கொஞ்சம் எடுத்துக் கிருபாசனத்திற்கு முன்பாக ஏழுமுறை தன் விரலினால் தெளிக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","பின்பு மக்களுடைய பாவநிவாரணபலியான வெள்ளாட்டுக்கடாவை அவன் கொன்று, அதின் இரத்தத்தைத் திரைக்கு உட்புறமாகக் கொண்டுவந்து, காளையின் இரத்தத்தைத் தெளித்ததுபோல, அதின் இரத்தத்தையும் கிருபாசனத்தின்மேலும் அதற்கு முன்பாகவும் தெளித்து, ");
INSERT INTO tam2017_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","இஸ்ரவேல் மக்களுடைய தீட்டுகளினிமித்தமும், அவர்களுடைய சகல பாவங்களினாலும் உண்டான அவர்களுடைய மீறுதல்களினிமித்தமும், பரிசுத்த ஸ்தலத்திற்காகப் பிராயச்சித்தம்செய்து, அவர்களிடத்தில் அவர்களுடைய தீட்டுகளுக்குள்ளே நிற்கிற ஆசரிப்புக்கூடாரத்திற்காகவும் அப்படியே செய்யக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","பாவநிவிர்த்தி செய்யும்படி அவன் பரிசுத்த ஸ்தலத்திற்குள் நுழைந்து, தனக்காகவும் தன் வீட்டாருக்காகவும் இஸ்ரவேல் சபையார் அனைவருக்காகவும் பாவநிவிர்த்தி செய்து, வெளியே வருமளவும் ஆசரிப்புக்கூடாரத்தில் ஒருவரும் இருக்கக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","பின்பு அவன் யெகோவாவுடைய சந்நிதியில் இருக்கிற பலிபீடத்தண்டை வந்து, அதற்காகப் பிராயச்சித்தம்செய்து, காளையின் இரத்தத்திலும் வெள்ளாட்டுக் கடாவின் இரத்தத்திலும் கொஞ்சம் எடுத்து, பலிபீடத்துக் கொம்புகளின்மேல் சுற்றிலும் பூசி, ");
INSERT INTO tam2017_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","தன் விரலினால் அந்த இரத்தத்தில் எடுத்து, ஏழுமுறை அதின்மேல் தெளித்து, அதை இஸ்ரவேல் மக்களின் தீட்டுகள் நீங்கச் சுத்திகரித்து, பரிசுத்தப்படுத்தவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“அவன் இப்படிப் பரிசுத்த ஸ்தலத்திற்கும் ஆசரிப்புக்கூடாரத்திற்கும் பலிபீடத்திற்கும் பிராயச்சித்தம் செய்துமுடிந்தபின்பு, உயிரோடிருக்கிற வெள்ளாட்டுக்கடாவைச் சேரச்செய்து, ");
INSERT INTO tam2017_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","அதின் தலையின்மேல் ஆரோன் தன் இரண்டு கைகளையும் வைத்து, அதின்மேல் இஸ்ரவேல் மக்களுடைய சகல அக்கிரமங்களையும் அவர்களுடைய எல்லாப் பாவங்களினாலும் உண்டான அவர்களுடைய சகல மீறுதல்களையும் அறிக்கையிட்டு, அவைகளை வெள்ளாட்டுக்கடாவினுடைய தலையின்மேல் சுமத்தி, அதை அதற்கான ஒருவன் கையில் கொடுத்து வனாந்திரத்திற்கு அனுப்பிவிடுவானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","அந்த வெள்ளாட்டுக்கடா அவர்களுடைய அக்கிரமங்களையெல்லாம் தன்மேல் சுமந்துகொண்டு, குடியில்லாத தேசத்திற்குப் போவதாக; அவன் அந்த வெள்ளாட்டுக்கடாவை வனாந்திரத்திலே போகவிடக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“ஆரோன் ஆசரிப்புக்கூடாரத்திற்குள் வந்து, தான் பரிசுத்த ஸ்தலத்திற்குள் நுழையும்போது, அணிந்திருந்த சணல்நூல் உடைகளைக் கழற்றி, அங்கே வைத்துவிட்டு, ");
INSERT INTO tam2017_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","பரிசுத்த இடத்திலே தண்ணீரில் குளித்து, தன் உடைகளை அணிந்துகொண்டு, வெளியே வந்து, தன் சர்வாங்கதகனபலியையும் மக்களின் சர்வாங்கதகனபலியையும் செலுத்தி, தனக்காகவும் மக்களுக்காகவும் பாவநிவிர்த்தி செய்து, ");
INSERT INTO tam2017_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","பாவநிவாரணபலியின் கொழுப்பைப் பலிபீடத்தின்மேல் எரிக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","போகவிடப்படும் போக்காடாகிய வெள்ளாட்டுக்கடாவைக் கொண்டுபோய் விட்டவன், தன் உடைகளைத் துவைத்து, தண்ணீரில் குளித்து, பின்பு முகாமிற்குள் வருவானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","பாவநிவிர்த்திக்கென்று பரிசுத்த ஸ்தலத்திற்குள் இரத்தம் கொண்டுவரப்பட்ட பாவநிவாரணபலியாகிய காளையையும், பாவநிவாரணபலியாகிய வெள்ளாட்டுக்கடாவையும், முகாமிற்கு வெளியே கொண்டுபோய், அவைகளின் தோலையும், மாம்சத்தையும், சாணியையும் நெருப்பிலே சுட்டெரிக்கக்கடவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","அவைகளைச் சுட்டெரித்தவன் தன் உடைகளைத் துவைத்து, தண்ணீரில் குளித்து, பின்பு முகாமிற்குள் வருவானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“ஏழாம் மாதம் பத்தாம் தேதியிலே, இஸ்ரவேலனானாலும், உங்களுக்குள் தங்கும் அந்நியனானாலும், தங்கள் ஆத்துமாக்களைத் தாழ்மைப்படுத்துவதுமன்றி, ஒரு வேலையும் செய்யாமல் இருக்கவேண்டும்; இது உங்களுக்கு நிரந்தரமான கட்டளையாக இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","யெகோவாவுடைய சந்நிதியில் உங்கள் பாவமெல்லாம் நீங்கிச் சுத்திகரிக்கப்படும்படி, அந்நாளில் உங்களைச் சுத்திகரிக்க, உங்களுக்காகப் பாவநிவிர்த்தி செய்யப்படும். ");
INSERT INTO tam2017_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","உங்களுக்கு அது விசேஷித்த ஓய்வுநாள்; அதிலே உங்கள் ஆத்துமாக்களைத் தாழ்மைப்படுத்தக்கடவீர்கள்; இது நிரந்தரமான கட்டளை. ");
INSERT INTO tam2017_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","அபிஷேகம் பெற்றவனும், தன் தகப்பனுடைய பட்டத்திற்கு வந்து ஆசாரிய ஊழியம்செய்யப் பிரதிஷ்டை செய்யப்பட்டவனுமாகிய ஆசாரியனே பாவநிவிர்த்தி செய்யக்கடவன். அவன் பரிசுத்த உடைகளாகிய சணல்நூல் உடைகளை அணிந்துகொண்டு, ");
INSERT INTO tam2017_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","பரிசுத்த ஸ்தலத்திற்கும் ஆசரிப்புக்கூடாரத்திற்கும், பலிபீடத்திற்கும், பிராயச்சித்தம்செய்து, ஆசாரியர்களுக்காகவும் சபையின் சகல மக்களுக்காகவும் பாவநிவிர்த்தி செய்யக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","இப்படி வருடத்தில் ஒருமுறை இஸ்ரவேல் மக்களுக்காக, அவர்களுடைய சகல பாவங்களுக்கும் பாவநிவிர்த்தி செய்வது, உங்களுக்கு நிரந்தரமான கட்டளையாக இருப்பதாக என்று சொல் என்றார். யெகோவா மோசேக்குக் கட்டளையிட்டபடியே ஆரோன் செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“நீ ஆரோனோடும் அவனுடைய மகன்களோடும் இஸ்ரவேல் மக்கள் அனைவரோடும் சொல்லவேண்டியதாவது; யெகோவா கட்டளையிடுகிறது என்னவென்றால்: ");
INSERT INTO tam2017_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","இஸ்ரவேல் குடும்பத்தாரில் எவனாகிலும் மாட்டையாவது செம்மறியாட்டையாவது வெள்ளாட்டையாவது ஆசரிப்புக்கூடாரத்தின் வாசலாகிய யெகோவாவுடைய வாசஸ்தலத்திற்கு முன்பாக, யெகோவாவுக்குச் செலுத்தும்படி கொண்டுவராமல், ");
INSERT INTO tam2017_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","முகாமிற்குள்ளேயோ அல்லது வெளியேயோ அதைக் கொன்றால், அது அந்த மனிதனுக்கு இரத்தப்பழியாகக் கருதப்படும். அந்த மனிதன் இரத்தம் சிந்தினபடியால், தன் மக்களுக்குள் இல்லாமல் அறுப்புண்டுபோவான். ");
INSERT INTO tam2017_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","ஆகையால் இஸ்ரவேல் மக்கள் வெளியிலே பலியிடுகிற தங்களுடைய பலிகளை, ஆசரிப்புக்கூடாரத்தின் வாசலில் ஆசாரியனிடத்தில் யெகோவாவுடைய சந்நிதியில் கொண்டுவந்து, அங்கே அவைகளைக் யெகோவாவுக்குச் சமாதானபலிகளாகச் செலுத்தக்கடவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","அங்கே ஆசாரியன், இரத்தத்தை ஆசரிப்புக்கூடாரத்தின் வாசலில் இருக்கிற யெகோவாவுடைய பலிபீடத்தின்மேல் தெளித்து, கொழுப்பைக் யெகோவாவுக்கு நறுமண வாசனையாக எரிக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","தாங்கள் முறைகேடான முறையில் பின்பற்றுகிற பேய்களுக்குத் தங்கள் பலிகளை இனிச் செலுத்தாமல் இருப்பார்களாக; இது அவர்கள் தலைமுறைதோறும் அவர்களுக்கு நிரந்தரமான கட்டளையாக இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","மேலும் நீ அவர்களை நோக்கி: “இஸ்ரவேல் குடும்பத்தாரிலும் உங்கள் நடுவே தங்குகிற அந்நியர்களிலும் எவனாகிலும் சர்வாங்கதகனபலி முதலானவைகளைச் செலுத்தி, ");
INSERT INTO tam2017_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","அதை ஆசரிப்புக்கூடாரத்தின் வாசலிலே யெகோவாவுக்குச் செலுத்தும்படி கொண்டுவராவிட்டால், அவன் தன் மக்களுக்குள் இல்லாமல் அறுப்புண்டுபோவான் என்று சொல். ");
INSERT INTO tam2017_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“இஸ்ரவேல் குடும்பத்தாரிலும் உங்களுக்குள் தங்கும் அந்நியர்களிலும் எவனாகிலும் எந்தவொரு இரத்தத்தைச் சாப்பிட்டால், இரத்தத்தைச் சாப்பிட்ட அவனுக்கு விரோதமாக நான் என் முகத்தைத் திருப்பி, அவன் தன் மக்களுக்குள் இல்லாதபடி அவனை அறுப்புண்டுபோகச் செய்வேன். ");
INSERT INTO tam2017_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","மாம்சத்தின் உயிர் இரத்தத்தில் இருக்கிறது; நான் அதை உங்களுக்குப் பலிபீடத்தின்மேல் உங்கள் ஆத்துமாக்களுக்காகப் பாவநிவிர்த்தி செய்யும்படிக் கட்டளையிட்டேன்; ஆத்துமாவிற்காகப் பாவநிவிர்த்தி செய்கிறது இரத்தமே. ");
INSERT INTO tam2017_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","ஆகவே உங்களில் ஒருவனும் இரத்தம் சாப்பிடவேண்டாம், உங்கள் நடுவே தங்குகிற அந்நியனும் இரத்தம் சாப்பிடவேண்டாம்” என்று இஸ்ரவேல் மக்களுக்குச் சொன்னேன். ");
INSERT INTO tam2017_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“இஸ்ரவேல் மக்களிலும் உங்களுக்குள் தங்குகிற அந்நியர்களிலும் எவனாகிலும் சாப்பிடத்தக்க ஒரு மிருகத்தையாவது ஒரு பறவையையாவது வேட்டையாடிப் பிடித்தால், அவன் அதின் இரத்தத்தைச் சிந்தச்செய்து, மண்ணினால் அதை மூடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","சகல மாம்சத்திற்கும் இரத்தம் உயிராக இருக்கிறது; இரத்தம் உயிருக்குச் சமானம்; ஆகையால் எந்த மாம்சத்தின் இரத்தத்தையும் சாப்பிடவேண்டாம்; சகல மாம்சத்தின் உயிரும் அதின் இரத்தம் தானே; அதைச் சாப்பிடுகிற எவனும் அறுப்புண்டுபோவான் என்று இஸ்ரவேல் மக்களுக்குச் சொன்னேன். ");
INSERT INTO tam2017_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","தானாக இறந்துபோனதையாவது, பீறுண்டதையாவது சாப்பிட்டவன் எவனும் அவன் இஸ்ரவேலனானாலும் அந்நியனானாலும், தன் உடைகளைத் துவைத்து, தண்ணீரில் குளித்து, மாலைவரைத் தீட்டாயிருப்பானாக; பின்பு சுத்தமாக இருப்பான். ");
INSERT INTO tam2017_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","அவன் தன் உடைகளைத் துவைக்காமலும், குளிக்காமலும் இருந்தால், தன் அக்கிரமத்தைச் சுமப்பான் என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“நீ இஸ்ரவேல் மக்களுக்குச் சொல்லவேண்டியது என்னவென்றால்: நான் உங்கள் தேவனாகிய யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","நீங்கள் குடியிருந்த எகிப்துதேசத்தாருடைய செயல்களின்படி செய்யாமலும், நான் உங்களை அழைத்துப்போகிற கானான் தேசத்தாருடைய செயல்களின்படி செய்யாமலும், அவர்களுடைய முறைமைகளின்படி நடவாமலும், ");
INSERT INTO tam2017_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","என்னுடைய நியாயங்களின்படி செய்து, என்னுடைய கட்டளைகளைக் கைக்கொண்டு நடங்கள்; நான் உங்கள் தேவனாகிய யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","“ஆகையால் என் கட்டளைகளையும் நியாயங்களையும் கைக்கொள்ளக்கடவீர்கள்; அவைகளின்படி செய்கிறவன் எவனும் அவைகளால் பிழைப்பான்; நான் யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ஒருவனும் தனக்கு நெருங்கின இனமாகிய ஒருத்தியை நிர்வாணமாக்குவதற்கு அவளைச் சேரக்கூடாது; நான் யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","உன் தகப்பனையாவது உன் தாயையாவது நிர்வாணமாக்கக்கூடாது; அவள் உன் தாயானவள்; அவளை நிர்வாணமாக்கக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","உன் தகப்பனுடைய மனைவியை நிர்வாணமாக்கக்கூடாது; அது உன் தகப்பனுடைய நிர்வாணம். ");
INSERT INTO tam2017_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","உன் தகப்பனுக்காவது உன் தாய்க்காவது வீட்டிலோ வெளியிலோ பிறந்த மகளாகிய உன் சகோதரியை நிர்வாணமாக்கக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","உன் மகனுடைய மகளையாவது உன் மகளுடைய மகளையாவது நிர்வாணமாக்கக்கூடாது; அது உன்னுடைய நிர்வாணம். ");
INSERT INTO tam2017_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","உன் தகப்பனுடைய மனைவியிடத்தில் உன் தகப்பனுக்குப் பிறந்த மகளை நிர்வாணமாக்கக்கூடாது; அவள் உனக்குச் சகோதரி. ");
INSERT INTO tam2017_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","உன் தகப்பனுடைய சகோதரியை நிர்வாணமாக்கக்கூடாது; அவள் உன் தகப்பனுக்கு நெருங்கின உறவானவள். ");
INSERT INTO tam2017_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","உன் தாயினுடைய சகோதரியை நிர்வாணமாக்கக்கூடாது; அவள் உன் தாய்க்கு நெருங்கின உறவானவள். ");
INSERT INTO tam2017_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","உன் தகப்பனுடைய சகோதரனை நிர்வாணமாக்கக்கூடாது; அவன் மனைவியைச் சேராதே; அவள் உன் தகப்பனுடைய சகோதரி. ");
INSERT INTO tam2017_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","உன் மருமகளை நிர்வாணமாக்கக்கூடாது; அவள் உன் மகனுக்கு மனைவி, அவளை நிர்வாணமாக்கக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","உன் சகோதரனுடைய மனைவியை நிர்வாணமாக்கக்கூடாது; அது உன் சகோதரனுடைய நிர்வாணம். ");
INSERT INTO tam2017_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","ஒரு பெண்ணையும் அவளுடைய மகளையும் நிர்வாணமாக்கக்கூடாது; அவளுடைய மகன்களின் மகளையும் மகளின் மகளையும் நிர்வாணமாக்கும்படி திருமணம் செய்யக்கூடாது; இவர்கள் அவளுக்கு நெருங்கின உறவானவர்கள்; அது முறைகேடு. ");
INSERT INTO tam2017_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","உன் மனைவி உயிரோடிருக்கும்போது அவளுக்கு உபத்திரவமாக அவள் சகோதரியையும் நிர்வாணமாக்குவதற்காக அவளைத் திருமணம் செய்யக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“பெண்ணானவள் மாதவிலக்கால் விலக்கப்பட்டிருக்கும்போது, அவளை நிர்வாணமாக்க அவளோடே சேராதே. ");
INSERT INTO tam2017_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","பிறனுடைய மனைவியோடே சேர்ந்து உடலுறவுகொண்டு, அவள்மூலம் உன்னைத் தீட்டுப்படுத்திக் கொள்ளவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","நீ உன் சந்ததியில் யாரையாகிலும் மோளேகு தெய்வத்திற்கென்று தீயில் பலியாக்க இடம்கொடுக்காதே; உன் தேவனுடைய நாமத்தைப் பரிசுத்தக் குலைச்சலாக்காதே; நான் யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","பெண்ணோடு உடலுறவு செய்வதுபோல ஆணோடே உடலுறவு செய்யவேண்டாம்; அது அருவருப்பானது. ");
INSERT INTO tam2017_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","எந்தவொரு மிருகத்தோடும் நீ உடலுறவுகொண்டு, அதினாலே உன்னைத் தீட்டுப்படுத்த வேண்டாம்; பெண்ணானவள் மிருகத்தோடே உடலுறவுகொள்ள ஏதுவாக அதற்கு முன்பாக நிற்கக்கூடாது; அது அருவருப்பான தாறுமாறு. ");
INSERT INTO tam2017_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“இவைகளில் ஒன்றினாலும் உங்களைத் தீட்டுப்படுத்தாதிருங்கள்; நான் உங்கள் முன்னின்று துரத்திவிடுகிற மக்கள் இவைகளெல்லாவற்றாலும் தங்களைத் தீட்டுப்படுத்தியிருக்கிறார்கள்; தேசமும் தீட்டுப்படுத்தப்பட்டிருக்கிறது. ");
INSERT INTO tam2017_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","ஆகையால் அதின் அக்கிரமத்தை விசாரிப்பேன்; தேசம் தன் மக்களை புறக்கணித்துவிடும். ");
INSERT INTO tam2017_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","இந்த அருவருப்புகளையெல்லாம் உங்களுக்குமுன் இருந்த அந்த தேசத்தின் மனிதர்கள் செய்ததினாலே தேசம் தீட்டானது. ");
INSERT INTO tam2017_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","இப்பொழுதும் உங்களுக்கு முன் இருந்த மக்களை தேசம் புறக்கணித்ததைப்போல, நீங்கள் அதைத் தீட்டுப்படுத்தும்போது அது உங்களையும் புறக்கணிக்காதிருக்க, ");
INSERT INTO tam2017_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","நீங்கள் என் கட்டளைகளையும் என் நியாயங்களையும் கைக்கொண்டு, தேசத்திலே பிறந்தவனானாலும் உங்கள் நடுவே தங்குகிற அந்நியனானாலும் இந்த அருவருப்புகளில் ஒன்றையும் செய்யவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","இப்படிப்பட்ட அருவருப்பானவைகளில் ஒன்றையாவது யாராவது செய்தால், செய்த அந்த ஆத்துமாக்கள் மக்களுக்குள் இல்லாதபடி அறுப்புண்டு போவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","ஆகையால் உங்களுக்குமுன் செய்யப்பட்ட அருவருப்பான முறைமைகளில் யாதொன்றை நீங்கள் செய்து, அவைகளால் உங்களைத் தீட்டுப்படுத்திக்கொள்ளாமலிருக்க என் கட்டளையைக் கைக்கொள்ளுங்கள்; நான் உங்கள் தேவனாகிய யெகோவா என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“நீ இஸ்ரவேல் மக்களின் சபை அனைத்தோடும் சொல்லவேண்டியது என்னவென்றால்: உங்கள் தேவனும் யெகோவாவாகிய நான் பரிசுத்தர், ஆகையால் நீங்களும் பரிசுத்தராக இருங்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","உங்களில் அவனவன் தன்தன் தாய்க்கும் தகப்பனுக்கும் பயந்திருக்கவும், என் ஓய்வு நாட்களை அனுசரிக்கவும்கடவீர்கள்; நான் உங்கள் தேவனாகிய யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","சிலைகளை நாடாமலும், வார்ப்பிக்கப்பட்ட தெய்வங்களை உங்களுக்கு உண்டாக்காமலும் இருப்பீர்களாக; நான் உங்கள் தேவனாகிய யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“நீங்கள் சமாதானபலியைக் யெகோவாவுக்குச் செலுத்தினால், அதை மன உற்சாகமாகச் செலுத்துங்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","நீங்கள் அதைச் செலுத்துகிற நாளிலும் மறுநாளிலும் அதைச் சாப்பிடவேண்டும்; மூன்றாம் நாள்வரை மீதியானது நெருப்பிலே சுட்டெரிக்கப்படக்கடவது. ");
INSERT INTO tam2017_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","மூன்றாம் நாளில் அதில் எதையாகிலும் சாப்பிட்டால் அருவருப்பாயிருக்கும்; அது அங்கீகரிக்கப்படமாட்டாது. ");
INSERT INTO tam2017_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","அதைச் சாப்பிடுகிறவன் யெகோவாவுக்குப் பரிசுத்தமானதைப் பரிசுத்தக்குலைச்சலாக்கினதினால் அவன் தன் அக்கிரமத்தைச் சுமந்து, தன் மக்களுக்குள் இல்லாதபடி அறுப்புண்டுபோவான். ");
INSERT INTO tam2017_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“நீங்கள் தேசத்தின் பயிரை அறுக்கும்போது, உன் வயலின் ஓரத்தில் இருக்கிறதை முற்றிலும் அறுக்காமலும், சிந்திக்கிடக்கிற கதிர்களைப் பொறுக்காமலும், ");
INSERT INTO tam2017_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","உன் திராட்சைத்தோட்டத்திலே பின் அறுப்பை அறுக்காமலும், அதிலே சிந்திக்கிடக்கிற பழங்களைப் பொறுக்காமலும், அவைகளை ஏழைகளுக்கும் பரதேசிக்கும் விட்டுவிடுவாயாக; நான் உங்கள் தேவனாகிய யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“நீங்கள் திருடாமலும், வஞ்சனைசெய்யாமலும், ஒருவருக்கொருவர் பொய் சொல்லாமலும் இருங்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","என் நாமத்தைக்கொண்டு பொய்யாணையிடுகிறதினால், உங்கள் தேவனுடைய நாமத்தைப் பரிசுத்தக் குலைச்சலாக்காமலும் இருப்பீர்களாக; நான் யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“பிறனை ஒடுக்காமலும் கொள்ளையிடாமலும் இருப்பாயாக; கூலிக்காரனுடைய கூலி விடியற்காலம்வரை உன்னிடத்தில் இருக்கக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","செவிடனை நிந்திக்காமலும், குருடனுக்கு முன்னே தடைகளை வைக்காமலும், உன் தேவனுக்குப் பயந்திருப்பாயாக; நான் யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“நியாயவிசாரணையில் அநியாயம் செய்யாதிருங்கள்; சிறியவனுக்கு முகதாட்சிணியம் செய்யாமலும், பெரியவனுடைய முகத்திற்கு பயப்படாமலும், நீதியாகப் பிறனுக்கு நியாயந்தீர்ப்பாயாக. ");
INSERT INTO tam2017_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","உன் மக்களுக்குள்ளே அங்கும் இங்கும் கோள்சொல்லித் திரியாதே; பிறனுடைய இரத்தப்பழிக்கு உட்படவேண்டாம்; நான் யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“உன் சகோதரனை உன் உள்ளத்தில் பகைக்காதே; பிறன்மேல் பாவம் சுமராதபடி அவனை எப்படியும் கடிந்து கொள்ளவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","பழிக்குப்பழி வாங்காமலும் உன் மக்கள்மேல் பொறாமைகொள்ளாமலும், உன்னில் நீ அன்புகூறுவதுபோல் பிறனிலும் அன்புகூருவாயாக; நான் யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“என் கட்டளைகளைக் கைக்கொள்வீர்களாக; உன் மிருகங்களை வேறு இனத்தோடே பெருகச்செய்யாதே; உன் வயலிலே வெவ்வேறு வகையான விதைகளைக் கலந்து விதைக்காதே; சணல்நூலும் கம்பளிநூலும் கலந்த உடையை அணியாதே ");
INSERT INTO tam2017_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ஒருவனுக்கு அடிமையானவள் ஒரு ஆணுக்கு நியமிக்கப்பட்டவளாக இருந்து, முற்றிலும் மீட்கப்படாமலும் தன்னிச்சையாக விடப்படாமலுமிருக்க, அவளோடே ஒருவன் காம உணர்வுடன் உடலுறவுகொண்டால், அவர்கள் கொலை செய்யப்படாமல், அடிக்கப்படவேண்டும்; அவள் சுதந்திரமுள்ளவள் அல்ல. ");
INSERT INTO tam2017_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","அவன் தன் குற்றநிவாரணபலியாக ஆசரிப்புக்கூடாரத்தின் வாசலிலே யெகோவாவுடைய சந்நிதியில் ஒரு ஆட்டுக்கடாவைக் கொண்டுவரக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","அதினாலே ஆசாரியன் அவன் செய்த பாவத்தினிமித்தம் அவனுக்காகக் யெகோவாவுடைய சந்நிதியில் பாவநிவிர்த்தி செய்யக்கடவன்; அப்பொழுது அவன் செய்த பாவம் அவனுக்கு மன்னிக்கப்படும். ");
INSERT INTO tam2017_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“நீங்கள் அந்த தேசத்தில் வந்து, சாப்பிடத்தக்க பழங்களைத் தருகிற பலவித மரங்களை நாட்டினபின்பு அவைகளின் பழங்களை விருத்தசேதனம் இல்லாதவைகளென்று கருதுவீர்களாக; மூன்று வருடங்கள் அது சாப்பிடப்படாமல், விருத்தசேதனம் இல்லாததாக உங்களுக்கு கருதப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","பின்பு நான்காம் வருடத்திலே அவைகளின் பழங்களெல்லாம் யெகோவாவுக்குத் துதிசெலுத்துகிறதற்கேற்ற பரிசுத்தமாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","ஐந்தாம் வருடத்திலே அவைகளின் பழங்களைச் சாப்பிடலாம்; இப்படி அவைகளின் பலன் உங்களுக்குப் பெருகும்; நான் உங்கள் தேவனாகிய யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“யாதொன்றையும் இரத்தத்துடன் சாப்பிடவேண்டாம். குறிகேட்காமலும், நாள்பார்க்காமலும் இருப்பீர்களாக. ");
INSERT INTO tam2017_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","உங்கள் தலைமுடியைச் சுற்றி ஒதுக்காமலும், தாடியின் ஓரங்களைக் கத்தரிக்காமலும், ");
INSERT INTO tam2017_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","செத்தவனுக்காக உங்கள் உடலைக் கீறிக்கொள்ளாமலும், அடையாளமான எழுத்துக்களை உங்கள்மேல் குத்திக்கொள்ளாமலும் இருப்பீர்களாக; நான் யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“தேசத்தார் வேசித்தனம்செய்து தேசமெங்கும் முறைகேடான பாவம் நிறையாதபடி உன் மகளை வேசித்தனம்செய்ய விடுகிறதினாலே பரிசுத்தக் குலைச்சலாக்காதே. ");
INSERT INTO tam2017_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","என் ஓய்வுநாட்களை அனுசரித்து, என் பரிசுத்த ஸ்தலத்தைக்குறித்துப் பயபக்தியாக இருப்பீர்களாக; நான் யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“மாந்திரீகம் செய்கிறவர்களை நாடி, குறிசொல்லுகிறவர்களைத் தேடாதிருங்கள்; அவர்களாலே தீட்டுப்படவேண்டாம்; நான் உங்கள் தேவனாகிய யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“நரைத்தவனுக்கு முன்பாக எழுந்து, முதிர்வயதுள்ளவன் முகத்தைக் கனப்படுத்தி, உன் தேவனுக்குப் பயப்படுவாயாக; நான் யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“யாதொரு அந்நியன் உங்கள் தேசத்தில் உங்களோடே தங்கினால், அவனைச் சிறுமைப்படுத்தவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","உங்களிடத்தில் குடியிருக்கிற அந்நியனை இஸ்ரவேலனைப்போல கருதி, நீங்கள் உங்களில் அன்புசெலுத்துவதுபோல அவனிலும் அன்புசெலுத்துவீர்களாக; நீங்களும் எகிப்துதேசத்தில் அந்நியர்களாக இருந்தீர்களே; நான் உங்கள் தேவனாகிய யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“நியாயவிசாரணையிலும், அளவிலும், நிறையிலும், படியிலும் அநியாயம் செய்யாதிருப்பீர்களாக. ");
INSERT INTO tam2017_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","நியாயமான தராசும், நியாயமான நிறைகல்லும், நியாயமான மரக்காலும், நியாயமான படியும் உங்களுக்கு இருக்கவேண்டும்; நான் உங்களை எகிப்துதேசத்திலிருந்து புறப்படச்செய்த உங்கள் தேவனாகிய யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","ஆகையால் என்னுடைய கட்டளைகள், நியாயங்கள் யாவையும் கைக்கொண்டு, அவைகளின்படி நடக்கக்கடவீர்கள்; நான் யெகோவா என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“பின்னும் நீ இஸ்ரவேல் மக்களிடம் சொல்லவேண்டியது என்னவென்றால்; இஸ்ரவேல் மக்களிலும் இஸ்ரவேலில் குடியிருக்கிற அந்நியர்களிலும் எவனாகிலும் தன் சந்ததியில் ஒரு பிள்ளையை மோளேகு தெய்வத்திற்கென்று கொடுத்தால், அவன் கொலைசெய்யப்படவேண்டும்; தேசத்தின் மக்கள் அவன்மேல் கல்லெறியவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","அவன் என் பரிசுத்த ஸ்தலத்தைத் தீட்டுப்படுத்தி, என் பரிசுத்த நாமத்தைப் பரிசுத்தக் குலைச்சலாக்கும்படி, தன் சந்ததியில் ஒரு பிள்ளையை மோளேகுக்குக் கொடுத்ததினாலே, நான் அப்படிப்பட்டவனுக்கு விரோதமாக எதிர்த்து நின்று, அவனைத் தன் மக்களுக்குள் இல்லாதபடி அறுப்புண்டு போகச் செய்வேன். ");
INSERT INTO tam2017_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","அவன் தன் சந்ததியில் ஒரு பிள்ளையை மோளேகுக்குக் கொடுக்கும்போது, தேசத்தின் மக்கள் அவனைக் கொலைசெய்யாதபடிக்குக் கண்டுகொள்ளாமல் இருந்தால், ");
INSERT INTO tam2017_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","நான் அந்த மனிதனுக்கும் அவன் குடும்பத்திற்கும் விரோதமாக எதிர்த்து நின்று, அவனையும், அவன் பின்னே மோளேகை விபசாரமார்க்கமாகப் பின்பற்றின அனைவரையும், தங்கள் மக்களுக்குள் இல்லாதபடிக்கு அறுப்புண்டுபோகச் செய்வேன். ");
INSERT INTO tam2017_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ஜோதிடம் பார்க்கிறவர்களையும் குறிசொல்லுகிறவர்களையும் பின்பற்றி கெட்டுப்போக எந்த ஆத்துமா அவர்களை நாடுகிறானோ, அந்த ஆத்துமாவுக்கு விரோதமாக எதிர்த்துநின்று, அவனைத் தன் மக்களுக்குள் இல்லாதபடி அறுப்புண்டுபோகச் செய்வேன். ");
INSERT INTO tam2017_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","ஆதலால் நீங்கள் உங்களைப் பரிசுத்தப்படுத்திப் பரிசுத்தராக இருங்கள்; நான் உங்கள் தேவனாகிய யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","என் கட்டளைகளைக் கைக்கொண்டு நடவுங்கள்; நான் உங்களைப் பரிசுத்தமாக்குகிற யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“தன் தகப்பனையாவது தன் தாயையாவது சபிக்கிற எவனும் கொலைசெய்யப்படக்கடவன்; அவன் தன் தகப்பனையும் தாயையும் சபித்தான், அவனுடைய இரத்தப்பழி அவன்மேல் இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ஒருவன் பிறனுடைய மனைவியோடே விபசாரம் செய்தால், பிறன் மனைவியோடே விபசாரம் செய்த அந்த விபசாரனும் அந்த விபசாரியும் கொலைசெய்யப்படக்கடவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","தன் தகப்பனுடைய மனைவியோடே உறவுகொள்கிறவன் தன் தகப்பனை நிர்வாணமாக்கினபடியால், இருவரும் கொலைசெய்யப்படக்கடவர்கள்; அவர்களுடைய இரத்தப்பழி அவர்கள்மேல் இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","ஒருவன் தன் மருமகளோடே உறவுகொண்டால், இருவரும் கொலைசெய்யப்படக்கடவர்கள்; அருவருப்பான தாறுமாறு செய்தார்கள்; அவர்களுடைய இரத்தப்பழி அவர்கள்மேல் இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","ஒருவன் பெண்ணோடே உடலுறவு கொள்கிறதுபோல ஆணோடே உடலுறவுகொண்டால், அருவருப்பான காரியம் செய்த அந்த இருவரும் கொலைசெய்யப்படக்கடவர்கள்; அவர்களுடைய இரத்தப்பழி அவர்கள்மேல் இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","ஒருவன் ஒரு பெண்ணையும் அவள் தாயையும் திருமணம் செய்தால், அது முறைகேடு; இந்தவித முறைகேடு உங்களுக்குள் இல்லாதபடி, அவனையும் அவர்களையும் நெருப்பில் சுட்டெரிக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","ஒருவன் மிருகத்தோடே உடலுறவுகொண்டால், அவன் கொலைசெய்யப்படக்கடவன்; அந்த மிருகத்தையும் கொல்லக்கடவீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","ஒரு பெண் யாதொரு மிருகத்தோடே சேர்ந்து உடலுறவுகொண்டால், அந்த பெண்ணையும் அந்த மிருகத்தையும் கொல்லக்கடவாய்; இரு ஜீவனும் கொலைசெய்யப்படவேண்டும்; அவைகளின் இரத்தப்பழி அவைகளின்மேல் இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ஒருவன் தன் தகப்பனுக்காவது தன் தாய்க்காவது மகளாயிருக்கிற தன் சகோதரியைச் சேர்த்துக்கொண்டு, அவன் அவளுடைய நிர்வாணத்தையும், அவள் அவனுடைய நிர்வாணத்தையும் பார்த்தால், அது பாதகம்; அவர்கள் தங்கள் மக்களின் கண்களுக்கு முன்பாக அறுப்புண்டு போகக்கடவர்கள்; அவன் தன் சகோதரியை நிர்வாணப்படுத்தினான்; அவன் தன் அக்கிரமத்தைச் சுமப்பான். ");
INSERT INTO tam2017_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","ஒருவன் மாதவிடாய் உள்ள பெண்ணுடன் உடலுறவுகொண்டு, அவளை நிர்வாணமாக்கினால், அவன் அவளுடைய இரத்தப்போக்கைத் திறந்து, அவளும் தன் இரத்தப்போக்கை வெளிப்படுத்தினபடியால், இருவரும் தங்கள் மக்களுக்குள் இல்லாதபடி அறுப்புண்டுபோகவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","உன் தாயினுடைய சகோதரியையும் உன் தகப்பனுடைய சகோதரியையும் நிர்வாணமாக்காதே, அப்படிப்பட்டவன் தன் நெருங்கிய இனத்தை அவமானமாக்கினான்; அவர்கள் தங்கள் அக்கிரமத்தைச் சுமப்பார்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","ஒருவன் தன் தகப்பனின் சகோதரனுடைய மனைவியோடே சயனித்தால், அவன் தன் தகப்பனின் சகோதரனை நிர்வாணமாக்கினான்; அவர்கள் தங்கள் பாவத்தைச் சுமப்பார்கள், வாரிசு இல்லாமல் சாவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","ஒருவன் தன் சகோதரனுடைய மனைவியைத் திருமணம்செய்தால், அது அசுத்தம்; தன் சகோதரனை நிர்வாணமாக்கினான், அவர்கள் வாரிசு இல்லாமலிருப்பார்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ஆகையால் நீங்கள் குடியிருப்பதற்காக நான் உங்களைக் கொண்டுபோகிற தேசம் உங்களை வாந்திபண்ணாதபடி, நீங்கள் என் கட்டளைகள் யாவையும் என்னுடைய நியாயங்கள் யாவையும் கைக்கொண்டு நடங்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","நான் உங்களுக்கு முன்பாகத் துரத்திவிடுகிற மக்களுடைய பழக்கவழக்கங்களின்படி நடக்காதிருங்கள்; அவர்கள் இப்படிப்பட்ட காரியங்களையெல்லாம் செய்தபடியால் நான் அவர்களை வெறுத்தேன். ");
INSERT INTO tam2017_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","“நீங்கள் அவர்கள் தேசத்தைச் சொந்தமாக்கிக்கொள்வீர்கள் என்று உங்களுடன் சொன்னேன்; பாலும் தேனும் ஒடுகிற அந்த தேசத்தை உங்களுக்குச் சொந்தமாகக் கொடுப்பேன்; உங்களை மற்ற மக்களைவிட்டுப் பிரித்தெடுத்த உங்கள் தேவனாகிய யெகோவா நானே. ");
INSERT INTO tam2017_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","ஆகையால் சுத்தமான மிருகங்களுக்கும் அசுத்தமான மிருகங்களுக்கும், சுத்தமான பறவைகளுக்கும் அசுத்தமான பறவைகளுக்கும் நீங்கள் வித்தியாசம்செய்து, நான் உங்களுக்குத் தீட்டாக எண்ணச்சொல்லி விலக்கின மிருகங்களாலும் பறவைகளாலும் தரையிலே ஊருகிற யாதொரு பிராணிகளாலும் உங்களை அருவருப்பாக்காமல் இருப்பீர்களாக. ");
INSERT INTO tam2017_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","யெகோவாகிய நான் பரிசுத்தராக இருக்கிறபடியினாலே நீங்களும் எனக்கேற்ற பரிசுத்தவான்களாக இருப்பீர்களாக; நீங்கள் என்னுடையவர்களாக இருக்கும்படிக்கு, உங்களை மற்ற மக்களைவிட்டுப் பிரித்தெடுத்தேன். ");
INSERT INTO tam2017_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ஜோதிடம் பார்க்கிறவர்களும் குறிசொல்லுகிறவர்களுமாக இருக்கிற ஆணாகிலும் பெண்ணாகிலும் கொலைசெய்யப்படவேண்டும்; அவர்கள்மேல் கல்லெறிவார்களாக; அவர்களுடைய இரத்தப்பழி அவர்கள்மேல் இருப்பதாக என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","பின்பு யெகோவா மோசேயை நோக்கி: “ஆரோனின் மகன்களாகிய ஆசாரியர்களில் ஒருவனும் தன் மக்களில் இறந்துபோன ஒருவருக்காகத் தங்களைத் தீட்டுப்படுத்தக்கூடாதென்று அவர்களோடே சொல். ");
INSERT INTO tam2017_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","தன் தாயும், தன் தகப்பனும், தன் மகனும், தன் மகளும், தன் சகோதரனும், ");
INSERT INTO tam2017_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ஆணுக்கு வாழ்க்கைப்படாமல் தன்னிடத்திலிருக்கிற கன்னிப்பெண்ணான தன் சகோதரியுமாகிய தனக்கு நெருங்கிய உறவுமுறையான இவர்களுடைய சாவுக்காகத் தீட்டுப்படலாம். ");
INSERT INTO tam2017_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","தன் மக்களுக்குள்ளே பெரியவனாகிய அவன் வேறொருவருக்காகவும் தன்னைப் பரிசுத்தக்குலைச்சலாக்கித் தீட்டுப்படுத்தக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","அவர்கள் தங்கள் தலையை மொட்டையடிக்காமலும், தங்கள் தாடியின் ஓரங்களைச் சிரைத்துக்கொள்ளாமலும், தங்கள் உடலைக் கீறிக்கொள்ளாமலும் இருப்பார்களாக. ");
INSERT INTO tam2017_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","தங்கள் தேவனுடைய நாமத்தைப் பரிசுத்தக் குலைச்சலாக்காமல் அவருக்கேற்ற பரிசுத்தராக இருப்பார்களாக; அவர்கள் யெகோவாவின் தகனபலிகளையும் தங்கள் தேவனுடைய அப்பத்தையும் செலுத்துகிறவர்களாதலால் பரிசுத்தராக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","அவர்கள் தங்கள் தேவனுக்குப் பரிசுத்தமானவர்கள், ஆகையால் வேசியையாகிலும், கற்பை இழந்தவளையாகிலும் திருமணம் செய்யக்கூடாது; தன் கணவனாலே விவாகரத்து செய்யப்பட்ட பெண்ணையும் திருமணம் செய்யக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","அவன் தேவனுடைய அப்பத்தைச் செலுத்துகிறபடியால் நீ அவனைப் பரிசுத்தப்படுத்தவேண்டும்; உங்களைப் பரிசுத்தமாக்குகிற யெகோவாகிய நான் பரிசுத்தராக இருக்கிறபடியால், அவனும் உனக்கு முன்பாகப் பரிசுத்தனாக இருப்பானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","ஆசாரியனுடைய மகள், வேசித்தனம்செய்து, தன்னைப் பரிசுத்தக்குலைச்சலாக்கினால், அவள் தன் தகப்பனையும் பரிசுத்தக் குலைச்சலாக்குகிறாள்; அவள் நெருப்பிலே சுட்டெரிக்கப்படக்கடவள். ");
INSERT INTO tam2017_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“தன் சகோதரர்களுக்குள்ளே பிரதான ஆசாரியனாக தன் தலையில் அபிஷேகத்தைலம் ஊற்றப்பட்டவனும், அவனுக்குரிய உடைகளை அணியும்படி பிரதிஷ்டை செய்யப்பட்டவனுமாக இருக்கிறவன் எவனோ, அவன் தன் தலைப்பாகையை எடுக்காமலும், தன் உடைகளைக் கிழித்துக்கொள்ளாமலும், ");
INSERT INTO tam2017_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","சடலம் கிடக்கும் இடத்தில் போகாமலும், தன் தகப்பனுக்காகவும், தாய்க்காகவும் தன்னைத் தீட்டுப்படுத்திக்கொள்ளாமலும், ");
INSERT INTO tam2017_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","பரிசுத்த ஸ்தலத்திலிருந்து புறப்படாமலும் தன் தேவனுடைய பரிசுத்த ஸ்தலத்தைப் பரிசுத்தக் குலைச்சலாக்காமலும் இருப்பானாக; அவனுடைய தேவனின் அபிஷேக தைலம் என்னும் கிரீடம் அவன்மேல் இருக்கிறதே: நான் யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","கன்னியாக இருக்கிற பெண்ணை அவன் திருமணம்செய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","விதவையையானாலும் விவாகரத்து செய்யப்பட்டவளையானாலும் கற்புக்குலைந்தவளையானாலும் வேசியையானாலும் திருமணம்செய்யாமல், தன் மக்களுக்குள்ளே ஒரு கன்னிகையைத் திருமணம்செய்யக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","அவன் தன் வித்தைத் தன் மக்களுக்குள்ளே பரிசுத்தக் குலைச்சலாக்காமல் இருப்பானாக; நான் அவனைப் பரிசுத்தமாக்குகிற யெகோவா என்று சொல் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“நீ ஆரோனோடே சொல்லவேண்டியது என்னவென்றால்: உன் சந்ததியாருக்குள்ளே உடல் ஊனமுள்ளவன் தலைமுறைதோறும் தேவனுடைய அப்பத்தைச் செலுத்தும்படி சேரக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","ஊனமுள்ள ஒருவனும் அணுகக்கூடாது; குருடனானாலும், சப்பாணியானாலும், குறுகின அல்லது நீண்ட உறுப்புள்ளவனானாலும், ");
INSERT INTO tam2017_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","கால் ஒடிந்தவனானாலும், கை ஒடிந்தவனானாலும், ");
INSERT INTO tam2017_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","கூன் விழுந்தவனானாலும், குள்ளமானவனானாலும், கண் பார்வை இழந்தவனானாலும், சொறியனானாலும், அசடு உள்ளவனானாலும், விதை நசுங்கினவனானாலும் அணுகக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","ஆசாரியனாகிய ஆரோனின் சந்ததியாரில் உடல் ஊனமுள்ள ஒருவனும் யெகோவாவின் தகனபலிகளைச் செலுத்த வரக்கூடாது; அவன் உடல் ஊனமுள்ளவனாக இருப்பதால், அவன் தேவனுடைய அப்பத்தைச் செலுத்த வரக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","அவன் தன் தேவனுடைய அப்பமாகிய மகா பரிசுத்தமானவைகளிலும் மற்ற பரிசுத்தமானவைகளிலும் சாப்பிடலாம். ");
INSERT INTO tam2017_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","ஆனாலும் அவன் உடல் ஊனமுள்ளவன், ஆகையால், அவன் என் பரிசுத்த ஸ்தலங்களைப் பரிசுத்தக் குலைச்சலாக்காதபடிக்குத் திரைக்குள்ளே போகாமலும் பலிபீடத்தின் அருகில் சேராமலும் இருப்பானாக; நான் அவர்களைப் பரிசுத்தமாக்குகிற யெகோவா என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","மோசே இவைகளை ஆரோனோடும் அவன் மகன்களோடும் இஸ்ரவேல் மக்கள் அனைவரோடும் சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“இஸ்ரவேல் மக்கள் எனக்கென்று நியமித்துச் செலுத்துகிற பரிசுத்தப் பொருட்களைக்குறித்து ஆரோனும் அவனுடைய மகன்களும் என் பரிசுத்த நாமத்தைப் பரிசுத்தக் குலைச்சலாக்காதபடி எச்சரிக்கையாக இருக்கவேண்டும் என்று அவர்களுக்குச் சொல்; நான் யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","அன்றியும் நீ அவர்களை நோக்கி: உங்கள் தலைமுறைகளிலுள்ள சந்ததியாரில் யாராவது தான் தீட்டுப்பட்டிருக்கும்போது, இஸ்ரவேல் மக்கள் யெகோவாவுக்கு நியமித்துச் செலுத்துகிற பரிசுத்தமானவைகள் அருகில் சேர்ந்தால், அந்த ஆத்துமா என் சந்நிதியில் இல்லாதபடி அறுப்புண்டுபோவான் என்று சொல்; நான் யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","ஆரோனின் சந்ததியாரில் எவன் தொழுநோயாளியோ, எவன் விந்து கழிதல் உள்ளவனோ, அவன் சுத்தமாகும்வரை பரிசுத்தமானவைகளில் சாப்பிடக்கூடாது; பிணத்தினாலே தீட்டானவைகளில் எதையாகிலும் தொட்டவனும், விந்து கழிந்தவனும், ");
INSERT INTO tam2017_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","தீட்டுப்படுத்துகிற யாதொரு ஊரும் பிராணியையாகிலும் தீட்டுள்ள மனிதனையாகிலும் தொட்டவனும், ");
INSERT INTO tam2017_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","மாலைவரைத் தீட்டுப்பட்டிருப்பான்; அவன் தண்ணீரில் குளிக்கும்வரை பரிசுத்தமானவைகளில் சாப்பிடக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","சூரியன் மறைந்தபின்பு சுத்தமாக இருப்பான்; அதன்பின்பு அவன் பரிசுத்தமானவைகளில் சாப்பிடலாம்; அது அவனுடைய ஆகாரம். ");
INSERT INTO tam2017_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","தானாகச் செத்ததையும் பீறுண்டதையும் அவன் சாப்பிடுகிறதினாலே தன்னைத் தீட்டுப்படுத்தக்கூடாது; நான் யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","ஆகையால் பரிசுத்தமானதை அவர்கள் பரிசுத்தக்குலைச்சலாக்குகிறதினாலே, பாவம் சுமந்து அதன் காரணமாக மரணமடையாமலிருக்க, என் கட்டளையைக் காக்கக்கடவர்கள்; நான் அவர்களைப் பரிசுத்தமாக்குகிற யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“அந்நியன் ஒருவனும் பரிசுத்தமானவைகளில் சாப்பிடக்கூடாது; ஆசாரியன் வீட்டில் தங்கியிருக்கிறவனும் கூலிவேலை செய்கிறவனும் பரிசுத்தமானதில் சாப்பிடக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","ஆசாரியனால் பணத்திற்கு வாங்கப்பட்டவனும், அவன் வீட்டிலே பிறந்தவனும் அவனுடைய ஆகாரத்தில் சாப்பிடலாம். ");
INSERT INTO tam2017_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","ஆசாரியனுடைய மகள் அந்நியனுக்கு வாழ்க்கைப்பட்டால், அவள் பரிசுத்தமானவைகளின் படைப்பிலே சாப்பிடக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","விதவையான, அல்லது விவாகரத்து செய்யப்பட்டவளான ஆசாரியனுடைய மகள் பிள்ளை இல்லாதிருந்து, தன் தகப்பனுடைய வீட்டில் தன்னுடைய இளவயதில் இருந்ததுபோல திரும்பவந்து இருந்தாளென்றால், அவள் தன் தகப்பனுடைய ஆகாரத்தில் சாப்பிடலாம்; அந்நியனாகிய ஒருவனும் அதில் சாப்பிடக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ஒருவன் அறியாமல் பரிசுத்தமானதில் சாப்பிட்டிருந்தால், அவன் அதிலே ஐந்தில் ஒரு பங்கு அதிகமாக சேர்த்து பரிசுத்தமானவைகளுடன் ஆசாரியனுக்குக் கொடுக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","அவர்கள் யெகோவாவுக்குப் படைக்கிற இஸ்ரவேல் மக்களுடைய பரிசுத்தமானவைகளைப் பரிசுத்தக்குலைச்சலாக்காமலும், ");
INSERT INTO tam2017_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","அவைகளைச் சாப்பிடுகிறதினால் அவர்கள்மேல் குற்றமான அக்கிரமத்தைச் சுமரச்செய்யாமலும் இருப்பார்களாக; நான் அவர்களைப் பரிசுத்தமாக்குகிற யெகோவா என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“நீ ஆரோனோடும் அவனுடைய மகன்களோடும் இஸ்ரவேல் மக்கள் அனைவரோடும் சொல்லவேண்டியது என்னவென்றால்: இஸ்ரவேல் குடும்பத்தாரிலும் இஸ்ரவேலில் தங்குகிற அந்நியர்களிலும் தங்களுடைய பொருத்தனைகளின்படியாகிலும் உற்சாகத்தின்படியாகிலும் சர்வாங்க தகனபலிகளாகக் யெகோவாவுக்குத் தங்கள் காணிக்கையை எவர்கள் செலுத்தப்போகிறார்களோ, ");
INSERT INTO tam2017_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","அவர்கள் தங்கள் மனதின்படியே மாடுகளிலாகிலும் ஆடுகளிலாகிலும் வெள்ளாடுகளிலாகிலும் பழுதற்ற ஒரு ஆணைப் பிடித்துவந்து செலுத்துவார்களாக. ");
INSERT INTO tam2017_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","ஊனமுள்ள ஒன்றையும் செலுத்தவேண்டாம்; அது உங்கள்நிமித்தம் அங்கீகரிக்கப்படுவதில்லை. ");
INSERT INTO tam2017_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","ஒருவன் விசேஷித்த பொருத்தனையாயாவது, உற்சாகமாயாவது, யெகோவாவுக்கு மாடுகளிலாகிலும் ஆடுகளிலாகிலும் சமாதானபலிகளைச் செலுத்தப்போனால், அது அங்கீகரிக்கப்படும்படி, ஒரு ஊனமில்லாமல் உத்தமமாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","குருடு, எலும்பு முறிந்தவை, முடம், கட்டிகள் உள்ளவை, சொறி, புண் முதலிய குறைபாடு உள்ளவைகளை நீங்கள் யெகோவாவுக்குச் செலுத்தாமலும், அவைகளாலே யெகோவாவுக்குப் பலிபீடத்தின்மேல் தகனபலியிடாமலும் இருப்பீர்களாக. ");
INSERT INTO tam2017_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","நீண்ட அல்லது குறுகின உறுப்புள்ள மாட்டையும் ஆட்டையும் நீ உற்சாகபலியாக செலுத்தலாம்; பொருத்தனைக்காக அது அங்கீகரிக்கப்படமாட்டாது. ");
INSERT INTO tam2017_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","விதை நசுங்கினதையும், நொறுங்கினதையும், காயப்பட்டதையும், விதை அறுக்கப்பட்டதையும் நீங்கள் யெகோவாவுக்குச் செலுத்தாமலும், அவைகளை உங்கள் தேசத்தில் பலியிடாமலும் இருப்பீர்களாக. ");
INSERT INTO tam2017_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","அந்நியர்களின் கையிலும் இப்படிப்பட்டதை வாங்கி, தேவனுக்கு அப்பமாகச் செலுத்தவேண்டாம்; அவைகளின் குறைபாடும், ஊனமும் அவைகளில் இருக்கிறது; அவைகள் உங்களுக்காக அங்கீகரிக்கப்படுவதில்லை என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“ஒரு கன்றாவது செம்மறியாட்டுக்குட்டியாவது, வெள்ளாட்டுக்குட்டியாவது பிறந்தால், அது ஏழுநாட்கள் தன் தாயினிடத்தில் இருப்பதாக; எட்டாம் நாள் முதல் அது யெகோவாவுக்குத் தகனபலியாக அங்கீகரிக்கப்படும். ");
INSERT INTO tam2017_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","பசுவையும் அதின் கன்றையும், ஆட்டையும் அதின் குட்டியையும் ஒரே நாளில் கொல்லவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","யெகோவாவுக்கு நன்றிபலியைச் செலுத்துவீர்களானால் மனப்பூர்வமாக அதைச் செலுத்துவீர்களாக. ");
INSERT INTO tam2017_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","அந்நாளிலேயே அதைச் சாப்பிட்டுவிடவேண்டும்; விடியற்காலம்வரை நீங்கள் அதில் ஒன்றையும் மீதியாக வைக்கவேண்டாம்; நான் யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“நீங்கள் என் கட்டளைகளைக் கைக்கொண்டு, அவைகளின்படி செய்யக்கடவீர்கள்; நான் யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","என் பரிசுத்த நாமத்தைப் பரிசுத்தக்குலைச்சலாக்காமல் இருப்பீர்களாக; நான் இஸ்ரவேல் மக்கள் நடுவே பரிசுத்தர் என்று மதிக்கப்படுவேன்; நான் உங்களைப் பரிசுத்தமாக்குகிற யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","நான் உங்களுக்கு தேவனாக இருப்பதற்காக, உங்களை எகிப்துதேசத்திலிருந்து புறப்படச்செய்தேன்; நான் யெகோவா என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“நீ இஸ்ரவேல் மக்களிடம் சொல்லவேண்டியது என்னவென்றால்: சபைகூடி வந்து பரிசுத்த நாட்களாக அனுசரிக்கும்படி, நீங்கள் கூறவேண்டிய யெகோவாவுடைய பண்டிகை நாட்களாவன: ");
INSERT INTO tam2017_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ஆறுநாட்களும் வேலைசெய்யவேண்டும்; ஏழாம்நாள் பரிசுத்த சபைகூடுதலான ஓய்வுநாள், அதில் ஒரு வேலையும் செய்யவேண்டாம்; அது உங்கள் குடியிருப்புகளிலெல்லாம் யெகோவாவுக்கென்று ஓய்ந்திருக்கும் நாளாக இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“சபைகூடிவந்து பரிசுத்தமாக அனுசரிக்கும்படி, நீங்கள் குறித்தகாலத்தில் அறிவிக்கவேண்டிய யெகோவாவின் பண்டிகைகளாவன: ");
INSERT INTO tam2017_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","முதலாம் மாதம் பதினான்காம் தேதி மாலைநேரமாகிய வேளையிலே யெகோவாவின் பஸ்கா பண்டிகையும், ");
INSERT INTO tam2017_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","அந்த மாதம் பதினைந்தாம் தேதியிலே, யெகோவாவுக்குப் புளிப்பில்லாத அப்பப்பண்டிகையுமாக இருக்கும்; ஏழுநாட்கள் புளிப்பில்லாத அப்பங்களைச் சாப்பிடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","முதலாம் நாள் உங்களுக்குப் பரிசுத்தமான சபைகூடுதல்; அதிலே சாதாரணமான யாதொரு வேலையும் செய்யவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","ஏழுநாட்களும் யெகோவாவுக்குத் தகனபலியிடவேண்டும்; ஏழாம்நாள் பரிசுத்தமான சபைகூடுதல்; அதில் சாதாரணமான யாதொரு வேலையும் செய்யக்கூடாது என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“நீ இஸ்ரவேல் மக்களிடம் சொல்லவேண்டியது என்னவென்றால்: நான் உங்களுக்குக் கொடுக்கும் தேசத்தில் நீங்கள் போய்ச் சேர்ந்து, அதின் விளைச்சலை அறுக்கும்போது, உங்கள் அறுப்பின் முதற்பலனாகிய ஒரு கதிர்க்கட்டை ஆசாரியனிடத்தில் கொண்டுவரக்கடவீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","உங்களுக்காக அது அங்கீகரிக்கப்படும்படி, ஆசாரியன் அந்தக் கதிர்க்கட்டை ஓய்வுநாளுக்கு மறுநாளில் யெகோவாடைய சந்நிதியில் அசைவாட்டவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","நீங்கள் அந்தக் கதிர்க்கட்டை அசைவாட்டும் நாளில் யெகோவாவுக்குச் சர்வாங்க தகனபலியாக ஒருவயதுடைய பழுதற்ற ஒரு ஆட்டுக்குட்டியையும், ");
INSERT INTO tam2017_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","யெகோவாவுக்கு நறுமண வாசனையான தகனபலியாக ஒரு மரக்காலிலே பத்தில் இரண்டு பங்கானதும் எண்ணெயிலே பிசைந்ததுமான மெல்லிய மாவாகிய உணவுபலியையும், திராட்சைப்பழ ரசத்திலே காற்படியாகிய பானபலியையும் செலுத்தக்கடவீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","உங்கள் தேவனுக்குக் காணிக்கையை நீங்கள் கொண்டுவரும் அந்தநாள்வரை, அப்பமும் வாட்டிய கதிரையும் பச்சைக்கதிரையும் சாப்பிடவேண்டாம்; இது உங்களுடைய குடியிருப்புகளிலெல்லாம் உங்கள் தலைமுறைதோறும் கைக்கொள்ளவேண்டிய நிரந்தரமான கட்டளை. ");
INSERT INTO tam2017_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“நீங்கள் அசைவாட்டும் கதிர்க்கட்டைக் கொண்டுவரும் ஓய்வுநாளுக்கு மறுநாள் முதற்கொண்டு எண்ணத்துவங்கி, ஏழுவாரங்கள் முடிந்தபின்பு, ");
INSERT INTO tam2017_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ஏழாம் ஓய்வுநாளுக்கு மறுநாளாகிய ஐம்பதாம் நாள்வரை கணக்கிட்டு, யெகோவாவுக்குப் புதிய உணவுபலியைச் செலுத்தக்கடவீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","நீங்கள் ஒரு மரக்காலிலே பத்தில் இரண்டு பங்காகிய மெல்லிய மாவிலே புளிப்பாக வேகவைக்கப்பட்ட அசைவாட்டும் காணிக்கையாக இருக்கிற இரண்டு அப்பங்களை உங்கள் வீடுகளிலிருந்து யேகோவாக்கென்று முதற்பலனாகக் கொண்டுவந்து, ");
INSERT INTO tam2017_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","அப்பத்தோடேகூடக் யெகோவாவுக்குச் சர்வாங்கதகனபலியாக, ஒருவயதுடைய பழுதற்ற ஏழு ஆட்டுக்குட்டிகளையும், ஒரு காளையையும், இரண்டு ஆட்டுக்கடாக்களையும், யெகோவாவுக்கு நறுமண வாசனையான தகனபலியாக அவைகளுக்குரிய உணவுபலியையும், பானபலியையும் செலுத்தி, ");
INSERT INTO tam2017_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","வெள்ளாடுகளில் ஒரு கடாவைப் பாவநிவாரணபலியாகவும், ஒருவயதுடைய இரண்டு ஆட்டுக்குட்டிகளைச் சமாதானபலியாகவும் செலுத்தக்கடவீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","அவைகளை ஆசாரியன் முதற்பலனாகிய அப்பத்தோடும் இரண்டு ஆட்டுக்குட்டிகளோடுங்கூட யெகோவாவுடைய சந்நிதியில் அசைவாட்டும் பலியாக அசைவாட்டக்கடவன்; யெகோவாவுக்குப் பரிசுத்தமாகிய அவைகள் ஆசாரியனுடையவைகளாகும். ");
INSERT INTO tam2017_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","அந்த நாள் உங்களுக்குச் சபைகூடும் பரிசுத்த நாள் என்று கூறவேண்டும்; அதிலே சாதாரணமான யாதொரு வேலையும் செய்யக்கூடாது; இது உங்கள் வீடுகளிலெல்லாம் உங்கள் தலைமுறைதோறும் கைக்கொள்ளவேண்டிய நிரந்தரமான கட்டளை. ");
INSERT INTO tam2017_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“உங்கள் தேசத்தின் விளைச்சலை நீங்கள் அறுக்கும்போது, வயலின் ஓரத்தில் இருக்கிறதை முற்றிலும் அறுக்காமலும், சிந்திக்கிடக்கிற கதிர்களைப் பொறுக்காமலும், எளியவனுக்கும் அந்நியனுக்கும் அவைகளை விட்டுவிடவேண்டும்; நான் உங்கள் தேவனாகிய யெகோவா என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“நீ இஸ்ரவேல் மக்களிடம் சொல்லவேண்டியது என்னவென்றால்: உங்களுக்கு ஏழாம் மாதம் முதலாம்தேதி எக்காளச்சத்தத்தால் நினைவுகூறுதலாகக் கொண்டாடுகிற பண்டிகை என்கிற சபை கூடும் பரிசுத்த ஓய்வுநாளாக இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","அதிலே சாதாரணமான யாதொரு வேலையும் செய்யாமல், யெகோவாவுக்குத் தகனபலி செலுத்தவேண்டும் என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“அந்த ஏழாம் மாதம் பத்தாந்தேதி உங்களுக்குப் பாவநிவிர்த்தி செய்யும் நாளும் சபைகூடும் பரிசுத்தநாளுமாக இருப்பதாக; அப்பொழுது நீங்கள் உங்கள் ஆத்துமாக்களைத் தாழ்மைப்படுத்தி, யெகோவாவுக்குத் தகனபலி செலுத்தக்கடவீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","அந்த நாள் உங்கள் தேவனாகிய யெகோவாவுடைய சந்நிதியில் உங்களுக்காகப் பாவநிவிர்த்தி செய்யப்படும் பாவநிவாரண நாளாக இருக்கிறபடியால், அதிலே யாதொரு வேலையும் செய்யவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","அந்நாளிலே தன்னைத் தாழ்மைப்படுத்தாத எந்த ஆத்துமாவும் தன் மக்களுக்குள் இல்லாதபடிக்கு அறுப்புண்டுபோவான். ");
INSERT INTO tam2017_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","அந்நாளிலே ஒரு ஆத்துமா யாதொரு வேலையைச் செய்தால், அந்த ஆத்துமாவை அவன் மக்களின் நடுவிலே வைக்காமல் அழிப்பேன். ");
INSERT INTO tam2017_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","அதில் நீங்கள் எந்த வேலையும் செய்யாதிருப்பது உங்கள் வீடுகளிலெல்லாம் உங்கள் தலைமுறைதோறும் கைக்கொள்ளவேண்டிய நிரந்தரமான கட்டளை. ");
INSERT INTO tam2017_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","அது உங்களுக்கு விசேஷித்த ஓய்வுநாள்; அதில் உங்கள் ஆத்துமாக்களைத் தாழ்மைப்படுத்தவேண்டும்; அந்த மாதத்தின் ஒன்பதாம்தேதி மாலை துவக்கி, மறுநாள் மாலைவரை உங்கள் ஓய்வை அனுசரிப்பீர்களாக” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“நீ இஸ்ரவேல் மக்களிடம் சொல்லவேண்டியது என்னவென்றால்: அந்த ஏழாம் மாதம் பதினைந்தாம்தேதிமுதல் ஏழுநாட்களும் யெகோவாவுக்கு அனுசரிக்கும் கூடாரப்பண்டிகையாக இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","முதலாம் நாள் சபைகூடும் பரிசுத்தநாள்; அதிலே சாதாரணமான யாதொரு வேலையும் செய்யக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ஏழுநாட்களும் யெகோவாவுக்குத் தகனபலி செலுத்தக்கடவீர்கள்; எட்டாம் நாள் உங்களுக்குச் சபைகூடும் பரிசுத்தநாள்; அதிலே யெகோவாவுக்குத் தகனபலி செலுத்தக்கடவீர்கள்; அது அனுசரிக்கப்படும் நாள்; அதிலே சாதாரணமான யாதொரு வேலையும் செய்யவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“நீங்கள் யெகோவாவுடைய ஓய்வுநாட்களில் செலுத்துவதும் தவிர, நீங்கள் யெகோவாவுக்குப் படைக்கிற உங்கள் எல்லாக் காணிக்கைகளும் பொருத்தனைகளும் உற்சாகபலிகளும் தவிர, ");
INSERT INTO tam2017_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","நீங்கள் அந்தந்த நாளுக்குத்தக்கதாகக் யெகோவாவுக்குச் சர்வாங்க தகனபலி, உணவுபலி, இரத்தபலி, பானபலி முதலானவைகளைச் செலுத்தும்படி சபைகூடிவந்து, பரிசுத்தமாக அனுசரிப்பதற்காக நீங்கள் அறிவிக்கவேண்டிய யெகோவாவுடைய பண்டிகைகள் இவைகளே. ");
INSERT INTO tam2017_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“நிலத்தின் பலனை நீங்கள் சேர்த்து வைக்கும் ஏழாம் மாதம் பதினைந்தாம்தேதிமுதல் யெகோவாவுக்குப் பண்டிகையை ஏழுநாட்கள் அனுசரிப்பீர்களாக; முதலாம் நாளிலும் ஓய்வு; எட்டாம் நாளிலும் ஓய்வு. ");
INSERT INTO tam2017_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","முதல் நாளிலே அலங்காரமான மரங்களின் பழங்களையும் பேரீச்சை மரங்களின் ஓலைகளையும் தழைத்திருக்கிற மரங்களின் கிளைகளையும் ஆற்றலரிகளையும் கொண்டுவந்து, உங்கள் தேவனாகிய யெகோவாவுடைய சந்நிதியில் ஏழுநாட்களும் மகிழ்ச்சியாக இருங்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","வருடந்தோறும் ஏழுநாட்கள் யெகோவாவுக்கு இந்தப் பண்டிகையை அனுசரிப்பீர்களாக; இது உங்கள் தலைமுறைதோறும் கைக்கொள்ளவேண்டிய நிரந்தரமான கட்டளை; ஏழாம் மாதத்தில் அதை அனுசரிக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","நான் இஸ்ரவேல் மக்களை எகிப்து தேசத்திலிருந்து புறப்படச்செய்தபோது, அவர்களைக் கூடாரங்களில் குடியிருக்கச்செய்ததை உங்கள் சந்ததியார் அறியும்படிக்கு, ");
INSERT INTO tam2017_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ஏழுநாட்கள் கூடாரங்களில் குடியிருக்கவேண்டும்; இஸ்ரவேலில் பிறந்தவர்கள் எல்லோரும் கூடாரங்களில் குடியிருக்கவேண்டும்; நான் உங்கள் தேவனாகிய யெகோவா என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","அப்படியே மோசே யெகோவாவுடைய பண்டிகைகளை இஸ்ரவேல் மக்களுக்குத் தெரிவித்தான். ");
INSERT INTO tam2017_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“குத்துவிளக்கு எப்பொழுதும் எரிந்துகொண்டிருக்கும்படி அதற்காக இடித்துப்பிழிந்த தெளிவான ஒலிவ எண்ணெயை இஸ்ரவேல் மக்கள் உன்னிடத்தில் கொண்டுவரும்படி அவர்களுக்குக் கட்டளையிடு. ");
INSERT INTO tam2017_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","ஆசரிப்புக்கூடாரத்தில் மகா பரிசுத்த ஸ்தலத்தின் திரைக்கு வெளிப்புறமாக ஆரோன் அதை எப்பொழுதும் மாலைதொடங்கி விடியற்காலம்வரை யெகோவாவுடைய சந்நிதியில் எரியும்படி ஏற்றுவானாக; இது உங்கள் தலைமுறைதோறும் கைக்கொள்ளவேண்டிய நிரந்தரமான கட்டளை. ");
INSERT INTO tam2017_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","அவன் எப்பொழுதும் யெகோவாவுடைய சந்நிதியில் பரிசுத்தமான குத்துவிளக்கின்மேல் இருக்கிற விளக்குகளை எரியவைக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“அன்றியும் நீ மெல்லிய மாவை எடுத்து, அதைப் பன்னிரண்டு அப்பங்களாகச் சுடுவாயாக; ஒவ்வொரு அப்பமும் மரக்காலிலே பத்தில் இரண்டுபங்கு மாவினால் செய்யப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","அவைகளை நீ யெகோவாவுடைய சந்நிதியில் பரிசுத்தமான மேஜையின்மேல் இரண்டு அடுக்காக, ஒவ்வொரு அடுக்கிலும் ஆறு ஆறு அப்பங்கள் இருக்கும்படியாக வைத்து, ");
INSERT INTO tam2017_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","ஒவ்வொரு அடுக்கிலும் சுத்தமான தூபவர்க்கம் போடக்கடவாய்; அது அப்பத்துடன் இருந்து, நன்றியின் அடையாளமாகக் யெகோவாவுக்கேற்ற தகனபலியாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","அப்பத்தை நிரந்தரமான உடன்படிக்கையாக இஸ்ரவேல் மக்கள் கையிலே வாங்கி, ஓய்வுநாள் தோறும் யெகோவாவுடைய சந்நிதியில் அடுக்கிவைப்பானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","அது ஆரோனையும் அவனுடைய மகன்களையும் சேரும்; அதைப் பரிசுத்த இடத்திலே சாப்பிடுவார்களாக; நிரந்தரமான கட்டளையாக யெகோவாவுக்குச் செலுத்தப்படும் தகனபலிகளில் அது அவனுக்கு மகா பரிசுத்தமாக இருக்கும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","அக்காலத்திலே இஸ்ரவேலைச் சார்ந்த பெண்ணுக்கும் எகிப்திய ஆணுக்கும் பிறந்த மகனாகிய ஒருவன் இஸ்ரவேல் மக்களோடு புறப்பட்டு வந்திருந்தான்; இவனும் இஸ்ரவேலனாகிய ஒரு மனிதனும் முகாமிலே சண்டையிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","அப்பொழுது இஸ்ரவேலைச் சார்ந்த அந்தப் பெண்ணின் மகன் யெகோவாவின் நாமத்தை நிந்தித்துத் தூஷித்தான். அவனை மோசேயினிடத்தில் கொண்டுவந்தார்கள். அவனுடைய தாயின் பெயர் செலோமித்; அவள் தாண் கோத்திரத்தானாகிய திப்ரியின் மகள். ");
INSERT INTO tam2017_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","யெகோவாவின் வாக்கினாலே தங்களுக்கு உத்திரவு வரும்வரை, அவனைக் காவலில்வைத்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","அப்பொழுது யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“தூஷித்தவனை முகாமிற்கு வெளியே கொண்டுபோ; கேட்டவர்கள் எல்லோரும் தங்கள் கைகளை அவனுடைய தலையின்மேல் வைப்பார்களாக; பின்பு சபையார் எல்லோரும் அவனைக் கல்லெறிவார்களாக. ");
INSERT INTO tam2017_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","மேலும் நீ இஸ்ரவேல் மக்களை நோக்கி: எவனாகிலும் தன் தேவனைத் தூஷித்தால், அவன் தன் பாவத்தைச் சுமப்பான். ");
INSERT INTO tam2017_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","யெகோவாவுடைய நாமத்தை நிந்திக்கிறவன் கொலைசெய்யப்படவேண்டும்; சபையார் எல்லோரும் அவனைக் கல்லெறியவேண்டும்; அந்நியனானாலும் இஸ்ரவேலனானாலும் யெகோவாவின் நாமத்தைத் தூஷிக்கிறவன் கொலைசெய்யப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ஒரு மனிதனைக் கொல்லுகிறவன் எவனோ அவன் கொலைசெய்யப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","மிருகத்தைக் கொன்றவன் மிருகத்திற்கு மிருகம் கொடுக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“ஒருவன் மற்றவனை ஊனப்படுத்தினால், அவன் செய்தபடியே அவனுக்கும் செய்யப்படக்கடவது. ");
INSERT INTO tam2017_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","நொறுக்குதலுக்கு நொறுக்குதல், கண்ணுக்குக் கண், பல்லுக்குப் பல்; அவன் ஒரு மனிதனை ஊனப்படுத்தினதுபோல அவனும் ஊனப்படுத்தப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","மிருகத்தைக் கொன்றவன் அதற்கு பதிலாக வேறு மிருகம் கொடுக்கவேண்டும்; மனிதனைக் கொன்றவனோ கொலைசெய்யப்படக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","உங்களில் அந்நியனுக்கும் இஸ்ரவேலர்களுக்கும் ஒரே நியாயம் இருக்கவேண்டும்; நான் உங்கள் தேவனாகிய யெகோவா என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","அப்படியே, நிந்தித்தவனை முகாமிற்கு வெளியே கொண்டுபோய், அவனைக் கல்லெறியும்படி மோசே இஸ்ரவேல் மக்களிடம் சொன்னான்; யெகோவா மோசேக்குக் கட்டளையிட்டபடியே செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","யெகோவா சீனாய்மலையில் மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“நீ இஸ்ரவேல் மக்களிடம் சொல்லவேண்டியது என்னவென்றால்: நான் உங்களுக்குக் கொடுக்கும் தேசத்திலே நீங்கள் போய்ச் சேர்ந்தபின்பு, தேசம் யெகோவாவுக்கென்று ஓய்வு கொண்டாடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ஆறுவருடங்கள் உன் வயலை விதைத்து, உன் திராட்சைத்தோட்டத்தைக் கிளைநறுக்கி, அதின் பலனைச் சேர்ப்பாயாக. ");
INSERT INTO tam2017_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ஏழாம் வருடத்திலோ, தேசத்திற்கு யெகோவாவுக்கென்று ஓய்ந்திருக்கும் ஓய்வாக இருக்கவேண்டும்; அதில் உன் வயலை விதைக்காமலும், உன் திராட்சைத்தோட்டத்தைக் கிளைநறுக்காமலும், ");
INSERT INTO tam2017_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","தானாக விளைந்து பயிரானதை அறுக்காமலும், கிளைநறுக்காமல்விட்ட திராட்சைச்செடியின் பழங்களைச் சேர்க்காமலும் இருப்பாயாக; தேசத்திற்கு அது ஓய்வு வருடமாக இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","தேசத்தின் ஓய்விலே விளைகிறது உங்களுக்கு ஆகாரமாக இருப்பதாக; உன்னுடைய வேலைக்காரனுக்கும், வேலைக்காரிக்கும், கூலிக்காரனுக்கும், உன்னிடத்தில் தங்குகிற அந்நியனுக்கும், ");
INSERT INTO tam2017_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","உன் நாட்டு மிருகத்திற்கும், உன் தேசத்தில் இருக்கிற காட்டு மிருகத்திற்கும் அதில் விளைந்திருப்பதெல்லாம் ஆகாரமாக இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“மேலும், ஏழு ஓய்வு வருடங்களுள்ள ஏழு ஏழு வருடங்களைக் கணக்கிடுவாயாக; அந்த ஏழு ஓய்வு வருடங்களும் நாற்பத்தொன்பது வருடங்களாகும். ");
INSERT INTO tam2017_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","அப்பொழுதும் ஏழாம் மாதம் பத்தாந்தேதியில் எக்காளச்சத்தம் தொனிக்கச்செய்யவேண்டும்; பாவநிவாரணநாளில் உங்கள் தேசமெங்கும் எக்காளச்சத்தம் தொனிக்கச்செய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","“50 வது வருடத்தைப் பரிசுத்தமாக்கி, தேசமெங்கும் அதின் குடிமக்களுக்கெல்லாம் விடுதலை கூறக்கடவீர்கள்; அது உங்களுக்கு யூபிலி வருடம்; அதிலே உங்களில் ஒவ்வொருவனும் தன்தன் சொந்த இடத்திற்கும், குடும்பத்திற்கும் திரும்பிப் போகக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","அந்த ஐம்பதாம் வருடம் உங்களுக்கு யூபிலி வருடமாக இருப்பதாக; அதிலே விதைக்காமலும், தானாக விளைந்து பயிரானதை அறுக்காமலும், கிளைநறுக்காமல் விடப்பட்ட திராட்சைச்செடியின் பழங்களைச் சேர்க்காமலும் இருப்பீர்களாக. ");
INSERT INTO tam2017_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","அது யூபிலி வருடம்; அது உங்களுக்குப் பரிசுத்தமாக இருக்கவேண்டும்; அந்த வருடத்தில் வயல்வெளியில் விளைந்தவைகளை நீங்கள் சாப்பிடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“அந்த யூபிலி வருடத்தில் உங்களில் அவனவன் தன்தன் சொந்த இடத்திற்குத் திரும்பிப்போகக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","ஆகையால், பிறனுக்கு எதையாவது விற்றாலும், அவனிடத்தில் எதையாவது விலைகொடுத்து வாங்கினாலும் ஒருவருக்கொருவர் அநியாயம் செய்யக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","யூபிலி வருடத்திற்குப் பின்வரும் வருடங்களின் எண்ணிக்கைக்கேற்ப பிறனிடத்தில் வாங்குவாயாக; பலனுள்ள வருடங்களின் தொகைக்கேற்ப அவன் உனக்கு விற்பானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","பலனுள்ள வருடங்களின் இலக்கத்தைப் பார்த்து அவன் உனக்கு விற்கிறதினால், வருடங்களின் எண்ணிக்கை அதிகமானால் விலையேறவும், வருடங்களின் எண்ணிக்கை குறைந்தால், விலை குறையவும் வேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","உங்களில் ஒருவனும் மற்றவனுக்கு அநியாயம் செய்யக்கூடாது; உன் தேவனுக்குப் பயப்படவேண்டும்; நான் உங்கள் தேவனாகிய யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“என் கட்டளைகளின்படி செய்து, என் நியாயங்களைக் கைக்கொண்டு அவைகளின்படி நடக்கக்கடவீர்கள்; அப்பொழுது தேசத்திலே சுகமாகக் குடியிருப்பீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","பூமி தன் பலனைத் தரும்; நீங்கள் திருப்தியாகச் சாப்பிட்டு, அதில் சுகமாகக் குடியிருப்பீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","ஏழாம் வருடத்தில் எதைச் சாப்பிடுவோம்? நாங்கள் விதைக்காமலும், விளைந்ததைச் சேர்க்காமலும் இருக்கவேண்டுமே! என்று சொல்வீர்களானால், ");
INSERT INTO tam2017_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","நான் ஆறாம் வருடத்தில் உங்களுக்கு ஆசீர்வாதத்தைக் கைகூடிவரச்செய்வேன்; அது உங்களுக்கு மூன்று வருடங்களின் பலனைத் தரும். ");
INSERT INTO tam2017_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","நீங்கள் எட்டாம் வருடத்திலே விதைத்து, ஒன்பதாம் வருடம்வரை பழைய பலனிலே சாப்பிடுவீர்கள்; அதின் பலன் விளையும்வரை பழைய பலனைச் சாப்பிடுவீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“தேசம் என்னுடையதாக இருக்கிறதினால், நீங்கள் நிலங்களை நிரந்தரமாக விற்கவேண்டாம்; நீங்கள் அந்நியர்களும் என்னிடத்தில் தற்காலக்குடிகளுமாக இருக்கிறீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","உங்கள் சொந்தமான தேசமெங்கும் நிலங்களை மீட்டுக்கொள்ள இடங்கொடுக்கக்கடவீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“உங்கள் சகோதரன் ஏழ்மையடைந்து, தன் சொந்த இடத்திலே சிலதை விற்றால், அவன் உறவினன் ஒருவன் வந்து, தன் சகோதரன் விற்றதை மீட்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","அதை மீட்க ஒருவனும் இல்லாமல், தானே அதை மீட்கத்தக்கவனானால், ");
INSERT INTO tam2017_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","அதை விற்றபின் சென்ற வருடங்களின் தொகையைக் கழித்துவிட்டு, மீதமுள்ள தொகையை உயர்த்தி, வாங்கினவனுக்குக் கொடுத்து, அவன் தன் சொந்த இடத்திற்கு திரும்பிப்போகக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","அப்படிக் கொடுப்பதற்கான நிர்வாகம் அவனுக்கு இல்லாவிட்டால், அவன் விற்றது வாங்கினவன் கையிலே யூபிலி வருடம்வரை இருந்து, யூபிலி வருடத்திலே அது விடுதலையாகும்; அப்பொழுது அவன் தன் சொந்த இடத்திற்குத் திரும்பப்போவான். ");
INSERT INTO tam2017_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ஒருவன் மதில்சூழ்ந்த பட்டணத்திலுள்ள தன் குடியிருக்கும் வீட்டை விற்றால், அதை விற்ற ஒரு வருடத்திற்குள் அதை மீட்டுக்கொள்ளலாம்; ஒரு வருடத்திற்குள்ளாகவே அதை மீட்டுக்கொள்ளவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","ஒரு வருடத்திற்குள்ளே அதை மீட்டுக்கொள்ளாதிருந்தால், மதில்சூழ்ந்த பட்டணத்திலுள்ள அந்த வீடு தலைமுறைதோறும் அதை வாங்கினவனுக்கே உரியதாகும்; யூபிலி வருடத்திலும் அது விடுதலையாகாது. ");
INSERT INTO tam2017_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","மதில்சூழப்படாத கிராமங்களிலுள்ள வீடுகளோ, தேசத்தின் நிலங்கள்போலவே எண்ணப்படும்; அவைகள் மீட்கப்படலாம்; யூபிலி வருடத்தில் அவைகள் விடுதலையாகும். ");
INSERT INTO tam2017_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","லேவியர்களின் சொந்த இடமாகிய பட்டணங்களிலுள்ள வீடுகளையோ லேவியர்கள் எக்காலத்திலும் மீட்டுக்கொள்ளலாம். ");
INSERT INTO tam2017_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","இஸ்ரவேல் மக்களுக்குள்ளே லேவியர்களுடைய பட்டணங்களிலுள்ள வீடுகள் அவர்களுக்குரிய சொந்தமாக இருப்பதால், லேவியர்களிடத்தில் அவனுடைய சொந்தமான பட்டணத்திலுள்ள வீட்டை ஒருவன் வாங்கினால், விற்கப்பட்ட அந்த வீடு, யூபிலி வருடத்தில் விடுதலையாகும். ");
INSERT INTO tam2017_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","அவர்கள் பட்டணங்களைச் சூழ்ந்த வெளிநிலம் விற்கப்படக்கூடாது; அது அவர்களுக்கு நிரந்தர சொந்தமாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“உன் சகோதரன் ஏழ்மையடைந்து, வசதியில்லாமல் போனவனானால் அவனை ஆதரிக்கவேண்டும்; அந்நியனைப்போலவும் தங்கவந்தவனைப்போலவும் அவன் உன்னோடே பிழைப்பானாக. ");
INSERT INTO tam2017_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","நீ அவன் கையில் வட்டியையாவது லாபத்தையாவது வாங்காமல், உன் தேவனுக்குப் பயந்து, உன் சகோதரன் உன்னுடன் பிழைக்கச் செய்வாயாக. ");
INSERT INTO tam2017_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","அவனுக்கு உன் பணத்தை வட்டிக்கும், உன் தானியத்தை லாபத்திற்கும் கொடுக்காதே. ");
INSERT INTO tam2017_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","உங்களுக்குக் கானான் தேசத்தைக் கொடுத்து, உங்களுக்கு தேவனாக இருப்பதற்கு, உங்களை எகிப்துதேசத்திலிருந்து புறப்படச்செய்த உங்கள் தேவனாகிய யெகோவா நானே. ");
INSERT INTO tam2017_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“உன் சகோதரன் ஏழ்மையடைந்து, உனக்கு விற்கப்பட்டுப்போனால், அவனை அடிமையைப்போல வேலைசெய்ய நெருக்கவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","அவன் கூலிக்காரனைப்போலவும் தங்கவந்தவனைப்போலவும் உன்னுடன் இருந்து, யூபிலி வருடம்வரை உன்னிடத்தில் வேலைசெய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","பின்பு, தன் பிள்ளைகளோடுங்கூட உன்னைவிட்டு விலகி, தன் குடும்பத்தாரிடத்திற்கும் தன் முற்பிதாக்களின் சொந்த இடத்திற்கும் திரும்பிப்போகக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","அவர்கள் நான் எகிப்துதேசத்திலிருந்து புறப்படச்செய்த என்னுடைய வேலைக்காரர்கள்; ஆகையால், அவர்கள் அடிமைகளாக விற்கப்படக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","நீ அவனைக் கடினமாக நடத்தாமல், உன் தேவனுக்குப் பயந்திரு. ");
INSERT INTO tam2017_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","உனக்கு இருக்கும் ஆண் அடிமையும் பெண் அடிமையும் சுற்றிலும் இருக்கிற அந்நியமக்களாக இருக்கவேண்டும்; அவர்களில் நீ ஆண் அடிமையையும் பெண் அடிமையையும் விலைக்கு வாங்கலாம். ");
INSERT INTO tam2017_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","உங்களிடத்திலே பரதேசிகளாய்த் தங்குகிற அந்நிய மக்களிலும், உங்கள் தேசத்தில் உங்களிடத்திலே பிறந்திருக்கிற அவர்களுடைய குடும்பத்தாரிலும் நீங்கள் உங்களுக்கு அடிமைகளைக்கொண்டு, அவர்களை உங்களுக்குச் சொந்தமாக்கலாம். ");
INSERT INTO tam2017_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","அவர்களை உங்களுக்குப் பின்வரும் உங்கள் சந்ததியாரும் சொந்தமாக்கும்படி நீங்கள் அவர்களைச் சொந்தமாக்கிக்கொள்ளலாம்; என்றைக்கும் அவர்கள் உங்களுக்கு அடிமைகளாக இருக்கலாம்; உங்கள் சகோதரர்களாகிய இஸ்ரவேல் மக்களோ ஒருவரையொருவர் கடினமாக நடத்தக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“உன்னிடத்தில் இருக்கிற பரதேசியும் அந்நியனும் செல்வந்தனாயிருக்க, அவனிடத்தில் இருக்கிற உன் சகோதரன் தரித்திரப்பட்டு, அந்தப் பரதேசிக்காவது, அந்நியனுக்காவது, பரதேசியின் குடும்பத்தாரில் எவனுக்காவது அவன் விற்கப்பட்டுப்போனால், ");
INSERT INTO tam2017_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","அவன் விற்கப்பட்டுப்போனபின் திரும்ப மீட்கப்படலாம்; அவனுடைய சகோதரர்களில் ஒருவன் அவனை மீட்கலாம். ");
INSERT INTO tam2017_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","அவனுடைய தகப்பனின் சகோதரனாவது, அந்தச் சகோதரனுடைய மகனாவது, அவன் குடும்பத்திலுள்ள அவனைச் சேர்ந்த உறவினரில் யாராவது அவனை மீட்கலாம்; தன்னால் கூடுமானால், தன்னைத்தானே மீட்டுக்கொள்ளலாம். ");
INSERT INTO tam2017_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","அவன் தான் விற்கப்பட்ட வருடம் துவங்கி, யூபிலி வருடம்வரைக்கும் உள்ள காலத்தைத் தன்னை விலைக்கு வாங்கியவனுடன் கணக்குப் பார்க்கக்கடவன்; அவனுடைய விலைக்கிரயம் கூலிக்காரனுடைய காலக்கணக்குப்போல, வருடத்தொகைக்கு ஒப்பிட்டுப்பார்க்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","இன்னும் அநேக வருடங்கள் இருந்தால், அவன் தன் விலைக்கிரயத்திலே அவைகளுக்குத் தக்கதைத் தன்னை மீட்கும்பொருளாகத் திரும்பக்கொடுக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","யூபிலி வருடம்வரை மீதியாக இருக்கிற வருடங்கள் கொஞ்சமாக இருந்தால், அவனோடே கணக்குப் பார்த்து, தன் வருடங்களுக்குத்தக்கதை, தன்னை மீட்கும் பொருளாகத் திரும்பக் கொடுக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","இவன் வருடத்திற்கு வருடம் கூலிபொருந்திக்கொண்ட கூலிக்காரனைப்போல, அவனிடத்தில் இருக்கவேண்டும்; அவன் இவனை உனக்கு முன்பாக கடினமாக நடத்தக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","இப்படி இவன் மீட்டுக்கொள்ளப்படாதிருந்தால், இவனும் இவனோடுகூட இவனுடைய பிள்ளைகளும் யூபிலி வருடத்தில் விடுதலையாவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","இஸ்ரவேல் மக்கள் என் ஊழியக்காரர்கள்; அவர்கள் நான் எகிப்துதேசத்திலிருந்து புறப்படச்செய்த என் ஊழியக்காரர்களே; நான் உங்கள் தேவனாகிய யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“நீங்கள் உங்களுக்கு சிலைகளையும் உருவங்களையும் உண்டாக்காமலும், உங்களுக்குச் சிலையை நிறுத்தாமலும், சித்திரம்வடித்த கல்லை வணங்குவதற்காக உங்கள் தேசத்தில் வைக்காமலும் இருப்பீர்களாக; நான் உங்கள் தேவனாகிய யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","என் ஓய்வுநாட்களை அனுசரித்து, என் பரிசுத்த ஸ்தலத்தைக்குறித்துப் பயபக்தியாக இருப்பீர்களாக; நான் யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“நீங்கள் என் கட்டளைகளின்படி நடந்து, என் கற்பனைகளைக் கைக்கொண்டு, அவைகளின்படி செய்தால், ");
INSERT INTO tam2017_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","நான் ஏற்ற காலத்தில் உங்களுக்கு மழை பெய்யச்செய்வேன்; பூமி தன் பலனையும், வெளியிலுள்ள மரங்கள் தங்கள் பழங்களையும் கொடுக்கும். ");
INSERT INTO tam2017_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","திராட்சைப்பழம் பறிக்கும் காலம்வரைக்கும் போரடிப்புக் காலம் இருக்கும்; விதைப்புக் காலம்வரைக்கும் திராட்சைப்பழம் பறிக்கும் காலம் இருக்கும்; நீங்கள் உங்கள் அப்பத்தைத் திருப்தியாகச் சாப்பிட்டு, உங்கள் தேசத்தில் சுகமாகக் குடியிருப்பீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","தேசத்தில் சமாதானத்தைக் கட்டளையிடுவேன்; தத்தளிக்கச் செய்பவர்கள் இல்லாமல் படுத்துக்கொள்வீர்கள்; கொடிய மிருகங்களைத் தேசத்தில் இல்லாமல் ஒழியச்செய்வேன்; பட்டயம் உங்கள் தேசத்தில் உலாவுவதில்லை. ");
INSERT INTO tam2017_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","உங்கள் எதிரிகளைத் துரத்துவீர்கள்; அவர்கள் உங்களுக்கு முன்பாகப் பட்டயத்தால் விழுவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","உங்களில் ஐந்துபேர் நூறுபேரைத் துரத்துவார்கள்; உங்களில் நூறுபேர் பத்தாயிரம்பேரைத் துரத்துவார்கள்; உங்கள் எதிரிகள் உங்களுக்கு முன்பாகப் பட்டயத்தால் விழுவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","நான் உங்கள்மேல் கண்ணோக்கமாக இருந்து, உங்களைப் பலுகவும் பெருகவும் செய்து, உங்களோடே என் உடன்படிக்கையை உறுதிப்படுத்துவேன். ");
INSERT INTO tam2017_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","போன வருடத்துப் பழைய தானியத்தைச் சாப்பிட்டு, புதிய தானியத்திற்கு இடமுண்டாக, பழையதை அகற்றுவீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","உங்கள் நடுவில் என் வாசஸ்தலத்தை நிறுவுவேன்; என் ஆத்துமா உங்களை வெறுப்பதில்லை. ");
INSERT INTO tam2017_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","நான் உங்கள் நடுவிலே உலாவி, உங்கள் தேவனாக இருப்பேன், நீங்கள் என்னுடைய மக்களாக இருப்பீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","நீங்கள் எகிப்தியர்களுக்கு அடிமைகளாக இல்லாமல், நான் அவர்களுடைய தேசத்திலிருந்து உங்களைப் புறப்படச்செய்து, உங்கள் நுகத்தடிகளை முறித்து, உங்களை நிமிர்ந்து நடக்கச்செய்த உங்கள் தேவனாகிய யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“நீங்கள் எனக்குச் செவிகொடுக்காமலும், இந்தக் கற்பனைகள் எல்லாவற்றின்படி செய்யாமலும், ");
INSERT INTO tam2017_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","என் கட்டளைகளை வெறுத்து, உங்கள் ஆத்துமா என் நியாயங்களை வெறுத்து, என் கற்பனைகள் எல்லாவற்றின்படியும் செய்யாதபடிக்கு, என் உடன்படிக்கையை நீங்கள் மீறுவீர்களென்றால்: ");
INSERT INTO tam2017_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","நான் உங்களுக்குச் செய்வது என்னவென்றால், கண்களைப் பார்வையிழக்கச் செய்கிறதற்கும், இருதயத்தைத் துயரப்படுத்துகிறதற்கும், திகிலையும், நோயையும், காய்ச்சலையும் உங்களுக்கு வரச்செய்வேன்; நீங்கள் விதைக்கும் விதை வீணாயிருக்கும்; உங்கள் எதிரிகள் அதின் பலனைச் சாப்பிடுவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","நான் உங்களுக்கு விரோதமாக என் முகத்தைத் திருப்புவேன்; உங்கள் எதிரிகளுக்கு முன்பாக தோற்கடிக்கப்படுவீர்கள்; உங்கள் பகைவர்கள் உங்களை ஆளுவார்கள்; துரத்துவார் இல்லாதிருந்தும் ஓடுவீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","இந்தவிதமாக நான் உங்களுக்குச் செய்தும், இன்னும் நீங்கள் எனக்குச் செவிகொடுக்காமலிருந்தால், உங்கள் பாவங்களின் காரணமாக மேலும் ஏழுமடங்காக உங்களைத் தண்டித்து, ");
INSERT INTO tam2017_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","உங்கள் வல்லமையின் பெருமையை முறித்து, உங்கள் வானத்தை இரும்பைப் போலவும், பூமியை வெண்கலத்தைப்போலவும் ஆக்குவேன். ");
INSERT INTO tam2017_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","உங்கள் பெலன் வீணாகச் செலவழியும், உங்கள் தேசம் தன் பலனையும், தேசத்தின் மரங்கள் தங்கள் பழங்களையும் கொடுக்காது. ");
INSERT INTO tam2017_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“நீங்கள் எனக்குச் செவிகொடுக்க மனதில்லாமல், எனக்கு எதிர்த்து நடப்பீர்களானால், நான் உங்கள் பாவங்களுக்குத்தக்கதாக இன்னும் ஏழுமடங்கு வாதையை உங்கள்மேல் வரச்செய்து, ");
INSERT INTO tam2017_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","உங்களுக்குள்ளே வெளியின் கொடிய மிருகங்களை வரவிடுவேன்; அவைகள் உங்களைப் பிள்ளைகள் இல்லாதவர்களாக்கி, உங்கள் மிருகஜீவன்களை அழித்து, உங்களைக் குறைந்துபோகச்செய்யும்; உங்கள் வழிகள் பாழாய்க் கிடக்கும். ");
INSERT INTO tam2017_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“நான் கொடுக்கும் தண்டனையினால் நீங்கள் குணப்படாமல், எனக்கு எதிர்த்து நடந்தால், ");
INSERT INTO tam2017_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","நான் உங்களுக்கு எதிர்த்து நடந்து, உங்கள் பாவங்களின் காரணமாக ஏழுமடங்காக வாதித்து, ");
INSERT INTO tam2017_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","என் உடன்படிக்கையை மீறினதற்குப் பழிவாங்கும் பட்டயத்தை உங்கள்மேல் வரச்செய்து, நீங்கள் உங்கள் பட்டணங்களில் சேர்ந்தபின், கொள்ளைநோயை உங்கள் நடுவிலே அனுப்புவேன்; எதிரியின் கையில் ஒப்புக்கொடுக்கப்படுவீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","உங்கள் அப்பம் என்னும் ஆதரவு கோலை நான் முறித்துப்போடும்போது, பத்துப் பெண்கள் ஒரே அடுப்பில் உங்கள் அப்பத்தைச் சுட்டு, அதைத் திரும்ப உங்களுக்கு நிறுத்துக்கொடுப்பார்கள்; நீங்கள் சாப்பிட்டும் திருப்தியடையமாட்டீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“இன்னும் இவைகளெல்லாவற்றாலும் நீங்கள் எனக்குச் செவிகொடுக்காமல், எனக்கு எதிர்த்து நடந்தால், ");
INSERT INTO tam2017_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","நானும் உக்கிரத்தோடே உங்களுக்கு எதிர்த்து நடந்து, நானே உங்கள் பாவங்களுக்காக உங்களை ஏழுமடங்காகத் தண்டிப்பேன். ");
INSERT INTO tam2017_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","உங்கள் மகன்களின் மாம்சத்தையும் உங்கள் மகள்களின் மாம்சத்தையும் சாப்பிடுவீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","நான் உங்கள் மேடைகளை அழித்து, உங்கள் விக்கிரகச் சிலைகளை உடைத்து, உங்கள் உடல்களை உங்கள் நரகலான தேவர்களுடைய உடல்கள்மேல் எறிவேன்; என் ஆத்துமா உங்களை வெறுக்கும். ");
INSERT INTO tam2017_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","நான் உங்கள் பட்டணங்களை வெறுமையும், உங்கள் பரிசுத்த ஸ்தலங்களைப் பாழாக்கி, உங்கள் நறுமண வாசனையை முகராமலிருப்பேன். ");
INSERT INTO tam2017_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","நான் தேசத்தைப் பாழாக்குவேன்; அதிலே குடியிருக்கிற உங்கள் எதிரிகள் பிரமிப்பார்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","தேசங்களுக்குள்ளே உங்களைச் சிதறடித்து, உங்களுக்குப் பின்னே பட்டயத்தை உருவுவேன்; உங்கள் தேசம் பாழும், உங்கள் பட்டணங்கள் வனாந்திரமுமாகும். ");
INSERT INTO tam2017_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","“நீங்கள் உங்கள் எதிரிகளின் தேசத்தில் இருக்கும்போது, தேசமானது பாழாய்க்கிடக்கிற நாட்களெல்லாம் தன் ஓய்வுநாட்களை மகிழ்ச்சியாக அனுபவிக்கும்; அப்பொழுது தேசம் ஓய்வடைந்து, தன் ஓய்வுநாட்களை மகிழ்ச்சியாக அனுபவிக்கும். ");
INSERT INTO tam2017_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","நீங்கள் அதிலே குடியிருக்கும்போது, அது உங்கள் ஓய்வு வருடங்களில் ஓய்வடையாததினாலே, அது பாழாய்க்கிடக்கும் நாட்களெல்லாம் ஓய்வடைந்திருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","உங்களில் உயிரோடு மீதியாக இருப்பவர்களின் இருதயங்கள் தங்கள் எதிரிகளின் தேசங்களில் மனம் சோர்வடையச் செய்வேன்; அசைகிற இலையின் சத்தமும் அவர்களை விரட்டும்; அவர்கள் பட்டயத்திற்குத் தப்பி ஓடுகிறதுபோல ஓடி, துரத்துவார் இல்லாமல் விழுவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","துரத்துவார் இல்லாமல், பட்டயத்திற்கு முன் விழுவதுபோல, ஒருவர்மேல் ஒருவர் இடறிவிழுவார்கள்; உங்கள் எதிரிகளுக்குமுன் நிற்க உங்களுக்குப் பெலன் இருக்காது. ");
INSERT INTO tam2017_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","அன்னியர்களுக்குள்ளே அழிந்துபோவீர்கள்; உங்கள் எதிரிகளின் தேசம் உங்களை அழிக்கும். ");
INSERT INTO tam2017_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","உங்களில் தப்பினவர்கள் தங்கள் அக்கிரமங்களினாலேயும், தங்கள் பிதாக்களின் அக்கிரமங்களினாலேயும், உங்கள் எதிரிகளின் தேசங்களில் சோர்ந்துபோவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“அவர்கள் எனக்கு விரோதமாகத் துரோகம் செய்து நடப்பித்த தங்கள் அக்கிரமத்தையும், தங்கள் முன்னோர்களின் அக்கிரமத்தையும் அறிக்கையிடுகிறதுமல்லாமல், ");
INSERT INTO tam2017_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","அவர்கள் எனக்கு எதிர்த்து நடந்ததினால், நானும் அவர்களுக்கு எதிர்த்து நடந்து, அவர்களுடைய எதிரிகளின் தேசத்திலே அவர்களைக் கொண்டுபோய் விட்டதையும் அறிக்கையிட்டு, விருத்தசேதனமில்லாத தங்கள் இருதயத்தைத் தாழ்த்தி, தங்கள் அக்கிரமத்திற்குக் கிடைத்த தண்டனையை நியாயம் என்று ஒத்துக்கொண்டால், ");
INSERT INTO tam2017_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","நான் யாக்கோபோடே செய்த என் உடன்படிக்கையையும், ஈசாக்குடன் செய்த என் உடன்படிக்கையையும், ஆபிரகாமுடன் செய்த என் உடன்படிக்கையையும் நினைப்பேன்; தேசத்தையும் நினைப்பேன். ");
INSERT INTO tam2017_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","தேசம் அவர்களாலே கைவிடப்பட்டு, பாழாய்க்கிடக்கிறதினாலே தன் ஓய்வுநாட்களை மகிழ்ச்சியாக அனுபவிக்கும்; அவர்கள் என் நியாயங்களை அவமதித்து, அவர்களுடைய ஆத்துமா என் கட்டளைகளை வெறுத்ததினால் அடைந்த தங்களுடைய அக்கிரமத்தின் தண்டனையை நியாயம் என்று ஒத்துக்கொள்ளுவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","அவர்கள் தங்கள் எதிரிகளின் தேசத்திலிருந்தாலும், நான் அவர்களை நிர்மூலமாக்குவதற்கோ, நான் அவர்களோடே செய்த என் உடன்படிக்கையை நிராகரிப்பதற்கோ, நான் அவர்களைக் கைவிடவும் வெறுக்கவும் மாட்டேன்; நான் அவர்களுடைய தேவனாகிய யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","அவர்களுடைய தேவனாக இருக்கும்படிக்கு, நான் அன்னிய மக்களின் கண்களுக்கு முன்பாக எகிப்துதேசத்திலிருந்து அவர்களைப் புறப்படச்செய்து, அவர்களுடைய முன்னோர்களுடன் நான் செய்த உடன்படிக்கையை அவர்களுக்காக நினைவுகூருவேன்; நான் யெகோவா என்று சொல் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","யெகோவா தமக்கும் இஸ்ரவேல் சந்ததியாருக்கும் நடுவே இருக்கும்படி மோசேயைக்கொண்டு, சீனாய்மலையின்மேல் கொடுத்த கட்டளைகளும் நியாயங்களும் இவைகளே. ");
INSERT INTO tam2017_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“நீ இஸ்ரவேல் மக்களிடம் சொல்லவேண்டியது என்னவென்றால்: யாராவது ஒருவர் ஒரு விசேஷித்த பொருத்தனை செய்திருந்தால், பொருத்தனை செய்யப்பட்டவர்கள் உன் மதிப்பின்படி யெகோவாவுக்கு உரியவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","இருபது வயதுமுதல் அறுபது வயதிற்கு உட்பட்ட ஆண் ஒருவனை நீ பரிசுத்த ஸ்தலத்தின் சேக்கலாகிய ஐம்பது வெள்ளிச்சேக்கலாகவும், ");
INSERT INTO tam2017_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","பெண் ஒருவளை முப்பது சேக்கலாகவும் மதிப்பாயாக. ");
INSERT INTO tam2017_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","ஐந்து வயதுமுதல் இருபது வயதிற்கு உட்பட்ட ஆண்பிள்ளையை இருபது சேக்கலாகவும், பெண்பிள்ளையைப் பத்துச்சேக்கலாகவும், ");
INSERT INTO tam2017_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ஒரு மாதம்முதல் ஐந்து வயதிற்கு உட்பட்ட ஆண்பிள்ளையை ஐந்து வெள்ளிச்சேக்கலாகவும், பெண்பிள்ளையை மூன்று வெள்ளிச்சேக்கலாகவும், ");
INSERT INTO tam2017_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","அறுபது வயதுதொடங்கி, அதற்கு மேற்பட்ட வயதுள்ள ஆண்களைப் பதினைந்து சேக்கலாகவும், பெண்களைப் பத்துச் சேக்கலாகவும் மதிக்கக்கடவாய். ");
INSERT INTO tam2017_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","உன் மதிப்பின்படி செலுத்தமுடியாத ஏழையாக இருந்தால், அவன் ஆசாரியனுக்கு முன்பாக வந்து நிற்கக்கடவன்; ஆசாரியன் அவனை மதிப்பானாக; பொருத்தனைசெய்தவனுடைய தகுதிக்குத் தக்கபடி ஆசாரியன் அவனை மதிக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ஒருவன் பொருத்தனைசெய்தது யெகோவாவுக்குப் பலியிடப்படத்தக்க மிருகமானால் அவன் யெகோவாவுக்குக் கொடுக்கிற அவைகளெல்லாம் பரிசுத்தமாக இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","அதை மாற்றாமலும் வேறுபடுத்தாமலும் இருப்பானாக; இளைத்துப்போனதற்குப் பதிலாக நலமானதையும், நலமானதற்குப் பதிலாக இளைத்துப்போனதையும் செலுத்தாமல் இருப்பானாக; அவன் மிருகத்திற்குப் பதிலாக மிருகத்தை மாற்றிக் கொடுப்பானாகில், அப்பொழுது அதுவும் அதற்குப் பதிலாகக் கொடுத்ததும் பரிசுத்தமாக இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","அது யெகோவாவுக்குப் பலியிடப்படத்தகாத சுத்தமில்லாத மிருகமானால், அதை ஆசாரியனுக்கு முன்பாக நிறுத்தக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ஆசாரியன் அது நல்லதானாலும் இளைத்ததானாலும் அதை மதிப்பீடு செய்வானாக; உன் மதிப்பின்படியே இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","அதை மீட்டுக்கொள்ள மனதாயிருந்தானாகில், உன் மதிப்போடே ஐந்தில் ஒரு பங்கைக் கூட்டிக் கொடுக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ஒருவன் தன் வீட்டைக் யெகோவாவுக்குப் பரிசுத்தம் என்று நேர்ந்துகொண்டால், ஆசாரியன் அதின் நலத்திற்கும், நிலைமைக்கும் தக்கதாக அதை மதிக்கக்கடவன்; ஆசாரியன் மதிக்கிறபடி அது இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","தன் வீட்டைப் பரிசுத்தம் என்று நேர்ந்துகொண்டவன் அதை மீட்டுக்கொள்ள மனதாயிருந்தால், நீ மதிக்கும் பொருளுடன் ஐந்தில் ஒரு பங்கைக் கூட்டிக் கொடுக்கக்கடவன்; அப்பொழுது அது அவனுடையதாகும். ");
INSERT INTO tam2017_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ஒருவன் தனக்குச் சொந்தமான வயலில் யாதொரு பங்கைக் யெகோவாவுக்குப் பரிசுத்தம் என்று நேர்ந்துகொண்டால், உன் மதிப்பு அதின் விதைப்புக்குத்தக்கதாக இருக்கவேண்டும்; ஒரு கலம் வாற்கோதுமை விதைக்கிற வயல் ஐம்பது வெள்ளிச் சேக்கலாக மதிக்கப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","யூபிலி வருடம்முதல் அவன் தன் வயலைப் பரிசுத்தம் என்று நேர்ந்துகொண்டால், அது உன் மதிப்பின்படி இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","யூபிலி வருடத்திற்குப்பின் தன் வயலைப் பரிசுத்தம் என்று நேர்ந்துகொண்டானானால், யூபிலி வருடம்வரையுள்ள மற்ற வருடங்களின்படியே ஆசாரியன் பொருட்களைக் கணக்குப்பார்த்து, அதற்குத் தக்கதை உன் மதிப்பீட்டில் தள்ளுபடி செய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","வயலைப் பரிசுத்தம் என்று நேர்ந்துகொண்டவன் அதை மீட்டுக்கொள்ள மனதாயிருந்தால், உன் மதிப்பான பொருட்களுடன் ஐந்தில் ஒரு பங்கை சேர்த்துக்கொடுக்கக்கடவன்; அப்பொழுது அது அவனுக்கு உறுதியாகும். ");
INSERT INTO tam2017_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","அவன் வயலை மீட்டுக்கொள்ளாமல், வயலை வேறொருவனுக்கு விற்றுப்போட்டால், அது திரும்ப மீட்கப்படாமல், ");
INSERT INTO tam2017_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","யூபிலி வருடத்தில் மீட்கப்படும்போது, சாபத்தீடான வயலாகக் யெகோவாவுக்கென்று நியமிக்கப்பட்டதாக இருப்பதாக; அது ஆசாரியனுக்குச் சொந்தமான நிலமாகும். ");
INSERT INTO tam2017_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","ஒருவன் தனக்குச் சொந்தமான வயலாக இல்லாமல், தான் விலைக்கு வாங்கின ஒரு வயலைக் யெகோவாவுக்குப் பரிசுத்தம் என்று நேர்ந்துகொண்டால், ");
INSERT INTO tam2017_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","அது யூபிலி வருடம்வரை, உன் மதிப்பின்படி பெறும்விலை இன்னதென்று ஆசாரியன் அவனோடே கணக்குப்பார்த்து, அந்த உன் மதிப்பை, யெகோவாவுக்குப் பரிசுத்தமாக இருக்கும்படி, அவன் அந்நாளிலே கொடுக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","யார் கையிலே அந்த வயலை வாங்கினானோ, அந்த நிலத்திற்குச் சொந்தக்காரனிடம் அது யூபிலி வருடத்தில் திரும்பச்சேரும். ");
INSERT INTO tam2017_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","உன் மதிப்பீடெல்லாம் பரிசுத்த ஸ்தலத்துச் சேக்கல் கணக்காயிருக்கக்கடவது; ஒரு சேக்கலானது இருபது கேரா. ");
INSERT INTO tam2017_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“முதற்பிறந்தவைகள் யெகோவாவுடையது, ஆகையால் ஒருவரும் முதற்பிறந்தவைகளாகிய மிருகங்களைப் பரிசுத்தம் என்று நேர்ந்துகொள்ளக்கூடாது; அது மாடானாலும் ஆடானாலும் யெகோவாவுடையது. ");
INSERT INTO tam2017_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","சுத்தமல்லாத மிருகத்தினுடைய முதற்பிறந்ததாக இருந்தால், அதை அவன் உன் மதிப்பின்படி மீட்டுக்கொண்டு, அதனுடனே ஐந்தில் ஒரு பங்கைக் கூட்டிக்கொடுக்கக்கடவன்; மீட்கப்படாமலிருந்தால், உன் மதிப்பின்படி அது விற்கப்படக்கடவது. ");
INSERT INTO tam2017_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ஒருவன் தன்னிடத்திலுள்ள மனிதர்களிலாவது, மிருகங்களிலாவது, சொந்தமான நிலத்திலாவது, எதையாகிலும் யெகோவாவுக்கென்று நேர்ந்துகொண்டால், அது விற்கப்படவும் மீட்கப்படவும் கூடாது; நேர்ந்துகொள்ளப்பட்டவைகளெல்லாம் யெகோவாவுக்காகப் பரிசுத்தமாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","மனிதர்களில் சாபத்தீடாக நியமிக்கப்பட்டவர்களெல்லாம் மீட்கப்படாமல் கொலைசெய்யப்படக்கடவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“தேசத்திலே நிலத்தின் வித்திலும், மரங்களின் பழங்களிலும், தசமபாகம் எல்லாம் யெகோவாவுக்கு உரியது; அது யெகோவாவுக்குப் பரிசுத்தமானது. ");
INSERT INTO tam2017_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","ஒருவன் தன் தசமபாகத்திலே எவ்வளவாவது மீட்டுக்கொள்ள விருப்பமாக இருந்தான் என்றால், அதனுடன் ஐந்தில் ஒரு பங்கைக் கூட்டிக் கொடுக்கக்கடவன். ");
INSERT INTO tam2017_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","மேய்ப்பனின் கோலின் கீழ்ப்பட்ட ஆடுமாடுகளிலே பத்தில் ஒரு பங்காகிறதெல்லாம் யெகோவாவுக்குப் பரிசுத்தமானது. ");
INSERT INTO tam2017_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","அது நல்லதோ குறைபாடுள்ளதோ என்று அவன் பார்க்கவேண்டாம்; அதை மாற்றவும் வேண்டாம்; மாற்றினால், அதுவும் அதற்குப் பதிலாகக் கொடுக்கப்பட்டதுமாகிய இரண்டும் பரிசுத்தமாகும்; அது மீட்கப்படக்கூடாதென்று அவர்களோடே சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","இஸ்ரவேல் மக்களுக்குச் சொல்லும்படி யெகோவா சீனாய்மலையில் மோசேக்கு விதித்த கட்டளைகள் இவைகளே.");
INSERT INTO tam2017_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","இஸ்ரவேல் மக்கள் எகிப்துதேசத்திலிருந்து புறப்பட்ட இரண்டாம் வருடம் இரண்டாம் மாதம் முதல் தேதியில், யெகோவா சீனாய் வனாந்திரத்தில் இருக்கிற ஆசரிப்புக் கூடாரத்திலே மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“நீங்கள் இஸ்ரவேலர்களின் முழுச்சபையாக இருக்கிற அவர்கள் தகப்பன்மார்களுடைய வீட்டு வம்சங்களிலுள்ள ஆண்களாகிய எல்லா தலைகளையும் ஒவ்வொருவராக எண்ணிக் கணக்கெடுங்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","இஸ்ரவேலிலே இருபது வயதுள்ளவர்கள்முதல் யுத்தத்திற்குப் புறப்படக்கூடியவர்கள் எல்லோரையும் அவர்களுடைய சேனைகளின்படி நீயும் ஆரோனும் எண்ணிப்பாருங்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","ஒவ்வொரு வம்சத்திற்கும் ஒவ்வொரு மனிதன் உங்களோடு இருக்கவேண்டும்; அவன் தன்னுடைய பிதாக்களின் வம்சத்திற்குத் தலைவனாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","உங்களோடு நிற்கவேண்டிய மனிதர்களுடைய பெயர்கள்: ரூபன் கோத்திரத்தில் சேதேயூருடைய மகன் எலிசூர். ");
INSERT INTO tam2017_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","சிமியோன் கோத்திரத்தில் சூரிஷதாயின் மகன் செலூமியேல். ");
INSERT INTO tam2017_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","யூதா கோத்திரத்தில் அம்மினதாபின் மகன் நகசோன். ");
INSERT INTO tam2017_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","இசக்கார் கோத்திரத்தில் சூவாரின் மகன் நெதனெயேல். ");
INSERT INTO tam2017_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","செபுலோன் கோத்திரத்தில் ஏலோனின் மகன் எலியாப். ");
INSERT INTO tam2017_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","யோசேப்பின் மகன்களாகிய எப்பிராயீம் கோத்திரத்தில் அம்மியூதின் மகன் எலிஷாமா; மனாசே கோத்திரத்தில் பெதாசூரின் மகன் கமாலியேல். ");
INSERT INTO tam2017_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","பென்யமீன் கோத்திரத்தில் கீதெயோனின் மகன் அபீதான். ");
INSERT INTO tam2017_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","தாண் கோத்திரத்தில் அம்மிஷதாயின் மகன் அகியேசேர். ");
INSERT INTO tam2017_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","ஆசேர் கோத்திரத்தில் ஓகிரானின் மகன் பாகியேல். ");
INSERT INTO tam2017_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","காத் கோத்திரத்தில் தேகுவேலின் மகன் எலியாசாப். ");
INSERT INTO tam2017_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","நப்தலி கோத்திரத்தில் ஏனானின் மகன் அகீரா. ");
INSERT INTO tam2017_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","இவர்களே சபையில் ஏற்படுத்தப்பட்டவர்களும், தங்கள் தங்கள் முன்னோர்களுடைய கோத்திரங்களில் பிரபுக்களும், இஸ்ரவேலில் ஆயிரம்பேர்களுக்குத் தலைவர்களுமாக இருப்பவர்கள் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","அப்படியே மோசேயும் ஆரோனும் பேர்பேராகக் குறிக்கப்பட்ட இந்த மனிதர்களைக் கூட்டிக்கொண்டு, ");
INSERT INTO tam2017_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","இரண்டாம் மாதம் முதல் தேதியில் சபையார் எல்லோரையும் கூடிவரச்செய்தார்கள். அப்பொழுது அவர்கள் தங்கள்தங்கள் குடும்பத்தின்படியும், முன்னோர்களுடைய வம்சத்தின்படியும், பெயர் கணக்கின்படியும், இருபது வயதுள்ளவர்கள்முதல் தலைதலையாகத் தங்களுடைய வம்சாவளியைத் தெரிவித்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","இப்படிக் யெகோவா கட்டளையிட்டபடியே, மோசே அவர்களை சீனாய் வனாந்திரத்தில் எண்ணிப்பார்த்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","இஸ்ரவேலின் மூத்தமகனாகிய ரூபன் சந்ததியாருடைய முன்னோர்களின் வீட்டு வம்சத்தாரில் இருபது வயதுள்ளவர்கள்முதல் யுத்தத்திற்குப் புறப்படக்கூடிய ஆண்கள் எல்லோரும் தலைதலையாக எண்ணப்பட்டபோது, ");
INSERT INTO tam2017_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","ரூபன் கோத்திரத்தில் எண்ணப்பட்டவர்கள், 46,500 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","சிமியோன் சந்ததியாருடைய முன்னோர்களின் வீட்டு வம்சத்தாரில் இருபது வயதுள்ளவர்கள்முதல் யுத்தத்திற்குப் புறப்படக்கூடிய ஆண்கள் எல்லோரும் தலைதலையாக எண்ணப்பட்டபோது, ");
INSERT INTO tam2017_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","சிமியோன் கோத்திரத்தில் எண்ணப்பட்டவர்கள், 59,300 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","காத் சந்ததியாருடைய முன்னோர்களின் வீட்டு வம்சத்தாரில் இருபது வயதுள்ளவர்கள் முதல் யுத்தத்திற்குப் புறப்படக்கூடிய ஆண்கள் எல்லோரும் எண்ணப்பட்டபோது, ");
INSERT INTO tam2017_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","காத் கோத்திரத்தில் எண்ணப்பட்டவர்கள், 45,650 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","யூதா சந்ததியாருடைய முன்னோர்களின் வீட்டு வம்சத்தாரில் இருபது வயதுள்ளவர்கள் முதல் யுத்தத்திற்குப் புறப்படக்கூடிய ஆண்கள் எல்லோரும் எண்ணப்பட்டபோது, ");
INSERT INTO tam2017_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","யூதா கோத்திரத்தில் எண்ணப்பட்டவர்கள், 74,600 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","இசக்கார் சந்ததியாருடைய முன்னோர்களின் வீட்டு வம்சத்தாரில் இருபது வயதுள்ளவர்கள்முதல் யுத்தத்திற்குப் புறப்படக்கூடிய ஆண்கள் எல்லோரும் எண்ணப்பட்டபோது, ");
INSERT INTO tam2017_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","இசக்கார் கோத்திரத்தில் எண்ணப்பட்டவர்கள் 54,400 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","செபுலோன் சந்ததியாருடைய புறப்படக்கூடிய முன்னோர்களின் வீட்டு வம்சத்தாரில் இருபது வயதுள்ளவர்கள்முதல் யுத்தத்திற்குப் புறப்படக்கூடிய ஆண்கள் எல்லோரும் எண்ணப்பட்டபோது, ");
INSERT INTO tam2017_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","செபுலோன் கோத்திரத்தில் எண்ணப்பட்டவர்கள், 57,400 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","யோசேப்பின் மகன்களில் எப்பிராயீம் சந்ததியாருடைய முன்னோர்களின் வீட்டு வம்சத்தாரில் இருபது வயதுள்ளவர்கள்முதல் யுத்தத்திற்குப் புறப்படக்கூடிய ஆண்கள் எல்லோரும் எண்ணப்பட்டபோது, ");
INSERT INTO tam2017_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","எப்பிராயீம் கோத்திரத்தில் எண்ணப்பட்டவர்கள், 40,500 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","மனாசே சந்ததியாருடைய முன்னோர்களின் வீட்டு வம்சத்தாரில் இருபது வயதுள்ளவர்கள்முதல் யுத்தத்திற்குப் புறப்படக்கூடிய ஆண்கள் எல்லோரும் எண்ணப்பட்டபோது, ");
INSERT INTO tam2017_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","மனாசே கோத்திரத்தில் எண்ணப்பட்டவர்கள், 32,200 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","பென்யமீன் சந்ததியாருடைய முன்னோர்களின் வீட்டு வம்சத்தாரில் இருபது வயதுள்ளவர்கள்முதல் யுத்தத்திற்குப் புறப்படக்கூடிய ஆண்கள் எல்லோரும் எண்ணப்பட்டபோது, ");
INSERT INTO tam2017_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","பென்யமீன் கோத்திரத்தில் எண்ணப்பட்டவர்கள், 35,400 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","தாண் சந்ததியாருடைய முன்னோர்களின் வீட்டு வம்சத்தாரில் இருபது வயதுள்ளவர்கள்முதல் யுத்தத்திற்குப் புறப்படக்கூடிய ஆண்கள் எல்லோரும் எண்ணப்பட்டபோது, ");
INSERT INTO tam2017_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","தாண் கோத்திரத்தில் எண்ணப்பட்டவர்கள், 62,700 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","ஆசேர் சந்ததியாருடைய முன்னோர்களின் வீட்டு வம்சத்தாரில் இருபது வயதுள்ளவர்கள் முதல் யுத்தத்திற்குப் புறப்படக்கூடிய ஆண்கள் எல்லோரும் எண்ணப்பட்டபோது, ");
INSERT INTO tam2017_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","ஆசேர் கோத்திரத்தில் எண்ணப்பட்டவர்கள், 41,500 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","நப்தலி சந்ததியாருடைய முன்னோர்களின் வீட்டு வம்சத்தாரில் இருபது வயதுள்ளவர்கள்முதல் யுத்தத்திற்குப் புறப்படக்கூடிய ஆண்கள் எல்லோரும் எண்ணப்பட்டபோது, ");
INSERT INTO tam2017_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","நப்தலி கோத்திரத்தில் எண்ணப்பட்டவர்கள், 53,400 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","எண்ணப்பட்டவர்கள் இவர்களே; மோசேயும் ஆரோனும் இஸ்ரவேலுடைய கோத்திரங்களின் வம்சத்தில் ஒவ்வொரு வம்சத்திற்கு ஒவ்வொரு பிரபுவாகிய பன்னிரண்டுபேரும் எண்ணினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","இஸ்ரவேல் பிதாக்களின் வம்சத்தில் இருபது வயதுள்ளவர்கள்முதல், இஸ்ரவேலில் யுத்தத்திற்குப் புறப்படக்கூடியவர்களாகிய எண்ணப்பட்ட நபர்கள் எல்லோரும், ");
INSERT INTO tam2017_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","6,03,550 பேராயிருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","லேவியர்கள் தங்கள் பிதாக்களுடைய கோத்திரத்தின்படியே, மற்றவர்களுடன் எண்ணப்படவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“நீ லேவி கோத்திரத்தாரை மட்டும் எண்ணாமலும், இஸ்ரவேல் மக்களுக்குள்ளே அவர்களுடைய தொகையை சேர்க்காமலும், ");
INSERT INTO tam2017_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","லேவியர்களைச் சாட்சியின் வாசஸ்தலத்திற்கும், அதினுடைய எல்லா பணிப்பொருட்களுக்கும், அதிலுள்ள அனைத்து பொருள்களுக்கும் பொறுப்பாளர்களாக ஏற்படுத்து; அவர்கள் வாசஸ்தலத்தையும் அதின் எல்லா பணிப்பொருட்களையும் சுமக்க வேண்டும்; அதினிடத்தில் ஊழியம் செய்து, வாசஸ்தலத்தைச் சுற்றிலும் முகாமிடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","சாட்சியின் வாசஸ்தலம் புறப்படும்போது, லேவியர்கள் அதை இறக்கிவைத்து, அது நிறுவப்படும்போது, லேவியர்கள் அதை எடுத்து நிறுத்தவேண்டும்; அந்நியன் அதற்கு அருகில் வந்தால் கொலை செய்யப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","இஸ்ரவேல் மக்கள் தங்கள் தங்கள் முகாமோடும், தங்கள் தங்கள் சேனையின் கொடியோடும் கூடாரம் போடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","இஸ்ரவேல் மக்களாகிய சபையின்மேல் கடுங்கோபம் வராதபடி லேவியர்கள் சாட்சியின் வாசஸ்தலத்தைச் சுற்றிலும் முகாமிட்டு, லேவியர்கள் சாட்சியின் வாசஸ்தலத்தைக் காவல்காப்பார்களாக என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","யெகோவா மோசேக்குக் கட்டளையிட்டபடி எல்லாவற்றையும் இஸ்ரவேல் மக்கள் செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","யெகோவா மோசேயையும் ஆரோனையும் நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“இஸ்ரவேல் சந்ததியார்கள் அவரவர் தங்கள் தங்கள் பிதாக்களுடைய வம்சத்தைச் சேர்ந்த தங்கள் தங்கள் கொடியருகில் தங்களுடைய கூடாரங்களைப் போட்டு, ஆசரிப்புக் கூடாரத்திற்கு எதிராகச் சுற்றிலும் முகாமிடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","யூதாவின் முகாமின் கொடியை உடைய இராணுவங்கள் சூரியன் உதிக்கும் கிழக்குப்புறத்திலே முகாமிடவேண்டும்; அம்மினதாபின் மகனாகிய நகசோன் யூதா சந்ததிக்குப் படைத்தலைவனாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","எண்ணப்பட்ட அவனுடைய இராணுவத்தில் இருந்தவர்கள் 74,600 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","அவன் அருகே இசக்கார் கோத்திரத்தார் முகாமிடவேண்டும்; சூவாரின் மகன் நெதனெயேல் இசக்கார் சந்ததிக்குப் படைத்தலைவனாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","எண்ணப்பட்ட அவனுடைய இராணுவத்தில் இருந்தவர்கள் 54,400 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","அவன் அருகே செபுலோன் கோத்திரத்தார் முகாமிடவேண்டும்; ஏலோனின் மகனாகிய எலியாப் செபுலோன் சந்ததிக்குப் படைத்தலைவனாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","அவனுடைய இராணுவத்தில் எண்ணப்பட்டவர்கள் 57,400 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","எண்ணப்பட்ட யூதாவின் முகாமைச்சேர்ந்தவர்கள் எல்லோரும் தங்களுடைய இராணுவங்களின்படியே 1,86,400 பேர்; இவர்கள் பயணத்தில் முதல் முகாமாகப் போகவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“ரூபனுடைய முகாமின் கொடியையுடைய இராணுவங்கள் தென்புறத்தில் முகாமிடவேண்டும்; சேதேயூரின் மகனாகிய எலிசூர் ரூபன் சந்ததியாருக்குப் படைத்தலைவனாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","அவனுடைய இராணுவத்தில் எண்ணப்பட்டவர்கள் 46,500 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","அவன் அருகே சிமியோன் கோத்திரத்தார் முகாமிடவேண்டும்; சூரிஷதாயின் மகனாகிய செலூமியேல் சிமியோன் சந்ததியாருக்குப் படைத்தலைவனாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","அவனுடைய இராணுவத்தில் எண்ணப்பட்டவர்கள் 59,300 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","அவன் அருகே காத் கோத்திரத்தார் முகாமிடவேண்டும்; ரேகுவேலின் மகனாகிய எலியாசாப் காத் சந்ததியாருக்கு படைத்தலைவனாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","அவனுடைய இராணுவத்தில் எண்ணப்பட்டவர்கள் நாற்பத்தையாயிரத்து அறுநூற்று ஐம்பது 45,650 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","எண்ணப்பட்ட ரூபனின் முகாமைச்சேர்ந்தவர்கள் எல்லோரும் தங்களுடைய இராணுவங்களின்படியே 1,51,450 பேர்; இவர்கள் பயணத்தில் இரண்டாம் முகாமாகப் போகவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“பின்பு ஆசரிப்புக் கூடாரம் லேவியர்களின் இராணுவத்தோடு முகாம்களின் நடுவே பிரயாணப்பட்டுப் போகவேண்டும்; எப்படி முகாமிடுகிறார்களோ, அப்படியே அவரவர் தங்களுடைய வரிசையிலே தங்களுடைய கொடிகளோடு பிரயாணமாகப் போகவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“எப்பிராயீமுடைய முகாமின் கொடியையுடைய இராணுவங்கள் மேற்கு புறத்தில் இறங்கவேண்டும், அம்மியூதின் மகனாகிய எலிஷாமா எப்பிராயீமின் சந்ததிக்குப் படைத்தலைவனாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","அவனுடைய இராணுவத்தில் எண்ணப்பட்டவர்கள் 40,500 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","அவன் அருகே மனாசே கோத்திரத்தார் முகாமிடவேண்டும்; பெதாசூரின் மகனாகிய கமாலியேல் மனாசே சந்ததிக்குப் படைத்தலைவனாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","அவனுடைய இராணுவத்தில் எண்ணப்பட்டவர்கள் 32,200 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","அவன் அருகே பென்யமீன் கோத்திரத்தார் முகாமிடவேண்டும்; கீதெயோனின் மகனாகிய அபீதான் பென்யமீன் சந்ததிக்குப் படைத்தலைவனாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","அவனுடைய இராணுவத்தில் எண்ணப்பட்டவர்கள் 35,400 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","எண்ணப்பட்ட எப்பிராயீமின் முகாமைச்சேர்ந்தவர்கள் எல்லோரும் தங்களுடைய இராணுவங்களின்படியே 1,08,100 பேர்; இவர்கள் பயணத்தில் மூன்றாம் முகாமாகப் போகவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“தாணுடைய முகாமின் கொடியையுடைய இராணுவங்கள் வடபுறத்தில் இறங்கவேண்டும்; அம்மிஷதாயின் மகனாகிய அகியேசேர் தாண் வம்சத்திற்குப் படைத்தலைவனாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","அவனுடைய இராணுவத்தில் எண்ணப்பட்டவர்கள் 62,700 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","அவன் அருகே ஆசேர் கோத்திரத்தார் முகாமிடவேண்டும்; ஓகிரானின் மகனாகிய பாகியேல் ஆசேர் சந்ததிக்குப் படைத்தலைவனாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","அவனுடைய இராணுவத்தில் எண்ணப்பட்டவர்கள் 41,500 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","அவன் அருகே நப்தலி கோத்திரத்தார் முகாமிடவேண்டும்; ஏனானின் மகனாகிய அகீரா நப்தலி சந்ததியாருக்குப் படைத்தலைவனாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","அவனுடைய இராணுவத்தில் எண்ணப்பட்டவர்கள் 53,400 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","எண்ணப்பட்ட தாணின் முகாமைச்சேர்ந்தவர்கள் எல்லோரும் 1,57,600 பேர்; இவர்கள் தங்களுடைய கொடிகளோடு கடைசியிலும் போகவேண்டும்”. ");
INSERT INTO tam2017_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","இவர்களே தங்கள் தங்கள் முன்னோர்களின் வம்சத்தின்படி இஸ்ரவேல் மக்களில் எண்ணப்பட்டவர்கள். முகாம்களிலே தங்கள் தங்கள் இராணுவங்களின்படியே எண்ணப்பட்டவர்கள் எல்லோரும் 6,03,550 பேராயிருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","லேவியர்களோ, யெகோவா மோசேக்குக் கட்டளையிட்டபடி, இஸ்ரவேல் மக்களுக்குள்ளே எண்ணப்படவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","யெகோவா மோசேக்குக் கட்டளையிட்டபடியெல்லாம் இஸ்ரவேல் மக்கள் செய்து, தங்கள் தங்கள் கொடிகளின்கீழ் முகாமிட்டு, தங்கள் தங்கள் முன்னோர்களின் வம்சங்களின்படியே பயணப்பட்டுப் போனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","சீனாய் மலையில் யெகோவா மோசேயோடு பேசின நாளில், ஆரோன் மோசே என்பவர்களுடைய வம்சவரலாறு: ");
INSERT INTO tam2017_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","ஆரோனுடைய மகன்கள், முதல் பிறந்தவனாகிய நாதாப், அபியூ, எலெயாசார், இத்தாமார் என்பவர்களே. ");
INSERT INTO tam2017_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","ஆசாரிய ஊழியம் செய்வதற்கு அவனால் பிரதிஷ்டை செய்யப்பட்டு அபிஷேகம் பெற்ற ஆசாரியர்களான ஆரோனுடைய மகன்களின் பெயர்கள் இவைகளே. ");
INSERT INTO tam2017_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","நாதாபும் அபியூவும் சீனாய் வனாந்திரத்தில் அந்நிய அக்கினியைக் யெகோவாவுடைய சந்நிதியில் கொண்டுவந்தபோது, யெகோவாவுடைய சந்நிதியில் இறந்துபோனார்கள்; அவர்களுக்குப் பிள்ளைகள் இல்லை; எலெயாசாரும் இத்தாமாருமே தங்களுடைய தகப்பனாகிய ஆரோனுக்கு முன்பாக ஆசாரிய ஊழியம் செய்தார்கள்; ");
INSERT INTO tam2017_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“நீ லேவிகோத்திரத்தார்களைச் சேர்த்து, அவர்கள் ஆசாரியனாகிய ஆரோனுக்குப் பணிவிடை செய்யும்படி அவர்களை நிறுத்து. ");
INSERT INTO tam2017_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","அவர்கள் ஆசரிப்புக் கூடாரத்திற்கு முன்பாக அவனுடைய காவலையும் எல்லாச் சபையின் காவலையும் காத்து, வாசஸ்தலத்தின் பணிவிடை வேலைகளைச் செய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","அவர்கள் ஆசரிப்புக் கூடாரத்தின் பொருட்கள் முதலானவைகளையும், இஸ்ரவேல் கோத்திரத்தின் காவலையும் காத்து, வாசஸ்தலத்தின் பணிவிடைகளைச் செய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","ஆகையால் லேவியர்களை ஆரோனிடத்திலும் அவனுடைய மகன்களிடத்திலும் ஒப்புக்கொடு; இஸ்ரவேல் மக்களில் இவர்கள் முழுவதுமாக அவனுக்கு ஒப்புக்கொடுக்கப்பட்டிருக்கிறார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","ஆரோனையும் அவனுடைய மகன்களையுமோ, தங்களுடைய ஆசாரிய ஊழியத்தைச் செய்வதற்காக நியமிக்கவேண்டும், அந்த ஊழியத்தைச் செய்யும்படி சேருகிற அந்நியன் கொலைசெய்யப்படவேண்டும் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“இஸ்ரவேல் மக்களில் கர்ப்பம்திறந்து பிறக்கிற முதற்பேறான எல்லாவற்றிற்கும் பதிலாக, நான் லேவியர்களை இஸ்ரவேல் மக்களிலிருந்து எடுத்துக்கொண்டேன்; அவர்கள் என்னுடையவர்களாக இருக்கிறார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","முதற்பேறானவையெல்லாம் என்னுடையவை; நான் எகிப்துதேசத்தில் முதற்பேறான எல்லாவற்றையும் கொலைசெய்த நாளில், இஸ்ரவேலில் மனிதர்கள்முதல் மிருகஜீவன் வரையுள்ள முதற்பேறான எல்லாவற்றையும் எனக்கென்று பரிசுத்தப்படுத்தினதால், அவைகள் என்னுடையவைகளாக இருக்கும்; நான் யெகோவா என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","பின்னும் யெகோவா சீனாய் வனாந்திரத்தில் மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“லேவியின் மக்களை அவர்களுடைய முன்னோர்களின் வம்சங்களின்படியே எண்ணவேண்டும்; அவர்களில் ஒரு மாதம் முதல் அதற்கு மேற்பட்ட வயதுள்ள ஆண்பிள்ளைகளையெல்லாம் எண்ணு என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","அப்பொழுது யெகோவாவுடைய வார்த்தை, தனக்குக் கட்டளையிட்டபடி மோசே அவர்களை எண்ணினான். ");
INSERT INTO tam2017_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","லேவியின் மகன்கள் தங்களுடைய பெயர்களின்படியே, கெர்சோன், கோகாத், மெராரி என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","தங்களுடைய வம்சத்தின்படியே கெர்சோனுடைய மகன்களின் பெயர்கள், லிப்னி, சீமேயி என்பவைகள். ");
INSERT INTO tam2017_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","தங்களுடைய வம்சங்களின்படியே கோகாத்துடைய மகன்கள் அம்ராம், இத்சேயார், எப்ரோன், ஊசியேல் என்பவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","தங்களுடைய வம்சங்களின்படியே மெராரியினுடைய மகன்கள், மகேலி, மூசி என்பவர்கள்; இவர்களே லேவியர்களுடைய பிதாக்களின் வம்சத்தார். ");
INSERT INTO tam2017_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","கெர்சோனின் வழியாக லிப்னீயர்களின் வம்சமும் சீமேயியர்கள் வம்சமும் தோன்றின; இவைகளே கெர்சோனியர்களின் வம்சங்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","அவர்களில் ஒரு மாதம் முதல் அதற்கு மேற்பட்ட வயதுள்ள ஆண்பிள்ளைகளெல்லாம் எண்ணப்பட்டபோது, எண்ணப்பட்டவர்கள் 7,500 பேராக இருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","கெர்சோனியர்களின் வம்சங்கள் வாசஸ்தலத்தின் பின்புறத்தில் மேற்கே முகாமிடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","கெர்சோனியர்களுடைய தகப்பன் வம்சத்திற்குத் தலைவன் லாயேலின் மகனாகிய எலியாசாப் என்பவன். ");
INSERT INTO tam2017_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","ஆசரிப்புக் கூடாரத்திலே கெர்சோன் குடும்பத்தாரின் காவலாவது: வாசஸ்தலமும், கூடாரமும், அதின் மூடியும், ஆசரிப்புக்கூடாரத்தின் வாசல் மறைவும், ");
INSERT INTO tam2017_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","வாசஸ்தலத்தின் அருகிலும் பலிபீடத்தின் அருகிலும் சுற்றிலும் இருக்கிற முற்றத்தின் தொங்கு திரைகளும், முற்றத்தின்வாசல் மூடுதிரையும், அவைகளின் வேலைகளுக்கெல்லாம் உரிய அவைகளின் கயிறுகளுமே. ");
INSERT INTO tam2017_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","கோகாத்தின் வழியாக அம்ராமியர்களின் வம்சமும் இத்சாரியர்களின் வம்சமும் எப்ரோனியர்களின் வம்சமும் ஊசியேலர்களின் வம்சமும் தோன்றின; இவைகளே கோகாத்தியர்களின் வம்சங்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","ஒரு மாதம் முதல் அதற்கு மேற்பட்ட வயதுள்ள ஆண்பிள்ளைகளெல்லாம் எண்ணப்பட்டபோது, பரிசுத்த ஸ்தலத்திற்குரியவைகளைக் காப்பவர்கள், 8,600 பேராக இருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","கோகாத் சந்ததியார்களின் வம்சங்கள் வாசஸ்தலத்தின் தென்புறமான பக்கத்திலே முகாமிடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","அவர்களின் தலைவன், ஊசியேலின் மகனாகிய எலிசாபான். ");
INSERT INTO tam2017_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","அவர்களுடைய காவலாவது: பெட்டியும், மேஜையும், குத்துவிளக்கும், பீடங்களும், ஆராதனைக்கேற்ற பரிசுத்த ஸ்தலத்தின் பணிப்பொருட்களும், தொங்கு திரையும், அதினுடைய எல்லா வேலைகளுக்கும் ஏற்றவைகளுமே. ");
INSERT INTO tam2017_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","ஆசாரியனாகிய ஆரோனின் மகன் எலெயாசார் என்பவன் லேவியர்களுடைய தலைவர்களுக்குத் தலைவனாகப் பரிசுத்த ஸ்தலத்தைக் காவல்காக்கிறவர்களுக்கு விசாரிப்புக்காரனாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","மெராரியின் வழியாக மகலியரின் வம்சமும் மூசியரின் வம்சமும் தோன்றின; இவைகளே மெராரியின் வம்சங்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","அவர்களில் ஒரு மாதம் முதல் அதற்கு மேற்பட்ட வயதுள்ள ஆண்பிள்ளைகளெல்லாம் எண்ணப்பட்டபோது, எண்ணப்பட்டவர்கள் 6,200 பேராக இருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","அபியாயேலின் மகனாகிய சூரியேல் என்பவன் அவர்களுக்குத் தலைவனாக இருந்தான்; இவர்கள் வாசஸ்தலத்தின் வடபுறமான பக்கத்தில் முகாமிடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","அவர்களுடைய காவல் விசாரிப்பாவது: வாசஸ்தலத்தின் பலகைகளும், தாழ்ப்பாள்களும், தூண்களும், பாதங்களும், அதினுடைய எல்லாப் பணிப்பொருட்களும், அதற்குரியவைகள் அனைத்தும், ");
INSERT INTO tam2017_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","சுற்றுப்பிராகாரத்தின் தூண்களும், அவைகளின் பாதங்களும், முளைகளும், கயிறுகளுமே. ");
INSERT INTO tam2017_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","ஆசரிப்புக் கூடாரமாகிய வாசஸ்தலத்திற்கு முன்பாக, சூரியன் உதிக்கும் கிழக்குபக்கத்திலே மோசேயும் ஆரோனும் அவனுடைய மகன்களும் கூடாரங்களைப் போட்டு இறங்கி, இஸ்ரவேல் மக்களின் காவலுக்குப் பதிலாகப் பரிசுத்த ஸ்தலத்தைக் காவல் காக்கவேண்டும். வாசஸ்தலத்தில் சேருகிற அந்நியன் கொலைசெய்யப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","மோசேயும், ஆரோனும், யெகோவாவுடைய வாக்கின்படி, லேவியர்களில் ஒரு மாதம் முதல் அதற்கு மேற்பட்ட வயதுள்ள ஆண்பிள்ளைகளையெல்லாம் அவர்களுடைய வம்சங்களின்படியே எண்ணினார்கள்; அவர்கள் 22,000 பேராக இருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","“அதன் பின்பு யெகோவா மோசேயை நோக்கி: நீ இஸ்ரவேல் மக்களில் ஒரு மாதம் முதல் அதற்கு மேற்பட்ட வயதுள்ள முதற்பேறான ஆண்பிள்ளைகளையெல்லாம் எண்ணி அவர்கள் பெயர்களை பட்டியலிட்டு, ");
INSERT INTO tam2017_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","இஸ்ரவேல் மக்களிலுள்ள முதற்பேறான எல்லாவற்றிற்கும் பதிலாக லேவியர்களையும், இஸ்ரவேல் சந்ததியின் மிருகஜீவன்களிலுள்ள தலையீற்றான யாவுக்கும் பதிலாக லேவியரின் மிருகஜீவன்களையும் எனக்கென்று பிரித்தெடு; நான் யெகோவா என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","அப்பொழுது மோசே, யெகோவா தனக்குக் கட்டளையிட்டபடியே, இஸ்ரவேல் மக்களிலுள்ள முதற்பேறான எல்லோரையும் எண்ணினான். ");
INSERT INTO tam2017_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","ஒரு மாதம் முதல் அதற்கு மேற்பட்ட வயதுள்ள முதற்பேறான ஆண்பிள்ளைகளெல்லோரும் பேர்பேராக எண்ணப்பட்டபோது, 22,273 பேராக இருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","அப்பொழுது யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“நீ இஸ்ரவேல் மக்களிலுள்ள முதற்பேறான அனைவருக்கும் பதிலாக லேவியர்களையும், அவர்களுடைய மிருகஜீவன்களுக்குப்பதிலாக லேவியர்களின் மிருகஜீவன்களையும் பிரித்தெடு; லேவியர்கள் என்னுடையவர்களாக இருப்பார்கள்; நான் யெகோவா. ");
INSERT INTO tam2017_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","இஸ்ரவேல் மக்களுடைய முதற்பேறுகளில் லேவியர்களின் எண்ணிக்கைக்கு அதிகமாக இருந்து, மீட்கப்படவேண்டிய 273 பேரிடத்திலும், ");
INSERT INTO tam2017_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","நீ தலைக்கு ஐந்து சேக்கல் வீதமாகப் பரிசுத்த சேக்கல் கணக்கின்படி வாங்கவேண்டும்; அந்தச் சேக்கலானது இருபது கேரா. ");
INSERT INTO tam2017_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","லேவியர்களுடைய எண்ணிக்கைக்கு அதிகமானவர்கள் மீட்கப்படும் பணத்தை ஆரோனுக்கும் அவனுடைய மகன்களுக்கும் கொடு” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","அப்படியே லேவியர்களால் மீட்கப்பட்டவர்களின் எண்ணிக்கைக்கு அதிகமாக இருந்து, இன்னும் மீட்கப்படவேண்டியவர்களுக்கு ஈடாக மோசே இஸ்ரவேல் மக்களுடைய முதற்பேறானவர்களிடத்தில், ");
INSERT INTO tam2017_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","1,365 சேக்கலாகிய பணத்தை, பரிசுத்த ஸ்தலத்துச் சேக்கல் கணக்கின்படி வாங்கி, ");
INSERT INTO tam2017_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","யெகோவாவுடைய வார்தையின்படியே மீட்கப்பட்டவர்களின் கிரயத்தை ஆரோனுக்கும் அவனுடைய மகன்களுக்கும், யெகோவா தனக்குக் கட்டளையிட்டபடியே கொடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","யெகோவா மோசேயையும் ஆரோனையும் நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“லேவியர்களுக்குள்ளே இருக்கிற கோகாத் சந்ததியார்களுடைய முன்னோர்களின் வீட்டு வம்சங்களில், ");
INSERT INTO tam2017_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","ஆசரிப்புக் கூடாரத்திலே வேலைசெய்யும் கூட்டத்திற்கு உட்படத்தக்க முப்பது வயது முதல் ஐம்பது வயதுவரைக்குமுள்ள எல்லோரையும் எண்ணி, கணக்கெடுக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","ஆசரிப்புக் கூடாரத்திலே கோகாத் சந்ததியாரின் பணிவிடை மகா பரிசுத்தமானவைகளுக்கு உரியது. ");
INSERT INTO tam2017_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","முகாம் புறப்படும்போது, ஆரோனும் அவனுடைய மகன்களும் வந்து, மறைவின் திரைச்சீலையை இறக்கி, அதினாலே சாட்சியின் பெட்டியை மூடி, ");
INSERT INTO tam2017_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","அதின்மேல் மெல்லிய தோல் மூடியைப்போட்டு, அதின்மேல் முற்றிலும் நீலமான துப்பட்டியை விரித்து, அதின் தண்டுகளைப் பாய்ச்சி, ");
INSERT INTO tam2017_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","சமுகத்து அப்ப மேஜையின்மேல் நீலத்துப்பட்டியை விரித்து, தட்டுகளையும் தூபக்கரண்டிகளையும் கிண்ணங்களையும் மூடுகிற தட்டுகளையும் அதின்மேல் வைக்கவேண்டும்; நிரந்தர அப்பமும் அதின்மேல் இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","அவைகளின்மேல் அவர்கள் சிவப்புத்துப்பட்டியை விரித்து, அதை மெல்லிய தோல் மூடியால் மூடி, அதின் தண்டுகளைப் பாய்ச்சி, ");
INSERT INTO tam2017_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","இளநீலத் துப்பட்டியை எடுத்து, குத்துவிளக்குத்தண்டையும், அதின் அகல்களையும், அதின் கத்தரிகளையும், சாம்பல் பாத்திரங்களையும், அதற்குரிய எண்ணெய்ப் பாத்திரங்களையும் மூடி, ");
INSERT INTO tam2017_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","அதையும் அதற்குரிய பொருட்கள் யாவையும் மெல்லிய தோல் மூடிக்குள்ளே போட்டு, அதை ஒரு தண்டிலே கட்டி, ");
INSERT INTO tam2017_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","பொற்பீடத்தின்மேல் இளநீலத் துப்பட்டியை விரித்து, அதைத் மெல்லிய தோல் மூடியால் மூடி, அதின் தண்டுகளைப் பாய்ச்சி, ");
INSERT INTO tam2017_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","பரிசுத்த ஸ்தலத்தில் வழங்கும் ஆராதனைக்கேற்ற எல்லா பொருட்களையும் எடுத்து, இளநீலத் துப்பட்டியிலே போட்டு, மெல்லிய தோல் மூடியினால் மூடி, தண்டின்மேல் கட்டி, ");
INSERT INTO tam2017_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","பலிபீடத்தைச் சாம்பல் போக கழுவி, அதின்மேல் இரத்தாம்பரத் துப்பட்டியை விரித்து, ");
INSERT INTO tam2017_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","அதின்மேல் ஆராதனைக்கு ஏற்ற எல்லாப் பணிப்பொருட்களாகிய கலசங்களையும், முள்துறடுகளையும், சாம்பல் எடுக்கும் கரண்டிகளையும், கலசங்களையும், பலிபீடத்திற்குரிய எல்லாப் பாத்திரங்களையும், அதின்மேல் வைத்து, அதின்மேல் மெல்லிய தோல் மூடியை விரித்து, அதின் தண்டுகளைப் பாய்ச்சவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","முகாம் புறப்படும்போது, ஆரோனும் அவனுடைய மகன்களும் பரிசுத்த ஸ்தலத்தையும் அதினுடைய எல்லா பணிப்பொருட்களையும் மூடிவைத்தபின்பு, கோகாத் சந்ததியார்கள் அதை எடுத்துக்கொண்டுபோவதற்கு வரவேண்டும்; அவர்கள் சாகாதபடிக்கு பரிசுத்தமானதைத் தொடாமலிருக்கவேண்டும்; ஆசரிப்புக் கூடாரத்திலே கோகாத் சந்ததியினர் சுமக்கும் சுமை இதுவே. ");
INSERT INTO tam2017_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“ஆசாரியனாகிய ஆரோனின் மகன் எலெயாசார், விளக்குக்கு எண்ணெயையும், நறுமண தூபவர்க்கத்தையும், தினந்தோறும் இடும் போஜனபலியையும், அபிஷேகத் தைலத்தையும், வாசஸ்தலம் முழுவதையும், அதிலுள்ள யாவையும், பரிசுத்த ஸ்தலத்தையும் அதின் பணிப்பொருட்களையும், விசாரிக்கவேண்டும் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","யெகோவா மோசேயையும் ஆரோனையும் நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“லேவியர்களுக்குள்ளே கோகாத் வம்சமாகிய கோத்திரத்தார் அழிந்துபோகாதபடி பாருங்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","அவர்கள் மகா பரிசுத்தமானவைகளின் அருகில் வரும்போது, சாகாமல் உயிரோடு இருக்கும்படி, நீங்கள் அவர்களுக்காகச் செய்யவேண்டியது: ");
INSERT INTO tam2017_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","ஆரோனும் அவனுடைய மகன்களும் வந்து, அவர்களில் அவனவனை அவனவன் செய்யும் வேலைக்கும் அவனவன் சுமக்கும் சுமைக்கும் நியமிக்கவேண்டும்; அவர்களோ சாகாதபடிப் பரிசுத்தமானவைகள் மூடப்படும்போது பார்க்கிறதற்கு உள்ளே நுழையாமல் இருக்கவேண்டும் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","பின்னும், யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“கெர்சோன் சந்ததியாருடைய பிதாக்களின் வீட்டு வம்சங்களிலும் ஆசரிப்புக் கூடாரத்திலே பணிவிடை வேலைசெய்யும் இராணுவத்திற்கு உட்படத்தக்க, ");
INSERT INTO tam2017_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","முப்பது வயதுமுதல் ஐம்பது வயதுவரைக்குமுள்ள எல்லோரையும் எண்ணி, தொகை ஏற்றுவாயாக. ");
INSERT INTO tam2017_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","பணிவிடை செய்கிறதிலும் சுமக்கிறதிலும் கெர்சோன் வம்சத்தாரின் வேலையாவது: ");
INSERT INTO tam2017_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","அவர்கள் வாசஸ்தலத்திற்கும் ஆசரிப்புக் கூடாரத்திற்கும் உரிய தொங்கு திரையையும், மூடியையும், அவைகளின் மேல் இருக்கிற மெல்லிய தோல் மூடியையும், ஆசரிப்புக்கூடாரத்தின் வாசல் மறைவையும், ");
INSERT INTO tam2017_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","பிராகாரத்தின் தொங்கு திரைகளையும், வாசஸ்தலத்தின் அருகிலும் பலிபீடத்தண்டையிலும் சுற்றிலும் இருக்கிற பிராகாரத்தினுடைய வாசல் தொங்கு திரையையும், அவைகளின் கயிறுகளையும், அவைகளின் வேலைக்குரிய கருவிகள் யாவையும் சுமந்து, அவைகளுக்காகச் செய்யவேண்டிய யாவையும் செய்யக்கடவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","கெர்சோன் சந்ததியார்கள் சுமக்கவேண்டிய சுமைகளும் செய்யவேண்டிய பணிவிடைகளாகிய சகல வேலைகளும் ஆரோனும் அவனுடைய மகன்களும் சொல்லுகிறபடியே செய்யவேண்டும்; அவர்கள் சுமக்கவேண்டிய எல்லா சுமைகளையும் நீங்கள் நியமித்து, அவர்களிடம் ஒப்புவியுங்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","கெர்சோன் சந்ததியாரின் வம்சத்தார் ஆசரிப்புக் கூடாரத்திலே செய்யும் பணிவிடை இதுதான்; அவர்களை வேலைகொள்ளும் விசாரணை, ஆசாரியனாகிய ஆரோனின் மகன் இத்தாமாருடைய கைக்குள் இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“மெராரி சந்ததியாருடைய பிதாக்களின் வீட்டு வம்சங்களிலும் ஆசரிப்புக் கூடாரத்திலே பணிவிடை வேலைசெய்யும் இராணுவத்திற்கு உட்படத்தக்க, ");
INSERT INTO tam2017_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","முப்பது வயதுமுதல் ஐம்பது வயதுவரைக்குமுள்ள எல்லோரையும் எண்ணவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","ஆசரிப்புக் கூடாரத்தில் அவர்கள் செய்யும் எல்லாப் பணிவிடைக்கும் அடுத்த காவல் விசாரிப்பாவது: வாசஸ்தலத்தின் பலகைகளும், தாழ்ப்பாள்களும், தூண்களும், பாதங்களும், ");
INSERT INTO tam2017_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","சுற்றிலும் இருக்கிற பிராகாரத்தின் தூண்களும், அவைகளின் பாதங்களும், முளைகளும், கயிறுகளும், அவைகளின் எல்லா கருவிகளும், அவற்றிற்கு அடுத்த மற்றெல்லா வேலையும்தானே; அவர்கள் சுமந்து காவல்காக்கும்படி ஒப்புவிக்கப்படுகிறவைகளைப் பேர்பேராக எண்ணவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","ஆசாரியனாகிய ஆரோனுடைய மகனான இத்தாமாருடைய கைக்குள்ளாக மெராரி சந்ததியாரின் வம்சத்தார் ஆசரிப்புக் கூடாரத்திலே செய்யும் பணிவிடைக்கு அடுத்த எல்லா வேலையும் இதுவே என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","அப்படியே மோசேயும் ஆரோனும் சபையின் பிரபுக்களும் கோகாத் புத்திரருடைய பிதாக்களின் வீட்டு வம்சங்களின்படி ஆசரிப்புக் கூடாரத்திலே பணிவிடை செய்யும் இராணுவத்திற்கு உட்படத்தக்க, ");
INSERT INTO tam2017_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","முப்பது வயது முதல் ஐம்பது வயதுவரைக்குமுள்ள எல்லோரையும் எண்ணினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","அவர்கள் வம்சங்களில் எண்ணப்பட்டவர்கள் 2,750 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","யெகோவா மோசேக்குக் கட்டளையிட்டபடியே, மோசேயினாலும் ஆரோனாலும் கோகாத் வம்சத்தாரில் ஆசரிப்புக் கூடாரத்தில் வேலை செய்கிறதற்காக எண்ணித் தொகையிடப்பட்டவர்கள் எல்லோரும் இவர்களே. ");
INSERT INTO tam2017_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","கெர்சோன் சந்ததியாருடைய பிதாக்களின் வீட்டு வம்சங்களிலும் ஆசரிப்புக் கூடாரத்திலே பணிவிடை செய்யும் இராணுவத்திற்கு உட்படத்தக்க, ");
INSERT INTO tam2017_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","முப்பது வயது முதல் ஐம்பது வயது வரைக்குமுள்ள எல்லோரும் எண்ணப்பட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","அவர்களில் எண்ணப்பட்டவர்கள் அவரவர் குடும்பத்தின்படியும், பிதாக்களுடைய வம்சத்தின்படிக்கும் 2,630 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","மோசேயினாலும் ஆரோனாலும் யெகோவா கட்டளையிட்டபடியே கெர்சோன் புத்திரரின் வம்சத்தாரில் ஆசரிப்புக் கூடாரத்தில் வேலைசெய்ய எண்ணித் தொகையிடப்பட்டவர்கள் எல்லோரும் இவர்களே. ");
INSERT INTO tam2017_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","மெராரி புத்திரருடைய பிதாக்களின் வீட்டு வம்சங்களிலும் ஆசரிப்புக் கூடாரத்திலே பணிவிடை செய்யும் இராணுவத்திற்கு உட்படத்தக்க, ");
INSERT INTO tam2017_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","முப்பது வயதுமுதல் ஐம்பது வயதுள்ளவர்கள் எல்லோரும் எண்ணப்பட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","அவர்களில் எண்ணப்பட்டவர்கள் தங்களுடைய குடும்பங்களின்படியே 3,200 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","யெகோவா மோசேக்குக் கட்டளையிட்டபடியே மோசேயினாலும் ஆரோனாலும் மெராரி புத்திரரின் குடும்பத்தாரில் எண்ணித் தொகையிடப்பட்டவர்கள் எல்லோரும் இவர்களே. ");
INSERT INTO tam2017_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","லேவியர்களுடைய பிதாக்களின் வீட்டு வம்சங்களில் முப்பது வயதுமுதல் ஐம்பது வயதுவரைக்குமுள்ளவர்கள் ஆசரிப்புக் கூடாரத்திலே செய்யும் பணிவிடை வேலைக்கும் சுமையின் வேலைக்கும் உட்படத்தக்கவர்களும், ");
INSERT INTO tam2017_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","மோசேயினாலும் ஆரோனாலும் இஸ்ரவேலின் பிரபுக்களாலும் எண்ணப்பட்டவர்களும் ஆகிய எல்லோரும், ");
INSERT INTO tam2017_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","8,580 பேராக இருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","யெகோவா மோசேக்குக் கட்டளையிட்டபடியே, அவர்கள் தங்கள் தங்கள் பணிவிடைக்கென்றும் தங்கள் தங்கள் சுமைக்கென்றும் மோசேயினால் எண்ணப்பட்டார்கள்; இந்த விதமாக, யெகோவா மோசேக்குக் கட்டளையிட்டபடியே அவர்கள் அவனால் எண்ணப்பட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“குஷ்டரோகிகள் யாவரையும், கசியும் புண்ணுள்ள யாவரையும், சவத்தினால் தீட்டுப்பட்டவர்கள் யாவரையும் முகாமிலிருந்து விலக்கிவிட இஸ்ரவேல் மக்களுக்கு கட்டளையிடு. ");
INSERT INTO tam2017_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","ஆண்பிள்ளையானாலும் பெண்பிள்ளையானாலும் அப்படிப்பட்டவர்களை நீங்கள் விலக்கி, நான் வாசம்செய்கிற தங்களுடைய முகாம்களை அவர்கள் தீட்டுப்படுத்தாதபடி, நீங்கள் அவர்களை முகாமிற்கு வெளியே அனுப்பிவிடவேண்டும் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","யெகோவா மோசேக்குச் சொன்னபடியே, இஸ்ரவேல் மக்கள் செய்து, அவர்களை முகாமிற்கு வெளியே அனுப்பிவிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","மேலும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“நீ இஸ்ரவேல் மக்களோடு சொல்லவேண்டியது என்னவென்றால்: ஒரு ஆணோ பெண்ணோ, யெகோவாவுடைய கட்டளையை மீறி மனிதர்கள் செய்யும் பாவங்களில் யாதொரு பாவத்தைச் செய்து குற்றவாளியானால், ");
INSERT INTO tam2017_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","அவர்கள் தாங்கள் செய்த பாவத்தை அறிக்கையிடவேண்டும்; அப்படிப்பட்டவன் தான் செய்த குற்றத்தினால் அபராதத்தின் முதலோடு ஐந்தில் ஒரு பங்கை அதிகமாகக் கூட்டி, தான் குற்றஞ்செய்தவனுக்குச் செலுத்தவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","அதைக் கேட்டு வாங்குகிறதற்கு இனத்தான் ஒருவனும் இல்லாமலிருந்தால், அப்பொழுது அவனுக்காகப் பாவநிவிர்த்தி செய்யும்படி ஆட்டுக்கடா செலுத்தப்படுவதுமல்லாமல், யெகோவாவுக்கு அந்த அபராதம் செலுத்தப்பட்டு, அது ஆசாரியனைச் சேரவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","இஸ்ரவேல் மக்கள் ஏறெடுத்துப் படைக்கும்படி, ஆசாரியனிடத்தில் கொண்டுவருகிற எல்லாப் பரிசுத்தமான படைப்பும் அவனுடையதாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","ஒவ்வொருவரும் படைக்கும் பரிசுத்தமான பொருட்கள் அவனுடையதாக இருக்கும்; ஒருவன் ஆசாரியனுக்குக் கொடுக்கிறது எதுவும் அவனுக்கே உரியது என்று சொல் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“நீ இஸ்ரவேல் மக்களுக்குச் சொல்லவேண்டியது என்னவென்றால்: ஒருவனுடைய மனைவி பிறர்முகம் பார்த்து, கணவனுக்குத் துரோகம்செய்து, ");
INSERT INTO tam2017_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ஒருவனோடு உறவு கொண்டிருந்த விஷயத்தில் அவள் தீட்டுப்பட்டவளாக இருந்தும், அவளுடைய கணவன் கண்களுக்கு அது மறைக்கப்பட்டு வெளிக்கு வராமல் இருக்கிறபோதும், சாட்சியில்லாமலும் அவள் கையும் களவுமாகப் பிடிக்கப்படாமலும் இருக்கிறபோதும், ");
INSERT INTO tam2017_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","எரிச்சலின் ஆவி அவன்மேல் வந்து, அவன் அவனுடைய மனைவி தீட்டுப்படுத்தப்பட்டிருக்க, தீட்டுப்படுத்தப்பட்ட தன்னுடைய மனைவியின்மேல் பகைகொண்டிருந்தாலும், அல்லது அவன் மனைவி தீட்டுப்படுத்தப்படாதிருக்க, எரிச்சலின் ஆவி அவன்மேல் வந்து, அவன் அவள்மேல் பகைகொண்டிருந்தாலும், ");
INSERT INTO tam2017_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","அந்தக் கணவன் தன்னுடைய மனைவியை ஆசாரியனிடத்தில் அழைத்துக்கொண்டுவந்து, அவளுக்காக ஒரு எப்பா அளவான வாற்கோதுமை மாவிலே பத்தில் ஒரு பங்கைப் படைப்பாகக் கொடுக்கவேண்டும்; அது எரிச்சலின் காணிக்கையும் அக்கிரமத்தை நினைப்பூட்டும் காணிக்கையுமாக இருப்பதால், அதின்மேல் எண்ணெய் ஊற்றாமலும் தூபவர்க்கம் போடாமலும் இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ஆசாரியன் அவளைச் சமீபத்தில் அழைத்து, யெகோவாவுடைய சந்நிதியில் நிறுத்தி, ");
INSERT INTO tam2017_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","ஒரு மண்பானையிலே பரிசுத்த தண்ணீர் ஊற்றி, வாசஸ்தலத்தின் தரையிலிருக்கும் புழுதியிலே கொஞ்சம் எடுத்து, அந்த தண்ணீரில்போட்டு, ");
INSERT INTO tam2017_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","பெண்ணைக் யெகோவாவுடைய சந்நிதியில் நிறுத்தி, அவளுடைய முக்காட்டை நீக்கி, எரிச்சலின் காணிக்கையாகிய நினைப்பூட்டுதலின் காணிக்கையை அவளுடைய உள்ளங்கையிலே வைக்கவேண்டும்; சாபகாரணமான கசப்பான தண்ணீர் ஆசாரியன் கையில் இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","பின்பு ஆசாரியன் அவளை ஆணையிட வைத்து: ஒருவனும் உன்னோடு உறவுகொள்ளாமலும், உன்னுடைய கணவனுக்கு கீழ்பட்டிருக்கிற நீ தீட்டுப்படும்படி பிறர்முகம் பார்க்காமலும் இருந்தால், சாபகாரணமான இந்தக் கசப்பான தண்ணீரின் தோஷத்திற்கு நீங்கலாக இருப்பாய். ");
INSERT INTO tam2017_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","உன்னுடைய கணவனுக்கு கீழ்ப்பட்டிருக்கிற நீ பிறர்முகம் பார்த்து, உன்னுடைய கணவனைத்தவிர அந்நியனோடு உறவுகொண்டு தீட்டுப்பட்டிருப்பாயானால், ");
INSERT INTO tam2017_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","யெகோவா உன்னுடைய இடுப்பு சூம்பவும், உன்னுடைய வயிறு வீங்கவும்செய்து, உன்னை உன்னுடைய மக்களுக்குள்ளே சாபமும் ஆணையிடும் அடையாளமாகவும் வைப்பாராக. ");
INSERT INTO tam2017_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","சாபகாரணமான இந்த தண்ணீர் உன்னுடைய வயிறு வீங்கவும் இடுப்பு சூம்பவும் செய்யும்படி, உன்னுடைய குடலுக்குள் போகவேண்டும் என்கிற சாபவார்த்தையாலே பெண்ணை ஆணையிடவைத்துச் சொல்வானாக. அதற்கு அந்தப் பெண்: ஆமென், ஆமென், என்று சொல்லவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“பின்பு ஆசாரியன் இந்தச் சாபவார்த்தைகளை ஒரு சீட்டில் எழுதி, அவைகளைக் கசப்பான தண்ணீரால் கழுவிப்போட்டு, ");
INSERT INTO tam2017_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","சாபகாரணமான அந்தக் கசப்பான தண்ணீரை அவள் குடிக்கும்படிச் செய்வான்; அப்பொழுது சாபகாரணமான அந்த தண்ணீர் அவளுக்குள் இறங்கிக் கசப்பாகும். ");
INSERT INTO tam2017_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","பின்பு ஆசாரியன் எரிச்சலின் காணிக்கையை அந்த பெண்ணின் கையிலிருந்து வாங்கி, அதைக் யெகோவாவுடைய சந்நிதியில் அசைவாட்டி, பீடத்தின்மேல் செலுத்தி, ");
INSERT INTO tam2017_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","ஞாபகக்குறியாக அதிலே ஒரு கைப்பிடி நிறைய எடுத்து, பீடத்தின்மேல் தகனித்து, பின்பு பெண்ணுக்கு அந்த தண்ணீரைக்குடிக்கும்படி கொடுக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","அந்த தண்ணீரைக் குடிக்கச் செய்த பின்பு சம்பவிப்பதாவது: அவள் தீட்டுப்பட்டு, தன்னுடைய கணவனுக்குத் துரோகம்செய்திருந்தால், சாபகாரணமான அந்த தண்ணீர் அவளுக்குள் நுழைந்து கசப்புண்டானதால், அவளுடைய வயிறு வீங்கி, அவளுடைய இடுப்பு சூம்பும்; இப்படியே அந்தப் பெண் தன்னுடைய மக்களுக்குள்ளே சாபமாக இருப்பாள். ");
INSERT INTO tam2017_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","அந்தப் பெண் தீட்டுப்படாமல் சுத்தமாக இருந்தால், அவள் அதற்கு நீங்கலாகி, கர்ப்பமடையக்கூடியவளாக இருப்பாள். ");
INSERT INTO tam2017_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ஒரு பெண் தன்னுடைய கணவனைத்தவிர அந்நிய ஆணோடு சேர்ந்து தீட்டுப்பட்டதால் உண்டான எரிச்சலுக்கும், ");
INSERT INTO tam2017_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","கணவன்மேல் எரிச்சலின் ஆவி வருகிறதினால், அவன் தன்னுடைய மனைவியின்மேல் அடைந்த பொறாமைக்கும் அடுத்த பிரமாணம் இதுவே. அவன் யெகோவாவுடைய சந்நிதியில் தன்னுடைய மனைவியை நிறுத்தவேண்டும்; ஆசாரியன் இந்தப் பிரமாணத்தின்படியெல்லாம் அவளுக்குச் செய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","கணவன் அக்கிரமத்திற்கு நீங்கலாக இருப்பான்; அப்படிப்பட்டப் பெண்ணோ, தன்னுடைய அக்கிரமத்தைச் சுமப்பாள் என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“நீ இஸ்ரவேல் மக்களோடு சொல்லவேண்டியது என்னவென்றால்: “ஆணோ பெண்ணோ யெகோவாக்கென்று விரதம் செய்து கொண்டவர்களாக இருக்கும்படி நசரேய விரதமாகிய ஒரு விசேஷித்த பொருத்தனையை செய்தால், ");
INSERT INTO tam2017_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","அப்படிப்பட்டவன் திராட்சைரசத்தையும் மதுபானத்தையும் விலக்கவேண்டும்; அவன் திராட்சைரசத்தின் காடியையும் மற்ற மதுபானத்தின் காடியையும், திராட்சைரசத்தினால் செய்த எவ்விதமான பானத்தையும் குடிக்காமலும், திராட்சைப்பழங்களையோ திராட்சைவற்றல்களையோ சாப்பிடாமலும், ");
INSERT INTO tam2017_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","தான் நசரேயனாக இருக்கும் நாளெல்லாம் திராட்சைச்செடி விதைமுதல் தோல்வரை உள்ளவைகளினால் செய்யப்பட்ட எதையும் சாப்பிடாமலும் இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“அவன் நசரேய விரதமிருக்கும் நாட்களெல்லாம் சவரகன் கத்தி அவனுடைய தலையின்மேல் படக்கூடாது; அவன் யெகோவாக்கென்று விரதமிருக்கும் காலம் நிறைவேறும்வரை பரிசுத்தமாக இருந்து, தன்னுடைய தலைமுடியை வளரவிடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","அவன் யெகோவாவுக்கென்று விரதமிருக்கும் நாட்களெல்லாம் யாதொரு பிரேதத்தின் அருகில் போகக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","அவன் தன்முடைய தேவனுக்கென்று செய்த நசரேய விரதம் அவனுடைய தலைமேல் இருக்கிறபடியால், மரணமடைந்த தன்னுடைய தகப்பனாலாகிலும் தாயினாலாகிலும் சகோதரனாலோ சகோதரியினாலோ தன்னைத் தீட்டுப்படுத்தக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","அவன் நசரேயனாக இருக்கும் நாட்களெல்லாம் யெகோவாவுக்குப் பரிசுத்தமாக இருப்பான். ");
INSERT INTO tam2017_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“அவனருகில் ஒருவன் திடீரென மரணமடைந்ததால், நசரேய விரதமுள்ள அவனுடைய தலை தீட்டுப்பட்டதென்றால், அவன் தன்னுடைய சுத்திகரிப்பின் நாளாகிய ஏழாம் நாளில் தன்னுடைய தலைமுடியைச் சிரைத்துக்கொண்டு, ");
INSERT INTO tam2017_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","எட்டாம் நாளில் இரண்டு காட்டுப்புறாக்களையோ இரண்டு புறாக்குஞ்சுகளையோ ஆசரிப்புக்கூடாரத்தின் வாசலில் ஆசாரியனிடம் கொண்டுவரவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","அப்பொழுது ஆசாரியன் ஒன்றைப் பாவநிவாரணபலியாகவும், மற்றொன்றைச் சர்வாங்க தகனபலியாகவும் செலுத்தி, பிணத்தினால் அவனுக்கு உண்டான தீட்டை நிவிர்த்திசெய்து, அவனுடைய தலையை அந்தநாளில் பரிசுத்தப்படுத்தவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","அவன் திரும்பவும் தன்னுடைய விரதநாட்களைக் யேகோவாக்கென்று காத்து, ஒரு வயதுள்ள ஆட்டுக்குட்டியைக் குற்றநிவாரணபலியாகக் கொண்டுவரவேண்டும்; அவனுடைய நசரேய விரதம் தீட்டுப்பட்டதால் சென்ற நாட்கள் வீணாகும். ");
INSERT INTO tam2017_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“நசரேயனுக்குரிய பிரமாணமாவது: அவன் விரதமிருக்கும் நாட்கள் நிறைவேறின அன்றைக்கே, அவன் ஆசரிப்புக்கூடாரத்தின் வாசலிலே வந்து, ");
INSERT INTO tam2017_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","சர்வாங்க தகனபலியாக ஒருவயதுடைய பழுதற்ற ஒரு ஆட்டுக்குட்டியையும், பாவநிவாரணபலியாக ஒருவயதுடைய பழுதற்ற ஒரு பெண்ணாட்டுக்குட்டியையும், சமாதானபலியாக பழுதற்ற ஒரு ஆட்டுக்கடாவையும், ");
INSERT INTO tam2017_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ஒரு கூடையில் எண்ணெயிலே பிசைந்த புளிப்பில்லாத மெல்லிய மாவினால் செய்த அதிரசங்களையும், எண்ணெய் தடவப்பட்ட புளிப்பில்லாத அடைகளையும், அவைகளுக்கு அடுத்த போஜனபலியையும், பானபலிகளையும் யெகோவாவுக்குத் தன்னுடைய காணிக்கையாகச் செலுத்தவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","அவைகளை ஆசாரியன் யெகோவாவுடைய சந்நிதியில் கொண்டுவந்து, அவனுடைய பாவநிவாரணபலியையும் அவனுடைய சர்வாங்கதகனபலியையும் செலுத்தி, ");
INSERT INTO tam2017_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","ஆட்டுக்கடாவைக் கூடையில் இருக்கும் புளிப்பில்லாத அப்பங்களோடுங்கூடக் யெகோவாவுக்குச் சமாதான பலியாகச் செலுத்தி, அவனுடைய போஜனபலியையும் பானபலியையும் படைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","அப்பொழுது நசரேயன் ஆசரிப்புக்கூடாரத்தின் வாசலிலே, பொருத்தனை செய்யப்பட்ட தன்னுடைய தலையைச் சிரைத்து, பொருத்தனை செய்யப்பட்ட தன்னுடைய தலைமுடியை எடுத்து, சமாதானபலியின்கீழ் எரிகிற அக்கினியில் போடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","நசரேயன் பொருத்தனை செய்யப்பட்ட தன் தலைமுடியைச் சிரைத்துக்கொண்டபின்பு, ஆசாரியன் ஆட்டுக்கடாவினுடைய வேகவைக்கப்பட்ட ஒரு முன்னந்தொடையையும், கூடையில் இருக்கிறவைகளிலே புளிப்பில்லாத ஒரு அதிரசத்தையும் புளிப்பில்லாத ஒரு அடையையும் எடுத்து, அவனுடைய உள்ளங்கைகளில் வைத்து, ");
INSERT INTO tam2017_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","அவைகளைக் யெகோவாவுடைய சந்நிதியில் அசைவாட்டவேண்டும்; அது அசைவாட்டப்பட்ட மார்புப்பகுதியோடும், ஏறெடுத்துப் படைக்கப்பட்ட முன்னந்தொடையோடும், ஆசாரியனைச் சேரும்; அது பரிசுத்தமானது. பின்பு நசரேயன் திராட்சைரசம் குடிக்கலாம். ");
INSERT INTO tam2017_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“பொருத்தனைசெய்த நசரேயனுக்கும், அவன் தன்னுடைய கைக்கு உதவுகிறதைத்தவிர, தன் நசரேய விரதத்திற்காக யெகோவாவுக்குச் செலுத்தும் காணிக்கையின் பிரமாணம் இதுவே. அவன் செய்த பொருத்தனையின்படியே தன்னுடைய பொருத்தனையின் பிரமாணத்துக்கேற்றபடி செய்து முடிக்கவேண்டும் என்று சொல் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“நீ ஆரோனோடும் அவனுடைய மகன்களோடும் சொல்லவேண்டியது என்னவென்றால்: நீங்கள் இஸ்ரவேல் மக்களை ஆசீர்வதிக்கும்போது, அவர்களைப் பார்த்துச் சொல்லவேண்டியதாவது: ");
INSERT INTO tam2017_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“யெகோவா உன்னை ஆசீர்வதித்து, உன்னைக் காப்பார். ");
INSERT INTO tam2017_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","“யெகோவா தம்முடைய முகத்தை உன்மேல் பிரகாசிக்கச்செய்து, உன்மேல் கிருபையாக இருபாராக. ");
INSERT INTO tam2017_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","“யெகோவா தம்முடைய முகத்தை உன்மேல் பிரசன்னமாக்கி, உனக்குச் சமாதானம் கட்டளையிடுவார், என்பதே. ");
INSERT INTO tam2017_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“இந்த விதமாக அவர்கள் என்னுடைய நாமத்தை இஸ்ரவேல் மக்கள்மேல் கூறவேண்டும்; அப்பொழுது நான் அவர்களை ஆசீர்வதிப்பேன் என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","மோசே வாசஸ்தலத்தை நிறுவி, அதையும் அதின் எல்லாப் பணிப்பொருட்களையும், பலிபீடத்தையும் அதின் எல்லாப் பணிப்பொருட்களையும் அபிஷேகம்செய்து, பரிசுத்தப்படுத்தி முடித்த நாளில், ");
INSERT INTO tam2017_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","தங்களுடைய பிதாக்களுடைய வம்சத்தலைவர்களும், எண்ணப்பட்டவர்களின் விசாரிப்புக்கு வைக்கப்பட்ட கோத்திரப் பிரபுக்களுமாகிய இஸ்ரவேலின் பிரபுக்கள் காணிக்கைகளைச் செலுத்தினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","தங்களுடைய காணிக்கையாக, ஆறு கூண்டுவண்டிகளையும், பன்னிரண்டு மாடுகளையும் இரண்டிரண்டு பிரபுக்களுக்கு ஒவ்வொரு வண்டியும், ஒவ்வொரு பிரபுக்கு ஒவ்வொரு மாடுமாக, யெகோவாவுக்குச் செலுத்த வாசஸ்தலத்திற்கு முன்பாகக் கொண்டுவந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","அப்பொழுது யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“நீ அவர்களிடத்தில் ஆசரிப்புக் கூடாரத்தின் ஊழியத்திற்காக அவைகளை வாங்கி. லேவியர்களுக்கு அவரவர் வேலைக்குத் தகுந்தவைகளாகப் பங்கிட்டுக் கொடு என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","அப்பொழுது மோசே அந்த வண்டிகளையும் மாடுகளையும் வாங்கி, லேவியர்களுக்குக் கொடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","இரண்டு வண்டிகளையும் நான்கு மாடுகளையும் கெர்சோன் சந்ததியார்களுக்கு, அவர்கள் வேலைக்குத்தகுந்த பங்காகக் கொடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","நான்கு வண்டிகளையும் எட்டு மாடுகளையும் மெராரியின் சந்ததியினருக்கு, ஆசாரியனாகிய ஆரோனின் மகன்கள் இத்தாமாருடைய கையின் கீழிருக்கிற அவர்களுடைய வேலைக்குத்தகுந்த பங்காகக் கொடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","கோகாத்தின் சந்ததியாருக்கோ ஒன்றும் கொடுக்கவில்லை; தோள்மேல் சுமப்பதே அவர்களுக்குரிய பரிசுத்த ஸ்தலத்தின் வேலையாக இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","பலிபீடம் அபிஷேகம்செய்யப்பட்ட நாளிலே, பிரபுக்கள் அதின் பிரதிஷ்டைக்காகக் காணிக்கைகளைச் செலுத்தி, பலிபீடத்திற்கு முன்பாகத் தங்களுடைய காணிக்கைகளைக் கொண்டுவந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","“அப்பொழுது யெகோவா மோசேயை நோக்கி: பலிபீடத்தின் பிரதிஷ்டைக்காக ஒவ்வொரு பிரபுவும் தன்தன் நாளில் தன்தன் காணிக்கையைச் செலுத்தவேண்டும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","அப்படியே முதலாம் நாளில் தன்னுடைய காணிக்கையைச் செலுத்தினவன் யூதா கோத்திரத்தானாகிய அம்மினதாபின் மகன் நகசோன். ");
INSERT INTO tam2017_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","அவனுடைய காணிக்கையாவது: போஜனபலியாகப் படைப்பதற்காக எண்ணெயிலே பிசைந்த மெல்லிய மாவினால் நிறைந்ததும், பரிசுத்த ஸ்தலத்தின் சேக்கல் கணக்காக நூற்றுமுப்பது சேக்கல் நிறையுள்ளதுமான ஒரு வெள்ளித்தட்டும், எழுபது சேக்கல் நிறையுள்ள ஒரு வெள்ளிப்பாத்திரமும் ஆகிய இந்த இரண்டும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","தூபவர்க்கம் நிறைந்த பத்துச்சேக்கல் நிறையுள்ள தங்கத்தால் செய்த ஒரு தூபகரண்டியும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","சர்வாங்கதகனபலியாக ஒரு காளையும், ஒரு ஆட்டுக்கடாவும், ஒருவயதுடைய ஒரு ஆட்டுக்குட்டியும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","பாவநிவாரணபலியாக ஒரு வெள்ளாட்டுக்கடாவும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","சமாதானபலியாக இரண்டு மாடுகளும், ஐந்து ஆட்டுக்கடாக்களும், ஐந்து வெள்ளாட்டுக்கடாக்களும், ஒருவயதுடைய ஐந்து ஆட்டுக்குட்டிகளுமே; இது அம்மினதாபின் மகனாகிய நகசோனின் காணிக்கை. ");
INSERT INTO tam2017_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","இரண்டாம் நாளில் இசக்காரின் பிரபுவாகிய சூவாரின் மகன் நெதனெயேல் காணிக்கை செலுத்தினான். ");
INSERT INTO tam2017_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","அவனுடைய காணிக்கையாவது: போஜனபலியாகப் படைப்பதற்காக, எண்ணெயிலே பிசைந்த மெல்லிய மாவினால் நிறைந்ததும், பரிசுத்த ஸ்தலத்தின் சேக்கல் கணக்காக நூற்றுமுப்பது சேக்கல் நிறையுள்ளதுமான ஒரு வெள்ளித்தட்டும், எழுபது சேக்கல் நிறையுள்ள ஒரு வெள்ளிப்பாத்திரமும் ஆகிய இந்த இரண்டும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","தூபவர்க்கம் நிறைந்த பத்துச்சேக்கல் நிறையுள்ள பொன்னினால் செய்த ஒரு தூபகரண்டியும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","சர்வாங்கதகனபலியாக ஒரு காளையும், ஒரு ஆட்டுக்கடாவும், ஒருவயதுடைய ஒரு ஆட்டுக்குட்டியும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","பாவநிவாரணபலியாக ஒரு வெள்ளாட்டுக்கடாவும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","சமாதானபலியாக இரண்டு மாடுகளும், ஐந்து ஆட்டுக்கடாக்களும், ஐந்து வெள்ளாட்டுக்கடாக்களும், ஒருவயதுடைய ஐந்து ஆட்டுக்குட்டிகளுமே; இது சூவாரின் மகனாகிய நெதனெயேலின் காணிக்கை. ");
INSERT INTO tam2017_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","மூன்றாம் நாளில் ஏலோனின் மகனாகிய எலியாப் என்னும் செபுலோன் சந்ததியாரின் பிரபு காணிக்கை செலுத்தினான். ");
INSERT INTO tam2017_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","அவனுடைய காணிக்கையாவது: போஜனபலியாகப் படைப்பதற்காக எண்ணெயிலே பிசைந்த மெல்லிய மாவினால் நிறைந்ததும், பரிசுத்த ஸ்தலத்தின் சேக்கல் கணக்காக நூற்றுமுப்பது சேக்கல் நிறையுள்ளதுமான ஒரு வெள்ளித்தட்டும், எழுபது சேக்கல் நிறையுள்ள ஒரு வெள்ளிப்பாத்திரமும் ஆகிய இந்த இரண்டும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","தூபவர்க்கம் நிறைந்த பத்துச்சேக்கல் நிறையுள்ள பொன்னினால் செய்த ஒரு தூபகரண்டியும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","சர்வாங்கதகனபலியாக ஒரு காளையும், ஒரு ஆட்டுக்கடாவும், ஒருவயதுடைய ஒரு ஆட்டுக்குட்டியும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","பாவநிவாரணபலியாக ஒரு வெள்ளாட்டுக்கடாவும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","சமாதானபலியாக இரண்டு மாடுகளும், ஐந்து ஆட்டுக்கடாக்களும், ஐந்து வெள்ளாட்டுக்கடாக்களும் ஒருவயதுடைய ஐந்து ஆட்டுக்குட்டிகளுமே; இது ஏலோனின் மகனாகிய எலியாபின் காணிக்கை. ");
INSERT INTO tam2017_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","நான்காம் நாளில் சேதேயூரின் மகனாகிய எலிசூர் என்னும் ரூபன் சந்ததியாரின் பிரபு காணிக்கை செலுத்தினான். ");
INSERT INTO tam2017_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","அவனுடைய காணிக்கையாவது: போஜனபலியாகப் படைப்பதற்காக எண்ணெயிலே பிசைந்த மெல்லிய மாவினால் நிறைந்ததும், பரிசுத்த ஸ்தலத்தின் சேக்கல் கணக்காக நூற்றுமுப்பது சேக்கல் நிறையுள்ளதுமான ஒரு வெள்ளித்தட்டும், எழுபது சேக்கல் நிறையுள்ள ஒரு வெள்ளிப்பாத்திரமும் ஆகிய இந்த இரண்டும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","தூபவர்க்கம் நிறைந்த பத்துச்சேக்கல் நிறையுள்ள பொன்னினால் செய்த ஒரு தூபகரண்டியும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","சர்வாங்கதகனபலியாக ஒரு காளையும், ஒரு ஆட்டுக்கடாவும், ஒருவயதுடைய ஒரு ஆட்டுக்குட்டியும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","பாவநிவாரணபலியாக ஒரு வெள்ளாட்டுக்கடாவும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","சமாதானபலியாக இரண்டு மாடுகளும், ஐந்து ஆட்டுக்காடாக்களும், ஐந்து வெள்ளாட்டுக்கடாக்களும், ஒருவயதுடைய ஐந்து ஆட்டுக்குட்டிகளுமே; இது சேதேயூரின் மகனாகிய எலிசூரின் காணிக்கை. ");
INSERT INTO tam2017_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","ஐந்தாம் நாளில் சூரிஷதாயின் மகனாகிய செலூமியேல் என்னும் சிமியோன் சந்ததியாரின் பிரபு காணிக்கை செலுத்தினான். ");
INSERT INTO tam2017_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","அவனுடைய காணிக்கையாவது: போஜனபலியாகப் படைக்கும்படியாக எண்ணெயிலே பிசைந்த மெல்லிய மாவினால் நிறைந்ததும், பரிசுத்த ஸ்தலத்தின் சேக்கல் கணக்காக நூற்றுமுப்பது சேக்கல் நிறையுள்ளதுமான ஒரு வெள்ளித்தட்டும், எழுபது சேக்கல் நிறையுள்ள ஒரு வெள்ளிகலமும் ஆகிய இந்த இரண்டும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","தூபவர்க்கம் நிறைந்த பத்துச்சேக்கல் நிறையுள்ள பொன்னினால் செய்த ஒரு தூபகரண்டியும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","சர்வாங்கதகனபலியாக ஒரு காளையும், ஒரு ஆட்டுக்கடாவும், ஒருவயதுடைய ஒரு ஆட்டுக்குட்டியும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","பாவநிவாரணபலியாக ஒரு வெள்ளாட்டுக்கடாவும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","சமாதானபலியாக இரண்டு மாடுகளும், ஐந்து ஆட்டுக்கடாக்களும், ஐந்து வெள்ளாட்டுக்கடாக்களும், ஒருவயதுடைய ஐந்து ஆட்டுக்குட்டிகளுமே; இது சூரிஷதாயின் மகனாகிய செலூமியேலின் காணிக்கை. ");
INSERT INTO tam2017_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ஆறாம் நாளிலே தேகுவேலின் மகனாகிய எலியாசாப் என்னும் காத் சந்ததியாரின் பிரபு காணிக்கை செலுத்தினான். ");
INSERT INTO tam2017_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","அவனுடைய காணிக்கையாவது: போஜனபலியாகப் படைக்கும்படியாக எண்ணெயிலே பிசைந்த மெல்லிய மாவினால் நிறைந்ததும், பரிசுத்த ஸ்தலத்தின் சேக்கல் கணக்காக நூற்றுமுப்பது சேக்கல் நிறையுள்ளதுமான ஒரு வெள்ளித்தட்டும், எழுபது சேக்கல் நிறையுள்ள ஒரு வெள்ளிப்பாத்திரமும் ஆகிய இந்த இரண்டும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","தூபவர்க்கம் நிறைந்த பத்துச்சேக்கல் நிறையுள்ள பொன்னினால் செய்த ஒரு தூபகரண்டியும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","சர்வாங்கதகனபலியாக ஒரு காளையும், ஒரு ஆட்டுக்கடாவும், ஒருவயதுடைய ஒரு ஆட்டுக்குட்டியும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","பாவநிவாரணபலியாக ஒரு வெள்ளாட்டுக்கடாவும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","சமாதானபலியாக இரண்டு மாடுகளும், ஐந்து ஆட்டுக்கடாக்களும், ஐந்து வெள்ளாட்டுக்கடாக்களும், ஒருவயதுடைய ஐந்து ஆட்டுக்குட்டிகளுமே; இது தேகுவேலின் மகனாகிய எலியாசாபின் காணிக்கை. ");
INSERT INTO tam2017_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","ஏழாம் நாளில் அம்மீயூதின் மகனாகிய எலிஷாமா என்னும் எப்பிராயீம் சந்ததியாரின் பிரபு காணிக்கை செலுத்தினான். ");
INSERT INTO tam2017_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","அவனுடைய காணிக்கையாவது: போஜனபலியாகப் படைக்கும்படியாக எண்ணெயிலே பிசைந்த மெல்லிய மாவினால் நிறைந்ததும், பரிசுத்த ஸ்தலத்தின் சேக்கல் கணக்காக நூற்றுமுப்பது சேக்கல் நிறையுள்ளதுமான ஒரு வெள்ளித்தட்டும், எழுபது சேக்கல் நிறையுள்ள ஒரு வெள்ளிப்பாத்திரமும் ஆகிய இந்த இரண்டும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","தூபவர்க்கம் நிறைந்த பத்துச்சேக்கல் நிறையுள்ள பொன்னினால் செய்த ஒரு தூபகரண்டியும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","சர்வாங்கதகனபலியாக ஒரு காளையும், ஒரு ஆட்டுக்கடாவும், ஒருவயதுடைய ஒரு ஆட்டுக்குட்டியும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","பாவநிவாரணபலியாக ஒரு வெள்ளாட்டுக்கடாவும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","சமாதானபலியாக இரண்டு மாடுகளும், ஐந்து ஆட்டுக்கடாக்களும், ஐந்து வெள்ளாட்டுக்கடாக்களும், ஒருவயதுடைய ஐந்து ஆட்டுக்குட்டிகளுமே; இது அம்மியூதின் மகனாகிய எலிஷாமாவின் காணிக்கை. ");
INSERT INTO tam2017_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","எட்டாம் நாளில் பெதாசூரின் மகனாகிய கமாலியேல் என்னும் மனாசே சந்ததியாரின் பிரபு காணிக்கை செலுத்தினான். ");
INSERT INTO tam2017_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","அவனுடைய காணிக்கையாவது: உணவுபலியாகப் படைக்கும்படியாக எண்ணெயிலே பிசைந்த மெல்லிய மாவினால் நிறைந்ததும், பரிசுத்த ஸ்தலத்தின் சேக்கல் கணக்காக நூற்றுமுப்பது சேக்கல் நிறையுள்ளதுமான ஒரு வெள்ளித்தட்டும், எழுபது சேக்கல் நிறையுள்ள ஒரு வெள்ளிப்பாத்திரமும் ஆகிய இந்த இரண்டும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","தூபவர்க்கம் நிறைந்த பத்துச்சேக்கல் நிறையுள்ள பொன்னினால் செய்த ஒரு தூபகரண்டியும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","சர்வாங்கதகனபலியாக ஒரு காளையும், ஒரு ஆட்டுக்கடாவும், ஒருவயதுடைய ஒரு ஆட்டுக்குட்டியும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","பாவநிவாரணபலியாக ஒரு வெள்ளாட்டுக்கடாவும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","சமாதானபலியாக இரண்டு மாடுகளும், ஐந்து ஆட்டுக்கடாக்களும், ஐந்து வெள்ளாட்டுக்கடாக்களும், ஒருவயதுடைய ஐந்து ஆட்டுக்குட்டிகளுமே; இது பெதாசூரின் மகனாகிய கமாலியேலின் காணிக்கை. ");
INSERT INTO tam2017_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","ஒன்பதாம் நாளில் கீதெயோனின் மகனாகிய அபீதான் என்னும் பென்யமீன் சந்ததியாரின் பிரபு காணிக்கை செலுத்தினான். ");
INSERT INTO tam2017_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","அவனுடைய காணிக்கையாவது: போஜனபலியாகப் படைக்கும்படியாக எண்ணெயிலே பிசைந்த மெல்லிய மாவினால் நிறைந்ததும், பரிசுத்த ஸ்தலத்தின் சேக்கல் கணக்காக நூற்றுமுப்பது சேக்கல் நிறையுள்ளதுமான ஒரு வெள்ளித்தட்டும், எழுபது சேக்கல் நிறையுள்ள ஒரு வெள்ளிப்பாத்திரமும் ஆகிய இந்த இரண்டும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","தூபவர்க்கம் நிறைந்த பத்துச்சேக்கல் நிறையுள்ள பொன்னினால் செய்த ஒரு தூபகரண்டியும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","சர்வாங்கதகனபலியாக ஒரு காளையும், ஒரு ஆட்டுக்கடாவும், ஒருவயதுடைய ஒரு ஆட்டுக்குட்டியும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","பாவநிவாரணபலியாக ஒரு வெள்ளாட்டுக்கடாவும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","சமாதானபலியாக இரண்டு மாடுகளும், ஐந்து ஆட்டுக்கடாக்களும், ஐந்து வெள்ளாட்டுக்கடாக்களும், ஒருவயதுடைய ஐந்து ஆட்டுக்குட்டிகளுமே; இது கீதெயோனின் மகனாகிய அபீதானின் காணிக்கை. ");
INSERT INTO tam2017_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","பத்தாம் நாளில் அம்மிஷதாயின் மகனாகிய அகியேசேர் என்னும் தாண் சந்ததியாரின் பிரபு காணிக்கை செலுத்தினான். ");
INSERT INTO tam2017_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","அவனுடைய காணிக்கையாவது: போஜனபலியாகப் படைக்கும்படியாக எண்ணெயிலே பிசைந்த மெல்லிய மாவினால் நிறைந்ததும், பரிசுத்த ஸ்தலத்தின் சேக்கல் கணக்காக நூற்றுமுப்பது சேக்கல் நிறையுள்ளதுமான ஒரு வெள்ளித்தட்டும், எழுபது சேக்கல் நிறையுள்ள ஒரு வெள்ளிப்பாத்திரமும் ஆகிய இந்த இரண்டும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","தூபவர்க்கம் நிறைந்த பத்துச்சேக்கல் நிறையுள்ள பொன்னினால் செய்த ஒரு தூபகரண்டியும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","சர்வாங்கதகனபலியாக ஒரு காளையும், ஒரு ஆட்டுக்கடாவும், ஒருவயதுடைய ஒரு ஆட்டுக்குட்டியும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","பாவநிவாரணபலியாக ஒரு வெள்ளாட்டுக்கடாவும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","சமாதானபலியாக இரண்டு மாடுகளும், ஐந்து ஆட்டுக்கடாக்களும், ஐந்து வெள்ளாட்டுக்கடாக்களும், ஒருவயதுடைய ஐந்து ஆட்டுக்குட்டிகளுமே; இது அம்மிஷதாயின் மகனாகிய அகியேசேரின் காணிக்கை. ");
INSERT INTO tam2017_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","பதினோராம் நாளில் ஓகிரானின் மகனாகிய பாகியேல் என்னும் ஆசேர் சந்ததியாரின் பிரபு காணிக்கை செலுத்தினான். ");
INSERT INTO tam2017_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","அவனுடைய காணிக்கையாவது: போஜனபலியாகப் படைக்கும்படியாக எண்ணெயிலே பிசைந்த மெல்லிய மாவினால் நிறைந்ததும், பரிசுத்த ஸ்தலத்தின் சேக்கல் கணக்காக நூற்றுமுப்பது சேக்கல் நிறையுள்ளதுமான ஒரு வெள்ளித்தட்டும், எழுபது சேக்கல் நிறையுள்ள ஒரு வெள்ளிப்பாத்திரமும் ஆகிய இந்த இரண்டும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","தூபவர்க்கம் நிறைந்த பத்துச்சேக்கல் நிறையுள்ள பொன்னினால் செய்த ஒரு தூபகரண்டியும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","சர்வாங்கதகனபலியாக ஒரு காளையும், ஒரு ஆட்டுக்கடாவும், ஒருவயதுடைய ஒரு ஆட்டுக்குட்டியும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","பாவநிவாரணபலியாக ஒரு வெள்ளாட்டுக்கடாவும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","சமாதானபலியாக இரண்டு மாடுகளும், ஐந்து ஆட்டுக்கடாக்களும், ஐந்து வெள்ளாட்டுக்கடாக்களும், ஒருவயதுடைய ஐந்து ஆட்டுக்குட்டிகளுமே; இது ஓகிரானின் மகனாகிய பாகியேலின் காணிக்கை. ");
INSERT INTO tam2017_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","பன்னிரண்டாம் நாளில் ஏனானின் மகனாகிய அகீரா என்னும் நப்தலி சந்ததியாரின் பிரபு காணிக்கை செலுத்தினான். ");
INSERT INTO tam2017_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","அவனுடைய காணிக்கையாவது: போஜனபலியாகப் படைக்கும்படியாக எண்ணெயிலே பிசைந்த மெல்லிய மாவினால் நிறைந்ததும், பரிசுத்த ஸ்தலத்தின் சேக்கல் கணக்காக நூற்றுமுப்பது சேக்கல் நிறையுள்ளதுமான ஒரு வெள்ளித்தட்டும், எழுபது சேக்கல் நிறையுள்ள ஒரு வெள்ளிப்பாத்திரமும் ஆகிய இந்த இரண்டும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","தூபவர்க்கம் நிறைந்த பத்துச்சேக்கல் நிறையுள்ள பொன்னினால் செய்த ஒரு தூபகரண்டியும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","சர்வாங்கதகனபலியாக ஒரு காளையும், ஒரு ஆட்டுக்கடாவும், ஒருவயதுடைய ஒரு ஆட்டுக்குட்டியும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","பாவநிவாரணபலியாக ஒரு வெள்ளாட்டுக்கடாவும், ");
INSERT INTO tam2017_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","சமாதானபலியாக இரண்டு மாடுகளும், ஐந்து ஆட்டுக்கடாக்களும், ஐந்து வெள்ளாட்டுக்கடாக்களும், ஒருவயதுடைய ஐந்து ஆட்டுக்குட்டிகளுமே; இது ஏனானின் மகனாகிய அகீராவின் காணிக்கை. ");
INSERT INTO tam2017_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","பலிபீடம் அபிஷேகம் செய்யப்பட்டபோது, இஸ்ரவேல் பிரபுக்களால் செய்யப்பட்ட பிரதிஷ்டையாவது: வெள்ளித்தாலங்கள் பன்னிரண்டு, வெள்ளிக்கலங்கள் பன்னிரண்டு, பொன் தூபகரண்டிகள் பன்னிரண்டு. ");
INSERT INTO tam2017_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ஒவ்வொரு வெள்ளித்தட்டு நூற்று முப்பது சேக்கல் நிறையும், ஒவ்வொரு கலம் எழுபது சேக்கல் நிறையுமாக, இந்தப் பாத்திரங்களின் வெள்ளியெல்லாம் பரிசுத்த ஸ்தலத்தின் சேக்கல் கணக்கின்படி இரண்டாயிரத்து நானூறு சேக்கல் நிறையாக இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","தூபவர்க்கம் நிறைந்த பொன் தூபகரண்டிகள் பன்னிரண்டு, ஒவ்வொன்று பரிசுத்த ஸ்தலத்தின் சேக்கல் கணக்கின்படி பத்துச்சேக்கல் நிறையாக, தூப கரண்டிகளின் பொன்னெல்லாம் நூற்றிருபது சேக்கல் நிறையாக இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","சர்வாங்கதகனபலியாகச் செலுத்தப்பட்ட காளைகளெல்லாம் பன்னிரண்டு, ஆட்டுக்கடாக்கள் பன்னிரண்டு, ஒருவயதுடைய ஆட்டுக்குட்டிகள் பன்னிரண்டு, அவைகளுக்குரிய போஜனபலிகளும் கூடச் செலுத்தப்பட்டது; பாவநிவாரணபலியாகச் செலுத்தப்பட்ட வெள்ளாட்டுக்கடாக்கள் பன்னிரண்டு. ");
INSERT INTO tam2017_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","சமாதானபலியாகச் செலுத்தப்பட்ட காளைகளெல்லாம் இருபத்துநான்கு; ஆட்டுக்கடாக்கள் அறுபது, வெள்ளாட்டுக் கடாக்கள் அறுபது; ஒருவயதுடைய ஆட்டுக்குட்டிகள் அறுபது; பலிபீடம் அபிஷேகம்செய்யப்பட்ட பின்பு செய்யப்பட்ட அதின் பிரதிஷ்டை இதுவே. ");
INSERT INTO tam2017_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","மோசே தேவனோடு பேசும்படி ஆசரிப்புக்கூடாரத்திற்குள் நுழையும்போது, தன்னோடே பேசுகிறவர்களின் சத்தம் சாட்சிப்பெட்டியின்மேலுள்ள கிருபாசனமான இரண்டு கேருபீன்களின் நடுவிலிருந்து உண்டாகக் கேட்பான்; அங்கே இருந்து அவனோடு பேசுவார். ");
INSERT INTO tam2017_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“நீ ஆரோனோடு சொல்லவேண்டியது என்னவென்றால்: நீ விளக்குகளை ஏற்றும்போது ஏழு விளக்குகளும் விளக்குத்தண்டிற்கு நேரே எரியவேண்டும் என்று சொல் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","யெகோவா மோசேக்குக் கட்டளையிட்ட பிரகாரம் ஆரோன் செய்து, விளக்குத்தண்டிற்கு நேரே ஒழுங்காக அதின் விளக்குகளை ஏற்றினான். ");
INSERT INTO tam2017_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","இந்தக் குத்துவிளக்கு, அதின் பாதமுதல் பூக்கள்வரைக்கும் தங்கத்தால் அடிப்பு வேலையாகச் செய்யப்பட்டிருந்தது; மோசேக்குக் காண்பித்த மாதிரியின்படியே அவன் குத்துவிளக்கை உண்டாக்கினான். ");
INSERT INTO tam2017_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“நீ இஸ்ரவேல் மக்களிலிருந்து லேவியர்களைப் பிரித்தெடுத்து, அவர்களைச் சுத்திகரிக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","அவர்களைச் சுத்திகரிக்கும்படி அவர்களுக்குச் செய்யவேண்டியதாவது: அவர்கள்மேல் சுத்திகரிக்கும் தண்ணீரைத் தெளிக்கவேண்டும்; பின்பு அவர்கள் உடல் முழவதும் சவரம்செய்து, தங்களுடைய ஆடைகளைத் துவைத்து, தங்களைச் சுத்திகரிக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","அப்பொழுது ஒரு காளையையும், அதற்கேற்ற எண்ணெயிலே பிசைந்த மெல்லியமாவாகிய போஜனபலியையும் கொண்டுவரவேண்டும்; பாவநிவாரணபலியாக வேறொரு காளையையும் நீ வாங்கி. ");
INSERT INTO tam2017_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","லேவியர்களை ஆசரிப்புக்கூடாரத்திற்கு முன்பு வரச்செய்து, இஸ்ரவேல் மக்களின் சபையார் எல்லோரையும் கூடிவரச்செய். ");
INSERT INTO tam2017_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","நீ லேவியர்களைக் யெகோவாவுடைய சந்நிதியில் வரச்செய்தபோது, இஸ்ரவேல் மக்கள் தங்களுடைய கைகளை லேவியர்கள்மேல் வைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","லேவியர்கள் யெகோவாவுக்குரிய பணிவிடை செய்யும்பொருட்டு, ஆரோன் அவர்களை இஸ்ரவேல் மக்களின் காணிக்கையாகக் யெகோவாவுக்கு முன்பாக அசைவாட்டப்படும் காணிக்கையாக நிறுத்தவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","அதன்பின்பு லேவியர்கள் தங்களுடைய கைகளைக் காளைகளுடைய தலையின்மேல் வைக்கவேண்டும்; பின்பு நீ லேவியர்களுக்காகப் பாவநிவிர்த்தி செய்வதற்காக, யெகோவாவுக்கு அவைகளில் ஒன்றைப் பாவநிவாரணபலியாகவும், மற்றொன்றைச் சர்வாங்கதகனபலியாகவும் செலுத்தி, ");
INSERT INTO tam2017_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","லேவியர்களை ஆரோனுக்கும் அவனுடைய மகனுக்கும் முன்பாக நிறுத்தி, அவர்களைக் யெகோவாவுக்கு அசைவாட்டப்படும் காணிக்கையாக்கி, ");
INSERT INTO tam2017_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","“இப்படி நீ லேவியர்களை இஸ்ரவேல் மக்களிலிருந்து பிரித்தெடுக்கவேண்டும்; லேவியர்கள் என்னுடையவர்களாக இருப்பார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","இப்படி அவர்களைச் சுத்திகரித்து, அவர்களை அசைவாட்டும் காணிக்கையாக்கவேண்டும்; அதன்பின்பு லேவியர்கள் ஆசரிப்புக்கூடாரத்தில் பணிவிடை செய்ய நுழையவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","இஸ்ரவேல் மக்களிலிருந்து அவர்கள் எனக்கு முற்றிலும் கொடுக்கப்பட்டிருக்கிறார்கள்; இஸ்ரவேல் மக்கள் எல்லாரிலும் கர்ப்பம்திறந்து பிறக்கிற எல்லா முதற்பேறுக்கும் பதிலாக அவர்களை எனக்கு எடுத்துக்கொண்டேன். ");
INSERT INTO tam2017_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","இஸ்ரவேல் மக்களில் மனிதர்களிலும் மிருகஜீவன்களிலும் முதற்பேறானதெல்லாம் என்னுடையது; நான் எகிப்துதேசத்திலே முதற்பேறான யாவையும் கொன்ற நாளிலே அவைகளை எனக்கென்று பரிசுத்தப்படுத்தி, ");
INSERT INTO tam2017_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","பின்பு லேவியர்களை இஸ்ரவேல் மக்களிலுள்ள முதற்பேறு சகலத்திற்கும் பதிலாக எடுத்துக்கொண்டு, ");
INSERT INTO tam2017_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","லேவியர்கள் இஸ்ரவேல் மக்களுடைய பணிவிடையை ஆசரிப்புக்கூடாரத்தில் செய்யும்படியும், இஸ்ரவேல் மக்களுக்காகப் பாவநிவிர்த்தி செய்யும்படியும், இஸ்ரவேல் மக்கள் தாங்களே பரிசுத்த ஸ்தலத்தில் சேருகிறதினால் இஸ்ரவேல் மக்களில் வாதை உண்டாகாதபடியும், லேவியர்களை அவர்களிலிருந்து எடுத்து, ஆரோனுக்கும் அவனுடைய மகன்களுக்கும் பரிசாகக் கொடுத்தேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","அப்பொழுது மோசேயும் ஆரோனும் இஸ்ரவேல் மக்களின் சபையார் யாவரும் யெகோவா லேவியர்களைக்குறித்து மோசேக்குக் கட்டளையிட்டபடியெல்லாம் லேவியர்களுக்குச் செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","லேவியர்கள் சுத்திகரிக்கப்பட்டு, தங்களுடைய ஆடைகளைத் துவைத்தார்கள்; பின்பு ஆரோன் அவர்களைக் யெகோவாவுக்கு முன்பாக அசைவாட்டும் காணிக்கையாக நிறுத்தி, அவர்களைச் சுத்திகரிக்க அவர்களுக்காகப் பாவநிவிர்த்தி செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","அதற்குப்பின்பு லேவியர்கள் ஆரோனுக்கும் அவனுடைய மகன்களுக்கும் முன்பாக ஆசரிப்புக்கூடாரத்தில் தங்களுடைய பணிவிடையைச் செய்யும்படி நுழைந்தார்கள்; யெகோவா லேவியர்களைக்குறித்து மோசேக்குக் கட்டளையிட்டபடியே அவர்களுக்குச் செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","லேவியர்களுக்குரிய கட்டளை என்னவென்றால்: “இருபத்தைந்து வயதுமுதல் அதற்கு மேற்பட்ட வயதுள்ள யாவரும் ஆசரிப்புக்கூடாரத்தின் பணிவிடையைச் செய்யும் கூட்டத்திற்கு சேவிக்க வரவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ஐம்பது வயதிற்கு மேற்பட்டவர்கள் வேலைசெய்யாமல் ஆசரிப்புக்கூடாரத்தின் பணிவிடை செய்யும் கூட்டத்தைவிட்டு, ");
INSERT INTO tam2017_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","ஆசரிப்புக்கூடாரத்தின் காவலைக்காக்கிறதற்குத் தங்களுடைய சகோதரர்களோடு ஊழியம் செய்வதைத் தவிர, வேறொரு வேலையும் செய்யவேண்டியதில்லை; இப்படி லேவியர்கள் செய்யவேண்டிய வேலைகளைக்குறித்துத் திட்டமிடவேண்டும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","அவர்கள் எகிப்துதேசத்திலிருந்து புறப்பட்ட இரண்டாம் வருடம் முதலாம் மாதத்தில் யெகோவா சீனாய் வனாந்திரத்தில் மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“குறித்த காலத்தில் இஸ்ரவேல் மக்கள் பஸ்காவை அனுசரிக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","இந்த மாதம் பதினான்காம்தேதி மாலை வேளையாகிய குறித்த காலத்தில் அதை அனுசரிக்கவேண்டும்; அதற்குரிய எல்லாக் கட்டளையின்படியேயும் முறைகளின்படியேயும் அதை அனுசரிக்கவேண்டும் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","அப்படியே பஸ்காவை அனுசரிக்கும்படி மோசே இஸ்ரவேல் மக்களுக்குக் கட்டளையிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","அதினால் முதலாம் மாதம் பதினான்காம் தேதி மாலைநேரமான வேளையில், சீனாய் வனாந்திரத்தில் பஸ்காவை ஆசரித்தார்கள்; யெகோவா மோசேக்குக் கட்டளையிட்டபடியெல்லாம் இஸ்ரவேல் மக்கள் செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","அந்நாளில் சிலர் மனித பிரேதத்தினால் தீட்டுப்பட்டபடியினால் பஸ்காவை அனுசரிக்கத்தகாதவர்களாக இருந்தார்கள்; அவர்கள் அந்நாளிலே மோசேக்கும் ஆரோனுக்கும் முன்பாக வந்து: ");
INSERT INTO tam2017_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","“நாங்கள் மனித பிரேதத்தினால் தீட்டுப்பட்டவர்கள்; குறித்த காலத்தில் இஸ்ரவேல் மக்களோடு யெகோவாவுக்குக் காணிக்கையைச் செலுத்தாதபடி, நாங்கள் விலக்கப்பட்டிருக்கவேண்டியது என்ன என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","மோசே அவர்களை நோக்கி: “பொறுங்கள்; யெகோவா உங்களைக்குறித்துக் கட்டளையிடுவது என்ன என்று கேட்பேன் என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“நீ இஸ்ரவேல் மக்களோடு சொல்லவேண்டியது என்னவென்றால்: உங்களிலோ உங்கள் சந்ததியாரிலோ ஒருவன் பிரேதத்தினால் தீட்டுப்பட்டாலும், பயணமாகத் தூரமாக போயிருந்தாலும், யெகோவாவுக்குப் பஸ்காவை அனுசரிக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","அவர்கள் அதை இரண்டாம் மாதம் பதினான்காம்தேதி மாலைநேரமான வேளையில் ஆசரித்து, அதைப் புளிப்பில்லாத அப்பங்களோடும் கசப்பான கீரைகளோடும் சாப்பிட்டு ");
INSERT INTO tam2017_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","அதிகாலைவரை அதில் ஒன்றும் மீதியாக வைக்காமலும், அதில் ஒரு எலும்பையும் முறிக்காமலும், பஸ்காவினுடைய எல்லா முறைகளின்படியும் அதை அனுசரிக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","ஒருவன் சுத்தமுள்ளவனுமாகப் பயணம் போகாதவனுமாக இருந்தும், பஸ்காவை அனுசரிக்காமல் போனால், அந்த ஆத்துமா குறித்த காலத்தில் யெகோவாவின் பலியைச் செலுத்தாதபடியால் தன்னுடைய மக்களில் இல்லாமல் அறுப்புண்டுபோவான்; அந்த மனிதன் தன்னுடைய பாவத்தைச் சுமப்பான். ");
INSERT INTO tam2017_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","ஒரு பரதேசி உங்களிடத்திலே தங்கி, யெகோவாவுக்குப் பஸ்காவை அனுசரிக்கவேண்டுமானால், அவன் அதைப் பஸ்காவின் கட்டளைப்படியும் அதின் முறையின்படியும் அனுசரிக்கவேண்டும்; பரதேசிக்கும் சுதேசிக்கும் ஒரே கட்டளை இருக்கவேண்டும் என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","வாசஸ்தலம் பிரதிஷ்டைசெய்யப்பட்ட நாளிலே, மேகமானது சாட்சியின் கூடாரமாகிய வாசஸ்தலத்தை மூடியது; சாயங்காலமானபோது, வாசஸ்தலத்தின்மேல் அக்கினிமயமான ஒரு தோற்றம் உண்டானது; அது அதிகாலைவரை இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","இப்படி எப்போதும் இருந்தது; பகலில் மேகமும், இரவில் அக்கினித்தோற்றமும் அதை மூடிக்கொண்டிருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","மேகம் கூடாரத்திலிருந்து மேலே எழும்பும்போது இஸ்ரவேல் மக்கள் பயணம்செய்வார்கள்; மேகம் தங்குமிடத்தில் இஸ்ரவேல் மக்கள் முகாமிடுவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","யெகோவாவுடைய கட்டளையின்படியே இஸ்ரவேல் மக்கள் புறப்படுவார்கள்; யெகோவாவுடைய கட்டளையின்படியே முகாமிடுவார்கள்; மேகம் வாசஸ்தலத்தின்மேல் தங்கியிருக்கும் நாட்களெல்லாம் அவர்கள் முகாமில் தங்கியிருப்பார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","மேகம் நெடுநாள் வாசஸ்தலத்தின்மேல் தங்கியிருக்கும்போது, இஸ்ரவேல் மக்கள் புறப்படாமல் யெகோவாவின் காவலைக் காத்துக்கொண்டிருப்பார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","மேகம் சிலநாட்கள் மட்டும் வாசஸ்தலத்தின்மேல் தங்கியிருக்கும்போது, யெகோவாவுடைய கட்டளையின்படியே முகாமிட்டு, யெகோவாவுடைய கட்டளையின்படியே புறப்படுவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","மேகம் மாலைதுவங்கி அதிகாலைவரை இருந்து, அதிகாலையில் உயர எழும்பும்போது, உடனே புறப்படுவார்கள்; பகலிலோ இரவிலோ மேகம் எழும்பும்போது புறப்படுவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","மேகமானது இரண்டு நாளாவது ஒரு மாதமாவது ஒரு வருடமாவது வாசஸ்தலத்தின்மேல் தங்கியிருக்கும்போது, இஸ்ரவேல் மக்கள் பயணம்செய்யாமல் முகாமிட்டிருப்பார்கள்; அது உயர எழும்பும்போதோ புறப்படுவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","யெகோவாவுடைய கட்டளையின்படியே முகாமிடுவார்கள்; யெகோவாவுடைய கட்டளையின்படியே பயணம் செய்வார்கள்; யெகோவா மோசேயைக்கொண்டு கட்டளையிடுகிறபடியே யெகோவாவுடைய காவலைக் காத்துக்கொள்வார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“சபையைக் கூடிவரவழைப்பதற்கும் முகாம்களைப் புறப்படச்செய்வதற்கும் உபயோகமாக இரண்டு வெள்ளி எக்காளங்களைச் செய்துகொள்; அவைகள் ஒரே வெள்ளித்தகட்டால் செய்யப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","அவைகளை ஊதும்போது, சபையார் எல்லோரும் ஆசரிப்புக்கூடாரத்தின் வாசலில் உன்னிடத்தில் கூடிவரவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","ஒன்றைமட்டும் ஊதினால் இஸ்ரவேலில் ஆயிரம்பேர்களுக்குத் தலைவர்களாகிய பிரபுக்கள் உன்னிடத்தில் கூடிவரவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","நீங்கள் அவைகளைப் பெருந்தொனியாக முழக்கும்போது, கிழக்கே இறங்கியிருக்கிற முகாம்கள் புறப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","அவைகளை நீங்கள் இரண்டாவது முறை பெருந்தொனியாய் முழக்கும்போது, தெற்கே இறங்கியிருக்கிற முகாம்கள் புறப்படவேண்டும்; அவர்களைப் புறப்படச்செய்வதற்கு பெருந்தொனியாக முழக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","சபையைக் கூட்டுகிறதற்கு நீங்கள் ஊதினால் போதும் பெருந்தொனியாக முழக்கவேண்டாம். ");
INSERT INTO tam2017_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","ஆரோனின் மகன்களாகிய ஆசாரியர்கள் எக்காளங்களை ஊதவேண்டும்; உங்களுடைய தலைமுறைதோறும் இது உங்களுக்கு நிரந்தர கட்டளையாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","உங்களுடைய தேசத்தில் உங்களைத் துன்பப்படுத்துகிற எதிரிக்கு விரோதமாக யுத்தத்திற்குப் போகும்போது, எக்காளங்களைப் பெருந்தொனியாக முழக்கவேண்டும்; அப்பொழுது உங்களுடைய தேவனாகிய யெகோவாவுடைய சமூகத்திலே நீங்கள் நினைவுகூரப்பட்டு, உங்கள் பகைஞருக்கு நீங்கலாகி இரட்சிக்கப்படுவீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","உங்களுடைய மகிழ்ச்சியின் நாட்களிலும், உங்களுடைய பண்டிகைகளிலும், மாதப்பிறப்புகளிலும், உங்களுடைய சர்வாங்கதகனபலிகளும் சமாதானபலிகளும் செலுத்தப்படும்போது எக்காளங்களை ஊதவேண்டும்; அப்பொழுது அவைகள் உங்களுடைய தேவனுடைய சமூகத்தில் உங்களுக்கு ஞாபகக்குறியாக இருக்கும்; நான் உங்களுடைய தேவனாகிய யெகோவா” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","இரண்டாம் வருடம் இரண்டாம் மாதம் இருபதாம் தேதியில் மேகம் சாட்சியினுடைய வாசஸ்தலத்தின் மீதிலிருந்து உயர எழும்பியது. ");
INSERT INTO tam2017_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","அப்பொழுது இஸ்ரவேல் மக்கள் சீனாய் வனாந்திரத்திலிருந்து தங்களுடைய பயண வரிசைகளின்படி புறப்பட்டார்கள்; மேகம் பாரான் வனாந்திரத்தில் தங்கிற்று. ");
INSERT INTO tam2017_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","இப்படியே யெகோவா மோசேயைக் கொண்டு கட்டளையிட்டபடி முதல் பயணம் செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","யூதா சந்ததியாருடைய முகாமின் கொடி அவர்களுடைய இராணுவங்களோடு முதல் புறப்பட்டது; அவனுடைய இராணுவத்திற்கு அம்மினதாபின் மகன் நகசோன் தலைவனாக இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","இசக்கார் சந்ததியாருடைய கோத்திரத்தின் இராணுவத்திற்குச் சூவாரின் மகன் நெதனெயேல் தலைவனாக இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","செபுலோன் சந்ததியாருடைய கோத்திரத்தின் இராணுவத்திற்கு ஏலோனின் மகன் எலியாப் தலைவனாக இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","அப்பொழுது வாசஸ்தலம் இறக்கி வைக்கப்பட்டது; அதைக் கெர்சோன் சந்ததியாரும் மெராரி சந்ததியாரும் சுமந்துகொண்டு புறப்பட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","அதற்குப்பின்பு ரூபன் சந்ததியாருடைய முகாமின் கொடி அவர்களுடைய இராணுவங்களோடு புறப்பட்டது; அவனுடைய இராணுவத்திற்குச் சேதேயூரின் மகன் எலிசூர் தலைவனாக இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","சிமியோன் சந்ததியாருடைய கோத்திரத்தின் இராணுவத்திற்குச் சூரிஷதாயின் மகன் செலூமியேல் தலைவனாக இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","காத் சந்ததியாருடைய கோத்திரத்தின் இராணுவத்திற்குத் தேகுவேலின் மகன் எலியாசாப் தலைவனாக இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","கோகாத்தியர் பரிசுத்தமானவைகளைச் சுமந்துகொண்டு புறப்பட்டார்கள்; இவர்கள் வந்து சேருமுன்பு மற்றவர்கள் வாசஸ்தலத்தை நிறுவுவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","அதற்குப்பின்பு, எப்பிராயீம் சந்ததியாருடைய முகாமின் கொடி அவர்களுடைய இராணுவங்களோடு புறப்பட்டது; அவனுடைய இராணுவத்திற்கு அம்மியூதின் மகன் எலிஷாமா தலைவனாக இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","மனாசே சந்ததியாருடைய கோத்திரத்தின் இராணுவத்திற்குப் பெதாசூரின் மகன் கமாலியேல் தலைவனாக இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","பென்யமீன் சந்ததியாருடைய கோத்திரத்தின் இராணுவத்திற்குக் கீதெயோனின் மகன் அபீதான் தலைவனாக இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","அதற்குப்பின்பு, தாண் சந்ததியாருடைய முகாமின் கொடி எல்லா முகாம்களுக்கும் பின்னாக அவர்களுடைய இராணுவங்களோடு புறப்பட்டது; அவனுடைய இராணுவத்திற்கு அம்மிஷதாயின் மகன் அகியேசேர் தலைவனாக இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","ஆசேர் சந்ததியாருடைய கோத்திரத்தின் இராணுவத்திற்கு ஓகிரானின் மகன் பாகியேல் தலைவனாக இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","நப்தலி சந்ததியாருடைய கோத்திரத்தின் இராணுவத்திற்கு ஏனானின் மகன் அகீரா தலைவனாக இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","இஸ்ரவேல் மக்கள் புறப்பட்டபோது, இந்த விதமாகத் தங்கள் தங்கள் இராணுவங்களின்படியே பயணம்செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","அப்பொழுது மோசே தன்னுடைய மாமனாகிய ரெகுவேல் என்னும் மீதியானனுடைய மகனான ஓபாவை நோக்கி: “உங்களுக்குத் தருவேன் என்று யெகோவா சொன்ன இடத்திற்கு நாங்கள் பயணமாகப் போகிறோம்; நீயும் எங்களோடு கூட வா, உனக்கு நன்மைசெய்வோம்; யெகோவா இஸ்ரவேலுக்கு நல்ல வாக்குத்தத்தம் செய்திருக்கிறார்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","அதற்கு அவன்: “நான் வரக்கூடாது; என்னுடைய தேசத்திற்கும் என்னுடைய இனத்தாரிடத்திற்கும் போகவேண்டும் என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","அப்பொழுது மோசே: “நீ எங்களை விட்டுப் போகவேண்டாம்; வனாந்திரத்திலே நாங்கள் முகாமிடும் இடங்களை நீ அறிந்திருக்கிறபடியால், எங்களுக்குக் கண்களைப்போல இருப்பாய். ");
INSERT INTO tam2017_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","நீ எங்களோடு வந்தால், யெகோவா எங்களுக்குச் செய்தருளும் நன்மையின்படியே உனக்கும் நன்மைசெய்வோம்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","அவர்கள் யெகோவாவுடைய மலையைவிட்டு, மூன்றுநாட்கள் பயணமாக போனார்கள்; மூன்றுநாட்கள் பயணத்திலும் யெகோவாவுடைய உடன்படிக்கைப் பெட்டி அவர்களுக்கு இளைப்பாறும் ஸ்தலத்தைத் தேடிக் காட்டும்படிக்கு அவர்கள் முன்பு சென்றது. ");
INSERT INTO tam2017_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","அவர்கள் முகாமிலிருந்து பயணமாக போகிறபோது, யெகோவாவுடைய மேகம் பகலில் அவர்கள்மேல் தங்கியிருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","உடன்படிக்கைப் பெட்டியானது புறப்படும்போது, மோசே: “யெகோவாவே, எழுந்தருளும், உம்முடைய எதிரிகள் சிதறடிக்கப்படுவார்களாக; உம்மைப் பகைக்கிறவர்கள் உமக்கு முன்பாக ஓடிப்போவார்களாக” என்பான். ");
INSERT INTO tam2017_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","அது தங்கும்போது: “யெகோவாவே, அநேக ஆயிரம்பேர்களாகிய இஸ்ரவேலர்களிடத்தில் திரும்புவீராக” என்று சொல்லுவான். ");
INSERT INTO tam2017_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","பின்பு, இஸ்ரவேல் மக்கள் முறையிட்டுக்கொண்டிருந்தார்கள்; அது யெகோவாவுடைய செவிகளில் தீமையாக இருந்தது; யெகோவா அதைக் கேட்டபோது, அவருடைய கோபம் மூண்டது; யெகோவாவுடைய அக்கினி அவர்களுக்குள்ளே பற்றியெரிந்து, முகாமின் கடைசியிலிருந்த சிலரை எரித்தது. ");
INSERT INTO tam2017_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","அப்பொழுது மக்கள் மோசேயை நோக்கிக் கூப்பிட்டார்கள்; மோசே யெகோவாவை நோக்கி விண்ணப்பம்செய்தான்; உடனே அக்கினி அணைந்துபோயிற்று. ");
INSERT INTO tam2017_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","யெகோவாவுடைய அக்கினி அவர்களுக்குள்ளே பற்றியெரிந்ததால், அந்த இடத்திற்குத் தபேரா என்று பெயரிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","பின்பு அவர்களுக்குள் இருந்த பல ஜாதியான அந்நிய மக்கள் மிகுந்த ஆசையுள்ளவர்களாக மாறினார்கள்; இஸ்ரவேல் மக்களும் திரும்ப அழுது, “நமக்கு இறைச்சியை சாப்பிடக்கொடுப்பவர் யார்? ");
INSERT INTO tam2017_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","நாம் எகிப்திலே விலையில்லாமல் சாப்பிட்ட மீன்களையும், வெள்ளரிக்காய்களையும், கொம்மட்டிக்காய்களையும், கீரைகளையும், வெங்காயங்களையும், வெள்ளைப்பூண்டுகளையும் நினைக்கிறோம். ");
INSERT INTO tam2017_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","இப்பொழுது நம்முடைய உள்ளம் வாடிப்போகிறது; இந்த மன்னாவைத் தவிர, நம்முடைய கண்களுக்கு முன்பாக வேறொன்றும் இல்லையே” என்று சொன்னார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","அந்த மன்னா கொத்துமல்லி விதையளவும், அதின் நிறம் முத்துப்போலவும் இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","மக்கள் போய் அதைப் பொறுக்கிக்கொண்டு வந்து, எந்திரங்களில் அரைத்தாவது உரல்களில் இடித்தாவது, பானைகளில் சமைப்பார்கள்; அதை அப்பங்களாகச் சுடுவார்கள்; அதின் ருசி புது ஒலிவ எண்ணெயின் ருசிபோலிருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","இரவிலே முகாமின்மேல் பனிபெய்யும்போது, மன்னாவும் அதின்மேல் விழும். ");
INSERT INTO tam2017_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","அந்தந்த வம்சங்களைச் சேர்ந்த மக்கள் தங்கள் தங்கள் கூடாரவாசலில் நின்று அழுகிறதை மோசே கேட்டான்; யெகோவாவுக்கு மிகவும் கோபம் மூண்டது; மோசேயின் பார்வைக்கும் அது தீமையாக இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","அப்பொழுது மோசே யெகோவாவை நோக்கி: நீர் இந்த மக்கள் எல்லோருடைய பாரத்தையும் என்மேல் சுமத்தினதால், உமது அடியானுக்கு உபத்திரவம் வரச்செய்தது ஏன்? உம்முடைய கண்களில் எனக்குக் கிருபை கிடைக்காமல் போனது ஏன்? ");
INSERT INTO tam2017_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","இவர்களுடைய முன்னோர்களுக்கு நான் ஆணையிட்டுக்கொடுத்த தேசத்திற்கு நீ இவர்களை பால்குடிக்கிற குழந்தையைத் தகப்பன் சுமந்துகொண்டுபோவதுபோல, உன்னுடைய மார்பிலே அணைத்துக்கொண்டுபோ என்று நீர் என்னோடு சொல்லும்படி இந்த மக்களையெல்லாம் கர்ப்பந்தரித்தேனோ? இவர்களைப் பெற்றது நானோ? ");
INSERT INTO tam2017_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","இந்த மக்கள் எல்லாருக்கும் கொடுக்கிறதற்கு எனக்கு இறைச்சி எங்கேயிருந்து வரும்? எனக்கு இறைச்சி கொடு என்று என்னைப் பார்த்து அழுகிறார்களே. ");
INSERT INTO tam2017_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","இந்த மக்கள் எல்லோரையும் நான் ஒருவனாகத் தாங்கமுடியாது; எனக்கு இது மிஞ்சின பாரமாக இருக்கிறது. ");
INSERT INTO tam2017_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","உம்முடைய கண்களிலே எனக்குக் கிருபை கிடைத்ததானால், இப்படி எனக்குச் செய்யாமல், என்னுடைய உபத்திரவத்தை நான் காணாதபடி இப்பொழுதே என்னைக் கொன்றுபோடும்” என்று வேண்டிக்கொண்டான். ");
INSERT INTO tam2017_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","அப்பொழுது யெகோவா மோசேயை நோக்கி: “இஸ்ரவேல் மக்களுக்கு மூப்பர்களும் தலைவருமானவர்கள் இன்னார் என்று நீ அறிந்திருக்கிறாயே, அந்த மூப்பரில் எழுபதுபேரைக் கூட்டி, அவர்களை ஆசரிப்புக்கூடாரத்தினிடத்தில் அங்கே உன்னோடு வந்து நிற்கும்படிசெய். ");
INSERT INTO tam2017_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","அப்பொழுது நான் இறங்கிவந்து, அங்கே உன்னோடு பேசி, நீ ஒருவன் மட்டும் மக்களின் பாரத்தைச் சுமக்காமல், உன்னோடு அவர்களும் அதைச் சுமப்பதற்காக உன்மேல் இருக்கிற ஆவியை அவர்கள்மேலும் வைப்பேன். ");
INSERT INTO tam2017_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","நீ மக்களை நோக்கி: நாளைக்காக உங்களைப் பரிசுத்தப்படுத்துங்கள்; நீங்கள் இறைச்சி சாப்பிடுவீர்கள்; எங்களுக்கு இறைச்சி சாப்பிடக் கொடுப்பவர் யார் என்றும், எகிப்திலே எங்களுக்குச் சௌக்கியமாக இருந்தது என்றும், யெகோவாவுடைய செவிகள் கேட்க அழுதீர்களே; ஆகையால், நீங்கள் சாப்பிடும்படி யெகோவா உங்களுக்கு இறைச்சி கொடுப்பார். ");
INSERT INTO tam2017_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","நீங்கள் ஒருநாள், இரண்டுநாட்கள், ஐந்துநாட்கள், பத்துநாட்கள், இருபதுநாட்கள் மட்டும் இல்லை, ");
INSERT INTO tam2017_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ஒரு மாதம்வரை சாப்பிடுவீர்கள்; அது உங்களுடைய மூக்கிலிருந்து புறப்பட்டு, உங்களுக்குத் தெவிட்டிப்போகும்வரை சாப்பிடுவீர்கள்; உங்களுக்குள்ளே இருக்கிற யெகோவாவை அசட்டைசெய்து, நாங்கள் ஏன் எகிப்திலிருந்து புறப்பட்டோம் என்று அவருக்கு முன்பாக அழுதீர்களே என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","அதற்கு மோசே: “என்னுடன் இருக்கிற காலாட்கள் ஆறுலட்சம்பேர்; ஒரு மாதம் முழுவதும் சாப்பிடும்படி அவர்களுக்கு இறைச்சி கொடுப்பேன் என்று சொன்னீரே. ");
INSERT INTO tam2017_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","ஆடுமாடுகளை அவர்களுக்காக அடித்தாலும் அவர்களுக்குப் போதுமா? சமுத்திரத்தின் மீன்களையெல்லாம் அவர்களுக்காகச் சேர்த்தாலும் அவர்களுக்குப் போதுமா” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","அதற்குக் யெகோவா மோசேயை நோக்கி: “யெகோவாவுடைய கை குறுகியிருக்கிறதோ? என் வார்த்தையின்படி நடக்குமோ நடவாதோ என்று. நீ இப்பொழுது காண்பாய்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","அப்பொழுது மோசே புறப்பட்டு, யெகோவாவுடைய வார்த்தைகளை மக்களுக்குச் சொல்லி, மக்களின் மூப்பர்களில் எழுபதுபேரைக் கூட்டி, கூடாரத்தைச் சுற்றிலும் அவர்களை நிறுத்தினான். ");
INSERT INTO tam2017_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","யெகோவா மேகத்தில் இறங்கி, அவனோடு பேசி, அவன் மேலிருந்த ஆவியை மூப்பர்களாகிய அந்த எழுபது பேர்மேலும் வைத்தார்; அந்த ஆவி அவர்கள்மேல் வந்து தங்கினவுடன் தீர்க்கதரிசனம் சொன்னார்கள்; சொல்லி, பின்பு ஓய்ந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","அப்பொழுது இரண்டு பேர் முகாமில் இருந்துவிட்டார்கள்; ஒருவன் பேர் எல்தாத், மற்றவன் பேர் மேதாத்; அவர்களும் பேர்வழியில் எழுதப்பட்டிருந்தும், கூடாரத்திற்குப் போகப் புறப்படாமலிருந்தார்கள்; அவர்கள்மேலும் ஆவி வந்து தங்கினதினால், முகாமில் தீர்க்கதரிசனம் சொன்னார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","ஒரு பிள்ளை ஓடிவந்து, எல்தாதும், மேதாதும் முகாமில் தீர்க்கதரிசனம் சொல்லுகிறார்கள் என்று மோசேக்கு அறிவித்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","உடனே மோசேயினிடத்திலுள்ள வாலிபர்களில் ஒருவனும் அவனுடைய ஊழியக்காரனும் நூனின் மகனுமாகிய யோசுவா மறுமொழியாக: “என்னுடைய ஆண்டவனாகிய மோசேயே, அவர்களைத் தடைசெய்யும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","அதற்கு மோசே: “நீ எனக்காக வைராக்கியம் காண்பிக்கிறாயோ? யெகோவாவுடைய மக்கள் எல்லோரும் தீர்க்கதரிசனம் சொல்லும்படி, யெகோவா தம்முடைய ஆவியை அவர்கள்மேல் இறங்கச்செய்தால் நலமாக இருக்குமே என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","பின்பு, மோசேயும் இஸ்ரவேலின் மூப்பர்களும் முகாமிலே வந்து சேர்ந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","அப்பொழுது யெகோவாவிடத்திலிருந்து புறப்பட்ட ஒரு காற்று சமுத்திரத்திலிருந்து காடைகளை அடித்துக்கொண்டுவந்து, முகாமிலும் முகாமைச் சுற்றிலும், இந்தப்பக்கம் ஒரு நாள் பயணம்வரை, அந்தப்பக்கம் ஒரு நாள் பயணம்வரை, தரையின்மேல் இரண்டு முழ உயரம் விழுந்துகிடக்கச் செய்தது. ");
INSERT INTO tam2017_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","அப்பொழுது மக்கள் எழும்பி, அன்று பகல்முழுவதும், இரவுமுழுவதும், மறுநாள் முழுவதும் காடைகளைச் சேர்த்தார்கள்; கொஞ்சமாகச் சேர்த்தவன் பத்து ஓமர் அளவு சேர்த்தான்; அவைகளை முகாமைச் சுற்றிலும் தங்களுக்காகக் குவித்து வைத்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","தங்களுடைய பற்கள் நடுவே இருக்கும் இறைச்சியை அவர்கள் மென்று சாப்பிடும்முன்னே யெகோவாவுடைய கோபம் மக்களுக்குள்ளே மூண்டது; யெகோவா மக்களை மகா பெரிய வாதையால் வாதித்தார். ");
INSERT INTO tam2017_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","ஆசைப்பட்ட மக்களை அங்கே அடக்கம்செய்ததால், அந்த இடத்திற்குக் கிப்ரோத் அத்தாவா என்று பெயரிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","பின்பு, மக்கள் கிப்ரோத் அத்தாவா என்னும் இடத்தை விட்டு, ஆஸரோத்திற்குப் பயணம்செய்து, ஆஸ்ரோத்திலே தங்கினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","எத்தியோப்பியா தேசத்து பெண்ணை மோசே திருமணம்செய்திருந்தபடியால், மிரியாமும் ஆரோனும் அவன் திருமணம்செய்த எத்தியோப்பியா தேசத்து பெண்ணினால் அவனுக்கு விரோதமாகப் பேசி: ");
INSERT INTO tam2017_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","“யெகோவா மோசேயைக்கொண்டுமட்டும் பேசினாரோ, எங்களைக்கொண்டும் அவர் பேசினதில்லையோ என்றார்கள். யெகோவா அதைக் கேட்டார். ");
INSERT INTO tam2017_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","மோசேயானவன் பூமியிலுள்ள சகல மனிதர்களிலும் மிகுந்த சாந்தகுணமுள்ளவனாக இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","உடனே யெகோவா மோசேயையும் ஆரோனையும் மிரியாமையும் நோக்கி: “நீங்கள் மூன்று பேரும் ஆசரிப்புக்கூடாரத்திற்குப் புறப்பட்டு வாருங்கள் என்றார்; மூன்றுபேரும் போனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","யெகோவா மேகத்தூணில் இறங்கி, கூடாரவாசலிலே நின்று, ஆரோனையும் மிரியாமையும் கூப்பிட்டார்; அவர்கள் இருவரும் போனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","அப்பொழுது அவர்: “என்னுடைய வார்த்தைகளைக் கேளுங்கள்; உங்களுக்குள்ளே ஒருவன் தீர்க்கதரிசியாக இருந்தால், யெகோவாவாகிய நான் தரிசனத்தில் என்னை அவனுக்கு வெளிப்படுத்தி, சொப்பனத்தில் அவனோடு பேசுவேன். ");
INSERT INTO tam2017_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","என்னுடைய தாசனாகிய மோசேயோ அப்படிப்பட்டவன் அல்ல, என்னுடைய வீட்டில் எங்கும் அவன் உண்மையுள்ளவன். ");
INSERT INTO tam2017_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","நான் அவனுடன் மறைபொருளாக அல்ல, முகமுகமாக பேசுகிறேன்; அவன் யெகோவாவின் சாயலைக் காண்கிறான்; இப்படியிருக்க, நீங்கள் என்னுடைய தாசனாகிய மோசேக்கு விரோதமாகப் பேச, உங்களுக்குப் பயமில்லாமல் போனது என்ன என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","யெகோவாவுடைய கோபம் அவர்கள்மேல் மூண்டது; அவர் போய்விட்டார். ");
INSERT INTO tam2017_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","மேகம் கூடாரத்தை விட்டு நீங்கிப்போயிற்று; மிரியாம் உறைந்த மழையின் வெண்மைபோன்ற தொழுநோயாளியானாள்; ஆரோன் மிரியாமைப் பார்த்தபோது, அவள் தொழுநோயாளியாக இருக்கக் கண்டான். ");
INSERT INTO tam2017_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","அப்பொழுது ஆரோன் மோசேயை நோக்கி: “ஆ, என்னுடைய ஆண்டவனே, நாங்கள் புத்தியீனமாகச் செய்த இந்தப் பாவத்தை எங்கள்மேல் சுமத்தாமலிரும். ");
INSERT INTO tam2017_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","தன் தாயின் கர்ப்பத்தில் பாதி மாம்சம் அழுகிச் செத்துவிழுந்த பிள்ளையைப்போல அவள் ஆகாமலிருப்பாளாக” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","அப்பொழுது மோசே யெகோவாவை நோக்கி: “என்னுடைய தேவனே. அவளைக் குணமாக்கும் என்று கெஞ்சினான். ");
INSERT INTO tam2017_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","யெகோவா மோசேயை நோக்கி: “அவளுடைய தகப்பன் அவளுடைய முகத்திலே காறித் துப்பினால், அவள் ஏழுநாட்கள் வெட்கப்படவேண்டாமோ, அதுபோலவே அவள் ஏழுநாள் முகாமிற்குப் புறம்பே விலக்கப்பட்டிருந்து, பின்பு சேர்த்துக்கொள்ளப்படவேண்டும் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","அப்படியே மிரியாம் ஏழு நாட்கள் முகாமிற்குப் புறம்பே விலக்கப்பட்டிருந்தாள்; மிரியாம் சேர்த்துக்கொள்ளப்படும்வரை மக்கள் பயணம் செய்யாமலிருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","பின்பு, மக்கள் ஆஸரோத்திலிருந்து புறப்பட்டு, பாரான் வனாந்திரத்திலே முகாமிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“நான் இஸ்ரவேல் மக்களுக்குக் கொடுக்கும் கானான்தேசத்தைச் சுற்றிப்பார்ப்பதற்கு நீ மனிதர்களை அனுப்பு; ஒவ்வொரு பிதாக்களின் கோத்திரத்திலும் ஒவ்வொரு பிரபுவாகிய மனிதனை அனுப்பவேண்டும் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","மோசே யெகோவாவுடைய வாக்கின்படியே அவர்களைப் பாரான் வனாந்திரத்திலிருந்து அனுப்பினான்; அந்த மனிதர்கள் யாவரும் இஸ்ரவேல் மக்களின் தலைவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","அவர்களுடைய பெயர்கள்: ரூபன் கோத்திரத்தில் சக்கூரின் மகன் சம்முவா. ");
INSERT INTO tam2017_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","சிமியோன் கோத்திரத்தில் ஓரியின் மகன் சாப்பாத். ");
INSERT INTO tam2017_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","யூதா கோத்திரத்தில் எப்புன்னேயின் மகன் காலேப். ");
INSERT INTO tam2017_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","இசக்கார் கோத்திரத்தில் யோசேப்பின் மகன் ஈகால். ");
INSERT INTO tam2017_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","எப்பிராயீம் கோத்திரத்தில் நூனின் மகன் ஓசேயா. ");
INSERT INTO tam2017_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","பென்யமீன் கோத்திரத்தில் ரப்பூவின் மகன் பல்த்தி. ");
INSERT INTO tam2017_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","செபுலோன் கோத்திரத்தில் சோதியின் மகன் காதியேல். ");
INSERT INTO tam2017_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","யோசேப்பின் கோத்திரத்தைச் சேர்ந்த மனாசே கோத்திரத்தில் சூசின் மகன் காதி. ");
INSERT INTO tam2017_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","தாண் கோத்திரத்தில் கெமல்லியின் மகன் அம்மியேல். ");
INSERT INTO tam2017_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","ஆசேர் கோத்திரத்தில் மிகாவேலின் மகன் சேத்தூர். ");
INSERT INTO tam2017_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","நப்தலி கோத்திரத்தில் ஒப்பேசியின் மகன் நாகபி. ");
INSERT INTO tam2017_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","காத் கோத்திரத்தில் மாகியின் மகன் கூவேல். ");
INSERT INTO tam2017_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","தேசத்தைச் சுற்றிப்பார்க்கும்படி மோசே அனுப்பின மனிதர்களின் பெயர்கள் இவைகளே: நூனின் மகனாகிய ஓசேயாவுக்கு யோசுவா என்று மோசே பெயரிட்டிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","அவர்களை மோசே கானான்தேசத்தைச் சுற்றிப்பார்க்கும்படி அனுப்பும்போது, அவர்களை நோக்கி: “நீங்கள் இப்படித் தெற்கே போய், மலையில் ஏறி, ");
INSERT INTO tam2017_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","தேசம் எப்படிப்பட்டது என்றும், அங்கே குடியிருக்கிற மக்கள் பலவான்களோ பலவீனர்களோ, கொஞ்சம்பேரோ அநேகம்பேரோ என்றும், ");
INSERT INTO tam2017_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","அவர்கள் குடியிருக்கிற தேசம் எப்படிப்பட்டது, அது நல்லதோ கெட்டதோ என்றும், அவர்கள் பட்டணங்கள் எப்படிப்பட்டது என்றும், அவர்கள் கூடாரங்களில் குடியிருக்கிறவர்களோ கோட்டைகளில் குடியிருக்கிறவர்களோ என்றும், ");
INSERT INTO tam2017_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","நிலம் எப்படிப்பட்டது அது வளமானதோ வளமில்லாததோ என்றும்; அதில் மரங்கள் உண்டோ இல்லையோ என்றும் பாருங்கள்; தைரியம்கொண்டிருந்து, தேசத்தின் கனிகளிலே சிலவற்றைக் கொண்டுவாருங்கள் என்றான். அக்காலம் திராட்சைச்செடி முதற்பழம் பழுக்கிற காலமாக இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","அவர்கள் போய், சீன் வனாந்திரம்துவங்கி, ஆமாத்திற்குப் போகிற வழியாகிய ரேகொப்வரை, தேசத்தைச் சுற்றிப்பார்த்து, ");
INSERT INTO tam2017_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","தெற்கேயும் சென்று, எபிரோன்வரை போனார்கள்; அங்கே ஏனாக்கின் மகன்களாகிய அகீமானும் சேசாயும் தல்மாயும் இருந்தார்கள். எபிரோன் எகிப்திலுள்ள சோவானுக்கு ஏழுவருடங்களுக்குமுன்னே கட்டப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","பின்பு, அவர்கள் எஸ்கோல் பள்ளத்தாக்குவரை போய், அங்கே ஒரே குலையுள்ள ஒரு திராட்சைக்கொடியை அறுத்தார்கள்; அதை ஒரு தடியிலே இரண்டு பேர் கட்டித் தூக்கிக்கொண்டு வந்தார்கள்; மாதுளம் பழங்களிலும் அத்திப்பழங்களிலும் சிலவற்றைக் கொண்டுவந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","இஸ்ரவேல் மக்கள் அங்கே அறுத்த திராட்சைக்குலையினால், அந்த இடம் எஸ்கோல்பள்ளத்தாக்கு எனப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","அவர்கள் தேசத்தைச் சுற்றிப் பார்த்து, நாற்பதுநாட்கள் சென்றபின்பு திரும்பினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","அவர்கள் பாரான் வனாந்திரத்தில் இருக்கிற காதேசுக்கு வந்து, மோசே ஆரோன் என்பவர்களிடத்திலும் இஸ்ரவேல் மக்களாகிய சபையார் எல்லோரிடத்திலும் சேர்ந்து, அவர்களுக்கும் சபையார் அனைவருக்கும் செய்தியை அறிவித்து, தேசத்தின் கனிகளை அவர்களுக்குக் காண்பித்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","அவர்கள் மோசேயை நோக்கி: “நீர் எங்களை அனுப்பின தேசத்திற்கு நாங்கள் போய் வந்தோம்; அது பாலும் தேனும் ஓடுகிற தேசந்தான்; இது அதினுடைய கனி. ");
INSERT INTO tam2017_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","ஆனாலும், அந்த தேசத்திலே குடியிருக்கிற மக்கள் பலவான்கள்; பட்டணங்கள் பாதுகாப்பானவைகளும் மிகவும் பெரியவைகளுமாக இருக்கிறது; அங்கே ஏனாக்கின் மகன்களையும் கண்டோம். ");
INSERT INTO tam2017_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","அமலேக்கியர்கள் தென்புறமான தேசத்தில் குடியிருக்கிறார்கள்; ஏத்தியர்களும், எபூசியர்களும், எமோரியர்களும் மலைநாட்டில் குடியிருக்கிறார்கள்; கானானியர்கள் மத்திய தரைக் கடல் அருகிலும் யோர்தானுக்கு அருகில் குடியிருக்கிறார்கள்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","அப்பொழுது காலேப் மோசேக்கு முன்பாக மக்களை அமர்த்தி: “நாம் உடனே போய் அதைச் சுதந்தரித்துக்கொள்ளுவோம்; நாம் அதை எளிதாக ஜெயித்துக்கொள்ளலாம்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","அவனோடுகூடப் போய்வந்த மனிதர்களோ: “நாம் போய் அந்த மக்களோடு எதிர்க்க நம்மாலே முடியாது; அவர்கள் நம்மைவிட பலவான்கள் என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","“நாங்கள் போய்ச் சுற்றிப் பார்த்து வந்த அந்த தேசம் தன்னுடைய குடிகளை தாங்களே உண்கிற தேசம்; நாங்கள் அதிலே கண்ட மக்கள் எல்லோரும் மிகவும் பெரிய ஆட்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","அங்கே இராட்சதப் பிறவியான ஏனாக்கின் மகன்களாகிய இராட்சதர்களையும் கண்டோம்; நாங்கள் எங்களுடைய பார்வைக்கு வெட்டுக்கிளிகளைப்போல் இருந்தோம், அவர்களுடைய பார்வைக்கும் அப்படியே இருந்தோம்” என்று சொல்லி, இப்படி இஸ்ரவேல் மக்களுக்குள்ளே தாங்கள் சுற்றிப்பார்த்து வந்த தேசத்தைக்குறித்து துர்ச்செய்தி பரம்பச்செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","அப்பொழுது சபையார் எல்லோரும் கூக்குரலிட்டுப் புலம்பினார்கள்; மக்கள் அன்று இரவுமுழுதும் அழுதுகொண்டிருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","இஸ்ரவேல் மக்கள் எல்லோரும் மோசேக்கும் ஆரோனுக்கும் விரோதமாக முறுமுறுத்தார்கள். சபையார் எல்லோரும் அவர்களை நோக்கி: “எகிப்துதேசத்திலே செத்துப்போனோமானால் நலமாக இருக்கும்; இந்த வனாந்திரத்திலே நாங்கள் செத்தாலும் நலம். ");
INSERT INTO tam2017_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","நாங்கள் பட்டயத்தால் மடியும்படியும், எங்களுடைய மனைவிகளும் பிள்ளைகளும் கொள்ளையாகும்படியும், யெகோவா எங்களை இந்த தேசத்திற்குக் கொண்டு வந்தது என்ன? எகிப்திற்குத் திரும்பிப் போகிறதே எங்களுக்கு உத்தமம் அல்லவோ” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","பின்பு அவர்கள்: “நாம் ஒரு தலைவனை ஏற்படுத்திக்கொண்டு எகிப்திற்குத் திரும்பிப்போவோம் வாருங்கள்” என்று ஒருவரோடொருவர் சொல்லிக்கொண்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","அப்பொழுது மோசேயும் ஆரோனும் இஸ்ரவேல் மக்களின் சபையாராகிய எல்லாக் கூட்டத்தாருக்கு முன்பாகவும் முகங்குப்புற விழுந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","தேசத்தைச் சுற்றிப்பார்த்தவர்களில் நூனின் மகனாகிய யோசுவாவும், எப்புன்னேயின் மகனாகிய காலேபும், தங்களுடைய ஆடைகளைக் கிழித்துக்கொண்டு, ");
INSERT INTO tam2017_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","இஸ்ரவேல் மக்களின் முழு சபையையும் நோக்கி: “நாங்கள் போய்ச் சுற்றிப்பார்த்து சோதித்த தேசம் மகா நல்ல தேசம். ");
INSERT INTO tam2017_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","யெகோவா நம்மேல் பிரியமாக இருந்தால், அந்தத் தேசத்திலே நம்மைக் கொண்டுபோய், நல்ல விளைச்சல் உள்ள செழிப்பான அந்தத் தேசத்தை நமக்குக் கொடுப்பார். ");
INSERT INTO tam2017_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","யெகோவாவுக்கு விரோதமாகமட்டும் கலகம்செய்யாமலிருங்கள்; அந்த தேசத்தின் மக்களுக்கு நீங்கள் பயப்படவேண்டியதில்லை; அவர்கள் நமக்கு இரையாவார்கள்; அவர்களைக் காத்த நிழல் அவர்களை விட்டு விலகிப்போனது; யெகோவா நம்மோடு இருக்கிறார்; அவர்களுக்குப் பயப்படவேண்டியதில்லை” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","அப்பொழுது அவர்கள்மேல் கல்லெறியவேண்டும் என்று சபையார் எல்லோரும் சொன்னார்கள்; உடனே யெகோவாவுடைய மகிமை ஆசரிப்புக்கூடாரத்தில் இஸ்ரவேல் மக்கள் எல்லோருக்கும் முன்பாகக் காணப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","யெகோவா மோசேயை நோக்கி: “எதுவரைக்கும் இந்த மக்கள் எனக்குக் கோபம் உண்டாக்குவார்கள்? தங்களுக்குள்ளே நான் காட்டின சகல அடையாளங்களையும் அவர்கள் கண்டும், எதுவரைக்கும் என்னை நம்பாமலிருப்பீர்கள்? ");
INSERT INTO tam2017_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","நான் அவர்களைக் கொள்ளைநோயினால் வாதித்து, கானானில் அவர்களுக்குரியதை வெளியே தள்ளி, அவர்களைவிட உன்னைப் பெரிதும் பலத்ததுமான தேசமாக்குவேன் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","மோசே யெகோவாவை நோக்கி: “எகிப்தியர்கள் இதைக் கேட்பார்கள், அவர்கள் நடுவிலிருந்து உம்முடைய வல்லமையினாலே இந்த மக்களைக் கொண்டுவந்தீரே. ");
INSERT INTO tam2017_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","யெகோவாவாகிய நீர் இந்த மக்களின் நடுவே இருக்கிறதையும், யெகோவாவாகிய நீர் முகமுகமாகத் தரிசனமாவதையும், உம்முடைய மேகம் இவர்கள்மேல் நிற்பதையும், பகலில் மேகத்தூணிலும், இரவில் அக்கினித்தூணிலும், நீர் இவர்களுக்கு முன்பு செல்லுகிறதையும் கேட்டிருக்கிறார்கள்; இந்த தேசத்தின் குடிகளுக்கும் சொல்லுவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","ஒரே மனிதனைக் கொல்லுகிறது போல இந்த மக்களையெல்லாம் நீர் கொன்று போட்டால், அப்பொழுது உம்முடைய புகழைக் கேட்டிருக்கும் புறஜாதியார்: ");
INSERT INTO tam2017_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","யெகோவா அந்த மக்களுக்குக் கொடுப்போம் என்று ஆணையிட்டிருந்த தேசத்திலே அவர்களைக் கொண்டுபோய்விடமுடியாமல் போனபடியால், அவர்களை வனாந்திரத்திலே கொன்றுபோட்டார் என்பார்களே. ");
INSERT INTO tam2017_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","ஆகையால் யெகோவா நீடிய சாந்தமும் மிகுந்த கிருபையுமுள்ளவர் என்றும், அக்கிரமத்தையும் மீறுதலையும் மன்னிக்கிறவர் என்றும், குற்றமுள்ளவர்களைக் குற்றமற்றவர்களாக விடாமல், பிதாக்கள் செய்த அக்கிரமத்தைப் பிள்ளைகளிடத்தில் மூன்றாம் நான்காம் தலைமுறைவரை விசாரிக்கிறவர் என்றும், நீர் சொல்லியிருக்கிறபடியே, ");
INSERT INTO tam2017_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","என்னுடைய ஆண்டவருடைய வல்லமை பெரிதாக விளங்குவதாக. ");
INSERT INTO tam2017_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","உமது கிருபையினுடைய மகத்துவத்தின்படியேயும், எகிப்தை விட்டதுமுதல் இந்நாள்வரைக்கும் இந்த மக்களுக்கு மன்னித்து வந்ததின்படியேயும், இந்த மக்களின் அக்கிரமத்தை மன்னித்தருளும் என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","அப்பொழுது யெகோவா: “உன்னுடைய வார்த்தையின்படியே மன்னித்தேன். ");
INSERT INTO tam2017_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","பூமியெல்லாம் யெகோவாவுடைய மகிமையினால் நிறைந்திருக்கும் என்று என்னுடைய ஜீவனைக்கொண்டு சொல்லுகிறேன். ");
INSERT INTO tam2017_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","என்னுடைய மகிமையையும், நான் எகிப்திலும் வனாந்திரத்திலும் செய்த என்னுடைய அடையாளங்களையும் கண்டிருந்தும், என்னுடைய சத்தத்தை கேட்காமல், இதோடு பத்துமுறை என்னைப் பரீட்சைபார்த்த மனிதர்களில் ஒருவரும், ");
INSERT INTO tam2017_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","அவர்களுடைய பிதாக்களுக்கு நான் ஆணையிட்டுக்கொடுத்த தேசத்தைக் காணமாட்டார்கள்; எனக்குக் கோபம் உண்டாக்கினவர்களில் ஒருவரும் அதைக் காணமாட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","என்னுடைய தாசனாகிய காலேப் வேறே ஆவியை உடையவனாக இருக்கிறபடியாலும், உத்தமமாக என்னைப் பின்பற்றி வந்தபடியாலும், அவன் போய் வந்த தேசத்திலே அவனைச் சேரும்படிச்செய்வேன்; அவனுடைய சந்ததியார் அதைச் சுதந்தரித்துக்கொள்ளுவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","அமலேக்கியர்களும் கானானியர்களும் பள்ளத்தாக்கிலே குடியிருக்கிறபடியால், நாளைக்கு நீங்கள் திரும்பி சிவந்த சமுத்திரத்திற்குப்போகிற வழியாக வனாந்திரத்திற்குப் பயணம்செய்யுங்கள்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","பின்னும் யெகோவா மோசேயையும் ஆரோனையும் நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“எனக்கு விரோதமாக முறுமுறுக்கிற இந்தப் பொல்லாத சபையாரை எதுவரைக்கும் பொறுப்பேன்? இஸ்ரவேல் மக்கள் எனக்கு விரோதமாக முறுமுறுக்கிறதைக் கேட்டேன். ");
INSERT INTO tam2017_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","நீ அவர்களோடு சொல்லவேண்டியது என்னவென்றால்: நீங்கள் என்னுடைய காதுகள் கேட்கச் சொன்னபடியே உங்களுக்குச் செய்வேன் என்பதை என்னுடைய ஜீவனைக்கொண்டு சொல்லுகிறேன் என்று யெகோவா உரைக்கிறார். ");
INSERT INTO tam2017_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","இந்த வனாந்திரத்தில் உங்களுடைய பிரேதங்கள் விழும்; உங்களில் இருபது வயது முதல் அதற்கு மேற்பட்டவர்களாக எண்ணப்பட்டு, உங்கள் தொகைக்கு உட்பட்டவர்களும் எனக்கு விரோதமாக முறுமுறுத்திருக்கிறவர்களுமாகிய அனைவரின் பிரேதங்களும் விழும். ");
INSERT INTO tam2017_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","எப்புன்னேயின் மகன் காலேபும், நூனின் மகன் யோசுவாவும் தவிர, மற்றவர்களாகிய நீங்கள் நான் உங்களைக் குடியேற்றுவேன் என்று ஆணையிட்டுக்கொடுத்த தேசத்தில் நுழைவதில்லை. ");
INSERT INTO tam2017_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","கொள்ளையாவார்கள் என்று நீங்கள் சொன்ன உங்களுடைய குழந்தைகளையோ நான் அதில் நுழையச் செய்வேன்; நீங்கள் அசட்டைசெய்த தேசத்தை அவர்கள் கண்டறிவார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","உங்களுடைய பிரேதங்களோ இந்த வனாந்திரத்திலே விழும். ");
INSERT INTO tam2017_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","அவைகள் வனாந்திரத்திலே விழுந்து தீரும்வரை, உங்களுடைய பிள்ளைகள் நாற்பது வருடங்கள் வனாந்திரத்திலே திரிந்து, நீங்கள் செய்த கலகங்களின் பலனைச் சுமப்பார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","நீங்கள் தேசத்தைச் சுற்றிப்பார்த்த நாற்பதுநாட்கள் இலக்கத்தின்படியே, ஒவ்வொரு நாள் ஒவ்வொரு வருடமாக, நீங்கள் நாற்பது வருடங்கள் உங்களுடைய அக்கிரமங்களைச் சுமந்து, என்னுடைய உடன்படிக்கைக்கு வந்த மாறுதலை உணருவீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","யெகோவாவாகிய நான் இதைச் சொன்னேன்; எனக்கு விரோதமாகக் கூட்டங்கூடின இந்தப் பொல்லாத சபையார் யாவருக்கும் இப்படியே செய்வேன்; இந்த வனாந்திரத்திலே அழிவார்கள், இங்கே சாவார்கள் என்று சொல் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","அந்தத் தேசத்தைச் சோதித்துப் பார்க்கும்படி மோசேயால் அனுப்பப்பட்டுத் திரும்பி, அந்தத் தேசத்தைக்குறித்துத் துர்ச்செய்தி கொண்டுவந்து, ");
INSERT INTO tam2017_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","சபையார் எல்லோரும் அவனுக்கு விரோதமாக முறுமுறுக்கும்படி அந்தத் துர்ச்செய்தியைச் சொன்னவர்களாகிய அந்த மனிதர்கள் யெகோவாவுடைய சந்நிதியில் வாதையினால் செத்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","தேசத்தைச் சுற்றிப் பார்க்கப்போன அந்த மனிதர்களில் நூனின் மகனாகிய யோசுவாவும், எப்புன்னேயின் மகனாகிய காலேபும் மட்டும் உயிரோடு இருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","மோசே இந்த வார்த்தைகளை இஸ்ரவேல் மக்கள் அனைவரோடும் சொன்னபோது, மக்கள் மிகவும் துக்கித்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","அதிகாலையில் அவர்கள் எழுந்து: “நாங்கள் பாவம்செய்தோம், யெகோவா வாக்குத்தத்தம்செய்த இடத்திற்கு நாங்கள் போவோம்” என்று சொல்லி மலையின் உச்சியில் ஏறத்துணிந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","மோசே அவர்களை நோக்கி: “நீங்கள் இப்படி யெகோவாவின் கட்டளையை மீறுகிறதென்ன? அது உங்களுக்கு வாய்க்காது. ");
INSERT INTO tam2017_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","நீங்கள் உங்களுடைய எதிரிகளுக்கு முன்பாக முறியடிக்கப்படாதபடிக்கு ஏறிப்போகாமலிருங்கள்; யெகோவா உங்களுடைய நடுவில் இருக்கமாட்டார். ");
INSERT INTO tam2017_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","அமலேக்கியர்களும் கானானியர்களும் அங்கே உங்களுக்கு முன்னே இருக்கிறார்கள்; பட்டயத்தினால் விழுவீர்கள்; நீங்கள் யெகோவா வை விட்டுப் பின்வாங்கினபடியால், யெகோவா உங்களோடு இருக்கமாட்டார்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","ஆனாலும் அவர்கள் மலையின் உச்சியில் ஏறத் துணிந்தார்கள்; யெகோவாவுடைய உடன்படிக்கையின் பெட்டியும் மோசேயும் முகாமை விட்டுப்போகவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","அப்பொழுது அமலேக்கியர்களும் கானானியர்களும் அந்த மலையிலே இருந்து இறங்கி வந்து, அவர்களை முறியடித்து, அவர்களை ஓர்மாவரை துரத்தினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“நீ இஸ்ரவேல் மக்களோடு சொல்லவேண்டியது என்னவென்றால்: நீங்கள் குடியிருக்கும்படி நான் உங்களுக்குக் கொடுக்கும் தேசத்தில் நீங்கள் போய்ச் சேர்ந்தபின்பு, ");
INSERT INTO tam2017_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","விசேஷித்த பொருத்தனையையோ, உற்சாக பலியையோ, உங்களுடைய பண்டிகைகளில் செலுத்தும் பலியையோ, யெகோவாவுக்கு மாடுகளிலாவது ஆடுகளிலாவது சர்வாங்கதகனபலியையாவது மற்ற ஏதாவது ஒரு பலியையாவது யெகோவாவுக்கு நறுமண வாசனையான தகனமாகப் பலியிடும்போது, ");
INSERT INTO tam2017_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","தன்னுடைய படைப்பைக் யெகோவாவுக்குச் செலுத்துகிறவன் சர்வாங்கதகனபலிக்காவது மற்றப் பலிக்காவது ஒரு ஆட்டுக்குட்டியுடனே, ஒரு மரக்காலிலே பத்தில் ஒரு பங்கும் காற்படி எண்ணெயிலே பிசைந்ததுமான மெல்லிய மாவின் போஜனபலியைச் செலுத்தவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","பானபலியாக காற்படி திராட்சைரசத்தையும் படைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","ஆட்டுக்கடாவாக இருந்ததென்றால், பத்தில் இரண்டு பங்கானதும், ஒரு படியில் மூன்றில் ஒரு பங்காகிய எண்ணெயிலே பிசைந்ததுமான மெல்லியமாவின் போஜனபலியையும், ");
INSERT INTO tam2017_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","பானபலியாக ஒரு படியில் மூன்றில் ஒரு பங்கு திராட்சைரசத்தையும் யெகோவாவுடைய நறுமண வாசனையான படைப்பாகப் படைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","நீ சர்வாங்கதகனபலிக்காவது, விசேஷித்த பொருத்தனைபலிக்காவது, சமாதானபலிக்காவது, ஒரு காளையைக் யெகோவாவுக்குச் செலுத்த ஆயத்தப்படுத்தும்போது, ");
INSERT INTO tam2017_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","அதனோடு பத்தில் மூன்றுபங்கானதும், அரைப்படி எண்ணெயிலே பிசைந்ததுமான மெல்லிய மாவின் போஜனபலியையும், ");
INSERT INTO tam2017_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","பானபலியாக அரைப்படி திராட்சைரசத்தையும், யெகோவாவுக்கு நறுமண வாசனையான தகனபலியாகப் படைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","“இந்தவிதமாகவே ஒவ்வொரு மாட்டுக்கும், ஆட்டுக்கடாவுக்கும், செம்மறியாட்டுக் குட்டிக்கும், வெள்ளாட்டுக் குட்டிக்கும் செய்து படைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","நீங்கள் படைக்கிறவைகளின் எண்ணிக்கைக்குத்தகுந்தபடி, ஒவ்வொன்றிற்காகவும் இந்த முறையில் செய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","சொந்ததேசத்தில் பிறந்தவர்கள் யாவரும் யெகோவாவுக்கு நறுமண வாசனையான தகனபலியைச் செலுத்தும்போது இந்த விதமாகவே செய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","“உங்களிடத்திலே தங்கியிருக்கிற அந்நியனாவது, உங்கள் நடுவிலே உங்களுடைய தலைமுறைதோறும் குடியிருக்கிறவனோ, யெகோவாவுக்கு நறுமண வாசனையான தகனபலி செலுத்தவேண்டுமானால், நீங்கள் செய்கிறபடியே அவனும் செய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","சபையாராகிய உங்களுக்கும் உங்களிடத்தில் தங்குகிற அந்நியனுக்கும் ஒரே பிரமாணம் இருக்கவேண்டும் என்பது உங்களுடைய தலைமுறைகளில் நிரந்தர கட்டளையாக இருக்கவேண்டும்; யெகோவாவுக்கு முன்பாக அந்நியனும் உங்களைப்போலவே இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","உங்களுக்கும் உங்களிடத்தில் தங்குகிற அந்நியனுக்கும் ஒரே பிரமாணமும் ஒரே கட்டளையும் இருக்கவேண்டும் என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","நீ இஸ்ரவேல் மக்களோடு சொல்லவேண்டியது என்னவென்றால்: “நான் உங்களை அழைத்துக்கொண்டுபோகிற தேசத்தில் நீங்கள் சேர்ந்து, ");
INSERT INTO tam2017_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","தேசத்தின் ஆகாரத்தை சாப்பிடும்போது, யெகோவாவுக்கு ஏறெடுத்துப் படைக்கும் காணிக்கையைச் செலுத்தவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","நீங்கள் பிசைந்த மாவினால் செய்த முதற்பலனாகிய அதிரசத்தை ஏறெடுத்துப் படைக்கவேண்டும்; போரடிக்கிற களத்தின் படைப்பை படைக்கிறதுபோல அதையும் ஏறெடுத்துப் படைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","இப்படி உங்களுடைய தலைமுறைதோறும் உங்களுடைய பிசைந்த மாவின் முதற்பலனிலே யெகோவாவுக்குப் படைப்பை ஏறெடுத்துப் படைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“யெகோவா மோசேயினிடத்தில் சொன்ன இந்தக் கற்பனைகள் எல்லாவற்றின்படியும், ");
INSERT INTO tam2017_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","யெகோவா மோசேயைக்கொண்டு கட்டளைகொடுத்த நாள்முதற்கொண்டு அவர் உங்களுக்கும் உங்களுடைய சந்ததிகளுக்கும் நியமித்த எல்லாவற்றின்படியேயும் நீங்கள் செய்யாமல், ");
INSERT INTO tam2017_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","அறியாமல் தவறி நடந்தாலும், சபையாருக்குத் தெரியாமல் யாதொரு தப்பிதம் செய்தாலும், சபையார் எல்லோரும் யெகோவாவுக்குச் சுகந்த வாசனையான தகனபலியாக ஒரு காளையையும், கட்டளையின்படி அதற்கேற்ற உணவுபலியையும், பானபலியையும், பாவநிவாரணபலியாக ஒரு வெள்ளாட்டுக்கடாவையும் செலுத்தவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","அதினால் ஆசாரியன் இஸ்ரவேல் மக்களின் சபையனைத்திற்காகவும் பாவநிவிர்த்தி செய்யவேண்டும்; அது அறியாமையினால் செய்யப்பட்டதாலும், அதற்காக அவர்கள் யெகோவாவுக்குத் தகனபலியையும் பாவநிவாரணபலியையும் யெகோவாவுடைய சந்நிதியில் கொண்டுவந்ததினாலும், அது அவர்களுக்கு மன்னிக்கப்படும். ");
INSERT INTO tam2017_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","அது அறியாமையினாலே மக்கள் யாவருக்கும் வந்தபடியால், அது இஸ்ரவேல் மக்களின் சபையனைத்திற்கும் அவர்களுக்குள்ளே தங்குகிற அந்நியனுக்கும் மன்னிக்கப்படும். ");
INSERT INTO tam2017_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ஒருவன் அறியாமையினால் பாவஞ்செய்தால், ஒருவயதுடைய வெள்ளாட்டைப் பாவநிவாரணபலியாகச் செலுத்தவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","அப்பொழுது அறியாமையினால் பாவம்செய்தவனுக்காக ஆசாரியன் பாவநிவிர்த்தி செய்யும்படி யெகோவாவுடைய சந்நிதியில் பாவநிவிர்த்தி செய்யவேண்டும்; அப்பொழுது அவனுக்கு மன்னிக்கப்படும். ");
INSERT INTO tam2017_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","இஸ்ரவேல் மக்களாகிய உங்களில் பிறந்தவனுக்கும் உங்களுக்குள்ளே தங்கும் அந்நியனுக்கும், அறியாமையினால் பாவம்செய்தவனுக்கும், ஒரே பிரமாணம் இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“அன்றியும் தேசத்திலே பிறந்தவர்களிலோ அந்நியர்களிலோ எவனாவது துணிகரமாக ஏதாவது ஒன்றைச்செய்தால், அவன் யெகோவாவை நிந்திக்கிறான்; அந்த ஆத்துமா தன்னுடைய மக்களில் இல்லாதபடி துண்டிக்கப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","அவன் யெகோவாவின் வார்த்தையை அசட்டைசெய்து, அவர் கற்பனையை மீறினபடியால், அந்த ஆத்துமா துண்டிக்கப்பட வேண்டும்; அவனுடைய அக்கிரமம் அவன்மேல் இருக்கும் என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","இஸ்ரவேல் மக்கள் வனாந்திரத்தில் இருக்கும்போது, ஓய்வுநாளில் விறகுகளைப் பொறுக்கிக்கொண்டிருந்த ஒரு மனிதனைக் கண்டுபிடித்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","விறகுகளைப் பொறுக்கின அந்த மனிதனைக் கண்டுபிடித்தவர்கள், அவனை மோசே ஆரோன் என்பவர்களிடத்திற்கும் சபையார் அனைவரிடத்திற்கும் கொண்டுவந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","அவனுக்குச் செய்யவேண்டியது இன்னதென்று சரியான தீர்ப்பு இல்லாதபடியால், அவனைக் காவலில் வைத்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","“யெகோவா மோசேயை நோக்கி: அந்த மனிதன் நிச்சயமாகக் கொலைசெய்யப்படவேண்டும்; சபையார் எல்லோரும் அவனை முகாமிற்குப் புறம்பே கல்லெறியவேண்டும் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","அப்பொழுது சபையார் எல்லோரும் யெகோவா மோசேக்குக் கட்டளையிட்டபடியே, அவனை முகாமிற்குப் புறம்பே கொண்டுபோய்க் கல்லெறிந்தார்கள்; அவன் செத்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“நீ இஸ்ரவேல் சந்ததியாரிடத்தில் பேசி, அவர்கள் தங்களுடைய தலைமுறைதோறும் தங்களுடைய ஆடைகளின் ஓரங்களிலே தொங்கல்களை உண்டாக்கி, ஓரத்தின் தொங்கலிலே இளநீல நாடாவைக் கட்டவேண்டும் என்று அவர்களுக்குச் சொல். ");
INSERT INTO tam2017_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","நீங்கள் பின்பற்றிச் சோரம்போகிற உங்களுடைய இருதயத்திற்கும் உங்களுடைய கண்களுக்கும் ஏற்க நடவாமல், அதைப் பார்த்து, யெகோவாவின் கற்பனைகளையெல்லாம் நினைத்து அவைகளின்படியே செய்யும்படி, அது உங்களுக்குத் தொங்கலாக இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","நீங்கள் என்னுடைய கற்பனைகளையெல்லாம் நினைத்து, அவைகளின்படியே செய்து, உங்களுடைய தேவனுக்குப் பரிசுத்தராக இருக்கும்படி அதைப் பார்க்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","நான் உங்களுக்கு தேவனாக இருக்கும்படி, உங்களை எகிப்துதேசத்திலிருந்து புறப்படச்செய்த உங்களுடைய தேவனாகிய யெகோவா; நானே உங்களுடைய தேவனாகிய யெகோவா என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","லேவிக்குப் பிறந்த கோகாத்தின் மகனாகிய இத்சேயாரின் மகன் கோராகு என்பவன் ரூபன் வம்சத்திலுள்ள எலியாபின் மகன்களாகிய தாத்தானையும் அபிராமையும் பேலேத்தின் மகனாகிய ஓனையும் கூட்டிக்கொண்டு, ");
INSERT INTO tam2017_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","இஸ்ரவேல் மக்களில் சபைக்குத் தலைவர்களும் சங்கத்திற்கு அழைக்கப்பட்டவர்களும் பிரபலமானவர்களுமாகிய 250 பேர்களோடும் கூட மோசேக்கு முன்பாக எழும்பி, ");
INSERT INTO tam2017_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","மோசேக்கும் ஆரோனுக்கும் விரோதமாகக் கூட்டம்கூடி, அவர்களை நோக்கி: “நீங்கள் மிஞ்சிப்போகிறீர்கள்; சபையார் எல்லோரும் பரிசுத்தமானவர்கள்; யெகோவா அவர்கள் நடுவில் இருக்கிறாரே; இப்படியிருக்க, யெகோவாவுடைய சபைக்கு மேலாக உங்களை ஏன் உயர்த்துகிறீர்கள்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","மோசே அதைக் கேட்டபோது, முகங்குப்புற விழுந்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","பின்பு அவன் கோராகையும் அவனுடைய எல்லாக் கூட்டத்தையும் நோக்கி: “நாளைக்குக் யெகோவா தம்முடையவன் இன்னான் என்றும், தம் அருகில் சேரத் தாம் கட்டளையிட்ட பரிசுத்தவான் இன்னான் என்றும் காண்பிப்பார்; அப்பொழுது எவனைத் தெரிந்துகொள்வாரோ, அவனைத் தம்மிடத்தில் சேரக் கட்டளையிடுவார். ");
INSERT INTO tam2017_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","ஒன்று செய்யுங்கள்; கோராகே, கோராகின் கூட்டத்தார்களே, நீங்கள் எல்லோரும் தூபகலசங்களை எடுத்துக்கொண்டு, ");
INSERT INTO tam2017_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","நாளைக்கு அவைகளில் அக்கினி போட்டு, யெகோவாவுடைய சந்நிதியில் தூபவர்க்கம் போடுங்கள்; அப்பொழுது யெகோவா எவனைத் தெரிந்துகொள்வாரோ, அவன் பரிசுத்தவானாக இருப்பான்; லேவியின் சந்ததியாராகிய நீங்களே மிஞ்சிப்போகிறீர்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","பின்னும் மோசே கோராகை நோக்கி: “லேவியின் சந்ததியாரே, கேளுங்கள்; ");
INSERT INTO tam2017_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","யெகோவாவுடைய வாசஸ்தலத்தின் பணிவிடைகளைச் செய்யவும், சபையாரின் முன்நின்று அவர்கள் செய்யவேண்டிய வேலைகளைச் செய்யவும், உங்களைத் தம் அருகில் சேரச்செய்யும்படி இஸ்ரவேலின் தேவன் இஸ்ரவேல் சபையாரிலிருந்து உங்களைப் பிரித்தெடுத்ததும், ");
INSERT INTO tam2017_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","அவர் உன்னையும் உன்னோடு லேவியின் சந்ததியாராகிய உன்னுடைய எல்லாச் சகோதரனையும் சேரச்செய்ததும், உங்களுக்கு அற்பகாரியமோ? இப்பொழுது ஆசாரியப்பட்டத்தையும் தேடுகிறீர்களோ? ");
INSERT INTO tam2017_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","இதற்காக நீயும் உன்னுடைய கூட்டத்தார் அனைவரும் யெகோவாவுடைய விரோதமாகவே கூட்டம்கூடினீர்கள்; ஆரோனுக்கு விரோதமாக நீங்கள் முறுமுறுக்கிறதற்கு அவன் யார்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","பின்பு மோசே எலியாபின் மகன்களாகிய தாத்தானையும் அபிராமையும் அழைத்தனுப்பினான். அவர்கள்: “நாங்கள் வருகிறதில்லை; ");
INSERT INTO tam2017_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","இந்த வனாந்திரத்தில் எங்களைக் கொன்றுபோடும்படி, நல்ல விளைச்சல் உள்ள செழிப்பான தேசத்திலிருந்து எங்களைக் கொண்டு வந்தது அற்பகாரியமோ, எங்கள்மேல் அதிகாரமும் செய்யப்பார்கிறாயோ? ");
INSERT INTO tam2017_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","மேலும் நீ எங்களைப் நல்ல விளைச்சல் உள்ள செழிப்பான தேசத்திற்குக் கொண்டுவந்ததும் இல்லை, எங்களுக்கு வயல்களையும் திராட்சைத்தோட்டங்களையும் சுதந்தரமாகக் கொடுத்ததும் இல்லை; இந்த மனிதர்களுடைய கண்களைப் பிடுங்கப்பார்க்கிறாயோ? நாங்கள் வருகிறதில்லை” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","அப்பொழுது மோசேக்குக் கடுங்கோபம் மூண்டது; அவன் யெகோவாவை நோக்கி: “அவர்கள் செலுத்தும் காணிக்கையை அங்கீகரியாமல் இருப்பீராக; நான் அவர்களிடம் ஒரு கழுதையைக் கூட எடுத்துக்கொள்ளவில்லை; அவர்களில் ஒருவனுக்கும் யாதொரு தீங்கு செய்யவும் இல்லை” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","பின்பு மோசே கோராகை நோக்கி: “நீயும் உன்னுடைய கூட்டத்தார் யாவரும் நாளைக்குக் யெகோவாவுடைய சந்நிதியில் வாருங்கள்; நீயும் அவர்களும் ஆரோனும் வந்திருங்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","உங்களில் ஒவ்வொருவரும் தங்கள் தங்கள் தூபகலசங்களை எடுத்து, அவைகளில் தூபவர்க்கத்தைப் போட்டு, தங்கள் தங்கள் தூபகலசங்களாகிய 250 தூபகலசங்களையும் யெகோவாவுடைய சந்நிதியில் கொண்டுவரவேண்டும்; நீயும் ஆரோனும் தன் தன் தூபகலசத்தைக் கொண்டுவாருங்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","அப்படியே அவரவர் தங்கள் தங்கள் தூபகலசங்களை எடுத்து, அவைகளில் அக்கினியையும் தூபவர்க்கத்தையும் போட்டு, ஆசரிப்புக்கூடாரத்தின் வாசலுக்கு முன்பாக வந்து நின்றார்கள்; மோசேயும் ஆரோனும் அங்கே நின்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","அவர்களுக்கு விரோதமாகக் கோராகு சபையையெல்லாம் ஆசரிப்புக்கூடாரத்தின் வாசலுக்கு முன்பாகக் கூடிவரும்படி செய்தான்; அப்பொழுது யெகோவாவுடைய மகிமை சபைக்கெல்லாம் காணப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","யெகோவா மோசேயோடும் ஆரோனோடும் பேசி: ");
INSERT INTO tam2017_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“இந்தச் சபையை விட்டுப் பிரிந்து போங்கள்; ஒரு நிமிடத்திலே அவர்களை அழித்துப்போடுவேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","அப்பொழுது அவர்கள் முகங்குப்புற விழுந்து: “தேவனே, மாம்சமான யாவருடைய ஆவிகளுக்கும் தேவனே, ஒரு மனிதன் பாவம் செய்திருக்கச் சபையார் எல்லார்மேலும் கடுங்கோபம்கொள்வீரோ” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","அப்பொழுது யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“கோராகு தாத்தான் அபிராம் என்பவர்களுடைய இடத்தை விட்டு விலகிப்போங்கள் என்று சபையாருக்குச் சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","உடனே மோசே எழுந்திருந்து, தாத்தான் அபிராம் என்பவர்களிடம் போனான்; இஸ்ரவேலின் மூப்பர்களும் அவனைப் பின்சென்று போனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","அவன் சபையாரை நோக்கி: “இந்தப் பொல்லாத மனிதர்களின் எல்லா பாவங்களிலும் நீங்கள் வாரிக்கொள்ளப்படாதபடி, அவர்கள் கூடாரங்களை விட்டு விலகி, அவர்களுக்கு உண்டானவைகளில் ஒன்றையும் தொடாமலிருங்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","அப்படியே அவர்கள் கோராகு தாத்தான் அபிராம் என்பவர்களுடைய இடத்தைவிட்டு விலகிப்போனார்கள்; தாத்தானும் அபிராமும் வெளியே வந்து, தங்களுடைய மனைவிகள் பிள்ளைகள் குழந்தைகளோடும் தங்களுடைய கூடாரவாசலிலே நின்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","அப்பொழுது மோசே: “இந்தக் கிரியைகளையெல்லாம் செய்கிறதற்குக் யெகோவா என்னை அனுப்பினார் என்றும், அவைகளை நான் என்னுடைய மனதின்படியே செய்யவில்லை என்றும், நீங்கள் எதினாலே அறிவீர்களென்றால், ");
INSERT INTO tam2017_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","எல்லா மனிதர்களும் சாகிறபடி இவர்கள் செத்து, எல்லா மனிதர்களுக்கும் நேரிடுகிறதுபோல இவர்களுக்கும் நேரிட்டால், யெகோவா என்னை அனுப்பவில்லை என்று அறிவீர்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","யெகோவா ஒரு புதிய காரியத்தை நேரிடச்செய்வதால், பூமி தன்னுடைய வாயைத்திறந்து, இவர்கள் உயிரோடு பாதாளத்தில் இறங்கும்படியாக இவர்களையும் இவர்களுக்கு உண்டான யாவையும் விழுங்கிப் போட்டதென்றால், இந்த மனிதர்கள் யெகோவாவை அவமதித்தார்கள் என்பதை அறிந்துகொள்வீர்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","அவன் இந்த வார்த்தைகளையெல்லாம் சொல்லி முடித்தவுடனே, அவர்கள் நின்றிருந்த நிலம் பிளந்தது; ");
INSERT INTO tam2017_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","பூமி தன்னுடைய வாயைத் திறந்து, அவர்களையும் அவர்களுடைய வீடுகளையும், கோராகுக்குரிய எல்லா மனிதர்களையும், அவர்களுக்கு உண்டான எல்லா பொருள்களையும் விழுங்கியது. ");
INSERT INTO tam2017_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","அவர்கள் தங்களுக்கு உண்டானவை எல்லாவற்றோடும் உயிரோடு பாதாளத்தில் இறங்கினார்கள்; பூமி அவர்களை மூடிக்கொண்டது; இப்படிச் சபையின் நடுவிலிருந்து அழிந்துபோனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","அவர்களைச் சுற்றிலும் இருந்த இஸ்ரவேலர்கள் யாவரும் அவர்கள் கூக்குரலைக்கேட்டு, பூமி நம்மையும் விழுங்கிப்போடும்” என்று சொல்லி ஓடினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","அக்கினி யெகோவாவுடைய சந்நிதியிலிருந்து புறப்பட்டு, தூபங்காட்டின 250 பேரையும் பட்சித்துப் போட்டது. ");
INSERT INTO tam2017_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","பின்பு யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“நெருப்பிற்குள் அகப்பட்ட தூபகலசங்களை எடுத்து, அவைகளிலிருக்கிற அக்கினியை அப்பாலே கொட்டிப்போடும்படி ஆசாரியனாகிய ஆரோனின் மகன் எலெயாசாருக்குச் சொல்; அந்தத் தூபகலசங்கள் பரிசுத்தமானது. ");
INSERT INTO tam2017_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","தங்களுடைய ஆத்துமாக்களுக்கே கேடு உண்டாக்கின அந்தப் பாவிகளின் தூபகலசங்களைப் பலிபீடத்தை மூடும் தட்டையான தகடுகளாக அடிக்கவேண்டும்; அவர்கள் யெகோவாவுடைய சந்நிதியில் அவைகளைக் கொண்டுவந்ததால் அவைகள் பரிசுத்தமானது; அவைகள் இஸ்ரவேல் மக்களுக்கு ஒரு அடையாளமாக இருக்கும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","அப்படியே ஆசாரியனாகிய எலெயாசார் சுட்டெரிக்கப்பட்டவர்கள் கொண்டுவந்திருந்த வெண்கலத் தூபகலசங்களை எடுத்து, ");
INSERT INTO tam2017_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","ஆரோனின் சந்ததியாக இல்லாத அந்நியன் ஒருவனும் யெகோவாவுடைய சந்நிதியில் தூபங்காட்ட வராதபடியும், கோராகைப்போலவும் அவனுடைய கூட்டத்தாரைப்போலவும் இல்லாதபடியும், இஸ்ரவேல் மக்களுக்கு நினைவுப்பொருளாக இருக்கும்படியாக, யெகோவா மோசேயைக்கொண்டு தனக்குச் சொன்னபடியே அவைகளைப் பலிபீடத்தை மூடும் தகடுகளாக அடிப்பித்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","மறுநாளில் இஸ்ரவேல் மக்களின் சபையார் எல்லோரும் மோசேக்கும் ஆரோனுக்கும் விரோதமாக முறுமுறுத்து: “நீங்கள் யெகோவாவின் மக்களைக் கொன்று போட்டீர்கள்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","சபையார் மோசேக்கும் ஆரோனுக்கும் விரோதமாகக் கூடி ஆசரிப்புக் கூடாரத்திற்கு நேரே பார்க்கிறபோது, மேகம் அதை மூடினது, யெகோவாவின் மகிமை காணப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","மோசேயும் ஆரோனும் ஆசரிப்புக் கூடாரத்திற்கு முன்பாக வந்தார்கள்; ");
INSERT INTO tam2017_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","அப்பொழுது யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“இந்தச் சபையாரை விட்டு விலகிப்போங்கள்; ஒரு நிமிடத்தில் அவர்களை அழிப்பேன் என்றார். அவர்கள் முகங்குப்புற விழுந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","மோசே ஆரோனை நோக்கி: “நீ தூபகலசத்தை எடுத்து, பலிபீடத்திலிருக்கிற அக்கினியை அதில் போட்டு, அதின்மேல் தூபவர்க்கம் இட்டு, சீக்கிரமாகச் சபையினிடத்தில் போய், அவர்களுக்காகப் பாவநிவிர்த்தி செய்”; யெகோவாவுடைய சந்நிதியிலிருந்து கடுங்கோபம் புறப்பட்டது. வாதை துவங்கியது என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","மோசே சொன்னபடி ஆரோன் அதை எடுத்துக்கொண்டு சபையின் நடுவில் ஓடினான்; மக்களுக்குள்ளே வாதை துவங்கியிருந்தது; அவன் தூபவர்க்கம் போட்டு, மக்களுக்காகப் பாவநிவிர்த்தி செய்து, ");
INSERT INTO tam2017_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","செத்தவர்களுக்கும் உயிரோடிருக்கிறவர்களுக்கும் நடுவே நின்றான்; அப்பொழுது வாதை நிறுத்தப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","கோராகின் காரியத்தினால் செத்தவர்கள் தவிர, அந்த வாதையினால் செத்துப்போனவர்கள் 14,700 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","வாதை நிறுத்தப்பட்டது; அப்பொழுது ஆரோன் ஆசரிப்புக்கூடாரத்தின் வாசலுக்கு மோசேயினிடம் திரும்பிவந்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","பின்பு யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“நீ இஸ்ரவேல் மக்களோடு பேசி, அவர்களுடைய பிதாக்களின் வம்சங்களாகிய ஒவ்வொரு வம்சத்தினுடைய பிரபுவினிடத்தில், ஒவ்வொரு கோலாகப் பன்னிரண்டு கோலை வாங்கி, அவனவன் கோலில் அவனவன் பெயரை எழுது. ");
INSERT INTO tam2017_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","லேவியினுடைய கோலின்மேல் ஆரோனின் பெயரை எழுதவேண்டும்; அவர்களுடைய பிதாக்களின் ஒவ்வொரு வம்சத்தலைவனுக்காகவும் ஒவ்வொரு கோல் இருக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","அவைகளை ஆசரிப்புக் கூடாரத்திலே நான் உங்களைச் சந்திக்கும் இடமாகிய சாட்சிப்பெட்டிக்கு முன்னே வைக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","அப்பொழுது நான் தெரிந்துகொள்ளுகிறவனுடைய கோல் துளிர்க்கும்; இப்படி இஸ்ரவேல் மக்கள் உங்களுக்கு விரோதமாக முறுமுறுக்கிற அவர்கள் முறுமுறுப்பை என்னைவிட்டு ஒழியச்செய்வேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","இதை மோசே இஸ்ரவேல் மக்களோடு சொன்னான்; அப்பொழுது அவர்களுடைய பிரபுக்கள் எல்லோரும் தங்கள் பிதாக்களுடைய வம்சத்தின்படி ஒவ்வொரு பிரபுவுக்கு ஒவ்வொரு கோலாகப் பன்னிரண்டு கோல்களை அவனிடத்தில் கொடுத்தார்கள்; ஆரோனின் கோலும் அவர்களுடைய கோல்களுடனே இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","அந்தக் கோல்களை மோசே சாட்சியின் கூடாரத்திலே யெகோவாவுடைய சமுகத்தில் வைத்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","மறுநாள் மோசே சாட்சியின் கூடாரத்திற்குள் நுழைந்தபோது, இதோ, லேவியின் குடும்பத்தாருக்கு இருந்த ஆரோனின் கோல் துளிர்த்திருந்தது; அது துளிர்விட்டு, பூப்பூத்து, வாதுமைப் பழங்களைக் கொடுத்தது. ");
INSERT INTO tam2017_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","அப்பொழுது மோசே யெகோவாவுடைய சமுகத்திலிருந்த அந்தக் கோல்களையெல்லாம் எடுத்து, இஸ்ரவேல் மக்கள் எல்லோரும் காண வெளியே கொண்டுவந்தான்; அவர்கள் கண்டு, அவரவர் தங்கள் தங்கள் கோல்களை வாங்கிக்கொண்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","அப்பொழுது யெகோவா மோசேயை நோக்கி: “ஆரோனின் கோல் அந்தக் கலகக்காரர்களுக்கு விரோதமான அடையாளமாவதற்காக, அதைத் திரும்பவும் சாட்சிப்பெட்டிக்கு முன்னே கொண்டு போய் வை; இப்படி அவர்கள் எனக்கு விரோதமாக முறுமுறுப்பதை ஒழியச்செய்வாய், அப்பொழுது அவர்கள் சாகமாட்டார்கள்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","யெகோவா தனக்குக் கட்டளையிட்டபடியே மோசே செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","அப்பொழுது இஸ்ரவேல் புத்திரர் மோசேயை நோக்கி: “இதோ, செத்து அழிந்துபோகிறோம்; நாங்கள் எல்லோரும் அழிந்துபோகிறோம். ");
INSERT INTO tam2017_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","யெகோவாவின் வாசஸ்தலத்தின் அருகில் வருகிற எவனும் சாகிறான்; நாங்கள் எல்லோரும் சாகத்தான் வேண்டுமோ” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","பின்பு யெகோவா ஆரோனை நோக்கி: “நீயும் உன்னுடன் உன்னுடைய மகன்களும் உன்னுடைய தகப்பன் வம்சத்தாரும் பரிசுத்த ஸ்தலத்தைப்பற்றிய அக்கிரமத்தைச் சுமக்கவேண்டும்; நீயும் உன்னுடன் உன்னுடைய மகன்களும் உங்கள் ஆசாரிய ஊழியத்தைப்பற்றிய அக்கிரமத்தைச் சுமக்க வேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","உன்னுடைய தகப்பனாகிய லேவியின் கோத்திரத்தாரான உன்னுடைய சகோதரர்களையும் உன்னோடே கூடியிருக்கவும் உன்னிடத்திலே சேவிக்கவும் அவர்களைச் சேர்த்துக்கொள்; நீயும் உன்னுடைய மகன்களுமோ சாட்சியின் கூடாரத்திற்குமுன்பு ஊழியம் செய்யவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","அவர்கள் உன்னுடைய காவலையும் கூடாரம் அனைத்தின் காவலையும் காக்கவேண்டும்; ஆனாலும் அவர்களும் நீங்களும் சாகாதபடி, அவர்கள் பரிசுத்த ஸ்தலத்தின் பணிப்பொருட்களின் அருகிலும் பலிபீடத்தின் அருகிலும் சேராமல், ");
INSERT INTO tam2017_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","உன்னோடே கூடிக்கொண்டு, கூடாரத்தின் எல்லா வேலையையும் செய்ய, ஆசரிப்புக்கூடாரத்தின் காவலைக் காக்கவேண்டும்; அந்நியன் ஒருவனும் உங்களிடத்தில் சேரக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","இஸ்ரவேல் மக்கள்மேல் இனிக் கடுங்கோபம் வராதபடி, நீங்கள் பரிசுத்த ஸ்தலத்தின் காவலையும் பலிபீடத்தின் காவலையும் காக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","ஆசரிப்புக்கூடாரத்தின் வேலையைச் செய்ய, யெகோவாவுக்குக் கொடுக்கப்பட்ட உங்கள் சகோதரர்களாகிய லேவியர்களை நான் இஸ்ரவேல் சந்ததியாரிலிருந்து பிரித்து, உங்களுக்கு பரிசாகக் கொடுத்தேன். ");
INSERT INTO tam2017_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","ஆகையால் நீயும் உன்னோடேகூட உன்னுடைய மகன்களும் பலிபீடத்திற்கும் திரைக்கு உட்புறத்திற்கும் அடுத்த எல்லாவற்றையும் செய்வதற்காக, உங்கள் ஆசாரிய ஊழியத்தைக் காத்துச் சேவிக்கவேண்டும்; உங்களுடைய ஆசாரிய ஊழியத்தை உங்களுக்கு பரிசாக அருளினேன்; அதைச் செய்யும்படி சேருகிற அந்நியன் கொலை செய்யப்படவேண்டும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","பின்னும் யெகோவா ஆரோனை நோக்கி: “இஸ்ரவேல் மக்கள் பரிசுத்தப்படுத்துகிறவைகளிலெல்லாம் எனக்கு ஏறெடுத்துப் படைக்கப்படும் படைப்புகளைக் காத்துக் கொண்டிருக்கிறீர்களே, அவைகளை உனக்குக் கொடுத்தேன்; அபிஷேகத்தினால் அவைகளை உனக்கும் உன் மகன்களுக்கும் நிரந்தர கட்டளையாகக் கொடுத்தேன். ");
INSERT INTO tam2017_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","மகா பரிசுத்தமானவைகளிலே, அக்கினிக்கு உட்படுத்தப்படாமல் உன்னுடையதாக இருப்பது எவையெனில், அவர்கள் எனக்குப் படைக்கும் எல்லாப் படைப்பும், எல்லா உணவுபலியும், எல்லாப் பாவநிவாரணபலியும், எல்லாக் குற்றநிவாரணபலியும், உனக்கும் உன்னுடைய மகன்களுக்கும் பரிசுத்தமாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","பரிசுத்த ஸ்தலத்திலே அவைகளைச் சாப்பிடவேண்டும்; ஆண்மக்கள் யாவரும் அவைகளைச் சாப்பிடலாம்; அவைகள் உனக்குப் பரிசுத்தமாக இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","இஸ்ரவேல் மக்கள் ஏறெடுத்துப்படைக்கிறதும் அசைவாட்டுகிறதுமான அவர்களுடைய எல்லாக் காணிக்கைகளின் படைப்பும் உன்னுடையவைகளாக இருக்கும்; அவைகளை உனக்கும் உன்னுடைய மகன்களுக்கும் உன்னுடைய மகள்களுக்கும் நிரந்தர பங்காகக் கொடுத்தேன்; உன்னுடைய வீட்டிலே சுத்தமானவர்கள் எல்லோரும் அவைகளைச் சாப்பிடலாம். ");
INSERT INTO tam2017_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","அவர்கள் யெகோவாவுக்குக் கொடுக்கும் அவர்களுடைய முதற்பலன்களாகிய சிறந்த எண்ணெயையும், சிறந்த திராட்சைரசத்தையும், தானியத்தையும் உனக்கு உரியதாகக் கொடுத்தேன். ");
INSERT INTO tam2017_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","தங்களுடைய தேசத்தில் முதற் பழுத்த பலனில் அவர்கள் யெகோவாவுக்குக் கொண்டு வருவதெல்லாம் உனக்கு உரியதாகும்; உன்னுடைய வீட்டிலே சுத்தமாக இருப்பவர்கள் யாவரும் அவைகளைச் சாப்பிடலாம். ");
INSERT INTO tam2017_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","இஸ்ரவேலிலே சாபத்தீடாக நேர்ந்துகொள்ளப்பட்டதெல்லாம் உனக்கு உரியதாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","மனிதரிலும் மிருகங்களிலும் அவர்கள் யெகோவாவுக்குச் செலுத்தும் எல்லா மிருகங்களுக்குள்ளே கர்ப்பந்திறந்து பிறக்கும் யாவும் உனக்கு உரியதாக இருக்கும்; ஆனாலும் மனிதரின் முதற்பேற்றை கொல்லப்படாத நியமத்தின்படி மீட்கவேண்டும்; தீட்டான மிருகஜீவனின் தலையீற்றையும் மீட்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","மீட்கவேண்டியவைகள் ஒரு மாதத்திற்கு மேற்பட்டதானால், உன்னுடைய மதிப்புக்கு இசைய பரிசுத்த ஸ்தலத்தின் சேக்கல் கணக்கின்படி ஐந்து சேக்கல் பணத்தாலே அவைகளை மீட்கவேண்டும்; ஒரு சேக்கல் இருபது கேரா. ");
INSERT INTO tam2017_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","மாட்டின் தலையீற்றும், செம்மறியாட்டின் தலையீற்றும், வெள்ளாட்டின் தலையீற்றுமோ மீட்கப்படவேண்டாம்; அவைகள் பரிசுத்தமானவைகள்; அவைகளின் இரத்தத்தைப் பலிபீடத்தின்மேல் தெளித்து, அவைகளின் கொழுப்பைக் யெகோவாவுக்குச் சுகந்த வாசனையான தகனமாகத் தகனிக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","அசைவாட்டும் மார்புப்பகுதியைப்போலவும் வலது முன்னந்தொடையைப்போலவும் அவைகளின் இறைச்சியும் உன்னுடையதாகும். ");
INSERT INTO tam2017_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","இஸ்ரவேல் மக்கள் யெகோவாவுக்கு ஏறெடுத்துப் படைக்கிற பரிசுத்த படைப்புகளையெல்லாம் உனக்கும் உன்னுடைய மகன்களுக்கும் உன்னுடைய மகள்களுக்கும் நிரந்தர கட்டளையாகக் கொடுத்தேன்; யெகோவாவுடைய சந்நிதியில் இது உனக்கும் உன்னுடைய சந்ததிக்கும் என்றைக்கும் செல்லும் மாறாத உடன்படிக்கை” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","பின்னும் யெகோவா ஆரோனை நோக்கி: “அவர்களுடைய தேசத்தில் நீ ஒன்றையும் சுதந்தரித்துக்கொள்ளவேண்டாம், அவர்கள் நடுவே உனக்குப் பங்கு உண்டாயிருக்கவும் வேண்டாம்; இஸ்ரவேல் மக்கள் நடுவில் நானே உன்னுடைய பங்கும் உன்னுடைய சுதந்தரமுமாக இருக்கிறேன். ");
INSERT INTO tam2017_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“இதோ, லேவியின் சந்ததி ஆசரிப்புக் கூடாரத்தின் பணிவிடையைச் செய்கிற அவர்களுடைய வேலைக்காக, இஸ்ரவேலருக்குள்ளவை எல்லாவற்றிலும் தசமபாகத்தை அவர்களுக்குச் சுதந்தரமாகக் கொடுத்தேன். ");
INSERT INTO tam2017_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","இஸ்ரவேல் மக்கள் குற்றஞ்சுமந்து சாகாதபடி, இனி ஆசரிப்புக் கூடாரத்தைக் அருகில் வராமலிருக்க வேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","லேவியர்கள் மட்டும் ஆசரிப்புக் கூடாரத்தைச்சேர்ந்த வேலைகளைச் செய்யவேண்டும்; அவர்கள் தங்களுடைய அக்கிரமத்தைச் சுமப்பார்கள்; இஸ்ரவேல் மக்கள் நடுவே அவர்களுக்குச் சுதந்தரம் இல்லை என்பது உங்களுடைய தலைமுறைதோறும் நிரந்தர கட்டளையாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","இஸ்ரவேல் மக்கள் யெகோவாவுக்கு ஏறெடுத்துப் படைக்கும் படைப்பாகிய தசமபாகத்தை லேவியர்களுக்குச் சுதந்தரமாகக் கொடுத்தேன்; ஆகையால் இஸ்ரவேல் மக்களின் நடுவே அவர்களுக்குச் சுதந்தரமில்லையென்று அவர்களுக்குச் சொன்னேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","பின்னும் யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“நீ லேவியரோடு சொல்லவேண்டியது என்னவென்றால்: இஸ்ரவேல் மக்கள் கையில் வாங்கிக்கொள்ளும்படி நான் உங்களுக்குச் சுதந்தரமாகக் கொடுத்த தசமபாகத்தை நீங்கள் அவர்கள் கையில் வாங்கும்போது. தசமபாகத்தில் பத்தில் ஒரு பங்கைக் யெகோவாவுக்கு ஏறெடுத்துப்படைக்கும் படைப்பாகச் செலுத்தவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","நீங்கள் ஏறெடுத்துப் படைக்கும் இந்தப் படைப்பு களத்தின் தானியத்தைப்போலும், ஆலையின் இரசத்தைப்போலும் உங்களுக்கு எண்ணப்படும். ");
INSERT INTO tam2017_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","இப்படியே நீங்கள் இஸ்ரவேல் மக்கள் கையில் வாங்கும் தசமபாகமாகிய உங்களுடைய பங்குகளிலெல்லாம் நீங்களும் யெகோவாவுக்கு என்று ஒரு படைப்பை ஏறெடுத்துப் படைத்து, அந்தப் படைப்பை ஆசாரியனாகிய ஆரோனுக்குக் கொடுக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","உங்களுக்குக் கொடுக்கப்படுகிற ஒவ்வொரு காணிக்கையிலுமுள்ள சிறந்த பரிசுத்த பங்கையெல்லாம் யெகோவாவுக்கு ஏறெடுத்துப் படைக்கும் படைப்பாகச் செலுத்தவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","ஆதலால் நீ அவர்களோடு சொல்லவேண்டியது என்னவென்றால்: அதில் சிறந்ததை நீங்கள் ஏறெடுத்துப் படைக்கும்போது, அது களத்தின் வரத்திலும் ஆலையின் வரத்திலும் இருந்து எடுத்துச்செலுத்துகிறதுபோல லேவியர்களுக்கு எண்ணப்படும். ");
INSERT INTO tam2017_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","அதை நீங்களும் உங்கள் குடும்பத்தாரும் எவ்விடத்திலும் சாப்பிடலாம்; அது நீங்கள் ஆசரிப்புக் கூடாரத்திலே செய்யும் பணிவிடைக்கு ஈடான உங்கள் சம்பளம். ");
INSERT INTO tam2017_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","இப்படி அதில் சிறந்ததை ஏறெடுத்துப் படைத்தீர்களானால், நீங்கள் அதற்காக பாவம் சுமக்கமாட்டீர்கள்; நீங்கள் சாகாதிருக்கும்படி, இஸ்ரவேல் மக்களின் பரிசுத்தமானவைகளைத் தீட்டுப்படுத்தக்கூடாது என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","யெகோவா மோசேயையும் ஆரோனையும் நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“யெகோவா கற்பித்த நியமப்பிரமாணமாவது: பழுதற்றதும் ஊனமில்லாததும் நுகத்தடிக்கு பயன்படுத்தாதுமாகிய சிவப்பான ஒரு கிடாரியை உன்னிடத்தில் கொண்டுவரும்படி இஸ்ரவேல் மக்களுக்குச் சொல்லுங்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","அதை எலெயாசார் என்னும் ஆசாரியனிடத்தில் ஒப்புக்கொடுங்கள்; அவன் அதைப் முகாமிற்கு வெளியே கொண்டுபோகவேண்டும்; அங்கே அது அவனுக்கு முன்பாகக் கொல்லப்படக்கடவது. ");
INSERT INTO tam2017_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","அப்பொழுது ஆசாரியனாகிய எலெயாசார் தன்னுடைய விரலினால் அதின் இரத்தத்தில் கொஞ்சம் எடுத்து, ஆசரிப்புக் கூடாரத்திற்கு எதிராக ஏழுதரம் தெளிக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","பின்பு கிடாரியை அவன் கண்களுக்கு முன்பாக ஒருவன் சுட்டெரிக்கவேண்டும்; அதின் தோலும் அதின் இறைச்சியும் அதின் இரத்தமும் அதின் சாணியும் சுட்டெரிக்கப்படவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","அப்பொழுது ஆசாரியன் கேதுருக்கட்டையையும் ஈசோப்பையும் சிவப்பு நூலையும் எடுத்து, கிடாரி எரிக்கப்படுகிற நெருப்பின் நடுவிலே போடவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","பின்பு ஆசாரியன் தன்னுடைய ஆடைகளைத் தோய்த்து, தண்ணீரிலே குளித்து, அதின்பின்பு முகாமில் நுழையவேண்டும்; ஆசாரியன் மாலைவரைத் தீட்டுப்பட்டிருப்பான். ");
INSERT INTO tam2017_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","அதைச் சுட்டெரித்தவனும் தன்னுடைய ஆடைகளை தண்ணீரில் தோய்த்து, தண்ணீரில் குளித்து, மாலைவரைத் தீட்டுப்பட்டிருப்பான். ");
INSERT INTO tam2017_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","சுத்தமாக இருக்கிற ஒருவன் அந்தக் கிடாரியின் சாம்பலை வாரிக்கொண்டு, முகாமிற்கு வெளியே சுத்தமான ஒரு இடத்திலே கொட்டிவைக்கவேண்டும்; அது இஸ்ரவேல் மக்களின் சபைக்காகத் தீட்டுக்கழிக்கும் தண்ணீருக்கென்று பாதுகாத்து வைக்கப்படவேண்டும்; அது பாவத்தைப் பரிகரிக்கும். ");
INSERT INTO tam2017_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","கிடாரியின் சாம்பலை வாரினவன் தன்னுடைய ஆடைகளைத் துவைக்கவேண்டும்; அவன் மாலைவரைத் தீட்டுப்பட்டிருப்பான்; இது இஸ்ரவேல் மக்களுக்கும் அவர்கள் நடுவிலே தங்குகிற அந்நியனுக்கும் நித்திய கட்டளையாக இருப்பதாக. ");
INSERT INTO tam2017_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“இறந்தவனுடைய பிரேதத்தைத் தொட்டவன் ஏழுநாட்கள் தீட்டுப்பட்டிருப்பான். ");
INSERT INTO tam2017_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","அவன் மூன்றாம் நாளிலும் ஏழாம் நாளிலும் தீட்டுக்கழிக்கும் தண்ணீரினால் தன்னைச் சுத்திகரிக்கவேண்டும்; அப்பொழுது சுத்தமாவான்; மூன்றாம் நாளிலும் ஏழாம் நாளிலும் தன்னைச் சுத்திகரிக்காமல் இருந்தால் சுத்தமாகமாட்டான். ");
INSERT INTO tam2017_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","செத்தவனுடைய பிரேதத்தைத் தொட்டும், தன்னைச் சுத்திகரித்துக்கொள்ளாதவன் யெகோவாவின் வாசஸ்தலத்தைத் தீட்டுப்படுத்துகிறான்; அந்த ஆத்துமா இஸ்ரவேலில் இல்லாமல் அழிந்துபோவான்; தீட்டுக்கழிக்கும் தண்ணீர் அவன்மேல் தெளிக்கப்படாததினால், அவன் தீட்டுப்பட்டிருப்பான்; அவனுடைய தீட்டு இன்னும் அவன்மேல் இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“கூடாரத்தில் ஒரு மனிதன் செத்தால், அதைச்சேர்ந்த நியமமாவது: அந்தக் கூடாரத்தில் நுழைகிற யாவரும் கூடாரத்தில் இருக்கிற யாவரும் ஏழுநாட்கள் தீட்டுப்பட்டிருப்பார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","மூடிக் கட்டப்படாமல் திறந்திருக்கும் பாத்திரங்கள் எல்லாம் தீட்டுப்பட்டிருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","வெளியிலே பட்டயத்தால் வெட்டப்பட்டவனையோ, செத்தவனையோ, மனித எலும்பையோ, பிரேதக்குழியையோ, தொட்டவன் எவனும் ஏழுநாட்கள் தீட்டுப்பட்டிருப்பான். ");
INSERT INTO tam2017_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","ஆகையால் தீட்டுப்பட்டவனுக்காக, பாவத்தைப் பரிகரிக்கும் கிடாரியின் சாம்பலிலே கொஞ்சம் எடுத்து, ஒரு பாத்திரத்தில் போட்டு, அதின்மேல் ஊற்று தண்ணீர் ஊற்றவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","சுத்தமான ஒருவன் ஈசோப்பை எடுத்து, அந்த தண்ணீரிலே நனைத்து, கூடாரத்தின்மேலும் அதிலுள்ள எல்லா பணிப்பொருட்களின்மேலும் அங்கேயிருக்கிற மக்களின்மேலும் தெளிக்கிறதும் இல்லாமல், எலும்பையோ வெட்டப்பட்டவனையோ செத்தவனையோ பிரேதக்குழியையோ தொட்டவன்மேலும் தெளிக்கவேண்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","சுத்தமாக இருக்கிறவன் தீட்டுப்பட்டவன்மேல் மூன்றாம் நாளிலும் ஏழாம் நாளிலும் தெளிக்கவேண்டும்; ஏழாம் நாளில் இவன் தன்னைச் சுத்திகரித்து, தன்னுடைய ஆடைகளைத் தோய்த்து, தண்ணீரில் குளித்து, மாலையிலே சுத்தமாக இருப்பான். ");
INSERT INTO tam2017_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“தீட்டுப்பட்டிருக்கிறவன் தன்னைச் சுத்திகரித்துக்கொள்ளாமல் இருந்தால், அவன் சபையில் இல்லாதபடி அழிந்துபோவான்; அவன் யெகோவாவின் பரிசுத்த ஸ்தலத்தைத் தீட்டுப்படுத்தினான்; தீட்டுக்கழிக்கும் தண்ணீர் அவன்மேல் தெளிக்கப்படாததினால் அவன் தீட்டுப்பட்டிருக்கிறான். ");
INSERT INTO tam2017_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","தீட்டுக்கழிக்கும் தண்ணீரைத் தெளிக்கிறவனும் தன்னுடைய ஆடைகளைத் துவைக்கவேண்டும்; தீட்டுக்கழிக்கும் தண்ணீரைத் தொட்டவனும் மாலைவரைத் தீட்டுப்பட்டிருப்பான். ");
INSERT INTO tam2017_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","தீட்டுப்பட்டிருக்கிறவன் தொடுகிறவைகளெல்லாம் தீட்டுப்படும், அவைகளைத் தொடுகிறவனும் மாலைவரைத் தீட்டுப்பட்டிருப்பான்; இது உங்களுக்கு நிரந்தர கட்டளையாக இருக்கும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","இஸ்ரவேல் மக்களின் சபையார் எல்லோரும் முதலாம் மாதத்தில் சீன்வனாந்திரத்திலே சேர்ந்து, மக்கள் காதேசிலே தங்கியிருக்கும்போது, மிரியாம் மரணமடைந்து, அங்கே அடக்கம்செய்யப்பட்டாள். ");
INSERT INTO tam2017_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","மக்களுக்குத் தண்ணீர் இல்லாமல் இருந்தது; அப்பொழுது அவர்கள் மோசேக்கும் ஆரோனுக்கும் விரோதமாகக் கூட்டம்கூடினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","மக்கள் மோசேயோடு வாக்குவாதம்செய்து: “எங்களுடைய சகோதரர்கள் யெகோவாவுடைய சந்நிதியில் இறந்தபோது நாங்களும் இறந்துபோயிருந்தால் நலமாக இருக்கும். ");
INSERT INTO tam2017_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","நாங்களும் எங்களுடைய மிருகங்களும் இங்கே இறக்கும்படி, நீங்கள் யெகோவாவின் சபையை இந்த வனாந்திரத்திலே கொண்டு வந்தது என்ன; ");
INSERT INTO tam2017_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","விதைப்பும், அத்திமரமும், திராட்சைச்செடியும், மாதுளஞ்செடியும், குடிக்கத்தண்ணீரும் இல்லாத இந்தக் கெட்ட இடத்தில் எங்களைக் கொண்டுவரும்படி, நீங்கள் எங்களை எகிப்திலிருந்து புறப்படச்செய்தது ஏன்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","அப்பொழுது மோசேயும் ஆரோனும் சபையாரைவிட்டு, ஆசரிப்புக்கூடாரத்தின் வாசலில் போய், முகங்குப்புற விழுந்தார்கள்; யெகோவாவுடைய மகிமை அவர்களுக்குக் காணப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“நீ கோலை எடுத்துக்கொண்டு, நீயும் உன்னுடைய சகோதரனாகிய ஆரோனும் சபையாரைக் கூடிவரச்செய்து, அவர்கள் கண்களுக்குமுன்னே கன்மலையைப் பார்த்துப் பேசுங்கள்; அப்பொழுது அது தன்னிடத்திலுள்ள தண்ணீரைக் கொடுக்கும்; இப்படி நீ அவர்களுக்குக் கன்மலையிலிருந்து தண்ணீர் புறப்படச்செய்து, சபையாருக்கும் அவர்களுடைய மிருகங்களுக்கும் குடிக்கக் கொடுப்பாய்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","அப்பொழுது மோசே தனக்குக் யெகோவா கட்டளையிட்டபடியே யெகோவாவுடைய சந்நிதியிலிருந்த கோலை எடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","மோசேயும் ஆரோனும் சபையாரைக் கன்மலைக்கு முன்பாகக் கூடிவரச்செய்தார்கள்; அப்பொழுது மோசே அவர்களை நோக்கி: “கலகக்காரரே, கேளுங்கள், உங்களுக்கு இந்தக் கன்மலையிலிருந்து நாங்கள் தண்ணீர் புறப்படச்செய்வோமோ” என்று சொல்லி, ");
INSERT INTO tam2017_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","தன்னுடைய கையை ஓங்கி, கன்மலையைத் தன்னுடைய கோலினால் இரண்டுமுறை அடித்தான்; உடனே தண்ணீர் ஏராளமாகப் புறப்பட்டது, சபையார் குடித்தார்கள்; அவர்கள் மிருகங்களும் குடித்தது. ");
INSERT INTO tam2017_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","பின்பு யெகோவா மோசேயையும் ஆரோனையும் நோக்கி: “இஸ்ரவேல் மக்கள் கண்களுக்கு முன்பாக என்னைப் பரிசுத்தம்செய்யும்படி, நீங்கள் என்னை விசுவாசிக்காமல் போனதால், இந்தச் சபையாருக்கு நான் கொடுத்த தேசத்திற்குள் நீங்கள் அவர்களைக் கொண்டுபோவதில்லை” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","இங்கே இஸ்ரவேல் மக்கள் யேகோவாவோடு வாக்குவாதம் செய்ததினாலும், அவர்களுக்குள்ளே அவருடைய பரிசுத்தம் விளங்கினதினாலும் இது மேரிபாவின் தண்ணீர் என்னப்பட்டது. ");
INSERT INTO tam2017_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","பின்பு மோசே காதேசிலிருந்து ஏதோமின் ராஜாவினிடத்திற்கு தூதுவர்களை அனுப்பி: ");
INSERT INTO tam2017_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","எங்களுடைய முற்பிதாக்கள் எகிப்திற்குப் போனதும், நாங்கள் எகிப்திலே நெடுநாட்கள் வாசம்செய்ததும், எகிப்தியர்கள் எங்களையும் எங்களுடைய பிதாக்களையும் உபத்திரவப்படுத்தினதும், இவைகளினால் எங்களுக்கு நேரிட்ட எல்லா வருத்தமும் உமக்குத் தெரிந்திருக்கிறது. ");
INSERT INTO tam2017_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","யெகோவாவை நோக்கி நாங்கள் மன்றாடினோம்; அவர் எங்களுக்குச் செவிகொடுத்து, ஒரு தூதனை அனுப்பி, எங்களை எகிப்திலிருந்து புறப்படச்செய்தார்; இப்பொழுது நாங்கள் உமது எல்லைக்கு உட்பட்ட காதேஸ் ஊரில் வந்திருக்கிறோம். ");
INSERT INTO tam2017_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","நாங்கள் உமது தேசத்தின் வழியாகக் கடந்துபோகும்படி அனுமதி கொடுக்கவேண்டும்; வயல்வெளிகள் வழியாகவும், திராட்சைத்தோட்டங்கள் வழியாகவும் நாங்கள் போகாமலும், கிணறுகளின் தண்ணீரைக் குடிக்காமலும், ராஜபாதையாகவே நடந்து, உமது எல்லையைக் கடந்துபோகும்வரை, வலதுபுறம் இடதுபுறம் சாயாமல் இருப்போம் என்று, உமது சகோதரனாகிய இஸ்ரவேல் சொல்லி அனுப்புகிறான்” என்று சொல்லச்சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","அதற்கு ஏதோம்: “நீ என்னுடைய தேசத்தின் வழியாகக் கடந்துபோக முடியாது; போனால் பட்டயத்தோடு உன்னை எதிர்க்கப் புறப்படுவேன் என்று அவனுக்குச் சொல்லச்சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","அப்பொழுது இஸ்ரவேல் மக்கள் அவனை நோக்கி: “நடப்பான பாதையின் வழியாகப் போவோம்; நாங்களும் எங்களுடைய மிருகங்களும் உன்னுடைய தண்ணீரைக் குடித்தால், அதற்குக் தகுந்த விலைகொடுப்போம்; வேறொன்றும் செய்யாமல், கால்நடையாக மட்டும் கடந்துபோவோம்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","அதற்கு அவன்: “நீ கடந்துபோக முடியாது” என்று சொல்லி, கணக்கற்ற மக்களோடும் பலத்த கரங்களோடும், படையோடும் அவர்களை எதிர்க்கப் புறப்பட்டான். ");
INSERT INTO tam2017_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","இப்படி ஏதோம் தன்னுடைய எல்லைவழியாகக் கடந்துபோகும்படி இஸ்ரவேலர்களுக்கு அனுமதி கொடுக்கவில்லை; ஆகையால் இஸ்ரவேலர்கள் அவனை விட்டு விலகிப் போனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","இஸ்ரவேல் மக்களான சபையார் எல்லோரும் காதேசை விட்டுப் பயணப்பட்டு, ஓர் என்னும் மலைக்குப் போனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","ஏதோம் தேசத்தின் எல்லைக்கு அருகான ஓர் என்னும் மலையிலே யெகோவா மோசேயையும் ஆரோனையும் நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“ஆரோன் தன்னுடைய மக்களோடு சேர்க்கப்படுவான். மேரிபாவின் தண்ணீரைப்பற்றிய காரியத்தில் நீங்கள் என்னுடைய வாக்குக்குக் கீழ்ப்படியாமல் போனபடியால், நான் இஸ்ரவேல் மக்களுக்குக் கொடுக்கிற தேசத்தில் அவன் நுழைவதில்லை. ");
INSERT INTO tam2017_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","நீ ஆரோனையும் அவனுடைய மகனாகிய எலெயாசாரையும் கூட்டிக்கொண்டு, அவர்களை ஓர் என்னும் மலையில் ஏறச்செய்து, ");
INSERT INTO tam2017_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","ஆரோன் உடுத்தியிருக்கிற ஆடைகளைக் கழற்றி, அவைகளை அவனுடைய மகனாகிய எலெயாசாருக்கு உடுத்து; ஆரோன் அங்கே மரித்து, தன்னுடைய மக்களோடு சேர்க்கப்படுவான்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","யெகோவா கட்டளையிட்டபடியே மோசே செய்தான்; சபையார் எல்லோரும் பார்க்க, அவர்கள் ஓர் என்னும் மலையில் ஏறினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","அங்கே ஆரோன் உடுத்தியிருந்த ஆடைகளை மோசே கழற்றி, அவைகளை அவனுடைய மகனாகிய எலெயாசாருக்கு உடுத்தினான்; அப்பொழுது ஆரோன் அங்கே மலையின் உச்சியிலே இறந்தான்; பின்பு மோசேயும் எலெயாசாரும் மலையிலிருந்து இறங்கினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","ஆரோன் இறந்துபோனான் என்பதைச் சபையார் எல்லோரும் கண்டபோது, இஸ்ரவேல் வம்சத்தார் எல்லோரும் ஆரோனுக்காக 30 நாட்கள் துக்கம்கொண்டாடினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","வேவுகாரர்கள் காண்பித்த வழியாக இஸ்ரவேலர்கள் வருகிறார்கள் என்று தெற்கே வாழ்கிற கானானியனாகிய ஆராத் ராஜா கேள்விப்பட்டபோது, அவன் இஸ்ரவேலர்களுக்கு எதிராக யுத்தம் செய்து, அவர்களில் சிலரைச் சிறைபிடித்துக்கொண்டுபோனான். ");
INSERT INTO tam2017_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","அப்பொழுது இஸ்ரவேலர்கள் யெகோவாவை நோக்கி: “தேவரீர் இந்த மக்களை எங்கள் கையில் ஒப்புக்கொடுத்தால், அவர்களுடைய பட்டணங்களைச் அழிப்போம்” என்று சபதம் செய்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","யெகோவா இஸ்ரவேலின் சத்தத்திற்குச் செவிகொடுத்து, அவர்களுக்குக் கானானியர்களை ஒப்புக்கொடுத்தார்; அப்பொழுது அவர்களையும் அவர்களுடைய பட்டணங்களையும் அழித்து, அந்த இடத்திற்கு ஓர்மா என்று பெயரிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","அவர்கள் ஏதோம் தேசத்தைச் சுற்றிப்போகும்படி, ஓர் என்னும் மலையைவிட்டு, சிவந்த சமுத்திரத்தின் வழியாகப் பயணம்செய்தார்கள்; வழிப்பயணத்தின் காரணமாக மக்கள் மனவேதனையடைந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","மக்கள் தேவனுக்கும் மோசேக்கும் விரோதமாகப் பேசி: “நாங்கள் வனாந்திரத்திலே சாகும்படி நீங்கள் எங்களை எகிப்து தேசத்திலிருந்து வரச்செய்தது ஏன்? இங்கே அப்பமும் இல்லை, தண்ணீரும் இல்லை; இந்த அற்பமான உணவு எங்களுடைய மனதிற்கு வெறுப்பாக இருக்கிறது என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","அப்பொழுது யெகோவா விஷமுள்ள பாம்புகளை மக்களுக்குள்ளே அனுப்பினார்; அவைகள் மக்களைக் கடித்ததினால் இஸ்ரவேலர்களுக்குள்ளே அநேக மக்கள் இறந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","அதினால் மக்கள் மோசேயினிடத்தில் போய்: “நாங்கள் யெகோவாவுக்கும் உமக்கும் விரோதமாகப் பேசினதினால் பாவம்செய்தோம்; பாம்புகள் எங்களைவிட்டு நீங்கும்படி யெகோவாவை நோக்கி விண்ணப்பம் செய்யவேண்டும்” என்றார்கள்; மோசே மக்களுக்காக விண்ணப்பம்செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","அப்பொழுது யெகோவா மோசேயை நோக்கி: “நீ ஒரு விஷமுள்ள பாம்பின் உருவத்தைச் செய்து, அதை ஒரு கம்பத்தின்மேல் தூக்கிவை; கடிக்கப்பட்டவன் எவனோ அவன் அதை நோக்கிப்பார்த்தால் பிழைப்பான் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","அப்படியே மோசே ஒரு வெண்கலப் பாம்பை உண்டாக்கி, அதை ஒரு கம்பத்தின்மேல் தூக்கிவைத்தான்; பாம்பு ஒருவனைக் கடித்தபோது, அவன் அந்த வெண்கலப் பாம்பை நோக்கிப்பார்த்துப் பிழைப்பான். ");
INSERT INTO tam2017_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","இஸ்ரவேல் மக்கள் பயணப்பட்டுப்போய், ஓபோத்தில் முகாமிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","ஓபோத்திலிருந்து பயணம் செய்து, கிழக்குதிசைக்கு நேராக மோவாபுக்கு எதிரான வனாந்திரத்திலுள்ள அபாரீமின் மேடுகளில் முகாமிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","அங்கேயிருந்து பயணப்பட்டுப் போய், சேரேத் பள்ளத்தாக்கிலே முகாமிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","அங்கேயிருந்து பயணப்பட்டுப் போய், எமோரியர்களின் எல்லையிலிருந்து வருகிறதும் வனாந்திரத்தில் ஓடுகிறதுமான அர்னோன் ஆற்றுக்கு இந்தப்பக்கம் முகாமிட்டார்கள்; அந்த அர்னோன் மோவாபுக்கும் எமோரியர்களுக்கும் நடுவே இருக்கிற மோவாபின் எல்லை. ");
INSERT INTO tam2017_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","அதினால் சூப்பாவிலுள்ள வாகேபும், அர்னோனின் ஆற்றுக்கால்களும், ");
INSERT INTO tam2017_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ஆர் என்னும் இடத்திற்குப் பாயும் நீரோடையும் மோவாபின் எல்லையைச் சார்ந்திருக்கிறது என்னும் வசனம் யெகோவாவுடைய யுத்த புத்தகத்தில் எழுதியிருக்கிறது. ");
INSERT INTO tam2017_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","அங்கேயிருந்து பேயேருக்குப் போனார்கள்; “மக்களைக் கூடிவரச்செய், அவர்களுக்குத் தண்ணீர் கொடுப்பேன்” என்று யெகோவா மோசேக்குச் சொன்ன ஊற்று இருக்கிற இடம் அதுதான். ");
INSERT INTO tam2017_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","அப்பொழுது இஸ்ரவேலர்கள் பாடின பாட்டாவது: “ஊற்றுத் தண்ணீரே, பொங்கிவா; அதைக்குறித்துப் பாடுவோம் வாருங்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","நியாயப்பிரமாணத் தலைவனின் தூண்டுதலால் அதிபதிகள் கிணற்றைத் தோண்டினார்கள்; மக்களின் மேன்மக்கள் தங்கள் தண்டாயுதங்களைக்கொண்டு தோண்டினார்கள்” என்று பாடினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","அந்த வனாந்திரத்திலிருந்து மாத்தனாவுக்கும், மாத்தனாவிலிருந்து நகாலியேலுக்கும், நகாலியேலிலிருந்து பாமோத்திற்கும், ");
INSERT INTO tam2017_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","பள்ளத்தாக்கிலுள்ள மோவாபின் வெளியில் இருக்கிற பாமோத்திலிருந்து எஷிமோனை நோக்கும் பிஸ்காவின் உச்சிக்கும் போனார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","அப்பொழுது இஸ்ரவேலர்கள் எமோரியர்களின் ராஜாவாகிய சீகோனிடத்தில் தூதுவர்களை அனுப்பி: ");
INSERT INTO tam2017_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“உமது தேசத்தின் வழியாகக் கடந்துபோகும்படி உத்திரவு கொடுக்கவேண்டும்; நாங்கள் வயல்களிலும், திராட்சைத்தோட்டங்களிலும் போகாமலும், கிணறுகளின் தண்ணீரைக் குடிக்காமலும், உமது எல்லையைக் கடந்துபோகும்வரை ராஜபாதையில் நடந்துபோவோம்” என்று சொல்லச்சொன்னார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","சீகோன் தன்னுடைய எல்லை வழியாகக் கடந்துபோக இஸ்ரவேலுக்கு உத்திரவு கொடாமல், தன்னுடைய மக்கள் எல்லோரையும் கூட்டிக்கொண்டு, இஸ்ரவேலர்களுக்கு எதிராக வனாந்திரத்திலே புறப்பட்டு, யாகாசுக்கு வந்து, இஸ்ரவேலர்களோடு யுத்தம்செய்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","இஸ்ரவேலர்கள் அவனைப் பட்டயக்கூர்மையினால் வெட்டி, அர்னோன் துவங்கி அம்மோன் மக்களின் தேசத்தைச்சார்ந்த யாப்போக்குவரைக்கும் உள்ள அவனுடைய தேசத்தைக் கட்டிக்கொண்டார்கள்; அம்மோன் மக்களின் எல்லை பாதுகாப்பானதாக இருந்தது. ");
INSERT INTO tam2017_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","இஸ்ரவேலர்கள் அந்தப் பட்டணங்கள் யாவையும் பிடித்து, எஸ்போனிலும் அதைச் சார்ந்த எல்லாக் கிராமங்களிலும் எமோரியர்களுடைய எல்லாப் பட்டணங்களிலும் குடியிருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","எஸ்போனானது எமோரியர்களின் ராஜாவாகிய சீகோனின் பட்டணமாக இருந்தது; அவன் மோவாபியர்களின் முந்தின ராஜாவுக்கு எதிராக யுத்தம்செய்து, அர்னோன் வரைக்கும் இருந்த அவனுடைய தேசத்தையெல்லாம் அவனுடைய கையிலிருந்து பறித்துக்கொண்டான். ");
INSERT INTO tam2017_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","அதினாலே நீதிமொழியைப் பேசுகிறவர்கள்: “எஸ்போனுக்கு வாருங்கள்; சீகோனின் பட்டணம் உறுதியாகக் கட்டப்படட்டும். ");
INSERT INTO tam2017_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","எஸ்போனிலிருந்து அக்கினியும் சீகோனுடைய பட்டணத்திலிருந்து ஜூவாலையும் புறப்பட்டு, மோவாபுடைய ஆர் என்னும் ஊரையும், அர்னோனுடைய மேடுகளிலுள்ள ஆண்டவன்மார்களையும் எரித்தது. ");
INSERT INTO tam2017_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","ஐயோ, மோவாபே, கேமோஷ் தேவனின் ஜனமே, நீ நாசமானாய்; தப்பி ஓடின தன்னுடைய மகன்களையும் தன்னுடைய மகள்களையும் எமோரியர்களின் ராஜாவாகிய சீகோனுக்குச் சிறைகளாக ஒப்புக்கொடுத்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","அவர்களை எய்துபோட்டோம்; எஸ்போன் பட்டணம், தீபோன் ஊர்வரைக்கும் அழிந்தது; மெதெபாவுக்கு அருகான நோப்பா பட்டணம்வரை அவர்களைப் பாழாக்கினோம்” என்று பாடினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","இஸ்ரவேலர்கள் இப்படியே எமோரியர்களின் தேசத்திலே குடியிருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","பின்பு, மோசே யாசேர் பட்டணத்திற்கு வேவுபார்க்கிறவர்களை அனுப்பினான்; அவர்கள் அதைச்சேர்ந்த கிராமங்களைக் கைப்பற்றி, அங்கே இருந்த எமோரியர்களைத் துரத்திவிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","பின்பு பாசானுக்குப் போகிற வழியாகத் திரும்பிவிட்டார்கள்; அப்பொழுது பாசான் ராஜாவாகிய ஓக் என்பவன் தன்னுடைய எல்லா மக்களோடும் அவர்களை எதிர்த்து யுத்தம்செய்யும்படி, எத்ரேயிக்குப் புறப்பட்டு வந்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","யெகோவா மோசேயை நோக்கி: “அவனுக்குப் பயப்படவேண்டாம்; அவனையும் அவனுடைய மக்கள் எல்லோரையும், அவனுடைய தேசத்தையும் உன்னுடைய கையில் ஒப்புக்கொடுத்தேன்; எஸ்போனிலே குடியிருந்த எமோரியர்களின் ராஜாவாகிய சீகோனுக்கு நீ செய்தபடியே இவனுக்கும் செய்வாய் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","அப்படியே ஒருவரும் உயிருடன் மீதியாக இல்லாதபடி அவனையும், அவனுடைய மகன்களையும், அவனுடைய எல்லா மக்களையும் வெட்டிப்போட்டு, அவனுடைய தேசத்தைக் கைப்பற்றிக்கொண்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","பின்பு இஸ்ரவேல் மக்கள் பயணம்செய்து, எரிகோவின் அருகே இருக்கும் யோர்தானுக்கு இக்கரையிலே மோவாபின் சமவெளிகளில் முகாமிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","இஸ்ரவேலர்கள் எமோரியர்களுக்குச் செய்த யாவையும் சிப்போரின் மகனாகிய பாலாக் கண்டான். ");
INSERT INTO tam2017_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","மக்கள் ஏராளமாக இருந்தபடியால், மோவாப் மிகவும் பயந்து, இஸ்ரவேல் மக்களினால் கலக்கமடைந்து, ");
INSERT INTO tam2017_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","மீதியானியர்களின் மூப்பர்களை நோக்கி: “மாடு வெளியின் புல்லை மேய்கிறதுபோல, இப்பொழுது இந்தக் கூட்டம் நம்மைச் சுற்றியிருக்கிற எல்லாவற்றையும் மேய்ந்துபோடும் என்றான். அக்காலத்திலே சிப்போரின் மகனாகிய பாலாக் மோவாபியர்களுக்கு ராஜாவாக இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","அவன் பேயோரின் மகனாகிய பிலேயாமை அழைத்துவரும்படி, தன்னுடைய சந்ததியாருடைய தேசத்தில் நதியருகேயுள்ள பேத்தோருக்கு தூதுவர்களை அனுப்பி: “எகிப்திலிருந்து ஒரு மக்கள்கூட்டம் வந்திருக்கிறது; அவர்கள் பூமியின் விசாலத்தை மூடி, எனக்கு எதிரே இறங்கியிருக்கிறார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","அவர்கள் என்னைவிட பலவான்கள்; இருந்தாலும், நீர் ஆசீர்வதிக்கிறவன் ஆசீர்வதிக்கப்பட்டவன், நீர் சபிக்கிறவன் சபிக்கப்பட்டவன் என்று அறிவேன்; ஆதலால் நீர் வந்து, எனக்காக அந்த மக்களை சபிக்கவேண்டும்; அப்பொழுது ஒருவேளை நான் அவர்களை முறியடித்து, அவர்களை இந்த தேசத்திலிருந்து துரத்திவிடலாம்” என்று சொல்லச்சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","அப்படியே மோவாபின் மூப்பர்களும் மீதியானின் மூப்பர்களும் குறிசொல்லுதலுக்கு உரிய கூலியைத் தங்களுடைய கையில் எடுத்துக்கொண்டு புறப்பட்டு, பிலேயாமிடத்தில் போய், பாலாகின் வார்த்தைகளை அவனுக்குச் சொன்னார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","அவன் அவர்களை நோக்கி: “இரவு இங்கே தங்கியிருங்கள்; யெகோவா எனக்குச் சொல்லுகிறபடியே உங்களுக்கு உத்திரவு கொடுப்பேன்” என்றான்; அப்படியே மோவாபின் பிரபுக்கள் பிலேயாமிடத்தில் தங்கினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","தேவன் பிலேயாமிடத்தில் வந்து: “உன்னிடத்திலிருக்கிற இந்த மனிதர்கள் யார்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","பிலேயாம் தேவனை நோக்கி: “சிப்போரின் மகனாகிய பாலாக் என்னும் மோவாபின் ராஜா அவர்களை என்னிடத்திற்கு அனுப்பி: ");
INSERT INTO tam2017_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","பூமியின் விசாலத்தை மூடுகிற ஒரு மக்கள்கூட்டம் எகிப்திலிருந்து வந்திருக்கிறது; ஆகையால், நீ வந்து எனக்காக அவர்களைச் சபிக்கவேண்டும்; அப்பொழுது நான் அவர்களோடு யுத்தம்செய்து, ஒருவேளை அவர்களைத் துரத்திவிடலாம் என்று சொல்லச்சொன்னான்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","அதற்குத் தேவன் பிலேயாமை நோக்கி: “நீ அவர்களோடு போகவேண்டாம்; அந்த மக்களைச் சபிக்கவும் வேண்டாம்; அவர்கள் ஆசீர்வதிக்கப்பட்டவர்கள்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","பிலேயாம் காலையில் எழுந்து, பாலாகின் பிரபுக்களை நோக்கி: “நீங்கள் உங்களுடைய தேசத்திற்குப் போய்விடுங்கள்; நான் உங்களோடு வருவதற்குக் யெகோவா எனக்கு உத்திரவு கொடுக்கமாட்டோம் என்கிறார்” என்று சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","அப்படியே மோவாபியர்களுடைய பிரபுக்கள் எழுந்து, பாலாகிடம் போய்: “பிலேயாம் எங்களோடு வரமாட்டேன் என்று சொன்னான்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","பாலாக் மறுபடியும் அவர்களிலும் கனவான்களான அதிக பிரபுக்களை அனுப்பினான். ");
INSERT INTO tam2017_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","அவர்கள் பிலேயாமிடத்தில் போய், அவனை நோக்கி: “சிப்போரின் மகனாகிய பாலாக் எங்களை அனுப்பி: நீர் என்னிடத்தில் வருவதற்குத் தடைபடவேண்டாம்; ");
INSERT INTO tam2017_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","உம்மை மிகவும் மரியாதைசெய்வேன்; நீர் சொல்வதையெல்லாம் செய்வேன்; நீர் வந்து எனக்காக அந்த மக்களைச் சபிக்கவேண்டும் என்று சொல்லச்சொன்னார்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","பிலேயாம் பாலாகின் ஊழியக்காரர்களுக்கு மறுமொழியாக: “பாலாக் எனக்குத் தன்னுடைய வீடு நிறைய வெள்ளியும் பொன்னும் தந்தாலும், சிறிய காரியமானாலும் பெரிய காரியமானாலும் செய்வதற்காக, என்னுடைய தேவனாகிய யெகோவாவின் கட்டளையை நான் மீறக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","ஆனாலும், யெகோவா இனிமேல் எனக்கு என்ன சொல்லுவார் என்பதை நான் அறியும்படி, நீங்களும் இந்த இரவு இங்கே தங்கியிருங்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","இரவிலே தேவன் பிலேயாமிடம் வந்து; “அந்த மனிதர்கள் உன்னைக் கூப்பிட வந்திருந்தால், நீ எழுந்து அவர்களோடு கூடப்போ; ஆனாலும், நான் உனக்குச் சொல்லும் வார்த்தையின்படிமட்டும் நீ செய்யவேண்டும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","பிலேயாம் காலையில் எழுந்து, தன்னுடைய கழுதையின்மேல் சேணங்கட்டி மோவாபின் பிரபுக்களோடு கூடப் போனான். ");
INSERT INTO tam2017_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","அவன் போவதினாலே தேவனுக்குக் கோபம் மூண்டது; யெகோவாவுடைய தூதனானவர் வழியிலே அவனுக்கு எதிராளியாக நின்றார். அவன் தன்னுடைய கழுதையின்மேல் ஏறிப்போனான்; அவனுடைய வேலைக்காரர்கள் இரண்டுபேரும் அவனோடே இருந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","யெகோவாவுடைய தூதனானவர் உருவின பட்டயத்தைத் தம்முடைய கையிலே பிடித்துக்கொண்டு வழியிலே நிற்கிறதைக் கழுதை கண்டு, வழியை விட்டு வயலிலே விலகிப்போனது; கழுதையை வழியில் திருப்ப பிலேயாம் அதை அடித்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","யெகோவாவுடைய தூதனானவர் இருபுறத்திலும் சுவர் வைத்திருந்த திராட்சைத் தோட்டங்களின் பாதையிலே போய் நின்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","கழுதை யெகோவாவுடைய தூதனைக்கண்டு, சுவர் ஒரமாக ஒதுங்கி, பிலேயாமின் காலைச் சுவரோடு நெருக்கியது; திரும்பவும் அதை அடித்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","அப்பொழுது யெகோவாவுடைய தூதன் அப்புறம் போய், வலதுபுறம் இடதுபுறம் விலக வழியில்லாத இடுக்கமான இடத்திலே நின்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","கழுதை யெகோவாவுடைய தூதனைக்கண்டு, பிலேயாமின் கீழ்ப் படுத்துக்கொண்டது; பிலேயாம் கோபம் வந்தவனாகி, கழுதையைத் தடியினால் அடித்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","உடனே யெகோவா கழுதையின் வாயைத் திறந்தார்; அது பிலேயாமைப் பார்த்து: “நீர் என்னை இப்பொழுது மூன்று தரம் அடிக்கும்படி நான் உமக்கு என்ன செய்தேன்” என்றது. ");
INSERT INTO tam2017_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","அப்பொழுது பிலேயாம் கழுதையைப் பார்த்து: “நீ என்னை கேலி செய்துகொண்டு வருகிறாய்; என்னுடைய கையில் ஒரு பட்டயம்மட்டும் இருந்தால், இப்பொழுதே உன்னைக் கொன்றுபோடுவேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","கழுதை பிலேயாமை நோக்கி: “நீர் என்னைக் கைக்கொண்ட காலமுதல் இந்நாள்வரைக்கும் நீர் ஏறின கழுதை நான் அல்லவா? இப்படி உமக்கு எப்போதாவது நான் செய்தது உண்டா” என்றது. அதற்கு அவன்: “இல்லை” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","அப்பொழுது யெகோவா பிலேயாமின் கண்களைத் திறந்தார்; வழியிலே நின்று உருவின பட்டயத்தைத் தம்முடைய கையிலே பிடித்திருக்கிற யெகோவாவுடைய தூதனை அவன் கண்டு, தலைகுனிந்து முகங்குப்புற விழுந்து பணிந்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","யெகோவாவுடைய தூதனானவர் அவனை நோக்கி: “நீ உன்னுடைய கழுதையை இதோடு மூன்றுமுறை அடித்தது ஏன்? உன்னுடைய வழி எனக்கு மாறுபாடாக இருக்கிறதினால், நான் உனக்கு எதிரியாகப் புறப்பட்டு வந்தேன். ");
INSERT INTO tam2017_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","கழுதை என்னைக் கண்டு, இந்த மூன்றுமுறை எனக்கு விலகியது; எனக்கு விலகாமல் இருந்திருந்தால், இப்பொழுது நான் உன்னைக் கொன்றுபோட்டு, கழுதையை உயிரோடு வைப்பேன்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","அப்பொழுது பிலேயாம் யெகோவாவுடைய தூதனை நோக்கி: “நான் பாவம்செய்தேன்; வழியிலே நீர் எனக்கு எதிராக நிற்கிறதை அறியாமலிருந்தேன்; இப்பொழுதும் உமது பார்வைக்கு இது பிரியமில்லாமல் இருந்தால், நான் திரும்பிப்போய்விடுகிறேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","யெகோவாவுடைய தூதனானவர் பிலேயாமை நோக்கி: “அந்த மனிதர்களோடு கூடப்போ; நான் உன்னோடு சொல்லும் வார்த்தையை மட்டும் நீ சொல்லவேண்டும்” என்றார்; அப்படியே பிலேயாம் பாலாகின் பிரபுக்களோடு கூடப்போனான். ");
INSERT INTO tam2017_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","பிலேயாம் வருகிறதைப் பாலாக் கேட்டவுடன், கடைசி எல்லையான அர்னோன் நதியின் ஓரத்திலுள்ள மோவாபின் பட்டணம்வரை அவனுக்கு எதிர்கொண்டு போனான். ");
INSERT INTO tam2017_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","பாலாக் பிலேயாமை நோக்கி: “உம்மை அழைக்கும்படி நான் ஆவலோடு உம்மிடத்தில் ஆள் அனுப்பவில்லையா? என்னிடத்திற்கு வராமல் இருந்தது ஏன்? ஏற்றபடி உமக்கு நான் மரியாதை செலுத்தமாட்டேனா என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","அப்பொழுது பிலேயாம் பாலாகை நோக்கி: “இதோ, உம்மிடத்திற்கு வந்தேன்; ஆனாலும், ஏதாவது சொல்வதற்கு என்னாலே ஆகுமோ? தேவன் என்னுடைய வாயிலே அளிக்கும் வார்த்தையையே சொல்லுவேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","பிலேயாம் பாலாகுடனே கூடப்போனான்; அவர்கள் கீரியாத் ஊசோத்தில் சேர்ந்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","அங்கே பாலாக் ஆடுமாடுகளை அடித்து, பிலேயாமுக்கும் அவனோடிருந்த பிரபுக்களுக்கும் அனுப்பினான். ");
INSERT INTO tam2017_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","மறுநாள் காலையில் பாலாக் பிலேயாமைக் கூட்டிக்கொண்டு, அவனைப் பாகாலுடைய மேடுகளில் ஏறச்செய்தான்; அந்த இடத்திலிருந்து பிலேயாம் ஜனத்தின் கடைசி முகாமைப் பார்த்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","பிலேயாம் பாலாகை நோக்கி: “நீர் இங்கே எனக்கு ஏழு பலிபீடங்களைக் கட்டி, ஏழு காளைகளையும் ஏழு ஆட்டுக்கடாக்களையும் இங்கே எனக்கு ஆயத்தப்படுத்தும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","பிலேயாம் சொன்னபடியே பாலாக் செய்தான்; பாலாகும் பிலேயாமும் ஒவ்வொரு பீடத்தில் ஒவ்வொரு காளையையும் ஒவ்வொரு ஆட்டுக்கடாவையும் பலியிட்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","பின்பு பிலேயாம் பாலாகை நோக்கி: “உம்முடைய சர்வாங்கதகனபலி அருகில் நில்லும், நான் போய்வருகிறேன்; யெகோவா வந்து என்னைச் சந்திப்பதாக இருக்கும்; அவர் எனக்கு வெளிப்படுத்துவதை உமக்கு அறிவிப்பேன் என்று சொல்லி, ஒரு மேட்டின்மேல் ஏறினான். ");
INSERT INTO tam2017_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","தேவன் பிலேயாமைச் சந்தித்தார்; அப்பொழுது அவன் அவரை நோக்கி: “நான் ஏழு பலிபீடங்களை ஆயத்தம்செய்து, ஒவ்வொரு பலிபீடத்தில் ஒவ்வொரு காளையையும் ஒவ்வொரு ஆட்டுக்கடாவையும் பலியிட்டேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","யெகோவா பிலேயாமின் வாயிலே வாக்கு அருளி: “நீ பாலாகினிடத்தில் திரும்பிப் போய், இந்த விதமாகச் சொல்லவேண்டும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","அவனிடம் அவன் திரும்பிப்போனான்; பாலாக் மோவாபுடைய எல்லா பிரபுக்களோடுங்கூட தன்னுடைய சர்வாங்கதகனபலி அருகிலே நின்று கொண்டிருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","அப்பொழுது அவன் தன்னுடைய வாக்கியத்தை எடுத்துரைத்து: “மோவாபின் ராஜாவாகிய பாலாக் என்னைக் கிழக்கு மலைகளிலுள்ள ஆராமிலிருந்து வரவழைத்து: நீ வந்து எனக்காக யாக்கோபைச் சபிக்கவேண்டும்; நீ வந்து இஸ்ரவேலை வெறுத்துவிடவேண்டும்” என்று சொன்னான். ");
INSERT INTO tam2017_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","தேவன் சபிக்காதவனை நான் சபிப்பதெப்படி? யெகோவா வெறுக்காதவனை நான் வெறுப்பதெப்படி? ");
INSERT INTO tam2017_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","உயரமான மலையிலிருந்து நான் அவனைக் கண்டு, குன்றுகளிலிருந்து அவனைப் பார்க்கிறேன்; அந்த மக்கள் தேசத்தோடு கலக்காமல் தனியே வாழ்வார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","“யாக்கோபின் தூளை எண்ணத்தக்கவன் யார்? இஸ்ரவேலின் காற்பங்கை எண்ணுகிறவன் யார்? நீதிமான் மரிப்பதுபோல் நான் மரிப்பேனாக, என்னுடைய முடிவு அவனுடைய முடிவுபோல் இருப்பதாக” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","அப்பொழுது பாலாக் பிலேயாமை நோக்கி: “நீர் எனக்கு என்ன செய்தீர்; என்னுடைய எதிரிகளைச் சபிக்கும்படி உம்மை அழைத்து வந்தேன்; நீர் அவர்களை ஆசீர்வதிக்கவே ஆசீர்வதித்தீர்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","அதற்கு அவன்: “யெகோவா என்னுடைய வாயில் அருளினதையே சொல்வது என்னுடைய கடமையல்லவா” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","பின்பு பாலாக் அவனை நோக்கி: “நீர் அவர்களைப் பார்க்கத்தக்க வேறொரு இடத்திற்கு என்னோடுகூட வாரும்; அங்கே அவர்கள் எல்லோரையும் பாரக்காமல், அவர்களுடைய கடைசி முகாமை மட்டும் பார்ப்பீர்; அங்கேயிருந்து எனக்காக அவர்களைச் சபிக்கவேண்டும்” என்று சொல்லி, ");
INSERT INTO tam2017_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","அவனைப் பிஸ்காவின் உச்சியில் இருக்கிற சோப்பீமின் வெளியிலே அழைத்துக்கொண்டுபோய், ஏழு பலிபீடங்களைக் கட்டி, ஒவ்வொரு பீடத்தில் ஒவ்வொரு காளையையும் ஒவ்வொரு ஆட்டுக்கடாவையும் பலியிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","அப்பொழுது பிலேயாம் பாலாகை நோக்கி: “இங்கே உம்முடைய சர்வாங்கதகனபலி அருகில் நில்லும்; நான் அங்கே போய்க் யெகோவாவைச் சந்தித்துவருகிறேன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","யெகோவா பிலேயாமைச் சந்தித்து, அவனுடைய வாயிலே வசனத்தை அருளி; “நீ பாலாகினிடம் திரும்பிப்போய், இந்த விதமாகச் சொல்லவேண்டும்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","அவனிடத்திற்கு அவன் வருகிறபோது, அவன் மோவாபின் பிரபுக்களோடுங்கூடத் தன்னுடைய சர்வாங்கதகனபலி அருகிலே நின்று கொண்டிருந்தான்; பாலாக் அவனை நோக்கி: “யெகோவா என்ன சொன்னார்” என்று கேட்டான். ");
INSERT INTO tam2017_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","அப்பொழுது அவன் தன்னுடைய வாக்கியத்தை எடுத்துரைத்து: “பாலாகே, எழுந்திருந்து கேளும்; சிப்போரின் மகனே, எனக்குச் செவிகொடும். ");
INSERT INTO tam2017_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","பொய் சொல்ல தேவன் ஒரு மனிதன் அல்ல; மனம்மாற அவர் ஒரு மனுபுத்திரனும் அல்ல; அவர் சொல்லியும் செய்யாமல் இருப்பாரா? அவர் வாக்களித்தும் நிறைவேற்றாமல் இருப்பாரா? ");
INSERT INTO tam2017_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","இதோ, ஆசீர்வதிக்கக் கட்டளை பெற்றேன்; அவர் ஆசீர்வதிக்கிறார், அதை நான் திருப்பக்கூடாது. ");
INSERT INTO tam2017_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","அவர் யாக்கோபிலே அக்கிரமத்தைக் காண்கிறதும் இல்லை, இஸ்ரவேலிலே குற்றம் பார்க்கிறதும் இல்லை; அவர்களுடைய தேவனாகிய யெகோவா அவர்களோடு இருக்கிறார்; ராஜாவின் வெற்றியின் கெம்பீரம் அவர்களுக்குள்ளே இருக்கிறது. ");
INSERT INTO tam2017_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","தேவன் அவர்களை எகிப்திலிருந்து புறப்படச்செய்தார்; காண்டாமிருகத்திற்கு இணையான பெலன் அவர்களுக்கு உண்டு. ");
INSERT INTO tam2017_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","யாக்கோபுக்கு விரோதமான மந்திரவாதம் இல்லை, இஸ்ரவேலுக்கு விரோதமான குறிசொல்லுதலும் இல்லை; தேவன் என்னென்ன செய்தார் என்று கொஞ்சக்காலத்திலே யாக்கோபையும் இஸ்ரவேலையும் குறித்துச் சொல்லப்படும். ");
INSERT INTO tam2017_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","அந்த மக்கள் கொடிய சிங்கம்போல எழும்பும், இளம்சிங்கம்போல நிமிர்ந்து நிற்கும்; அது தான் பிடித்த இரையைச் சாப்பிட்டு, வெட்டுண்டவர்களின் இரத்தத்தைக் குடிக்கும்வரை படுத்துக்கொள்வதில்லை” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","அப்பொழுது பாலாக் பிலேயாமை நோக்கி: “நீர் அவர்களைச் சபிக்கவும் வேண்டாம், அவர்களை ஆசீர்வதிக்கவும் வேண்டாம்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","அதற்குப் பிலேயாம் பாலாகைப் பார்த்து: “யெகோவா சொல்லுகிறபடியெல்லாம் செய்வேன் என்று உம்மோடு நான் சொல்லவில்லையா” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","அப்பொழுது பாலாக் பிலேயாமை நோக்கி: “வாரும், வேறொரு இடத்திற்கு உம்மை அழைத்துக்கொண்டு போகிறேன்; நீர் அங்கே இருந்தாவது எனக்காக அவர்களைச் சபிக்கிறது தேவனுக்குப் பிரியமாக இருக்கும்” என்று சொல்லி, ");
INSERT INTO tam2017_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","அவனை எஷிமோனுக்கு எதிராக இருக்கிற பேயோரின் உச்சிக்கு அழைத்துக்கொண்டு போனான். ");
INSERT INTO tam2017_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","அப்பொழுது பிலேயாம் பாலாகை நோக்கி: “இங்கே எனக்கு ஏழு பலிபீடங்களைக் கட்டி, இங்கே எனக்கு ஏழு காளைகளையும் ஏழு ஆட்டுக்கடாக்களையும் ஆயத்தம்செய்யும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","பிலேயாம் சொன்னபடி பாலாக் செய்து, ஒவ்வொரு பீடத்தில் ஒவ்வொரு காளையையும் ஒவ்வொரு ஆட்டுக்கடாவையும் பலியிட்டான். ");
INSERT INTO tam2017_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","இஸ்ரவேலை ஆசீர்வதிப்பதே யெகோவாவுக்குப் பிரியம் என்று பிலேயாம் பார்த்தபோது, அவன் முந்திச் செய்து வந்ததுபோல யெகோவாவைப் பார்க்கப் போகாமல், வனாந்திரத்திற்கு நேராகத் தன்னுடைய முகத்தைத் திருப்பி, ");
INSERT INTO tam2017_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","தன்னுடைய கண்களை ஏறெடுத்து, இஸ்ரவேல் தன்னுடைய கோத்திரங்களின்படியே முகாமிட்டிருக்கிறதைப் பார்த்தான்; தேவஆவி அவன்மேல் வந்தது. ");
INSERT INTO tam2017_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","அப்பொழுது அவன் தன்னுடைய வாக்கியத்தை எடுத்துரைத்து: “பேயோரின் மகனாகிய பிலேயாம் சொல்லுகிறதாவது, கண் திறக்கப்பட்டவன் உரைக்கிறதாவது, ");
INSERT INTO tam2017_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","தேவன் அருளும் வார்த்தைகளைக் கேட்டு, சர்வவல்லவரின் தரிசனத்தைக் கண்டு தாழவிழும்போது, கண் திறக்கப்பட்டவன் சொல்லுகிறதாவது, ");
INSERT INTO tam2017_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","யாக்கோபே, உன்னுடைய கூடாரங்களும், இஸ்ரவேலே, உன்னுடைய தங்குமிடங்களும் எவ்வளவு அழகானவைகள்! ");
INSERT INTO tam2017_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","அவைகள் பரவிப்போகிற ஆறுகளைப்போலவும், நதியோரத்திலுள்ள தோட்டங்களைப்போலவும், யெகோவா நாட்டின சந்தனமரங்களைப்போலவும், தண்ணீர் அருகே உள்ள கேதுரு மரங்களைப்போலவும் இருக்கிறது. ");
INSERT INTO tam2017_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","அவர்களுடைய வாளிகளிலிருந்து தண்ணீர் பாயும்; அவர்கள் விதை திரளான தண்ணீர்களில் பரவும்; அவர்களுடைய ராஜா ஆகாகை விட உயருவான்; அவர்களுடைய ராஜ்ஜியம் மேன்மையடையும். ");
INSERT INTO tam2017_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","தேவன் அவர்களை எகிப்திலிருந்து புறப்படச்செய்தார்; காண்டாமிருகத்திற்கு இணையான பெலன் அவர்களுக்கு உண்டு; அவர்கள் தங்களுடைய எதிரிகளாகிய தேசத்தை தின்று, அவர்களுடைய எலும்புகளை நொறுக்கி, அவர்களைத் தங்களுடைய அம்புகளாலே எய்வார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","சிங்கம்போலவும் கொடிய சிங்கம்போலவும் மடங்கிப் படுத்துக்கொண்டிருக்கிறார்கள்; அவர்களை எழுப்புகிறவன் யார்? உங்களை ஆசீர்வதிக்கிறவன் ஆசீர்வதிக்கப்பட்டவன், உங்களைச் சபிக்கிறவன் சபிக்கப்பட்டவன்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","அப்பொழுது பாலாக் பிலேயாமின்மேல் கோபம் வந்தவனாகி, கையோடு கைதட்டி, பிலேயாமை நோக்கி: “என்னுடைய எதிரிகளைச் சபிக்க உன்னை அழைத்து வந்தேன்; நீயோ இந்த மூன்றுமுறையும் அவர்களை ஆசீர்வதிக்கவே ஆசீர்வதித்தாய். ");
INSERT INTO tam2017_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","ஆகையால் உன்னுடைய இடத்திற்கு ஓடிப்போ; உன்னை மிகவும் மேன்மைப்படுத்துவேன் என்றேன்; நீ மேன்மை அடையாதபடி யெகோவா தடுத்தார் என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","அப்பொழுது பிலேயாம் பாலாகை நோக்கி: “பாலாக் எனக்குத் தன்னுடைய வீடு நிறைய வெள்ளியும் பொன்னும் கொடுத்தாலும், நான் என்னுடைய மனதாக நன்மையையோ தீமையையோ செய்கிறதற்குக் யெகோவாவின் கட்டளையை மீறக்கூடாது; யெகோவா சொல்வதையே சொல்வேன் என்று, ");
INSERT INTO tam2017_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","நீர் என்னிடத்திற்கு அனுப்பின தூதுவர்களிடத்தில் நான் சொல்லவில்லையா? ");
INSERT INTO tam2017_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","இதோ, நான் என்னுடைய மக்களிடத்திற்குப் போகிறேன்; பிற்காலத்திலே இந்த மக்கள் உம்முடைய மக்களுக்குச் செய்வது இன்னதென்று உமக்குத் தெரிவிப்பேன் வாரும்” என்று சொல்லி. ");
INSERT INTO tam2017_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","அவன் தன்னுடைய வாக்கியத்தை எடுத்துரைத்து: “பேயோரின் மகன் பிலேயாம் சொல்லுகிறதாவது, கண் திறக்கப்பட்டவன் உரைக்கிறதாவது, ");
INSERT INTO tam2017_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","தேவன் அருளும் வார்த்தைகளைக் கேட்டு, உன்னதமான தேவன் அளித்த அறிவை அறிந்து, உன்னதமான தேவனுடைய தரிசனத்தைக் கண்டு, தாழவிழும்போது, கண் திறக்கப்பட்டவன் சொல்லுகிறதாவது; ");
INSERT INTO tam2017_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","அவரைக் காண்பேன், இப்பொழுது அல்ல; அவரைத் தரிசிப்பேன், அருகாமையில் அல்ல; ஒரு நட்சத்திரம் யாக்கோபிலிருந்து உதிக்கும், ஒரு செங்கோல் இஸ்ரவேலிலிருந்து எழும்பும்; அது மோவாபின் எல்லைகளை நொறுக்கி, சேத் சந்ததி எல்லோரையும் நிர்மூலமாக்கும். ");
INSERT INTO tam2017_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ஏதோம் சுதந்தரமாகும், சேயீர் தன்னுடைய எதிரிகளுக்குச் சுதந்தரமாகும்; இஸ்ரவேல் பராக்கிரமம்செய்யும். ");
INSERT INTO tam2017_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","யாக்கோபிலிருந்து தோன்றும் ஒருவர் ஆளுகை செய்வார்; பட்டணங்களில் மீதியானவர்களை அழிப்பார்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","மேலும், அவன் அமலேக்கைப் பார்த்து, தன்னுடைய வாக்கியத்தை எடுத்துரைத்து: “அமலேக்கு முந்தியெழும்பினவன்; ஆனாலும் அவன் முடிவில் முற்றிலும் நாசமாவான் என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","அன்றியும் அவன் கேனியனைப் பார்த்து, தன்னுடைய வாக்கியத்தை எடுத்துரைத்து: “உன்னுடைய தங்குமிடம் பாதுகாப்பானது; உன்னுடைய கூட்டைக் கன்மலையில் கட்டினாய். ");
INSERT INTO tam2017_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","ஆகிலும் கேனியன் அழிந்துபோவான்; அசூர் உன்னைச் சிறைபிடித்துக்கொண்டுபோக எத்தனை நாட்கள் ஆகும்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","பின்னும் அவன் தன்னுடைய வாக்கியத்தை எடுத்துரைத்து: “ஐயோ, தேவன் இதைச்செய்யும்போது யார் பிழைப்பான்; ");
INSERT INTO tam2017_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","கித்தீமின் கடல் துறையிலிருந்து கப்பல்கள் வந்து, அசூரைச் சிறுமைப்படுத்தி, ஏபேரையும் வருத்தப்படுத்தும்; அவனும் முற்றிலும் அழிந்துபோவான்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","பின்பு பிலேயாம் எழுந்து புறப்பட்டு, தன்னுடைய இடத்திற்குத் திரும்பினான்; பாலாகும் தன்னுடைய வழியே போனான். ");
INSERT INTO tam2017_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","இஸ்ரவேல் சித்தீமிலே தங்கியிருக்கும்போது, மக்கள் மோவாபின் மகள்களோடு விபசாரம் செய்யத் தொடங்கினார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","அவர்கள் தங்களுடைய தெய்வங்களுக்கு செலுத்திய பலிகளை விருந்துண்ணும்படி மக்களை அழைத்தார்கள்; மக்கள் போய் சாப்பிட்டு, அவர்கள் தெய்வங்களைப் பணிந்துகொண்டார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","இப்படி இஸ்ரவேலர்கள் பாகால்பேயோரைப் பற்றிக்கொண்டார்கள்; அதனால் இஸ்ரவேலர்கள்மேல் யெகோவாவுடைய கோபம் வந்தது. ");
INSERT INTO tam2017_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","யெகோவா மோசேயை நோக்கி: “யெகோவாவுடைய கடுமையான கோபம் இஸ்ரவேலை விட்டு நீங்கும்படி நீ மக்களின் தலைவர் எல்லோரையும் கூட்டிக்கொண்டு, அப்படிச் செய்தவர்களைச் சூரிய வெளிச்சத்திலே யெகோவாவுடைய சந்நிதானத்தில் தூக்கில்போடும்படி செய் என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","அப்படியே மோசே இஸ்ரவேலின் நியாயாதிபதிகளை நோக்கி: “நீங்கள் அவரவர் பாகால்பேயோரைப் பற்றிக்கொண்ட உங்களுடைய மனிதர்களைக் கொன்றுபோடுங்கள்” என்றான். ");
INSERT INTO tam2017_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","அப்பொழுது மோசேயும் இஸ்ரவேல் மக்களாகிய சபையார் அனைவரும் ஆசரிப்புக் கூடாரத்தின்வாசலுக்கு முன்பாக அழுதுகொண்டு நிற்கும்போது, அவர்கள் கண்களுக்கு முன்பாக இஸ்ரவேல் மக்களில் ஒருவன் ஒரு மீதியானிய பெண்ணைத் தன்னுடைய சகோதரர்களிடம் அழைத்துக்கொண்டுவந்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","அதை ஆசாரியனாகிய ஆரோனின் மகனான எலெயாசாரின் மகன் பினெகாஸ் பார்த்தபோது, அவன் நடுச்சபையிலிருந்து எழுந்து, ஒரு ஈட்டியைத் தன்னுடைய கையிலே பிடித்து, ");
INSERT INTO tam2017_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","இஸ்ரவேலனாகிய அந்த மனிதன் விபசாரம்செய்யும் அறையிலே அவன் பின்னாலே போய், இஸ்ரவேல் மனிதனும் அந்த பெண்ணுமாகிய இருவருடைய வயிற்றிலும் ஈட்டி வெளியே போகுமளவுக்கு அவர்களைக் குத்திப்போட்டான்; அப்பொழுது இஸ்ரவேல் மக்களில் உண்டான வாதை நின்றுபோயிற்று. ");
INSERT INTO tam2017_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","அந்த வாதையால் இறந்தவர்கள் 24,000 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“நான் என்னுடைய எரிச்சலில் இஸ்ரவேல் மக்களை அழிக்காதபடி, ஆசாரியனாகிய ஆரோனின் மகனான எலெயாசாரின் மகன் பினெகாஸ், எனக்காக அவர்கள் நடுவில் பக்திவைராக்கியம் காண்பித்ததினால், இஸ்ரவேல் மக்கள்மேல் உண்டான என்னுடைய கடுங்கோபத்தை திருப்பினான். ");
INSERT INTO tam2017_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","ஆகையால், “இதோ, அவனுக்கு என்னுடைய சமாதானத்தின் உடன்படிக்கையைக் கட்டளையிடுகிறேன். ");
INSERT INTO tam2017_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","அவன் தன்னுடைய தேவனுக்காக பக்திவைராக்கியம் காண்பித்து, இஸ்ரவேல் மக்களுக்காகப் பாவநிவிர்த்தி செய்தபடியினால், அவனுக்கும் அவனுக்குப் பின்பு அவன் சந்ததிக்கும் நிரந்தர ஆசாரிய பட்டத்திற்குரிய உடன்படிக்கை உண்டாயிருக்கும் என்று சொல்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","மீதியானிய பெண்ணோடு குத்தப்பட்டு இறந்த இஸ்ரவேல் மனிதனுடைய பெயர் சிம்ரி; அவன் சல்லூவின் மகனும், சிமியோனியர்களின் தகப்பன் வம்சத்தில் ஒரு பிரபுவாகவும் இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","குத்தப்பட்ட மீதியானிய பெண்ணின் பெயர் கஸ்பி, அவள் சூரின் மகள், அவன் மீதியானியர்களுடைய தகப்பன் வம்சத்தாரான மக்களுக்குத் தலைவனாக இருந்தான். ");
INSERT INTO tam2017_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","யெகோவா மோசேயை நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“மீதியானியர்களை வீழ்த்தி அவர்களை வெட்டிப்போடுங்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","பேயோரின் காரியத்திலும் பேயோரினால் வாதை உண்டான நாளிலே குத்தப்பட்ட அவர்களுடைய சகோதரியாகிய கஸ்பி என்னும் மீதியான் பிரபுவினுடைய மகளின் காரியத்திலும், அவர்கள் உங்களுக்குச் செய்த துரோகங்களினால் உங்களை மோசம்போக்கி நெருக்கினார்களே” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","அந்த வாதை தீர்ந்தபின்பு, யெகோவா மோசேயையும் ஆரோனின் மகனும் ஆசாரியனுமாகிய எலெயாசாரையும் நோக்கி: ");
INSERT INTO tam2017_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“இஸ்ரவேல் மக்களின் எல்லா சபையாரையும் அவர்கள் பிதாக்களுடைய வம்சத்தின்படி இருபது வயதுமுதல் அதற்கு மேற்பட்ட இஸ்ரவேலிலே யுத்தத்திற்குப் புறப்படக்கூடியவர்கள் எல்லோரையும் எண்ணுங்கள்” என்றார். ");
INSERT INTO tam2017_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","அப்பொழுது மோசேயும் ஆசாரியனாகிய எலெயாசாரும் எரிகோவின் அருகே இருக்கும் யோர்தானுக்கு அருகிலே மோவாபின் சமவெளிகளிலே அவர்களோடு பேசி: ");
INSERT INTO tam2017_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“யெகோவா மோசேக்கும் எகிப்துதேசத்திலிருந்து புறப்பட்ட இஸ்ரவேல் மக்களுக்கும் கட்டளையிட்டிருக்கிறபடியே, இருபது வயது முதற்கொண்டிருக்கிறவர்களை எண்ணுங்கள்” என்றார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","ரூபன் இஸ்ரவேலின் மூத்த மகன்: ரூபனுடைய மகன்கள், ஆனோக்கியர்களின் குடும்பத்திற்குத் தகப்பனான ஆனோக்கும், பல்லூவியர்கள் குடும்பத்திற்குத் தகப்பனான பல்லூவும், ");
INSERT INTO tam2017_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","எஸ்ரோனியர்களின் குடும்பத்திற்குத் தகப்பனான எஸ்ரோனும், கர்மீயர்களின் குடும்பத்திற்குத் தகப்பனான கர்மீயுமே. ");
INSERT INTO tam2017_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","இவைகளே ரூபனியர்களின் குடும்பங்கள்; அவர்களில் எண்ணப்பட்டவர்கள் 43,730 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","பல்லூவின் மகன் எலியாப். ");
INSERT INTO tam2017_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","எலியாபின் மகன்கள் நேமுவேல், தாத்தான், அபிராம் என்பவர்கள்; இந்தத் தாத்தான் அபிராம் என்பவர்களே சபையில் பெயர்பெற்றவர்களாக இருந்து, யெகோவாவுக்கு எதிராகப் போராட்டம்செய்து, கோராகின் கூட்டாளிகளாகி, மோசேக்கும், ஆரோனுக்கும் எதிராக விவாதம்செய்தவர்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","பூமி தன்னுடைய வாயைத் திறந்து, அவர்களையும் கோராகையும் விழுங்கினதினாலும், அக்கினி 250 பேரை எரித்ததினாலும், அந்தக் கூட்டத்தார் செத்து, ஒரு அடையாளமானார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","கோராகின் மகன்களோ சாகவில்லை. ");
INSERT INTO tam2017_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","சிமியோனுடைய மகன்களின் குடும்பங்களாவன: நேமுவேலின் சந்ததியான நேமுவேலர்களின் குடும்பமும், யாமினியின் சந்ததியான, யாமினியர்களின் குடும்பமும், யாகீனின் சந்ததியான யாகீனியர்களின் குடும்பமும், ");
INSERT INTO tam2017_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","சேராகின் சந்ததியான சேராகியர்களின் குடும்பமும், சவுலின் சந்ததியான சவுலியர்களின் குடும்பமுமே. ");
INSERT INTO tam2017_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","இவைகளே சிமியோனியர்களின் குடும்பங்கள்; அவர்கள் 22,200 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","காத்துடைய மகன்களின் குடும்பங்களாவன: சிப்போனின் சந்ததியான சிப்போனியர்களின் குடும்பமும், அகியின் சந்ததியான ஆகியர்களின் குடும்பமும், சூனியின் சந்ததியான சூனியர்களின் குடும்பமும், ");
INSERT INTO tam2017_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ஒஸ்னியின் சந்ததியான ஒஸ்னியர்களின் குடும்பமும், ஏரியின் சந்ததியான ஏரியர்களின் குடும்பமும், ");
INSERT INTO tam2017_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","ஆரோதின் சந்ததியான ஆரோதியர்களின் குடும்பமும், அரேலியின் சந்ததியான அரேலியர்களின் குடும்பமுமே. ");
INSERT INTO tam2017_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","இவைகளே காத் சந்ததியின் குடும்பங்கள்; அவர்களில் எண்ணப்பட்டவர்கள் 40,500 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","யூதாவின் மகன்கள் ஏர், ஓனான் என்பவர்கள்; ஏரும், ஓனானும் கானான்தேசத்தில் செத்தார்கள். ");
INSERT INTO tam2017_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","யூதாவுடைய மற்ற மகன்களின் குடும்பங்களாவன: சேலாவின் சந்ததியான சேலாவியர்களின் குடும்பமும், பாரேசின் சந்ததியான பாரேசியர்களின் குடும்பமும், சேராவின் சந்ததியான சேராகியர்களின் குடும்பமுமே. ");
INSERT INTO tam2017_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","பாரேசுடைய மகன்களின் குடும்பங்களாவன: எஸ்ரோனின் சந்ததியான எஸ்ரோனியர்களின் குடும்பமும், ஆமூலின் சந்ததியான ஆமூலியர்களின் குடும்பமுமே. ");
INSERT INTO tam2017_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","இவைகளே யூதாவின் குடும்பங்கள்; அவர்களில் எண்ணப்பட்டவர்கள் 76,500 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","இசக்காருடைய மகன்களின் குடும்பங்களாவன: தோலாவின் சந்ததியான தோலாவியர்களின் குடும்பமும், பூவாவின் சந்ததியான பூவாவியர்களின் குடும்பமும், ");
INSERT INTO tam2017_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","யாசூபின் சந்ததியான யாசூபியர்களின் குடும்பமும், சிம்ரோனின் சந்ததியான சிம்ரோனியர்களின் குடும்பமுமே. ");
INSERT INTO tam2017_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","இவைகளே இசக்காரின் குடும்பங்கள்; அவர்களில் எண்ணப்பட்டவர்கள் அறுபத்து 64,300 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","செபுலோனுடைய மகன்களின் குடும்பங்களாவன: சேரேத்தின் சந்ததியான சேரேத்தியர்களின் குடும்பமும், ஏலோனின் சந்ததியான ஏலோனியர்களின் குடும்பமும், யாலேயேலின் சந்ததியான யாலேயேலியர்களின் குடும்பமுமே. ");
INSERT INTO tam2017_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","இவைகளே செபுலோனியர்களின் குடும்பங்கள்; அவர்களில் எண்ணப்பட்டவர்கள் 60,500 பேர். ");
INSERT INTO tam2017_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","யோசேப்புடைய மகனான மனாசே எப்பிராயீம் என்பவர்களின் குடும்பங்களாவன: ");
INSERT INTO tam2017_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","மனாசேயினுடைய மகன்களின் குடும்பங்கள்; மாகீரின் சந்ததியான மாகீரியர்களின் குடும்பமும், மாகீர் பெற்ற கீலேயாத்தின் சந்ததியான கிலெயாதியர்களின் குடும்பமும், ");
INSERT INTO tam2017_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","கீலேயாத் பெற்ற ஈயேசேர்களின் சந்ததியான ஈயேசேரியர்களின் குடும்பமும், ஏலேக்கின் சந்ததியான ஏலேக்கியர்களின் குடும்பமும், ");
INSERT INTO tam2017_vpl VALUES ("NU26_