﻿USE sofia;
DROP TABLE IF EXISTS sofia.tam2008_vpl;
CREATE TABLE tam2008_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tam2008_vpl WRITE;
INSERT INTO tam2008_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","துவக்கத்தில் தேவன் வானத்தையும் பூமியையும் படைத்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","பூமியானது வெறுமையாக இருந்தது; தண்ணீரின்மேல் இருள் சூழ்ந்திருந்தது. தேவ ஆவியானவர் அந்தத் தண்ணீரின்மேல் அசை வாடிக்கொண்டிருந்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","அப்பொழுது தேவன், “வெளிச்சம் உண்டாகட்டும்” என்றார். வெளிச்சம் உண்டாயிற்று. ");
INSERT INTO tam2008_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","தேவன் வெளிச்சத்தைப் பார்த்தார். அது நல்லதென்று அறிந்துகொண்டார். பிறகு தேவன் வெளிச்சத்தையும் இருளையும் வெவ்வேறாகப் பிரித்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","தேவன் வெளிச்சத்துக்குப் “பகல்” என்று பெயரிட்டார். அவர் இருளுக்கு “இரவு” என்று பெயரிட்டார். மாலையும் காலையும் ஏற்பட்டது. இதுவே முதல் நாளாயிற்று. ");
INSERT INTO tam2008_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","பிறகு தேவன், “இரண்டு பாகமாக தண்ணீர்ப் பகுதி பிரிந்து ஆகாய விரிவு உண்டாகக்கடவது!” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","தேவன் காற்றின் விரிவை உருவாக்கி, தண்ணீரைத் தனியாகப் பிரித்தார். தண்ணீரில் ஒரு பகுதி காற்றிற்கு மேலேயும், மறுபகுதி காற்றிற்குக் கீழேயும் ஆனது. ");
INSERT INTO tam2008_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","தேவன் காற்றின் விரிவுக்கு “வானம்” என்று பெயரிட்டார். மாலையும் காலையும் ஏற்பட்டது. இது இரண்டாம் நாள் ஆகும். ");
INSERT INTO tam2008_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","பிறகு தேவன், “வானத்தின் கீழே உள்ள தண்ணீரெல்லாம் ஓரிடத்தில் சேர்வதாக, அதனால் காய்ந்த நிலம் உண்டாகட்டும்” என்று சொன்னார். அது அவ்வாறே ஆயிற்று. ");
INSERT INTO tam2008_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","தேவன் அந்த காய்ந்த நிலத்துக்கு “பூமி” என்று பெயரிட்டார். ஒன்று சேர்ந்த தண்ணீருக்கு தேவன் “கடல்” என்று பெயரிட்டார். தேவன் இது நல்லது என்று கண்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","பிறகு தேவன், “பூமியில் புல்லும் விதைகளைத் தரும் செடிகளும் கனிதருகிற மரங்களும் உருவாகட்டும். கனிமரங்கள் விதைகளை உடைய கனிகளை உருவாக்கட்டும். ஒவ்வொரு செடிகொடிகளும் தங்கள் இனத்தை உண்டாக்கக்கடவது. இவை பூமியிலே வளரட்டும்” என்று சொன்னார். அவ்வாறே ஆயிற்று. ");
INSERT INTO tam2008_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","பூமி புல்லையும் தானியங்களைக் கொடுக்கும் செடிகளையும் முளைப்பித்தது. பூமி விதைகளைக்கொண்ட பழங்களைக் கொடுக்கும் மரங்களை முளைப்பித்தது. ஒவ்வொரு செடியும் தனக்கேயுரிய இனத்தை உருவாக்கியது. தேவன் இது நல்லதென்று கண்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","மாலையும் காலையும் ஏற்பட்டது. இது மூன்றாம் நாளாயிற்று. ");
INSERT INTO tam2008_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","பிறகு தேவன், “வானத்தில் வெளிச்சம் உண்டாகட்டும், இந்த வெளிச்சமானது பகலையும் இரவையும் பிரிக்கட்டும். இந்த வெளிச்சங்கள் காலங்களையும் நாட்களையும் ஆண்டுகளையும் குறிப்பதாக இருக்கட்டும். ");
INSERT INTO tam2008_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","இந்த வெளிச்சங்கள் வானத்திலிருந்து பூமிக்கு ஒளி தரட்டும்” என்றார். அது அவ்வாறே ஆயிற்று. ");
INSERT INTO tam2008_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","தேவன் இரண்டு மகத்தான ஒளிச்சுடர்களை உண்டுபண்ணினார். தேவன் பெரிய ஒளிச்சுடரைப் பகலை ஆண்டுகொள்ளவும், சிறிய ஒளிச்சுடரை இரவை ஆண்டுகொள்ளவும் செய்தார். நட்சத்திரங்களையும் தேவன் உருவாக்கினார். ");
INSERT INTO tam2008_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","தேவன் இந்த ஒளிச்சுடர்களைப் பூமிக்கு வெளிச்சம் தரும்படி வானத்தில் வைத்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","இரவையும் பகலையும் ஆள்வதற்கு இந்த ஒளிச்சுடர்களைத் தேவன் வானத்தில் ஏற்படுத்தினார். இவை வெளிச்சத்துக்கும் இருளுக்கும் வேறுபாட்டை உண்டாக்கிற்று. இது நல்லது என்று தேவன் கண்டுகொண்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","மாலையும் காலையும் ஏற்பட்டது. இது நான்காம் நாள். ");
INSERT INTO tam2008_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","பிறகு தேவன், “தண்ணீரானது திரளான உயிரினங்களை தோற்றுவிப்பதாக, பூமியிலும் வானத்திலும் பறப்பதற்காக பறவைகள் உருவாகட்டும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","பிறகு தேவன் கடலில் வாழும் பெரிய உயிரினங்களை உருவாக்கினார். கடலுக்குள் அலைந்து திரிகிற ஏராளமான உயிரினங்களைப் படைத்தார். பல்வேறு வகையான கடல் வாழ் உயிர்களையும் படைத்தார். வானத்தில் பறந்து திரிகிறதற்கு பல்வேறுவகைப் பறவைகளையும் படைத்தார். தேவன் இது நல்லது என்று கண்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","தேவன் அவைகளை ஆசீர்வதித்து, இனப் பெருக்கம் செய்து, எண்ணிக்கையில் விருத்தியடைந்து கடல் தண்ணீரை நிரப்புங்கள், மேலும் பறவைகள் பூமியில் பெருகட்டும் என்று சொன்னார். ");
INSERT INTO tam2008_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","மாலையும் காலையும் ஏற்பட்டது. இது ஐந்தாம் நாள் ஆயிற்று. ");
INSERT INTO tam2008_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","பிறகு தேவன், “பூமியானது, கால் நடைகள், ஊர்வன, காட்டு மிருகங்கள் முதலியனவற்றை அதனதன் இனத்திற்கு ஏற்ப தோற்றுவிப்பதாக” என்றார். அவை அப்படியே உண்டானது. ");
INSERT INTO tam2008_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","இவ்வாறு, தேவன் எல்லாவகையான மிருகங் களையும் படைத்தார். அவர் காட்டு மிருகங்களையும், வீட்டு மிருகங்களையும், பூமியில் ஊர்ந்து செல்லும் விதவிதமான உயிரினங்களையும் படைத்தார். இவை நல்லதென்று தேவன் கண்டுகொண்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","அதன் பிறகு தேவன், “நாம் மனுக்குலத்தை நமது சாயலில் உருவாக்குவோம். மனிதர்கள் நம்மைப்போலவே இருப்பார்கள். அவர்கள் கடலில் உள்ள எல்லா மீன்களையும், வானத்திலுள்ள பறவைகளையும் ஆண்டுகொள்ளட்டும். அவர்கள் பெரிய மிருகங்களையும் தரையில் ஊரும் உயிரினங்களையும் ஆண்டுகொள்ளட்டும்” என்று சொன்னார். ");
INSERT INTO tam2008_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","எனவே தேவன் தமது சொந்த சாயலிலேயே மனுகுலத்தைப் படைத்தார், தேவனுடைய சாயலாகவே அவர்களைப் படைத்தார். தேவன் அவர்களை ஆண் என்றும் பெண் என்றும் படைத்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","தேவன் அவர்களை ஆசீர்வதித்தார். அவர்களிடம், “பிள்ளைகளைப் பெற்று விருத்தியடையுங்கள், பூமியை நிரப்பி அதை ஆண்டுகொள்ளுங்கள். கடலில் உள்ள மீன்களையும் வானத்திலுள்ள பறவைகளையும் ஆண்டுகொள்ளுங்கள். பூமியில் அலைந்து திரிகின்ற அனைத்து உயிரினங்களையும் ஆண்டுகொள்ளுங்கள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","மேலும் தேவன், “நான் உங்களுக்குத் தானியங்களைத் தரும் அனைத்து வகைப் பயிரினங்களையும், எல்லாவகையான பழ மரங்களையும் தருகிறேன். அந்த மரங்கள் விதைகளோடு கூடிய கனிகளைத் தரும். அந்த விதைகளும் கனிகளும் உங்களுக்கு உணவாகும். ");
INSERT INTO tam2008_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","நான் புல் பூண்டுகளையெல்லாம் மிருகங்களுக்காகக் கொடுத்துள்ளேன். புல் பூண்டுகள் அவற்றுக்கு உணவாக இருக்கும். பூமியில் உள்ள அனைத்து மிருகங்களும் வானத்திலுள்ள அனைத்து பறவைகளும், தரையில் ஊர்கின்ற அனைத்து சிறு உயிரினங்களும் அவற்றை உணவாகக்கொள்ளும்” என்றார். அது அவ்வாறே ஆயிற்று. ");
INSERT INTO tam2008_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","தாம் உண்டாக்கிய அனைத்தும் மிக நன்றாக இருப்பதாக தேவன் கண்டார். மாலையும் காலையும் ஏற்பட்டது. இது ஆறாவது நாளாயிற்று. ");
INSERT INTO tam2008_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","பூமியும் வானமும் அவற்றிலுள்ள யாவும் படைக்கப்பட்டு முடிந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","தேவன் அனைத்து வேலைகளையும் செய்து முடித்தார். ஆகையால் ஏழாவது நாள் அவர் ஓய்வெடுத்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","தேவன் ஏழாவது நாளை ஆசீர்வதித்து அதனைப் பரிசுத்தமாக்கினார். அவர் அன்றைக்குத் தமது படைப்பு வேலைகளையெல்லாம் நிறைவு செய்துவிட்டு ஓய்வெடுத்ததால் அந்த நாள் சிறப்புக்குரியதாயிற்று. ");
INSERT INTO tam2008_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","இதுதான் பூமி மற்றும் வானம் தோன்றின வரலாறாகும். இதுதான் தேவனாகிய கர்த்தர் வானத்தையும் பூமியையும் படைக்கும்போது, நடந்தவற்றைப்பற்றிக் கூறும் விபரங்களாகும். ");
INSERT INTO tam2008_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","பூமியில் எந்தத் தாவரமும் இல்லாமல் இருந்தது. வயலிலும் அதுவரை எதுவும் வளரவில்லை. எந்தப் பகுதியிலும் எந்தச் செடிகொடிகளும் இல்லை. ஏனெனில் தேவனாகிய கர்த்தர் இன்னும் மண்ணில் மழை பெய்யச் செய்யவில்லை. பூமியில் விவசாயம் செய்ய மனுக்குலம் எதுவும் இல்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","பூமியிலிருந்து தண்ணீர் எழும்பி நிலத்தை நனைத்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","பிறகு தேவனாகிய கர்த்தர் பூமியிலிருந்து மண்ணை எடுத்து மனிதனை உருவாக்கினார். அவன் மூக்கில் தன் உயிர் மூச்சினை தேவனாகிய கர்த்தர் ஊதினார். அதனால் மனிதன் உயிர் பெற்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","பிறகு தேவனாகிய கர்த்தர் கிழக்குப் பகுதியில் ஒரு தோட்டத்தை அமைத்து அதற்கு ஏதேன் என்று பெயரிட்டார். தேவனாகிய கர்த்தர் தாம் உருவாக்கிய மனிதனை அத்தோட்டத்தில் வைத்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","தேவனாகிய கர்த்தர் எல்லாவகையான அழகான மரங்களையும், உணவுக் கேற்ற கனிதரும் மரங்களையும் தோட்டத்தில் வளரும்படிச் செய்தார். அத்தோட்டத்தின் நடுவில் தேவனாகிய கர்த்தர் ஜீவ மரத்தையும், நன்மை மற்றும் தீமை பற்றி அறிவு தருகிற மரத்தையும் வைத்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ஏதேன் தோட்டத்தில் தண்ணீர் பாய ஒரு ஆற்றையும் படைத்தார். அந்த ஆறு நான்கு சிறு ஆறுகளாகவும் பிரிந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","அந்த முதல் ஆற்றின் பெயர் பைசோன். அந்த ஆறு ஆவிலா நாடு முழுவதும் ஓடிற்று. ");
INSERT INTO tam2008_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","அந்த நாட்டில் தங்கம் இருந்தது. அத்தங்கம் நன்றாக இருந்தது. அங்கு வாசனைப் பொருள்களும் கோமேதகக் கல்லும் இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","இரண்டாவது ஆற்றின் பெயர் கீகோன். அது எத்தியோப்பியா நாடு முழுவதும் ஓடிற்று. ");
INSERT INTO tam2008_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","மூன்றாவது ஆற்றின் பெயர் இதெக்கேல் அது அசீரியாவுக்கு கிழக்கே பாய்ந்தது. நான்காவது ஆற்றின் பெயர் ஐபிராத்து. ");
INSERT INTO tam2008_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","தேவனாகிய கர்த்தர் மனிதனை ஏதேன் தோட்டத்தில் வைத்து, அதனைப் பராமரிக்கவும், காக்கவும் செய்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","தேவனாகிய கர்த்தர் மனிதனிடம், “இந்த தோட்டத்திலுள்ள எந்த மரத்தின் கனியை வேண்டுமானாலும் நீ உண்ணலாம். ");
INSERT INTO tam2008_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ஆனால் நன்மை தீமை பற்றிய அறிவைக் கொடுக்கக் கூடிய மரத்தின் கனியைமட்டும் உண்ணக் கூடாது. அதனை உண்டால் நீ மரணமடைவாய்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","மேலும் தேவனாகிய கர்த்தர், “ஒரு ஆண் தனியாக இருப்பது நல்லதல்ல, எனவே அவனுக்கு உதவியாக அவனைப்போன்று ஒரு துணையை உருவாக்குவேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","தேவனாகிய கர்த்தர் பூமியிலிருந்து மண்ணை எடுத்து காட்டிலுள்ள அனைத்து மிருகங்களையும், வானத்திலுள்ள அனைத்து பறவைகளையும் படைத்து அவைகளை மனிதனிடம் கொண்டு வந்தார். அவன் அவை ஒவ்வொன்றுக்கும் பெயர் வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","மனிதன் வீட்டு மிருகங்களுக்கும், வானில் பறக்கும் பறவைகளுக்கும், காட்டிலுள்ள மிருகங்களுக்கும் பெயர் வைத்தான். மனிதன் எல்லா மிருகங்களையும் பறவைகளையும் கண்டான். எனினும் அவனுக்கு ஏற்ற துணை காணவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","எனவே, தேவனாகிய கர்த்தர் அவனை ஆழ்ந்து தூங்க வைத்தார். அவன் தூங்கும்போது அவர் அவனது சரீரத்திலிருந்து ஒரு விலா எலும்பை எடுத்து, அந்த இடத்தை சதையால் மூடிவிட்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","தேவனாகிய கர்த்தர் அந்த விலா எலும்பை ஒரு பெண்ணாகப் படைத்து, அந்தப் பெண்ணை மனிதனிடம் அழைத்து வந்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","அப்பொழுது அவன், “இறுதியில் என்னைப்போலவே ஒருத்தி; அவளது எலும்பு என் எலும்பிலிருந்து உருவானவை. அவளது உடல் எனது உடலிலிருந்து உருவானது. அவள் மனிதனிலிருந்து எடுக்கப்பட்டாள். அதனால் அவளை மனுஷி என்று அழைப்பேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","அதனால் தான் மனிதன் தன் தாயையும் தகப்பனையும் விட்டு மனைவியோடு சேர்ந்துகொள்ளுகிறான். இதனால் இருவரும் ஒரே உடலாகிவிடுகின்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","மனிதனும் அவன் மனைவியும் நிர்வாணமாக இருந்தாலும் அவர்கள் வெட்கப்படவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","தேவனாகிய கர்த்தரால் படைக்கப்பட்ட விலங்குகளிலேயே பாம்பானது மிகவும் தந்திர குணமுள்ளதாயிருந்தது. அது அவளிடம், “பெண்ணே! தேவன் உங்களிடம் இத்தோட்டத்தில் உள்ள மரத்தின் பழங்களை உண்ணக்கூடாது என்று உண்மையில் கூறினாரா?” என்று கேட்டது. ");
INSERT INTO tam2008_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","அந்தப் பெண்ணும் பாம்புக்கு, “இல்லை! தேவன் அவ்வாறு சொல்லவில்லை. நாங்கள் இத்தோட்டத்தில் எல்லா மரங்களின் கனிகளையும் உண்ணலாம். ");
INSERT INTO tam2008_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ஆனால் ‘இத்தோட்டத்தின் நடுவிலுள்ள மரத்தின் கனியை உண்ணக் கூடாது. அம்மரத்தைத் தொடவும் கூடாது. இதை மீறினால் மரணமடைவீர்கள்’ என்று சொல்லியிருக்கிறார்” எனப் பதில் சொன்னாள். ");
INSERT INTO tam2008_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","ஆனால் பாம்போ அவளிடம், “நீங்கள் மரிக்கமாட்டீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","தேவனுக்குத் தெரியும், நீங்கள் அதன் கனியை உண்டால் உங்கள் கண்கள் திறக்கப்படும், நன்மை தீமை பற்றிய அறிவைப் பெறுவீர்கள். நீங்களும் தேவனைப்போன்று ஆவீர்கள்” என்றது. ");
INSERT INTO tam2008_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","அந்தப் பெண் அந்த மரம் அழகாக இருப்பதைக் கண்டாள். அதன் கனியும் உண்பதற்கு ஏற்றதாக இருப்பதை அறிந்தாள். அப்பழம் தன்னை அறிவாளியாக்கும் என்பதை எண்ணி அவள் பரவச மடைந்தாள். எனவே அவள் அம்மரத்தின் கனியை எடுத்து உண்டதுடன், அவள் தன் கணவனுக்கும் அதைக் கொடுத்தாள். அவனும் அதை உண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","இதனால் அவர்களின் கண்கள் திறந்தன. அவர்கள் தாங்கள் ஆடையில்லாமல் நிர்வாணமாக இருப்பதை அறிந்துகொண்டனர். எனவே அவர்கள் அத்தி மரத்தின் இலைகளை எடுத்து அவற்றைத் தைத்து ஆடையாக அணிந்துகொண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","பகலின் குளிர்ச்சியான வேளையில் தேவனாகிய கர்த்தர் அத்தோட்டத்தில் உலாவிக்கொண்டிருந்தார். மனிதனும், மனுஷியும் அவருடைய சத்தத்தைக் கேட்டுப் பயந்து தோட்டத்திலிருந்த மரங்களுக்கு இடையில் தங்களை மறைத்துக்கொண்டார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","ஆனால் தேவனாகிய கர்த்தர் மனிதனை அழைத்து, “நீ எங்கே இருக்கிறாய்?” என்று கேட்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","அதற்கு அவன், “நீர் தோட்டத்தில் நடந்து போவதைக் கண்டேன். எனக்குப் பயமாக உள்ளது. நான் நிர்வாணமாக இருப்பதால் மறைந்திருக்கிறேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","அப்பொழுது தேவனாகிய கர்த்தர் மனிதனிடம், “நீ நிர்வாணமாக இருப்பதாக யார் உனக்குச் சொன்னது? நீ உண்ண வேண்டாம் என்று நான் கூறியிருந்த மரத்தின் கனியை உண்டாயா?” என்று அவனிடம் கேட்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","அதற்கு அவன், “எனக்காக உம்மால் படைக்கப்பட்ட இந்தப் பெண் அந்த மரத்தின் கனியைக் கொடுத்தாள். நான் உண்டுவிட்டேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","பிறகு தேவனாகிய கர்த்தர் பெண்ணிடம், “நீ என்ன காரியத்தைச் செய்தாய்?” என்று கேட்டார். அதற்கு அவள், “பாம்பு என்னை வஞ்சித்துவிட்டது. எனவே நான் பழத்தை உண்டுவிட்டேன்” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","எனவே தேவனாகிய கர்த்தர் பாம்பிடம்: “நீ இந்தத் தீய செயலைச் செய்தபடியால், மற்ற எந்த மிருகத்தை விடவும் நீ மிகவும் துன்பப்படுவாய். நீ உன் வயிற்றாலேயே ஊர்ந்து திரிவாய். வாழ்நாள் முழுவதும் மண்ணைத் தின்று உயிர்வாழ்வாய். ");
INSERT INTO tam2008_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","உனக்கும் பெண்ணுக்கும் பகையை உண்டாக்குவேன். அதோடு உன் பிள்ளைகளுக்கும் அவள் பிள்ளைகளுக்கும் பகை உண்டாக்குவேன். அவள் பிள்ளையின் காலை நீ கடிப்பாய், அவர் உன் தலையை நசுக்குவார்” என்று சொன்னார். ");
INSERT INTO tam2008_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","பிறகு தேவனாகிய கர்த்தர் பெண்ணிடம்: “நீ கருவுற்றிருக்கும்போது உனது வேதனையை அதிகப்படுத்துவேன். அதுபோல் நீ பிரசவிக்கும்போதும் அதிக வேதனைப்படுவாய். உனது ஆசை உன் கணவன் மேலிருக்கும். அவன் உன்னை ஆளுகை செய்வான்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","பின்பு தேவனாகிய கர்த்தர் ஆணிடம்: “அந்த மரத்தின் கனியை உண்ணக் கூடாது என்று உனக்கு ஆணையிட்டிருந்தேன். ஆனால் நீ உன் மனைவியின் பேச்சைக் கேட்டு அந்த கனியை உண்டுவிட்டாய். ஆகையால் உன்னிமித்தம் இந்தப் பூமி சபிக்கப்பட்டிருக்கும். எனவே நீ உயிரோடு இருக்கும் நாளெல்லாம் மிகுந்த கஷ்டத்துடன் பூமியின் பலனைப் பெறுவாய். ");
INSERT INTO tam2008_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","இந்தப் பூமி உனக்கு முள்ளையும் களையையும் தரும். விளையும் பயிர்களை நீ உண்பாய். ");
INSERT INTO tam2008_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","உனது முகம் வேர்வையால் நிறையும்படி கஷ்டப்பட்டு உழைத்து உனது உணவை உண்பாய். மரிக்கும்வரை நீ கஷ்டப்பட்டு உழைப்பாய். உன்னை மண்ணால் உருவாக்கினேன். நீ மரிக்கும்போது மீண்டும் மண்ணுக்கே திரும்புவாய்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","ஆதாம் தன் மனைவிக்கு ஏவாள் என்று பெயரிட்டான். ஏனென்றால் அவள் உயிரோடுள்ள அனைவருக்கும் தாயாக விளங்குபவள். ");
INSERT INTO tam2008_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","தேவனாகிய கர்த்தர் மிருகங்களின் தோலை ஆடையாக்கி அவனுக்கும் அவளுக்கும் அணிந்துகொள்ளக் கொடுத்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","பின்பு தேவனாகிய கர்த்தர், “இதோ, நன்மை தீமை அறிந்தவனாக மனிதன் நம்மில் ஒருவரைப்போல் ஆனான். இப்பொழுது மனிதன் ஜீவமரத்தின் பழத்தை எடுத்து உண்டால் என்றென்றும் உயிருடன் இருப்பான்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","ஆகையால் அவர்களை தேவனாகிய கர்த்தர் ஏதேன் தோட்டத்தை விட்டு வெளியேற்றினார். ஆதாம் ஏதேன் தோட்டத்தை விட்டு வெளியேறி தான் உருவாக்கப்பட்ட மண்ணிலேயே உழைக்கும்படி வலியுறுத்தப்பட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","தேவனாகிய கர்த்தர் அவர்களை ஏதேன் தோட்டத்தை விட்டு துரத்திவிட்டு அதனைப் பாதுகாக்க தோட்டத்தின் நுழை வாசலில் கேருபீன்களை வைத்தார். அதோடு தேவனாகிய கர்த்தர் நெருப்பு வாளையும் வைத்தார். அது மின்னிக்கொண்டு, ஜீவமரத்துக்குச் செல்லும் வழியைச் சுற்றிக் காவல் செய்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","ஆதாமும் அவன் மனைவியும் பாலின உறவு கொண்டனர். அவள் கர்ப்பமுற்று காயீன் என்ற ஒரு மகனைப் பெற்றெடுத்து, நான், “கர்த்தரின் உதவியால் ஒரு மனிதனைப் பெற்றுள்ளேன்” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","அதன் பிறகு ஏவாள் இன்னொரு மகனைப் பெற்றாள். அவன் காயீனின் சகோதரனான ஆபேல். ஆபேல் ஒரு மேய்ப்பனாகவும், காயீன் ஒரு விவசாயியாகவும் வளர்ந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","4","அறுவடைக் காலத்தில் காயீன் தன் வயலில் விளைந்த தானியங்களைக் கர்த்தருக்குக் காணிக்கையாகக் கொண்டு போனான். ஆனால் ஆபேல் தன் மந்தையிலிருந்து சில சிறந்த ஆடுகளைக் கொண்டு போனான். கர்த்தர் ஆபேலையும், அவன் காணிக்கையையும் ஏற்றுக்கொண்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ஆனால் கர்த்தர் காயீனையும் அவன் காணிக்கைகளையும் ஏற்றுக்கொள்ளவில்லை. இதனால் காயீன் துக்கமும் கோபமும் கொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","கர்த்தர் அவனிடம், “ஏன் நீ கோபமாயிருக்கிறாய்? ஏன் உன் முகத்தில் கவலை தெரிகிறது. ");
INSERT INTO tam2008_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","நீ நன்மை செய்திருந்தால் எனக்கு விருப்பமானவனாக இருந்திருப்பாய். நானும் உன்னை ஏற்றுக்கொண்டிருப்பேன். ஆனால் நீ தீமை செய்தால் பிறகு அந்தப் பாவம் உன் வாழ்வில் இருக்கும். உனது பாவம் உன்னை அடக்கி ஆள விரும்பும். நீயோ உன் பாவத்தை அடக்கி ஆளவேண்டும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","காயீன் தனது சகோதரன் ஆபேலிடம். “வயலுக்குப் போவோம்” என்றான். அவர்கள் வயலுக்குப் போனார்கள். அங்கே காயீன் தன் தம்பியைத் தாக்கிக் கொலை செய்துவிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","பிறகு கர்த்தர் காயீனிடம், “உனது சகோதரன் ஆபேல் எங்கே?” என்று கேட்டார். அதற்கு அவன், “எனக்குத் தெரியாது. என் தம்பியைக் காவல் செய்வது என் வேலையில்லை” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","11","அதற்குக் கர்த்தர், “நீ என்ன காரியம் செய்தாய்? நீ உன் சகோதரனைக் கொன்றுவிட்டாய். பூமியிலிருந்து அவனது இரத்தம் என்னைக் கூப்பிடுகிறதே. இப்பொழுது அவனது இரத்தத்தை உன் கைகளிலிருந்து வாங்கிக்கொள்ள தன் வாயைத் திறந்த, இந்தப் பூமியில் நீ சபிக்கப்பட்டிருப்பாய். ");
INSERT INTO tam2008_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","கடந்த காலத்தில் நீ பயிர் செய்தவை நன்றாக விளைந்தன. ஆனால் இனிமேல் நீ பயிரிடுபவை விளையாதவாறு இந்த பூமி தடை செய்யும். இந்தப் பூமியில் நிலையில்லாமல் ஒவ்வொரு இடமாக அலைந்துகொண்டிருப்பாய்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","பிறகு காயீன், “என்னால் தாங்கிக்கொள்ள இயலாதவாறு இந்தத் தண்டனை அதிகமாக இருக்கிறது. ");
INSERT INTO tam2008_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","எனது பூமியை விட்டுப் போகுமாறு நீர் என்னை வற்புறுத்துகின்றீர். நான் உமது பார்வையிலிருந்து மறைவேன். எனக்கென்று ஒரு வீடு இருக்காது. பூமியில் ஒவ்வொரு இடமாக அலையும்படி நிர்பந்தப்படுத்தப்பட்டிருக்கிறேன். என்னைப் பார்க்கிறவன் எவனும் என்னைக் கொன்றுபோடுவானே” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","பிறகு கர்த்தர் காயீனிடம், “அவ்வாறு நடக்குமாறு நான் விடமாட்டேன். எவராவது உன்னைக் கொன்றால் நான் அவர்களை மிகுதியாகத் தண்டிப்பேன்” என்றார். ஆகையால் கர்த்தர் காயீன்மீது ஒரு அடையாளம் இட்டார். அதனால் எவரும் அவனைக் கொல்லமாட்டார்கள் என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","காயீன் கர்த்தரைவிட்டு விலகிப்போய் ஏதேனின் கிழக்கிலிருந்த நோத் என்னும் தேசத்தில் குடியிருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","காயீன் தன் மனைவியுடன் பாலின உறவு கொண்டபோது அவள் ஏனோக் என்னும் பெயருள்ள மகனைப் பெற்றாள். காயீன் ஒரு நகரத்தை உருவாக்கி அதற்குத் தன் மகனின் பெயரை வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ஏனோக்குக்கு ஈராத் என்னும் மகன் பிறந்தான். ஈராத்துக்கு மெகுயவேல் என்ற மகன் பிறந்தான். மெகுயவேலுக்கு மெத்தூசவேல் என்ற மகன் பிறந்தான். மெத்தூசவேலுக்கு லாமேக் என்ற மகன் பிறந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","லாமேக் இரண்டு பெண்களை மணந்துகொண்டான். ஒருத்தியின் பெயர் ஆதாள், இன்னொருத்தியின் பெயர் சில்லாள். ");
INSERT INTO tam2008_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ஆதாள் யாபாலைப் பெற்றாள். யாபால் கூடாரத்தில் வாழ்பவர்களுக்கும், மந்தையை மேய்க்கிறவர்களுக்கும் தந்தை ஆனான். ");
INSERT INTO tam2008_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","ஆதாளுக்கு யூபால் என்று இன்னொரு மகன் இருந்தான். அவன் கின்னரக்காரர் நாகசுரக்காரர் போன்றோருக்குத் தந்தை ஆனான். ");
INSERT INTO tam2008_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","சில்லாள் தூபால்-காயீனைப் பெற்றாள். அவன் பித்தளை, இரும்பு முதலியவற்றின் தொழிலாளர் யாவருக்கும் தந்தை ஆனான். தூபால் காயீனுக்கு, நாமாள் என்ற சகோதரி இருந்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","லாமேக்கு தன் மனைவிகளிடம், “ஆதாளே, சில்லாளே என் பேச்சைக் கேளுங்கள். நீங்கள் லாமேக்கின் மனைவியர், நான் சொல்வதைக் கவனியுங்கள். என்னை ஒருவன் துன்புறுத்தினான், அவனை நான் கொன்றேன். என்னுடன் இளைஞன் மோதினான், எனவே அவனையும் கொன்றேன். ");
INSERT INTO tam2008_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","காயீனின் கொலைக்காக கொடுக்கப்பட்ட தண்டனை மிகப்பெரியது. என்னைக் கொல்வதால் கிடைக்கும் தண்டனையும் மிக அதிகமாகவே இருக்கும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","ஆதாம் ஏவாளோடு பாலின் உறவு கொண்டான். ஏவாள் இன்னொரு மகனைப் பெற்றாள். அவனுக்குச் சேத் என்று பெயரிட்டனர். ஏவாள், “தேவன் எனக்கு இன்னொரு மகனைக் கொடுத்திருக்கிறார். காயீன் ஆபேலைக் கொன்றான். ஆனால் நான் சேத்தைப் பெற்றேன்” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","சேத்துக்கும் ஒரு மகன் பிறந்தான். அவனுக்கு ஏனோஸ் என்று பெயர் வைத்தான். அப்பொழுது மனிதர்கள் கர்த்தரிடத்தில் நம்பிக்கை வைக்க ஆரம்பித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","இது ஆதாமின் குடும்பத்தைப்பற்றி கூறுகின்ற பகுதி. தேவன் மனிதரைத் தம் சாயலிலேயே படைத்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","தேவன் அவர்களை ஆண் என்றும் பெண் என்றும் படைத்தார். தேவன் அவர்களைப் படைத்த அந்நாளிலேயே அவர்களை ஆசீர்வதித்து அவர்களுக்கு “மனிதர்” என்று பெயரிட்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","ஆதாமுக்கு 130 வயது ஆன பிறகு இன்னொரு மகன் பிறந்தான். அவன் ஆதாமைப்போலவே இருந்தான். ஆதாம் அவனுக்குச் சேத் என்று பெயர் வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","சேத் பிறந்த பிறகும்Ԕஆதாம் 800 ஆண்டுகள் வாழ்ந்தான். அக்காலத்தில் ஆதாமுக்கு ஆண்பிள்ளைகளும் பெண்பிள்ளைகளும் பிறந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","எனவே ஆதாம் மொத்தமாக 930 ஆண்டுகள் வாழ்ந்து, மரணமடைந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","சேத்துக்கு 105 வயதானபோது அவனுக்கு ஏனோஸ் என்ற மகன் பிறந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ஏனோஸ் பிறந்த பிறகு சேத் 807 ஆண்டுகள் வாழ்ந்தான். அக்காலத்தில் அவனுக்கு ஆண்பிள்ளைகளும் பெண் பிள்ளைகளும் பிறந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","சேத் மொத்தம் 912 ஆண்டுகள் வாழ்ந்து பிறகு மரணமடைந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ஏனோசுக்கு 90 வயதானபோது அவனுக்குக் கேனான் என்ற மகன் பிறந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","கேனான் பிறந்த பிறகு ஏனோஸ் 815 ஆண்டுகள் வாழ்ந்தான். அக்காலத்தில் அவனுக்கு ஆண்பிள்ளைகளும் பெண் பிள்ளைகளும் பிறந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ஏனோஸ் 905 ஆண்டுகள் வாழ்ந்து பின்னர் மரணமடைந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","கேனானுக்கு 70 வயதானபோது அவனுக்கு மகலாலேயேல் என்ற மகன் பிறந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","மகலாலேயேல் பிறந்த பிறகு கேனான் 840 ஆண்டுகள் வாழ்ந்தான். அப்போது அவனுக்கு ஆண் பிள்ளைகளும் பெண்பிள்ளைகளும் பிறந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","ஆகவே கேனான் 910 ஆண்டுகள் வாழ்ந்து மரணமடைந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","மகலாலேயேல் 65 வயதானபோது அவனுக்கு யாரேத் என்ற மகன் பிறந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","யாரேத் பிறந்த பின் மகலாலேயேல் 830 ஆண்டுகள் வாழ்ந்தான். அக்காலத்தில் அவனுக்கு ஆண்பிள்ளைகளும் பெண்பிள்ளைகளும் பிறந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","மகலாலேயேல் 895 ஆண்டுகள் வாழ்ந்து மரணமடைந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","யாரேத்துக்கு 162 வயதானபோது அவனுக்கு ஏனோக் என்ற மகன் பிறந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ஏனோக் பிறந்த பின் யாரேத் 800 ஆண்டுகள் வாழ்ந்தான். அக்காலத்தில் அவனுக்கு ஆண்பிள்ளைகளும் பெண் பிள்ளைகளும் பிறந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","யாரேத் மொத்தம் 962 ஆண்டுகள் வாழ்ந்து மரணமடைந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ஏனோக்குக்கு 65 வயதானபோது அவனுக்கு மெத்தூசலா என்ற மகன் பிறந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","மெத்தூசலா பிறந்தபின் ஏனோக் 300 ஆண்டுகள் தேவனோடு வழிநடந்தான். அக்காலத்தில் அவன் ஆண்பிள்ளைகளையும் பெண்பிள்ளைகளையும் பெற்றெடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","அவன் மொத்தம் 365 ஆண்டுகள் வாழ்ந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ஒரு நாள் ஏனோக் தேவனோடு நடந்துகொண்டிருக்கும்போதே அவன் மறைந்து போனான். தேவன் அவனை எடுத்துக்கொண்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","மெத்தூசலாவுக்கு 187 வயதானபோது அவனுக்கு லாமேக் என்ற மகன் பிறந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","லாமேக் பிறந்தபின் மெத்தூசலா 782 ஆண்டுகள் வாழ்ந்தான். அக்காலத்தில் அவனுக்கு ஆண்பிள்ளைகளும் பெண்பிள்ளைகளும் பிறந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","மெத்தூசலா 969 ஆண்டுகள் வாழ்ந்து மரணமடைந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","லாமேக்கிற்கு 182 வயதானபோது அவனுக்கு ஒரு மகன் பிறந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","அவனுக்கு நோவா என்று பெயரிட்டான். அவன், “நாம் விவசாயிகளாக பாடுபடுகிறோம். ஏனென்றால் தேவன் பூமியைச் சபித்திருக்கிறார். ஆனால் நோவா, நமக்கு இளைப்பாறுதலை அளிப்பான்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","நோவா பிறந்தபின், லாமேக் 595 ஆண்டுகள் வாழ்ந்தான். அக்காலத்தில் அவன் ஆண் பிள்ளைகளையும் பெண்பிள்ளைகளையும் பெற்றெடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","லாமேக் மொத்தம் 777 ஆண்டுகள் வாழ்ந்து மரண மடைந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","நோவாவுக்கு 500 வயதானபின் அவனுக்கு சேம், காம், யாப்பேத் என்னும் ஆண்பிள்ளைகள் பிறந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","4","பூமியில் ஜனங்கள் தொகை பெருக ஆரம்பித்தது. அவர்களுக்குப் பெண் பிள்ளைகள் ஏராளமாகப் பிறந்தனர். தேவ குமாரர்கள் மானிடப் பெண்களை அதிக அழகுள்ளவர்கள் எனக் கண்டு, தாங்கள் விரும்பியபடி பெண்களைத் தேர்ந்தெடுத்து மணந்துகொண்டனர். அப்பெண்களும் பிள்ளைகளைப் பெற்றனர். அந்நாட்களிலும், அதற்குப் பிறகும் இராட்சதர்கள் இருந்தார்கள். அவர்கள் பழங்காலத்திலிருந்தே புகழ்பெற்ற வீரர்களாகவும் இருந்தனர். கர்த்தர், “ஜனங்கள் மனிதப்பிறவிகளே, அவர்களால் என்றென்றைக்கும் எனது ஆவி துன்புறும்படி அனுமதிக்கமாட்டேன். அவர்கள் 120 ஆண்டுகள் வாழும்படி அனுமதிக்கிறேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","பூமியில் உள்ள மனிதர்கள் அனைவரும் பெரும் பாவிகளாக இருப்பதைக் கர்த்தர் அறிந்தார். அவர்கள் எல்லாக் காலத்திலும் பாவ எண்ணங்களையே கொண்டிருப்பதைக் கர்த்தர் பார்த்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","கர்த்தர் மனிதர்களைப் பூமியில் படைத்ததற்காக வருத்தப்பட்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","எனவே கர்த்தர், “பூமியில் நான் படைத்த அனைத்து மனிதர்களையும், மிருகங்களையும், ஊர்வனவற்றையும், வானத்தில் பறக்கும் பறவைகளையும் அழிக்கப் போகிறேன். ஏனென்றால் நான் இவற்றையெல்லாம் படைத்ததற்காக வருத்தப்படுகிறேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","ஆனால் கர்த்தருக்கு விருப்பமான வழியில் நடப்பவனாக நோவா என்னும் ஒரே ஒரு மனிதன் மட்டும் இருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","இது நோவாவின் குடும்பத்தைப்பற்றிக் கூறுகின்ற பகுதி. நோவா நேர்மையான மனிதனாக இருந்தான். அவன் தன்னைச் சுற்றியுள்ள ஜனங்களில் குற்றமற்றவனாக இருந்தான். அவன் எப்பொழுதும் தேவனைப் பின்பற்றி வாழ்ந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","அவனுக்கு சேம், காம், யாப்பேத் எனும் மூன்று மகன்கள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","தேவன் பூமியைப் பார்த்தார். அது மனிதர்களால் கெடுக்கப்பட்டிருப்பதை அறிந்தார். எங்கும் வன்முறை பரவியிருந்தது. ஜனங்கள் பாவிகளாகவும், கொடூரமானவர்களாகவும் மாறியிருந்தனர். அவர்கள் பூமியில் தம் வாழ்க்கையையும் கெடுத்திருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","எனவே, தேவன் நோவாவிடம், “எல்லோரும் பூமியில் பாவத்தையும் வன்முறையையும் பரவ வைத்துள்ளனர். எனவே நான் எல்லா உயிர்களையும் அழித்து, அவற்றை பூமியிலிருந்து விலக்குவேன். ");
INSERT INTO tam2008_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","கொப்பேர் மரத்தைப் பயன்படுத்தி நீயே ஒரு பெரிய கப்பலைச் செய். அதில் பல அறைகளை ஏற்படுத்து. உள்ளும் புறம்புமாகத் தார் பூசி விடு. ");
INSERT INTO tam2008_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","“கப்பல் 450 அடி நீளமும், 75 அடி அகலமும், 45 அடி உயரமும் இருக்கட்டும். ");
INSERT INTO tam2008_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","இதில் 18 அங்குலம் கூரையை விட்டு கீழே ஒரு ஜன்னல் இருக்கட்டும். கப்பலின் பக்கவாட்டில் ஒரு கதவு இருக்கட்டும். அதில் மேல்தளம், நடுத்தளம், கீழ்த்தளம் என்று மூன்று தளங்கள் இருக்கட்டும். ");
INSERT INTO tam2008_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“நான் உனக்குச் சொல்வதைக் கவனமாகக் கேள். நான் பூமியில் ஒரு பெரிய வெள்ளப் பெருக்கை ஏற்படுத்துவேன். வானத்துக்குக் கீழேயுள்ள அனைத்து உயிர்களையும் அழிப்பேன். மண்ணிலுள்ள அனைத்தும் மரணமடையும். ");
INSERT INTO tam2008_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","ஆனால் நான் உன்னோடு ஒரு சிறப்பான உடன்படிக்கையைச் செய்கிறேன். நீயும் உன் மனைவியும் உன் மகன்களும், மகன்களின் மனைவிமார்களும் கப்பலுக்குள் போய்விடுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","பூமியிலுள்ள அனைத்து உயிர்களிலும் ஆண், பெண் என இணையாகத் தேர்ந்தெடுத்துக்கொள். கப்பலில் அவைகள் உயிரோடு இருக்கட்டும். ");
INSERT INTO tam2008_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","ஒவ்வொரு பறவை இனங்களிலும் ஒவ்வொரு ஜோடியும், ஒவ்வொரு மிருக இனங்களிலும் ஒவ்வொரு ஜோடியும், எல்லா ஊர்வனவற்றிலும் ஒவ்வொரு ஜோடியும் கண்டு பிடித்து, அவற்றையும் உனது கப்பலில் உயிரோடு வைத்துக்கொள். ");
INSERT INTO tam2008_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","எல்லாவகை உணவுப் பொருட்களையும் கப்பலில் சேமித்து வை. அவ்வுணவு உங்களுக்கும் மற்ற மிருகங்களுக்கும் உதவியாக இருக்கட்டும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","நோவா தேவன் சொன்னபடி எல்லாவற்றையும் சரியாகச் செய்து முடித்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","பிறகு கர்த்தர் நோவாவிடம், “நீ நல்லவன் என்பதை, எல்லோரும் கெட்டுப்போன இக்காலத்திலும் கண்டிருக்கிறேன். ஆகையால் உனது குடும்பத்தினரை அழைத்துக்கொண்டு கப்பலுக்குள் செல். ");
INSERT INTO tam2008_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","பலிக்குரிய சுத்தமான விலங்குகளில் ஏழு ஜோடிகளைத் தேர்ந்தெடுத்துக்கொள். மற்ற மிருகங்களில் ஒரு ஜோடி போதும். இவற்றையெல்லாம் உனது கப்பலுக்குள் சேர்த்து வை. ");
INSERT INTO tam2008_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","பறவைகளில் ஒவ்வொரு வகையிலும் ஏழு ஜோடிகளைத் தேர்ந்தெடுத்துக்கொள். இதனால் மற்ற இனங்கள் அழிந்தாலும் இவை நிலைத்திருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","இன்றிலிருந்து ஏழு நாட்களானதும் பூமியில் பெருமழை பொழியச் செய்வேன். 40 இரவும் 40 பகலுமாக தொடர்ந்து மழை பொழியும். உலகில் வாழும் அனைத்து உயிர்களும் அழிந்துபோகும். என்னால் படைக்கப்பட்ட அனைத்தும் அழியும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","நோவா கர்த்தர் சொன்னபடி எல்லாவற்றையும் செய்து முடித்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","மழை பெய்தபோது நோவாவுக்கு 600 வயதாயிருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","நோவாவும் அவனது குடும்பத்தினரும் கப்பலுக்குள் சென்று வெள்ளத்திலிருந்து உயிர் பிழைத்தனர். நோவாவோடு அவனது மனைவியும் அவனது மகன்களும், மகன்களின் மனைவியரும் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","பலிக்குரிய மிருகங்களும் மற்ற மிருகங்களும் பறவைகளும் ஊர்வனவும், ");
INSERT INTO tam2008_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","நோவாவோடு கப்பலுக்குள் கொண்டுவரப்பட்டன. அவை ஆணும் பெண்ணுமாக ஜோடி ஜோடியாக தேவனுடைய ஆணையின்படி தேர்ந்தெடுக்கப்பட்டிருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ஏழு நாட்களானதும் வெள்ளப்பெருக்கு துவங்கியது. மழை தொடர்ந்து பெய்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","13","இரண்டாவது மாதத்தின் பதினேழாவது நாள் பூமிக்கடியில் உள்ள ஊற்றுகள் எல்லாம் திறந்து பீறிட்டுக் கிளம்பின. அன்று பெருமழையும் சேர்ந்து கொட்ட ஆரம்பித்தது. அது வானத்தின் ஜன்னல்கள் திறந்துகொண்டது போன்று இருந்தது. நாற்பது நாட்கள் இரவும் பகலுமாக மழை தொடர்ந்து பெய்தது. முதல் நாளே நோவாவும் அவனது மனைவியும் அவன் மகன்களான சேம், காம், யாப்பேத் ஆகியோரும் அவர்களது மனைவிமாரும் கப்பலுக்குள் சென்றுவிட்டனர். அப்போது நோவாவுக்கு 600 வயது. ");
INSERT INTO tam2008_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","அவர்களும் எல்லாவகை மிருகங்களும் கப்பலுக்குள் இருந்தனர். எல்லா வகை மிருகங்களும், எல்லாவகைப் பறவைகளும், எல்லாவகை ஊர்வனவும் கப்பலுக்குள் இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","இவை எல்லாம் நோவாவோடு கப்பலுக்குள் சென்றன. அவைகள் எல்லா மிருக வகைகளிலிருந்தும் ஜோடி, ஜோடியாக வந்தன. ");
INSERT INTO tam2008_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","இந்த மிருகங்கள் எல்லாம் இரண்டு இரண்டாக, கப்பலுக்குள் சென்றன. தேவனுடைய ஆணையின்படியே அவை கப்பலுக்குள் சென்றன. பிறகு கர்த்தர் கப்பலின் கதவை அடைத்துவிட்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","பூமியில் 40 நாட்கள் தொடர்ந்து வெள்ளம் பெருகியது. அவ்வெள்ளம் கப்பலைத் தரையிலிருந்து மேல் நோக்கிக் கிளப்பியது. ");
INSERT INTO tam2008_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","வெள்ளம் தொடர்ந்து ஏறியது. அதனால் கப்பல் தண்ணீரில் மிதக்க ஆரம்பித்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","உயரமான மலைகளும் மூழ்கும்படி வெள்ளம் உயர்ந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","வெள்ளம் மலைகளுக்கு மேலும் உயர்ந்தது. அதன் உயரம் மலைகளுக்கு மேல் 20 அடி இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","22","உலகில் உள்ள அனைத்து உயிர்களும் மரித்தன. எல்லா ஆண்களும் பெண்களும், பறவைகளும், எல்லா மிருகங்களும், எல்லா ஊர்வனவும் மரித்தன. தரையில் வாழக்கூடிய அனைத்து உயிர்களும் மரித்துப்போயின. ");
INSERT INTO tam2008_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","இவ்வாறு தேவன் பூமியை அழித்தார். தேவன் பூமியில் உயிருள்ள அனைத்தையும் மனிதன், மிருகம், ஊர்ந்து செல்லும் பிராணிகள், பறவைகள் உட்பட எல்லாவற்றையும் பூமியிலிருந்து முற்றிலுமாய் அழித்தார். நோவாவும் அவனது குடும்பத்தினரும் அவனோடு கப்பலிலிருந்த பறவைகளும், மிருகங்களும் மட்டுமே உயிர் பிழைத்தன. ");
INSERT INTO tam2008_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","வெள்ளமானது தொடர்ந்து 150 நாட்கள் பூமியில் பரவியிருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ஆனால் தேவன் நோவாவை மறக்கவில்லை. தேவன் அவனையும் அவனது குடும்பத்தினரையும் அவனோடு கப்பலிலுள்ள விலங்குகளையும் நினைவுகூர்ந்தார். பூமியின்மீது காற்று வீசுமாறு செய்தார். தண்ணீரெல்லாம் மறையத்தொடங்கியது. ");
INSERT INTO tam2008_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","வானிலிருந்து பெய்த மழை நின்றது. ");
INSERT INTO tam2008_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","4","பூமியின் மீதிருந்த தண்ணீர் கீழே செல்லத் துவங்கியது. 150 நாட்கள் ஆனதும் மீண்டும் கப்பல் பூமியைத் தொடுகிற அளவிற்குக் குறைந்து போனது. கப்பல் அரராத் என்ற மலைமீது அமர்ந்தது. அது ஏழாவது மாதத்தின் 17வது நாள். ");
INSERT INTO tam2008_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","வெள்ளமானது மேலும் மேலும் கீழே போயிற்று. பத்தாவது மாதத்தின் முதல் நாளில் அனைத்து மலைகளின் மேல்பாகமெல்லாம் தெரிய ஆரம்பித்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","நாற்பது நாட்களுக்குப் பிறகு நோவா கப்பலின் ஜன்னலைத் திறந்து, ");
INSERT INTO tam2008_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ஒரு காகத்தை வெளியே அனுப்பினான். அது பூமியிலுள்ள தண்ணீர் வற்றிப்போகும்வரை போவதும் வருவதுமாக இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","நோவா ஒரு புறாவையும் வெளியே அனுப்பினான். அது தான் தங்கிட ஒரு வறண்ட இடத்தைக் கண்டுக்கொள்ளும் என எண்ணினான். இதன் மூலம் பூமியில் தண்ணீர் வற்றிவிட்டதா என்பதை அறிந்துகொள்ளலாம் என நினைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ஆனால் தண்ணீர் இன்னும் பூமியில் பரவியிருந்தது. எனவே புறா மீண்டும் கப்பலுக்கே திரும்பி வந்தது. நோவா அதனைத் தன் கையை நீட்டிப் பிடித்து கப்பலுக்குள் சேர்த்துக்கொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","ஏழு நாட்களானதும் நோவா மீண்டும் புறாவை அனுப்பினான். ");
INSERT INTO tam2008_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","அன்று மாலையில் அப்புறா மீண்டும் திரும்பி வந்தது. அதன் வாயில் ஒலிவ மரத்தின் புதிய இலை இருந்தது. இதன் மூலம் அவன் தண்ணீர் வற்றிவிட்டது என்பதை அறிந்துக்கொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","மேலும் 7 நாட்கள் ஆனதும் மீண்டும் புறாவை வெளியே அனுப்பினான். ஆனால் அது திரும்பி வரவே இல்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","அதன் பிறகு நோவா கப்பலின் கதவைத் திறந்தான். தரை காய்ந்துபோனதை நோவா தெரிந்துகொண்டான். இதுதான் அந்த ஆண்டின் முதல் மாதத்தின் முதல் நாளாக ஆயிற்று. நோவா 601 வயதுடையவன் ஆனான். ");
INSERT INTO tam2008_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","இரண்டாவது மாதத்தின் 27வது நாளில் தரை முழுவதும் நன்றாகக் காய்ந்துவிட்டது. ");
INSERT INTO tam2008_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","பிறகு தேவன் நோவாவிடம், ");
INSERT INTO tam2008_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“நீயும் உன் மனைவியும் உன் மகன்களும் அவர்களின் மனைவியரும் இப்போது கப்பலை விட்டு வெளியே வாருங்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","உங்களோடுள்ள அனைத்தையும் வெளியே கொண்டு வாருங்கள். பறவைகள், விலங்குகள், ஊர்வன அனைத்தும் மீண்டும் குட்டிகளும் குஞ்சுகளும் இட்டு பூமியை நிரப்பட்டும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","எனவே நோவா தன் மனைவி, மகன்கள், மருமகள்கள் ஆகியோரோடு வெளியே வந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","கப்பலிலுள்ள அனைத்து மிருகங்களும் பறவைகளும் ஊர்வனவும் எல்லா விலங்கினங்களும் கப்பலை விட்டு ஜோடிகளாக வெளியே வந்தன. ");
INSERT INTO tam2008_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","பிறகு நோவா கர்த்தருக்கு ஓர் பலிபீடத்தைக் கட்டினான். அவன் பலிக்குரிய சுத்தமான மிருகங்களையும், பறவைகளையும் தேர்ந்தெடுத்து தேவனுக்குப் பலியிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","கர்த்தர் அதன் வாசனையை முகர்ந்தார். அது அவருக்கு விருப்பமாக இருந்தது. கர்த்தர் தமக்குள், “மனிதர்களைத் தண்டிக்க நான் மீண்டும் இது போன்று பூமியைச் சபிக்கமாட்டேன். ஜனங்கள் இளமை முதலாகவே பாவத்தில் இருக்கிறார்கள். நான் செய்ததுபோல, மீண்டும் ஒருமுறை உயிர்களை அழிக்கமாட்டேன். ");
INSERT INTO tam2008_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","பூமி தொடர்ந்து இருக்கும் காலம்வரை நடுவதற்கென்று ஒரு காலமும், அறுவடைக்கென்று ஒரு காலமும் இருக்கும். பூமியில் குளிரும் வெப்பமும், கோடையும் வசந்தமும், இரவும் பகலும் இருக்கும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","தேவன் நோவாவையும் அவனது பிள்ளைகளையும் ஆசீர்வதித்தார். தேவன் அவர்களிடம், “குழந்தைகளைப் பெற்று, ஜனங்களால் இப்பூமியை நிரப்புங்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","பூமியிலுள்ள அனைத்து மிருகங்களும், வானத்திலுள்ள அனைத்து பறவைகளும், தண்ணீரிலுள்ள அனைத்து மீன்களும், பிற அனைத்து ஊர்வனவும் உங்களைக் கண்டு அஞ்சும், அவை உங்கள் அதிகாரத்திற்குள் இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","கடந்த காலத்தில் பச்சையானதாவரங்களை உங்களுக்கு உணவாகக் கொடுத்தேன். இப்போது அனைத்து மிருகங்களும் உங்களுக்கு உணவாகட்டும். உலகிலுள்ள அனைத்தும் உங்களுக்காகக் கொடுக்கப்பட்டிருக்கிறது. ");
INSERT INTO tam2008_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","ஆனால் உங்களுக்கு ஒரு ஆணை இடுகிறேன். இறைச்சியை அதின் உயிராகிய இரத்தத்துடன் உண்ணாதீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","நான் உங்களது உயிருக்காக உங்களது இரத்தத்தைக் கேட்பேன். அதாவது ஒரு மனிதனைக் கொல்லுகிற விலங்கின் இரத்தத்தைக் கேட்பேன். மேலும் மற்றொரு மனிதனைக் கொல்லுகிற மனிதனின் இரத்தத்தைக் கேட்பேன். ");
INSERT INTO tam2008_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“தேவன் மனிதனைத் தமது சாயலாகவேப் படைத்தார். எனவே மற்றவனைக் கொல்லுகிற எவனும் இன்னொருவரால் கொல்லப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“நோவா, நீயும் உன் மகன்களும் குழந்தைகளைப் பெற்று, உங்கள் ஜனங்களால் பூமியை நிரப்புங்கள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","பிறகு தேவன் நோவாவிடமும் அவனது பிள்ளைகளிடமும், ");
INSERT INTO tam2008_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“நான் உங்களோடும் உங்களுக்குப் பின்னுள்ள வாரிசுகளோடும், ");
INSERT INTO tam2008_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","உங்களோடு கப்பலிலே இருந்த பறவைகளோடும் மிருகங்களோடும் ஊர்வனவற்றோடும் பூமியில் உள்ள அனைத்து உயிர்களோடும் எனது உடன்படிக்கையை ஏற்படுத்திக்கொள்கிறேன். ");
INSERT INTO tam2008_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","வெள்ளப்பெருக்கால் பூமியில் உள்ள அனைத்து உயிர்களும் அழிக்கப்பட்டன. ஆனால் மீண்டும் இது போல் நடைபெறாது. இன்னொரு வெள்ளப் பெருக்கு பூமியில் உள்ள உயிர்களை அழிக்காது” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","மேலும் தேவன், “உங்களுக்குக் கொடுத்த வாக்குறுதிக்கு அடையாளமாக ஒன்றை உங்களுக்குத் தருகிறேன். உன்னோடும் பூமியில் வாழும் ஒவ்வொரு உயிரோடும் நான் செய்துகொண்ட உடன்படிக்கைக்கு அது அத்தாட்சியாக இருக்கும். இந்த உடன்படிக்கை இனிவரும் எல்லாக் காலத்துக்கும் உரியதாக இருக்கும். இதுவே அந்த அத்தாட்சி. ");
INSERT INTO tam2008_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","மேகங்களுக்கு இடையே ஒரு வானவில்லை உருவாக்கி உள்ளேன். எனக்கும் பூமிக்குமான உடன்படிக்கைக்கு இதுவே அத்தாட்சி. ");
INSERT INTO tam2008_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","பூமிக்கு மேலாய் மேகங்களைக் கொண்டு வரும்போதெல்லாம் நீங்கள் அதில் வானவில்லைப் பார்க்கலாம். ");
INSERT INTO tam2008_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","வானவில்லைப் பார்க்கும்போதெல்லாம் நான் எனக்கும் உங்களுக்கும் மற்ற உயிர்களுக்கும் இடையில் ஏற்படுத்திக்கொண்ட உடன்படிக்கையை நினைத்துக்கொள்வேன். அந்த உடன்படிக்கை இனி ஒரு வெள்ளப் பெருக்கு உலகில் தோன்றி இங்குள்ள உயிர்களை அழிக்காது என்று கூறுகிறது. ");
INSERT INTO tam2008_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","மேகங்களுக்கிடையில் நான் வானவில்லைப் பார்க்கும்போதெல்லாம் எனக்கும் பூமியின் மீதுள்ள அனைத்து உயிர்களுக்குமிடையிலான நிரந்தரமான உடன்படிக்கையை நினைத்துக்கொள்வேன்.” ");
INSERT INTO tam2008_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","“நான் பூமியில் உள்ள அனைத்து உயிர்களோடும் செய்துகொண்ட உடன்படிக்கைக்கு அத்தாட்சியாக வானவில் விளங்குகிறது” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","நோவாவின் மகன்கள் கப்பலைவிட்டு வெளியே வந்தனர். அவர்களின் பெயர் சேம், காம், யாப்பேத் ஆகும். காம், கானானின் தந்தை. ");
INSERT INTO tam2008_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","இந்த மூன்று பேரும் நோவாவின் மகன்கள். பூமியில் உள்ள அனைத்து ஜனங்களும் அவர்களது வம்சமேயாகும். ");
INSERT INTO tam2008_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","நோவா ஒரு விவசாயி ஆனான். அவன் ஒரு திராட்சைத் தோட்டத்தைப் பயிர் செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","நோவா அதில் திராட்சை ரசத்தைச் செய்து குடித்தான். அவன் போதையில் தன் கூடாரத்தில் ஆடையில்லாமல் விழுந்து கிடந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","கானானின் தந்தையான காம் ஆடையற்ற தனது தந்தையைப் பார்த்து அதைக் கூடாரத்திற்கு வெளியே இருந்த தன் சகோதரர்களிடம் சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","சேமும் யாப்பேத்தும் ஒரு ஆடையை எடுத்து தங்கள் முதுகின் மேல் போட்டுக்கொண்டு பின்னால் நடந்து கூடாரத்திற்குள் நுழைந்து அதைத் தங்கள் தகப்பன் மேல் போட்டார்கள். இவ்வாறு தந்தையின் நிர்வாணத்தைப் பார்க்காமல் தவிர்த்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","திராட்சை ரசத்தைக் குடித்ததினால் தூங்கிய நோவா எழுந்ததும் தனது இளைய மகனான காம் செய்தது அவனுக்குத் தெரியவந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","எனவே அவன், “கானான் சபிக்கப்பட்டவன். அவன் தன் சகோதரர்களுக்கு அடிமையிலும் அடிமையாக இருப்பான்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","மேலும், “சேமுடைய தேவனாகிய கர்த்தர் துதிக்கப்படுவாராக. கானான் சேமுடைய அடிமையாய் இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","தேவன் யாப்பேத்துக்கு மேலும் நிலங்களைக் கொடுப்பார். தேவன் சேமுடைய கூடாரத்தில் இருப்பார். இவர்களின் அடிமையாகக் கானான் இருப்பான்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","வெள்ளப் பெருக்குக்குப் பிறகு நோவா 350 ஆண்டுகள் வாழ்ந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","அவன் மொத்தம் 950 ஆண்டுகள் வாழ்ந்து மரண மடைந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","சேம், காம், யாப்பேத் ஆகியோர் நோவாவின் மகன்கள். வெள்ளப் பெருக்குக்குப் பின் இவர்கள் மேலும் பல பிள்ளைகளுக்குத் தந்தை ஆனார்கள். இங்கே அவர்களின் பிள்ளைகள் பற்றிய பட்டியல் கொடுக்கப்பட்டுள்ளது. ");
INSERT INTO tam2008_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","கோமர், மாகோகு, மாதாய், யாவான், தூபால், மேசேக்கு, தீராஸ் ஆகியோர் யாப்பேத்தின் மகன்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","அஸ்கினாஸ், ரீப்பாத்து, தொகர்மா ஆகியோர் கோமரின் மகன்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","எலீசா, தர்ஷீஸ், கித்தீம், தொதானீம் ஆகியோர் யாவானின் மகன்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","மத்தியத்தரைக் கடல் பகுதியில் வாழ்ந்த ஜனங்கள் யாப்பேத்தின் வழி வந்தவர்கள். ஒவ்வொரு மகனும் தனக்குரிய சொந்த நிலத்தைப் பெற்றிருந்தான். ஒவ்வொரு குடும்பமும் பெருகி வெவ்வேறு நாடுகளாயின. ஒவ்வொரு நாடும் தனக்கென்று ஒரு தனி மொழியைப் பெற்றது. ");
INSERT INTO tam2008_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","கூஷ், மிஸ்ராயீம், பூத், கானான் ஆகியோர் காமின் பிள்ளைகள். ");
INSERT INTO tam2008_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","சேபா, ஆவிலா, சப்தா, ராமா, சப்திகா, ஆகியோர் கூஷின் பிள்ளைகள். சேபா, திதான் ஆகியோர் ராமாவின் பிள்ளைகள். ");
INSERT INTO tam2008_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","கூஷ் நிம்ரோத்தை பெற்றான். நிம்ரோத் பூமியில் மிக வல்லமை மிக்க வீரன் ஆனான். ");
INSERT INTO tam2008_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","இவன் கர்த்தருக்கு முன்னால் பெரிய வேட்டைக்காரனாக இருந்தான். இதனால் “கர்த்தருக்கு முன்பாகப் பலத்த வேட்டைக்காரனான நிம்ரோத்தைப்போல” என்ற வழக்குச்சொல் உண்டானது. ");
INSERT INTO tam2008_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","நிம்ரோத்தின் அரசாட்சி பாபேலிலிருந்து ஏரேக், அக்காத், சிநெயார் நாட்டிலுள்ள கல்னேவரை பரவியிருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","நிம்ரோத் அசீரியாவுக்குப் போனான், அங்கு நினிவே, ரெகொபோத், காலாகு, ரெசேன் ஆகிய நகரங்களைக் கட்டினான். ");
INSERT INTO tam2008_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","(ரெசேன் நகரமானது நினிவேக்கும் காலாகுக்கும் இடைப்பட்ட பெரிய நகரம்) ");
INSERT INTO tam2008_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","லூதி, ஆனாமீ, லெகாபீ, நப்தூகீம், ");
INSERT INTO tam2008_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","பத்ருசீம், பெலிஸ்தர், கஸ்லூ, கப்தொர் ஆகியோரின் தந்தை மிஸ்ராயீம். ");
INSERT INTO tam2008_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","கானான் சீதோனின் தந்தையானான். இவன் கானானின் மூத்தமகன். கானான் கேத்துக்கும் தந்தை. கேத் கேத்தியர்களின் தந்தை ஆனான். ");
INSERT INTO tam2008_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","எபூசியர், எமோரியர், கிர்காசியர், ");
INSERT INTO tam2008_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ஈவியர், அர்க்கீரியர், சீநியர், ");
INSERT INTO tam2008_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","அர்வாதியர், செமாரியர், காமாத்தியர், ஆகியோருக்கும் கானான் தந்தை ஆனான். இவனது சந்ததியினர் உலகின் பல பாகங்களிலும் பரவினர். ");
INSERT INTO tam2008_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","கானான் தேசத்தில் இருந்தவர்களுக்கு தம் எல்லையாக சீதோன் முதல் கேரார் வழியாய்க் காசா மட்டும், அது முதல் சோதோம், கொமோரா, அத்மா, செபோயிம் வழியாய் லாசா மட்டும் இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","இவர்கள் அனைவரும் காமுடைய சந்ததியார்கள். இக்குடும்பத்தினர் அனைவரும் தங்களுக்கென்று சொந்த மொழியும் சொந்த பூமியும் உடையவர்களாய் இருந்தனர். அவர்கள் தனித்தனி நாட்டினராயும் ஆயினர். ");
INSERT INTO tam2008_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","சேம், யாப்பேத்தின் மூத்த சகோதரன். அவனது சந்ததியில் ஒருவனே ஏபேர். எபேரே எபிரெய ஜனங்கள் அனைவருக்கும் தந்தையானான். ");
INSERT INTO tam2008_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","ஏலாம், அசூர், அர்பக்சாத், லூத், ஆராம் ஆகியோர் சேமின் பிள்ளைகள். ");
INSERT INTO tam2008_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","ஊத்ஸ், கூல், கேத்தெர், மாஸ் ஆகியோர் ஆராமின் பிள்ளைகள். ");
INSERT INTO tam2008_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","அர்பக்சாத்தின் மகன் சாலா. சாலாவின் மகன் ஏபேர். ");
INSERT INTO tam2008_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ஏபேருக்கு இரு மகன்கள். ஒருவன் பேர் பேலேகு. அவனுடைய நாட்களில்தான் பூமி பகுக்கப்பட்டது. யொக்தான் இன்னொரு மகன். ");
INSERT INTO tam2008_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","அல்மோதாத், சாலேப் அசர்மாவேத், யேராகை, ");
INSERT INTO tam2008_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","அதோராம், ஊசால், திக்லா, ");
INSERT INTO tam2008_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ஓபால், அபிமாவேல், சேபா, ");
INSERT INTO tam2008_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ஒப்பீர், ஆவிலா, யோபா ஆகியோரை யொக்தான் பிள்ளைகளாகப் பெற்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","இவர்களின் பகுதிகள் மேசா துவக்கி, கிழக்கேயுள்ள மலையாகிய செப்பாருக்குப் போகிற வழி மட்டும் இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","இவர்கள் அனைவரும் சேமுடைய வாரிசுகள். இவர்கள் அனைவரும் தம் குடும்பங்கள், மொழிகள், நாடுகள், தேசங்கள், வழியாக வரிசைப்படுத்தப்பட்டவர்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","நோவாவின் பிள்ளைகளால் உருவான குடும்பப்பட்டியல் இதுதான். இவர்கள் தங்கள் நாடுகளின்படி வரிசைப்படுத்தப்பட்டுள்ளனர். வெள்ளப் பெருக்குக்குப் பிறகு இக்குடும்பங்கள் தோன்றி பூமி முழுவதும் பரவினர். ");
INSERT INTO tam2008_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","வெள்ளப் பெருக்குக்குப் பிறகு முழு உலகமும் ஒரே மொழியைப் பேசியது. எல்லா ஜனங்களும் ஒரே விதமாகப் பேசினர். ");
INSERT INTO tam2008_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ஜனங்கள் கிழக்கே இருந்து பயணம் செய்து சிநெயார் நாட்டில் ஒரு சமவெளியைக் கண்டு அங்கே தங்கினர். ");
INSERT INTO tam2008_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","ஜனங்கள், “நாம் செங்கற்களைச் செய்து, நெருப்பில் அவற்றைச் சுடுவோம். அது பல முடையதாகும்” என்றனர். எனவே ஜனங்கள் கற்களைப் பயன்படுத்தாமல் செங்கற்களைப் பயன்படுத்தி வீடு கட்டினர். சாந்துக்கு பதிலாக தாரைப் பயன்படுத்தினர். ");
INSERT INTO tam2008_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","மேலும் ஜனங்கள், “நமக்காக நாம் ஒரு நகரத்தை நிர்மாணிக்க வேண்டும். ஒரு பெரிய கோபுரத்தை வானத்தை எட்டுமளவு கட்ட வேண்டும். நாம் புகழ் பெறுவோம். அது நம்மை ஒன்றுபடுத்தும். பூமி எங்கும் பரவிப் போகாமல் இருக்கலாம்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","கர்த்தர் பூமிக்கு இறங்கி வந்து அவர்கள் நகரத்தையும் கோபுரத்தையும் கட்டுவதைப் பார்வையிட்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","கர்த்தர், “இந்த ஜனங்கள் அனைவரும் ஒரே மொழியையே பேசுகின்றனர். இவர்கள் சேர்ந்து இவ்வேலையைச் செய்வதை நான் பார்க்கிறேன். இவர்களால் சாதிக்கக் கூடியவற்றின் துவக்கம்தான் இது. இனி இவர்கள் செய்யத்திட்டமிட்டுள்ள எதை வேண்டுமானாலும் செய்ய முடியும். ");
INSERT INTO tam2008_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","எனவே, நாம் கீழே போய் அவர்களின் மொழியைக் குழப்பி விடுவோம். பிறகு அவர்கள் ஒருவரை ஒருவர் புரிந்துகொள்ளமாட்டார்கள்” என்று சொன்னார். ");
INSERT INTO tam2008_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","அவ்வாறே, கர்த்தர் ஜனங்களைப் பூமி முழுவதும் சிதறிப் போகும்படி செய்தார். அதனால் அவர்கள் அந்த நகரத்தைக் கட்டி முடிக்க முடியாமல் போயிற்று. ");
INSERT INTO tam2008_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","உலகமெங்கும் பேசிய ஒரே மொழியைக் கர்த்தர் குழப்பிவிட்டபடியால் அந்த இடத்தை பாபேல் என்று அழைத்தனர். கர்த்தர் அவர்களை அவ்விடத்திலிருந்து பூமியெங்கும் பரவிப் போகச் செய்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","இது சேமின் குடும்பத்தைப்பற்றி கூறுகின்ற பகுதி: வெள்ளப்பெருக்கு ஏற்பட்டு இரண்டு ஆண்டுகளுக்கு பிறகு சேமுக்கு 100 வயதானபோது அர்பக்சாத் என்னும் மகன் பிறந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","அதன் பிறகு அவன் 500 ஆண்டுகள் வாழ்ந்தான். அவனுக்கு வேறு மகன்களும் மகள்களும் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","அர்பக்சாத்துக்கு 35 வயதானபோது சாலா என்னும் மகன் பிறந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","சாலா பிறந்த பின் அர்பக்சாத் 403 ஆண்டுகள் வாழ்ந்தான். அப்போது அவனுக்கு வேறு மகன்களும் மகள்களும் பிறந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","சாலாவுக்கு 30 வயதானபோது ஏபேர் பிறந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ஏபேர் பிறந்தபின் சாலா 403 ஆண்டுகள் வாழ்ந்தான். அப்போது அவனுக்கு வேறு மகன்களும் மகள்களும் பிறந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ஏபேருக்கு 34 வயதானபோது பேலேகைப் பெற்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","பேலேக் பிறந்த பின் ஏபேர் 430 ஆண்டுகள் வாழ்ந்தான். அப்போது அவனுக்கு வேறு மகன்களும் மகள்களும் பிறந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","பேலேக்குக்கு 30 வயதானபோது அவனது மகன் ரெகூ பிறந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ரெகூ பிறந்த பின் பேலேகு 209 ஆண்டுகள் உயிர்வாழ்ந்தான். அப்போது அவனுக்கு வேறு மகன்களும் மகள்களும் பிறந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","ரெகூவுக்கு 32 வயது ஆனதும் அவனது மகன் செரூகைப் பெற்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","செரூகு பிறந்தபின் ரெகூ 207 ஆண்டுகள் வாழ்ந்தான். அப்போது அவனுக்கு வேறு மகன்களும் மகள்களும் பிறந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","செரூகுக்கு 30 வயது ஆனதும் நாகோர் பிறந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","நாகோர் பிறந்தபின் செரூகு 200 ஆண்டுகள் வாழ்ந்தான். அப்போது அவனுக்கு வேறு மகன்களும் மகள்களும் பிறந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","நாகோருக்கு 29 வயது ஆனதும் அவனது மகன் தேராகைப் பெற்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","தேராகு பிறந்ததும் நாகோர் 119 ஆண்டுகள் வாழ்ந்தான். அப்போது அவனுக்கு வேறு மகன்களும் மகள்களும் பிறந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","தேராகுக்கு 70 வயதானபோது அவனது மகன்கள் ஆபிராம், நாகோர், ஆரான் பிறந்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","இது தேராகு குடும்பத்தின் வரலாறு ஆகும். தேராகு என்பவன் ஆபிராம், நாகோர், ஆரான் ஆகியோரின் தந்தையானவன். ஆரான் லோத்தின் தந்தையானவன். ");
INSERT INTO tam2008_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ஆரான் தனது பிறந்த நகரமான பாபிலோனியாவில் உள்ள ஊர் என்ற இடத்தில்மரண மடைந்தான். அப்போது அவனது தந்தையான தேராகு உயிரோடு இருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","ஆபிராமும் நாகோரும் திருமணம் செய்துகொண்டனர். ஆபிராமின் மனைவியின் பெயர் சாராய். நாகோரின் மனைவியின் பெயர் மில்காள். இவள் ஆரானுடைய மகள். ஆரான் மில்காளுக்கும் இஸ்காளுக்கும் தந்தை. ");
INSERT INTO tam2008_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","சாராய் பிள்ளைகள் இல்லாமல் மலடியாய் இருந்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","தேராகு தனது குடும்பத்தோடு பாபிலோனியாவில் உள்ள ஊர் எனும் இடத்தை விட்டுப் போனான். அவர்கள் கானானுக்குப் போகத் திட்டமிட்டனர். தேராகு தனது மகன் ஆபிராமையும் பேரன் லோத்தையும், மருமகள் சாராவையும் தன்னோடு அழைத்துச் சென்றான். அவர்கள் ஆரான் நகரத்துக்கு போய் அங்கே தங்கிவிட முடிவு செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","தேராகு 205 ஆண்டுகள் வாழ்ந்து அங்கேயே மரணமடைந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","கர்த்தர் ஆபிராமிடம், “நீ உனது ஜனங்களையும், நாட்டையும், தந்தையின் குடும்பத்தையும்விட்டு வெளியேறி நான் காட்டும் நாட்டுக்குப் போ. ");
INSERT INTO tam2008_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","நான் உன் மூலமாக ஒரு பெரிய தேசத்தை உருவாக்குவேன். நான் உன்னை ஆசீர்வதிப்பேன். உனது பெயரைப் புகழ்பெறச் செய்வேன். ஜனங்கள் மற்றவர்களை ஆசீர்வதிக்க உன் பெயரைப் பயன்படுத்துவர். ");
INSERT INTO tam2008_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","உன்னை ஆசீர்வதிக்கிற ஜனங்களை நான் ஆசீர்வதிப்பேன். உன்னை சபிப்பவர்களை நான் சபிப்பேன். நான் உன் மூலம் பூமியிலுள்ள அனைத்து ஜனங்களையும் ஆசீர்வதிப்பேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","எனவே, ஆபிராம் கர்த்தருக்குக் கீழ்ப் படிந்து ஆரானை விட்டுப் போனான். லோத்து அவனோடு சென்றான். அப்போது ஆபிராமுக்கு 75 வயது. ");
INSERT INTO tam2008_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ஆபிராம் ஆரானை விட்டு போகும்போது தன் மனைவி சாராயையும், தன் சகோதரனுடைய மகனான லோத்தையும், எல்லா அடிமைகளையும், ஆரானில் அவனுக்குச் சொந்தமான அனைத்தையும் எடுத்துக்கொண்டு போனான். அவர்கள் ஆரானை விட்டுக் கானானை நோக்கிப் பயணம் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ஆபிராம் கானான் தேசத்தின் வழியாகப் பயணம் செய்து சீகேம் நகரம் வழியே மோரேயில் இருக்கும் பெரிய மரங்கள் உள்ள இடத்திற்கு வந்தான். அக்காலத்தில் அங்கு கானானியர் வாழ்ந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","கர்த்தர் ஆபிராமுக்குக் காட்சியளித்து, “நான் உன் சந்ததிக்கு இத்தேசத்தைக் கொடுப்பேன்” என்றார். கர்த்தர் காட்சியளித்த இடத்தில் ஆபிராம் கர்த்தரைத் தொழுகைசெய்ய ஒரு பலிபீடத்தைக் கட்டினான். ");
INSERT INTO tam2008_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","பின் ஆபிராம் அந்த இடத்தை விட்டு பெத்தேலுக்குக் கிழக்கே இருக்கும் மலைக்குப் போனான். அங்கு அவன் கூடாரம் போட்டான். பெத்தேல் நகரம் மேற்காக இருந்தது. ஆயீ நகரம் அதற்குக் கிழக்கே இருந்தது. அங்கு ஒரு பலிபீடத்தைக் கர்த்தருக்கு அமைத்து கர்த்தரைத் தொழுதுகொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","மீண்டும் ஆபிராம் பயணம் செய்து பாலைவனப் பகுதிக்குச் சென்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","அந்நாட்களில் பூமியில் பஞ்சம் ஏற்பட்டது. மழை இல்லாததால் உணவுப் பொருட்களும் விளையாமல் இருந்தது. எனவே ஆபிராம் எகிப்திற்கு பிழைப்பதற்காகப் போனான். ");
INSERT INTO tam2008_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","தன் மனைவி சாராய் மிகவும் அழகாக இருக்கிறாள் என்று எண்ணிய அவன், எகிப்தை நெருங்குவதற்கு முன் சாராயிடம், “நீ வெகு அழகான பெண் என்பது எனக்குத் தெரியும். ");
INSERT INTO tam2008_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","எகிப்தியர்கள் உன்னைப் பார்க்கும்போது அவர்கள், ‘இவள் இவனுடைய மனைவி’ என்று பேசுவார்கள் பிறகு உன்னை அடைய விரும்பி என்னைக் கொன்றுவிடுவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","அதனால் நான் அவர்களிடம் நீ என் சகோதரி என்று கூறுவேன். பிறகு அவர்கள் என்னைக் கொல்லமாட்டார்கள். நான் உன் சகோதரன் என்பதால் அவர்கள் என் மீது கருணையோடு இருப்பார்கள். இவ்வகையில் நீ என் உயிரைக் காப்பாற்றலாம்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","எனவே ஆபிராம் எகிப்துக்குப் போனான். அங்குள்ள ஜனங்கள் சாராய் மிகவும் அழகானவளாக இருப்பதைப் பார்த்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","சில எகிப்தின் தலைவர்களும் அவளைப் பார்த்தனர். அவள் மிகவும் அழகான பெண் என்று அவர்கள் பார்வோனிடம் கூறினர். அவர்கள் அவளைப் பார்வோனுடைய வீட்டிற்கு அழைத்துச் சென்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","ஆபிராமைச் சாராயின் சகோதரனாக எண்ணிப் பார்வோனும் ஆபிராமிடம் அன்பாக இருந்தான். பார்வோன் அவனுக்கு ஆடுகள், மாடுகள், பெண் வேலையாட்கள், கழுதைகள், ஒட்டகங்கள் என்று பலவற்றைக் கொடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","பார்வோன் ஆபிராமின் மனைவியை எடுத்துக்கொண்டான். எனவே பார்வோனும் அவனது வீட்டில் உள்ளவர்களும் கொடிய வியாதியுறுமாறு கர்த்தர் சபித்துவிட்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","எனவே பார்வோன் ஆபிராமை அழைத்தான். அவன், “நீ எனக்கு மிகக் கெட்ட காரியத்தைச் செய்துள்ளாய்! சாராய் உன் மனைவி என்று சொல்லாமல், ");
INSERT INTO tam2008_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","அவளை உன் சகோதரி என்று ஏன் சொன்னாய்? நான் அவளை எடுத்துக்கொண்டதால் அவள் எனது மனைவியாக இருந்திருப்பாளே. ஆனால் இப்பொழுது உன் மனைவியை உனக்கு நான் திரும்பிக் கொடுக்கிறேன். அவளை அழைத்துகொண்டு போய்விடு” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","பிறகு, பார்வோன் தன் வீரர்களிடம், ஆபிராமை நாட்டைவிட்டு வெளியே அனுப்புமாறு கட்டளையிட்டான். எனவே, ஆபிராமும் அவனது மனைவியும் அவர்களுக்குச் சொந்தமானவற்றை எடுத்துக்கொண்டு அந்த இடத்தைவிட்டு வெளியேறினர். ");
INSERT INTO tam2008_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","ஆபிராம் எகிப்தை விட்டு வெளியேறி, தன் மனைவியோடும் தனக்குரிய பொருட்களோடும் பாலைவனத்தின் வழியாகப் பயணம் செய்தான். லோத்துவும் அவனோடு சென்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","ஆபிராம் மிகவும் செல் வந்தனாக இருந்தான். அவனிடம் ஏராளமான மிருகங்களும் தங்கமும் வெள்ளியும் இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","ஆபிராம் தொடர்ந்து பயணம் செய்து பாலைவனத்தை விட்டுப் பெத்தேலுக்குச் சென்று, பெத்தேல் நகரத்திற்கும் ஆயி நகரத்திற்கும் இடையில் உள்ள பகுதியில் தங்கினான். அது ஏற்கெனவே அவனும் அவன் குடும்பத்தாரும் தங்கிய இடமாகும். ");
INSERT INTO tam2008_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","இங்கு தான் ஆபிராம் பலிபீடம் அமைத்திருந்தான். எனவே, ஆபிராம் கர்த்தரை அந்த இடத்தில் தொழுதுகொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","இந்த நேரத்தில் லோத்தும் ஆபிராமோடு பயணம் செய்துகொண்டிருந்தான். லோத்துக்கும் நிறைய மிருகங்களும் கூடாரங்களும் இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ஆபிராமிடமும் லோத்திடமும் இருந்த மிருகங்கள் வாழ்கிற அளவிற்கு அந்த நிலம் அவ்வளவு போதுமானதாக இல்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","அதோடு கானானியர்களும் பெரிசியரும் அவர்களுடன் அங்கு வாழ்ந்து வந்தனர். ஆபிராமின் மேய்ப்பர்களும் லோத்தின் மேய்ப்பர்களும் தங்களுக்குள் சண்டையிட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","எனவே, ஆபிராம் லோத்திடம், “நம்மிரு வருக்கும் இடையில் எவ்வித வாக்குவாதமும் வேண்டாம். உனது ஆட்களுக்கும் எனது ஆட்களுக்கும் இனி மேல் எந்த விரோதமும் வேண்டாம். நாம் சகோதரர்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","நாம் பிரிந்து விடுவோம். உனக்கு விருப்பமான எந்த இடத்தையும் நீ தேர்ந்தெடுத்துக்கொள். நீ இடது பக்கமாகப் போனால் நான் வலது பக்கமாகப் போகிறேன். நீ வலது பக்கமாகப் போனால் நான் இடது பக்கமாகப் போகிறேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","லோத்து யோர்தான் நதிக்கு அருகான சமவெளியைப் பார்வையிட்டான். அங்கு நீர் வளம் இருப்பதைக் கண்டான். (கர்த்தர் சோதோமையும் கொமோராவையும் அழிப்பதற்கு முன்பு சோவாருக்குப்போகும் வழிவரை அது கர்த்தரின் தோட்டம் போலவும் எகிப்து தேசத்தைப்போலவும் இருந்தது.) ");
INSERT INTO tam2008_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","எனவே லோத்து யோர்தான் சமவெளியைத் தேர்ந் தெடுத்தான். இருவரும் பிரிந்தனர். லோத்து கிழக்கு நோக்கிப் பயணம் செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","ஆபிராம் கானான் தேசத்தில் தங்கினான். லோத்து சமவெளிப்பகுதியின் நகரங்களில் தங்கினான். லோத்து மேலும் தெற்கு நோக்கி நகர்ந்து சோதோமில் கூடாரம் அடித்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","சோதோம் ஜனங்கள் கர்த்தருக்கு எதிராகப் பாவம் செய்துகொண்டிருந்தனர் என்பதை அறிந்திருந்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","லோத்து விலகிப்போனதும் கர்த்தர் ஆபிராமிடம், “உன்னைச் சுற்றிலும் வடக்கேயும், தெற்கேயும், கிழக்கேயும், மேற்கேயும்பார். ");
INSERT INTO tam2008_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","இந்தப் பூமியை நான் உனக்கும் உன் சந்ததியினருக்கும் கொடுக்கிறேன். இது என்றென்றும் உங்களுக்குரியதாக இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","உன் ஜனங்களை உலகத்தில் உள்ள புழுதியின் அளவுக்குப் பெருகச் செய்வேன். எவராவது புழுதியை எண்ண முடியுமானால் அதுவே உங்கள் தொகையாக இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","எனவே நாட்டின் நீளமும் அகலமும் எவ்வளவோ அவ்வளவு தூரம் நட. நான் அவற்றை உனக்குத் தருவேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","எனவே, ஆபிராம் தனது கூடாரத்தை எடுத்துக்கொண்டு பெரிய மரங்களிருக்கும் எபிரோனிலிலுள்ள மம்ரேயின் சமபூமிக்குச் சென்றான். இங்கு ஆபிராம் கர்த்தரைத் தொழுதுகொள்ள ஒரு பலிபீடத்தைக் கட்டினான். ");
INSERT INTO tam2008_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","அம்ராப்பேல் சிநெயாரின் அரசன். அரியோகு ஏலாசாரின் அரசன். கெதர்லாகோமேர் ஏலாமின் அரசன். திதியால் கோயம் தேசத்தின் அரசன். ");
INSERT INTO tam2008_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","இவர்கள் அனைவரும் மற்ற அரசர்களோடு சண்டையிட்டனர். சோதோமின் அரசனான பேராவோடும், கொமோராவின் அரசனான பிர்சாவோடும், அத்மாவின் அரசனான சிநெயாவோடும், செபோயீமின் அரசனான செமேபரோடும் பேலாவின் அரசனோடும் (பேலா சோவார் என்றும் அழைக்கப்பட்டான்) அவர்கள் போர் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","சித்தீம் பள்ளத்தாக்கில் எல்லா அரசர்களும் தம் படைகளோடு கூடினர். (சித்தீம் பள்ளத்தாக்கு இப்போது உப்புக் கடல் என்று அழைக்கப்படுகிறது.) ");
INSERT INTO tam2008_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","இந்த அரசர்கள் 12 ஆண்டுகள் கெதர்லாகோமேருக்குச் சேவைசெய்து 13ஆம் ஆண்டில் கலகம் செய்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","14 ஆம் ஆண்டிலே கெதர்லாகோமேரும் அவனோடு இருந்த அரசர்களும் போருக்கு வந்தனர். இவர்கள் அஸ்தரோத் கர்னாயீமிலே இருந்த ரெப்பாயீமியரையும் காமிலிருந்த சூசிமியரையும், சாவேகீரியத் தாயீமிலே இருந்த ஏமியரையும், ");
INSERT INTO tam2008_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","சேயீர் மலைகளில் இருந்த ஒசரியரையும் வனாந்தரத்திற்கு அருகிலே இருந்த எல்பாரான் மட்டும் தோற்கடித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","அதன்பிறகு அரசன் கெதர்லாகோமேர் வடதிசையில் காதேஸ் என்னும் என்மிஸ்பாத்துக்கு வந்து அமலேக்கியரின் நாடுகளையும் அத்சாத்சோன் தாமாரிலே இருந்த எமோரியரையும் அழித்து ஒழித்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","அப்போது சோதோம், அத்மா, கொமோரா, செபோயீம், சோவார் என்னும் பேலா ஆகிய நாடுகளின் அரசர்கள் புறப்பட்டுப் போனார்கள். இவர்கள் சித்தீம் பள்ளத்தாக்கிலே, ஏலாமின் அரசனாகிய கெதர்லாகோ மேரோடும், கோயம் அரசனாகிய திதியாலோடும் சிநெயாரின் அரசனாகிய அம்ராப்பேலோடும் ஏலாசாரின் அரசனாகிய அரியோகோடும் யுத்தம் செய்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","எனவே நான்கு அரசர்கள் ஐந்து பேருக்கு எதிராக இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","அந்தச் சித்தீம் பள்ளத்தாக்கு முழுவதும் தார் நிறைந்த குழிகள் இருந்தன. சோதோம் கொமோராவின் அரசர்கள் தோற்றோடி வந்து அதில் விழுந்தார்கள். இன்னும் பலர் மலைகளுக்கு ஓடிப்போனார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","எனவே, சோதோம் மற்றும் கொமோராவினருக்கு உரிய பொருட்களை எல்லாம் அவர்களின் பகைவர்கள் எடுத்துக்கொண்டனர். அவர்களது அனைத்து உணவுப் பொருட்களையும், ஆடைகளையும் எடுத்துக்கொண்டு ஓடினார்கள். ஆபிராமின் சகோதரனுடைய மகனான லோத்து சோதோமில் வசித்துக்கொண்டிருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","அவனையும் எதிரிகள் பிடித்துக்கொண்டார்கள். மேலும் அவனுடைய உடமைகள் அனைத்தையும் எடுத்துக்கொண்டு எதிரிகள் ஓடினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","பிடிபடாதவர்களில் ஒருவன் எபிரெயனாகிய ஆபிராமிடம் சென்று நடந்ததைக் கூறினான். ஆபிராம் மம்ரே என்னும் எமோரியனுடைய பூமியில் குடியிருந்தான். மம்ரே, எஸ்கோல், ஆநேர் ஆகியோர் ஒருவருக்கு ஒருவர் உதவுவதாக ஒப்பந்தம் செய்திருந்தனர். அவர்கள் ஆபிராமுக்கு உதவுவதாகவும் ஒப்பந்தத்தில் கையெழுத்திட்டிருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","லோத்து கைதுசெய்யப்பட்டதை ஆபிராம் அறிந்துகொண்டான். அவன் தனது குடும்பத்தினர் அனைவரையும் அழைத்தான் அவர்களிடம் 318 பயிற்சி பெற்ற வீரர்கள் இருந்தனர். அவன் அவர்களோடு தாண் நகரம்வரை பகைவர்களைத் துரத்திக்கொண்டு போனான். ");
INSERT INTO tam2008_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","அன்று இரவு அவனும் அவனது வீரர்களும் பகைவரைத் திடீரென்று தாக்கினர். அவர்களைத் தோற்கடித்து தமஸ்குவின் வடக்கேயுள்ள கோபாவரை துரத்தினர். ");
INSERT INTO tam2008_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","பிறகு, பகைவர்கள் எடுத்துசென்ற அனைத்து பொருட்களையும் ஆபிராம் மீட்டுக்கொண்டான். பெண்கள், வேலைக்காரர்கள், லோத்து, அவனது பொருட்கள் அனைத்தும் மீட்கப்பட்டன. ");
INSERT INTO tam2008_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","பிறகு ஆபிராம் கெதர்லாகோமரையும் அவனோடிருந்த அரசர்களையும் தோற்கடித்து விட்டு தன் நாட்டுக்குத் திரும்பினான். சோதோமின் அரசன் புறப்பட்டு சாவே பள்ளத்தாக்குக்கு வந்து ஆபிராமை வரவேற்றான். (இப்போது இப்பள்ளத்தாக்கு அரசனின் பள்ளத்தாக்கு என்று அழைக்கப்படுகிறது.) ");
INSERT INTO tam2008_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","சாலேமின் அரசனாகிய மெல்கிசேதேக்கும் ஆபிராமைச் சந்திக்கப் போனான். இவன் உன்னதமான தேவனின் ஆசாரியன். இவன் அப்பமும் திராட்சைரசமும் கொண்டுவந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","மெல்கிசேதேக் ஆபிராமை ஆசீர்வாதம் செய்து, “ஆபிராமே, வானத்தையும் பூமியையும் படைத்த உன்னதமான தேவன் உன்னை ஆசீர்வதிப்பாராக. ");
INSERT INTO tam2008_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","நாம் உன்னதமான தேவனைப் போற்றுவோம். உன் பகைவர்களை வெல்ல உனக்குத் தேவன் உதவினார்” என்றான். போரில் கைப்பற்றியவற்றில் பத்தில் ஒரு பங்கை ஆபிராம் மெல்கிசேதேக்கிற்குக் கொடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","பிறகு சோதோமின் அரசன் ஆபிராமிடம், “இவை எல்லாவற்றையும் நீ உனக்கே வைத்துக்கொள். எனது ஜனங்களை மட்டும் எனக்குக் கொடு அது போதும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","ஆனால் ஆபிராமோ சோதோம் அரசனிடம், “நான் உன்னதமான தேவனாகிய கர்த்தரிடம் வாக்குப் பண்ணியிருக்கிறேன். வானத்தையும் பூமியையும் படைத்த உன்னதமான தேவனுக்கு முன்பாக என் கைகள் சுத்தமாயிருக்கிறது. ");
INSERT INTO tam2008_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","உனக்குரிய எதையும் நான் வைத்திருக்க மாட்டேன் என்று வாக்குப் பண்ணியிருக்கிறேன். நான் உனக்குரிய ஒரு நூல் அல்லது பாதரட்டையின் சிறு வாரையாகிலும் கூட ஏற்கமாட்டேன். ‘நான் ஆபிராமைப் பணக்காரன் ஆக்கினேன்’ என்று நீ சொல்வதை நான் விரும்ப மாட்டேன். ");
INSERT INTO tam2008_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","என்னுடைய இளைஞர்கள் உண்பதற்கான உணவை மட்டுமே ஏற்றுக்கொள்வேன். ஆனால் மற்றவர்களுக்கு அவர்களின் பங்கினைக் கொடுத்துவிடு. நாம் போரில் வென்ற பொருட்களை யெல்லாம் எடுத்துக்கொள். சிலவற்றை ஆநேர், எஸ்கோல், மம்ரே ஆகியவர்களுக்குக் கொடு. இவர்கள் எனக்குப் போரில் உதவினார்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","இவையெல்லாம் நடந்த பிறகு கர்த்தரின் வார்த்தையானது ஆபிராமுக்குத் தரிசனத்தில் வந்தது. தேவன், “ஆபிராமே, நீ பயப்படவேண்டாம். நான் உன்னைப் பாதுகாப்பேன். உனக்குப் பெரிய பரிசு தருவேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","ஆனால் ஆபிராமோ, “தேவனாகிய கர்த்தாவே! நீர் கொடுக்கிற எதுவும் எனக்கு மகிழ்ச்சியைத் தராது, ஏனென்றால் எனக்குப் பிள்ளைகள் இல்லை. எனவே நான் மரித்த பிறகு எனக்குரிய பொருட்கள் எல்லாம் எனது அடிமையான தமஸ்குவைச் சேர்ந்த எலியேசருக்கு உரியதாகும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","மேலும் ஆபிராம், “நீர் எனக்கு மகனைக் கொடுக்கவில்லை. எனவே என் வீட்டில் பிறக்கும் அடிமைக்கு இந்த சொத்து முழுவதும் உரிமையாகுமே” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","கர்த்தர் ஆபிராமிடம், “அந்த அடிமை உனக்குரியவற்றைப் பெறமாட்டான். உனக்கொரு மகன் பிறப்பான். அவனே உனக்குரியவற்றைப் பெற்றுக்கொள்வான்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","பிறகு தேவன் ஆபிராமை வெளியே அழைத்து வந்து, “வானத்தில் நிறைந்திருக்கும் ஏராளமான நட்சத்திரங்களைப் பார், அவற்றை உன்னால் எண்ணமுடியாது, வாருங்காலத்தில் உன் சந்ததியும் இவ்வாறே இருக்கும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","ஆபிராம் தேவனை நம்பினான். மேலும் தேவன் ஆபிராமின் நம்பிக்கையை அவனுடைய நீதியான காரியமாக எண்ணினார். ");
INSERT INTO tam2008_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","தேவன் ஆபிராமிடம், “நானே கர்த்தர். உன்னை பாபிலோனியாவிலுள்ள ஊர் என்னும் பட்டணத்திலிருந்து அழைத்து வந்தேன். நானே இதைச்செய்தேன். இந்தத் தேசத்தை உனக்குக் கொடுக்கிறேன். இது உனக்கே உரியதாகும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","ஆனால் ஆபிராமோ, “கர்த்தராகிய என் ஆண்டவரே! இந்தத் தேசம் எனக்கு உரியதாகும் என்று எப்படி உறுதிப்படுத்திக்கொள்வது?” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","தேவன் ஆபிராமிடம், “நாம் ஒரு உடன்படிக்கையைச் செய்துகொள்வோம், மூன்று ஆண்டுகள் ஆன ஒரு பசுவை கொண்டு வா. அதோடு மூன்று ஆண்டுகள் ஆன ஆட்டையும், ஆட்டுக்கடாவையும், கொண்டு வா, அதோடு ஒரு காட்டுப் புறாவையும், புறாக் குஞ்சையும் என்னிடம் கொண்டு வா” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ஆபிராம் இவை எல்லாவற்றையும் தேவனிடம் கொண்டு வந்தான். ஒவ்வொன்றையும் கொன்று இரண்டு துண்டுகளாக வெட்டி, பிறகு ஒரு பாதியை இன்னொரு பாதியோடு சேர்த்தான். பறவைகளை அவன் அவ்வாறு வெட்டவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","பின்னர், பெரிய பறவைகள் விலங்குகளின் உடலை உண்ண கீழே பறந்து வந்தன. ஆபிராம் அவற்றைத் துரத்தினான். ");
INSERT INTO tam2008_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","சூரியன் அஸ்தமிக்கும் நேரம் நெருங்கியபோது ஆபிராமுக்குத் தூக்கம் வந்தது. அத்துடன் அச்சுறுத்தும் இருள் அவனைச் சூழ்ந்துகொண்டது. ");
INSERT INTO tam2008_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","பிறகு கர்த்தர் ஆபிராமிடம், “நீ இவ்விஷயங்களைப்பற்றி அறிய வேண்டும். உனது சந்ததி தங்களுக்குச் சொந்தமில்லாத நாட்டிலே அந்நியர்களாக இருப்பார்கள். அங்குள்ளவர்கள் அவர்களை 400 ஆண்டு காலத்துக்கு அடிமைகளாக வைத்திருந்து, மோசமாக நடத்துவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","ஆனால் நான் அந்த நாட்டைத் தண்டிப்பேன். உனது ஜனங்கள் அந்நாட்டை விட்டு பல்வேறு பொருட்களுடன் வெளியேறுவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","“நீ நல்ல முதிர் வயதாகும்வரை வாழ்ந்து, சமாதானமாக மரணமடைவாய். ");
INSERT INTO tam2008_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","நான்கு தலைமுறைகளுக்குப்பின் உன் சந்ததியினர் மீண்டும் இங்கே வருவார்கள். அப்போது உனது ஜனங்கள் எமோரியரைத் தோற்கடிப்பார்கள். இது எதிர்காலத்தில்தான் நடைபெறும், ஏனென்றால் இன்னும் எமோரியர்கள் தண்டிக்கப்படுகிற அளவிற்கு மிக மோசமாகக் கெட்டுப்போகவில்லை” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","சூரியன் அஸ்தமித்தபின் மேலும் இருளாயிற்று. மரித்துப்போன மிருகங்கள் தரையின் மேலேயே கிடந்தன. இரண்டு துண்டுகளாகக் கிடந்த அவற்றின் உடலிலிருந்து சூளையின் புகையும் நெருப்பும் வெளிவந்தன. ");
INSERT INTO tam2008_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ஆகையால், அன்று கர்த்தர் ஆபிராமோடு ஒரு வாக்குறுதியும், உடன்படிக்கையையும் செய்துகொண்டார். கர்த்தர், “நான் இந்த நாட்டை உன் சந்ததிக்குத் தருவேன். எகிப்து நதி முதல் யூப்ரடீஸ் நதி வரையுள்ள இடத்தைக் கொடுப்பேன். ");
INSERT INTO tam2008_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","இந்த பூமி கேனியர், கெனிசியர், கத்மோனியர், ");
INSERT INTO tam2008_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ஏத்தியர், பெரிசியர், ரெப்பாயீமியர், ");
INSERT INTO tam2008_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","எமோரியர், கானானியர், கிர்காசியர் மற்றும் எபூசியருக்குச் சொந்தமானதாகும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","சாராய் ஆபிராமின் மனைவி. அவளுக்கும் ஆபிராமுக்கும் குழந்தை இல்லாமல் இருந்தது. சாராய்க்கு ஒரு எகிப்திய வேலைக்காரப் பெண் இருந்தாள். அவள் பெயர் ஆகார். ");
INSERT INTO tam2008_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","சாராய் ஆபிராமிடம், “கர்த்தர் நான் குழந்தை பெற்றுக்கொள்ள அனுமதிக்கவில்லை. எனவே எனது வேலைக்காரப் பெண்ணோடு செல்லுங்கள். அவளுக்குப் பிறக்கும் குழந்தையை என் குழந்தை போல் ஏற்றுக்கொள்வேன்” என்றாள். ஆபிராமும் தன் மனைவி சாராய் சொன்னபடி கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","இது ஆபிராம் கானான் நாட்டில் பத்து ஆண்டுகள் வாழ்ந்தபின் நடந்தது. சாராய் தனது வேலைக்காரப் பெண்ணை ஆபிராமுக்குக் கொடுத்தாள். (ஆகார் எகிப்திய வேலைக்காரப் பெண்) ");
INSERT INTO tam2008_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","ஆபிராமால் ஆகார் கர்ப்பமுற்றாள். இதனால் அவளுக்குப் பெருமை ஏற்பட்டது. அவள் தன்னைத் தன் எஜமானியைவிடச் சிறந்தவளாக எண்ணினாள். ");
INSERT INTO tam2008_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","ஆனால் சாராய் ஆபிராமிடம், “இப்பொழுது என் வேலைக்காரப் பெண் என்னை வெறுக்கிறாள். இதற்காக நான் உம்மையே குற்றம்சாட்டுவேன். நான் அவளை உமக்குக் கொடுத்தேன். அவள் கர்ப்பமுற்றாள். பிறகு என்னைவிடச் சிறந்தவளாகத் தன்னை நினைத்துக்கொள்கிறாள். உமக்கும் எனக்கும் இடையில் கர்த்தரே நியாயந்தீர்க்கட்டும்” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","ஆனால் ஆபிராமோ சாராயிடம், “நீ ஆகாரின் எஜமானி, நீ அவளுக்கு செய்ய விரும்புவதைச் செய்யலாம்” என்றான். எனவே சாராய் ஆகாரைக் கடினமாகத் தண்டித்தபடியால் அவள் சாராயை விட்டு ஓடிப்போனாள். ");
INSERT INTO tam2008_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","பாலைவனத்தில் சூருக்குப் போகிற வழியில் இருந்த நீரூற்றினருகில் ஆகாரைக் கர்த்தருடைய தூதன் கண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","தூதன் அவளிடம், “சாராயின் பணிப்பெண்ணாகிய ஆகாரே. ஏன் இங்கே இருக்கிறாய்? எங்கே போகிறாய்?” என்று கேட்டான். அவளோ, “நான் சாராயிடமிருந்து விலகி ஓடிக்கொண்டிருக்கிறேன்” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","அதற்குக் கர்த்தருடைய தூதன், “சாராய் உனது எஜமானி. வீட்டிற்குத் திரும்பிப் போய் அவளுக்குக் கீழ்ப்படிந்திரு. ");
INSERT INTO tam2008_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","உன்னிடமிருந்து ஏராளமான ஜனங்கள் தோன்றுவர், அவர்கள் எண்ண முடியாத அளவிற்கு இருப்பார்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","மேலும் கர்த்தருடைய தூதன், “ஆகார் நீ இப்போது கர்ப்பமாக இருக்கிறாய். உனக்கு ஒரு மகன் பிறப்பான். அவனுக்கு இஸ்மவேல் என்று பெயரிடு. ஏனென்றால் நீ மோசமாக நடத்தப்பட்டதை கர்த்தர் அறிந்திருக்கிறார். உன் மகன் உனக்கு உதவுவான். ");
INSERT INTO tam2008_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","இஸ்மவேல் காட்டுக் கழுதையைப் போன்று முரடனாகவும், சுதந்திரமானவனாகவும் இருப்பான். அவன் ஒவ்வொருவருக்கும் விரோதமாக இருப்பான். ஒவ்வொருவரும் அவனுக்கு விரோதமாக இருப்பார்கள். அவன் ஒவ்வொரு இடமாகச் சுற்றித் தன் சகோதரர்கள் அருகில் குடியேறுவான். அவர்களுக்கும் அவன் விரோதமாக இருப்பான்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","கர்த்தர் ஆகாரிடம் பேசினார், அவள் அவரிடம், “நீர் என்னைக் காண்கிற தேவன்” என்று கூறினாள். அவள், “இத்தகைய இடத்திலும் தேவன் என்னைக் காண்கிறார், பொறுப்போடு கவனிக்கிறார். நானும் தேவனைக் கண்டேன்” என்று நினைத்து இவ்வாறு சொன்னாள். ");
INSERT INTO tam2008_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","எனவே, அந்த கிணற்றிற்கு பீர்லாகாய் ரோயீ என்று பெயரிடப்பட்டது. அது காதேசுக்கும் பாரேத்துக்கும் இடையில் இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ஆகார் ஆபிராமுக்கு ஒரு மகனைப் பெற்றாள். அவனுக்கு ஆபிராம் இஸ்மவேல் என்று பெயரிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","ஆபிராம் ஆகார் மூலம் இஸ்மவேலைப் பெறும்போது அவனுக்கு 86 வயது. ");
INSERT INTO tam2008_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","ஆபிராமுக்கு 99 வயதானபோது கர்த்தர் அவனுக்கு காட்சி தந்தார். அவர், “நான் சர்வ வல்லமையுள்ள தேவன். எனக்குக் கீழ்ப்படிந்து எனக்கு முன்பாகச் சரியான வழியில் நட. ");
INSERT INTO tam2008_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","நீ இவற்றைச் செய்தால், நமக்குள் ஒரு உடன்படிக்கையை நான் ஏற்படுத்துவேன். உனது ஜனங்களுக்காக ஒரு பெரிய நாட்டை ஏற்பாடு செய்வதாக வாக் குறுதி செய்வேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","தேவனுக்கு முன் ஆபிராம் பணிந்து வணங்கினான். ");
INSERT INTO tam2008_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","தேவன் அவனிடம், “நான் உன்னைப் பல நாடுகளின் தந்தையாக்குவேன். ");
INSERT INTO tam2008_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","நான் உனது பெயரை மாற்றுவேன். இப்போது உனது பெயர் ஆபிராம், இனி உன் பெயர் ஆபிரகாம். நான் உன்னைப் பல நாடுகளுக்குத் தந்தையாக்கப் போவதால் இந்தப் பெயரை உனக்கு சூட்டுகிறேன். ");
INSERT INTO tam2008_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","நான் உனக்கு அநேக சந்ததிகளை கொடுப்பேன். உன்னிடமிருந்து புதிய நாடுகள் உருவாகும். பல அரசர்கள் உன்னிடமிருந்து எழும்புவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","நான் உனக்கும் எனக்கும் இடையில் ஒரு உடன்படிக்கையை ஏற்படுத்துவேன். இந்த உடன்படிக்கை உனக்கு மட்டுமல்லாமல் உனது சந்ததிக்கும் உரியதாகும். என்றென்றைக்கும் இந்த உடன்படிக்கை தொடரும். நான் உனக்கும் உனது சந்ததிக்கும் தேவன். ");
INSERT INTO tam2008_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","நான் இந்த பூமியை உனக்கும் உன் சந்ததிக்கும் தருவேன். நீ பரதேசியாய் தங்கி வருகிற கானான் நாடு முழுவதையும் தருவேன். என்றென்றைக்கும் இது உனக்கு உரியதாகும். நான் உனது தேவனாயிருப்பேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","மேலும் தேவன் ஆபிரகாமிடம், “இது உடன்படிக்கையில் உனது பகுதியாகும். நீயும் உனது சந்ததியும் இந்த உடன்படிக்கையை மனதில் வைத்திருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","இது தான் நீ கீழ்ப்படிய வேண்டிய உடன்படிக்கை. இதுவே உனக்கும் எனக்கும் இடையேயுள்ள உடன்படிக்கை. இது உனது சந்ததிகளுக்கெல்லாம் உரியது. உனது சந்ததியருக்குப் பிறக்கும் ஒவ்வொரு ஆண்பிள்ளையும் விருத்தசேதனம் செய்துகொள்ள வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","உங்கள் நுனித்தோலின் மாம்சத்தை விருத்தசேதனம் செய்துகொள்ள வேண்டும். இதுவே நீங்கள் உடன்படிக்கைக்குக் கீழ்ப்படிகிறீர்கள் என்பதற்கான அடையாளம். ");
INSERT INTO tam2008_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","ஒரு ஆண்குழந்தை பிறந்த எட்டாவது நாள் அவனுக்கு விருத்தசேதனம் செய்துவிட வேண்டும். அது போலவே உங்கள் அடிமைகளுக்குப் பிறக்கும் ஆண்குழந்தைகளுக்கும் விருத்தசேதனம் செய்ய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","எனவே உங்கள் நாட்டிலுள்ள ஒவ்வொரு ஆண்களும் விருத்தசேதனம் செய்யப்பட்டவர்களாக இருக்க வேண்டும். உங்கள் பிள்ளைகளுக்கு மட்டுமல்லாமல் உங்கள் அடிமைகளுக்கும் விருத்தசேதனம் செய்ய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","இதுதான் உனக்கும் எனக்கும் இடையில் ஏற்படுத்தப்பட்ட உடன்படிக்கை. விருத்தசேதனம் செய்யப்படாத எந்த ஆணும் உங்களிடமிருந்து விலக்கப்படுவான்; ஏனென்றால் அவன் எனது உடன்படிக்கையை உடைத்தவனாகிறான்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","தேவன் ஆபிரகாமிடம், “உன் மனைவி சாராய் இனிமேல் சாராள் என்று அழைக்கப்படுவாள். ");
INSERT INTO tam2008_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","அவளை நான் ஆசீர்வதிக்கிறேன். அவள் உனக்கு ஒரு மகனைப் பெற்றுத்தரும்படி செய்வேன். நீயே அவன் தந்தை. சாராள் பல நாடுகளுக்குத் தாயாக இருப்பாள். அவளிடமிருந்து பல அரசர்கள் வருவார்கள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","ஆபிரகாம் தன் முகம் தரையில்படும்படி விழுந்து வணங்கி தேவனுக்கு மரியாதை செலுத்தினான். எனினும் அவன் தனக்குள் சிரித்துக்கொண்டே, “எனக்கு 100 வயது ஆகிறது. என்னால் ஒரு மகன் பிறப்பது கூடியகாரியமா?. சாராளுக்கோ 90 வயது. அவள் ஒரு மகனைப் பெறுவது எப்படி?” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","ஆபிரகாம் தேவனிடம், “இஸ்மவேல் வாழ்ந்து உமக்குச் சேவை செய்வான் என நம்புகிறேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","தேவன், “இல்லை. உன் மனைவி சாராள் ஒரு மகனைப் பெறுவாள் என்று சொன்னேன். நீ அவனுக்கு ஈசாக்கு என்று பெயரிடுவாய். நான் அவனோடு என் உடன்படிக்கையை ஏற்படுத்திக்கொள்வேன். அந்த உடன்படிக்கையே என்றென்றைக்கும் அவனுக்கும் அவனது சந்ததிக்கும் தொடரும். ");
INSERT INTO tam2008_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","“நீ இஸ்மவேலைப்பற்றிச் சொன்னாய். நான் அவனையும் ஆசீர்வதிப்பேன். அவனுக்கும் நிறைய பிள்ளைகள் இருக்கும். அவன் 12 பெரிய தலைவர்களுக்குத் தந்தையாவான். அவனது குடும்பமே ஒரு நாடாகும். ");
INSERT INTO tam2008_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","ஆனால் நான் என் உடன்படிக்கையை ஈசாக்கிடம் ஏற்படுத்துவேன். ஈசாக்கு சாராளின் மகனாயிருப்பான். அவன் அடுத்த ஆண்டு இதே நேரத்தில் பிறந்திருப்பான்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","ஆபிரகாமிடம் தேவன் பேசி முடித்த பிறகு தேவன் அவனை விட்டு விலகிப் போனார். ");
INSERT INTO tam2008_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","தேவன் ஆபிரகாமிடம் அவன் குடும்பத்திலுள்ள ஆண்களும், சிறுவர்களும் விருத்தசேதனம் செய்துகொள்ள வேண்டும் என்று கூறியிருந்தார். எனவே, ஆபிரகாம் தனது மகன் இஸ்மவேல், மற்றும் அவனுடைய வீட்டில் பிறந்த அடிமைகளையும், பணம் கொடுத்து வாங்கிய அடிமைகளையும் கூட்டினான். ஆபிரகாமின் வீட்டிலுள்ள ஒவ்வொரு ஆணும், சிறுவனும் அந்த நாளிலே, தேவன் ஆபிரகாமிடம் கூறியபடியே விருத்தசேதனம் செய்யப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","ஆபிரகாம் விருத்தசேதனம் செய்யப்பட்டபோது அவனுக்கு 99 வயது. ");
INSERT INTO tam2008_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","அப்போது ஆபிரகாமின் மகன் இஸ்மவேலுக்கு 13 வயது. ");
INSERT INTO tam2008_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","ஆபிரகாமும் அவனது மகனும் அதே நாளில் விருத்தசேதனம் செய்யப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","அன்று அவனது குடும்பத்தில் உள்ள அனைவரும் விருத்தசேதனம் செய்துகொண்டனர். அவன் வீட்டில் பிறந்த அடிமைகளும், அவன் வாங்கிய அடிமைகளும் கூட விருத்தசேதனம் செய்துகொண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","பிறகு, கர்த்தர் மீண்டும் ஆபிரகாமுக்குக் காட்சியளித்தார். ஆபிரகாம் மம்ரேயிலுள்ள ஓக் மரங்களுக்கு அருகில் வாழ்ந்தான். ஒரு நாள், வெப்பம் அதிகமான நேரத்தில் ஆபிரகாம் தனது கூடாரத்தின் வாசலுக்கருகில் இருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","ஆபிரகாம் மேலே ஏறிட்டுப் பார்த்தபோது முன்றுபேர் அவனுக்கு முன்னால் நின்று கொண்டிருப்பதைப் பார்த்தான். ஆபிரகாம் அவர்களைப் பார்த்ததும் குனிந்து வணங்கினான். ");
INSERT INTO tam2008_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ஆபிரகாம், “ஐயா, உங்கள் பணியாளாகிய என்னோடு தயவுசெய்து தங்கியிருங்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","உங்கள் பாதங்களைக் கழுவ தண்ணீர் கொண்டு வருகிறேன். நீங்கள் மரங்களுக்கடியில் ஓய்வுகொள்ளுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","நான் உங்களுக்கு உணவைக்கொண்டு வருவேன். நீங்கள் விரும்புகிற அளவிற்குச் சாப்பிடலாம். பிறகு உங்களது பயணத்தைத் தொடரலாம்” என்றான். அந்த மூன்று மனிதர்களும், “அது நல்லது. நீ சொன்னபடி நாங்கள் செய்கிறோம்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","ஆபிரகாம் கூடாரத்திற்கு விரைந்து போனான். அவன் சாராளிடம், “சீக்கிரம் மூன்றுபடி கோதுமை மாவை எடுத்து ரொட்டிகள் தயார் செய்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","பிறகு ஆபிரகாம் தனது தொழுவத்துக்கு ஓடி இளமையான கன்றுக் குட்டியைத் தேர்ந்தெடுத்து, அதனை வேலைக்காரனிடம் கொடுத்தான். அதனை விரைவில் கொன்று உணவு தயாரிக்கும்படி கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ஆபிரகாம் இறைச்சியும், கொஞ்சம் பாலும், வெண்ணெயும் கொண்டு வந்து மூன்று பார்வையாளர்கள் முன்பு வைத்து அவர்கள் அருகில் பரிமாறுவதற்குத் தயாராக நின்றான். அவர்கள் மரத்தடியில் அமர்ந்து உண்ண ஆரம்பித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","பிறகு அவர்கள் ஆபிரகாமிடம், “உனது மனைவி சாராள் எங்கே?” என்று கேட்டனர். அதற்கு ஆபிரகாம், “அவள் அங்கே கூடாரத்தில் இருக்கிறாள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","பிறகு கர்த்தர், “நான் மீண்டும் அடுத்த ஆண்டு இதே நேரத்தில் திரும்பி வருவேன். அப்போது உன் மனைவி சாராள் ஒரு மகனோடு இருப்பாள்” என்றார். சாராள் கூடாரத்திலிருந்து இவற்றைக் கேட்டுக்கொண்டிருந்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","ஆபிரகாமும் சாராளும் மிகவும் முதியவர்களாக இருந்தனர். சாதாரணமாக பெண்கள் குழந்தை பெறுவதற்கான வயதை சாராள் கடந்திருந்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","எனவே, சாராள் அவர்கள் சொன்னதை நம்பவில்லை. அவள் தனக்குள், “நானும் முதியவள். என் கணவனும் முதியவர். நான் குழந்தை பெறமுடியாதபடி முதியவளாகிவிட்டேன்” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","கர்த்தர் ஆபிரகாமிடம், “சாராள், குழந்தை பெறமுடியாத அளவுக்கு முதியவளானதாகக் கூறிச் சிரிக்கிறாள். ");
INSERT INTO tam2008_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","கர்த்தருக்கு கடினமான காரியம் ஏதாவது இருக்கிறதா? இல்லை. நான் வசந்த காலத்தில் மீண்டும் வருவேன். அப்போது நான் சொன்னது நடக்கும். உனது மனைவி சாராள் மகனோடு இருப்பாள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","ஆனால் சாராளோ, “நான் சிரிக்கவில்லையே” என்றாள். (அவள் அச்சத்தால் இவ்வாறு சொன்னாள்) ஆனால் கர்த்தரோ, “இல்லை. நீ சொல்வது உண்மையன்று என எனக்குத் தெரியும், நீ சிரித்தாய்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","பிறகு அந்த மனிதர்கள் எழுந்து சென்றனர். அவர்கள் சோதோம் இருந்த திசை நோக்கிப் போனார்கள். ஆபிரகாமும் அவர்களோடு கொஞ்சம் தூரம் சென்று அவர்களை அனுப்பி வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","கர்த்தர் தனக்குள், “நான் செய்யப்போகிறவற்றை ஆபிரகாமிற்கு மறைக்கமாட்டேன். ");
INSERT INTO tam2008_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","ஆபிரகாம் ஒரு மகத்தான பலமிக்க தேசமாவான். அவனால் பூமியிலுள்ள ஜனங்கள் ஆசீர்வதிக்கப்படுவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","நான் ஆபிரகாமோடு சிறந்த உடன்படிக்கை ஒன்றைச் செய்து வைத்திருக்கிறேன். நான் இதைச் செய்ததால் அவன் தன் பிள்ளைகளையும், சந்ததிகளையும் எனது விருப்பப்படி வாழ கட்டளையிடுவான். அவர்கள் நீதியோடும், நேர்மையோடும் வாழும்படி அவர்களுக்குப் போதனை செய்வான் என அறிவேன். கர்த்தராகிய நான் வாக்குறுதியளித்தபடியே அவனுக்குச் செய்வேன்” என்று சொல்லிக்கொண்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","மேலும் கர்த்தர், “சோதோம், கொமோரா ஜனங்கள் மிகவும் பாவிகள் என்று நான் பல முறை கேள்விப்பட்டிருக்கிறேன். ");
INSERT INTO tam2008_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","எனவே நான் சோதோமின் உண்மை நிலை என்னவென்று போய்ப் பார்ப்பேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","ஆகையால், அந்த மனிதர்கள் திரும்பி சோதோமை நோக்கி நடக்க ஆரம்பித்தனர். ஆனால் ஆபிரகாம் கர்த்தருக்கு முன்னால் நின்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","பிறகு ஆபிரகாம் கர்த்தரிடம் நெருங்கி வந்து, “கர்த்தாவே! நீர் தீயவர்களை அழிக்கும்போதே நல்லவர்களையும் அழிக்கப்போகிறீரா? ");
INSERT INTO tam2008_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","அந்த நகரத்தில் 50 நல்ல மனிதர்கள் இருந்தால் என்ன செய்வீர்? அழித்துவிடுவீரா? உறுதியாக நீர் அந்த 50 நல்ல மனிதர்களுக்காக அந்நகரத்தைக் காப்பாற்றத்தான் வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","உம்மால் உறுதியாக அந்நகரத்தை அழிக்க முடியாது. தீயவர்களை அழிப்பதற்காக அந்த 50 நல்ல மனிதர்களையும் உம்மால் அழிக்க முடியாது. அவ்வாறு நடந்தால் பிறகு நல்ல மனிதர்களும் தீய மனிதர்களும் ஒரே மாதிரி ஆகிவிடுவார்கள். இருவருமே தண்டிக்கப்பட்டுவிடுவார்கள். பூமி முழுவதற்கும் நீரே நீதிபதி. நீர் நியாயமானவற்றையே செய்வீர் என்று எனக்குத் தெரியும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","பிறகு கர்த்தர், “என்னால் சோதோம் நகரத்தில் நல்லவர்கள் 50 பேரைக் காண முடியுமானால் நான் அந்த நகரத்தைக் காப்பாற்றுவேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","பிறகு ஆபிரகாம், “கர்த்தாவே, உம்மோடு ஒப்பிட்டுப் பார்க்கும்போது நான் வெறும் தூசியாகவும், சாம்பலாகவும் இருக்கிறேன். என்றாலும் இன்னும் ஒரு கேள்வியைக் கேட்க அனுமதியும். ");
INSERT INTO tam2008_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","அந்நகரத்தில் 45 நல்ல மனிதர்கள் மட்டுமே இருந்தால் என்ன செய்வீர்? அந்த முழு நகரத்தையும் அழித்துவிடுவீரா?” என்று கேட்டான். அதற்கு கர்த்தர், “நான் அங்கு 45 நல்ல மனிதர்களைக் கண்டால் அந்நகரத்தை அழிக்கமாட்டேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","ஆபிரகாம் மீண்டும் பேசினான். அவன், “நீர் 40 நல்ல மனிதர்களை மட்டும் கண்டால் அப்போது அந்நகரத்தை அழிப்பீரா?” என்று கேட்டான். அதற்குக் கர்த்தர், “நான் 40 நல்ல மனிதர்களைக் கண்டால் அந்நகரத்தை அழிக்கமாட்டேன்” என்று சொன்னார். ");
INSERT INTO tam2008_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","மேலும் ஆபிரகாம், “கர்த்தாவே தயவு செய்து என்மீது கோபம் கொள்ளாதிரும். இதையும் கேட்க அனுமதியும், அந்நகரத்தில் 30 நல்ல மனிதர்கள் மட்டும் இருந்தால், அந்நகரத்தை அழித்துவிடுவீரா?” என்று கேட்டான். அதற்குக் கர்த்தர், “நான் 30 நல்ல மனிதர்களைக் கண்டால் அந்நகரத்தை அழிக்கமாட்டேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","பிறகு ஆபிரகாம், “கர்த்தாவே மேலும் உம்மிடம் ஒன்று கேட்கலாமா? அந்நகரத்தில் 20 நல்ல மனிதர்கள் மட்டும் இருந்தால் என்ன செய்வீர்கள்?” என்று கேட்டான். அதற்குக் கர்த்தர், “நான் அங்கே 20 நல்ல மனிதர்களை மட்டும் கண்டாலும் அந்நகரத்தை அழிக்கமாட்டேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","மேலும் ஆபிரகாம், “கர்த்தாவே என் மீது கோபம்கொள்ள வேண்டாம். இறுதியாக இன்னொன்றைக் கேட்க அனுமதி தாரும். நீர் அங்கே 10 நல்ல மனிதர்களை மட்டும் கண்டால் என்ன செய்வீர்?” என்று கேட்டான். அதற்குக் கர்த்தர், “நான் 10 நல்ல மனிதர்களைக் கண்டாலும் அந்நகரத்தை அழிக்கமாட்டேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","கர்த்தர் ஆபிரகாமுடன் தன் பேச்சை முடித்து விட்டுப் போனார். ஆபிரகாமும் தன் வீட்டிற்குத் திரும்பினான். ");
INSERT INTO tam2008_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","2","அன்று மாலையில் இரண்டு தேவ தூதர்கள் சோதோம் நகரத்திற்கு வந்தனர். நகர வாசலில் இருந்துகொண்டு லோத்து தேவதூதர்களைப் பார்த்தான். அவர்கள் நகரத்துக்குப் போகும் பயணிகள் என்று நினைத்தான். அவன் எழுந்து அவர்களிடம் சென்று தரையில் குனிந்து வணங்கினான். லோத்து அவர்களிடம், “ஐயா, எனது வீட்டிற்கு வாருங்கள். நான் உங்களுக்குச் சேவை செய்வேன். உங்கள் பாதங்களைக் கழுவிக்கொண்டு இரவில் அங்கே தங்கி, நாளை உங்கள் பயணத்தைத் தொடரலாம்” என்றான். அதற்குத் தேவதூதர்கள், “இல்லை, நாங்கள் இரவில் வெட்டவெளியில் தங்குவோம்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","ஆனால் லோத்து தொடர்ந்து தன் வீட்டிற்கு வருமாறு அவர்களை வற்புறுத்தினான். அவர்களும் ஒப்புக்கொண்டு அவனது வீட்டிற்குப் போனார்கள். அவர்களுக்காக அவன் ஆயத்தம் செய்த ரொட்டியை அவர்கள் சாப்பிட்டார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","அன்று மாலை தூங்குவதற்கு முன்னால், லோத்தின் வீட்டிற்கு நகரின் பலபாகங்களில் இருந்தும் இளைஞர், முதியோர்கள் எனப் பலரும் கூடிவந்து வீட்டைச் சுற்றிலும் நின்றுகொண்டு அவனை அழைத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","அவர்கள், “இன்று இரவு உன் வீட்டிற்கு வந்த இருவரும் எங்கே? அவர்களை வெளியே அழைத்து வா, நாங்கள் அவர்களோடு பாலின உறவு கொள்ள வேண்டும்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","லோத்து வெளியே வந்து வீட்டின் கதவை அடைத்துக்கொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","லோத்து அவர்களிடம், “நண்பர்களே வேண்டாம். உங்களைக் கெஞ்சிக் கேட்டுக்கொள்கிறேன். இந்தக் கெட்டச் செயல்களைச் செய்ய வேண்டாம். ");
INSERT INTO tam2008_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","எனக்கு இரண்டு மகள்கள் இருக்கிறார்கள். அவர்கள் இதுவரை எந்த ஆணையும் அறியாதவர்கள். நான் அவர்களை உங்களுக்குத் தருகிறேன். நீங்கள் அவர்களோடு என்ன வேண்டுமானாலும் செய்துகொள்ளுங்கள். ஆனால் இந்த மனிதர்களை எதுவும் செய்து விடாதீர்கள். இவர்கள் என் வீட்டிற்கு வந்திருக்கிறார்கள். நான் அவர்களைப் பாதுகாக்க வேண்டும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","வீட்டைச் சுற்றி நின்றவர்கள், “எங்கள் வழியில் குறுக்கிடாதே” என்று சத்தமிட்டார்கள். பிறகு அவர்கள் தங்களுக்குள்ளேயே, “லோத்து நமது நகரத்திற்கு விருந்தாளியாக வந்தான். இப்போது நாம் எவ்வாறு நடந்துகொள்ள வேண்டும் என்று நமக்கே கூறுகிறான்” என்றனர். பிறகு அவர்கள் லோத்திடம், “நாங்கள் அந்த மனிதர்களை விட உனக்கே அதிகக் கொடுமையைச் செய்வோம்” என்று கூறி லோத்தை நெருங்கி வந்து, கதவை உடைப்பதற்கு முயன்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","ஆனால் லோத்தின் வீட்டிற்குள் இருந்த இருவரும் கதவைத் திறந்து லோத்தை வீட்டிற்குள் இழுத்து கதவை மூடிக்கொண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","பிறகு அவர்கள் கதவுக்கு வெளியே இருந்த இளைஞர்களும் முதியவர்களும் தங்கள் பார்வையை இழக்கும்படி செய்தனர். எனவே, அவர்களால் கதவு இருக்கும் இடத்தைக் கண்டுபிடிக்க முடியவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","அந்த இருவரும் லோத்திடம், “உன் குடும்பத்திலுள்ளவர்களில் யாராவது இந்த நகரத்தில் இருக்கிறார்களா? உனக்கு மரு மகன்களோ, மகன்களோ, மகள்களோ அல்லது வேறு யாராவது இந்நகரத்தில் இருந்தால் அவர்களை உடனே இந்நகரத்தைவிட்டு விலகச் சொல்ல வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","நாங்கள் இந்த நகரத்தை அழிக்கப் போகிறோம். இந்த நகரம் எவ்வளவு மோசமானது என்பதைப்பற்றி கர்த்தர் அறிந்தபடியால் இதனை அழிக்க எங்களை அனுப்பினார்” என்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","ஆகவே, லோத்து வெளியே போய், தனது மகள்களை மணந்துகொள்வதாயிருந்த மருமகன்களிடம், “வேகமாக இந்த நகரத்தை விட்டு வெளியேறுங்கள். விரைவில் கர்த்தர் இந்த நகரத்தை அழிக்கப் போகிறார்” என்றான். அவர்களோ அவன் வேடிக்கையாகப் பேசுவதாய் எண்ணினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","அடுத்த நாள் காலையில் தேவதூதர்கள் லோத்தை வெளியேற விரைவுபடுத்தினார்கள். அவர்கள், “இந்நகரம் தண்டிக்கப்படும். எனவே, உனது மனைவியையும், இரண்டு பெண்களையும், இன்னும் உன்னோடு வருகிறவர்களையும், அழைத்துக்கொண்டு இந்த இடத்தைவிட்டு விலகிப் போ. அவ்வாறு செய்தால் நீ இந்நகரத்தோடு அழியாமல் இருப்பாய்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","லோத்து குழப்பத்துடன் வேகமாகப் புறப்படாமல் இருந்தான், எனவே அந்த இரண்டு தேவதூதர்கள் அவன், அவனது மனைவி, மகள்கள் ஆகியோரின் கையைப் பிடித்து அவர்களைப் பாதுகாப்பாக நகரத்தை விட்டு வெளியே அழைத்துச் சென்றனர். லோத்தோடும் அவனது குடும்பத்தோடும் கர்த்தர் மிகவும் கருணை உடையவராக இருந்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","எனவே, இரு தேவதூதர்களும் லோத்தையும் அவன் குடும்பத்தையும் பாதுகாப்பாக நகரத்திற்கு வெளியே கொண்டு வந்தபின்னர் தூதர்களில் ஒருவன், “இப்போது உங்கள் உயிரைக் காப்பாற்றிக்கொள்ள ஓடிப் போங்கள். இந்நகரத்தைத் திரும்பிப் பார்க்காதீர்கள். இந்தச் சமவெளியில் எங்கும் நிற்காதீர்கள். மலைக்குப் போய்ச் சேரும்வரை ஓடுங்கள். இடையில் நின்றால் நகரத்தோடு நீங்களும் அழிந்துபோவீர்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","ஆனால் லோத்து அந்த இருவரிடமும், “ஐயா, அவ்வளவு தூரத்துக்கு ஓடும்படி என்னைக் கட்டாயப்படுத்தாதீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","உங்கள் சேவகனாகிய என் மீது நீங்கள் மிகவும் இரக்கம் வைத்திருக்கிறீர்கள். என்னைக் காப்பாற்ற கருணையுடன் இருக்கிறீர்கள். ஆனால் மலைவரை என்னால் ஓட முடியாது. நான் மரித்துப்போய்விட வாய்ப்புண்டு. ");
INSERT INTO tam2008_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","அருகில் ஒரு சிறிய நகரம் உள்ளது. என்னை அந்நகரத்திற்கு ஓடிப்போகவிடுங்கள். அந்த அளவுக்கு என்னால் ஓடி என்னை பாதுகாத்துக்கொள்ள முடியும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","அதற்குத் தேவதூதன், “நல்லது, அவ்வாறு செய்ய உன்னை அனுமதிக்கிறேன். நான் அந்நகரத்தை அழிக்கமாட்டேன். ");
INSERT INTO tam2008_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","ஆனால் அங்கு வேகமாக ஓடு. அங்கு நீ பாதுகாப்பாகப் போய்ச் சேரும்வரை சோதோம் நகரத்தை அழிக்கமாட்டேன்” என்றான். (அந்நகரின் பெயர் சோவார். ஏனெனில் அது மிகச் சிறிய நகரம்) ");
INSERT INTO tam2008_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","சூரியன் உதயமானபோது லோத்து சோவார் நகரத்திற்குள் நுழைந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","அதே நேரத்தில் கர்த்தர் சோதோமையும் கோமோராவை அழிக்க ஆரம்பித்தார். கர்த்தர் வானத்திலிருந்து நெருப்பையும் கந்தகத்தையும் அந்நகரின் மேல் விழுமாறு செய்து, ");
INSERT INTO tam2008_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","அந்த நகரங்களையும் அதன் முழு சமவெளியையும், அங்கிருந்த செடிகளையும், ஜனங்களையும் அழித்துவிட்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","அவர்கள் ஓடிப்போகும்போது லோத்தின் மனைவி திரும்பிப் பார்த்தாள். அதனால் அவள் உப்புத்தூண் ஆனாள். ");
INSERT INTO tam2008_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","அதே நாள் அதிகாலையில், ஆபிரகாம் எழுந்து கர்த்தரை தொழுதுகொள்ளும் இடத்துக்குச் சென்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","அவன் அங்கிருந்து சோதோம், கொமோரா நகரங்கள் இருக்கும் திசையையும், அதன் சமவெளியையும் பார்த்தபோது அங்கிருந்து புகை எழும்புவதைக் கண்டான். அது பெரிய நெருப்பினால் ஏற்படும் புகைபோல் தோன்றியது. ");
INSERT INTO tam2008_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","தேவன் பள்ளத்தாக்கில் உள்ள நகரங்களை அழித்துவிட்டார். அப்போது அவர் ஆபிரகாமை நினைத்து, ஆபிரகாமின் உறவினனான லோத்தை அழிக்காமல் விட்டார். பள்ளத்தாக்கில் இருக்கும் நகரங்களுக்குள் லோத்து வாழ்ந்துகொண்டிருந்த அவ்விடங்களை அழிக்கும் முன்பு லோத்தை தேவன் வெளியேற்றினார். ");
INSERT INTO tam2008_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","சோவாரில் தங்கியிருக்க லோத்துவுக்கு அச்சமாக இருந்தது. எனவே, அவனும் அவனது மகள்களும் மலைக்குச் சென்று அங்கு ஒரு குகையில் வசித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ஒரு நாள் மூத்தவள் இளையவளிடம், “உலகில் எல்லா இடங்களிலும் ஆண்களும் பெண்களும் மணந்துகொண்டு குடும்பமாக வாழ்கிறார்கள். ஆனால் நமது தந்தையோ வயதானவராக உள்ளார். நமக்கு குழந்தை தர வேறு ஆண்களும் இங்கே இல்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","எனவே, நாம் தந்தைக்கு மதுவைக் கொடுக்கலாம். அவர் மயங்கியபின் அவரோடு பாலின உறவு கொள்ளலாம். இப்படியாக நமக்குச் சந்ததி உண்டாக நம் தந்தையைப் பயன்படுத்திக்கொள்ளலாம்” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","அன்று இரவு இரண்டு பெண்களும் தந்தைக்கு மதுவைக் கொடுத்து குடிக்க வைத்தனர். பிறகு மூத்தவள் தந்தையின் படுக்கைக்குச் சென்று அவரோடு பாலின உறவு கொண்டாள். லோத்துவுக்குத் தன் மகள் தன்னோடு படுத்ததும், எழுந்து போனதும் தெரியவில்லை. அந்த அளவுக்குக் குடித்திருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","மறுநாள் மூத்தவள் இளையவளிடம்: “நேற்று இரவு நான் தந்தையோடு பாலின உறவு கொண்டேன். இன்று இரவும் அவரை மீண்டும் குடிக்க வைப்போம். பிறகு நீ அவரோடு பாலின உறவுகொள். இதன் மூலம் நாம் குழந்தை பெற நம் தந்தையைப் பயன்படுத்திக்கொள்ளலாம். நம் குடும்பமும் அழியாமல் இருக்கும்” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","அதனால் இருவரும் அந்த இரவிலும் தந்தையை மது குடிக்கும்படி செய்தனர். பிறகு இளையவள் தந்தையோடு படுத்து பாலின உறவு கொண்டாள். லோத்து மதுவைக் குடித்திருந்தபடியால் அவள் படுத்ததையும், எழுந்து போனதையும் அறியாமலிருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","லோத்தின் இரு மகள்களும் கர்ப்பமுற்றனர். அவர்களின் தந்தையே அவர்களது பிள்ளைகளுக்கும் தந்தை. ");
INSERT INTO tam2008_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","மூத்தவள் ஒரு ஆண் குழந்தையைப் பெற்றாள். அவள் அவனுக்கு மோவாப் என்று பெயர் வைத்தாள். அவன் மோவாபியருக்கெல்லாம் தந்தையானான். ");
INSERT INTO tam2008_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","இளையவளும் ஒரு ஆண் குழந்தையைப் பெற்றாள். அவனுக்கு அவள் பென்னம்மி என்று பெயரிட்டாள். அவன் அம்மோன் ஜனங்களுக்குத் தந்தை ஆனான். ");
INSERT INTO tam2008_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ஆபிரகாம் அந்த நாட்டைவிட்டுப் பாலைவனப் பகுதிக்குச் சென்றான். அவன் காதேசுக்கும், சூருக்கும் நடுவிலுள்ள கேராரில் தங்கினான். ");
INSERT INTO tam2008_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","அவன் கேராரிலே தங்கி இருந்தபோது தன் மனைவி சாராளைச் சகோதரி என்று சொன்னான். அபிமெலேக்குக் கேராரின் அரசன். அவன் சாராளை மிகவும் விரும்பினான். எனவே, வேலைக்காரர்களை அனுப்பி அவளைக் கொண்டு வருமாறு சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","ஆனால் இரவில் தேவன் அபிமெலேக்கின் கனவிலே பேசி, “நீ மரித்து போவாய். நீ கைப்பற்றிய பெண் திருமணமானவள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","ஆகையால் அபிமெலேக்குச் சாராளைத் தொடவில்லை. அவன் தேவனிடம், “கர்த்தாவே! நான் குற்றமுடையவன் அல்ல. ஒன்றும் தெரியாத அப்பாவியை நீர் கொல்வீரா? ");
INSERT INTO tam2008_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","ஆபிரகாமே என்னிடம், ‘இவள் என் சகோதரி’ என்று சொன்னானே! சாராளும் ஆபிரகாமை ‘இவர் என் சகோதரன்’ என்று கூறிவிட்டாள். நான் அப்பாவி. நான் வேண்டுமென்றே இதைச் செய்யவில்லை” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","தேவன் அவனிடம், “நீ என்ன மனநிலையில் இதைச் செய்தாய் என்று எனக்குத் தெரியும். நீ என்ன செய்கிறாய் என்பது உனக்குத் தெரியாது. நீ எனக்கு எதிராகப் பாவம் செய்யாதபடி நான் உன்னைக் காப்பாற்றினேன். நீ அவளைத் தொடாதபடி நானே உன்னைத் தடுத்தேன். ");
INSERT INTO tam2008_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ஆகவே ஆபிரகாமிடம் அவன் மனைவியைத் திரும்பக் கொடுத்துவிடு. ஆபிரகாம் ஒரு தீர்க்கதரிசி. அவன் உனக்காக ஜெபிப்பான். நீ வாழ்வாய். ஆனால் நீ சாராளை ஆபிரகாமிடம் திரும்பக் கொடுக்காவிட்டால் நீயும் உன்னைச் சேர்ந்தவர்களும் மரித்துப்போவீர்கள் என்று அறிந்துகொள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","எனவே, மறுநாள் அதிகாலையில், அபிமெலேக்கு தன் வேலைக்காரர்களை அழைத்து, நடந்த வைகளைப்பற்றிக் கூறினான், அவர்கள் பயந்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","பிறகு அபிமெலேக்கு ஆபிரகாமை அழைத்து அவனிடம்: “நீ ஏன் எங்களுக்கு இதுபோல் செய்தாய்? உனக்கு எதிராக நான் என்ன செய்தேன்? அவள் உன் சகோதரி என்று ஏன் பொய் சொன்னாய்? எனது அரசுக்கு நீ நிறைய தொந்தரவுகளைக் கொடுத்துவிட்டாய். நீ இவ்வாறு செய்திருக்கக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","நீ எதற்காகப் பயந்தாய்? ஏன் இவ்வாறு செய்தாய்” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","பிறகு ஆபிரகாம், “நான் பயந்துவிட்டேன், இந்த இடத்தில் உள்ள எவரும் தேவனை மதிக்கமாட்டார்கள் என்று நினைத்தேன். சாராளுக்காக என்னை எவராவது கொன்று விடுவார்களோ என்று நினைத்தேன். ");
INSERT INTO tam2008_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","அவள் எனது மனைவி, ஆனால் அவள் என் சகோதரியும் கூட, அவள் என் தந்தைக்கு மகள். ஆனால் என் தாய்க்கு மகளல்ல. ");
INSERT INTO tam2008_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","தேவன் என்னை என் தந்தையின் வீட்டிலிருந்து வெளியே கொண்டு வந்து என்னைப் பல்வேறு இடங்களில் அலைந்து திரியும்படி செய்திருக்கிறார். அப்போதெல்லாம் சாராளிடம், ‘நாம் எங்கு சென்றாலும் நான் உன் சகோதரன் என்று சொல்லு’ என்று கேட்டுக்கொண்டேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","என்ன நடந்தது என்பதை அபிமெலேக்கு புரிந்துகொண்டான். எனவே சாராளைத் திரும்ப ஆபிரகாமிடம் அனுப்பிவிட்டான். அவளுக்குச் சில ஆடுகளையும் மாடுகளையும் அடிமைகளையும் கொடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","பிறகு, “உன்னைச் சுற்றிலும் பார், இது எனது நிலம், நீ விரும்புகிற எந்த இடத்திலும் வாழலாம்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","அவன் சாராளிடம், “நான் உன் சகோதரன், ஆபிரகாமிடம் 1,000 வெள்ளிக் காசுகள் கொடுத்தேன். நடந்தவற்றுக்கு வருத்தம் தெரிவிக்கவே அவ்வாறு செய்தேன். நான் செய்தது சரியென்று எல்லோருக்கும் தெரியவேண்டும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","கர்த்தர், சாராளினிமித்தம் அபிமெலேக்கின் குடும்பத்தில் எவருக்கும் குழந்தை இல்லாமல் இருக்கும்படி செய்திருந்தார். இப்போது ஆபிரகாம் தேவனிடம் வேண்டிக்கொள்ளவே, தேவன் அபிமெலேக்கு, அவன் மனைவி, வேலைக்காரப் பெண்கள் அனைவரையும் குணப்படுத்தினார். ");
INSERT INTO tam2008_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","கர்த்தர், சாராளுக்குக் கொடுத்திருந்த வாக்குறுதியை நிறைவேற்றினார். ");
INSERT INTO tam2008_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","சாராள் கர்ப்பமுற்றாள். ஆபிரகாமின் வயோதிப காலத்தில் அவனுக்கு ஓர் ஆண் மகனைப் பெற்றுக் கொடுத்தாள். இவையெல்லாம் தேவன் வாக்களித்தபடியே நடந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","சாராள் ஒரு மகனைப் பெற்றெடுத்தாள். ஆபிரகாம் அவனுக்கு ஈசாக்கு என்று பெயரிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","ஈசாக்கு பிறந்து எட்டு நாள் கழிந்தபோது ஆபிரகாம் அவனுக்கு விருத்தசேதனம் செய்து வைத்தான். தேவனின் ஆணைப்படி இவ்வாறு நடந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","ஈசாக்கு பிறக்கும்போது அவனது தந்தை ஆபிரகாமுக்கு 100 வயதாயிருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","சாராள், “தேவன் என்னை மகிழ்ச்சியடையச் செய்தார். இதைக் கேள்விப்படும் எவரும் என்னோடு சேர்ந்து மகிழ்ச்சியடைவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","ஆபிரகாமின் குழந்தையை நான் பெற்றெடுப்பேன் என்று எவரும் நினைத்திருக்கமாட்டார்கள். ஆனால் நான் இந்த வயோதிப காலத்திலும் அவருக்கு ஆண் பிள்ளையைப் பெற்றுக் கொடுத்தேன்” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ஈசாக்கு பால்குடிக்க மறக்கும் நாளில் ஆபிரகாம் பெரிய விருந்து கொடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ஆகார் என்னும் எகிப்திய அடிமைப்பெண் ஆபிரகாமின் முதல் மகனைப் பெற்றிருந்தாள். சாராள் அவனைப் பார்த்தாள். அவன் கேலிச் செய்துகொண்டிருப்பதைக் கண்டு அவளுக்கு அவன் மேல் எரிச்சல் வந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","சாராள் ஆபிரகாமிடம், “இந்த அடிமைப் பெண்ணையும் அவள் மகனையும் வெளியே தள்ளும். நாம் சாகும்போது நமக்குரிய அனைத்தையும் ஈசாக்கே பெற வேண்டும். அந்த அடிமைப் பெண்ணின் மகன் அதில் பங்கு போடுவதை நான் விரும்பவில்லை” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","இது ஆபிரகாமுக்கு துயரத்தைத் தந்தது. அவன் தன் மகன் இஸ்மவேலைப்பற்றிக் கவலைப்பட ஆரம்பித்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","ஆனால் தேவன் ஆபிரகாமிடம், “அடிமைப் பெண்ணையும், அவள் மகனையும்பற்றிக் கவலைப்படாதே, சாராள் விரும்புவது போலவே செய். ஈசாக்கு ஒருவனே உனது வாரிசு. ");
INSERT INTO tam2008_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","ஆனால் நான் உனது அடிமைப் பெண்ணின் மகனையும் ஆசீர்வதிப்பேன். அவனும் உன் மகன் என்பதால் அவனிடமிருந்தும் ஒரு பெரிய தேசத்தை உருவாக்குவேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","மறுநாள் அதிகாலையில் ஆபிரகாம் கொஞ்சம் தண்ணீரும், உணவும் எடுத்து அவற்றை ஆகாரிடம் கொடுத்தான். அவள் அவற்றை எடுத்துக்கொண்டு தன் மகனோடு வெளியேறி, பெயெர்செபா பாலைவனத்தில் அலைந்து திரிந்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","கொஞ்ச நேரம் கழிந்ததும் தண்ணீர் தீர்ந்து போனதால் குடிப்பதற்கு எதுவும் இல்லாமல் போயிற்று. எனவே ஆகார் தன் மகனை ஒரு புதரின் அடியில் விட்டாள். ");
INSERT INTO tam2008_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ஆகார் கொஞ்ச தூரம் போய் உட்கார்ந்தாள். அவள் தன் மகன் தண்ணீர் இல்லாமலேயே மரித்துப்போவான் என்று எண்ணினாள். அவன் மரிப்பதை அவள் பார்க்க விரும்பவில்லை. எனவே அவள் அங்கே உட்கார்ந்து அழ ஆரம்பித்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","சிறுவனின் அழுகையை தேவன் கேட்டார். தேவதூதன் வானத்திலிருந்து ஆகாரைக் கூப்பிட்டு: “ஆகாரே! உனக்கு என்ன நடந்தது? அஞ்ச வேண்டாம், கர்த்தர் சிறுவனின் அழுகையைக் கேட்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","போய் சிறுவனுக்கு உதவி செய், அவனது கையைப் பிடித்து வழிநடத்திச்செல். நான் அவனை ஏராளமான ஜனங்களுக்குத் தந்தையாக்குவேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","பிறகு தேவன், ஆகாரை ஒரு கிணற்றைப் பார்க்கும்படிச் செய்தார். அவள் அந்த கிணற்றின் அருகே சென்று, தன் பை நிறைய தண்ணீரை நிரப்பியதுடன், தன் மகனுக்கும் குடிக்கக் கொடுத்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","அவன் வளர்ந்து ஆளாகும்வரை தேவன் அவனோடு இருந்தார். இஸ்மவேல் பாலைவனத்தில் வாழ்ந்து பெரிய வேட்டைக்காரன் ஆனான். வில்லைப் பயன்படுத்தத் தெரிந்துகொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","அவனது தாய் அவனுக்கொரு மனைவியை எகிப்தில் கண்டுபிடித்தாள். அவர்கள் பாரான் பாலைவனத்தில் வாழ்ந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","இவைகளுக்குப் பின்னர் அபிமெலேக்கும் பிகோலும் ஆபிரகாமோடு பேசினர். பிகோல் அபிமெலேக்கின் படைத் தளபதி. அவர்கள் ஆபிரகாமிடம், “நீ செய்கிற எல்லாவற்றிலும் தேவன் உன்னோடு இருக்கிறார். ");
INSERT INTO tam2008_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","எனவே இப்போது எனக்கு தேவனுக்கு முன்பு ஒரு வாக்குறுதி கொடு. நீ என்னோடும், என் பிள்ளைகளோடும் நியாயமாக நடந்துகொள்வேன் என்றும், நீ என்னோடும், நீ வாழ்கிற இந்தத் தேசத்தோடும் கருணையாய் இருப்பேன் என்றும் வாக்குறுதிகொடு. நான் உன்னோடு கருணையாய் இருப்பதுபோன்று நீ என்னோடு கருணையாய் இருப்பதாக உறுதியளி” என்று கேட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","ஆபிரகாமோ, “நீங்கள் என்னை நடத்துவது போன்று நானும் உங்களை நடத்துவேன்” என்று சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","பிறகு ஆபிரகாம் அபிமெலேக்கிடம் அரசனின் ஆட்கள் அவனது கிணற்றை அபகரித்துக்கொண்டதாய் முறையிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","ஆனால் அபிமெலேக்கோ, “யார் இதைச் செய்தது என்று எனக்குத் தெரியாது, இதற்கு முன் நீ எனக்கு இதைப்பற்றி சொல்லவில்லை” என்று கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","ஆகவே, அபிமெலேக்கும் ஆபிரகாமும் ஒரு ஒப்பந்தம் செய்துகொண்டனர். அதன்படி ஆபிரகாம் அரசனுக்குச் சில ஆடுகளையும் மாடுகளையும் ஒப்பந்தத்தின் அத்தாட்சியாகக் கொடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","ஆபிரகாம் ஏழு பெண் ஆட்டுக்குட்டிகளையும் தனியாக அபிமெலேக்கு முன்பு நிறுத்தினான். ");
INSERT INTO tam2008_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","அபிமெலேக்கு ஆபிரகாமிடம், “ஏன் இவற்றைத் தனியாக இதுபோல் நிறுத்தியிருக்கிறாய்” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","அதற்கு ஆபிரகாம், “என்னிடத்திலிருந்து நீ இவற்றை ஏற்றுக்கொண்டால், அது நான் இந்தக் கிணற்றைத் தோண்டியதற்கு அடையாளமாகும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","அதற்குப் பிறகு அந்தக் கிணறு பெயெர் செபா என்று அழைக்கப்பட்டது. ஒருவருக்கொருவர் ஒப்பந்தம் செய்துகொண்ட இடம் என்று இதற்குப் பொருள். ");
INSERT INTO tam2008_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","இவ்வாறு அபிமெலேக்கும் ஆபிரகாமும் அந்த இடத்தில் ஒரு ஒப்பந்தம் செய்துகொண்ட பின்னர் அபிமெலேக்கும் அவனது படையும் அந்த இடத்தை விட்டு பெலிஸ்தருடைய நாட்டுக்குத் திரும்பிப் போனார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","ஆபிரகாம் பெயெர்செபாவில் ஒரு புதிய மரத்தை நட்டு என்றென்றும் ஜீவிக்கும் தேவனாகிய கர்த்தரிடம் ஜெபித்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ஆபிரகாம் பெலிஸ்தருடைய நாட்டில் நீண்ட காலம் தங்கியிருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","இதற்குப் பிறகு, தேவன் ஆபிரகாமின் விசுவாசத்தைச் சோதிக்க விரும்பினார். எனவே தேவன் “ஆபிரகாமே” என்று அழைத்தார். ஆபிரகாமும், “நான் இங்கே இருக்கிறேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","தேவன் அவனிடம், “உன்னுடைய அன்பிற்குரிய, ஒரே மகனான ஈசாக்கை அழைத்துக்கொண்டு மோரியா தேசத்திற்குச் செல். அங்கு உன் மகனை எனக்கு தகன பலியாகக் கொடு. எந்த இடத்தில் அதைச் செய்ய வேண்டுமென்று நான் உனக்குச் சொல்வேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","காலையில் ஆபிரகாம் எழுந்து தனது கழுதையைத் தயார் செய்தான். ஈசாக்கையும் இரண்டு வேலைக்காரர்களையும் அழைத்துக்கொண்டான். பலிக்கு விறகுகளையும் எடுத்துக்கொண்டான். தேவன் போகச் சொன்ன இடத்திற்கு அவர்கள் போனார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","அவர்கள் மூன்று நாட்கள் பயணம் செய்தபின் தொலைவில் தேவன் குறிப்பிட்ட இடம் தெரிந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","ஆபிரகாம் தனது வேலைக்காரர்களிடம், “கழுதையோடு நீங்கள் இங்கேயே தங்கியிருங்கள், நானும் என் மகனும் அவ்விடத்திற்கு தொழுதுகொள்ளப் போகிறோம். பிறகு உங்களிடம் திரும்பி வருவோம்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","பலிக்கான விறகுகளை எடுத்து மகனின் தோள் மீது வைத்தான். ஆபிரகாம் கத்தியையும், நெருப்பையும் எடுத்துக்கொண்டு, அவனும் அவனது மகனும் சேர்ந்து போனார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ஈசாக்கு தன் தந்தையைப் பார்த்து, “அப்பா” என்று அழைத்தான். ஆபிரகாமும், “என்ன மகனே” எனக் கேட்டான். ஈசாக்கு அவனிடம், “விறகும், நெருப்பும் நம்மிடம் உள்ளது. பலியிடுவதற்கான ஆட்டுக்குட்டி எங்கே?” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","அதற்கு ஆபிரகாம், “தேவனே தனக்கான பலிக்குரிய ஆட்டுக்குட்டியைக் கொடுப்பார் மகனே” என்று பதில் சொன்னான். ஆபிரகாமும் அவனது மகனும் ");
INSERT INTO tam2008_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","தேவன் போகச் சொன்ன இடத்திற்கு போய்ச் சேர்ந்தனர். அங்கே ஆபிரகாம் ஒரு பலிபீடத்தை கட்டி அதின்மேல் விறகுகளை அடுக்கினான். பின் தன் மகன் ஈசாக்கைப் பலிபீடத்தின்மேல் கிடத்தினான். ");
INSERT INTO tam2008_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","பிறகு ஆபிரகாம் கத்தியை எடுத்து மகனை வெட்டுவதற்குத் தயாரானான். ");
INSERT INTO tam2008_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","அப்போது கர்த்தருடைய தூதன் ஆபிரகாமைத் தடுத்து நிறுத்தி, “ஆபிரகாமே ஆபிரகாமே” என்று அழைத்தார். ஆபிரகாம், “நான் இங்கே இருக்கிறேன்” என்று பதிலளித்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","தேவதூதன்: “உனது மகனைக் கொல்ல வேண்டாம். அவனை எவ்விதத்திலும் காயப்படுத்த வேண்டாம். நீ தேவனை மதிப்பவன் என்றும், கீழ்ப்படிபவன் என்பதையும் நான் தெரிந்துகொண்டேன். நீ எனக்காக உன் ஒரே ஒரு மகனையும் கொல்லத் தயாராக உள்ளாய் என்பதையும் தெரிந்துகொண்டேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","ஆபிரகாம் தொலைவில் தன் கண் முன் ஒரு ஆட்டுக் கடாவைக் கண்டான். அதன் கொம்புகள் புதரில் சிக்கிக்கொண்டிருந்தன. ஆபிரகாம் அதனை விடுவித்து தேவனுக்குப் பலியிட்டான். ஆபிரகாமின் மகன் காப்பாற்றப்பட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","அதனால் ஆபிரகாம் அந்த இடத்திற்கு, “யேகோவா யீரே” என்று பெயரிட்டான். “கர்த்தருடைய பர்வதத்திலே பார்த்துக்கொள்ளப்படும்” என்று இன்றைக்கும் கூட ஜனங்கள் கூறுகின்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","கர்த்தருடைய தூதன் இரண்டாவது முறையும் வானத்திலிருந்து ஆபிரகாமை அழைத்து, ");
INSERT INTO tam2008_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“எனக்காக உன் மகனைக் கொல்லத் தயாராக இருந்தாய், இவன் உனது ஒரே மகன். இதை எனக்காகச் செய்தாய். ");
INSERT INTO tam2008_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","கர்த்தராகிய நான் உண்மையாகவே உன்னை ஆசீர்வதிப்பேன். வானத்தில் உள்ள நட்சத்திரங்களைப்போன்று நான் உன் சந்ததியைப் பெருகச் செய்வேன். கடற்கரையிலுள்ள மணலைப் போன்று எண்ணற்ற வாரிசுகளையும் தருவேன். உனது ஜனங்கள் தங்கள் பகைவர்களை வெல்லுவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","பூமியிலுள்ள ஒவ்வொரு நாடும் உனது சந்ததி மூலம் ஆசீர்வாதத்தைப்பெறும். நீ எனக்குக் கீழ்ப்படிந்தாய். அதனால் இதை நான் உனக்குச் செய்வேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","பிறகு, ஆபிரகாம் தன் வேலைக்காரர்கள் இருக்குமிடத்திற்குச் சென்றான், அவர்கள் அனைவரும் பெயெர்செபாவுக்குத் திரும்பினார்கள். ஆபிரகாம் அங்கேயே தங்கியிருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","இவை எல்லாம் நடந்து முடிந்த பிறகு ஆபிரகாமுக்கு ஒரு செய்தி வந்தது. அதில், “உனது சகோதரன் நாகோருக்கும் அவனது மனைவி மில்காளுக்கும் குழந்தைகள் பிறந்துள்ளனர். ");
INSERT INTO tam2008_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","முதல் மகனின் பெயர் ஊத்ஸ். இரண்டாவது மகனின் பெயர் பூஸ். மூன்றாவது மகனின் பெயர் கேமுவேல். இவன் ஆராமின் தந்தை. ");
INSERT INTO tam2008_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","மேலும் கேசேத், ஆசோ, பில்தாஸ், இத்லாப், பெத்துவேல் என்பவர்களும் உள்ளனர். பெத்துவேல் ரெபெக்காளைப் பெற்றான்” என்று கூறப்பட்டிருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","அந்த எட்டு பேரை மில்க்காள் ஆபிரகாமுடைய சகோதரனாகிய நாகோருக்குப் பெற்றாள். நாகோர் ஆபிரகாமின் சகோதரன். ");
INSERT INTO tam2008_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ரேயுமாள் என்ற அவனது வேலைக்காரி தேபா, காகாம், தாகாஸ், மாகா என்பவர்களைப் பெற்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","சாராள் 127 ஆண்டுகள் வாழ்ந்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","அவள் கானான் நாட்டில் உள்ள கீரியாத் அர்பா (எபிரோன்) எனும் நகரத்தில் மரணமடைந்தாள். ஆபிரகாம் மிகவும் துக்கப்பட்டு அவளுக்காக அழுதான். ");
INSERT INTO tam2008_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","பிறகு அவன் மரித்துப்போன மனைவியின் உடலை விட்டு எழுந்து போய் ஏத்தின் ஜனங்களோடு பேசினான். ");
INSERT INTO tam2008_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","அவன், “நான் உங்கள் நாட்டில் தங்கி இருக்கும் ஒரு பிரயாணி. எனவே என் மனைவியை அடக்கம் செய்ய எனக்கு இடமில்லை. கொஞ்சம் இடம் தாருங்கள், என் மனைவியை அடக்கம் செய்ய வேண்டும்” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","ஏத்தின் ஜனங்களோ ஆபிரகாமிடம், ");
INSERT INTO tam2008_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“ஐயா எங்களிடமுள்ள மகா தேவனின் தலைவர்களுள் நீங்களும் ஒருவர். உமது மனைவியின் பிணத்தை அடக்கம் செய்ய எங்களிடமுள்ள எந்த நல்ல இடத்தையும் நீர் எடுத்துக்கொள்ளலாம். எங்களுக்குரிய கல்லறைகளில் உமக்கு விருப்பமான எதையும் நீர் பெறமுடியும். உமது மனைவியை அங்கே அடக்கம் செய்வதை எங்களில் எவரும் உம்மைத் தடுக்கமாட்டார்கள்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","ஆபிரகாம் எழுந்து அவர்களைக் குனிந்து வணங்கினான். ");
INSERT INTO tam2008_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","அவன் அவர்களிடம், “நீங்கள் உண்மையில் எனக்கு என் மனைவியை அடக்கம் செய்ய உதவ விரும்பினால், சோகாருடைய மகனாகிய எப்பெரோனுக்குச் சொல்லுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","நான் மக்பேலா எனப்படும் குகையை விலைக்கு வாங்க விரும்புகிறேன். அது எப்பெரோனுக்கு உரியது. அது இந்த வயலின் இறுதியில் உள்ளது. நான் அவனுக்கு முழு விலையையும் கொடுத்துவிடுவேன். நீங்கள் அனைவரும் இதற்குச் சாட்சியாக இருக்க வேண்டும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","எப்பெரோன் ஏத்தின் ஜனங்களிடையில் உட்கார்ந்திருந்தான். அவன் ஆபிரகாமிடம், ");
INSERT INTO tam2008_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“இல்லை ஐயா, நான் அந்த நிலத்தையும் குகையையும் உமக்குத் தருவேன். நீர் உமது மனைவியை அதில் அடக்கம் செய்யலாம்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","பிறகு ஆபிரகாம் ஏத்தின் ஜனங்களிடம் குனிந்து வணங்கினான். ");
INSERT INTO tam2008_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ஆபிரகாம் அனைவருக்கும் முன்பாக எப்பெரோனிடம், “ஆனால் நான் அதற்குரிய விலையைக் கொடுப்பேன். என்னுடைய பணத்தை ஏற்றுக்கொள்ள வேண்டும். அதன் பின் என் மனைவியை அடக்கம் செய்வேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","எப்பெரோன் ஆபிரகாமுக்கு, ");
INSERT INTO tam2008_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“ஐயா, நான் சொல்வதைக் கேளுங்கள். நானூறு சேக்கல் நிறை வெள்ளி என்பது உங்களுக்கும் எனக்கும் சாதாரணமானது. எனவே நிலத்தை எடுத்துக்கொண்டு மரித்த உங்கள் மனைவியை அடக்கம் செய்யுங்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","அதனால் ஆபிரகாம் நானூறு சேக்கல் நிறை வெள்ளியை எடையிட்டுக் கொடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","எனவே, எப்பெரோனுடைய நிலம் ஆபிரகாமுக்குக் கிடைத்தது. இது மம்ரேவின் கிழக்குப் பகுதியிலுள்ள மக்பேலாவில் இருந்தது. ஆபிரகாமுக்கு அந்த நிலமும் அதிலுள்ள மரங்களும் குகையும் சொந்தமாயின. அவன் செய்த ஒப்பந்தத்தை அங்கு அனைத்து ஜனங்களும் கண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","இதற்குப் பிறகே ஆபிரகாம் தன் மனைவியான சாராளை மம்ரே அருகிலுள்ள கல்லறையில் அடக்கம் செய்தான். (இது கானான் நாட்டிலுள்ள எப்பெரோன்.) ");
INSERT INTO tam2008_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","இப்படி ஏத்தின் ஜனங்களிடமிருந்து பெறப்பட்ட நிலம் ஆபிரகாமுக்கு உரியதாகிக் கல்லறை பூமியாக உறுதி செய்யப்பட்டது. ");
INSERT INTO tam2008_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ஆபிரகாம் மிகவும் வயோதிபனாக இருந்தான். அவனையும், அவன் செய்த காரியங்களையும் கர்த்தர் ஆசீர்வதித்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","ஆபிரகாமுக்கு ஒரு வேலைக்காரன் இருந்தான். அவனே ஆபிரகாமுக்குச் சொந்தமான எல்லாவற்றுக்கும் பொறுப்பானவனாக இருந்தான். ஒரு நாள் ஆபிரகாம் அவனை அழைத்து, “எனது தொடையின் கீழ் உன் கைகளை வை. ");
INSERT INTO tam2008_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","நான் உன்னிடமிருந்து ஒரு வாக்குறுதியை வாங்க விரும்புகிறேன், வானத்திற்கும் பூமிக்கும் அதிபதியான தேவனாகிய கர்த்தருக்கு முன்னால் எனக்கு வாக்குறுதிக் கொடு. கானானியர்களிடமிருந்து ஒரு பெண்ணை என் மகன் மணந்துகொள்ள நீ அனுமதிக்கக் கூடாது. நாம் இவர்கள் மத்தியில் வாழ்கிறோம். எனினும் ஒரு கானான் தேசத்துப் பெண்ணை, அவன் மணந்துகொள்ளக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","எனது சொந்த ஜனங்கள் இருக்கிற என் நாட்டிற்குத் திரும்பிப்போ. அங்கு என் மகன் ஈசாக்குக்கு மணமுடிக்க ஒரு பெண்ணைப் பார்த்து அவளை இங்கு அழைத்துக்கொண்டு வா” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","அதற்கு அந்த வேலைக்காரன், “ஒருவேளை அந்தப் பெண் இந்த நாட்டிற்கு என்னோடு வர மறுக்கலாம். எனவே உங்கள் மகனையும் என்னோடு நான் அழைத்துச் செல்லலாமா?” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","ஆபிரகாம் அவனிடம், “இல்லை என் மகனை அந்த இடத்திற்கு உன்னோடு அழைத்துச் செல்லக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","வானத்திற்கு தேவனாகிய கர்த்தர் என்னை என் தாய் நாட்டிலிருந்து இங்கு அழைத்து வந்துள்ளார். அது என் தந்தைக்கும் என் குடும்பத்திற்கும் தாய்நாடு. ஆனால் கர்த்தர் இந்தப் புதிய நாடே எனது குடும்பத்தின் தாய்நாடு என்று வாக்குறுதிச் செய்திருக்கிறார். எனவே கர்த்தர் தன் தூதனை உனக்கு முன் அனுப்புவாராக. பெண்ணைத் தேர்ந்தெடுக்க உனக்கு உதவுவார். ");
INSERT INTO tam2008_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","ஆனால் அந்தப் பெண் உன்னோடு இங்கு வர சம்மதிக்காவிட்டால் உனது வாக்குறுதியிலிருந்து நீ விடுதலை பெறுகிறாய். ஆனால் என் மகனை மட்டும் அங்கு அழைத்துக்கொண்டு போகக் கூடாது” என்று கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","அதன்படி, அந்த வேலைக்காரன் தன் எஜமானனின் காலடியில் தன் கையை வைத்து வாக்குறுதி செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ஆபிரகாமின் வேலைக்காரன் பத்து ஒட்டகங்களோடு அங்கிருந்து புறப்பட்டான். அவன் தன்னோடு பலவித அழகான பரிசுப்பொருட்களையும் எடுத்து சென்றான். அவன் நாகோரின் நகரமான மெசொப் பொத்தாமியாவிற்குச் சென்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","அவன் ஊருக்கு வெளியே இருந்த கிணற்றினருகே வந்தடைந்தான். அது பெண்கள் தண்ணீர் எடுக்க வரும் மாலை நேரம். அங்கே ஒட்டகங்களைத் தங்கச் செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","அவன், “என் எஜமானனின் தேவனாகிய கர்த்தாவே இன்று அவரது மகனுக்குப் பெண் தேட உதவி செய்யும். என் எஜமானரான ஆபிரகாம் மீது கருணை காட்டும். ");
INSERT INTO tam2008_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","நான் இந்தக் கிணற்றருகில் நின்றுகொண்டிருக்கிறேன். நகருக்குள் இருந்து ஏராளமான இளம் பெண்கள் தண்ணீரெடுக்க வருகின்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ஈசாக்குக்குச் சரியான பெண் யாரென்று அறிந்துகொள்ள நான் ஒரு சிறப்பான அடையாளத்துக்காகக் காத்திருக்கிறேன். அதாவது, நான் ஒரு பெண்ணிடம், ‘குடிக்க உன் குடத்தைச் சாய்க்க வேண்டும்’ என்று சொல்லும்போது எந்தப் பெண், ‘குடி உன் ஒட்டகங்களுக்கும் தண்ணீர் தருவேன்’ என்று கூறுகிறாளோ அவளையே ஈசாக்கின் மனைவியாகத் தேர்ந்தெடுக்க வேண்டும். அப்படி நடந்தால், அவளே நீர் ஈசாக்கிற்காக தேர்ந்தெடுத்த சரியான பெண் என்றும் அதன்பின் நீர் என் எஜமானன் மீது கருணை காட்டினீர் என்றும் நம்புவேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","அந்த வேலைக்காரன் இவ்வாறு பிரார்த்தனை செய்து முடிப்பதற்குள் ஒரு இளம் பெண் தண்ணீரெடுக்க கிணற்றருகே வந்தாள். இவள் பெத்துவேலின் மகளாகிய ரெபெக்காள். பெத்துவேல் நாகோருக்கும் மில்காளுக்கும் பிறந்த மகன். நாகோர் ஆபிரகாமின் சகோதரன். அவள் தோளில் குடத்தை வைத்துக்கொண்டு தண்ணீரெடுக்க வந்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","அவள் மிகவும் அழகுள்ளவளும், புருஷனை அறியாத கன்னிகையுமாயிருந்தாள். அவள் கிணற்றருகே சென்று தண்ணீரெடுத்து தன் குடத்தை நிறைத்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","வேலைக்காரன் அவளிடம் போய், “நான் குடிக்கக் கொஞ்சம் தண்ணீரை உன் குடத்திலிருந்து தா” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","உடனே ரெபெக்காள் தோளிலிருந்து குடத்தை இறக்கி, “இதைக் குடியுங்கள் ஐயா” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","அவன் குடித்து முடித்ததும் அவள், “உங்கள் ஒட்டகங்கள் குடிக்கவும் நான் தண்ணீர் ஊற்றுவேன்” என்று சொல்லி, ");
INSERT INTO tam2008_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","குடத்திலுள்ள தண்ணீர் முழுவதையும் ஒட்டகம் குடிக்குமாறு ஊற்றினாள். பிறகு கிணற்றுக்குப் போய் மேலும் தண்ணீரெடுத்து வந்து எல்லா ஒட்டகங்களுக்கும் ஊற்றினாள். ");
INSERT INTO tam2008_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","வேலைக்காரன் அவளை அமைதியாகக் கவனித்துக்கொண்டிருந்தான். கர்த்தர் அவனுக்கு ஒரு பதிலளித்தார் என்பதையும் அவனது பயணத்தை வெற்றிகரமானதாக்கினார் என்பதையும் உறுதிப்படுத்த விரும்பினான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ஒட்டகங்கள் தண்ணீர் குடித்த பின் வேலைக்காரன் அவளுக்கு அரைச் சேக்கல் எடையுள்ள தங்கக் காதணியும், பத்து சேக்கல் எடையுள்ள இரண்டு பொன் கடகங்களையும் கொடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","அவன் அவளிடம், “உனது தந்தை யார்? உன் தந்தையின் வீட்டில் நாங்கள் இரவில் தங்க இடம் உண்டா” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","அதற்கு ரெபக்காள், “என் தந்தை பெத்துவேல். அவர் நாகோர் மில்க்காள் ஆகியோரின் மகன்” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","பிறகு அவள், “எங்கள் வீட்டில், உங்கள் ஒட்டகங்களுக்கு உணவும், உங்களுக்குப் படுக்க இடமும் உண்டு” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","வேலைக்காரன் பணிந்து கர்த்தரைத் தொழுதுகொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","அவன், “எனது எஜமான் ஆபிரகாமின் தேவனாகிய கர்த்தர் ஸ்தோத்தரிக்கப்படுவாராக. அவருக்குக் கர்த்தர் கருணை காட்டி தமது உண்மையை நிரூபித்துள்ளார். என் எஜமானனின் மகனுக்கு ஏற்ற பெண்ணிடம் கர்த்தர் என்னை வழி நடத்திவிட்டார்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","பிறகு ரெபெக்காள் ஓடிப்போய் தன் குடும்பத்தாரிடம் நடந்ததை எல்லாம் சொன்னாள். ");
INSERT INTO tam2008_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","அவளுக்கு ஒரு சகோதரன் இருந்தான். அவன் பெயர் லாபான். அவள் சொன்னதையெல்லாம் அவன் கேட்டான். அவன் அவளது காதணிகளையும் கடகங்களையும் பார்த்துவிட்டு கிணற்றருகே ஓடினான். அங்கு கிணற்றருகில் ஒட்டகங்களையும், வேலையாளையும் கண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","அவனிடம், “ஐயா, கர்த்தரால் ஆசீர்வதிக்கப்பட்டவரே உங்களை எங்கள் வீட்டிற்கு வரவேற்கிறோம். இங்கே வெளியே நீங்கள் நின்றுகொண்டிருக்க வேண்டாம். நீங்கள் இளைப்பாற ஒரு அறையை ஏற்பாடு செய்துள்ளேன். உங்கள் ஒட்டகங்கள் தங்கவும் ஏற்பாடு செய்துள்ளேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ஆபிரகாமின் வேலைக்காரன் அந்த வீட்டிற்குப் போனான். லாபான் அவனுக்கு உதவினான். ஒட்டகங்களுக்கு உணவு கொடுத்தான். பிறகு ஆபிரகாமின் வேலைக்காரனும் அவனது ஆட்களும் கால்களைக் கழுவிக்கொள்ளத் தண்ணீர் கொடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","பிறகு அவனுக்கு உண்ண உணவு கொடுத்தான். ஆனால் வேலையாள் உண்ண மறுத்துவிட்டான், “நான் ஏன் வந்திருக்கிறேன் என்பதைச் சொல்வதற்கு முன் உண்ணமாட்டேன்” என்றான். ஆகையால் லாபான், “பிறகு எங்களுக்குச் சொல்லும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","வேலையாள், “நான் ஆபிரகாமின் வேலைக்காரன். ");
INSERT INTO tam2008_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","கர்த்தர் எல்லாவகையிலும் என் எஜமானனை சிறப்பாக ஆசீர்வதித்திருக்கிறார். என் எஜமானன் பெரிய மனிதராகிவிட்டார். அவருக்கு ஆட்டு மந்தைகளையும் மாட்டு மந்தைகளையும் கர்த்தர் கொடுத்திருக்கிறார். அவரிடம் தங்கமும் வெள்ளியும் உள்ளன. நிறைய வேலைக்காரர்களும் உள்ளனர். ஒட்டகங்களும் கழுதைகளும் இருக்கின்றன. ");
INSERT INTO tam2008_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","சாராள் என் எஜமானனின் மனைவி. அவள் தனது முதிய வயதில் ஆண் குழந்தையை பெற்றாள். எனது எஜமானன் தனக்குரிய அனைத்தையும் அவனுக்கே கொடுத்திருக்கிறார். ");
INSERT INTO tam2008_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","என் எஜமானன் என்னை ஒரு வாக்குறுதி செய்யுமாறு வற்புறுத்தினார். என் எஜமானன் என்னிடம், ‘என் மகன் கானான் நாட்டுப் பெண்ணை மணந்துகொள்ள நீ அனுமதிக்கக் கூடாது. நாம் கானானியர்களுக்கிடையில் வாழ்கிறோம். ஆனால் இங்குள்ள பெண்ணை என் மகன் மணந்துகொள்ளக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","அதனால் எனது தந்தையின் நாட்டிலுள்ள எனது குடும்பத்தாரிடம் போய் என் மகனுக்குப் பெண்ணைத் தேர்ந்தெடுக்கவேண்டும்’ என்று சொன்னார். ");
INSERT INTO tam2008_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","அதற்கு நான், என் எஜமானிடம் ‘ஒருவேளை அந்தப் பெண் என்னோடு இங்கு வர மறுப்பாள்’ என்றேன். ");
INSERT INTO tam2008_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","உடனே அவர், ‘நான் கர்த்தருக்குச் சேவை செய்கிறேன். எனவே கர்த்தர் தன் தூதனை உனக்கு முன்பாக அனுப்பி உனக்கு உதவுவார். அங்கே எனது குடும்பத்தில் என் மகனுக்கேற்ற பெண்ணைக் கண்டுபிடிப்பாய்’ என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","ஆனால் அவர்கள் என் மகனுக்குப் பெண் கொடுக்க மறுத்தால் பிறகு நீ செய்த வாக்குறுதியிலிருந்து விடுதலை பெறுவாய்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“இன்று அந்தக் கிணற்றருகில் வந்து ‘என் எஜமானன் ஆபிரகாமின் தேவனாகிய கர்த்தாவே! எனது பயணத்தை வெற்றிகரமாக்கும். ");
INSERT INTO tam2008_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","நான் இந்தக் கிணற்றருகில் ஒரு இளம் பெண்ணுக்காகக் காத்திருப்பேன். அவளிடம் குடிக்க தண்ணீர் கேட்பேன். ");
INSERT INTO tam2008_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","பொருத்தமான பெண் எனில் சிறப்பான முறையில் சரியான பதிலைத் தருவாள். அவள், “இந்த தண்ணீரைக் குடியுங்கள். உங்கள் ஒட்டகங்களுக்கும் தண்ணீர் கொடுப்பேன்” என்பாள். அதன் மூலம் இந்தப் பெண்ணே என் எஜமானின் மகனுக்குக் கர்த்தரால் தேர்ந்தெடுக்கப்பட்டவள் என்று அறிவேன்’” என்று பிரார்த்தனை செய்தேன். ");
INSERT INTO tam2008_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“நான் வேண்டுதல்களை முடிக்கும் முன்னரே ரெபெக்காள் தண்ணீர் எடுப்பதற்காக கிணற்றுக்கு வந்தாள். அவள் தோளில் குடத்தோடு வந்து தண்ணீரை நிரப்பினாள். நான் அவளிடம் குடிக்க தண்ணீர் கேட்டேன். ");
INSERT INTO tam2008_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","அவள் உடனே வேகமாகக் குடத்தை இறக்கி எனக்கு தண்ணீர் ஊற்றினதுடன், ‘இந்த தண்ணீரைக் குடியுங்கள். நான் உங்கள் ஒட்டகங்களுக்கும் தண்ணீர் கொண்டு வருகிறேன்’ என்றாள். எனவே நான் தண்ணீரைக் குடித்தேன். பிறகு அவள் என் ஒட்டகங்களுக்கும் தண்ணீர் கொடுத்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","பிறகு நான் ‘உனது தந்தை யார்?’ என்று கேட்டேன். அதற்கு அவள், ‘என் தந்தை பெத்துவேல், அவர் நாகோருக்கும் மில்க்காளுக்கும் மகன்’ என்றாள். பிறகு அவளுக்கு நான் காதணிகளும் கடகங்களும் கொடுத்தேன். ");
INSERT INTO tam2008_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","பின்னர் நான் குனிந்து கர்த்தருக்கு நன்றி சொன்னேன். என் எஜமானனாகிய ஆபிரகாமின் தேவனாகிய கர்த்தரைப் புகழ்ந்தேன். என்னைச் சரியான வழியில் நடத்தியதற்காக நான் நன்றி சொன்னேன். என் எஜமானனின் சகோதரரது பேத்தியையே தேவன் காட்டிவிட்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","இப்போது சொல்லுங்கள். என் எஜமானன் மீது நீங்கள் கருணையும் நேசமும் வைத்து உங்கள் பெண்ணைக் கொடுப்பீர்களா? அல்லது உங்கள் பெண்ணைக் கொடுக்க மறுப்பீர்களா? சொல்லுங்கள். பின்னரே நான் செய்ய வேண்டியதை முடிவு செய்ய வேண்டும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","லாபானும் பெத்துவேலும், “இது கர்த்தரிடமிருந்து வந்த காரியம் என உணர்கிறோம். ஆகையால் சொல்வதற்கு ஏதுமில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","இதோ ரெபெக்காள் இருக்கிறாள். அவளை அழைத்துக் கொண்டுபோம். அவள் உமது எஜமானனின் மகனை மணந்துகொள்ளட்டும். இதுவே கர்த்தரின் விருப்பம்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ஆபிரகாமின் வேலையாள் இதனைக் கேட்டு தரையில் விழுந்து கர்த்தரை வணங்கினான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","பின்னர் தான் கொண்டு வந்திருந்த பரிசுப் பொருட்களையெல்லாம் ரெபெக்காளுக்குக் கொடுத்தான். அவன் அழகான ஆடைகளையும், பொன்னாலும் வெள்ளியாலும் ஆன நகைகளையும் கொடுத்தான். அவன் ரெபெக்காளின் தாய், சகோதரன் போன்றவர்களுக்கும் விலையுயர்ந்த பரிசுகளைக் கொடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","பிறகு அவனும் அவனோடு வந்தவர்களும் அங்கே உண்டு இரவில் உறங்கினர். மறுநாள் அதிகாலையில் அவர்கள் எழுந்து, “இப்போது நான் என் எஜமானனிடம் போக வேண்டும்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","ரெபக்காளின் தாயும் சகோதரனும், “இவள் இன்னும் பத்து நாட்கள் எங்களோடு இருக்கட்டும். பிறகு அவளை அழைத்துப் போகலாம்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","ஆனால் வேலையாளோ, “என்னைக் காத்திருக்கும்படி செய்யாதீர்கள். கர்த்தர் என் பயணத்தை வெற்றிகரமாக்கியுள்ளார். இப்போது என் எஜமானனிடம் போகவிடுங்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","“ரெபெக்காளின் தாயும் சகோதரனும், நாங்கள் ரெபெக்காளை அழைத்து அவளது விருப்பத்தை அறியவேண்டும்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","அவர்கள் அவளை அழைத்து, “இப்போது இவரோடு போக விரும்புகிறாயா?” என்று கேட்டனர், “ஆம், நான் போகிறேன்” என்று அவள் சொன்னாள். ");
INSERT INTO tam2008_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","எனவே, அவர்கள் அவளை வேலையாளோடும் ஆட்களோடும் அனுப்ப அனுமதி கொடுத்தனர். ரெபெக்காளின் தாதியும் அவளோடு போனாள். ");
INSERT INTO tam2008_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","அவள் அவர்களை விட்டுப் போகும்போது அவளை ஆசீர்வதித்து: “எங்கள் சகோதரியே லட்சக்கணக்கான ஜனங்களுக்கு நீ தாயாவாய். உனது சந்ததியார் தங்கள் பகைவரை வெல்லுவார்கள். நகரங்களைக் கைப்பற்றுவார்கள்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","பின் ரெபெக்காளும் அவளது தாதியும் ஒட்டகத்தின் மீது ஏறி அமர்ந்து வேலையாளைப் பின் தொடர்ந்து போனார்கள். அவன் அவர்களை அழைத்துக் கொண்டு போனான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ஈசாக்கு, பெயர்லகாய்ரோயியை விட்டு பாலைவனப் பகுதியில் வசித்துக்கொண்டிருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ஒரு நாள் மாலை தியானம் செய்ய அவன் வயலுக்குச் சென்றான். அப்போது வெகு தூரத்திலிருந்து ஒட்டகங்கள் வருவதைப் பார்த்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","ரெபெக்காளும் ஈசாக்கைப் பார்த்தாள். பின் அவள் ஒட்டகத்திலிருந்து இறங்கினாள். ");
INSERT INTO tam2008_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","அவள் வேலைக்காரனிடம், “வயலில் நம்மை சந்திக்க வருகிறாரே அந்த இளைஞன் யார்?” என்று கேட்டாள். அதற்கு அவன், “அவர்தான் என் எஜமானனின் மகன்” என்று பதில் சொன்னான். அவள் தன் முகத்தைத் துணியால் மறைத்துக்கொண்டாள். ");
INSERT INTO tam2008_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ஈசாக்கிடம் வேலைக்காரன் நடந்ததை எல்லாம் விபரமாகச் சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","பின் ஈசாக்கு அவளை அழைத்துக்கொண்டு அவனது தாயான சாராளின் கூடாரத்திற்குப் போனான். அன்று அவள் அவனது மனைவியானாள். ஈசாக்கு ரெபெக்காளைப் பெரிதும் நேசித்தான். அவன் தாயின் மரணத்தினால் அடைந்த துக்கம் குறைந்து அமைதியும் ஆறுதலும் பெற்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","ஆபிரகாம் மீண்டும் திருமணம் செய்தான். அவனது மனைவியின் பெயர் கேத்தூராள். ");
INSERT INTO tam2008_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","கேத்தூராள் சிம்ரான், யக்ஷான், மேதான், மீதியான், இஸ்பாக், சூவாக் போன்றவர்களைப் பெற்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","யக்ஷான் சேபாவையும், தேதானையும் பெற்றான். தேதானுடைய சந்ததி அசூரீம், லெத்தூசீம், லெயூமீம், என்பவர்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","மீதியானுக்கு ஏப்பா, ஏப்பேர், ஆனோக்கு, அபீதா, எல்தாகா என்ற மகன்கள் பிறந்தனர். இவர்கள் அனைவரும் கேத்தூராளின் பிள்ளைகள். ");
INSERT INTO tam2008_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","ஆபிரகாம் மரிப்பதற்குமுன், அவன் தன் வேலைக்காரப் பெண்களின் பிள்ளைகளுக்குப் பரிசுகளைக் கொடுத்து கிழக்கு நாடுகளுக்கு ஈசாக்கை விட்டு அப்பால் அவர்களை அனுப்பி வைத்தான். பின் ஆபிரகாம் தனக்குரிய எல்லாவற்றையும் ஈசாக்குக்கு உரிமையாக்கினான். ");
INSERT INTO tam2008_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","ஆபிரகாமுக்கு 175 வயது ஆனது. ");
INSERT INTO tam2008_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","அதனால் அவன் மெலிந்து பலவீனமாகி மரணமடைந்தான். அவன் ஒரு நீண்ட திருப்தியான வாழ்க்கை வாழ்ந்தான். அவன் தனது பிதாக்களோடு சேர்த்துக்கொள்ளப்பட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","அவனது மகன்களான ஈசாக்கும் இஸ்மவேலும் அவனை மக்பேலா குகையிலே அடக்கம் செய்தனர். அந்தக் குகை எப்பெரோனின் வயலில் இருந்தது. எப்பெரோன் சோகாரின் மகன். அந்த இடம் மம்ரேக்குக் கிழக்கே இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","இந்தக் குகையைத்தான் ஆபிரகாம் ஏத்தின் ஜனங்களிடமிருந்து விலைக்கு வாங்கியிருந்தான். சாராளோடு சேர்த்து ஆபிரகாமை அடக்கம் செய்துவிட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ஆபிரகாம் மரித்துப் போனபின் தேவன் ஈசாக்கை ஆசீர்வதித்தார். ஈசாக்கு தொடர்ந்து பெயர்லகாய்ரோயியில் வாழ்ந்து வந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","பின்வருவது இஸ்மவேலின் குடும்பப் பட்டியல்: இஸ்மவேல் ஆபிரகாமுக்கும் ஆகாருக்கும் பிறந்தவன். (ஆகார் சாராளின் எகிப்தியப் பணிப்பெண்.) ");
INSERT INTO tam2008_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","இஸ்மவேலின் பிள்ளைகளது பெயராவன: மூத்தமகன் பெயர் நெபாயோத், பின் கேதார், தொடர்ந்து அத்பியேல், மிப்சாம். ");
INSERT INTO tam2008_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","மிஷ்மா, தூமா, மாசா, ");
INSERT INTO tam2008_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ஆதார், தேமா, யெத்தூர், நாபீஸ், கேத்மா என்பவர்கள் பிறந்தார்கள். இவை அனைத்தும் இஸ்மவேலின் ஜனங்களின் பெயர்கள் ஆகும். ");
INSERT INTO tam2008_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ஒவ்வொரு மகனும் தங்கள் குடியிருப்புகளை நகரங்களாக்கிக்கொண்டனர். பன்னிரண்டு பிள்ளைகளும் தம் ஜனங்களுடன் பன்னிரண்டு அரசகுமாரர்களைப்போல வாழ்ந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","இஸ்மவேல் 137 ஆண்டுகள் வாழ்ந்தான். பின் அவன் மரித்து தன் முற்பிதாக்களோடு சேர்த்துக்கொள்ளப்பட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","இஸ்மவேலின் சந்ததிகள் பாலைவனப் பகுதி முழுவதும் பரவி குடியேறினார்கள். அப்பகுதி ஆவிலா முதல் சூர் வரை இருந்தது. சூர் எகிப்துக்கு அருகில் இருந்தது. அங்கிருந்து அசிரியா வரை பரவிற்று. இஸ்மவேலின் சந்ததிகள் அவ்வப்போது அவனுடைய சகோதரர்களின் ஜனங்களைத் தாக்கினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","இது ஈசாக்கின் குடும்ப வரலாறு: ஈசாக்கு ஆபிரகாமின் மகன். ");
INSERT INTO tam2008_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ஈசாக்கிற்கு 40 வயதானபோது அவன் ரெபெக்காளை மணந்துகொண்டான். ரெபெக்காள் பதான் அராம் என்னும் ஊரைச் சேர்ந்த பெத்துவேலின் மகள். லாபானுக்குச் சகோதரி. ");
INSERT INTO tam2008_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ஈசாக்கின் மனைவிக்குப் பிள்ளைப்பேறு இல்லாமல் இருந்தது. எனவே, அவன் தன் மனைவிக்காகக் கர்த்தரிடம் ஜெபித்தான். ஈசாக்கின் ஜெபத்தைக் கேட்டு, கர்த்தர் ரெபெக்காள் கர்ப்பமடையச் செய்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","அவள் கர்ப்பமாக இருந்தபோது, கருவிலுள்ள குழந்தைகள் மோதிக்கொண்டதால் மிகவும் கஷ்டப்பட்டாள். அவள் கர்த்தரிடம் ஜெபித்து, “ஏன் எனக்கு இவ்வாறு ஏற்படுகிறது?” என்று கேட்டாள். ");
INSERT INTO tam2008_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","அதற்கு கர்த்தர், “உனது கர்ப்பத்தில் இரண்டு நாடுகள் உள்ளன. இரண்டு குடும்பங்களின் அரசர்கள் உனக்குப் பிறப்பார்கள். அவர்கள் பிரிக்கப்பட்டு ஒருவனைவிட இன்னொருவன் பலவானாக இருப்பான். மூத்தவன் இளையவனுக்குச் சேவை செய்வான்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","சரியான நேரம் வந்தபோது ரெபெக்காள் இரட்டைக் குழந்தைகளைப் பெற்றெடுத்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","முதல் குழந்தை சிவப்பாக இருந்தது. அவனது உடல் ரோம அங்கி போர்த்தது போல இருந்தது. எனவே அவன் ஏசா என்று பெயர் பெற்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","இரண்டாவது குழந்தை பிறந்தபோது, அவன் ஏசாவின் குதிங்காலைப் பிடித்துக்கொண்டே வெளியே வந்தான். எனவே அவனுக்கு யாக்கோபு என்று பெயரிட்டனர். யாக்கோபும் ஏசாவும் பிறக்கும்போது ஈசாக்குக்கு 60 வயது. ");
INSERT INTO tam2008_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","பிள்ளைகள் வளர்ந்தார்கள். ஏசா திறமை மிக்க வேட்டைக்காரன் ஆனான். அவன் எப்போதும் வெளியே அலைவதிலேயே விருப்பப்பட்டான். ஆனால் யாக்கோபு அமைதியானவன், தன் கூடாரத்திலேயே தங்கியிருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ஈசாக்கு ஏசாவை நேசித்தான். ஏசா வேட்டையாடிய மிருகங்களை உண்ண ஈசாக்கு விரும்பினான். ஆனால் ரெபெக்காள் யாக்கோபை நேசித்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ஒருமுறை ஏசா வேட்டை முடித்து திரும்பிக்கொண்டிருந்தான். அவன் சோர்வாகவும் பலவீனமாகவும் இருந்தான். யாக்கோபு ஒரு பாத்திரத்தில் கூழ் சமைத்துக்கொண்டிருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","எனவே ஏசா யாக்கோபிடம், “நான் பலவீனமாகவும் பசியாகவும் இருக்கிறேன். எனக்குக் கொஞ்சம் கூழ் கொடு” என்று கேட்டான் (இதனாலே அவனுக்கு ஏதோம் என்றும் பெயராயிற்று.) ");
INSERT INTO tam2008_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","ஆனால் யாக்கோபோ, அதற்குப் பதிலாக: “முதல் மகன் என்ற உரிமையை இன்று எனக்கு விற்றுவிட வேண்டும்” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","ஏசாவோ, “நான் பசியால் மரித்துக்கொண்டிருக்கிறேன். நான் மரித்துப் போனால் என் தந்தையின் சொத்துக்கள் எல்லாம் எனக்கு உதவுவதில்லை. எனவே நான் எனது பங்கை உனக்குத் தருகிறேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","ஆனால் யாக்கோபு, “முதலில் உன் பங்கைத் தருவதாகச் சத்தியம் செய்” என்றான். ஆகையால் ஏசாவும் சத்தியம் செய்தான். அவன் மூதாதையர் சொத்தாக தனக்குக் கிடைக்கவிருந்த பங்கை யாக்கோபுக்கு விற்றுவிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","பிறகு யாக்கோபு ஏசாவுக்கு அப்பத்தையும் பயற்றங்கூழையும் கொடுத்தான். ஏசா அவற்றை உண்டு, விலகிப் போனான். இவ்வாறு ஏசா தனது பிறப்புரிமையைப்பற்றி கவலைப்படாமல் இருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ஒருமுறை பஞ்சம் உண்டாயிற்று. இது ஆபிரகாம் காலத்தில் ஏற்பட்டது போல் இருந்தது. எனவே ஈசாக்கு கேரார் நகருக்குப் போனான். அதனை அபிமெலேக்கு ஆண்டு வந்தான். அவன் பெலிஸ்திய ஜனங்களின் அரசன். ");
INSERT INTO tam2008_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","கர்த்தர் ஈசாக்கின் முன்பு தோன்றி, “நீ எகிப்துக்குப் போக வேண்டாம். நான் எங்கே உன்னை வசிக்கச் சொல்கிறேனோ அங்கே இரு. ");
INSERT INTO tam2008_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","நான் உன்னோடு இருப்பேன். உன்னை ஆசீர்வதிப்பேன். நான் உனக்கும் உன் வாரிசுகளுக்கும் இந்தப் பகுதியைத் தருவேன். உன் தந்தையான ஆபிரகாமுக்குச் செய்த வாக்கின்படி உனக்குத் தருவேன். ");
INSERT INTO tam2008_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","வானத்து நட்சத்திரங்ளைப் போன்று உன் குடும்பத்தைப் பெருகச் செய்வேன். இந்த நிலப்பகுதிகளையெல்லாம் உன் குடும்பத்தாருக்கே தருவேன். உன் சந்ததிகள் மூலம் உலகிலுள்ள அனைத்து நாடுகளையும் ஆசீர்வதிப்பேன். ");
INSERT INTO tam2008_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","நான் இவற்றைச் செய்வேன். ஏனென்றால் உன் தந்தை எனக்குக் கீழ்ப்படிந்து நான் சொன்னபடி நடந்தான். எனது ஆணைகள், சட்டங்கள், விதிகள் அனைத்துக்கும் ஆபிரகாம் கீழ்ப்படிந்தான்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","ஆகவே, ஈசாக்கு கேராரிலியே தங்கினான். ");
INSERT INTO tam2008_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","ஈசாக்கின் மனைவியான ரெபெக்காள் மிகவும் அழகானவள். அங்குள்ளவர்கள் அவளைப்பற்றி ஈசாக்கிடம் கேட்டனர். அதற்கு ஈசாக்கு, அவர்களிடம் ரெபெக்காள் தன் மனைவி என்று சொல்ல அஞ்சி, “அவள் என் சகோதரி” என்று சொன்னான். தன்னைக் கொன்று அவளை அபகரித்துக்கொள்வார்கள் என எண்ணினான். ");
INSERT INTO tam2008_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","ஈசாக்கு அங்கே நீண்ட காலம் வாழ்ந்தபோது, அபிமெலேக்கு ஒரு நாள் தன் ஜன்னல் வழியாக ஈசாக்கு ரெபெக்காளோடு விளையாடுவதைக் கவனித்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","அபிமெலேக்கு ஈசாக்கை அழைத்து அவனிடம், “இவள் உன் மனைவி அல்லவா, அவள் உன் சகோதரி என்று ஏன் பொய் சொன்னாய்?” என்று கேட்டான். ஈசாக்கு, “என்னைக் கொன்று இவளை அபகரித்துக்கொள்வாயோ என்று பயந்தேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","“நீ எங்களுக்குத் தீயதைச் செய்துவிட்டாய், ஒருவேளை எங்களில் ஒருவன் உன் மனைவியோடு பாலின உறவுகொண்டிருந்தால் பெரிய குற்றம் செய்த பாவத்துக்கு அவன் ஆளாகி இருக்கக் கூடும்” என்று அபிமெலேக்கு கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","ஆகையால் அபிமெலேக்கு அனைவருக்கும் எச்சரிக்கை விடுவித்தான், “இவனையோ இவன் மனைவியையோ யாரும் துன்புறுத்தக்கூடாது. அப்படிச் செய்ய முயல்வோர் கொல்லப்படுவர்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ஈசாக்கு அங்கேயே நிலங்களில் விதை விதைத்தான். அவ்வாண்டு அவனுக்கு பெரும் அறுவடை கிடைத்தது. கர்த்தர் அவனை ஆசீர்வதித்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","ஈசாக்கு செல்வந்தன் ஆனான். தொடர்ந்து அவன் பெரிய செல்வந்தனாக வளர்ந்துகொண்டிருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","அவனுக்கு நிறைய மந்தைகளும், அடிமைகளும் இருந்தனர். பெலிஸ்திய ஜனங்கள் அவன்மீது பொறாமை கொண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","ஆகவே அவர்கள் முற் காலத்தில் ஆபிரகாமும் அவனது வேலைக்காரர்களும் தோண்டிய கிணறுகள் அனைத்தையும் மண்ணால் நிரப்பி அழித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","அபிமெலேக்கு ஈசாக்கிடம், “எங்கள் நாட்டைவிட்டுப் போ. நீ எங்களைவிட பெரும் அதிகாரம் பெற்றிருக்கிறாய்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","எனவே ஈசாக்கு அந்த இடத்தை விட்டுப் போய், கேராரில் உள்ள சிறு நதியின் கரையில் குடியேறினான். ");
INSERT INTO tam2008_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","இதற்கு ரொம்ப காலத்திற்கு முன்பே ஆபிரகாம் நிறைய கிணறுகள் தோண்டியிருந்தான். ஆபிரகாம் மரித்தபின்பு, பெலிஸ்திய ஜனங்கள் அவற்றை மண்ணால் தூர்த்துவிட்டனர். அதன் பின்பு ஈசாக்கு மீண்டும் அக்கிணறுகளைத் தோண்டினான். அவற்றிற்கு தன் தந்தை இட்ட பெயர்களையே இட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ஈசாக்கின் வேலைக்காரர்களும் நதிக்கரையில் ஒரு கிணறு தோண்டினார்கள். அதிலிருந்து ஒரு பெரும் ஊற்று வந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ஆனால் அங்கு ஆடு மேய்த்துக்கொண்டிருந்தவர்கள் வேலைக்காரர்களோடு வாக்குவாதம் செய்து தண்ணீர் தங்களுடையது என உரிமை கொண்டாடினர். அதனால் ஈசாக்கு அதற்கு ஏசேக்கு என்று பெயர் வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","பிறகு ஈசாக்கின் வேலைக்காரர்கள் இன்னொரு கிணற்றைத் தோண்டினர். அங்குள்ள ஜனங்கள் அது தொடர்பாகவும் வாக்குவாதம் செய்தனர். எனவே ஈசாக்கு அதற்கு சித்னா என்று பெயரிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ஈசாக்கு அங்கிருந்து நகர்ந்து போய் வேறொரு கிணறு தோண்டினான். எவரும் அதுபற்றி வாதிட வரவில்லை. அதனால் அதற்கு ரெகொபோத் என்று பெயரிட்டான். “இப்போது கர்த்தர் நமக்கென்று ஒரு இடத்தைக் கொடுத்துவிட்டார். எனவே நாம் இங்கே செழித்து நாட்டில் பெருகுவோம்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","அங்கிருந்து ஈசாக்கு பெயர்செபாவுக்குப் போனான். ");
INSERT INTO tam2008_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","அன்று இரவு கர்த்தர் அவனோடு பேசி, “நானே உனது தந்தை ஆபிரகாமின் தேவன், அஞ்சவேண்டாம். நான் உன்னோடு இருக்கிறேன். நான் உன்னை ஆசீர்வதிப்பேன். உன் குடும்பத்தை பெரிதாக்குவேன். எனது ஊழியனான ஆபிரகாமுக்காக இதனைச் செய்வேன்” என்று சொன்னார். ");
INSERT INTO tam2008_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","எனவே, ஈசாக்கு அந்த இடத்தில் ஒரு பலிபீடத்தைக் கட்டி கர்த்தரை தொழுதுக்கொண்டு அங்கேயே குடியேறினான். அவனது வேலைக்காரர்கள் அங்கே ஒரு கிணறு தோண்டினர். ");
INSERT INTO tam2008_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","அபிமெலேக்கு கேராரிலிருந்து ஈசாக்கைப் பார்க்க வந்தான். அவன் தன்னோடு தன் அமைச்சரான அகுசாத்தையும் அழைத்துவந்தான். மீகோல் எனும் படைத் தளபதியும் கூட வந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","“என்னை ஏன் பார்க்க வந்தீர்கள்? இதற்கு முன் என்னை நீங்கள் வெறுத்தீர்கள். உங்கள் நாட்டை விட்டு துரத்தினீர்களே” என்று ஈசாக்கு கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","“கர்த்தர் உன்னோடு இருக்கிறார் என்பதை இப்போது தெரிந்துகொண்டோம். நாம் ஒரு ஒப்பந்தம் செய்துகொள்ளலாம். ");
INSERT INTO tam2008_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","நாங்கள் உன்னைத் துன்புறுத்தவில்லை. நீயும் எங்களைத் துன்புறுத்தமாட்டாய் என்று வாக்குறுதி செய். நாங்கள் உன்னைச் சமாதானத்தோடுதான் வெளியே அனுப்பினோம். கர்த்தர் உன்னை ஆசீர்வதிக்கிறார் என்பது இப்போது தெளிவாகிவிட்டது” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","அதனால் ஈசாக்கு அவர்களுக்கு விருந்து கொடுத்தான். அவர்கள் நன்றாக உண்டு, குடித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","மறுநாள் அதிகாலையில் ஒருவரோடொருவர் வாக்குறுதி செய்துகொண்டபின், அவர்கள் சமாதானத்தோடு பிரிந்து போனார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","அன்று, ஈசாக்கின் வேலைக்காரர்கள் வந்து தாங்கள் தோண்டிய கிணற்றைப்பற்றிக் கூறினர். “அதில் தண்ணீரைக் கண்டோம்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","அதனால் ஈசாக்கு அதற்கு சேபா என்று பெயரிட்டான். அந்த நகரமே பெயெர்செபா என்று இன்றும் அழைக்கப்படுகிறது. ");
INSERT INTO tam2008_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ஏசாவுக்கு 40 வயது ஆனபோது, அவன் ஏத்தியரான இரு பெண்களை மணந்துகொண்டான். ஒருத்தி பெயேரியின் மகளான யூதித், இன்னொருத்தி ஏலோனுடைய மகளான பஸ்மாத். ");
INSERT INTO tam2008_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","இவர்களால் ஈசாக்கும் ரெபெக்காளும் பாதிக்கப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ஈசாக்கு வயோதிபன் ஆனான். அவனது கண்கள் பலவீனமாகி அவனால் தெளிவாகப் பார்க்க முடியவில்லை. ஒரு நாள் தன் மூத்த மகன் ஏசாவை அழைத்து “மகனே” என்றான். ஏசா “இங்கே இருக்கிறேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ஈசாக்கு அவனை நோக்கி, “எனக்கு வயதாகிவிட்டது. விரைவில் நான் செத்துப் போகலாம். ");
INSERT INTO tam2008_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","எனவே, உன் வில்லையும் அம்பையும் எடுத்துக்கொண்டு வேட்டைக்குப் போ. நான் உண்பதற்காக ஒரு மிருகத்தைக் கொன்று வா. ");
INSERT INTO tam2008_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","நான் விரும்புகிற அந்த உணவைத் தயாரித்து வா. அதை நான் உண்ண வேண்டும். மரிப்பதற்கு முன் உன்னை ஆசீர்வதிப்பேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","எனவே ஏசா வேட்டைக்குப் போனான். ஈசாக்கு ஏசாவிடம் கூறுவதை ரெபெக்காள் கேட்டுக்கொண்டிருந்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","இதனை அவள் யாக்கோபிடம் கூறினாள். “கவனி! உன் தந்தை உன் சகோதரனிடம் கூறுவதைக் கேட்டேன். ");
INSERT INTO tam2008_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","அவர் ‘நான் உண்பதற்கு ஒரு மிருகத்தைக் கொன்று, எனக்கு உணவை சமைத்து வா, நான் உண்பேன். பிறகு நான் மரிப்பதற்கு முன் உன்னை ஆசீர்வதிப்பேன்’ என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","எனவே மகனே நான் சொல்வதைக் கவனித்து அதன்படி செய். ");
INSERT INTO tam2008_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","நீ நமது ஆட்டு மந்தைக்குப் போ இரண்டு இளம் ஆட்டுக் குட்டிகளைக் கொண்டு வா. உன் தந்தை விரும்புவதுபோல நான் சமைத்து தருவேன். ");
INSERT INTO tam2008_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","பிறகு அதனை உன் தந்தைக்குக் கொடு. அவர் உன்னைத் தான் மரிப்பதற்கு முன்னர் ஆசீர்வதிப்பார்” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","ஆனால் அவன் தாயிடம், “என் சகோதரனோ உடல் முழுவதும் முடி உள்ளவன். நான் அவ்வாறில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","என் தந்தை என்னைத் தொட்டுப் பார்த்தால் நான் ஏசா இல்லை என்பதைத் தெரிந்துகொள்வார். பின் அவர் என்னை ஆசீர்வதிக்கமாட்டார்; சபித்துவிடுவார். நான் ஏமாற்றியதை அறிந்துகொள்வாரே” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","அதனால் ரெபெக்காள் அவனிடம், “ஏதாவது தவறு ஏற்பட்டால் அதற்கான சாபம் என்மேல் விழட்டும், நீ போய் எனக்காக இரண்டு ஆட்டுக் குட்டிகளைக் கொண்டு வா” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","அதனால் யாக்கோபு வெளியே போய் இரண்டு ஆட்டுக் குட்டிகளைக் கொண்டு வந்தான். அவள் அதனை ஈசாக்கு விரும்பும் வகையில் சிறப்பான முறையில் சமைத்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","பின்னர் ரெபெக்காள் ஏசா விரும்பி அணியும் ஆடைகளை தேர்ந்தெடுத்து யாக்கோபுக்கு அணிவித்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ஆட்டுத் தோலை யாக்கோபின் கைகளிலும் கழுத்திலும் கட்டினாள். ");
INSERT INTO tam2008_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","பிறகு அவள் மகன் யாக்கோபிடம் அவள் செய்த ரொட்டியையும் சுவையான உணவையும் கொடுத்து அனுப்பி வைத்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","யாக்கோபு தன் தந்தையிடம் போய், “அப்பா” என்று அழைத்தான். அவன் தந்தையோ, “மகனே, நீ யார்?” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","யாக்கோபு தன் தந்தையிடம், “நான் ஏசா, உங்கள் மூத்த மகன். நீங்கள் சொன்னபடி செய்துள்ளேன். இப்போது உட்கார்ந்து நான் வேட்டையாடிக் கொண்டு வந்த இறைச்சியை உண்ணுங்கள். பிறகு என்னை ஆசீர்வாதம் செய்யுங்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ஆனால் ஈசாக்கு தன் மகனிடம், “இவ்வளவு வேகமாக நீ எவ்வாறு வேட்டையாடி மிருகத்தைக் கொன்றாய்?” என்று கேட்டான். இதற்கு யாக்கோபு, “உங்கள் தேவனாகிய கர்த்தர் விரைவாக வேட்டையாடி மிருகத்தைக் கொல்ல எனக்கு உதவினார்” என்று சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","பிறகு ஈசாக்கு யாக்கோபிடம், “என் அருகிலே வா. உன்னைத் தொட்டுப் பார்க்க வேண்டும். அப்போதுதான் நீ என் மகன் ஏசாவா இல்லையா என்று தெரிந்துகொள்ள முடியும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","யாக்கோபு அவனது அருகிலே போனான். ஈசாக்கு அவனைத் தொட்டுப் பார்த்துவிட்டு, “உனது சத்தம் யாக்கோபினுடையதுபோல் உள்ளது. ஆனால் உனது கைகள் ஏசாவின் கைகள் போல் முடி நிறைந்ததாய் இருக்கிறது” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ஈசாக்கினால் அவனை யாக்கோபு என்று கண்டுகொள்ள முடியவில்லை. எனவே, அவனை ஆசீர்வதித்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","எனினும் ஈசாக்கு, “உண்மையில் நீ என்னுடைய மகன் ஏசாதானா?” என்று கேட்டான். யாக்கோபு, “ஆமாம்” என்று பதில் சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","பிறகு ஈசாக்கு, “அந்த உணவைக் கொண்டு வா. அதனை உண்டு விட்டு உன்னை ஆசீர்வதிக்கிறேன்” என்றான். எனவே யாக்கோபு உணவைக் கொடுத்தான். அவனும் அதை உண்டான். பின் யாக்கோபு கொஞ்சம் திராட்சை ரசத்தைக் கொடுத்தான். அதையும் அவன் குடித்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","பிறகு ஈசாக்கு அவனிடம், “மகனே அருகில் வந்து என்னை முத்தமிடு” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","எனவே யாக்கோபு அருகிலே போய் தந்தையை முத்தமிட்டான். ஈசாக்கு அவனது ஆடையை நுகர்ந்து பார்த்து அவனை ஏசா என்றே நம்பி ஆசீர்வதித்தான். “என் மகன் கர்த்தரால் ஆசீர்வதிக்கப்பட்ட வயலைப் போன்று மணக்கிறான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","கர்த்தர் உனக்கு மிகுதியாக மழையைத் தரட்டும். அதனால் நீ பூமியின் செல்வத்தைப் பெறுவாய். ");
INSERT INTO tam2008_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","எல்லா ஜனங்களும் உனக்குச் சேவை செய்யட்டும். நாடுகள் உனக்கு அடிபணியட்டும். உன் சகோதரர்களையும் நீ ஆள்வாய். உன் தாயின் மகன்கள் உனக்கு அடிபணிந்து கீழ்ப்படிவார்கள். “உன்னைச் சபிக்கிறவர்கள் சபிக்கப்படுவார்கள். உன்னை ஆசீர்வதிப்பவர்கள் ஆசீர்வதிக்கப்படுவார்கள்” என்று கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ஈசாக்கு யாக்கோபை ஆசீர்வதித்து முடித்தான். யாக்கோபு தந்தையிடமிருந்து போன உடனேயே ஏசா வேட்டையை முடித்துவிட்டு உள்ளே வந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","தந்தைக்கென வேட்டையாடிய மிருகத்தைச் சிறப்பாக சமைத்தான். அதனை எடுத்துக்கொண்டு தந்தையிடம் போனான். “தந்தையே நான் உங்களின் மகன் எழுந்திருங்கள். உங்களுக்காக வேட்டையாடி சமைத்துக்கொண்டு வந்த உணவை உண்ணுங்கள். பிறகு என்னை ஆசீர்வதியுங்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","ஆனால் ஈசாக்கோ “நீ யார்” என்று கேட்டான். “நான்தான் உங்கள் மூத்தமகன் ஏசா” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","அதனால் ஈசாக்கு அதிர்ச்சியும் வருத்தமும் அடைந்தான். “நீ வருவதற்கு முன்னால் இறைச்சி உணவு சமைத்துக் கொடுத்துவிட்டுப் போனானே அவன் யார்? நான் அதனை உண்டு அவனை ஆசீர்வாதம் செய்தேனே. அவன் ஆசீர்வதிக்கப்பட்டவனாகவும் இருப்பான்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","ஏசா தந்தையின் வார்த்தைகளைக் கேட்டான். பிறகு கோபமும் ஆத்திரமும் அடைந்து அழுதான். தந்தையிடம் “என்னையும் ஆசீர்வாதம் செய்யுங்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","ஈசாக்கு அவனிடம், “உன் தம்பி என்னை ஏமாற்றிவிட்டான். அவன் வந்து உனது ஆசீர்வாதத்தை எடுத்துக்கொண்டு போய்விட்டான்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","“அவன் பெயரே யாக்கோபு, (தந்திரசாலி என்றும் பொருள்.) அவனுக்குப் பொருத்தமான பெயர்தான். அவன் இருமுறை என்னை ஏமாற்றி இருக்கிறான். முன்பு முதல் மகன் என்ற உரிமைப் பங்கையும் அவன் பெற்றுக்கொண்டான். இப்போதோ எனது ஆசீர்வாதங்களையும் எடுத்துக்கொண்டானே” என்று புலம்பினான். பிறகு, “எனக்கென்று ஏதாவது ஆசீர்வாதம் மீதி இருக்கிறதா” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","அதற்கு ஈசாக்கு, “இல்லை. இப்போது மிகவும் தாமதமாகிவிட்டது. நான் அவனுக்கு உன்மீது ஆளுகை செலுத்தும்படி ஆசீர்வதித்துவிட்டேன். அவனது சகோதரர்கள் அனைவரும் அவனுக்கு வேலை செய்வார்கள் என்றும் கூறிவிட்டேன். ஏராளமான உணவும் திராட்சைரசமும் பெறுவான் என்றும் ஆசீர்வதித்து விட்டேன். உனக்கென்று தர எதுவும் இல்லையே” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","ஆனால் தொடர்ந்து ஏசா தந்தையை கெஞ்சிக்கொண்டிருந்தான். “அப்பா உங்களிடம் ஒரு ஆசீர்வாதம்தான் உள்ளதா, என்னையும் ஆசீர்வதியுங்கள்” என்று அழுதான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","பிறகு ஈசாக்கு “நல்ல நிலத்தில் நீ வாழமாட்டாய். அதிக மழை இருக்காது. ");
INSERT INTO tam2008_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","நீ உன் பட்டயத்தால்தான் வாழ்வாய். உன் தம்பிக்கு நீ அடிமையாகவும் இருக்க வேண்டும். ஆனால் விடுதலைக்காகச் சண்டையிட்டு அவனது கட்டுகளை உடைத்துவிடுவாய்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","அதற்குப் பின் ஏசா யாக்கோபுக்கு எதிராக வஞ்கசம் கொண்டான். ஏனென்றால் தந்தையின் ஆசீர்வாதத்தை அவன் பெற்றுள்ளான். “என் தந்தை விரைவில் மரித்துபோவார். அதனால் நான் சோகமடைவேன். அதற்குப் பின் நான் யாக்கோபை கொன்றுவிடுவேன்” என்று தனக்குள் ஏசா கூறிக்கொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","யாக்கோபை கொல்ல வேண்டும் என்ற ஏசாவின் திட்டத்தை ரெபெக்காள் அறிந்துகொண்டாள். அவள் யாக்கோபை அழைத்து அவனிடம், “உன் சகோதரன் ஏசா உன்னைக் கொல்லத் திட்டமிடுகிறான். ");
INSERT INTO tam2008_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","எனவே நான் சொல்கிறபடி நீ செய். ஆரானில் இருக்கிற என் சகோதரன் லாபானிடம் ஓடிச் சென்று அவனோடு இரு. ");
INSERT INTO tam2008_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","உன் சகோதரனின் கோபம் தீரும்வரை அங்கேயே இரு. ");
INSERT INTO tam2008_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","கொஞ்சக் காலம் ஆனதும் உன் சகோதரன் நீ செய்ததை மறந்துவிடுவான். பிறகு உன்னை இங்கு அழைக்க ஒரு வேலைக்காரனிடம் செய்தியைச் சொல்லி அனுப்புவேன். ஒரே நாளில் எனது இரண்டு மகன்களையும் நான் இழக்க விரும்பவில்லை” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","பிறகு ரெபெக்காள் ஈசாக்கிடம், “உமது மகன் ஏசா ஏத்தியர் பெண்களை மணந்துகொண்டான். நான் அந்தப் பெண்களால் பாதிக்கப்பட்டிருக்கிறேன். ஏனெனில் அவர்கள் நம் இனத்தவர்களல்ல. யாக்கோபும் இதுபோல் மணம் செய்தால் நான் மரித்துப்போவேன்” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ஈசாக்கு யாக்கோபை அழைத்து அவனை ஆசீர்வதித்தான். அவனுக்கு ஒரு ஆணையிட்டான். “நீ ஒரு கானானியப் பெண்ணை மனைவியாக்கக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","எனவே நீ இந்த இடத்தைவிட்டுப் பதான் ஆராமுக்குப் போ. உன் தாயின் தந்தையான பெத்துவேல் வீட்டிற்குப் போ. உன் தாயின் சகோதரனான லாபான் அங்கு வாழ்கிறான். அவனது மகள்களில் ஒருத்தியை மணந்துகொள். ");
INSERT INTO tam2008_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","சர்வ வல்லமையுள்ள தேவன் உன்னை ஆசீர்வதிப்பார். உனக்கு நிறைய குழந்தைகள் பிறப்பார்கள். ஒரு பெரிய தேசத்தின் தந்தையாவாய். ");
INSERT INTO tam2008_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","தேவன் உன்னையும் உன் குழந்தைகளையும் ஆசீர்வதிப்பார். ஆபிரகாமையும் அப்படித்தான் ஆசீர்வதித்தார். நீ வாழ்கிற நாடு உனக்குச் சொந்தமாகும். தேவன் ஆபிரகாமுக்குக் கொடுத்த நாடு இது” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ஆகவே ஈசாக்கு யாக்கோபை பதான் ஆராமுக்கு அனுப்பி வைத்தான். யாக்கோபும் லாபானிடம் போனான். பெத்துவேல் லாபானுக்கும் ரெபெக்காளுக்கும் தந்தை. ரெபெக்காள் ஏசாவுக்கும் யாக்கோபுக்கும் தாய். ");
INSERT INTO tam2008_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","தன் தந்தை யாக்கோபை ஆசீர்வதித்ததையும் ஒரு மனைவியைத் தேட யாக்கோபை பதான் ஆராமுக்கு தன் தந்தை அனுப்பியதையும், கானானியப் பெண்களை மணந்துகொள்ளக் கூடாது என்று ஆணை இட்டதையும் ஏசா அறிந்துகொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","யாக்கோபு தன் தாயும், தந்தையும் சொன்னதைக் கேட்டு அதற்குக் கீழ்ப்படிந்து பதான் ஆராமுக்குப் போனதையும் அறிந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","இதனால் ஈசாக்கு தம் பிள்ளைகள் கானானியப் பெண்களை மணந்துகொள்வதை விரும்பவில்லை என்பதையும் தெரிந்துகொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","அவனுக்கு ஏற்கெனவே இரண்டு மனைவியர் இருந்தனர். ஆனாலும் அவன் இஸ்மவேலிடம் போய் அவன் மகளாகிய மகலாத்தை மணந்துக்கொண்டான். இஸ்மவேல் ஆபிரகாமின் மகன். மகலாத் நெபாயோத்தின் சகோதரி. ");
INSERT INTO tam2008_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","யாக்கோபு பெயர்செபாவை விட்டு ஆரானுக்குப் போனான். ");
INSERT INTO tam2008_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","அவன் பயணத்தின்போது சூரியன் மறைந்தது. அன்றைய இரவு தங்கும்பொருட்டு ஒரு இடத்துக்குச் சென்றான். அங்கே ஒரு கல்லை எடுத்து அதை தலைக்கு வைத்துக்கொண்டு படுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","யாக்கோபு ஒரு கனவு கண்டான். கனவில் வானத்தைத் தொடும் அளவுக்கு உயரமாய் இருந்த ஒரு ஏணியைக் கண்டான். தேவதூதர்கள் அதில் ஏறி மேலும் கீழும் வந்து போய்க்கொண்டிருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","கர்த்தர் ஏணியின் அருகில் நின்றுகொண்டிருப்பதையும் கண்டான். கர்த்தர், “நானே தேவன். உன் தாத்தாவான ஆபிரகாமுக்கும் நானே தேவன். நான் ஈசாக்குக்கும் தேவன். இப்போது நீ படுத்திருக்கிற பூமியையே உனக்குக் கொடுப்பேன். இது உனக்கும் உன் பிள்ளைகளுக்கும் உரியதாகும். ");
INSERT INTO tam2008_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","உனக்கு எண்ணிறந்த சந்ததிகள் உருவாகுவார்கள். பூமியில் உள்ள தூளைப்போன்று அவர்கள் எண்ணிக்கையில் நிறைந்திருப்பார்கள். அவர்கள் கிழக்கிலும் மேற்கிலுமாக வடக்கிலும் தெற்கிலுமாகப் பரவுவார்கள். உன்னாலும் உன் சந்ததிகளாலும் உலகிலுள்ள குடும்பங்கள் எல்லாம் ஆசீர்வதிக்கப்படும். ");
INSERT INTO tam2008_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","“நான் உன்னோடு இருக்கிறேன். நீ போகிற ஒவ்வொரு இடத்திலும் உன்னைக் காப்பாற்றுவேன். நான் மீண்டும் உன்னை இங்கே கொண்டுவருவேன். எனது வாக்குறுதியை முடிக்கும்வரை உன்னை விட்டு விலகமாட்டேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","உடனே யாக்கோபு தனது தூக்கத்திலிருந்து எழுந்தான். “கர்த்தர் இங்கேதான் இருக்கிறார் என்பதைத் தெரிந்துகொண்டேன். நான் தூங்கும்வரை இதை அறிந்துகொள்ளவில்லை” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","அவனுக்கு பயம் வந்தது, “இது மிகச் சிறந்த இடம். இது தேவனுடைய வீடு, பரலோகத்தின் வாசல்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","யாக்கோபு அதிகாலையில் எழுந்ததும் தலைக்கு வைத்துப்படுத்த கல்லை நிமிர்த்தி வைத்து, அதன்மேல் எண்ணெய் ஊற்றினான். இவ்வாறு அவன் அந்தக் கல்லை நினைவுச் சின்னமாக ஆக்கினான். ");
INSERT INTO tam2008_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","இந்த நகரத்தின் பெயர் லூஸ். ஆனால் யாக்கோபு அதற்குப் பெத்தேல் என்று பெயரிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","பின் யாக்கோபு: “தேவன் என்னோடு இருந்து, எங்கு போனாலும் என்னைத் தேவன் காப்பாற்று வாரானால், உண்ண உணவும் அணிய ஆடையும் தேவன் கொடுப்பாரானால், ");
INSERT INTO tam2008_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","என் தந்தையின் இடத்துக்குச் சமாதானத்தோடு திரும்புவேனேயானால், தேவன் இதையெல்லாம் செய்வாரானால், கர்த்தர் என் தேவனாயிருப்பார். ");
INSERT INTO tam2008_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","இந்த இடத்தில் இக்கல்லை ஞாபகார்த்தக் கல்லாக நிறுத்துவேன். தேவனுக்கான பரிசுத்த இடம் இது என்று அடையாளம் காட்டும். தேவன் எனக்குக் கொடுக்கும் அனைத்திலும் பத்தில் ஒரு பங்கை அவருக்கே கொடுப்பேன்” என்று பொருத்தனை செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","பிறகு யாக்கோபு தன் பயணத்தைத் தொடர்ந்து, கிழக்கே உள்ள நாட்டுக்குப் போனான். ");
INSERT INTO tam2008_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","யாக்கோபு வயல்வெளியில் ஒரு கிணற்றைப் பார்த்தான். அக்கிணற்றின் அருகில் மூன்று ஆட்டு மந்தைகள் மடக்கப்பட்டிருப்பதையும் பார்த்தான். அக்கிணறு தான் ஆடுகள் தண்ணீர் குடிக்கும் இடம் ஆகும். கிணற்றின் வாயானது ஒரு பெரிய கல்லால் அடைக்கப்பட்டிருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","ஆடுகள் எல்லாம் அங்கு ஒன்று சேர்ந்ததும் மேய்ப்பர்கள் கிணற்றை மூடியுள்ள பாறையை அகற்றி, ஆடுகளுக்குத் தண்ணீர் காட்டுவார்கள். ஆடுகள் வயிறு நிறைய தண்ணீர் குடித்த பிறகு மேய்ப்பர்கள் அக்கிணற்றைப் பாறையால் மூடி வைப்பார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","யாக்கோபு அந்த மேய்ப்பர்களிடம், “சகோதரர்களே, நீங்கள் எங்கிருந்து வருகிறீர்கள்?” என்று கேட்டான். மேய்ப்பர்கள், “நாங்கள் ஆரானிலிருந்து வருகிறோம்” என்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","பிறகு யாக்கோபு “உங்களுக்கு லாபானைத் தெரியுமா? அவர் நாகோரின் மகன்” என்று கேட்டான். மேய்ப்பர்கள் “எங்களுக்குத் தெரியும்” என்று பதில் சொன்னார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","“அவர் எப்படி இருக்கிறார்?” என்று கேட்டான் யாக்கோபு. அதற்கு அவர்கள் “அவர் நன்றாக இருக்கிறார். அதோ பாரும் அவரது மகள் ராகேல் ஆட்டு மந்தையோடு வந்துகொண்டிருக்கிறாள்” என்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","யாக்கோபு, “சூரியன் அஸ்தமிக்க இன்னும் பொழுது இருக்கிறதே. ஆடுகளை இன்னும் கொஞ்சம் மேய்த்து தண்ணீர் காட்டலாமே! இது ஆடுகளை அடைக்கிற நேரமில்லையே. தண்ணீர் காட்டிவிட்டு மீண்டும் அவற்றை, வயல்வெளிக்கு அனுப்புங்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","அதற்கு மேய்ப்பர்கள், “எல்லா ஆடுகளும் சேரு முன்னால் நாங்கள் அவ்வாறு செய்யக் கூடாது. சேர்ந்த பின்னரே கிணற்றின் கல்லை அகற்றுவோம் அப்போது எல்லா ஆடுகளும் தண்ணீர் குடிக்கும்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","யாக்கோபு மேய்ப்பர்களோடு பேசிக்கொண்டிருக்கும்போதே ராகேல் தன் தந்தையின் ஆடுகளோடு வந்தாள். (அவளது வேலையே ஆடு மேய்ப்பது தான்.) ");
INSERT INTO tam2008_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","ராகேல் லாபானின் மகள். லாபான் யாக்கோபின் தாயான ரெபெக்காளின் சகோதரன். அவன் ராகேலைக் கண்டதும் கிணற்றின் மேலுள்ள கல்லை நகர்த்தி ஆடுகள் தண்ணீர் குடிக்க உதவினான். ");
INSERT INTO tam2008_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","பிறகு அவன் ராகேலை முத்தமிட்டு, அழுதான். ");
INSERT INTO tam2008_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","அவன் அவளிடம், தான் அவளது தந்தையின் குடும்பத்திலிருந்து வந்திருப்பதாகச் சொன்னான். தான் ரெபெக்காளின் மகன் என்றான். ராகேல் ஓடிப் போய் தந்தையிடம் கூறினாள். ");
INSERT INTO tam2008_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","லாபான் தன் சகோதரியின் மகன் யாக்கோபைப்பற்றிக் கேள்விப்பட்டதும் அவனைச் சந்திக்க ஓடி வந்தான். அவனை அணைத்து முத்தமிட்டு வீட்டிற்கு அழைத்துச் சென்றான். யாக்கோபு நடந்தவற்றையெல்லாம் சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","அப்பொழுது லாபான் “இது ஆச்சரியமானது. நீ எனது சொந்தக் குடும்பத்தில் உள்ளவன்” என்றான். எனவே யாக்கோபு அங்கு ஒரு மாத காலம் தங்கி இருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ஒரு நாள் லாபான் யாக்கோபிடம், “நீ என்னிடம் தொடர்ந்து சம்பளமில்லாமல் வேலை செய்துகொண்டிருப்பது சரியல்ல. நீ எனது அடிமையல்ல, உறவினன். நான் உனக்கு என்ன சம்பளம் தரட்டும்?” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","லாபானுக்கு இரண்டு பெண்கள் இருந்தனர். மூத்தவள் பெயர் லேயாள் இளையவள் பெயர் ராகேல். ");
INSERT INTO tam2008_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","ராகேல் மிக அழகானவள். லேயாளின் கண்களோ கூச்சம் உடையவை. ");
INSERT INTO tam2008_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","யாக்கோபு ராகேலை நேசித்தான். எனவே அவன் லாபானிடம், “உங்கள் மகள் ராகேலை மணமுடிக்க நீங்கள் அனுமதித்தால் நான் ஏழு ஆண்டுகள் உங்களுக்காக வேலை செய்யத் தயார்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","அதற்கு லாபான், “அவள் வேறு யாரையாவது மணந்துகொள்வதைவிட உன்னை மணந்துகொள்வது அவளுக்கு நல்லது” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","அதனால் யாக்கோபு அங்கு ஏழு ஆண்டுகள் தங்கி வேலை பார்த்தான். ஆனால் அவன் ராகேலை நேசித்ததால் ஆண்டுகள் வேகமாக முடிந்துவிட்டன. ");
INSERT INTO tam2008_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ஏழு ஆண்டுகள் ஆனதும் அவன் லாபானிடம், “ராகேலை எனக்குத் தாருங்கள். நான் அவளை மணமுடிக்க வேண்டும். நான் வேலை செய்ய வேண்டிய காலமும் முடிந்துவிட்டது” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","அதனால் அந்த இடத்திலுள்ள எல்லா ஜனங்களுக்கும் லாபான் ஒரு விருந்து கொடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","அன்று இரவு அவன் தன் மூத்த மகள் லேயாளை யாக்கோபிடம் அழைத்து வந்தான். இருவரும் பாலின உறவு கொண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(லாபான் தன் வேலைக்காரியாகிய சில்பாளை லேயாளுக்கு வேலைக்காரியாக ஆக்கி இருந்தான்.) ");
INSERT INTO tam2008_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","காலையில் எழுந்ததும் யாக்கோபு இரவு முழுக்க தன்னோடு இருந்தது லேயாள் என்பதை அறிந்துகொண்டான். லாபானிடம் சென்று “என்னை ஏமாற்றிவிட்டீர்கள். நான் ராகேலை மணம் செய்துகொள்ள வேண்டும் என்பதற்காகவே ஏழு ஆண்டுகள் கடினமாக உழைத்திருக்கிறேன். ஏன் என்னை ஏமாற்றினீர்கள்?” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","லாபான், “மூத்தவள் இருக்கும்போது இளையவளுக்கு மணம் முடிக்க எங்கள் நாட்டில் அனுமதிக்கமாட்டோம். ");
INSERT INTO tam2008_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","ஆனால் திருமணச் சடங்குகளை ஒரு வாரத்திற்குத் தொடர்ந்தபின் நான் உனக்கு ராகேலையும் திருமணம் செய்துகொள்ளத் தருவேன். ஆனால் நீ இன்னும் ஏழு ஆண்டுகள் எனக்குப் பணியாற்ற வேண்டும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","எனவே யாக்கோபு அதற்கு ஒப்புக்கொண்டு ஒரு வாரத்தைக் கழித்தான். லாபான் ராகேலை அவனுக்கு மனைவியாகக் கொடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(தனது வேலைக்காரியான பில்காளை ராகேலுக்கு வேலைக் காரியாகக் கொடுத்தான்.) ");
INSERT INTO tam2008_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","யாக்கோபு ராகேலோடும் பாலின உறவு கொண்டான். அவன் லேயாளைவிட ராகேலைப் பெரிதும் நேசித்ததால் மேலும் ஏழு ஆண்டுகள் அங்கு வேலை செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","யாக்கோபு லேயாளைவிட ராகேலை அதிகமாக நேசிப்பதைக் கர்த்தர் கண்டார். எனவே லேயாள் மட்டுமே கருத்தரிக்குமாறு கர்த்தர் செய்தார். ஆனால் ராகேலோ மலடியாய் இருந்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","லேயாளுக்கு ஓர் மகன் பிறந்தான். அவள் அவனுக்கு ரூபன் என்று பெயரிட்டாள். “கர்த்தர் நான் படும் தொல்லைகளைக் கண்டார். என் கணவன் என்னை நேசிக்காமல் இருந்தார். இப்போது ஒரு வேளை அவர் என்னை நேசிக்கலாம்” என்று நினைத்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","லேயாள் மீண்டும் கர்ப்பமானாள். அவள் இன்னொரு மகனைப் பெற்றாள். அவனுக்கு சிமியோன் என்று பெயர் வைத்தாள். “நான் நேசிக்கப்படாததைக் கண்டு கர்த்தர் எனக்கு இன்னொரு மகனை கொடுத்தார்” என்று கூறினாள். ");
INSERT INTO tam2008_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","லேயாள் மீண்டும் கர்ப்பமாகி இன்னொரு ஆண் குழந்தையைப் பெற்றாள். அவனுக்கு லேவி என்று பெயரிட்டாள். “இப்பொழுது என் கணவர் என்னை நிச்சயம் நேசிப்பார். நான் அவருக்கு மூன்று மகன்களைக் கொடுத்திருக்கிறேன்” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","லேயாள் மேலும் ஒரு மகனைப் பெற்றாள். அவனுக்கு யூதா என்று பெயரிட்டாள். அவள், “நான் இப்போது கர்த்தரைத் துதிப்பேன்” என்றாள். பிறகு குழந்தை பெறுவது நின்றுவிட்டது. ");
INSERT INTO tam2008_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","ராகேல், தன்னால் யாக்கோபுக்குக் குழந்தைகளைக் கொடுக்க முடியவில்லையே என்று வருத்தப்பட்டாள். அவளுக்கு தன் சகோதரி லேயாள் மீது பொறாமை வந்தது. அவள் யாக்கோபிடம் “எனக்குக் குழந்தையைக் கொடும் அல்லது நான் மரித்துப் போவேன்” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","அவனுக்கு அவள் மீது கோபம் வந்தது. அவன், “நான் தேவன் இல்லை. நீ குழந்தை பெற முடியாததற்குத் தேவனே காரணம்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","பிறகு ராகேல் அவனிடம், “நீர் என் வேலைக்காரி பில்காளோடு பாலின உறவு கொண்டால், எனக்காக அவள் ஒரு குழந்தையைப் பெற்றுத் தருவாள். அவள் மூலம் நான் தாயாக விரும்புகிறேன்” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","பின் தனது வேலைக்காரி பில்காளை யாக்கோபிற்குக் கொடுத்தாள். அவன் அவளோடு பாலின உறவு கொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","பில்காள் கருவுற்று ஒரு ஆண் பிள்ளையைப் பெற்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","ராகேல் மகிழ்ந்து, “தேவன் என் பிரார்த்தனையைக் கேட்டு, எனக்கு ஒரு மகனை கொடுத்தார்” என்று கூறி அவனுக்குத் தாண் என்று பெயர் வைத்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","பில்காள் மீண்டும் கர்ப்பமுற்று இன்னொரு மகனைப் பெற்றாள். அவனுக்கு ராகேல் நப்தலி என்று பெயரிட்டு, ");
INSERT INTO tam2008_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","“எனது சகோதரியோடு போராட நான் கடுமையாக உழைத்திருக்கிறேன். நான் வென்றுவிட்டேன்” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","லேயாள் தனக்கு மேலும் குழந்தை இல்லாததைக் கவனித்தாள். மேலும் குழந்தை வேண்டும் என்று தன் வேலைக்காரி சில்பாளை யாக்கோபுக்குக் கொடுத்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","பிறகு சில்பாளுக்கும் ஒரு மகன் பிறந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","“நான் பாக்கியசாலி” என்று லேயாள் மகிழ்ந்தாள். பின் அவனுக்குக் காத் என்று பெயரிட்டாள். ");
INSERT INTO tam2008_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","சில்பாள் மேலும் ஒரு மகனைப் பெற்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","லேயாள் “நான் மேலும் மகிழ்ச்சி அடைகிறேன். என்னை பார்க்கும் பெண்களும் மகிழ்ச்சியுடன் அழைப்பார்கள்” என்று எண்ணினாள். எனவே அவனுக்கு ஆசேர் என்று பெயரிட்டாள். ");
INSERT INTO tam2008_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","கோதுமை அறுவடைக் காலத்தில் ரூபன் வயலுக்குப் போனான். அங்கு சில புதுவகை மலர்களைக் கண்டான். அதனைப் பறித்துக்கொண்டு தன் தாயான லேயாளிடம் வந்தான். ராகேல் இதனைப் பார்த்து, “உன் மகன் கொண்டுவந்த மலர்களில் சிலவற்றை எனக்குக் கொடு” என்று கேட்டாள். ");
INSERT INTO tam2008_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","அதற்கு லேயாள், “ஏற்கெனவே என் கணவனை எடுத்துக்கொண்டிருக்கிறாய். இப்போது என் மகன் கொண்டு வந்த மலர்களையும் எடுக்கப் பார்க்கிறாயா?” என்று மறுத்தாள். ஆனால் ராகேலோ, “நீ அந்த மலர்களைக் கொடுத்தால் இன்று இரவு நீ யாக்கோபோடு பாலின உறவுகொள்ளலாம்” என்று சொன்னாள். ");
INSERT INTO tam2008_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","யாக்கோபு அன்று இரவு வயலில் இருந்து திரும்பினான். அவனை லேயாள் போய் சந்தித்து, “இன்று இரவு நீங்கள் என்னோடு தூங்கவேண்டும். நான் அதற்காக என் மகன் கொண்டு வந்த மலர்களைக் கொடுத்திருக்கிறேன்” என்றாள். அவன் அன்று இரவு அவளோடு இருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","தேவன் லேயாளை மீண்டும் கர்ப்பவதியாக அனுமதித்தார். அவள் ஐந்தாவது மகனைப் பெற்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","லேயாள், “நான் என் கணவனுக்கு வேலைக்காரியை கொடுத்ததால் தேவன் எனக்குப் பரிசு கொடுத்திருக்கிறார்” என்று மகிழ்ந்தாள். தன் மகனுக்கு இசக்கார் என்று பெயரிட்டாள். ");
INSERT INTO tam2008_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","லேயாள் மீண்டும் கர்ப்பமாகி ஆறாவது மகனைப் பெற்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","லேயாள் “தேவன் எனக்கு அற்புதமான பரிசு கொடுத்திருக்கிறார். இப்போது யாக்கோபு என்னை நிச்சயம் ஏற்றுக்கொள்வார். நான் அவருக்கு ஆறு மகன்களைக் கொடுத்திருக்கிறேன்” என்று மகிழ்ச்சி அடைந்தாள். அவனுக்கு செபுலோன் என்று பெயர் வைத்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","பிறகு அவள் ஒரு மகளைப் பெற்றாள். அவளுக்கு தீனாள் என்று பெயர் வைத்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","பிறகு தேவன் ராகேலின் பிரார்த்தனையைக் கேட்டு, அவளும் குழந்தை பெறுவதற்கான வாய்ப்பைக் கொடுத்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","24","அவள் கர்ப்பமாகி ஒரு மகனைப் பெற்றாள். “தேவன் எனது அவமானத்தை அகற்றி ஒரு மகனைத் தந்துவிட்டார்” என்று மகிழ்ச்சியடைந்தாள். அவள் தன் மகனுக்கு யோசேப்பு என்று பெயர் வைத்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","யோசேப்பு பிறந்த பிறகு யாக்கோபு லாபானிடம், “இப்போது என்னை என் சொந்த நாட்டிற்குப் போக அனுமதிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","எனக்கு எனது மனைவிகளையும் குழந்தைகளையும் தாருங்கள். நான் 14 ஆண்டுகளாக அவர்களுக்காக உழைத்திருக்கிறேன். நான் நன்றாக உழைத்தேன் என்பதும் உங்களுக்குத் தெரியுமே” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","லாபான், “என்னையும் ஏதாவது சொல்லவிடு. உன்னால் கர்த்தர் என்னை ஆசீர்வதித்திருக்கிறார் என்பதை நான் அறிவேன். ");
INSERT INTO tam2008_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","நான் உனக்கு என்ன தரவேண்டும் என்று சொல், நான் தருவேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","“நான் உங்களுக்காக கடினமாக உழைத்ததை நீங்கள் அறிவீர்கள். நான் கவனித்ததால் உங்கள் மந்தைகள் பெருகியுள்ளன. ");
INSERT INTO tam2008_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","நான் வந்து சேர்ந்தபோது உங்களிடம் குறைவான எண்ணிக்கையிலேயே மந்தைகள் இருந்தன. இப்போது ஏராளமாக உள்ளன. எப்பொழுதும் உங்களுக்காக ஏதாவது வேலை செய்தேன். கர்த்தர் உங்களை ஆசீர்வதித்தார். இப்போது நான் எனக்காக உழைக்க வேண்டிய காலம் வந்துவிட்டது. நான் சொந்தமாக வீடு கட்டிக்கொள்ள வேண்டும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","அதற்கு லாபான், “நான் என்ன தர வேண்டும்” என்று கூறு எனக் கேட்டான். யாக்கோபு அவனிடம், “நீங்கள் எனக்கு எதுவும் கொடுக்க வேண்டாம். நான் செய்த வேலைக்கு மட்டும் சம்பளம் கொடுங்கள். இந்தக் காரியம் மட்டும் செய்யுங்கள். நான் திரும்பிப் போய் உங்கள் மந்தையைக் கவனித்துக்கொள்கிறேன். ");
INSERT INTO tam2008_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","அவற்றில் புள்ளியும் வரியும் கறுப்பும் உள்ள செம்மறியாடுகளையும், வரியும் புள்ளியுமுள்ள வெள்ளாடுகளையும் இன்று பிரித்துவிடுகிறேன். ஒவ்வொரு கறுப்பு இன ஆட்டையும் நான் எடுத்துக்கொள்கிறேன். புள்ளியும் வரியும் உடைய ஒவ்வொரு பெண் ஆட்டையும் எடுத்துக்கொள்கிறேன். இதுவே என் சம்பளமாய் இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","நான் நேர்மையானவனாக இருக்கிறேனா இல்லையா என்பதை எதிர்காலத்தில் எளிதில் கண்டுகொள்ளலாம். அப்போது நீங்கள் எனது மந்தையை வந்து காணலாம். புள்ளியும் வரியுமில்லாத ஆடுகளைக் கண்டால் அவை என்னால் திருடப்பட்டதாகக்கொள்ளலாம்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","“நான் இதற்கு ஒத்துக்கொள்கிறேன். நீ கேட்டபடியே தருகிறேன்” என்று லாபான் கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","அன்று லாபான் புள்ளி உள்ள ஆட்டுக்கடாக்களையும், ஆடுகளையும் பிரித்து மறைத்துவிட்டான். கறுப்பு ஆடுகளையும் தனியாகப் பிரித்து மறைத்தான். அவற்றைத் தன் மகன்களிடம் கொடுத்து கவனிக்கும்படி சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","அவர்கள் புள்ளி ஆடுகளையெல்லாம் மூன்று நாள் பயண தூரத்திற்குத் தனியாகக் கொண்டு போனார்கள். மிஞ்சியவற்றை யாக்கோபு கவனித்துக்கொண்டான். புள்ளியோ, வரிகளோ கொண்ட ஆடுகள் எதுவும் யாக்கோபிடம் இல்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","எனவே அவன் பச்சையாக உள்ள புன்னை, வாதுமை, அர்மோன் மரக் கொப்புகளை வெட்டி, இடையிடையே வெண்மை தோன்றும்படி பட்டையை உரித்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","அவற்றை அவன் ஆடுகள் தண்ணீர் குடிக்கும் இடங்களில் போட்டு வைத்தான். அவை தண்ணீர் குடிக்கும்போது கடாவும் ஆடும் இணைந்தன. ");
INSERT INTO tam2008_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ஆடுகள் அந்தக் கிளைகளுக்கு முன்னால் இணைந்ததினால் அவை கலப்பு நிறமுள்ளதும் புள்ளியுள்ளதும் வரியுள்ளதுமான குட்டிகளைப் போட்டன. ");
INSERT INTO tam2008_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","யாக்கோபு மந்தையில் இருந்து புள்ளிகளும் கறுப்பும் உள்ள ஆடுகளைத் தனியாகப் பிரித்தான். அவற்றை லாபானின் ஆட்டிலிருந்து தனிப்படுத்தினான். ");
INSERT INTO tam2008_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","பலமுள்ள ஆடுகள் இணையும்போது அவற்றின் கண்களில் படுமாறு மரக்கிளைகளைக் கால்வாய்க் கரையில் போட்டு வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ஆனால் பல வீனமுள்ள ஆடுகள் இணையும்போது போடமாட்டான். அதன் குட்டிகள் எல்லாம் லாபானுக்கு உரியதாயிற்று. பலமுள்ள ஆடுகளின் குட்டிகள் எல்லாம் யாக்கோபுக்கு உரியதாயிற்று. ");
INSERT INTO tam2008_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","இவ்வாறு யாக்கோபு பெரும் பணக்காரன் ஆனான். அவனிடம் பெரிய மந்தை இருந்தது. அதோடு வேலைக்காரர்களும், ஒட்டகங்களும் கழுதைகளும் சொந்தமாயின. ");
INSERT INTO tam2008_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","ஒரு நாள், லாபானின் மகன்கள் பேசிக்கொள்வதை யாக்கோபு கேட்டான். அவர்கள், “நம் தந்தைக்குரிய அனைத்தையும் யாக்கோபு எடுத்துக்கொண்டான். அதனால் பணக்காரனாகிவிட்டான். நம் தந்தையிடம் இருந்தே இச்செல்வத்தை எடுத்துக்கொண்டான்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","யாக்கோபு, முன்புபோல் லாபான் அன்போடு இல்லை என்பதையும் கவனித்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","கர்த்தர் யாக்கோபிடம், “உனது சொந்த நாடான, உன் முற்பிதாக்களின் நாட்டுக்கு திரும்பிப் போ. நான் உன்னோடு இருப்பேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","அதனால் யாக்கோபு லேயாளிடமும் ராகேலிடமும் தன்னை மந்தைகள் உள்ள வயலில் சந்திக்குமாறு கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","அங்கு அவர்களிடம், “உங்கள் தந்தை என்மீது கோபமாய் இருப்பதாகத் தெரிகிறது. முன்பு என்னிடம் மிகவும் அன்பாய் இருந்தார். இப்போது அப்படி இல்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","நான் உங்கள் தந்தைக்காக எவ்வளவு கடினமாக உழைத்திருக்கிறேன் என்று உங்கள் இருவருக்குமே தெரியும். ");
INSERT INTO tam2008_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ஆனால் உங்கள் தந்தை என்னை ஏமாற்றிவிட்டார். அவர் என் சம்பளத்தைப் பத்து முறை மாற்றிவிட்டார். எனினும் லாபானின் எல்லாத் தந்திரங்களிலிருந்தும் தேவன் என்னைக் காப்பாற்றினார். ");
INSERT INTO tam2008_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","“அவர் ஒருமுறை, ‘புள்ளியுள்ள ஆடுகளையெல்லாம் நீயே வைத்துக்கொள்’ அதுவே உனக்கு சம் பளம் என்றார். ஆனால் அப்போது எல்லா ஆடுகளும் புள்ளி உள்ளவையாக இருந்ததால் எல்லாம் எனக்கு உரியதாயிற்று. எனவே இப்போது, ‘புள்ளி உள்ள ஆடுகள் எல்லாம் எனக்கு வேண்டும்.’ கலப்பு நிறம் உள்ள ஆடுகளை நீ வைத்துக்கொள்” என்கிறார். இதன் பிறகு எல்லா ஆடுகளும் கலப்புநிறக் குட்டிகளைப் போட்டன. ");
INSERT INTO tam2008_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","ஆகையால் தேவன் உங்கள் தந்தையிடமுள்ள ஆடுகளையெல்லாம் எடுத்து எனக்குக் கொடுத்துவிட்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“ஆடுகள் எல்லாம் இணையும்போது நான் கனவு கண்டேன். அதில் இணைகிற ஆண் ஆடுகள் மட்டுமே புள்ளியும் வரியும் உடையவையாக இருக்கக் கண்டேன். ");
INSERT INTO tam2008_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","அதோடு கனவில் ‘யாக்கோபே’ என்று தேவதூதன் ஒருவர் அழைத்தார். “‘நான் இங்கே இருக்கிறேன்’ என்று பதில் சொன்னேன். ");
INSERT INTO tam2008_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","“தேவதூதன் என்னிடம் ‘பார், புள்ளிகளும்வரிகளும் உடைய கடாக்களே இணைகின்றன. இவற்றை நானே ஏற்படுத்தினேன், லாபான் உனக்கு எதிராக செய்யும் எல்லாக் காரியங்களையும் நான் பார்த்திருக்கிறேன். எல்லா புதிய ஆட்டுக் குட்டிகளையும் நீ பெறவேண்டும் என்பதற்காக இதைச் செய்துகொண்டிருக்கிறேன். ");
INSERT INTO tam2008_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","நான் பெத்தேலில் உனக்கு வெளிப்பட்ட அதே தேவன். அங்கு எனக்குப் பலிபீடம் அமைத்தாய். பலிபீடத்தின்மேல் ஒலிவ எண்ணெயை ஊற்றினாய். அங்கு ஒரு பொருத்தனையும் செய்தாய். இப்போதும் நீ உன் பிறந்த நாட்டிற்குப் போகத் தயாராக இருக்க வேண்டும், என்று சொன்னார்’” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","15","ராகேலும் லேயாளும் யாக்கோபுக்குப் பதிலளித்தார்கள், “எங்கள் தந்தை மரிக்கும் பொழுது எங்களுக்குக் கொடுக்க அவரிடம் ஏதுமில்லை. அவர் எங்களை அந்நியர்களாகவே நடத்தினார். எங்களை உங்களுக்கு விற்றுவிட்டார். எங்களுடையதாயிருக்க வேண்டிய பணம் முழுவதையும் அவர் செலவழித்துவிட்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","எனவே தேவன் எங்கள் தந்தையிடமிருந்து எடுத்த இந்தச் செல்வமெல்லாம் நமக்கும் நம் பிள்ளைகளுக்கும் உரியது. எனவே தேவன் உமக்குச் சொன்னபடி செய்யும்” என்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","எனவே, யாக்கோபு பயணத்துக்குத் தயாரானான். தன் மனைவிகளையும் பிள்ளைகளையும் ஒட்டகத்தில் ஏற்றினான். ");
INSERT INTO tam2008_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","பின் அவர்கள் அவனது தந்தை இருக்கும் கானான் தேசத்துக்குப் பயணம் செய்தனர். அவர்களுக்கு முன்னால் அவர்களது மந்தையும் கொண்டு செல்லப்பட்டது. பதான் அராமிலிருக்கும்போது அவன் வாங்கிய பொருட்களையெல்லாம் அவன் எடுத்துக்கொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","அந்த நேரத்தில் லாபான் ஆடுகளுக்கு மயிர் கத்தரிக்கப் போயிருந்தான். ராகேல் வீட்டிற்குள் போய் தந்தையினுடைய பொய்த் தெய்வங்களின் உருவங்களைத் திருடிக்கொண்டாள். ");
INSERT INTO tam2008_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","யாக்கோபு தந்திரமாக லாபானிடம் தான் போவதைப்பற்றிக் கூறாமல் புறப்பட்டுப் போய்விட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","யாக்கோபு தன் குடும்பத்தோடும் தனக்குரியவற்றோடும் வேகமாகச் சென்று ஐபிராத்து ஆற்றைக் கடந்து கீலேயாத் மலையை நோக்கிப் போனார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","மூன்று நாள் ஆனதும் லாபான் யாக்கோபு ஓடிவிட்டதை அறிந்துகொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","உடனே தன் ஆட்களைச் சேகரித்துக்கொண்டு யாக்கோபைத் துரத்திக்கொண்டு போனான். ஏழு நாட்கள் ஆனபிறகு லாபான் யாக்கோபை கீலேயாத் மலை நகரம் ஒன்றில் கண்டு பிடித்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","அன்று இரவு தேவன் லாபானின் கனவில் தோன்றி, “எச்சரிக்கையாய் இரு. யாக்கோபிடம் பேசும் ஒவ்வொரு வார்த்தையையும் எச்சரிக்கையோடு பேசு” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","மறுநாள் காலையில் லாபான் யாக்கோபைப் பிடித்தான். யாக்கோபு மலைமீது தன் கூடாரத்தைப் போட்டிருந்தான். எனவே லாபானும் அவனது ஆட்களும் கீலேயாத்தின் மலை நகரத்தில் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","லாபான் யாக்கோபிடம், “என்னை ஏன் ஏமாற்றினாய். ஏன் என் மகள்களைப் போரில் கைப்பற்றிய பெண்களைப் போன்று கவர்ந்துகொண்டு போகிறாய். ");
INSERT INTO tam2008_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","என்னிடம் சொல்லாமல் கூட ஏன் ஓடிப்போகிறாய்? என்னிடம் நீ சொல்லியிருந்தால் உனக்கு ஒரு விருந்து கொடுத்திருப்பேனே. அவ்விருந்தில் ஆடலும் பாடலும் இசையும் இருந்திருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","நான் என் மகள்களையும் பேரப்பிள்ளைகளையும் முத்தமிட்டு வழியனுப்பவும் வாய்ப்பு கொடுக்க வில்லையே. இதனை நீ முட்டாள்தனமாகச் செய்துவிட்டாய். ");
INSERT INTO tam2008_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","உன்னைத் துன்புறுத்தும் அளவுக்கு எனக்கு வல்லமை இருக்கிறது. ஆனால் நேற்று இரவு கனவில் உன் தந்தையின் தேவன் என்னிடம் வந்தார். உன்னை எந்த விதத்திலும் துன்புறுத்த வேண்டாம் என்று அவர் என்னை எச்சரித்துவிட்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","நீ உன் தந்தையின் வீட்டிற்குத் திரும்பிச் செல்ல விரும்புகிறாய் என்று அறிகிறேன். அதனால் தான் நீ விலகிப் போகிறாய். ஆனால் ஏன் என் தேவர்களைத் திருடிக்கொண்டு போகிறாய்?” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","அதற்கு யாக்கோபு, “நான் எதுவும் சொல்லாமல் வந்துவிட்டேன். ஏனென்றால் எனக்குப் பயமாக இருந்தது. ஒரு வேளை நீங்கள் உங்கள் பெண்களை என்னிடமிருந்து பிரித்துவிடலாம் என்று நினைத்தேன். ");
INSERT INTO tam2008_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ஆனால் நான் உங்கள் தேவர்களைத் திருடவில்லை. அதைத் திருடியவர்கள் யாராவது என்னோடு இருந்தால் அவரை நான் கொல்லுவேன். உங்கள் மனிதர்களே இதற்குச் சாட்சி. உங்களுக்குரிய எந்தப் பொருளும் இங்கிருக்கிறதா என்று நீர் பார்த்து, இருந்தால் எடுத்துக்கொள்ளலாம்” என்றான். (ராகேல் தன் தந்தையின் தெய்வங்களின் உருவங்களைத் திருடிக்கொண்டு வந்தது யாக்கோபுக்குத் தெரியாது.) ");
INSERT INTO tam2008_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","எனவே, லாபான் யாக்கோபின் கூடாரத்துக்குள் போய் தேடிப் பார்த்தான். பிறகு லேயாளின் கூடாரத்தில் தேடினான். இரு அடிமைப் பெண்கள் இருந்த கூடாரங்களிலும் தேடினான். ஆனால் திருட்டுப்போன தேவர்களின் சிலைகள் கிடைக்கவில்லை. பிறகு ராகேலின் கூடாரத்திற்குள் சென்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","ராகேல் அச்சிலைகளை ஒட்டகத்தின் சேணத்திற்குள் ஒளித்து வைத்து அதன் மேல் உட்கார்ந்திருந்தாள். லாபான் கூடாரம் முழுவதையும் பார்த்தான். ஆனால் அவனால் தேவர்களைக் காண முடியவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","ராகேல் தன் தந்தையிடம், “அப்பா என்னிடம் கோபப்படாதீர்கள். உங்கள் முன்னால் என்னால் நிற்க முடியவில்லை. நான் மாத விலக்காக இருக்கிறேன்” என்று கூறிவிட்டாள். கூடாரம் எங்கும் தேடிப் பார்த்தும் தன் தேவர்களின் சிலைகளை லாபானால் கண்டுபிடிக்க முடியவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","யாக்கோபுக்குக் கோபம் வந்தது. “நான் செய்த தவறு என்ன? எந்தச் சட்டத்தை உடைத்துவிட்டேன்? எதற்கு என்னைப் பின் தொடர்ந்து வந்து தடுத்து நிறுத்த வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","எனக்குரிய எல்லாவற்றையும் சோதித்துவிட்டீர். உமக்குரிய பொருள் இவற்றில் எதுவுமில்லை. இருந்தால் நம் மனிதர்கள் காணும்படி அதை இங்கே வையுங்கள். நம் இருவரில் யாரிடம் தவறு உள்ளது என்று நம் மனிதர்களே தீர்மானிக்கட்டும். ");
INSERT INTO tam2008_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","நான் உமக்காக 20 வருடங்கள் உழைத்திருக்கிறேன். அப்போது எந்தக் குட்டியும் பிறக்கும்போது மரிக்கவில்லை. எந்தக் கடாவையும் உமது மந்தையிலிருந்து எடுத்து நான் உண்டதில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","காட்டு மிருகங்களால் ஏதாவது ஆடுகள் அடிபட்டு மரித்திருக்குமானால் அதற்குரிய விலையை நானே தந்திருக்கிறேன். மரித்த ஆடுகளைக்கொண்டு வந்து உமக்கு முன் காட்டி இதற்குக் காரணம் நானில்லை என்று சொன்னதில்லை. ஆனால் நானோ பகலிலும் இரவிலும் திருடப்பட்டேன். ");
INSERT INTO tam2008_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","பகல் பொழுது என் பலத்தை எடுத்துக்கொண்டது. இரவு குளிர் என் கண்களிலிருந்து உறக்கத்தைத் திருடிக்கொண்டது. ");
INSERT INTO tam2008_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","ஒரு அடிமையைப் போன்று 20 வருடங்களாக உமக்காக உழைத்திருக்கிறேன். முதல் 14 ஆண்டுகளும் உமது மகள்களை மணந்துகொள்வதற்காக உழைத்தேன். இறுதி ஆறு ஆண்டுகளும் உமது மிருகங்களை காப்பாற்றுவதற்கு உழைத்தேன். இந்நாட்களில் எனது சம்பளத்தைப் பத்து முறை மாற்றி இருக்கிறீர். ");
INSERT INTO tam2008_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","ஆனால் என் முற்பிதாக்களின் தேவனும், ஆபிரகாமின் தேவனும் ஈசாக்கின் பயபக்திக்குரிய தேவனுமானவர் என்னோடு இருந்தார். தேவன் என்னோடு இல்லாமற் போயிருந்தால் நீர் என்னை ஒன்றும் இல்லாதவனாக ஆக்கி அனுப்பி இருப்பீர். ஆனால் என் துன்பங்களையும், எனது உழைப்பையும் கண்ட தேவன் நேற்று இரவு நான் நியாயமானவன் என்பதை நிரூபித்துவிட்டார்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","லாபான் யாக்கோபிடம், “இந்தப் பெண்கள் என் மகள்கள். இந்தக் குழந்தைகள் என்னைச் சேர்ந்தவர்கள். இந்த மிருகங்கள் எல்லாம் என்னுடையவை. நான் இங்கு காண்கிற அனைத்தும் என்னுடையவை. ஆனால் எனது மகள்களுக்கும் அவர்களின் குழந்தைகளுக்கும் என்னால் தீமை செய்ய முடியாது. ");
INSERT INTO tam2008_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","எனவே நான் உன்னோடு ஒரு ஒப்பந்தம் செய்துகொள்கிறேன். நாம் இங்கே ஒரு கற்குவியலை அமைத்து அதை நமது ஒப்பந்தத்திற்கு நினைவு சின்னமாகக் கருதுவோம்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","அதை யாக்கோபும் ஒப்புக்கொண்டு ஒரு பெரிய கல்லை ஒப்பந்தத்துக்கு அடையாளமாக நட்டு வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","மேலும் கற்களைத் தேடி எடுத்து வந்து குவியலாக்குங்கள் என தன் ஆட்களிடம் சொன்னான். பிறகு அதன் அருகில் இருந்து இருவரும் உணவு உண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","லாபான் அந்த இடத்திற்கு ஜெகர்சகதூதா என்றும், யாக்கோபு கலயெத் என்றும் பெயரிட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","லாபான் யாக்கோபிடம், “இக்கற்குவியல் நமது ஒப்பந்தத்தை நினைவுபடுத்தும்” என்றான். இதனால் தான் யாக்கோபு அந்த இடத்துக்கு கலயெத் என்று பெயரிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","பிறகு லாபான், “நாம் ஒருவரை ஒருவர் விட்டுப் பிரிந்திருந்தாலும் கர்த்தர் நம்மைக் கண்காணிக்கட்டும்” என்றான். எனவே இந்த இடம் மிஸ்பா என்றும் அழைக்கப்பட்டது. ");
INSERT INTO tam2008_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","மேலும் லாபான், “நீ என் பெண்களைத் துன்புறுத்தினால் தேவன் உன்னைத் தண்டிப்பார். நீ வேறு பெண்களை மணந்துகொண்டாலும் தேவன் உன்னைக் கவனித்துக்கொண்டிருப்பார். ");
INSERT INTO tam2008_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","நம் இருவருக்கும் இடையில் இங்கே நான் நட்ட கற்கள் உள்ளன. இந்த விசேஷ கல்லானது நம் ஒப்பந்தத்தை நினைவுப்படுத்துகிறது. ");
INSERT INTO tam2008_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","நம் இருவருக்கும் இடையிலான ஒப்பந்தத்தை என்றென்றும் ஞாபகப்படுத்தும் இந்தக் கல்லைத் தாண்டி வந்து நான் உன்னோடு போரிடமாட்டேன். நீயும் இதைக் கடந்து வந்து என்னோடு போரிடக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","ஆபிரகாமின் தேவனும் நாகோரின் தேவனும் அவர்களது முற்பிதாக்களின் தேவனுமானவர், நாம் இந்த ஒப்பந்தத்தை உடைத்தால், குற்றவாளி யாரென்று நியாயந்தீர்க்கட்டும்” என்றான். யாக்கோபின் தந்தையான ஈசாக்கு தேவனை “பயபக்திக்குரியவர்” என்று அழைத்தார். யாக்கோபு அந்தப் பெயரிலேயே வாக்குறுதி செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","பிறகு, யாக்கோபு ஒரு ஆட்டைப் பலியிட்டு மலையில் வழிபாடு செய்தான். தன் மனிதர்களை அழைத்து உணவு உண்ணுமாறு வேண்டினான். உணவு முடிந்தபின் அந்த இரவை மலையின் மேலேயே கழித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","மறு நாள் அதிகாலையில், லாபான் எழுந்து தன் மகள்களையும் பேரப் பிள்ளைகளையும் முத்தமிட்டு ஆசீர்வதித்தான். பின் தன் ஊருக்குத் திரும்பிப் போனான். ");
INSERT INTO tam2008_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","யாக்கோபும் அந்த இடத்தைவிட்டுப் புறப்பட்டான். வழியில் அவன் தேவ தூதர்களைக் கண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","அவர்களைப் பார்த்ததும், “இதுவே தேவனின் முகாம்” என்று எண்ணினான். அந்த இடத்திற்கு மக்னாயீம் என்று பேர் வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","யாக்கோபின் சகோதரனான ஏசா, சேயீர் பகுதியில் வாழ்ந்து வந்தான். அது ஏதோம் நாட்டைச் சேர்ந்தது. யாக்கோபு ஏசாவிடம் தூதுவர்களை அனுப்பினான். ");
INSERT INTO tam2008_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","யாக்கோபு அவர்களிடம், “எனது எஜமானனான ஏசாவிடம் இதைச் சொல்லுங்கள்: ‘உங்கள் வேலைக்காரனான யாக்கோபு இந்த நாள்வரை லாபானோடு வாழ்ந்தேன். ");
INSERT INTO tam2008_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","என்னிடம் நிறைய பசுக்களும், கழுதைகளும், ஆடுகளும், ஆண் வேலைக்காரர்களும், பெண் வேலைக்காரர்களும் உள்ளனர். ஐயா நீர் எங்களை ஏற்றுக்கொள்வதற்காகவே இந்த தூதுவரை அனுப்பினேன்’” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","தூதுவர்கள் யாக்கோபிடம் திரும்பி வந்து, “நாங்கள் உங்கள் சகோதரர் ஏசாவிடம் சொன்னோம். அவர் உங்களைச் சந்திக்க 400 பேரோடே வருகிறார்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","அதனால் யாக்கோபு பயந்தான். தன்னோடு இருந்தவர்களையும் மிருகங்களையும் இரு பிரிவாகப் பிரித்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","“ஏசா வந்து ஒரு பிரிவை அழித்தால் இன்னொரு பிரிவு தப்பி ஓடிப் பிழைத்துக்கொள்ளும்” என்று நினைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","“என் தந்தையாகிய ஆபிரகாமின் தேவனே! என் தந்தையாகிய ஈசாக்கின் தேவனே, கர்த்தாவே, என்னை என் சொந்த நாட்டுக்குத் திரும்பிப் போகுமாறு சொன்னீர். எனக்கு நன்மை செய்வதாகவும் சொன்னீர். ");
INSERT INTO tam2008_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","என் மீது நீர் வைத்த மிகுதியான கருணைக்கும் நன்மைகளுக்கும் நான் தகுதியுடையவனில்லை. நான் யோர்தான் ஆற்றை முதல் முறையாகக் கடந்து சென்றபோது, என்னிடம் எதுவுமில்லை. ஒரு கைத்தடி மட்டுமே இருந்தது. இப்போது என்னிடம் இரு குழுக்களாகப் பிரிக்கும் அளவிற்கு எல்லாம் உள்ளது. ");
INSERT INTO tam2008_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","இப்போது என்னை என் சகோதரனாகிய ஏசாவிடமிருந்து காப்பாற்றும். அவனைக் குறித்து நான் அஞ்சுகிறேன். அவன் வந்து அனைவரையும் கொன்றுவிடுவான். ");
INSERT INTO tam2008_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","கர்த்தாவே, ‘நான் உனக்கு நன்மை செய்வேன் என்று சொன்னீர். உனது குடும்பத்தையும் ஜனங்களையும் கடற்கரையிலுள்ள மணலைப் போன்று பெருகச் செய்வேன்’ என்று சொன்னீர்” என்று பிரார்த்தித்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","யாக்கோபு இரவு முழுவதும் அங்கே தங்கி இருந்தான். ஏசாவுக்கு அன்பளிப்பாகக் கொடுக்க சில பொருட்களைத் தயார் செய்து வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200 வெள்ளாடுகளையும், 20 கடாக்களையும் 200 செம்மறி ஆடுகளையும், ");
INSERT INTO tam2008_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","பால் கொடுக்கும் 30 ஒட்டகங்களையும் அதன் குட்டிகளையும், 40 கடாரிகளையும், 10 காளைகளையும் 20 பெண் கழுதைகளையும், 10 ஆண் கழுதைகளையும் பிரித்தெடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","வேலைக்காரனிடம் ஒவ்வொரு மந்தையையும் தனித்தனியாக ஒப்புவித்து, “எனக்கு முன்னால் போங்கள். ஒவ்வொரு மந்தைக்கும் இடைவெளி இருக்கட்டும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","யாக்கோபு அவர்களுக்குச் சில ஆணைகளையும் இட்டான். முதல் குழுவிடம், “என் சகோதரன் வந்து, ‘யாருடைய மிருகங்கள் இவை? எங்கே போகின்றன? யாருடைய வேலைக்காரர்கள் நீங்கள்’ என்று கேட்டால் நீங்கள், ");
INSERT INTO tam2008_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","‘இவை உங்கள் அடிமையான யாக்கோபின் மிருகங்கள். எஜமானே இவை உங்களுக்கான பரிசுகள், யாக்கோபும் பின்னால் வந்துகொண்டிருக்கிறார்’ என்று சொல்லுங்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","யாக்கோபு இரண்டாம் வேலைக்காரனுக்கும், மூன்றாம் வேலைக்காரனுக்கும், மற்ற வேலைக்காரர்களுக்கும் இவ்வாறே கட்டளையிட்டான். “நீங்கள் ஏசாவைச் சந்திக்கும்போது. ");
INSERT INTO tam2008_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","இவ்வாறே சொல்ல வேண்டும். ‘இவை உங்களுக்கான பரிசுகள். உங்கள் அடிமையான யாக்கோபு பின்னால் வந்துகொண்டிருக்கிறார்’, என்று சொல்லவேண்டும்” என்றான். யாக்கோபு, “இவர்களையும் பரிசுகளையும் முதலில் அனுப்பி வைத்ததால் என் சகோதரன் ஏசா இவற்றை ஏற்றுக்கொண்டு என்னை மன்னித்துவிடலாம்” என்று எண்ணினான். ");
INSERT INTO tam2008_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","எனவே, யாக்கோபு பரிசுகளை அனுப்பிவிட்டு அன்று இரவு கூடாரத்திலேயே தங்கிவிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","பின்னிரவில் எழுந்து அந்த இடத்தை விட்டுப் புறப்பட்டான். அவன் தனது இரண்டு மனைவிகளையும், இரண்டு வேலைக்காரிகளையும், பதினொரு குழந்தைகளையும் தன்னோடு அழைத்துக்கொண்டு ஆற்றைக் கடந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","முதலில் தன் குடும்பத்தை ஆற்றைக் கடக்க அனுப்பினான். பிறகு தனக்குரிய அனைத்தும் கடக்க உதவினான். ");
INSERT INTO tam2008_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","யாக்கோபு ஆற்றைக் கடந்தவர்களில் கடைசி நபர். அவன் ஆற்றைக் கடக்குமுன், தனியாக நிற்கும்போது தேவதூதனைப் போன்ற ஒருவர் வந்து அவனோடு போராடினார். சூரியன் உதயமாகும் வரைக்கும் அவர் போராடியும், ");
INSERT INTO tam2008_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","அந்த மனிதரை யாக்கோபு விடுவதாயில்லை. எனவே, அவர் யாக்கோபின் தொடையைத் தொட்டார். அப்போது யாக்கோபின் கால் சுளுக்கிக்கொண்டது. ");
INSERT INTO tam2008_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","அந்த மனிதர் யாக்கோபிடம், “என்னைப் போக விடுகிறாயா? சூரியன் உதித்துவிட்டது” என்று கேட்டார். அதற்கு யாக்கோபு, “நான் உம்மைப் போகவிடமாட்டேன். நீர் என்னை ஆசீர்வதித்தே ஆக வேண்டும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","அந்த மனிதர், “உன் பெயர் என்ன?” என்று கேட்டார். அவன், “என் பெயர் யாக்கோபு” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","பிறகு அந்த மனிதர், “உன் பெயர் இனி யாக்கோபு அல்ல. உன் பெயர் இஸ்ரவேல். நீ தேவனோடும் மனிதரோடும் போராடி மேற்கொண்டபடியால் நான் உனக்கு இந்தப் பெயரை வைக்கிறேன். உன்னைத் தோற்கடிக்க மனிதர்களால் முடியாது” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","யாக்கோபு அவரிடம், “உமது பெயரைத் தயவு செய்து சொல்லும்” என்றான். ஆனால் அவர், “என் பெயரை ஏன் கேட்கிறாய்?” என்று கேட்டார். அதே சமயத்தில் அவர் யாக்கோபை ஆசீர்வதித்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","எனவே, யாக்கோபு அந்த இடத்திற்கு பெனியேல் என்று பெயர் வைத்தான். “இந்த இடத்தில் நான் தேவனை முகமுகமாய்ப் பார்த்தேன். உயிர் தப்பிப் பிழைத்தேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","அவன் பெனியேலைக் கடந்து போகையில் சூரியன் உதயமாகிவிட்டது. அவனது தொடை சுளுக்கிக்கொண்டதால் நொண்டி நொண்டி நடந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","எனவே, இன்னும் இஸ்ரவேல் ஜனங்கள் தொடைச் சந்து தசையை உண்பதில்லை. ஏனென்றால் அது தேவன் யாக்கோபின் தொடைச் சந்து தசையைத் தொட்ட இடம் ஆகும். ");
INSERT INTO tam2008_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","யாக்கோபு, ஏசா வருவதைப் பார்த்தான். அவனோடு 400 ஆட்கள் வந்தனர். யாக்கோபு தனது குடும்பத்தை நான்கு குழுக்களாகப் பிரித்தான். லேயாளும் அவள் குழந்தைகளும் ஒரு குழு. ராகேலும் யோசேப்பும் இன்னொரு குழு. இரண்டு வேலைக்காரிகளும் அவர்களின் பிள்ளைகளும் தனித்தனியாக இரண்டு குழுக்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","யாக்கோபு முதலில் வேலைக்காரிகளையும் பிள்ளைகளையும் நிற்க வைத்தான். பின் லேயாளும் அவள் பிள்ளைகளும். கடைசியில் ராகேல் மற்றும் யோசேப்பு இருவரையும் நிற்க வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","யாக்கோபு ஏசாவிடம் முதலில் போனான். அவன் போகும்போதே ஏழுமுறை தரையில் குனிந்து வணங்கினான். ");
INSERT INTO tam2008_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","அப்போது ஏசா எதிர்கொண்டு ஓடிவந்து அவனைத் தழுவிக்கொண்டான். ஏசா யாக்கோபை கைகளால் கழுத்தில் அணைத்துக்கொண்டு முத்தமிட்டான். பின் இருவரும் அழுதனர். ");
INSERT INTO tam2008_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ஏசா ஏறிட்டுப் பார்த்து பெண்களையும் குழந்தைகளையும் கவனித்தான். “இவர்கள் அனைவரும் யார்?” எனக் கேட்டான். யாக்கோபு, “இவர்கள் தேவன் கொடுத்த என் பிள்ளைகள். தேவன் எனக்கு நன்மை செய்திருக்கிறார்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","பிறகு இரு வேலைக்காரிகளும் குழந்தைகளும் ஏசாவின் அருகில் சென்று அவன் முன் கீழே குனிந்து வணங்கினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","பிறகு லேயாளும் அவளது பிள்ளைகளும் போய் பணிந்து வணங்கினார்கள். பின்னர் ராகேலும், யோசேப்பும் ஏசாவின் அருகில் சென்று பணிந்து வணங்கினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","ஏசா அவனிடம், “நான் வரும்போது பார்க்க நேர்ந்த இந்த மனிதர்கள் எல்லாம் யார்? இந்த மிருகங்கள் எல்லாம் எதற்காக?” என்று கேட்டான். யாக்கோபு, “என்னை நீர் ஏற்றுக்கொண்ட தன் அடையாளமாக இப்பரிசுப் பொருட்களை ஏற்றுக்கொள்ள வேண்டும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","ஆனால் ஏசாவோ, “எனக்கு நீ பரிசுப் பொருட்கள் கொடுக்க வேண்டிய தேவையில்லை. என்னிடம் போதுமான அளவு இருக்கிறது” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","அதற்கு யாக்கோபு, “இல்லை. நான் கெஞ்சிக் கேட்டுக்கொள்கிறேன், என்னை நீர் உண்மையில் ஏற்றுக்கொள்வதானால் இப்பொருட்களையும் ஏற்றுக்கொள்ளும். உமது முகத்தை மீண்டும் பார்த்ததில் மிகவும் மகிழ்ச்சி அடைகிறேன். இது தேவனின் முகத்தைப் பார்ப்பதுபோல் இருக்கிறது. என்னை நீர் ஏற்றுக்கொண்டதைப் பார்த்து மிகவும் சந்தோஷப்படுகிறேன். ");
INSERT INTO tam2008_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ஆகையால் நான் கொடுக்கும் பரிசுப் பொருட்களையும் ஏற்றுக்கொள்ளுமாறு வேண்டுகிறேன். தேவன் எனக்கு நிறைய நன்மைகள் செய்திருக்கிறார். தேவைக்குமேல் என்னிடம் உள்ளது” என்றான். இவ்வாறு யாக்கோபு கெஞ்சியதால் ஏசா பரிசுப் பொருட்களை ஏற்றுக்கொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","ஏசா, “இப்போது உனது பயணத்தைத் தொடரலாம். நான் உனக்கு முன் வருவேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","ஆனால் யாக்கோபோ, “எனது குழந்தைகள் பலவீனமாய் இருக்கிறார்கள் என்பது உமக்குத் தெரியும். எனது மந்தைகளைப்பற்றியும், அவற்றின் இளம் கன்றுகளைப்பற்றியும் நான் கவனமாக இருக்க வேண்டும். நான் அவற்றை ஒரு நாளில் அதிக தூரம் நடக்க வைத்தால் எல்லா விலங்குகளும் மரித்துப்போகும். ");
INSERT INTO tam2008_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","எனவே நீங்கள் போய்க்கொண்டே இருங்கள், நான் மெதுவாகப் பின் தொடர்ந்து வருகிறேன். ஆடுமாடுகளும் மற்ற மிருகங்களும் பாதுகாப்பாக இருக்கும் வகையில் நான் மெதுவாக வருகிறேன். என் குழந்தைகள் மிகவும் சோர்ந்து போகாதபடி மெதுவாக வருகிறேன். நான் உங்களை சேயீரில் சந்திப்பேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","எனவே ஏசா, “பிறகு நான் எனது சில மனிதர்களை உனக்கு உதவியாக விட்டுவிட்டுப் போகிறேன்” என்றான். ஆனால் யாக்கோபு, “உம் அன்புக்காக நன்றி, ஆனால் அது தேவையில்லை” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","எனவே அன்று ஏசா சேயீருக்குப் பயணம் புறப்பட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","ஆனால் யாக்கோபோ சுக்கோத்திற்குப் பயணம் செய்தான். அங்கே அவன் தனக்கென்று வீடு கட்டிக்கொண்டதுடன், மிருகங்களுக்கும் தொழுவம் அமைத்துக்கொண்டான். எனவே அந்த இடம் சுக்கோத் என்று பெயர் பெற்றது. ");
INSERT INTO tam2008_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","யாக்கோபு தனது பயணத்தைச் சுகமாகபதான் அராமிலிருந்து கானான் நாட்டிலிலுள்ள சீகேம் பட்டணத்திற்கு அருகில் முடித்துவிட்டான். நகரத்திற்கு அருகிலுள்ள வயலில் தன் கூடாரத்தைப் போட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","யாக்கோபு அந்த வயலைச் சீகேமின் தந்தையான ஏமோரிடமிருந்து விலைக்கு வாங்கினான். அவன் அதற்கு 100 வெள்ளிக் காசுகள் கொடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","யாக்கோபு தேவனைத் தொழுதுகொள்ள அங்கே ஒரு பலிபீடத்தைக் கட்டினான். யாக்கோபு அந்த இடத்திற்கு “ஏல் எல்லோகே இஸ்ரவேல்” என்று பெயரிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","யாக்கோபுக்கும் லேயாளுக்கும் பிறந்த மகள் தீனாள். ஒரு நாள் அவள் அப்பகுதியிலுள்ள பெண்களைப் பார்ப்பதற்காகச் சென்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","ஏமோர் அந்தப் பகுதியில் அரசன். தனது மகனான சீகேம் தீனாளைப் பார்த்தான். அவன் அவளைக் கடத்திக் கொண்டுபோய் அவளைக் கற்பழித்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","பிறகு சீகேம் அவளை மணந்துகொள்ள விரும்பினான். ");
INSERT INTO tam2008_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","அவன் தன் தந்தையிடம் சென்று, “நான் திருமணம் செய்துகொள்ளும்பொருட்டு இந்தப் பெண்ணை ஏற்பாடு செய்யுங்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","யாக்கோபு தன் மகளுக்கு ஏற்பட்ட தீய நிலைமையை அறிந்துகொண்டான். அப்போது யாக்கோபின் மகன்கள் ஆடு மேய்ப்பதற்காக வயலுக்கு வெளியே போயிருந்தார்கள். அவர்கள் திரும்பி வரும்வரை எதுவும் செய்ய முடியவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","அப்போது சீகேமின் தந்தையாகிய ஏமோர் யாக்கோபோடு பேசுவதற்குப் போனான். ");
INSERT INTO tam2008_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","வயலில் யாக்கோபின் மகன்கள் நடந்ததைப்பற்றிக் கேள்விப்பட்டனர். இதனால் அவர்களுக்குக் கடும் கோபம் வந்தது. நடந்த காரியம் அவர்களுக்கு அவமானமாக இருந்தது. சீகேம் யாக்கோபின் மகளைக் கற்பழித்ததால் இஸ்ரவேலுக்கே அவன் இழிவை கொண்டு வந்தான். அவர்கள் உடனே வயல்களிலிருந்து திரும்பி வந்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","ஏமோர் அவர்களோடு பேசினான். “என் மகன் சீகேம் தீனாளைப் பெரிதும் விரும்புகிறான். அவளை அவன் மணந்துகொள்ளுமாறு அனுமதியுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","இந்தத் திருமணம் நமக்குள் ஒரு சிறப்பான ஒப்பந்தம் உண்டு எனக் காண்பிக்கும். பிறகு உங்கள் ஆண்கள் எங்கள் பெண்களையும் எங்கள் ஆண்கள் உங்கள் பெண்களையும் மணந்துகொள்ளட்டும். ");
INSERT INTO tam2008_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","நீங்கள் இங்கேயே எங்களோடு வாழலாம். இந்த நிலத்தை நீங்கள் எடுத்துக்கொண்டு இங்கேயே வியாபாரம் செய்யலாம்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","சீகேம் யாக்கோபோடும் தீனாளின் சகோதரர்களோடும் கூட பேசினான். “என்னை ஏற்றுக்கொள்ளுங்கள் நீங்கள் என்ன செய்யச் சொன்னாலும் நான் உங்களுக்காகச் செய்வேன். ");
INSERT INTO tam2008_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","உங்களுக்கு எந்த அன்பளிப்பு வேண்டுமானாலும் நான் கொடுப்பேன். ஆனால் தீனாளை மணக்க என்னை அனுமதிக்க வேண்டும்” என்று கெஞ்சினான். ");
INSERT INTO tam2008_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","யாக்கோபின் மகன்களோ சீகேமையும் அவனது தந்தையையும் வஞ்சிக்க விரும்பினார்கள். தங்கள் சகோதரிக்கு அவன் செய்த கேடான காரியத்தை அவர்களால் மறக்க முடியவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","அதனால், “எங்கள் சகோதரியை நீ மணந்துகொள்ள அனுமதிக்க முடியாது. ஏனென்றால் நீ இன்னும் விருத்தசேதனம் செய்துகொள்ளவில்லை. அதனால் இந்த மணம் தவறாகும். ");
INSERT INTO tam2008_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","ஆனால் நீயும் உன் நகரத்திலுள்ள அனைத்து ஆண்களும் விருத்தசேதனம் செய்துகொள்ள வேண்டும். அப்போது எங்கள் சகோதரியை மணந்துகொள்ள அனுமதிக்கிறோம். ");
INSERT INTO tam2008_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","பிறகு உங்கள் ஆண்கள் எங்கள் பெண்களையும், எங்கள் ஆண்கள் உங்கள் பெண்களையும் மணந்துகொள்ளலாம். பிறகு நாம் ஒரே ஜனங்கள் ஆகலாம். ");
INSERT INTO tam2008_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","இல்லாவிட்டால் நாங்கள் தீனாளை அழைத்துக் கொண்டு போய்விடுவோம்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","இந்த ஒப்பந்தத்தால் ஏமோரும் அவன் மகன் சீகேமும் மகிழ்ச்சி அடைந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","சீகேம் தீனாளை விரும்பியதால் தீனாளின் சகோதரர்கள் சொன்னதைச் செய்வதில் சீகேம் மிக்க மகிழ்ச்சியடைந்தான். சீகேம் அவனது குடும்பத்திலேயே மதிப்பிற்குரிய மனிதன். ");
INSERT INTO tam2008_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ஏமோரும் சீகேமும் நகரத்திற்குள்ளே ஜனங்கள் கூடும் இடத்திற்குச் சென்று, அவர்களோடு பேசினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“இஸ்ரவேல் ஜனங்கள் நம்மோடு நட்பாக இருக்க விரும்புகின்றனர். நாம் இந்தப் பூமியில் அவர்களை வாழவிடுவோம். அவர்கள் நம்மோடு சமாதானமாய் இருக்கட்டும். நம் அனைவருக்கும் போதுமான நிலம் இங்கே உள்ளது. அவர்களின் பெண்களை நாம் மணந்துகொள்ளலாம். நமது பெண்களையும் அவர்களுக்கு மணமுடித்துக் கொடுக்கலாம். ");
INSERT INTO tam2008_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","ஆனால் நாம் ஒரு காரியம் செய்ய ஒப்புக்கொள்ள வேண்டும். நமது ஆண்கள் அனைவரும் விருத்தசேதனம் செய்துகொள்ள வேண்டும். ஏனென்றால் அவர்களும் அவ்வாறே செய்திருக்கிறார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","நாம் இவ்வாறு செய்தால் நாம் அவர்களின் ஆடு மாடுகளைப் பெற்று பணக்காரர்களாகிவிடுவோம். எனவே இந்த ஒப்பந்தத்தை நாம் நிறைவேற்றுவோம். அவர்களும் நம்மோடு இங்கே தங்கட்டும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","அக்கூட்டத்தில் கலந்துகொண்ட அனைவரும் இதற்கு ஒப்புக்கொண்டனர். அப்போது ஒவ்வொரு ஆண் மகனுக்கும் விருத்தசேதனம் செய்யப்பட்டது. ");
INSERT INTO tam2008_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","மூன்று நாட்கள் ஆனதும் விருத்தசேதனம் செய்துகொண்ட ஆண்களுக்குப் புண் ஆறாமல் இருந்தது. யாக்கோபின் மகன்களில் இருவரான சிமியோனும் லேவியும், பட்டணத்திலுள்ள ஆண்களின் நிலையை அறிந்துகொண்டு, அங்கு போய் ஆண்களை எல்லாம் வெட்டிக் கொன்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","தீனாளின் சகோதரர்களாகிய சிமியோனும் லேவியும் ஏமோரையும் சீகேமையும் கொன்றனர். பிறகு தீனாளை அழைத்துக்கொண்டு சீகேமின் வீட்டை விட்டு வெளியேறினர். ");
INSERT INTO tam2008_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","யாக்கோபின் மகன்கள் நகரத்திற்குள் போய் அங்குள்ள செல்வங்களையெல்லாம் கொள்ளையிட்டனர். அவர்கள் தங்கள் சகோதரிக்கு ஏற்பட்ட அவமானத்திற்காக இன்னும் கோபம் தணியாமல் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","அவர்கள் எல்லா மிருகங்களையும் கொண்டு சென்றதுடன், கழுதைகளையும் பிறவற்றையும் வயலில் உள்ளவற்றையும் எடுத்துக்கொண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","தீனாளின் சகோதரர்கள் சீகேம் ஜனங்களின் அனைத்துப் பொருட்களையும் எடுத்துக்கொண்டதோடு அவர்களின் மனைவி மார்களையும் குழந்தைகளையும் அழைத்துக்கொண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","ஆனால் யாக்கோபு, “நீங்கள் எனக்கு மிகுதியாகத் தொல்லை கொடுக்கிறீர்கள். இந்தப் பகுதியிலுள்ள அனைவரும் என்னை வெறுப்பார்கள். அனைத்து கானானியர்களும் பெரிசியர்களும் எனக்கு எதிராகத் திரும்புவார்கள். நாம் கொஞ்சம் பேர்தான் இருக்கிறோம். இங்குள்ள ஜனங்கள் எல்லாம் கூடி நம்மோடு சண்டைக்கு வந்தால் நாம் அழிக்கப்பட்டுவிடுவோம். நமது ஜனங்கள் அனைவரும் அழிந்து போவார்கள்” என்று சிமியோனிடமும் லேவியிடமும் சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","ஆனால் அச்சகோதர்களோ, “எங்கள் சகோதரியை அவர்கள் ஒரு வேசியைப் போன்று நடத்தினார்களே. அதை நாங்கள் அனுமதிக்க முடியுமா? முடியாது. அவர்கள் எங்கள் சகோதரிக்குத் தீங்கு செய்துவிட்டனர்” என்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","தேவன் யாக்கோபிடம், “பெத்தேல் நகரத்திற்குப் போய், அங்கே வாசம் செய். தொழுதுகொள்ள எனக்கொரு பலிபீடம் கட்டு. நீ உன் சகோதரனாகிய ஏசாவிற்குப் பயந்து ஓடிப்போனபோது உனக்குக் காட்சி தந்த தேவனுக்கு அங்கே ஒரு பலிபீடத்தை அமைத்து அங்கு தேவனைத் தொழுதுகொள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","எனவே, யாக்கோபு தன் குடும்பத்தார் வேலைக்காரர்கள் அனைவரிடமும், “உங்களிடம் உள்ள மரத்தாலும் உலோகங்களாலும் செய்யப்பட்ட அந்நிய தெய்வங்களையெல்லாம் அழித்துப் போடுங்கள். உங்களைத் தூய்மைப்படுத்திக்கொண்டு, சுத்தமான ஆடைகளை அணிந்துகொள்ளுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","நாம் இந்த இடத்தைவிட்டு பெத்தேலுக்குப் போகிறோம். அங்கே எனக்குத் துன்பத்தில் உதவிய தேவனுக்கு நான் பலிபீடம் கட்டப்போகிறேன். அந்த தேவன் நான் எங்கு போனாலும் என்னோடு இருக்கிறார்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","எனவே, ஜனங்கள் தம்மிடம் இருந்த அந்நிய தெய்வங்களையும், தங்கள் காதுகளில் அணிந்திருந்த வளையங்களையும் யாக்கோபிடம் கொடுத்தார்கள். அவற்றை சீகேம் நகருக்கருகில் இருந்த ஒரு கர்வாலி மரத்தின் அடியிலே புதைத்துவிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","யாக்கோபும் அவனது மகன்களும் அவ்விடத்தை விட்டுப் புறப்பட்டுப் போனபோது, அப்பகுதியில் உள்ள ஜனங்கள் அவர்களைப் பின் தொடர்ந்து போய் அவர்களைக் கொலைசெய்ய விரும்பினார்கள். ஆனால் தேவனால் ஏற்படுத்தப்பட்ட ஒரு பயம் அவர்களுக்கு ஏற்பட்டபடியால் அவர்கள் யாக்கோபைப் பின்தொடரவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","எனவே, யாக்கோபும் அவனைச் சேர்ந்தவர்களும் கானானிலுள்ள லூசை அடைந்தனர். லூஸ் இப்போது பெத்தேல் என்று அழைக்கப்பட்டது. ");
INSERT INTO tam2008_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","யாக்கோபு அவ்விடத்தில் ஒரு பலிபீடத்தைக் கட்டினான். அதற்கு “ஏல் பெத்தேல்” என்று பெயரிட்டான். காரணம் அவன் சகோதரனுக்குப் பயந்து ஓடியபோது தேவன் அந்த இடத்தில் தான் அவனுக்கு முதலில் காட்சியளித்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","தெபோராள் எனும் ரெபெக்காளின் தாதி அங்கு மரித்துபோனாள். பெத்தேலில் கர்வாலி மரத்தின் அடியில் அவளை அடக்கம் செய்தனர். அந்த இடத்திற்கு அல்லோன் பாகூத் என்று பெயர் வைத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","பதான் அராமிலிருந்து யாக்கோபு திரும்பி வந்தபோது தேவன் மீண்டும் அவனுக்குக் காட்சியளித்தார், தேவன் யாக்கோபை ஆசீர்வதித்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","தேவன், யாக்கோபிடம், “உன் பெயர் யாக்கோபு, உன் பெயர் இனி யாக்கோபு என அழைக்கப்படாது. உன் பெயர் இஸ்ரவேல் எனப்படும்” என்று கூறி அவனுக்கு “இஸ்ரவேல்” என்று பெயரிட்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","தேவன் அவனிடம், “நான் சர்வ வல்லமையுள்ள தேவன். உனக்கு இந்த ஆசீர்வாதத்தைத் தருவேன். நீ நிறைய குழந்தைகளைப் பெற்று ஒரு நாட்டை உருவாக்குவாய். வேறு ஜாதிகளின் கூட்டமும், அரசர்களும் உன்னிடமிருந்து தோன்றுவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","நான் ஆபிரகாமுக்கும் ஈசாக்குக்கும் சிறந்த இடங்களைக் கொடுத்திருந்தேன். இப்போது அதனை உனக்குக் கொடுக்கிறேன். உனக்குப் பின்னால் வரும் உன் பிள்ளைகளுக்கும் கொடுப்பேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","பிறகு தேவன் அந்த இடத்தை விட்டு எழுந்தருளிப் போனார். ");
INSERT INTO tam2008_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","15","யாக்கோபு தேவன் தன்னோடு பேசின அந்த இடத்தில் ஒரு ஞாபகக் கல் நிறுத்தி அதில் திராட்சைரசத்தையும் எண்ணெயையும் ஊற்றினான். இது ஒரு சிறப்பான இடம். ஏனென்றால் அதுதான் தேவன் அவனிடம் பேசிய இடம். எனவே யாக்கோபு அதற்கு “பெத்தேல்” என்று பெயரிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","யாக்கோபு அவனது கூட்டமும் பெத்தேலை விட்டுப் புறப்பட்டது. எப்பிராத்தாவுக்கு வர இன்னும் கொஞ்ச தூரம் இருந்தது. அப்போது ராகேல் பிள்ளை பெற்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","ஆனால் பிரசவ வேதனை அதிகமாக இருந்தது. தாதியோ, “பயப்படாதே நீ இன்னொரு குழந்தையையும் பெறுவாய்” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","ஆனால் அவள் ஆண் குழந்தை பெறும்போதே மரித்துபோனாள். மரிக்கும் முன்னால் தன் மகனுக்குப் பெனோனி என்று பெயர் சூட்டினாள். ஆனால் யாக்கோபு அவனைப் பென்யமீன் என்று அழைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ராகேல் எப்பிராத்தாவுக்குப் போகும் சாலை ஓரத்திலேயே அடக்கம் செய்யப்பட்டாள். (எப்பிராத்தா என்பது பெத்லேகம் ஆகும்) ");
INSERT INTO tam2008_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","யாக்கோபு அதில் ஒரு சிறப்பான கல்தூணை நட்டு ராகேலின் கல்லறையைப் பெருமைப்படுத்தினான். இன்றும் அக்கல் (தூண்) உள்ளது. ");
INSERT INTO tam2008_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","இஸ்ரவேல் (யாக்கோபு) தன் பயணத்தைத் தொடர்ந்தான். ஏதேர் கோபுரத்திற்குத் தென் பகுதியில் கூடாரமிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","இஸ்ரவேல் அங்கு கொஞ்சக்காலமே தங்கினான். அப்போது ரூபன், தன் தந்தையின் வேலைக் காரியான பில்காளோடு பாலின உறவு கொண்டதை அறிந்து இஸ்ரவேல் கடுங்கோபம் கொண்டான். யாக்கோபிற்கு (இஸ்ரவேலுக்கு) 12 மகன்கள் இருந்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","ரூபன், சிமியோன், லேவி, யூதா, இசக்கார், செபுலோன் ஆகியோர் யாக்கோபுக்கும் லேயாளுக்கும் முதலில் பிறந்தவர்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","யோசேப்பும் பென்யமீனும் யாக்கோபுக்கும் ராகேலுக்கும் பிறந்தவர்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","தாண், நப்தலி ஆகிய இருவரும் யாக்கோபுக்கும் பில்காளுக்கும் பிறந்தவர்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","காத், ஆசேர் இருவரும் யாக்கோபுக்கும் சில்பாளுக்கும் பிறந்தவர்கள். இவர்கள் அனைவரும் பதான் அராமில் யாக்கோபிற்குப் (இஸ்ரவேலுக்கு) பிறந்தவர்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","யாக்கோபு தனது தந்தை ஈசாக்கு இருந்த கீரியாத் அர்பாவிலிருந்த மம்ரேக்கு சென்றான். அங்கேதான் ஆபிரகாமும் வாழ்ந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ஈசாக்கு 180 ஆண்டுகள் வாழ்ந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","பிறகு ஈசாக்கு பலவீனமாகி மரித்துப் போனான். அவன் நீண்ட முழுமையான வாழ்க்கை வாழ்ந்தான். ஏசாவும் யாக்கோபும் ஆபிரகாமை அடக்கம் செய்த இடத்திலேயே ஈசாக்கையும் அடக்கம் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","இது ஏசாவின் குடும்ப வரலாறு. ");
INSERT INTO tam2008_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","ஏசா கானான் நாட்டுப் பெண்களை மணந்துகொண்டான். அவன் ஏத்தியனான ஏலோனின் மகளான ஆதாளையும், ஏவியனாகிய சிபியோனின் மகளும் ஆனாகின் மகளுமான அகோலிபாமாளையும் முதலில் மணந்துகொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","இஸ்மவேலின் மகளும் நெபாயோத்தின் சகோதரியுமான பஸ்மாத்தையும் பிறகு மணந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","ஏசாவுக்கும் ஆதாளுக்கும் எலீப்பாஸ் என்ற மகன் பிறந்தான். பஸ்மாத்துக்கு ரெகுவேல் என்ற மகன் பிறந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","அகோலி பாமாளுக்கு எயூஷ், யாலாம், கோரா என்ற மூன்று மகன்கள் பிறந்தனர். ஏசாவின் இந்தப் பிள்ளைகள் கானான் நிலப் பகுதியிலேயே பிறந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","8","யாக்கோபு மற்றும் ஏசா ஆகியோரின் குடும்பங்கள் கானான் நாட்டில் வளர்ந்து மிகப் பெரிதாயின. எனவே ஏசா தன் சகோதரன் யாக்கோபை விட்டு விலகிப்போனான். ஏசா தனது மனைவியரையும், பிள்ளைகளையும், அடிமைகளையும், பசுக்கள் மற்றும் மிருகங்களையும் மற்ற பொருட்களையும் எடுத்துக்கொண்டு சேயீர் எனும் மலைப் பகுதிக்குச் சென்றான். (ஏசாவுக்கு ஏதோம் என்ற பேரும் உண்டு. சேயீர் நாட்டுக்கும் இந்தப் பெயர் உண்டு) ");
INSERT INTO tam2008_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","ஏசா ஏதோம் ஜனங்களுக்குத் தந்தையானான். சேயீர் எனும் மலைப் பகுதியில் வாழ்ந்த ஏசா குடும்பத்தினரின் பெயர்கள் பின்வருமாறு: ");
INSERT INTO tam2008_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ஏசாவுக்கும் ஆதாவுக்கும் பிறந்த மகன் எலிப்பாஸ். ஏசாவுக்கும் பஸ்மாத்துக்கும் பிறந்த மகன் ரெகுவேல். ");
INSERT INTO tam2008_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","எலிப்பாசுக்கு தேமான், ஓமார், செப்போ, கத்தாம், கேனாஸ் எனும் ஐந்து மகன்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","எலிப்பாசுக்குத் திம்னா என்ற வேலைக்காரி இருந்தாள். அவளுக்கும் அவனுக்கும் அமலேக்கு என்ற மகன் பிறந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","ரெகுவேலுக்கு நகாத், செராகு, சம்மா, மீசா என்று நான்கு மகன்கள். இவர்கள் ஏசாவுக்கு பஸ்மாத் மூலம் வந்த பேரக்குழந்தைகள். ");
INSERT INTO tam2008_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ஏசாவின் மூன்றாவது மனைவியான சிபியோனின் மகள் ஆனாகினின் மகளான அகோலிபாமாள் எயூஷ், யாலாம், கோராகு எனும் மகன்களைப் பெற்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ஏசாவின் மகன்களில் கீழ்க்கண்ட கோத்திரங்கள் தோன்றினர். ஏசாவின் மூத்த மகன் எலீப்பாஸ். எலீப்பாசிலிருந்து தேமான், ஓமார், செப்போ, கேனாஸ், ");
INSERT INTO tam2008_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","கோராகு, கத்தாம், அமலேக்கு என்பவர்கள். இவர்கள் ஏதோம் நாட்டில் எலீப்பாசின் சந்ததியும் ஏசாவின் மனைவி வழி வந்த ஆதாளின் கோத்திரங்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","ஏசாவின் மகனாகிய ரெகுவேலின் மகன்களில் நகாத், செராகு, சம்மா, மீசா என்பவர்கள் முக்கியமானவர்கள். இவர்கள் ஏதோம் நாட்டில் ரெகுவேலின் சந்ததியும் ஏசாவின் மனைவியாகிய பஸ்மாத்தின் மகனுமாயிருந்த பிரபுக்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","ஏசாவின் மனைவியாகிய அகோலிபாமாளின் மகன்கள் எயூஷ், யாலாம், கோராகு என்பவர்கள். இவர்கள் ஆனாகின் மகளும் ஏசாவின் மனைவியுமாகிய அகோலிபாமாளின் சந்ததியாயிருந்த தலைவர்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","இவர்கள் எல்லோரும் ஏசாவின் குடும்பத்திலிருந்து வந்தவர்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","அந்த நாட்டில் ஏசாவுக்கு முன் வாழ்ந்த சேயீருக்கு லோத்தான், சோபால், சிபியோன், ஆனாகு, ");
INSERT INTO tam2008_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","திஷோன், ஏதசேர், திஷான் என்னும் மகன்கள் இருந்தனர். இவர்கள் ஏதோம் நாட்டில் சேயீரின் மகன்களாகிய ஓரியருடைய சந்ததியாயிருந்த பிரபுக்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","லோத்தானுக்கு ஓரி, ஏமாம் எனும் மகன்கள் இருந்தனர். லோத்தானின் சகோதரி திம்னாள் என்பவள். ");
INSERT INTO tam2008_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","சோபாலினுக்கு அல்வான், மானகாத், ஏபால், செப்போ, ஓனாம் எனும் மகன்கள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","சிபியோனுக்கு அயா, ஆனாகு எனும் மகன்கள் இருந்தனர். ஆனாகு தன் தகப்பனாகிய சிபியோனின் கழுதைகளைப் பாலைவனத்தில் மேய்க்கையில் வெந்நீர் ஊற்றுகளைக் கண்டுபிடித்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","ஆனாகினுக்கு திஷோன், அகோலிபாமாள் எனும் பிள்ளைகள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","திஷோனுக்கு எம்தான், எஸ்பான், இத்தரான், கெரான் எனும் மகன்கள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","ஏத்சேனுக்கு பில்கான், சகவான், அக்கான் என்னும் மகன்கள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","திஷானுக்கு ஊத்ஸ், அரான், என்னும் மகன்கள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","ஓரியரின் சந்ததியிலே லோத்தான், சோபால், சிபியோன், ஆனாகு, ");
INSERT INTO tam2008_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","திஷோன், ஏத்சேர், திஷான் என்பவர்கள் தலைவர்கள் ஆனார்கள். இவர்களே சேயீர் நாட்டிலே தங்கள் பகுதிகளில் இருந்த ஓரியர் சந்ததியிலே உள்ள பிரபுக்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","அப்பொழுது ஏதோமிலே இராஜாக்கள் இருந்தார்கள். இஸ்ரவேலுக்கு நீண்ட காலத்திற்கு முன்பே ஏதோமில் பல மன்னர்கள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","பேயோர் எனும் அரசனின் மகனாகிய பேலா ஏதோமில் ஆட்சி செலுத்தி வந்தான். அவன் தின்காபா எனும் நகரிலிருந்து ஆண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","பேலா மரித்ததும் யோபாப் அரசன் ஆனான். இவன் போஸ்றாவிலுள்ள சேராகுவின் மகன். ");
INSERT INTO tam2008_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","யோபாப் மரித்ததும் ஊசாம் அரசாண்டான். இவன் தேமானிய நாட்டினன். ");
INSERT INTO tam2008_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","ஊசாம் மரித்ததும் ஆதாத் அரசாண்டான். இவன் பேதாதின் மகன். (ஆதாத் மோவாபிய நாட்டிலே மீதியானியரை வெற்றி பெற்றவன்) இவன் ஆவீத் நாட்டிலிருந்து வந்தவன். ");
INSERT INTO tam2008_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ஆதாத் மரித்தபின் சம்லா அரசாண்டான். இவன் மஸ்ரேக்கா ஊரைச் சார்ந்தவன். ");
INSERT INTO tam2008_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","சம்லா மரித்தபின் சவுல் அரசாண்டான். இவன் அங்குள்ள ஆற்றின் அருகிலுள்ள ரெகொபோத் ஊரைச் சேர்ந்தவன். ");
INSERT INTO tam2008_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","சவுல் மரித்தபின் பாகால்கானான் அரசாண்டான். இவன் அக்போருடைய மகன். ");
INSERT INTO tam2008_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","பாகால் கானான் மரித்தபின் ஆதார் அரசாண்டான். இவன் பாகு எனும் நகரைச் சேர்ந்தவன். இவனது மனைவியின் பெயர் மெகேதபேல். இவள் மத்ரேத் மற்றும் மேசகாவின் மகள். ");
INSERT INTO tam2008_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","ஏசாவே ஏதோமிய குடும்பங்களின் தந்தை ஆவான். ஏசாவின் வம்சத்தில் திம்னா, அல்வா, ஏதேத், அகோலிபாமா, ஏலா, பினோன், கேனாஸ், தேமான், மிப்சர், மக்தியேல், ஈராம் எனும் பிரபுக்கள் இருந்தனர். ஒவ்வொரு குடும்பமும் அந்தந்த குடும்பப் பெயர்களால் அழைக்கப்படுகிற பகுதிகளில் வாழ்ந்து வந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","கானான் தேசத்திலேயே யாக்கோபு வாழ்ந்து வந்தான். இதே நாட்டில் தான் அவனது தந்தையும் வாழ்ந்திருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","இது யாக்கோபின் குடும்ப வரலாறு: யோசேப்பு ஓர் 17 வயது இளைஞன். தன் சகோதரர்களோடு சேர்ந்து ஆடு மாடுகளைக் கவனித்துக்கொள்வது அவனது வேலை. பில்காள், சில்பாள், ஆகியோரின் மகன்களும் அவனோடு இருந்தனர் (பில்காளும, சில்பாளும் அவனது தந்தையின் மனைவிகள்.) யோசேப்பு தன் சகோதரர்கள் செய்த கெட்ட செயல்களைத் தந்தையிடம் சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","யோசேப்பு பிறக்கும்போது இஸ்ரவேலுக்கு மிக முதிய வயது. எனவே அவன் மற்ற மகன்களைவிட யோசேப்பைப் பெரிதும் நேசித்தான். அவனுக்கென்று ஒரு தனி அங்கியைக் கொடுத்திருந்தான். அது மிக நீளமானதாகவும் அழகானதாகவும் இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","யோசேப்பின் சகோதரர்கள், தங்கள் தந்தை தங்களைவிட யோசேப்பை அதிகமாக நேசிப்பதாக உணர்ந்தனர். இதனால் அவர்கள் அவனை வெறுத்தனர். எனவே அவர்கள் அவனோடு அன்பாகப் பேசுவதில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ஒரு நாள் யோசேப்புக்கு விசேஷமான கனவு வந்தது. அவன் அதனைச் சகோதரர்களிடம் சொன்னான். அதனால் அவர்கள் அவனை மேலும் வெறுத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","யோசேப்பு, “நான் ஒரு கனவு கண்டேன். ");
INSERT INTO tam2008_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","நாம் எல்லோரும் வயலில் வேலை செய்துகொண்டிருக்கிறோம். கோதுமை அரிகளைக் கட்டிக்கொண்டிருக்கிறோம். அப்போது என்னுடைய கட்டு நிமிர்ந்திருந்தது. உங்கள் கட்டுகள் என் கட்டுகளைச் சுற்றி வந்து வணங்கின” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","அவனுடைய சகோதரர்கள், “இதனால் நீ அரசனாகி எங்களையெல்லாம் ஆளலாம் என்று நினைக்கிறாயா?” எனக் கேட்டனர். அவன் சகோதரர்கள் இக்கனவைப்பற்றி அறிந்தபிறகு அதிகமாக அவனை வெறுத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","பிறகு யோசேப்புக்கு இன்னொரு கனவு வந்தது. அதையும் அவன் அவர்களிடம் சொன்னான். “நான் இன்னொரு கனவு கண்டேன். அதில் சூரியனும் சந்திரனும் பதினொரு நட்சத்திரங்களும் என்னை வணங்கின” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","அவன் அக்கனவைத் தந்தையிடமும் சொன்னான். ஆனால் அவனது தந்தை அவனை விமர்சனம் செய்து, “என்ன மாதிரியான கனவு இது? நானும் உனது தாயும் சகோதரர்களும் உன்னை வணங்குவோம் என நினைக்கிறாயா?” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","யோசேப்பின் சகோதரர்கள் தொடர்ந்து அவன்மீது பொறாமைகொண்டிருந்தனர், அவன் தந்தையோ அவன் சொன்னதை மனதிலே வைத்துக்கொண்டு, அது என்னவாக இருக்கும் என்று யோசனை செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","ஒரு நாள் யோசேப்பின் சகோதரர்கள் சீகேமிற்குத் தங்கள் தந்தையின் ஆடுகளை மேய்க்கப் போனார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","சில நாட்களான பின்பு யாக்கோபு யோசேப்பிடம், “சீகேமிற்குப் போ. அங்கு உன் சகோதரர்கள் ஆடு மேய்க்கிறார்கள்” என்றான். யோசேப்பும், “நான் போகிறேன்” என்று கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","யாக்கோபு அவனிடம், “போய் உன் சகோதரர்களும், ஆடுகளும் பத்திரமாக இருக்கிறார்களா என்று பார்த்து வா” என்றான். அவனை எபிரோன் சமவெளியிலிருந்து சீகேமிற்கு அனுப்பினான். ");
INSERT INTO tam2008_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","சீகேமிற்குப் போகும்போது யோசேப்பு வழிதப்பிவிட்டான். ஒரு மனிதன் இவன் அலைந்துகொண்டிருப்பதைப் பார்த்து, “யாரை நீ தேடிக்கொண்டிருக்கிறாய்?” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","“நான் என் சகோதரர்களைத் தேடிக்கொண்டிருக்கிறேன். அவர்கள் மந்தைகளோடு எங்கே இருக்கிறார்கள் என்று சொல்லமுடியுமா?” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","அவனோ, “அவர்கள் ஏற்கெனவே தோத்தானுக்குப் போயிருப்பதாகக் கேள்விப்பட்டேன்” என்றான். எனவே யோசேப்பும் தோத்தானுக்குப் போய் சகோதரர்களைக் கண்டுகொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","யோசேப்பு தூரத்தில் வரும்போதே அவனது சகோதரர்கள் அவனைப் பார்த்துவிட்டு, அவனைக் கொன்றுவிட முடிவுசெய்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","அவர்கள் ஒருவருக்கொருவர், “கனவு காணும் யோசேப்பு வந்துகொண்டிருக்கிறான். ");
INSERT INTO tam2008_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","இப்பொழுது நம்மால் அவனைக் கொல்லமுடியும். கொன்று ஏதாவது ஒரு கிணற்றில் அவன் பிணத்தை எறிந்துவிடுவோம். ஏதோ காட்டு மிருகம் அவனைக் கொன்றுவிட்டதாகத் தந்தையிடம் சொல்லுவோம். அவனது கனவுகள் பயனற்றவை என்று நீரூபிப்போம்” எனப் பேசிக்கொண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","ஆனால் யோசேப்பைக் காப்பாற்ற ரூபன் விரும்பினான். “அவனைக் கொல்ல வேண்டாம். ");
INSERT INTO tam2008_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","அவனைத் தூக்கி பாலைவனத்திலுள்ள இந்தக் கிணற்றில் போட்டுவிடுங்கள்” என்றான். பிறகு அவனைக் காப்பாற்றி தந்தையிடம் அனுப்பலாம் என்று அவன் திட்டம் போட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","யோசேப்பு சகோதரர்களிடம் வந்தான். அவர்கள் அவனை அடித்து அவனது அழகான மேல் அங்கியைக் கிழித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","பிறகு அவனை ஒரு வறண்ட கிணற்றில் தூக்கிப்போட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","அவன் கிணற்றில் கிடக்கும்போது அவர்கள் மேலே உணவு உண்ண உட்கார்ந்தனர். அப்போது வியாபாரிகள் கூட்டமாகக் கீலேயாத்திலிருந்து எகிப்து நோக்கிப் போவதைக் கண்டனர். அவர்கள் ஒட்டகங்களில் நிறைய செல்வங்களையும் விலையுயர்ந்த பொருட்களையும் ஏற்றிச் சென்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","எனவே யூதா சகோதரர்களிடம், “யோசேப்பைக் கொன்று மறைத்து விடுவதால் நமக்கு என்ன லாபம்? ");
INSERT INTO tam2008_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","அதைவிட அவனை வியாபாரிகளிடம் விற்றுவிட்டால் நிறைய லாபம் கிடைக்குமே, சொந்த சகோதரனைக் கொன்றோம் என்ற பழியும் இருக்காதே” என்றான். மற்ற சகோதரர்களும் இதற்கு ஒப்புக்கொண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","மீதியானிய வியாபாரிகள் அருகில் வந்ததும் யோசேப்பைக் கிணற்றிலிருந்து வெளியே எடுத்து 20 வெள்ளிக்காசுகளுக்கு அவனை விற்றுவிட்டனர். அவர்கள் யோசேப்பை எகிப்துக்கு அழைத்துக்கொண்டு போனார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","இச்சமயத்தில் ரூபன் அவர்களோடு இல்லை. அவனுக்கு அவர்கள் யோசேப்பை விற்றுவிட்டார்கள் என்பது தெரியாது. அவன் கிணற்றைப் பார்த்தபோது அவன் இல்லாததை அறிந்து வருத்தப்பட்டு தன் ஆடைகளைக் கிழித்துக்கொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","ரூபன் தன் சகோதரர்களிடம் போய், “அந்த இளைஞன் கிணற்றில் இல்லையே, நான் என்ன செய்வது?” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","அச்சகோதரர்கள் ஒரு ஆட்டைக் கொன்று அதன் இரத்தத்தை யோசேப்பின் அங்கியில் தோய்த்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","பிறகு அதைக் கொண்டுபோய் தந்தையிடம் காட்டி, “இந்த அங்கியைக் கண்டெடுத்தோம். இது யோசேப்பினுடையதா?” என்று கேட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","தந்தை அந்த அங்கியைப் பார்த்துவிட்டு அது யோசேப்பினுடையது என்று அறிந்துகொண்டான். “ஆமாம் இது அவனுடையதுதான். ஒருவேளை ஏதாவது காட்டு மிருகம் அவனைக் கொன்றிருக்கும். என் மகன் யோசேப்பு காட்டு மிருகத்தால் உண்ணப்பட்டான்” என்று கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","அவனுக்கு வருத்தம் அதிகமாகித் தன் ஆடைகளைக் கிழித்துக்கொண்டான். பிறகு அவன் தன் சோகத்தை சாக்கினாலான ஆடையை அணிந்து வெளிப்படுத்தினான். அவன் தொடர்ந்து நீண்ட நாள் மகனைப் பிற்றிய துக்கத்தில் இருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","யாக்கோபின் பிற மகன்களும், மகள்களும் அவனுக்கு ஆறுதல் கூற முயன்றார்கள். ஆனால் அவன் ஆறுதல் அடையவில்லை. “நான் மரிக்கும்வரை என் மகனுக்காக வருத்தப்படுவேன்” என்று கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","மீதியானிய வியாபாரிகள் எகிப்தில் யோசேப்பை விற்றுவிட்டார்கள். பார்வோனின் பிரதானியும் தலையாரிகளுக்குத் தலைவனுமான போத்திப்பாருக்கு அவனை விற்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","அந்த நேரத்தில் யூதா தன் சகோதரர்களை விட்டுவிட்டு ஈரா என்ற பெயருடைய மனிதனோடு இருந்தான். ஈரா அதுல்லாம் என்ற நகரிலிருந்து வந்தவன். ");
INSERT INTO tam2008_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","யூதா ஒரு கானானிய பெண்ணைச் சந்தித்து அவளை மணந்துகொண்டான். அவளது தந்தையின் பெயர் சூவா. ");
INSERT INTO tam2008_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","அவளுக்கு ஒரு மகன் பிறந்தான். அவனுக்கு ஏர் என்று பெயர் வைத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","அவள் இன்னொரு மகனைப் பெற்றாள். அவனுக்கு ஓனான் என்று பேர் வைத்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","இன்னொரு மகன் அவளுக்கு பிறந்தான். அவனுக்கு சேலா என்று பெயர் வைத்தார்கள். அவன் பிறந்த போது அவர்கள் கெசீபிலே வாழ்ந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","யூதா தன் மூத்த மகனான ஏர் என்பவனுக்கு மணம் முடிக்க ஒரு பெண்ணைத் தேர்ந்தெடுத்தான். அந்த பெண்ணின் பெயர் தாமார். ");
INSERT INTO tam2008_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","ஆனால் ஏர் பல தீய செயல்களைச் செய்தான். கர்த்தர் அவனைப்பற்றி சந்தோஷமடையாததால், கர்த்தர் அவனை அழித்துவிட்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","பிறகு யூதா, ஏரின் சகோதரனான ஓனானிடம், “போய் உன் சகோதரனின் மனைவியச் சேர்த்துக்கொண்டு அவளுக்குக் கணவனாகு. அவளுக்குக் குழந்தைகள் பிறந்தால் அவை உன் சகோதரன் ஏருக்கு உரியதாகும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","இந்தச் சேர்க்கையினால் பிறக்கும் குழந்தைகள் தன்னுடையதாக இருக்காது என்பதை ஓனான் அறிந்தான். ஓனான் தாமாருடன் பாலின உறவுகொள்ளும்போது தனது சகோதரனுக்கு சந்ததி உண்டாகாதிருக்கத் தனது வித்துவைத் தரையில் விழச் செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","இது கர்த்தருக்கு மிகவும் கோபம் மூட்டியது. எனவே கர்த்தர் ஓனானையும் அழித்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","பிறகு யூதா தன் மருமகளான தாமாரிடம், “உன் தந்தை வீட்டிற்குப் போ. என் இளைய மகன் வளர்ந்து ஆளாகிற வரை நீ அவனுக்காகக் காத்திரு” என்றான். சேலாவும் அழிந்து போவானோ என்று யூதா அஞ்சினான். தாமார் தன் தந்தை வீட்டிற்குப் போனாள். ");
INSERT INTO tam2008_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","பின்னர் சூவாவின் மகளான யூதாவின் மனைவி மரித்துப் போனாள். யூதாவின் துக்க காலத்தில் அதுல்லாம் நகரைச் சேர்ந்த தன் நண்பன் ஈராவோடு தன் ஆடுகளுக்கு மயிர்கத்தரிக்க திம்னாவுக்குப் போனான். ");
INSERT INTO tam2008_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","தன் மாமனாராகிய யூதா ஆடுகளின் மயிரைக் கத்தரிக்கும்படி திம்னாவை நோக்கிச் செல்கிறார் என்பதைத் தாமார் அறிந்துகொண்டாள். அவள் எப்போதும் விதவைக்குரிய ஆடைகளையே அணிந்து வந்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","எனவே இப்போது வேறு ஆடைகளை அணிந்து, தன் முகத்தை மூடிக்கொண்டு திம்னா நகருக்கு அருகில் உள்ள ஏனாயிம் என்னும் இடத்துக்குச் செல்லும் பாதைக்கு அருகில் உட்கார்ந்துகொண்டாள். யூதாவின் இளைய மகனான சேலா அப்பொழுது வளர்ந்துவிட்டான் என்பதைத் தாமார் அறிந்தாள். ஆனால் தாமார் அவனை மணப்பதற்கானத் திட்டத்தை யூதா செய்யமாட்டான் என்று அவள் உணர்ந்துகொண்டாள். ");
INSERT INTO tam2008_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","யூதா அவ்வழியாகப் போனபோது அவளைப் பார்த்தான். அவள் தன் முகத்தை மூடியிருந்தபடியால் அவளை வேசி என்று நினைத்துக்கொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","யூதா அவளிடம் போய், “நான் உன்னோடு பாலின உறவு கொள்ளலாமா” என்று கேட்டான். (அவனுக்கு அவள் தன் மருமகளான தாமார் என்பது தெரியாது) அவளோ, “எனக்கு எவ்வளவு கொடுப்பீர்?” என்று கேட்டாள். ");
INSERT INTO tam2008_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","அவனோ, “என் மந்தையிலிருந்து ஓர் இளம் ஆட்டை அனுப்புவேன்” என்றான். அவள் அதற்கு, “நான் ஒத்துக்கொள்கிறேன். ஆனால் முதலில் ஆடு வரும்வரை அடமானமாக ஏதாவது கொடுத்துவிட்டுப் போகவேண்டும்” என்று கேட்டாள். ");
INSERT INTO tam2008_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","அவன், “என்னிடமிருந்து அடமானமாக என்ன பொருளை விரும்புகிறாய்” என்று கேட்டான். அவள், “உம்முடைய முத்திரை மோதிரமும், ஆரமும், கைக்கோலும் வேண்டும்” என்று கேட்டாள். யூதாவும் அவ்வாறே கொடுத்துவிட்டு அவளோடு பாலின உறவு கொண்டான். அதனால் அவள் கர்ப்பமானாள். ");
INSERT INTO tam2008_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","தாமார் தன் வீட்டிற்குப் போய் முக் காட்டை எடுத்துவிட்டாள். பின் விதவைக்குரிய ஆடைகளை அணிந்துகொண்டாள். ");
INSERT INTO tam2008_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","யூதா தான் வாக்களித்தபடி வேசியிடம் ஆட்டுக் குட்டியைக் கொடுக்க தன் நண்பன் ஈராவை அனுப்பினான். அவளிடம் கொடுத்த அடமானப் பொருட்களையும் வாங்கி வருமாறு சொன்னான். ஆனால் அவனால் அவளைக் கண்டுபிடிக்க முடியவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","ஈரா அந்நகர ஜனங்கள் பலரிடம் அந்த வேசியைப்பற்றி விசாரித்தான். அவர்கள், “அத்தகைய வேசி இங்கு இல்லை” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","எனவே அவன் யூதாவிடமே திரும்பி வந்தான். “என்னால் அந்தப் பெண்ணைக் கண்டுபிடிக்க முடியவில்லை. அங்குள்ளவர்கள் அத்தகைய வேசி அங்கில்லை எனக் கூறுகின்றனர்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","அதனால் யூதா, “அவள் எனது பொருட்களை வைத்திருக்கட்டும். ஜனங்கள் எங்களை நகையாடுவதை நான் விரும்பவில்லை. ஆட்டுக்குட்டியை அவளுக்குக் கொடுக்க முயன்றேன். அங்கே அவளோ இல்லை, இதுபோதும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","மூன்று மாதங்கள் ஆனதும் சிலர் யூதாவிடம், “உன் மருமகள் தாமார் ஒரு வேசியைப்போல பாவம் செய்துவிட்டாள். இப்போது அவள் கர்ப்பமாக இருக்கிறாள்” என்றனர். யூதாவோ, “அவளை அழைத்துப் போய் எரித்துவிடுவோம்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","அந்த மனிதர்கள் தாமாரைக் கொல்வதற்காக அவளிடம் சென்றார்கள். ஆனால் அவள் தன் மாமனாருக்கு ஒரு செய்தியை அனுப்பினாள், “என்னைக் கர்ப்பவதியாக்கிய மனிதருக்குரிய பொருட்கள் சில என்னிடம் உள்ளன. இப்பொருட்களைப் பாருங்கள், அவர் யார்? யாருடைய முத்திரையும், ஆரமும் இது? யாருடைய கோல் இது?” என்று கேட்டிருந்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","யூதாவுக்கு எல்லாம் புரிந்து போயிற்று, “அவள் சொல்வது சரி, நானே தவறு செய்து விட்டேன். நான் சொன்னபடி என் மகன் சேலாவை நான் அவளுக்குக் கொடுக்கவில்லை” என்று உணர்ந்தான். அவன் மீண்டும் தாமாரோடு பாலின உறவு கொள்ளவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","தாமார் குழந்தைபெறும் காலம் வந்தது. அவளுக்கு இரட்டைக் குழந்தை பிறக்கும் என்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","முதலில் ஒரு குழந்தை கையை நீட்டியதும் அதன் கையில் சிவப்புக் கயிற்றைக்கட்டி “அது மூத்த குழந்தை” என்றாள் தாதி. ");
INSERT INTO tam2008_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","ஆனால் அக்குழந்தை கைகளை உள்ளே இழுத்துக்கொண்ட போது இன்னொரு குழந்தை பிறந்தது. எனவே தாதி, “நீ மீறிக்கொண்டு வந்தாய். அதனால் மீறுதல் உன்னிடம் நிற்கும்” என்று அதற்கு பாரேஸ் என்று பேரிட்டாள். ");
INSERT INTO tam2008_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","பின்னரே அடுத்த குழந்தை பிறந்தது. அதன் கையில் சிவப்புக் கயிறு இருந்ததால் சேரா என்று பெயரிட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","யோசேப்பை வாங்கிய வியாபாரிகள் அவனை எகிப்தில் பார்வோனின் படைத் தலைவன் போத்திபாரிடம் விற்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","ஆனால் கர்த்தர் அவனுக்கு உதவினார். யோசேப்பு ஒரு வெற்றியுள்ள மனிதன் ஆனான். அவன் தன் எஜமானனின் வீட்டில் வசித்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","கர்த்தர் யோசேப்போடு இருப்பதையும், அவன் செய்கிற எல்லாவற்றிலும் கர்த்தரின் உதவியால் வெற்றி பெறுவதையும் பார்த்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","அதனால் யோசேப்பைப்பற்றி மிகவும் மகிழ்ச்சி அடைந்தான். எனவே, தனக்காக யோசேப்பு வேலை செய்வதை அனுமதித்ததுடன், தன் வீட்டைக் கவனித்துக்கொள்ளவும் வைத்தான். போத்திபாருக்குச் சொந்தமான எல்லாவற்றையும் யோசேப்பு ஆளுகை செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","யோசேப்பைத் தனது வீடு முழுவதற்கும் அதிகாரியாக்கியதும் கர்த்தர் அந்த வீட்டையும், போத்திபாருக்குச் சொந்தமான எல்லாவற்றையும் ஆசீர்வதித்தார். இவை அனைத்தையும் கர்த்தர் யோசேப்புக்காகச் செய்தார். போத்திப்பாருக்குரிய வீடு மற்றும் வயல்களையும் கர்த்தர் ஆசீர்வதித்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","ஆகவே போத்திபார் யோசேப்பிற்கு வீட்டிலுள்ள எல்லா பொறுப்புகளையும் கொடுத்துவிட்டான். அவன் உண்ணும் உணவைத் தவிர வேறு எதைப்பற்றியும் கவலைப்படவில்லை. யோசேப்பு கம்பீரமாகவும் பார்ப்பதற்கு அழகாகவும் இருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","கொஞ்சக் காலம் ஆனதும், யோசேப்பின் எஜமானனின் மனைவி யோசேப்பு மீது ஆசைப்பட ஆரம்பித்தாள். ஒரு நாள் அவனிடம், “என்னோடு பாலின உறவுகொள்ள வா” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","ஆனால் யோசேப்பு மறுத்துவிட்டான். “என் எஜமானன் என்னை நம்பி வீட்டிலுள்ள எல்லாவற்றையும் ஒப்படைத்திருக்கிறார். ");
INSERT INTO tam2008_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","என் எஜமானன் இந்த வீட்டில் ஏறக்குறைய என்னைத் தனக்குச் சமமாக வைத்திருக்கிறார். நான் அவரது மனைவியோடு பாலின உறவுகொள்ளக் கூடாது. இது தவறு, தேவனுக்கு விரோதமான பாவம்” என்று கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","அவள் ஒவ்வொரு நாளும் யோசேப்போடு பேசி அவனை அழைத்தாள். அவனோ அவளோடு பாவத்தில் ஈடுபட மறுத்துவிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ஒரு நாள் அவன் வீட்டிற்குள் வேலை செய்வதற்காகப் போனான். அப்போது வீட்டில் அவன் மட்டும் தான் இருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","அவனது எஜமானனின் மனைவி அவனது அங்கியை பற்றிப் பிடித்து, “என்னோடு பாலின உறவுகொள்ள வா” என்றாள். எனவே அவன் வேகமாக வீட்டைவிட்டு வெளியே ஓடிவிட்டான். அப்போது அவனது அங்கி அவளது கையில் சிக்கிக்கொண்டது. ");
INSERT INTO tam2008_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","அவள் அதனைக் கவனித்தாள். நடந்ததைப்பற்றி அவள் பொய்யாகச் சொல்லத் திட்டமிட்டாள். ");
INSERT INTO tam2008_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","அவள் வீட்டிலுள்ள வேலைக்காரர்களை அழைத்து “பாருங்கள், நம்மை அவமானம் செய்வதற்காக இந்த எபிரெய அடிமை கொண்டு வரப்பட்டுள்ளான். அவன் வந்து என்னோடு படுக்க முயன்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","நான் சத்தமிட்டதால் அவன் ஓடிப் போய்விட்டான். அவனது அங்கி மட்டும் சிக்கிக்கொண்டது” என்று முறையிட்டாள். ");
INSERT INTO tam2008_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","அவள் அந்த அங்கியை அவள் புருஷன் வரும் வரை வைத்திருந்து, ");
INSERT INTO tam2008_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","அவனிடமும் அதே கதையைக் கூறினாள். “நீங்கள் கொண்டுவந்த எபிரெய அடிமை என்னைக் கெடுக்கப் பார்த்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","அவன் என்னருகில் வந்ததும் நான் சத்தமிட்டேன், அவன் ஓடிவிட்டான். அவனது அங்கி மட்டும் சிக்கிக்கொண்டது” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","யோசேப்பின் எஜமானன் அவனது மனைவி சொன்னதைக் கேட்டு கோபம் கொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","அரசனுடைய பகைவர்களைப் போடுவதற்கென்றிருந்த சிறையிலே போத்திபார் யோசேப்பைப் போட்டுவிட்டான். யோசேப்பு அங்கேயே தங்கினான். ");
INSERT INTO tam2008_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","ஆனால் கர்த்தர் யோசேப்போடு இருந்தார். அவர் தொடர்ந்து தனது இரக்கத்தை அவன்மீது காட்டி வந்தார். சிறையதிகாரி யோசேப்பை விரும்ப ஆரம்பித்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","யோசேப்பை கைதிகளைக் கண்காணிப்பவனாக நியமித்தான். அங்கு நடப்பவற்றுக்கு அவன் பொறுப்பாளியாக்கப்பட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","அந்த அதிகாரி அவனை முழுமையாக நம்பினான். கர்த்தர் யோசேப்போடு இருந்ததால் இது இவ்வாறு நடந்தது. அவன் செய்கிற ஒவ்வொரு காரியத்தையும் வெற்றிகரமாக்க கர்த்தர் உதவினார். ");
INSERT INTO tam2008_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","பிறகு, பார்வோனுக்கு எதிராக ரொட்டி சுடுபவனும், திராட்சைரசம் கொடுப்பவனுமான இரண்டு வேலைக்காரர்கள் தவறு செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","அவர்கள் மீது பார்வோனுக்கு மிகுந்த கோபம் இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","அரசன் அவர்களை யோசேப்பு இருந்த சிறையிலேயே அடைத்துவிட்டான். போத்திபார் இந்தச் சிறையின் பொறுப்பாளன். ");
INSERT INTO tam2008_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","அதிகாரி, இந்த இருவரையும் யோசேப்பின் கண்காணிப்பில் வைத்தார். இருவரும் சிறையில் கொஞ்சக் காலம் தொடர்ந்து இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ஓரிரவு, இருவருக்கும் கனவு வந்தது. இருவரும் வெவ்வேறு கனவுகளைக் கண்டனர். இருவரும் எகிப்திய அரசனின் வேலைக்காரர்கள். ஒருவன் ரொட்டி சுடுபவன், மற்றொருவன் திராட்சைரசம் கொடுப்பவன். ஒவ்வொன்றுக்கும் தனிதனிப் பொருள் இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","மறுநாள் காலையில் யோசேப்பு அவர்களிடம் சென்றான். அவர்கள் இருவரும் கவலையாயிருப்பதைக் கண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","அவர்களிடம், “ஏன் இவ்வாறு இன்று கவலையோடு இருக்கிறீர்கள்?” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","அவர்கள், “நேற்று நாங்கள் இருவரும் கனவு கண்டோம். அதன் பொருள் புரியவில்லை. அதின் பொருளையோ, விளக்கத்தையோ சொல்பவர்கள் யாரும் எங்களுக்கு இல்லை” என்றனர். யோசேப்பு அவர்களிடம், “தேவன் ஒருவரே நமது கனவுகளைப் புரிந்துகொண்டு விளக்க வல்லவர். என்னிடம் உங்கள் கனவுகளைக் கூறுங்கள் என்று கேட்டுக்கொள்கிறேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","திராட்சைரசம் கொடுப்பவன் தன் கனவை யோசேப்பிடம் கூறினான். “என் கனவில் நான் ஒரு திராட்சைக் கொடியைக் கண்டேன். ");
INSERT INTO tam2008_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","அதில் மூன்று கிளைகள் இருந்தன. அவை வளர்ந்து பூக்கள் விட்டு கனிவதைக் கண்டேன். ");
INSERT INTO tam2008_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","நான் பார்வோனின் கோப்பையை ஏந்தியிருந்தேன். எனவே அந்தத் திராட்சையைப் பிழிந்து சாறு எடுத்தேன். பிறகு அதனைப் பார்வோனுக்குக் கொடுத்தேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","பிறகு யோசேப்பு, “இந்தக் கனவை உனக்கு விளக்குவேன். மூன்று கிளைகள் என்பது மூன்று நாட்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","இன்னும் மூன்று நாளில் பார்வோன் உன்னை மன்னித்து, உன்னை விடுதலை செய்து, முன்பு அவரது கிண்ணம் ஏந்துபவனாக இருந்தது போல் உன்னை ஏற்றுக்கொள்வார். ");
INSERT INTO tam2008_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","ஆனால் நீ விடுதலையானதும் என்னை நினைத்துக்கொள். எனக்கும் உதவி செய். பார்வோனிடம் என்னைப்பற்றிக் கூறு. அவர் என்னை விடுதலை செய்வார். ");
INSERT INTO tam2008_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","நான் என் சொந்த எபிரெய நாட்டைவிட்டு இங்கு பலவந்தமாக கொண்டு வரப்பட்டேன். இங்கேயும் நான் தவறு செய்யவில்லை. நான் சிறையில் இருக்க வேண்டியவன் அல்ல” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","ரொட்டி சுடுபவன் மற்றவனின் கனவுக்கு நல்ல பொருள் இருப்பதை அறிந்தான். தன் கனவையும் யோசேப்பிடம் கூறினான். “நானும் ஒரு கனவு கண்டேன். என் தலையில் மூன்று ரொட்டிக் கூடைகள் இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","மேல் கூடையில் எல்லா வகையான சமைத்த உணவுகளும் இருந்தது. அது பார்வோனுக்கு உரியது. ஆனால் பறவைகள் அவற்றைத் தின்றுகொண்டிருந்தன” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","யோசேப்பு, “நான் உனக்கு அக்கனவின் பொருளைச் சொல்கிறேன். மூன்று கூடைகள் மூன்று நாட்களைக் குறிக்கும். ");
INSERT INTO tam2008_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","மூன்று நாள் முடிவதற்குள் நீ வெளியே செல்வாய். அரசன் உன் தலையை வெட்டிவிடுவான். உனது உடலைக் கம்பத்தில் தொங்கவிடுவான். பறவைகள் உன் உடலைத் தின்னும்” என்று சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","மூன்று நாளானதும் பார்வோனுடைய பிறந்த நாள் வந்தது. அவன் தன் வேலைக்காரர்களுக்கெல்லாம் விருந்து கொடுத்தான். அதனால் ரொட்டி சுடுபவனையும் திராட்சைரசம் கொடுப்பவனையும் விடுதலை செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","பார்வோன் திராட்சைரசம் கொடுப்பவனுக்கு மீண்டும் வேலை கொடுத்தான். அவனும் பார்வோனிடம் ஒரு கோப்பை திராட்சை ரசத்தை கொடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ஆனால் பார்வோன் ரொட்டி சுடுபவனைக் கொன்றுவிட்டான். யோசேப்பு சொன்னதுபோலவே அனைத்தும் நிகழ்ந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","ஆனால் திராட்சைரசம் வழங்குபவன் உதவிசெய்ய மறந்துவிட்டான். அவன் யோசேப் பைப்பற்றி பார்வோனிடம் எதுவும் சொல்லவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","இரண்டு ஆண்டுகள் கழிந்தது. பார்வோன் ஒரு கனவு கண்டான். நைல் நதியின் அருகில் நின்றுகொண்டிருப்பதாகக் கனவு கண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ஆற்றிலிருந்து ஏழு பசுக்கள் வெளியே வந்து புல் தின்றுகொண்டிருந்தன. அவை செழுமையாகவும் ஆரோக்கியமாகவும் இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","மேலும் ஏழு பசுக்கள் ஆற்றிலிருந்து வெளியே வந்து கரையில் நின்ற மற்ற பசுக்களோடு நின்றன. அவை மெலிந்தும் பார்க்க அருவருப்பாகவும் இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","மெலிந்த அருவருப்பான பசுக்கள் கொழுத்த ஆரோக்கியமான ஏழு பசுக்களையும் உண்டன. பிறகு பார்வோன் எழும்பினான். ");
INSERT INTO tam2008_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","பார்வோன் மீண்டும் தூங்கி கனவு காண ஆரம்பித்தான். அப்போது ஒரே செடியில் ஏழு செழுமையான கதிர்கள் வந்திருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","மேலும் ஒரு செடியில் ஏழு கதிர்கள் வந்தன. ஆனால் அவை செழுமையில்லாமல் இருந்தன. காற்றில் உதிர்ந்துபோயின. ");
INSERT INTO tam2008_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","மெலிந்த ஏழு கதிர்களும் செழுமையான ஏழு கதிர்களை விழுங்கிவிட்டன. பார்வோன் மீண்டும் எழுந்து தான் கண்டது கனவு என உணர்ந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","மறுநாள் காலையில் அவன் இதைப்பற்றி மிகவும் கவலைப்பட்டான். அவன் எகிப்திலுள்ள அனைத்து மந்திரவாதிகளையும், ஞானிகளையும் அழைத்தான். அவர்களிடம் தன் கனவைச் சொன்னான். ஆனால் ஒருவராலும் அதற்கு விளக்கம் சொல்ல முடியவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","பிறகு திராட்சைரசம் கொடுப்பவனுக்கு யோசேப்பைப்பற்றிய நினைவு வந்தது. அவன் பார்வோனிடம், “எனக்கு ஏற்பட்டது இன்று நினைவுக்கு வருகிறது. ");
INSERT INTO tam2008_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","உங்களுக்குக் கோபம் வந்து என்னையும், ரொட்டி சுடுபவனையும் சிறையில் அடைத்திருந்தீர்களே, ");
INSERT INTO tam2008_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","அப்போது ஓரிரவில் நாங்கள் கனவு கண்டோம். இரண்டும் வெவ்வேறு கனவுகள். ");
INSERT INTO tam2008_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","அங்கு எபிரேய இளைஞன் ஒருவன் இருந்தான். அவன் சிறையதிகாரியின் உதவியாள். நாங்கள் அவனிடம் கனவைச் சொன்னோம். அவன் அதைப்பற்றி விளக்கம் சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","அவன் சொன்னதெல்லாம் உண்மையாயிற்று. நான் மூன்று நாளில் விடுதலையாகிப் பழைய வேலையைப் பெறுவேன் என்றான். அது அவ்வாறாயிற்று. ரொட்டி சுடுபவன் தூக்கிலிடப்படுவான் என்றான். அது போலவே நடந்தது” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","எனவே, பார்வோன் சிறையில் இருந்து யோசேப்பை அழைத்தான். அதிகாரி உடனே யோசேப்பை வெளியே கொண்டு வந்தான். அவன் சவரம் செய்து நல்ல ஆடைகள் அணிந்துகொண்டு, பார்வோனைப் பார்க்கப்போனான். ");
INSERT INTO tam2008_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","பார்வோன் யோசேப்பிடம், “நான் கனவு கண்டேன். எவராலும் அதற்கு பொருள் சொல்லமுடியவில்லை. உன்னிடம் அவற்றைப்பற்றி சொன்னால் நீ அதற்கு விளக்கம் சொல்ல முடியும் என்று அறிந்தேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","யோசேப்பு, “என்னால் முடியாது. ஆனால் தேவன் உமக்காக விளக்கம் தருவார்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","பிறகு பார்வோன், “கனவில் நான் நைல் ஆற்றின் கரையில் நின்றுகொண்டிருந்தேன். ");
INSERT INTO tam2008_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","அப்போது ஏழு பசுக்கள் ஆற்றிலிருந்து வெளியே வந்து புல் மேய்ந்துகொண்டிருந்தது. அவை செழுமையாகவும், பார்க்க அழகாகவும் இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","பிறகு மேலும் ஏழு பசுக்கள் ஆற்றிலிருந்து வெளியே வந்தன. அவை மெலிந்து, நோய் கொண்டவையாக இருந்தன. அவற்றைப் போன்று மோசமான பசுக்களை நான் எகிப்திலே எங்கும் பார்த்ததில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","அவை செழுமையான பசுக்களை உண்டுவிட்டன. ");
INSERT INTO tam2008_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","அவை அதற்குப் பிறகும் ஒல்லியாகவும், நோயுற்றும் தோன்றின. அவை பசுக்களைத் தின்றுவிடும் என்று சொல்ல முடியாத வகையிலேயே இருந்தன. அதற்குள் நான் எழுந்துவிட்டேன். ");
INSERT INTO tam2008_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“அடுத்த கனவில் ஒரு செடியில் ஏழு கதிர்களைக் கண்டேன். அவை செழுமையாக இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","பிறகு செடியில் மேலும் ஏழு கதிர்கள் வளர்ந்தன. காற்றில் உதிரக் கூடிய நிலையில் மெலிந்து இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","பிறகு இவை செழுமையான கதிர்களை விழுங்கிவிட்டன. “நான் இந்தக் கனவை மந்திரவாதிகளிடமும் ஞானிகளிடமும் கூறினேன். ஆனால் யாராலும் இவற்றிற்கு பதில் சொல்ல முடிய வில்லை, இவற்றின் பொருள் என்ன?” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","பிறகு யோசேப்பு பார்வோனிடம், “இரண்டு கனவுகளுக்கும் ஒரே பொருள் தான். விரைவில் என்ன நடக்கும் என்பதைத் தேவன் கூறிவிட்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","ஏழு செழுமையான பசுக்கள், ஏழு செழுமையான கதிர்கள் என்பது ஏழு வளமான ஆண்டுகளைக் குறிக்கும். ");
INSERT INTO tam2008_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","ஏழு மெலிந்த பசுக்கள் ஏழு மெலிந்த கதிர்கள் என்பது பஞ்சமான ஏழு ஆண்டுகளைக் குறிக்கும். வளமான ஏழு ஆண்டுகளுக்குப் பிறகே பஞ்சமான ஏழு ஆண்டுகள் வரும். ");
INSERT INTO tam2008_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","விரைவில் என்ன நடக்கும் என்பதை தேவன் உமக்கு காண்பித்திருக்கிறார். இவ்வாறே தேவன் நடத்துவார். ");
INSERT INTO tam2008_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","இன்னும் ஏழு ஆண்டுகளுக்கு எகிப்தில் ஏராளமான உணவுப் பொருட்கள் விளையும். ");
INSERT INTO tam2008_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","பிறகு ஏழு ஆண்டுகள் பஞ்சமும் பசியும் இருக்கும். எகிப்து ஜனங்கள் முன்பு கடந்த காலத்தில் தாங்கள் வைத்திருந்த உணவின் மிகுதியை மறந்துவிடுவார்கள். இப்பஞ்சம் நாட்டை அழித்துவிடும். ");
INSERT INTO tam2008_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ஏனென்றால் தொடர்ந்து வரும் பஞ்சம் அவ்வளவு கடுமையாக இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","“நீர் ஏன் ஒரே பொருள்பற்றிய இரு கனவுகளைக் கண்டிருக்கிறீர் தெரியுமா? இது நிச்சயம் நடக்கும் என்பதை தேவன் உமக்குக் காட்ட விரும்புகிறார். அதோடு தேவன் இதனை விரைவில் நிகழவைப்பார். ");
INSERT INTO tam2008_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","எனவே, நீர் புத்திசாலியான ஒருவனிடம் எகிப்தின் பொறுப்புகளை விடவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","பிறகு மேலும் சிறந்த ஆட்களை தேர்ந்தெடுத்து உணவுப் பொருட்களை எல்லாம் சேகரிக்க வேண்டும். இனியுள்ள ஏழு வருடங்களும் ஜனங்கள் தங்கள் விளைச்சலில் ஐந்தில் ஒரு பங்கை அரசனுக்குரியதென இவர்களிடம் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","இவ்வாறு அந்த ஆட்கள் உணவுப் பொருட்களைச் சேகரித்து, தேவைப்படும் அளவுக்கு நன்றாகச் சேமித்து வைக்கவேண்டும். இந்த உணவு உமது கட்டுப்பாட்டிற்குள் இருக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","பிறகு ஏழு பஞ்ச ஆண்டுகளில் தேவையான உணவுப் பொருள் எகிப்து நாட்டில் இருக்கும். அதனால் எகிப்து பஞ்சத்தில் அழியாமல் இருக்கும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","இந்த விளக்கம் பார்வோனுக்கும் அவனது அதிகாரிகளுக்கும் பொருத்தமானதாக இருந்தது. அதோடு ");
INSERT INTO tam2008_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","பார்வோன் அவர்களிடம், “யோசேப்பைவிடப் பொருத்தமானவன் வேறு யாரும் இருப்பதாகத் தெரியவில்லை. தேவ ஆவியானவர் அவன் மேல் இருக்கிறார். அவனை மிக ஞானமுள்ளவனாக ஆக்கியிருக்கிறார்!” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","எனவே, பார்வோன் யோசேப்பிடம், “தேவன் இவற்றை உனக்குத் தெரியச் செய்தார். உன்னைப்போல் அறிவுக் கூர்மையும், ஞானமும் உள்ளவர்கள் வேறு யாருமில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","உன்னை என் நாட்டிற்கு அதிகாரியாய் ஆக்குகிறேன். உன் கட்டளைகளுக்கு என் ஜனங்கள் அடங்கி நடப்பார்கள். நான் மட்டுமே உன்னைவிட மிகுந்த அதிகாரம் பெற்றவனாக இருப்பேன்” என்று கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","யோசேப்பை ஆளுநர் ஆக்குவதற்குரிய விசேஷச் சடங்கும், ஊர்வலமும் சிறப்பான முறையில் நடந்தன. “உன்னை எகிப்து முழுமைக்கும் ஆளுநர் ஆக்குகிறேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","பார்வோன் யோசேப்புக்கு தனது விசேஷ மோதிரத்தைக் கொடுத்தான். அம்மோதிரத்தில் அரசமுத்திரை பொறிக்கப்பட்டிருந்தது. இத்தோடு அழகான ஆடைகளையும், அவன் கழுத்தில் பொன்மாலையும் அணிவித்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","யோசேப்பைத் தனது இரண்டாவது இரதத்தில் ஏற்றி ஊர்வலமாகப் போகச் செய்தான். காவல் அதிகாரிகள் அவன் முன்னே போய் ஜனங்களிடம், “யோசேப்புக்கு அடிபணியுங்கள்” என்றனர். இவ்வாறு யோசேப்பு எகிப்து முழுவதற்கும் ஆளுநர் ஆனான். ");
INSERT INTO tam2008_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","பார்வோன் யோசேப்பிடம், “நான் எகிப்தின் அரசனாகிய பார்வோன். எனக்கு விருப்பமான முறையில் நான் நடந்துகொள்வேன். வேறுயாரும் இந்நாட்டில் உன் அனுமதி இல்லாமல் கையைத் தூக்கவோ காலை நகர்த்தவோ முடியாது” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","பார்வோன் யோசேப்புக்கு சாப்னாத்பன்னேயா என்று வேறு பெயர் சூட்டினான். அவனுக்கு ஆஸ்நாத் என்ற மனைவியையும் கொடுத்தான். அவள் ஓன் நகரத்து ஆசாரியனாகிய போத்திபிராவின் மகள். இவ்வாறாக யோசேப்பு எகிப்து தேசத்து ஆளுநரானான். ");
INSERT INTO tam2008_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","யோசேப்புக்கு அப்போது 30 வயது. அவன் நாடு முழுவதையும் சுற்றிப்பார்க்கப் புறப்பட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ஏழு ஆண்டுகளாக எகிப்தில் நல்ல விளைச்சல் இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","யோசேப்பு அவற்றை நன்கு சேமித்து வைத்தான். ஒவ்வொரு நகரத்திலும் அதன் சுற்றுப்புறத்திலுள்ள தானியங்களையெல்லாம் சேமித்து வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","யோசேப்பு ஏராளமாக கடற்கரை மணலைப்போன்று தானியங்களைச் சேமித்து வைத்தான். அவன் சேமித்த தானியமானது அளக்கமுடியாத அளவில் இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","யோசேப்பின் மனைவி ஆஸ்நாத்து ஓன் பட்டணத்து ஆசாரியனாகிய போத்திபிராவின் மகள். முதலாண்டு பஞ்சம் வருவதற்கு முன்னால் அவளுக்கு இரண்டு மகன்கள் பிறந்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","முதல் மகனுக்கு மனாசே என்று பேரிட்டான். ஏனென்றால், “தேவன் என் துன்பங்களையெல்லாம் மறக்கச் செய்தார். என் வீட்டையும் மறக்கச் செய்துவிட்டார்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","யோசேப்பு இரண்டாவது மகனுக்கு எப்பிராயீம் என்று பேரிட்டான். “நான் சிறுமைப்பட்டிருந்த தேசத்தில் தேவன் என்னைப் பலுகப் பண்ணினார்” என்று சொல்லி இந்தப் பெயரை வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ஏழு ஆண்டுகளுக்குத் தேவையான உணவுப் பொருட்கள் இருந்தன. அந்த ஆண்டுகள் முடிந்தன. ");
INSERT INTO tam2008_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","அதன் பிறகு யோசேப்பு சொன்னதைப்போலவே பஞ்ச காலம் துவங்கியது. எந்த நாடுகளிலும் உணவுப் பொருட்கள் விளையவில்லை. ஆனால் எகிப்தில் உணவுப் பொருட்கள் ஏராளமாக சேமிக்கப்பட்டிருந்தன. இதற்குக் காரணம் யோசேப்பின் திட்டம். ");
INSERT INTO tam2008_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","பஞ்சம் துவங்கியதும் ஜனங்கள் பார்வோனிடம் வந்து உணவுக்கு அழுதனர். பார்வோன் ஜனங்களிடம், “நீங்கள் போய் யோசேப்பிடம் என்ன செய்யலாம் எனக் கேளுங்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","எங்கும் பஞ்சம் அதனால் யோசேப்பு ஜனங்களுக்குச் சேமிப்பிலிருந்து தானியத்தை எடுத்துக் கொடுத்தான். சேர்த்து வைத்த தானியங்களை யோசேப்பு எகிப்தியருக்கு விற்றான். பஞ்சம் மேலும் மோசமாகியது. ");
INSERT INTO tam2008_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","எல்லா இடத்திலும் மோசமான அளவில் பஞ்சம் இருந்தது. எகிப்தைச் சுற்றி பல் வேறு நாடுகளிலிருந்து ஜனங்கள் உணவுப் பொருட்களை வாங்குவதற்காக எகிப்திற்கு வந்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","கானான் தேசத்திலும் கொடிய பஞ்சம் இருந்தது. யாக்கோபு எகிப்தில் உணவுப் பொருட்கள் இருப்பதாக அறிந்தான். எனவே அவன் தன் மகன்களிடம், “எதுவும் செய்யாமல் இங்கே இருந்து என்ன பயன்? ");
INSERT INTO tam2008_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","எகிப்தில் உணவுப் பொருட்களை விற்பதாகக் கேள்விப்பட்டேன். எனவே நாம் செத்துப் போவதற்குப் பதிலாக அங்கே போய் உணவுப் பொருட்களை வாங்கி வருவோம்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","எனவே, யோசேப்பின் பத்து சகோதரர்களும் உணவுப் பொருட்கள் வாங்க எகிப்து நாட்டிற்குப் போனார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","யாக்கோபு பென்யமீனை அவர்களோடு அனுப்பவில்லை. (அவனே யோசேப்பின் முழுமையான சகோதரன்) அவனுக்கும் ஏதாவது கேடு ஏற்படலாம் என்று யாக்கோபு பயந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","கானான் பகுதியில் பஞ்சம் மிகவும் கொடுமையாக இருந்தது. எனவே ஏராளமான ஜனங்கள் எகிப்துக்குப் போனார்கள். அவர்களுள் இஸ்ரவேலின் மகன்களும் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","யோசேப்புதான் எகிப்தின் ஆளுநராக அச்சமயத்தில் இருந்தான். எகிப்துக்கு வரும் ஜனங்களுக்கு விற்கப்படும் தானியத்தைக் கண்காணிக்கும் பொறுப்பு அவனிடமே இருந்தது. எனவே யோசேப்பின் சகோதரர்கள் அவனிடம் வந்து குனிந்து வணங்கி நின்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","யோசேப்பு தன் சகோதரர்களைப் பார்த்ததும், உடனே அடையாளம் கண்டுகொண்டான். எனினும் தெரிந்துகொண்டதைப்போல் காட்டிகொள்ளாமல் அவர்களிடம் கடுமையாக நடந்துகொண்டான். “எங்கேயிருந்து வருகின்றீர்கள்?” என்று கேட்டான். அவர்கள், “நாங்கள் கானான் பகுதியிலிருந்து வருகிறோம். உணவுப் பொருட்களை வாங்குவதற்காக வந்தோம்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","யோசேப்புக்கு அவர்கள் அனைவரும் தன் சகோதரர்கள் என்று புரிந்தது. ஆனால் அவர்களுக்கு அவனை அடையாளம் தெரியவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","அவன் தன் சகோதரர்களைப்பற்றி தான் கண்ட கனவை நினைத்துப் பார்த்தான். யோசேப்பு அவர்களிடம், “நீங்கள் உணவுப் பொருட்கள் வாங்க வரவில்லை, நீங்கள் ஒற்றர்கள். எங்கள் நாட்டின் பலவீனத்தைத் தெரிந்துகொள்ள வந்திருக்கிறீர்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","அவர்களோ, “இல்லை ஐயா! நாங்கள் உங்கள் வேலைக்காரர்களாக வந்திருக்கிறோம். உணவுப் பொருட்களை வாங்கவே வந்துள்ளோம். ");
INSERT INTO tam2008_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","நாங்கள் அனைவரும் சகோதரர்கள். எங்கள் அனைவருக்கும் ஒரே தந்தை. நாங்கள் நேர்மையானவர்கள். நாங்கள் தானியம் வாங்கவே வந்தோம்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","பின்னும் யோசேப்பு, “இல்லை! நீங்கள் எங்கள் பலவீனத்தை அறியவே வந்துள்ளீர்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","அவர்களோ, “இல்லை நாங்கள் அனைவரும் சகோதரர்கள். மொத்தம் பன்னிரெண்டு பேர். எல்லோருக்கும் ஒரே தந்தை. எங்கள் இளைய தம்பி வீட்டில் தந்தையோடு இருக்கிறான். இன்னொரு சகோதரன் பல ஆண்டுகளுக்கு முன் மரித்து போனான். இப்போது உங்கள் முன் வேலைக்காரர்களைப் போன்று இருக்கிறோம். நாங்கள் கானான் நாட்டிலிருந்து வந்துள்ளோம்” என்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","ஆனால் யோசேப்போ, “இல்லை! நீங்கள் ஒற்றர்களே. ");
INSERT INTO tam2008_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","ஆனால், நீங்கள் சொல்வது உண்மை என்பதை நிரூபிக்க அனுமதிக்கிறேன். உங்கள் இளைய சகோதரன் வந்தால் நீங்கள் போகலாம், இது பார்வோன்மேல் நான் இடுகிற ஆணை. ");
INSERT INTO tam2008_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","உங்களில் ஒருவர் மட்டும் ஊருக்குப் போய் இளைய சகோதரனை அழைத்துவர அனுமதிக்கிறேன். மற்றவர்கள் அனைவரும் சிறையில் இருக்கவேண்டும். நீங்கள் சொல்வது உண்மையா என்று பார்ப்பேன். ஆனால் உங்களை நான் ஒற்றர்கள் என்றே நினைக்கிறேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","பின்பு அவர்களை மூன்று நாட்களுக்குச் சிறையில் அடைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","மூன்று நாட்கள் ஆனதும் யோசேப்பு அவர்களிடம், “நான் தேவனுக்குப் பயந்தவன். நான் சொல்கிறபடி செய்தால் உங்களை விடுவேன். ");
INSERT INTO tam2008_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","நீங்கள் உண்மையில் நேர்மையானவர்கள் என்றால் உங்களில் ஒருவன் சிறையில் இருக்கட்டும். மற்றவர்கள் உணவுப் பொருட்களோடு உங்கள் நாட்டிற்கு செல்லுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","ஆனால் நீங்கள் உங்கள் இளைய சகோதரனை என்னிடம் அழைத்துவர வேண்டும். அதனால் உங்களது வார்த்தைகள் உண்மை என்று அறிவேன். நீங்களும் மரிக்காமல் இருக்கலாம்” என்றான். சகோதரர்கள் இதற்கு ஒப்புக்கொண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","அவர்கள் ஒருவருக்கொருவர், “நாம் நமது இளைய சகோதரனுக்குச் செய்த தீமைக்கே இந்தத் தண்டனை. அவன் துன்பப்படுவதைப் பார்த்தோம். தன்னைக் காப்பாற்றும்படி அவன் எவ்வளவோ கெஞ்சினான். ஆனால் நாம் அவன் சொன்னதைக் கவனிக்க மறுத்துவிட்டோம். இப்போது அதற்கு அனுபவிக்கிறோம்” என்று பேசிக்கொண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","பிறகு ரூபன் அவர்களிடம், “அவனுக்கு எந்தத் தீமையும் செய்யவேண்டாம் என்று நான் உங்களிடம் சொன்னேன். ஆனால் நான் சொன்னதை நீங்கள் கேட்கவில்லை. அவனது மரணத்துக்கு நாம் இப்போது தண்டனை அனுபவிக்கிறோம்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","24","யோசேப்பு மொழி பெயர்ப்பாளனைக் கொண்டு அவர்களோடு பேசியதால் தாங்கள் சொன்னதை அவன் புரிந்துகொள்ளமாட்டான் என்று அவர்கள் நினைத்தார்கள். ஆனால் யோசேப்பு அவர்கள் சொன்னவற்றையெல்லாம் புரிந்துகொண்டான். அவர்களின் வார்த்தைகள் அவனைப் பெரிதும் வருந்தச்செய்தது. எனவே, அவன் அவர்களை விட்டுப் போய் கதறி அழுதான். பிறகு அவர்களிடம் வந்து, சகோதரர்களுள் ஒருவனான சிமியோனைக் கைது செய்தான். மற்ற சகோதரர்கள் இதைப் பார்த்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","யோசேப்பு வேலைக்காரர்களிடம் அவர்களின் பைகளை உணவுப் பொருட்களால் நிரப்பிய பின்னர் அவர்கள் கொடுத்த பணத்தை அவர்கள் பையிலேயே போட்டு, அவர்களின் பயணத்துக்குத் தேவையானவற்றையெல்லாம் கொடுத்து அனுப்பச் சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","சகோதரர்கள் உணவுப் பொருட்களைக் கழுதைகளில் ஏற்றிக்கொண்டு போனார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","அன்று இரவு வழியில் ஓரிடத்தில் தங்கினார்கள். அப்போது ஒருவன் கழுதைக்காக உணவு எடுக்கப் பையைத் திறந்து பார்த்தபோது உள்ளே பணம் இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","அவன் மற்ற சகோதரர்களிடம், “பாருங்கள். இங்கே பணம் இருக்கிறது. நான் தானியத்துக்குப் பணம் கொடுத்தேன். ஆனால் பணம் என் பையில் திரும்பப் போடப்பட்டிருக்கிறது” என்றான். அவர்கள் பயந்தார்கள், “தேவன் நமக்கு என்ன செய்கிறார்?” என்று ஒருவருக்கொருவர் சொல்லிக்கொண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","அவர்கள் கானான் பகுதிக்குப் போய் தம் தந்தையான யாக்கோபைச் சந்தித்து, நடந்தவை அனைத்தையும் சொன்னார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“அந்நாட்டின் ஆளுநர் எங்களிடம் மிகக் கடுமையாகப் பேசினான். எங்களை ஒற்றர்கள் என்று குற்றம் சாட்டினான்” ");
INSERT INTO tam2008_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","நாங்கள் அவ்வாறு இல்லை என்று மறுத்தோம். நாங்கள் நேர்மையானவர்கள் என்றோம். ");
INSERT INTO tam2008_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","நாங்கள் பன்னிரண்டு சகோதரர்கள் என்றும் தந்தையைப்பற்றியும் இளைய தம்பியைப்பற்றியும் சொன்னோம். ");
INSERT INTO tam2008_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“பிறகு அந்த ஆளுநர் ‘நீங்கள் கௌரவமானவர்கள் என்பதை இதன் மூலம் நிரூபியுங்கள். ஒரு சகோதரனை விட்டு விட்டுப் போங்கள். உங்கள் உணவுப் பொருட்களை எடுத்துச் செல்லுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","பிறகு உங்கள் இளைய சகோதரனை அழைத்துக்கொண்டு வாருங்கள். அதன் பிறகு நீங்கள் கௌரமானவர்களா, இல்லை ஒற்றர்களா என்பதை அறிந்துகொள்வேன். நீங்கள் சொன்னது உண்மை என்றால் உங்கள் சகோதரனை விட்டு விடுவோம். நீங்களும் இந்த தேசத்திலே வியாபாரம் பண்ணலாம், என்று சொன்னான்’” என்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","பிறகு சகோதர்கள் அனைவரும் தங்கள் பைகளை அவிழ்த்து தானியத்தை வெளியே எடுத்தனர். எல்லாப் பைகளிலும் பணம் இருந்தது. சகோதரர்களும் தந்தையும் அவற்றைப் பார்த்து அஞ்சினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","யாக்கோபு அவர்களிடம், “நான் எனது எல்லா மகன்களையும் இழக்கவேண்டும் என்று விரும்புகிறீர்களா? யோசேப்பு போய்விட்டான். சிமியோனும் போய்விட்டான். நீங்கள் இப்போது பென்யமீனையும் கொண்டுபோகிறீர்களா?” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","அதற்கு ரூபன், “தந்தையே, நான் பென்யமீனை மீண்டும் உங்களிடம் அழைத்து வராவிட்டால் எனது இரண்டு மகன்களையும் கொன்றுவிடுங்கள். என்னை நம்புங்கள். நான் பென்யமீனைத் திரும்ப அழைத்துக்கொண்டு வருவேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","ஆனால் யாக்கோபு, “பென்யமீனை உங்களோடு அனுப்பமாட்டேன். அவனது ஒரே சகோதரன் மரித்துபோனான். ராகேலின் மகன்களில் இவன் ஒருவன் மட்டுமே உள்ளான். எகிப்துக்கு போகிற வழியில் ஏதாவது நடந்தால் அதுவே என்னைக் கொன்றுவிடும். வயதான என்னை துக்கத்துடனே கல்லறைக்கு அனுப்புவீர்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","நாட்டில் பஞ்சம் மிகக் கொடியதாய் இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","அவர்கள் எகிப்திலிருந்து வாங்கி வந்த தானியங்கள் எல்லாம் தீர்ந்துவிட்டது. யாக்கோபு தன் மகன்களிடம், “எகிப்துக்குப் போய் இன்னும் கொஞ்சம் தானியங்களை வாங்கி வாருங்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","ஆனால் யூதாவோ யாக்கோபிடம், “அந்நாட்டின் ஆளுநர் எங்களை எச்சரித்திருக்கிறார். ‘உங்கள் இளைய சகோதரனை அழைத்துக்கொண்டு வராவிட்டால் உங்களோடு பேசமாட்டேன்’ என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","நீங்கள் பென்யமீனை எங்களோடு அனுப்பினால் நாங்கள் போய் தானியங்களை வாங்கி வருவோம். ");
INSERT INTO tam2008_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ஆனால் நீங்கள் பென்யமீனை அனுப்ப மறுத்தால் நாங்கள் போகமாட்டோம். அந்த மனிதன் இவன் இல்லாமல் வரவேண்டாம் என்று எச்சரித்துள்ளான்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","இஸ்ரவேல் (யாக்கோபு) “அவனிடம் ஏன் உங்கள் இளைய சகோதரனைப்பற்றி சொன்னீர்கள்? ஏன் இதுபோல் ஒரு கெட்டச் செயலை எனக்குச் செய்தீர்கள்?” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","அதற்கு சகோதரர்கள், “அந்த மனிதன் ஏராளமான கேள்விகளைக் கேட்டான். அவன் எங்களைப்பற்றியும் நமது குடும்பத்தைப்பற்றியும் கேட்டான். அவன் எங்களிடம், ‘உங்கள் தந்தை உயிரோடு இருக்கிறாரா? இன்னொரு தம்பி வீட்டில் இருக்கிறானா?’ என்று கேட்டான். நாங்கள் பதிலை மட்டும் சொன்னோம். அவன் இளைய சகோதரனையும் அழைத்துக்கொண்டு வரச்சொல்லுவான் என்பதை நாங்கள் அறியோம்” என்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","பிறகு யூதா, “தன் தந்தையாகிய இஸ்ரவேலிடம் பென்யமீனை என்னோடு அனுப்பி வையுங்கள் அவனுக்கு நான் பொறுப்பு. உணவுப் பொருட்களுக்காக எகிப்துக்குப் போகவே வேண்டும். நாம் போகாவிட்டால் நீரும், நமது குழந்தைகளும் மரித்து போவோம். ");
INSERT INTO tam2008_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","அவனைப் பாதுகாப்பாக அழைத்து வருவோம் என்று உறுதி கூறுகிறேன். அவனை நாங்கள் திருப்பி அழைத்து வாராவிட்டால் நீங்கள் என்னை எப்பொழுதும் பழிகூறுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","நீங்கள் முன்னமே போகவிட்டிருந்தால் இதற்குள் இரண்டுமுறை போய் வந்திருக்கலாம்” என்று சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","பிறகு அவர்கள் தந்தை இஸ்ரவேல், “இது உண்மை என்றால் பென்யமீனை உங்களோடு அழைத்துப்போங்கள். ஆனால் ஆளுநருக்குச் சில அன்பளிப்புகளையும் எடுத்துக்கொள்ளுங்கள். நம் நாட்டில் சேகரிக்கத்தக்கவற்றைச் சேகரியுங்கள். தேன், பிசின்தைலம், கந்தவர்க்கம், வெள்ளைப்போளம், தொபிந்துகொட்டைகள், வாதுமைக் கொட்டைகள் போன்றவற்றை எடுத்துச் செல்லுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","பணத்தை இரட்டிப்பாய் எடுத்துப்போங்கள். கடந்த முறை நீங்கள் கொடுத்த பணம் தவறி உங்களிடமே வந்துவிட்டது ஆளுநர் தவறு செய்திருக்கலாம். ");
INSERT INTO tam2008_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","பென்யமீனையும் அழைத்துக்கொண்டு அவரிடம் போங்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","நீங்கள் ஆளுநர் முன்னால் நிற்கும்போது சர்வ வல்லமையுள்ள தேவன் உங்களுக்கு உதவுவார். அவர் சிமியோனையும், பென்ய மீனையும் திருப்பி அனுப்பும்படி பிரார்த்தனை செய்கிறேன். இல்லாவிட்டால் நான் மீண்டும் மகனை இழந்த துக்கத்துக்கு ஆளாவேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","எனவே, சகோதரர்கள் காணிக்கைப் பொருட்களோடும் இரண்டு மடங்கு பணத் தோடும் எகிப்துக்குப் புறப்பட்டுப் போனார்கள். இப்போது பென்யமீனும் அவர்களோடு போனான். ");
INSERT INTO tam2008_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","எகிப்தில், அவர்களோடு பென்யமீனை பார்த்த யோசேப்பு வேலைக்காரனிடம், “இவர்களை என் வீட்டிற்கு அழைத்து வாருங்கள். ஒரு மிருகத்தைக் கொன்று சமையுங்கள். இன்று மத்தியானம் அவர்கள் என்னோடு சாப்பிடுவார்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","வேலைக்காரன் யோசேப்பு சொன்னபடி செய்தான். அவர்களை யோசேப்பின் வீட்டிற்கு அழைத்துப் போனார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","அவர்கள் யோசேப்பின் வீட்டிற்கு அழைத்துச் செல்லப்பட்டபோது பயந்தனர். “சென்ற முறை பணத்தை பைக்குள்ளே போட்டுவிட்டதால் இப்போது தனது வீட்டிற்கு அழைக்கிறார். அது நமக்கு எதிரான சாட்சியாகப் பயன்படுத்தப்படும். நமது கழுதைகளைப் பறித்துக்கொண்டு நம்மை அடிமைகளாக்கிவிடுவார்கள்” என்று பேசிக்கொண்டார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","ஆகவே அவர்கள் அனைவரும் யோசேப்பின் வீட்டின் பொறுப்பாளனாகிய வேலைக்காரனிடம் வந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","அவர்கள் அவனிடம், “ஐயா, இதுதான் உண்மை என்று வாக்குறுதிச் செய்கிறோம். சென்றமுறை தானியம் வாங்க வந்தோம். ");
INSERT INTO tam2008_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","வீட்டிற்குத் திரும்பும்போது வழியில் பைக்குள் பணம் இருப்பதைப் பார்த்தோம். அதற்குள் எவ்வாறு வந்தது என்று எங்களுக்குப் புரியவில்லை. ஆனால் அந்தப் பணத்தைத் திருப்பிக் கொடுக்க கொண்டு வந்திருக்கிறோம். இந்த முறை உணவுப் பொருள் வாங்குவதற்கு அதிகப்படியான பணமும் கொண்டு வந்திருக்கிறோம்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","ஆனால் வேலைக்காரனோ, “பயப்பட வேண்டாம், நம்புங்கள் உங்கள் தேவனும் உங்கள் தந்தையின் தேவனும் அந்தப் பணத்தை உங்கள் பைகளில் போட்டிருக்கலாம். கடந்த முறை தானியத்துக்கான பணத்தைக் கொடுத்துவிட்டீர்கள் என்று நினைக்கிறேன்” என்றான். பிறகு அவன் சிமியோனைச் சிறையிலிருந்து விடுவித்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","அவர்கள் அனைவரையும் அழைத்துக்கொண்டு வேலைக்காரன் வீட்டிற்குள் போனான். அவர்களுக்குத் தண்ணீர் கொடுத்தான். அவர்கள் பாதங்களைக் கழுவிக்கொண்டனர். அவர்களின் கழுதைகளுக்கும் உணவு கொடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","அவர்கள் ஆளுநரோடு உண்ணப் போகிறோம் என்பதை அறிந்தனர். எனவே, அவனுக்குக் கொடுக்க வேண்டிய காணிக்கைகளை எடுத்து தயார் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","மதியம் ஆனபோது யோசேப்பு வீட்டிற்கு வந்தான். அவர்கள் அவனுக்குக் காணிக்கைகளைக் கொடுத்தனர். பிறகு அவனுக்கு முன்னால் பணிந்து வணங்கினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","யோசேப்பு அவர்களிடம் நடந்ததை எல்லாம் கேட்டான், “உங்கள் வயதான தந்தை எப்படி இருக்கிறார். இப்போதும் அவர் உயிரோடும் நலமாகவும் இருக்கிறாரா?” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","சகோதரர்கள் அனைவரும், “ஆமாம் ஐயா, அவர் இன்னும் உயிரோடு இருக்கிறார்” என்றனர். மீண்டும் அவனைப் பணிந்து வணங்கினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","பிறகு யோசேப்பு தன் தம்பியைப் பார்த்தான். (இருவரும் ஒரே தாயின் வயிற்றில் பிறந்தவர்கள்.) “இதுதான் எனக்கு நீங்கள் சொன்ன உங்கள் இளைய சகோதரனா?” என்று கேட்டான். பிறகு யோசேப்பு, “என் மகனே தேவன் உன்னை ஆசீர்வதிக்கட்டும்” என்று பென்யமீனிடம் சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","பிறகு அவன் அந்த அறையை விட்டு வெளியே ஓடினான். தன் சகோதரன் பென்யமீனைத் தான் மிகவும் விரும்புவதை அவனுக்கு உணர்த்தப் பெரிதும் விரும்பினான். அவனுக்கு அழவேண்டும்போல இருந்தது. ஆனால் தான் அழுவதைத் தன் சகோதரர்கள் பார்த்துவிடக் கூடாதே என்று அஞ்சினான். இதனால்தன் அறைக்குச் சென்று அழுதான். ");
INSERT INTO tam2008_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","பிறகு முகத்தைக் கழுவிக்கொண்டு வந்தான். அவன் தன்னைத் தானே அடக்கிக்கொண்டு, “இது உணவு உண்ணும் நேரம்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","அவனுக்கும் அவர்களுக்கும் மற்ற எகிப்தியர்களுக்கும் தனித்தனியாக மேஜை போடப்பட்டிருந்தது. அவர்களும் தனித் தனியாக அமர்ந்தார்கள். எகிப்தியர்கள் எபிரெயர்களோடு சேர்ந்து சாப்பிடுவதில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","யோசேப்பின் சகோதரர்கள் அவனுக்கு முன்னால் அமர்ந்தார்கள். மூத்தவன் முதல் இளையவன் வரை வரிசையாக அமர்ந்திருந்தார்கள். அவர்கள் நடப்பதைப்பற்றி வியப்புடன் ஒருவரை ஒருவர் பார்த்துக்கொண்டார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","வேலைக்காரர்கள் யோசேப்பின் மேஜையிலிருந்து உணவை எடுத்து வந்து அவர்களிடம் கொடுத்தார்கள். அவர்கள் பென்யமீனுக்கு மற்றவர்களைக் காட்டிலும் ஐந்து மடங்கு அதிகமாக உணவு கொடுத்தனர். சகோதரர்கள் யோசேப்போடு சாப்பிட்டு மகிழ்ச்சியாக இருந்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","பிறகு யோசேப்பு வேலைக்காரர்களிடம்: “இவர்களின் பைகளில் எவ்வளவு தானியம் போட முடியுமோ அவ்வளவு போடுங்கள். அவர்களால் கொண்டுபோக முடிகிறவரை போடுங்கள். தானியத்தோடு அவர்களின் பணத்தையும் போட்டுவிடுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","இளைய சகோதரனின் பைக்குள் பணத்தோடு குறிப்பாக எனது வெள்ளிக் கோப்பையையும் போடுங்கள்” என்றான். வேலைக்காரர்களும் அவ்வாறே செய்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","மறுநாள் அதிகாலையில் சகோதரர்களும் அவர்களின் கழுதைகளும் அவர்களின் நாட்டுக்குத் திரும்பி அனுப்பப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","அவர்கள் புறப்பட்டுப் போனதும் அவன் வேலைக்காரர்களிடம் “போய் அவர்களைப் பின் தொடருங்கள். அவர்களை நிறுத்தி, ‘நாங்கள் நல்லபடியாக நடந்துகொண்டோம். நீங்கள் ஏன் இவ்வாறு நடந்துகொள்கிறீர்கள், எங்கள் எஜமானின் வெள்ளிக் கோப்பையை ஏன் திருடினீர்கள்? ");
INSERT INTO tam2008_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","எங்கள் எஜமானர் அந்தக் கோப்பையில்தான் திராட்சைரசம் குடிப்பார். அவர் இதனைக் குறிகூறவும் பயன்படுத்துவார். நீங்கள் என்ன செய்தீர்களோ அது தவறு என்று கேளுங்கள்’” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","வேலைக்காரர்களும் அவ்வாறே செய்து, யோசேப்பு சொல்லச் சொன்னதைச் சொன்னார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","ஆனால் சகோதரர்களோ வேலைக்காரர்களிடம், “ஏன் இவ்வாறு ஆளுநர் சொன்னார்? நாங்கள் எதுவும் அவ்வாறு செய்யவில்லையே. ");
INSERT INTO tam2008_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","எங்கள் பைகளில் கண்டுபிடித்த பணத்தைத் திரும்பக்கொண்டு வந்திருக்கிறோம். நாங்கள் ஏன் உங்கள் எஜமானரின் வெள்ளியையும் தங்கத்தையும் திருடுகிறோம்? ");
INSERT INTO tam2008_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","எங்களில் எவராவது ஒருவரது பையில் அந்த வெள்ளிக் கோப்பை இருக்குமானால் அவன் சாகட்டும். நீங்கள் அவனைக் கொல்லுங்கள். நாங்கள் உங்கள் அடிமையாகிறோம்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","வேலைக்காரனோ, “நீங்கள் சொல்வது போலவே செய்வோம். ஆனால் அந்த மனிதனை நான் கொல்லமாட்டேன். அந்த வெள்ளிக் கோப்பை யாரிடம் உள்ளதோ அவன் எங்கள் அடிமையாவான். மற்றவர்களை விட்டுவிடுவேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","ஒவ்வொருவரும் தங்கள் பையை விரைவாக அவிழ்த்து தானியத்தைத் தரையில் கொட்டினர். ");
INSERT INTO tam2008_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","வேலைக்காரன் ஒவ்வொரு பையிலும் தேடினான். மூத்தவனிலிருந்து இளையவன் வரை என வரிசையாகத் தேடினான். அவன் பென்யமீனின் பையில் கோப்பையைக் கண்டு பிடித்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","சகோதரர்கள் மிகவும் துக்கப்பட்டனர். தம் துயரத்தை வெளிப்படுத்தும்படி தங்கள் ஆடைகளைக் கிழித்துக்கொண்டனர். தங்கள் பைகளைக் கழுதைகளின்மீது வைத்துக்கொண்டு நகரத்திற்குத் திரும்பினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","யூதாவும் பிற சகோதரர்களும் யோசேப்பின் வீட்டிற்கு வந்தனர். யோசேப்பு அங்கேயே இருந்தான். அவர்கள் அவனுக்கு முன்னால் விழுந்து வணங்கினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","யோசேப்பு, “ஏன் இவ்வாறு செய்தீர்கள்? நான் இரகசியங்களை அறிந்துகொள்ள சிறப்பான வழிகள் உண்டு என்று உங்களுக்குத் தெரியாதா? என்னைத் தவிர வேறு எவராலும் சிறப்பாகச் செய்ய முடியாது!” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","யூதா, ஐயா, “நாங்கள் சொல்வதற்கு எதுவுமில்லை. விளக்கிச் சொல்லவும் வழியில்லை. நாங்கள் குற்றமற்றவர்கள் என்பதை நிரூபிக்க முடியவில்லை. நாங்கள் எப்போதோ செய்த தவறுக்கு இப்போது தேவன் தண்டிக்கிறார். நாங்களும் பென்யமீனும் இனி உங்கள் அடிமைகள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","ஆனால் யோசேப்போ, “உங்கள் அனைவரையும் அடிமையாக்க நான் விரும்பவில்லை. என் கோப்பையைத் திருடியவனை மட்டுமே அடிமையாக்குவேன். உங்கள் தந்தையிடம் நீங்கள் அனைவரும் சமாதானமாகத் திரும்பிப் போகலாம்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","யூதா யோசேப்பிடம் போய், “ஐயா! எங்களை வெளிப்படையாகப் பேச விடுங்கள். எங்களிடம் கோபப்படாதீர்கள். நீங்கள் பார்வோன் மன்னரைப் போன்றவர் என்பதை அறிவோம். ");
INSERT INTO tam2008_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","முன்பு இங்கு வந்தபோது ‘உங்களுக்குத் தந்தையோ சகோதரரோ இருக்கிறார்களா’ என்று கேட்டீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","நாங்கள் எங்களுக்குத் தந்தை இருக்கிறார், அவர் முதியவர். இளைய சகோதரன் இருக்கிறான். அவன் எங்கள் தந்தையின் முதிய வயதில் பிறந்ததால் அவனைப் பெரிதும் நேசிக்கிறார். அவனோடு கூடப்பிறந்தவன் மரித்துப் போனான். இவன் ஒருவன் தான் அத்தாயின் மகன்களில் உயிரோடு இருக்கிறான். எனவே எங்கள் தந்தை இவனைப் பெரிதும் நேசிக்கிறார் என்றோம். ");
INSERT INTO tam2008_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","பிறகு நீங்கள், ‘அவனையும் அழைத்துக்கொண்டு வாருங்கள். நான் அவனைப் பார்க்க விரும்புகிறேன்’ என்றீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","அதற்கு நாங்கள், ‘அவனால் வரமுடியாது அவனைத் தந்தை விடமாட்டார். அவனைப் பிரிந்தால் எங்கள் தந்தை மரித்துபோவார்’ என்றோம். ");
INSERT INTO tam2008_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ஆனால் நீங்களோ எங்களிடம், ‘நீங்கள் அவனை அழைத்துக்கொண்டு வரவேண்டும் இல்லாவிட்டால் இனிமேல் தானியம் தரமுடியாது’ என்றீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","அதனால் நாங்கள் எங்கள் தந்தையிடம் போய் நீங்கள் சொன்னதையெல்லாம் சொன்னோம். ");
INSERT INTO tam2008_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“இறுதியில் எங்கள் தந்தை, ‘போய் இன்னும் தானியம் வாங்கிக்கொண்டு வாருங்கள்’ என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","நாங்கள் எங்கள் தந்தையிடம் ‘நாங்கள் எங்கள் இளைய சகோதரன் இல்லாமல் போகமாட்டோம். ஆளுநர் இவனைப் பார்க்காவிட்டால் தானியம் தர முடியாது என்று கூறியிருக்கிறார்’ என்றோம். ");
INSERT INTO tam2008_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","பிறகு என் தந்தை, ‘என் மனைவி ராகேல் எனக்கு இரண்டு மகன்களைக் கொடுத்தாள். ");
INSERT INTO tam2008_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","ஒரு மகனை வெளியே அனுப்பினேன். அவனைக் காட்டு மிருகங்கள் கொன்றுவிட்டன. அவனை இன்றுவரை காணவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","அடுத்த மகனையும் நீங்கள் அழைத்துப் போய் அவனுக்கு ஏதாவது நடந்தால் நான் மரணமடையுமளவுக்கு வருத்தமடைவேன்’ என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","இப்போதும் எங்களின் இளைய சகோதரன் இல்லாமல் நாங்கள் போகும்பொழுது என்ன நடக்கும் என்பதைக் கற்பனை செய்யுங்கள். அவனே எங்கள் தந்தையின் வாழ்வில் மிக முக்கியமானவன். ");
INSERT INTO tam2008_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","அவன் எங்களுடன் இல்லை என்பதை எங்கள் தந்தை அறிந்தால் அவர் மரித்துவிடுவார். மேலும் அது எங்களுடைய தவறாகும். நாங்கள் எங்கள் தந்தையை மிகக் கவலைகொண்ட மனிதராக அவரது கல்லறைக்கு அனுப்புவோம்! ");
INSERT INTO tam2008_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","“நான் என் தந்தையிடம் இவனுக்காக பொறுப் பேற்று வந்துள்ளேன். ‘நான் இவனைத் திரும்ப அழைத்துக்கொண்டு வராவிட்டால் என் வாழ்க்கை முழுவதும் என்னைப் பழிக்கலாம்’ என்றேன். ");
INSERT INTO tam2008_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","எனவே நான் உங்களை கெஞ்சிக் கேட்டுக்கொள்கிறேன். இவனை இவர்களோடு அனுப்பி வையுங்கள். நான் இங்கே உங்களுக்கு அடிமையாக இருக்கிறேன். ");
INSERT INTO tam2008_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","இவன் இல்லாமல் நான் என் தந்தையிடம் போகமாட்டேன். என் தந்தைக்கு என்ன நேருமோ என்று எனக்கு அச்சமாக இருக்கிறது” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","யோசேப்பு அதிக நேரம் தன்னைக் கட்டுப்படுத்திக்கொள்ள முடியவில்லை. அங்கிருந்தவர்களின் முன்னால் அவன் உள்ளம் உடைந்து கண்ணீர் சிந்தினான். யோசேப்பு “எல்லோரையும் வெளியே போகச்சொல்” என்று கட்டளையிட்டான். அனைவரும் வெளியேறினர். அச்சகோதரர்கள் மட்டுமே அங்கிருந்தார்கள். பிறகு அவன் தன்னை யாரென்று சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","யோசேப்பு தொடர்ந்து அழுதான். அந்த வீட்டில் உள்ள எகிப்தியர்கள் அனைவரும் அதைக் கேட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","யோசேப்பு தனது சகோதரர்களிடம், “நான் உங்களின் சகோதரன் யோசேப்பு. என் தந்தை உயிரோடு நலமாக இருக்கிறாரா?” என்று கேட்டான். சகோதரர்கள் அவனுக்குப் பதில் சொல்லவில்லை. அவர்கள் குழப்பமும் பயமும் கொண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","யோசேப்பு மீண்டும், “என்னருகே வாருங்கள். கெஞ்சி கேட்கிறேன், வாருங்கள்” என்றான். சகோதரர்கள் அவனருகே வந்தனர். அவர்களிடம், “நான் உங்கள் சகோதரன் யோசேப்பு. எகிப்திய வியாபாரிகளிடம் உங்களால் விற்கப்பட்டவன். ");
INSERT INTO tam2008_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","இப்போது அதற்காக வருத்தப்படாதீர்கள். நீங்கள் செய்தவற்றுக்காக உங்களையே கோபித்துக்கொள்ளாதீர்கள். இங்கே நான் வரவேண்டும் என்பது தேவனின் திட்டம். உங்கள் வாழ்க்கையைக் காப்பாற்றவே இங்கே இருக்கிறேன். ");
INSERT INTO tam2008_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","இந்தப் பஞ்சம் இரண்டு ஆண்டுகளாக இருக்கின்றன. இன்னும் ஐந்து ஆண்டுகள் இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","ஆகவே தேவன் என்னை உங்களுக்கு முன்னதாக அனுப்பி இருக்கிறார். அதனால் உங்களை காப்பாற்றமுடியும். ");
INSERT INTO tam2008_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","என்னை இங்கே அனுப்பியது உங்களது தவறு அல்ல. இது தேவனின் திட்டம். பார்வோன் மன்னருக்கே தந்தை போன்று நான் இங்கே இருக்கிறேன். நான் அரண்மனைக்கும் இந்த நாட்டிற்கும் ஆளுநராக இருக்கிறேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","யோசேப்பு அவர்களிடம், “வேகமாக என் தந்தையிடம் போங்கள். அவரது மகன் யோசேப்பு இந்தச் செய்தியை அனுப்பியதாகக் கூறுங்கள்: ‘தேவன் என்னை எகிப்தின் ஆளுநராக ஆக்கினார். எனவே என்னிடம் வாருங்கள். காத்திருக்க வேண்டாம். இப்போதே வாருங்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","என்னருகில் கோசேன் நிலப்பகுதியில் வாழலாம். நீங்களும், உங்கள் பிள்ளைகளும், பேரப்பிள்ளைகளும், மிருகங்களும் இங்கே வரவேற்கப்படுகிறீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","இனிவரும் ஐந்தாண்டு பஞ்சத்திலும் உங்கள் அனைவரையும் பாதுகாத்துக்கொள்வேன். எனவே, நீங்களும் உங்கள் குடும்பமும் உங்களுக்குரிய எதையும் இழக்கமாட்டீர்கள்’ என்று கூறுங்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","யோசேப்பு தன் சகோதரர்களிடம், “நன்றாக உறுதி செய்துகொள்ளுங்கள். நான் தான் யோசேப்பு. உங்கள் சகோதரனாகிய எனது வாய்தான் பேசுகிறது என்பதை நீங்களும் பென்யமீனும் கண்களால் காண்கிறீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","எகிப்திலே எனக்குள்ள மரியாதையையும் இங்கே நீங்கள் பார்க்கின்றவற்றையும் தந்தையிடம் சொல்லுங்கள். வேகமாகப் போய் தந்தையை அழைத்து வாருங்கள்” என்று சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","பிறகு தன் தம்பி பென்யமீனை அணைத்துக்கொண்டான். இருவரும் அழுதார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","பிறகு அவன் சகோதரர்கள் அனைவரையும் முத்தமிட்டான். அவர்களுக்காக அழுதான். இதற்குப் பிறகு அவர்கள் அவனோடு பேசத் தொடங்கினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","யோசேப்பின் சகோதரர்கள் வந்த செய்தியை பார்வோன் அறிந்துகொண்டான். பார்வோன் அரண்மனை முழுக்க அச்செய்தி பரவியது. அரசனும் அவனது வேலைக்காரர்களும் மகிழ்ச்சியடைந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","அரசன் யோசேப்பிடம் வந்து, “உங்கள் சகோதரர்களுக்குத் தேவையான உணவுப் பொருட்களை எடுத்துக்கொண்டு கானான் பகுதிக்குப் போகட்டும். ");
INSERT INTO tam2008_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","உனது குடும்பத்தையும் தந்தையையும் என்னிடம் அழைத்து வருமாறு கூறு. உங்களுக்கு வாழ நல்ல நிலத்தைக் கொடுக்கிறேன். இங்குள்ள சிறந்த உணவை அவர்கள் உண்ணலாம்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“அதோடு இங்குள்ள சிறந்த வண்டிகளை உன் சகோதரர்களுக்கு கொடு. அவர்கள் கானான் பகுதிக்குச் சென்று உன் தந்தையையும், பெண்களையும், குழந்தைகளையும் ஏற்றிக்கொண்டு வரட்டும். ");
INSERT INTO tam2008_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","அங்கிருந்து எல்லாவற்றையும் எடுத்துக்கொண்டு வருவதைக் குறித்துக் கவலைகொள்ள வேண்டாம். எகிப்திலுள்ளவற்றில் சிறந்தவற்றை அவர்களுக்குக் கொடுக்கலாம்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","எனவே இஸ்ரவேலின் பிள்ளைகளும் அவ்வாறே செய்தனர். பார்வோன் மன்னன் சொன்னது போல் நல்ல வண்டிகளையும், பயணத்திற்கு வேண்டிய உணவையும் யோசேப்பு கொடுத்து அனுப்பினான். ");
INSERT INTO tam2008_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","சகோதரர் அனைவருக்கும் யோசேப்பு அழகான ஆடைகளைக் கொடுத்தான். ஆனால் யோசேப்பு பென்யமீனுக்கு மட்டும் ஐந்து ஜோடி ஆடைகளையும், 300 வெள்ளிக் காசுகளையும் கொடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","யோசேப்பு தன் தந்தைக்கும் அன்பளிப்புகளைக் கொடுத்து அனுப்பினான். 10 கழுதைகள் சுமக்குமளவு எகிப்திலுள்ள சிறந்த பொருட்களையெல்லாம் கொடுத்தான். 10 பெண் கழுதைகள் சுமக்கும்படி உணவுப் பொருட்களும், ரொட்டியும் பிற பொருட்களும் தன் தந்தையார் திரும்பிவரும் பயணத்திற்குப் பயன்பட கொடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","பிறகு சகோதரர்களை அனுப்பினான். அவர்கள் பிரிந்து போகும்போது “நேராக வீட்டிற்குப் போங்கள், வழியில் சண்டை போடாதீர்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","எனவே, சகோதரர்கள் எகிப்தை விட்டு கானான் பகுதிக்குத் தந்தையிடம் போனார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","அவர்கள் அவரிடம், “யோசேப்பு உயிரோடு இருக்கிறான் அவன் எகிப்து நாடு முழுவதிற்கும் ஆளுநராக இருக்கிறான்” என்றனர். இந்தச் செய்தியைக் கேட்டதும் யாக்கோபு புரியாமலிருந்தான். முதலில் அவனால் நம்ப முடியவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","ஆனால் அவர்கள் யோசேப்பு சொன்னதை எல்லாம் சொன்னார்கள். தன்னை அழைத்துப் போவதற்காக யோசேப்பு அனுப்பியிருந்த வண்டிகளையெல்லாம் பார்த்தான். பிறகு யாக்கோபு புத்துணர்வு பெற்று மிக்க சந்தோஷமடைந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","“இப்போது உங்களை நம்புகிறேன், என் மகன் யோசேப்பு இன்னும் உயிரோடு இருக்கிறான். மரிப்பதற்கு முன்னால் அவனைப் பார்க்கப் போவேன்” என்று இஸ்ரவேல் கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","எனவே, இஸ்ரவேல் எகிப்துக்குப் பயணம் தொடங்கினான். அவன் முதலில் பெயெர் செபாவுக்குப் போனான். அவன் அங்கே தன் தகப்பனாகிய ஈசாக்கின் தேவனைத் தொழுதுகொண்டு, பலிகளும் செலுத்தினான். ");
INSERT INTO tam2008_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","இரவில் தேவன் கனவில் இஸ்ரவேலிடம் பேசினார். தேவன், “யாக்கோபே, யாக்கோபே” என்று கூப்பிட்டார். “நான் இங்கே இருக்கிறேன்” என்றான் இஸ்ரவேல். ");
INSERT INTO tam2008_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","அப்பொழுது அவர், “நான் தேவன், உன் தந்தைக்கும் தேவன். எகிப்திற்குப் போகப் பயப்படவேண்டாம். அங்கு உன்னைப் பெரிய இனமாக்குவேன். ");
INSERT INTO tam2008_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","உன்னோடு நானும் எகிப்துக்கு வருவேன். மீண்டும் உன்னை எகிப்திலிருந்து வெளியே வரவழைப்பேன். நீ எகிப்திலேயே மரணமடைவாய். ஆனால் யோசேப்பு உன்னோடு இருப்பான். நீ மரிக்கும்போது அவன் தன் கையாலேயே உன் கண்களை மூடுவான்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","பிறகு, யாக்கோபு பெயர்செபாவை விட்டு எகிப்துக்குப் பயணம் செய்தான். அவனது பிள்ளைகளும், பிள்ளைகளின் பிள்ளைகளும், அவர்களின் மனைவிமார்களும் எகிப்துக்கு வந்து சேர்ந்தார்கள். அவர்கள் பார்வோன் மன்னன் அனுப்பிய வண்டியில் பயணம் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","தங்கள் ஆடு மாடுகளையும் கானான் பகுதியில் சம்பாதித்த பொருட்களையும் எடுத்துக்கொண்டு எகிப்துக்குப் போனார்கள். எனவே இஸ்ரவேல் தன் குடும்பத்தோடும் தன் எல்லாப் பிள்ளைகளோடும் எகிப்திற்குச் சென்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","அவர்களோடு அவனது பிள்ளைகளும் பேரன்களும், பேத்திகளும், இருந்தனர். மொத்த குடும்பமும் அவனோடு எகிப்தை அடைந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","எகிப்துக்கு இஸ்ரவேலோடு சென்ற அவனது மகன்களின் பெயர்களும் குடும்பத்தின் பெயர்களும் பின்வருமாறு: ரூபன் முதல் மகன். ");
INSERT INTO tam2008_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ரூபனுக்கு ஆனோக்கு, பல்லூ, எஸ்ரோன், கர்மீ ஆகிய மகன்கள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","சிமியோனுக்கு எமுவேல், யாமின், ஓகாத், யாகீன், சொகார், கானானிய பெண்ணின் மகனான சவுல் ஆகிய பிள்ளைகள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","கெர்சோன், கோகாத், மெராரி ஆகியோர் லேவியின் பிள்ளைகள். ");
INSERT INTO tam2008_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","ஏர், ஓனான், சேலா, பாரேஸ், சேரா ஆகியோர் யூதாவின் பிள்ளைகள். (ஏர் மற்றும் ஓனான் கானானில் இருக்கும்போதே மரணமடைந்தனர்) எஸ்ரோன், ஆமூல் இருவரும் பாரேசுடைய குமாரர். ");
INSERT INTO tam2008_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","தோலா, பூவா, யோபு, சிம்ரோன் என்பவர்கள் இசக்காரின் பிள்ளைகள். ");
INSERT INTO tam2008_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","செரேத், ஏலோன், யக்லேல் ஆகியோர் செபுலோனுடைய பிள்ளைகள். ");
INSERT INTO tam2008_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","யாக்கோபுக்கும் லேயாளுக்கும் பிறந்த பிள்ளைகள் ரூபன், சிமியோன், லேவி, யூதா, இசக்கார், செபுலோன் ஆகியோர். அவள் இக்குழந்தைகளை பதான் ஆராமில் பெற்றாள். அவளுக்கு தீனாள் என்ற மகளும் உண்டு. மொத்தம் 33 பேர்கள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","காத்துக்கு சிபியோன், அகி, சூனி, எஸ்போன், ஏரி, அரோதி, அரேலி எனும் பிள்ளைகள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","ஆசேருக்கு, இம்னா, இஸ்வா, இஸ்வி, பெரீயா எனும் பிள்ளைகள் இருந்தனர். இவர்களுக்கு செராக்கு எனும் சகோதரி இருந்தாள். பெரீயாவுக்கு ஏபேர், மல்கியேல் என்ற பிள்ளைகள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","இவர்கள் அனைவரும் யாக்கோபின் மனைவியான லேயாளின் வேலைக்காரப் பெண் சில்பாவுக்குப் பிறந்தவர்கள். அவர்கள் மொத்தம் 16 பேர். ");
INSERT INTO tam2008_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","யாக்கோபின் மனைவியான ராகேலுக்கு இரண்டு பிள்ளைகள், யோசேப்பும் பென்ய மீனும். பென்யமீன் யாக்கோபோடு இருந்தான். யோசேப்பு ஏற்கெனவே எகிப்தில் இருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","எகிப்தில் யோசேப்புக்கு இரண்டு மகன்கள். அவர்கள் மனாசேயும் எப்பிராயீமும். அவன் மனைவி ஆஸ்நாத், ஓன் நகரத்து ஆசாரியனாகிய போத்திப்பிராவின் மகள். ");
INSERT INTO tam2008_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","பென்யமீனுக்கு பேலா, பெகேர், அஸ்பேல், கேரா, நாகமான், ஏகி, ரோஷ், முப்பிம், உப்பிம், ஆர்து என்னும் பிள்ளைகள். ");
INSERT INTO tam2008_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","இவர்கள் அனைவரும் யாக்கோபிற்கு ராகேல் மூலம் வந்தவர்கள். மொத்தம் 14 பேர். ");
INSERT INTO tam2008_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","தாணின் மகன் உசீம். ");
INSERT INTO tam2008_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","நப்தலியின் மகன்களான யாத்சியேல், கூனி, எத்சேர், சில்லேம் என்பவர்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","இவர்கள் யாக்கோபிற்கும் பில்காளுக்கும் பிறந்தவர்கள். (பில்காள் ராகேலின் வேலைக்காரி.) மொத்தம் ஏழு பேர். ");
INSERT INTO tam2008_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","ஆக மொத்தம் யாக்கோபு குடும்பத்தின் நேர் சந்ததியார் 66 பேர் இருந்தனர். இவர்கள் அனைவரும் எகிப்துக்குச் சென்றார்கள். இதில் யாக்கோபு மருமகள்கள் பெயர் சேர்க்கப்படவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","யோசேப்புக்கும் இரண்டு பிள்ளைகள். அவர்கள் எகிப்திலேயே பிறந்தவர்கள். எனவே ஒட்டுமொத்தமாக 70 பேர் யாக்கோபு குடும்பத்தில் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","முதலில் யாக்கோபு யூதாவை யோசேப்போடு பேச அனுப்பினான். யூதா யோசேப்பிடம் போய் அவனைக் கோசேனில் பார்த்தான். பிறகு யாக்கோபும் மற்றவர்களும் அவனோடு போனார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","யோசேப்பு தன் தந்தை வருவதை அறிந்து தன் தேரைத் தயார் செய்து அவரை எதிர்கொண்டழைக்கப் போனான். அவன் தன் தந்தையைப் பார்த்ததும் ஓடிப்போய் மார்போடு கட்டிப்பிடித்துக்கொண்டு நீண்ட நேரம் அழுதான். ");
INSERT INTO tam2008_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","இஸ்ரவேல் யோசேப்பிடம், “இப்போது நான் சமாதானமாக மரிப்பேன். உன் முகத்தைப் பார்த்துவிட்டேன். இன்னும் நீ உயிரோடு இருக்கிறாயே” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","யோசேப்பு தன் சகோதரர்களிடமும் அவர்களின் குடும்பத்தினரிடமும், “நான் இப்போது போய் பார்வோன் மன்னரிடம் நீங்கள் இங்கே இருப்பதைப்பற்றிக் கூறுவேன். அவரிடம், ‘என் சகோதரர்களும் அவர்களது குடும்பமும் கானான் நாட்டை விட்டு என்னிடம் வந்திருக்கிறார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","அவர்கள் மேய்ப்பர் குடும்பத்தினர். அவர்கள் எப்போதும் ஆடு மாடுகள் வைத்திருப்பார்கள். அவர்கள் ஆடு மாடுகளையும் அவர்களுக்குரிய அனைத்தையும் கொண்டு வந்திருக்கிறார்கள்’ என்பேன். ");
INSERT INTO tam2008_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","அவர் உங்களை அழைத்து ‘நீங்கள் என்ன வேலை செய்கிறீர்கள்?’ என்று கேட்டால், ");
INSERT INTO tam2008_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","அவரிடம் நீங்கள் ‘நாங்கள் மேய்ப்பர்கள், எங்கள் வாழ்க்கை முழுவதும் மேய்ப்பது தான் எங்கள் தொழில். எங்கள் முற்பிதாக்களும் மேய்ப்பர்கள்தான்’ என்று சொல்லுங்கள். பிறகு பார்வோன் மன்னன் உங்களை கோசேன் பகுதியில் வாழ அனுமதிப்பார். எகிப்தியர்கள் மேய்ப்பர்களை விரும்பமாட்டார்கள். எனவே நீங்கள் இங்கே கோசேனில் இருப்பதுதான் நல்லது” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","யோசேப்பு பார்வோனிடம் சென்று, “எனது தந்தையும் சகோதரர்களும் அவர்களின் குடும்பமும் வந்துள்ளது. அவர்கள் தங்கள் மிருகங்களையும், பொருட்களையும் கொண்டுவந்துள்ளனர். அவர்கள் இப்போது கோசேன் பகுதியில் உள்ளனர்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","யோசேப்பு தம் சகோதரர்களில் ஐந்து பேரைத் தேர்ந்தெடுத்து அழைத்துச் சென்று பார்வோன் முன் நிறுத்தினான். ");
INSERT INTO tam2008_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","பார்வோன் அவர்களிடம், “நீங்கள் என்ன வேலை செய்கிறீர்கள்?” என்று கேட்டான். அவர்கள், “ஐயா, நாங்கள் மேய்ப்பர்கள். எங்கள் முற்பிதாக்களும் மேய்ப்பர்கள்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","மேலும், “கானான் நாட்டில் பஞ்சம் அதிகம். எங்கள் மிருகங்களுக்கு அங்கே புல் மிகுந்த வயல் எதுவுமே இல்லை. எனவே, இங்கே வாழ்வதற்காக வந்துள்ளோம். கோசேனில் வாழ அனுமதிக்குமாறு கேட்டுக்கொள்கிறோம்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","பார்வோன் யோசேப்பிடம், “உனது தந்தையும் சகோதரர்களும் உன்னிடம் வந்திருக்கிறார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","எனவே, நீ எந்த இடத்தை வேண்டுமானாலும் தேர்ந்தெடுத்துக்கொள்ளலாம். அவர்களுக்கு நல்ல நிலத்தைக் கொடு. அவர்கள் வேண்டுமானால் கோசேனிலேயே வாழட்டும். அவர்கள் திறமையுள்ள மேய்ப்பர்கள் என்றால் எனது ஆடுமாடுகளையும் பார்த்துக்கொள்ளலாம்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","யோசேப்பு தன் தந்தையைப் பார்வோனைப் பார்ப்பதற்காக அழைத்தான். யாக்கோபு பார்வோனை ஆசீர்வதித்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","பார்வோன் அவனிடம், “உங்களுக்கு எத்தனை வயதாகிறது?” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","“ஏராளமான துன்பங்களோடு மிகக் குறுகிய காலமே வாழ்ந்திருக்கிறேன். என் வயது 130 ஆண்டுகளே. எனது தந்தையும் அவருடைய முற்பிதாக்களும் என்னைவிட அதிகக் காலம் வாழ்திருக்கிறார்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","யாக்கோபு பார்வோனை வாழ்த்தி, அங்கிருந்து புறப்பட்டுச் சென்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","பார்வோன் சொன்னதுபோலவே யோசேப்பு தந்தைக்கும் சகோதரர்களுக்கும் நல்ல நிலத்தை கோசேனில் கொடுத்தான். இது எகிப்திலேயே சிறந்த இடம். இது ராமசேஸ் நகரத்துக்கு அருகில் உள்ளது. ");
INSERT INTO tam2008_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","யோசேப்பு தன் தந்தைக்கும் சகோதரர்களுக்கும் குடும்பத்துக்கும் வேண்டிய உணவுப் பொருட்களையும் கொடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","பஞ்சம் மிகவும் மோசமாகியது. பூமியில் எங்கும் உணவு இல்லை. எகிப்தும் கானானும் இக்காலத்தில் மிகவும் மோசமாகியது. ");
INSERT INTO tam2008_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","ஜனங்கள் நிறைய தானியங்களை விலைக்கு வாங்கினார்கள். யோசேப்பு அச்செல்வத்தைச் சேர்த்து வைத்து பார்வோனின் வீட்டிற்குக் கொண்டு வந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","கொஞ்ச காலத்தில் எகிப்திலும் கானானிலும் உள்ள ஜனங்களிடம் தானியம் வாங்கப் பணம் இல்லை. தம்மிடம் இருந்த பணத்தை ஏற்கெனவே தானியம் வாங்குவதில் செலவழித்திருந்தார்கள். எனவே அவர்கள் யோசேப்பிடம் சென்று, “தயவு செய்து தானியம் கொடுங்கள். எங்கள் பணம் தீர்ந்துவிட்டது. நாங்கள் உணவு உண்ணாவிட்டால் உங்கள் முன்னாலேயே மரித்துவிடுவோம்” என்று வேண்டினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","ஆனால் யோசேப்போ, “உங்கள் ஆடு மாடுகளைக் கொடுங்கள் உணவு தருகிறேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","எனவே ஜனங்கள் தங்கள் ஆடு மாடுகளையும் குதிரைகளையும் மற்ற மிருகங்களையும் உணவுக்காக விற்றனர். யோசேப்பு அவற்றை வாங்கிக்கொண்டு உணவைக் கொடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","ஆனால் அடுத்த ஆண்டு அவர்களிடம் விற்க மிருகங்களும் இல்லை. எனவே, யோசேப்பிடம் ஜனங்கள் போய், “எங்களிடம் உணவு வாங்கப் பணம் இல்லை. எங்களது மிருகங்களோ உங்களிடம் உள்ளது. எங்களிடம் எதுவும் இல்லை. எங்கள் சரீரமும், நிலங்களும் மட்டுமே உள்ளது. ");
INSERT INTO tam2008_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","நீங்கள் பார்க்கும்போதே நாங்கள் மரித்துவிடுவோம். ஆனால் நீங்கள் உணவு கொடுத்தால் பார்வோன் மன்னருக்கு எங்கள் நிலங்களைக் கொடுப்போம். நாங்கள் அவரது அடிமைகளாக இருப்போம். விதை கொடுங்கள் விதைக்கிறோம். பிறகு நாங்கள் மரிக்காமல் உயிர் வாழ்வோம். நிலத்தில் மீண்டும் உணவு விளையும்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","எனவே, யோசேப்பு எகிப்தில் உள்ள எல்லா நிலங்களையும் பார்வோனுக்காக வாங்கிவிட்டான். அனைவரும் தங்கள் நிலங்களை யோசேப்பிடம் விற்றுவிட்டார்கள், அவர்கள் பசியாய் இருந்ததால் இவ்வாறு செய்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","எகிப்திலே, எல்லோரும் பார்வோன் மன்னனின் அடிமைகள் ஆனார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","ஆசாரியர்களுக்கு உரிய நிலத்தை மட்டுமே யோசேப்பு வாங்கவில்லை. அவர்களின் உணவுக்கு ஆசாரியர்கள் தங்கள் நிலத்தை விற்கவேண்டிய தேவை ஏற்படவில்லை. ஏனெனில் மன்னன் தேவையானவற்றைச் சம்பளமாகக் கொடுத்து வந்தான். அதையே உணவு வாங்க வைத்துக்கொண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","யோசேப்பு ஜனங்களிடம், “இப்போது நான் உங்கள் நிலத்தையும் உங்களையும் பார்வோனுக்காக வாங்கிவிட்டேன். எனவே விதை கொடுக்கிறேன். நீங்கள் அந்நிலங்களில் பயிர் செய்யுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","அறுவடைக் காலத்தில், நீங்கள் ஐந்தில் ஒரு பாகம் எங்களுக்குக் கொடுக்க வேண்டும். ஐந்தில் நான்கு பாகம் நீங்கள் வைத்துக்கொள்ளலாம். அதில் விதை வைத்திருந்து அடுத்த ஆண்டுக்குப் பயன்படுத்தலாம். இப்போது உங்கள் குழந்தைகளுக்கும் குடும்பத்துக்கும் உணவு கொடுக்கலாம்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","ஜனங்களோ, “எங்கள் உயிரைக் காப்பாற்றினீர்கள். நாங்கள் பார்வோனுக்கு அடிமையாக இருப்பதில் மகிழ்கிறோம்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","எனவே, யோசேப்பு அப்போது ஒரு சட்டத்தை இயற்றினான். அது இன்றும் உள்ளது. அதன்படி நில வருவாயில் ஐந்தில் ஒரு பாகமானது பார்வோனுக்குரியது. பார்வோனுக்கு எல்லா நிலமும் சொந்தமாக இருக்கும். ஆசாரியர்களின் நிலம் மட்டுமே, பார்வோனுக்குச் சொந்தமாகவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","இஸ்ரவேல் (யாக்கோபு) எகிப்தில் கோசேன் பகுதியில் வாழ்ந்தான். அவனது குடும்பம் வளர்ந்து மிகப் பெரியதாகி அப்பகுதியில் நன்றாக வாழ்ந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","யாக்கோபு எகிப்தில் 17 ஆண்டுகள் வாழ்ந்தான். எனவே அவனுக்கு 147 வயது ஆனது. ");
INSERT INTO tam2008_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","தான் விரைவில் மரித்துப் போவேன் என்று இஸ்ரவேலுக்குத் (யாக்கோபு) தெரிந்தது. அவன் யோசேப்பை அழைத்து அவனிடம்: “நீ என்னை நேசித்தால், உன் கையை என் தொடையின் கீழ் வைத்து ஒரு வாக்குறுதியைச் செய். நான் சொல்வதை நீ செய்யவேண்டும். எனக்கு உண்மையாக இருக்கவேண்டும். நான் மரித்தால் என்னை எகிப்தில் அடக்கம் செய்யவேண்டாம். ");
INSERT INTO tam2008_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","எனது முற்பிதாக்களை அடக்கம் செய்த இடத்திலேயே என்னையும் அடக்கம் செய்துவிடு. இங்கிருந்து கொண்டுபோய் நமது குடும்பக் கல்லறையில் என்னை அடக்கம் செய்” என்றான். யோசேப்பு, “நீர் சொன்னபடியே நான் செய்வேன் என்று வாக்குறுதி செய்கிறேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","பிறகு யாக்கோபு, “எனக்கு வாக்கு கொடு” என்று கேட்டான். யோசேப்பும் அவ்வாறே வாக்குறுதி அளித்தான். பின் இஸ்ரவேல் (யாக்கோபு) படுக்கையில் தன் தலையைச் சாய்த்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","கொஞ்ச காலத்திற்குப் பிறகு, யோசேப்பு தன் தந்தை உடல் நலம் குன்றி இருப்பதை அறிந்தான். ஆகவே அவன் மனாசே மற்றும் எப்பிராயீம் எனும் தன் இரண்டு மகன்களையும் அவனிடம் அழைத்து சென்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","யோசேப்பு போய்ச் சேர்ந்தபோது ஒருவர், “உங்கள் மகன் யோசேப்பு உங்களைப் பார்க்க வந்திருக்கிறார்” என்று யாக்கோபிடம் சொன்னார். அவன் பலவீனமானவராக இருப்பினும் கஷ்டப்பட்டு எழுந்து உட்கார முயன்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","அவன் யோசேப்பிடம், “சர்வ வல்லமையுள்ள தேவன் கானான் நாட்டிலுள்ள லூஸ் என்னுமிடத்தில் என் முன் தோன்றி அங்கே என்னை ஆசீர்வதித்தார். ");
INSERT INTO tam2008_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","தேவன் என்னிடம், ‘உன்னைப் பெரிய குடும்பமாக செய்வேன். நிறைய குழந்தைகளைத் தருவேன். நீங்கள் பெரிய இனமாக வருவீர்கள். உன் குடும்பம் இந்த நிலத்தைச் சொந்தமாக்கிக்கொள்ளும்’ என்றார். ");
INSERT INTO tam2008_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","இப்போது உனக்கு இரண்டு மகன்கள் இருக்கிறார்கள். நான் வருவதற்கு முன்னரே அவர்கள் இந்த எகிப்து நாட்டில் பிறந்திருக்கிறார்கள். உன் பிள்ளைகள் எனது சொந்தப் பிள்ளைகளைப் போன்றவர்கள். அவர்கள் எனக்கு சிமியோனையும் ரூபனையும் போன்றவர்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","எனவே இந்த இருவரும் என் பிள்ளைகள். எனக்குரிய அனைத்தையும் இவர்களுக்குப் பங்கிட்டுத் தருகிறேன். ஆனால் உனக்கு வேறு குழந்தைகள் பிறந்தால் அவர்கள் உன் பிள்ளைகள். ஆனால் அவர்கள் மனாசேக்கும் எப்பிராயீமுக்கும் பிள்ளைகள் போல் இருப்பார்கள். எனவே, வருங்காலத்தில் இவர்களுக்குரியவற்றை அவர்களும் பங்கிட்டுக்கொள்வார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","பதான் அராமிலிருந்து வரும்போது ராகேல் மரித்துப்போனாள். அது என்னை மிகவும் வருத்தத்திற்குள்ளாக்கியது. அவள் கானான் நாட்டிலேயே மரித்தாள். நாங்கள் எப்பிராத்தாவை நோக்கி வந்தோம். சாலையோரத்தில் அவளை அடக்கம் செய்தோம்” என்றான். (எப்பிராத்தா என்பது பெத்லகேமைக் குறிக்கும்.) ");
INSERT INTO tam2008_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","பின் இஸ்ரவேல் யோசேப்பின் பிள்ளைகளைப் பார்த்து, “இவர்கள் யார்?” என்று கேட்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","யோசேப்பு தந்தையிடம், “இவர்கள் என் பிள்ளைகள், எனக்குத் தேவன் கொடுத்த மகன்கள்” என்றான். இஸ்ரவேல் அவனிடம், “என்னிடம் அவர்களை அழைத்து வா, நான் அவர்களை ஆசீர்வதிக்கிறேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","இஸ்ரவேலுக்கு வயதானதால் கண்களும் சரியாகத் தெரியவில்லை. எனவே, யோசேப்பு தன் மகன்களை மிக அருகில் அழைத்து வந்தான். இஸ்ரவேல் அவர்களை முத்தமிட்டு அணைத்துகொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","பிறகு அவன் யோசேப்பிடம், “நான் உனது முகத்தை மீண்டும் பார்ப்பேன் என்று நினைக்கவில்லை. ஆனால் தேவன் உன்னையும் உன் பிள்ளைகளையும் பார்க்கும்படி செய்துவிட்டார்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","பிறகு யோசேப்பு தன் மகன்களை இஸ்ரவேலின் மடியில் இருந்து இறக்கிவிட்டான். அவர்கள் அவரைக் குனிந்து வணங்கினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","யோசேப்பு எப்பிராயீமை தனது வலது பக்கத்திலும் மனாசேயை தனது இடது பக்கத்திலும் அமர வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","ஆனால் இஸ்ரவேல் தனது கைகளைக் குறுக்காக வைத்து வலது கையை இளையவன் மீதும் இடது கையை மூத்தவன் மீதும் வைத்து ஆசீர்வாதம் செய்தான். மனாசே மூத்தவனாக இருப்பினும் அவன் மீது இடது கையை வைத்து ஆசீர்வதித்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","இஸ்ரவேல் யோசேப்பையும் ஆசீர்வதித்தான். அவன், “என் முற்பிதாக்களான ஆபிரகாமும் ஈசாக்கும் நம் தேவனை வழிபட்டனர். அதே தேவன் என் வாழ்க்கை முழுவதும் என்னை வழி நடத்தினார். ");
INSERT INTO tam2008_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","எனது அனைத்து துன்பங்களிலும் என்னைக் காப்பாற்றும் தேவதூதனாக இருந்தார். இந்தப் பிள்ளைகளை ஆசீர்வதிக்கும்படி அந்த தேவனை வேண்டுகிறேன். இப்போது இவர்கள் எனது பெயரையும், எனது முற்பிதாக்களான ஆபிரகாம் மற்றும் ஈசாக்கின் பெயரையும் பெறுவார்கள். இவர்கள் வளர்ந்து மகத்தான குடும்பமாகவும், தேசமாகவும் இப்பூமியில் விளங்கவேண்டும் என்று பிரார்த்திக்கிறேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","யோசேப்பு தன் தந்தை வலது கையை எப்பிராயீம் மீது வைத்திருப்பதைப் பார்த்தான். இது யோசேப்புக்கு மகிழ்ச்சி தரவில்லை. யோசேப்பு தன் தந்தையின் வலது கையை எப்பிராயீம் தலையிலிருந்து எடுத்து மனாசேயின் தலையில் வைக்க விரும்பினான். ");
INSERT INTO tam2008_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","அவன் தன் தந்தையிடம், “உமது வலது கையைத் தவறாக வைத்திருக்கிறீர், மனாசேதான் முதல் மகன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","ஆனால் யாக்கோபோ, “எனக்குத் தெரியும் மகனே! மனாசேதான் மூத்தவன், அவன் பெரியவன் ஆவான். அவனும் ஏராளமான ஜனங்களின் தந்தையாவான். ஆனால் இளையவனே மூத்தவனைவிட பெரியவனாவான். அவனது குடும்பமும் மிகப் பெரியதாக இருக்கும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","இவ்விதமாக இஸ்ரவேல் அன்று அவர்களை ஆசீர்வதித்தான். “இஸ்ரவேலின் ஜனங்கள் உங்கள் பெயரைப் பயன்படுத்தி மற்றவரை வாழ்த்துவார்கள். அவர்கள், ‘எப்பிராயீமும் மனாசேயும்போல தேவன் உங்களை வாழ வைக்கட்டும் என்பார்கள்’” என்றான். இவ்வாறு இஸ்ரவேல் எப்பீராயிமை மனாசேயைவிடப் பெரியவனாக்கினான். ");
INSERT INTO tam2008_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","பிறகு இஸ்ரவேல் யோசேப்பிடம், “பார், நான் மரிப்பதற்குரிய காலம் நெருங்கிவிட்டது. ஆனாலும் தேவன் உன்னோடு இருக்கிறார். அவர் உன்னை உன் முற்பிதாக்களின் பூமிக்கு வழி நடத்திச் செல்வார். ");
INSERT INTO tam2008_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","நான் உன் சகோதரர்களுக்குக் கொடுக்காத சிலவற்றை உனக்குக் கொடுத்திருக்கிறேன். எமோரிய ஜனங்களிடம் இருந்து நான் வென்ற மலையை உனக்குக் கொடுத்திருக்கிறேன். நான் என் பட்டயத்தையும், வில்லையும் பயன்படுத்தி அதை நான் வென்றேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","பின்பு யாக்கோபு தன் அனைத்து பிள்ளைகளையும் அழைத்து, “பிள்ளைகளே! என்னிடம் வாருங்கள். எதிர்காலத்தில் என்ன நடக்கும் என்று சொல்கிறேன். ");
INSERT INTO tam2008_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“சேர்ந்து வாருங்கள், கவனியுங்கள். யாக்கோபின் பிள்ளைகளே. இஸ்ரவேலாகிய உங்கள் தந்தை சொல்வதைக் கேளுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“ரூபனே! என் முதல் மகனே! நீ எனக்கு முதல் பிள்ளை. எனது மனித சக்தியின் முதல் அடையாளம் நீயே. நீயே வல்லமையும் மரியாதையும் உள்ள மகனாக விளங்கியிருக்கலாம். ");
INSERT INTO tam2008_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","ஆனால் உனது உணர்ச்சிகளை வெள்ளம்போல உன்னால் கட்டுப்படுத்த முடியாததாக இருக்கிறது. எனவே நீ மரியாதைக்குரியவனாக இருக்கமாட்டாய். நீ உன் தந்தையின் படுக்கையில் அவர் மனைவிகளுள் ஒருத்தியோடு படுத்தவன். நீ எனது படுக்கைக்கே அவமானம் தேடித் தந்தவன். ");
INSERT INTO tam2008_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“சிமியோனும் லேவியும் சகோதரர்கள். அவர்கள் வாள்களால் சண்டையிடுவதை விரும்புவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","இரகசியமாகப் பாவம் செய்யத் திட்டமிடுவார்கள். அவர்களின் திட்டங்களில் என் ஆத்துமா பங்குகொள்ள விரும்பவில்லை. அவர்களின் இரகசியக் கூட்டங்களை நான் ஏற்றுக்கொள்ளமாட்டேன். கோபமாக இருக்கும்போது மனிதர்களைக் கொல்லுகிறார்கள், மிருகங்களை வேடிக்கைக்காகவே துன்புறுத்துகிறார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","அவர்களின் கோபமே ஒரு சாபம். அது வலிமையானது. அவர்கள் பைத்தியமாகும்போது கொடூரமானவர்களாகிறார்கள். யாக்கோபின் பூமியிலே அவர்கள் சொந்த பூமியைப் பெறமாட்டார்கள். அவர்கள் இஸ்ரவேல் முழுவதும் பரவி வாழ்வார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“உன்னை உன் சகோதரர்கள் போற்றுவார்கள். நீ உன் பகைவர்களை வெல்வாய். உன் சகோதரர்கள் உனக்கு அடிபணிவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","யூதா ஒரு சிங்கத்தைப் போன்றவன். என் மகனே, தான் கொன்ற மிருகத்தின் மேல் நிற்கும் ஒரு சிங்கத்தை போன்றவன் நீ. நீ ஓய்வெடுக்கும்போது உன்னை எவரும் தொந்தரவு செய்யமுடியாது. ");
INSERT INTO tam2008_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","யூதாவின் குடும்பத்தில் வருபவர்கள் அரசர் ஆவார்கள். சமாதான கர்த்தர் வரும்வரை உன்னை விட்டு செங்கோல் நீங்குவதில்லை. ஏராளமான ஜனங்கள் அவனுக்கு அடிபணிந்து சேவை செய்வார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","அவன் தன் கழுதையைத் திராட்சைக் கொடியில் கட்டி வைப்பான். அவன் தன் இளைய கழுதையை சிறந்த திராட்டைக் கொடியில் கட்டி வைப்பான். அவன் சிறந்த திராட்சைரசத்தை ஆடைவெளுக்கப் பயன்படுத்துவான். ");
INSERT INTO tam2008_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","அவன் கண்கள் திராட்சைரசத்தினால் சிவப்பாகும். அவன் பற்கள் பாலால் வெளுக்கும். ");
INSERT INTO tam2008_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“இவன் கடற்கரையில் வசிப்பான். அவனது துறைமுகம் கப்பல்களுக்கு ஏற்றதாக இருக்கும். அவனது எல்லை சீதோன்வரை இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“இசக்கார் ஒரு கழுதையைப்போல கடினமாக உழைப்பான். இரண்டு பொதியின் நடுவே படுத்திருப்பவனைப் போன்றவன். ");
INSERT INTO tam2008_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","தன் ஓய்விடத்தை நன்றாக இருக்கும்படி பார்த்துக்கொள்வான். தன் பூமியை செழிப்பாக வைத்துக்கொள்வான். அடிமையைப்போல வேலை செய்ய சம்மதிப்பான். ");
INSERT INTO tam2008_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“தாண் இஸ்ரவேல் குடும்பத்தில் ஒருவனாக தன் சொந்த ஜனங்களையே நியாயம்தீர்ப்பான். ");
INSERT INTO tam2008_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","இவன் சாலையோரத்தில் அலையும் பாம்பைப் போன்றவன். இவன் பாதையிலேபடுத்திருக்கும் பாம்பைப் போன்று பயங்கரமானவன். இப்பாம்பு ஒரு குதிரையின் காலை கடிக்கிறது, சவாரி செய்தவன் கீழே விழுகிறான். ");
INSERT INTO tam2008_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“கர்த்தாவே நான் உமது இரட்சிப்புக்காகக் காத்திருக்கிறேன். ");
INSERT INTO tam2008_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“ஒரு கொள்ளைக் கூட்டம் காத்தைத் தாக்கும். ஆனால் அவர்களை அவன் துரத்திவிடுவான். ");
INSERT INTO tam2008_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“இவனது நிலம் அதிகமாக விளையும். ஒரு அரசனுக்கு வேண்டிய உணவு பொருட்களைத் தருவான். ");
INSERT INTO tam2008_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“இவன் சுதந்திரமாக ஓடுகிற மானைப் போன்றவன். அவன் வார்த்தைகள் குழந்தைகளைப் போன்று அழகானவைகள்.” ");
INSERT INTO tam2008_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“இவன் வெற்றி பெற்றவன். இவன் பழத்தால் மூடப்பட்ட திராட்சைக்கொடியைப் போன்றவன். நீரூற்றுக்கருகிலும் வேலிக்குள்ளும் இருக்கிற கொடியைப் போன்றவன். ");
INSERT INTO tam2008_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","பலர் அவனுக்கு எதிராகப் போரிடுவார்கள். வில் வீரர்களே அவன் பகைவர். ");
INSERT INTO tam2008_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ஆனால் அவன் பலம் வாய்ந்த வில்லாலும் திறமையான கைகளாலும் சண்டையில் வென்றான். அவன் யாக்கோபின் வல்லவரும், மேய்ப்பரும், இஸ்ரவேலின் பாறையும் ஆனவரிடமிருந்தும் உன் பிதாவின் தேவனிடமிருந்தும் வலிமை பெற்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","தேவன் உன்னை ஆசீர்வதிக்கிறார். சர்வ வல்லமையுள்ள தேவன் வானத்திலிருந்தும், கீழே ஆழத்திலிருந்தும் உன்னை ஆசீர்வதிக்கட்டும். ஸ்தனங்களுக்கும், கர்ப்பங்களுக்குமுரிய ஆசிகளை அவர் உனக்கு வழங்கட்டும். ");
INSERT INTO tam2008_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","எனது பெற்றோர்களுக்கு எவ்வளவோ நன்னமைகள் ஏற்பட்டன எனினும் எனது ஆசீர்வாதங்கள் அவற்றைவிட மேலானது. உனது சகோதரர்கள் உன்னை எதுவுமில்லாமல் விட்டுவிட்டுப் போனார்கள். ஆனால், இப்போது எனது ஆசீர்வாதங்களையெல்லாம் மலையின் உயரம்போல் கூட்டித் தருகிறேன். ");
INSERT INTO tam2008_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“பென்யமீன் ஒரு பசித்த நரி போன்றவன். காலையில் கொன்று தின்பான். மாலையில் மிஞ்சியதைப் பகிர்ந்துகொள்வான்.” ");
INSERT INTO tam2008_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","இவர்கள் அனைவரும் இஸ்ரவேலின் 12 குடும்பத்தினர். இவ்வாறு யாக்கோபு அவர்கள் ஒவ்வொரு வருக்கும் அவரவருக்குப் பொருத்தமான ஆசீர்வாதங்களைக் கொடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","பின் இஸ்ரவேல் ஒரு ஆணையிட்டான். “நான் மரிக்கும்போது என் ஜனங்களோடு இருக்க விரும்புகிறேன். என் முற்பிதாக்களோடு நான் அடக்கம் செய்யப்பட வேண்டும். அந்தக் கல்லறை ஏத்தியரிடம் வாங்கிய எப்பெரோனில் உள்ளது. ");
INSERT INTO tam2008_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","அந்தக் குகை மம்ரேக்கு அருகில் மக்பேலா எனும் இடத்தில் வயலில் உள்ளது. இது கானான் நாட்டில் உள்ளது. இதனை ஆபிரகாம் எப்ரோனிடமிருந்து விலைக்கு வாங்கி கல்லறையாக மாற்றிவிட்டார். ");
INSERT INTO tam2008_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","ஆபிரகாமும் அவன் மனைவி சாராளும் அதே குகையில் அடக்கம் செய்யப்பட்டனர். ஈசாக்கும் அவர் மனைவி ரெபெக்காளும் அதே குகையில் அடக்கம் செய்யப்பட்டனர். நான் என் மனைவி லேயாளையும் அதே குகையில் அடக்கம் பண்ணினேன். ");
INSERT INTO tam2008_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","அந்தக் குகை இருக்கும் நிலம் ஏத்தின் மகன்களிடமிருந்து வாங்கப்பட்டது” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","யாக்கோபு பேசி முடித்ததும் படுத்தான். கால்களைக் கட்டிலின்மேல் மடக்கியபடியே மரணமடைந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","இஸ்ரவேல் மரித்ததும் யோசேப்பு மிகவும் துக்கப்பட்டான். அவன் தன் தந்தையைக் கட்டிப் பிடித்துக்கொண்டு அழுது முத்தமிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","பிறகு யோசேப்பு தன் வேலைக்காரர்களுக்கு அவனது தந்தையின் உடலை அடக்கத்திற்கு தயார் செய்யும்படி ஆணையிட்டான். (அவர்கள் அனைவரும் மருத்துவர்கள்.) அடக்கம் செய்வதற்கு ஏற்ற முறையில் அதனைத் தயார்படுத்தினர். எகிப்திய முறையில் அவ்வாறு செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","சரியான முறையில் தயார் செய்ய 40 நாட்கள் ஆகும். அந்தபடியே அந்த நாட்கள் நிறைவேறின. எகிப்தியர்கள் அவனுக்காக 70 நாட்கள் துக்கம் கொண்டாடினர். ");
INSERT INTO tam2008_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","70 நாட்கள் ஆனதும் துக்க நாட்கள் முடிந்தன. எனவே யோசேப்பு பார்வோன் மன்னனின் அதிகாரிகளோடு பேசினான். “இதனைப் பார்வோன் மன்னனுக்குச் சொல்லுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘என் தந்தை மரணத்தை நெருங்கும்போது அவருக்கு நான் ஒரு வாக்குக் கொடுத்தேன். அவரைக் கானான் நாட்டில் ஓரிடத்தில் அடக்கம் செய்வதாக ஒப்புக்கொண்டேன். அதுவே அவர் விரும்பிய குகை. எனவே, நான் போய் அவரை அடக்கம் செய்ய எனக்கு அனுமதி வேண்டும். பின்னர் நான் உங்களிடம் திரும்பி வருவேன்’” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","பார்வோனும், “உன் வாக்கைக் காப்பாற்று. போய் உன் தந்தையை அடக்கம் செய்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","எனவே யோசேப்பு அடக்கம் செய்யக் கிளம்பினான். பார்வோனின் மூப்பர்களும் (தலைவர்களும்) எகிப்திலுள்ள முதியவர்களும் யோசேப்போடு சென்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","யோசேப்பின் குடும்பத்தினரும், அவனது சகோதரர்களின் குடும்பத்ததினரும் தந்தையின் குடும்பத்தினரும் அவனோடு சென்றார்கள். குழந்தைகளும் மிருகங்களும் மட்டுமே கோசேன் பகுதியில் தங்கினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","அவர்கள் பெருங்கூட்டமாகப் போனார்கள். வீரர்களும் இரதங்களிலும் குதிரைகளிலும் ஏறிப் போனார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","அவர்கள் கோரான் ஆத்தாத் நதியின் கீழ்க்கரையில் உள்ள கோசேன் ஆத்தாதிற்கு வந்தனர். அங்கே இஸ்ரவேலுக்கு இறுதிச் சடங்குகளையெல்லாம் செய்தனர். இது ஏழு நாட்கள் நடந்தது. ");
INSERT INTO tam2008_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","கானான் நாட்டிலுள்ள ஜனங்களெல்லாம் இந்தச் சடங்கில் கலந்துகொண்டனர். அவர்களோ, “அந்த எகிப்தியர்கள் பெரிய துக்கமான சடங்கைக் கொண்டுள்ளனர்” என்றனர். இப்போது அந்த இடத்திற்கு ஆபேல்மிஸ்ராயீம் என்று பெயர் வழங்குகிறது. ");
INSERT INTO tam2008_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","யாக்கோபின் மகன்கள் தந்தை சொன்னபடியே செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","அவர்கள் அவனது உடலை கானானுக்குள் எடுத்துச் சென்று மக்பேலாவில் அடக்கம் செய்தனர். இந்தக் குகை ஆபிரகாம் ஏத்தின் ஜனங்களிடமிருந்து வாங்கிய நிலத்தில் மம்ரேக்கு அருகில் இருந்தது. ஆபிரகாம் இதனைக் கல்லறைக்காகவே வாங்கியிருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","யோசேப்பு தன் தந்தையை அடக்கம் செய்த பிறகு, அவனோடு அனைவரும்Ԕ எகிப்துக்குத் திரும்பிப் போனார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","யாக்கோபு மரித்தபிறகு யோசேப்பின் சகோதரர்கள் மிகவும் கவலைப்பட்டனர். அவர்கள் பயந்தார்கள். அவர்கள் யோசேப்புக்கு தாங்கள் செய்த தீமையை எண்ணிப் பயந்தனர். “நாம் யோசேப்பிற்குச் செய்த தீமைக்காக அவன் இப்போது நம்மை வெறுக்கலாம். நம் தீமைகளுக்கெல்லாம் அவன் பழி தீர்க்கலாம்” என்று அவர்கள் பேசிக்கொண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","எனவே அவனது சகோதரர்கள் அவனுக்குக் கீழ்க்கண்ட செய்தியை அனுப்பினர்: “தந்தை மரிப்பதற்கு முன்னால் உனக்கு ஒரு செய்தி சொல்லும்படி சொன்னார். ");
INSERT INTO tam2008_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","அவர், ‘யோசேப்புக்கு நீங்கள் முன்பு செய்த தீமையை மன்னிக்கும்படி கேட்டுக்கொள்ளுங்கள்’ என்றார். எனவே நாங்கள் உன்னைக் கெஞ்சிக் கேட்டுக்கொள்கிறோம். நாங்கள் உனக்குச் செய்த தீமைக்கு எங்களை மன்னித்துவிடு. நாங்கள் தேவனின் அடிமைகள். அவர் உனது தந்தைக்கும் தேவன்” என்றனர். இந்தச் செய்தி யோசேப்பை மிகவும் துக்கப்படுத்தியது. அவன் அழுதான். ");
INSERT INTO tam2008_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","அவனது சகோதரர்கள் அவனிடம் சென்று பணிந்து வணங்கினார்கள். “நாங்கள் உன் வேலைக்காரர்கள்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","பிறகு யோசேப்பு, “பயப்படவேண்டாம், நான் தேவன் அல்ல. உங்களைத் தண்டிக்க எனக்கு உரிமையில்லை. ");
INSERT INTO tam2008_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","எனக்குக் கேடு செய்ய நீங்கள் திட்டம்போட்டீர்கள் என்பது உண்மை. ஆனால் உண்மையில் தேவன் நன்மைக்குத் திட்டமிட்டிருக்கிறார். நான் பலரது உயிரைக் காப்பாற்ற வேண்டும் என்பது தேவனின் திட்டம். இன்னும் அவரது திட்டம் அதுதான். ");
INSERT INTO tam2008_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","எனவே அஞ்ச வேண்டாம். நான் உங்களையும் உங்கள் பிள்ளைகளையும் பொறுப்பேற்றுக்கொள்வேன்” என்றான். இவ்வாறு யோசேப்பு தன் சகோதரர்களுக்கு இனிமையாகப் பதில் சொன்னான். இதனால் அவர்கள் மகிழ்ச்சி அடைந்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","யோசேப்பு தொடர்ந்து எகிப்தில் தன் தந்தையின் குடும்பத்தோடு வாழ்ந்தான். அவனுக்கு 110 வயதானபோது மரணமடைந்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","யோசேப்பு உயிரோடு இருக்கும்போதே எப்பிராயீமுக்குப் பிள்ளைகளும் பேரப்பிள்ளைகளும் இருந்தனர். மனாசேக்கு மாகீர் என்ற மகன் இருந்தான். மாகீரின் பிள்ளைகளையும் யோசேப்பு பார்த்தான். ");
INSERT INTO tam2008_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","மரணம் நெருங்கியதும் யோசேப்பு தன் சகோதரர்களிடம், “எனது மரண நேரம் நெருங்கிவிட்டது. தேவன் உங்களை கவனித்துக்கொள்வார் என்பதை நான் அறிவேன். உங்களை இந்த நாட்டிலிருந்து வெளியே அழைத்துச் செல்வார். ஆபிரகாம், ஈசாக்கு, யாக்கோபு ஆகியோருக்கு தேவன் கொடுப்பதாகச் சொன்ன நாடுகளை உங்களுக்குக் கொடுப்பார்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","பின் யோசேப்பு இஸ்ரவேல் ஜனங்களிடம் ஒரு வாக்குறுதிச் செய்தான். அவன், “நான் மரித்த பிறகு என் எலும்புகளை எடுத்துக்கொள்ளுங்கள். நீங்கள் தேவனால் வழி நடத்தப்பட்டு புதிய பூமிக்குப் போகும்போது அதையும் கொண்டு செல்லுங்கள்” இதைப்பற்றி வாக்குறுதி செய்யுங்கள் என்றான். ");
INSERT INTO tam2008_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","யோசேப்பு எகிப்திலேயே மரணமடைந்தான். அப்போது அவனுக்கு 110 வயது. மருத்துவர்கள் அவனது உடலை அடக்கம் செய்வதற்காகத் தயார் செய்தனர். அதனை ஒரு பெட்டியில் வைத்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","யாக்கோபு (இஸ்ரவேல்) தன் மகன்களோடு எகிப்திற்குப் பயணமானான். ஒவ்வொரு மகனும் தன் குடும்பத்தோடே சென்றான். பின்வருபவர்களே இஸ்ரவேலின் மகன்கள்: ");
INSERT INTO tam2008_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","ரூபன், சிமியோன், லேவி, யூதா, ");
INSERT INTO tam2008_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","இசக்கார், செபுலோன், பென்யமீன், ");
INSERT INTO tam2008_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","தாண், நப்தலி, காத், ஆசேர். ");
INSERT INTO tam2008_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","70 பேர் யாக்கோபின் நேரடி சந்ததியாகப் பிறந்தவர்களாக இருந்தனர். (யோசேப்பு 12 மகன்களில் ஒருவன். ஆனால் அவன் ஏற்கெனவே எகிப்தில் இருந்தான்.) ");
INSERT INTO tam2008_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","பின்னர், யோசேப்பும் அவனது சகோதரர்களும் அத்தலைமுறையைச் சேர்ந்த எல்லோருமே மரித்துவிட்டார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ஆனால் இஸ்ரவேலின் ஜனங்களுக்குப் பல குழந்தைகள் இருந்தனர். அவர்களின் எண்ணிக்கை பெருகிக்கொண்டேயிருந்தது. இஸ்ரவேலின் ஜனங்கள் வலிமையுடையோரானார்கள். எகிப்து நாடும் இஸ்ரவேலரால் நிரம்பிற்று. ");
INSERT INTO tam2008_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","அப்போது யோசேப்பை அறிந்திராத ஒரு புதிய அரசன் எகிப்தை அரசாள ஆரம்பித்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","இந்த அரசன் தம் ஜனங்களை நோக்கி, “இஸ்ரவேலின் ஜனங்களைப் பாருங்கள்! அவர்கள் மிக அதிகமாயிருக்கிறார்கள்! நம்மைக் காட்டிலும் அவர்கள் பலம்மிக்கவர்கள்! ");
INSERT INTO tam2008_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","இஸ்ரவேலர் பலம் பொருந்தியவர்களாய் வளர்ந்துகொண்டிருப்பதைத் தடை செய்ய நாம் திட்டங்கள் வகுக்க வேண்டும். போர் ஏற்படுமானால், இஸ்ரவேலர் நமது பகைவரோடு சேர்ந்துகொள்வதுடன், நம்மைத் தோற்கடித்து, நம்மிடமிருந்து தப்பித்துக்கொள்ளக்கூடும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","இஸ்ரவேல் ஜனங்களின் வாழ்க்கையைச் சிரமமாக்குவதென எகிப்திய ஜனங்கள் முடிவெடுத்து, அவர்களிடையே மேற் பார்வையாளர்களை எகிப்தியர் நியமித்தார்கள். இந்த மேற்பார்வையாளர்கள் பித்தோம், ராமசேஸ் நகரங்களை அரசனுக்காகக்கட்டும்படியாக இஸ்ரவேலரைக் கட்டாயப்படுத்தினர். தானியங்களையும் பிற பொருட்களையும் சேர்த்து வைப்பதற்காக அரசன் இந்நகரங்களைப் பயன்படுத்தினான். ");
INSERT INTO tam2008_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","மிகக் கடினமாக உழைக்கும்படியாக எகிப்தியர்கள் இஸ்ரவேலரை வற்புறுத்தினார்கள். எந்த அளவுக்கு இஸ்ரவேல் ஜனங்களை வேலை செய்யும்பொருட்டு கட்டாயப்படுத்தினார்களோ, அந்த அளவுக்கு அவர்கள் மிகுதியாகப் பெருகிப் பரவினார்கள். இஸ்ரவேல் ஜனங்களைக் கண்டு எகிப்திய ஜனங்கள் அதிக பயமடைந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","எனவே, எகிப்தியர்கள் இஸ்ரவேலரை இன்னும் கடினமாக உழைக்கும்படியாகக் கட்டாயப்படுத்தினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","இஸ்ரவேலரின் வாழ்க்கையை எகிப்தியர்கள் கடினமாக்கினார்கள். செங்கல்லும், சாந்தும் செய்யும்படியாக இஸ்ரவேலரை அவர்கள் வற்புறுத்தி வேலை வாங்கினார்கள். வயல்களிலும் கடினமாக உழைக்கும்படியாக அவர்களைக் கட்டாயப்படுத்தினர். அவர்கள் செய்த ஒவ்வொரு வேலையிலும் கடினமாக உழைக்குமாறு, கட்டாயப்படுத்தினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","இஸ்ரவேல் பெண்கள் குழந்தை பெறுவதற்கு உதவ சிப்பிராள், பூவாள் என்ற இரண்டு எபிரெய மருத்துவச்சிகள் இருந்தனர். எகிப்தின் அரசன் மருத்துவச்சிகளிடம் பேசி, ");
INSERT INTO tam2008_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“எபிரெயப் பெண்களின் பிரசவத்திற்கு நீங்கள் இருவரும் தொடர்ந்து உதவுங்கள். பெண் குழந்தை பிறந்தால், அக்குழந்தை உயிரோடிருக்கட்டும். குழந்தை ஆணாக இருந்தால், நீங்கள் அதைக் கொன்றுவிட வேண்டும்!” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","ஆனால் மருத்துவச்சிகள் தேவனுக்குப் பயப்படுகிறவர்களானதால் அவர்கள் அரசனின் கட்டளைக்குக் கீழ்ப்படியவில்லை. அவர்கள் எல்லா ஆண் குழந்தைகளையும் உயிரோடு விட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","எகிப்திய அரசன் மருத்துவச்சிகளை அழைத்து, “நீங்கள் ஏன் இதைச் செய்தீர்கள்? ஆண் குழந்தைகளை ஏன் உயிரோடு விடுகிறீர்கள்?” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","மருத்துவச்சிகள் அரசனை நோக்கி, “எபிரெயப் பெண்கள் எகிப்தியப் பெண்களைக் காட்டிலும் வலிமையானவர்கள். நாங்கள் உதவுவதற்குப் போகும் முன்னரே அவர்களுக்குக் குழந்தை பிறந்துவிடுகின்றது” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","தேவன் மருத்துவச்சிகளின்மேல் மகிழ்ச்சி அடைந்து அவர்களுக்கு நன்மை செய்தார். அவர்கள் தங்கள் குடும்பங்களுடன் செழிப்படையச் செய்தார். எபிரெய ஜனங்கள் தொடர்ந்து பல குழந்தைகளைப் பெற்றெடுத்து, வலிமை மிகுந்தோர் ஆயினர். ");
INSERT INTO tam2008_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","எனவே பார்வோன், தனது சொந்த ஜனங்களிடம், “எபிரெயரின் எல்லாப் பெண் குழந்தைகளும் உயிரோடிருக்கட்டும், ஆனால் ஒவ்வொரு ஆண் குழந்தை பிறக்கும்போதும், அதனை நைல் நதியில் வீசிவிட வேண்டும்” என்று ஆணையிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","லேவியின் குடும்பத்தைச் சேர்ந்த ஒரு மனிதன் லேவியின் குடும்பத்திலிருந்த ஒரு பெண்ணை மணந்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","அப்பெண் கருவுற்று ஒரு ஆண் குழந்தையைப் பெற்றெடுத்தாள். தாய் அக்குழந்தையின் அழகைக் கண்டு அதை மூன்று மாதங்கள் மறைத்து வைத்தாள். ");
INSERT INTO tam2008_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","அது ஆணாக இருந்ததால், அக்குழந்தை கண்டுபிடிக்கப்பட்டு கொல்லப்படுமோ என்று தாய் பயந்தாள். மூன்று மாதங்களுக்குப் பிறகு அவள் ஒரு கூடையைச் செய்து, அது மிதக்கும்படியாக கீல் பூசி, குழந்தையை அக்கூடையில் வைத்து, நதியில் உயரமான புற்களிடையே கூடையை மிதக்கவிட்டாள். ");
INSERT INTO tam2008_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","குழந்தையின் சகோதரி அங்கு நின்று நடப்பதைக் கவனித்தாள். குழந்தைக்கு நிகழப்போவதைப் பார்க்க விரும்பினாள். ");
INSERT INTO tam2008_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","அப்போதுதான் பார்வோனின் மகள் குளிப்பதற்காக நதிக்கு வந்தாள். உயர்ந்த புற்களிடையே இருந்த கூடையை அவள் கண்டாள். நதியருகே அவளது வேலைக்காரிகள் நடந்துகொண்டிருந்தனர். அவர்களில் ஒருவரிடம் கூடையை எடுத்து வருமாறு அவள் கூறினாள். ");
INSERT INTO tam2008_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","அரசனின் மகள் கூடையைத் திறந்து அதில் ஒரு ஆண் குழந்தையைக் கண்டாள். அக்குழந்தை அழுதுகொண்டிருந்தது. அவள் அதற்காக மனமிரங்கினாள். அது எபிரெயக் குழந்தைகளில் ஒன்று என்பதை அவள் அறிந்தாள். ");
INSERT INTO tam2008_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","அங்கே நின்றுகொண்டிருந்த குழந்தையின் சகோதரி அரசனின் மகளை நோக்கி, “நான் போய் குழந்தைக்குப் பாலூட்டுவதற்கும், அதைக் கவனித்துக்கொள்வதற்கும் ஒரு எபிரெயப் பெண்ணை அழைத்து வரட்டுமா?” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","அரசனின் மகளும், “தயவு செய்து அவ்வாறே செய்” என்றாள். எனவே அப்பெண் சென்று, குழந்தையின் தாயையே அழைத்து வந்தாள். ");
INSERT INTO tam2008_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","அரசனின் மகள் அத்தாயை நோக்கி, “குழந்தையை எடுத்து எனக்காக அதற்குப் பாலூட்டு. அவனைக் கவனித்துக்கொள்வதற்காக உனக்குப் பணம் கொடுப்பேன்” என்றாள். எனவே, அப்பெண் குழந்தையை எடுத்துச் சென்று, அதனை வளர்த்தாள். ");
INSERT INTO tam2008_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","குழந்தை வளர்ந்தது. சில காலத்திற்குப் பிறகு, அவள் அக்குழந்தையை அரசனின் மகளிடம் கொடுத்தாள். அரசனின் மகள் குழந்தையைத் தன் சொந்த மகனாகவே ஏற்றுக்கொண்டாள். அக்குழந்தையை தண்ணீரிலிருந்து எடுத்ததால் அவனுக்கு மோசே என்று பெயரிட்டாள். ");
INSERT INTO tam2008_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","மோசே வளர்ந்து, பெரியவனானான். அவனது சொந்த ஜனங்களாகிய எபிரெயர்கள் கடினமாக உழைப்பதற்கு வற்புறுத்தப்படுவதைக் கண்டான். ஒரு நாள் ஒரு எபிரெய மனிதனை, எகிப்திய மனிதன் ஒருவன் அடித்துக்கொண்டிருப்பதைக் கண்டான். ");
INSERT INTO tam2008_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","மோசே சுற்றிலும் நோக்கி, யாரும் தன்னைக் கவனிக்கவில்லை என்பதைக் கண்டான். பின் மோசே, எகிப்தியனைக் கொன்று, அவனை மண்ணில் புதைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","மறுநாள் இரண்டு எபிரெய மனிதர்கள் ஒருவரோடொருவர் சண்டையிட்டுக்கொண்டிருப்பதையும், அவர்களில் ஒருவன் செய்தது தவறாயிருப்பதையும் மோசே பார்த்தான். மோசே அம்மனிதனை நோக்கி, “நீ ஏன் உனது அயலானை அடிக்கிறாய்?” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","அம்மனிதன் அதற்குப் பதிலாக, “எங்களுக்கு அதிகாரியாகவும், நியாயாதிபதியாகவும் இருக்கும்படியாக உன்னிடம் யாராவது கூறினார்களா? நீ எகிப்தியனை நேற்று கொன்றதுபோல என்னையும் கொல்லப் போகிறாயா?” என்றான். இதைக் கேட்டு மோசே அஞ்சினான். மோசே தனக்குள், “நான் செய்ததை எல்லோரும் இப்போது அறிந்திருக்கிறார்கள்” என்று நினைத்துக்கொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","மோசே செய்ததைக் குறித்து பார்வோன் கேள்விப்பட்டு, அவன் மோசேயைக் கொல்ல முடிவு செய்தான். ஆனால் பார்வோனிடமிருந்து மோசே தப்பி ஓடி, மீதியான் தேசத்திற்குச் சென்றான். மீதியானின் ஒரு கிணற்றருகே மோசே நின்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","ஏழு பெண்களைப் பெற்ற ஒரு ஆசாரியன் மீதியானில் இருந்தான். அப் பெண்கள் வந்து தம்முடைய தந்தையின் ஆடுகளுக்கு தண்ணீர் காட்டும்படிக்கு கிணற்றில் இருந்து தண்ணீர் இறைத்து தொட்டிகளை நிரப்பிக்கொண்டிருந்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","ஆனால் அங்கிருந்த சில மேய்ப்பர்கள் அப்பெண்களைத் துரத்தி, அவர்கள் தண்ணீர் இறைக்க முடியாதபடி செய்தனர். மோசே அப்பெண்களுக்கு உதவி, அவர்களின் ஆடுகளுக்கு தண்ணீர் கொடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","பின் அப்பெண்கள் தங்கள் தந்தையாகிய ரெகுவேலிடம் சென்றனர். அவர்கள் தந்தை அவர்களிடம், “இன்று சீக்கிரமாக வந்துவிட்டீர்களே!” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","அப்பெண்கள், “மேய்ப்பர்கள் எங்களைத் துரத்திவிட முயன்றதால் ஒரு எகிப்திய மனிதன் எங்களுக்கு உதவினான். அவன் எங்களுக்கும் எங்கள் ஆடுகளுக்கும் தண்ணீர் கொடுத்தான்” என்று பதில் சொன்னார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","எனவே, ரெகுவேல் அவனது பெண்களை நோக்கி, “அம்மனிதன் எங்கே? ஏன் அவனை விட்டு வந்தீர்கள்? அவனை அழையுங்கள், அவன் நம்மோடு சாப்பிடட்டும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","மோசே அம்மனிதனோடு தங்குவதில் மகிழ்ச்சியடைந்தான். ரெகுவேல், தனது மகளாகிய சிப்போராளை மோசேக்குத் திருமணம் செய்து வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","சிப்போராள் கர்ப்பவதியாகி, ஒரு மகனைப் பெற்றெடுத்தாள். மோசே அவனுக்குக் கெர்சோம் என்று பேரிட்டான். தனக்குச் சொந்தமில்லாத நாட்டில் அந்நியனாக இருந்தமையால் மோசே அவனுக்கு இப்பெயரை வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","நீண்டகாலம் கழிந்தது. எகிப்தின் மன்னன் மரித்தான். ஆனால் இஸ்ரவேல் ஜனங்களோ கடினமாக உழைப்பதற்கு தொடர்ந்து வற்புறுத்தப்பட்டனர். உதவிக்காக அவர்கள் அழுதார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","தேவன் அவர்கள் ஜெபத்தைக் கேட்டார். ஆபிரகாம், ஈசாக்கு, யாக்கோபு ஆகியோரோடு செய்த உடன்படிக்கையை அவர் நினைவுகூர்ந்தார். ");
INSERT INTO tam2008_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","இஸ்ரவேல் ஜனங்கள் அடைந்த துயரங்களைத் தேவன் கண்டார். விரைவில் அவர்களுக்கு உதவ வேண்டும் என்பதை தீர்மானித்தார். ");
INSERT INTO tam2008_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","மோசேயின் மாமன் எத்திரோ என்ற பெயருடையவன் ஆவான். (எத்திரோ மீதியானில் ஆசாரியனாக இருந்தான்) எத்திரோவின் ஆடுகளை மோசே கவனித்து வந்தான். ஒரு நாள், மோசே ஆடுகளைப் பாலைவனத்தின் மேற்குத் திசைக்கு அழைத்துச் சென்றான். மோசே ஓரேப் (சீனாய்) எனப்படும் தேவனின் மலைக்குப் போனான். ");
INSERT INTO tam2008_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","மோசே மலையின்மேல், ஒரு எரியும் புதரில் கர்த்தருடைய தூதனைக் கண்டான். அது பின்வருமாறு நிகழ்ந்தது: அழியாதபடி எரிந்துகொண்டிருந்த ஒரு புதரை மோசே கண்டான். ");
INSERT INTO tam2008_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","மோசே புதரின் அருகே சென்று, அழியாதபடி அது எவ்வாறு எரிகிறது என்பதைப் பார்ப்பதற்குத் தீர்மானித்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","புதரைப் பார்ப்பதற்கு மோசே வந்துகொண்டிருப்பதைக் கர்த்தர் கண்டார். எனவே, தேவன் புதரிலிருந்து, “மோசே, மோசே!” என்று கூப்பிட்டார். மோசே, “நான் இங்கே இருக்கிறேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","அப்போது கர்த்தர், “பக்கத்தில் நெருங்காதே. உனது செருப்புகளைக் கழற்று. நீ பரிசுத்த பூமியில் நின்று கொண்டிருக்கிறாய். ");
INSERT INTO tam2008_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","நான் உனது முற்பி தாக்களின் தேவன். நான் ஆபிரகாமின் தேவனும், ஈசாக்கின் தேவனும், யாக்கோபின் தேவனாகவும் இருக்கிறேன்” என்றார். தேவனைப் பார்ப்பதற்குப் பயந்ததால் மோசே முகத்தை மூடிக்கொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","அப்போது கர்த்தர், “எகிப்தில் என் ஜனங்கள் படுகின்ற தொல்லைகளை நான் கண்டேன். எகிப்தியர்கள் அவர்களைத் துன்புறுத்தும்போது, அவர்களிடும் கூக் குரலை நான் கேட்டேன். அவர்கள் படும் வேதனையை நான் அறிவேன். ");
INSERT INTO tam2008_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","நான் இப்போது இறங்கிப்போய், எகிப்தியரிடமிருந்து என் ஜனங்களை மீட்பேன். அந்நாட்டிலிருந்து தொல்லைகளில்லாமல் சுதந்திரமாக வாழத்தக்க ஒரு நல்ல நாட்டிற்கு அவர்களை அழைத்துச் செல்வேன். அந்நாடு நல்ல பொருட்களால் நிரம்பியதாகும். கானானியர், ஏத்தியர், எமோரியர், பெரிசியர், ஏவியர், எபூசியர் போன்ற ஜனங்கள் அந்நாட்டில் வாழ்கிறார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","நான் இஸ்ரவேல் ஜனங்களின் கூக் குரலைக் கேட்டேன். எகிப்தியர்கள் அவர்கள் வாழ்க்கையைக் கடினமாக்கியதையும் கண்டேன். ");
INSERT INTO tam2008_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","நான், உன்னை இப்போது பார்வோனிடம் அனுப்புகிறேன். நீ போய் எனது ஜனங்களாகிய இஸ்ரவேலரை எகிப்திலிருந்து வெளியே வழிநடத்து!” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","ஆனால் மோசே தேவனிடம், “நான் பெரிய மனிதன் அல்ல, நான் எவ்வாறு பார்வோனிடம் போய், இஸ்ரவேல் ஜனங்களை எகிப்திலிருந்து வெளியே வழிநடத்தக் கூடும்?” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","தேவன், “நான் உன்னோடு இருப்பேன். எனவே நீ இதைச் செய்ய முடியும். நான் உன்னை அனுப்புகிறேன் என்பதற்கு இதுவே சான்றாகும்! ஜனங்களை எகிப்திலிருந்து வழிநடத்திய பிறகு, நீ வந்து இம்மலையின் மேல் என்னைத் தொழுவாய்!” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","அப்போது மோசே தேவனை நோக்கி, “நான் இஸ்ரவேல் ஜனங்களிடம் சென்று, ‘உங்கள் முற்பிதாக்களின் தேவன் என்னை அனுப்பினார்’ என்று கூறினால், அவர்கள், ‘அவரது பெயரென்ன?’ என்று கேட்டால், நான் என்ன சொல்லட்டும்?” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","அப்போது தேவன் மோசேயை நோக்கி, “அவர்களிடம் ‘இருக்கிறவராக இருக்கிறேன்’ என்று கூற வேண்டும். இஸ்ரவேல் ஜனங்களிடம் நீ போகும்போது, ‘இருக்கிறேன்’ என்பவர் என்னை உங்களிடம் அனுப்பினார், என்று சொன்னார் என்று சொல்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","மோசேயிடம் தேவன் மீண்டும், “இஸ்ரவேலர்களிடம், நீ சொல்ல வேண்டியது இதுதான்: ‘உங்களுடைய முற்பிதாக்களின் தேவனும், ஆபிரகாமின் தேவனும், ஈசாக்கின் தேவனும், யாக்கோபின் தேவனுமானவர் யேகோவா என்பவர் ஆவார். என் பெயரும் எப்பொழுதும் யேகோவா ஆகும். அப்பெயரில்தான் தலைமுறை தலைமுறையாக ஜனங்கள் என்னை அறிவார்கள். யேகோவா என்னை உங்களிடம் அனுப்பினார்’ என்று ஜனங்களிடம் சொல்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","மேலும் கர்த்தர், “போய் ஜனங்களின் மூப்பர்களை (தலைவர்களை) ஒருமித்துக் கூடி வரச் செய்து அவர்களுக்கு, ‘உங்கள் முற்பிதாக்களின் தேவனாகிய யேகோவா, எனக்குத் தரிசனமளித்தார். ஆபிரகாம், ஈசாக்கு, யாக்கோபு, ஆகியோரின் தேவன் என்னிடம் பேசினார். கர்த்தர், நான் உங்களை நினைவுகூர்ந்து, எகிப்தில் உங்களுக்கு நடந்ததையும் கண்டேன். ");
INSERT INTO tam2008_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","எகிப்தில் நீங்கள் அனுபவிக்கும் துன்பங்களிலிருந்து உங்களை விடுவிக்க முடிவு செய்தேன். இப்போது கானானியர், ஏத்தியர், எமோரியர், பெரிசியர், ஏவியர், எபூசியர் போன்ற வெவ்வேறு ஜனங்களுக்குச் சொந்தமான தேசத்திற்கு உங்களை அழைத்துச் செல்வேன். பல நல்ல பொருட்களால் நிரம்பிய தேசத்திற்கு உங்களை வழிநடத்துவேன்’ என்று சொன்னார்” என்று சொல். ");
INSERT INTO tam2008_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“மூப்பர்கள் (தலைவர்கள்) உனக்குச் செவி கொடுப்பார்கள். பின்னர் நீயும், அவர்களும் எகிப்திய அரசனிடம் செல்லுங்கள். நீ அரசனிடம், ‘எபிரெய ஜனங்களின் தேவனாகிய யேகோவா எங்களிடம் பாலைவனத்தில் மூன்று நாட்கள் பயணப்படும்படியாகக் கூறினார். எங்கள் தேவனாகிய யேகோவாவுக்கு நாங்கள் அங்கு பலி செலுத்தவேண்டும்’ என்று சொல்லுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","“ஆனால் எகிப்திய அரசன் உங்களைப் போக அனுமதிக்கமாட்டான் என்பதை அறிவேன். மிகப் பெரிய ஒரு வல்லமை மட்டுமே உங்களை அனுப்ப அவனைக் கட்டாயப்படுத்தும். ");
INSERT INTO tam2008_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","ஆகையால் எனது மிகுந்த வல்லமையை எகிப்துக்கு எதிராகப் பயன்படுத்துவேன். அந்த தேசத்தில் வியக்கும்படியான காரியங்கள் நிகழும்படி செய்வேன். நான் இதைச் செய்தபிறகு, அவன் உங்களைப் போக அனுமதிப்பான். ");
INSERT INTO tam2008_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","இஸ்ரவேல் ஜனங்களிடம் எகிப்திய ஜனங்கள் இரக்கம்கொள்ளும்படி செய்வேன். எகிப்தைவிட்டுப் புறப்படும்போது, உங்கள் ஜனங்களுக்கு எகிப்தியர்கள் பல வெகுமதிகளைக் கொடுப்பார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","“எல்லா எபிரெய பெண்களும் தங்கள் அண்டை வீடுகளிலும், தங்கள் வீடுகளிலும் வசிக்கும் எகிப்திய பெண்களிடம் பரிசுகளைக் கேட்க வேண்டும். அந்த எகிப்திய பெண்கள் அவர்களுக்குப் பரிசுகளைக் கொடுப்பார்கள். உன் ஜனங்கள் பொன், வெள்ளி, விலைமதிப்புள்ள ஆடைகள் ஆகியவற்றைப் பரிசாகப் பெறுவார்கள். பின் நீங்கள் எகிப்தை விட்டுப் புறப்படும்போது, உங்கள் குழந்தைகளுக்கு அப்பரிசுகளை அணிவிப்பீர்கள். இவ்வகையில் நீங்கள் எகிப்து தேசத்தின் செல்வத்தை எடுத்துச் செல்வீர்கள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","அப்போது மோசே தேவனை நோக்கி, “நீர் என்னை அனுப்பினீர் என்று கூறும்பொழுது, இஸ்ரவேல் ஜனங்கள் என்னை நம்பமாட்டார்கள். அவர்கள், ‘தேவன் (யேகோவா) உனக்குக் காட்சியளிக்க வில்லை’ என்பார்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","தேவன் மோசேயை நோக்கி, “உன் கையில் இருப்பது என்ன?” என்று கேட்டார். மோசே, “இது எனது கைத்தடி” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","அப்போது தேவன், “உனது கைத்தடியை தரையில் போடு” என்றார். மோசே, தனது கைத்தடியை நிலத்தின் மேல் போட்டான். அது பாம்பாக மாறிற்று. மோசே அதற்குப் பயந்து அங்கிருந்து ஓடினான். ");
INSERT INTO tam2008_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","கர்த்தர் மோசேயை நோக்கி, “கையை நீட்டி, பாம்பின் வாலைப் பிடி” என்றார். எனவே மோசே கையை நீட்டிப் பாம்பின் வாலைப் பிடித்தான். மோசே அவ்வாறு செய்த போது, பாம்பு மீண்டும் கைத்தடியாயிற்று. ");
INSERT INTO tam2008_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","அப்போது, தேவன், “உனது கைத் தடியை இவ்வாறு பயன்படுத்து. அப்போது நீ உனது முற்பிதாக்களின் தேவனாகிய ஆபிரகாமின் தேவனும், ஈசாக்கின் தேவனும், யாக்கோபின் தேவனுமாகிய கர்த்தரைக் கண்டாய் என்பதை ஜனங்கள் நம்புவார்கள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","பின் கர்த்தர், “உனக்கு மற்றொரு அடையாளத்தையும் தருவேன். உனது கையை அங்கிக்குள் நுழை” என்றார். எனவே மோசே தன் அங்கிக்குள் கையை நுழைத்தான். மோசே அங்கியிலிருந்து கையை எடுத்தபோது, அது மாறிப்போயிருந்தது. கை முழுவதும் உறைந்த பனியைப் போன்ற வெள்ளைப் புள்ளிகளால் நிரம்பியிருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","அப்போது தேவன், “உனது கையை அங்கிக்குள் மீண்டும் நுழை” என்றார். மோசே அவ்வாறே அங்கிக்குள் கையை நுழைத்தான். பின் மோசே கையை வெளியே எடுத்தபோது அவனது கை முன்பிருந்ததைப்போலவே நன்றாக இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","அப்போது தேவன், “நீ உனது கைத்தடியைப் பயன்படுத்தும்போது ஒருவேளை ஜனங்கள் உன்னை நம்பாவிட்டாலும், இந்த அடையாளத்தைக் காட்டும்போது, அவர்கள் உன்னை நம்புவார்கள் ");
INSERT INTO tam2008_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","இந்த இரண்டு காரியங்களைக் காண்பித்து, அவர்கள் உன்னை நம்ப மறுத்தால், நீ நைல் நதியிலிருந்து கொஞ்சம் தண்ணீரை அள்ளி, அதனைத் தரையில் ஊற்று. அது நிலத்தைத் தொட்டதும் இரத்தமாக மாறும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","ஆனால் மோசே கர்த்தரை நோக்கி, “கர்த்தாவே, நான் உமக்கு உண்மையைச் சொல்கிறேன் நான் தேர்ந்த பேச்சாளன் அல்ல. நான் சிறப்பாக எப்போதும் பேசியதில்லை. இப்போது உம்மிடம் பேசிய பிறகும்கூட, நான் சிறந்த பேச்சாளனாக மாறவில்லை. நான் நிதானமாகப் பேசுகிறேன் என்பதும், சிறந்த வார்த்தைகளைப் பயன்படுத்தாததிக்குவாய் உடையவன் என்பதும் உமக்கு தெரியும்” என்று கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","அப்போது கர்த்தர் அவனை நோக்கி, “யார் மனிதனின் வாயை உண்டாக்கினார்? யாரால் மனிதனைச் செவிடனாகவும், ஊமையாகவும் செய்யமுடியும்? யார் ஒருவனைக் குருடனாக்கக் கூடும்? யார் ஒருவனுக்குப் பார்வை தரமுடியும்? இக்காரியங்களைச் செய்ய வல்லவர் நானே. நான் யேகோவா. ");
INSERT INTO tam2008_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","எனவே நீ போ! நீ பேசும்போது நான் உன்னோடு இருப்பேன். நீ சொல்லவேண்டிய வார்த்தைகளை நான் உனக்குத் தருவேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","ஆனால் மோசே, “எனது கர்த்தாவே, வேறு யாரையாவது அனுப்புமாறு உம்மிடம் வேண்டிக்கொள்கிறேன், என்னை அனுப்பவேண்டாம்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","அப்போது மோசேயின்மேல் கர்த்தர் கோபம் கொண்டு, “நல்லது! உனக்கு உதவியாக நான் ஒருவனைத் தருவேன். லேவியனாகிய உனது சகோதரன் ஆரோனை நான் பயன்படுத்துவேன். அவன் தேர்ந்த பேச்சாளன். அவன் உன்னைப் பார்க்க வந்துகொண்டிருக்கிறான். அவன் உன்னைப் பார்த்து சந்தோஷப்படுவான். ");
INSERT INTO tam2008_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","அவன் உன்னோடுகூட பார்வோனிடம் வருவான். நீ கூற வேண்டியதை உனக்குச் சொல்வேன். நீ அதை ஆரோனுக்குச் சொல். பார்வோனிடம் பேச வேண்டிய தகுந்த வார்த்தைகளை ஆரோன் தெரிந்துகொள்வான். ");
INSERT INTO tam2008_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","உனக்காக ஆரோன் ஜனங்களிடமும் பேசுவான். நீ ஒரு பேரரசனைப் போலிருப்பாய், உனக்குரிய பேச்சாளனாக அவன் இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","எனவே போ. உனது கைத்தடியையும் எடுத்துச்செல். நான் உன்னோடிருக்கிறேன் என்பதை ஜனங்களுக்குக் காட்டுவதற்கு உனது கைத்தடியையும், பிற அற்புதங்களையும் பயன்படுத்து” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","அப்போது மோசே தன் மாமனாகிய எத்திரோவிடம் திரும்பிப்போனான். மோசே எத்திரோவை நோக்கி, “நான் எகிப்துக்குத் திரும்பிப்போக அனுமதி கொடும். எனது ஜனங்கள் இன்னும் உயிரோடிருக்கிறார்களா என்று பார்க்கவேண்டும்” என்றான். எத்திரோ மோசேயை நோக்கி, “நீ சமாதானத்தோடு போய்வா” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","மோசே இன்னும் மீதியானில் இருக்கும்போதே, தேவன் மோசேயை நோக்கி, “இப்போது நீ எகிப்திற்குத் திரும்பிப் போவதற்குப் பொருத்தமான வேளை. உன்னைக் கொல்ல விரும்பிய மனிதர்கள் மரித்து போய்விட்டனர்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","எனவே மோசே, தன் மனைவியையும், குழந்தைகளையும் கழுதையின்மேல் ஏற்றிக்கொண்டு, எகிப்திற்குத் திரும்பிப் போனான். தேவனின்வல்லமையைப் பெற்றிருந்த தனது கைத்தடியையும் மோசே எடுத்துக்கொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","மோசே எகிப்தை நோக்கிப் பிரயாணம் செய்துகொண்டிருந்தபோது, தேவன் அவனோடு பேசினார். அவர், “நீ பார்வோனோடு பேசும்போது, உனக்கு நான் அளித்துள்ள வல்லமையினால் எல்லா அற்புதங்களையும் செய்து காட்ட வேண்டும் என்பதை ஞாபகத்தில் வைத்துக்கொள். ஆனால் பார்வோன் மிகவும் பிடிவாதமாக இருக்கும்படியாகச் செய்வேன். ஜனங்களைப் போகும்படியாக அவன் அனுமதிக்கமாட்டான். ");
INSERT INTO tam2008_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","அப்போது நீ பார்வோனைப் பார்த்து, ‘இஸ்ரவேல் எனது முதற்பேறான மகன். ");
INSERT INTO tam2008_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","என் மகன் கிளம்பிப் போய் என்னைத் தொழுதுகொள்ளவிடு என்று உனக்குக் கூறுகிறேன்! இஸ்ரவேல் போவதற்கு நீ அனுமதி அளிக்க மறுத்தால், நான் உனது முதற்பேறான மகனைக் கொல்வேன், என்று கர்த்தர் சொல்கிறார்’ என்று சொல்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","எகிப்திற்குச் செல்லும் வழியில் இரவைக் கழிப்பதற்காக மோசே ஓரிடத்தில் தங்கினான். கர்த்தர் அவ்விடத்தில் மோசேயைச் சந்தித்து அவனைக் கொல்ல முயன்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","ஆனால் சிப்போராள் கூர்மையான கல்லினால் செய்யப்பட்டக் கத்தியினால் தனது மகனின் நுனித்தோலை அறுத்தெடுத்து, நுனித் தோலினால் மோசேயின் பாதங்களைத் தொட்டு, “நீர் எனக்கு இரத்த சம்பந்தமான கணவன்” என்றாள். ");
INSERT INTO tam2008_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","மகனுக்கு அவளே விருத்தசேதனம் செய்யும்படியாக நேரிட்டதால் சிப்போராள் இவ்வாறு கூறினாள். எனவே தேவன் மோசேயை மன்னித்து அவனைக்கொல்லாமல்விட்டார். ");
INSERT INTO tam2008_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","கர்த்தர் ஆரோனோடு பேசினார். கர்த்தர் அவனிடம், “பாலைவனத்தில் சென்று மோசேயைப் பார்” என்றார். எனவே ஆரோன் சென்று, தேவனின் மலையில் மோசேயைச் சந்தித்தான். ஆரோன் மோசேயைக் கண்டு, அவனை முத்தமிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","தேவன் அவனை அனுப்பினார் என்பதை நிரூபிப்பதற்காக அவன் செய்யவேண்டிய காரியங்களையும் அற்புதங்களையும் குறித்து மோசே ஆரோனுக்குச் சொன்னான். தேவன் அவனுக்குச் சொன்ன எல்லாவற்றையும் மோசே ஆரோனுக்குக் கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","மோசேயும் ஆரோனும் சென்று இஸ்ரவேல் ஜனங்களின் மூப்பர்களை (தலைவர்களை) ஒன்றாகக் கூட்டினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","அப்போது ஆரோன் ஜனங்களிடம் கர்த்தர் மோசேயிடம் கூறிய எல்லாக் காரியங்களையும் கூறினான். எல்லா ஜனங்களும் பார்க்கும்படியாக அடையாளங்களைச் செய்து காட்டினான். ");
INSERT INTO tam2008_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","தேவன் மோசேயை அனுப்பினார் என்பதை ஜனங்கள் நம்பினார்கள். தேவன் அவர்களின் துன்பங்களைக் கண்டார் எனவும், அவர்களுக்கு உதவுவதற்காக அவன் வந்துள்ளான் என்பதையும் இஸ்ரவேல் ஜனங்கள் அறிந்தார்கள். எனவே அவர்கள் தலைகுனிந்து தேவனைத் தொழுதுகொண்டார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","மோசேயும் ஆரோனும் ஜனங்களிடம் பேசிய பிறகு, பார்வோனிடம் சென்றனர். அவர்கள், “இஸ்ரவேலின் தேவனாகிய கர்த்தர், ‘பாலைவனத்தில் போய் பண்டிகை கொண்டாடி என்னை கௌரவப்படுத்துவதற்கு என் ஜனங்களை நீ போகவிடு’ என்று கூறுகிறார்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","ஆனால் பார்வோன், “யார் உங்கள் கர்த்தர்? நான் ஏன் அவருக்குக் கீழ்ப்படியவேண்டும்? இஸ்ரவேலரை நான் ஏன் போக அனுமதிக்கவேண்டும்? இந்த கர்த்தர் யாரென்று கூட எனக்குத் தெரியாது. நான் இஸ்ரவேலரைப் போக அனுமதிக்கமாட்டேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","அப்போது ஆரோனும் மோசேயும், “எபிரெய ஜனங்களின் தேவன் எங்களுடன் பேசினார். பாலைவனத்தில் மூன்று நாட்கள் பயணம் செல்வதற்கு எங்களை அனுமதிக்குமாறு நாங்கள் உன்னை வேண்டுகிறோம். அங்கு எங்கள் தேவனாகிய கர்த்தருக்குப் பலி செலுத்துவோம். இதை நாங்கள் செய்யவில்லையென்றால், அவர் கோபங்கொண்டு நோய் அல்லது யுத்தத்தினால் நாங்கள் அழியும்படியாகச் செய்வார்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","ஆனால் பார்வோன் அவர்களை நோக்கி, “மோசேயே, ஆரோனே, நீங்கள் வேலை செய்கிறவர்களைத் தொந்தரவு செய்கிறீர்கள். அவர்கள் அவர்களது வேலையைச் செய்யட்டும். உங்கள் வேலையை நீங்கள் கவனியுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","ஏராளமான வேலையாட்கள் உள்ளார்கள். தம் வேலைகளைச் செய்யாதபடி நீங்கள் அவர்களை தடுக்கிறீர்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","அதே நாளில் இஸ்ரவேல் ஜனங்கள் இன்னும் கடினமாக உழைக்கும்படியாக பார்வோன் ஒரு கட்டளையிட்டான். அடிமைகளின் மேற்பார்வையாளர்களிடமும் எபிரெயர்களைக் கண்காணிப் பவர்களிடமும் பார்வோன், ");
INSERT INTO tam2008_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“ஜனங்களுக்கு எப்போதும் நீங்கள் வைக்கோலை கொடுத்து வந்தீர்கள். அவர்கள் அதைப் பயன்படுத்திச் செங்கல் செய்தார்கள். ஆனால் இப்போது செங்கல் செய்வதற்குத் தேவையான வைக்கோலை அவர்களே சேகரித்து வரும்படி கூறுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ஆனால் முன்னால் செய்தபடியே, அதே எண்ணிக்கை செங்கற்களை தினமும் அவர்கள் செய்யவேண்டும். அவர்கள் சோம்பேறிகளாகிவிட்டனர், எனவே தான் தங்களை அனுப்பும்படியாக அவர்கள் என்னைக் கேட்கிறார்கள். அவர்கள் செய்வதற்குப் போதிய வேலை இல்லை. எனவேதான் அவர்கள் தங்கள் தேவனுக்குப் பலிகள் செலுத்தவேண்டுமென என்னைக் கேட்கிறார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","எனவே இந்த மனிதர்கள் கடினமாக வேலை செய்யும்படிச் செய்யுங்கள். அவர்களைச் சுறுசுறுப்பாக வைத்திருங்கள். அப்போது அவர்களுக்கு மோசேயின் பொய்களை நம்புவதற்குப் போதிய நேரமிராது” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","எனவே இஸ்ரவேலரின் எகிப்திய எஜமானர்களும், எபிரெய மேற்பார்வையாளர்களும் இஸ்ரவேல் ஜனங்களிடம் சென்று, “செங்கற்கள் செய்ய உங்களுக்கு வைக்கோல் தரமுடியாதென பார்வோன் முடிவு செய்துள்ளார். ");
INSERT INTO tam2008_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","நீங்கள் போய் உங்களுக்கு வேண்டிய வைக்கோலைக் கொண்டு வரவேண்டும். ஆனால் முன்னால் செய்தபடியே எண்ணிக்கைகளில் ஒன்றும் குறைக்கப்படுவதில்லை” என்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","வைக்கோலைக் கொண்டு வருவதற்காக ஜனங்கள் எகிப்தின் எல்லா இடங்களுக்கும் சென்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","மேற்பார்வையாளர்கள் ஜனங்களை இன்னும் கடினமாக வேலைவாங்கினார்கள். முன்னால் செய்த எண்ணிக்கை அளவுக்கு செங்கற்களைச் செய்யும்படி வற்புறுத்தினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","இஸ்ரவேலரின் எகிப்திய எஜமானர்கள், எபிரெய மேற்பார்வையாளர்களைத் தேர்ந்தெடுத்து ஜனங்கள் செய்த வேலைக்கு அவர்களைப் பொறுப்பாளர்கள் ஆக்கினார்கள். இஸ்ரவேலரின் எகிப்திய எஜமானர்கள், எபிரெய மேற்பார்வையாளர்களை அடித்து அவர்களிடம், “முன்னால் செய்த எண்ணிக்கையளவு செங்கற்களை ஏன் நீங்கள் செய்யவில்லை? முன்பு அதனைச் செய்ய முடிந்ததென்றால், இப்போதும் உங்களால் அதைச் செய்யக் கூடும்!” என்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","அப்போது எபிரெய மேற்பார்வையாளர்கள் பார்வோனிடம் சென்று: “நாங்கள் உமது ஊழியர்கள். ஏன் எங்களை இவ்வாறு நடத்துகிறீர்? ");
INSERT INTO tam2008_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","எங்களுக்கு நீர் வைக்கோல் தரவில்லை. ஆனால் முன்பு செய்த எண்ணிக்கையளவுக்கு செங்கற்களை இப்போதும் செய்யும்படியாகக் கூறுகிறீர். இப்போது எங்கள் எஜமானர்கள் எங்களை அடிக்கிறார்கள். இவ்வாறு உங்கள் ஜனங்கள் செய்வது தவறானது” என்று குறை கூறினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","பார்வோன், “நீங்கள் சோம்பேறிகள், உங்களுக்கு வேலைசெய்ய விருப்பமில்லை. அதனால் தான் உங்களை அனுப்பும்படி நீங்கள் என்னைக் கேட்கிறீர்கள். நீங்கள் இங்கிருந்து போய், கர்த்தருக்கு பலிசெலுத்த விரும்புகிறீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","இப்போது வேலை செய்யத் திரும்பி போங்கள்! உங்களுக்கு வைக்கோல் தரமாட்டோம். ஆனால் முன்பு செய்த எண்ணிக்கை அளவுக்கு செங்கற்களை நீங்கள் செய்ய வேண்டும்!” என்று பதிலளித்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","தங்களுக்கத் தொல்லை நேர்ந்ததை எபிரெய மேற்பார்வையாளர்கள் கண்டுகொண்டார்கள். கடந்த காலத்த்தில் செய்த எண்ணிக்கை அளவுக்கு செங்கற்களைச் செய்யமுடியாது என்று அவர்கள் அறிந்திருந்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","பார்வோனைச் சந்தித்துத் திரும்பிக்கொண்டிருந்த வழியில் மோசேயும், ஆரோனும் அவர்களுக்காகக் காத்துக்கொண்டிருந்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","அவர்கள் மோசேயையும், ஆரோனையும் நோக்கி, “நம்மைப் போகவிடும்படியாக பார்வோனைக் கேட்டபடியால் நீங்கள் பெரிய தவறு செய்துவிட்டீர்கள். பார்வோனும், அவரது ஆட்சியாளர்களும் எங்களை வெறுக்கும்படிச் செய்ததால் கர்த்தர் உங்களைத் தண்டிப்பார். எங்களைக் கொல்வதற்கு அவர்களுக்கு ஒரு தருணத்தை அளித்திருக்கிறீர்கள்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","மோசே கர்த்தரிடம் ஜெபம் செய்து, “ஆண்டவரே, உமது ஜனங்களுக்கு ஏன் இந்தக் கொடுமையான காரியத்தைச் செய்தீர்? ஏன் என்னை இங்கு அனுப்பினீர்? ");
INSERT INTO tam2008_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","நான் பார்வோனிடம் போய் நீர் கூறும்படியாகச் சொன்னவற்றைக் கூறினேன். அப்போதிலிருந்து அவன் ஜனங்களைக் கேவலமாக நடத்துகிறான். அவர்களுக்கு உதவுவதற்கு நீர் எதையும் செய்யவில்லை!” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","அப்போது கர்த்தர் மோசேயை நோக்கி, “நான் பார்வோனுக்குச் செய்யப்போவதை நீ இப்போது காண்பாய். அவனுக்கு எதிராக என் மகா வல்லமையைப் பயன்படுத்துவேன். அவன் என் ஜனங்களைப் போகவிடுவான். அவர்களை அனுப்ப மிக்க ஆயத்தத்தோடு இருப்பான். அவர்கள் போகும்படியாக அவன் கட்டாயப்படுத்துவான்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","பின், தேவன் மோசேயை நோக்கி, “நானே கர்த்தர். ");
INSERT INTO tam2008_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","நான் ஆபிரகாம், ஈசாக்கு, யாக்கோபுக்கு தரிசனமானேன். அவர்கள் என்னை எல்ஷடாய் (சர்வ வல்லமையுள்ள தேவன்) என்று அழைத்தார்கள். அவர்களுக்கு யேகோவா (கர்த்தர்) என்னும் எனது பெயர் தெரிந்திருக்கவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","நான் அவர்களோடு ஒரு உடன்படிக்கை செய்தேன். கானான் தேசத்தை அவர்களுக்குக் கொடுப்பதாக வாக்களித்தேன். அவர்கள் அத்தேசத்தில் வாழ்ந்தார்கள். ஆனால் அது அவர்களின் சொந்த தேசமல்ல. ");
INSERT INTO tam2008_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","இஸ்ரவேல் ஜனங்கள் படும் தொல்லைகளை நான் இப்போது அறிகிறேன். அவர்கள் எகிப்தில் அடிமைகளாக இருப்பதையும் நான் அறிகிறேன், எனது உடன்படிக்கையை நினைவுகூருகிறேன். ");
INSERT INTO tam2008_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","எனவே இஸ்ரவேல் ஜனங்களை நோக்கி, ‘நானே கர்த்தர். நான் உங்களை மீட்பேன். நான் உங்களை விடுவிப்பேன். எகிப்தியர்களுக்கு நீங்கள் அடிமைகளாக இருக்கமாட்டீர்கள். எனது பெரிய வல்லமையைப் பயன்படுத்தி, எகிப்தியருக்குப் பயங்கரமான தண்டனை அளிப்பேன். பின், உங்களை மீட்பேன். ");
INSERT INTO tam2008_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","நீங்கள் எனது ஜனங்களாயிருப்பீர்கள், நான் உங்கள் தேவனாக இருப்பேன். நான் உங்கள் தேவனாகிய கர்த்தர், நான் உங்களை எகிப்திலிருந்து மீட்டேன் என்பதை அறிவீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","ஆபிரகாம், ஈசாக்கு, யாக்கோபு ஆகியோருக்கு ஒரு பெரிய வாக்குத்தத்தம் பண்ணனேன். அவர்களுக்கு ஒரு விசேஷமான தேசத்தை அளிப்பதாக வாக்களித்தேன். எனவே உங்களை அத்தேசத்திற்கு வழிநடத்துவேன். உங்களுக்கு அத்தேசத்தைத் தருவேன், அது உங்களுடையதாக இருக்கும். நானே கர்த்தர்!’ என்று கூறியதாகச் சொல்லுங்கள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","மோசே இதனை இஸ்ரவேல் ஜனங்களுக்குக் கூறினான். ஆனால் ஜனங்கள் அதற்குச் செவிசாய்க்கவிலை. அவர்கள் மிகக் கடினமாக உழைத்ததால் மோசேயிடம் பொறுமையிழந்து காணப்பட்டார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","அப்போது கர்த்தர் மோசேயை நோக்கி, ");
INSERT INTO tam2008_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“பார்வோனிடம் போய் இஸ்ரவேல் ஜனங்களை தனது தேசத்திலிருந்து போகவிடும்படியாகக் கூறு” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","ஆனால் மோசே, “இஸ்ரவேல் ஜனங்களே எனக்குச் செவிசாய்க்க மறுக்கிறார்கள்! எனவே பார்வோனும் நான் சொல்வதைக் கேட்கமாட்டான். நான் பேச திறமையில்லாதவன்” என்று பதில் கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","ஆனால் கர்த்தர் மோசேயோடும், ஆரோனோடும் பேசினார். இஸ்ரவேல் ஜனங்களிடமும், பார்வோனிடமும் சென்று பேசுமாறு அவர்களுக்குக் கட்டளையிட்டார். எகிப்து தேசத்திலிருந்து இஸ்ரவேல் ஜனங்களை வழிநடத்துமாறும் அவர்களுக்கு தேவன் கட்டளையிட்டார். ");
INSERT INTO tam2008_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","இஸ்ரவேல் குடும்பத் தலைவர்களில் சிலருடைய பெயர்கள் இங்குத் தரப்படுகின்றன: இஸ்ரவேலின் முதல் மகன் ரூபனுக்கு நான்கு மகன்கள். அவர்கள் ஆனோக்கு, பல்லூ, எஸ்ரோன், கர்மீ ஆகியோர். ");
INSERT INTO tam2008_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","சிமியோனின் மகன்கள் எமுவேல், யாமின், ஓகாத், யாகீன், சோகார், சவுல் ஆகியோர். (சவுல் கானானிய பெண்ணின் மகன்.) ");
INSERT INTO tam2008_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","லேவி 137 ஆண்டுகள் வாழ்ந்தான். கெர்சோன், கோகாத், மெராரி ஆகியோர் லேவியின் ஜனங்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","கெர்சோனுக்கு, லிப்னீ, சிமேயீ என்னும் இரண்டு மகன்கள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","கோகாத் 133 ஆண்டுகள் வாழ்ந்தான். கோகாத்தின் ஜனங்கள் அம்ராம், இத்சேயார், எப்ரோன், ஊசியேல் ஆகியோர். ");
INSERT INTO tam2008_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","மெராரியின் ஜனங்கள் மகேலியும், மூசியுமாவர். இந்தக் குடும்பங்கள் அனைத்தும் இஸ்ரவேலின் மகன் லேவியிலிருந்து வந்தவை. ");
INSERT INTO tam2008_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","அம்ராம் 137 ஆண்டுகள் வாழ்ந்தான். அவன் தன் தந்தையின் சகோதரியாகிய யோகெபேத்தை மணந்தான். அம்ராமும் யோகெபேத்தும், ஆரோனையும் மோசேயையும் பெற்றனர். ");
INSERT INTO tam2008_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","கோராகு, நெப்பேக், சித்ரி ஆகியோர் இத்சேயாரின் மகன்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","மீசவேல், எல்சாபான், சித்ரி ஆகியோர் ஊசியேலின் மகன்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","எலிசபாளை ஆரோன் மணந்தான். (எலிசபா அம்மினதாபின் மகளும், நகசோனின் சகோதரியுமாவாள்.) ஆரோனும் எலிசபாளும் நாதாப், அபியூ, எலெயாசார், இத்தாமார் ஆகியோரைப் பெற்றனர். ");
INSERT INTO tam2008_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","ஆசீர், எல்க்கானா, அபியாசாப் ஆகியோர் கோராகின் ஜனங்களும் கோராகியரின் முற்பிதாக்களும் ஆவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","ஆரோனின் மகனாகிய எலெயாசார் பூத்தயேலின் மகள் ஒருத்தியை மணந்தான். அவள் பினெகாசைப் பெற்றெடுத்தாள். இந்த ஜனங்கள் எல்லோரும் இஸ்ரவேலின் மகனாகிய லேவியின் குடும்பத்தினராவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","ஆரோனும் மோசேயும், இந்த கோத்திரத்திலிருந்து வந்தனர். அவர்களிடம் தேவன் பேசி, “குழுக்களாக என் ஜனங்களை வழிநடத்து” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","ஆரோனும், மோசேயும் எகிப்து மன்னன் பார்வோனிடம் பேசினார்கள். எகிப்திலிருந்து இஸ்ரவேல் ஜனங்கள் போவதற்கு அனுமதிக்கும்படி அவர்கள் பார்வோனிடம் கூறினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","எகிப்தில் தேவன் மோசேயிடம் பேசினார். ");
INSERT INTO tam2008_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","அவர், “நானே கர்த்தர். நான் உன்னிடம் கூறுகின்றவற்றை எகிப்து அரசனிடம் சொல்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","ஆனால் மோசே, “நான் பேச திறமையில்லாதவன். அரசன் எனக்குச் செவிசாய்க்கமாட்டான்” என்று பதிலளித்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","கர்த்தர் மோசேயிடம், “நான் உன்னோடு இருப்பேன். பார்வோனுக்கு நீ ஒரு பேரரசனைப் போல் தோன்றுவாய். ஆரோன் உனக்காகப் பேசுகிறவனாய் இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","நான் உனக்குக் கட்டளையிடுகிற எல்லாவற்றையும் ஆரோனுக்குச் சொல். நான் சொல்லும் காரியங்களை அவன் அரசனுக்குச் சொல்வான். இஸ்ரவேல் ஜனங்கள் இத்தேசத்தை விட்டுச் செல்வதற்கு பார்வோன் அனுமதிப்பான். ");
INSERT INTO tam2008_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","ஆனால் பார்வோன் பிடிவாதமாக இருக்கும்படி நான் செய்வேன். நீங்கள் சொல்லுகிற காரியங்களுக்கு அவன் கீழ்ப்படியமாட்டான். நான் யாரென்பதை நிரூபிப்பதற்காக எகிப்தில் அநேக அற்புதங்களையும் அடையாளங்களையும் செய்வேன். ஆனால் உங்களுக்கு செவிகொடுக்க மறுப்பான். ");
INSERT INTO tam2008_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","பிறகு நான் எகிப்தை அதிகமாகத் தண்டிப்பேன். என் ஜனங்களையும் வெளியே கொண்டு வருவேன். ");
INSERT INTO tam2008_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","அப்போது எகிப்து ஜனங்கள் நானே கர்த்தர் என்பதை அறிவார்கள். அதன்பின் அவர்கள் தேசத்திலிருந்து என் ஜனங்களை வழி நடத்துவேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","கர்த்தரின் கட்டளைகளுக்கு மோசேயும் ஆரோனும் கீழ்ப்படிந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","பார்வோனிடம் பேசும்போது, மோசே 80 வயதுள்ளவனாகவும் ஆரோன் 83 வயதுள்ளவனாகவும் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","கர்த்தர் மோசேயிடமும், ஆரோனிடமும், ");
INSERT INTO tam2008_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“பார்வோன் உங்கள் வல்லமையை நிரூபித்துக் காட்டச் சொல்வான். உங்களிடம் ஒரு அற்புதத்தைச் செய்ய வேண்டுமென பார்வோன் கேட்பான். ஆரோனின் கைத்தடியை நிலத்தில் வீசும்படியாகச் சொல். பார்வோன் கவனித்துக்கொண்டிருக்கும்போதே, கைத்தடி ஒரு பாம்பாக மாறும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","எனவே மோசேயும், ஆரோனும் பார்வோனிடம் போய், கர்த்தர் சொன்னபடியே செய்தார்கள். ஆரோன் அவனது கைத்தடியைக் கீழே எறிந்தான். பார்வோனும் அவனது அதிகாரிகளும் பார்த்துக்கொண்டிருக்கையிலேயே, கைத்தடி பாம்பாக மாறிற்று. ");
INSERT INTO tam2008_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","எனவே, அரசன் தன் நாட்டுԔஞானிகளுக்கும், மந்திரவாதிகளுக்கும் சொல்லியனுப்பினான். அம்மனிதர்களும் அவர்களது உபாயங்களைப் பயன்படுத்தி ஆரோன் செய்தவாறே செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","அவர்களும் தங்கள் கைத்தடிகளை நிலத்தின் மேல் எறிந்தபோது, அக்கைத்தடிகள் பாம்புகளாயின, ஆனால் ஆரோனின் கைத்தடியோ அவற்றைத் தின்றது. ");
INSERT INTO tam2008_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","பார்வோனின் இருதயம் கடினமாகி, இப்போதும் ஜனங்களைப் போக விட மறுத்துவிட்டான். கர்த்தர் நடக்குமெனக் கூறியபடியே இது நிகழ்ந்தது. மோசேயும் ஆரோனும் கூறுவதைக் கேட்க அரசன் மறுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","கர்த்தர் மோசேயிடம், “பார்வோன் பிடிவாதமாக இருக்கிறான். பார்வோன் ஜனங்களை அனுப்ப மறுக்கிறான். ");
INSERT INTO tam2008_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","காலையில் பார்வோன் நதிக்குப் போவான். நைல் நதியினருகே பாம்பாக மாறின உனது கைத்தடியை எடுத்துக்கொண்டு அவனிடம் போ. ");
INSERT INTO tam2008_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","அவனிடம் இதைக் கூறு: ‘எபிரெய ஜனங்களின் தேவனாகிய கர்த்தர் என்னை உன்னிடம் அனுப்பினார். பாலைவனத்தில் அவரது ஜனங்கள் சென்று தொழுதுகொள்ள அனுப்பு என்று உன்னிடம் கூறுமாறு எனக்குக் கர்த்தர் சொன்னார். இதுவரைக்கும் நீ கர்த்தர் கூறியவற்றிற்கு செவிசாய்க்கவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","எனவே, அவரே கர்த்தர் என்பதை உனக்குக் காட்டுவதற்காக சில காரியங்களைச் செய்வதாகக் கர்த்தர் சொல்கிறார். எனது கையிலிருக்கும் இந்தக் கைத்தடியால் நைல் நதியின் தண்ணீரை அடிப்பேன். நதி இரத்தமாக மாறும். ");
INSERT INTO tam2008_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","நதியின் மீன்கள் செத்துப்போகும், நதியிலிருந்து துர் நாற்றம் வீச ஆரம்பிக்கும். அப்போது நதியின் தண்ணீரை எகிப்தியர்கள் பருகமுடியாது’” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","கர்த்தர் மோசேயை நோக்கி, “ஆரோனின் கையிலுள்ள கைத்தடியை நதிகள், கால்வாய்கள், ஏரிகள், தண்ணீர் தேங்கி நிற்கும் இடங்கள் அனைத்தின் மேலாகவும் நீட்டும்படியாக ஆரோனுக்குக் கூறு, அவன் அவ்வாறு செய்தவுடன் தண்ணீரெல்லாம் இரத்தமாகும். மரத்தாலும் கல்லாலுமாகிய ஜாடிகளில் நிரப்பியிருக்கும் தண்ணீர் உட்பட, எல்லா இடங்களிலுள்ள தண்ணீரும் இரத்தமாக மாறும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","ஆகையால் மோசேயும் ஆரோனும் கர்த்தர் கட்டளையிட்டபடியே செய்தார்கள். ஆரோன் கைத்தடியை உயர்த்தி நைல் நதியின் தண்ணீரை பார்வோன் முன்பாகவும் அவனது அதிகாரிகள் முன்பாகவும் அடித்தான். நதியின் தண்ணீர் முழுவதும் இரத்தமாயிற்று. ");
INSERT INTO tam2008_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","நதியின் மீன்கள் இறந்தன. நதி நாற்றமெடுத்தது. நதியின் தண்ணீரை எகிப்தியர்கள் பருக முடியா மலாயிற்று. எகிப்தில் எல்லா இடங்களிலும் இரத்தம் காணப்பட்டது. ");
INSERT INTO tam2008_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","எகிப்திய மந்திரவாதிகளும் தங்கள் உபாயங்களைப் பயன்படுத்தி இதையே செய்தார்கள். எனினும், பார்வோன் மோசேக்கும், ஆரோனுக்கும் செவிசாய்க்க மறுத்தான். இது கர்த்தர் சொன்னபடியே நடந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","மோசேயும், ஆரோனும் செய்தவற்றைப் பார்வோன் பொருட்படுத்தவில்லை. பார்வோன் மறுபுறமாகத் திரும்பி வீட்டிற்குள் சென்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","நதியிலிருந்து தண்ணீரை எகிப்தியர்கள் பருக முடியாமற்போயிற்று. எனவே, அவர்கள் நதியைச் சுற்றிலும் குடிப்பதற்குரிய தண்ணீரைப் பெறுவதற்காக கிணறுகளைத் தோண்டினர். ");
INSERT INTO tam2008_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","நைல் நதியை கர்த்தர் மாற்றிய பின்னர் ஏழு நாட்கள் கழிந்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","கர்த்தர் மோசேயை நோக்கி, “பார்வோனிடம் போய், ‘எனது ஜனங்கள் என்னைத் தொழுதுகொள்ள செல்வதற்கு அனுமதிகொடு! ");
INSERT INTO tam2008_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","எனது ஜனங்கள் போக நீ அனுமதிக்காவிட்டால், நான் எகிப்தைத் தவளைகளால் நிரப்புவேன். ");
INSERT INTO tam2008_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","நைல் நதி தவளைகளால் நிரம்பும், அவை நதியை விட்டு வெளியேறி உங்கள் வீடுகளுக்குள் நுழையும். அந்தத் தவளைகள் உங்கள் படுக்கையறைகளிலும், படுக்கைகளிலும் இருக்கும். உங்கள் அதிகாரிகளின் வீடுகளிலும், உங்கள் சமையல் அடுப்புகளிலும் தண்ணீர் ஜாடிகளிலும் இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","தவளைகள் உன் மீதும், உன் ஜனங்கள் மீதும், உன் அதிகாரிகள் மீதும் இருக்கும்’ என்று கர்த்தர் சொல்கிறார்” என்று சொல்லுமாறு கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","பின்பு கர்த்தர் மோசேயை நோக்கி, “கால்வாய்கள், நதிகள், ஏரிகள் ஆகியவற்றின் மீது அவனது கைத்தடியைப் பிடிக்குமாறு ஆரோனுக்குக் கூறு, அப்போது எகிப்து தேசமெங்கும் தவளைகள் வெளியில் வந்துசேரும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","எனவே ஆரோன் எகிப்தின் தண்ணீர் நிலைகள் அனைத்தின்மீதும் தனது கையைத் தூக்கினான். தவளைகள் தண்ணீரிலிருந்து வெளியேறிவர ஆரம்பித்து எகிப்து தேசமெங்கும் நிறைந்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","மந்திரவாதிகளும் அதே காரியத்தைச் செய்வதற்குத் தங்கள் உபாயங்களைப் பயன்படுத்தினர். எனவே, இன்னும் அதிகமான தவளைகள் எகிப்து தேசத்திற்குள் வந்தன! ");
INSERT INTO tam2008_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","பார்வோன் மோசேயையும், ஆரோனையும் அழைத்து, “என்னிடமிருந்தும், எனது ஜனங்களிடமிருந்தும் தவளைகளை அப்புறப்படுத்தும்படியாக கர்த்தரை வேண்டிக்கொள்ளுங்கள், நான் கர்த்தருக்குப் பலிகளைச் செலுத்துவதற்கு ஜனங்களைப் போக அனுமதிப்பேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","மோசே பார்வோனை நோக்கி, “தவளைகளை எப்போது அப்புறப்படுத்தலாமென்பதை எனக்குக் கூறு. நான் உனக்காகவும் உனது ஜனங்களுக்காவும் உனது அதிகாரிகளுக்காகவும் வேண்டிக்கொள்வேன். அப்போது தவளைகள் உங்களையும் உங்கள் வீடுகளையயும் விட்டுச்செல்லும், நதியில் மட்டுமே அவை வாழும். எப்போது தவளைகள் போக வேண்டுமென நீ விரும்புகிறாய்?” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","பார்வோன், “நாளைக்கு” என்றான். மோசே, “நீ சொல்வதுபோல் நடக்கும். இதன் மூலமாக எங்கள் தேவனாகிய கர்த்தரைப் போல வேறே தேவன் இல்லை என்பதை நீ அறிவாய். ");
INSERT INTO tam2008_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","தவளைகள் உன்னையும், உன் வீட்டையும், உன் அதிகாரிகளையும், உன் ஜனங்களையும் விட்டுநீங்கும். ஆற்றில் மட்டுமே தவளைகள் தங்கும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","மோசேயும், ஆரோனும் பார்வோனிடமிருந்து சென்றனர். பார்வோனுக்கு எதிராகக் கர்த்தர் அனுப்பிய தவளைகளைக் குறித்து மோசே அவரை நோக்கி ஜெபம் செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","மோசே கேட்டபடியே கர்த்தர் செய்தார். வீடுகளிலும், வெளிகளிலும், வயல்களிலும் இருந்த தவளைகள் செத்துப்போயின. ");
INSERT INTO tam2008_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","தவளைகள் குவியலாக சேர்க்கப்பட்டன. அவை அழுகிப்போனதால், நாடெங்கும் துர்நாற்றம் வீசியது. ");
INSERT INTO tam2008_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","தவளைகளின் தொல்லை இல்லாததைக் கண்ட பார்வோன் மேலும் பிடிவாதம் கொண்டான். மோசேயும் ஆரோனும் கேட்டுக்கொண்டதை பார்வோன் செய்யவில்லை. கர்த்தர் கூறியபடியே இது நடந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","கர்த்தர் மோசேயை நோக்கி, “ஆரோனிடம் அவனது தடியை உயர்த்தி, பூமியின் மீதுள்ள தூசியை அடிக்கும்படிகூறு, அப்போது எகிப்து தேசத்தின் எல்லா இடங்களிலும் தூசியெல்லாம் பேன்களாகும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","அவர்கள் அவ்வாறே செய்தார்கள். ஆரோன் அவனது கையிலுள்ள தடியை உயர்த்தி, பூமியின் மீதுள்ள தூசியில் அடித்தான். எகிப்து முழுவதுமிருந்த தூசி பேன்களாயிற்று. மிருகங்களின் மீதும், ஜனங்களின் மீதும் அவை புகுந்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","மந்திரவாதிகளும் தங்கள் உபாயங்களைப் பயன்படுத்தி அவ்வாறே செய்ய முயன்றனர். தூசியிலிருந்து பேன்கள் வரும்படியாகச் செய்ய மந்திரவாதிகளால் முடியவில்லை. பேன்கள் மிருகங்களின் மீதும், ஜனங்களின் மீதும் தங்கின. ");
INSERT INTO tam2008_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","தேவனின் வல்லமையால் இவ்வாறு நிகழ்ந்தது என்று மந்திரவாதிகள் பார்வோனுக்குக் கூறினார்கள். ஆனால் பார்வோன் தன் மனதைக் கடினமாக்கி அவர்கள் கூறியதைக் கேட்க மறுத்தான். கர்த்தர் கூறியபடியே இது நடந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","கர்த்தர் மோசேயை நோக்கி, “காலையில் எழுந்து பார்வோனிடம் போ. பார்வோன் நதிக்குப் போவான். அவனிடம், ‘எனது ஜனங்கள் போய், என்னைத் தொழுதுகொள்ள அனுமதி. ");
INSERT INTO tam2008_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","எனது ஜனங்களைப் போக அனுமதிக்காவிட்டால் ஈக்கள் உங்கள் வீட்டிற்குள்ளும், உன்மீதும், உன் அதிகாரிகள் மீதும் மிகுதியாய் வரும், உன் தேசமெங்கும் ஈக்கள் நிரம்பியிருக்கும்! ");
INSERT INTO tam2008_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","எகிப்திய ஜனகங்களுக்கு செய்ததுபோல, நான் இஸ்ரவேல் ஜனங்களுக்குச் செய்யமாட்டேன். என் ஜனங்கள் வாழும் கோசேனில் ஈக்கள் இராது. இதன் மூலம் இந்த ஜனங்களின் கர்த்தர் நான் என்பதை நீ அறிவாய். ");
INSERT INTO tam2008_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","எனவே நாளைக்கு எனது ஜனங்களை உன் ஜனங்களைக் காட்டிலும் வேறுவிதமாக நடத்துவேன். அதுவே எனது அடையாளமாக அமையும்’ என்று கூறு” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","பிறகு கர்த்தர் தான் சொன்னபடியே செய்து காட்டினார். மிகுதியான ஈக்கள் எகிப்து தேசமெங்கும் பார்வோன் வீட்டினுள்ளும் அவன் அதிகாரிகளின் வீட்டினுள்ளும் நிரம்பியிருந்தன. ஈக்கள் தேசத்தை அழித்துக்கொண்டிருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","எனவே பார்வோன் மோசேக்கும், ஆரோனுக்கும் சொல்லியனுப்பினான். பார்வோன் அவர்களை நோக்கி, “இந்தத் தேசத்திலேயே உங்கள் தேவனுக்குப் பலிகளைக் கொடுங்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","ஆனால் மோசே, “அவ்வாறு செய்வது சரியாக இருக்காது. எங்கள் தேவனாகிய கர்த்தருக்குப் பலியிடுவதற்காக மிருகங்களைக் கொல்வது கொடிய காரியம் என்று எகிப்தியர்கள் நினைக்கிறார்கள். இதை நாங்கள் இங்குச் செய்தால் எகிப்தியர் எங்களைக் கண்டு, எங்கள் மீது கற்களை வீசிக் கொன்றுவிடுவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","மூன்று நாட்கள் பாலைவனத்திற்குப் போய் எங்கள் தேவனாகிய கர்த்தருக்குப் பலி செலுத்த அனுமதிக்கவும். நாங்கள் செய்யும்படியாகக் கர்த்தர் கூறியதும் இதுதான்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","அதற்குப் பார்வோன், “பாலைவனத்திற்கு நீங்கள் போய் உங்கள் தேவனாகிய கர்த்தருக்கு பலிகளைச் செலுத்துவதற்கு உங்களை அனுமதிப்பேன். ஆனால் வெகு தூரம் பயணம் செய்யக் கூடாது. இப்போது போய் எனக்காக ஜெபம் செய்யுங்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","மோசே, “பார், நான் போய் உன்னிடமிருந்தும், உன் ஜனங்களிடமிருந்தும், உன் அதிகாரிகளிடமிருந்தும், ஈக்களை நீக்குவதற்காக கர்த்தரைக் கேட்டுக்கொள்வேன். ஆனால் கர்த்தருக்கு ஜனங்கள் பலி செலுத்துவதை நீ தடுக்கக் கூடாது” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","பின் மோசே பார்வோனிடமிருந்து சென்று கர்த்தரிடம் ஜெபம் செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","மோசே கேட்டபடியே கர்த்தர் செய்தார். பார்வோன், அவன் அதிகாரிகள், ஜனங்கள் ஆகியோரிடமிருந்தும் ஈக்களை அகற்றினார். எல்லா ஈக்களும் அகன்றன. ");
INSERT INTO tam2008_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","ஆனால் பார்வோன் மீண்டும் பிடிவாதம் மிகுந்தவனாய் ஜனங்களைப் போக அனுமதிக்கவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","அப்போது கர்த்தர் மோசேயை நோக்கி, “பார்வோனிடம் போய் அவனைப் பார்த்து, ‘எபிரெய ஜனங்களின் தேவனாகிய கர்த்தர்: என்னைத் தொழுதுக்கொள்ளும்படி என் ஜனங்களைப் போக அனுமதி! ");
INSERT INTO tam2008_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","நீ விடாப்பிடியாக அவர்களை அனுப்ப மறுத்தால், ");
INSERT INTO tam2008_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","உனது பண்ணை மிருகங்களுக்கு எதிராக கர்த்தர் தமது வல்லமையைப் பயன்படுத்துவார். ஒரு கொடிய நோயால் உனது குதிரைகள், கழுதைகள், ஒட்டகங்கள், பசுக்கள், ஆடுகள், ஆகியவை பாதிக்கப்படும்படியாகக் கர்த்தர் செய்வார். ");
INSERT INTO tam2008_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","எகிப்தியரின் மிருகங்களுக்கும், இஸ்ரவேலரின் மிருகங்களுக்கும் கர்த்தர் வித்தியாசம் காட்டுவார். இஸ்ரவேல் ஜனங்களின் மிருகங்கள் எதுவும் சாகாது. ");
INSERT INTO tam2008_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","இது நடப்பதற்குரிய காலத்தை கர்த்தர் குறித்துவிட்டார். நாளை இதனை இத்தேசத்தில் கர்த்தர் நிறைவேற்றுவார் என்று சொல்கிறார்’ என்று சொல்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","மறுநாள் காலையில் எகிப்தின் பண்ணை மிருகங்கள் அனைத்தும் மடிந்தன. ஆனால் இஸ்ரவேலருக்குரிய மிருகங்கள் எதுவும் மரிக்கவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","இஸ்ரவேலரின் மிருகங்களில் ஏதேனும் மரித்திருக்கிறதா என்று பார்ப்பதற்குப் பார்வோன் ஆட்களை அனுப்பினான். இஸ்ரவேலரின் மிருகங்கள் எதுவும் மரிக்கவில்லை என்று பார்வோன் அறிந்தும் பிடிவாதமாகவே இருந்தான். அவன் ஜனங்களைப் போக அனுமதிக்கவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","கர்த்தர் மோசேயையும் ஆரோனையும் நோக்கி, “உலையிலுள்ள சாம்பலை உங்கள் கைகளில் அள்ளிக்கொள்ளுங்கள். மோசே, நீ பார்வோனுக்கு முன்பாக உன் கைகளிலுள்ள சாம்பலைக் காற்றில் வீசு. ");
INSERT INTO tam2008_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","எகிப்து தேசம் முழுவதும் இச்சாம்பல் பரவி தூளாக இது மாறும். அந்தத் தூள் ஒரு மனிதன் மீதோ, ஒரு மிருகத்தின்மீதோ பட்டவுடன் தோலின் மீது கொப்புளங்கள் ஏற்படும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","எனவே மோசேயும், ஆரோனும் ஒரு உலையிலிருந்து சாம்பலை அள்ளிக்கொண்டனர். பின் அவர்கள் போய் பார்வோனுக்கு முன்னே நின்று, மோசே சாம்பலைக் காற்றில் தூவினான். ஜனங்களின் மீதும், மிருகங்களின் மீதும் கொப்புளங்கள் தோன்றின. ");
INSERT INTO tam2008_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","மோசே இவ்வாறு செய்வதை மந்திரவாதிகளால் தடுத்து நிறுத்த முடியவில்லை. ஏனெனில் மந்திரவாதிகளின் மீதும் கொப்பளங்கள் தோன்றியிருந்தன. எகிப்து தேசமெங்கும் இவ்வாறு நிகழ்ந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","ஆனால் பார்வோன் பிடிவாதமாக இருக்கும்படி கர்த்தர் செய்தார். எனவே மோசேக்கும், ஆரோனுக்கும் செவிசாய்க்க, பார்வோன் விரும்பவில்லை. கர்த்தர் கூறியவாறே இது நடந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","பின்பு கர்த்தர் மோசேயிடம், “காலையில் எழுந்து பார்வோனிடம் போ. எபிரெய ஜனங்களின் தேவனாகிய கர்த்தர், ‘எனது ஜனங்கள் என்னைத் தொழுதுக்கொள்வதற்குப் போக அனுமதி கொடு! ");
INSERT INTO tam2008_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","நீ அவ்வாறு செய்யாவிட்டால் எனது முழு சக்தியையும் உனக்கும், உனது அதிகாரிகளுக்கும், உனது ஜனங்களுக்கும் எதிராக அனுப்புவேன். அப்போது என்னைப் போன்ற தேவன் இவ்வுலகில் எவரும் இல்லை என்பதை நீ அறிவாய். ");
INSERT INTO tam2008_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","என் வல்லமையைப் பயன்படுத்தி ஒரு நோயை ஏற்படுத்தி அதனால் உன்னையும், உனது ஜனங்களனை வரையும் பூமியிலேயே இராதபடி அழிக்கமுடியும். ");
INSERT INTO tam2008_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","ஆனால் என் வல்லமையை உங்களுக்குக் காட்டுவதற்காகவே உங்களை இங்கு வைத்திருக்கிறேன். அப்போது உலகமெங்குமுள்ள ஜனங்கள் என்னைக் குறித்து அறிந்துக்கொள்வார்கள்! ");
INSERT INTO tam2008_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","எனது ஜனங்களுக்கு எதிராகவே நீ இன்னும் இருக்கிறாய். அவர்களை விடுதலை செய்வதற்கு நீ அனுமதிக்கவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","எனவே நாளைக்கு இதே நேரத்தில், ஒரு கொடிய கல்மழை காற்றை வீசச் செய்வேன். எகிப்து தேசத்தில் இன்றுவரை அதைப் போன்ற புயல்காற்று வீசியதே இல்லை. ");
INSERT INTO tam2008_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","இப்போதே உனது மிருகங்களை ஒரு பாதுகாப்பான இடத்தில் சேர்த்துவிடு. வயல்களில் காணப்படும் உனக்குரிய பொருள் எது வாயினும் அதைப் பாதுகாப்பான இடத்தில் சேர்த்துவிடு. ஏனெனில் வயலில் இருக்கும் எந்த மனிதனாயினும் சரி, மிருகமாயினும் சரி, அது கொல்லப்படும். அனைத்து பொருட்களின் மீதும் கல்மழை காற்று வீசும் என்று சொல்கிறார்’ என்று சொல்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","கர்த்தரின் செய்திக்குப் பார்வோனின் அதிகாரிகளில் சிலர் செவிசாய்த்தனர். அவர்கள் தங்கள் மிருகங்களையும், அடிமைகளையும், வீடுகளுக்குள் விரைவாகச் சேர்த்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","ஆனால் மற்றவர்கள் கர்த்தரின் செய்தியை ஒரு பொருட்டாய் எண்ணவில்லை. அவர்கள் வயல்களிலிருந்த எல்லா அடிமைகளையும் மிருகங்களையும் விட்டுவிட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","கர்த்தர் மோசேயிடம், “உன் கைகளை மேலே உயர்த்து. எகிப்து முழுவதும் கல்மழை பொழியத் துவங்கும். எகிப்தின் வயல்களிலுள்ள எல்லா ஜனங்கள், விலங்குகள் மற்றும் செடிகளின் மீதும் கல்மழை விழ ஆரம்பிக்கும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","மோசே தனது கைத்தடியை உயர்த்தினான். இடி, மின்னல், புயல் ஆகியவை எகிப்தைப் பாதிக்குமாறு கர்த்தர் செய்தார். ");
INSERT INTO tam2008_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","எகிப்தில் புயல் வீசியபோது மின்னல் அதனூடே தோன்றியது. எகிப்து ஒரு தேசமான பின்னர், அங்கு ஏற்பட்ட மிகக் கொடிய புயல் இதுவேயாகும். ");
INSERT INTO tam2008_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","புயல், எகிப்தின் வயல்களிலிருந்த எல்லாவற்றையும், ஜனங்கள், மிருகங்கள், தாவரங்கள் அனைத்தையும் அழித்தது. வயல்களின் மரங்களைப் புயல் வீழ்த்தியது. ");
INSERT INTO tam2008_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","எபிரெய ஜனங்கள் வாழ்ந்த கோசேன் தேசத்தில் மட்டும் புயலின் பாதிப்பு ஏற்படவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","பார்வோன் மோசேயையும், ஆரோனையும் அழைத்து அவர்களிடம், “இம்முறை நான் பாவம் செய்தேன். கர்த்தர் நீதியானவர். நானும் எனது ஜனங்களும் குற்றம் செய்தோம். ");
INSERT INTO tam2008_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","தேவன் அனுப்பிய புயலும், இடியும், கல்மழையும் கொடியவை. புயலை நிறுத்தும்படியாக தேவனிடம் விண்ணப்பியுங்கள். நான் நீங்கள் போவதற்கு அனுமதிப்பேன். நீங்கள் இங்குத் தங்க வேண்டியதில்லை” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","மோசே பார்வோனிடம், “நான் நகரத்தை விட்டுப் புறப்பட்டதும் கர்த்தரை நோக்கி ஜெபம் செய்தபடியே என் கைகளை உயர்த்துவேன். இடியும் கல்மழையும் நின்றுபோகும், இந்த பூமியில் கர்த்தர் இருக்கிறார் என்பதை அப்போது நீ அறிவாய். ");
INSERT INTO tam2008_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","ஆனால் நீயும் உனது அதிகாரிகளும் உண்மையாகவே கர்த்தருக்குப் பயந்து அவரை மதிக்கவில்லை என்பதை நான் அறிவேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","சணல் பயிர்களில் ஏற்கெனவே கதிர்களும், வாற்கோதுமைப் பயிரில் பூக்களும் தோன்றியிருந்தன. இச்செடிகள் அனைத்தும் அழிந்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","ஆனால் கோதுமையும், கம்பும், பிற தானியங்களைக் காட்டிலும் தாமதமாக அறுவடை ஆகும். எனவே இவை அழிக்கப்படவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","மோசே பார்வோனிடமிருந்து புறப்பட்டு நகரத்திற்கு வெளியேபோய் கர்த்தரை நோக்கி ஜெபம் செய்ய கரங்களை உயர்த்தினான். உடனே கல்மழையும், புயலும், இடியும்கூட நின்றுபோனது. ");
INSERT INTO tam2008_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","மழை, புயல், இடி ஆகியவை நின்றுபோயின என்பதைக் கண்ட பார்வோன் மீண்டும் தவறு செய்தான். அவனும், அவனது அதிகாரிகளும் மீண்டும் தங்கள் இருதயத்தைக் கடினப்படுத்தினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","இஸ்ரவேல் ஜனங்களை விடுதலை செய்ய பார்வோன் மறுத்தான். மோசேயின் மூலமாக கர்த்தர் கூறியபடியே இது நிகழ்ந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","கர்த்தர் மோசேயை நோக்கி, “பார்வோனிடம் போ. அவனையும், அவனது அதிகாரிகளையும் பிடிவாதம் உடையவர்களாக்கினேன். எனது வல்லமைமிக்க அற்புதங்களை அவர்களுக்குக் காட்டும்படியாக நான் இதைச் செய்தேன். ");
INSERT INTO tam2008_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","நான் எகிப்தில் செய்த அற்புதங்களையும், மற்ற அதிசயமான காரியங்களையும் குறித்து நீங்கள் உங்கள் பிள்ளைகளுக்கும், பேரப்பிள்ளைகளுக்கும் சொல்வதற்காகவும் நான் இதைச் செய்தேன். அப்போது நானே கர்த்தர் என்பதை நீங்கள் எல்லாரும் அறவீர்கள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","ஆகையால் மோசேயும், ஆரோனும் பார்வோனிடம் சென்றார்கள். அவர்கள் அவனை நோக்கி, “எபிரெய ஜனங்களின் தேவனாகிய கர்த்தர், ‘எத்தனை காலம் எனக்குக் கீழ்ப்படிய மறுப்பாய்? எனது ஜனங்கள் என்னைத் தொழுதுகொள்வதற்குப் போக அனுமதி! ");
INSERT INTO tam2008_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","நீ எனது ஜனங்களைப் போகவிடாவிட்டால், நாளை உனது நாட்டிற்குள் வெட்டுக்கிளிகளை அனுப்புவேன். ");
INSERT INTO tam2008_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","வெட்டுக்கிளிகள் நாட்டை ஆக்கிரமிக்கும். பூமியைப் பார்க்க முடியாத அளவிற்கு வெட்டுக்கிளிகள் நிரம்பும். புயலின் அழிவிற்குத் தப்பியவை அனைத்தும் வெட்டுக்கிளிகளால் அழிக்கப்படும். வயலிலுள்ள மரங்களின் இலைகள் அனைத்தையும் வெட்டுக்களிகள் தின்றுவிடும். ");
INSERT INTO tam2008_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","உனது வீட்டிலும், உனது அதிகாரிகளின் வீடுகளிலும், எகிப்திலுள்ள எல்லா வீடுகளிலும் வெட்டுக் கிளிகள் நிறைந்துவிடும். உங்கள் பிதாக்களோ, முற்பிதாக்களோ, பார்த்திராத அளவிற்கு வெட்டுக் கிளிகள் காணப்படும். எகிப்தில் ஜனங்கள் வாழ ஆரம்பித்த காலம் முதல் இன்றுவரை பார்த்த வெட்டுக்கிளிகளைக் காட்டிலும் அதிகமான வெட்டுக்கிளிகள் காணப்படும் என்கிறார்’” என்று சொன்னார்கள். பிறகு மோசே திரும்பி, பார்வோனை விட்டுப் புறப்பட்டான். ");
INSERT INTO tam2008_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","அப்போது அதிகாரிகள் பார்வோனிடம், “இந்த ஜனங்களால் எத்தனை நாட்கள் நாம் இக்கட்டில் அகப்பட்டிருப்போம்? அவர்கள் தேவனாகிய கர்த்தரைத் தொழுதுகொள்ள அந்த ஜனங்களைப் போகவிடும். நீர் அவர்களைப் போகவிடாவிட்டால், நீர் அறிந்துகொள்ளும் முன்பு எகிப்து அழிக்கப்படும்!” என்று கூறினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","எனவே பார்வோன் மோசேயையும், ஆரோனையும் திரும்பவும் தன்னிடம் அழைக்கும்படிக்கு அதிகாரிகளை அனுப்பினான். பார்வோன் அவர்களை நோக்கி, “நீங்கள் போய், உங்கள் தேவனாகிய கர்த்தரைத் தொழுதுகொள்ளுங்கள், ஆனால் யார் யார் போகப்போகிறீர்கள் என்பதைச் சரியாக எனக்குக் கூறுங்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","மோசே பதிலாக, “இளைஞரும், முதியோருமாகிய எல்லா ஜனங்களும் போவோம். எங்களோடு எங்கள் மகன்களையும், மகள்களையும், ஆடுகளையும், மாடுகளையும், அழைத்துச் செல்வோம். கர்த்தரின் பண்டிகை எங்கள் எல்லோருக்கும் உரியது என்பதால் நாங்கள் எல்லோரும் போவோம்” என்று கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","பார்வோன் அவர்களிடம், “நான் உங்களையும் உங்கள் ஜனங்களையும் எகிப்தைவிட்டுப் போகும்படியாக அனுமதிக்கும் முன்னர் கர்த்தர் உங்களோடு கண்டிப்பாக இருக்கவேண்டும். பாருங்கள், நீங்கள் தீமையான ஒன்றைத் திட்டமிடுகிறீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","ஆண்கள் மாத்திரம் போய் கர்த்தரைத் தொழுதுகொள்ளலாம். நீங்கள் முதலில் அதைத்தான் என்னிடம் கேட்டீர்கள். உங்கள் ஜனங்கள் எல்லாரும் போகமுடியாது” என்று கூறி, பார்வோன் மோசேயையும், ஆரோனையும் அனுப்பிவிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","கர்த்தர் மோசேயை நோக்கி, “இப்போது உன் கைகளை எகிப்து தேசத்திற்கு மேலாக உயர்த்து, அப்போது எகிப்து நாடெங்கும் வெட்டுக்கிளிகள் வந்து பரவும். புயல் அழிக்காமல்விட்ட எல்லா தாவரங்களையும் வெட்டுக்கிளிகள் தின்றுவிடும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","எனவே, மோசே தனது கைத்தடியை எகிப்து நாட்டிற்கு மேலாக உயர்த்தினான். கிழக்கிலிருந்து ஒரு பெருங்காற்று வீசும்படியாகக் கர்த்தர் செய்தார். பகலும் இரவும் காற்று வீசிற்று. காலையில் காற்று எகிப்திற்குள் வெட்டுக்கிளிகளைக் கொண்டு வந்திருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","வெட்டுக்கிளிகள் எகிப்து நாட்டிற்குள் வந்து பூமியில் விழுந்தன. எகிப்தில் அதுவரை அந்த அளவில் வெட்டுக்கிளிகள் வந்ததுமில்லை, இனி மேலும் அத்தனை எண்ணிக்கை வெட்டுக்கிளிகள் எகிப்தில் வருவதும் இல்லை. ");
INSERT INTO tam2008_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","வெட்டுக்கிளிகள் தேசம் முழுவதும் பூமி மேல் இருள் மூடும்வரை நிரப்பின. கல்மழை அழிக்காமல் விட்ட மரங்களின் கனிகளையும், பூமியிலுள்ள தாவரங்கள் அனைத்தையும் வெட்டுக்கிளிகள் தின்றுவிட்டன. எகிப்தில் எங்கும் மரங்களிலும் செடிகளிலும் ஒரு இலைகூட இருக்கவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","பார்வோன் அவசரமாக மோசேயையும், ஆரோனையும் அழைத்துவரச் செய்து, “நான் உங்கள் தேவனாகிய கர்த்தருக்கும் உங்களுக்கும் எதிராகப் பாவம் செய்தேன். ");
INSERT INTO tam2008_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","இம்முறை எனது பாவங்களுக்காக என்னை மன்னியுங்கள். இந்த ‘மரணத்தை’ (வெட்டுக்கிளிகளை) என்னிடமிருந்து அகற்றுவதற்கு கர்த்தரிடம் கேளுங்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","மோசே பார்வோனிடமிருந்து சென்று கர்த்தரிடம் ஜெபித்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","எனவே, கர்த்தர் காற்றின் திசையை மாற்றி மேற்கிலிருந்து மிகப் பலமான காற்று ஒன்று வீசும்படியாகச் செய்தார். அது வெட்டுக்கிளிகளை எகிப்திலிருந்து அகற்றி, செங்கடலில் விழச்செய்தது. எகிப்தில் ஒரு வெட்டுக்கிளிகூட இருக்க வில்லை! ");
INSERT INTO tam2008_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","ஆனால், பார்வோன் மீண்டும் பிடிவாதமாக இருக்குமாறு கர்த்தர் செய்தார். இஸ்ரவேல் ஜனங்கள் போவதற்குப் பார்வோன் அனுமதிதரவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","கர்த்தர் மோசேயை நோக்கி, “உனது கைகளை மேலே உயர்த்து. எகிப்தை இருள் மூடும். நீங்கள் உணர்ந்துகொள்ளுமளவிற்கு இருள் மிகுதியாக இருக்கும்!” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","மோசே கைகளை மேலே உயர்த்திய போது, இருண்ட மேகமானது எகிப்தை மறைத்தது. எகிப்தை மூன்று நாட்கள் இருள் மூடியது. ");
INSERT INTO tam2008_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ஒருவரையொருவர் பார்க்க முடியவில்லை. மூன்று நாட்களாக எந்த இடத்திற்கும் போவதற்காக ஜனங்கள் எழுந்திருக்கவில்லை. ஆனால் இஸ்ரவேல் ஜனங்கள் வாழ்ந்த எல்லா இடங்களிலும் ஒளி இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","பார்வோன் மீண்டும் மோசேயை வரவழைத்து, “நீங்கள் போய்க் கர்த்தரை தொழுதுகொள்ளுங்கள்! நீங்கள் உங்கள் குழந்தைகளையும் அழைத்துப்போகலாம். ஆனால் உங்கள் ஆடுகளையும், மாடுகளையும் இங்கே விட்டுச் செல்லவேண்டும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","மோசே, “நாங்கள் போகும்போது எங்கள் ஆடுகளையும், மாடுகளையும் கொண்டு செல்வதோடு மட்டுமல்லாது, எங்கள் தேவனாகிய கர்த்தரைத் தொழுதுகொள்வதற்குப் பயன்படுத்தும்பொருட்டுப் பலிகளையும், காணிக்கைகளையும் நீங்களே கூட எங்களுக்குக் கொடுப்பீர்கள்! ");
INSERT INTO tam2008_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ஆம், கர்த்தரைத் தொழுதுகொள்வதற்கு நாங்கள் எங்கள் மிருகங்களையும் கொண்டு செல்வோம். எந்த மிருகத்தின் குளம்பையும்கூட விட்டுச் செல்லமாட்டோம். கர்த்தரைத் தொழுதுகொள்வதற்குத் தேவைப்படுபவை எவை என்பதை இன்னமும் நாங்கள் சரியாக அறியவில்லை. நாங்கள் போகவிருக்கும் இடத்தை அடையும்போதுதான் அதை அறிந்துகொள்வோம், எனவே இந்தப் பொருட்கள் எல்லாவற்றையும் நாங்கள் கொண்டு செல்லவேண்டும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","கர்த்தர் பார்வோனை இன்னும் பிடிவாதம் உடையவனாக்கினார். எனவே பார்வோன் அவர்களை அனுப்ப மறுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","பிறகு பார்வோன் மோசேயிடம், “இங்கிருந்து போய்விடு! நீ இங்கு மீண்டும் வருவதை நான் விரும்பவில்லை! என்னைப் பார்க்க நீ மீண்டும் வந்தால் நீ சாவாய்” என்று கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","அப்போது மோசே பார்வோனை நோக்கி, “நீ ஒரு விஷயத்தைச் சரியாகச் சொன்னாய், நான் உன்னைப் பார்ப்பதற்கு மீண்டும் வரப்போவதில்லை!” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","அப்போது கர்த்தர் மோசேயைப் பார்த்து, “பார்வோனுக்கும், எகிப்துக்கும் எதிராக நான் செய்யவிருக்கும் கேடு இன்னும் ஒன்று உண்டு. இதன் பிறகு, அவன் உங்களை எகிப்திலிருந்து அனுப்பிவிடுவான். உண்மையில், இந்நாட்டை விட்டு நீங்கள் வெளியேறும்படி துரத்துவான். ");
INSERT INTO tam2008_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","நீ இஸ்ரவேலுக்கு இந்த செய்தியைத் தெரியப்படுத்து: இஸ்ரவேலின் ஒவ்வொரு ஆண்களும், பெண்களும் உங்கள் அக்கம் பக்கத்தாரிடம் வெள்ளியாலும் பொன்னாலுமாகிய பொருட்களை உங்களுக்குக் கொடுக்கும்படியாகக் கேட்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","எகிப்தியர்கள் உங்களிடம் இரக்கத்துடன் இருக்கும்படி செய்வேன். எகிப்திய ஜனங்களும், பார்வோனின் சொந்த அதிகாரிகளும்கூட மோசேயைப் பெரியவனாக ஏற்கெனவே கருதுகிறார்கள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","மோசே ஜனங்களிடம், “கர்த்தர் ‘இன்று நள்ளிரவில், நான் எகிப்தின் வழியாகச் செல்வேன், ");
INSERT INTO tam2008_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","எகிப்தின் முதற்பேறான ஆண் குழந்தைகள் அனைவரும், எகிப்து மன்னனாகிய பார்வோனின் முதற்பேறான மகன் முதல், மாவரைக்கிற அடிமைப் பெண்ணின் முதற்பேறான மகன் வரைக்கும் எல்லோரும் மரிப்பார்கள். முதற்பேறான மிருகங்கள் கூட மடியும். ");
INSERT INTO tam2008_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","கடந்த எந்தக் காலத்தைக் காட்டிலும் எகிப்தின் அழுகுரல் பயங்கரமாயிருக்கும். வருங்காலத்தில் நடக்கக் கூடியதைக் காட்டிலும் அது கொடியதாக இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","ஆனால் இஸ்ரவேல் ஜனங்களில் ஒருவரும் பாதிக்கப்படுவதில்லை. ஒரு நாய் கூட அவர்களைப் பார்த்துக் குரைக்காது. இஸ்ரவேல் ஜனங்களில் ஒருவனும், மிருகங்களில் ஒன்றும் காயமடைவதில்லை. இதன் மூலமாக, எகிப்தியரைக் காட்டிலும் இஸ்ரவேலரை நான் வித்தியாசமாக நடத்துவதை நீங்கள் அறிவீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","அப்போது உங்கள் அடிமைகள் (எகிப்தியர்கள்) எல்லோரும் குனிந்து என்னைத் தொழுதுகொள்வார்கள். அவர்கள், “உங்கள் ஜனங்களை உங்களோடு அழைத்துக்கொண்டு புறப்பட்டுச் செல்லுங்கள்” என்பார்கள். அப்போது கோபத்தோடு நான் பார்வோனை விட்டுப் புறப்படுவேன்!’ என்றார்” என்று கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","பின்பு கர்த்தர் மோசேயிடம், “பார்வோன் நீ சொன்னதைக் கேட்கவில்லை, ஏன்? நான் எகிப்தில் என் மகா வல்லமையைக் காட்ட அப்போதுதான் முடியும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","எனவே தான், மோசேயும், ஆரோனும் இம்மகா அற்புதங்களைப் பார்வோனுக்கு முன்பாகச் செய்து காட்டினார்கள். இதனாலேயே இஸ்ரவேல் ஜனங்களைத் தனது தேசத்திலிருந்து அனுப்பாதபடி பார்வோனைப் பிடிவாத முள்ளவனாக கர்த்தர் ஆக்கினார். ");
INSERT INTO tam2008_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","மோசேயும் ஆரோனும் இன்னும் எகிப்தில் இருக்கையில் கர்த்தர் அவர்களிடம் பேசினார்: ");
INSERT INTO tam2008_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“இம்மாதம் உங்கள் ஆண்டின் முதல் மாதமாக இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","இஸ்ரவேலின் எல்லா கோத்திரத்திற்கும் இந்தக் கட்டளை உரியது: இம்மாதத்தின் பத்தாவது நாள் ஒவ்வொரு மனிதனும் அவனது வீட்டினருக்காக ஒரு ஆட்டுக்குட்டியைக் கொண்டு வர வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ஒரு ஆட்டுக்குட்டியை உண்பதற்கு வேண்டிய ஆட்கள் அவனது வீட்டில் இல்லாதிருந்தால், அவன் அக்கம் பக்கத்தாரில் சிலரை உணவைப் பகிர்ந்துகொள்வதற்கு அழைக்க வேண்டும். ஆட்டுக் குட்டி ஒவ்வொருவரும் உண்ணப் போதுமானதாக இருக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","அந்த ஆட்டுக் குட்டி ஒரு வயது நிரம்பிய கடாவாகவும், நோயற்றதாகவும் இருக்க வேண்டும். அது ஒரு செம்மறி ஆடு அல்லது வெள்ளாட்டின் குட்டியாக இருக்கலாம். ");
INSERT INTO tam2008_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","மாதத்தின் பதினான்காவது நாள்வரை அம்மிருகத்தைக் கவனித்துக்கொள்ளவேண்டும். அந்நாளில், இஸ்ரவேல் கோத்திரத்தின் எல்லா ஜனங்களும் மாலைப்பொழுதில் அவற்றைக் கொல்ல வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","நீங்கள் அதன் இரத்தத்தைச் சேகரிக்க வேண்டும். இந்த இரத்தத்தை, அதன் இறைச்சியை உண்ணுகிறவர்கள் தங்கள் வீட்டு வாசலின் மேற்பகுதியிலும், பக்க வாட்டிலும் நிலைக்கால்களில் பூசவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","“இந்த இரவில், ஆட்டுக்குட்டியை நெருப்பில் வாட்டியெடுத்து மாமிசம் எல்லாவற்றையும் உண்ண வேண்டும். நீங்கள் கசப்பான கீரை வகைகளையும், புளிக்காத ரொட்டியையும் கூட சாப்பிட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","ஆட்டுக்குட்டியை நீங்கள் தண்ணீரில் வேக வைக்கக்கூடாது. அந்த ஆட்டுக் குட்டி முழுவதையும் நெருப்பினால் சுடவேண்டும். அதன் தலை, கால்கள் மற்றும் உள் உறுப்புக்கள் எல்லாம் இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","அந்த இரவுக்குள் நீங்கள் மாமிசம் முழுவதையும் சாப்பிட்டு முடிக்கவேண்டும். காலையில் மாமிசம் மீதியாயிருந்தால் நெருப்பில் அந்த மாமிசத்தை சுட்டு எரிக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","“நீங்கள் உணவைச் சாப்பிடும்போது பயணத்திற்குத் தயாரான உடை அணிந்தவர்களாய் இருக்க வேண்டும். உங்கள் மிதியடிகளை அணிந்து, கைத்தடிகளை ஏந்தியவர்களாய் இருக்க வேண்டும். நீங்கள் அதை அவசரமாகச் சாப்பிட வேண்டும். ஏனென்றால், இது கர்த்தருடைய பஸ்கா பண்டிகை. கர்த்தர் தமது ஜனங்களைப் பாதுகாத்து, எகிப்திலிருந்து விரைவாக வெளியில் கொண்டுவரும் நேரம். ");
INSERT INTO tam2008_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“இன்றிரவில் நான் எகிப்தின் வழியாகச் சென்று ஒவ்வொரு முதற்பேறான மனிதனையும், மிருகத்தையும் கொன்றுபோடுவேன். இவ்வாறாக, எகிப்தின் தேவர்கள் அனைத்தின் மேலும் தீர்ப்பு கொண்டு வருவேன். நானே கர்த்தர் என்பதைக் காட்டுவேன். ");
INSERT INTO tam2008_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","ஆனால் உங்கள் வீடுகளில் பூசப்பட்ட இரத்தம் ஒரு விசேஷ அடையாளமாக இருக்கும். நான் இரத்தத்தைப் பார்த்ததும் உங்கள் வீட்டைக் கடந்து போவேன். எகிப்தின் ஜனங்களுக்குத் தீமையான காரியங்கள் ஏற்படுமாறு செய்வேன். அத்தீய நோய்கள் ஒன்றும் உங்களைப் பாதிக்காது. ");
INSERT INTO tam2008_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“இந்த இரவை நீங்கள் எப்போதும் நினைவு கூருவீர்கள். இது உங்களுக்கு ஒரு விசேஷ விடுமுறை நாளாக இருக்கும். எப்போதும் இந்த விடுமுறை நாளில் உங்கள் சந்ததியார் கர்த்தரை மகிமைப்படுத்துவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","இந்த விடுமுறையின் ஏழு நாட்களும் புளிக்காத மாவினால் செய்த ரொட்டியை உண்ணவேண்டும். இந்த விடுமுறையின் முதல் நாளில் புளிப்பான யாவற்றையும் உங்கள் வீடுகளிலிருந்து அகற்ற வேண்டும். இப்பண்டிகையின் ஏழு நாட்களிலும் யாரும் புளிப்பான எதையும் உண்ணக்கூடாது. யாரேனும் புளிப்பானதைச் சாப்பிட்டால், அவன் இஸ்ரவேல் ஜனங்களிலிருந்து ஒதுக்கப்படவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","விடுமுறை காலத்தின் முதல் நாளிலும் கடைசி நாளிலும் பரிசுத்த சபைக் கூட்டங்கள் நடைபெற வேண்டும். இந்நாட்களில் நீங்கள் எந்த வேலையும் செய்யக் கூடாது. உங்கள் சாப்பாட்டிற்கான உணவைத் தயாரிப்பது மட்டுமே நீங்கள் செய்யும் வேலையாக இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","நீங்கள் புளிப்பில்லா அப்பப் பண்டிகையை நினைவுகூர வேண்டும். ஏனெனில் இந்நாளில் உங்கள் ஜனங்கள் எல்லோரையும் குழுக்களாக எகிப்திலிருந்து வெளியே கொண்டு வந்தேன். எனவே உங்கள் எல்லா சந்ததியாரும் இந்த நாளை நினைவுகூர வேண்டும். எந்நாளும் நிலைபெற்றிருக்கும் சட்டமாக இது அமையும். ");
INSERT INTO tam2008_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","எனவே (நிசான்) முதல் மாதத்தின் பதினான்காவது நாளில் நீங்கள் புளிப்பில்லாத ரொட்டியை உண்ணத் துவங்க வேண்டும். அதே மாதத்தின் இருபத்தொன்றாம் நாள் மாலைவரைக்கும் இந்த புளிப்பில்லாத ரொட்டியைத் தொடர்ந்து நீங்கள் சாப்பிட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","ஏழு நாட்கள் உங்கள் வீடுகளில் எந்தப் புளிப்பான பொருளும் காணப்படக் கூடாது. இஸ்ரவேலின் குடிமகனாகிலும், அந்நியனாகிலும், புளிப்பானதைச் சாப்பிட்டால் அவன் இஸ்ரவேல் ஜனத்தினின்று ஒதுக்கப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","இந்த ஓய்வு நாளில் நீங்கள் புளிப்புள்ள உணவை உண்ணவே கூடாது. நீங்கள் எங்கு வாழ்ந்தாலும் புளிப்பு இல்லாத மாவால் செய்த ரொட்டியையே உண்ணவேண்டும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","மோசே எல்லா மூப்பர்களையும் (தலைவர்கள்) ஒன்றாகக் கூடிவரச் செய்தான். மோசே அவர்களிடம், “உங்கள் குடும்பங்களுக்குரிய ஆட்டுக்குட்டிகளைக் கொண்டு வந்து, பஸ்கா பண்டிகைக்காக அவற்றைக் கொல்லுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","ஈசோப் தழைகளை எடுத்து, அவற்றை இரத்தம் நிரம்பியிருக்கும் கிண்ணங்களில் தோய்த்து எடுத்து வாசல் நிலைக்கால்களின் பக்கங்களிலும், மேலேயும் இரத்தத்தைப் பூசுங்கள். காலை வரைக்கும் ஒருவனும் அவனது வீட்டை விட்டு எங்கும் போகக்கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","எகிப்தின் முதற்பேறானவற்றை அழிப்பதற்காகக் கர்த்தர் கடந்து செல்லும்போது அவர் வாசல் நிலைக்கால்களிலிருக்கும் இரத்தத்தைக் காண்பார். அப்போது கர்த்தர் அந்த வீட்டைப் பாதுகாப்பார். அழிக்கிறவன் உங்கள் வீட்டுக்குள் வந்து, உங்களைச் சேதப்படுத்த கர்த்தர் அவனை விடமாட்டார். ");
INSERT INTO tam2008_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","நீங்கள் இக்கட்டளையை நினைவுகூர வேண்டும். உங்களுக்கும், உங்கள் சந்ததிக்கும் எந்நாளும் இது சட்டமாக இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","கர்த்தர் உங்களுக்குக் கொடுக்கிற தேசத்திற்குப் போன பிறகும் இதை நினைவுகூர்ந்து செய்ய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","உங்கள் பிள்ளைகள், ‘நீங்கள் ஏன் இந்த பண்டிகையைக் கொண்டாடுகிறீர்கள்?’ என்று உங்களைக் கேட்டால், ");
INSERT INTO tam2008_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","நீங்கள், ‘இந்தப் பஸ்காப் பண்டிகை கர்த்தரை மகிமைப்படுத்துவதற்குரியதாகும். ஏனெனில், நாங்கள் எகிப்தில் வாழ்ந்தபோது கர்த்தர் இஸ்ரவேலரின் வீடுகளைக் கடந்து சென்று எகிப்தியர்களைக் கொன்றார், ஆனால் அவர் நமது வீடுகளின் ஜனங்களைக் காப்பாற்றினார்.’ என்று கூறுங்கள்” என்றார். ஜனங்கள் கர்த்தரைப் பணிந்து தொழுதுகொள்கிறார்கள் ");
INSERT INTO tam2008_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","கர்த்தர் இந்தக் கட்டளையை மோசேக்கும், ஆரோனுக்கும் கொடுத்தார். எனவே இஸ்ரவேல் ஜனங்கள் கர்த்தர் கட்டளையிட்டவற்றைச் செய்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","நள்ளிரவில் கர்த்தர் எகிப்தின் முதற்பேறானவர்களை, எகிப்தை ஆண்ட பார்வோனின் முதல் மகனிலிருந்து, சிறையிலுள்ள கைதியின் முதல் மகன் வரைக்கும் எல்லோரையும் அழித்தார். எல்லா முதற் பேறான மிருகங்களும் மரித்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","அந்த இரவில் எகிப்தின் ஒவ்வொரு வீட்டிலும் யாராவது ஒருவர் மரித்தனர். பார்வோனும், அவனது அதிகாரிகளும், எகிப்தின் எல்லா ஜனங்களும் சத்தமிட்டு அழுதனர். ");
INSERT INTO tam2008_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","அந்த இரவில் பார்வோன் மோசேயையும், ஆரோனையும் வரவழைத்தான். பார்வோன் அவர்களிடம், “எழுந்து என் ஜனங்களை விட்டு விலகிப்போங்கள். நீங்கள் கூறுகிறபடியே நீங்களும் உங்கள் ஜனங்களும் செய்யலாம். போய்க் கர்த்தரைத் தொழுதுகொள்ளுங்கள்! ");
INSERT INTO tam2008_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","உங்கள் ஆடுகளையும், மாடுகளையும் நீங்கள் கூறியபடியே உங்களோடு எடுத்துச் செல்லலாம், போங்கள்! என்னையும் ஆசீர்வதியுங்கள்!” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","எகிப்தின் ஜனங்களும் அவர்களை விரைந்து போகும்படிக் கேட்டுக்கொண்டனர். அவர்கள், “நீங்கள் போகா விட்டால், நாங்கள் அனைவரும் மரித்துப் போவோம்!” என்று கூறினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","இஸ்ரவேல் ஜனங்கள் ரொட்டியைப் புளிக்கச் செய்வதற்கும் நேரமிருக்கவில்லை. மாவிருந்த கிண்ணங்களைத் துணியால் பொதிந்து அவர்கள் தங்கள் தோள்களில் சுமந்து சென்றனர். ");
INSERT INTO tam2008_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","பிறகு இஸ்ரவேல் ஜனங்கள் மோசே கூறியபடியே செயல்பட்டனர். அவர்கள் அக்கம் பக்கத்தாராகிய எகிப்தியரிடம் சென்று ஆடைகளையும், பொன் மற்றும் வெள்ளி பொருட்களையும் கேட்டார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","இஸ்ரவேல் ஜனங்கள் மீது எகிப்தியர்களுக்கு இரக்கம் உண்டாகுமாறு கர்த்தர் செய்தார். எனவே எகிப்தியர்கள் தங்கள் விலையுயர்ந்த பொருட்களை இஸ்ரவேல் ஜனங்களுக்குக் கொடுத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","ராமசேசிலிருந்து சுக்கோத்துக்கு இஸ்ரவேல் ஜனங்கள் பிரயாணம் செய்தனர். சமார் 6,00,000 புருஷர்கள் இருந்தனர். குழந்தைகள் இந்த எண்ணிக்கையில் சேர்க்கப்படவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","ஆடுகளும், மாடுகளும், பிற பொருட்களும் மிக அதிகமாக இருந்தன. அவர்களோடு இஸ்ரவேலர் அல்லாத வெவ்வேறு இனத்து ஜனங்களும் பயணம் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","ரொட்டி மாவை புளிக்கவைக்க ஜனங்களுக்கு நேரம் இருக்கவில்லை. பயணத்திற்காக எந்த விசேஷ உணவையும் அவர்கள் தயாரிக்கவில்லை. எனவே புளிப்பற்ற ரொட்டியையே சுட்டார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","இஸ்ரவேல் ஜனங்கள் எகிப்தில் 430 ஆண்டுகள் வாழ்ந்திருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","சரியாக 430 ஆண்டுகளுக்குப் பிறகு, அந்த நாளில் கர்த்தரின் சேனைகள் எகிப்தை விட்டுச் சென்றனர். ");
INSERT INTO tam2008_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","கர்த்தர் செய்ததை ஜனங்கள் நினைவுகூரும் அந்த இரவு விசேஷமா னது. இஸ்ரவேலின் ஜனங்கள் எல்லாரும் எந்நாளும் அந்த இரவை நினைவுகூருவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","கர்த்தர் மோசேயையும், ஆரோனையும் நோக்கி, “பஸ்கா பண்டிகையின் விதிகள் இவை: அந்நியன் யாரும் பஸ்காவை உண்ணக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ஆனால் ஒருவன் ஒரு அடிமையை வாங்கி அவனுக்கு விருத்த சேதனம் செய்வித்தால், அந்த அடிமை பஸ்காவை உண்ணலாம். ");
INSERT INTO tam2008_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","ஆனால் ஒருவன் உங்கள் நாட்டில் வாழ்ந்தாலும், கூலி வேலைக்கு உங்களால் அமர்த் தப்பட்டவனாக இருந்தாலும், அம்மனிதன் பஸ்கா உணவை உண்ணக்கூடாது, இஸ்ரவேல் ஜனங்களுக்கு மட்டுமே பஸ்கா உரியது. ");
INSERT INTO tam2008_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“ஒவ்வொரு குடும்பமும் அவர்கள் வீட்டில் அவ்வுணவை உண்ண வேண்டும். வீட்டிலிருந்து வெளியே அவ்வுணவை எடுத்துச் செல்லக் கூடாது. ஆட்டுக்குட்டியின் எலும்புகளை முறிக்க வேண்டாம். ");
INSERT INTO tam2008_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","இஸ்ரவேலின் எல்லா ஜனங்களும் இப் பண்டிகையைக் கொண்டாட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","உங்களோடு வசிக்கும் இஸ்ரவேலன் அல்லாத ஒருவன் கர்த்தரின் பஸ்காவில் பங்கு கொள்ள விரும்பினால், அவனுக்கு விருத்தசேதனம் செய்ய வேண்டும். அப் போது அவன் இஸ்ரவேலின் குடிமகனாகக் கருதப் படுவான். அவன் பஸ்கா உணவில் பங்கு கொள்ள முடியும். ஆனால் ஒரு மனிதன் விருத்தசேதனம் செய்துகொள்ளாவிட்டால், அவன் பஸ்கா உணவை உண்ண முடியாது. ");
INSERT INTO tam2008_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","இந்த விதிகள் எல்லோருக்கும் பொதுவானவை. இஸ்ரவேலின் குடி மகன் அல்லது உங்கள் நாட்டில் வசிக்கும் இஸ்ரவேல் அல்லாத எல்லோருக்கும் விதிகள் பொதுவானதாகவே இருக்கும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","கர்த்தர் மோசேக்கும், ஆரோனுக்கும் கொடுத்த கட்டளைகளின்படி இஸ்ரவேலின் ஜனங்கள் குழுக்களாக எல்லோரும் எகிப்தை விட்டுபோனார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","அதே நாளில் கர்த்தர் இஸ்ரவேல் ஜனங்களை எகிப்திலிருந்து வெளியே வழிநடத்தினார். ஜனங்கள் குழுக்களாக புறப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","பிறகு கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“இஸ்ரவேலில் ஒரு தாயின் வயிற்றில் பிறக்கும் முதல் ஆண் குழந்தை ஒவ்வொன்றும் எனக்குரியதாகும். முதலில் பிறந்த ஒவ்வொரு ஆண் குழந்தையும், முத லில் பிறந்த ஒவ்வொரு விலங்கும் எனக்குரியதாகும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","அப்போது மோசே ஜனங்களிடம், “இந்த நாளை நினைவுகூருங்கள். நீங்கள் எகிப்தில் அடிமைகளாக இருந்தீர்கள். ஆனால் இந்த நாளில் கர்த்தர் அவரது மிகுந்த வல்லமையைப் பயன்படுத்தி உங்களை விடுதலை செய்தார். நீங்கள் புளிப்புள்ள ரொட்டியை உண்ணக்கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","ஆபீப் மாதத்தின் இந்த நாளில் நீங்கள் எகிப்தை விட்டுச் செல்கிறீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","கர்த்தர் உங்கள் முற்பிதாக்களுக்கு ஒரு விசேஷமான வாக்குறுதியை அளித்தார். கானானியர், ஏத்தியர், எமோரியர், ஏவியர், எபூசியர் ஜனங்களின் நாட்டை உங்களுக்குக் கொடுப்பதாகக் கர்த்தர் வாக்களித்தார். நல்ல பொருட்களால் நிரப்பப்பட்ட நாட்டிற்குக் கர்த்தர் உங்களை வழிநடத்திய பிறகும் நீங்கள் இந்த நாளை நினைவுகூர வேண்டும். ஒவ்வொரு ஆண்டும் முதல் மாதத்தின் இந்த நாளை வழிபாட்டிற்குரிய விசேஷ தினமாகக் கொள்ள வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","“புளிப்பு இல்லாத ரொட்டியையே ஏழு நாட்களுக்கு நீங்கள் உண்ண வேண்டும். ஏழாவது நாளில் ஒரு பெரிய விருந்து கர்த்தரை மகிமைப்படுத்துவதற்காக நடைபெறும். ");
INSERT INTO tam2008_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","எனவே ஏழு நாட்கள் புளிப்புள்ள ரொட்டியை நீங்கள் உண்ணவே கூடாது. உங்கள் தேசத்தில் எப்பக்கத்திலும் புளிப்புள்ள ரொட்டி இருக்கவே கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","இந்த நாளில் உங்கள் பிள்ளைகளுக்கு, ‘கர்த்தர் நம்மை எகிப்திலிருந்து வழிநடத்தியதால் இந்த விருந்து நடைப்பெறுகிறது’ என்று சொல்ல வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","“உங்கள் கண்களின் முன்னால் இது அடையாளமாக இருக்கும். இந்த பண்டிகை நாள் கர்த்தரின் போதனைகளை நினைவுபடுத்தவும், உங்களை எகிப்திலிருந்து வெளியே கொண்டுவர கர்த்தர் தமது பெரும் வல்லமையைப் பயன்படுத்தினார் என்பதை நினைவுபடுத்தவும் இது உதவும். ");
INSERT INTO tam2008_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","எனவே ஒவ்வொரு ஆண்டும் அதன் காலத்தில் இந்த விடுமுறை நாளை நினைவு கூருங்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“உங்களுக்குக் கொடுப்பதாகக் கர்த்தர் வாக்களித்த தேசத்திற்கு அவர் உங்களை வழிநடத்துவார். கானானிய ஜனங்கள் இப்போது அங்கு வாழ்கிறார்கள். இத்தேசத்தை உங்களுக்குக் கொடுப்பதாக தேவன் உங்கள் முற்பிதாக்களுக்கு வாக்களித்தார்.” தேவன் இந்நாட்டை உங்களுக்குக் கொடுத்தபிறகு, ");
INSERT INTO tam2008_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","நீங்கள் உங்கள் முதல் மகனை அவருக்குக் கொடுக்க வேண்டும் என்பதை நினைவு கூருங்கள். முதலில் பிறந்த எந்த ஆண் மிருகத்தையும் கர்த்தருக்குக் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","முதலில் பிறந்த ஒவ்வொரு ஆண் கழுதையையும் கர்த்தரிடமிருந்து திரும்பப்பெற்று, அதற்குப் பதிலாக ஒரு ஆட்டுக்குட்டியைக் கொடுக்கவேண்டும். கர்த்தரிடமிருந்து கழுதையை வாங்க உங்களுக்கு விருப்பமில்லையென்றால், அதனைக் கொன்றுவிடுங்கள். அது ஒரு பலியாகும். நீங்கள் அதன் கழுத்தை முறிக்க வேண்டும். முதலில் பிறக்கும் ஒவ்வொரு ஆண் குழந்தையையும் கர்த்தரிடமிருந்து திரும்பப் பெற வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“வருங்காலத்தில் நீங்கள் இதைச் செய்வதன் காரணத்தை அறியும்படி உங்கள் பிள்ளைகள், ‘இதன் பொருள் என்ன?’ என்று கேட்பார்கள். நீங்கள் அவர்களிடம்: ‘கர்த்தர் தமது மகா வல்லமையைப் பயன்படுத்தி நம்மை எகிப்திலிருந்து மீட்டார். நாம் அந் நாட்டில் அடிமைகளாக இருந்தோம். ஆனால் கர்த்தர் நம்மை இங்கு வழிநடத்தினார். ");
INSERT INTO tam2008_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","எகிப்தில், பார்வோன் பிடிவாதமாக இருந்தான். நாம் புறப்படுவதற்கு அவன் அனுமதி கொடுக்வில்லை. எனவே கர்த்தர் அந்நாட்டின் முதலாவதாகப் பிறந்த எல்லா உயிரினங்களையும் கொன்றார். (கர்த்தர் முதலில் பிறந்த மகன்களையும், முதலில் பிறந்த மிருகங்களையும் கொன்றார்.) எனவே நான் முதலில் பிறந்த ஆண் மிருகத்தைக் கர்த்தருக்குக் கொடுக்கிறேன், எல்லா முதலில் பிறந்த ஆண் பிள்ளைகளையும் கர்த்தரிடமிருந்து திரும்பப் பெறுகிறேன்!’ என்று நீங்கள் பதில் கூறுவீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","இது உங்கள் கையில் கட்டப்பட்ட ஒரு குறியீடு போலவும், உங்கள் கண்களுக்கு நடுவில் தொங்கும் ஒரு அடையாளமாகவும் காணப்படும். கர்த்தர் தமது அளவில்லா வல்லமையினால் நம்மை எகிப்திலிருந்து வெளியே கொண்டு வந்தார் என்பதை நீங்கள் நினைவுகூர இது உதவும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","பார்வோன் இஸ்ரவேல் ஜனங்களை எகிப்திலிருந்து வெளியேற்றினான். பெலிஸ்தரின் நாட்டின் வழியாக ஜனங்கள் பயணம் செய்வதைக் கர்த்தர் அனுமதிக்கவில்லை. கடலின் ஓரமாக உள்ள அந்த சாலை குறுக்கு சாலையாக இருந்தது. ஆனால் கர்த்தர், “அவ்வழியே ஜனங்கள் பயணத்தை மேற் கொண்டால் அவர்கள் போரிட வேண்டியிருக்கும். அதனால் தங்கள் எண்ணத்தை மாற்றி, எகிப்திற்குத் திரும்பிப் போகக்கூடும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","ஆகவே கர்த்தர் அவர்களை வேறு வழியாக நடத்திச் சென்றார். செங்கடல் அருகே பாலைவனத்தின் நடுவே அவர்களை வழிநடத்தினார். இஸ்ரவேல் ஜனங்கள் எகிப்தைவிட்டுப் புறப்பட்டபோது சண்டைக்கு ஆயத்தமான ஆடைகளை அணிந்திருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","யோசேப்பின் எலும்புகளை மோசே தன்னோடு எடுத்துச் சென்றான். (யோசேப்பு மரிக்கும் முன்னர் இஸ்ரவேலின் ஜனங்களிடம் இதைச் செய்ய வேண்டுமென வாக்குறுதி பெற்றிருந்தான். யோசேப்பு, “தேவன் உங்களை மீட்கும்போது, எனது எலும்புகளை எகிப்திலிருந்து வெளியே எடுத்துச் செல்ல வேண்டுமென்பதை நினைவில் வையுங்கள்” என்று கூறியிருந்தான்.) ");
INSERT INTO tam2008_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","இஸ்ரவேல் ஜனங்கள் சுக்கோத்தை விட்டு நீங்கி ஏத்தாமில் தங்கினார்கள். ஏத்தாம் பாலைவனத்தினருகே இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","கர்த்தர் பாதை காட்டினார். பகலில், கர்த்தர் ஜனங்களை வழிநடத்த உயரமான ஒரு மேகத்தையும், இரவு வேளையில் வழிநடத்த உயரமான ஒரு நெருப்புதூணையும் பயன்படுத்தினார். அவர்கள் இரவிலும் பயணம் செய்வதற்கேதுவாக இந்த நெருப்பு வெளிச்சம் தந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","உயர்ந்த மேகம் பகல் முழுவதும், உயர்ந்த நெருப்பு தூண் இரவு முழுவதும் அவர்களோடிருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","அப்போது கர்த்தர் மோசேயை நோக்கி, ");
INSERT INTO tam2008_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“ஜனங்களிடம் ஈரோத்துக்கு திரும்பிப் போகும்படியாகக் கூறு. பாகால் செபோனுக்கு அருகேயுள்ள மிக்தோலுக்கும் செங்கடலுக்கும் மத்தியில் அவர்கள் இரவில் தங்கட்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","இஸ்ரவேல் ஜனங்கள் பாலைவனத்தில் காணாமற்போனார்கள் என்று பார்வோன் எண்ணுவான். ஜனங்களுக்குப் போகத்தக்க இடம் எதுவுமில்லை என்று அவன் நினைப்பான். ");
INSERT INTO tam2008_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","பார்வோனுக்குத் தைரியம் தந்து, அவன் உங்களைத் துரத்தும்படியாகச் செய்வேன். ஆனால் நான் பார்வோனையும் அவனது சேனையையும் தோற்கடிப்பேன். அது எனக்கு கனத்தைக் கொண்டுவரும். அப்போது எகிப்திய ஜனங்கள் நானே கர்த்தர் என்பதை அறிவார்கள்” என்றார். இஸ்ரவேல் ஜனங்கள் தேவனுக்குக் கீழ்ப்படிந்தார்கள். அவர் கூறினபடியே அவர்கள் செய்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","இஸ்ரவேல் ஜனங்கள் தப்பிச் சென்றுவிட்டார்கள் என்ற செய்தி பார்வோனுக்குக் கிடைத்தது. இதைக் கேட்டபோது அவனும், அவனது அதிகாரிகளும் மனம்மாறி முன்பு செய்த தங்கள் செயல்களை மறு பரிசீலனை செய்தனர். பார்வோன், “இஸ்ரவேல் ஜனங்கள் போவதற்கு ஏன் அனுமதித்தோம்? அவர்கள் ஓடிப்போவதற்கு ஏன் வகை செய்தோம்? இப்போது நாம் நமது அடிமைகளை இழந்துபோனோம்!” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","எனவே, பார்வோன் தனது ஆட்களோடு தேரையும் தயார்ப்படுத்தினான். ");
INSERT INTO tam2008_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","பார்வோன் அவனது சிறந்த 600 ஆட்களையும், அவனது இரதங்கள் அனைத்தையும் கூட்டிச் சென்றான். ஒவ்வொரு தேரிலும் ஒரு அதிகாரி இருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","வெற்றிக் களிப்போடு தங்கள் கைகளை உயர்த்தியவர்களாய் இஸ்ரவேல் ஜனங்கள் புறப்பட்டுச் சென்றுகொண்டிருந்தனர். ஆனால் எகிப்திய அரசனாகிய பார்வோன் தைரியம் கொள்ளும்படியாக கர்த்தர் செய்தார். பார்வோன் இஸ்ரவேல் ஜனங்களைத் துரத்தினான். ");
INSERT INTO tam2008_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","எகிப்திய படையில் இரதங்களோடு கூடிய பல குதிரை வீரர்கள் இருந்தனர். அவர்கள் இஸ்ரவேல் ஜனங்களைப் பின் தொடர்ந்து அவர்கள் செங்கடலின் அருகேயுள்ள பாகால் செபோனுக்குக் கிழக்கேயிருக்கிற ஈரோத்தில் இருக்கும்போது நெருங்கி வந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","பார்வோனும் அவனது படையினரும் தங்களை நோக்கி வருவதை இஸ்ரவேல் ஜனங்கள் கண்டு மிகவும் பயந்தனர். அவர்கள் கர்த்தரிடம் உதவி வேண்டினர். ");
INSERT INTO tam2008_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","அவர்கள் மோசேயை நோக்கி, “நீர் ஏன் எங்களை எகிப்திலிருந்து அழைத்து வந்தீர்? பாலைவனத்தில் சாகும்படியாக ஏன் எங்களை அழைத்துக் கொண்டு வந்தீர்? எகிப்தில் நிம்மதியாக மரித்திருப்போம். எகிப்தில் நிறைய கல்லறைகள் இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","இவ்வாறு நடக்குமென நாங்கள் உங்களிடம் கூறினோம். எகிப்தில் இருந்தபோது நாங்கள், ‘எங்களைத் தொல்லைப்படுத்தாதீர்கள். நாங்கள் தங்கியிருந்து எகிப்தியருக்கு அடிமை வேலை செய்வோம்’ என்றோம். அங்கிருந்து வெளியேறி பாலைவனத்தில் இங்கு மடிவதைக் காட்டிலும் அங்கு தங்கி அடிமைகளாக இருப்பதே நலமாக இருந்திருக்கும்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","ஆனால் மோசே, “பயப்படாதீர்கள்! ஓடிப் போகாதீர்கள்! சும்மா இருந்து, கர்த்தர் இன்றைக்கு உங்களை மீட்பதைப் பாருங்கள். இந்த எகிப்தியர்களை இனிமேல் பார்க்கமாட்டீர்கள்! ");
INSERT INTO tam2008_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","நீங்கள் எதையும் செய்யாமல் அமைதியாக இருந்தால் போதும், கர்த்தர் உங்களுக்காகப் போரிடுவார்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","கர்த்தர் மோசேயை நோக்கி, “ஏன் இன்னும் நீ என்னிடம் அழுகிறாய்? இஸ்ரவேல் ஜனங்கள் தங்கள் பயணத்தைத் தொடருமாறு கூறு. ");
INSERT INTO tam2008_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","செங்கடலுக்கு மேலாக உன் கைத்தடியை உயர்த்து. கடல் பிளக்கும். அப்போது ஜனங்கள் அதிலுள்ள உலர்ந்த தரை வழியே நடந்து செல்லலாம். ");
INSERT INTO tam2008_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","உங்களைத் துரத்தும்படியாக நானே எகிப்தியருக்குத் தைரியம் அளித்தேன். ஆனால் நானே பார்வோனையும், அவனது குதிரைகள் இரதங்களைக் காட்டிலும் வல்லமை பொருந்தியவர் என்று உணரச் செய்வேன். ");
INSERT INTO tam2008_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","அப்போது எகிப்தியர் நானே கர்த்தர் என்பதை அறிவார்கள். பார்வோனையும் அவனது இரதம் குதிரை வீரர்களையும் நான் மேற்கொள்ளும்போது அவர்கள் என்னை மதிப்பார்கள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","அப்போது கர்த்தருடைய தூதன் ஜனங்களுக்குப் பின்னாகப் போனான். (கர்த்தருடைய தூதன் எப்போதும் ஜனங்களுக்கு முன்னே, அவர்களை வழிநடத்தியபடியே சென்று கொண்டிருந்தான்). அந்த உயரமான மேகம் ஜனங்களுக்கு முன்னே செல்லாமல் அவர்களுக்கு பின்னே சென்றது. ");
INSERT INTO tam2008_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","இவ்வாறு அம்மேகம் எகிப்தியருக்கும் இஸ்ரவேல் ஜனங்களுக்கும் இடையே சென்று நின்றது. இஸ்ரவேல் ஜனங்களுக்கு வெளிச்சம் இருந்தது. ஆனால் எகிப்தியர்களையோ இருள் சூழ்ந்தது. எனவே அந்த இரவில் எகிப்தியர்கள் இஸ்ரவேல் ஜனங்களை நெருங்கிவர முடியவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","மோசே தனது கரங்களைச் செங்கடலுக்கு நேராக உயர்த்தினான். கர்த்தர் கிழக்கிலிருந்து ஒரு காற்று வீசும்படியாகச் செய்தார். இரவு முழுவதும் காற்று வீசிற்று, கடல் பிளந்தது. காற்று நிலத்தை உலரச் செய்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","இஸ்ரவேல் ஜனங்கள் உலர்ந்த தலையின் மேல் கடலினூடே போனார்கள். அவர்களுக்கு வலது பக்கத்திலும் இடது பக்கத்திலும் தண்ணீர் சுவர்போல் உயர்ந்து நின்றது. ");
INSERT INTO tam2008_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","அப்போது பார்வோனின் குதிரை வீரர்கள் தங்கள் இரதங்களுடன் கடலினுள் இஸ்ரவேலரைப் பின்தொடர ஆரம்பித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","அதிகாலையில் கர்த்தர் உயர்ந்த மேகத்திலிருந்தும், நெருப்புத் தூணிலிருந்தும் எகிப்திய படையை நோக்கிப் பார்த்து அவர்களைத் தோற்கடித்தார். ");
INSERT INTO tam2008_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","இரதங்களின் சக்கரங்கள் சிக்கிக்கொண்டன. இரதங்களைக் கட்டுப்படுத்துவது கடினமாக இருந்தது. எகிப்தியர்கள், “இங்கிருந்து தப்பிப் போவோம்! இஸ்ரவேல் ஜனங்களுக்காகக் கர்த்தர் நம்மை எதிர்த்து போர் செய்கிறார்” என்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","அப்போது கர்த்தர் மோசேயிடம், “உன் கைகளைக் கடலுக்கு மேலாக உயர்த்து, தண்ணீர் புரண்டு எகிப்தியரின் இரதங்களையும் குதிரை வீரர்களையும் மூழ்கடிக்கும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","எனவே விடிவதற்குச் சற்றுமுன் மோசே கடலுக்கு மேலாகத் தன் கரங்களை உயர்த்தினான். தண்ணீர் முன்புபோல் சமமாக வந்து நின்றது. எகிப்தியர்கள் தங்களால் முடிந்த அளவு தண்ணீரிலிருந்து தப்பி ஓட முயன்றார்கள். ஆனால் கர்த்தர் அவர்களைக் கடலில் மூழ்கடித்துவிட்டார். ");
INSERT INTO tam2008_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","தண்ணீர் முன்பு போல் சமமாக வந்ததால் இரதங்களையும், குதிரை வீரர்களையும் மூழ்கடித்து விட்டது. பார்வோனின் படையினர் இஸ்ரவேல் ஜனங்களைத் துரத்தினர், ஆனால் அப்படையோ அழிக்கப்பட்டது, ஒருவரும் பிழைக்கவில்லை! ");
INSERT INTO tam2008_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","இஸ்ரவேல் ஜனங்கள் உலர்ந்த தரையில் கடலைக் கடந்தனர். அவர்களது வலது, இடது புறங்களில் மாத்திரம் தண்ணீர் சுவரைப்போல நின்றது. ");
INSERT INTO tam2008_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","எனவே, அந்நாளில் எகிப்தியரிடமிருந்து இஸ்ரவேல் ஜனங்களை கர்த்தர் மீட்டார். செங் கடலின் கரையில் எகிப்தியரின் பிணங்களை இஸ்ரவேல் ஜனங்கள் கண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","கர்த்தர் எகிப்தியர்களை வென்றபோது, இஸ்ரவேல் ஜனங்கள் கர்த்தரின் மிகுந்த வல்லமையைக் கண்டார்கள். எனவே ஜனங்கள் பயந்து கர்த்தரை மதித்தார்கள். அவர்கள் கர்த்தரையும் அவரது தாசனாகிய மோசேயையும் நம்ப ஆரம்பித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","அப்போது மோசேயும் இஸ்ரவேல் ஜனங்களும் கர்த்தரை நோக்கி பின்வரும் பாடலைப் பாடினார்கள்: “நான் கர்த்தரைப் பாடுவேன்! அவர் பெருமைமிக்க செயல்களைச் செய்தார், அவர் குதிரையையும், குதிரை வீரனையும் கடலில் தள்ளினார். ");
INSERT INTO tam2008_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","கர்த்தரே எனது பலம். அவர் என்னை மீட்கிறார். நான் அவரைத் துதித்துப்பாடுவேன் கர்த்தரே எனது தேவன், நான் அவரைத் துதிப்பேன். கர்த்தர் எனது முற்பிதாக்களின் தேவன். நான் அவரை மதிப்பேன். ");
INSERT INTO tam2008_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","கர்த்தர் யுத்தத்தில் சிறந்தவர், கர்த்தர் என்பது அவரது பெயர். ");
INSERT INTO tam2008_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","பார்வோனின் இரதங்களையும், வீரர்களையும் அவர் கடலில் தள்ளினார். பார்வோனின் சிறந்த வீரர்கள் செங்கடலில் அமிழ்ந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","ஆழியின் தண்ணீர் அவர்களை மூடிக்கொண்டது. அவர்கள் கடலினடியில் பாறைகளைப்போல் மூழ்கிப்போயினர். ");
INSERT INTO tam2008_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","7","“உமது வலது கரம் வியக்கத்தகும் வல்லமை உடையது. கர்த்தாவே, உமது வலது கரம் பகைவர்களைச் சிதறடித்தது. உமது பெருமையால் உமக்கு எதிராக நின்ற ஜனங்களை நீர் அழித்தீர். உமது கோபம் அவர்களை வைக்கோலில் பற்றும் நெருப்பைப் போல அழித்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","உமது உக்கிரத்தின் பெருமூச்சால் தண்ணீர் மேலெழும்பிற்று, ஒழுகும் தண்ணீர் திடமான சுவராயிற்று. ஆழத்தின் அஸ்திபாரம்வரைக்கும் கடல் தண்ணீர் திடன் கொண்டது. ");
INSERT INTO tam2008_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“நான் தொடர்ந்து பிடிப்பேன், ‘நான் அவர்கள் செல்வத்தைப் பறிப்பேன். எனது வாளால் அவற்றை அபகரிப்பேன். நான் எல்லாவற்றையும் எனக்காக எடுப்பேன்’ என்று பகைவன் சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","ஆனால் நீர் அவர்கள் மேல் ஊதி, கடலால் அவர்களை மூடினீர். ஆழ்கடலில் அவர்கள் ஈயத்தைப் போல மூழ்கினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“கர்த்தரைப்போன்ற தேவர்கள் உள்ளனரோ? இல்லை! உம்மைப்போன்ற தேவர்கள் எவருமில்லை! நீர் மேலான பரிசுத்தமானவர்! நீர் வியக்கத்தக்க ஆற்றல் வாய்ந்தவர்! நீர் மாபெரும் அற்பு தங்கள் செய்பவர்! ");
INSERT INTO tam2008_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","வலதுகரத்தை உயர்த்தி உலகத்தை அழிக்க உம்மால் முடியும். ");
INSERT INTO tam2008_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","ஆனால் உமது இரக்கத்தால் நீர் மீட்ட ஜனங்களை வழிநடத்துகிறீர். உமது வல்லமையால் அவர்களைப் பரிசுத்தமும், இன்பமுமான நாட்டிற்குள் நடத்துகிறீர். ");
INSERT INTO tam2008_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","“பிற ஜாதிகள் இதைக் கேட்டு, பயந்து நடுங்குவார்கள். பெலிஸ்தியர் பயத்தால் நடுங்குவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ஏதோமின் தலைவர்கள் பயத்தால் நடுங்குவார்கள். மோவாபின் தலைவர் பயத்தால் நடுங்குவார்கள். கானானின் ஜனங்கள் துணிவிழப்பார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","அவர்கள் உமது ஆற்றலைக் காண்கையில் அச்சத்தால் நிரம்புவார்கள். கர்த்தரின் ஜனங்கள் செல்லும்மட்டும், உம்மால் உண்டாக்கப்பட்ட உமது ஜனங்கள் கடந்து செல்லும்மட்டும் அவர்கள் உறுதியான பாறையைப் போல ஸ்தம்பித்து நிற்பார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","கர்த்தாவே நீர் உம்முடைய ஜனங்களை உம்முடைய மலைக்கு வழிநடத்துவீர். உமது சிங்காசனத்திற்காக நீர் தேர்ந்தெடுத்த இடத்தினருகே அவர்களை வாழச்செய்வீர். ஆண்டவரே, நீர் உமது ஆலயத்தைக் கட்டுவீர்! ");
INSERT INTO tam2008_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“கர்த்தாவே நீர் என்றென்றும் ஆளுகை செய்வீர்!” ");
INSERT INTO tam2008_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","ஆம், அது உண்மையாகவே நிகழ்ந்தது! பார்வோனின் குதிரைகளும், வீரர்களும், இரதங்களும் கடலுக்குள் அமிழ்ந்தன. கடலின் ஆழத்து தண்ணீரை அவர்களுக்கு மேலாகக் கர்த்தர் கொண்டு வந்தார். ஆனால் இஸ்ரவேல் ஜனங்களோ கடலினூடே உலர்ந்த தரையில் நடந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","அப்போது, தீர்க்கதரிசினியும், ஆரோனின் சகோதரியுமாகிய மிரியாம் ஒரு தம்புருவை எடுத்தாள். மிரியாமுடன் பெண்கள் பாடவும் நடனம் ஆடவும் செய்தனர். மிரியாம், ");
INSERT INTO tam2008_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","“கர்த்தரைப் பாடுங்கள்! அவர் பெரிய செயல்களைச் செய்தார். அவர் குதிரையையும், குதிரை வீரனையும் கடலுக்குள் அமிழ்த்தினார்” என்று பாடினாள். ");
INSERT INTO tam2008_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","செங்கடலை விட்டு சூர் பாலைவனத்திற்குள் மோசே இஸ்ரவேல் ஜனங்களை வழிநடத்திச் சென்றான். அவர்கள் பாலைவனத்தில் மூன்று நாட்கள் பயணம் செய்தனர். ஜனங்களுக்குக் குடிப்பதற்கு அங்கு தண்ணீர் கிடைக்கவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","மூன்று நாட்களுக்குப் பின் ஜனங்கள் மாராவிற்கு வந்தனர். மாராவில் தண்ணீர் இருந்தது. ஆனால் குடிக்க முடியாதபடி கசப்பாக இருந்தது. (இதனால் அந்த இடம் மாரா என்று அழைக்கப்பட்டது) ");
INSERT INTO tam2008_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","மோசேயிடம் வந்து ஜனங்கள், “நாங்கள் இப்போது எதைக் குடிப்போம்?” என்று முறையிட ஆரம்பித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","மோசே கர்த்தரை வேண்டினான், கர்த்தர் அவனுக்கு ஒரு மரத்தைக் காட்டினார். மோசே அம்மரத்தை தண்ணீருக்குள் போட்டான். அவன் அவ்வாறு செய்தபோது, அது நல்ல குடிதண்ணீராக மாறிற்று. அவ்விடத்தில், கர்த்தர் ஜனங்களை நியாயந்தீர்த்து அவர்களுக்கு ஒரு சட்டத்தைக் கொடுத்தார். ஜனங்களின் நம்பிக்கையையும் சோதித்துப் பார்த்தார். ");
INSERT INTO tam2008_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","கர்த்தர், “நீங்கள் உங்கள் தேவனாகிய கர்த்தருக்குக் கீழ்ப்படிய வேண்டும். அவர் சரியெனக் கூறும் காரியங்களை நீங்கள் செய்யவேண்டும். கர்த்தரின் எல்லாக் கட்டளைகளுக்கும், சட்டங்களுக்கும் நீங்கள் கீழ்ப்படிந்தால், எகிப்தியர்களைப்போல நோயுறமாட்டீர்கள். கர்த்தராகிய நான் எகிப்தியருக்கு கொடுத்த எந்த நோயையும் உங்களுக்கு வரவிடமாட்டேன். நானே கர்த்தர். உங்களைக் குணப்படுத்துகிறவர் நான் ஒருவரே” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","பின்பு ஜனங்கள் ஏலிமுக்குப் பயணமாயினர். ஏலிமில் பன்னிரண்டு நீரூற்றுக்களும், எழுபது பேரீச்ச மரங்களும் இருந்தன. எனவே தண்ணீர் இருந்த இடத்தினருகே ஜனங்கள் கூடாரமிட்டுத் தங்கினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ஜனங்கள் ஏலிமை விட்டு ஏலிமுக்கும், சீனாய்க்கும் நடுவில் உள்ள சீன் பாலைவனத்திற்கு வந்தனர். எகிப்தைவிட்டுப் புறப்பட்டபின் இரண்டாவது மாதத்தில் பதினைந்தாம் நாள் அவர்கள் அந்த இடத்தை வந்தடைந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","இஸ்ரவேல் ஜனங்கள் மீண்டும் முறையிட ஆரம்பித்தனர். பாலைவனத்தில் மோசேயையும், ஆரோனையும் நோக்கி: ");
INSERT INTO tam2008_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","“எகிப்து தேசத்தில் கர்த்தர் எங்களைக் கொன்றிருந்தால் நலமாக இருந்திருக்கும். அங்கு உண்பதற்காவது மிகுதியான உணவு கிடைத்தது. எங்களுக்குத் தேவையான எல்லா உணவும் கிடைத்தன. ஆனால் இப்போது எங்களை நீர் பாலைவனத்திற்குள் கொண்டு வந்திருக்கிறீர். பசியால் இங்கு நாங்கள் எல்லோரும் செத்துப்போவோம்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","அப்போது கர்த்தர் மோசேயை நோக்கி, “நான் வானத்திலிருந்து உணவுப்பொருளை விழச் செய்வேன். நீங்கள் உண்பதற்கு அது உணவாகும். ஒவ்வொரு நாளும் ஜனங்கள் வெளியே போய் அவர்களுக்கு அந்தந்த நாளுக்கு மட்டும் தேவையான உணவைச் சேகரித்துவரவேண்டும். இப்படி நான் அவர்களைச் சோதித்து, என் ஆலோசனைகளைப் பின்பற்றுகிறார்களா என்று பார்ப்பேன். ");
INSERT INTO tam2008_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ஒவ்வொரு நாளும் ஜனங்கள் அந்த நாளுக்குத் தேவையான உணவை மட்டுமே சேகரிக்கவேண்டும்: ஆனால் வெள்ளிக் கிழமையன்று, ஜனங்கள் உணவைத் தயாரிக்கும் பொழுது, இரண்டு நாட்களுக்குப் போதுமான இருமடங்கு உணவு இருக்குமாறு பார்த்துக்கொள்ள வேண்டும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","மோசேயும், ஆரோனும் இஸ்ரவேல் ஜனங்களை நோக்கி, “இன்றிரவு நீங்கள் கர்த்தரின் வல்லமையைக் காண்பீர்கள். எகிப்திலிருந்து உங்களை அழைத்து வந்தவர் அவரே என்பதை நீங்கள் அறிவீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","நீங்கள் கர்த்தரிடம் முறையிட்டபோது அவர் உங்கள் முறையீட்டைக் கேட்டார். எனவே நாளைக் காலையில் கர்த்தரின் மகிமையைக் காண்பீர்கள். நீங்கள் எங்களிடம் முறையிட்டுக்கொண்டேயிருக்கிறீர்கள். இப்போது எங்களுக்குச் சற்று ஓய்வு கிடைக்கும்” என்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","மோசே தொடர்ந்து, “நீங்கள் முறையிட்டீர்கள், கர்த்தர் உங்கள் முறையீட்டைக் கேட்டார். எனவே இன்றிரவு கர்த்தர் உங்களுக்கு மாமிசம் கிடைக்கச் செய்வார். காலையில் உங்களுக்குத் தேவையான அப்பத்தைப் பெறுவீர்கள். நீங்கள் ஆரோனிடமும் என்னிடமும் முறையிட்டுக்கொண்டிருக்கிறீர்கள். நீங்கள் ஆரோனுக்கும் எனக்கும் எதிராக அல்ல, நீங்கள் கர்த்தருக்கெதிராகவே முறையிட்டீர்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","மோசே ஆரோனை நோக்கி, “இஸ்ரவேலின் ஜனங்களிடம் பேசு. அவர்களிடம், ‘கர்த்தருக்கு முன்பாக ஒருமித்து வாருங்கள். ஏனெனில் அவர் உங்கள் முறையீட்டைக் கேட்டார் என்று சொல்’” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","ஆரோன் இஸ்ரவேல் ஜனங்களிடம் பேசினான். அவர்கள் எல்லோரும் ஓரிடத்தில் கூடியிருந்தார்கள். ஆரோன் பேசும்போது, எல்லா ஜனங்களும் திரும்பிப் பாலைவனத்தை நோக்கினார்கள். மேகத்தில் கர்த்தரின் மகிமை வெளிப்படுவதைக் கண்டார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","கர்த்தர் மோசேயை நோக்கி, ");
INSERT INTO tam2008_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“இஸ்ரவேல் ஜனங்களின் முறையீட்டைக் கேட்டேன். எனவே அவர்களிடம் ‘இன்றிரவு நீங்கள் இறைச்சி உண்பீர்கள், காலையில் உங்களுக்கு வேண்டிய ரொட்டி கிடைக்கும். பிறகு உங்கள் தேவனாகிய கர்த்தரை நம்பலாம் என்று அறிவீர்கள்’ என்று சொல்லுங்கள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","அன்றிரவு, காடைப் பறவைகள் அவர்கள் தங்கியிருந்த இடத்தைச் சுற்றிலும் வந்து விழுந்தன. ஜனங்கள் இறைச்சிக்காக அவற்றைப் பிடித்தனர். காலையில் அவர்கள் தங்கியிருந்த இடத்திற்கு அருகே பனிபடர்ந்திருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","பனி மறைந்ததும் மெல்லிய அப்பம் போன்ற ஒரு பொருள் நிலத்தின் மேல் காணப்பட்டது. ");
INSERT INTO tam2008_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","இஸ்ரவேல் ஜனங்கள் ஒருவரையொருவர் நோக்கி, “இது என்ன?” என்றனர். அப்பொருள் என்ன என்று அவர்களுக்குத் தெரியாததினால், ஒருவருக்கொருவர் பேசிக்கொண்டனர். மோசே அவர்களை நோக்கி, “கர்த்தர் உங்களுக்கு உணவாகக் கொடுப்பது இதுவே. ");
INSERT INTO tam2008_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","ஒவ்வொருவனும் அவனவனுக்குத் தேவையான உணவை எடுத்துக்கொள்ள வேண்டும். உங்கள் குடும்பத்திலுள்ள ஒவ்வொருவனுக்கும் எட்டு கிண்ண அளவின்படி எடுத்துக்கொள்ள வேண்டும் என்று சொல்லுகிறார்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","எனவே இஸ்ரவேல் ஜனங்கள் அவ்வாறே செய்தார்கள். ஒவ்வொருவனும் இந்த உணவைச் சேகரித்துக்கொண்டான். சிலர் மற்றவர்களை விட அதிகமாக எடுத்துக்கொண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","ஜனங்கள் இந்த உணவைக் குடும்பத்திலுள்ள ஒவ்வொருவருக்கும் கொடுத்தார்கள். உணவை அளந்தபோது ஒவ்வொருவருக்கும் போதுமான அளவு இருந்தது. ஆனால் ஒருபோதும் அதிகப்படியான உணவு இருந்ததில்லை. ஒவ்வொருவனும் அவனுக்கும் அவனது குடும்பத்திற்கும் தேவையான உணவை மாத்திரம் சேகரித்துக்கொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","மோசே அவர்களை நோக்கி, “மறுநாள் உண்பதற்காக உணவை வைக்காதீர்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","ஆனால் ஜனங்கள் மோசேக்குக் கீழ்ப்படியவில்லை. சிலர் அடுத்த நாளுக்காகச் சிறிது உணவை எடுத்து வைத்தார்கள். அந்த உணவைப் புழுக்கள் அரித்தபடியால் துர்நாற்றம் வீச ஆரம்பித்தது. இவ்வாறு செய்தவர்கள்மேல் மோசே கோபங்கொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","ஒவ்வொரு நாள் காலையிலும் உணவைச் சேகரித்துக்கொண்டனர். ஒருவன் தான் சாப்பிடக் கூடிய அளவு உணவை எடுத்துக்கொண்டான். வெயில் ஏறினதும் உணவு உருகி மறைந்துபோனது. ");
INSERT INTO tam2008_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","வெள்ளியன்று, ஜனங்கள் இரண்டு மடங்கு உணவைச் சேர்த்தார்கள். ஒவ்வொருவருக்கும் 16 கிண்ண அளவு உணவைச் சேர்த்தார்கள். எனவே ஜனங்களின் தலைவர்கள் மோசேயிடம் வந்து இதனை அறிவித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","மோசே அவர்களை நோக்கி, “இவ்வாறு தான் நடக்கும் என்று கர்த்தர் கூறியிருக்கிறார். நாளை கர்த்தரை மகிமைப்படுத்தும் விசேஷ நாளாகிய ஓய்வுநாள் என்பதால் இவ்வாறு நிகழ்ந்தது. இன்றைக்குத் தேவையான எல்லா உணவையும் சமையுங்கள். மீதமாகும் உணவை நாளை காலைக்காக எடுத்து வையுங்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","எனவே மீதமான உணவை ஜனங்கள் மோசேக்குக் கீழ்ப்படிந்து அடுத்த நாளுக்காகப் பத்திரப்படுத்தினார்கள். அன்று அந்த உணவு கெட்டுப்போகவில்லை, புழுக்களும் அந்த உணவை அணுகவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","சனிக்கிழமையன்று மோசே ஜனங்களை நோக்கி, “இன்று ஓய்வுநாள், இது கர்த்தருக்கு மரியாதை செலுத்தும் விசேஷ நாள். எனவே உங்களில் ஒருவனும் வெளியே போகக்கூடாது. நேற்று சேர்த்து வைத்த உணவையே உண்ணுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ஆறு நாட்கள் நீங்கள் உணவைச் சேகரிக்கவேண்டும், ஆனால் வாரத்தின் ஏழாவதுநாள் ஓய்வுக்குரிய நாள். எனவே பூமியில் விசேஷ உணவு எதுவுமிராது” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","சனிக்கிழமையன்று சில ஜனங்கள் உணவைச் சேகரிக்கச் சென்றார்கள், ஆனால் அவர்களுக்கு உணவு எதுவும் கிடைக்கவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","அப்போது கர்த்தர் மோசேயை நோக்கி, “எனது கட்டளைகளுக்கும் போதனைகளுக்கும் கீழ்ப்படிய எத்தனை காலம் இந்த ஜனங்கள் மறுப்பார்கள்? ");
INSERT INTO tam2008_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","பார், உங்களுக்கு ஓய்ந்திருக்கும் நாளாக கர்த்தர் ஓய்வு நாளை உண்டாக்கினார். எனவே வெள்ளியன்று இரண்டு நாட்களுக்குத் தேவையான உணவைக் கர்த்தர் கொடுப்பார், பின் ஓய்வு நாளில் உங்களில் ஒவ்வொருவனும் ஓய்வெடுக்கவேண்டும். நீங்கள் இருக்குமிடத்திலேயே தங்கியிருங்கள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","எனவே ஜனங்கள் ஓய்வுநாளில் ஓய்வெடுத்துக்கொண்டார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","அந்த விசேஷ உணவை ஜனங்கள் “மன்னா” என்று அழைத்தார்கள். இந்த மன்னா தோற்றத்தில் சிறிய வெண்மையான கொத்து மல்லி விதைகளைப் போன்றிருந்தன. அவை ருசியில் தேனில் தோய்க்கப்பட்ட மெல்லிய வார்ப்புரொட்டி போன்று இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","மோசே, “கர்த்தர் உங்கள் சந்ததியினருக்காக ‘இந்த உணவில் எட்டு கிண்ணம் எடுத்து வையுங்கள். அப்போது, உங்களை எகிப்திலிருந்து அழைத்து செல்கையில் வனாந்திரத்தில் நான் உங்களுக்கு கொடுத்த உணவை உங்கள் தலைமுறையினர் பார்க்க முடியும்’ என்றார்” என்று சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","எனவே மோசே ஆரோனை நோக்கி, “ஒரு சிறிய ஜாடியை எடுத்து அதை 8 கிண்ணம் மன்னாவால் நிரப்பு. கர்த்தருக்கு முன் வைக்கும்படியாக அதைப் பத்திரப்படுத்து. அதை நமது சந்ததியினருக்காகவும் பாதுகாத்து வை” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","(கர்த்தர் மோசேக்குக் கட்டளையிட்டவாறே ஆரோன் செய்தான். உடன்படிக்கைப் பெட்டியின் முன்னால் அந்த ஜாடியை ஆரோன் வைத்தான்.) ");
INSERT INTO tam2008_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ஜனங்கள் 40 ஆண்டுகள் மன்னாவைச் சாப்பிட்டார்கள். ஓய்வுக்குரிய நாடாகிய, கானான் தேசத்தின் எல்லையை வந்தடையும் மட்டும் அவர்கள் மன்னாவைச் சாப்பிட்டார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(மன்னாவை அளப்பதற்காக அவர்கள் பயன்படுத்தியது ஒரு ஓமர். எட்டுக் கிண்ணங்கள் அளவு கொண்டது ஒரு ஓமர் ஆகும்.) ");
INSERT INTO tam2008_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","சீன் பாலைவனத்திலிருந்து இஸ்ரவேல் ஜனங்கள் எல்லோரும் சேர்ந்து பிரயாணம் செய்தார்கள். கர்த்தர் கட்டளையிட்டபடியே அவர்கள் ஓரிடத்திலிருந்து மற்றோரிடத்திற்குப் பயணமானார்கள். ரெவிதீமிற்கு ஜனங்கள் பிரயாணம் செய்து அங்கு கூடாரமிட்டுத் தங்கினார்கள். குடிக்கக் கூட ஜனங்களுக்கு அங்கே தண்ணீர் கிடைக்கவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","எனவே ஜனங்கள் மோசேக்கு எதிராக திரும்பி, அவனோடு வாதாட ஆரம்பித்தார்கள். “எங்களுக்குக் குடிப்பதற்கு தண்ணீர் தா” என்று ஜனங்கள் கேட்டார்கள். மோசே அவர்களை நோக்கி, “ஏன் எனக்கு எதிராகத் திரும்பினீர்கள்? ஏன் கர்த்தரை சோதிக்கிறீர்கள்? கர்த்தர் நம்மோடு வரவில்லை என்று நினைக்கிறீர்களா?” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","ஆனால் ஜனங்கள் மிகவும் தாகமாக இருந்தபடியால் மோசேயிடம் தொடர்ந்து முறையிட்டார்கள், “ஏன் எங்களை எகிப்திலிருந்து அழைத்து வந்தீர்? நாங்களும், எங்கள் பிள்ளைகளும், ஆடு மாடுகளும் தாகத்தால் மரித்துபோவதற்காகவா எங்களை அழைத்து வந்தீர்?” என்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","எனவே மோசே கர்த்தரிடம் சத்தமாக அழுது, “நான் இந்த ஜனங்களோடு என்ன செய்ய முடியும்? இவர்கள் என்னைக் கொல்லத் தயாராயிருக்கிறார்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","கர்த்தர் மோசேயை நோக்கி, “இஸ்ரவேல் ஜனங்களுக்கு முன்பாகப் போ, ஜனங்களின் மூப்பர்களில் (தலைவர்களில்) சிலரையும் உன்னோடு அழைத்துச் செல். உனது கைத்தடியையும் எடுத்துக்கொள். நைல் நதியை அடித்தபோது நீ பயன்படுத்திய தடி இதுவே. ");
INSERT INTO tam2008_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","உனக்கு முன்பாக ஓரேபிலுள்ள (சீனாய் மலையிலுள்ள) பாறையில் நான் இருப்பேன். உனது கைத்தடியால் பாறையை அடி, உடனே பாறையிலிருந்து தண்ணீர் சுரந்து வரும், அப்போது ஜனங்கள் அதைப் பருகலாம்” என்றார். மோசே அவ்வார்த்தைகளின்படியே செய்தான். இஸ்ரவேலின் மூப்பர்கள் (தலைவர்கள்) அதைப் பார்த்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","இவ்விடத்தில் ஜனங்கள் மோசேக்கு எதிராகத் திரும்பி கர்த்தரை சோதித்ததால் மோசே அதற்கு மேரிபா என்றும், மாசா என்றும் பெயரிட்டான். கர்த்தர் அவர்களோடு இருக்கிறாரா, இல்லையா என்று சோதிக்க ஜனங்கள் விரும்பினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","ரெவிதீமில் அமலேக்கிய ஜனங்கள் வந்து இஸ்ரவேல் ஜனங்களோடு போர் செய்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","எனவே மோசே யோசுவாவை நோக்கி, “சில மனிதர்களைத் தேர்ந்தெடுத்துக் கொண்டு போய் அமலெக்கியரோடு நாளை போர் செய். நான் மலையின்மீது நின்று உங்களை கண்காணிப்பேன். தேவன் எனக்குக் கொடுத்த கைத்தடியைப் பிடித்துக்கொண்டிருப்பேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","யோசுவா மோசேக்குக் கீழ்ப்படிந்து, அமலேக்கிய ஜனங்களோடு போர் செய்வதற்கு மறுநாள் போனான். அதே நேரத்தில் மோசேயும், ஆரோனும், ஊரும் மலையுச்சிக்குச் சென்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","மோசே கைகளை மேலே உயர்த்தியிருந்தபோது, இஸ்ரவேல் ஜனங்கள் வென்றனர். ஆனால் மோசேயின் கரங்கள் கீழே தாழ்ந்தபோது, இஸ்ரவேல் ஜனங்கள் தோல்வியடையத் தொடங்கினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","சிறிது நேரத்திற்குப் பிறகு மோசேயின் கைகள் சோர்வடைந்தன. மோசேயோடு சென்ற மனிதர்கள் மோசேயின் கைகளைத் தூக்கியவாறே வைத்திருப்பதற்கு ஒரு வழி காண முயன்றார்கள். ஒரு பெரிய பாறையை மோசேக்குக் கீழே நகர்த்தி, அவனை அதில் உட்காரச் செய்தார்கள். பின் ஆரோனும், ஊரும் மோசேயின் கைகளைத் தூக்கிப் பிடித்தார்கள். ஆரோன் மோசேக்கு ஒரு புறமாகவும், ஊர் அவனுக்கு மறுபுறமாகவும் நின்றிருந்தனர். சூரியன் மறையும் வரைக்கும் அவர்கள் இவ்வாறே அவனுடைய கைகளைப் பிடித்திருந்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","ஆகவே யோசுவாவும் அவனுடைய ஆட்களும் இப்போரில் அமலேக்கியர்களை வென்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","அப்போது கர்த்தர் மோசேயிடம், “இந்த யுத்தத்தைப்பற்றி எழுது. இங்கு நடந்தவற்றை ஜனங்கள் நினைவுகூரும்படியாக இக்காரியங்களை ஒரு புத்தகத்தில் எழுது. பூமியிலிருந்து அமலேக்கிய ஜனங்களை முற்றிலுமாக அழிப்பேன் என்பதை யோசுவாவுக்கு உறுதியாகக் கூறு” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","பின் மோசே ஒரு பலிபீடத்தைக் கட்டினான். “கர்த்தர் எனது கொடி” என்று அந்தப் பலி பீடத்திற்குப் பெயரிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","மோசே, “கர்த்தருடைய சிங்காசனத்திற்கு நேராக என் கைகளை உயர்த்தினேன். ஆகையால் கர்த்தர் எப்பொழுதும் செய்தது போல தலைமுறை தலைமுறையாக அமலேக்கியரை எதிர்த்துப் போர் செய்தார்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","மோசேயின் மாமனாராகிய எத்திரோ மீதியா ஒரு ஆசாரியனாக இருந்தான். மோசேக்கும், இஸ்ரவேல் ஜனங்களுக்கும் பல வகைகளில் தேவன் உதவியதையும், எகிப்திலிருந்து கர்த்தர் இஸ்ரவேலரை வழிநடத்தினதையும் எத்திரோ கேள்விப்பட்டான். ");
INSERT INTO tam2008_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","எனவே தேவனின் மலைக்கருகில் (ஓரேப்) மோசே கூடாரமிட்டுத் தங்கியிருந்தபோது, எத்திரோ அவனிடம் சென்றான். அவன் மோசேயின் மனைவியாகிய சிப்போராளையும் அழைத்து வந்திருந்தான். (மோசே அவளை வீட்டிற்கு அனுப்பி விட்டிருந்தபடியால் சிப்போராள், மோசேயோடு இருக்கவில்லை.) ");
INSERT INTO tam2008_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","எத்திரோ மோசேயின் இரண்டு மகன்களையும் அழைத்து வந்திருந்தான். முதல் மகனின் பெயர் கெர்சோம், ஏனெனில் அவன் பிறந்தபோது, “நான் அந்நிய தேசத்தில் பரதேசியாக உள்ளேன்” என்று மோசே கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","இன்னொரு மகனின் பெயர் எலியேசர். ஏனெனில் அவன் பிறந்தபோது, மோசே, “எனது முற்பிதாக்களின் தேவன் எனக்கு உதவி, எகிப்தின் மன்னனிடமிருந்து அவர் என்னைக் காத்தார்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","மோசே தேவனின் மலைக்குப் (சீனாய்) பக்கத்திலுள்ள பாலைவனத்தில் கூடாரமிட்டுத் தங்கியிருந்தபோது, எத்திரோ அவனிடம் சென்றான். மோசேயின் மனைவியும் அவனது இரண்டு மகன்களும் எத்திரோவோடிருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","எத்திரோ மோசேக்குச் செய்தி சொல்லியனுப்பினான். எத்திரோ, “உனது மாமனாராகிய எத்திரோ வந்துள்ளேன். நான் உனது மனைவியையும், உனது இரண்டு மகன்களையும் உன்னிடம் அழைத்து வந்திருக்கிறேன்” என்று சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","எனவே மோசே மாமனாரைப் பார்ப்பதற்கு வெளியே போனான். மோசே அவனைக் குனிந்து வணங்கி, முத்தமிட்டான். இருவரும் ஒருவருக்கொருவர் சுகசெய்திகளை விசாரித்துக்கொண்டனர். பின் மோசேயின் கூடாரத்திற்குள் மேலும் அதிகமாக உரையாடும்படிக்கு நுழைந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","இஸ்ரவேல் ஜனங்களினிமித்தம் கர்த்தர் பார்வோனுக்கும் எகிப்தியருக்கும் எதிராகச் செய்த எல்லாவற்றையும், பார்வோனுக்கும் எகிப்தின் ஜனங்களுக்கும் கர்த்தர் செய்தவற்றையும், வழியில் அவர்களுக்கு உண்டான பிரச்சனைகளைப்பற்றியும், துன்பம் வந்தபோதெல்லாம் கர்த்தர் இஸ்ரவேல் ஜனங்களை எப்படிக் காப்பாற்றினார் என்பதையெல்லாம் மோசே தன் மாமனாரான எத்திரோவிடம் சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","கர்த்தர் இஸ்ரவேலுக்காகச் செய்த எல்லா நல்ல காரியங்களையும் கேள்விப்பட்டபோது எத்திரோமிக்க மகிழ்ச்சியடைந்தான். எகிப்தியரிடமிருந்து இஸ்ரவேல் ஜனங்களை கர்த்தர் விடுதலை செய்தார் என்பதையறிந்து அவன் மகிழ்ந்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","எத்திரோ, “கர்த்தரை துதியுங்கள்! எகிப்தின் வல்லமையிலிருந்து அவர் உங்களை விடுவித்தார். பார்வோனிடமிருந்து கர்த்தர் உங்களைக் காப்பாற்றினார். ");
INSERT INTO tam2008_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","இப்போது மற்ற எல்லா தேவர்களையும்விட கர்த்தர் பெரியவர் என்பதை நான் அறிவேன். அவர்கள் அடிமைகளாக உள்ளார்கள் என எண்ணியிருந்தனர், ஆனால் தேவன் செய்ததைப் பாருங்கள்!” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","எத்திரோ சில பலிகளையும், காணிக்கைகளையும் தேவனை மகிமைப்படுத்துவதற்காகக் கொண்டு வந்தான். மோசேயின் மாமனாராகிய எத்திரோவோடு சேர்ந்து உண்பதற்காக ஆரோனும் இஸ்ரவேலரின் மூப்பர்களும் (தலைவர்களும்) வந்தார்கள். அவர்கள் எல்லோரும் தேவனுடைய சந்நிதியில் சேர்ந்து உணவு உண்டார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","மறுநாள், ஜனங்களை நியாயந்தீர்க்கும் விசேஷ வேலை மோசேக்கு இருந்தது. நாள் முழுவதும் மோசேக்கு முன்னால் காலை முதல் மாலைவரை ஜனங்கள் கூடி நின்றனர். ");
INSERT INTO tam2008_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","மோசே ஜனங்களை நியாயந்தீர்ப்பதை எத்திரோ பார்த்தான். அவன், “ஏன் இவ்வாறு செய்கிறாய்? ஏன் நீ மட்டும் நியாயந்தீர்க்க வேண்டும்? ஏன் நாள் முழுவதும் ஜனங்கள் உன்னிடம் வந்துகொண்டிருக்கின்றனர்?” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","மோசே அவனது மாமனாரை நோக்கி: “ஜனங்கள் என்னிடம் வந்து, அவர்களின் பிரச்சனைகளைப்பற்றிய தேவனின் முடிவைக் கேட்டறிந்து சொல்லுமாறு என்னைக் கேட்கிறார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","ஜனங்கள் மத்தியில் விவாதம் எழுந்தால் அவர்கள் என்னிடம் வருகிறார்கள். எந்த மனிதன் சரியாகச் செயல்படுகிறான் என்பதை நான் முடிவு செய்வேன். இவ்வகையில் நான் ஜனங்களுக்கு தேவனின் சட்டங்களையும், போதனைகளையும் கற்பிக்கிறேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","ஆனால் மோசேயின் மாமனார் அவனை நோக்கி, “இதைச் செய்யும் வழி இதுவல்ல, ");
INSERT INTO tam2008_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","நீ ஒருவனே செய்வதற்கு இது பழுவான வேலையாகும். இவ்வேலையை நீ ஒருவனே செய்ய முடியாது. அது உன்னைக்களைப்படையச் செய்யும். ஜனங்களும் சோர்ந்து போகிறார்கள்! ");
INSERT INTO tam2008_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","இப்போது நான் சொல்வதைக் கேள். நான் உனக்குச் சில அறிவுரைகளைக் கூறுவேன். தேவன் உன்னோடிருக்கும் பொருட்டு நான் ஜெபம் செய்கிறேன். ஜனங்களின் பிரச்சனைகளைத் தொடர்ந்து நீ கேட்கவேண்டும், இவற்றைக் குறித்துத் தொடர்ந்து நீ தேவனிடம் பேச வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","நீ தேவனின் சட்டங்களையும் போதனைகளையும் ஜனங்களுக்குக் கற்பித்துக்கொண்டிருக்க வேண்டும். சட்டங்களை மீறக்கூடாது என்று அவர்களை எச்சரித்துவிடு. தக்க நெறியில் நடக்குமாறு அவர்களுக்குக் கூறு. என்னென்ன செய்ய வேண்டும் என்பது பற்றி அவர்களுக்குக் கூறு. ");
INSERT INTO tam2008_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","ஆனால் தலைவர்களாகவும், நீதிபதிகளாகவும் இருப்பதற்காகச் சிலரை நீ தேர்ந்தெடுத்துக்கொள்ளவும் வேண்டும். “உன் நம்பிக்கைக்குரிய நல்ல மனிதர்களைத் தேர்ந்தெடுத்துக்கொள். அம்மனிதர்கள் தேவனை மதிக்கிறவர்களாக இருக்க வேண்டும். பணத்திற்காக தங்கள் முடிவுகளை மாற்றாத மனிதர்களைத் தெரிந்துகொள். ஜனங்களுக்குத் தலைவர்களாக அவர்களை நியமித்துவிடு. 1,000 ஜனங்களுக்கும், 100 ஜனங்களுக்கும், 50 ஜனங்களுக்கும், 10 பேருக்கும் கூட தலைவர்கள் இருக்கட்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","இந்த அதிகாரிகள் ஜனங்களை நியாயந்தீர்க்கட்டும். மிக முக்கியமான வழக்கிருந்தால் அவர்கள் உன்னிடம் வரட்டும், நீ என்ன செய்வதென முடிவெடுக்கலாம். ஆனால் மற்ற வழக்குகளில் இம்மனிதர்கள் உனது வேலையைப் பகிர்ந்துகொள்ளட்டும். இப்படி ஜனங்களை வழி நடத்துவது உனக்கு எளிதாகும். ");
INSERT INTO tam2008_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","தேவ தயவால் நீ இவற்றைச் செய்தால், நீ உனது பணியை இன்னும் சிறப்பாகச் செய்ய முடியும். அதே நேரத்தில் ஜனங்களும் தங்கள் பிரச்சனைகளுக்குத் தீர்வு கண்டவர்களாய் வீடு திரும்ப முடியும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","எனவே எத்திரோ கூறியபடியே மோசே செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","இஸ்ரவேல் ஜனங்களில் சில நல்ல மனிதர்களை மோசே தெரிந்தெடுத்து ஜனங்களுக்குத் தலைவர்களாக அவர்களை நியமித்தான். 1,000 பேருக்கும், 100 பேருக்கும், 50 பேருக்கும், 10 பேருக்கும் தலைவர்கள் நியமிக்கப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","இந்த அதிகாரிகள் ஜனங்களுக்கு நீதிபதிகளாக இருந்தனர். இந்த அதிகாரிகளிடம் ஜனங்கள் தங்கள் விவாதங்களை எந்த நேரத்திலும் முன் வைக்க முடிந்தது. மிக முக்கியமான வழக்குகளை மட்டும் மோசே தீர்த்து வைக்க வேண்டியதாயிற்று. ");
INSERT INTO tam2008_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","கொஞ்ச நாட்களுக்குப்பின், மோசே தன் மாமனாராகிய எத்திரோவை வழியனுப்பினான். எத்திரோ தன் வீட்டிற்குத் திரும்பினான். ");
INSERT INTO tam2008_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","எகிப்திலிருந்து புறப்பட்ட மூன்றாவது மாதத்தில் இஸ்ரவேல் ஜனங்கள் சீனாய் பாலைவனத்தை அடைந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","அவர்கள் ரெவிதீமிலிருந்து சீனாய் பாலை வனத்திற்குப் பிரயாணம் செய்திருந்தனர். மலைக்கருகே (ஓரேப் மலை) இஸ்ரவேல் ஜனங்கள் கூடாரமிட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","பின் மோசே தேவனைச் சந்திக்கும்பொருட்டு மலைமீது ஏறினான். மலையின் மேல் தேவன் அவனோடு பேசினார். அவனிடம், “யாக்கோபின் பெரிய குடும்பத்தினராகிய இஸ்ரவேலின் ஜனங்களுக்கு இவ்விஷயங்களைக் கூறு: ");
INSERT INTO tam2008_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘என் எதிரிகளுக்கு என்னால் என்ன செய்ய முடியும் என்பதை நீங்களே பார்த்தீர்கள். எகிப்தின் ஜனங்களுக்கு நான் செய்தவற்றை நீங்கள் கண்டீர்கள். கழுகைப்போல நான் உங்களை எகிப்திலிருந்து சுமந்து வந்து, இங்கு என்னிடம் அழைத்து வந்ததை நீங்கள் பார்த்தீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","எனவே என் கட்டளைகளுக்கு நீங்கள் கீழ்ப்படிய வேண்டுமென உங்களுக்குக் கூறுகிறேன். எனது உடன்படிக்கையை மீறாதீர்கள். நான் கூறுகிறபடி நீங்கள் நடந்தால், என் விசேஷமான ஜனங்களாயிருப்பீர்கள். உலகம் முழுவதும் எனக்குச் சொந்தமானது. ஆனால் எனது விசேஷ ஜனங்களாக இருக்கும்படி, நான் உங்களைத் தெரிந்துகொண்டேன். ");
INSERT INTO tam2008_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ராஜரீக ஆசாரிய கூட்டமான, ஒரு பரிசுத்த ஜனமாக நீங்கள் இருப்பீர்கள்.’ மோசே, நான் கூறியதை நீ இஸ்ரவேல் ஜனங்களுக்குச் சொல்ல வேண்டும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","மோசே மலையிருந்து கீழே இறங்கினான். ஜனங்களின் மூப்பர்களை (தலைவர்கள்) வரவழைத்து அவர்களிடம் கூறும்படியாகக் கர்த்தர் கட்டளையிட்டவற்றை மோசே கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","எல்லா ஜனங்களும் சேர்ந்து ஒரே குரலில், “கர்த்தர் கூறுகின்றவற்றிற்கு நாங்கள் கீழ்ப்படிவோம்” என்றார்கள். மோசே மீண்டும் மலையின் மேலேறி தேவனிடம் சென்றான். மோசே தேவனிடம் ஜனங்கள் அவருக்குக் கீழ்ப்படிவதாகக் கூறியதைச் சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","கர்த்தர் மோசேயிடம், “கார்மேகத்தினூடே நான் உன்னிடம் வருவேன், உன்னோடு பேசுவேன்! நான் உன்னோடு பேசுவதை எல்லா ஜனங்களும் கேட்பார்கள். நீ அவர்களுக்குக் கூறுவதை ஜனங்கள் எப்போதும் நம்புவதற்காக நான் இதைச் செய்வேன்” என்றார். ஜனங்கள் கூறிய அனைத்தையும் மோசே தேவனுக்குச் சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","கர்த்தர் மோசேயை நோக்கி, “ஒரு விசேஷ கூட்டத்திற்காக இன்றும், நாளையும் நீ ஜனங்களை ஆயத்தப்படுத்த வேண்டும். ஜனங்கள் அவர்கள் ஆடைகளைத் துவைக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","மூன்றாம் நாளில் எனக்காகக் காத்திருக்க வேண்டும். மூன்றாவது நாள் கர்த்தர் சீனாய் மலைக்கு இறங்கி வருவார், எல்லா ஜனங்களும் என்னைக் காண்பார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","13","எல்லா ஜனங்களும் மலையை நெருங்காதிருக்கும்படி அவர்களுக்கு நீ கூறவேண்டும். ஒரு எல்லையை வரைந்து, ஜனங்கள் அதைத் தாண்டிச் செல்லாதபடி பார்த்துக்கொள். மலையைத் தொடும் மனிதனோ, மிருகமோ கொல்லப்பட வேண்டும். அவனைக் கற்களால் தாக்கியோ, அம்புகளை எய்தோ கொல்ல வேண்டும். கொல்லப்பட்டவனைப் பிறர் தொடக்கூடாது. எக்காளம் தொனிக்கும் வரைக்கும் ஜனங்கள் காத்திருக்க வேண்டும். அதன் பின்னரே அவர்கள் மலைக்கு சமீபம் செல்லலாம்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","மோசே மலையை விட்டிறங்கி, ஜனங்களிடம் சென்று, விசேஷ கூட்டத்திற்கு அவர்களை ஆயத்தப்படுத்தினான். அவர்கள் தங்கள் ஆடைகளைத் துவைத்து பரிசுத்தமாக்கினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","மோசே ஜனங்களை நோக்கி, “மூன்று நாட்களில் தேவனைத் தரிசிப்பதற்குத் தயாராகுங்கள். அதுவரைக்கும் ஆண்கள், பெண்களைத் தொடக்கூடாது” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","மூன்றாம் நாள் காலையில், மலையின் மேல் மேகமொன்று திரண்டு வந்தது. இடியும் மின்னலும் எக்காளத்தின் பேரொலியும் இருந்தன. கூடாரத்திலிருந்த ஜனங்கள் அனைவரும் பயந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","அப்போது மோசே, ஜனங்களைக் கூடாரத்திலிருந்து மலையருகேயுள்ள ஓரிடத்திற்கு தேவனைச் சந்திப்பதற்காக வழிநடத்திச் சென்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","சீனாய் மலை புகையால் நிரம்பிற்று. சூளையிருந்து புகை வருவதுபோல் மலையின் மேல் புகை எழுந்தது. கர்த்தர் மலைக்கு நெருப்பில் இறங்கி வந்ததால் இப்படி ஆயிற்று. மலையும் அதிரத்தொடங்கிற்று. ");
INSERT INTO tam2008_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","எக்காள சத்தம் உரத்து தொனிக்க ஆரம்பித்தது. மோசே தேவனிடம் பேசியபோதெல்லாம், தேவன் இடிபோன்ற குரலில் பதிலளித்தார். ");
INSERT INTO tam2008_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","கர்த்தர் சீனாய் மலையின்மேல் இறங்கினார். பரலோகத்திலிருந்து கர்த்தர் மலையின் உச்சியில் இறங்கினார். பின் கர்த்தர் மோசேயை மலையின் உச்சிக்கு தன்னிடத்தில் வருமாறு கூறினார். அவ்வாறே மோசேயும் மலையின் மீது ஏறினான். ");
INSERT INTO tam2008_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","கர்த்தர், மோசேயை நோக்கி, “ஜனங்கள் என்னைப் பார்கும்படி நெருங்கிவராதபடி அவர்களை எச்சரி. இதை மீறினால் அவர்களில் பலர் மரிக்க நேரிடும். ");
INSERT INTO tam2008_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","என்னிடம் வர வேண்டிய ஆசாரியர்களை இந்த சிறப்புச் சந்திப்புக்கு ஆயத்தமாகி வரும்படி கூறு. அவர்கள் சரியான ஆயத்தம் செய்யவில்லையென்றால், நான் அவர்களைத் தண்டிப்பேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","மோசே கர்த்தரை நோக்கி, “ஜனங்கள் மலை உச்சிக்கு வரமுடியாது. பரிசுத்த எல்லையை நெருங்காதபடி செய்யுமாறு நீர் தானே எங்களிடம் கூறியுள்ளீர்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","கர்த்தர் அவனிடம், “ஜனங்களிடம் இறங்கிச் செல். ஆரோனை உன்னோடு அழைத்து வா, ஆசாரியர்களோ, ஜனங்களோ என்னை அணுகவிடாதே. அவர்கள் என்னை நெருங்கினால் நான் அவர்களை தண்டிப்பேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","எனவே மோசே ஜனங்களிடம் போய் இச்செய்தியைக் கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","பின்பு தேவன், ");
INSERT INTO tam2008_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“நானே உங்கள் தேவனாகிய கர்த்தர். நீங்கள் அடிமைகளாயிருந்த எகிப்து தேசத்திலிருந்து நான் உங்களை வழிநடத்தி வந்தேன். எனவே, நீங்கள் இந்தக் கட்டளைகளுக்குக் கீழ்ப்படிய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“என்னைத் தவிர வேறு தேவர்களை நீங்கள் தொழக்கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“நீங்கள் எந்த விக்கிரகங்களையோ, படங்களையோ, சிலைகளையோ செய்யக் கூடாது. வானிலும், பூமியிலும் தண்ணீரிலு முள்ள எந்தப் பொருளின் வடிவத்திலும் அவற்றைச் செய்யக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","எந்த விதமான விக்கிரகத்தையும் தொழுகை செய்யவோ அதை சேவிக்கவோ கூடாது. ஏனெனில் நானே உங்கள் தேவனாகிய கர்த்தர். எனது ஜனங்கள் பிற தேவர்களைத் தொழுவதை நான் வெறுக்கிறேன். எனக்கு எதிராகப் பாவம் செய்வோர் எனது பகைவர்களாவார்கள். நான் அவர்களைத் தண்டிப்பேன். அவர்களின் பிள்ளைகளையும், பேரக் குழந்தைகளையும் அப்பேரர்களின் குழந்தைகளையும் தண்டிப்பேன். ");
INSERT INTO tam2008_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","என்னிடம் அன்போடிருந்து எனது கட்டளைகளுக்கு கீழ்ப்படிகிறவர்களிடம் நான் இரக்கம் காட்டுவேன். ஆயிரம் தலைமுறை வரைக்கும் அவர்கள் குடும்பங்களிடம் கருணையோடு இருப்பேன். ");
INSERT INTO tam2008_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“நீங்கள் உங்கள் தேவனாகிய கர்த்தரின் பெயரைத் தகாத வழியில் பயன்படுத்தக் கூடாது. ஒருவன் அவ்வாறு பயன்படுத்தினால், அவன் குற்றவாளியாவான். கர்த்தர் அவனது குற்றத்திற்காக அவனை தண்டிப்பார். ");
INSERT INTO tam2008_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“ஓய்வுநாளை விசேஷ நாளாகக் கருதும்படி நீங்கள் நினைவுகூருங்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","உங்கள் வேலையை வாரத்தின் ஆறு நாட்களும் செய்யுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ஆனால் ஏழாம் நாள் தேவனாகிய கர்த்தரை மகிமைப்படுத்தும்படி ஓய்வெடுக்க வேண்டிய நாள். எனவே அந்நாளில் நீங்களும், உங்கள் பிள்ளைகளும், உங்கள் வேலைக்காரரும், வேலைக்காரிகளும் வேலை செய்யக்கூடாது. உங்கள் மிருகங்களையோ, உங்கள் நகரங்களில் வாழும் அந்நியர்களையோ வேலை வாங்கக்கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","ஏனெனில் கர்த்தர் ஆறு நாட்கள் வேலை செய்து வானம், பூமி, கடல் அவற்றிலுள்ள எல்லாவற்றையும் படைத்தார். ஏழாம் நாளில் கர்த்தர் ஓய்வெடுத்தார். இவ்வாறு கர்த்தர் ஏழாம் நாளாகிய ஓய்வு நாளை ஆசீர்வதித்தார். கர்த்தர் அதை ஒரு மிக விசேஷமான நாளாக்கினார். ");
INSERT INTO tam2008_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“உங்கள் தந்தை, தாயாரை மதிக்க வேண்டும். உங்கள் தேவனாகிய கர்த்தர் தரும் நாட்டில் நீண்டஆயுள் வாய்ப்பதற்கு இதைச் செய்தல் வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“நீங்கள் யாரையும் கொல்லாதிருப்பீர்களாக. ");
INSERT INTO tam2008_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“நீங்கள் விபச்சாரம், செய்யாதிருப்பீர்களாக. ");
INSERT INTO tam2008_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“நீங்கள் எதையும் திருடாதிருப்பீர்களாக. ");
INSERT INTO tam2008_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“பிற ஜனங்களைக் குறித்துப் பொய் சாட்சி பேசவேண்டாம். ");
INSERT INTO tam2008_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“அயலானின் வீட்டை இச்சிக்கக்கூடாது. அவனது மனைவியை விரும்பவேண்டாம். அவனது வேலைக்காரனையோ வேலைக்காரியையோ, ஆடு மாடுகளையோ, கழுதைகளையோ எடுக்க வேண்டாம். இன்னொருவ னுக்குச் சொந்தமான எந்தப் பொருளையும் வஞ்சித்து எடுத்துக்கொள்ளக்கூடாது!” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","இதுவரை, பள்ளத்தாக்கிலிருந்த ஜனங்கள் இடி முழக்கத்தைக் கேட்டார்கள், மலையின் மீது மின்னலைப் பார்த்தார்கள். மலையினின்று புகையெழும்பக் கண்டனர். ஜனங்கள் அச்சத்தால் நடுங்கினார்கள். மலையை விட்டு தூரத்தில் நின்று கவனித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","பின்பு ஜனங்கள் மோசேயிடம், “நீர் எங்களோடு பேசினால் நாங்கள் கேட்போம். ஆனால் தேவன் எங்களோடு நேரில் பேசவிடாதிரும். அவ்வாறு நடந்தால், நாங்கள் மரித்துப்போவோம்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","மோசே ஜனங்களிடம், “பயப்படாதீர்கள்! கர்த்தர் உங்களை நேசிக்கிறார் என்பதைக் காண்பிக்கும்படியாக வந்திருக்கிறார். நீங்கள் அவருக்கு மரியாதை கொடுக்க வேண்டும். அதினிமித்தமாக நீங்கள் பாவம் செய்யாதிருப்பீர்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","தேவன் இருந்த கார்மேகத்திற்குள் மோசே போனபோது ஜனங்கள் மலையை விட்டு விலகி நின்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","இஸ்ரவேல் ஜனங்களிடம் கூறுமாறு கர்த்தர் மோசேக்கு பின்வருமாறு கூறினார்: “பரலோகத்திலிருந்து உங்களோடு பேசினதை நீங்கள் கண்டீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","எனவே, பொன் அல்லது வெள்ளியால் எனக்கு இணையாக நீங்கள் விக்கிர கங்களை உண்டாக்க வேண்டாம். இந்த போலியான தெய்வங்களை நீங்கள் செய்யக்கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“எனக்கென்று விசேஷ பலிபீடம் செய்யுங்கள். அதைக் கட்டும்போது மண்ணைப் பயன்படுத்துங்கள். அதன்மேல், தகன பலிகளையும், சமாதான பலிகளையும் பலியாகச் செலுத்துங்கள். உங்கள் ஆடு மாடுகளை இதற்கென்று பயன்படுத்துங்கள். என்னை நினைவு கூரும்படியாக நான் சொல்கிற இடங்களிலெல்லாம் இதைச் செய்யுங்கள். அப்போது நான் வந்து உங்களை ஆசீர்வதிப்பேன். ");
INSERT INTO tam2008_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","பலிபீடத்தை அமைப்பதற்கு நீங்கள் கற்களைப் பயன்படுத்தினால், இரும்புக் கருவியால் பிளக்கப்பட்ட கற்களைப் பயன்படுத்தவேண்டாம். அப் பலிபீடம் ஏற்றுக்கொள்ளப்படமாட்டாது. ");
INSERT INTO tam2008_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","பலிபீடத்திற்குப் படிகளைச் செய்யாதீர்கள். படிகள் இருந்தால் ஜனங்கள் பலிபீடத்தை ஏறிட்டு நோக்கும்போது உங்கள் நிர்வாணத்தை ஆடைகளின் கீழே அவர்கள் பார்க்கநேரிடும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","அப்போது தேவன் மோசேயிடம், “ஜனங்களுக்கு நீ கொடுக்க வேண்டிய பிற சட்டங்கள் இவையாகும். ");
INSERT INTO tam2008_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“நீங்கள் ஒரு எபிரெய அடிமையை வாங்கினால், அவன் ஆறு ஆண்டுகள் மட்டுமே உங்களுக்காக உழைப்பான். ஆறு ஆண்டுகளுக்குப்பின் அவன் விடுதலை பெறுவான். கட்டணமாக எதையும் அவன் செலுத்தத் தேவையில்லை. ");
INSERT INTO tam2008_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","ஒருவன் உங்கள் அடிமையாகும்போது மணமாகாதவனாக இருந்தால், விடுதலையாகும்போது தனியனாகப் போவான். ஒருவன் அடிமையாகும்போது திருமணமானவனாக இருந்தால், அவன் விடுதலை பெறும்போது மனைவியை அழைத்துச் செல்லலாம். ");
INSERT INTO tam2008_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","அடிமை மணமாகாதவனாக இருந்தால், எஜமான் அவனுக்கு ஒரு மனைவியைக் கொடுக்கலாம். அவள் மகன்களையோ, மகள்களையோ பெற்றெடுத்தால் அவளும் அவள் பிள்ளைகளும் எஜமானுக்கு உரிமையாவார்கள். அடிமையின் வேலையாண்டுகள் முடிந்தபின், அவன் மட்டும் விடுதலை பெறுவான். ");
INSERT INTO tam2008_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“ஆனால் அடிமை எஜமானோடு நீடித்து இருப்பதாக முடிவு செய்தால் அவன், ‘நான் என் எஜமானை நேசிக்கிறேன். நான் எனது மனைவியையும், என் பிள்ளைகளையும் நேசிக்கிறேன். நான் விடுதலை பெறமாட்டேன். நான் இங்கேயே தங்குவேன்’ என்று சொல்லவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","இவ்வாறு நிகழ்ந்தால், எஜமான் அடிமையைத் தேவனுடைய சந்நிதானத்தில் கொண்டுவரவேண்டும். எஜமான் அடிமையை ஒரு வாசலருகே அல்லது வாசலின் நிலைக்காலின் அருகே அழைத்துச் சென்று, அடிமையின் காதில் கூர்மையான கருவியால் ஒரு துளை போடவேண்டும். அப்போது அடிமை தன் வாழ்க்கை முழுவதும் எஜமானுக்கு தொண்டு செய்வான். ");
INSERT INTO tam2008_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“ஒரு மனிதன் தன் மகளை அடிமையாக விற்க முடிவு செய்தால், அவளை விடுதலை செய்வதற்குரிய விதிகள் ஆண் அடிமையை விடுவிப்பதற்கான விதிமுறைகளில் இருந்து மாறுப்பட்டவை. ");
INSERT INTO tam2008_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","எஜமானுக்கு அப்பெண்ணிடம் விருப்பம் இல்லை என்றால், அப்பெண்ணை அவள் தந்தைக்கு மீண்டும் விற்றுவிடலாம். எஜமான் அப்பெண்ணை மணப்பதாக வாக்குறுதி அளித்தால் அப்பெண்ணை வேறு யாருக்கும் விற்கும் உரிமையை இழந்துவிடுவான். ");
INSERT INTO tam2008_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","அடிமைப் பெண் எஜமானின் மகனை மணப்பதற்கு எஜமான் சம்மதித்தால் அவளை அடிமையாக நடத்தக்கூடாது. அவளை ஒரு மகளைப் போல் நடத்தவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","“எஜமான் மற்றொரு பெண்ணை மணந்தால் முதல் மனைவிக்குக் குறைவான ஆடையோ, உணவோ கொடுக்கக்கூடாது. அவன் அவளோடு தூங்குவதை நிறுத்தக் கூடாது. விவாகத்தில் அவளுக்கு உரிமையான எல்லாப் பொருட்களையும் அவன் கொடுத்து வர வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","அவன் அவளுக்கு இந்த மூன்று காரியங்களையும் செய்ய வேண்டும். இவ்வாறு செய்யவில்லையென்றால், அப்பெண் விடுவிக்கப்படுவாள். அவள் செலுத்தவேண்டிய கடன் எதுவுமிராது. ");
INSERT INTO tam2008_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“ஒரு மனிதன் இன்னொருவனை திட்டமிட்டு அடித்துக் கொன்றால், அப்போது அம்மனிதன் கொல்லப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","ஆனால் ஒருவன் மற்றொருவனைத் திட்டமிடாமல் கொன்றால், தேவன் அந்த விபத்தை அனுமதித்தார் என்று எண்ணலாம். குறிப்பிட்ட சில இடங்களை பாதுகாப்பிற்காக ஓடி உயிர்தப்பும்படி நியமிப்பேன். அதனால் இத்தகைய ஒருவன் அங்கே ஓடலாம். ");
INSERT INTO tam2008_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","ஒருவன் மற்றொருவனைச் சினந்து அல்லது வெறுத்துக் கொல்லத் திட்டமிட்டால், கொலையாளி தண்டிக்கப்பட வேண்டும். அவனை எனது பலிபீடத்திற்குத் தொலைவில் அழைத்துச் சென்று கொல்லவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“தந்தையையோ, தாயையோ அடிக்கிற எந்த மனிதனும் கொல்லப்படவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“ஒருவனை அடிமையாக்கவோ, அடிமையாக விற்பதற்கோ திருடிச் சென்றால், அவ்வாறு திருடிச் சென்றவன் கொல்லப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“தந்தையையோ, தாயையோ சபிக்கிற எந்த மனிதனும் கொல்லப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“இருவர் வாக்குவாதம் செய்து, ஒருவனை மற்றொருவன் கல்லால் அல்லது கையால் தாக்கினால் எவ்வாறு அம்மனிதனைத் தண்டிக்க வேண்டும்? தாக்கப்பட்ட மனிதன் மரிக்க வில்லையென்றால் அவனைத் தாக்கிய மனிதனும் கொல்லப்படக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","தாக்கப்பட்ட மனிதன் படுக்கையில் சில காலம் இருக்க நேர்ந்தால், அவனைத் தாக்கிய மனிதன் அவன் குணமாகும்வரை அவனை ஆதரிக்க வேண்டும். அவன் சம்பாதிப்பதற்குரிய நாட்களை வீணாக்கியதற்குப் பணம் கொடுக்க வேண்டும். அம்மனிதன் அவன் முழுமையாக குணமாகும் வரை உதவி செய்ய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“சில வேளைகளில் ஜனங்கள் தங்கள் ஆண் அல்லது பெண் அடிமைகளை அடிப்பார்கள். அடிபட்டு அடிமை மரிக்க நேர்ந்தால், அவனைக் கொன்றவன் தண்டிக்கப்படவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","அடிமை மரிக்காமல் சில நாட்களுக்குப் பின் குணமடைந்தால், அம்மனிதனைத் தண்டிக்க வேண்டாம். ஏனெனில் எஜமானன் அடிமையைப் பணம் கொடுத்து வாங்கியிருந்ததால் அந்த அடிமை அவனுக்குரியவன். ");
INSERT INTO tam2008_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“இரு மனிதர் சண்டையிடும்போது, ஒரு கர்ப்பிணிப் பெண்னைத் தாக்கிவிடக் கூடும். அதனால் உரிய காலத்திற்கு முன்னாலேயே அவள் குழந்தையை பெறலாம். அப்பெண் அதிகமான காயமடையவில்லையென்றால், அவளைக் காயப்படுத்திய மனிதன் அபராதம் செலுத்த வேண்டும். அபராதத் தொகை எவ்வளவு என்பதை அப்பெண்ணின் கணவன் தீர்மானிப்பான். அபராதத் தொகையின் அளவைத் தீர்மானிக்க நீதிபதிகள் அவனுக்கு உதவுவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","ஆனால் அப்பெண் மிகுதியாகக் காயமுற்றால் அவளைக் காயப்படுத்திய மனிதன் தண்டனை பெற வேண்டும். ஒருவன் கொல்லப்பட்டால் அக்கொலைக்குக் காரணமானவனும் கொல்லப்படவேண்டும். ஒரு உயிருக்கு மற்றொரு உயிர் வாங்கப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","கண்ணுக்குக் கண்ணையும், பல்லுக்குப் பல்லையும், கைக்குக் கையையும், காலுக்குக் காலையும், ");
INSERT INTO tam2008_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","சூட்டுக்கு சூடும், காயத்துக்குக் காயமும், வெட்டுக்கு வெட்டும் தண்டனையாகக் கொடுக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“ஒரு மனிதன் அடிமையைக் கண்ணில் அடித்ததால் அவன் குருடனாக நேர்ந்தால், அடிமை விடுதலைபெற வேண்டும். விடுதலைக்குரிய விலை அவன் இழந்த கண்ணேயாகும். இது ஆண் அடிமைக்கும், பெண்ணடிமைக்கும் பொதுவாகும். ");
INSERT INTO tam2008_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","ஒரு எஜமானன் தன் அடிமையை வாயில் அடித்து, அடிமை பல்லை இழக்க நேர்ந்தால் அடிமையை விடுதலை செய்யவேண்டும். அவன் விடுதலைக்கு அவன் பல்லே விலையாக அமையும். இது ஆண் அல்லது பெண் அடிமைக்கும் பொருந்தும். ");
INSERT INTO tam2008_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“ஒரு மனிதனின் மாடு ஒரு ஆணையோ, பெண்ணையோ கொன்றால், அந்த மாட்டைக் கல்லெறிந்து கொல்லவேண்டும். அதை உணவாக உட்கொள்ளக் கூடாது. அதன் உரிமையாளன் குற்றவாளி அல்ல. ");
INSERT INTO tam2008_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","அது முன்பு பலரைத் தாக்கியபோது உரிமையாளன் எச்சரிக்கப்பட்டும், அவன் ஓரிடத்தில் அதைக் கட்டியோ, அடைத்தோ வைக்காமலிருந்ததால் அவன் குற்றவாளியாவான். ஏன்? அது வெளியே தனித்துச் சென்று, யாரையேனும் கொன்றால் அப்போது அதன் எஜமானன் குற்றவாளியாகக் கருதப்படுவான். மாட்டையும் அதன் உரிமையாளனையும் நீ கல்லெறிந்து கொல்ல வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","மரித்த மனிதனின் குடும்பத்தினர் ஈடாகப் பணத்தைப் பெறலாம், அவர்கள் பணத்தை ஏற்றுக்கொள்ளும் பட்சத்தில் மாட்டின் உரிமையாளனைக் கொல்லத் தேவையில்லை. ஆனால் நீதிபதி கூறும் ஈடுப் பணத்தை அவன் செலுத்தவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","“ஒருவனின் மகன் அல்லது மகளை மாடு கொன்றாலும் அதே விதி பின்பற்றப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","ஆனால் ஒரு அடிமையை மாடு கொன்றால், அந்த அடிமையின் எஜமானனுக்கு மாட்டின் எஜமானன் 30 வெள்ளிப்பணம் கொடுக்கவேண்டும். மாட்டைக் கல்லெறிந்து கொல்ல வேண்டும். ஆண் அல்லது பெண் அடிமைக்கும் சட்டம் பொதுவானதே. ");
INSERT INTO tam2008_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“ஒரு மனிதன் கிணற்றின் மூடியை அகற்றினதாலோ அல்லது ஒரு குழியைத்தோண்டி மூடாமல் விட்டதாலோ, இன்னொருவனின் மிருகம் அக்குழியில் விழுந்தால், அக்குழியைத் தோண்டியவன் குற்றவாளியாவான். ");
INSERT INTO tam2008_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","அவன் மிருகத்தின் விலையைக் கொடுத்து அம்மிருகத்தின் உடலைப் பெற்றுக்கொள்ளலாம். ");
INSERT INTO tam2008_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“ஒருவனின் மாடு மற்றொருவனின் மிருகத்தைக் கொன்றால் உயிருள்ள மாட்டை விற்றுவிட வேண்டும். அப்பணத்தை இருவரும் சரிபாதியாகப் பங்கிட்டுக்கொள்ள வேண்டும். கொல்லப்பட்ட மாட்டையும் அவர்கள் சமமாகப் பங்கிட்டுக்கொள்ள வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","அம்மனிதனின் மாடு அதற்கும் முன்னர் பிற மிருகங்களைத் தாக்கி காயப்படுத்தியிருந்தால் அதன் உரிமையாளனே மாட்டின் பொறுப்பேற்க வேண்டும். அவன் மாடு மற்ற மாட்டைக் கொன்றிருந்தால் அந்த மாட்டை அவிழ்த்து விட்டபடியால் அதன் உரிமையாளன் குற்றவாளியாவான். அவன் செத்துப்போன மாட்டுக்கு ஈடாக இன்னொரு மாட்டைக் கொடுக்க வேண்டும். அவனது செத்துப் போன மாட்டின் உடலைப் பெற்றுக்கொள்ள வேண்டும்.” ");
INSERT INTO tam2008_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“ஒரு மாட்டையோ, ஆட்டையோ திருடுகிற மனிதனை நீ எவ்வாறு தண்டிக்க வேண்டும்? அம்மனிதன் அந்த மிருகத்தைக் கொன்றாலோ அல்லது விற்றாலோ, அதனைத் திரும்பக் கொடுக்க முடியாது. எனவே, அவன் திருடிய மாட்டுக்குப் பதிலாக ஐந்து மாடுகளைக் கொடுக்க வேண்டும். அல்லது திருடிய ஒரு ஆட்டிற்காக நான்கு ஆடுகளைக் கொடுக்க வேண்டும். திருட்டுக்காக பணம் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","அவனுக்கு கொடுக்க எதுவும் சொந்தமில்லையென்றால், அவன் அடிமையாக விற்கப்பட வேண்டும். ஆனால் அந்த மனிதன் தான் திருடிய மிருகத்தை வைத்திருந்தானாகில், தான் திருடிய ஒவ்வொரு மிருகத்திற்காகவும் இரண்டு மிருகங்களைக் கொடுக்க வேண்டும். அது மாடா, கழுதையா, அல்லது ஆடா என்பது ஒரு பொருட்டல்ல. “இரவில் திருடும்படி ஒருவன் ஒரு வீட்டுக்குள் நுழைய முயற்சி செய்யும்போது திருடன் கொல்லப்பட்டால், அவன் கொலைக்கு யாரும் பொறுப்பாளி அல்ல. ஆனால் அது பகலில் நடந்தால், அவனைக் கொன்றவன் கொலைக் குற்றவாளியாவான். ");
INSERT INTO tam2008_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“ஒருவன் தன் வயலில் அல்லது திராட்சைத் தோட்டத்தில் நெருப்பு மூட்டக் கூடும். அந்த நெருப்பு பரவி, அடுத்த வயலிலோ அல்லது திராட்சைத் தோட்டத்திலோ பற்றிக்கொள்ள நேர்ந்தால் அயலானின் நஷ்டத்திற்கு ஈடாக அவன் விளைச்சலின் சிறந்த பலனுக்கு ஈடான பணத்தைக் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“ஒருவன் வயலின் முட்புதர்களை எரிக்கும்படி நெருப்பு வைக்கக்கூடும். அது பரவி அடுத்தவனின் வயலிலுள்ள பயிர்களையோ, தானியத்தையோ அழித்தால், அழிந்து போனவற்றின் விலையை அழிவுக்குக் காரணமாக இருந்தவன் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“ஒரு மனிதன் தனக்குத் தேவையான பணத்தையோ அல்லது பொருட்களையோ அடுத்த வீட்டுக்காரனிடம் கொடுத்து வைக்கச் சொல்லலாம். அவ்வீட்டிலிருந்து அப்பணமோ அல்லது பொருளோ திருடப்பட்டுவிட்டால் திருடனைக் கண்டுபிடிக்க முயற்சி செய்ய வேண்டும். திருடன் அகப்பட்டால் அவன் திருடிய பொருளின் இரண்டு மடங்கு விலையைக் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","ஆனால் திருடன் அகப்படாமல் வீட்டின் எஜமான் குற்ற வாளியாக இருந்தால் தேவன் நியாயந்தீர்ப்பார். வீட்டின் எஜமானன் தேவனுக்கு முன்னே செல்லும்போது, அவன் திருடனாக இருந்தால் தேவன் அவனைத் தண்டிப்பார். ");
INSERT INTO tam2008_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“காணாமற்போன மாடு, கழுதை, ஆடு அல்லது துணிகளைக் குறித்து இருவர் முரண்பட்டால் நீ என்ன செய்ய வேண்டும்? ஒருவன், ‘இது என்னுடையது’ என்றும் இன்னொருவன், ‘இல்லை, அது எனக்குரியது’ என்றும் கூறுகிறான். இருவரும் தேவனுக்கு முன்னே போக வேண்டும். யார் குற்றவாளி என்பதைத் தேவன் தீர்மானிப்பார். குற்றவாளியான மனிதன் அப்பொருளின் இருமடங்கு விலையை மற்றவனுக்குக் கொடுக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“ஒருவன் அடுத்தவனிடம் தனது மிருகத்தைச் சில காலம் கவனித்துக்கொள்ளும்படியாக விடாலாம். அது கழுதை அல்லது மாடு அல்லது ஆடாக இருக்கலாம். யாரும் பார்க்காதபோது ஒருவன் அதனைக் காயப்படுத்தவோ, கொல்லவோ, திருடவோ செய்தால் நீ என்ன செய்ய வேண்டும்? ");
INSERT INTO tam2008_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","அதைப் பெற்றுகொண்டவன் அம்மிருகத்தைத் தான் திருடவில்லை என்பதை விளக்க வேண்டும். அது உண்மையானால் கர்த்தரின் சந்நிதியில் சென்று நான் திருடவில்லை என்று ஆணையிட வேண்டும். மிருகத்தின் உரிமையாளனும் அதை ஏற்றுக்கொள்ள வேண்டும். அண்டை வீட்டுக்காரன் அந்த மிருகத்திற்காக எந்தப் பணமும் செலுத்த தேவையில்லை. ");
INSERT INTO tam2008_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","ஆனால் அண்டை வீட்டுக்காரன் மிருகத்தைத் திருடியிருந்தால், அவன் அதற்கான விலையை உரிமையாளனுக்குக் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","காட்டு மிருகங்கள் அதனைக் கொன்றிருந்தால் அதன் உடலைச் சாட்சியாக அண்டை வீட்டுக்காரன் எடுத்துவர வேண்டும். கொல்லப்பட்ட மிருகத்துக்காக அவன் விலை கொடுக்க வேண்டாம். ");
INSERT INTO tam2008_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“அண்டை வீட்டுக்காரனிடமிருந்து ஒருவன் எதையேனும் இரவல் பெற்றுக்கொண்டால், அவனே அப்பொருளுக்குப் பொறுப் பாளியாவான். ஒரு மிருகம் காயமுற்றாலோ அல்லது மரித்தாலோ அண்டை வீட்டுக்காரன் அம்மிருகத்தின் விலையை உரிமையாளனுக்குக் கொடுக்க வேண்டும். அப்பொருளின் உரிமையாளன் அங்கு இல்லாதிருந்தால், அண்டை வீட்டுக்காரன் அதற்குப் பொறுப்பேற்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","ஆனால் உரிமையாளனே அங்கிருந்தால் அயலான் அதற்கு பொறுப்பேற்க அவசியமில்லை. அண்டை வீட்டுக்காரன் அம்மிருகத்தை வேலைக்குப் பயன்படுத்தும்போது அதற்குக் குத்தகை செலுத்தும் பட்சத்தில் அம்மிருகம் மரித்தாலோ அல்லது காயப்பட்டாலோ அதற்குரிய பணத்தைச் செலுத்த வேண்டியதில்லை. மிருகத்தைப் பயன்படுத்தியதற்காக அவன் ஏற்கெனவே கொடுத்த பணமே போதுமானது. ");
INSERT INTO tam2008_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“மணமாகாத கன்னியிடம் ஒரு மனிதன் பாலின உறவு கொண்டால், அவன் அவளை மணந்துகொள்ள வேண்டும். அப்பெண்ணின் தந்தைக்குப் பரிசுப் பொருளை அவன் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","பெண்ணின் தந்தை அவனைத் தன் மகள் மணக்கச் சம்மதிக்காவிட்டாலும் கூட, அவன் அப்பணத்தைக் கொடுத்துத் தீர வேண்டும். அவளுக்குரிய முழு ஈட்டுப் பொருளையும் அவன் செலுத்தியே ஆகவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“எந்தப் பெண்ணையும் மந்திரம் செய்ய நீ அனுமதிக்கக் கூடாது. அவள் மந்திரம் செய்தால் அவள் வாழ அனுமதிக்காதே. ");
INSERT INTO tam2008_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“மிருகத்தோடு யாரும் உடலுறவு கொள்ளலாகாது. அவ்வாறு செய்யும் மனிதன் கொல்லப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“பொய்த் தேவர்களுக்கு ஒருவன் பலி செலுத்தினால் அம்மனிதன் கொல்லப்பட வேண்டும். தேவனாகிய கர்த்தருக்கு மட்டுமே நீங்கள் பலி செலுத்த வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“முன்பு எகிப்தில் அந்நியர்களாக இருந்தீர்கள் என்பதை நினைவிலிருத்திக்கொள்ளுங்கள். எனவே, உங்கள் நாட்டில் வாழும் எந்த அந்நியனையும் ஏமாற்றவோ, காயப்படுத்தவோ கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“கணவனை இழந்த பெண்களுக்கும், பெற்றோரற்ற குழந்தைகளுக்கும் எந்தத் தீமையும் செய்யாதீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","விதவைகளுக்கும், அநாதைகளுக்கும் ஏதேனும் தீங்கு செய்தீர்களானால் நான் அதை அறிவேன். அவர்கள் பட்ட துன்பத்தைப்பற்றிக் கூறும்போது, நான் கேட்பேன். ");
INSERT INTO tam2008_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","எனக்கு மிகுந்த கோபம் உண்டாகும். உங்களைப் பட்டயத்தால் கொல்லுவேன். அப்போது உங்கள் மனைவியர் விதவைகளாவார்கள். உங்கள் பிள்ளைகள் அநாதைகளாவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“என் ஜனங்களில் ஏழையான ஒருவனுக்கு நீங்கள் கடனாகப் பணம் கொடுத்தால், அதற்கு வட்டி கேட்காதீர்கள். உடனே அப்பணத்தைத் திருப்பும்படியாக வற்புறுத்தக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","நீ கொடுக்கவிருக்கும் பணத்திற்கு அடமானமாக தன் மேற்சட்டையை ஒருவன் கொடுத்தால் சூரியன் மறையும் முன்னர் அந்த மேற்சட்டையைத் திரும்பக் கொடுத்து விடவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","அம்மனிதனுக்கு மேற்சட்டை இல்லாமலிருந்தால் உடலைப் போர்த்திக்கொள்ள எதுவுமிராது. அவன் தூங்கும்போது சளிபிடிக்கும். அவன் என்னைக் கூப்பிட்டால் நான் அவனைக் கேட்பேன். நான் இரக்கம் பொருந்தியவராக இருப்பதால் நான் அவனுக்கு செவிகொடுப்பேன். ");
INSERT INTO tam2008_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“நீங்கள் தேவனையோ, ஜனங்கள் தலைவர்களையோ சபிக்கக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“அறுவடையின்போது நீங்கள் முதல் தானியத்தையும், முதல் பழங்களின் ஈற்றையும் எனக்குக் கொடுக்க வேண்டும். வருடத்தின் இறுதிவரைக்கும் காத்திராதீர்கள். “உங்கள் முதற்பேறான மகன்களை எனக்குக் கொடுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","முதலில் பிறந்த ஆடுகளையும், மாடுகளையும் எனக்குக் கொடுங்கள். முதற்பேறான குட்டியானது தாயுடன், ஏழுநாட்கள் இருக்கட்டும், எட்டாவது நாள் அதை எனக்குக் கொடுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“நீங்கள் என் விசேஷ ஜனங்கள். எனவே கொடிய மிருகங்களால் கொல்லப்பட்ட விலங்குகளின் மாமிசத்தை உண்ணாதீர்கள். அந்த மரித்த மிருகத்தை நாய்கள் தின்னட்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“பிறருக்கு விரோதமாகப் பொய் பேசாதீர்கள். சாட்சி சொல்லும்படி நீதி மன்றத்துக்கு நீங்கள் சென்றால், ஒரு தீய மனிதன் பொய் சொல்வதற்கு உதவாதீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“பிறர் செய்கிறார்கள் என்பதால் மட்டுமே நீங்கள் சிலவற்றைச் செய்யாதீர்கள். ஒரு கூட்டம் ஜனங்கள் தவறு செய்தால் அவர்களோடு சேராதீர்கள். அந்த ஜனங்கள் உங்களை தீயவற்றைச் செய்யும்படியாகத் தூண்டவிடாதீர்கள். எது சரியென்றும் நியாயமான தென்றும் தெரிகிறதோ, அதையே செய்யுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","“ஒரு ஏழை நியாயந்தீர்க்கப்படுகையில் அவன் மீதுள்ள இரக்கத்தினால் ஜனங்கள் அவனுக்கு ஆதரவாக இருக்கலாம். ஆனால், நீங்கள் அவ்வாறு செய்யக்கூடாது. அவன் செய்தது சரியாக இருந்தால் மட்டுமே அவனுக்கு ஆதரவாக இருங்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“காணாமற்போன மாட்டையோ, கழுதையையோ பார்த்தீர்களானால், அதை அதன் உரிமையாளனிடம் சேர்ப்பிக்க வேண்டும். அதன் உரிமையாளன் உனது பகைவனாக இருந்தாலும், நீ அதைச் செய்ய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","“மிகுந்த பாரத்தால் நடக்க முடியாத மிருகத்தைக் கண்டால் அதை நிறுத்தி அதற்கு உதவ வேண்டும். அது உனது பகைவர்களில் ஒருவனுக்குச் சொந்தமானதாக இருந்தாலும் அம்மிருகத்திற்கு நீ உதவ வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“ஒரு ஏழை மனிதனுக்கு ஜனங்கள் அநியாயம் செய்ய விடாதே. அவனும் பிறரைப் போன்றே நியாயந்தீர்க்கப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","“ஒருவன் குற்றவாளி என நீ கூறும்போது எச்சரிக்கையாக இரு. ஒருவனுக்கு எதிராக வீண் பழி சுமத்தாதே. குற்றமற்ற ஒருவன் செய்யாத செயலுக்குத் தண்டனையாகக் கொல்லப்படுவதற்கு வகை செய்யாதே. குற்றமற்ற மனிதனைக் கொல்பவன் கொடியவன். அம்மனிதனை நான் மன்னிக்கமாட்டேன். ");
INSERT INTO tam2008_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“ஒருவன் தவறு செய்யும்போது அவன் செயலை ஆமோதிப்பதற்காக ஒருவன் உனக்கு லஞ்சம் கொடுக்க வந்தால் அதை ஏற்றுக்கொள்ளாதே. நீதிபதிகள் உண்மையைப் பார்க்காதபடிக்கு இத்தகைய பணம் நீதிபதிகளைக் குருடாக்கும். அந்தப் பணம் உண்மையுள்ளவர்களையும் பொய்யராக்கும். ");
INSERT INTO tam2008_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“அந்நியனுக்குத் தீங்குசெய்யாதீர்கள். எகிப்து தேசத்தில் வாழ்ந்தபோது நீங்களும் அந்நியராக இருந்ததை நினைவு கூருங்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“விதைகளை விதையுங்கள், பயிர்களை அறுவடை செய்யுங்கள், ஆறு ஆண்டுகள் நிலத்தைப் பண்படுத்துங்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ஆனால் ஏழாவது ஆண்டு நிலத்தைப் பண்படுத்தாதீர்கள். நிலம் ஓய்வெடுப்‌பதற்குரிய விசேஷ காலமாக ஏழாவது ஆண்டு இருக்கட்டும். அந்த ஆண்டில் உங்கள் நிலங்களில் எதையும் விதைக்காதீர்கள். ஏதேனும் பயிர்கள் அந்நிலத்தில் விளைந்தால் அதை ஏழைகள் அனுபவிக்கட்டும். மிகுதியான தானியங்களைக் காட்டுமிருகங்கள் உண்ணட்டும். உங்களுக்குச் சொந்தமான திராட்சைத் தோட்டங்களையும், ஒலிவமரத் தோப்புக்களையும் அவ்வாறே பயன்படுத்துங்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“ஆறு நாட்கள் உழையுங்கள். ஏழாவது நாளில் ஓய்வு எடுங்கள். உங்கள் அடிமைகளுக்கும், வேலையாட்களுக்கும் ஓய்வுக்கும், அமைதிக்கும் அது வழிவகுக்கும். உங்கள் மாடுகளும், கழுதைகளும் ஓய்வெடுக்க நேரம் கிடைக்கும். ");
INSERT INTO tam2008_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“இச்சட்டங்களை உறுதியாகப் பின்பற்றுங்கள் பொய்த் தேவர் களை தொழுதுகொள்ளாதீர்கள். அவைகளின் பெயர்களை உங்கள் நாவினால் உச்சரிக்கவேண்டாம்! ");
INSERT INTO tam2008_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“ஒவ்வொரு ஆண்டும் மூன்று விசேஷ விடு முறைகள் உங்களுக்கு இருக்கும். அந்நாட்களில் என்னைத் தொழுதுகொள்ளும்படி விசேஷ இடத்தில் நீங்கள் கூடுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","முதலாவது, புளிப்பில்லா அப்பப் பண்டிகையாகும். நான் கட்டளையிட்டபடியே இதைக் கொண்டாடவேண்டும். புளிப்புச் சேராத ரொட்டியை நீங்கள் ஏழு நாட்கள் உண்ண வேண்டும். ஆபிப் மாதத்தில் இதைச் செய்ய வேண்டும். ஏனெனில் அம்மாதத்தில்தான் நீங்கள் எகிப்தை விட்டு வெளியேறினீர்கள். அந்த சமயம் உங்களில் ஒவ்வொருவனும் ஒரு பலியைக் கொண்டு வரவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“பெந்தெகோஸ்தே பண்டிகையானது ஆண்டின் இரண்டாவது விடுமுறை நாளாக இருக்கும். உங்கள் வயல்களில் அறுவடை ஆரம்பிக்கும் கோடையின் தொடக்கத்தில் இந்த விடுமுறை நாள் வரும். “ஆண்டின் மூன்றாம் விடுமுறையானது அடைக்கலக் கூடாரப் பண்டிகையாக இருக்கும். இலையுதிர் காலத்தில் உங்கள் வயல்களின் எல்லாப் பயிர்களையும் சேர்க்கும் நாட்களில் இப்பண்டிகை வரும். ");
INSERT INTO tam2008_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“ஆகவே ஆண்டிற்கு மூன்றுமுறை ஒவ்வொரு ஆண்டும் உங்கள் கர்த்தராகிய ஆண்டவரை வணங்கும்படி நீங்கள் எல்லோரும் கூடிவரவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“ஒரு மிருகத்தைக் கொன்று அதன் இரத்தத்தைப் பலியாகக் கொடுத்தால், புளிப்புள்ள ரொட்டியை அதனோடு படைக்கக்கூடாது. இப்பலியிலிருந்து நீங்கள் மாமிசத்தை எடுத்து உண்ணும்போது, ஒரே நாளில் அதை முடித்துவிடவேண்டும். எஞ்சிய மாமிசத்தை அடுத்த நாளுக்காகப் பாதுகாக்க வேண்டாம். ");
INSERT INTO tam2008_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“அறுவடை காலத்தில் பயிர்களைச் சேர்க்கும்போது, பயிர்களில் முதலில் அறு வடை செய்பவற்றை தேவனாகிய கர்த்தரின் வீட்டிற்குக் (பரிசுத்த கூடாரத்திற்குக்) கொண்டுவர வேண்டும். “தாய் ஆட்டின் பாலில் வேக வைக்கப்பட்ட ஆட்டுக்குட்டியின் மாமிசத்தைச் சாப்பிடாதீர்கள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","தேவன், “நான் உங்களுக்கு முன்பாக ஒரு தூதனை அனுப்புவேன். நான் உங்களுக்கென தயாராக வைத்திருக்கிற இடத்திற்கு அத்தூதன் அழைத்துச் செல்வார். அந்தத் தூதன் உங்களைப் பாதுகாப்பார். ");
INSERT INTO tam2008_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","தூதனுக்குக் கீழ்ப்படிந்து அவரைப் பின்பற்றுங்கள். அவரை எதிர்க்காதீர்கள். நீங்கள் அவரை எதிர்த்துச் செய்கிற தவறுகளைத் தூதன் மன்னிக்கமாட்டார். அவரில் என் வல்லமை (நாமம்) இருக்கிறது. ");
INSERT INTO tam2008_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","அவர் சொல்கிற எல்லாவற்றிற்கும் நீங்கள் செவிகொடுக்கவேண்டும். அவ்வாறு செய்தால் நான் உங்களோடிருப்பேன். உங்கள் பகைவர்களை எதிர்ப்பேன். உங்களை எதிர்க்கிற ஒவ்வொருவருக்கும் நான் பகைவனாவேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","தேவன், “என் தூதன் உங்களை தேசத்தில் வழி நடத்துவார். எமோரியர், ஏத்தியர், பெரிசியர், கானானியர், ஏவியர், எபூசியர் ஆகிய வெவ்வேறு ஜனங்களுக்கு எதிராக உங்களை வழிநடத்துவார். நான் அந்த ஜனங்களை எல்லாம் தோற்கடிப்பேன். ");
INSERT INTO tam2008_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","“அந்த ஜனங்களின் தேவர்களைத் தொழுதுகொள்ளாதீர்கள். அவைகளுக்கு முன்பு பணியாதீர்கள். அவர்கள் வாழுகிறபடி நீங்கள் வாழாதீர்கள். அவர்களின் விக்கிரகங்களை அழித்துவிடுங்கள். அவர்கள் தெய்வங்களின் நினைவுச் சின்னங்களை உடைத்துவிடுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","உங்கள் தேவனாகிய கர்த்தருக்குச் சேவை செய்யுங்கள். நீங்கள் இதைச் செய்தால், உங்களை ஏராளமான ஆகாரத்தாலும், தண்ணீராலும் ஆசீர்வதிப்பேன். உங்களிலிருந்து எல்லா நோய்களையும் அகற்றுவேன். ");
INSERT INTO tam2008_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","உங்களது பெண்களுக்கு குழந்தைகள் பிறக்கும், உங்களது பெண்களின் பிரசவத்தின்போது குழந்தைகள் மரிப்பதில்லை. நீங்கள் நீண்ட ஆயுளோடு இருக்கும்படிச் செய்வேன். ");
INSERT INTO tam2008_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“உங்கள் எதிரிகளோடு போரிடும்போது உங்களுக்கு முன்பாக என் வல்லமையின் செய்தியை அனுப்புவேன். போரில் உங்கள் எதிரிகள் குழப்பமுற்று ஓடுவார்கள். நான் உங்கள் பகைவர்களை வெல்ல உங்களுக்கு உதவுவேன். ");
INSERT INTO tam2008_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","உங்கள் பகைவர்களை விரட்ட காட்டுக் குளவிகளை உங்கள் முன் அனுப்புவேன். ஏவியரும், கானானியரும் ஏத்தியரும் உங்கள் தேசத்தை விட்டுப் போவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","ஆனால் உங்கள் தேசத்திலிருந்து இவர்களை உடனடியாக விரட்டமாட்டேன். ஒரே ஆண்டில் நான் இதைச் செய்தால் நாடு வெறுமையாகிவிடும். எல்லாக் காட்டு மிருகங்களும் பெருகி நாட்டை ஆக்கிரமிக்கும். அவை உங்களுக்குத் தொல்லையாக மாறும். ");
INSERT INTO tam2008_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","எனவே உங்கள் நாட்டினின்று அந்த ஜனங்களை சிறிது சிறிதாக அனுப்புவேன். தேசத்தில் நீங்கள் தொடர்ந்து முன்னேறுவீர்கள். நீங்கள் போகுமிடமெல்லாம் அந்நியரை உங்களுக்கு முன்பாக விரட்டுவேன். ");
INSERT INTO tam2008_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“செங்கடலிலிருந்து ஐப்பிராத்து நதி வரைக்குமுள்ள நாட்டை உங்களுக்குத் தருவேன். பெலிஸ்திய கடல் (மத்திய தரைக் கடல்) மேற்கு எல்லையாகவும் அரேபிய பாலைவனம் கிழக்கு எல்லையாகவும் இருக்கும். அங்கு வாழும் ஜனங்களை நீங்கள் தோற்கடிக்கச் செய்வேன். அங்குள்ள ஜனங்களெல் லோரும் விலகிப் போகும்படி செய்வீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","“அவர்களோடும், அவர்களது தேவர்களோடும் எந்த ஒப்பந்தத்தையும் செய்யாதீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","அவர்கள் உங்கள் நாட்டில் தங்க விடாதீர்கள். அவர்களைத் தங்க அனுமதிப்பது உங்களுக்குக் கண்ணியாக அமையும். எனக்கு விரோதமாக பாவம் செய்யவும், அந்நிய தேவர்களை நீங்கள் தொழுதுகொள்ளவும் அவர்கள் உங்களைத் தூண்டுவார்கள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","தேவன் மோசேயை நோக்கி, “நீயும் ஆரோன், நாதாப், அபியூ, மற்றும் இஸ்ரவேலின் 70 மூப்பர்களும் (தலைவர்கள்) மலையின் மேல் வந்து என்னைத் தூரத்திலிருந்து தொழுதுகொள்ள வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","பின்பு மோசே மாத்திரம் கர்த்தரிடம் நெருங்கி வருவான். மற்றவர்கள் கர்த்தரை நெருங்கி மலை மீது ஏறி வரக்கூடாது” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","கர்த்தர் கூறிய எல்லா விதிகளையும், கட்டளைகளையும் மோசே ஜனங்களுக்குக் கூறினான். எல்லா ஜனங்களும், “கர்த்தர் கூறின எல்லா கட்டளைகளுக்கும் நாங்கள் கீழ்ப்படிவோம்” என்று ஏகமாய் பதிலுரைத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","எனவே மோசே ஒரு சுருளில் கர்த்தரின் கட்டளைகளை எழுதினான். மறுநாள் காலையில் மோசே எழுந்து மலையடிவாரத்தில், ஒவ்வொரு கல்லும் இஸ்ரவேலின் பன்னிரண்டு கோத்திரங்களைக் குறிக்கும் வகையில் பன்னிரண்டு கற்களால் ஒரு பலிபீடத்தைக் கட்டினான். ");
INSERT INTO tam2008_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","பின் மோசே இஸ்ர வேலின் வாலிபர்களைப் பலி செலுத்தவதற்காக அழைத்தனுப்பினான். தகன பலியாகவும் சமாதான பலியாகவும் அவர்கள் இளங் காளைகளைப் பலியிட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","மோசே இம்மிருகங்களின் இரத்தத்தை எடுத்து வைத்தான். அந்த இரத்தத்தில் பாதியைக் கிண் ணங்களில் ஊற்றினான். மீதியைப் பலி பீடத் தின்மேல் தெளித்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","விசேஷ உடன்படிக்கை பொருந்திய சுருளை எல்லா ஜனங்களும் கேட்கும்படியாக மோசே வாசித்தான். அதைக் கேட்டதும் ஜனங்கள், “கர்த்தர் எங்களுக்குக் கொடுத்த சட்டங்களைக் கேட்டோம். அவற்றிற்குக் கீழ்ப்படிய சம்மதிக்கிறோம்” என்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","பலிகளின் இரத்தத்தைச் சேகரித்து வைத்திருந்த கிண்ணத்தை மோசே உயர்த்தி, இரத்தத்தை ஜனங் கள் மீது தெளித்தான். அவன், “கர்த்தர் உங்களோடு ஒரு விசேஷ உடன்படிக்கையைச் செய்தார் என்பதை இந்த இரத்தம் குறிக்கிறது. தேவன் கொடுத்த சட்டங்கள் இந்த உடன்படிக்கையை விளக்குகின் றன” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","பின்பு மோசே, ஆரோன், நாதாப், அபியூ மற்றும் இஸ்ரவேலின் 70 மூப்பர்களும் (தலைவர்கள்) மலை யின் மீது ஏறி, ");
INSERT INTO tam2008_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","இஸ்ரவேலின் தேவனைக் கண்ட னர். அவர் நின்றிருந்த இடம் வானத்தின் நிறமுள்ள தெளிந்த நீல இரத்தினக் கற்பாறை போன்று காணப் பட்டது! ");
INSERT INTO tam2008_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","இஸ்ரவேலின் மூப்பர் எல்லோரும் தேவனைக் கண்டார்கள். ஆனால் தேவன் அவர் களை அழிக்கவில்லை. அவர்கள் எல்லோரும் சேர்ந்து சாப்பிட்டு குடித்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","கர்த்தர் மோசேயை நோக்கி, “மலையின் உச்சியில் என்னிடம் வா. அங்கே எனது கற்பலகைகளையும், நீ அவர்களுக்கு கற்றுக் கொடுக்க வேண்டிய நியாயப்பிரமாணத்தையும், கற்பனைகளையும் நான் உனக்கு கொடுப்பேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","மோசேயும், அவனது உதவியாளனாகிய யோசுவாவும் தேவனின் மலையின் மீது ஏறினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","மோசே இஸ்ரவேல் மூப்பர்களிடம் (தலைவர்களிடம்), “இங்கே எங்களுக்காகக் காத்திருங்கள். நாங்கள் உங்களிடம் திரும்பி வருவோம். நான் இல்லாதபோது, ஆரோனும், ஊரும் உங்களைக் கண்காணிப்பார்கள். பிரச்சனை ஏதேனும் வந்தால் அவர்களிடம் செல்லுங்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","பின்பு மோசே மலையின் மீது ஏறினான். மேகம் மலையைச் சூழ்ந்துகொண்டது. ");
INSERT INTO tam2008_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","கர்த்தரின் மகிமை சீனாய் மலையின் மீது இறங்கியது. மேகம் மலையை சுற்றி ஆறு நாட்கள் சூழ்ந்திருந்தது. ஏழாவது நாளில் கர்த்தர் மேகத்திலிருந்து மோசேயிடம் பேசினார். ");
INSERT INTO tam2008_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","இஸ்ரவேல் ஜனங்கள் கர்த்தரின் மகிமையைக் கண்டார்கள். மலை உச்சியின் மீது எரிகிற நெருப்பைப் போன்று அது இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","பின்பு மோசே மலையின் உச்சியில் மேகத்துக்குள் சென்றான். அங்கே மோசே 40 பகலையும் 40 இரவையும் கழித்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","கர்த்தர் மோசேயை நோக்கி, ");
INSERT INTO tam2008_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“இஸ்ரவேல் ஜனங்களிடம் காணிக்கைகளைக் கொண்டு வரச் சொல். எனக்குக் கொடுக்க விரும்புவதைக் குறித்து அவனவன் தீர்மானிக் கட்டும். அவற்றை நீ எனக்காகப் பெற்றுக்கொள். ");
INSERT INTO tam2008_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","ஜனங்களிடமிருந்து நீ பெறக்கூடிய பொருட்களின் பட்டியல் இவை: பொன், வெள்ளி, வெண்கலம், ");
INSERT INTO tam2008_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","இளநீலநூல், இரத்தாம்பர நூல், சிவப்பு நூல், மெல்லிய துகில், வெள்ளாட்டு மயிர், ");
INSERT INTO tam2008_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","சிவப்பு சாயம் தோய்த்த ஆட்டுத் தோல், மெல்லிய தோல், சீத்திம் மரம், ");
INSERT INTO tam2008_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","அகல் எண்ணெய், அபிஷேக எணணெய்ப் பொருட்கள், நறுமணப்புகைப் பொருட்கள், ");
INSERT INTO tam2008_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ஏபோத்திலும், நியாயத்தீர்ப்பு மார்ப்பதக்கத்திலும் பதிக்கும் கோமேதகக் கற்களும் பிற இரத்தினக் கற்களும் ஆகும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","மேலும் தேவன், “ஜனங்கள் எனக்காக பரிசுத்த பிரகாரத்தை ஏற்படுத்த வேண்டும். அப்போது நான் அவர்கள் மத்தியில் வாழ்வேன். ");
INSERT INTO tam2008_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","பரிசுத்தக் கூடாரமும் அதிலுள்ள பொருட்களும் எவ்வாறு இருக்க வேண்டுமென்பதை நான் உனக்குக் காட்டுவேன். நான் காட்டுகிற மாதிரியின்படியே எல்லாவற்றையும் தவறாமல் செய். ");
INSERT INTO tam2008_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“சீத்திம் மரத்தால் விசேஷமான பெட்டி ஒன்றைச் செய். இப்பரிசுத்த பெட்டி 45 அங்குல நீளமும், 27 அங்குல அகலமும், 27 அங்குல உயரமும் இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","பெட்டியின் உட்புறத்தையும், வெளிப்புறத்தையும் மூடுவதற்காக சுத்தமான தங்கத்தை உபயோகி. பெட்டியின் விளிம்புகளையும் தங்கத் தகட்டால் மூடவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","பெட்டியைத் தூக்குவதற்கு நான்கு தங்க வளையங்களைச் செய். பக்கத்திற்கு இரண்டாக நான்கு மூலைகளிலும் தங்க வளையங்களைப் போடு. பின் பெட்டியைத் தூக்கிச் செல்ல கழிகளைச் செய். இந்த கழிகள் சீத்திம் மரத்தில் செய்யப்பட்டு தங்கத்தால் மூடப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","பெட்டியைச் சுமப்பதற்குத் தண்டுகளைச் செய். அவை சீத்திம் மரத்தால் செய்யப்பட்டு பொன்னால் மூடப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","பெட்டியின் ஓரங்களிலுள்ள வளையங்களில் அத்தண்டுகளை நுழைக்க வேண்டும். பெட்டியைச் சுமப்பதற்கு இத்தண்டுகளைப் பயன்படுத்த வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","இத்தண்டுகள் எப்போதும் பெட்டியின் வளையங்களில் இருக்க வேண்டும். தண்டுகளை அப்புறப்படுத்தக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","“நான் உனக்கு உடன்படிக்கையைக் கொடுப்பேன். அந்த உடன்படிக்கையை இப்பெட்டியில் வை. ");
INSERT INTO tam2008_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","பின் ஒரு கிருபாசனத்தை பசும் பொன்னால் செய். 45 அங்குல நீளமும் 27 அங்குல அகலமும் உள்ளதாக அதைச் செய். ");
INSERT INTO tam2008_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","பின்பு தங்கத்தினால் இரண்டு கேருபீன்களைச் செய்து அவற்றை கிருபாசனத்தின் இரு முனைகளிலும் வை. தகடாய் அடித்த பொன்னால் அவற்றைச் செய். ");
INSERT INTO tam2008_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ஒரு கேருபீனை ஒரு முனையிலும் மற்ற கேருபீனை மறு முனையிலும் வை. இந்த கேருபீன்கள் ஒன்றாக இருக்கும்படி கிருபாசனத்தோடு இணை. ");
INSERT INTO tam2008_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","பொன் கேருபீன்களின் சிறகுகள் வானத்தை நோக்கி உயர்ந்திருக்க வேண்டும். அவை தங்கள் சிறகுகளால் பெட்டியை மூட வேண்டும். அவை ஒன்றுக்கொன்று எதிராக கிருபாசனத்தை நோக்கியபடி இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","“நான் உனக்கு கொடுக்கும் உடன்படிக்கையைப் பரிசுத்த பெட்டிக்குள் வை. பெட்டியின் மீது கிருபாசனத்தை பொருத்து. ");
INSERT INTO tam2008_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","நான் உன்னைச் சந்திக்கும்போது, உடன்படிக்கைப் பெட்டியின் மேலுள்ள கேருபீன்களின் மத்தியிலிருந்து உன்னோடு பேசுவேன். அங்கிருந்து இஸ்ரவேல் ஜனங்களுக்கு எல்லாக் கட்டளைகளையும் கொடுப்பேன். ");
INSERT INTO tam2008_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“சீத்திம் மரத்தால் ஒரு மேசையைச் செய். அது 36 அங்குல நீளம், 18 அங்குல அகலமும், 27 அங்குல உயரமும் உள்ளதாக இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","மேசையைப் பசும் பொன்னால் மூடி, சுற்றிலும் தங்கத் தகட்டால் அழகுபடுத்து. ");
INSERT INTO tam2008_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","மூன்று அங்குல அகலமான சட்டத்தை மேசையைச் சுற்றிலும் வை. சட்டத்தைப் பொன் தகட்டால் அழகுபடுத்து. ");
INSERT INTO tam2008_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","நான்கு பொன் வளையங்களைச் செய்து அவற்றை மேசையின் நான்கு கால்கள் இருக்கும் ஓரங்களில் வை. ");
INSERT INTO tam2008_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","மேசையின் மேல் சட்டத்தைச் சுற்றிலும் சுருக்கமாக வளையங்களைப் பொருத்து. இந்த வளையங்கள் மேசையைச் சுமந்து செல்லும் தண்டுகளைத் தாங்கிக்கொள்ளும். ");
INSERT INTO tam2008_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","தண்டுகளைச் சீத்திம் மரத்தினால் செய்து அவற்றைப் பொன்னால் மூடு. தண்டுகள் மேசையைச் சுமந்து செல்லப் பயன்படும். ");
INSERT INTO tam2008_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","தட்டுகளையும், கரண்டிகளையும், கிண்ணங்களையும், குவளைகளையும் பசும்பொன்னால் செய். பானங்களின் காணிக்கைகளைக் கொட்டுவதற்கும், ஊற்றுவதற்கும் குவளைகளும், கிண்ணங்களும் பயன்படும். ");
INSERT INTO tam2008_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","பரிசுத்த ரொட்டியை எனக்கு முன்பாக மேசையின் மீது வை. அது எப்போதும் தவறாமல் எனக்கு முன்பாக இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“பின் நீ விளக்குத் தண்டைச் செய்ய வேண்டும். சுத்தமான பொன்னைப் பயன்படுத்தி அதன் அடிப்பகுதியைச் சுத்தியால் அடித்துச் செய்ய வேண்டும். பூக்கள், மொக்குகள், இலைகள் பூசிய பொன்னால் அமையவேண்டும். அதிலுள்ள எல்லாவற்றையும் ஒரே துண்டாக இணைத்து அமைக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","“அந்தக் குத்துவிளக்குத் தண்டுக்கு ஆறு கிளைகள் இருக்கவேண்டும். மூன்று கிளைகள் ஒரு புறமாகவும், மூன்று கிளைகள் மறு புறமாகவும் அமைய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ஒவ்வொரு கிளையிலும் மூன்று பூக்கள் இருக்கவேண்டும். வாதுமைப் பூக்களைப் போல் மொக்குகளோடும், இதழ்களோடும் இப்பூக்களைச் செய்ய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","மேலும் நான்கு பூக்களை விளக்குத் தண்டுக்காகச் செய். இவை மொக்குகளும் இதழ்களும் கொண்ட வாதுமைப் பூக்களைப் போலிருக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","குத்துவிளக்கில் ஆறு கிளைகள் இருக்க வேண்டும். அடிப் பகுதியிலிருந்து மும் மூன்று கிளைகளை ஒவ்வொரு புறத்திலும் இணைக்கவேண்டும். கிளைகள் தண்டில் சேரும் மூன்று இடங்களின் அடிப்பகுதியிலும் மொக்குகளும் இதழ்களும் கொண்ட ஒவ்வொரு பூவை இணைக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","பூக்களும் இலைகளும் பொருத்திய குத்துவிளக்குத் தண்டானது முழுவதும் சுத்தமான பொன்னால் செய்யப்பட வேண்டும். வெவ்வேறு பாகங்களைச் சுத்தியால் அடித்து ஒன்றாக இணைக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","பின் குத்து விளக்குத் தண்டில் ஏழு அகல்களைப் பொருத்த வேண்டும். குத்து விளக்கின் முன்னே இந்த அகல்கள் ஒளி தரும். ");
INSERT INTO tam2008_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","திரிகளைக் கத்தரிக்கும் கத்தரிகளும், சாம்பல் கிண்ணங்களும் பொன்னால் செய்யப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","குத்துவிளக்கையும் அதற்குத் தேவையான பொருட்களையும் செய்வதற்கு 75 பவுண்டு எடையுள்ள பசும் பொன்னைப் பயன்படுத்து. ");
INSERT INTO tam2008_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","மலையின் மீது உனக்கு காட்டியபடியே ஒவ்வொரு பொருளையும் செய்வதில் கவனமாயிரு” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","கர்த்தர் மோசேயை நோக்கி, “பரிசுத்தக் கூடாரம் பத்து திரைச் சீலைகளால் தைக்கப்பட வேண்டும். இந்த திரைச்சீலைகள் மெல்லிய துகில், இளநீலம், இரத்தாம்பரம் சிவப்பு ஆகிய நூல்களால் நெய்யப்படவேண்டும். ஒரு திறமை வாய்ந்த ஓவியன் இத்திரைச் சீலையில் சிறகுகளுள்ள கேரூபீன்களின் ஓவியங்களை நெய்ய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","எல்லாத் திரைகளும் ஒரே அளவுடையதாய் இருக்க வேண்டும். ஒவ்வொன்றும் 28 முழ நீளமும் 4 முழ அகலமுமாக இருக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","இரண்டு பிரிவாகத் திரைகளை இணை. ஐந்து திரைகளை ஒன்றாகவும், மற்ற ஐந்து திரைகளை வேறாகவும் இணை. ");
INSERT INTO tam2008_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","ஒரு பிரிவின் விளிம்பில் இளநீலத் துணியால் கண்ணிகளை உருவாக்கு. இவ்வாறே மற்ற பிரிவின் விளிம்பு திரையிலும் செய். ");
INSERT INTO tam2008_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","முதலிணைப்பில் 50 கண்ணிகளும் இரண்டாம் இணைப்பில் 50 கண்ணிகளும் தைக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","பின்பு திரைகளை இணைப்பதற்கு 50 பொன்வளையங்களைச் செய். அது பரிசுத்தக் கூடாரத்தை ஒன்றாக இணைத்துவிடும். ");
INSERT INTO tam2008_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“பரிசுத்தக் கூடாரத்திற்கு மேல் மற்றொரு கூடாரத்தை உருவாக்கு. இக்கூடாரம் செய்வதற்குப் பதினொரு திரைகளைப் பயன்படுத்து. வெள்ளாட்டு மயிரால் இத்திரைகளை நெசவு செய். ");
INSERT INTO tam2008_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","எல்லாத் திரைகளும் ஒரே அளவுடையதாய் இருக்க வேண்டும். 30 முழ நீளமும் 4 முழ அகலமும் உடையதாய் அது இருக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","ஐந்து திரைகளை ஒன்றாகவும், வேறு 6 திரைகளை ஒன்றாகவும் இணைக்கவேண்டும். ஆறாம் திரையின் பாதிப் பகுதியை கூடாரத்தின் முன் பகுதியில் மடித்துவிட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","ஒரு திரையிணைப்பின் கடைசித் திரையில் 50 கண்ணிகளையும் இன்னொரு திரையிணைப்பின் கடைசித் திரையில் 50 கண்ணிகளையும் தைக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","பின்னர் திரைகளை இணைப்பதற்கு 50 வெண்கல வளையங்களைச் செய். அவை கூடாரத்தின் இருபகுதிகளையும் ஒன்றாக இணைக்கும். ");
INSERT INTO tam2008_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","இக்கூடாரத்தின் இறுதித் திரையின் பாதிப்பகுதி பரிசுத்தக் கூடாரத்தின் பின் பகுதியில் தொங்கிக்கொண்டிருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","அதன் பக்க வாட்டில் பரிசுத்தக் கூடாரத்தின் திரைகள் பரிசுத்தக் கூடாரத்தின் கீழ்ப்புற ஓரங்களைக் காட்டிலும் ஒரு முழம் தாழ்வாகத் தொங்கும். இவ்வாறு பரிசுத்தக் கூடாரம் மகா பரிசுத்தக் கூடாரத்தை முற்றிலும் மறைக்கும். ");
INSERT INTO tam2008_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","மகா பரிசுத்தக் கூடாரத்தை மறைப்பதற்கு இரண்டு உறைகளைச் செய். சிவப்புச் சாயம் தீர்த்த ஆட்டுக்கடா தோலினால் ஒரு உறையும் மெல்லிய தோலினால் மற்றொரு உறையும் செய்யப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“பரிசுத்தக் கூடாரத்தைத் தாங்குவதற்காகச் சட்டங்களை சீத்திம் மரத்தால் செய்ய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","அச்சட்டங்கள் 10 முழ உயரமும் 1 1/2 முழ அகலமும் உள்ளதாக இருக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","ஒவ்வொரு புறமுள்ள தூண்கள் குறுக்குத் துண்டுகளால் ஒவ்வொரு சட்டமாகச் சேர்க்கப்படவேண்டும். பரிசுத்த கூடாரத்தின் எல்லாச் சட்டங்களும் ஒரே அளவுடையதாக இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","பரிசுத்த கூடாரத்தின் தென் புறத்திற்கென்று 20 சட்டங்களை உருவாக்கு. ");
INSERT INTO tam2008_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","சட்டங்களுக்கு 40 வெள்ளிப் பீடங்களை உண்டாக்கு. ஒவ்வொரு சட்டத்தின் கீழும் இரண்டு பீடங்கள் வீதம் அமைய வேண்டும். ஒவ்வொரு பக்கத் தூணுக்கும் ஒருபீடம் வீதம் இருக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","பரிசுத்தக் கூடாரத்தின் மறுபக்கத்திற்கென்று (வடக்குப் புறம்) மேலும் இருபது சட்டங்கள் செய். ");
INSERT INTO tam2008_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","நாற்பது வெள்ளி பீடங்கள் ஒவ்வொரு சட்டத்திற்கும் இரண்டு வீதம் செய். ");
INSERT INTO tam2008_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","ஆறு சட்டங்கள் பரிசுத்தக் கூடாரத்தின் பின்புறத்திற்கு (மேற்குப்பக்கம்) அமைத்துவிடு. ");
INSERT INTO tam2008_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","பரிசுத்தக் கூடாரத்தின் பின்புறத்து மூலைகளுக்கென்று இரண்டு சட்டங்கள் செய். ");
INSERT INTO tam2008_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","மூலைகளிலுள்ள சட்டங்கள் அடியில் சேர்க்கப்படவேண்டும். மேற்புறத்தில் சட்டங்களை ஒரு வளையத்தால் இணைக்கவேண்டும். இரண்டு மூலைகளுக்கும் அவ்வாறே செய். ");
INSERT INTO tam2008_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","கூடாரத்தின் மேற்குப்புறத்திற்கு எட்டுச் சட்டங்கள் இருக்கும். 16 வெள்ளிப் பீடங்கள் ஒவ்வொரு சட்டத்திற்கு இரண்டு வீதம் அமையும். ");
INSERT INTO tam2008_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“பரிசுத்த கூடாரத்தின் சட்டங்களுக்குச் சீத்திம் மரத்தாலான தாழ்ப்பாள்களைச் செய். பரிசுத்த கூடாரத்தின் முன்புறத்திற்கு ஐந்து தாழ்ப்பாள்கள் இருக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","பரிசுத்த கூடாரத்தின் பின்னாலுள்ள (மேற்குப் புறத்தின்) சட்டங்களுக்கு ஐந்து தாழ்ப்பாள்கள் இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","நடுவிலுள்ள தாழ்ப்பாள் ஒரு மூலையிலிருந்து மறுமூலைவரைக்கும் சட்டங்கள் வழியாகச் செல்லவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","“இந்த சட்டங்களைப் பொன் தகட்டால் மூடு. தாழ்ப்பாள்களை இணைப்பதற்குப் பொன் வளையங்களை உண்டுபண்ணு. தாழ்ப்பாள்களுக்கும் பொன் முலாம் பூசு. ");
INSERT INTO tam2008_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","மலையில் நான் உனக்குக் காட்டிய மாதிரியின்படியே பரிசுத்தக் கூடாரத்தை உண்டாக்கு. ");
INSERT INTO tam2008_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“பரிசுத்தக் கூடாரத்தின் உட்புறத்தில் விரிப்பதற்கு மெல்லிய துகிலினால் ஒரு விசேஷ திரைச் சீலையை உண்டாக்கு. நீலம், இரத்தாம்பரம், சிவப்பு நூலால் அந்தத் திரைச்சீலையை உண்டாக்கி, அதிலே கேரூ பின்களின் சித்திரங்களைப் பின்னு. ");
INSERT INTO tam2008_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","சீத்திம் மரத்தால் நான்கு தூண்களை உண்டாக்கி அவற்றைப் பொன்னால் மூடு. நான்கு தூண்கள் மேலும் பொன்னால் ஆன கொக்கிகளை இணை. தூண்களுக்கு அடியில் நான்கு வெள்ளி பீடங்களை வை. பிறகு திரைச் சீலையைத் தங்கக் கொக்கிகளில் தொங்கவிடு. ");
INSERT INTO tam2008_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","பொன் வளையங்களுக்குக் கீழே திரைகளைத் தொங்கவிடு. நீ செய்த உடன்படிக்கைப் பெட்டியைத் திரைக்குப் பின்னே வை. இந்தத் திரையானது பரிசுத்த இடத்தையும், மகா பரிசுத்த இடத்தையும் பிரிக்கும். ");
INSERT INTO tam2008_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","உடன்படிக்கைப் பெட்டியை அதன் கிருபாசனத்தால் மூடிவை. ");
INSERT INTO tam2008_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","“பின்பு பரிசுத்த இடத்தின் திரையின் முன் புறத்தில் நீ செய்த விசேஷ மேசையை வை. பரிசுத்த கூடாரத்தின் வடக்குப்புறத்தில் மேசை இருக்க வேண்டும். குத்துவிளக்குத் தண்டை தெற்குப் புறத்தில் வை. அது மேசையின் குறுக்காக இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“பரிசுத்தக் கூடாரத்தின் நுழைவாயிலை மூடுவதற்கு ஒரு திரையை உருவாக்குங்கள். நீலம், இரத்தாம்பரம், சிவப்பு நூலாலும், மெல்லிய துகிலாலும், இத்திரையை உண்டாக்கு. அதில் சித்திரங்களைப் பின்னி வை. ");
INSERT INTO tam2008_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","திரைகளுக்குப் பொன் கொக்கிகளை உண்டாக்கு. பொன் முலாம் பூசப்பட்ட சீத்திம் மரத்தால் ஐந்து தூண்களைச் செய். ஐந்து தூண்களுக்கும் வெண்கலத்தால் ஐந்து பீடங்களைச் செய்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","கர்த்தர் மோசேயை நோக்கி, “சீத்திம் மரத்தால் ஒரு பலிபீடம் செய். அப்பலிபீடம் சதுர வடிவமாக இருக்கவேண்டும். 5 முழ நீளமும், 5 முழ அகலமும், 3 முழ உயரமும் இருக்கட்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","பலிபீடத்தின் நான்கு மூலைகளிலும் நான்கு கொம்புகளைப் பொருத்து. இப்படி பலிபீடமும், கொம்புகளும் ஒரே துண்டாக இருக்கும். பலி பீடத்தை வெண்கலத்தால் மூட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","“பலிபீடத்தில் பயன்படுத்தும் பாத்திரங்களும், கருவிகளும் வெண்கலத்தால் செய்யப்பட்டவையாக இருக்கட்டும். பானைகள், அகப்பைகள், கிண்ணங்கள், முள் கரண்டிகள், நெருப்புச் சட்டிகள் ஆகியவற்றைச் செய். பலிபீடத்தின் சாம்பலை அகற்றுவதற்காக இவை பயன்படும். ");
INSERT INTO tam2008_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","பலபீடத்திற்கு வலை போன்ற ஒரு சல்லடை செய்யவேண்டும். சல்லடையின் நான்கு மூலைகளிலும் ஒவ்வொரு வெண்கல வளையங்களை உண்டாக்கு. ");
INSERT INTO tam2008_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","பலிபீடத்தின் கீழ்ப்புறத்தில் பாதி உயரத்தில் அந்த சல்லடையை உட்கார வை. ");
INSERT INTO tam2008_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","“பலிபீடத்திற்கான தூண்களை சீத்திம் மரத்தால் செய்து அதை வெண்கலத்தால் மூட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","பலிபீடத்தின் இருபக்கங்களிலும் வளையங்களின் வழியே தண்டுகளைச் செலுத்து. பலிபீடத்தைச் சுமப்பதற்கு இத்தண்டுகளைப் பயன்படுத்து. ");
INSERT INTO tam2008_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","பல கைகளால் செய்யப்பட்ட பக்கங்களை உடைய உட்குழியுள்ள பெட்டியைப்போல பலிபீடத்தைச் செய்ய வேண்டும். நான் மலையில் உனக்குக் காண்பித்தபடியே பலி பீடத்தைச் செய்யவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“பரிசுத்த கூடாரத்திற்கு ஒரு வெளிப்பிரகாரம் அமைப்பாயாக. அது 100 முழ நீளமான திரைகளால் தெற்குப்புறம் மறைக்கப்படட்டும். மெல்லிய துகிலால் இத்திரைகள் அமைய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","20 வெண்கல பீடங்கள் உள்ள 20 தூண்களைப் பயன்படுத்து. தூண்களின் கொக்கிகளும், திரைப் பூண்களும் வெள்ளியால் செய்யப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","வடபுறத்திலும் திரைச் சுவர் 100 முழ நீளமாக இருக்க வேண்டும். அதற்கு 20 தூண்களும், 20 வெண்கலப் பீடங்களும் இருக்கவேண்டும். தூண்களின் கொக்கிகளும், திரைப் பூண்களும் வெள்ளியால் செய்யப் படவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“வெளிப்பிரகாரத்தின் மேற்குப்புறத்தில் 50 முழ நீளமுள்ள திரைச்சுவர் இருக்க வேண்டும். 10 தூண்களும், 10 பீடங்களும் இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","வெளிப்பிரகாரத்தின் கிழக்குப் புறமும் 50 முழ அகலம் இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","வெளிப்பிரகாரத்தின் நுழை வாயில் கிழக்குப் புறத்திலேயே அமையட்டும். நுழைவாயிலின் ஒருபுறம் 15 முழ நீளமான திரைகளும், 3 தூண்களும், 3 பீடங்களும் இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","அதன் மறுபுறமும் 15 முழ நீளமான திரைகளும், மூன்று தூண்களும், அவற்றிற்கு மூன்று பீடங்களும் இருக்கட்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“வெளிப்பிரகாரத்தின் நுழைவாயிலை மூடுவதற்கு 20 முழ நீளமான திரை இருக்கவேண்டும். மெல்லிய துகில், இளநீலம், இரத்தாம்பரம், சிவப்பு நூலாலும் ஆகிய துணிகளால் திரைகளையும், அதில் சித்திர வேலைப்பாடுகளையும் செய். நான்கு பீடங்கள் உள்ள நான்கு தூண்கள் திரைக்கென இருக்கட்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","வெளிப்பிரகாரத்தைச் சுற்றிலுமுள்ள அனைத்துத் தூண்களும் வெள்ளி பூண்களும், வெள்ளிக் கொக்கிகளும், வெண்கலப் பீடங்களும் கொண்டதாக இருக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","100 முழ நீளமும் 50 முழ அகலமும் கொண்டதாக வெளிப்பிரகாரம் இருக்கவேண்டும். வெளிப்பிரகாரத்தைச் சுற்றிலு முள்ள திரைகளின் சுவர் 5 முழ உயரம் இருக்க வேண்டும். திரைகள் மெல்லிய துகிலால் நெய்யப்பட வேண்டும். தூண்களின் பீடங்கள் வெண்கலத்தாலாக வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","எல்லாக் கருவிகளும், கூடாரத்தின் ஆணிகளும், பரிசுத்தக் கூடாரத்திற்குத் தேவையான எல்லாப் பொருட்களும் வெண்கலத்தால் அமைய வேண்டும். வெளிப்பிரகாரத்திற்கான திரைகளுக்குத் தேவையான கூடார ஆணிகளும் வெண்கலத்தால் செய்யப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“தரத்தில் உயர்ந்த ஒலிவ எண்ணெயைக் கொண்டுவரும்படியாக இஸ்ரவேல் ஜனங்களுக்குக் கட்டளையிடு. தினமும் மாலை நேரத்தில் ஏற்றப்பட வேண்டிய விளக்கிற்கு இந்த எண்ணெயைப் பயன்படுத்து. ");
INSERT INTO tam2008_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","ஆரோனும், அவன் மகன்களும் விளக்கைச் சுத்திகரிக்கும் வேலையைச் செய்ய வேண்டும். ஆசரிப்புக் கூடாரத்தின் முன் அறைக்குள் அவர்கள் செல்வார்கள். இது உடன்படிக்கை இருக்கும் அறைக்கு முன்பாக இருக்கும் வெளிப்புற அறை. ஒரு திரை இந்த இரண்டு அறைகளையும் பிரிக்கும். மாலை முதல், காலைவரை கர்த்தருக்கு முன் விளக்கு தொடர்ந்து எரிந்துக்கொண்டே இருக்கும்படி அவர்கள் அதைக் கவனித்து வரவேண்டும். இஸ்ரவேல் ஜனங்களும், அவர்கள் சந்ததியும் இச்சட்டத்தை என்றென்றைக்கும் பின்பற்ற வேண்டும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","கர்த்தர் மோசேயை நோக்கி, “உன் சகோதரனாகிய ஆரோனையும், நாதாப், அபியூ, எலெயாசார், இத்தாமார் என்னும் ஆரோனின் மகன்களையும் இஸ்ரவேல் ஜனங்களிடமிருந்து பிரித்து உன்னிடம் வரவழை. இவர்கள் எனக்கு ஆசாரியர்களாக ஊழியம் செய்வார்களாக. ");
INSERT INTO tam2008_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","“உனது சகோதரனாகிய ஆரோனுக்கென்று சிறப்பான ஆடைகளை உண்டாக்கு. அந்த ஆடைகள் அவனுக்குக் கனமும், மேன்மையும் தரும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","இந்த ஆடைகளைச் செய்யும் திறமைமிக்கவர்கள் ஜனங்கள் மத்தியில் இருக்கிறார்கள். அவர்களுக்கு விசேஷ அறிவை நான் கொடுத்துள்ளேன். அவர்களிடம் ஆரோனுடைய ஆடைகளைத் தயாரிக்கச் சொல். அவன் எனக்குச் சிறப்பான பணிவிடை செய்வதை அந்த உடை காட்டும். அவன் என்னைச் சேவிக்கிற ஆசாரியனாகப் பணியாற்றுவான். ");
INSERT INTO tam2008_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","அந்த மனிதர்கள் செய்யவேண்டிய ஆடைகள் இவைகளே: நியாயத்தீர்ப்பு மார்ப்பதக்கம், ஏபோத், நீல அங்கி, முழுவதும் நெய்யப்பட்ட வெள்ளை அங்கி, தலைப்பாகை, கச்சை. ஆரோனுக்கும் அவன் மகன்களுக்கென்றும் இந்தச் சிறப்பு ஆடைகளை உண்டாக்க வேண்டும். பின்பு ஆரோனும், அவனது மகன்களும் எனக்கு ஆசாரியர்களாக ஊழியம் செய்யமுடியும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","பொன்னையும், ஜரிகைகளையும், மெல்லிய துகிலையும், இளநீலம், இரத்தாம்பரம், சிவப்புநிற நூலையும் பயன்படுத்துமாறு அவர்களுக்குச் சொல். ");
INSERT INTO tam2008_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“ஏபோத்தைச் செய்வதற்குப் பொன்னையும், சரிகைகளையும், மெல்லிய துகிலையும், இளநீலம், இரத்தாம்பரம், சிவப்புநிற நூலையும் பயன்படுத்து. இது திறமை மிக்க கலைஞனின் வேலை ஆகும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","ஏபோத்தின் தோள் பகுதி ஒவ்வொன்றிலும் ஒவ்வொரு தோள்பட்டை இருக்கவேண்டும். இந்தத் தோள் பட்டைகள் ஏபோத்தின் இரண்டு மூலைகளிலும் கட்டப்படவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","“ஏபோத்திற்கு ஒரு இடைக்கச்சையைச் செய்ய வேண்டும். ஏபோத்தை நெய்தது போலவே, இடைக் கச்சையையும், பொன் ஜரிகை, மெல்லிய துகில், இளநீலம், இரத்தாம்பரம், சிவப்புநிற நூல் ஆகியவற்றால் செய்ய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“இரண்டு கோமேதகக் கற்களை எடுத்துகொள். இஸ்ரவேலின் (யாக்கோபு) பன்னிரண்டு மகன்களின் பெயர்களையும் அக்கற்களின் மீது எழுது. ");
INSERT INTO tam2008_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ஆறு பெயர்களை ஒரு கல்லிலும், மற்ற ஆறு பெயர்களை மறு கல்லிலும் எழுதவேண்டும். முதல் மகனிலிருந்து கடைசி மகன் வரைக்கும் ஒவ்வொருவரின் பெயர்களையும் எழுதவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","இந்த கற்களின் மீது இஸ்ரவேலின் ஆண் பிள்ளைகளுடைய பெயர்களை செதுக்கவேண்டும். முத்திரை செய்கிற முறைப்படியே இதனையும் செய். பின்பு தங்கச் சட்டங்களில் கற்களைப் பொருத்து. ");
INSERT INTO tam2008_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","ஏபோத்தின் வார்களில் இந்த கற்களைப் பொருத்து. கர்த்தருக்கு முன்னால் நிற்கும்போது ஆரோன் அந்தச் சிவப்பு அங்கியை அணிந்துகொள்வான். ஏபோத்தின்மேல் இஸ்ரவேலின் பன்னிரண்டு மகன்களின் பெயர்களும் உள்ள இரண்டு கற்களும் இருக்கும். இஸ்ரவேல் ஜனங்களை தேவன் நினைவு கூருவதற்கு இக்கற்கள் உதவும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","ஏபோத்தின் மேல் அக்கற்கள் நன்றாக பதிக்கப்பட்டிருக்கும்படி பசும் பொன்னை பயன்படுத்து. ");
INSERT INTO tam2008_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","பொன்னால் இரண்டு பின்னல் வேலையான சங்கிலிகள் செய்து அவற்றைப் பொன் சட்டத்தில் பூட்டவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“தலைமை ஆசாரியனுக்காக நியாயத் தீர்ப்பு மார்ப்பதக்கத்தைச் செய். ஏபோத்தைச் செய்தது போலவே, திறமைமிக்க கை வேலைக்காரர்களைக்கொண்டு இதையும் செய்ய வேண்டும். பொன் ஜரிகையையும், மெல்லிய துகிலையும், இளநீலம், இரத்தாம் பரம், சிவப்பு நிற நூலையும் பயன்படுத்த வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","இந்த நியாயத்தீர்ப்பு மார்ப்பதக்கத்தை இரண்டாக மடித்து ஒரு சதுர பையாக தைக்க வேண்டும். அது 9 அங்குல நீளமும், 9 அங்குல அகலமும் உடைய சதுரமாய் இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","நியாயத்தீர்ப்பு மார்ப்பதக்கத்தில் நான்கு வரிசை விலையுயர்ந்த கற்களைப் பதிக்க வேண்டும். பத்மராகம், புஷ்பராகம், மாணிக்கம் கற்கள் முதல் வரிசையில் இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","இரண்டாவது வரிசையில் மரகதம், இந்திரநீலம், வச்சிரம் ஆகிய கற்கள் இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","மூன்றாவது வரிசையில் கெம்பு, வைடூரியம், சுகந்தி ஆகிய கற்கள் இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","நான்காவது வரிசையில் படிகப்பச்சை, கோமேதகம், யஸ்பி என்ற கற்கள் இருக்க வேண்டும். இவை அனைத்தையும் பொன்னில் பதிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","நியாயத்தீர்ப்பு மார்ப்பதக்கத்தில் மேற்கூறிய பன்னிரெண்டு கற்கள் இருக்க வேண்டும். இஸ்ரவேலின் மகன்கள் ஒவ்வொருவனுக்கும் ஒவ்வொரு கல் இருக்க வேண்டும். முத்திரை செய்கிற வண்ணமே ஒவ்வொரு கல்லிலும் இப்பெயர்கள் பொறிக்கப் பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“சுத்தமான பொன்னினால் ஆன சங்கிலிகளை நியாயத்தீர்ப்பு மார்ப்பதக்கத்திற்காக செய்ய வேண்டும். அவை கயிறு போல் பின்னப்பட்டிருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","இரண்டு பொன் வளையங்களைச் செய்து நியாயத்தீர்ப்பு மார்ப்பதக்கத்தின் இரண்டு மூலைகளிலும் அவற்றை மாட்ட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","இரண்டு பொன் சங்கிலிகளையும் நியாயத்தீர்ப்பு மார்ப்பதக்கத்தின் இரண்டு வளையங்களில் பொருத்து. ");
INSERT INTO tam2008_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","இரண்டு சட்டத்திலும் சங்கிலிகளின் வார்களை இணைத்துவிடு. ஏபோத்தின் முன்பகுதியிலுள்ள இரண்டு தோள் பட்டைகளிலும் இவை பொருத்தப்பட்டிருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","மேலும் இரண்டு பொன் வளையங்களைச் செய்து அவற்றை நியாயத்தீர்ப்பு மார்ப்பதக்கத்தின் மூலைகளில் பொருத்து. ஏபோத்துக்கு பொருத்தின நியாயத்தீர்ப்பு மார்ப்பதக்கத்தின் உட்புற மூலைகளில் இது இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","இன்னும் இரண்டு பொன் வளையங்களைச் செய்து அவற்றை ஏபோத்தின் முன்புறமுள்ள தோள் பட்டைகளின் கீழ்ப்பகுதியில் பொருத்து. பொன் வளையங்களை ஏபோத்தின் இடைக் கச்சைக்கு மேல் வை. ");
INSERT INTO tam2008_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","நியாயத்தீர்ப்பு மார்ப்பதக்கத்தின் வளையங்களை ஏபோத்தின் வளையங்களோடு இணைப்பதற்கு நீல நிற நாடாவைப் பயன்படுத்து. இதனால் நியாயத்தீர்ப்பு மார்ப்பதக்கம் கச்சைக்கு அருகேயும் ஏபோத்திற்கு எதிரேயும் இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“பரிசுத்த இடத்துக்குள் ஆரோன் நுழையும்போது, அவன் நியாயத்தீர்ப்பு மார்ப்பதக்கத்தை அணிய வேண்டும். அவனது மார்புக்கு நேராக இஸ்ரவேலின் பன்னிரெண்டு மகன்களின் பேரையும் அவன் அணிந்துகொள்வான். இவ்வாறு கர்த்தர் அவர்களை எப்போதும் நினைவு கூருவார். ");
INSERT INTO tam2008_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","நியாயத்தீர்ப்பு மார்ப்பதக்கத்திற்குள் ஊரீமையும் தும்மீமையும் வை. கர்த்தருக்கு முன் செல்லும்போது இவை ஆரோனின் மார்புக்கு மேலாக இருக்கும். இப்படியாக இஸ்ரவேல் ஜனங்களின் நியாயத்தீர்ப்பை கர்த்தருக்கு முன்பாக ஆரோன் எப்போதும் சுமந்து செல்வான். ");
INSERT INTO tam2008_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“ஏபோத்திற்காக ஒரு நீல அங்கியைத் தயார் செய். ");
INSERT INTO tam2008_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","தலையை நுழைத்துக்கொள்ளும்பொருட்டு நடுவில் ஒரு துவாரத்தை அமைப்பாயாக. அத்து வாரத்தைச் சுற்றிலும் ஒரு நெய்யப்பட்ட துணியைத் தைத்துவிடு. துவாரம் கிழியாதபடிக்கு அது உதவும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","துணியாலான மாதுளம் பழங்களை உண்டாக்க நீலம், இரத்தாம்பரம், சிவப்பு ஆகிய நூலைப் பயன்படுத்து. அவற்றை வஸ்திரத்தின் ஓரங்களில் சுற்றிலும் தொங்கவிடு. மாதுளம் பழங்களுக்கு இடையில் பொன்மணிகளைத் தொங்கவிடு. ");
INSERT INTO tam2008_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","இவ்வாறு அங்கியின் கீழே பொன் மணிகளும், மாதுளம் பழங்களும் இருக்க வேண்டும். ஒரு மாதுளம் பழமும், ஒரு பொன் மணியுமாக வரிசையாக அமையட்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","ஆரோன் ஆசாரியனாகப் பணிவிடை செய்யும்போது இந்த அங்கியை அணிந்துகொள்ள வேண்டும். கர்த்தரின் முன்னே நிற்கும்படியாக பரிசுத்த இடத்திற்கு அவன் போகும்போது அவன் சாகாத படிக்கு மணிகள் ஒலிக்கும். பரிசுத்த இடத்திலிருந்து வெளியேறும்போதும் அவை ஒலிக்கும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“முத்திரை செய்வதைப்போல், பொன் தகட்டில் பொன் எழுத்துக்களால் அதில் ‘கர்த்தருக்கு பரிசுத்தம்’ என்னும் வார்த்தைகளை பொறித்து வை. ");
INSERT INTO tam2008_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","அந்த பொன் தகட்டை ஒரு நீல வண்ண நாடாவில் இணைத்துவிடு. தலைப்பாகையின் முன் புறம் அந்தப் பொன் தகடு இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","ஆரோன் அதை தலையில் அணிந்துகொள்ள வேண்டும். இஸ்ரவேல் ஜனங்கள் படைக்கும் காணிக்கைகளில் உள்ள கறையினால் அவன் கறைபடாதபடி இது உதவும். ஜனங்கள் கர்த்தருக்குக் கொடுக்கும் காணிக்கைகள் இவைகளே. ஜனங்களின் காணிக்கைகளைக் கர்த்தர் ஏற்றுக்கொள்ளும் பொருட்டு ஆரோன் இதனை எப்போதும் தலையில் அணிந்துகொள்ள வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“வெள்ளை அங்கியை மெல்லிய துகில் நூலிலிருந்து நெய்ய வேண்டும். தலைப்பாகைக்கும் மெல்லிய துகிலைப் பயன்படுத்து. கச்சையில் சித்திர வேலைப்பாடுகள் தைக்கப்பட்டிருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","மேலங்கி, கச்சை, தலைப்பாகை ஆகியவற்றை ஆரோனின் மகன்களுக்காகவும் செய்ய வேண்டும். இது அவர்களுக்கு கனத்தையும் மதிப்பையும் அளிக்கும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","உன் சகோதரனாகிய ஆரோனுக்கும், அவன் மகன்களுக்கும் இந்த ஆடைகளை அணிவி. அவர்களை ஆசாரியர்களாக்கும்படி விசேஷ எண்ணெயை அவர்கள் மீது ஊற்று. இது அவர்களைப் பரிசுத்தமாக்கும். அவர்கள் எனக்கு சேவை செய்யும் ஆசாரியர்களாக இருப்பார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“மெல்லிய துகிலால் ஆசாரியர்களுக்கு உள்ளாடைகள் தைக்க வேண்டும். அவை இடுப்பிலிருந்து முழங்கால்வரைக்கும் இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","ஆசாரிப்புக் கூடாரத்திற்குள் நுழையும்போதெல்லாம் ஆரோனும், அவனது மகன்களும் இந்த ஆடைகளை அணிந்திருக்க வேண்டும். பரிசுத்த இடத்தில் பலிபீடத்தருகே ஆசாரியராக பணிவிடை செய்ய வரும்போது இதை அணியவேண்டும். அவற்றை அணியாவிட்டால் அவர்கள் குற்றவாளிகளாவார்கள். அதனால் அவர்கள் சாகநேரிடும். ஆரோனுக்கும் அவன் குடும்பத்தினருக்கும் என்றென்றைக்கும் இது கட்டளையாக இருக்கும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","பின்பு கர்த்தர் மோசேயை நோக்கி, “எனக்கு ஆசாரியர்களாக விசேஷ பணிவிடையை ஆரோனும் அவன் மகன்களும் செய்யும்பொருட்டு நீ செய்ய வேண்டிய காரியங்களை நான் உனக்குக் கூறுவேன். ஒரு இளங்காளையையும், குறைகள் இல்லாத இரண்டு இளம் வெள்ளாடுகளையும் தேர்ந்தெடுத்துக்கொள். ");
INSERT INTO tam2008_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","சுத்தமான கோதுமை மாவை புளிப்பில்லாத ரொட்டியாகச் செய்துகொள். அதே மாவைப் பயன்படுத்தி ஒலிவ எண்ணெயால் வார்ப்பு ரொட்டிகளையும் தயாரித்துக்கொள். சிறிய மெல்லிய அடைகளையும் எண்ணெய் பூசி உண்டாக்கு. ");
INSERT INTO tam2008_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","வார்ப்பு ரொட்டிகளையும், அடைகளையும் ஒரு கூடையில் வைத்து அவைகளையும், காளையையும், இரண்டு கடாக்களையும் ஆரோனுக்கும் அவன் மகன்களுக்கும் கொடு. ");
INSERT INTO tam2008_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“ஆசாரிப்புக் கூடாரத்தின் நுழை வாயிலுக்கு ஆரோனையும், அவனது மகன்களையும் அழைத்துவா. அவர்களை தண்ணீரில் கழுவின பின்பு ஆரோனுக்கு விசேஷ ஆடைகளை அணிவி. ");
INSERT INTO tam2008_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","முழுவதும் நெய்த வெள்ளை அங்கியையும், ஏபோத்தோடு அணிய வேண்டிய நீல அங்கியையும் உடுத்திவிடு. அதன் மேல் ஏபோத்தையும், நியாயத்தீர்ப்பு மார்ப்பதக்கத்தையும் அணியச்செய். அழகிய அரைக்கச்சையை கட்டிவிடு. ");
INSERT INTO tam2008_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","தலைப்பாகையை அவன் தலையில் வைத்து, அதன்மேல் பரிசுத்த கிரீடத்தை வை. ");
INSERT INTO tam2008_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","பின்பு அபிஷேக எண்ணெயை எடுத்து ஆரோனின் தலையின்மேல் ஊற்று. கர்த்தருக்குரிய ஆசாரியப் பணிவிடைக்கு ஆரோன் பிரித்தெடுக்கப்பட்டதை இது காட்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","“பின்பு ஆரோனின் மகன்களை அந்த இடத்திற்கு அழைத்து வா. முழுவதும் நெய்யப்பட்டவெள்ளை நிற அங்கிகளை அவர்களுக்கு அணிவி. ");
INSERT INTO tam2008_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","பின் அரைக்கச்சைகளைக் கட்டிவிடு. அவர்கள் அணிவதற்கான விசேஷ பாகைகளைக் கொடு. அப்போதிலிருந்து அவர்கள் ஆசாரியர்களாகப் பணி செய்ய ஆரம்பிப்பார்கள். என்றென்றைக்குமான விசேஷ சட்டப்படி அவர்கள் ஆசாரியர்களாக இருப்பார்கள். இவ்வாறு ஆரோனையும் அவன் மகன்களையும் நீ ஆசாரியர்களாக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“ஆசாரிப்புக் கூடாரத்திற்கு முன் காளையைக் கொண்டு வா. ஆரோனும், அவனது மகன்களும் தங்கள் கைகளைக் காளையின் தலையில் வைக்கட்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","ஆசாரிப்புக் கூடாரத்தின் நுழைவாயிலில் காளையைக் கொல். கர்த்தர் இதைப் பார்ப்பார். ");
INSERT INTO tam2008_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","காளையின் இரத்தத்தில் கொஞ்சம் எடுத்து பலிபீடத்திற்குச் செல். உனது விரல்களை இரத்தத்தில் தோய்த்து பலிபீடத்தின் கொம்புகளில் பூசு. மீதி இரத்தத்தைப் பலிபீடத்தின் அடியிலே ஊற்றிவிடு. ");
INSERT INTO tam2008_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","காளையின் உட்புறத்திலுள்ள எல்லா கொழுப்பையும், ஈரலின் மேலுள்ள சவ்வையும், சிறுநீரகங்களையும், அவைகளை சுற்றிய கொழுப்பையும் எடுத்து, பலிபீடத்தில் எரித்துவிடு. ");
INSERT INTO tam2008_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","பின் காளையின் மாமிசம், அதன் தோல், பிற பகுதிகளை எடுத்துவிட்டு பாளையத்துக்கு வெளியே கொண்டுபோய் அவற்றைச் சுட்டெரித்துவிடு. இதுவே ஆசாரியர்களின் பாவத்தைப் போக்குவதற்கான காணிக்கை ஆகும். ");
INSERT INTO tam2008_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“பின் ஆரோனும், அவனது மகன்களும் ஆட்டுக் கடாவின் தலையில் தம் கைகளை வைக்கும்படி சொல். ");
INSERT INTO tam2008_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","கடாவைக் கொன்று இரத்தத்தைச் சேகரித்துப் பலிபீடத்தைச் சுற்றிலும் நான்கு பக்கங்களிலும் அதைத் தெளித்துவிடு. ");
INSERT INTO tam2008_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","செம்மறி ஆட்டுக் கடாவைப் பல துண்டுகளாக்கு. அதன் எல்லா உட்பாகங்களையும், கால்களையும் கழுவு. அவற்றை செம்மறி ஆட்டுக் கடாவின் தலையோடும், அதன் மற்ற துண்டுகளோடும் வை. ");
INSERT INTO tam2008_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","எல்லாவற்றையும் பலிபீடத்தில் எரித்துவிடு. இது கர்த்தருக்குத் தரப்படும் தகனபலியாகும். கர்த்தருக்கு சுகந்த வாசனையாக இது இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“ஆரோனும், அவனது மகன்களும் மற்றொரு ஆட்டுக் கடாவின்மேல் தம் கைகளை வைக்கட்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","அக்கடாவைக் கொன்று கொஞ்சம் இரத்தத்தை சேகரித்துக்கொள். அந்த இரத்தத்தை ஆரோனின் வலது காது மடலிலும், அவன் மகன்களின் வலது காது மடலிலும், அவர்களின் வலது கைப் பெரு விரல்களிலும், அவர்களின் வலது கால் பெருவிரல்களிலும் தடவு. பின்பு பலிபீடத்தின் 4 பக்கங்களின் எதிரிலும் மீதி இரத்தத்தை தெளி. ");
INSERT INTO tam2008_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","பிறகு சிறிது இரத்தத்தைப் பலி பீடத்திலிருந்து எடுத்து அதை விசேஷ எண்ணெயுடன் கலந்து ஆரோன் மீதும் அவன் ஆடைகள் மீதும் தெளி. பின்பு அவனது மகன்கள் மற்றும் அவர்களின் ஆடைகள் மீதும் தெளி. ஆரோனும் அவனது மகன்களும் எனக்கு விசேஷ பணிவிடை செய்பவர்கள் என்பதையும், இந்த ஆடைகள் விசேஷ காலங்களில் மாத்திரம் பயன்படுத்தப்பட வேண்டியவை என்பதையும் இது காட்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“பின்பு ஆட்டுக் கடாவிலிருந்து கொழுப்பை அகற்று. (ஆரோனை தலைமை ஆசாரியனாக நியமிக்கும் விழாவில் பயன்படுத்தப்படும் கடா இது.) வாலையும், உட்பாகங்களையும் சூழ்ந்திருக்கும் கொழுப்பையும், ஈரலின் மேலுள்ள சவ்வையும், சிறுநீரகங்களையும் அவைகளைச் சுற்றி இருக்கும் கொழுப்பையும் வலது காலையும் எடுத்துக்கொள். ");
INSERT INTO tam2008_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","பின் புளிப்பு இல்லாத ரொட்டி இருக்கும் கூடையை எடுத்துக்கொள். கர்த்தரின் முன் வைக்க வேண்டிய கூடை இது. ஒரு வார்ப்பு ரொட்டி, எண்ணெயால் செய்யப்பட்ட அடை, ஒரு சிறிய மெல்லிய அடை ஆகியவற்றைக் கூடையில் இருந்து எடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","இவற்றை ஆரோனுக்கும், அவன் மகன்களுக்கும் கையில் கொடு. இவற்றை அவர்கள் ஏந்தி நிற்கும்படி செய். கர்த்தருக்கு உகந்த அசைவாட்டும் காணிக்கையாக அவர்கள் அதை அசைவாட்ட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","பின்பு அவற்றை அவர்களிடமிருந்து வாங்கிக் ஆட்டுக் கடாவோடு பலி பீடத்தில் சுட்டெரி. இது நெருப்பின் மூலமாக தேவனுக்குத் தரப்படும் தகன பலியாகும். அதன் சுகந்த வாசனை கர்த்தருக்கு ஏற்றது. ");
INSERT INTO tam2008_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“ஆட்டுக்கடாவின் (இந்தக் கடா ஆரோனை தலைமை ஆசாரியனாக்கும் விழாவில் பயன்படுத்தப்படும்) மார்புப் பகுதியை விசேஷ காணிக்கையாக கர்த்தரின் முன்னிலையில் ஏந்தி நிற்க வேண்டும். பின் அதை எடுத்து வை. மிருகத்தின் இந்தப் பகுதி உனக்குரியது. ");
INSERT INTO tam2008_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","ஆரோனைத் தலைமை ஆசாரியனாக்குவதற்குப் பயன்படுத்திய கடாவின் மார்புப் பகுதி, கால் ஆகியவற்றை எடுத்து அவற்றை பரிசுத்தப்படுத்து. அந்த விசேஷ பாகங்களை ஆரோனுக்கும், அவன் மகன்களுக்கும் கொடு. ");
INSERT INTO tam2008_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","இஸ்ரவேல் ஜனங்கள் எப்போதும் இப்பாகங்களை ஆசாரியர்களுக்கு கொடுத்துவிட வேண்டும். இஸ்ரவேல் ஜனங்கள் கர்த்தருக்கு காணிக்கை செலுத்தும் போதெல்லாம் இப்பாகங்கள் ஆசாரியர்களுக்கு உரியவை. இவற்றை அவர்கள் ஆசாரியர்களுக்குக் கொடுக்கும்போது அது கர்த்தருக்கு கொடுப்பதற்குச் சமமாகும். ");
INSERT INTO tam2008_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“ஆரோனுக்காகச் செய்த அந்த விசேஷ ஆடைகளைப் பாதுகாப்பாக வைத்திரு. அவனுக்குப்பின் வரும் மகன்களுக்கும் அந்த ஆடைகள் உரியனவாகும். தலைமை ஆசாரியர்களாகத் தெரிந்தெடுக்கப்பட்டவர்கள் அவற்றை அணிவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","ஆரோனின் மகன் அவனுக்குப்பின் தலைமை ஆசாரியனாவான். பரிசுத்த இடத்தில் பணியாற்றுவதற்காக ஆசாரிப்புக் கூடாரத்தில் பிரவேசிக்கும்போது 7 நாளளவும் அவன் அதை உடுத்த வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“ஆரோனை தலைமை ஆசாரியனாக்க பயன்படுத்திய ஆட்டுக்கடாவின் மாம்சத்தை பரிசுத்தமான இடத்தில் சமைக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","முன் வாசலில் ஆரோனும் அவன் மகன்களும் அதை உண்ண வேண்டும். ஆசாரிப்புக் கூடாரத்தின் கூடையிலுள்ள ரொட்டியையும் அவர்கள் சாப்பிட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","அவர்கள் ஆசாரியர்களானபோது, அவர்கள் பாவங்களை அகற்ற இந்தக் காணிக்கை பயன்படுத்தப்பட்டது. இப்போது அவர்கள் அவற்றை உண்ண வேண்டும். அவைகள் பரிசுத்தமானதால் அந்நியன் அவைகளை உண்ணக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","மறு நாள் காலையில் கடாவின் மாமிசமோ, ரொட்டியோ மீதியிருந்தால் அது முற்றிலும் சுட்டெரிக்கப்பட வேண்டும். அதை விசேஷ காலத்தில் விசேஷ வகையில் சாப்பிட வேண்டுமாதலால் அந்த ரொட்டியையோ, மாமிசத்தையோ நீ சாப்பிடக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“ஆரோனுக்காகவும், அவன் மகன்களுக்காகவும் நீ அவற்றைச் செய்ய வேண்டும். நான் சொன்னபடியே அவற்றைச் செய்ய வேண்டும். ஆசாரியர்களாக அவர்களை நியமிக்கும் விழா 7 நாட்கள் தொடர வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","ஏழு நாட்களிலும் தினந்தோறும் ஒவ்வொரு காளையைக் கொல்ல வேண்டும். ஆரோன், அவன் மகன்களின் பாவங்களுக்காக செலுத்தப்பட்ட பலியாக இது அமையும். பலிபீடத்தைப் பரிசுத்தப் படுத்துவதற்கு இப்பலிகளை நீ பயன்படுத்த வேண்டும். அதைப் பரிசுத்தமாக்க ஒலிவ எண்ணெயை ஊற்ற வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","அந்த 7 நாட்களில் பலிபீடத்தை சுத்தமாகவும், பரிசுத்தமாகவும் வைத்துக்கொள்ள வேண்டும். அப்போது பலிபீடம் மகா பரிசுத்தமாகும். பலி பீடத்தைத் தொடும் எப்பொருளும் பரிசுத்தம் ஆகும். ");
INSERT INTO tam2008_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“ஒவ்வொரு நாளும் பலிபீடத்தில் ஒரு காணிக்கை செலுத்த வேண்டும். ஒரு வயது நிரம்பிய இரண்டு ஆட்டுக்குட்டிகளைக் கொல்ல வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ஒரு ஆட்டுக்குட்டியைக் காலையிலும் மற்றொன்றை மாலையிலும் காணிக்கையாய் செலுத்த வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","41","முதல் ஆட்டுக்குட்டியைக் கொல்லும்போது, சுத்தமான அரைத்த 8 கிண்ணம் கோதுமை மாவைக் காணிக்கையாகக் கொடுக்க வேண்டும். அந்த மாவைக் கால்படி திராட்சைரசத்தோடு சேர்த்து காணிக்கையாக அளிக்க வேண்டும். மாலையில் இரண்டாவது ஆட்டுக்குட்டியைக் கொல்லும்போதும் 8 கிண்ணம் மாவையும் கால்படி திராட்சை ரசத்தையும் காலையில் செய்தது போலவே காணிக்கையாகக் கொடுக்க வேண்டும். அது கர்த்தருக்கு அளிக்கும் சுகந்த வாசனையான தகன காணிக்கையாகும். இதனை எரிக்கும்போது, கர்த்தர் வாசனையை முகருவார், அது அவரை மகிழ்விக்கும். ");
INSERT INTO tam2008_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“ஒவ்வொரு நாளும் இவற்றைச் சர்வாங்க தகனக் காணிக்கையாக எரிக்க வேண்டும். கர்த்தருக்கு முன்பாக ஆசாரிப்புக் கூடாரத்தின் நுழைவாயிலில் இதைச் செய். தொடர்ந்து உனது தலைமுறைகளுக்கும் இவ்வாறே செய். நீ காணிக்கை செலுத்தும்போது கர்த்தராகிய நான் உங்களைச் சந்தித்துப் பேசுவேன். ");
INSERT INTO tam2008_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","அங்கு இஸ்ரவேல் ஜனங்களைச் சந்திப்பேன். எனது மகிமை அவ்விடத்தைப் பரிசுத்தப்படுத்தும். ");
INSERT INTO tam2008_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“ஆசாரிப்புக் கூடாரத்தையும் பலி பீடத்தையும் நான் பரிசுத்தப்படுத்துவேன். ஆரோனையும், அவனது மகன்களையும் எனக்கு ஆசாரியராகப் பணியாற்றுவதற்காகப் பரிசுத்தமாக்குவேன். ");
INSERT INTO tam2008_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","நான் இஸ்ரவேல் ஜனங்களோடு வாழ்வேன், நான் அவர்கள் தேவனாக இருப்பேன். ");
INSERT INTO tam2008_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","நானே தேவனாகிய கர்த்தர் என்பதை ஜனங்கள் அறிவார்கள். அவர்களோடு வாழும்படியாக அவர்களை எகிப்திலிருந்து வழிநடத்திய தேவன் நான் என்பதை அவர்கள் அறிவார்கள். நானே அவர்கள் தேவனாகிய கர்த்தர்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","மேலும் தேவன் மோசேயை நோக்கி, “சீத்திம் மரத்தால் ஒரு பலிபீடத்தை தயார் செய்து, நறுமணப்புகை எரிக்கும்படியான தூபபீடமாக அதைப் பயன்படுத்து. ");
INSERT INTO tam2008_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","பலிபீடம் 1 முழம் நீளமும் 1 முழம் அகலமும் உடைய சதுர வடிவில் இருக்க வேண்டும். அது 2 முழம் உயரம் இருக்கட்டும். நான்கு மூலைகளிலும் கொம்புகள் இருக்கும். இந்த கொம்புகள் ஒரே துண்டாக தூபபீடத்தோடு இணைக்கப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","பீடத்தின் மேல் புறத்தையும் பக்கங்களையும் கொம்புகளையும் பொன்னால் மூட வேண்டும். பீடத்தைச் சுற்றிலும் பொன் சட்டத்தைப் பதிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","அதன் கீழ் இரண்டு பொன் வளையங்கள் இருக்கட்டும். பீடத்தின் எதிர்ப்பக்கங்களில் இரண்டு பொன் வளையங்கள் இருக்க வேண்டும். பீடத்தைத் தண்டுகளால் சுமப்பதற்கு இவ்வளையங்கள் பயன்படுத்தப்படும். ");
INSERT INTO tam2008_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","தண்டுகளை சீத்திம் மரத்தால் செய்து பொன்னால் மூடு. ");
INSERT INTO tam2008_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","விசேஷ திரைக்கு முன்னால் தூபபீடத்தை நிறுத்து. அத்திரைக்குப் பின் உடன்படிக்கைப் பெட்டி இருக்கும். உடன்படிக்கைக்குமேல் இருக்கும் கிருபாசனத்துக்கு முன்னால் பீடம் அமையும். இவ்விடத்தில்தான் நான் உன்னைச் சந்திப்பேன். ");
INSERT INTO tam2008_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“ஆரோன் தினந்தோறும் அதிகாலையில் தூபபீடத்தின்மேல் இனிய நறுமணப் புகையை எரிக்க வேண்டும். விளக்குகளை பராமரிக்க வரும்போது அவன் இதைச் செய்வான். ");
INSERT INTO tam2008_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","மீண்டும் மாலையிலும் அவன் நறுமணப்புகையை எரிப்பான். அதுவும் மாலையில் விளக்கைப் பராமரிப்பதற்கு அவன் வரும் நேரமேயாகும். ஒவ்வொரு நாளும் என்றென்றும் கர்த்தரின் முன் நறுமணப் புகை எரிக்கப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","வேறு எந்த நறுமணப் பொருட்களை எரிப்பதற்கோ, வேறு தகனபலிகளை எரிப்பதற்கோ இந்தத் தூபபீடத்தைப் பயன்படுத்தக் கூடாது. தானிய காணிக்கையையோ, பானங்களின் காணிக்கையையோ எரிப்பதற்கு இப்பீடத்தைப் பயன்படுத்தலாகாது. ");
INSERT INTO tam2008_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","“ஆண்டிற்கொருமுறை கர்த்தருக்கு ஒரு விசேஷ பலியை ஆரோன் செலுத்த வேண்டும். ஜனங்களின் பாவத்தைப் போக்குவதற்கு பாவப்பரிகார பலியின் இரத்தத்தை ஆரோன் பயன்படுத்த வேண்டும். பீடத்தின் கொம்புகளினருகே ஆரோன் இதனைச் செய்வான். இது பாவப்பரிகார நாள் எனப்படும். இது கர்த்தருக்கு மிகவும் பரிசுத்த நாள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","கர்த்தர் மோசேயை நோக்கி, ");
INSERT INTO tam2008_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“இஸ்ரவேல் ஜனங்களின் எண்ணிக்கையைத் தெரிந்துகொள். நீ இதைச் செய்தபிறகு ஒவ்வொருவனும் கர்த்தருக்கென ஒரு தொகை கொடுக்க வேண்டும். ஒவ்வொருவனும் இதைச் செய்தால் அவர்களுக்குத் தீங்கு நேராது. ");
INSERT INTO tam2008_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","எண்ணப்பட்ட ஒவ்வொருவனும் 1/2 சேக்கல் வீதம் கொடுக்க வேண்டும். (அதாவது அதிகாரப்பூர்வமான அளவுப்படி 1/2 சேக்கல்.) 1 சேக்கலுக்கு 20 கேரா 1/2 சேக்கல் கர்த்தருக்குரிய காணிக்கை. ");
INSERT INTO tam2008_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","குறைந்தபட்சம் இருபது வயது நிம்பியவர்கள் எல்லோரையும் கணக்கெடுக்க வேண்டும். கணக்கெடுத்து கொள்ளப்பட்ட ஒவ்வொருவரும் கர்த்தருக்கு இந்தக் காணிக்கையைக் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","செல்வந்தர்கள் 1/2 சேக்கலுக்கு அதிகமாக கொடுக்கக் கூடாது. ஏழைகளும் 1/2 சேக்கலுக்குக் குறைவாகக் கொடுக்கக்கூடாது. எல்லோரும் கர்த்தருக்கு ஒரே அளவு காணிக்கை தரவேண்டும். இது உங்கள் வாழ்க்கையின் இரட்சிப் பிற்கான பணம். ");
INSERT INTO tam2008_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","இப்பணத்தை இஸ்ரவேல் ஜனங்களிடமிருந்து திரட்டு. அதை ஆசாரிப்புக் கூடாரத்தின் பணிவிடைக்காகப் பயன்படுத்து. கர்த்தர் தமது ஜனங்களை நினைவுகூருவதற்காக இது அமையும். அவர்களின் சொந்த வாழ்க்கையின் பாதுகாப்புக்காக ஜனங்கள் கொடுக்கும் பணம் இது” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","கர்த்தர் மோசேயை நோக்கி, ");
INSERT INTO tam2008_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“வெண்கலத்தால் ஒரு பெரிய தொட்டியைச் செய்து அதை வெண்கலப் பீடத்தில் வை. இதைக் கைகளையும், கால்களையும் கழுவுவதற்குப் பயன்படுத்து. அதை ஆசாரிப்புக் கூடாரத்திற்கும், பலிபீடத்திற்கும் நடுவில் வை. வெண்கலத் தொட்டியைத் தண்ணீரால் நிரப்பு. ");
INSERT INTO tam2008_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","ஆரோனும், அவனது மகன்களும் அவர்கள் கைகளையும் கால்களையும் இந்த தொட்டித் தண்ணீரில் கழுவ வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","ஆசாரிப்புக் கூடாரத்திற்குள் நுழையும்போதும் கர்த்தருக்குக் காணிக்கையைப் படைக்க பலிபீடத்தை நெருங்கும்போதும் ஒவ்வொரு முறையும் அவர்கள் தண்ணீரால் கழுவிக்கொள்ள வேண்டும். அதனால் அவர்கள் மரிக்கமாட்டார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","அவர்கள் மரிக்காமலிருக்கும் படிக்குத் தங்கள் கைகளையும் கால்களையும் கழுவி சுத்தமாக இருக்க வேண்டும். இது ஆரோனும், அவனது ஜனங்களும் என்றென்றும் பின்பற்ற வேண்டிய சட்டமாகும். எதிர் காலத்தில் வாழவிருக்கும் ஆரோனின் ஜனங்களுக்கும் இது நித்திய கட்டளையாயிருக்கும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","பின்பு கர்த்தர் மோசேயை நோக்கி, ");
INSERT INTO tam2008_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“தரத்தில் உயர்ந்த நறுமணப் பொருட்களை அரசாங்க அளவின்படி வாங்கு. வெள்ளைப் போள தைலம் 12 பவுண்டும், நறுமணப் பட்டை 6 பவுண்டும், வசம்பு 6 பவுண்டும் ");
INSERT INTO tam2008_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","இலவங்கம் 12 பவுண்டும் வாங்கிக்கொள். அதிகாரப்பூர்வமான அளவின்படி பார்த்து வாங்குவதோடு ஒரு கேலன் தரமான ஒலிவ எண்ணெயையும் வாங்கிக்கொள். ");
INSERT INTO tam2008_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","“எல்லாவற்றையும் கூட்டிக் கலந்து சுகந்த அபிஷேக எண்ணெயைத் தயாரித்துக்கொள். ");
INSERT INTO tam2008_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","ஆசாரிப்புக் கூடாரத்தின் மேலும் உடன்படிக் கைப் பெட்டியின் மேலும் இந்த எண்ணெயைத் தெளி. அவை விசேஷமானவை என்பதை இது உணர்த்தும். ");
INSERT INTO tam2008_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","எண்ணெயை மேசைமீதும் அதன் மீதுள்ள எல்லாப் பாத்திரங்களின்மீதும் ஊற்று. குத்துவிளக்குத் தண்டின்மீதும், அதன் உபகரணங்களின்மீதும், தூபபீடத்தின்மீதும் ஊற்று. ");
INSERT INTO tam2008_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","“தேவனுக்கு பலிகளை எரிப்பதற்கான பலி பீடத்திலும் எண்ணெயை ஊற்று. இதன் பாத்திரத்திலும் அதன் அடித்தளத்திலும் ஊற்று. ");
INSERT INTO tam2008_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","இவற்றையெல்லாம் நீ பரிசுத்தமாக்குவாய். அவை கர்த்தருக்கு மிகவும் விசேஷமானவை. அவற்றைத் தொடும் எவையும் பரிசுத்தமாகும். ");
INSERT INTO tam2008_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“ஆரோன்மீதும், அவனது மகன்கள் மீதும் அபிஷேக எண்ணெயை ஊற்று. அவர்கள் எனக்கு விசேஷ பணிவிடை செய்வதை அது காட்டும். அப்பொழுது அவர்கள் ஆசாரியர்களாக எனக்கு சேவை செய்யலாம். ");
INSERT INTO tam2008_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","அபிஷேக எண்ணெய் பரிசுத்தமானது என்பதை இஸ்ரவேல் ஜனங்களுக்குச் சொல். அது எனக்காக மட்டுமே பயன்படுத்தப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","சாதாரண நறுமணப் பொருளாக அதைப் பயன்படுத்தக் கூடாது. இந்த விசேஷ எண்ணெயைத் தயாரிக்கும் முறையில் சாதாரண நறுமண தைலத்தை தயாரிக்கக் கூடாது. இந்த அபிஷேக எண்ணெய் பரிசுத்தமானது. இது உங்களுக்கு மிகவும் விசேஷமானதாகும். ");
INSERT INTO tam2008_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","இந்தப் பரிசுத்த எண்ணெயைப் போல யாரேனும் நறுமண தைலத்தை உண்டாக்கி அதை அந்நியருக்குக் கொடுத்தால் அவன் இஸ்ரவேல் ஜனங்களிடமிருந்து ஒதுக்கப்பட வேண்டும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","பின்பு கர்த்தர் மோசேயை நோக்கி, “இந்த நறுமணப் பொருட்களை வாங்கிக்கொள். அவை வெள்ளைப் போளம், குங்கிலியம், அல்பான் பிசின், கந்தவர்க்கம், சாம்பிராணி ஆகியன எல்லாவற்றையும் ஒரே அளவில் எடுத்துக்கொள். ");
INSERT INTO tam2008_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","இவற்றைச் சேர்த்து நறுமணமுள்ள தூபவர்க்கம் செய். அபிஷேக எண்ணெய் தயாரிப்பதுபோல, இதைத் தயாரிக்க வேண்டும். உப்பையும் அதனோடு சேர்க்கும்போது அது சுத்தமானதாகவும், விசேஷமானதாகவும் இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","அதில் கொஞ்சம் தூபவர்க்கத்தைத் தூளாக்கு. ஆசாரிப்புக் கூடாரத்தில் உடன்படிக்கைக்கு முன்னால் நறுமணப் பொடியை வை. அந்த இடத்தில் நான் உன்னைச் சந்திப்பேன். விசேஷ காரியத்துக்காக மட்டுமே அந்த நறுமணப் பொடியை நீ பயன்படுத்த வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","இப்படியாக இந்த நறுமணப்பொருளை கர்த்தருக்கென்று சிறந்த முறையில் தயாரிக்கவேண்டும். அதேவிதமாக வேறு நறுமணப் பொருளைத் தயாரிக்கக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","ஒருவன் நறுமணத்திற்கென்று தனது உபயோகத்திற்காக நறுமணப் பொருளை இதே முறையில் தயாரிக்க விரும்பலாம். ஆனால் அவன் அவ்வாறு செய்தால், எனது ஜனங்களிலிருந்து ஒதுக்கி வைக்கப்படுவான்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","கர்த்தர் மோசேயை நோக்கி, ");
INSERT INTO tam2008_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“யூதாவின் கோத்திரத்திலிருந்து ஒரு மனிதனை எனது விசேஷ பணிக்காகத் தெரிந்தெடுத்துள்ளேன். அவன் ஊருடைய மகனான ஊரியின் மகன் பெசலெயேல். ");
INSERT INTO tam2008_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","தேவ ஆவியால் நான் பெசலெயேலை நிரப்பியுள்ளேன். எல்லாவிதமான கைவேலைகளையும் செய்யக்கூடிய திறமையையும், அறிவையும் அவனுக்குக் கொடுத்திருக்கிறேன். ");
INSERT INTO tam2008_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","பெசலெயேல் கலைப் பொருட்களை வடிப்பதில் வல்லவன். பொன், வெள்ளி, வெண்கலம் ஆகியவற்றால் பொருட்களைச் செய்ய அவனுக்கு இயலும். ");
INSERT INTO tam2008_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","பெசலெயேலால் அழகான அணிகலன்களை வெட்டி உருவாக்க முடியும். மரவேலைகளிலும் அவன் கை தேர்ந்தவன். அவன் எல்லாவிதமான வேலைகளையும் செய்யும் ஆற்றல்மிக்கவன். ");
INSERT INTO tam2008_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","அவனுக்கு உதவி செய்வதற்குத் தாண் கோத்திரத்திலிருந்து அகிசாமாக்கின் மகன் அகோலியாபை தெரிந்தெடுத்துள்ளேன். நான் உனக்குக் கூறிய எல்லாப் பொருட்களையும் செய்யும் திறமையை எல்லாப் பணியாட்களுக்கும் கொடுத்துள்ளேன். நான் உனக்குக் கட்டளையிட்ட யாவையும் அவர்கள் செய்வார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","ஆசாரிப்புக் கூடாரம், உடன்படிக்கைப் பெட்டி, கிருபாசனம், கூடாரத்தின் பணி முட்டுகளும், ");
INSERT INTO tam2008_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","மேசையும் அதற்குத் தேவையான பொருட்களும், சுத்தமான குத்துவிளக்கையும் அதின் கருவிகளும், நறுமணப் பொருளை எரிக்கும் பீடம், ");
INSERT INTO tam2008_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","காணிக்கைகளை எரிக்கும் பலிபீடம், பலிபீடத்தில் பயன்படுத்தப்படும் பொருட்கள், தொட்டியும் அதன் பீடமும், ");
INSERT INTO tam2008_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ஆசாரியனாகிய ஆரோனின் விசேஷ ஆடைகள், ஆரோனின் மகன்கள் ஆசாரியராக சேவை செய்ய அவர்களுக்கான உடைகள், ");
INSERT INTO tam2008_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","நறுமணம் மிக்க அபிஷேக எண்ணெய், மகா பரிசுத்த இடத்தின் நறுமணப்பொருள் அனைத்தையும் நான் உனக்குக் கூறிய விதத்திலேயே பணியாளர்கள் செய்ய வேண்டும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","பின்பு கர்த்தர் மோசேயை நோக்கி, ");
INSERT INTO tam2008_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“இஸ்ரவேல் ஜனங்களுக்கு இதைக் கூறு: ‘ஓய்வுக்குரிய விசேஷ தினங்களின் விதிகளை நீங்கள் பின்பற்ற வேண்டும். எல்லாத் தலைமுறைகளிலும் அது உங்களுக்கும் எனக்கும் மத்தியிலுள்ள அடையாளமாக விளங்கும். உங்களை எனது விசேஷமான ஜனங்களாக கர்த்தராகிய நான் ஏற்றுக்கொண்டதை இது உணர்த்தும். ");
INSERT INTO tam2008_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“‘ஒய்வு நாளை ஒரு விசேஷ நாளாக எண்ணுவாயாக. பிறநாட்களுக்கு சமமாக ஓய்வு நாளையும் ஒருவன் எண்ணினால் அம்மனிதன் கொல்லப்பட வேண்டும். ஓய்வு நாளில் வேலை செய்கிறவனை அவனது ஜனங்களிடமிருந்து ஒதுக்கிவிட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","வேலை நாட்களாக வாரத்தில் ஆறு நாட்கள் உள்ளன. ஏழாவது நாள் ஓய்வுக்குரிய விசேஷ நாளாகும். கர்த்தரை மகிமைப்படுத்தும் விசேஷ நாள் அது. ஓய்வு நாளில் வேலை செய்கிற எவனும் கொல்லப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","இஸ்ரவேல் ஜனங்கள் ஓய்வு நாளை நினைவுகூர்ந்து அதை விசேஷ நாளாக்க வேண்டும். என்றென்றும் தொடர்ந்து இதைச் செய்துவர வேண்டும். என்றென்றும் எனக்கும் அவர்களுக்கும் மத்தியில் தொடர்கிற உடன்படிக்கையாக அது விளங்கும். ");
INSERT INTO tam2008_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","ஓய்வு நாள் எனக்கும் இஸ்ரவேலருக்கும் மத்தியில் ஒரு அடையாளமாக எப்போதும் இருக்கும். கர்த்தர் ஆறு நாட்கள் உழைத்து வானையும் பூமியையும் உண்டாக்கினார். அவர் ஏழாம் நாளில் ஓய்வாகவும் அமைதியாகவும் இருந்தார்’” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","சீனாய் மலையில் கர்த்தர் மோசேயிடம் பேசி முடித்தார். உடன்படிக்கை பதித்த இரண்டு கற்பலகைகளை கர்த்தர் அவனுக்குக் கொடுத்தார். தேவன் தமது விரல்களால் அக்கற்பலகைகளில் எழுதினார். ");
INSERT INTO tam2008_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","மோசே மலையிலிருந்து இறங்கிவர மிகுந்த தாமதமானதை ஜனங்கள் உணர்ந்தனர். அவர்கள் ஆரோனைச் சூழ்ந்து, அவனை நோக்கி, “பாரும், மோசே எங்களை எகிப்து தேசத்திலிருந்து வெளியே வழி நடத்தி வந்தான். இப்போது அவனுக்கு என்ன நேர்ந்தது என்று தெரியவில்லை. ஆகவே எங்களுக்கு முன்பாகச் சென்று வழி நடத்துவதற்குச் சில தேவர்களை உருவாக்கும்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","ஆரோன் ஜனங்களிடம், “உங்கள் மனைவி, பிள்ளைகளுக்குச் சொந்தமான பொன் காதணிகளை என்னிடம் கொண்டு வாருங்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","எல்லா ஜனங்களும் தங்கள் பொன் காதணிகளைச் சேர்த்து ஆரோனிடம் கொடுத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","ஆரோன் ஜனங்களிடமிருந்து அவற்றை வாங்கி, அதைப் பயன்படுத்தி ஒரு கன்றுக் குட்டியின் உருவத்தை வார்த்தான். பின்பு ஒரு உளியைப் பயன்படுத்தி, அந்த சிலையைச் செதுக்கினான். பின் அதை பொன் தகட்டால் மூடினான். அப்போது ஜனங்கள், “இஸ்ரவேலரே, இந்த தெய்வங்களே உங்களை எகிப்திலிருந்து அழைத்து வந்தன!” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","ஆரோன் இவற்றையெல்லாம் பார்த்தான். கன்றுக்குட்டியின் எதிரில் ஒரு பலிபீடம் அமைத்தான். பின்பு ஜனங்களை நோக்கி, “கர்த்தரைக் கனப்படுத்துவதற்கு நாளை ஒரு பண்டிகை நடத்துவோம்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","மறுநாள் காலையில் ஜனங்கள் வெகு சீக்கிரமாக எழுந்தனர். அவர்கள் மிருகங்களைக் கொன்று தகன பலிகளையும், சமாதானபலிகளையும் படைத்தனர். ஜனங்கள் தின்று, குடித்துக்களிக்க உட்கார்ந்தனர். பின்பு எழுந்து மிகுதியான அநாகரீகத்தில் ஈடுபட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","அப்போது கர்த்தர் மோசேயிடம், “இந்த மலையைவிட்டு சீக்கிரமாய் கீழே இறங்கிப் போ. எகிப்திலிருந்து நீ வெளியே அழைத்து வந்த, உனது ஜனங்கள் மிகவும் சீர்கேடான பாவத்தைச் செய்திருக்கிறார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","செய்யும்படி நான் அவர்களுக்கு கட்டளையிட்ட வைகளினின்று மிக வேகமாய் சோரம் போனார்கள். பொன்னை உருக்கி கன்றுக் குட்டியை வார்த்தார்கள். அவர்கள் அதைத் தொழுது அதற்குப் பலி செலுத்துகிறார்கள். அதனிடம், ‘எங்களை எகிப்திலிருந்து வழிநடத்தின தெய்வங்கள் இவையே’ என்றனர்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","மேலும் கர்த்தர் மோசேயை நோக்கி, “நான் இந்த ஜனங்களைப் பார்த்திருக்கிறேன். அவர்கள் பிடிவாத குணமுடையோர் என்பதையும் அறிவேன். அவர்கள் எப்போதும் எனக்கெதிராகத் திரும்புவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","எனவே என் கோபத்தால் அவர்களை அழிப்பேன். பின் உன் மூலமாக ஒரு பெரிய ஜனத்தை உரு வாக்குவேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","ஆனால் மோசே தேவனாகிய கர்த்தரை மிகவும் கெஞ்சி, “கர்த்தாவே, உமது கோபத்தால் உமது ஜனங்களை அழித்து விடாதேயும். உமது மிகுந்த ஆற்றலினாலும் வல்லமையாலும் நீர் இந்த ஜனங்களை எகிப்திலிருந்து கொண்டு வந்தீர். ");
INSERT INTO tam2008_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","ஆனால் நீர் உமது ஜனங்களை அழித்துவிட்டால் எகிப்தியர்கள், ‘கர்த்தர் அந்த ஜனங்களுக்குத் தீமை செய்யத் திட்டமிட்டார். எனவே அவர்களை எகிப்திலிருந்து அழைத்துச் சென்றார். அவர்களை மலைகளில் கொல்ல விரும்பினார். அவர்களைப் பூமியிலிருந்து நிர்மூலமாக்க எண்ணினார், என்று சொல்வார்கள்.’ எனவே, உமது ஜனங்களிடம் கோபம் கொள்ளாதிரும். உமது எண்ணத்தை மாற்றிக்கொள்ளும்! உமது ஜனங்களை அழித்துவிடாதிரும். ");
INSERT INTO tam2008_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","ஆபிரகாம், ஈசாக்கு, இஸ்ரவேல் (யாக்கோபு) ஆகியோரை நினைவுகூரும். அவர்கள் உமக்குப் பணிவிடை செய்தனர். உமது பெயரால் அவர்களுக்கு வாக்குறுதி கொடுத்தீர். ‘நான் உன் ஜனங்களை வானத்தின் நட்சத்திரங்களைப் போல பெருகச் செய்வேன். நான் உன் ஜனங்களுக்கு வாக்குறுதி அளித்த தேசத்தைக் கொடுப்பேன். அத்தேசம் என்றும் அவர்களுக்குரியதாகும்’ என்று நீர் வாக்குறுதி தந்தீர்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","எனவே, கர்த்தர் ஜனங்களுக்காக மனஸ்தாபப்பட்டார். தான் செய்வதாகக் கூறிய செயலைக் கர்த்தர் செய்யவில்லை, அவர் ஜனங்களை அழிக்கவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","பின்பு மோசே மலையிலிருந்து இறங்கினான். உடன்படிக்கை எழுதப்பட்ட இரண்டு கற்பலகைகளை அவன் கையில் ஏந்திவந்தான். கற்பலகைகளின் முன்புறம், பின்புறமும் அந்தக் கட்டளைகள் எழுதப்பட்டிருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","தேவனே அக்கற்களை உண்டாக்கி, அக்கற்களின் மீது கட்டளைகளை எழுதியிருந்தார். ");
INSERT INTO tam2008_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","மலையிலிருந்து இறங்கியபோது பாளையத்திலிருந்து பெரும் சத்தத்தை யோசுவா கேட்டான். யோசுவா மோசேயை நோக்கி: “நம் பாளையத்தில் யுத்த சத்தம் எழும்புகிறது” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","மோசே பதிலாக, “இது வெற்றியால் ஒரு படை எழுப்பும் சத்தமல்ல. தோல்வியால் ஒரு படை எழுப்பும் கூக்குரலும் அல்ல. நான் கேட்டது இசையின் சத்தமே” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","மோசே பாளையத்திற்கு அருகே வந்தான். அவன் பொன் கன்றுக்குட்டியையும் ஜனங்கள் நடன மாடுவதையும் கண்டு, மிகுந்த கோபங்கொண்டான். அவன் கற்பல கைகளை தரையில் வீசி எறிந்தான். மலை அடிவாரத்தில் அவை சுக்கு நூறாக உடைந்து சிதறின. ");
INSERT INTO tam2008_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","பின்பு மோசே ஜனங்கள் செய்த கன்றுக் குட்டியை உடைத்து, அதை நெருப்பில் போட்டு உருக்கினான். பொன்னைத் தூளாகுமட்டும் அரைத்து அதைத் தண்ணீரில் கரைத்தான். அந்த தண்ணீரை பருகும்படி இஸ்ரவேல் ஜனங்களை வற்புறுத்தினான். ");
INSERT INTO tam2008_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","மோசே ஆரோனை நோக்கி, “இந்த ஜனங்கள் உனக்குச் செய்ததென்ன? ஏன் இந்த மாபெரும் கேடான பாவத்தைச் செய்யும்படியாக அவர்களை வழி நடத்தினாய்?” என்று கேட்டான். ");
INSERT INTO tam2008_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","ஆரோன், “கோபம் கொள்ளாதிரும், இந்த ஜனங்கள் எப்போதுமே பாவம் செய்யத் தயாராக இருக்கிறார்கள் என்பது உமக்குத் தெரியும் அல்லவா. ");
INSERT INTO tam2008_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","ஜனங்கள் என்னிடம், ‘மோசே எங்களை எகிப்திலிருந்து வழிநடத்தினான். ஆனால் அவருக்கு என்ன நேர்ந்தது என்று எங்களுக்குத் தெரியவில்லை. எனவே, எங்களை வழிநடத்துவதற்கு தெய்வங்களைச் செய்’ என்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","நான் அவர்களிடம், ‘உங்களிடம் பொன் காதணிகள் இருந்தால், அவற்றை என்னிடம் கொடுங்கள்’ என்றேன். ஜனங்கள் பொன்னை என்னிடம் கொடுத்தார்கள். நான் பொன்னை நெருப்பில் போட்டேன். நெருப்பிலிருந்து கன்றுகுட்டி வந்தது!” என்று பதிலுரைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","ஜனங்கள் கட்டுப்பாட்டை மீறி அநாகரீகமாக நடக்கும்படியாக ஆரோன் அவர்களை அனுமதித்ததை மோசே கண்டான். ஜனங்கள் காட்டுமி ராண்டித்தனமாக நடந்துகொண்டதை அவர்களின் பகைவர்கள் கண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","எனவே, பாளையத்தின் நுழைவாயிலில் மோசே நின்றான். மோசே, “கர்த்தரைப் பின்பற்ற விரும்புகிறவர்கள் என்னிடம் வாருங்கள்” என்று சொன்னான். லேவியின் குடும்பத்தைச் சேர்ந்த அனைவரும் மோசேயிடம் ஓடினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","பின்பு மோசே அவர்களை நோக்கி, “இஸ்ரவேலின் தேவனாகிய கர்த்தர் சொல்வதை நான் உங்களுக்குக் கூறுவேன்: ‘ஒவ்வொருவனும் வாளை எடுத்துக்கொண்டு பாளையத்தின் ஒரு புறத்திலிருந்து மறுபுறம் வரைக்கும் போய் வாருங்கள். ஒவ்வொருவனும் தனது சகோதரனையும் நண்பனையும், அயலானையும் கொல்ல வேண்டி வந்தாலும் அவர்களைக் கொல்ல வேண்டும்’” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","லேவி குடும்பத்தின் ஜனங்கள் மோசேக்குக் கீழ்ப்படிந்தனர். அன்றையதினம் சுமார் 3,000 இஸ்ரவேல் ஜனங்கள் செத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","மோசே, “தமக்குப் பணிவிடை செய்ய கர்த்தர் இன்று உங்களைத் தெரிந்தெடுத்தார். ஏனென்றால், இன்றைக்கு உங்களில் ஒவ்வொருவரும் அவனது மகனுக்கு எதிராகவும், சகோதரனுக்கு எதிராகவும் இருந்தீர்கள். எனவே இன்று அவர் உங்கள் மேல் ஆசீர்வாதம் பொழிவார்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","மறுநாள் காலையில் மோசே ஜனங்களை நோக்கி, “நீங்கள் கொடிய பாவம் செய்துள்ளீர்கள்! நான் கர்த்தரிடம் மேலே போவேன். உங்கள் பாவத்தை அவர் மன்னிப்பதற்காக நான் ஏதாவது செய்யக்கூடுமா எனப் பார்ப்பேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","எனவே மோசே கர்த்தரிடம் மீண்டும் சென்று, “தயவு செய்து நான் கூறுவதைக் கேளும்! இந்த ஜனங்கள் பெரும்பாவம் செய்தனர். அவர்கள் பொன்னால் ஒரு தேவனைச் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","இப்போது அவர்களின் இப்பாவத்தை மன்னித்துவிடும்! நீர் அவர்களை மன்னிக்காவிட்டால், உமது புத்தகத்திலிருந்து எனது பெயரை கிறுக்கி விடும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","ஆனால் கர்த்தர் மோசேயை நோக்கி, “எனக் கெதிராக பாவம் செய்தோரின் பெயர்களை மட்டுமே நான் அழிப்பேன். ");
INSERT INTO tam2008_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","எனவே நீ கீழே போய் நான் சொல்கிற இடத்திற்கு ஜனங்களை வழிநடத்து. எனது தூதன் உங்களுக்கு முன்பாகச் சென்று வழிநடத்துவார். பாவம் செய்கிற மனிதர்கள் தண்டிக்கப்படும் காலம் வரும்போது அவர்கள் தண்டிக்கப்படுவார்கள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","எனவே கர்த்தர் ஒரு கொடிய நோய் ஜனங்களை வாதிக்கும்படியாகச் செய்தார். ஆரோனிடம் பொன் கன்றுக்குட்டியைச் செய்யுமாறு கேட்டதால் அவர் இவ்வாறு செய்தார். ");
INSERT INTO tam2008_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","பின்பு கர்த்தர் மோசேயை நோக்கி, “நீயும், நீ எகிப்திலிருந்து வழிநடத்திய ஜனங்களும் இவ்விடத்தை விட்டுப் புறப்பட வேண்டும். ஆபிரகாம், ஈசாக்கு, யாக்கோபு ஆகியோருக்குக் கொடுப்பதாக நான் வாக்குறுதி அளித்த தேசத்திற்குச் செல்லுங்கள். அவர்களின் சந்ததிக்கு அத்தேசத்தைக் கொடுப்பதாகச் சொன்னேன். ");
INSERT INTO tam2008_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","எனவே உங்களுக்கு முன்பாகச் செல்வதற்கு ஒரு தூதனை அனுப்புவேன். கானானியரையும், எமோரியரையும், ஏத்தியரையும், பெரிசியரையும், ஏவியரையும், எபூசியரையும், நான் தோற்கடிப்பேன். உங்கள் தேசத்தைவிட்டு அவர்கள் போகும்படியாகச் செய்வேன். ");
INSERT INTO tam2008_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","எனவே உச்சி தமான பொருட்களால் நிரம்பியுள்ள அத்தேசத்திற்குச் செல்லுங்கள். ஆனால் நான் உங்களோடு வரமாட்டேன். நீங்கள் பிடிவாத மான ஜனங்கள். என்னை மிகவும் கோபப்படுத்துகிறீர்கள். நான் உங்களோடு வந்தால் ஒருவேளை வழியிலேயே உங்களை அழித்து விடுவேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","ஜனங்கள் இந்தச் செய்தியைக் கேட்டுக் கவலையடைந்தனர். அவர்கள் ஆபரணங்கள் அணிவதை விட்டுவிட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","ஏனெனில் கர்த்தர் மோசேயை நோக்கி, “இஸ்ரவேல் ஜனங்களுக்குக் கூறு, ‘நீங்கள் பிடிவாதமான ஜனங்கள். சிறிது காலம் உங்களோடு வந்தாலும் நான் உங்களை அழித்து விடக்கூடும். நான் உங்களுக்கு என்ன செய்வதென முடிவெடுக்கும்வரை உங்கள் அணிகலன்களைக் கழற்றிவிடுங்கள்’ என்று கூறு” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","(சீனாய்) ஓரேப் மலையருகே இஸ்ரவேல் ஜனங்கள் ஆபரணங்களை அணிவதை விட்டுவிட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","பாளையத்துக்கு வெளியே சற்று தூரத்தில் மோசே ஒரு கூடாரத்தை எடுத்துச் செல்வது வழக்கம். மோசே அதை “ஆசரிப்புக் கூடாரம்” என்று அழைத்தான். கர்த்தரிடமிருந்து எதையாவது கேட்டறிய விரும்புகிறவன் பாளையத்துக்கு வெளியே ஆசாரிப்புக் கூடாரத்திற்குச் செல்வான். ");
INSERT INTO tam2008_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","மோசே அக்கூடாரத்திற்குப் போகும் போதெல்லாம் ஜனங்கள் அவனைக் கவனித்து நோக்கினார்கள். ஜனங்கள் அவரவர் கூடாரத்தின் வாயிலில் வந்து நின்று, மோசே ஆசாரிப்புக் கூடாரத்திற்குள் நுழைவதைப் பார்த்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","மோசே கூடாரத்திற்கு போகும்போதெல்லாம் நீண்ட மேகம் இறங்கி வந்து கூடாரத்தின் வாசலில் தங்கும். கர்த்தர் மோசேயோடு பேசுவார். ");
INSERT INTO tam2008_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","ஜனங்கள் கூடார வாசலில் மேகத்தைப் பார்க்கும்போதெல்லாம் அவரவர் கூடார வாசல்களுக்குச் சென்று கீழே குனிந்து கர்த்தரை வணங்கினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","இவ்வாறு கர்த்தர் மோசேயுடன் நேருக்கு நேராக நின்று பேசினார். ஒரு மனிதன் தன் நண்பனிடம் பேசுவதுபோல கர்த்தர் மோசேயுடன் பேசினார். கர்த்தரிடம் பேசியபிறகு, மோசே தங்குமிடத்துக்குத் திரும்பினான். ஆனால் அவனது உதவியாளன் எப்போதும் கூடரத்திலேயே இருந்தான். அந்த உதவியாளன் நூனின் மகனாகிய யோசுவா என்பவனாவான். ");
INSERT INTO tam2008_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","மோசே கர்த்தரை நோக்கி, “இந்த ஜனங்களை வழிநடத்துமாறு நீர் சொன்னீர். ஆனால் என்னோடு வருபவர் யார் என்பதை நீர் கூறவில்லை. நீர் என்னிடம், ‘உன்னை நன்கு அறிவேன். உன்னைக் குறித்து பிரியமாயிருக்கிறேன்.’ என்றீர். ");
INSERT INTO tam2008_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","நான் உண்மையாகவே உம்மை திருப்திப்படுத்தியிருந்தால் உமது வழிகளை எனக்குப் போதியும். நான் உம்மை அறிந்துகொள்ள விரும்புகிறேன். நான் தொடர்ந்து உம்மைப் பிரியப்படுத்துவேன். இவர்கள் உமது ஜனங்கள் என்பதை நினைவுகூரும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","கர்த்தர், “நான் உன்னோடுகூட வருவேன். உன்னை வழிநடத்துவேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","அப்போது மோசே கர்த்தரை நோக்கி, “நீர் வழி நடத்தவில்லையெனில், என்னை இவ்விடத்திலிருந்து அனுப்பாதிரும். ");
INSERT INTO tam2008_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","மேலும், என்னிடமும் இந்த ஜனங்களிடமும் திருப்தியடைந்துள்ளீர் என்பதை நான் எவ்வாறு அறிவேன்? நீர் எங்களோடு வந்தால், அதை நிச்சயமாக அறிவோம். இல்லையென்றால், பூமியிலுள்ள மற்ற மனிதருக்கும் எங்களுக்கும் வித்தியாசமேயில்லை” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","அப்போது கர்த்தர் மோசேயிடம், “நீ கேட்டபடியே நான் செய்வேன். உன்னில் சந்தோஷம் அடைந்திருக்கிறேன், உன்னை நான் நன்கு அறிவேன்.” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","அப்போது மோசே, “இப்போது உமது மகிமையை எனக்குக் காட்டும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","கர்த்தர், “என் பரிபூரண நன்மை உனக்கு முன் செல்லும்படி செய்வேன். நானே கர்த்தர், நீ கேட்கும்படி என் பெயரை அறிவிப்பேன். நான் விரும்பும் யாருக்கும் எனது இரக்கத்தையும், அன்பையும் காட்டுவேன். ");
INSERT INTO tam2008_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","ஆனால் நீ என் முகத்தைப் பார்க்க முடியாது. எந்த மனிதனும் என்னைப் பார்த்து பின்பு உயிரோடு இருக்க முடியாது. ");
INSERT INTO tam2008_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","“எனக்கருகிலுள்ள ஒரு இடத்தில் ஒரு பாறை உள்ளது. நீ அப்பாறையின் மேல் ஏறி நில். ");
INSERT INTO tam2008_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","எனது மகிமை அவ்விடத்தைக் கடந்து செல்லும். நான் உன்னைத் தாண்டும்போது உன்னை அந்தப் பாறையின் வெடிப்பில் வைத்து என் கரங்களால் உன்னை மூடுவேன். ");
INSERT INTO tam2008_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","பின் எனது கைகளை விலக்குவேன். நீ என் முதுகைக் காண்பாய், ஆனால் நீ என் முகத்தைக் காணமாட்டாய்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","கர்த்தர் மோசேயை நோக்கி, “உடைந்து போன முதல் இரண்டு பலகைகளைப் போலவேவேறே இரண்டு கற்பலகைகளைச் செய். முதல் இரண்டு கற்களிலும் எழுதப்பட்ட அதே வார்த்தைகளை நான் இந்தக் கற்களிலும் எழுதுவேன். ");
INSERT INTO tam2008_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","நாளை காலையில் தக்க ஆயத்தத்துடன் சீனாய் மலைக்கு வா. மலையின்மேல் என் முன்னே வந்து நில். ");
INSERT INTO tam2008_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","உன்னோடு வேறு யாரும் வரக்கூடாது. யாரும் மலையில் காணப்படக் கூடாது. உங்கள் மிருகங்களோ, ஆட்டு மந்தைகளோ எதுவும் மலையடிவாரத்தில் புல்லை உண்பதற்குக்கூட அனுமதிக்கக் கூடாது” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","எனவே, முதல் இரண்டு கற்பலகைகளைப் போலவே வேறே இரண்டு கற்பலகைகளை மோசே உருவாக்கினான். மறுநாள் அதிகாலையில் சீனாய் மலையின் மேல் ஏறிச் சென்றான். கர்த்தர் கட்டளையிட்டபடியே மோசே எல்லாவற்றையும் செய்தான். மோசே இரண்டு கற்பலகைகளையும் தன்னோடு எடுத்துச் சென்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","மோசே மலையின்மீது ஏறியவுடன், கர்த்தர் மேகத்தில் அவனிடம் இறங்கி வந்து, தமது பெயரை மோசேயிடம் சொன்னார். ");
INSERT INTO tam2008_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","கர்த்தர் மோசேக்கு முன்னர் கடந்து சென்று, “யேகோவா என்னும் கர்த்தர், இரக்கமும் தயவும் உள்ள தேவன். கர்த்தர் எளிதில் கோபம் கொள்ளமாட்டார். கர்த்தர் அன்பு மிகுந்தவர், கர்த்தர் நம்பிக் கைக்குரியவர். ");
INSERT INTO tam2008_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ஆயிரம் தலைமுறைவரைக்கும் கர்த்தர் தமது இரக்கத்தைக் காட்டுவார். ஜனங்கள் செய்கிற தவறுகளைக் கர்த்தர் மன்னிப்பார். ஆனால் குற்றவாளிகளைத் தண்டிக்க கர்த்தர் மறப்பதில்லை. கர்த்தர் குற்றவாளிகளை மட்டும் தண்டிக்காமல் அவர்களின் பிள்ளைகளையும், பேரக் குழந்தைகளையும், அவர்களின் பிள்ளைகளையும், அவர்கள் செய்த தீயகாரியங்களுக்காகத் தண்டிப்பார்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","உடனே மோசே கீழே தரையில் குனிந்து கர்த்தரைத் தொழுதுகொண்டான். மோசே, ");
INSERT INTO tam2008_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“கர்த்தாவே நீர் என்னோடு சந்தோஷமாக இருக்கிறீர் என்பது உண்மையானால் தயவு செய்து எங்களோடு வாரும். இவர்கள் பிடிவாதமான ஜனங்கள் என்பதை அறிவேன். ஆனால் நாங்கள் செய்த தீயசெயல்களுக்கு எங்களை மன்னித்தருளும்! உமது ஜனங்களாக எங்களை ஏற்றுக்கொள்ளும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","அப்போது கர்த்தர், “உன் ஜனங்கள் எல்லாரோடும் இந்த உடன்படிக்கையைச் செய்கிறேன். பூமியிலுள்ள வேறேந்த ஜனத்துக்கும் செய்யாத வியக்கத்தக்க காரியங்களை நான் உங்களிடம் செய்வேன். உன்னோடு இருக்கிற ஜனங்கள் நான் மிக உன்னதமான கர்த்தர் என்பதைக் காண்பார்கள். நான் உனக்காகச் செய்யப்போகும் அற்புதங்களை ஜனங்கள் காண்பார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","நான் இன்றைக்கு உங்களுக்கு இடும் கட்டளைகளுக்குக் கீழ்ப்படியுங்கள். உங்கள் நாட்டிலிருந்து உங்கள் பகைவர்கள் போகும்படி செய்வேன். எமோரியரையும், கானானியரையும், ஏத்தியரையும், பெரிசியரையும், ஏவியரையும், எபூசியரையும் வெளியேற்றுவேன். ");
INSERT INTO tam2008_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","எச்சரிக்கையாயிருங்கள், நீங்கள் நுழையும் இந்தத் தேசத்தின் ஜனங்களோடு எந்த ஒப்பந்தத்தையும் செய்யாதீர்கள்! அந்த ஜனங்களோடு ஒப்பந்தம் செய்தால் அது உங்களுக்குத் தொல்லையைத் தரும். ");
INSERT INTO tam2008_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","ஆகையால் அவர்கள் பலிபீடங்களை அழித்துப்போடுங்கள். அவர்கள் தொழுதுகொள்ளும் கற்களை உடையுங்கள். அவர்கள் விக்கிரகங்களை நொறுக்குங்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","வேறெந்த தேவனையும் தொழுதுகொள்ளாதீர்கள். நான் ‘யேகோவா’ என்னும் வைராக்கியமுள்ள கர்த்தர். இதுவே என் பெயர். நான் எல்கானா-வைராக்கியமுள்ள தேவன். ");
INSERT INTO tam2008_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“இத்தேசத்து ஜனங்களோடு எந்தவொரு ஒப்பந்தமும் செய்யாதீர்கள். அவ்வாறு செய்தால் அவர்கள் தங்கள் தெய்வங்களைத் தொழுதுகொள்ளும்போது நீங்களும் சேர்ந்துகொள்ள அவர்கள் உங்களை அழைப்பார்கள். பிறகு அவர்கள் செலுத்திய பலிகளை நீங்கள் உண்பீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","அவர்களின் மகள்களை உங்கள் மகன்களுக்காக நிச்சயம் செய்யக்கூடும். அப்பெண்கள் பொய்த் தேவர்களை சேவிக்கிறார்கள். உங்கள் மகன்களையும் அவ்வாறே பொய்த் தேவர்களை தொழுதுகொள்ள வழிநடத்தக்கூடும். ");
INSERT INTO tam2008_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“விக்கிரகங்களைச் செய்யாதீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“புளிப்பில்லாத ரொட்டியின் பண்டிகையைக் கொண்டாடுங்கள். உங்களுக்கு நான் கட்டளையிட்டபடி ஏழு நாட்கள் புளிப்பில்லாமல் செய்த ரொட்டிகளை உண்ணுங்கள். நான் தெரிந்துகொண்டபடி ஆபிப் மாதத்திலேயே இதைச் செய்யுங்கள். ஏனெனில், அந்த மாதத்திலேயே நீங்கள் எகிப்தைவிட்டு வந்தீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“ஒரு பெண்ணிடம் பிறக்கும் முதல் குழந்தை எப்போதும் எனக்குரியது. உங்கள் மிருகங்களின் ஆடுகளின் முதற்பேறானவையும் எனக்குரியவை. ");
INSERT INTO tam2008_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","கழுதையின் முதல் ஈற்றை நீங்கள் வைத்துக்கொள்ள விரும்பினால் அதை ஒரு ஆட்டுக்குட்டியைக் கொடுத்து திரும்பப் பெறவேண்டும். இவ்வாறு ஆட்டுக்குட்டியைக் கொடுத்து அக்கழுதையை மீட்காவிட்டால் அப்போது அந்தக் கழுதையின் கழுத்தை முறித்துப் போடவேண்டும். உங்கள் முதற்பேறான மகன்கள் அனைவரையும் நீங்கள் என்னிடமிருந்து மீண்டும் வாங்கவேண்டும். காணிக்கையின்றி யாரும் என் முன்னிலையில் வரக்கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“நீங்கள் ஆறு நாட்கள் உழையுங்கள். ஏழாம் நாள் நீங்கள் ஓய்வெடுக்க வேண்டும். விதைப்பு, அறுவடை காலங்களிலும் நீங்கள் ஓய்வு நாளில் ஓய்வெடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“வாரங்களின் பண்டிகையை (பெந்தெகோஸ்தே) கொண்டாடுங்கள். கோதுமை அறுவடையின் முதல் தானியத்தை அதற்குப் பயன்படுத்துங்கள். இலையுதிர் காலத்தின்போது அறுப்பின் பண்டிகையைக் கொண்டாடுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“ஆண்டில் மூன்று முறை உங்கள் ஜனங்கள் இஸ்ரவேலரின் தேவனாயிருக்கிற கர்த்தராகிய ஆண்டவரின் சந்நிதானத்திற்குச் செல்ல வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","“உங்கள் தேசத்திற்குள் நீங்கள் போகும்போது, அத்தேசத்திலிருந்து உங்கள் பகைவர்களை வெளியேற்றுவேன். உங்கள் எல்லைகளை விரிவுபடுத்தி உங்கள் தேசத்தின் அளவை அதிகரிக்கச் செய்வேன். உங்கள் தேவனாகிய கர்த்தருக்கு முன் ஓராண்டில் மூன்று முறை செல்லுங்கள் அப்போது, யாரும் உங்கள் நாட்டை எடுத்துக்கொள்ள முயலமாட்டார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“பலியின் இரத்தத்தை எனக்குப் படைக்கும்போதெல்லாம் புளிப்பை அதனோடு படைக்காதீர்கள். “பஸ்கா உணவிலுள்ள இறைச்சியை மறுநாள் காலைவரைக்கும் வைக்காதீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“நீங்கள் அறுவடை செய்யும் முதல் தானியங்களைக் கர்த்தருக்குக் கொடுங்கள். உங்கள் தேவனாகிய கர்த்தருடைய வீட்டிற்கு அவற்றைக் கொண்டு வாருங்கள். “இளம் ஆட்டை அதன் தாய்ப்பாலில் ஒருபோதும் சமைக்காதீர்கள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","மீண்டும் கர்த்தர் மோசேயிடம், “நான் உங்களுக்குக் கூறிய எல்லாக் காரியங்களையும் எழுதிக்கொள். உன்னோடும், இஸ்ரவேல் ஜனங்களோடும் நான் செய்த உடன்படிக்கை இதுவேயாகும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","மோசே 40 பகலும் 40 இரவும் கர்த்தரோடு தங்கினான். மோசே எந்த உணவையும் உண்ணவோ, தண்ணீரைப் பருகவோ இல்லை. இரண்டு கற்பலகைகளில் உடன்படிக்கையை (பத்துக் கட்டளைகளை) மோசே எழுதினான். ");
INSERT INTO tam2008_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","பின் மோசே சீனாய் மலையிலிருந்து உடன்படிக்கை எழுதப்பட்ட இரண்டு கற் பலகைகளையும் எடுத்துக்கொண்டு இறங்கி வந்தான். கர்த்தரோடு பேசியதால் அவன் முகம் பிரகாசித்தது. ஆனால் மோசே அதனை அறியவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","ஆரோனும் இஸ்ரவேல் ஜனங்களும் மோசேயின் முகம் பிரகா சிப்பதைக் கண்டனர். எனவே அவனிடம் செல்ல பயந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","ஆனால் மோசே அவர்களை அழைத்தான். எனவே, ஆரோனும், ஜனங்களின் தலைவர்களும் மோசேயிடம் சென்றனர். மோசே அவர்களோடு பேசினான். ");
INSERT INTO tam2008_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","அதன் பிறகு இஸ்ரவேல் ஜனங்கள் எல்லோரும் மோசேயிடம் வந்தனர். சீனாய் மலையில் கர்த்தர் அவனிடம் கொடுத்த கட்டளைகளை மோசே அவர்களுக்குக் கொடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","ஜனங்களிடம் மோசே பேசி முடித்த பின்பு அவன் தன் முகத்தில் ஒரு முக்காடு போட்டுக்கொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","மோசே கர்த்தருக்கு முன் பேசச் செல்லும்போது அதை அகற்றினான். அப்புறம் கர்த்தர் கூறிய கட்டளைகளை அவன் இஸ்ரவேல் ஜனங்களிடம் வந்து கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","மோசேயின், முகம் பிரகாசிப்பதை ஜனங்கள் கண்டனர். மீண்டும் மோசே முகத்தை மூடிக்கொண்டான். மறுமுறை கர்த்தரை சந்தித்துப் பேசுவதற்குச் செல்லும்வரைக்கும் மோசே அவனது முகத்தை மூடி வைத்திருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","மோசே இஸ்ரவேல் ஜனங்கள் எல்லோரையும் ஒன்றாகக் கூட்டி அவர்களை நோக்கி, “நீங்கள் செய்ய வேண்டுமெனக் கர்த்தர் கட்டளையிட்ட காரியங்களை நான் உங்களுக்குக் கூறுவேன்: ");
INSERT INTO tam2008_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","“ஆறு நாட்கள் நீங்கள் வேலை செய்யலாம். ஏழாவது நாள் நீங்கள் ஓய்வெடுப்பதற்குரிய மிக விசேஷ நாளாகும். அந்த நாளில் ஓய்வெடுப்பதன் மூலம் கர்த்தரை மகிமைப்படுத்துவீர்கள். ஏழாவது நாளில் வேலை செய்கிற எவனும் கொல்லப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","ஓய்வு நாளில் நீங்கள் வாழுமிடங்களில் நெருப்பை மூட்டவும் கூடாது” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","மோசே இஸ்ரவேலின் எல்லா ஜனங்களுக்கும் கூறியதாவது, “இதுவே கர்த்தர் கட்டளையிட்டவை: ");
INSERT INTO tam2008_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","கர்த்தருக்காக விசேஷ காணிக்கைகளைச் சேர்த்து வையுங்கள். என்ன காணிக்கையைக் கொடுக்க வேண்டும் என்பதை மனதுக்குள்ளேயே ஒவ்வொருவரும் தீர்மானம் செய்துகொள்ளுங்கள். பின் அந்த காணிக்கையைக் கர்த்தருக்குக் கொண்டுவர வேண்டும். பொன், வெள்ளி, வெண்கலம் ஆகியவற்றைக் கொண்டு வாருங்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","இளநீலம், இரத்தாம்பரம், சிவப்பு ஆகிய நூலையும், வெள்ளாட்டு மயிராலான கம்பள துணியையும் ");
INSERT INTO tam2008_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","சிவப்புத் தோய்த்த கடாவின் தோலையும், மெல்லிய தோலையும், சீத்திம் மரத்தையும், ");
INSERT INTO tam2008_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","குத்து விளக்குகளுக்கு எண்ணெயையும், தூபம் காட்டுவதற்கு நறுமணப் பொருள்களையும் கொண்டு வாருங்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","மேலும் கோமேதகக் கல்லையும், ஏபோத்திலும் நியாயத்தீர்ப்பு மார்ப்பதகத்திலும் வைக்க வேண்டிய கற்களையும் கொண்டு வாருங்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“கர்த்தர் கட்டளையிட்ட பொருள்களையெல்லாம் திறமை மிகுந்த கைவேலைக்காரர் அனைவரும் செய்ய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","பரிசுத்தக் கூடாரம், அதன் வெளிப்பிரகாரம், அதன் மேற் பரப்பு: கொக்கிகள், பலகைகள், தாழ்ப்பாள்கள், தூண்கள், அடித்தளங்கள், ");
INSERT INTO tam2008_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","பரிசுத்தப் பெட்டி, அதன் தண்டுகள், கிருபாசனம், பெட்டி இருக்குமிடத்தை மூடும் திரை, ");
INSERT INTO tam2008_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","மேசையும் அதன் தண்டுகளும், மேசையின் மீதிருக்கும் பொருள்கள், மேசையின் மீது வைக்க வேண்டிய விசேஷ ரொட்டி, ");
INSERT INTO tam2008_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","வெளிச்சத்திற்கான குத்து விளக்குத் தண்டு, அதனோடு பயன்படுத்தப்படும் பொருட்கள், விளக்குகள், விளக்குக்கு எண்ணெய், ");
INSERT INTO tam2008_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","நறுமணப் பொருள்களை எரிக்கும்பீடம், அதன் தண்டுகள், அபிஷேக எண்ணெய், நறுமணப் புகைப் பொருள், பரிசுத்தக் கூடாரத்தின் நுழைவாயிலை மூடும் திரை, ");
INSERT INTO tam2008_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","தகன பலிபீடம், வெண்கலத் தளம், அதின் தண்டுகள், பலிபீடத்தில் பயன்படும் பொருட்கள், வெண்கலத் தொட்டிகள், அதன் பீடம், ");
INSERT INTO tam2008_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","பிரகாரத்தைச் சுற்றிலுமுள்ள திரைகள், அவற்றிற்கான தூண்களும், பீடங்களும், பிரகாரத்திற்கான நுழை வாயிலை மூடும் திரை, ");
INSERT INTO tam2008_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","கூடாரத்தைத் தாங்கி நிற்க உதவும் வெண்கல முளைகள், திரைகளின் சுவர்கள், வெளிப்பிரகாரத்தின் முளைகள், முளைகளில் கட்டப்படும் கயிறுகள், ");
INSERT INTO tam2008_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","பரிசுத்த இடத்தில் ஆசாரியர் அணியும் பொருட்டு விசேஷமாக நெய்த ஆடைகள். இந்த விசேஷ ஆடைகள் ஆசாரியனான ஆரோனும் அவன் மகன்களும் அணிவதற்குரியவை. அவர்கள் ஆசாரியராகப் பணியாற்றும்போது இந்த விசேஷ ஆடைகளை அணிவார்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","இஸ்ரவேல் ஜனங்கள் மோசேயிடமிருந்து புறப்பட்டு சென்றனர். ");
INSERT INTO tam2008_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","கர்த்தருக்கு காணிக்கைகளைக் கொடுக்க விரும்பியவர்கள் அனைவரும் கொண்டு வந்தனர். ஆசாரிப்புக் கூடாரம், அதிலுள்ள பொருட்கள், விசேஷ ஆடைகள் ஆகியவற்றைச் செய்வதற்கு இப் பொருட்கள் பயன்படுத்தப்பட்டன. ");
INSERT INTO tam2008_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","பல வகை பொன் அணிகலன்களைக் கொடுக்க விரும்பிய தாராள மனமுள்ள ஆண்களும், பெண்களும் அவற்றைக் கொண்டு வந்தனர். அவர்கள் ஊசிகள், காதணிகள், மோதிரங்கள், மற்றும் பிற அணிகலன்களைக் கொண்டு வந்தார்கள். கர்த்தருக்காக தம் ஆபரணங்களை அவர்கள் கொடுத்தனர். இது கர்த்தருக்கு விசேஷ காணிக்கையாகும். ");
INSERT INTO tam2008_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","மெல்லிய துகில், மற்றும் இளநீல இரத்தாம்பர, சிவப்பு நூல் வைத்திருந்தவர்கள் அனைவரும் அவற்றைக் கர்த்தருக்காகக் கொண்டு வந்தார்கள். மேலும் ஆட்டுத் தோலோ, சிவப்புச் சாயமிட்ட செம்மறியாட்டுத் தோலோ அல்லது பதனிடப்பட்ட மெல்லிய தோலோ வைத்திருந்தவர்கள் அதைக் கர்த்தருக்காகக் கொண்டு வந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","வெள்ளி, வெண்கலம் ஆகியவற்றைக் கொடுக்க விரும்பியவர்கள், கர்த்தருக்குக் காணிக்கையாகக் கொண்டு வந்தனர். சீத்திம் மரத்தை வைத்திருந்தவர்கள் அதைக் கர்த்தருக்குக் கொண்டுவந்து கொடுத்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","கலைத்திறன் வாய்ந்த ஒவ்வொரு பெண்ணும் மெல்லிய துகில், இளநீலம், இரத்தாம்பரம், சிவப்பு நிற நூல்களையும் தயாரித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","திறமை மிகுந்தவர்களும், உதவிசெய்ய விரும்பிய எல்லா பெண்களும் வெள்ளாட்டு மயிரால் ஆடைகளைச் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","தலைவர்கள் கோமேதகக் கற்களையும் பிற விலையுயர்ந்த கற்களையும் கொண்டுவந்தனர். ஆசாரியரின் ஏபோத்திலும் நியாயத்தீர்ப்பு மார்ப்பதக்கத்திலும் இவை வைக்கப்பட்டன. ");
INSERT INTO tam2008_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ஜனங்கள் தூபவர்க்க பொருட்களையும், ஒலிவ எண்ணெயையும் கொண்டு வந்தனர். நறுமணப் பொருள்களுக்கும், அபிஷேக எண்ணெய்க்கும், குத்துவிளக்கின் எண்ணெய்க்கும் இவை பயன்படுத்தப்பட்டன. ");
INSERT INTO tam2008_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","உதவிசெய்ய விரும்பிய இஸ்ரவேல் ஜனங்கள் எல்லோரும் கர்த்தருக்கு அன்பளிப்புகளைக் கொண்டு வந்தனர். இவ்வன்பளிப்புகளை அவர்கள் விரும்பிக் கொடுத்ததால் தாராளமாகக் கொடுத்தார்கள். கர்த்தர் மோசேக்கும், அவனது ஜனங்களுக்கும் செய்யுமாறு கட்டளையிட்ட எல்லாப் பொருட்களையும் செய்வதற்கு இப்பொருள்கள் பயன்படுத்தப்பட்டன. ");
INSERT INTO tam2008_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","பின் மோசே இஸ்ரவேல் ஜனங்களை நோக்கி, “பாருங்கள், கர்த்தர் யூதாவின் கோத்திரத்தைச் சேர்ந்த ஊர் என்பவனின் குமாரனாகிய, ஊரியின் மகனான பெசலெயேலை தெரிந்தெடுத்துள்ளார். ");
INSERT INTO tam2008_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","தேவ ஆவியால் பெசலெயேலை நிரப்பியுள்ளார். பலவகை காரியங்களையும் செய்யவல்ல திறனையும், அறிவையும் அவனுக்குக் கொடுத்திருக்கிறார். ");
INSERT INTO tam2008_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","அவன் பொன், வெள்ளி, வெண்கலம் ஆகியவற்றால் பொருள்களைச் செய்து அவற்றை வடிவமைக்க வல்லவன். ");
INSERT INTO tam2008_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","கற்களைச் செதுக்கி அவற்றில் ஆபரணங்களைச் செய்யமுடியும். பெசலெயேலுக்கு மரவேலைகள் அனைத்தும் தெரியும். ");
INSERT INTO tam2008_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","பிறருக்குக் கற்பிக்கும்படியான விசேஷ திறமைகளைக் கர்த்தர் பெசலேயேலுக்கும், அகோலியாபிற்கும் (தாண் கோத்திரத்து அகிசமாகின் மகன்.) கொடுத்திருக்கிறார். ");
INSERT INTO tam2008_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","எல்லா வகை வேலைகளையும் செய்யும் ஆற்றலைக் கர்த்தர் இவர்களுக்குக் கொடுத்திருக்கிறார். தச்சு, உலோக வேலைகளையும் அவர்கள் செய்வார்கள். இளநீலம், இரத்தாம்பரம், சிவப்பு நூலாலும், மெல்லிய துகிலாலும் ஆடைகளைச் சித்திர வேலைப்பாடுகளோடு நெய்வதில் வல்லவர்கள். கம்பளியும் அவர்களால் நெய்ய முடிந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“எனவே பெசலேயேல், அகோலியாப், மற்றும் திறமைவாய்ந்த கலைவல்லுநர்கள் அனைவரும் சேர்ந்து கர்த்தர் கட்டளையிட்ட வேலைகளைச் செய்ய வேண்டும். அவர்கள் இந்த பரிசுத்த இடத்தை எழுப்புவதற்கான கைதேர்ந்த வேலையை செய்யத் தேவையான ஞானத்தையும், அறிவையும் கர்த்தர் அந்த மனிதருக்குக் கொடுத்திருக்கிறார்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","பின் மோசே பெசலெயேலையும், அகோலியாபையும் கர்த்தரால் திறமை வழங்கப்பட்ட பிற கலைவல்லுநர்களையும் அழைத்தான். வேலையில் உதவ விரும்பியதால் அவர்களும் ஒன்றாகக் கூடினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","இஸ்ரவேல் ஜனங்கள் காணிக்கையாகக் கொண்டு வந்த எல்லாப் பொருட்களையும் மோசே இந்த ஜனங்களுக்குக் கொடுத்தான். தேவனின் பரிசுத்த இடத்தை எழுப்புவதற்கு அவர்கள் அந்தப் பொருட்களைப் பயன்படுத்தினார்கள். காலைதோறும் ஜனங்கள் தங்கள் விருப்பதின்படி காணிக்கைகளை கொண்டு வந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","பின்னர் கலை வல்லுநர்கள் பரிசுத்த இடத்தில் தாங்கள் செய்யும் வேலையை விட்டு மோசேயிடம் பேசுவதற்குச் சென்றார்கள். அவர்கள், ");
INSERT INTO tam2008_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","“ஜனங்கள் மிகுதியாகப் பொருட்களைக் கொண்டு வந்துள்ளனர்! கூடார வேலையை முடிப்பதற்குத் தேவையான பொருளைக் காட்டிலும் அதிகமான பொருள்கள் உள்ளன!” என்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","மோசே இந்தச் செய்தியை பாளையத்தைச் சுற்றிலும் அறிவித்து: “பரிசுத்த இடத்தின் வேலைக்கு இனிமேல் எவரும் எதையும் காணிக்கையாக தரவேண்டாம்” என்றான். இவ்வாறு ஜனங்கள் அளவுக்கதிகமாகக் கொடுப்பதைக் கட்டாயமாக நிறுத்த வேண்டியதாயிற்று. ");
INSERT INTO tam2008_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","தேவனின் பரிசுத்த இடத்தை எழுப்புவதற்கு ஜனங்கள் தேவைக்கு அதிகமான பொருட்களைக் கொண்டு வந்திருந்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","பரிசுத்தக் கூடாரத்தைக் திறமையுள்ளவர்கள் அமைக்கத் தொடங்கினார்கள். மெல்லிய துகில், இளநீலம், இரத்தாம்பரம், சிவப்பு நூல்களாலும் அவர்கள் பத்துத் திரைகளை உண்டாக்கினார்கள். திரைகளில் சிறகுகளுள்ள கேரூப் தூதர்களின் சித்திரங்களைத் தைத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ஒவ்வொரு திரையும் 28 முழ நீளமும் 4 முழ அகலமுமாக ஒரே அளவுடையதாய் அமைந்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","பணி செய்வோர் இரண்டு வெவ்வேறு திரைகளாக அத்திரைகளை இணைத்தனர். ஐந்து திரைகளை ஒரே திரையாகவும், மற்றும் ஐந்து திரைகளை இன்னொரு திரையாகவும் இணைத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","ஒரு திரையின் கடைசிப் பகுதியில் நீலத்துணியால் துளைகளைச் செய்தனர். மற்றொரு திரையின் கடைசிப் பகுதியிலும் அவ்வாறே செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ஒரு திரையின் இறுதிப் பகுதியில் 50 கண்ணிகளும் மற்றொரு திரையின் இறுதிப் பகுதியில் 50 கண்ணிகளும் இருந்தன. அவ்வளையங்கள் எதிரெதிராக அமைந்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","பின் அவர்கள் அத்திரைகளை இணைப்பதற்கு 50 பொன் வளையங்களைச் செய்தனர். எனவே பரிசுத்தக் கூடாரம் ஒரே துண்டாக இணைக்கப்பட்டது. ");
INSERT INTO tam2008_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","பரிசுத்தக் கூடாரத்தை மூடி மறைத்து நிற்குமாறு அந்தத் திறமைச்சாலிகள் மற்றொரு கூடாரத்தை அமைத்தனர். வெள்ளாட்டின் மயிரால் பதினொரு திரைகளைச் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","எல்லாத் திரைகளும் 30 முழ நீளமும் 4 முழ அகலமும் கொண்ட ஓரே அளவுடையனவாய் இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","பணியாட்கள் ஐந்து திரைகளை ஒன்றாகவும், பிற ஆறு திரைகளை ஒன்றாகவும் இணைத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","ஒரு திரையின் இறுதியில் 50 துளைகளை அமைத்தனர். மறறொரு திரையில் இறுதியிலும் அவ்வாறே செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","பணியாட்கள் 50 வெண்கல வளையங்களை இரு திரைகளையும் சேர்த்து ஒரே கூடாரமாக இணைப்பதற்காகச் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","பரிசுத்தக் கூடாரத்திற்கு அவர்கள் மேலும் இரண்டு மூடுதிரைகளை செய்தனர். ஒரு மூடுதிரை சிவப்புத் தோய்க்கப்பட்ட ஆட்டுக்கடாவின் தோலாலானது. மற்றொரு மூடுதிரை மெல்லிய தோலினாலானது. ");
INSERT INTO tam2008_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","பிறகு அந்த வல்லுநர்கள் பரிசுத்த கூடாரத்தைத் தாங்குவதற்காக சீத்தீம் மரத்தினால் சட்டங்களை அமைத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ஒவ்வொரு சட்டமும் 10 முழ நீளமும் 1 1/2 முழ அகலமும் உடையதாய் இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","இரண்டு பக்கத்திலும் தூண்கள் குறுக்குத் துண்டுகளால் இணைக்கப்பட்டு ஒவ்வொரு சட்டமும் அமைக்கப்பட்டது. பரிசுத்தக் கூடாரத்தின் ஒவ்வொரு சட்டமும் அவ்வாறு அமைந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","பரிசுத்தக் கூட்டத்தின் தெற்குப் புறத்திற்கு 20 சட்டங்களைச் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","பின் அந்தச் சட்டங்களுக்கு 40 வெள்ளி பீடங்களைச் செய்தனர். ஒவ்வொரு சட்டத்திற்கும் இரண்டு பீடங்கள் இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","அவர்கள் மறுபக்கமாகிய (வடபுறத்திற்கு) 20 சட்டங்களைச் செய்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ஒவ்வொரு சட்டத்திற்கும் இரண்டு பீடங்களாக 20 சட்டங்களுக்கு 40 வெள்ளி பீடங்களைச் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","பரிசுத்த கூடாரத்தின் பின் பகுதியாகிய மேற்கு புறத்திற்கு 6 சட்டங்கள் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","மேலும் பரிசுத்த கூடாரத்தின் பின் மூலைகளுக்கென்று 2 சட்டங்கள் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","இந்தச் சட்டங்கள் அடிப் புறத்தில் ஒன்றாக இணைக்கப்பட்டன. மேலே இந்த மூலை சட்டங்களை ஒரு வளையம் தாங்கிக்கொண்டிருந்தது. இரண்டு மூலைகளுக்கும் அவர்கள் அவ்வாறே செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","பரிசுத்தக் கூடாரத்தின் மேற்குப் புறத்தில் மொத்தம் எட்டுச் சட்டங்கள் இருந்தன. ஒவ்வொரு சட்டத்திற்கும் இரண்டு பீடங்கள் வீதம் 16 வெள்ளியாலாகிய பீடங்கள் அமைந்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","பரிசுத்தக் கூடாரத்தின் முதல் பக்கத்திற்கு சீத்திம் மரத்தாலான ஐந்து தாழ்ப்பாள்களைப் பணியாட்கள் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","மறுபக்கத்திற்கு ஐந்து தாழ்ப்பாள்களும், பரிசுத்தக் கூடாரத்தின் பின்புறத்திற்கு (மேற்கு) ஐந்து தாழ்ப்பாள்களும் அமைத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","சட்டத்தின் ஒரு முனையிலிருந்து மறுமுனைக்குச் செல்லும்படியாக மத்தியிலுள்ள தாழ்ப்பாளைச் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","தாழ்ப்பாள்களைத் தாங்கிக்கொள்வதற்குப் பொன்னால் வளையங்களைச் செய்தனர். தாழ்ப்பாள்களில் பொன் முலாம் பூசினர். ");
INSERT INTO tam2008_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","மெல்லிய துகில், இளநீலம், இரத்தாம் பரம், சிவப்புநிற நூல்களையும் மகாபரிசுத்த கூடாரத்தின் நுழைவாயிலுக்கான திரையைச் செய்வதற்குப் பயன்படுத்தினர். திரையில் கேருபீன்களின் சித்திரங்களைத் தைத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","சீத்திம் மரத்தால் நான்கு தூண்களைச் செய்து அவற்றிற்குப் பொன் முலாம் பூசினர். அவற்றிற்குப் பொன் கொக்கிகளைச் செய்தனர். அவற்றிற்கு நான்கு வெள்ளி பீடங்களைச் செய்து வைத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","கூடாரத்தின் வாயிலை மூடுவதற்குத் திரைகள் அமைத்தனர். அவர்கள் இளநீலம், இரத்தாம்பரம், சிவப்பு நிற நூலையும், மெல்லிய துகிலையும் இத்திரையைச் செய்வதற்கு உபயோகப்படுத்தினர். அத் திரையில் சித்திரங்களை நெய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","பின் அவர்கள் நுழைவாயிலின் திரைக்காக ஐந்து தூண்களையும் அதன் கொக்கிகளையும் அமைத்தனர். அவர்கள் தூண்களின் மேற் பகுதிகளையும் திரைத்தண்டுகளையும் பொன் தகட்டால் மூடினார்கள். அத்தூண்களுக்கு ஐந்து வெண்கல பீடங்களைச் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","சீத்திம் மரத்தினால் பெசலெயேல் பரிசுத்தப் பெட்டியைச் செய்தான். அந்தப் பெட்டி 2 1/2 முழ நீளமும் 1 1/2 முழ அகலமும் 1 1/2 முழு உயரமும் கொண்டவையாக இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","அவன் பெட்டியின் உட்புறத்தையும் வெளிப்புறத்தையும் பசும் பொன் தகட்டால் மூடினான். பெட்டியைச் சுற்றிலும் பொன் சட்டங்களைச் செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","அவன் நான்கு பொன் வளையங்களைச் செய்து அவற்றை நான்கு மூலைகளிலும் இணைத்தான். அவ்வளையங்கள் பெட்டியைச் சுமப்பதற்கென்று பயன்படுத்தப்பட்டன. ஒவ்வொரு பக்கத்திற்கும் இரண்டு வளையங்கள் இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","பின் அவன் பெட்டியைச் சுமப்பதற்குத் தேவையான தண்டுகளைச் செய்தான். அவன் சீத்திம் மரத்தால் அத்தண்டுகளைச் செய்து அவற்றைப் பசும் பொன்னால் மூடினான். ");
INSERT INTO tam2008_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","பெட்டியின் இருபுறங்களிலுமுள்ள வளையங்களினுள்ளே தண்டுகளைச் செலுத்தினான். ");
INSERT INTO tam2008_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","பின் கிருபாசனத்தை பசும் பொன்னால் செய்தான். அது 2 1/2 முழ நீளமும் 1 1/2 முழ அகலமும் உடையதாக இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","இரண்டு கேருபீன்களைச் செய்வதற்குப் பெசலெயேல் பொன்னைச் சுத்தியால் அடித்து உருவமைத்தான். இந்தக் கேருபீன்களை கிருபாசனத்தின் இரண்டு ஓரத்திலும் வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","ஒரு கேருபீனை கிருபாசனத்தின் ஒரு ஓரத்திலும், மற்றொரு கேருபீனை எதிர் ஓரத்திலும் வைத்தான். மூடியோடு இரண்டு கேருபீன் களையும் எதிரெதிரே ஒன்றாக இணைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","கேருபீன்களின் சிறகுகள் வானத்தை நோக்கி உயர்த்தப்பட்டிருந்தன. கேருபீன்கள் தங்கள் சிறகுகளால் பெட்டியை மூடியிருந்தன. கிருபாசனத்தின் மேல் குனிந்த நிலையில் தூதர்கள் ஒருவரையொருவர் நேருக்கு நேர் பார்த்துக்கொண்டிருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","பின் அவன் சீத்திம் மரப் பலகையிலான மேசையைச் செய்தான். அம்மேசை 2 முழ நீளமும் 1 முழ அகலமும் 1 முழ உயரமும் உள்ளதாக இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","அவன் மேசையை பசும் பொன்னினால் மூடினான். மேசையைச் சுற்றிலும் பொன் சட்டங்களை இணைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","பின் அவன் 3 அங்குல அகலமுள்ள ஒரு சட்டத்தை மேசையைச் சுற்றிலும் இணைத்தான். அவன் சட்டத்தின் மேல் பொன் தகட்டை வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","பின் அவன் நான்கு பொன் வளையங்களைச் செய்து அவற்றை மேசையின் நான்கு கால்களுமுள்ள நான்கு மூலைகளிலும் வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","மேசையின் மேற்பகுதியைச் சுற்றிலும் உள்ள சட்டத்தினருகே அவன் அந்த வளையங்களை இணைத்தான். மேசையைச் சுமக்கும் தண்டுகளைத் தாங்குவதற்கு அவ்வளையங்கள் பயன்பட்டன. ");
INSERT INTO tam2008_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","பின் அவன் சீத்திம் மரப்பலகையால் செய்யப்பட்ட மேசையைச் சுமக்கும் தண்டுகளைச் செய்தான். தண்டுகளைச் சுத்த பொன்னால் மூடினான். ");
INSERT INTO tam2008_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","பின் அவன் மேசையில் பயன்படுத்தப்படுவதற்குரிய எல்லாப் பொருட்களையும் செய்தான். தட்டுகள், கோப்பைகள், கரண்டிகள், கிண்ணங்கள், பாத்திரங்கள் ஆகியவற்றையும் அவன் பொன்னால் செய்தான். பானங்களின் காணிக்கைகளை ஊற்றுவதற்குக் கிண்ணங்களும் பாத்திரங்களும் பயன்பட்டன. ");
INSERT INTO tam2008_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","பிறகு அவன் குத்துவிளக்கைச் செய்தான். அவன் பசும் பொன்னை அடித்து அதன் பீடத்தையும், தண்டையும் செய்தான். பின் அவன் பூக்கள், மொட்டுகள், இதழ்கள் ஆகியவற்றைச் செய்து எல்லாவற்றையும் ஒன்றாக இணைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","குத்துவிளக்குக்கு ஆறு கிளைகள் இருந்தன. மூன்று கிளைகள் ஒரு புறத்திலும் மூன்று கிளைகள் எதிர் புறத்திலும் இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","ஒவ்வொரு கிளையிலும் மூன்று பூக்கள் இருந்தன. அப்பூக்கள் மொட்டுகளோடும், இதழ்களோடும் பூத்த வாதுமைப் பூக்களைப் போல செய்யப்பட்டன. ");
INSERT INTO tam2008_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","குத்துவிளக்கின் தண்டில், மேலும் நான்கு பூக்கள் இருந்தன. அவையும் மொட்டுகளோடும் இதழ்களோடும் பூத்த வாதுமைப் பூக்களைப் போல செய்யப்பட்டன. ");
INSERT INTO tam2008_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","தண்டின் இருபுறங்களிலுமிருந்து மூன்று கிளைகள் வீதம் ஆறு கிளைகள் இருந்தன. கிளைகள் தண்டோடு இணைந்த மூன்று இடங்களுக்கும் கீழே மொட்டுகளோடும் இதழ்களோடும் கூடிய ஒவ்வொரு பூ இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","பூக்களும் கிளைகளும் கொண்ட வேலைப்பாடுகள் உடைய அந்தக் குத்துவிளக்கு முழுவதும் பொன்னால் ஆனதாக இருந்தது. இந்தப் பொன் சுத்தியால் அடிக்கப்பட்டு ஒன்றாக இணைக்கப்பட்டிருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","இந்தக் குத்துவிளக்கிற்கு ஏழு அகல்களை அவன் செய்தான். பின் அவன் திரி கத்தரிக்கும் கருவிகளையும், சாம்பல் கிண்ணங்களையும் பொன்னால் செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","குத்து விளக்கையும் அதற்குத் தேவையான பொருட்களையும் செய்வதற்கு அவன் 75 பவுண்டு எடையுள்ள சுத்தமான பொன்னைப் பயன்படுத்தினான். ");
INSERT INTO tam2008_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","நறுமணப் பொருள்களை எரிக்கும்படியான பீடத்தையும் அவன் செய்தான். சீத்திம் மரத்தால் இதைச் செய்தான். பீடம் சதுரவடிவமானது. அது 1 முழ நீளமும் 1 முழ அகலமும் 2 முழ உயரமுமாக இருந்தது. நறுமணப் பீடத்தில் நான்கு கொம்புகள் ஒவ்வொரு மூலையிலும் ஒன்வொன்றாக இருந்தன. இவை நறுமணப் பீடத்தோடு ஒன்றாக அடிக்கப்பட்டன. ");
INSERT INTO tam2008_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","நறுமணப் பீடத்தின் மேல்புறம், பக்கங்கள், கொம்புகள் ஆகியவற்றை அவன் பசும்பொன்னால் மூடினான். பின்பு அவன் நறுமணப் பீடத்தைச் சுற்றிலும் பொன் சட்டத்தை இணைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","நறுமணப் பீடத்திற்கு இரண்டு பொன் வளையங்கள் செய்தான். அதன் ஒவ்வொரு பக்கத்திலும் பொன் தகட்டிற்கு அடியில் சேரும்படி பொன் வளையங் களைப் பொருத்தினான். நறுமணப் பீடத்தைத் தூக்கிச் செல்லும்போது, தண்டைக் கோர்க்கும்படி இந்தத் தங்க வளையங்கள் இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","அவன் சீத்திம் மரத்தினாலான தண்டுகளைச் செய்து அவற்றையும் பொன்னால் மூடினான். ");
INSERT INTO tam2008_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","பிறகு அவன் பரிசுத்த அபிஷேக எண்ணெயைத் தயாரித்தான். அவன் சுத்தமான நறுமணப் பொருளையும் தயாரித்தான். நறுமணத் திரவியங்களைத் தயாரிக்கும் முறையிலேயே இப்பொருட்கள் அனைத்தையும் அவன் செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","பலிபீடத்தை பெசலெயேல் சீத்திம் மரத்தால் செய்தான். இப்பலிபீடம் பலிகளை எரிப்பதற்காக பயன்படுத்தப்பட்டது. அது சதுரவடிவமானது. அது 5 முழ நீளமும் 5 முழ அகலமும் 3 முழ உயரமும் உடையது. ");
INSERT INTO tam2008_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","அவன் பலிபீடத்தின் நான்கு மூலைகளிலும் ஒவ்வொரு கொம்பைச் செய்து வைத்தான். அவற்றைப் பலிபீடத்தோடு இணைத்து ஒன்றாக அடித்தான். பின்பு பலிபீடத்தை வெண்கலத்தால் மூடினான். ");
INSERT INTO tam2008_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","பலிபீடத்தில் பயன்படுத்தப்படும் எல்லா கருவிகளையும் வெண்கலத்தால் செய்தான். பானைகள், கரண்டிகள், கிண்ணங்கள், முள்கரண்டிகள், பெரிய கொப்பரைகளையும் செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","பின்னர் பலிபீடத்திற்காக வெண்கலத்தாலான வலைப் பின்னல் போன்ற ஒரு சல்லடையை உண்டாக்கினான். பலிபீடத்தின் அடித்தட்டில் அந்தச் சல்லடையைப் பொருத்தினான். அது பலிபீடத்தின் நடுப்பகுதியில் (பாதி உயரத்தில்) பொருந்தியது. ");
INSERT INTO tam2008_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","பின் அவன் பித்தளை வளையங்களை செய்தான். பலிபீடத்தைச் சுமக்கும் தண்டுகளைத் தாங்குவதற்கு இவ்வளையங்கள் பயன்பட்டன. சல்லடையின் நான்கு மூலைகளிலும் அவன் அந்த வளையங்களை வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","பின் அவன் சீத்திம் மரத்தினால் தண்டுகளைச் செய்து அவற்றை வெண்கலத்தால் மூடினான். ");
INSERT INTO tam2008_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","பலிபீடத்தின் பக்கங்களிலுள்ள வளையங்களில் தண்டுகளைச் செலுத்தினான். தண்டுகள் பலிபீடத்தைச் சுமப்பதற்குப் பயன்பட்டன. பலிபீடத்தின் நான்கு பக்கங்களையும் சீத்திம் பலகைகளினால் செய்தான். அது வெறுமையான பெட்டியைப் போன்று உள்ளே ஒன்றுமில்லாதிருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","அவன் வெண்கலத்தாலான தொட்டிகளையும், அதன் பீடங்களையும் செய்தான். பெண்கள் கொடுத்த வெண்கல முகக் கண்ணாடிகளை அதற்குப் பயன்படுத்தினான். இந்தப் பெண்களே ஆசரிப்புக்கூடாரத்தின் நுழைவாயிலில் திருப்பணியாற்றி வந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","பின்னர் முற்றத்தைச் சுற்றி திரைச் சீலைகள் எழுப்பினான். 100 முழ நீளமுள்ள தொங்குதிரையை தெற்குப் பக்கத்தில் எழுப்பினான். மெல்லிய துகிலால் அத்திரைகள் அமைந்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","தெற்குப் பக்கத்துத் திரைகளை 20 தூண்கள் தாங்கின. அவற்றிற்கு 20 வெண்கல பீடங்கள் அமைந்தன. தூண்களுக்கான கொக்கிகளையும் திரைச் சீலைத் தண்டுகளையும் வெள்ளியால் செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","பிரகாரத்தின் வடக்குப்புறத்தில் 100 முழ நீளமான திரைச் சுவர் அமைந்தது. 20 வெண்கலப் பீடங்கள் உள்ள 20 தூண்கள் இருந்தன. தூண்களின் கொக்கிகளும், திரைப் பூண்களும் வெள்ளியால் செய்யப்பட்டன. ");
INSERT INTO tam2008_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","வெளிப்பிரகாரத்தின் மேற்குப் பக்கத்தில் 50 முழ நீளமான தொங்குதிரையை அமைத்தான். அந்த 10 தூண்களுக்கும், 10 பீடங்கள் இருந்தன. தூண்களின் கொக்கிகளையும் திரைப் பூண்களையும் வெள்ளியால் அமைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","வெளிப் பிரகாரத்தின் கிழக்குப்புறத்திலிருந்து தொங்குதிரை 50 முழ அகலம்Ԕஉடையதாக இருந்தது. பிரகாரத்தின் நுழைவாயில் இப்பக்கத்தில் இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","நுழைவாயிலின் ஒரு பக்கத்தில் தொங்கு திரை 15 முழ நீள முடையதாகவும் மூன்று பீடங்களின்மேல் நின்ற மூன்று தூண்களைக் கொண்டதாகவும் இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","நுழை வாயிலின் மறுபுறத்திலுள்ள தொங்கு திரைகள் 15 முழ நீளமுடையதாக இருந்தது. அந்தப் பக்கத்தில் மூன்று தூண்களும் அவற்றிக்கு மூன்று பீடங்களும் அமைத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","பிரகாரத்தைச் சுற்றிலும் அமைந்த தொங்கு திரைகள் மெல்லிய துகிலால் செய்யப்பட்டன. ");
INSERT INTO tam2008_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","தூண்களின் பீடங்கள் வெண்கலத்தால் செய்யப்பட்டிருந்தன. கொக்கிகளும், திரைப்பூண்களும், வெள்ளியால் செய்யப்பட்டன. தூண்களின் மேற்பகுதிகளும் வெள்ளியால் மூடப்பட்டன. பிரகாரத்தின் தூண்களில் வெள்ளியாலான திரைப்பூண்கள் இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","பிரகார நுழைவாயிலின் தொங்குதிரைகள் மெல்லிய துகிலாலும், இளநீலம், இரத்தாம்பரம், சிவப்பு நூல்களாலும் நெய்யப்பட்டன. அவற்றில் பல சித்திரங்களும் வடிவமைக்கப்பட்டிருந்தன. திரையானது 20 முழ நீளமும் 5 முழ உயரமும் உடையதாக இருந்தது. அவை பிரகாரத்தைச் சுற்றிலும் அமைந்த தொங்கு திரைகளின் உயரம் கொண்டிருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","தொங்குதிரையை நான்கு தூண்களும், வெண்கல பீடங்களும் தாங்கின. தூண்களின் கொக்கிகள் வெள்ளியால் ஆனவை ஆகும். தூண்களின் மேற்பகுதிகளும் வெள்ளியால் மூடப்பட்டன. திரைப் பூண்களும் வெள்ளியாலாயின. ");
INSERT INTO tam2008_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","பரிசுத்தக் கூடாரத்திற்கும், வெளிப்பிரகாரத்தின் திரைகளுக்கும் தேவையான கூடார ஆணிகள் வெண்கலத்தால் செய்யப்பட்டன. ");
INSERT INTO tam2008_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","உடன்படிக்கையின் கூடாரமாகிய பரிசுத்த கூடாரத்திற்குத் தேவைப்பட்ட பொருட்களை எல்லாம் லேவி குடும்பத்தார் எழுதி வைத்துக்கொள்ளும்படியாக மோசே கட்டளையிட்டான். பட்டியலைத் தயாரிக்கும் பொறுப்பை ஆரோனின் மகனாகிய இத்தாமார் ஏற்றுக்கொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","மோசேக்கு கர்த்தர் விதித்த எல்லாக் கட்டளைகளையும் யூதாவின் கோத்திரத்தின் வழியே வந்த ஊரின் மகனாகிய ஊரியின் மகன் பெசலெயேல் நிறைவேற்றினான். ");
INSERT INTO tam2008_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","தாண் கோத்திரத்தைச் சேர்ந்த அகிசாமாகின் மகனான அகோலியாப் அவனோடு ஒத்துழைத்தான். அகோலியாப் மிகச் சிறந்த சித்திரை கைவேலையாளும், நெசவில் நிபுணனும் ஆவான். மெல்லிய துகிலை நெய்வதிலும், இளநீலம், இரத்தாம்பரம், சிவப்பு நூலை நெய்வதிலும் அவன் தலைசிறந்தவனாக இருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","கர்த்தரின் பரிசுத்த இடத்திற்கு 2 டன்கள் எடைக்கு மேற்பட்ட பொன் காணிக்கையாக அளிக்கப்பட்டது. (அதிகாரப் பூர்வமான அளவு எடையின்படி அது எடையிடப்பட்டது.) ");
INSERT INTO tam2008_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","எண்ணிக்கை எடுக்கப்பட்ட மனிதர்கள் அனைவரும் 3 3/4 டன்கள் வெள்ளி கொடுத்தனர். (இதுவும் அதிகாரப்பூர்வமான அளவின் தராசில் நிறுக்கப்பட்டது) ");
INSERT INTO tam2008_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","இருபதும் அதற்கு மேற்பட்ட வயதுமுடைய ஆண்கள் எண்ணப்பட்டனர். 6,03,550 ஆண்கள் இருந்தனர். ஒவ்வொருவனும் 1 பெக்கா வெள்ளியை வரியாக அளித்தான். (அதிகாரப்பூர்வமான அளவின்படி 1 பெக்கா என்பது 1/2 சேக்கல் எடை அளவாகும்.) ");
INSERT INTO tam2008_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","கர்த்தரின் பரிசுத்த இடத்தின் தொங்கு திரைகளுக்கும் 100 பீடங்களை உண்டாக்குவதற்கு அந்த 3 3/4 டன்கள் வெள்ளியைப் பயன்படுத்தினார்கள். ஒவ்வொரு பீடத்திற்கும் சுமார் 75 பவுண்டு வெள்ளி வீதம் உபயோகப்படுத்தப்பட்டது. ");
INSERT INTO tam2008_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","மீதமுள்ள 50 பவுண்டு வெள்ளியால் கொக்கிகளையும், திரைப்பூண்களையும், தூண்களின் வெள்ளிப் பூச்சையும் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","கர்த்தருக்கு 26 1/2 டன்களுக்கும் அதிகமான வெண்கலம் தரப்பட்டது. ");
INSERT INTO tam2008_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ஆசாரிப்புக் கூடாரத்தின் நுழைவாயிலின் பீடங்களைச் செய்வதற்கு அது பயன்பட்டது. பீடத்தையும், சல்லடையையும் செய்வதற்கும் வெண்கலத்தைப் பயன்படுத்தினர். பலிபீடத்தின் எல்லாக் கருவிகளையும், பாத்திரங்களையும் செய்வதற்கு வெண்கலம் பயன்படுத்தப்பட்டது. ");
INSERT INTO tam2008_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","பிரகாரத்தைச் சுற்றிலுமுள்ள தொங்கு திரைகளின் பீடங்களையும், நுழைவாயிலில் உள்ள தொங்கு திரைகளின் பீடங்களையும் அமைப்பதற்கு வெண்கலம் பயன்படுத்தப்பட்டது. வெண்கலத்தால் பரிசுத்தக்கூடாரத்திற்கும், வெளிப்பிரகாரத்தின் தொங்கு திரைகளுக்கும் தேவையான கூடார ஆணிகளைச் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","கர்த்தரின் பரிசுத்தக் கூடாரத்திற்கு வரும்போது ஆசாரியர் அணிய வேண்டிய விசேஷ ஆடைகளை நெய்வதற்கு இளநீலம், இரத்தாம்பரம், சிவப்புநிற நூலை சித்திர வேலையாட்கள் பயன்படுத்தினார்கள். கர்த்தர் மோசேக்குக் கட்டளையிட்டபடி அவர்கள் ஆரோனுக்கு விசேஷ ஆடைகளைத் தயாரித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","பொன் ஜரிகை, மெல்லிய துகில், இள நீலம், இரத்தாம்பரம், சிவப்புநிற நூல் ஆகியவற்றால் ஏபோத்தைச் செய்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","(அவர்கள் பொன்னை மெல்லிய நாடாவாக அடித்து பொன் ஜரிகைகளை வெட்டினார்கள். இந்தப் பொன் ஜரிகையை இளநீலம், இரத்தாம்பரம், சிவப்பு நூலிலும், மெல்லிய துகிலுடனும் சேர்த்து நெய்தார்கள். இது சிறந்த சித்திரக்காரனின் கைவேலையாக இருந்தது). ");
INSERT INTO tam2008_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","அவர்கள் ஏபோத்தின் தோள் பட்டைகளைச் செய்தார்கள். ஏபோத்தின் இரண்டு மூலைகளிலும் அந்தத் தோள் பட்டைகளை இணைத்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","அவர்கள் கச்சையை ஏபோத்தோடு இணைத்தார்கள். ஏபோத்தைப் போலவே இதுவும் செய்யப்பட்டது. அவர்கள் பொன் ஜரிகை, மெல்லிய துகில், இளநீலம், இரத்தாம்பரம், சிவப்பு நூல் ஆகியவற்றைப் பயன்படுத்தி, கர்த்தர் மோசேக்குக் கட்டளையிட்டபடியே செய்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","கைவேலைக்காரர் ஏபோத்துக்கு இரண்டு கோமேதகக் கற்களை தங்கச்சட்டத்தில் பதித்தனர். அக்கற்களின்மீது இஸ்ரவேலின் பன்னிரண்டு மகன்களின் பெயர்களைப் பதித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","பின் அவர்கள் அதனை ஏபோத்தின் தோள்பட்டைகளோடு இணைத்தனர். இஸ்ரவேல் ஜனங்களை தேவன் நினைவு கூருவதற்காக இந்தக் கற்கள் பயன்பட்டன. மோசேக்கு கர்த்தர் கட்டளையிட்டபடியே இதைச் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","பின் அவர்கள் நியாயத்தீர்ப்பு மார்ப்பதக்கத்தை செய்தனர். ஏபோத்தைச் செய்தது போலவே, இதுவும் கைத்தேர்ந்த சித்திர வேலையாக இருந்தது. அது பொன் ஜரிகை, மெல்லிய துகில், இளநீலம், இரத்தாம்பரம், சிவப்புநிற நூலால் நெய்யப்பட்டன. ");
INSERT INTO tam2008_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","நியாயத்தீர்ப்பு மார்ப்பதக்கத்தை இரண்டாக மடித்து சதுரவடிவில் அமைத்தனர். இது 9 அங்குல நீளமும் 9 அங்குல அகலமும் உடையதாக இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","சித்திரவேலையாட்கள் நியாயத்தீர்ப்பு மார்ப்பதக்கத்தில் 4 வரிசை விலையுயர்ந்த கற்களைப் பதித்தனர். முதல் வரிசையில் பத்மராகமும், புஷ்பராகமும், மாணிக்கமும் இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","இரண்டாம் வரிசையில் மரகதமும், இந்திர நீலக் கல்லும், வச்சிரமும் காணப்பட்டன. ");
INSERT INTO tam2008_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","மூன்றாம் வரிசையில் கெம்பும், வைடூரியமும், சுகந்தியும் இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","நாலாம் வரிசையில் படிகப் பச்சையும், கோமேதகமும், யஸ்பியும் காணப்பட்டன. இந்தக் கற்கள் அனைத்தும் பொன்னில் பூட்டப்பட்டிருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","நியாயத்தீர்ப்பு மார்ப்பதக்கத்தில் இஸ்ரவேலின் (யாக்கோபின்) ஒவ்வொரு மகனுக்கும் ஒவ்வொரு கல் வீதம் பன்னிரண்டு கற்கள் இருந்தன. ஒவ்வொரு கல்லிலும் முத்திரையைப் போன்று இஸ்ரவேலின் மகன்கள் ஒவ்வொருவரின் பெயரும் பொறிக்கபட்டிருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","நியாயத்தீர்ப்பு மார்ப்பதக்கத்திற்காக சித்திர வேலைக்காரர் பசும்பொன்னால் இரண்டு சங்கிலிகளைச் செய்தார்கள். அச்சங்கிலிகள் கயிறுகளைப் போல் பின்னப்பட்டிருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","சித்திர வேலைக்காரர் இரண்டு பொன் வளையங்களைச் செய்து, அவற்றை நியாயத்தீர்ப்பு மார்ப்பதக்கத்தின் இரண்டு மூலைகளிலும் இணைத்தனர். தோள்பட்டைகளுக்கு பூட்டும்படி இரண்டு பொன் வளையங்களைச் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","அவர்கள் பொன் சங்கிலிகளை நியாயத்தீர்ப்பு மார்ப்பதக்கத்தின் மூலைகளிலிருந்த வளையங்களில் இணைத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","தோள்பட்டைகளின் பொன்வளையங்களில் பொன் சங்கிலிகளின் மறுமுனைகளை இணைத்தனர். இவற்றை அவர்கள் ஏபோத்தின் முன்புறத்தில் சேர்த்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","பின்பு அவர்கள் மேலும் இரண்டு பொன் வளையங்களைச் செய்து அவற்றை நியாயத்தீர்ப்பு மார்ப்பதக்கத்தின் மற்ற இரண்டு மூலைகளிலும் தைத்தனர். ஏபோத்தை அடுத்து நியாயத்தீர்ப்பு மார்ப்பதக்கத்தின் உட்புறத்தில் இது இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","ஏபோத்தின் முன்புறத்தில் தோள்பட்டைகளின் கீழே இரண்டு பொன் வளையங்களை தைத்தனர். கச்சைக்கு மேலே ஏபோத்தின் இணைப்புக்கருகே இவ்வளையங்கள் இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","பின் அவர்கள் நீல நிற நாடாவையும், நியாயத்தீர்ப்பு மார்ப்பதக்கத்தின் வளையங்களையும் ஏபோத்தின் வளையங்களோடு கட்டினார்கள். இவ்விதமாக நியாயத்தீர்ப்பு மார்ப்பதக்கம் கச்சைக்கு அருகில் ஏபோத்துக்கு இணையாக இருக்கும்படி இழுத்துக் கட்டப்பட்டது. கர்த்தர் கட்டளையிட்டபடி அவர்கள் எல்லாவற்றையும் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","பின் அவர்கள் ஏபோத்திற்காக ஒரு அங்கியை நெய்தனர். இளநீல துணியால் அதைச் செய்தார்கள். அது சிறந்த சித்திரத் தையல்காரனால் நெய்யப்பட்டது. ");
INSERT INTO tam2008_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","அங்கியின் மத்தியில் ஒரு துளையை அவர்கள் உண்டு பண்ணி, அந்தத் துவாரத்தின் விளிம்பைச் சுற்றிலும் ஒரு துண்டுத் துணியைத் தைத்தனர். துவாரம் கிழிந்து போகாதபடி அது பாதுகாத்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","பின் அவர்கள் மெல்லிய துகில், இளநீலம், இரத் தாம்பரம், சிவப்பு நிற நூலைக் கொண்டு துணியாலான மாதுளம் பழங்களை உண்டாக்கினார்கள். அங்கியின் கீழ்த்தொங்கலில் இந்த மாதுளம் பழங்களைத் தைத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","பின்பு பசும் பொன்னால் மணிகளை உண்டாக்கினார்கள். அவற்றை அங்கியின் கீழ்த்தொங்கலில் மாதுளம் பழங்களுக்கு இடையே தொங்கவிட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","அங்கியின் கீழ்த் தொங்கலைச் சுற்றிலும் மாதுளம் பழங்களும், பொன்மணிகளும் இருந்தன. மாதுளம் பழங்களுக்கு இடையில் ஒரு பொன்மணி இருந்தது. மோசேக்குக் கர்த்தர் கட்டளையிட்டபடியே, கர்த்தருக்கு பணிவிடை செய்யும்போது ஆசாரியன் அணியும் அங்கியாக இது இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","ஆரோனுக்கும் அவனது மகன்களுக்கும் சட்டைகளை கைவேலைக்காரர் நெய்தனர். இவை மெல்லிய துகிலால் நெய்யப்பட்டன. ");
INSERT INTO tam2008_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","மெல்லிய துகிலிலிருந்து கை வேலையாட்கள் ஒவ்வொரு தலைப்பாகையையும் நெய்தனர். உள் ஆடைகளையும் நெற்றிப்பட்டைகளையும் மெல்லிய துகிலிலிருந்து செய்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","மெல்லிய துகில், இளநீலம், இரத்தாம்பரம், சிவப்புநிற நூலிலிருந்து கச்சையைச் செய்தனர். ஆடையில் சித்திர வேலைப்பாடுகள் செய்யப்பட்டன. மோசேக்குக் கர்த்தர் கட்டளையிட்டபடியே இவை அனைத்தும் தைக்கப்பட்டன. ");
INSERT INTO tam2008_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","பின் பரிசுத்தக் கிரீடத்திற்குரிய நெற்றிப்பட்டையைத் தயாரித்தனர். சுத்தப் பொன்னால் அதைச் செய்தனர். அந்தப் பொன் தகட்டில் “கர்த்தருக்குப் பரிசுத்தம்” என்ற வார்த்தைகளைப் பதித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","பொன் பட்டையை நீல நாடாவில் இணைத்தனர். மோசேக்குக் கர்த்தர் இட்ட கட்டளைப்படியே இந்த நீல நாடாவை தலைப்பாகையோடு இணைத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","இவ்வாறு பரிசுத்தக் கூடாரத்தின் (அதாவது ஆசாரிப்புக் கூடாரத்தின்) எல்லா வேலைகளும் செய்து முடிக்கப்பட்டன. கர்த்தர் மோசேக்குக் கட்டளையிட்டபடியே இஸ்ரவேல் ஜனங்கள் ஒவ்வொன்றையும் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","பின் அவர்கள் மோசேக்குப் பரிசுத்தக் கூடாரத்தையும், அதிலுள்ள எல்லாப் பொருட்களையும் காட்டினார்கள். வளையங்கள், சட்டங்கள், தாழ்ப்பாள்கள், தூண்கள், பீடங்கள் ஆகியவற்றை அவனுக்குக் காட்டினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","சிவப்புச் சாயம் தோய்த்த ஆட்டுக்கடாவின் தோலால் கூடாரம் மூடப்பட்டிருந்ததைக் காட்டினார்கள். அதன் கீழ் பதனிடப்பட்ட மெல்லிய தோலாலாகிய மூடியையும் காட்டினார்கள். மகா பரிசுத்தக் கூடாரத்தின் நுழைவாயிலை மூடிய திரைச் சீலையயும் அவர்கள் அவனுக்குக் காட்டினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","அவர்கள் மோசேக்கு உடன்படிக்கைப் பெட்டியைக் காட்டினார்கள். பெட்டியைச் சுமக்கும் தண்டுகளையும், பெட்டியின் மூடியையும் காண்பித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","மேசையை அதனுடன் சேர்ந்த பொருட்களோடும், விசேஷ ரொட்டியோடும் காட்டினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","அவர்கள் அவனுக்குப் பசும் பொன்னால் செய்யப்பட்ட குத்துவிளக்குத் தண்டையும் அதன் அகல்களையும் காட்டினார்கள். அகலுக்குப் பயன்படுத்தவேண்டிய எண்ணெயையும் பிற பொருட்களையும் காண்பித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","பொன் நறுமணப்பீடம், அபிஷேக எண்ணெய், நறுமணப்பொருள், கூடாரத்தை மூடிய தொங்குதிரை ஆகியவற்றையும் அவர்கள் மோசேக்குக் காட்டினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","வெண்கல பலிபீடத்தையும், வெண்கல சல்லடையையும் அவனுக்குக் காட்டினார்கள். பலிபீடத்தைச் சுமக்கும் தண்டுகளையும் காட்டினார்கள். பலிபீடத்தின் பொருட்களையும் காண்பித்தனர். வெண்கலத் தொட்டியையும் அதன் பீடத்தையும் அவனுக்குக் காட்டினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","பின்பு தூண்களோடும் அவற்றின் பீடங்களோடும் கூடிய வெளிப்பிரகாரத்தைச் சுற்றிலும் காணப்பட்ட தொங்கு திரைகளை அவர்கள் மோசேக்குக் காட்டினார்கள். பிரகாரத்தின் நுழை வாயிலில் இருந்த திரையைக் காண்பித்தனர். கயிறுகளையும், கூடார ஆணிகளையும் காட்டினார்கள். பரிசுத்த கூடாரத்தின் அதாவது ஆசரிப்புக் கூடாரத்தின் எல்லாப் பொருட்களையும் அவர்கள் அவனுக்குக் காட்டினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","பரிசுத்த பிரகாரங்களில் பணிவிடை செய்யும் ஆசாரியர்களுக்கான ஆடைகளை அவர்கள் மோசேக்குக் காட்டினார்கள். ஆசாரியனான ஆரோனுக்கும், அவனது மகன்களுக்கும் தைக்கப்பட்ட விசேஷ ஆடைகளைக் காட்டினார்கள். அவர்கள் ஆசாரியர்களாகப் பணிவிடை செய்யும்போது அணிய வேண்டிய ஆடைகள் இவையாகும். ");
INSERT INTO tam2008_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","கர்த்தர் மோசேக்குக் கட்டளையிட்டபடியே இஸ்ரவேல் ஜனங்கள் இந்த வேலைகளை எல்லாம் செய்திருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","மோசே எல்லா வேலைகளையும் கூர்ந்து கவனித்தான். கர்த்தர் கட்டளையிட்டபடியே எல்லா வேலைகளும் நிறைவேற்றப்பட்டதைக் கண்டான். எனவே மோசே அவர்களை ஆசீர்வதித்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","பின்பு கர்த்தர் மோசேயை நோக்கி, ");
INSERT INTO tam2008_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“முதல் மாதத்தின் முதல் நாளில் பரிசுத்தக் கூடாரத்தை, அதாவது ஆசாரிப்புக் கூடாரத்தை எழுப்பு. ");
INSERT INTO tam2008_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","பரிசுத்தக் கூடாரத்தில் உடன்படிக்கைப் பெட்டியை வைத்துப் பெட்டியைத் திரையால் மூடு. ");
INSERT INTO tam2008_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","பிறகு மேசையை உள்ளே கொண்டு வா. மேசையின் மேல் வைக்க வேண்டிய பொருட்களை வை. பின்பு கூடாரத்தில் குத்து விளக்குத் தண்டை வை. சரியான இடங்களில் குத்து விளக்கின் அகல்களை வை. ");
INSERT INTO tam2008_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","கூடாரத்தில் நறுமணப் பொருட்களின் காணிக்கையைப் படைக்க பொன்னாலான நறுமணப் பீடத்தை வை. உடன்படிக்கைப் பெட்டியின் முன்புறத்தில் நறுமணப்பீடத்தை வை. அதன்பின் பரிசுத்தக் கூடாரத்தின் நுழை வாயிலில் திரைகளை இடு. ");
INSERT INTO tam2008_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“பரிசுத்தக் கூடாரத்தின், அதாவது ஆசாரிப்புக் கூடாரத்தின் நுழைவாயிலின் முன்பு தகனபலிக்கான பலிபீடத்தை வை. ");
INSERT INTO tam2008_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ஆசாரிப்புக் கூடாரத்திற்கும், பலிபீடத்திற்கும் இடையே தொட்டியை வை. தொட்டியில் தண்ணீர் ஊற்றி வை. ");
INSERT INTO tam2008_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","வெளிப் பிரகாரத்தைச் சுற்றிலும் திரைச் சீலைகளைத் தொங்கவிடு. பிரகாரத்தின் நுழைவாயில் திரையை அதன் ஸ்தானத்தில் தொங்கவிடு. ");
INSERT INTO tam2008_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“பின்பு அபிஷேக எண்ணெயை எடுத்து பரிசுத்தக் கூடாரத்தையும் அதிலுள்ள எல்லாப் பொருட்களையும் அபிஷேகம் செய். எண்ணெயை இப்பொருட்களின் மேல் ஊற்றும்போது அவை பரிசுத்தமாகும். ");
INSERT INTO tam2008_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","தகனபலிக்கான பலிபீடத்தையும் அதிலுள்ள எல்லாவற்றையும் அபிஷேகம் செய்து, பலிபீடத்தை பரிசுத்தமாக்கு. அது மிகவும் பரிசுத்தமானதாகும். ");
INSERT INTO tam2008_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","பின் தொட்டியையும், அதன் அடித்தளத்தையும் அபிஷேகம் செய். அப்பொருட்கள் பரிசுத்தமாவதற்கு இவ்வாறு செய். ");
INSERT INTO tam2008_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“ஆரோனையும், அவனது மகன்களையும் ஆசாரிப்புக் கூடாரத்தின் நுழைவாயிலுக்கு அழைத்து வா. அவர்களைத் தண்ணீரால் கழுவு. ");
INSERT INTO tam2008_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","பிறகு ஆரோனுக்கு விசேஷ ஆடைகளை உடுத்தி எண்ணெயால் அபிஷேகம் செய்து அவனைப் பரிசுத்தப்படுத்து. அப்போது அவன் ஆசாரியனாகப் பணியாற்ற முடியும். ");
INSERT INTO tam2008_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","பின் அவனது மகன்களுக்கும் ஆடைகளை அணி வித்துவிடு. ");
INSERT INTO tam2008_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","அவர்களது தந்தைக்கு செய்தபடியே அவர்கள் மேலும் எண்ணெயை ஊற்றி அவர்களையும் பரிசுத்தப்படுத்து. அப்போது அவர்களும் ஆசாரியப் பணிவிடை செய்யமுடியும். அவர்கள்மேல் அபிஷேக எண்ணெயை ஊற்றும்போது, அவர்கள் ஆசாரியர் ஆவார்கள். வரும் காலங்களில் எல்லாம் அவர்கள் குடும்பத்தினர் ஆசாரியர்களாகவே இருப்பார்கள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","மோசே கர்த்தர் கூறியபடியெல்லாம் செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","எனவே, ஏற்ற காலத்தில் பரிசுத்தக் கூடாரம் எழுப்பப்பட்டது. எகிப்தைவிட்டுப் புறப்பட்ட இரண்டாம் வருடத்தின் முதல் மாதம் முதல் தேதியன்று ");
INSERT INTO tam2008_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","கர்த்தர் கூறியபடியே மோசே பரிசுத்த கூடாரத்தை நிறுவினான். முதலில் பீடங்களை வைத்தான். பிறகு பீடங்களின்மீது சட்டங்களை பொருத்தினான். பின்பு தாழ்ப்பாள்களை வைத்து, தூண்களை நிறுவினான். ");
INSERT INTO tam2008_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","அதன் பிறகு மோசே பரிசுத்தக் கூடாரத்திற்கு மேல் வெளிக் கூடாரத்தை அமைத்தான். பிறகு பரிசுத்தக் கூடாரத்தின் மேல் மூடியை அமைத்தான். கர்த்தர் கட்டளையிட்டபடியே இவற்றையெல்லாம் செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","மோசே உடன்படிக்கையை எடுத்து அதை பரிசுத்தப் பெட்டியில் வைத்தான். மோசே பெட்டியின்மீது தண்டுகளை வைத்து பெட்டியின் மூடியை பொருத்தினான். ");
INSERT INTO tam2008_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","பின்பு மோசே பரிசுத்தப் பெட்டியை பரிசுத்தக் கூடாரத்தில் வைத்தான். அதைப் பாதுகாப்பதற்காக தொங்கு திரையை அதற்குரிய இடத்தில் தொங்கவிட்டான். இவ்வாறு அவன் கர்த்தர் கட்டளையிட்டபடியே தொங்கு திரைகளுக்குப் பின்னே உடன் படிக்கைப் பெட்டியை வைத்து பாதுகாத்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","பிறகு மோசே ஆசாரிப்புக் கூடாரத்தில் மேசையை வைத்தான். அதைக் கூடாரத்தின் வடக்குத் திசையில் இருந்த பரிசுத்தக் கூடாரத்தில் திரைகளுக்கு முன்னே வைத் தான். ");
INSERT INTO tam2008_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","பிறகு கர்த்தருக்கு முன்னே மேசை யின்மீது பரிசுத்த அப்பத்தை வைத்தான். கர்த்தர் சொன்னபடியே அவன் இதைச் செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","பிறகு மோசே ஆசாரிப்புக் கூடாரத்தில் குத்துவிளக்குத் தண்டை வைத்தான். கூடாரத்தின் தெற்குப் பகுதியில் மேசைக்கு எதிராக அதனை வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","அதன் பின் மோசே கர்த்தருக்கு முன் இருந்த விளக்குத் தண்டில் அகல்களை வைத்தான். கர்த்தர் கட்டளையிட்டபடியே இதைச் செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","பின்பு மோசே ஆசாரிப்புக் கூடாரத்தில் பொன் நறுமணப்பீடத்தை திரைக்கு முன்னால் நிறுவினான். ");
INSERT INTO tam2008_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","பின் நறுமணப் பீடத்தில் சுகந்தவாசனையுள்ள நறுமணப் பொருள்களை எரித்தான். கர்த்தர் கட்டளையிட்டபடியே அவன் இதனையும் செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","பிறகு மோசே பரிசுத்தக் கூடாரத்தின் நுழைவாயிலில் தொங்குதிரையை தொங்கவிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","பரிசுத்தக் கூடாரம், அதாவது ஆசாரிப்புக் கூடாரத்தின் நுழை வாயிலில் தகன பலிக்கான பலி பீடத்தை மோசே வைத்தான். பின் மோசே அந்தப் பலிபீடத்தின் மேல் ஒரு தகன பலியைச் செலுத்தினான். தானிய காணிக்கைகளையும் கர்த்தருக்குச் செலுத்தினான். கர்த்தர் கட்டளையிட்டபடியே அவன் இக்காரியங்களைச் செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","பின்பு ஆசாரிப்புக் கூடாரத்திற்கும், பலி பீடத்திற்கும் மத்தியில் மோசே தொட்டியை வைத்தான். கழுவுவதற்கான தண்ணீரை மோசே, தொட்டியில் நிரப்பினான். ");
INSERT INTO tam2008_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","மோசே, ஆரோன், ஆரோனின் மகன்கள் ஆகியோர் தங்கள் கைகளையும், கால்களையும் கழுவுவதற்கு இந்தத் தொட்டியைப் பயன்படுத்தினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","அவர்கள் ஆசாரிப்புக் கூடாரத்தில் நுழையும்போதெல்லாம் தங்களைக் கழுவிக்கொண்டனர். பலிபீடத்தின் அருகே செல்லும்போதெல்லாம் அவர்கள் தங்கள் கை, கால்களைக் கழுவிக்கொண்டனர். மோசேக்குக் கர்த்தர் கட்டளையிட்டபடியே அவர்கள் இக்காரியங்களைச் செய்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","பின்பு மோசே பரிசுத்தக் கூடாரத்தின் வெளிப் பிரகாரத்தைச் சுற்றிலும் திரைகளைத் தொங்கவிட்டான். மோசே பலி பீடத்தை வெளிப்பிரகாரத்தில் வைத்தான். வெளிப்பிரகாரத்தின் நுழைவாயிலில் திரைச் சீலைகளைத் தொங்கவிட்டான். கர்த்தர் செய்யுமாறு கூறிய எல்லா வேலைகளையும் மோசே செய்து முடித்தான். ");
INSERT INTO tam2008_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","அப்போது ஆசாரிப்புக் கூடாரத்தை மேகம் வந்து மறைத்துக்கொண்டது. கர்த்தரின் மகிமை பரிசுத்தக் கூடாரத்தை நிரப்பியது. ");
INSERT INTO tam2008_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","ஆசாரிப்புக் கூடாரத்திற்குள் மோசே செல்ல முடியவில்லை. ஏனெனில், மேகம் அதன் மீது மூடியிருந்தது. மேலும் கர்த்தரின் மகிமை பரிசுத்தக் கூடாரத்தை நிரப்பியிருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","இந்த மேகமே ஜனங்கள் புறப்பட வேண்டிய நேரத்தை உணர்த்தி வந்தது. பரிசுத்தக் கூடாரத்திலிருந்து மேகம் எழும்பிய போது, இஸ்ரவேல் ஜனங்கள் பயணத்தைத் தொடங்கினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ஆனால் பரிசுத்தக் கூடாரத்தில் மேகம் மூடியிருந்த போது ஜனங்கள் பயணத்தைத் தொடர முயலவில்லை. மேகம் கிளம்பும் வரையிலும் அவர்கள் அவ்விடத்திலேயே தங்கினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","எனவே பகலில் கர்த்தரின் மேகம் பரிசுத்தக் கூடாரத்தின் மீது இருந்தது. இரவில் மேகத்தில் நெருப்பு காணப்பட்டது. எனவே இஸ்ரவேல் ஜனங்கள் பிரயாணத்தின் போதெல்லாம் மேகத்தைப் பார்க்க முடிந்தது. ");
INSERT INTO tam2008_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","தேவனாகிய கர்த்தர் மோசேயைக் கூப்பிட்டு ஆசாரிப்புக் கூடாரத்திலிருந்து அவனிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“நீ இஸ்ரவேல் ஜனங்களிடம் கூற வேண்டியதாவது: நீங்கள் கர்த்தருக்குப் பலி செலுத்த வரும்பொழுது அப்பலி உங்கள் மந்தையில் உள்ள பசுவாகவோ, ஆடாகவோ அல்லது வெள்ளாடாகவோ இருக்கலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ஒருவன் தனக்குச் சொந்தமான மாடுகளில் ஒன்றைத் தகனபலியாகச் செலுத்த விரும்பினால் அது எவ்விதமான குறையுமற்ற காளையாக இருக்க வேண்டும். அந்தக் காளையை அவன் ஆசாரிப்புக் கூடார வாசலுக்குக் கொண்டு வர வேண்டும். பிறகு கர்த்தர் அதனை ஏற்றுக்கொள்வார். ");
INSERT INTO tam2008_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","அம்மிருகம் பலியிடப்படும்போது அவன் அதன் தலையில் தன் கைகளை வைக்க வேண்டும். அந்த மனிதன் பரிசுத்தம் அடைவதற்கான விலையாகக் கர்த்தர் அதனை ஏற்றுக்கொள்வார். ");
INSERT INTO tam2008_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","“அவன் அந்த இளம் காளையை கர்த்தருக்கு முன்பாகக் கொல்ல வேண்டும். பிறகு ஆரோனின் மகன்களாகிய ஆசாரியர்கள் அதன் இரத்தத்தை எடுத்து ஆசரிப்புக் கூடாரத்தின் வாசலில் உள்ள பலிபீடத்தின் மேலும், அதைச் சுற்றிலும் தெளிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","அம்மிருகத்தின் தோலை வெட்டிய பிறகு ஆசாரியன் மிருகத்தை துண்டு துண்டாக வெட்டவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","ஆரோனின் மகன்களாகிய ஆசாரியர்கள் பலிபீடத்தில் நெருப்பிட்டு கட்டைகளை அடுக்கி ");
INSERT INTO tam2008_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","துண்டுகளை (மிருகத்தின் தலையையும் கொழுப்பையும்) பலிபீடத்தின் மேலுள்ள நெருப்பிலுள்ள கட்டைகளின்மேல் அடுக்கி வைக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","பின் அதன் கால்களையும் உட்பகுதிகளையும் தண்ணீரால் கழுவவேண்டும். அதன் அனைத்துப் பகுதிகளையும் பலிபீடத்தின் மேல் நெருப்பில் எரிக்க வேண்டும். இது நெருப்பாலான தகனபலி. இதன் வாசனை கர்த்தருக்கு விருப்பமானதாக இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ஒருவன் தன் ஆட்டு மந்தையிலிருந்து ஒரு வெள்ளாட்டையோ அல்லது செம்மறியாட்டையோ நெருப்பிலிட்டு தகன பலியிட விரும்பினால் அது ஆண் மிருகமாக இருக்க வேண்டும். அதில் எவ்விதக் குறைபாடும் இருக்கக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","அதனைக் கர்த்தருக்கு முன்பு பலி பீடத்தின் வடக்குத் திசையில் வைத்துக் கொல்லவேண்டும். ஆரோனின் மகன்களாகிய ஆசாரியர்கள் அதன் இரத்தத்தைப் பலிபீடத்தின் மேல் சுற்றிலும் தெளிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","பிறகு அம்மிருகத்தை ஆசாரியன் வெட்டித் துண்டாக்க வேண்டும். அவன் அந்தத் துண்டுகளை (தலை மற்றும் கொழுப்பு) பலிபீடத்திலுள்ள நெருப்பின் மேலுள்ள கட்டைகளின் மேல் வைக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","அதன் கால்களையும், உட்பாகத்தையும் ஆசாரியர்கள் தண்ணீரால் கழுவ வேண்டும். பிறகு துண்டாக வெட்டப்பட்ட மிருகத்தின் எல்லா பாகங்களையும் பலிபீடத்தில் வைத்து எரிக்க வேண்டும். இது நெருப்பால் செய்யப்படுகிற தகனபலி. இதன் வாசனை கர்த்தருக்கு விருப்பமானதாக இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“எவராவது ஒரு பறவையைக் கர்த்தருக்குப் பலியிட விரும்பினால் புறாவையாவது, இளம் புறாக்குஞ்சையாவது தேர்ந்தெடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","ஆசாரியன் அதனைப் பலிபீடத்திற்கு கொண்டு வந்து, அதன் தலையை கிள்ளி பலிபீடத்தில் எரிக்க வேண்டும். அப்பறவையின் இரத்தம் பலிபீடத்தின் பக்கத்தில் சிந்த வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","ஆசாரியன் அப்பறவையின் இரைப்பையையும், முடிகளையும் அகற்றி பலிபீடத்தின் கிழக்குப் பக்கமாக எறிய வேண்டும். அங்கேதான் பலிபீடத்தின் சாம்பலைப் போடுவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","ஆசாரியன் அதன் சிறகுகளை இரண்டாகப் பிளந்துவிடாமல் கவனமுடன் கிழிக்க வேண்டும். பிறகு அப்பறவையைப் பலிபீடத்தில் கட்டைகளின் மேல் வைத்து எரிக்க வேண்டும். இது நெருப்பினால் செய்யப்படுகிற தகன பலி. இதன் வாசனை கர்த்தருக்கு விருப்பமானதாக இருக்கும்.” ");
INSERT INTO tam2008_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ஒருவன் தேவனாகிய கர்த்தருக்கு தானியத்தைக் காணிக்கையாகக் கொடுக்க விரும்பினால், அவன் மிருதுவான மாவைப் பயன்படுத்த வேண்டும். அந்த மாவில் எண்ணெய் ஊற்றி அதன்மேல் சாம்பிராணியைப் போடவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","பிறகு அதை ஆரோனின் மகன்களாகிய ஆசாரியர்களிடம் கொண்டு வரவேண்டும். எண்ணெயும் தூபவர்க்கமும் கலந்த அந்த மிருதுவான மாவில் இருந்து ஆசாரியன் கைப்பிடியளவு எடுத்து, பலிபீடத்தில் வைத்து அதனை எரிக்க வேண்டும். இது நெருப்பினால் செய்யப்படுகிற காணிக்கை ஆகும். இதன் வாசனை கர்த்தருக்குப் பிடித்தமானதாக இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","மிஞ்சின தானியமானது ஆரோனுக்கும், அவன் மகன்களுக்கும் சொந்தமாகும். கர்த்தருக்காக செய்யப்படுகிற இந்த தகன பலியானது மிகவும் பரிசுத்தமானது. ");
INSERT INTO tam2008_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ஒருவன் அடுப்பில் வேகவைத்த தானியப் பொருட்களை காணிக்கை செலுத்த விரும்பினால் அது புளிப்பில்லா அப்பமாக இருக்க வேண்டும். அதுவும் மிருதுவான மாவை எண்ணெயிலே பிசைந்து செய்யப்பட்டிருக்க வேண்டும். அல்லது எண்ணெய் பூசப்பட்ட புளிப்பில்லா அப்பங்களாக இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","தட்டையான சட்டியில் சமைத்துப் பக்குவம் செய்த பலகாரத்தை நீ தானியக் காணிக்கையாகச் செலுத்த விரும்பினால் அது எண்ணெயிலே பிசைந்த புளிப்பில்லாத மிருதுவான மாவினால் செய்யப்பட்டதாக இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","அதைத் துண்டு துண்டாக உடைத்து அதன் மேல் எண்ணெய் ஊற்ற வேண்டும். இது தானியக் காணிக்கை ஆகும். ");
INSERT INTO tam2008_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","நீ பொரிக்கும் சட்டியில் பாகம் செய்யப்பட்ட பலகாரத்தை தானியக் காணிக்கையாக செலுத்த விரும்பினால் அது மிருதுவான மாவிலே எண்ணெய் பிசைந்து செய்யப்பட்டதாக இருக்கட்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","“இத்தகைய தானியக் காணிக்கையை நீ கர்த்தருக்குக் கொண்டு வரவேண்டும். அதனை ஆசாரியனிடம் கொடுத்தால் அவன் அவற்றைப் பலிபீடத்தின்மேல் வைப்பான். ");
INSERT INTO tam2008_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","பின்பு, ஆசாரியன் தானியக் காணிக்கையின் ஒரு பாகத்தை எடுத்து பலி பீடத்தில் ஞாபகக் காணிக்கையாக எரிப்பான். இக்காணிக்கை நெருப்பில் இடப்பட வேண்டும். இதன் வாசனை கர்த்தருக்கு விருப்பமானதாக இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","மீதியுள்ள தானியக் காணிக்கை ஆரோனுக்கும் அவனது மகன்களுக்கும் உரியதாகும். கர்த்தருக்காக செய்யப்படும் தகனங்களில் இது மிகவும் பரிசுத்தமானதாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“புளித்த மாவினால் செய்யப்பட்ட எந்த தானியப் பொருட்களையும், தேனால் செய்யப்பட்ட எந்தப் பொருட்களையும் கர்த்தருக்குக் காணிக்கையாக எரிக்கக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","நீ முதல் அறுவடையிலிருந்து புளிப்பில்லாத அப்பத்தையும் அல்லது தேனையும் கர்த்தருக்குக் காணிக்கையாகக் கொண்டு வரலாம். ஆனால் அதனைப் பலிபீடத்தின் மேல் இனிய வாசனையாக எரிக்க கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","நீ கொண்டு வருகிற எல்லா தானியக் காணிக்கைப் பொருட்களிலும் உப்பு சேர்ந்திருக்கட்டும். உன் தேவனின் உடன்படிக்கையில் உப்பை உன் தானியக் காணிக்கையில் குறைய விடாமல் பார்த்துக்கொள். உன் எல்லாக் காணிக்கைகளோடும் நீ உப்பைக் கொண்டுவர வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“நீ முதல் அறுவடையிலிருந்து தானியங்களைக் கர்த்தருக்குக் காணிக்கையாகக் கொண்டு வரும்போது, புதிய பச்சையான கதிர்களை நெருப்பால் வாட்டி உதிர்த்து கொண்டு வரவேண்டும். இதுவே உன் முதல் அறுவடையின் தானியக் காணிக்கையாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","அதன் மேல் நீ எண்ணெயையும், சாம்பிராணியையும் போட வேண்டும். இது தானியக் காணிக்கை. ");
INSERT INTO tam2008_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","ஆசாரியன் இதில் ஒரு பகுதியை எடுத்து ஞாபகார்த்தக் காணிக்கையாகப் பலிபீடத்தில் எரிக்க வேண்டும். இது கர்த்தருக்காக செய்யப்படும் தகனபலி ஆகும். ");
INSERT INTO tam2008_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ஒருவன் சமாதானப் பலியைப் படைக்க விரும்பினால் அந்த மிருகம் காளையாகவோ, பசுவாகவோ இருக்கலாம். கர்த்தருக்கு முன்பாக படைக்கப்படுகிற அம்மிருகம் எவ்விதமான குறையுமற்றதாக இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","அவன் தன் பலியின் தலைமேல் தன் கையை வைத்து ஆசாரிப்புக் கூடார வாசலில் அதனைக் கொல்ல வேண்டும். அப்போது ஆரோனின் மகன்களாகிய ஆசாரியர்கள் அதன் இரத்தத்தை பலிபீடத்தைச் சுற்றிலும் தெளிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","சமாதான பலி கர்த்தருக்காக செய்யப்படும் தகனபலியாகும். பிறகு ஆசாரியன் மிருகத்தின் உள்பாகங்களை மூடிய கொழுப்பையும், குடல்களிலுள்ள கொழுப்பு முழுவதையும் காணிக்கையாக அளிக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","அந்த மனிதன் இரண்டு சிறுநீரகங்களையும் அவற்றின்மேல் சிறு குடல்களிலுள்ள கொழுப்பையும் முதுகின் கீழ் தசையின் மேலுள்ள கொழுப்பையும், கல்லீரல் மேலுள்ள கொழுப்பையும் செலுத்த வேண்டும். அவற்றை சிறுநீரகங்களோடு நீக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","பிறகு அதனை ஆரோனின் மகன்கள் பலிபீடத்தில் வைத்து எரிக்கும்படி நெருப்பின் நடுவில் இருக்கும் தகனபலியின் கட்டைகளின் மேல் இதை வைப்பார்கள். இது ஒருவகை தகன காணிக்கையாகும். இதன் வாசனை கர்த்தருக்கு விருப்பமானதாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ஒருவன் கர்த்தருக்கு சமாதானப் பலியைப் படைக்க வேண்டுமென்று ஆட்டு மந்தையிலிருந்து ஒரு ஆட்டைக் கொண்டு வரலாம். அந்த ஆடு ஆணாகவோ பெண்ணாகவோ இருக்கலாம். ஆனால் எவ்விதத்திலும் குறை இல்லாததாக இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","அவன் பலியிடக்கூடிய ஆட்டுக்குட்டியுடன் வந்தால், அதைக் கர்த்தருக்கு முன்னால் கொண்டு வந்து, ");
INSERT INTO tam2008_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","அவன் தன் மிருகத்தின் தலைமேல் தன் கையை வைக்க வேண்டும். பிறகு ஆசாரிப்புக் கூடாரத்தின் முன்னால் அதனைக் கொல்ல வேண்டும். ஆரோனின் மகன்கள் அதன் இரத்தத்தை பலிபீடத்தின் மேலும் அதனைச் சுற்றிலும் தெளிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","அவன் சமாதானப் பலியின் ஒரு பாகத்தை எரிக்கப்பட்ட பலியாக கர்த்தருக்கு அளிக்க வேண்டும். அவன் மிருகத்தின் கொழுப்பையும் கொழுப்பான வால் முழுவதையும், மிருகத்தின் உறுப்புகளின் உள்ளேயும் மேலும் படர்ந்துள்ள கொழுப்பையும் கொடுக்க வேண்டும். (அவன் அதனுடைய முதுகெலும்புக்கு அருகிலுள்ள வாலை வெட்ட வேண்டும்.) ");
INSERT INTO tam2008_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","இரண்டு சிறுநீரகங்களையும், கொழுப்புத் தசைகளையும், கல்லீரலைச் சுற்றியுள்ள கொழுப்பு பகுதிகளையும் கொடுக்க வேண்டும். அவன் சிறுநீரகத்தை அப்புறப்படுத்த வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","பிறகு இவை அனைத்தையும் ஆசாரியன் பலிபீடத்தில் வைத்து எரிக்க வேண்டும். இவ்வாறு கர்த்தருக்காகப் படைக்கிற காணிக்கையே சமாதானப் பலியாகும். மேலும் இது ஜனங்களுக்கும் உணவாகிறது. ");
INSERT INTO tam2008_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ஒருவன் சமாதானக் காணிக்கையாக வெள்ளாட்டைச் செலுத்த விரும்புவானேயானால் அவன் அதனை கர்த்தருக்கு முன்னால் கொண்டு வரவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","அதன் தலைமேல் தன் கையை வைத்து ஆசரிப்புக் கூடாரத்துக்கு முன்னால் கொல்ல வேண்டும். பிறகு ஆரோனின் மகன் அதன் இரத்தத்தை பலிபீடத்தின் மேலும் அதனைச் சுற்றிலும் தெளிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","அவன் சமாதானக் காணிக்கையாக ஒரு பகுதியை நெருப்பில் எரித்து கர்த்தருக்குக் காணிக்கையாக்க வேண்டும். குடல்களை மூடிய கொழுப்பையும், அவைகளின் மேலிருக்கிற கொழுப்பையும், ");
INSERT INTO tam2008_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","இரண்டு சிறுநீரகங்களையும் அவற்றின் மேல் உள்ள சிறு குடல்களில் உள்ள கொழுப்பையும் சிறுநீரகங்களோடு கூடக் கல்லீரலின் மேலுள்ள சதையையும் எடுத்து கர்த்தருக்குத் தகனபலியாகக் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","பிறகு ஆசாரியன் பலிபீடத்தின் மேல் அவற்றை எரிக்க வேண்டும். சமாதானப் பலி நறுமண வாசனையாக கர்த்தருக்கு எரிக்கப்பட்டக் காணிக்கையாகும். இதன் வாசனை கர்த்தருக்கு பிரியமானதாக இருக்கும். இது ஜனங்களுக்கு உணவாகவும் இருக்கும். ஆனால் சிறப்பான பாகம் முழுவதும் கர்த்தருக்குரியது. ");
INSERT INTO tam2008_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","கொழுப்பையும், இரத்தத்தையும் நீங்கள் உண்ணக்கூடாது. எங்கெங்குமுள்ள உங்கள் பரம்பரை முழுவதற்கும் இக்கட்டளை உரியது. நீங்கள் எங்கு வாழ நேர்ந்தாலும் கொழுப்பையோ, இரத்தத்தையோ, உண்ணக் கூடாது” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“நீ, இஸ்ரவேல் ஜனங்களிடம் கூற வேண்டியதாவது: செய்யக்கூடாது எனக் கர்த்தர் சொன்ன காரியங்களைச் செய்ய நேர்ந்தாலும், அசம்பாவிதமாக பாவம் செய்ய நேர்ந்தாலும், ஒருவன் கீழ்க்கண்டபடி செய்ய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“அபிஷேகம் பெற்ற ஆசாரியன், ஜனங்கள் குற்றத்திற்கு உட்படத்தக்கதாகப் பாவம் செய்தால் அந்த ஆசாரியன் தன் பாவத்துக்காக கர்த்தருக்குச் சில காணிக்கைகளைச் செலுத்த வேண்டும். அந்த ஆசாரியன் குறையற்ற ஒரு இளங்காளையைப் பாவப் பரிகாரப் பலியாகக் கொண்டு வரவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","ஆசாரியன் ஆசரிப்புக் கூடார வாசலுக்கு கர்த்தரின் சந்நிதானத்திற்கு அந்தக் காளையைக் கொண்டு வரவேண்டும். அவன் அதன் தலையின் மேல் தன் கையை வைத்து அதனைக் கொல்ல வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","பின் அந்த அபிஷேகம் பெற்ற ஆசாரியன் காளையின் இரத்தத்தை எடுத்து ஆசரிப்புக் கூடாரத்திற்குள் கொண்டு வரவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","அவன் தன் விரலால் அந்த இரத்தத்தைத் தொட்டு மகாபரிசுத்த ஸ்தலத்தின் திரைக்கு எதிரே கர்த்தரின் சந்நிதியில் ஏழுமுறை தெளிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","பின் ஆசாரியன் இரத்தத்தில் கொஞ்சம் எடுத்து நறுமண பலிபீடத்தின் மூலைகளில் பூச வேண்டும். (இந்த பலிபீடமானது ஆசரிப்புக் கூடாரத்திலே கர்த்தருக்கு முன் இருக்கும்.) காளையின் எல்லா இரத்தத்தையும் தகன பலிபீடத்தின் அடியில் ஊற்ற வேண்டும். (இப்பலிபீடமானது ஆசரிப்புக் கூடாரத்தின் வாசலில் இருக்கும்.) ");
INSERT INTO tam2008_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","அதற்குப் பிறகு, பாவப்பரிகாரப் பலியாகத் தரப்பட்ட காளையின் கொழுப்பு அனைத்தையும் எடுக்க வேண்டும். காளையின் உட்பகுதிகளிலும் அதைச் சுற்றிலும் உள்ள கொழுப்பு முழுவதையும் எடுத்து, ");
INSERT INTO tam2008_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","அவன் அதன் இரண்டு சிறு நீரகங்களையும் அவற்றையொட்டி கீழ்ப்புறத்திலும், மேல்புறத்திலும் ஒட்டி இருக்கிற கொழுப்பையும் கல்லீரலில் இருக்கும் கொழுப்புப் பகுதிகளையும் சிறுநீரகங்களோடு சேர்த்து, ");
INSERT INTO tam2008_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","சமாதானப் பலியின் போது காளையிலிருந்து எடுப்பது போன்று இப்பாகங்களை எடுத்து ஆசாரியன் பலி பீடத்தின் மேல் வைத்து எரிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","12","ஆனால் ஆசாரியன் காளையின் தோலையும், அதன் குடல்களையும், கழிவுப் பொருட்களையும் தலையிலும் கால்களிலும் உள்ள மாம்சத்தையும் தனியே எடுக்க வேண்டும். அவற்றைக் கூடாரத்திற்கு வெளியே கொண்டுபோய் சாம்பல் கொட்டுகிற சிறப்புக்குரிய இடத்தில் குவிக்க வேண்டும். பின்பு ஆசாரியன் இக்குவியலை விறகுகளின் மேல் அடுக்கி எரிக்க வேண்டும். சாம்பல் குவிக்கப்பட்டிருக்கும் இடத்தில் காளை எரிக்கப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“இஸ்ரவேல் ஜனங்கள் அனைவரும் அறியாமையால் பாவம் செய்து, கர்த்தர் எவற்றைச் செய்யக் கூடாது என்று சொன்னாரோ அவற்றை அவர்கள் தெரியாமல் செய்து பாவத்திற்குரியவர்களாகலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","அவர்கள் தங்கள் பாவங்களை அறிந்துகொள்ளும் போது, அதற்காக ஒரு இளங்காளையைப் பாவப்பரிகார பலியாக தங்கள் முழு நாட்டிற்காகவும் அளிக்க வேண்டும். அதனை அவர்கள் ஆசரிப்புக் கூடாரத்தின் முன்பு கொண்டு வரவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","இஸ்ரவேலின் மூப்பர்கள் கர்த்தருக்கு முன்பாக தங்கள் கைகளை அதன் தலையில் வைக்க வேண்டும். பின்னர் அதனைக் கர்த்தருடைய சந்நிதானத்தில் கொல்ல வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","பின்னர் அபிஷேகம் பெற்ற ஆசாரியன் அக்காளையின் இரத்தத்தில் கொஞ்சம் எடுத்து ஆசரிப்புக் கூடாரத்திற்குள் கொண்டு வர வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","ஆசாரியன் தனது விரலை இரத்தத்தில் தொட்டு கர்த்தருக்கு முன்னால் உள்ள திரையில் ஏழுமுறை தெளிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","பிறகு ஆசாரியன் கொஞ்சம் இரத்தத்தை எடுத்து பலிபீடத்தின் மூலைப்பகுதிகளில் பூச வேண்டும். (இப்பலிபீடம் ஆசாரிப்புக் கூடாரத்திற்குள் கர்த்தருக்கு முன்னால் இருக்கும்.) பின்பு ஆசாரியன் அக்காளையின் எல்லா இரத்தத்தையும் தகனபலிபீடத்தின் அடியில் ஊற்ற வேண்டும். (இது ஆசாரிப்புக் கூடாரத்தின் வாசலில் இருக்கும்.) ");
INSERT INTO tam2008_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","பின் அக்காளையிடம் உள்ள கொழுப்பு முழுவதையும் எடுத்து பலிபீடத்தின் மேல் எரிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","பாவப்பரிகாரப் பலியைப் போலவே ஆசாரியன் இதன் பாகங்களையும் செய்து முடிக்க வேண்டும். இதன் மூலம், ஜனங்கள் அனைவரையும் சுத்திகரிக்க முடியும். இஸ்ரவேல் ஜனங்கள் அனைவரையும் தேவன் மன்னிப்பார். ");
INSERT INTO tam2008_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","ஆசாரியன் மற்ற காளையைக் கூடாரத்திற்கு வெளியே கொண்டு சென்று முன்பு செய்தது போலவே இதையும் எரித்துவிடவேண்டும். இது முழு சமுதாயத்திற்கான பாவப்பரிகாரப் பலியாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ஒரு ஆட்சியாளன் அசம்பாவிதமாக தன் தேவனாகிய கர்த்தர் செய்யவேண்டாம் என்று கூறியவற்றை மீறி செய்யத்தகாததைச் செய்து பாவத்திற் குரியவனாயிருக்கலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","அந்த ஆட்சியாளன் தனது பாவத்தைத் தெரிந்துகொண்டதும் அவன் எவ்விதக் குறைபாடும்Ԕ இல்லாத ஆண் வெள்ளாட்டைக் கொண்டு வரவேண்டும். அதுவே அவனது காணிக்கை. ");
INSERT INTO tam2008_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","ஆட்சியாளன் தன் கையை ஆட்டின் தலைமேல் வைத்து, அதனைக் கர்த்தருக்கு முன்பு தகன பலியிடக் கூடிய இடத்தில் கொல்ல வேண்டும். அந்த வெள்ளாடுதான் பாவப்பரிகார பலியாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","ஆசாரியன் கொஞ்சம் இரத்தத்தைத் தன் விரலால் எடுத்து தகனபலிபீடத்தின் மூலைப் பகுதிகளில் பூச வேண்டும். மிச்சமுள்ள இரத்தத்தைத் தகன பலிபீடத்தின் அடியில் ஊற்ற வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","ஆசாரியன் அந்த ஆட்டின் கொழுப்பு முழுவதையும் பலிபீடத்தின் மேல் எரிக்க வேண்டும். சமாதானப் பலியில் செய்தது போன்றே இதிலும் கொழுப்பை எரித்துவிடவேண்டும். இவ்வாறு செய்வதன் மூலம் ஆசாரியன் ஆட்சியாளனைப் பரிசுத்தப்படுத்திவிடலாம். தேவனும் அவனை மன்னித்துவிடுவார். ");
INSERT INTO tam2008_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“பொது ஜனங்களில் ஒருவன் அசம்பாவிதமாக பாவம் செய்துவிடலாம். இப்படி அவன் கர்த்தர் சொன்னதை மீறி செய்யத் தகாததைச் செய்துவிடுகிறான். ");
INSERT INTO tam2008_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","அவன் தான் செய்தது பாவம் என்பதைத் தெரிந்துகொண்டவுடனே அவன் பழுதற்ற பெண் ஆட்டைக் கொண்டு வர வேண்டும். அதுவே அவனுடைய பாவப்பரிகாரப் பலி ஆகும். அவன் செய்த பாவத்திற்காக அவன் அதைக் கொண்டுவர வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","அவன் தன் கையை அதன் தலைமீது வைத்து, தகன பலிக்குரிய இடத்தில் அதனைக் கொல்ல வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","பிறகு ஆசாரியன் தன் விரல்களில் அதன் இரத்தத்தை எடுத்து தகன பலிபீடத்தின் கொம்புகளில் பூச வேண்டும். பின் அவன் மிச்சமுள்ள இரத்தத்தை பலிபீடத்தின் அடியில் ஊற்ற வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","சமாதானப் பலியில் செய்தது போன்று ஆட்டின் கொழுப்பு முழுவதையும் பலிபீடத்தில் எரித்துவிட வேண்டும். கர்த்தருக்கு இனிய நறுமணம் தரும்படி ஆசாரியன் அதனைப் பலிபீடத்தில் எரிக்கவேண்டும். இம்முறையில் ஆசாரியன் அம்மனிதனைச் சுத்தப்படுத்தலாம். தேவன் அவனை மன்னித்துவிடுவார். ");
INSERT INTO tam2008_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“அவன் பாவப்பரிகாரப் பலியாக ஒரு ஆட்டுக் குட்டியைக் கொண்டு வருவானாகில், அது பழுதற்ற பெண் குட்டியாக இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","அதன் தலைமீது தன் கையை வைத்து, தகனபலிகளை வழங்கும் இடத்தில் அதனை பாவப்பரிகாரப் பலியாகக் கொல்ல வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","ஆசாரியன் அதன் இரத்தத்தைத் தன் விரலில் எடுத்து தகன பலிபீடத்தின் மூலைகளில் தடவ வேண்டும். பின் அதன் இரத்தத்தைப் பலிபீடத்தின் அடியில் ஊற்ற வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","சமாதானப் பலிகளில் செய்தது போலவே ஆட்டின் கொழுப்பை தகனபலிபீடத்தின் மேல் வைத்து எரிக்க வேண்டும். மற்ற பலி முறைகளில் செய்தது போலவே பலிபீடத்தில் வைத்ததை எரிக்க வேண்டும். இவ்வாறு ஆசாரியன் அவன் செய்த பாவத்திலிருந்து சுத்தப்படுத்தலாம். தேவனும் அவனை மன்னித்துவிடுவார். ");
INSERT INTO tam2008_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ஒருவன் ஒரு எச்சரிக்கையைக் கேட்டாலோ அல்லது பிறரை எச்சரிக்க வேண்டியவைகளைப் பார்த்தாலோ கேட்டாலோ அதை மற்றவர்களுக்குச் சொல்லவேண்டும். தான் கண்டதையும் கேட்டதையும் மற்றவர்களுக்குச் சொல்லாவிட்டால், பிறகு அவன் தவறு செய்வதற்கான குற்ற உணர்வைப் பெறுவான். ");
INSERT INTO tam2008_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ஒருவன் தூய்மையற்ற ஒன்றைத் தொட்டிருக்கலாம். அது காட்டுமிருகத்தின் இறந்து போன உடலாகக் கூட இருக்கலாம். அல்லது அது தரையில் ஊர்ந்து போகும் அசுத்தமான நாட்டு மிருகத்தின் உடலாக இருக்கலாம். அவற்றைத் தொட்டதற்கான உணர்வு அவனிடம் இல்லாமல் இருக்கலாம். எனினும் அதனால் அவன் தீட்டுக்குரியவனாய் இருக்கிறான். ");
INSERT INTO tam2008_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“ஒருவன் பல காரணங்களால் அசுத்தமானவற்றைத் தொட்டதற்கான தீட்டைப் பெற்றிருக்கலாம். ஒரு மனிதன் மனிதத் தீட்டுக்களில் ஏதாகிலும் ஒன்றை அவனை அறியாமல் மற்ற மனிதனிடமிருந்து தொட்டிருக்கலாம். அவன் அதனை அறிய வரும்போது, அவன் குற்றமுடையவனாகிறான். ");
INSERT INTO tam2008_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“ஒருவன் அவசரமாக ஏதோ ஒரு காரணத்திற்காக வாக்குறுதி கொடுக்கிறான். அது நன்மைக்குரியதாகவோ தீமைக்குரியதாகவோ இருக்கலாம். ஜனங்கள் பலவிதமான அவசர வாக்குறுதிகள் வழங்குகின்றனர். ஒருவன் இவ்வாறு செய்து மறந்தும் போகலாம், அதைக் காப்பாற்றாமலும் போகலாம். பிற்காலத்தில் தான் கொடுத்த வாக்குறுதிகளை நினைத்துப் பார்க்கும் போது குற்றவாளியாகிறான். ஏனெனில் அவ்வாக்குறுதிகளின்படி அவன் செய்யவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","ஒருவன் இப்படிப்பட்ட ஏதாவது ஒன்றில் குற்றம் உள்ளவனாகும்போது அவன் தான் செய்தது பாவம் என்று ஒத்துக்கொள்ள வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","அவன் தான் செய்த பாவத்துக்குக் குற்ற நிவாரண பலியிடவேண்டும். அதற்காக அவன் பெண் ஆட்டினை அல்லது பெண் வெள்ளாட்டுக் குட்டியைக் கர்த்தருக்காகப் பாவநிவாரண பலியாகக் கொண்டு வரவேண்டும். பிறகு ஆசாரியன் அவனை பரிசுத்தமாக்குவதற்கான சடங்குகளைச் செய்து அவனது பாவத்தைப் போக்கி சுத்தமாக்குவான். ");
INSERT INTO tam2008_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ஒருவேளை அவனால் ஆட்டுக் குட்டியைக் கொண்டுவர வசதியில்லாமல் போனால், அவன் கர்த்தருக்கு இரண்டு காட்டுப் புறாக்களையாவது அல்லது இரண்டு புறாக்குஞ்சுகளையாவதுகொண்டு வரவேண்டும். இவை அவன் பாவத்திற்கான குற்றநிவாரண பலியாகும். அவற்றில் ஒன்றை பாவப்பரிகார பலியாகவும் மற்றொன்றை தகன பலியாகவும் படைக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","அவன் அவற்றை ஆசாரியனிடம் கொண்டு வரவேண்டும். ஆசாரியன் பாவப்பரிகார பலிக்கானதை முதலில் செலுத்துவான். அதன் தலையைக் கழுத்திலிருந்து கிள்ளுவான். அவன் அப்புறாவை இரண்டு துண்டாக்கக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","பாவப் பரிகாரப் பலியின் இரத்தத்தில் ஆசாரியன் கொஞ்சம் எடுத்து பலிபீடத்தின் பக்கத்திலே தெளித்து, மீதி இரத்தத்தைப் பலிபீடத்தின் அடியிலே ஊற்றிவிடுவான். இதுவே பாவப்பரிகார பலி ஆகும். ");
INSERT INTO tam2008_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","பின்பு இரண்டாவது புறாவை தகன பலிக்குரிய விதிகளின்படி காணிக்கையாகச் செலுத்த வேண்டும். இதன் மூலம் ஆசாரியன் அந்த மனிதன் செய்த பாவத்திலிருந்து அவனை விடுவித்து சுத்தப்படுத்துகிறான். தேவனும் அவனை மன்னித்துவிடுவார். ");
INSERT INTO tam2008_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“இரண்டு காட்டுப் புறாக்களையோ, இரண்டு புறாக்குஞ்சுகளையோ அவனால் கொண்டுவர வசதியில்லாமல் போனால் அவன் 8 கிண்ணங்கள் அளவு மிருதுவான மாவை எடுத்து வரவேண்டும். இதுவே பாவப்பரிகாரப் பலியாக இருப்பதால் அந்த மாவின் மேல் எண்ணெய் எதையும் ஊற்றவோ, அதன்மேல் எவ்விதமான சாம்பிராணியையும் போடவோ கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","அவன் அந்த மாவை ஆசாரியனிடத்தில் கொண்டு வரவேண்டும். அதில் ஆசாரியன் ஒரு கைப் பிடியளவு எடுக்கவேண்டும். அது ஞாபகப் பலியாக இருக்கும். மாவை ஆசாரியன் பலி பீடத்தின் மேல் எரித்துவிடுவான். இது நெருப்பினால் கர்த்தருக்கென்று கொடுக்கும் காணிக்கையாகும். இது பாவப்பரிகாரப் பலியாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","இவ்வாறு ஆசாரியன் அம்மனிதனை சுத்தபடுத்துவான். அப்போது தேவன் அவனுக்கு மன்னிப்பார். மீதி மாவானது தானியக் காணிக்கையைப் போல ஆசாரியனுக்குச் சேரும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","மேலும் கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“கர்த்தருக்குரிய பரிசுத்தமானவற்றில் ஒருவன் அசம்பாவிதமாக தவறு செய்துவிட்டால் அவன் ஒரு குறையற்ற ஆட்டுக்குட்டியைக் கொண்டு வரவேண்டும். அது கர்த்தருக்கு அவன் கொடுக்கும் குற்ற நிவாரண பலியாகும். அதிகாரப் பூர்வமான அளவைப் பயன்படுத்தி ஆட்டின் விலையை நிர்ணயிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","அந்த மனிதன் தான் செய்த பாவத்திற்குரிய விலையைச் செலுத்த வேண்டும். வாக்குறுதியளித்த தொகையோடு, அதன் மதிப்பில் ஐந்தில் ஒரு பகுதியையும் கூட்டி, மொத்தப் பணத்தை ஆசாரியன் கையில் கொடுக்க வேண்டும். இம்முறையில் குற்ற நிவாரண பலியின் மூலம் அம்மனிதனை ஆசாரியன் சுத்தமாக்குகிறான். தேவனும் அம்மனிதனை மன்னிப்பார். ");
INSERT INTO tam2008_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“செய்யக்கூடாது என்று கர்த்தர் சொன்னவற்றில் ஏதாவது ஒன்றைச் செய்தால் ஒருவன் பாவியாகிறான். அவன் அறியாமல் செய்தாலும் அது பாவமே. அவன் குற்றவாளியாகிறான். அவன் தன் பாவத்தின் பொறுப்பை ஏற்றுக்கொள்ள வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","அவன் ஆசாரியனிடம் ஒரு ஆட்டுக்குட்டியைக் கொண்டு வரவேண்டும். எவ்வித குறைகளும் இல்லாததாக அந்த ஆடு இருக்கவேண்டும். அந்த ஆட்டுக்குட்டி குற்ற நிவாரண பலி ஆகும். இந்த முறையில் ஆசாரியன் அவன் அறியாமல் செய்த பாவத்திலிருந்து அவனை சுத்தமாக்குவான், தேவனும் அவனை மன்னித்துவிடுவார். ");
INSERT INTO tam2008_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","ஒருவன் பாவம் செய்யும்போது அறியாமல் செய்தாலும் அவன் குற்றவாளிதான். எனவே அவன் கர்த்தருக்கு குற்ற நிவாரணப் பலியைச் செலுத்தியே ஆக வேண்டும்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“கர்த்தர் சொன்னவற்றுக்கு எதிராக ஒருவன் இந்தப் பாவங்களில் ஒன்றைச் செய்திருக்கலாம். ஒருவன் தான் பெற்ற தொகையைப்பற்றிப் பொய் சொல்லலாம். ஒருவன் சிலவற்றைத் திருடியிருக்கலாம். அல்லது ஒருவன் இன்னொருவனை ஏமாற்றியிருக்கலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","அல்லது ஒருவன் காணாமல் போனதைக் கண்டுபிடித்து விட்டு பின் அதுபற்றி பொய் சொல்லலாம்; அல்லது ஒருவன் ஒன்றைச் செய்வதாகச் சத்தியம் செய்துவிட்டு சத்தியத்தின்படி செய்யாமல் இருக்கலாம். அல்லது ஒருவன் வேறுவிதமான தவறுகள் செய்யலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ஒருவன் மேற்கூறியபடி ஏதேனும் ஒன்றைச் செய்வானேயானால் அவன் பாவியாகக் கருதப்படுகிறான். அவன் எதைத் திருடியிருந்தாலும் திரும்பிக் கொண்டுவந்து கொடுக்கவேண்டும். ஏமாற்றிப் பொருளை எடுத்திருந்தாலும், பாதுகாப்புக்காக இன்னொருவன் தன்னிடம் கொடுத்து வைத்த பொருளை எடுத்திருந்தாலும், எதையாவது கண்டுபிடித்து பொய் சொல்லியிருந்தாலும் ");
INSERT INTO tam2008_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","அல்லது சத்தியம் செய்துவிட்டு அதை நிறை வேற்றாமல் இருந்தாலும் சரிசெய்துகொள்ள வேண்டும். அவன் அதற்குரிய முழுமையான விலையைக் கொடுக்க வேண்டும். அதோடு அவற்றில் மதிப்பில் ஐந்தில் ஒரு பாகத்தை அதிகமாகக் கொடுக்க வேண்டும். அத்தொகையை அதன் உண்மையான சொந்தக்காரனுக்குக் கொடுக்க வேண்டும். அவன் இவற்றையெல்லாம் கொண்டுவந்து தரும் நாளிலேயே குற்ற நிவாரண பலியைச் செலுத்த வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","அவன் தன் குற்றபரிகாரப் பலியை ஆசாரியனிடம் கொண்டு வரவேண்டும். அது மந்தையிலிருந்து தேர்ந்தெடுத்த ஆடாயிருக்க வேண்டும். எல்லாவிதத்திலும் குறையற்றதாக இருக்கவேண்டும். ஆசாரியன் சொல்லும் விலைக்கு ஏற்றதாக அது இருக்கவேண்டும். அது கர்த்தருக்குச் செலுத்த வேண்டிய குற்ற பரிகாரப் பலியாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","பிறகு ஆசாரியன் கர்த்தரிடம் சென்று அம்மனிதன் சுத்தமாவதற்குரியவற்றைச் செய்வான். தேவனும் அவன் செய்த அனைத்து பாவங்களிலிருந்தும் அவனை மன்னித்துவிடுவார்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","மேலும் கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“இந்தக் கட்டளையை ஆரோனுக்கும் அவனது பிள்ளைகளுக்கும் சொல். இதுவே தகன பலியைப்பற்றிய சட்டங்கள். தகனபலி இரவு முழுவதும் விடியும்வரை பலிபீடத்தின் மேல் இருக்க வேண்டும். காணிக்கைக்குத் தேவையான நெருப்பானது பலிபீடத்தின் மேல் எரிந்துக்கொண்டிருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","ஆசாரியன் தனது மெல்லிய அங்கியை உடுத்திக்கொண்டு, தனது மெல்லிய உள்ளாடையை இடுப்பில் கட்டிக்கொள்ள வேண்டும். பிறகு ஆசாரியன் பலிபீடத்தின் மேல் மீதியாய் இருக்கும், தகனபலியை எரித்த சாம்பலை எடுத்து அதனைப் பலிபீடத்தின் பக்கத்திலே கொட்ட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","பிறகு ஆசாரியன் தன் ஆடைகளை மாற்றி வேறு ஆடையை அணிந்துக்கொள்ள வேண்டும். பின்னர் அவன் அந்தச் சாம்பலைக் கூடாரத்துக்கு வெளியே ஒரு விசேஷ இடத்திற்குக் கொண்டுபோக வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","பலிபீடத்தின் நெருப்பானது தொடர்ந்து பலிபீடத்தின் மேல் எரிய வேண்டும். அதனை அணைந்து போகும்படி விடக்கூடாது. ஆசாரியன் ஒவ்வொரு நாள் காலையிலும் விறகு வைத்து நெருப்பை அதிகரிக்க வேண்டும். அவன் அந்த விறகை பலிபீடத்தில் வைக்க வேண்டும். அவன் அதனோடு சமாதானப் பலியின் கொழுப்பையும் போட்டு எரிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","பலிபீடத்தின் மேல் நெருப்பானது எப்பொழுதும் அணையாமல் எரிய வேண்டும். அது அணைந்து போகக்கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“தானியக் காணிக்கைக்குரிய சட்டம் இதுவே: ஆரோனின் மகன்கள் இதனைக் கர்த்தருக்குப் பலிபீடத்தின் முன்னால் கொண்டு வரவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","தானியக் காணிக்கையிலிருந்து மிருதுவான மாவினை ஒரு கையளவு ஆசாரியன் எடுக்க வேண்டும். எண்ணெயும், சாம்பிராணியும் அத்தானியக் காணிக்கையின்மேல் இருக்க வேண்டும். பலிபீடத்தின் மேல் தானியக் காணிக்கையை ஆசாரியன் எரிக்க வேண்டும். இது கர்த்தருக்காக ஞாபகக் காணிக்கையாக இருக்கும். அதன் வாசனை கர்த்தருக்குப் பிரியமானதாக இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","“ஆரோனும் அவனது மகன்களும் மிச்சமுள்ள தானியக் காணிக்கையை உண்ண வேண்டும். இத்தானியக் காணிக்கையானது புளிப்பில்லாத ஒருவகை அப்பம். ஆசாரியர்கள் இந்த அப்பத்தை ஒரு பரிசுத்த இடத்தில் வைத்து உண்ண வேண்டும். அவர்கள் அதனை ஆசரிப்புக் கூடாரத்தைச் சுற்றியுள்ள வெளிப்பிரகாரத்தில் வைத்து உண்ண வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","தானியக் காணிக்கையை புளித்த மாவுடன் சமைக்கக் கூடாது. எனக்கு அளிக்கப்படும் தகன காணிக்கையில் ஆசாரியர்களின் பங்காக நான் அதனை அவர்களுக்குக் கொடுத்திருக்கிறேன். இது பாவப்பரிகார பலியை போலவும், குற்ற நிவாரண பலியை போலவும் மிகவும் பரிசுத்தமானது. ");
INSERT INTO tam2008_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","கர்த்தருக்கு இடப்படும் தகன காணிக்கையை ஆரோனின் ஜனங்களில் ஒவ்வொரு ஆணும் உண்ணலாம். உங்கள் தலைமுறைகள்தோறும் இதனை எக்காலத்திற்கும் உரிய விதியாக வைத்துக்கொள்ள வேண்டும். இக்காணிக்கைகளைத் தொடுகிற மனிதர் பரிசுத்தமடைவர்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","மேலும் கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“ஆரோனும் அவனது மகன்களும் கர்த்தருக்குக் கொண்டுவரக் கூடிய காணிக்கை யாதெனில்: ஆரோன் தலைமை ஆசாரியனாக அபிஷேகம் பண்ணப்படும் நாளில் அவர்கள் இதனைச் செய்ய வேண்டும். அவர்கள் தானியக் காணிக்கையாக எட்டுக் கிண்ணங்கள் அளவு மிருதுவான மாவை எடுத்துவர வேண்டும். (இது தினந்தோறும் செலுத்த வேண்டிய காணிக்கையின்போது செலுத்தப்பட வேண்டும்.) அவர்கள் காலையில் பாதியும் மாலையில் பாதியும் கொண்டு வரவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","அந்த மென்மையான மாவானது எண்ணெயோடு கலக்கப்பட்டு சட்டியில் வைக்கப்பட வேண்டும். அது பாகம் பண்ணப்பட்டபின், நீ அதனைக் கொண்டு வரவேண்டும். அதனைப் பல துண்டுகளாக வெட்ட வேண்டும். அதன் வாசனை கர்த்தருக்கு மிகவும் பிரியமானது. ");
INSERT INTO tam2008_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","“ஆரோனின் சந்ததியில் வந்து ஆரோனின் இடத்துக்குத் தேர்ந்தெடுக்கப்பட்ட ஆசாரியனே இந்த தானியக் காணிக்கையைக் கர்த்தருக்குச் செலுத்த வேண்டும். இந்த விதி எக்காலத்திற்கு முரியது. தானியக் காணிக்கை கர்த்தருக்காக முழுமையாக எரிக்கப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","ஆசாரியனுக்குரிய ஒவ்வொரு தானியக் காணிக்கையும் முழுமையாக எரிக்கப்பட வேண்டும், அதைச் சாப்பிடக் கூடாது” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“ஆரோனுக்கும் அவனது ஜனங்களுக்கும் சொல், இதுதான் பாவப்பரிகார பலிக்கான சட்டம். பாவப் பரிகார பலியை கர்த்தருக்கு முன்பாகத் தகன பலி கொல்லப்படும் இடத்திலேயே கொல்லப்பட வேண்டும். இது மிகவும் பரிசுத்தமானது. ");
INSERT INTO tam2008_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","பாவப் பரிகார பலியைச் செலுத்தும் ஆசாரியன் அதனை உண்ண வேண்டும். ஆனால் அதனைப் பரிசுத்தமான இடத்தில் உண்ண வேண்டும். அந்த இடம் ஆசரிப்புக் கூடாரத்தைச் சுற்றியுள்ள வெளிப்பிரகாரமாக இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","பாவப்பரிகார பலிகுரிய இறைச்சியைத் தொடுவதும் கூட ஒரு பொருளையோ ஒரு நபரையோ பரிசுத்தமாக்கும். “அதன் இரத்தம் தெளிக்கப்படும்போது ஒருவரது ஆடையில் பட்டால், அந்த ஆடையைப் பரிசுத்தமான இடத்தில் துவைக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","பாவப் பரிகார பலி வேகவைக்கப்பட்ட பாத்திரம் மண் பாத்திரமானால் அது உடைக்கப்பட வேண்டும். அது செம்புப் பானையில் வேகவைக்கப்பட்டிருந்தால் அது நன்றாக தேய்க்கப்பட்டு தண்ணீரில் கழுவப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","“பாவப்பரிகார பலியை ஆசாரியக் குடும்பத்தைச் சேர்ந்த எந்த ஆண் வேண்டுமானாலும் உண்ணலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","ஆனால், பாவப் பரிகார பலியின் இரத்தமானது ஆசரிப்புக் கூடாரத்திற்குள் கொண்டு வரப்பட்டு பரிசுத்தமான இடத்தில் பயன்படுத்தப்பட்டு ஜனங்களை சுத்தப்படுத்திய பிறகு இது எரிக்கப்பட வேண்டும். அந்த பாவப்பரிகாரப் பலியை உண்ணக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“குற்ற பரிகார பலியின் விதிகள் கீழ்க்கண்டவாறு உள்ளன. இது மிக பரிசுத்தமானது. ");
INSERT INTO tam2008_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","தகன பலி கொல்லப்படும் இடத்திலேயே ஆசாரியன் குற்ற பரிகார பலியையும் கொல்ல வேண்டும். அதன் இரத்தத்தைப் பலிபீடத்தைச் சுற்றி ஆசாரியன் தெளிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","“ஆசாரியன் குற்ற பரிகார பலியின் கொழுப்பு முழுவதையும், செலுத்தவேண்டும். அவன் அதன் வாலையும் குடல்களை மூடியிருக்கிற கொழுப்பையும் அளிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ஆசாரியன் இரண்டு சிறு நீரகங்களையும் அவற்றைச் சுற்றியுள்ள கொழுப்பையும் எடுத்து அளிக்க வேண்டும். மேலும் கல்லீரலின் கொழுப்பு பகுதியையும் சிறு நீரகங்களோடு எடுத்து செலுத்த வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","இவற்றைப் பலி பீடத்தின்மேல் ஆசாரியன் எரிக்க வேண்டும். இது நெருப்பினால் கர்த்தருக்கென்று கொடுக்கும் காணிக்கையாகும். இது குற்ற பரிகார பலியாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","“இக்குற்ற பரிகார பலியை ஆசாரியனின் குடும்பத்தில் உள்ள எந்த ஆண் மகனாயினும் உண்ணலாம். இது மிகவும் பரிசுத்தமானது. எனவே அது ஒரு பரிசுத்தமான இடத்தில் உண்ணப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","இக்குற்ற பரிகார பலியானது பாவப் பரிகார பலியைப் போன்றதாகும். இரண்டுக்கும் ஒரேவிதமான விதிமுறைகளே உள்ளன. எனவே பலியைக் கொடுத்த ஆசாரியனே அப்பலியின் இறைச்சியைப் பெறுவான். ");
INSERT INTO tam2008_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","ஒருவனது தகன பலியைச் செலுத்திய ஆசாரியன் தான் செலுத்திய பலியின் தோலைத் தனக்காக வைத்துக்கொள்ளலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","எல்லா தானியக் காணிக்கைகளும் அதை முன்னின்று வழங்கும் ஆசாரியனுக்கே உரியதாகும். அடுப்பில் சமைக்கப்பட்டதாகவோ, அல்லது சட்டியிலும், தட்டையான சட்டியிலும் சமைக்கப்பட்டதாகவோ இருக்கும் காணிக்கையானது ஆசாரியனுக்கே சேரும். ");
INSERT INTO tam2008_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","ஆரோனின் மகன்களுக்கு தானியக் காணிக்கைப் பொருள்கள் சேரும். அவை உலர்ந்ததா அல்லது எண்ணெயில் கலக்கப்பட்டதா என்பதைப் பொருட்படுத்தாமல், ஆரோனின் மகன்கள் அதனைப் பங்கிட்டுக்கொள்ள வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“கர்த்தருக்குச் செலுத்துகிற சமாதானப் பலியின் சட்டங்கள் கீழ்க்கண்டவையாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","தன் நன்றியைத் தெரிவிப்பதற்காக ஒருவன் சமாதானப் பலியைக் கொண்டு வரலாம். அப்போது அவன் எண்ணெயிலே கலந்து பிசைந்த புளிப்பில்லாத அப்பத்தையும், எண்ணெய் பூசப்பட்ட புளிப்பில்லாத அடைகளையும், எண்ணெயிலே பிசைந்து வறுக்கப்பட்ட மிருதுவான மாவால் ஆன அப்பங்களையும் படைக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","ஒருவன் தேவனுக்குத் தன் நன்றியைத் தெரிவிக்கிற முறையே சமாதானப் பலியாகும். அந்தக் காணிக்கையோடு அவன் புளித்த மாவினாலான அப்பங்களையும் செலுத்த வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","சமாதானப் பலியின் இரத்தத்தைத் தெளிக்கும் ஆசாரியனுக்கு இந்த அப்பங்களில் ஒன்று உரியதாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","சமாதானப் பலியின் இறைச்சியை வழங்கும் அதே நாளிலேயே உண்ண வேண்டும். தேவனுக்கு தன் நன்றியைச் செலுத்தும் வகையில் ஒருவன் சமாதானப் பலியை வழங்குகிறான். இறைச்சியில் சிறிதளவுகூட அடுத்த நாள் மீந்திருக்கக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“தேவனுக்கு அன்பளிப்பாகக் கொடுக்க விரும்பும் ஒருவன் சமாதானப் பலியைக் கொண்டுவரலாம், அல்லது விசேஷ வாக்குறுதியை ஒருவன் தேவனுக்கு செய்திருக்கலாம். இது உண்மையானால், பின் அந்த பலியின் இறைச்சியை அவன் செலுத்திய அன்றே சாப்பிட வேண்டும். அதில் மீதியாக இருந்தால் அதனை அடுத்த நாளில் சாப்பிட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","ஆனால் பலியின் இறைச்சியானது மூன்றாம் நாளும் மிஞ்சுமானால், அதனை நெருப்பிலே சுட்டு எரித்துவிட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","எவனாவது மூன்றாம் நாளிலும் மிச்சமான சமாதானப் பலியின் இறைச்சியை உண்ணுவானேயானால் அவனைப்பற்றி கர்த்தர் மகிழ்ச்சியடையமாட்டார். கர்த்தர் அந்த பலியை அவனுக்குரியதாக ஏற்றுக்கொள்ளமாட்டார். அந்த பலி அசுத்தமானதாகும். அத்தகைய இறைச்சியை எவனாவது தின்றால் அதற்குரிய பாவத்திற்கு அவனே பொறுப்பாளியாவான். ");
INSERT INTO tam2008_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“அந்த இறைச்சியானது தீட்டான எப்பொருளின் மீதாவது பட்டால் அதனையும் ஜனங்கள் உண்ணக் கூடாது. அதனை நெருப்பில் எரித்துவிட வேண்டும். சமாதான பலிக்குரிய இறைச்சியைச் சுத்தமுள்ள எவனும் உண்ணலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ஆனால் ஒருவன் கர்த்தருக்கு அசுத்தமானவனாக இருந்தும் சமாதான பலிக்குரிய இறைச்சியை உண்டுவிட்டால் அவன் அந்த ஜனங்களிடமிருந்து ஒதுக்கப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","“ஒருவன் தீட்டான ஒன்றைத் தொட்டுவிடலாம். அது மனிதர்களாலோ, தீட்டான மிருகங்களாலோ அல்லது தீட்டான வெறுக்கத்தக்கப் பொருளாலோ தீட்டாகியிருக்கலாம். ஒருவன் அதனைத் தொட்டதால் தீட்டாகிவிடுகிறான். அவன் கர்த்தருக்கு அசுத்தமானவனாக இருந்தும், சமாதானப் பலிக்குரிய இறைச்சியை உண்டால், பிறகு மற்ற ஜனங்களிடமிருந்து ஒதுக்கப்பட வேண்டும்” என்று சொன்னார். ");
INSERT INTO tam2008_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","மேலும் கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“இஸ்ரவேல் ஜனங்களிடம் நீங்கள் பசு, வெள்ளாடு, ஆடு ஆகியற்றின் கொழுப்பை உண்ணக் கூடாது என்று கூறுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","தானாக இறந்த எந்த மிருகத்தின் கொழுப்பையும் நீங்கள் பயன்படுத்தலாம் அல்லது மற்ற மிருகங்களால் கொல்லப்பட்ட மிருகக் கொழுப்பையும் நீங்கள் பயன்படுத்தலாம். ஆனால் அவற்றை ஒருபோதும் நீங்கள் உண்ணக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","எவனாவது கர்த்தருக்கு நெருப்பில் எரித்து அளித்த பலியின் இறைச்சியை உண்பானேயானால் அவன் தன் ஜனங்களிடமிருந்து ஒதுக்கப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","“நீங்கள் எங்கே வாழ்ந்தாலும் அங்கே எவரும் பறவைகளின் இரத்தத்தையோ அல்லது மிருகங்களின் இரத்தத்தையோ உண்ணக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","எவனாவது இரத்தத்தை உண்டால் அவன் தன் ஜனங்களிடம் இருந்து ஒதுக்கப்பட வேண்டும்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","மேலும் கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“இஸ்ரவேல் ஜனங்களிடம் கூறுங்கள்: ஒருவன் கர்த்தருக்கு சமாதானப் பலியைக் கொண்டு வரும்போது அதன் ஒரு பகுதியை கர்த்தருக்கு வழங்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","அப்பகுதி நெருப்பில் எரிக்கப்பட வேண்டும். அவன் தன் கைகளால் அந்த பலிகளை எடுத்துக்கொண்டு வரவேண்டும். அவன் ஆசாரியனிடம் அம்மிருகத்தின் மார்புக்கண்டத்தையும், கொழுப்பையும் தர வேண்டும். அந்த மார்புக்கண்டத்தைக் கர்த்தருக்கு முன்னால் மேலே தூக்கிப்பிடிக்க வேண்டும். இதுவே அசைவாட்டும் பலியாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","பிறகு ஆசாரியன் அந்தக் கொழுப்பை பலி பீடத்தில் எரிக்க வேண்டும். ஆனால் மார்புக்கண்டம் ஆரோனுக்கும் அவன் மகன்களுக்கும் உரியதாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","நீங்கள் அம்மிருகத்தின் வலது தொடையை சமாதானப் பலியிலிருந்து எடுத்து ஆசாரியனிடம் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","சமாதானப் பலியின் இரத்தத்தையும் கொழுப்பையும் செலுத்துகிற ஆரோனின் குமாரனாகிய ஆசாரியனுக்கு வலது முன்னந் தொடை பங்காகச் சேரும். ");
INSERT INTO tam2008_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","(கர்த்தராகிய) நான் இஸ்ரவேல் ஜனங்களிடமிருந்து சமாதானப் பலிகளிலிருந்து வலது தொடையையும், அசைவாட்டும் பலியின் மார்க்கண்டத்தையும் எடுத்துக்கொள்வேன். நான் அவற்றை ஆரோனுக்கும் அவனது மகன்களுக்கும் கொடுக்கிறேன். இஸ்ரவேலின் ஜனங்கள் இந்த விதிக்கு என்றென்றும் கீழ்ப்படிய வேண்டும்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","எரிக்கப்பட்ட காணிக்கை மூலமாகக் கிடைத்த இப்பாகங்கள் ஆரோனுக்கும் அவனது மகன்களுக்கும் கொடுக்கப்படும். ஆரோனும் அவனது மகன்களும் கர்த்தருக்கு ஊழியம் செய்யுமளவும் அவர்கள் தங்களுக்குரிய பலிகளின் பங்கைப் பெறுவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","அவர்களை ஆசாரியர்களாகத் தேர்ந்தெடுத்த காலத்திலேயே கர்த்தர் இஸ்ரவேல் ஜனங்களிடம் ஆசாரியர்களுக்குரிய பங்கை அவர்களுக்குக் கொடுக்க வேண்டும் என்று கட்டளையிட்டிருக்கிறார். அந்த ஜனங்கள் அப்பங்கை அவர்களுக்கு எப்பொழுதும் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","இவையே தகன பலிகளுக்கும், தானிய பலிகளுக்கும், குற்றபரிகார பலிகளுக்கும், பாவப் பரிகார பலிகளுக்கும், சமாதானப் பலிகளுக்கும், ஆசாரியர்களைத் தேர்ந்தெடுப்பதற்கும் உரிய சட்டங்களாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","கர்த்தர் இச்சட்டங்களை மோசேக்கு சீனாய் மலையில் கொடுத்தார். கர்த்தர் அச்சட்டங்களை, இஸ்ரவேல் ஜனங்கள் தங்கள் பலிகளை சீனாய் வனாந்தரத்துக்கே கொண்டு வந்து செலுத்தும்படி கட்டளையிட்ட அந்த நாளிலேயே கொடுத்தார். ");
INSERT INTO tam2008_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“உன்னோடு ஆரோனையும் அவனது மகன்களையும் அழைத்துக்கொள். ஆடைகளையும், அபிஷேக எண்ணெயையும் பாவப்பரிகார பலிக்கான ஒரு காளையையும், இரண்டு ஆட்டுக் கடாக்களையும், ஒரு கூடை புளிப்பில்லாத அப்பங்களையும் எடுத்துக்கொள். ");
INSERT INTO tam2008_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","பிறகு ஜனங்கள் அனைவரையும் ஆசாரிப்புக் கூடாரத்தின் வாசலில் கூட்டு” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","கர்த்தர் கட்டளையிட்டபடியே மோசே செய்து முடித்தான். ஆசரிப்புக் கூடாரத்தின் வாசலில் ஜனங்கள் கூடி வந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","மோசே ஜனங்களிடம், “இவைதான் நாம் செய்ய வேண்டும் என்று கர்த்தர் கட்டளையிட்டவை” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","பிறகு மோசே ஆரோனையும் அவனது மகன்களையும் அழைத்து வந்து அவர்களை தண்ணீரால் கழுவினான். ");
INSERT INTO tam2008_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","பின் நெய்யப்பட்ட உள்ளங்கியை ஆரோனுக்கு அணிவித்து, இடுப்பைச் சுற்றிக் கச்சையையும் கட்டினான். பிறகு அவன் மேல் அங்கியை உடுத்தி, ஏபோத்தையும் அணிவித்தான். அதன்மேல் ஏபோத்தின் அழகான கச்சையைக் கட்டினான். ");
INSERT INTO tam2008_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","பிறகு ஆரோனுக்கு நியாயத்தீர்ப்பு மார்ப்பதக்கத்தையும், அதின் பையில் ஊரீம் தும்மீம் என்பவற்றையும் வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","மோசே ஆரோனின் தலையில் தலைப்பாகையைக் கட்டி, அதன் முன் பக்கத்தில் பொற்பட்டத்தைக் கட்டினான். அது பரிசுத்த கிரீடமாக விளங்கியது. மோசே இவற்றையெல்லாம் கர்த்தர் கட்டளையிட்டபடியே செய்து முடித்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","பிறகு மோசே அபிஷேக எண்ணெயை எடுத்து பரிசுத்த கூடாரத்திற்குள்ளும் கூடாரத்திற்குள் இருந்த எல்லாப் பொருட்கள் மேலும் தெளித்தான். இவ்வாறு அனைத்தையும் மோசே பரிசுத்தமாக்கினான். ");
INSERT INTO tam2008_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","பிறகு மோசே சிறிதளவு அபிஷேக எண்ணெயை ஏழு முறை பலிபீடத்தின் மேல் தெளித்தான். அவன் பலிபீடத்தையும் அபிஷேக எண்ணெயால் பரிசுத்தப்படுத்தினான். பின் கிண்ணத்திலும் அதன் அடிப்பாகத்திலும் அபிஷேக எண்ணெயைத் தெளித்தான். இவ்வாறு மோசே கருவிகளையும் பாத்திரங்கள் அனைத்தையும் பரிசுத்தப்படுத்தினான். ");
INSERT INTO tam2008_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","பிறகு மோசே அபிஷேக எண்ணெயில் சிறிதளவு எடுத்து ஆரோனின் தலையில் ஊற்றி அவனையும் பரிசுத்தமாக்கினான். ");
INSERT INTO tam2008_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","பின்னர் மோசே ஆரோனின் மகன்களையும் அழைத்து அவர்களுக்கும் நெய்யப்பட்ட அங்கியை அணிவித்து, இடுப்புக் கச்சையைக் கட்டினான். பின் அவர்களின் தலையில் தலைப்பாகைகளை அணிவித்தான். மோசே இவற்றையெல்லாம் கர்த்தர் கட்டளையிட்டபடியே செய்து முடித்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","பிறகு மோசே பாவப்பரிகார பலிக்கான காளையைக் கொண்டு வந்தான். ஆரோனும் அவனது மகன்களும் தங்கள் கைகளை அப்பாவப் பரிகார பலியான காளையின் தலை மீது வைத்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","பின் மோசே அக்காளையைக் கொன்று அதன் இரத்தத்தை சேகரித்தான். அவன் தன் விரல்களில் இரத்தத்தைத் தொட்டு பலிபீடத்தின் மூலைகளில் பூசினான். இந்த முறையில் மோசே பலிபீடத்தைப் பலியிடுவதற்குரியதாகத் தயார் படுத்தினான். பின் பலிபீடத்தின் அடியில் அந்த இரத்தத்தை ஊற்றினான். அம்முறையில் அவன் ஜனங்களைப் பரிசுத்தப்படுத்த பலிபீடத்தைத் தயார் செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","காளையின் உட்பகுதியிலுள்ள கொழுப்பையெல்லாம் வெளியே எடுத்தான். பின் குடல்களின் மேலிருந்து கொழுப்பையும், கல்லீரல்மேலிருந்து ஜவ்வையும், இரண்டு சிறு நீரகங்களையும், அவற்றின் மேலுள்ள கொழுப்பையும் வெளியே எடுத்து, அவற்றை பலிபீடத்தின்மேல் எரித்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","ஆனால் மோசே அக்காளையின் தோலையும் இறைச்சியையும் உடல் கழிவுகளையும் கூடாரத்திற்கு வெளியே கொண்டு போய் அவைகளை எரித்தான். மோசே தனக்குக் கர்த்தர் கட்டளையிட்டபடியே இவை அனைத்தையும் செய்து முடித்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","பிறகு மோசே தகன பலிக்கான ஆட்டுக் கடாவைக் கொண்டு வந்தான். ஆரோனும் அவனது மகன்களும் செம்மறி ஆட்டுக் கடாவின் தலைமீது தங்கள் கைகளை வைத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","பிறகு அதனை மோசே கொன்று, அதன் இரத்தத்தைப் பலிபீடத்தைச் சுற்றிலும் தெளித்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","21","பின்னர் அந்த ஆட்டைப் பல துண்டுகளாக வெட்டினான். அதன் உள்பகுதிகளையும் கால்களையும் தண்ணீரால் கழுவினான். பின்னர் அனைத்தையும் பலிபீடத்தின் மீது குவித்து வைத்து எரித்தான். இது கர்த்தருக்கு செய்யப்படும் சர்வாங்க தகனபலியாகும். இதன் மணம் கர்த்தருக்கு மிகவும் பிரியமானதாக இருக்கும். கர்த்தர் கட்டளையிட்டபடியே மோசே அனைத்தையும் செய்து முடித்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","பிறகு மோசே இன்னொரு ஆட்டுக் கடாவையும் கொண்டு வந்தான். இது ஆரோனையும் அவனது மகன்களையும் ஆசாரியர்களாக நியமிப்பதற்காகப் பயன்படுத்தப்பட்டது. ஆரோனும் அவனது மகன்களும் தங்கள் கைகளை செம்மறி ஆட்டுக்கடாவின் தலையில் வைத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","பிறகு மோசே அதனைக் கொன்றான். அவன் அதன் இரத்தத்தைத் தொட்டு ஆரோனின் வலது காது முனையிலும், வலது கை பெருவிரலிலும், வலது கால் பெருவிரலிலும் தேய்த்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","பிறகு மோசே ஆரோனின் மகன்களை பலிபீடத்தின் அருகிலே அழைத்தான். மோசே அவர்களது வலது காதுகளின் முனையிலும், வலது கை பெருவிரல்களிலும், வலது கால் பெருவிரல்களிலும் அதன் இரத்தத்தைத் தேய்த்தான். பின்னர் இரத்தத்தைப் பலிபீடத்தைச் சுற்றிலும் தெளித்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","மோசே கொழுப்பையும், வாலையும், உட்பகுதி கொழுப்பையும், நுரையீரலை மூடியுள்ள கொழுப்பையும், இரண்டு சிறு நீரகங்களையும், அதன் மேல் உள்ள கொழுப்பையும், வலது கால் தொடையையும் எடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","கர்த்தரின் முன்பாகத் தினமும் வைக்கப்படும் புளிப்பில்லா அப்பக்கூடையிலிருந்து ஒரு புளிப்பான அப்பத்தையும், ஒரு எண்ணெய் கலந்த அப்பத்தையும், ஒரு மெல்லிய புளிப்பில்லா அடையையும் எடுத்தான். இவற்றை ஏற்கெனவே எடுத்த கொழுப்பின் மேலும் ஆட்டுத் தொடையின் மேலும் வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","பின்பு இவை எல்லாவற்றையும் எடுத்து ஆரோனின் கைகளிலும், அவனது மகன்களின் கைகளிலும் வைத்து அசைவாட்டும் பலியாகக் கர்த்தருக்கு முன்பாக அசைவாட்டினான். ");
INSERT INTO tam2008_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","பின்பு அவற்றை அவர்கள் கைகளிலிருந்து எடுத்து, அவற்றைப் பலிபீடத்தின் மேலுள்ள தகன பலிக்குரிய இடத்தில் போட்டு எரித்தான். இது ஆரோனையும் அவனது மகன்களையும் ஆசாரியர்களாக நியமித்ததற்கான பலியாகும். இது நெருப்பால் எரிக்கப்பட்ட காணிக்கையாகும். இதன் மணம் கர்த்தருக்கு மிகவும் பிரியமானதாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","மோசே மார்க்கண்டத்தை எடுத்து கர்த்தருக்கு முன்பாக அசைவாட்டும் பலியாக அசைவாட்டினான். இது மோசே ஆசாரியர்களை நியமித்ததற்காக அவனது பங்காகும். மோசேக்குக் கர்த்தர் இட்ட கட்டளையின்படியே இது இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","மோசே கொஞ்சம் அபிஷேக எண்ணெயையும் பலிபீடத்தில் உள்ள இரத்தத்தையும் எடுத்து, அவற்றை ஆரோனின் மேலும் அவனது ஆடைகளின் மேலும் தெளித்தான். பிறகு அவற்றை ஆரோனின் மகன்கள் மீதும் அவர்களின் ஆடைகள் மேலும் தெளித்தான். இவ்வாறு அவன் ஆரோன், அவனது மகன்கள், அவர்களின் ஆடைகள் அனைத்தையும் பரிசுத்தமாக்கினான். ");
INSERT INTO tam2008_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","பிறகு மோசே ஆரோனிடமும் அவனது மகன்களிடமும், “எனது கட்டளைகள் உங்களுக்கு நினைவிருக்கிறதா? ‘ஆரோனும் அவனது மகன்களும் இவற்றை உண்ண வேண்டும்’ என்று சொன்னேன். எனவே அப்பக் கூடையையும் ஆசாரியர்களாக நியமித்தற்கான காணிக்கை இறைச்சியையும் எடுத்துக்கொள்ளுங்கள். ஆசரிப்புக் கூடாரத்தின் நுழைவாசலிலேயே இறைச்சியை வேகவையுங்கள். அந்த இடத்திலேயே அப்பத்தையும் இறைச்சியையும் உண்ணுங்கள். நான் சொன்னபடியே செய்யுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","அப்பத்திலும் இறைச்சியிலும் ஏதாவது மிஞ்சினால் அவற்றை எரித்துவிடுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","ஆசாரியர்களைத் தேர்ந்தெடுப்பதற்கான சடங்கு ஏழு நாட்கள் நடைபெறும். எனவே ஏழு நாட்களும் ஆசரிப்புக் கூடாரத்தின் வாசலைவிட்டு விலகக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","இன்று நடந்தவை அனைத்தும் கர்த்தரின் கட்டளையின்படி நடந்தவை. உங்களை பரிசுத்தப்படுத்துவதற்காகவே அவர் இவ்வாறு கட்டளையிட்டுள்ளார். ");
INSERT INTO tam2008_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","ஏழு நாட்களாக இரவும் பகலும் நீங்கள் ஆசரிப்புக் கூடாரத்தின் வாசலிலேயே இருக்க வேண்டும். நீங்கள் கர்த்தரின் கட்டளைக்குக் கீழ்ப்படியாவிட்டால் மரித்துப்போவீர்கள். கர்த்தர் எனக்கு இந்தக் கட்டளைகளைக் கொடுத்திருக்கிறார்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","ஆரோனும் அவனுடைய மகன்களும் மோசேக்குக் கர்த்தர் கட்டளையிட்டபடியே செய்து முடித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","எட்டாவது நாள் மோசே ஆரோனையும் அவனது மகன்களையும், இஸ்ரவேல் ஜனங்களின் மூப்பர்களையும் அழைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","மோசே ஆரோனிடம், “பழுதற்ற ஒரு காளையையும், ஆட்டுக் கடாவையும் எடுத்துக் கொண்டு வா. பாவப் பரிகாரப் பலியாக காளையும், தகன பலியாக ஆட்டுக்கடாவும் இருக்கட்டும். கர்த்தருக்கு இந்த மிருகங்களைப் பலியாக அளிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","நீ இஸ்ரவேலரிடம் ஒரு வயதுள்ளதும், ‘பழுது இல்லாததுமான ஆட்டுக்கடாவைப் பாவப்பரிகார பலியாகவும், தகனபலியாகக் கன்றுகுட்டியையும், ஆட்டுக்குட்டியையும் ");
INSERT INTO tam2008_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","சமாதானப் பலியாக ஒரு காளையையும் வெள்ளாட்டுக் கடாவையும் கொண்டு வரும்படி இஸ்ரவேல் ஜனங்களிடம் கூறு. அந்த மிருகங்களையும், எண்ணெயிலே பிசைந்த தானியக் காணிக்கையையும் கர்த்தருக்குக் கொண்டு வாருங்கள்; ஏனென்றால் இன்று உங்களுக்குக் கர்த்தர் தரிசனமாவார்’ என்று சொல்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","எனவே, அனைத்து ஜனங்களும் மோசே கட்டளையிட்டபடியே அவர்கள் பொருட்களையும் எடுத்துக்கொண்டு ஆசரிப்புக் கூடாரத்துக்கு வந்து, கர்த்தரின் சந்நிதானத்தில் நின்றனர். ");
INSERT INTO tam2008_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","மோசே அவர்களிடம், “கர்த்தர் கட்டளையிட்டபடி நீங்கள் இவற்றைச் செய்ய வேண்டும், பின்னர் கர்த்தரின் மகிமை உங்களுக்குக் காணப்படும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","பிறகு மோசே ஆரோனிடம், “கர்த்தர் கட்டளையிட்டபடி செய்வதற்காக பலி பீடத்தின் அருகில் போய் பாவப்பரிகார பலியையும், தகன பலியையும் செலுத்து. அது உன்னையும் ஜனங்களையும் தூய்மைப்படுத்தும். ஜனங்களின் பலிப் பொருட்களை எடுத்து அவர்களைச் சுத்தப்படுத்தும் செயல்களைச் செய்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","எனவே ஆரோன் பலிபீடத்தின் அருகில் சென்று தனது பாவப்பரிகார பலிக்காக காளையைப் பலியிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","பிறகு ஆரோனின் மகன்கள் அதின் இரத்தத்தை ஆரோனிடம் கொண்டு வந்தனர். ஆரோன் அந்த இரத்தத்தில் தன் விரலை விட்டு பலிபீடத்தின் மூலைகளில் தடவியதுடன், மீந்திருந்த இரத்தத்தைப் பலிபீடத்தின் அடியில் ஊற்றினான். ");
INSERT INTO tam2008_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","பின் காளையின் கொழுப்பு, சிறுநீரகங்கள், கல்லீரலில் உள்ள ஜவ்வு ஆகியவற்றை எடுத்து, கர்த்தர் மோசேக்குக் கட்டளையிட்டபடியே அவற்றைப் பலி பீடத்தின்மேல் ஆரோன் எரித்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","பிறகு அவன் அதன் இறைச்சியையும் தோலையும் முகாமுக்கு வெளியே எரித்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","அடுத்து, தகன பலிக்கான மிருகத்தைக் கொன்று அதனைத் துண்டுகளாக வெட்டினான். ஆரோனின் மகன்கள் அவனிடம் அதன் இரத்தத்தை எடுத்து வந்தனர். ஆரோன் அந்த இரத்தத்தைப் பலிபீடத்தைச் சுற்றி தெளித்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","ஆரோனின் மகன்கள் தகன பலிக்குரிய துண்டுகளையும், தலையையும் ஆரோனிடம் கொடுத்தனர். ஆரோன் அவற்றை பலிபீடத்தின் மேல் எரித்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","ஆரோன் தகன பலிக்குரிய மிருகத்தின் உட்பகுதிகளையும் கால்களையும் தண்ணீரால் கழுவி அவற்றையும் பலிபீடத்தின் மேல் எரித்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","பிறகு ஆரோன் ஜனங்களின் பலிகளை கொண்டு வந்து, ஜனங்களுக்கான பாவப் பரிகார பலிக்குரிய ஒரு வெள்ளாட்டைக் கொன்றான். ");
INSERT INTO tam2008_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","ஆரோன் தகன பலிக்குரியதையும் கொண்டு வந்து கர்த்தர் கட்டளையிட்டபடியே பலி செலுத்தினான். ");
INSERT INTO tam2008_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","ஆரோன் தானியக் காணிக்கையை கொண்டு வந்து பலிபீடத்தின் மேல் வைத்தான். அதில் ஒரு கையளவு எடுத்து காலையில் செலுத்தும் பலியோடு பலிபீடத்தின் மேல் வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","காளையையும், ஆட்டுக் கடாவையும் ஆரோன் கொன்றான். இது ஜனங்களுக்குரிய சமாதானப் பலிகள் ஆகும். ஆரோனின் மகன்கள் அவற்றின் இரத்தத்தை ஆரோனிடம் கொண்டு வந்தனர். ஆரோன் அதனைப் பலிபீடத்தைச் சுற்றிலும் தெளித்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","ஆரோனின் மகன்கள் அம்மிருகங்களின் கொழுப்பு, வால், குடல்களை மூடிய ஜவ்வு, சிறுநீரகங்கள், கல்லீரலின் மேலிருந்த ஜவ்வு ஆகியவற்றைக் கொண்டு வந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ஆரோனின் மகன்கள் இக்கொழுப்புப் பாகங்களை மார்புக்கண்டங்களின் மீது வைத்தனர். ஆரோன் அந்த கொழுப்புப் பகுதிகளை பலிபீடத்தின் மீது வைத்து எரித்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","மோசே கட்டளையிட்டபடியே ஆரோன் மார்புக்கண்டங்களையும் வலதுகால் தொடையையும் அசைவாட்டும் பலியாகக் கர்த்தரின் சந்நிதானத்தில் அசைவாட்டினான். ");
INSERT INTO tam2008_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","பிறகு ஆரோன் தனது கைகளை ஜனங்களை நோக்கி உயர்த்தி ஆசீர்வாதம் செய்தான். பாவப் பரிகார பலி, தகனபலி, சமாதானப் பலி அனைத்தையும் ஆரோன் செலுத்தி முடித்த பிறகு பலிபீடத்திலிருந்து கீழே இறங்கி வந்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","மோசேயும் ஆரோனும் ஆசரிப்புக் கூடாரத்திற்குள்ளே சென்றனர். பின் அவர்கள் வெளியே வந்து ஜனங்களை ஆசீர்வதித்தனர். பிறகு கர்த்தரின் மகிமையானது அனைத்து ஜனங்களுக்கும் காணப்பட்டது. ");
INSERT INTO tam2008_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","கர்த்தருடைய சந்நிதியிருந்து நெருப்பு எழும்பி வந்து பலிபீடத்தின் மேல் இருந்த தகனபலிப் பொருட்களையும் கொழுப்பையும் எரித்தது. ஜனங்கள் இதனைப் பார்த்து ஆரவாரம் செய்தனர். தங்கள் முகங்களைத் தரையை நோக்கி தாழ்த்தினர். ");
INSERT INTO tam2008_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","பின் ஆரோனின் மகன்களாகிய நாதாபும் அபியூவும் பாவம் செய்தனர். ஒவ்வொருவனும் ஒரு நறுமண கலசத்தை எடுத்து, அதில் தேவன் அங்கீகரியாத நெருப்பைப் பயன்படுத்தி அதில் நறுமணப் பொருளைப் போட்டனர். மோசே கட்டளையிட்டுச் சொல்லியிருந்த நெருப்பை அவர்கள் பயன்படுத்தவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","எனவே கர்த்தரின் சந்நிதியிலிருந்து நெருப்பு கிளம்பி நாதாபையும் அபியூவையும் அழித்தது. அவர்கள் கர்த்தரின் சந்நிதானத்திலேயே மரித்துப் போனார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","பிறகு மோசே ஆரோனிடம், “‘என் அருகிலே வருகிற ஆசாரியர்கள் என்னை மதிக்க வேண்டும். நான் அவர்களுக்கும் எல்லா ஜனங்களுக்கும் பரிசுத்தமாக விளங்க வேண்டும்’ என்று கர்த்தர் கூறுகிறார்” என்றான். ஆகையால் ஆரோன் தன் மகன்கள் மரணமடைந்ததை குறித்து எதுவும் சொல்லவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","ஆரோனின் சிறிய தந்தையான ஊசியேலுக்கு மிஷாயேல், எல்சாபான் என்று இரண்டு மகன்கள் இருந்தார்கள். மோசே அவர்களிடம், “பரிசுத்த இடத்தின் முற்பகுதிக்குப் போய் உங்கள் சகோதரர்களின் உடல்களை அங்கிருந்து எடுத்து முகாமுக்கு வெளியே கொண்டு போங்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","மிஷாயேலும் எல்சாபானும் மோசே சொன்னபடியே அவர்களின் உடல்களை முகாமுக்கு வெளியே கொண்டு போனார்கள். நாதாப், அபியூவின் உடல்களில் ஆசாரியர்களுக்குரிய சிறப்பான உடைகள் இன்னும் இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","பிறகு மோசே ஆரோனின் வேறு இரு மகன்களான எலெயாசரிடமும், இத்தாமாரிடமும்:, “உங்கள் சோகத்தை வெளியே காண்பிக்கவோ, உங்கள் ஆடைகளை கிழிக்கவோ, உங்கள் தலை முடியை கலைக்கவோ வேண்டாம். அப்பொழுது நீங்கள் கொல்லப்படமாட்டீர்கள். கர்த்தர் நம் எல்லா ஜனங்கள் மீதும் கோபம் கொள்ளமாட்டார். இஸ்ரவேல் ஜனங்கள் அனைவரும் உங்கள் உறவினர். எனவே அவர்கள் நாதாபும் அபியூவும் மரித்ததற்காக அழட்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","ஆனால் நீங்கள் இந்த ஆசரிப்புக் கூடாரத்தின் வாசலை விட்டு கூட வெளியே போகக்கூடாது. நீங்கள் இதைவிட்டுப் போனால் மரித்துப்போவீர்கள். ஏனென்றால் கர்த்தரின் அபிஷேக எண்ணெய் உங்கள் மேல் உள்ளது” என்றான். ஆகவே ஆரோனும், எலெயாசரும், இத்தாமாரும், மோசேக்குக் கீழ்ப்படிந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","பிறகு கர்த்தர் ஆரோனிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“நீங்கள் ஆசரிப்புக் கூடாரத்திற்குள் நுழையும்போது திராட்சை ரசத்தையோ அல்லது மதுவையோ அருந்திவிட்டு வரக்கூடாது. நீங்கள் அவற்றைக் குடித்தால் மரித்துப்போவீர்கள். இந்தச் சட்டமானது என்றென்றைக்கும் உங்கள் தலைமுறைகளுக்கெல்லாம் தொடரும். ");
INSERT INTO tam2008_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","நீங்கள் பரிசுத்தமான பொருட்களுக்கும் பரிசுத்தமற்ற பொருட்களுக்கும், தீட்டுள்ள பொருட்களுக்கும், தீட்டில்லாத பொருட்களுக்கும் இடையில் தெளிவான வேறுபாட்டினை உருவாக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","கர்த்தர் தம் சட்டங்களை மோசேயிடம் கொடுத்தார். மோசே அந்த சட்டங்களை ஜனங்களிடம் கொடுத்தான். ஆரோனாகிய நீ ஜனங்களுக்கு அந்த சட்டங்களைக் கற்பிக்க வேண்டும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","ஆரோனின் மற்ற இரண்டு மகன்களான எலெயாசரும், இத்தாமாரும் உயிரோடு இருந்தனர். மோசே ஆரோனிடமும் அவனது இரு மகன்களிடமும், “பலிக்காகக் கொண்டு வந்த பலியில் இன்னும் கொஞ்சம் தானியக் காணிக்கை மிஞ்சியுள்ளது. அதில் புளிப்பு எதுவும் சேர்க்காமல் பலிபீடத்தின் அருகில் இருந்து அதை உண்ண வேண்டும், ஏனென்றால், அக்காணிக்கையானது மிக பரிசுத்தமானதாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","இது கர்த்தருக்காகச் செலுத்தப்பட்ட தகன பலியாகும். நான் உங்களுக்குக் கொடுத்த சட்டத்தின்படி இதன் ஒரு பகுதி உனக்கும் உன் மகன்களுக்கும் சொந்தமாகும். ஆனால் அவற்றைப் பரிசுத்தமான ஒரு இடத்தில் வைத்து உண்ண வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","“நீங்களும் உங்கள் மகன்களும் மகள்களும் அசைவாட்டும் பலியில் உள்ள மார்புக்கண்டத்தை உண்ண வேண்டும். நீங்கள் இதனைப் பரிசுத்தமான இடத்தில் வைத்து உண்ண வேண்டும் என்ற அவசியமில்லை, ஆனால் அவற்றைத் தீட்டில்லாத இடத்தில் வைத்து உண்ண வேண்டும். ஏனென்றால் இவை சமாதானப் பலியில் இருந்து பெறப்பட்டவை. இஸ்ரவேலின் ஜனங்கள் இதனைத் தேவனுக்கு அன்பளிப்பாகக் கொடுத்துள்ளனர். அந்த ஜனங்கள் அம்மிருகத்தின் ஒரு பாகத்தை உண்பார்கள். ஆனால் அதன் மார்புக்கண்டம் உங்களுக்கு உரியது. ");
INSERT INTO tam2008_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","ஜனங்கள் தங்கள் மிருகங்களின் கொழுப்பைப் பலியின் ஒரு பாகமாகக் கொண்டு வந்து பலிபீடத்தின் மேல் எரிக்க வேண்டும். அவர்கள் சமாதானப் பலிக்குரிய தொடையையும் அசைவாட்டும் பலிக்குரிய மார்புக்கண்டத்தையும் கொண்டு வர வேண்டும். அவை கர்த்தரின் சந்நிதானத்தில் அசைவாட்டப்படும். பின் அவை உங்களுக்கு உரிய பாகமாகக் கருதப்படும். கர்த்தர் சொன்னபடி பலியின் இப்பங்கானது என்றென்றைக்கும் உங்களுக்கும் உங்கள் பிள்ளைகளுக்கும் உரியதாகும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","மோசே பாவப்பரிகார பலிக்காகச் செலுத்தப்பட்ட வெள்ளாட்டைத் தேடினான். ஆனால் அது ஏற்கெனவே எரிக்கப்பட்டிருந்தது. அதனால் மோசேக்கு ஆரோனின் மகன்கள் எலெயாசரிடமும், இத்தாமாரிடமும் மிகுந்த கோபம் ஏற்பட்டது. ");
INSERT INTO tam2008_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","மோசே, “நீங்கள் அந்த வெள்ளாட்டை பரிசுத்தமான இடத்தில் வைத்து உண்டிருக்க வேண்டும். அது மிகவும் பரிசுத்தமானது. ஏன் அதனைக் கர்த்தரின் சந்நிதானத்தில் வைத்து உண்ணாமற் போனீர்கள்? கர்த்தர் அதனை உங்களிடம், ஜனங்களின் குற்றங்களைப் போக்கி அவர்களைப் பரிசுத்தப் படுத்துவதற்காகவே கொடுத்துள்ளார். ");
INSERT INTO tam2008_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","அந்த வெள்ளாட்டின் இரத்தமானது பரிசுத்தமான இடத்திற்குள் கொண்டுவரப்படவில்லையே. நான் கட்டளையிட்டபடி நீங்கள் அதனைப் பரிசுத்த இடத்தில் வைத்து உண்டிருக்க வேண்டும்!” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","ஆனால் ஆரோன் மோசேயிடம், “இன்றைக்கு அவர்கள் பாவப்பரிகார பலியையும், தகன பலியையும் கர்த்தருக்கு முன்னால் கொண்டு வந்தார்கள். ஆனால் எனக்கு இன்று என்ன ஏற்பட்டதென்று உங்களுக்குத் தெரியும்! பாவப்பரிகார பலிக்குரிய பாகத்தை நான் இன்று உண்டிருந்தால் கர்த்தர் மகிழ்ச்சி அடைந்திருப்பார் என்று எண்ணுகிறீரா?” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","மோசே இவற்றைக் கேட்டதும் அமைதியாகிவிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","கர்த்தர் மோசேயிடமும், ஆரோனிடமும், ");
INSERT INTO tam2008_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“இஸ்ரவேல் ஜனங்களிடம் நீங்கள் கூற வேண்டியதாவது: நீங்கள் உண்ணத்தக்க மிருகங்கள் பின்வருவனவாகும், ");
INSERT INTO tam2008_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","இரண்டாகப் பிளந்த குளம்புடைய மற்றும் அசைபோடும் மிருகங்களின் இறைச்சியை உண்ணலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","“சில மிருகங்கள் அசைபோடும். ஆனால் அவற்றுக்குப் பிளந்த குளம்புகள்Ԕஇருக்காது. அவற்றை நீங்கள் உண்ணக் கூடாது. ஒட்டகம், குழிமுயல், முயல் ஆகிய மிருகங்கள் அவ்வகையைச் சார்ந்தவை. அவை தீட்டு உள்ளவை. ");
INSERT INTO tam2008_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","இன்னும் சில மிருகங்களுக்குக் குளம்புகள் விரிந்திருக்கும். ஆனால் அசை போடாது. அவற்றையும் நீங்கள் உண்ணக் கூடாது. பன்றிகள் இத்தகையவை. எனவே இவை தீட்டுள்ளவை. ");
INSERT INTO tam2008_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","அவற்றின் இறைச்சியை உண்ணாதீர்கள்! அவற்றின் பிணத்தையும் தொடாதீர்கள்! அவை உங்களுக்குத் தீட்டுள்ளவை! ");
INSERT INTO tam2008_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“சில மிருகங்கள் கடல் தண்ணீரிலோ, ஆற்று தண்ணீரிலோ வாழ்ந்து அவற்றுக்குச் செதில்களும், சிறகுகளும் இருந்தால் அவற்றை நீங்கள் உண்ணலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","11","ஆனால் சில மிருகங்கள் கடல் தண்ணீரிலோ, ஆற்று தண்ணீரிலோ, வாழ்ந்தும் அவற்றுக்குச் செதில்களும் சிறகுகளும் இல்லாவிட்டால் அவற்றை உண்ணக் கூடாது. கர்த்தர் இத்தகைய மிருகங்கள் உண்பதற்குத் தகுந்தவையல்ல என்கிறார். இவற்றின் இறைச்சியை உண்ணாதீர்கள். இவற்றின் பிணத்தைத் தொடவும் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","எனவே தண்ணீரில் வாழ்ந்தும் செதில்களும், சிறகுகளும் இல்லாத மிருகங்களை தேவன் சொன்னபடி உண்ணத் தகாதவை என்று கருதுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“தேவன் உண்ணத்தகாத மிருகங்களைப்பற்றி சொன்னது போலவே உண்ணத்தகாத பறவைகளைப்பற்றியும் கூறியிருக்கிறார். அதாவது கழுகு, கருடன், கடலுராஞ்சி, ");
INSERT INTO tam2008_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","பருந்து, வல்லூறு வகைகள், ");
INSERT INTO tam2008_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","காக வகைகள், ");
INSERT INTO tam2008_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","நெருப்புக் கோழி, கூகை, செம்புகம், டேகை, ");
INSERT INTO tam2008_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ஆந்தைகள், நீர்க்காகம், கோட்டான், ");
INSERT INTO tam2008_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","நாரை, கூழக்கடா, குருகு, ");
INSERT INTO tam2008_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","கொக்கு, ராஜாளி வகைகள், புழுக்கொத்தி, வௌவால் ஆகியவற்றை நீங்கள் உண்ணக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“சிறகும் கால்களும் கொண்டு ஊர்ந்து செல்லும் பூச்சிகளை உண்ணக்கூடாது என்று தேவன் கட்டளையிட்டிருக்கிறார். ");
INSERT INTO tam2008_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","ஆனால் நீங்கள் தரையிலே தாவுவதற்கேற்ற வகையில் கால்களுக்கு மேல் தொடைகளைக் கொண்டவற்றை உண்ணலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","வெட்டுக்கிளி வகைகளையும், சோலையாம் என்னும் கிளி வகைகளையும் அர்கொல், ஆகாபு என்னும் கிளி வகைகளையும் நீங்கள் உண்ணலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","“ஆனால் சிறகுகளும் கால்களும் கொண்டு ஊர்ந்து செல்லும் பூச்சிகளை, கர்த்தர் உண்ணக் கூடாது என்றார். ");
INSERT INTO tam2008_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","அப்பூச்சிகள் உங்களைத் தீட்டுக்குள்ளாக்கும். எவராவது இத்தகையவற்றின் பிணத்தைத் தொட்டாலும் மாலைவரை தீட்டுள்ளவர்களாவர். ");
INSERT INTO tam2008_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","எவராவது இத்தகையவற்றின் பிணத்தைத் தொட்டு எடுத்தால் அவர்கள் தங்கள் ஆடைகளை துவைக்க வேண்டும். அவர்கள் மாலைவரை தீட்டாக இருப்பார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","27","“சில மிருகங்களுக்குப் பிளந்த குளம்புகள் இருக்கும். ஆனால் அவை சரியாக இரண்டாக பிளந்திருக்காது. சில மிருகங்கள் அசைபோடாது. சில மிருகங்கள் குளம்புகளால் நடக்காமல் உள்ளங்கால்களால் நடக்கும். இவை அனைத்தும் தீட்டுள்ளவை. அவற்றைத் தொடுகிற எவரும் மாலைவரை தீட்டுள்ளவர்களாக இருப்பார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","எவராவது இவற்றின் சடலத்தை எடுத்தால் அவர்கள் தம் ஆடைகளைத் துவைக்க வேண்டும். அவர்களும் மாலைவரை தீட்டு உள்ளவர்களாக இருப்பார்கள். அம்மிருகங்கள் உங்களுக்கு தீட்டானவை. ");
INSERT INTO tam2008_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“பெருச்சாளி, எலி, பெரிய பல்லி வகைகள், ");
INSERT INTO tam2008_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","உடும்பு, அழுங்கு, ஓணான், பல்லி, பச்சோந்தி ");
INSERT INTO tam2008_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","ஆகிய ஊர்ந்து செல்லும் பிராணிகள் அனைத்தும் உங்களுக்குத் தீட்டானவை. இவற்றின் செத்த உடலைத் தொடுகிற எவரும் மாலைவரை தீட்டுள்ளவர்களாக இருப்பார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","“மேற்சொன்ன தீட்டான மிருகங்கள் செத்து எதன் மேலாவது விழுந்தாலும் அது தீட்டாகும். அவை மரப்பொருள், ஆடை, தோல், துக்க நேரத்திற்குரிய ஆடை, வேலைக்குரிய கருவி என எதுவாக வேண்டுமானாலும் இருக்கலாம். எதுவானாலும் உடனடியாக அதை தண்ணீரால் கழுவ வேண்டும். அது மாலைவரை தீட்டாக இருக்கும். அதன் பிறகே அவை தீட்டு கழிந்து சுத்தமாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","அவற்றில் ஒன்று மண்பாத்திரத்தில் விழுந்தால், பாத்திரமும் அதில் உள்ள பொருளும் தீட்டாகிவிடும். எனவே அதனை உடைத்துப் போட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","தீட்டான மண்பாத்திரத்தில் இருந்து தண்ணீர் விழுந்து உணவுப் பொருட்கள் மேல் படுமேயானால், அவ்வுணவும் தீட்டாகிவிடும். ");
INSERT INTO tam2008_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","மரித்து தீட்டாகிப் போன மிருகத்தின் உடலானது எதன் மேலாவது விழுமானால், அதுவும் தீட்டாகிப்போகும். அது களிமண்ணாலான அடுப்பாகவோ, அல்லது மண் தொட்டியாகவோ இருக்கலாம், அவற்றை உடைத்துப் போட வேண்டும். அவை உங்களுக்குத் தீட்டாய் இருக்கட்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","“நீரூற்றும், தண்ணீருள்ள கிணறும் சுத்தமாக இருக்கும். ஆனால் எவராவது தீட்டான மிருகத்தின் செத்த உடலைத் தொட்டால் அவர்களும் தீட்டாகிவிடுவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","தீட்டான மிருகங்களின் செத்த உடலானது விதைகளின் மேல் விழுந்தால் அவை தீட்டாகாது. ");
INSERT INTO tam2008_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","ஆனால் தீட்டான மிருகங்களின் செத்த உடலின் பாகங்கள் தண்ணீர் பட்ட விதையின்மேல் பட்டால் அது உங்களுக்குத் தீட்டாயிருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“உங்களது உணவுக்கான ஒரு மிருகம் செத்தால், அதன் உடலைத் தொடுகிறவன் மாலைவரை தீட்டாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","அதன் இறைச்சியைத் தின்றவன் தன் ஆடைகளைத் துவைக்க வேண்டும். அவன் மாலைவரை தீட்டுள்ளவனாக இருப்பான். அம்மிருகங்களின் செத்த உடலைத் தூக்குகிறவன் தன் ஆடைகளைத் துவைக்க வேண்டும். இவனும் மாலைவரை தீட்டுள்ளவனாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“தரையில் ஊர்ந்து செல்லுகிற மிருகங்களைக் கர்த்தர் உண்ணத்தகாதவை என்று கூறியுள்ளார். நீங்கள் அவற்றை உண்ணக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","தரையில் ஊர்ந்து செல்லும் சகல மிருகங்களிலும் வயிற்றினால் நகர்ந்து செல்லுகின்றவற்றையும் நாலு கால்களால் நடமாடுகின்றவற்றையும் பற்பல கால்கள் உள்ளவற்றையும் உண்ண வேண்டாம். அவை தீட்டுள்ளவை. ");
INSERT INTO tam2008_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","அவை உங்களைத் தீட்டுப் பண்ணாமல் பார்த்துக்கொள்ளுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","ஏனென்றால் நான் தேவனாகிய கர்த்தர். நான் பரிசுத்தமானவர் நீங்களும் உங்களைப் பரிசுத்தமானவர்களாக வைத்துக்கொள்ளுங்கள். ஊர்வனவற்றால் உங்களைத் தீட்டாக்கிக்கொள்ளாதீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","நான் உங்களை எகிப்திலிருந்து அழைத்து வந்தேன். நான் இதைச் செய்ததால் நீங்கள் சிறப்பான ஜனங்களாக விளங்குகிறீர்கள். உங்களது தேவனாகிய நான் பரிசுத்தமானவராக இருக்கிறேன். நீங்களும் பரிசுத்தமுள்ளவர்களாக இருங்கள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","இவை அனைத்தும் மிருகம், பறவை, ஊர்வன பற்றிய விதிகள் ஆகும். இவை அனைத்தும் கடலிலும், தரையிலும் உள்ள மிருகங்களைப்பற்றியவை. ");
INSERT INTO tam2008_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","இதன் மூலம் ஜனங்கள் தீட்டுள்ள மிருகங்களுக்கும் தீட்டில்லாத மிருகங்களுக்கும் உள்ள வேறு பாட்டைக் கண்டுகொள்ளலாம். அதோடு உண்ணத் தக்க மிருகம் எது, உண்ணத்தகாத மிருகம் எது என்றும் அறிந்துகொள்ளலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","மேலும் கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“இஸ்ரவேல் ஜனங்களிடம் நீ கூற வேண்டியதாவது: ஒரு பெண், ஆண் குழந்தை ஒன்றைப் பெற்றிருந்தால், அவள் ஏழு நாட்களுக்குத் தீட்டுள்ளவளாக இருப்பாள். இது மாதவிலக்காக இருக்கும் நாட்களைப் போல் இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","எட்டாவது நாள் அந்த குழந்தை விருத்தசேதனம் பண்ணப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","பிறகு அவள் முப்பத்துமூன்று நாட்கள் இரத்த சுத்திகரிப்பு நிலையில் இருக்க வேண்டும். அந்நாட்களில் அவள் பரிசுத்தமான எந்தப் பொருட்களையும் தொடவோ, பரிசுத்தமான எந்த இடத்திற்குள்ளும் நுழையவோ கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","அவள் ஒரு பெண் குழந்தையைப் பெற்றெடுத்தால் அவள் இரு வாரங்களுக்குத் தீட்டாக இருப்பாள். அந்நாட்கள் அவளுக்கு மாத விலக்கான நாட்களைப் போன்றே கருதப்படும். இரத்த சுத்திகரிப்புக்கு அவளுக்கு அறுபத்தாறு நாட்கள் தேவைப்படும். ");
INSERT INTO tam2008_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ஒரு பெண், ஆண் அல்லது பெண் பிள்ளையைப் பெற்றதற்காக அவளுடைய சுத்திகரிப்பின் நாட்கள் முடிந்தபின் ஆசரிப்புக் கூடாரத்திற்குச் சிறப்பான பலிகளைக் கொண்டு வர வேண்டும். அவள் ஆசாரியனிடம் ஆசரிப்புக் கூடாரத்தின் வாசலில் பலிகளை வழங்க வேண்டும். அவள் ஓராண்டு நிறைந்த ஆட்டுக் குட்டியை தகன பலிக்காகவும், ஒரு புறாக்குஞ்சு அல்லது காட்டுப்புறாவைப் பாவப்பரிகார பலிக்காகவும் கொண்டு வர வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","8","ஒரு பெண்ணுக்கு ஆட்டுக் குட்டியைக் கொடுக்க முடியாவிட்டால் அவள் இரண்டு புறாக்களையாவது அல்லது இரண்டு புறாக் குஞ்சுகளையாவது கொண்டு வரலாம். இவற்றில் ஒரு புறா தகன பலிக்காகவும் இன்னொரு புறா பாவப்பரிகார பலிக்காகவும் பயன்படும். ஆசாரியன் இவற்றைக் கர்த்தரின் சந்நிதானத்தில் பலியிட வேண்டும். இதன் மூலம் ஆசாரியன் அவளுக்காக பாவ நிவாரணம் செய்ய வேண்டும். அவள் அப்படியே சுத்தமாவாள். இவையே ஆண் அல்லது பெண் குழந்தைப் பெற்ற ஒரு புதிய தாய்க்குரிய விதிகள் ஆகும்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","கர்த்தர் மோசேயிடமும் ஆரோனிடமும், ");
INSERT INTO tam2008_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“ஒரு மனிதனின் தோல்மீது வீக்கமோ அல்லது தடிப்போ, அல்லது வெள்ளைப் புள்ளியோ காணப்படலாம். அவை தொழுநோயின் அறிகுறியாய் இருந்தால் அவனை ஆசாரியனான ஆரோன் அல்லது அவனது மகன்கள் முன்னால் அழைத்துவர வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","ஆசாரியன் அவனது தோலில் ஏற்பட்ட நோயைக் கவனித்துப் பார்க்கவேண்டும். நோயுள்ள இடத்தின் முடிகள் வெளுத்திருந்தாலும் நோயுள்ள இடம் மற்ற தோலைவிட பள்ளமாக இருந்தாலும் அந்நோய் தொழுநோயாக இருக்கும். எனவே ஆசாரியன் அவனைத் தீட்டுள்ளவன் என்று அறிவிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","“சில நேரங்களில் நோயாளியின் உடம்பில் வெள்ளைப் புள்ளிகள் ஏற்படலாம். ஆனால் அவை தோலின் பரப்பைவிட ஆழமாக இல்லாமல் இருக்கலாம். அப்பகுதியிலுள்ள முடி வெள்ளை ஆகாமல் இருக்கலாம். அப்போது, ஆசாரியன் அந்நோயாளியைத் தனியாக ஏழு நாட்கள் ஒதுக்கி வைத்திருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ஏழாவது நாளில் ஆசாரியன் நோயாளியைக் கவனித்துப் பார்க்க வேண்டும். அப்போது புண் மாறியிருக்காவிட்டாலோ, தோலில் மேலும் பரவி இருக்காவிட்டாலோ மேலும் ஏழு நாட்களுக்கு அந்நோயாளியைத் தனியே வைத்திருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","அந்த ஏழு நாட்களும் முடிந்த பிறகு ஆசாரியன் அந்த நோயாளியை மீண்டும் பார்க்கவேண்டும். அப்போது புண்கள் ஆறி இருந்தாலோ, மற்ற பகுதிகளில் பரவாமல் இருந்தாலோ ஆசாரியன் அவன் குணமாகிவிட்டதை அறிவிக்க வேண்டும். அந்தப் புண் வெறும் வடு மட்டுமே. அவன் தன் ஆடைகளைத் தோய்த்து மீண்டும் சுத்தமாக இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","“நோயாளி தன்னை ஆசாரியனிடம் காட்டி சுத்தமுள்ளவனாகத் தீர்மானித்த பிறகும் ஒரு வேளை வெண்திட்டு உடலில் பரவலாம். அதையும் ஆசாரியனிடம் காட்ட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","அப்பொழுது வெண்திட்டு தோலிலே படர்ந்து வருகிறது என்று ஆசாரியன் கண்டால் அவனைத் தீட்டானவன் என்று அறிவிக்க வேண்டும். அது தொழுநோய் ஆகும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“ஒருவனுக்குத் தொழுநோய் ஏற்பட்டால் அவனை ஆசாரியனிடம் கொண்டு வர வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","ஆசாரியன் அவனைச் சோதித்துப் பார்க்க வேண்டும். தோலிலே வெள்ளைத் தடிப்புகள் இருந்தாலும், முடி வெண்மையாகியிருந்தாலும், தோலானது கொப்புளங்களில் காய்ந்து இருந்தாலும் ");
INSERT INTO tam2008_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","அது நெடுநாளாகவே அவன் தோலில் உள்ள தொழுநோயாகவே கருதப்பட வேண்டும். ஆசாரியன் உடனே அவனைத் தீட்டுள்ளவன் என்று அறிவிக்க வேண்டும். அந்நோயாளியை மற்றவர்களிடமிருந்து கொஞ்சக்காலம் தனியே பிரித்துவைக்க வேண்டிய தேவையில்லை. ஏனென்றால் அவன் ஏற்கெனவே தீட்டுள்ளவன். ");
INSERT INTO tam2008_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“சில வேளைகளில் தொழுநோயானது ஒருவனின் உடல் முழுவதும் பரவியிருக்கலாம். தலை முதல் கால்வரை அந்நோய் அவனை மூடி இருக்கலாம். ஆசாரியன் அவனை முழுமையாகச் சோதித்துப் பார்க்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","அவனது உடல் முழுவதும் வெள்ளையாகியிருந்தால் அவனைச் சுத்தமுள்ளவன் என்று ஆசாரியன் அறிவிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","எனினும் கொஞ்சம் புண்நிறைந்த தோல் இருந்தால் அவன் தீட்டுள்ளவனே. ");
INSERT INTO tam2008_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","ஆசாரியன் அதனைக் கண்டதும் அவனைத் தீட்டுள்ளவனாக அறிவிக்க வேண்டும் புண்நிறைந்த தோல் தீட்டுள்ளது. அது தொழுநோய். ");
INSERT INTO tam2008_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","“தோலின் நிறம்மாறி வெண்மையானால் பின் அவன் ஆசாரியனிடம் வரவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","ஆசாரியன் அவனைச் சோதித்துப் பார்க்க வேண்டும். நோயுள்ள இடம் வெண்மையாகியிருந்தால் அவனது நோய் குணமாகிவிட்டதென்று பொருள். எனவே, அவனைத் தீட்டு இல்லாதவன் என்று ஆசாரியன் அறிவிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“ஒருவனுக்குத் தோலின் மேல் புண் ஏற்பட்டு அது குணமாகலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","அதே புண் பிற்பாடு வெள்ளைத் தடிப்பாகவோ அல்லது சிவந்த நிறத்தில் வெண் புள்ளிகளாகவோ மாறக்கூடும். அப்படி நேரும்போது அப்புண்ணை ஆசாரியனிடத்தில் காட்ட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","ஆசாரியன் அவற்றைச் சோதித்துப் பார்க்க வேண்டும். அப்புண்ணானது தோலின் பரப்பைவிட ஆழமாக இருந்தாலோ, அதிலுள்ள முடிகள் வெண்மையானாலோ அது தொழுநோய் என்றே கருதப்பட வேண்டும். உடனே அவனைத் தீட்டுள்ளவனாக அறிவிக்க வேண்டும். அது புண்ணில் ஏற்பட்ட தொழுநோயாகும். தொழுநோயானது அப்புண்ணின் உள்ளிருந்து உருவாகியுள்ளது. ");
INSERT INTO tam2008_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","சோதிப்பின்பொழுது தடிப்பின் மேற் பகுதியில் வெள்ளை முடி இல்லாதிருந்தாலும், தோலில் அவ்வளவு ஆழமற்றதாக ஆனால் வெளுத்து இருந்தாலும், ஆசாரியன் அவனை ஏழு நாட்கள் தனியே பிரித்து வைக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","பின்பு வெள்ளைத் தடிப்பு அதிக அளவில் தோலில் படர்ந்திருந்தால், ஆசாரியன் அவனைத் தீட்டுள்ளவன் என்று அறிவிக்க வேண்டும். அது தொழுநோய்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","அந்த வெள்ளைப்படரானது அதிகப்படாமல் பழைய அளவில் நின்றிருக்குமானால் அதுவெறும் புண்ணின் தழும்புதான். எனவே அவனைச் சுத்தமுள்ளவன் என்று ஆசாரியன் அறிவிக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","25","“ஒருவனது உடம்பின் மேல் நெருப்புப்பட்டு வெந்து அது ஆறிப்போன இடத்தில் தோலில் நிறம் இழந்தோ, அல்லது வெண்மையாகவோ இருக்கலாம். ஆசாரியன் அதனைச் சோதித்துப் பார்க்க வேண்டும். வெண்மையான தடிப்பு தோலுக்கு அடியில் ஆழமாக இருந்தாலும் தடிப்பின் மேல் உள்ள முடியின் பரப்பு வெளுத்திருந்தாலும், அதைத் தொழுநோயாகக் கருதலாம். தொழுநோய் வெந்த இடத்தில் வெளிப்பட்டு வளர்ந்து பெருகிவிட்டது. ஆகவே ஆசாரியன் அவனைத் தொழுநோயாளி என்று அறிவிக்கலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","ஆசாரியன் சோதித்துப் பார்க்கும்போது, படரிலே வெள்ளை முடி இல்லை என்றாலோ அல்லது படர் மற்றப் பகுதிகளைவிடக் குழியாமல் இருந்தால் அவனை ஏழு நாள் தனியே பிரித்து வைத்திருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ஏழாம் நாளில் அவனை மீண்டும் சோதித்துப் பார்க்க வேண்டும். அது தோலில் அதிகமாகப் பரவியிருந்தால் ஆசாரியன் அவனைத் தீட்டுள்ளவன் என்று அறிவிக்க வேண்டும். அது தொழுநோய்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","தோலில் படரானது பரவாமல் இருந்தாலோ அல்லது படர் மற்ற பகுதிகளைவிடப் பள்ளமாக இல்லாமல் இருந்தாலோ அது வெந்ததால் உண்டான கொப்புளம் என்று எண்ண வேண்டும். அவனை ஆசாரியன் சுத்தமானவன் என்று அறிவிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“ஒருவனுக்குத் தலையில் அல்லது தாடியில் எரிச்சல் உண்டாகலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ஆசாரியன் அதனைச் சோதித்து பார்க்க வேண்டும். அவ்விடம் மற்ற தோலைவிட பள்ளமும் அதிலே உள்ள முடிகள் பொன்நிறமும், மிருதுவாயும் இருந்தால் அவனைத் தீட்டுள்ளவன் என்று அறிவிக்க வேண்டும். அது சொறி தொழுநோய். ");
INSERT INTO tam2008_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","ஆசாரியன் இதனைப் பார்க்கும் போது அவ்விடம் மற்ற தோலைவிட பள்ளமாய் இராமல் இருக்கலாம். அதிலே கறுமை யான முடிகள் இல்லாமல் இருக்கலாம். அவ்வாறானால் அவனை ஏழு நாட்கள் தனியே அடைத்து வைக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ஏழாவது நாள் அப்புண்ணை ஆசாரியன் மீண்டும் சோதித்துப் பார்க்க வேண்டும். அந்த நோய் பரவாமல் இருந்தாலோ அல்லது பொன் நிறமாக முடி மாறாமல் இருந்தாலோ அல்லது நோயுள்ள இடம் மற்ற தோல் பகுதியை விடப் பள்ளம் இல்லாமல் இருந்தாலோ, ");
INSERT INTO tam2008_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","அவன் சொறியுள்ள இடம் தவிர மற்ற இடத்தை மழித்துக்கொள்ள வேண்டும். மேலும் அவனை ஏழு நாள் தனியே பிரித்து வைக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ஏழாம் நாளில் ஆசாரியன் மீண்டும் சோதித்து பார்க்கும்போது சொறி பரவாமலும், அவ்விடம் மற்ற இடங்களைவிடப் பள்ளமில்லாமலும் இருந்தால் அவனை ஆசாரியன் சுத்தமுள்ளவன் என்று அறிவிக்க வேண்டும். அவன் தன் ஆடைகளைத் துவைத்தபின் சுத்தமாய் இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","ஆனால் அந்தச் சொறி அதற்குப்பிறகு பரவினால் ");
INSERT INTO tam2008_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","மீண்டும் ஆசாரியன் அவனைச் சோதிக்க வேண்டும். சொறி தோலில் பரவியிருந்தாலோ, முடியும் பொன் நிறமாகியிருந்தாலோ ஆசாரியன் மறுபடியும் சோதிக்க வேண்டியதில்லை. அவன் தீட்டுள்ளவனே. ");
INSERT INTO tam2008_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","அவன் சோதிக்கும்போது சொறி நீங்கியிருந்தால், கறுமையான முடிகள் முளைத்திருந்தால் சொறி குணமாயிற்று என்று பொருள். அவன் சுத்தமானவன். ஆசாரியன் அவனைச் சுத்தமுள்ளவன் என்று அறிவிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“யாராவது ஒருவனுக்கு உடல்மீது வெள்ளைப் புள்ளிகள் ஏற்பட்டால், ");
INSERT INTO tam2008_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","அதனை ஆசாரியன் சோதித்து பார்க்க வேண்டும். தோலில் மங்கின வெள்ளைப் புள்ளிகள் இருந்தால் அது அவ்வளவாகப் பாதிப்பற்ற வெள்ளைத் தேமல். அவனும் சுத்தமுள்ளவனே. ");
INSERT INTO tam2008_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“ஒருவனுடைய தலைமுடி உதிரக்கூடும், அவன் சுத்தமானவனே. அது ஒரு வகை வழுக்கை ஆகும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","தலையைச் சுற்றியுள்ள பகுதியில் இருந்து முடி உதிரக்கூடும். அவனும் சுத்தமானவனே, அதுவும் இன்னொரு வகை வழுக்கை ஆகும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","ஆனால் வழுக்கையான இடத்தில் சிவப்பாகவோ அல்லது வெண்மையாகவோ தடிப்புகள் இருக்குமேயானால், அது தோல் வியாதி ஆகும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","ஆசாரியன் அதனைச் சோதிக்க வேண்டும். அவனது வழுக்கைத் தலையிலாவது அரை வழுக்கைத் தலையிலாவது மற்ற உறுப்புகளின் மேல் உண்டாகும் குஷ்டத்தைப்போல் சிவப்பு கலந்த வெண்மையான தடிப்பு இருந்தால் அவன் தொழுநோயாளி. ");
INSERT INTO tam2008_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","அவன் தீட்டுள்ளவன் என்று ஆசாரியன் அறிவிக்க வேண்டும். அவனது நோய் தலையில் உள்ளது. ");
INSERT INTO tam2008_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“ஒருவனுக்கு தொழுநோய் இருந்தால் அவன், மற்றவர்களை எச்சரிக்க வேண்டும். அவன் ‘தீட்டு தீட்டு’ என்று கத்த வேண்டும். அவனது ஆடைகள் கிழிக்கப்பட்டிருக்க வேண்டும். அவன் தன் தலை முடியை நன்றாக வளர்க்க வேண்டும். அவன் தன் வாயை மூடி மறைத்துக்கொண்டிருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","அந்நோய் அவனிடம் இருக்கும்வரை அவன் தீட்டுள்ளவனாகக் கருதப்படுகிறான். எனவே அவன் தனியே குடியிருக்க வேண்டும். அவன் வீடு கூடாரத்திற்கு அப்பால் இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","48","“ஆட்டுமுடி அல்லது பஞ்சால் ஆன ஆடையில் நோய் இருக்கும். அந்த ஆடை நெய்யவோ பின்னவோபட்டிருக்கலாம். தோல் துண்டிலோ அல்லது தோலால் ஆன ஆடையிலோ நோய் இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","அதில் பச்சை அல்லது சிவப்புப் புள்ளிகள் காணப்பட்டால் அதை ஆசாரியனுக்குக் காட்ட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","ஆசாரியன் அதைச் சோதித்துப் பார்த்துவிட்டு ஏழு நாட்கள் தனியே அடைத்து வைக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","ஏழாம் நாள் ஆசாரியன் அவனைச் சோதித்துப் பார்க்க வேண்டும். ஆடையிலாவது பாவிலாவது, தோல் துண்டிலாவது, தோலால் ஆன ஆடையிலாவது அது அதிகப்பட்டிருந்தால் அது அரிக்கிற தொழுநோய் என்று கருதலாம். அது தீட்டு உள்ளது. ");
INSERT INTO tam2008_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","அந்த நோய் இருக்கிற மயிராடை, நூலாடை, தோலாடை போன்றவற்றை ஆசாரியன் சுட்டெரிக்க வேண்டும். இது அரிக்கிற தொழுநோய். எனவே அதனை நெருப்பில் சுட்டெரிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“ஆசாரியன் சோதிப்பின்போது அரிப்பானது மேலும் பரவவில்லை என்பது உறுதியானால், அந்த ஆடையையோ அல்லது தோலையோ துவைக்க வேண்டும். அது தோலா அல்லது துணியா அல்லது நெய்யப்பட்டதா அல்லது பின்னப்பட்டதா என்பதில் வித்தியாசமில்லை. ");
INSERT INTO tam2008_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","பிறகு தோல் ஆடையை அல்லது துணியைத் துவைக்கும்படி ஆசாரியன் ஜனங்களுக்கு ஆணையிட வேண்டும். பிறகு துணியை ஏழு நாட்களுக்குப் பிரித்துத் தனியே வைக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","அதற்குப் பின்பு அதை மீண்டும் சோதிக்க வேண்டும். அந்த அரிப்பானது நிறம் மாறாமல் இருந்தால் அது தீட்டு என எண்ண வேண்டும். அரிப்பு பரவாமல் போனாலும் கூட, அதை நெருப்பில் சுட்டெரிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","“தோல் ஆடையை அல்லது துணியைப் பார்க்கும்போது அரிப்புப் பகுதி மங்கியிருந்தால், அரித்த பகுதியை மட்டும் தோலாடையில் இருந்தும் அல்லது துணியில் இருந்தும் நெய்யப்பட்ட துணியா அல்லது பின்னப்பட்ட துணியா என்று பாராமல் ஆசாரியன் தனியே வெட்டி எடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","அரிப்பானது மீண்டும் துணியிலோ அல்லது தோல் ஆடையிலோ வரக் கூடும். அப்போது அத்துணியை அல்லது தோலை நெருப்பில் சுட்டெரிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","கழுவிய பிறகு அந்நோய் அதைவிட்டு போய்விட்டதென்றால், மீண்டும் கழுவப்பட வேண்டும். அப்போதுதான் அது சுத்தமாகும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","இவையே, தோலாடை அல்லது நூலாடை, பின்னப்பட்டது அல்லது நெய்யப்பட்ட ஆடைகளின் மேல் தோன்றும் தொழுநோய் பற்றிய விதிகள் ஆகும் என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","மேலும் கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“இவை தொழுநோயாளிகள் குணமாவதற்கும், அவர்களைச் சுத்தப்படுத்துவதற்கு முரிய விதி முறைகளாகும். “தொழுநோயுள்ள ஒருவனை ஆசாரியன் சோதித்துப் பார்க்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ஆசாரியன் கூடாரத்திற்கு வெளியே போய் அவன் நோய் குணமாகிவிட்டதா என்று பார்க்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","அவனது நோய் குணமாகியிருந்தால் அவனிடம் கீழ்க்கண்டவற்றை செய்யும்படி கூறவேண்டும். முதலில் சுத்தமான இரண்டு குருவிகளையும், கேதுருக் கட்டைகளையும், சிவப்பு நூலையும், ஈசோப்பையும் வாங்கி வரவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","பின்னர், ஆசாரியன் அதில் ஒரு குருவியை மண்பாண்டத்தில் உள்ள ஊற்று தண்ணீரில் கொல்ல வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","அடுத்து ஆசாரியன், உயிருள்ள குருவியையும் அதோடு கேதுரு கட்டையையும் சிவப்பு நூலையும் ஈசோப்பையும் எடுத்து அதில் கொல்லப்பட்டக் குருவியின் இரத்தத்தைத் தோய்க்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","பின் ஆசாரியன் நோய் நீங்கப்பட்டவனின் மேல் ஏழுதரம் தெளித்து அவனைச் சுத்தப்படுத்த வேண்டும். பிறகு ஆசாரியன் அவனைத் தீட்டில்லாதவன் என அறிவிக்க வேண்டும். பின் ஆசாரியன் திறந்த நிலப்பரப்பிற்கு சென்று உயிருள்ள குருவியை விட்டுவிட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“பிறகு அவன் தன் ஆடைகளை துவைத்து, தன் முடியை மழித்துக்கொண்டு, தண்ணீரில் குளிக்க வேண்டும். பின்னரே அவன் சுத்தமாவான். அதன் பின் அவன் கூடாரத்திற்குள் செல்லலாம். ஆனால் அவன் ஏழு நாட்கள் கூடாரத்திற்கு வெளியிலேயே தங்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","ஏழாவது நாள் அவன் தன் தலை முடி, தாடி, புருவம் என அனைத்து முடியையும் மழித்துவிட வேண்டும். பின் தன் ஆடைகளைத் துவைத்துக் குளிக்க வேண்டும். இதன்பின் அவன் சுத்தமாவான். ");
INSERT INTO tam2008_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“எட்டாவது நாள், எவ்விதமான குறையு மற்ற இரண்டு ஆட்டுக் குட்டிகளையும், ஒரு வயதான எக்குறையுமில்லாத பெண் ஆட்டுக்குட்டியையும் தோல் வியாதியால் பாதிக்கப்பட்டவன் தானியக் காணிக்கைக்காக கொண்டு வரவேண்டும். இருபத்து நான்கு கிண்ணங்கள் எண்ணெயிலே பிசைந்த மெல்லிய மாவையும், ஆழாக்கு ஒலிவ எண்ணெயையும் கொண்டு வரவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","அவனை தீட்டில்லாதவன் என்று அறிவித்த அதே ஆசாரியன் நோயுற்றவனையும் அவனது பலிப் பொருட்களையும் கர்த்தருக்கு முன்னால் ஆசரிப்புக் கூடாரத்திற்கு கொண்டு வர வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","ஆசாரியன் ஒரு ஆண் ஆட்டுக்குட்டியை குற்ற பரிகார பலியாக செலுத்த வேண்டும். அவன் அதனையும் சிறிது எண்ணெயையும் அசைவாட்டும் பலியாகப் பயன்படுத்த வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","பிறகு ஒரு ஆண் ஆட்டுக்குட்டியை பாவப் பரிகார பலியையும் தகனபலியையும் கொல்லுகிற பரிசுத்த இடத்தில் கொல்ல வேண்டும். குற்ற நிவாரண பலியானது பாவப்பரிகார பலி போன்றதாகும். அது ஆசாரியனுக்குரியது. அது மிகவும் பரிசுத்தமானது. ");
INSERT INTO tam2008_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","“ஆசாரியன் குற்ற பரிகார பலியின் இரத்தத்தில் சிறிதளவு எடுத்துக்கொள்ள வேண்டும். அதனைச் சுத்திகரிக்கப்பட வேண்டியவனின் வலது காது நுனியில் தடவ வேண்டும். அது அவனைச் சுத்தமாக்கும். பிறகு கொஞ்சம் இரத்தத்தை அவனது வலது கையின் பெருவிரலிலும், வலதுகால் பெரு விரலிலும் தடவ வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","மேலும் ஆசாரியன் எண்ணெயை எடுத்து தனது இடது உள்ளங்கையில் ஊற்றி ");
INSERT INTO tam2008_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","வலது கை விரலில் தொட்டு ஏழுமுறை கர்த்தரின் சந்நிதியில் தெளிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","பிறகு ஆசாரியன் தன் உள்ளங்கையில் உள்ள மீதி எண்ணெயை எடுத்து சுத்திகரிக்கப்படவேண்டியவனின் வலது காது நுனியிலும், வலது கை பெருவிரலிலும், வலது கால் பெருவிரலிலும் தடவ வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","மேலும் மீதியுள்ள எண்ணெயை அவனது தலையிலே தடவ வேண்டும். இவ்வாறு, ஆசாரியன் கர்த்தருக்கு முன்பாக அவனைச் சுத்தப்படுத்தி விடுகிறான். ");
INSERT INTO tam2008_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“பின் ஆசாரியன் பாவப்பரிகார பலியைச் செலுத்தி சுத்திகரிக்கப்படவேண்டியவனின் தீட்டு நீங்க அவனுக்குப் பாவப்பரிகாரம் செய்துவிட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","பின்பு தகன பலிக்குரிய மிருகத்தைக் கொன்று அதனோடு தானியக் காணிக்கையையும் பலிபீடத்தின்மேல் வைத்து அவனுக்காகப் பாவப்பரிகாரம் செய்ய வேண்டும். அப்போது அவன் சுத்தமாவான். ");
INSERT INTO tam2008_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“ஆனால் ஒரு ஏழையால் இத்தகைய பலியைக் கொடுக்க இயலாது. அப்போது அவன் ஒரு ஆண் ஆட்டுக்குட்டியை மட்டும் கொண்டு வந்தால் போதும். அது அசைவாட்டும் பலியாகும். ஆசாரியன் இதன் மூலம் அவனைச் சுத்தப்படுத்தலாம். இதற்கு ஆசாரியன் எண்ணெயுடன் கலந்த மிருதுவான மாவிலே 8 கிண்ணம் அளவு எடுத்துக்கொள்ள வேண்டும். இது தானியக் காணிக்கைக்காக உபயோகப்படுத்தப்படும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","இரண்டு காட்டுப் புறாக்களையாவது அல்லது இரு புறாக் குஞ்சுகளையாவது கொடுக்க வேண்டும். இவற்றில் ஒன்று பாவப்பரிகார பலிக்கும் இன்னொன்று தகன பலிக்கும் உரியது. ");
INSERT INTO tam2008_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“எட்டாவது நாளில் மேற்கண்ட எல்லாப் பொருட்களையும் எடுத்துக்கொண்டு அவன் ஆசரிப்புக் கூடாரத்திற்கு ஆசாரியனிடம் வர வேண்டும். அவை கர்த்தருக்கு முன்பு அளிக்கப்பட வேண்டும். அதனால் அவன் சுத்தமாவான். ");
INSERT INTO tam2008_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","ஆசாரியன் ஆண் ஆட்டுக்குட்டியைக் குற்றப்பரிகார பலிக்காக எடுத்துக்கொள்வான். இதையும் ஆழாக்கு எண்ணெயையும் கர்த்தருடைய சந்நிதியில் அசைவாட்டும் பலியாக செலுத்துவான். ");
INSERT INTO tam2008_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","பிறகு அந்த ஆண் ஆட்டுக்குட்டியை குற்றப்பரிகார பலிக்காகக் கொல்லுவான். அதன் இரத்தத்தைக் கொஞ்சம் எடுத்து, சுத்திகரிக்கப்பட வேண்டியவனின் வலது காதின் நுனியிலும், வலதுகை பெருவிரலிலும், வலது கால் பெருவிரலிலும் தடவுவான். ");
INSERT INTO tam2008_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","ஆசாரியன் தனது இடது உள்ளங்கையில் எண்ணெயை ஊற்றிக்கொண்டு ");
INSERT INTO tam2008_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","பின் வலது கை விரலால் தொட்டு கர்த்தருடைய சந்நிதியில் ஏழுதரம் தெளிப்பான். ");
INSERT INTO tam2008_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","மிச்சமிருக்கிற எண்ணெயைத் தொட்டு இரத்தத்தை தடவிய இடங்களில் எல்லாம் தடவுவான். அதனை அவனின் வலது காதின் நுனியிலும், வலது கை பெருவிரலிலும், வலது கால் பெருவிரலிலும் தடவுவான். ");
INSERT INTO tam2008_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","உள்ளங்கையில் மேலும் மிச்சமிருக்கிற எண்ணெயை அவனது தலையில் தடவுவான். இவ்வாறு ஆசாரியன் அவனைக் கர்த்தருக்கு முன்பு சுத்தப்படுத்த வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","“பிறகு ஆசாரியன் ஒரு காட்டுப் புறா வையாவது, புறாக்குஞ்சையாவது பலியிட வேண்டும். (ஒருவன் எவற்றைக் கொடுக்க முடியுமோ அவற்றையே காணிக்கையாக அளிக்க வேண்டும்.) ");
INSERT INTO tam2008_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","இவற்றில் ஒன்றை பாவப்பரிகார பலியாகவும், இன்னொன்றை தகன பலியாகவும் செலுத்த வேண்டும். தானியக் காணிக்கையோடு இதனைச் சேர்த்துச் செலுத்த வேண்டும். இவ்வாறு ஆசாரியன் அவனைக் கர்த்தருக்கு முன்பு சுத்திகரிப்பு செய்யவேண்டும். அவனும் சுத்திகரிக்கப்படுவான்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","தொழுநோயுற்றவன் குணம் அடைந்தபின் சுத்திகரிப்புச் செய்யவேண்டிய விதிகள் இவையாகும். முறையான பலிகளைத் தரமுடியாதவர்கள் இவ்வாறு சில விதிகளைக் கடைப்பிடிக்கலாம் என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","மேலும் கர்த்தர் மோசேயையும் ஆரோனையும் பார்த்து, ");
INSERT INTO tam2008_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“நான் உங்களுக்குக் கானான் தேசத்தைக் கொடுத்திருக்கிறேன். நீங்கள் அங்கு போய்ச் சேர்ந்த பின்பு உங்களில் சிலரது வீட்டிலே தொழுநோய் ஏற்படும்படி செய்தால் ");
INSERT INTO tam2008_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","அப்போது அந்த வீட்டிற்கு உரியவன் ஆசாரியனிடம் வந்து, ‘என் வீட்டில் தொழுநோய் போன்று ஒன்று இருப்பதைப் பார்த்தேன்’ என்று சொல்ல வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","“பிறகு அந்த ஆசாரியன், வீட்டில் உள்ள யாவற்றையும் வெளியே எடுத்துச் செல்ல ஜனங்களிடம் கூறவேண்டும். ஆசாரியன் அந்த வீட்டில் உள்ள அனைத்து பொருட்களும் தீட்டுக்குரியவை என்று சொல்லத் தேவை இருக்காது. வீட்டிலுள்ள பொருட்களை எல்லாம் வெளியே வைத்த பிறகுதான் ஆசாரியன் வீட்டிற்குள் நுழைய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","ஆசாரியன் அந்த வீட்டிற்குள் நுழைந்து தொழுநோயுள்ள இடங்களைக் கவனித்து பார்க்க வேண்டும். அப்போது சுவரில் கொஞ்சம் பச்சையும், சிவப்புமான குழிகள் சுவற்றின் மற்ற பகுதிகளைவிடப் பள்ளமாக இருப்பதைக் கண்டால், ");
INSERT INTO tam2008_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ஆசாரியன் வெளியே வந்து அவ்வீட்டை ஏழு நாட்கள் பூட்டிவைக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","“ஏழாம் நாள் ஆசாரியன் திரும்பப் போய், சோதித்துப் பார்க்க வேண்டும். தோஷம் வீட்டுச் சுவர்களில் பரவியிருந்தால் ");
INSERT INTO tam2008_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ஆசாரியன் தோஷம் படிந்த கற்களைச் சுவற்றிலிருந்து பெயர்த்தெடுத்துப் பட்டணத்துக்கு வெளியே ஒரு குறிப்பிட்ட அசுத்தமான இடத்திலே கொண்டு போய் போடச் சொல்ல வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","வீட்டினுள்ளே தரையைப் பெயர்த்து, அதையும் வெளியே அசுத்தமான இடத்தில் போட்டுவிட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","பிறகு சுவரில் புதிய கற்களை வைத்துப் பூசவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“கற்களைப் பெயர்த்து வீட்டைச் செதுக்கி புதிதாய்ப் பூசின பிறகும் நோய் திரும்பவும் வந்தால், ");
INSERT INTO tam2008_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ஆசாரியன் போய் அந்த வீட்டைச் சோதித்துப் பார்க்க வேண்டும். அந்த நோய் மேலும் சுவரில் பரவி இருந்தால் அதனை வீட்டை அரிக்கிற தொழுநோயாகக் கருதவேண்டும். அது தீட்டுள்ளதாக இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","எனவே வீடு முழுவதையும் இடித்து அதன் கற்களையும் மரங்களையும் காரையையும் ஊருக்கு வெளியே அசுத்தமான தனி இடத்தில் கொட்டிவிட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","அந்த வீட்டிற்குள் நுழைகிற எவனும் மாலைவரை தீட்டுள்ளவனாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","அந்த வீட்டில் எவனாவது உண்டாலோ, உறங்கினாலோ, அவனும் தனது ஆடையைத் துவைக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“புதிய கற்களும் பூச்சும் முடிந்தபிறகு அவ்வீட்டை ஆசாரியன் சோதிக்கும்போது நோய் பரவியதற்கான அறிகுறி எதுவும் இல்லாவிட்டால் அவ்வீடு தீட்டு இல்லாததாய் ஆயிற்று என்று அறிவிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","“பிறகு அந்த வீட்டை சுத்திகரிப்புச் செய்ய வேண்டும். அதற்கு ஆசாரியன் இரண்டு குருவிகளையும், கேதுரு கட்டையையும், ஒரு துண்டு சிவப்புத் துணியையும், ஈசோப்பையும் எடுத்துக்கொள்ள வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","அதில் ஒரு குருவியை மண்பாண்டத்தில் உள்ள ஊற்று தண்ணீரில் கொல்ல வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","பிறகு கேதுருக் கட்டையையும், ஈசோப்பையும், சிவப்பு நூலையும், உயிருள்ள குருவியையும் எடுத்துக்கொள்ள வேண்டும். பின் கொல்லப்பட்ட குருவியின் இரத்தத்தில் இவற்றை மூழ்க வைக்க வேண்டும். பிறகு அந்த இரத்தத்தை ஆசாரியன் வீட்டின்மேல் ஏழுதரம் தெளிக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","குருவியின் இரத்தம், ஊற்று தண்ணீர், உயிருள்ள குருவி, ஈசோப்பு, கேதுருக் கட்டை, சிவப்பு நூல் போன்றவற்றால் வீட்டின் தீட்டினைக் கழிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","பின் உயிருள்ள குருவியை நகருக்கு வெளியே விட்டுவிட வேண்டும். இம்முறையில் ஆசாரியன் வீட்டைச் சுத்தம் செய்வான். பிறகு வீடு சுத்தமாகும்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","55","துணிகளிலோ அல்லது வீட்டிலோ தோஷம் பிடித்தல், தொழுநோய், ஆகியன உண்டாகும்பொழுது கடைப்பிடிக்க வேண்டிய விதிகள் இவைகளே. ");
INSERT INTO tam2008_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","வீக்கம், அசறு, தோலில் வெள்ளைப் புள்ளிகள் உண்டாகுதல் ஆகியவற்றின்போதும் கடைப்பிடிக்க வேண்டிய விதிகள் இவைகளே. ");
INSERT INTO tam2008_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","பொருட்கள் எப்பொழுது சுத்தமாயுள்ளன, எப்பொழுது சுத்தமற்றவையாக உள்ளன எனக் கற்பிப்பதற்குரிய விதிகள் இவைகளே. ");
INSERT INTO tam2008_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","பிறகு கர்த்தர் மோசேயையும், ஆரோனையும் பார்த்து, ");
INSERT INTO tam2008_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“நீங்கள் இஸ்ரவேல் ஜனங்களுக்குச் சொல்ல வேண்டியதாவது: ஒருவனுக்கு உடற்கழிவுகள் ஏற்பட்டால் அதனாலும் தீட்டு உண்டாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","இக்கழிவுகள் அவன் உடம்பிலிருந்து சரளமாக வெளியேறுகிறதா இல்லையா என்பது முக்கியமில்லை. ");
INSERT INTO tam2008_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“உடற்கழிவு ஏற்பட்டவன் படுக்கிற எந்தப் படுக்கையும் தீட்டாகும். அவன் எதன் மேல் உட்காருகிறானோ அதுவும் தீட்டாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","அவனது படுக்கையைத் தொடுகிறவன் தனது ஆடைகளைத் துவைத்து தண்ணீரில் குளிக்க வேண்டும். மாலைவரை அவன் தீட்டுள்ளவனாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","உடற்கழிவு ஏற்பட்டவன் உட்காருகிற இடத்தில் உட்காருகிறவனும் தன் ஆடைகளைத் துவைத்து தண்ணீரில் குளிக்க வேண்டும். மாலைவரை இவனும் தீட்டு உள்ளவனாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","உடற்கழிவு ஏற்படுகிறவனைத் தொடுபவனும் தன் ஆடைகளைத் துவைத்து தண்ணீரில் குளிக்கவேண்டும். மாலைவரை இவனுக்கும் தீட்டு இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","உடற்கழிவு உள்ளவனின் எச்சில் மேலேபட்டாலும் ஒருவன் தன் ஆடைகளைத் துவைத்து தண்ணீரில் குளிக்கவேண்டும். மாலைவரை அவனுக்குத் தீட்டு இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","இத்தகையவன் ஏறுகிற எந்த சேணமும் தீட்டாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","இத்தகையவனுக்குக் கீழ் இருக்கிற எந்தப் பொருளையும் தொடுகிறவன் மாலைவரை தீட்டாயிருப்பான். அப்பொருளை எடுத்துக்கொண்டு போகிறவன் தன் ஆடைகளைத் துவைத்து தண்ணீரில் குளித்து மாலைவரை தீட்டு உள்ளவனாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","சிற்சில இடங்களில் உடற்கழிவு உள்ளவன் தண்ணீரில் தன் கைகளைக் கழுவாமலே அடுத்தவனைத் தொட்டுவிட்டால், தொடப்பட்டவன் தன் ஆடைகளைத் துவைத்து குளிக்க வேண்டும். மாலைவரை அவன் தீட்டாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“உடற்கழிவு ஏற்பட்டவன் ஏதேனும் மண் பாண்டத்தைத் தொட்டால் அம்மண்பாண்டம் உடைக்கப்படவேண்டும். மரத்தாலான பாத்திரத்தை அவன் தொடநேர்ந்தால், அதைத் தண்ணீரால் கழுவ வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“உடற்கழிவு உள்ளவன் அது நீங்கி சுத்தமானதும் அதற்குச் சுத்திகரிப்புச் செய்ய வேண்டும். அதற்காக ஏழு நாட்கள் காத்திருந்து, தன் ஆடைகளைத் துவைத்து தண்ணீரில் குளிக்க வேண்டும். அப்போதுதான் அவன் சுத்தமாவான். ");
INSERT INTO tam2008_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","எட்டாவது நாள் அவன் இரண்டு காட்டுப் புறாக்களையாவது, புறாக்குஞ்சுகளையாவது ஆசரிப்புக் கூடாரத்திற்குக் கொண்டுவர வேண்டும். அவற்றைக் கர்த்தருக்கு முன் கொண்டுவந்து ஆசாரியனிடம் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","அவற்றுள் ஒன்று பாவப்பரிகார பலியாகவும் இன்னொன்று தகன பலியாகவும் ஆசாரியன் கர்த்தருக்கு செலுத்துவான். இம்முறையில் ஆசாரியன் கர்த்தருக்கு முன் அவனைச் சுத்திகரிப்பு செய்யவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ஒருவனுக்கு விந்து வெளிப்பட்டால், அவன் தண்ணீரில் குளிக்க வேண்டும். அவன் மாலைவரை தீட்டுள்ளவனாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","தோல் ஆடையிலும், துணியிலும் விந்துபட்டிருந்தால் அவற்றை தண்ணீரால் கழுவவேண்டும். அது மாலைவரை தீட்டுள்ளதாக இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","விந்து கழிந்தவனோடு ஒரு பெண்படுத்திருந்தால் இருவரும் தண்ணீரில் குளிக்க வேண்டும். அவர்கள் மாலைவரை தீட்டுள்ளவர்களாக இருப்பார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“இரத்தப் போக்குடைய மாதவிலக்கான பெண், ஏழு நாட்கள் தீட்டுப்பட்டவளாக இருப்பாள். அவளைத் தொடுகிறவன் எவனும் மாலை வரை தீட்டுள்ளவனாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","அவள் மாத விலக்காக இருக்கும்போது எதன் மேல் படுத்துக்கொள்கிறாளோ, எதன் மீது உட்காருகிறாளோ அவை தீட்டாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","அவளது படுக்கையைத் தொட்டவன் தன் ஆடைகளைத் துவைத்து தண்ணீரில் குளிக்க வேண்டும். மாலைவரை அவனும் தீட்டுள்ளவனாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","அவள் அமர்ந்த இருக்கையைத் தொட்டவனும் தன் ஆடைகளைத் துவைத்து தண்ணீரில் குளிக்க வேண்டும். அவனும் மாலைவரை தீட்டுள்ளவனாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","அவள் படுக்கையையோ இருக்கையையோ தொட்டவன் மாலைவரை தீட்டு உடையவனாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“அவளோடு ஒருவன் படுத்துக்கொண்டால் அவள் தீட்டு அவன்மேல் படும். அதனால் அவன் ஏழு நாள் தீட்டாய் இருப்பான். அவன் படுக்கிற படுக்கையும் தீட்டாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ஒருத்திக்கு மாதவிலக்கு அல்லாத நாட்களிலும் அவளிடம் இரத்தம் கசிந்தால் அப்போதும் அவள் விலக்கானவள் போலவே கருதப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","அந்த நாட்களிலும் அவள் படுக்கும் படுக்கையும் விலக்கான நாட்களுக்குரிய படுக்கை போன்று தீட்டாகும். அவள் அமரும் இருக்கையும் விலக்கத் தீட்டைப் போன்றே கருதப்படும். ");
INSERT INTO tam2008_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","இத்தகையவற்றைத் தொடுகிற எவனும் தன் ஆடைகளைத் துவைத்து தண்ணீரில் குளிக்க வேண்டும். அவனும் மாலை வரை தீட்டாய் இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","அவளது தீட்டு நின்றதும் ஏழு நாட்கள் அவள் காத்திருக்க வேண்டும். அதன் பிறகே அவள் சுத்தமாகிறாள். ");
INSERT INTO tam2008_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","எட்டாவது நாளில் அவள் இரண்டு காட்டுப் புறாக்களையோ, இரு புறாக்குஞ்சுகளையோ கொண்டு வந்து அவற்றை ஆசாரிப்புக் கூடாரத்திற்குள் ஆசாரியனிடம் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","ஆசாரியன் அவற்றில் ஒன்றைப் பாவப்பரிகார பலியாகவும், இன்னொன்றை தகன பலியாகவும் செலுத்த வேண்டும். கர்த்தருடைய சந்நிதியில் அவளை இவ்வாறு ஆசாரியன் சுத்திகரிப்பு செய்ய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“இஸ்ரவேல் ஜனங்கள் தீட்டு இல்லாதவர்களாக இருக்க எச்சரிக்கை செய்யுங்கள். இல்லாவிட்டால் அவர்கள் எனது ஆராதனை கூடாரத்தைத் தீட்டுள்ளதாக்குவதுடன், அவர்கள் அழிந்தும் போவார்கள்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","இவையே, உடற்கழிவு உள்ளவர்களுக்கான விதிகள். விந்து கழிவினால் தீட்டான ஆண்களுக்கும், ");
INSERT INTO tam2008_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","மாதவிலக்கால் தீட்டான பெண்களுக்கும், தீட்டானவளோடு படுத்துக்கொண்டவனுக்குமுரிய விதிகள் இவைகளேயாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","ஆரோனின் இரண்டு மகன்களும் கர்த்தரின் சந்நிதியில் அங்கீகரிக்கப்படாத முறையில் தூபம் காட்டியபோது மரணமடைந்தனர். அதற்குப் பின்பு கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","“உன் சகோதரன் ஆரோனிடம் பின்வருவதைக் கூறு: கூடாரத்தின் திரைக்குப் பின்னால் அவன் விரும்புகிற போதெல்லாம் மகாபரிசுத்த இடத்திற்கு போகவேண்டாம். திரைக்குப் பின்னால் அந்த அறையில் பரிசுத்தப் பெட்டி உள்ளது. அதன்மேல் கிருபாசன மூடி உள்ளது. நான் அதற்கு மேல் மேகத்தில் காட்சி தருவேன். ஆரோன் அங்கே சென்றால் மரித்து போகலாம்! ");
INSERT INTO tam2008_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“ஆரோன் பாவப்பரிகார நாள் அன்று மிகவும் பரிசுத்தமான அந்த இடத்திற்குள் நுழைவதற்கு முன் ஒரு காளையைப் பாவப் பரிகார பலியாகவும், ஒரு ஆட்டுக்கடாவை தகன பலியாகவும் செலுத்திவிட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","ஆரோன் தண்ணீரில் தன் உடல் முழுவதையும் கழுவ வேண்டும். பின் அவன் வேறு ஆடைகளை அணிந்துகொள்ள வேண்டும். ஆரோன் பரிசுத்த சணல் நூல் சட்டையை அணிந்து இடுப்பில் சணல் நூல் சல்லடத்தைக் கட்டிக்கொள்ள வேண்டும். சணல் நூல் தலைப் பாகையையும், சணல் நூலால் ஆன இடைக் கச்சையையும் அணிந்துகொள்ள வேண்டும். இவை பரிசுத்தமான ஆடைகள். ");
INSERT INTO tam2008_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“ஆரோன் இஸ்ரவேல் ஜனங்களிடமிருந்து பாவப்பரிகார பலிக்காக இரண்டு வெள்ளாட்டுக் கடாக்களையும் தகன பலிக்காக ஒரு ஆட்டுக் காடாவையும் வாங்கிக்கொள்ள வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","பிறகு ஆரோன் காளையைப் பாவப்பரிகார பலியாக செலுத்த வேண்டும். இந்தப் பாவப்பரிகார பலி அவனுக்குரியது. இதனை ஆரோன் தன்னையும் தன் குடும்பத்தாரையும் சுத்திகரிப்பு செய்வதற்காக இவ்வாறு செய்ய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","“பிறகு ஆரோன் இரு வெள்ளாட்டுக் கடாக்களையும் கர்த்தருக்கு முன்பாக ஆசரிப்புக் கூடாரத்தின் வாசலுக்குக் கொண்டு வரவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","பின் கடாக்களுக்காகச் சீட்டுப்போட வேண்டும். ஒரு சீட்டு கர்த்தருக்குரியது. இன்னொரு சீட்டு போக் காட்டுக்கு உரியது. ");
INSERT INTO tam2008_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","“பிறகு ஆரோன் கர்த்தருக்குரிய சீட்டுள்ள கடாவைக் கர்த்தருடைய சந்நிதியில் பாவப் பரிகார பலியாக வழங்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","ஆனால் போக்காடாகச் சீட்டுள்ள கடாவையும் கர்த்தருக்கு முன் கொண்டு வர வேண்டும். பின் அந்தக் கடாவை உயிரோடு வனத்துக்குத் துரத்திவிட வேண்டும். இது ஜனங்களைச் சுத்திகரிப்புச் செய்யும். ");
INSERT INTO tam2008_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“பிறகு ஆரோன் காளையைத் தனக்குரிய பாவப்பரிகார பலியாகச் செலுத்தி, தன்னையும் தனது குடும்பத்தாரையும் பரிசுத்தப்படுத்த வேண்டும். அவனே தனக்கான பாவப்பரிகார பலியாக அக்காளையைக் கொல்ல வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","பிறகு கர்த்தரின் சந்நிதியிலிருக்கும் பலிபீடத்தின் மேலுள்ள நெருப்புத் தணலினால் தூபகலசத்தை நிரப்ப வேண்டும். பொடியாக்கப்பட்ட நறுமணப் பொருட்களை தன் கைப்பிடி நிறைய எடுத்து திரைக்கு உட்புறமாகக் கொண்டு வர வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","அவன் கர்த்தரின் சந்நிதியில் நறுமணப் பொருட்களைப் போட வேண்டும். அப்புகையானது உடன்படிக்கைப் பெட்டியின் மேலுள்ள கிருபாசனத்தை மூடும் அளவிற்கு போட வேண்டும். இவ்வாறு செய்தால் ஆரோன் மரிக்கமாட்டான். ");
INSERT INTO tam2008_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ஆரோன் கொல்லப்பட்ட காளையின் இரத்தத்தில் கொஞ்சம் எடுத்து, அதனை விரலால் தொட்டுக் கீழ்ப்புறமாக நின்று கிருபாசனத்தின்மேல் தெளிக்க வேண்டும். இவ்வாறு ஏழுமுறை அவன் இரத்தத்தைத் தெளிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“பிறகு ஆரோன் ஜனங்களின் பாவப் பரிகார பலிக்கான வெள்ளாட்டைக் கொன்று, அதன் இரத்தத்தைத் திரைக்குப் பின்னால் உள்ள அறைக்குக் கொண்டு வர வேண்டும். காளையின் இரத்தத்தைச் செய்தது போன்றே இதனையும் செய்ய வேண்டும். அவன் அந்த இரத்தத்தைக் கிருபாசனத்தின் மேலும் அதற்கு முன்பும் தெளிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","இவ்வாறு ஆரோன் மிகவும் பரிசுத்தமான இடத்தைச் சுத்திகரிப்பு செய்யவேண்டும். இஸ்ரவேல் ஜனங்கள் அனைவருடைய தீட்டிற்காகவும், பாவங்களுக்காகவும் ஆரோன் இதனையெல்லாம் செய்ய வேண்டும். ஆரோன் இதனை ஆசரிப்பு கூடாரத்திற்குள்ளே செய்ய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","“அவர்களுடைய தீட்டுகளின் மத்தியிலிருக்கிற மிகப் பரிசுத்தமான இடத்தில் இச்சடங்குகளையெல்லாம் ஆரோன் செய்யும்போது எவரும் ஆசரிப்புக் கூடாரத்தில் நுழையக் கூடாது. ஆரோன் வெளியே வந்த பிறகுதான் எவரும் நுழைய வேண்டும். இவ்வாறு ஆரோன் தன்னையும், தன் குடும்பத்தாரையும், இஸ்ரேவேல் ஜனங்களையும் சுத்தம் செய்கிறான். ");
INSERT INTO tam2008_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","பிறகு அவன் கர்த்தருடைய சந்நிதியில் இருக்கிற பலி பீடத்தின் அருகில் வரவேண்டும். அதற்குப் பிராயச்சித்தம் செய்ய, காளையின் இரத்தத்திலும் வெள்ளாட்டின் இரத்தத்திலும் கொஞ்சம் எடுத்து பலிபீடத்தின் கொம்புகளில் தடவ வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","தன் விரலினால் அந்த இரத்தத்தைத் தொட்டு ஏழுமுறை அதன்மேல் தெளிக்க வேண்டும். அதனை இஸ்ரவேல் ஜனங்களின் தீட்டுகள் நீங்கும்படி சுத்திகரித்து பரிசுத்தப்படுத்த வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“ஆரோன் மிகப் பரிசுத்தமான இடத்தையும், ஆசரிப்புக் கூடாரத்தையும், பலி பீடத்தையும் பரிசுத்தப்படுத்துவான். பிறகு ஆரோன் உயிருள்ள வெள்ளாட்டைக் கர்த்தருக்கு முன் கொண்டு வந்து ");
INSERT INTO tam2008_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","தனது இரு கைகளையும் அதன் தலைமீது வைப்பான். பிறகு இஸ்ரவேல் ஜனங்களுடைய பாவங்களையும் குற்றங்களையும் அறிக்கையிட்டு அந்த வெள்ளாட்டின் தலையிலே சுமத்துவான். பின் அதனை அதற்கு நியமிக்கப்பட்ட ஆள் மூலம் வனாந்திரத்திற்கு அனுப்பிவிடுவான். ");
INSERT INTO tam2008_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","அந்தக் கடாவானது வனாந்திரத்திற்கு அனைவரது பாவங்களையும் எடுத்து சென்றுவிடுகிறது. அதனைக் காட்டிலே விட்டுவிட்டு அந்த ஆள் வந்துவிடுவான். ");
INSERT INTO tam2008_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“பிறகு ஆரோன் ஆசரிப்புக் கூடாரத்திற்குள் நுழைவான். பரிசுத்த இடத்திற்குள் நுழையும் போது அவன் அணிந்திருக்கும் மெல்லிய பஞ்சாடைகளை நீக்கி அவைகளை அங்கேயே வைத்துவிட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","ஒரு பரிசுத்தமான இடத்தில் தனது உடல் முழுவதையும் தண்ணீரால் கழுவி, பிறகு வேறு சிறப்பு ஆடைகளை அணிந்துக்கொள்ள வேண்டும். அதன்பின் வெளியே வந்து தனது மற்றும் ஜனங்களின் தகன பலிகளைச் செலுத்தி தன்னையும் ஜனங்களையும் பரிசுத்தமாக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","பின் பாவப் பரிகார பலியின் கொழுப்பை பலிபீடத்தின் மேல் எரிப்பான். ");
INSERT INTO tam2008_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“போக்காடாகிய கடாவைக் கொண்டு போய் வனாந்திரத்திலே விட்டவன் ஆடைகளைத் துவைத்துக் குளித்துவிட்டு முகாமுக் குள் வரவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","“பாவப்பரிகார பலிக்குரிய காளையையும் வெள்ளாட்டையும் முகாமிற்கு வெளியே கொண்டு செல்லவேண்டும். (அவற்றின் இரத்தத்தை மட்டும் பரிசுத்த இடத்திற்குள் கொண்டுப் போய் அதனைச் சுத்திகரிப்பு செய்யவேண்டும்.) தோல்கள், உடல்கள், கழிவுகள் அனைத்தையும் ஆசாரியன் நெருப்பிலே போட்டு எரிக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","எரித்தவன் ஆடையைத் துவைத்து தண்ணீரில் உடல் முழுவதையும் கழுவிய பின்னரே கூடாரத்திற்குள் நுழைய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“இந்தச் சட்டங்கள் என்றென்றும் தொடர்ந்து இருக்கும். ஏழாவது மாதத்தின் பத்தாவது நாளில் எவ்வுணவையும் நீங்கள் உண்ணவோ, ஒரு வேலையும் செய்யவோ கூடாது. உங்கள் தேசத்தில் வசிக்கும் உள்நாட்டுக்காரர்களும், வெளிநாட்டுக்காரர்களும் கூட எவ்வேலையும் செய்யக்கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","ஏனென்றால் ஆசாரியர்கள் அந்நாளில் வந்து உங்களைச் சுத்திகரிப்பு செய்து உங்கள் பாவங்களைப் போக்குவார்கள். பிறகு நீங்கள் கர்த்தருக்கு முன் தீட்டு இல்லாமல் இருப்பீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","இந்நாள் சிறப்பான ஓய்வு நாளாகும். அன்று உணவு எதையும் உட்கொள்ளாமல் உங்கள் மனதில் தாழ்மையுடன் இருக்க வேண்டும். இந்த விதிமுறை என்றென்றும் இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","“தேவனுடைய அபிஷேகம் பெற்று தேர்ந்தெடுக்கப்பட்ட தலைமை ஆசாரியனே பாவப்பரிகாரம் செய்யத் தகுந்தவன். தனது தந்தைக்குப் பிறகு தலைமை ஆசாரியனாகப் பணி செய்யும் உரிமையைப் பெற்றவன் இவன். ஆசாரியன் பரிசுத்தமான சணல் நூல் ஆடைகளை அணிந்துகொள்ள வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","மிகப் பரிசுத்தமான இடத்திற்கும் ஆசரிப்புக் கூடாரத்திற்கும் பலிபீடத்திற்கும் பிராயச்சித்தம் செய்ய வேண்டும். அவன் மற்ற ஆசாரியர்களையும், இஸ்ரவேல் ஜனங்களையும் சுத்தப்படுத்துவான். ");
INSERT INTO tam2008_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","இஸ்ரவேல் ஜனங்களின் பாவங்களின் காரணமாக அவர்களை வருடம் ஒருமுறை பரிசுத்தம் செய்யும் இச்சட்டம் தொடர்ந்து இருக்கும்” என்றார். கர்த்தர் மோசேக்குக் கட்டளையிட்டபடியே அவர்கள் செய்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","கர்த்தர் மோசேயிடம் ");
INSERT INTO tam2008_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“நீ ஆரோனுடனும், அவனது மகன்களோடும் இஸ்ரவேல் ஜனங்கள் அனைவரிடமும் பேசி, கர்த்தர் என்ன கட்டளையிட்டுள்ளார் என்பதைக் கூறு: ");
INSERT INTO tam2008_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","ஒரு இஸ்ரவேலன் ஒரு காளையையோ, அல்லது ஒரு செம்மறியாட்டையோ அல்லது வெள்ளாட்டையோ முகாமுக்கு உள்ளேயோ அல்லது வெளியேயோ கொல்லலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","அவன் அந்த மிருகத்தை ஆசரிப்புக் கூடாரத்திற்குக் கொண்டுவர வேண்டும். அவன் அந்த மிருகத்தின் ஒரு பகுதியை கர்த்தருக்கு அன்பளிப்பாக அளிக்க வேண்டும். கொல்லப்பட்ட மிருகத்தின் இரத்தத்தை அவன் சிந்தியவனாகிறான். எனவே, தனது அன்பளிப்பை கர்த்தரின் பரிசுத்தக் கூடாரத்திற்கு எடுத்துச் செல்ல வேண்டும். அவன் அம்மிருகத்தின் ஒரு பகுதியை கர்த்தருக்கு அன்பளிப்பாக எடுத்துச் செல்லவில்லையெனில் அவன் தனது ஜனங்களிடமிருந்து ஒதுக்கப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","விதிகள் இவ்வாறு இருப்பதால் ஜனங்கள் தங்கள் சமாதானப் பலியைக் கர்த்தருக்குக் கொண்டு வரவேண்டும். இஸ்ரவேல் ஜனங்கள் வயல்களில் கொல்கிற மிருகங்களை ஆசரிப்புக் கூடாரத்திற்கு ஆசாரியனிடம் கொண்டு வரவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","பிறகு ஆசாரியன் ஆசரிப்புக் கூடாரத்தின் வாசலில் உள்ள பலிபீடத்தின்மேல் கர்த்தருக்கு முன் இரத்தத்தைத் தெளிக்க வேண்டும். கொழுப்பை நறுமணமிக்க வாசனையாக எரிக்க வேண்டும். அந்த மணம் கர்த்தருக்கு மிகவும் பிரியமாயிருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","தாங்கள் தவறாகப் பின்பற்றிய பொய்த் தேவர்களுக்கு இனிமேல் அவர்கள் எவ்வித பலிகளும் இடாமல் இருக்க வேண்டும். அவர்கள் இத்தகைய பொய்த் தேவர்களைப் பின்பற்றினால் ஒரு வேசியைப் போன்று இருப்பார்கள். இவ்விதிகள் நிரந்தரமானவை. ");
INSERT INTO tam2008_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“ஜனங்களிடம் சொல்லுங்கள், இஸ்ரவேல் குடிமக்களோ அல்லது உங்களிடையே வாழும் அயல் நாட்டுக்காரர்களோ தகன பலியையோ அல்லது வேறு பலிகளையோ ");
INSERT INTO tam2008_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ஆசரிப்புக் கூடாரத்தின் வாசலுக்குக் கர்த்தருக்கு அளிக்க வரவேண்டும். இவ்வாறு அவர்கள் செய்யாவிட்டால் மற்ற ஜனங்களிடமிருந்து ஒதுக்கப்பட்டுப் போவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“இரத்தத்தைச் சாப்பிடுகிற எவருக்கும் தேவனாகிய நான் எதிராக இருக்கிறேன். அவன் இஸ்ரவேல் குடிமகனாகவோ, அல்லது உங்களோடு குடியிருக்கும் அயல் நாட்டுக்காரனாகவோ இருக்கலாம். நான் அவர்களை மற்ற ஜனங்களிடம் இருந்து ஒதுக்கிவிடுவேன். ");
INSERT INTO tam2008_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","ஏனென்றால் சரீரத்தின் உயிர் இரத்தத்தில் உள்ளது. இரத்தத்தைப் பலி பீடத்தில் ஊற்றும்படி நான் விதிகளைக் கொடுத்திருக்கிறேன். உங்களைச் சுத்திகரித்துக்கொள்ள நீங்கள் இதனைச் செய்ய வேண்டும். இரத்தமே ஆத்துமாவை பாவ நிவிர்த்தி செய்கிறது. ");
INSERT INTO tam2008_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","உங்களில் எவரும், உங்களோடு வாழும் அயல் நாட்டுக்காரர்களும் இரத்தம் உண்ணக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“எவராவது உண்ணத்தக்க பறவையையோ, மிருகத்தையோ பிடித்துக்கொன்றால் அதன் இரத்தத்தைத் தரையிலே ஊற்றி மண்ணால் மூட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","இறைச்சியில் இரத்தம் இருந்தால் இறைச்சியில் மிருகத்தின் உயிர் இருப்பதாகப் பொருள். இறைச்சியில் இரத்தம் இருந்தால் அதை உண்ணாதீர்கள். இரத்தத்தோடு உண்ணுகிற எவனும் தன் ஜனங்களிடம் இருந்து ஒதுக்கப்படுவான். ");
INSERT INTO tam2008_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“இஸ்ரவேலராகிய நீங்களும், உங்களோடு வசிக்கும் அயலார் எவரும் தானாக மரித்துப்போன மிருகத்தையோ, வேறு மிருகத்தாலே கொல்லப்பட்ட மிருகத்தையோ உண்ணக் கூடாது, அது உங்களுக்குத் தீட்டாயிருக்கும். அப்படி உண்பவன் மாலைவரை தீட்டாயிருப்பான். மாலையில் அவன் தன் உடையைத் துவைத்து தண்ணீரால் உடல் முழுவதையும் கழுவ வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","அவன் தனது ஆடையைத் துவைக்காவிட்டாலோ, தண்ணீரால் உடலைக் கழுவாவிட்டாலோ அவன் குற்றமுள்ளவனாயிருப்பான்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","மேலும் கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“இஸ்ரவேல் ஜனங்களிடம் நீ கூற வேண்டியதாவது: நானே தேவனாகிய கர்த்தர் ");
INSERT INTO tam2008_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","எகிப்திலிருந்த உங்களை நான் கானானுக்கு வழி நடத்தினேன். அங்கு செய்துவந்த செயல்களை எல்லாம் இங்கு செய்யக் கூடாது. நான் உங்களை கானான் தேசத்திற்கு நடத்திச் செல்கிறேன். அவர்களின் பழக்கவழக்கங்களைப் பின்பற்றாதீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","நீங்கள் எனக்குக் கீழ்ப்படிந்து எனது விதிகளைப் பின்பற்றுவதில் உறுதியாக இருங்கள். ஏனென்றால் நானே உங்கள் தேவனாகிய கர்த்தர். ");
INSERT INTO tam2008_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","எனவே நீங்கள் எனக்குக் கீழ்ப்படிந்து எனது விதிகளைப் பின்பற்ற வேண்டும். எனது சட்டங்களுக்கும், விதிகளுக்கும் கீழ்ப்படிகிறவனே உண்மையில் நீடித்து வாழ்வான். நானே கர்த்தர். ");
INSERT INTO tam2008_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“நீங்கள் உங்களுடைய நெருங்கிய உறவினர்களுடன் பாலின உறவு கொள்ளக் கூடாது. நானே கர்த்தர்! ");
INSERT INTO tam2008_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“நீங்கள் உங்கள் தந்தையோடும் தாயோடும் பாலின உறவு தொடர்புகொள்ளக் கூடாது. அந்தப் பெண் உனது தாய். எனவே நீ அவளோடு பாலின உறவு கொள்ளக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","அவள் உனது தாயாக இல்லாவிட்டாலும் உனது தந்தையின் மனைவியோடு பாலின உறவு வைத்துக்கொள்ளக்கூடாது. ஏனென்றால் அது உனது தந்தையை நிர்வாணமாக்குவது போன்றதாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“நீங்கள் உங்கள் சகோதரியோடு பாலின உறவு வைத்துக்கொள்ளக்கூடாது. அவள் உனது தந்தைக்கோ, தாய்க்கோ பிறந்தவளாக இல்லாமல் இருக்கலாம். அவள் உனது வீட்டிலே பிறந்தவளாகவோ வேறு இடத்தில் பிறந்தவளாகவோ இருக்கலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“நீ உன் பேத்தியோடு பாலின உறவு வைத்துக்கொள்ளக் கூடாது. அவர்கள் உங்களில் ஒரு பகுதியானவர்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“உனது தந்தைக்கும் அவரது மனைவிக்கும் பிறந்தவளாக இருந்தாலும் அவள் உனது சகோதரிதான். நீ அவளோடு பாலின உறவு வைத்துக்கொள்ளக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“உன் தந்தையின் சகோதரியோடும் பாலின உறவு வைத்துக்கொள்ளக்கூடாது. அவள் உனது தந்தையோடு நெருங்கிய உறவு உடையவள். ");
INSERT INTO tam2008_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","நீ உனது தாயின் சகோதரியோடு பாலின உறவு வைத்துக்கொள்ளக் கூடாது. அவள் உனது தாயின் நெருங்கிய உறவினள். ");
INSERT INTO tam2008_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","நீ உனது தந்தையின் சகோதரனோடும் பாலின உறவு வைத்துக்கொள்ளக் கூடாது. நீ அவரது மனைவியோடும் பாலின உறவு வைத்துக்கொள்ளக்கூடாது. ஏனென்றால் அவள் உனது அத்தை அல்லது சித்தி அல்லது பெரியம்மாள். ");
INSERT INTO tam2008_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“நீ உனது மருமகளோடும் பாலின உறவு வைத்துக்கொள்ளக் கூடாது. ஏனென்றால் அவள் உனது மகனின் மனைவி. அவளோடு பாலின உறவு வைத்துக்கொள்ளக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“நீ உனது சகோதரனது மனைவியோடும் பாலின உறவு வைத்துக்கொள்ளக் கூடாது. அது உனது சகோதரனை நிர்வாணமாக்குவது போன்றதாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“நீ தாய்-மகள் இருவரோடும் பாலின உறவு கொள்ளக்கூடாது. அதோடு அவளது பேத்தியோ டும் பாலின உறவு வைத்துக்கொள்ளக் கூடாது. அந்தப் பேத்தி அவளது மகளின் மகளாகவும் மகனின் மகளாகவும் இருக்கலாம். அவளது பேத்தி என்றால் அவளுக்கு நெருக்கமான உறவினள். அவர்களோடு தொடர்பு வைத்துக்கொள்வது முறை கெட்ட செயல். ");
INSERT INTO tam2008_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“உனது மனைவி உயிரோடு இருக்கும்போது அவளது தங்கையை அடுத்த மனைவியாக வைத்துக்கொள்ளக் கூடாது. இது அந்தச் சகோதரிகளை விரோதிகளாக மாற்றிவிடும். உனது மனைவியின் சகோதரியோடு பாலின உறவு வைத்துக்கொள்ளக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ஒரு பெண் மாதவிலக்கான காலத்தில் இருக்கும்போது அவளோடு பாலின உறவு வைத்துக்கொள்ளக் கூடாது. அவள் அப்போது தீட்டுள்ளவளாக இருக்கிறாள். ");
INSERT INTO tam2008_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“பக்கத்து வீட்டுக்காரனின் மனைவியோடும் பாலின உறவு வைத்துக்கொள்ளக் கூடாது. இது உன்னை தீட்டுள்ளவனாக்கிவிடும். ");
INSERT INTO tam2008_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“நீ உனது குழந்தைகளை மோளேகு என்ற பொய்த் தெய்வத்திற்கு முன்பு நெருப்பில் நடக்கும்படி அனுமதியாதே. நீ இதனைச் செய்தால் உனது தேவனை மதிக்கவில்லை என்று பொருள். நானே கர்த்தர். ");
INSERT INTO tam2008_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“நீ பெண்ணோடு பாலின உறவு வைத்துக்கொள்வதைப் போல ஆணோடு பாலின உறவு வைத்துக்கொள்ளக் கூடாது. இது பயங்கரமான பாவமாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“நீ எந்த மிருகத்தோடும் பாலின உறவு வைத்துக்கொள்ளக் கூடாது. இது உன்னை அருவருப்பு உள்ளவனாக்கும். இதுபோல் ஒரு பெண்ணும் எந்த மிருகத்தோடும் பாலின உறவு வைத்துக்கொள்ளக் கூடாது. இது இயற்கைக்கு மாறானது. ");
INSERT INTO tam2008_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“இது போன்ற தவறான செயல்களைச் செய்து உங்களைத் தீட்டுள்ளவர்களாக்கிக்கொள்ளாதீர்கள். இத்தேசத்தில் உள்ளவர்களை வெளியே துரத்திக்கொண்டிருக்கிறேன். அவர்களின் நிலத்தை உங்களுக்குத் தந்தேன், ஏனென்றால் அவர்கள் இத்தகைய பயங்கரமான பாவங்களைச் செய்திருக்கிறார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","அவர்கள் இந்த நாட்டையும் அருவருப்பாக்கிவிட்டார்கள். எனவே நான் இதன் பாவத்துக்காக இதனைத் தண்டிப்பேன். அந்நாடு அங்கு வாழ்பவர்களைக்கக்கிப்போடும். ");
INSERT INTO tam2008_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","“நீங்கள் என்னுடைய சட்டங்களுக்கும் விதிகளுக்கும் கீழ்ப்படியவேண்டும். நீங்கள் இது போன்ற பயங்கரமான பாவங்களைச் செய்யக் கூடாது. இந்த விதிகள் இஸ்ரவேல் குடிமக்களுக்கும் அவர்களிடையே வாழும் அயலாருக்கும் உரியது. ");
INSERT INTO tam2008_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","உங்களுக்கு முன்னால் இந்த நாட்டில் வாழ்ந்தவர்கள் எல்லாம் அத்தகைய பாவங்களைச் செய்தார்கள். அதனால் நாடே அருவருப்பாயிற்று. ");
INSERT INTO tam2008_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","நீங்கள் இவற்றைச் செய்தால் நீங்களும் இந்த நாட்டை அருவருப்பாக்குவீர்கள். அவர்களை இந்நாடு கக்கிப்போட்டது போன்று உங்களைக் கக்கிப்போடும். ");
INSERT INTO tam2008_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","எவராவது இதுபோன்ற மோசமான பாவங்களைச் செய்தால் பிறகு அவர்கள் தங்கள் ஜனங்களிடமிருந்து ஒதுக்கப்படுவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","மற்ற ஜனங்கள் இத்தகைய மோசமான பாவங்களைச் செய்தார்கள், ஆனால் நீங்கள் எனது சட்டங்களுக்குக் கீழ்ப்படிய வேண்டும். நீங்கள் இது போன்ற மோசமான பாவங்களைச் செய்து உங்களை அருவருப்பாக்கிக்கொள்ளாதீர்கள். நான் உங்கள் தேவனாகிய கர்த்தர்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“அனைத்து இஸ்ரவேல் ஜனங்களுக்கும் நீ கூற வேண்டியதாவது: நான் உங்கள் தேவனாகிய கர்த்தர். நான் பரிசுத்தமானவர். எனவே, நீங்களும் பரிசுத்தமாய் இருக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“உங்களில் ஒவ்வொருவரும் தங்கள் தாய் தந்தைக்கு மரியாதை செய்யவேண்டும். என் ஓய்வு நாட்களை ஆசரிக்கவேண்டும். நான் உங்கள் தேவனாகிய கர்த்தர்! ");
INSERT INTO tam2008_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“விக்கிரகங்களை வணங்காதீர்கள். வார்ப்பிக்கப்பட்ட தெய்வங்களை உருவாக்காதீர்கள். நானே உங்கள் தேவனாகிய கர்த்தர். ");
INSERT INTO tam2008_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“நீங்கள் சமாதானப் பலியைக் கர்த்தருக்குக் கொடுக்கும்போது அது அங்கீகரிக்கப்படத்தக்க சரியான வழியிலேயே செய்யவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","நீங்கள் பலிகொடுத்த நாளிலும், மறுநாளும் அதனை உண்ணலாம். ஆனால் அந்த உணவில் மீதியானது மூன்றாவது நாளும் இருந்தால் அதனை நெருப்பில் போட்டு எரித்துவிட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","மூன்றாவது நாள் பலியின் மீதியான எதையும் நீங்கள் உண்ணக் கூடாது. இது தீட்டானது, இது ஏற்றுக்கொள்ளப்பட முடியாதது. ");
INSERT INTO tam2008_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","இதனை எவராவது செய்தால் அது பாவமாயிருக்கும். ஏனென்றால் அவர்கள் கர்த்தருக்குரிய பரிசுத்தமானவற்றை மதிக்கவில்லை. இத்தகைய மனிதர்கள் தம் ஜனங்களிடமிருந்து ஒதுக்கப்படுவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“அறுவடைக் காலத்தில் நீங்கள் விளைந்த பயிரை அறுவடை செய்யும்போது வயலின் எல்லாப் பகுதிகளையும் மூலைகளையும் சேர்த்து அறுக்காதீர்கள். தானியங்கள் தரையில் சிதறுமானால் அவற்றைச் சேகரித்து அள்ளிக்கொள்ளாதீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","உங்கள் திராட்சைக் கொடியில் உள்ள அனைத்து திராட்சைப் பழங்களையும் பறிக்காதீர்கள். தரையில் விழும் திராட்சைப் பழங்களையும் பொறுக்கிக்கொள்ளாதீர்கள். அவற்றை ஏழை ஜனங்களுக்கும் பயணிகளுக்கும் விட்டுவிட வேண்டும். நானே உங்கள் தேவனாகிய கர்த்தர். ");
INSERT INTO tam2008_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“நீங்கள் திருடக்கூடாது. நீங்கள் ஜனங்களை ஏமாற்றவும் கூடாது. ஒருவருக்கொருவர் பொய் சொல்லாதீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","எனது பெயரைப் பயன்படுத்தி பொய் சத்தியம் செய்யாதீர்கள். நீங்கள் அவ்வாறு செய்தால் உங்கள் தேவனின் பெயரை மதிக்காமல் இருக்கிறீர்கள். நானே கர்த்தர். ");
INSERT INTO tam2008_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“உங்கள் அண்டை வீட்டுக்காரனுக்குத் தீமை செய்யாதீர்கள். அவனிடம் திருடாதீர்கள். வேலைக்காரனின் கூலியை விடியும்வரை இரவு முழுக்க நிறுத்தி வைக்காதீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“செவிடர்களை நீங்கள் சபிக்காதீர்கள். குருடன் விழுந்துவிடும்படி அவன் எதிரே எதுவும் போடாதீர்கள். உங்கள் தேவனுக்கு மரியாதைச் செலுத்த வேண்டும். நானே கர்த்தர்! ");
INSERT INTO tam2008_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“நீங்கள் நியாயத்தீர்ப்பில் நடுநிலையுடன் இருங்கள். ஒருவன் ஏழை என்பதினால் சிறப்பான சலுகையோ அல்லது ஒருவர் முக்கியமான மனிதர் என்பதினால் விசேஷ சலுகையோ செய்யக் கூடாது. உனது அயலானுக்குத் தீர்ப்பளிக்கும்போது நடுநிலையில் இருந்து சொல்ல வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","மற்றவர்களைப்பற்றிய பொய்க் கதைகளைப் பரப்பிக்கொண்டு திரியக் கூடாது. அயலானின் வாழ்வுக்கு ஆபத்து ஏற்படும்படி நீ எதுவும் செய்யக்கூடாது. நானே கர்த்தர்! ");
INSERT INTO tam2008_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“உன் மனதில் உன் சகோதரனை நீ வெறுக்கக் கூடாது. உனது அயலான் உனக்குக் கெடுதல் செய்தால் அதைப்பற்றி அவனிடம் பேசு, பின் அவனை மன்னித்துவிடு. ");
INSERT INTO tam2008_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","உனக்கு ஜனங்கள் செய்த தீமைகளை மறந்துவிடு. பழிவாங்க முயற்சி செய்யாதே. உனது அயலானையும் உன்னைப்போல நேசி. நானே கர்த்தர்! ");
INSERT INTO tam2008_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“நீங்கள் என்னுடைய சட்டங்களுக்குக் கீழ்ப்படிய வேண்டும். நீங்கள் இருவிதமான மிருகங்களைச் சேர்த்து இனப்பெருக்கம் செய்யக்கூடாது. உங்களது வயலில் இரண்டுவிதமான விதைகளை விதைக்கக்கூடாது. இரண்டு விதமான நூலில் இருந்து தயாரிக்கப்பட்ட ஆடைகளை அணியக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“அடுத்தவனிடம் அடிமையாய் இருக்கிற ஒரு பெண்ணுடன் ஒருவன் பாலியல் உறவுகொள்ள நேரிடலாம். ஆனால் அவளை வாங்கவோ அவளுக்குச் சுதந்திரம் அளிக்கவோ முடியாது. இவ்வாறு நடந்தால் இது தண்டனைக்குரியது. ஆனால் இது மரணத்திற்குரியது அல்ல. ஏனென்றால் அவள் சுதந்திரமானவள் அல்ல. ");
INSERT INTO tam2008_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","அவன் குற்றபரிகார பலியாக ஆட்டுக்கடா ஒன்றை ஆசரிப்புக் கூடாரத்தின் வாசலுக்குக் கொண்டுவரவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","அவன் சுத்திகரிக்கப்படும்படி ஆசாரியன் பாவ நிவிர்த்தி செய்வான். கர்த்தருக்கு முன்பாக ஆசாரியன் ஆட்டுக்கடாவை குற்றபரிகார பலியாகச் செலுத்த வேண்டும், அப்போது அவன் பாவங்கள் மன்னிக்கப்படும். ");
INSERT INTO tam2008_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“வருங்காலத்தில் உங்கள் நாட்டுக்குள் நுழைந்த பின்பு உணவுக்காகப் பலவிதமான மரங்களை நீங்கள் நடுவீர்கள். ஒரு மரத்தை நட்டபிறகு மூன்று வருடத்திற்கு அதிலுள்ள பழங்களைப் பயன்படுத்தாமல் விட்டுவிட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","நான்காவது ஆண்டில் கிடைக்கும் பழங்கள் கர்த்தருக்குரியவை. அவற்றப் பரிசுத்தக் காணிக்கையாகக் கர்த்தரைத் துதிப்பதற்காகக் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","ஐந்தாவது ஆண்டில் அம்மரத்திலுள்ள கனியை நீங்கள் உண்ணலாம். அம்மரம் உங்களுக்காக மேலும் மேலும் பழங்களைத் தரும். உனது தேவனாகிய கர்த்தர் நானே. ");
INSERT INTO tam2008_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“இரத்தம் இருக்கிற இறைச்சியை நீங்கள் உண்ணக் கூடாது. “மாயவேலைகளைப் பயன்படுத்தவோ, அல்லது எதிர்காலத்தைப்பற்றி அறிய மந்திர, தந்திர வழிகளில் முயற்சி செய்யவோ கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“உன் முகத்தில் வளருகிற முடியையும், தாடியையும் மழிக்கக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","மரித்து போனவர்களின் நினைவாக உன் உடலில் கீறி அடையாளம் உருவாக்காதே. உன் உடம்பில் பச்சை குத்திக்கொள்ளாதே. நானே கர்த்தர். ");
INSERT INTO tam2008_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“உனது மகள் வேசியாகும்படி விடாதே. அவளை நீ மதிக்கவில்லை என்பதையே அது காட்டும். உன் நாட்டில் ஜனங்கள் வேசிகளாகும்படிவிடாதே. இத்தகைய பாவம் உன் நாட்டில் காணப்படக்கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“எனது ஓய்வு நாளில் நீங்கள் வேலை செய்யக்கூடாது. என் பரிசுத்தமான இடத்தை நீங்கள் மதிக்க வேண்டும். நானே கர்த்தர். ");
INSERT INTO tam2008_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“மந்திரவாதிகளிடமும் செத்தவர்களிடமும் தொடர்புகொள்வதாகக் கூறுபவர்களிடமும் புத்திமதி கேட்டு செல்லாதீர்கள். அவர்கள் உங்களைத் தீட்டுப்படுத்துவார்கள். நானே உங்கள் தேவனாகிய கர்த்தர். ");
INSERT INTO tam2008_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“முதியவர்களுக்கு மரியாதை கொடு. அவர்கள் அறைக்குள் வரும்போது எழுந்து நில். உங்கள் தேவனுக்கு மரியாதை செலுத்துங்கள். நானே கர்த்தர். ");
INSERT INTO tam2008_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“உனது நாட்டில் வாழும் அயல்நாட்டுக்காரர்களுக்குக் கெடுதல் செய்யாதே. ");
INSERT INTO tam2008_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","நீ உனது நாட்டாரை மதிப்பதுபோலவே அந்நியர்களையும் மதிக்க வேண்டும். நீ உன்னையே நேசிப்பது போல அந்நியர்களையும் நேசிக்க வேண்டும். ஏனென்றால் நீங்களும் முன்பு எகிப்தில் அந்நியராயிருந்தீர்கள். நானே உங்கள் தேவனாகிய கர்த்தர். ");
INSERT INTO tam2008_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“நியாய விசாரணையின்போது நடு நிலமையில் இருங்கள். அளக்கும்போதும், நிறுக்கும்போதும் நேர்மையாக இருங்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","உங்கள் கூடைகளும், ஜாடிகளும் சரியான அளவுள்ளவையாக இருக்கட்டும். உங்கள் எடைக் கற்களும், தராசும் பொருட்களைச் சரியாக எடை போடட்டும். நானே உங்கள் தேவனாகிய கர்த்தர், எகிப்திலிருந்து உங்களை நானே வெளியே அழைத்து வந்தேன். ");
INSERT INTO tam2008_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“எனது கட்டளைகளையும், எனது விதிகளையும் நினைவில் கொண்டு அவற்றுக்கு நீங்கள் கீழ்ப்படிய வேண்டும். நானே கர்த்தர்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“இஸ்ரவேல் ஜனங்களிடம் நீ இவற்றையும் கூற வேண்டும். உங்கள் நாட்டில் உள்ளவர்களில் இஸ்ரவேலரில் ஒருவனோ அல்லது அந்நியரில் ஒருவனோ எவனாவது தன் பிள்ளைகளை போலிதெய்வமாகிய மோளேகுக்கு அர்ப்பணித்தால் அவன் கல்லெறிந்து கொல்லப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","நான் அவனுக்கு எதிராக இருப்பேன். அவன் தன் பிள்ளைகளை மோளேகுக்குக் கொடுத்தபடியால், எனது பரிசுத்தமான பெயருக்கு மரியாதை கொடுக்கவில்லை என்பதை அவன் காட்டிவிட்டான். அவன் எனது பரிசுத்த இடத்தைத் தீட்டாக்கிவிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","அவனை பொது ஜனங்கள் தங்களை விட்டு ஒதுக்கித் தள்ளிவிடலாம். மோளேகுக்குத் தன் பிள்ளையைக் கொடுத்த அவனைப் புறக்கணிக்கலாம். அவர்கள் அவனைக் கொல்லாமல் விடலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ஆனால் நான் அவனுக்கும் அவனது குடும்பத்துக்கும் எதிராக இருப்பேன். அவனை மற்ற ஜனங்களிடம் இருந்து பிரித்து வைப்பேன். என்னிடம் நம்பிக்கையில்லாமல் இருக்கிற எவனையும், மோளேக்குப் பின் செல்லுகிற எவனையும் நான் ஒதுக்கி வைப்பேன். ");
INSERT INTO tam2008_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“மந்திரவாதிகளையும், குறி சொல்லுகிறவனிடமும் எவனாவது அறிவுரை கேட்க நாடிச் சென்றால் நான் அவனுக்கு எதிராக இருப்பேன். அவன் என்னில் நம்பிக்கையற்றவனாக இருப்பதால் அவனை மற்ற ஜனங்களை விட்டு தனியே பிரித்து வைப்பேன். ");
INSERT INTO tam2008_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“நீங்கள் சிறப்பானவர்களாயிருங்கள். உங்களைப் பரிசுத்தப்படுத்திக்கொள்ளுங்கள், ஏனென்றால் நான் பரிசுத்தராய் இருக்கிறேன். நானே உங்கள் தேவனாகிய கர்த்தர். ");
INSERT INTO tam2008_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","என் கட்டளைகளை நினைவில் கொண்டு அவற்றுக்குக் கீழ்ப்படியுங்கள். நானே கர்த்தர். நான் உங்களை பரிசுத்தமாக்குவேன். ");
INSERT INTO tam2008_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“எவனாவது தன் தந்தை அல்லது தாயைச் சபித்தால் அவன் கொலை செய்யப்பட வேண்டும். அவ்வாறு செய்வதினால் அவனது மரணத்துக்கு அவனே பொறுப்புள்ளவனாகிறான். ");
INSERT INTO tam2008_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“எவனாவது பிறனுடைய மனைவியோடு பாலின உறவு கொண்டால் இருவரும் விபசாரம் என்னும் பாவத்துக்கு ஆளாகிறார்கள். எனவே அந்த ஆண், பெண் இருவரும் கொலைச் செய்யப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","எவனாவது தன் தந்தையின் மனைவியோடு பாலின உறவு கொண்டால் அந்த இருவரும் கொலை செய்யப்பட வேண்டும். அவர்களின் மரணத்துக்கு அவர்களே பொறுப்பாவார்கள். அது அவன் தன் தந்தையை நிர்வாணப்படுத்தியது போன்றதாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ஒருவன் தன் மருமகளோடு பாலின உறவு கொண்டால் அந்த இருவரும் கொலை செய்யப்பட வேண்டும். அவர்கள் மிக மோசமான பாலியல் பாவத்தைச் செய்திருக்கிறார்கள். அவர்கள் மரணத்துக்கு அவர்களே பொறுப்பாவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ஒருவன் இன்னொரு ஆணோடு, பெண்ணோடு பாலின உறவு கொள்வது போன்று பாலின உறவு கொண்டால் அந்த இருவரும் பெரும் பாவம் செய்தபடியால் அவர்கள் கொல்லப்பட வேண்டும். அவர்களே தம் மரணத்துக்குப் பொறுப்பாவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ஒருவன் ஒரு தாயோடும் மகளோடும் பாலின உறவு கொண்டால் இதுவும் பெரிய பாலியல் பாவமாகும். ஜனங்கள் அவர்கள் மூவரையும் நெருப்பிலே போட்டுக் கொல்ல வேண்டும். இது போன்ற பாலியல் பாவங்கள் உங்கள் ஜனங்களிடம் ஏற்படாமல் பார்த்துக்கொள்ளுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“எவனாவது மிருகத்தோடு பாலின உறவு கொண்டிருந்தால் அவன் கொல்லப்பட வேண்டும். அந்த மிருகத்தையும் நீ கொன்றுபோட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","ஒரு பெண் மிருகத்தோடு பாலின உறவு கொண்டால் நீ அவளையும் அந்த மிருகத்தையும் கொன்றுவிட வேண்டும். அவர்களே தங்கள் மரணத்துக்குப் பொறுப்பாவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ஒருவன் தன் சகோதரியையோ, சகோதரி முறையுள்ளவளையோ மணந்துகொண்டு அவளோடு பாலின உறவு கொள்வது வெட்ககரமான பாவமாகும். அவர்கள் பொது ஜனங்கள் மத்தியில் தண்டிக்கப்படுவதுடன், மற்ற ஜனங்களிடமிருந்தும் தனியே பிரிக்கப்பட வேண்டும். ஒருவன் தன் சகோதரியோடு பாலின உறவு கொண்ட பாவத்துக்காக அவன் தண்டிக்கப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ஒருவன் ஒரு பெண் மாதவிலக்காக இருக்கும் போது அவளுடன் பாலின உறவு கொண்டால் அவர்கள் இருவருமே தங்கள் ஜனங்களிடமிருந்து தனியே ஒதுக்கப்பட வேண்டியவர்கள். அவளது இரத்தப் போக்கை அவன் திறந்து விட்டிருக்கிறபடியால் அவர்கள் பாவம் செய்தவர்களாகிறார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“நீங்கள் உங்கள் தந்தை அல்லது தாயின் சகோதரியோடு பாலின உறவு கொள்ளக் கூடாது. இது நெருங்கிய உறவோடு பாலின உறவு கொண்ட பாவத்திற்குரியது. உங்கள் பாவத்திற்கு நீங்கள் தண்டிக்கப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ஒருவன் தன் தகப்பனின் சகோதரனுடைய மனைவியோடு பாலின உறவு கொண்டால் அது தகப்பனின் சகோதரனோடு பாலின உறவு கொண்டது போலாகும். அவனும் அவனுடைய தகப்பனின் சகோதரனின் மனைவியும் தண்டிக்கப்பட வேண்டியவர்கள். அவர்கள் குழந்தைகள் இல்லாமல் செத்துப்போவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ஒருவன் தனது சகோதரனின் மனைவியை எடுத்துக்கொள்வது தவறானதாகும். இது அவன் தன் சகோதரனோடு பாலின உறவு கொள்வது போன்றதாகும். அவர்களுக்கும் குழந்தைகள் இல்லாமற்போகும். ");
INSERT INTO tam2008_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“நீங்கள் எனது சட்டங்களையும் விதிகளையும் நினைவில் கொண்டு, அவற்றுக்குக் கீழ்ப்படிய வேண்டும். நான் உங்கள் நாட்டிற்கு உங்களை அழைத்துச் செல்கிறேன். நீங்கள் அங்கு வாழும்போது எனது சட்டங்களுக்கும், விதிகளுக்கும் கீழ்ப்படிந்தால் அந்த நாடு உங்களை கக்கிவிடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","நான் மற்றவர்களை அந்நாட்டினின்று துரத்திவிடுகிறேன். ஏனென்றால் அவர்கள் இத்தகைய பாவங்களையெல்லாம் செய்கின்றனர். நான் அப்பாவங்களை வெறுக்கிறேன். எனவே அவர்களைப் போலவே நீங்களும் வாழாதீர்கள்! ");
INSERT INTO tam2008_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","அவர்களின் நாட்டை நீங்கள் பெற்றுக்கொள்வீர்கள் என்று நான் கூறியிருக்கிறேன். அவர்களின் நாட்டை உங்களுக்குக் கொடுப்பேன். இது உங்கள் நாடாகும். அது நன்மைகள் நிரம்பிய நாடாக இருக்கும். நானே உங்கள் தேவனாகிய கர்த்தர்! “நான் உங்களை என் சிறப்புக்குரிய ஜனங்களாக அழைத்திருக்கிறேன். மற்றவர்களைவிட உங்களை வித்தியாசமாக நடத்தியிருக்கிறேன். ");
INSERT INTO tam2008_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","எனவே நீங்கள் தீட்டுள்ள மிருகங்களிலிருந்து தீட்டு இல்லாத மிருகங்களையும், தீட்டுள்ள பறவைகளிலிருந்து தீட்டில்லாத பறவைகளையும், வேறுபடுத்தி நடத்த வேண்டும். தீட்டுளள்ள பறவைகளையும், மிருகங்ளையும், ஊர்ந்து செல்லுகின்றவற்றையும் உண்ணாதீர்கள். நான் அவற்றைத் தீட்டுள்ளதாகச் செய்திருக்கிறேன். ");
INSERT INTO tam2008_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","நான் உங்களை எனக்கென்று சிறப்பான மக்களாகச் செய்திருக்கிறேன்; எனவே நீங்கள் எனக்குப் பரிசுத்தமாக இருக்கவேண்டும். ஏனென்றால் நான் பரிசுத்தமுள்ளவர். நானே கர்த்தர்! ");
INSERT INTO tam2008_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“மந்திரவாதிகளையும், குறிசொல்லுகிற ஆண்களையும் பெண்களையும் ஜனங்கள் கல்லெறிந்து கொல்ல வேண்டும்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","கர்த்தர் மோசேயிடம், “ஆரோனின் மகன்களான ஆசாரியர்களிடம் பின் வருபவைகளைக் கூறு: ஒரு ஆசாரியன் மரித்த ஒருவனின் உடலைத்தொட்டு தீட்டுள்ளவனாகக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","ஆனால் மரித்தவன் அவனது நெருங்கிய உறவினனாக இருந்தால் அவன் அந்தப் பிணத்தைத் தொடலாம். மரித்துபோனவர்கள் அவரது தாய் அல்லது தந்தை, மகன் அல்லது மகள், சகோதரன் அல்லது ");
INSERT INTO tam2008_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","திருமணமாகாத கன்னித் தன்மையுள்ள சகோதரி எனும் உறவினராக இருந்தால் ஆசாரியன் தீட்டு உள்ளவனாகலாம். திருமணம் ஆகாத சகோதரி என்றால் அவளுக்குக் கணவன் இல்லை. எனவே அவன் அவளுக்கு நெருக்கமானவனாகிறான். அவள் மரித்துப்போனால் அவன் தீட்டுள்ளவனாகலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","ஆனால் ஆசாரியனின் அடிமைகளுள் ஒருவன் மரித்து போனால் அதற்காக ஆசாரியன் தீட்டுள்ளவனாகக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ஆசாரியர்கள் தங்கள் தலையை மொட்டையடிக்கவோ, தங்கள் தாடியின் ஓரங்களை மழிக்கவோ கூடாது. தங்கள் உடலில் வெட்டி எவ்வித அடையாளக் குறிகளும் இல்லாமல் பார்த்துக்கொள்ள வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","இவர்கள் தங்கள் தேவனுக்குப் பரிசுத்தமாக இருக்க வேண்டும். இவர்கள் தேவனின் பெயருக்கு மரியாதை செலுத்த வேண்டும், ஏனென்றால் இவர்கள் கர்த்தரின் தகன பலியையும் அப்பத்தையும் செலுத்துகிறவர்கள். எனவே, பரிசுத்தமாக இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“விசேஷ வழியில் ஒரு ஆசாரியன் தேவனுக்குச் சேவை செய்கிறான். எனவே அவர்கள் வேசியையோ, கற்ப்பிழந்தவளையோ திருமணம் செய்துக்கொள்ளக் கூடாது. கணவனால் விவாகரத்து செய்யப்பட்ட பெண்ணையும் திருமணம் செய்துகொள்ளக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","ஒரு ஆசாரியன் தேவனுக்கு விசேஷ வழியில் சேவை செய்கிறான். ஆகையால் நீங்கள் அவனை விசேஷமாக நடத்த வேண்டும். ஏனென்றால் அவன் பரிசுத்தமான பொருட்களை ஏந்திச் செல்பவன். பரிசுத்தமான அப்பத்தைக் கர்த்தருக்கு எடுத்து வருபவன். நான் பரிசுத்தமானவர்! நானே கர்த்தர். நான் உன்னையும் பரிசுத்தப்படுத்துவேன். ");
INSERT INTO tam2008_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ஒரு ஆசாரியனின் மகள் வேசியானால் அவள் தனது பரிசுத்தத்தைக் குலைத்துகொள்வதுடன், தன் தந்தைக்கும் அவமானத்தைத் தேடித்தருகிறாள். அவளைச் சுட்டெரிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“தலைமை ஆசாரியன் தன் சகோதரர்களுக்கிடையில் இருந்து தலைமை சிறப்பு பதவிக்காக தேர்ந்தெடுக்கப்பட்டவன், சிறப்பான உடைகளை அணிவதற்காக அவன் தேர்ந்தெடுக்கப்பட்டவன். அவன் தலையில் அபிஷேக எண்ணெய் ஊற்றப்பட்டிருக்கும். அவன் தனது துன்பங்களைப் பொது ஜனங்களிடம் வெளிக்காட்டிக்கொள்ளக் கூடாது. அவன் தன் தலை முடியை அதிகமாக வளரும்படிவிடவோ, தன் ஆடைகளைக் கிழித்துக்கொள்ளவோ கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","அவன் பிணத்தைத் தொட்டு தன்னைத் தீட்டுப் பண்ணிக்கொள்ளக் கூடாது. மரித்து போனது அவனது தாயாகவோ தந்தையாகவோ இருந்தாலும் பிணத்தின் அருகில் போகக்கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","தலைமை ஆசாரியன் தேவனின் பரிசுத்தமான இடத்தை விட்டு வெளியே போகக் கூடாது. அவன் அதனால் தீட்டாவதுடன், தேவனின் பரிசுத்தமான இடத்தையும் தீட்டாக்கிவிடுகிறான். அபிஷேக எண்ணெயானது தலைமை ஆசாரியனின் தலைமீது ஊற்றப்பட்டிருக்கிறபடியால், இது அவனை மற்றவர்களிடமிருந்து தனியே பிரித்துக் காட்டும். நானே கர்த்தர்! ");
INSERT INTO tam2008_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“கன்னியான ஒரு பெண்ணை தலைமை ஆசாரியன் மணந்துகொள்ள வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","விபச்சாரியான பெண்ணையோ, வேசியையோ, விதவையையோ, விவாகரத்து செய்யப்பட்டவளையோ மணந்துகொள்ளக் கூடாது. அவன் தன் சொந்த ஜனங்களிடமிருந்து ஒரு கன்னியான பெண்ணை மணந்துகொள்ள வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","அப்பொழுது அவனது பிள்ளைகளை ஜனங்கள் மதிப்பார்கள். கர்த்தராகிய நான் தலைமை ஆசாரியனை அவனது சிறப்புப் பணிகளுக்காகத் தனியாக வைத்திருக்கிறேன்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“ஆரோனிடம் சொல்! உனது சந்ததியில் எவராவது அங்கக் குறைவுள்ளவர்களாக இருந்தால் அவர்கள் தேவனுக்கு சிறப்பு அப்பத்தை எடுத்துச் செல்ல தகுதியற்றவர்களாகிறார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","உடல் உறுப்புகளிலே குறைவுள்ள யாரும் ஆசாரியனாகப் பணிச்செய்யக் கூடாது. எனக்குப் பலிசெலுத்தும் பொருள்களையும் கொண்டுவரக்கூடாது. குருடர், சப்பாணி, முகத்திலே வெட்டுக்காயங்கள் உள்ளவர்கள், கைகளும் கால்களும் அதிக நீளமாய் இருக்கிறவர்கள், ");
INSERT INTO tam2008_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","உடைந்த கைகளும், கால்களும் உடையவர்கள், ");
INSERT INTO tam2008_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","கூனர்கள், குள்ளர்கள், பூ விழுந்த கண்ணுள்ளவர்கள், சொறியர்கள், அசறு உள்ளவர்கள், விதை நசுங்கினவர்கள் ஆகியோர் ஆசாரியனாகத் தகுதியில்லாதவர்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","“ஆரோனின் சந்ததியில் எவராவது இத்தகைய உடல்குறை உடையவர்களாக இருந்தால் அவர்கள் கர்த்தருக்கு எந்த பலிகளையும் கொடுக்க தகுதியற்றுப் போகிறார்கள். அவன் தேவனுக்கு சிறப்பான அப்பத்தை எடுத்துச் செல்ல முடியாது. ");
INSERT INTO tam2008_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","அவன் ஆசாரியர் குடும்பத்தைச் சேர்ந்தவன் என்பதினால் பரிசுத்தமான அப்பத்தையும், மிகப்பரிசுத்தமான அப்பங்களையும் அவன் உண்ணலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","ஆனால் அவன் மிகவும் பரிசுத்தமான இடத்துக்குத் திரையைக் கடந்து போகமுடியாது. பலிபீடத்தின் அருகிலும் செல்ல முடியாது. ஏனென்றால் அவனிடம் குறையுள்ளது. அவன் எனது பரிசுத்தமான இடத்தை அசுத்தப்படுத்தக் கூடாது. கர்த்தராகிய நான் அந்த இடங்களை பரிசுத்தப்படுத்துகிறேன்!” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","ஆகவே இவ்விதிமுறைகள் அனைத்தையும் ஆரோனுக்கும், ஆரோனின் பிள்ளைகளுக்கும், இஸ்ரவேல் ஜனங்கள் அனைவரிடமும் மோசே சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","தேவனாகிய கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“ஆரோனிடமும் அவனது மகன்களிடமும் கூறு: இஸ்ரவேல் ஜனங்கள் எனக்குக் கொடுக்கும் பொருட்கள் பரிசுத்தமானவையாக இருக்கும். அவை என்னுடையவை. எனவே ஆசாரியர்களாகிய நீங்கள் அவற்றை எடுத்துக்கொள்ளக்கூடாது. நீங்கள் பரிசுத்த பொருட்களை உங்கள் சொந்த உபயோகத்துக்குப் பயன்படுத்தினால் நீங்கள் என் பெயருக்கு மரியாதை செலுத்தவில்லை என்று பொருள்படும். நானே கர்த்தர். ");
INSERT INTO tam2008_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","உங்களது சந்ததியார் எவரும் அப்பொருட்களைத் தொட்டால் அவர்கள் தீட்டுள்ளவர்களாகிறார்கள். அவர்கள் என்னிடமிருந்து விலக்கி வைக்கப்பட வேண்டும். இஸ்ரவேல் ஜனங்கள் அப்பொருட்களை எனக்குக் கொடுத்தனர். நானே கர்த்தர். ");
INSERT INTO tam2008_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ஆரோனின் சந்ததிகளில் எவருக்காவது தொழுநோய் இருந்தால் அல்லது உடற்கழிவுகள் இருந்தால் அவனது தீட்டு நீங்கும்வரை பரிசுத்த உணவை உண்ணக்கூடாது. இது, தீட்டுள்ள ஆசாரியர்கள் அனைவருக்கும் உரிய விதியாகும். ஒரு ஆசாரியன் பிணத்தைத் தொடுவதன் மூலமோ, தன் விந்துக்கழிவின் மூலமோ தீட்டு அடையலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","தீட்டுள்ள எந்த ஊர்கின்ற மிருகங்களை அவன் தொட்டாலும் தீட்டு அடையலாம். தீட்டுள்ள மனிதனைத் தொட்டாலும் ஆசாரியன் தீட்டு அடையலாம். எது அவனைத் தீட்டுப்படுத்தியது என்பது ஒரு பொருட்டல்ல. ");
INSERT INTO tam2008_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ஒருவன் மேற்கூறியவற்றுள் ஏதாவது ஒன்றினைத் தொட்டால் அதன் மூலம் அவன் மாலைவரை தீட்டுள்ளவனாக இருக்கிறான். அவன் பரிசுத்தமான உணவு வகைகளில் எதையும் தின்னக் கூடாது. அவன் தண்ணீரால் தன்னைக் கழுவிக்கொண்டாலும் அவன் பரிசுத்த உணவை உண்ணக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","சூரியன் மறைந்த பிறகே அவன் தீட்டு இல்லாதவன் ஆகிறான், பிறகு அவன் பரிசுத்த உணவை உண்ணலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","“ஒரு மிருகம் தானாகவோ அல்லது இன்னொரு மிருகத்தாலோ செத்துப் போயிருக்கலாம். எனினும் ஒரு ஆசாரியன் அதனை உண்ணக்கூடாது. அவன் அதனை உண்டால் அதனால் தீட்டுள்ளவன் ஆகிறான். நானே கர்த்தர். ");
INSERT INTO tam2008_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ஆசாரியன் எனக்குச் சேவை செய்வதற்கென்று சிறப்பான நேரங்கள் உள்ளன. அந்த நேரங்களில் அவர்கள் கவனம் உள்ளவர்களாக இருக்க வேண்டும். பரிசுத்தமானவற்றைப் பரிசுத்தமற்றதாகச் செய்துவிடக் கூடாது. அவர்கள் கவனமாக இருந்தால் அழிந்து போகமாட்டார்கள். கர்த்தராகிய நான் அவர்களைச் சிறப்பான வேலைக்கென்று தனியாகப் பிரித்துவைத்திருக்கிறேன். ");
INSERT INTO tam2008_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","ஆசாரியர்களின் குடும்பத்தில் உள்ளவர்கள் மட்டுமே பரிசுத்த உணவை உண்ண வேண்டும். இவர்களின் வீட்டிற்கு வரும் விருந்தினனோ கூலிக்கு வேலை செய்யும் வேலைக்காரனோ பரிசுத்த உணவை உண்ணக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","ஆனால் ஆசாரியன் தனது சொந்தப் பணத்தின் மூலம் ஒரு அடிமையை வாங்கியிருந்தால், அந்த அடிமை பரிசுத்தமான உணவில் கொஞ்சம் உண்ணலாம். ஆசாரியன் வீட்டிலேயே பிறந்து வளர்ந்த அடிமைகளும் ஆசாரியனின் உணவை கொஞ்சம் உண்ணலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","ஆசாரியனின் மகள் ஆசாரியன் அல்லாத ஒருவனை மணந்துகொண்டால் அவளும் பரிசுத்த பலி உணவுகளை உண்ணக்கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","ஒரு ஆசாரியனின் மகள் விதவையாகலாம், அல்லது அவளுக்கு விவாகரத்து செய்யப்படலாம், அல்லது அவளுக்கு உதவ குழந்தைகள் இல்லாமல் போனதால் அவள் தான் பிறந்து வளர்ந்த தந்தையின் வீட்டிற்குத் திரும்பிவர நேரலாம். அப்போது அவள் தன் தந்தையின் உணவை கொஞ்சம் உண்ணலாம். ஆனால் ஆசாரியன் குடும்பத்தில் உள்ளவர்கள் மட்டுமே இந்த உணவை உண்ண வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ஒருவன் தவறுதலாக பரிசுத்த உணவை உண்டால், அவன் அதற்குரிய விலையில் ஐந்தில் ஒரு பங்கை ஆசாரியனிடம் கூட்டிக் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","“இஸ்ரவேல் ஜனங்கள் கர்த்தருக்குக் கொடுக்கும் அந்த காணிக்கைகள் பரிசுத்தமானவை. எனவே ஆசாரியர்கள் பரிசுத்தமான அவற்றை அசுத்தமாக்கக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ஒருவேளை ஆசாரியர்கள் அவற்றை அசுத்தமாக்கிவிட்டால் அவர்கள் பரிசுத்த உணவை உண்ணும்போது தங்கள் பாவத்தை மிகுதிப்படுத்துகிறார்கள். கர்த்தராகிய நான் அவர்களை பரிசுத்தமாக்குவேன்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","தேவனாகிய கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“ஆரோனிடமும் அவனது மகன்களிடமும் இஸ்ரவேல் ஜனங்களிடமும் கூறு. ஒருவன் இஸ்ரவேல் குடிமக்களில் ஒருவனோ அல்லது அந்நியரில் ஒருவனோ எனக்குப் பலி கொண்டுவர விரும்பலாம். அது அவன் செய்த சிறப்பான பொருத்தனையாக இருக்கலாம், அல்லது அது அவன் கொடுக்க விரும்பும் சிறப்பான பலியாக இருக்கலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","20","அவர்கள் அந்த அன்பளிப்புகளைக் கொண்டுவரலாம். ஏனென்றால் உண்மையில் அவர்கள் தேவனுக்கு அன்பளிப்பு செலுத்த விரும்புகின்றனர். அந்த அன்பளிப்புகளில் ஏதாவது குறை இருக்குமானால் அவற்றை ஏற்றுக்கொள்ளக் கூடாது. அந்த அன்பளிப்பால் நான் மகிழ்ச்சியடையமாட்டேன். அந்த அன்பளிப்பானது ஒரு காளையாகவோ, ஆடாகவோ, வெள்ளாடாகவோ இருக்கலாம். ஆனால் அது ஆணாக இருக்க வேண்டும். அதில் எவ்வித குறையும் இருக்கக்கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","“ஒருவன் சமாதானப் பலியை கர்த்தருக்குக் கொண்டு வரலாம். அந்த சமாதானப் பலியானது அவன் ஏற்கெனவே செய்த சிறப்பான பொருத்தனைக்கு உரியதாக இருக்கலாம். அல்லது சிறப்பாக அவன் கர்த்தருக்குக் கொடுக்கக் கூடிய அன்பளிப்பாக இருக்கலாம். அது மாடாகவோ ஆடாகவோ இருக்கலாம். ஆனால் அது ஆரோக்கியமானதாகவும், ஊனமற்றதாகவும் இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","குருடான, அல்லது எலும்பு முறிந்த, அல்லது நொண்டியான, அல்லது உடற்கழிவுடைய, அல்லது சொறியும் புண்ணும் உடைய மிருகங்களைக் கர்த்தருக்குப் பலியாகக் கொடுக்கக்கூடாது. நோயுற்ற மிருகங்களையும் கர்த்தரின் பலிபீடத்தில் செலுத்தக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","“சில நேரங்களில் மாடு அல்லது ஆட்டிற்கு கால்கள் மிக நீளமாகவோ அல்லது குறுகியோ இருக்கலாம். எனினும் ஒருவன் இதனைக் கர்த்தருக்கு சிறப்பான அன்பளிப்பாகக் கொடுக்க விரும்பினால் அது ஏற்றுக்கொள்ளப்படலாம்; ஆனால் இது சிறப்பான பொருத்தனையின் அன்பளிப்பாக ஒருவனால் கொடுக்கப்பட்டால் அது ஏற்றுக்கொள்ளப்படமாட்டாது. ");
INSERT INTO tam2008_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","“ஒரு மிருகம் காயப்பட்டதாகவோ, நசுங்கியதாகவோ, விதை நொறுங்கியதாகவோ இருந்தால் அதைக் கர்த்தருக்கு பலியாகக் கொடுக்கக்கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","“நீங்கள் அந்நியரிடமிருந்து மிருகங்களைக் கர்த்தருக்குரிய பலியாக எடுத்துக்கொள்ளக் கூடாது. ஏனென்றால் அம்மிருகம் ஏதாவது ஒரு இடத்தில் புண் உள்ளதாகவோ, குறையுடையதாகவோ இருக்கலாம். எனவே, அவற்றை ஏற்றுக்கொள்ளக் கூடாது!” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","கர்த்தர் மேலும் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“ஒரு கன்றுக் குட்டியோ, ஒரு செம்மறி ஆட்டுக் குட்டியோ, ஒரு வெள்ளாட்டுக் குட்டியோ பிறந்ததும் அது ஏழு நாட்கள் தன் தாயோடு இருக்க வேண்டும். எட்டாவது நாளே அது தகன பலியாக கர்த்தருக்கு முன்பு பலியிடத் தகுதியுள்ளதாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","ஆனால் தாயையும், குட்டியையும் ஒரே நாளில் பலியிடக்கூடாது. இந்த விதி பசுவுக்கும் கன்றுக் குட்டிக்கும் பொருந்தும். ");
INSERT INTO tam2008_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“நீ நன்றி தெரிவிப்பதற்காகக் கர்த்தருக்குச் சிறப்பான பலியைச் செலுத்த விரும்பினால் அது உன் விருப்பத்தைப் பொருத்தது. ஆனால் அது தேவனுக்கும் விருப்பமானதாக அமைய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","ஆனால் பலியிடப்படும் முழு மிருகத்தையும் அன்றே சாப்பிட்டுவிட வேண்டும். மறுநாள் காலையில் அதன் இறைச்சியில் எதுவும் மீதியிருக்கக் கூடாது. நானே கர்த்தர். ");
INSERT INTO tam2008_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“எனது கட்டளைகளை நினைவில் வைத்துக்கொள். அவற்றுக்குக் கீழ்ப்படிந்து நட. நானே கர்த்தர். ");
INSERT INTO tam2008_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","எனது பரிசுத்தமான பெயருக்கு மதிப்புகொடு. நான் இஸ்ரவேல் ஜனங்களுக்குச் சிறப்பானவராயிருப்பேன். கர்த்தராகிய நான் உங்களை என் சிறப்பான ஜனங்களாக்கியிருக்கிறேன். ");
INSERT INTO tam2008_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","நான் எகிப்திலிருந்து உங்களை அழைத்து வந்தேன். நானே உங்கள் தேவனாகிய கர்த்தர்!” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","மேலும் கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“இஸ்ரவேல் ஜனங்களிடம் கூறு. கீழ்க்கண்ட பண்டிகைகள் கர்த்தரால் தேர்ந்தெடுக்கப்பட்ட பரிசுத்த கூட்டங்கள் என்று அறிவி: ");
INSERT INTO tam2008_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ஆறு நாட்கள் வேலை செய்யுங்கள். ஏழாவது நாள் ஓய்விற்குரிய சிறப்பு நாள். பரிசுத்தமான சபை கூடும் நாள். அன்று ஒரு வேலையும் செய்யக் கூடாது. இது கர்த்தருக்குரிய சிறப்பு ஓய்வு நாளாக உங்கள் வீடுகளில் விளங்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“கர்த்தர் தேர்ந்தெடுத்த விடுமுறை நாட்கள். பரிசுத்தக் கூட்டங்கள் கூடும் குறித்த காலங்களை நீ அறிவிக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","முதலாம் மாதம் 14ஆம் நாள் அந்தி நேரத்தில் பஸ்கா பண்டிகை நடை பெற வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","“அதே (நிசான்) மாதத்தில் 15ஆம் நாள் புளிப்பில்லாத அப்பப் பண்டிகை வரும். நீங்கள் புளிப்பில்லாத அப்பத்தை ஏழு நாட்கள் உண்ணவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","பண்டிகையின் முதல் நாளில் சிறப்பு சபைக் கூட்டம் இருக்கும். அந்நாளில் நீங்கள் எந்த வேலையும் செய்யக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","ஏழு நாட்களிலும் கர்த்தருக்கு தகன பலிகள் வழங்கப்பட வேண்டும். பிறகு ஏழாவது நாளும் சிறப்பான ஒரு சபைக் கூட்டம் இருக்கும். அந்நாளில் நீங்கள் எந்த வேலையும் செய்யக்கூடாது” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","மேலும் கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“இஸ்ரவேல் ஜனங்களிடம் சொல். நான் கொடுத்த நாட்டிற்குள் நீங்கள் சென்று அங்கே பயிர் செய்து அறுவடை செய்வீர்கள். அப்போது முதல் கதிரில் ஒரு கட்டை ஆசாரியனிடம் கொண்டு வரவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","ஆசாரியன் அக்கதிரை கர்த்தருடைய சந்நிதியில் அசைப்பான். பிறகு அது ஏற்றுக்கொள்ளப்படும். ஆசாரியன் அசைவாட்டும் பலியை ஞாயிற்றுக்கிழமை காலையில் செய்ய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","“கதிரை அசைவாட்டும் பலி செய்கிற நாளில் ஒரு வயதுள்ள குறையற்ற ஒரு ஆண் செம்மறி ஆட்டுக்குட்டியைக் கொண்டு வந்து தகன பலியாகக் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","நீங்கள் தானியக் காணிக்கையையும் வழங்க வேண்டும். 16 கிண்ணங்கள் அளவுள்ள அரைத்த மாவையும், ஒலிவ எண்ணெயையும் கலந்து பலியாக வழங்க வேண்டும். மேலும் திராட்சைப் பழரசத்தில் கால் படியும் கொடுக்க வேண்டும். இக்காணிக்கையின் மணமானது கர்த்தருக்கு மிகவும் பிரியமாயிருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","புதிய தானியத்தையோ, பழங்களையோ, புதிய மாவால் செய்த அப்பத்தையோ உங்கள் தேவனுக்கு பலிகளை செலுத்துவதற்கு முன் உண்ணக் கூடாது. இது உங்கள் தலைமுறை தோறும் தொடர வேண்டிய சட்டமாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“அறுவடை செய்த கதிரைக் கர்த்தருக்கு முன்பு அசைவாட்டும் பலியாக வழங்கிய ஞாயிறு காலையிலிருந்து ஏழு வாரங்களை எண்ணுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","50 நாட்களுக்குப் பிறகு வரும் ஏழாவது ஞாயிற்றுக்கிழமையன்று கர்த்தருக்கு புதிய தானியக் காணிக்கைகளை கொண்டு வாருங்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","அன்று உங்கள் வீட்டிலிருந்து இரண்டு அப்பங்களைக் கொண்டு வாருங்கள். இவை அசைவாட்டும் பலிக்குரியவை. 16 கிண்ணங்கள் அளவுள்ள மாவைப் புளிப்பு சேர்த்து அந்த அப்பங்களைத் தயார் செய்யப் பயன்படுத்துங்கள். இது முதல் அறுவடையானதும் கர்த்தருக்கு நீங்கள் கொடுக்க வேண்டிய காணிக்கையாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","“ஒரு காளை, இரண்டு ஆட்டுக்கடா, ஒரு வயது நிறைந்த ஏழு ஆட்டுக் குட்டிகளையும் தகனபலியாக தானியக் காணிக்கையோடு ஜனங்கள் கொடுக்க வேண்டும். அம்மிருகங்களில் எவ்வித குறையும் இருக்கக் கூடாது. அவற்றைத் தகன பலியாக செலுத்த வேண்டும். இதன் வாசனை கர்த்தருக்கு மிகவும் பிரியமாயிருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","மேலும் நீங்கள் பாவப்பரிகார பலியாக ஒரு ஆட்டுக் கடாவையும், சமாதான பலியாக ஒருவயதான இரண்டு ஆண் ஆட்டுக்குட்டிகளையும் கொண்டுவர வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","“ஆசாரியன் கர்த்தருக்கு முன்பாக அசைவாட்டும் பலி செலுத்தவேண்டும். முதல் அறுவடையின் தானிய மாவால் செய்த அப்பத்தோடு இரண்டு ஆட்டுக் குட்டிகளையும் அசைவாட்டும் பலியாக செலுத்த வேண்டும். கர்த்தருக்குப் பரிசுத்தமான அவைகள் ஆசாரியர்களுக்கு உரியவை. ");
INSERT INTO tam2008_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","அதே நாளில் நீங்கள் பரிசுத்தமான சபைக் கூட்டம் ஒன்றை நடத்த வேண்டும். அன்று வேறு எந்த வேலையும் செய்யக்கூடாது. எக்காலத்திற்கும் உங்கள் தலைமுறைதோறும் இச்சட்டம் தொடர்ந்து இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“நீங்கள் உங்கள் வயலில் அறுவடை செய்யும்போது, வயலின் மூலைகள் வரை சேர்த்து அறுவடை செய்யாதீர்கள். தரையில் விழுந்த தானியங்களை பொறுக்காதீர்கள். அவற்றை ஏழை ஜனங்களுக்கும், அந்நியர்களுக்கும், வழிப்போக்கருக்கும் பயன்படும்படி விட்டுவிடுங்கள். நானே உங்கள் தேவனாகிய கர்த்தர்!” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","மேலும் கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“இஸ்ரவேல் ஜனங்களிடம் கூறு. ஏழாவது மாதத்தில் முதல் நாள் உங்களுக்கு ஓய்வுக்குரிய சிறப்பான நாள் உண்டு. அன்று பரிசுத்த சபைக் கூட்டமும் உண்டு. அன்று எக்காளத்தை ஊதி சிறப்பு நேரத்தை நினைவூட்ட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","அன்று ஒரு வேலையும் செய்யாமல் கர்த்தருக்குரிய தகனபலியைச் செலுத்த வேண்டும்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“ஏழாவது மாதத்தின் பத்தாவது நாளில் பாவப்பரிகாரம் செய்யும் பண்டிகை வரும். அப்போது ஒரு பரிசுத்த சபைக் கூட்டம் உண்டு. அன்று வேலை எதையும் செய்யாமலும், சாப்பிடாமலும் இருக்க வேண்டும். கர்த்தருக்குரிய தகன பலியைக் கொண்டு வரவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","அந்த நாளில் நீங்கள் எந்த வேலையும் செய்யக் கூடாது. ஏனென்றால் அது பாவப் பரிகாரநாள். அந்நாளில் ஆசாரியர்கள் கர்த்தருடைய சந்நிதியில் உங்களைச் சுத்திகரிப்பு செய்யும் சடங்குகளைச் செய்வார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","“அன்று எவனாவது உபவாசம் இருக்க மறுத்தால் அவன் தன் ஜனங்களிடமிருந்து தனியே பிரிக்கப்படுவான். ");
INSERT INTO tam2008_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","இந்நாளில் எவனாவது வேலை செய்தால் அவனை மற்ற ஜனங்களிடமிருந்து நான் அழித்துப் போடுவேன். ");
INSERT INTO tam2008_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","நீங்கள் எந்த வேலையும் அன்று செய்யக்கூடாது என்பது என்றென்றும் தொடர்ந்து வருகிற சட்டமாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","அது உங்களுக்கு ஒரு சிறப்பான ஓய்வு நாளாகும். அந்நாளில் வேறு எதுவும் நீங்கள் செய்யாமல் தாழ்மையான மனதுடன் இருக்க வேண்டும். அந்த சிறப்பான பண்டிகை அம்மாதத்தின் ஒன்பதாவது நாள் மாலையிலிருந்து மறுநாள் மாலைவரை தொடர்ந்திருக்கும்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“இஸ்ரவேல் ஜனங்களிடம் கூறு; ஏழாவது மாதத்தின் 15 ஆம் தேதி முதல் ஏழுநாட்கள் கூடாரப் பண்டிகை நடைபெறும். ");
INSERT INTO tam2008_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","முதல் நாள் பரிசுத்தமான சபைக்கூட்டம் ஒன்று நடைபெறும். அன்று நீங்கள் எந்த வேலையும் செய்யக்கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","நீங்கள் ஏழு நாட்கள் தகன பலியை கர்த்தருக்குக் கொண்டு வர வேண்டும். மறுபடியும் எட்டாவது நாள் பரிசுத்த சபைக் கூட்டம் நடை பெறும். நீங்கள் தகனபலியைக் கர்த்தருக்குக் கொண்டு வர வேண்டும். இதுவே பரிசுத்த சபைக் கூட்டமாகும். அன்று நீங்கள் எந்த வேலையும் செய்யக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“இவை கர்த்தரின் சிறப்பான விடுமுறைகள். அந்நாட்களில் பரிசுத்த சபைக் கூட்டங்களும் நடைபெறும். நீங்கள் கர்த்தருக்குத் தகன பலிகளையும், தானிய காணிக்கைகளையும், பானங்களின் பலியையும் சரியான நேரத்தில் கொண்டு வர வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","கர்த்தரின் ஓய்வு நாட்களை நினைவுபடுத்துவதோடு இந்த விடுமுறை நாட்களையும் நீங்கள் கொண்டாடவேண்டும். மற்ற அன்பளிப்போடு இவைகளையும் கர்த்தருக்குக் கொண்டு வரவேண்டும். சிறப்பான பொருத்தனைகளுக்கான பலிகளையும் கர்த்தருக்குக் கொண்டுவர வேண்டும். கர்த்தருக்காகச் சிறப்பாக கொடுக்கப்படும் பலிகளோடு இவைகளையும் சேர்த்துக் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ஏழாவது மாதத்தின் 15வது நாளில் நிலத்தின் விளைச்சலைச் சேர்த்து வைக்கும்போது கர்த்தருக்கு ஏழு நாள் பண்டிகையைக் கொண்டாடுங்கள். முதல் நாளிலும் எட்டாவது நாளிலும் நீங்கள் ஓய்வெடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","முதல் நாள் பழமரங்களில் இருந்து நல்ல பழங்களையும், ஈச்சமரத்தின் கிளைகளையும், தழைத்துள்ள மரக்கிளைகளையும், வில்லோ மரக்கிளைகளையும் எடுத்துகொண்டு வந்து, ஏழு நாட்கள் தேவனாகிய கர்த்தரின் சந்நிதானத்தில் மகிழ்ச்சியாகக் கொண்டாடுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","ஒவ்வொரு ஆண்டும் இப்பண்டிகையைக் கர்த்தருக்கு முன் ஏழு நாட்கள் கொண்டாடுங்கள். இவ்விதிகள் எக்காலத்திற்கும் உரியவையாகும். இதனை நீங்கள் ஏழாவது மாதத்தில் கொண்டாட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","நீங்கள் ஏழு நாட்களிலும் தற்காலிகமான கூடாரங்களில் தங்கியிருக்கவேண்டும். இஸ்ரவேலில் பிறந்த அனைத்து ஜனங்களும் இக்கூடாரங்களில் தங்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ஏனென்றால் எகிப்திலிருந்து உங்களை அழைத்து வரும் போது நீங்கள் தற்காலிகமான கூடாரங்களில் தங்கியிருந்தீர்கள் என்பதை உங்கள் சந்ததியினர் உணர்ந்துகொள்ள வேண்டும். நானே உங்கள் தேவனாகிய கர்த்தர்!” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","எனவே, மோசே இஸ்ரவேல் ஜனங்களிடம் கர்த்தரைக் கனப்படுத்துகிற பண்டிகைகளைப்பற்றிக் கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“இடித்துப் பிழிந்த சுத்தமான ஒலிவ எண்ணெயைக் கொண்டுவரும்படி இஸ்ரவேல் ஜனங்களுக்குக் கட்டளையிடு. அந்த எண்ணெய் குத்து விளக்கிற்குரியது. அது அணையாமல் தொடர்ந்து எரியவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","ஆரோன் இந்த விளக்கை ஆசாரிப்புக் கூடாரத்தில் கர்த்தருடைய சந்நிதானத்தில் மாலைமுதல் காலைவரை அணையாமல் காக்கவேண்டும். இது திரைக்கு வெளியே உடன்படிக்கைப் பெட்டிக்கு முன்பு எரிய வேண்டும். இச்சட்டம் என்றென்றைக்குமுரியது. ");
INSERT INTO tam2008_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","ஆரோன் கர்த்தரின் சந்நிதியில் சுத்தமான தங்கத்தாலான விளக்குத்தண்டில் விளக்கைப் பொருத்தி எப்பொழுதும் எரியவிட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“அரைத்த மாவை எடுத்து அதில் பன்னிரெண்டு அப்பங்களைச் செய்யுங்கள். ஒவ்வொரு அப்பமும் பதினாறு கிண்ணங்கள் அளவு மாவால் செய்யப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","கர்த்தருக்கு முன்பாக தங்கத்தாலான மேஜையின்மேல் இரண்டு வரிசையாக அப்பங்களை அடுக்க வேண்டும். ஒவ்வொரு வரிசையிலும் ஆறு அப்பங்கள் இருக்கட்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","ஒவ்வொரு வரிசைக்கும் சாம்பிராணிப் புகை காட்டு. அது அப்பத்தோடு இருந்து, கர்த்தருக்கு நினைவு அடையாளமாக, தகன பலியாக கர்த்தருக்கு ஏற்றதாக இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","அப்பத்தை இவ்வரிசையிலேயே ஒவ்வொரு ஓய்வு நாளிலும் ஆரோன் கர்த்தருக்கு முன்பு வைக்க வேண்டும். இது எல்லாக் காலங்களுக்குமுரியது. இஸ்ரவேல் ஜனங்களோடு உள்ள இந்த உடன்படிக்கை என்னென்றும் தொடரும். ");
INSERT INTO tam2008_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","இந்த அப்பங்கள் ஆரோனுக்கும் அவனது மகன்களுக்கும் உரியதாகும். அவர்கள் பரிசுத்தமான இடங்களில் அவற்றை உண்ண வேண்டும்; ஏனென்றால் அவை கர்த்தருக்குத் தகன பலியாகக் கொடுக்கப்பட்டவை. அது என்றென்றும் ஆரோனின் பங்காக இருக்கும்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","இஸ்ரவேல் பெண்ணுக்குப் பிறந்த ஒருவன் இருந்தான். அவனது தந்தை எகிப்தியன். இஸ்ரவேலியப் பெண்ணுக்கு பிறந்த அம்மகன் இஸ்ரவேலைச் சேர்ந்தவன். அவன் இஸ்ரவேல் ஜனங்களோடு நடந்துகொண்டிருந்தான். அவன் முகாமில் இன்னொரு இஸ்ரவேலனோடு சண்டையிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","அப்போது அவன் கர்த்தரின் நாமத்தைத் தூஷித்து, அவரைப்பற்றிக் கெடுதலாகப் பேசினான். எனவே அவனை மோசேயிடம் அழைத்து வந்தார்கள். (அவனது தாயின் பெயர் செலோமித். அவள் தாண் கோத்திரத்தானாகிய திப்ரியின் மகள்.) ");
INSERT INTO tam2008_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","ஜனங்கள் அவனைச் சிறையில் வைத்துவிட்டு, அவனைப்பற்றிய தெளிவான பதிலைப் பெறும்படி கர்த்தரின் கட்டளைக்காகக் காத்திருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“முகாமுக்கு வெளியே ஒரு இடத்திற்கு அவனைக் கொண்டு வா. அவன் தூஷணம் பேசியதைக் காதால் கேட்ட எல்லோரையும் ஒன்றுகூட்டி அழைத்து வா. அவர்கள் தங்கள் கைகளை அவன் தலையில் வைக்கவேண்டும், பிறகு ஜனங்கள் அவன் மீது கல்லெறிந்து கொல்ல வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","இஸ்ரவேல் ஜனங்களிடம் கூற வேண்டும்: எவனாவது தேவனை தூஷித்தால் அவன் தண்டிக்கப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","கர்த்தருக்கு எதிராக பேசுகிற எவனையும் எல்லோரும் சேர்ந்து கல்லெறிந்து கொன்று போடவேண்டும். அவன் அந்நியனாக இருந்தாலும் அவனும் இஸ்ரவேல் ஜனங்களைப் போன்றே தண்டிக்கப்பட வேண்டும். கர்த்தரின் நாமத்தைத் தூஷிக்கிற எவனும் சாகடிக்கப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“எவனாவது ஒரு கொலை செய்தால் அவனுக்கு மரணதண்டனை உண்டு. ");
INSERT INTO tam2008_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","ஒருவன் இன்னொருவனுக்குரிய மிருகத்தைக் கொன்றால் அதற்குப் பதிலாக இன்னொரு மிருகத்தைக் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“எவனாவது இன்னொருவனைக் காயப்படுத்தினால் அவனுக்கும் அதைப் போன்ற காயத்தை உண்டாக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","உடைந்த எலும்புக்கு எலும்பு உடைபட வேண்டும். கண்ணுக்குக் கண், பல்லுக்குப் பல். அடுத்தவனுக்கு எவ்விதமான காயங்களை ஒருவன் உண்டாக்குகிறானோ, அதே விதமான காயங்களை அவன் அடைவான். ");
INSERT INTO tam2008_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","எனவே ஒருவன் ஒரு மிருகத்தைக் கொன்றால் அவன் அதற்குரிய தொகையைக் கொடுக்க வேண்டும். ஆனால் ஒருவன் இன்னொருவனைக் கொன்றுவிட்டால் அவன் மரண தண்டனையடைய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","“இந்த சட்டம் நடுநிலையாக இருக்கும். இஸ்ரவேல் குடிமக்களுக்கும் அயல் நாட்டுக்காரர்களுக்கும் ஒரே நீதிதான். ஏனென்றால் நான் தேவனாகிய கர்த்தர்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","பிறகு மோசே இஸ்ரவேல் ஜனங்களிடம் பேசினான். ஜனங்கள் தேவனைத் தூஷித்தவனை முகாமுக்கு வெளியே கொண்டு சென்று அங்கு அவனைக் கல்லெறிந்து கொன்றார்கள். இவ்வாறு இஸ்ரவேல் ஜனங்கள், கர்த்தர் மோசேக்குக் கட்டளையிட்டபடி செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","சீனாய் மலையில் கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“நீ இஸ்ரவேல் ஜனங்களிடம் கூற வேண்டியதாவது; நான் உங்களுக்குக் கொடுக்கப்போகும் நாட்டிற்குள் சென்ற பின்னர் ஓய்வுக்கென சிறப்பான காலத்தை அந்நாடு கொண்டிருக்க நீங்கள் அனுமதிக்க வேண்டும். இது கர்த்தரைப் பெருமைப் படுத்துகிற ஓய்வுக்காலம் ஆகும். ");
INSERT INTO tam2008_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ஆறு ஆண்டுகளுக்கு, உங்கள் வயல்களில் விதைகளை விதையுங்கள், உங்கள் திராட்சைத் தோட்டத்தில் கிளை கழியுங்கள். அதன் பழங்களைக் கொண்டு வாருங்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ஆனால் ஏழாவது ஆண்டில் அந்நிலத்துக்கு ஓய்வு அளியுங்கள். இது கர்த்தரைப் பெருமைப்படுத்துகிற சிறப்பான ஓய்வுக் காலமாகும். அப்போது வயலில் விதை விதைக்காமலும், திராட்சை தோட்டத்தில் பயிர் செய்யாமலுமிருங்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","அறுவடைக்குப் பிறகு வயலில் தானாக வளர்ந்து விளைந்தவற்றை அறுவடை செய்யவோ, கிளை கழிக்காத கொடிகளில் உள்ள திராட்சைப் பழங்களைப் பறிக்கவோ கூடாது. பூமி ஒரு வருடம் ஓய்வு கொள்ளட்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","“நிலம் ஒரு வருடம் ஓய்வாக விடப்பட்டாலும் உங்களிடம் போதுமான உணவுப் பொருட்கள் இருக்கும். உங்களுக்கும், உங்கள் ஆண், பெண், வேலையாட்களுக்கும், உங்கள் நாட்டிலுள்ள கூலி வேலைக்காரர்களுக்கும், அயல்நாட்டுக்காரர்களுக்கும்கூட போதுமான உணவுப் பொருட்கள் இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","உங்கள் பசுக்களுக்கும் மற்ற மிருகங்களுக்கும்கூட போதுமான உணவு இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“மேலும் நீங்கள் ஏழு ஓய்வு ஆண்டுகள் கொண்ட ஏழு ஓய்வு ஆண்டுகளை எண்ணுங்கள். அது மொத்தம் 49 ஆண்டுகளாகும். அந்த 49 வருடங்களில் மொத்தத்தில் ஏழு ஆண்டுகளுக்கு பூமிக்கு ஓய்வு கிடைக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","பாவப்பரிகார நாளில் செம்மறியாட்டுக் கடாவின் கொம்பினால் செய்யப்பட்ட எக்காளத்தை ஊதவேண்டும். அது ஏழாவது மாதத்தின் பத்தாவது நாளாக இருக்கும். நாடு முழுவதும் எக்காளம் ஊதிக் கொண்டாட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","நீங்கள் ஐம்பதாவது ஆண்டினைச் சிறப்பாகக் கொண்டாட வேண்டும். உங்கள் நாட்டில் உள்ள அனைவருக்கும் விடுதலை என்று அறிவிக்க வேண்டும். இந்த விழாவை ‘யூபிலி’ என்று அழைப்பீர்கள். நீங்கள் ஒவ்வொருவரும் உங்களது சொந்த சொத்திற்கும், சொந்த குடும்பத்திற்கும் திரும்புவீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","உங்களுக்கு ஐம்பதாவது ஆண்டு விழா மிகச் சிறப்பான யூபிலி விழாவாகும். அவ்வருடத்தில் விதைகளை விதைக்காதீர்கள். தானாக வளர்ந்த பயிர்களை அறுவடை செய்யாதீர்கள். கிளை கழிக்காத செடிகளில் உள்ள திராட்சைகளைப் பறிக்காதீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","அது யூபிலி ஆண்டு, அது உங்களுக்குப் பரிசுத்தமான வருடமாகும். உங்கள் வயலில் விளைந்தவற்றை உண்ணுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","யூபிலி ஆண்டில் ஒவ்வொருவனும் தன் சொந்த பூமிக்குச் செல்லவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“உனது அயலானிடம் நிலம் விற்கும்போது ஏமாற்றாதே. அதுபோல் நீ நிலம் வாங்கும்போது அவன் உன்னை ஏமாற்றும்படி விடாதே. ");
INSERT INTO tam2008_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","நீ அயலானின் நிலத்தை வாங்கும்போது அந்த நிலத்தின் யூபிலியைக் கணக்கிட்டு அதற்கேற்ற விலையை நிர்ணயித்துக்கொள். நிலத்தை விற்கும்போதும் அதனுடைய அறுவடைகளைக் கணக்கிட்டு அதன் மூலம் சரியான விலையை நிர்ணயித்துக்கொள். ஏனென்றால் அடுத்த யூபிலிவரை அறுவடை செய்யும் உரிமையை மட்டுமே விற்கிறான். ");
INSERT INTO tam2008_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","யூபிலிக்கு முன் அதிகமான ஆண்டுகள் விளைந்த நிலம் அதிக விலையை உடையது. குறைந்த ஆண்டுகள் விளைந்த நிலத்தின் விலை குறையும். ஏனென்றால் உனது அயலான் உன்னிடம் அறுவடைகளின் எண்ணிக்கைகளையே விற்பனை செய்கிறான். அடுத்த யூபிலியில் அந்த நிலம் மீண்டும் அவனுக்கு உரியதாகிவிடும். ");
INSERT INTO tam2008_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","ஒருவரை ஒருவர் ஏமாற்றக் கூடாது. உங்கள் தேவனை நீங்கள் பெருமைபடுத்த வேண்டும். நானே உங்களுடைய தேவனாகிய கர்த்தர்! ");
INSERT INTO tam2008_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“எனது சட்டங்களையும், விதிகளையும் நினைவில் வைத்துக்கொள்ளுங்கள். அவற்றைப் பின்பற்றுங்கள், அப்போது உங்கள் நாட்டில் நீங்கள் பாதுகாப்போடு வாழலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","நிலம் உங்களுக்கு நல்ல விளைச்சலைத் தரும். நீங்கள் அதிக விளைபொருட்களைப் பெற்று நாட்டில் வசதியோடு வாழலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","“ஆனால் நீங்கள் ‘நான் விளைய வைத்துப் பொருட்களைச் சேர்த்து வைக்காவிட்டால் ஏழாவது ஆண்டில் வசதியாக உண்ண முடியாது’ என்று சொல்லலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","கவலைப்படாதிருங்கள்! ஆறாவது ஆண்டில் என் ஆசீர்வாதம் உங்களுக்குக் கிடைக்கும்படி கட்டளையிடுவேன். தொடர்ந்து நிலம் மூன்று ஆண்டுகளுக்கு நன்கு விளையும். ");
INSERT INTO tam2008_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","நீ எட்டாவது ஆண்டில் பயிர் செய்யும் போதும் பழைய விளைச்சலையே உண்டுகொண்டிருப்பாய். ஒன்பதாவது ஆண்டில் புதிய விளைச்சல் கிடைக்கும்வரை இவ்வாறு செய்வாய். you planted in the eighth year ");
INSERT INTO tam2008_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“இந்த நிலம் உண்மையில் எனக்குரியது. எனவே இதனை நீங்கள் நிரந்தரமாக விற்கமுடியாது. அந்நியர்களாகவும் பயணிகளாகவுமே என் நிலத்தில் நீங்கள் அனைவரும் என்னோடு வாழ்கிறீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","ஜனங்கள் தங்கள் நிலத்தை விற்றுவிடலாம். எனினும் அது அவர்களின் குடும்பத்திற்கு மீண்டும் வந்து சேரும். ");
INSERT INTO tam2008_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","உங்களில் ஒருவன் மிகவும் வறியவனாகவோ, தன் சொத்துக்களை விற்கும் அளவுக்கு ஏழையாகவோ மாறலாம். அப்போது அவனுக்கு நெருக்கமான உறவினரில் எவராவது வந்து அதனைத் திரும்ப வாங்கிக்கொள்ள வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","அவனிடமிருந்து நிலத்தை திரும்ப வாங்குகிற அளவுக்கு நெருக்கமான உறவினர்கள் இல்லாமற் போகும்போது, அந்த நிலத்தைத்தானே திரும்ப வாங்குகிற அளவிற்கு அவன் பணத்தை சேகரித்திருக்கலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","பிறகு அவன் நிலத்தை விற்ற ஆண்டுகளைக் கணக்கிட்டு, அந்த எண்ணிக்கை மூலம் எவ்வளவு விலை கொடுக்க வேண்டும் என்று முடிவு செய்து அதனைத் திரும்ப விலைக்கு வாங்கலாம். அதனால் அச்சொத்து அவனுக்கு மீண்டும் உரியதாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","ஆனால் ஒருவேளை அவனுக்குத் தன் நிலத்தை திரும்ப வாங்குகிற அளவிற்குப் பணம் சேர்க்கமுடியாமல் போனால் அப்போது அந்த நிலம் யூபிலி ஆண்டுவரை வாங்கியவனிடமே இருக்கும். பிறகு சிறப்பான யூபிலி விழா நடக்கும்போது அந்நிலம் முதல் உரிமையாளனுக்கு மீண்டும் சேர்ந்துவிடும். எனவே, சரியான குடும்பத்துக்கு அந்த சொத்தானது மீண்டும் சொந்தமாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ஒருவன், மதில் சூழ்ந்த பட்டணத்திலுள்ள தன் வீட்டை விற்றால் ஒரு ஆண்டு வரை மட்டுமே அவனுக்குத் திரும்ப வாங்கிக்கொள்கிற உரிமை உண்டு. ");
INSERT INTO tam2008_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","ஆனால் வீட்டுக்குச் சொந்தக்காரன் அதனைத் திரும்ப வாங்கிக்கொள்ள முடியாவிட்டால் அது வாங்கியவனுக்கும் அவனது சந்ததிகளுக்கும் உரிமையாகிவிடும். வீடு யூபிலி ஆண்டில் நிலத்தைப் போன்று அதன் சொந்தக்காரனுக்குப் போய்ச் சேர்வதில்லை. ");
INSERT INTO tam2008_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","மதில் இல்லாத பட்டணங்களாக இருந்தால் அது வயல் வெளியாக எண்ணப்படும். அதில் உள்ள வீடுகள் மட்டுமே யூபிலி ஆண்டின் போது உண்மையான சொந்தக்காரனுக்கு சேரும். ");
INSERT INTO tam2008_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ஆனால் லேவியரின் நகரம்பற்றி வேறு விதிகள் உள்ளன. லேவியர்கள் நகரங்களில் தங்கள் வீடுகளை எப்போது வேண்டுமானாலும் மீண்டும் வாங்கிக்கொள்ளலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","லேவியர்களிடமிருந்து யாரவது ஒரு வீடு வாங்கினால் லேவியரின் நகரங்களிலுள்ள வீடுகளெல்லாம் யூபிலி ஆண்டில் மீண்டும் அவர்களுக்கே உரியதாகிவிடும். ஏனென்றால் லேவியரின் நகரங்கள் எல்லாம் லேவியின் கோத்திரங்களுக்கு சொந்தம். இஸ்ரவேல் ஜனங்கள் இதனை லேவியர்களுக்குக் கொடுத்துவிட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","அதோடு லேவியரின் நகரங்களைச் சுற்றியிருக்கிற வெளி நிலங்களை விற்கமுடியாது. அது எப்போதும் லேவியர்களுக்கே உரியதாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“உன் சகோதரரில் ஒருவன் மிகவும் வறுமையனாகிவிட்டால் அவன் அயல் நாட்டுக்காரனைப் போன்று உன்னோடு பிழைக்கும்படி அனுமதிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","நீ அவனுக்குக் கடன் கொடுத்து அவனிடம் வட்டி வாங்காமல் இருப்பாயாக. தேவனுக்குரிய மதிப்பைக் கொடுத்து, உன் சகோதரனை வாழவிடுவாயாக. ");
INSERT INTO tam2008_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","அவனிடம் நீ கொடுத்த கடனுக்காக வட்டி வாங்காதே. நீ விற்கிற உணவிற்கு மிகுதியாக லாபம் வரும்படி செய்யாதே. ");
INSERT INTO tam2008_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","நான் உங்கள் தேவனாகிய கர்த்தர். உன்னை எகிப்தில் இருந்து அழைத்து வந்து கானான் நாட்டைக் கொடுத்து, உனது தேவனாக ஆனேன். ");
INSERT INTO tam2008_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“உனது சகோதரன் ஒருவன் ஏழ்மை காரணமாக உன்னிடம் அடிமையாக இருக்கலாம். நீ அடிமைபோன்று அவனை வேலை வாங்கக்கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","யூபிலி ஆண்டு வரை அவன் ஒரு கூலிக்காரனைப் போன்றும் ஒரு பயணியைப் போலவும் இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","பிறகு அவன் உன்னைவிட்டுச் செல்லலாம். அவன் தன் பிள்ளைகளைக் கூட்டிக்கொண்டு மீண்டும் தன் குடும்பத்துக்குத் திரும்பமுடியும். அவன் தனது முற்பிதாக்களின் சொத்துக்களைப் பெற்றுக்கொள்வான். ");
INSERT INTO tam2008_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","ஏனென்றால் அவர்கள் எனது ஊழியர்கள். அவர்களை நான் அடிமைத்தனத்திலிருந்து மீட்டு எகிப்திலிருந்து அழைத்து வந்தேன். அவர்கள் மீண்டும் அடிமையாகக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","இவர்களுக்குக் கொடூரமான எஜமானனாக நீங்கள் இருக்கக் கூடாது. நீங்கள் தேவனுக்கு பயப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“உங்கள் ஆணும் பெண்ணுமான அடிமைகளைப்பற்றிய காரியங்களாவன: உங்களைச் சுற்றியுள்ள நாடுகளிலிருந்து அடிமைகளை அழைத்து வரலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","உங்கள் தேசத்தில் வசிக்கும் அயல் நாட்டவர்கள் குடும்பங்களில் இருந்து நீங்கள் அடிமைகளாக சிறுவர்களையும் அழைத்து வந்திருக்கலாம். அந்த அடிமைச் சிறுவர்கள் உனக்கு உரியவர்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","உங்கள் இறப்பிற்குப் பின் உங்களது பிள்ளைகளின் வசத்தில் அவர்கள் இருப்பார்கள். என்றென்றும் அவர்கள் உங்களது அடிமைகளாக இருக்கலாம். இந்த அயல் நாட்டுக்காரர்களை உங்கள் அடிமைகளாக வைத்துக்கொள்ளலாம். ஆனால் உங்கள் சொந்தச் சகோதரர்களாகிய இஸ்ரவேல் ஜனங்களுக்கு ஒரு கொடுமையான எஜமானனாக நீ இருக்கக்கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“அயல் நாட்டுக்காரரோ பயணிகளோ செல் வந்தர் ஆகலாம். உன் சொந்த நாட்டுக்காரன் ஏழையாக இருப்பதினால் அவர்கள் அயல் நாட்டுக்காரர் ஒருவருக்கு அடிமையாகலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","அவன் திரும்பவும் சுதந்திரமானவனாக முடியும். அவனது சகோதரரில் ஒருவன் அவனை விலை கொடுத்து மீட்டுவிடலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","அவனது சித்தப்பாவோ, பங்காளிகளோ, அவனைத் திரும்ப வாங்கலாம். ஆனால் அவனுக்குப் போதுமான பணம் இருந்தால் தானே அதனைக் கொடுத்துவிட்டு சுதந்திரம் பெற்றுவிடலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","“அவன் தன்னை விற்றுக்கொண்ட ஆண்டு முதல் அடுத்த யூபிலி வரை எண்ணிக்கொள்ள வேண்டும். ஆண்டுகளின் எண்ணிக்கையை வைத்து விலையை முடிவு செய்யலாம். ஏனென்றால் அவன் சில ஆண்டுகளே தன்னை ‘வாடகையாகத்’ தந்திருக்கிறான். ");
INSERT INTO tam2008_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","யூபிலி ஆண்டு வருவதற்கு இன்னும் பல ஆண்டுகள் இருந்தால் அவன் கொடுக்க வேண்டிய விலை மிகுதியாக இருக்கும். அவன் அதனைக் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","யூபிலி ஆண்டு வர இன்னும் கொஞ்சம் ஆண்டுகளே இருந்தால் அவன் கொடுக்க வேண்டிய விலை குறைவாக இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","ஆனால் அவன் ஒரு வாடகை ஆளைப் போன்று அயல் நாட்டுக்காரனோடு ஒவ்வொரு ஆண்டும் இருக்க வேண்டும். அந்த அயல் நாட்டுக்காரன் கொடூரமான எஜமானனாக இல்லாமல் இருக்கட்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“அவனை யாரும் திரும்பி வாங்காவிட்டாலும் யூபிலி ஆண்டில் அவனும் அவனது பிள்ளைகளும் விடுதலை பெறுவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","ஏனென்றால் இஸ்ரவேல் ஜனங்கள் எல்லாரும் எனது ஊழியர்கள். நான் அவர்களை எகிப்தின் அடிமைத்தனத்திலிருந்து மீட்டேன். நானே உங்கள் தேவனாகிய கர்த்தர்! ");
INSERT INTO tam2008_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“உங்களுக்காக விக்கிரகங்களை ஏற்படுத்தாதீர்கள். உங்கள் நாடுகளில் சிலைகளையோ நினைவுச் சின்னங்களையோ வணங்குவதற்காக ஏற்படுத்தாதீர்கள். ஏனென்றால் நானே உங்கள் தேவனாகிய கர்த்தர்! ");
INSERT INTO tam2008_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“எனது சிறப்பான ஓய்வு நாட்களை நினைவில் கொள்ளுங்கள். எனது பரிசுத்தமான இடங்களைப் பெருமைப்படுத்துங்கள். நானே கர்த்தர்! ");
INSERT INTO tam2008_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“எனது சட்டங்களையும் கட்டளைகளையும் நினைவில் கொண்டு அவற்றுக்குக் கீழ்ப்படியுங்கள்! ");
INSERT INTO tam2008_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","நீங்கள் இவற்றைச் செய்தால் நான் உரிய பருவத்தில் மழையைத் தருவேன். நிலம் நன்றாக விளையும். மரங்கள் நல்ல பழங்களைத் தரும். ");
INSERT INTO tam2008_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","திராட்சைப் பழம் பறிக்கும் காலம்வரை உங்கள் போரடிப்புக் காலம் இருக்கும். விதைப்புக் காலம்வரை திராட்சைப்பழம் பறிக்கும் காலம் இருக்கும். நீங்கள் உங்கள் அப்பத்தைத் திருப்தியாகச் சாப்பிட்டு உங்கள் நாட்டில் சுகமாய் குடியிருப்பீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","உங்கள் நாட்டில் சமாதானத்தை உருவாக்குவேன். நீங்கள் பாதுகாப்புடன் இருப்பீர்கள். எவரும் வந்து உங்களை நெருங்கி அச்சுறுத்த முடியாது. தீமை செய்யும் மிருகங்களை நாட்டுக்கு வெளியே வைத்திருப்பேன். வேறு படைகளும் உங்கள் நாட்டின் வழியாகக் கடந்து செல்லாது. ");
INSERT INTO tam2008_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","“நீங்கள் உங்களது பகைவர்களைத் துரத்தி சென்று தோற்கடிப்பீர்கள். உங்கள் வாளால் அவர்களைக் கொல்வீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","ஐந்து பேரான நீங்கள் நூறு பேரை விரட்டிச் செல்வீர்கள், நூறு பேராக இருந்தாலும் நீங்கள் பத்தாயிரம் பேரை விரட்டிச்சென்று அவர்களை வாளால் வெட்டிக் கொல்லுவீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“நான் உங்கள்மேல் கவனமாயிருந்து நிறைய குழந்தைகளை நீங்கள் பெறும்படி செய்வேன். நான் எனது உடன்படிக்கையை பாதுகாப்பேன். ");
INSERT INTO tam2008_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","நீங்கள் ஒரு ஆண்டு விளைச்சலைப் போதுமான அளவிற்கு மேல் பெற்றிருப்பீர்கள். புதிய விளைச்சலும் பெறுவீர்கள். புதியதை வைக்க இடமில்லாமல் பழையதை எறிவீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","உங்கள் நடுவே எனது ஆராதனைக் கூடாரத்தை அமைப்பேன். நான் உங்களிடமிருந்து விலகிச் செல்லமாட்டேன். ");
INSERT INTO tam2008_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","நான் உங்களோடு நடந்து உங்கள் தேவனாக இருப்பேன். நீங்களே எனது ஜனங்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","நானே உங்கள் தேவனாகிய கர்த்தர். நீங்கள் எகிப்தில் அடிமைகளாக இருந்தீர்கள். நான் உங்களை அங்கிருந்து மீட்டு வந்தேன். அடிமைகளாக நீங்கள் சுமந்த பாரத்தால் முதுகு வளைந்துபோனீர்கள். நான் உங்கள் நுகத்தடிகளை உடைத்து உங்களை நிமிர்ந்து நடக்கச் செய்தேன்! ");
INSERT INTO tam2008_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“நீங்கள் எனக்கு கீழ்ப்படியாவிட்டாலோ அல்லது என் கட்டளையை பின்பற்றாவிட்டாலோ கீழ்க்கண்ட தீமைகள் உங்களுக்கு ஏற்படும். ");
INSERT INTO tam2008_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","நீங்கள் எனது சட்டங்களுக்கும் கட்டளைகளுக்கும் கீழ்ப்படிய மறுத்தால் எனது உடன்படிக்கையை மீறினவர்களாக மாறுகிறீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","நீங்கள் அவ்வாறு செய்தால் நான் உங்களுக்கு மோசமான தீமைகளை உருவாக்குவேன். நோய்களையும் காய்ச்சலையும் உங்களுக்கு வரச் செய்வேன். அவை உங்கள் கண்களையும் ஜீவனையும் கெடுக்கும். நீங்கள் செய்யும் பயிர் விளைச்சலில் நீங்கள் வெற்றி பெற முடியாது. உங்கள் பகைவர்கள் உங்களது விளைச்சலை உண்பார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","நான் உங்களுக்கு எதிராக இருப்பேன். எனவே உங்களை உங்கள் எதிரிகள் வெல்வார்கள். அவர்கள் உங்களை வெறுத்து ஆட்சி செலுத்துவார்கள். உங்களை எவரும் துரத்தாவிட்டாலும் நீங்கள் பயந்து ஓடுவீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“இவற்றுக்குப் பிறகும் நீங்கள் கீழ்ப்படியாவிட்டால் உங்கள் பாவங்களுக்காக ஏழு மடங்கு தண்டிப்பேன். ");
INSERT INTO tam2008_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","உங்கள் பெருமைக்குரிய பெரிய நகரங்களையெல்லாம் அழிப்பேன். வானம் உங்களுக்கு மழையைத் தராது. நிலம் விளைச்சலைத் தராது. ");
INSERT INTO tam2008_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","நீங்கள் கடினப்பட்டு உழைப்பீர்கள், ஆனால் விளைச்சல் கிடைக்காது. உங்கள் மரங்களும் பழங்களைத் தராது. ");
INSERT INTO tam2008_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“அல்லது இத்தனைக்குப் பிறகும் எனக்கு எதிராகவே நீங்கள் மாறி கீழ்ப்படிய மறுத்தால் உங்களை ஏழு மடங்கு கடுமையாக தண்டிப்பேன். உங்களது பாவங்கள் அதிகரிக்கும்போது தண்டனைகளும் அதிகமாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","நான் உங்களுக்கு எதிராகக் காட்டு மிருகங்களை அனுப்புவேன். உங்கள் பிள்ளைகளை உங்களிடமிருந்து அவை பிரித்துக் கொண்டு போகும். அவை உங்கள் மிருகங்களைக் கொல்லும். அவை உங்கள் ஜனங்களை அழிக்கும். ஜனங்கள் பயணம் செய்ய அஞ்சுவார்கள். சாலைகள் வெறுமையாகும்! ");
INSERT INTO tam2008_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“இவை அனைத்தும் நடந்த பிறகும் நீங்கள் பாடம் கற்றுக்கொள்ளவில்லை என்றாலோ மேலும் எனக்கு எதிராக இருந்தாலோ, ");
INSERT INTO tam2008_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","நானும் உங்களுக்கு எதிராக மாறுவேன். ஆம் கர்த்தராகிய நானே உங்கள் பாவங்களுக்காக ஏழு மடங்கு தண்டிப்பேன். ");
INSERT INTO tam2008_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","நீங்கள் எனது உடன்படிக்கையை மீறியிருப்பதினால் நான் உங்களைத் தண்டிப்பேன். உங்களுக்கெதிராக நான் படைகளைக் கொண்டு வருவேன். நீங்கள் பாதுகாப்புக்காக உங்கள் நகரங்களுக்கு ஓடுவீர்கள். ஆனால், உங்களுக்கிடையில் நோய்களைப் பரவச் செய்வேன். மேலும் உங்கள் எதிரிகள் உங்களைத் தோற்கடிப்பார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","அந்த நகரத்தில் உண்பதற்குக் குறைவான அளவிலேயே தானியங்கள் இருக்கும். ஒரே அடுப்பில் பத்துப் பெண்கள் அவர்களது எல்லா உணவையும் சமைக்க முடியும். நீங்கள் அதை உண்ட பிறகும் பசியோடிருப்பீர்கள்! ");
INSERT INTO tam2008_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“நீங்கள் அதற்கு மேலும் என்னைக் கவனிக்காவிட்டாலோ, எனக்கு எதிராகத் திரும்பினாலோ, ");
INSERT INTO tam2008_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","நான் உண்மையாகவே எனது கோபத்தைக் காட்டுவேன். ஆம், கர்த்தராகிய நான் உங்கள் பாவங்களுக்காக உங்களை ஏழு மடங்கு தண்டிப்பேன். ");
INSERT INTO tam2008_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","நீங்கள் மிகவும் பசியாவதினால் உங்கள் மகன்களையும். மகள்களையும் தின்பீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","நான் உங்களது உயர்ந்த மேடைகளை அழிப்பேன். உங்களது நறுமணப்புகைப் பலிபீடங்களை உடைப்பேன். உங்களது பிணங்களை உங்களது உயிரற்ற விக்கிரகங்களின்மேல் போடுவேன். நீங்கள் எனது வெறுப்புக்கு ஆளாவீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","நான் உங்கள் நகரங்களை அழிப்பேன். உங்கள் பரிசுத்தமான இடங்களை வெறுமையாக்குவேன். உங்கள் பலிகளின் மணத்தை நுகரமாட்டேன். ");
INSERT INTO tam2008_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","உங்கள் நிலங்களை வெறுமையாக்குவேன். அதிலே குடியிருக்கும் உங்கள் பகைவர்கள் அதிர்ச்சியடைவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","தேசங்களெங்கும் உங்களைச் சிதறடிப்பேன். நான் எனது வாளை உருவி உங்களை அழிப்பேன். உங்கள் வயல்கள் பாழாகும், உங்கள் நகரங்கள் அழிந்துபோகும். ");
INSERT INTO tam2008_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","“நீங்கள் உங்களது பகைவரின் நாட்டிற்கு கொண்டு செல்லப்படுவீர்கள். உங்கள் நாடு வெறுமையடையும். இறுதியில் உங்கள் வயல்கள் ஓய்வுபெறும். அவை ஓய்வு காலத்தின் மகிழ்ச்சியை அனுபவிக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","வயல்கள் ஏழு ஆண்டுகளுக்கு ஒரு முறை ஓய்வு பெறவேண்டும் என்று சட்டம் கூறுகின்றன. நீங்கள் அங்கு குடியிருந்தபோது ஓய்வுபெறாத அந்த நிலங்கள் பாழாய்க் கிடந்து ஓய்வுபெறும். ");
INSERT INTO tam2008_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","உங்களில் உயிரோடு இருப்பவர்களைப் பகைவரின் நாடுகளில் தைரியம் இழந்து தவிக்கச் செய்வேன். அசைகிற இலைகளின் சத்தமும் அவர்களை அச்சுறுத்தி விரட்டும். அவர்கள் எதற்கெடுத்தாலும் அஞ்சுவார்கள். யாரும் துரத்தாவிட்டாலும் யாரோ அவர்களை வாளெடுத்துக் கொண்டு துரத்துவது போன்று ஓடிக்கொண்டிருப்பார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","யாரும் துரத்தாவிட்டாலும் கூட அவர்கள் ஓடி ஒருவர் மேல் ஒருவர் விழுவார்கள். “எதிரிகளை எதிர்த்து நிற்கிற பலம் உங்களிடம் இல்லாமல் போகும். ");
INSERT INTO tam2008_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","வேறு நாடுகளில் நீங்கள் காணாமல் போவீர்கள். உங்கள் பகைவரின் நாடுகளில் மறைந்து போவீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","உங்களில் உயிரோடு இருப்பவர்கள் தங்கள் பாவங்களால் பகைவர்கள் நாட்டில் அழிவார்கள். அவர்கள் தம் முற்பிதாக்கள் செய்ததுபோலவே தங்கள் பாவங்களால் அழிவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ஜனங்கள் தங்கள் பாவங்களை ஒப்புக்கொண்டு, அவர்கள் தங்கள் முற்பிதாக்களின் பாவங்களையும் அறிக்கையிட்டு, அவர்கள் எனக்கு எதிராக நடந்துக்கொண்டு, பாவம் செய்தார்கள் என்பதை ஒப்புக்கொள்ளலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","அவர்கள் எனக்கு எதிராக நடந்துகொண்டதால் நானும் அவர்களுக்கு எதிராக நடந்துகொண்டேன். அவர்களைப் பகைவரின் நாடுகளுக்கு அனுப்பி வைத்தேன். இதனையும் அவர்கள் அறிக்கையிடலாம். அவர்கள் எனக்கு அந்நியர்களாவார்கள். அவர்கள் அடக்கமாக தங்கள் பாவங்களுக்கான தண்டனைகளை ஏற்றுக்கொள்ள வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","இவ்வாறு செய்தால் நான் யாக்கோபோடு செய்த உடன்படிக்கையையும், நான் ஈசாக்கோடு செய்த உடன்படிக்கையையும் நான் ஆபிரகாமோடு செய்த உடன்படிக்கையையும் நினைவுப்படுத்திக்கொள்வேன். நான் அந்த தேசத்தை நினைவுகூருவேன். ");
INSERT INTO tam2008_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","“நிலம் வெறுமையாக இருக்கும். அது தனது ஓய்வு காலத்தை மகிழ்ச்சியுடன் அனுபவிக்கும். பின் உயிரோடு இருக்கிறவர்கள் தங்கள் பாவங்களுக்கான தண்டனைகளை ஏற்றுக்கொள்வார்கள். அவர்கள் எனது சட்டங்களையும், விதிகளையும் வெறுத்து கீழ்ப்படிய மறுத்ததால் இந்தத் தண்டனை பெற்றதாக உணர்ந்துகொள்வார்கள். ");
INSERT INTO tam2008_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","அவர்கள் உண்மையில் பாவம் செய்தவர்கள். ஆனால் அவர்கள் என்னிடம் உதவிக்கு வந்தால் நான் அவர்களை விட்டு விலகிப் போகமாட்டேன். நான் அவர்கள் சொல்வதைக் கேட்பேன். அவர்கள் தங்கள் பகைவரின் நாட்டிலே இருந்தாலும் முழுவதுமாக அழித்துவிடமாட்டேன். நான் அவர்களோடு செய்த உடன்படிக்கையை உடைக்கமாட்டேன். ஏனென்றால் நான் அவர்களுடைய தேவனாகிய கர்த்தர். ");
INSERT INTO tam2008_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","அவர்களுக்காக, நான் அவர்களின் முற்பிதாக்களோடு செய்த உடன்படிக்கையை நினைவுபடுத்திக்கொள்வேன். நான் அவர்களின் முற்பிதாக்களை எகிப்திலிருந்து மீட்டுக்கொண்டு வந்து, அவர்களின் தேவன் ஆனேன். மற்ற நாடுகளும் இதனைக் கவனித்தன. நான் கர்த்தர்!” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","இவையே இஸ்ரவேல் ஜனங்களுக்குக் கர்த்தர் கொடுத்த சட்டங்களும், விதிகளும், போதனைகளுமாகும். கர்த்தருக்கும் இஸ்ரவேல் ஜனங்களுக்கும் ஏற்பட்ட உடன்படிக்கையின் சட்டங்களும் இவை தான். இச்சட்டங்களை கர்த்தர் சீனாய் மலையில் மோசேயிடம் கொடுத்தார். மோசே இவற்றை ஜனங்களிடம் கொடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“இஸ்ரவேல் ஜனங்களிடம் கூறு. கர்த்தரிடம் ஒருவன் சிறப்பான பொருத்தனை ஒன்றைச் செய்திருக்கலாம். அவன் கர்த்தருக்கு ஒரு நபரைக் கொடுப்பதாக வாக்குறுதி அளித்திருக்கலாம். அந்த நபர் கர்த்தருக்குச் சிறப்பான ஊழியம் செய்வான். ஆசாரியன் அவனுக்கென்று ஒரு விலையை நிர்ணயம் செய்ய வேண்டும். அந்த நபரைத் திரும்பப் பெற வேண்டுமானால் அவனுக்குரிய மீட்பின் தொகையைக் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","இருபது வயது முதல் அறுபது வயது வரையுள்ள ஒரு ஆணின் விலை ஐம்பது வெள்ளிச் சேக்கலாகும். (நீங்கள் இதற்கு அதிகாரப்பூர்வமான பரிசுத்த இடத்தின் சேக்கலின் அளவையே எடுத்துக்கொள்ள வேண்டும்.) ");
INSERT INTO tam2008_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","இருபது வயது முதல் அறுபது வயது வரையுள்ள ஒரு பெண்ணின் விலை முப்பது வெள்ளிச்சேக்கலாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","ஐந்து வயது முதல் இருபது வயதுவரை உடைய ஒரு ஆண்மகனின் விலை இருபது வெள்ளிச் சேக்கலாகும். ஐந்து வயது இருபது வயது வரை உடைய ஒரு பெண்ணின் விலை பத்து வெள்ளிச் சேக்கலாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ஒரு மாதம் முதல் ஐந்து வயது வரையுள்ள ஆண் குழந்தையின் விலை ஐந்து சேக்கலாகும். ஒரு பெண் குழந்தையின் விலை மூன்று சேக்கலாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","அறுபதும் அதற்கும் மேலும் ஆன ஒரு முதியவனின் விலை பதினைந்து சேக்கலாகும். இது போன்ற முதிய பெண்ணின் விலை பத்து சேக்கலாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“ஒருவேளை அவன் அப்பணத்தைச் செலுத்த முடியாத அளவிற்கு ஏழையாக இருந்தால் அவனை ஆசாரியனிடம் அழைத்துவர வேண்டும். அவன் செலுத்த வேண்டிய தொகையைப்பற்றி ஆசாரியனே முடிவு செய்வான். ");
INSERT INTO tam2008_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“கர்த்தருக்கான பலிகளாக சில மிருகங்களைப் பயன்படுத்தலாம். ஒருவன் இத்தகைய மிருகங்களைக் கொண்டுவந்தால் அவை பரிசுத்தமடைந்துவிடும். ");
INSERT INTO tam2008_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","அவன் அந்த மிருகத்தை கர்த்தருக்கு தருவதாக வாக்களித்திருக்கலாம். எனவே அவன் அதற்குப் பதிலாக வேறு மிருகத்தைக் கொண்டுவர முயலக்கூடாது. மோசமான மிருகத்துக்குப் பதிலாக நல்ல மிருகத்தையோ, நல்ல மிருகத்துக்குப் பதில் மோசமான மிருகத்தையோ, கொண்டுவர முயற்சி செய்யக் கூடாது. அவ்வாறு ஒருவன் செய்தால் அந்த இரண்டு மிருகங்களுமே பரிசுத்தமாகி விடுவதால், இரண்டுமே கர்த்தருக்குரியதாகிவிடும். ");
INSERT INTO tam2008_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","“சில மிருகங்களைக் கர்த்தருக்கு பலியாகத் தர இயலாது. இத்தகைய தீட்டுள்ள மிருகத்தை ஒருவன் கர்த்தருக்குக் கொண்டு வந்தால், அதனை ஆசாரியனிடம் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ஆசாரியன் அதற்குரிய விலையை முடிவு செய்வான். அம்மிருகம் நல்லதா, கெட்டதா என்பதைப்பற்றி வேறுபாடு எதுவும் இல்லை. எனவே ஆசாரியன் முடிவு செய்வதே அம்மிருகத்தின் விலையாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","ஒருவேளை அவன் அந்த மிருகத்தைத் திரும்பப் பெறவேண்டும் என்று விரும்பினால் அதற்குரிய விலையோடு ஐந்தில் ஒரு பங்கு சேர்த்துக் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ஒருவன் தனது வீட்டைக் கர்த்தருக்குப் பரிசுத்தம் என்று அர்ப்பணித்தால், அதன் விலையை ஆசாரியன் முடிவு செய்ய வேண்டும். அவ்வீடு நல்லது, கெட்டது என்பது பற்றி வேறுபாடு இல்லை. ஆசாரியன் தீர்மானிப்பதே அவ்வீட்டின் விலையாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","ஆனால் வீட்டுக்காரன் அவ்வீட்டைத் திரும்பப் பெற்றுக்கொள்ள வேண்டும் என்று விரும்பினால் வீட்டின் விலையோடு ஐந்தில் ஒரு பாகம் சேர்த்துக் கொடுக்க வேண்டும். பின்பு வீடு அவனுக்குரியதாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ஒருவன் தனது வயல்களின் ஒரு பாகத்தை கர்த்தருக்கு அர்ப்பணித்தால் அதன் விலையானது அதில் எவ்வளவு விதை விதைக்கலாம் என்பதைப் பொறுத்தே முடிவு செய்யப்படும். ஒருகலம் வாற் கோதுமை, விதைக்கிற வயல் ஐம்பது வெள்ளிச் சேக்கலாக மதிக்கப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","ஒருவேளை வயலை யூபிலி ஆண்டில் தேவனுக்குக் கொடுத்தால், அதன் விலையை ஆசாரியன் தீர்மானிப்பான். ");
INSERT INTO tam2008_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","அவன் தனது வயலை யூபிலி ஆண்டுக்குப் பிறகு கொடுத்தால் ஆசாரியன் அதன் விலையைச் சரியாகக் கணக்கிடவேண்டும். அவன் அடுத்த யூபிலிக்கான ஆண்டு எண்ணிக்கையைக் கணக்கிட்டு விலையைச் சொல்லுவான். ");
INSERT INTO tam2008_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","வயலைக் கொடுத்தவன் திரும்பப்பெற வேண்டும் என்று விரும்பினால் வயலின் விலையோடு ஐந்தில் ஒரு பங்கு மிகுதியாகக் கொடுத்து பெற்றுக்கொள்ளலாம். பிறகு அது அவனுக்கு உரிமை உடையதாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","ஒருவேளை அவன் திரும்ப விலை கொடுத்து வாங்கிக்கொள்ளாவிட்டால், அவ்வயல் தொடர்ந்து ஆசாரியர்களுக்கு உரியதாகும். ஒருவேளை அந்த வயல் வேறுயாருக்கேனும் விற்கப்பட்டால், அவன் அதனைத் திரும்பப் பெற்றுக்கொள்ள முடியாது. ");
INSERT INTO tam2008_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","எனவே வயலுக்குச் சொந்தக்காரன் திரும்பப் பெற்றுக்கொள்ளாவிட்டால், யூபிலி ஆண்டு வந்தாலும் அது கர்த்தருக்கு பரிசுத்தமானதாக விளங்கும், என்றென்றும் ஆசாரியர்களுக்கு உரிமை உடையதாக இருக்கும். அது கர்த்தருக்கே முழுமையாகக் கொடுக்கப்பட்ட நிலம்போல் இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ஒருவன் கர்த்தருக்கு அர்ப்பணித்த நிலம் அவன் விலைக்கு வாங்கியதாக இருக்கலாம். அது அவனது குடும்பச் சொத்தாக இல்லாமல் இருக்கலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","அப்போது ஆசாரியன் யூபிலி ஆண்டுகுரிய ஆண்டுகளைக் கணக்கிட்டு அதன் விலையை முடிவு செய்வான். அது கர்த்தருக்கு உரியதாக இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","பிறகு யூபிலி ஆண்டில் அந்நிலம் மீண்டும் அந்நிலத்திற்கு சொந்தமான குடும்பத்திற்கே போய்ச் சேரும். ");
INSERT INTO tam2008_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","“இதன் விலையை முடிவு செய்யும் போது அதிகாரப்பூர்வமான அளவை பயன்படுத்த வேண்டும். ஒரு சேக்கல் என்பது இருபது கேராவாகும். ");
INSERT INTO tam2008_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ஜனங்கள் கர்த்தருக்கு மாடுகளையோ, ஆடுகளையோ சிறப்புக் காணிக்கைளாகக் கொடுக்கலாம். அவை முதலில் பிறந்தவையாக இருப்பின் அது ஏற்கெனவே கர்த்தருக்கு உரியது. எனவே அவற்றை ஜனங்கள் சிறப்புக் காணிக்கையாகக் கொடுக்க முடியாது. ");
INSERT INTO tam2008_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","ஜனங்கள் முதலில் பிறந்த மிருகங்களைக் கர்த்தருக்கே கொடுக்க வேண்டும். ஆனால் அது தீட்டுள்ளதாக இருந்தால் அவன் அதனைத் திருப்பி வாங்கிக்கொள்ளவேண்டும். ஆசாரியன் அதற்குரிய விலையை முடிவு செய்வான். விலையோடு ஐந்தில் ஒரு பாகம் மிகுதியாகக் கொடுத்து அதனை வாங்கிக்கொள்ள வேண்டும். அவன் அதனைத் திருப்ப வாங்கிக்கொள்ளாவிட்டால் ஆசாரியன்தான் விரும்புகிற விலையில் மற்றவர்களுக்கு விற்றுவிட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ஜனங்கள் கர்த்தருக்குக் கொடுக்கும் அன்பளிப்புகளில் சில சிறப்பான அன்பளிப்புகள் உள்ளன. இவை கர்த்தருக்கே உரியவை. அவற்றைக் கொடுத்தவன் திருப்பி வாங்கிக்கொள்ளவும், விற்கவும் முடியாது. இவை கர்த்தருக்கே சொந்தமானவை. காணிக்கைகளில் மனிதர்கள், மிருகங்கள், குடும்பச் சொத்திலுள்ள வயல்கள் போன்றவற்றை சேர்த்துக்கொள்ளலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","சிறப்புக் காணிக்கையாக மனிதனைக் கொடுத்தால், அவனைத் திரும்ப விலைக்கு வாங்க முடியாது. அவன் கொல்லப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“விளைச்சலில் பத்தில் ஒருபாகம் கர்த்தருக்கு உரியது. வயல்களில் விளைப வைகளிலும், மரங்களின் பழங்களிலும் பத்தில் ஒரு பாகம் கர்த்தருக்கே உரியது. ");
INSERT INTO tam2008_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","எனவே எவனாவது இதனைத் திரும்பப் பெற்றுக்கொள்ள விரும்பினால் அதன் விலையோடு ஐந்தில் ஒரு பாகம் மிகுதியாகக் கொடுத்து பெற்றுக்கொள்ளலாம். ");
INSERT INTO tam2008_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","“ஒருவனது மாடு அல்லது ஆட்டு மந்தையில் பத்தில் ஒரு பங்கான மிருகங்கள் கர்த்தருக்கு உரியவை. ");
INSERT INTO tam2008_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","கர்த்தருக்குத் தேர்ந்தெடுக்கப்படும் மிருகங்கள் நல்லவையா, கெட்டவையா என்பதைப்பற்றி கவலைப்பட வேண்டாம். அதற்காக அவன் வேறு மிருகங்களை மாற்றிக்கொள்ள வேண்டாம். அவன் அவ்வாறு மாற்றிக்கொள்ள விரும்பினால் இரண்டு மிருகங்களுமே கர்த்தருக்கு உரியதாகும். இவற்றைத் திரும்ப வாங்கிக்கொள்ள முடியாது” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","இவை அனைத்தும் கர்த்தர் மோசேக்குக் கொடுத்த கட்டளைகளாகும். இதனை இஸ்ரவேல் ஜனங்களுக்காகச் சீனாய் மலையில் அவர் கொடுத்தார். ");
INSERT INTO tam2008_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","ஆசரிப்புக் கூடாரத்திலே கர்த்தர் மோசேயிடம் பேசினார். இது சீனாய் பாலைவனத்தில் நடந்தது. இஸ்ரவேல் ஜனங்கள் எகிப்தை விட்டுப் புறப்பட்ட இரண்டாவது ஆண்டின் இரண்டாம் மாதத்தின் முதல் நாளில் இது நடந்தது. கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“இஸ்ரவேல் ஜனங்கள் தொகையை கணக்கிடு. ஒவ்வொரு மனிதனையும் அவனது குடும்பத்தோடும் கோத்திரங்களோடும் பட்டியலிடு. ");
INSERT INTO tam2008_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","இஸ்ரவேல் ஜனங்களில் இருபது வயது அல்லது அதற்கு மேலுள்ள எல்லா ஆண்களையும் நீயும் ஆரோனும் எண்ணிக் கணக்கிடுங்கள். (இந்த ஆண்கள்தான் இஸ்ரவேல் படையில் பணிபுரிய வேண்டும்.) இவர்களை குழுவின்படி கணக்கிடுக. ");
INSERT INTO tam2008_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","ஒவ்வொரு கோத்திரத்திற்கும் ஒவ்வொரு மனிதன் உங்களுக்கு உதவுவான். அவனே அந்தக் கோத்திரத்துக்குத் தலைவனாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","உங்களுக்குத் துணையாக நின்று உங்களுக்கு உதவி செய்பவர்களின் பெயர்கள் பின்வருவதாகும். ரூபனின் கோத்திரத்திலிருந்து சேதேயூருடைய மகன் எலிசூர்; ");
INSERT INTO tam2008_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","சிமியோனின் கோத்திரத்திலிருந்து சூரிஷதாயின் மகன் செலூமியேல்; ");
INSERT INTO tam2008_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","யூதாவின் கோத்திரத்திலிருந்து அம்மினதாபின் மகன் நகசோன்; ");
INSERT INTO tam2008_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","இசக்காரின் கோத்திரத்திலிருந்து சூவாரின் மகன் நெதனெயேல்; ");
INSERT INTO tam2008_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","செபுலோனின் கோத்திரத்திலிருந்து ஏலோனின் மகன் எலியாப்; ");
INSERT INTO tam2008_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","யோசேப்பின் சந்ததியிலிருந்து யோசேப்பின் மகனான எப்பிராயீமின் கோத்திரத்திலிருந்து அம்மியூதின் மகன் எலிஷாமா; யோசேப்பின் மகனான மனாசேயின் கோத்திரத்திலிருந்து பெதாசூரின் மகன் கமாலியேல்; ");
INSERT INTO tam2008_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","பென்யமீனின் கோத்திரத்திலிருந்து கீதெயோனின் மகன் அபீதான்; ");
INSERT INTO tam2008_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","தாணின் கோத்திரத்திலிருந்து அம்மிஷதாயின் மகன் அகியேசேர்; ");
INSERT INTO tam2008_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","ஆசேரின் கோத்திரத்திலிருந்து ஓகிரானின் மகன் பாகியேல் ");
INSERT INTO tam2008_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","காத்தின் கோத்திரத்திலிருந்து தேகுவேலின் மகன் எலியாசாப்; ");
INSERT INTO tam2008_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","நப்தலியின் கோத்திரத்திலிருந்து ஏனானின் மகன் அகீரா” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","இவர்கள் அனைவரும் தங்களுடைய கோத்திரங்களுக்கு தலைவர்களாக தேர்ந்தெடுக்கப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","மோசேயும் ஆரோனும் இவர்களைத் தலைவர்களாக ஏற்றுக்கொண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","மோசேயும் ஆரோனும் இஸ்ரவேல் ஜனங்களைச் சேர்த்துக் கூட்டினர். பிறகு, அவர்கள் தங்கள் குடும்பம், மற்றும் கோத்திரங்களின்படி பட்டியலிடப்பட்டனர். இருபது வயதும் அதற்கு மேலும் உள்ள எல்லா ஆண்களும் பட்டியலிடப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","கர்த்தருடைய கட்டளையின்படியே மோசே சரியாக செய்து முடித்தான். ஜனங்கள் சீனாய் பாலைவனத்தில் இருக்கும்போதே, மோசே அவர்களை எண்ணிக் கணக்கிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","அவர்கள் ரூபனின் கோத்திரத்தைக் கணக்கிட்டார்கள். (இஸ்ரவேலின் மூத்த மகன் ரூபன்.) இருபது வயதும் அதற்கு மேலும் உள்ள படையில் பணியாற்றும் தகுதியுடைய எல்லா ஆண்களும் எண்ணிக் கணக்கிடப்பட்டனர். அவர்கள் தம் கும்பத்தாரோடும், கோத்திரங்களோடும் எண்ணி பட்டியலிடப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","ரூபனின் கோத்திரத்தில் கணக்கிடப்பட்ட ஆண்களின் மொத்த எண்ணிக்கை 46,500. ");
INSERT INTO tam2008_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","சிமியோனின் கோத்திரத்தில் உள்ளவர்களை எண்ணினர். இருபது வயதும் அதற்கு மேலும் உள்ள படையில் பணியாற்றும் தகுதியுடைய எல்லா ஆண்களும் பட்டியலிடப்பட்டனர். அவர்கள் தங்கள் குடும்பத்தாரோடும், கோத்திரங்களோடும் எண்ணிப் பட்டியலிடப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","சிமியோனின் கோத்திரத்தில் கணக்கிடப்பட்ட ஆண்களில் மொத்த எண்ணிக்கை 59,300. ");
INSERT INTO tam2008_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","காத்தின் கோத்திரத்தில் உள்ளவர்களை எண்ணினார்கள். இருபது வயதும், அதற்கு மேலும் உள்ள படையில் பணியாற்றும் தகுதியுடைய எல்லா ஆண்களும் எண்ணிப் பட்டியலிடப்பட்டனர். அவர்கள் தங்கள் குடும்பத்தாரோடும், கோத்திரங்களோடும் எண்ணிப் பட்டியலிடப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","காத்தின் கோத்திரத்தில் கணக்கிடப்பட்ட ஆண்களின் மொத்த எண்ணிக்கை 45,650. ");
INSERT INTO tam2008_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","யூதாவின் கோத்திரத்தில் இருபது வயதும், அதற்கு மேலும் உள்ள படையில் பணியாற்றும் தகுதியுடைய எல்லா ஆண்களையும் பட்டியலிட்டனர். அவர்கள் குடும்பத்தாரோடும், கோத்திரங்களோடும் எண்ணிப் பட்டியலிடப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","யூதாவின் கோத்திரத்தில் கணக்கிடப்பட்ட ஆண்களின் மொத்த எண்ணிக்கை 74,600. ");
INSERT INTO tam2008_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","இசக்காரின் கோத்திரத்தில் உள்ளவர்களை எண்ணினார்கள். இருபது வயதும் அதற்கு மேலும் உள்ள படையில் பணியாற்றும் தகுதியுடைய எல்லா ஆண்களையும் பட்டியலிட்டனர். அவர்கள் குடும்பத்தாரோடும், கோத்திரங்களோடும் எண்ணிப் பட்டியலிடப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","இசக்காரின் கோத்திரத்தில் கணக்கிடப்பட்ட ஆண்களின் மொத்த எண்ணிக்கை 54,400. ");
INSERT INTO tam2008_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","செபுலோனின் கோத்திரத்தில் உள்ளவர்களை எண்ணினார்கள். இருபது வயதும் அதற்கு மேலும் உள்ள படையில் பணியாற்றும் தகுதியுடைய எல்லா ஆண்களையும் பட்டியலிட்டனர். அவர்கள் குடும்பத்தாரோடும், கோத்திரங்களோடும் எண்ணிப் பட்டியலிடப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","செபுலோனின் கோத்திரத்தில் கணக்கிடப்பட்ட ஆண்களின் மொத்த எண்ணிக்கை 57,400. ");
INSERT INTO tam2008_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","எப்பிராயீமின் கோத்திரத்தில் உள்ளவர்களை எண்ணினார்கள். (இவன் யோசேப்பின் மகன்) இருபது வயதும், அதற்கு மேலும் உள்ள படையில் பணியாற்றும் தகுதியுடைய எல்லா ஆண்களையும் பட்டியலிட்டனர். அவர்கள் குடும்பத்தாரோடும், கோத்திரங்களோடும் எண்ணிப் பட்டியலிடப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","எப்பிராயீமின் கோத்திரத்தில் கணக்கிடப்பட்ட ஆண்களின் மொத்த எண்ணிக்கை 40,500. ");
INSERT INTO tam2008_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","மனாசேயின் கோத்திரத்தில் உள்ளவர்களை அவர்கள் எண்ணினார்கள். (மனாசேயும் யோசேப்பின் மகன்.) இருபது வயதும், அதற்கு மேலும் உள்ள படையில் பணியாற்றும் தகுதியுடைய எல்லா ஆண்களையும் பட்டியலிட்டனர். அவர்கள் குடும்பத்தினரோடும், கோத்திரங்களோடும் எண்ணிப் பட்டியலிடப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","மனாசேயின் கோத்திரத்தில் கணக்கிடப்பட்ட ஆண்களின் மொத்த எண்ணிக்கை 32,200. ");
INSERT INTO tam2008_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","அவர்கள் பென்யமீனின் கோத்திரத்தில் உள்ளவர்களை எண்ணினார்கள். இருபது வயதும் அதற்கு மேலும் உள்ள படையில் பணியாற்றும் தகுதியுடைய எல்லா ஆண்களையும் பட்டியலிட்டனர். அவர்கள் குடும்பத்தினரோடும், கோத்திரங்களோடும் எண்ணிப் பட்டியலிடப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","பென்யமீனின் கோத்திரத்தில் கணக்கிடப்பட்ட ஆண்களின் மொத்த எண்ணிக்கை 35,400. ");
INSERT INTO tam2008_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","அவர்கள் தாணின் கோத்திரத்தில் உள்ளவர்களை எண்ணினார்கள். இருபது வயதும், அதற்கு மேலும் உள்ள படையில் பணியாற்றும் தகுதியுடைய எல்லா ஆண்களையும் பட்டியலிட்டனர். அவர்கள் குடும்பத்தினரோடும், கோத்திரங்களோடும் எண்ணிப் பட்டியலிடப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","தாணின் கோத்திரத்தில் கணக்கிடப்பட்ட ஆண்களின் மொத்த எண்ணிக்கை 62,700. ");
INSERT INTO tam2008_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","ஆசேரின் கோத்திரத்தில் உள்ளவர்களை அவர்கள் எண்ணினார்கள். இருபது வயதும், அதற்கு மேலும் உள்ள படையில் பணியாற்றும் தகுதியுடைய எல்லா ஆண்களையும் பட்டியலிட்டனர். அவர்கள் குடும்பத்தினரோடும், கோத்திரங்களோடும் எண்ணிப் பட்டியலிடப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","ஆசேரின் கோத்திரத்தில் கணக்கிடப்பட்ட ஆண்களின் மொத்த எண்ணிக்கை 41,500. ");
INSERT INTO tam2008_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","அவர்கள் நப்தலியின் கோத்திரத்தில் உள்ளவர்களை எண்ணினார்கள். இருபது வயதும், அதற்கு மேலும் உள்ள படையில் பணியாற்றும் தகுதியுடைய எல்லா ஆண்களையும் பட்டியலிட்டனர். அவர்கள் குடும்பத்தினரோடும், கோத்திரங்களோடும் எண்ணிப் பட்டியலிடப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","நப்தலியின் கோத்திரத்தில் கணக்கிடப்பட்ட ஆண்களின் மொத்த எண்ணிக்கை 53,400. ");
INSERT INTO tam2008_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","மோசேயும், ஆரோனும், பன்னிரண்டு இஸ்ரவேல் தலைவர்களும், இந்த ஜனங்களை எண்ணினார்கள். (ஒவ்வொரு கோத்திரத்துக்கும் ஒவ்வொரு தலைவர் இருந்தனர்.) ");
INSERT INTO tam2008_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","அவர்கள் இருபது வயதும் அதற்கு மேலும் உள்ள படையில் பணியாற்றும் தகுதி கொண்டவர்களை எண்ணினார்கள். ஒவ்வொருவனும், தனது குடும்பத்தோடு பட்டியலிடப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","அவர்கள் கணக்கிட்ட ஆண்களின் மொத்த எண்ணிக்கை 603,550. ");
INSERT INTO tam2008_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","லேவி கோத்திரத்தைச் சேர்ந்தவர்கள் இஸ்ரவேலர்களோடு சேர்த்து எண்ணப்படவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“லேவியின் கோத்திரத்தில் உள்ள ஆண்களை எண்ணவேண்டாம். அவர்களை இஸ்ரவேல் ஜனங்களோடு சேர்க்க வேண்டாம். ");
INSERT INTO tam2008_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","லேவியர்களிடம், அவர்கள் உடன்படிக்கையின் பரிசுத்தக் கூடாரத்திற்கு பொறுப்பானவர்கள் என்று சொல். அவர்கள் அக்கூடாரத்தையும், அதற்குரிய வேலைகளையும் கவனித்துக்கொள்ள வேண்டும். அவர்கள் பரிசுத்தக் கூடாரத்தையும், அதிலுள்ள பொருட்களையும் சுமக்கவேண்டும். அவர்கள் தங்கள் முகாமை அக்கூடாரத்தைச் சுற்றிலும் அமைத்து தங்கியிருந்து, அவற்றைக் கவனித்துக்கொள்ள வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","பரிசுத்தக் கூடாரமானது இடம் பெயரும்போதும், அதற்கான வேலைகளை லேவியர்களே செய்யவேண்டும். பரிசுத்தக் கூடாரமானது நிறுவப்படும்போதெல்லாம் அதற்குரிய வேலைகளையும் லேவியர்களே செய்ய வேண்டும். அவர்களே பரிசுத்தக் கூடாரத்தின் சகல பொறுப்புகளுக்கும் உரியவர்கள். லேவியின் கோத்திரத்தைச் சேராத ஒருவன், பரிசுத்தக் கூடாரத்தின் வேலைகளைச் செய்ய முயன்றால் அவன் கொல்லப்படவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","இஸ்ரவேல் ஜனங்கள், தனித்தனிக் குழுக்களாக தங்கள் முகாமை அமைத்துக்கொள்ள வேண்டும். தங்கள் குடும்பக் கொடியின் அருகிலேயே ஒவ்வொருவனும் தங்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","ஆனால், லேவியர்கள் தங்கள் முகாமை பரிசுத்தக் கூடாரத்தைச் சுற்றியே அமைத்துக்கொள்ள வேண்டும். அவர்கள் உடன்படிக்கையின் பரிசுத்தக் கூடாரத்தைப் பாதுகாக்கவேண்டும். அதனால் இஸ்ரவேல் ஜனங்களுக்கு எவ்விதத் தீமையும் ஏற்படாமல் இருக்கும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","இஸ்ரவேல் ஜனங்கள் அனைவரும், மோசேக்குக் கர்த்தர் கட்டளையிட்டபடியே கீழ்ப்படிந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","கர்த்தர் மோசேயிடமும், ஆரோனிடமும், ");
INSERT INTO tam2008_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“இஸ்ரவேல் ஜனங்கள் ஆசரிப்புக் கூடாரத்தைச் சுற்றியே, தங்கள் முகாமை அமைத்துக்கொள்ள வேண்டும். ஒவ்வொரு குழுவும், தங்களுக்கென்று தனியான கொடியை வைத்துக்கொள்ள வேண்டும். தங்கள் குழுக்கொடியின் அருகிலேயே, ஒவ்வொருவனும் தங்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","“யூதா முகாமின் கொடியானது சூரியன் உதிக்கின்ற, கிழக்குத் திசையில் இருக்க வேண்டும். யூதாவின் கோத்திரம், அக்கொடியின் அருகிலேயே தங்கள் முகாம்களை அமைத்துக்கொள்ள வேண்டும். அம்மினதாபின் மகனான நகசோன், யூதாவின் கோத்திரத்துக்குத் தலைவனாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","அவர்கள் குழுவில் 74,600 ஆண்கள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","“இசக்காரின் கோத்திரம், யூதாவின் கோத்திரத்திற்கு அருகில் தங்கியிருக்க வேண்டும். சூவாரின் மகனான நெதனேயேல், இசக்கார் ஜனங்களின் தலைவனாய் இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","அவனுடைய குழுவில் 54,400 ஆண்கள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","“செபுலோனின் கோத்திரமானது, யூதாவின் கோத்திரத்துக்கு அருகில் தங்கியிருக்க வேண்டும். ஏலோனின் மகனான எலியாப், செபுலோன் ஜனங்களின் தலைவனாவான். ");
INSERT INTO tam2008_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","அவர்கள் குழுவில் 57,400 ஆண்கள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","“யூதாவின் முகாமில் மொத்தம் 1,86,400 ஆண்கள் இருந்தனர். இவர்கள் அனைவரும், தங்கள் கோத்திரங்களின்படி பிரிக்கப்பட்டார்கள். ஜனங்கள் ஓரிடத்திலிருந்து இன்னொரு இடத்திற்குப் போகும்போது, யூதாவின் கோத்திரமே முதலில் செல்லும். ");
INSERT INTO tam2008_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“ரூபனுடைய முகாமின் கொடியைக் கொண்ட படைகள், பரிசுத்தக் கூடாரத்தின் தென்பகுதியில் இருக்கும். ஒவ்வொரு குழுவும் இக்கொடியின் அருகில் இருக்கும். சேதேயூரின் மகனான எலிசூர், ரூபன் ஜனங்களின் தலைவனாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","இக்குழுவில் 46,500 ஆண்கள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","“சிமியோனின் கோத்திரம், ரூபனின் கோத்திரத்தின் அருகில் இருக்கும். சூரிஷதாவின் மகனான செலூமியேல், சிமியோன் ஜனங்களின் தலைவனாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","இக்குழுவில் 59,300 ஆண்கள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","“காத்தின் கோத்திரமும், ரூபனின் கோத்திரத்தின் அருகில் இருக்கும். தேகுவேலின் மகனாகிய எலியாசாப், காத் ஜனங்களின் தலைவனாயிருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","இக்குழுவில் 45,650 ஆண்கள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","“ரூபனின் முகாமில் எல்லா கோத்திரங்களிலிருந்தும் மொத்தம் 1,51,450 ஆண்கள் இருந்தனர். ஜனங்கள் ஓரிடத்திலிருந்து, இன்னொரு இடத்திற்குப் போகும்போது இக்குழு இரண்டாவதாகச் செல்லும். ");
INSERT INTO tam2008_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“ஜனங்கள் பயணம் செய்யும்போது, அடுத்ததாக லேவியரின் குழு செல்ல வேண்டும். ஆசாரிப்புக் கூடாரமானது அவர்களுடைய எல்லா முகாம்களுக்கும் நடுவே இருக்க வேண்டும். அவர்கள் செல்லுகிற வரிசைப்படியே தங்கள் முகாம்களையும் அமைத்துக்கொள்ள வேண்டும். ஒவ்வொருவரும் தங்கள் குடும்பக் கொடிகளோடுதான் பயணம் செய்யவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“எப்பிராயீமுடைய முகாமின் கொடியையுடைய படைகள் மேற்கு பக்கத்தில் தங்கள் முகாமை அமைத்துக்கொள்ள வேண்டும். அம்மியூதின் மகனான எலிஷாமா எப்பிராயீமின் ஜனங்களுக்குத் தலைவனாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","இக்குழுவில் மொத்தம் 40,500 ஆண்கள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","“மனாசேயின் கோத்திரமானது எப்பிராயீமுடைய குடும்பத்துக்கு அருகில் தங்க வேண்டும். பெதாசூரின் மகனான கமாலியேல், மனாசே ஜனங்களுக்குத் தலைவனாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","இக்குழுவில் மொத்தம் 32,200 ஆண்கள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","“பென்யமீனின் கோத்திரமும் எப்பிராயீமுடைய குடும்பத்துக்கு அருகில் தங்க வேண்டும். கீதெயோனின் குமாரனாகிய அபீதான் பென்யமீன் ஜனங்களுக்குத் தலைவனாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","அக்குழுவில் உள்ள ஆண்களின் எண்ணிக்கை 35,400 ஆகும். ");
INSERT INTO tam2008_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","“எப்பிராயீமின் குழு தங்கி இருக்கும் இடத்தில், மொத்தத்தில் 1,08,100 ஆண்கள் இருந்தார்கள். ஜனங்கள் ஓரிடத்திலிருந்து இன்னொரு இடத்திற்குப் போகும்போது, மூன்றாவதாக இவர்கள் செல்ல வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“தாண் குழுவின் கொடியானது வடக்குப் புறத்தில் இருக்க வேண்டும். தாணின் கோத்திரங்கள், அங்கே தங்கள் முகாம்களை அமைத்திருப்பார்கள். அம்மிஷதாயின் மகனான அகியேசேர், தாண் ஜனங்களின் தலைவனாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","இந்தக் குழுவில் 62,700 ஆண்கள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","“ஆசேரின் கோத்திரத்தினர் தாணின் கோத்திரத்தினரை அடுத்து இருப்பார்கள். ஓகிரானின் மகனான பாகியேல், ஆசேர் ஜனங்களின் தலைவனாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","இக்குழுவில், 41,500 ஆண்கள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","“நப்தலியின் கோத்திரத்தினரும் தாணின் கோத்திரத்தினருக்கு அடுத்துக் கூடாரமிட்டு இருப்பார்கள். ஏனானின் மகனாகிய அகீரா, நப்தலி ஜனங்களின் தலைவனாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","இக்குழுவில் 53,400 ஆண்கள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","“தாணின் குழு தங்கி இருக்கும் இடத்தில் மொத்தத்தில் 1,57,600 ஆண்கள் இருந்தார்கள். மக்கள் ஓரிடத்திலிருந்து இன்னொரு இடத்திற்குச் செல்லும்போது, கடைசியில் செல்ல வேண்டியவர்கள் இவர்களே, ஒவ்வொருவரும் தங்கள் குடும்பக் கொடிகளோடு இருக்க வேண்டும்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","இவர்கள்தான் இஸ்ரவேல் ஜனங்கள். அவர்கள் குடும்பவாரியாகக் கணக்கிடப்பட்டனர். எல்லா முகாம்களிலும் இருந்த மொத்த இஸ்ரவேல் ஆண்களின் எண்ணிக்கை 6,03,550 ஆகும். ");
INSERT INTO tam2008_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","மோசே கர்த்தருக்குக் கீழ்ப்படிந்து, லேவியர்களை மற்ற இஸ்ரவேல் ஜனங்களோடு சேர்த்து எண்ணவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","கர்த்தர் மோசேயிடம் சொன்னபடி, இஸ்ரவேல் ஜனங்கள் எல்லாவற்றையும் செய்து முடித்தனர். ஒவ்வொரு குழுவும் தமது சொந்தக் கொடியின் கீழ் தங்கி இருந்தது. அனைவரும் தங்கள் குடும்பம், மற்றும் கோத்திரத்தின்படியே பிரயாணப்பட்டு போனார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","சீனாய் மலையில் கர்த்தர் மோசேயோடு பேசிக்கொண்டிருந்தபோது, ஆசாரியனாகிய ஆரோன், மற்றும் மோசேயின் வம்ச வரலாறு கீழ்க்கண்டவாறு இருந்தது: ");
INSERT INTO tam2008_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","ஆரோனுக்கு நான்கு மகன்கள் இருந்தனர். நாதாப் முதல் மகன். அபியூ, எலெயாசார், இத்தாமார் என்பவர்கள் இளையவர்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","இவர்கள் ஆசாரியர்களாகத் தேர்ந்தெடுக்கப்பட்டு, கர்த்தருக்கு ஊழியம் செய்யும் பொறுப்பைப் பெற்றிருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","ஆனால் நாதாபும் அபியூவும் தங்கள் பாவத்தின் காரணமாக, கர்த்தருக்கு ஊழியம் செய்யும்போதே, மரித்துப்போனார்கள். கர்த்தருக்குக் காணிக்கைப் பலி செலுத்தும்போது கர்த்தரால் அங்கீகரிக்கப்படாத நெருப்பை அவர்கள் பயன்படுத்தினர். எனவே, நாதாப்பும், அபியூவும் சீனாய் பாலைவனத்திலேயே மடிந்தார்கள். அவர்களுக்கு மகன்கள் இல்லை. எனவே, அவர்களின் இடத்தில் எலெயாசாரும், இத்தாமாரும் ஆசாரியர்களாகக் கர்த்தருக்கு ஊழியம் செய்தனர். அவர்களின் தந்தையான ஆரோன் உயிரோடு இருக்கும்போதே இது நிகழ்ந்தது. ");
INSERT INTO tam2008_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“லேவியர்களின் கோத்திரத்திலிருந்து அனைவரையும், ஆசாரியனாகிய ஆரோனிடம் அழைத்துக் கொண்டு வா. அவர்கள் ஆரோனின் உதவியாட்களாக இருப்பார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","ஆசரிப்புக் கூடாரத்தில் ஆரோன் ஊழியம் செய்யும்போது, அவனுக்கு லேவியர்கள் உதவுவார்கள். இஸ்ரவேல் ஜனங்கள் பரிசுத்தக் கூடாரத்திற்கு தொழுதுகொள்ள வரும்போதும், லேவியர்கள் அவர்களுக்கு உதவி செய்வார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","ஆசரிப்புக் கூடாரத்திலுள்ள அனைத்துப் பொருட்களையும் பாதுகாப்பது இஸ்ரவேல் ஜனங்களின் கடமையாகும். ஆனால் லேவியர்கள் இவற்றைச் சுமந்து இஸ்ரவேல் ஜனங்களுக்குச் சேவை செய்யவேண்டும். பரிசுத்தக் கூடாரத்தில் தொழுதுகொள்ள வேண்டிய முறை இதுவேயாகும். ");
INSERT INTO tam2008_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","“ஆரோனிடமும் அவனது மகன்களிடமும் லேவியர்களை ஒப்படையுங்கள். அவர்கள் ஆரோனுக்கும் அவனது மகன்களுக்கும் உதவி செய்வதற்காகவே தேர்ந்தெடுக்கப்பட்டுள்ளனர். ");
INSERT INTO tam2008_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","“ஆரோனையும் அவனது மகன்களையும், ஆசாரியர்களாக ஊழியம் செய்ய நியமனம் செய். அவர்கள் தங்கள் கடமையை நிறைவேற்றி ஆசாரிய ஊழியம் செய்ய வேண்டும். இப்பரிசுத்தமான பொருட்களின் அருகில் வேறு எவராவது வர முயன்றால் அவர்கள் கொல்லப்பட வேண்டும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","மேலும் கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“இஸ்ரவேல் ஜனங்களின் குடும்பம் ஒவ்வொன்றிலும் முதலில் பிறக்கும் மகனை எனக்குக் கொடுக்க வேண்டும் என்று ஏற்கெனவே சொல்லியிருந்தேன். ஆனால் இப்போது எனக்கு ஊழியம் செய்வதற்காக லேவியர்களைத் தேர்ந்தெடுத்திருக்கிறேன். அவர்கள் எனக்குரியவர்களாக இருப்பார்கள்; எனவே இனி இஸ்ரவேல் ஜனங்கள் தங்கள் முதல் பிள்ளையை எனக்குக் கொடுக்க வேண்டாம். ");
INSERT INTO tam2008_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","நீங்கள் எகிப்தில் இருந்தபோது நான் எகிப்திலுள்ள முதலில் பிறந்த அனைத்தையும் கொன்றேன். அந்த நேரத்தில் இஸ்ரவேல் ஜனங்களின் ஒவ்வொரு முதல் குழந்தையையும் எனக்குரியதாக நான் எடுத்துக்கொண்டேன். முதலில் பிறந்த அனைத்து குழந்தைகளும், அனைத்து மிருகங்களும் எனக்குரியது. ஆனால் இப்போது உங்களுக்கு முதலில் பிறக்கும் குழந்தைகளை உங்களுக்கே கொடுத்துவிடுகிறேன். லேவியர்களை எனக்குச் சொந்தமாக்கிக்கொண்டேன். நானே கர்த்தர்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","கர்த்தர் மீண்டும் சீனாய் பாலைவனத்தில் மோசேயோடு பேசி, ");
INSERT INTO tam2008_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“லேவியின் எல்லாக் குடும்பங்களையும், கோத்திரங்களையும் ஒருமாத வயதும் அதற்கு மேலும் உள்ள ஆண்கள் மற்றும் ஆண் குழந்தைகளைக் கணக்கிடு” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","மோசே கர்த்தருக்குக் கீழ்ப்படிந்து அவர்களை கணக்கிட்டான். ");
INSERT INTO tam2008_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","லேவிக்கு கெர்சோன், கோகாத், மெராரி என்று மூன்று மகன்கள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","ஒவ்வொருவரும் பல கோத்திரங்களுக்குத் தலைவர்கள். கெர்சோன் கோத்திரத்தில் லிப்னீயும், சீமேயியும் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","கோகாத் கோத்திரத்தில் அம்ராம், இத்சேயார், எப்ரோன், ஊசியேல் ஆகியோர் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","மெராரி கோத்திரத்தில் மகேலியும், மூசியும் இருந்தனர். இந்த அனைத்துக் குடும்பங்களும் லேவியின் கோத்திரத்தில் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","லிப்னீ, சீமேயி ஆகியோரின் குடும்பங்கள், கெர்சோனின் கோத்திரத்தைச் சேர்ந்தவர்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","அவர்கள் இரு கோத்திரங்களிலும் ஆண்களும், ஒரு மாத வயதுக்கு மேற்பட்ட ஆண் பிள்ளைகளுமாக 7,500 பேர் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","மேற்குப்பக்கத்தில் முகாமை அமைத்துக்கொள்ளுமாறு கெர்சோனியர் கோத்திரங்களுக்குச் சொல்லப்பட்டது. அவர்கள் பரிசுத்தக் கூடாரத்தின் பின் பகுதியில் தங்கள் முகாமை அமைத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","லாயேலின் மகனாகிய எலியாசாப் என்பவன் கெர்சோனிய கோத்திரத்தினருக்கு தலைவன் ஆனான். ");
INSERT INTO tam2008_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","ஆசரிப்புக் கூடாரத்தின் காவலோடு பரிசுத்தக் கூடாரத்தையும், வெளிக் கூடாரத்தையும் அதன் மூடியையும் கவனித்துக்கொள்ளும் பொறுப்பு கெர்சோனியருக்கு இருந்தது. ஆசரிப்புக் கூடாரத்தின் வாசலில் உள்ள தொங்கு திரையையும் இவர்களே கவனித்துக்கொண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","மேலும் பிரகாரத்தின் தொங்கு திரைகளையும், பிரகாரத்தின் மூடு திரைகளையும் அவர்கள் கவனித்துக்கொண்டனர். பிரகாரமானது பரிசுத்தக் கூடாரத்தையும், பலிபீடத்தையும் சுற்றியிருந்தது. திரைகளுக்குத் தேவையான கயிறு மற்றும் மற்ற பொருட்களுக்கும் அவர்கள் பொறுப்புள்ளவர்களாக இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","அம்ராம், இத்சேயர் எப்ரோன், ஊசியேல் ஆகிய குடும்பங்கள் கோகாத்தின் கோத்திரத்தில் இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","இக்கோத்திரத்தில் ஆண்களும், ஒரு மாதத்திற்கு மேலான ஆண் குழந்தைகளுமாக 8,300 பேர் இருந்தனர். கோகாத்தியர்கள் பரிசுத்தமான இடத்திலுள்ள பொருட்களைப் பாதுகாக்கும் பொறுப்பு வகித்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","பரிசுத்தக் கூடாரத்தின் தெற்கு பக்கத்தில் கோகாத்தின் கோத்திரங்கள் தங்கள் முகாமை அமைத்திருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","ஊசியேலின் மகனான எல்சாபான் கோகாத்தியரின் கோத்திரங்களுக்குத் தலைவன் ஆனான். ");
INSERT INTO tam2008_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","அவர்கள் பரிசுத்தப் பெட்டி, மேஜை, குத்து விளக்கு, பீடங்கள், பரிசுத்த இடத்தின் பொருட்கள், தொங்கு திரை, அங்குள்ள அனைத்து வேலைகளுக்கும் உரிய பொருட்களையும் காத்து வந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","ஆரோனின் மகனாகிய ஆசாரியன் எலெயாசார் லேவியர்களின் தலைவர்களுக்கெல்லாம் தலைவனாக இருந்தான். இவன் பரிசுத்தப் பொருட்களை காவல் காப்பவர்களுக்கெல்லாம் பொறுப்பாளியாய் இருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","34","மகேலி, மூசி ஆகியோரின் கோத்திரங்கள் மெராரியின் குடும்பத்தோடு சேர்ந்தது. மகேலியின் கோத்திரத்தில் ஆண்களும், ஒரு மாதத்திற்கு மேற்பட்ட வயதுடைய ஆண் குழந்தைகளும் 6,200 பேர் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","அபியாயேலின் மகனாகிய சூரியேல், மெராரி கோத்திரத்தின் தலைவனாய் இருந்தான். பரிசுத்தக் கூடாரத்தின் வடக்கு பக்கத்தில் இவர்களுக்கு இடம் கொடுக்கப்பட்டிருந்தது. இந்த இடத்தில் அவர்கள் தங்கள் முகாமை அமைத்திருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","மெராரி குடும்பத்தில் உள்ளவர்களுக்கு பரிசுத்தக் கூடாரத்தின் சட்டங்கள், பலகைகள், தாழ்ப்பாள், தூண்கள், பாதங்கள் மற்றும் அதற்குரிய பொருள்கள் அனைத்தையும் கவனித்துக்கொள்ளும் பொறுப்பு ஒப்படைக்கப்பட்டிருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","பரிசுத்தக் கூடாரத்தின் சுற்றுப் பிரகாரத்தில் உள்ள தூண்கள், பாதங்கள், முளைகள், கயிறுகள் அனைத்தையும் அவர்கள் கவனித்துக்கொண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","மோசே, ஆரோன், அவனது மகன்கள் எல்லோரும் ஆசாரிப்புக் கூடாரத்திற்கு எதிரில் பரிசுத்தக் கூடாரத்தின் கிழக்கில் முகாமிட்டனர். பரிசுத்த இடத்தை கவனிக்கும் பொறுப்பு அவர்களுக்கு கொடுக்கப்பட்டிருந்தது. இஸ்ரவேலின் அனைத்து ஜனங்களுக்காகவும் அவர்கள் இதனைச் செய்தனர். வேறு யாராவது பரிசுத்த இடத்தின் அருகில் வந்தால், அவர்கள் கொல்லப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","லேவியின் கோத்திரத்தில் உள்ள ஆண்களையும், ஒரு மாதத்திற்கு மேற்பட்ட ஆண்பிள்ளைகளையும் கணக்கிடுமாறு கர்த்தர் மோசேயிடம் கட்டளையிட்டார். அவர்களின் மொத்த எண்ணிக்கை 22,000. ");
INSERT INTO tam2008_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","கர்த்தர் மோசேயிடம், “இஸ்ரவேலில் முதலில் பிறந்த எல்லா ஆண்களையும், குறைந்தது ஒரு மாதமாவது ஆன ஆண் குழந்தைகளையும் கணக்கிடு. அவர்களின் பெயரையும் எழுதி பட்டியலிடு. ");
INSERT INTO tam2008_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","கடந்த காலத்தில் நான், இஸ்ரவேலில் முதலில் பிறக்கும் ஆண் மக்களையெல்லாம் எனக்குரியவர்கள் என்று கூறியிருந்தேன். கர்த்தராகிய நான் இப்போது லேவியர்களை மட்டும் எடுத்துக்கொள்வேன். இஸ்ரவேலில் முதலில் பிறக்கும் அனைத்து மிருகங்களையும் எடுத்துக்கொள்வதற்குப் பதிலாக, லேவியர்களுக்குரிய முதலில் பிறந்த மிருகங்களை மட்டும் எடுத்துக்கொள்வேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","எனவே மோசே, கர்த்தருடைய கட்டளைப்படி செய்தான். அவன் இஸ்ரவேல் ஜனங்களில் முதலில் பிறந்த குழந்தைகளைக் கணக்கெடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","முதலாவதாக பிறந்த ஆண்களையும், ஒரு மாதமும் அதற்கு மேலுமுள்ள ஆண் குழந்தைகளையும், மோசே பட்டியலிட்டான். அதில் மொத்தம் 22,273 பெயர்கள் இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","மேலும் கர்த்தர் மோசேயிடம், “கர்த்தராகிய நான் இந்தக் கட்டளையைக் கொடுக்கிறேன்: ‘இஸ்ரவேலில் உள்ள அனைத்துக் குடும்பங்களிலுமுள்ள முதலில் பிறந்த ஆண் குழந்தைகளுக்கு பதிலாக லேவியர்வம்சத்திலுள்ள முதலில் பிறக்கும் ஆண்களை மட்டும் எடுத்துக்கொள்வேன். ");
INSERT INTO tam2008_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","மற்ற இஸ்ரவேலில் முதலில் பிறந்த மிருகங்களுக்குப் பதிலாக லேவியர்களிடமுள்ள முதலில் பிறக்கும் மிருகங்களை மட்டும் எடுத்துக்கொள்வேன். லேவியர்கள் எனக்கு உரியவர்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","மொத்தம் 22,000 லேவியர்கள் இருந்தனர். ஆனால் மற்ற குடும்பங்களில் 22,273 முதலில் பிறந்த ஆண் பிள்ளைகள் இருந்தனர். லேவியர்களை விட, முதலில் பிறந்த ஆண் பிள்ளைகள் 273 பேர் மற்ற குடும்பங்களில் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","அதிகாரப் பூர்வமான அளவை அடிப்படையாய் வைத்துக்கொண்டு, தலைக்கு ஐந்து சேக்கல் வீதமாக 273 பேர்களிடமிருந்தும் வாங்கு. (ஒரு சேக்கல் என்பது இருபது கேரா இருக்கும்.) ");
INSERT INTO tam2008_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","இஸ்ரவேல் ஜனங்களிடம் இருந்து வெள்ளியையும் வசூல் செய். இவற்றை ஆரோனுக்கும், அவனது மகன்களுக்கும் கொடுப்பாயாக. இது 273 இஸ்ரவேல் ஜனங்களுக்கான சம்பளத் தொகையாகும்’” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","மற்ற கோத்திரங்களில் இருந்து வந்த 273 பேர்களின் இடத்தை ஈடுசெய்ய போதுமான அளவில் லேவியர்கள் இல்லாமல் இருந்தனர். எனவே மோசே அந்த 273 பேர்களுக்காக பணம் வசூல் செய்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","மோசே இஸ்ரவேல் ஜனங்களில் முதலில் பிறந்த ஆண் பிள்ளைகளிடமிருந்து வெள்ளியை வசூல் செய்தான். அதிகாரப் பூர்வமான அளவை வைத்துக்கொண்டு, அவன் 1,365 சேக்கல் வெள்ளியை வசூலித்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","மோசே கர்த்தருக்குக் கீழ்ப்படிந்தான். வெள்ளியை ஆரோனுக்கும் அவனது மகன்களுக்கும் கர்த்தர் கட்டளையிட்டபடியே கொடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","கர்த்தர் மோசேயிடமும் ஆரோனிடமும், ");
INSERT INTO tam2008_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“கோகாத்தின் கோத்திரத்தில் உள்ள குடும்பங்களின் மொத்த ஆண்களின் தொகையை எண்ணிக் கணக்கிடு. (கோகாத்தின் கோத்திரமானது லேவியர் கோத்திரத்தின் ஒரு பகுதியாகும்.) ");
INSERT INTO tam2008_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","30 வயது முதல் 50 வயது வரையுள்ள, படையில் பணியாற்றக்கூடிய ஆண்களைக் கணக்கிடு. இவர்கள் ஆசரிப்புக் கூடாரத்தில் வேலை செய்வார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","ஆசரிப்புக் கூடாரத்தில் உள்ள மிகப் பரிசுத்தமானப் பொருட்களைக் கவனித்துக்கொள்வதே இவர்களின் வேலை. ");
INSERT INTO tam2008_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","“இஸ்ரவேல் ஜனங்கள் புதிய இடங்களுக்குப் பயணம் செய்யும்போது, ஆரோனும் அவனது மகன்களும் ஆசரிப்புக் கூடாரத்தின் உள்ளேச் செல்லவேண்டும். அவர்கள் திரையை கீழே எடுத்து, அதனால் பரிசுத்த உடன்படிக்கைப் பெட்டியை மூட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","அதன்மேல் அழகான தோலினாலான மூடியால் மூடவேண்டும். அதன் மேல் கெட்டியான நீலத்துணியை விரித்து, தண்டுகளை வளையத்தினுள் செலுத்தி, பரிசுத்தப்பெட்டியை மூட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“பிறகு ஒரு நீலத்துணியைப் பரிசுத்த மேஜையின்மேல் விரிக்க வேண்டும். அதன் மேல் தட்டுக்களை வைத்து, கரண்டி, கோப்பை, மற்றும் பானங்களின் காணிக்கைக்கான ஜாடியை வைக்க வேண்டும். அதோடு சிறப்பான அப்பத்தையும் அதன் மேல் வைக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","பின் அதன்மேல் சிவப்புத் துணியை வைத்து, அதனை மெல்லிய தோல் மூடியால் மூடவேண்டும். பிறகு மேஜை தண்டுகளையும் வளையத்தினுள் கட்டிவிட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“குத்து விளக்குத் தண்டையும் அதிலுள்ள அகல்களையும் நீலத் துணியால் மூட வேண்டும். விளக்கு எரிவதற்கு உதவுகின்ற அனைத்துப் பொருட்களையும், எண்ணெய் பாத்திரங்களையும் மூடி வைக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","பிறகு இவை அனைத்தையும் மெல்லிய தோலால் மூடிக்கட்டி, ஒரு தண்டோடு இணைக்க வேண்டும். இது இவற்றைத் தூக்கிச் செல்ல உதவியாக இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“அவர்கள் தங்க பலிபீடத்தின் மேல் நீலத் துணியை மூடி, அதன் மேல் மெல்லிய தோலை மூடவேண்டும். அதில் தண்டுகளை வளையத்தோடு இணைத்துக் கட்ட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“பிறகு பரிசுத்த இடத்தில் தொழுதுகொள்வதற்குப் பயன்படும், அனைத்து சிறப்புப் பொருட்களையும் சேகரிக்க வேண்டும். அவற்றை நீலத்துணியில் சுருட்ட வேண்டும். பிறகு அதனை மெல்லியத் தோலால் மூடிக்கட்டவேண்டும். இவற்றைத் தூக்கிச் செல்வதற்கு வசதியாக ஒரு தண்டோடு கட்டிக்கொள்ள வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“வெண்கலத்தாலான பலீபீடத்தில் உள்ள சாம்பலை சுத்தப்படுத்த வேண்டும். பிறகு அதனை நீலத் துணியால் மூட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","பின் தொழுதுகொள்வதற்கான அனைத்துப் பொருட்களையும் சேகரிக்க வேண்டும். நெருப்புத்தட்டு, குறடு, சாம்பல் எடுக்கும் கரண்டி, கலசங்கள் போன்றவைகளை அவர்கள் வெண்கலத்தாலான பலி பீடத்தின் மேல் வைக்க வேண்டும். பின் மெல்லியத் தோலால் பலிபீடத்தை மூடவேண்டும். இவற்றைத் தூக்கிச் செல்ல வசதியாக தண்டுகளை வளையங்களில் மாட்டிள்ளவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“ஆரோனும் அவனது மகன்களும், பரிசுத்த இடத்திலுள்ள பரிசுத்தமான பொருட்களையெல்லாம் மூடிவைத்துக் கொள்ளவேண்டும். பிறகு கோகாத் கோத்திரத்தில் உள்ளவர்கள், இவற்றைத் தூக்கிச் செல்ல வேண்டும். இம்முறையில் இவர்கள் மரிக்காதபடிக்கு பரிசுத்தமான இடத்தைத் தொடாதிருக்கக்கடவர்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“ஆசாரியன் ஆரோனின் மகனான எலெயாசார் பரிசுத்தக் கூடாரத்தின் பொறுப்புக்குரியவன். பரிசுத்த இடத்திற்கும், அதிலுள்ள பொருட்களுக்கும் அவனே பொறுப்பானவன். விளக்குக்குரிய எண்ணெய்க்கும், நறுமணப் பொருட்களுக்கும், தினந்தோறும் செலுத்தப்படும் பலிகளுக்கும், அபிஷேக எண்ணெய்க்கும் அவனே பொறுப்பானவன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","மேலும் கர்த்தர் மோசேயிடமும், ஆரோனிடமும், ");
INSERT INTO tam2008_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“கவனமாக இருங்கள். கோகாத் கோத்திரம் அழிந்துபோகாமல் பார்த்துக்கொள்ளுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","அவர்கள் மகா பரிசுத்த இடத்தின் அருகில் செல்லும்போது மரிக்காமல் இருப்பதற்காக, நீங்கள் அவர்களுக்காக இவற்றைச் செய்யவேண்டும். ஆரோனும் அவனது மகன்களும் உள்ளே போய்க் கோகாத்தியர்கள் என்னென்ன செய்ய வேண்டும் என்று கூறுவார்கள். ஒவ்வொரு ஆணுக்கும் அவனது வேலையும், அவன் சுமக்க வேண்டியவற்றையும் நியமிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","நீங்கள் இவற்றைச் செய்யாவிட்டால் கோகாத்தியர்கள் உள்ளே போய் பரிசுத்த பொருட்களை ஒரு வேளை பார்த்துவிடலாம். அவ்வாறு ஒரு வினாடி பார்த்தாலும், அவர்கள் மரிக்க நேரிடும்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“கெர்சோன் குடும்பத்தில் உள்ள அனைத்துԔ ஜனங்களையும் எண்ணிக் கணக்கிடு. அவர்களைக் குடும்ப வாரியாகவும், கோத்திரங்களாகவும் பட்டியலிடு. ");
INSERT INTO tam2008_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","படையில் பணியாற்றக் கூடிய 30 வயது முதல் 50 வயது வரையுள்ள ஆண்களையும் கணக்கிடுக. இவர்களுக்கு ஆசரிப்புக் கூடாரத்தைக் கவனிக்கும் வேலையுண்டு. ");
INSERT INTO tam2008_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“இவைதான் கெர்சோன் வம்சத்தாரின் வேலைகள். அவர்கள் கீழ்க்கண்டவற்றைச் சுமக்க வேண்டும்: ");
INSERT INTO tam2008_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","பரிசுத்த கூடாரத்தின் திரைகளையும், அதோடு ஆசாரிப்புக் கூடாரத்தையும், அதன் மூடியையும், அவற்றைப் போர்த்தியுள்ள மெல்லியத் தோல் மூடியையும், ஆசாரிப்புக் கூடார வாசல் திரையையும் சுமந்து செல்ல வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","அவர்கள் பரிசுத்தக் கூடாரத்தைச் சுற்றியுள்ள பிரகாரத்தின் தொங்கு திரைகளையும், பலி பீடத்தின் திரையையும், பிரகாரத்ததின் வாசல் திரையையும், அதோடு கயிறுகளையும், திரைக்குப்பயன்படும் மற்ற பொருட்களையும் சுமக்க வேண்டும். இவற்றுக்காகச் செய்ய வேண்டிய அனைத்து வேலைகளையும் கெர்சோனியர்கள் செய்யவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","கெர்சோனியர்கள் சுமத்தல் மற்றும் மற்ற வேலைகளையும் செய்யும்போது ஆரோனும் அவனது மகன்களும் இவ்வேலைகளைக் கவனித்துக்கொள்ள வேண்டும். அவர்கள் சுமக்க வேண்டிய பொருட்களைப்பற்றி அவர்களிடம் எடுத்துச் சொல்ல வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","ஆசரிப்புக் கூடாரத்துக்காக கெர்சோனிய கோத்திரம் செய்ய வேண்டிய பணிகள் இவைதான். ஆசாரியனான ஆரோனின் மகனான இத்தாமார் இந்த வேலைகளுக்குப் பொறுப்பானவன். ");
INSERT INTO tam2008_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“மெராரி கோத்திரத்தில் உள்ள எல்லாக் கோத்திரங்களையும், எண்ணிக் கணக்கெடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","படையில் பணியாற்றக் கூடிய 30 முதல் 50 வயது வரையுள்ள ஆண்களைக் கணக்கிடு. இவர்கள் ஆசரிப்புக் கூடாரத்திற்காக, ஒரு சிறப்பான பணியைச் செய்ய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","நீங்கள் பயணம் செய்யும்போது, ஆசரிப்புக் கூடாரத்திற்கான மரச் சட்டங்களை, இவர்களே சுமந்து செல்ல வேண்டும். அதோடு பாதங்களையும், தாழ்ப்பாள்களையும், தூண்களையும். ");
INSERT INTO tam2008_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","பிரகாரத் தூண்களையும் சுமக்க வேண்டும். பிரகாரத்திலுள்ள மற்ற பாதங்கள், முளைகள், கயிறுகள், அவற்றுக்கான சகல கருவிகள் ஆகியவற்றையும் சுமக்க வேண்டும். அதோடு, அதைச் சார்ந்த அனைத்து வேலைகளையும் செய்ய வேண்டும். அவர்களின் பெயரைப் பட்டியலிட்டு, ஒவ்வொருவரிடமும் அவர்கள் எதைச் சுமந்து செல்ல வேண்டும் என்பதையும் சொல்லுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","இவைதான் மெராரி வம்சத்தினர் ஆசரிப்புக் கூடாரத்திற்காகச் செய்ய வேண்டிய பணிகளாகும். ஆசாரியனான ஆரோனின் மகனாகிய இத்தாமார் இதற்கான பொறுப்புடையவன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","கோகாத்தியர்களையும், மற்ற இஸ்ரவேல் தலைவர்களையும் மோசேயும் ஆரோனும் எண்ணிக் கணக்கிட்டனர். அவர்களைக் குடும்ப வாரியாகவும், கோத்திரங்கள் வாரியாகவும் கணக்கிட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","படையில் பணியாற்றக்கூடிய 30 முதல் 50 வயதுவரையுள்ள ஆண்கள் அனைவரையும் அவர்கள் கணக்கிட்டனர். இவர்கள் ஆசரிப்புக் கூடாரத்திற்கான சிறப்பு வேலைகளைச் செய்யும்படி நியமிக்கப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","கோகாத்திய கோத்திரத்தில் 2,750 ஆண்கள் இவ்வேலையைச் செய்ய தகுதியுடையவர்களாக இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","எனவே, ஆசரிப்புக் கூடாரத்திற்க்கான சிறப்பு வேலைகளைச் செய்ய கோகாத்திய கோத்திரத்தினர் நியமிக்கப்பட்டனர். கர்த்தர் மோசேயிடம் சொன்னபடியே, மோசேயும், ஆரோனும் இதனைச் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","கெர்சோனிய கோத்திரத்தினரும் எண்ணி கணக்கிடப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","படையில் பணியாற்றும் தகுதியுடைய 30 முதல் 50 வயது வரையுள்ள ஆண்கள் எண்ணப்பட்டனர். அவர்கள் ஆசரிப்புக் கூடாரத்திற்கான சிறப்பு பணிகளைச் செய்ய நியமிக்கப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","கெர்சோன் கோத்திரத்தில் தகுதி கொண்டவர்களாக 2,630 ஆண்கள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","எனவே, கெர்சோன் கோத்திரத்தைச் சேர்ந்த இவர்களுக்கு, ஆசரிப்புக் கூடாரத்தின் சிறப்பு வேலைகள் கொடுக்கப்பட்டன. கர்த்தர் மோசேயிடம் சொன்னபடி மோசேயும், ஆரோனும் செய்து முடித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","மெராரி குடும்பத்திலும், கோத்திரங்களிலும் உள்ள ஆண்கள் கணக்கிடப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","அவர்களில் படையில் பணியாற்றக்கூடிய 30 முதல் 50 வயதுவரையுள்ள ஆண்கள் அனைவரும் எண்ணப்பட்டனர். அந்த ஆண்கள் ஆசரிப்புக் கூடாரத்திற்கான சிறப்பு வேலைகளைச் செய்ய நியமிக்கப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","மெராரி கோத்திரத்தில் தகுதி கொண்டவர்களாக 3,200 ஆண்கள் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","எனவே, மெராரி கோத்திரத்தில் உள்ள இந்த ஆண்கள், இச்சிறப்பு வேலைகளுக்கு நியமிக்கப்பட்டனர். கர்த்தர் மோசேயிடம் சொன்னபடி மோசேயும் ஆரோனும் செய்து முடித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","எனவே மோசே, ஆரோன், இஸ்ரவேல் ஜனங்களின் தலைவர்கள் ஆகியோர் லேவியரின் கோத்திரத்தில் உள்ளவர்களையும் எண்ணிக் கணக்கிட்டனர். அவர்கள் ஒவ்வொரு குடும்பவாரியாகவும், கோத்திர வாரியாகவும் கணக்கிடப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","படையில் பணியாற்றக் கூடிய 30 முதல் 50 வயதுவரையுள்ள ஆண்களும் எண்ணிக் கணக்கிடப்பட்டனர். இவர்களுக்கு ஆசரிப்புக் கூடாரத்தின், சிறப்பு வேலைகள் தரப்பட்டன. அவர்கள் தங்கள் பயணத்தின்போது, ஆசரிப்புக் கூடாரத்தைச் சுமக்கும் வேலையைச் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","அவர்களின் மொத்த எண்ணிக்கை 8,580. ");
INSERT INTO tam2008_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","எனவே, கர்த்தர் மோசேயிடம் சொன்னப்படி, ஒவ்வொரு ஆண்மகனும், கணக்கிடப்பட்டான். ஒவ்வொருவனுக்கும் அவன் செய்யவேண்டிய வேலை ஒதுக்கப்பட்டது. அவன் எதனைச் சுமந்து செல்லவேண்டும் என்பதும் சொல்லப்பட்டது. இவை யாவும் கர்த்தர் கட்டளையிட்டபடியே நடைபெற்றது. ");
INSERT INTO tam2008_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“நான் இஸ்ரவேல் ஜனங்களுக்கு கட்டளையிடுவதாவது: அவர்கள் தங்கள் முகாம்களை நோய்கள் பரவாதபடி வைத்துக்கொள்ளவேண்டும். அவர்களில் யாராவது ஒருவனுக்குத் தொழுநோய் இருந்தால், அவனை முகாமை விட்டு அனுப்பிவிட வேண்டும் என்று சொல். முகாமில் யாருக்காவது (இரத்தப் போக்கான) விலக்கு தீட்டு இருந்தால் அவர்களையும் அனுப்பிவிட வேண்டும் என்று சொல். முகாமில் யாராவது பிணத்தைத் தொட்டு அதனால் தீட்டாகியிருந்தால் அவனையும் வெளியே அனுப்பி விடவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","ஆணா, பெண்ணா என்பது பற்றிக் கவலைப்படாமல் அந்த நபரை வெளியேற்ற வேண்டும். அதனால் மற்றவர்களுக்கு அந்த நோயும், தீட்டும் ஏற்படாமல் இருக்கும். நானும் உங்கள் முகாமில் உங்களோடு வாழ்வேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","எனவே இஸ்ரவேல் ஜனங்கள் தேவனுடைய கட்டளைகளுக்குக் கீழ்ப்படிந்தனர். அவர்கள் இத்தகையவர்களை முகாமைவிட்டு வெளியேற்றினர். கர்த்தர் மோசேயிடம் கட்டளையிட்டபடியே அவர்கள் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“இஸ்ரவேல் ஜனங்களில் ஒருவன் இன்னொருவனுக்குத் தீமை செய்திருந்தால் (ஒருவன் இன்னொருவனுக்குத் தீமை செய்வது என்பது உண்மையில் தேவனுக்கு எதிராகப் பாவம் செய்வதாகும்) அவன் தண்டனைக்கு உரியவன். ");
INSERT INTO tam2008_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","எனவே அவன் தான் செய்த பாவத்தைப் பற்றி ஜனங்களிடம் சொல்ல வேண்டும். பின் அதற்கான அபராதத் தொகையையும் செலுத்த வேண்டும். அதில் ஐந்தில் ஒரு பாகத்தையும் சேர்த்து பாதிக்கப்பட்டவனுக்குக் கொடுக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","பாதிக்கப்பட்டவன் ஒருவேளை மரித்து போயிருந்தாலோ, அத்தொகையை ஏற்றுக்கொள்ள அவனுக்கு நெருங்கிய உறவினர்கள் யாரும் இல்லாமலிருந்தாலோ, அவன் அத்தொகையை கர்த்தருக்குச் செலுத்த வேண்டும். அவன் அம்முழுத்தொகையையும் ஆசாரியனிடம் கொடுக்க வேண்டும். அந்த ஆசாரியன் அவனது பாவநிவிர்த்திக்காக ஆட்டுக் காடாவை பலியாகச் செலுத்த வேண்டும். அதனைப் பலியிடுவதன் மூலம் ஜனங்கள் செய்த பாவமானது நிவிர்த்தி செய்யப்படுகிறது. மீதி பணத்தை, ஆசாரியன் வைத்துக்கொள்ள வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","“இஸ்ரவேலனாக இருக்கும் ஒருவன் தேவனுக்கு இதுபோல் சிறப்பான அன்பளிப்புகளைச் செலுத்தினால் ஆசாரியன் அவற்றைப் பெற்றுக்கொள்ள வேண்டும். அது அவனுக்கு உரியது. ");
INSERT INTO tam2008_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","ஒருவன் இது போன்ற சிறப்பு காணிக்கைகளை கொடுக்காமலும் இருக்கலாம். ஆனால் ஆசாரியனுக்குக் கொடுக்கப்பட்ட எதுவும் அவனுக்கு உரியதாகிவிடும்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“ஒருவனின் மனைவி அவனுக்கு நம்பிக்கைத் துரோகம் செய்திருக்கலாம். ");
INSERT INTO tam2008_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","அவள் இன்னொருவனோடு பாலின உறவு வைத்துக்கொண்டு அதனைக் கணவனுக்குத் தெரியாமல் மறைத்துவிடலாம். அவள் தனது செயலில் பிடிபடாமல் அவளுக்கு எதிராக எந்த சாட்சியும் இல்லாமல் இருக்கலாம். எனவே, அவள் செய்த பாவம் அவளது கணவனுக்குத் தெரியாமல் போய்விடலாம். அவளும் தன் கணவனுக்குத் தன் பாவம் பற்றி சொல்லாமல் இருக்கலாம். ");
INSERT INTO tam2008_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ஆனால், அவளது கணவன் தனது மனைவி தனக்குத் துரோகம் செய்கிறாளோ என்று சந்தேகப்படலாம். அவள் தனக்கு உண்மையானவளாகவும், சுத்தமானவளாகவும் இல்லை என்று அவன் நினைக்கலாம். ");
INSERT INTO tam2008_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","இவ்வாறு நிகழ்ந்தால், அவன் தன் மனைவியை ஆசாரியனிடம் அழைத்துச் செல்லவேண்டும். அப்போது, அவன் காணிக்கையாக ஒரு எப்பா அளவான வாற் கோதுமை மாவிலே பத்தில் ஒரு பங்கைக் கொடுக்க வேண்டும். அவன் அந்த வாற்கோதுமை மாவிலே எண்ணெயோ, நறுமணப் பொருளோ போடக்கூடாது. இது கர்த்தருக்குத் தானிய காணிக்கையாக இருக்கும். கணவன் சந்தேகம் அடைந்ததால் அதற்குப் பரிகாரமாக இப்பலி அமைகின்றது. தனது மனைவி தனக்கு உண்மையில்லாதவளாக இருந்தாள் என்று அவன் எண்ணியதை இப்பலி காட்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ஆசாரியன் அந்தப் பெண்ணை கர்த்தரின் முன்பு அழைத்துக்கொண்டு போய் அங்கே அவளை நிறுத்தி, ");
INSERT INTO tam2008_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","பிறகு ஆசாரியன் பரிசுத்த தண்ணீரை எடுத்து மண்ஜாடியில் ஊற்ற வேண்டும். பின் பரிசுத்தக் கூடாரத்தின் தரையிலிருந்து கொஞ்சம் மண்ணை எடுத்து, அப்பாத்திரத்தில் போட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","ஆசாரியன் அவளைக் கர்த்தர் முன் நிற்குமாறு செய்து பிறகு அவளது கூந்தலை அவிழ்க்கச் சொல்லி, அவள் கையில் தானியக் காணிக்கையை வைக்க வேண்டும். இப்பலி, அவளது கணவனால் அவனது சந்தேகத்திற்காக கர்த்தருக்குக் கொடுக்கப்பட்ட காணிக்கையாகும். அதே நேரத்தில் ஆசாரியன் தன் கையில் பரிசுத்த தண்ணீர் இருக்கும் மண் ஜாடியை வைத்திருக்க வேண்டும். அந்த பரிசுத்த தண்ணீர் அவள் பாவம் செய்திருந்தால் அவளுக்கு சாபத்தை உண்டாக்கும். ");
INSERT INTO tam2008_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","“பிறகு, ஆசாரியன் அந்தப் பெண்ணிடம் அவள் பொய் சொல்லக்கூடாது என்றும், அவள் உண்மையைச் சொல்ல வேண்டுமென்றும் கட்டளையிட வேண்டும். ஆசாரியன் அவளிடம், ‘நீ இன்னொரு மனிதனோடு தொடர்பு வைக்காமல் இருந்திருந்தால், திருமணத்துக்கு பின் உன் கணவனுக்கு எதிராகப் பாவம் செய்யாமல் இருந்திருந்தால், சாபங்களைக் கொடுக்கும் இந்த தண்ணீரானது உனக்குத் தீங்கு செய்யாது. ");
INSERT INTO tam2008_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","ஆனால் நீ உன் கணவனுக்கு எதிராகப் பாவம் செய்திருந்தால், உன் கணவன் அல்லாத ஒருவனுடன் நீ தொடர்பு வைத்திருந்தால், நீ தூய்மையானவளல்ல. ");
INSERT INTO tam2008_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","இது உண்மையென்றால், இந்த பரிசுத்தமான தண்ணீரை நீ குடிப்பதால் உனக்குத் துன்பங்கள் வரும். உனக்குக் குழந்தை பெறுகிற பாக்கியம் கிடைக்காமல்போகும். ஒருவேளை நீ இப்பொழுது கருவுற்றவளாக இருந்தால் அக்குழந்தை மரித்துப்போகும். பிறகு உன் ஜனங்கள் உன்னை விலக்கி வைத்து, உன் மீது குற்றங்களைச் சுமத்துவார்கள்’ என்று கூறவேண்டும். “பிறகு கர்த்தருக்கு முன்பு ஒரு விசேஷ உறுதியளிக்கும்படி அப்பெண்ணிடம் ஆசாரியன் சொல்ல வேண்டும். பொய் சொன்னால் அவளுக்குத் தீமைகள் ஏற்படும் என்பதை அவள் உணரச் செய்ய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","நீ கேடு உண்டாக்கக் கூடிய தண்ணீரைக் குடிக்க வேண்டும். நீ பாவம் செய்திருந்தால், ‘உனக்குக் குழந்தை ஏற்படாமல் போகும். நீ கருவுற்றிருந்தால் அது பிறக்குமுன் மரித்துப்போகும்’ என்று ஆசாரியன் அப்பெண்ணிடம் கூறவேண்டும். அதற்கு அவள், ‘நீர் சொல்கிறபடி நான் செய்வேன்’ என்று கூற வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“இந்த எச்சரிக்கைகளையெல்லாம் ஒரு நீண்டத் தோல் சுருளில் ஆசாரியன் எழுதி வைக்க வேண்டும். அதனைப் பிறகு பரிசுத்தத் தண்ணீரால் சிறிது கழுவ வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","பின்னர் கேடு தருகிற அந்தத் தண்ணீரை அவள் குடிக்க வேண்டும். அதைக் குடித்ததும், அவள் பாவம் செய்தவளாக இருந்தால் அத்தண்ணீர் அவளுக்குப் பெருந்துன்பத்தைத் தரும். ");
INSERT INTO tam2008_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","“பிறகு ஆசாரியன் அவள் கையில் உள்ள தானியக் காணிக்கையை வாங்கி அதனை கர்த்தரின் சமூகத்தில் தூக்கிப் பிடிக்க வேண்டும். பின் அதனைப் பலிபீடத்தில் வைக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","ஆசாரியன் அத்தானியப் பலியைக் கை நிறைய அள்ளி பலிபீடத்தின் நெருப்பில் போட்டு எரிந்துவிட வேண்டும். அதற்குப் பிறகு ஆசாரியன் அவள் தண்ணீரைக் குடிக்குமாறு கேட்டுக்கொள்ள வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","அவள் தன் கணவனுக்கு எதிராகப் பாவம் செய்தவளாக இருந்தால், அந்த தண்ணீர் அவளுக்குப் பெருந்துன்பத்தை அளிக்கும். அத்தண்ணீர் அவள் உடம்புக்குள் சென்று அவளுக்குப் பெருந்துன்பத்தைக் கொடுக்கும். அவள் கருவிலுள்ள எந்தக் குழந்தையும், அது பிறக்கு முன்னரே மரித்துப்போகும். அவள் என்றென்றும் குழந்தை பெற முடியாமல் இருப்பாள். அவள் அவளது ஜனங்களின் மத்தியில் சபிக்கப்பட்டவளாக இருப்பாள். ");
INSERT INTO tam2008_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","ஆனால் அவள் தன் கணவனுக்கு எதிராகப் பாவம் செய்யாமல், சுத்தமானவளாக இருந்தால், ஆசாரியன் அவளைக் குற்றமற்றவள் என்று கூறுவான். பின் அவள் சாதாரணமானவளாக குழந்தைகளைப் பெறுவாள். ");
INSERT INTO tam2008_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“இதுவே பொறாமை அல்லது சந்தேகம் பற்றிய சட்டமாகும். ஒருத்தி ஒருவனுக்குத் திருமணத்தின் மூலம் மனைவியான பிறகு, அவனுக்கு எதிராகப் பாவம் செய்தால், நீங்கள் இதையே செய்ய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ஒரு கணவன் தன் மனைவி மீது பொறாமை கொண்டு அவளைச் சந்தேகப்பட்டாலும், அவன் இந்தப் பரிகாரத்தையே செய்ய வேண்டும். ஆசாரியன் அந்தப் பெண்ணை கர்த்தரின் முன்னிலையில் நிற்கச் செய்து இவற்றையெல்லாம் செய்ய வேண்டும். இதுதான் சட்டம். ");
INSERT INTO tam2008_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","அவள் தவறினிமித்தம் அவள் கணவனுக்கு எதுவும் நேரிடாது. ஆனால் அந்தப் பெண்ணோ தன் பாவத்தினிமித்தம் துன்பப்படுவாள்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“இவற்றை இஸ்ரவேல் ஜனங்களிடம் கூறு. ஒரு ஆணோ அல்லது பெண்ணோ தன் ஜனங்களிடமிருந்து தனியே பிரிந்து வாழ வேண்டும் என்று விரும்பலாம். இந்த விரதகாலம் ஒருவன் தன்னையே முழுக்க கர்த்தருக்கு சில காலம் ஒப்படைத்துக்கொள்ள அனுமதிக்கிறது. இத்தகையவனை ‘நசரேயன்’ என அழைப்பார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","இக்காலக் கட்டத்தில், அவன் திராட்சைரசமோ, போதை தரும் வேறு பானமோ குடிக்கக் கூடாது. அவன் திராட்சைரசம் மற்றும் மதுபானத்தின் காடியையோ குடிக்கக் கூடாது. திராட்சைரசத்தால் செய்த எவ்வித பானத்தையோ திராட்சைப் பழங்களையோ, காய்ந்த திராட்சைகளையோ உண்ணாமல் இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","இந்த விரத காலத்தில் அவன் திராட்சைச் செடியின் எந்த உணவுப் பொருட்களையும், உண்ணக் கூடாது, அவன் திராட்சைப் பழத்தின் தோலையும் விதைகளையும் கூட உண்ணக்கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“இந்த விரதகாலத்தில் அவன் தனது தலை முடியைக் கூட வெட்டிக் குறைத்துக்கொள்ளக் கூடாது. தனது விரத நாட்கள் முடியும் வரையில் அவன் பரிசுத்தமாக இருக்க வேண்டும். அவன் தன் தலைமுடியை வளரவிட வேண்டும். அவனது தலை முடியானது அவன் தேவனுக்குச் செய்த பொருத்தனையின் ஒரு பகுதியாகும். அவன் அந்த முடியை வெட்டாமலிருப்பது தேவனுக்குத் தன்னை அர்ப்பணித்திருப்பதின் அடையாளம். எனவே விரதகாலம் முடிகிறவரை தனது தலைமுடியை நீளமாக வளரவிட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“இவ்விரதக் காலத்தில் ஒரு நசரேயன் பிணத்தின் அருகில் செல்லக்கூடாது. ஏனென்றால் அவன் கர்த்தருக்குத் தன்னை முழுமையாக அர்ப்பணித்து இருக்கிறான். ");
INSERT INTO tam2008_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","ஒரு வேளை அவனது தாயோ, தந்தையோ, அல்லது சகோதரனோ, சகோதரியோ கூட மரித்து போயிருக்கலாம். எனினும் அவன் அவர்களைத் தொடக் கூடாது. அது அவனைத் தீட்டு உள்ளவனாக ஆக்கும். அவன் தன்னைத் தனிப்பட்டவன் என்றும், தன்னை தேவனுக்கு முழுமையாகக் கொடுத்திருக்கிறான் என்பதையும் காட்ட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","விரதகாலம் முழுமைக்கும் அவன் தன்னை முழுவதுமாக கர்த்தரிடம் ஒப்படைக்கிறான். ");
INSERT INTO tam2008_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","நசரேய விரதம் கொள்பவன், இன்னொருவனோடு இருக்கும்போது, தீடீரென்று அந்த மற்றவன் மரித்துப் போனதாக வைத்துக்கொள்வோம். அவனையறியாமலேயே மரித்தவனைத் தொட்டிருப்பானேயானால், அவன் தீட்டுள்ளவனாகக் கருதப்படுகிறான். இவ்வாறு நிகழ்ந்தால் அவன் தலைமுடியை முழுக்க மழித்துக்கொள்ள வேண்டும். (அந்தத் தலை முடியானது அவனது விசேஷ அர்ப்பணிப்பின் ஒரு பகுதியாகும்.) ஏழாவது நாள் தன் முடியை வெட்டிக்கொள்ள வேண்டும். ஏனென்றால் அன்றைக்குத்தான் அவன் தீட்டு இல்லாதவனாகிறான். ");
INSERT INTO tam2008_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","எட்டாவது நாள், நசரேய விரதம் கொள்ளும் அவன், இரண்டு புறாக்களையும் இரண்டு புறாக் குஞ்சுகளையும் ஆசாரியனிடம் கொண்டுவரவேண்டும். அவன் இவற்றை ஆசரிப்புக் கூடாரத்தின் வாசலில் ஆசாரியனிடம் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","பிறகு ஆசாரியன் அவற்றில் ஒன்றைப் பாவப்பரிகாரப் பலியாகவும் இன்னொன்றைத் தகன பலியாகவும் தரவேண்டும். இந்த தகனபலியானது நசரேய விரதத்தில் அவன் செய்த பாவத்திற்குரிய காணிக்கையாகும். (அவன் பிணத்தின் அருகில் இருந்ததால் பாவம் செய்தவனாகக் கருதப்படுகிறான்.) அந்த வேளையில், அவன் தன் தலைமுடியை மீண்டும் தேவனுக்கு தருவதாக வாக்களிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","அவன் மீண்டும் ஒருமுறை கர்த்தருக்காகத் தன்னை முழுமையாக ஒப்புக் கொடுத்து தனியாக சில காலம் நசரேய விரதம் இருக்க வேண்டும். அவன் ஓராண்டான ஆட்டுக் குட்டியைக் கொண்டு வந்து அதை குற்ற பரிகார பலியாகக் கொடுக்க வேண்டும். அவன் விரதம் இருந்த நாட்களெல்லாம் மறக்கப்படும். எனவே, அவன் புதிதாக விரதம் அனுசரிக்க வேண்டும். அவன் முதலில் விரதம் இருக்கும்போது, பிணத்தைத் தொட்டதினால் தீட்டானதே இதற்குக் காரணம். ");
INSERT INTO tam2008_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“அவனது விரதகாலம் முடிந்தபிறகு, ஒரு நசரேயன் ஆசரிப்புக் கூடாரத்தின் வாசலுக்குப் போக வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","அவன் தனது காணிக்கையைக் கர்த்தருக்குக் கொடுக்க வேண்டும். அவன்: தகன பலிக்காக ஒரு வயதான, எவ்விதக் குறைபாடும் இல்லாத ஆட்டுக்குட்டியையும்; பாவப்பரிகார பலிக்காக ஒரு வயதான, குறைபாடுகளற்ற ஒரு பெண் ஆட்டுக்குட்டியையும், சமாதான பலிக்காக குறைபாடுகளற்ற ஆட்டுக் கடாவையும், ");
INSERT INTO tam2008_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","தானிய காணிக்கைக்காக கூடை நிறைய எண்ணெயிலே பிசைந்த புளிப்பில்லாத மெல்லிய மாவில் செய்த அதிரசங்களையும், எண்ணெய் தடவப்பட்ட புளிப்பில்லாத அடைகளையும் காணிக்கையாக செலுத்த வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“இவை அனைத்தையும் கர்த்தருக்கு ஆசாரியன் கொடுக்கவேண்டும். பிறகு, அவன் பாவப் பரிகார பலியையும், தகன பலியையும் செலுத்த வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","புளிப்பில்லாத அதிரசங்கள் நிறைந்த கூடையைக் கர்த்தருக்கு ஆசாரியன் கொடுக்க வேண்டும். சமாதான பலிக்காக அவன் ஆட்டுக் கடாவைக் கொல்ல வேண்டும். பிறகு அவன் தானிய காணிக்கையையும், பானங்களின் காணிக்கையையும் அளிக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“நசரேய விரதம் கொண்டவன் ஆசரிப்புக் கூடாரத்தின் வாசலுக்குச் செல்ல வேண்டும். அவன் அங்கே கர்த்தருக்காக வளர்த்த தலை முடியை மழித்துக்கொள்ள வேண்டும். பிறகு அதனை சமாதானப் பலிக்குக் கீழ் நெருப்பில் போட்டு எரிக்க வேண்டும்.Ԕ ");
INSERT INTO tam2008_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“நசரேய விரதம் கொண்டவன், தன் தலை முடியை மழித்தபிறகு ஆசாரியன் வேகவைத்த ஆட்டுக்கடாவின் தோள்பாகத்தையும், கூடையில் உள்ள புளிப்பில்லாத அதிரசம் மற்றும் அடையையும் அவனுடைய உள்ளங்கையில் வைக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","பின்னர் ஆசாரியன் இவற்றை கர்த்தருக்கு முன் அசைவாட்டும் பலியாக ஏறெடுக்க வேண்டும். அது அசைவாட்டப்பட்ட மார்க்கண்டத்தோடும், ஏறெடுத்துப் படைக்கப்பட்ட முன்னந்தொடையோடும் ஆசாரியனுக்கு உரியதாகும். ஆட்டுக் கடாவின் மார்க்கண்டத்தையும், தொடையையும் கர்த்தருக்கு முன்பு அசைவாட்டும் பலி செய்வார்கள். அவைகளும் ஆசாரியனுக்கு உரியதாகும். அதற்குப் பிறகு நசரேய விரதம் கொண்டவன், திராட்சை ரசம் குடிக்கலாம். ");
INSERT INTO tam2008_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“நசரேய விரதம் கொள்ளும் ஒருவன், கடைப்பிடிக்க வேண்டிய விதிகள் இவையாகும். அவன் அனைத்து அன்பளிப்புகளையும் கர்த்தருக்குக் கொடுக்க வேண்டும். ஆனால் ஒருவன் மிக அதிக அளவில் கர்த்தருக்கு அன்பளிப்பு தரும் வசதியைக் கொண்டிருக்கலாம். ஒருவன் அவ்வாறு மிகுதியாக அன்பளிப்பு கொடுப்பதாக வாக்குத்தந்தால் பிறகு அந்த வாக்கைக் காப்பாற்ற வேண்டும். ஆனால் அவன் குறைந்தபட்சமாக நசரேய விதிகளில் சொல்லியபடியாவது காணிக்கை செலுத்த வேண்டும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“ஆரோனிடமும் அவனது மகன்களிடமும், சொல்ல வேண்டியதாவது: நீங்கள் இஸ்ரவேல் ஜனங்களை ஆசீர்வதிக்கும்போது, ");
INSERT INTO tam2008_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“‘கர்த்தர் உன்னை ஆசீர்வதித்து, உன்னைக் காப்பாற்றுவாராக! ");
INSERT INTO tam2008_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","கர்த்தர் உன்னிடம் நல்லவராக இருந்து அவர் உனக்குக் கருணை காட்டுவாராக! ");
INSERT INTO tam2008_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","உனது ஜெபங்களுக்கு கர்த்தர் பதில் தருவாராக! அவர் உனக்குச் சமாதானத்தைத் தருவாராக!’ என்று சொல்லுங்கள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“இவ்வாறு ஆரோனும், அவனது மகன்களும் எனது நாமத்தைச் சொல்லி இஸ்ரவேல் ஜனங்களை ஆசீர்வதிக்க வேண்டும். நானும் அவர்களை ஆசீர்வதிப்பேன்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","மோசே பரிசுத்தக் கூடாரத்தை அமைத்து முடித்தான். அந்நாளிலேயே அதனை கர்த்தருக்கு அர்ப்பணித்தான். மோசே கூடாரத்தையும் அதிலுள்ள பொருட்களையும், பலிபீடத்தையும் அதற்குரிய அனைத்து பொருட்களையும் அபிஷேகம் செய்தான். இவையனைத்துப் பொருட்களும் கர்த்தரை தொழுதுகொள்வதற்கு மாத்திரமே பயன்படுத்தப்பட வேண்டும் என்று இது காட்டியது. ");
INSERT INTO tam2008_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","பிறகு இஸ்ரவேலின் அனைத்து தலைவர்களும் கர்த்தருக்குக் காணிக்கை செலுத்தினார்கள். இவர்கள் அவர்களது குடும்பத்தின் தலைவர்களும் கோத்திரங்களின் தலைவர்களும் ஆவார்கள். இவர்களே இஸ்ரவேல் ஜனங்களை எண்ணி கணக்கிடும் பொறுப்புடையவர்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","இத்தலைவர்கள் கர்த்தருக்கு அன்பளிப்புகளைக் கொண்டு வந்தனர். அவர்கள் மூடப்பட்ட ஆறு வண்டிகளையும் அதை இழுக்க பன்னிரெண்டு மாடுகளையும் கொண்டு வந்தனர். (ஒவ்வொரு தலைவர்களும் ஆளுக்கொரு மாட்டையும் இரு தலைவர்கள் சேர்ந்து ஒரு வண்டியையும் கொடுத்தனர்.) பரிசுத்தக் கூடாரத்தில் தலைவர்கள் இவற்றைக் கர்த்தருக்குக் கொடுத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“தலைவர்களிடமிருந்து இந்த அன்பளிப்புகளைப் பெற்றுக்கொள். ஆசாரிப்புக் கூடாரத்திற்கான வேலைகளுக்கு இக்காணிக்கைகள் உதவியாயிருக்கும்படி இவற்றை லேவியர்களிடம் கொடு” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","எனவே, மோசே வண்டிகளையும், அவற்றை இழுத்து வந்த மாடுகளையும் ஏற்றுக்கொண்டு, அவற்றை லேவியர்களிடம் கொடுத்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","அவன் அவற்றில் இரண்டு வண்டிகளையும் நான்கு மாடுகளையும் கெர்சோன் குழுவினருக்குக் கொடுத்தான். அவர்களின் வேலைக்கு அந்த வண்டிகளும், மாடுகளும் தேவையாய் இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","பிறகு நான்கு வண்டிகளையும் எட்டு மாடுகளையும் மெராரி குழுவினருக்குக் கொடுத்தான். அவர்களின் வேலைக்கு இந்த வண்டிகளும் மாடுகளும் தேவையாய் இருந்தன. ஆசாரியனான ஆரோனின் மகனான இத்தாமார் இவர்களின் வேலைக்கான பொறுப்பினை ஏற்றிருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","மோசே கோகாத் குழுவினருக்கு எந்த வண்டியையும், மாடுகளையும் கொடுக்கவில்லை. ஏனென்றால், அவர்களின் வேலை, பரிசுத்தமான பொருட்களைத் தங்கள் தோள்களில் தூக்கிச் செல்வதாகும். ");
INSERT INTO tam2008_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","மோசே பலிபீடத்தை அபிஷேகம் செய்தான். அதே நாளில், தலைவர்கள் தங்கள் காணிக்கைகளை, அந்தப் பலிபீடத்தை அர்பணிப்பதற்காகக் கொண்டு வந்தனர், அவர்கள் தங்கள் காணிக்கைகளைக் கர்த்தருக்காகப் பலிபீடத்தின் மேல் வைத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","கர்த்தர் மோசேயிடம், “ஒவ்வொரு நாளும், ஒவ்வொரு தலைவனும் தன் அன்பளிப்பைக் கொண்டு வந்து பலிபீடத்தில் அர்ப்பணிக்க வேண்டும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","பன்னிரெண்டு தலைவர்களில் ஒவ்வொரு வரும் தங்கள் அன்பளிப்புகளைக் கொண்டு வந்தனர். அவை பின்வருமாறு: ஒவ்வொரு தலைவனும் மூன்றேகால் பவுண்டு எடையுள்ள ஒவ்வொரு வெள்ளித் தட்டுக்களையும், ஒன்றே முக்கால் பவுண்டு எடையுள்ள ஒவ்வொரு வெள்ளிக் கோப்பைகளையும் கொண்டு வந்தனர். இவ்விரண்டு காணிக்கைகளும் அதிகாரப்பூர்வமான அளவால் நிறுக்கப்பட்டன. வட்டமான கிண்ணங்களும், தட்டுகளும் எண்ணெயில் கலக்கப்பட்ட மெல்லிய மாவால் நிரப்பப்பட்டு இருந்தன. இது தானியக் காணிக்கைக்குப் பயன்படுவதாக இருந்தது. ஒவ்வொரு தலைவனும் பெரிய தங்கக் கரண்டியையும் கொண்டு வந்தனர். அது 4 அவுன்ஸ் எடையுள்ளதாய் இருந்தது. இக்கரண்டி நறுமணப் பொருட்களால் நிரப்பப்பட்டிருந்தது. ஒவ்வொரு தலைவனும் ஒரு இளம் காளையைக் கொண்டு வந்தனர். அதோடு ஒரு ஆட்டுக் கடா, ஒரு வயதான ஒரு ஆண் ஆட்டுக்குட்டி ஆகியவற்றையும் கொண்டு வந்தனர். இம்மிருகங்கள் தகன பலிக்கு உரியவை. ஒவ்வொரு தலைவனும் பாவ பரிகார பலிக்குரியதாக ஒரு ஆட்டுக்கடாவைக் கொண்டு வந்தனர். அதோடு அவர்கள் 2 பசுக்களையும் 5 ஆட்டுக்கடாக்களையும், ஒரு வயதான 5 வெள்ளாட்டுக் கடாக்களையும், 5 ஆண் ஆட்டுக் குட்டிகளையும் கொண்டு வந்தனர். இவை அனைத்தும் சமாதான பலிக்காகக் கொல்லப்பட்டன. முதல் நாளில், யூதா கோத்திரத்தின் தலைவனான அம்மினதாபின் மகனான நகசோன் அன்பளிப்புகளைக் கொண்டு வந்தான். இரண்டாம் நாளில், இசக்கார் குழுவின் தலைவனான சூவாரின் மகன் நெதனெயேல் தன் அன்பளிப்புகளைக் கொண்டு வந்தான். மூன்றாம் நாளில், செபுலோன் கோத்திரத்தின் தலைவனான ஏலோனின் மகன் எலியாப் தன் அன்பளிப்புகளைச் கொண்டு வந்தான். நான்காம் நாளில், ரூபன் கோத்திரத்தின் தலைவனான சேதேயூரின் மகனான எலிசூர் தன் அன்பளிப்புகளைக் கொண்டு வந்தான். ஐந்தாம் நாளில், சிமியோன் கோத்திரத்தின் தலைவனான சூரிஷதாயின் மகன் செலுமியேல் தன் அன்பளிப்புகளைக் கொண்டு வந்தான். ஆறாம் நாளில், காத் கோத்திரத்தின் தலைவனான தேகுவேலின் மகன் எலியாசாப் தன் அன்பளிப்புகளைக் கொண்டு வந்தான். ஏழாம் நாளில், எப்பிராயீம் கோத்திரத்தின் தலைவனான அம்மியூதின் மகன் எலிஷாமா தன் அன்பளிப்புகளைக் கொண்டு வந்தான். எட்டாம் நாளில், மனாசே கோத்திரத்தின் தலைவனான பெதாசூரின் மகன் கமாலியேல் தன் அன்பளிப்புகளைக் கொண்டு வந்தான். ஒன்பதாம் நாளில், பென்யமீன் கோத்திரத்தின் தலைவனான கீதெயோனின் மகன் அபீதான் தன் அன்பளிப்புகளைக் கொண்டு வந்தான். பத்தாம் நாளில், தாண் கோத்திரத்தின் தலைவனான அம்மிஷதாயின் மகன் அகியேசேர் தன் அன்பளிப்புகளைக் கொண்டு வந்தான். பதினோறாம் நாளில், ஆசேர் கோத்திரத்தின் தலைவனான ஓகிரானின் மகன் பாகியேல் தன் அன்பளிப்புகளைக் கொண்டு வந்தான். பன்னிரெண்டாம் நாளில், நப்தலி கோத்திரத்தின் தலைவனான ஏனானின் மகன் அகீரா தன் அன்பளிப்புகளைக் கொண்டு வந்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","இஸ்ரவேலின் ஜனங்களின் தலைவர்களிடமிருந்து இவ்வாறு பல்வேறு அன்பளிப்புகள் வந்து சேர்ந்தன. அவர்கள் இவற்றை மோசே பலிபீடத்தை அபிஷேகம் செய்து அர்ப்பணித்த நாட்களில் கொண்டு வந்தனர். அவர்கள் 12 வெள்ளிக் தட்டுகளையும், 12 வெள்ளிக் கோப்பைகளையும், 12 தங்கக் கரண்டிகளையும் கொண்டு வந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ஒவ்வொரு வெள்ளித்தட்டும் முன்றே கால் பவுண்டு எடையுள்ளதாய் இருந்தது. ஒவ்வொரு வெள்ளிக் கோப்பையும் ஒன்றே முக்கால் பவுண்டு எடையுள்ளதாய் இருந்தது. ஆக மொத்தம் தட்டுகளும் கோப்பைகளும் சேர்ந்து 60 பவுண்டு அதிகாரப்பூர்வமான அளவு எடையுள்ள வெள்ளியாய் இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","நறுமணப் பொருட்கள் நிறைந்த 12 தங்கக் கரண்டிகளும், ஒவ்வொன்றும் 4 அவுன்ஸ் உடையதாக இருந்தது. அந்த 12 தங்கக் கரண்டிகளும் சேர்ந்து 3 பவுண்டு அதிகாரப் பூர்வமான அளவு எடையுள்ளதாக இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","ஆக மொத்தம் தகனபலிக்கான 12 காளைகளும் 12 ஆட்டுக்கடாக்களும், 12 ஒரு வயதான ஆண் ஆட்டுக்குட்டிகளும் கொண்டு வரப்பட்டன. அவற்றோடு தானிய காணிக்கையும் கொடுக்கப்பட்டன. கர்த்தருக்கு பாவப்பரிகாரப் பலியாக 12 ஆண் வெள்ளாடுகளும் கொண்டு வரப்பட்டன. ");
INSERT INTO tam2008_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","சமாதானப் பலிக்குப் பயன்படுத்துவதற்காகத் தலைவர்கள் மிருகங்களைக் கொண்டு வந்தனர். அவற்றின் எண்ணிக்கையானது 24 காளைகள், 60 ஆட்டுக் கடாக்கள், 60 வெள்ளாட்டுக் கடாக்கள், 60 ஒரு வயதான ஆண் ஆட்டுக்குட்டிகள் என இருந்தன. இவ்வாறு மோசே பலிபீடத்தை அபிஷேகம் செய்த பிறகு, அவர்கள் அதனை அர்ப்பணம் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","கர்த்தரோடு பேசுவதற்காக மோசே ஆசரிப்புக் கூடாரத்தின் உள்ளே சென்றான். அப்போது கர்த்தரின் குரல் அவனோடு பேசுவதைக் கேட்டான். அந்தக் குரலானது உடன்படிக்கைப் பெட்டியின் மேலுள்ள கிருபாசனமான இரு கேருபீன்களின் நடுவில் இருந்து உண்டாயிற்று. தேவன் மோசேயோடு பேசிய முறை இதுதான். ");
INSERT INTO tam2008_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“நான் காட்டிய இடத்தில் ஏழு விளக்குகளையும் வைக்க வேண்டும் என்று ஆரோனிடம் சொல். ஏழு விளக்குகளும் விளக்குத் தண்டுக்கு நேரே எரிய வேண்டும்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","ஆரோன் அவ்வாறே விளக்குகளைச் சரியான இடத்தில் வைத்தான். விளக்குத் தண்டுக்கு எதிரேயுள்ள பகுதியில் ஒளி வீசுமாறு விளக்குகள் இருந்தன. கர்த்தர் மோசேக்கு இட்ட கட்டளைக்கு ஆரோன் கீழ்ப்படிந்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","விளக்குத் தண்டு கீழ்க் கண்டவாறு அமைக்கப்பட்டது. இது அடித்த பொன்னால் செய்யப்பட்டது. அடிப்பாகம் முதல் உச்சிவரை பொன்னால் பூ வேலைகள் செய்யப்பட்டிருந்தது. மோசேயிடம் கர்த்தர் சொன்னபடியே விளக்கு அமைக்கப்பட்டிருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“மற்ற இஸ்ரவேல் ஜனங்களிடமிருந்து லேவியர்களைப் பிரித்து, அவர்களைச் சுத்திகரிப்பாயாக. ");
INSERT INTO tam2008_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","கீழ்க்கண்டவாறு அவர்களைச் சுத்தப்படுத்த வேண்டும். அவர்கள் மீது பாவப் பரிகாரத்திற்குரிய சிறப்பான தண்ணீரைத் தெளிக்க வேண்டும். பின் அவர்கள் உடல் முழுவதிலும் சவரம் பண்ணிக் கொண்டு ஆடைகளைச் சலவை செய்ய வேண்டும். இது அவர்களின் உடலைச் சுத்தமாக்கும். ");
INSERT INTO tam2008_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","“லேவியர்களில் ஆண்கள் ஒரு இளங்காளையையும், தானியக் காணிக்கையையும் எடுத்து வரவேண்டும். அப்பலியானது எண்ணெயோடு கலக்கப்பட்ட மெல்லிய மாவாக இருக்கும். பின் இன்னொரு இளங்காளையைப் பாவப் பரிகார பலியாகக் கொண்டு வரவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","லேவியர்களை ஆசரிப்புக் கூடாரத்திற்கு எதிரேயுள்ள இடத்தில் கூட்டவேண்டும். பின் இஸ்ரவேல் ஜனங்கள் அனைவரையும் அங்கே கூட்டவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","பின் லேவியரைக் கர்த்தருக்கு முன்னால் அழைத்து வாருங்கள். இஸ்ரவேல் ஜனங்கள் அவர்கள்மீது தம் கைகளை வைக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","பிறகு ஆரோன் லேவியர்களைக் கர்த்தருக்கு அர்ப்பணிக்க வேண்டும். அவர்கள் தேவனுக்கு அளிக்கப்படும் காணிக்கையைப் போன்று இருப்பார்கள். இம்முறையில் லேவியர்கள் கர்த்தருக்குத் தாங்கள் செய்ய வேண்டிய சிறப்பு வேலைகளுக்காகத் தயாராயிருப்பார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“தங்கள் கைகளை காளைகளின் தலை மீது வைக்குமாறு லேவியர்களுக்குக் கூறுங்கள். ஒரு காளை, கர்த்தருக்குரிய பாவப்பரிகார பலியாகும். இன்னொரு காளை, கர்த்தருக்குரிய தகன பலியாகும். இப்பலிகளினால் லேவியர்கள் சுத்தம் செய்யப்படுகின்றனர். ");
INSERT INTO tam2008_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","ஆரோன் மற்றும் அவனது மகன்களின் முன்னிலையில் நிற்குமாறு லேவியர்களிடம் கூறு. பிறகு லேவியர்களை கர்த்தருக்கு அர்ப்பணித்துவிடு அவர்கள் அசை வாட்டும் பலியைப் போன்றவர்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","இது லேவியர்களைப் பரிசுத்தமாக்கும். அவர்கள் தேவனுக்காக ஒரு சிறப்பான முறையில் பயன்படுத்தப்படுகிறார்கள் என்பதைக் காட்டும். இவர்கள் மற்ற இஸ்ரவேல் ஜனங்களிடமிருந்து வேறுபட்டவர்கள். லேவியர்கள் எனக்குரியவர்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“எனவே லேவியர்களை சுத்தமாக்குங்கள். அவர்களைக் கர்த்தருக்குக் கொடுங்கள். அவர்கள் அசைவாட்டும் பலியைப் போன்றவர்கள். நீங்கள் இவ்வாறு செய்த பிறகு அவர்கள் ஆசரிப்புக் கூடாரத்திற்குள் வந்து தம் பணியைச் செய்யலாம். ");
INSERT INTO tam2008_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","இஸ்ரவேலர்கள் லேவியர்களை எனக்குக் கொடுப்பார்கள். அவர்கள் எனக்கு உரியவர்கள். ஒவ்வொரு இஸ்ரவேல் குடும்பமும் தனக்கு முதலில் பிறக்கும் ஆண் குழந்தைகளை எனக்குத் தர வேண்டும் என்று கடந்த காலத்தில் கூறியிருக்கிறேன். இஸ்ரவேல் ஜனங்களில் முதலில் பிறக்கும் குழந்தைகளுக்குப் பதிலாக லேவியர்களை நான் இப்போது எடுத்துக் கொண்டேன். ");
INSERT INTO tam2008_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","இஸ்ரவேலர்களில் முதலில் பிறக்கும் ஆண் குழந்தைகள் ஒவ்வொன்றும் எனக்குரியதாகும். அது மனிதர்களா, அல்லது மிருகங்களா என்பது ஒரு பொருட்டல்ல. அவை எனக்குரியதாகும். ஏனென்றால் நான் எகிப்திலே, முதலில் பிறக்கும் ஆண் குழந்தைகளையும் மிருகங்களையும் கொன்றேன். அதோடு இஸ்ரவேலில் முதலில் பிறக்கும் ஆண் குழந்தைகளை எனக்குரியவர்களாகத் தேர்ந்தெடுத்துக்கொண்டேன். ");
INSERT INTO tam2008_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","ஆனால் இப்போது இவர்களின் இடத்தில் லேவியர்களை எடுத்துக்கொண்டேன். இஸ்ரவேலில் உள்ள மற்ற குடும்பங்களில் முதலாவதாகப் பிறந்த ஆண் மகன்களுக்குப் பதிலாக லேவியர்களை எடுத்துக்கொண்டேன். ");
INSERT INTO tam2008_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","இஸ்ரவேலில் உள்ள அனைத்து ஜனங்களிலிருந்தும் லேவியர்களைத் தேர்ந்தெடுத்தேன். அவர்களை ஆரோனுக்கும், அவனது மகன்களுக்கும் தத்தமாகக் கொடுத்தேன். அவர்கள் ஆசரிப்புக் கூடாரத்தில் பணியாற்ற வேண்டும் என்று விரும்புகிறேன். அவர்கள் இஸ்ரவேல் ஜனங்கள் அனைவருக்காவும் சேவை செய்வார்கள். இஸ்ரவேல் ஜனங்களை சுத்தப்படுத்தும் பலிகளைச் செலுத்த உதவி செய்வார்கள். இதனால் பெருநோய்களும், துன்பங்களும் இஸ்ரவேலர்கள் பரிசுத்தமான இடத்திற்குள் வரும்போது ஏற்படுவதில்லை” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","எனவே மோசே, ஆரோன், இஸ்ரேவேல் ஜனங்கள் அனைவரும் கர்த்தருக்குக் கீழ்ப்படிந்தனர். கர்த்தர் மோசேக்குக் கட்டளையிட்டபடி அவர்கள் லேவியரோடு சேர்ந்து செயல்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","லேவியர்கள் தங்களையும், தங்கள் ஆடைகளையும் சுத்தப்படுத்திண்டனர். ஆரோன் லேவியர்களை அசைவாட்டும் பலிபோன்று கர்த்தருக்கு அர்ப்பணித்தான். ஆரோன் பலிகளைக் கொடுத்ததின் மூலம் அவர்களின் பாவங்கள் நீக்கப்பட்டு, அவர்கள் பரிசுத்தம் அடைந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","அதன் பிறகு லேவியர்கள் ஆசரிப்புக் கூடாரத்திற்குள் தங்கள் பணியைச் செய்ய வந்தனர். ஆரோனும் அவனது மகன்களும் அவர்களைக் கண்காணித்தனர். லேவியர்களின் பணிகளுக்கு இவர்களே பொறுப்பானவர்கள். மோசேயிடம் கர்த்தர் சொன்னபடியே ஆரோனும் அவனது மகன்களும் செயல்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","மேலும் கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“இது லேவியர்களுக்கான சிறப்புக் கட்டளைகள் ஆகும். ஆசரிப்புக் கூடாரத்திலுள்ள வேலைகளை லேவியர்களில் 25 வயதும் அதற்கு மேற்பட்ட வயதும் கொண்டவர்கள் வந்து பங்கிட்டுச் செய்ய வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ஆனால், ஒருவனுக்கு 50 வயதாகும்போது அவன் தன் பணியிலிருந்து ஓய்வுபெற வேண்டும். அவன் மேலும் வேலை செய்ய வேண்டிய தேவை இல்லை. ");
INSERT INTO tam2008_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","இப்படிப்பட்ட 50 வயதும் அதற்கு மேலும் ஆன ஆண்கள் ஆசரிப்புக் கூடாரத்தில் தங்கள் சகோதரர்களின் வேலைக்கு உதவியாக இருக்கலாம். ஆனால், அவர்கள் அவ்வேலைகளைத் தாமாகவே செய்யக் கூடாது. நீங்கள் லேவியர்களை அவர்களின் வேலைக்குத் தேர்ந்தெடுக்கும்போது இவற்றைச் செய்யவேண்டும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","சீனாய் பாலைவனத்தில் மோசேயிடம் கர்த்தர் பேசினார். இது இஸ்ரவேல் ஜனங்கள் எகிப்தை விட்டு வந்த இரண்டாவது ஆண்டின் முதல் மாதமாகும். கர்த்தர் மோசேயிடம்: ");
INSERT INTO tam2008_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“தேர்ந்தெடுக்கப்பட்ட காலத்தில், பஸ்கா பண்டிகையைக் கொண்டாட வேண்டும் என்று இஸ்ரவேல் ஜனங்களிடம் கூறு. ");
INSERT INTO tam2008_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","அவர்கள் பஸ்கா விருந்தை இம்மாதத்தின் 14ஆம் நாளன்று சூரியன் மறைகிற அந்தி வேளையில் உண்ண வேண்டும். அவர்கள் அந்தத் தேர்ந்தெடுத்த நேரத்தில் இதனைச் செய்ய வேண்டும். பஸ்கா பண்டிகையின் விதிகளை அவர்கள் பின்பற்ற வேண்டும்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","எனவே, பஸ்காவைக் கொண்டாடும்படி இஸ்ரவேல் ஜனங்களிடம் மோசே கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","அவர்கள் சீனாய் பாலைவனத்தில், முதல் மாதத்தின் 14ஆம் நாளன்று, சூரியன் மறைகின்ற சாயங்கால வேளையில் பஸ்காவைக் கொண்டாடினர். கர்த்தர் மோசேக்குக் கட்டளையிட்டபடியே, இஸ்ரவேல் ஜனங்கள் எல்லாவற்றையும் செய்து முடித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","ஆனால் அந்நாளில் சில ஜனங்கள் பஸ்காவைக் கொண்டாட முடியவில்லை. காரணம், அவர்கள் பிணத்தைத் தொட்டதால் தீட்டாகி இருந்தனர். எனவே, அன்று அவர்கள் மோசேயிடமும், ஆரோனிடமும் சென்றனர். ");
INSERT INTO tam2008_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","அவர்கள் மோசேயிடம், “நாங்கள் பிணத்தைத் தொட்டதால் தீட்டாகிவிட்டோம். எனவே தேர்ந்தெடுக்கப்பட்ட நேரத்தில் நாங்கள் கர்த்தருக்கு அன்பளிப்பைச் செலுத்த முடியாமல் ஆசாரியர்களால் தடுக்கப்பட்டோம். எனவே, எங்களால் மற்ற இஸ்ரவேலர்களோடு பஸ்காவைக் கொண்டாட முடியவில்லை. நாங்கள் என்ன செய்யலாம்?” என்று கேட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","மோசே அவர்களிடம், “கர்த்தர் இதனைப் பற்றி என்ன சொல்கிறார் என்று கேட்கிறேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","பிறகு கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“எல்லா இஸ்ரவேல் ஜனங்களிடமும் இவற்றைக் கூறு. இந்த விதியானது உனக்கும் உனது எல்லாச் சந்ததிக்கும் உரியதாகும். சரியான நேரத்தில் ஒருவனால் பஸ்காவைக் கொண்டாட முடியாமல் போகலாம். அவன் பிணத்தைத் தொட்டதால் தீட்டுள்ளவனாக இருக்கலாம், அல்லது அவன் பயணத்தின் பொருட்டு வெளியே போயிருக்கலாம். ");
INSERT INTO tam2008_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ஆனாலும் அவன் இரண்டாவது மாதத்தில் 14ஆம் தேதி மாலை வேளையில் பஸ்காவைக் கொண்டாடலாம். அப்போது அவன் ஆட்டுக்குட்டியின் இறைச்சியையும், புளிப்பில்லாத அப்பத்தையும், கசப்பான கீரையையும் உண்ண வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","அவன் மறுநாள் விடியும்வரை அதில் எதையும் மீதி வைக்காமல் உண்ண வேண்டும். அவன் ஆட்டுக்குட்டியின் எலும்புகள் எதையும் உடைக்கக் கூடாது. அவன் பஸ்காவின் அனைத்து விதிகளையும் பின்பற்ற வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","ஆனால் இயன்றவர்கள் குறிப்பிட்ட காலத்திலேயே பஸ்காவைக் கொண்டாட வேண்டும். ஆனால் அவன் தீட்டில்லாமல் இருந்து, பயணம் போகாமல் இருந்தால் அவனுக்கு மன்னிப்பு இல்லை. அவன் சரியான காலத்தில் பஸ்காவைக் கொண்டாடாவிட்டால், அவன் மற்ற ஜனங்களிடமிருந்து பிரிக்கப்படவேண்டும். அவன் குற்றவாளியாகி அதனால் தண்டிக்கப்படுவான். ஏனென்றால் அவன் சரியான நேரத்தில் தன் அன்பளிப்பைக் கர்த்தருக்குச் செலுத்தவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“உங்களோடு வாழ்கின்ற அயல் நாட்டுக்காரன், கர்த்தரின் பஸ்காப் பண்டிகையை பகிர்ந்துகொள்ள விரும்பலாம், இதனை அனுமதிக்கலாம். ஆனால், அவன் பஸ்காவின் விதிகளைப் பின்பற்ற வேண்டும். அவ்விதிகள் அனைவருக்கும் ஒரே மாதிரிதான்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","பரிசுத்தக் கூடாரத்தையும், உடன்படிக்கையின் கூடாரத்தையும் அமைத்த அன்று, கர்த்தரின் மேகமானது அதை மூடிற்று. மாலை முதல் காலைவரை பரிசுத்தக் கூடாரத்திற்கு மேலுள்ள மேகமானது நெருப்பு போல் காணப்பட்டது. ");
INSERT INTO tam2008_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","அம்மேகம் பரிசுத்தக் கூடாரத்தின் மேல் எப்போதும் இருந்தது. இரவு நேரத்தில் அது நெருப்புபோல தோன்றியது. ");
INSERT INTO tam2008_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","மேகமானது பரிசுத்தக் கூடாரத்தை விட்டு நகர்ந்தபோது, இஸ்ரவேலரும் கூடவே சென்றனர். அம்மேகம் நின்ற இடத்தில் அவர்கள் தங்கள் முகாமை அமைத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","இவ்வாறு எப்போது புறப்பட வேண்டும், எப்போது நிற்க வேண்டும், முகாமை எங்கே அமைக்க வேண்டும் என்பதையெல்லாம் இஸ்ரவேலர்களுக்குக் கர்த்தர் சுட்டிக் காட்டினார். அங்கே மேகம் நிலைத்திருக்கும்வரை அவர்கள் அங்கேயே தங்கள் முகாமை அமைத்திருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","சில வேளைகளில் அம்மேகமானது நீண்ட காலம் பரிசுத்தக் கூடாரத்தின் மேல் தங்கியிருக்கும். கர்த்தரின் கட்டளைக்குப் பணிந்து இஸ்ரவேலர்கள் அதை விட்டு நகராமல் இருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","சில வேளைகளில், மேகமானது பரிசுத்தக் கூடாரத்தின்மேல் சில நாட்களே தங்கியிருக்கும். எனவே, அவர்கள் கர்த்தரின் கட்டளைக்கு அடிபணிந்து, அது நகரும்போது அவர்களும் நகர்ந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","சில வேளைகளில் மேகமானது இரவு மட்டுமே தங்கியிருக்கும். மறுநாள் காலையில் அது நகர்ந்துவிடும். அப்போது அவர்களும் தங்கள் பொருட்களை கட்டிக்கொண்டு பின்பற்றிச் செல்வார்கள். மேகமானது பகலில் நகர்ந்தாலும், அல்லது இரவில் நகர்ந்தாலும் இஸ்ரவேல் ஜனங்கள் அதைப் பின்பற்றிச் சென்றனர். ");
INSERT INTO tam2008_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","அந்த மேகம் பரிசுத்தக் கூடாரத்தின் மேல் இரண்டு நாட்களோ, ஒரு மாதமோ, ஒரு ஆண்டோ இருந்தால் அவர்களும் அங்கே தங்கியிருப்பார்கள். கர்த்தரின் ஆணைப்படி மேகம் நகரும்வரை அவர்களும் நகரமாட்டார்கள். எப்போது மேகம் எழும்பி நகருகிறதோ அப்போது அவர்களும் நகருவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","எனவே, ஜனங்கள் இவ்வாறு கர்த்தருடைய கட்டளைக்குக் கீழ்ப்படிந்தனர். கர்த்தரின் ஆணைப்படி முகாமை அமைத்தனர். கர்த்தர் சொல்லும்போது முகாமை கலைத்து விட்டுப் புறப்பட்டனர். ஜனங்கள் மிக எச்சரிக்கையாகக் கவனித்து மோசேக்குக் கர்த்தர் கட்டளையிட்டபடி கீழ்ப்படிந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“வெள்ளியைப் பயன்படுத்தி அடிப்பு வேலையினால் இரண்டு எக்காளங்களை செய்துகொள்ளுங்கள். இந்த எக்காளங்கள் ஜனங்களை கூப்பிட்டு எப்போது நகர வேண்டும் என்பதை அறிவிப்பதற்காகப் பயன்படும். ");
INSERT INTO tam2008_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","இரண்டு எக்காளங்களையும் தொடர்ச்சியாக பெருந்தொனியாக ஊதினால் இஸ்ரவேல் ஜனங்கள் ஆசரிப்புக் கூடாரத்தின் வாசலில் கூட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","ஆனால் ஒரே ஒரு எக்காளத்தை மட்டும் பெருந்தொனியாகத் தொடர்ந்து ஊதினால், தலைவர்கள் மட்டும், உன்னைச் சந்திக்க கூடிவர வேண்டும். (தலைவர்கள் என்பது 12 இஸ்ரவேல் கோத்திரங்களின் தலைவர்கள் ஆகும்.) ");
INSERT INTO tam2008_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","“எக்காளங்களை குறைந்த நேரம் ஊதினால், ஜனங்கள் தங்கும் இடங்களைக் கலைத்து விட்டுப் புறப்படவேண்டும் என்று அர்த்தமாகும். முதல்முறை குறைந்த நேரம் ஊதும்போது ஆசரிப்புக் கூடாரத்தின் கிழக்குப் பக்கத்தில் தங்கி இருக்கும் குடும்பங்கள் புறப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","இரண்டாவது முறை குறைந்த நேரம் ஊதினால், ஆசரிப்புக் கூடாரத்தின் தென் பக்கத்தில் பாளையமிட்ட குடும்பங்கள் நகர வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","ஆனால் நீ ஜனங்கள் அனைவரையும் கூட்ட வேண்டும் என்று விரும்பினால் எக்காளங்களை சற்று வித்தியாசமாக ஓயாமல் நெடுநேரம் ஊத வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","ஆரோனின் மகன்களான ஆசாரியர்கள் மாத்திரமே எக்காளங்களை ஊத வேண்டும். இதுவே என்றென்றும் வரும் தலைமுறைகளிலும் கடைப்பிடிக்க வேண்டிய சட்டமாகும். ");
INSERT INTO tam2008_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“நீங்கள் உங்கள் சொந்த பூமியில் பகைவர்களோடு சண்டையிட வேண்டி வந்தால் எக்காளத்தை மிகச் சத்தமாகப் போருக்கு முன் ஊதுங்கள். உங்கள் தேவனாகிய கர்த்தர் அதனைக் கேட்டு உங்கள் பகைவரிடமிருந்து உங்களைக் காப்பாற்றுவார். ");
INSERT INTO tam2008_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","உங்களது சிறப்புக் கூட்டங்களுக்கும், மாதப் பிறப்பு நாட்களிலும், மகிழ்ச்சிக் காலங்களிலும் எக்காளங்களை ஊதுங்கள். நீங்கள் தகன பலியும், சமாதான பலியும் கொடுக்கும்போதெல்லாம் எக்காளங்களை ஊதுங்கள். உங்கள் தேவனாகிய கர்த்தர் உங்களை நினைவுகூருவதற்கு இந்த எக்காளச் சத்தம் உதவும். இவ்வாறு செய்யுமாறு நான் கட்டளையிடுகிறேன், நானே உங்கள் தேவனாகிய கர்த்தர்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","இஸ்ரவேல் ஜனங்கள் எகிப்தை விட்டுப் புறப்பட்ட இரண்டாவது ஆண்டின் இரண்டாவது மாதத்தின் 20 ஆம் நாளில், உடன்படிக்கைக் கூடாரத்தின் மேல் இருந்த மேகமானது எழும்பிற்று. ");
INSERT INTO tam2008_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","எனவே, இஸ்ரவேல் ஜனங்கள் தங்கள் பயணத்தைத் தொடர்ந்தனர். அவர்கள் சீனாய் பாலைவனத்தைக் கடந்து பாரான் பாலைவனத்தில் நிற்கும்வரை பயணம் செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","இதுவே இஸ்ரவேல் ஜனங்கள் தம் முகாமை கலைத்துவிட்டு, முதல் முதலாக புறப்பட்ட சம்பவம் ஆகும். மோசேயிடம் கர்த்தர் ஆணையிட்டபடியே அவர்கள் நகர்ந்து சென்றனர். ");
INSERT INTO tam2008_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","யூதாவின் முகாமில் உள்ள மூன்று குழுக்களும் முதலில் சென்றன. அவர்கள் தங்கள் கொடியோடு பயணம் செய்தனர். முதல் குழுவானது யூதாவின் கோத்திரமாகும். அம்மினதாபின் மகனான நகசோன் அக்குழுவின் தலைவனாக இருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","அடுத்து இசக்காரின் கோத்திரம் வந்தது. சூவாரின் மகனான நெதனெயேல் இதற்குத் தலைவனாக இருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","அதற்கு அடுத்து செபுலோனின் கோத்திரம் வந்தது. ஏலோனின் மகனான எலியாசாப் அதற்குத் தலைவனாக இருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","பிறகு, பரிசுத்தக் கூடாரம் இறக்கி வைக்கப்பட்டது.பரிசுத்தக் கூடாரத்தைக் கெர்சோன் மற்றும் மெராரி குடும்பத்தில் உள்ளவர்கள் சுமந்துகொண்டு வந்தனர். எனவே, இக்குடும்பத்தவர்கள் இவ்வரிசையில் அடுத்ததாக வந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","பிறகு ரூபனின் முகாமைச் சேர்ந்த மூன்று குழுக்களும் வந்தன, அவர்கள் தம் கொடியோடு பயணம் செய்தனர். முதலில் ரூபனின் கோத்திரம் வந்தது. சேதேயூரின் மகன் எலிசூர் இதற்குத் தலைவனாக இருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","அடுத்து சிமியோனின் கோத்திரம் வந்தது. சூரிஷதாயின் மகனான செலூமியேல் இதற்குத் தலைவனாயிருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","அதற்கு அடுத்து காத் கோத்திரம் வந்தது, தேகுவேலின் மகனான எலியாசாப் அதற்குத் தலைவனாக இருந்தான், ");
INSERT INTO tam2008_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","பிறகு கோகாத்தியர் குடும்பத்தைச் சேர்ந்தவர்கள் பரிசுத்த இடத்தில் இருக்கும் பரிசுத்தப் பொருட்களைச் சுமந்துவந்தனர். இவர்கள் வந்து சேருமுன் மற்றவர்கள் பரிசுத்த கூடாரத்தை அமைத்து முடிப்பார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","அதற்குப் பிறகு எப்பிராயீம் கோத்திரத்தின் முகாமில் இருந்து மூன்று குழுக்கள் தங்கள் கொடிகளோடு பயணம் செய்தனர். முதலில் எப்பிராயீமின் கோத்திரம் வந்தது. அம்மியூதின் மகனான எலிஷாமா அதற்குத் தலைவனாக இருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","அடுத்து மனாசேயின் கோத்திரம் வந்தது. பெதாசூரின் மகனான கமாலியேல் அதற்குத் தலைவனாக இருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","அடுத்து பென்யமீன் கோத்திரம் வந்தது. கீதெயோனின் மகனான அபீதான் அதற்குத் தலைவனாக இருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","இவ்வரிசையில் உள்ள கடைசி மூன்று கோத்திரங்களும் மற்றக் கோத்திரங்களுக்குப் பாதுகாவலாக இருந்தது. அது தாண் கோத்திரத்தின் பிரிவுகள் ஆகும். அவர்கள் தங்கள் கொடியோடு பயணம் செய்தனர். முதலில் தாணின் கோத்திரம் வந்தது. அம்மிஷதாயின் மகனான அகியேசேர் அதற்குத் தலைவனாக இருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","அடுத்து ஆசேர் கோத்திரம் வந்தது. ஓகிரானின் மகனான பாகியேல் அதற்குத் தலைவனாக இருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","நப்தலியின் கோத்திரம் அதற்கு அடுத்து வந்தது. ஏனானின் மகனான அகிரா அதற்குத் தலைவனாக இருந்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","இவ்வாறுதான் இஸ்ரவேல் ஜனங்கள் ஓரிடத்தை விட்டு இன்னொரு இடத்துக்குப் போகும்போது வரிசை முறையைக் கைக்கொண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","ஓபாப், மீதியானியனான ரெகுவேலின் மகன். (ரெகுவேல் மோசேயின் மாமனார்.) மோசே ஓபாபிடம், “தேவன் எங்களுக்கு தருவதாக வாக்களித்துள்ள நாட்டிற்கு நாங்கள் போய்ண்டிருக்கிறோம். எங்களோடு வாரும், உமக்கு நாங்கள் நல்லவர்களாக இருப்போம். இஸ்ரவேல் ஜனங்களுக்கு கர்த்தர் நன்மை செய்வதாக வாக்களித்துள்ளார்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","ஆனால் ஓபாப், “இல்லை நான் உங்களோடு வரமாட்டேன். நான் எனது தாய் நாட்டிற்குத் திரும்பிப் போகிறேன். அங்கே என் சொந்த ஜனங்கள் இருக்கின்றனர்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","பிறகு மோசே, “தயவுசெய்து எங்களைவிட்டுப் போகாதிரும், எங்களைவிட இந்தப் பாலைவனத்தைப்பற்றி உமக்கு நன்றாகத் தெரியும். நீர் எங்களுக்கு வழிகாட்டியாக இரும். ");
INSERT INTO tam2008_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","நீர் எங்களோடு வந்தால், கர்த்தர் எங்களுக்கு அளிக்கும் நன்மையை உம்மோடு பகிர்ந்துகொள்வோம்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","எனவே, ஓபாப் ஒப்புக்கொண்டான். பிறகு அவர்கள் கர்த்தரின் மலையிலிருந்து பயணம் செய்தனர். ஆசாரியர்கள் கர்த்தருடைய உடன்படிக்கைப் பெட்டியைத் தூக்கிக்கொண்டு முன்னே சென்றார்கள். மூன்று நாட்கள் அவர்கள் பரிசுத்தப் பெட்டியைச் சுமந்து பயணம் செய்து முகாம் அமைப்பதற்காக இடம் பார்த்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","கர்த்தரின் மேகமானது தினமும் அவர்களுக்கு மேல் சென்றது. ஒவ்வொரு நாள் காலையிலும் அது வழிகாட்டிய வண்ணம் சென்றது. ");
INSERT INTO tam2008_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","ஜனங்கள் பரிசுத்தப் பெட்டியைத் தூக்கிக்கொண்டு நகரும்போதெல்லாம் மோசே: “கர்த்தாவே எழுந்திரும்! உமது பகைவர்கள் சிதறடிக்கப்படட்டும். உமது பகைவர்கள் உம்மைவிட்டு ஓடட்டும்” என்று சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","பரிசுத்தப் பெட்டியை அவர்கள் கீழே வைக்கும்போதெல்லாம் மோசே எப்பொழுதும், “கர்த்தாவே, அநேக ஆயிரங்களான இஸ்ரவேல் ஜனங்களிடம் திரும்பி வாரும்” என்று சொன்னான். ");
INSERT INTO tam2008_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","ஜனங்கள் தங்கள் துன்பங்களைப்பற்றி முறுமுறுக்க ஆரம்பித்தனர். கர்த்தர் அவர்களது முறுமுறுப்புகளைக் கேட்டு அதனால் கோபம் கொண்டார். கர்த்தரிடமிருந்து நெருப்பு தோன்றி, முகாமின் ஓரங்களில் உள்ள சில ஜனங்களை எரித்தது. ");
INSERT INTO tam2008_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","எனவே ஜனங்கள் மோசேயிடம் தம் மக்களைக் காப்பாற்றுமாறு கதறினார்கள். மோசே கர்த்தரிடம் வேண்டுதல் செய்ததினால் நெருப்பு அணைந்து போயிற்று. ");
INSERT INTO tam2008_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","எனவே அந்த இடம் தபேரா என்று அழைக்கப்பட்டது. கர்த்தர் நெருப்பின் மூலம் அவர்கள் முகாமை எரித்ததால் இந்தப் பெயர் அந்த இடத்திற்கு ஏற்பட்டது. ");
INSERT INTO tam2008_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","இஸ்ரவேல் ஜனங்களோடு சேர்ந்த அயல் நாட்டுக்காரர்கள் மற்றப் பொருட்களை உண்ண ஆசைப்பட்டார்கள். எனவே, இஸ்ரவேல் ஜனங்கள் மீண்டும் முறையிட ஆரம்பித்தனர். அந்த ஜனங்கள், “நாங்கள் இறைச்சியை உண்ண ஆசைப்படுகிறோம்! ");
INSERT INTO tam2008_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","நாங்கள் எகிப்தில் உண்ட மீன்களை எண்ணிப் பார்க்கிறோம். அவை எங்களுக்கு விலையில்லாதது. அங்கு எங்களுக்கு வெள்ளரிக்காய், கொம்மட்டிக்காய், கீரை, வெங்காயம், வெள்ளைப்பூண்டு போன்ற நல்ல காய்கறிகளும் இருந்தன. ");
INSERT INTO tam2008_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","ஆனால் இப்போது நாங்கள், எங்கள் பலத்தை இழந்துவிட்டோம். இந்த மன்னாவை மட்டுமே உண்கிறோம், வேறு எதையும் புசிப்பதில்லை” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","(இந்த மன்னா சிறிய கொத்தமல்லி விதை போன்று அளவிலும் மரப்பிசின் போன்று தோற்றத்திலும் இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","ஜனங்கள் இந்த மன்னாவைப் பொறுக்கிக்கொண்டு வந்து அதனைக் கல்லால் அரைத்து பானையில் போட்டு சமைப்பார்கள். அல்லது அதனை எந்திரங்களில் அரைத்து மாவாக்கி அப்பங்களாகச் செய்வார்கள். இந்த அப்பங்கள் ஒலிவ எண்ணெயால் செய்யப்பட்ட இனிப்பு அப்பங்களைப்போல சுவையாக இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","பூமி பனியால் நனைந்திருக்கும்போது ஒவ்வொரு இரவும் இந்த மன்னா தரையில் விழும்.) ");
INSERT INTO tam2008_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","மோசே ஜனங்களின் முறையீட்டைக் கேட்டான். ஒவ்வொரு குடும்பத்தில் உள்ளவர்களும் தங்கள் தங்கள் கூடார வாசலில் இருந்துகொண்டு முறையிட்டார்கள். இதனால், கர்த்தர் பெருங்கோபம் கொண்டார். மோசேயும் இதனால் சஞ்சலப்பட்டான். ");
INSERT INTO tam2008_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","மோசே கர்த்தரிடம், “கர்த்தாவே, ஏன் எனக்கு இந்தத் தொல்லையைத் தந்தீர்? நான் உமது ஊழியன். நான் என்ன தவறு செய்தேன்? நான் உமக்கு என்ன பொல்லாப்பு செய்தேன்? இவ்வளவு மிகுதியான ஜனங்களுக்கான பொறுப்பினை ஏன் எனக்குக் கொடுத்தீர்? ");
INSERT INTO tam2008_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","நான் இவர்களின் தந்தை அல்ல என்பதையும், நான் இவர்களைப் பெற்றெடுக்கவில்லை என்பதையும் நீர் அறிவீர். ஆனால் ஒரு தாதி ஒரு குழந்தையைக் கைகளில் தாங்கிச் செல்வது போன்று நான் தாங்கிச் செல்ல வேண்டியதாயிருக்கிறது. ஏன் இதனை என்மேல் சுமத்தினீர்? என் முன்னோருக்குத் தருவதாகச் சொன்ன தேசத்திற்கு இவர்களை அழைத்துப் போகும் பொறுப்பை என்மேல் ஏன் சுமத்தினீர்? ");
INSERT INTO tam2008_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","இவர்கள் அனைவருக்கும் தேவையான இறைச்சி என்னிடம் இல்லை. அவர்கள் தொடர்ந்து முறையிட்டுக்கொண்டு ‘எங்களுக்கு இறைச்சியைத் தாரும்’ என்று கேட்கிறார்கள்! ");
INSERT INTO tam2008_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","நான் ஒருவனாக இவர்கள் அத்தனை பேரையும் கவனித்துக்கொள்ளமுடியாது. இந்தச் சுமை எனக்கு மிகவும் அதிகமாக உள்ளது. ");
INSERT INTO tam2008_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","இதுபோல் தொடர்ந்து நீர் எனக்கு அவர்களின் தொல்லைகளைக் கொடுப்பதாக இருந்தால், இப்போது என்னைக் கொன்றுவிடும். உமது ஊழியனாக என்னை ஏற்றுக்கொண்டால், இப்போது எனக்கு மரணத்தைத் தாரும். நான், என் தொல்லைகளிலிருந்து விடுதலை பெறுவேன்” என்றான்! ");
INSERT INTO tam2008_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","கர்த்தர் மோசேயிடம், “இஸ்ரவேல் ஜனங்களில் 70 முதிய தலைவர்களை என்னிடம் அழைத்து வா. இவர்கள் இஸ்ரவேலர்களின் தலைவர்களாயிருக்கிறார்கள். அவர்களை ஆசரிப்புக் கூடாரத்திற்குள் அழைத்து வா. அவர்கள் உன்னோடு நிற்கட்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","பிறகு நான் இறங்கி வந்து உன்னோடு பேசுவேன். இப்போது ஆவியானவர் உன்மேல் உள்ளார். ஆனால் அவர்களுக்கும் ஆவியை அளிப்பேன். பிறகு இந்த ஜனங்களைக் கவனித்துக்கொள்கிற பொறுப்பில் அவர்கள் உனக்கு உதவுவார்கள். இவ்வகையில் நீ மட்டும் தனியாக இவர்களுக்கான பொறுப்பை ஏற்க வேண்டியதிருக்காது.” ");
INSERT INTO tam2008_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“இவற்றை ஜனங்களிடம் கூறு: நாளைக்காக உன்னைத் தயார் செய்துகொள்! நாளை நீங்கள் இறைச்சி உண்பீர்கள். நீங்கள் முறையிட்டபோது கர்த்தர் அதனைக் கேட்டார். ‘எங்களுக்கு உண்ண இறைச்சி வேண்டும், எகிப்து எங்களுக்கு நன்றாக இருந்தது!’ என்று நீங்கள் சொன்ன சொற்களைக் கர்த்தர் கேட்டார். எனவே, இப்போது கர்த்தர் உங்களுக்கு இறைச்சியைக் கொடுப்பார். ");
INSERT INTO tam2008_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","நீங்கள் ஒரு நாள் அல்லது, இரு நாள் அல்லது, ஐந்து நாள் அல்லது, பத்து நாள் அல்லது, இருபது நாட்களுக்கு மேலாக இறைச்சியை உண்பீர்கள்! ");
INSERT INTO tam2008_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","நீங்கள் இந்த மாதம் முழுவதும்கூட இறைச்சியை உண்பீர்கள். அது உங்களுக்குத் திகட்டும்வரைக்கும் உண்பீர்கள். நீங்கள் கர்த்தருக்கு எதிராக முறையிட்டதினால் இது உங்களுக்கு ஏற்படும். கர்த்தர் உங்களோடு வாழ்கிறார். உங்களது தேவைகளை அவர் அறிவார். ஆனால் நீங்கள் அழுதீர்கள்! அவரிடம் முறையிட்டீர்கள். நாங்கள் எகிப்தை விட்டு ஏன் வந்தோம்? என்று கூறுகிறீர்கள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","மோசே, “கர்த்தாவே இங்கே 6,00,000 மனிதர்கள் உள்ளனர். ஆனால் நீர் ‘இவர்கள் ஒரு மாதத்திற்குப் போதுமானபடி உண்ண இறைச்சியைக் கொடுப்பேன்’ என்று கூறுகிறீர். ");
INSERT INTO tam2008_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","நாம் இங்குள்ள அத்தனை ஆடுகளையும், மாடுகளையும் கொன்றாலும் கூட அது போதுமானதாக இராது. கடலில் உள்ள அத்தனை மீன்களையும் பிடித்தாலும்கூட அவை போதுமானதாக இராது” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","ஆனால் கர்த்தர் மோசேயிடம், “கர்த்தருடைய வல்லமையைக் குறைவாக எடை போடாதே! நான் சொன்னபடி என்னால் செய்யமுடியுமா? என்பதை இப்போது காண்பாய்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","எனவே, ஜனங்களோடு பேச மோசே வெளியே சென்றான். கர்த்தர் சொன்னவற்றையெல்லாம் மோசே ஜனங்களிடம் கூறினான். பின் 70 முதிய இஸ்ரவேல் தலைவர்களைக் கூட்டி அழைத்து வந்தான். ஆசரிப்புக் கூடாரத்தைச் சுற்றி நிற்குமாறு அவர்களிடம் கூறினான். ");
INSERT INTO tam2008_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","பிறகு கர்த்தர் மேகத்தில் இறங்கி வந்து மோசேயோடு பேசினார். மோசேயின் மேல் ஆவியானவர் இருந்தார். அதே ஆவியை 70 முதிய தலைவர்கள் மேலும் கர்த்தர் வைத்தார். அவர்கள்மேல் ஆவி வந்ததும் தீர்க்கதரிசனம் சொன்னார்கள். ஆனால் அவர்கள் அந்த நேரத்தில் மட்டுமே அவ்வாறு நடந்துகொண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","அப்போது எல்தாத், மேதாத் எனும் இரு முதிய தலைவர்கள் மட்டும் கூடாரத்திற்கு வெளியே போகவில்லை. அவர்களின் பெயர் முதிய தலைவர்களின் பட்டியலில் இருந்தது. எனினும் அவர்கள் கூடாரத்திற்குள்ளேயே இருந்துவிட்டனர். எனினும் அவர்கள் மீதும் ஆவி வந்தது. அவர்கள் கூடாரத்திற்குள்ளிருந்தே தீர்க்கதரிசனம் சொன்னார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","ஒரு இளைஞன் மோசேயிடம் ஓடிப்போய், “எல்தாத்தும், மேதாத்தும் கூடாரத்திற்குள் தீர்க்கதரிசனம் கூறுகிறார்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","நூனின் மகனாகிய யோசுவா மோசேயிடம், “மோசே ஐயா, நீங்கள் அவர்களைத் தடுக்கவேண்டும்” என்றான். (யோசுவா தன் சிறு வயதிலிருந்தே மோசேயிடம் உதவியாளனாக இருந்தான்.) ");
INSERT INTO tam2008_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","ஆனால் மோசே, “நான் இப்போது தலைவன் இல்லை என்று ஜனங்கள் நினைத்துவிடுவார்கள் என்று அஞ்சுகிறாயா? கர்த்தரின் ஜனங்கள் அனைவரும் தீர்க்கதரிசனம் சொல்லவேண்டும் என்று நான் விரும்புகிறேன்! அவர்கள் அனைவர் மேலும் கர்த்தர் தன் பரிசுத்த ஆவியை வைக்க வேண்டும் என்று விரும்புகிறேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","பிறகு மோசேயும் இஸ்ரவேல் தலைவர்களும் கூடாரத்திற்குள் சென்றனர். ");
INSERT INTO tam2008_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","பிறகு கடலிலிருந்து பெருங்காற்று அடிக்குமாறு கர்த்தர் செய்தார். அக்காற்று காடைகளைக் கொண்டு வந்தது. காடைகள் கூடாரத்தைச் சுற்றிலும் பறந்து வந்து தரையில் விழுந்தன. தரையின் மேல் மூன்றடி உயரத்திற்கு அவை விழுந்துகிடந்தன. ஒரு மனிதன் எல்லா திசைகளிலும் ஒரு நாள் முழுவதும் நடக்கும் தூரம்வரை அக்காடைகள் கிடந்தன. ");
INSERT INTO tam2008_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","ஜனங்கள் மகிழ்ச்சியோடு சென்றனர்! அவர்கள் இரவும் பகலுமாக அவற்றைச் சேகரித்தனர். ஒவ்வொருவரும் மறுநாளும் அவற்றைச் சேகரித்தனர். அவர்கள் குறைந்தபட்சம் 60 மரக்கால் அளவு சேர்த்தனர். அவற்றை வெயிலில் காயும்படி முகாம்களைச் சுற்றிலும் பரப்பி வைத்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","ஜனங்கள் அந்த இறைச்சியை உண்ண ஆரம்பித்தனர். ஆனால் கர்த்தரோ பெருங்கோபம் கொண்டார். அவர்கள் வாயில் இறைச்சி இருக்கும்போதே, அவற்றை அவர்கள் தின்று முடிக்கும் முன்னரே அவர்கள் நோயுறும்படி கர்த்தர் செய்தார். அதனால் பலர் மரித்துப்போனார்கள். அங்கேயே புதைக்கப்பட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","எனவே ஜனங்கள் அந்த இடத்திற்கு “கிப்ரோத் அத்தாவா” என்று பெயர் வைத்தனர். இறைச்சி மேல் அதிக ஆசை கொண்டு மரித்தவர்கள் புதைக்கப்பட்ட இடம் என்று இதற்கு பொருள். ");
INSERT INTO tam2008_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","கிப்ரோத் அத்தாவா என்ற இடத்திலிருந்து அவர்கள் பயணப்பட்டு ஆஸ்ரோத்துக்குப் போய் அங்கே தங்கினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","மிரியாமும், ஆரோனும் மோசேக்கு எதிராகப் பேச ஆரம்பித்தனர். அவன் ஒரு எத்தியோப்பிய பெண்ணை மணந்துகொண்டதால் அவனைப் பற்றி அவர்கள் அவதூறு பேசினார்கள். அவன் எத்தியோப்பிய பொண்னை மணந்துகொண்டது சரியல்ல என அவர்கள் எண்ணினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","அவர்கள் தமக்குள், “ஜனங்களோடு பேசுவதற்கு கர்த்தர் மோசே ஒருவனை மட்டும் பயன்படுத்தவில்லை. எங்கள் மூலமாகவும் கர்த்தர் பேசினார்” என்று கூறிக்கொண்டனர்! கர்த்தர் இதனைக் கேட்டார். ");
INSERT INTO tam2008_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(மோசே மிகவும் தாழ்மையான குணமுள்ளவன். அவன் தனக்குள் பெருமையுள்ளவன் அல்ல. பூமியிலுள்ள மற்ற மனிதர்களைவிட அவன் மிகவும் சாந்த குணமுள்ளவன்.) ");
INSERT INTO tam2008_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","எனவே கர்த்தர் மோசே, ஆரோன், மிரியாம் ஆகிய மூவருடனும் பேசி, “நீங்கள் மூவரும் இப்பொழுது ஆசரிப்புக் கூடாரத்திற்குள் வாருங்கள்” என்று சொன்னார். ");
INSERT INTO tam2008_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","உயரமான மேகத்திலிருந்து கர்த்தர் இறங்கி வந்து கூடாரத்தின் வாசலில் நின்று: “ஆரோன்! மிரியாம்!” என்று அழைத்தார். ஆரோனும் மிரியாமும் அவரிடம் சென்றனர். ");
INSERT INTO tam2008_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","தேவன், “நான் சொல்வதைக் கேளுங்கள். உங்களுக்குத் தீர்க்கதரிசிகள் இருக்கிறார்கள். கர்த்தராகிய நான் அவர்களுக்குக் காட்சியளிப்பேன். அவர்களோடு கனவில் பேசுவேன். ");
INSERT INTO tam2008_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","ஆனால் மோசே அத்தகையவன் அல்ல. மோசே எனது உண்மையான ஊழியன். நான் அவனை எனது வீட்டில் எல்லா விதத்திலும் நம்பிக்கையும், உண்மையுள்ளவனாகவும் காண்கிறேன். ");
INSERT INTO tam2008_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","நான் அவனோடு பேசும்போது, முகமுகமாய் பேசுகிறேன். மறைபொருளான கதைகளையல்ல, அவன் தெரிந்துகொள்ள வேண்டியவற்றை நான் தெளிவாகக் கூறிவிடுவேன். கர்த்தரின் தோற்றத்தையே மோசே பார்க்க இயலும். எனவே, ஏன் நீங்கள் எனது ஊழியனான மோசேக்கு எதிராகப் பேசத் துணிந்தீர்கள்?” என்று கேட்டார். ");
INSERT INTO tam2008_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","கர்த்தர் அவர்கள் மீது பெருங்கோபத்தோடு இருந்தபடியால் அவர்களைவிட்டு கர்த்தர் விலகினார். ");
INSERT INTO tam2008_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","மேகம் கூடாரத்திலிருந்து மேலே எழும்பிச் சென்றது. ஆரோன் திரும்பி மிரியாமைப் பார்த்தான். அவளது தோல் பனியைப் போன்று வெளுத்திருந்தது. அவளுக்குப் பயங்கரமான தொழுநோய் ஏற்பட்டது! ");
INSERT INTO tam2008_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","பிறகு ஆரோன் மோசேயிடம், “ஐயா, தயவு செய்து எங்களை மன்னித்து விடுங்கள். நாங்கள் முட்டாள்தனமாக பாவம் செய்துவிட்டோம். ");
INSERT INTO tam2008_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","மரித்துப் பிறந்த குழந்தையைப் போல அவள் தன் தோலை இழக்க விட்டுவிடாதிரும்” என்றான். (சில வேளையில் சில குழந்தைகள் பாதிதோல் அழுகிய நிலையில் மரித்துப் பிறப்பதுண்டு.) ");
INSERT INTO tam2008_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","எனவே மோசே கர்த்தரிடம் விண்ணப்பம் செய்து, “தேவனே தயவு செய்து இவளது தொழு நோயைப் போக்கிவிடும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","கர்த்தர் மோசேயை நோக்கி, “அவளது தந்தை அவள் முகத்தின் மீது உமிழ்ந்தால், அவளுக்கு ஏழு நாட்கள் அவமானமாக இருக்கும். எனவே, அவளை முகாமிற்கு வெளியே ஏழு நாட்கள் வைத்திரு. அதற்குப் பிறகு அவள் குணமாவாள். பின்னர் அவள் கூடாரத்திற்குத் திரும்பலாம்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","ஆகையால் அவர்கள் மிரியாமை ஏழு நாட்கள் முகாமிற்கு வெளியே வைத்திருந்தனர். அவளைத் திரும்பக் கூடாரத்திற்குள் அழைத்துக்கொள்ளும்வரை அவர்கள் அந்த இடத்தை விட்டு நகரவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","அதன்பின் அவர்கள் ஆஸ்ரோத்தை விட்டு பாரான் பாலைவனத்துக்குச் சென்று, அங்கே முகாமிட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“கானான் தேசத்தைக் கண்டு வருமாறு சிலரை அனுப்பு. இஸ்ரவேல் ஜனங்களுக்கு நான் கொடுக்கப்போகும் நாடு இதுதான். குடும்பத்திற்கு ஒரு தலைவன் என்கிற வீதம் 12 கோத்திரங்களில் இருந்தும் 12 தலைவர்களை அங்கு அனுப்பு” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","கர்த்தருடைய கட்டளைக்கு மோசே கீழ்ப்படிந்தான். ஜனங்கள் அனைவரும் பாரான் பாலைவனத்தில் தங்கியிருந்தபோது இந்தத் தலைவர்களை மோசே கானானுக்கு அனுப்பி வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","ரூபனின் கோத்திரத்திலிருந்து சக்கூரின் மகனான சம்முவா; ");
INSERT INTO tam2008_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","சிமியோனின் கோத்திரத்திலிருந்து ஓரியின் மகனான சாப்பாத்; ");
INSERT INTO tam2008_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","யூதாவின் கோத்திரத்திலிருந்து எப்புன்னேயின் மகனான காலேப்; ");
INSERT INTO tam2008_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","இசக்காரின் கோத்திரத்திலிருந்து யோசேப்பின் மகனான ஈகால்; ");
INSERT INTO tam2008_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","எப்பிராயீமின் கோத்திரத்திலிருந்து நூனின் மகனான ஓசேயா; ");
INSERT INTO tam2008_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","பென்யமீன் கோத்திரத்திலிருந்து ரப்பூவின் மகனான பல்த்தி; ");
INSERT INTO tam2008_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","செபுலோன் கோத்திரத்திலிருந்து சோதியின் மகனான காதியேல்; ");
INSERT INTO tam2008_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","யோசேப்பின் கோத்திரத்திலிருந்து (மனாசே) ஆசின் மகனான காதி; ");
INSERT INTO tam2008_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","தாண் கோத்திரத்திலிருந்து கெமல்லியின் மகனான அம்மியேல்; ");
INSERT INTO tam2008_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","ஆசேர் கோத்திரத்திலிருந்து மிகாவேலின் மகனான சேத்தூர்; ");
INSERT INTO tam2008_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","நப்தலி கோத்திரத்திலிருந்து ஒப்பேதியின் மகனான நாகபி; ");
INSERT INTO tam2008_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","காத் கோத்திரத்திலிருந்து மாகியின் மகனான கூவேல்; ");
INSERT INTO tam2008_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","நாட்டைப் போய் கண்டுபிடிக்கவும், அதைப் பற்றி அறியவும் மோசேயால் அனுப்பட்டவர்களின் பெயர்கள் இவைகளே ஆகும். (நூனின் மகனான ஓசேயாவுக்கு மோசே, யோசுவா என்று பெயர் வைத்திருந்தான்.) ");
INSERT INTO tam2008_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","மோசே அவர்களைக் கானான் தேசத்தைக் கண்டு வருமாறு அனுப்பும்போது அவர்களிடம், “நீங்கள் இந்தப் பாலைவனத்தின் தெற்குப் பகுதி வழியாகச் சென்று மலையில் ஏறவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","அந்த நாடு எவ்வாறு தோற்றம் அளிக்கிறது என்று பார்க்க வேண்டும், அங்கே வாழுகிற ஜனங்களைப் பற்றித் தெரிந்துக்கொள்ளுங்கள். அவர்கள் பலமானவர்களா, அல்லது பலவீனமானவர்களா? அவர்களின் எண்ணிக்கை குறைவா, மிகுதியா? ");
INSERT INTO tam2008_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","நாட்டைப் பற்றியும் அதில் வாழும் ஜனங்களைப் பற்றியும் தெரிந்துகொள்ளுங்கள், இது நல்ல நாடா கெட்ட நாடா? எந்த விதமான பட்டணங்களில் குடியிருக்கிறார்கள்? நகரங்களைப் பாதுகாக்க மதில் சுவர்கள் உள்ளனவா? நகரங்கள் பலமாகப் பாதுகாக்கப்பட்டுள்ளனவா? ");
INSERT INTO tam2008_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","நாட்டிலுள்ள மற்ற செய்திகளைப் பற்றியும் தெரிந்துக்கொள்ளுங்கள். அங்குள்ள மண் விவசாயம் செய்வதற்குரிய வளம் உள்ளதா, அல்லது சாரம் அற்றதா? இந்நாட்டில் மரங்கள் உள்ளனவா? அங்குள்ள பழவகைகளில் சிலவற்றைக் கொண்டு வர முயலுங்கள்” என்றான். (அது முதல் திராட்சைகள் பழுக்கும் காலமாய் இருந்தது.) ");
INSERT INTO tam2008_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","எனவே அவர்கள் நாட்டைப் பற்றித் தெரிந்துக்கொள்ளச் சென்றனர். பின் அவர்கள் சீன் பாலைவனம் முதல் ஆமாத்துக்குப் போகிற வழியாகிய ரேகொப்வரை சுற்றிப் பார்த்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","நெகேவ் வழியாக நாட்டிற்குள் நுழைந்தனர். தெற்கேயும் எபிரோன் வரை சென்றார்கள். (எபிரோன் எகிப்திலுள்ள சோவானுக்கு ஏழு ஆண்டுகளுக்கு முன் கட்டப்பட்டது.) அங்கே ஆனாக்கின் சந்ததியாகிய அகீமானும், சேசாயும் தல்மாயும் இருந்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","பிறகு அவர்கள் எஸ்கோல் பள்ளத்தாக்குவரை சென்றனர். அங்கே அவர்கள் திராட்சைக் கொடியில் ஒரு குலையை அறுத்துக்கொண்டனர். அதனை ஒரு கம்பிலே கட்டி, இரண்டு பேர் தூக்கிக்கொண்டு வந்தனர். அவர்கள் மாதுளம் பழங்களிலும், அத்திப்பழங்களிலும் சிலவற்றைக் கொண்டு வந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","அந்த இடம் எஸ்கோல் பள்ளத்தாக்கு என்று அழைக்கப்பட்டது. காரணம் அந்த இடத்தில்தான் இஸ்ரவேல் ஜனங்கள் ஒரு குலை திராட்சை பழத்தைக் கொடியோடு வெட்டிக் கொண்டு வந்தார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","அவர்கள் 40 நாட்கள் அந்த தேசத்தை நன்கு சுற்றி பார்த்தனர். பிறகு அவர்கள் தங்கள் முகாமுக்கு திரும்பி வந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","இஸ்ரவேல் ஜனங்கள் பாரான் பாலைவனத்தில் காதேஷ் என்ற இடத்துக்கு அருகில் தம் கூடாரங்களை அடித்திருந்தனர். அவர்கள் மோசே, ஆரோன் மற்றும் மற்ற இஸ்ரவேல் ஜனங்கள் இருந்த இடத்துக்குத் திரும்பி வந்தனர். அந்நாட்டிலிருந்து கொண்டு வந்த பழங்களைக் காட்டினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","மேலும் அவர்கள் மோசேயிடம், “நீங்கள் அனுப்பிய இடத்திற்கு நாங்கள் சென்றோம். பல நல்ல பொருட்களால் நிறைந்த நாடு அது. அங்கே பழுத்துள்ள சில பழங்களில் கொஞ்சம் இதோ; ");
INSERT INTO tam2008_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","ஆனால் அங்கு ஜனங்கள் மிகவும் பல முள்ளவர்களாக வாழ்கிறார்கள். நகரங்கள் மிகவும் விரிவானவை, மிகவும் பலமான பாதுகாப்பு கொண்டவை. அங்கே சில ஏனாக்கின் ஜனங்களையும் கண்டோம். ");
INSERT INTO tam2008_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","அமலேக்கியர் தென்புறமான நாட்டில் குடியிருக்கிறார்கள். மலை நாடுகளில் ஏத்தியரும், எபூசியரும், எமோரியரும் குடியிருக்கிறார்கள். கானானியர்கள் கடற்கரைகளிலும், யோர்தான் நதி அருகேயும் வாழ்கிறார்கள்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","மோசேயின் அருகே இருந்த ஜனங்களைக் காலேப் அமைதிப்படுத்தி, “நாம் போய் அந்நாட்டை நமக்குரியதாக எடுத்துக்கொள்வோம். நாம் எளிதில் இவர்களை வென்றுவிடலாம்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","ஆனால் அவனோடு சென்று வந்த மற்றவர்களோ, “நாம் அவர்களோடு சண்டையிட முடியாது. அவர்கள் நம்மைவிட பலமுள்ளவர்கள்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","மேலும் அவர்கள் இஸ்ரவேல் ஜனங்களிடம் தம்மால் அந்நாட்டில் உள்ளவர்களை வெல்ல முடியாது என்று கருத்து தெரிவித்தனர். அவர்கள், “நாங்கள் பார்வையிட்ட அந்நாட்டில் பல முள்ளவர்கள் பலர் இருக்கின்றனர். எனவே அங்கே செல்லும் எவரையும் அவர்கள் எளிதாக வென்று விடுவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","அங்கே நாங்கள் இராட்சதர்களையும் பார்த்தோம்! (ஏனாக்கின் சந்ததியிலுள்ள சிலர் இராட்சதப் பிறவிகளாயிருந்தனர்.) எங்கள் பார்வையில் அவர்களுக்கு முன் நாங்கள் சிறிய வெட்டுக்கிளிகளைப் போன்று இருந்தோம். அவர்களது பார்வையில் நாங்களும் அப்படியே தோன்றினோம்!” என்றார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","அன்று இரவு, முகாம்களில் உள்ள அனைவரும் கூக்கூரலிட்டுப் புலம்பினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","இஸ்ரவேல் ஜனங்கள் மோசேக்கும், ஆரோனுக்கும் எதிராக முறையிட்டனர். அவர்கள் அனைவரும் கூடி மோசேயிடமும், ஆரோனிடமும், “நாம் எகிப்து நாட்டிலோ பலைவனங்களிலோ மரித்துப்போயிருக்கலாம், இவ்வாறு புதிய நாட்டில் கொல்லப்படுவதைவிட அது மேலானது. ");
INSERT INTO tam2008_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","நாம் இப்புதிய நாட்டில் போரில் கொல்லப்படுவதற்காகத்தான், கர்த்தர் இங்கே அழைத்து வந்தாரா? எதிரிகள் நம்மைக் கொன்றுவிட்டு, நமது மனைவியரையும், பிள்ளைகளையும் அபகரித்துக்கொள்வார்கள். இதைவிட நாம் எகிப்துக்குத் திரும்பிப் போவது நல்லது” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","பிறகு ஜனங்கள் ஒருவரோடு ஒருவர், “நாம் வேறு தலைவரைத் தேர்ந்தெடுத்து, எகிப்துக்குத் திரும்பிப் போவோம்” எனப் பேசிக்கொண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","அங்கே கூடியிருந்த அனைத்து இஸ்ரவேல் ஜனங்களின் முன்பும், மோசேயும், ஆரோனும் தரையில் பணிந்து வணங்கினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","யோசுவாவும் காலேப்பும் மிகவும் மனமுறிவடைந்தனர். (யோசுவா நூனின் மகன். காலேப் எப்புன்னேயின் மகன். இருவரும் கானான் நாட்டைச் சுற்றிப் பார்த்துவிட்டு வந்தவர்கள்.) ");
INSERT INTO tam2008_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","அங்கே கூடியிருந்த இஸ்ரவேல் ஜனங்களிடம் அந்த இருவரும், “நாங்கள் பார்த்த அந்த நாடு நன்றாக இருக்கிறது. ");
INSERT INTO tam2008_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","அது நல்ல பொருட்கள் பலவற்றால் நிறைந்த நாடு. கர்த்தர் நம்மீது விருப்பம் உடையவராக இருந்தால், அவர் அந்த நாட்டுக்குள் நம்மை வழி நடத்திச் செல்லுவார். அந்த நாட்டை கர்த்தர் நமக்குத் தருவார். ");
INSERT INTO tam2008_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","எனவே கர்த்தருக்கு எதிராக திரும்பாதீர்கள். அந்த நாட்டின் ஜனங்களுக்குப் பயப்படாதீர்கள்! நாம் அவர்களைத் தோற்கடிக்க முடியும். அவர்களுக்குப் பாதுகாப்பு இல்லை, எதுவும் அவர்களைக் காப்பாற்றாது. ஆனால், நம்மோடு கர்த்தர் இருக்கிறார். எனவே, பயப்படவேண்டாம்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","அனைத்து ஜனங்களும் யோசுவாவையும் கலேபையும் கல்லெறிந்து கொன்றுவிட வேண்டும் என்று பேச ஆரம்பித்தார்கள். ஆனால் கர்த்தரின் மகிமை, ஆசரிப்புக் கூடாரத்தின் மேலே அவர்கள் அனைவரும் காணும்படி தோன்றியது. ");
INSERT INTO tam2008_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","கர்த்தர் மோசேயுடன் பேசினார். அவர், “எவ்வளவு காலத்திற்கு இந்த ஜனங்கள் எனக்கெதிராக இருப்பார்கள்? என் மீது நம்பிக்கையில்லை என்பதைக் காட்டுகிறார்கள், என் வல்லமையின் மீது நம்பிக்கை இல்லை என்பதைக் காட்டுகிறார்கள். நான் எத்தனையோ அடையாளங்களை அவர்களுக்கு காட்டியிருக்கிறேன். எனினும் என்னை அவர்கள் நம்ப மறுக்கிறார்கள். நான் அவர்களுக்கிடையில் பலப் பெருங்காரியங்களைச் செய்திருக்கிறேன். ");
INSERT INTO tam2008_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","அவர்கள் அனைவரையும் பெருநோயால் கொன்றுவிடுவேன். அவர்களை அழிப்பேன். நான் இவர்களை விட உங்கள் ஜனத்தை பெரியதாகவும் பலமிக்கதாகவும் பண்ணுவேன்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","பிறகு மோசே கர்த்தரிடம், “நீர் இதனைச் செய்துவிட்டால், எகிப்தியர்கள் இதனைப் பற்றி கேள்விப்படுவார்கள். நீர் உமது வல்லமையைப் பயன்படுத்தி உமது ஜனங்களை எகிப்திலிருந்து வெளியே மீட்டுவந்தீர், என்பதை அவர்கள் அறிவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","எகிப்திய ஜனங்கள் கானான் ஜனங்களிடம் இதைப்பற்றி கூறினார்கள். நீரே கர்த்தர் என்பதை ஏற்கெனவே அவர்கள் அறிந்திருக்கின்றனர். நீர் உமது ஜனங்களோடு இருப்பதையும், ஜனங்கள் உம்மைப் பார்த்தனர் என்பதையும் அறிந்திருக்கின்றனர். அவர்களுக்குத் தனிச்சிறப்புடைய மேகத்தைப் பற்றி தெரியும். பகல் பொழுதில் நீர் மேகத்தின் மூலம் வழிநடத்திச் சென்றதையும், இரவில் அம்மேகம் நெருப்பாகி ஜனங்களுக்கு வெளிச்சம் தந்ததையும் அவர்கள் அறிவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","எனவே இப்போது நீர் இந்த ஜனங்களை அழிக்கக்கூடாது. நீர் இவர்களை அழித்தால், உமது வல்லமையைப்பற்றி அறிந்த அனைத்து ஜனங்களும், ");
INSERT INTO tam2008_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘கர்த்தர் தான் வாக்களித்தபடி தன் ஜனங்களுக்கு நாட்டை அளிக்க முடியவில்லை. எனவே, அவர் அவர்களை பாலைவனத்தில் கொன்றுவிட்டார் என்று பேசுவார்கள்’ ");
INSERT INTO tam2008_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“இப்போதும், ஆண்டவரே, உமது பலத்தைக் காட்டும்! உம்மைப்பற்றி நீரே சொல்லியிருக்கிறபடி செய்யும்! ");
INSERT INTO tam2008_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘நீர் கர்த்தர் கோபப்படுகிறதற்கு தாமதம் பண்ணுகிறார். கர்த்தர் பேரன்பு கொண்டவர். சட்டங்களை மீறி குற்றம் செய்கின்றவர்களை கர்த்தர் மன்னிப்பார். ஆனால் அக்கிரமக்காரர்களையும், அவர்கள் பிள்ளைகளையும், பேரப்பிள்ளைகளையும், அவர்களின் பிள்ளைகளையும் தண்டிப்பார்’ என்று உம்மைப்பற்றி சொல்லியிருக்கிறபடியால், ");
INSERT INTO tam2008_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","இப்போது உமது பேரன்பை இந்த ஜனங்களிடம் காண்பித்து, இவர்களின் பாவத்தை மன்னித்தருளும், எகிப்தை விட்டுப் புறப்பட்ட நாள்முதல் நீர் மன்னித்து வருவது போலவே, இப்போதும் மன்னித்துவிடும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","இதற்கு கர்த்தர், “ஆம்! நீ கேட்டுண்டபடியே இந்த ஜனங்களை மன்னித்துவிடுகிறேன். ");
INSERT INTO tam2008_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ஆனால் உனக்கு ஒரு உண்மையைக் கூறுகிறேன். நான் இந்த பூமியில் இருப்பது எவ்வளவு உண்மையோ, அதுபோலவே எனது மகிமையும் பூமியில் நிறைந்திருக்கும் என்பதும் உண்மையாகும். ");
INSERT INTO tam2008_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","எகிப்திலிருந்து என்னால் அழைத்து வரப்பட்டவர்கள் எவரும் கானான் நாட்டைக் காணமாட்டார்கள். நான் எகிப்தில் செய்த அற்புதங்களையும் நான் பாலைவனத்தில் செய்த பெருஞ்செயல்களையும், அவர்கள் கண்டிருக்கிறார்கள். ஆனாலும், அவர்கள் எனக்குக் கீழ்ப்படியவில்லை. என்னைப் பத்துமுறை சோதித்திருக்கிறார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","நான் அவர்களின் முற்பிதாக்களிடம் அவர்களுக்கு ஒரு நாட்டைத் தருவதாக வாக்களித்தேன். ஆனால் எனக்கு எதிராக உள்ள எவரும் அந்த நாட்டிற்குள் நுழைய முடியாது. ");
INSERT INTO tam2008_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","ஆனால் எனது ஊழியனான காலேப் வேறுபட்டவன். என்னை அவன் முழுமையாகப் பின்பற்றினான். எனவே அவனை ஏற்கெனவே அவன் பார்வையிட்ட நாட்டிற்குள் அழைத்துச் செல்வேன். அவனது ஜனங்கள் அந்நாட்டைப் பெற்றுக்கொள்வார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","அமலேக்கியரும், கானானியரும் இந்தப் பள்ளத்தாக்கில் வாழ்ந்துகொண்டிருக்கிறார்கள். எனவே, நாளை இந்த இடத்தை விட்டுப் புறப்பட்டு செங்கடலுக்குச் செல்லும் சாலையின் மேலுள்ள பாலைவனத்துக்குச் செல்லுங்கள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","கர்த்தர் மோசேயிடமும், ஆரோனிடமும், ");
INSERT INTO tam2008_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“இன்னும் எவ்வளவு காலத்திற்கு இந்தத் தீய ஜனங்கள் எனக்கு எதிராக முறையிடுவார்கள்? நான் இவர்களின் முறையீடுகளையும், புலம்பல்களையும் பலமுறை கேட்டிருக்கிறேன். ");
INSERT INTO tam2008_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","நீங்கள் முறையிட்டபடியே கர்த்தர் நிச்சயம் உங்களுக்குச் செய்வார் என்று அவர்களிடம் சொல். இதுதான் உங்களுக்கு நடை பெறப்போகிறது: ");
INSERT INTO tam2008_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","நீங்கள் பாலைவனத்தில் மரித்துப்போவீர்கள். இருபதும் அதற்கு மேலும் வயதுள்ள, எண்ணி கணக்கிடப்பட்ட ஜனங்கள் மரிப்பார்கள். கர்த்தராகிய எனக்கு எதிராக முறையிட்டீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","எனவே, நான் வாக்களித்திருந்த நாட்டிற்குள் எப்புன்னேயின் மகனான காலேபும், நூனின் மகனான யோசுவாவும் தவிர வேறு எவரும் நுழைய முடியாது. ");
INSERT INTO tam2008_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","அந்நாட்டிலுள்ள உங்களது பகைவர்கள், உங்கள் பிள்ளைகளை அபகரித்துக்கொள்வார்கள் என்று அஞ்சி முறையிட்டீர்கள். ஆனால், நான் உங்களுக்குக் கூறுகிறேன், அந்தப் பிள்ளைகள் அந்நாட்டிற்குள் செல்வார்கள். நீங்கள் ஏற்றுக்கொள்ள மறுத்த மகிழ்ச்சியை அவர்கள் அனுபவிப்பார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","உங்களைப் பொறுத்தவரையில், நீங்கள் இந்தப் பாலைவனத்திலேயே மரித்துப் போவீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","“உங்கள் பிள்ளைகள் இந்தப் பாலைவனத்தில் மேய்ப்பர்களாக 40 ஆண்டுகள் அலைந்து திரிவார்கள், நீங்கள் எனக்கு உண்மையுள்ளவர்களாக இல்லாததால், அவர்கள் துன்பப்படுவார்கள். நீங்கள் அனைவரும் இப்பாலைவனத்தில் மரித்து விழும்வரை அவர்கள் துன்பப்படுவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","40 ஆண்டுகள் உங்கள் பாவங்களுக்காக நீங்கள் துன்பப்படுவீர்கள். (நீங்கள் கானான் நாட்டைச் சுற்றி பார்த்தது 40 நாட்கள். ஒரு நாளுக்கு ஒரு ஆண்டு வீதம் 40 ஆண்டுகள்.) உங்களுக்கு எதிராக என்னை நிறுத்தி வைப்பது எவ்வளவு பயங்கரமானது என்பதை நீங்கள் அறிந்துகொள்வீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","“நானே கர்த்தர். நான் சொல்லியிருக்கிறேன், தீய ஜனங்கள் அனைவருக்கும் நான் சொன்னபடியே செய்வேன் என்று உறுதியாய்க் கூறுகிறேன். இந்த ஜனங்கள் அனைவரும் எனக்கு எதிராக ஒன்று சேர்ந்தார்கள். எனவே அனைவரும் இப்பாலைவனத்திலேயே மரித்துப்போவார்கள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","புதிய நாட்டைப் பார்வையிட்டு வருமாறு மோசே அனுப்பி வைத்தவர்களில் சிலர் இஸ்ரவேல் ஜனங்களிடம் வதந்தியைப் பரப்பினார்கள். அந்நாட்டிற்குள் நுழைகிற அளவிற்குத் தமக்குப் பலமில்லை என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","இஸ்ரவேல் ஜனங்கள் மத்தியில் அவநம்பிக்கையைப் பரப்பியதற்கு இவர்களே பொறுப்பாகும். எனவே கர்த்தர் அந்த ஜனங்களை கொல்லும்படி நோயைக் கொண்டு வந்தார். ");
INSERT INTO tam2008_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","ஆனால் நூனின் மகனான யோசுவாவும், எப்புன்னேயின் மகனான காலேபும் கானான் நாட்டை பார்வையிட்டவர்களில் இந்த இருவரையும் கர்த்தர் காப்பாற்றினார். மற்றவர்களைச் சாகடித்த அந்நோய் இவர்களுக்கு வரவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","இஸ்ரவேல் ஜனங்களிடம் மோசே இவை அனைத்தையும் சொன்னான். அவர்கள் மிகவும் துக்கப்பட்டு மனங்கசந்து அழுதனர். ");
INSERT INTO tam2008_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","மறுநாள் அதிகாலையில் அவர்கள் உயரமான மலைநாட்டிற்குள் பிரவேசிக்கப் புறப்பட்டனர். அவர்கள்: “நாங்கள் பாவம் செய்துவிட்டோம். நாங்கள் கர்த்தரை நம்பாமல் போனதற்காக வருத்தப்படுகிறோம். கர்த்தர் வாக்களித்த நாட்டிற்குள் நாங்கள் போவோம்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","ஆனால் மோசே, “கர்த்தரின் கட்ட ளைக்கு ஏன் கீழ்ப்படிய மறுக்கிறீர்கள். நீங்கள் வெற்றியடையப் போவதில்லை. ");
INSERT INTO tam2008_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","அந்த நாட்டிற்குள் போகாதீர்கள். கர்த்தர் இப்போது உங்களோடு இல்லை. எனவே, உங்கள் பகைவர்கள் உங்களை எளிதில் வென்றுவிடுவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","அமலேக்கியரும், கானானியரும் உங்களுக்கு முன்னே அங்கே இருக்கிறார்கள். அவர்கள் உங்களுக்கு எதிராகச் சண்டையிடுவார்கள். நீங்கள் கர்த்தரிடமிருந்து விலகிவிட்டீர்கள். எனவே நீங்கள் அவர்களோடு சண்டையிடும்போது கர்த்தர் உங்களோடு இருக்கமாட்டார். எனவே நீங்கள் அனைவரும் போரில் கொல்லப்படுவீர்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","ஆனால் மோசேயின் வார்த்தைகளை ஜனங்கள் நம்பவில்லை. அவர்கள் மலை நாட்டை நோக்கிச் சென்றனர். ஆனால் மோசேயும், கர்த்தருடைய உடன்படிக்கைப் பெட்டியும் அவர்களோடு போகவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","மலைநாட்டில் வாழ்ந்த அமலேக்கியரும், கானானியரும் கீழே இறங்கி வந்து அவர்களைத் தாக்கி, அவர்களை எளிதில் தோற்கடித்தனர். அவர்களை ஓர்மா வரை துரத்தி அடித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“இஸ்ரவேல் ஜனங்களிடம் பேசி இதனைக் கூறு. உங்கள் வீடாக இருக்கும்படி நான் உங்களுக்கு ஒரு நாட்டைக் கொடுக்கிறேன். நீங்கள் அதனுள்ளே நுழைந்ததும், ");
INSERT INTO tam2008_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","நீங்கள் கர்த்தருக்குச் சில சிறப்புக்குரிய தகன பலிகளைச் செலுத்த வேண்டும். அவற்றின் வாசனை கர்த்தருக்கு விருப்பமானது. நீங்கள் உங்கள் மாடுகளையும், ஆடுகளையும், வெள்ளாடுகளையும் தகனபலிக்குப் பயன்படுத்தலாம். அவற்றை சிறப்பு காணிக்கைகள், உற்சாக பலிகள், சமாதானப் பலிகள் அல்லது சிறப்புப் பண்டிகைப் பலிகள், ஆகியவற்றுக்காகவும் பயன்படுத்த வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","“ஒருவன் கர்த்தருக்கு காணிக்கையைக் கொண்டு வரும்போது, அவன் தானியக் காணிக்கையையும் கொண்டுவர வேண்டும். தானியக் காணிக்கை என்பது, ஒரு மரக்காலில் பத்தில் ஒரு பங்கு மெல்லிய மாவில் காற்படி எண்ணெய் பிசைந்து கொண்டு வரவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","ஒரு ஆட்டுக்குட்டியைத் தகனபலியாகக் கொண்டுவரும் ஒவ்வொரு முறையும், நீங்கள் காற்படி திராட்சை ரசத்தையும், பானங்களின் காணிக்கையாகப் படைக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“நீங்கள் ஒரு ஆட்டுக்கடாவைப் படைக்கும்போது, தானியக் காணிக்கையையும் சேர்த்து படைக்கவேண்டும். இந்தத் தானியக் காணிக்கை, ஒரு மரக்காலில் பத்தில் இரண்டு பங்கான, மெல்லிய மாவிலே ஒருபடியில் மூன்றில் ஒரு பங்கு, ஒலிவ எண்ணெயோடு பிசைந்து கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ஒரு படியில் மூன்றில் ஒரு பங்கு திராட்சைரசத்தைப் பானங்களின் காணிக்கையாகக் கொடுக்க வேண்டும். அதன் மணம் கர்த்தருக்கு மிகவும் விருப்பமானது. ");
INSERT INTO tam2008_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ஓர் இளங்காளையைத் தகனபலியாகவோ, சிறப்பான பொருத்தனைப் பலியாகவோ, சமாதான பலியாகவோ, கொடுக்கலாம். ");
INSERT INTO tam2008_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","அப்போது, அதனோடு தானியக் காணிக்கையையும், ஒரு காளையையும் படைக்கவேண்டும். அதாவது, ஒரு மரக்காலில் பத்தில் மூன்று பங்கான மெல்லிய மாவுடன், அரைப்படி ஒலிவ எண்ணெயைப் பிசைந்து கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","அதோடு பானங்களின் காணிக்கையாக அரைப்படி திராட்சைரசத்தையும் கொடுக்கவேண்டும். இதன் மணம் கர்த்தருக்கு மிகவும் விருப்பமாக இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","நீங்கள் கர்த்தருக்கு தகனபலியாக கொடுக்கப் போகும் பலி, காளை அல்லது ஆட்டுக்கடா அல்லது செம்மறி ஆட்டுக் குட்டி அல்லது வெள்ளாட்டுக் குட்டியை இம்முறையில்தான் அளிக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","நீங்கள் படைக்கும் ஒவ்வொரு மிருகத்திற்கும் இவ்வாறுதான் செய்யவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“இவ்வாறே ஒவ்வொரு இஸ்ரவேலனும் கர்த்தருக்குப் பிரியமான முறையில் தகன பலியைச் செலுத்த வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","உங்களிடையே பிறநாட்டு ஜனங்களும் வாழ்வார்கள். அவர்களும் தகனபலி கொடுத்து கர்த்தரை வழிபட விரும்பினால் இந்த முறையில்தான் செலுத்தவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","இதே விதிகள்தான் உங்களுக்கும், உங்களோடு வாழும் பிற நாட்டு ஜனங்களுக்கும் உரியதாகும். இவ்விதிகள் எக்காலத்திற்கும் உரியதாக விளங்கும். கர்த்தருக்கு முன்பு, நீங்களும், உங்களோடு வாழும் மற்றவர்களும், சமமாகக் கருதப்படுவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","எனவே, நீங்கள் இந்த விதிகளையும், சட்டங்களையும் கண்டிப்பாகக் கடைபிடிக்க வேண்டும் என்பதுதான் இதற்குப் பொருள். அந்தச் சட்டங்களும், விதிகளும் இஸ்ரவேல் ஜனங்களாகிய உங்களுக்கும், உங்களோடு வாழும் மற்ற ஜனங்களுக்கும் பொருந்தும்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","கர்த்தர் மேலும் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“இவற்றை இஸ்ரவேல் ஜனங்களிடம் கூறு. நான் உங்களை வேறு நாட்டிற்கு அழைத்துச் செல்வேன். ");
INSERT INTO tam2008_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","அங்கு நீங்கள் விளைந்த உணவை உண்பதற்கு முன்னால், அதில் ஒரு பங்கை, கர்த்தருக்கு காணிக்கையாகக் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","நீங்கள் தானியத்தைச் சேகரித்து, மாவாக அரைக்கவேண்டும். அது அப்பம் செய்வதற்கு ஏற்றதாக இருக்கவேண்டும். முதலில் செய்யப்படும் அப்பத்தை, கர்த்தருக்கு காணிக்கையாகக் கொடுக்கவேண்டும். போரடிக்கிற களத்தில் தானியத்தைக் காணிக்கையாகக் கொடுப்பது போன்று இது இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","இவ்விதிமுறை எக்காலத்திற்கும் தொடர்ந்திருக்கும். நீங்கள் பிசைந்த மாவின் முதற்பகுதியை, கர்த்தருக்கு அன்பளிப்பாகக் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“இந்தக் கட்டளையை மறதியினால் தவறி நீங்கள் அநுசரியாமற்போனால், நீங்கள் அதற்காக என்ன செய்யவேண்டும்? ");
INSERT INTO tam2008_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","இந்தக் கட்டளைகளைக் கர்த்தர் உங்களுக்கு மோசே மூலமாகக் கொடுத்தார். உங்களுக்கு கொடுத்த அந்நாளிலேயே இக்கட்டளைகள் செயல்படத் துவங்கியது. அந்நாள் முதல் எல்லாக் காலத்திற்கும் இக்கட்டளைகள் உங்களுக்குத் தொடர்ந்து வரும். ");
INSERT INTO tam2008_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","எனவே, இஸ்ரவேலின் அனைத்து ஜனங்களும் திட்டமிடாமல் இந்தக் கட்டளைகளை காக்கத் தவறினால் அதற்கு என்ன செய்வீர்கள்? இஸ்ரவேல் ஜனங்கள் அனைவரும் இந்தத் தவறைச் செய்தால், அவர்கள் அனைவரும் சேர்ந்து, ஓர் இளங்காளையைப் பலி கொடுக்க வேண்டும். அதன் மணம் கர்த்தருக்கு மிகவும் விருப்பமானதாகும். அதோடு தானியக் காணிக்கையையும், பானங்களின் காணிக்கையையும் ஒரு காளையோடு காணிக்கையாக கொடுக்கவேண்டும். பாவநிவாரண பலியாக ஒரு வெள்ளாட்டுக் கடாவையும் பலி கொடுக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","“ஜனங்களைத் சுத்தப்படுத்த ஆசாரியன் அனைத்து சடங்குகளையும் செய்ய வேண்டும். அவன் இவற்றை இஸ்ரவேல் ஜனங்கள் அனைவருக்காகவும் செய்யவேண்டும். தாங்கள் பாவிகள் என்பது அவர்களுக்குத் தெரியாமல் இருக்கலாம். ஆனால், எப்போது அவர்களுக்கு அது தெரிய வருகிறதோ, அப்போதே அவர்கள் கர்த்தருக்கு அன்பளிப்புச் செலுத்த வேண்டும். அவர்கள் தகனபலியையும் பாவ நிவாரண பலியையும் கொடுக்க வேண்டும். அதனால் அவர்கள் பாவங்கள் மன்னிக்கப்படும். ");
INSERT INTO tam2008_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","இஸ்ரவேலின் அனைத்து ஜனங்களும், அவர்களோடு வாழும் மற்ற ஜனங்களும் மன்னிக்கப்படுவார்கள். அவர்களுக்கு நாம் தவறு செய்துகொண்டிருக்கிறோம் என்று தெரியாதிருந்தால் அவர்களும் மன்னிக்கப்படுவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ஒரே ஒரு மனிதன் மட்டும் தவறிப் பாவம் செய்தால் அவன் ஓராண்டு வயதுள்ள பெண் வெள்ளாட்டைக் கொண்டு வர வேண்டும். அது பாவப்பரிகார பலியாகும். ");
INSERT INTO tam2008_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","அவனைத் சுத்தப்படுத்துவதற்குரிய நியமனத்தை ஆசாரியன் நிறைவேற்றவேண்டும். அந்த மனிதன் கர்த்தர் முன்னால் தவறி குற்றம் செய்து பாவியானால் ஆசாரியன் அவனுக்கு நிவாரணம் செய்தபின் அவன் சுத்தமாக்கி மன்னிக்கப்படுகிறான். ");
INSERT INTO tam2008_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","குற்றம் செய்து பாவியாகிற எவனுக்கும் இந்தச் சட்டம் உரியதாகும். இச்சட்டங்கள் இஸ்ரவேல் குடும்பத்தில் பிறந்த ஜனங்களுக்கும், அவர்களிடையே வாழும் அயல் நாட்டுக்காரர்களுக்கும் உரியதாகும். ");
INSERT INTO tam2008_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ஆனால் ஒருவன் அறிந்தே பாவம் செய்துகொண்டேயிருக்கிறவனாயிருந்தால் அவன் கர்த்தருக்கு எதிராகிறான். அவன் தம் ஜனங்களிடமிருந்து தனியே பிரிக்கப்படவேண்டும். இந்தச் சட்டம் இஸ்ரவேல் குடும்பத்தில் பிறந்த ஜனங்களுக்கும், உங்களோடு வாழும் பிறநாட்டு ஜனங்களுக்கும் உரியதாகும். ");
INSERT INTO tam2008_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","கர்த்தரின் வார்த்தைகள் முக்கியமானவை என்று அந்த மனிதன் நினைக்கவில்லை. அவன் கர்த்தரின் கட்டளையை உடைத்துவிட்டான். அப்படிப்பட்டவன் உங்கள் குழுவிலிருந்து நிச்சயம் விலக்கப்பட வேண்டும். அவன் குற்றவாளியாகித் தண்டிக்கப்படுவான்!” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","இந்த நேரத்தில் இஸ்ரவேல் ஜனங்கள் பாலைவனத்திலேயே இருந்தனர். ஒருவன் ஓய்வு நாள் ஒன்றில் எரிப்பதற்கான விறகுகளைக் கண்டு அவற்றைச் சேகரித்தான். சிலர் இதனைப் பார்த்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","அவன் விறகைச் சேகரித்துக்கொண்டு வரும்போது, அவர்கள் அவனை மோசேயிடமும், ஆரோனிடமும் அழைத்து வந்தனர். மற்றவர்களும் அவர்களோடு சேர்ந்து வந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","அவனுக்கு என்ன தண்டனை கொடுப்பது என்பது தெரியாததால் அவனை காவலுக்குள் வைத்திருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","பிறகு மோசேயிடம் கர்த்தர், “இவன் சாகவேண்டும். முகாமிற்கு வெளியே அவனைக் கொண்டு போய் அனைவரும் அவன் மேல் கல்லெறியுங்கள்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","எனவே, ஜனங்கள் அவனை முகாமிற்கு வெளியே கொண்டு போய் கல்லால் எறிந்தனர். அவர்கள் இதனை மோசேக்குக் கர்த்தர் கட்டளையிட்டபடியே செய்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“இஸ்ரவேல் ஜனங்களிடம் பேசி கீழ்க்கண்டவற்றை அவர்களிடம் கூறு. எனது கட்டளைகளை நினைவுப்படுத்திக்கொள்ள நான் உங்களுக்கு உதவுவேன். பல துண்டு நூல் கயிறுகளைச் சேர்த்து, உங்கள் ஆடைகளின் மூலையில் தொங்கல்களைக் கட்டிக்கொள்ளுங்கள். ஒவ்வொரு தொங்கலிலும் நீல நிற நூலைக் கட்டிக்கொள்ளுங்கள். இதனை இப்போதும் எக்காலத்திற்கும் அணிந்துகொள்ள வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","நீங்கள் இம்முடிச்சுகளைப் பார்க்கும்போதெல்லாம் கர்த்தர் உங்களுக்குக் கொடுத்த கட்டளைகளை நினைவுப்படுத்திக்கொள்ளுங்கள். அப்போது நீங்கள் அவற்றுக்குக் கீழ்ப்படிவீர்கள். இதனால் மறதி காரணமாக பாவம் செய்யாமல் இருப்பீர்கள். உங்கள் உடம்பும், கண்களும் விரும்புகிற காரியங்களை செய்யமாட்டீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","எனது அனைத்து கட்டளைகளுக்கும் நீங்கள் கீழ்ப்படிய வேண்டும் என்பதை நினைவுபடுத்திக்கொள்ளுங்கள். அப்போது நீங்கள் உங்கள் தேவனுக்கென்று பரிசுத்தமாக இருப்பீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","நான் உங்கள் தேவனாகிய கர்த்தர். நானே உங்களை எகிப்திலிருந்து மீட்டு வந்தேன். நான் உங்கள் தேவனாயிருக்க இவற்றைச் செய்தேன். நானே உங்கள் தேவனாகிய கர்த்தர்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","கோராகு, தாத்தான், அபிராம், ஓன் ஆகியோர் மோசேக்கு எதிராகக் கிளம்பினார்கள். (கோராகு இத்சேயாரின் மகன். இத்சேயார் கோகாத்தின் மகன். கோகாத் லேவியின் மகன். தாத்தானும், அபிராமும் சகோதரர்கள். இவர்கள் எலியாபின் பிள்ளைகள். ஓன் பேலேத்தின் மகன். இவர்கள் அனைவரும் ரூபன் சந்ததியைச் சேர்ந்தவர்கள்.) ");
INSERT INTO tam2008_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","இவர்கள் நான்கு பேரும் 250 இஸ்ரவேல் ஜனங்களைச் சேர்த்து மோசேக்கு எதிராக நின்றனர். இவர்கள் அனைவரும் ஜனங்களால் தேர்ந்தெடுக்கப்பட்டத் தலைவர்கள். அவர்களை அனைவருக்கும் தெரியும். ");
INSERT INTO tam2008_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","அவர்கள் அனைவரும் ஒரு குழுவாகி மோசேக்கும், ஆரோனுக்கும் எதிராகப் பேச வந்தனர். அவர்கள் மோசேயிடமும், ஆரோனிடமும் வந்து, “நீங்கள் அளவை மிஞ்சிப் போய் விட்டீர்கள். நீங்கள் தவறானவர்கள்! இஸ்ரவேல் ஜனங்கள் அனைவரும் பரிசுத்தமானவர்கள். அவர்கள் மத்தியில் கர்த்தர் வாழ்கிறார்! கர்த்தரின் மற்ற ஜனங்களைவிட, நீங்கள் உங்களை மட்டும் மிக முக்கிமானவர்களாக்கிக் கொண்டீர்கள்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","இதைக் கேள்விப்பட்டதும் மோசே தரையில் முகம்குப்புற விழுந்து வணங்கி, தான் பெருமை இல்லாதவன் என்பதை வெளிப்படுத்தினான். ");
INSERT INTO tam2008_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","பிறகு மோசே, கோராகிடமும் அவனைப் பின்பற்றி வந்தவர்களிடமும்: “நாளை காலையில் கர்த்தர், தனது உண்மையான ஊழியன் யாரென்றும் உண்மையில் யார் பரிசுத்தமானவன் என்பதையும் காட்டுவார். அந்த மனிதனை அவர் தன்னருகில் அழைப்பார். அந்த மனிதனைத் தேர்ந்தெடுத்து, கர்த்தர் தன்னருகே சேர்த்துக்கொள்வார். ");
INSERT INTO tam2008_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","எனவே, கோராகே! நீயும் உன்னைப் பின்பற்றுகிறவர்களும் ");
INSERT INTO tam2008_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","நாளை தூபகலசங்களில் நெருப்பை உண்டாக்கி, அதில் நறுமணப் பொருட்களையிட்டு, அவற்றைக் கர்த்தருக்கு முன்னால் கொண்டு வாருங்கள். உண்மையில் பரிசுத்தமானவன் யார் என்பதைக் கர்த்தர் தேர்ந்தெடுப்பார். லேவியர்களாகிய நீங்கள்தான் மிதமிஞ்சி போகிறீர்கள். நீங்கள் தவறானவர்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","மேலும் மோசே கோராகிடம், “லேவியர்களாகிய நீங்கள் நான் சொல்வதைக் கேளுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","இஸ்ரவேல் ஜனங்களின் தேவன் உங்களைச் சிறப்பாகத் தேர்ந்தெடுத்திருப்பதால், நீங்கள் மேலும் மகிழ்ச்சி அடையவேண்டும், இல்லையா? மற்ற இஸ்ரவேல் ஜனங்களிடமிருந்து நீங்கள் வேறுபட்டவர்கள். பரிசுத்தக் கூடாரத்தில் பணிவிடை செய்வதற்காகக் கர்த்தர் உங்களைத் தேர்ந்தெடுத்திருக்கிறார். அவர் தம்மருகே உங்களை வரச்செய்திருக்கிறார். இஸ்ரவேல் ஜனங்களின் ஆராதனைக்கு நீங்கள் உதவ வேண்டும். இது போதாதா? ");
INSERT INTO tam2008_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","ஆசாரியர்களுக்கு உதவும்படி லேவியர்களாகிய உங்களைக் கர்த்தர் தன்னருகே அனுமதித்திருக்கிறார். ஆனால் நீங்கள் இப்போது ஆசாரியர்களாக மாறப் பார்க்கிறீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","நீயும் உன்னைப் பின்பற்றுகிறவர்களும் சேர்ந்து கர்த்தருக்கு எதிராக நிற்கிறீர்கள். ஆரோன் ஏதாவது தவறு செய்தானா? இல்லையே! அவ்வாறு இருக்க அவனுக்கு எதிராக ஏன் முறையிடுகிறீர்கள்?” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","பிறகு மோசே எலியாப்பின் மகன்களான தாத்தானையும், அபிராமையும் அழைத்தான். ஆனால் அவர்களோ, “நாங்கள் வரமாட்டோம்! ");
INSERT INTO tam2008_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","நீர் ஏராளமான நன்மைகள் நிறைந்த நாட்டிலிருந்து வெளியேற்றி எங்களை கொல்வதற்காக இப்பாலைவனத்துக்கு கொண்டு வந்திருக்கிறீர். இப்போது எங்களை விட உம்மை திறமை மிக்கவராக காட்ட விரும்புகிறீர். ");
INSERT INTO tam2008_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","நாங்கள் ஏன் உம்மை பின்பற்ற வேண்டும்? தேவன் வாக்களித்த பாலும் தேனும் ஓடுகிற தேசத்துக்குள் நீர் எங்களைக் கொண்டு வரவில்லை. நீர் எங்களுக்கு வயல்களோ, திராட்சை தோட்டங்களோ கொடுக்கவில்லை. இந்த ஜனங்களையெல்லாம் உங்கள் அடிமைகளாக்குவதுதான் உங்கள் எண்ணமா? முடியாது. நாங்கள் அங்கே வரமாட்டோம்” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","எனவே, மோசே மிகவும் கோபம் கொண்டான். அவன் மீண்டும் கர்த்தரிடம், “நான் இந்த ஜனங்களுக்கு எதிராக எந்தத் தவறும் செய்யவில்லை. நான் அவர்களிடமிருந்து எதையும், ஏன் ஒரு கழுதையையும் கூட எடுத்துக்கொள்ளவில்லை! கர்த்தாவே, இவர்களது அன்பளிப்பை ஏற்றுக்கொள்ளாதிரும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","பிறகு மோசே கோராகிடம், “நாளை கர்த்தருக்கு முன்னால் நீயும், உன்னைப் பின்பற்றுகிறவர்களும் நிற்கவேண்டும். அங்கே உங்களோடு ஆரோனும் நிற்பான். ");
INSERT INTO tam2008_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","நீங்கள் ஒவ்வொருவரும் நறுமணப் பொருட்களை இடுகின்ற தூபகலசத்தைக் கொண்டு வந்து அவற்றைக் கர்த்தருக்கு முன்பு வைக்க வேண்டும். மூப்பர்களுக்குரிய 250 தூபகலசத்தோடு உனக்கும், ஆரோனுக்குமாக இரண்டு தூப கலசங்கள் இருக்கும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","எனவே, ஒவ்வொரு தலைவரும் தனக்கென்று தூபகலசமும், அதில் இடுவதற்கு நறுமணப் பொருட்களும் கொண்டு வந்தனர். ஆசரிப்புக் கூடாரத்தின் வாசலில் அவர்கள் வந்து நின்றனர். மோசேயும் ஆரோனும் அங்கே நின்றனர். ");
INSERT INTO tam2008_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","கோராகும் அனைத்து ஜனங்களையும் ஆசரிப்புக் கூடாரத்தின் வாசலில் கூடுமாறு செய்தான். பிறகு அங்குள்ள ழுழு சபையினருக்கும் கர்த்தரின் மகிமை காணப்பட்டது. ");
INSERT INTO tam2008_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","கர்த்தர் மோசேயிடமும், ஆரோனிடமும், ");
INSERT INTO tam2008_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“இந்த ஜனங்களிடமிருந்து விலகி நில்லுங்கள். அவர்களை இப்போதே அழிக்கப் போகிறேன்!” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","ஆனால் மோசேயும், ஆரோனும் தரையில் முகங்குப்புற விழுந்து வணங்கிக் கதறினார்கள், “தேவனே! நீர் மாம்சமான எல்லாருடைய ஆவிகளுக்கும் தேவன். ஒரே ஒருவன் மட்டும் பாவம் செய்தால் நீர் முழு சபையினர் மீதும் கோபங்கொள்ளலாமா?” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","பிறகு கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“கோராகு, தாத்தான், அபிராம் ஆகியோரின் கூடாரத்தை விட்டு விலகிப்போகும்படி ஜனங்களிடம் கூறு” என்று கேட்டுண்டார். ");
INSERT INTO tam2008_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","மோசே எழுந்து, தாத்தானிடமும், அபிராமிடமும் சென்றான். எல்லா மூப்பர்களும் அவனைப் பின்பற்றினர். ");
INSERT INTO tam2008_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","மோசே, ஜனங்களை எச்சரித்து. “அந்தத் தீய மனிதர்களின் கூடாரங்களை விட்டு விலகிப் போங்கள், அவர்களுக்குரிய எதையும் தொடாதீர்கள், நீங்கள் இவ்வாறு செய்தால் அவர்களது பாவத்தின் காரணமாக அழிக்கப்படுவீர்கள்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","எனவே கோராகு, தாத்தான், அபிராம் ஆகியோரின் கூடாரத்தை விட்டு விலகிப் போனார்கள். தாத்தானும் அபிராமும் தங்கள் கூடாரத்திற்கு வெளியே வந்து, தங்கள் கூடார வாசல்களில், தங்கள் மனைவி, குழந்தைகளோடு நின்று கொண்டிருந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","பிறகு மோசே, “இவை எல்லாவற்றையும் செய்யுமாறு கர்த்தர் என்னை அனுப்பினார் என்று ஏற்கெனவே நான் கூறியுள்ளேன். இதுதான் அதற்கான சாட்சி. இவை எனது சொந்த எண்ணங்கள் அல்ல என்பதை இவை உங்களுக்குக் காட்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","இங்குள்ள மனிதர்கள் மரித்துப்போவார்கள். அவர்கள் சாதாரண ஜனங்களைப் போன்று மரிப்பார்களேயானால் பிறகு கர்த்தர் உண்மையில் என்னை அனுப்பவில்லை என்று தெரிந்துக்கொள்ளுங்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","ஆனால் கர்த்தர் இவர்களை அசாதாரணமான முறையில் மரிக்க செய்வாரானால், இவர்கள் கர்த்தருக்கு எதிராகப் பாவம் செய்தார்கள் என்பதைத் தெரிந்துக்கொள்ளுங்கள். பூமி பிளந்து இந்த மனிதர்களை அப்படியே விழுங்கிவிடும். இதுதான் அதற்கு சான்று, இவர்கள் உயிரோடு தங்கள் கல்லறைக்குள் புதைக்கப்படுவார்கள். இவர்களுக்குரிய அனைத்தும், இவர்களோடேயே போய்ச்சேரும்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","மோசே இவற்றைச் சொல்லி முடித்ததும், அவர்கள் நின்ற இடத்தில் பூமி பிளந்தது. ");
INSERT INTO tam2008_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","பூமி தன் வாயைத் திறந்து, அவர்களை விழுங்கியது போல் இருந்தது. கோரகின் ஜனங்களும் அவர்களின் குடும்பங்களும் அவர்களுக்குரிய அனைத்தும் பூமிக்குள் சென்றுவிட்டன. ");
INSERT INTO tam2008_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","அவர்கள் தங்கள் கல்லறைக்குள் உயிரோடு சென்றனர். அவர்களுக்குரிய பொருட்களும், அவர்களோடு சென்றன. பிறகு பூமி மூடிக்கொண்டது. அவர்கள் முகாமிலிருந்து மூடப்பட்டு மடிந்தனர்! ");
INSERT INTO tam2008_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","இஸ்ரவேல் ஜனங்கள் அழிந்து போனவர்களின் அழுகுரல்களைக் கேட்டனர், அவர்கள் பல திசைகளிலும் ஓடிப்போய், “இந்தப் பூமி எங்களையும் விழுங்கிக் கொன்றுவிடும்” என்று கதறினர். ");
INSERT INTO tam2008_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","பிறகு கர்த்தரிடமிருந்து நெருப்பு புறப்பட்டு வந்து தூபதீபம் காட்டிய 250 தலைவர்களையும் அழித்துப் போட்டது. ");
INSERT INTO tam2008_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","கர்த்தர் மோசேயிடம் ");
INSERT INTO tam2008_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","38","“ஆசாரியனான ஆரோனின் மகனான எலெயாசாரிடம் நெருப்புக்குள் அகப்பட்ட தூபகலசங்களை எடுத்து, அவற்றிலுள்ள கரியையும், சாம்பலையும் கொட்டிவிடச் சொல். அவர்கள் எனக்கெதிராகப் பாவம் செய்தார்கள். அவர்களது பாவம் அவர்களின் உயிரைப் போக்கிவிட்டது. ஆனால், அக்கலசங்கள் இப்போதும் பரிசுத்தமானவை. அவற்றை கர்த்தருக்குக் கொண்டுவந்ததால் பரிசுத்தமடைந்தன. அவற்றைத் தகடுகளாக அடித்து, பலிபீடத்தைச் சுற்றிலும் மூடிவைக்கவும். இது எல்லா இஸ்ரவேல் ஜனங்களுக்கும் ஒரு எச்சரிக்கையாக இருக்கும்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","எனவே, ஆசாரியனாகிய எலெயாசார் அனைத்து வெண்கலத் தூபகலசங்களையும் சேகரித்தான். அவற்றைக் கொண்டு வந்த மனிதர்கள் மரித்துப்போனார்கள். ஆனால், கலசங்கள் இருந்தன. அவன் அவற்றை அடித்து, தகடாக்கும்படி செய்து, பின் அத்தகடுகளைப் பலிபீடத்தைச் சுற்றி மாட்டி வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","மோசே மூலமாக கர்த்தர் எலெயாசாருக்குக் கட்டளையிட்டபடிச் செய்து முடித்தான். இது இஸ்ரவேல் ஜனங்களுக்கு ஒரு அடையாளம் ஆயிற்று. ஆரோன் ஜனங்களைத் தவிர வேறு யாரேனும் நறுமணப் பொருள் கொண்டு வரக் கூடாது என்பதற்கு இது நினைவூட்டல் ஆயிற்று. யாராவது கர்த்தருக்கு நறுமணப் பொருள் கொண்டுவந்தால், கோராகும் அவனைப் பின்பற்றியவர்களும் மரித்துப் போனதுபோல் மரித்துப்போவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","மறுநாள் இஸ்ரவேல் ஜனங்கள், மோசேக்கும், ஆரோனுக்கும் எதிராக முறையிட்டு, “நீங்கள் கர்த்தருடைய ஜனங்களைக் கொன்று விட்டீர்கள்” எனக் கூறினர். ");
INSERT INTO tam2008_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","மோசேயும் ஆரோனும் ஆசரிப்புக் கூடாரத்தின் வாசலில் நின்று கொண்டு இருந்தனர். ஜனங்கள் அங்கே கூடி அவர்களுக்கு எதிராக முறையிட்டனர். ஆனால் அவர்கள் ஆசரிப்புக் கூடாரத்தை நோக்கியபோது அதை மேகம் சூழ்ந்தது. அங்கே கர்த்தரின் மகிமை காணப்பட்டது. ");
INSERT INTO tam2008_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","பிறகு மோசேயும் ஆரோனும் ஆசரிப்புக் கூடாரத்தின் முன்பாக வந்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","மோசேயிடம் கர்த்தர், ");
INSERT INTO tam2008_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“இந்த ஜனங்களிடமிருந்து விலகி நில்லுங்கள். நான் இவர்களை உடனே அழிக்கப்போகிறேன்” என்றார். எனவே மோசேயும் ஆரோனும் தரையில் முகம்குப்புற விழுந்து வணங்கினார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","பிறகு மோசே ஆரோனிடம், “உனது வெண்கலத் தூபகலசத்தை எடுத்துக்கொள், பலிபீடத்திலுள்ள நெருப்பை அதில் இடு, பின் நறுமணப் பொருளைப்போடு, அவற்றை ஜனங்களிடம் கொண்டு போய் காட்டு, அது அவர்களைத் சுத்தமாக்கும். அவர்கள் மேல் கர்த்தர் கோபமாக உள்ளார். அவர்களுக்கு துன்பம் ஏற்கெனவே தொடங்கி விட்டது” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","48","ஆரோன் மோசே சொன்னபடி தூபகலசமும், நெருப்பும், நறுமணப் பொருட்களும் எடுத்துக்கொண்டு ஜனங்கள் மத்தியில் ஓடினான். ஆனால், ஏற்கெனவே நோய் அவர்களிடையே துவங்கிவிட்டது. எனவே ஆரோன் மரித்துப் போனவர்களுக்கும், இன்னும் உயிரோடு இருந்தவர்களுக்கும் இடையே நின்று அவர்களைத் சுத்தப்படுத்தவதற்குரியவற்றைச் செய்தான். நோயும் நிறுத்தப்பட்டது. ");
INSERT INTO tam2008_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","ஆனால் 14,700 பேர் நோயால் மரித்துப்போனார்கள். கோரகினால் மரித்தவர்கள் இதில் கணக்கிடப்படவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","எனவே நோய் நிறுத்தப்பட்டது. பின் ஆரோன் ஆசரிப்புக் கூடாரத்தின் வாசலில் நின்ற மோசேயிடம் திரும்பி வந்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“இஸ்ரவேல் ஜனங்களிடம் பேசு. அவர்களிடமிருந்து 12 கைத்தடிகளை வாங்கு. 12 கோத்திரங்களின் தலைவர்களிடமிருந்தும் ஒவ்வொரு கைத்தடியாகப் பெற வேண்டும். ஒவ்வொருவரின் பெயரையும் அவரவர் கைத்தடியிலும் எழுது. ");
INSERT INTO tam2008_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","லேவியின் கைத்தடியில் ஆரோனின் பெயரை எழுது. ஒவ்வொரு கோத்திரத்திற்கும் ஒரு கைத்தடி வீதம் பன்னிரண்டு இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","அக்கைத்தடிகளை ஆசரிப்புக் கூடாரத்திற்குள் உடன்படிக்கைப் பெட்டியின் முன்னால் வை. அந்த இடத்தில்தான் நான் உன்னைச் சந்திப்பேன். அவர்களில் ஒருவனை நான் உண்மையான ஆசாரியனாக தேர்ந்தெடுப்பேன். ");
INSERT INTO tam2008_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","நான் யாரைத் தேர்ந்தெடுப்பேனோ அவனது கைத்தடியில் இலைகள் துளிர்த்திருக்கும். இதன் மூலம் உனக்கும் எனக்கும் எதிராக முறையிடுபவர்களை நான் தடுப்பேன்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","இஸ்ரவேல் ஜனங்களிடம் மோசே பேசினான். ஒவ்வொரு 12 கோத்திரங்களின் தலைவரும் தங்கள் கைத்தடியை அவனிடம் கொடுத்தார்கள். மொத்தம் 12 கைத்தடிகளைப் பெற்றான். ஒவ்வொரு கோத்திரத்திற்கும் ஒரு கைத்தடி என்பதாக இருந்தது. ஒரு கைத்தடியில் ஆரோனுடைய பெயர் இருந்தது. ");
INSERT INTO tam2008_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","மோசே அனைத்து கைத்தடிகளையும் கர்த்தருக்கு முன்னால் உடன்படிக்கைக் கூடாரத்திற்குள் வைத்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","மறுநாள் மோசே கூடாரத்திற்குள் நுழைந்தபோது லேவியின் குடும்பத்திலிருந்து வந்த ஆரோனின் கைத்தடியில் புதிய இலைகள் துளிர் விட்டிருந்ததை மோசே பார்த்தான். அதில் கிளைகளும் தோன்றி வாதுமை பழங்களும் காணப்பட்டன. ");
INSERT INTO tam2008_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","மோசே கர்த்தரின் சமூகத்திலிருந்து கைத் தடிகளை எடுத்து வந்து, இஸ்ரவேல் ஜனங்களிடம் அவற்றைக் காட்டினான். அவரவர் தங்கள் கைத்தடிகளை பார்த்து எடுத்துக்கொண்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","பிறகு கர்த்தர் மோசேயிடம், “ஆரோனின் கைத்தடியை மீண்டும் கூடாரத்திற்குள் எனது உடன்படிக்கைப் பெட்டியின் முன்பாக வை. எப்போதும் எனக்கு எதிராகத் திருப்புவோருக்கு இது ஒரு எச்சரிக்கையாக இருக்கும். இது எனக்கு எதிராக அவர்கள் முறையிடுவதை தடுக்கும். எனவே அவர்களை நான் அழிக்கமாட்டேன்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","எனவே மோசே கர்த்தர் தனக்குக் கட்டளையிட்டபடி செய்து முடித்தான். ");
INSERT INTO tam2008_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","இஸ்ரவேல் ஜனங்கள் மோசேயிடம், “நாங்கள் மரித்துப்‌போவோம் என்பது எங்களுக்குத் தெரியும். நாங்கள் தொலைந்தோம். நாங்கள் அனைவரும் அழிந்து போவோம். ");
INSERT INTO tam2008_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","எவராவது கர்த்தரின் பரிசுத்த இடத்தின் அருகில் வந்தாலும் மரித்துப் போவார்கள். நாங்கள் அனைவரும் மரித்துப் போவோம் என்பது உண்மையா?” என்று கேட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","கர்த்தர் ஆரோனிடம், “நீயும், உனது மகன்களும், உன் தந்தையின் குடும்பத்தில் உள்ளவர்களுமே பரிசுத்தமான இடத்தில் ஏற்படும் தவறுகளுக்குப் பொறுப்பாவீர்கள். ஆசாரியர்களுக்கு எதிராக நடை பெறும் தவறுகளுக்கும் நீயும், உனது மகன்களும் பொறுப்பாவீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","உனது கோத்திரத்தில் உள்ள மற்ற வேவியர்களையும் உங்களோடுச் சேர்த்துக்கொள். ஆசரிப்புக் கூடாரத்தில் நீங்களும் உங்கள் மகன்களும் செய்யும் வேலைகளுக்கு அவர்கள் உதவுவார்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","லேவியரின் குடும்பத்தில் உள்ள அனைத்து ஜனங்களும் உங்கள் கட்டுபாட்டிற்குள் இருப்பார்கள். கூடாரத்திற்குள் செய்ய வேண்டிய அனைத்து வேலைகளையும் அவர்கள் செய்வார்கள். ஆனால் அவர்கள் பரிசுத்தமான இடத்தின் அருகிலோ, பலிபீடத்தின் அருகிலோ போகக்கூடாது. அவ்வாறு போனால் மரித்துப்போவார்கள். நீங்களும் மரித்துப்போவீர்கள். ");
INSERT INTO tam2008_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","அவர்கள் உங்களோடு சேர்ந்து வேலை செய்வார்கள். அவர்களே ஆசரிப்புக் கூடாரத்தைக் காக்கும் பொறுப்புள்ளவர்கள். கூடாரத்திற்குள் நடை பெற வேண்டிய அனைத்து வேலைகளையும் அவர்கள் செய்வார்கள். நீங்கள் இருக்கும் இடத்தில் உங்கள் அருகில் எவரும் வரக்கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“இஸ்ரவேல் ஜனங்கள் மீது திரும்பவும் கோபாக்கினை விழாதபடி நீங்கள் பரிசுத்த இடத்தையும் பலிபீடத்தையும் காக்கிற பொறுப்புடையவர்கள். நான் மீண்டும் இஸ்ரவேல் ஜனங்கள் மீது கோபம்கொள்ள விரும்பவில்லை. ");
INSERT INTO tam2008_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","அனைத்து இஸ்ரவேல் ஜனங்களிடமிருந்தும் நானே லேவியர்களைத் தேர்ந்தெடுத்தேன். அவர்கள் உங்களுக்கு ஒரு பரிசைப் போன்றவர்கள். நான், அவர்களை உங்களுக்காகக் கர்த்தருக்குச் சேவை செய்யவும், ஆசரிப்புக் கூடாரத்திற்குள் சில வேலைகளைச் செய்யவும் தந்தேன். ");
INSERT INTO tam2008_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","ஆனால் ஆரோனே! நீயும் உன் மகன்களும் மட்டும் ஆசாரியர்களாகப் பணிபுரிய வேண்டும். பலிபீடத்தின் அருகில் செல்லும் தகுதியுடையவர்கள் நீங்கள் மட்டுமே. மகாபரிசுத்த இடத்திற்குள் திரைக்குப் பின்னால் செல்லும் தகுதி உடையவர்களும் நீங்கள் மட்டுமே. ஆசாரியர்களாகப் பணிபுரிவதை உங்களுக்கு ஒரு பரிசாகக் கொடுத்திருக்கிறேன். வேறு எவராவது எனது பரிசுத்த இடத்திற்கு அருகில் வந்தால் கொல்லப்படுவார்கள்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","பிறகு கர்த்தர் ஆரோனிடம், “ஜனங்கள் எனக்குத் தருகிற எல்லா அன்பளிப்புகளுக்கும் உங்களையே பொறுப்பாளர்களாக ஆக்கினேன். இஸ்ரவேல் ஜனங்கள் கொடுக்கும் அனைத்து பரிசுத்தமான அன்பளிப்புகளையும் நான் உங்களுக்குத் தருகிறேன். அவற்றை நீயும் உனது மகன்களும் பங்கிட்டுக்கொள்ள வேண்டும். அவை எப்பொழுதும் உங்களுக்கு உரியது. ");
INSERT INTO tam2008_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","ஜனங்கள் பலிகளையும் தானியக் காணிக்கைகளையும், பாவப்பரிகார பலிகளையும், குற்றபரிகாரப் பலிகளையும் கொண்டு வருவார்கள். அவை மிகவும் பரிசுத்தமானவை. தகனம் செய்யப்படாத பலிகளெல்லாம் உங்கள் பங்காகக் கிடைக்கும். அவை உனக்கும் உன் மகன்களுக்கும் உரியதாகும். ");
INSERT INTO tam2008_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","அவற்றை மிகப் பரிசுத்தமான இடத்தில் வைத்துதான் உண்ண வேண்டும். உங்கள் குடும்பத்திலுள்ள ஒவ்வொரு ஆணும் உண்ணலாம். ஆனால் அவை பரிசுத்தமானவை என்பதை நீங்கள் மறக்கக் கூடாது. ");
INSERT INTO tam2008_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“இஸ்ரவேலர்கள் தரும் அசைவாட்டும் பலிகளும், உங்களுக்கு உரியதாகும். நான் அவற்றை உனக்கும், உன் மகன்களுக்கும், உனது மகள்களுக்கும் தருவேன். இது உனது பங்காகும். உன் குடும்பத்திலுள்ள தீட்டு இல்லாத எல்லாரும் அதனை உண்ணலாம். ");
INSERT INTO tam2008_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“அதோடு நான் உனக்கு சிறந்த ஒலிவ எண்ணெயையும், புதிய திராட்சைரசத்தையும், தானியத்தையும் தருவேன். இவை இஸ்ரவேல் ஜனங்களால் கர்த்தராகிய எனக்குக் கொடுக்கப்பட்டவை. இவை அறுவடையின் போது, முதலில் கிடைக்கப் பெற்றவையாயிருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","ஜனங்கள் அறுவடை செய்யும்போதெல்லாம் முதலில் கிடைத்ததைக் கர்த்தருக்குக் கொண்டு வரவேண்டும். அவற்றையெல்லாம் உனக்குத் தருவேன். உன் குடும்பத்தில் உள்ள தீட்டு இல்லாத ஒவ்வொருவரும் அவற்றை உண்ணலாம். ");
INSERT INTO tam2008_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“இஸ்ரவேல் ஜனங்களால் கர்த்தருக்குக் கொடுக்கப்படும் அனைத்தும் உங்களுக்கு உரியதாகும். ");
INSERT INTO tam2008_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","“ஒரு பெண்ணின் முதல் குழந்தையும் ஒரு மிருகத்தின் முதல் குட்டியும் கர்த்தருக்குக் கொடுக்கப்பட வேண்டும். அந்த விலங்கின் முதலீற்று தீட்டுள்ளதாக இருந்தால் கொடுப்பவரே அதைத் திரும்ப விலைக்கு வாங்கிக்கொள்ள வேண்டும். முதலில் பிறந்த குழந்தை காணிக்கையாகக் கொடுக்கப்படும்போது அதுவும் திரும்ப வாங்கப்பட வேண்டும். அப்பொழுது அக்குழந்தை மறுபடியும் அதே குடும்பத்திற்கு உரியதாகிவிடும். ");
INSERT INTO tam2008_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","அக்குழந்தை ஒரு மாத வயதுடையதாக இருந்தால், அதற்குரிய தொகையைக் கொடுக்கவேண்டும். அத்தொகை 2 அவுன்ஸ் வெள்ளியாகும். அது அதிகாரப் பூர்வமான அளவு முறையில் 5 சேக்கல் உடையதாக எடையிடப்பட வேண்டும். ஒரு சேக்கல் அதிகாரப் பூர்வமான அளவில் 20 கேராவாகும். ");
INSERT INTO tam2008_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“ஆனால் நீங்கள் முதலில் பிறந்த காளைக்கும், ஆட்டுக்கும், வெள்ளாட்டுக்கும் பணம் கொடுக்கக் கூடாது. அவை பரிசுத்தமானவை. அவற்றின் இரத்தத்தைப் பலிபீடத்தின்மேல் தெளிக்கவேண்டும். அவற்றின் கொழுப்பை எரிக்க வேண்டும். இது நெருப்பிலிடப்படும் தகனபலியாகும். இதின் மணம் கர்த்தருக்குப் பிரியமானதாயிருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","அவற்றின் இறைச்சியானது உங்களுக்கு உரியதாகும். அசை வாட்டும் பலியாகச் செலுத்தப்பட்ட மார்புக்கண்டமும், உங்களுக்கு உரியது. மற்ற பலிகளின் தொடைக்கறியும் உங்களுக்கு உரியது. ");
INSERT INTO tam2008_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","ஜனங்களால் கொடுக்கப்படும் பரிசுத்தமான அன்பளிப்புகளையும் கர்த்தராகிய நான் உங்களுக்குத் தருவேன். இது உங்கள் பங்காகும். நான் இவற்றை உனக்கும், உன் மகன்களுக்கும், உன் மகள்களுக்கும் தருவேன். இந்த சட்டம் எல்லாக் காலத்திற்கும் உரியதாகும். இது கர்த்தரோடு செய்யப்பட்ட உடன்படிக்கையாகும். இதனை உடைக்க முடியாது. நான் இந்த வாக்குறுதியை உனக்கும், உன் சந்ததிகளுக்கும் தந்துள்ளேன், இது மாறாததாகும்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","கர்த்தர் மேலும் ஆரோனிடம், “நீ எவ்வித நிலத்தையும் பெறமாட்டாய். மற்றவர்களுக்குச் சொந்தமான எதுவும் உனக்குச் செந்தமாவதில்லை. கர்த்தராகிய நானே உனக்கு உரியவர். இஸ்ரவேல் ஜனங்கள் நான் வாக்களித்தபடி நிலத்தைப் பெற்றுக்கொள்வார்கள். ஆனால் என்னை நானே உனக்கு சுதந்திரமாகத் தந்துள்ளேன். ");
INSERT INTO tam2008_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“இஸ்ரவேல் ஜனங்கள் தங்களுக்குரிய அனைத்திலும் பத்தில் ஒரு பங்கை உங்களுக்குத் தருவார்கள். எனவே நான் அந்தப் பத்தில் ஒன்றை லேவியின் சந்ததியினருக்குக் கொடுக்கிறேன். ஆசாரிப்புக் கூடாரத்தில் பணிபுரியும் அவர்களுக்கு இதுவே சம்பளமாகும். ");
INSERT INTO tam2008_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","ஆனால் இஸ்ரவேலரின் ஜனங்களில் மற்றவர்கள் ஆசரிப்புக் கூடாரத்தின் அருகில் சென்றால் அவர்கள் சாகடிக்கப்படுவர்! ");
INSERT INTO tam2008_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","ஆசரிப்புக் கூடாரத்திற்குள் பணியாற்றும் லேவியர்கள் இதற்கு எதிரான பாவங்களுக்குப் பொறுப்பாவார்கள். இந்த சட்டம் எல்லாக் காலத்திற்குரியதாகும். நான் மற்ற இஸ்ரவேல் ஜனங்களுக்கு வாக்களித்த நிலமானது லேவியர்களுக்கும் கிடைக்காது. ");
INSERT INTO tam2008_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","ஆனால் இஸ்ரவேல் ஜனங்கள் தங்களுக்குரிய அனைத்திலும் பத்தில் ஒரு பங்கை எனக்கு தருவார்கள். நான் அதனை லேவியர்களுக்குத் தருவேன். எனவே லேவியர்கள் மற்ற இஸ்ரவேலரைப் போல நிலம் எதையும் பெற்றுக்கொள்ளமாட்டார்கள்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","கர்த்தர் மோசேயிடம், ");
INSERT INTO tam2008_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“லேவியர்களிடம் இவற்றை கூறு: இஸ்ரவேல் ஜனங்கள் தங்களுக்குரிய அனைத்திலும் பத்தில் ஒரு பங்கை கர்த்தருக்குத் தருவார்கள். அவை லேவியர்களுக்கு உரியதாகும். ஆனால், நீங்கள் அதில் பத்தில் ஒரு பங்கைக் கர்த்தருக்குக் காணிக்கையாகக் கொடுக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","அறுவடையானதும் தானியத்தையும், திராட்சை ரசத்தையும் நீங்கள் பெறுவீர்கள். அவற்றையும் கர்த்தருக்குக் காணிக்கையாக செலுத்த வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","இவ்வாறு மற்ற இஸ்ரவேல் ஜனங்கள் செய்வது போலவே, நீங்களும் கர்த்தருக்குக் காணிக்கையைச் செலுத்தவேண்டும். ஜனங்கள் கர்த்தருக்குக் கொடுக்கும் பத்தில் ஒரு பங்கு உங்களுக்குரியது. உங்களுக்குக் கொடுக்கப்படும் பத்தில் ஒரு பங்கில், கர்த்தருக்கு ஒரு பங்கைத் தரவேண்டும். பிறகு ஆசாரியனாகிய ஆரோனுக்கும் அதில் பத்தில் ஒரு பங்கைக் கொடுக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","இஸ்ரவேல் ஜனங்கள் தங்களுக்குரிய அனைத்திலும் பத்தில் ஒரு பங்கைத் தரும்போது நீங்கள் அவற்றில் சிறந்த பரிசுத்தமானவற்றைத் தேர்ந்தெடுக்கவேண்டும். அவற்றையே நீங்கள் உங்கள் பாகத்தில் பத்தில் ஒரு பங்காகக் கர்த்தருக்குத் தரவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“மோசே, லேவியர்களிடம் கூறு: இஸ்ரவேல் ஜனங்கள் தங்கள் அறுவடையின் போது தானியத்திலும் திராட்சைரசத்திலும் பத்தில் ஒரு பங்கைத் தருவார்கள். நீங்கள் அவற்றில் சிறந்த பங்கைக் கர்த்தருக்குத் தரவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","மீதமுள்ளவற்றை நீங்களும் உங்கள் குடும்பத்தாரும் உண்ணலாம். நீங்கள் ஆசரிப்புக் கூடாரத்திற்குள் செய்யும் வேலைகளுக்கு இதுவே கூலியாகும். ");
INSERT INTO tam2008_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","நீங்கள் எப்போதும் உங்கள் பங்கிலுள்ள சிறந்த பகுதியை மட்டும் கர்த்தருக்குக் கொடுத்து வந்தால் பிறகு எப்போதும் நீங்கள் குற்றவாளியாகமாட்டீர்கள். அந்த அன்பளிப்புகளை எல்லாம் இஸ்ரவேல் ஜனங்களால் தரப்பட்டப் பரிசுத்த காணிக்கைகள் என்பதை எப்போதும் நினைவில் வைத்துக்கொள்ளவேண்டும், அப்போது நீங்கள் அழியமாட்டீர்கள்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","கர்த்தர் மோசேயிடமும், ஆரோனிடமும் பேசினார். அவர், ");
INSERT INTO tam2008_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“இந்த சட்டங்களெல்லாம் கர்த்தர் இஸ்ரவேல் ஜனங்களுக்குத் தந்த போதனைகளாகும். பழுதற்ற ஒரு சிவப்புப் பசுவைக் கொண்டு வாருங்கள். அப்பசு நுகத்தடியில் பூட்டப்படாததாகவும் ஊனமில்லாததாகவும் இருக்க வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","கன்று போடாத இளம் பசுவை ஆசாரியனாகிய எலெயாசாரிடம் கொடுங்கள். அவன் அதை வெளியே கொண்டுப்போய் கொல்லவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","பிறகு எலெயாசார் அதன் இரத்தத்தில் கொஞ்சம் தன் விரல்களால் தொட்டு பரிசுத்த கூடாரத்திற்குள் தெளிக்கவேண்டும். இவ்வாறு அவன் ஏழு முறை செய்யவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","பின்பு அவன் கண்களுக்கு முன்னால் அந்தப் பசுவின் தோல், சதை, இரத்தம், குடல் அனைத்தும் எரிக்கப்பட வேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","பிறகு, ஆசாரியர் கேதுருக் கட்டையையும், ஈசோப்பையும், சிவப்பு நூலையும் எடுத்து காளை எரிக்கப்படும் இடத்தில் போடவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","பின்னர் ஆசாரியன் தன்னையும், தனது உடைகளையும் தண்ணீரால் சுத்தம் செய்ய வேண்டும். அதற்குப்பின் அவன் கூடாரத்திற்குள் வரவேண்டும். அவன் மாலைவரை தீட்டாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","காளையை எரித்தவனும் தன்னைக் கழுவி உடலைச் சுத்தமாக்க வேண்டும். மேலும் தனது ஆடையையும் தண்ணீரால் கழுவ வேண்டும். அவனும் அன்று மாலைவரை தீட்டாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“பிறகு தீட்டு இல்லாத ஒருவன் எரிந்துபோன காளையின் சாம்பலைச் சேகரித்து அவற்றைக் கூடாரத்திற்கு வெளியே சுத்தமான இடத்தில் கொட்ட வேண்டும். ஜனங்கள் இதனை தம்மை சுத்தப்படுத்திக்கொள்ளும் சடங்குகளில் பயன்படுத்திக்கொள்ளலாம். இச்சாம்பல் ஒருவனின் பாவத்தைப் போக்கவும் பயன்படும். ");
INSERT INTO tam2008_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","“காளையின் சாம்பலைச் சேகரித்தவன் தனது ஆடைகளைத் துவைக்கவேண்டும். அவன் அன்று மாலைவரை தீட்டாக இருப்பான். “இந்த விதிகள் எல்லாக் காலத்துக்கும் இஸ்ரவேல் ஜனங்கள் அனைவருக்கும் உரியதாக்கும். இந்த விதி உங்களோடு வாழ்கிற அயல் நாட்டவருக்கும் உரியதாகும். ");
INSERT INTO tam2008_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","எவனாவது, மரித்துப்போனவனின் சரீரத்தை தொட்டால், அவன் ஏழு நாட்களுக்குத் தீட்டுள்ளவனாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","அவன் தன்னைத் தீட்டுக்கழிக்கும் தண்ணீரால் மூன்றாவது நாளும், ஏழாவது நாளும் கழுவவேண்டும். அவ்வாறு அவன் செய்யாவிட்டால் தொடர்ந்து அவன் தீட்டுள்ளவனாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","ஒருவன் ஒரு மரித்த சரீரத்தைத் தொட்டால், அவன் தீட்டுள்ளவன் ஆகிறான். அவன் தீட்டுள்ளவனாக பரிசுத்த கூடாரத்திற்குள் சென்றால், அதுவும் தீட்டாகிவிடும். எனவே அவன் இஸ்ரவேல் ஜனங்களிடமிருந்து தனியே பிரித்து வைக்கப்படுவான். தீட்டுள்ளவன் மேல் தீட்டுக்கழிக்கும் தண்ணீர் தெளிக்கப்படாவிட்டால், அவன் தொடர்ந்து தீட்டுள்ளவனாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“இவை அனைத்தும் தங்கள் கூடாரத்திற்குள் மரித்துப் போகிறவர்களைப் பற்றிய விதிகளாகும். ஒருவன் தனது கூடாரத்தில் மரித்தால், அக்கூடாரத்திலுள்ள அனைத்துப் பொருட்களும் தீட்டாகும். அவை ஏழு நாட்களுக்குத் தீட்டுள்ளவையாக இருக்கும். ");
INSERT INTO tam2008_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","ஒவ்வொரு ஜாடியும், பாத்திரமும் மூடப்படாமல் இருந்தால் தீட்டாகும். ");
INSERT INTO tam2008_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","வெளியிலே எவனாவது பிணத்தைத் தொட்டால், ஏழு நாட்களுக்குத் தீட்டுள்ளவனாக இருப்பான். போரில் கொல்லப்பட்டவனையோ, மரித்தவனின் எலும்பையோ தொட்டாலும் அவன் தீட்டுள்ளவன் ஆவான். ");
INSERT INTO tam2008_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“எனவே அவனை மீண்டும் சுத்தப்படுத்த எரித்த காளையின் சம்பலை நீங்கள் பயன்படுத்தவேண்டும். ஒரு ஜாடிக்குள் சாம்பலைப்போட்டு தண்ணீரை அதில் விடவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","தீட்டில்லாத ஒருவன் ஈசோப்புக் கிளையை எடுத்து அதை தண்ணீரில் நனைக்கவேண்டும். பிறகு அதனைக் கூடாரம், சகல பொருட்கள், ஜனங்கள் ஆகியவற்றின் மீது தெளிக்கவேண்டும். மரித்த மனிதனின் சரீரத்தைத் தொட்டவன் மீதும் இவ்வாறு தெளிக்க வேண்டும். போரில் கொல்லப்பட்ட ஒருவனைத் தொட்டவன் மீதும், மரித்துப் போனவனின் எலும்புகளைத் தொட்டவன் மீதும் இவ்வாறு தெளிக்கவேண்டும். ");
INSERT INTO tam2008_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","“தீட்டு இல்லாத ஒருவன், இத்தண்ணீரை தீட்டுள்ளவன் மீது மூன்றாவது நாளும், ஏழாவது நாளும் தெளிக்கவேண்டும். ஏழாவது நாள் தீட்டுள்ளவன் சுத்தமாவான். அவன் தனது ஆடையை தண்ணீரில் துவைக்கவேண்டும். மாலையில அவன் சுத்தமாகிவிடுவான். ");
INSERT INTO tam2008_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“ஒருவன் தீட்டுள்ளவனாகி அதிலிருந்து சுத்தமாகாமல் இருந்தால் அவனை இஸ்ரவேல் ஜனங்களிடமிருந்து ஒதுக்கி வைக்கவேண்டும். அவன் மீது தீட்டுக்கழிக்கும் தண்ணீர் தெளிக்கப்படாததால் அவன் சுத்தமாகவில்லை: ஆகையால், அவன் பரிசுத்தக் கூடாரத்தையும் தீட்டாக்கிவிடுவான். ");
INSERT INTO tam2008_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","இந்த விதி எல்லாக் காலத்திற்கும் உரியது, ஒருவன் தீட்டுக்கழிக்கும் தண்ணீரால் தெளிக்கப்பட்டாலும் அவன் தன் ஆடைகளை தண்ணீரில் துவைக்க வேண்டும். தீட்டுக்கழிக்கும் தண்ணீரைத் தொடுகிற எவனும் மாலைவரை தீட்டுள்ளவனாக இருப்பான். ");
INSERT INTO tam2008_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","தீட்டுள்ள ஒருவன் யாரையாவது தொட்டால் அவனும் தீட்டுள்ளவனாவான். அவன் மாலைவரை தீட்டுள்ளவனாக இருப்பான்” என்று கூறினார். ");
INSERT INTO tam2008_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","இஸ்ரவேல் ஜனங்கள் முதல் மாதத்தில் சீன் பாலைவனத்தை அடைந்தனர். ஜனங்கள் காதேசில் தங்கியிருந்தபோது மிரியாம் மரணமடைந்தாள். அவள் அங்கேயே அடக்கம் செய்யப்பட்டாள். ");
INSERT INTO tam2008_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","அந்த இடத்தில் ஜனங்களுக்குப் போதுமான தண்ணீர் இல்லை. எனவே ஜனங்கள் ஒன்று கூடி வந்து இதைப்பற்றி மோசேயிடமும் ஆரோனிடமும் முறையிட்டனர். ");
INSERT INTO tam2008_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","அவர்கள், மோசேயிடம் விவாதித்து, “எங்கள் சகோதரர்களைப் போலவே நாங்களும் இந்த இடத்தில் கர்த்தர் முன்னால் மரித்துப்போயிருக்கவேண்டும்? ");
INSERT INTO tam2008_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","எதற்காக கர்த்தருடைய ஜனங்களை இந்தப் பாலைவனத்துக்கு அழைத்து வந்தீர்கள்? நாங்களும் எங்கள் மிருகங்களும் இங்கேயே மரித்துப் போகவேண்டும் என்று விரும்புகின்றீரா? ");
INSERT INTO tam2008_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","எங்களை எகிப்திலிருந்து இந்த மோசமான இடத்திற்கு ஏன் அழைத்து வந்தீர்கள்? இங்கே தானியங்கள் இல்லை. அத்திமரமும், திராட்சை செடிகளும், மாதளஞ் செடியும், குடிக்க தண்ணீர் கூட இல்லையே” என்றனர். ");
INSERT INTO tam2008_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","எனவே, மோசேயும் ஆரோனும் கூட்டத்தை விட்டு விலகி ஆசரிப்புக் கூடாரத்தின் வாசலுக்குச் சென்று அங்கே அவர்கள் தரையில் விழுந்து வணங்கினார்கள். கர்த்தருடைய மகிமை அவர்களுக்குக் காணப்பட்டது. ");
INSERT INTO tam2008_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","கர்த்தர் மோசேயோடு பேசினார். ");
INSERT INTO tam2008_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","அவர், “சிறப்புக்குரிய உன் கைத் தடியை எடுத்துக்கொள். உனது சகோதரன் ஆரோனையும் ஜனங்கள் கூட்டத்தையும் அழைத்துக்கொண்டு பாறையின்மீது போ. ஜனங்கள் முன்னால் பாறையோடு பேசு. பிறகு பாறையிலிருந்து தண்ணீர் சுரந்து வரும். அந்த தண்ணீரை நீ ஜனங்களுக்கும் மிருகங்களுக்கும் தரலாம்” என்றார். ");
INSERT INTO tam2008_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","பரிசுத்தக் கூடாரத்திற்குள் கர்த்தர் முன்னிலையில் கைத்தடி இருந்தது. கர்த்தர் சொன்னபடியே மோசே கைத்தடியை எடுத்துக்கொண்டான். ");
INSERT INTO tam2008_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","மோசேயும், ஆரோனும் ஜனங்களிடம் பாறையின் முன்னால் கூடுமாறு சொன்னார்கள். பிறகு மோசே, “நீங்கள் எப்போதும் முறையிடுகிறீர்கள். இப்போது நான் சொல்வதைக் கவனியுங்கள். நான் இந்த பாறையிலிருந்து தண்ணீர் வரும்படி செய்வேன்” என்றான். ");
INSERT INTO tam2008_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","மோசே தன் கையை உயர்த்தி பாறையின் மீது தனது கோலால் இருமுறை அடித்தான். தண்ணீர் பாறையிலிருந்து பீறிட்டு வெளியே வந்தது. ஜனங்களும் மிருகங்களும் அந்த தண்ணீரைக் குடித்தனர். ");
INSERT INTO tam2008_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","ஆனால் கர்த்தர் மோசேயிடமும் ஆரோனிடமும், “அனைத்து இஸ்ரவேல் ஜனங்களும் இங்கே கூடியுள்ளனர். ஆனால் நீங்கள் என்னை கனப்படுத்தவில்லை. தண்ணீரை பெறும் வல்லமை என்னிடமிருந்து வந்ததை நீங்கள் ஜனங்களுக்கு காண்பிக்கவில்லை. நீங்கள் என்னில் நம்பிக்கை வைத்திருக்கிறீர்கள் என்பதையும் ஜனங்களிடம் காட்டவில்லை. ஆகையால் நான் அவர்களுக்கு