﻿USE sofia;
DROP TABLE IF EXISTS sofia.taj_vpl;
CREATE TABLE taj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES taj_vpl WRITE;
INSERT INTO taj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","चुरी भ्रिबा म्‍हिला मिनगदे येशू ख्रीष्‍टला वंशला हिन्‍ना। येशू ख्रीष्‍ट दाऊदला वंशरी न्‍हबा हिन्‍ना, ओच्‍छे दाऊद अब्राहामला वंशरी न्‍हबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","अब्राहामला झा इसहाक मुबा, इसहाकला झा याकूब, याकूबला झा यहूदादेन थेला ज्‍योज्‍यो आलेगदे मुबा। ");
INSERT INTO taj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","यहूदाला झा फारेसदेन जाहेर मुबा। थेनीगदेला आमा तामार मुबा, फारेसला झा हेस्रोन, हेस्रोनला झा आराम, ");
INSERT INTO taj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","आरामला झा अम्‍मीनादाब, अम्‍मीनादाबला झा नहशोन, नहशोनला झा सल्‍मोन, ");
INSERT INTO taj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","सल्‍मोनला झा बोअज मुबा, थेला आमा राहाब मुबा, बोअजला झा ओबेद मुबा, थेला आमा रूथ मुबा, ओबेदला झा यिशै, ");
INSERT INTO taj_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","यिशैला झा दाऊद ग्‍ले मुबा, दाऊद ग्‍लेला सन्‍तान सोलोमन मुबा, सोलोमनला आमा चा ङाच्‍छा उरियाहला म्रिङ मुबा। ");
INSERT INTO taj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","सोलोमनला झा रहबाम, रहबामला झा अबिया, अबियाला झा आश, ");
INSERT INTO taj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","आशला झा यहोशापात, यहोशापातला झा यहोराम, यहोरामला झा उज्‍जियाह, ");
INSERT INTO taj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","उज्‍जियाहला झा योताम, योतामला झा आहाज, आहाजला झा हिजकिया, ");
INSERT INTO taj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","हिजकियाला झा मनश्‍शे, मनश्‍शेला झा आमोन, आमोनला झा योशियाह, ");
INSERT INTO taj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","योशियाहला झा यकोनियासदेन थेला आलेगदेला आबा मुबा। थेनीगदे यहूदीगदेदा चुङ्सी बेबिलोन भिबा ग्‍लारी भोर्बा भन्‍दा ङाच्‍छान न्‍हबा मुबा। ");
INSERT INTO taj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","बेबिलोनरी भोर्माहेन्‍से यकोनियासला झा शालतिएल न्‍हजी, ओच्‍छे शालतिएलला झा यरुबाबेल, ");
INSERT INTO taj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","यरुबाबेलला झा अबिउद, अबिउदला झा एल्‍याकीम, एल्‍याकीमला झा आजोर, ");
INSERT INTO taj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","आजोरला झा सादोक, सादोकला झा आखिम, आखिमला झा एलिउद, ");
INSERT INTO taj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","एलिउदला झा एलाजार, एलाजारला झा मत्तान, मत्तानला झा याकूब, ");
INSERT INTO taj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","याकूबला झा योसेफ मुबा, योसेफसे मरियमदा ब्‍याह लजी। थेनोन मरियमग्‍याम येशू न्‍हजी, थेदा जम्‍मासेन थार्बा पिन्‍बा ख्रीष्‍ट भिसी भिला। ");
INSERT INTO taj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","चुह्रङ् लसी अब्राहामहेन्‍से दाऊदधोना च्‍युक ब्‍लि पुस्‍ता मुबा, थेह्रङ् लसीन दाऊदहेन्‍से यहूदीगदे बेबिलोनरी भोर्बा धुइधोना च्‍युक ब्‍लि पुस्‍ता मुबा, ओच्‍छे बेबिलोनरी भोर्बा धुइहेन्‍से थार्बा पिन्‍बा ख्रीष्‍ट न्‍हबा धुइधोना च्‍युक ब्‍लि पुस्‍ता मुबा। ");
INSERT INTO taj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","येशू ख्रीष्‍ट चुह्रङ् लसी न्‍हजी, योसेफसे येशूला आमादा ब्‍याह लबारी ह्रीबा मुबा। तर थेनीगदेला ब्‍याह तबा भन्‍दा ङाच्‍छान मरियम परमेश्‍वरला आत्‍माग्‍याम न्‍हसेला तबा मुबा। ");
INSERT INTO taj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","तर थेला ह्रेम्‍बो योसेफ परमेश्‍वरला ङाच्‍छा ज्‍यबा म्‍हि तबासे लमा थेदा म्‍हिला ओन्‍छाङरी पेःना थालगै भिसी खालैसे था आयाङ्ना लसी ख्‍लाबा सेम लजी। ");
INSERT INTO taj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","चु ताम म्‍हन्‍बान लमा योसेफ छुप निजी, जमाहेन्‍से म्‍हाङरी थे मुबा ग्‍लारी परमप्रभुला दूत खसी थेदा “दाऊद ग्‍लेला सन्‍तान योसेफ, ए मरियमदेन ब्‍याह लबारी थालोङ्‍गो। तिग्‍दा भिसम थे परमेश्‍वरला आत्‍माग्‍याम न्‍हसेला तबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","थेसे झा गिक न्‍हला, एसे थेला मिन येशू थान्‍गो। तिग्‍दा भिसम थेसे ह्राङला म्‍हिगदेदा थेनीगदेला पापग्‍याम थार्ना लला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","परमप्रभुसे अगमवक्ताग्‍याम सुङ्बा बचन पूरा तगै भिसीन चु जम्‍मान तबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“च्‍यागो, ब्‍याह आलबा म्रिङकोला गिक न्‍हसेला तला ओच्‍छे थेसे झा न्‍हला, थेला मिन इम्‍मानुएल भिसी थान्‍ना,” इम्‍मानुएल भिबा चा “परमेश्‍वर य्‍हाङदेन छ्‌याम” भिबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","योसेफ छोर्माहेन्‍से परमप्रभुला दूतसे पाङ्बा ह्रङ् थेसे मरियमदा ब्‍याह लजी। ");
INSERT INTO taj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","तर मरियमसे कोला आन्‍हतेधोना योसेफ मरियमदेन छ्‌याम आम्‍हेर्नी। मरियमसे कोला न्‍हमाहेन्‍से योसेफसे कोलाला मिन येशू थान्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","हेरोद ग्‍लेला धुइरी यहूदिया अञ्‍चलला बेथलेहेम भिबा नाम्‍सारी येशू न्‍हजी। जमाहेन्‍से स्‍यारला ज्‍योतिषीगदे यरूशलेमरी खजी, ओच्‍छे थेनीगदेसे, ");
INSERT INTO taj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“यहूदीगदेला ग्‍ले दोसी न्‍हबा कोला खानङ मुला? तिग्‍दा भिसम ङन्‍से स्‍याररी थे न्‍हजी भिसी उन्‍बा सार म्राङ्जी। थेतबासेलमा ङनी थेदा झ्‍याल्‍बारी खबा हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","चु ताम थेःमाहेन्‍से हेरोद ग्‍लेदेन यरूशलेमरी मुबा जम्‍मान म्‍हिगदेदा ल्‍हानान सुर्दा तजी। ");
INSERT INTO taj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","जमाहेन्‍से हेरोद ग्‍लेसे परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी धर्मगुरुगदे जम्‍मादान ग्‍ला गिकरी ङ्‌योइसी “थार्बा पिन्‍बा ख्रीष्‍ट खानङ न्‍हला भिसी पाङ्बा मुला?” भिसी ङ्‌योइबा छार्बा लजी। ");
INSERT INTO taj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","थेनीगदेसे हेरोद ग्‍लेदा “यहूदियाला बेथलेहेम भिबा नाम्‍सारी न्‍हला भिसी पाङ्बा मुला, तिग्‍दा भिसम अगमवक्तासे चुह्रङ् लसी भ्रिबा मुला, ");
INSERT INTO taj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘यहूदिया अञ्‍चलरी मुबा बेथलेहेम नाम्‍सा जजा मुसैनोन घ्रेन तला, तिग्‍दा भिसम बेथलेहेमग्‍याम शासन लबा म्‍हि गिक थोन्‍ना, थेसे ङाला म्‍हि इस्राएलीगदेदा वास्‍ता लला’ भिसी भिजी।” ");
INSERT INTO taj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","जमाहेन्‍से हेरोदसे थे ज्‍योतिषीगदेदा जे सुटुक्‍क ङ्‌योइसी सार खाइमा म्राङ्बा हिन्‍ना, भिसी ङ्‌योइबा छार्बा लजी। ओच्‍छे थेनीगदेग्‍याम सार म्राङ्बा धुइ था याङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","जमाहेन्‍से थेसे थेनीगदेदा “निउ, ओच्‍छे थे कोलादा ज्‍यना लसी म्‍हाइगो। थेदा स्‍याप्‍मैछ्‌याम ङादा पाङ्‍गो, ङाएनोन थेदा झ्‍याल्‍बारी निला” भिसी बेथलेहेमरी पुइजी। ");
INSERT INTO taj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ग्‍लेला ताम थेःसी थेनीगदे थेग्‍याम निजी। थेनीगदेसे ङाच्‍छा स्‍याररी म्राङ्बा सार दोःसी थेनीगदेला ङाच्‍छा ङाच्‍छा निजी, ओच्‍छे लैनु येशू मुबा ग्‍लारी धोमाहेन्‍से थे सार अडेब तजी। ");
INSERT INTO taj_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","थे सार म्राङ्माहेन्‍से थेनीगदे ल्‍हानान ताङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","दिम न्‍हङरी वाङ्मा थेनीगदेसे लैनु येशूदा थेला आमा मरियमदेन छ्‌याम म्राङ्जी, जमाहेन्‍से थेनीगदेसे येशूदा फ्‍या लसी ह्राङ ह्राङला बाकस ठोङ्सी म्‍हर, ज्‍यबा बास्‍ना खबा धूपदेन मूर्र भिबा महँगो अत्तर भसी फुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ओच्‍छे म्‍हाङरी परमेश्‍वरसे थेनीगदेदा हेरोद मुबा ग्‍लारी थानिउ भिबासे लमा थेनीगदे अर्गुन ग्‍यामसे ह्राङला य्‍हुल्‍सारी निजी। ");
INSERT INTO taj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ज्‍योतिषीगदे निमाहेन्‍से, परमप्रभुला दूत गिक म्‍हाङरी योसेफ मुबा ग्‍लारी खजी, ओच्‍छे थेसे योसेफदा “योसेफ, ए रेःसी लैनु कोलादेन थेला आमादा भोर्सी मिश्र य्‍हुल्‍सारी निउ। ओच्‍छे ङाइ एदा दोःसी खउ भिसी आपाङ्तेधोना एनीगदे थेरीन चिउ। तिग्‍दा भिसम हेरोदसे लैनु कोलादा साइबारी म्‍हाइबा मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","जमाकुनु म्‍हुनङनोन रेःसी थेसे लैनु कोलादेन थेला आमादा भोर्सी मिश्र य्‍हुल्‍सारी निजी। ");
INSERT INTO taj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ओच्‍छे हेरोद आसितेधोना थेनीगदे थेरीन चिजी। चुह्रङ् लसी परमप्रभुसे अगमवक्ताग्‍याम “ङाइ ङाला झादा मिश्र य्‍हुल्‍साग्‍याम ङ्‌योइबा मुला” भिसी सुङ्बा बचन पूरा तबारी हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","जमाहेन्‍से ह्राङदा ज्‍योतिषीगदेसे झुक्‍याब लजीम भिबा था याङ्सी हेरोद ल्‍हानान बोमो खजी। ओच्‍छे थेसे ज्‍योतिषीगदेग्‍याम था याङ्बा धुइ अन्‍छार बेथलेहेम नाम्‍सादेन क्‍यारक्‍युर मुबा न्‍ही दिङधोनाला जम्‍मान कोलागदेदा साइपुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","जमाहेन्‍से यर्मिया अगमवक्तासे पाङ्बा ताम पूरा तजी, ");
INSERT INTO taj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“रामा भिबा ग्‍लारी क्राबा क्रिङ्बा लबा थेःजी, राहेल ह्राङला कोलागदेला लागिरी क्राबान मुबा। थेदा जम्‍मासेन सम्‍झब लसैनोन क्राबा आख्‍लानी। तिग्‍दा भिसम थेला कोलागदे साइसी जिन्‍बा मुबा।” ");
INSERT INTO taj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ओच्‍छे हेरोद सिमाहेन्‍से, मिश्र य्‍हुल्‍सारी परमप्रभुला दूत गिक म्‍हाङरी योसेफ मुबा ग्‍लारी खजी, ओच्‍छे थेदा स्‍वर्गदूतसे, ");
INSERT INTO taj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“योसेफ, ए रेःसी लैनु कोलादेन थेला आमादा इस्राएल य्‍हुल्‍सारी भोर्सी निउ। तिग्‍दा भिसम लैनु कोलादा साइबारी म्‍हाइबा म्‍हिगदे जम्‍मान सिसी जिन्‍बा मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","जमाहेन्‍से थे रेःसी लैनु कोलादेन थेला आमादा इस्राएल य्‍हुल्‍सारी भोर्सी निजी। ");
INSERT INTO taj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","23","तर यहूदियारी हेरोदला झा अर्खिलाउस ग्‍ले दोबा मुला भिबा थेःसी थेनीगदे थेरी निबारी लोङ्जी। थेतबासेलमा दोःसी परमेश्‍वरसे थेदा म्‍हाङरी पाङ्बा अन्‍छार गालील अञ्‍चलला नासरत भिबा नाम्‍सारी निसी चिजी। चुह्रङ् लसी “थेदा नासरी भिला” भिसी अगमवक्तागदेग्‍याम पाङ्बा ताम पूरा तजी। ");
INSERT INTO taj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ल्‍हानान दिङ लिच्‍छा बप्‍तिस्‍मा पिन्‍बा यूहन्‍ना यहूदिया अञ्‍चलला तोङतोङबा ग्‍लारी खसी चुह्रङ् भिसी पाङ्‌बारी छ्‌याइजी, ");
INSERT INTO taj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःगो, तिग्‍दा भिसम स्‍वर्गला य्‍हुल्‍सा खसी जिन्‍बा मुला।” ");
INSERT INTO taj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","यशैया अगमवक्तासे चुनोन यूहन्‍नाला बारेरी चुह्रङ् भिसी पाङ्बा मुला, “तोङतोङबा ग्‍लारीक्‍यार परमप्रभुला ग्‍याम तयार लउ, ओच्‍छे ‘परमप्रभु भ्रबाला लागिरी थेला ग्‍याम सोजो स्‍होउ,’ भिसी म्‍हि गिक क्रिङ्बा मुला।” ");
INSERT INTO taj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","यूहन्‍नासे ऊँटला क्राला क्‍वान क्‍वान्‍मुबा, ओच्‍छे ढिला पेटी खीमुबा। थेसे तिरीदेन ह्रि सिङसोरला खुदु चमुबा। ");
INSERT INTO taj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","यरूशलेम शहरदेन यहूदिया अञ्‍चल ओच्‍छे यर्दन स्‍योङला क्‍यारक्‍युरला जम्‍मान ग्‍लाला म्‍हिगदे थे मुबा ग्‍लारी खजी। ");
INSERT INTO taj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ओच्‍छे ह्राङ ह्राङला पाप ख्‍लासी थेग्‍याम यर्दन स्‍योङरी बप्‍तिस्‍मा किन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","तर फरिसीगदेदेन सदुकीगदे न्‍हङला ल्‍हानान म्‍हिगदे बप्‍तिस्‍मा किन्‍बारी खबान लबा म्राङ्सी थेसे थेनीगदेदा “पुख्रीला कोलागदे, एनीगदेदा परमेश्‍वरला बोमोग्‍याम स्‍योरम्‍याङ्ला भिसी खाल्‍से भिजी? ");
INSERT INTO taj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","थेतबासेलमा ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःबा अन्‍छारला गे लउ। ");
INSERT INTO taj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","एनीगदेसे ङाला ताम ङ्‌यान्‍गो, एनीगदेसे ‘ङनी अब्राहामला सन्‍तान हिन्‍ना’ भिदेमा परमेश्‍वरला सजायग्‍याम स्‍योरम्‍याङ्ला भिसी थाम्‍हन्‍गो। तिग्‍दा भिसम परमेश्‍वरसे अब्राहामला लागिरी चु युङबागदेग्‍यामसेनोन कोलागदे स्‍होबारी खम्‍ला। ");
INSERT INTO taj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","च्‍यागो, दोङ थाबारी तरी थीसी जिन्‍बा मुला। थेतबासेलमा ज्‍यबा रो आरोबा जम्‍मान दोङ टाहेन्‍सेन थासी मेरी भ्‍याङ्‍ला। ");
INSERT INTO taj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“ङाइ चा एनीगदेसे ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःजी भिसी क्‍युइसे बप्‍तिस्‍मा पिन्‍ना। तर ङा भन्‍दा लिच्‍छा फेप्‍खबासे एनीगदेदा परमेश्‍वरला आत्‍मादेन मेसे बप्‍तिस्‍मा पिन्‍ना। थे ङा भन्‍दा शक्तिशाली मुला। ओच्‍छे ङा थेला लखम पुइबाधोनाला सुत्तै आरे। ");
INSERT INTO taj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ग्‍वा य्‍हाप्‍बा नाख्‍ले थेलान छ्‌यारी मुला, दाहेन्‍से ग्‍वा ज्‍यना लसी य्‍हाप्‍सी ग्‍वा जति भकारीरी थान्‍ना ओच्‍छे पोलोवा जति खाइमै आसिबा मेरी ख्राङ्ला।” ");
INSERT INTO taj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","जमाहेन्‍से येशूएनोन यूहन्‍ना ग्‍याम बप्‍तिस्‍मा किन्‍बारी गालील अञ्‍चलग्‍याम यर्दन स्‍योङरी फेप्‍खजी। ");
INSERT INTO taj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","तर यूहन्‍नासे थेदा “ङाइ चा ह्राङग्‍याम बप्‍तिस्‍मा किन्‍तोःबा मुला, तिग्‍दा ह्राङ चा ङा मुबा ग्‍लारी फेप्‍खबा?” भिसी रोकब लबारी म्‍हाइजी। ");
INSERT INTO taj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","तर येशूसे थेदा “दान्‍देदा चुह्रङ्‌नोन तगै। तिग्‍दा भिसम परमेश्‍वरसे म्‍हन्‍बा ताम पूरा लबारी य्‍हाङसे चुह्रङ्‌नोन लतोःला” भिसी सुङ्जी। जमाहेन्‍से यूहन्‍नासे येशूदा बप्‍तिस्‍मा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ओच्‍छे येशूसे बप्‍तिस्‍मा किन्‍सी क्‍युइग्‍याम पाखारी थोन्‍मैछ्‌याम थेसे स्‍वर्ग ठोङ्सी परमेश्‍वरला आत्‍मा ढुकुर ह्रङ् लसी फाप्‍सी ह्राङथोरी फेप्‍खबान लबा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","जमाहेन्‍से स्‍वर्गग्‍याम “चु ङाइ सेमहेन्‍सेन माया लबा ङाला झा हिन्‍ना, चुदा म्राङ्सी ङा ल्‍हानान ताङ्‍बा मुला” भिबा काइ खजी। ");
INSERT INTO taj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","जमाहेन्‍से परमेश्‍वरला आत्‍मासे शैतानग्‍याम सेम च्‍याबारी येशूदा तोङतोङबा ग्‍लारी भोर्जी। ");
INSERT INTO taj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","थेरी बोगल न्‍ही धिनधोना येशूसे धिन म्‍हुननोन तिगै आसोल्‍नी। थेतबासेलमा थेदा ल्‍हानान फोख्रेन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","जमाहेन्‍से शैतान येशू मुबा ग्‍लारी खसी “ह्राङ परमेश्‍वरला झा हिन्‍सम चु युङबागदेदा गेङ दोगो भिसी सुङ्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","तर येशूसे “गेङसे जे म्‍हि आसो, तर परमेश्‍वरला सुङग्‍याम थोन्‍बा जम्‍मान बचनसे सोबारी खम्‍ला भिसी परमेश्‍वरला बचनरी भ्रिबा मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","जमाहेन्‍से शैतानसे येशूदा परमेश्‍वरला शहर यरूशलेमरी भोर्सी परमेश्‍वरला मन्‍दिरला थोबोरी राप्‍पुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ओच्‍छे थेसे येशूदा “ह्राङ परमेश्‍वरला झा हिन्‍सम चुग्‍याम मार छ्‌योङ्‍गो। तिग्‍दा भिसम बचनरी चुह्रङ् भिसी भ्रिबा मुला, ‘परमेश्‍वरसे ह्राङदा चुङ्बाला लागिरी ह्राङला स्‍वर्गदूतगदेदा कुल्‍ला। ओच्‍छे एला काङ युङबारी थाठोक्‍गै भिसी एदा थेनीगदेसे या यारीन ताला’ भिसी भिजी।” ");
INSERT INTO taj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","येशूसे थेदा “बचनरी चुह्रङ् लसी भ्रिबा मुला, ‘एसे ह्राङला परमप्रभु परमेश्‍वरला सेम च्‍याबा गे तिगै थालउ’” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","दोःसी शैतानसे येशूदा नोबा गङ गिकरी भोर्सी जम्‍बुलिङला जम्‍मान य्‍हुल्‍सागदेदेन जम्‍मान ज्‍यबा स्‍हेगदे उन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ओच्‍छे “ह्राङसे ङादा फ्‍या लसी तेन्‍जी भिसम चु जम्‍मान य्‍हुल्‍सा ङाइ ह्राङदा पिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","जमाहेन्‍से येशूसे थेदा “शैतान, ए चुग्‍याम तुरुन्‍तन निउ! तिग्‍दा भिसम बचनरी ‘एसे ह्राङला परमप्रभु परमेश्‍वरदा फ्‍या लउ, ओच्‍छे थेदा जे तेन्‍गो’ भिसी भ्रिबा मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","जमाहेन्‍से शैतानसे येशूदा ख्‍लासी निजी ओच्‍छे स्‍वर्गदूतगदे खसी येशूदा क्‍योङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","यूहन्‍ना झ्‍याल्‍खानरी परब तजी भिबा थेःसी येशू दोःसी गालील अञ्‍चलरी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ओच्‍छे नासरत भिबा ग्‍लारी आफेप्‍ना कफर्नहुम शहररी धन्‍छ्‌याबारी फेप्‍जी। चु शहर गालील समुन्‍द्रला कुनीरी मुबा, चु शहर चा जबूलूनदेन नप्‍ताली भिबा य्‍हुलला म्‍हिगदे चिबा जिल्‍लारी परब तमुबा। ");
INSERT INTO taj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","चुह्रङ् लसी यशैया अगमवक्तासे पाङ्बा ताम पूरा तजी, ");
INSERT INTO taj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“जबूलूनदेन नप्‍तालीला जिल्‍लारी यर्दन क्‍याम्‍सङ, समुन्‍द्रला कुनीरी, यर्दन क्‍याम्‍सङ, गालीलरी चिबा अर्गु य्‍हुलला म्‍हिगदे ");
INSERT INTO taj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ओच्‍छे धोपधोपरी चिबा म्‍हिगदेसे घ्रेन य्‍हालदा म्राङ्बा मुला। थेह्रङ् लसीन कालला धोपधोपरी मुबा म्‍हिगदेला गुङरी थे य्‍हाल फेःबा मुला।” ");
INSERT INTO taj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","थे धुइहेन्‍से येशूसे “एनीगदेसे ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःगो, तिग्‍दा भिसम स्‍वर्गला य्‍हुल्‍सा खसी जिन्‍बा मुला” भिसी म्‍हिगदेदा सुङ्बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","येशू गालील समुन्‍द्रला कुनीन कुनी फेप्‍बान लमा पत्रुस भिबा सिमोनदेन थेला आले अन्‍द्रियासदा तार्ङा साइबारी समुन्‍द्ररी घ्‍याङ क्‍लाङ्बान लबा म्राङ्जी। तिग्‍दा भिसम थेनीगदे तार्ङा साइबा म्‍हिगदे मुबा। ");
INSERT INTO taj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","येशूसे थेनीगदेदा “ङादेन छ्‌याम भ्रउ, दाहेन्‍से ङाइ एनीगदेदा तार्ङा चुङ्बा म्‍हि आहिन, तर म्‍हिगदेदा परमेश्‍वर मुबा ग्‍लारी भबा म्‍हि स्‍होला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","येशूसे थेह्रङ् सुङ्मैछ्‌याम, ह्राङला घ्‍याङ ख्‍लासी थेनीगदे येशूदेन छ्‌याम भ्रजी। ");
INSERT INTO taj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","थेग्‍याम फेप्‍बान लमा येशूसे जब्‍दियाला झागदे याकूबदेन थेला आले यूहन्‍नादा म्राङ्जी। थेनीगदे ह्राङला आबादेन छ्‌याम दोँगारी घ्‍याङ राबान मुबा। येशूसे थेनीगदेदाएनोन ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","येशूसे चुह्रङ् सुङ्मैछ्‌याम थेनीगदे दोँगादेन आबादा ख्‍लासी येशूदेन छ्‌याम भ्रजी। ");
INSERT INTO taj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","येशू गालील अञ्‍चलला जम्‍मान ग्‍लारी फेप्‍सी यहूदीगदे ह्रुप तबा दिमरी म्‍हिगदेदा लोप्‍बान परमेश्‍वरला य्‍हुल्‍साला समाचार थेःना लजी। ओच्‍छे ल्‍हानान थरीला रोगसे स्‍याप्‍बादेन आखम्‍बा म्‍हिगदेदा खम्‍ना लजी। ");
INSERT INTO taj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","जमाहेन्‍से सिरिया य्‍हुल्‍सा नाङनोन येशूला बारेरी थेःजी। ओच्‍छे म्‍हिगदेसे ल्‍हानान थरीला रोगसे स्‍याप्‍सी दुख याङ्बागदे, म्‍हङसे स्‍याप्‍बागदे, स्‍ह म्‍हङसे स्‍याप्‍बागदेदेन काङ या चलब आतबा कुज्‍या म्‍हिगदेदा येशू मुबा ग्‍लारी भजी। जमाहेन्‍से येशूसे थेनीगदेदा खम्‍ना लजी। ");
INSERT INTO taj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ओच्‍छे गालील, डेकापोलिस, यरूशलेम, यहूदियादेन यर्दन क्‍याम्‍सङहेन्‍सेला ल्‍हानान म्‍हिगदे येशूदेन छ्‌याम भ्रजी। ");
INSERT INTO taj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ल्‍हानान म्‍हिगदे खबा म्राङ्सी येशू गङरी फेप्‍सी धन्‍छ्‌याजी। जमाहेन्‍से चेलागदेएनोन येशूला क्‍युर्सीन चिजी। ");
INSERT INTO taj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ओच्‍छे येशूसे थेनीगदेदा चुह्रङ् भिसी लोप्‍बारी छ्‌याइजी, ");
INSERT INTO taj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“परमेश्‍वरथोरी जे आश लबागदेसे परमेश्‍वरग्‍याम मोलम याङ्ला, तिग्‍दा भिसम स्‍वर्गला य्‍हुल्‍सा थेनीगदेलान हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","सेम क्राबागदेसे परमेश्‍वरग्‍याम मोलम याङ्ला तिग्‍दा भिसम थेनीगदेदा परमेश्‍वरसे ताङ्ना लला। ");
INSERT INTO taj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","सोजो म्‍हिगदेसे परमेश्‍वरग्‍याम मोलम याङ्ला, तिग्‍दा भिसम थेनीगदेसे जम्‍बुलिङला अधिकार याङ्ला। ");
INSERT INTO taj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","परमेश्‍वरसे म्‍हन्‍बा अन्‍छार भ्रबारी म्‍हाइबागदेसे परमेश्‍वरग्‍याम मोलम याङ्ला, तिग्‍दा भिसम परमेश्‍वरसे थेनीगदेदा भङ पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","स्‍य्‍हान्‍दोदा दया लबागदेसे परमेश्‍वरग्‍याम मोलम याङ्ला, तिग्‍दा भिसम थेनीगदेसे दया याङ्ला। ");
INSERT INTO taj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ज्‍यबा सेम थोबागदेसे परमेश्‍वरग्‍याम मोलम याङ्ला, तिग्‍दा भिसम थेनीगदेसे परमेश्‍वरदा म्राङ्ला। ");
INSERT INTO taj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","स्‍य्‍हान्‍दोदा ढिक्‍ना लबागदेसे परमेश्‍वरग्‍याम मोलम याङ्ला, तिग्‍दा भिसम थेनीगदे परमेश्‍वरला झा दोला। ");
INSERT INTO taj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","म्‍हिगदेसे दुख पिन्‍सैनोन परमेश्‍वरसे म्‍हन्‍बा अन्‍छार भ्रबागदेसे परमेश्‍वरग्‍याम मोलम याङ्ला, तिग्‍दा भिसम स्‍वर्गला य्‍हुल्‍सा थेनीगदेलान हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“ङादा विश्‍वास लबासे लमा म्‍हिगदेसे एनीगदेदा खिसी लला, दुख पिन्‍ना, ओच्‍छे लुसीला ताम पाङ्सी एनीगदेला बिरोधरी जम्‍मान नइबा ताम लमैनोन एनीगदेसे परमेश्‍वरग्‍याम मोलम याङ्ला। ");
INSERT INTO taj_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","तसैनोन एनीगदे ल्‍हानान ताङ्‍गो, तिग्‍दा भिसम स्‍वर्गरी एनीगदेसे घ्रेन इनाम याङ्ला। एनीगदे भन्‍दा ङाच्‍छाला अगमवक्तागदेदाएनोन थेनीगदेसे चुह्रङ् लसीन दुख पिन्‍मुबा। ");
INSERT INTO taj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“एनीगदे जम्‍बुलिङला चजा ह्रङ्‌बान हिन्‍ना, तर चजाला ङम्‍बा स्‍हे म्‍हाजी भिसम दोःसी तिग्‍से ङम्‍ना लबा? गे आखेल्‍बासे लमा म्‍हिसे थेदा भ्‍याङ्‍ला, जमाहेन्‍से म्‍हिसे नाङ्सी भ्रला। ");
INSERT INTO taj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“गङरी मुबा शहरदा जम्‍मासेन म्राङ्बा ह्रङ् लसी एनीगदेएनोन जम्‍बुलिङला नाङसल तबासे लमा जम्‍मासेन म्राङ्ला। ");
INSERT INTO taj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","म्‍हिगदेसे नाङसल म्रासी फामसे घप्‍सी आथान, तर दिमरी मुबा जम्‍मान म्‍हिगदेसे म्राङ्‍गै भिसी नोबा ग्‍लारी थान्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","चुह्रङ् लसी नाङसलसे य्‍हाल तना लबा ह्रङ् लसी एनीगदेसे ज्‍यबा गे लसी उन्‍गो। एनीगदेला गे म्राङ्सी थेनीगदेसे स्‍वर्गरी धन्‍छ्‌याबा एनीगदेला परमेश्‍वर आबाला जयजयकार लगै। ");
INSERT INTO taj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“ङा परमेश्‍वरसे मोशादा पिन्‍बा ठिमदेन अगमवक्तागदेसे पाङ्बा ताम भ्‍याङ्बारी आहिन, तर थे पूरा लबारी खबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","एनीगदेसे ङाला ताम ङ्‌यान्‍गो, तिग्‍दा भिसम मुदेन जम्‍बुलिङ नाश आततेधोना परमेश्‍वरसे मोशादा पिन्‍बा ठिमरी मुबा हिगी गिकनोन आम्‍हा। ");
INSERT INTO taj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","थेतबासेलमा जुन म्‍हिसे ठिमरी मुबा तामगदे न्‍हङला जम्‍मान भन्‍दा जजा तामदा आङ्‌यान्‍ना म्‍हिगदेदाएनोन थेह्रङ्नोन लपुङ्जी भिसम थे म्‍हि स्‍वर्गला य्‍हुल्‍सारी जम्‍मान भन्‍दा जजा तला। तर जुन म्‍हिसे ठिमरी मुबा तामगदे ङ्‌यान्‍सी म्‍हिगदेदा थेह्रङ्नोन लपुङ्ला थे म्‍हि स्‍वर्गला य्‍हुल्‍सारी जम्‍मान भन्‍दा घ्रेन म्‍हि तला। ");
INSERT INTO taj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","एनीगदेसे ङाला ताम ङ्‌यान्‍गो, तिग्‍दा भिसम एनीगदेसे यहूदी धर्मगुरुगदेदेन फरिसीगदेसे भन्‍दा ज्‍यना लसी परमेश्‍वरसे म्‍हन्‍बा अन्‍छार आलनी भिसम तिगै लसीन एनीगदे स्‍वर्गला य्‍हुल्‍सारी वाङ्‌आम्‍याङ्। ");
INSERT INTO taj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“‘एसे म्‍हि थासाइगो, जुन म्‍हिसे म्‍हि साइला थेसे सजाय याङ्ला’ भिसी परमेश्‍वरसे मोशादा पिन्‍बा ठिमरी भ्रिबा ताम एनीगदेसे थेःबा मुला। ");
INSERT INTO taj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","तर एनीगदेसे ङाला ताम ङ्‌यान्‍गो, जुन म्‍हिसे खालैदा बोमो लला, थे म्‍हिसे सजाय याङ्ला, ओच्‍छे खालैसे स्‍य्‍हान्‍दोदा हेला लजी भिसम थेदा अदालतरी भोर्ला। तर जुन म्‍हिसे स्‍य्‍हान्‍दोदा ‘ए गे आखेल्‍बा मूर्ख’ भिसी भिला थेदा नर्गला लोङ्‌बा खबा मेरी युला। ");
INSERT INTO taj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“थेतबासेलमा परमेश्‍वरदा भेटी फुल्‍बा धुइरी एदेन छ्‌याम खालै म्‍हि बोमो खबा मुला भिबा ताम एसे ढन्‍जी भिसम, ");
INSERT INTO taj_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","एला भेटी परमेश्‍वरला मन्‍दिररी भेटी फुल्‍बा ग्‍लाला ङाच्‍छापट्टि ख्‍लासी ङाच्‍छा थे म्‍हिदेन छ्‌याम ढिक्‍गो, ओच्‍छे एसे ह्राङला भेटी फुल्‍गो। ");
INSERT INTO taj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“एदा मुद्दा युबा म्‍हिदेन छ्‌याम अदालतरी निबान लबा धुइरी ग्‍यामरीन ढिक्‍गो। आहिन्‍सम थेसे एदा न्‍यायाधीशला यारी जिम्‍मा पिन्‍ना, ओच्‍छे न्‍यायाधीशसे सिपाहीगदेला यारी जिम्‍मा पिन्‍ना। जमाहेन्‍से ए झ्‍याल्‍खानरी परब तला। ");
INSERT INTO taj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","एसे ङाला सत्‍य ताम ङ्‌यान्‍गो, एसे जम्‍मान टाङगा आफातेधोना थेग्‍याम थोन्‍बारी आम्‍याङ्। ");
INSERT INTO taj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“परमेश्‍वरसे मोशादा पिन्‍बा ठिमरी चुह्रङ् भिसी भ्रिबा तामएनोन एनीगदेसे थेःबा मुला, ‘ए स्‍य्‍हान्‍दोला म्रिङदेन छ्‌याम ब्रेल्‍सी थाभ्रउ।’ ");
INSERT INTO taj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","तर एनीगदेसे ङाला ताम ङ्‌यान्‍गो, जुन म्‍हिसे खालै म्रिङम्‍हेमेदा नइबा सेमसे च्‍याला थेसे सेमरी थे म्रिङम्‍हेमेदेन छ्‌याम ब्रेल्‍सी जिन्‍बा तला। ");
INSERT INTO taj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","चुदे एला दाहिने मीसे पाप लपुङ्जी भिसम थे मी तेःसी भ्‍याङ्‍गो। तिग्‍दा भिसम एला पूरान ल्‍हुइ नर्गरी निबा भन्‍दा मी गिक तेःसी भ्‍याङ्‍बान एला लागिरी ज्‍यबा तला। ");
INSERT INTO taj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","थेह्रङ् लसीन एदा दाहिने यासे पाप लपुङ्जी भिसम थे या थासी भ्‍याङ्‍गो। तिग्‍दा भिसम एला पूरान ल्‍हुइ नर्गरी निबा भन्‍दा एला या गिक थासी भ्‍याङ्‍बान एला लागिरी ज्‍यबा तला। ");
INSERT INTO taj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“परमेश्‍वरसे मोशादा पिन्‍बा ठिमरी चुह्रङ् भिसी भ्रिबा तामएनोन एनीगदेसे थेःबा मुला, ‘जुन म्‍हिसे म्रिङ ख्‍लाला थे म्‍हिसे छोडपत्रला कागज भ्रिसी पिन्‍गै।’ ");
INSERT INTO taj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","तर एनीगदेसे ङाला ताम ङ्‌यान्‍गो, जुन म्‍हिसे ह्राङला म्रिङदा स्‍य्‍हान्‍दोदेन छ्‌याम ब्रेल्‍सी आभ्रसैनोन ख्‍लाला, थेसे ह्राङला म्रिङदा स्‍य्‍हान्‍दोदेन छ्‌याम ब्रेल्‍सी भ्रबा म्रिङम्‍हेमे स्‍होला। ओच्‍छे थे म्रिङम्‍हेमेदेन छ्‌याम जुन म्‍हिसे ब्‍याह लला थेएनोन ब्रेल्‍सी भ्रबा तला। ");
INSERT INTO taj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“परमेश्‍वरसे मोशादा पिन्‍बा ठिमरी चुह्रङ् भिसी भ्रिबा तामएनोन एनीगदेसे थेःबा मुला, ‘एसे लुसीला ताम लसी घ्रान थाफागो, ओच्‍छे परमेश्‍वरदेन छ्‌याम लबा कबुल पूरा लउ।’ ");
INSERT INTO taj_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","तर एनीगदेसे ङाला ताम ङ्‌यान्‍गो, एनीगदेसे घ्रान भिबा फानोन थाफागो, स्‍वर्गला मिनरी तसै, जम्‍बुलिङला मिनरी तसै एनीगदेसे घ्रान थाफागो। तिग्‍दा भिसम स्‍वर्ग परमेश्‍वर धन्‍छ्‌याबा ग्‍ला हिन्‍ना ओच्‍छे जम्‍बुलिङ परमेश्‍वरला स्‍य्‍हाप न्‍हेःबा ग्‍ला हिन्‍ना, ओच्‍छे यरूशलेम शहर चा जम्‍मालान ग्‍ले परमेश्‍वरला शहर हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ओच्‍छे ह्राङला थोबोरी या थान्‍सी घ्रान थाफागो। तिग्‍दा भिसम एसे क्रा गिकदाएनोन म्‍लाङ अथवा तार तना लबारी आखम। ");
INSERT INTO taj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","थेतबासेलमा एनीगदेसे पाङ्बा ताम चा ‘हिन्‍ना’ भिसम ‘हिन्‍ना,’ ‘आहिन’ भिसम ‘आहिन’ जे तगै। थे भन्‍दा ल्‍हाना ताम चा शैतानग्‍याम खबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“परमेश्‍वरसे मोशादा पिन्‍बा ठिमरी चुह्रङ् भिसी भ्रिबा तामएनोन एनीगदेसे थेःबा मुला, ‘मीला बदला मी, ओच्‍छे स्‍वाला बदला स्‍वा किन्‍गो।’ ");
INSERT INTO taj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","तर एनीगदेसे ङाला ताम ङ्‌यान्‍गो, एनीगदेदा बिरोध लबागदेदा एनीगदेसे बदला थाकिन्‍गो। बरु खालैसे एला दाहिने ग्रम्‍बारी तोजी भिसम अर्गुपट्टिला ग्रम्‍बाएनोन तासी पिन्‍गो। ");
INSERT INTO taj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","खालै म्‍हिसे एदा बिरोध लसी मुद्दा लमा अदालतसे थेदा एला स्‍हुर्दम पिन्‍गो भिजी भिसम थेदा एसे घएनोन पिन्‍गो। ");
INSERT INTO taj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","चुदे खालै म्‍हिसे एदा कोस गिकधोना भ्रउ भिसी कर लजी भिसम थेदेन छ्‌याम कोस न्‍हीधोना निउ। ");
INSERT INTO taj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","खालैसे एदा ह्रीजी भिसम पिन्‍गो ओच्‍छे एदा छे ह्रीबा म्‍हिदाएनोन छे पिन्‍गो। ");
INSERT INTO taj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“परमेश्‍वरसे मोशादा पिन्‍बा ठिमरी चुह्रङ् भिसी भ्रिबा तामएनोन एनीगदेसे थेःबा मुला, ‘एसे ह्राङला खिम्‍जेमदा माया लउ, ओच्‍छे शत्रुदा हेला लउ।’ ");
INSERT INTO taj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","तर एनीगदेसे ङाला ताम ङ्‌यान्‍गो, एनीगदेसे ह्राङला शत्रुगदेदा माया लउ, ओच्‍छे एनीगदेदा दुख पिन्‍बागदेला लागिरी प्रार्थना लउ। ");
INSERT INTO taj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","चुह्रङ् लजी भिसम एनीगदे स्‍वर्गरी धन्‍छ्‌याबा परमेश्‍वर आबाला कोलागदे दोला। परमेश्‍वरसे ज्‍यबा सेम थोबादेन नइबा सेम थोबा न्‍हीलान लागिरी धिनी फेना लबा मुला। ओच्‍छे परमेश्‍वरला ङाच्‍छापट्टि ज्‍यबा गे लबा म्‍हिदेन आज्‍यबा गे लबा म्‍हि न्‍हीलान लागिरी नाम ताइना लबा मुला। ");
INSERT INTO taj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","चुदे एनीगदेदा माया लबादा जे एनीगदेसे माया लजी भिसम एनीगदेसे खाह्रङ् लसी इनाम याङ्ला? थेह्रङ् मी तिरो दुइबा म्‍हिगदेसेनोन आल? लमुला। ");
INSERT INTO taj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","एनीगदेसे ह्राङला ज्‍योज्‍यो आलेगदेदा जे मान लजी भिसम स्‍य्‍हान्‍दोगदेसे भन्‍दा ज्‍यबा तिग लजी? थेह्रङ् मी अर्गु य्‍हुलला म्‍हिगदेसेनोन आल? लमुला। ");
INSERT INTO taj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","थेतबासेलमा एनीगदेला स्‍वर्गरी धन्‍छ्‌याबा परमेश्‍वर आबा खाह्रङ्बा मुला, एनीगदेएनोन थेह्रङ्बान दोगो।” ");
INSERT INTO taj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“एनीगदेसे लबा ज्‍यबा गेगदे म्‍हिगदेदा उन्‍बाला लागिरी भिसी थालउ। थेह्रङ् लजी भिसम स्‍वर्गरी धन्‍छ्‌याबा एनीगदेला परमेश्‍वर आबासे एनीगदेदा तिगै इनाम आपिन। थेतबासेलमा होशियार तसी चिउ। ");
INSERT INTO taj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“एनीगदेसे प्राङबोगदेदा पिन्‍बा धुइरी कप्‍टीगदेसे ह्रङ् लसी म्‍हिगदेदा थेःना लसी थाभ्रउ। तिग्‍दा भिसम थेनीगदे म्‍हिगदेसे मान लगै भिसी यहूदीगदे ह्रुप तबा दिमगदेदेन ग्‍यामरीक्‍यार निसी स्‍य्‍हान्‍दोदा थेःना लसी भ्रमुला। च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, थेनीगदेसे याङ्तोःबा इनाम याङ्सी जिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","तर एसे प्राङबोगदेदा पिन्‍बा धुइरी एला दाहिने यासे तिग लबान मुला थे ताम एला देब्रे यासेनोन था थायाङ्‍गै। ");
INSERT INTO taj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","थेतबासेलमा एसे प्राङबोगदेदा पिन्‍बा स्‍हे खालैदा था आतगै। थेह्रङ् लजी भिसम खालैसे था आयाङ्बा तामएनोन था याङ्बा परमेश्‍वर आबासे एदा इनाम पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“थेतबासेलमा एसे प्रार्थना लबा धुइरी कप्‍टीगदेसे ह्रङ् लसी थालउ। तिग्‍दा भिसम थेह्रङ्बा म्‍हिगदेसे म्‍हिगदेदा उन्‍बाला लागिरी यहूदीगदे ह्रुप तबा दिमगदेदेन ग्‍यामला कुनीरीक्‍यार राप्‍सी प्रार्थना लबारी सेम लमुला। च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, थेह्रङ्बा म्‍हिगदेसे याङ्तोःबा इनाम याङ्सी जिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","तर ए प्रार्थना लबा धुइरी कोठा न्‍हङरी वाङ्सी म्राप ढुङ्‍गो, ओच्‍छे खालैसे आम्राङ्बा ग्‍लारी धन्‍छ्‌याबा परमेश्‍वर आबादेन छ्‌याम प्रार्थना लउ। जमाहेन्‍से खालैसे आम्राङ्बा तामएनोन म्राङ्बा परमेश्‍वर आबासे एदा इनाम पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ओच्‍छे प्रार्थना लमा अर्गु य्‍हुलला म्‍हिगदेसे ह्रङ् लसी ओह्रङ्नोन थाक्रिङ्‍गो। तिग्‍दा भिसम ह्रेङ्बा ह्रेङ्बा प्रार्थना लजी भिसम परमेश्‍वरसे थेःमुला भिसी थेनीगदेसे म्‍हन्‍मुला। ");
INSERT INTO taj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","थेतबासेलमा एनीगदे थेनीगदे ह्रङ्‌बा थादोगो। तिग्‍दा भिसम एनीगदेसे ह्रीबा भन्‍दा ङाच्‍छान एनीगदेदा तिग तिग स्‍हे तोःबा मुला, थे एनीगदेला परमेश्‍वर आबादा था मुला। ");
INSERT INTO taj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“तर एनीगदेसे चा चुह्रङ् लसी प्रार्थना लउ, ‘स्‍वर्गरी धन्‍छ्‌याबा ङन्‍ना परमेश्‍वर आबा, ह्राङदा जम्‍मासेन मान लगै। ");
INSERT INTO taj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ओच्‍छे जम्‍मानथोरी ह्राङला शासन खगै, ओच्‍छे ह्राङसे म्‍हन्‍बा ताम स्‍वर्गरी पूरा तबा ह्रङ्नोन चु जम्‍बुलिङरीनोन पूरा तगै। ");
INSERT INTO taj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ङन्‍से धिन धिननोन चतोःबा स्‍हे ङन्‍दा तिनी पिन्‍गो। ");
INSERT INTO taj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ङन्‍से ङन्‍दा बिरोध लसी पाप लबागदेदा माफ लबा ह्रङ् लसी ह्राङसेनोन ङन्‍ना पाप माफ लसी पिन्‍गो। ");
INSERT INTO taj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ओच्‍छे ङन्‍दा पापरी फसब तबा ग्‍यामरी भ्रआपुङ्‍गो, तर शैतानग्‍याम फेसी थान्‍गो। ह्राङला य्‍हुल्‍सादेन शक्ति ओच्‍छे ह्राङला मान सदनना लागिरी ह्राङलान हिन्‍ना, आमेन।’ ");
INSERT INTO taj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“एनीगदेदा बिरोध लसी पाप लबागदेदा एनीगदेसे माफ लजी भिसम स्‍वर्गरी धन्‍छ्‌याबा परमेश्‍वर आबासेनोन एनीगदेदा माफ लला। ");
INSERT INTO taj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","तर एनीगदेसे म्‍हिगदेदा माफ आलनी भिसम परमेश्‍वर आबासेनोन एनीगदेदा माफ आल। ");
INSERT INTO taj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“एनीगदेसे फोइथान चिसी प्रार्थना लबा धुइरी कप्‍टी म्‍हिगदेसे ह्रङ् लसी ली धोपधोप लसी थाभ्रउ। तिग्‍दा भिसम थेनीगदेसे फोइथान चिसी प्रार्थना लबा म्‍हिगदेसे म्राङ्‍गै भिसी ली धोपधोप लसी भ्रमुला। थेतबासेलमा एनीगदेसे ङाला ताम ङ्‌यान्‍गो, थेनीगदेसे याङ्तोःबा इनाम याङ्सी जिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","तर एनीगदेसे चा फोइथान चिसी प्रार्थना लबा धुइरी ली ख्रुसी थोबोरी छ्‌युगु फोर्गो। ");
INSERT INTO taj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ओच्‍छे ए फोइथान चिसी प्रार्थना लबा म्‍हिगदेसे आहिन, तर खालैसे आम्राङ्बा ग्‍लारी धन्‍छ्‌याबा परमेश्‍वर आबासे म्राङ्‍गै। ओच्‍छे खालैसे आम्राङ्बा तामएनोन म्राङ्बा परमेश्‍वर आबासे एदा इनाम पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“ह्राङला लागिरी जम्‍बुलिङरी धन सम्‍पत्ति सोसी थाथान्‍गो, तिग्‍दा भिसम जम्‍बुलिङला धन सम्‍पत्तिगदे बुलुङदेन खियासे चला, ओच्‍छे दिम फोसी य्‍होगदेसे य्‍हो लसी भोर्ला। ");
INSERT INTO taj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","बरु ह्राङला लागिरी स्‍वर्गरी धन सम्‍पत्ति सोसी थान्‍गो। तिग्‍दा भिसम थेरी बुलुङसेएनोन आच खियासेएनोन आच, ओच्‍छे य्‍होसेएनोन वाङ्सी य्‍हो आल। ");
INSERT INTO taj_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","तिग्‍दा भिसम जुन ग्‍लारी एनीगदेला धन सम्‍पत्ति मुला, एनीगदेला सेमएनोन थेरीन तला। ");
INSERT INTO taj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“मी ल्‍हुइला लागिरी नाङसल ह्रङ्‌बान हिन्‍ना। थेतबासेलमा एला मी ज्‍यबा मुसम एसे ज्‍यना लसी म्राङ्ला, ");
INSERT INTO taj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","तर एला मी न्‍होङ्जी भिसम एसे तिगै आम्राङ्। थेह्रङ् लसीन एला सेमला नाङसल सिजी भिसम एला लागिरी जम्‍मान धोपधोप तला। ");
INSERT INTO taj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“खालैसेनोन मालिक न्‍हीला गे लबारी आखम। तिग्‍दा भिसम थेसे गिकदा हेला लला, ओच्‍छे स्‍य्‍हान्‍दोदा माया लला। अथवा थेसे गिकसे भिबा ताम ङ्‌यान्‍ना, ओच्‍छे स्‍य्‍हान्‍दोदा वास्‍तान आल। थेह्रङ् लसीन एनीगदेसेनोन परमेश्‍वरदेन धन सम्‍पत्ति न्‍हीलान गे लबारी आखम। ");
INSERT INTO taj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“थेतबासेलमा एनीगदेसे ङाला ताम ङ्‌यान्‍गो, सोबाला लागिरी तिग चसे तिग थुङ्‍से ओच्‍छे तिग क्‍वान्‍से भिसी धन्‍दा सुर्दा थालउ। तिग्‍दा भिसम चबा थुङ्बादेन क्‍वान्‍बा भन्‍दा एनीगदेला प्राणदेन ल्‍हुइ घ्रेन आहिन? ");
INSERT INTO taj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","मुरी चरागदेदा च्‍यागो, थेनीगदेसे न्‍ह ब्‍लु ढ्वला, न्‍ह बाली दुइसी पोप लला, तर स्‍वर्गरी धन्‍छ्‌याबा एनीगदेला परमेश्‍वर आबासेन थेनीगदेदा ख्‍वामुला। चरागदे भन्‍दा मी एनीगदे घ्रेन आहिन? ");
INSERT INTO taj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","एनीगदे न्‍हङला खालैसे धन्‍दा सुर्दा लसी छिन्‍नङला लागिरी आयू काप्‍खम्‍ला? ");
INSERT INTO taj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“तिग्‍दा एनीगदेसे क्‍वान्‍ना लागिरी धन्‍दा सुर्दा लबा? ह्रिरी सार्बा म्‍हेन्‍दोदा च्‍यागो, थेसे गेएनोन आलमुला, क्‍वानएनोन आरामुला। तसैनोन थे खाह्रङ् लसी ल्‍हेमुला! ");
INSERT INTO taj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","एनीगदेसे ङाला ताम ङ्‌यान्‍गो, सोलोमन ग्‍लेदेन ल्‍हानान धन सम्‍पत्ति मुसैनोन थेसे क्‍वान्‍बा क्‍वान थे म्‍हेन्‍दोगदे न्‍हङला गिक तेबै जेबा आरेमुबा। ");
INSERT INTO taj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","तिनी ल्‍हेबान निसी न्‍हङगर खर्माहेन्‍से मेरी फर्बा छेदा मी परमेश्‍वरसे चुह्रङ् लसी जेना लमुला भिसम झन एनीगदेदा परमेश्‍वरसे जेना आल? खाइ एनीगदेला विश्‍वास? ");
INSERT INTO taj_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","थेतबासेलमा ‘तिग चसे? तिग थुङ्‍से? ओच्‍छे तिग क्‍वान्‍से?’ भिसी धन्‍दा सुर्दा थालउ। ");
INSERT INTO taj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","तिग्‍दा भिसम परमेश्‍वरदा ङोआसेबा अर्गु य्‍हुलला म्‍हिगदेसे चा चु जम्‍मान स्‍हे म्‍हाइमुला। तर स्‍वर्गरी धन्‍छ्‌याबा परमेश्‍वर आबासे एनीगदेदा चु जम्‍मान स्‍हे तोःला भिसी था मुला। ");
INSERT INTO taj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","थेतबासेलमा ङाच्‍छा एनीगदेसे परमेश्‍वरला य्‍हुल्‍सा म्‍हाइगो ओच्‍छे थेसे म्‍हन्‍बा अन्‍छार गे लउ। जमाहेन्‍से परमेश्‍वरसे एनीगदेदा चु जम्‍मान स्‍हे पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","थेतबासेलमा न्‍हङगरला लागिरी धन्‍दा सुर्दा थालउ। तिग्‍दा भिसम न्‍हङगरदा तोःबा स्‍हे न्‍हङगरनोन याङ्ला। तिनीला लागिरी तिनीलान दुख मुला। ");
INSERT INTO taj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“स्‍य्‍हान्‍दोदा दोष लसी थाभ्रउ ओच्‍छे परमेश्‍वरसेनोन एनीगदेदा दोष आल। ");
INSERT INTO taj_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","तिग्‍दा भिसम एनीगदेसे खाह्रङ् लसी स्‍य्‍हान्‍दोदा दोष लला, थेह्रङ् लसीन एनीगदेदाएनोन दोष लला। ओच्‍छे एनीगदेसे जुन दप्‍बा स्‍हेसे दप्‍सी पिन्‍ना, परमेश्‍वरसेनोन एनीगदेदा थेनोन दप्‍बा स्‍हेसे दप्‍सी पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“स्‍य्‍हान्‍दोला गोरी सेः भ्रबा म्राङ्बा म्‍हिसे ह्राङला गोरी मुइ भ्रबा तिग्‍दा आम्राङ्बा? ");
INSERT INTO taj_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ह्राङला गोरी म्‍हुइ भ्रबा आम्राङ्बासे खाह्रङ् लसी आलेदा ‘खाइ एला गोला सेः तेःसी पिन्‍ना भिसी भिखम्‍ला?’ ");
INSERT INTO taj_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","कप्‍टी, ङाच्‍छा ह्राङला गोला मुइ तेःगो, ओच्‍छे जे एसे आलेला गोरी भ्रबा सेः तेःबारी खम्‍ला। ");
INSERT INTO taj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“परमेश्‍वरदा फुल्‍तोःबा स्‍हे नगीदा थापिन्‍गो, तिग्‍दा भिसम थेसे एदा ख्राप्‍बारी खला। ओच्‍छे ह्राङला मोती ढ्वला ङाच्‍छापट्टि थाभ्‍याङ्‍‍गो। तिग्‍दा भिसम थेसे मोती नाङ्सी भ्रला। ");
INSERT INTO taj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“एनीगदेसे ह्रीसम पिन्‍ना म्‍हाइसम स्‍याप्‍ला ओच्‍छे म्रापरी ढ्वक ढ्वक लसम एनीगदेला लागिरी म्राप ठोङ्सी पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","तिग्‍दा भिसम जुन म्‍हिसे ह्रीला थेदा पिन्‍ना, ओच्‍छे जुन म्‍हिसे म्‍हाइला थेसे स्‍याप्‍ला ओच्‍छे जुन म्‍हिसे म्रापरी ढ्वाक ढ्वाक लला थेदा म्राप ठोङ्सी पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“एनीगदे न्‍हङला खालैसे ह्राङला कोलासे गेङ ह्रीमा थेदा युङबा पिन्‍ना? ");
INSERT INTO taj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","खाइमै तार्ङा ह्रीमा थेदा पुख्री पिन्‍ना? ");
INSERT INTO taj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","एनीगदे पापी तसीनोन ह्राङला कोलागदेदा ज्‍यबा स्‍हे पिन्‍बारी सेमुला भिसम स्‍वर्गरी मुबा एनीगदेला परमेश्‍वर आबासे गाते ल्‍हाना ज्‍यबा स्‍हे पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","एनीगदेदा स्‍य्‍हान्‍दो म्‍हिगदेसे जस्‍तो व्‍यवहार लगै भिसी म्‍हन्‍बा मुला एनीगदेसेनोन थेनीगदेदा थेह्रङ्बान व्‍यवहार लउ। तिग्‍दा भिसम परमेश्‍वरसे मोशादा पिन्‍बा ठिमरी मुबादेन अगमवक्तासे लोप्‍बा मुल ताम चुनोन हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“एनीगदे साङरो म्रापग्‍याम वाङ्‍गो। तिग्‍दा भिसम घ्रेन म्रापग्‍याम वाङ्बारी सजिलो मी मुला तसैनोन थे म्रापग्‍याम नाश तबा ग्‍लारी धोमुला। चु म्रापग्‍याम वाङ्बा म्‍हिगदे चा ल्‍हानान मुला। ");
INSERT INTO taj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","तर साङरो म्रापदेन जजाबा ग्‍यामसे भ्रमा जुकजुकधोनाला जुनी याङ्मुला। तसैनोन चु ग्‍यामरी भ्रबा म्‍हिगदे ल्‍हाना आरे। ");
INSERT INTO taj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“फट्टा अगमवक्तागदे म्राङ्सी होशियार तसी चिउ, थेनीगदे एनीगदे मुबा ग्‍लारी ग्‍यु ह्रङ् लसी खमुला, तर थेनीगदेला सेम चा लोङ्‌बा खबा फार्बा ह्रङ्‌बान तमुला। ");
INSERT INTO taj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","एनीगदेसे रो च्‍यासी दोङ ङोसेबा ह्रङ् लसी थेनीगदे खाह्रङ्बा म्‍हि हिन्‍ना भिबा ताम थेनीगदेला गेग्‍यामसेन ङोसेला। पुजुला दोङग्‍याम अङगुर आथु ओच्‍छे देस्‍यला दोङग्‍यामनोन अञ्‍जीर आथु। ");
INSERT INTO taj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","थेह्रङ् लसीन जम्‍मान ज्‍यबा दोङरी ज्‍यबान रो रोला। ओच्‍छे आज्‍यबा दोङरी आज्‍यबान रो रोला। ");
INSERT INTO taj_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ओच्‍छे ज्‍यबा दोङरी आज्‍यबा रो आरो ओच्‍छे आज्‍यबा दोङरीनोन ज्‍यबा रो आरो। ");
INSERT INTO taj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","आज्‍यबा रो रोबा जम्‍मान दोङ थासी मेरी फर्ला। ");
INSERT INTO taj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","चुह्रङ् लसीन थे अगमवक्तागदे खाह्रङ्बा म्‍हि हिन्‍ना भिबा ताम एनीगदेसे थेनीगदेला गेग्‍यामसेन ङोसेखम्‍ला। ");
INSERT INTO taj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“ङादा ‘प्रभु, प्रभु’ जे भिबा म्‍हिगदे स्‍वर्गला य्‍हुल्‍सारी वाङ्बारी आम्‍याङ्। तर स्‍वर्गरी धन्‍छ्‌याबा ङाला आबासे कुल्‍बा ताम ङ्‌यान्‍बा म्‍हि जे वाङ्म्‍याङ्ला। ");
INSERT INTO taj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","जमा धुइरी ल्‍हानान म्‍हिसे ङादा ‘प्रभु, ङन्‍से ह्राङला अधिकारग्‍याम परमेश्‍वरला ताम पाङ्बा आहिन? ओच्‍छे ह्राङला अधिकारग्‍याम ङन्‍से म्‍हङगदे ताप्‍बा आहिन? थेह्रङ् लसीन ङन्‍से ह्राङला अधिकारग्‍याम ल्‍हानान उदेकला गेगदे लबा आहिन?’ भिसी भिला। ");
INSERT INTO taj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","जमा ङाइ थेनीगदेदा ‘एनीगदेदा ङाइ खाइमै ङोसेबा आरे। पाप गे लबा म्‍हिगदे, एनीगदे ङा मुबा ग्‍लाग्‍याम निउ’ भिसी पाङ्ला। ");
INSERT INTO taj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“थेतबासेलमा जुन म्‍हिसे ङाइ पाङ्बा ताम ङ्‌यान्‍सी थे अन्‍छार भ्रला, थे म्‍हि चा दिम स्‍होमा नुप्‍ना जग ख्‍वसी स्‍होबा बुद्धि मुबा म्‍हि ह्रङ्‌बान हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","बुद्धि मुबा म्‍हिसे दिम स्‍होमा नुप्‍ना जग ख्‍वसी स्‍होबासे लमा लाबालुङसरदेन भाल बाढी खसी थे दिमरी टसैनोन थे दिम आफुप्‍नी। ");
INSERT INTO taj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","तर जुन म्‍हिसे ङाइ पाङ्बा ताम थेःसी थे अन्‍छार गे आल, थे म्‍हि चा दिम स्‍होमा नुप्‍ना जग आख्‍वना स्‍होबा बुद्धि आरेबा मूर्ख म्‍हि ह्रङ्‌बान हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","बुद्धि आरेबा मूर्ख म्‍हिसे दिम स्‍होमा नुप्‍ना जग आख्‍वना स्‍होला। तर लाबालुङसरदेन भाल बाढी खसी थे दिमरी टजी भिसम थे दिम फुप्‍सी ल्‍हानान नोक्‍सान तला।” ");
INSERT INTO taj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","येशूसे चु ताम सुङ्सी जिन्‍माहेन्‍से थेरी मुबा म्‍हिगदे येशूसे लोप्‍बा म्राङ्सी उदेक तजी। ");
INSERT INTO taj_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","तिग्‍दा भिसम येशूसे थेनीगदेला यहूदी धर्मगुरुगदेसे लोप्‍बा ह्रङ् लसी आहिन, तर अधिकार मुबा म्‍हिसे ह्रङ् लसी लोप्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","येशू गङग्‍याम मार फेप्‍खमाहेन्‍से ल्‍हानान म्‍हिगदे येशूदेन छ्‌याम भ्रबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","थेनोन धुइरी कोरे खबा म्‍हि गिक येशूला ङामरी खसी येशूदा फ्‍या लजी। ओच्‍छे “प्रभु, ह्राङला सेम मुसम ह्राङसे ङादा खम्‍ना लखम्‍ला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","जमाहेन्‍से येशूसे थेदा थुर्सी “ए खम्‍गै भिबा ङाला सेम मुला, ए खम्‍गो” भिसी सुङ्मैछ्‌याम थेला कोरे म्‍हाजी। ");
INSERT INTO taj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ओच्‍छे येशूसे थेदा “एसे चु ताम खालैदा थापाङ्‍गो। बरु ए निसी परमेश्‍वरला मन्‍दिररी पूजा लबा म्‍हिदा उन्‍गो। ओच्‍छे मोशासे कुल्‍बा अन्‍छार बलि फुल्‍गो। थेह्रङ् लजी भिसम म्‍हिगदेसे ए खम्‍जी भिसी था याङ्ला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","येशू कफर्नहुम शहररी फेप्‍खमा रोमी कप्‍तान गिक खसी, ");
INSERT INTO taj_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“प्रभु, ङाला नोकर काङ या चलब आतना स्‍हु खसी थलारी मुला” भिसी बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","जमाहेन्‍से येशूसे कप्‍तानदा “ङा खसी थेदा खम्‍ना लला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","तर कप्‍तानसे येशूदा “प्रभु, ह्राङ ङाला दिमरी फेप्‍खबाधोनाला ङा आरे। थेतबासेलमा ह्राङसे चुग्‍यामसेन खम्‍गै भिसी सुङ्जे सुङ्सैनोन ङाला नोकर खम्‍ला। ");
INSERT INTO taj_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","तिग्‍दा भिसम ङाएनोन ङाला हाकिमला तहरी चिबा म्‍हि हिन्‍ना। ङाला तहरीनोन सिपाहीगदे मुला। ङाइ कोइदा निउ भिमा निमुला, कोइदा खउ भिमा खमुला। ओच्‍छे ङाला नोकरदा ङाइ चुह्रङ् लउ भिमा थेसे थेह्रङ्नोन लमुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","चु ताम थेःसी येशू उदेक तसी ह्राङदेन छ्‌याम भ्रबा म्‍हिगदेदा चुह्रङ् भिसी सुङ्जी, “च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, इस्राएल य्‍हुल्‍साला म्‍हिगदे न्‍हङरीनोन ङाइ चुह्रङ्बा घ्रेन विश्‍वास मुबा म्‍हि आस्‍याप्‍नी। ");
INSERT INTO taj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, स्‍यारदेन ल्‍हो जम्‍मान ग्‍लाग्‍याम अर्गु य्‍हुलला ल्‍हानान म्‍हिगदे खला। ओच्‍छे अब्राहाम, इसहाक, याकूबदेन छ्‌यामनोन स्‍वर्गला य्‍हुल्‍सारी भोज चबारी चिला। ");
INSERT INTO taj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","तर स्‍वर्गला य्‍हुल्‍सारी चितोःबा ल्‍हानान इस्राएल य्‍हुल्‍साला म्‍हिगदे चा मङग्‍यार धोपधोप्‍बा ग्‍लारी भ्‍याङ्‍ला। थेरी क्राबा क्रिङ्बा लसी स्‍वा क्रेला।” ");
INSERT INTO taj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","जमाहेन्‍से येशूसे थे कप्‍तानदा “ए निउ, एसे विश्‍वास लबा ह्रङ्नोन तगै” भिसी सुङ्जी। चुह्रङ् सुङ्बा धुइरीन थे नोकर खम्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","येशू पत्रुसला दिमरी धोखमाहेन्‍से पत्रुसला स्‍युमी छवा खसी म्‍हेर्सी चिबा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","चु म्राङ्सी येशूसे थेला यारी थुर्जी, ओच्‍छे थेला छवा म्‍हाजी। जमाहेन्‍से थे रेःसी येशूदा क्‍योङ्बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","धिनी घल्‍माहेन्‍से म्‍हिगदेसे म्‍हङसे स्‍याप्‍बा म्‍हिगदेदा येशू मुबा ग्‍लारी भजी। जमाहेन्‍से येशूसे म्‍हङदा बङ्‌सी थे म्‍हिगदेला ल्‍हुइग्‍याम ताप्‍जी। ओच्‍छे थेरी मुबा जम्‍मान आखम्‍बा म्‍हिगदेदा खम्‍ना लजी। ");
INSERT INTO taj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","येशूसे चुह्रङ् लबासे लमा यशैया अगमवक्तासे पाङ्बा ताम पूरा तजी। यशैया अगमवक्तासे, “य्‍हाङसे नातोःबा दुख थेसेन नाजी ओच्‍छे य्‍हाङला आखम्‍बागदेएनोन खम्‍ना लजी” भिसी पाङ्बा मुबा। ");
INSERT INTO taj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","येशूसे ह्राङला क्‍युर्सीन ल्‍हानान म्‍हिगदे म्राङ्सी “य्‍हाङ समुन्‍द्रला क्‍याम्‍सङपट्टि निइ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","थे धुइरी यहूदी धर्मगुरु गिक खसी येशूदा “गुरु, ह्राङ खानङदमान फेप्‍सै ङाएनोन ह्राङदेन छ्‌याम निला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","जमाहेन्‍से येशूसे थेदा “च्‍यागो, ल्‍हुन्‍दीगदे चिबारी ऊ मुला, ओच्‍छे चरागदे चिबारीनोन जङ मुला। तर परमेश्‍वरसे पुइखबा म्‍हिला मी ब्‍लप्‍बा न्‍हबा ग्‍ला सुत्तै आरे” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","स्‍य्‍हान्‍दो चेला गिकसे येशूदा “प्रभु, ङाच्‍छा ङाला सिबा आबादा ल्‍हुसी ह्राङदेन छ्‌याम भ्रला” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","येशूसे थेदा “सिबागदेदा सिबागदे ह्रङ्बासेन ल्‍हुगै, तर ए चा ङादेन छ्‌याम भ्रउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","जमाहेन्‍से येशू दोँगारी क्रेःजी, ओच्‍छे थेला चेलागदेएनोन थेदेन छ्‌यामनोन निजी। ");
INSERT INTO taj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","निबान लमा तिक्‍खुरीन समुन्‍द्ररी घ्रेन लाबालुङसर खजी। ओच्‍छे समुन्‍द्ररी छाल रेःसी छालसे दोँगा प्‍लिङ्‍बारी छ्‌याइजी। तर थे धुइरी येशू चा स्‍हिम्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","जमाहेन्‍से चेलागदे खसी “प्रभु, य्‍हाङ सिबारी छ्‌याइजी, जोगब लउ” भिसी येशूदा छिङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","जमाहेन्‍से येशूसे थेनीगदेदा “एनीगदे तिग्‍दा लोङ्‌बा? खाइ एनीगदेला विश्‍वास?” भिसी सुङ्जी। ओच्‍छे येशू रेःसी लाबालुङसरदेन समुन्‍द्रला छालदा बङ्जी। जमाहेन्‍से लाबालुङसर म्‍हासी शान्‍त तजी। ");
INSERT INTO taj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","चुह्रङ् तबा म्राङ्सी थेनीगदे उदेक तजी। ओच्‍छे थेनीगदेसे “चु खाह्रङ्बा म्‍हि? चुसे कुल्‍बा ताम मी लाबालुङसरदेन समुन्‍द्रला छालसेनोन ङ्‌यान्‍बा चीम” भिसी ह्राङ ह्राङ न्‍हङरी ताम लजी। ");
INSERT INTO taj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","येशू समुन्‍द्रला क्‍याम्‍सङपट्टि गदरा भिबा ग्‍लारी धोखमा म्‍हङसे स्‍याप्‍बा म्‍हि न्‍ही धुर्साग्‍याम खबान लबा स्‍याप्‍जी। थे म्‍हि न्‍ही ल्‍हानान लोङ्‌बा खबा खाल्‍ला मुबासे लमा थे ग्‍याम खालै म्‍हि आभ्रमुबा। ");
INSERT INTO taj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","थेनीगदेसे येशूदा म्राङ्सी क्रिङ्बान, “परमेश्‍वरला झा, ह्राङसे ङन्‍दा तिग लबारी म्‍हाइबा? ङन्‍ना धुइ आतमान ह्राङ ङन्‍दा नाश लबारी फेप्‍खबा हिन्‍ना?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","थेनीगदे मुबा ग्‍लाग्‍याम जजाकी क्‍याथाङ ढ्वागदे छबान मुबा। ");
INSERT INTO taj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","थेतबासेलमा म्‍हङगदेसे येशूदा “चुदे ह्राङसे ङन्‍दा चुरी चिआपुङ्बा हिन्‍सम ङन्‍दा ढ्वागदे न्‍हङरी वाङ्पुङ्‍गो” भिसी बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","जमाहेन्‍से येशूसे थेनीगदेदा “निउ” भिसी सुङ्माहेन्‍से थेनीगदे थोन्‍सी ढ्वागदे न्‍हङरी वाङ्‌जी। जमाहेन्‍से जम्‍मान ढ्वागदे गङग्‍याम समुन्‍द्ररी छ्‌योङ्सी सिजी। ");
INSERT INTO taj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","चुह्रङ् तबा म्राङ्सी ढ्वा छबा म्‍हिगदे यार्सी नाम्‍सारी निजी। ओच्‍छे म्‍हङसे स्‍याप्‍बा म्‍हि न्‍हीदा तिग तिग तजी भिबा ताम जम्‍मादान थेःना लजी। ");
INSERT INTO taj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","जमाहेन्‍से नाम्‍साला मुबा जति जम्‍मान म्‍हिगदे येशूदा स्‍याप्‍बारी खजी। ओच्‍छे येशूदा म्राङ्सी थे म्‍हिगदेसे “चु ग्‍लाग्‍याम फेप्‍गो” भिसी बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","जमाहेन्‍से येशू दोँगारी क्रेःसी क्‍यामसङपट्टि फेप्‍जी, ओच्‍छे ह्राङलान शहररी दोःसी फेप्‍खजी। ");
INSERT INTO taj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","म्‍हिगदेसे काङ या चलब आतबा कुज्‍या तसी म्‍हेर्सी चिबा म्‍हि गिकदा येशू मुबा ग्‍लारी भजी। येशूसे थेनीगदेला विश्‍वास म्राङ्सी थे कुज्‍या म्‍हिदा “कोला, भङ लउ, ङाइ एला पाप माफ लबा मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","थेरी मुबा यहूदी धर्मगुरुगदे न्‍हङला कोइ कोइसे “चुसे मी ह्राङसे ह्राङदान परमेश्‍वर स्‍होसी ताम लबान मुला” भिसी ह्राङ ह्राङ न्‍हङरी ताम लजी। ");
INSERT INTO taj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","येशूसे थेनीगदेला सेमला ताम था याङ्सी “एनीगदेसे तिग्‍दा चुह्रङ्बा नइबा ताम म्‍हन्‍बा? ");
INSERT INTO taj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","‘एला पाप माफ तबा मुला’ भिबादेन ‘रेःसी भ्रउ’ भिबारी खजिबा चा सजिलो मुला? ");
INSERT INTO taj_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","तर परमेश्‍वरसे पुइखबा म्‍हिदा चु जम्‍बुलिङरी म्‍हिगदेला पापला दोष मेटब लबा अधिकार मुला भिसी ङाइ एनीगदेदा उन्‍ना” भिसी सुङ्जी। जमाहेन्‍से येशूसे थे कुज्‍या म्‍हिदा “ए रेःगो, ओच्‍छे एला तीबा नान्‍बा पुइसी दिमरी निउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","जमाहेन्‍से थे रेःसी ह्राङला दिमरी निजी। ");
INSERT INTO taj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","चु म्राङ्सी थेरी मुबा म्‍हिगदे उदेक तजी। ओच्‍छे थेनीगदेसे म्‍हिगदेदा चुह्रङ्बा शक्ति पिन्‍बा परमेश्‍वरला जयजयकार लजी। ");
INSERT INTO taj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","येशू थेग्‍याम फेप्‍बान लबा धुइरी मत्ती भिबा म्‍हिदा तिरो दुइबा ग्‍लारी चिबान लबा म्राङ्जी, ओच्‍छे येशूसे थेदा “ङादेन छ्‌याम भ्रउ” भिसी सुङ्जी। जमाहेन्‍से थे रेःसी येशूदेन छ्‌याम भ्रजी। ");
INSERT INTO taj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","येशू मत्तीला दिमरी सोल छ्‌योइबान लबा धुइरी तिरो दुइबा म्‍हिगदेदेन पापीगदेएनोन खसी येशूदेन येशूला चेलागदेदेन छ्‌याम चिसी चबान मुबा। ");
INSERT INTO taj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","चु म्राङ्सी फरिसीगदेसे येशूला चेलागदेदा “एनीगदेला गुरु तिग्‍दा तिरो दुइबा म्‍हिगदे ओच्‍छे पापीगदेदेन छ्‌याम चिसी चबा?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","चु ताम थेःसी येशूसे “खम्‍बा म्‍हिगदेदा डाक्‍टर आतोः, तर आखम्‍बा म्‍हिगदेदा जे डाक्‍टर तोःला। ");
INSERT INTO taj_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","दाहेन्‍से एनीगदे निसी चु तामला अर्थ तिग हिन्‍ना घोबारी म्‍हाइगो, ‘च्‍यागो, ङाइ म्‍हाइबा चा बलिदान आहिन, तर एनीगदेसे स्‍य्‍हान्‍दोदा लबा दया हिन्‍ना।’ थेतबासेलमा परमेश्‍वरला ङाच्‍छा ज्‍यबा मुबा म्‍हिगदेदा आहिन, तर पापीगदेदा ङ्‌योइबारी ङा खबा हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","जमाहेन्‍से यूहन्‍नाला चेलागदे येशू मुबा ग्‍लारी खसी “ङन्‍देन फरिसीगदे फोइथान चिसी प्रार्थना लमुला, तर ह्राङला चेलागदे चा तिग्‍दा फोइथान चिसी प्रार्थना आलबा?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “म्‍हाछार जन्‍तीगदेदेन छ्‌याम मुतेधोना थेरी मुबागदेसे सुर्दा आल। तर म्‍हाछार थेनीगदेग्‍याम फेसी भोर्माहेन्‍से जे थेनीगदे सुर्दा तसी फोइथान चिला। ");
INSERT INTO taj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","खालैसे बोक्‍टो क्‍वानरी छार क्‍वानगेनसे आख्‍या, छार क्‍वानगेनसे बोक्‍टो क्‍वान ख्‍याजी भिसम बोक्‍टो क्‍वान झन ढेला। ");
INSERT INTO taj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ओच्‍छे खालै म्‍हिसेनोन ढिला बोक्‍टो ताङरी अङगुरला कलिलो निङगु आयु, चुदे युजी भिसम थे ताङ ढेसी अङगुरला निङगु ङेला। ओच्‍छे थे ताङएनोन गे आखेल्‍बा तला। तर अङगुरला कलिलो निङगु ढिला छार ताङरी युला ओच्‍छे न्‍हीनोन जोगब तला।” ");
INSERT INTO taj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","येशूसे थेनीगदेदा चुह्रङ् सुङ्बान लबा धुइरी यहूदीगदे ह्रुप तबा दिमला नेता गिक खजी। ओच्‍छे येशूदा फ्‍या लसी “दान्‍दे भर्खर ङाला झामे सिजी, तर ह्राङ फेप्‍खसी थेदा ह्राङसे थुर्जी भिसम थे सोला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","जमाहेन्‍से येशू स्‍हेङ्‌सी थे म्‍हिदेन छ्‌याम फेप्‍जी, ओच्‍छे येशूला चेलागदेएनोन येशूदेन छ्‌यामनोन निजी। ");
INSERT INTO taj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","थेनोन धुइरी का निबा बेथासे स्‍याप्‍सी च्‍युक न्‍ही दिङ तबा म्रिङम्‍हेमे गिक ग्‍यापग्‍याम खसी येशूला क्‍वानला जोरी थुर्जी। ");
INSERT INTO taj_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","तिग्‍दा भिसम “ङाइ येशूला क्‍वान थुर्बारी जे म्‍याङ्‍सम ङा खम्‍ला” भिसी थेसे सेम सेमरी म्‍हन्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","फ्‍लिक दोःसी च्‍यामा येशूसे थे म्रिङम्‍हेमेदा म्राङ्जी। ओच्‍छे येशूसे थेदा “भङ लउ, माइ! एला विश्‍वाससे लमा ए खम्‍बा मुला” भिसी सुङ्मैछ्‌याम थे म्रिङम्‍हेमे खम्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","येशू थे नेताला दिमरी धोखमा थेरी बाँसुरी ह्राप्‍बा म्‍हिगदेदेन हल्‍ली खल्‍ली लसी चिबा म्‍हिगदे म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","चु म्राङ्सी येशूसे जम्‍मादान “एनीगदे जम्‍मान मङग्‍यार थोन्‍गो। तिग्‍दा भिसम माइ सिबा आरे, तर म्‍हेर्सी चिबा मुला” भिसी सुङ्जी। चु ताम थेःसी थेरी मुबा म्‍हिगदेसे खिसी लसी ङेःजी। ");
INSERT INTO taj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","थेरी मुबा म्‍हिगदे मङग्‍यार थोन्‍माहेन्‍से येशू दिम न्‍हङरी वाङ्‌जी। ओच्‍छे थे माइला यारी चुङ्सी थीजी। थीमैछ्‌याम थे माइ डोङ रेःजी। ");
INSERT INTO taj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","जमाहेन्‍से चु ताम थे य्‍हुल्‍साला जम्‍मान ग्‍लारी थेःजी। ");
INSERT INTO taj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","येशू थेग्‍याम फेप्‍बान लबा धुइरी मी आम्राङ्बा म्‍हि न्‍हीसे “दाऊद ग्‍लेला सन्‍तान, ङन्‍दा दया लउ” भिसी क्रिङ्बान येशूला लिच्‍छा लिच्‍छा खजी। ");
INSERT INTO taj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","येशू दिम न्‍हङरी वाङ्माहेन्‍से थे मी आम्राङ्बा म्‍हि न्‍हीएनोन येशू मुबा ग्‍लारी खजी। जमाहेन्‍से येशूसे थेन्‍नीदा “ङाइ खम्‍ना लबारी खम्‍ला भिसी एनीगदेदा विश्‍वास मुला?” भिसी ङ्‌योइमा थेन्‍नीसे “मुला, प्रभु” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","जमाहेन्‍से येशूसे थेन्‍नीला मीरी थुर्सी “एनीगदेसे विश्‍वास लबासे लमा एनीगदे खम्‍बा मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","येशूसे चुह्रङ् सुङ्मैछ्‌याम थेन्‍नीसे म्राङ्जी। जमाहेन्‍से येशूसे थेन्‍नीदा “च्‍यागो, चु ताम खालैदान थापाङ्‍गो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","तसैनोन थेनीगदे निसी जम्‍मान ग्‍लारी येशूला बारेरी थेःना लजी। ");
INSERT INTO taj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","थे म्‍हि न्‍ही निबारी छ्‌याइमा म्‍हिगदेसे म्‍हङसे स्‍याप्‍सी ताइ दोबा म्‍हि गिकदा येशू मुबा ग्‍लारी भजी। ");
INSERT INTO taj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","येशूसे म्‍हङदा ताप्‍मैछ्‌याम थे ताइ दोबा म्‍हिसे ताम पाङ्‌बारी छ्‌याइजी। चु म्राङ्सी थेरी मुबा म्‍हिगदे उदेक तसी “चुह्रङ्बाम ङन्‍से इस्राएल य्‍हुल्‍साला म्‍हिगदे न्‍हङरी खाइमै म्राङ्बा आरेबा” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","तर फरिसीगदेसे चा “चु म्‍हिसे मी म्‍हङगदेला ग्‍लेला शक्तिग्‍याम म्‍हङ ताप्‍बा हिन्‍ना” भिसी भिबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","जमाहेन्‍से येशूसे यहूदीगदे ह्रुप तबा दिमरी लोप्‍बादेन परमेश्‍वरला य्‍हुल्‍साला समाचार थेःना लजी। ओच्‍छे जम्‍मान थरीला रोगसे स्‍याप्‍बादेन आखम्‍बा म्‍हिगदेदा खम्‍ना लबान शहरदेन नाम्‍सा नाम्‍सारी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","म्‍हिला हुल म्राङ्सी येशूदा ल्‍हानान दया रेःजी, तिग्‍दा भिसम थेनीगदे खालैसे आच्‍याना दुख याङ्बा गोठालो आरेबा ग्‍युगदे ह्रङ्‌बान मुबा। ");
INSERT INTO taj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","जमाहेन्‍से येशूसे ह्राङला चेलागदेदा “च्‍यागो, बाली मी ल्‍हानान मिन्‍बा मुला, तर बाली दुइबा म्‍हिगदे ल्‍हाना आरे। ");
INSERT INTO taj_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","थेतबासेलमा बाली दुइबा म्‍हिगदे पुइखउ भिसी बालीला दोप्‍ता प्रभुदेन छ्‌याम प्रार्थना लउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","येशूसे ह्राङला च्‍युक न्‍ही चेलागदेदा ङ्‌योइसी जम्‍मान थरीला रोगसे स्‍याप्‍सी आखम्‍बागदेदा खम्‍ना लबादेन म्‍हङगदेदा ताप्‍बा अधिकार पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","येशूला मुल चेलागदे चुनोन हिन्‍ना, जम्‍मान भन्‍दा ङाच्‍छा पत्रुस भिबा सिमोनदेन थेला आले अन्‍द्रियास, जब्‍दियाला झा याकूबदेन याकूबला आले यूहन्‍ना, ");
INSERT INTO taj_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ओच्‍छे फिलिपदेन बारथोलोमाइ, थोमादेन तिरो दुइबा मत्ती, अल्‍फयसला झा याकूबदेन थेदियस, ");
INSERT INTO taj_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ओच्‍छे सिमोन चु सिमोनदा ह्राङला य्‍हुल्‍सादा माया लसी ह्राङला य्‍हुल्‍साला लागिरी ज्‍याननोन पिन्‍खम्‍बा म्‍हि भिसी भिमुबा। ओच्‍छे यहूदा इस्‍करियोत, चुनोन यहूदा इस्‍करियोतसे लिच्‍छा येशूदा चुङ्सी म्‍हिगदेला यारी जिम्‍मा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","येशूसे ह्राङला च्‍युक न्‍ही मुल चेलागदेदा चुह्रङ् भिसी कुल्‍सी पुइजी, “एनीगदे अर्गु य्‍हुलला म्‍हिगदेदेन सामरीगदेला शहररी थानिउ। ");
INSERT INTO taj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","बरु एनीगदे गोठालो आरेबा ग्‍युगदे ह्रङ् तसी भ्रबा इस्राएलीगदे मुबा ग्‍लारी निउ। ");
INSERT INTO taj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ओच्‍छे ‘स्‍वर्गला य्‍हुल्‍सा खसी जिन्‍बा मुला’ भिसी पाङ्‍गो। ");
INSERT INTO taj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ओच्‍छे आखम्‍बा म्‍हिगदेदा खम्‍ना लबादेन सिबा म्‍हिगदेदा सोना लउ। थेह्रङ् लसीन कोरे खबागदेदा खम्‍ना लबादेन म्‍हङगदे ताप्‍गो। एनीगदेसे ओह्रङ्नोन याङ्बा स्‍हे एनीगदेसेएनोन ओह्रङ्नोन पिन्‍गो। ");
INSERT INTO taj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","एनीगदेसे म्‍हर म्‍हुइदेन टाङगा तिगै थाभोर्गो। ");
INSERT INTO taj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ओच्‍छे एनीगदेसे ग्‍यामला लागिरी पोबा क्‍वानदेन झोला ओच्‍छे लखमदेन कडी तिगै थाभोर्गो। तिग्‍दा भिसम गे लबा म्‍हिसे ज्‍याला याङ्तोःमुला। ");
INSERT INTO taj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“एनीगदे शहररी निसै नाम्‍सारी निसै ङाच्‍छा थेरी एनीगदेदा मान लबा म्‍हि खाल चीम थे म्‍हाइगो। ओच्‍छे एनीगदे थेग्‍याम आनितेधोना थेरीन चिउ। ");
INSERT INTO taj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ओच्‍छे थे दिमरी वाङ्मा एनीगदेसे थे दिमला म्‍हिदा “परमेश्‍वरला शान्‍ति एनीगदेदेन छ्‌याम तगै” भिसी पाङ्‍गो। ");
INSERT INTO taj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","थे दिमला म्‍हिसे एनीगदेदा मान लजी भिसम थे दिमला म्‍हिसे शान्‍ति याङ्‌गै। चुदे थे दिमला म्‍हिसे एनीगदेदा मान आलनी भिसम थे दिमला म्‍हिसे शान्‍ति थायाङ्‍गै। ");
INSERT INTO taj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ओच्‍छे खालैसे एनीगदेला ताम आङ्‌यान्‍ना मान आलनी भिसम थे दिमदेन शहरग्‍याम थोन्‍बा धुइरी ह्राङला काङला धुलु खर्सी पिन्‍गो। ");
INSERT INTO taj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, परमेश्‍वरसे निसाफ लबा धिनकुनु थे शहरला म्‍हिगदेला गति भन्‍दा मी सदोमदेन गमोरा शहरला म्‍हिगदेला गति नाखम्‍बा तला। ");
INSERT INTO taj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“च्‍यागो, ङाइ एनीगदेदा फार्बागदेला गुङरी ग्‍युदा पुइबा ह्रङ् लसी पुइला। थेतबासेलमा एनीगदे पुख्री ह्रङ्‌बा चलाक ओच्‍छे ढुकुर ह्रङ् सोजो तसी भ्रउ। ");
INSERT INTO taj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","तर एनीगदे म्‍हिगदे म्राङ्सी होशियार तउ, तिग्‍दा भिसम थेनीगदेसे एनीगदेदा चुङ्सी अदालतरी भोर्ला। ओच्‍छे यहूदीगदे ह्रुप तबा दिमरी भोर्सी एनीगदेदा कोर्रासे तोबा ग्‍याङ्‍बा लला। ");
INSERT INTO taj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ङादा विश्‍वास लबासे लमा थेनीगदेसे एनीगदेदा अञ्‍चलाधीशदेन ग्‍लेला ङाच्‍छापट्टि भोर्ला। एनीगदे थेनीगदेदेन अर्गु य्‍हुलला म्‍हिगदेला लागिरी ङाला साक्षी दोला। ");
INSERT INTO taj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","थेनीगदेसे चुङ्सी भोर्सैनोन खाह्रङ् लसी जोहाब पिन्‍से भिसी एनीगदेसे धन्‍दा सुर्दा लआतोः। तिग्‍दा भिसम थे धुइरी खाह्रङ् लसी पाङ्तोःबा थे ताम एनीगदेदा लोप्‍सी पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","तिग्‍दा भिसम थे धुइरी एनीगदेसे पाङ्बा आहिन, तर परमेश्‍वर आबाला आत्‍मासेन एनीगदेग्‍याम पाङ्ला। ");
INSERT INTO taj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“ह्राङलान ज्‍योज्‍यो आलेसे ह्राङलान ज्‍योज्‍यो आलेदा साइपुङ्ला। थेह्रङ् लसीन आबासे कोलागदेदा साइपुङ्ला, ओच्‍छे कोलागदेसे आबा आमाला बिरोध लसी साइपुङ्ला। ");
INSERT INTO taj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ओच्‍छे ङादा विश्‍वास लबासे लमा एनीगदेदा जम्‍मासेन हेला लला। तर जुन म्‍हिसे जस्‍तोन दुख तसैनोन ह्राङ आसितेधोना ङादा विश्‍वास लबा आख्‍ला थेसे थार्बा याङ्ला। ");
INSERT INTO taj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","म्‍हिगदेसे एनीगदेदा नाम्‍सा गिकरी दुख पिन्‍जी भिसम एनीगदे अर्गु नाम्‍सारी यार्गो। च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, परमेश्‍वरसे पुइखबा म्‍हि खबा भन्‍दा ङाच्‍छा एनीगदे इस्राएलला जम्‍मान नाम्‍सारी धोआखम। ");
INSERT INTO taj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“च्‍यागो, गुरु भन्‍दा चेला घ्रेन आत, ओच्‍छे मालिक भन्‍दा नोकरएनोन घ्रेन आत। ");
INSERT INTO taj_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","चेला ह्राङला गुरु ह्रङ्‌बा दोबादेन नोकर ह्राङला मालिक ह्रङ्‌बा दोबान ठीक मुला। तिग्‍दा भिसम थेनीगदेसे ङा दिमला मुल म्‍हिदाम म्‍हङला ग्‍ले बालजिबुल भिला भिसम झन ङाला म्‍हेमेगदेदा मी तिग भिला? ");
INSERT INTO taj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“थेतबासेलमा थेह्रङ्बा म्‍हिगदेदेन छ्‌याम थालोङ्‍गो। तिग्‍दा भिसम घप्‍सी आम्राङ्बा स्‍हे तिगै आरे, ओच्‍छे छुम्‍सी था आयाङ्बा स्‍हे तिगै आरे। ");
INSERT INTO taj_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","जुन ताम ङाइ एनीगदेदा धोपधोपरी पाङ्बा मुला, थे ताम एनीगदेसे य्‍हालरी पाङ्‍गो, ओच्‍छे जुन ताम एनीगदेसे थेःला, थे ताम एनीगदेसे दिमला धुरीग्‍याम थेःना लउ। ");
INSERT INTO taj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ओच्‍छे एनीगदेला ल्‍हुइदा साइसी आत्‍मादा चा तिगै लबारी आखम्‍बा म्‍हिगदेदेन छ्‌याम थालोङ्‍गो। तर ल्‍हुइदेन आत्‍मा न्‍हीदान साइसी नर्गरी धोना लखम्‍बा परमेश्‍वरदेन छ्‌याम जे लोङ्‍गो। ");
INSERT INTO taj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","डबल गिकरी च्‍युर्गन न्‍ही याङ्मुला। तसैनोन एनीगदेला परमेश्‍वर आबासे सेम आलनी भिसम थे च्‍युर्गनगदे न्‍हङला गिकएनोन आसि। ");
INSERT INTO taj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","एनीगदेला थोबोरी क्रा गाते मुला भिबा ताम सुत्तै परमेश्‍वरदा था मुला। ");
INSERT INTO taj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","थेतबासेलमा एनीगदे थालोङ्‍गो। तिग्‍दा भिसम थे ल्‍हानान च्‍युर्गनगदे भन्‍दा मी एनीगदे ल्‍हानान घ्रेन मुला। ");
INSERT INTO taj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“थेतबासेलमा जुन म्‍हिसे ङादा म्‍हिला ओन्‍छाङरी सेमहेन्‍से प्रभु भिसी पाङ्ला, ङाएनोन स्‍वर्गरी धन्‍छ्‌याबा आबाला ङाच्‍छा थेदा ङाला म्‍हि भिसी भिला। ");
INSERT INTO taj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","तर जुन म्‍हिसे म्‍हिगदेला ओन्‍छाङरी ङादा ङाइ थेदा ङोसेबा आरे भिसी भिला, ङाइएनोन थेदा स्‍वर्गरी धन्‍छ्‌याबा ङाला आबाला ङाच्‍छा ङोसेबा आरे भिसी भिला। ");
INSERT INTO taj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“ङा जम्‍बुलिङरी म्‍हिगदेदा ढिक्‍ना लबारी खबा हिन्‍ना भिसी थाम्‍हन्‍गो। तिग्‍दा भिसम ङा म्‍हिगदेदा ढिक्‍ना लबारी आहिन, तर थेनीगदे न्‍हङरी छेना लबारी खबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","तिग्‍दा भिसम ‘ङा आबाला बिरोधरी झा, आमाला बिरोधरी झामे ओच्‍छे स्‍युमीला बिरोधरी चाङ रेःना लबारी खबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","म्‍हिला शत्रु चा ह्राङलान म्‍हेमेगदे न्‍हङ‍ग्‍याम थोन्‍ना।’ ");
INSERT INTO taj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“जुन म्‍हिसे ङादा भन्‍दा ह्राङला आबा आमादेन कोलागदेदा माया लला, थे म्‍हि ङाला चेला दोबारी आखम। ");
INSERT INTO taj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ओच्‍छे जुन म्‍हिसे आसितेधोना ह्राङला दुख ह्राङसेन नासी ङादेन छ्‌याम आभ्र, थे म्‍हि ङाला चेला दोबाधोनाला आरे। ");
INSERT INTO taj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","जुन म्‍हिसे ह्राङला ज्‍यान जोगब लबारी म्‍हाइला थे म्‍हिसे जुकजुकधोनाला जुनी आयाङ्। तर ङाला लागिरी ज्‍याननोन पिन्‍खम्‍बा म्‍हिसे जुकजुकधोनाला जुनी याङ्ला। ");
INSERT INTO taj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“एनीगदेदा मान लबा म्‍हिगदेसे ङादाएनोन मान लला। ओच्‍छे ङादा मान लबागदेसे ङादा पुइखबादाएनोन मान लला। ");
INSERT INTO taj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","जुन म्‍हिसे अगमवक्तादा ‘अगमवक्ता’ भिसी मान लला, थेसेनोन अगमवक्तासे याङ्बा ह्रङ्‌बान इनाम याङ्ला। थेह्रङ् लसीन जुन म्‍हिसे परमेश्‍वरदा सेम निबा म्‍हिदा ‘परमेश्‍वरदा सेम निबा म्‍हि’ भिसी मान लला, थेसेनोन थे परमेश्‍वरदा सेम निबा म्‍हिसे याङ्बा ह्रङ्‌बान इनाम याङ्ला। ");
INSERT INTO taj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","च्‍यागो, खालैसे चुगदे न्‍हङला गिकदा ङाला चेला भिसी सिम्‍बा क्‍युइ जे थुङ्बारी पिन्‍सैनोन थेसे याङ्तोःबा इनाम याङ्ला।” ");
INSERT INTO taj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","येशूसे ह्राङला च्‍युक न्‍ही चेलादा चुह्रङ् सुङ्सी जिन्‍माहेन्‍से गालील अञ्‍चलला नाम्‍सागदेरी परमेश्‍वरला य्‍हुल्‍साला समाचार लोप्‍बारीदेन थेःना लबारी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","थे धुइरी बप्‍तिस्‍मा पिन्‍बा यूहन्‍ना झ्‍याल्‍खानरी मुबा। थार्बा पिन्‍बा ख्रीष्‍टसे लबा गेला बारेरी थेःसी यूहन्‍नासे ह्राङला चेलागदेदा “ङन्‍से फेप्‍खला भिसी आश लसी चिबा थार्बा पिन्‍बा ग्‍ले ह्राङनोन हिन्‍ना कि स्‍य्‍हान्‍दो खालैदा भ्रान्‍तोःबा हिन्‍ना?” भिसी ङ्‌योइबारी थार्बा पिन्‍बा ख्रीष्‍ट मुबा ग्‍लारी पुइजी। ");
INSERT INTO taj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","जमाहेन्‍से येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदेसे थेःबादेन म्राङ्बा ताम निसी यूहन्‍नादा पाङ्सी पिन्‍गो। ");
INSERT INTO taj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","मी आम्राङ्बागदेला मी म्राङ्ना लबा मुला, कुज्‍यादेन कोरे खबा म्‍हिगदेदा खम्‍ना लबा मुला, नाब्‍यङ आथेःबागदेदा थेःना लबा मुला, सिबागदेदा सोना लबा मुला, ओच्‍छे प्राङबोगदेदा परमेश्‍वरला य्‍हुल्‍साला समाचार थेःना लबान मुला। ");
INSERT INTO taj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","जुन म्‍हिसे शङ्का आलना विश्‍वास लला, थे म्‍हिसे परमेश्‍वरग्‍याम मोलम याङ्ला।” ");
INSERT INTO taj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","थेनीगदे निमाहेन्‍से येशूसे थेरी मुबा म्‍हिगदेदा यूहन्‍नाला बारेरी सुङ्बारी छ्‌याइजी, “एनीगदे तोङतोङबा ग्‍लारी तिग च्‍याबारी निबा मुबा? तिग लाबासे य्‍होङ्बा मा दोङ च्‍याबारी निबा हिन्‍ना? ");
INSERT INTO taj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ओच्‍छे एनीगदे तिग च्‍याबारी थोन्‍बा मुबा? ज्‍यबा ज्‍यबा क्‍वान क्‍वान्‍बा म्‍हिदा च्‍याबारी? च्‍यागो, ज्‍यबा ज्‍यबा क्‍वान क्‍वान्‍बा म्‍हिगदे मी ग्‍लेखाङरी जे चिमुला। ");
INSERT INTO taj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","एनीगदे तिग च्‍याबारी निमुबा? तिग अगमवक्तादा च्‍याबारी निबा आहिन? हिन्‍ना, ङाइ पाङ्ला एनीगदेसे स्‍य्‍हान्‍दो अगमवक्तागदे भन्‍दा घ्रेन म्‍हि गिक म्राङ्बा मुला। ");
INSERT INTO taj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","चुनोन यूहन्‍नाला बारेरी परमेश्‍वरला बचनरी चुह्रङ् भिसी भ्रिबा मुला, ‘च्‍यागो, ङाइ ङाला समाचार भोर्बा म्‍हिदा एला ङाच्‍छा ङाच्‍छा पुइला। थेसे एला लागिरी ग्‍याम स्‍होला।’ ");
INSERT INTO taj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“च्‍यागो, दान्‍देधोना बप्‍तिस्‍मा पिन्‍बा यूहन्‍ना भन्‍दा घ्रेन म्‍हि खालैनोन न्‍हबा आरे। तसैनोन जुन म्‍हि स्‍वर्गला य्‍हुल्‍सारी जम्‍मान भन्‍दा जजा मुला, थे बप्‍तिस्‍मा पिन्‍बा यूहन्‍ना भन्‍दा घ्रेन हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","बप्‍तिस्‍मा पिन्‍बा यूहन्‍नाला धुइहेन्‍से दान्‍देधोना थेःना लबा स्‍वर्गला य्‍हुल्‍साला बारेरी ल्‍हानान गे तबा मुला। तर ह्राङसे ह्राङदान शक्तिशाली म्‍हन्‍बा म्‍हिगदे चा ह्राङलान भङसे स्‍वर्गला य्‍हुल्‍सारी वाङ्बारी म्‍हाइबा मुला। ");
INSERT INTO taj_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","तिग्‍दा भिसम यूहन्‍नाला धुइधोना परमेश्‍वरसे मोशादा पिन्‍बा ठिमदेन जम्‍मान अगमवक्तागदेसे परमेश्‍वरला य्‍हुल्‍साला बारेरी पाङ्बा मुला। ");
INSERT INTO taj_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","एनीगदेसे अगमवक्तागदेसे पाङ्बा ताम विश्‍वास लबा हिन्‍सम थेनीगदेसे खाल भिसी पाङ्बा एलिया चा चुनोन यूहन्‍ना हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","जुन म्‍हिदा ङ्‌यान्‍बा सेम मुला, थेसे ङ्‌यान्‍सी घोउ। ");
INSERT INTO taj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“दान्‍देला म्‍हिगदेदा ङाइ खाह्रङ् लसी घोना लसे? थेनीगदे मी ग्‍यामरीक्‍यार क्‍लाङ्बा कोलागदे ह्रङ्‌बान हिन्‍ना। थेनीगदेसे ह्राङला ह्रोगदेदा ङ्‌योइसी चुह्रङ् भिमुला, ");
INSERT INTO taj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘ङन्‍से एनीगदेला लागिरी बाँसुरी ह्राप्‍सी पिन्‍जी, तर एनीगदे आस्‍य्‍हनी। ओच्‍छे ङन्‍से दुखला व्‍हाइ गोजी, तर एनीगदे आक्रानी।’ ");
INSERT INTO taj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","चुह्रङ् लसीन यूहन्‍नासे अङगुरला निङगु आथुङ्ना फोइथान चिसी प्रार्थना लमुबा, जमा म्‍हिगदेसे ‘थेदा म्‍हङसे स्‍याप्‍बा म्‍हि’ भिसी भिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","परमेश्‍वरसे पुइखबा म्‍हि चा चबा थुङ्बा लसी भ्रजी। थेतबासेलमा म्‍हिगदेसे ङादा ‘च्‍यागो, ल्‍हानान चबा स्‍हेदेन ल्‍हानान निङगु कासी ङ्‌य्‍होइसी भ्रबा, तिरो दुइबादेन पापीगदेला ह्रो’ भिसी भिमुला! तर परमेश्‍वरला बुद्धिग्‍याम गे लबा म्‍हिदा थेसे लबा गेगदेग्‍यामसेन थे ठीक हिन्‍ना भिसी था याङ्ला।” ");
INSERT INTO taj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","जमाहेन्‍से जुन जुन नाम्‍सारी येशूसे ल्‍हानान उदेकला गेगदे लबा मुबा, थे नाम्‍साला म्‍हिगदेदा दाहेन्‍से ज्‍यबा तसेला आरे भिसी सुङ्बारी छ्‌याइजी, तिग्‍दा भिसम थेनीगदेसे ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि आदोःनी। ");
INSERT INTO taj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“खोराजीनदेन बेथसेदाला म्‍हिगदे, एनीगदेसे परमेश्‍वरग्‍याम सजाय याङ्ला। तिग्‍दा भिसम एनीगदेला नाम्‍सारी लबा ह्रङ्‌बा उदेकला गेगदे टुरोसदेन सीदोन शहररी लबा हिन्‍सम ओन्‍मान थेनीगदेसे बोरा क्‍वान्‍सी मेफ्रा फोर्सी ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःसेला मुबा। ");
INSERT INTO taj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","तर एनीगदेसे ङाला ताम ङ्‌यान्‍गो, परमेश्‍वरसे निसाफ लबा धुइरी एनीगदेला दुख भन्‍दा टुरोसदेन सीदोनला म्‍हिगदेला दुख नाखम्‍बा तला ");
INSERT INTO taj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","कफर्नहुमला म्‍हिगदे, तिग एनीगदे स्‍वर्गरीन धोला भिसी म्‍हन्‍मुला? आधो! एनीगदेदा मी नर्गरी भ्‍याङ्‍ला। तिग्‍दा भिसम एनीगदेला गुङरी लबा उदेकला गेगदे सदोमरी लबा हिन्‍सम थे नाम्‍सा तिनीधोना चिसेला मुबा। ");
INSERT INTO taj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","च्‍यागो, परमेश्‍वरसे निसाफ लबा धुइरी सदोमला म्‍हिगदेसे भन्‍दा एनीगदेसे ल्‍हानान सजाय याङ्ला?” ");
INSERT INTO taj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","थे धुइरी येशूसे चुह्रङ् भिसी प्रार्थना लजी, “मुदेन जम्‍बुलिङला प्रभु आबा, ह्राङदा धन्‍यवाद मुला, तिग्‍दा भिसम ह्राङसे ज्ञान बुद्धि मुबा म्‍हिगदेदेन सेबा घोबा म्‍हिगदेग्‍याम छुम्‍सी थान्‍बा ताम तिगै आसेबा म्‍हिगदेदा उन्‍सी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","हिन्‍ना आबा, चुह्रङ् लमान ह्राङ ताङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“ङाला आबासे ङादा जम्‍मान स्‍हे जिम्‍मा पिन्‍बा मुला। थेतबासेलमा झा खाल हिन्‍ना भिसी आबादा बाहेक स्‍य्‍हान्‍दो खालैदान था आरे। थेह्रङ् लसीन आबा खाल भिसी झादेन झासे आबादा ङोसेना लबा म्‍हिगदेसे बाहेक स्‍य्‍हान्‍दो खालैदान आबा खाल हिन्‍ना भिसी था आरे। ");
INSERT INTO taj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“धोइ पुइसी ब्‍लप्‍बा म्‍हिगदे, ङा मुबा ग्‍लारी खउ, ङाइ एनीगदेला ब्‍लप्‍बा साल्‍ना लला। ");
INSERT INTO taj_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ङाला जुवा पुइसी ङाग्‍याम लोप्‍गो, तिग्‍दा भिसम ङाला सेम ङेम्‍बादेन दयासे प्‍लिङ्बा मुला। थेतबासेलमा एनीगदेला सेमरी शान्‍ति तला। ");
INSERT INTO taj_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","तिग्‍दा भिसम ङाइ काप्‍बा जुवा सजिलो मुला, ओच्‍छे ङाइ काप्‍बा धोइ याङ्बा मुला।” ");
INSERT INTO taj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","येशूदेन थेला चेलागदे ब्‍लप्‍बा न्‍हबा धिनकुनु बु‍ग्‍याम फेप्‍बान मुबा। थे धुइरी फोख्रेन्‍बासे लमा थेला चेलागदेसे ग्‍वाला नम थुसी चबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","थेनीगदेसे चुह्रङ् लबा म्राङ्सी फरिसीगदेसे येशूदा “च्‍यागो, ह्राङला चेलागदेसे ब्‍लप्‍बा न्‍हबा धिनकुनु लबारीन आतबा गे लजी” भिसी पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","जमाहेन्‍से थेनीगदेदा येशूसे चुह्रङ् भिसी सुङ्जी, “दाऊददेन थेला ह्रोगदेदा फोख्रेन्‍बा धुइरी थेनीगदेसे तिग लजी? तिग एनीगदेसे खाइमै परमेश्‍वरला बचन पढब लबा आरे? ");
INSERT INTO taj_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","थे धुइरी दाऊदसे परमेश्‍वरला दिमरी वाङ्सी परमेश्‍वरदा फुल्‍बा गेङ भसी ह्राङला ह्रोगदेदेन छ्‌याम ढिक्‍सी चजी। थे गेङ थेनीगदेसे चबारीन आतमुबा। तिग्‍दा भिसम थे गेङ परमेश्‍वरला मन्‍दिररी पूजा लबा म्‍हिसे जे चबारी तमुबा। ");
INSERT INTO taj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ओच्‍छे एनीगदेसे परमेश्‍वरसे मोशादा पिन्‍बा ठिम पढब लबा आरे? ब्‍लप्‍बा न्‍हबा धिनकुनुएनोन परमेश्‍वरला मन्‍दिररी पूजा लबा म्‍हिगदेसे गे लमुला, तसैनोन थेनीगदेसे पाप लबा मुला भिसी आम्‍हन्‍मुला। ");
INSERT INTO taj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","तर एनीगदेसे ङाला ताम ङ्‌यान्‍गो, परमेश्‍वरला मन्‍दिर भन्‍दा घ्रेन चुरी स्‍य्‍हान्‍दो खालै मुला। ");
INSERT INTO taj_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","थेतबासेलमा ‘ङाइ म्‍हाइबा चा बलिदान आहिन, तर एनीगदेसे स्‍य्‍हान्‍दोदा लबा दया हिन्‍ना’ भिसी बचनरी भ्रिबा ताम घोबा हिन्‍सम एनीगदेसे तिगै दोष आरेबा म्‍हिदा दोष आलसेला मुबा। ");
INSERT INTO taj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","तिग्‍दा भिसम परमेश्‍वरसे पुइखबा म्‍हि ब्‍लप्‍बा न्‍हबा धिनना प्रभु हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","थेग्‍याम येशू यहूदीगदे ह्रुप तबा दिमरी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","थेरी या गिक खर्बा म्‍हि मुबा। फरिसीगदेसे येशूदा दोष लबाला लागिरी “तिग ब्‍लप्‍बा न्‍हबा धिनकुनु खालै म्‍हिदा खम्‍ना लबा ठीक हिन्‍ना?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","जमाहेन्‍से येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदे न्‍हङ‍री खालैला ग्‍यु गिक ब्‍लप्‍बा न्‍हबा धिनकुनु व्‍हाङरी ताइजी भिसम एसे थे ग्‍युदा आतेःना थेह्रङ्नोन थान्‍ना? ");
INSERT INTO taj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","एनीगदेसे ग्‍युदा मी तेःमुला भिसम म्‍हि ग्‍यु भन्‍दा घ्रेन आहिन? थेतबासेलमा ब्‍लप्‍बा न्‍हबा धिनकुनु खालैदा ज्‍यबा लबा ठीक हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","जमाहेन्‍से येशूसे थे म्‍हिदा “एला या तन्‍गब लउ” भिसी सुङ्माहेन्‍से थेसे या तन्‍गब लजी। तन्‍गब लमैछ्‌याम थेला या अर्गु या ह्रङ्‌बान ज्‍यबा तजी। ");
INSERT INTO taj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","जमाहेन्‍से फरिसीगदे थेग्‍याम थोन्‍सी निजी, ओच्‍छे येशूदा खाह्रङ् लसी साइबा भिसी ह्राङ ह्राङ न्‍हङरी सल्‍लाह लबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","फरिसीगदेला ताम था याङ्सी येशू थेग्‍याम फेप्‍जी। जमाहेन्‍से म्‍हिला हुलएनोन येशूदेन छ्‌यामनोन खजी, ओच्‍छे येशूसे आखम्‍बा जम्‍मान म्‍हिगदेदा खम्‍ना लजी। ");
INSERT INTO taj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","तर येशूसे थे म्‍हिला ल्‍हुइरी मुबा म्‍हङदा “च्‍यागो, ङा परमेश्‍वरला झा हिन्‍ना भिसी खालैदा थापाङ्‍गो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","यशैया भिबा अगमवक्तासे पाङ्बा ताम पूरा तबारीन येशूसे चुह्रङ् सुङ्बा हिन्‍ना। यशैया अगमवक्ताग्‍याम परमेश्‍वरसे चुह्रङ् भिसी सुङ्बा मुला, ");
INSERT INTO taj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“ङाइ धम्‍बा ङादा तेन्‍बा म्‍हि म्राङ्सी ङा ताङ्‍बा मुला। ओच्‍छे थेदा ङाइ माया लसी ङाला आत्‍मा थेथोरी थान्‍सी पिन्‍बा मुला, थेसे ङाइ लबा निसाफला बारेरी जम्‍मान य्‍हुलला म्‍हिगदेदा पाङ्ला। ");
INSERT INTO taj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","थे छेबा बङ्बा लसी आभ्र ओच्‍छे ल्‍हानान क्रिङ्सीएनोन आभ्र। थेतबासेलमा थे ग्‍यामरीक्‍यार क्रिङ्सी भ्रबा खालैसे आथेः। ");
INSERT INTO taj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","थिबा मादा आक्‍युइना जोगब लसी थान्‍बा ह्रङ् लसी दुखरी मुबा म्‍हिगदेदा थेसे जोगब लसी थान्‍ना। थेह्रङ् लसीन छ्‌युगु जिन्‍सी सिबारी छ्‌याइबा नाङसलदा सिआपुङ्बा ह्रङ् लसी थेसे विश्‍वासरी कमजोर तबा म्‍हिगदेदाएनोन जोगब लसी थान्‍ना। ओच्‍छे जम्‍मादान ठीक निसाफ लसी थार्ना लला। ");
INSERT INTO taj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","थेतबासेलमा जम्‍मान य्‍हुलला म्‍हिगदेसे थेथोरी आश लला।” ");
INSERT INTO taj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","जमाहेन्‍से म्‍हिगदेसे म्‍हङसे स्‍याप्‍सी ताइ दोबादेन मी आम्राङ्बा म्‍हि गिकदा येशू मुबा ग्‍लारी भजी। येशूसे थेदा खम्‍ना लजी, जमाहेन्‍से थेसे म्राङ्‌खम्‍जी तामएनोन पाङ्‍खम्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","चु म्राङ्सी थेरी मुबा जम्‍मान म्‍हिगदे उदेक तसी “चु दाऊद ग्‍लेला सन्‍ताननोन हिन्‍ना?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","तर चुह्रङ्बा ताम थेःसी फरिसीगदेसे येशूदा “चु म्‍हिसे मी म्‍हङगदेला ग्‍ले बालजिबुलला शक्तिग्‍याम जे म्‍हङगदे ताप्‍बा हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","तर थेनीगदेला सेमला ताम था याङ्सी येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “च्‍यागो, जुन य्‍हुल्‍साला म्‍हिगदे ह्राङ ह्राङ न्‍हङ‍री तोबा छेबा लला थे य्‍हुल्‍सा नाश तला, ओच्‍छे दिम गिकलान म्‍हिएनोन ह्राङ ह्राङ न्‍हङ‍री आढिक्‍नी भिसम थे दिमएनोन फुप्‍ला। ");
INSERT INTO taj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","थेतबासेलमा शैतानसे शैतानदान ताप्‍जी भिसम थेनीगदे ह्राङ ह्राङ न्‍हङ‍री फेला। थेह्रङ् लजी भिसम थेनीगदेला य्‍हुल्‍सा खाह्रङ् लसी टुला? ");
INSERT INTO taj_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ङाइ बालजिबुलला शक्तिग्‍याम म्‍हङ ताप्‍मुला भिसम एनीगदेला चेलागदेसे चा खाल्‍ला शक्तिग्‍याम म्‍हङ ताप्‍बा हिन्‍ना? थेतबासेलमा एनीगदेला गल्‍ती थेनीगदेसेन उन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","तर ङाइ परमेश्‍वरला आत्‍माग्‍याम म्‍हङ ताप्‍बा मुला भिसम एनीगदेला गुङरी परमेश्‍वरला य्‍हुल्‍सा खसी जिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“भङ्‍बा म्‍हिला दिमरी वाङ्सी ङाच्‍छा थे म्‍हिदा आखीना खालैसे थेला धन सम्‍पत्ति य्‍हो लखम्‍ला? थे भङ्‍बा म्‍हिदा खीमाहेन्‍से जे थेसे थेला धन सम्‍पत्ति भोर्खम्‍ला। ");
INSERT INTO taj_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“जुन म्‍हि ङादेन छ्‌याम आढिक, थे म्‍हि ङाला बिरोधी तला। ओच्‍छे जुन म्‍हिसे ङा मुबा ग्‍लारी म्‍हिगदे आभ, थे म्‍हिसे ङाला बिरोधरी गे लला। ");
INSERT INTO taj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","थेतबासेलमा म्‍हिगदेसे जस्‍तोन पाप गेदेन पाप तामगदे लसैनोन थेनीगदेदा माफ लला। तर परमेश्‍वरला आत्‍मादा बिरोध लसी पाप ताम लबा म्‍हिसे खाइमै माफ आयाङ्। ");
INSERT INTO taj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","थेह्रङ् लसीन खालै म्‍हिसे परमेश्‍वरसे पुइखबा म्‍हिदा बिरोध लसी ताम पाङ्सै थेसे माफ याङ्ला। तर परमेश्‍वरला आत्‍मादा बिरोध लसी ताम पाङ्जी भिसम थेदा दान्‍देला धुइरी माफ आल, लिच्‍छाला जुनीरीनोन माफ आयाङ्। ");
INSERT INTO taj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“ज्‍यना लसी सयार लबा दोङरी ज्‍यना लसीन रोला। ओच्‍छे ज्‍यना लसी सयार आलबा दोङरी ज्‍यना लसी आरो। थेतबासेलमा सयार लजीम कि आलजीम भिबा ताम रोग्‍यामसेन था तला। ");
INSERT INTO taj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","पुख्रीला कोलागदे, एनीगदेला सेमरीन पाप मुला भिसम खाह्रङ् लसी ज्‍यबा ताम पाङ्‌खम्‍ला? तिग्‍दा भिसम सेमरी जुन ताम मुला, थेनोन ताम एनीगदेसे पाङ्बा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ज्‍यबा सेम मुबा म्‍हिला सेम न्‍हङ‍ग्‍याम ज्‍यबान ताम थोन्‍मुला ओच्‍छे नइबा सेम मुबा म्‍हिला सेम न्‍हङ‍ग्‍याम नइबान ताम थोन्‍मुला। ");
INSERT INTO taj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","थेतबासेलमा एनीगदेसे ङाला ताम ङ्‌यान्‍गो, परमेश्‍वरसे निसाफ लबा धिनकुनु आतोःबा ताम पाङ्बा म्‍हिगदेसे ह्राङ ह्राङला हिसाब उन्‍तोःला। ");
INSERT INTO taj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","तिग्‍दा भिसम एला दोष मुला कि आरे भिबा एला तामग्‍यामसेन था तला।” ");
INSERT INTO taj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","जमाहेन्‍से यहूदी धर्मगुरुगदेदेन फरिसीगदे न्‍हङला कोइ कोइसे येशूदा “गुरु, ङन्‍दा ह्राङसे लबा उदेकला गे च्‍याबा सेम मुला” भिसी पाङ्‌मा, ");
INSERT INTO taj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","येशूसे थेनीगदेदा चुह्रङ् भिसी जोहाब पिन्‍जी, “नइबा बानिबेहोर थोसी स्‍य्‍हान्‍दोदेन छ्‌याम ब्रेल्‍सी भ्रबा म्‍हिगदेसे उदेकला चिनु जे म्‍हाइमुला। तर दान्‍देला म्‍हिगदेदा चा योना अगमवक्ताला चिनु बाहेक अर्गु चिनु आउन। ");
INSERT INTO taj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","तिग्‍दा भिसम धिन सोम म्‍हुन सोमधोना योना घ्रेन तार्ङाला फोरी चिबा ह्रङ् लसी परमेश्‍वरसे पुइखबा म्‍हिएनोन धिन सोम म्‍हुन सोमधोना धुर्सारी तला। ");
INSERT INTO taj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","च्‍यागो, परमेश्‍वरसे निसाफ लबा धुइरी निनवे शहरला म्‍हिगदे रेःसी दान्‍देला म्‍हिगदेला दोष उन्‍ना। तिग्‍दा भिसम योना अगमवक्तासे पाङ्बा परमेश्‍वरला य्‍हुल्‍सा समाचार थेःसी, थेनीगदे ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःबा मुबा। तर चुरी योना अगमवक्ता भन्‍दा घ्रेन म्‍हि गिक मुला। तसैनोन एनीगदेसे थेला ताम आङ्‌यान्‍नी। ");
INSERT INTO taj_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","निसाफ लबा धुइरी ल्‍होग्‍याम खबा ग्‍लेस्‍यासे दान्‍देला म्‍हिगदेला दोष उन्‍ना, तिग्‍दा भिसम थे सोलोमन ग्‍लेला ज्ञान बुद्धिला ताम ङ्‌यान्‍बारी ल्‍हानान थारेङग्‍याम खबा मुबा। तर च्‍यागो, चुरी सोलोमन ग्‍ले भन्‍दा घ्रेन म्‍हि मुसैनोन थेला ताम आङ्‌यान्‍नी। ");
INSERT INTO taj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“म्‍हङ म्‍हिला ल्‍हुइग्‍याम थोन्‍सी निमाहेन्‍से थेसे ब्‍लप्‍बा न्‍हबारी तोङतोङबा ग्‍लारीक्‍यार ग्‍ला म्‍हाइसी भ्रला। ओच्‍छे खानङएनोन ब्‍लप्‍बा न्‍हबा ग्‍ला आयाङ्माहेन्‍से, ");
INSERT INTO taj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘ङा जुन म्‍हिला ल्‍हुइग्‍याम थोन्‍सी खजी थेनोन म्‍हिला ल्‍हुइरी चिबारी निइ’ भिसी दोःसी निला। दोःसी खमा थेसे ङाच्‍छा ह्राङ चिबा ग्‍ला खालै आरेबा साङसाङबा म्राङ्ला। ");
INSERT INTO taj_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","जमाहेन्‍से थे म्‍हङ निसी ह्राङ भन्‍दा नइबा अर्गु गोर निस म्‍हङगदे भसी थे म्‍हि न्‍हङरी वाङ्सी चिमुला। थेतबासेलमा थे म्‍हिला गति ङाच्‍छाला भन्‍दा लिच्‍छाला गति झन नइबा तला। दान्‍देला म्‍हिगदेदाएनोन थेह्रङ्बान तला।” ");
INSERT INTO taj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","येशू म्‍हिगदेदेन छ्‌याम ताम लबान लबा धुइरी येशूदेन छ्‌याम ताम लबारी भिसी थेला आमादेन आलेगदे मङग्‍यार खसी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","जमाहेन्‍से म्‍हि गिकसे “ह्राङदेन छ्‌याम ताम लबारी भिसी ह्राङला आमादेन आलेगदे मङग्‍यार खसी चिमुला” भिसी येशूदा पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","तर येशूसे थे म्‍हिदा “ङाला आमा खाल? ङाला आलेगदे खाल?” ");
INSERT INTO taj_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ओच्‍छे येशूसे ह्राङला चेलागदेदा उन्‍बान चुह्रङ् भिसी सुङ्जी, “च्‍यागो, चुरी मुबा जम्‍मान ङाला आमादेन आलेगदे हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","तिग्‍दा भिसम जुन म्‍हि स्‍वर्गरी धन्‍छ्‌याबा ङाला आबासे म्‍हन्‍बा अन्‍छार भ्रला थेनोन ङाला आमा, ङाला आङा ओच्‍छे ङाला आले हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","जमाकुनु येशू दिमग्‍याम फेप्‍सी समुन्‍द्रला कुनीरी धन्‍छ्‌याजी। ");
INSERT INTO taj_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ओच्‍छे थेरी म्‍हिला हुल मुबासेलमा येशू दोँगारी धन्‍छ्‌याजी। ओच्‍छे म्‍हिला हुल चा समुन्‍द्रला कुनीरीक्‍यार राप्‍सी चिजी। ");
INSERT INTO taj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","जमाहेन्‍से थेरी मुबा म्‍हिगदेदा येशूसे उखानग्‍याम ल्‍हानान ताम लोप्‍बान चुह्रङ् भिसी सुङ्जी, “च्‍यागो, ब्‍लु ढ्वबा म्‍हि गिक ब्‍लु ढ्वबारी भ्रजी। ");
INSERT INTO taj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","थे म्‍हिसे ब्‍लु ढ्वमा कोइ ब्‍लु ग्‍यामरी परब तजी, थे ब्‍लु चरागदे खसी चजी। ");
INSERT INTO taj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","कोइ ब्‍लु चा युङबाला घह्रङ मुबा सरी परब तजी, ओच्‍छे थेरी साप्रा ल्‍हाना आरेबासे लमा योनान फुइजी। ");
INSERT INTO taj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","तर साप्रा ल्‍हाना आरेबासे लमा थेला टा नुप्‍ना निआम्‍याङ्नी। थेतबासेलमा धिनीसे क्रोसी थे दोङ सिजी। ");
INSERT INTO taj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","कोइ ब्‍लु चा पुजु झाङरी परब तजी, ओच्‍छे थे ब्‍लुदेन पुजु दोङ छ्‌याम छ्‌यामनोन फुइजी। तर पुजु दोङ ल्‍हेबान निबासे लमा थे दोङदा हाप तजी। ");
INSERT INTO taj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","कोइ ब्‍लु चा ज्‍यबा सरी परब तसी फुइजी, ओच्‍छे कोइ दोङरी दोब्‍बर, कोइ दोङरी तेब्‍बर, कोइ दोङरी चौबरधोना रोजी। ");
INSERT INTO taj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","जुन म्‍हिदा ङ्‌यान्‍बा सेम मुला थेसे ङ्‌यान्‍सी घोउ।” ");
INSERT INTO taj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","जमाहेन्‍से चेलागदेसे येशूदा “ह्राङसे थेनीगदेदा तिग्‍दा उखानग्‍यामसे जे लोप्‍बा?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","येशूसे थेनीगदेदा चुह्रङ् भिसी जोहाब पिन्‍जी, “म्‍हिसे था आयाङ्‍बा स्‍वर्गला य्‍हुल्‍साला ताम ङाइ एनीगदेदा घोखम्‍बा ज्ञान बुद्धि पिन्‍बा मुला। तर थेनीगदेदा चु ज्ञान बुद्धि पिन्‍बा आरे। ");
INSERT INTO taj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","तिग्‍दा भिसम जुन म्‍हिसे ङाइ लोप्‍बा तामदा सेम लसी ङ्‌यान्‍ना, थेदा ङाइ अझन घोना लला। तर ङाइ लोप्‍बा ताम आङ्‌यान्‍बादा चा थेसे जुन घोबा मुला थे तामएनोन म्‍हाना लला। ");
INSERT INTO taj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","थेनीगदेसे ङाइ लबा गे च्‍याबाम च्‍यामुला तर आम्राङ्मुला, ओच्‍छे ङाइ पाङ्बा ताम ङ्‌यान्‍बाम ङ्‌यान्‍मुला तर आघोमुला। थेतबासेलमान ङाइ थेनीगदेदा उखानग्‍याम पाङ्बा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“परमेश्‍वरसे यशैया अगमवक्ताग्‍याम सुङ्बा ताम चुह्रङ् लसी पूरा तबा मुला, ‘थेनीगदेसे ङ्‌यान्‍बाम ङ्‌यान्‍मुला तर खाइमै आघोमुला, च्‍याबाम च्‍यामुला तर खाइमै आम्राङ्मुला, ");
INSERT INTO taj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","तिग्‍दा भिसम चु म्‍हिगदेला सेम कोङ्बा मुला, थेनीगदेला नाब्‍यङसे आथेःमुला, ओच्‍छे थेनीगदेसे मी च्‍युम्‍बा मुला। आहिन्‍सम थेनीगदेसे म्राङ्सेला मुबा, थेःसेला मुबा, सेमहेन्‍सेन घोसेला मुबा, ङापट्टि दोःसेला मुबा, ओच्‍छे थेनीगदेदा ङाइ खम्‍ना लसेला मुबा।’” ");
INSERT INTO taj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","जमाहेन्‍से येशूसे ह्राङला चेलागदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदेसे परमेश्‍वरग्‍याम मोलम याङ्ला, तिग्‍दा भिसम एनीगदेसे म्राङ्बाएनोन मुला थेःबाएनोन मुला। ");
INSERT INTO taj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, ल्‍हानान अगमवक्तादेन परमेश्‍वरसे म्‍हन्‍बा अन्‍छार भ्रबा म्‍हिगदेसे एनीगदेसे म्राङ्बा चु तामगदे च्‍याबारी म्‍हाइमुबा। तर थेनीगदेसे आम्राङ्‌नी, ओच्‍छे एनीगदेसे थेःबा ताम थेनीगदेसे थेःबारी म्‍हाइजी, तर थेःबारी आम्‍याङ्नी। ");
INSERT INTO taj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“लु, ब्‍लु ढ्वबा उखानना अर्थ ङ्‌यान्‍गो। ");
INSERT INTO taj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ग्‍यामरीक्‍यार परब तबा ब्‍लुला अर्थ चुनोन हिन्‍ना, जुन म्‍हिसे परमेश्‍वरला बचन ङ्‌यान्‍ना, तर थेसे घोबा भन्‍दा ङाच्‍छान शैतान खसी थेनीगदेला सेमग्‍याम थे ताम ब्‍यन्‍सी भोर्ला। ");
INSERT INTO taj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","युङबाला घह्रङ मुबा सरीक्‍यार परब तबा ब्‍लुला अर्थ चुनोन हिन्‍ना, जुन म्‍हिसे परमेश्‍वरला बचन ङ्‌यान्‍सी तुरुन्‍तन विश्‍वास लला। ");
INSERT INTO taj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","तर थेनीगदेला विश्‍वासला टा आरेबासे लमा, थे छिन्‍नङ जे चिला। ओच्‍छे परमेश्‍वरला बचनदा विश्‍वास लबासे लमा थेनीगदेदा आपत विपत खमाहेन्‍से थेनीगदेसे विश्‍वास लबा ख्‍लाला। ");
INSERT INTO taj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","पुजु झाङ न्‍हङरी परब तबा ब्‍लुला अर्थ चा जुन म्‍हिसे परमेश्‍वरला बचन ङ्‌यान्‍ना, तर चु जम्‍बुलिङला धन्‍दा सुर्दादेन धन सम्‍पत्तिला लोभसे लमा परमेश्‍वरला बचनदा गे लआपुङ्। थेतबासेलमा थेला विश्‍वासग्‍याम तिगै आरो। ");
INSERT INTO taj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","तर ज्‍यबा सरी परब तबा ब्‍लुला अर्थ चा जुन म्‍हिसे परमेश्‍वरला बचन ङ्‌यान्‍सी ह्राङला सेमरी थान्‍ना, ओच्‍छे थेला विश्‍वासग्‍याम दोब्‍बर, तेब्‍बर, चौबरधोनाला रो रोला।” ");
INSERT INTO taj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","दोःसी येशूसे थेनीगदेदा उखान गिक सुङ्जी, “च्‍यागो, स्‍वर्गला य्‍हुल्‍सा ह्राङला बुरी ज्‍यबा ब्‍लु ढ्वबा म्‍हि ह्रङ्‌बान हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","तर जम्‍मान म्‍हिगदे म्‍हेर्बा धुइरी थेला शत्रु खसी ग्‍वा न्‍हङरी कोडोङ ढ्‌वसी निजी। ");
INSERT INTO taj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","थे ग्‍वा ल्‍हेबान निसी रोबा धुइरी चा ग्‍वा न्‍हङ‍री कोडोङला दोङएनोन म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“थेतबासेलमा नोकरगदे दिमला मालिक मुबा ग्‍लारी खसी ‘बुरी ह्राङसे ग्‍वा जे ढ्वबा आहिन? थेरीम कोडोङएनोन फुइजीम’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“जमाहेन्‍से दिमला मालिकसे थेनीगदेदा ‘खालै शत्रुसे चुह्रङ् लबा हिन्‍ना’ भिसी भिमा, नोकरगदेसे ‘थेह्रङ् भिसम ङनी निसी थे कोडोङ स्‍योइसी भ्‍याङ्‍गो?’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“तर थे मालिकसे नोकरगदेदा चुह्रङ् भिसी पाङ्जी, ‘दान्‍देन थास्‍योइगो, तिग्‍दा भिसम एनीगदेसे कोडोङ भिसी स्‍योइमा ग्‍वाएनोन स्‍योइसी भ्‍याङ्‍ला। ");
INSERT INTO taj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","बरु ग्‍वा खन्‍बा धुइ आततेधोना थेह्रङ्बान मुगै। ग्‍वा खन्‍बा धुइरी खन्‍बागदेदा ङाच्‍छा कोडोङ स्‍योइसी ख्राङ्बाला लागिरी ग्‍ला गिकरी थान्‍गो। तर एनीगदेसे ग्‍वा जे भसी ङाला भकारीरी थान्‍गो भिसी पाङ्ला।’” ");
INSERT INTO taj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","दोःसी येशूसे थेनीगदेदा अर्गु उखान गिक सुङ्जी, “च्‍यागो, स्‍वर्गला य्‍हुल्‍सा म्‍हि गिकसे घुर्‍यानरी ढ्वबा पच्‍छै ब्‍लुला गेडा गिक ह्रङ्‌बान हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","पच्‍छैला गेडा ढापढुपगदे न्‍हङ‍री जम्‍मान भन्‍दा जजा तसैनोन थे फुइसी ल्‍हेबान निसी दोङनोन दोला। ओच्‍छे थे पच्‍छै दोङला हाँगारी चरागदे खसी जङ स्‍होसी चिला।” ");
INSERT INTO taj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","दोःसीनोन येशूसे थेनीगदेदा अर्गु उखान गिक सुङ्जी, “च्‍यागो, स्‍वर्गला य्‍हुल्‍सा चा गेङरी युबा खमीर ह्रङ्‌बान हिन्‍ना। थे खमीर म्रिङम्‍हेमे गिकसे फाम सोम ब्रारी युसी ज्‍योप्‍ला। ओच्‍छे थे ब्रा आभोतेधोना थेसे घप्‍सी थान्‍ना।” ");
INSERT INTO taj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","येशूसे म्‍हिला हुलदा जम्‍मान ताम उखानग्‍यामसे जे लोप्‍जी। उखान आसुङ्तेधोना थेनीगदेदा येशूसे तिगै ताम आलोप्‍नी। ");
INSERT INTO taj_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","परमेश्‍वरसे अगमवक्ताग्‍याम सुङ्बा ताम चुह्रङ् लसी पूरा तजी, “ङाइ ताम लमा उखानग्‍यामसे जे लला, ओच्‍छे जम्‍बुलिङ ठुङ्माहेन्‍से दान्‍देधोना था आरेबा ताम ङाइ घोना लला।” ");
INSERT INTO taj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","जमाहेन्‍से थे म्‍हिला हुलदा ख्‍लासी येशू दिम न्‍हङरी फेप्‍जी। ओच्‍छे थेला चेलागदेएनोन दिम न्‍हङरी खसी, “बुरी फुइबा कोडोङ म्राला उखानना अर्थ घोना लसी पिन्‍गो” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “ज्‍यबा ब्‍लु ढ्वबा म्‍हि चा परमेश्‍वरसे पुइखबा म्‍हि हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","बु भिबा चा चु जम्‍बुलिङ हिन्‍ना ओच्‍छे ज्‍यबा ब्‍लु भिबा चा परमेश्‍वरला य्‍हुल्‍साला म्‍हिगदे हिन्‍ना, कोडोङ म्रा भिबा चा परमेश्‍वरदा बिरोध लबागदे हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ओच्‍छे कोडोङ ढ्वबा शत्रु चा शैतान हिन्‍ना, बाली खन्‍बा धुइ भिबा चा परमेश्‍वरसे जम्‍बुलिङला जम्‍मान म्‍हिगदेला निसाफ लबा धुइ हिन्‍ना। ओच्‍छे बाली खन्‍बागदे चा स्‍वर्गदूतगदे हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","कोडोङ स्‍योइसी म्‍हिगदेसे खाह्रङ् लसी मेरी फर्मुला थेह्रङ् लसीन परमेश्‍वरसे जम्‍बुलिङला जम्‍मान म्‍हिगदेला निसाफ लबा धुइरीनोन थेह्रङ्नोन लला। ");
INSERT INTO taj_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","जमा धुइरी परमेश्‍वरसे पुइखबा म्‍हिसेनोन ङाला स्‍वर्गदूतगदेदा पुइखला। थेनीगदेसे म्‍हिगदेदा पाप लपुङ्बा जम्‍मान स्‍हेदेन पाप गे लबा जम्‍मान म्‍हिगदेदा ङाला य्‍हुल्‍साग्‍याम ह्रुप लला। ");
INSERT INTO taj_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ओच्‍छे थेनीगदेदा मेरी युला, थेरी थेनीगदे स्‍वा क्रेसी क्रेसी क्राबा क्रिङ्बा लला। ");
INSERT INTO taj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","जमाहेन्‍से परमेश्‍वरसे म्‍हन्‍बा अन्‍छार भ्रबा म्‍हिगदे ह्राङला परमेश्‍वर आबाला य्‍हुल्‍सारी धिनी ह्रङ्नोन य्‍हाल य्‍हाल तसी चिला। जुन म्‍हिदा घोबा सेम मुला थेसे ज्‍यना लसी ङ्‌यान्‍सी घोउ। ");
INSERT INTO taj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“च्‍यागो, स्‍वर्गला य्‍हुल्‍सा वारीरी ल्‍हुसी थान्‍बा धन ह्रङ्‌बान हिन्‍ना। थे धन म्‍हि गिकसे स्‍याप्‍जी। जमाहेन्‍से थे ल्‍हानान ताङ्सी थे धन थेरीन ल्‍हुसी थान्‍सी दिमरी निजी। ओच्‍छे थेसे ह्राङदेन छ्‌याम मुबा जति जम्‍मान चुङ्सी थे वारी ग्‍लुजी। ");
INSERT INTO taj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“चुह्रङ् लसीन स्‍वर्गला य्‍हुल्‍सा ज्‍यबा खाल्‍ला मोती म्‍हाइसी भ्रबा व्‍यापारी ह्रङ्‌बान हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","थेसे ज्‍यबा खाल्‍ला मोती स्‍याप्‍माहेन्‍से ह्राङदेन छ्‌याम मुबा जति जम्‍मान चुङ्सी थे मोती ग्‍लुजी। ");
INSERT INTO taj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“थेह्रङ् लसीन स्‍वर्गला य्‍हुल्‍सा समुन्‍द्ररी रोप्‍बा घ्‍याङ ह्रङ्‌बान हिन्‍ना। थे घ्‍याङरी ल्‍हानान थरीला तार्ङागदे परब तला। ");
INSERT INTO taj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ओच्‍छे घ्‍याङ नाङनोन तार्ङा परब तमाहेन्‍से म्‍हिगदेसे समुन्‍द्रला कुनीरी भसी गे खेल्‍बा तार्ङागदे ताङरी थान्‍ना, गे आखेल्‍बा तार्ङागदे पाखारी भ्‍याङ्‍ला। ");
INSERT INTO taj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","चुह्रङ्‌नोन लसी परमेश्‍वरसे जम्‍बुलिङला जम्‍मान म्‍हिगदेला निसाफ लबा धुइरीनोन स्‍वर्गदूतगदे खसी ज्‍यबा गे लबा म्‍हिगदेदेन नइबा गे लबा म्‍हिगदेदा फेला। ");
INSERT INTO taj_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ओच्‍छे परमेश्‍वरसे कुल्‍बा ताम आङ्‌यान्‍बागदेदा चा मेरी युला। थेरी म्‍हिगदे स्‍वा क्रेसी क्रेसी क्राबा क्रिङ्बा लला।” ");
INSERT INTO taj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","जमाहेन्‍से येशूसे थेनीगदेदा “एनीगदेसे चु ताम जम्‍मान घोजी?” भिसी ङ्‌योइमा, “घोजी” भिसी थेनीगदेसे येशूदा जोहाब पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","थेतबासेलमा येशूसे चेलागदेदा “च्‍यागो, स्‍वर्गला य्‍हुल्‍साला बारेरी था याङ्बा यहूदी धर्मगुरुगदे दिमला दोप्‍ता ह्रङ्‌बान हिन्‍ना। तिग्‍दा भिसम थेसे ह्राङला ढुकुटीग्‍याम छारदेन पुरानो धनगदे तेःला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","चु उखानगदे सुङ्सी जिन्‍माहेन्‍से येशू थेग्‍याम ह्राङला नाम्‍सारी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ओच्‍छे ह्राङला नाम्‍सारी धोखमाहेन्‍से यहूदीगदे ह्रुप तबा दिमरी फेप्‍सी थेरी मुबा म्‍हिगदेदा लोप्‍जी। येशूसे लोप्‍बा म्राङ्सी थेरी मुबा म्‍हिगदे उदेक तसी चुह्रङ् भिजी, “चु म्‍हिसे चुह्रङ्बा उदेकला गे लबा शक्तिदेन बुद्धि खानङग्‍याम याङ्जी? ");
INSERT INTO taj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","चु सिकर्मीला झा आहिन? चुला आमा मरियम ओच्‍छे आलेगदे याकूब, योसेफ, सिमोनदेन यहूदा आहिन? ");
INSERT INTO taj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","चुला जम्‍मान आङागदे य्‍हाङदेन छ्‌यामनोन आरे? तसैनोन चुसे चु जम्‍मान ज्ञान बुद्धिदेन शक्ति खानङग्‍याम याङ्जी?” ");
INSERT INTO taj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","जमाहेन्‍से थेनीगदेदा येशूदेन छ्‌याम बोमो खजी। तर येशूसे थेनीगदेदा “च्‍यागो, अगमवक्तादा ह्राङला नाम्‍सारीदेन ह्राङला दिमरी बाहेक अर्गु खजिबै ग्‍लारी निसैनोन मान लला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","थेनीगदेसे विश्‍वास आलबा म्राङ्सी येशूसे थेरी ल्‍हाना उदेकला गे आलनी। ");
INSERT INTO taj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","थे धुइरी गालील अञ्‍चलरी शासन लबा हेरोदसे येशूसे लबा उदेकला गेला बारेरी थेःजी। ");
INSERT INTO taj_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","जमाहेन्‍से थेसे ह्राङला गे लबागदेदा “थे म्‍हि बप्‍तिस्‍मा पिन्‍बा यूहन्‍ना हिन्‍ना। थे सिबाग्‍याम सोसी खबा हिन्‍ना। थेतबासेलमान थेसे चुह्रङ्बा उदेकला गेगदे लबा हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","हेरोदसे ह्राङला आले फिलिपला म्रिङ हेरोदियाससे लमा ङाच्‍छा यूहन्‍नादा झ्‍याल्‍खानरी झाङ्मुबा। ");
INSERT INTO taj_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","तिग्‍दा भिसम हेरोदसे ह्राङला आले चाङदा थान्‍बासे लमा यूहन्‍नासे हेरोददा “ह्राङसे आले चाङदेन छ्‌याम ब्‍याह लबा ठीक आहिन” भिसी पाङ्मुबा। ");
INSERT INTO taj_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","थेतबासेलमा हेरोदसे यूहन्‍नादा साइबारी म्‍हाइमुबा। तर हेरोद म्‍हिगदे म्राङ्सी लोङ्मुबा। तिग्‍दा भिसम म्‍हिगदेसे बप्‍तिस्‍मा पिन्‍बा यूहन्‍नादा अगमवक्ता हिन्‍ना भिसी भिमुबा। ");
INSERT INTO taj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","हेरोदसे ह्राङ न्‍हबा धिन‍दा ढन्‍सी घ्रेन भोज लजी। जमाकुनु हेरोदियासला झामे जम्‍मान म्‍हिगदेला ङाच्‍छापट्टि स्‍य्‍हसी हेरोददा ल्‍हानान ताङ्ना लजी। ");
INSERT INTO taj_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","थेतबासेलमा हेरोदसे थेदा “एसे जे ह्रीबा थेनोन पिन्‍ना” भिसी कबुल लजी। ");
INSERT INTO taj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","तर थेला आमासे थेदा बप्‍तिस्‍मा पिन्‍बा यूहन्‍नाला थोबो ह्री‍गो भिसी पाङ्बासे लमा थेसे “ङादा दान्‍देन बप्‍तिस्‍मा पिन्‍बा यूहन्‍नाला थोबो खार्बारी भउ” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","जमाहेन्‍से हेरोद ग्‍लेदा ल्‍हानान दुख ङ्‌हम्‍जी। तसैनोन ह्राङला डोन्‍बोगदेला ओन्‍छाङरी जे ह्रीसै पिन्‍ना भिसी घ्रान फाबासे लमा थेसे भिबा ह्रङ्नोन लउ भिसी सिपाहीगदेदा कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ओच्‍छे थेनीगदे झ्‍याल्‍खानरी निसी यूहन्‍नाला थोबो थाजी। ");
INSERT INTO taj_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","जमाहेन्‍से यूहन्‍नाला थोबो खार्बारी भसी थे माइदा पिन्‍जी। ओच्‍छे थे माइसे भोर्सी ह्राङला आमादा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","यूहन्‍नादा साइजी भिबा ताम थेःमाहेन्‍से यूहन्‍नाला चेलागदे खसी लास भोर्सी ल्‍हुजी। जमाहेन्‍से यूहन्‍नाला चेलागदे येशू मुबा ग्‍लारी खसी थे जम्‍मान ताम पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","बप्‍तिस्‍मा पिन्‍बा यूहन्‍नादा साइजी भिबा ताम थेःमाहेन्‍से येशू ह्राङ गिक जे दोँगारी क्रेःसी सुनसान ग्‍लारी फेप्‍जी। तर येशू थेग्‍याम सुनसान ग्‍लारी फेप्‍जी भिबा ताम थेःसी शहर शहरग्‍याम म्‍हिला हुल भ्रसीन येशू मुबा ग्‍लारी निजी। ");
INSERT INTO taj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","येशू समुन्‍द्रला कुनीरी धोमा ल्‍हानान म्‍हिला हुलदा म्राङ्सी थेदा दया रेःजी। थेतबासेलमा येशूसे थेनीगदेला आखम्‍बा म्‍हिगदेदा खम्‍ना लजी। ");
INSERT INTO taj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ओच्‍छे ङ्‍यसे तमाहेन्‍से येशूला चेलागदे थे मुबा ग्‍लारी खसी “दाहेन्‍से ङ्‍यसे तसी जिन्‍जी, चु सुनसान ग्‍लारी तिगै आरे। थेतबासेलमा चु म्‍हिगदेदा पुइगो। ओच्‍छे थेनीगदे नाम्‍सा नाम्‍सारी निसी ह्राङ ह्राङला लागिरी चबा स्‍हे ग्‍लुसी चगै” भिसी येशूदा पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","तर येशूसे थेनीगदेदा “चु म्‍हिगदेदा तिग्‍दा पुइसे? एनीगदेसेन चुगदेदा चबा स्‍हे पिन्‍गो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","जमाहेन्‍से थेनीगदेसे येशूदा “ङन्‍देन छ्‌याम गोर ङा गेङदेन गोर न्‍ही तार्ङा भन्‍दा अर्गु तिगै आरे” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","येशूसे थेनीगदेदा “थे गेङदेन तार्ङा ङादा भउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","जमाहेन्‍से येशूसे म्‍हिगदेदा पाङरी चिपुङ्जी। ओच्‍छे गेङदेन तार्ङा यारी थोसी स्‍वर्गपट्टि स्‍हीबान परमेश्‍वरदा धन्‍यवाद पिन्‍जी। ओच्‍छे गेङ क्‍युइसी म्‍हिगदेदा भो लसी पिन्‍गो भिसी चेलागदेदा पिन्‍जी। जमाहेन्‍से चेलागदेसे भो लसी म्‍हिगदेदा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","जम्‍मान म्‍हिगदेसे म्रेन्‍ना चसीनोन लेङ्बा गेङदेन तार्ङा चेलागदेसे च्‍युक न्‍ही सोली दुइजी। ");
INSERT INTO taj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","थेरी गेङ चबा म्‍हिगदे म्रिङम्‍हेमेदेन कोलागदे बाहेकनोन हजार ङा ह्रेम्‍फेबेगदे मुबा। ");
INSERT INTO taj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","जमाहेन्‍से येशूसे तुरुन्‍तन ह्राङला चेलागदेदा दोँगारी क्रेःसी क्‍यामसङपट्टि ह्राङ भन्‍दा ङाच्‍छा पुइजी। थे धुइरी येशूसे चा म्‍हिला हुलदा पुइबान लजी। ");
INSERT INTO taj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","म्‍हिगदे पुइसी जिन्‍माहेन्‍से येशू ह्राङ गिक जे प्रार्थना लबारी गङरी फेप्‍जी। थेरी ङ्‍यसेधोनान येशू गिक जे मुबा। ");
INSERT INTO taj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","थे धुइरी चेलागदे क्रेःसी निबा दोँगा समुन्‍द्रला कुनीग्‍याम ल्‍हानान थारेङ धोसी जिन्‍बा मुबा। तसैनोन लाबा उल्‍टोग्‍याम खबासे लमा समुन्‍द्ररी छाल रेःसी थेनीगदेदा क्‍यामसङपट्टि निबारी गाह्रो तबा मुबा। ");
INSERT INTO taj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","स्‍य्‍होला तीन बजेरीक्‍यार येशू समुन्‍द्रथोरी भ्रबान थेनीगदेपट्टि फेप्‍खजी। ");
INSERT INTO taj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","चेलागदेसे येशू समुन्‍द्रथोरी भ्रसी फेप्‍खबान लबा म्राङ्सी “चु मी म्‍हङनोन हिन्‍ना!” भिसी थेनीगदे लोङ्सी क्रिङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","तर तुरुन्‍तन येशूसे थेनीगदेदा “भङ लउ, ङानोन हिन्‍ना, थालोङ्‍गो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","जमाहेन्‍से पत्रुससे येशूदा “प्रभु, ह्राङनोन हिन्‍सम ङादाएनोन समुन्‍द्रथोरी भ्रसी ह्राङ मुबा ग्‍लारी खउ भिसी सुङ्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","येशूसे “लु, खउ!” भिसी सुङ्माहेन्‍से पत्रुस दोँगाग्‍याम फाप्‍सी येशू मुबा ग्‍लारी निबारी समुन्‍द्रथोरी भ्रबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","तर घ्रेन लाबा खबा म्राङ्सी थे लोङ्जी। लोङ्बासे लमा थे समुन्‍द्ररी डुबब तबारी छ्‌याइजी। जमाहेन्‍से थेसे “प्रभु, ङादा जोगब लउ” भिसी क्रिङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","येशूसे तुरुन्‍तन पत्रुसला या चुङ्सी “खाइ एला विश्‍वास, एसे तिग्‍दा शङ्का लबा?” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","येशूदेन पत्रुस दोँगारी क्रेःमाहेन्‍से लाबा म्‍हाजी। ");
INSERT INTO taj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","जमाहेन्‍से दोँगारी मुबा चेलागदेसे येशूदा फ्‍या लसी, “ह्राङ पक्‍कान परमेश्‍वरला झा हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","थेनीगदे समुन्‍द्र थासी गनेसरेत भिबा ग्‍लारी धोखजी। ");
INSERT INTO taj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","थे ग्‍लाला म्‍हिगदेसे येशूदा ङोसेमाहेन्‍से क्‍यारमारला नाम्‍साला म्‍हिगदेदा येशू फेप्‍खजी भिसी पाङ्सी पिन्‍जी। जमाहेन्‍से म्‍हिगदेसे आखम्‍बा म्‍हिगदे जम्‍मादान येशू मुबा ग्‍लारी भसी, ");
INSERT INTO taj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","“चुगदेदा ह्राङला क्‍वान्‍ना जो जे भिसै थुर्पुङ्‍गो” भिसी बिन्‍ती लजी, ओच्‍छे येशूला क्‍वान थुर्बा जति जम्‍मान खम्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","यरूशलेमग्‍याम खबा फरिसीगदेदेन यहूदी धर्मगुरुगदे येशू मुबा ग्‍लारी खसी, ");
INSERT INTO taj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“ह्राङला चेलागदेसे तिग्‍दा आखे म्‍हेमेला रिमठिमदा ख्‍लाबा? तिग्‍दा चबा भन्‍दा ङाच्‍छा या आख्रुबा?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदेसे चा तिग्‍दा परमेश्‍वरसे कुल्‍बा ताम आङ्‌यान्‍ना आखे म्‍हेमेला रिमठिम तेन्‍बा? ");
INSERT INTO taj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","तिग्‍दा भिसम परमेश्‍वरसे ‘एसे ह्राङला आबा आमादा मान लउ,’ ओच्‍छे ‘जुन म्‍हिसे ह्राङला आबा आमादा बिरोध लसी नइबा ताम लला थेदा चा साइनोन तोःला’ भिसी सुङ्बा मुला। ");
INSERT INTO taj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","तर एनीगदेसे चा ‘जुन म्‍हिसे ह्राङला आबा आमादा पिन्‍तोःबा स्‍हे परमेश्‍वरदा फुल्‍बा मुला, थेसे ह्राङला आबा आमादा मान लआतोः’ भिसी लोप्‍मुला। ");
INSERT INTO taj_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","चुह्रङ् लसी एनीगदेसे ह्राङला रिमठिम अन्‍छार भ्रगै भिसी परमेश्‍वरसे कुल्‍बा ताम चा गे आखेल्‍बा स्‍होबा मुला। ");
INSERT INTO taj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","थेतबासेलमा कप्‍टीगदे, परमेश्‍वरसे यशैया अगमवक्ताग्‍याम सुङ्बा ताम एनीगदेला गे अन्‍छार ढिक्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘चु म्‍हिगदेसे सुङसे जे ङादा मान लमुला, तर सेमहेन्‍से चा मान आलमुला। ");
INSERT INTO taj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ओच्‍छे थेनीगदेसे ङादा तेन्‍बाम तेन्‍मुला, तसैनोन परमेश्‍वरसे कुल्‍बा तामदा भन्‍दा म्‍हिसे स्‍होबा रिमठिमदा घ्रेन म्‍हन्‍मुला।’” ");
INSERT INTO taj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","जमाहेन्‍से येशूसे म्‍हिला हुलदा ह्राङ मुबा ग्‍लारी ङ्‌योइसी, “ङाइ पाङ्बा ताम तिग चीम भिसी एनीगदेसे घोबारी म्‍हाइगो। ");
INSERT INTO taj_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","परमेश्‍वरदा तेन्‍बारी म्‍हिदा खजिबै चबा स्‍हेसे न्‍होङ्ना आल। तर म्‍हिला सेमग्‍याम थोन्‍बा नइबा तामसे चा म्‍हिदा न्‍होङ्ना लमुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","जमाहेन्‍से चेलागदे येशू मुबा ग्‍लारी खसी “ह्राङला ताम थेःसी फरिसीगदे ह्राङदेन छ्‌याम बोमो खबा ताम ह्राङदा था मुला?” भिसी पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","तर येशूसे चेलागदेदा चुह्रङ् भिसी सुङ्जी, “स्‍वर्गरी धन्‍छ्‌याबा ङाला आबासे आसूबा दोङगदे स्‍योइसी भ्‍याङ्‍ला। ");
INSERT INTO taj_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","थेतबासेलमा थेनीगदेदा तिगै पाङ्आतोः। थेनीगदे मी आम्राङ्बा म्‍हिगदेदा लोप्‍बा मी आम्राङ्बा म्‍हिगदे हिन्‍ना। थेतबासेलमा मी आम्राङ्बा म्‍हिसे मी आम्राङ्बादान चुङ्सी भोर्सम न्‍हीनोन व्‍हाङरी ताइला।” ");
INSERT INTO taj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","जमाहेन्‍से पत्रुससे येशूदा “म्‍हिगदेदा चबा स्‍हेसे न्‍होङ्ना आलमुला भिसी ह्राङसे सुङ्बा ताम ङन्‍दा घोना लसी पिन्‍गो” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “दान्‍देधोना अझ एनीगदेसे घोबा आरे? ");
INSERT INTO taj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","चबा स्‍हे चमाहेन्‍से फोरी धोमुला। ओच्‍छे फोग्‍यामसेनोन मङग्‍यार थोन्‍मुला भिबा ताम एनीगदेदा था आरे? ");
INSERT INTO taj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","तर म्‍हिला सेमरी जुन ताम मुला थेनोन ताम सुङग्‍याम थोन्‍मुला, ओच्‍छे थेनोन तामसे म्‍हिदा न्‍होङ्ना लमुला। ");
INSERT INTO taj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","तिग्‍दा भिसम म्‍हिला सेमग्‍याम थोन्‍बा नइबा तामगदे चा म्‍हि साइबा, म्‍हिला म्रिङदेन छ्‌याम ब्रेल्‍सी भ्रबा, खालैदेन छ्‌याम ब्रेल्‍सी भ्रबा, य्‍हो लबा, लुसीला ताम पाङ्बा ओच्‍छे म्‍हिला तामगन लबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","चु जम्‍मान तामसे चा म्‍हिदा न्‍होङ्ना लमुला। तर या आख्रुना चसी म्‍हिदा न्‍होङ्ना आलमुला।” ");
INSERT INTO taj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","जमाहेन्‍से येशू थे शहर ख्‍लासी टुरोसदेन सीदोन भिबा ग्‍लारीक्‍यार फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","थे शहरला अर्गु य्‍हुलला कनानी म्रिङम्‍हेमे गिक क्रिङ्बान खसी येशूदा “प्रभु, दाऊद ग्‍लेला सन्‍तान, ङादा दया लउ। ङाला झामेदा म्‍हङसे ल्‍हानान दुख पिन्‍बा मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","तर येशूसे तिगै जोहाब आपिन्‍नी। जमाहेन्‍से चेलागदेसे येशूदा “चु म्रिङम्‍हेमेदा चुग्‍याम पुइगो। तिग्‍दा भिसम चु क्रिङ्बान य्‍हाङला लिच्‍छा लिच्‍छा भ्रसी छेर्ना लजी” भिसी बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","जमाहेन्‍से येशूसे थे म्रिङम्‍हेमेदा “च्‍यागो, परमेश्‍वरसे ङादा म्‍हाबा ग्‍यु ह्रङ् तसी चिबा इस्राएलला म्‍हिगदेला लागिरी जे पुइखबा हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","तर थे म्रिङम्‍हेमेसे येशूदा फ्‍या लबान, “प्रभु, ङादा ह्रो लउ” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","जमाहेन्‍से येशूसे थे म्रिङम्‍हेमेदा “च्‍यागो, कोलागदेदा पिन्‍तोःबा गेङ नगीदा पिन्‍बा ठीक आहिन” भिसी सुङ्मा, ");
INSERT INTO taj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","थे म्रिङम्‍हेमेसे “हिन्‍ना प्रभु, तर नगीसेनोन थेला दोप्‍तासे चमा सरी ताइबा भ्राइभ्रुइ मी चम्‍याङ्मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","जमाहेन्‍से येशूसे थे म्रिङम्‍हेमेदा “माइ, एला विश्‍वास घ्रेन चीम। एला विश्‍वाससे लमा एसे म्‍हन्‍बा ह्रङ्नोन तबा मुला” भिसी सुङ्जी। थेनोन धुइरी थेला झामे खम्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","जमाहेन्‍से येशू थे ग्‍ला ख्‍लासी गालील समुन्‍द्रला कुनीग्‍याम गङरी फेप्‍सी धन्‍छ्‌याजी। ");
INSERT INTO taj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ओच्‍छे म्‍हिला हुल येशू मुबा ग्‍लारी खजी। थेनीगदेसे कुज्‍या तबा, मी आम्राङ्बादेन ताइ दोबा ओच्‍छे ल्‍हानान थरीला रोगसे स्‍याप्‍बा म्‍हिगदेदा भजी। जमाहेन्‍से येशूसे थे आखम्‍बा म्‍हिगदेदा खम्‍ना लजी। ");
INSERT INTO taj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","येशूसे ताइ दोबा म्‍हि, कुज्‍या म्‍हि, मी आम्राङ्बा म्‍हिदेन जम्‍मान आखम्‍बा म्‍हिगदेदा खम्‍ना लबा म्राङ्सी थेरी मुबा जम्‍मान म्‍हिगदे उदेक म्‍हन्‍सी इस्राएलला म्‍हिगदेसे तेन्‍बा परमेश्‍वरला जयजयकार लजी। ");
INSERT INTO taj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","जमाहेन्‍से येशूसे चेलागदेदा ह्राङ मुबा ग्‍लारी ङ्‌योइसी, “चु म्‍हिगदे म्राङ्सी ङादा दया रेःजी। तिग्‍दा भिसम चुगदे ङादेन छ्‌याम भ्रबा तिनी सोमरे तजी। ओच्‍छे चुगदेदेन छ्‌याम तिगै चबा स्‍हे आरे। थेतबासेलमा चुगदेदा फोइथाननोन पुइबारी आत। फोइथाननोन दिमरी पुइजी भिसम चुगदे ग्‍यामरीन बिहोस तला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","जमाहेन्‍से चेलागदेसे येशूदा “चुह्रङ्बा तिगै आयाङ्बा ग्‍लारी चुदेला म्‍हिला हुलदा ख्‍वाबारी ङन्‍से खानङग्‍याम गेङ भसे?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","येशूसे थेनीगदेदा “एनीगदेदेन छ्‌याम गेङ गाते मुला?” भिसी ङ्‌योइमा, थेनीगदेसे “ङन्‍देन छ्‌याम गोर निस गेङदेन जजाबा तार्ङागदे जजाकी मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","जमाहेन्‍से येशूसे थेरी मुबा म्‍हिला हुलदा पाङरी चिपुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","येशूसे गोर निस गेङदेन तार्ङा थोसी परमेश्‍वरदा धन्‍यवाद पिन्‍जी। ओच्‍छे गेङ क्‍युइसी चेलागदेदा पिन्‍जी। जमाहेन्‍से चेलागदेसे म्‍हिगदेदा भो लसी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ओच्‍छे जम्‍मान म्‍हिगदेसे म्रेन्‍ना चजी। जमाहेन्‍से चेलागदेसे लेङ्बा गेङदेन तार्ङा दुइमा सोली निस तजी। ");
INSERT INTO taj_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","थेरी चबागदे न्‍हङ‍री कोलागदेदेन म्रिङम्‍हेमे बाहेकनोन ह्रेम्‍फेबेगदे जे हजार ब्‍लि मुबा। ");
INSERT INTO taj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","जमाहेन्‍से येशूसे जम्‍मान म्‍हिगदेदा पुइजी। ओच्‍छे येशू ह्राङला चेलागदेदेन छ्‌याम दोँगारी क्रेःसी मगादान भिबा नाम्‍सारीक्‍यार फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","कोइ कोइ फरिसीगदेदेन सदुकीगदे येशूला सेम च्‍याबाला लागिरी येशू मुबा ग्‍लारी खजी। ओच्‍छे “चुदे ह्राङ परमेश्‍वरग्‍याम फेप्‍खबा हिन्‍सम ङन्‍दा स्‍वर्गला चिनु उन्‍गो” भिसी पाङ्‌मा, ");
INSERT INTO taj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदेसे ङ्‍यसे मु वाला तबा म्राङ्सम ‘न्‍हङगर धिन ज्‍यबा तला’ भिसी भिमुला। ");
INSERT INTO taj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ओच्‍छे स्‍य्‍होरी चा खसुदेन मु वाला तबा म्राङ्सम ‘तिनी लाबालुङसर खनम’ भिसी मु च्‍यासी एनीगदेसे धिन फेबारी खम्मुला। तर एनीगदेदा ज्‍यना लसी उन्‍बा चु धुइला चिनु चा एनीगदेसे घोखम्‍बा आरे। ");
INSERT INTO taj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","नइबा बानिबेहोर थोसी स्‍य्‍हान्‍दोदेन छ्‌याम ब्रेल्‍सी भ्रबा म्‍हिगदेसे उदेकला चिनु जे म्‍हाइमुला। तर दान्‍देला म्‍हिगदेदा चा योना अगमवक्ताला चिनु बाहेक अर्गु चिनु आउन।” जमाहेन्‍से येशू थे ग्‍लाग्‍याम फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","समुन्‍द्रला क्‍यामसङपट्टि धोखमाहेन्‍से गेङ भबारी म्‍लेःजीम भिसी चेलागदेसे था याङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","थेनोन धुइरी येशूसे थेनीगदेदा “च्‍यागो, एनीगदे फरिसीदेन सदुकीगदेला खमीरग्‍याम होशियार तसी चिउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","तर चेलागदेसे चा “य्‍हाङसे गेङ भबारी म्‍लेःबासे लमा येशूसे चुह्रङ् सुङ्बा हिन्‍ना” भिसी ह्राङ ह्राङ न्‍हङ‍री ताम लबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","येशूसे चु ताम था याङ्सी, “एनीगदे खाह्रङ्बा विश्‍वास आरेबा म्‍हिगदे! एनीगदेसे ह्राङदेन छ्‌याम गेङ आरे भिसी तिग्‍दा ताम लसी चिबा? ");
INSERT INTO taj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","एनीगदेसे अझ घोबा आरे? ङाइ गोर ङा गेङसे हजार ङा म्‍हिगदेदा ख्‍वामा एनीगदेसे गाते सोली गेङ दुइबा मुबा? थे ताम म्‍लेःसी जिन्‍जी? ");
INSERT INTO taj_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ओच्‍छे ङाइ गोर निस गेङसे हजार ब्‍लि म्‍हिगदेदा ख्‍वामा एनीगदेसे गाते सोली दुइमुबा? ");
INSERT INTO taj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","एनीगदेसे अझ तिग्‍दा आघोबा? ङाइ एनीगदेदा गेङला बारेरी पाङ्बा आहिन। तर फरिसीदेन सदुकीगदेला खमीर ह्रङ्‌बान तामग्‍याम होशियार तसी चिउ” भिसी पाङ्बा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","जमाहेन्‍से थेनीगदेसे येशूसे गेङरी युबा खमीरग्‍याम आहिन, तर फरिसीदेन सदुकीगदेसे लोप्‍बा तामग्‍याम होशियार तसी चिउ भिसी सुङ्बा चीम भिसी घोजी। ");
INSERT INTO taj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","कैसरिया फिलिप्‍पी भिबा ग्‍लारी धोखमाहेन्‍से येशूसे ह्राङला चेलागदेदा “म्‍हिगदेसे परमेश्‍वरसे पुइखबा म्‍हिदा खाल भिसी भिमुला?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","चेलागदेसे “खालैसे बप्‍तिस्‍मा पिन्‍बा यूहन्‍ना, खालैसे एलिया अगमवक्ता, खालैसे यर्मिया अगमवक्ता थेह्रङ् लसीन खालैसे अगमवक्तागदे न्‍हङला गिक हिन्‍ना भिसी भिमुला” भिसी येशूदा जोहाब पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","दोःसी येशूसे थेनीगदेदा “तर एनीगदेसे चा ङा खाल भिसी म्‍हन्‍मुला?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","सिमोन पत्रुससे “ह्राङ परमेश्‍वरला झा थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","जमाहेन्‍से येशूसे थेदा “योनाला झा सिमोन, एसे परमेश्‍वरग्‍याम मोलम याङ्बा मुला। तिग्‍दा भिसम चु ताम एदा म्‍हिगदेसे पाङ्सी था तबा आहिन। तर स्‍वर्गरी धन्‍छ्‌याबा ङाला आबासे सुङ्सी था याङ्बा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","च्‍यागो, एसे ङाला ताम ङ्‌यान्‍गो, एला मिन पत्रुस हिन्‍ना। चु युङबाला पहराथोरी ङाइ ङाला मण्‍डली स्‍होला। चु मण्‍डलीदा कालला शक्तिगदेसे खाइमै ढाबारी आखम। ");
INSERT INTO taj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","थेतबासेलमा ङाइ एदा स्‍वर्गला य्‍हुल्‍साला साँचोगदे पिन्‍ना। एसे जम्‍बुलिङरी जुन स्‍हे ढुङ्ला, थे स्‍हे स्‍वर्गरीनोन ढुङ्ला। ओच्‍छे एसे जम्‍बुलिङरी जुन स्‍हे ठोङ्ला, थे स्‍हे स्‍वर्गरीनोन ठोङ्ला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","तर चेलागदेदा येशूसे “ङा थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍ना भिसी खालैदा थापाङ्‍गो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","जमाहेन्‍से येशूसे ह्राङला चेलागदेदा “यरूशलेमरी निसी ङाइ यहूदी गन्‍बागदे, परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी धर्मगुरुगदेग्‍याम ल्‍हानान दुख नातोःला। थेनीगदेसे ङादा दुख पिन्‍सी पिन्‍सीन साइला। तसैनोन ङादा सिबाग्‍याम सोमरेमाकुनु सोना लला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","चु ताम थेःमाहेन्‍से पत्रुससे येशूदा जजाकी क्‍याथाङ भोर्सी “प्रभु, ह्राङदा परमेश्‍वरसे खाइमै चुह्रङ् तआपुङ्‍गै, ह्राङदा चुह्रङ् खाइमै आत!” भिसी बङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","तर येशू फ्‍लिक दोःसी पत्रुसदा “ङादा कोल्‍ना लबारी म्‍हाइबा शैतान, ए चुग्‍याम थोन्‍सी निउ! तिग्‍दा भिसम एसे परमेश्‍वरसे सुङ्बा तामदा भन्‍दा म्‍हिगदेला तामदा सेम लमुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","जमाहेन्‍से येशूसे ह्राङला चेलागदेदा चुह्रङ् भिसी सुङ्जी, “खालै म्‍हि ङाला चेला दोबा सेम मुसम थेसे ह्राङला ज्‍याननोन माया मारब लसी ह्राङला क्रुस ह्राङसेन पुइसी ङादेन छ्‌याम भ्रगै। ");
INSERT INTO taj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","तिग्‍दा भिसम जुन म्‍हिसे ह्राङला ज्‍यान जोगब लबारी म्‍हाइला, थे म्‍हिसे जुकजुकधोनाला जुनी आयाङ्। तर ङाला लागिरी ज्‍याननोन पिन्‍खम्‍बा म्‍हिसे चा जुकजुकधोनाला जुनी याङ्ला। ");
INSERT INTO taj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","म्‍हिसे जम्‍बुलिङनोन यारी किन्‍सी ह्राङला ज्‍यान चा निजी भिसम थेदा तिग ज्‍यबा तला? जम्‍बुलिङरी म्‍हिला ज्‍यान भन्‍दा घ्रेन अर्गु तिगै स्‍हे मुला? ");
INSERT INTO taj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","तिग्‍दा भिसम लिच्‍छा परमेश्‍वरसे पुइखबा म्‍हि ह्राङला आबाला घ्रेन य्‍हालदेन शक्तिरी स्‍वर्गदूतदेन छ्‌याम खला। ओच्‍छे थेसे जम्‍मान म्‍हिदा थेनीगदेसे लबा गे अन्‍छारला इनाम पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, चुरी मुबा म्‍हिगदे न्‍हङला कोइ कोइ म्‍हि चा परमेश्‍वरसे पुइखबा म्‍हि ह्राङला य्‍हुल्‍सारी खबा आम्राङ्तेधोना आसि।” ");
INSERT INTO taj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ढुरे लिच्‍छा येशूसे पत्रुस, याकूबदेन याकूबला आले यूहन्‍नादा जे ह्राङदेन छ्‌याम नोबा गङरी भोर्सी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","चेलागदेसे च्‍याना च्‍यानान येशूला स्‍य्‍हाल पोसी धिनी ह्रङ् य्‍हाल य्‍हाल तजी। ओच्‍छे थेला क्‍वानएनोन धिनीला स्‍हेर ह्रङ्‌बान तजी। ");
INSERT INTO taj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","थेनोन धुइरी थेनीगदेसे थेरी मोशादेन एलिया, येशूदेन छ्‌याम ताम लबान लबा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","चु म्राङ्सी पत्रुससे येशूदा “प्रभु, य्‍हाङ चुरी मुबा ज्‍यबा तजीम। ह्राङदा ज्‍यबा छोर्सम चुरी ङाइ छाप्रो सोम स्‍होला, गिक ह्राङला लागिरी, गिक मोशाला लागिरी ओच्‍छे गिक एलियाला लागिरी” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","थेसे थेह्रङ् पाङ्ना पाङ्नान तार तार्बा खसु खसी थेनीगदेदा घप्‍जी। थे खसु न्‍हङ‍ग्‍याम “चु ङाइ सेमहेन्‍से माया लबा ङाला झा हिन्‍ना, थेदा म्राङ्सी ङा ल्‍हानान ताङ्‍बा मुला। थेतबासेलमा एनीगदेसे चुसे भिबा ताम ङ्‌यान्‍गो” भिबा काइ थेःजी। ");
INSERT INTO taj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","थे ताम थेःमाहेन्‍से चेलागदे लोङ्सी सरी ख्‍लुप तजी। ");
INSERT INTO taj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","तर येशू थेनीगदे मुबा ग्‍लारी खसी थेनीगदेदा थुर्सी “रेःगो, एनीगदे थालोङ्‍गो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","जमाहेन्‍से थेनीगदे रेःसी च्‍यामा थेरी येशू बाहेक स्‍य्‍हान्‍दो खालैदा आम्राङ्‌नी। ");
INSERT INTO taj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","जमाहेन्‍से येशू ह्राङला चेलागदेदेन छ्‌याम गङग्‍याम फाप्‍बान लबा धुइरी येशूसे चेलागदेदा “च्‍यागो, परमेश्‍वरसे पुइखबा म्‍हि सिबाग्‍याम आसोतेधोना एनीगदेसे तिनी म्राङ्बा चु ताम खालैदा थापाङ्‍गो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","जमाहेन्‍से चेलागदेसे येशूदा “यहूदी धर्मगुरुगदेसे तिग्‍दा एलिया अगमवक्ता ङाच्‍छा खतोःला भिबा?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","येशूसे चेलागदेदा चुह्रङ् भिसी सुङ्जी, “हिन्‍ना, ङाच्‍छा एलिया खला ओच्‍छे थेसे जम्‍मान ताम ढिक्‍ना लला। ");
INSERT INTO taj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","तर एनीगदेसे ङाला ताम ङ्‌यान्‍गो, तिग्‍दा भिसम एलिया खसी जिन्‍बा मुला। तसैनोन थेदा ङोआसेना म्‍हिगदेसे जे लइ म्‍हन्‍बा थेनोन लजी। थेह्रङ् लसीन परमेश्‍वरसे पुइखबा म्‍हिसेनोन थेनीगदेला याग्‍याम ल्‍हानान दुख नातोःबा मुला।” ");
INSERT INTO taj_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","जमाहेन्‍से येशूसे बप्‍तिस्‍मा पिन्‍बा यूहन्‍नाला बारेरी सुङ्जीम भिबा ताम चेलागदेसे घोजी। ");
INSERT INTO taj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","थेनीगदे म्‍हिला हुल मुबा ग्‍लारी धोखमाहेन्‍से म्‍हि गिक येशूला ङाच्‍छापट्टि पुइ जूसी, ");
INSERT INTO taj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“प्रभु, ङाला झादा दया लउ, तिग्‍दा भिसम थेदा स्‍ह म्‍हङसे ल्‍हानान दुख पिन्‍बा मुला। थेदा खाइमाम मेरी, खाइमाम क्‍युइरी भ्‍याङ्‍मुला। ");
INSERT INTO taj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","थेदा खम्‍ना लसी पिन्‍गो भिसी ङाइ ह्राङला चेलागदे मुबा ग्‍लारी भमुबा। तर थेनीगदेसे खम्‍ना लबारी आखम्‍नी” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","जमाहेन्‍से येशूसे थेनीगदेदा “विश्‍वास आलबादेन नइबा सेम थोबा म्‍हिगदे, खाइमाधोना ङा एनीगदेदेन छ्‌याम तला? खाइमाधोना ङाइ एनीगदेदा नासे? थेदा चुरी भउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ओच्‍छे येशूसे थे म्‍हङदा बङ्जी। बङ्‍माहेन्‍से थे कोलाला ल्‍हुइग्‍याम म्‍हङ थोन्‍सी यार्जी। जमाहेन्‍से थे कोला तुरुन्‍तन खम्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ओच्‍छे चेलागदे सुटुक्‍क येशू मुबा ग्‍लारी खसी “तिग्‍दा ङन्‍से थे म्‍हङदा ताप्‍बारी आखम्‍नी” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","येशूसे थेनीगदेदा “एनीगदेला विश्‍वास आयोबासे लमा हिन्‍ना। थेतबासेलमा एनीगदेसे ङाला ताम ङ्‌यान्‍गो, चुदे एनीगदेदेन छ्‌याम पच्‍छैला ब्‍लु गिक तेःबा जे विश्‍वास मुसैनोन चु गङदा ‘चुग्‍याम लेःउ’ भिसम थे लेःला। एनीगदेला लागिरी आतबा गे तिगै आरे। ");
INSERT INTO taj_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","तसैनोन चुह्रङ्बा म्‍हङ चा फोइथान चिसी प्रार्थना आलतेधोना थोन्‍सी आयार्मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","थेनीगदे गालील अञ्‍चलरी ह्रुप तबा धुइरी येशूसे चेलागदेदा “परमेश्‍वरसे पुइखबा म्‍हिदा म्‍हिगदेला यारी जिम्‍मा पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","थेनीगदेसे थेदा साइला। तसैनोन सिसी सोमरेमाकुनु थेदा सिबाग्‍याम सोना लला” भिसी सुङ्जी। चु ताम थेःसी चेलागदेदा ल्‍हानान दुख ङ्‌हम्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","येशू ह्राङला चेलागदेदेन छ्‌याम कफर्नहुम नाम्‍सारी फेप्‍खबा धुइरी परमेश्‍वरला मन्‍दिरला तिरो दुइबा म्‍हिगदे पत्रुस मुबा ग्‍लारी खसी, “एनीगदेला गुरुसे परमेश्‍वरला मन्‍दिरला तिरो फामुला कि आफामुला?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","पत्रुससे “फामुला” भिसी भिजी। जमाहेन्‍से पत्रुस दिम न्‍हङ‍री वाङ्सी येशूदा पाङ्‌बारी छ्‌याइमा येशूसेन, “सिमोन, एला तिग सेम मुला? जम्‍बुलिङला ग्‍लेगदेसे ह्राङलान म्‍हिगदेग्‍याम तिरो दुइमुला कि स्‍य्‍हान्‍दो म्‍हिगदेग्‍याम दुइमुला?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","पत्रुससे “स्‍य्‍हान्‍दो म्‍हिगदेग्‍याम दुइमुला” भिसी जोहाब पिन्‍जी। जमाहेन्‍से येशूसे चुह्रङ् भिसी सुङ्जी, “थेह्रङ् भिसम ह्राङला म्‍हिगदेसे चा आफासै तबा चीम। ");
INSERT INTO taj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","तसैनोन ए समुन्‍द्ररी निसी बल्‍छीसे तार्ङा साइसी भउ। एसे जम्‍मान भन्‍दा ङाच्‍छा साइबा तार्ङाला सुङरी च्‍यागो, एसे थेला सुङरी म्‍हुइला डबल गिक स्‍याप्‍ला। थे डबल भोर्सी य्‍हाङ न्‍हीला तिरो फागो। थेनीगदे य्‍हाङदेन छ्‌याम बोमो थाखगै।” ");
INSERT INTO taj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","थे धुइरी चेलागदे येशू मुबा ग्‍लारी खसी, “स्‍वर्गला य्‍हुल्‍सारी जम्‍मान भन्‍दा घ्रेन खाल तला?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","येशूसे कोला गिकदा ङ्‌योइजी। ओच्‍छे थेनीगदेला गुङरी राप्‍पुङ्‍सी, ");
INSERT INTO taj_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","चुह्रङ् भिसी सुङ्बारी छ्‌याइजी, “च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, एनीगदेसे ह्राङ ह्राङला सेम पोसी चु कोलागदे ह्रङ्‌बा आतनी भिसम खाइमै स्‍वर्गला य्‍हुल्‍सारी वाङ्‌आम्‍याङ्। ");
INSERT INTO taj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","जुन म्‍हि चु कोला ह्रङ्‌बान सोजो तला थेनोन स्‍वर्गला य्‍हुल्‍सारी जम्‍मान भन्‍दा घ्रेन तला। ");
INSERT INTO taj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","जुन म्‍हिसे चुह्रङ्बा कोलादा ङाला मिनरी वास्‍ता लला, थेसे ङादाएनोन वास्‍ता लला। ");
INSERT INTO taj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“तर जुन म्‍हिसे ङादा विश्‍वास लबा चु कोलागदे न्‍हङला गिकदा पाप लपुङ्ला, थेह्रङ्बा म्‍हिदा मी खारेरी ह्रान्‍दा च्‍योसी समुन्‍द्ररी डुबब लबान ज्‍यबा तला। ");
INSERT INTO taj_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","चु जम्‍बुलिङरी म्‍हिगदेदा पाप लपुङ्बा स्‍हेगदे मुला। थेतबासेलमा चु जम्‍बुलिङला म्‍हिगदेसे परमेश्‍वरग्‍याम सजाय याङ्ला। पाप लपुङ्बा स्‍हेगदे मी मुनोन मुला, तसैनोन जुन म्‍हिसे स्‍य्‍हान्‍दोदा पाप लपुङ्ला थे परमेश्‍वरग्‍याम सजाय याङ्बा म्‍हि हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“एला यादेन काङरी खजिबासे चा एदा पाप लपुङ्ला थे थासी भ्‍याङ्‍गो। तिग्‍दा भिसम या काङ मुसी खाइमै आसिबा मेरी निबा भन्‍दा मी बरु ठुडे तसी जुकजुकधोनाला जुनी याङ्बा चा एला लागिरी ज्‍यबा तला। ");
INSERT INTO taj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","एला मीसे एदा पाप लपुङ्जी भिसम तेःसी भ्‍याङ्‍गो। तिग्‍दा भिसम मी न्‍हीनोन मुसी नर्गरी खाइमै आसिबा मेरी निबा भन्‍दा मी बरु काना तसी जुकजुकधोनाला जुनी याङ्बा चा एदा ज्‍यबा तला। ");
INSERT INTO taj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“च्‍यागो, एनीगदेसे चु कोलागदे न्‍हङ‍री खालैदान हेला थालउ। तिग्‍दा भिसम चु कोलागदेदा च्‍याबा स्‍वर्गदूतगदे स्‍वर्गरी धन्‍छ्‌याबा ङाला आबादेन छ्‌याम सदन तला। थेतबासेलमा एनीगदे होशियार तसी चिउ। ");
INSERT INTO taj_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","तिग्‍दा भिसम परमेश्‍वरसे पुइखबा म्‍हि म्‍हाबागदेदा म्‍हाइबारीदेन थार्बा पिन्‍बारी खबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“च्‍यागो, खालै म्‍हिला ग्‍यार्जा गिक ग्‍यु न्‍हङ‍री गिक म्‍हाजी भिसम थेसे तिग लला? तिग थेसे बोगल ब्‍लिसे च्‍युक कु ग्‍युदा गङरीन ख्‍लासी म्‍हाबा ग्‍यु म्‍हाइबारी आनि? ");
INSERT INTO taj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","च्‍यागो, ङाला ताम ङ्‌यान्‍गो, चुदे थे म्‍हिसे म्‍हाबा ग्‍यु स्‍याप्‍जी भिसम थे आम्‍हबा बोगल ब्‍लिसे च्‍युक कु ग्‍युगदेला लागिरी भन्‍दा थे स्‍याप्‍बा ग्‍यु गिकला लागिरी ल्‍हानान ताङ्ला। ");
INSERT INTO taj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","थेह्रङ् लसीन स्‍वर्गरी धन्‍छ्‌याबा एनीगदेला परमेश्‍वर आबालाएनोन चु कोलागदे न्‍हङ‍री खालैनोन नाश थातगै भिबा सेम मुला। ");
INSERT INTO taj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“चुदे परमेश्‍वरदा विश्‍वास लबा खालै म्‍हिसे एला बिरोध लसी आज्‍यबा गे लजी भिसम ए गिक जे थे मुबा ग्‍लारी निसी थेदा घोना लउ। चुदे एला ताम ङ्‌यान्‍सी थेसे ह्राङसे लबा आज्‍यबा गे ख्‍लाजी भिसम थे एला ह्रो तला। ");
INSERT INTO taj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","तर थेसे एला ताम आङ्‌यान्‍नी भिसम एसे ह्राङदेन छ्‌याम स्‍य्‍हान्‍दो म्‍हि गिक अथवा न्‍ही भोर्सी निउ। ओच्‍छे परमेश्‍वरला बचनसे पाङ्बा ह्रङ् म्‍हि न्‍ही अथवा सोम साक्षी थान्‍सी जम्‍मान ताम पक्‍का लउ। ");
INSERT INTO taj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","थे म्‍हिसे थेनीगदेला तामएनोन आङ्‌यान्‍नी भिसम एसे मण्‍डलीदा पाङ्‍गो। मण्‍डलीला तामएनोन आङ्‌यान्‍नी भिसम एसे थेदा परमेश्‍वरदा आतेन्‍बा म्‍हिदेन तिरो दुइबा म्‍हि ह्रङ्‌बान म्‍हन्‍सी ख्‍लापिन्‍गो। ");
INSERT INTO taj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","एनीगदेसे ङाला ताम ङ्‌यान्‍गो, एनीगदेसे जम्‍बुलिङरी जुन स्‍हे ढुङ्ला थे स्‍हे स्‍वर्गरीनोन ढुङ्ला। ओच्‍छे एनीगदेसे जम्‍बुलिङरी जुन स्‍हे ठोङ्ला, थे स्‍हे स्‍वर्गरीनोन ठोङ्ला। ");
INSERT INTO taj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“दोःसी ङाइ एनीगदेदा पाङ्ला, जम्‍बुलिङरी एनीगदे न्‍हङला म्‍हि न्‍ही ढिक्‍सी तिगै ताम ह्रीजी भिसम स्‍वर्गरी धन्‍छ्‌याबा ङाला आबासे एनीगदेदा पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","तिग्‍दा भिसम ङाला मिनरी म्‍हि न्‍ही सोम ढिक्‍सी खजिबै ग्‍लारी ह्रुप तजी भिसम ङा थेनीगदेदेन छ्‌याम तला।” ");
INSERT INTO taj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","जमाहेन्‍से पत्रुससे येशूदा “प्रभु, परमेश्‍वरदा विश्‍वास लबा म्‍हिसे ङादा आज्‍यना लजी भिसम ङाइ थेदा गाते रेमधोना माफ लतोःबा? निसरेमधोना?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","येशूसे थेदा चुह्रङ् भिसी जोहाब पिन्‍जी, “निसरेमधोना जे आहिन, एसे थेदा सदन माफ लउ! ");
INSERT INTO taj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","तिग्‍दा भिसम स्‍वर्गला य्‍हुल्‍सा मी ग्‍ले गिक ह्रङ्‌बान हिन्‍ना। थेसे ह्राङला नोकरगदेदेन छ्‌याम हिसाब किताब किन्‍बारी म्‍हाइजी। ");
INSERT INTO taj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","थे ग्‍लेसे हिसाब किताब किन्‍बारी छ्‌याइमा हजार च्‍युइ म्‍हरला डबल छे किन्‍बा नोकरदा ग्‍ले मुबा ग्‍लारी भजी। ");
INSERT INTO taj_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","तर थे नोकरसे छे फाबारी आखम्‍बासे लमा ग्‍लेसे थेदा, थेला म्रिङ, झा झामेदेन थेदेन छ्‌याम मुबा जम्‍मान स्‍हे चूङ्सी जम्‍मान टाङगा किन्‍गो” भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","जमाहेन्‍से थे नोकरसे ग्‍लेदा फ्‍या लबान, “ह्राङसे तिगै रेधोना भ्रान्‍गो। ङाइ ह्राङला जम्‍मान टाङगा फाला” भिसी बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","थे नोकरदा म्राङ्सी ग्‍लेदा दया रेःजी। ओच्‍छे ग्‍लेसे थेदा ‘दाहेन्‍से तजी, एसे चु छे फाआतोः’ भिसी ख्‍लापिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“जमाहेन्‍से थे नोकर निजी। निबान लमा थेसे ङाच्‍छा ग्‍यार्जा गिक म्‍हुइला डबल पिन्‍बा ह्रोदा स्‍याप्‍जी। जमाहेन्‍से थेसे ह्रोला खारेरी न्‍हेप्‍सी ‘ङाला टाङगा दान्‍देन भउ’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","जमाहेन्‍से थे ह्रोसे थेदा फ्‍या लबान, ‘तिगै रे भ्रान्‍गो ङाइ एला जम्‍मान टाङगा पिन्‍ना’ भिसी बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","तर थेसे आङ्‌यान्‍ना ह्रोदा टाङगा आपिन्‍तेधोना झ्‍याल्‍खानरी झाङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“थे नोकरसे थेह्रङ् लबा म्राङ्सी स्‍य्‍हान्‍दो ह्रोगदेदा ल्‍हानान दुख ङ्‍हम्‍सी थेसे लबा जम्‍मान ताम ग्‍लेदा पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","थेह्रङ्बा ताम थेःसी ग्‍लेसे थे नोकरदा ह्राङ मुबा ग्‍लारी ङ्‌योइजी। ओच्‍छे थेदा ‘पापी नोकर, एला ताम थेःसी ङाइ दया लसी एसे फातोःबा जम्‍मान टाङगा ख्‍लापिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ङाइ एदा दया लमाहेन्‍से एसेनोन एला ह्रोदा दया लआतोःबा?’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","थे नोकरला बेहोर म्राङ्सी ग्‍लेदा ल्‍हानान बोमो खजी। जमाहेन्‍से थेदाएनोन जम्‍मान छे आफातेधोना सजाय पिन्‍बा म्‍हिगदेला यारी जिम्‍मा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“थेह्रङ् लसीन एनीगदेसेनोन परमेश्‍वरदा विश्‍वास लबा खालै म्‍हिदा सेमहेन्‍सेन माफ आलनी भिसम स्‍वर्गरी धन्‍छ्‌याबा ङाला आबासेनोन एनीगदेदा थेह्रङ्नोन लला।” ");
INSERT INTO taj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","चु ताम सुङ्सी जिन्‍माहेन्‍से येशू गालील अञ्‍चलग्‍याम यर्दन स्‍योङला क्‍याम्‍सङपट्टि यहूदिया अञ्‍चलरी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","येशूला लिच्‍छा लिच्‍छा म्‍हिला हुल खजी। ओच्‍छे येशूसे थेनीगदेदा खम्‍ना लजी। ");
INSERT INTO taj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ओच्‍छे कोइ कोइ फरिसीगदेसे येशूला सेम च्‍याबाला लागिरी, “खालै म्‍हिसे ह्राङला म्रिङदा तिगै दोष उन्‍सी छोडपत्र लबा ठीक हिन्‍ना कि आहिन” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","जमाहेन्‍से येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “परमेश्‍वरसे जम्‍बुलिङ छ्‌यामाहेन्‍सेन ‘ह्रेम्‍कोलादेन म्रिङकोला स्‍होबा हिन्‍ना’ भिबा ताम एनीगदेसे पढब लबा आरे? ");
INSERT INTO taj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‘थेतबासेलमा म्‍हिसे ह्राङला आबादेन आमादा ख्‍लासी ह्राङला म्रिङदेन छ्‌याम ढिक्‍सी चिमुला। ओच्‍छे थेन्‍नी ल्‍हुइ गिक ह्रङ्‌बान तला’ ");
INSERT INTO taj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","दाहेन्‍से थेन्‍नी ल्‍हुइ न्‍ही आहिन, तर ल्‍हुइ गिकनोन हिन्‍ना। थेतबासेलमा परमेश्‍वरसे स्‍होबा जोडीदा खालैसेन थाफेगै।” ");
INSERT INTO taj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","थेनीगदेसे दोःसी येशूदा “थेह्रङ् भिसम मोशासे तिग्‍दा छोडपत्र भ्रिसी म्रिङदा ख्‍लागो भिसी कुल्‍बा?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","जमाहेन्‍से येशूसे थेनीगदेदा “मोशासे मी एनीगदेला सेम कोङ्बासे म्रिङदा ख्‍लाबारी तला भिसी पाङ्बा हिन्‍ना। तर ङाच्‍छाहेन्‍से चा चुह्रङ्बा ठिम आरेबा। ");
INSERT INTO taj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","थेतबासेलमा एनीगदेसे ङाला ताम ङ्‌यान्‍गो, जुन म्‍हिसे ह्राङला म्रिङ स्‍य्‍हान्‍दोदेन छ्‌याम ब्रेल्‍सी आभ्रसै ख्‍लासी स्‍य्‍हान्‍दो म्रिङम्‍हेमेदेन छ्‌याम ब्‍याह लला थेसे चा ङाच्‍छाला म्रिङला बिरोधरी ब्रेल्‍सी भ्रबा हिन्‍ना। ओच्‍छे स्‍य्‍हान्‍दोसे ख्‍लाबा म्रिङम्‍हेमेदेन छ्‌याम ब्‍याह लबा म्‍हिएनोन ब्रेल्‍सी भ्रबा हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","जमाहेन्‍से चेलागदेसे येशूदा “म्रिङ ह्रेम्‍बो न्‍हङ‍री चुह्रङ् तसम ब्‍याह आलबान ज्‍यबा हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “तर जम्‍मान म्‍हि ब्‍याह आलना चिबारी आखम। जुन म्‍हिदा परमेश्‍वरसे ब्‍याह आलना चिखम्‍बा शक्ति पिन्‍ना थे जे चिखम्‍ला। ");
INSERT INTO taj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","तिग्‍दा भिसम कोइ न्‍हमान नपुंसक न्‍हमुला, कोइ म्‍हिदा चा स्‍य्‍हान्‍दो म्‍हिसे नपुंसक स्‍होसी थान्‍मुला। ओच्‍छे कोइ म्‍हि चा स्‍वर्गला य्‍हुल्‍साला गे लबारी नपुंसक ह्रङ् लसीन ब्‍याह आलना चिमुला। जुन म्‍हि चुह्रङ् लसी चिखम्‍ला, थे म्‍हि जे चुह्रङ् लसी चिउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","येशूसे ह्राङला छ्‌या कोलागदेथोरी थान्‍सी मोलम पिन्‍गै भिसी म्‍हिगदेसे ह्राङला कोलागदेदा येशू मुबा ग्‍लारी भजी। चु म्राङ्सी येशूला चेलागदेसे थे कोलागदे भबा म्‍हिगदेदा बङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","तर येशूसे चेलागदेदा “कोलागदेदा ङा मुबा ग्‍लारी खपुङ्‍गो, थेनीगदेला ग्‍याम थाकागो। तिग्‍दा भिसम स्‍वर्गला य्‍हुल्‍सा चु कोलागदे ह्रङ्बालान हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","जमाहेन्‍से येशूसे कोलागदेथोरी ह्राङला छ्‌या थान्‍सी मोलम पिन्‍जी। ओच्‍छे येशू थे ग्‍याम फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","फ्‍युक्‍पो म्‍हि गिक येशू मुबा ग्‍लारी खसी, “गुरु, जुकजुकधोनाला जुनी याङ्बारी ङाइ ज्‍यबा गे तिग लतोःला?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","जमाहेन्‍से येशूसे थेदा “एसे ङादा ज्‍यबा तिग हिन्‍ना भिसी तिग्‍दा ङ्‌योइबा? च्‍यागो, ज्‍यबा मी परमेश्‍वर जे मुला। थेतबासेलमा एदा जुकजुकधोनाला जुनी याङ्बा सेम मुसम परमेश्‍वरसे कुल्‍बा अन्‍छार भ्रउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","थे म्‍हिसे येशूदा “परमेश्‍वरसे कुल्‍बा खजिबा ताम?” भिसी भिमा, येशूसे थेदा चुह्रङ् भिसी सुङ्जी, “एसे म्‍हि थासाइगो, स्‍य्‍हान्‍दोदेन छ्‌याम ब्रेल्‍सी थाभ्रउ, य्‍हो थालउ, लुसीला ताम पाङ्सी थाभ्रउ, ");
INSERT INTO taj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ह्राङला आबा आमादा मान लउ, ओच्‍छे एसे ह्राङला खिम्‍जेमदा ह्राङदा ह्रङ्नोन माया लउ।” ");
INSERT INTO taj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","जमाहेन्‍से थे म्‍हिसे येशूदा “चु जम्‍मान ताम मी ङाइ लसीन चिबा मुला। दाहेन्‍से ङाइ लतोःबा तिग मुला?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","जमाहेन्‍से येशूसे थेदा “चुदे ए परमेश्‍वरदा सेम निबा म्‍हि दोबा हिन्‍सम एदेन छ्‌याम मुबा जम्‍मान धन सम्‍पत्ति चूङ्सी प्राङबोगदेदा भो लसी पिन्‍गो। एसे स्‍वर्गरी धन सम्‍पत्ति याङ्ला, ओच्‍छे ङादेन छ्‌याम भ्रउ।” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","येशूला ताम थेःसी थे म्‍हि ल्‍हानान दुख ङ्‍हम्‍सी निजी। तिग्‍दा भिसम थेदेन छ्‌याम ल्‍हानान धन सम्‍पत्ति मुबा। ");
INSERT INTO taj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ओच्‍छे येशूसे ह्राङला चेलागदेदा चुह्रङ् भिसी सुङ्जी, “च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, फ्‍युक्‍पो म्‍हिदा स्‍वर्गला य्‍हुल्‍सारी वाङ्बारी ल्‍हानान गाह्रो मुला। ");
INSERT INTO taj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","दोःसी ङाइ एनीगदेदा पाङ्ला, फ्‍युक्‍पो म्‍हिदा परमेश्‍वरला य्‍हुल्‍सारी वाङ्बारी भन्‍दा ऊँटदा दापला मीग्‍याम वाङ्बारी सजिलो मुला।” ");
INSERT INTO taj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","चुह्रङ्बा ताम थेःसी चेलागदे उदेक म्‍हन्‍बान, “थेह्रङ् भिसम खाल्‍से थार्बा याङ्ला?” भिसी येशूदा ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","जमाहेन्‍से येशूसे थेनीगदेदा स्‍हीबान, “चु गे म्‍हिसे लबारीन आखम्‍बा गे हिन्‍ना। तर परमेश्‍वरसे चु जम्‍मान गे लखम्‍ला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","जमाहेन्‍से पत्रुससे येशूदा “ङन्‍से मी जम्‍मान स्‍हे ख्‍लासी ह्राङदेन छ्‌याम भ्रबा मुला। दाहेन्‍से ङन्‍से चा तिग याङ्ला?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदेसे ङाला ताम ङ्‌यान्‍गो, परमेश्‍वरसे छार जम्‍बुलिङ स्‍होमा परमेश्‍वरसे पुइखबा म्‍हि य्‍हाल य्‍हाल्‍बा शक्तिशाली ठिरी चिबा धुइरी एनीगदे ङादेन छ्‌याम भ्रबागदेएनोन ह्राङला च्‍युक न्‍ही ठिरी चिला। ओच्‍छे इस्राएलला च्‍युक न्‍ही वंशला निसाफ लला। ");
INSERT INTO taj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","थेह्रङ् लसीन जुन म्‍हिसे ङाला लागिरी ह्राङला दिमनाम, ज्‍योज्‍यो आले, नाना आङा, आबा आमादेन झा झामे ख्‍लाला, थेसे थे भन्‍दा दोब्‍बर, तेब्‍बर, चौबरधोना याङ्ला। ओच्‍छे जुकजुकधोनाला जुनी याङ्बा अधिकार याङ्ला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","तर दान्‍दे ङाच्‍छा मुबागदे न्‍हङला ल्‍हानान म्‍हि लिच्‍छा तला। ओच्‍छे दान्‍दे लिच्‍छा मुबागदे चा ङाच्‍छा तला। ");
INSERT INTO taj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“च्‍यागो, स्‍वर्गला य्‍हुल्‍सा अङगुर वारीला दोप्‍ता गिक ह्रङ्‌बान हिन्‍ना। थे म्‍हि स्‍य्‍होरीन ह्राङला वारीरी गे लबारी म्‍हि म्‍हाइबारी निजी। ");
INSERT INTO taj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","थेसे म्‍हि स्‍याप्‍माहेन्‍से धिन गिकला ज्‍याला तोगब लसी थेनीगदेदा अङगुर वारीरी गे लउ भिसी पुइजी। ");
INSERT INTO taj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“दोःसी थे दोप्‍ता नौ बजेरीक्‍यार बजाररी निमा गे आयाङ्ना चिबा म्‍हि म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","जमाहेन्‍से थेसे थे म्‍हिगदेदा ‘एनीगदेएनोन ङाला अङगुर वारीरी गे लबारी निउ। ङाइ एनीगदेदा ठीक ज्‍याला पिन्‍ना’ भिसी भिमाहेन्‍से, ");
INSERT INTO taj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","थेनीगदे गे लबारी निजी। “थेह्रङ् लसीन दोःसी थे दोप्‍तासे बाह्र बजेदेन तीन बजेरीक्‍यारएनोन स्‍य्‍हान्‍दो म्‍हिगदे भसी गे लपुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“पाँच बजेरीक्‍यार दोःसी थे दोप्‍ता बजाररी निमा गे आयाङ्ना चिबा म्‍हिगदे स्‍याप्‍जी। थेतबासेलमा थेसे थे म्‍हिगदेदा ‘एनीगदे तिग्‍दा गे आलना धिन गिक य्‍होङ्सी चिबा?’ भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","थेनीगदेसे ‘खाइ ङन्‍दा खालैसेन गे आपिन्‍नी’ भिसी भिजी। जमाहेन्‍से थे दोप्‍तासे ‘थेह्रङ् भिसम एनीगदे ङाला अङगुर वारीरी निसी गे लउ’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“ङ्‍यसे तमाहेन्‍से थे अङगुर वारीला दोप्‍तासे नाइकेदा ‘गे लबागदे जम्‍मादान ङ्‌योइसी थेनीगदेदा ज्‍याला पिन्‍गो। ज्‍याला पिन्‍बा धुइरी जम्‍मान भन्‍दा लिच्‍छा गे लबारी खबा म्‍हिगदेदा ङाच्‍छा पिन्‍गो, ओच्‍छे ङाच्‍छा गे लबारी खबा म्‍हिगदेदा चा लिच्‍छा पिन्‍गो’ भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","जमाहेन्‍से पाँच बजेरी गे लबारी खबा म्‍हि खजी। थेनीगदेदा धिन गिकलान ज्‍याला पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","पाँच बजेरी खबागदेदा धिन गिकला ज्‍याला पिन्‍बा म्राङ्सी स्‍य्‍होरी जम्‍मान भन्‍दा ङाच्‍छा खसी गे लबागदेसे चा य्‍हाङसे मी थे भन्‍दा ल्‍हानान याङ्ला तला भिसी म्‍हन्‍जी। तर थेनीगदेसेनोन धिन गिकला ज्‍याला जे याङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ज्‍याला याङ्माहेन्‍से थेनीगदेसे थे अङगुर वारीला दोप्‍ताला बिरोध लबान ताम लबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘लिच्‍छा खसी घण्‍टा गिक जे गे लबा चुगदेदा ङनी स्‍य्‍होहेन्‍से धिन गिकनोन छेप्‍बा छबा नासी गे लबागदेदा तेनोन तिग्‍दा ह्राङसे ज्‍याला पिन्‍बा’ भिसी थेनीगदेसे भिजी, ");
INSERT INTO taj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“तर थे अङगुर म्राङ्ला दोप्‍तासे थेनीगदे न्‍हङला म्‍हि गिकदा चुह्रङ् भिसी जोहाब पिन्‍जी, ‘च्‍यागो, एनीगदेदा ङाइ तिगै अन्‍याय लबा आरे। ङाइ धिन गिकला ज्‍याला पिन्‍ना भिमा एसेन तला भिसी गे लबा आहिन? ");
INSERT INTO taj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","थेतबासेलमा एला ज्‍याला भोर्सी निउ। लिच्‍छा खसै चुगदेदा एदा तेनोन पिन्‍बा ङाला सेम मुला। ");
INSERT INTO taj_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ङादेन मुबा स्‍हे ङाइ म्‍हन्‍बा अन्‍छार पिन्‍आम्‍याङ्? ङाइ ताङ्सी पिन्‍बा ग्‍लारी एसे तिग्‍दा डाह लबा?’ ");
INSERT INTO taj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“चुह्रङ् लसी लिच्‍छाला म्‍हि ङाच्‍छा, ङाच्‍छाला म्‍हि लिच्‍छा तला।” ");
INSERT INTO taj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","यरूशलेमपट्टि फेप्‍बान लबा धुइरी येशूसे ह्राङला च्‍युक न्‍ही चेलागदेदा कुनी गिकरी भोर्सी चुह्रङ् भिसी सुङ्जी, ");
INSERT INTO taj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“च्‍यागो, दान्‍दे य्‍हाङ यरूशलेमपट्टि निबान मुला। दाहेन्‍से परमेश्‍वरसे पुइखबा म्‍हिदा परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी धर्मगुरुगदेला यारी जिम्‍मा पिन्‍ना। जमाहेन्‍से थेनीगदेसे थेदा ‘चुदा साइनोन तोःला’ भिसी पाङ्ला। ");
INSERT INTO taj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ओच्‍छे थेदा अर्गु य्‍हुलला म्‍हिगदेला यारी जिम्‍मा पिन्‍ना। जमाहेन्‍से थेनीगदेसे थेदा खिसी लबान कोर्रासे तोबा ग्‍याङ्‍बा लसी क्रुसरी टाँगब लसी साइला। तर थेदा सोमरेमाकुनु सिबाग्‍याम सोना लला।” ");
INSERT INTO taj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","जमाहेन्‍से जब्‍दियाला म्रिङसे ह्राङला झा न्‍हीदा छ्‌यामनोन येशू मुबा ग्‍लारी भसी खजी। ओच्‍छे थेसे येशूदा फ्‍या लबान बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","जमाहेन्‍से येशूसे थेदा “एदा तिग तोःबा?” भिसी सुङ्मा, थेसे येशूदा “ह्राङसे शासन लबा धुइरी ङाला झा न्‍हीदा गिकदा ह्राङला दाहिनेपट्टि गिकदा देब्रेपट्टि चिपुङ्ला भिसी सुङ्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","तर येशूसे थेनीगदेदा “तिग ह्रीदोबा भिसी एनीगदेदा थानोन आरे। ङाइ नाबा दुख एनीगदेसे नाबारी खम्‍ला?” भिसी सुङ्जी। थेनीगदेसे “खम्‍ला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","जमाहेन्‍से येशूसे थेनीगदेदा “एनीगदेसे ङाइ नाबा दुख मी नाला। तर ङाला दाहिने देब्रे चिपुङ्बा अधिकार ङाला यारी आरे। चु ग्‍ला ङाला आबासे जुन म्‍हिला लागिरी स्‍होबा हिन्‍ना थे जे चिम्‍याङ्ला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","चु ताम थेःसी स्‍य्‍हान्‍दो चेला च्‍युइदा चा थेन्‍ना ज्‍योज्‍यो आले न्‍हीदेन छ्‌याम बोमो रेःजी। ");
INSERT INTO taj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","तर येशूसे थेनीगदेदा ह्राङ मुबा ग्‍लारी ङ्‌योइसी चुह्रङ् भिसी सुङ्जी, “च्‍यागो, एनीगदेदा चु ताम थानोन मुला, अर्गु य्‍हुलला शासन लबा म्‍हिगदेसे ह्राङला सेमसे म्‍हन्‍बा अन्‍छार म्‍हिगदेथोरी शासन लमुला। ओच्‍छे घ्रेन घ्रेन पदरी मुबा म्‍हिगदेसे ह्राङ भन्‍दा धिरी मुबा म्‍हिगदेथोरी शासन लमुला। ");
INSERT INTO taj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","तर एनीगदे चा थेह्रङ् तबारी आत। जुन म्‍हि जम्‍मान भन्‍दा घ्रेन दोबारी म्‍हाइला थेसे चा एनीगदेला सेवा लतोःला। ");
INSERT INTO taj_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ओच्‍छे एनीगदे न्‍हङ‍री जुन म्‍हि ङाच्‍छा तबारी म्‍हाइला थे चा एनीगदेला नोकर दोतोःला। ");
INSERT INTO taj_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","थेह्रङ् लसीन परमेश्‍वरसे पुइखबा म्‍हिएनोन स्‍य्‍हान्‍दोगदेग्‍याम सेवा किन्‍बारी आहिन, तर स्‍य्‍हान्‍दोगदेला सेवा लबारी ओच्‍छे ह्राङलान ज्‍यान पिन्‍सी ल्‍हानान म्‍हिगदेला पापला सय फाबारी खबा हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","येशू ह्राङला चेलागदेदेन छ्‌याम यरीहो भिबा शहरग्‍याम फेप्‍बान लबा धुइरी म्‍हिला हुलएनोन थेनीगदेदेन छ्‌याम छ्‌याम खजी। ");
INSERT INTO taj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ग्‍यामला कुनीरी चिबा मी आम्राङ्बा म्‍हि न्‍हीसे येशू थेनोन ग्‍याम फेप्‍बान लबा ताम था याङ्सी “प्रभु, दाऊद ग्‍लेला सन्‍तान! ङन्‍दा दया लउ” भिसी क्रिङ्बान भिजी। ");
INSERT INTO taj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","थे म्‍हि न्‍हीदा येशूदेन छ्‌यामनोन खबा म्‍हिगदेसे “कुटिसी चिउ” भिसी बङ्जी। तर थेन्‍नी झन क्रिङ्बान, “प्रभु, दाऊद ग्‍लेला सन्‍तान ङन्‍दा दया लउ” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","जमाहेन्‍से थेन तसी येशूसे थेनीगदेदा “ङाइ एनीगदेला लागिरी तिग लगै भिसी म्‍हन्‍बा मुला?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","थेनीगदेसे येशूदा “प्रभु ह्राङसे ङन्‍ना मी म्राङ्ना लपिन्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","थेनीगदेला ताम थेःसी येशूदा दया रेःसी येशूसे थेनीगदेला मीरी थुर्जी। थुर्मैछ्‌याम थेनीगदेसे म्राङ्जी। ओच्‍छे थेनीगदे येशूदेन छ्‌याम भ्रजी। ");
INSERT INTO taj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","येशू ह्राङला चेलागदेदेन छ्‌याम फेप्‍बान लमा यरूशलेम ङामला जैतून भिबा गङला बेथफागे नाम्‍सारी धोखजी। ओच्‍छे येशूसे ह्राङला चेला न्‍हीदा पुइजी। ");
INSERT INTO taj_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","पुइबा धुइरी चुह्रङ् भिसी सुङ्जी, “एनी जजाकी क्‍याथाङला नाम्‍सारी निउ। एनी थेरी धोमैछ्‌याम च्‍युन्‍सी थान्‍बा गधाला मामादेन कोला म्राङ्ला। जमाहेन्‍से एनीसे थे गधाला मामादेन कोलादा ब्‍लसी ङा मुबा ग्‍लारी भउ। ");
INSERT INTO taj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","थेरी एनीदा खालैसे तिगै भिजी भिसम ‘चु प्रभुदा तोःबा मुला’ भिसी भिउ। जमाहेन्‍से थेनीगदेसे एनीदा पुइखला।” ");
INSERT INTO taj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","अगमवक्ताग्‍याम पाङ्बा बचन पूरा तगै भिसी चु तबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“सियोनना म्‍हिगदेदा चुह्रङ् भिसी पाङ्‍गो, ‘च्‍यागो, एनीगदेला ग्‍ले एनीगदे मुबा ग्‍लारी गधाला कोलाथोरी क्रेःसी फेप्‍खबान मुला। थे ल्‍हानान सोजो मुला।’” ");
INSERT INTO taj_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","जमाहेन्‍से चेला न्‍ही निसी येशूसे कुल्‍बा अन्‍छार लजी। ");
INSERT INTO taj_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","थेनीगदेसे गधाला मामादेन कोला भजी। ओच्‍छे थे गधाला मामादेन कोलाथोरी ह्राङ ह्राङला घ ती‍जी। जमाहेन्‍से येशू थेथोरी धन्‍छ्‌याजी। ");
INSERT INTO taj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ओच्‍छे थेरी मुबा ल्‍हानान म्‍हिगदेसे ग्‍यामरी ह्राङ ह्राङला घगदे ती‍जी, कोइसे स्‍याउला थासी ग्‍यामरी ती‍जी, ");
INSERT INTO taj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","जमाहेन्‍से येशूला लिच्‍छा ङाच्‍छा भ्रबा जम्‍मान म्‍हिला हुलसे चुह्रङ् भिसी क्रिङ्बान जयजयकार लजी, “दाऊद ग्‍लेला सन्‍तानला जयजयकार तगै। परमप्रभुला मिनरी फेप्‍खबासे परमेश्‍वरग्‍याम मोलम याङ्‌गै। थेह्रङ् लसीन स्‍वर्गरी धन्‍छ्‌याबा परमेश्‍वरदा जयजयकार तगै।” ");
INSERT INTO taj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","येशू यरूशलेमरी धोमाहेन्‍से शहर नाङनोन हल्‍ली खल्‍ली तजी। ओच्‍छे म्‍हिगदेसे “चु खाल हिन्‍ना?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","येशूदेन छ्‌याम खबा म्‍हिला हुलसे “चु गालीलला नासरत भिबा नाम्‍साग्‍याम फेप्‍खबा अगमवक्ता येशू हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","येशूसे परमेश्‍वरला मन्‍दिर न्‍हङरी चूङ्बादेन ग्‍लुबागदेदा ताप्‍जी। ओच्‍छे टाङगा देप्‍बारी चिबागदेला टेबुलदेन ढुकुर चूङ्बारी चिबागदे जम्‍मालान चिबा ग्‍लागदे प्‍लाङ प्‍लिङ लसी भ्‍याङ्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ओच्‍छे येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “च्‍यागो, ‘ङाला दिम य्‍हुल य्‍हुलला म्‍हिगदेसे प्रार्थना लबा दिम दोला’ भिसी परमेश्‍वरला बचनरी भ्रिबा मुला। तर एनीगदेसे मी ङाला दिमदा य्‍होगदे चिबा ग्‍ला स्‍होबा मुला।” ");
INSERT INTO taj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","येशू परमेश्‍वरला मन्‍दिररी मुबा धुइरी मी आम्राङ्बा म्‍हिदेन कुज्‍या म्‍हिगदे येशू मुबा ग्‍लारी खजी। जमाहेन्‍से येशूसे थेनीगदेदा खम्‍ना लजी। ");
INSERT INTO taj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","तर येशूसे लबा उदेकला गेदेन परमेश्‍वरला मन्‍दिररी कोलागदेसे “दाऊद ग्‍लेला सन्‍तानना जयजयकार तगै” भिसी क्रिङ्बा म्राङ्सी परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी धर्मगुरुगदे बोमो खजी। ");
INSERT INTO taj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","थेनीगदेसे येशूदा “चु कोलागदेसे तिग भिबान मुला ह्राङसे थेःबा आरे?” भिसी भिमा, येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “थेःबा मुला। तर परमेश्‍वरला बचनरी चुह्रङ् भिसी भ्रिबा मुला, ‘प्रभु, ह्राङसे लैनु कोलागदेदेन जजा कोलागदेदाएनोन जयजयकार लतोःला भिसी लोप्‍बा मुला’ तिग एनीगदेसे चु ताम पढब लबा आरे?” ");
INSERT INTO taj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","जमाहेन्‍से थेनीगदेदा थेरी ख्‍लासी येशू बेथानिया भिबा नाम्‍सारी फेप्‍सी जमाकुनु म्‍हुनङ थेरीन धन्‍छ्‌याजी। ");
INSERT INTO taj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","न्‍हङगरदङ स्‍य्‍होरी यरूशलेमपट्टि दोःसी फेप्‍खबान लबा धुइरी येशूदा फोख्रेन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ग्‍यामरी फेप्‍बान लबा धुइरी येशूसे ग्‍यामला कुनीरी अञ्‍जीरला दोङ गिक म्राङ्जी। थे दोङरी अञ्‍जीर मुजी वा भिसी स्‍हीबारी फेप्‍मा भा जे म्राङ्सी “दाहेन्‍से चु दोङरी खाइमै अञ्‍जीर थारोगै” भिसी येशूसे सुङ्जी। थेह्रङ् सुङ्मैछ्‌याम थे अञ्‍जीर दोङ खर्जी। ");
INSERT INTO taj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","अञ्‍जीर दोङ खर्सी निबा म्राङ्सी उदेक म्‍हन्‍बान येशूला चेलागदेसे “दान्‍देला दान्‍देन खाह्रङ् लसी चु अञ्‍जीर दोङ खर्जी?” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, एनीगदेला सेमरी शङ्का आलना विश्‍वास लजी भिसम चु अञ्‍जीर दोङदा लबा ह्रङ् जे आहिन, तर चु गङदाएनोन ‘ए होक निसी समुन्‍द्ररी ताइगो’ भिसम थेह्रङ्नोन तला। ");
INSERT INTO taj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ओच्‍छे एनीगदेसे विश्‍वास लसी प्रार्थना लमा जुन ताम ह्रीला थेनोन एनीगदेसे याङ्ला।” ");
INSERT INTO taj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","परमेश्‍वरला मन्‍दिररी फेप्‍सी येशूसे म्‍हिगदेदा लोप्‍बान लबा धुइरी परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी गन्‍बागदे येशू मुबा ग्‍लारी खसी “ह्राङसे खानङग्‍याम अधिकार याङ्सी चु गे लबा हिन्‍ना? ह्राङदा चु अधिकार खाल्‍से पिन्‍बा हिन्‍ना?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदेदाएनोन ङाइ ताम गिक ङ्‌योइला। थे तामला जोहाब पिन्‍जी भिसम ङादा चु गेगदे लबारी खाल्‍से अधिकार पिन्‍जी थे एनीगदेदा पाङ्ला। ");
INSERT INTO taj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","यूहन्‍नादा बप्‍तिस्‍मा पिन्‍बा अधिकार खाल्‍से पिन्‍जी? परमेश्‍वरसे कि म्‍हिगदेसे?” जमाहेन्‍से थेनीगदे ह्राङ ह्राङ न्‍हङ‍री सल्‍लाह लबान, “परमेश्‍वरग्‍याम भिजी भिसम थेसे य्‍हाङदा ‘थेह्रङ् भिसम एनीगदेसे तिग्‍दा यूहन्‍नादा विश्‍वास आलबा?’ भिसी भिला। ");
INSERT INTO taj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","तर म्‍हिगदेग्‍याम भिजी भिसम म्‍हिला हुलसे साइला भिसी य्‍हाङ लोङ्‌मुला। तिग्‍दा भिसम जम्‍मासेन यूहन्‍नादा अगमवक्ता हिन्‍ना भिसी भिमुला।” ");
INSERT INTO taj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","थेतबासेलमा थेनीगदेसे “ङन्‍दा था आरे” भिसी येशूदा जोहाब पिन्‍जी। येशूसे थेनीगदेदा “थेह्रङ् भिसम ङाइएनोन चु गेगदे खाल्‍ला अधिकारग्‍याम लबा हिन्‍ना, थे एनीगदेदा आपाङ्” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","येशूसे अझ चुह्रङ् भिसी सुङ्जी, “ङाइ एनीगदेदा झा न्‍ही मुबा म्‍हिला उखान पाङ्ला। एनीगदेसे चुग्‍याम तिग घोला? थे म्‍हि थेबा झा मुबा ग्‍लारी निसी ‘ए तिनी अङगुर वारीरी निसी गे लउ झा’ भिसी कुल्‍मा, ");
INSERT INTO taj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","थेसे ‘ङा आनि आबा’ भिसी जोहाब पिन्‍जी। तर लिच्‍छा सेम दोःसी थे गे लबारी निजी। ");
INSERT INTO taj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“थेह्रङ् लसीन थे झा च्‍याङ्बा मुबा ग्‍लारी निसी थेदाएनोन थेह्रङ्नोन भिसी कुल्‍मा, थेसे ‘तला आबा ङा निला’ भिसी भिजी। तर थे आनिनी।” ");
INSERT INTO taj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","जमाहेन्‍से येशूसे परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी गन्‍बागदेदा “चु न्‍ही न्‍हङ‍री खजिबासे चा आबासे कुल्‍बा ताम ङ्‌यान्‍जी” भिसी ङ्‌योइमा, थेनीगदेसे “थेबा झासे” भिसी जोहाब पिन्‍जी। ओच्‍छे येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, एनीगदे भन्‍दा ङाच्‍छा तिरो दुइबा म्‍हिगदेदेन बेश्‍यागदे परमेश्‍वरला य्‍हुल्‍सारी निला। ");
INSERT INTO taj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","तिग्‍दा भिसम बप्‍तिस्‍मा पिन्‍बा यूहन्‍नासे एनीगदेदा परमेश्‍वरसे म्‍हन्‍बा अन्‍छारला ग्‍याम उन्‍बारी खमाएनोन एनीगदेसे थेदा विश्‍वास आलनी। बरु तिरो दुइबा म्‍हिगदेदेन बेश्‍यागदेसे चा थेदा विश्‍वास लजी। थेनीगदेसे विश्‍वास लबा म्राङ्सीनोन एनीगदेसे ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि आदोःनी। ओच्‍छे थेला ताम विश्‍वास आलनी। ");
INSERT INTO taj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“अर्गु उखानएनोन ङ्‌यान्‍गो, फ्‍युक्‍पो म्‍हि गिकसे वारीरी अङगुर सूसी क्‍युर्सीन पर्खाल लजी। ओच्‍छे अङगुर म्‍हर्बारी कोल स्‍होसी अङगुर वारी ख्रुङ्बारी नोबा छाप्रो गिक स्‍होजी। जमाहेन्‍से अधियाँरी पिन्‍सी थे अर्गु य्‍हुल्‍सारी निजी। ");
INSERT INTO taj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“अङगुर मिन्‍बा धुइ तमाहेन्‍से थे फ्‍युक्‍पो म्‍हिसे ह्राङला भो किन्‍बाला लागिरी अधियाँ लबागदे मुबा ग्‍लारी ह्राङला नोकरगदेदा पुइजी। ");
INSERT INTO taj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ओच्‍छे अधियाँ लबागदेसे थे फ्‍युक्‍पो म्‍हिला नोकर गिकदा चुङ्सी तोबा ग्‍याङ्‍बा लजी, गिकदा साइजी तर स्‍य्‍हान्‍दो गिकदा चा युङबासे तोजी। ");
INSERT INTO taj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","थे फ्‍युक्‍पो म्‍हिसे दोःसी ङाच्‍छाला भन्‍दा ल्‍हानान नोकरगदे पुइजी, तर थेनीगदेसे थे नोकरगदेदाएनोन थेह्रङ्नोन लजी। ");
INSERT INTO taj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“जमाहेन्‍से थे फ्‍युक्‍पो म्‍हिसे जम्‍मान भन्‍दा लिच्‍छा ‘थेनीगदेसे ङाला झादा मी मान लला तला’ भिसी थेसे ह्राङला झादान थेनीगदे मुबा ग्‍लारी पुइजी। ");
INSERT INTO taj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","तर थेदा खबान लबा म्राङ्सी अधियाँ लबागदेसे ‘चु मी य्‍हाङला धनीला झा हिन्‍ना, य्‍हाङसे थेदा साइगे। जमाहेन्‍से थेला सम्‍पत्ति य्‍हाङलान तला’ भिसी ह्राङ ह्राङ न्‍हङ‍री ताम लजी। ");
INSERT INTO taj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","जमाहेन्‍से थेनीगदेसे थे फ्‍युक्‍पो म्‍हिला झादा चुङ्सी अङगुर वारीग्‍याम क्‍याथाङ भोर्सी साइजी। ");
INSERT INTO taj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","जमाहेन्‍से परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी गन्‍बागदेदा येशूसे “दाहेन्‍से अङगुर वारीला धनी खसी थे अधियाँ लबा म्‍हिगदेदा तिग लला?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","थेनीगदेसे “थे अङगुर वारीला धनीसे थेह्रङ्बा नइबा गे लबा म्‍हिगदेदा नाश लला। ओच्‍छे जुन म्‍हिसे अङगुर मिन्‍माहेन्‍से ह्राङला भो पिन्‍ना थेह्रङ्बा म्‍हिगदेदा अधियाँ पिन्‍ना” भिसी येशूदा जोहाब पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","जमाहेन्‍से येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदेसे परमेश्‍वरला बचन खाइमै पढब लबा आरे? ‘जुन युङबादा दिम स्‍होबा कर्मीगदेसे गे आखेल भिसी भ्‍याङ्‍बा मुबा थेनोन युङबा दिमला सुर युङबा दोजी। चु परमप्रभुग्‍याम तबासे लमा य्‍हाङला लागिरी उदेकला ताम हिन्‍ना’ भिसी भ्रिबा मुला। ");
INSERT INTO taj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“थेतबासेलमा एनीगदेसे ङाला ताम ङ्‌यान्‍गो। च्‍यागो, दाहेन्‍से परमेश्‍वरला य्‍हुल्‍सा एनीगदेग्‍याम ब्‍यन्‍सी परमेश्‍वरसे कुल्‍बा अन्‍छार भ्रबा य्‍हुलला म्‍हिगदेदा पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","थे युङबाथोरी ताइबा म्‍हि चा जम्‍मान छारछिर निला, ओच्‍छे थे युङबा खालैथोरी ताइजी भिसम थेरी मुबा म्‍हि फ्‍लातफ्‍लेत निला।” ");
INSERT INTO taj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","येशूसे सुङ्बा उखान थेःमाहेन्‍से परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन फरिसीगदेसे “चु ताम येशूसे य्‍हाङलान बारेरी पाङ्बा ताम हिन्‍ना” भिसी घोजी। ");
INSERT INTO taj_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","थेतबासेलमा थेनीगदेसे येशूदा चुङ्बारी म्‍हाइजी, तर थेनीगदे म्‍हिला हुल म्राङ्सी लोङ्जी। तिग्‍दा भिसम म्‍हिगदेसे येशूदा अगमवक्ता भिसी म्‍हन्‍मुबा। ");
INSERT INTO taj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","दोःसीनोन येशूसे थेनीगदेदा उखानग्‍याम चुह्रङ् भिसी सुङ्जी, ");
INSERT INTO taj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“स्‍वर्गला य्‍हुल्‍सा चुह्रङ्बान हिन्‍ना, ग्‍ले गिकसे ह्राङला झाला ब्‍याहला भोज ठीक लजी। ");
INSERT INTO taj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ओच्‍छे निम्‍तो याङ्बा म्‍हिगदेदा ङ्‌योइबारी ह्राङला नोकरगदे पुइजी। तर निम्‍तो याङ्बा म्‍हिगदेसे खबा सेम आलनी। ");
INSERT INTO taj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“दोःसी ग्‍लेसे निम्‍तो याङ्बा म्‍हिगदेदा ‘ङाइ छोबा छोबा म्‍हे बहर साइसी ब्‍याहला भोज ठीक लसी जिन्‍बा मुला। दाहेन्‍से ह्राङनी फेप्‍खउ भिउ’ भिसी स्‍य्‍हान्‍दो नोकरगदेदा पुइजी। ");
INSERT INTO taj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“तर थे निम्‍तो याङ्बा म्‍हिगदेसे नोकरगदेला तामदा थेगोन आलना कोइ ह्राङला बु वारीरीक्‍यार निजी, कोइ व्‍यापार लबारी निजी, ");
INSERT INTO taj_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ओच्‍छे स्‍य्‍हान्‍दोगदेसे चा थे नोकरगदेदा चुङ्सी तोबा ग्‍याङ्‍बा लसी साइजी। ");
INSERT INTO taj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","चु ताम थेःसी ग्‍ले ल्‍हानान बोमो खजी। जमाहेन्‍से ग्‍लेसे सिपाहीगदेदा पुइसी ह्राङला नोकरगदे साइबागदेदा साइजी। ओच्‍छे थेनीगदेला शहरएनोन ख्राङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“जमाहेन्‍से ग्‍लेसे ह्राङला नोकरगदेदा चुह्रङ् भिसी कुल्‍जी, ‘ब्‍याहला भोज ठीक लसी जिन्‍बा मुला। तसैनोन निम्‍तो याङ्बा म्‍हिगदे य्‍हाङला भोजरी खबाधोनाला आरेम। ");
INSERT INTO taj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","थेतबासेलमा दाहेन्‍से एनीगदे ग्‍याम ग्‍यामरी निउ। ओच्‍छे स्‍याप्‍बागदे जम्‍मादान ब्‍याहला भोज चबारी खउ भिसी निम्‍तो पिन्‍गो।’ ");
INSERT INTO taj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ओच्‍छे नोकरगदे ग्‍याम ग्‍यामरी निसी ज्‍यबा गे लबा तसै आज्‍यबा गे लबा तसै स्‍याप्‍तेबा जम्‍मादान निम्‍तो पिन्‍जी। चुह्रङ् लसी ब्‍याह दिम नाङनोन डोन्‍बोगदे तजी। ");
INSERT INTO taj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“डोन्‍बोगदेदा च्‍याबारी भिसी ग्‍ले दिम न्‍हङ‍री खमा थेरी ब्‍याहरी खबा धुइरी क्‍वान्‍तोःबा क्‍वान आक्‍वान्‍ना खबा म्‍हि गिकदा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","थेदा म्राङ्सी, ‘ओहो, ह्रो!, ए मी ब्‍याहरी क्‍वान्‍तोःबा क्‍वान आक्‍वान्‍ना चुरी खाह्रङ् लसी खजी?’ भिसी ङ्‌योइमा, थे म्‍हिसे तिगै जोहाब पिन्‍आखम्‍नी। ");
INSERT INTO taj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","जमाहेन्‍से ग्‍लेसे ह्राङला नोकरगदेदा ‘चुला या काङ खीसी मङग्‍यार धोपधोप्‍बा ग्‍लारी भ्‍याङ्‍गो। थेरी म्‍हिगदे स्‍वा क्रेसी क्राबा क्रिङ्बा लला’ भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“तिग्‍दा भिसम ङ्‌योइबागदे ल्‍हानान मुला, तर धम्‍बागदे चा ल्‍हाना आरे।” ");
INSERT INTO taj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","जमाहेन्‍से फरिसीगदे येशू मुबा ग्‍लाग्‍याम निजी। ओच्‍छे दाहेन्‍से येशूदा थेलान तामग्‍याम खाह्रङ् लसी फसब लसे भिसी ह्राङ ह्राङ न्‍हङ‍री सल्‍लाह लजी। ");
INSERT INTO taj_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","थेनीगदेसे ह्राङला चेलागदेदा हेरोद ग्‍लेला म्‍हिगदेदेन छ्‌याम येशू मुबा ग्‍लारी पुइजी। थे म्‍हिगदे येशू मुबा ग्‍लारी निसी चुह्रङ् भिसी भिजी, “गुरु, ह्राङ सत्‍य म्‍हि हिन्‍ना, ओच्‍छे ह्राङसे खालैदा वास्‍ता आलमुला भिसी ङन्‍दा था मुला। तिग्‍दा भिसम ह्राङसे म्‍हिला ली च्‍यासी गे आलमुला, तर ह्राङसे म्‍हिगदेदा लोप्‍बा धुइरी परमेश्‍वरला ग्‍याम ज्‍यना लसी उन्‍मुला। ");
INSERT INTO taj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","थेतबासेलमा रोमी ग्‍याल्‍बो कैसरदा तिरो फाबा ठीक हिन्‍ना कि आहिन? ङन्‍दा सुङ्‍गो।” ");
INSERT INTO taj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","तर येशूसे थेनीगदेला सेमला नइबा ताम था याङ्सी “कप्‍टीगदे, तिग्‍दा एनीगदेसे ङादा फसब लबारी म्‍हाइबा? ");
INSERT INTO taj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","एनीगदेसे तिरो फाबा डबल ङादा उन्‍गो” भिसी सुङ्मा, थेनीगदेसे डबल गिक भसी येशूदा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","जमाहेन्‍से येशूसे थेनीगदेदा “चु डबलरी मुबा छापदेन मिन खाल्‍ला हिन्‍ना?” भिसी सुङ्मा, ");
INSERT INTO taj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","थेनीगदेसे “रोमी ग्‍याल्‍बो कैसरला” भिसी जोहाब पिन्‍जी। जमाहेन्‍से येशूसे थेनीगदेदा “दाहेन्‍से एनीगदेसे रोमी ग्‍लेला जति रोमी ग्‍लेदा फागो। ओच्‍छे परमेश्‍वरला जति परमेश्‍वरदान फागो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","चुह्रङ्बा ताम थेःसी थेनीगदे उदेक तजी। जमाहेन्‍से थेनीगदेसे येशूदा ख्‍लासी निजी। ");
INSERT INTO taj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","म्‍हि सिमाहेन्‍से दोःसी आसो भिसी विश्‍वास लबा सदुकीगदे थेनोन धिनकुनु येशू मुबा ग्‍लारी खसी येशूदा चुह्रङ् भिसी ङ्‌योइबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“गुरु, मोशासे य्‍हाङदा पिन्‍बा ठिम अन्‍छार खालैला ज्‍योज्‍योसे ब्‍याह लसी कोलागदे आतनान सिजी भिसम ज्‍योज्‍यो‍ला लागिरी कोलागदे तगै भिसी आलेसे चाङदा ब्‍याह लतोःला भिसी पाङ्बा मुला। ");
INSERT INTO taj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ङन्‍ना गुङरी ज्‍योज्‍यो आले निस मुबा। थेनीगदे न्‍हङ‍री थेबासे ब्‍याह लजी। तर कोलागदे आतनान थे सिजी। जमाहेन्‍से पाराङसे थेनोन चाङदेन छ्‌याम ब्‍याह लजी। ");
INSERT INTO taj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","थेह्रङ् लसीन पाराङ साँजी लसी च्‍याङ्बाधोनासेन थेनोन चाङदेन छ्‌याम ब्‍याह लजी। ");
INSERT INTO taj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","थेनीगदे जम्‍मान सिमाहेन्‍से थे म्रिङम्‍हेमेनोन सिजी। ");
INSERT INTO taj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","थेतबासेलमा ङन्‍दा सुङ्‍गो, सिबाग्‍याम सोना लजी भिसम थे म्रिङम्‍हेमे खजिबाला म्रिङ तला? तिग्‍दा भिसम थेनीगदे जम्‍मासेन थे म्रिङम्‍हेमेदेन छ्‌याम ब्‍याह लबा मुला।” ");
INSERT INTO taj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","जमाहेन्‍से येशूसे थेनीगदेदा चुह्रङ् भिसी जोहाब पिन्‍जी, “एनीगदे अन्‍दोलरीन चीम, तिग्‍दा भिसम एनीगदेसे परमेश्‍वरला बचनदेन परमेश्‍वरला शक्तिला बारेरी घोबान आरेम। ");
INSERT INTO taj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","तिग्‍दा भिसम सिबाग्‍याम सोना लबा धुइरी न्‍ह ब्‍याह लला न्‍ह ब्‍याह तला। तर थेनीगदे स्‍वर्गरी मुबा स्‍वर्गदूतगदे ह्रङ्‌बान तला। ");
INSERT INTO taj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","सिबाग्‍याम सोना लबाला बारेरी परमेश्‍वरसे एनीगदेदा तिग सुङ्बा मुला, थे ताम एनीगदेसे पढब लबा आरे? ");
INSERT INTO taj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘ङा अब्राहाम, इसहाकदेन याकूबला परमेश्‍वर हिन्‍ना’ भिसी परमेश्‍वरसे मोशादा सुङ्बा मुबा। परमेश्‍वर सिबागदेला परमेश्‍वर आहिन, तर सोबागदेला परमेश्‍वर हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","येशूसे चुह्रङ् लसी लोप्‍बा म्राङ्सी थेरी मुबा म्‍हिला हुल उदेक तजी। ");
INSERT INTO taj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","येशूसे सदुकीगदेदा जोहाबनोन पिन्‍आखम्‍बा तना लजी भिबा ताम थेःसी फरिसीगदे ढिक्‍सी सल्‍लाह लबारी ग्‍ला गिकरी पोप तजी। ");
INSERT INTO taj_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","जमाहेन्‍से थेनीगदे न्‍हङला यहूदी धर्मगुरु गिकसे येशूला सेम च्‍याबाला लागिरी चुह्रङ् भिसी ङ्‌योइजी, ");
INSERT INTO taj_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“गुरु, परमेश्‍वरसे मोशादा पिन्‍बा ठिमरी जम्‍मान भन्‍दा मुल ताम चा खजिबा हिन्‍ना?” ");
INSERT INTO taj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","येशूसे थेदा चुह्रङ् भिसी सुङ्जी, “च्‍यागो, परमेश्‍वरसे कुल्‍बा जम्‍मान भन्‍दा मुल ताम चा चुनोन हिन्‍ना। एसे ह्राङला परमप्रभु परमेश्‍वरदा ह्राङला जम्‍मान सेमहेन्‍से, जम्‍मान प्राणसे, जम्‍मान बुद्धिसे माया लउ। ");
INSERT INTO taj_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ओच्‍छे अर्गु मुल ताम चा एसे ह्राङला खिम्‍जेमदा ह्राङदा ह्रङ्नोन माया लउ। ");
INSERT INTO taj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","अगमवक्तागदेसे लोप्‍बा तामदेन मोशाला ठिमरी मुबा जम्‍मान तामगदे चा परमेश्‍वरसे कुल्‍बा चु मुल ताम न्‍हीग्‍यामनोन खबा हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","जमाहेन्‍से येशूसे थेरी पोप तसी चिबा फरिसीगदेदा चुह्रङ् भिसी ङ्‌योइजी, ");
INSERT INTO taj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“थार्बा पिन्‍बा ख्रीष्‍टला बारेरी एनीगदेसे तिग म्‍हन्‍बा मुला? थे खाल्‍ला झा हिन्‍ना?” थेनीगदेसे येशूदा “दाऊद ग्‍लेला सन्‍तान हिन्‍ना” भिसी जोहाब पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","दोःसी येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “थेह्रङ् भिसम दाऊददा परमेश्‍वरला आत्‍माला शक्तिग्‍याम तिग्‍दा ख्रीष्‍टदा ‘प्रभु’ भिपुङ्जी? दाऊदसेन चुह्रङ् भिसी भिमुला, ");
INSERT INTO taj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘परमप्रभुसे ङाला प्रभुदा, “ङाइ एला शत्रुगदेदा एला काङ धिरी आथान्‍तेधोना ए ङाला दाहिनेपट्टि चिउ भिसी सुङ्जी।”’ ");
INSERT INTO taj_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","दाऊद ग्‍लेसेन ख्रीष्‍टदा प्रभु भिला भिसम खाह्रङ् लसी ख्रीष्‍ट दाऊद ग्‍लेला सन्‍तान तला?” ");
INSERT INTO taj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","जमाहेन्‍से खालैसेन येशूदा जोहाब गिकनोन लआखम्‍नी। जमाकुनुहेन्‍से खालैसेन येशूदा तिगै ताम ङ्‌योइबा आँट आलनी। ");
INSERT INTO taj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","जमाहेन्‍से येशूसे ह्राङला चेलागदेदेन थेरी मुबा म्‍हिला हुलदा चुह्रङ् भिसी सुङ्जी, ");
INSERT INTO taj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“च्‍यागो, यहूदी धर्मगुरुदेन फरिसीगदेसे मोशाला ठिम लोप्‍बा अधिकार याङ्बा मुला। ");
INSERT INTO taj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","थेतबासेलमा थेनीगदेसे पाङ्बा ताम एनीगदेसे ङ्‌यान्‍गो, तर थेनीगदेसे लबा ह्रङ्‌बान गे चा थालउ। तिग्‍दा भिसम थेनीगदेसे एनीगदेदा लोप्‍बाम लोप्‍मुला, तर लोप्‍बा अन्‍छारला गे चा आलमुला। ");
INSERT INTO taj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ओच्‍छे म्‍हिगदेदा थेनीगदेसे पुइनोन आखम्‍बा धोइ काप्‍सी पिन्‍मुला। तर थेनीगदेसे भिसम थे धोइ थीबाला लागिरी या जुम्‍बीसेनोन आथुर्मुला। ");
INSERT INTO taj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“थेनीगदेसे जम्‍मान गे म्‍हिदा उन्‍बाला लागिरी लमुला। तिग्‍दा भिसम थेनीगदेसे परमेश्‍वरसे मोशादा पिन्‍बा ठिम कागजरी भ्रिसी घ्रेन घ्रेन जन्‍तर स्‍होसी ङोदेन नारीरी खीमुला। ओच्‍छे थेनीगदेसे क्‍वान्‍बा क्‍वान्‍ना जोरी ह्रेङ्बा ह्रेङ्बा फुर्गा कार्मुला। ");
INSERT INTO taj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","थेनीगदेसे भोजरीदेन यहूदीगदे ह्रुप तबा दिमला मुल ठिरी चिबारी सेम लमुला। ");
INSERT INTO taj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","बजाररी निमाएनोन म्‍हिगदेसे फ्‍या लगै भिसी म्‍हन्‍मुला, ओच्‍छे ‘गुरु’ भिसीएनोन पाङ्‌गै भिसी म्‍हन्‍मुला। ");
INSERT INTO taj_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","तर एनीगदेदा खालैसेन ‘गुरु’ भिसी थाभिगै। तिग्‍दा भिसम एनीगदे ज्‍योज्‍यो आले हिन्‍ना। एनीगदेला गुरु चा गिक जे मुला। ");
INSERT INTO taj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","जम्‍बुलिङरी एनीगदेसे खालैदान आबा थापाङ्‍गो। तिग्‍दा भिसम स्‍वर्गरी एनीगदे जम्‍मालान आबा गिक जे मुला। ");
INSERT INTO taj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ओच्‍छे एनीगदेदा खालैसेन ‘मालिक’ थाभिगै। तिग्‍दा भिसम एनीगदे जम्‍मालान मालिक थार्बा पिन्‍बा ख्रीष्‍ट जे हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","एनीगदे न्‍हङला जुन म्‍हि घ्रेन मुला, थेसे चा एनीगदे जम्‍मालान सेवा लतोःला। ");
INSERT INTO taj_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ओच्‍छे जुन म्‍हिसे ह्राङसे ह्राङदान घ्रेन स्‍होला, थे म्‍हि चा जजा दोला। तर ह्राङसे ह्राङदान जजा स्‍होबा म्‍हि चा घ्रेन दोला। ");
INSERT INTO taj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“परमेश्‍वरग्‍याम सजाय याङ्तोःबा यहूदी धर्मगुरुदेन फरिसीगदे, एनीगदे मी कप्‍टीगदे हिन्‍ना। तिग्‍दा भिसम एनीगदेसे म्‍हिगदेला ङाच्‍छा स्‍वर्ग य्‍हुल्‍साला म्राप ढुङ्मुला। ओच्‍छे एनीगदे ह्राङएनोन आनिमुला निबारी म्‍हाइबा म्‍हिदाएनोन निआपुङ्मुला। ");
INSERT INTO taj_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“परमेश्‍वरग्‍याम सजाय याङ्तोःबा यहूदी धर्मगुरुदेन फरिसीगदे, एनीगदे मी कप्‍टीगदे हिन्‍ना। तिग्‍दा भिसम एनीगदेसे ह्रेम्‍बो सिबा म्रिङम्‍हेमेगदेला दिमनाम ब्‍यन्‍मुला। ओच्‍छे म्‍हिदा उन्‍बाला लागिरी ह्रेङ्बा ह्रेङ्बा प्रार्थना लबा स्‍होमुला। थेतबासेलमा स्‍य्‍हान्‍दोगदेसे भन्‍दा एनीगदेसे ल्‍हाना सजाय याङ्ला। ");
INSERT INTO taj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“परमेश्‍वरग्‍याम सजाय याङ्तोःबा यहूदी धर्मगुरुदेन फरिसीगदे, एनीगदे मी कप्‍टीगदे हिन्‍ना। तिग्‍दा भिसम एनीगदे गङ स्‍योङ थासी भ्रसै कोर्सी कोर्सी स्‍य्‍हान्‍दो म्‍हिदा ह्राङलान ग्‍यामरी भ्रपुङ्मुला। ओच्‍छे तिगै लसी स्‍य्‍हान्‍दो म्‍हि गिक एनीगदेदेन छ्‌याम ढिक्‍जी भिसम एनीगदेसे थे म्‍हिदा ह्राङ भन्‍दा आज्‍यबा स्‍होसी नर्गरी नितोःबा म्‍हि स्‍होमुला। ");
INSERT INTO taj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“स्‍य्‍हान्‍दोदा लोप्‍बा काना म्‍हिगदे, एनीगदेसे परमेश्‍वरग्‍याम गाते सजाय याङ्ला। एनीगदेसे म्‍हिगदेदा लोप्‍बा धुइरी ‘परमेश्‍वरला मन्‍दिरला मिन किन्‍सी घ्रान फासैनोन तिगै आतमुला। तर परमेश्‍वरला मन्‍दिररी मुबा म्‍हरला मिन किन्‍सी घ्रान फाजी भिसम चा थे घ्रानसेन चमुला’ भिसी लोप्‍मुला। ");
INSERT INTO taj_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","मूर्ख कानागदे, खजिबा चा घ्रेन? म्‍हरदा चोखो तना लबा परमेश्‍वरला मन्‍दिर घ्रेन कि म्‍हर घ्रेन? ");
INSERT INTO taj_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ओच्‍छे ‘खालै म्‍हिसे बलि फुल्‍बा ग्‍लाला मिन किन्‍सी घ्रान फाजी भिसम तिगै आतमुला, तर थेरी फुल्‍बा भेटीला मिन किन्‍सी घ्रान फाजी भिसम चा थे घ्रानसेन चमुला’ भिसीनोन एनीगदेसे लोप्‍मुला। ");
INSERT INTO taj_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","कानागदे, खजिबा चा घ्रेन हिन्‍ना। भेटीदा चोखो तना लबा ग्‍ला घ्रेन कि भेटी घ्रेन? ");
INSERT INTO taj_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","थेतबासेलमा च्‍यागो, परमेश्‍वरला मन्‍दिररी बलि फुल्‍बा ग्‍लाला मिन किन्‍सी घ्रान फाबा म्‍हिसे थेथोरी मुबा जम्‍मान स्‍हेला मिन किन्‍सी घ्रान फाबा तला। ");
INSERT INTO taj_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ओच्‍छे परमेश्‍वरला मन्‍दिरला मिन किन्‍सी घ्रान फाबासे थेरी धन्‍छ्‌याबाला मिन किन्‍सी घ्रान फाबा तला। ");
INSERT INTO taj_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","थेह्रङ् लसीन स्‍वर्गला मिन किन्‍सी घ्रान फाबासे परमेश्‍वरला ठिदेन थेथोरी धन्‍छ्‌याबाला मिन किन्‍सी घ्रान फाबा तला। ");
INSERT INTO taj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“परमेश्‍वरग्‍याम सजाय याङ्तोःबा यहूदी धर्मगुरुदेन फरिसीगदे, एनीगदे मी कप्‍टीगदे हिन्‍ना। तिग्‍दा भिसम एनीगदेसे बाबरीदेन सोँप ओच्‍छे जिराला भो च्‍युइला भो गिक चा पिन्‍मुला। तर ठीक निसाफ, दयादेन विश्‍वासला बारेरी परमेश्‍वरसे मोशादा पिन्‍बा ठिमला मुल तामदा चा आङ्‌यान्‍मुला। तर एनीगदेसे चु गे न्‍हीनोन लतोःबा मुबा। ");
INSERT INTO taj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","तर एनीगदेसे भुसुना ह्रङ्‌बा जजा स्‍हे चा म्राङ्बा, तर ऊँट ह्रङ्‌बा घ्रेन स्‍हेदा चा आम्राङ्बा, एनीगदे मी कानान हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“परमेश्‍वरग्‍याम सजाय याङ्तोःबा यहूदी धर्मगुरुदेन फरिसीगदे, एनीगदे मी कप्‍टीगदे हिन्‍ना। एनीगदेसे खोरेदेन खार्बाला पाखापट्टि जे म्‍याप्‍मुला। तर न्‍हङपट्टि चा चीबुन थान्‍बा ह्रङ् लसी एनीगदेसे ह्राङला सेमरी लोभदेन म्‍हिदा ठगब लबा ह्रङ्‌बा नइबा ताम थान्‍मुला। ");
INSERT INTO taj_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","काना फरिसीगदे, ङाच्‍छा खार्बादेन खोरे न्‍हङपट्टि ज्‍यना लसी म्‍याप्‍गो। जमाहेन्‍से जे थे खार्बादेन खोरे पाखापट्टि ज्‍यना लसी धा‍ला। ");
INSERT INTO taj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“परमेश्‍वरग्‍याम सजाय याङ्तोःबा यहूदी धर्मगुरुदेन फरिसीगदे, एनीगदे मी कप्‍टीगदे हिन्‍ना। एनीगदे तार साप्रासे च्‍युर्सी थान्‍बा धुर्सा ह्रङ्‌बान मुला। थे धुर्साला पाखापट्टि च्‍यामा चा जेबा म्राङ्‌मुला। तर न्‍हङ‍री भिसम सिबा म्‍हिला नख्रुदेन नइबा स्‍हेगदेसे प्‍लिङ्बा मुला। ");
INSERT INTO taj_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","थेह्रङ् लसीन एनीगदे म्‍हिला ओन्‍छाङरी ‘ङनी परमेश्‍वरला ङाच्‍छा ज्‍यबा म्‍हि हिन्‍ना’ भिसी भ्रमुला। तर एनीगदेला सेम चा छलकपटदेन पापसे प्‍लिङ्बा मुला। ");
INSERT INTO taj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“परमेश्‍वरग्‍याम सजाय याङ्तोःबा यहूदी धर्मगुरुदेन फरिसीगदे, एनीगदे मी कप्‍टीगदे हिन्‍ना। तिग्‍दा भिसम एनीगदेसे अगमवक्तागदेला धुर्सा स्‍होमुला, ओच्‍छे परमेश्‍वरला ङाच्‍छा ज्‍यबा म्‍हिगदेला धुर्सा जेना लसी थान्‍मुला। ");
INSERT INTO taj_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ओच्‍छे ‘ङन्‍ना आखे म्‍हेमेसे अगमवक्तागदेदा साइबा धुइरी ङनीएनोन थेनीगदेदेन छ्‌याम मुबा हिन्‍सम थेनीगदेसे ह्रङ् चा ङन्‍से आलसेला मुबा’ भिसी एनीगदेसे पाङ्‌मुला। ");
INSERT INTO taj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","एनीगदेसे पाङ्बा चुह्रङ्बा तामग्‍यामसेन एनीगदे अगमवक्तागदेदा साइबागदेला सन्‍तान हिन्‍ना भिसी था तना लबा मुला। ");
INSERT INTO taj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","दाहेन्‍से एनीगदेला आखे म्‍हेमेसे शुरु लबा पाप गे एनीगदेसे पूरा लउ। ");
INSERT INTO taj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“पुख्रीदेन पुख्रीला कोलागदे, नर्गरी नातोःबा दुखग्‍याम एनीगदे खाह्रङ् लसी जोगब तला? ");
INSERT INTO taj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","थेतबासेलमा एनीगदेसे ङाला ताम ङ्‌यान्‍गो, दाहेन्‍से ङाइ अगमवक्तागदेदेन बुद्धि मुबा म्‍हिगदेदा ओच्‍छे सत्‍य ताम लोप्‍बा धर्मगुरुगदे एनीगदे मुबा ग्‍लारी पुइखला। थेनीगदेदा एनीगदेसे कोइदा साइला, कोइदा क्रुसरी टाँगब लसी साइला, कोइदा एनीगदे ह्रुप तबा दिमगदेरी भोर्सी कोर्रासे तोःला ओच्‍छे कोइदा शहर शहरग्‍याम ताप्‍ला। ");
INSERT INTO taj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","थेतबासेलमा परमेश्‍वरला ङाच्‍छा ज्‍यबा म्‍हि हाबिलदा साइबा धुइहेन्‍से बेरेक्‍याहला झा जकरियादा साइबा धुइधोना जम्‍बुलिङरी मुबा जम्‍मान ज्‍यबा म्‍हिगदेदा साइबा पापला दोष एनीगदेसेन नातोःला। एनीगदेसे बेरेक्‍याहला झा जकरियादाएनोन परमेश्‍वरला मन्‍दिरदेन बलि फुल्‍बा ग्‍लाला गुङरी साइजी। ");
INSERT INTO taj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, चु जम्‍मान पापला सजाय दान्‍देला म्‍हिगदेथोरीन खला। ");
INSERT INTO taj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“यरूशलेमला म्‍हिगदे, एनीगदेसे अगमवक्तागदेदा साइला ओच्‍छे परमेश्‍वरसे एनीगदे मुबा ग्‍लारी पुइखबागदेदा युङबासे तोला। ङाइ एनीगदेला कोलागदेदा नागा मामासे ह्राङला कोलागदेदा भ्‍याप्‍से घप्‍बा ह्रङ् लसी पोप लबारी म्‍हाइमा एनीगदेसे आङ्‌यान्‍नी। ");
INSERT INTO taj_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","थेतबासेलमा दाहेन्‍से परमेश्‍वरसे एनीगदेला शहर ख्‍लाला। ");
INSERT INTO taj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ङाला ताम ङ्‌यान्‍गो, एनीगदेसे ‘परमप्रभुला मिनरी फेप्‍खबादा मोलम याङ्बा म्‍हि’ आभितेधोना ङादा आम्राङ्।” ");
INSERT INTO taj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","जमाहेन्‍से येशू परमेश्‍वरला मन्‍दिरग्‍याम थोन्‍सी फेप्‍बारी छ्‌याइमा थेला चेलागदे परमेश्‍वरला मन्‍दिरला दिमगदे उन्‍बारी भिसी येशूला ङामरी खजी। ");
INSERT INTO taj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","तर येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदेसे चु जम्‍मान म्राङ्बा मुला आहिन? च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, चु मन्‍दिरला युङबा गिकनोन बाँकी आचिना जम्‍मान फुप्‍ला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","जमाहेन्‍से येशू जैतून भिबा गङरी धन्‍छ्‌याबा धुइरी, थेला चेलागदे सुटुक्‍क खसी “ह्राङसे सुङ्बा चु तामगदे खाइमा तला? ओच्‍छे ह्राङ फेप्‍खबा धुइदेन परमेश्‍वरसे जम्‍बुलिङला जम्‍मान म्‍हिगदेला निसाफ लबा धुइरी खाह्रङ्बा चिनु म्राङ्ला? ङन्‍दा सुङ्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदे होशियार तसी चिउ, एनीगदेदा खालैसेन झुक्‍याब थालगै। ");
INSERT INTO taj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","तिग्‍दा भिसम ल्‍हानान म्‍हिगदे ङाला मिन किन्‍सी ‘ङानोन थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍ना’ भिसी खला। ओच्‍छे ल्‍हानान म्‍हिदा झुक्‍याब लला। ");
INSERT INTO taj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","एनीगदेसे लडाइदेन लडाइला हल्‍लागदे थेःला। तसैनोन एनीगदे थालोङ्‍गो, तिग्‍दा भिसम चु तनोन तोःबा हिन्‍ना। तर थेनोन धुइरी चा चु जम्‍बुलिङ नाश आत। ");
INSERT INTO taj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","तिग्‍दा भिसम म्‍हि य्‍हुलला बिरोधरी म्‍हि य्‍हुलनोन ओच्‍छे य्‍हुल्‍साला बिरोधरी य्‍हुल्‍सा रेःला। चुह्रङ् तसी ग्‍ला ग्‍लारी अनिकाल तबादेन सङगुल निला। ");
INSERT INTO taj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","चु जम्‍मान ताम मी कोला न्‍हसेला म्रिङम्‍हेमेदा बेथासे थुर्बा ह्रङ्‌बा जे हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“थे धुइरी एनीगदेदा म्‍हिगदेसे चुङ्सी दुख पिन्‍ना, ओच्‍छे साइला। थेह्रङ् लसीन ङादा विश्‍वास लबासे लमा एनीगदेदा जम्‍मान य्‍हुलला म्‍हिगदेसे हेला लला। ");
INSERT INTO taj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","थे धुइरी ल्‍हानान म्‍हिगदेसे ङादा विश्‍वास लबा ख्‍लाला। ओच्‍छे गिकसे स्‍य्‍हान्‍दोदा चुङ्सी म्‍हिगदेला यारी जिम्‍मा पिन्‍बादेन हेला लला। ");
INSERT INTO taj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","थे धुइरी ल्‍हानान फट्टा अगमवक्तागदे थोन्‍सी ल्‍हानान म्‍हिगदेदा झुक्‍याब लला। ");
INSERT INTO taj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","थेह्रङ् लसीन पाप गे ल्‍हानान तसी निबासे लमा ल्‍हानान म्‍हिसे स्‍य्‍हान्‍दोदा माया लबा ख्‍लाबान निला। ");
INSERT INTO taj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","तर जस्‍तोन दुख तसैनोन जुन म्‍हिसे ह्राङ आसितेधोना ङादा विश्‍वास लसीन चिला थेसे थार्बा याङ्ला। ");
INSERT INTO taj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ओच्‍छे जम्‍बुलिङला जम्‍मान य्‍हुलला म्‍हिगदेसे परमेश्‍वरला य्‍हुल्‍साला समाचार थेःसी जिन्‍माहेन्‍से जे नाश तबा धुइ खला। ");
INSERT INTO taj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“थेतबासेलमा दानिएल अगमवक्तासे पाङ्बा ह्रङ्नोन एनीगदेसे परमेश्‍वरला मन्‍दिरला चोखो ग्‍लारी नइबा खबा स्‍हे म्राङ्ला।” चुला अर्थ पढब लबा म्‍हिसे घोगै। ");
INSERT INTO taj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“थे धुइरी यहूदिया अञ्‍चलरी मुबा म्‍हिगदे गङरीक्‍यार यार्गै। ");
INSERT INTO taj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ओच्‍छे तलाथोरी मुबा म्‍हिगदे ह्राङला सामान किन्‍बारी मार फाप्‍सी दिम न्‍हङरी थावाङ्‍गो। ");
INSERT INTO taj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","बु वारीरी मुबागदे ह्राङला घ किन्‍बारी दोःसी दिमरी थानिउ। ");
INSERT INTO taj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","थे धुइरी जिउ न्‍हीला म्रिङम्‍हेमेदेन कोलादा ङ्‍हे ख्‍वाबा आमागदेदा झन गाते ल्‍हानान दुख तला! ");
INSERT INTO taj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","थेतबासेलमा खङ्‍बा लादेन ब्‍लप्‍बा न्‍हबा धिनकुनु यारआतोःगै भिसी एनीगदेसे प्रार्थना लउ। ");
INSERT INTO taj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","तिग्‍दा भिसम थे धुइरी तबा घ्रेन दुख जम्‍बुलिङ छ्‌यामाहेन्‍से दान्‍देधोना तबा आरे ओच्‍छे लिच्‍छाएनोन खाइमै तसेला आरे। ");
INSERT INTO taj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","थेह्रङ्बा दुखला धिन परमेश्‍वरसे तुन्‍ना आलबा हिन्‍सम खालैसेन थार्बा आयाङ्सेला मुबा। तर परमेश्‍वरसे ह्राङसे धम्‍बा म्‍हिगदेला लागिरी थे धिन तुन्‍ना लसी पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“खालैसे एनीगदेदा ‘च्‍यागो, थार्बा पिन्‍बा ख्रीष्‍ट चुरी मुला,’ अथवा ‘थेरी मुला,’ भिजी भिसम थेनीगदेला ताम विश्‍वास थालउ। ");
INSERT INTO taj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","तिग्‍दा भिसम फट्टा ख्रीष्‍टगदेदेन फट्टा अगमवक्तागदे थोन्‍ना। ओच्‍छे थेनीगदेसे खम्‍तेधोना परमेश्‍वरसे धम्‍बा म्‍हिगदेदा झुक्‍याब लबाला लागिरी उदेकला घ्रेन चिनुगदेदेन उदेकला गेगदे लसी उन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","च्‍यागो, चु ताम ङाइ एनीगदेदा ङाच्‍छाहेन्‍सेन पाङ्सी पिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“थेतबासेलमा म्‍हिगदेसे एनीगदेदा ‘येशू तोङतोङबा ग्‍लारी मुला’ भिजी भिसम, एनीगदे थेरी थानिउ। ओच्‍छे ‘च्‍यागो, येशू मी कोठा न्‍हङ‍री मुला’ भिजी भिसैनोन एनीगदेसे थेनीगदेला ताम विश्‍वास थालउ। ");
INSERT INTO taj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","तिग्‍दा भिसम स्‍यारपट्टि तिप्‍लीङ खमा न्‍हुपधोना य्‍हाल तबा ह्रङ् लसी परमेश्‍वरसे पुइखबा म्‍हिएनोन थेह्रङ् लसीन खला। ");
INSERT INTO taj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“जुन ग्‍लारी सिबा जन्‍तु मुला थेरी गिद्धागदे पोप तमुला। ");
INSERT INTO taj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“थेह्रङ्बा दुखला धिन खमैछ्‌याम, ‘धिनीसे य्‍हाल पिन्‍बा ख्‍लाला ओच्‍छे लनीला य्‍हाल म्‍हाला। जमाहेन्‍से मुला शक्तिगदे याङयोङ तसी सुक्र सार जम्‍मान ताइला।’ ");
INSERT INTO taj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","चुह्रङ् तमाहेन्‍से मुरी परमेश्‍वरसे पुइखबा म्‍हि खबान लबा चिनु गिक म्राङ्ला। ओच्‍छे परमेश्‍वरसे पुइखबा म्‍हिदा स्‍वर्गला खसुरी शक्तिदेन घ्रेन य्‍हाल य्‍हालरी खबा म्राङ्सी जम्‍बुलिङरी मुबा जम्‍मान य्‍हुलला म्‍हिगदे क्राबा क्रिङ्बा लला। ");
INSERT INTO taj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","बिगुलला घ्रेन काइदेन छ्‌याम थेसे स्‍वर्गदूतगदेदा जम्‍बुलिङदेन मुला जम्‍मान ग्‍लारी पुइला। जमाहेन्‍से थे स्‍वर्गदूतगदेसे परमेश्‍वरसे धम्‍बा जम्‍मान म्‍हिगदेदा ग्‍ला गिकरी पोप लला। ");
INSERT INTO taj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“एनीगदेसे अञ्‍जीरला दोङदा च्‍यासी थेग्‍याम तिगै ताम लोप्‍गो। थेला हाँगागदेरी भा भुमैछ्‌याम छेप्‍बा छबा ला वाङ्‌जी भिसी एनीगदेसे था याङ्मुला। ");
INSERT INTO taj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","थेह्रङ् लसीन ङाइ पाङ्बा जम्‍मान तामगदे तबा म्राङ्माहेन्‍से परमेश्‍वरसे पुइखबा म्‍हि खबा धिन खसी जिन्‍जी भिबा ताम एनीगदेसे था याङ्‍गो। ");
INSERT INTO taj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, चु जम्‍मान ताम पूरा आततेधोना दान्‍देला म्‍हिगदे आसि। ");
INSERT INTO taj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","मुदेन जम्‍बुलिङ म्‍हासी निसैनोन ङाला बचन खाइमै आम्‍हा। ");
INSERT INTO taj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“थे दुखला धिनदेन धुइ खाइमा खला भिसी स्‍वर्गदूतदाएनोन था आरे ओच्‍छे ङा परमेश्‍वरला झादाएनोन था आरे। थे ताम परमेश्‍वर आबादा जे था मुला। ");
INSERT INTO taj_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ओन्‍मा नोआला धुइरी तबा ह्रङ्नोन परमेश्‍वरसे पुइखबा म्‍हि दोःसी खबा धुइरीनोन तला। ");
INSERT INTO taj_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","तिग्‍दा भिसम नाम खसी भाल बाढी खबा भन्‍दा ङाच्‍छा नोआ पानी जहाजरी वाङ्बा धिनकुनुधोना म्‍हिगदे चबा थुङ्बादेन ब्‍याह लबान मुबा। ");
INSERT INTO taj_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ओच्‍छे नाम खसी भाल बाढीसे आभोर्तेधोना थेनीगदेसे तिग तला भिसी था आयाङ्नी। परमेश्‍वरसे पुइखबा म्‍हि खमाएनोन थेह्रङ् तला। ");
INSERT INTO taj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","थे धुइरी बु वारीरी गे लसी चिबा म्‍हि न्‍ही न्‍हङ‍री गिकदा भोर्ला गिकदा थेरीन ख्‍लाला। ");
INSERT INTO taj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","थेह्रङ् लसीन ह्रान्‍दारी ब्रा स्‍याङ्सी चिबा म्रिङम्‍हेमे न्‍ही न्‍हङ‍री गिकदा भोर्ला, गिकदा थेरी ख्‍लाला। ");
INSERT INTO taj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“थेतबासेलमा एनीगदे होशियार तसी छोर्सी चिउ। तिग्‍दा भिसम एनीगदेला प्रभु खाइमा खला भिबा ताम एनीगदेदा था आरे। ");
INSERT INTO taj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","तर एनीगदेसे चु तामएनोन था याङ्‍गो, दिमला म्‍हिसे य्‍हो खबा धुइ था याङ्सम थे छोर्सी चिला, ओच्‍छे थेसे ह्राङला दिम न्‍हङरी य्‍हो वाङ्आपुङ्। ");
INSERT INTO taj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","थेतबासेलमा एनीगदेएनोन होशियार तसी छोर्सी चिउ। तिग्‍दा भिसम परमेश्‍वरसे पुइखबा म्‍हिएनोन एनीगदेसे आम्‍हन्‍बा धुइरी खला। ");
INSERT INTO taj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“दिमरी गे लबा बुद्धि मुबादेन भर्तुप्‍पा म्‍हि खाल हिन्‍ना? मालिकसे दिमला स्‍य्‍हान्‍दो नोकरगदेदा ठीक ठीक धुइरी चबा थुङ्बा ढिक्‍ना लसी पिन्‍बारी जिम्‍मा पिन्‍थान्‍जी।” ");
INSERT INTO taj_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","मालिक दोःसी खबा धुइरीनोन थेसे मालिकसे कुल्‍सी थान्‍बा ह्रङ् लसी गे लबा म्राङ्जी भिसम इनाम याङ्बा नोकर थेनोन हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, मालिकसे थेह्रङ्बा नोकरदा ह्राङला जम्‍मान धन सम्‍पत्ति जिम्‍मा पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","तर थे नइबा नोकरसे ‘ङाला मालिक योनान आख’ भिसी म्‍हन्‍सी, ");
INSERT INTO taj_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ङ्‍य्‍होइबा म्‍हिगदेदेन छ्‌याम चिसी चबा थुङ्बा लसी ह्राङदेन छ्‌यामनोन गे लबा नोकरगदेदा तोबा ग्‍याङ्‍बा लजी भिसम, ");
INSERT INTO taj_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","थेला मालिक थेसे आम्‍हन्‍बा धिनदेन धुइरी धोखला। ");
INSERT INTO taj_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","जमाहेन्‍से मालिकसे थेदा ल्‍हानान सजाय पिन्‍सी कप्‍टी म्‍हिगदे मुबा ग्‍लारी भ्‍याङ्‍ला। थेरी चा जम्‍मान म्‍हिगदे स्‍वा क्रेसी क्रेसी क्राबा क्रिङ्बा लसी चिला।” ");
INSERT INTO taj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","येशूसे अझ चुह्रङ् भिसी सुङ्जी, “स्‍वर्गला य्‍हुल्‍सा चा गोर च्‍युइ म्रिङकोलागदेला ताम ह्रङ्‌बान तला। थे गोर च्‍युइ म्रिङकोलागदे ह्राङ ह्राङला नाङसल थोसी म्‍हाछारदा ह्रुप तबारी निजी। ");
INSERT INTO taj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","थे गोर च्‍युइ म्रिङकोला न्‍हङ‍री गोर ङा बुद्धि मुबा, गोर ङा बुद्धि आरेबा मुबा। ");
INSERT INTO taj_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","4","तिग्‍दा भिसम बुद्धि मुबागदेसे चा नाङसलदेन छ्‌युगुएनोन भोर्सी निजी, तर बुद्धि आरेबासे चा नाङसल जे भोर्सी निजी। ");
INSERT INTO taj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","म्‍हाछार घइसी खबासे लमा थेनीगदे जम्‍मान छुप निजी। ");
INSERT INTO taj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“तर म्‍हुन गङसलरी ‘म्‍हाछारदा स्‍याप्‍बारी खउ’ भिबा काइ थेःजी। ");
INSERT INTO taj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","जमाहेन्‍से थेनीगदे जम्‍मान रेःसी ह्राङ ह्राङला नाङसल ठीक लजी। ");
INSERT INTO taj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ओच्‍छे बुद्धि आरेबा म्रिङकोलागदेसे बुद्धि मुबा म्रिङकोलागदेदा ‘ङन्‍ना नाङसल सिबारी छ्‌याइजी, एनीगदेला छ्‌युगु ङन्‍दाएनोन जजाकी जजाकी पिन्‍तोःजी’ भिसी ह्रीजी। ");
INSERT INTO taj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","तर बुद्धि मुबा म्रिङकोलागदेसे ‘ङन्‍देन छ्‌याम मुबा छ्‌युगुसे य्‍हाङ जम्‍मादान आछ्‌यो तला। बरु एनीगदे पसलरी निसी ग्‍लुसी भउ’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“तर थेनीगदे छ्‌युगु ग्‍लुबारी निमा म्‍हाछार धोखजी। ओच्‍छे ङाच्‍छान ठीक तसी चिबागदे म्‍हाछारदेन छ्‌याम भोज चबारी दिम न्‍हङ‍री वाङ्‌जी। ओच्‍छे म्राप ढुङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“छिन्‍नङ लिच्‍छा थे बुद्धि आरेबा म्रिङकोलागदे खसी ‘प्रभु, प्रभु ङन्‍दाएनोन म्राप ठोङ्सी पिन्‍गो’ भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","म्‍हाछारसे थेनीगदेदा ‘च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, ङाइ एनीगदेदा ङोसेबा आरे’ भिसी जोहाब पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“थेतबासेलमा एनीगदे होशियार तसी चिउ। तिग्‍दा भिसम ङा खजिबा धिनदेन धुइरी खला भिबा ताम एनीगदेदा था आरे। ");
INSERT INTO taj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“थे धुइरी परमेश्‍वरला य्‍हुल्‍सा चुह्रङ्बान तला, च्‍यागो, फ्‍युक्‍पो म्‍हि गिक अर्गु य्‍हुल्‍सारी निबा धुइरी ह्राङला नोकरगदेदा ङ्‌योइसी ह्राङला धन सम्‍पत्तिगदे जिम्‍मा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","अर्गु य्‍हुल्‍सारी निबा धुइरी थे फ्‍युक्‍पो म्‍हिसे ह्राङला नोकरगदेसे तिग तिग गे लखम्‍मुला थे अन्‍छार गिकदा म्‍हरला डबल ङा, गिकदा डबल न्‍ही, गिकदा डबल गिक पिन्‍सी निजी। ");
INSERT INTO taj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“जमाहेन्‍से म्‍हरला डबल ङा याङ्बा चा तुरुन्‍तन निजी। ओच्‍छे व्‍यापार लसी अर्गु म्‍हरला डबल ङा स्‍होजी। ");
INSERT INTO taj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","थेह्रङ् लसीन म्‍हरला डबल न्‍ही याङ्बासेनोन अर्गु म्‍हरला डबल न्‍ही स्‍होजी। ");
INSERT INTO taj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","तर म्‍हरला डबल गिक याङ्बासे चा थे डबल भोर्सी स न्‍हङ‍री ल्‍हुसी थान्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“ल्‍हानान धिन लिच्‍छा थे नोकर‍गदेला मालिक खसी थेनीगदेदेन छ्‌याम हिसाब किताब म्‍हाइजी। ");
INSERT INTO taj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","जमाहेन्‍से म्‍हरला डबल ङा याङ्बा नोकर खसी ‘मालिक, ह्राङसे ङादा पिन्‍बा डबल ङाग्‍याम ङाइ अर्गु डबल ङा स्‍होबा मुला, चु किन्‍गो’ भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","मालिकसे थेदा ‘स्‍याबास ज्‍यबा नोकर, एसे जजा तामरी विश्‍वास उन्‍जी। थेतबासेलमा दाहेन्‍से ङाइ एदा ल्‍हानान तामगदे जिम्‍मा पिन्‍ना। दाहेन्‍से ए ङादेन छ्‌याम ताङ्सी गे लउ’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“जमाहेन्‍से म्‍हरला डबल न्‍ही याङ्बा नोकरएनोन खसी ‘मालिक, ह्राङसे ङादा पिन्‍बा म्‍हरला डबल न्‍हीग्‍याम ङाइ अर्गु म्‍हरला डबल न्‍ही स्‍होबा मुला, चु किन्‍गो’ भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","थेदाएनोन मालिकसे ‘स्‍याबास ज्‍यबा नोकर, एसेनोन जजा तामरी विश्‍वास उन्‍जी। थेतबासेलमा एदाएनोन ङाइ ल्‍हानान तामगदे जिम्‍मा पिन्‍ना। दाहेन्‍से एएनोन ङादेन छ्‌याम ताङ्सी गे लउ’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“थेह्रङ् लसीन म्‍हरला डबल गिक याङ्बा नोकरएनोन खसी ‘मालिक, ह्राङ तिगै आढ्‍वबा ग्‍लाग्‍याम बाली दुइबारी म्‍हाइबादेन तिगै आय्‍हाप्‍बा ग्‍लारी पोप लबारी म्‍हाइबा खरो म्‍हि हिन्‍ना भिबा ताम ङादा था मुबा। ");
INSERT INTO taj_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","थेतबासेलमा लोङ्सी ह्राङसे ङादा पिन्‍बा म्‍हरला डबल ङाइ स न्‍हङ‍री ल्‍हुसी थान्‍जी। दाहेन्‍से ह्राङला चु डबल किन्‍गो’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“जमाहेन्‍से मालिकसे थेदा ‘ब्‍लेगु गे आखेल्‍बा नोकर, ङाइ तिगै आढ्वना बाली दुइबारी म्‍हाइबादेन तिगै आय्‍हाप्‍बा ग्‍लाग्‍याम पोप लबारी म्‍हाइमुला भिबा ताम एदा था मुबा हिन्‍सम, ");
INSERT INTO taj_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","एसे ङाइ पिन्‍बा डबल बैंकरी थान्‍तोःबा मुबा, एसे बैंकरी थान्‍बा हिन्‍सम ङाइ दोःसी ब्‍याजदेन थे डबल किन्‍म्‍याङ्सेला’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“जमाहेन्‍से मालिकसे ‘थे म्‍हरला डबल थेग्‍याम ब्‍यन्‍सी डबल च्‍युइ मुबा म्‍हिदा पिन्‍गो। ");
INSERT INTO taj_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","तिग्‍दा भिसम जुन म्‍हिदेन छ्‌याम मुला थेदा अर्गुएनोन पिन्‍ना। जमाहेन्‍से थेदेन छ्‌याम झन ल्‍हानान तला। तर जुन म्‍हिदेन छ्‌याम आरे थेदेन छ्‌याम मुबा जजाकीएनोन थेग्‍याम ब्‍यन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","दाहेन्‍से थे गे आखेल्‍बा नोकरदा मङग्‍यार धोपधोप्‍बा ग्‍लारी भ्‍याङ्‍गो। थेरी म्‍हिगदे स्‍वा क्रेसी क्राबा क्रिङ्बा लला।’ ");
INSERT INTO taj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“परमेश्‍वरसे पुइखबा म्‍हि य्‍हाल य्‍हाल्‍बा शक्तिरी स्‍वर्गदूतगदेदेन छ्‌याम खसी ह्राङला ठिरी शक्तिशाली ग्‍ले दोसी धन्‍छ्‌याला। ");
INSERT INTO taj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","थे धुइरी जम्‍बुलिङरी मुबा जम्‍मान य्‍हुलला म्‍हिगदे ङा मुबा ग्‍लारी पोप तला। जमाहेन्‍से गोठालोसे रादेन ग्‍युदा फेबा ह्रङ् लसी थेसेनोन थे म्‍हिगदेदा फेला। ");
INSERT INTO taj_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","थेह्रङ् लसी फेमाहेन्‍से ङाइ रादा देब्रेपट्टि थान्‍ना। ओच्‍छे ग्‍युदा चा दाहिनेपट्टि थान्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“जमाहेन्‍से ङाइ ह्राङला दाहिनेपट्टि मुबा म्‍हिगदेदा चुह्रङ् भिसी भिला, ‘ङाला आबा परमेश्‍वरग्‍याम मोलम याङ्बा म्‍हिगदे! जम्‍बुलिङ छ्‌यामाहेन्‍सेन एनीगदेला लागिरी स्‍होसी थान्‍बा य्‍हुल्‍सारी खसी चिउ। ");
INSERT INTO taj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","तिग्‍दा भिसम ङा ख्रेन्‍बा फुइबा धुइरी एनीगदेसे ङादा चबा थुङ्बा पिन्‍जी। ङा विदेशी तसैनोन एनीगदेसे ङादा ह्राङला दिमरी चिपुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ओच्‍छे ङाइ क्‍वान क्‍वान्‍आम्‍याङ्बा धुइरी एनीगदेसे ङादा क्‍वान पिन्‍जी। ङा आखम्‍बा धुइरी एनीगदेसे ङादा च्‍याजी, ङा झ्‍याल्‍खानरी परब तमा एनीगदे ङादा स्‍याप्‍बारी खजी।’ ");
INSERT INTO taj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“चुह्रङ्बा ताम थेःसी परमेश्‍वरसे कुल्‍बा ताम ङ्‌यान्‍बा म्‍हिगदेसे थेदा चुह्रङ् भिसी ङ्‌योइला, ‘प्रभु, ङन्‍से ह्राङदा खाइमा ख्रेन्‍बा फुइबा म्राङ्सी चबा थुङ्बा पिन्‍जी? ");
INSERT INTO taj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ओच्‍छे ङन्‍से ह्राङदा खाइमा विदेशी भिसी ङन्‍ना दिमरी स्‍य्‍हूपुङ्जी, ओच्‍छे खाइमा ह्राङसे क्‍वानआम्‍याङ्बा म्राङ्सी ङन्‍से ह्राङदा क्‍वान पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ह्राङ आखम्‍बा खाइमा म्राङ्सी ङन्‍से ह्राङदा च्‍याजी? खाइमा ह्राङ झ्‍याल्‍खानरी परब तबा म्राङ्सी ङनी ह्राङदा स्‍याप्‍बारी खजी?’ ");
INSERT INTO taj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“जमाहेन्‍से ङाइ थेनीगदेदा ‘एनीगदेसे ङाला ताम ङ्‌यान्‍गो, चु ङाला आलेगदे न्‍हङला जम्‍मान भन्‍दा जजा आले गिकदा एनीगदेसे जे लबा मुबा थे ङालान लागिरी लबा हिन्‍ना’ भिसी भिला। ");
INSERT INTO taj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“दोःसी ङाइ ह्राङला देब्रेपट्टि मुबा म्‍हिगदेदा चा चुह्रङ् भिसी भिला, ‘नाश तसी निबा म्‍हिगदे, दाहेन्‍से एनीगदे शैतानदेन थेला दूतगदेला लागिरी स्‍होबा खाइमै आसिबा मेरी निउ! ");
INSERT INTO taj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","तिग्‍दा भिसम ङा ख्रेन्‍बा फुइबा धुइरी एनीगदेसे ङादा चबा थुङ्बा आपिन्‍नी। ");
INSERT INTO taj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ङा विदेशी मुमा एनीगदेसे ङादा एनीगदेला दिमरी चिआपुङ्नी। ङाइ क्‍वान क्‍वान्‍आम्‍याङ्मा एनीगदेसे ङादा क्‍वान आपिन्‍नी। ङा आखम्‍बा धुइरी एनीगदेसे ङादा आच्‍यानी। ओच्‍छे ङा झ्‍याल्‍खानरी परब तबा धुइरी एनीगदे ङादा स्‍याप्‍बारी आखनी।’ ");
INSERT INTO taj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“जमाहेन्‍से थेनीगदेसेनोन ‘प्रभु, खाइमा ङन्‍से ह्राङ ख्रेन्‍बा फुइबादेन विदेशी, क्‍वान क्‍वान्‍आम्‍याङ्बा, आखम्‍बा ओच्‍छे झ्‍याल्‍खानरी परब तबा म्राङ्सीनोन ह्राङला वास्‍ता आलनी?’ भिसी ङ्‌योइला। ");
INSERT INTO taj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“जमाहेन्‍से ङाइ थेनीगदेदा ‘एनीगदेसे ङाला ताम ङ्‌यान्‍गो, चु ङाला आलेगदे न्‍हङला जम्‍मान भन्‍दा जजा आलेदा एनीगदेसे वास्‍ता आलबान ङादा वास्‍ता आलबा हिन्‍ना’ भिसी भिला। ");
INSERT INTO taj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“थेतबासेलमा परमेश्‍वरसे कुल्‍बा ताम आङ्‌यान्‍बा म्‍हिगदेसे चा जुकजुकधोनान सजाय याङ्ला। तर परमेश्‍वरसे कुल्‍बा ताम ङ्‌यान्‍बा म्‍हिगदेसे चा जुकजुकधोनाला जुनी याङ्ला।” ");
INSERT INTO taj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","चु जम्‍मान ताम सुङ्सी जिन्‍माहेन्‍से येशूसे ह्राङला चेलागदेदा चुह्रङ् भिसी सुङ्जी, ");
INSERT INTO taj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाड खबारी न्‍हीरे जे मुला भिबा ताम एनीगदेदा थानोन मुला। थेनोन धुइरी परमेश्‍वरसे पुइखबा म्‍हिदा क्रुसरी टाँगब लबारी चुङ्सी म्‍हिगदेदा जिम्‍मा पिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","थेनोन धुइरी परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हि कैयाफाला दिमरी यहूदी गन्‍बागदेदेन परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदे ह्रुप तजी। ");
INSERT INTO taj_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ओच्‍छे थेनीगदेसे येशूदा खाह्रङ् लसी खालैदा था आयाङ्ना साइबा भिसी ह्राङ ह्राङ न्‍हङ‍री सल्‍लाह लजी। ");
INSERT INTO taj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","तर थेनीगदेसे “य्‍हाङला चाडला धुइरी चा चुङ्बारी आत। चाडला धुइरी चुङ्‌जी भिसम म्‍हिगदेसे हुल दङगा लला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","येशू बेथानिया भिबा नाम्‍साला कोरे खबा सिमोनला दिमरी फेप्‍खजी। ");
INSERT INTO taj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","सोल छ्‌योइबान लबा धुइरी म्रिङम्‍हेमे गिक सिङ्‍गमरमरला ताङरी ल्‍हानान महँगो अत्तर भसी येशू मुबा ग्‍लारी खजी। ओच्‍छे थेसे थे अत्तर येशूला थोबोरी युजी। ");
INSERT INTO taj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","चुह्रङ् लबा म्राङ्सी येशूला चेलागदे बोमो खसी “चुह्रङ्बा महँगो अत्तर तिग्‍दा ओह्रङ्नोन खेरो भ्‍याङ्‍बा? ");
INSERT INTO taj_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","बरु चु अत्तर चूङ्सी खबा टाङगा प्राङबोगदेदा पिन्‍बा हिन्‍सै तसे मुबा” भिसी ह्राङ ह्राङ न्‍हङ‍री ताम लजी। ");
INSERT INTO taj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","येशूसे चु ताम था याङ्सी थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदेसे तिग्‍दा चु म्रिङम्‍हेमेदा कचकच लबा? चुसे मी ङाला लागिरी ज्‍यबा गे लबा मुला। ");
INSERT INTO taj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","तिग्‍दा भिसम प्राङबोगदे मी सदन एनीगदेदेन छ्‌याम तला। तर ङा मी एनीगदेदेन छ्‌याम सदन आत। ");
INSERT INTO taj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","चुसे ङाला सिबा ल्‍हुइ धुर्सारी थान्‍बाला लागिरी ङा सिबा भन्‍दा ङाच्‍छान ङाला थोबोरी चु अत्तर युसी ठीक लबा मुला। ");
INSERT INTO taj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, जम्‍बुलिङला जुन जुन ग्‍लारी थार्बा पिन्‍बा समाचार थेःना लला, थे, थे ग्‍लारी चु म्रिङम्‍हेमेसे लबा गे ढन्‍बाला लागिरी थेला ताम लला।” ");
INSERT INTO taj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","जमाहेन्‍से येशूला च्‍युक न्‍ही चेलागदे न्‍हङला यहूदा इस्‍करियोत भिबा चेला गिक परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदे मुबा ग्‍लारी निजी। ");
INSERT INTO taj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ओच्‍छे थेसे थेनीगदेदा “चुदे ङाइ येशूदा चुङ्सी ह्राङनीदा जिम्‍मा पिन्‍सम ह्राङनीसे ङादा तिग पिन्‍ना?” भिसी ङ्‌योइमा, थेनीगदेसे यहूदा इस्‍करियोतदा बोगल गिकसे च्‍युइ म्‍हुइला डबल पिन्‍ना भिसी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","जमाकुनुहेन्‍से यहूदा इस्‍करियोतसे येशूदा चुङ्सी पिन्‍बाला लागिरी दाउ च्‍यासी भ्रजी। ");
INSERT INTO taj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","खमीर आयुना गेङ चसी धङ्बा चाडला शुरुला धिनकुनु चेलागदे येशू मुबा ग्‍लारी खसी “ह्राङला लागिरी ङन्‍से मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाडला भोज खानङ ठीक लउ?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","येशूसे चेलागदेदा चुह्रङ् भिसी कुल्‍जी, “एनीगदे शहररी म्‍हि गिक मुबा ग्‍लारी निसी थे म्‍हिदा ‘ङा सिबा धुइ तसी जिन्‍बा मुला। थेतबासेलमा ङाइ ह्राङला चेलागदेदेन छ्‌याम चिसी एला दिमरी मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाड धङ्बा सेम मुला, भिसी गुरुसे सुङ्बा मुला’ भिसी पाङ्‍गो।” ");
INSERT INTO taj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","जमाहेन्‍से येशूसे कुल्‍बा अन्‍छारनोन चेलागदेसे मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाडला भोज ठीक लजी। ");
INSERT INTO taj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ङ्‍यसे तमाहेन्‍से येशू ह्राङला च्‍युक न्‍ही चेलागदेदेन छ्‌यामनोन भोज छ्‌योइबारी धन्‍छ्‌याजी। ");
INSERT INTO taj_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","जमाहेन्‍से भोज छ्‌योइबान लबा धुइरी येशूसे चेलागदेदा “च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, एनीगदे न्‍हङलान गिकसे ङादा म्‍हिगदेला यारी जिम्‍मा पिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","जमाहेन्‍से ल्‍हानान दुख ङ्‍हम्‍सी चेलागदे जम्‍मासेन येशूदा “प्रभु, थे म्‍हि ङानोन हिन्‍ना?” भिसी पालो पालो लसी ङ्‌योइबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ओच्‍छे येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “च्‍यागो, जुन म्‍हिसे खार्बारी ङादेन छ्‌याम गेङ तुइसी चमुला, थेनोन म्‍हिसे ङादा चुङ्सी पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","परमेश्‍वरला बचनरी भ्रिबा ह्रङ्नोन परमेश्‍वरसे पुइखबा म्‍हि मी सिनोन तोःला। तर जुन म्‍हिसे परमेश्‍वरसे पुइखबा म्‍हिदा चुङ्सी म्‍हिला यारी जिम्‍मा पिन्‍ना, थेसे परमेश्‍वरग्‍याम खाह्रङ्बा लोङ्‌बा खबा सजाय याङ्ला। बरु थे मी न्‍हनोन आन्‍हबा हिन्‍सम ज्‍यबा तसेला मुबा” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","येशूदा चुङ्सी पिन्‍बारी म्‍हाइबा यहूदासेनोन येशूदा “गुरु, थे म्‍हि ङानोन हिन्‍ना?” भिसी ङ्‌योइजी। जमाहेन्‍से येशूसे थेदा “थे ताम मी एसेन पाङ्जी” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","थेनीगदे भोज चबान लबा धुइरी येशूसे गेङ थोसी परमेश्‍वरदा धन्‍यवाद पिन्‍जी। ओच्‍छे थे गेङ क्‍युइसी चेलागदेदा “ना! चु चउ, चु ङाला ल्‍हुइ हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","जमाहेन्‍से येशूसे खोरेरी मुबा अङगुरला निङगु थोसी परमेश्‍वरदा धन्‍यवाद पिन्‍सी, चेलागदेदा चुह्रङ् भिसी सुङ्जी, “ना! एनीगदे जम्‍मासेन चु थुङ्‍गो। ");
INSERT INTO taj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","तिग्‍दा भिसम एनीगदेसे थुङ्बा चु निङगु ङाला का हिन्‍ना। चु का एनीगदेदेन छ्‌याम लबा छार कबुल हिन्‍ना। चुनोन का ल्‍हानान म्‍हिला पापला दोष मेटब लबाला लागिरी बगब तला। ");
INSERT INTO taj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","तर एनीगदेसे ङाला ताम ङ्‌यान्‍गो, एनीगदेदेन छ्‌याम ङाला आबाला य्‍हुल्‍सारी छार अङगुरला निङगु थुङ्बा धिन आखतेधोना ङाइ चु निङगु आथुङ्।” ");
INSERT INTO taj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","जमाहेन्‍से परमेश्‍वरदा धन्‍यवादला व्‍हाइ गिक गोसी येशू ह्राङला चेलागदेदेन छ्‌याम थे ग्‍लाग्‍याम जैतून भिबा गङरीक्‍यार फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","जमाहेन्‍से येशूसे ह्राङला चेलागदेदा चुह्रङ् भिसी सुङ्जी, “तिनी म्‍हुनङ एनीगदे जम्‍मासेन ङादा ख्‍लासी यार्ला। तिग्‍दा भिसम परमेश्‍वरला बचनरी ‘ङाइ गोठालोदा साइला। ओच्‍छे ग्‍युगदे ससा बङबङ तसी यार्ला’ भिसी भ्रिबा मुला। ");
INSERT INTO taj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","तर ङादा सिबाग्‍याम सोना लमाहेन्‍से एनीगदे भन्‍दा ङाच्‍छा ङा गालीलरी निला।” ");
INSERT INTO taj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","थेनोन धुइरी पत्रुससे येशूदा “ह्राङदा थेह्रङ् लमा जम्‍मासेन ख्‍लासी यार्सैनोन ङाइ ह्राङदा खाइमै आख्‍ला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","जमाहेन्‍से येशूसे पत्रुसदा “च्‍यागो, एसे ङाला ताम ङ्‌यान्‍गो। तिनी म्‍हुनङ नागा क्राबा भन्‍दा ङाच्‍छा एसे सोमरेमधोना ‘ङाइ येशूदा ङोसेबान आरे’ भिसी पाङ्ला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","दोःसी पत्रुससे येशूदा “ङा ह्राङदेन छ्‌याम सितोःसैनोन ङाइ ह्राङदा आख्‍ला” भिसी भिजी। ओच्‍छे स्‍य्‍हान्‍दो चेलागदेसेनोन थेह्रङ्नोन भिजी। ");
INSERT INTO taj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","जमाहेन्‍से येशू ह्राङला चेलागदेदेन छ्‌याम गेत‍समनी भिबा ग्‍लारी फेप्‍जी। ओच्‍छे चेलागदेदा “एनीगदे चुरीन चिउ, ङा चा जजाकी क्‍याथाङ निसी प्रार्थना लला” भिसी सुङ्सी ");
INSERT INTO taj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","येशूसे पत्रुसदेन जब्‍दियाला झा न्‍हीदा ह्राङदेन छ्‌यामनोन भोर्सी फेप्‍जी। ओच्‍छे थेदा ल्‍हानान सुर्दा तसी सेमरी दुख तबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","जमाहेन्‍से येशूसे थेनीगदेदा “ङाला सेम क्रोसी ङा सिबा तेबान तबा मुला। थेतबासेलमा एनीगदे चुरीन ङा ह्रङ् लसी छोर्सी चिउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ओच्‍छे येशू चा जजाकी क्‍याथाङ फेप्‍सी सरी ख्‍लुप तसी “आबा ङाथोरी खबारी छ्‌याइबा चु दुख तसम ङादा नाआपुङ्‍गो। तर ङाइ म्‍हन्‍बा अन्‍छार आहिन, ह्राङसे म्‍हन्‍बा अन्‍छार तगै” भिसी प्रार्थना लजी। ");
INSERT INTO taj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","जमाहेन्‍से येशू चेला सोम मुबा ग्‍लारी दोःसी फेप्‍खमा थेनीगदे म्‍हेर्सी चिबा म्राङ्सी येशूसे पत्रुसदा चुह्रङ् भिसी सुङ्जी, “एनीगदे ङादेन छ्‌याम घण्‍टा गिक सुत्तै छोर्सी चिआखम्‍नी? ");
INSERT INTO taj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","दाहेन्‍से एनीगदे पापरी फसब आतबाला लागिरी छोर्सी प्रार्थना लसी चिउ। च्‍यागो, एनीगदेला आत्‍मा मी तयार मुला, तर ल्‍हुइ चा कमजोर मुला।” ");
INSERT INTO taj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","दोःसीनोन येशू ङाच्‍छाला ग्‍लारीन फेप्‍सी “आबा चु दुख ङाइ नानोन तोःबा हिन्‍सम ह्राङसे म्‍हन्‍बा ह्रङ्नोन तगै” भिसी प्रार्थना लजी। ");
INSERT INTO taj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ओच्‍छे चेलागदे मुबा ग्‍लारी दोःसी फेप्‍खमा चेलागदे म्‍हेर्सी चिबा स्‍याप्‍जी। म्‍हेर्बा खबासे लमा थेनीगदेसे मीनोन ठोङ्आखम्‍नी। ");
INSERT INTO taj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","थेतबासेलमा येशूसे थेनीगदेदा थेरीन ख्‍लासी सोमरेमला पालोरी ङाच्‍छाला ग्‍लारीन फेप्‍सी ङाच्‍छाला ह्रङ् लसीन प्रार्थना लजी। ");
INSERT INTO taj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","जमाहेन्‍से येशू चेलागदे मुबा ग्‍लारी फेप्‍खसी थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “अझन एनीगदे म्‍हेर्सी ब्‍लप्‍बा न्‍हबान मुला? च्‍यागो, परमेश्‍वरसे पुइखबा म्‍हिदा चुङ्सी पापीगदेला यारी जिम्‍मा पिन्‍बा धुइ खसी जिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","रेःगो, निइ! च्‍यागो, ङादा स्‍य्‍हान्‍दोला यारी जिम्‍मा पिन्‍बा म्‍हि खसी जिन्‍बा मुला।” ");
INSERT INTO taj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","येशूसे चु ताम सुङ्बान लबा धुइरी च्‍युक न्‍ही चेला न्‍हङला यहूदा इस्‍करियोत भिबा चेलादेन छ्‌याम कडीदेन तरवार थोबा म्‍हिला हुल धोखजी। थेनीगदेदा परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिदेन यहूदी गन्‍बागदेसे पुइखमुबा। ");
INSERT INTO taj_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","येशूदा चुङ्बारी खबा म्‍हिगदेदा यहूदासे “जुन म्‍हिदा ङाइ च्‍योक लला थेनोन येशू हिन्‍ना, थेदान चुङ्‍गो” भिसी ङाच्‍छान पाङ्बा मुबा। ");
INSERT INTO taj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","येशू मुबा ग्‍लारी धोमैछ्‌याम यहूदासे “लास्‍सो, फ्‍याफुल्‍ला गुरु” भिसी येशूदा च्‍योक लजी। ");
INSERT INTO taj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","जमाहेन्‍से येशूसे थेदा “यहूदा, ए तिग लबारी खबा लउ” भिसी सुङ्माहेन्‍से कडी तरवार पुइसी खबा म्‍हिगदेसे येशूदा चुङ्सी खीसी भोर्जी। ");
INSERT INTO taj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","येशूदेन छ्‌याम मुबा चेलागदे न्‍हङला गिकसे ह्राङला तरवार तेःसी परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिला नोकरला नाब्‍यङ च्‍वाट्टन थाजी। ");
INSERT INTO taj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","थे चेलादा येशूसे चुह्रङ् भिसी सुङ्जी, “एला तरवार स्‍युबारी झाङ्‍गो। तिग्‍दा भिसम तरवार थोबा जम्‍मान म्‍हिदा तरवारसेन ताम्‍सी नाश लला। ");
INSERT INTO taj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","चुदे ङाइ ङाला आबादा पाङ्बा हिन्‍सम ङादा जोगब लबारी ङाला आबासे च्‍युक न्‍ही भन्‍दा ल्‍हानान स्‍वर्गदूतगदेला हुल तुरुन्‍तन पुइखसे मुबा। चु ताम दान्‍देधोना एसे घोबा आरे? ");
INSERT INTO taj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","तर ङाइ चुह्रङ् लबा हिन्‍सम परमेश्‍वरला बचनरी चुह्रङ् तनोन तला भिसी भ्रिबा ताम खाह्रङ् लसी पूरा तला?” ");
INSERT INTO taj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","जमाहेन्‍से येशूसे ह्राङदा चुङ्बारी खबा म्‍हिला हुलदा चुह्रङ् भिसी सुङ्जी, “एनीगदे तिग्‍दा य्‍होदा चुङ्बारी खबा ह्रङ् लसी कडी तरवार थोसी खबा? खाइ, ङाइ म्‍हिगदेदा धिन धिननोन परमेश्‍वरला मन्‍दिररी लोप्‍सी चिबा धुइरी एनीगदेसे ङादा आचुङ्नी। ");
INSERT INTO taj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","तर अगमवक्तागदेसे परमेश्‍वरला बचनरी भ्रिबा अन्‍छार पूरा तगै भिसीन चुह्रङ् तबा हिन्‍ना।” जमाहेन्‍से जम्‍मान चेलागदेसे येशूदा ख्‍लासी यार्जी। ");
INSERT INTO taj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","जमाहेन्‍से येशूदा चुङ्बा म्‍हिगदेसे येशूदा परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हि कैयाफाला दिमरी भोर्जी। थेरी यहूदी गन्‍बागदेदेन यहूदी धर्मगुरुगदेएनोन पोप तसी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","तर पत्रुस चा थारेङग्‍यामसेन येशूदा च्‍याबान च्‍याबान थे पूजा लबा मुल म्‍हिला दिमला ख्राङगाधोनान निजी। जमाहेन्‍से येशूदा तिग लबा चीम भिसी पालेगदेदेन छ्‌याम चिसी च्‍याबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी सभाला जम्‍मान म्‍हिगदेसे येशूदा साइबाला सजाय पिन्‍बाला लागिरी येशूला बिरोधरी लुसीला ताम पाङ्बा म्‍हिगदे म्‍हाइजी। ");
INSERT INTO taj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","चुह्रङ् लसी ल्‍हानान म्‍हिगदेसे येशूदा बिरोध लबान लुसीला ताम पाङ्जी। तसैनोन थेनीगदेसे पाङ्बा ताम गिकनोन आढिक्‍नी। जम्‍मान भन्‍दा लिच्‍छाला म्‍हि न्‍ही ङाच्‍छापट्टि खसी, ");
INSERT INTO taj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“च्‍यागो, चु म्‍हिसे ‘ङाइ परमेश्‍वरला मन्‍दिरदा फुप्‍सी सोमरेरीन स्‍होखम्‍ला’ भिसी पाङ्बा मुला” भिसी दोष लजी। ");
INSERT INTO taj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","जमाहेन्‍से परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हि रेःसी येशूदा “एसे तिग्‍दा जोहाब आपिन्‍बा? चु म्‍हिगदेसे एला बिरोधरी पाङ्बा तामला बारेरी एदा तिगै पाङ्सेला आरे?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","तर येशूसे तिगै जोहाब आलमाहेन्‍से परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिसे दोःसीनोन येशूदा “छोन्‍बो परमेश्‍वरला मिनरी घ्रान फासी ङन्‍दा पाङ्‍गो। तिग ए परमेश्‍वरला झा थार्बा पिन्‍बा ख्रीष्‍टनोन हिन्‍ना?” भिसी पाङ्‌मा, ");
INSERT INTO taj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","येशूसे थेदा “थे ताम मी ह्राङसेन सुङ्जी। तसैनोन दाहेन्‍से ह्राङनीसे परमेश्‍वरसे पुइखबा म्‍हिदा शक्तिशाली परमेश्‍वरला दाहिने छ्‌यापट्टि चिबादेन स्‍वर्गग्‍याम खसुरी खबान लबा म्राङ्ला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","जमाहेन्‍से परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिसे ह्राङला क्‍वान ढेबान, “चु म्‍हिसे परमेश्‍वरला बिरोध लसी ताम पाङ्बा मुला। दाहेन्‍से य्‍हाङदा अर्गु प्रमाण तिग्‍दा तोःजी? ह्राङनीसे दान्‍दे चुसे ह्राङसे ह्राङदान परमेश्‍वर स्‍होसी पाङ्बा ताम य्‍हाङसे थेःनोन थेःजी। ");
INSERT INTO taj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","दाहेन्‍से ह्राङनीला तिग बिचार मुला?” भिसी ङ्‌योइमा, स्‍य्‍हान्‍दोगदेसे “चु म्‍हि साइनोन तोःबा म्‍हि हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","जमाहेन्‍से थे म्‍हिगदेसे येशूला लीरी थो स्‍वाबा तोबा ग्‍याङ्‍बा लजी। ओच्‍छे कोइ कोइसे चा तोबान, ");
INSERT INTO taj_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“ए थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍सम, लु, अगमवाणी पाङ्‍गो। एदा खाल्‍से तोबा हिन्‍ना?” भिसी पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","थे धुइरी पत्रुस ख्राङगारी मुबा। थेदा म्राङ्सी नोकरस्‍या गिक थे मुबा ग्‍लारी खसी, “एएनोन गालीलला येशूदेन छ्‌यामनोन मुबा आहिन?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","तर पत्रुससे जम्‍मालान ओन्‍छाङरी “एसे खाल्‍ला ताम लबा, ङादा तिगै था आरे” भिसी, ");
INSERT INTO taj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","थे ख्राङगाला म्रापरी निजी। थेरीनोन थेदा स्‍य्‍हान्‍दो नोकरस्‍या गिकसे म्राङ्सी जम्‍मान म्‍हिगदेदा “चु म्‍हिएनोन नासरतला येशूदेन छ्‌यामनोन मुबा” भिसी पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","दोःसी पत्रुससे घ्रान फाबान, “ङाइ थे म्‍हिदा ङोसेबान आरे” भिसी पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","जजाकी लिच्‍छा थेरी मुबा म्‍हिगदे पत्रुसला ङामरी खसी थेदा “पक्‍कान एएनोन थेनीगदे न्‍हङला गिक हिन्‍ना भिबा एला तामग्‍यामनोन था तजी” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","जमाहेन्‍से पत्रुससे “ङाइ लुसीला ताम पाङ्बा हिन्‍सम परमेश्‍वरला सजाय ङाथोरी खगै भिसी घ्रान फाबान ङाइ थे म्‍हिदा ङोसेबान आरे” भिसी भिजी। थेसे थेह्रङ् भिमैछ्‍याम नागा क्राजी। ");
INSERT INTO taj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","जमाहेन्‍से येशूसे “च्‍यागो, नागा क्राबा भन्‍दा ङाच्‍छा सोमरेमधोना एसे ङादा ङोसेबान आरे भिला” भिसी सुङ्बा ताम पत्रुससे ढन्‍जी। थेतबासेलमा थे मङग्‍यार निसी घ्‍वाँ घ्‍वाँ क्राजी। ");
INSERT INTO taj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","स्‍य्‍होरीन परमेश्‍वरला मन्‍दिररी पूजा लबा जम्‍मान मुल म्‍हिगदेदेन यहूदी गन्‍बागदेसे येशूदा साइनोन तोःला भिसी सल्‍लाह लजी। ");
INSERT INTO taj_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","जमाहेन्‍से थेनीगदेसे येशूदा खीसी पिलातस भिबा रोमी अञ्‍चलाधीश मुबा ग्‍लारी भोर्सी जिम्‍मा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","येशूदा साइनोन तोःला भिसी पाङ्बा ताम येशूदा चुङ्सी पिन्‍बा यहूदासे थेःजी। जमाहेन्‍से थेदा ल्‍हानान दुख ङ्‍हम्‍सी थेसे किन्‍बा बोगल गिकसे च्‍युइ म्‍हुइला डबल परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी गन्‍बागदेदा दोःसी पिन्‍बारी खजी। ");
INSERT INTO taj_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ओच्‍छे यहूदासे थेनीगदेदा “तिगै दोष आरेबा म्‍हिदा साइबाला लागिरी चुङ्सी पिन्‍सी ङाइ पाप गे लबा मुला” भिसी भिमा, थेनीगदेसे यहूदादा “ङन्‍दा तिग मतलब? एनोन सेला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","जमाहेन्‍से यहूदासे थे म्‍हुइला डबल परमेश्‍वरला मन्‍दिररीन भ्‍याङ्‍सी निजी, ओच्‍छे थे च्‍योसी सिजी। ");
INSERT INTO taj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","तर परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेसे चा थे डबल दुइसी “चु डबल परमेश्‍वरला मन्‍दिरला ढुकुटीरी थान्‍बा ठीक आत। तिग्‍दा भिसम चु काला सय हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","थेतबासेलमा थेनीगदे ह्राङ ह्राङ न्‍हङ‍री सल्‍लाह लसी थे टाङगासे अर्गु य्‍हुल्‍साला सिबा म्‍हि ल्‍हुबारी कुमालेला वारी ग्‍लुजी। ");
INSERT INTO taj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","थेतबासेलमा दान्‍देधोनाएनोन थे वारीदा काला वारी भिसी भिमुला। ");
INSERT INTO taj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","यर्मिया अगमवक्तासे पाङ्बा ताम चुह्रङ् लसी पूरा तजी, “थे म्‍हुइला बोगल गिकसे च्‍युइ डबल परमेश्‍वरला मन्‍दिररी पूजा लबा म्‍हिगदेसे किन्‍जी। थे डबल चा थेला सय हिन्‍ना भिसी इस्राएलला म्‍हिगदेसे तोगब लबा मुबा। ");
INSERT INTO taj_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","जमाहेन्‍से परमेश्‍वरसे ङादा कुल्‍बा अन्‍छार थेनीगदेसे थेनोन टाङगासे कुमालेला बु ग्‍लुजी।” ");
INSERT INTO taj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","येशू अञ्‍चलाधीशला ङाच्‍छापट्टि राप्‍माहेन्‍से अञ्‍चलाधीशसे “तिग ए यहूदीगदेला ग्‍ले हिन्‍ना?” भिसी ङ्‌योइमा, येशूसे थेदा “थे मी ह्राङसेन सुङ्बा मुला” भिसी जोहाब पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी गन्‍बागदेसे येशूदा ल्‍हानान दोष लजी। तसैनोन येशूसे तिगै जोहाब आलनी। ");
INSERT INTO taj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","जमाहेन्‍से पिलातस भिबा अञ्‍चलाधीशसे येशूदा “थेनीगदेसे एला बिरोध लसी एदा ल्‍हानान दोष लबान मुला, तिग एसे थेःबा आरे?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","तर येशूसे थेदा ताम गिकलान जोहाब आपिन्‍नी। थेतबासेलमा अञ्‍चलाधीशएनोन उदेक तजी। ");
INSERT INTO taj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","अञ्‍चलाधीशसे मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाडला धुइरी म्‍हिला हुलसे धम्‍बा झ्‍याल्‍खानरी मुबा म्‍हि गिकदा पुइमुबा। ");
INSERT INTO taj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","थे धुइरी जम्‍मान म्‍हिसे ङोसेबा बारब्‍बा भिबा आज्‍यबा गे लबा म्‍हि गिक झ्‍याल्‍खानरी मुबा। ");
INSERT INTO taj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","थेरी म्‍हिगदे पोप तमाहेन्‍से पिलातससे थेनीगदेदा “ङाइ खाल्‍दा पुइगै भिबा एनीगदेला सेम मुला? बारब्‍बादा पुइगो कि थार्बा पिन्‍बा ख्रीष्‍ट भिबा येशूदा पुइगो?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","तिग्‍दा भिसम थेनीगदेसे येशूला डाह लसी ह्राङ मुबा ग्‍लारी भबा हिन्‍ना भिबा ताम पिलातसदा था मुबा। ");
INSERT INTO taj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","पिलातस निसाफ लबा ग्‍लारीन मुबा धुइरी पिलातसला म्रिङसे “थे तिगै दोष आरेबा म्‍हिदा तिगै थालउ। तिग्‍दा भिसम तिनी म्‍हुनङ ङाइ थेला बारेरी म्‍हङ म्राङ्सी ङादा ल्‍हानान दुख तबा मुला” भिसी खबर पुइजी। ");
INSERT INTO taj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","तर परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी गन्‍बागदेसे थेरी मुबा म्‍हिला हुलदा “‘बारब्‍बादा ख्‍लासी पिन्‍गो। ओच्‍छे येशूदा चा साइगो’ भिउ” भिसी पाङ्‌पुङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","थेतबासेलमा दोःसी अञ्‍चलाधीशसे थेनीगदेदा “ङाइ चु न्‍ही न्‍हङ‍री खजिबादा पुइगै भिबा एनीगदेला सेम मुला?” भिसी ङ्‌योइमा, थेनीगदेसे “बारब्‍बादा पुइगो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","जमाहेन्‍से पिलातससे थेनीगदेदा “थेह्रङ् भिसम थार्बा पिन्‍बा ख्रीष्‍ट भिबा येशूदा ङाइ तिग लउ?” भिसी ङ्‌योइमा, थेनीगदे जम्‍मासेन “चुदा क्रुसरी टाँगब लसी साइगो!” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","पिलातससे “तिग्‍दा? चुसे थेह्रङ्बा आज्‍यबा गे तिग लबा मुला?” भिसी ङ्‌योइजी। तर थेनीगदेसे झन क्रिङ्बान, “चुदा क्रुसरी टाँगब लसी साइगो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","तिगै लसीन आखम्‍बा म्राङ्सी दाहेन्‍से झन हल्‍ली खल्‍ली तला भिसी पिलातस लोङ्जी। ओच्‍छे थेसे जम्‍मान म्‍हिला ङाच्‍छा या ख्रुसी “चु म्‍हिदा साइबासे लमा ङाइ तिगै सजाय नाआतोःगै, थे सजाय एनीगदेसेन नागो” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","थेरी मुबा जम्‍मान म्‍हिगदेसे “चुदा साइबाला सजाय ङन्‍देन ङन्‍ना सन्‍तानसेन नाला” भिसी जोहाब पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","जमाहेन्‍से पिलातससे बारब्‍बादा पुइजी। तर येशूदा चा कोर्रासे तोसी क्रुसरी टाँगब लसी साइबाला लागिरी रोमी सिपाहीगदेदा जिम्‍मा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","जमाहेन्‍से येशूदा सिपाहीगदेसे अञ्‍चलाधीश चिबा दिमरी भोर्जी। ओच्‍छे जम्‍मान सिपाहीगदे येशूला क्‍युर्सीन पोप तजी। ");
INSERT INTO taj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","जमाहेन्‍से येशूला क्‍वान स्‍युसी वाला क्‍वान क्‍वान्‍सी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","थेनीगदेसे पुजुला फेटा स्‍होसी येशूदा थोइसी पिन्‍जी। ओच्‍छे येशूदा दाहिने छ्‌यारी माला कडी पिन्‍सी “लास्‍सो यहूदीगदेला ग्‍ले, फ्‍याफुल्‍ला” भिसी फ्‍या लबा स्‍होसी येशूदा खिसी लजी। ");
INSERT INTO taj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ओच्‍छे थेनीगदेसे येशूदा थो स्‍वाबान थे माला कडीसे थोबोरी तोजी। ");
INSERT INTO taj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","थेह्रङ् लसी खिसी लमाहेन्‍से थेनीगदेसे थे क्‍वान स्‍युसी पिन्‍जी। ओच्‍छे येशूदा थेलान क्‍वान क्‍वान्‍सी क्रुसरी टाँगब लसी साइबारी भोर्जी। ");
INSERT INTO taj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ग्‍यामरी निबान लमा थेनीगदेसे कुरेनी भिबा ग्‍लाला सिमोनदा खबान लबा स्‍याप्‍जी। जमाहेन्‍से थेनीगदेसे थे म्‍हिदा कर लसी येशूला क्रुस पुइपुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ओच्‍छे थेनीगदे गलगथा भिबा ग्‍लारी धोखजी। गलगथा भिबा चा “खप्‍परला ग्‍ला” हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","थेरी धोखमाहेन्‍से थेनीगदेसे येशूदा अङगुरला निङगुरी कम्‍बा मान युसी पिन्‍जी। तर येशूसे थे निङगु म्‍य्‍हाङ्माहेन्‍से आसोल्‍नी। ");
INSERT INTO taj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","थेनीगदेसे येशूदा क्रुसरी टाँगब लमाहेन्‍से चिट्ठा युसी ह्राङ ह्राङ न्‍हङरी येशूला क्‍वान भो लजी। ");
INSERT INTO taj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","जमाहेन्‍से थेनीगदे थेरीन चिसी येशूदा ख्रुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ओच्‍छे थेनीगदेसे “येशू यहूदीगदेला ग्‍ले” भिसी दोष उन्‍बा ताम भ्रिसी येशूला थोबोथोरी क्रुसरी थान्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","थेनीगदेसे येशूदा क्रुसरी टाँगब लबा धुइरी य्‍हो न्‍हीदाएनोन गिकदा दाहिनेपट्टि गिकदा देब्रेपट्टि क्रुसरी टाँगब लजी। ");
INSERT INTO taj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","थे ग्‍याम निबा खबा म्‍हिगदेसेनोन ह्राङ ह्राङला थोबो य्‍होङ्बान येशूदा खिसी लबान, ");
INSERT INTO taj_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“लु, परमेश्‍वरला मन्‍दिर फुप्‍सी दोःसी सोमरेरीन स्‍होला भिबा म्‍हि दान्‍दे एसे ह्राङसे ह्राङदान जोगब लउ। ए परमेश्‍वरलान झा हिन्‍सम क्रुसग्‍याम मार फाप्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","जमाहेन्‍से परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदे, यहूदी धर्मगुरुदेन यहूदी गन्‍बागदेसेनोन येशूदा खिसी लबान चुह्रङ् भिसी भिजी, ");
INSERT INTO taj_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“चुसे स्‍य्‍हान्‍दो म्‍हिदा चा जोगब लजी, तर ह्राङसे ह्राङदान चा जोगब लबारी आखम्‍नी। चु इस्राएलीगदेला ग्‍ले आहिन! थे दान्‍देन क्रुसग्‍याम मार फाप्‍सी खगै। जमाहेन्‍से ङन्‍से थेदा विश्‍वास लला। ");
INSERT INTO taj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","चुसे परमेश्‍वरदा विश्‍वास लमुबा। ओच्‍छे ‘ङा परमेश्‍वरलान झा हिन्‍ना’ भिसी भिमुबा। चुदे परमेश्‍वर चुदा म्राङ्सी ताङ्‍बा मुसम परमेश्‍वरसेन चुदा जोगब लगै।” ");
INSERT INTO taj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","थेह्रङ् लसीन येशूदेन छ्‌यामनोन क्रुसरी टाँगब लबा य्‍होगदेसेनोन येशूदा खिसी लजी। ");
INSERT INTO taj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","जमाहेन्‍से धिनना बाह्र बजेहेन्‍से तीन बजेधोना य्‍हुल्‍सा नाङनोन धोपधोप तजी। ");
INSERT INTO taj_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ओच्‍छे तीन बजेरीक्‍यार येशूसे घ्रेन काइरी क्रिङ्बान, “इलोइ इलोइ लामा सबखथनी?” भिसी सुङ्जी। चुह्रङ् भिबा चा “ङाला परमेश्‍वर, ङाला परमेश्‍वर ह्राङसे ङादा तिग्‍दा ख्‍लाबा?” भिबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","येशूला ताम थेःसी थेरी राप्‍सी चिबागदे न्‍हङला कोइ कोइसे चा “चुसे मी एलियादा गा ङ्‌योइबा चीम” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","जमाहेन्‍से थेनीगदे न्‍हङला गिक चा तुरुन्‍तन यार्बान निसी अङगुरला कम्‍बा निङगुरी क्‍वानगेन ब्‍लुम्‍सी माला कडीरी खीसी येशूदा ख्‍वाजी। ");
INSERT INTO taj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","तर स्‍य्‍हान्‍दोगदेसे चा “भ्रान्‍गो, भ्रान्‍गो, चुदा एलिया खसी जोगब लला वा? च्‍यागे” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","दोःसी येशू घ्रेन काइरी क्रिङ्‌जी, जमाहेन्‍से येशूला सा निजी। ");
INSERT INTO taj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","थेनोन धुइरी परमेश्‍वरला मन्‍दिररी मुबा पर्दा तोरहेन्‍से मारधोना ह्राङनोन ढेसी पख्‍ले न्‍ही तजी। ओच्‍छे जम्‍बुलिङनोन याङयोङ तसी पहरागदे फुप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","जमाहेन्‍से धुर्सागदे ठोङ्‌जी, ओच्‍छे परमेश्‍वरला ल्‍हानान म्‍हिगदेदा सिबाग्‍याम सोना लजी। ");
INSERT INTO taj_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","येशू सिबाग्‍याम सोना लमाहेन्‍से थेनीगदे धुर्साग्‍याम थोन्‍सी परमेश्‍वरला शहर यरूशलेमरी निजी। थेनीगदेदा थेरी ल्‍हानान म्‍हिगदेसे म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","सङगुल खबादेन थेरी तबा जम्‍मान ताम म्राङ्सी येशूदा ख्रुङ्‌सी चिबा रोमी सिपाहीगदेदेन कप्‍तान ल्‍हानान लोङ्सी “पक्‍कान चु मी परमेश्‍वरला झानोन चीम” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","थेरी येशूदा गालीलहेन्‍सेन ह्रो लबान येशूदेन छ्‌याम छ्‌यामनोन खबा ल्‍हानान म्रिङम्‍हेमेगदेसेनोन थारेङग्‍यामसेन च्‍यासी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","थेनीगदे न्‍हङ‍री मरियम मग्‍दलिनी, याकूबदेन योसेफला आमा मरियमदेन जब्‍दियाला म्रिङएनोन मुबा। ");
INSERT INTO taj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ङ्‍यसे तमाहेन्‍से अरिमाथिया भिबा शहरला योसेफ भिबा फ्‍युक्‍पो म्‍हि गिक पिलातस मुबा ग्‍लारी निजी। थेएनोन येशूला चेला मुबा। ");
INSERT INTO taj_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","पिलातस मुबा ग्‍लारी धोमाहेन्‍से थेसे येशूला लास ह्रीजी। जमाहेन्‍से पिलातससे थेदा येशूला लास भोर्पुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","जमाहेन्‍से योसेफसे मलमलला सफा छार क्‍वानरी येशूला लास रिल्‍सी, ");
INSERT INTO taj_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","थेसे ह्राङलान लागिरी पहरारी ठ्वाइसी स्‍होबा छार धुर्सारी थान्‍जी। ओच्‍छे धुर्साला म्रापरी घ्रेन युङबा ब्‍लिङ्बान भसी थान्‍सी थे निजी। ");
INSERT INTO taj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","थे धुर्साला ङाच्‍छापट्टि मरियम मग्‍दलिनीदेन अर्गु मरियमएनोन चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","न्‍हङगरदङसे ब्‍लप्‍बा न्‍हबा धिनकुनु परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन फरिसीगदे पिलातस मुबा ग्‍लारी निजी। ");
INSERT INTO taj_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ओच्‍छे थेनीगदेसे चुह्रङ् भिसी भिजी, “थे ठगसे सोबा धुइरी ‘ङादा सिबाग्‍याम सोमरेमाकुनु सोना लला’ भिसी भ्रबा ताम ङन्‍दा था मुला। ");
INSERT INTO taj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","थेतबासेलमा सोमरेमाधोना सिपाहीगदेदा धुर्सा ख्रुङ्पुङ्‍गो। आहिन्‍सम थेला चेलागदे खसी थेला लास य्‍हो लसी भोर्ला। ओच्‍छे ‘येशूदा सिबाग्‍याम सोना लजी’ भिसी म्‍हिगदेदा ङाच्‍छाला भन्‍दा झन झुक्‍याब लसी भ्रला।” ");
INSERT INTO taj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","लु, थेह्रङ् भिसम “सिपाहीगदे भोर्सी ज्‍यना लसी धुर्सा ख्रुङ्पुङ्‍गो” भिसी पिलातससे थेनीगदेदा भिजी। ");
INSERT INTO taj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","जमाहेन्‍से थेनीगदे धुर्सारी निसी धुर्साला म्रापरी थान्‍बा युङबारी लाहा छाप लसी सिपाहीगदेदा ख्रुङ्पुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ब्‍लप्‍बा न्‍हबा धिनना न्‍हङगरदङ स्‍य्‍होरीन मरियम मग्‍दलिनीदेन स्‍य्‍हान्‍दो मरियम भिबा म्रिङम्‍हेमे न्‍ही येशूदा थान्‍बा धुर्सा च्‍याबारी निजी। ");
INSERT INTO taj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","थेनोन धुइरी सङगुल खजी। तिग्‍दा भिसम स्‍वर्गग्‍याम परमप्रभुला दूत गिक मार फाप्‍सी धुर्साला म्रापरी थान्‍बा युङबा ब्‍लिङ्सी थेनोन युङबाथोरी चिजी। ");
INSERT INTO taj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","थे स्‍वर्गदूतला ली धिनीला स्‍हेर ह्रङ्‌बान य्‍हाल य्‍हाल्‍बा मुबा। ओच्‍छे थेला क्‍वान ग्‍लिङ तेबान तार मुबा। ");
INSERT INTO taj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","थेदा म्राङ्सी धुर्सा ख्रुङ्‌सी चिबा सिपाहीगदे लोङ्सी फितफित धर्सी सिबा तेबान तजी। ");
INSERT INTO taj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","तर स्‍वर्गदूतसे थे म्रिङम्‍हेमेगदेदा चुह्रङ् भिसी भिजी, “एनीगदे थालोङ्‍गो, तिग्‍दा भिसम क्रुसरी टाँगब लसी साइबा येशूदा एनीगदेसे म्‍हाइबान मुला भिबा ताम ङादा था मुला। ");
INSERT INTO taj_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","येशू चुरी आरे, थेसे सुङ्बा ह्रङ्नोन थेदा सिबाग्‍याम सोना लसी जिन्‍बा मुला। एनीगदेन खसी थेदा थान्‍बा ग्‍ला च्‍यागो। ");
INSERT INTO taj_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","दाहेन्‍से एनीगदे योना निसी थेला चेलागदेदा ‘येशूदा सिबाग्‍याम सोना लसी जिन्‍बा मुला। ओच्‍छे येशू एनीगदे भन्‍दा ङाच्‍छा गालील अञ्‍चलरी फेप्‍बान मुला। एनीगदेसे येशूदा थेरीन म्राङ्ला’ भिसी पाङ्सी पिन्‍गो।” ");
INSERT INTO taj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","चुह्रङ् तबा म्राङ्सी थे म्रिङम्‍हेमेगदे लोङ्जी। तसैनोन स्‍वर्गदूतला ताम थेःसी थेनीगदे ल्‍हानान ताङ्सी येशूला चेलागदेदा थे ताम पाङ्‌बारी धुर्साग्‍याम थोन्‍सी यार्बान निजी। ");
INSERT INTO taj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","थे म्रिङम्‍हेमेगदे ग्‍यामरी निबान लमा तिक्‍खुरीन येशूसे स्‍याप्‍सी “एनीगदेदा शान्‍ति तगै” भिसी सुङ्माहेन्‍से थेनीगदेसे येशूला स्‍य्‍हाप चुङ्सी फ्‍या लजी। ");
INSERT INTO taj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","जमाहेन्‍से येशूसे थेनीगदेदा “एनीगदे थालोङ्‍गो, ङाला आलेगदे मुबा ग्‍लारी निसी थेनीगदेदा गालील अञ्‍चलरी निउ भिउ, थेनीगदेसे ङादा थेरीन स्‍याप्‍ला भिसी पाङ्सी पिन्‍गो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","थे म्रिङम्‍हेमेगदे धुर्साग्‍याम निमाहेन्‍से धुर्सा ख्रुङ्‌सी चिबा सिपाहीगदे न्‍हङला कोइ कोइ सिपाहीगदे शहररी निसी परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदा थे धुर्सारी तिग तिग तबा मुबा, थे ताम पाङ्सी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","जमाहेन्‍से पूजा लबा मुल म्‍हिगदेदेन यहूदी गन्‍बागदे ह्रुप तसी थेनीगदे न्‍हङ‍री सल्‍लाह लसी सिपाहीगदेदा ल्‍हानान टाङगा पिन्‍सी चुह्रङ् भिसी भिजी, ");
INSERT INTO taj_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“एनीगदेसे ‘ङनी म्‍हुनङ म्‍हेर्बा धुइरी थेला चेलागदे खसी थेला लास य्‍हो लसी भोर्जीम’ भिसी पाङ्‍गो। ");
INSERT INTO taj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","तिगै लसी चु ताम अञ्‍चलाधीशसे था याङ्जी भिसै ङन्‍से थेदा ताङ्ना लसी एनीगदेदा तिगै लआपुङ्।” ");
INSERT INTO taj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","जमाहेन्‍से सिपाहीगदेसे थे टाङगा किन्‍जी, ओच्‍छे थेनीगदेदा लोप्‍बा अन्‍छारनोन म्‍हिगदेदा पाङ्जी। दान्‍देधोनाएनोन यहूदीगदेला गुङरी चुनोन ताम लसी चिमुला। ");
INSERT INTO taj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","येशूसे ह्राङला च्‍युक गिक चेलागदेदा “गालील अञ्‍चलला गङरी निउ” भिसी कुल्‍बासे लमा थेनीगदे थेरी निजी। ");
INSERT INTO taj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","थेरी थेनीगदेसे येशूदा म्राङ्सी फ्‍या लजी। तर थेनीगदे न्‍हङला कोइ कोइसे चा येशू हिन्‍ना कि आहिन भिसी शङ्का लजी। ");
INSERT INTO taj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","जमाहेन्‍से येशू थेनीगदे मुबा ग्‍लारी फेप्‍खसी चुह्रङ् भिसी सुङ्जी, “च्‍यागो, परमेश्‍वरसे स्‍वर्गदेन जम्‍बुलिङला जम्‍मान अधिकार ङादा पिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","थेतबासेलमा एनीगदे य्‍हुल्‍सा य्‍हुल्‍सारी निसी जम्‍मान य्‍हुलला म्‍हिगदेदा ङाला चेला स्‍होउ। ओच्‍छे थेनीगदेदा परमेश्‍वर आबा, परमेश्‍वरला झादेन परमेश्‍वरला आत्‍माला मिनरी बप्‍तिस्‍मा पिन्‍गो, ");
INSERT INTO taj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ओच्‍छे ङाइ एनीगदेदा लोप्‍बादेन कुल्‍बा जम्‍मान ताम थेनीगदेदाएनोन लउ भिसी लोप्‍गो। च्‍यागो, परमेश्‍वरसे जम्‍बुलिङला जम्‍मान म्‍हिगदेला निसाफ लबा धिनधोनाएनोन ङा एनीगदेदेन छ्‌यामनोन तला।”");
INSERT INTO taj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","परमेश्‍वरला झा येशू ख्रीष्‍टला बारेला थार्बा पिन्‍बा समाचार चुह्रङ् लसी शुरु तजी। ");
INSERT INTO taj_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","यशैया भिबा अगमवक्ताला किताबरी परमेश्‍वरसे चुह्रङ् भिसी सुङ्बा मुला, “च्‍यागो, ङाइ ङाला समाचार भोर्बा म्‍हिदा एला ङाच्‍छा ङाच्‍छा पुइखला। थेसे एला ग्‍याम स्‍होला। ");
INSERT INTO taj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","तोङतोङबा ग्‍लारीक्‍यार म्‍हि गिक क्रिङ्बान, ‘परमप्रभुला ग्‍याम तयार लउ, ओच्‍छे परमप्रभु भ्रबाला लागिरी थेला ग्‍याम सोजो स्‍होउ।” ");
INSERT INTO taj_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","चु म्‍हि बप्‍तिस्‍मा पिन्‍बा यूहन्‍ना हिन्‍ना। थेसे तोङतोङबा ग्‍लारीक्‍यार खसी म्‍हिगदेदा “दाहेन्‍से एनीगदे ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःसी बप्‍तिस्‍मा किन्‍गो। परमेश्‍वरसे एनीगदेला पापला दोष मेटब लला।” भिबान थार्बा पिन्‍बा समाचार थेःना लजी। ");
INSERT INTO taj_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","यरूशलेमदेन यहूदिया य्‍हुल्‍साला जम्‍मान म्‍हिगदे यूहन्‍ना मुबा ग्‍लारी खसी, दाहेन्‍से ङनी ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःला भिसी यर्दन स्‍योङरी यूहन्‍नाग्‍याम बप्‍तिस्‍मा किन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","यूहन्‍नासे ऊँटला क्राला क्‍वान क्‍वान्‍मुबा ओच्‍छे ढिला पेटी खीमुबा। थेसे तिरीदेन ह्रि सिङसोरला खुदु चमुबा। ");
INSERT INTO taj_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","थेसे म्‍हिगदेदा चुह्रङ् भिसी पाङ्जी, “ङा भन्‍दा लिच्‍छा फेप्‍खबान लबा चा ङा भन्‍दान शक्तिशाली मुला। ङा कू तसी थेला लखमला तुना ब्‍लबाधोनाला आरे। ");
INSERT INTO taj_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ङाइ एनीगदेदा क्‍युइग्‍याम बप्‍तिस्‍मा पिन्‍बा मुला, तर थेसे एनीगदेदा परमेश्‍वरला आत्‍मासे बप्‍तिस्‍मा पिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","थेनोन धुइरी येशू गालील अञ्‍चलला नासरत नाम्‍साग्‍याम फेप्‍खजी, ओच्‍छे यर्दन स्‍योङरी यूहन्‍नाग्‍याम बप्‍तिस्‍मा किन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","यूहन्‍नाग्‍याम बप्‍तिस्‍मा किन्‍सी क्‍युइग्‍याम थोन्‍मैछ्‌याम येशूसे स्‍वर्ग ठोङ्‌बा म्राङ्जी ओच्‍छे परमेश्‍वरला आत्‍मा ढुकुर ह्रङ् लसी ह्राङथोरी फाप्‍खबान लबा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ओच्‍छे स्‍वर्गग्‍याम “ए ङाइ सेमहेन्‍से माया लबा ङाला झा हिन्‍ना, थेतबासेलमा ङा एदा म्राङ्सी ल्‍हानान ताङ्‍बा मुला” भिबा काइ खजी। ");
INSERT INTO taj_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","जमाहेन्‍से परमेश्‍वरला आत्‍मासे येशूदा तोङतोङबा ग्‍लारी भोर्जी। ");
INSERT INTO taj_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","येशू बोगल न्‍ही धिनधोना थेरीन धन्‍छ्‌याजी। थेनोन धुइरी शैतानसे थेदा फसब लबारी थेला सेम च्‍याजी। थे ह्रीला जन्‍तुगदेदेन छ्‌याम मुबा ओच्‍छे स्‍वर्गदूतगदेसे थेदा क्‍योङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","बप्‍तिस्‍मा पिन्‍बा यूहन्‍नादा झ्‍याल्‍खानरी थान्‍माहेन्‍से येशूसे परमेश्‍वरला य्‍हुल्‍साला समाचार थेःना लबान गालील अञ्‍चलरी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“दाहेन्‍से धुइ योसी जिन्‍बा मुला, ओच्‍छे परमेश्‍वरला य्‍हुल्‍सा खबा धुइ तसी जिन्‍बा मुला। थेतबासेलमा एनीगदे ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःगो। ओच्‍छे थार्बा पिन्‍बा समाचाररी विश्‍वास लउ” भिसी येशूसे सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","येशू गालील समुन्‍द्रला कुनीन कुनी फेप्‍बान लमा थेसे सिमोनदेन थेला आले अन्‍द्रियासदा तार्ङा साइबारी समुन्‍द्ररी घ्‍याङ क्‍लाङ्बान लबा म्राङ्जी। तिग्‍दा भिसम थेनीगदे तार्ङा साइबा म्‍हिगदे मुबा। ");
INSERT INTO taj_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","येशूसे थेनीगदेदा “ङादेन छ्‌याम भ्रउ, दाहेन्‍से ङाइ एनीगदेदा तार्ङा चुङ्बा म्‍हि आहिन, तर म्‍हिगदेदा परमेश्‍वर मुबा ग्‍लारी भबा म्‍हि स्‍होला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","येशूसे थेह्रङ् सुङ्मैछ्‌याम ह्राङला घ्‍याङ ख्‍लासी थेनीगदे येशूदेन छ्‌याम भ्रजी। ");
INSERT INTO taj_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","जजाकी क्‍याथाङ धोमाहेन्‍से येशूसे जब्‍दियाला झा न्‍ही, याकूबदेन थेला आले यूहन्‍नादा दोँगारी चिसी घ्‍याङ राबान लबा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","येशूसे थेनीगदेदा म्राङ्मैछ्‍याम “ङादेन छ्‌याम खउ” भिसी ङ्‌योइजी, ओच्‍छे थेनीगदेसे ह्राङला आबा जब्‍दियादा दोँगारी मुबा कुल्‍लीगदेदेन छ्‌याम ख्‍लासी येशूदेन छ्‌याम भ्रजी। ");
INSERT INTO taj_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","जमाहेन्‍से थेनीगदे कफर्नहुम भिबा शहररी फेप्‍जी। ओच्‍छे ब्‍लप्‍बा न्‍हबा धिनकुनु येशू यहूदीगदे ह्रुप तबा दिमरी फेप्‍सी परमेश्‍वरला बचनग्‍याम लोप्‍बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","येशूसे लोप्‍बा म्राङ्सी म्‍हिगदे उदेक तजी। तिग्‍दा भिसम येशूसे यहूदी धर्मगुरुगदेसे लोप्‍बा ह्रङ् लसी आहिन, तर अधिकार मुबा म्‍हिसे ह्रङ् लसी लोप्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","थेनोन धुइरी यहूदीगदे ह्रुप तबा दिम न्‍हङ‍ग्‍याम म्‍हङसे स्‍याप्‍बा म्‍हि गिक चुह्रङ् भिबान क्रिङ्‌जी, ");
INSERT INTO taj_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“नासरतला येशू, ह्राङसे ङन्‍दा तिग लबारी म्‍हाइबा? तिग ह्राङ ङन्‍दा साइबारी फेप्‍खबा हिन्‍ना? ह्राङ परमेश्‍वरसे पुइखबा परमेश्‍वरला म्‍हि भिसी ङादा था मुला।” ");
INSERT INTO taj_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","येशूसे थे म्‍हङदा बङ्‌सी, “कुटिसी चिउ! थे म्‍हिग्‍याम थोन्‍सी निउ!” भिसी ");
INSERT INTO taj_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","सुङ्मैछ्‌याम थे म्‍हिदा लछार पछार लसी क्रिङ्बान थे म्‍हिग्‍याम म्‍हङ थोन्‍सी निजी। ");
INSERT INTO taj_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","चु म्राङ्सी थेरी मुबा जम्‍मान म्‍हिगदे उदेक म्‍हन्‍जी। ओच्‍छे ह्राङ ह्राङ न्‍हङरी चुह्रङ् भिबारी छ्‌याइजी, “आहिन, चु तिग? चु मी अधिकार लसी लोप्‍बा छार ताम गा चीम। थेसे कुल्‍बा ताम म्‍हङगदेसेएनोन ङ्‌यान्‍बा चीम।” ");
INSERT INTO taj_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","चुह्रङ् तमैछ्‌याम येशूसे लबा उदेकला गेला बारेरी गालील अञ्‍चलला जम्‍मान ग्‍लारी थेःजी। ");
INSERT INTO taj_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ओच्‍छे येशू यहूदीगदे ह्रुप तबा दिमग्‍याम थोन्‍सी याकूब, यूहन्‍नादेन छ्‌याम सिमोनदेन अन्‍द्रियासला दिमरी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","थे धुइरी सिमोनना स्‍युमी छवा खसी म्‍हेर्सी चिबा मुबा। ओच्‍छे थेनीगदेसे थे ताम येशूदा पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","थेतबासेलमा येशू सिमोनना स्‍युमी मुबा ग्‍लारी फेप्‍सी थेला यारी चुङ्सी थीजी। जमाहेन्‍से थेला छवा म्‍हाजी। ओच्‍छे थेसे थेनीगदेदा क्‍योङ्बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","जमाकुनु ङ्‍यसे धिनी घल्‍माहेन्‍से म्‍हिगदेसे ल्‍हानान आखम्‍बा म्‍हिदेन म्‍हङसे स्‍याप्‍बा म्‍हिगदेदा येशू मुबा ग्‍लारी भजी। ");
INSERT INTO taj_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ओच्‍छे नाम्‍साला जम्‍मान म्‍हिगदे दिमला ख्राङगारी ह्रुप तजी। ");
INSERT INTO taj_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","येशूसे ल्‍हानान खाल्‍ला रोगसे आखम्‍बा म्‍हिगदेदा खम्‍ना लजी। ओच्‍छे ल्‍हानान म्‍हिला ल्‍हुइग्‍याम म्‍हङ ताप्‍जी। येशू खाल भिबा ताम थे म्‍हङगदेसे ङोसेबासे लमा येशूसे थेनीगदेदा ताम पाङ्आपुङ्नी। ");
INSERT INTO taj_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","स्‍य्‍होरीन मी म्राङ्बा भन्‍दा ङाच्‍छान येशू स्‍हेङ्‌सी सुनसान ग्‍लारी प्रार्थना लबारी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","सिमोन ओच्‍छे थेदेन छ्‌याम मुबागदे जम्‍मासेन येशूदा म्‍हाइबान निजी। ");
INSERT INTO taj_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","थेनीगदेसे येशूदा स्‍याप्‍माहेन्‍से “ह्राङदा जम्‍मासेन म्‍हाइबान मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","येशूसे थेनीगदेदा “लु, य्‍हाङ अर्गु नाम्‍सारीक्‍यार निइ, थेरीनोन ङाइ थार्बा पिन्‍बा समाचार थेःना लतोःबा मुला। तिग्‍दा भिसम ङा चुलान लागिरी खबा हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ओच्‍छे येशू गालील अञ्‍चलला जम्‍मान ग्‍लारी यहूदीगदे ह्रुप तबा दिमगदेरी थार्बा पिन्‍बा समाचार थेःना लबान म्‍हिगदेला ल्‍हुइग्‍याम म्‍हङगदे ताप्‍बान भ्रजी। ");
INSERT INTO taj_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ओच्‍छे कोरे खबा म्‍हि गिक येशू मुबा ग्‍लारी खसी पुइ जूबान, “ह्राङला सेम मुसम ह्राङसे ङादा खम्‍ना लखम्‍ला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","चु ताम थेःमाहेन्‍से येशूदा दया रेःसी ह्राङला यासे थेदा थुर्बान, “ए खम्‍गै भिबा ङाला सेम मुला, ए खम्‍गो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","थेनोन धुइरी थे कोरे खबा म्‍हि खम्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","ओच्‍छे येशूसे थेदा “एसे चु ताम खालैदा थापाङ्‍गो, बरु निसी परमेश्‍वरला मन्‍दिररी पूजा लबा म्‍हिदा उन्‍गो। ओच्‍छे ए खम्‍जी भिसी म्‍हिगदेदा उन्‍बाला लागिरी मोशासे कुल्‍बा अन्‍छार परमेश्‍वरदा बलि फुल्‍गो” भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","तर थे म्‍हि निसी चु ताम जम्‍मान म्‍हिदा पाङ्जी। जमाहेन्‍से येशू दोःसी नाम्‍सारी ङाच्‍छाला ह्रङ् लसी फेप्‍बारी आखम्‍नी। थेतबासेलमा येशू सुनसान ग्‍लारी धन्‍छ्‌याजी। तर थेरीनोन जम्‍मान ग्‍लाग्‍यामसे म्‍हिगदे येशू मुबा ग्‍लारी खजी। ");
INSERT INTO taj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","तिगै धिन लिच्‍छा दोःसी येशू कफर्नहुम भिबा शहररी फेप्‍जी। ओच्‍छे येशू दिमरीन मुला भिबा ताम म्‍हिगदेसे थेःजी। ");
INSERT INTO taj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","जमाहेन्‍से म्‍हिला हुल खसी मङग्‍यारहेन्‍से दिम न्‍हङधोना चिबा ग्‍ला आतनी। थेरी येशूसे परमेश्‍वरला बचन सुङ्बान मुबा। ");
INSERT INTO taj_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","थेनोन धुइरी गोर ब्‍लि म्‍हिसे काङ या चलब आतबा कुज्‍या म्‍हि गिकदा पुइसी येशू मुबा ग्‍लारी भजी। ");
INSERT INTO taj_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","तर म्‍हिला हुलसे लमा थेनीगदेसे थे कुज्‍या म्‍हिदा येशू मुबा ग्‍लारी धोना लबारी आखम्‍नी। थेतबासेलमा थेनीगदेसे थे दिमला छाना होक्‍सी थे कुज्‍या म्‍हिदा थेला तीबा नान्‍बादेन छ्‌यामनोन येशूला ङाच्‍छापट्टि धोना लजी। ");
INSERT INTO taj_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","येशूसे थे म्‍हिगदेला विश्‍वास म्राङ्सी कुज्‍या म्‍हिदा “कोला, एला पाप माफ तबा मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","येशूसे चुह्रङ् सुङ्बा म्राङ्सी थेरी मुबा यहूदी धर्मगुरुगदेसे “तिग्‍दा चु म्‍हिसे चुह्रङ्बा ताम लबा? चुसे मी ह्राङसे ह्राङदान परमेश्‍वर स्‍होसी गा ताम लबा चीम, म्‍हिगदेला पापला दोष परमेश्‍वरसे जे मेटब लखम्‍मुला” भिसी सेम न्‍हङ न्‍हङरी म्‍हन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","येशूसे थेनीगदेला सेमला ताम था याङ्सी थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदेला सेमरी तिग्‍दा चुह्रङ्बा म्‍हन्‍बा?” ");
INSERT INTO taj_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","चु कुज्‍या म्‍हिदा ‘एला पाप माफ तबा मुला’ भिबादेन ‘रेःसी भ्रउ, एला तीबा नान्‍बा पुइसी निउ’ भिबा खजिबा चा सजिलो मुला? ");
INSERT INTO taj_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","तर च्‍यागो, परमेश्‍वरसे पुइखबा म्‍हिदा चु जम्‍बुलिङरी म्‍हिगदेला पापला दोष मेटब लबा अधिकार मुला भिबा ताम ङाइ एनीगदेदा उन्‍ना।” जमाहेन्‍से येशूसे थे कुज्‍या म्‍हिदा “ए रेःगो, ओच्‍छे एला तीबा नान्‍बा पुइसी दिमरी निउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","येशूसे थेह्रङ् सुङ्मैछ्‌याम थे कुज्‍या म्‍हि जम्‍मासेन च्‍याना च्‍यानान डोङ रेःसी ह्राङला तीबा नान्‍बा पुइसी निजी। चु म्राङ्सी म्‍हिगदे उदेक म्‍हन्‍सी परमेश्‍वरदा जयजयकार लबान, “चुह्रङ्बाम य्‍हाङसे खाइमै म्राङ्बा आरे” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","दोःसी तिरेम येशू समुन्‍द्रला कुनीरी फेप्‍जी। थेरी येशूदा म्राङ्सी म्‍हिला हुल खजी ओच्‍छे येशूसे थेनीगदेदा लोप्‍बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","येशू थेग्‍याम फेप्‍बा धुइरी अल्‍फयसला झा लेवीदा तिरो दुइबा ग्‍लारी चिबान लबा म्राङ्जी ओच्‍छे थेदा “ङादेन छ्‌याम भ्रउ” भिसी सुङ्जी। जमाहेन्‍से थे रेःसी येशूदेन छ्‌याम भ्रजी। ");
INSERT INTO taj_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","येशू लेवीला दिमरी सोल छ्‌योइबान लबा धुइरी तिरो दुइबा म्‍हिगदे, पापीगदे ओच्‍छे थेला चेलागदे थेदेन छ्‌यामनोन चिसी चबान मुबा। तिग्‍दा भिसम येशूदेन छ्‌याम भ्रबा म्‍हिगदे ल्‍हानान मुबा। ");
INSERT INTO taj_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","फरिसीदेन यहूदी धर्मगुरुगदेसे येशू पापीगदेदेन तिरो दुइबा म्‍हिगदेदेन छ्‌यामनोन धन्‍छ्‌यासी चबा म्राङ्सी थेनीगदेसे थेला चेलागदेदा “तिग्‍दा चुसे पापीगदेदेन तिरो दुइबा म्‍हिगदेदेन छ्‌याम चिसी चबा?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","चुह्रङ् भिबा ताम थेःसी येशूसे थेनीगदेदा “खम्‍बा म्‍हिगदेला लागिरी डाक्‍टर आतोः, तर आखम्‍बा म्‍हिगदेला लागिरी जे तोःला। थेतबासेलमा परमेश्‍वरला ङाच्‍छा ज्‍यबा मुबा म्‍हिगदेदा आहिन तर पापीगदेदा ङ्‌योइबारी ङा खबा हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","यूहन्‍नाला चेलागदेदेन फरिसीगदे फोइथान चिसी प्रार्थना लबान लमुबा। थेतबासेलमा कोइ कोइ म्‍हिगदे खसी येशूदा “यूहन्‍नाला चेलागदेदेन फरिसीला चेलागदे फोइथान चिसी प्रार्थना लमुला तर ह्राङला चेलागदेसे चा तिग्‍दा चुह्रङ् आलबा?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “म्‍हाछार जन्‍तीगदेदेन छ्‌याम मुतेधोना खाह्रङ् लसी थेनीगदे फोइथान चिला? दान्‍देधोना म्‍हाछार थेनीगदेदेन छ्‌याम मुला, थेतबासेलमा थेनीगदे फोइथान आचि। ");
INSERT INTO taj_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","तर म्‍हाछार जन्‍तीगदेग्‍याम फेसी भोर्बा धुइ खला। थे धुइरी थेनीगदे फोइथान चिला। ");
INSERT INTO taj_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“खालैसे बोक्‍टो क्‍वानरी छार क्‍वानगेनसे आख्‍या, छार क्‍वानगेनसे बोक्‍टो क्‍वान ख्‍याजी भिसम बोक्‍टो क्‍वान झन ढेला। ");
INSERT INTO taj_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ओच्‍छे खालै म्‍हिसेनोन ढिला बोक्‍टो ताङरी अङगुरला कलिलो निङगु आयु, युजी भिसम थे ढिला बोक्‍टो ताङ भोसी ढेला, ओच्‍छे अङगुरला निङगु जति ङेला। जमाहेन्‍से ढिला ताङएनोन गे आखेल्‍बा तला। थेतबासेलमा अङगुरला कलिलो निङगु ढिला छार ताङरी युतोःला।” ");
INSERT INTO taj_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ब्‍लप्‍बा न्‍हबा धिनकुनु येशू बुग्‍याम फेप्‍बान मुबा। थे धुइरी थेला चेलागदेसे ग्‍वाला नम थुबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","चु म्राङ्सी फरिसीगदेसे येशूदा “च्‍यागो, ब्‍लप्‍बा न्‍हबा धिनकुनु लबारी आतबा गे थेनीगदेसे तिग्‍दा लबा?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ओच्‍छे येशूसे थेनीगदेदा “दाऊदसे थेदेन छ्‌याम मुबा म्‍हिगदे फोख्रेन्‍बा धुइरी थेनीगदेसे तिग लजी? एनीगदेसे खाइमै परमेश्‍वरला बचन पढब लबा आरे? ");
INSERT INTO taj_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","थेसे परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हि अबियाथारला पालरी परमेश्‍वरला दिमरी वाङ्सी, परमेश्‍वरदा फुल्‍बा गेङ चजी, ओच्‍छे थेसे थेदेन छ्‌याम मुबा म्‍हिगदेदाएनोन पिन्‍जी। तर थे गेङ परमेश्‍वरला मन्‍दिररी पूजा लबा म्‍हिगदेदा जे चपुङ्मुबा” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","दोःसी येशूसे फरिसीगदेदा “ब्‍लप्‍बा न्‍हबा धिन म्‍हिला लागिरी स्‍होबा हिन्‍ना, तर म्‍हि ब्‍लप्‍बा न्‍हबा धिनना लागिरी स्‍होबा आहिन। ");
INSERT INTO taj_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","थेतबासेलमा परमेश्‍वरसे पुइखबा म्‍हि ब्‍लप्‍बा न्‍हबा धिननाएनोन प्रभु हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","दोःसी येशू यहूदीगदे ह्रुप तबा दिमरी वाङ्‌जी। थेरी या खर्बा म्‍हि गिक मुबा। ");
INSERT INTO taj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ब्‍लप्‍बा न्‍हबा धिनकुनु येशूसे थे म्‍हिला खर्बा या खम्‍ना लला वा भिसी कोइ कोइ म्‍हिगदेसे दोष लबाला लागिरी चिवा लसी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","येशूसे थे या खर्बा मुबा म्‍हिदा “जम्‍मालान ङाच्‍छापट्टि राप्‍गो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","थेसे थेनीगदेदा “ब्‍लप्‍बा न्‍हबा धिनकुनु ज्‍यबा गे लबा कि नइबा गे लबा, म्‍हि सोना लबा कि सिना लबा खजिबा चा ज्‍यबा हिन्‍ना?” भिसी ङ्‌योइजी। तर थेनीगदे कुटिसी चिजी। ");
INSERT INTO taj_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","येशूसे ह्राङला क्‍युर्सीन मुबा म्‍हिगदेदा स्‍हीसी येशूसे थेनीगदेला सेम कोङ्बा था याङ्सी सेमरी ल्‍हानान दुख तसी येशूदा बोमो रेःजी। ओच्‍छे येशूसे थे या खर्बा मुबा म्‍हिदा “एला या तन्‍गब लउ” भिसी सुङ्जी। ओच्‍छे थे म्‍हिसे थेला या तन्‍गब लमैछ्‌याम या खम्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","जमाहेन्‍से फरिसीगदे थेग्‍याम थोन्‍सी निसी येशूदा खाह्रङ् लसी साइबा भिसी हेरोद ग्‍लेला म्‍हिगदेदेन छ्‌याम सल्‍लाह लजी। ");
INSERT INTO taj_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","जमाहेन्‍से येशू ह्राङला चेलागदेदेन छ्‌याम समुन्‍द्रपट्टि फेप्‍जी, ओच्‍छे गालील अञ्‍चलग्‍यामसे म्‍हिला हुल थेला लिच्‍छा भ्रजी। ");
INSERT INTO taj_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","येशूसे लबा उदेकला गेला बारेरी थेःसी यहूदिया, यरूशलेम, इदुमिआ, यर्दन क्‍याम्‍सङ्‍ला ओच्‍छे टुरोसदेन सीदोन नाम्‍साला क्‍यारमारला म्‍हिगदे येशू मुबा ग्‍लारी खजी। ");
INSERT INTO taj_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","थेतबासेलमा म्‍हिगदेसे ह्राङदा थानाङ्‍गै भिसी येशूसे ह्राङला चेलागदेदा दोँगा गिक ठीक लपुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","तिग्‍दा भिसम येशूसे ल्‍हानान आखम्‍बा म्‍हिगदेदा खम्‍ना लबासे लमा रोगसे स्‍याप्‍बा म्‍हिगदे येशूदा थुर्बारी तोर हुइ मार हुइ लबान मुबा। ");
INSERT INTO taj_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ओच्‍छे म्‍हङसे स्‍याप्‍बा म्‍हिगदेसे येशूदा म्राङ्मैछ्‍याम ख्‍लुप तसी, “ह्राङ परमेश्‍वरला झा हिन्‍ना” भिसी क्रिङ्मुबा। ");
INSERT INTO taj_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","तर येशूसे थे म्‍हिला ल्‍हुइरी मुबा म्‍हङदा “च्‍यागो, ङा परमेश्‍वरला झा हिन्‍ना भिसी खालैदा थापाङ्‍गो” भिसी बङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","येशू गङरी फेप्‍सी ह्राङला सेमसे चबा जतिदा ङ्‌योइजी, ओच्‍छे थेनीगदे थे मुबा ग्‍लारी खजी। ");
INSERT INTO taj_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","जमाहेन्‍से ह्राङदेन छ्‌याम भ्रबारी ओच्‍छे म्‍हिगदेदा परमेश्‍वरला य्‍हुल्‍साला समाचार थेःना लबारी च्‍युक न्‍ही म्‍हि धम्‍जी, ओच्‍छे थेनीगदेदा मुल चेला भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ओच्‍छे म्‍हिगदेला ल्‍हुइग्‍याम म्‍हङ ताप्‍बा अधिकार पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","येशूसे धम्‍बा च्‍युक न्‍ही मुल चेलागदे चुगदेन हिन्‍ना, सिमोन भिबादा येशूसे पत्रुस मिन थान्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","जब्‍दियाला झा याकूबदेन याकूबला आले यूहन्‍नादा थेसे बोअनर्गेस भिसी मिन थान्‍जी। बोअनर्गेस भिबा चा मु घुर्बा ह्रङ्बाला झागदे भिबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ओच्‍छे अन्‍द्रियास, फिलिप, बारथोलोमाइ, मत्ती, थोमा, अल्‍फयसला झा याकूब, ओच्‍छे थेदियस, सिमोन मुबा। चु सिमोनदा चा ह्राङला य्‍हुल्‍सादा माया लबा म्‍हि भिसी भिमुबा। ");
INSERT INTO taj_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ओच्‍छे यहूदा इस्‍करियोत चुनोन यहूदा इस्‍करियोतसे लिच्‍छा येशूदा चुङ्सी म्‍हिगदेला यारी जिम्‍मा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ओच्‍छे येशू दिमरी फेप्‍बा धुइरी दोःसी म्‍हिगदे ह्रुप तजी। थेतबासेलमा येशूदेन थेला चेलागदेसे सोल छ्‌योइबारी सुत्तै आम्‍याङ्नी। ");
INSERT INTO taj_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","चु ताम येशूला दिमला म्‍हिगदेसे थेःसी थेदा भोर्बारी भिसी दिमग्‍याम थोन्‍जी, तिग्‍दा भिसम येशूला सेम ठेगानरी आरे भिसी थेनीगदेसे म्‍हन्‍मुबा। ");
INSERT INTO taj_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","यरूशलेमग्‍याम खबा यहूदी धर्मगुरुगदेसे, “चुला ल्‍हुइरी म्‍हङगदेला ग्‍ले बालजिबुल मुला, चु म्‍हिसे मी म्‍हङगदेला ग्‍लेला शक्तिग्‍याम म्‍हङ ताप्‍बा हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","तर येशूसे थेनीगदेदा ह्राङ मुबा ग्‍लारी ङ्‌योइसी उखानग्‍याम चुह्रङ् भिसी सुङ्जी, “शैतानसे शैतानदा खाह्रङ् लसी ताप्‍खम्‍ला? ");
INSERT INTO taj_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","य्‍हुल्‍सा गिकलान म्‍हि ह्राङ ह्राङ न्‍हङरी आढिक्‍सम थे य्‍हुल्‍सा न्‍होङ्ला। ");
INSERT INTO taj_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ओच्‍छे दिम गिकला म्‍हिएनोन ह्राङ ह्राङ न्‍हङरी आढिक्‍नी भिसम थे दिमनामएनोन फुप्‍ला। ");
INSERT INTO taj_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","थेह्रङ् लसी शैतान शैतान न्‍हङरी आढिक्‍नी भिसम थेला य्‍हुल्‍सा नाश तला। ");
INSERT INTO taj_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","खालैसे भङ्‍बा म्‍हिला दिमरी वाङ्सी थेला धन सम्‍पत्ति य्‍हो लतोःजी भिसम थेसे ङाच्‍छा थे भङ्‍बा म्‍हिदा चुङ्सी खीतोःला। थे भङ्‍बा म्‍हिदा खीमाहेन्‍से जे थेसे थेला धन सम्‍पत्ति भोर्खम्‍ला। ");
INSERT INTO taj_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“एनीगदेसे ङाला ताम ङ्‌यान्‍गो, म्‍हिगदेसे लबा जम्‍मान पाप गेदेन परमेश्‍वरदा बिरोध लसी पाप लसैनोन माफ याङ्ला। ");
INSERT INTO taj_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","तर जुन म्‍हिसे परमेश्‍वरला आत्‍माला बिरोध लसी पाप गेदेन पाप ताम लला, थेसे खाइमै माफ आयाङ्। थे जुकजुकधोना पापरी चितोःला।” ");
INSERT INTO taj_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","तिग्‍दा भिसम थेनीगदेसे येशूला ल्‍हुइरी म्‍हङ मुला भिसी भिबान मुबा। ");
INSERT INTO taj_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ओच्‍छे येशूला आमादेन आलेगदे थेरी धोखजी। थेनीगदे मङग्‍यार राप्‍सी येशूदा ङ्‌योइबारी कोइ म्‍हिदा पुइजी। ");
INSERT INTO taj_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","येशूला क्‍युर्नोन म्‍हिला हुल मुबा ओच्‍छे थेनीगदेसे येशूदा “मङग्‍यार ह्राङला आमादेन आलेगदे ह्राङदा म्‍हाइबान मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","येशूसे थेनीगदेदा “ङाला आमादेन आलेगदे खाल हिन्‍ना?” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ओच्‍छे येशूसे ह्राङला क्‍युर्नोन चिबा म्‍हिगदेदा स्‍हीबान, “च्‍यागो, चुरी मुबा जम्‍मान ङाला आमादेन आलेगदे हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","तिग्‍दा भिसम जुन म्‍हि परमेश्‍वरसे म्‍हन्‍बा अन्‍छार भ्रला थेनोन ङाला आमा, ङाला आङा ओच्‍छे ङाला आले हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","येशूसे दोःसी समुन्‍द्रला कुनीरी फेप्‍सी लोप्‍बारी छ्‌याइजी। थेरी म्‍हिला हुल मुबासे लमा येशू समुन्‍द्ररी मुबा दोँगा गिकरी धन्‍छ्‌यासी लोप्‍बारी छ्‌याइजी। ओच्‍छे म्‍हिला हुल चा समुन्‍द्रला कुनीरीक्‍यार चिजी। ");
INSERT INTO taj_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","येशूसे थेरी मुबा म्‍हिगदेदा उखानग्‍याम ल्‍हानान ताम लोप्‍बान चुह्रङ् सुङ्जी, ");
INSERT INTO taj_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“च्‍यागो, ब्‍लु ढ्वबा म्‍हि गिक ब्‍लु ढ्वबारी भ्रजी। ");
INSERT INTO taj_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","थे म्‍हिसे ब्‍लु ढ्वबा धुइरी कोइ ब्‍लु ग्‍यामरी परब तजी, ओच्‍छे थे ब्‍लु चरा खसी चजी। ");
INSERT INTO taj_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","कोइ ब्‍लु चा युङबाला घह्रङ मुबा सरी परब तजी, थेरी ल्‍हानान साप्रा आरेबासे लमा थे ब्‍लु योनान फुइजी। ");
INSERT INTO taj_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","थेतबासेलमा थेला टा नुप्‍ना निआम्‍याङ्नी। ओच्‍छे धिनीसे क्रोसी थे दोङ सिजी। ");
INSERT INTO taj_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","कोइ ब्‍लु चा पुजु झाङरी परब तजी, ओच्‍छे थे ब्‍लु फुइसी ल्‍हेबान निजी। ल्‍हेसी निसै थे पुजु झाङला हापसे लमा थे दोङला नमरी गेडा आवाङ्नी। ");
INSERT INTO taj_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","कोइ ब्‍लु चा ज्‍यबा सरी परब तसी फुइजी, ओच्‍छे थे दोङ ल्‍हेसी निमा थे दोङला नमरी चा दोब्‍बर, तेब्‍बर, चौबरधोना गेडा रोजी। ");
INSERT INTO taj_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","जुन म्‍हिदा ङ्‌यान्‍बा सेम मुला थेसे ङ्‌यान्‍सी घोउ।” ");
INSERT INTO taj_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","म्‍हिला हुल निमाहेन्‍से येशूला क्‍युर्नोन मुबा म्‍हिगदेदेन च्‍युक न्‍ही चेलागदेसे थे उखानना अर्थ ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ओच्‍छे येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदेदा ङाइ म्‍हिसे था आयाङ्‍बा परमेश्‍वरला य्‍हुल्‍साला ताम घोखम्‍बा ज्ञान बुद्धि पिन्‍बा मुला। तर स्‍य्‍हान्‍दोगदेदा चा ङाइ उखानग्‍याम जे पाङ्बा मुला। ");
INSERT INTO taj_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","तिग्‍दा भिसम ‘थेनीगदेसे च्‍याबाम च्‍यामुला तर आम्राङ्मुला ओच्‍छे ङ्‌यान्‍बाम ङ्‌यान्‍मुला तर आघोमुला। आहिन्‍सम ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःसेला मुबा, ओच्‍छे परमेश्‍वरसे थेनीगदेला पाप माफ लसेला मुबा।’” ");
INSERT INTO taj_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","येशूसे थेनीगदेदा “एनीगदेसे चु उखानला अर्थ आघोसम अर्गु उखानना अर्थ खाह्रङ् लसी घोला?” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ब्‍लु ढ्वबा म्‍हि चा परमेश्‍वरला बचन थेःना लबा म्‍हि हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ग्‍यामरीक्‍यार परब तबा ब्‍लुला अर्थ चा चुनोन हिन्‍ना, जुन म्‍हिसे परमेश्‍वरला बचन ङ्‌यान्‍ना तर तुरुन्‍तन शैतान खसी थेनीगदेदा थेःना लबा ताम भोर्ला। ");
INSERT INTO taj_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","युङबाला घह्रङरी परब तबा ब्‍लुला अर्थ चा चुनोन हिन्‍ना, जुन म्‍हिसे परमेश्‍वरला बचन थेःमैछ्‌याम ताङ्सी ह्राङला सेमरी थान्‍ना, ");
INSERT INTO taj_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","तर थेनीगदेला विश्‍वासला टा आरेबासे लमा, थे छिन्‍नङ जे चिला। ओच्‍छे परमेश्‍वरला बचनदा विश्‍वास लबासे लमा थेनीगदेदा आपत विपत खमाहेन्‍से थेनीगदेसे विश्‍वास लबा ख्‍लाला। ");
INSERT INTO taj_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","पुजु झाङ न्‍हङरी परब तबा ब्‍लुला अर्थ चा जुन म्‍हिसे बचन ङ्‌यान्‍ना ");
INSERT INTO taj_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","तर थेला सेमरी जम्‍बुलिङला धन्‍दा सुर्दादेन धन सम्‍पत्तिला लोभसे लमा परमेश्‍वरला बचनदा गे लआपुङ्, ओच्‍छे थेला विश्‍वासग्‍याम तिगै आरो ");
INSERT INTO taj_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","तर ज्‍यबा सरी परब तबा ब्‍लुला अर्थ चा जुन म्‍हिसे बचन ङ्‌यान्‍सी ह्राङला सेमरी थान्‍ना, थेला विश्‍वाससे दोब्‍बर, तेब्‍बर, चौबरधोना गे लला। ");
INSERT INTO taj_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “खालैसे नाङसल म्रासी खाट धिरीनोन आथान ओच्‍छे फामसे घप्‍सीनोन आथान। बरु य्‍हाल तगै भिसी नोबा ग्‍लारी थान्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","थेतबासेलमा ल्‍हुसैनोन आम्राङ्बा स्‍हे तिगै आरे। ओच्‍छे छुम्‍सी थान्‍सैनोन आघोबा स्‍हे तिगै आरे। ");
INSERT INTO taj_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","खालैदा ङ्‌यान्‍बा सेम मुसम थेसे ङ्‌यान्‍सी घोउ। ");
INSERT INTO taj_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“एनीगदेसे जुन ताम थेःबा मुला, थे तामरी सेम लउ। तिग्‍दा भिसम जुन दप्‍बा स्‍हेसे एनीगदेसे दप्‍ला, थेनोन दप्‍बा स्‍हेग्‍यामसे एनीगदेसे याङ्ला। ओच्‍छे एनीगदेदा झन ल्‍हाना पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","जुन म्‍हिसे ङाइ लोप्‍बा तामदा सेम लसी ङ्‌यान्‍ना, थेदा ङाइ अझ घोना लला। तर ङाइ लोप्‍बा ताम आङ्‌यान्‍बादा चा थेसे जुन घोबा मुला थे तामएनोन म्‍हाना लला।” ");
INSERT INTO taj_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","येशूसे चुह्रङ् भिसी सुङ्जी, “परमेश्‍वरला य्‍हुल्‍सा चा म्‍हि गिकसे बुरी ढ्वबा ब्‍लु ह्रङ्‌बान हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ओच्‍छे थे म्‍हि म्‍हेर्सी चिसै आम्‍हेर्ना चिसै धिन म्‍हुननोन थे ब्‍लु फुइसी ल्‍हेबान निला, तर खाह्रङ् लसी ल्‍हेजी भिबा ताम थे म्‍हिसे था आयाङ्। ");
INSERT INTO taj_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","तिग्‍दा भिसम बुरी ब्‍लु ह्राङनोन फुइसी ल्‍हेबान निमाहेन्‍से दोङ दोला, ओच्‍छे थे दोङरी नम थोन्‍ना, जमाहेन्‍से थे नमरी गेडा वाङ्ला। ");
INSERT INTO taj_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","बाली दुइबा धुइ तमैछ्‌याम थे म्‍हि खसी बाली खन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","येशूसे दोःसी चुह्रङ् भिसी सुङ्जी, “ङाइ परमेश्‍वरला य्‍हुल्‍सादा तिगदेन छ्‌याम दाँजब लसे? ओच्‍छे एनीगदेदा खाह्रङ् लसी घोना लसे? ");
INSERT INTO taj_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","चु मी घुर्‍यानरी ढ्वबा पच्‍छैला ब्‍लु ह्रङ्‌बान हिन्‍ना। जम्‍बुलिङरी जम्‍मान भन्‍दा जजाबा ब्‍लु तसैनोन, ");
INSERT INTO taj_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","थे गेडा ढ्वमाहेन्‍से ढापढुप न्‍हङरी जम्‍मान भन्‍दा हाँगा मुबा घ्रेन दोङ तला। ओच्‍छे थे दोङला हाँगारी चरागदे खसी जङ स्‍होसी चिला।” ");
INSERT INTO taj_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","थेनीगदेसे घोखम्‍तेधोना येशूसे चुह्रङ्बान उखानगदेग्‍याम परमेश्‍वरला बचन लोप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","उखान आसुङ्तेधोना थेनीगदेदा येशूसे तिगै ताम आलोप्‍नी। तर ह्राङला चेलागदे जे तबा धुइरी चा जम्‍मान उखानना अर्थ घोना लमुबा। ");
INSERT INTO taj_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","जमाकुनु ङ्‍यसे येशूसे ह्राङला चेलागदेदा “लु, य्‍हाङ समुन्‍द्रला क्‍याम्‍सङपट्टि निइ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","येशूसे चुह्रङ् सुङ्माहेन्‍से चेलागदे म्‍हिला हुलदा ख्‍लासी येशू मुबा दोँगारी क्रेःजी। ओच्‍छे दोँगा चलब लबान क्‍याम्‍सङपट्टि भोर्जी। थेनीगदेला दोँगादेन छ्‌याम छ्‌याम अर्गु दोँगागदेएनोन निजी। ");
INSERT INTO taj_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","निबान लमा समुन्‍द्ररी लाबालुङसर खजी। थे लाबालुङसरसे लमा समुन्‍द्रला छाल रेःसी दोँगा डुबब तबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","थे धुइरी येशू दोँगाला ग्‍यापपट्टि खुम लसी स्‍हिम्‍बान मुबा। ओच्‍छे चेलागदेसे “प्रभु, य्‍हाङ सिबारी छ्‌याइजी, ह्राङदा तिगै वास्‍ता आरे?” भिसी छिङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","जमाहेन्‍से येशूसे स्‍हेङ्‌सी लाबालुङसरदेन समुन्‍द्रला छालदा “कुटिसी चिउ” भिसी सुङ्मैछ्‌याम लाबालुङसर म्‍हाजी ओच्‍छे शान्‍त तजी। ");
INSERT INTO taj_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","येशूसे “एनीगदे तिग्‍दा लोङ्‌बा? दान्‍देधोना एनीगदेदा ङाला विश्‍वास आरे?” भिसी ह्राङला चेलागदेदा सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ओच्‍छे चेलागदे उदेक म्‍हन्‍सी लोङ्बान, “चु खाल? लाबालुङसरदेन समुन्‍द्रला छालसेएनोन थेसे कुल्‍बा ताम ङ्‌यान्‍बा चीम!” भिसी थेनीगदे ह्राङ ह्राङ न्‍हङरी ताम लबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ओच्‍छे येशूदेन थेनीगदे गालील समुन्‍द्रला क्‍याम्‍सङपट्टि गेरासेनस भिबा ग्‍लारी धोखजी। ");
INSERT INTO taj_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","येशू दोँगाग्‍याम फप्‍मैछ्‌याम म्‍हङसे स्‍याप्‍बा म्‍हि गिक धुर्साग्‍याम यार्बान खसी येशूदा स्‍याप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","थे म्‍हि धुर्सारीक्‍यार चिमुबा। थेदा तिगै लसीन चुङ्बारी आखम्‍मुबा थेदा च्‍याल्‍दासे खीसैनोन ब्‍लसी यार्मुबा। ");
INSERT INTO taj_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","तिग्‍दा भिसम थेदा ल्‍हानान रेम च्‍याल्‍दासे खीसी थान्‍सैनोन थेसे थे च्‍याल्‍दागदे फ्राटफ्रेट टाङ्मुबा। थेतबासेलमा थेदा खालैसे तहरी थान्‍बारी आखम्‍मुबा। ");
INSERT INTO taj_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","थे धिन म्‍हुननोन ह्राङसे ह्राङदान युङबासे तोसी धुर्सा गङरीक्‍यार क्रिङ्बान भ्रमुबा। ");
INSERT INTO taj_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","थेसे थारेङग्‍यामसेन येशूदा म्राङ्मैछ्‍याम यार्बान खसी येशूदा फ्‍या लजी। ");
INSERT INTO taj_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ओच्‍छे थेसे “जम्‍मान भन्‍दा घ्रेन परमेश्‍वरला झा येशू, ह्राङसे ङादा तिग लबारी छ्‌याइबा? ङाइ ह्राङदा परमेश्‍वरला मिनरी घ्रान फासी भिला, ङादा दुख थापिन्‍गो” भिसी क्रिङ्बान भिजी। ");
INSERT INTO taj_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","तिग्‍दा भिसम येशूसे ङाच्‍छान थे म्‍हिला ल्‍हुइरी मुबा म्‍हङदा “ए थोन्‍सी निउ” भिसी सुङ्बा मुबा। ");
INSERT INTO taj_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ओच्‍छे येशूसे थेदा “एला मिन तिग?” भिसी ङ्‌योइमा, थे म्‍हङसे “ङाला मिन हुल हिन्‍ना, तिग्‍दा भिसम ङनी ल्‍हानान मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","थे म्‍हङसे येशूदा “ङन्‍दा चु ग्‍लाग्‍याम थातेःगो।” भिसी बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","थेरी गङरीक्‍यार ढ्वला बथान छबान मुबा। ");
INSERT INTO taj_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ओच्‍छे म्‍हङगदेसे येशूदा “ङन्‍दा ढ्वागदे न्‍हङरी वाङ्पुङ्‍गो” भिसी बिन्‍ती लजी ");
INSERT INTO taj_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","येशूसे वाङ्‌पुङ्‌माहेन्‍से म्‍हङगदे म्‍हिला ल्‍हुइग्‍याम थोन्‍सी ढ्वागदे न्‍हङरी वाङ्‌जी। वाङ्मैछ्‌याम ओस्‍पन, हजार न्‍ही ढ्वला बथान गङग्‍याम समुन्‍द्ररी छ्‌योङ्सी सिजी। ");
INSERT INTO taj_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","जमाहेन्‍से ढ्वा छबा म्‍हिगदे यार्सी शहरदेन नाम्‍सा नाम्‍सारी निसी चु ताम थेःना लजी। ओच्‍छे जम्‍मान म्‍हिगदे तिग तजीम भिसी च्‍याबारी खजी। ");
INSERT INTO taj_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","जमाहेन्‍से थेनीगदे येशू मुबा ग्‍लारी खजी, ओच्‍छे थे म्‍हङला हुलसे स्‍याप्‍बा म्‍हि खम्‍सी ज्‍यना लसी क्‍वान क्‍वान्‍सी चिबा म्राङ्सी थेनीगदे लोङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","म्‍हङसे स्‍याप्‍बा म्‍हिदेन ढ्वागदेदा तिग तिग तजी भिबा ताम म्राङ्बा म्‍हिगदेसे थेरी च्‍याबारी खबा म्‍हिगदेदा पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","जमाहेन्‍से थेनीगदेसे येशूदा “चु ग्‍लाग्‍याम फेप्‍गो” भिसी बिन्‍ती लबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","येशू दोँगारी क्रेःबारी छ्‌याइमा थे म्‍हङसे स्‍याप्‍बा म्‍हिसे “ङाएनोन ह्राङदेन छ्‌याम निसे” भिसी बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","तर येशूसे ह्राङदेन छ्‌याम खआपुङ्ना “ए ह्राङला दिमरी निसी एदा परमेश्‍वरसे उन्‍बा दयादेन परमेश्‍वरसे एला लागिरी तिग तिग लजी, थे तामगदे एसे ह्राङला ह्रोगदेदा थेःना लउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ओच्‍छे थे निसी डेकापोलिस भिबा ग्‍ला नाङनोन येशूसे ह्राङला लागिरी लबा उदेकला गेला बारेरी पाङ्सी भ्रजी, चु ताम थेःसी नाम्‍साला म्‍हिगदे उदेक म्‍हन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","दोःसी येशू दोँगारी क्रेःसी समुन्‍द्रला क्‍याम्‍सङपट्टि फेप्‍जी। ओच्‍छे थेला क्‍युर्सीन म्‍हिला हुल पोप तजी। ");
INSERT INTO taj_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","थेनोन धुइरी यहूदीगदे ह्रुप तबा दिमला याइरस मिन लबा नेता गिक थेरी धोखजी। थेसे येशूदा म्राङ्मैछ्‍याम येशूदा फ्‍या लसी, ");
INSERT INTO taj_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“ङाला झामे आखम्‍ना सिबारी छ्‌याइबा मुला, ह्राङ फेप्‍खसी थेदा थुर्सी पिन्‍गो। ओच्‍छे थे खम्‍गै” भिसी बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","थेतबासेलमा येशू याइरसदेन छ्‌याम फेप्‍जी ओच्‍छे म्‍हिला हुलएनोन येशूला लिच्‍छा भ्रजी, म्‍हिला हुलसे लमा येशूदा तोर हुइ मार हुइ लजी। ");
INSERT INTO taj_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","थे म्‍हिला हुल न्‍हङरी का निबा बेथासे स्‍याप्‍सी च्‍युक न्‍ही दिङ तबा म्रिङम्‍हेमे गिक मुबा। ");
INSERT INTO taj_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","थेसे ह्राङला मुदेबा धन सम्‍पत्ति खर्च लसी डाक्‍टरगदेदा च्‍यापुङ्जी। तर खम्‍ला भिमाम झन ङाच्‍छाला भन्‍दा सारो तसी निजी। ");
INSERT INTO taj_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","थेसे येशूला बारेरी थेःमाहेन्‍से थे म्‍हिला हुल न्‍हङरी वाङ्सी ग्‍यापग्‍याम खसी येशूला क्‍वान थुर्जी। ");
INSERT INTO taj_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","तिग्‍दा भिसम थेसे “ङाइ येशूला क्‍वान थुर्बारी जे म्‍याङ्‍सम ङा खम्‍ला” भिसी म्‍हन्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","थेसे येशूला क्‍वान थुर्मैछ्‌याम थेला का निबा बेथा म्‍हाजी भिसी थेसे तुरुन्‍तन था याङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ओच्‍छे येशूसे ह्राङला ल्‍हुइग्‍याम तुरुन्‍तन शक्ति थोन्‍बा था याङ्सी म्‍हिला हुलपट्टि दोःसी, “खाल्‍से ङाला क्‍वान थुर्जी?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","चेलागदेसे येशूदा भिजी, “चुदेला म्‍हिला हुलसे तोर हुइ मार हुइ लबा स्‍हीना स्‍हीनान दोःसी ह्राङ ‘ङादा खाल्‍से थुर्जी’ भिसी सुङ्बान मुला।” ");
INSERT INTO taj_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ङादा थुर्बा खाल भिसी येशूसे क्‍युर्सीन च्‍याबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ओच्‍छे थे का निबा बेथासे स्‍याप्‍बा म्रिङम्‍हेमेसे येशूला क्‍वान थुर्मा ह्राङदा तिग तजी भिबा था तसी लोङ्सी फितफित धर्बान येशूला ङाच्‍छापट्टि फ्‍या लजी। ओच्‍छे येशूदा जम्‍मान सत्‍य ताम पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","येशूसे थेदा “झामे, एला विश्‍वाससे लमा ए खम्‍बा मुला। दाहेन्‍से ए ढुक्‍क तसी निउ, एला रोग म्‍हाजी” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","येशूसे ताम लबान लबा धुइरी याइरसला दिमग्‍याम म्‍हिगदे खसी, “ह्राङला झामे सिजी, दाहेन्‍से गुरुदा दुख थापिन्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","तर येशूसे थेनीगदेला तामदा थेगो आलना, याइरसदा “थालोङ्‍गो, एसे विश्‍वास जे लउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ओच्‍छे येशूसे पत्रुस, याकूबदेन याकूबला आले यूहन्‍नादा बाहेक स्‍य्‍हान्‍दोदा ह्राङदेन छ्‌याम खआपुङ्नी। ");
INSERT INTO taj_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","थेनीगदे याइरसला दिमरी फेप्‍खमा येशूसे थेरी मुबा म्‍हिगदे क्राबा क्रिङ्बादेन हल्‍ली खल्‍ली लसी चिबा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","येशू दिम न्‍हङरी वाङ्सी, थेनीगदेदा “तिग्‍दा एनीगदे चुह्रङ् लसी क्राबा क्रिङ्बादेन हल्‍ली खल्‍ली लसी चिबा? माइ सिबा आरे, म्‍हेर्सी चिबा मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","तर थेनीगदेसे येशूला तामदा खिसी लसी ङेःजी। ओच्‍छे येशूसे थेनीगदे जम्‍मादान मङग्‍यार तेःसी माइला आबादेन आमा ओच्‍छे ह्राङला चेलागदेदा छ्‌याम भोर्सी माइ मुबा ग्‍लारी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ओच्‍छे येशूसे थे माइला या चुङ्सी, “तालिता कुम,” भिसी सुङ्जी। चु भिबा चा “माइ रेःगो” भिबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","येशूसे चुह्रङ् सुङ्मैछ्‌याम थे माइ डोङ रेःसी क्‍यारमार भ्रबारी छ्‌याइजी। थे माइ च्‍युक न्‍ही दिङला मुबा। चु म्राङ्सी थेनीगदे उदेक म्‍हन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","येशूसे थेनीगदेदा “च्‍यागो, चु ताम खालैसे था थायाङ्‍गै।” ओच्‍छे थे माइदा चा “तिगै चबा स्‍हे पिन्‍गो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","येशू थे ग्‍याम थोन्‍सी ह्राङलान नाम्‍सारी फेप्‍जी। ओच्‍छे थेला चेलागदेएनोन थेदेन छ्‌याम निजी। ");
INSERT INTO taj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ब्‍लप्‍बा न्‍हबा धिनकुनु येशूसे यहूदीगदे ह्रुप तबा दिमरी लोप्‍बारी छ्‌याइजी। थेसे लोप्‍बा म्राङ्सी ल्‍हानान म्‍हिगदे उदेक तजी, “चु म्‍हिसे चु जम्‍मान खानङग्‍याम याङ्जी? चुदा पिन्‍बा चु ज्ञान बुद्धि खाह्रङ्बा हिन्‍ना? चुला याग्‍यामसे खाह्रङ्बा उदेकला गे तबा? ");
INSERT INTO taj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","तिग चु मरियमला झा, याकूब, योसेफ, यहूदादेन सिमोनला ज्‍योज्‍यो सिकर्मी आहिन? तिग चुला आङागदेएनोन य्‍हाङदेन छ्‌याम आरे?” भिसी येशूला ताम पत्‍याब आतनी। ");
INSERT INTO taj_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","येशूसे थेनीगदेदा “अगमवक्तादा जम्‍मान ग्‍लारी मान लला, तर ह्राङला नाम्‍सारीदेन ह्राङला म्‍हिगदे ओच्‍छे ह्राङला दिमरी बाहेक अर्गु खजिबै ग्‍लारी निसैनोन मान लला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","थेरी येशूसे कोइ कोइ आखम्‍बा म्‍हिगदेथोरी ह्राङला या थान्‍सी थेनीगदेदा खम्‍ना लजी। तर थेनीगदेला विश्‍वास आरेबा म्राङ्सी अर्गु उदेकला गे आलनी। ");
INSERT INTO taj_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","येशू थेनीगदेसे विश्‍वास आलबा म्राङ्सी उदेक म्‍हन्‍जी। थेतबासेलमा नाम्‍सा नाम्‍सारी लोप्‍बारी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","थे धुइरी येशूसे ह्राङला च्‍युक न्‍ही चेलागदेदा ङ्‌योइसी थेनीगदेदा म्‍हङ ताप्‍बा अधिकार पिन्‍सी गोर न्‍ही न्‍ही लसी पुइजी। ");
INSERT INTO taj_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","येशूसे थेनीगदेदा चुह्रङ् भिसी कुल्‍जी, “एनीगदेसे ग्‍यामला लागिरी कडी बाहेक तिगै चबा स्‍हे, टाङगा, झोला थापुइगो। ");
INSERT INTO taj_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","तर लखम क्‍वान्‍गो, ओच्‍छे ह्राङला लागिरी पोबा क्‍वान थापुइगो। ");
INSERT INTO taj_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","दोःसी येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदे खजिबै दिमरी वाङ्माहेन्‍से थे नाम्‍साग्‍याम थोन्‍सी आनितेधोना एनीगदे थे दिमरीन चिउ। ");
INSERT INTO taj_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","चुदे खजिबै ग्‍लारी एनीगदेदा मान आलनी। ओच्‍छे एनीगदेसे पाङ्बा ताम आङ्‌यान्‍नी भिसम, एनीगदे थे ग्‍लाग्‍याम थोन्‍बा धुइरी दाहेन्‍से ङन्‍से लतोःबा गे लसी जिन्‍जी। एनीगदेसे तिग लतोःबा लउ भिसी काङला धुलु खर्सी पिन्‍गो।” ");
INSERT INTO taj_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","जमाहेन्‍से थेला चेलागदे थेग्‍याम थोन्‍सी निसी म्‍हिगदेदा “ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःगो” भिसी पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","थेनीगदेसे ल्‍हानान म्‍हिला ल्‍हुइग्‍याम म्‍हङ ताप्‍जी। ओच्‍छे ल्‍हानान आखम्‍बा म्‍हिगदेदा छ्‌युगु फोर्सी प्रार्थना लसी खम्‍ना लजी। ");
INSERT INTO taj_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","येशूसे लबा उदेकला गेला बारेरी हेरोद ग्‍लेसे थेःजी, तिग्‍दा भिसम जम्‍मान ग्‍लारी येशूला मिन थेःमुबा। गाते म्‍हिसे मी “बप्‍तिस्‍मा पिन्‍बा यूहन्‍ना सिबाग्‍याम सोसी खजीम, थेतबासेलमान थेसे चुह्रङ्बा उदेकला गेगदे लबा हिन्‍ना” भिसी भिमुबा। ");
INSERT INTO taj_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","तर स्‍य्‍हान्‍दोगदेसे, “चु एलिया हिन्‍ना” भिसी भिजी। ओच्‍छे अझ स्‍य्‍हान्‍दोगदेसे, “चु म्‍हि मी ओन्‍माला अगमवक्तागदे ह्रङ्‌बान अगमवक्ता गिक हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","तर हेरोदसे चु ताम थेःसी, “चु म्‍हि ङाइ साइपुङ्‌बा यूहन्‍ना हिन्‍ना, थेनोन सिबाग्‍यामसे सोसी खजीम” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","तिग्‍दा भिसम ङाच्‍छा हेरोद ह्राङसेन यूहन्‍नादा चुङ्‌पुङ्‌जी थेदा झ्‍याल्‍खानरी थान्‍बा मुबा। हेरोदसे ह्राङला आले फिलिपला म्रिङ हेरोदियासदेन छ्‌याम ब्‍याह लबासे लमा थेसे यूहन्‍नादा झ्‍याल्‍खानरी थान्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","तिग्‍दा भिसम यूहन्‍नासे हेरोददा “ह्राङसे आले चाङदेन छ्‌याम ब्‍याह लबा ठीक आहिन” भिसी भिमुबा। ");
INSERT INTO taj_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","थेतबासेलमा हेरोदियाससे यूहन्‍नाथोरी ईख थान्‍सी थेदा साइबारी म्‍हाइमुबा तर खम्‍बा आरेबा। ");
INSERT INTO taj_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","तिग्‍दा भिसम यूहन्‍ना परमेश्‍वरसे म्‍हन्‍बा अन्‍छार भ्रबा म्‍हिदेन परमेश्‍वरला लागिरी फेसी थान्‍बा म्‍हि भिसी हेरोददा था मुबा। थेतबासेलमा यूहन्‍नादेन छ्‌याम लोङ्सी थेदा जोगब लसी थान्‍मुबा। यूहन्‍नासे लोप्‍बा म्राङ्सी थेला सेम क्रामुबा। तसैनोन सेम लसी ङ्‌यान्‍मुबा। ");
INSERT INTO taj_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","हेरोदियाससे हेरोद न्‍हबा धिन‍दा ढन्‍सी लबा भोजकुनु ज्‍यबा मौका याङ्जी। हेरोदसे ह्राङ न्‍हबा धिन‍दा ढन्‍सी घ्रेन पदरी मुबा म्‍हिगदे, सिपाहीला कप्‍तानगदेदेन गालील नाम्‍साला गन्‍बा म्‍हिगदेदा ङ्‌योइसी भोज पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","थे धुइरी हेरोदियासला ह्राङलान झामे थेरी खसी स्‍य्‍हजी। थे स्‍य्‍हबा म्राङ्सी हेरोद ग्‍लेदेन थेला डोन्‍बोगदे ल्‍हानान ताङ्जी। हेरोद ग्‍लेसे थे माइदा “एदा तिग तोःबा ङादा ह्री‍गो, थे ङाइ एदा पिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ओच्‍छे हेरोद ग्‍लेसे घ्रान फासी, “एदा ङाला गङसल य्‍हुल्‍सा भिसै पिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ओच्‍छे थे मङग्‍यार थोन्‍सी ह्राङला आमादा ङाइ तिग ह्री‍गो भिसी, ङ्‌योइमा, “बप्‍तिस्‍मा पिन्‍बा यूहन्‍नाला थोबो ह्री‍गो” भिसी थेला आमासे भिजी। ");
INSERT INTO taj_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","चुह्रङ् भिमैछ्‌याम थे माइ ग्‍ले मुबा ग्‍लारी निसी, “दान्‍दे ङादा ह्राङसे बप्‍तिस्‍मा पिन्‍बा यूहन्‍नाला थोबो खार्बारी भउ” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","थेह्रङ् भिमाहेन्‍से ग्‍लेला सेमरी दुख ङ्‌हम्‍जी, तर ओतेला डोन्‍बोला ओन्‍छाङरी घ्रान फासी पाङ्बा तामदा थाबारी आखम्‍नी। ");
INSERT INTO taj_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","थेतबासेलमा थेसे तुरुन्‍तन ह्राङला सिपाही गिकदा “बप्‍तिस्‍मा पिन्‍बा यूहन्‍नाला थोबो थासी भउ” भिसी कुल्‍जी। ओच्‍छे थे सिपाही झ्‍याल्‍खानरी निसी यूहन्‍नाला थोबो थाजी। ");
INSERT INTO taj_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","थासी भसी थे माइदा खार्बारी युसी पिन्‍जी। ओच्‍छे थे माइसे थेला आमादा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","चु ताम थेःसी यूहन्‍नाला चेलागदे खसी थेला लास भोर्सी धुर्सारी थान्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","येशूसे पुइबा जम्‍मान मुल चेलागदे दोःसी खसी येशू मुबा ग्‍लारी पोप तजी। थेनीगदेसे लबा गेदेन लोप्‍सी पिन्‍बा तामगदे येशूदा पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","येशूसे थेनीगदेदा “एनीगदेएनोन सुनसान ग्‍लारी खसी ब्‍लप्‍बा न्‍हउ” भिसी सुङ्जी। तिग्‍दा भिसम थेरी खबा निबा म्‍हिगदे ल्‍हानान मुबासे लमा थेनीगदेदा चबारी सुत्तै फुर्सत आरेबा। ");
INSERT INTO taj_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","थेतबासेलमा थेनीगदे दोँगारी क्रेःसी सुटुक्‍क सुनसान ग्‍लारी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","तर ल्‍हानान म्‍हिगदेसे थेनीगदे निबान लबा म्राङ्जी। थेतबासेलमा थेनीगदे फेप्‍गे लबा ग्‍ला था याङ्सी, नाम्‍सा नाम्‍साला म्‍हिगदे यार्बान थेनीगदे फेप्‍बा ग्‍लापट्टि निजी। ओच्‍छे थेनीगदे भन्‍दा ङाच्‍छा धोजी। ");
INSERT INTO taj_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","येशू दोँगाग्‍याम फाप्‍बा धुइरी ल्‍हानान म्‍हिला हुल म्राङ्सी थेदा दया रेःजी। तिग्‍दा भिसम थे म्‍हिगदे गोठालो आरेबा ग्‍युगदे ह्रङ्‌बा मुबा। येशूसे थे म्‍हिगदेदा ल्‍हानान ताम लोप्‍बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ङ्‍यसे तमाहेन्‍से थेला चेलागदे थे मुबा ग्‍लारी खसी थेदा “दाहेन्‍से ङ्‍यसे तसी जिन्‍जी, चु सुनसान ग्‍लारी तिगै आरे। ");
INSERT INTO taj_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","थेतबासेलमा चु म्‍हिगदेदा पुइगो। थेनीगदे चु क्‍यारमारला नाम्‍सारी निसी चबा स्‍हेगदे ग्‍लुसी चगै” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","तर येशूसे थेनीगदेदा “एनीगदेसेन चुगदेदा चबा स्‍हे पिन्‍गो” भिसी सुङ्जी। तर थेनीगदेसे येशूदा “ङन्‍से ग्‍यार्जा न्‍ही म्‍हुइला डबलसे गेङ ग्‍लुसी थेनीगदेदा चबारी छ्‍योला?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","येशूसे थेनीगदेदा “एनीगदेदेन छ्‌याम गेङ गाते मुला? निसी च्‍यागो” भिसी सुङ्जी। जमाहेन्‍से थेनीगदेसे च्‍यासी, “गोर ङा गेङदेन गोर न्‍ही तार्ङा मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","जमाहेन्‍से येशूसे म्‍हिगदेदा पाङरी लाम लसी चिउ भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ओच्‍छे म्‍हिगदे ग्‍यार्जा ग्‍यार्जादेन बोगल न्‍हीसे च्‍युइ च्‍युइला लाम लसी पाङरी चिजी। ");
INSERT INTO taj_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","येशूसे थे गोर ङा गेङदेन गोर न्‍ही तार्ङा थोसी स्‍वर्गपट्टि स्‍हीसी परमेश्‍वरदा धन्‍यवाद पिन्‍जी। ओच्‍छे थे गोर ङा गेङ क्‍युइसी म्‍हिगदेदा भो लसी पिन्‍गो भिसी चेलागदेदा पिन्‍जी। ओच्‍छे गोर न्‍ही तार्ङाएनोन जम्‍मान म्‍हिगदेदा भो लसी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ओच्‍छे जम्‍मान म्‍हिगदेसे म्रेन्‍ना चजी। ");
INSERT INTO taj_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","जमाहेन्‍से चेलागदेसे लेङ्बा गेङदेन तार्ङा दुइमा च्‍युक न्‍ही सोली तजी। ");
INSERT INTO taj_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","थेरी चबा ह्रेम्‍फेबेगदे हजार ङा मुबा। ");
INSERT INTO taj_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ओच्‍छे येशूसे तुरुन्‍तन ह्राङला चेलागदेदा दोँगारी क्रेःसी क्‍यामसङ बेथसेदा नाम्‍सारी ह्राङ भन्‍दा ङाच्‍छा पुइजी। थे धुइरी येशूसे चा म्‍हिला हुलदा पुइबान लजी। ");
INSERT INTO taj_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ओच्‍छे थेनीगदेदा पुइमाहेन्‍से येशू गङपट्टि प्रार्थना लबारी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ङ्‍यसे तमा दोँगा समुन्‍द्रला गुङरी मुबा, ओच्‍छे येशू चा गिकजेन समुन्‍द्रला कुनीरी मुबा। ");
INSERT INTO taj_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","थेसे चेलागदेदा दोँगा चलब लबारी गाह्रो तबा म्राङ्जी। तिग्‍दा भिसम लाबा उल्‍टोग्‍यामसे खबा मुबा। स्‍य्‍होला तीन बजेरीक्‍यार येशू समुन्‍द्रथोरी भ्रबान थेनीगदेपट्टि फेप्‍खजी, ओच्‍छे थेनीगदेदा ख्‍लासी ङाच्‍छा फेप्‍गे लमा, ");
INSERT INTO taj_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","थेनीगदेसे येशूदा समुन्‍द्रथोरी भ्रबान लबा म्राङ्सी म्‍हङ मुनम भिसी थेनीगदे लोङ्सी क्रिङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","तिग्‍दा भिसम येशूदा म्राङ्सी जम्‍मान लोङ्‌बा मुबा। तर तुरुन्‍तन येशूसे थेनीगदेदा “भङ लउ, ङानोन हिन्‍ना, थालोङ्‍गो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ओच्‍छे ह्राङला चेलागदेदेन छ्‌याम दोँगारी क्रेःजी। जमाहेन्‍से लाबालुङसर म्‍हाजी। ओच्‍छे थेनीगदे ल्‍हानान उदेक तजी। ");
INSERT INTO taj_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","तिग्‍दा भिसम थेनीगदेला सेम कोङ्बासे लमा येशूसे हजार ङा म्‍हिगदेदा गेङ पिन्‍बा म्राङ्सीएनोन थेला अर्थ घोबा आरेबा। ");
INSERT INTO taj_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","थेनीगदे समुन्‍द्र थासी गनेसरेत भिबा ग्‍लारी धोखमाहेन्‍से दोँगा समुन्‍द्रला कुनीरी थान्‍सी, ");
INSERT INTO taj_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","दोँगाग्‍याम फाप्‍मैछ्‌याम म्‍हिगदेसे येशूदा ङोसेजी। ");
INSERT INTO taj_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ओच्‍छे थेनीगदे क्‍यारमारला नाम्‍सारी निसी येशू फेप्‍खजी भिसी थेःना लजी। जमाहेन्‍से म्‍हिगदेसे आखम्‍बा म्‍हिगदेदा तीबा नान्‍बादेन छ्‌यामनोन येशू मुबा ग्‍लारी भबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","जुन जुन ग्‍लारी येशू फेप्‍जी, थे ग्‍लारी म्‍हिगदेसे आखम्‍बा म्‍हिगदेदा येशूला क्‍वान जे भिसै, थुर्पुङ्‍गो भिसी बिन्‍ती लजी। ओच्‍छे येशूला क्‍वान थुर्बा जति जम्‍मान खम्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","यरूशलेमग्‍याम खबा फरिसीदेन यहूदी धर्मगुरुगदे येशूला क्‍युर्नोन पोप तजी। ");
INSERT INTO taj_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","थेनीगदेसे येशूला कोइ कोइ चेलागदेसे या आख्रुना चबा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","फरिसीगदेदेन यहूदीगदेला आखे म्‍हेमेला रिमठिम अन्‍छार या आख्रुतेधोना चबारी आतबा मुबा। ");
INSERT INTO taj_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","चुदे जे आहिन बजारग्‍याम खमाहेन्‍से नुहाब आलतेधोना आचमुबा। आखे म्‍हेमेला चु भन्‍दा ल्‍हानान रिमठिम तेन्‍मुबा ओच्‍छे खोरेगदे, ताङगदेदेन काँसला ताङगदे म्‍याप्‍बा रिमठिम मुबा। ");
INSERT INTO taj_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ओच्‍छे फरिसीगदेदेन यहूदी धर्मगुरुसे येशूदा “ह्राङला चेलागदे तिग्‍दा आखे म्‍हेमेला रिमठिम अन्‍छार आभ्रबा? ओच्‍छे या आख्रुनान चबा?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","थेतबासेलमा थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदे ह्रङ्‌बा कप्‍टी म्‍हिगदेला लागिरी यशैया अगमवक्तासे भ्रिबा ताम ढिक्‍बा मुला, ‘चु म्‍हिगदेसे सुङसे जे ङादा मान लमुला, तर सेमहेन्‍से चा मान आलमुला। ");
INSERT INTO taj_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ओच्‍छे एनीगदेसे ङादा तेन्‍बाम तेन्‍मुला तसैनोन परमेश्‍वरसे कुल्‍बा तामदा भन्‍दा म्‍हिसे स्‍होबा रिमठिमदा घ्रेन म्‍हन्‍मुला।’ ");
INSERT INTO taj_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","एनीगदेसे परमेश्‍वरसे कुल्‍बा ताम ख्‍लासी म्‍हिगदेला रिमठिम तेन्‍बा मुला।” ");
INSERT INTO taj_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","दोःसी येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदे ह्राङला रिमठिम तेन्‍बाला लागिरी परमेश्‍वरसे कुल्‍बा ताम ख्‍लाबा एनीगदे खाह्रङ्बा छट्टु? ");
INSERT INTO taj_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","तिग्‍दा भिसम मोशासे भिबा मुला, ‘एसे ह्राङला आबा आमादा मान लउ,’ ओच्‍छे ‘जुन म्‍हिसे ह्राङला आबा आमादा बिरोध लसी नइबा ताम लला थेदा चा साइनोन तोःला’ भिसी सुङ्बा मुला। ");
INSERT INTO taj_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","तर एनीगदेसे चा ‘जुन म्‍हिसे ह्राङला आबा आमादा पिन्‍तोःबा स्‍हे परमेश्‍वरदा फुल्‍बा मुला, थेसे ह्राङला आबा आमादा मान लआतोः’ भिसी पाङ्‌मुला। ");
INSERT INTO taj_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","थेतबासेलमा एनीगदेला तामग्‍यामसेन म्‍हिगदेदा थेन्‍ना आबा आमादा तिगै पिनआपुङ्बा ह्रङ्‌बान हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","चुह्रङ् लसी एनीगदे ह्राङला रिमठिम अन्‍छार चा भ्रमुला। तर परमेश्‍वरला बचनदा चा तिगै गे आखेल्‍बा भिसी म्‍हन्‍मुला। चुह्रङ्बा गे एनीगदेसे ल्‍हानान लमुला।” ");
INSERT INTO taj_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","दोःसी येशूसे म्‍हिला हुलदा ह्राङ मुबा ग्‍लारी ङ्‌योइसी चुह्रङ् भिसी सुङ्जी, “ङाइ पाङ्बा ताम तिग चीम भिसी एनीगदेसे घोबारी म्‍हाइगो। ");
INSERT INTO taj_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","खजिबै चबा स्‍हेसे म्‍हिदा न्‍होङ्ना लबारी आखम। तर म्‍हिला सेमग्‍याम थोन्‍बा तामसे जे म्‍हिदा न्‍होङ्ना लमुला। ");
INSERT INTO taj_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","जुन म्‍हिदा ङ्‌यान्‍बा सेम मुला थेसे ङ्‌यान्‍सी घोउ।” ");
INSERT INTO taj_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","येशू म्‍हिगदेदा ख्‍लासी दिम न्‍हङरी वाङ्माहेन्‍से थेला चेलागदेसे “ह्राङसे सुङ्बा ताम ङन्‍दा घोना लसी पिन्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","जमाहेन्‍से येशूसे ह्राङला चेलागदेदा चुह्रङ् भिसी सुङ्जी, “दान्‍देधोना अझ एनीगदेसे घोबा आरे? एनीगदेदा था आरे? म्‍हिला सुङग्‍याम न्‍हङरी वाङ्बा स्‍हेसे म्‍हिदा न्‍होङ्ना आल। ");
INSERT INTO taj_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","तिग्‍दा भिसम चबा स्‍हे मी सेम न्‍हङरी आवाङ्ना फो न्‍हङरी वाङ्ला ओच्‍छे फो न्‍हङसेनोन मङग्‍यार थोन्‍ना।” चुह्रङ् लसी येशूसे जम्‍मान चबा स्‍हे चबारी तला भिसी ह्राङला चेलागदेदा घोना लसी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","येशूसे दोःसी चुह्रङ् भिसी सुङ्जी, “म्‍हिला सेम न्‍हङ‍ग्‍याम मङग्‍यार थोन्‍बा तामसे म्‍हिदा न्‍होङ्ना लमुला। ");
INSERT INTO taj_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","तिग्‍दा भिसम म्‍हिला सेमग्‍यामसेन नइबा म्‍हन्‍बा, ब्रेल्‍सी भ्रबा, य्‍हो लबा, म्‍हि साइबा, ");
INSERT INTO taj_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","म्‍हिला म्रिङदेन छ्‌याम ब्रेल्‍सी भ्रबा, लोभ लबा, नइबा गे लबा, ठगब लबा, सुङरी जे ताम खजी थेनोन पाङ्सी भ्रबा, डाह लबा, म्‍हिला तामगन लबा, ङा ह्रङ्‌बा खालै आरे भिसी भ्रबा, मूर्ख गे लबा चु जम्‍मान तामगदे थोन्‍मुला। ");
INSERT INTO taj_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","म्‍हिला सेमग्‍याम थोन्‍बा चु जम्‍मान नइबा तामसेन म्‍हिगदेदा न्‍होङ्ना लमुला।” ");
INSERT INTO taj_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","जमाहेन्‍से येशू थेग्‍याम टुरोस भिबा ग्‍लापट्टि फेप्‍जी। ओच्‍छे खालैसे था थायाङ्‍गै भिसी दिम गिकरी वाङ्‌जी तसैनोन म्‍हिगदेसे था याङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","थेनोन धुइरी म्रिङम्‍हेमे गिकसे येशूला बारेरी थेःमैछ्‌याम येशू मुबा ग्‍लारी खसी येशूदा फ्‍या लजी। थे म्रिङम्‍हेमेला झामेदा म्‍हङसे स्‍याप्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","थे म्रिङम्‍हेमे सिरिया य्‍हुल्‍साला फोनिके भिबा नाम्‍सारी न्‍हबा मुबा। थे अर्गु य्‍हुलला म्रिङम्‍हेमे मुबा। थेसे “ङाला झामेला ल्‍हुइग्‍यामसे म्‍हङ ताप्‍सी पिन्‍गो” भिसी येशूदा बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","तर येशूसे “ङाच्‍छा ह्राङला कोलागदेदा म्रेन्‍ना लतोःला, ह्राङला कोलागदेला गेङ ब्‍यन्‍सी नगीदा पिन्‍बा ठीक आहिन” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ओच्‍छे थे म्रिङम्‍हेमेसे “हिन्‍ना प्रभु, तसैनोन कोलागदेसे चबान लमा ताइबा भ्राइभ्रुइ नगीसेनोन चम्‍याङ्मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","येशूसे थे म्रिङम्‍हेमेदा “एसे चुह्रङ् भिबासे लमा एला झामेला ल्‍हुइग्‍याम म्‍हङ थोन्‍सी निसी जिन्‍बा मुला। दाहेन्‍से ए दिमरी निउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","थे म्रिङम्‍हेमे दिमरी धोमा झामेला ल्‍हुइग्‍याम म्‍हङ थोन्‍सी निसी जिन्‍बा मुबा, ओच्‍छे झामे चा खाटरी म्‍हेर्सी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","येशू टुरोस भिबा ग्‍लाग्‍याम थोन्‍सी सीदोन ओच्‍छे डेकापोलिस तबान गालील समुन्‍द्ररी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","थेरी म्‍हिगदेसे नाब्‍यङ आथेःबा खाग्‍ले म्‍हिदा येशू मुबा ग्‍लारी भसी, “थेदा थुर्सी खम्‍ना लपिन्‍गो” भिसी बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","येशूसे थे म्‍हिदा म्‍हिला हुलग्‍याम जजाकी क्‍याथाङ भोर्सी थेला नाब्‍यङ न्‍हीरी या जुम्‍बी झाङ्‌जी। ओच्‍छे सरी थो स्‍वासी यासे थेला लेरी थुर्जी। ");
INSERT INTO taj_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","जमाहेन्‍से येशूसे स्‍वर्गपट्टि स्‍हीबान सा न्‍हसी, “इफ्‍फाता” भिसी सुङ्जी। चु भिबा चा “ठोङ्‍गो” भिबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","चुह्रङ् भिमैछ्‌याम थे म्‍हिला नाब्‍यङ थेःजी ओच्‍छे थेसे ज्‍यना लसी ताम पाङ्‌बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","येशूसे थेनीगदे जम्‍मादान “चु ताम खालैदा थापाङ्‍गो” भिसी कुल्‍जी। तर जति जति चु ताम खालैदा थापाङ्‍गो भिसी कुल्‍जी, झन ओतेन म्‍हिगदेसे पाङ्‌बान भ्रजी। ");
INSERT INTO taj_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","चु ताम थेःबागदेसे उदेक म्‍हन्‍सी, “येशूसे लबा जम्‍मान गे ज्‍यबा मुला। थेसे नाब्‍यङ आथेःबा खाग्‍ले म्‍हिदाएनोन खम्‍ना लमुला” भिसी भिबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","तिगै धिन लिच्‍छा दोःसी म्‍हिला हुल पोप तजी। थेनीगदेदेन छ्‌याम चबा स्‍हे तिगै आरेबासे लमा येशूसे ह्राङला चेलागदेदा ङ्‌योइसी, ");
INSERT INTO taj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“चु म्‍हिगदेदा म्राङ्सी ङादा दया रेःजी। तिग्‍दा भिसम चुगदे ङादेन छ्‌याम भ्रबा तिनी सोमरे तजी। ओच्‍छे चुगदेदेन छ्‌याम चबा स्‍हे तिगै आरे। ");
INSERT INTO taj_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","चु म्‍हिगदेदा फोइथाननोन दिमरी पुइजी भिसम ग्‍यामरी बिहोस तला। तिग्‍दा भिसम कोइ कोइ म्‍हिगदे ल्‍हानान थारेङग्‍याम खबा मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","जमाहेन्‍से चेलागदेसे येशूदा “चुह्रङ्बा तिगै आयाङ्बा ग्‍लारी चु म्‍हिगदेदा खानङग्‍याम गेङ भसी ख्‍वासे?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","येशूसे थेनीगदेदा “एनीगदेदेन छ्‌याम गेङ गाते मुला?” भिसी ङ्‌योइमा, थेनीगदेसे “ङन्‍देन छ्‌याम गोर निस गेङ मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","जमाहेन्‍से येशूसे थेरी मुबा म्‍हिला हुलदा पाङरी चिपुङ्जी। ओच्‍छे थेसे गोर निस गेङ थोसी परमेश्‍वरदा धन्‍यवाद पिन्‍सी गेङ क्‍युइसी चेलागदेदा भो लसी पिन्‍गो भिसी सुङ्जी, ओच्‍छे चेलागदेसे म्‍हिगदेदा भो लसी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","थेनीगदेदेन छ्‌याम जजाबा तार्ङागदेएनोन मुबा। येशूसे तार्ङाला लागिरीनोन धन्‍यवाद पिन्‍सी चेलागदेदा भो लपुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ओच्‍छे म्‍हिगदेसे म्रेन्‍ना चजी। जमाहेन्‍से चेलागदेसे लेङ्बा गेङदेन तार्ङा दुइमा सोली निस तजी। ");
INSERT INTO taj_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","थेरी गेङ चबा म्‍हिगदे हजार ब्‍लि ते मुबा। येशूसे म्‍हिला हुलदा पुइसी, ");
INSERT INTO taj_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ह्राङला चेलागदेदेन छ्‌याम दोँगारी क्रेःसी दलमनुथा भिबा ग्‍लारीक्‍यार फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","फरिसीगदे येशू मुबा ग्‍लारी खसी चुह्रङ् भिसी ताम लबारी छ्‌याइजी। ओच्‍छे येशूला सेम च्‍याबान, “ङन्‍दा स्‍वर्गला चिनु गिक उन्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","चु ताम थेःसी येशूसे सा न्‍हसी, “एनीगदेसे ङाला ताम ङ्‌यान्‍गो, दान्‍देला म्‍हिगदेसे तिग्‍दा चिनु म्‍हाइबा? तर ङाइ दान्‍देला म्‍हिगदेदा तिगै चिनु आउन” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ओच्‍छे थेनीगदेदा ख्‍लासी दोँगारी क्रेःसी येशू क्‍याम्‍सङपट्टि फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","दोँगारी क्रेःसी समुन्‍द्रला क्‍यामसङपट्टि निबा धुइरी चेलागदेसे गेङ भोर्बारी म्‍लेःबा मुबा। थेनीगदेदेन छ्‌याम गेङ गिक जे मुबा। ");
INSERT INTO taj_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ओच्‍छे येशूसे थेनीगदेदा “च्‍यागो, एनीगदे फरिसीदेन हेरोद ग्‍लेला खमीरग्‍याम होशियार तसी चिउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","तर चेलागदेसे चा “य्‍हाङदेन छ्‌याम गेङ आरेबासे लमा येशूसे चुह्रङ् भिसी सुङ्बा हिन्‍ना” भिसी ह्राङ ह्राङ न्‍हङरी ताम लबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","चेलागदेसे चुह्रङ् लसी ताम लबा था याङ्सी येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदे गेङ आरे भिसी तिग्‍दा ताम लसी चिबा? एनीगदेसे अझ घोबा आरे? एनीगदेला सेम कोङ्बान मुला? ");
INSERT INTO taj_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","मी मुसैनोन एनीगदेसे तिग्‍दा आम्राङ्बा? नाब्‍यङ मुसैनोन तिग्‍दा आथेःबा? अझ एनीगदेसे ढन्‍बा आरे? ");
INSERT INTO taj_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ङाइ गोर ङा गेङसे हजार ङा म्‍हिगदेदा ख्‍वामा एनीगदेसे लेङ्बा गेङ गाते सोली दुइबा मुबा?” थेनीगदेसे “च्‍युक न्‍ही सोली” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ओच्‍छे “ङाइ गोर निस गेङसे हजार ब्‍लि म्‍हिगदेदा ख्‍वामा एनीगदेसे लेङ्बा गेङ गाते सोली दुइमुबा?” भिसी येशूसे ङ्‌योइमा, थेनीगदेसे “सोली निस” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","जमाहेन्‍से येशूसे थेनीगदेदा “थेह्रङ् भिसम अझ एनीगदेसे तिग्‍दा आघोबा?” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","येशू ह्राङला चेलागदेदेन छ्‌याम बेथसेदा भिबा ग्‍लारी धोखमा म्‍हिगदेसे मी आम्राङ्बा म्‍हि गिकदा येशू मुबा ग्‍लारी भसी, “चुदा थुर्सी पिन्‍गो” भिसी बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","येशूसे थे मी आम्राङ्बा म्‍हिदा नाम्‍साग्‍याम क्‍याथाङ भोर्सी थे मी आम्राङ्बा म्‍हिला मीरी थो स्‍वाजी ओच्‍छे यासे थुर्सी, “एसे तिगै म्राङ्जी?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","थे मी आम्राङ्बा म्‍हिसे ओसो च्‍यासी, “ङाइ म्‍हिगदेदा दोङ भ्रबा ह्रङ् लसी क्‍युर्सीन भ्रबा म्राङ्बा मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","येशूसे दोःसी थे मी आम्राङ्बा म्‍हिला मीरी ह्राङला यासे थुर्जी। जमाहेन्‍से थेसे म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","जमाहेन्‍से थे म्‍हिदा येशूसे नाम्‍सारी आवाङ्ना दिमरी निउ भिसी पुइजी। ");
INSERT INTO taj_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","जमाहेन्‍से येशू ह्राङला चेलागदेदेन छ्‌याम कैसरिया फिलिप्‍पी भिबा ग्‍लाला नाम्‍सारीक्‍यार फेप्‍जी। थेनीगदे ग्‍यामरी फेप्‍बान लमा येशूसे ह्राङला चेलागदेदा “म्‍हिगदेसे ङादा खाल भिमुला?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","थेनीगदेसे “खालैसे बप्‍तिस्‍मा पिन्‍बा यूहन्‍ना, खालैसे एलिया, ओच्‍छे गाते म्‍हिसे चा अगमवक्तागदे न्‍हङला गिक हिन्‍ना भिमुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“तर एनीगदेसे चा ङा खाल भिसी म्‍हन्‍मुला?” भिसी येशूसे ङ्‌योइमा, पत्रुससे “ह्राङ परमेश्‍वरला म्‍हि थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","येशूसे थेनीगदेदा “च्‍यागो, एनीगदेसे चु ताम खालैदा थापाङ्‍गो” भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","जमाहेन्‍से येशूसे ह्राङला चेलागदेदा “परमेश्‍वरसे पुइखबा म्‍हिसे ल्‍हानान दुख नातोःला। थेदा यहूदी गन्‍बागदेसे, परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेसे ओच्‍छे यहूदी धर्मगुरुगदेसे बिरोध लसी साइला। तसैनोन थे सिबाग्‍याम सोमरेमाकुनु सोला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","येशूसे चुह्रङ् भिसी ह्राङला चेलागदेदा घोना लमाहेन्‍से पत्रुससे येशूदा जजाकी क्‍याथाङ भोर्सी, “चुह्रङ् थासुङ्‍गो” भिसी बङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","तर येशू स्‍य्‍हान्‍दो चेलागदेपट्टि फ्‍लिक दोःसी थेनीगदेदा स्‍हीबान पत्रुसदा “शैतान ए चुग्‍याम थोन्‍सी निउ! एसे म्‍हन्‍बा ताम परमेश्‍वरला आहिन, म्‍हिला हिन्‍ना” भिसी बङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","जमाहेन्‍से येशूसे ह्राङला चेलागदेदेन थेरी मुबा म्‍हिगदेदा ङ्‌योइसी, “खालै म्‍हि ङाला चेला दोबा सेम मुसम थेसे ह्राङला ज्‍याननोन माया मारब लसी ह्राङला क्रुस ह्राङसेन पुइसी ङादेन छ्‌याम भ्रगै” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","तिग्‍दा भिसम जुन म्‍हिसे ह्राङला ज्‍यान जोगब लबारी म्‍हाइला थे म्‍हिसे जुकजुकधोनाला जुनी आयाङ्, तर ङादेन थार्बा पिन्‍बा समाचारला लागिरी ज्‍याननोन पिन्‍खम्‍बा म्‍हिसे चा जुकजुकधोनाला जुनी याङ्ला। ");
INSERT INTO taj_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","म्‍हिसे जम्‍बुलिङनोन यारी किन्‍सी ह्राङला ज्‍यान चा निजी भिसम थेदा तिग ज्‍यबा तला? ");
INSERT INTO taj_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","जम्‍बुलिङरी म्‍हिला ज्‍यान भन्‍दा घ्रेन अर्गु तिगै स्‍हे मुला? ");
INSERT INTO taj_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ओच्‍छे दान्‍दे पापीदेन नइबा बानीबेहोर थोसी भ्रबा म्‍हिगदेला ओन्‍छाङरी जुन म्‍हि ङादेन ङाला तामरी पेःला लिच्‍छा परमेश्‍वरला स्‍वर्गदूतगदेदेन छ्‌याम परमेश्‍वरसे पुइखबा म्‍हि ह्राङला आबा परमेश्‍वरला य्‍हालदेन शक्तिरी खमा थेदा ह्राङला भिबारी पेःला। ");
INSERT INTO taj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ओच्‍छे येशूसे थेनीगदेदा “च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, चुरी मुबा म्‍हिगदे न्‍हङला कोइ कोइ म्‍हि चा परमेश्‍वरला य्‍हुल्‍सा शक्तिरी खबा आम्राङ्तेधोना आसि” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ढुरे लिच्‍छा येशूसे पत्रुस, याकूबदेन यूहन्‍नादा जे ह्राङदेन छ्‌याम नोबा गङरी भोर्सी फेप्‍जी। ओच्‍छे चेलागदेसे च्‍याना च्‍यानान येशूला स्‍य्‍हाल पोजी। ");
INSERT INTO taj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","येशूला क्‍वान धिनीला स्‍हेर ह्रङ्‌बान य्‍हाल य्‍हाल तसी चुदे य्‍हाल य्‍हाल तजी कि ओते तार मी जम्‍बुलिङला खजिबै म्‍हिसे ख्रुसैनोन तना लआखम। ");
INSERT INTO taj_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","थे धुइरी थेनीगदेसे एलियादेन मोशा, येशूदेन छ्‌याम ताम लबान लबा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","चु म्राङ्सी पत्रुससे येशूदा “गुरु, ङनीएनोन चुरी मुबा ज्‍यबा तजी। दाहेन्‍से ङन्‍से चुरी छाप्रो सोम स्‍होइ, गिक ह्राङला लागिरी, गिक मोशाला लागिरी ओच्‍छे गिक एलियाला लागिरी” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","थेनीगदे लोङ्बासे लमा पत्रुसदा तिग भितोःबा था आरेबा। ");
INSERT INTO taj_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","थे धुइरी खसु खसी थेनीगदेदा घप्‍जी। ओच्‍छे खसु न्‍हङ‍ग्‍याम चुह्रङ्बा काइ थेःजी, “चु ङाइ सेमहेन्‍से माया लबा ङाला झा हिन्‍ना, चुसे भिबा ताम एनीगदेसे ङ्‌यान्‍गो।” ");
INSERT INTO taj_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","चुह्रङ् भिबा थेःसी थेनीगदेसे क्‍यारमार च्‍यामा थेरी येशू बाहेक खालैदा आम्राङ्‌नी। ");
INSERT INTO taj_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","जमाहेन्‍से येशू ह्राङला चेलागदेदेन छ्‌याम गङग्‍याम फाप्‍बान लबा धुइरी येशूसे चेलागदेदा “परमेश्‍वरसे पुइखबा म्‍हि सिबाग्‍याम आसोतेधोना एनीगदेसे तिनी म्राङ्बा चु ताम खालैदा थापाङ्‍गो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","थेनीगदेसे येशूसे सुङ्बा ताम सेमरी थान्‍जी। तर थेनीगदेसे चु सिबा ग्‍याम सोबा भिबा चा तिग हिन्‍ना भिसी ह्राङ ह्राङ न्‍हङरी ताम लजी। ");
INSERT INTO taj_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","थेनीगदेसे येशूदा “यहूदी धर्मगुरुगदेसे तिग्‍दा एलिया अगमवक्ता ङाच्‍छा खतोःला भिबा?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “हिन्‍ना, ङाच्‍छा एलिया खला ओच्‍छे थेसे जम्‍मान ताम ढिक्‍ना लला। तर परमेश्‍वरसे पुइखबा म्‍हिसे ल्‍हानान दुख नातोःला ओच्‍छे जम्‍मान म्‍हिगदेसे थेदा ख्‍लाला भिसी तिग्‍दा भ्रिबा? ");
INSERT INTO taj_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","तर च्‍यागो, एलिया मी खसी जिन्‍बा मुला। ओच्‍छे परमेश्‍वरला बचनरी भ्रिबा अन्‍छार थेदा म्‍हिगदेसे जे लइ म्‍हन्‍बा थेनोन लजी।” ");
INSERT INTO taj_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","थेनीगदे स्‍य्‍हान्‍दो चेलागदे मुबा ग्‍लारी धोखमा क्‍युर्नोन म्‍हिला हुल मुबा। ओच्‍छे यहूदी धर्मगुरुगदे थेरी चेलागदेदेन छ्‌याम छलफल लबान मुबा। ");
INSERT INTO taj_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","म्‍हिगदेसे येशूदा म्राङ्मैछ्‍याम उदेक म्‍हन्‍सी यार्बान निसी येशूदा फ्‍या लजी। ");
INSERT INTO taj_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","येशूसे थेनीगदेदा “एनीगदे तिग ताम लबान मुला?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","म्‍हिला हुल न्‍हङ‍ग्‍याम म्‍हि गिकसे बिन्‍ती लबान येशूदा “गुरु, ङाइ ङाला झा ह्राङ मुबा ग्‍लारी भबा मुला। म्‍हङसे स्‍याप्‍बासे लमा थेसे ताम पाङ्‌आखम्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","थेदा म्‍हङसे भ्‍याङ्‍बा धुइरी थेसे सुङग्‍याम बोप्‍स्‍या तेःमुला। ओच्‍छे स्‍वा क्रेसी कक्‍रक कुक्‍रूक तमुला। ङाइ ह्राङला चेलागदेदा थेला ल्‍हुइग्‍याम म्‍हङ ताप्‍सी पिन्‍गो भिसी बिन्‍ती लजी, तर थेनीगदेसे आखम्‍नी” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","येशूसे थेनीगदेदा “विश्‍वास आलबा म्‍हिगदे, खाइमाधोना ङा एनीगदेदेन छ्‌याम तला? खाइमाधोना ङाइ एनीगदेदा नासे? थेदा ङा मुबा ग्‍लारी भउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","थेनीगदेसे थे म्‍हङसे स्‍याप्‍बा कोलादा येशू मुबा ग्‍लारी भजी। येशूदा म्राङ्मैछ्‍याम थे म्‍हङसे थे कोलादा लछार पछार लसी सरी ह्रिल्‍ना लजी। ओच्‍छे सुङग्‍याम बोप्‍स्‍या तेःबान कक्‍रक कुक्‍रूक तना लजी। ");
INSERT INTO taj_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ओच्‍छे येशूसे थे म्‍हङसे स्‍याप्‍बा कोलाला आबादा “खाइमाहेन्‍से चुह्रङ् तबा?” भिसी ङ्‌योइजी। थेला आबासे येशूदा चुह्रङ् भिसी भिजी, “चुदा जजाहेन्‍सेन चुह्रङ् तबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","थेदा साइबारी म्‍हङसे घरिघरि मेरी, क्‍युइरी भ्‍याङ्‍बा मुला। गुरु, ह्राङसे खम्‍सम ङन्‍दा दया लसी खम्‍ना लपिन्‍गो।” ");
INSERT INTO taj_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","येशूसे थेदा “खम्‍सम भिसी तिग्‍दा भिबा? विश्‍वास लबादा जम्‍मान तखम्‍ला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","येशूसे चुह्रङ् सुङ्माहेन्‍से थे म्‍हङसे स्‍याप्‍बा कोलाला आबासे क्रिङ्बान भिजी, “गुरु, ङाइ विश्‍वास लला। विश्‍वास लबारी ङादा ह्रो लउ।” ");
INSERT INTO taj_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","म्‍हिला हुल ह्राङ मुबापट्टि यार्बान खबा म्राङ्सी येशूसे म्‍हङदा “ताइधोना लबादेन नाब्‍यङ थेःना आलबा म्‍हङ ए थे कोलाला ल्‍हुइग्‍याम थोन्‍सी निउ! दोःसी खाइमै चु कोलाला ल्‍हुइरी थावाङ्‍गो” भिसी बङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","जमाहेन्‍से थे म्‍हङ क्रिङ्सी थे कोलादा लछार पछार लबान थोन्‍सी निजी। म्‍हङ थोन्‍सी निबा धुइरी थे कोला सिबा तेबान तजी। ओच्‍छे थेरी मुबा ल्‍हानान म्‍हिगदेसे सिजीम भिसी म्‍हन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","तर येशूसे थेला यारी चुङ्सी थीमाहेन्‍से थे डोङ रेःजी। ");
INSERT INTO taj_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","दिम न्‍हङरी वाङ्माहेन्‍से खालै आरेबा धुइरी येशूदा चेलागदेसे “तिग्‍दा ङन्‍से थे म्‍हङदा ताप्‍बारी आखम्‍नी” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","येशूसे ह्राङला चेलागदेदा “चुह्रङ्बा म्‍हङदा चा प्रार्थनाग्‍यामसे जे ताप्‍खम्‍ला, तर अर्गु तिगै लसी ताप्‍आखम” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","येशूदेन थेला चेलागदे थे ग्‍ला ख्‍लासी गालील अञ्‍चलग्‍याम तबान फेप्‍जी। ह्राङ खानङ मुला भिसी म्‍हिगदेसे था थायाङ्‍गै भिबा येशूला सेम मुबा। ");
INSERT INTO taj_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","तिग्‍दा भिसम येशूसे ह्राङला चेलागदेदा लोप्‍बान मुबा। थे धुइरी येशूसे थेनीगदेदा “परमेश्‍वरसे पुइखबा म्‍हिदा चुङ्सी म्‍हिगदेला यारी जिम्‍मा पिन्‍ना। थेनीगदेसे थेदा साइला, तसैनोन सोमरेमाकुनु थे सिबाग्‍याम सोला” भिसी सुङ्जी ");
INSERT INTO taj_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","तर चेलागदेसे चु ताम आघोनी, ओच्‍छे दोःसी येशूदेन छ्‌याम चु ताम ङ्‌योइबारी थेनीगदे लोङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","थेनीगदे कफर्नहुम नाम्‍सारी धोमाहेन्‍से जम्‍मान दिमरी मुबा धुइरी येशूसे चेलागदेदा “दोलो एनीगदे ग्‍यामरी तिग ताम लबान मुबा?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","तर थेनीगदे कुटिसी चिजी। तिग्‍दा भिसम थेनीगदेसे “य्‍हाङ न्‍हङला खाल घ्रेन हिन्‍ना” भिसी ह्राङ ह्राङ न्‍हङरी ताम लबा मुबा। ");
INSERT INTO taj_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ओच्‍छे येशू धन्‍छ्‌यासी ह्राङला च्‍युक न्‍ही चेलागदेदा ङ्‌योइसी, “खालै घ्रेन दोबा सेम मुसम थे जम्‍मान भन्‍दा जजा तसी जम्‍मालान सेवा लतोःला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","जमाहेन्‍से येशूसे थेनीगदेला गुङरी कोला गिकदा भजी। ओच्‍छे थे कोलादा ह्राङला कुरी किन्‍सी चेलागदेदा, ");
INSERT INTO taj_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“ङाला मिनरी चुह्रङ्बा कोलागदेदा वास्‍ता लबासे ङादा वास्‍ता लला, ओच्‍छे ङादा वास्‍ता लबासे ङादा जे आहिन, ङादा पुइखबा ङाला आबादाएनोन वास्‍ता लला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","जमाहेन्‍से यूहन्‍नासे येशूदा “गुरु, ङन्‍से ह्राङला मिनरी म्‍हि गिकसे म्‍हङ ताप्‍बा म्राङ्जी। तर ङन्‍से थेदा थेह्रङ् लआपुङ्नी तिग्‍दा भिसम थे म्‍हि य्‍हाङदेन छ्‌याम भ्रबा म्‍हि आहिन” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदेसे थेदा थेह्रङ् थालउ। तिग्‍दा भिसम ङाला मिनरी उदेकला गे लबासे खाइमै ङाला बिरोध आल। ");
INSERT INTO taj_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","य्‍हाङदा बिरोध आलबा म्‍हि चा य्‍हाङपट्टिला हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","च्‍यागो, खालैसे एनीगदेदा थार्बा पिन्‍बा ख्रीष्‍टदा विश्‍वास लबा म्‍हि भिसी क्‍युइ जे थुङ्बारी पिन्‍सैनोन थे म्‍हिसे याङ्तोःबा इनाम याङ्ला।” ");
INSERT INTO taj_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","दोःसी येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “जुन म्‍हिसे ङादा विश्‍वास लबा चु कोलागदे न्‍हङला गिकदा पाप लपुङ्ला, थेह्रङ्बा म्‍हिदा मी खारेरी ह्रान्‍दा च्‍योसी समुन्‍द्ररी भ्‍याङ्‍बा ज्‍यबा तला। ");
INSERT INTO taj_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","चुदे एला यासे पाप लपुङ्जी भिसम थे थासी भ्‍याङ्‍गो। या न्‍ही मुसी नर्गरी खाइमै आसिबा मेरी निबा भन्‍दा बरु ठुडे तसी जुकजुकधोनाला जुनी याङ्बा चा एला लागिरी ज्‍यबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","नर्गरी न्‍ह च्‍योलोङ सिला न्‍ह मेनोन सिला। ");
INSERT INTO taj_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ओच्‍छे एला काङसे एदा पाप लपुङ्जी भिसम थे थासी भ्‍याङ्‍गो। काङ न्‍ही मुसी नर्गरी निबा भन्‍दा बरु कुज्‍या तसी जुकजुकधोनाला जुनी याङ्बा चा एला लागिरी ज्‍यबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","नर्गरी न्‍ह च्‍योलोङ सिला, न्‍ह मेनोन सिला। ");
INSERT INTO taj_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","एला मीसे एदा पाप लपुङ्जी भिसम तेःसी भ्‍याङ्‍गो मी न्‍ही मुसी नर्गरी निबा भन्‍दा मी गिक तेःसी भ्‍याङ्‍सी परमेश्‍वरला य्‍हुल्‍सारी वाङ्बा एदा ज्‍यबा तला। ");
INSERT INTO taj_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","नर्गरी न्‍ह च्‍योलोङ सिला, न्‍ह मेनोन सिला। ");
INSERT INTO taj_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","जम्‍मान म्‍हिगदेदा मेसे खारेब लसी चजा ङम्‍बा ह्रङ्‌बा दोना लला। ");
INSERT INTO taj_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","चजा ज्‍यबा स्‍हे हिन्‍ना, तर चजाला ङम्‍बा म्‍हाजी भिसम थे दोःसी तिग्‍से ङम्‍ना लबा? थेतबासेलमा एनीगदेसेनोन ह्राङ ह्राङ न्‍हङरी चजा थान्‍गो ओच्‍छे ह्राङ ह्राङ न्‍हङरी ढिक्‍सी चिउ।” ");
INSERT INTO taj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","येशू थे ग्‍ला ख्‍लासी यर्दन स्‍योङला क्‍याम्‍सङपट्टि यहूदिया अञ्‍चलरी फेप्‍जी। थेरीनोन म्‍हिला हुल पोप तजी, ओच्‍छे येशूसे दोःसी ङाच्‍छाला ह्रङ् लसी थेनीगदेदा लोप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","फरिसीगदेसे येशूला सेम च्‍याबाला लागिरी येशूदा “खालै म्‍हिसे ह्राङला म्रिङदेन छोडपत्र लबारी तला कि आत?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","येशूसे थेनीगदेदा “एनीगदेदा मोशासे तिग भिसी कुल्‍बा मुला?” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","थेनीगदेसे, “खालैसे ह्राङला म्रिङदा ख्‍लातोःसम छोडपत्र भ्रिसी ख्‍लाबारी तला भिसी मोशासे पाङ्बा मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदेला सेम कोङ्बासे लमा मोशासे चुह्रङ् भिसी कुल्‍बा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","तर परमेश्‍वरसे जम्‍बुलिङ छ्‌यामाहेन्‍सेन थेनीगदेदा ह्रेम्‍कोलादेन म्रिङकोला लसी स्‍होबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘थेतबासेलमा म्‍हिसे ह्राङला आबादेन आमादा ख्‍लासी ह्राङला म्रिङदेन छ्‌याम ढिक्‍सी चिमुला। ");
INSERT INTO taj_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ओच्‍छे थेन्‍नी ल्‍हुइ गिक ह्रङ्‌बान तला’ दाहेन्‍से थेन्‍नी न्‍ही आहिन, तर गिक ह्रङ्‌बान हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","थेतबासेलमा परमेश्‍वरसे स्‍होबा जोडीदा खालै म्‍हिसे थाफेगै।” ");
INSERT INTO taj_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","येशू ह्राङला चेलागदेदेन छ्‌याम दिमरी धन्‍छ्‌याबा धुइरी चेलागदेसे येशूदा थे तामला बारेरी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “खालै म्‍हिसे ह्राङला म्रिङदेन छ्‌याम छोडपत्र लसी स्‍य्‍हान्‍दो म्रिङम्‍हेमेदेन छ्‌याम ब्‍याह लजी भिसम ङाच्‍छाला म्रिङला बिरोधरी थे ब्रेल्‍सी भ्रबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ओच्‍छे थेह्रङ् लसी ह्राङला ह्रेम्‍बोदेन छ्‌याम छोडपत्र लसी स्‍य्‍हान्‍दो ह्रेम्‍फेबेदेन छ्‌याम ब्‍याह लजी भिसम थेएनोन ह्राङला ङाच्‍छाला ह्रेम्‍बोला बिरोधरी ब्रेल्‍सी भ्रबा हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","येशूसे ह्राङला छ्‌या कोलागदेथोरी थान्‍सी मोलम पिन्‍गै भिसी म्‍हिगदेसे ह्राङला कोलागदेदा येशू मुबा ग्‍लारी भजी। तर येशूला चेलागदेसे थे कोलागदे भबा म्‍हिगदेदा बङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","चेलागदेसे चुह्रङ् लबा म्राङ्सी येशूदा बोमो रेःजी। ओच्‍छे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “कोलागदेदा ङा मुबा ग्‍लारी खपुङ्‍गो, थेनीगदेला ग्‍याम थाकागो। तिग्‍दा भिसम परमेश्‍वरला य्‍हुल्‍सा चु कोलागदे ह्रङ्बालान हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","एनीगदेसे ङाला ताम ङ्‌यान्‍गो, जुन म्‍हिसे चु कोलागदेसे ह्रङ् लसी परमेश्‍वरला य्‍हुल्‍सादा विश्‍वास आल थे म्‍हि परमेश्‍वरला य्‍हुल्‍सारी खाइमै वाङ्‌आम्‍याङ्। ");
INSERT INTO taj_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","जमाहेन्‍से येशूसे कोलागदेदा ह्राङला कुरी किन्‍सी थेनीगदेथोरी ह्राङला छ्‌या थान्‍सी मोलम पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","येशू ग्‍यामरी फेप्‍बान लबा धुइरी म्‍हि गिक यार्बान खसी पुइ जूबान येशूदा “ज्‍यबा गुरु, जुकजुकधोनाला जुनी याङ्बाला लागिरी ङाइ तिग लतोःला?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","येशूसे थेदा चुह्रङ् भिसी सुङ्जी, “एसे ङादा तिग्‍दा ज्‍यबा भिबा? परमेश्‍वर बाहेक खालै ज्‍यबा आरे। ");
INSERT INTO taj_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","परमेश्‍वरसे कुल्‍बा ताम एदा थानोन मुला। म्‍हि थासाइगो, स्‍य्‍हान्‍दोदेन छ्‌याम ब्रेल्‍सी थाभ्रउ, य्‍हो थालउ, लुसीला ताम पाङ्सी थाभ्रउ, ठगब थालउ, ओच्‍छे ह्राङला आबा आमादा मान लउ।” ");
INSERT INTO taj_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","थेसे येशूदा “प्रभु, चु गे मी ङाइ जत्‍धुगुहेन्‍सेन लबान मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","येशूसे थेदा स्‍हीबान माया लसी चुह्रङ् भिसी सुङ्जी, “अझन एसे गे गिक लतोःबा मुला। दाहेन्‍से ए निसी एला जम्‍मान धन सम्‍पत्ति चूङ्सी प्राङबोगदेदा भो लसी पिन्‍गो। एसे स्‍वर्गरी धन सम्‍पत्ति याङ्ला, ओच्‍छे ङादेन छ्‌याम भ्रउ।” ");
INSERT INTO taj_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","चु तामसे थेला ली धोपधोप तजी। ओच्‍छे दुख ङ्‍हम्‍सी निजी। तिग्‍दा भिसम थेदेन छ्‌याम ल्‍हानान धन सम्‍पत्ति मुबा। ");
INSERT INTO taj_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","येशूसे क्‍युर्नोन स्‍हीसी ह्राङला चेलागदेदा “फ्‍युक्‍पो म्‍हिदा परमेश्‍वरला य्‍हुल्‍सारी वाङ्बारी गाते गाह्रो मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","चुह्रङ्बा तामसे चेलागदे उदेक म्‍हन्‍जी। तर येशूसे अझ थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “च्‍यागो कोलागदे, धन सम्‍पत्तिथोरी भर लबा म्‍हिगदेदा परमेश्‍वरला य्‍हुल्‍सारी वाङ्बारी गाते गाह्रो मुला? ");
INSERT INTO taj_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","फ्‍युक्‍पो म्‍हिदा परमेश्‍वरला य्‍हुल्‍सारी वाङ्बारी भन्‍दा बरु ऊँटदा दापला मीग्‍याम वाङ्बारी सजिलो तला।” ");
INSERT INTO taj_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","चु ताम थेःसी चेलागदे झन उदेक म्‍हन्‍सी, “थेह्रङ् भिसम खाल्‍से थार्बा याङ्ला?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","येशूसे थेनीगदेदा स्‍हीबान, “चु गे म्‍हिसे लबारीन आखम्‍बा गे हिन्‍ना, तर परमेश्‍वरसे खम्‍ला, तिग्‍दा भिसम परमेश्‍वरसे लआखम्‍बा गे तिगै आरे” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","जमाहेन्‍से पत्रुससे येशूदा “ङन्‍से ङन्‍ना जम्‍मान स्‍हे ख्‍लासी ह्राङदेन छ्‌याम भ्रबा मुला” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","येशूसे चुह्रङ् भिसी सुङ्जी, “च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, खालैसे ङादेन थार्बा पिन्‍बा समाचारला लागिरी ह्राङला आबा आमा, झा झामे, ज्‍योज्‍यो आले, नाना आङा, दिमनाम ख्‍लाला, ");
INSERT INTO taj_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","थेसे नाबा दुखदेन छ्‌यामनोन दान्‍देन थे भन्‍दा ल्‍हाना दिमनाम, आबा आमा, झा झामे, ज्‍योज्‍यो आले, नाना आङा याङ्ला। ओच्‍छे खबा धुइरी थेसे जुकजुकधोनाला जुनी याङ्ला। ");
INSERT INTO taj_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","तर दान्‍दे ङाच्‍छा मुबागदे न्‍हङला ल्‍हानान म्‍हि लिच्‍छा तला, दान्‍दे लिच्‍छा मुबागदे चा ङाच्‍छा तला।” ");
INSERT INTO taj_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","थेनीगदे यरूशलेमपट्टि फेप्‍बान लबा धुइरी येशू चेलागदे भन्‍दा ङाच्‍छा ङाच्‍छा भ्रबान मुबा। ओच्‍छे चेलागदे उदेक तजी, तर स्‍य्‍हान्‍दो लिच्‍छा भ्रबा म्‍हिगदे चा लोङ्जी। दोःसीनोन येशूसे ह्राङला च्‍युक न्‍ही चेलागदेदा कुनी गिकरी भोर्सी ह्राङथोरी तिग तला भिबा तामला बारेरी चुह्रङ् भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","34","“च्‍यागो, दान्‍दे य्‍हाङ यरूशलेमपट्टि निबान मुला। परमेश्‍वरसे पुइखबा म्‍हिदा परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी धर्मगुरुगदेला यारी जिम्‍मा पिन्‍ना। जमाहेन्‍से थेनीगदेसे साइनोन तोःला भिसी अर्गु य्‍हुलला म्‍हिगदेला यारी जिम्‍मा लला। ओच्‍छे थेनीगदेसे थेदा थो स्‍वासी खिसी लला ओच्‍छे कोर्रासे तोसी साइला। तसैनोन थे सोमरेमाकुनु सिबाग्‍याम सोला।” ");
INSERT INTO taj_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","जमाहेन्‍से जब्‍दियाला झा याकूबदेन यूहन्‍ना येशू मुबा ग्‍लारी खसी, “गुरु, ङन्‍से ह्रीबा स्‍हे पूरा लसी पिन्‍गो भिबा ङन्‍ना सेम मुला” भिसी थेनीगदेसे बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“ङाइ एनीगदेला लागिरी तिग लतोःजी?” भिसी येशूसे थेनीगदेदा ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","“ह्राङ स्‍वर्गला य्‍हाल य्‍हाल्‍बा मान याङ्बा ठिरी धन्‍छ्‌यामा ङनी ज्‍योज्‍यो आलेदा ह्राङला दाहिनेपट्टिदेन देब्रेपट्टि चिपुङ्‍गो” भिसी थेनीगदेसे भिजी। ");
INSERT INTO taj_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","“तिग ह्रीदोबा भिसी एनीगदेदा थानोन आरे। ङाइ नाबा दुख एनीगदेसे नाबारी खम्‍ला? ङाइ किन्‍बा बप्‍तिस्‍मा एनीगदेसे किन्‍खम्‍ला?” भिसी येशूसे थेनीगदेदा सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","जमाहेन्‍से थेनीगदेसे येशूदा “खम्‍ला” भिसी भिजी। जमाहेन्‍से येशूसे चुह्रङ् भिसी सुङ्जी, “एनीगदेसे ङाइ नाबा दुख मी नाला, ओच्‍छे ङाइ किन्‍बा बप्‍तिस्‍माएनोन एनीगदेसे किन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","तर ङाला दाहिने देब्रे चिपुङ्बा अधिकार ङाला यारी आरे। चु ग्‍ला परमेश्‍वरसे जुन म्‍हिला लागिरी स्‍होबा हिन्‍ना थे जे चिम्‍याङ्ला।” ");
INSERT INTO taj_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","चु ताम थेःसी चेला च्‍युइदा चा याकूब, यूहन्‍ना म्राङ्सी बोमो रेःजी। ");
INSERT INTO taj_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","तर येशूसे थेनीगदेदा ह्राङ मुबा ग्‍लारी ङ्‌योइसी चुह्रङ् भिसी सुङ्जी, “च्‍यागो, एनीगदेदा चु ताम थानोन मुला, अर्गु य्‍हुलला शासन लबा म्‍हिगदेसे ह्राङला सेमसे म्‍हन्‍बा अन्‍छार म्‍हिगदेथोरी शासन लमुला। ओच्‍छे घ्रेन घ्रेन पदरी मुबा म्‍हिगदेसे ह्राङ भन्‍दा धिरी मुबा म्‍हिगदेथोरी शासन लमुला। ");
INSERT INTO taj_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","तर एनीगदे चा थेह्रङ् तबारी आत। जुन म्‍हि जम्‍मान भन्‍दा घ्रेन दोबारी म्‍हाइला थेसे चा एनीगदेला सेवा लतोःला। ");
INSERT INTO taj_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","जुन म्‍हि जम्‍मान भन्‍दा ङाच्‍छा तबारी म्‍हाइला थे म्‍हि चा जम्‍मालान नोकर दोतोःला। ");
INSERT INTO taj_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","तिग्‍दा भिसम परमेश्‍वरसे पुइखबा म्‍हिएनोन स्‍य्‍हान्‍दोगदेग्‍याम सेवा किन्‍बारी आहिन, तर स्‍य्‍हान्‍दोगदेला सेवा लबारी ओच्‍छे ह्राङलान ज्‍यान पिन्‍सी ल्‍हानान म्‍हिगदेला पापला सय फाबारी खबा हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","येशू ह्राङला चेलागदेदेन छ्‌याम यरीहो नाम्‍सारी धोखजी। थे नाम्‍सा ख्‍लासी निबा धुइरी ल्‍हानान म्‍हिला हुल थेनीगदेदेन छ्‌याम छ्‌याम खजी। ग्‍यामला कुनीरी तिमैला झा बारतिमै भिबा मी आम्राङ्बा म्‍हि गिक ह्रीसी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","नासरतला येशू खबा थेःसी थेसे “दाऊद ग्‍लेला सन्‍तान येशू, ङादा दया लउ!” भिसी क्रिङ्बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ल्‍हानान म्‍हिगदेसे थेदा “कुटिसी चिउ” भिसी बङ्जी। तर झन थेसे “दाऊद ग्‍लेला सन्‍तान येशू, ङादा दया लउ!” भिसी क्रिङ्बान भिजी। ");
INSERT INTO taj_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","येशू थेन तसी, “थेदा चुरी ङ्‍योइगो!” भिसी सुङ्जी। ओच्‍छे थेनीगदेसे थे मी आम्राङ्बा म्‍हिदा ङ्‌योइसी, “भङ लउ, एदा येशूसे ङ्‍योइबान मुला, योनान रेःसी खउ।” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","जमाहेन्‍से थे मी आम्राङ्बा म्‍हि ह्राङला घ भ्‍याङ्‍सी छ्‌योङ्बान येशू मुबा ग्‍लारी खजी। ");
INSERT INTO taj_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","येशूसे थेदा “ङाइ एला लागिरी तिग लगै भिसी म्‍हन्‍बा मुला?” भिसी ङ्‌योइजी, थे मी आम्राङ्बा म्‍हिसे “गुरु, ङाला मी म्राङ्ना लसी पिन्‍गो” भिसी बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","येशूसे थेदा “एसे विश्‍वास लबासे लमा ए खम्‍बा मुला। दाहेन्‍से ए निउ” भिसी सुङ्जी। येशूसे थेह्रङ् सुङ्मैछ्‌याम थेसे म्राङ्जी ओच्‍छे येशूदेन छ्‌याम भ्रजी। ");
INSERT INTO taj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","येशूदेन थेला चेलागदे यरूशलेम ङामला जैतून गङला बेथफागेदेन बेथानिया भिबा नाम्‍सारी धोखमा येशूसे ह्राङला चेलागदे न्‍हङला न्‍हीदा पुइजी। ");
INSERT INTO taj_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","पुइबा धुइरी चुह्रङ् भिसी सुङ्जी, “एनी जजाकी क्‍याथाङला नाम्‍सारी निउ। नाम्‍सारी धोमैछ्‌याम एनीसे दान्‍देधोना खालै आक्रेःबा गधाला कोला गिक स्‍याप्‍ला। थेदा ब्‍लसी चुरी भसी खउ। ");
INSERT INTO taj_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","थेरी एनीदा खालैसे चु तिग लबा? भिसी ङ्‌योइसम, चु प्रभुदा तोःबा मुला, प्रभुसे योनान दोःसी पिन्‍ना भिउ” भिसी पुइजी। ");
INSERT INTO taj_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","थेनी निमा ग्‍याम ङामला दिमला ख्राङगारी गधाला कोला च्‍युन्‍सी थान्‍बा स्‍याप्‍जी। थेनीसे थे गधाला कोलादा ब्‍लबारी छ्‌याइमा, ");
INSERT INTO taj_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","थेरी राप्‍सी चिबा म्‍हिगदेसे “एनीसे थे गधाला कोलादा ब्‍लसी तिग लबारी छ्‌याइबा?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","येशूसे सुङ्बा ह्रङ्नोन चेला न्‍हीसे थेरी मुबा म्‍हिगदेदा भिजी, जमाहेन्‍से थे म्‍हिगदेसे गधाला कोला भोर्पुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","थे गधाला कोलादा चेला न्‍हीसे येशू मुबा ग्‍लारी भसी ह्राङ ह्राङला घ गधाला कोलाथोरी तीसी पिन्‍जी, ओच्‍छे येशू गधाला कोलाथोरी क्रेःजी। ");
INSERT INTO taj_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ल्‍हानान म्‍हिगदेसे ग्‍यामरी ह्राङ ह्राङला घगदे ती‍जी, ओच्‍छे स्‍य्‍हान्‍दोगदेसे चा भ्‍लेग्‍याम स्‍याउला भसी ती‍जी। ");
INSERT INTO taj_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","येशूला लिच्‍छा ङाच्‍छा भ्रबा म्‍हिगदेसे चुह्रङ् भिसी क्रिङ्बारी छ्‌याइजी “परमेश्‍वरदा जयजयकार तगै, परमप्रभुला मिनरी फेप्‍खबासे परमेश्‍वरग्‍याम मोलम याङ्‌गै। ");
INSERT INTO taj_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","य्‍हाङला आखे म्‍हेमे दाऊद ग्‍लेला खबा चु य्‍हुल्‍सादा परमेश्‍वरसे मोलम पिन्‍गै। ओच्‍छे स्‍वर्गरी धन्‍छ्‌याबा परमेश्‍वरला जयजयकार तगै।” ");
INSERT INTO taj_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","यरूशलेमरी धोखमाहेन्‍से येशू परमेश्‍वरला मन्‍दिर न्‍हङरी वाङ्‌जी। ओच्‍छे थेसे परमेश्‍वरला मन्‍दिरला क्‍युर्सीन स्‍हीजी। तर घइबासे लमा येशू ह्राङला च्‍युक न्‍ही चेलागदेदेन छ्‌याम बेथानिया नाम्‍सारी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","न्‍हङगरदङसे थेनीगदे बेथानियाग्‍याम यरूशलेमपट्टि फेप्‍बा धुइरी येशूदा फोख्रेन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","येशूसे जजाकी क्‍याथाङ अञ्‍जीरला दोङ गिक म्राङ्जी। थेरी अञ्‍जीर मुजी वा भिसी येशूसे स्‍हीबारी फेप्‍जी। तर थे दोङरी भानोन भा जे मुबा। तिग्‍दा भिसम थे धुइरी अञ्‍जीर रोबा धुइ तबा आरेबा। ");
INSERT INTO taj_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","जमाहेन्‍से येशूसे “दाहेन्‍से एग्‍याम रोबा अञ्‍जीर खाइमै खालैसे थाचगै” भिसी सुङ्जी। चु ताम थेला चेलागदेसे थेःजी। ");
INSERT INTO taj_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","येशू ह्राङला चेलागदेदेन छ्‌याम यरूशलेमरी धोमाहेन्‍से परमेश्‍वरला मन्‍दिर न्‍हङरी चूङ्बादेन ग्‍लुबागदेदा ताप्‍जी। थेसे थेरी चुङ्बा ग्‍लुबा लबा जम्‍मान व्‍यापारीगदेदा ताप्‍जी। ओच्‍छे टाङगा देप्‍बारी चिबागदेला टेबुलदेन ढुकुर चूङ्बारी चिबागदे जम्‍मालान चिबा ग्‍लागदे प्‍लाङ प्‍लिङ लसी भ्‍याङ्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","जमाहेन्‍से येशूसे परमेश्‍वरला मन्‍दिरग्‍याम खालैदा तिगै स्‍हे भोर्बारी आपिन्‍नी भबारीएनोन आपिन्‍नी। ");
INSERT INTO taj_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ओच्‍छे येशूसे जम्‍मान म्‍हिगदेदा लोप्‍बान, “तिग परमेश्‍वरला बचनरी चुह्रङ् भिबा आरे? ‘ङाला दिमदा य्‍हुल य्‍हुलला म्‍हिगदेसे प्रार्थना लबा दिम भिसी भिला।’ तर एनीगदेसे मी ङाला दिमदा य्‍होगदे चिबा ग्‍ला स्‍होबा मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","चु ताम परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी धर्मगुरुगदेसे थेःसी येशूदा खाह्रङ् लसी साइबा भिसी दाउ च्‍यासी भ्रबारी छ्‌याइजी। तिग्‍दा भिसम येशूसे लोप्‍बा तामरी जम्‍मान म्‍हिगदे उदेक म्‍हन्‍मुबा। थेतबासेलमा थेनीगदे येशूदेन छ्‌याम लोङ्मुबा। ");
INSERT INTO taj_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ङ्‍यसे तमाहेन्‍से येशू ह्राङला चेलागदेदेन छ्‌याम यरूशलेम शहरग्‍याम फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","न्‍हङगरदङ स्‍य्‍होरी थेनीगदे ङाच्‍छालाग्‍याम्‍से निबान लमा थेनीगदेसे थे अञ्‍जीर दोङ टाहेन्‍सेन खर्बा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","येशूसे थे अञ्‍जीर दोङदा केःबा ताम ढन्‍सी पत्रुससे “रब्‍बी, ह्राङसे केःबा थे अञ्‍जीरला दोङ मी सिजीम” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","येशूसे ह्राङला चेलागदेदा “परमेश्‍वरथोरी विश्‍वास लउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","दोःसी येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदेसे ङाला ताम ङ्‌यान्‍गो, चुदे एनीगदेसे सेमरी तिगै शङ्का आलना ह्राङला सेमरी म्‍हन्‍बा ताम पूरा तला भिसी विश्‍वास लसी चु गङदा ‘ए होक निसी समुन्‍द्ररी ताइगो’ भिजी भिसम एनीगदेला लागिरी थेह्रङ्नोन तला। ");
INSERT INTO taj_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","थेतबासेलमा एनीगदेसे प्रार्थना लमा तिग ह्रीबा मुला, थे ङाइ याङ्जी भिसी विश्‍वास लजी भिसम एनीगदेसे याङ्ला। ");
INSERT INTO taj_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","तर एनीगदेसे प्रार्थना लबारी छ्‌याइबा धुइरी खालैला बिरोधरी तिगै आज्‍यबा ताम मुसम थेदा माफ लउ। स्‍वर्गरी मुबा एनीगदेला परमेश्‍वर आबासेनोन एनीगदेला पाप माफ लला। ");
INSERT INTO taj_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","तर एनीगदेसे माफ आलनी भिसम स्‍वर्गरी मुबा एनीगदेला परमेश्‍वर आबासेनोन एनीगदेला पाप माफ आल। ");
INSERT INTO taj_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","दोःसी येशू ह्राङला चेलागदेदेन छ्‌याम यरूशलेम शहररी फेप्‍खजी। मन्‍दिररी भ्रबान लमा परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदे, यहूदी गन्‍बागदे ओच्‍छे यहूदी धर्मगुरुगदे येशू मुबा ग्‍लारी खसी, ");
INSERT INTO taj_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“ह्राङसे खानङग्‍याम अधिकार याङ्सी चु गे लबा हिन्‍ना? ह्राङदा चु अधिकार खाल्‍से पिन्‍बा हिन्‍ना?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","येशूसे थेनीगदेदा चुह्रङ् भिसी ङ्‌योइजी, “एनीगदेदाएनोन ङाइ ताम गिक ङ्‌योइला। थे तामला जोहाब पिन्‍जी भिसम ङादा चु गेगदे लबारी खाल्‍से अधिकार पिन्‍जी थे एनीगदेदा पाङ्ला। ");
INSERT INTO taj_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","यूहन्‍नासे पिन्‍बा बप्‍तिस्‍मा परमेश्‍वरग्‍याम मुबा कि म्‍हिग्‍याम मुबा? ङादा पाङ्‍गो।” ");
INSERT INTO taj_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","जमाहेन्‍से थेनीगदे ह्राङ ह्राङ न्‍हङरी ताम लसी, “चुदे य्‍हाङसे परमेश्‍वरग्‍याम भिजी भिसम थेसे य्‍हाङदा ‘थेह्रङ् भिसम एनीगदेसे तिग्‍दा यूहन्‍नादा विश्‍वास आलबा?’ भिसी भिला। ");
INSERT INTO taj_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","तर म्‍हिगदेग्‍याम भिबारीनोन आत।” थेनीगदे म्‍हिला हुल म्राङ्सी लोङ्जी। तिग्‍दा भिसम जम्‍मान म्‍हिगदेसे यूहन्‍नादा अगमवक्ता हिन्‍ना भिसी भिमुला। ");
INSERT INTO taj_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","थेतबासेलमा थेनीगदेसे “ङन्‍दा था आरे” भिसी येशूदा जोहाब पिन्‍जी। येशूसे थेनीगदेदा “थेह्रङ् भिसम ङाइएनोन चु गेगदे खाल्‍ला अधिकारग्‍याम लबा हिन्‍ना, थे एनीगदेदा आपाङ्” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","येशूसे थेनीगदेदा उखानग्‍याम चुह्रङ् भिसी सुङ्बारी छ्‌याइजी, “म्‍हि गिकसे वारीरी अङगुर सूसी क्‍युर्सीन पर्खाल लजी। ओच्‍छे अङगुर म्‍हर्बारी कोल स्‍होसी अङगुर वारी ख्रुङ्बारी नोबा छाप्रो गिक स्‍होजी। जमाहेन्‍से अधियाँरी पिन्‍सी थे अर्गु य्‍हुल्‍सारी निजी। ");
INSERT INTO taj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","अङगुर मिन्‍बा धुइ तमाहेन्‍से थे फ्‍युक्‍पो म्‍हिसे ह्राङला भो किन्‍बाला लागिरी अधियाँ लबागदे मुबा ग्‍लारी ह्राङला नोकरगदेदा पुइजी। ");
INSERT INTO taj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","तर थे अधियाँ लबागदेसे थेदा चुङ्सी तोबा ग्‍याङ्‍बा लसी तिगै आपिन्‍ना पुइजी। ");
INSERT INTO taj_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ओच्‍छे थेसे स्‍य्‍हान्‍दो नोकरदा पुइजी, तर थेनीगदेसे थेला थोबोरी तोसी बेइज्‍जत लसी पुइजी। ");
INSERT INTO taj_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","थेसे अझ स्‍य्‍हान्‍दो नोकरदा पुइजी। थेनीगदेसे थेदाएनोन साइजी। चुह्रङ् लसी थेनीगदेसे कोइदा साइबा कोइदा तोबा लजी। ");
INSERT INTO taj_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“दाहेन्‍से थेदेन छ्‌याम थेसे सेमहेन्‍सेन माया लबा झा गिक जे बाँकी मुबा। जम्‍मादान पुइसी जिन्‍माहेन्‍से ‘थेनीगदेसे ङाला झादा मी मान लला तला’ भिसी थेसे ह्राङला झादा थेनीगदे मुबा ग्‍लारी पुइजी। ");
INSERT INTO taj_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","तर अधियाँ लबागदेसे ‘चु मी य्‍हाङला धनीला झा हिन्‍ना, य्‍हाङसे थेदा साइगे। जमाहेन्‍से थेला सम्‍पत्ति य्‍हाङलान तला’ भिसी ह्राङ ह्राङ न्‍हङरी ताम लजी। ");
INSERT INTO taj_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ओच्‍छे थेनीगदेसे थेदा चुङ्सी साइसी थेदा वारीग्‍याम पाखारी भ्‍याङ्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“दाहेन्‍से थे अङगुर वारीला धनीसे तिग लला? थे खसी अधियाँ लबा म्‍हिगदेदा साइला ओच्‍छे थे अङगुरला वारी स्‍य्‍हान्‍दोगदेदा स्‍होबारी पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","एनीगदेसे परमेश्‍वरला बचन खाइमै पढब लबा आरे? ‘जुन युङबादा दिम स्‍होबा कर्मीगदेसे गे आखेल भिसी भ्‍याङ्‍बा मुबा, थेनोन युङबा दिमला सुर युङबा दोजी। ");
INSERT INTO taj_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","चु परमप्रभुग्‍याम तबासे लमा य्‍हाङला लागिरी उदेकला ताम हिन्‍ना’ भिसी भ्रिबा मुला।” ");
INSERT INTO taj_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","येशूसे सुङ्बा ताम य्‍हाङला बिरोधरी चीम भिसी यहूदी धर्मगुरुगदेसे था याङ्सी थेनीगदेसे येशूदा चुङ्बारी म्‍हाइजी। तिग्‍दा भिसम चु उखान येशूसे थेनीगदेलान बिरोधरी सुङ्बा हिन्‍ना भिबा ताम थेनीगदेदा था मुबा। तर म्‍हिला हुलसे लमा थेनीगदे लोङ्सी येशूदा चुङ्बारी आखम्‍नी। थेतबासेलमा थेनीगदेसे येशूदा ख्‍लासी निजी। ");
INSERT INTO taj_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","जमाहेन्‍से तामनोन तामरी येशूदा फसब लइ भिसी यहूदी धर्मगुरुगदेसे फरिसीदेन हेरोदीगदेला कोइ कोइ म्‍हिगदेदा येशू मुबा ग्‍लारी पुइजी। ");
INSERT INTO taj_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","थेनीगदे येशू मुबा ग्‍लारी खसी, “गुरु, ह्राङ सत्‍यला म्‍हि हिन्‍ना, ओच्‍छे खालैदा वास्‍ता आलमुला भिसी ङन्‍दा था मुला। तिग्‍दा भिसम ह्राङसे म्‍हिला ली च्‍यासी गे आलमुला। तर परमेश्‍वरला ग्‍याम ज्‍यना लसी लोप्‍मुला। थेतबासेलमा ङन्‍से रोमी ग्‍याल्‍बो कैसरदा तिरो फाबा ठीक हिन्‍ना कि आहिन? सुङ्‍गो। ");
INSERT INTO taj_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ङन्‍से तिरो फागो कि थाफागो?” भिसी ङ्‌योइमा, येशूसे थेनीगदेला कप्‍टी सेम था याङ्सी, “तिग्‍दा एनीगदेसे ङादा फसब लबारी म्‍हाइबा? खाइ डबल गिक भउ च्‍यागे” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","थेनीगदेसे येशूदा डबल गिक पिन्‍जी, ओच्‍छे येशूसे थेनीगदेदा “चु डबलरी मुबा छापदेन मिन खाल्‍ला हिन्‍ना?” भिसी सुङ्मा, थेनीगदेसे “रोमी ग्‍याल्‍बो कैसरला” भिसी जोहाब पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","जमाहेन्‍से येशूसे थेनीगदेदा “थेह्रङ् भिसम रोमी ग्‍याल्‍बो कैसरला जति रोमी ग्‍याल्‍बो कैसरदा पिन्‍गो ओच्‍छे परमेश्‍वरला जति परमेश्‍वरदा पिन्‍गो” भिसी सुङ्जी। चुह्रङ्बा ताम थेःसी थेनीगदे उदेक तजी। ");
INSERT INTO taj_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","सिबा म्‍हि दोःसी आसो भिसी विश्‍वास लबा सदुकीगदे येशू मुबा ग्‍लारी खसी चुह्रङ् भिसी ङ्‌योइजी, ");
INSERT INTO taj_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“गुरु, मोशासे य्‍हाङदा पिन्‍बा ठिम अन्‍छार खालैला ज्‍योज्‍योसे ब्‍याह लसी कोलागदे आतनान सिजी भिसम ज्‍योज्‍यो‍ला लागिरी कोलागदे तगै भिसी आलेसे चाङदा ब्‍याह लतोःला भिसी भ्रिबा मुला। ");
INSERT INTO taj_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","म्‍हि गिकला ज्‍योज्‍यो आले निस मुबा। थेबासे ब्‍याह लजी तर कोलागदे आतनान थे सिजी। ");
INSERT INTO taj_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ओच्‍छे पाराङसे चाङदा ब्‍याह लजी थेएनोन कोलागदे आतनान सिजी, साँजीएनोन थेह्रङ् तसीन सिजी। ");
INSERT INTO taj_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","चुह्रङ् लसी जम्‍मासेन पालोन पालो चाङदा ब्‍याह लजी। ओच्‍छे कोलागदे आतनान थेनीगदे सिजी। ओच्‍छे थे म्रिङम्‍हेमेएनोन सिजी। ");
INSERT INTO taj_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","थेतबासेलमा ङन्‍दा सुङ्‍गो, सिबाग्‍याम सोना लजी भिसम थे म्रिङम्‍हेमे खजिबाला म्रिङ तला? तिग्‍दा भिसम थेनीगदे जम्‍मासेन थे म्रिङम्‍हेमेदेन छ्‌याम ब्‍याह लबा मुला।” ");
INSERT INTO taj_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","येशूसे थेनीगदेदा “एनीगदे अन्‍दोलरीन चीम, तिग्‍दा भिसम एनीगदेसे परमेश्‍वरला बचनदेन परमेश्‍वरला शक्तिला बारेरी घोबान आरेम। ");
INSERT INTO taj_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","तिग्‍दा भिसम सिबाग्‍याम सोना लबा धुइरी न्‍ह ब्‍याह लला न्‍ह ब्‍याह तला। तर थेनीगदे स्‍वर्गरी मुबा स्‍वर्गदूतगदे ह्रङ्‌बान तला। ");
INSERT INTO taj_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","सिबाग्‍याम सोना लबाला बारेरी अझ भिगे भिसम परमेश्‍वरसे मोशादा लुङ्बा मेला झाङग्‍याम ‘ङा अब्राहाम, इसहाकदेन याकूबला परमेश्‍वर हिन्‍ना’ भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","परमेश्‍वर मी सिबागदेला परमेश्‍वर आहिन, तर सोबागदेला परमेश्‍वर हिन्‍ना। थेतबासेलमा एनीगदेसे घोबा जम्‍मान ताम गल्‍ती मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","येशूसे म्‍हिगदेदा ज्‍यना लसी जोहाब पिन्‍बा म्राङ्सी यहूदी धर्मगुरुगदे न्‍हङला गिकसे, “गुरु, परमेश्‍वरसे मोशादा पिन्‍बा ठिमरी जम्‍मान भन्‍दा मुल ताम चा खजिबा हिन्‍ना?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","येशूसे थेदा चुह्रङ् भिसी सुङ्जी, “‘इस्राएलीगदे च्‍यागो, जम्‍मान भन्‍दा मुल ताम चा परमप्रभु य्‍हाङला परमेश्‍वर गिक जे प्रभु हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","एसे ह्राङला परमप्रभु परमेश्‍वरदा सेमहेन्‍से, जम्‍मान प्राणसे, जम्‍मान बुद्धिसे, जम्‍मान शक्तिसे माया लउ।’ ");
INSERT INTO taj_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ओच्‍छे परमेश्‍वरसे कुल्‍बा अर्गु मुल ताम चा ‘एसे ह्राङला खिम्‍जेमदा ह्राङदा ह्रङ्नोन माया लउ।’ परमेश्‍वरसे कुल्‍बा मुल ताम चु भन्‍दा अर्गु आरे।” ");
INSERT INTO taj_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","चु ताम थेःसी यहूदी धर्मगुरुसे येशूदा “गुरु, ह्राङसे सुङ्बा ताम ठीक हिन्‍ना। परमेश्‍वर गिक जे मुला, ओच्‍छे परमेश्‍वर बाहेक स्‍य्‍हान्‍दो खालै आरे। ");
INSERT INTO taj_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ओच्‍छे परमेश्‍वरदान सेमहेन्‍सेन, जम्‍मान प्राणसे, जम्‍मान बुद्धिसे, जम्‍मान शक्तिसे माया लबा, ओच्‍छे ह्राङदा ह्रङ्नोन ह्राङला खिम्‍जेमदाएनोन माया लबा चा मेरी ख्राङ्‌सी पिन्‍बा जम्‍मान बलिदेन बलिदानगदे भन्‍दा मुल ताम हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","थेसे होशियार तसी जोहाब पिन्‍बा म्राङ्सी येशूसे थेदा “ए परमेश्‍वरला य्‍हुल्‍साग्‍याम थारेङ आरे” भिसी सुङ्जी। जमाकुनुहेन्‍से खालैसे येशूदा तिगै ताम ङ्‌योइबारी आँट आलनी। ");
INSERT INTO taj_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","येशूसे परमेश्‍वरला मन्‍दिररी लोप्‍बान लबा धुइरी चुह्रङ् भिसी सुङ्जी, “यहूदी धर्मगुरुगदेसे तिग्‍दा थार्बा पिन्‍बा ख्रीष्‍टदा दाऊद ग्‍लेला सन्‍तान भिसी भिबा? ");
INSERT INTO taj_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","तिग्‍दा भिसम दाऊदसेन परमेश्‍वरला आत्‍माग्‍याम चुह्रङ् भिबा मुबा, ‘परमप्रभुसे ङाला प्रभुदा ङाइ एला शत्रुगदेदा एला काङ धिरी आथान्‍तेधोना ए ङाला दाहिनेपट्टि चिउ’ भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“दाऊद ह्राङसेन मी ख्रीष्‍टदा ‘प्रभु’ भिमाहेन्‍से खाह्रङ् लसी ख्रीष्‍ट दाऊद ग्‍लेला सन्‍तान तला?” ओच्‍छे येशूसे लोप्‍बा ताम म्‍हिगदेसे सेम लसी ङ्‌यान्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","येशूसे लोप्‍बान लबा धुइरी चुह्रङ् भिसी सुङ्जी, “यहूदी धर्मगुरुगदे म्राङ्सी होशियार तउ। तिग्‍दा भिसम थेनीगदे ज्‍यबा ज्‍यबा क्‍वान क्‍वान्‍सी कोर्बारी निबादेन बजाररी निबा धुइरी म्‍हिगदेसे मान लगै भिसी म्‍हन्‍मुला। ");
INSERT INTO taj_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ओच्‍छे यहूदीगदे ह्रुप तबा दिमरीदेन भोज लबा ग्‍लारीनोन मुल ठि म्‍हाइमुला। ");
INSERT INTO taj_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","थेह्रङ् लसीन थेनीगदेसे ह्रेम्‍बो सिबा म्रिङम्‍हेमेगदेला दिमनाम ब्‍यन्‍मुला। ओच्‍छे म्‍हिगदेदा उन्‍बाला लागिरी ह्रेङ्बा ह्रेङ्बा प्रार्थना लमुला थेह्रङ्बा म्‍हिगदेसे झन ल्‍हानान सजाय याङ्ला।” ");
INSERT INTO taj_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","येशू परमेश्‍वरला मन्‍दिररी भेटी युबा ग्‍लाला ङाच्‍छापट्टि धन्‍छ्‌यासी म्‍हिगदेसे भेटी युबा बाकसरी भेटी युबान लबा स्‍हीबान मुबा। थेरी फ्‍युक्‍पो म्‍हिगदेसे ल्‍हानान टाङगा युजी। ");
INSERT INTO taj_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ओच्‍छे ह्रेम्‍बो सिबा प्राङबो म्रिङम्‍हेमे गिक खसी साङबोला सिगा गिकला डबल न्‍ही युजी। ");
INSERT INTO taj_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","जमाहेन्‍से येशूसे चेलागदेदा ह्राङ मुबा ग्‍लारी ङ्‌योइसी, “च्‍यागो, ङाला ताम ङ्‌यान्‍गो। भेटी युबा बाकसरी चु ह्रेम्‍बो सिबा प्राङबो म्रिङम्‍हेमेसे स्‍य्‍हान्‍दो म्‍हिगदेसे भन्‍दा ल्‍हाना भेटी युबा मुला। ");
INSERT INTO taj_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","तिग्‍दा भिसम स्‍य्‍हान्‍दो म्‍हिगदेसे ह्राङदेन छ्‌याम मुबा ल्‍हानान सम्‍पत्तिग्‍याम युजी। तर चु म्रिङम्‍हेमे प्राङबो तसीनोन ह्राङदेन छ्‌याम मुबा जति जम्‍मान युबा मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","येशू परमेश्‍वरला मन्‍दिरग्‍याम थोन्‍सी फेप्‍बान लबा धुइरी चेलागदे न्‍हङला गिकसे “गुरु स्‍हीगो, चुरी गाते घ्रेन घ्रेन युङबासे स्‍होबा गाते जेबा दिमगदे” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","येशूसे थेदा “चु घ्रेन दिमगदेला युङबा गिकनोन बाँकी आचिना जम्‍मान फुप्‍ला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","येशू परमेश्‍वरला मन्‍दिरला क्‍याम्‍सङपट्टिला जैतून गङरी धन्‍छ्‌याबा धुइरी पत्रुस, याकूब, यूहन्‍नादेन अन्‍द्रियास येशू मुबा ग्‍लारी खसी चुह्रङ् भिसी सुटुक्‍क ङ्‌योइजी, ");
INSERT INTO taj_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“ह्राङसे सुङ्बा चु तामगदे खाइमा तला? ओच्‍छे चु तामगदे तबा धुइरी खाह्रङ्बा चिनु म्राङ्ला? ङन्‍दा सुङ्‍गो।” ");
INSERT INTO taj_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदे होशियार तउ। खालैसे एनीगदेदा झुक्‍याब थालगै। ");
INSERT INTO taj_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","तिग्‍दा भिसम ल्‍हानान म्‍हिगदे ङाला मिन किन्‍सी ‘ङानोन थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍ना’ भिसी खला। ओच्‍छे ल्‍हानान म्‍हिदा झुक्‍याब लला। ");
INSERT INTO taj_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","एनीगदेसे लडाइदेन लडाइला हल्‍लागदे थेःला। तसैनोन एनीगदे थालोङ्‍गो, तिग्‍दा भिसम चु तनोन तोःबा हिन्‍ना। तर थेनोन धुइरी चा चु जम्‍बुलिङ नाश आत। ");
INSERT INTO taj_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","तिग्‍दा भिसम म्‍हि य्‍हुलला बिरोधरी म्‍हि य्‍हुलनोन ओच्‍छे य्‍हुल्‍साला बिरोधरी य्‍हुल्‍सा रेःला। खानङदमान सङगुल निला ओच्‍छे अनिकाल तला। चु चा कोला न्‍हसेला म्रिङम्‍हेमेदा कोला न्‍हबा धुइरी स्‍हु खबारी छ्‌याइबा दुख ह्रङ्‌बान दुख तबारी छ्‌याइबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“तर थे धुइरी एनीगदे होशियार तउ। तिग्‍दा भिसम म्‍हिगदेसे एनीगदेदा अदालतरी ओच्‍छे यहूदीगदे ह्रुप तबा दिमरी भोर्सी तोबा ग्‍याङ्‍बा लला। ओच्‍छे थेनीगदेसे एनीगदेदा ङादा विश्‍वास लबा ताम उन्‍बाला लागिरी अञ्‍चलाधीशदेन ग्‍लेला ङाच्‍छापट्टि राप्‍पुङ्ला। ");
INSERT INTO taj_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","थे भन्‍दा ङाच्‍छा जम्‍मान य्‍हुलदा थार्बा पिन्‍बा समाचार थेःना लतोःबा मुला। ");
INSERT INTO taj_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","म्‍हिगदेसे एनीगदेदा चुङ्सी भोर्सी मुद्दा युबा धुइरी एनीगदेसे तिग पाङ्तोःला भिसी धन्‍दा सुर्दा थालउ। तर थे धुइरी परमेश्‍वरसे तिग पाङ्‍गो भिबा चीम थेनोन पाङ्‍गो। तिग्‍दा भिसम थे धुइरी पाङ्बा एनीगदेसे आहिन तर परमेश्‍वरला आत्‍मासे हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“ह्राङलान ज्‍योज्‍यो आलेसे ह्राङलान ज्‍योज्‍यो आलेदा साइपुङ्ला। थेह्रङ् लसीन आबासे कोलागदेदा साइपुङ्ला ओच्‍छे कोलागदेसे आबा आमादा बिरोधरी लसी साइपुङ्ला। ");
INSERT INTO taj_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ओच्‍छे ङादा विश्‍वास लबासे लमा एनीगदेदा जम्‍मान म्‍हिगदेसे हेला लला। तर जुन म्‍हिसे जस्‍तोन दुख तसैनोन ह्राङ आसितेधोना ङादा विश्‍वास लबा आख्‍ला थेसे थार्बा याङ्ला। ");
INSERT INTO taj_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“परमेश्‍वरला मन्‍दिरला चोखो ग्‍लारी नइबा खबा स्‍हे म्राङ्ला।” चुला अर्थ चा पढब लबा म्‍हिसे घोगै। “थे धुइरी यहूदिया अञ्‍चलरी मुबा म्‍हिगदे गङरीक्‍यार यार्गै। ");
INSERT INTO taj_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ओच्‍छे तलाथोरी मुबा म्‍हिगदे ह्राङला सामान किन्‍बारी मार फाप्‍सी दिम न्‍हङरी थावाङ्‍गो। ");
INSERT INTO taj_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","बु वारीरी मुबागदे ह्राङला घ किन्‍बारी दोःसी दिमरी थानिउ। ");
INSERT INTO taj_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","थे धुइरी जिउ न्‍हीला म्रिङम्‍हेमेदेन कोलादा ङ्‍हे ख्‍वाबा आमागदेदा झन गाते ल्‍हानान दुख तला! ");
INSERT INTO taj_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","चु ताम खङ्‍बा लारी आतगै भिसी प्रार्थना लउ। ");
INSERT INTO taj_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","तिग्‍दा भिसम थे धुइरी तबा घ्रेन दुख परमेश्‍वरसे चु जम्‍बुलिङ स्‍होमाहेन्‍से दान्‍देधोना तबा आरे ओच्‍छे लिच्‍छाएनोन खाइमै तसेला आरे। ");
INSERT INTO taj_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","चुदे परमेश्‍वरसे थे धुइ तुन्‍ना आलबा हिन्‍सम खालै म्‍हिसेन थार्बा आयाङ्सेला मुबा। तर ह्राङसे धम्‍बा म्‍हिगदेला लागिरी परमेश्‍वरसे थे धुइ तुन्‍ना लबा मुला। ");
INSERT INTO taj_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“थे धुइरी खालैसे एनीगदेदा ‘च्‍यागो, थार्बा पिन्‍बा ख्रीष्‍ट चुरी मुला,’ अथवा ‘थेरी मुला,’ भिजी भिसम एनीगदेसे थेनीगदेला ताम पत्‍याब थाचउ। ");
INSERT INTO taj_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","तिग्‍दा भिसम फट्टा ख्रीष्‍टगदेदेन फट्टा अगमवक्तागदे थोन्‍ना। ओच्‍छे थेनीगदेसे खम्‍तेधोना परमेश्‍वरसे धम्‍बा म्‍हिगदेदा झुक्‍याब लबाला लागिरी उदेकला चिनुगदेदेन उदेकला गेगदे लसी उन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","तर एनीगदे चा होशियार लसी चिउ। ङाइ एनीगदेदा जम्‍मान ताम ङाच्‍छाहेन्‍सेन पाङ्सी पिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“थे दुखला धुइ जिन्‍माहेन्‍से धिनीसे य्‍हाल पिन्‍बा ख्‍लाला ओच्‍छे लनीला य्‍हाल म्‍हाला। ");
INSERT INTO taj_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","जमाहेन्‍से मुला शक्तिगदे याङयोङ तसी सुक्र सार जम्‍मान ताइला। ");
INSERT INTO taj_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","जमाहेन्‍से म्‍हिगदेसे परमेश्‍वरसे पुइखबा म्‍हिदा घ्रेन शक्तिदेन य्‍हाल य्‍हालरी खसुरी खबान लबा म्राङ्ला। ");
INSERT INTO taj_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ओच्‍छे थेसे स्‍वर्गदूतगदेदा जम्‍बुलिङदेन मुला जम्‍मान ग्‍लारी पुइला। जमाहेन्‍से थे स्‍वर्गदूतगदेसे परमेश्‍वरसे धम्‍बा जम्‍मान म्‍हिगदेदा ग्‍ला गिकरी पोप लला।” ");
INSERT INTO taj_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","येशूसे थेनीगदेदा दोःसी चुह्रङ् भिसी सुङ्जी, “एनीगदेसे अञ्‍जीरला दोङदा च्‍यासी थेग्‍याम तिगै ताम लोप्‍गो। थेला हाँगागदेरी भा भुमैछ्‌याम छेप्‍बा छबा ला वाङ्‌जी भिसी एनीगदेसे था याङ्मुला। ");
INSERT INTO taj_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","थेह्रङ् लसीन ङाइ पाङ्बा तामगदे तबा म्राङ्माहेन्‍से परमेश्‍वरसे पुइखबा म्‍हि खबा धिन खसी जिन्‍जी भिबा ताम एनीगदेसे था याङ्‍गो। ");
INSERT INTO taj_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, चु जम्‍मान ताम पूरा आततेधोना दान्‍देला म्‍हिगदे आसि। ");
INSERT INTO taj_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","मुदेन जम्‍बुलिङ म्‍हासी निसैनोन ङाला बचन खाइमै आम्‍हा। ");
INSERT INTO taj_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“थे दुखला धिनदेन धुइ खाइमा खला भिसी स्‍वर्गदूतदाएनोन था आरे ओच्‍छे ङा परमेश्‍वरला झादाएनोन था आरे। थे ताम परमेश्‍वर आबादा जे था मुला। ");
INSERT INTO taj_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","थेतबासेलमा एनीगदे होशियार तसी छोर्सी चिउ। ओच्‍छे प्रार्थना लउ, तिग्‍दा भिसम थे धुइ खाइमा खला भिसी एनीगदेदा था आरे। ");
INSERT INTO taj_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“चु ताम चा मालिकसे ह्राङला दिम च्‍याबा म्‍हिदा क्‍यारमार ज्‍यना लसी च्‍यागो, ओच्‍छे नोकरगदेदाएनोन ह्राङ ह्राङला गे ज्‍यना लसी लउ भिसी कुल्‍सी ह्राङ चा विदेशरी निबा ह्रङ्‌बान हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","थेतबासेलमा एनीगदे छोर्सी चिउ, तिग्‍दा भिसम मालिक खाइमा खला भिसी एनीगदेदा था आरे। थे ङ्‍यसे खखम्‍ला, म्‍हुन गुङरी खखम्‍ला, नागा क्राबा धुइरी खखम्‍ला, स्‍य्‍होरीनोन खखम्‍ला खजिबै धुइरीनोन थे खखम्‍ला। ");
INSERT INTO taj_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","तर एनीगदेदा था आपिन्‍ना तिक्‍खुरीन खमा एनीगदेदा म्‍हेर्सी चिबा स्‍याप्‍ला। ");
INSERT INTO taj_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","थेतबासेलमा एनीगदे छोर्सी चिउ, ङाइ एनीगदेदा पाङ्बा चु ताम जम्‍मादान पाङ्बा मुला।” ");
INSERT INTO taj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाङदेन खमीर आयुना गेङ चसी धङ्बा चाडला न्‍हीरे ङाच्‍छाकुनु परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी धर्मगुरुगदेसे येशूदा चुङ्सी साइबारी दाउ च्‍यासी भ्रमुबा। ");
INSERT INTO taj_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","तिग्‍दा भिसम “य्‍हाङला चाडला धुइरी चा चुङ्बारी आत। चाडला धुइरी चुङ्‌जी भिसम म्‍हिगदेसे हुल दङगा लला” भिसी थेनीगदे ह्राङ ह्राङ न्‍हङरी ताम लजी। ");
INSERT INTO taj_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","येशू बेथानिया भिबा नाम्‍साला कोरे खबा सिमोनला दिमरी सोल छ्‌योइबान लबा धुइरी म्रिङम्‍हेमे गिकसे सिङ्‍गमरमरला ताङरी ल्‍हानान महँगो खाल्‍ला अत्तर भसी खजी। थे अत्तर जटामसी भिबा दोङला टाग्‍याम स्‍होबा मुबा। थेसे थे ताङनोन थिसी येशूला थोबोरी युजी। ");
INSERT INTO taj_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","थेसे चुह्रङ् लबा म्राङ्सी स्‍य्‍हान्‍दो म्‍हिगदेसे नाआखम्‍ना “चुदे महँगो अत्तर ओह्रङ्नोन तिग्‍दा खेरो भ्‍याङ्‍बा” भिसी ह्राङ ह्राङ न्‍हङरी ताम लजी। ");
INSERT INTO taj_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","बरु चु चूङ्सी खबा टाङगा प्राङबोगदेदा पिन्‍सै तसेला। चु चूङ्सम ग्‍यार्जा सोम म्‍हुइला डबल खसेला मुबा” चुह्रङ् लसी थे म्रिङम्‍हेमेदा थेनीगदेसे बङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","तर येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “थालउ, एनीगदेसे तिग्‍दा चुदा कचकच लबा? चुसे मी ङाला लागिरी ज्‍यबा गे लबा मुला। ");
INSERT INTO taj_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","च्‍यागो, प्राङबोगदे मी सदन एनीगदेदेन छ्‌याम तला। ओच्‍छे एनीगदेसे थेनीगदेदा खजिबै धुइरी ह्रो लखम्‍ला। तर ङा मी सदन एनीगदेदेन छ्‌याम आत। ");
INSERT INTO taj_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","चु म्रिङम्‍हेमेसे जे लखम्‍जी, थेनोन थेसे लजी। ङाला ल्‍हुइ धुर्सारी थान्‍बाला लागिरी चुसे अत्तर फोर्सी ङाच्‍छान ठीक लबा मुला। ");
INSERT INTO taj_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, जम्‍बुलिङला जुन जुन ग्‍लारी थार्बा पिन्‍बा समाचार थेःना लला, थे, थे ग्‍लारी चु म्रिङम्‍हेमेसे लबा गे ढन्‍बाला लागिरी थेला ताम लला।” ");
INSERT INTO taj_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","जमाहेन्‍से येशूला च्‍युक न्‍ही चेलागदे न्‍हङला यहूदा इस्‍करियोत भिबा चेला गिक परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदे मुबा ग्‍लारी निसी येशूदा चुङ्सी पिन्‍ना भिसी सल्‍लाह लजी। ");
INSERT INTO taj_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","चु ताम थेःसी परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदे ल्‍हानान ताङ्सी यहूदा इस्‍करियोतदा टाङगा पिन्‍ना भिसी कबुल लजी। थे धुइहेन्‍से थेसे येशूदा चुङ्सी पिन्‍बाला लागिरी दाउ च्‍यासी भ्रजी। ");
INSERT INTO taj_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","खमीर आयुना गेङ चसी धङ्बा चाडला शुरुला धिनकुनु यहूदीगदेसे ग्‍यु बोगो फुल्‍तोःमुबा। येशूला चेलागदेसे येशूदा “ह्राङला लागिरी ङन्‍से मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाडला भोज खानङ ठीक लउ?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","येशूसे ह्राङला चेला न्‍हीदा “एनीगदे शहररी निउ, एनीगदेसे थेरी दर्बुङरी क्‍युइ पुइसी निबा म्‍हि गिकदा स्‍याप्‍ला। थेनोन म्‍हिला लिच्‍छा लिच्‍छा निउ। ");
INSERT INTO taj_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ओच्‍छे थे म्‍हि जुन दिमरी वाङ्ला, थेनोन दिमला धनीदा ‘ङाइ ङाला चेलागदेदेन छ्‌याम चिसी मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाडला भोज चबा कोठा खानङ मुला?’ भिसी गुरुसे ङ्‌योइबा मुला भिउ। ");
INSERT INTO taj_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","एनीगदेदा थेसे ङाच्‍छान जेना लसी थान्‍बा तलाथोला घ्रेन कोठा उन्‍सी पिन्‍ना। एनीगदेसे थेरीन य्‍हाङला लागिरी भोज ठीक लउ” भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","जमाहेन्‍से चेलागदे शहररी निबान लबा धुइरी येशूसे सुङ्बा ह्रङ्नोन स्‍याप्‍जी। ओच्‍छे थेनीगदेसे थेरीन मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाडला भोज ठीक लजी। ");
INSERT INTO taj_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ओच्‍छे ङ्‍यसे तमाहेन्‍से येशू ह्राङला च्‍युक न्‍ही चेलागदेदेन छ्‌याम फेप्‍खजी। ");
INSERT INTO taj_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","भोज सोल्‍बान लबा धुइरी येशूसे ह्राङला चेलागदेदा “च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, एनीगदे न्‍हङला ङादेन छ्‌यामनोन चबा गिकसे ङादा म्‍हिगदेला यारी जिम्‍मा पिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","चु ताम थेःमाहेन्‍से चेलागदेदा दुख ङ्‍हम्‍सी, “थे म्‍हि ङानोन हिन्‍ना?” भिसी पालो पालो लसी येशूदा ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","येशूसे थेनीगदेदा “एनीगदे च्‍युक न्‍ही न्‍हङला गिकसे खार्बारी ङादेन छ्‌यामनोन गेङ तुइसी चबान मुला। ");
INSERT INTO taj_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","परमेश्‍वरला बचनरी भ्रिबा ह्रङ्नोन परमेश्‍वरसे पुइखबा म्‍हि मी सिनोन तोःला। तर जुन म्‍हिसे परमेश्‍वरसे पुइखबा म्‍हिदा चुङ्सी म्‍हिला यारी जिम्‍मा पिन्‍ना, थेसे परमेश्‍वरग्‍याम खाह्रङ्बा लोङ्‌बा खबा सजाय याङ्ला। बरु थे मी न्‍हनोन आन्‍हबा हिन्‍सम ज्‍यबा तसेला मुबा” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","थेनीगदेसे चबान लबा धुइरी येशूसे यारी गेङ किन्‍सी परमेश्‍वरदा धन्‍यवाद पिन्‍बान प्रार्थना लजी। ओच्‍छे गेङ क्‍युइसी चेलागदेदा पिन्‍बान, “ना! चु ङाला ल्‍हुइ हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","जमाहेन्‍से येशूसे खोरेरी मुबा अङगुरला निङगु थोसी परमेश्‍वरदा धन्‍यवाद पिन्‍सी चेलागदेदा पिन्‍जी। ओच्‍छे थेनीगदेसे थे खोरेग्‍याम थुङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","जमाहेन्‍से येशूसे थेनीगदेदा “चु ल्‍हानान म्‍हिगदेला लागिरी बगब तबा ङाला का हिन्‍ना। ङाला कानोन परमेश्‍वरसे म्‍हिगदेदा लबा छार कबुल हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","‘च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, परमेश्‍वरला य्‍हुल्‍सारी अङगुरला छार निङगु थुङ्बा धुइ आखतेधोना ङाइ चु अङगुरला निङगु आथुङ्’ भिसी सुङ्जी।” ");
INSERT INTO taj_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ओच्‍छे थेनीगदे परमेश्‍वरदा धन्‍यवादला व्‍हाइ गिक गोसी जैतून भिबा गङरीक्‍यार भ्रजी। ");
INSERT INTO taj_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","येशूसे ह्राङला चेलागदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदे जम्‍मासेन ङादा ख्‍लासी यार्ला। तिग्‍दा भिसम परमेश्‍वरला बचनरी ‘ङाइ गोठालोदा साइला ओच्‍छे ग्‍युगदे ससा बङबङ तसी यार्ला’ भिसी भ्रिबा मुला। ");
INSERT INTO taj_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","तर ङादा सिबाग्‍याम सोना लमाहेन्‍से एनीगदे भन्‍दा ङाच्‍छा ङा गालीलरी निला।” ");
INSERT INTO taj_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","येशूसे चुह्रङ् सुङ्मैछ्‌याम पत्रुससे येशूदा “जम्‍मासेन ह्राङदा ख्‍लासी यार्सैनोन ङाइ ह्राङदा खाइमै आख्‍ला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","येशूसे पत्रुसदा “च्‍यागो, एसे ङाला ताम ङ्‌यान्‍गो, न्‍हङगर स्‍य्‍होरी न्‍हीरेम नागा क्राबा भन्‍दा ङाच्‍छा एसे सोमरेमधोना ङा येशूदेन छ्‌याम भ्रबा म्‍हि हिन्‍नोन आहिन भिसी भिला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","तर पत्रुससे, “आहिन, ङा ह्राङदेन छ्‌याम सितोःसैनोन ङाइ ह्राङदा आख्‍ला” भिसी भिजी। ओच्‍छे स्‍य्‍हान्‍दो चेलागदेसेनोन थेह्रङ्नोन भिजी। ");
INSERT INTO taj_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","जमाहेन्‍से थेनीगदे गेत‍समनी भिबा ग्‍लारी फेप्‍जी। ओच्‍छे येशूसे ह्राङला चेलागदेदा “ङाइ प्रार्थना लतेधोना एनीगदे चुरीन चिउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","येशूसे पत्रुस, याकूबदेन यूहन्‍नादा ह्राङदेन छ्‌याम भोर्जी। ओच्‍छे येशूला सेम भोल्‍सी ल्‍हानान दुख तबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ओच्‍छे येशूसे थेनीगदेदा “ङाला सेम क्रोसी ङा सिबा तेबान तबा मुला। थेतबासेलमा एनीगदे चुरीन ङा ह्रङ् लसी छोर्सी चिउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","जमाहेन्‍से येशू जजाकी क्‍याथाङ फेप्‍सी सरी ख्‍लुप तसी, “ङाथोरी खबारी छ्‌याइबा चु दुख तसम ङाइ नाआतोःगै” भिसी प्रार्थना लबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","येशूसे चुह्रङ् भिसी प्रार्थना लजी, “आबा, ह्राङसे लआखम्‍बा ताम तिगै आरे, थेतबासेलमा तसम ङादा चु दुखग्‍याम फेसी पिन्‍गो। तर ङाइ म्‍हन्‍बा अन्‍छार आहिन, ह्राङसे म्‍हन्‍बा अन्‍छार तगै।” ");
INSERT INTO taj_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","जमाहेन्‍से येशू ह्राङला चेला सोम मुबा ग्‍लारी दोःसी फेप्‍खमा थेनीगदे म्‍हेर्सी चिबा स्‍याप्‍जी। येशूसे पत्रुसदा चुह्रङ् भिसी सुङ्जी, “सिमोन, तिग ए म्‍हेर्सी चिबा? ए घण्‍टा गिक सुत्तै छोर्सी चिआखम्‍नी? ");
INSERT INTO taj_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","दाहेन्‍से एनीगदे पापरी फसब आतबाला लागिरी छोर्सी प्रार्थना लसी चिउ। च्‍यागो, एनीगदेला आत्‍मा मी तयार मुला, तर ल्‍हुइ चा कमजोर मुला।” ");
INSERT INTO taj_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","येशू दोःसी तिरेम थे ग्‍लारी फेप्‍सी ङाच्‍छाला ह्रङ् लसीन प्रार्थना लजी। ");
INSERT INTO taj_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ओच्‍छे चेलागदे मुबा ग्‍लारी दोःसी फेप्‍खमा चेलागदे म्‍हेर्सी चिबा स्‍याप्‍जी। म्‍हेर्बा खबासे लमा थेनीगदेसे मीनोन ठोङ्आखम्‍नी, ओच्‍छे तिग भितोःबा थे थेनीगदेदा था आतनी। ");
INSERT INTO taj_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","येशू सोमरेमला पालोरी फेप्‍खसी चेलागदेदा चुह्रङ् भिसी सुङ्जी, “अझन एनीगदे म्‍हेर्सी ब्‍लप्‍बा न्‍हबान मुला? दाहेन्‍से म्‍हेर्बा धुइ निजी। च्‍यागो, परमेश्‍वरसे पुइखबा म्‍हिदा चुङ्सी पापीगदेला यारी जिम्‍मा पिन्‍बा धुइ तसी जिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","रेःगो, निइ! च्‍यागो, ङादा स्‍य्‍हान्‍दोला यारी जिम्‍मा पिन्‍बा म्‍हि खसी जिन्‍बा मुला।” ");
INSERT INTO taj_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","येशूसे चु ताम सुङ्मैछ्‌याम च्‍युक न्‍ही चेलागदे न्‍हङला यहूदा भिबा चेलादेन छ्‌याम कडीदेन तरवार थोबा म्‍हिला हुल धोखजी। थेनीगदेदा परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी धर्मगुरुगदे ओच्‍छे यहूदी गन्‍बागदेसे पुइखबा मुबा। ");
INSERT INTO taj_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","येशूदा चुङ्बारी खबा म्‍हिगदेदा यहूदासे “जुन म्‍हिदा ङाइ च्‍योक लला, थेनोन येशू हिन्‍ना, थेदा चुङ्सी क्‍युर लसी भोर्गो” भिसी पाङ्बा मुबा। ");
INSERT INTO taj_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ओच्‍छे यहूदा येशू मुबा ग्‍लारी सरासर निसी, “गुरु” भिसी येशूदा च्‍योक लजी। ");
INSERT INTO taj_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","जमाहेन्‍से थेनीगदेसे येशूदा चुङ्सी खीसी भोर्जी। ");
INSERT INTO taj_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","तर थेरी राप्‍सी चिबा गिकसे तरवार तेःसी परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिला नोकरला नाब्‍यङ च्‍वाट्टन थाजी। ");
INSERT INTO taj_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","येशूसे थेनीगदेदा “एनीगदे तिग्‍दा य्‍होदा चुङ्बारी खबा ह्रङ् लसी कडी तरवार थोसी खबा? ");
INSERT INTO taj_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","खाइ, ङाइ एनीगदेला गुङरी म्‍हिगदेदा धिन धिननोन परमेश्‍वरला मन्‍दिररी लोप्‍सी चिबा धुइरी एनीगदेसे ङादा आचुङ्नी। तर परमेश्‍वरला बचनरी भ्रिबा अन्‍छार पूरा तगै भिसीन चुह्रङ् तबा हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","जमाहेन्‍से चेलागदे जम्‍मासेन येशूदा ख्‍लासी यार्जी। ");
INSERT INTO taj_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","तर सुतिला क्‍वान क्‍वान्‍बा भ्‍योन गिक येशूला लिच्‍छा लिच्‍छा भ्रबान मुबा। थेनीगदेसे थेदाएनोन चुङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ओच्‍छे थेनीगदेसे थेदा चुङ्मा थेला क्‍वान जे स्‍याप्‍जी। तर थे म्‍हि ह्राङला क्‍वाननोन ख्‍लासी लिगन्‍डीन यार्जी। ");
INSERT INTO taj_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","जमाहेन्‍से येशूदा परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हि मुबा ग्‍लारी भोर्जी। थेरी पूजा लबा म्‍हिगदेदेन यहूदी गन्‍बागदे ओच्‍छे यहूदी धर्मगुरुगदेएनोन पोप तबा मुबा। ");
INSERT INTO taj_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ओच्‍छे पत्रुस चा येशूला जजाकी लिच्‍छा लिच्‍छा निसी परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिला दिमला ख्राङगाधोना निजी, ओच्‍छे पालेगदेदेन छ्‌याम मे दूसी चिजी। ");
INSERT INTO taj_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","जमाहेन्‍से परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी सभाला जम्‍मान म्‍हिगदेसे येशूदा साइबाला लागिरी प्रमाण म्‍हाइबारी छ्‌याइजी। तर थेनीगदेसे तिगै प्रमाण आस्‍याप्‍नी। ");
INSERT INTO taj_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","थेरी ल्‍हानान म्‍हिगदेसे येशूला बिरोध लसी लुसीला ताम लजी। तर खालैला ताम आढिक्‍नी। ");
INSERT INTO taj_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","जमाहेन्‍से कोइ कोइ म्‍हिगदे रेःसी येशूला बिरोध लबान चुह्रङ् भिसी लुसीला ताम पाङ्‌बारी छ्‌याइजी, ");
INSERT INTO taj_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“चु म्‍हिसे ‘ङाइ म्‍हिसे स्‍होबा चु परमेश्‍वरला मन्‍दिरदा फुप्‍सी सोमरेरीन म्‍हिसे आस्‍होबा परमेश्‍वरला मन्‍दिर स्‍होला भिसी चुसे भिबा ङन्‍से थेःबा मुला।’” ");
INSERT INTO taj_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ओते लसैनोन थेनीगदेला ताम आढिक्‍नी। ");
INSERT INTO taj_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदे जम्‍मान म्‍हिगदेला ङाच्‍छापट्टि राप्‍सी येशूदा “एसे तिग्‍दा जोहाब आपिन्‍बा? चु म्‍हिगदेसे एला बिरोधरी पाङ्बा तामला बारेरी एदा तिगै पाङ्सेला आरे?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","तर येशूसे तिगै जोहाब आपिन्‍ना कुटिसी स्‍य्‍हूजी। परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिसे येशूदा दोःसी, “तिग ए परमेश्‍वरला झा थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍ना?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","“ङा हिन्‍ना, परमेश्‍वरसे पुइखबा म्‍हिदा ह्राङनीसे शक्तिशाली परमेश्‍वरला दाहिने छ्‌यापट्टि चिबादेन स्‍वर्गग्‍याम खसुरी खबान लबा म्राङ्ला” भिसी येशूसे सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","चु ताम थेःसी परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिसे ह्राङला क्‍वान ढेबान, “दाहेन्‍से य्‍हाङदा अर्गु प्रमाण तिग्‍दा तोःजी?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","“चुसे ह्राङसे ह्राङदान परमेश्‍वर स्‍होसी पाङ्बा ताम य्‍हाङसे थेःनोन थेःजी, दाहेन्‍से एनीगदेला तिग बिचार मुला?” भिमा, थेरी मुबा जम्‍मान म्‍हिगदेसे “चु म्‍हि साइनोन तोःबा म्‍हि हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","थेरी मुबा म्‍हिगदे न्‍हङला कोइ कोइ म्‍हिगदेसे येशूदा थो स्‍वाबारी छ्‌याइजी। ओच्‍छे येशूला मी घप्‍सी तोबान, “लु, अगमवाणी पाङ्‍गो” भिसी ङ्‌योइजी। जमाहेन्‍से थेरी मुबा स्‍य्‍हान्‍दो सिपाहीगदेसेनोन येशूदा तोबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","पत्रुस ख्राङगारी चिबान लमा परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिला नोकरस्‍या गिक पत्रुस मुबा ग्‍लारी खजी। ");
INSERT INTO taj_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ओच्‍छे पत्रुसदा मे दूबान लबा म्राङ्सी थे नोकरस्‍यासे “एएनोन नासरतला येशूदेन छ्‌यामनोन मुबा आहिन?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","“एसे खाल्‍ला ताम लबा, ङादा तिगै था आरे” भिसी पत्रुस ख्राङगाला म्रापरीक्‍यार निजी। थे धुइरी नागा क्राजी। ");
INSERT INTO taj_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","पत्रुसदा म्रापरी चिबान लबा म्राङ्सी दोःसी थे नोकरस्‍यासे स्‍य्‍हान्‍दो म्‍हिगदेदा “चु म्‍हि मी येशूला चेला हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","पत्रुससे दोःसी आहिन भिसी भिजी। जजाकी लिच्‍छा दोःसी थेरी राप्‍सी चिबा म्‍हिगदेसे पत्रुसदा “पक्‍कान, ए येशूला चेला हिन्‍ना। तिग्‍दा भिसम ए गालीलला म्‍हि हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","पत्रुससे दोःसी, “ङाइ लुसीला ताम पाङ्बा हिन्‍सम परमेश्‍वरला सजाय ङाथोरी खइ भिसी घ्रान फाबान ह्राङसे भिबा म्‍हिदा ङाइ ङोसेबा आरे” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","पत्रुससे थेह्रङ् भिमैछ्‌याम दोःसी नागा क्राजी। “न्‍हीरेम नागा क्राबा भन्‍दा ङाच्‍छा सोमरेमधोना एसे ङादा ङोसेबान आरे भिला” भिसी येशूसे सुङ्बा ताम ढन्‍सी पत्रुस घ्‍वाँ घ्‍वाँ क्राजी। ");
INSERT INTO taj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","स्‍य्‍होरीन परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी गन्‍बागदे ओच्‍छे थेरी मुबा यहूदी धर्मगुरुगदेदेन छ्‌याम जम्‍मान म्‍हिगदे सल्‍लाह लजी। ओच्‍छे थेनीगदेसे येशूदा खीसी पिलातस भिबा रोमी अञ्‍चलाधीश मुबा ग्‍लारी भोर्सी जिम्‍मा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","जमाहेन्‍से पिलातससे येशूदा “तिग ए यहूदीगदेला ग्‍ले हिन्‍ना?” भिसी ङ्‌योइमा, येशूसे “थे मी ह्राङसेन सुङ्बा मुला” भिसी जोहाब पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेसे येशूदा ल्‍हानान तामरी दोष लबाला लबान लजी। ");
INSERT INTO taj_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","थेतबासेलमा पिलातससे येशूदा दोःसी, “एला तिगै जोहाब आरे? च्‍यागो, थेनीगदेसे एला बिरोध लसी एदा ल्‍हानान दोष लबान मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","तर येशूसे तिगै जोहाब आपिन्‍नी। चु म्राङ्सी पिलातस उदेक तजी। ");
INSERT INTO taj_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाडला धुइरी पिलातससे म्‍हिगदेसे धम्‍बा झ्‍याल्‍खानरी मुबा म्‍हि गिकदा पुइमुबा। ");
INSERT INTO taj_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","थे धुइरी बारब्‍बा भिबा आज्‍यबा गे लबा म्‍हि गिक झ्‍याल्‍खानरी मुबा। थेसे आन्‍दोलनरी म्‍हि साइबा मुबा। ");
INSERT INTO taj_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ओच्‍छे म्‍हिला हुल खसी पिलातसदा “निबा दिङरी ह्रङ् चु पाल्सेनोन झ्‍याल्‍खानरी मुबा म्‍हि गिकदा पुइसी पिन्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","म्‍हिगदेसे चुह्रङ् भिमाहेन्‍से पिलातससे “ङाइ चु यहूदीगदेला ग्‍लेदा ख्‍लासी पिन्‍गै भिसी एनीगदेसे म्‍हन्‍बा मुला?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","तिग्‍दा भिसम परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेसे डाह लसी येशूदा ङा मुबा ग्‍लारी भबा हिन्‍ना भिबा ताम पिलातसदा था मुबा। ");
INSERT INTO taj_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","तर परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेसे स्‍य्‍हान्‍दो म्‍हिगदेदा थीसी, “येशूदा आहिन, बारब्‍बादा ख्‍लासी पिन्‍गो!” भिपुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ओच्‍छे पिलातससे “चु यहूदीगदेला ग्‍ले भिबा म्‍हिदा ङाइ तिग लउ?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","“चुदा क्रुसरी टाँगब लसी साइगो!” भिसी यहूदीगदे क्रिङ्बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","पिलातससे “तिग्‍दा? चुसे थेह्रङ्बा आज्‍यबा गे तिग लबा मुला?” भिसी ङ्‌योइजी। तर थेनीगदेसे झन क्रिङ्बान, “चुदा क्रुसरी टाँगब लसी साइगो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","पिलातसदा थे म्‍हिला हुलदा ताङ्ना लबा सेम मुबा। थेतबासेलमा थेसे बारब्‍बादा पुइजी। तर येशूदा चा कोर्रासे तोसी क्रुसरी टाँगब लसी साइबाला लागिरी रोमी सिपाहीगदेदा जिम्‍मा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","जमाहेन्‍से सिपाहीगदेसे येशूदा सिपाहीगदेला हाकिम चिबा प्रेटोरियन भिबा दिम न्‍हङरी भोर्जी। ओच्‍छे जम्‍मान सिपाहीगदेदा ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ओच्‍छे थेनीगदेसे ग्‍लेला ह्रङ्‌बान वाला वाला पिङगै छोनना क्‍वान क्‍वान्‍सी पिन्‍जी। ओच्‍छे थेनीगदेसे पुजुला फेटा स्‍होसी येशूदा थोइसी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","जमाहेन्‍से थेनीगदेसे येशूदा “लास्‍सो यहूदीगदेला ग्‍ले, फ्‍याफुल्‍ला” भिबान सलाम लजी। ");
INSERT INTO taj_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ओच्‍छे थेनीगदेसे येशूदा थो स्‍वाबान माला कडीसे थोबोरी तोसी फ्‍या लजी। ");
INSERT INTO taj_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","थेह्रङ् लसी येशूदा खिसी लमाहेन्‍से थेनीगदेसे थे वाला वाला पिङगै छोनना क्‍वान स्‍युसी पिन्‍जी। ओच्‍छे येशूदा थेलान क्‍वान क्‍वान्‍सी क्रुसरी टाँगब लसी साइबारी भोर्जी। ");
INSERT INTO taj_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","थेनीगदेसे येशूदा भोर्बान लबा धुइरी कुरेनी भिबा ग्‍लाला सिमोनदा खबान लबा स्‍याप्‍जी। थे अलेक्‍जेन्‍डरदेन रूफसला आबा मुबा। जमाहेन्‍से सिपाहीगदेसे थेदा कर लसी येशूला क्रुस पुइपुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ओच्‍छे थेनीगदेसे येशूदा गलगथा भिबा ग्‍लारी भोर्जी। गलगथा भिबा चा “खप्‍परला ग्‍ला” हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","गलगथारी धोमाहेन्‍से थेनीगदेसे येशूदा अङगुरला निङगुरी लठेब तबा मन युसी पिन्‍जी। तर येशूसे थे आसोल्‍नी। ");
INSERT INTO taj_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","जमाहेन्‍से थेनीगदेसे येशूदा क्रुसरी टाँगब लजी। ओच्‍छे थेनीगदेसे येशूला क्‍वान भो लसी खाल्‍दा खजिबा परब तबा चीम भिसी ह्राङ ह्राङ न्‍हङरी चिट्ठा युजी। ");
INSERT INTO taj_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","येशूदा क्रुसरी टाँगब लबा धुइरी स्‍य्‍होला नौ बजब तमुबा। ");
INSERT INTO taj_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","येशूदा दोष लबा तामरी “चु यहूदीगदेला ग्‍ले” भिसी भ्रिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","थेनीगदेसे येशूदा क्रुसरी टाँगब लबा धुइरी य्‍हो न्‍हीदाएनोन गिकदा दाहिनेपट्टि गिकदा देब्रेपट्टि क्रुसरी टाँगब लजी। ");
INSERT INTO taj_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","परमेश्‍वरला बचनरी भ्रिबा ताम चुह्रङ् लसी पूरा तजी, “थेदा अपराधीगदेदा ह्रङ्नोन लजी।” ");
INSERT INTO taj_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","थेग्‍याम भ्रबा म्‍हिगदेसे थोबो य्‍होङ्बान, “लु, परमेश्‍वरला मन्‍दिर फुप्‍सी सोमरेरीन दोःसी स्‍होला भिबा म्‍हि दान्‍दे एसे ह्राङसे ह्राङदान जोगब लउ, ओच्‍छे क्रुसग्‍याम मार फाप्‍गो” भिसी येशूदा खिसी लजी। ");
INSERT INTO taj_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","32","थेह्रङ् लसीन परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी धर्मगुरुगदेसेएनोन थेनीगदे ह्राङ ह्राङ न्‍हङरी, “चुसे स्‍य्‍हान्‍दोदा चा जोगब लखम्‍जी। तर ह्राङसे ह्राङदा चा जोगब लआखम्‍नी। चु इस्राएलीगदेला ग्‍ले थार्बा पिन्‍बा ख्रीष्‍ट क्रुसग्‍याम मार फाप्‍सी खगै, ओच्‍छे जे य्‍हाङसे थेदा विश्‍वास लला!” भिसी ठट्टा लजी। ओच्‍छे येशूदेन छ्‌याम क्रुसरी टाँगब लबा म्‍हिगदेसेनोन येशूदा खिसी लजी। ");
INSERT INTO taj_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","धिनना बाह्र बजेहेन्‍से तीन बजेधोना य्‍हुल्‍सा नाङनोन धोपधोप तजी। ");
INSERT INTO taj_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ङ्‍यसे तीन बजेरीक्‍यार येशूसे घ्रेन काइरी क्रिङ्बान, “इलोइ इलोइ लामा सबखथनी?” भिसी सुङ्जी। चु भिबा चा “ङाला परमेश्‍वर, ङाला परमेश्‍वर, ह्राङसे ङादा तिग्‍दा ख्‍लाबा?” भिबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","चुह्रङ् लसी क्रिङ्बा म्राङ्सी थेरी राप्‍सी चिबागदे न्‍हङरी कोइ कोइसे “च्‍यागो, चुसे मी एलियादा गा ङ्‌योइबा चीम” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ओच्‍छे थेनीगदे न्‍हङरी गिकसे चा यार्सी निसी अङगुरला कम्‍बा निङगुरी क्‍वानगेन ब्‍लुम्‍सी माला कडीरी खीसी येशूदा ख्‍वामा, “भ्रान्‍गो, भ्रान्‍गो, चुदा एलिया खसी क्रुसग्‍याम मार तेःला वा? च्‍यागे” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","जमाहेन्‍से घ्रेन काइरी क्रिङ्सी येशूला सा निजी। ");
INSERT INTO taj_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","थेनोन धुइरी परमेश्‍वरला मन्‍दिर न्‍हङरी मुबा पर्दा ह्राङनोन तोरहेन्‍से मारधोना पख्‍ले न्‍ही तसी ढेजी। ");
INSERT INTO taj_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","चुह्रङ् लसी येशूला सा निबा म्राङ्सी थेरी क्रुसला ङाच्‍छापट्टि राप्‍सी चिबा रोमी कप्‍तानसे “चु मी साँच्‍चिन परमेश्‍वरला झानोन चीम” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","थेरी कोइ कोइ म्रिङम्‍हेमेगदेसे थारेङग्‍याम च्‍यासी चिबा मुबा। थेनीगदे न्‍हङरी मरियम मग्‍दलिनी, जजा याकूबदेन योसेफला आमा मरियम ओच्‍छे सलोमी मुबा। ");
INSERT INTO taj_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","येशू गालीलरी मुबा धुइरी थेनीगदे येशूला लिच्‍छा लिच्‍छा भ्रसी येशूला सेवा लमुबा। ओच्‍छे थेरी यरूशलेमधोना येशूदेन छ्‌याम खबा ल्‍हानान म्रिङम्‍हेमेगदेएनोन मुबा। ");
INSERT INTO taj_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","चु धिन ब्‍लप्‍बा न्‍हबा धिनना ङाच्‍छाकुनु मुबा। ");
INSERT INTO taj_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","थे धिनकुनु ङ्‍यसे अरिमाथिया भिबा शहरला योसेफ भिबा म्‍हि आलोङ्नान पिलातस मुबा ग्‍लारी निसी येशूला लास ह्रीजी। थे योसेफ यहूदी सभाला मुल सदस्‍या मुबा। थेएनोन परमेश्‍वरसे शासन लबा धुइ खला भिसी भ्रान्‍सी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","येशू सिजी भिबा ताम थेःसी पिलातस उदेक तजी। ओच्‍छे थेसे रोमी कप्‍तानदा ह्राङ मुबा ग्‍लारी ङ्‌योइसी येशू साँच्‍चिन सिबा हिन्‍ना कि आहिन भिसी ङ्‌योइबा छार्बा लजी। ");
INSERT INTO taj_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","रोमी कप्‍तानसे येशू साँच्‍चिन सिबा हिन्‍ना भिमाहेन्‍से पिलातससे येशूला लास योसेफदा भोर्बारी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","योसेफसे ज्‍यबा खाल्‍ला सुतिला क्‍वान ग्‍लुसी भजी। ओच्‍छे येशूला लास क्रुसग्‍याम मार तेःसी थे सुतिला क्‍वानरी रिल्‍जी। थेग्‍याम येशूला लासदा भोर्सी युङबाला पहरारी ठ्वाइसी स्‍होबा धुर्सा न्‍हङरी भोर्सी थान्‍जी। जमाहेन्‍से युङबा ब्‍लिङ्बान भसी धुर्साला म्रापरी थान्‍जी। ");
INSERT INTO taj_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","मरियम मग्‍दलिनीदेन योसेफला आमा मरियमसे येशूला लास थान्‍बा ग्‍ला च्‍यासी चिमुबा। ");
INSERT INTO taj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ब्‍लप्‍बा न्‍हबा धिन निमाहेन्‍से थेनोन धिनकुनु ङ्‍यसे मरियम मग्‍दलिनी, याकूबला आमा मरियमदेन सलोमीसे येशूला लासरी फोर्बाला लागिरी ज्‍यबा बास्‍ना खबा छ्‌युगु ग्‍लुजी। ");
INSERT INTO taj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","न्‍हङगरदङ आइतवार स्‍य्‍होरी धिनी फेबा धुइरी थेनीगदे येशूदा थान्‍बा धुर्सारी निजी। ");
INSERT INTO taj_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","“य्‍हाङदा थे धुर्साला म्रापरी मुबा युङबा खाल्‍से ब्‍लिङ्सी पिन्‍ना?” भिसी थेनीगदे ग्‍यामरीक्‍यार ताम लबान निजी। ");
INSERT INTO taj_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","तर धुर्साला ङाच्‍छापट्टि धोसी च्‍यामा, थे घ्रेन युङबा ङाच्‍छान ब्‍लिङ्सी थान्‍बा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","थेनीगदे धुर्सा न्‍हङरी वाङ्सी च्‍यामा, धुर्साला दाहिनेपट्टि तार क्‍वान क्‍वान्‍सी चिबा भ्‍योन म्‍हि गिकदा म्राङ्जी। चु म्राङ्सी थेनीगदे लोङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","तर थे भ्‍योन म्‍हिसे थेनीगदेदा “थालोङ्‍गो! क्रुसरी साइबा नासरतला येशूदा एनीगदेसे म्‍हाइबान मुला भिबा ताम ङादा था मुला। थेदा सिबाग्‍याम सोना लसी जिन्‍बा मुला। येशू चुरी आरे। एनीगदेन खसी थेदा थान्‍बा ग्‍ला च्‍यागो। ");
INSERT INTO taj_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","दाहेन्‍से निसी थेला चेलागदेदा ओच्‍छे खास लसी पत्रुसदा ‘एनीगदे भन्‍दा ङाच्‍छा येशू गालील अञ्‍चलरी फेप्‍बान मुला। थेसे सुङ्बा ह्रङ्नोन एनीगदेसे थेरी थेदा म्राङ्ला भिसी पाङ्सी पिन्‍गो’” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","जमाहेन्‍से थेनीगदे लोङ्सी फितफित धर्सी धुर्साग्‍याम थोन्‍सी निजी। ओच्‍छे थेनीगदेसे चु ताम खालैदा आपाङ्नी। तिग्‍दा भिसम थेनीगदे ल्‍हानान लोङ्‌बा मुबा। ");
INSERT INTO taj_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","आइतवार स्‍य्‍होरीन येशू सिबाग्‍याम सोमाहेन्‍से जम्‍मान भन्‍दा ङाच्‍छा मरियम मग्‍दलिनी मुबा ग्‍लारी फेप्‍जी। थे मरियमला ल्‍हुइग्‍याम येशूसे गोर निस म्‍हङ ताप्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","जमाहेन्‍से मरियम मग्‍दलिनी येशूला चेलागदे मुबा ग्‍लारी निसी चु ताम थेःना लजी। सेमरी ल्‍हानान दुख तसी थेनीगदे क्रासी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","येशू सोसी ह्राङ मुबा ग्‍लारी फेप्‍खजी भिबा ताम मरियमसे थेनीगदेदा भिजी। तर थेनीगदेसे चु ताम पत्‍याब आतनी। ");
INSERT INTO taj_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","जमाहेन्‍से चेला न्‍ही नाम्‍सारीक्‍यार निबान लबा धुइरी ह्राङला ङाच्‍छापट्टि येशूदा अर्गुन रूपरी म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ओच्‍छे थेनीगदे स्‍य्‍हान्‍दो चेलागदे मुबा ग्‍लारी निसी चु ताम थेःना लजी। तर स्‍य्‍हान्‍दो चेलागदेसे थेनीगदेला ताम पत्‍याब आतनी। ");
INSERT INTO taj_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","जमाहेन्‍से येशू च्‍युक गिक चेलागदे चबान लबा धुइरी थेनीगदे मुबा ग्‍लारी फेप्‍खजी। ओच्‍छे थेनीगदेला सेम कोङ्बादेन म्‍हिगदेसे येशू सिबाग्‍याम सोजी भिसी पाङ्बा ताम विश्‍वास आलबासे लमा येशूसे थेनीगदेदा बङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","येशूसे ह्राङला चेलागदेदा “एनीगदे जम्‍बुलिङला जम्‍मान ग्‍लारी निसी जम्‍मान म्‍हिगदेदा परमेश्‍वरला य्‍हुल्‍साला समाचार थेःना लउ। ");
INSERT INTO taj_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","विश्‍वास लसी बप्‍तिस्‍मा किन्‍बागदेसे थार्बा याङ्ला। तर विश्‍वास आलबा जतिसे चा परमेश्‍वरग्‍याम सजाय याङ्ला। ");
INSERT INTO taj_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ओच्‍छे विश्‍वास लबा म्‍हिगदेदेन छ्‌याम चुह्रङ्बा चिनुगदे तला थेनीगदेसे ङाला मिनरी म्‍हङगदे ताप्‍ला, ओच्‍छे छार छार ग्‍योइरी ताम लला। ");
INSERT INTO taj_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ओच्‍छे थेनीगदेसे पुख्री चुङ्सैनोन, बिख थुङ्सैनोन थेनीगदेदा तिगै आत। थेनीगदेसे आखम्‍बा म्‍हिगदेथोरी या थान्‍सी प्रार्थना लमाहेन्‍से थे म्‍हिगदे खम्‍ला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","चुह्रङ् लसी चेलागदेदेन छ्‌याम ताम लमाहेन्‍से प्रभु येशूदा स्‍वर्गरी भोर्जी। ओच्‍छे येशू परमेश्‍वरला दाहिने छ्‌यापट्टि मुल ठिरी धन्‍छ्‌याजी। ");
INSERT INTO taj_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","जमाहेन्‍से चेलागदे जम्‍मान ग्‍लारी निसी येशूला बारेरी पाङ्सी भ्रजी। थेनीगदेदेन छ्‌याम तसी प्रभुसे गे लजी। ओच्‍छे थेनीगदेसे थेःना लबा तामदा प्रभुसे उदेकला गेग्‍याम चु हिन्‍ना चीम भिसी विश्‍वास तना लजी।");
INSERT INTO taj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","परमेश्‍वरसे ङन्‍ना गुङरी लबा गेला बारेरी ल्‍हानान म्‍हिगदेसे भ्रिबारी छ्‌याइबा मुला। ");
INSERT INTO taj_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ङाच्‍छाहेन्‍सेन येशूसे लबा गेदेन लोप्‍बा ताम म्राङ्बा म्‍हिगदेसे ङन्‍दा थेःना लजी। ");
INSERT INTO taj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","थेतबासेलमा माननीय थियोफिलस, ङाइएनोन ङाच्‍छाहेन्‍सेन जम्‍मान ताम म्‍हाइसी घोबासे लमा ह्राङला लागिरी मेलोसेन भ्रिमा ज्‍यबा तला भिसी म्‍हन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","तिग्‍दा भिसम ह्राङदा पाङ्बा तामगदेरी सत्‍य ताम घोगै भिसी ङाइ चु ह्राङला लागिरी भ्रिबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","यहूदिया य्‍हुल्‍साला हेरोद ग्‍लेला धुइरी अबिया भिबा समूहरी परमेश्‍वरला मन्‍दिररी पूजा लबा जकरिया भिबा म्‍हि मुबा। थेला म्रिङ एलीशिबाएनोन परमेश्‍वरला मन्‍दिररी पूजा लबा हारूनना वंशरी न्‍हबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","परमेश्‍वरसे कुल्‍बा जम्‍मान ताम ङ्‌यान्‍बासे लमा थे न्‍हीनोन परमेश्‍वरला ङाच्‍छा ज्‍यबा म्‍हि मुबा। ");
INSERT INTO taj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","तर एलीशिबाग्‍याम कोला आतबासे लमा थे न्‍हीला कोलागदे आरेबा मुबा। थे न्‍हीला दिङएनोन निसी जिन्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","तिरेकुनु जकरिया ह्राङला समूहला पालोरी परमेश्‍वरला मन्‍दिररी पूजा लबान मुबा। ");
INSERT INTO taj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","परमेश्‍वरला मन्‍दिररी पूजा लबा समूहला ठिम अन्‍छार चिट्ठा युमा, परमप्रभुला मन्‍दिर न्‍हङरी वाङ्सी धूप म्राबा गे जकरियाला मिनरी थोन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","परमेश्‍वरला मन्‍दिर न्‍हङरी धूप म्राबा धुइरी म्‍हिला हुल मङग्‍यार प्रार्थना लसी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","धूप म्राबान लबा धुइरी जकरियासे धूप म्राबा ग्‍लाला दाहिनेपट्टि स्‍वर्गदूत खसी राप्‍सी चिबा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","स्‍वर्गदूतदा म्राङ्सी जकरिया आत्तेब तसी लोङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","तर स्‍वर्गदूतसे थेदा “थालोङ्‍गो जकरिया, तिग्‍दा भिसम परमेश्‍वरसे एला प्रार्थना सान्‍बा मुला। दाहेन्‍से एला म्रिङ एलीशिबासे झा गिक न्‍हला। एसे थेला मिन यूहन्‍ना थान्‍गो। ");
INSERT INTO taj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","थे न्‍हबा धुइरी ए ल्‍हानान ताङ्ला, ओच्‍छे स्‍य्‍हान्‍दो ल्‍हानान म्‍हिगदेएनोन ताङ्ला। ");
INSERT INTO taj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","तिग्‍दा भिसम थे परमप्रभुला ङाच्‍छापट्टि घ्रेन म्‍हि दोला। ओच्‍छे थेसे अङगुरला निङगुदेन खजिबै अर्गु ङ्‌य्‍होइबा स्‍हे आथुङ्। थे आमाला फोरी खमाहेन्‍सेन परमेश्‍वरला आत्‍मा थेदेन छ्‌याम तला। ");
INSERT INTO taj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","थेसे ल्‍हानान इस्राएलीगदेदा परमप्रभु परमेश्‍वरला ग्‍यामरी दोःसी भला। ");
INSERT INTO taj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","आबागदेला सेम कोलागदेपट्टि तना लबारी ओच्‍छे परमेश्‍वरसे कुल्‍बा ताम आङ्‌यान्‍बागदेदा परमेश्‍वरसे कुल्‍बा ताम ङ्‌यान्‍बा म्‍हिगदे ह्रङ्‌बा स्‍होसी प्रभुला ग्‍याम च्‍यासी चिबा य्‍हुल स्‍होबाला लागिरी थे प्रभुला ङाच्‍छा एलियाला आत्‍मादेन शक्तिरी भ्रला। ");
INSERT INTO taj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","जमाहेन्‍से जकरियासे स्‍वर्गदूतदा “ङाइ चु ताम खाह्रङ् लसी विश्‍वास लसे? तिग्‍दा भिसम ङा खेप्‍बा दोसी जिन्‍जी ओच्‍छे ङाला म्रिङलाएनोन दिङ निसी जिन्‍बा मुला” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","स्‍वर्गदूतसे जकरियादा “ङा परमेश्‍वरला ङाच्‍छा राप्‍सी चिबा गब्रिएल हिन्‍ना। ङादा परमेश्‍वरसे एदेन छ्‌याम ताम लबारी ओच्‍छे चु ज्‍यबा समाचार पाङ्‌बारी पुइखबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","एसे ङाइ पाङ्बा ताम विश्‍वास आलबासे लमा चु ताम पूरा आततेधोना एसे ताम पाङ्‌आखम। तर चु ताम ततोःबा धुइरी तनोन तला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","जकरिया परमेश्‍वरला मन्‍दिर न्‍हङरी घइना चिबासे लमा मङग्‍यार जकरियादा भ्रान्‍सी चिबा म्‍हिगदेदा सुर्दा तजी। ");
INSERT INTO taj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","थे परमेश्‍वरला मन्‍दिर न्‍हङ‍ग्‍याम मङग्‍यार थोन्‍सी खमा थेसे तिगै ताम पाङ्आखम्‍नी। थेतबासेलमा मङग्‍यार मुबा म्‍हिगदेसे थेसे तिगै म्राङ्जीनम भिसी म्‍हन्‍जी। जकरियासे थे म्‍हिगदेदा या लिप्‍बान ताम लबारी छ्‌याइजी। ओच्‍छे थे ताम पाङ्आखम्‍बाला आखम्‍बान तजी। ");
INSERT INTO taj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","परमेश्‍वरला मन्‍दिर न्‍हङरी पूजा लतोःबा ह्राङला पालो जिन्‍माहेन्‍से जकरिया दिमरी निजी। ");
INSERT INTO taj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","तिगै धिन लिच्‍छा थेला म्रिङ एलीशिबा न्‍हसेला तजी। जमाहेन्‍से एलीशिबा ला ङाधोना दिम ख्‍लासी खानङएनोन आनिनी। ");
INSERT INTO taj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ओच्‍छे थेसे “दाहेन्‍से खालैसे ङादा हेला थालगै भिसी परमेश्‍वरसे ङादा दया लसी चु लबा हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","गालील अञ्‍चलला नासरत भिबा नाम्‍सारी मरियम भिबा कन्‍याकेटी गिक मुबा। थेदा दाऊद ग्‍लेला वंशला योसेफ भिबा म्‍हिसे ब्‍याह लबारी ह्रीबा मुबा। एलीशिबा न्‍हसेला तबा ला ढु तमा परमेश्‍वरसे गब्रिएल स्‍वर्गदूतदा मरियम मुबा ग्‍लारी पुइखजी। ");
INSERT INTO taj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","जमाहेन्‍से स्‍वर्गदूत थे कन्‍याकेटी मुबा ग्‍लारी निसी, “लास्‍सो माइ, एदा परमेश्‍वरसे ल्‍हानान दयामाया लबा मुला। थेतबासेलमा एदेन छ्‌याम परमप्रभु मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","स्‍वर्गदूतला ताम थेःसी मरियम उदेक तजी। ओच्‍छे “आहिन, चु तिग भिबा?” भिसी सेमरी म्‍हन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","तर स्‍वर्गदूतसे थेदा “थालोङ्‍गो मरियम, तिग्‍दा भिसम परमेश्‍वरसे एदा ल्‍हानान मोलम पिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","दाहेन्‍से ए न्‍हसेला तला ओच्‍छे एसे झा गिक न्‍हला। एसे थेला मिन येशू थान्‍गो। ");
INSERT INTO taj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","थे घ्रेन म्‍हि दोला ओच्‍छे थेदा जम्‍मान भन्‍दा घ्रेन परमेश्‍वरला झा भिला। परमप्रभु परमेश्‍वरसे थेदा दाऊदला य्‍हुल्‍सारी शासन लबारी ग्‍ले स्‍होला। ");
INSERT INTO taj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","थेसे सदनना लागिरी याकूबला वंशथोरी शासन लला। ओच्‍छे थेला शासन खाइमै आजिन” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","स्‍वर्गदूतला चुह्रङ्बा ताम थेःसी मरियमसे “चु खाह्रङ् लसी तला? तिग्‍दा भिसम ङाइ ब्‍याह लबान आरे” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","स्‍वर्गदूतसे मरियमदा “एथोरी परमेश्‍वरला आत्‍मा फेप्‍खला। ओच्‍छे एसे जम्‍मान भन्‍दा घ्रेन परमेश्‍वरला आत्‍माला शक्तिसे कोला न्‍हला। थेतबासेलमा थे कोलादा परमेश्‍वरला झा भिला। ");
INSERT INTO taj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","च्‍यागो, एला ह्राङला म्‍हि एलीशिबादाएनोन दिङ निबासे लमा कोला आन्‍ह भिसी भिमुबा। तर दान्‍दे थे न्‍हसेला तबा ला ढु तबा मुला। ");
INSERT INTO taj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","थेतबासेलमा परमेश्‍वरसे लआखम्‍बा गे तिगै आरे” भिसी मरियमदा जोहाब पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ओच्‍छे मरियमसे स्‍वर्गदूतदा “ङा परमेश्‍वरदा तेन्‍बा म्‍हि हिन्‍ना, ङादा ह्राङसे भिबा ह्रङ्नोन तगै” भिसी भिमाहेन्‍से स्‍वर्गदूत निजी। ");
INSERT INTO taj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","तिगै धिन लिच्‍छा मरियम योना योना लसी यहूदिया अञ्‍चलला गङपट्टिला नाम्‍सा गिकरी निजी। ");
INSERT INTO taj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ओच्‍छे जकरियाला दिमरी वाङ्सी एलीशिबादा “लास्‍सो फ्‍याफुल्‍ला” भिजी। ");
INSERT INTO taj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","मरियमसे लास्‍सो फ्‍याफुल्‍ला भिबा एलीशिबासे थेःमाहेन्‍से एलीशिबाला फोरी मुबा कोला भोल्‍जी। ओच्‍छे एलीशिबाथोरी परमेश्‍वरला आत्‍मा फेप्‍खजी। ");
INSERT INTO taj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","जमाहेन्‍से एलीशिबासे घ्रेन काइ लसी, “म्रिङम्‍हेमेगदे न्‍हङरी ए परमेश्‍वरग्‍याम मोलम याङ्बा म्‍हि हिन्‍ना। ओच्‍छे एला फोरी मुबा कोलादाएनोन ल्‍हानान मोलम पिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","खाल्‍ला दयासे लमा ङा ह्रङ्बाला दिमरी ङाला प्रभुला आमा खजी? ");
INSERT INTO taj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","च्‍यागो, एसे लास्‍सो फ्‍याफुल्‍ला भिबा ङाइ थेःमैछ्‌याम ङाला फोरी मुबा कोला ताङ्सी भोल्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","परमप्रभुसे सुङ्बा ताम पूरा तला भिसी विश्‍वास लबासे लमा एसे परमेश्‍वरग्‍याम मोलम याङ्बा मुला।” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ओच्‍छे मरियमसे चुह्रङ् भिसी व्‍हाइ गोबारी छ्‌याइजी, “ङाला परमप्रभु परमेश्‍वरदा जयजयकार तगै। ");
INSERT INTO taj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ङादा थार्बा पिन्‍बा परमेश्‍वरदेन छ्‌याम ङा सेमहेन्‍सेन ताङ्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","तिग्‍दा भिसम परमेश्‍वरदा तेन्‍बा ङा ह्रङ्‌बा जजा म्‍हिदाएनोन वास्‍ता लबा मुला। दाहेन्‍से जम्‍मान म्‍हिगदेसे ङादा परमेश्‍वरग्‍याम मोलम याङ्बा म्‍हि भिसी भिला। ");
INSERT INTO taj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","तिग्‍दा भिसम जम्‍मान भन्‍दा घ्रेन परमप्रभु परमेश्‍वरसे ङाला लागिरी घ्रेन गे लसी पिन्‍बा मुला। परमप्रभुन परमेश्‍वर हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","परमेश्‍वरदा मान लबा म्‍हिगदेदा परमेश्‍वरसे जुकजुकधोनान दया लला। ");
INSERT INTO taj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ओच्‍छे सेमरी ङा ह्रङ्‌बा खालै आरे भिसी भ्रबा म्‍हिगदेदा परमेश्‍वरसे ह्राङला शक्तिसे ससा बङबङ तना लबा मुला। ");
INSERT INTO taj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","शासन लबा म्‍हिगदेदा परमेश्‍वरसे थेला ग्‍लाग्‍याम तेःबा मुला। ओच्‍छे प्राङबोगदेदा परमेश्‍वरसे घ्रेन म्‍हि स्‍होबा मुला। ");
INSERT INTO taj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ओच्‍छे फोख्रेन्‍बागदेदा परमेश्‍वरसे सदन ज्‍यबा ज्‍यबा स्‍हे पिन्‍सी म्रेन्‍ना लबा मुला। तर फ्‍युक्‍पो म्‍हिगदेदा तिगै आपिन्‍ना या थान्‍थान पुइबा मुला। ");
INSERT INTO taj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","परमेश्‍वरसे ह्राङसे लबा दया ढन्‍सी ह्राङदा तेन्‍बा इस्राएलीगदेदा ह्रो लबा मुला। ");
INSERT INTO taj_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ओच्‍छे य्‍हाङला आखे म्‍हेमेदा सुङ्बा ह्रङ् अब्राहामदेन थेला सन्‍तानगदेदा जुकजुकधोनाला लागिरी दया लबा मुला।” ");
INSERT INTO taj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","मरियम ला सोमधोना एलीशिबादेन छ्‌यामनोन चिसी ह्राङला दिमरी निजी। ");
INSERT INTO taj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ओच्‍छे एलीशिबासे कोला न्‍हबा धुइ तसी थेसे झा न्‍हजी। ");
INSERT INTO taj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","जमाहेन्‍से परमप्रभु परमेश्‍वरसे एलीशिबादा दया लबा मुला भिबा थेःसी थेला ह्राङला म्‍हिदेन खिम्‍जेमगदे ल्‍हानान ताङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","कोला न्‍हसी भ्रेःरे तमाहेन्‍से थेनीगदे थे कोलाला खतना लबारी खजी। ओच्‍छे थेनीगदेसे थे कोलाला मिन थेला आबाला ह्रङ्‌बान जकरिया थान्‍बारी छ्‌याइजी, ");
INSERT INTO taj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","तर थेला आमासे “आहिन, थेला मिन यूहन्‍ना थान्‍तोःला” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","थेनीगदेसे “थेह्रङ्बा मिन एला ह्राङला म्‍हि न्‍हङरी खालैला आरे” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","जमाहेन्‍से थेनीगदेसे थेला आबादा झाला मिन तिग थान्‍बा भिसी या लिप्‍सी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","जकरियासे पाटी गिक ह्रीसी थे पाटीरी थेला मिन यूहन्‍ना हिन्‍ना भिसी भ्रिजी। चुह्रङ्बा म्राङ्सी थेनीगदे जम्‍मान उदेक तजी। ");
INSERT INTO taj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","थेनोन धुइरी जकरियासे ताम पाङ्‌बारी छ्‌याइजी। ओच्‍छे थेसे परमेश्‍वरदा धन्‍यवाद पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","चुह्रङ् तबा म्राङ्सी थेला खिम्‍जेमगदे जम्‍मान उदेक तसी लोङ्‌बा खजी। ओच्‍छे यहूदियाला गङरीक्‍यारला नाम्‍सा नाङनोन चु ताम थेःजी। ");
INSERT INTO taj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","चु ताम थेःबा जति जम्‍मासेन “लिच्‍छा चु कोला खाह्रङ्बा तला” भिसी ह्राङ ह्राङला सेमरी म्‍हन्‍जी। तिग्‍दा भिसम थे कोलादेन छ्‌याम परमेश्‍वर मुबा। ");
INSERT INTO taj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","यूहन्‍नाला आबा जकरियाथोरी परमेश्‍वरला आत्‍मा फेप्‍खजी। ओच्‍छे परमेश्‍वरला आत्‍मासे कुल्‍बा ह्रङ्नोन थेसे पाङ्‌बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“इस्राएलीगदेला परमप्रभु परमेश्‍वरला जयजयकार तगै तिग्‍दा भिसम परमेश्‍वर फेप्‍खसी ह्राङला म्‍हिगदेदा ह्रो लसी पापग्‍याम फेबा मुला! ");
INSERT INTO taj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","परमेश्‍वरसे थेदा तेन्‍बा दाऊदला वंशरी य्‍हाङदा थार्बा पिन्‍बा शक्तिशाली म्‍हि गिक पुइखबा मुला। ");
INSERT INTO taj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","य्‍हाङला शत्रुगदेदेन य्‍हाङदा हेला लबागदेग्‍याम थार्बा पिन्‍ना भिबा ताम दङबोरीन परमेश्‍वरसे ह्राङला अगमवक्तागदेग्‍याम सुङ्सी जिन्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ओच्‍छे परमेश्‍वरसे य्‍हाङला आखे म्‍हेमेदेन छ्‌याम लबा ह्राङला कबुल ढन्‍सी य्‍हाङदा दया लबा मुला। ");
INSERT INTO taj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","थे कबुल परमेश्‍वरसे य्‍हाङला म्‍हेमे अब्राहामदेन छ्‌याम लबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","थेतबासेलमा शत्रुगदेग्‍याम थार्बा याङ्बाला लागिरी आलोङ्ना य्‍हाङ सोतेधोना परमेश्‍वरला ङाच्‍छापट्टि ज्‍यबा म्‍हि दोसी य्‍हाङसे ज्‍यबा गे लसी परमेश्‍वरदा तेन्‍म्‍याङ्‍गै। ");
INSERT INTO taj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ङाला झा, दाहेन्‍से एदा जम्‍मासेन जम्‍मान भन्‍दा घ्रेन परमेश्‍वरला अगमवक्ता भिसी भिला। तिग्‍दा भिसम ए प्रभुला ङाच्‍छा ङाच्‍छा निसी थेला ग्‍याम स्‍होला। ");
INSERT INTO taj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ओच्‍छे पापला दोष मेटब तमाहेन्‍से थार्बा याङ्ला भिसी एसे परमेश्‍वरला म्‍हिगदेदा लोप्‍ला। ");
INSERT INTO taj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","तिग्‍दा भिसम य्‍हाङला परमेश्‍वर दया लबा परमेश्‍वर हिन्‍ना। थेतबासेलमा परमेश्‍वरसे य्‍हाङ मुबा ग्‍लारी स्‍वर्गग्‍याम य्‍हाल पुइखला। ");
INSERT INTO taj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","परमेश्‍वरसे धोपधोपरी भ्रबादेन सिला भिसी लोङ्‌बा म्‍हिगदेदा य्‍हाल पिन्‍ना। ओच्‍छे थेनोन य्‍हालसे य्‍हाङदा शान्‍तिला ग्‍यामरी भ्रपुङ्ला।” ");
INSERT INTO taj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","यूहन्‍ना परमेश्‍वरला आत्‍माग्‍याम ज्ञान बुद्धि याङ्बान घ्रेन तबान निजी। ओच्‍छे इस्राएलीगदेला गुङरी परमेश्‍वरला य्‍हुल्‍साला समाचार थेःना लबा धुइ आततेधोना यूहन्‍ना तोङतोङबा ग्‍लारी चिजी। ");
INSERT INTO taj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","थे धुइरी रोमी ग्‍याल्‍बो कैसर अगस्‍टससे जम्‍मान य्‍हुल्‍साला म्‍हि झ्‍याबाला लागिरी जम्‍मालान मिन भ्रिउ भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","सिरिया भिबा ग्‍लाला हाकिम कुरेनियस मुबा धुइरी चुह्रङ् लसी म्‍हिगदे झ्‍याबा ङाच्‍छा रेम तबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","जमाहेन्‍से जम्‍मान म्‍हिगदे मिन भ्रिबारी ह्राङ ह्राङला आखे म्‍हेमेला नाम्‍सारी निजी। ");
INSERT INTO taj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","थे धुइरी योसेफ गालील अञ्‍चलला नासरत भिबा ग्‍लारी चिबा मुबा। थेएनोन ह्राङला मिन भ्रिबारी यहूदिया अञ्‍चलला बेथलेहेम भिबा दाऊदला शहररी निजी। तिग्‍दा भिसम थे दाऊद ग्‍लेला वंशला मुबा। ");
INSERT INTO taj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ओच्‍छे योसेफसे ह्राङसे ब्‍याह लबारी छ्‌याइबा मरियमदाएनोन छ्‌यामनोन भोर्सी बेथलेहेमरी मिन भ्रिबारी निजी। थे धुइरी मरियम न्‍हसेला मुबा। ");
INSERT INTO taj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","थेनीगदे बेथलेहेमरी मुमान मरियमसे कोला न्‍हबा धुइ तजी। ");
INSERT INTO taj_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","जमाहेन्‍से मरियमसे बेथलेहेमरीन ह्राङला थेबा झा न्‍हजी। थे झादा ल्‍हेथानरी रिल लसी म्‍हे मुइदा खोले पिन्‍बा डूँडरी नाइजी। तिग्‍दा भिसम थेनीगदेसे खजिबै दिमरी चिबा ग्‍ला आयाङ्नी। ");
INSERT INTO taj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","थे ग्‍लाला ङामला पाङग्‍यालरी गोठालोगदे म्‍हुनङ ग्‍युगदे ख्रुङ्‌सी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","थेनोन धुइरी थेनीगदेसे स्‍वर्गदूत गिक म्राङ्जी। ओच्‍छे थेनीगदेला क्‍युर्नोन परमेश्‍वरला स्‍हेरसे य्‍हाल य्‍हाल तजी। चुह्रङ् तबा म्राङ्सी थेनीगदे लोङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","तर स्‍वर्गदूतसे थेनीगदेदा “थालोङ्‍गो! तिग्‍दा भिसम ङाइ एनीगदेला लागिरी थार्बा पिन्‍बा समाचार भसी खबा मुला। चु समाचार जम्‍मान म्‍हिगदेला लागिरी हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","तिनी दाऊदला शहररी एनीगदेदा पापग्‍याम थार्बा पिन्‍बा म्‍हि गिक न्‍हबा मुला। थेनोन थार्बा पिन्‍बा ख्रीष्‍ट प्रभु हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ओच्‍छे एनीगदेला लागिरी चिनु चा चु तला, एनीगदेसे कोला गिकदा ल्‍हेथानसे रिल लसी म्‍हे मुइदा खोले पिन्‍बा डूँडरी नाइसी थान्‍बा स्‍याप्‍ला।” ");
INSERT INTO taj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","थेनोन धुइरी स्‍य्‍हान्‍दो स्‍वर्गदूतला हुल म्राङ्जी। ओच्‍छे थे स्‍वर्गदूतगदेसे परमेश्‍वरदा धन्‍यवादला व्‍हाइ गोबारी छ्‌याइजी, ");
INSERT INTO taj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“स्‍वर्गरी धन्‍छ्‌याबा परमेश्‍वरला जयजयकार, जम्‍बुलिङरी जुन म्‍हिदा परमेश्‍वरसे धम्‍बा मुला थेनीगदेदा शान्‍ति तगै!” ");
INSERT INTO taj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","स्‍वर्गदूतगदे स्‍वर्गरी निमाहेन्‍से गोठालोगदेसे ह्राङ ह्राङ न्‍हङरी “लु, भ्रउ, य्‍हाङदा परमेश्‍वरसे सुङ्बा चु ल्‍हेङमो च्‍याबारी बेथलेहेमरी निइ” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","जमाहेन्‍से थेनीगदे योना योना लसी बेथलेहेमरी निजी। थेरी थेनीगदेसे मरियमदेन योसेफ ओच्‍छे लैनु कोलादा चा म्‍हे मुइदा खोले पिन्‍बा डूँडरी नाइसी थान्‍बा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","जमाहेन्‍से थे कोलाला बारेरी थेनीगदेदा स्‍वर्गदूतसे पाङ्बा ताम थेनीगदेसे जम्‍मान म्‍हिगदेदा थेःना लजी। ");
INSERT INTO taj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ओच्‍छे गोठालोगदेसे पाङ्बा ताम थेःबा म्‍हिगदे जम्‍मान उदेक तजी। ");
INSERT INTO taj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","तर मरियमसे चा चु जम्‍मान ताम म्‍हन्‍सी सेमरीन थान्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ओच्‍छे स्‍वर्गदूतसे भिबा ह्रङ्नोन म्राङ्बासे लमा गोठालोगदेसे परमेश्‍वरदा घ्रेन मानदेन जयजयकार लसी धन्‍यवादला व्‍हाइ गोबान निजी। ");
INSERT INTO taj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","थे कोला न्‍हसी भ्रेःरे तमा खतना लबा धुइरी थेला मिन येशू थान्‍जी। थेला मिन आमाला फोरी खबा भन्‍दा ङाच्‍छान स्‍वर्गदूतसे पाङ्बा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ओच्‍छे मोशाला ठिम अन्‍छार थेनीगदे चोख्‍याब लबा धुइ तमाहेन्‍से येशूदा थेला आबादेन आमासे परमप्रभुला ङाच्‍छा अर्पण लबाला लागिरी यरूशलेमरी परमेश्‍वरला मन्‍दिररी भजी। ");
INSERT INTO taj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","परमप्रभुसे मोशादा पिन्‍बा ठिमरी भ्रिबा अन्‍छार जम्‍मान भन्‍दा ङाच्‍छा न्‍हबा झा परमप्रभुला लागिरी फेसी थान्‍तोःबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ओच्‍छे परमेश्‍वरसे मोशादा पिन्‍बा ठिमरी मुबा अन्‍छार जोर गिक ढुकुर तसै जोर गिक परेवा तसै परमप्रभुदा फुल्‍तोःबासे लमा थेनीगदे बलि फुल्‍बारी खजी। ");
INSERT INTO taj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","थे धुइरी यरूशलेमरी शिमियोन भिबा म्‍हि गिक मुबा। थे परमेश्‍वरसे म्‍हन्‍बा अन्‍छार भ्रबादेन परमेश्‍वरदा तेन्‍बा म्‍हि मुबा। थेदा परमेश्‍वरसे इस्राएलीगदेदा थार्बा पिन्‍बा म्‍हि पुइखला भिसी सुङ्बा ताम पूरा लला भिसी भ्रान्‍सी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ओच्‍छे “थार्बा पिन्‍बा ख्रीष्‍टदा आम्राङ्तेधोना ए आसि” भिसी परमेश्‍वरला आत्‍मासे ङाच्‍छान थेदा पाङ्बा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","परमेश्‍वरला आत्‍मासे कुल्‍बा ह्रङ् शिमियोन परमेश्‍वरला मन्‍दिररी निजी। थे धुइरी येशूला आबादेन आमासे परमेश्‍वरसे मोशादा पिन्‍बा ठिम अन्‍छार तिग लतोःबा मुबा, थे लबारी येशूदा परमेश्‍वरला मन्‍दिररी भसी खजी। ");
INSERT INTO taj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","जमाहेन्‍से शिमियोनसे लैनु येशूदा कुरी किन्‍सी परमेश्‍वरदा धन्‍यवाद पिन्‍सी चुह्रङ् भिजी, ");
INSERT INTO taj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“परमप्रभु ह्राङसे सुङ्बा ताम पूरा तबा मुला। दाहेन्‍से ह्राङदा तेन्‍बा म्‍हि ङा सिसै ढुक्‍क मुला। ");
INSERT INTO taj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","तिग्‍दा भिसम ह्राङसे कबुल लबा ह्रङ्नोन थार्बा पिन्‍बा ख्रीष्‍टदा ङाइ म्राङ्सी जिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","चु कोलादा ह्राङसे जम्‍मान म्‍हिगदेला लागिरी पुइखबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","अर्गु य्‍हुलला म्‍हिगदेदा ख्रीष्‍टसेन ह्राङला ग्‍याम उन्‍ना, ओच्‍छे चुसे लमा इस्राएलीगदेसे मान याङ्ला।” ");
INSERT INTO taj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ओच्‍छे शिमियोनसे लैनु येशूला बारेरी पाङ्बा ताम थेःसी येशूला आबादेन आमा उदेक तजी। ");
INSERT INTO taj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","जमाहेन्‍से शिमियोनसे मरियमदा मोलम पिन्‍बान भिजी, “च्‍यागो, चु लैनु इस्राएलीगदेदा थार्बा पिन्‍बादेन नाश लबाला लागिरी परमेश्‍वरसे पिन्‍बा चिनु हिन्‍ना। थेदा ल्‍हानान म्‍हिगदेसे बिरोध लला। ");
INSERT INTO taj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","थेतबासेलमा ल्‍हानान म्‍हिला सेमरी म्‍हन्‍बा तामगदे परमेश्‍वरसे उन्‍ना। ओच्‍छे एला सेमरी ल्‍हानान दुख तला।” ");
INSERT INTO taj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","थेरी आशेर वंशला फनुएलला झामे हन्‍ना भिबा बोगल ब्‍लिसे ब्‍लि दिङ तबा म्रिङम्‍हेमे गिक मुबा। थे अगमवक्तास्‍या मुबा, ब्‍याह तसी निस दिङ तमा थेला ह्रेम्‍बो सिजी। ओच्‍छे थे फोइथान चिसी धिन म्‍हुननोन परमेश्‍वरला मन्‍दिररी प्रार्थना लबान परमेश्‍वरदा तेन्‍मुबा। ");
INSERT INTO taj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","थेनोन धुइरी हन्‍ना खसी परमेश्‍वरदा धन्‍यवाद पिन्‍जी। ओच्‍छे थेसे परमेश्‍वरसे यरूशलेमदा पापग्‍याम फेबा धुइदा भ्रान्‍सी चिबा म्‍हिगदेदा थे कोलाला बारेरी पाङ्सी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","जमाहेन्‍से थेनीगदेसे परमेश्‍वरसे मोशादा पिन्‍बा ठिम अन्‍छार लतोःबा जम्‍मान गे जिन्‍ना लसी गालील अञ्‍चलला ह्राङलान नासरत शहररी निजी। ");
INSERT INTO taj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","लैनु येशू घ्रेन घ्रेन तबान खमाहेन्‍से थेला बुद्धिएनोन खजी। तिग्‍दा भिसम परमेश्‍वरला मोलम थेदेन छ्‌याम मुबा। ");
INSERT INTO taj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाडरी चाडला ठिम अन्‍छार येशूला आबा आमा दिङएदङसे यरूशलेमरी निबा लमुबा। थेतबासेलमा येशू च्‍युक न्‍ही दिङ तमाएनोन येशूला आबादेन आमासे येशूदा छ्‌यामनोन भोर्सी यरूशलेमरी निजी। ");
INSERT INTO taj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","चाड धङ्‍सी जिन्‍माहेन्‍से थेनीगदे दिमरी निजी। तर येशू चा यरूशलेमरीन धन्‍छ्‌याजी। चु ताम थेला आबादेन आमासे था आयाङ्नी। ");
INSERT INTO taj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","येशूला आबादेन आमासे येशू म्‍हिला हुलरी मुला तला भिसी म्‍हन्‍सी तिरेला ग्‍याम भ्रसी निजी। ओच्‍छे थेनीगदेसे येशूदा ह्राङला म्‍हिदेन ङोसेबा म्‍हिगदे मुबा ग्‍लारी निसी म्‍हाइजी, ");
INSERT INTO taj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","तर आस्‍याप्‍बासे लमा थेनीगदे थेदा म्‍हाइबान यरूशलेमरी दोःसी खजी। ");
INSERT INTO taj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","थेनीगदेसे सोमरेरी येशूदा परमेश्‍वरला मन्‍दिररी स्‍याप्‍जी। थेरी थे यहूदी धर्मगुरुगदेदेन छ्‌याम धन्‍छ्‌यासी थेनीगदेसे पाङ्बा ताम ङ्‌यान्‍सी, ङ्‌योइबा छार्बा लसी धन्‍छ्‌याबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","थेरी येशूला ताम ङ्‌यान्‍सी चिबागदे येशूसे ताम घोसी जोहाब पिन्‍बा म्राङ्सी उदेक तबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","येशूला आबादेन आमासे थेदा म्राङ्सी उदेक म्‍हन्‍सी थेला आमासे “च्‍यागो झा, एला आबादेन ङा एदा म्‍हाइमा म्‍हाइमा हैरान तजी, एसे चुह्रङ् तिग लबा?” भिमा, ");
INSERT INTO taj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","येशूसे थेनीगदेदा “ह्राङनीसे ङादा तिग्‍दा म्‍हाइबा? ङा ङाला आबाला दिमरी चितोःबा भिसी ह्राङनीदा था आरे?” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","तर थेला आबादेन आमासे चु ताम आघोनी। ");
INSERT INTO taj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","जमाहेन्‍से येशू ह्राङला आबा आमादेन छ्‌यामनोन नासरतरी फेप्‍जी। ओच्‍छे ह्राङला आबा आमासे पाङ्बा ताम ङ्‌यान्‍सी धन्‍छ्‌याजी। तर थेला आमासे चु जम्‍मान ताम ह्राङला सेमरीन थान्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ओच्‍छे येशू परमेश्‍वरदेन म्‍हिगदेला दयामायारी घ्रेन घ्रेन तमाहेन्‍से बुद्धिनोन बढब तबान निजी। ");
INSERT INTO taj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","रोमी ग्‍याल्‍बो कैसर तिबेरियाससे शासन लबा च्‍युक ङा दिङ तमा पन्‍तियस पिलातस भिबा म्‍हि यहूदिया अञ्‍चलला हाकिम मुबा। जमा धुइरी हेरोद गालील अञ्‍चलला ग्‍ले मुबा, ओच्‍छे थेला आले फिलिप इतुरियादेन त्राखोनितिस भिबा ग्‍लाला ग्‍ले मुबा, थेह्रङ् लसीन लुसानियास अबिलेने अञ्‍चलला ग्‍ले मुबा। ");
INSERT INTO taj_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ओच्‍छे हन्‍नासदेन कैयाफा परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हि मुबा। थेनोन धुइरी परमेश्‍वरसे जकरियाला झा तोङतोङबा ग्‍लारी चिबा यूहन्‍ना मुबा ग्‍लारी ह्राङला बचन पुइखजी। ");
INSERT INTO taj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","यूहन्‍नासे म्‍हिगदेदा ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःगो, ओच्‍छे बप्‍तिस्‍मा किन्‍गो। जमाहेन्‍से परमेश्‍वरसे एनीगदेला पापला दोष मेटब लला भिबान थार्बा पिन्‍बा समाचार थेःना लबान यर्दन स्‍योङला क्‍यारमारला जिल्‍लारीक्‍यार खजी। ");
INSERT INTO taj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","चु ताम यशैया भिबा अगमवक्तासे चुह्रङ् लसी भ्रिबा मुबा, “तोङतोङबा ग्‍लारीक्‍यार म्‍हि गिक क्रिङ्बान चुह्रङ् भिसी भ्रला, ‘परमप्रभुला ग्‍याम तयार लउ, ओच्‍छे परमप्रभु भ्रबाला लागिरी थेला ग्‍याम सोजो स्‍होउ, ");
INSERT INTO taj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","मुबा जे गङदेन होपगदे सम्‍म स्‍होला, ओच्‍छे काङलाङ कुङलीङबा ग्‍यामगदे सोजो तला ओच्‍छे पगल पोगल मुबा ग्‍लाएनोन सम्‍म तला। ");
INSERT INTO taj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","जमाहेन्‍से जम्‍मान म्‍हिगदेसे परमेश्‍वरसे पिन्‍बा थार्बा म्राङ्ला।’” ");
INSERT INTO taj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","थेतबासेलमा यूहन्‍नासे बप्‍तिस्‍मा किन्‍बारी खबा म्‍हिगदेदा चुह्रङ् भिसी पाङ्जी, “पुख्रीला कोलागदे, एनीगदेदा परमेश्‍वरला बोमोग्‍याम स्‍योरम्‍याङ्ला भिसी खाल्‍से भिजी? ");
INSERT INTO taj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","चुदे एनीगदे ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःबान हिन्‍सम परमेश्‍वरदा सेम निबा गे लउ, ओच्‍छे एनीगदे ह्राङ ह्राङ न्‍हङरी ङनी अब्राहामला कोलागदे भिसी पाङ्‌बारी थाम्‍हाइगो। तिग्‍दा भिसम परमेश्‍वरसे अब्राहामला लागिरी चु युङबागदेग्‍यामसेनोन कोलागदे स्‍होबारी खम्‍ला। ");
INSERT INTO taj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","च्‍यागो, दोङ थाबारी तरी थीसी जिन्‍बा मुला। थेतबासेलमा ज्‍यबा रो आरोबा जम्‍मान दोङ टाहेन्‍सेन थासी मेरी फर्ला।” ");
INSERT INTO taj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","जमाहेन्‍से म्‍हिगदेसे यूहन्‍नादा “थेह्रङ् भिसम दाहेन्‍से ङन्‍से तिग लउ?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","यूहन्‍नासे थेनीगदेदा “जुन म्‍हिदेन छ्‌याम स्‍हुर्दम न्‍ही मुला थेसे आरेबा म्‍हिदा पिन्‍गै, ओच्‍छे जुन म्‍हिदेन छ्‌याम चबा स्‍हे मुला थेसे आरेबागदेदा भो लसी पिन्‍गै” भिसी जोहाब पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ओच्‍छे तिरो दुइबा म्‍हिगदेएनोन यूहन्‍ना मुबा ग्‍लारी बप्‍तिस्‍मा किन्‍बारी खसी, “गुरु, ङन्‍से चा तिग लउ?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","यूहन्‍नासे थेनीगदेदा “एनीगदेसे तिरो दुइमा सरकारसे तोगब लबा भन्‍दा ल्‍हाना थाकिन्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ओच्‍छे सिपाहीगदेएनोन खसी, “ङन्‍से चा तिग लउ?” भिसी ङ्‌योइजी। यूहन्‍नासे थेनीगदेदा “खालैदा अत्‍याचार लसी आहिन्‍बा तामदा हिन्‍ना भिसी टाङगा थाकिन्‍गो, ह्राङला खतोःबा जे टाङगा किन्‍सी सन्‍तोक लसी चिउ” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","जमा धुइरी म्‍हिगदेसे थार्बा पिन्‍बा ख्रीष्‍ट फेप्‍खला भिसी आश लसी चिबा मुबा। थेतबासेलमा थेनीगदेसे यूहन्‍नादा म्राङ्सी चुनोन ख्रीष्‍ट हिन्‍ना वा भिसी सेमरी म्‍हन्‍सी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","तर यूहन्‍नासे थेनीगदेदा “ङाइ एनीगदेदा क्‍युइसे बप्‍तिस्‍मा पिन्‍ना। तर ङा भन्‍दा शक्तिशाली फेप्‍खबान मुला ङा थेला लखमला तुना ब्‍लबाधोनाला आरे। थेसे एनीगदेदा परमेश्‍वरला आत्‍मादेन मेसे बप्‍तिस्‍मा पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ग्‍वा य्‍हाप्‍बा नाख्‍ले थेलान छ्‌यारी मुला। थेसे खलारी ग्‍वा ज्‍यना लसी य्‍हाप्‍सी ग्‍वा जति भकारीरी युला। ओच्‍छे पोलोवा जति खाइमै आसिबा मेरी ख्राङ्ला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","चुह्रङ् लसी यूहन्‍नासे अर्गु ल्‍हानान अर्ती पिन्‍सी, लोप्‍सी म्‍हिगदेदा परमेश्‍वरला य्‍हुल्‍साला समाचार थेःना लजी। ");
INSERT INTO taj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","तर हेरोद ग्‍लेसे ह्राङला आले चाङ हेरोदियास भिबादा थान्‍बासे लमा थेला जम्‍मान पाप गे म्राङ्सी यूहन्‍नासे थेदा बङ्बा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","थेतबासेलमा थेसे यूहन्‍नादा झ्‍याल्‍खानरी झाङ्‌सी पापथोरी झन पाप गे लजी। ");
INSERT INTO taj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","म्‍हिगदेसे बप्‍तिस्‍मा किन्‍बान लबा धुइरी येशूसेनोन बप्‍तिस्‍मा किन्‍जी। थेसे प्रार्थना लबान लबा धुइरी स्‍वर्ग ठोङ्‌बा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ओच्‍छे परमेश्‍वरला आत्‍मा थेथोरी ढुकुर ह्रङ् लसी फाप्‍खजी। ओच्‍छे स्‍वर्गग्‍याम “ए ङाइ सेमहेन्‍से माया लबा ङाला झा हिन्‍ना, ए म्राङ्सी ङा ल्‍हानान ताङ्‍बा मुला” भिबा काइ खजी। ");
INSERT INTO taj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","येशूसे ह्राङला गे लबारी छ्‌याइबा धुइरी येशू बोगल गिकसे च्‍युइ दिङ तबा मुबा। जम्‍मान म्‍हिगदेसे येशू योसेफलान झा भिसी म्‍हन्‍बा मुबा। योसेफ एलीला झा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","एली मत्तातला झा, मत्तात लेवीला झा, लेवी मल्‍कीला झा, मल्‍की यान्‍नाला झा, यान्‍ना योसेफला झा, ");
INSERT INTO taj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","योसेफ मत्ताथियासला झा, मत्ताथियस आमोसला झा, आमोस नहूमला झा, नहूम इसलीला झा, इसली नग्‍गैला झा, ");
INSERT INTO taj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","नग्‍गै माथला झा, माथ मत्ताथियासला झा, मत्ताथियस सेमैनला झा, सेमैन योसेखला झा, योसेख योदाला झा, ");
INSERT INTO taj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","योदा योआननला झा, योआनन रेसाला झा, रेसा यरुबाबेलला झा, यरुबाबेल शालतिएलला झा, शालतिएल नेरीला झा, ");
INSERT INTO taj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","नेरी मल्‍कीला झा, मल्‍की अद्दीला झा, अद्दी कोसामला झा, कोसाम एलमादमला झा, एलमादम एर्‌ला झा, ");
INSERT INTO taj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","एर् यहोशूला झा, यहोशू एलीएजरला झा, एलीएजर योरीमला झा, योरीम मत्तातला झा, मत्तात लेवीला झा, ");
INSERT INTO taj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","लेवी शिमियोनला झा, शिमियोन यहूदाला झा, यहूदा योसेफला झा, योसेफ योनानला झा, योनान एल्‍याकीमला झा, ");
INSERT INTO taj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","एल्‍याकीम मलेआला झा, मलेआ मिन्‍नाला झा, मिन्‍ना मत्ताथाला झा, मत्ताथा नातानला झा, नातान दाऊद ग्‍लेला सन्‍तान, ");
INSERT INTO taj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","दाऊद यिशैला झा, यिशै ओबेदला झा, ओबेद बोअजला झा, बोअज सल्‍मोनला झा, सल्‍मोन नहशोनला झा, ");
INSERT INTO taj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","नहशोन अम्‍मीनादाबला झा, अम्‍मीनादाब आरामला झा, आराम हेस्रोनला झा, हेस्रोन फारेसला झा, फारेस यहूदाला झा, ");
INSERT INTO taj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","यहूदा याकूबला झा, याकूब इसहाकला झा, इसहाक अब्राहामला झा, अब्राहाम तेरहला झा, तेरह नाहोरला झा, ");
INSERT INTO taj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","नाहोर सरूगला झा, सरूग रऊला झा, रऊ पेलेगला झा, पेलेग एबेरला झा, एबेर शेलहला झा, ");
INSERT INTO taj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","शेलह केनानला झा, केनान अर्पक्षदला झा, अर्पक्षद शेमला झा, शेम नोआला झा, नोआ लेमेखला झा, ");
INSERT INTO taj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","लेमेख मतूशेलहला झा, मतूशेलह हनोकला झा, हनोक येरेदला झा, येरेद महलालेलला झा, महलालेल केनानला झा, ");
INSERT INTO taj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","केनान एनोशला झा, एनोश शेतला झा, शेत आदमला झा, आदम परमेश्‍वरला झा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","परमेश्‍वरला आत्‍मा येशूथोरी फेप्‍खमाहेन्‍से येशू यर्दन स्‍योङग्‍याम दोःजी। ओच्‍छे परमेश्‍वरला आत्‍मासे थेदा तोङतोङबा ग्‍लारी भोर्जी। ");
INSERT INTO taj_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","थेरी शैतानसे येशूदा बोगल न्‍ही धिनधोना फसब लबारी म्‍हाइजी। ओच्‍छे बोगल न्‍ही धिनधोना येशूसे तिगै आसोल्‍नी। थेतबासेलमा येशूदा ल्‍हानान फोख्रेन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","थेनोन धुइरी शैतानसे येशूदा “ह्राङ परमेश्‍वरला झा हिन्‍बान हिन्‍सम चु युङबादा गेङ स्‍होउ” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ओच्‍छे येशूसे शैतानदा “गेङसे जे म्‍हि आसो भिसी बचनरी भ्रिबा मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","6","जमाहेन्‍से शैतानसे येशूदा नोबा गङरी भोर्सी जम्‍बुलिङला जम्‍मान य्‍हुल्‍सागदे उन्‍बान, “ङाइ ह्राङदा चु जम्‍मान य्‍हुल्‍साला ग्‍लेदेन चु जम्‍मान धन सम्‍पत्तिला मालिक स्‍होला, तिग्‍दा भिसम चु जम्‍मान ङादा पिन्‍बा मुला। ओच्‍छे ङाला सेमसे म्‍हन्‍बादा ङाइ पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","थेतबासेलमा ह्राङसे ङादा फ्‍या लजी भिसम चु जम्‍मान ह्राङला तला” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","येशूसे थेदा “बचनरी चुह्रङ् भिसी भ्रिबा मुला, ‘एसे ह्राङला परमप्रभु परमेश्‍वरदा फ्‍या लउ, ओच्‍छे थेदा जे तेन्‍गो’” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","दोःसी शैतानसे येशूदा यरूशलेमरी भोर्सी परमेश्‍वरला मन्‍दिरला थोबोरी राप्‍पुङ्जी। ओच्‍छे थेसे येशूदा चुह्रङ् भिसी भिजी, “ह्राङ पक्‍कान परमेश्‍वरला झा हिन्‍सम चु ग्‍याम मार छ्‌योङ्‍गो, ");
INSERT INTO taj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","तिग्‍दा भिसम बचनरी चुह्रङ् भिसी भ्रिबा मुला, ‘परमेश्‍वरसे ह्राङदा जोगब लबाला लागिरी ह्राङला स्‍वर्गदूतगदेदा कुल्‍ला। ");
INSERT INTO taj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ओच्‍छे एला काङ युङबारी थाठोक्‍गै भिसी थेनीगदेसे एदा या यारीन ताला’ भिसी भ्रिबा मुला।” ");
INSERT INTO taj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","तर येशूसे थेदा “बचनरी चुह्रङ्बाएनोन भ्रिबा मुला, ‘एसे ह्राङला परमप्रभु परमेश्‍वरला सेम च्‍याबा गे तिगै थालउ’” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","जमाहेन्‍से शैतानसे येशूदा तिगै लसी फसब लबारी आखम्‍बासे लमा दोःसी मौका आयाङ्‌तेधोना थेसे येशूदा ख्‍लासी निजी। ");
INSERT INTO taj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","जमाहेन्‍से परमेश्‍वरला आत्‍माला शक्तिरी येशू गालील अञ्‍चलरी दोःसी फेप्‍खजी। ओच्‍छे थेला बारेरी क्‍यारमारला जम्‍मान ग्‍लारी थेःजी। ");
INSERT INTO taj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","येशू यहूदीगदे ह्रुप तबा दिम दिमरी फेप्‍सी म्‍हिगदेदा लोप्‍बारी छ्‌याइजी। जमाहेन्‍से जम्‍मान म्‍हिगदेसे थेला जयजयकार लजी। ");
INSERT INTO taj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","जमाहेन्‍से येशू ह्राङ छर्बा नासरत नाम्‍सारी फेप्‍खजी। ओच्‍छे थे सदन ह्रङ् लसी ब्‍लप्‍बा न्‍हबा धिनकुनु यहूदीगदे ह्रुप तबा दिमरी फेप्‍सी परमेश्‍वरला बचनग्‍याम पढब लबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ओच्‍छे थेदा यशैया अगमवक्तासे भ्रिबा किताब पढब लबाला लागिरी पिन्‍जी। जमाहेन्‍से थे ठोङ्सी चुह्रङ् भिसी भ्रिबा ग्‍ला तेःसी पढब लजी। ");
INSERT INTO taj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“परमप्रभु परमेश्‍वरला आत्‍मा ङादेन छ्‌याम मुला। तिग्‍दा भिसम प्राङबोगदेदा परमेश्‍वरला य्‍हुल्‍साला समाचार थेःना लबारी ओच्‍छे झ्‍याल्‍खानरी मुबागदेदा परमेश्‍वरला य्‍हुल्‍साला समाचार थेःना लसी झ्‍याल्‍खानग्‍याम तेःबारी, मी आम्राङ्बागदेदा मी म्राङ्ना लबारी ओच्‍छे दुखरी मुबागदेदा दुखग्‍याम फेबारी, ");
INSERT INTO taj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","थेह्रङ् लसीन ह्राङला म्‍हिगदेदा परमेश्‍वरसे थार्बा पिन्‍बा धुइ खसी जिन्‍बा मुला भिसी थेःना लबारी परमेश्‍वरसे ङादा धम्‍सी पुइखबा हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","जमाहेन्‍से येशूसे किताब बन्‍द लसी थेरी मुबा म्‍हिदा पिन्‍सी धन्‍छ्‌याजी। यहूदीगदे ह्रुप तबा दिमरी मुबा जम्‍मान म्‍हिगदेसे येशूदा च्‍यासी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ओच्‍छे येशूसे थेनीगदेदा “परमेश्‍वरला बचनरी भ्रिबा चु ताम तिनी एनीगदेसे ङ्‌यान्‍ना ङ्‌यान्‍नान पूरा तबा मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","येशूसे सुङ्बा दयामायाला ताम थेःसी थेनीगदे उदेक म्‍हन्‍सी जम्‍मासेन थेला तामदा ज्‍यबा भिजी। ओच्‍छे “चु योसेफला झा आहिन?” भिसी थेनीगदेसे भिजी। ");
INSERT INTO taj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","येशूसे थेनीगदेदा “एनीगदेसे ङादा पक्‍कान चु उखान भिला ‘डाक्‍टर, ह्राङसे ह्राङदान खम्‍ना लउ। एसे कफर्नहुमरी उदेकला गे लजी भिसी ङन्‍से थेःमुबा थे गे एसे ह्राङला नाम्‍सारीनोन लउ’ भिसी पाङ्ला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","दोःसी येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “च्‍यागो, खजिबै अगमवक्तादा ह्राङलान नाम्‍सारी मान आल। ");
INSERT INTO taj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","तर ङ्‌यान्‍गो, चु सत्‍य हिन्‍ना। तिग्‍दा भिसम एलियाला धुइरी इस्राएलरी ह्रेम्‍बो सिबा म्रिङम्‍हेमेगदे ल्‍हानान मुबा। थे धुइरी सोम दिङसे ला ढुधोना नाम आखबासे लमा य्‍हुल्‍सा नाङनोन अनिकाल तबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","तर परमेश्‍वरसे एलियादा स्‍य्‍हान्‍दो खालै मुबा ग्‍लारी आपुइना सीदोनला सारपत भिबा नाम्‍सारी मुबा ह्रेम्‍बो सिबा म्रिङम्‍हेमे मुबा ग्‍लारी जे पुइजी। ");
INSERT INTO taj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","थेह्रङ् लसीन एलीशा अगमवक्ताला धुइरीएनोन इस्राएलरी कोरे खबा म्‍हिगदे ल्‍हानान मुबा। तर थेनीगदे न्‍हङरी सिरिया य्‍हुल्‍साला नामान भिबा कोरेला जे कोरे म्‍हाजी। तर स्‍य्‍हान्‍दो म्‍हिगदे खालैलान आम्‍हानी।” ");
INSERT INTO taj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","चु ताम थेःसी यहूदीगदे ह्रुप तबा दिमरी मुबा जम्‍मान म्‍हिगदेदा बोमो खजी। ");
INSERT INTO taj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","जमाहेन्‍से थेरी मुबा म्‍हिगदेसे येशूदा शहरग्‍याम मङग्‍यार तेःजी। थे शहर गङरी मुबा, थेतबासेलमा थेनीगदेसे येशूदा गङला जोरी भोर्सी ह्रिल्‍ना लबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","तर येशू थे म्‍हिगदेला गुङग्‍याम थोन्‍सी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","जमाहेन्‍से येशू गालीलला कफर्नहुम भिबा शहररी फेप्‍जी। ओच्‍छे ब्‍लप्‍बा न्‍हबा धिनकुनु म्‍हिगदेदा परमेश्‍वरला बचनग्‍याम लोप्‍बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","येशूसे लोप्‍बा म्राङ्सी थेनीगदे उदेक तजी। तिग्‍दा भिसम येशूसे अधिकार लसी म्‍हिगदेदा लोप्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","यहूदीगदे ह्रुप तबा दिम न्‍हङरी म्‍हङसे स्‍याप्‍बा म्‍हि गिक मुबा। थे म्‍हङसे स्‍याप्‍बा म्‍हिसे क्रिङ्बान, ");
INSERT INTO taj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“नासरतला येशू, ह्राङसे ङन्‍दा तिग लबारी छ्‌याइबा? तिग ह्राङ ङन्‍दा साइबारी फेप्‍खबा हिन्‍ना? ह्राङ परमेश्‍वरसे पुइखबा परमेश्‍वरला म्‍हि भिसी ङादा था मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","चुह्रङ् भिबा थेःसी येशूसे थे म्‍हङदा बङ्‍बान, “कुटिसी चिउ! थे म्‍हिग्‍याम थोन्‍सी निउ!” सुङ्मैछ्‌याम थे म्‍हिदा जम्‍मान म्‍हिला ओन्‍छाङरी लछार पछार लसी थोन्‍सी निजी, तर थे म्‍हिदा तिगै आतनी। ");
INSERT INTO taj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","चु म्राङ्सी जम्‍मान म्‍हिगदे उदेक म्‍हन्‍सी, “चु म्‍हिला बोली बचनरी खाह्रङ्बा अधिकार चीम, थेला अधिकारदेन शक्तिसे कुल्‍मैछ्‌याम म्‍हङगदे थोन्‍सी यार्बा चीम!” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ओच्‍छे येशूसे लबा गे कफर्नहुम शहरला क्‍यारमारला जम्‍मान ग्‍लारी थेःजी। ");
INSERT INTO taj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","येशू यहूदीगदे ह्रुप तबा दिमग्‍याम थोन्‍सी सिमोनना दिमरी फेप्‍जी। थेरी सिमोनना स्‍युमी छवा खसी आखम्‍बा मुबा। ओच्‍छे दिमरी मुबागदेसे “थेदा खम्‍ना लसी पिन्‍गो” भिसी बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","जमाहेन्‍से येशू सिमोनना स्‍युमीला ङामरी फेप्‍सी छवादा म्‍हासी निउ भिसी सुङ्मा थेला छवा म्‍हाजी। ओच्‍छे सिमोनना स्‍युमी तुरुन्‍तन रेःसी थेनीगदेदा क्‍योङ्बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ओच्‍छे धिनी घल्‍माहेन्‍से म्‍हिगदेसे ल्‍हानान थरीला रोगसे स्‍याप्‍बा म्‍हिगदेदा येशू मुबा ग्‍लारी भजी। जमाहेन्‍से येशूसे थेनीगदेथोरी ह्राङला या थान्‍सी थेनीगदे जम्‍मादान खम्‍ना लजी। ");
INSERT INTO taj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","जमाहेन्‍से ल्‍हानान म्‍हिगदेला ल्‍हुइग्‍याम म्‍हङगदे चुह्रङ् भिबान क्रिङ्सी थोन्‍जी, “ह्राङ परमेश्‍वरला झा हिन्‍ना।” तर येशूसे थे म्‍हङगदेदा बङ्‍बान दोःसी तिगै ताम पाङ्आपुङ्नी। तिग्‍दा भिसम येशू थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍ना भिसी थे म्‍हङगदेसे ङोसेबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","स्‍य्‍हो तमाहेन्‍से येशू सुनसान ग्‍लारी फेप्‍जी। जमाहेन्‍से म्‍हिला हुलसे म्‍हाइबान येशू मुबा ग्‍लारी धोखजी। ओच्‍छे थेनीगदेसे येशूदा “ङन्‍दा ख्‍लासी थाफेप्‍गो” भिसी रोकब लबारी म्‍हाइजी। ");
INSERT INTO taj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","तर येशूसे थेनीगदेदा “ङाइ अर्गु ग्‍लागदेरीएनोन परमेश्‍वरला य्‍हुल्‍साला समाचार थेःना लतोःबा मुला। तिग्‍दा भिसम परमेश्‍वरसे ङादा चुलान लागिरी पुइखबा हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","जमाहेन्‍से येशू यहूदियाला यहूदीगदे ह्रुप तबा दिमगदेरी फेप्‍सी थार्बा पिन्‍बा समाचार थेःना लजी। ");
INSERT INTO taj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","परमेश्‍वरला बचन ङ्‌यान्‍बाला लागिरी ल्‍हानान म्‍हिगदे येशूला क्‍युर्सीन तोर हुइ मार हुइ लबान मुबा। थेतबासेलमा येशू गनेसरेत भिबा घ्‍योइला कुनीरी राप्‍सी धन्‍छ्‌याबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ओच्‍छे येशूसे घ्‍योइला कुनीरी दोँगा न्‍ही म्राङ्जी। थे धुइरी माझीगदे दोँगा ख्‍लासी ह्राङ ह्राङला घ्‍याङ ख्रुबान मुबा। ");
INSERT INTO taj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","थेरी मुबा दोँगा गिक चा सिमोनना मुबा। येशू सिमोनना दोँगारी क्रेःसी, “दोँगा जजाकी क्‍याथाङ भोर्गो” भिसी सिमोनदा सुङ्जी। थे दोँगारी धन्‍छ्‌यासी म्‍हिगदेदा लोप्‍बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","लोप्‍सी जिन्‍माहेन्‍से येशूसे सिमोनदा “दोँगा नुप्‍बा ग्‍लारीक्‍यार भोर्गो, ओच्‍छे तार्ङा चुङ्बारी घ्‍याङ रोप्‍गो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","चु थेःसी सिमोनसे येशूदा “गुरु, ङन्‍से म्‍हुन गिक घ्‍याङ क्‍लाङ्सैनोन तार्ङा गिकनोन आस्‍याप्‍नी। तर ह्राङसे कुल्‍बासे लमा ङाइ घ्‍याङ रोप्‍ला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ओच्‍छे थेनीगदेसे घ्‍याङ रोप्‍माहेन्‍से तार्ङा ल्‍हानान स्‍याप्‍बासे लमा घ्‍याङनोन ढेबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","थेतबासेलमा थेनीगदेसे अर्गु दोँगारी मुबा ह्राङला ह्रोगदेदा गुहार ह्रीजी। जमाहेन्‍से थेनीगदे खसी तार्ङा तेःबारी छ्‌याइजी। तार्ङा तेः‍मा तेः‍मा दोँगा न्‍हीरीन तार्ङा ल्‍हानान तबासे लमा दोँगा न्‍हीनोन डुबब तबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","चु म्राङ्सी सिमोन पत्रुससे येशूला स्‍य्‍हापरी फ्‍या लसी, “प्रभु, ङा पापी म्‍हि हिन्‍ना। थेतबासेलमा ह्राङ ङा मुबाग्‍याम फेप्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","तिग्‍दा भिसम ल्‍हानान तार्ङा स्‍याप्‍बासे लमा सिमोनदेन थेला ह्रोगदे उदेक तजी। ");
INSERT INTO taj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ओच्‍छे सिमोनदेन छ्‌याम ढिक्‍सी गे लबा जब्‍दियाला झागदे याकूबदेन यूहन्‍नादाएनोन ल्‍हानान उदेक तजी। जमाहेन्‍से येशूसे सिमोनदा “थालोङ्‍गो, दाहेन्‍से ए तार्ङा चुङ्बा म्‍हि आहिन, तर एसे म्‍हिगदेदा परमेश्‍वर मुबा ग्‍लारी भला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","जमाहेन्‍से थेनीगदेसे दोँगा घ्‍योइला कुनीरी भसी ह्राङदेन छ्‌याम मुबा जम्‍मान स्‍हेगदे ख्‍लासी येशूदेन छ्‌याम भ्रजी। ");
INSERT INTO taj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","तिरेकुनु येशू शहर गिकरी मुबा। ओच्‍छे थेनोन शहररी मुबा कोरे खबा म्‍हि गिकसे येशूदा म्राङ्जी। जमाहेन्‍से थे येशूला ङामरी खसी फ्‍या लबान, “प्रभु, ह्राङला सेम मुसम ह्राङसे ङादा खम्‍ना लखम्‍ला” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","येशूसे थेदा ह्राङला छ्‌यासे थुर्सी, “ए खम्‍गै भिबा ङाला सेम मुला, ए खम्‍गो” भिसी सुङ्मैछ्‌याम थेला कोरे म्‍हाजी। ");
INSERT INTO taj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","जमाहेन्‍से येशूसे थेदा “च्‍यागो, एसे चु ताम खालैदा थापाङ्‍गो! बरु ए निसी परमेश्‍वरला मन्‍दिररी पूजा लबा म्‍हिदा उन्‍गो। ओच्‍छे एला कोरे म्‍हाजी भिसी म्‍हिगदेसे था याङ्बाला लागिरी परमेश्‍वरसे मोशादा पिन्‍बा ठिमसे कुल्‍बा अन्‍छार बलि फुल्‍गो” भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","जमाकुनुहेन्‍से झन जम्‍मान ग्‍लारी येशूसे लबा गेला बारेरी थेःजी। थेतबासेलमा म्‍हिगदे येशूला ताम ङ्‌यान्‍बारीदेन ह्राङला रोग म्‍हागै भिसी येशू मुबा ग्‍लारी खजी। ");
INSERT INTO taj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","तर येशू चा सुनसान ग्‍लारी फेप्‍सी प्रार्थना लबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","तिरेकुनु येशूसे म्‍हिगदेदा लोप्‍बान लबा धुइरी गालील अञ्‍चलदेन यहूदिया अञ्‍चलला नाम्‍सा नाम्‍साग्‍यामसे ओच्‍छे यरूशलेमग्‍याम खबा फरिसीगदेदेन यहूदी धर्मगुरुगदेएनोन थेरी मुबा। येशूदेन छ्‌याम आखम्‍बा म्‍हिगदेदा खम्‍ना लबा परमप्रभुला शक्ति मुबा। ");
INSERT INTO taj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","थेनोन धुइरी म्‍हिगदेसे कुज्‍या म्‍हि गिकदा खाटरीन पुइसी भजी। ओच्‍छे थेनीगदेसे थे कुज्‍या म्‍हिदा दिम न्‍हङरी येशूला ङाच्‍छापट्टि भोर्बारी म्‍हाइजी। ");
INSERT INTO taj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","तर म्‍हिला हुलसे लमा थेनीगदेसे थे कुज्‍या म्‍हिदा येशूला ङाच्‍छापट्टि भोर्बाला लागिरी ग्‍याम आयाङ्नी। थेतबासेलमा थेनीगदेसे थे कुज्‍या म्‍हिदा मङग्‍यारग्‍यामसे छानारी भोर्जी। ओच्‍छे छाना होक्‍सी थेदा तीबा नान्‍बादेन छ्‌यामनोन येशूला ङाच्‍छापट्टि धोना लजी। ");
INSERT INTO taj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","थे म्‍हिगदेला विश्‍वास म्राङ्सी येशूसे थे कुज्‍या म्‍हिदा “ङाइ एला पापला दोष मेटब लबा मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","येशूसे चुह्रङ् सुङ्बा म्राङ्सी यहूदी धर्मगुरुगदेदेन फरिसीगदेसे “ह्राङसे ह्राङदान परमेश्‍वर स्‍होसी ताम लबा चु म्‍हि खाल हिन्‍ना? म्‍हिगदेला पापला दोष मी परमेश्‍वरसे जे मेटब लखम्‍मुला” भिसी ह्राङ ह्राङ न्‍हङरी पाङ्‌बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","येशूसे थेनीगदेला सेमला ताम था याङ्सी चुह्रङ् भिसी सुङ्जी, “एनीगदेला सेमरी तिग्‍दा चुह्रङ्बा म्‍हन्‍बा? ");
INSERT INTO taj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","चु कुज्‍या म्‍हिदा ‘एला पाप माफ तबा मुला’ भिबादेन ‘रेःसी भ्रउ’ भिबारी खजिबा चा सजिलो मुला? ");
INSERT INTO taj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","तर च्‍यागो, परमेश्‍वरसे पुइखबा म्‍हिदा चु जम्‍बुलिङरी म्‍हिगदेला पापला दोष मेटब लबा अधिकार मुला भिबा तामला प्रमाण ङाइ एनीगदेदा उन्‍ना।” जमाहेन्‍से येशूसे थे कुज्‍या म्‍हिदा “ए रेःगो, ओच्‍छे एला तीबा नान्‍बा पुइसी दिमरी निउ।” ");
INSERT INTO taj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","येशूसे थेह्रङ् सुङ्मैछ्‌याम थे कुज्‍या म्‍हि डोङ रेःसी ह्राङला तीबा नान्‍बा पुइसी परमेश्‍वरला जयजयकार लबान दिमरी निजी। ");
INSERT INTO taj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","जमाहेन्‍से थेरी मुबा जम्‍मान म्‍हिगदे लोङ्सी उदेक म्‍हन्‍जी। ओच्‍छे परमेश्‍वरला जयजयकार लबान, “तिनी य्‍हाङसे ल्‍हानान उदेकला गे म्राङ्जी” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","थेग्‍याम फेप्‍बान लबा धुइरी येशूसे लेवी भिबा तिरो दुइबा म्‍हिदा तिरो दुइबा ग्‍लारी चिबान लबा म्राङ्जी। ओच्‍छे येशूसे थेदा “ङादेन छ्‌याम भ्रउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","जमाहेन्‍से लेवीसे जम्‍मान स्‍हे ख्‍लासी रेःजी ओच्‍छे येशूदेन छ्‌याम भ्रजी। ");
INSERT INTO taj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ओच्‍छे लेवीसे येशूदा ह्राङला दिमरी भोज सोल्‍बारी ङ्‌योइजी। थेरी येशूदेन छ्‌याम भोज चबारी चिबा म्‍हिगदे न्‍हङरी तिरो दुइबा म्‍हिगदेदेन ल्‍हानान स्‍य्‍हान्‍दो म्‍हिगदेएनोन मुबा। ");
INSERT INTO taj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","जमाहेन्‍से फरिसीगदेदेन थेनीगदेला धर्मगुरुगदेसे येशूला चेलागदेदा बिरोध लबान, “तिग्‍दा एनीगदे तिरो दुइबा म्‍हिगदे ओच्‍छे स्‍य्‍हान्‍दो पापीगदेदेन छ्‌याम चिसी चबा थुङ्बा लबा?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","येशूसे थेनीगदेदा “खम्‍बा म्‍हिदा डाक्‍टर आतोः, तर आखम्‍बा म्‍हिदा जे डाक्‍टर तोःला! ");
INSERT INTO taj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","थेतबासेलमा परमेश्‍वरला ङाच्‍छा ज्‍यबा मुबा म्‍हिगदेदा आहिन, तर ङनी पापी हिन्‍ना भिसी भ्रबा म्‍हिगदेसे ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःगै भिसी ङ्‌योइबारी ङा खबा हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","जमाहेन्‍से थेनीगदेसे येशूदा “यूहन्‍नाला चेलागदे सदन फोइथान चिसी प्रार्थना लमुला। ओच्‍छे फरिसीगदेला चेलागदेसेनोन थेह्रङ्नोन लमुला। तर ह्राङला चेलागदेसे चा तिग्‍दा फोइथान चिसी प्रार्थना आलबा?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","येशूसे थेनीगदेदा “म्‍हाछार जन्‍तीगदेदेन छ्‌याम मुतेधोना थेनीगदेदा खाह्रङ् लसी फोइथान चिउ भिखम्‍ला? ");
INSERT INTO taj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","तर म्‍हाछार थेनीगदेग्‍याम फेसी भोर्बा धुइरी जे थेनीगदे फोइथान चिला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ओच्‍छे येशूसे थेनीगदेदा उखान गिकएनोन सुङ्बान, “खालै म्‍हिसे बोक्‍टो क्‍वानरी छार क्‍वानगेन्‍से आख्‍या। थेह्रङ् लसी ख्‍याजी भिसम छार क्‍वानएनोन न्‍होङ्ला ओच्‍छे छार क्‍वानगेन बोक्‍टो क्‍वानदेन छ्‌याम ढिकएनोन आढिक। ");
INSERT INTO taj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ओच्‍छे खालै म्‍हिसे ढिला बोक्‍टो ताङरी अङगुरला कलिलो निङगु आयु, युजी भिसम कलिलो निङगुसे ढिला बोक्‍टो ताङ भोसी ढेला। जमाहेन्‍से निङगु ङेला ओच्‍छे ढिला ताङएनोन गे आखेल्‍बा तला। ");
INSERT INTO taj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","थेतबासेलमा कलिलो निङगु छार ढिला ताङरी युसी थान्‍तोःबा मुला। ");
INSERT INTO taj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","खालैसे चिप्‍बा निङगु थुङ्सी कलिलो निङगु थुङ्बा सेम आल, तिग्‍दा भिसम थेसे चिप्‍बा निङगुन ज्‍यबा भिला।” ");
INSERT INTO taj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ब्‍लप्‍बा न्‍हबा धिनकुनु येशू बुग्‍याम फेप्‍बान मुबा। थे धुइरी थेला चेलागदेसे ग्‍वाला नम थुसी यारी न्‍हइसी चबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","तर फरिसीगदे न्‍हङरी कोइ कोइसे “थेनीगदेदा ब्‍लप्‍बा न्‍हबा धिनकुनु लबारी आतबा गे एनीगदेसे तिग्‍दा लबा?” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदेसे परमेश्‍वरला बचन पढब लबा आरे? दाऊदसे थेदेन छ्‌याम मुबागदे फोख्रेन्‍बा धुइरी थेसे तिग लजी? ");
INSERT INTO taj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","थेसे परमेश्‍वरला मन्‍दिररी पूजा लबा म्‍हिगदे बाहेक स्‍य्‍हान्‍दोसे चबारी आतबा गेङ परमेश्‍वरला दिमरी वाङ्सी तेःसी चजी। ओच्‍छे थेसे ह्राङदेन छ्‌याम मुबागदेदाएनोन पिन्‍मा खालैसेन तिगै भिजी?” ");
INSERT INTO taj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","जमाहेन्‍से येशूसे थेनीगदेदा “परमेश्‍वरसे पुइखबा म्‍हि ब्‍लप्‍बा न्‍हबा धिनना प्रभु हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ब्‍लप्‍बा न्‍हबा अर्गु धिनकुनु येशूसे यहूदीगदे ह्रुप तबा दिम न्‍हङरी परमेश्‍वरला य्‍हुल्‍साला बारेरी लोप्‍बारी छ्‌याइजी। थेरी दाहिने या खर्बा म्‍हि गिक मुबा। ");
INSERT INTO taj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ब्‍लप्‍बा न्‍हबा धिनकुनु येशूसे थे म्‍हिला खर्बा या खम्‍ना लला वा भिसी यहूदी धर्मगुरुगदेदेन फरिसीगदेसे दोष लबाला लागिरी चिवा लसी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","तर येशूसे थेनीगदेला सेमला ताम था याङ्सी थे या खर्बा मुबा म्‍हिदा “ए रेःसी चुरी राप्‍गो” भिसी सुङ्जी। ओच्‍छे थे म्‍हि राप्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","जमाहेन्‍से येशूसे थेनीगदेदा “थेह्रङ् भिसम चु तामला जोहाब पिन्‍गो, ब्‍लप्‍बा न्‍हबा धिनकुनु ज्‍यबा लबादेन नइबा लबा, अथवा म्‍हि सोना लबादेन सिना लबा खजिबा चा ज्‍यबा हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ओच्‍छे येशूसे ह्राङला क्‍युर्सीन मुबा म्‍हिगदेदा स्‍हीसी थे या खर्बा मुबा म्‍हिदा “एला या तन्‍गब लउ!” भिसी सुङ्जी। ओच्‍छे थेसे या तन्‍गब लमैछ्‌याम थेला या खम्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","चु म्राङ्सी फरिसीगदेदा बोमो रेःसी दाहेन्‍से येशूदा तिग लबा भिसी ह्राङ ह्राङ न्‍हङरी सल्‍लाह लजी। ");
INSERT INTO taj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","तिरेकुनु येशू गङरी फेप्‍सी म्‍हुन गिकनोन परमेश्‍वरदेन छ्‌याम प्रार्थना लजी। ");
INSERT INTO taj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ओच्‍छे स्‍य्‍हो तमाहेन्‍से येशूसे ह्राङला चेलागदेदा ङ्‌योइसी थेनीगदे न्‍हङरी च्‍युक न्‍ही चेलादा धम्‍जी। ओच्‍छे थेनीगदेदा मुल चेला भिसी मिन थान्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","सिमोनदा येशूसे पत्रुस भिसी सुङ्जी, थेला आले अन्‍द्रियास ओच्‍छे याकूब, यूहन्‍ना, फिलिप, बारथोलोमाइ, ");
INSERT INTO taj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","मत्ती, थोमा, अल्‍फयसला झा याकूब ओच्‍छे सिमोन। चु सिमोनदा ह्राङला य्‍हुल्‍सादा माया लबा म्‍हि भिसी भिमुबा। ");
INSERT INTO taj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ओच्‍छे याकूबला झा यहूदा, ओच्‍छे यहूदा इस्‍करियोत चुनोन यहूदा इस्‍करियोतसे लिच्‍छा येशूदा चुङ्सी म्‍हिगदेला यारी जिम्‍मा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","येशू ह्राङसे धम्‍बा चेलागदेदेन छ्‌याम गङग्‍याम मार फाप्‍सी सम्‍म ग्‍लारी फेप्‍खसी राप्‍सी धन्‍छ्‌याजी। जमाहेन्‍से येशूदेन छ्‌याम भ्रबा म्‍हिला हुल ओच्‍छे यहूदिया अञ्‍चलला जम्‍मान ग्‍लादेन यरूशलेम, ओच्‍छे टुरोसदेन सीदोन भिबा ग्‍लाग्‍याम म्‍हिला हुल ");
INSERT INTO taj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","येशूसे लोप्‍बा ताम ङ्‌यान्‍बारी ओच्‍छे ह्राङ ह्राङला रोगगदे म्‍हाना लबारी खजी। थेरी म्‍हङसे स्‍याप्‍सी आखम्‍बा म्‍हिगदेएनोन खम्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","थेतबासेलमा जम्‍मान म्‍हिगदेसे येशूदा थुर्बारी म्‍हाइमुबा। तिग्‍दा भिसम येशूदेन छ्‌याम म्‍हिगदेदा खम्‍ना लबा शक्ति मुबा। थे शक्तिग्‍याम रोगसे स्‍याप्‍बा जम्‍मान म्‍हिगदे खम्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","जमाहेन्‍से येशूसे ह्राङला चेलागदेदा स्‍हीबान चुह्रङ् भिसी सुङ्जी, “दुख याङ्बा म्‍हिगदे, एनीगदेसे परमेश्‍वरग्‍याम मोलम याङ्ला। तिग्‍दा भिसम परमेश्‍वरला य्‍हुल्‍सा एनीगदेलान हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","फोख्रेन्‍बा म्‍हिगदे, एनीगदेसे परमेश्‍वरग्‍याम मोलम याङ्ला। तिग्‍दा भिसम एनीगदेदा परमेश्‍वरसे म्रेन्‍ना लला। ओच्‍छे क्राबा म्‍हिगदे, एनीगदेसे परमेश्‍वरग्‍याम मोलम याङ्ला। तिग्‍दा भिसम परमेश्‍वरसे एनीगदे ताङ्सी ङेःम्‍याङ्‍ला। ");
INSERT INTO taj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“परमेश्‍वरसे पुइखबा म्‍हिदा विश्‍वास लबासे लमा म्‍हिगदेसे एनीगदेदा हेला लसी नाम्‍साग्‍यामसे तेःला ओच्‍छे जम्‍मासेन एनीगदेदा खिसी लमाएनोन एनीगदेसे परमेश्‍वरग्‍याम मोलम याङ्ला। ");
INSERT INTO taj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“थे धुइरी एनीगदे फुरफुर ताङ्‍गो। तिग्‍दा भिसम स्‍वर्गरी एनीगदेसे घ्रेन इनाम याङ्ला। एनीगदेदा दुख पिन्‍बागदेला आखे म्‍हेमेगदेसेनोन अगमवक्तागदेदा चुह्रङ्‌नोन लमुबा। ");
INSERT INTO taj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","फ्‍युक्‍पोगदे, एनीगदेसे परमेश्‍वरग्‍याम सजाय याङ्ला। तिग्‍दा भिसम एनीगदेसे मोजमजा लसी जिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","म्रेन्‍बागदे, एनीगदे फोइथाननोन चितोःला। तिग्‍दा भिसम एनीगदेसे परमेश्‍वरग्‍याम सजाय याङ्ला। ओच्‍छे ताङ्बागदे दुख नासी क्रासी चितोःला। तिग्‍दा भिसम एनीगदेसे परमेश्‍वरग्‍याम सजाय याङ्ला। ");
INSERT INTO taj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","म्‍हिगदेग्‍याम मान याङ्बागदे, एनीगदेसे परमेश्‍वरग्‍याम सजाय याङ्ला। तिग्‍दा भिसम एनीगदेला आखे म्‍हेमेगदेसेनोन फट्टा अगमवक्तागदेदा चुह्रङ्‌नोन लमुबा। ");
INSERT INTO taj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“तर ङाइ लोप्‍बा ताम ङ्‌यान्‍बागदेदा ङाइ भिला, एनीगदेसे ह्राङला शत्रुगदेदा माया लउ, ओच्‍छे ह्राङदा हेला लबागदेदा ज्‍यबा व्‍यवहार लउ। ");
INSERT INTO taj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","एनीगदेदा केःबागदेदा परमेश्‍वरसे मोलम पिन्‍गै भिसी प्रार्थना लउ। ओच्‍छे खालैसे एनीगदेदा आज्‍यबा लजी भिसम थेनीगदेदा ज्‍यबा तगै भिसी परमेश्‍वरदेन छ्‌याम प्रार्थना लउ। ");
INSERT INTO taj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","खालैसे एदा ग्रम्‍बा गिकरी तोजी भसम अर्गुपट्टिला ग्रम्‍बाएनोन तासी पिन्‍गो। ओच्‍छे एला स्‍कोट भोर्बारी छ्‌याइबादा स्‍हुर्दमदाएनोन पिन्‍गो। ");
INSERT INTO taj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","एदेन छ्‌याम ह्रीबागदेदा पिन्‍गो, ओच्‍छे एसे थेदेन छ्‌याम दोःसी थाह्रीगो। ");
INSERT INTO taj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","एनीगदेदा स्‍य्‍हान्‍दो म्‍हिगदेसे जस्‍तो व्‍यवहार लगै भिसी म्‍हन्‍बा मुला, एनीगदेसेनोन स्‍य्‍हान्‍दोगदेदा थेह्रङ्नोन लउ। ");
INSERT INTO taj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“चुदे एनीगदेदा माया लबादा जे एनीगदेसे माया लजी भिसम एनीगदेदा तिग ज्‍यबा तला? तिग्‍दा भिसम पापीगदेसेनोन ह्राङदा माया लबागदेदा माया लमुला। ");
INSERT INTO taj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ओच्‍छे एनीगदेसे ह्राङदा ज्‍यबा लबादा जे ज्‍यबा लजी भिसम एनीगदेदा तिग ज्‍यबा तला? तिग्‍दा भिसम पापीगदेसेनोन थेह्रङ्नोन लमुला। ");
INSERT INTO taj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","चुदे एनीगदेसे दोःसी याङ्बा सेम लसी खालैदा छे पिन्‍जी भिसम एनीगदेदा तिग ज्‍यबा तला? तिग्‍दा भिसम पापीगदेसे जे जति छे पिन्‍बा मुला ओतेन किन्‍बा आश लसी पापीगदेदान छे पिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","तर ह्राङला शत्रुगदेदा माया लउ, जम्‍मादान ज्‍यबा लउ, दोःसी किन्‍बा सेम लसी छे थापिन्‍गो ओच्‍छे एनीगदेला मान घ्रेन तला। एनीगदे स्‍वर्गरी धन्‍छ्‌याबा जम्‍मान भन्‍दा घ्रेन परमेश्‍वरला सन्‍तान तला। तिग्‍दा भिसम परमेश्‍वरसे बैगुनीदेन ह्राङला जे ग्‍याम च्‍याबा म्‍हिगदेदाएनोन दया लमुला। ");
INSERT INTO taj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","थेतबासेलमा एनीगदेला परमेश्‍वर आबासे दया लबा ह्रङ् एनीगदेसेनोन दया लउ। ");
INSERT INTO taj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“स्‍य्‍हान्‍दोदा दोष लसी थाभ्रउ ओच्‍छे परमेश्‍वरसेनोन एनीगदेदा दोष आल। म्‍हिगदेला निसाफ लसी थाभ्रउ ओच्‍छे परमेश्‍वरसेनोन एनीगदेला निसाफ आल। म्‍हिगदेदा माफ पिन्‍गो ओच्‍छे परमेश्‍वरसेनोन एनीगदेदा माफ पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","म्‍हिगदेदा पिन्‍गो ओच्‍छे परमेश्‍वरसेनोन एनीगदेदा पिन्‍ना। परमेश्‍वरसे मी छुइसी छुइसी पिन्‍ना ओच्‍छे जुन दप्‍बा स्‍हेसे एनीगदेसे स्‍य्‍हान्‍दोगदेदा पिन्‍ना, थेनोन दप्‍बा स्‍हेसे एनीगदेसे याङ्ला।” ");
INSERT INTO taj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","येशूसे थेनीगदेदा उखानग्‍याम चुह्रङ् भिसी सुङ्जी, “तिग मी आम्राङ्बा म्‍हिसे मी आम्राङ्बा म्‍हिदान डोर्‍याब लखम्‍ला? चुदे थेसे डोर्‍याब लजी भिसम थे न्‍हीनोन व्‍हाङरी ताइला। ");
INSERT INTO taj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ओच्‍छे खजिबै चेला ह्राङला गुरु भन्‍दा घ्रेन आत, तर थेसे लोप्‍सी जिन्‍माहेन्‍से गुरु ह्रङ्‌बान तला। ");
INSERT INTO taj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“स्‍य्‍हान्‍दोला गोरी सेः भ्रबा म्राङ्बासे ह्राङला गोरी मुइ भ्रबा तिग्‍दा आम्राङ्बा? ");
INSERT INTO taj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ह्राङला गोरी भ्रबा मुइ आम्राङ्बासे खाह्रङ् लसी आलेदा ‘खाइ, एला गोला सेः तेःसी पिन्‍ना भिसी भिखम्‍ला।’ कप्‍टी, ङाच्‍छा ह्राङला गोला मुइ तेःगो, ओच्‍छे जे एसे आलेला गोरी भ्रबा सेः तेःबारी खम्‍ला। ");
INSERT INTO taj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“ज्‍यबा दोङरी आज्‍यबा रो आरो ओच्‍छे आज्‍यबा दोङरी ज्‍यबा रो आरो। ");
INSERT INTO taj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","जम्‍मान दोङ थेरी रोबा रो अन्‍छार ङोसेला। पुजुला दोङग्‍याम अञ्‍जीर आथु ओच्‍छे पोलाङला दोङग्‍यामएनोन अङगुर आथु। ");
INSERT INTO taj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","तिग्‍दा भिसम ज्‍यबा सेम मुबा म्‍हिला सेम न्‍हङ‍ग्‍याम ज्‍यबान ताम थोन्‍मुला ओच्‍छे नइबा सेम मुबा म्‍हिला सेम न्‍हङ‍ग्‍याम नइबान ताम थोन्‍मुला। थेतबासेलमा म्‍हिला सेम न्‍हङरी जे मुला थेनोन थेला सुङग्‍याम पाङ्ला। ");
INSERT INTO taj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“ङाइ कुल्‍बा ताम आङ्‌यान्‍सम तिग्‍दा ङादा ‘प्रभु, प्रभु’ जे भिबा? ");
INSERT INTO taj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ङा मुबा ग्‍लारी खबा म्‍हिसे ङाइ पाङ्बा ताम ङ्‌यान्‍ना ओच्‍छे ङाइ कुल्‍बा अन्‍छार गे लला। थे खाह्रङ्बा म्‍हि हिन्‍ना भिबा ताम ङाइ एनीगदेदा पाङ्ला। थे म्‍हिसे ");
INSERT INTO taj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ह्राङला दिम स्‍होबा धुइरी जग नुप्‍ना ख्‍वसी स्‍होजी। ओच्‍छे नाम, भाल खमा थे दिमरी टजी। तसैनोन थे दिम आफुप्‍नी, तिग्‍दा भिसम थे दिमला जग नुप्‍ना ख्‍वसी स्‍होबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","तर जुन म्‍हिसे ङाइ पाङ्बा ताम थेःसी थे अन्‍छार गे आल थे म्‍हि चा जग नुप्‍ना आख्‍वना दिम स्‍होबा म्‍हि ह्रङ्‌बा हिन्‍ना। थेतबासेलमा नाम, भाल बाढी खबा धुइरी थे दिमरी टसी थे दिम फुप्‍सी ल्‍हानान नोक्‍सान तजी।” ");
INSERT INTO taj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","चुह्रङ् सुङ्सी जिन्‍माहेन्‍से येशू कफर्नहुम भिबा ग्‍लारी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","थेरी रोमी कप्‍तान गिकला नोकर आखम्‍ना सिबारीन छ्‌याइबा मुबा। थेसे थे नोकरदा ल्‍हानान माया लमुबा। ");
INSERT INTO taj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","थेतबासेलमा थेसे ह्राङला नोकरदा खम्‍ना लगै भिसी येशूदा फेप्‍खउ भिसी ङ्‌योइबाला लागिरी यहूदी गन्‍बागदेदा पुइजी। तिग्‍दा भिसम थेसे येशूला बारेरी थेःबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","जमाहेन्‍से थेनीगदे येशू मुबा ग्‍लारी खसी बिन्‍ती लबान, “थे ह्राङला दया याङ्तोःबा खाल्‍ला म्‍हि हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","तिग्‍दा भिसम थेसे य्‍हाङ यहूदी य्‍हुलदा माया लमुला, ओच्‍छे थेसेन यहूदीगदे ह्रुप तबा दिम स्‍होसी पिन्‍बा हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","जमाहेन्‍से येशू थेनीगदेदेन छ्‌याम फेप्‍जी। येशू कप्‍तानला दिम ङामरी धोमा, कप्‍तानसे ह्राङला ह्रोगदेदा चुह्रङ् भिउ भिसी येशू मुबा ग्‍लारी पुइजी, “प्रभु ह्राङसे दुख थालउ। तिग्‍दा भिसम ह्राङ ङाला दिमरी फेप्‍खबाधोनाला ङा आरे। ");
INSERT INTO taj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ङाएनोन ह्राङ मुबा ग्‍लारी खबाधोनाला आम्‍हन्‍नी। थेतबासेलमा ह्राङसे ङाला नोकर खम्‍गै भिसी सुङ् जे सुङ्सैनोन थे खम्‍ला। ");
INSERT INTO taj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","तिग्‍दा भिसम ङाएनोन ङाला हाकिमला तहरी चिबा म्‍हि हिन्‍ना। ङाला तहरीनोन सिपाहीगदे मुला। ङाइ कोइदा निउ भिमा निमुला, कोइदा खउ भिमा खमुला। ओच्‍छे ङाला नोकरदा ङाइ चुह्रङ् लउ भिमा थेसे थेह्रङ्नोन लमुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","थेला चुह्रङ्बा ताम थेःसी येशू उदेक तजी, ओच्‍छे म्‍हिला हुलपट्टि दोःसी, “एनीगदेसे ङाला ताम ङ्‌यान्‍गो, इस्राएल य्‍हुल्‍साला म्‍हिगदे न्‍हङरीनोन ङाइ चुह्रङ्बा घ्रेन विश्‍वास मुबा म्‍हि आस्‍याप्‍नी” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","जमाहेन्‍से कप्‍तानसे येशू मुबा ग्‍लारी पुइबा म्‍हिगदे दोःसी दिमरी निमा, थे नोकर खम्‍सी जिन्‍बा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","न्‍हङगरदङ येशू नाइन भिबा शहररी फेप्‍मा ह्राङला चेलागदेदेन म्‍हिला हुलएनोन येशूदेन छ्‌याम निजी। ");
INSERT INTO taj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ओच्‍छे येशू शहररी धोबारीन छ्‌याइमा सिबा म्‍हि भबान मुबा। थे सिबा म्‍हि ह्रेम्‍बो सिबा म्रिङम्‍हेमेला गिक जेन झा मुबा। ओच्‍छे शहरला म्‍हिगदेएनोन थेदेन छ्‌याम मुबा। ");
INSERT INTO taj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","थे म्रिङम्‍हेमेदा म्राङ्सी प्रभुदा सेमहेन्‍सेन दया रेःजी। ओच्‍छे थेदा “ए थाक्रागो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","जमाहेन्‍से येशू सिबाला ङामरी फेप्‍सी सिबादा थुर्जी। चुह्रङ् लसी थुर्मैछ्‌याम सिबा पुइबा म्‍हिगदे थेन तजी। जमाहेन्‍से येशूसे सिबा म्‍हिदा “कोला, रेःगो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","जमाहेन्‍से सिबा म्‍हि रेःसी ताम पाङ्‌बारी छ्‌याइजी। ओच्‍छे येशूसे थेदा थेला आमादा जिम्‍मा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","चु म्राङ्सी जम्‍मान म्‍हिगदे लोङ्सी परमेश्‍वरदा जयजयकार लबान चुह्रङ् भिजी, “य्‍हाङला गुङरी घ्रेन अगमवक्ता गिक फेप्‍खबा मुला। ओच्‍छे परमेश्‍वरसे ह्राङला म्‍हिदा दया लबा मुला।” ");
INSERT INTO taj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","जमाहेन्‍से येशूसे लबा गेला बारेरी यहूदियाला जम्‍मान ग्‍लारीदेन ङाम ङामला जम्‍मान जिल्‍लारी थेःजी। ");
INSERT INTO taj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","यूहन्‍नाला चेलागदेसे येशूसे लबा जम्‍मान गे ह्राङला गुरु यूहन्‍नादा पाङ्जी। जमाहेन्‍से यूहन्‍नासे ह्राङला चेला न्‍हीदा ङ्‌योइसी, ");
INSERT INTO taj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","“ङन्‍से फेप्‍खला भिसी आश लसी चिबा थार्बा पिन्‍बा ग्‍ले ह्राङनोन हिन्‍ना कि स्‍य्‍हान्‍दो खालैदा भ्रान्‍तोःबा हिन्‍ना?” भिसी येशू मुबा ग्‍लारी ङ्‌योइबारी पुइजी। ");
INSERT INTO taj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","जमाहेन्‍से थेनीगदे येशू मुबा ग्‍लारी निसी, “ङन्‍से फेप्‍खला भिसी आश लसी चिबा थार्बा पिन्‍बा ग्‍ले ह्राङनोन हिन्‍ना कि स्‍य्‍हान्‍दो खालैदा भ्रान्‍तोःबा हिन्‍ना?” भिसी ङ्‌योइबारी बप्‍तिस्‍मा पिन्‍बा यूहन्‍नासे ङन्‍दा ह्राङ मुबा ग्‍लारी पुइखबा हिन्‍ना भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","थे धुइरी येशूसे रोगसे स्‍याप्‍बा ल्‍हानान म्‍हिगदेदेन म्‍हङसे स्‍याप्‍बा म्‍हिगदेदा खम्‍ना लबान मुबा। ओच्‍छे मी आम्राङ्बा ल्‍हानान म्‍हिगदेला मी म्राङ्ना लजी। ");
INSERT INTO taj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","जमाहेन्‍से यूहन्‍नाला चेलागदेदा येशूसे चुह्रङ् भिसी सुङ्जी, “एनीगदेसे जुन जुन ताम म्राङ्बादेन थेःबा मुला, थेनोन ताम यूहन्‍ना मुबा ग्‍लारी निसी पाङ्‍गो। मी आम्राङ्बागदेला मी म्राङ्ना लबा मुला, कुज्‍यादेन कोरे खबा म्‍हिगदेदा खम्‍ना लबा मुला, नाब्‍यङ आथेःबागदेदा थेःना लबा मुला, सिबागदेदा सोना लबा मुला, ओच्‍छे प्राङबोगदेदा परमेश्‍वरला य्‍हुल्‍साला समाचार थेःना लबान मुला। ");
INSERT INTO taj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","जुन म्‍हिसे शङ्का आलना विश्‍वास लला थे म्‍हिसे परमेश्‍वरग्‍याम मोलम याङ्ला।” ");
INSERT INTO taj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","यूहन्‍नाला चेलागदे दोःसी निमाहेन्‍से येशूसे यूहन्‍नाला बारेरी म्‍हिला हुलदा चुह्रङ् भिसी सुङ्बारी छ्‌याइजी, “एनीगदे तोङतोङबा ग्‍लारी तिग च्‍याबारी निबा मुबा? तिग लाबासे य्‍होङ्बा मा दोङ च्‍याबारी निबा हिन्‍ना? ");
INSERT INTO taj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ओच्‍छे एनीगदे तिग च्‍याबारी थोन्‍बा मुबा? ज्‍यबा ज्‍यबा क्‍वान क्‍वान्‍बा म्‍हिदा च्‍याबारी? च्‍यागो, थेह्रङ्बा ज्‍यबा ज्‍यबा क्‍वान क्‍वान्‍बादेन मोजमजा लबा म्‍हि मी ग्‍लेखाङरी जे चिबा मुला। ");
INSERT INTO taj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","एनीगदे तिग च्‍याबारी निमुबा? तिग अगमवक्तादा च्‍याबारी निबा आहिन? हिन्‍ना, ङाइ पाङ्ला एनीगदेसे स्‍य्‍हान्‍दो अगमवक्तागदे भन्‍दा घ्रेन म्‍हि गिकदा म्राङ्बा मुला। ");
INSERT INTO taj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","थे अगमवक्ता थेनोन हिन्‍ना, थेला बारेरी परमेश्‍वरला बचनरी चुह्रङ्बा भ्रिबा मुला, ‘च्‍यागो, ङाइ ङाला समाचार भोर्बा म्‍हिदा एला ङाच्‍छा ङाच्‍छा पुइखला। थेसे एला लागिरी ग्‍याम स्‍होला’। ");
INSERT INTO taj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“थेतबासेलमा च्‍यागो, दान्‍देधोना न्‍हबा कोलागदे न्‍हङरी यूहन्‍ना भन्‍दा घ्रेन म्‍हि खालै आरे। तसैनोन परमेश्‍वरला य्‍हुल्‍सारी जुन म्‍हि जजा मुला थे म्‍हि यूहन्‍ना भन्‍दा घ्रेन म्‍हि तला।” ");
INSERT INTO taj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ओच्‍छे तिरो दुइबा म्‍हिगदेदेन स्‍य्‍हान्‍दो म्‍हिगदेसे यूहन्‍नाला ताम थेःसी, “परमेश्‍वरसे कुल्‍बा ताम ठीक हिन्‍ना” भिसी थेग्‍याम बप्‍तिस्‍मा किन्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","तर फरिसीगदेदेन यहूदी धर्मगुरुगदेसे चा परमेश्‍वरसे कुल्‍बा ताम गे आखेल्‍बा ताम हिन्‍ना भिसी यूहन्‍नाग्‍याम बप्‍तिस्‍मा आकिन्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “थेह्रङ्बा म्‍हिगदेदा ङाइ तिगदेन छ्‌याम दाँजब लसे? थेनीगदे खाह्रङ्बा मुला भिसम, ");
INSERT INTO taj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","बजाररी चिबा कोलागदे ह्रङ्‌बा मुला। थेनीगदे ह्राङ ह्राङ न्‍हङरी चुह्रङ् भिसी कल लमुला, ‘ङन्‍से एनीगदेला लागिरी बाँसुरी ह्राप्‍सी पिन्‍जी, तर एनीगदे आस्‍य्‍हनी। ओच्‍छे ङन्‍से दुखला व्‍हाइ गोजी, तर एनीगदे आक्रानी?’ ");
INSERT INTO taj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","तिगै चबा थुङ्बादेन अङगुरला निङगुएनोन आथुङ्बा बप्‍तिस्‍मा पिन्‍बा यूहन्‍ना खमा एनीगदेसे ‘थेदा म्‍हङसे स्‍याप्‍बा म्‍हि’ भिसी भिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","परमेश्‍वरसे पुइखबा म्‍हि चा चबा थुङ्बा लसी भ्रजी। थेतबासेलमा म्‍हिगदेसे ङादा ‘च्‍यागो, ल्‍हानान चबा स्‍हेदेन ल्‍हानान निङगु कासी ङ्‌य्‍होइसी भ्रबा, तिरो दुइबादेन पापीगदेला ह्रो’ भिसी भिमुला! ");
INSERT INTO taj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","तर परमेश्‍वरग्‍याम बुद्धि याङ्बागदेसे जे परमेश्‍वरला बुद्धि ठीक हिन्‍ना भिसी था याङ्बा मुला।” ");
INSERT INTO taj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","फरिसीगदे न्‍हङला गिकसे येशूदा सोल छ्‌योइबारी ङ्‌योइजी। ओच्‍छे थेला दिमरी फेप्‍सी येशू सोल छ्‌योइबारी धन्‍छ्‌याजी। ");
INSERT INTO taj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","थे शहररी मुबा पापी म्रिङम्‍हेमे गिकसे फरिसीला दिमरी येशू सोल छ्‌योइबारी फेप्‍खजी भिबा थेःसी सिङ्‍गमरमरला बोतलरी अत्तर भसी येशू मुबा ग्‍लारी खजी। ");
INSERT INTO taj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","थे येशूला ग्‍यापग्‍याम खसी येशूला ङामरी राप्‍सी क्राजी, ओच्‍छे थेला मीख्‍लीसे येशूला स्‍य्‍हाप भम्‍जी। जमाहेन्‍से थेसे ह्राङला क्रासे येशूला स्‍य्‍हाप फ्‍यासी च्‍योक लसी येशूला स्‍य्‍हापरी अत्तर फोर्बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","चुह्रङ् लबा म्राङ्सी येशूदा ङ्‌योइबा फरिसीसे “चु म्‍हि अगमवक्ता हिन्‍सम थेदा थुर्बा म्रिङम्‍हेमे खाह्रङ्बा म्रिङम्‍हेमे भिसी ङोसेसेला मुबा। तिग्‍दा भिसम चु पापीस्‍या हिन्‍ना” भिसी ह्राङला सेम न्‍हङरी म्‍हन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","थेसे सेमरी चुह्रङ्बा ताम म्‍हन्‍बा था याङ्सी येशूसे फरिसीदा “सिमोन ङाइ एदा ताम गिक पाङ्तोःबा मुला” भिसी सुङ्मा, थेसे “सुङ्‍गो गुरु” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“च्‍यागो, म्‍हि न्‍हीसे साहू गिकदेन छ्‌याम छे किन्‍बा मुबा गिकसे ग्‍यार्जा ङा ओच्‍छे स्‍य्‍हान्‍दोसे बोगल न्‍हीसे च्‍युइ टाङगा किन्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","थे न्‍हीसेन छे फाआखम्‍बासे लमा साहूसे थे न्‍हीदान माफ पिन्‍जी। थेतबासेलमा, लु, पाङ्‍गो थे न्‍ही न्‍हङरी खजिबासे चा साहूदा ल्‍हाना माया लला” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","“ल्‍हाना माफ याङ्बासे” भिसी सिमोनसे भिमा, “एसे ठीक भिजी” भिसी येशूसे थेदा सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ओच्‍छे थे म्रिङम्‍हेमेपट्टि दोःसी येशूसे सिमोनदा चुह्रङ् सुङ्जी, “चुदा च्‍यागो, ङा एला दिमरी खमा एसे ङादा काङ ख्रुबारी क्‍युइएनोन आपिन्‍नी तर चुसे मी ङाला काङ मीख्‍लीसे ख्रुसी ह्राङला क्रासे फ्‍यासी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","एसे ङादा च्‍योक लसी फ्‍याआफुल्‍नी, तर चुसे मी खमाहेन्‍सेन ङाला काङरी च्‍योक लबाला लबान मुला। ");
INSERT INTO taj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ओच्‍छे एसे ङाला थोबोरी छ्‌युगु फोर्सी आपिन्‍नी। तर चुसे मी ङाला काङरी अत्तर फोर्सी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","थेतबासेलमा एसे ङाला ताम ङ्‌यान्‍गो, चुसे ल्‍हानान पाप लसैनोन माफ याङ्सी जिन्‍बा मुला। तिग्‍दा भिसम चु म्रिङम्‍हेमेसे ल्‍हानान मान लबा मुला। तर जुन म्‍हिदा जजाकी जे माफ लला, थेसे जजाकी जे मान लला।” ");
INSERT INTO taj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ओच्‍छे येशूसे थे म्रिङम्‍हेमेदा “एला पाप माफ तबा मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","थेरी चबारी चिबा म्‍हिगदेसे चु ताम थेःसी, “पाप माफ लबा चु म्‍हि खाल हिन्‍ना?” भिसी ह्राङ ह्राङ न्‍हङरी भिबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ओच्‍छे येशूसे थे म्रिङम्‍हेमेदा “एला विश्‍वाससे लमा एसे थार्बा याङ्बा मुला, ए ढुक्‍क तसी निउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","जमाहेन्‍से येशू शहर शहरदेन नाम्‍सा नाम्‍सा तसी परमेश्‍वरला य्‍हुल्‍साला समाचार थेःना लबान फेप्‍जी। थेला च्‍युक न्‍ही चेलागदेएनोन थेदेन छ्‌यामनोन मुबा। ");
INSERT INTO taj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ओच्‍छे येशूसे म्‍हङसे स्‍याप्‍बादेन रोगग्‍याम खम्‍ना लबा कोइ कोइ म्रिङम्‍हेमेगदेएनोन येशूदेन छ्‌याम मुबा, थेनीगदे न्‍हङरी मरियम मग्‍दलिनी भिबा म्रिङम्‍हेमेला ल्‍हुइग्‍याम येशूसे गोर निस म्‍हङ ताप्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ओच्‍छे सुसन्‍नादेन हेरोद ग्‍लेला दिमरी गे लबा म्‍हिगदे न्‍हङला खुजास भिबा मुल म्‍हिला म्रिङ योअन्‍नाएनोन येशूदेन छ्‌याम मुबा। ओच्‍छे थेनीगदेदेन स्‍य्‍हान्‍दो म्रिङम्‍हेमेगदेसे ह्राङलान टाङगासे येशूदा ह्रो लमुबा। ");
INSERT INTO taj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","जमाहेन्‍से नाम्‍सा नाम्‍साग्‍याम म्‍हिला हुल खसी येशू मुबा ग्‍लारी पोप तजी। ओच्‍छे येशूसे थेनीगदेदा उखान गिक चुह्रङ् भिसी सुङ्जी, ");
INSERT INTO taj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“च्‍यागो, ब्‍लु ढ्वबा म्‍हि गिक ब्‍लु ढ्वबारी भ्रजी। थे म्‍हिसे ब्‍लु ढ्वमा कोइ ब्‍लु ग्‍यामरी परब तजी। थे ब्‍लु म्‍हिसे नाङ्जी ओच्‍छे चरागदे खसी चजी। ");
INSERT INTO taj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","कोइ ब्‍लु चा युङबाला घह्रङ मुबा सरी परब तजी, ओच्‍छे फुइमैछ्‌याम सिजी। तिग्‍दा भिसम थे स खर्बा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","कोइ ब्‍लु चा पुजु झाङरी परब तजी। ओच्‍छे थे ब्‍लु पुजुदेन छ्‌याम छ्‌यामनोन ल्‍हेसी निसैनोन पुजु दोङला हापसे लमा थे दोङरी तिगै आरोनी। ");
INSERT INTO taj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","तर कोइ ब्‍लु चा ज्‍यबा सरी परब तजी, ओच्‍छे थे दोङरी दोब्‍बर, तेब्‍बर, चौबरधोना रोजी।” चुदे सुङ्माहेन्‍से येशूसे थेरी मुबा म्‍हिगदेदा “जुन म्‍हिदा ङ्‌यान्‍बा सेम मुला, थेसे ङ्‌यान्‍सी घोउ।” ");
INSERT INTO taj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","जमाहेन्‍से चेलागदेसे येशूदा चु उखानना अर्थ तिग भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “ङाइ एनीगदेदा म्‍हिसे था आयाङ्‍बा परमेश्‍वरला य्‍हुल्‍साला ताम घोखम्‍बा ज्ञान बुद्धि पिन्‍बा मुला। तर स्‍य्‍हान्‍दोगदेदा चा उखानग्‍याम पाङ्बा मुला। थेतबासेलमा ‘थेनीगदेसे च्‍याबाम च्‍याला तर आम्राङ्, ङ्‌यान्‍बाम ङ्‌यान्‍बा मुला तर आघो।’ ");
INSERT INTO taj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“च्‍यागो, चु उखानना अर्थ चुनोन हिन्‍ना, चु ब्‍लु भिबा चा परमेश्‍वरला बचन हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ग्‍यामला कुनीरीक्‍यार परब तबा ब्‍लुला अर्थ चा जुन म्‍हिसे परमेश्‍वरला बचन ङ्‌यान्‍बाम ङ्‌यान्‍ना तर सेमरी थान्‍बारी चा आखम्‍मुला। तिग्‍दा भिसम थेनीगदेसे विश्‍वास लसी थार्बा थायाङ्‌गै भिसी शैतान खसी थेनीगदेला सेमग्‍याम परमेश्‍वरला बचन ब्‍यन्‍सी भोर्मुला। ");
INSERT INTO taj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","थेह्रङ् लसीन युङबाला घह्रङरी परब तबा ब्‍लुला अर्थ चा थेनीगदेसे परमेश्‍वरला बचन ज्‍यबा म्‍हन्‍सी विश्‍वास मी लला। तर थेनीगदेला विश्‍वासला टा आरेबासे लमा तिगै धिन लिच्‍छा थेनीगदेदा तबा दुखसे लमा थेनीगदेसे विश्‍वास लबा ख्‍लाला। ");
INSERT INTO taj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ओच्‍छे पुजु झाङ न्‍हङरी परब तबा ब्‍लुला अर्थ चा थेनीगदेसे जम्‍बुलिङरी म्राङ्बा धन सम्‍पत्तिदेन मोजमजा, ओच्‍छे थेनीगदेदा तबा धन्‍दा सुर्दासे लमा विश्‍वासरी कोङ्‌सी चिआखम्‍बासे लमा थेनीगदेला विश्‍वासग्‍याम तिगै आरो। ");
INSERT INTO taj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","तर ज्‍यबा सरी परब तबा ब्‍लुला अर्थ चा जुन म्‍हिसे परमेश्‍वरला बचन ङ्‌यान्‍सी ह्राङला ज्‍यबा सेमहेन्‍सेन विश्‍वास लला। ओच्‍छे थेला विश्‍वासग्‍याम गोल्‍से गोल्‍से ज्‍यबा रोगदे रोबान निला। ");
INSERT INTO taj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“खालैसे नाङसल म्रासी फामसे घप्‍सी आथान, ओच्‍छे खाट धिरीएनोन छुम्‍सी आथान। तर दिम न्‍हङरी खबा म्‍हिगदेदा य्‍हाल तगै भिसी नोबा ग्‍लारी थान्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ल्‍हुसैनोन आम्राङ्बा स्‍हे तिगै आरे। ओच्‍छे छुम्‍सी थान्‍सैनोन आघोबा स्‍हे तिगै आरे। ");
INSERT INTO taj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","जुन म्‍हिसे ङाइ लोप्‍बा तामदा सेम लसी ङ्‌यान्‍ना, थेदा ङाइ अझ घोना लला। तर ङाइ लोप्‍बा ताम आङ्‌यान्‍बादा चा थेसे जुन घोबा मुला थे तामएनोन म्‍हाना लला।” ");
INSERT INTO taj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","थे धुइरी येशूला आमादेन आलेगदे येशूदा स्‍याप्‍बारी येशू मुबा ग्‍लारी खजी। तर येशूला क्‍युर्सीन म्‍हिला हुल मुबासे लमा थेनीगदेसे येशूदा स्‍याप्‍बारी आखम्‍नी। ");
INSERT INTO taj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","जमाहेन्‍से थेरी मुबा खालै म्‍हिसे “ह्राङदा स्‍याप्‍बारी ह्राङला आमादेन आलेगदे मङग्‍यार भ्रान्‍सी चिबा मुला” भिमा, ");
INSERT INTO taj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","“च्‍यागो, जुन म्‍हिसे परमेश्‍वरला बचन ङ्‌यान्‍सी परमेश्‍वरसे कुल्‍बा ताम ङ्‌यान्‍ना थेनोन ङाला आमादेन आलेगदे हिन्‍ना” भिसी येशूसे थेनीगदे जम्‍मादान सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","तिरेकुनु येशू ह्राङला चेलागदेदेन छ्‌याम दोँगारी क्रेःमाहेन्‍से “लु, य्‍हाङ समुन्‍द्रला क्‍याम्‍सङपट्टि निइ” भिसी चेलागदेदा सुङ्जी। जमाहेन्‍से येशू ह्राङला चेलागदेदेन छ्‌याम क्‍याम्‍सङ फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","थेनीगदे फेप्‍बान लबा धुइरी येशू दोँगारीन छुप निजी। जमाहेन्‍से समुन्‍द्ररी घ्रेन लाबालुङसर खजी, लाबालुङसरसे लसी समुन्‍द्ररी छाल रेःजी, छालसे लमा दोँगा डुबब तबारी छ्‌याइजी, जमाहेन्‍से थेनीगदेदा आपत विपत तजी। ");
INSERT INTO taj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","जमाहेन्‍से चेलागदे येशूला ङामरी खसी येशूदा छिङ्बान, “गुरु, य्‍हाङ सिबारी छ्‌याइजी” भिसी भिजी। चेलागदेला चुह्रङ्बा ताम थेःसी येशू स्‍हेङ्‌सी लाबालुङसरदा बङ्जी। बङ्मैछ्‌याम लाबालुङसर म्‍हासी शान्‍त तजी। ");
INSERT INTO taj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","येशूसे थेनीगदेदा “खाइ, एनीगदेला विश्‍वास” भिसी सुङ्मा, थेनीगदे लोङ्सी उदेक म्‍हन्‍बान ह्राङ ह्राङ न्‍हङरी “चु खाल? लाबालुङसरसेनोन थेसे कुल्‍बा ताम ङ्‌यान्‍बा चीम” भिसी ताम लजी। ");
INSERT INTO taj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","येशू ह्राङला चेलागदेदेन छ्‌याम गालील अञ्‍चलला क्‍याम्‍सङपट्टि गेरासेनस भिबा ग्‍लारी धोखजी। ");
INSERT INTO taj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","येशू दोँगाग्‍याम फप्‍मैछ्‌याम थे शहररी मुबा म्‍हङसे स्‍याप्‍बा म्‍हि गिक येशूदा स्‍याप्‍बारी खजी। थे क्‍वान आक्‍वान्‍नान भ्रबा ल्‍हानान तसी जिन्‍बा मुबा। ओच्‍छे थे दिमरी आचिना धुर्सारीक्‍यार चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","थेसे येशूदा म्राङ्मैछ्‍याम क्रिङ्बान येशूला ङाच्‍छापट्टि ख्‍लुप तसी, “जम्‍मान भन्‍दा घ्रेन परमेश्‍वरला झा येशू ह्राङसे ङादा तिग लबा सेम मुला? ङादा दुख थापिन्‍गो” भिसी बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","तिग्‍दा भिसम येशूसे थे म्‍हङदा थे म्‍हिला ल्‍हुइग्‍याम थोन्‍सी निउ भिसी कुल्‍बा मुबा। थेदा थे म्‍हङसे ल्‍हानान रेम चुङ्बा मुबा। थे म्‍हिदा या काङरी च्‍याल्‍दासे खीसी ख्रुङ्‌सी चिसैनोन म्‍हङला शक्तिसे लमा थेसे च्‍याल्‍दा फ्राटफ्रेट टाङ्सी थे ह्रिरीक्‍यार यार्मुबा। ");
INSERT INTO taj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","येशूसे थेदा “एला मिन तिग?” भिसी ङ्‌योइमा, “ङा हुल हिन्‍ना” भिसी भिजी। तिग्‍दा भिसम थे म्‍हिला ल्‍हुइरी ल्‍हानान म्‍हङ मुबा। ");
INSERT INTO taj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ओच्‍छे म्‍हङगदेसे “ङन्‍दा ल्‍हानान नुप्‍बा व्‍हाङरी थापुइगो” भिसी येशूदेन छ्‌याम बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","थे ग्‍लाला ङामला गङरी ढ्वला बथान छबान मुबा। थेतबासेलमा थे म्‍हङगदेसे ङन्‍दा थे ढ्वागदे न्‍हङरी वाङ्पुङ्‍गो भिसी बिन्‍ती लमा थेनीगदेदा येशूसे “निउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","जमाहेन्‍से थे म्‍हङगदे थे म्‍हिला ल्‍हुइग्‍याम थोन्‍सी ढ्वागदे न्‍हङरी वाङ्माहेन्‍से थेरी मुबा जम्‍मान ढ्वागदे गङग्‍याम समुन्‍द्ररी छ्‌योङ्सी सिजी। ");
INSERT INTO taj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","चुह्रङ् तबा म्राङ्सी ढ्वा छबा म्‍हिगदे यार्जी। ओच्‍छे नाम्‍सा नाम्‍सादेन शहर शहररी निसी थेनीगदेसे म्राङ्बा जम्‍मान ताम थेःना लजी। ");
INSERT INTO taj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","थेनीगदेसे पाङ्बा ताम थेःसी ल्‍हानान म्‍हिगदे च्‍याबारी येशू मुबा ग्‍लारी खमा, थेनीगदेसे ङाच्‍छा म्‍हङसे स्‍याप्‍सी म्‍योसी भ्रबा म्‍हि खम्‍सी क्‍वान क्‍वान्‍सी येशूला ङामरी चिबा म्राङ्जी। चु म्राङ्सी थेनीगदे लोङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","थे म्‍हङसे स्‍याप्‍बा म्‍हि खाह्रङ् लसी खम्‍जी भिसी म्राङ्बा म्‍हिगदेसे थेरी च्‍याबारी खबा म्‍हिगदेदा पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","जमाहेन्‍से गेरासेनस भिबा नाम्‍साला क्‍यारमारला म्‍हिगदेसे येशूदा “ङनी मुबा ग्‍लाग्‍याम फेप्‍गो” भिसी बिन्‍ती लजी। तिग्‍दा भिसम थेनीगदे ल्‍हानान लोङ्सी उदेक तबा मुबा। थेतबासेलमा येशू थे ग्‍लाग्‍याम दोँगारी क्रेःसी फेप्‍बारी छ्‌याइमा, ");
INSERT INTO taj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","येशूसे म्‍हङ ताप्‍सी खम्‍ना लबा म्‍हिसे “ङाएनोन ह्राङदेन छ्‌याम निबा” भिसी येशूदेन छ्‌याम बिन्‍ती लमा येशूसे थेदा, ");
INSERT INTO taj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“ए ह्राङला दिमरी निउ ओच्‍छे परमेश्‍वरसे एला लागिरी खाह्रङ्बा गे लबा मुला, थे ताम जम्‍मादान थेःना लउ” भिसी सुङ्जी। जमाहेन्‍से थे म्‍हि निसी येशूसे ह्राङला लागिरी लबा गेला बारेरी शहरला जम्‍मान ग्‍लारी थेःना लबान भ्रजी। ");
INSERT INTO taj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","जमाहेन्‍से येशू दोःसी फेप्‍खमाहेन्‍से म्‍हिला हुलसे येशूदा फ्‍याफुल्‍जी। तिग्‍दा भिसम थेनीगदे येशू फेप्‍खला भिसी भ्रान्‍सी चिमुबा। ");
INSERT INTO taj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","थेनोन धुइरी याइरस भिबा यहूदीगदे ह्रुप तबा दिमला नेता येशू मुबा ग्‍लारी खसी येशूला स्‍य्‍हापरी फ्‍या लबान, “ङाला दिमरी फेप्‍खउ” भिसी बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","तिग्‍दा भिसम थेला गिक जेन मुबा च्‍युक न्‍ही दिङला झामे सिबारीन छ्‌याइबा मुबा। जमाहेन्‍से येशू फेप्‍बान लबा धुइरी म्‍हिगदेसे तोर हुइ मार हुइ लबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","थेरी का निबा बेथासे स्‍याप्‍सी च्‍युक न्‍ही दिङ तबा म्रिङम्‍हेमे गिक मुबा। थेसे ह्राङला जम्‍मान सम्‍पत्ति खर्च लसी मन लसैनोन थेदा खालैसे खम्‍ना लआखम्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","थेतबासेलमा थे येशूला ग्‍यापग्‍याम खसी येशूला क्‍वान्‍ना जोरी थुर्जी। थेसे येशूला क्‍वान थुर्मैछ्‌याम थेला का निबा बेथा म्‍हाजी। ");
INSERT INTO taj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","जमाहेन्‍से येशूसे “ङादा खाल्‍से थुर्जी” भिसी सुङ्मा, जम्‍मासेन “ङाइ थुर्बा आहिन” भिसी भिजी। तर पत्रुससे चा “गुरु, ह्राङदा म्‍हिगदेसे तोर हुइ मार हुइ लबान मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","तर येशूसे “आहिन, ङादा खालैसे थुर्बा मुला, तिग्‍दा भिसम ङाग्‍याम ङाला शक्ति थोन्‍सी निबा ङाइ था याङ्जी” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","जमाहेन्‍से थे म्रिङम्‍हेमेसे ह्राङ लासी चिबारी आतनम भिसी फितफित धर्बान येशूला ङाच्‍छापट्टि खसी फ्‍या लबान येशूदा तिग्‍दा थुर्जी ओच्‍छे थुर्मैछ्‌याम ह्राङ खाह्रङ् लसी खम्‍जी भिबा ताम जम्‍मान म्‍हिगदेला ङाच्‍छापट्टि पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ओच्‍छे येशूसे थे म्रिङम्‍हेमेदा “झामे, एला विश्‍वाससे लमा ए खम्‍बा मुला, ए ढुक्‍क तसी निउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","येशूसे ताम लबान लबा धुइरी याइरसला दिमग्‍याम म्‍हि गिक खसी याइरसदा “ह्राङला झामे सिसी जिन्‍जी। दाहेन्‍से गुरुदा दुख थापिन्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","तर येशूसे याइरसदा “थालोङ्‍गो, एसे विश्‍वास जे लउ, ओच्‍छे एला झामे सोला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","याइरसला दिमरी धोमाहेन्‍से येशूसे पत्रुस, याकूब, यूहन्‍नादेन थे माइला आबादेन आमादा बाहेक स्‍य्‍हान्‍दो खालैदान दिम न्‍हङरी खआपुङ्नी। ");
INSERT INTO taj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","याइरसला दिमरी पोप तबा म्‍हिगदे थे माइ सिजी भिसी क्राबा क्रिङ्बा लसी चिबा मुबा। येशूसे थेनीगदेदा “थाक्रागो, थे सिबा आरे, म्‍हेर्सी चिबा मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","येशूला ताम थेःसी थेनीगदेसे ङेःबान येशूदा खिसी लजी। तिग्‍दा भिसम थे माइ सिसी जिन्‍बा मुला भिसी थेनीगदेदा था मुबा। ");
INSERT INTO taj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","तर येशूसे थे माइला यारी चुङ्सी, “माइ, ए रेःगो” भिसी सुङ्मैछ्‌याम, ");
INSERT INTO taj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","थे माइला आत्‍मा दोःसी खजी ओच्‍छे थे डोङ रेःजी। जमाहेन्‍से येशूसे “चु माइदा चबा स्‍हे पिन्‍गो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","चु म्राङ्सी थे माइला आबादेन आमा उदेक तजी। तर येशूसे थेनीगदेदा “चु ताम खालैदा थापाङ्‍गो” भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","जमाहेन्‍से येशूसे ह्राङला च्‍युक न्‍ही चेलागदेदा ङ्‌योइसी थेनीगदेदा म्‍हङगदे ताप्‍बादेन रोगगदे म्‍हाना लबा शक्तिदेन अधिकार पिन्‍सी, ");
INSERT INTO taj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","परमेश्‍वरला य्‍हुल्‍साला समाचार थेःना लबारी ओच्‍छे आखम्‍बा म्‍हिगदेदा खम्‍ना लबारी पुइजी। ");
INSERT INTO taj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ओच्‍छे येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदेसे ग्‍यामला लागिरी कडी, झोला, चबा स्‍हे, टाङगा ओच्‍छे पोबा क्‍वान तिगै थाभोर्गो। ");
INSERT INTO taj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","जुन दिमला म्‍हिगदेसे एनीगदेदा मान लला, थे नाम्‍साग्‍याम थोन्‍सी आनितेधोना एनीगदे थे दिमरीन चिउ। ");
INSERT INTO taj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","तर जुन ग्‍लाला म्‍हिगदेसे एनीगदेदा मान आल, एनीगदे थे शहरग्‍याम थोन्‍बा धुइरी दाहेन्‍से ङन्‍से लतोःबा गे लसी जिन्‍जी। एनीगदेसे तिग लतोःबा लउ भिसी काङला धुलु खर्सी पिन्‍गो।” ");
INSERT INTO taj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","जमाहेन्‍से चेलागदे नाम्‍सा नाम्‍सारी निसी परमेश्‍वरला य्‍हुल्‍साला समाचार थेःना लबान आखम्‍बा म्‍हिगदेदा खम्‍ना लजी। ");
INSERT INTO taj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","चु जम्‍मान गेला बारेरी थेःसी गालील अञ्‍चलरी शासन लबा हेरोद अलमल तजी। तिग्‍दा भिसम कोइ कोइ म्‍हिसे येशूदा “बप्‍तिस्‍मा पिन्‍बा यूहन्‍ना सिबाग्‍याम सोसी खजीम” भिसी भिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","कोइ कोइसे चा “एलिया दोःसी खजीम” भिसी भिबा मुबा। ओच्‍छे स्‍य्‍हान्‍दो कोइ कोइसे चा “ओन्‍माला अगमवक्तागदे न्‍हङरी गिक सिबाग्‍याम सोसी खजीम” भिसी भिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","थेतबासेलमा हेरोद ग्‍लेसे “चुह्रङ्बा उदेकला गे लबा म्‍हि खाल हिन्‍ना? तिग्‍दा भिसम यूहन्‍नाला थोबो मी ङाइनोन आपुङ्‍बा हिन्‍ना” भिसी भिजी। ओच्‍छे थेसे तिरेम येशूदा स्‍याप्‍बा सेम लजी। ");
INSERT INTO taj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","येशूसे परमेश्‍वरला य्‍हुल्‍साला समाचार थेःना लबारी पुइबा मुल चेलागदे दोःसी खसी थेनीगदेसे लबा जम्‍मान गे येशूदा पाङ्जी। जमाहेन्‍से येशूसे थेनीगदेदा जे भोर्सी बेथसेदा भिबा शहररी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","तर चु ताम था याङ्सी म्‍हिला हुल येशू मुबा ग्‍लारी निजी। जमाहेन्‍से येशूसे थेनीगदेदा खपुङ्जी। ओच्‍छे म्‍हिगदेदा परमेश्‍वरला य्‍हुल्‍साला समाचार थेःना लबान आखम्‍बा म्‍हिगदेदा खम्‍ना लजी। ");
INSERT INTO taj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","धिनी घल्‍बारी छ्‌याइमाहेन्‍से च्‍युक न्‍ही चेलागदे येशू मुबा ग्‍लारी खसी येशूदा “म्‍हिगदेदा चुग्‍याम निपुङ्‍गो। तिग्‍दा भिसम चु ग्‍लारी तिगै आरे। थेतबासेलमा थेनीगदे क्‍यारमारला नाम्‍सारी निसी चबा थुङ्बादेन चिबा ग्‍ला ढिक्‍ना लगै” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","तर येशूसे थेनीगदेदा “एनीगदेसेन चुगदेदा चबा स्‍हे पिन्‍गो” भिसी सुङ्मा, थेनीगदेसे “ङन्‍देन छ्‌याम गोर ङा गेङदेन तार्ङा न्‍ही जे मुला। आतसम ङनी निसी चु जम्‍मान म्‍हिगदेला लागिरी चबा स्‍हे ग्‍लुसी भतोःला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","थेरी हजार ङा ते चा ह्रेम्‍फेबे जे मुबा। ओच्‍छे येशूसे ह्राङला चेलागदेदा “म्‍हिगदेदा बोगल न्‍हीसे च्‍युइला लाम लसी चिपुङ्‍गो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ओच्‍छे चेलागदेसे येशूसे सुङ्बा ह्रङ्नोन लसी चिपुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","जमाहेन्‍से येशूसे गोर ङा गेङदेन तार्ङा न्‍ही छ्‌यारी थोसी स्‍वर्गपट्टि स्‍हीसी परमेश्‍वरदा धन्‍यवाद पिन्‍जी। ओच्‍छे येशूसे गेङदेन तार्ङा क्‍युइसी म्‍हिगदेदा भो लसी पिन्‍गो भिसी चेलागदेदा कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","जमाहेन्‍से जम्‍मान म्‍हिगदेसे म्रेन्‍ना चसीनोन लेङ्बा भ्राइभ्रुइ चेलागदेसे दुइमा च्‍युक न्‍ही सोली तजी। ");
INSERT INTO taj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","तिरेकुनु येशू गिक जेन प्रार्थना लसी धन्‍छ्‌याबा मुबा। थे धुइरी थेला चेलागदेएनोन छ्‌यामनोन मुबा। ओच्‍छे येशूसे थेनीगदेदा “म्‍हिगदेसे ङादा खाल भिबा चीम?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","थेनीगदेसे “ह्राङदा खालैसे बप्‍तिस्‍मा पिन्‍बा यूहन्‍ना भिबा मुला, खालैसे एलिया, ओच्‍छे स्‍य्‍हान्‍दोगदेसे चा ओन्‍माला अगमवक्तागदे न्‍हङला गिक सिबाग्‍याम सोसी खजीम भिबा मुला” भिसी जोहाब पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","जमाहेन्‍से येशूसे दोःसी चेलागदेदा “तर एनीगदेसे चा ङा खाल भिसी म्‍हन्‍मुला?” भिसी ङ्‌योइमा, पत्रुससे “ह्राङ परमेश्‍वरसे पुइखबा थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍ना” भिसी जोहाब पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","जमाहेन्‍से येशूसे, “च्‍यागो, एनीगदेसे चु ताम खालैदा थापाङ्‍गो” भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ओच्‍छे येशूसे थेनीगदेदा “परमेश्‍वरसे पुइखबा म्‍हिसे ल्‍हानान दुख नातोःला। ओच्‍छे यहूदी गन्‍बागदे, परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी धर्मगुरुगदेसे बिरोध लसी साइला। तसैनोन थेदा सिबाग्‍याम सोमरेमाकुनु सोना लला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","जमाहेन्‍से येशूसे थेरी मुबा जम्‍मान म्‍हिगदेदा चुह्रङ् भिसी सुङ्जी, “खालै म्‍हि ङाला चेला दोबा सेम मुसम थेसे ह्राङला ज्‍याननोन माया मारब लसी ह्राङला क्रुस ह्राङसेन धिन धिननोन पुइसी ङादेन छ्‌याम भ्रगै। ");
INSERT INTO taj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","तिग्‍दा भिसम जुन म्‍हिसे ह्राङला ज्‍यान जोगब लबारी म्‍हाइला, थे म्‍हिसे चा जुकजुकधोनाला जुनी आयाङ्। तर ङाला लागिरी ह्राङला ज्‍याननोन पिन्‍खम्‍बा म्‍हिसे चा जुकजुकधोनाला जुनी याङ्ला। ");
INSERT INTO taj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","चुदे खालै म्‍हिसे जम्‍बुलिङनोन यारी किन्‍सी थेला ज्‍याननोन निजी भिसम तिग ज्‍यबा तला? ");
INSERT INTO taj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ओच्‍छे खालै म्‍हि ङादेन ङाला तामरी पेःजी भिसम परमेश्‍वरला स्‍वर्गदूतगदेदेन छ्‌याम परमेश्‍वरसे पुइखबा म्‍हि ङाला आबा परमेश्‍वरला य्‍हालदेन शक्तिरी खमा थेदा ह्राङला भिबारी पेःला। ");
INSERT INTO taj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","तर एनीगदेसे ङाला ताम ङ्‌यान्‍गो, चुरी मुबा म्‍हिगदे न्‍हङला कोइ कोइ म्‍हि चा परमेश्‍वरला य्‍हुल्‍सा आम्राङ्तेधोना आसि।” ");
INSERT INTO taj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","येशूसे चु ताम सुङ्सी भ्रेःरे तमा पत्रुस, यूहन्‍नादेन याकूबदा प्रार्थना लबारी गङरी भोर्सी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","थेरी येशू प्रार्थना लबान लबा धुइरी येशूला स्‍य्‍हाल पोजी। ओच्‍छे येशूला क्‍वान धिनीला स्‍हेर ह्रङ्‌बान य्‍हाल य्‍हाल तजी ");
INSERT INTO taj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ओच्‍छे म्‍हि न्‍ही येशूदेन छ्‌याम ताम लबा म्राङ्जी। थे म्‍हि न्‍ही मोशादेन एलिया मुबा। ");
INSERT INTO taj_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","थेनीगदेला स्‍य्‍हाल य्‍हाल य्‍हाल तबा मुबा। ओच्‍छे येशू यरूशलेमरी सितोःला भिबा तामला बारेरी येशूदेन छ्‌याम ताम लबान मुबा। ");
INSERT INTO taj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","थे धुइरी चा पत्रुस ओच्‍छे थेदेन छ्‌याम मुबागदे म्‍हेर्बा मुबा। थेनीगदे फातछोर्मा येशू स्‍वर्गला य्‍हालरी ओच्‍छे स्‍य्‍हान्‍दो म्‍हि न्‍हीएनोन येशूदेन छ्‌याम राप्‍सी चिबा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ओच्‍छे थे म्‍हि न्‍ही येशू मुबाग्‍याम दोःसी निबारी छ्‌याइमा पत्रुससे “गुरु, य्‍हाङ चुरी मुबा ज्‍यबा तजीम। दाहेन्‍से ङन्‍से चुरी छाप्रो सोम स्‍होइ, गिक ह्राङला लागिरी, गिक मोशाला लागिरी ओच्‍छे गिक एलियाला लागिरी” भिसी भिजी। तर पत्रुसदा तिग ताम पाङ्तोःबा थे था आरेमुबा। ");
INSERT INTO taj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","पत्रुससे चुह्रङ् पाङ्ना पाङ्नान खसु खसी थेनीगदेदा घप्‍जी। चु म्राङ्सी चेलागदे लोङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ओच्‍छे खसु न्‍हङ‍ग्‍याम चुह्रङ्बा काइ थेःजी, “चु ङाइ धम्‍बा ङाला झा हिन्‍ना, चुसे भिबा ताम एनीगदेसे ङ्‌यान्‍गो।” ");
INSERT INTO taj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","चु काइ थेःसी जिन्‍माहेन्‍से चेलागदेसे थेरी येशूदा जे म्राङ्जी। जमाहेन्‍से थेनीगदे कुटिसी चिजी। ओच्‍छे थेनीगदेसे म्राङ्बा चु ताम थे धुइरी खालैदा आपाङ्नी। ");
INSERT INTO taj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","न्‍हङगरदङ येशू ह्राङला चेलागदेदेन छ्‌याम गङग्‍याम मार फेप्‍खबा धुइरी म्‍हिला हुल गिक येशूदा स्‍याप्‍बारी खजी। ");
INSERT INTO taj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ओच्‍छे थे म्‍हिला हुल न्‍हङ‍ग्‍याम म्‍हि गिकसे क्रिङ्बान भिजी, “गुरु, ङाला झादा च्‍यासी पिन्‍गो, तिग्‍दा भिसम चु ङाला गिक जेन झा हिन्‍ना! ");
INSERT INTO taj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","थेदा म्‍हङसे घरिघरि चुङ्‍मुला, ओच्‍छे थे क्रिङ्सी सिबा तेबान तमुला। जमाहेन्‍से थेला सुङग्‍याम बोप्‍स्‍या तेःबा मुला, ओच्‍छे थे म्‍हङसे लछार पछार आलतेधोना थेदा आख्‍लामुला। ");
INSERT INTO taj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ङाइ थे म्‍हङ ताप्‍सी पिन्‍गो भिसी ह्राङला चेलागदेदा भिजी, तर थेनीगदेसे म्‍हङ ताप्‍आखम्‍नी।” ");
INSERT INTO taj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","जमाहेन्‍से येशूसे थेनीगदेदा “विश्‍वास आलबादेन नइबा सेम थोबा म्‍हिगदे, खाइमाधोना ङा एनीगदेदेन छ्‌याम तला? खाइमाधोना ङाइ एनीगदेदा नासे?” भिसी सुङ्जी। ओच्‍छे येशूसे थे म्‍हिदा “एला झादा चुरी भउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ओच्‍छे थेसे ह्राङला झादा भना भनान थेला झादा थे म्‍हङसे चुङ्सी भ्‍याङ्‍जी। तर येशूसे थे म्‍हङदा बङ्‌सी थे कोलादा खम्‍ना लसी थेला आबादा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","परमेश्‍वरला शक्ति म्राङ्सी थेरी मुबा म्‍हिगदे उदेक तजी। ओच्‍छे थेरी मुबा म्‍हिगदे येशूला गे म्राङ्सी उदेक तसी चिबा धुइरी येशूसे ह्राङला चेलागदेदा, ");
INSERT INTO taj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“च्‍यागो, परमेश्‍वरसे पुइखबा म्‍हिदा चुङ्सी म्‍हिगदेला यारी जिम्‍मा पिन्‍ना। एनीगदेसे चु ताम खाइमै थाम्‍लेःगो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","तर चेलागदेसे चु ताम आघोनी। तिग्‍दा भिसम थेनीगदेसे चु ताम घोखम्‍बा ज्ञान आयाङ्बासे लमा येशूसे तिग सुङ्जी भिसी म्‍हन्‍बारीनोन आखम्‍नी। ओच्‍छे थेनीगदे लोङ्बासे लमा चु तामला अर्थ तिग भिसी येशूदा ङ्‌योइबारी आखम्‍नी। ");
INSERT INTO taj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","थे धुइरी चेलागदे ह्राङ ह्राङ न्‍हङरी खाल घ्रेन भिसी ताम लबान मुबा। ");
INSERT INTO taj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","येशूसे थेनीगदेला सेमला ताम था याङ्सी कोला गिकदा ह्राङला ङामरी भसी थेनीगदेदा चुह्रङ् भिसी सुङ्जी, ");
INSERT INTO taj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“च्‍यागो, जुन म्‍हिसे चुह्रङ्बा कोलादा ङाला मिनरी वास्‍ता लला, थेसे ङादाएनोन वास्‍ता लला, ङादा वास्‍ता लबासे ङादा पुइखबा ङाला आबादाएनोन वास्‍ता लला। ओच्‍छे एनीगदे न्‍हङरी जुन म्‍हि जम्‍मान भन्‍दा जजा मुला, थेनोन घ्रेन तला।” ");
INSERT INTO taj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","जमाहेन्‍से यूहन्‍नासे, “गुरु, ङन्‍से ह्राङला मिनरी म्‍हि गिकसे म्‍हङ ताप्‍बा म्राङ्जी। तर ङन्‍से थेदा थेह्रङ् लआपुङ्नी, तिग्‍दा भिसम थे ङनी ह्रङ् ह्राङदेन छ्‌याम आभ्रमुला।” ");
INSERT INTO taj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","तर येशूसे थेनीगदेदा “एनीगदेसे थेह्रङ् थालउ, तिग्‍दा भिसम जुन म्‍हिसे एनीगदेला बिरोध आल थे म्‍हि एनीगदेपट्टिला हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","जमाहेन्‍से येशूसे ह्राङ स्‍वर्गरी फेप्‍बा धुइ तबासे लमा यरूशलेमरी निनोन तोःला भिसी पक्‍का लजी। ");
INSERT INTO taj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ओच्‍छे येशूसे कोइ कोइ समाचार भोर्बा म्‍हिगदेदा ङाच्‍छान जम्‍मान ताम तयार लबाला लागिरी सामरियाला नाम्‍सा गिकरी पुइजी। ");
INSERT INTO taj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","येशू यरूशलेमरी फेप्‍बारी छ्‌याइबा ताम था याङ्सी सामरिया नाम्‍साला म्‍हिगदेसे येशूदा चिआपुङ्नी। ");
INSERT INTO taj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","चु म्राङ्सी येशूला चेला याकूबदेन यूहन्‍नासे, “प्रभु, ङन्‍से स्‍वर्गग्‍याम मे ताइना लसी थेनीगदेदा नाश लगै भिसी भिउ भिबा ह्राङला सेम मुला?” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","येशू चेलागदेपट्टि दोःसी थेनीगदेदा बङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","जमाहेन्‍से येशू ह्राङला चेलागदेदा भोर्सी अर्गु नाम्‍सापट्टि फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ओच्‍छे येशू ह्राङला चेलागदेदेन छ्‌याम यरूशलेमपट्टि फेप्‍बान लबा धुइरी म्‍हि गिक खसी येशूदा “ह्राङ खानङदमान फेप्‍सै ङाएनोन ह्राङदेन छ्‌याम निला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","जमाहेन्‍से येशूसे थेदा “च्‍यागो, ल्‍हुन्‍दीगदे चिबारी ऊ मुला, ओच्‍छे चरागदे चिबारीनोन जङ मुला, तर परमेश्‍वरसे पुइखबा म्‍हिदा ब्‍लप्‍बा न्‍हबारीनोन ग्‍ला आरे” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ओच्‍छे स्‍य्‍हान्‍दो म्‍हि गिकदा येशूसे “ङादेन छ्‌याम भ्रउ” भिसी सुङ्जी। तर थेसे “प्रभु, ङाच्‍छा ङाला सिबा आबादा ल्‍हुसी ह्राङदेन छ्‌याम भ्रला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","येशूसे थेदा “सिबागदेदा सिबागदे ह्रङ्बासेन ल्‍हुगै तर ए चा निसी परमेश्‍वरला य्‍हुल्‍साला समाचार थेःना लउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","दोःसी स्‍य्‍हान्‍दो म्‍हि गिक येशू मुबा ग्‍लारी खसी, “ङाएनोन ह्राङदेन छ्‌याम भ्रला, तर ङाच्‍छा ङा दिमरी निसी जम्‍मादान ङा येशूदेन छ्‌याम निजी भिसी पाङ्सी खला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","थेदा येशूसे, “मोइबा धुइरी ग्‍याप दोःसी च्‍याबा म्‍हि चा परमेश्‍वरला य्‍हुल्‍सारी गे आखेल” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","जमाहेन्‍से येशूसे स्‍य्‍हान्‍दो बोगल सोमसे च्‍युइ चेलागदेदा धम्‍जी। ओच्‍छे ह्राङ फेप्‍बारी छ्‌याइबा नाम्‍सादेन शहररी ह्राङ फेप्‍बा भन्‍दा ङाच्‍छा थेनीगदेदा गोर न्‍ही न्‍ही लसी पुइजी। ");
INSERT INTO taj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","पुइबा धुइरी येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “च्‍यागो, बाली मी ल्‍हानान मिन्‍बा मुला, तर बाली दुइबा म्‍हिगदे ल्‍हाना आरे। थेतबासेलमा बाली दुइबा म्‍हिगदे पुइखउ भिसी बालीला दोप्‍ता प्रभुदेन छ्‌याम प्रार्थना लउ। ");
INSERT INTO taj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","दाहेन्‍से एनीगदे निउ। ङाइ एनीगदेदा फार्बागदेला गुङरी ग्‍युला कोलादा पुइबा ह्रङ् लसी पुइला। ");
INSERT INTO taj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ओच्‍छे एनीगदेसे टाङगा, झोला, लखम तिगै थापुइगो। ओच्‍छे ग्‍यामरी खालैदेन छ्‌याम ल्‍हाना ताम थालउ। ");
INSERT INTO taj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“ओच्‍छे एनीगदे जुन दिमरी वाङ्ला ङाच्‍छा ‘थे दिमला म्‍हिदा शान्‍ति तगै’ भिसी मोलम पिन्‍गो। ");
INSERT INTO taj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","थे दिमरी एनीगदेदेन छ्‌याम ढिक्‍बा म्‍हि मुसम थेनीगदेसे शान्‍ति याङ्ला। तर एनीगदेदेन छ्‌याम ढिक्‍बा म्‍हि आरेसम एनीगदेसे पिन्‍बा मोलम एनीगदेदान दोःसी खला। ");
INSERT INTO taj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ओच्‍छे थेनीगदेसे एनीगदेदा जस्‍तो चबा स्‍हे पिन्‍सै चबा थुङ्बा लसी थेनोन दिमरी चिउ। तिग्‍दा भिसम गे लबा म्‍हिसे ज्‍याला याङ्तोःमुला। ओच्‍छे एनीगदे दिम दिमरी वाङ्सी ज्‍यबा ज्‍यबा चबा स्‍हे म्‍हाइसी थाभ्रउ। ");
INSERT INTO taj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“थेह्रङ् लसी एनीगदे शहरगदेरी निबा धुइरी थे शहरला म्‍हिगदेसे मान लसी चबा थुङ्बारी पिन्‍बा स्‍हे चउ। ");
INSERT INTO taj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ओच्‍छे थेरी आखम्‍बा म्‍हिगदेदा खम्‍ना लउ, ‘ओच्‍छे परमेश्‍वरला य्‍हुल्‍सा खसी जिन्‍बा मुला’ भिसी थेनीगदेदा पाङ्‍गो। ");
INSERT INTO taj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","तर खजिबै शहररी एनीगदे निमा थे शहरला म्‍हिगदेसे एनीगदेदा मान आलनी भिसम थे शहरला ग्‍यामरी थोन्‍सी, ");
INSERT INTO taj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘ङन्‍से ङन्‍ना काङरी भेर्बा एनीगदेला नाम्‍साला धुलु सुत्तै एनीगदेलान नाम्‍सारी खर्बा मुला। तिग्‍दा भिसम ङन्‍से पाङ्बा ताम एनीगदेसे आङ्‌यान्‍नी। तर च्‍यागो, परमेश्‍वरला य्‍हुल्‍सा खसी जिन्‍बा मुला भिबा एनीगदेसे था याङ्‍गो’ भिसी थेनीगदेदा पाङ्‍गो। ");
INSERT INTO taj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","एनीगदेसे ङाला ताम ङ्‌यान्‍गो, परमेश्‍वरसे निसाफ लबा धिनकुनु थे शहरला म्‍हिगदेला गति भन्‍दा मी सदोम शहरला म्‍हिगदेला गति नाखम्‍बा तला। ");
INSERT INTO taj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“खोराजीनदेन बेथसेदाला म्‍हिगदे, एनीगदेसे परमेश्‍वरग्‍याम सजाय याङ्ला। तिग्‍दा भिसम एनीगदेला नाम्‍सारी लबा ह्रङ्‌बा उदेकला गेगदे टुरोसदेन सीदोन शहररी लबा हिन्‍सम ओन्‍मान थेनीगदेसे बोरा क्‍वान्‍सी मेफ्रा फोर्सी ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःसेला मुबा ");
INSERT INTO taj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","तर परमेश्‍वरसे निसाफ लबा धुइरी एनीगदेला गति भन्‍दा टुरोसदेन सीदोनला म्‍हिगदेला गति नाखम्‍बा तला। ");
INSERT INTO taj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","कफर्नहुमला म्‍हिगदे, तिग एनीगदे स्‍वर्गरीन धोला भिसी म्‍हन्‍मुला? आधो! एनीगदेदा मी नर्गरी भ्‍याङ्‍ला।” ");
INSERT INTO taj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","येशूसे ह्राङला चेलागदेदा “एनीगदेला ताम ङ्‌यान्‍बासे ङाला तामदाएनोन ङ्‌यान्‍ना, एनीगदेला ताम आङ्‌यान्‍बासे ङाला तामएनोन आङ्‌यान। ओच्‍छे ङाला ताम आङ्‌यान्‍बासे ङादा पुइखबाला तामएनोन आङ्‌यान” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","येशूसे पुइबा बोगल सोमसे च्‍युइ न्‍ही चेलागदे ताङ्बान येशू मुबा ग्‍लारी खसी, “प्रभु ङन्‍से ह्राङला मिनरी म्‍हङगदेदा कुल्‍मा थेनीगदेसे ङ्‌यान्‍जी” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ओच्‍छे येशूसे थेनीगदेदा “ङाइ शैतानदा स्‍वर्गग्‍याम तिप्‍लीङ ह्रङ् लसी ताइबा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ओच्‍छे ङाइ एनीगदेदा पुख्रीदेन बिच्‍छीदा नाङ्सी भ्रबादेन एनीगदेदा ह्राङला शत्रुगदेला जम्‍मान शक्तिदा ढाबा अधिकार पिन्‍बा मुला। थेतबासेलमा एनीगदेदा तिगै स्‍हेसेएनोन न्‍होङ्ना लआखम। ");
INSERT INTO taj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","तसैनोन म्‍हङगदेदा ह्राङला धिरी थान्‍म्‍याङ्जी भिसी एनीगदे थाताङ्‍गो। तर ह्राङला मिन स्‍वर्गरी भ्रिबा मुला भिसी एनीगदे ताङ्‍गो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","थेनोन धुइरी येशूथोरी परमेश्‍वरला आत्‍मा फेप्‍खजी। ओच्‍छे येशू ताङ्सी, “मुदेन जम्‍बुलिङला प्रभु आबा, ह्राङदा धन्‍यवाद मुला, तिग्‍दा भिसम ह्राङसे ज्ञान बुद्धि मुबा म्‍हिगदेदेन सेबा घोबा म्‍हिगदेग्‍याम छुम्‍सी थान्‍बा ताम तिगै आसेबा म्‍हिगदेदा उन्‍सी पिन्‍जी। हिन्‍ना आबा, चुह्रङ् लमान ह्राङ ताङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“ङाला आबासे ङादा जम्‍मान स्‍हे जिम्‍मा पिन्‍बा मुला। ओच्‍छे ङा खाल भिसी ङाला आबादा बाहेक स्‍य्‍हान्‍दो खालैदा था आरे। थेह्रङ् लसीन आबा खाल भिसी झादेन झासे आबादा ङोसेना लबा म्‍हिगदेसे बाहेक स्‍य्‍हान्‍दो खालैदान आबा खाल हिन्‍ना भिसी था आरे।” ");
INSERT INTO taj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","जमाहेन्‍से येशू ह्राङला चेलागदेपट्टि दोःसी थेनीगदेदा जे चुह्रङ् भिसी सुङ्जी, “एनीगदेसे म्राङ्बा मुला, चु ताम म्राङ्बागदे चा परमेश्‍वरग्‍याम मोलम याङ्बा म्‍हिगदे हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","तिग्‍दा भिसम ल्‍हानान अगमवक्तागदेदेन ग्‍लेगदेसे एनीगदेसे म्राङ्बा चु तामगदे च्‍याबारी म्‍हाइमुबा। तर थेनीगदेसे आम्राङ्‌नी, ओच्‍छे एनीगदेसे थेःबा ताम थेनीगदेसे थेःबारी म्‍हाइजी, तर थेःबारी आम्‍याङ्नी।” ");
INSERT INTO taj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","तिरेकुनु यहूदी धर्मगुरु गिक येशू मुबा ग्‍लारी खसी येशूला सेम च्‍याबारी थेसे “गुरु जुकजुकधोना आसिबा जुनी याङ्बारी ङाइ तिग लतोःला?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","येशूसे थेदा “परमेश्‍वरसे मोशादा पिन्‍बा ठिमरी तिग भ्रिबा मुला? एसे पढब लबा आरे?” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","जमाहेन्‍से थेसे येशूदा “ह्राङला सेमहेन्‍सेन, ह्राङला प्राणसे, ह्राङला बुद्धिसे ओच्‍छे ह्राङला शक्तिसे एसे परमप्रभु ह्राङला परमेश्‍वरदा माया लउ। ओच्‍छे एसे ह्राङला खिम्‍जेमदा ह्राङदा ह्रङ्नोन माया लउ” भिसी भ्रिबा मुला। ");
INSERT INTO taj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","भिसी भिमा, येशूसे थेदा “एसे ठीक भिजी दाहेन्‍से एसे थेह्रङ्नोन लउ। जमाहेन्‍से ए जुकजुकधोना सोला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","तर थे म्‍हिसे ह्राङसे ह्राङदान ङा ठीक मुला भिसी उन्‍बाला लागिरी “थेह्रङ् भिसम ङाला खिम्‍जेम खाल हिन्‍ना?” भिसी येशूदा ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","जमाहेन्‍से येशूसे थेदा चुह्रङ् भिसी सुङ्जी, “च्‍यागो, म्‍हि गिक यरूशलेमग्‍याम यरीहो भिबा ग्‍लापट्टि निबान लमा थेदा य्‍होगदेसे स्‍याप्‍सी लिगन्‍डीन लसी सिबाधोनान तोजी। ");
INSERT INTO taj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ओच्‍छे छिन्‍नङ लिच्‍छा परमेश्‍वरला मन्‍दिररी पूजा लबा म्‍हि थेग्‍यामसेन खजी। तर थेसे थे य्‍होगदेसे तोसी सिबा तेबान तबा म्‍हिदा म्राङ्सीनोन आम्राङ्बा स्‍होसी निजी। ");
INSERT INTO taj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","थेह्रङ् लसीन स्‍य्‍हान्‍दो लेवी गिकएनोन थेग्‍यामसेन खजी थेसेनोन थे सिबा तेबान तबा म्‍हिदा म्राङ्सीनोन आम्राङ्बा स्‍होसी निजी। ");
INSERT INTO taj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","तर स्‍य्‍हान्‍दो सामरी य्‍हुलला म्‍हि गिकएनोन थेग्‍यामसेन खजी। थे सिबा तेबान तबा म्‍हिदा म्राङ्सी थेदा ल्‍हानान दया रेःजी। ");
INSERT INTO taj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","जमाहेन्‍से थे सिबा तेबान तबा म्‍हि मुबा ग्‍लारी निसी थेसे थे म्‍हिला पोरगदेरी छ्‌युगुदेन अङगुरला निङगु फोर्सी क्‍वानगेनसे खीजी। ओच्‍छे थेसे थे म्‍हिदा ह्राङलान गधाथोरी थान्‍सी म्‍हिगदे बास चिबा पाटी गिकरी भोर्सी म्‍हुन गिक ह्राङसेन थे म्‍हिला सयार लजी। ");
INSERT INTO taj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","न्‍हङगरदङ निबा धुइरी थेसे थे पाटीला धनीदा म्‍हुइला डबल न्‍ही पिन्‍सी थेसे ‘ज्‍यना लसी चुला सयार लउ, अझ खर्च ल्‍हानान निसम ङा दोःसी खमा ह्राङदा पिन्‍ना’ भिसी भिजी।” ");
INSERT INTO taj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","येशूसे थेदा “एला बिचाररी चु म्‍हि सोम न्‍हङरी खजिबा चा थे य्‍होसे स्‍याप्‍बा म्‍हिला खिम्‍जेम तजी?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","थेसे येशूदा “थे य्‍होगदेसे तोबा म्‍हिदा दया लबा म्‍हि” भिसी भिजी। ओच्‍छे येशूसे थेदा “दाहेन्‍से निसी एसेनोन थेह्रङ्नोन लउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ओच्‍छे येशू ह्राङला चेलागदेदेन छ्‌याम फेप्‍बान लमा नाम्‍सा गिकरी धोजी, थे नाम्‍सारी मुबा मार्था भिबा म्रिङम्‍हेमेसे येशूदा ह्राङला दिमरी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","थे म्रिङम्‍हेमेला मरियम भिबा आङा गिक मुबा, थे चा येशूला ङामरी चिसी येशूला ताम ङ्‌यान्‍मुबा। ");
INSERT INTO taj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","मार्था चा येशूदा क्‍योङ्बाला लागिरी चबा स्‍हे स्‍होबा गेरी कोल्‍सी चिबा मुबा। ओच्‍छे थे येशूला ङामरी खसी, “प्रभु, चबा स्‍हे स्‍होबारी आङासे ङादा ह्रो आलबा ह्राङसे म्राङ्बा आरे? ह्राङसे ङादा ह्रो लबारी निउ भिसी थेदा सुङ्सी पिन्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","तर येशूसे थेदा “मार्था, ए ल्‍हानान तामरी धन्‍दा सुर्दा जे लमुला। ");
INSERT INTO taj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","तर तोःबा स्‍हे गिक जेन मुला, थेनोन स्‍हे मरियमसे धम्‍बा मुला। थेतबासेलमा थेग्‍याम चु आब्‍यन” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","तिरेकुनु येशूसे ग्‍ला गिकरी प्रार्थना लबान मुबा। येशूसे प्रार्थना लसी जिन्‍माहेन्‍से थेला चेला गिकसे “प्रभु, यूहन्‍नासे ह्राङला चेलागदेदा प्रार्थना लबारी लोप्‍सी पिन्‍बा ह्रङ् लसी ङन्‍दाएनोन प्रार्थना लबारी लोप्‍सी पिन्‍गो” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","येशूसे थेनीगदेदा “एनीगदेसे चुह्रङ् लसी प्रार्थना लउ” भिसी सुङ्जी, “परमेश्‍वर आबा, ह्राङदा जम्‍मासेन मान लगै, ओच्‍छे जम्‍मानथोरी ह्राङला शासन खगै। ");
INSERT INTO taj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ङन्‍से धिन धिननोन चतोःबा स्‍हे ङन्‍दा धिन धिननोन पिन्‍गो। ");
INSERT INTO taj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ङन्‍ना पाप माफ लसी पिन्‍गो। तिग्‍दा भिसम ङन्‍सेनोन ङन्‍दा बिरोध लसी पाप लबागदेदा माफ लबा मुला। ओच्‍छे ङन्‍दा पापरी फसब तबा ग्‍यामरी भ्रआपुङ्‍गो।” ");
INSERT INTO taj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","जमाहेन्‍से येशूसे ह्राङला चेलागदेदा दोःसी चुह्रङ् भिसी सुङ्जी, “एनीगदे न्‍हङरी खालैला ह्रो गिक मुला भिसी म्‍हन्‍गो। थे म्‍हुन गुङरी थे ह्रो मुबा ग्‍लारी निसी ‘ङादा गोर सोम गेङ भउले ज्‍योज्‍यो, ");
INSERT INTO taj_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ङाला दिमरी थारेङग्‍याम डोन्‍बो गिक खबा मुला। दान्‍दे ङादेन छ्‌याम चबा स्‍हे तिगै आरे’ भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","थेला ह्रोसे दिम न्‍हङ‌ग्‍यामसेन ‘ङा म्राप ढुङ्सी कोलागदेदेन छ्‌याम म्‍हेर्सी जिन्‍जी। थेतबासेलमा ङादा दुख थापिन्‍गो। दान्‍दे ङा रेःसी एदा तिगै पिन्‍आखम’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","तर ङाइ एनीगदेदा पाङ्ला, थे ह्रोसे थेदा ह्रो म्‍हन्‍सी तिगै आपिन्‍सैनोन थेसे ह्रीबाला ह्रीबान लमाहेन्‍से थे रेःसी थेदा तोःतेधोना पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“थेतबासेलमा एनीगदेसे ङाला ताम ङ्‌यान्‍गो, ह्रीसम पिन्‍ना, म्‍हाइसम स्‍याप्‍ला ओच्‍छे म्रापरी ढ्वक ढ्वक लसम एनीगदेला लागिरी म्राप ठोङ्सी पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","तिग्‍दा भिसम जुन म्‍हिसे ह्रीला थेदा पिन्‍ना, ओच्‍छे जुन म्‍हिसे म्‍हाइला थेसे स्‍याप्‍ला ओच्‍छे जुन म्‍हिसे म्रापरी ढ्वाक ढ्वाक लला थेदा म्राप ठोङ्सी पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“ओच्‍छे एनीगदे न्‍हङरी खाल्‍ला आबासे चा ह्राङला कोलासे गेङ ह्रीमा युङबा, तार्ङा ह्रीमा पुख्री, ");
INSERT INTO taj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ओच्‍छे नागाफुम ह्रीमा बिच्‍छी पिन्‍ना? आपिन। ");
INSERT INTO taj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","एनीगदे पापी तसीनोन ह्राङला कोलागदेदा ज्‍यबा स्‍हे पिन्‍बारी सेमुला भिसम एनीगदेला स्‍वर्गरी मुबा परमेश्‍वर आबासे थेदेन छ्‌याम ह्रीबागदेदा गाते ल्‍हाना लसी ह्राङला आत्‍मा पिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","येशूसे म्‍हङसे स्‍याप्‍सी ताइ दोबा म्‍हिला ल्‍हुइग्‍याम थे ताइ दोना लबा म्‍हङ ताप्‍जी। जमाहेन्‍से थे म्‍हिसे ताम पाङ्‌बारी छ्‌याइबा म्राङ्सी थेरी मुबा म्‍हिगदे उदेक तजी। ");
INSERT INTO taj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","तर थेनीगदे न्‍हङरी कोइ कोइसे “चु म्‍हिसे मी म्‍हङगदेला ग्‍ले बालजिबुलला शक्तिग्‍याम जे म्‍हङगदे ताप्‍बा हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ओच्‍छे स्‍य्‍हान्‍दो कोइ कोइसे चा येशूला सेम च्‍याबाला लागिरी “ङन्‍दा स्‍वर्गला चिनु गिक उन्‍सी पिन्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","तर येशूसे थेनीगदेला सेमला ताम था याङ्सी थेनीगदेदा “च्‍यागो, जुन य्‍हुल्‍साला म्‍हिगदे ह्राङ ह्राङ न्‍हङरी तोबा छेबा लला, थे य्‍हुल्‍सा नाश तला, ओच्‍छे जुन दिमला म्‍हिगदे ह्राङ ह्राङ न्‍हङरीन तोबा छेबा लला, थे दिमएनोन फुप्‍ला।” ");
INSERT INTO taj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","थेतबासेलमा शैतानएनोन ह्राङ ह्राङ न्‍हङरी आढिक्‍नी भिसम खाह्रङ् लसी थेला य्‍हुल्‍सा टुला? तिग्‍दा भिसम एनीगदेसे ङादा बालजिबुलला शक्तिग्‍याम म्‍हङ ताप्‍बा मुला भिसी भिबा मुला। ");
INSERT INTO taj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ङाइ बालजिबुलला शक्तिग्‍याम म्‍हङ ताप्‍मुला भिसम एनीगदेला चेलागदेसे चा खाल्‍ला शक्तिग्‍याम म्‍हङ ताप्‍बा हिन्‍ना? थेतबासेलमा एनीगदेला गल्‍ती थेनीगदेसेन उन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","तर ङाइ परमेश्‍वरला शक्तिग्‍याम म्‍हङ ताप्‍बा मुला भिसम एनीगदेला गुङरी परमेश्‍वरला य्‍हुल्‍सा खसी जिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ओच्‍छे भङ्‍बा म्‍हिसे हतियार थोसी ह्राङला दिम ख्रुङ्जी भिसम थेला मालसामान खालैसे भोरआखम। ");
INSERT INTO taj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","तर थे भन्‍दान भङ्‍बा म्‍हि खजी भिसम थेदा ढासी थेसे भर लबा जम्‍मान हतियारगदे ब्‍यन्‍ना, ओच्‍छे थेला जम्‍मान मालसामान ब्‍यन्‍सी जम्‍मादान भो लसी पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","जुन म्‍हि ङादेन छ्‌याम आढिक, थे म्‍हि ङाला बिरोधी तला। ओच्‍छे जुन म्‍हिसे ङादेन छ्‌याम गे आल थे म्‍हिसे ङाला बिरोधरी गे लला। ");
INSERT INTO taj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“म्‍हङ म्‍हिला ल्‍हुइग्‍याम थोन्‍सी निमाहेन्‍से थेसे ब्‍लप्‍बा न्‍हबारी तोङतोङबा ग्‍लारीक्‍यार ग्‍ला म्‍हाइसी भ्रला, तर थेसे खानङएनोन ब्‍लप्‍बा न्‍हबा ग्‍ला आयाङ्माहेन्‍से ‘ङा जुन म्‍हिला ल्‍हुइग्‍याम थोन्‍सी खजी थेनोन म्‍हिला ल्‍हुइरी चिबारी निइ’ भिसी दोःसी निला। ");
INSERT INTO taj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ओच्‍छे थे म्‍हङ दोःसी खमा थेसे ङाच्‍छा ह्राङ चिबा ग्‍ला साङसाङबा म्राङ्ला। ");
INSERT INTO taj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","जमाहेन्‍से थे म्‍हङ निसी ह्राङ भन्‍दा नइबा अर्गु गोर निस म्‍हङगदे भसी थे म्‍हि न्‍हङरी वाङ्सी चिमुला। थेतबासेलमा थे म्‍हिला गति ङाच्‍छाला भन्‍दा लिच्‍छाला गति झन नइबा तला।” ");
INSERT INTO taj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","येशूसे चु ताम सुङ्बान लमा म्‍हिला हुल न्‍हङ‍ग्‍याम क्रिङ्बान म्रिङम्‍हेमे गिकसे “ह्राङदा न्‍हसी ङ्‍हे ख्‍वाबा आमासे परमेश्‍वरग्‍याम मोलम याङ्बा मुला,” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","तर येशूसे “जुन म्‍हिसे परमेश्‍वरला बचन ङ्‌यान्‍सी परमेश्‍वरसे कुल्‍बा अन्‍छार लला, थे म्‍हिसे परमेश्‍वरग्‍याम झन मोलम याङ्ला,” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","येशूला क्‍युर्नोन म्‍हिला हुल तमाहेन्‍से येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदे दान्‍देला म्‍हिगदे खाह्रङ्बा नइबा म्‍हि! उदेकला चिनु जे म्‍हाइबा। तर योना अगमवक्ताला चिनु बाहेक अर्गु चिनु आउन। ");
INSERT INTO taj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","निनवे शहरला म्‍हिगदेला लागिरी योना चिनु तबा ह्रङ्नोन परमेश्‍वरसे पुइखबा म्‍हि दान्‍देला म्‍हिगदेला लागिरी चिनु हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","निसाफ लबा धुइरी ल्‍होग्‍याम खबा ग्‍लेस्‍यासे दान्‍देला म्‍हिगदेला दोष उन्‍ना, तिग्‍दा भिसम थे सोलोमन ग्‍लेला ज्ञान बुद्धिला ताम ङ्‌यान्‍बारी ल्‍हानान थारेङग्‍याम खबा मुबा। तर च्‍यागो, चुरी सोलोमन ग्‍ले भन्‍दा घ्रेन म्‍हि मुसैनोन थेला ताम आङ्‌यान्‍नी। ");
INSERT INTO taj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","निसाफ लबा धुइरी निनवे शहरला म्‍हिगदे रेःसी दान्‍देला म्‍हिगदेला दोष उन्‍ना। तिग्‍दा भिसम योना अगमवक्तासे पाङ्बा ताम ङ्‌यान्‍सी थेनीगदेसे ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःबा मुबा। तर च्‍यागो, चुरी योना अगमवक्ता भन्‍दा घ्रेन म्‍हि गिक मुला। ");
INSERT INTO taj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“खालैसे नाङसल म्रासी फामसे घप्‍सी आथान, ओच्‍छे छुम्‍सीनोन आथान। बरु दिम न्‍हङरी खबा म्‍हिगदेदा य्‍हाल तगै भिसी नोबा ग्‍लारी थान्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","एला मी एला ल्‍हुइला लागिरी नाङसल ह्रङ्‌बान हिन्‍ना। एला मी ज्‍यबा मुसम एसे ज्‍यना लसी म्राङ्ला। तर एला मी ज्‍यबा आरेसम एसे तिगै म्राङ्बारी आखम ओच्‍छे ए धोपधोपरी भ्रतोःला। ");
INSERT INTO taj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","थेतबासेलमा ए होशियार तउ, तिग्‍दा भिसम एला ल्‍हुइरी मुबा नाङसल सिसी धोपधोप थातगै। ");
INSERT INTO taj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","चुदे एनीगदेला ल्‍हुइरी तिगै धोपधोप आतना जम्‍मान ल्‍हुइ य्‍हाल तजी भिसम नाङसलसे एनीगदेदा य्‍हाल तना लबा ह्रङ्नोन एनीगदेला पूरान ल्‍हुइ य्‍हाल तला।” ");
INSERT INTO taj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","येशूसे चुह्रङ् सुङ्सी जिन्‍माहेन्‍से फरिसी गिकसे येशूदा सोल छ्‌योइबारी ह्राङला दिमरी ङ्‌योइजी। जमाहेन्‍से येशू थेला दिमरी फेप्‍सी सोल छ्‌योइबारी धन्‍छ्‌याजी। ");
INSERT INTO taj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","तर येशूसे छ्‌या आस्‍याल्‍ना सोल्‍बा म्राङ्सी थे फरिसी उदेक तजी। ");
INSERT INTO taj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","थे उदेक तबा म्राङ्सी प्रभुसे थेदा चुह्रङ् भिसी सुङ्जी, “एनी फरिसीगदेसे खोरेदेन खार्बाला पाखापट्टि म्‍याप्‍सी चोखो स्‍होबा ह्रङ् लसी एनीगदेएनोन म्‍हिदा उन्‍बारी चोखो दोबा स्‍होमुला। तर एनीगदेला सेम लोभदेन नइबा तामसे प्‍लिङ्बा तमुला। ");
INSERT INTO taj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","एनीगदे खाह्रङ्बा मूर्ख म्‍हि, जुन‍से पाखापट्टि स्‍होजी, थेसेन न्‍हङपट्टिनोन स्‍होबा आहिन? ");
INSERT INTO taj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","एनीगदेदेन छ्‌याम मुबा स्‍हेगदे प्राङबोगदेदा पिन्‍गो। जमाहेन्‍से एनीगदेला लागिरी जम्‍मान स्‍हे चोखो तला। ");
INSERT INTO taj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","परमेश्‍वरग्‍याम सजाय याङ्तोःबा फरिसीगदे, एनीगदेसे परमेश्‍वरदा बाबरीदेन जिरा ओच्‍छे अर्गु मसलाला दोङला भो च्‍युइला भो गिक मी पिन्‍मुला, तर एनीगदेसे म्‍हिगदेदा ठीक निसाफदेन परमेश्‍वरदा लतोःबा मायाला भिसम तिगै वास्‍ता आलमुला। तर एनीगदेसे चु गे न्‍हीनोन लतोःबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","परमेश्‍वरग्‍याम सजाय याङ्बा फरिसीगदे, एनीगदेसे यहूदीगदे ह्रुप तबा दिमला मुल ठिरी चिबारीदेन बजाररी स्‍य्‍हान्‍दो म्‍हिगदेसे मान लगै भिसी सेम लमुला। ");
INSERT INTO taj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","परमेश्‍वरग्‍याम सजाय याङ्तोःबागदे, एनीगदे म्‍हिगदेसे आम्राङ्बा धुर्सा ह्रङ्‌बान हिन्‍ना। थेतबासेलमा म्‍हिगदेसे था आयाङ्ना चुह्रङ्बा धुर्साथोरी भ्रमुला।” ");
INSERT INTO taj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ओच्‍छे यहूदी धर्मगुरुगदे न्‍हङला गिकसे येशूदा “गुरु ह्राङसे चुह्रङ् सुङ्सी ङन्‍नाएनोन बेइज्‍जत लबा मुला” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","येशूसे चुह्रङ् भिसी सुङ्जी, “एनी धर्मगुरुगदेएनोन परमेश्‍वरग्‍याम सजाय याङ्तोःबा म्‍हिगदे हिन्‍ना। तिग्‍दा भिसम एनीगदेसे म्‍हिगदेदा पुइनोन आखम्‍बा धोइ काप्‍बा मुला। तर एनीगदेसे चा या जुम्‍बीसेनोन आथुर्मुला। ");
INSERT INTO taj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“परमेश्‍वरग्‍याम सजाय याङ्तोःबा म्‍हिगदे, एनीगदेसे ह्राङला आखे म्‍हेमेगदेसे साइबा अगमवक्तागदेला धुर्सा स्‍होबा मुला। ");
INSERT INTO taj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","तर एनीगदेला आखे म्‍हेमेसे तिग लमुबा थे एनीगदेला गेग्‍यामसेन उन्‍बा मुला। ओच्‍छे थेन्‍ना गेदेन एनीगदेला गे ढिक्‍बा मुला। तिग्‍दा भिसम थेनीगदेसे अगमवक्तागदेदा साइजी, ओच्‍छे एनीगदेसे चा म्‍हिदा उन्‍बाला लागिरी अगमवक्तागदेला धुर्सा स्‍होबा मुला। ");
INSERT INTO taj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","थेतबासेलमा परमेश्‍वरसे ह्राङला ज्ञान बुद्धिग्‍याम चुह्रङ् भिसी सुङ्बा मुला, ‘ङाइ थेनीगदे मुबा ग्‍लारी अगमवक्तादेन मुल चेला पुइखला थेनीगदेसे कोइदा साइला कोइदा ल्‍हानान दुख पिन्‍ना।’ ");
INSERT INTO taj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","थेतबासेलमा जम्‍बुलिङ छ्‌यामाहेन्‍से दान्‍देधोना साइबा अगमवक्तागदेला सजाय दान्‍देला म्‍हिगदेसे याङ्ला। ");
INSERT INTO taj_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ओच्‍छे हाबिलहेन्‍से परमेश्‍वरला मन्‍दिर न्‍हङला चोखो ग्‍लादेन धूप म्राबा ग्‍लाला गुङरी साइबा जकरियाधोनाला सजाय दान्‍देला म्‍हिगदेला थोबोरी खला। ");
INSERT INTO taj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“परमेश्‍वरग्‍याम सजाय याङ्तोःबा यहूदी धर्मगुरुगदे, एनीगदेदेन छ्‌याम परमेश्‍वरला ज्ञान, बुद्धिला म्राप ठोङ्‌बा साँचो मुला। तसैनोन एनीगदे न्‍हङरी आवाङ्नी ओच्‍छे न्‍हङरी वाङ्बारी म्‍हाइबा म्‍हिगदेदाएनोन वाङ्आपुङ्नी।” ");
INSERT INTO taj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","येशू थेग्‍याम थोन्‍सी फेप्‍बारी छ्‌याइमा यहूदी धर्मगुरुगदेदेन फरिसीगदेसे येशूदा ल्‍हानान बिरोध लसी ल्‍हानान तामगदे ङ्‌योइबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","येशूसे जोहाब पिन्‍मा खानङै गल्‍ती स्‍याप्‍ला वा भिसी थेनीगदेसे दाउ च्‍यासी चिजी। ");
INSERT INTO taj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","थे धुइरी थेरी झ्‍यासीन झ्‍याबारी आखम्‍बाधोनाला म्‍हिगदे पोप तबासे लमा गिकसे गिकदा नाङ्बारी छ्‌याइजी, ओच्‍छे जम्‍मान भन्‍दा ङाच्‍छा येशूसे ह्राङला चेलागदेदा चुह्रङ् भिसी सुङ्बारी छ्‌याइजी, “एनीगदे फरिसीगदेला खमीरग्‍याम जोगब तसी चिउ। थे खमीर चा थेनीगदेसे म्‍हन्‍बा कप्‍टी ताम हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","घप्‍सी आम्राङ्बा स्‍हे तिगै आरे, ओच्‍छे छुम्‍सी था आयाङ्बा स्‍हे तिगै आरे। ");
INSERT INTO taj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","थेतबासेलमा जुन ताम एनीगदेसे धोपधोपरी पाङ्ला थे ताम य्‍हाल तमा थेःला। ओच्‍छे दिम न्‍हङरी सा ताम लसी पाङ्बा ताम दिमला धुरीग्‍याम थेःना लला। ");
INSERT INTO taj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","येशूसे दोःसी चुह्रङ् भिसी सुङ्जी, “ङाला ह्रोगदे ङ्‌यान्‍गो, एनीगदे ह्राङदा साइबा म्‍हि म्राङ्सी थालोङ्‍गो। तिग्‍दा भिसम थेसे एनीगदेला ल्‍हुइदा जे साइला, तर आत्‍मादा चा साइबारी आखम। ");
INSERT INTO taj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","तर एनीगदे खाल्‍देन छ्‌याम लोङ्तोःला थे ताम ङ्‌यान्‍गो, जुनदेन छ्‌याम एनीगदेदा साइसी नर्गरी भ्‍याङ्‍बा शक्ति मुला, थे म्राङ्सी जे लोङ्‍गो। ");
INSERT INTO taj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","तिग डबल न्‍हीरी च्‍युर्गन ङा ग्‍लुबारी आखम? खम्‍ला। तसैनोन थे न्‍हङला गिकदाएनोन परमेश्‍वरसे आम्‍लेः। ");
INSERT INTO taj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ओच्‍छे एनीगदेला थोबोला क्राएनोन परमेश्‍वरसे झ्‍यासी जिन्‍बा मुला। थेतबासेलमा एनीगदे थालोङ्‍गो। तिग्‍दा भिसम थे ल्‍हानान च्‍युर्गनगदे भन्‍दा मी एनीगदे ल्‍हानान घ्रेन मुला। ");
INSERT INTO taj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“ङाला ताम ङ्‌यान्‍गो, जुन म्‍हिसे ङादा म्‍हिला ओन्‍छाङरी सेमहेन्‍से प्रभु भिसी पाङ्ला, परमेश्‍वरसे पुइखबा म्‍हिसेनोन थेदा परमेश्‍वरला दूतगदेला ओन्‍छाङरी चु ह्राङलान हिन्‍ना भिसी पाङ्ला। ");
INSERT INTO taj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","तर जुन म्‍हिसे म्‍हिगदेला ओन्‍छाङरी ङादा ङाइ थेदा ङोसेबा आरे भिसी भिला, ङाइएनोन परमेश्‍वरला दूतगदेला ओन्‍छाङरी थेदा सेबान आरे भिसी पाङ्ला। ");
INSERT INTO taj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","च्‍यागो, जुन म्‍हिसे परमेश्‍वरसे पुइखबा म्‍हिला बिरोधरी ताम लला, थेसे माफ याङ्ला। तर परमेश्‍वरला आत्‍माला बिरोधरी ताम लबा म्‍हिसे खाइमै माफ आयाङ्। ");
INSERT INTO taj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“म्‍हिगदेसे एनीगदेदा चुङ्सी यहूदीगदे ह्रुप तबा दिमला नेतादेन शासन लबा म्‍हिगदे ओच्‍छे न्‍यायाधीश मुबा ग्‍लारी भोर्बा धुइरी खाह्रङ् लसी जोहाब पिन्‍बा भिसी एनीगदेसे धन्‍दा सुर्दा थालउ। ");
INSERT INTO taj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","तिग्‍दा भिसम थे धुइरी खाह्रङ् लसी जोहाब पिन्‍तोःला भिसी एनीगदेदा परमेश्‍वरला आत्‍मासेन लोप्‍ला।” ");
INSERT INTO taj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","म्‍हिला हुल न्‍हङ‍ग्‍याम म्‍हि गिकसे येशूदा “गुरु, ङाला ज्‍योज्‍योदा अंश भो लसी पिन्‍गो भिसी सुङ्सी पिन्‍गो” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","येशूसे थेदा “एनीगदेला निसाफ लबादेन अंश भो लसी पिन्‍बारी ङादा खाल्‍से अधिकार पिन्‍बा मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ओच्‍छे येशूसे थेनीगदेदा “एनीगदे होशियार तसी लोभग्‍याम जोगब तसी चिउ। तिग्‍दा भिसम म्‍हिदेन छ्‌याम जतिन धन सम्‍पत्ति मुसैनोन थेसे म्‍हिदा सत्‍यला जुनी आपिन” भिसी सुङ्बान, ");
INSERT INTO taj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","थेनीगदेदा उखान गिक सुङ्जी, “ग्‍ला गिकरी फ्‍युक्‍पो म्‍हि गिक मुबा, थेला बुरी ल्‍हानान बाली रोजी। ");
INSERT INTO taj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","थे फ्‍युक्‍पो म्‍हिसे सेम सेमरी चुह्रङ् भिजी, ‘ङादेन छ्‌याम बाली थान्‍बा ग्‍ला आरे, ङाइ तिग लसे?’ ");
INSERT INTO taj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ओच्‍छे थेसे चुह्रङ् भिजी, ‘दाहेन्‍से ङाइ चुह्रङ् लला, जम्‍मान ढुकुटीगदे फुप्‍सी घ्रेन घ्रेन स्‍होला, ओच्‍छे जम्‍मान बालीदेन मालसामान थेरीन थान्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ओच्‍छे थेसे ह्राङला सेम न्‍हङ न्‍हङरी चुह्रङ् भिसी भिजी, “ङाइ ल्‍हानान दिङधोनादा छ्‌योबा बाली पोप लबा मुला। थेतबासेलमा ङा सुख शान्‍तिरी चबा थुङ्बादेन मोजमजा लसी चिला।” ");
INSERT INTO taj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“तर परमेश्‍वरसे थेदा ‘मूर्ख, तिनी म्‍हुनङनोन एला प्राण ङाइ किन्‍ना, एसे पोप लसी थान्‍बा धन सम्‍पत्ति खाल्‍से चला?’ भिसी सुङ्जी।” ");
INSERT INTO taj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","चु उखान सुङ्सी जिन्‍माहेन्‍से येशूसे “ह्राङला लागिरी धन सम्‍पत्ति पोप लबा म्‍हिला गति चुह्रङ्बान तला। परमेश्‍वरसे चुह्रङ्बा म्‍हिगदेदा फ्‍युक्‍पो आम्‍हन्‍मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","जमाहेन्‍से येशूसे ह्राङला चेलागदेदा चुह्रङ् भिसी सुङ्जी, “थेतबासेलमा एनीगदेसे ङाला ताम ङ्‌यान्‍गो, ‘सोबाला लागिरी तिग चसे, तिग क्‍वान्‍से भिसी धन्‍दा सुर्दा थालउ।’ ");
INSERT INTO taj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","तिग्‍दा भिसम चबा थुङ्बादेन क्‍वान्‍बा भन्‍दा एनीगदेला प्राणदेन ल्‍हुइ घ्रेन हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","एनीगदेसे कावागदेदा च्‍यागो! थेनीगदेसे न्‍ह कमाइ लला, न्‍ह बाली धुइला, न्‍ह थेनीगदेला ढुकुटीन मुला। तसैनोन परमेश्‍वरसे थेनीगदेदा चबा स्‍हे पिन्‍बान मुला। एनीगदे मी चरागदे भन्‍दा ल्‍हानान घ्रेन मुला। ");
INSERT INTO taj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","एनीगदे न्‍हङरी खाल्‍से धन्‍दा सुर्दा लसी छिन्‍नङला लागिरी आयू काप्‍खम्‍ला? ");
INSERT INTO taj_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","चुदे जजा गे मी लआखम्‍मुला भिसम तिग्‍दा एनीगदे अर्गु तामला धन्‍दा सुर्दा लबा? ");
INSERT INTO taj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“एनीगदेसे म्‍हेन्‍दोदा च्‍यागो, थेनीगदेसे न्‍ह गे लला, न्‍ह क्‍वान राला। तर च्‍यागो, सोलोमन ग्‍लेदेन छ्‌याम ल्‍हानान धन सम्‍पत्ति मुसैनोन थे म्‍हेन्‍दो तेएनोन जेबा आरेमुबा। ");
INSERT INTO taj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","तिनी ल्‍हेबान निसी न्‍हङगर खर्माहेन्‍से मेरी फर्बा छेदा मी परमेश्‍वरसे चुह्रङ् लसी जेना लमुला भिसम झन एनीगदेदा परमेश्‍वरसे गाते जेना लला? खाइ एनीगदेला विश्‍वास? ");
INSERT INTO taj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","थेतबासेलमा एनीगदेसे तिग चबा, तिग थुङ्बा भिसी धन्‍दा सुर्दा लसी म्‍हाइसी थाभ्रउ। ");
INSERT INTO taj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","तिग्‍दा भिसम परमेश्‍वरदा ङोआसेबा जम्‍बुलिङला म्‍हिगदेसे चा चुह्रङ् लसी धन्‍दा सुर्दा लमुला। तर एनीगदेदा चु जम्‍मान स्‍हे तोःला भिसी परमेश्‍वर आबादा था मुला। ");
INSERT INTO taj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","थेतबासेलमा ङाच्‍छा परमेश्‍वरला य्‍हुल्‍सा म्‍हाइगो। जमाहेन्‍से परमेश्‍वरसे एनीगदेदा चु जम्‍मान स्‍हे पिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","दोःसी येशूसे चुह्रङ् भिसी सुङ्जी, “ङाला कोलागदे, एनीगदे थालोङ्‍गो! तिग्‍दा भिसम एनीगदेला परमेश्‍वर आबा ल्‍हानान ताङ्सी एनीगदेदा थेसे ह्राङला य्‍हुल्‍सा पिन्‍बारी छ्‌याइबा मुला। ");
INSERT INTO taj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","थेतबासेलमा एनीगदेसे ह्राङदेन छ्‌याम मुबा धन सम्‍पत्ति चूङ्सी खबा टाङगा प्राङबोगदेदा भो लसी पिन्‍गो। ओच्‍छे खाइमै आन्‍होङ्बा ढुकुटी स्‍होसी ह्राङला लागिरी स्‍वर्गरी धन सम्‍पत्ति सोसी थान्‍गो। थेरी य्‍होएनोन आख, बुलुङसेनोन आच। ");
INSERT INTO taj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","तिग्‍दा भिसम जुन ग्‍लारी एनीगदेला धन सम्‍पत्ति मुला, एनीगदेला सेमएनोन थेरीन तला।” ");
INSERT INTO taj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","दोःसी येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदे ह्राङला क्‍वान क्‍वान्‍सी नाङसल म्रासी तयार लसी चिउ। ");
INSERT INTO taj_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ओच्‍छे एनीगदे ब्‍याहला भोजरी निसी खबा मालिकदा भ्रान्‍सी चिबा नोकर ह्रङ्‌बान तउ। तिग्‍दा भिसम मालिक खसी म्राप ढ्वक ढ्वक लमैछ्‌याम थेनीगदेसे ह्राङला मालिकदा म्राप ठोङ्सी पिन्‍मुला। ");
INSERT INTO taj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","च्‍यागो, थे नोकरगदे गाते ताङ्‍म्‍याङ्‍ला, ह्राङला मालिक खबा धुइरी थेनीगदेदा छोर्सी चिबा म्राङ्जी। थेतबासेलमा थेसे केः खीसी ह्राङला नोकरगदेदा चबा स्‍हे पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","थे नोकरगदे गाते ताङ्‍म्‍याङ्‍ला, मालिक म्‍हुन गुङरी अथवा स्‍य्‍हो तबा धुइरी खसैनोन ह्राङला नोकरगदे छोर्सी चिबा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","तर एनीगदेसे चु तामएनोन था याङ्‍गो, दिमला म्‍हिसे य्‍हो खबा धुइ था याङ्सम थेसे ह्राङला दिम न्‍हङरी य्‍हो वाङ्आपुङ्। ");
INSERT INTO taj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","थेह्रङ् लसीन एनीगदेएनोन होशियार तसी छोर्सी चिउ। तिग्‍दा भिसम परमेश्‍वरसे पुइखबा म्‍हिएनोन एनीगदेसे आम्‍हन्‍बा धुइरी खला। ");
INSERT INTO taj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","जमाहेन्‍से पत्रुससे येशूदा “प्रभु, चु उखान ङन्‍ना लागिरी जे सुङ्बा कि स्‍य्‍हान्‍दो म्‍हिगदेला लागिरीनोन सुङ्बा हिन्‍ना?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","प्रभुसे थेदा चुह्रङ् भिसी सुङ्जी, “दिमरी गे लबा बुद्धि मुबादेन भर्तुप्‍पा म्‍हि खाल हिन्‍ना? मालिकसे दिमला स्‍य्‍हान्‍दो नोकरगदेदा ठीक ठीक धुइरी चबा थुङ्बा ढिक्‍ना लसी पिन्‍बारी जिम्‍मा पिन्‍थान्‍जी।” ");
INSERT INTO taj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","मालिक दोःसी खबा धुइरीनोन थेसे मालिकसे कुल्‍सी थान्‍बा ह्रङ् लसी गे लबा म्राङ्जी भिसम इनाम याङ्बा नोकर थेनोन हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, मालिकसे थेह्रङ्बा नोकरदा ह्राङला जम्‍मान धन सम्‍पत्ति जिम्‍मा पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","तर थे आज्‍यबा नोकरसे ‘ङाला मालिक योनान आख’ भिसी म्‍हन्‍सी, ङ्‍य्‍होइबा म्‍हिगदेदेन छ्‌याम चिसी चबा थुङ्बा लसी ह्राङदेन छ्‌यामनोन गे लबा नोकरगदेदा तोबा ग्‍याङ्‍बा लजी भिसम, ");
INSERT INTO taj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","थेला मालिक थेसे आम्‍हन्‍बा धिनदेन धुइरी धोखसी मालिकसे थेदा ल्‍हानान सजाय पिन्‍ना। ओच्‍छे थेदा परमेश्‍वरदा विश्‍वास आलबा म्‍हिगदे मुबा ग्‍लारी भ्‍याङ्‍ला। ");
INSERT INTO taj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“ह्राङला दिमला मालिकला सेमला ताम था याङ्सीनोन सेम निबा गे आलबा नोकरसे तोबा चला। ");
INSERT INTO taj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","तर ह्राङला मालिकला सेमला ताम था आयाङ्ना तोबा चबा खाल्‍ला गे लसैनोन थे नोकरदा ल्‍हाना आतोः। ओच्‍छे जुन म्‍हिदा ल्‍हाना पिन्‍बा मुला थेसेनोन ल्‍हानान पिन्‍तोःला। थेह्रङ् लसीन जुन म्‍हिदा ल्‍हानान जिम्‍मा पिन्‍बा मुला थेदेन छ्‌याम ल्‍हानान किन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“च्‍यागो, ङा जम्‍बुलिङरी मे सल्‍कब लबारी खबा हिन्‍ना। बरु ङाच्‍छान सल्‍कब तबा हिन्‍सै तसेला मुबा। ");
INSERT INTO taj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ङाइ दुखला बप्‍तिस्‍मा किन्‍तोःबा मुला, थे बप्‍तिस्‍मा आकिन्‍तेधोना ङादा शान्‍ति आत। ");
INSERT INTO taj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","तिग एनीगदेसे ङा जम्‍बुलिङरी म्‍हिगदेदा ढिक्‍ना लबारी खबा भिसी म्‍हन्‍बा? आहिन, ङा मी एनीगदेदा फेना लबारी खबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","दाहेन्‍से गोर ङा म्‍हिला थेमे ह्राङ ह्राङ न्‍हङरी फेला। ओच्‍छे न्‍हीला बिरोधरी सोम, सोमला बिरोधरी न्‍ही रेःला। ");
INSERT INTO taj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","थेह्रङ् लसीन आबाला बिरोधरी झा, झाला बिरोधरी आबा, आमाला बिरोधरी झामे, झामेला बिरोधरी आमा ओच्‍छे स्‍युमीला बिरोधरी चाङ, चाङला बिरोधरी स्‍युमी रेःला।” ");
INSERT INTO taj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","जमाहेन्‍से म्‍हिला हुलदाएनोन येशूसे चुह्रङ् भिसी सुङ्जी, “जम्‍बुलिङला न्‍हुपग्‍याम खसु थोन्‍माहेन्‍से ‘दाहेन्‍से नाम खला’ भिसी एनीगदेसे भिमुला, ओच्‍छे थेह्रङ्नोन तमुला। ");
INSERT INTO taj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","थेह्रङ् लसीन जम्‍बुलिङला ल्‍होपट्टिसे लाबा खबारी छ्‌याइमाहेन्‍से ‘दाहेन्‍से छेप्‍बा छला’ भिसी एनीगदेसे भिमुला, ओच्‍छे थेह्रङ्नोन तमुला। ");
INSERT INTO taj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","कप्‍टीगदे, एनीगदेसे सदेन मुरी च्‍यासी तिग तबारी छ्‌याइबा मुला भिबा ताम चा था याङ्मुला। तर दान्‍दे तिग तबारी छ्‌याइबा मुला भिबा ताम चा तिग्‍दा था आयाङ्बा? ");
INSERT INTO taj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“‘ङाइ लबा गे ठीक मुला कि आरे’ भिसी एनीगदेसे तिग्‍दा पक्‍का आलबा? ");
INSERT INTO taj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","खालैसे एदा मुद्दा युसी न्‍यायाधीश मुबा ग्‍लारी भोर्जी भिसम, थे म्‍हिदेन छ्‌याम ग्‍यामरीन ढिक्‍गो। आहिन्‍सम थेसे एदा न्‍यायाधीशला ङाच्‍छापट्टि राप्‍पुङ्ला। ओच्‍छे न्‍यायाधीशसे सिपाहीगदेला यारी जिम्‍मा पिन्‍ना। जमाहेन्‍से सिपाहीगदेसे भोर्सी झ्‍याल्‍खानरी झाङ्‌ला। ");
INSERT INTO taj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","एसे ङाला ताम ङ्‌यान्‍गो, एसे जम्‍मान टाङगा आफातेधोना थेग्‍याम थोन्‍बारी आम्‍याङ्।” ");
INSERT INTO taj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","थेनोन धुइरी थेरी मुबा कोइ कोइ म्‍हिगदेसे येशूदा चुह्रङ् भिसी पाङ्जी। गालीलला म्‍हिगदेसे परमेश्‍वरदा बलि फुल्‍बान लमा पिलातस भिबा रोमी अञ्‍चलाधीशसे थेनीगदेदान साइजी। ओच्‍छे थेनीगदेला काएनोन पशुला कादेन छ्‌याम दोङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","जमाहेन्‍से येशूसे थेनीगदेदा चुह्रङ् भिसी जोहाब पिन्‍जी, “थे गालीलला म्‍हिगदेसे चुह्रङ् लसी दुख नाजी भिदेमा एनीगदेसे चु गालीलला म्‍हिगदेदा स्‍य्‍हान्‍दोगदे भन्‍दा ल्‍हानान पापी मुला भिसी म्‍हन्‍बा? ");
INSERT INTO taj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","आहिन, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, तिग्‍दा भिसम एनीगदेसे ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि आदोःनी भिसम एनीगदेएनोन थेह्रङ् लसीन नाश तला। ");
INSERT INTO taj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","थेह्रङ् लसीन सिलोआम भिबा ग्‍लाला धरहरा गुर्सी सिबा च्‍युक भ्रेः म्‍हिगदे तिग यरूशलेमला स्‍य्‍हान्‍दो म्‍हिगदे भन्‍दा पापी मुबा भिसी म्‍हन्‍बा? ");
INSERT INTO taj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","आहिन, ङाला ताम ङ्‌यान्‍गो, तिग्‍दा भिसम एनीगदेसे ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि आदोःनी भिसम एनीगदेएनोन थेह्रङ् लसीन नाश तला।” ");
INSERT INTO taj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","जमाहेन्‍से येशूसे थेनीगदेदा उखान गिक सुङ्जी, “म्‍हि गिकसे वारीरी अञ्‍जीरला दोङ सूबा मुबा। थे म्‍हिसे थे अञ्‍जीरला दोङरी अञ्‍जीर रोजी वा भिसी च्‍याबारी खमा तिगै आस्‍याप्‍नी। ");
INSERT INTO taj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","थेतबासेलमा थेसे ह्राङला वारीरी गे लबा म्‍हिदा ‘ङाइ अञ्‍जीर रोला वा भिसी च्‍याबा सोम दिङ तजी, तर दान्‍देधोना आरोनी। दाहेन्‍से चुदा थासी भ्‍याङ्‍गो’ भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","थे गे लबा म्‍हिसे ‘अझ तिदिङ भ्रान्‍गो, ङाइ चु दोङला क्‍यारक्‍युर ख्‍वसी सार युला। ");
INSERT INTO taj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ओते लसीनोन आरोनी भिसम ह्राङसे चु दोङ थासी भ्‍याङ्‍खम्‍ला’ भिसी भिजी।” ");
INSERT INTO taj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","येशूसे ब्‍लप्‍बा न्‍हबा धिनकुनु यहूदीगदे ह्रुप तबा दिमरी लोप्‍बान मुबा। ");
INSERT INTO taj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","थेरी म्‍हङसे स्‍याप्‍सी कुब्रे तबा म्रिङम्‍हेमे गिक मुबा। थे खाइमै सिधा तसी भ्रबारी आखम्‍मुबा। थे थेह्रङ् तबा च्‍युक भ्रेः दिङ तबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","येशूसे थे म्रिङम्‍हेमेदा म्राङ्सी ह्राङला ङामरी ङ्‌योइसी, “दाहेन्‍से ए खम्‍जी” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ओच्‍छे थेथोरी येशूसे ह्राङला छ्‌या थान्‍मैछ्‌याम थे कुब्रे तबा म्रिङम्‍हेमे खम्‍जी। जमाहेन्‍से थे म्रिङम्‍हेमेसे परमेश्‍वरला जयजयकार लबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","येशूसे थे म्रिङम्‍हेमेदा ब्‍लप्‍बा न्‍हबा धिनकुनु खम्‍ना लबा म्राङ्सी यहूदीगदे ह्रुप तबा दिमला नेता बोमो खसी, “म्‍हिगदेदा गे लबा धिन साता गिकरी ढुरे मुनोन मुला। थेतबासेलमा चु ढुरे न्‍हङरी खसी खम्‍ना लउ, ब्‍लप्‍बा न्‍हबा धिनकुनु आहिन” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","प्रभुसे थेदा चुह्रङ् भिसी सुङ्जी, “कप्‍टी, तिग एनीगदेसे ब्‍लप्‍बा न्‍हबा धिनकुनु म्‍हे मुइदेन गधादा पुइसी क्‍युइ ख्‍वाबारी आभोर्मुला? ");
INSERT INTO taj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","चु अब्राहामला सन्‍तानदा च्‍युक भ्रेः दिङधोना शैतानसे आख्‍लाबा मुबा भिसम, तिनी ब्‍लप्‍बा न्‍हबा धिनकुनुएनोन खम्‍ना लतोःबा आहिन?” ");
INSERT INTO taj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","येशूसे चुह्रङ् लसी जोहाब पिन्‍बा म्राङ्सी, येशूला बिरोधीगदे पेःजी। तर थेरी मुबा म्‍हिगदे चा येशूसे लबा उदेकला गे म्राङ्सी ताङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","जमाहेन्‍से येशूसे थेनीगदेदा “परमेश्‍वरला य्‍हुल्‍सादा ङाइ तिगदेन छ्‌याम दाँजब लसे? परमेश्‍वरला य्‍हुल्‍सा खाह्रङ्बा मुला भिसम, ");
INSERT INTO taj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","चु चा पच्‍छै ढापला ब्‍लु गिक ह्रङ्‌बान हिन्‍ना। खालै म्‍हिसे घुर्‍यानरी ढ्वमाहेन्‍से थे ढाप फुइसी ल्‍हेबान निमुला। जमाहेन्‍से थे पच्‍छै ढापला दोङला हाँगारी चरागदेसे जङ स्‍होसी चिला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","दोःसी येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “परमेश्‍वरला य्‍हुल्‍सादा ङाइ तिगदेन छ्‌याम दाँजब लसे? ");
INSERT INTO taj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","चु मी गेङरी युबा खमीर ह्रङ्‌बान हिन्‍ना। थे खमीर म्रिङम्‍हेमे गिकसे फाम सोम ब्रारी युसी ज्‍योप्‍ला। ओच्‍छे थे ब्रा आभोतेधोना थेसे घप्‍सी थान्‍ना।” ");
INSERT INTO taj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","जमाहेन्‍से येशू शहर शहरदेन नाम्‍सा नाम्‍सारी फेप्‍सी म्‍हिगदेदा लोप्‍बान यरूशलेमरी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","थेनोन धुइरी म्‍हि गिकसे, “प्रभु, तिग थार्बा याङ्बा म्‍हिगदे ल्‍हाना आरे?” भिसी येशूदा ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","येशूसे थेरी मुबा म्‍हिगदेदा चुह्रङ् भिसी सुङ्जी, “च्‍यागो, साङरो म्रापग्‍याम वाङ्बारी भङ लउ। तिग्‍दा भिसम ल्‍हानान म्‍हिगदे वाङ्बारी म्‍हाइमुला, तसैनोन वाङ्बारी आखम्‍मुला। ");
INSERT INTO taj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","दिमला मालिक रेःसी म्राप ढुङ्सी जिन्‍माहेन्‍से एनीगदेसे मङग्‍यारग्‍याम ढ्वक ढ्वक लसी ‘गुरु, ङन्‍दा म्राप ठोङ्सी पिन्‍गो’ भिसी भिमा, थेसे एनीगदेदा ‘एनीगदे खाल हिन्‍ना? ओच्‍छे खानङग्‍याम खबा? ङाइ एनीगदेदा ङोसेबा आरे’ भिसी भिला। ");
INSERT INTO taj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","एनीगदेसे ‘ह्राङ ङन्‍देन छ्‌यामनोन सोल्‍बा छ्‌योइबा लबा मुबा। ओच्‍छे ङन्‍ना नाम्‍सारीक्‍यार ह्राङसे लोप्‍बा मुबा’ भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","थेसे एनीगदेदा ‘एनीगदे खाल हिन्‍ना? ङाइ ङोआसेनी। थेतबासेलमा पाप गे लबागदे, एनीगदे ङा मुबा ग्‍लाग्‍याम निउ’ भिसी भिला। ");
INSERT INTO taj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ओच्‍छे एनीगदेसे अब्राहाम, इसहाक, याकूबदेन जम्‍मान अगमवक्तागदेदा परमेश्‍वरला य्‍हुल्‍सारी म्राङ्मा, ह्राङदा चा मङग्‍यार भ्‍याङ्‍मा क्राबा क्रिङ्बा लसी स्‍वा क्रेला। ");
INSERT INTO taj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","स्‍यार, ल्‍हो, न्‍हुप, झ्‍याङ जम्‍मान ग्‍लाग्‍यामसे म्‍हिगदे खसी परमेश्‍वरला य्‍हुल्‍सारी थेदेन छ्‌यामनोन चबा थुङ्बा लबारी चिला। ");
INSERT INTO taj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","तर च्‍यागो, दान्‍दे लिच्‍छा मुबागदे ङाच्‍छा तला, ओच्‍छे दान्‍दे ङाच्‍छा मुबागदे लिच्‍छा तला।” ");
INSERT INTO taj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","थेनोन धुइरी कोइ कोइ फरिसीगदे येशू मुबा ग्‍लारी खसी, “ह्राङ चुग्‍याम थोन्‍सी फेप्‍गो। तिग्‍दा भिसम ह्राङदा हेरोदसे साइबारी छ्‌याइबा मुला” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदे निसी थे ल्‍हुन्‍दी ह्रङ्‌बा छट्टुदा चुह्रङ् भिउ, ‘तिनीदेन न्‍हङगर ङाइ म्‍हङगदे ताप्‍बादेन आखम्‍बागदेदा खम्‍ना लबा गे लला, ओच्‍छे रेनी ङाला गे जिन्‍ना।’ ");
INSERT INTO taj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ओच्‍छे तिनी, न्‍हङगर, रेनीकुनुधोनारी ङा यरूशलेम शहररी धोनोन तोःला। तिग्‍दा भिसम यरूशलेम शहररी बाहेक अर्गु ग्‍लारी अगमवक्तादा आसाइ! ");
INSERT INTO taj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“यरूशलेमला म्‍हिगदे, एनीगदेसे अगमवक्तागदेदा साइला ओच्‍छे परमेश्‍वरसे एनीगदे मुबा ग्‍लारी पुइखबागदेदा युङबासे तोला। ङाइ एनीगदेला कोलागदेदा नागा मामासे ह्राङला कोलागदेदा भ्‍याप्‍से घप्‍बा ह्रङ् लसी पोप लबारी म्‍हाइमा एनीगदेसे आङ्‌यान्‍नी। ");
INSERT INTO taj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","दाहेन्‍से परमेश्‍वरसे एनीगदेला दिम ख्‍लाला। च्‍यागो, ङाला ताम ङ्‌यान्‍गो, एनीगदेसे ‘परमप्रभुला मिनरी फेप्‍खबादा मोलम याङ्बा म्‍हि’ भिसी आभितेधोना ङादा आम्राङ्।” ");
INSERT INTO taj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","येशू ब्‍लप्‍बा न्‍हबा धिनकुनु फरिसीगदेला नेता गिकला दिमरी सोल छ्‌योइबारी फेप्‍जी। थेरी मुबा फरिसीगदेसे येशूला चिवा लसी चिमुबा। ");
INSERT INTO taj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","थेरी टाङ्‌बा बेथासे स्‍याप्‍बा म्‍हि गिक येशूला ङाच्‍छापट्टि मुबा। ");
INSERT INTO taj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","येशूसे यहूदी धर्मगुरुगदेदेन फरिसीगदेदा “ब्‍लप्‍बा न्‍हबा धिनकुनु आखम्‍बा म्‍हिदा खम्‍ना लबारी तला कि आत?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","थेनीगदे कुटिसी चिजी। ओच्‍छे येशूसे थे आखम्‍बा म्‍हिदा ह्राङला यासे थुर्सी खम्‍ना लमाहेन्‍से “दिमरी निउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","जमाहेन्‍से येशूसे थेनीगदेदा “ब्‍लप्‍बा न्‍हबा धिनकुनु एनीगदेला कोलागदे अथवा ग्‍लाप इनार न्‍हङरी ताइजी भिसम तिग एनीगदेसे तुरुन्‍तन आतेःना चिला?” भिसी सुङ्मा, ");
INSERT INTO taj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","थेनीगदेसे तिगै पाङ्‌बारी आखम्‍नी। ");
INSERT INTO taj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","थेरी चबा थुङ्बारी खबा म्‍हिगदेसे मुल ठिगदे धम्‍सी चिबारी म्‍हाइबा म्राङ्सी येशूसे थेनीगदेदा उखान गिक सुङ्जी, ");
INSERT INTO taj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“खालैसे एनीगदेदा ब्‍याहरी निम्‍तो पिन्‍जी भिसम मुल ठिरी चिबारी थाम्‍हाइगो। तिग्‍दा भिसम थेरी एनीगदे भन्‍दा घ्रेन म्‍हिदाएनोन निम्‍तो पिन्‍बा मुला तला। ");
INSERT INTO taj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","एदेन थेदा निम्‍तो पिन्‍बा म्‍हि खसी ‘चु ग्‍लारी थेदा चिपुङ्‍गो’ भिसी एदा चिबा ग्‍लाग्‍याम रेःपुङ्ला। जमा ए पेःसी जम्‍मान भन्‍दा धिरी चितोःला। ");
INSERT INTO taj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","थेतबासेलमा एसे निम्‍तो याङ्बा धुइरी निसी जम्‍मान भन्‍दा धिला ग्‍लारी चिउ। जमाहेन्‍से एदा निम्‍तो पिन्‍बा म्‍हि खसी ‘तोर धन्‍छ्‌यागो’ भिसी मुल ठिरी चिपुङ्ला। थे धुइरी एदेन छ्‌याम चबा थुङ्बारी चिबागदेला ओन्‍छाङरी एसे मान याङ्ला। ");
INSERT INTO taj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","तिग्‍दा भिसम जुन म्‍हिसे ह्राङसे ह्राङदान घ्रेन स्‍होला थेदा जम्‍मान भन्‍दा जजा स्‍होला ओच्‍छे जुन म्‍हिसे ह्राङसे ह्राङदान जजा स्‍होला थेदा जम्‍मान भन्‍दा घ्रेन स्‍होला।” ");
INSERT INTO taj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","येशूसे ह्राङदा निम्‍तो पिन्‍बा म्‍हिदाएनोन चुह्रङ् भिसी सुङ्जी, “एसे चबा थुङ्बारी ह्रोगदे, ह्राङला ज्‍योज्‍यो आलेगदे, ह्राङला म्‍हिगदेदेन फ्‍युक्‍पो खिम्‍जेमगदेदा जे थाङ्‌योइगो। तिग्‍दा भिसम थेनीगदेसेनोन एसे ह्रङ् लसीन निम्‍तो पिन्‍सी एला गुण फाला। ");
INSERT INTO taj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","थेतबासेलमा एसे प्राङबोगदे, कुज्‍यागदेदेन मी आम्राङ्बा म्‍हिगदेदाएनोन ङ्‌योइगो। ");
INSERT INTO taj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","थेह्रङ् लजी भिसम एसे मोलम याङ्ला। तिग्‍दा भिसम थेनीगदेसे एसे लबा गुण फाबारी आखम्‍सै परमेश्‍वरसे म्‍हन्‍बा अन्‍छारला गे लबा म्‍हिगदे सिबाग्‍याम सोबा धुइरी परमेश्‍वरसेन एसे लबा गुण फाला।” ");
INSERT INTO taj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","येशूला ताम थेःसी येशूदेन छ्‌याम चबा थुङ्बा लबा म्‍हिगदे न्‍हङला गिकसे “परमेश्‍वरला य्‍हुल्‍सारी चबा थुङ्बा लम्‍याङ्बागदे गाते ताङ्‍म्‍याङ्‍ला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","जमाहेन्‍से येशूसे थेदा उखानग्‍याम चुह्रङ् भिसी सुङ्जी, “म्‍हि गिकसे घ्रेन भोज पिन्‍बारी ल्‍हानान म्‍हिगदेदा निम्‍तो पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","भोज ठीक लसी जिन्‍माहेन्‍से ह्राङसे निम्‍तो पिन्‍बा म्‍हिगदेदा जम्‍मान ठीक तजी भिसी ङ्‌योइबारी ह्राङला नोकरदा पुइजी। ");
INSERT INTO taj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","तर निम्‍तो याङ्बा जम्‍मान म्‍हिगदेसे निउ गिक गिक लसी चुह्रङ् भिबारी छ्‌याइजी, ‘गिकसे चा ङाइ बु ग्‍लुबा मुला थे च्‍याबारी नितोःला। थेतबासेलमा ङादा माफ लउ, ङा खआम्‍याङ्’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ओच्‍छे स्‍य्‍हान्‍दोसे चा ‘ङाइ हल ङा ग्‍लाप ग्‍लुबा मुला, तिनीन थे ग्‍लाप च्‍याबारी नितोःबा मुला। थेतबासेलमा ङादा माफ लउ, ङा खआम्‍याङ्’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","थेह्रङ् लसीन स्‍य्‍हान्‍दोसेनोन ‘ङाइ भर्खर जे ब्‍याह लबा मुला, थेतबासेलमा ङा खआम्‍याङ्’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","नोकरसे चु ताम ह्राङला मालिकदा पाङ्माहेन्‍से दिमला मालिक बोमो खसी ‘ए शहरला ग्‍यामदेन गल्‍लीगदेरी निसी थेरी मुबा जम्‍मान प्राङबो, कुज्‍यादेन मी आम्राङ्बागदेदा ङ्‌योइसी चुरी भउ’ भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","चुह्रङ् लसी जिन्‍माहेन्‍से नोकरसे दिमला मालिकदा ‘गुरु, ह्राङसे कुल्‍बा अन्‍छार ङाइ जम्‍मादान ङ्‌योइसी भजी, तसैनोन अझ ग्‍ला मुला’ भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","मालिकसे ‘ए शहरला मुल ग्‍यामदेन गल्‍ली गल्‍लीरी निसी म्‍हिगदेदा कर लसी भसी खउ। तिग्‍दा भिसम ङाला दिम नाङनोन म्‍हिगदे तगै! ");
INSERT INTO taj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","चु भन्‍दा ङाच्‍छा निम्‍तो याङ्बा म्‍हिगदे खालैसेनोन ङाला भोजला ब्रोइ म्‍य्‍हाङ् आम्‍य्‍हाङ्’ भिसी भिजी।” ");
INSERT INTO taj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","म्‍हिला हुल येशूदेन छ्‌याम निबान लबा धुइरी थेनीगदेपट्टि दोःसी येशूसे चुह्रङ् भिसी सुङ्जी, ");
INSERT INTO taj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“चुदे ङादेन छ्‌याम भ्रजी भिसम थेसे ह्राङला आबा आमा, म्रिङ, कोलागदे, ज्‍योज्‍यो आले, नाना आङा ओच्‍छे ह्राङलान ज्‍यानएनोन माया मारब आलनी भिसम थे ङाला चेला दोआखम। ");
INSERT INTO taj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","जुन म्‍हिसे आसितेधोना ह्राङला दुख ह्राङसेन नासी ङादेन छ्‌याम आभ्र थे ङाला चेला दोआखम। ");
INSERT INTO taj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“चुदे एनीगदे न्‍हङरी खालै म्‍हिसे धरहरा स्‍होबा सेम लसम थेसे धरहरा स्‍होसी जिन्‍बाधोना गाते खर्च निला भिसी ङाच्‍छान हिसाब लतोःला। ");
INSERT INTO taj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","थेह्रङ् आलनी भिसम थेसे धरहराला जग थान्‍सी धरहरा स्‍होसी जिन्‍ना लबारी आखम्‍नी भिसम चु म्राङ्बा जम्‍मान म्‍हिगदेसे थेदा खिसी लसी, ");
INSERT INTO taj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘चु म्‍हिसे स्‍होबारीम छ्‌याइमुबा तर स्‍होसी जिन्‍ना लबारी चा आखम्‍नी’ भिला। ");
INSERT INTO taj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“खजिबै ग्‍लेसे अर्गु य्‍हुल्‍साला ग्‍लेदेन छ्‌याम लडाइ लबारी निमा ह्राङदेन छ्‌याम मुबा हजार च्‍युइ सिपाहीगदे भोर्सी ह्राङदेन छ्‌याम लडाइ लबारी खबा बोगल गिक हजार सिपाहीदा ढाबारी खम्‍ला कि आखम थे ङाच्‍छान चिसी सल्‍लाह आल? ");
INSERT INTO taj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","लडाइ लबारी आखम्‍नाम भिसी था याङ्माहेन्‍से ङाच्‍छान ढिक्‍बाला लागिरी स्‍य्‍हान्‍दो ग्‍ले मुबा ग्‍लारी ह्राङला ग्‍ले ब्‍लोन पुइला। ");
INSERT INTO taj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","थेह्रङ् लसी एनीगदे न्‍हङला जुन म्‍हिसे ङाला लागिरी जम्‍मान स्‍हे ख्‍लाआखम थे म्‍हि ङाला चेला दोआखम। ");
INSERT INTO taj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“चजा ज्‍यबा स्‍हे हिन्‍ना, तर चजाला ङम्‍बा स्‍हे निजी भिसम थेदा दोःसी तिग्‍से ङम्‍ना लबा? ");
INSERT INTO taj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","थे चजा न्‍ह साप्राला लागिरी गे खेल्‍बा तला न्‍ह सारनोन तला। जमाहेन्‍से म्‍हिगदेसे थे चजा भ्‍याङ्‍ला। जुन म्‍हिदा ङ्‌यान्‍बा सेम मुला थेसे ङ्‌यान्‍सी घोउ।” ");
INSERT INTO taj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","तिरेकुनु तिरो दुइबा म्‍हिगदेदेन पापीगदे जम्‍मान येशूला बचन ङ्‌यान्‍बारी थेला ङामरी खजी। ");
INSERT INTO taj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","चु म्राङ्सी फरिसीदेन यहूदी धर्मगुरुगदेसे “चु म्‍हि मी पापीगदेदेन छ्‌याम ढिक्‍सी थेनीगदेदेन छ्‌यामनोन चिसी चबा थुङ्बा लबा चीम” भिसी येशूला तामगन लबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","जमाहेन्‍से येशूसे थेनीगदेदा उखान गिक सुङ्जी, ");
INSERT INTO taj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“एनीगदे खालै म्‍हिला ग्‍यार्जा गिक ग्‍यु न्‍हङरी गिक म्‍हाजी भिसम थेसे बोगल ब्‍लिसे च्‍युक कु ग्‍युगदेदा ख्‍लासी थे म्‍हाबा ग्‍यु आस्‍याप्‍तेधोना आम्‍हाइ? म्‍हाइला। ");
INSERT INTO taj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","थे ग्‍यु स्‍याप्‍माहेन्‍से ताङ्सी ताङ्सी थेसे बमरी पुइसी दिमरी भला। ");
INSERT INTO taj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ओच्‍छे ह्राङला ह्रोगदेदेन खिम्‍जेमगदेदा ङ्‌योइसी एनीगदेएनोन ङा ह्रङ् लसी ताङ्‍गो। तिग्‍दा भिसम ‘ङाइ ङाला म्‍हाबा ग्‍यु स्‍याप्‍जी’ भिसी भिला। ");
INSERT INTO taj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","थेतबासेलमा एनीगदेसे ङाला ताम ङ्‌यान्‍गो, चुह्रङ् लसीन ह्राङला पाप आख्‍लाना ङनी परमेश्‍वरला ङाच्‍छा ज्‍यबा दोसी ह्राङला पाप ख्‍लाआतोःबा बोगल ब्‍लिसे च्‍युक कु म्‍हिगदेला लागिरी भन्‍दा ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःबा म्‍हि गिकला लागिरी स्‍वर्गरी मुबागदे ल्‍हानान ताङ्ला। ");
INSERT INTO taj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","दोःसी येशूसे उखान गिकग्‍याम चुह्रङ् भिसी सुङ्जी, “खालै म्रिङम्‍हेमे गिकदेन छ्‌याम म्‍हुइला गोर च्‍युइ डबल मुबा। थे डबल च्‍युइ न्‍हङरी डबल गिक म्‍हाजी भिसम थेसे थे डबल आस्‍याप्‍तेधोना नाङसल म्रासी दिम साङसिङ लसी आम्‍हाइ? म्‍हाइला। ");
INSERT INTO taj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ओच्‍छे थे म्‍हाबा डबल स्‍याप्‍माहेन्‍से थेसे ह्राङला ह्रोगदेदेन खिम्‍जेमगदेदा ङ्‌योइसी ‘एनीगदेएनोन ङा ह्रङ् लसी ताङ्‍गो। तिग्‍दा भिसम ङाइ ङाला म्‍हाबा डबल याङ्जी’ भिसी भिला। ");
INSERT INTO taj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","थेतबासेलमा एनीगदेसे ङाला ताम ङ्‌यान्‍गो, थेह्रङ् लसीन खालै म्‍हिसे ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःजी भिसम थे पापी गिकला लागिरी परमेश्‍वरला दूतगदे परमेश्‍वरदेन छ्‌यामनोन ताङ्ला।” ");
INSERT INTO taj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","दोःसी येशूसे उखान गिक सुङ्जी, “च्‍यागो, म्‍हि गिकला झा न्‍ही मुबा। ");
INSERT INTO taj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","थेला झा च्‍याङ्‍बासे चा आबादा ‘ङाला अंश भउ आबा’ भिसी भिजी। जमाहेन्‍से थेसे ह्राङला सम्‍पत्ति झा न्‍हीदान भो लसी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“तिगै धिन लिच्‍छा थे म्‍हिला झा च्‍याङ्बा ह्राङला जम्‍मान सम्‍पत्ति भोर्सी अर्गु य्‍हुल्‍सारी निजी। थेसे थेरी मोजमजा लसी जम्‍मान सम्‍पत्ति जिन्‍ना लजी। ");
INSERT INTO taj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","थेला जम्‍मान धन सम्‍पत्ति जिन्‍बा धुइरीन थे य्‍हुल्‍सारी ल्‍हानान अनिकाल तजी, ओच्‍छे थेसे ल्‍हानान दुख याङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","जमाहेन्‍से थे, थे य्‍हुल्‍साला म्‍हि गिक मुबा ग्‍लारी गे म्‍हाइबारी निजी। थे म्‍हिसे थेदा ह्राङला ढ्वा छबारी पुइजी। ");
INSERT INTO taj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","थेदा खालैसे चबा थुङ्बा आपिन्‍बासे लमा थेसे ढ्वला दाना चसीन ह्राङला फो म्रेन्‍ना लबारी म्‍हाइजी। ");
INSERT INTO taj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“जमाहेन्‍से थेसे ह्राङला दिम ढन्‍जी। ओच्‍छे चुह्रङ् भिबारी छ्‌याइजी, ‘ङाला दिमरी ङाला आबाला नोकरगदेसे म्रेन्‍ना चसीनोन लेङ्बाधोना चबा स्‍हे मुला। तर ङा चा भिसम चुरी फोइथाननोन सिबारी छ्‌याइबा मुला। ");
INSERT INTO taj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","दाहेन्‍से ङा आबा मुबा ग्‍लारी निसी, “आबा, ङाइ परमेश्‍वरदेन ह्राङला बिरोधरी पाप लजी। ");
INSERT INTO taj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","दाहेन्‍से ङा ह्राङला झा भिबाधोनाला आरे। तसैनोन ह्राङसे ङादा दया लसी ह्राङला नोकरगदे न्‍हङला गिक म्‍हन्‍सी थान्‍गो भितोःजी”’ भिसी म्‍हन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“जमाहेन्‍से थे आबा मुबा ग्‍लारी निजी। आबासे थेदा थारेङग्‍याम खबान लबा म्राङ्सी थेला सेमरी दया रेःजी। ओच्‍छे ताङ्सी झादा स्‍याप्‍बारी यार्बान निसी झादा हाप ख्‍वाइसी च्‍योक लजी। ");
INSERT INTO taj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ओच्‍छे झासे ‘आबा, ङाइ परमेश्‍वरदेन ह्राङला बिरोधरी पाप लबा मुला। ङा दाहेन्‍से ह्राङला झा भिबाधोनाला आरे’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","तर आबासे ह्राङला नोकरगदेदा ङ्‌योइसी चुह्रङ् भिजी, ‘जम्‍मान भन्‍दा ज्‍यबा क्‍वान, च्‍याप‍देन लखम योना भसी चुदा क्‍वान्‍सी पिन्‍गो। ");
INSERT INTO taj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ओच्‍छे छोबा ह्रङ्‌बा बहर भसी साइगो। तिनी य्‍हाङसे भोज लइ। ");
INSERT INTO taj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","तिग्‍दा भिसम चु ङाला झा सिबा मुबा दान्‍दे सोबा मुला, थे म्‍हाबा मुबा तर दान्‍दे याङ्बा मुला।’ जमाहेन्‍से जम्‍मान ताङ्सी भोज चबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“थे धुइरी थेला थेबा झा बुरी मुबा। थे बुग्‍याम खबा धुइरी दिमला ङामरी धोखमा दिमरी व्‍हाइ गोबादेन स्य्‍हबान लबा थेःजी। ");
INSERT INTO taj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","जमाहेन्‍से थेसे नोकर गिकदा ङ्‌योइसी, ‘चुरी तिग लबा?’ भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","नोकरसे थेदा ‘ह्राङला आले दोःसी दिमरी खबा मुला। चुह्रङ् लसी ह्राङला झा ज्‍यना लसी खबासे लमा आबासे जम्‍मान भन्‍दा छोबा बहर गिक साइबा मुला’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“चु ताम थेःसी थे बोमोसे दिम न्‍हङरी वाङ्बारी आम्‍हाइनी। थेतबासेलमा थेला आबा मङग्‍यार खसी थेदा व्‍हाम्‍बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","तर थेसे आबादा ‘च्‍यागो, ङाइ चुदे दिङधोना ह्राङला नोकरसे ह्रङ् लसी जम्‍मान गे लसी ह्राङसे कुल्‍बा जम्‍मान तामएनोन ङ्‌यान्‍जी। तसैनोन ङाला ह्रोगदेदेन छ्‌याम ढिक्‍सी चबा थुङ्बा लबारी ह्राङसे ङादा खाइमै रा गिकधोना पिन्‍जी? ");
INSERT INTO taj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","तर तिनी ह्राङला धन सम्‍पत्ति बेश्‍यागदेदेन छ्‌याम भ्रसी जिन्‍ना लबा झा दोःसी खमा चा थेला लागिरी छोबा बहर साइबा?’ भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","आबासे थेदा ‘झा, ए मी सदन ङादेन छ्‌याम मुनोन मुला। ओच्‍छे ङादेन छ्‌याम मुबा जम्‍मान धन सम्‍पत्ति एलान हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","तिनी य्‍हाङसे ताङ्सी भोज लतोःबा धिन हिन्‍ना। तिग्‍दा भिसम एला आले सिबा मुबा दान्‍दे सोबा मुला, म्‍हाबा मुबा दान्‍दे याङ्बा मुला’ भिसी भिजी।” ");
INSERT INTO taj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","येशूसे ह्राङला चेलागदेदा चुह्रङ् भिसी सुङ्जी, “ग्‍ला गिकरी फ्‍युक्‍पो म्‍हि गिकला गे लबा नाइके गिक मुबा। ‘नाइकेसे ह्राङला धन सम्‍पत्ति नाश लजी’ भिसी म्‍हिगदेसे थे फ्‍युक्‍पो म्‍हिदा पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","जमाहेन्‍से थे फ्‍युक्‍पो म्‍हिसे ह्राङला गे लबा नाइकेदा ङ्‌योइसी ‘म्‍हिगदेसे एला बिरोधरी पाङ्बा ताम तिग हिन्‍ना? दाहेन्‍से जम्‍मान हिसाब किताब ङादा घोना लउ। ओच्‍छे चु गे ख्‍लागो’ भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","थे नाइकेसे चुह्रङ् भिसी म्‍हन्‍जी, ‘दाहेन्‍से ङादा मालिकसे गेग्‍याम तेःबारी छ्‌याइबा मुला, ङा तिग लइ? ख्‍वबा मोइबा लइ भिसम भङ आरे, ह्रीसी चबारी ङादा पेःबा खमुला। ");
INSERT INTO taj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","दाहेन्‍से ङाइ तिग लतोःबा थे ङादा था मुला, ङादा मालिकसे गेग्‍याम तेःमाहेन्‍से म्‍हिगदेसे ङादा मान लला भिबा ताम ङाइ था याङ्सी जिन्‍बा मुला।’ ");
INSERT INTO taj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","जमाहेन्‍से थेसे ह्राङला मालिकला असामीगदेदा गिक गिक लसी ङ्‌योइजी। ओच्‍छे थेसे ङाच्‍छा खबा असामीदा ‘एदा ङाला मालिकला छे गाते मुला?’ भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","थे असामीसे ‘हजार सोम लिटर छ्‌युगु मुला’ भिसी भिमाहेन्‍से थे नाइकेसे ‘दाहेन्‍से एला तमसुकरी हजार गिकसे ग्‍यार्जा ङा लिटर जे भ्रिउ’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","थेह्रङ् लसी स्‍य्‍हान्‍दोदाएनोन ‘एदा ङाला मालिकला छे गाते मुला?’ भिसी ङ्‌योइमा, थे असामीसे ‘हजार गिक बोरा ग्‍वा मुला’ भिसी भिमाहेन्‍से थे नाइकेसे ‘एला तमसुकरी ग्‍यार्जा भ्रेः बोरा जे भ्रिउ’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“मालिकसे थे बेइमान नाइकेसे चलाक गे लबा म्राङ्सी थेला हर्गबढाइ लजी। तिग्‍दा भिसम चु जम्‍बुलिङला म्‍हिगदे ह्राङला ह्रो स्‍होबारी परमेश्‍वरदा ङोसेबा म्‍हिगदे भन्‍दा ल्‍हानान चलाक तमुला। ");
INSERT INTO taj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","थेतबासेलमा एनीगदेसे ङाला ताम ङ्‌यान्‍गो, एनीगदेसे ह्राङला लागिरी जम्‍बुलिङला धन सम्‍पत्तिसे ह्रो स्‍होउ। तिग्‍दा भिसम एनीगदेला धन सम्‍पत्ति जिन्‍सी निसैनोन थेनीगदेसे एनीगदेदा जुकजुकधोना चिबा ग्‍लारी मान लला। ");
INSERT INTO taj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","येशूसे दोःसी चुह्रङ् भिसी सुङ्जी, “खालैसे जजाबा तामरी विश्‍वासला गे लजी भिसम थेदा घ्रेन गेरीएनोन विश्‍वास लला। तर जजाबा तामरी विश्‍वासला गे आलनी भिसम थेदा घ्रेन गेरीएनोन विश्‍वास आल। ");
INSERT INTO taj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","थेतबासेलमा एनीगदेसे जम्‍बुलिङला धन सम्‍पत्तिरी विश्‍वासला गे आलनी भिसम खाल्‍से एनीगदेदा सत्‍यला धन सम्‍पत्ति जिम्‍मा पिन्‍ना? ");
INSERT INTO taj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","थेह्रङ् लसीन स्‍य्‍हान्‍दोला धन सम्‍पत्तिरी विश्‍वासला गे आलनी भिसम एनीगदेदा धन सम्‍पत्ति खाल्‍से पिन्‍ना? ");
INSERT INTO taj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“खजिबै नोकरसे मालिक न्‍हीला गे लबारी आखम। तिग्‍दा भिसम थेसे गिकदा हेला लला, स्‍य्‍हान्‍दोदा माया लला, अथवा गिकसे भिबा ताम ङ्‌यान्‍ना, स्‍य्‍हान्‍दोदा वास्‍तान आल। थेह्रङ् लसीन एनीगदेसेनोन परमेश्‍वरदेन धन सम्‍पत्ति न्‍हीलान गे लबारी आखम।” ");
INSERT INTO taj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","चु ताम थेःसी थेरी मुबा फरिसीगदेसे येशूदा खिसी लजी। तिग्‍दा भिसम थेनीगदे टाङगाला लिच्‍छा जे भ्रमुबा। ");
INSERT INTO taj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ओच्‍छे येशूसे थेनीगदेदा “म्‍हिगदेला ओन्‍छाङरी ह्राङसे ह्राङदान ङनी ज्‍यबा म्‍हि हिन्‍ना भिसी भ्रबा एनीगदेन हिन्‍ना। तर परमेश्‍वरदा एनीगदेला सेम खाह्रङ्बा मुला भिसी था मुला। तिग्‍दा भिसम म्‍हिगदेसे घ्रेन भिसी म्‍हन्‍बा तामगदे परमेश्‍वरला लागिरी ल्‍हानान नइबा खबा ताम हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“बप्‍तिस्‍मा पिन्‍बा यूहन्‍नाला धुइधोना मोशाला ठिमदेन अगमवक्तागदेसे भ्रिबा परमेश्‍वरला बचन थेःना लबा मुबा। थेनोन धुइहेन्‍से परमेश्‍वरला य्‍हुल्‍साला समाचार थेःना लबान मुला। ओच्‍छे जम्‍मान म्‍हिगदे भङ लसी परमेश्‍वरला य्‍हुल्‍सारी वाङ्बान मुला। ");
INSERT INTO taj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","मुदेन जम्‍बुलिङ नाश तसैनोन परमेश्‍वरसे मोशादा पिन्‍बा ठिमरी मुबा ताम गिकनोन आम्‍हा। ");
INSERT INTO taj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“खालै म्‍हिसे ह्राङला म्रिङदेन छ्‌याम छोडपत्र लसी स्‍य्‍हान्‍दो म्रिङम्‍हेमेदेन छ्‌याम ब्‍याह लजी भिसम थे चा ब्रेल्‍सी भ्रबा हिन्‍ना। थेह्रङ् लसी थेसे ख्‍लाबा म्रिङम्‍हेमेदा जुन म्‍हिसे ब्‍याह लला थेएनोन ब्रेल्‍सी भ्रबा हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","दोःसी येशूसे चुह्रङ् भिसी सुङ्जी, “ग्‍ला गिकरी फ्‍युक्‍पो म्‍हि गिक मुबा। थेसे मलमलला महँगो क्‍वान क्‍वान्‍सी धिन धिननोन मोजमजा लसी चिमुबा। ");
INSERT INTO taj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","तर थेला म्रापरी चा जिउ नाङ पोरनोन पोर मुबा लाजरस भिबा ह्रीबा म्‍हि गिकदा भसी थान्‍मुबा। ");
INSERT INTO taj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","थे फ्‍युक्‍पो म्‍हिसे चमा ताइबा भ्राइभ्रुइ चम्‍याङ्ला वा भिसी च्‍यासी चिमुबा। नगीगदे चा खसी थेला पोर ल्‍हेम्‍मुबा। ");
INSERT INTO taj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“तिरेकुनु थे प्राङबो म्‍हि सिजी। जमाहेन्‍से थेदा स्‍वर्गदूतगदेसे अब्राहामला ङामरी भोर्सी थान्‍जी। ओच्‍छे थे फ्‍युक्‍पो म्‍हिएनोन सिजी। ");
INSERT INTO taj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","थे फ्‍युक्‍पो म्‍हि नर्गरी ल्‍हानान दुख नासी चिबा धुइरी थेसे च्‍यामा थारेङग्‍याम अब्राहामला ङामरी लाजरसदा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ओच्‍छे थेसे क्रिङ्सी ‘आबा अब्राहाम, ङादा दया लसी लाजरसदा ङा मुबा ग्‍लारी पुइखउ। थेला या जुम्‍बी क्‍युइरी ब्‍लुम्‍सी ङाला लेरी थोपा गिक क्‍युइ ताइना लगै। तिग्‍दा भिसम ङा चुरी मेसे क्रोसी भोल्‍सी चिबा मुला’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“जमाहेन्‍से अब्राहामसे थेदा ‘झा, एसे तिग ढन्‍बा आरे? ए सोबा धुइरी ल्‍हानान सुख याङ्बा मुबा, तर लाजरससे चा ल्‍हानान दुख याङ्बा मुबा। दान्‍दे चा लाजरससे चुरी सुख शान्‍ति याङ्बा मुला, एसे चा दुख नासी चितोःबा मुला। ");
INSERT INTO taj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","एदेन छ्‌याम ङन्‍ना गुङरी घ्रेन व्‍हाङ मुला। थेतबासेलमा क्‍याम्‍सङ झासम लबा सेम मुसैनोन क्‍याम्‍सङ झासम लबारी आखम्‍मुला’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“जमाहेन्‍से थे फ्‍युक्‍पो म्‍हिसे ‘थेह्रङ् भिसम आबा अब्राहाम, ङाला बिन्‍ती मुला, लाजरसदा ङाला आबाला दिमरी पुइगो। ");
INSERT INTO taj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","तिग्‍दा भिसम थेरी ङाला आले ङा मुला। थेसे थेनीगदेदा ङा ह्रङ् लसी थाभ्रउ भिसी पाङ्‌गै, आहिन्‍सम थेनीगदेएनोन चु दुख नातोःबा ग्‍लारी खला’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“जमाहेन्‍से अब्राहामसे, ‘थेनीगदेदेन छ्‌याम मोशादेन अगमवक्तागदेसे भ्रिबा परमेश्‍वरला बचन मुनोन मुला, एला आलेगदेसे थे बचनरी भ्रिबा ताम ङ्‌यान्‍सम तनोन तला’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“ओच्‍छे थे फ्‍युक्‍पो म्‍हिसे ‘आहिन अब्राहाम आबा, थेनीगदेदा ओतेसे जे आत। सिबा म्‍हिगदे न्‍हङला खालै सोसी थेनीगदे मुबा ग्‍लारी निजी भिसम थेनीगदे ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःसेला मुबा’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“तर अब्राहामसे थेदा ‘मोशादेन अगमवक्तागदेला ताम आङ्‌यान्‍बागदेसे सिबा म्‍हि सोसी निसैनोन थेनीगदेसे विश्‍वास आल’ भिसी भिजी।” ");
INSERT INTO taj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","येशूसे ह्राङला चेलागदेदा चुह्रङ् भिसी सुङ्जी, “च्‍यागो, म्‍हिदा पापरी फसब लबा तामगदे मी खनोन खमुला। तर स्‍य्‍हान्‍दोदा पापरी फसब लबा म्‍हिसे चा परमेश्‍वरग्‍याम सजाय याङ्ला। ");
INSERT INTO taj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","जुन म्‍हिसे चु कोलागदेदा पाप लपुङ्ला थेह्रङ्बा म्‍हिदा पाप लपुङ्बा भन्‍दा खारेरी ह्रान्‍दा च्‍योसी समुन्‍द्ररी भ्‍याङ्‍बान ज्‍यबा तला। ");
INSERT INTO taj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","थेतबासेलमा ह्राङला लागिरी होशियार तसी चिउ! एला आलेसे पाप लजी भिसम थेदा बङ्‍‌गो। ओच्‍छे थेसे ङाइ लबा पाप ख्‍लाला भिजी भिसम थेदा माफ लउ। ");
INSERT INTO taj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","एला आलेसे एला बिरोधरी धिनना निसरेमधोना पाप लसैनोन निसरेमधोनान थेसे ङाइ लबा पाप ख्‍लाला भिजी भिसम थेदा माफ लउ।” ");
INSERT INTO taj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","जमाहेन्‍से प्रभुला मुल चेलागदेसे प्रभुदा “प्रभु, ङन्‍ना विश्‍वास ल्‍हेना लसी पिन्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","प्रभुसे थेनीगदेदा “एनीगदेदेन छ्‌याम पच्‍छैला ब्‍लु गिक तेःबा जे विश्‍वास मुजी भिसम चु किम्‍बुला दोङदा ‘ए प्‍योक्‍सी समुन्‍द्ररी निउ’ भिजी भिसम थे एनीगदेसे भिबा ह्रङ्नोन तला। ");
INSERT INTO taj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“एनीगदे न्‍हङरी खालैला नोकर बु मोइसी तसै ग्‍यु छसी तसै दिमरी खमा, एनीगदेसे थेदा ‘चबा थुङ्बा लउ’ भिसी खाइमै भिला? आभि। ");
INSERT INTO taj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","बरु एनीगदेसे थेदा ‘निउ, ङाला लागिरी चबा थुङ्बा तयार लउ, ङाइ चसी आजिन्‍तेधोना ङादा क्‍योङ्सी चिउ, ओच्‍छे ए चउ’ भिसी भिला। ");
INSERT INTO taj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ह्राङसे कुल्‍बा अन्‍छार गे लबा थे नोकरदा एसे खाइमै धन्‍यवाद पिन्‍ना? आपिन। ");
INSERT INTO taj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","थेह्रङ् लसीन एनीगदेदा कुल्‍बा जम्‍मान गे लसी जिन्‍माहेन्‍से ‘ङनी मी गे आखेल्‍बा नोकर हिन्‍ना। तिग्‍दा भिसम ङन्‍से लतोःबा गे जे लबा हिन्‍ना’ भिसी भिउ।” ");
INSERT INTO taj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","येशू यरूशलेम भिबा शहररी फेप्‍बा धुइरी सामरियादेन गालील अञ्‍चलग्‍याम तबान फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","येशू नाम्‍सा गिकरी वाङ्बारी छ्‌याइबा धुइरी कोरे खबा म्‍हि च्‍युइदा स्‍याप्‍जी। थे कोरे खबा म्‍हिगदे जजाकी क्‍याथाङनोन राप्‍सी, ");
INSERT INTO taj_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“येशू गुरु, ङन्‍दा दया लउ” भिसी क्रिङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","जमाहेन्‍से येशूसे थेनीगदेदा “एनीगदे परमेश्‍वरला मन्‍दिररी पूजा लबा म्‍हि मुबा ग्‍लारी निसी ह्राङदा उन्‍गो” भिसी सुङ्जी। ओच्‍छे थेनीगदे निना निनान ग्‍यामरीन खम्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","थेनीगदे न्‍हङला गिकसे ह्राङ खम्‍बा था याङ्सी परमेश्‍वरदा जयजयकार लबान दोःसी खजी। ");
INSERT INTO taj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ओच्‍छे थे म्‍हिसे येशूदा धन्‍यवाद पिन्‍सी येशूला स्‍य्‍हापरी फ्‍या लजी। थे म्‍हि चा सामरी य्‍हुलला मुबा। ");
INSERT INTO taj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","जमाहेन्‍से येशूसे “कोरेग्‍याम खम्‍बा म्‍हि च्‍युइ न्‍हङरी चु गिक जेन हिन्‍ना? स्‍य्‍हान्‍दो म्‍हि कु चा खानङ निजी? ");
INSERT INTO taj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","परमेश्‍वरदा धन्‍यवाद पिन्‍बारी चु सामरी बाहेक स्‍य्‍हान्‍दो खालै आतनी?” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","जमाहेन्‍से येशूसे थे सामरी य्‍हुलला म्‍हिदा “दाहेन्‍से ए रेःसी निउ, एला विश्‍वाससे लमा एला कोरे म्‍हाबा मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","फरिसीगदेसे परमेश्‍वरला य्‍हुल्‍सा खाइमा खला भिसी ङ्‌योइमा, येशूसे थेनीगदेदा “परमेश्‍वरला य्‍हुल्‍सा म्राङ्ना लसी आख। ");
INSERT INTO taj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","खालै म्‍हिसे परमेश्‍वरला य्‍हुल्‍सा चुरी मुला, थेरी मुला भिसी भिदेमा एनीगदेसे आम्राङ्। तिग्‍दा भिसम परमेश्‍वरला य्‍हुल्‍सा एनीगदेला गुङरीन मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","जमाहेन्‍से येशूसे ह्राङला चेलागदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदेसे तिरेकुनु परमेश्‍वरसे पुइखबा म्‍हिदा च्‍याबा सेम लला, तसैनोन एनीगदेसे आम्राङ्। ");
INSERT INTO taj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","म्‍हिगदेसे एनीगदेदा थे थेरी मुला, चुरी मुला भिसी भिला, जमा धुइरी एनीगदे थानिउ ओच्‍छे थेनीगदेला लिच्‍छा थाभ्रउ। ");
INSERT INTO taj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","तिग्‍दा भिसम परमेश्‍वरसे पुइखबा म्‍हि तिप्‍लीङ खबा धुइरी मुला कुनी गिकग्‍याम अर्गु कुनीधोना य्‍हाल तबा ह्रङ् तला। ");
INSERT INTO taj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","तर ङाच्‍छा थेसे ल्‍हानान दुखदेन म्‍हिगदेसे लबा बिरोध नातोःबा मुला। ");
INSERT INTO taj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“ओन्‍मा नोआला धुइरी तबा ह्रङ्नोन परमेश्‍वरसे पुइखबा म्‍हि दोःसी खबा धुइरीनोन तला। ");
INSERT INTO taj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","नोआ पानी जहाजरी वाङ्बा धिनकुनुधोना म्‍हिगदे चबा थुङ्बादेन ब्‍याह लबान मुबा। थेनोन धुइरी नामदेन भाल बाढी खसी जम्‍मान नाश लजी। ");
INSERT INTO taj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“थेह्रङ् लसीन लोतला धुइरीनोन कोइ म्‍हिगदे चबा थुङ्बा, कोइ म्‍हिगदे ग्‍लुबा चूङ्बा, कोइ सूबा ओच्‍छे कोइ म्‍हिगदे दिम स्‍होबान मुबा। ");
INSERT INTO taj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","लोत सदोमग्‍याम थोन्‍माकुनुन मुग्‍याम मेदेन बारूद ताइसी जम्‍मान नाश लजी। ");
INSERT INTO taj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“परमेश्‍वरसे पुइखबा म्‍हि खबा धुइरीनोन थेह्रङ्नोन तला। ");
INSERT INTO taj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","थे धुइरी तलाथोरी मुबा म्‍हिगदे ह्राङला सामान किन्‍बारी मार फाप्‍सी दिम न्‍हङरी थावाङ्‍गो, ओच्‍छे बुरी मुबागदेएनोन दिमरी दोःसी थानिउ। ");
INSERT INTO taj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","थेह्रङ् लसीन एनीगदेसे लोतला म्रिङदा तबा ताम ढन्‍गो। ");
INSERT INTO taj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","तिग्‍दा भिसम जुन म्‍हिसे ह्राङला ज्‍यान जोगब लबारी म्‍हाइला थे म्‍हिसे जुकजुकधोनाला जुनी आयाङ्। तर ङाला लागिरी ज्‍याननोन पिन्‍खम्‍बा म्‍हिसे जुकजुकधोनाला जुनी याङ्ला। ");
INSERT INTO taj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","थेतबासेलमा एनीगदेसे ङाला ताम ङ्‌यान्‍गो, म्‍हुनङ ग्‍ला गिकरीन म्‍हेर्सी चिबा म्‍हि न्‍ही न्‍हङरी गिकदा भोर्ला गिकदा थेरीन ख्‍लाला। ");
INSERT INTO taj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ओच्‍छे ह्रान्‍दारी ब्रा स्‍याङ्सी चिबा म्रिङम्‍हेमे न्‍ही न्‍हङरी गिकदा भोर्ला गिकदा थेरी ख्‍लाला। ");
INSERT INTO taj_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","थेह्रङ् लसीन बुरी मुबा म्‍हि न्‍ही न्‍हङरी गिकदा भोर्ला, गिकदा ख्‍लाला।” ");
INSERT INTO taj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","जमाहेन्‍से चेलागदेसे येशूदा “खानङ प्रभु?” भिसी ङ्‌योइमा, येशूसे थेनीगदेदा “जुन ग्‍लारी सिबा जन्‍तु मुला थेरी गिद्धागदे पोप तमुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","जमाहेन्‍से येशूसे ह्राङला चेलागदेदा “सदन प्रार्थना लसी चिगै ओच्‍छे खाइमै हरेस थाचगै” भिसी उखान गिक सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“शहर गिकरी न्‍यायाधीश गिक मुबा। थेसे परमेश्‍वरदेन म्‍हिगदेला वास्‍ता आलमुबा। ");
INSERT INTO taj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","थेनोन शहररी ह्रेम्‍बो सिबा म्रिङम्‍हेमे गिकएनोन मुबा। थे म्रिङम्‍हेमे घरिघरि थे न्‍यायाधीश मुबा ग्‍लारी निसी ‘ङादा ङाला बिरोधरी रेःबा म्‍हिग्‍याम ठीक निसाफ लसी पिन्‍गो’ भिसी भिमुबा। ");
INSERT INTO taj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“तिगै धिनधोना मी थेसे थे म्रिङम्‍हेमेला तामदा आङ्‌यान्‍नी। तर लिच्‍छा थेसे, ‘ङा परमेश्‍वरदेन म्‍हिगदेला वास्‍ता आलबा म्‍हि हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","तर चु ह्रेम्‍बो सिबा म्रिङम्‍हेमेसे ङादा ल्‍हानान दुख पिन्‍बासे लमा चुला ठीक निसाफ लसी पिन्‍तोःजी। आहिन्‍सम चु घरिघरि खसी ङादा छेर्ना लला’ भिसी सेमरी म्‍हन्‍जी।” ");
INSERT INTO taj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","जमाहेन्‍से प्रभुसे चुह्रङ् भिसी सुङ्जी, “च्‍यागो, थे आज्‍यबा न्‍यायाधीशसे तिग लबा चीम, एनीगदेसे था याङ्‍गो। ");
INSERT INTO taj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","थेह्रङ् लसीन परमेश्‍वरसे धिन म्‍हुननोन बिन्‍ती लबा ह्राङसे धम्‍बा ह्राङला म्‍हिला ठीक निसाफ आल? तिग ह्राङला म्‍हिदा ह्रो लबारी घइना लला? ");
INSERT INTO taj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","च्‍यागो, परमेश्‍वरसे ह्राङला म्‍हिला ठीक निसाफ लबारी खाइमै घइना आल। तसैनोन परमेश्‍वरसे पुइखबा म्‍हि खमा तिग चु जम्‍बुलिङरी ङादा विश्‍वास लबागदे स्‍याप्‍ला?” ");
INSERT INTO taj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ह्राङसे ह्राङदान ङा ज्‍यबा म्‍हि हिन्‍ना भिसी ढुक्‍क तसी स्‍य्‍हान्‍दोदा चा हेला लबा म्‍हिगदेदा येशूसे चुह्रङ् भिसी उखान गिक सुङ्जी, ");
INSERT INTO taj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“फरिसीदेन तिरो दुइबा म्‍हि प्रार्थना लबारी परमेश्‍वरला मन्‍दिररी निजी। ");
INSERT INTO taj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ओच्‍छे फरिसीसे चुह्रङ् भिसी प्रार्थना लजी, ‘परमेश्‍वर ह्राङदा धन्‍यवाद मुला, तिग्‍दा भिसम ङा स्‍य्‍हान्‍दो म्‍हिगदे ह्रङ्‌बा लोभी, बेइमानी, स्‍य्‍हान्‍दोदेन छ्‌याम ब्रेल्‍सी भ्रबा म्‍हि ह्रङ्‌बा आहिन। ओच्‍छे चु तिरो दुइबा म्‍हि ह्रङ्बाएनोन आहिन। ");
INSERT INTO taj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ङाइ सातारी न्‍हीरेम फोइथान चिसी प्रार्थना लबा मुला। ओच्‍छे ङाइ याङ्बा जम्‍मान स्‍हेला भो च्‍युइला भो गिक ह्राङदा पिन्‍बा मुला।’ ");
INSERT INTO taj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“तर तिरो दुइबा म्‍हि चा थारेङनोन राप्‍सी स्‍वर्गपट्टि आच्‍याना ह्राङला कु ठोक्‍बान, ‘परमेश्‍वर, ङा पापीदा दया लउ’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","थेतबासेलमा एनीगदेसे ङाला ताम ङ्‌यान्‍गो, चु तिरो दुइबा म्‍हि चा स्‍य्‍हान्‍दो म्‍हि भन्‍दा परमेश्‍वरदा सेम निबा म्‍हि दोसी ह्राङला दिमरी निजी। तिग्‍दा भिसम जुन म्‍हिसे ह्राङसे ह्राङदान घ्रेन स्‍होला थे म्‍हि जजा तला। तर जुन म्‍हिसे ह्राङसे ह्राङदान जजा स्‍होला थे म्‍हि घ्रेन तला।” ");
INSERT INTO taj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","म्‍हिगदेसे ह्राङला कोलागदेदा येशूसे ह्राङला छ्‌या थान्‍सी मोलम पिन्‍गै भिसी येशू मुबा ग्‍लारी भजी। चु म्राङ्सी चेलागदेसे थेनीगदेदा बङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","तर येशूसे थेनीगदेदा ङ्‌योइसी चुह्रङ् भिसी सुङ्जी, “कोलागदेदा ङा मुबा ग्‍लारी खपुङ्‍गो, थेनीगदेला ग्‍याम थाकागो। तिग्‍दा भिसम परमेश्‍वरला य्‍हुल्‍सा चु कोलागदे ह्रङ्बालान हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","एनीगदेसे ङाला ताम ङ्‌यान्‍गो, जुन म्‍हिसे चु कोलागदेसे ह्रङ् लसी परमेश्‍वरला य्‍हुल्‍सादा विश्‍वास आल, थे म्‍हि परमेश्‍वरला य्‍हुल्‍सारी खाइमै वाङ्‌आम्‍याङ्।” ");
INSERT INTO taj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","यहूदी नेता गिकसे येशूदा “ज्‍यबा गुरु, जुकजुकधोनाला जुनी याङ्बाला लागिरी ङाइ तिग लतोःला?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","येशूसे थेदा चुह्रङ् भिसी सुङ्जी, “एसे ङादा तिग्‍दा ज्‍यबा भिबा? परमेश्‍वर बाहेक खालै ज्‍यबा आरे। ");
INSERT INTO taj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","परमेश्‍वरसे कुल्‍बा ताम एदा थानोन मुला। म्‍हि थासाइगो, स्‍य्‍हान्‍दोदेन छ्‌याम ब्रेल्‍सी थाभ्रउ, य्‍हो थालउ, लुसीला ताम पाङ्सी थाभ्रउ ओच्‍छे ह्राङला आबा आमादा मान लउ।” ");
INSERT INTO taj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","जमाहेन्‍से थेसे, “चु जम्‍मान ताम मी ङाइ जत्‍धुगुहेन्‍सेन लसीन चिबा मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","चु ताम थेःमाहेन्‍से येशूसे थेदा “अझ एसे गे गिक लतोःबा मुला, दाहेन्‍से एसे ह्राङदेन छ्‌याम मुबा जम्‍मान धन सम्‍पत्ति चूङ्सी प्राङबोगदेदा भो लसी पिन्‍गो। एसे स्‍वर्गरी धन सम्‍पत्ति याङ्ला, ओच्‍छे ङादेन छ्‌याम भ्रउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","तर चु ताम थेःसी थे म्‍हिदा ल्‍हानान दुख ङ्‌हम्‍जी। तिग्‍दा भिसम थे ल्‍हानान फ्‍युक्‍पो मुबा। ");
INSERT INTO taj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","थे म्‍हिला सेमरी ल्‍हानान दुख तबा था याङ्सी येशूसे चुह्रङ् भिसी सुङ्जी, “थेदा च्‍यासी फ्‍युक्‍पो म्‍हिदा परमेश्‍वरला य्‍हुल्‍सारी वाङ्बारी गाते गाह्रो मुला। ");
INSERT INTO taj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","तिग्‍दा भिसम फ्‍युक्‍पो म्‍हिदा परमेश्‍वरला य्‍हुल्‍सारी वाङ्बारी भन्‍दा ऊँटदा दापला मीग्‍याम वाङ्बारी सजिलो मुला।” ");
INSERT INTO taj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","चु ताम थेःबागदेसे येशूदा “थेह्रङ् भिसम खाल्‍से थार्बा याङ्ला?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","जमाहेन्‍से येशूसे थेनीगदेदा “चु गे म्‍हिसे लबारीन आखम्‍बा गे तसैनोन परमेश्‍वरसे लखम्‍ला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ओच्‍छे पत्रुससे, “स्‍हीगो प्रभु, ङन्‍से ह्राङला दिमनामनोन ख्‍लासी ह्राङदेन छ्‌याम भ्रबा मुला” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","येशूसे थेनीगदेदा “एनीगदेसे ङाला ताम ङ्‌यान्‍गो, जुन म्‍हिसे ह्राङला दिम, म्रिङ, ज्‍योज्‍यो आले, आबा आमा, ओच्‍छे झा झामेदा परमेश्‍वरला य्‍हुल्‍साला लागिरी ख्‍लाला, ");
INSERT INTO taj_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","थेसे दान्‍देन थे भन्‍दा ल्‍हाना याङ्ला, ओच्‍छे लिच्‍छा खबा धुइरी थेसे जुकजुकधोनाला जुनी याङ्ला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","येशूसे ह्राङला च्‍युक न्‍ही चेलागदेदा कुनी गिकरी भोर्सी चुह्रङ् भिसी सुङ्जी, “च्‍यागो, य्‍हाङ यरूशलेमरी निबान मुला। दाहेन्‍से परमेश्‍वरसे पुइखबा म्‍हिला बारेरी अगमवक्तागदेसे भ्रिबा ताम पूरा तला। ");
INSERT INTO taj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","थेदा अर्गु य्‍हुलला म्‍हिगदेला यारी जिम्‍मा पिन्‍ना। जमाहेन्‍से थे म्‍हिगदेसे थेदा खिसी लला ओच्‍छे थो स्‍वाबान बेइज्‍जत लला, ");
INSERT INTO taj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","जमाहेन्‍से कोर्रासे तोला ओच्‍छे साइला। तसैनोन थे सोमरेमाकुनु सिबाग्‍याम सोला।” ");
INSERT INTO taj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","तर चेलागदेसे चु ताम तिगै आघोनी। तिग्‍दा भिसम चु ताम म्‍हिला ज्ञान बुद्धिसे घोसी घोआखम्‍बा तबासे लमा येशूसे तिग सुङ्बा हिन्‍ना भिसी थेनीगदेसे म्‍हन्‍बारीएनोन आखम्‍नी। ");
INSERT INTO taj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","येशू यरीहो शहरला ङामरी धोमा थेरी मी आम्राङ्बा म्‍हि गिक ग्‍यामला कुनीरी ह्रीसी चिमुबा। ");
INSERT INTO taj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","थे मी आम्राङ्बा म्‍हिसे ह्राङला ङामग्‍याम म्‍हिला हुल निबान लबा थेःसी, “चुरी तिग तजी?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","म्‍हिगदेसे थेदा “नासरतला येशू चुग्‍यामसेन फेप्‍बान मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","जमाहेन्‍से थेसे क्रिङ्बान, “दाऊद ग्‍लेला सन्‍तान येशू, ङादा दया लउ” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ङाच्‍छा भ्रबागदेसे थेदा कुटिसी चिउ भिसी बङ्जी। तर थेसे झन क्रिङ्बान, “दाऊद ग्‍लेला सन्‍तान येशू, ङादा दया लउ” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","थेसे चुह्रङ् भिबा थेःसी येशू थेन तसी थेदा ह्राङ मुबा ग्‍लारी भपुङ्जी। ओच्‍छे थे ङामरी खमाहेन्‍से, ");
INSERT INTO taj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“ङाइ एला लागिरी तिग लउ भिसी म्‍हन्‍बा मुला?” भिसी ङ्‌योइजी। जमाहेन्‍से थेसे “प्रभु, ङाला मी म्राङ्ना लसी पिन्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","येशूसे थेदा “लु, एसे म्राङ्‍गै, एसे विश्‍वास लबासे लमा एसे म्राङ्बा मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","येशूसे चुह्रङ् सुङ्मैछ्‌याम थेसे म्राङ्जी। ओच्‍छे थेसे परमेश्‍वरदा जयजयकार लबान येशूदेन छ्‌याम भ्रजी। चु म्राङ्बा म्‍हिगदेसेनोन परमेश्‍वरदा जयजयकार लजी। ");
INSERT INTO taj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","येशू यरीहो शहरग्‍याम फेप्‍बान मुबा। ");
INSERT INTO taj_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","थेरी जखायस भिबा फ्‍युक्‍पो म्‍हि गिक मुबा। थे तिरो दुइबा म्‍हिगदे न्‍हङला मुल म्‍हि मुबा। ");
INSERT INTO taj_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","थेसे येशूदा खाल चीम भिसी च्‍याबारी म्‍हाइजी। तर म्‍हिला हुलसे लमा थेसे येशूदा आम्राङ्‌नी। तिग्‍दा भिसम थे मेबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","थेतबासेलमा येशूदा च्‍याबारी थे ङाच्‍छा ङाच्‍छा यार्बान निसी अञ्‍जीरला दोङरी क्रेःजी। तिग्‍दा भिसम येशू थेग्‍यामसेन फेप्‍बारी छ्‌याइबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","थेरी धोखमाहेन्‍से येशूसे तोरपट्टि स्‍हीसी जखायसदा “जखायस, ए योना मार फाप्‍सी खउ! तिग्‍दा भिसम तिनी ङा एला दिमरी चितोःबा मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","जमाहेन्‍से जखायस ताङ्सी मार फाप्‍सी येशूदा फ्‍याफुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","चु म्राङ्माहेन्‍से म्‍हिगदेसे “चु म्‍हि मी पापीला दिमरी डोन्‍बो दोसी निजी” भिसी येशूला तामगन लजी। ");
INSERT INTO taj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","तर जखायससे “प्रभु, दाहेन्‍से ङाइ ङाला गङसल धन सम्‍पत्ति प्राङबोगदेदा भो लसी पिन्‍ना, ओच्‍छे ङाइ खालैदा ठगब लसी किन्‍बा मुसम थेदा भो ब्‍लि ल्‍हाना दोःसी पिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","जमाहेन्‍से येशूसे थेदा “तिनीहेन्‍से चु दिमसे थार्बा याङ्बा मुला। तिग्‍दा भिसम जखायसएनोन अब्राहामला सन्‍तान हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","परमेश्‍वरसे पुइखबा म्‍हि म्‍हाबागदेदा म्‍हाइबारीदेन थार्बा पिन्‍बारी खबा हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","येशू यरूशलेमला ङामरी धोमुबा। म्‍हिगदेसे दाहेन्‍से परमेश्‍वरला य्‍हुल्‍सा योनान खबान मुला भिसी म्‍हन्‍सी येशूला ताम ङ्‌यान्‍सी चिमुबा। थेतबासेलमा येशूसे थेनीगदेदा चुह्रङ् भिसी उखान गिक सुङ्जी, ");
INSERT INTO taj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“खालै घ्रेन म्‍हि गिक ह्राङला ग्‍लारी शासन लबा सेम लसी थे य्‍हुल्‍साला ग्‍ले मुबा ग्‍लारी निजी। ");
INSERT INTO taj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","निबा भन्‍दा ङाच्‍छा थेसे ह्राङला नोकर च्‍युइदा ङ्‌योइजी। ओच्‍छे जम्‍मादान म्‍हरला डबल गिक गिक पिन्‍सी ‘ङा आखतेधोना चु टाङगासे व्‍यापार लउ’ भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","तर थेला य्‍हुल्‍साला म्‍हिगदेसे चा थेदा सेम आनिमुबा। थेतबासेलमा थे निसी जिन्‍माहेन्‍से ‘चु म्‍हिसे शासन लगै भिबा ङन्‍ना सेम आरे’ भिसी ग्‍ले ब्‍लोनदा पुइजी। ");
INSERT INTO taj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“तर थे म्‍हि शासन लबा अधिकार किन्‍सी खजी। जमाहेन्‍से थेसे ह्राङला नोकरगदेदा व्‍यापार लसी गाते स्‍होजी भिसी ङ्‌योइबारी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ओच्‍छे ङाच्‍छा खबा नोकरसे ‘मालिक, ह्राङसे पिन्‍बा डबल गिकसे ङाइ डबल च्‍युइ स्‍होजी’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","जमाहेन्‍से थे म्‍हिसे थेदा ‘स्‍याबास! ए ङाला ज्‍यबा नोकर हिन्‍ना! तिग्‍दा भिसम एसे ङादा जजा तामरी विश्‍वास उन्‍जी। थेतबासेलमा ङाइ एदा शहर च्‍युइरी शासन लबा अधिकार पिन्‍ना’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ओच्‍छे स्‍य्‍हान्‍दो नोकरसे ‘मालिक, ह्राङसे पिन्‍बा डबल गिकसे ङाइ डबल ङा स्‍होजी’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","जमाहेन्‍से थेदाएनोन थे म्‍हिसे ‘ए शहर ङाला मुल म्‍हि तला’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ओच्‍छे स्‍य्‍हान्‍दो नोकरएनोन खसी ‘मालिक, ङाइ ह्राङला म्‍हरला डबल रूमालरी झोर्सी थान्‍बा मुला, थे चुरी मुला। ");
INSERT INTO taj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ह्राङ खरो म्‍हि भिसी ङादा था मुबासे लमा ङादा लोङ्‌बा खजी, ह्राङसे व्‍यापार आलबा ग्‍लारी नाफा म्‍हाइमुला, ओच्‍छे तिगै आढ्‍वबा ग्‍लारी बाली दुइबारी म्‍हाइमुला’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","थे शासन लबा म्‍हिसे थेदा ‘गे आखेल्‍बा नोकर! एला तामग्‍यामसेन ङाइ ए गे आखेल्‍बा चीम भिसी निसाफ लला। ङाइ व्‍यापार आलबा ग्‍लारी नाफा म्‍हाइमुला ओच्‍छे तिगै आढ्‍वबा ग्‍लारी बाली दुइबारी म्‍हाइबा खरो म्‍हि भिसी एदा थानोन चीम। ");
INSERT INTO taj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","थेह्रङ् भिसम एसे तिग ङाइ पिन्‍बा डबल बैंकरी आथान्‍नी? एसे बैंकरी थान्‍बा हिन्‍सम ङाइ दोःसी ब्‍याजदेन थे डबल किन्‍म्‍याङ्सेला’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ओच्‍छे थेसे थेरी राप्‍सी चिबागदेदा ‘दाहेन्‍से थेग्‍याम थे म्‍हरला डबल ब्‍यन्‍सी गोर च्‍युइ डबल मुबादा पिन्‍गो’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","जमाहेन्‍से थेनीगदेसे ‘मालिक, थेदेन छ्‌याम मी ङाच्‍छालान गोर च्‍युइ डबल मुला’ भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","थे शासन लबा म्‍हिसे थेनीगदेदा ‘एनीगदेसे ङाला ताम ङ्‌यान्‍गो, तिग्‍दा भिसम जुन म्‍हिदेन छ्‌याम मुला थेदा अर्गुएनोन पिन्‍ना। तर जुन म्‍हिदेन छ्‌याम आरे थेदेन छ्‌याम मुबा जजाकीएनोन थेग्‍याम ब्‍यन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","थेतबासेलमा ङाइ शासन थालगै भिसी म्‍हन्‍बा ङाला शत्रुगदेदा चुरी भसी ङाला ङाच्‍छापट्टि साइगो’ भिसी कुल्‍जी।” ");
INSERT INTO taj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","चुह्रङ् सुङ्सी जिन्‍माहेन्‍से येशू थेनीगदेला ङाच्‍छा ङाच्‍छा यरूशलेमपट्टि फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ओच्‍छे बेथफागेदेन बेथानिया नाम्‍साला ङामला जैतून भिबा गङरी धोखमाहेन्‍से येशूसे ह्राङला चेलागदे न्‍हङला न्‍हीदा पुइजी। ");
INSERT INTO taj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","पुइबा धुइरी चुह्रङ् भिसी सुङ्जी, “एनी जजाकी क्‍याथाङला नाम्‍सारी निउ। नाम्‍सारी धोमाहेन्‍से एनीगदेसे दान्‍देधोना खालै आक्रेःबा गधाला कोला गिक स्‍याप्‍ला। थेदा ब्‍लसी चुरी भसी खउ। ");
INSERT INTO taj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ब्‍लबारी छ्‌याइमा खालैसे एनीदा ‘चुदा तिग्‍दा ब्‍लबा’ भिसी ङ्‌योइजी भिसम, ‘चु प्रभुदा तोःबा मुला’ भिसी भिउ।” ");
INSERT INTO taj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","जमाहेन्‍से थे चेला न्‍ही नाम्‍सारी निजी। ओच्‍छे थेरी थेनीसे येशूसे सुङ्बा ह्रङ्नोन गधाला कोला स्‍याप्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","थेनीसे थे गधाला कोलादा ब्‍लबारी छ्‌याइमा थे गधाला धनीसे “एनीसे चु गधाला कोलादा तिग्‍दा ब्‍लबा?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ओच्‍छे चेला न्‍हीसे “चु प्रभुदा तोःबा मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","जमाहेन्‍से थे चेला न्‍हीसे गधाला कोलादा येशू मुबा ग्‍लारी भसी ह्राङला घ तीसी येशूदा थेथोरी धन्‍छ्‌यापुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","येशू फेप्‍बारी छ्‌याइबा धुइरी म्‍हिगदेसेनोन ग्‍यामरी ह्राङ ह्राङला घगदे ती‍जी। ");
INSERT INTO taj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","येशू यरूशलेम ङामला जैतून भिबा गङला ग्‍युरोरी धोखमा येशूदेन छ्‌याम भ्रबा चेलागदेसे येशूसे लबा उदेकला गेगदे ढन्‍सी ताङ्बान क्रिङ्सी चुह्रङ् भिसी परमेश्‍वरदा धन्‍यवाद पिन्‍बारी छ्‌याइजी, ");
INSERT INTO taj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“परमप्रभुला मिनरी फेप्‍खबा ग्‍लेसे परमेश्‍वरग्‍याम मोलम याङ्‌गै, स्‍वर्गरी शान्‍ति तगै। ओच्‍छे स्‍वर्गरी धन्‍छ्‌याबा परमेश्‍वरदा मानदेन जयजयकार तगै। ");
INSERT INTO taj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","म्‍हिला हुल न्‍हङ‍ग्‍याम फरिसीगदेसे येशूदा “गुरु, ह्राङला चेलागदेदा कुटिसी चिउ भिसी बङ्‍‌गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","तर येशूसे थेनीगदेदा “ङाला ताम ङ्‌यान्‍गो, चुगदे कुटिसी चिजी भिसम युङबागदेन क्रिङ्बारी छ्‌याइला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","यरूशलेम ङामरी धोमा येशूसे शहरदा ह्राङला ङाच्‍छापट्टि म्राङ्सी क्राबान चुह्रङ् भिसी सुङ्जी, ");
INSERT INTO taj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“यरूशलेमला म्‍हिगदे, तिनी शान्‍तिला लागिरी तिग तोःला भिसी था याङ्बा हिन्‍सम तसेला, तर एनीगदेसे था आयाङ्नी! ");
INSERT INTO taj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","थेतबासेलमा दाहेन्‍से एनीगदेला शत्रुगदे ढिक्‍सी क्‍युर्सीन खसी एनीगदेदा गुङरी झाङ्‌ला। ");
INSERT INTO taj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ओच्‍छे थेनीगदेसे एनीगदेला शहरला पर्खाल फुप्‍सी एनीगदेला शहरदा नाश लला। जमाहेन्‍से एनीगदेला कोलागदेदा साइला। तिग्‍दा भिसम परमेश्‍वरसे एनीगदेदा थार्ना लबा धुइदा एनीगदेसे ङोआसेनी।” ");
INSERT INTO taj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","जमाहेन्‍से येशू परमेश्‍वरला मन्‍दिररी फेप्‍जी। ओच्‍छे परमेश्‍वरला मन्‍दिर न्‍हङरी चूङ्बागदेदा चुह्रङ् भिसी सुङ्बान ताप्‍जी, ");
INSERT INTO taj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“च्‍यागो, परमेश्‍वरला बचनरी ‘ङाला दिम प्रार्थना लबा दिम तला’ भिसी भ्रिबा मुला। तर एनीगदेसे मी य्‍होगदे चिबा ग्‍ला स्‍होबा मुला।” ");
INSERT INTO taj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","जमाहेन्‍से धिन धिननोन येशूसे परमेश्‍वरला मन्‍दिररी लोप्‍बारी छ्‌याइजी। थे धुइरी परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी धर्मगुरुगदे ओच्‍छे थे य्‍हुल्‍साला नेतागदे ढिक्‍सी येशूदा साइबारी म्‍हाइमुबा। ");
INSERT INTO taj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","तर थेनीगदेसे तिगै निउ आयाङ्नी। तिग्‍दा भिसम जम्‍मान म्‍हिगदेसे सेम लसी येशूला ताम ङ्‌यान्‍मुबा। ");
INSERT INTO taj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","तिरेकुनु येशू परमेश्‍वरला मन्‍दिररी लोप्‍बान मुबा ओच्‍छे परमेश्‍वरला य्‍हुल्‍साला समाचार थेःना लबान मुबा। थेनोन धुइरी परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी गन्‍बागदे ओच्‍छे यहूदी धर्मगुरुगदे येशू मुबा ग्‍लारी खजी। ");
INSERT INTO taj_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ओच्‍छे थेनीगदेसे येशूदा “ह्राङसे खानङग्‍याम अधिकार याङ्सी चु गे लबा हिन्‍ना? ह्राङदा चु अधिकार खाल्‍से पिन्‍बा हिन्‍ना?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","येशूसे थेनीगदेदा “ङाइएनोन एनीगदेदा ताम गिक ङ्‌योइला, थे ताम ङादा पाङ्‍गो। ");
INSERT INTO taj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","यूहन्‍नासे पिन्‍बा बप्‍तिस्‍मा परमेश्‍वरग्‍याम हिन्‍ना कि म्‍हिग्‍याम हिन्‍ना?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","जमाहेन्‍से थेनीगदे ह्राङ ह्राङ न्‍हङरी ताम लबारी छ्‌याइजी, “परमेश्‍वरग्‍याम भिजी भिसम थेसे य्‍हाङदा ‘थेह्रङ् भिसम एनीगदेसे तिग्‍दा यूहन्‍नादा विश्‍वास आलबा?’ भिसी भिला। ");
INSERT INTO taj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","तर म्‍हिगदेग्‍याम भिजी भिसम म्‍हिगदेसे य्‍हाङदा बिरोध लला। तिग्‍दा भिसम थेनीगदेसे यूहन्‍नादा अगमवक्ता भिसी विश्‍वास लबा मुबा।” ");
INSERT INTO taj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","थेतबासेलमा थेनीगदेसे येशूदा “खाइ, थेसे चु अधिकार खानङग्‍याम याङ्जी ङन्‍दा था आरे” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","येशूसे थेनीगदेदा “थेह्रङ् भिसम ङाइएनोन चु गेगदे खाल्‍ला अधिकारग्‍याम लबा हिन्‍ना, थे एनीगदेदा आपाङ्” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","जमाहेन्‍से येशूसे म्‍हिगदेदा उखान गिक सुङ्जी, “म्‍हि गिकसे वारीरी अङगुर सूसी अधियाँरी पिन्‍सी थे ल्‍हानान धिनना लागिरी अर्गु य्‍हुल्‍सारी निजी। ");
INSERT INTO taj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","अङगुर मिन्‍बा धुइ तमाहेन्‍से थे फ्‍युक्‍पो म्‍हिसे ह्राङला भो किन्‍बाला लागिरी अधियाँ लबागदे मुबा ग्‍लारी ह्राङला नोकरगदेदा पुइजी। तर थे अधियाँ लबागदेसे थेदा तोबा ग्‍याङ्‍बा लसी तिगै आपिन्‍ना पुइजी। ");
INSERT INTO taj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","थे वारीला धनीसे स्‍य्‍हान्‍दो नोकर गिकदा पुइजी। थेदाएनोन थे अधियाँ लबागदेसे तोसी बेइज्‍जत लसी थान्‍थान पुइखजी। ");
INSERT INTO taj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","थेह्रङ् लसीन थेसे दोःसी स्‍य्‍हान्‍दो नोकरदाएनोन पुइजी थेदाएनोन थे अधियाँ लबागदेसे सिबाधोनान तोसी तेःजी। ");
INSERT INTO taj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“जमाहेन्‍से थे वारीला धनीसे ‘दाहेन्‍से ङाइ तिग लसे? ङाइ माया लबा ङाला झादान पुइतोःजी। ङाला झादा मी थेनीगदेसे मान लला वा?’ भिसी पुइजी। ");
INSERT INTO taj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","तर थेदा म्राङ्सी अधियाँ लबागदेसे ‘चु मी य्‍हाङला धनीला झा हिन्‍ना, य्‍हाङसे थेदा साइगे। जमाहेन्‍से थेला सम्‍पत्ति य्‍हाङलान तला’ भिसी ह्राङ ह्राङ न्‍हङरी ताम लजी। ");
INSERT INTO taj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","जमाहेन्‍से थेनीगदेसे थेदा अङगुर वारीग्‍याम मङग्‍यार भोर्सी साइजी।” चुह्रङ् सुङ्सी जिन्‍माहेन्‍से येशूसे थेनीगदेदा “दाहेन्‍से थे वारीला धनीसे थेनीगदेदा तिग लला तला? ");
INSERT INTO taj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","थे खसी अधियाँ लबा म्‍हिगदेदा साइला ओच्‍छे थे अङगुरला वारी स्‍य्‍हान्‍दोगदेदा स्‍होबारी पिन्‍ना।” भिसी सुङ्जी। चु थेःसी म्‍हिगदेसे “चुह्रङ्बाम खाइमै थातगै” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ओच्‍छे येशूसे थेनीगदेला लीरी स्‍हीसी चुह्रङ् भिसी सुङ्जी, “थेह्रङ् भिसम परमेश्‍वरला बचनरी ‘जुन युङबादा दिम स्‍होबा कर्मीगदेसे गे आखेल भिसी भ्‍याङ्‍बा मुबा थेनोन युङबा दिमला सुर युङबा दोजी’ भिसी भ्रिबा चु तामला अर्थ तिग हिन्‍ना? ");
INSERT INTO taj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","थे युङबाथोरी ताइबागदे जम्‍मान छारछिर निला, ओच्‍छे थे युङबा खालैथोरी ताइजी भिसम थेरी मुबा म्‍हि फ्‍लातफ्‍लेत निला।” ");
INSERT INTO taj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","जमाहेन्‍से यहूदी धर्मगुरुगदेदेन परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेसे थे धुइरी येशूदा चुङ्बारी म्‍हाइजी। तिग्‍दा भिसम चु उखान येशूसे थेनीगदेलान बिरोधरी सुङ्बा हिन्‍ना भिबा ताम थेनीगदेदा था मुबा। तर थेनीगदे म्‍हिगदे म्राङ्सी लोङ्मुबा। ");
INSERT INTO taj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","थेतबासेलमा थेनीगदेसे येशूदा चुङ्बारी दाउ च्‍याजी। थेनीगदेसे येशूदा तामग्‍याम फसब लसी रोमी अञ्‍चलाधीशला यारी जिम्‍मा पिन्‍बारी म्‍हाइमुबा। थेतबासेलमा ह्राङसे ह्राङदान ङा ज्‍यबा म्‍हि हिन्‍ना भिसी भ्रबा म्‍हिगदेदा थेनीगदेसे येशू मुबा ग्‍लारी पुइजी। ");
INSERT INTO taj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","थे म्‍हिगदे येशू मुबा ग्‍लारी निसी, “गुरु, ह्राङसे लोप्‍बा ताम ठीक हिन्‍ना। ह्राङसे खालैला ली स्‍हीसी गे आलमुला, ओच्‍छे ह्राङसे परमेश्‍वरला सत्‍य ग्‍याम उन्‍मुला भिसी ङन्‍दा था मुला। ");
INSERT INTO taj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","थेतबासेलमा ङन्‍से रोमी ग्‍याल्‍बो कैसरदा तिरो फाबा य्‍हाङला ठिम अन्‍छार ठीक हिन्‍ना कि आहिन?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","तर येशूसे थेनीगदेला पापी सेम था याङ्सी येशूसे थेनीगदेदा “ङादा डबल गिक भउ। चु डबलरी मुबा छापदेन मिन खाल्‍ला हिन्‍ना?” भिसी सुङ्मा, थेनीगदेसे “रोमी ग्‍याल्‍बो कैसरला” भिसी जोहाब पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","जमाहेन्‍से येशूसे थेनीगदेदा “थेह्रङ् भिसम रोमी ग्‍याल्‍बो कैसरला जति कैसरदा पिन्‍गो, परमेश्‍वरला जति परमेश्‍वरदा पिन्‍गो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","थेनीगदेसे म्‍हिला ओन्‍छाङरी येशूदा खजिबै तामग्‍याम फसब लसी चुङ्बारी आखम्‍नी। ओच्‍छे येशूसे सुङ्बा तामरी थेनीगदे उदेक म्‍हन्‍सी कुटिसी चिजी। ");
INSERT INTO taj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","जमाहेन्‍से सिबाग्‍याम दोःसी आसो भिसी विश्‍वास लबा कोइ कोइ सदुकीगदे येशू मुबा ग्‍लारी खजी। ");
INSERT INTO taj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ओच्‍छे थेनीगदेसे येशूदा चुह्रङ् भिसी ङ्‌योइजी, “गुरु, मोशासे य्‍हाङदा पिन्‍बा ठिम अन्‍छार खालैला ज्‍योज्‍योसे ब्‍याह लसी कोलागदे आतनान सिजी भिसम ज्‍योज्‍यो‍ला लागिरी कोलागदे तगै भिसी आलेसे चाङदा ब्‍याह लतोःला भिसी भ्रिबा मुला। ");
INSERT INTO taj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ग्‍ला गिकरी ज्‍योज्‍यो आले निस मुबा। थेबासे ब्‍याह लजी, तर कोलागदे आतनान थे सिजी। ");
INSERT INTO taj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","थेह्रङ् लसीन पाराङसे चाङदा ब्‍याह लजी, थेएनोन कोलागदे आतनान सिजी। ");
INSERT INTO taj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","जमाहेन्‍से साँजीसे चाङदा ब्‍याह लजी, थेएनोन कोलागदे आतनान सिजी। थेह्रङ् लसी जम्‍मासेन पालोन पालो चाङदा ब्‍याह लजी। तर जम्‍मान कोलागदे आतनान सिजी। ");
INSERT INTO taj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ओच्‍छे थे म्रिङम्‍हेमेएनोन सिजी। ");
INSERT INTO taj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","थेतबासेलमा ङन्‍दा सुङ्‍गो, सिबाग्‍याम सोना लजी भिसम थे म्रिङम्‍हेमे खजिबाला म्रिङ तला? तिग्‍दा भिसम थेनीगदे जम्‍मासेन थे म्रिङम्‍हेमेदेन छ्‌याम ब्‍याह लबा मुला।” ");
INSERT INTO taj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","जमाहेन्‍से येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “दान्‍देला म्‍हिगदेसे ब्‍याह लला, ओच्‍छे ब्‍याहएनोन लसी पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","तर स्‍वर्गरी निम्‍याङ्सेला म्‍हिगदे सिबाग्‍याम सोना लबा धुइरी ब्‍याह लसी आपिन ब्‍याहएनोन आल। ");
INSERT INTO taj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ओच्‍छे थेनीगदे खाइमै आसि तिग्‍दा भिसम थेनीगदे स्‍वर्गदूतगदे ह्रङ्‌बान तला। ओच्‍छे सिबाग्‍याम सोना लबाला सन्‍तान तबासे लमा थेनीगदे परमेश्‍वरला सन्‍तान हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","परमप्रभुसे लुङ्बा झाङग्‍याम मोशादा ‘ङा अब्राहामला परमेश्‍वर, इसहाकला परमेश्‍वर ओच्‍छे याकूबला परमेश्‍वर हिन्‍ना’ भिसी सुङ्बा ताम मोशासे भ्रिबा मुला। चु तामग्‍यामसेन सिबाग्‍याम सोना लमुला भिसी उन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","परमेश्‍वर सिबागदेला परमेश्‍वर आहिन, तर सोबागदेला परमेश्‍वर हिन्‍ना! थेतबासेलमा परमेश्‍वरला लागिरी जम्‍मान सोबा मुला।” ");
INSERT INTO taj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","जमाहेन्‍से कोइ कोइ यहूदी धर्मगुरुगदेसे “गुरु, ह्राङसे सुङ्बा ताम ठीक हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","जमाहेन्‍से खालैसेन येशूदा तिगै ताम ङ्‌योइबारी आँट आलनी। ");
INSERT INTO taj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","जमाहेन्‍से येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “म्‍हिगदेसे खाह्रङ् लसी थार्बा पिन्‍बा ख्रीष्‍टदा दाऊद ग्‍लेला सन्‍तान भिसी भिबा? ");
INSERT INTO taj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","तिग्‍दा भिसम दाऊद ह्राङसेन भ्रिबा व्‍हाइला किताबरी चुह्रङ् भिसी भ्रिबा मुला, ‘परमप्रभुसे ङाला प्रभुदा ङाइ एला शत्रुगदेदा एला काङ धिरी आथान्‍तेधोना ए ङाला दाहिने यापट्टि चिउ भिसी सुङ्जी।’ ");
INSERT INTO taj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","दाऊद ग्‍लेसेन ख्रीष्‍टदा प्रभु भिला भिसम खाह्रङ् लसी ख्रीष्‍ट दाऊद ग्‍लेला सन्‍तान तला?” ");
INSERT INTO taj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ओच्‍छे जम्‍मान म्‍हिगदेसे ङ्‌यान्‍बान लबा धुइरी येशूसे ह्राङला चेलागदेदा चुह्रङ् भिसी सुङ्जी, ");
INSERT INTO taj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“एनीगदे यहूदी धर्मगुरुगदे म्राङ्सी होशियार तसी चिउ। तिग्‍दा भिसम थेनीगदे ज्‍यबा ज्‍यबा क्‍वान क्‍वान्‍सी कोर्बारी निमुला, ओच्‍छे बजाररीक्‍यार निमा म्‍हिगदेसे मान लगै भिसी सेम लमुला। थेह्रङ् लसीन यहूदीगदे ह्रुप तबा दिमदेन भोज चबा ग्‍लारीनोन मुल ठिरी चिबारी सेम लमुला। ");
INSERT INTO taj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","थेह्रङ् लसी थेनीगदेसे ह्रेम्‍बो सिबा म्रिङम्‍हेमेगदेला दिमनाम ब्‍यन्‍मुला ओच्‍छे म्‍हिगदेदा उन्‍बाला लागिरी ह्रेङ्बा ह्रेङ्बा प्रार्थना लमुला। थेह्रङ्बा म्‍हिगदेसे ल्‍हानान सजाय याङ्ला।” ");
INSERT INTO taj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","येशूसे परमेश्‍वरला मन्‍दिररी फ्‍युक्‍पो म्‍हिगदेसे भेटी युबा ताङरी भेटी युबान लबा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ओच्‍छे ह्रेम्‍बो सिबा प्राङबो म्रिङम्‍हेमेसेनोन डबल न्‍ही युबा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","चु म्राङ्सी येशूसे, “च्‍यागो, ङाला ताम ङ्‌यान्‍गो। स्‍य्‍हान्‍दो म्‍हिगदेसे भन्‍दा चु ह्रेम्‍बो सिबा प्राङबो म्रिङम्‍हेमेसे ल्‍हानान भेटी युबा मुला। ");
INSERT INTO taj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","तिग्‍दा भिसम स्‍य्‍हान्‍दो म्‍हिगदेसे ह्राङदेन छ्‌याम मुबा ल्‍हानान सम्‍पत्तिग्‍याम युजी, तर चु ह्रेम्‍बो सिबा म्रिङम्‍हेमे प्राङबो तसीनोन ह्राङदेन छ्‌याम मुबा जति जम्‍मान युजी” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","तिरेकुनु चेलागदेसे, “ज्‍यबा ज्‍यबा युङबादेन म्‍हिगदेसे फुल्‍बा भेटीगदेग्‍याम जेना लसी स्‍होबा चु परमेश्‍वरला मन्‍दिर गाते जेबा!” भिसी ताम लबान मुबा। तर येशूसे थेनीगदेदा, ");
INSERT INTO taj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“तिरेकुनु चुह्रङ्बा धुइएनोन खाल, थे धुइरी दान्‍दे म्राङ्बा चु मन्‍दिरला युङबा गिकनोन बाँकी आचिना जम्‍मान फुप्‍ला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ओच्‍छे थेनीगदेसे, “गुरु, चु तामगदे खाइमा तला? चुह्रङ् तबारी छ्‌याइजी भिसी खाह्रङ्बा चिनु म्राङ्ला?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदे होशियार तसी चिउ, खालैसे एनीगदेदा झुक्‍याब थालगै। तिग्‍दा भिसम ङाला मिन किन्‍सी ‘ङानोन थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍ना’ भिसी ल्‍हानान म्‍हिगदे खला। ओच्‍छे ‘धुइ खसी जिन्‍बा मुला’ भिसी भिला, तर एनीगदेसे थेनीगदेला ताम थाङ्‌यान्‍गो। ");
INSERT INTO taj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ओच्‍छे लडाइ तजी भिबा ताम थेःसी एनीगदे आत्तेब थातउ, तिग्‍दा भिसम चु जम्‍बुलिङ नाश तबा भन्‍दा ङाच्‍छा चु तनोन तोःला। तर थेनोन धुइरी चु जम्‍बुलिङ नाश आत।” ");
INSERT INTO taj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","जमाहेन्‍से येशूसे थेनीगदेदा दोःसी चुह्रङ् भिसी सुङ्जी, “म्‍हि य्‍हुलला बिरोधरी म्‍हि य्‍हुलनोन ओच्‍छे य्‍हुल्‍साला बिरोधरी य्‍हुल्‍सा रेःला। ");
INSERT INTO taj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ओच्‍छे घ्रेन घ्रेन सङगुल खला, जम्‍मान ग्‍लारी अनिकालदेन देसान खला। मुरी घ्रेन घ्रेन लोङ्‌बा खबा चिनुगदे म्राङ्ला। ");
INSERT INTO taj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“तर चु तबा भन्‍दा ङाच्‍छा म्‍हिगदेसे एनीगदेदा चुङ्सी दुख पिन्‍ना। ओच्‍छे यहूदीगदे ह्रुप तबा दिमरी जिम्‍मा लसी एनीगदेदा झ्‍याल्‍खानरी झाङ्‌ला। ओच्‍छे एनीगदेसे ङादा विश्‍वास लबासे लमा ग्‍लेदेन अञ्‍चलाधीशगदेला ङाच्‍छापट्टि भोर्ला। ");
INSERT INTO taj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","थे धुइरी एनीगदेसे ङाला बारेरी पाङ्बा मौका याङ्ला। ");
INSERT INTO taj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","तर एनीगदेसे ह्राङदा जोगब लबारी तिग पाङ्तोःबा भिसी धन्‍दा सुर्दा थालउ। ");
INSERT INTO taj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","तिग्‍दा भिसम थे धुइरी एनीगदेसे तिग ताम पाङ्तोःबा थे ताम पाङ्‌बारी ङाइ एनीगदेदा ज्ञान बुद्धि पिन्‍ना। जमाहेन्‍से थेनीगदेसे एनीगदेला ताम थाबारी आखम ओच्‍छे एनीगदेसे पाङ्बा तामला जोहाबएनोन पिन्‍बारी आखम। ");
INSERT INTO taj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","तर एनीगदेदा ह्राङलान आबा आमा, ज्‍योज्‍यो आले ओच्‍छे ह्राङला म्‍हिगदेदेन ह्रोगदेसेनोन चुङ्सी पिन्‍ना। ओच्‍छे एनीगदे न्‍हङला कोइ कोइदा मी म्‍हिगदेसे साइपुङ्‍ला। ");
INSERT INTO taj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","थेह्रङ् लसीन ङादा विश्‍वास लबासे लमा एनीगदेदा जम्‍मान म्‍हिगदेसे हेला लला। ");
INSERT INTO taj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","तर एनीगदेला थोबोला क्रा गिक सुत्तै आताइ। ");
INSERT INTO taj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","जस्‍तोन दुख तसैनोन एनीगदेसे सेमहेन्‍सेन विश्‍वास लसी चिबासे लमा जुकजुकधोनाला जुनी याङ्ला। ");
INSERT INTO taj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“यरूशलेम शहरदा सिपाहीगदेसे घेरब लबा म्राङ्माहेन्‍से शहर नाश तबा धुइ खसी जिन्‍जी भिसी एनीगदेसे घोउ। ");
INSERT INTO taj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","थे धुइरी यहूदिया अञ्‍चलरी मुबागदे गङरीक्‍यार यार्गै, शहर न्‍हङरी मुबागदेसे शहर ख्‍लागै ओच्‍छे नाम्‍सारी मुबागदे शहररी थाखगै। ");
INSERT INTO taj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","तिग्‍दा भिसम थे धिन चा परमेश्‍वरग्‍याम सजाय याङ्बा धिन हिन्‍ना। ओच्‍छे परमेश्‍वरला बचनरी भ्रिबा जम्‍मान ताम पूरा तनोन तला। ");
INSERT INTO taj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","थे धुइरी जिउ न्‍हीला म्रिङम्‍हेमेदेन कोलादा ङ्‍हे ख्‍वाबा आमागदेदा झन गाते ल्‍हानान दुख तला! ओच्‍छे य्‍हुल्‍सा नाङनोन ल्‍हानान दुख तला। चु य्‍हुलला म्‍हिगदेदा परमेश्‍वरसे ल्‍हानान सजाय पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","थे धुइरी कोइ कोइ म्‍हिगदेदा तरवारसे ताम्‍सी साइला, कोइ कोइदा चुङ्सी य्‍हुल्‍सा य्‍हुल्‍सारी भोर्ला। ओच्‍छे अर्गु य्‍हुलला म्‍हिगदेला धुइ आजिन्‍तेधोना थेनीगदेसे यरूशलेमरी रजाइँ लला। ");
INSERT INTO taj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“लनी धिनीदेन सारगदेरी खाइमै आम्राङ्बा चिनुगदे म्राङ्ला। ओच्‍छे समुन्‍द्र घुर्बादेन समुन्‍द्रला छालसे लमा जम्‍बुलिङला जम्‍मान म्‍हिगदे लोङ्सी आत्तेब तला। ");
INSERT INTO taj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","जम्‍बुलिङरी तबारी छ्‌याइबा दुखला बारेरी था याङ्सी म्‍हिगदे लोङ्सी सिबा तेबान तला। तिग्‍दा भिसम मुरी मुबा जम्‍मान शक्ति याङयोङ तला। ");
INSERT INTO taj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","जमाहेन्‍से परमेश्‍वरसे पुइखबा म्‍हिदा घ्रेन शक्तिदेन य्‍हाल य्‍हालरी खसुरी खबान लबा म्राङ्ला। ");
INSERT INTO taj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","थेह्रङ् तमाहेन्‍से आलोङ्ना एनीगदेसे स्‍वर्गपट्टि च्‍यागो, तिग्‍दा भिसम एनीगदेदा योनान थार्ना लला।” ");
INSERT INTO taj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","जमाहेन्‍से येशूसे थेनीगदेदा उखानग्‍याम चुह्रङ् भिसी सुङ्जी, “एनीगदेसे अञ्‍जीर दोङदेन अर्गु दोङगदे, ");
INSERT INTO taj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","भुबा म्राङ्माहेन्‍से दाहेन्‍से छेप्‍बा छबा ला खबारी छ्‌याइजी भिसी था याङ्मुला। ");
INSERT INTO taj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","थेह्रङ् लसीन ङाइ पाङ्बा ताम तबान लबा म्राङ्माहेन्‍से एनीगदेसे परमेश्‍वरला य्‍हुल्‍सा खबा धुइ तबारी छ्‌याइजी भिसी था याङ्‍गो। ");
INSERT INTO taj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, चु जम्‍मान ताम पूरा आततेधोना दान्‍देला म्‍हिगदे आसि। ");
INSERT INTO taj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","मुदेन जम्‍बुलिङ म्‍हासी निसैनोन ङाला बचन खाइमै आम्‍हा।” ");
INSERT INTO taj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“तर एनीगदे होशियार तसी चिउ, आहिन्‍सम मोजमजा लसी ङ्‌य्‍होइसी भ्रबादेन ह्राङला ल्‍हुइला धन्‍दा सुर्दासे लमा एनीगदेला सेम न्‍होङ्ला। ओच्‍छे परमेश्‍वरसे पुइखबा म्‍हि खमा एनीगदे तिक्‍खुरीन पासोरी परब तबा ह्रङ् तला। ");
INSERT INTO taj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","थेह्रङ् लसीन जम्‍बुलिङरी चिबा जम्‍मान म्‍हिगदेथोरी थे धिन खला। ");
INSERT INTO taj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","थेतबासेलमा एनीगदे ‘थे लोङ्‌बा खबा धुइरी जोगब तबारीदेन परमेश्‍वरसे पुइखबा म्‍हिला ङाच्‍छा राप्‍बारी खम्‍गै भिसी प्रार्थना लसी छोर्सी चिउ’ भिसी सुङ्जी।” ");
INSERT INTO taj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","थे धुइरी येशूसे धिनीरी म्‍हिगदेदा परमेश्‍वरला मन्‍दिररी लोप्‍मुबा, ओच्‍छे म्‍हुन तमाहेन्‍से जैतून भिबा गङरी बास स्‍य्‍हूबारी फेप्‍मुबा। ");
INSERT INTO taj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","येशूला बचन ङ्‌यान्‍बाला लागिरी म्‍हिगदे स्‍य्‍होरीन परमेश्‍वरला मन्‍दिररी खमुबा। ");
INSERT INTO taj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी खमीर आयुना गेङ चसी धङ्बा चाड खबारी छ्‌याइमुबा। ");
INSERT INTO taj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","थे धुइरी परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिदेन यहूदी धर्मगुरुगदेसे येशूदा खाह्रङ् लसी साइबा भिसी दाउ च्‍यासी भ्रमुबा। तर थेनीगदे म्‍हिगदेदेन छ्‌याम लोङ्मुबा। ");
INSERT INTO taj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","थे धुइरी च्‍युक न्‍ही चेलागदे न्‍हङला यहूदा इस्‍करियोत भिबा चेलाला सेम न्‍हङरी शैतान वाङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","जमाहेन्‍से यहूदा इस्‍करियोत परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिदेन मन्‍दिरला सिपाहीगदेला हाकिम मुबा ग्‍लारी निसी येशूदा चुङ्सी थेनीगदेला यारी जिम्‍मा लसी पिन्‍ना भिसी सल्‍लाह लजी। ");
INSERT INTO taj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","जमाहेन्‍से थेनीगदे ताङ्सी यहूदा इस्‍करियोतदा टाङगा पिन्‍ना भिसी कबुल लजी। ");
INSERT INTO taj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","जमाहेन्‍से यहूदा इस्‍करियोतसे तला, भिसी म्‍हिला हुल आरेबा धुइरी येशूदा चुङ्सी पिन्‍बारी दाउ च्‍यासी भ्रजी। ");
INSERT INTO taj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाड खसी जिन्‍बा मुबा। थे चाडकुनु ग्‍यु बोगो बलि पिन्‍तोःबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","थे धुइरी येशूसे पत्रुसदेन यूहन्‍नादा “एनीगदे निसी य्‍हाङला लागिरी चाडला भोज तयार लउ” भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","जमाहेन्‍से थेनीगदेसे “ङन्‍से भोज खानङ तयार लउ” भिसी येशूदा ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","येशूसे थेनीगदेदा “एनीगदे शहररी धोमैछ्‌याम दर्बुङरी क्‍युइ पुइसी निबान लबा म्‍हि गिकदा स्‍याप्‍ला, एनीगदे थे म्‍हिला लिच्‍छा लिच्‍छा निउ। ");
INSERT INTO taj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ओच्‍छे थे म्‍हि जुन दिमरी वाङ्ला थे दिमला धनीदा ‘ङाइ ङाला चेलागदेदेन छ्‌याम चिसी मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाडला भोज चबा कोठा खानङ मुला? भिसी ङन्‍ना गुरुसे ङ्‌योइबा मुला’ भिसी भिउ। ");
INSERT INTO taj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","जमाहेन्‍से एनीगदेदा थेसे ङाच्‍छान जेना लसी थान्‍बा तलाथोला घ्रेन कोठा उन्‍सी पिन्‍ना। एनीगदेसे थेरीन य्‍हाङला लागिरी भोज तयार लउ” भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","जमाहेन्‍से थेनीगदे निजी ओच्‍छे येशूसे सुङ्बा ह्रङ्नोन स्‍याप्‍जी। ओच्‍छे थेनीगदेसे थे मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाडला भोज तयार लजी। ");
INSERT INTO taj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","चबा धुइ तमाहेन्‍से येशू ह्राङला मुल चेलागदेदेन छ्‌याम सोल छ्‌योइबारी धन्‍छ्‌याजी। ");
INSERT INTO taj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","जमाहेन्‍से येशूसे थेनीगदेदा “ङाइ दुख नाबा भन्‍दा ङाच्‍छा एनीगदेदेन छ्‌याम चिसी चु चाडला भोज चबा सेम ल्‍हानान मुबा। ");
INSERT INTO taj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","थेतबासेलमा एनीगदेसे ङाला ताम ङ्‌यान्‍गो, परमेश्‍वरला य्‍हुल्‍सारी चु भोजला अर्थ पूरा आततेधोना ङाइ चु भोज दोःसी आच” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","जमाहेन्‍से येशूसे खोरे यारी थोसी परमेश्‍वरदा धन्‍यवाद पिन्‍माहेन्‍से “ना, चु एनीगदे जम्‍मासेन भो लसी थुङ्‍गो। ");
INSERT INTO taj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","एनीगदेसे ङाला ताम ङ्‌यान्‍गो, तिग्‍दा भिसम परमेश्‍वरला य्‍हुल्‍सा आखतेधोना ङाइ अङगुरला निङगु आथुङ्” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","जमाहेन्‍से येशूसे यारी गेङ थोसी परमेश्‍वरदा धन्‍यवाद पिन्‍माहेन्‍से गेङ क्‍युइसी चेलागदेदा पिन्‍बान, “चु एनीगदेला लागिरी पिन्‍बा ङाला ल्‍हुइ हिन्‍ना। दाहेन्‍से ङादा ढन्‍सी चिबाला लागिरी एनीगदेसे चुह्रङ्‌नोन लउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","थेह्रङ् लसीन गेङ चसी जिन्‍माहेन्‍से येशूसे खोरे थोसी चेलागदेदा चुह्रङ् भिसी सुङ्जी, “चु खोरेरी मुबा अङगुरला निङगु ङाला काग्‍याम स्‍होबा छार कबुल हिन्‍ना। चु ङाला का एनीगदेला लागिरी बगब तबा मुला। ");
INSERT INTO taj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“तर च्‍यागो, ङादा चुङ्सी पिन्‍बा म्‍हि ङादेन छ्‌यामनोन चिसी चबान मुला। ");
INSERT INTO taj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","परमेश्‍वरसे पुइखबा म्‍हि मी परमेश्‍वरसे सुङ्बा अन्‍छार निनोन तोःला। तर परमेश्‍वरसे पुइखबा म्‍हिदा चुङ्सी पिन्‍बा म्‍हिसे चा परमेश्‍वरग्‍याम सजाय याङ्ला।” ");
INSERT INTO taj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","चु ताम थेःसी चेलागदे ह्राङ ह्राङ न्‍हङरी चुह्रङ्बा गे लबा म्‍हि खाल मुला तला? भिसी ताम लजी। ");
INSERT INTO taj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","जमाहेन्‍से चेलागदे ह्राङ ह्राङ न्‍हङरी खाल घ्रेन भिसी ताम लबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","चु ताम था याङ्सी येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “चु जम्‍बुलिङला ग्‍लेगदेदेन घ्रेन घ्रेन म्‍हिगदेसे म्‍हिगदेथोरी शासन लमुला। ओच्‍छे म्‍हिगदेसे थेनीगदेन ङन्‍दा दया लबा ज्‍यबा म्‍हि हिन्‍ना भिसी भिमुला। ");
INSERT INTO taj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","तर एनीगदे चा थेह्रङ् तबारी आत। ओच्‍छे एनीगदे न्‍हङरी जुन घ्रेन मुला थे जजा दोगै ओच्‍छे नेता दोबासे चा स्‍य्‍हान्‍दोगदेला सेवा लगै। ");
INSERT INTO taj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","तिग्‍दा भिसम चबारी चिबा मालिकदेन चबा पिन्‍बा नोकररी खजिबा चा घ्रेन हिन्‍ना? तिग चबारी चिबा मालिक घ्रेन आहिन? हिन्‍ना। तर ङा एनीगदेला ओन्‍छाङरी चबा पिन्‍बा नोकर ह्रङ्‌बान मुला। ");
INSERT INTO taj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","एनीगदे चा ङादा दुख तमा ह्रो लबागदे हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","थेतबासेलमा ङाला आबासे ङादा य्‍हुल्‍सा गिकला अधिकार पिन्‍बा ह्रङ् लसी ङाइएनोन एनीगदेदा थे य्‍हुल्‍साला अधिकार पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","जमाहेन्‍से एनीगदेसे ङाला य्‍हुल्‍सारी टेबुल गिकरीन चबा थुङ्बा लला। ओच्‍छे इस्राएलला च्‍युक न्‍ही वंशला निसाफ लसी ठिरी चिला।” ");
INSERT INTO taj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","जमाहेन्‍से येशूसे पत्रुसदा “सिमोन, सिमोन, शैतानसे एदा ग्‍वा य्‍हाप्‍बा ह्रङ् लसी य्‍हाप्‍बारी छ्‌याइबा मुला। ");
INSERT INTO taj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","तर एला विश्‍वास याङयोङ थातगै भिसी ङाइ एला लागिरी प्रार्थना लजी। ए दोःसी ङादेन छ्‌याम खमाहेन्‍से एसे आलेगदेदा विश्‍वासरी कोङ्‌ना लउ। ");
INSERT INTO taj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","जमाहेन्‍से पत्रुससे येशूदा “प्रभु, ङा ह्राङदेन छ्‌याम झ्‍याल्‍खानरी चितोःसै ह्राङदेन छ्‌याम सितोःसै सिबारी तयार मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","तर येशूसे पत्रुसदा “पत्रुस, ङाला ताम ङ्‌यान्‍गो, न्‍हङगर स्‍य्‍होरी नागा क्राबा भन्‍दा ङाच्‍छा एसे ङादा ङोसेबान आरे भिसी सोमरेमधोना पाङ्ला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","येशूसे थेनीगदेदा “ङाइ एनीगदेदा टाङगा, झोला, लखम आभोर्ना निउ भिसी पुइमुबा। थे धुइरी एनीगदेदा तिगै स्‍हेला खाँचो तजी? भिसी ङ्‌योइमा, थेनीगदेसे “आतनी” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","जमाहेन्‍से येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “तर दाहेन्‍से टाङगा मुबासे टाङगा थोगो, झोला मुबासे झोला थोगो, ओच्‍छे जुन म्‍हिदेन छ्‌याम तरवार आरे थेसे ह्राङला क्‍वान चूङ्सी भिसै तरवार गिक ग्‍लुउ। ");
INSERT INTO taj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","एनीगदेसे ङाला ताम ङ्‌यान्‍गो, तिग्‍दा भिसम परमेश्‍वरला बचनरी ‘थेदा अपराधीगदेदा ह्रङ्नोन लला भिसी भ्रिबा ताम ङाग्‍याम पूरा तनोन तोःला’ तिग्‍दा भिसम ङाला बारेरी भ्रिबा ताम पूरा तबान मुला।” ");
INSERT INTO taj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","जमाहेन्‍से येशूदा चेलागदेसे “प्रभु, चुरी तरवार न्‍ही मुला” भिसी भिमा, येशूसे थेनीगदेदा “तजी” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","येशू सदला ह्रङ्नोन थे ग्‍लाग्‍याम थोन्‍सी जैतून भिबा गङरी फेप्‍जी। ओच्‍छे थेला चेलागदेएनोन लिच्‍छा लिच्‍छा निजी। ");
INSERT INTO taj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","थे ग्‍लारी धोमाहेन्‍से येशूसे थेनीगदेदा “एनीगदे फसब आतबाला लागिरी प्रार्थना लसी चिउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ओच्‍छे येशू थेनीगदेग्‍याम जजाकी क्‍याथाङ फेप्‍सी पुइ जूसी चुह्रङ् भिसी प्रार्थना लबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“आबा, तसम ङादा चु दुखग्‍याम फेसी पिन्‍गो। तर ङाइ म्‍हन्‍बा अन्‍छार आहिन, ह्राङसे म्‍हन्‍बा अन्‍छार पूरा तगै।” ");
INSERT INTO taj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","जमाहेन्‍से स्‍वर्गग्‍याम स्‍वर्गदूत गिक खसी येशूदा दुख नाखम्‍बा भङ पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","थे धुइरी येशूदा ल्‍हानान दुख तबासे लमा थेसे झन प्रार्थना लजी। थे धुइरी थेला टू काला धारा ह्रङ् लसी सरी ताइबान मुबा। ");
INSERT INTO taj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","प्रार्थना लसी ह्राङला चेलागदे मुबा ग्‍लारी फेप्‍खमा येशूसे थेनीगदे दुखसे लमा लारकलुरूक तसी म्‍हेर्सी चिबा स्‍याप्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","जमाहेन्‍से येशूसे थेनीगदेदा “तिग्‍दा एनीगदे म्‍हेर्सी चिबा? रेःगो, पापरी फसब आतबाला लागिरी एनीगदेसे प्रार्थना लउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","येशूसे चु ताम सुङ्बान लबा धुइरी थेरी म्‍हिला हुल गिक खजी। थे म्‍हिला हुलला ङाच्‍छा ङाच्‍छा च्‍युक न्‍ही चेलागदे न्‍हङला यहूदा भिबा चेला खजी। येशूदा च्‍योक लबाला लागिरी थे येशूला ङामरी खजी। ");
INSERT INTO taj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","तर येशूसे थेदा “यहूदा, तिग एसे परमेश्‍वरसे पुइखबा म्‍हिदा च्‍योक लसी फसब लबारी म्‍हाइबा?” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","जमाहेन्‍से येशूला ङामरी मुबा चेलागदेसे थेरी तबारी छ्‌याइबा ताम था याङ्सी येशूदा “प्रभु, ङन्‍से तरवार चलब लउ?” भिसी, ");
INSERT INTO taj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","थेनीगदे न्‍हङला गिकसे परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिला नोकरदा ताम्‍मा थेला दाहिनेपट्टिला नाब्‍यङ च्‍वाट्टन थाजी। ");
INSERT INTO taj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","तर येशूसे “तजी थालउ” भिसी थेला नाब्‍यङरी थुर्सी खम्‍ना लजी। ");
INSERT INTO taj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","जमाहेन्‍से येशूसे ह्राङदा चुङ्बारी खबा परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन मन्‍दिरला सिपाहीगदेला हाकिमगदेदा ओच्‍छे यहूदी गन्‍बागदेदा “एनीगदे य्‍होदा चुङ्बारी खबा ह्रङ् लसी तिग्‍दा कडीदेन तरवार थोसी खबा? ");
INSERT INTO taj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ङा धिन धिननोन एनीगदेदेन छ्‌यामनोन परमेश्‍वरला मन्‍दिररी मुबा। थे धुइरी एनीगदेसे ङादा आचुङ्नी। तर दाहेन्‍से एनीगदेला गे लबा धुइ खबा मुला ओच्‍छे चु धोपधोपसे शासन लबा धुइ हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","जमाहेन्‍से थेनीगदेसे येशूदा चुङ्सी परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिला दिमरी भोर्जी। पत्रुसएनोन थारेङग्‍यामसेन येशूला लिच्‍छा लिच्‍छा निजी। ");
INSERT INTO taj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","थेरी म्‍हिगदे ख्राङगाला गुङरी मे फुइसी दूबान मुबा। ओच्‍छे पत्रुसएनोन थेरी खसी थेनीगदेदेन छ्‌यामनोन चिजी। ");
INSERT INTO taj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","थेनोन धुइरी नोकरस्‍या गिकसे पत्रुसदा मे दूसी चिबा म्राङ्सी थेदा “चु म्‍हिएनोन येशूदेन छ्‌यामनोन मुबा” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","पत्रुससे थे नोकरस्‍यादा “माइ, ङाइ थेदा ङोसेबा आरे” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ओच्‍छे छिन्‍नङ लिच्‍छा स्‍य्‍हान्‍दो म्‍हि गिकसे पत्रुसदा म्राङ्सी, “एएनोन थेनीगदेला ह्रो हिन्‍ना” भिसी भिमा, पत्रुससे “ङा आहिन” भिसी जोहाब पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ओस्‍पन घण्‍टा गिक लिच्‍छा स्‍य्‍हान्‍दो म्‍हि गिकसे “चु म्‍हिएनोन पक्‍कान येशूदेन छ्‌यामनोन मुबा, तिग्‍दा भिसम चुएनोन गालीलला हिन्‍ना” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","पत्रुससे “एसे तिग भिबा, ङादा था आरे” भिसी भिमैछ्‍याम नागा क्राजी। ");
INSERT INTO taj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ओच्‍छे प्रभुसे पत्रुसदा स्‍हीजी। जमाहेन्‍से “न्‍हङगर स्‍य्‍होरी नागा क्राबा भन्‍दा ङाच्‍छा सोमरेमधोना एसे ङादा ङोसेबान आरे भिला” भिसी प्रभुसे सुङ्बा ताम पत्रुससे ढन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","जमाहेन्‍से पत्रुस मङग्‍यार निसी घ्‍वाँ घ्‍वाँ क्राजी। ");
INSERT INTO taj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","जमाहेन्‍से येशूदा चुङ्सी भबा म्‍हिगदेसे येशूदा खिसी लबान तोजी। ");
INSERT INTO taj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ओच्‍छे येशूला मी घप्‍सी तोबान, “लु, अगमवाणी पाङ्‍गो, एदा खाल्‍से तोजी?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ओच्‍छे थेनीगदेसे येशूदा बङ्‍बान बेइज्‍जत लजी। ");
INSERT INTO taj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","य्‍हाल तमैछ्‌याम येशूदा यहूदी गन्‍बागदे ह्रुप तबा सभारी भोर्जी। थे सभारी परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी धर्मगुरुगदे मुबा। ");
INSERT INTO taj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","जमाहेन्‍से थेनीगदेसे येशूदा “ए थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍ना भिसम ङन्‍दा पाङ्‍गो” भिसी भिमा, येशूसे थेनीगदेदा “ङाइ पाङ्सैनोन ह्राङनीसे विश्‍वास आल। ");
INSERT INTO taj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ओच्‍छे ङाइ तिगै ङ्‌योइसैनोन ह्राङनीसे जोहाब पिन्‍बारी आखम। ");
INSERT INTO taj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","तर दाहेन्‍से परमेश्‍वरसे पुइखबा म्‍हि शक्तिशाली परमेश्‍वरला दाहिनेपट्टि चिला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","जमाहेन्‍से थेनीगदे जम्‍मासेन येशूदा “थेह्रङ् भिसम तिग ए परमेश्‍वरला झा हिन्‍ना?” भिसी ङ्‌योइमा, येशूसे थेनीगदेदा “ह्राङनीसे सुङ्बा ह्रङ्नोन ङा थेनोन हिन्‍ना” भिसी जोहाब पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","येशूसे चुह्रङ् सुङ्माहेन्‍से थेनीगदेसे “थेलान सुङग्‍याम य्‍हाङसे चु जम्‍मान ताम थेःसी जिन्‍माहेन्‍से दाहेन्‍से य्‍हाङदा थेला बिरोधरी अर्गु प्रमाण तिग्‍दा तोःजी” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","जमाहेन्‍से यहूदीगदेलान सभाला म्‍हिगदेसे येशूदा पिलातस भिबा रोमी अञ्‍चलाधीश मुबा ग्‍लारी भोर्सी जिम्‍मा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ओच्‍छे थेनीगदेसे येशूदा दोष लबान, “चुसे ह्राङसे ह्राङदान ङा थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍ना भिबादेन रोमी ग्‍याल्‍बो कैसरदा तिरो फाआतोः भिसी य्‍हाङला य्‍हुल्‍साला म्‍हिगदेदा न्‍होङ्ना लबा ङन्‍से स्‍याप्‍जी” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","थेनीगदेला ताम थेःसी पिलातससे येशूदा “तिग ए यहूदीगदेला ग्‍ले हिन्‍ना?” भिसी ङ्‌योइमा, येशूसे पिलातसदा “थे मी ह्राङसेन सुङ्बा मुला” भिसी जोहाब पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","जमाहेन्‍से पिलातससे परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिदेन थेरी मुबा जम्‍मान म्‍हिगदेदा “ङाइ चु म्‍हिला तिगै गल्‍ती आस्‍याप्‍नी” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","थेनीगदेसे क्रिङ्बान, “चुसे यहूदिया अञ्‍चलदेन गालील अञ्‍चलहेन्‍से चुधोनाला म्‍हिगदेदा ह्राङला ताम लोप्‍सी न्‍होङ्ना लबा मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","जमाहेन्‍से पिलातससे “चु म्‍हि गालीलला हिन्‍ना?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","येशू हेरोदसे शासन लबा अञ्‍चलला चीम भिसी था याङ्माहेन्‍से पिलातससे येशूदा हेरोद मुबा ग्‍लारी पुइजी। थे धुइरी हेरोद यरूशलेमरी मुबा। ");
INSERT INTO taj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","येशूदा म्राङ्माहेन्‍से हेरोद ल्‍हानान ताङ्जी। तिग्‍दा भिसम थेसे येशूला बारेरी थेःबासे लमा ल्‍हानान धिनहेन्‍से येशूदा च्‍याबा सेम लमुबा। ओच्‍छे थेसे येशूसे लबा तिगै उदेकला गे च्‍याम्‍याङ्ला भिसी आश लबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","थेतबासेलमा थेसे येशूदा ल्‍हानान ताम ङ्‌योइजी तर येशूसे तिगै जोहाब आपिन्‍नी। ");
INSERT INTO taj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ओच्‍छे परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी धर्मगुरुगदे क्रिङ्बान येशूदा दोष लबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","जमाहेन्‍से हेरोददेन थेला सिपाहीगदेसे येशूदा खिसी लबान बेइज्‍जत लजी। ओच्‍छे येशूदा ग्‍लेसे क्‍वान्‍बा ह्रङ्‌बा क्‍वान क्‍वान्‍सी पिन्‍सी पिलातस मुबा ग्‍लारी दोःसी पुइजी। ");
INSERT INTO taj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ङाच्‍छा हेरोददेन पिलातस आढिक्‍बा मुबा। तर थे धिनकुनुहेन्‍से थेन्‍नी ढिक्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","जमाहेन्‍से पिलातससे परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी नेतागदेदा ओच्‍छे म्‍हिगदेदा ङ्‌योइसी, ");
INSERT INTO taj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“एनीगदेसे चुसे म्‍हिगदेदा न्‍होङ्ना लजी भिसी ङा मुबा ग्‍लारी भजी, तर ङाइ एनीगदेला ङाच्‍छापट्टिन चुदा ङ्‌योइबा छार्बा लमा ङाइ ह्राङनीसे लबा दोष तिगै आस्‍याप्‍नी। ");
INSERT INTO taj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","हेरोदसेएनोन तिगै दोष आस्‍याप्‍बासे लमा चुदा य्‍हाङ मुबा ग्‍लारी पुइखजी। च्‍यागो, साइनोन तोःबा खाल्‍ला गे चा चुसे तिगै लबा आरे। ");
INSERT INTO taj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","थेतबासेलमा ङाइ चुदा सजाय जे पिन्‍सी पुइला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","यहूदीगदे मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाडला धुइरी पिलातससे झ्‍याल्‍खानरी मुबा म्‍हि गिकदा पुइतोःमुबा। ");
INSERT INTO taj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","तर जम्‍मान म्‍हिगदेसे “चुदा साइनोन तोःला, बरु ङन्‍ना लागिरी बारब्‍बादा पुइसी पिन्‍गो” भिसी क्रिङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","थे धुइरी जम्‍मान म्‍हिसे ङोसेबा बारब्‍बा भिबा आज्‍यबा गे लबा म्‍हि गिक झ्‍याल्‍खानरी थान्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","पिलातससे येशूदा पुइबा सेम लसी म्‍हिगदेदा घोना लबारी म्‍हाइजी। ");
INSERT INTO taj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","तर थेनीगदे जम्‍मासेन, “चुदा क्रुसरी टाँगब लसी साइगो, क्रुसरी साइगो!” भिसी क्रिङ्बाला क्रिङ्बान लजी। ");
INSERT INTO taj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","दोःसीएनोन पिलातससे थेनीगदेदा “तिग्‍दा? चुसे थेह्रङ्बा आज्‍यबा गे तिग लबा मुला? ङाइ मी चुदा साइतोःबा दोष तिगै आस्‍याप्‍नी। थेतबासेलमा ङाइ चुदा सजाय पिन्‍सी पुइला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","तर थेनीगदे झन क्रिङ्सी, “क्रुसरी साइनोन तोःला” भिसी भिजी। चुह्रङ् लसी क्रिङ्सी म्‍हिगदेसे ढाजी। ");
INSERT INTO taj_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","जमाहेन्‍से पिलातससे येशूदा थेनीगदेसे भिबा ह्रङ्नोन लपुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ओच्‍छे आन्‍दोलन लसी म्‍हि साइबासे लमा झ्‍याल्‍खानरी झाङ्‌बा बारब्‍बादा पिलातससे पुइसी पिन्‍जी। तिग्‍दा भिसम म्‍हिगदेसे थेदान पुइसी पिन्‍गो भिसी भिमुबा। तर येशूदा चा थेनीगदेसे पाङ्बा अन्‍छार थेनीगदेला यारी जिम्‍मा लसी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","जमाहेन्‍से थेनीगदेसे येशूदा थेग्‍याम भोर्बान लमा कुरेनी भिबा ग्‍लाला सिमोन खबान मुबा। थेदा चुङ्सी येशूला क्रुस पुइपुङ्सी येशूला लिच्‍छा लिच्‍छा भ्रपुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ओच्‍छे म्‍हिला हुल येशूला लिच्‍छा लिच्‍छा निजी। थेरी म्रिङम्‍हेमेगदेएनोन क्राबा क्रिङ्बा लबान मुबा। ");
INSERT INTO taj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","तर थेनीगदेपट्टि दोःसी येशूसे चुह्रङ् भिसी सुङ्जी, “यरूशलेमला झामेगदे, ङाला लागिरी थाक्रागो, तर ह्राङलान लागिरी ओच्‍छे ह्राङलान कोलागदेला लागिरी क्रागो। ");
INSERT INTO taj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","तिग्‍दा भिसम चुह्रङ्बा धुइएनोन खबान मुला। थे धुइरी म्‍हिगदेसे कोला आन्‍हबा म्रिङम्‍हेमेदेन ङ्‍हे ख्‍वाआतोःबा म्रिङम्‍हेमेगदेदा परमेश्‍वरग्‍याम मोलम याङ्बा म्‍हि हिन्‍ना भिसी भिला। ");
INSERT INTO taj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","थेनोन धुइरी म्‍हिगदेसे गङगदेदा ङनीथोरी ताइगो ओच्‍छे ङन्‍दा ल्‍हुउ भिसी भिला। ");
INSERT INTO taj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","दोङ पिङगै मुबा धुइरीन चुगदेसे चुह्रङ् लमुला भिसम दोङ खर्माहेन्‍से झन तिग लला?” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","थेनीगदेसे य्‍हो न्‍हीदाएनोन येशूदेन छ्‌यामनोन साइबारी भोर्जी। ");
INSERT INTO taj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","जमाहेन्‍से थेनीगदे खप्‍पर भिबा गङरी धोखजी। थेरी थेनीगदेसे येशूदा क्रुसरी टाँगब लजी। ओच्‍छे थे य्‍हो न्‍हीदाएनोन गिकदा येशूला दाहिनेपट्टि, गिकदा देब्रेपट्टि लसी क्रुसरी टाँगब लजी। ");
INSERT INTO taj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","थे धुइरी येशूसे “आबा, चुगदेदा माफ लउ। तिग्‍दा भिसम चुगदेसे तिग लबान मुला थे चुगदेदा था आरे” भिसी सुङ्जी। ओच्‍छे सिपाहीगदेसे चिट्ठा युसी येशूला क्‍वान ह्राङ ह्राङ न्‍हङरी भो लजी। ");
INSERT INTO taj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","थेरी राप्‍सी च्‍यासी चिबा म्‍हिगदेदेन यहूदी नेतागदेसे येशूदा खिसी लबान, “चुसे स्‍य्‍हान्‍दो म्‍हिदा मी जोगब लजी। चु परमेश्‍वरसे धम्‍बा थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍सम ह्राङसे ह्राङदान जोगब लगै” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ओच्‍छे सिपाहीगदेसेएनोन येशूदा अङगुरला कम्‍बा निङगु पिन्‍सी खिसी लबान, ");
INSERT INTO taj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“ए यहूदीगदेला ग्‍ले हिन्‍सम ह्राङसे ह्राङदान जोगब लउ” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ओच्‍छे येशूदा “यहूदीगदेला ग्‍ले” भिसी दोष उन्‍बा ताम भ्रिसी येशूला थोबोथोरी थान्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","येशूदेन छ्‌यामनोन क्रुसरी टाँगब लबा य्‍हो न्‍ही न्‍हङला गिकसे येशूदा खिसी लबान, “ए थार्बा पिन्‍बा ख्रीष्‍ट आहिन? लु, एसे ह्राङदा जोगब लउ, ओच्‍छे ङन्‍दाएनोन जोगब लउ” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","तर स्‍य्‍हान्‍दो य्‍होसे थेदा बङ्‍बान चुह्रङ् भिसी सुङ्जी, “एदा परमेश्‍वर म्राङ्सी लोङ्‌बा आखमुला? थेसे याङ्बा सजाय एसे याङ्बा आरे? ");
INSERT INTO taj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","य्‍हाङसे मी आज्‍यबा गे लबासे लमा ठीक सजाय नाबान मुला, तर चुसे मी थेह्रङ्बा तिगै आज्‍यबा गे लबा आरे।” ");
INSERT INTO taj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","जमाहेन्‍से थेसे येशूदा “येशू, ह्राङला य्‍हुल्‍सारी फेप्‍बा धुइरी ङादाएनोन ढन्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ओच्‍छे येशूसे थेदा “एसे ङाला ताम ङ्‌यान्‍गो, तिनीन ए ङादेन छ्‌याम स्‍वर्गरी तला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ओस्‍पन धिनना बाह्र बजेहेन्‍से तीन बजेधोना य्‍हुल्‍सा नाङनोन धोपधोप तजी। ");
INSERT INTO taj_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","थे धुइरी धिनीला य्‍हाल म्‍हाजी, ओच्‍छे परमेश्‍वरला मन्‍दिर न्‍हङला पर्दा पख्‍ले न्‍ही तसी ढेजी। ");
INSERT INTO taj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","जमाहेन्‍से येशूसे क्रिङ्बान, “आबा, ङाला आत्‍मा किन्‍गो” भिसी सुङ्माहेन्‍से येशूला सा निजी। ");
INSERT INTO taj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","चु म्राङ्सी रोमी कप्‍तानसे परमेश्‍वरदा जयजयकार लबान, “चु म्‍हि पक्‍कान परमेश्‍वरला ङाच्‍छा ज्‍यबा म्‍हि चीम” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","चु म्राङ्सी थेरी च्‍याबारी खबा जम्‍मान म्‍हिगदेदा ल्‍हानान दुख तसी क्राबा क्रिङ्बा लबान दिमरी निजी। ");
INSERT INTO taj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ओच्‍छे येशूदा ङोसेबा म्‍हिगदेदेन गालीलग्‍याम येशूदेन छ्‌याम छ्‌याम खबा म्रिङम्‍हेमेगदे थारेङग्‍यामसेन चु ताम च्‍यासी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","योसेफ भिबा म्‍हि ज्‍यबादेन परमेश्‍वरसे कुल्‍बा ताम ङ्‌यान्‍बा म्‍हि मुबा। थे यहूदी सभाला सदस्‍य मुबा। ");
INSERT INTO taj_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","थेसे स्‍य्‍हान्‍दोगदेसे येशूदा साइबारी सल्‍लाह लबा धुइरी बिरोध लमुबा। तिग्‍दा भिसम थेसे परमेश्‍वरसे शासन लबा धुइ खला भिसी भ्रान्‍सी चिबा मुबा। थे यहूदिया अञ्‍चलला अरिमाथिया भिबा नाम्‍साला म्‍हि मुबा। ");
INSERT INTO taj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","थे पिलातस मुबा ग्‍लारी निसी येशूला लास ह्रीजी। ");
INSERT INTO taj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ओच्‍छे थेसे येशूला लास क्रुसग्‍याम तेःसी मलमलला क्‍वानसे रिल्‍जी। जमाहेन्‍से युङबाला पहरारी ठ्वाइसी स्‍होबा धुर्सारी थान्‍जी, थे धुर्सारी चु भन्‍दा ङाच्‍छा खालैला लास थान्‍बा आरेबा। ");
INSERT INTO taj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","थे धिन ब्‍लप्‍बा न्‍हबा धिनना ङाच्‍छाकुनु मुबा। थेतबासेलमा ब्‍लप्‍बा न्‍हबा धिन खबारी छ्‌याइमुबा। ");
INSERT INTO taj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","गालीलग्‍याम येशूदेन छ्‌याम खबा म्रिङम्‍हेमेगदेएनोन योसेफदेन छ्‌यामनोन निजी ओच्‍छे येशूला लास धुर्सारी थान्‍बा च्‍याजी। ");
INSERT INTO taj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","जमाहेन्‍से थेनीगदे दिमरी निसी येशूला लासरी फोर्बाला लागिरी ज्‍यबा खाल्‍ला छ्‌युगुदेन अत्तर तयार लजी। तर न्‍हङगरदङ चा यहूदीगदेला ठिम अन्‍छार ब्‍लप्‍बा न्‍हबा धिन धङ्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","जमाहेन्‍से थे म्रिङम्‍हेमेगदे आइतवारकुनु स्‍य्‍होरीन ह्राङसे तयार लबा ज्‍यबा खाल्‍ला छ्‌युगुदेन अत्तर भोर्सी येशूदा थान्‍बा धुर्सारी निजी। ");
INSERT INTO taj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","थेनीगदे थेरी धोमा धुर्साला म्रापरी थान्‍बा युङबा ब्‍लिङ्सी थान्‍बा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","तर थेनीगदे धुर्सा न्‍हङरी वाङ्सी च्‍यामा थेरी येशूला लास आम्राङ्‌नी। ");
INSERT INTO taj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","थेरी थेनीगदे अलमल तसी चिबा धुइरी झक्‍झक्‍बा क्‍वान क्‍वान्‍बा म्‍हि न्‍ही थेनीगदेला ङामरीन राप्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","थे म्‍हि न्‍हीदा म्राङ्सी म्रिङम्‍हेमेगदे लोङ्सी सरी ख्‍लुप तजी। जमाहेन्‍से थे म्‍हि न्‍हीसे थेनीगदेदा चुह्रङ् भिसी भिजी, “एनीगदेसे सोबा म्‍हिदा तिग्‍दा सिबागदे थान्‍बा धुर्सारी म्‍हाइबा? ");
INSERT INTO taj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","येशू चुरी आरे। थेदा सिबाग्‍याम सोना लसी जिन्‍बा मुला! येशू गालीलरी मुबा धुइरी एनीगदेदा तिग भिसी सुङ्बा मुबा थे ताम एनीगदेसे ढन्‍गो। ");
INSERT INTO taj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","परमेश्‍वरसे पुइखबा म्‍हिदा पापीगदेला यारी जिम्‍मा लला, ओच्‍छे क्रुसरी टाँगब लला तसैनोन ङादा सोमरेमाकुनु सिबाग्‍याम सोना लला।” ");
INSERT INTO taj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","जमाहेन्‍से येशूसे सुङ्बा ताम थेनीगदेसे ढन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","जमाहेन्‍से थे म्रिङम्‍हेमेगदे धुर्साग्‍याम दोःसी निसी ह्राङसे म्राङ्बा जम्‍मान ताम च्‍युक गिक चेलागदेदेन स्‍य्‍हान्‍दो जम्‍मान म्‍हिगदेदा पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","थे म्रिङम्‍हेमेगदे चा मरियम मग्‍दलिनी, याकूबला आमा मरियमदेन योअन्‍ना मुबा। ओच्‍छे थेनीगदेदेन छ्‌याम स्‍य्‍हान्‍दो म्रिङम्‍हेमेगदेएनोन मुबा। थेनीगदेसेन मुल चेलागदेदा ह्राङसे म्राङ्बा जम्‍मान ताम पाङ्मुबा। ");
INSERT INTO taj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","तर चेलागदेसे “एनीगदेसे तिग आतोःबा ताम लबा?” भिसी पत्‍याब आतनी। ");
INSERT INTO taj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","तर पत्रुस चा डोङ रेःसी धुर्सापट्टि यार्बान निजी। थेरी धोसी धुर्साला म्रापग्‍याम योइ तसी च्‍यामा येशूदा बेरब लबा क्‍वान जे म्राङ्जी। चुह्रङ् तबा म्राङ्सी थे उदेक म्‍हन्‍बान दिमपट्टि निजी। ");
INSERT INTO taj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","थेनोन धिनकुनु येशूला चेलागदे न्‍हङला चेला न्‍ही यरूशलेमग्‍याम ओस्‍पन कोस सोमसे गङसल थारेङला इम्‍माउस भिबा नाम्‍सारीक्‍यार निबान मुबा। ");
INSERT INTO taj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","थेनीगदेसे यरूशलेमरी तबा तामला बारेरी ह्राङ ह्राङ न्‍हङरी ताम लबान मुबा। ");
INSERT INTO taj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","चुह्रङ् लसी ताम लसी भ्रबान लबा धुइरी येशूएनोन थेनीगदेदेन छ्‌यामनोन फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","तसैनोन थेनीगदेसे येशूदा ङोआसेनी। तिग्‍दा भिसम परमेश्‍वरसे थेनीगदेदा ङोसेना आलनी। ");
INSERT INTO taj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","जमाहेन्‍से येशूसे थेनीगदेदा “एनीगदेसे तिग ताम लसी भ्रबा?” भिसी ङ्‌योइमा, थेनीगदेला ली धोपधोप लसी थेन तजी। ");
INSERT INTO taj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","थे न्‍ही न्‍हङला क्‍लेओपास भिबासे येशूदा “यरूशलेमरी कोर्सी खबा म्‍हि तसीनोन थेरी तिनी न्‍हङगर तिग तबा मुला थे ताम था आयाङ्बा चा ह्राङ जे चीम” भिसी पाङ्‌मा, ");
INSERT INTO taj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","येशूसेएनोन थेनीगदेदा “तिग ताम?” भिसी ङ्‌योइजी। जमाहेन्‍से थेनीगदेसे “नासरतला येशूला बारेरी तबा ताम ह्राङदा था आरे? थे म्‍हि अगमवक्ता हिन्‍ना। थेसे लबा गेदेन लोप्‍बा ताम परमेश्‍वरदेन म्‍हिला ओन्‍छाङरी शक्तिशाली मुबा। ");
INSERT INTO taj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","तर थेदा परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिदेन यहूदी नेतागदेसे चुदा साइगो भिसी क्रुसरी टाँगब लपुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","य्‍हाङ इस्राएलीगदेदा येशूसेन पापग्‍याम फेला भिसी ङन्‍से आश लमुबा। तर येशूदा साइबाएनोन तिनी सोमरे तजी। ");
INSERT INTO taj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","चुदे जे आहिन, तिनी स्‍य्‍होरीन ङन्‍ना कोइ कोइ नाना आङागदे येशूदा थान्‍बा धुर्सारी निमा, थेनीगदेसे येशूला लास आस्‍याप्‍नी। थेरी थेनीगदेसे स्‍वर्गदूतगदेदा म्राङ्जी। थे स्‍वर्गदूतगदेसे “येशू सोसी जिन्‍बा मुला” भिसी थेनीगदेदा पाङ्बा ताम ङन्‍दाएनोन पाङ्सी उदेक तना लजी। ");
INSERT INTO taj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","चु ताम थेःसी ङन्‍ना कोइ कोइ ह्रोगदे येशूदा थान्‍बा धुर्सारी च्‍याबारी निजी। थेनीगदेसेएनोन थे म्रिङम्‍हेमेगदेसे पाङ्बा ह्रङ्नोन स्‍याप्‍जी, तर येशूदा भिसम आम्राङ्नीम।” ");
INSERT INTO taj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","जमाहेन्‍से येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “ताम आघोबा म्‍हि, अगमवक्तागदेसे पाङ्बा ताम विश्‍वास लबारी एनीगदेदा खाह्रङ्बा गाह्रो तबा? ");
INSERT INTO taj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","तिग थार्बा पिन्‍बा ख्रीष्‍ट ह्राङला शक्तिदेन य्‍हालरी फेप्‍खबा भन्‍दा ङाच्‍छा चु दुख नातोःबा आरेबा?” ");
INSERT INTO taj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ओच्‍छे येशूसे ह्राङला बारेरी मोशाहेन्‍से जम्‍मान अगमवक्तागदेसे परमेश्‍वरला बचनरी भ्रिबा ताम थेनीगदेदा घोना लजी। ");
INSERT INTO taj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","थेनीगदे इम्‍माउस नाम्‍साला ङामरी धोखमाहेन्‍से येशू अझ थेग्‍याम क्‍यारनोन फेप्‍बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","तर थे चेला न्‍हीसे येशूदा “म्‍हुन तबारी छ्‌याइजी, थेतबासेलमा तिनी ह्राङ ङन्‍देन छ्‌यामनोन धन्‍छ्‌यागो” भिसी भिमाहेन्‍से येशू थेनीगदेदेन छ्‌याम धन्‍छ्‌याबाला लागिरी दिम न्‍हङरी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","येशू थेनीगदेदेन छ्‌याम सोल छ्‌योइबारी धन्‍छ्‌याजी। जमाहेन्‍से येशूसे गेङ छ्‌यारी थोसी धन्‍यवाद पिन्‍सी गेङ क्‍युइसी थेनीगदेदा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","जमाहेन्‍से थेनीगदेसे येशूदा ङोसेजी। तर थेनोन धुइरी थेनीगदेसे येशूदा थेरी आम्राङ्‌नी। ");
INSERT INTO taj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ओच्‍छे थेनीगदेसे “येशू य्‍हाङदेन छ्‌याम ग्‍यामरी ताम लबान परमेश्‍वरला बचन घोना लबा धुइरी य्‍हाङला सेम गाते ताङ्‍बा मुबा” भिसी ह्राङ ह्राङ न्‍हङरी ताम लजी। ");
INSERT INTO taj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","जमाहेन्‍से तुरुन्‍तन थेनीगदे यरूशलेमपट्टि निजी। थेरी धोमा थेनीगदेसे च्‍युक गिक चेलागदेदेन छ्‌याम पोप तसी चिबा म्‍हिगदेसे, ");
INSERT INTO taj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","“प्रभु सिबाग्‍याम सोबादेन सिमोन मुबा ग्‍लारी फेप्‍बा ताम चा पक्‍कान हिन्‍ना चीम” भिसी ताम लसी चिबा स्‍याप्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","जमाहेन्‍से थेन्‍नीसेएनोन ग्‍यामरी तबा तामदेन प्रभुसे गेङ क्‍युइबा धुइरी थेन्‍नीसे प्रभुदा ङोसेजी भिबा ताम थेरी मुबागदेदा पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","थेनीगदेसे चु ताम लबान लबा धुइरी येशू थेनीगदेला ङाच्‍छा राप्‍जी, ओच्‍छे “एनीगदेदा शान्‍ति तगै” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","तर येशूदा म्राङ्सी, “चु म्‍हङ कि तिग” भिसी थेनीगदे लोङ्सी आत्‍यब तजी। ");
INSERT INTO taj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","जमाहेन्‍से येशूसे थेनीगदेदा “एनीगदे तिग्‍दा सेमरी शङ्का लसी लोङ्‌बा? ");
INSERT INTO taj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","एनीगदेसे ङाला यादेन काङरी थुर्सी च्‍यागो, ङानोन हिन्‍ना। तिग्‍दा भिसम म्‍हङला स्‍यादेन नख्रु आत, तर ङाला मी मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","चुह्रङ् सुङ्माहेन्‍से येशूसे थेनीगदेदा ह्राङला छ्‍यादेन स्‍य्‍हाप उन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","जमाहेन्‍से थेनीगदे ताङ्सी उदेक तसी अझ येशूला ताम विश्‍वास आलनी। जमाहेन्‍से येशूसे थेनीगदेदा “एनीगदेदेन छ्‌याम तिगै चबा स्‍हे मुला?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","थेनीगदेसे दुम्‍बु गिक तार्ङाला स्‍या येशूदा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","थे तार्ङाला स्‍या तासी येशूसे थेनीगदेलान ङाच्‍छापट्टि छ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","जमाहेन्‍से येशूसे थेनीगदेदा “ङाला बारेरी परमेश्‍वरसे मोशादा पिन्‍बा ठिमरी, अगमवक्तागदेसे भ्रिबा किताबगदेदेन व्‍हाइला किताबरी भ्रिबा जम्‍मान ताम पूरा तबा मुला। चु ताम एनीगदेदेन छ्‌याम मुबा धुइरीन ङाइ एनीगदेदा पाङ्बा मुबा” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","जमाहेन्‍से येशूसे थेनीगदेदा परमेश्‍वरला बचन घोखम्‍बा ज्ञान पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ओच्‍छे येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “थार्बा पिन्‍बा ख्रीष्‍टसे दुख नातोःला ओच्‍छे सोमरेमाकुनु थे सिबाग्‍याम सोला, ");
INSERT INTO taj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","थेला मिनरी ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःजी भिसम पापला दोष मेटब तला। चु ताम यरूशलेमहेन्‍से जम्‍मान य्‍हुलला म्‍हिगदेदा थेःना लतोःला भिसी परमेश्‍वरला बचनरी भ्रिबा मुला। ");
INSERT INTO taj_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","तिग्‍दा भिसम चु जम्‍मान ताम म्राङ्बा एनीगदेन हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","च्‍यागो, ङाला आबासे पिन्‍ना भिसी कबुल लबा शक्ति ङाइ एनीगदे मुबा ग्‍लारी पुइखला। थेतबासेलमा तोरग्‍याम शक्ति आयाङ्‌तेधोना एनीगदे चु शहररीन चिउ।” ");
INSERT INTO taj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","जमाहेन्‍से येशूसे थेनीगदेदा बेथानियाधोना भोर्जी, ओच्‍छे ह्राङला या थीसी थेनीगदेदा मोलम पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","चुह्रङ् लसी मोलम पिन्‍माहेन्‍से येशूदा थेनीगदेग्‍याम फेसी स्‍वर्गरी भोर्जी। ");
INSERT INTO taj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","येशूदा फ्‍या लमाहेन्‍से थेनीगदे ताङ्सी यरूशलेमरी दोःसी निजी। ");
INSERT INTO taj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ओच्‍छे थेनीगदेसे परमेश्‍वरला जयजयकार लबान सदन परमेश्‍वरला मन्‍दिररी चिजी।");
INSERT INTO taj_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","जम्‍बुलिङ स्‍होबा भन्‍दा ङाच्‍छान बचन भिबा मुबा, थे बचन परमेश्‍वरदेन छ्‌याम मुबा, ओच्‍छे बचननोन परमेश्‍वर मुबा। ");
INSERT INTO taj_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","जम्‍बुलिङ स्‍होबा भन्‍दा ङाच्‍छाहेन्‍सेन थे परमेश्‍वरदेन छ्‌याम मुबा। ");
INSERT INTO taj_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","परमेश्‍वरसे जम्‍मान स्‍हे थेनोन बचनग्‍याम स्‍होजी। परमेश्‍वरसे स्‍होबा स्‍हेगदे न्‍हङ‍री बचनग्‍याम आस्‍होबा स्‍हे तिगैनोन आरे। ");
INSERT INTO taj_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","बचनसे स्‍होबा जम्‍मान स्‍हेगदेसे थेनोन बचनग्‍याम जुनी याङ्जी। थेनोन जुनी जम्‍मान म्‍हिगदेला य्‍हाल हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","थे य्‍हाल धोपधोपरी य्‍हाल य्‍हाल तला, ओच्‍छे धोपसे थे य्‍हालदा खाइमै साइबारी आखम। ");
INSERT INTO taj_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","परमेश्‍वरसे म्‍हि गिक पुइखबा मुबा, थेला मिन यूहन्‍ना मुबा। ");
INSERT INTO taj_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","थेग्‍यामसेन जम्‍मान म्‍हिगदेसे थे य्‍हालदा विश्‍वास लगै भिसी परमेश्‍वरसे थेदा थे य्‍हालला बारेरी पाङ्‌बाला लागिरी पुइखबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","थे चा थे य्‍हाल आहिन्‍बा मुबा। तर थे य्‍हालला बारेरी म्‍हिगदेदा घोना लबारी थे खबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","जम्‍मान म्‍हिगदेदा ज्ञान बुद्धि पिन्‍बा सत्‍य य्‍हाल चा जम्‍बुलिङरी फेप्‍खबान मुबा। ");
INSERT INTO taj_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","थे जम्‍बुलिङरी मुबा, जम्‍बुलिङ थेग्‍यामसेन स्‍होबा हिन्‍ना। तसैनोन जम्‍बुलिङला म्‍हिगदेसे थेदा ङोआसेनी। ");
INSERT INTO taj_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","थे ह्राङलान म्‍हिगदे मुबा ग्‍लारी फेप्‍खजी। तर थेदा ह्राङलान म्‍हिगदेसे मान आलनी। ");
INSERT INTO taj_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","तर जुन म्‍हिसे थेदा मान लसी थेथोरी विश्‍वास लजी, थेनीगदेदा थेसे परमेश्‍वरला सन्‍तान दोबा हक पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","थेनीगदे म्‍हिला सेमसे म्‍हन्‍बा अन्‍छार खजिबै म्‍हिला ल्‍हुइग्‍याम न्‍हबा आहिन। थेनीगदे परमेश्‍वरसे स्‍होबा परमेश्‍वरलान कोलागदे हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","चुनोन बचन म्‍हि दोसी न्‍हजी, ओच्‍छे दयामायादेन सत्‍यसे प्‍लिङ्‌सी थे य्‍हाङला गुङरी धन्‍छ्‌याजी। ङन्‍से थेला घ्रेन य्‍हालदेन शक्ति म्राङ्जी, थे य्‍हालदेन शक्ति परमेश्‍वरला गिकजेन झाला मुबा। ");
INSERT INTO taj_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","यूहन्‍नासे थेला बारेरी चुह्रङ् भिसी क्रिङ्बान पाङ्जी, “ङा भन्‍दा लिच्‍छा फेप्‍खबा चा ङा भन्‍दा घ्रेन म्‍हि हिन्‍ना। तिग्‍दा भिसम थे ङा भन्‍दा ङाच्‍छाहेन्‍सेन मुबा। थे म्‍हिला बारेरी ङाइ ङाच्‍छान पाङ्बा मुबा।” ");
INSERT INTO taj_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","थे दयामायासे प्‍लिङ्बा मुला। थेतबासेलमा थेग्‍यामसेन य्‍हाङसे दयामायाथोरी दयामाया याङ्बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","तिग्‍दा भिसम परमेश्‍वरसे य्‍हाङदा मोशाग्‍याम ठिम पिन्‍मुबा। तर येशू ख्रीष्‍टग्‍याम चा दयामायादेन सत्‍य ताम पिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","परमेश्‍वरदा खालैसेन खाइमै म्राङ्बा आरे। तर परमेश्‍वर आबादेन छ्‌याम मुबा थेला गिकजेन झा परमेश्‍वरसेन य्‍हाङदा परमेश्‍वर आबा खाह्रङ्बा मुला भिसी उन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","यरूशलेम शहरग्‍याम यहूदीगदेसे परमेश्‍वरला मन्‍दिररी पूजा लबागदेदेन लेवीगदेदा यूहन्‍ना मुबा ग्‍लारी थे खाल चीम? भिसी ङ्‌योइबारी पुइमा यूहन्‍नासे थेनीगदेदा चुह्रङ् भिसी पाङ्मुबा। ");
INSERT INTO taj_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","थेसे थेनीगदेदा “ङा थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍नोन आहिन” भिसी सत्‍य ताम पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","जमाहेन्‍से थेनीगदेसे यूहन्‍नादा “थेह्रङ् भिसम ए खाल हिन्‍ना? तिग ए एलिया हिन्‍ना” भिसी ङ्‌योइजी। तर यूहन्‍नासे “ङा आहिन” भिसी जोहाब पिन्‍जी। दोःसी थेनीगदेसे “तिग ए थेनोन अगमवक्ता हिन्‍ना?” भिसी ङ्‌योइमा, यूहन्‍नासे “ङा थे अगमवक्ताएनोन आहिन” भिसी जोहाब पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","जमाहेन्‍से दोःसीनोन थेनीगदेसे यूहन्‍नादा “ए खाल हिन्‍ना? ङन्‍दा पाङ्‍गो। ङन्‍दा चुरी पुइखबा म्‍हिगदेदा एला बारेरी पाङ्तोःबा मुला। थेतबासेलमा ए खाल हिन्‍ना? ङन्‍दा पाङ्‍गो” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","यूहन्‍नासे थेनीगदेदा “यशैया अगमवक्तासे पाङ्बा ह्रङ्नोन ‘परमप्रभु भ्रबाला लागिरी थेला ग्‍याम सोजो स्‍होउ’ भिसी तोङतोङबा ग्‍लारी क्रिङ्बा म्‍हि गिकला काइ ङानोन हिन्‍ना” भिसी पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","थेनीगदे न्‍हङला कोइ कोइ फरिसीगदेसे ");
INSERT INTO taj_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","यूहन्‍नादा “ए थार्बा पिन्‍बा ख्रीष्‍टएनोन आहिन, एलियाएनोन आहिन, ओच्‍छे थे अगमवक्ताएनोन आहिन भिसम तिग्‍दा बप्‍तिस्‍मा पिन्‍बा?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","जमाहेन्‍से यूहन्‍नासे थेनीगदेदा “ङाइ क्‍युइसे बप्‍तिस्‍मा पिन्‍बा मुला, तर एनीगदेला गुङरी खालै गिक मुला थेदा एनीगदेसे ङोसेबा आरे। ");
INSERT INTO taj_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ङा भन्‍दा लिच्‍छा फेप्‍खबा चा थेनोन हिन्‍ना। ङा थेला लखमला तुना ब्‍लबाधोनाला आरे” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","चु ताम यर्दन स्‍योङला क्‍याम्‍सङपट्टि बेथानिया भिबा नाम्‍सारी तबा मुबा, थेरीन यूहन्‍नासे म्‍हिगदेदा बप्‍तिस्‍मा पिन्‍बान मुबा। ");
INSERT INTO taj_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","न्‍हङगरदङ येशू ह्राङ मुबा ग्‍लारी फेप्‍खबान लबा म्राङ्सी यूहन्‍नासे चुह्रङ् भिजी, “च्‍यागो, जम्‍बुलिङरी मुबा जम्‍मान म्‍हिदा पापग्‍याम फेबा परमेश्‍वरसे पुइखबा ग्‍ले! ");
INSERT INTO taj_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","थेला बारेरी ङाइ ङाच्‍छान पाङ्बा मुबा, ‘ङा भन्‍दा लिच्‍छा म्‍हि गिक फेप्‍खबान मुला, थे ङा भन्‍दा शक्तिशाली मुला। तिग्‍दा भिसम थे ङा न्‍हबा भन्‍दा ङाच्‍छाहेन्‍सेन मुबा।’ ");
INSERT INTO taj_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","थे खाल हिन्‍ना भिबा ताम ङादा था आरेबा, तर इस्राएलीगदेसे थेदा ङोसेगै भिसीन ङाइ क्‍युइग्‍याम बप्‍तिस्‍मा पिन्‍बान खबा हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","यूहन्‍नासे अझ ह्राङसे म्राङ्बा ताम चुह्रङ् भिसी पाङ्जी, “ङाइ परमेश्‍वरला आत्‍मा ढुकुर ह्रङ् लसी स्‍वर्गग्‍याम फेप्‍खसी थेथोरी धन्‍छ्‌याबा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ङाइ अझ थेदा ङोसेबा आरेबा, तर क्‍युइग्‍याम बप्‍तिस्‍मा पिन्‍गो भिसी ङादा पुइखबासेन, ‘एसे जुन म्‍हिथोरी परमेश्‍वरला आत्‍मा फेप्‍खसी धन्‍छ्‌याबा म्राङ्ला, थेसेन परमेश्‍वरला आत्‍माग्‍याम बप्‍तिस्‍मा पिन्‍ना’ भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","थेथोरी परमेश्‍वरला आत्‍मा फेप्‍खबा ङाइ म्राङ्बा मुला। थेतबासेलमा ङाइ पाङ्बा चु ताम सत्‍य हिन्‍ना, परमेश्‍वरला झा चा थेनोन हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","दोःसी न्‍हङगरदङ यूहन्‍ना ह्राङला चेलागदे न्‍हङला न्‍हीदेन छ्‌याम राप्‍सी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","येशू फेप्‍बान लबा म्राङ्सी यूहन्‍नासे, “च्‍यागो, परमेश्‍वरसे पुइखबा ग्‍ले!” भिसी पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","चु ताम थेःसी यूहन्‍नाला चेला न्‍ही येशूला लिच्‍छा लिच्‍छा निजी। ");
INSERT INTO taj_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","येशूसे फ्‍लिक दोःसी स्‍हीमा, थेनीगदे लिच्‍छा लिच्‍छा खबान लबा म्राङ्सी येशूसे थेनीगदेदा “एनीगदेसे तिग म्‍हाइबा?” भिसी ङ्‌योइजी। जमाहेन्‍से थेनीगदेसे येशूदा “गुरु ह्राङ खानङ धन्‍छ्‌यामुला?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","येशूसे थेनीगदेदा “ङादेन छ्‌याम खउ, एनीगदेसे म्राङ्ला” भिसी सुङ्जी। जमाहेन्‍से थेनीगदे येशूदेन छ्‌याम निजी, ओच्‍छे येशू धन्‍छ्‌याबा ग्‍ला म्राङ्जी। जमाकुनु ओस्‍पन ङ्‍यसेला चार बजब तसी जिन्‍बासे लमा थेनीगदे येशूदेन छ्‌याम चिजी। ");
INSERT INTO taj_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","यूहन्‍नासे पाङ्बा ताम थेःसी येशूदेन छ्‌याम निबा थे चेला न्‍ही न्‍हङला गिक चा सिमोन पत्रुसला आले अन्‍द्रियास मुबा। ");
INSERT INTO taj_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","थेसे ङाच्‍छा ह्राङला ज्‍योज्‍यो सिमोनदा स्‍याप्‍सी, “ङन्‍से मसीहदा स्‍याप्‍जी,” भिसी पाङ्जी। हिब्रू ग्‍योइरी “मसीह” भिबा चा “थार्बा पिन्‍बा ख्रीष्‍ट” भिबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","थेसे सिमोनदा येशू मुबा ग्‍लारी भजी। येशूसे सिमोनदा स्‍हीसी, “ए योनाला झा सिमोन हिन्‍ना, एला मिन केफास हिन्‍ना” भिसी सुङ्जी। केफास भिबा चा ग्रीक ग्‍योइरी पत्रुस भिबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","न्‍हङगरदङ येशू गालील अञ्‍चलरी नितोःजी भिसी फेप्‍मा फिलिपदा स्‍याप्‍जी। ओच्‍छे येशूसे थेदा “ङादेन छ्‌याम भ्रउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","फिलिपएनोन पत्रुसदेन अन्‍द्रियासलान शहर बेथसेदाला मुबा। ");
INSERT INTO taj_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","जमाहेन्‍से फिलिप नथानेलदा ह्रुप तबारी निजी। ओच्‍छे नथानेलदा चुह्रङ् भिसी पाङ्जी, “मोशासे भ्रिबा ठिमदेन अगमवक्तागदेसे जुन म्‍हिला बारेरी पाङ्बा मुबा, ङन्‍से थे म्‍हिदा स्‍याप्‍बा मुला। थे योसेफला झा नासरतला येशू हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","नथानेलसे थेदा “तिग नासरतग्‍यामसेनोन तिगै ज्‍यबा स्‍हे खला?” भिसी ङ्‌योइमा, फिलिपसे थेदा “खसी च्‍यागो” भिसी जोहाब पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","नथानेल ह्राङ मुबा ग्‍लारी खबान लबा म्राङ्सी येशूसे थेला बारेरी “तिगै लुसीला ताम आलबा पक्‍का इस्राएलीदा च्‍यागो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","नथानेलसे येशूदा “ह्राङसे ङाला बारेरी खाह्रङ् लसी था याङ्जी?” भिसी ङ्‌योइमा, येशूसे थेदा “फिलिपसे एदा ङ्‌योइबारी निबा भन्‍दा ङाच्‍छान ङाइ एदा अञ्‍जीरला दोङ टारी म्राङ्मुबा” भिसी जोहाब पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","जमाहेन्‍से नथानेलसे येशूदा “रब्‍बी, ह्राङनोन परमेश्‍वरला झा इस्राएलला ग्‍ले हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","येशूसे थेदा “ङाइ एदा अञ्‍जीरला दोङ टारी म्राङ्जी भिबासे लमा एसे विश्‍वास लबा आहिन? एसे अझ चु भन्‍दान घ्रेन घ्रेन तामगदे म्राङ्ला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","दोःसी येशूसे थेनीगदेदा “च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, एनीगदेसे स्‍वर्ग ठोङ्बादेन परमेश्‍वरला दूतगदे परमेश्‍वरसे पुइखबा म्‍हिथोरी फाप्‍खबान लबा तोर निबान लबा म्राङ्ला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","सोमरेमाकुनु गालील अञ्‍चलला काना भिबा नाम्‍सारी ब्‍याह गिक मुबा। थेरी येशूला आमाएनोन मुबा। ");
INSERT INTO taj_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","थे ब्‍याहरी येशूदेन येशूला चेलागदेदाएनोन निम्‍तो पिन्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","अङगुरला निङगु जिन्‍माहेन्‍से येशूला आमासे येशूदा “थेनीगदेदेन छ्‌याम अङगुरला निङगु आरे” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","चु ताम थेःसी येशूसे “चु य्‍हाङला गे आहिन। ङाइ गे लबा धुइ अझ तबा आरे” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","जमाहेन्‍से येशूला आमासे नोकरगदेदा “येशूसे एनीगदेदा जे लउ भिसी कुल्‍ला, थेनोन लउ” भिसी पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ओच्‍छे थेरी युङबा ठ्वाइसी स्‍होबा ओस्‍पन बोगल ब्‍लिहेन्‍से ग्‍यार्जा गिक लिटर क्‍युइ वाङ्बा गोर ढु युङबाला फुम्‍बा मुबा। थे फुम्‍बारी चा यहूदीगदेला ठिम अन्‍छार चोख्‍याब लबाला लागिरी क्‍युइ थान्‍मुबा। ");
INSERT INTO taj_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","येशूसे थेरी मुबा नोकरगदेदा “चु जम्‍मान फुम्‍बारी क्‍युइ प्‍लिङ्‍ना लउ” भिसी कुल्‍जी। जमाहेन्‍से थेनीगदेसे थे जम्‍मान फुम्‍बा नाङ नाङ क्‍युइ प्‍लिङ्‍ना लजी। ");
INSERT INTO taj_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ओच्‍छे येशूसे थेनीगदेदा “चु जजाकर भोर्सी भोजला मुल म्‍हिदा म्‍य्‍हाङ्पुङ्‍गो” भिसी कुल्‍जी। जमाहेन्‍से थेनीगदेसे भोर्सी मुल म्‍हिदा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","मुल म्‍हिसे म्‍य्‍हाङ्बा धुइरी थे क्‍युइ अङगुरला निङगु दोसी जिन्‍बा मुबा। थेदा थे निङगु खानङग्‍याम भजी भिबा ताम था आरेबा, तर थे क्‍युइ युबा नोकरगदेदा चा था मुबा। जमाहेन्‍से थे मुल म्‍हिसे म्‍हाछारदा ङ्‌योइसी, ");
INSERT INTO taj_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“जम्‍मान म्‍हिसे ङाच्‍छा अङगुरला ज्‍यबा निङगु पिन्‍मुला। ओच्‍छे डोन्‍बोगदे ङ्‍योइमाहेन्‍से लिच्‍छा अङगुरला आज्‍यबा निङगु पिन्‍मुला। तर एसे मी दान्‍दे धोनान ज्‍यबा निङगु पिन्‍बान मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","येशूसे लबा उदेकला गेगदे न्‍हङ‍री गालील अञ्‍चलला काना भिबा नाम्‍सारी लबा उदेकला गे चा जम्‍मान भन्‍दा ङाच्‍छा लबा हिन्‍ना। चु उदेकला चिनुग्‍याम येशूसे ह्राङला शक्ति उन्‍जी। चु म्राङ्सी थेला चेलागदेसे थेदा विश्‍वास लजी। ");
INSERT INTO taj_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","जमाहेन्‍से येशू ह्राङला आमा, आले, चेलागदेदेन छ्‌याम कफर्नहुम भिबा शहररी फेप्‍जी। ओच्‍छे तिगै धिनधोना थेनीगदे थेरीन धन्‍छ्‌याजी। ");
INSERT INTO taj_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","यहूदीगदेसे मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाड खबारी छ्‌याइबा मुबा। थे धुइरी येशू यरूशलेमरी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","येशूसे म्‍हिगदेदा परमेश्‍वरला मन्‍दिररी ग्‍यु, बहर, ढुकुर चूङ्बा किन्‍बा लबादेन टेबुलरी टाङगा थान्‍सी टाङगा देप्‍सी चिबा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","जमाहेन्‍से येशूसे छोला कोर्रा स्‍होसी मन्‍दिररी मुबा ग्‍युगदेदेन बहरगदे जम्‍मादान ताप्‍जी, ओच्‍छे टाङगा देप्‍सी चिबागदेला टाङगागदे भ्‍याङ्‍सी टेबुल प्‍लाङ प्‍लिङ लसी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ढुकुर चूङ्बागदेदा येशूसे “चु जम्‍मान स्‍हे चुग्‍याम भोर्गो। ङाला आबाला दिमदा व्‍यापार लबा दिम थास्‍होउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","थे धुइरी येशूला चेलागदेसे परमेश्‍वरला बचनरी, “परमेश्‍वर! ह्राङला दिमला लागिरी ङाइ लबा मायासे लमा ङा सिबा तेबान तबा मुला” भिसी भ्रिबा ताम ढन्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","यहूदी नेतागदेसे येशूदा “ह्राङदा चु गे लबाला लागिरी अधिकार मुबा हिन्‍सम ङन्‍दा ह्राङसे तिग चिनु उन्‍बारी खम्‍ला?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","येशूसे थेनीगदेदा “एनीगदेसे चु मन्‍दिर फुप्‍गो, ङाइ चु सोमरेरी स्‍होला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","जमाहेन्‍से यहूदी नेतागदेसे येशूदा “परमेश्‍वरला चु मन्‍दिर स्‍होबारी ङन्‍दा बोगल न्‍हीसे ढु दिङ लगब तजी भिसम ह्राङसे चा खाह्रङ् लसी सोमरेरी स्‍होखम्‍ला?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","तर येशूसे जुन मन्‍दिरला बारेरी सुङ्बा मुबा, थे मन्‍दिर चा ह्राङलान ल्‍हुइ मुबा। ");
INSERT INTO taj_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","येशू सिबाग्‍याम सोमाहेन्‍से येशूसे सुङ्बा चु ताम चेलागदेसे ढन्‍जी। जमाहेन्‍से थेनीगदेसे परमेश्‍वरला बचनरी भ्रिबा तामदेन येशूसे सुङ्बा तामरी विश्‍वास लजी। ");
INSERT INTO taj_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाडला धुइरी येशू यरूशलेमरी मुबा। थेरी येशूसे लबा उदेकला गे म्राङ्सी ल्‍हानान म्‍हिगदेसे येशूदा विश्‍वास लजी। ");
INSERT INTO taj_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","तर थेनीगदेसे लबा विश्‍वासदा येशूसे पत्‍याब आतनी। तिग्‍दा भिसम जम्‍मान म्‍हिगदेला सेमला ताम येशूदा था मुबा। ");
INSERT INTO taj_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","जम्‍मान म्‍हिला सेमला ताम था मुबासे लमा खालै म्‍हिला बारेरी येशूदा खालैसेन पाङ्तोःबा आरेबा। ");
INSERT INTO taj_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","फरिसीगदे न्‍हङला निकोदेमस भिबा म्‍हि गिक मुबा। थे यहूदी नेतागदे न्‍हङला गिक मुबा। ");
INSERT INTO taj_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","थे तिरेकुनु म्‍हुनङ येशू मुबा ग्‍लारी निसी येशूदा “गुरु, ह्राङ ङन्‍दा लोप्‍बारी परमेश्‍वरग्‍याम फेप्‍खबा हिन्‍ना भिबा ङन्‍दा था मुला। तिग्‍दा भिसम परमेश्‍वरसे ह्रो आलनी भिसम ह्राङसे लबा ह्रङ्‌बा शक्तिशाली गेगदे खालैसेन लबारी आखम” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","येशूसे थेदा “च्‍यागो, एसे ङाला ताम ङ्‌यान्‍गो, खालै म्‍हि तोरग्‍याम आन्‍हतेधोना परमेश्‍वरला य्‍हुल्‍सादा म्राङ्बारी आखम” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","चु ताम थेःसी निकोदेमससे येशूदा “खेप्‍बा दोसीनोन म्‍हि खाह्रङ् लसी दोःसी न्‍हबारी खम्‍ला? तिग थे दोःसी आमाला फो न्‍हङ‍री वाङ्सी न्‍हबारी खम्‍ला?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","जमाहेन्‍से येशूसे थेदा चुह्रङ् भिसी सुङ्जी, “च्‍यागो, एसे ङाला ताम ङ्‌यान्‍गो, खालै म्‍हि क्‍युइदेन आत्‍माग्‍याम आन्‍हतेधोना परमेश्‍वरला य्‍हुल्‍सारी वाङ्‌आम्‍याङ्। ");
INSERT INTO taj_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ल्‍हुइग्‍याम न्‍हबा ल्‍हुइ हिन्‍ना, तर परमेश्‍वरला आत्‍माग्‍याम न्‍हबा आत्‍मा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ङाइ एदा तोरग्‍याम न्‍हतोःला भिसी पाङ्‌मा ए उदेक थातउ। ");
INSERT INTO taj_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","लाबा खानङपट्टि निम्‍हन्‍जी थेनोनपट्टि निमुला। लाबा खबा एसे था याङ्मुला, तर थे खानङग्‍याम खजी खानङपट्टि निजी भिबा एदा था आरे। परमेश्‍वरला आत्‍माग्‍याम न्‍हबा म्‍हिगदेएनोन थेह्रङ्बान तमुला।” ");
INSERT INTO taj_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","निकोदेमससे येशूदा “चु खाह्रङ् लसी तखम्‍ला?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","जमाहेन्‍से येशूसे थेदा चुह्रङ् भिसी सुङ्जी, “ए इस्राएलीगदेला गुरु तसीनोन चु ताम आघोनी? ");
INSERT INTO taj_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","च्‍यागो, एसे ङाला ताम ङ्‌यान्‍गो, ङन्‍से मी ह्राङसे म्राङ्बा तामदेन था याङ्बा ताम जे पाङ्‌मुला। तर ङन्‍से पाङ्बा ताम एनीगदेसे विश्‍वास आलमुला। ");
INSERT INTO taj_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ङाइ जम्‍बुलिङरी मुबा स्‍हेला बारेरी पाङ्‌मा मी एनीगदेसे विश्‍वास आलमुला भिसम स्‍वर्गला बारेरी पाङ्‌मा एनीगदेसे खाह्रङ् लसी विश्‍वास लबारी खम्‍ला? ");
INSERT INTO taj_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“स्‍वर्गग्‍याम खबा परमेश्‍वरसे पुइखबा म्‍हि बाहेक स्‍य्‍हान्‍दो खालैनोन स्‍वर्गरी निबा आरे। ");
INSERT INTO taj_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","यहूदीगदे तोङतोङबा ग्‍लारी मुबा धुइरी मोशासे पित्तलला पुख्री स्‍होसी सिङरी ठोक्‍सी च्‍योबा ह्रङ् परमेश्‍वरसे पुइखबा म्‍हिदाएनोन च्‍योला। ");
INSERT INTO taj_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ओच्‍छे जुन जुन म्‍हिसे थेदा विश्‍वास लला, थेनीगदेसे जुकजुकधोनाला जुनी याङ्ला। ");
INSERT INTO taj_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“तिग्‍दा भिसम परमेश्‍वरसे जम्‍बुलिङदा ल्‍हानान माया लसी ह्राङला गिक जेन झा पुइखजी। थेदा विश्‍वास लबागदे खालै नाश थातगै, तर जुकजुकधोनाला जुनी याङ्‌गै भिसीन चुह्रङ् लबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","तिग्‍दा भिसम परमेश्‍वरसे ह्राङला झादा जम्‍बुलिङदा सजाय पिन्‍बारी पुइखबा आहिन। तर थेग्‍याम जम्‍बुलिङसे थार्बा याङ्‌गै भिसी पुइखबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","जुन म्‍हिसे परमेश्‍वरला झाथोरी विश्‍वास लला, थेला दोष आउन। तर विश्‍वास आलबा म्‍हिला चा ङाच्‍छान दोष उन्‍सी जिन्‍बा तला। तिग्‍दा भिसम थेसे परमेश्‍वरला झादा विश्‍वास आलनी। ");
INSERT INTO taj_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","दोषी खाह्रङ् लसी तला भिसम य्‍हाल जम्‍बुलिङरी खसी जिन्‍सैनोन म्‍हिगदेदा य्‍हाल भन्‍दा धोपधोपनोन सेम निजी। तिग्‍दा भिसम थेनीगदेसे लबा गेनोन आज्‍यबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","आज्‍यबा गे लबागदेसे य्‍हालदा हेला लमुला। तिग्‍दा भिसम य्‍हालरी खमाहेन्‍से थेनीगदेसे लबा आज्‍यबा गे जम्‍मासेन म्राङ्ला भिसी थेनीगदे य्‍हालरी आखबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","तर थेसे लबा जम्‍मान गे परमेश्‍वरदेन छ्‌याम गिक तसी लबा हिन्‍ना भिसी जम्‍मासेन म्राङ्‍गै भिसी सत्‍य तामदा तेन्‍बा म्‍हि य्‍हालरी खबा हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","जमाहेन्‍से येशू ह्राङला चेलागदेदेन छ्‌याम यहूदिया अञ्‍चलरी फेप्‍सी तिगै धिनना लागिरी थेनीगदेदेन छ्‌याम थेरी धन्‍छ्‍याबा धुइरी म्‍हिगदेदा बप्‍तिस्‍मा पिन्‍बान मुबा। ");
INSERT INTO taj_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","यूहन्‍नासेनोन सालीम भिबा ग्‍लाला ङामरी मुबा एनोन भिबा ग्‍लारी बप्‍तिस्‍मा पिन्‍बान मुबा। तिग्‍दा भिसम थेरी ल्‍हानान क्‍युइ मुबा, ओच्‍छे म्‍हिगदे थेरी खसी बप्‍तिस्‍मा किन्‍बान मुबा। ");
INSERT INTO taj_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","थे धुइधोना यूहन्‍ना झ्‍याल्‍खानरी परब तबा आरेमुबा। ");
INSERT INTO taj_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","थेनोन धुइरी यूहन्‍नाला चेलागदे यहूदी गिकदेन छ्‌याम चोखो तबाला बारेरी ताम लबान मुबा। ");
INSERT INTO taj_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","जमाहेन्‍से थेनीगदे यूहन्‍ना मुबा ग्‍लारी खसी, “गुरु, यर्दन क्‍याम्‍सङ मुबा धुइरी ह्राङसे ङन्‍दा म्‍हि गिकला बारेरी सुङ्मुबा, थे म्‍हि ह्राङदेन छ्‌यामनोन मुबा। दान्‍दे थेसेनोन बप्‍तिस्‍मा पिन्‍बान मुला, ओच्‍छे जम्‍मान म्‍हिगदे थे मुबा ग्‍लारी निबान मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","यूहन्‍नासे थेनीगदेदा चुह्रङ् भिसी जोहाब पिन्‍जी, “परमेश्‍वरसे आपिन्‍तेधोना म्‍हिसे तिगै स्‍हे आयाङ्। ");
INSERT INTO taj_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‘ङा थार्बा पिन्‍बा ख्रीष्‍ट आहिन, तर थे भन्‍दा ङाच्‍छा पुइखबा म्‍हि जे हिन्‍ना’ भिसी ङाला बारेरी पाङ्बा ताम एनीगदेदान था मुला। ");
INSERT INTO taj_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","जुन म्‍हिदेन छ्‌याम चाङछार चिला थेनोन म्‍हाछार हिन्‍ना। म्‍हाछारदेन छ्‌याम राप्‍बा म्‍हि म्‍हाछारला काइ थेःसी ल्‍हानान ताङ्मुला। थेह्रङ् लसीन ङाएनोन ल्‍हानान ताङ्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","दाहेन्‍से ख्रीष्‍ट चा बढब तबान नितोःला, तर ङा चा घटब तबान नितोःला। ");
INSERT INTO taj_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“तोरग्‍याम फेप्‍खबा चा जम्‍मान भन्‍दा घ्रेन मुला। जम्‍बुलिङरी न्‍हबा म्‍हिगदे चा जम्‍बुलिङलान हिन्‍ना, ओच्‍छे जम्‍बुलिङलान ताम लमुला। तर स्‍वर्गग्‍याम फेप्‍खबा चा जम्‍मान भन्‍दा घ्रेन मुला। ");
INSERT INTO taj_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","थेसे ह्राङसे म्राङ्बादेन थेःबा तामनोन सुङ्मुला, तर थेला ताम खालैसेन विश्‍वास आलमुला। ");
INSERT INTO taj_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","जुन म्‍हिसे थेला तामदा विश्‍वास लला, थेसे चा परमेश्‍वर सत्‍य हिन्‍ना भिबा तामला प्रमाण उन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","परमेश्‍वरसे पुइखबा म्‍हिसे परमेश्‍वरलान ताम पाङ्ला। तिग्‍दा भिसम परमेश्‍वरसे थेदा ह्राङला पूरान आत्‍मा पिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","परमेश्‍वरसे ह्राङला झादा माया लबा मुला, ओच्‍छे थेदा जम्‍मानथोरी शासन लबा अधिकार पिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","थेतबासेलमा जुन म्‍हिसे परमेश्‍वरला झादा विश्‍वास लला थेसे जुकजुकधोनाला जुनी याङ्ला। तर जुन म्‍हिसे परमेश्‍वरला झासे कुल्‍बा ताम आङ्‌यान थेसे जुकजुकधोनाला जुनी आयाङ्। बरु थेसे परमेश्‍वरग्‍याम खबा सजाय नातोःला।” ");
INSERT INTO taj_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","यूहन्‍नासे भन्‍दा येशूसे ल्‍हानान चेलागदे स्‍होबा मुला, ओच्‍छे बप्‍तिस्‍माएनोन पिन्‍बान मुला भिसी फरिसीगदेसे थेःजी भिबा ताम येशूदा था मुबा। ");
INSERT INTO taj_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","बप्‍तिस्‍मा पिन्‍बा चा चेलागदेसे पिन्‍मुबा तर येशू ह्राङसेन चा आहिन मुबा। ");
INSERT INTO taj_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","फरिसीगदेसे थेःबा ताम था याङ्माहेन्‍से येशू यहूदिया अञ्‍चल ख्‍लासी गालील अञ्‍चलरी दोःसी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","येशू गालील अञ्‍चलरी फेप्‍मा सामरिया अञ्‍चलग्‍याम फेप्‍तोःमुबा। ");
INSERT INTO taj_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","थेतबासेलमा येशू सामरिया अञ्‍चलला सुखार भिबा शहररी धोखजी। चु शहर चा याकूबसे ह्राङला झा योसेफदा पिन्‍बा बुला ङामरी मुबा। ");
INSERT INTO taj_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","थेरी याकूबला इनार मुबा। भ्रना भ्रना ब्‍लप्‍बासे लमा येशू थे इनारला कुनीरी धन्‍छ्‌याबा मुबा। थे धुइरी ओस्‍पन धिनी गङसल तबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","थेनोन धुइरी सामरी य्‍हुलला म्रिङम्‍हेमे गिक थे इनाररी क्‍युइ किन्‍बारी खजी। येशूसे थेदा “ङादा क्‍युइ थुङ्बारी भउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","येशूला चेलागदे चा चबा स्‍हे ग्‍लुबारी शहररी निबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","सामरी य्‍हुलला म्रिङम्‍हेमेसे येशूदा “ह्राङ यहूदी य्‍हुलला म्‍हि तसीनोन ङा ह्रङ्‌बा सामरी य्‍हुलला म्रिङम्‍हेमेदेन छ्‌याम तिग्‍दा क्‍युइ ह्रीबा?” भिसी भिजी। तिग्‍दा भिसम यहूदीगदेसे सामरीगदेदेन छ्‌याम संगतनोन आलमुबा। ");
INSERT INTO taj_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","येशूसे थेदा “एसे परमेश्‍वरसे पिन्‍बा मोलमदेन दान्‍दे एदेन छ्‌याम क्‍युइ ह्रीबा म्‍हिदा ङोसेबा हिन्‍सम एसे थे म्‍हिदेन छ्‌याम क्‍युइ ह्रीसेला मुबा। जमाहेन्‍से थे म्‍हिसे एदा जुकजुकधोनाला जुनी याङ्बा क्‍युइ पिन्‍सेला मुबा” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","थे म्रिङम्‍हेमेसे येशूदा “लास्‍सो, ह्राङदेन छ्‌याम क्‍युइ तेःबारी ताङ आरे, ओच्‍छे इनारएनोन नुप्‍बा मुला। ह्राङसे खानङग्‍याम थे जुकजुकधोनाला जुनी याङ्बा क्‍युइ भला? ");
INSERT INTO taj_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","तिग ह्राङ ङन्‍ना म्‍हेमे याकूब भन्‍दा घ्रेन हिन्‍ना? थेसेन ङन्‍दा चु इनार स्‍होसी पिन्‍बा हिन्‍ना। थेदेन थेला सन्‍तानसे ओच्‍छे थेला म्‍हे मुइगदेसेनोन चुनोन इनारला क्‍युइ थुङ्मुबा” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","जमाहेन्‍से येशूसे थेदा चुह्रङ् भिसी सुङ्जी, “चु क्‍युइ थुङ्बा म्‍हिगदेदा दोःसी क्‍युइ फुइला। ");
INSERT INTO taj_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","तर जुन जुन म्‍हिसे ङाइ पिन्‍बा क्‍युइ थुङ्ला थे म्‍हिदा दोःसी क्‍युइ आफुइ। ङाइ थेदा जुन क्‍युइ पिन्‍ना, थे क्‍युइ चा थेला लागिरी जुकजुकधोनाला जुनी पिन्‍बा क्‍युइला मुहान दोला!” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","थे म्रिङम्‍हेमेसे येशूदा “लास्‍सो, ङादाएनोन थे क्‍युइ भउ, थेह्रङ् भिसम ङादा दोःसी क्‍युइ आफुइ ओच्‍छे चुधोना क्‍युइ किन्‍बारीनोन खआतोः” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","जमाहेन्‍से येशूसे थेदा “निउ, एला ह्रेम्‍बोदा ङ्‌योइसी भउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","थेसे “ङाला ह्रेम्‍बो आरे” भिसी भिजी। तर येशूसे थेदा “एसे ङाला ह्रेम्‍बो आरे भिसी भिबा ठीक हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","तिग्‍दा भिसम एला गोर ङा ह्रेम्‍बो तसी जिन्‍बा मुला। दान्‍दे ए जुन म्‍हिदेन छ्‌याम चिबा मुला, थे म्‍हि एला ह्रेम्‍बो आहिन। एसे पाङ्बा ताम सत्‍य हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","जमाहेन्‍से थे म्रिङम्‍हेमेसे, “लास्‍सो, ह्राङ अगमवक्ता हिन्‍बा चीम भिसी ङाइ था याङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ङन्‍ना आखे म्‍हेमेगदेसे चु गङरी परमेश्‍वरदा तेन्‍जी, तर ह्राङनी यहूदीगदेसे चा परमेश्‍वरदा तेन्‍बा ग्‍ला यरूशलेम जे हिन्‍ना भिसी सुङ्मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","येशूसे थे म्रिङम्‍हेमेदा चुह्रङ् भिसी सुङ्जी, “एसे ङादा विश्‍वास लउ, दाहेन्‍से खालैनोन परमेश्‍वरदा तेन्‍बारी चु गङरीदेन यरूशलेमरी निआतोःबा धुइ खबान मुला। ");
INSERT INTO taj_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","एनी सामरीगदेसे आसेनान परमेश्‍वरदा तेन्‍जी, तर ङनी यहूदीगदेसे चा सेसी तेन्‍जी। तिग्‍दा भिसम थार्बा याङ्बा चा यहूदीगदे न्‍हङ‌ग्‍यामनोन तला। ");
INSERT INTO taj_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","तर चुह्रङ्बा धुइएनोन खबान मुला, थे धुइ चा चुनोन हिन्‍ना, सेसी सेमहेन्‍सेन परमेश्‍वरदा तेन्‍बा म्‍हिगदेसे चा सत्‍यदेन आत्‍माग्‍याम परमेश्‍वर आबादा तेन्‍मुला। परमेश्‍वर आबासे चुह्रङ् लसी तेन्‍बा म्‍हिगदे म्‍हाइमुला। ");
INSERT INTO taj_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","तिग्‍दा भिसम परमेश्‍वर आत्‍मा हिन्‍ना। थेतबासेलमा थेदा तेन्‍बागदेसे सत्‍यदेन आत्‍माग्‍याम तेन्‍तोःला।” ");
INSERT INTO taj_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","जमाहेन्‍से थे म्रिङम्‍हेमेसे येशूदा “थार्बा पिन्‍बा ग्‍ले फेप्‍खला भिबा ताम ङादाएनोन था मुला, थेदा ‘थार्बा पिन्‍बा ख्रीष्‍ट’ भिसी भिला। थे फेप्‍खमाहेन्‍से थेसेन ङन्‍दा जम्‍मान ताम घोना लला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","येशूसे थेदा “एदेन छ्‌याम ताम पाङ्बा म्‍हि, ङा थेनोन हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","थे धुइरी येशूला चेलागदेएनोन थेरी धोखजी। येशू म्रिङम्‍हेमे गिकदेन छ्‌याम ताम लसी चिबा म्राङ्सी थेनीगदे उदेक तजी। तर “ह्राङसे तिग म्‍हाइबा?” अथवा “ह्राङ थे म्रिङम्‍हेमेदेन छ्‌याम तिग्‍दा ताम लबा” भिसी खालैसेन आङ्‍योइनी। ");
INSERT INTO taj_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","जमाहेन्‍से थे म्रिङम्‍हेमे दर्बुङ थेरीन ख्‍लासी नाम्‍सापट्टि निसी म्‍हिगदेदा, ");
INSERT INTO taj_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“म्‍हि गिकदा च्‍याबारी खउ, ङाइ लबा जम्‍मान गे थेसे ङादा पाङ्जी। थेनोन थार्बा पिन्‍बा ख्रीष्‍ट मी आहिन?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","चु ताम थेःसी शहरला जम्‍मान म्‍हिगदे येशूदा च्‍याबारी थेरी खजी। ");
INSERT INTO taj_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","थेनोन धुइरी चेलागदेसे येशूदा “रब्‍बी, सोल छ्‍योइगो” भिसी बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","तर येशूसे थेनीगदेदा “ङादेन छ्‌याम चबा स्‍हे मुला, थे ताम एनीगदेदा थानोन आरे” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","थेतबासेलमा चेलागदेसे “खालैसे येशूदा सोल भसी पिन्‍जी कि तिग?” भिसी ह्राङ ह्राङ न्‍हङ‍री ताम लजी। ");
INSERT INTO taj_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “ङादा पुइखबासे कुल्‍बा ताम ङ्‌यान्‍सी थेला गे पूरा लबान ङाला चबा स्‍हे हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","एनीगदेसे ‘बाली मिन्‍बारी अझ ला ब्‍लि बाँकी मुला भिसी भिमुला।’ तर एनीगदेसे ङाला ताम ङ्‌यान्‍गो, बु वारीरी च्‍यागो, बाली मिन्‍सी दुइबा धुइ तसी जिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","जुन म्‍हिसे बाली दुइबान मुला, थेसे ज्‍यला याङ्बान मुला। ओच्‍छे जुकजुकधोनाला जुनी याङ्बा बाली ह्रुप लबान मुला। ओच्‍छे ब्‍लु ढ्‍वबादेन बाली दुइबा न्‍हीनोन ताङ्म्‍याङ्ला। ");
INSERT INTO taj_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","तिग्‍दा भिसम चु ताम सत्‍य हिन्‍ना। ‘गिकसे ब्‍लु ढ्वला, ओच्‍छे स्‍य्‍हान्‍दोसे बाली दुइला।’ ");
INSERT INTO taj_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ङाइ एनीगदेदा एनीगदेसे ब्‍लुनोन आढ्‍वबा ग्‍लारी बाली दुइबारी पुइजी। स्‍य्‍हान्‍दोसे दुख लसी ब्‍लु ढ्वबा ग्‍लारी एनीगदेसे बाली दुइम्‍याङ्बा मुला।” ");
INSERT INTO taj_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","“ङाइ लबा जम्‍मान गे थेसे ङादा सुङ्जी” भिसी थे सामरी म्रिङम्‍हेमेसे पाङ्बासे लमा थे नाम्‍साला ल्‍हानान सामरीगदेसे येशूदा विश्‍वास लजी। ");
INSERT INTO taj_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","थेनीगदे येशू मुबा ग्‍लारी खसी येशूदा “ह्राङ ङन्‍देन छ्‌याम धन्‍छ्‌यागो” भिसी बिन्‍ती लजी। जमाहेन्‍से येशू थेनीगदेदेन छ्‌याम न्‍हीरेधोना धन्‍छ्‌याजी। ");
INSERT INTO taj_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","येशूला ताम थेःसी झन ल्‍हानान सामरीगदेसे येशूदा विश्‍वास लजी। ");
INSERT INTO taj_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","थेनीगदेसे थे म्रिङम्‍हेमेदा “दान्‍दे एसे पाङ्बा ताम थेःसी जे ङन्‍से विश्‍वास लबा आहिन, तर ङन्‍सेन येशूला ताम थेःसी विश्‍वास लबा हिन्‍ना। ओच्‍छे पक्‍कान जम्‍बुलिङला जम्‍मान म्‍हिदा थार्ना लबा थेनोन हिन्‍ना भिसी ङन्‍से था याङ्जी” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","थे ग्‍लारी न्‍हीरेधोना धन्‍छ्‌यासी येशू गालील अञ्‍चलरी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","अगमवक्तादा ह्राङलान नाम्‍सारी मान आल भिसी येशूसेन सुङ्बा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","येशू गालील अञ्‍चलरी धोखमाहेन्‍से थे ग्‍लाला म्‍हिगदेसे येशूदा मान लजी। तिग्‍दा भिसम मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाडला धुइरी येशूसे यरूशलेम शहररी लबा जम्‍मान उदेकला गेगदे थेनीगदेसे म्राङ्बा मुबा। थे धुइरी थेनीगदेएनोन यरूशलेम शहररी चाड धङ्‍बारी निबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","दोःसी येशू गालील अञ्‍चलला काना भिबा शहररी फेप्‍जी। थेनोन शहररी येशूसे क्‍युइदा अङगुरला निङगु दोना लबा मुबा। कफर्नहुम शहररी चिबा हाकिम गिकला झा ल्‍हानान आखम्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","येशू यहूदिया अञ्‍चलग्‍याम गालील अञ्‍चलरी फेप्‍खजी भिबा ताम थेःसी थे हाकिम येशू मुबा ग्‍लारी खजी। ओच्‍छे थेसे ह्राङ फेप्‍खसी ङाला झादा खम्‍ना लसी पिन्‍गो भिसी बिन्‍ती लजी। तिग्‍दा भिसम थेला झा ल्‍हानान आखम्‍ना सिबारीन छ्‌याइबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","थेतबासेलमा येशूसे थेदा “उदेकला गेदेन चिनु आम्राङ्तेधोना एनीगदेसे खाइमै विश्‍वास आल” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","थे हाकिमसे येशूदा “लास्‍सो, ङाला झा सिबा भन्‍दा ङाच्‍छान ह्राङ फेप्‍खउ” भिसी पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","येशूसे थेदा “निउ, दाहेन्‍से एला झा सोला” भिसी सुङ्जी। जमाहेन्‍से येशूसे सुङ्बा तामरी विश्‍वास लसी थे दिमरी निजी। ");
INSERT INTO taj_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ओच्‍छे थे ग्‍यामरी निबान लमा थेला नोकरगदे खसी, “ह्राङला झा खम्‍जी” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","जमाहेन्‍से थेसे नोकरगदेदा “थे गाते धुइहेन्‍से खम्‍जी?” भिसी ङ्‌योइमा, थेनीगदेसे “तिल्‍मा धिनना एक बजेहेन्‍से थेला छवा म्‍हाजी” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","चु ताम थेःमाहेन्‍से येशूसे थेदा “एला झा सोला” भिसी सुङ्बा धुइरीन खम्‍जी भिबा ताम थेसे था याङ्जी। थेतबासेलमा थेदेन थेला म्‍हेमेक्‍योङ्सेन येशूदा विश्‍वास लजी। ");
INSERT INTO taj_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","चु गे चा यहूदिया अञ्‍चलग्‍याम गालील अञ्‍चलरी फेप्‍खसी येशूसे लबा अर्गु उदेकला गे हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","जमाहेन्‍से यहूदीगदेला चाडला धुइरी येशू यरूशलेमरी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","यरूशलेम शहर न्‍हङ‍री निबारी ग्‍यु भिबा म्राप मुबा। थे म्रापला ङामरी गोर ङा दलान मुबा घ्‍योइ गिक मुबा। थे घ्‍योइदा हिब्रू ग्‍योइरी बेथेसदा भिसी भिमुबा। ");
INSERT INTO taj_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","थे दलानरी आखम्‍बा ल्‍हानान म्‍हिगदे, मी आम्राङ्बा म्‍हि, कुज्‍या म्‍हिदेन काङ या चलब आतबा म्‍हि चिमुबा। थे घ्‍योइला क्‍युइ गाते धुइरी ल्‍हिङ्‍ला भिसी थेनीगदे जम्‍मासेन च्‍यासी चिमुबा। ");
INSERT INTO taj_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","तिग्‍दा भिसम धुइ धुइरी परमप्रभुला दूत गिक मार खसी थे घ्‍योइला क्‍युइ ल्‍हिङ्सी पिन्‍मुबा। घ्‍योइरी क्‍युइ ल्‍हिङ्मैछ्‍याम जुन म्‍हि ङाच्‍छा घ्‍योइरी वाङ्‌जी थे म्‍हि जस्‍तोन आखम्‍बा मुसैनोन थे खम्‍मुबा। ");
INSERT INTO taj_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","थेरी बोगल गिकसे च्‍युक भ्रेः दिङधोना आखम्‍बा म्‍हि गिकएनोन मुबा। ");
INSERT INTO taj_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","येशूसे थे थेरीन म्‍हेर्सी चिबा म्राङ्जी। ओच्‍छे थे ल्‍हानान दिङहेन्‍से आखम्‍बा चीम भिबा था याङ्सी येशूसे थेदा “तिग एदा खम्‍बा सेम मुला?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","थे आखम्‍बा म्‍हिसे, “लास्‍सो, घ्‍योइला क्‍युइ ल्‍हिङ्बा धुइरी ङादा घ्‍योइरी झाङ्‌सी पिन्‍बा ङाला खालै आरे। थेतबासेलमा ङा घ्‍योइरी वाङ्बारी निना निनान ङा भन्‍दा ङाच्‍छा स्‍य्‍हान्‍दो म्‍हि वाङ्मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","जमाहेन्‍से येशूसे थेदा “रेःगो, ओच्‍छे ह्राङला तीबा नान्‍बा पुइसी भ्रउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","येशूसे थेह्रङ् सुङ्मैछ्‌याम थे म्‍हि खम्‍जी। जमाहेन्‍से थे ह्राङला तीबा नान्‍बा पुइसी भ्रजी। जमाकुनु ब्‍लप्‍बा न्‍हबा धिन मुबा। ");
INSERT INTO taj_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","थेतबासेलमा यहूदी धर्मगुरुगदेसे थे म्‍हिदा “तिनी ब्‍लप्‍बा न्‍हबा धिन हिन्‍ना, एसे तीबा नान्‍बा पुइबारी आत” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","जमाहेन्‍से थेसे “जुन म्‍हिसे ङादा खम्‍ना लजी थेसेन ङादा तीबा नान्‍बा पुइसी भ्रउ भिसी सुङ्बा हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","थे म्‍हिगदेसे थेदा “एदा तीबा नान्‍बा पुइसी भ्रउ भिबा म्‍हि खाल हिन्‍ना?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","तर ह्राङदा खम्‍ना लबा म्‍हि खाल हिन्‍ना भिसी थेसे ङोसेबा आरेमुबा। तिग्‍दा भिसम थेरी म्‍हिगदे ल्‍हानान पोप तबासे लमा म्‍हिला हुल न्‍हङ‍ग्‍याम येशू सुटुक्‍क फेप्‍सी जिन्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","लिच्‍छा येशूसे थेदा परमेश्‍वरला मन्‍दिररी स्‍याप्‍सी, “च्‍यागो, ए खम्‍सी जिन्‍बा मुला। थेतबासेलमा एसे दोःसी पाप थालउ, चुदे पाप लजी भिसम एदा चु भन्‍दा आज्‍यबा तला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","थे निसी ह्राङदा खम्‍ना लबा म्‍हि येशू चीम भिसी यहूदी धर्मगुरुगदेदा पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","येशूसे चु गे ब्‍लप्‍बा न्‍हबा धिनकुनु लबासे लमा यहूदी धर्मगुरुगदेसे येशूदा बिरोध लबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","तर येशूसे “ङाला आबासे सदन गे लमुला। ओच्‍छे ङाइनोन सदन गे लला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","थेतबासेलमा यहूदी धर्मगुरुगदेसे झन येशूदा साइबारी म्‍हाइजी, तिग्‍दा भिसम थेसे ठिम अन्‍छार ब्‍लप्‍बा न्‍हबा धिनकुनु लबारी आतबा गे जे लबा आहिन, तर थेसे ह्राङसे ह्राङदान परमेश्‍वर ह्रङ्‌बान स्‍होसी परमेश्‍वरदा ह्राङला आबा भिसी सुङ्मुबा। ");
INSERT INTO taj_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, आबासे जुन जुन लबा म्राङ्ला झासेनोन थेनोन गे जे लला, तर झासे जे तिगै गे लबारी आखम। तिग्‍दा भिसम आबासे जुन गे लला झासेनोन थेनोन गे लला। ");
INSERT INTO taj_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","तिग्‍दा भिसम आबासे झादा माया लसी ह्राङसे लबा जम्‍मान गे उन्‍ना। ओच्‍छे थेसे अझ चु भन्‍दान घ्रेन घ्रेन गे ह्राङला झादा उन्‍ना। ओच्‍छे एनीगदे उदेक तगै भिसी थेसे अझ चु भन्‍दा घ्रेन घ्रेन गे लला। ");
INSERT INTO taj_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","आबासे सिबागदेदा सोना लसी जुकजुकधोनाला जुनी पिन्‍बा ह्रङ् लसी झासेनोन जुन म्‍हिदा सेम निला थेदा जुकजुकधोनाला जुनी पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","आबासे खालैलान निसाफ आल। तिग्‍दा भिसम जम्‍मादान निसाफ लबा अधिकार आबासे झादा पिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","आबादा मान लबा ह्रङ् लसी झादाएनोन मान लगै भिसीन आबासे चुह्रङ् लबा हिन्‍ना। तिग्‍दा भिसम जुन म्‍हिसे झादा मान आल थेसे झादा पुइखबा आबादाएनोन मान आल। ");
INSERT INTO taj_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“थेतबासेलमा एनीगदेसे ङाला ताम ङ्‌यान्‍गो, जुन म्‍हिसे ङाला ताम ङ्‌यान्‍सी ङादा पुइखबादा विश्‍वास लला थेसे जुकजुकधोनाला जुनी याङ्ला। ओच्‍छे थेदा दोषएनोन आल, बरु थे सिबाला तहग्‍याम थोन्‍ना। जमाहेन्‍से थेसे जुकजुकधोनाला जुनी याङ्ला। ");
INSERT INTO taj_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, थे धुइ खबान मुला, थे धुइ ङाच्‍छान खसी जिन्‍बा मुला। थेतबासेलमा सिबागदे न्‍हङला जुन जुन्‍से परमेश्‍वरला झाला काइ थेःला थेनीगदे सोला। ");
INSERT INTO taj_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","तिग्‍दा भिसम परमेश्‍वर आबा ह्राङदेन छ्‌यामनोन जुकजुकधोनाला जुनी मुला, थेह्रङ् लसीन थेसे ह्राङला झादाएनोन जुकजुकधोनाला जुनी पिन्‍बा अधिकार मुबा म्‍हि स्‍होबा मुला। ");
INSERT INTO taj_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ओच्‍छे निसाफ लबा अधिकार थेदान पिन्‍बा मुला। तिग्‍दा भिसम परमेश्‍वरसे पुइखबा म्‍हि थेनोन हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“ङाला ताम थेःसी एनीगदे उदेक थातउ। तिग्‍दा भिसम चुह्रङ्बा धुइ खबान मुला, थे धुइरी परमेश्‍वरसे पुइखबा म्‍हिला काइ थेःसी सिबागदे जम्‍मान दोःसी सोला। ");
INSERT INTO taj_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ज्‍यबा गे लबागदे जुकजुकधोनाला जुनी याङ्बारी दोःसी सोला ओच्‍छे आज्‍यबा गे लबागदे सजाय नाबाला लागिरी दोःसी सोला। ");
INSERT INTO taj_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“ङाइ ह्राङसेन तिगै लबारी आखम, परमेश्‍वर आबासे सुङ्बा अन्‍छार निसाफ लबासे लमा ङाइ लबा निसाफ ठीक तमुला। तिग्‍दा भिसम ङाइ म्‍हन्‍बा अन्‍छार आहिन, तर ङादा पुइखबासे म्‍हन्‍बा अन्‍छार ङाइ गे लमुला। ");
INSERT INTO taj_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“चुदे ङाइ ङाला बारेरी जे पाङ्जी भिसम एनीगदेसे ङाइ पाङ्बा ताम सत्‍य हिन्‍ना भिसी था आयाङ्। ");
INSERT INTO taj_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","तर ङाला बारेरी परमेश्‍वर आबासेन सुङ्ला, थेसे ङाला बारेरी जुन ताम सुङ्ला थे जम्‍मान ताम सत्‍य हिन्‍ना भिसी ङादा था मुला। ");
INSERT INTO taj_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“एनीगदेसे ताम घोबाला लागिरी ह्राङला म्‍हिगदेदा बप्‍तिस्‍मा पिन्‍बा यूहन्‍ना मुबा ग्‍लारी पुइजी। ओच्‍छे थेसे थेनीगदेदा सत्‍य ताम पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ङाइ म्‍हिगदेसे ङाला बारेरी तिग ताम पाङ्‌मुला भिसी भर लबा आहिन, तर एनीगदेदा थार्ना लबाला लागिरीन ङाइ चु ताम पाङ्बा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","यूहन्‍ना मी लुङ्सी य्‍हाल तना लबा नाङसल ह्रङ्‌बान मुबा, तर थेसे पिन्‍बा य्‍हालरी एनीगदे छिन्‍नङ जे ताङ्बारी म्‍हाइजी। ");
INSERT INTO taj_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“तर ङाला बारेरी ताम पाङ्बा यूहन्‍ना भन्‍दाएनोन घ्रेन ताम चुरी मुला। तिग्‍दा भिसम जुन गेगदे पूरा लबारी आबासे ङादा पिन्‍बा मुला, थे गेगदे ङाइ लबान मुला। चु गेसेन ङादा परमेश्‍वरसे पुइखबा हिन्‍ना भिसी उन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ङादा पुइखबा आबासेनोन ङाला बारेरी सुङ्बा मुला। तर एनीगदेसे थेला काइ खाइमै थेःबा आरे, ओच्‍छे थेदा म्राङ्बाएनोन आरे। ");
INSERT INTO taj_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","थेसे सुङ्बा बचन एनीगदेला सेमरी आचि। तिग्‍दा भिसम थेसे पुइखबा म्‍हिदा एनीगदेसे विश्‍वास आलनी। ");
INSERT INTO taj_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","एनीगदेसे जुकजुकधोनाला जुनी याङ्ला भिसी बचनरी म्‍हाइमुला, थे बचनसेनोन ङाला बारेरी पाङ्‌मुला। ");
INSERT INTO taj_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","तसैनोन जुकजुकधोनाला जुनी याङ्बाला लागिरी एनीगदे ङा मुबा ग्‍लारी खबारी आम्‍हाइमुला। ");
INSERT INTO taj_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“म्‍हिगदेसे ङादा जयजयकार लगै भिसी ङाइ म्‍हन्‍बा आरे। ");
INSERT INTO taj_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","तर एनीगदे परमेश्‍वरदा माया आलबा खाह्रङ्बा खाल्‍ला म्‍हि हिन्‍ना भिबा ताम ङादा था मुला। ");
INSERT INTO taj_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ङा ह्राङलान आबाला मिन किन्‍सी खमाएनोन एनीगदेसे ङादा मान आलनी। तर स्‍य्‍हान्‍दो खालै म्‍हि ह्राङलान मिन किन्‍सी खजी भिसम एनीगदेसे थेदा मान लला। ");
INSERT INTO taj_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","एनीगदेसे ङादा खाह्रङ् लसी विश्‍वास लखम्‍ला? एनीगदे ह्राङ ह्राङ न्‍हङ‍री चा गिकसेम गिकदा मान लगै भिसी म्‍हन्‍बा, तर परमेश्‍वरग्‍याम जे याङ्बा मान चा किन्‍बारी आम्‍हाइबा। ");
INSERT INTO taj_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“परमेश्‍वर आबाला ओन्‍छाङरी ङाइ एनीगदेला दोष उन्‍ना भिसी थाम्‍हन्‍गो। तर थार्बा पिन्‍ना भिसी एनीगदेसे विश्‍वास आश लबा मोशाला ठिमरी मुबा तामसेन एनीगदेला दोष उन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","च्‍यागो, एनीगदेसे मोशादा विश्‍वास लबा हिन्‍सम दान्‍दे ङादाएनोन विश्‍वास लसेला मुबा। तिग्‍दा भिसम थेसे ङालान बारेरी भ्रिबा मुबा! ");
INSERT INTO taj_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","तर मोशासे भ्रिबा तामनोन एनीगदेसे विश्‍वास लबारी आखम्‍नी भिसम ङाइ पाङ्बा ताम झन खाह्रङ् लसी विश्‍वास लखम्‍ला?” ");
INSERT INTO taj_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","जमाहेन्‍से येशू गालील समुन्‍द्रला क्‍याम्‍सङपट्टि फेप्‍जी। थे समुन्‍द्रदा तिबेरियास समुन्‍द्र भिसीनोन भिमुबा। ");
INSERT INTO taj_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ओच्‍छे ल्‍हानान म्‍हिला हुलएनोन येशूला लिच्‍छा लिच्‍छा निजी। तिग्‍दा भिसम आखम्‍बा म्‍हिगदेदा येशूसे ल्‍हानान रेम खम्‍ना लबा उदेकला चिनुगदे थेनीगदेसे म्राङ्बा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ओच्‍छे येशू गङरी फेप्‍सी ह्राङला चेलागदेदेन छ्‌याम थेरीन धन्‍छ्‌याजी। ");
INSERT INTO taj_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","थे धुइरी यहूदीगदेला मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाडएनोन खबारी छ्‌याइबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","येशूसे क्‍युर्सीन स्‍हीमा ह्राङ मुबा ग्‍लारी ल्‍हानान म्‍हिगदे खबान लबा म्राङ्सी फिलिपदा “चु म्‍हिगदेदा पिन्‍बाला लागिरी य्‍हाङसे खानङग्‍यामसे गेङ ग्‍लुसी भसे?” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","येशूसे थेला सेम च्‍याबाला लागिरी थेह्रङ् भिसी सुङ्बा मुबा। तिग्‍दा भिसम ह्राङसे तिग लबारी छ्‌याइबा मुबा, थे ताम येशूदा था मुबा। ");
INSERT INTO taj_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","फिलिपसे येशूदा “य्‍हाङसे ग्‍यार्जा न्‍ही म्‍हुइला डबलसे गेङ ग्‍लुसी भसैनोन चुरी मुबा म्‍हिगदेदा जजाकर सुत्तै आथोप” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","येशूला चेला सिमोन पत्रुसला आले अन्‍द्रियाससे येशूदा, ");
INSERT INTO taj_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“चुरी कोला गिकदेन छ्‌याम जौला गोर ङा गेङदेन गोर न्‍ही तार्ङा मुला। तिग चुदेसे चु जम्‍मान म्‍हिगदेदा छ्‍योला?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","येशूसे चेलागदेदा “म्‍हिगदेदा चिपुङ्‍गो” भिसी सुङ्जी। थेरी घ्रेन पाङग्‍याल मुबा, थेरी हजार ङा ते चा ह्रेम्‍फेबे जे मुबा। ");
INSERT INTO taj_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","जमाहेन्‍से येशूसे गेङ छ्‌यारी थोसी परमेश्‍वरदा धन्‍यवाद पिन्‍माहेन्‍से जम्‍मान म्‍हिदा भो लसी पिन्‍जी, ओच्‍छे तार्ङाएनोन भो लसी पिन्‍जी। थेरी मुबा जम्‍मान म्‍हिसे म्रेन्‍ना चजी। ");
INSERT INTO taj_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","थेनीगदे जम्‍मासेन म्रेन्‍ना चसी जिन्‍माहेन्‍से येशूसे ह्राङला चेलागदेदा “लेङ्बा टगलटोगोल खेरो थानिगै, जम्‍मान पोप लउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","थेतबासेलमा थेनीगदेसे चसी लेङ्बा गोर ङा जौला गेङला टगलटोगोल दुइमा च्‍युक न्‍ही सोली तजी। ");
INSERT INTO taj_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","येशूसे लबा चुह्रङ्बा उदेकला गे म्राङ्सी म्‍हिगदेसे “जम्‍बुलिङरी फेप्‍खला भिसी बचनसे य्‍हाङदा पाङ्बा अगमवक्ता चा पक्‍कान चुनोन चीम” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","थेतबासेलमा म्‍हिगदे खसी ह्राङदा जबरजस्‍ती ग्‍ले स्‍होबारी म्‍हाइबा मुला भिबा ताम था याङ्सी येशू दोःसी ह्राङ गिकनोन गङरी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ङ्‍यसे तमाहेन्‍से येशूला चेलागदे समुन्‍द्रपट्टि निजी। ");
INSERT INTO taj_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ओच्‍छे थेनीगदे दोँगारी क्रेःसी समुन्‍द्रला क्‍याम्‍सङ कफर्नहुम भिबा शहरपट्टि निजी। थे धुइरी धोप तसी जिन्‍बा मुबा, तसैनोन अझ येशू थेनीगदे मुबा ग्‍लारी फेप्‍खबा आरेमुबा। ");
INSERT INTO taj_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","घ्रेन लाबा खबासे लमा समुन्‍द्ररी छाल रेःबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","चेलागदे दोँगा चलब लसी ओस्‍पन कोस गिक-न्‍ही ते थारेङ धोमा, थेनीगदेसे येशू समुन्‍द्र थोथोरी भ्रसी ह्राङगदे मुबापट्टि फेप्‍खबान लबा म्राङ्जी। चु म्राङ्सी थेनीगदे लोङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","तर येशूसे थेनीगदेदा “ङानोन हिन्‍ना, थालोङ्‍गो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","चु ताम थेःसी थेनीगदे ल्‍हानान ताङ्जी, ओच्‍छे येशूदा दोँगारी धन्‍छ्‍यापुङ्जी। जमाहेन्‍से तुरुन्‍तन थेनीगदे धोतोःबा ग्‍लारी धोजी। ");
INSERT INTO taj_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ओच्‍छे समुन्‍द्रला क्‍याम्‍सङपट्टि मुबा म्‍हिगदेसे न्‍हङगरदङ थेरी दोँगा गिक जेन म्राङ्जी। ङाच्‍छाकुनु येशू चेलागदेदेन छ्‌याम दोँगारी फेप्‍बा आरेमुबा, तर थेला चेलागदे जे निमुबा भिबा ताम थेनीगदेदा था मुबा। ");
INSERT INTO taj_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","जमाहेन्‍से तिबेरियास भिबा शहरग्‍याम अर्गु दोँगागदे येशूसे परमेश्‍वरदा धन्‍यवाद पिन्‍सी थेनीगदेदा गेङ पिन्‍बा ग्‍लाला ङामरी धोखजी। ");
INSERT INTO taj_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","थेरी येशूदेन छ्‌याम चेलागदे आरेबा था याङ्सी थेनीगदे दोँगागदेरी क्रेःसी येशूदा म्‍हाइबान कफर्नहुम शहररी निजी। ");
INSERT INTO taj_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","थेनीगदेसे येशूदा समुन्‍द्रला क्‍याम्‍सङपट्टि स्‍याप्‍माहेन्‍से “गुरु, ह्राङ चुरी खाइमा फेप्‍खजी?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","जमाहेन्‍से येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदेसे ङाला ताम ङ्‌यान्‍गो, ङाइ लबा उदेकला गे म्राङ्सी आहिन, तर म्रेन्‍ना गेङ चम्‍याङ्बासे लमान एनीगदेसे ङादा म्‍हाइबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","च्‍यागो, नाश तसी निबा चबा स्‍हेला लागिरी जे दुख लसी गे थालउ, तर जुकजुकधोना चिबा चबा स्‍हेला लागिरी दुख लसी गे लउ। चु चबा स्‍हे एनीगदेदा परमेश्‍वरसे पुइखबा म्‍हिसे पिन्‍ना। तिग्‍दा भिसम चु गे लबाला लागिरीन परमेश्‍वर आबासे थेदा धम्‍बा मुला।” ");
INSERT INTO taj_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","जमाहेन्‍से थेनीगदेसे येशूदा “थेह्रङ् भिसम परमेश्‍वरसे म्‍हन्‍बा अन्‍छारला गे लबाला लागिरी ङन्‍से तिग लतोःला?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","येशूसे थेनीगदेदा “परमेश्‍वरसे पुइखबा म्‍हिदा विश्‍वास लउ, एनीगदेसे लगै भिसी परमेश्‍वरसे म्‍हन्‍बा गे चा थेनोन हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","जमाहेन्‍से थेनीगदेसे येशूदा भिसी भिजी, “ङन्‍से ह्राङदा विश्‍वास लबाला लागिरी ह्राङसे ङन्‍दा खाह्रङ्बा उदेकला चिनु उन्‍खम्‍ला? ह्राङसे तिग लखम्‍ला? ");
INSERT INTO taj_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","य्‍हाङला आखे म्‍हेमेगदेसे मी तोङतोङबा ग्‍लारीएनोन मन्‍न चजी। चु ताम बचनरीन ‘परमेश्‍वरसे थेनीगदेदा स्‍वर्गग्‍याम गेङ पिन्‍जी’ भिसी भ्रिबा मुला।” ");
INSERT INTO taj_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, एनीगदेदा स्‍वर्गग्‍याम गेङ पिन्‍बा मोशा आहिन। तर स्‍वर्गग्‍याम सत्‍य गेङ पिन्‍बा चा ङाला आबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","तिग्‍दा भिसम परमेश्‍वरसे पिन्‍बा गेङ चा चुनोन हिन्‍ना, थे स्‍वर्गग्‍याम खसी जम्‍बुलिङला म्‍हिगदेदा जुनी पिन्‍मुला!” ");
INSERT INTO taj_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","थेनीगदेसे येशूदा “प्रभु, चु गेङ ङन्‍दा सदन पिन्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","जमाहेन्‍से येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “जुकजुकधोनाला जुनी पिन्‍बा गेङ चा ङानोन हिन्‍ना। ङा मुबा ग्‍लारी खबागदे खाइमै आख्रेन, ओच्‍छे ङादा विश्‍वास लबागदेदा खाइमै क्‍युइ आफुइ। ");
INSERT INTO taj_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","तर ङाइ एनीगदेदा पाङ्सी जिन्‍बा मुबा, एनीगदेसे ङादा म्राङ्सैनोन विश्‍वास आलनी। ");
INSERT INTO taj_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","आबासे ङादा पिन्‍बा जति जम्‍मान ङा मुबा ग्‍लारी खला, ङा मुबा ग्‍लारी खबागदेदा ङाइ तिगै लसीन आख्‍ला। ");
INSERT INTO taj_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ङा ह्राङसे म्‍हन्‍बा अन्‍छारला गे लबारी खबा आहिन, तर ङादा पुइखबासे म्‍हन्‍बा अन्‍छारला गे लबारी ङा स्‍वर्गग्‍याम खबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ङादा पुइखबासे म्‍हन्‍बा ताम चा थेसे ङादा पिन्‍बा म्‍हिगदे ङाग्‍याम गिकनोन थाम्‍हागै, तर चु जम्‍बुलिङरी ङा दोःसी खबा धुइरी ङाइ थेनीगदेदा सोना लबारी खम्‍गै भिसी हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","तिग्‍दा भिसम ङाला आबासे म्‍हन्‍बा ताम चा चुनोन हिन्‍ना, झादा म्राङ्सी थेदा विश्‍वास लबागदे जम्‍मासेन जुकजुकधोनाला जुनी याङ्‌गै, ओच्‍छे ङा दोःसी खबा धुइरी ङाइ थेनीगदेदा सिबाग्‍याम सोना लला।” ");
INSERT INTO taj_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“स्‍वर्गग्‍याम खबा गेङ ङानोन हिन्‍ना” भिसी येशूसे सुङ्बासे लमा यहूदी गन्‍बागदेसे येशूला बिरोध लसी ताम लबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","थेनीगदेसे, “तिग चु योसेफला झा येशू आहिन?, चुला आबा आमादा य्‍हाङसे ङोसेबा आरे?, खाह्रङ् लसी चुसे ‘ङा स्‍वर्गग्‍याम खबा हिन्‍ना’ भिसी पाङ्बा” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","जमाहेन्‍से येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदेसे ह्राङ ह्राङ न्‍हङ‍री ङाला बिरोध लसी ताम थालउ। ");
INSERT INTO taj_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","तिग्‍दा भिसम ङादा पुइखबा आबासे ङा मुबा ग्‍लारी खबा सेम आपिन्‍तेधोना खालैनोन ङा मुबा ग्‍लारी खबारी आखम। ङा मुबा ग्‍लारी खबागदे जम्‍मादान ङा दोःसी खबा धुइरी ङाइ सोना लला। ");
INSERT INTO taj_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","अगमवक्तागदेसेनोन परमेश्‍वरला बचनरी ‘परमेश्‍वरसेन जम्‍मान म्‍हिगदेदा लोप्‍ला’ भिसी भ्रिबा मुबा। परमेश्‍वर आबाला ताम थेःसी थेग्‍यामसेन लोप्‍बा म्‍हिगदे जम्‍मान ङा मुबा ग्‍लारी खला। ");
INSERT INTO taj_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","परमेश्‍वर आबाग्‍याम खबा म्‍हिसे जे परमेश्‍वरदा म्राङ्बा मुला। तर स्‍य्‍हान्‍दो खालैसेन थेदा म्राङ्बा आरे। ");
INSERT INTO taj_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","थेतबासेलमा एनीगदेसे ङाला ताम ङ्‌यान्‍गो, जुन म्‍हिसे विश्‍वास लला थेसे जुकजुकधोनाला जुनी याङ्बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","च्‍यागो, जुकजुकधोनाला जुनी पिन्‍बा गेङ ङानोन हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","एनीगदेला आखे म्‍हेमेगदेसे तोङतोङबा ग्‍लारी मन्‍न चजी, तसैनोन थेनीगदे सिजी। ");
INSERT INTO taj_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","तर स्‍वर्गग्‍याम खबा गेङ चुनोन हिन्‍ना, जुन म्‍हिसे चु गेङ चला थे खाइमै आसि। ");
INSERT INTO taj_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","स्‍वर्गग्‍याम खबा छोन्‍बो गेङ चा ङानोन हिन्‍ना, जुन म्‍हिसे चु गेङ चला थे खाइमै आसि। चु गेङ चा ङाइ जम्‍बुलिङला म्‍हिगदेसे जुकजुकधोनाला जुनी याङ्‌गै भिसी पिन्‍ना। थे गेङ चा ङालान ल्‍हुइ हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","चु ताम थेःसी यहूदीगदेदा बोमो रेःसी ह्राङ ह्राङ न्‍हङ‍री चुह्रङ् भिसी ताम लबारी छ्‌याइजी, “चु म्‍हिसे खाह्रङ् लसी ह्राङला ल्‍हुइ य्‍हाङदा चबारी पिन्‍खम्‍ला?” ");
INSERT INTO taj_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","जमाहेन्‍से येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, चुदे एनीगदेसे परमेश्‍वरसे पुइखबा म्‍हिला ल्‍हुइ आचनी भिसम, का आथुङ्नी भिसम एनीगदेदेन छ्‌याम जुकजुकधोनाला जुनी आत। ");
INSERT INTO taj_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","तर ङाला ल्‍हुइ चबा, ङाला का थुङ्बा म्‍हिदेन छ्‌याम जुकजुकधोनाला जुनी तला। ओच्‍छे ङा दोःसी खबा धुइरी ङाइ थेदा सिबाग्‍याम सोना लला। ");
INSERT INTO taj_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","तिग्‍दा भिसम चनोन तोःबा स्‍हे चा ङाला ल्‍हुइ हिन्‍ना ओच्‍छे थुङ्नोन तोःबा स्‍हे चा ङाला का हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ङाला ल्‍हुइ चबा, ङाला का थुङ्बा म्‍हि ङादेन छ्‌याम तला, ओच्‍छे ङा थेदेन छ्‌याम तला। ");
INSERT INTO taj_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","छोन्‍बो परमेश्‍वरसे ङादा पुइखबासे लमा ङा थेग्‍यामसे सोला, थेह्रङ् लसीन ङादा चबा म्‍हिएनोन ङाग्‍यामसेन सोला। ");
INSERT INTO taj_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","स्‍वर्गग्‍याम खबा गेङ चुनोन हिन्‍ना। चु गेङ एनीगदेला आखे म्‍हेमेगदेसे चबा गेङ ह्रङ्‌बा आहिन। थेनीगदेसे थे गेङ चजी तसैनोन थेनीगदे सिजी। तर चु गेङ चबा म्‍हिगदे चा खाइमै आसि।” ");
INSERT INTO taj_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","चु ताम चा येशूसे कफर्नहुम भिबा शहररी यहूदीगदे ह्रुप तबा दिमरी म्‍हिगदेदा लोप्‍बा धुइरी सुङ्बा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","चु ताम थेःमाहेन्‍से येशूला चेलागदे न्‍हङला ल्‍हानानसे “चुह्रङ्बा गाह्रो बचन खाल्‍से ङ्‍यान्‍खम्‍ला?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","तर चेलागदेसे चु तामला बारेरी ताम लबान मुला भिबा था याङ्सी येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “तिग ङाइ पाङ्बा तामसे लमा एनीगदेला विश्‍वास म्‍हाबा हिन्‍ना? ");
INSERT INTO taj_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","थेह्रङ् भिसम एनीगदेसे परमेश्‍वरसे पुइखबा म्‍हिदा स्‍वर्गरी दोःसी निबा म्राङ्मा एनीगदेला सेमरी खाह्रङ्बा छोर्ला? ");
INSERT INTO taj_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","जुकजुकधोनाला जुनी पिन्‍बा चा परमेश्‍वरला आत्‍मासेन हिन्‍ना। चु गे चा म्‍हिला शक्तिसे लबारी खम्‍बा गे आहिन। ङाइ एनीगदेदा पाङ्बा ताम चा परमेश्‍वरला आत्‍मासे पिन्‍बा जुकजुकधोनाला जुनीला बारेरी हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","तर एनीगदे न्‍हङ‍री गातेसे मी चु ताम विश्‍वास लबा आरे।” तिग्‍दा भिसम खाल्‍से विश्‍वास आल, खाल्‍से ह्राङदा धोका पिन्‍ना भिबा ताम येशूदा ङाच्‍छाहेन्‍सेन था मुबा। ");
INSERT INTO taj_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","जमाहेन्‍से दोःसी येशूसे थेनीगदेदा “थेतबासेलमान ङाइ एनीगदेदा चु ताम पाङ्बा हिन्‍ना, चुदे ङाला आबासे ङा मुबा ग्‍लारी खआपुङ्नी भिसम खालै म्‍हि ङा मुबा ग्‍लारी खबारी आखम” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","चु तामसे लमा जमाकुनुहेन्‍से चेलागदे न्‍हङला ल्‍हानान चेलागदे येशूदेन छ्‌याम भ्रबारी ख्‍लाजी। ");
INSERT INTO taj_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","थेतबासेलमा येशूसे ह्राङला च्‍युक न्‍ही चेलागदेदा “तिग एनीगदेएनोन ङादा ख्‍लासी निबा हिन्‍ना?” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","जमाहेन्‍से सिमोन पत्रुससे येशूदा भिसी भिजी, “प्रभु, जुकजुकधोनाला जुनी पिन्‍बा बचन मी ह्राङदेन छ्‌याम मुला भिसम ङनी खाल मुबा ग्‍लारी निसे? ");
INSERT INTO taj_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ह्राङ परमेश्‍वरसे पुइखबा परमेश्‍वरला म्‍हि हिन्‍ना भिबा ताम ङन्‍से था याङ्सीन ह्राङदा विश्‍वास लबा हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","येशूसे थेनीगदेदा “एनीगदे च्‍युक न्‍हीदान ङाइ धम्‍बा हिन्‍ना, तसैनोन एनीगदे न्‍हङला गिक चा शैतान हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","चु ताम येशूसे सिमोन इस्‍करियोतला झा यहूदाला बारेरी सुङ्बा मुबा। तिग्‍दा भिसम च्‍युक न्‍ही चेला न्‍हङला तसीनोन थेसे लिच्‍छा येशूदा धोका पिन्‍बारी छ्‌याइबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","जमाहेन्‍से येशू गालील अञ्‍चललान नाम्‍सा नाम्‍सारी फेप्‍जी, तर यहूदिया अञ्‍चलरी चा फेप्‍बा सेम आलनी। तिग्‍दा भिसम यहूदीगदेसे येशूदा साइबारी म्‍हाइमुबा। ");
INSERT INTO taj_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","थे धुइरी यहूदीगदेसे छाप्रोरी चिसी धङ्बा चाड खबारी छ्‌याइबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","थेतबासेलमा येशूदा ह्राङला आलेगदेसेनोन खिसी लसी चुह्रङ् भिसी भिजी, “चु ग्‍ला ख्‍लासी ह्राङ यहूदिया अञ्‍चलरी फेप्‍नोन फेप्‍गो, थेरीनोन ह्राङसे लबा गेगदे ह्राङला चेलागदेसे म्राङ्‍गै। ");
INSERT INTO taj_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ह्राङदा जम्‍मासेन ङोसेगै भिसी म्‍हन्‍बा म्‍हिसे खाइमै लासी गे आलमुला। ह्राङसेनोन थेह्रङ्बान गेगदे लबा मुसम ह्राङ खाल हिन्‍ना भिबा ताम जम्‍बुलिङला म्‍हिगदेदा ङोसेना लउ।” ");
INSERT INTO taj_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","तिग्‍दा भिसम येशूला आलेगदेसेनोन येशूदा विश्‍वास आलमुबा! ");
INSERT INTO taj_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","थेतबासेलमा येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “ङाला लागिरी धुइ तबा आरे। तर एनीगदेला लागिरी मी खजिबै धुइ मुसै ठीक मुला। ");
INSERT INTO taj_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","एनीगदेदा जम्‍बुलिङला म्‍हिगदेसे हेला आलमुला, तर ङादा चा हेला लमुला। तिग्‍दा भिसम थेनीगदेला बानीबेहोर आज्‍यबा मुला भिसी ङाइ पाङ्‌मुला। ");
INSERT INTO taj_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","एनीगदे चा चाड धङ्बारी निउ, ङा दान्‍दे आनि। तिग्‍दा भिसम ङाला धुइ तबा आरे।” ");
INSERT INTO taj_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","थेह्रङ् सुङ्सी येशू गालीलरीन धन्‍छ्‌याजी। ");
INSERT INTO taj_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","तर येशूला आलेगदे चाड धङ्बारी निमाहेन्‍से येशूएनोन खालैसे था आयाङ्ना लसी थेरी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","थेरी यहूदी नेतागदेसे येशूदा म्‍हाइबान, “थे म्‍हि खानङ मुला?” भिसी म्‍हिगदेदा ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ल्‍हानान म्‍हिगदेसे येशूला बारेरी चुह्रङ् भिसी ताम लबान मुबा, कोइ कोइसे “थे ज्‍यबा म्‍हि हिन्‍ना” भिसी भिमुबा। तर कोइ कोइसे चा “आहिन, थेसे ल्‍हानान म्‍हिगदेदा न्‍होङ्ना लबा मुला” भिसी भिमुबा। ");
INSERT INTO taj_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","तसैनोन यहूदी नेतागदेदेन छ्‌याम लोङ्सी खालैसेन येशूला बारेरी स्‍य्‍हान्‍दो म्‍हिसे था याङ्ना लसी ताम आलमुबा। ");
INSERT INTO taj_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","चाडला गुङरी परमेश्‍वरला मन्‍दिररी फेप्‍सी येशूसे म्‍हिगदेदा लोप्‍बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","यहूदी नेतागदे उदेक म्‍हन्‍बान, “चुसे तिगै पढब आलना चुह्रङ्बा ज्ञान बुद्धि खानङग्‍याम याङ्जी?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","जमाहेन्‍से येशूसे थेनीगदेदा चुह्रङ् भिसी जोहाब पिन्‍जी, “ङाइ ङाला ताम लोप्‍बा आहिन, तर ङादा पुइखबा परमेश्‍वरला ताम लोप्‍बा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","चुदे खालै म्‍हिसे परमेश्‍वरसे म्‍हन्‍बा अन्‍छार लबारी म्‍हाइजी भिसम थेसे जे ङाइ लोप्‍बा ताम परमेश्‍वरग्‍याम हिन्‍ना कि ङालान सेमला ताम लोप्‍बा हिन्‍ना भिसी था याङ्ला। ");
INSERT INTO taj_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","जुन म्‍हिसे ह्राङलान ताम पाङ्ला थेसे ह्राङदान मान लगै भिसी म्‍हन्‍मुला। तर ह्राङदा पुइखबादा मान लगै भिसी म्‍हन्‍बा म्‍हिसे चा सत्‍य ताम पाङ्‌मुला, थेसे तिगै लुसीला ताम आलमुला। ");
INSERT INTO taj_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","मोशासे एनीगदेदा ठिम पिन्‍बा मुला, तसैनोन एनीगदेसे मोशासे पिन्‍बा ठिम अन्‍छार गे आलनी। एनीगदेसे ङादा तिग्‍दा साइबारी म्‍हाइबा?” ");
INSERT INTO taj_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","थेरी मुबा म्‍हिला हुलसे येशूदा “एदा म्‍हङसे स्‍याप्‍जीम, खाइ एदा खाल्‍से साइबारी म्‍हाइबा मुला?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","जमाहेन्‍से येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “ङाइ गे गिक लमा एनीगदे तिग्‍दा उदेक म्‍हन्‍बा? ");
INSERT INTO taj_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","च्‍यागो, खतना लउ भिसी एनीगदेदा मोशासे ठिम स्‍होसी पिन्‍बा मुला। हिन्‍बाम थे ठिम मोशासे स्‍होबा आहिन, एनीगदेला आखे म्‍हेमेसेन स्‍होबा हिन्‍ना। थेतबासेलमा एनीगदेसे ब्‍लप्‍बा न्‍हबा धिनकुनुएनोन ह्राङला झागदेला खतना लमुला। ");
INSERT INTO taj_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","य्‍हाङसे मोशासे पिन्‍बा ठिम आख्‍लागे भिसी ब्‍लप्‍बा न्‍हबा धिनरीएनोन खतना लमुला भिसम ङाइ चा आखम्‍बा म्‍हि गिकदा खम्‍ना लमा एनीगदेसे तिग्‍दा ङादा बोमो लबा? ");
INSERT INTO taj_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","एनीगदेसे म्‍हिला ली च्‍यासी निसाफ थालउ, तर ठीक लसी निसाफ लउ।” ");
INSERT INTO taj_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","यरूशलेमग्‍याम खबा कोइ कोइ म्‍हिगदेसे चुह्रङ् भिसी भिजी, “तिग यहूदी धर्मगुरुगदेसे साइबारी म्‍हाइबा म्‍हि चुनोन आहिन? ");
INSERT INTO taj_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","च्‍यागो, आलोङ्नान चुसे जम्‍मादान लोप्‍बान मुला, तर चुदा थेनीगदेसे तिगै आपाङ्नी! ङन्‍ना नेतागदेसेनोन चुनोन थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍ना भिसी पक्‍कान था याङ्जी कि तिग? ");
INSERT INTO taj_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","चु म्‍हि खाह्रङ् लसी थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍ना, तिग्‍दा भिसम चु म्‍हि खानङग्‍याम खबा हिन्‍ना भिबा ताम य्‍हाङदा था मुला। तर ख्रीष्‍ट फेप्‍खबा धुइरी खानङग्‍याम फेप्‍खला भिबा ताम खालैदान था आत। ");
INSERT INTO taj_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","थे धुइरी परमेश्‍वरला मन्‍दिररी लोप्‍बान लमा येशूसे घ्रेन काइरी चुह्रङ् भिसी सुङ्जी, “ङा खानङग्‍याम खबा हिन्‍ना भिबादेन ङा खाल हिन्‍ना भिबा ताम एनीगदेदा पक्‍कान था मुला। च्‍यागो, ङा ह्राङनोन खबा आहिन, तर ङादा खालैसे पुइखबा हिन्‍ना थे चा सत्‍य हिन्‍ना, एनीगदेसे थेदा ङोसेबा आरे। ");
INSERT INTO taj_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","तर ङाइ थेदा ङोसेबा मुला। तिग्‍दा भिसम थेसे पुइखबासे लमा ङा थेग्‍याम खबा हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","चु ताम थेःसी थेनीगदेसे येशूदा चुङ्बारी म्‍हाइजी। तर खालैसेन या आझाङ्नी, तिग्‍दा भिसम येशूला धुइ तबा आरेमुबा। ");
INSERT INTO taj_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","थेरी मुबा ल्‍हानान म्‍हिगदेसे येशूदा विश्‍वास लजी। ओच्‍छे थेनीगदेसे, “थार्बा पिन्‍बा ख्रीष्‍ट फेप्‍खसी, तिग चु म्‍हिसे भन्‍दा अझ उदेकला गेगदे लला?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","म्‍हिगदेसे येशूला बारेरी खासखास खुसखुस ताम लबान लबा फरिसीगदेसे थेःजी। जमाहेन्‍से परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन फरिसीगदेसे येशूदा चुङ्बाला लागिरी परमेश्‍वरला मन्‍दिर ख्रुङ्बा सिपाहीगदेदा पुइजी। ");
INSERT INTO taj_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","येशूसे म्‍हिगदेदा चुह्रङ् भिसी सुङ्जी, “तिगै धिनधोना ङा एनीगदेदेन छ्‌यामनोन तला, जमाहेन्‍से ङादा जुन्‍से पुइखबा मुला, ङा थे मुबा ग्‍लारीन निला। ");
INSERT INTO taj_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ओच्‍छे एनीगदेसे ङादा म्‍हाइला, तर आस्‍याप। तिग्‍दा भिसम ङा निबा ग्‍लारी एनीगदे खबारी आखम।” ");
INSERT INTO taj_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","चु ताम थेःसी यहूदी नेतागदेसे ह्राङ ह्राङ न्‍हङ‍री चुह्रङ् भिसी भिजी, “चु म्‍हि खानङ निबारी छ्‌याइजी? एनीगदेसे ङादा आस्‍याप भिसी भिमुला। अर्गु य्‍हुल्‍सारी ससा बङबङ तसी चिबा यहूदीगदे मुबा ग्‍लारी निसी थे य्‍हुल्‍साला ग्रीक ग्‍योइ पाङ्बा म्‍हिगदेदा लोप्‍बारी म्‍हाइजी कि तिग? ");
INSERT INTO taj_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‘एनीगदेसे ङादा म्‍हाइला, तर आस्‍याप। तिग्‍दा भिसम ङा निबा ग्‍लारी एनीगदे खबारीन आखम’ भिसी चु म्‍हिसे तिग ताम पाङ्बा?” ");
INSERT INTO taj_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","चाड जिन्‍बा धिनकुनु अथवा मुल धिनकुनु येशूसे म्‍हिगदेला ङाच्‍छा राप्‍सी घ्रेन काइरी चुह्रङ् भिसी सुङ्जी, “चुदे खालैदा क्‍युइ फुइबा मुसम ङा मुबा ग्‍लारी खसी थुङ्‍गो। ");
INSERT INTO taj_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","परमेश्‍वरला बचनसे पाङ्बा ह्रङ्नोन ङादा विश्‍वास लबा म्‍हिला सेम न्‍हङ‍ग्‍याम जुकजुकधोनाला जुनी पिन्‍बा क्‍युइ थोन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","चु ताम चा येशूसे ह्राङदा विश्‍वास लबा म्‍हिगदेसे याङ्तोःबा परमेश्‍वरला आत्‍माला बारेरी सुङ्बा मुबा। परमेश्‍वरसे थे धुइधोना ह्राङला आत्‍मा पुइखबा आरेमुबा। तिग्‍दा भिसम थे धुइधोना येशूदा क्रुसरी टाँगब लबादेन स्‍वर्गरी घ्रेन य्‍हालदेन शक्तिरी फेप्‍बा धुइ तबा आरेमुबा। ");
INSERT INTO taj_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","येशूला ताम थेःसी थेरी मुबा कोइ कोइ म्‍हिगदेसे “चु म्‍हि पक्‍कान थेनोन अगमवक्ता हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ओच्‍छे कोइ कोइसे “चु थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍ना” भिसी भिजी। तर कोइ कोइसे चुह्रङ् भिसी भिजी, “तिग गालील अञ्‍चलग्‍यामसेनोन थार्बा पिन्‍बा ग्‍ले फेप्‍खला? ");
INSERT INTO taj_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","परमेश्‍वरला बचनरी थार्बा पिन्‍बा ख्रीष्‍ट दाऊदला सन्‍तानग्‍याम दाऊदलान नाम्‍सा बेथलेहेमग्‍यामसेन खला भिसी पाङ्बा आरे?” ");
INSERT INTO taj_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","चुह्रङ् लसी येशूसे लमा म्‍हिगदे ह्राङ ह्राङ न्‍हङरीन आढिक्‍नी। ");
INSERT INTO taj_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","थेनीगदे न्‍हङला गाते म्‍हिगदेसे येशूदा चुङ्बारी म्‍हाइजी। तर थेनीगदे खालैसेन या आझाङ्नी। ");
INSERT INTO taj_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","परमेश्‍वरला मन्‍दिर ख्रुङ्बा सिपाहीगदे दोःसी खमाहेन्‍से परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन फरिसीगदेसे थेनीगदेदा “खाइ, एनीगदेसे थेदा तिग्‍दा आभबा?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","जमाहेन्‍से थे सिपाहीगदेसे थेनीगदेदा “थे म्‍हिला ताम थेःसी ङनी उदेक तजी। थेह्रङ्बा ताम मी ङन्‍से खाइमै थेःबा आरे” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","जमाहेन्‍से फरिसीगदेसे थेनीगदेदा चुह्रङ् भिसी भिजी, “एनीगदेदाएनोन थेसे झुक्‍याब लजी कि तिग? ");
INSERT INTO taj_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","तिग यहूदी नेतागदेदेन फरिसीगदे खालैसे थेदा विश्‍वास लबा मुला? ");
INSERT INTO taj_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","तर परमेश्‍वरसे मोशादा पिन्‍बा ठिम आसेबा चु म्‍हिगदेसे परमेश्‍वरग्‍याम सजाय याङ्ला।” ");
INSERT INTO taj_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ङाच्‍छा म्‍हुनङ तिरेम येशूदा ह्रुप तबारी निबा थेनीगदे न्‍हङलान निकोदेमस भिबा म्‍हिसे चुह्रङ् भिसी भिजी, ");
INSERT INTO taj_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“तिग य्‍हाङला ठिम अन्‍छार थे म्‍हिसे लबा तामदेन गे आघोनान य्‍हाङसे थेदा दोष उन्‍बारी तला?” ");
INSERT INTO taj_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","तर स्‍य्‍हान्‍दोगदेसे थेदा “एएनोन गालील अञ्‍चलला हिन्‍ना? परमेश्‍वरला बचन ज्‍यना लसी पढब लउ। जमाहेन्‍से एसे गालीलग्‍याम खाइमै खालै अगमवक्ता आख भिबा ताम था याङ्ला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","जमाहेन्‍से थेनीगदे जम्‍मान ह्राङ ह्राङला दिमरी निजी। ");
INSERT INTO taj_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","तर येशू चा जैतून भिबा गङरी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","येशू न्‍हङगरदङ स्‍य्‍होरीन परमेश्‍वरला मन्‍दिररी फेप्‍खजी। जमाहेन्‍से जम्‍मान म्‍हिगदे येशू मुबा ग्‍लारी खजी। ओच्‍छे येशू धन्‍छ्‌यासी जम्‍मान म्‍हिगदेदा लोप्‍बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","यहूदी धर्मगुरुगदेदेन फरिसीगदेसे स्‍य्‍हान्‍दोदेन छ्‌याम ब्रेल्‍सी चिबान लबा धुइरी स्‍याप्‍बा म्रिङम्‍हेमेदा चुङ्सी येशू मुबा ग्‍लारी भजी। ओच्‍छे जम्‍मालान ङाच्‍छा थे म्रिङम्‍हेमेदा राप्‍सी चिपुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","थेनीगदेसे येशूदा चुह्रङ् भिसी भिजी, “गुरु, चु स्‍य्‍हान्‍दोदेन छ्‌याम ब्रेल्‍बान लबा म्रिङम्‍हेमेदा चुङ्सी ङन्‍से ह्राङ मुबा ग्‍लारी भसी खबा मुला। ");
INSERT INTO taj_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","य्‍हाङला मोशासे ठिमरी चुह्रङ्बा म्रिङम्‍हेमेदा युङबासे तोसी साइगो भिसी कुल्‍बा मुला। ह्राङसे चा चुला बारेरी तिग सुङ्बा?” ");
INSERT INTO taj_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","तर येशूदा दोष लम्‍याङ्ला कि भिसी थेनीगदेसे चुह्रङ् भिसी ङ्‌योइबा मुबा। येशूसे कू तसी या जुम्‍बीसे सरी भ्रिबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","थेनीगदेसे येशूदा ङ्‌योइबाला ङ्‍योइबान लमाहेन्‍से येशू राप्‍सी थेनीगदेदा “जुन म्‍हिसे खाइमै पाप लबा आरे थेसे ङाच्‍छा चु म्रिङम्‍हेमेदा युङबासे तोउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","जमाहेन्‍से येशूसे दोःसी कू तसी सरी भ्रिजी। ");
INSERT INTO taj_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","चु ताम थेःसी थेरी मुबा जम्‍मान म्‍हिगदे घ्रेनहेन्‍से जजाधोना गिक गिक लसी थेग्‍याम निजी। ओच्‍छे थेरी येशूदेन छ्‌याम थे म्रिङम्‍हेमे जे तजी। थे म्रिङम्‍हेमे चा अझ येशूला ङाच्‍छापट्टि राप्‍सी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","जमाहेन्‍से येशू राप्‍सी थे म्रिङम्‍हेमेदा चुह्रङ् भिसी सुङ्जी, “खाइ, एदा दोष लबा म्‍हिगदे खानङ निजी? तिग थेनीगदे खालैसेन एदा सजाय आपिन्‍नी?” ");
INSERT INTO taj_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","जमाहेन्‍से थे म्रिङम्‍हेमेसे येशूदा “प्रभु, खालैसेन तिगै आलनी” भिसी भिमा, येशूसे थेदा “ङाइएनोन एदा सजाय आपिन, दाहेन्‍से निउ, तर दोःसी पाप थालउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","दोःसीनोन येशूसे म्‍हिगदेदा लोप्‍बान, “जम्‍बुलिङला य्‍हाल ङानोन हिन्‍ना। ङादेन छ्‌याम भ्रबा म्‍हि खाइमै धोपधोपरी भ्रआतोः। तिग्‍दा भिसम थेसे जुनी पिन्‍बा य्‍हाल याङ्ला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","जमाहेन्‍से फरिसीगदेसे येशूदा “एसे ह्राङलान बारेरी पाङ्‌बान मुला, एसे पाङ्बा ताम सत्‍य आहिन” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “ङाइ ङालान बारेरी पाङ्सैनोन ङाइ पाङ्बा ताम सत्‍य हिन्‍ना। तिग्‍दा भिसम ङा खानङग्‍याम खबा हिन्‍ना, ओच्‍छे खानङ निबान मुला भिबा ताम ङादा था मुला। तर एनीगदेदा चु ताम था आरे। ");
INSERT INTO taj_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","एनीगदेसे मी म्‍हिला ज्ञान बुद्धिग्‍याम निसाफ लमुला। तर ङाइ मी खालैला निसाफ आल। ");
INSERT INTO taj_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","चुदे ङा ह्राङसेन निसाफ लतोःजी भिसम ङाइ लबा निसाफ चा सत्‍य तला। तिग्‍दा भिसम ङा गिक जे आरे, तर ङादा पुइखबा आबाएनोन ङादेन छ्‌याम मुला। ");
INSERT INTO taj_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","मोशासे पिन्‍बा एनीगदेला ठिमरी म्‍हि न्‍हीसे पाङ्बा ताम चा सत्‍य तमुला भिसी भ्रिबा मुला। ");
INSERT INTO taj_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ह्राङलान बारेरी सत्‍य ताम पाङ्बा म्‍हि गिक चा ङानोन हिन्‍ना, ओच्‍छे स्‍य्‍हान्‍दो चा ङादा पुइखबा आबा हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","चु ताम थेःसी थेनीगदेसे येशूदा “एला आबा खानङ मुला?” भिसी ङ्‌योइमा, येशूसे थेनीगदेदा “एनीगदेसे ङादाएनोन ङोसेबा आरे, ङाला आबादाएनोन ङोसेबा आरे। चुदे एनीगदेसे ङादा ङोसेबा हिन्‍सम ङाला आबादाएनोन ङोसेसेला मुबा” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","चु जम्‍मान ताम येशूसे परमेश्‍वरला मन्‍दिररी भेटी युबा ताङ मुबा ग्‍लाग्‍याम लोप्‍बान लबा धुइरी सुङ्बा मुबा। तर थेनीगदे खालैसेन येशूदा आचुङ्नी। तिग्‍दा भिसम अझ येशूला धुइ तबा आरेमुबा। ");
INSERT INTO taj_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","दोःसी येशूसे थेनीगदेदा “ङा चुग्‍याम निनोन निला, ओच्‍छे एनीगदेसे ङादा म्‍हाइला। तर एनीगदे ह्राङलान पापरी सिला। ङा निबा ग्‍लारीनोन एनीगदे खबारी आखम” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","चु ताम थेःसी यहूदी नेतागदेसे “चु म्‍हि सिबारी म्‍हाइबा कि तिग? चुसे मी ‘ङा निबा ग्‍लारी एनीगदे खबारी आखम भिसी भिमुला’ भिसी ह्राङ ह्राङ न्‍हङ‍री ताम लजी।” ");
INSERT INTO taj_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","जमाहेन्‍से येशूसे थेनीगदेदा “एनीगदे मारग्‍याम खबा हिन्‍ना, ङा तोरग्‍याम खबा हिन्‍ना। एनीगदे चुनोन जम्‍बुलिङला हिन्‍ना, तर ङा चा चु जम्‍बुलिङला आहिन। ");
INSERT INTO taj_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","थेतबासेलमा ‘एनीगदे ह्राङलान पापरी सिला’ भिसी ङाइ एनीगदेदा पाङ्सी जिन्‍बा मुला। चुदे एनीगदेसे ‘ङा थेनोन हिन्‍ना’ भिसी ङादा विश्‍वास आलनी भिसम एनीगदे ह्राङलान पापरी सिला।” ");
INSERT INTO taj_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","जमाहेन्‍से थेनीगदेसे येशूदा “ए खाल हिन्‍ना?” भिसी ङ्‌योइमा, येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “ङा थेनोन हिन्‍ना, चु ताम ङाइ एनीगदेदा ङाच्‍छान पाङ्बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","एनीगदेला बारेरी ङाइ पाङ्तोःबा तामदेन एनीगदेला निसाफ लतोःबा ताम ल्‍हानान मुला। तर ङादा पुइखबा चा सत्‍य मुला, ओच्‍छे थेग्‍याम ङाइ जुन ताम थेःजी थेनोन ताम ङाइ जम्‍बुलिङला म्‍हिगदेदा पाङ्बा मुला।” ");
INSERT INTO taj_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","येशूसे परमेश्‍वर आबाला बारेरी सुङ्बान मुबा भिबा ताम थेनीगदेसे आघोनी। ");
INSERT INTO taj_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","थेतबासेलमा येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदेसे परमेश्‍वरसे पुइखबा म्‍हिदा तोर थीमाहेन्‍से जे ङा थेनोन चीम भिबादेन ङाइ ङालान सेमग्‍याम ताम पाङ्बा आहिन्‍बा चीम, तर परमेश्‍वर आबासे लोप्‍बा अन्‍छार जे पाङ्बा चीम भिबा ताम एनीगदेसे था याङ्ला। ");
INSERT INTO taj_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ओच्‍छे ङादा पुइखबा ङादेन छ्‌यामनोन मुला, थेसे ङादा खाइमै आख्‍लामुला। तिग्‍दा भिसम ङाइ सदन थेदा सेम निबा गे जे लमुला।” ");
INSERT INTO taj_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","चु ताम थेःसी ल्‍हानान म्‍हिगदेसे येशूदा विश्‍वास लजी। ");
INSERT INTO taj_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","येशूसे ह्राङदा विश्‍वास लबा यहूदीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदे ङाइ लोप्‍बा अन्‍छार भ्रजी भिसम एनीगदे ङाला पक्‍का चेला दोला। ");
INSERT INTO taj_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ओच्‍छे सत्‍य तिग हिन्‍ना भिसी एनीगदेसे था याङ्ला, थेनोन सत्‍यसे एनीगदे खालैला तहरी चिआतोः।” ");
INSERT INTO taj_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","थेनीगदेसे येशूदा “ङनी अब्राहामला सन्‍तान हिन्‍ना, दान्‍देधोना ङनी खालैला नोकर दोबा आरे। ह्राङसे ङन्‍दा स्‍य्‍हान्‍दोला तहग्‍याम फेला भिसी सुङ्बाला अर्थ चा तिग हिन्‍ना?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","जमाहेन्‍से येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, पाप लबागदे जम्‍मान पापला तहरी तला। ");
INSERT INTO taj_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","नोकर सदन मालिकला दिमरी आचि, तर झा चा सदन चिला। ");
INSERT INTO taj_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","थेतबासेलमा परमेश्‍वरला झासे एनीगदेदा फेजी भिसम एनीगदे पक्‍कान फेला। ");
INSERT INTO taj_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","एनीगदे अब्राहामला सन्‍तान हिन्‍ना भिसी ङादा था मुला। तसैनोन एनीगदेसे ङाइ पाङ्बा ताम नाबारी आखम्‍बासे लमा ङादा साइबारी म्‍हाइबा मुला। ");
INSERT INTO taj_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ङा ङाला आबादेन छ्‌याम मुबा धुइरी ङाइ जुन ताम म्राङ्मुबा, थेनोन ताम ङाइ एनीगदेदा पाङ्बा हिन्‍ना। तर एनीगदेसे चा एनीगदेला आबाग्‍याम तिग थेःबा मुला थेनोन लमुला।” ");
INSERT INTO taj_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","थेनीगदेसे येशूदा “ङन्‍ना आबा चा अब्राहामनोन हिन्‍ना” भिसी भिमा, येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदे पक्‍कान अब्राहामला सन्‍तान हिन्‍सम अब्राहामसे लबा ह्रङ्‌बा गे एनीगदेसेनोन लसेला मुबा। ");
INSERT INTO taj_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","तर ङाइ परमेश्‍वरग्‍याम थेःबा सत्‍य ताम एनीगदेदा पाङ्‌मा एनीगदेसे चा ङादा साइबारी म्‍हाइजी। तर अब्राहामसे मी चुह्रङ्बा गे आलनी। ");
INSERT INTO taj_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","एनीगदेला आबासे जुन गे लबा मुबा, थेनोन गे एनीगदेसेनोन लबा मुला।” जमाहेन्‍से थेनीगदेसे येशूदा “ङनी स्‍य्‍हान्‍दोदेन छ्‌याम ब्रेल्‍सी भ्रमा न्‍हबा कोलागदे आहिन, तर परमेश्‍वरनोन ङन्‍ना आबा हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “च्‍यागो, एनीगदेला आबा परमेश्‍वरनोन हिन्‍सम एनीगदेसे ङादा माया लसेला मुबा। तिग्‍दा भिसम परमेश्‍वरसे पुइखबासे लमा ङा दान्‍दे चुरी मुला। ङा ह्राङला सुरसे खबा आहिन, तर परमेश्‍वरसेन ङादा पुइखबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","एनीगदेसे तिग्‍दा ङाइ पाङ्बा ताम आघोबा? तिग्‍दा भिसम एनीगदेसे ङाला ताम नाआखम्‍नी। ");
INSERT INTO taj_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","एनीगदेला आबा शैतान हिन्‍ना, एनीगदेसे ह्राङला आबासे म्‍हन्‍बा अन्‍छारनोन गे लमुला। थेसे मी ङाच्‍छाहेन्‍से म्‍हि साइबा मुबा, थे सत्‍यरी खाइमै भ्रबारी आखम। तिग्‍दा भिसम थेदेन छ्‌याम सत्‍य भिबा मुनोन आरे। थेसे सदन ह्राङला बानीबेहोर अन्‍छार लुसीला ताम पाङ्‌मुला। थेतबासेलमा थे लुसीला ताम पाङ्बा म्‍हि हिन्‍ना, थे जम्‍मान लुसीला तामला आबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","तर एनीगदेसे ङाला ताम विश्‍वास आलमुला। तिग्‍दा भिसम ङाइ सत्‍य ताम पाङ्‌मुला। ");
INSERT INTO taj_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","एनीगदे न्‍हङला खाल्‍से ङादा पापी भिसी दोष लबारी खम्‍ला? ङाइ सत्‍य ताम पाङ्‌मा एनीगदेसे तिग्‍दा ङादा विश्‍वास आलबा? ");
INSERT INTO taj_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","परमेश्‍वरला म्‍हिगदेसे परमेश्‍वरला ताम ङ्‍यान्‍मुला। तर एनीगदे चा परमेश्‍वरला म्‍हि आहिन। थेतबासेलमा एनीगदेसे परमेश्‍वरला ताम आङ्‌यान्‍मुला।” ");
INSERT INTO taj_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","यहूदी नेतागदेसे येशूदा “ङन्‍से पाङ्बा ताम ठीक हिन्‍ना। ए सामरी य्‍हुलला हिन्‍ना, एदा म्‍हङसे स्‍याप्‍बा मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “ङादा म्‍हङसे स्‍याप्‍बा आरे। ङाइ ङाला आबादा मान लबा मुला, तर एनीगदेसे ङादा पेःना लमुला। ");
INSERT INTO taj_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ङाइ ङादा मान लगै भिसी म्‍हन्‍बा आहिन, तर ङादा मान लबादेन ङाला लागिरी निसाफ लसी पिन्‍बा म्‍हि स्‍य्‍हान्‍दोन मुला। ");
INSERT INTO taj_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","थेतबासेलमा च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, चुदे खालै म्‍हिसे ङाला ताम ङ्‌यान्‍जी भिसम थे खाइमै आसि।” ");
INSERT INTO taj_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","यहूदीगदेसे येशूदा चुह्रङ् भिसी भिजी, “एदा म्‍हङसे स्‍याप्‍बान हिन्‍ना भिसी दाहेन्‍से ङन्‍दा पक्‍का था तजी। तिग्‍दा भिसम अब्राहामदेन अगमवक्तागदे सिजी, तर एसे चा ‘खालै म्‍हिसे ङाइ पाङ्बा ताम ङ्‌यान्‍जी भिसम थे खाइमै आसि’ भिसी भिमुला। ");
INSERT INTO taj_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","तिग ए ङन्‍ना म्‍हेमे अब्राहाम भन्‍दा घ्रेन हिन्‍ना? थे सिजी, ओच्‍छे अगमवक्तागदेएनोन सिजी। एसे चा ह्राङदा खाल भिसी म्‍हन्‍बा?” ");
INSERT INTO taj_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “ङाइ ह्राङदा मान लगै भिसी म्‍हन्‍जी भिसम थे गे आखेल्‍बा ताम हिन्‍ना। तर ङादा मान पिन्‍बा चा ङालान आबा हिन्‍ना, ङाला आबादान एनीगदेसे य्‍हाङला परमेश्‍वर भिसी पाङ्‌मुला। ");
INSERT INTO taj_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","तर एनीगदेसे थेदा ङोसेबा आरे। ङाइ चा थेदा ज्‍यना लसी ङोसेबा मुला। चुदे ङाइएनोन थेदा ङोसेबा आरे भिसी भिजी भिसम ङाएनोन एनीगदे ह्रङ्‌बान लुसीला ताम पाङ्बा म्‍हि दोला। तर ङाइ थेदा ङोसेबा मुला, ओच्‍छे थेसे सुङ्बा अन्‍छारनोन ङाइ गे लबा मुला। ");
INSERT INTO taj_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","एनीगदेला म्‍हेमे अब्राहामसेनोन ङा खबा धिन च्‍याबारी ल्‍हानान सेम लबा मुबा। ओच्‍छे थेसे ङा खबा धिन म्राङ्सी जिन्‍बासे लमा ताङ्जी।” ");
INSERT INTO taj_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","थेतबासेलमा यहूदीगदेसे येशूदा “एसे बोगल न्‍हीसे च्‍युइ दिङ मी तबा आरे भिसम खाह्रङ् लसी एसे अब्राहामदा म्राङ्जी?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","जमाहेन्‍से येशूसे थेनीगदेदा “च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, अब्राहाम न्‍हबा भन्‍दा ङाच्‍छाहेन्‍सेन ‘ङा थेनोन हिन्‍ना’ भिबा मुनोन मुबा” भिसी सुङ्मैछ्‌याम, ");
INSERT INTO taj_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","थेनीगदेसे येशूदा तोबारी भिसी युङबा दुइजी। तर येशू लासी परमेश्‍वरला मन्‍दिरला ग्‍यापग्‍याम सुटुक्‍क थोन्‍सी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","थेग्‍याम फेप्‍बान लमा येशूसे न्‍हमान मी आम्राङ्बा म्‍हि गिकदा स्‍याप्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","येशूला चेलागदेसे येशूदा “गुरु, खाल्‍ला पापसे लमा चु म्‍हि न्‍हमान काना न्‍हजी, चुलान पापसे लमा कि चुला आबा आमाला पापसे लमा चुह्रङ् तबा हिन्‍ना?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","जमाहेन्‍से येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “थेला पापसे लमाएनोन आहिन, थेला आबा आमाला पापसे लमाएनोन आहिन। तर परमेश्‍वरला गे थेग्‍याम म्राङ्‍गै भिसीन थे काना तबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","धिनी मुबा धुइरीन य्‍हाङसे ङादा पुइखबाला गे लतोःला। धोप तमाहेन्‍से खालैसेन गे लबारी आखम। ");
INSERT INTO taj_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ङा जम्‍बुलिङरी चितेधोना ङानोन जम्‍बुलिङला य्‍हाल हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","चुह्रङ् सुङ्माहेन्‍से येशूसे सरी थो स्‍वाजी, ओच्‍छे थोसे साप्रा ज्‍योप्‍सी थे काना म्‍हिला मीरी फोर्सी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ओच्‍छे थेदा चुह्रङ् भिसी सुङ्जी, “सिलोआम भिबा घ्‍योइरी निसी ली ख्रुउ।” सिलोआम भिबाला अर्थ चा पुइबा हिन्‍ना। ओच्‍छे थे, थे घ्‍योइरी निसी ली ख्रुजी। जमाहेन्‍से थेसे म्राङ्जी, ओच्‍छे दोःसी खजी। ");
INSERT INTO taj_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","थेला खिम्‍जेमगदेदेन थेदा ङाच्‍छा ह्रीसी चिबा म्राङ्बा म्‍हिगदेसे “तिग चु थे ह्रीबा म्‍हि आहिन?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","कोइ कोइ म्‍हिसे थेदा म्राङ्सी, “चु मी थेनोन ह्रीबा म्‍हि हिन्‍ना” भिसी भिबान मुबा। स्‍य्‍हान्‍दोगदेसे चा हिन्‍बाम थे ह्रङ्‌बान म्राङ्बा चीम, तर थे म्‍हि “आहिन” भिसी भिजी। तर थे म्‍हिसे “ङा थेनोन हिन्‍ना” भिसी भिबाला भिबान मुबा। ");
INSERT INTO taj_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","थेनीगदेसे थेदा “दान्‍दे एसे खाह्रङ् लसी म्राङ्जी?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","जमाहेन्‍से थेसे थेनीगदेदा “येशू भिबा म्‍हि गिकसे साप्रा ज्‍योप्‍सी ङाला मीरी फोर्सी ङादा ‘सिलोआमरी निसी ख्रुउ’ भिसी सुङ्जी। ओच्‍छे निसी ख्रुमाहेन्‍से ङाइ म्राङ्जी” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","थेनीगदेसे थेदा “थे म्‍हि खानङ मुला?” भिसी ङ्‌योइमा, थेसे “ङादा था आरे” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","जमाहेन्‍से थेनीगदेसे ङाच्‍छा काना मुबा म्‍हिदा फरिसीगदे मुबा ग्‍लारी भोर्जी। ");
INSERT INTO taj_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","येशूसे साप्रा ज्‍योप्‍सी थेला मीरी फोर्सी थेदा खम्‍ना लबा धिन चा ब्‍लप्‍बा न्‍हबा धिनकुनु मुबा। ");
INSERT INTO taj_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","फरिसीगदेसेनोन थेदा “एसे खाह्रङ् लसी म्राङ्जी?” भिसी ङ्‌योइमा, थेसे थेनीगदेदा “येशूसे साप्रा ज्‍योप्‍सी ङाला मीरी फोर्सी पिन्‍जी, ओच्‍छे ङाइ ख्रुमाहेन्‍से म्राङ्जी” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","फरिसीगदे न्‍हङला कोइ कोइसे “थे म्‍हि परमेश्‍वरग्‍याम खबा आहिन। तिग्‍दा भिसम थेसे ब्‍लप्‍बा न्‍हबा धिन‍दा आधङ्‍मुला” भिसी भिजी। तर स्‍य्‍हान्‍दोगदेसे चा “पापी म्‍हिसे खाह्रङ् लसी चुह्रङ्बा उदेकला गे लबारी खम्‍ला?” भिसी भिजी। थेतबासेलमा थेनीगदे ह्राङ ह्राङ न्‍हङ‍री आढिक्‍नी। ");
INSERT INTO taj_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","थेनीगदेसे दोःसीनोन थे काना म्‍हिदा “थे म्‍हिसे एला मी खम्‍ना लजी, दाहेन्‍से एसे चा थे म्‍हि खाल भिसी म्‍हन्‍बा मुला” भिसी ङ्‌योइमा, थेसे “थे म्‍हि अगमवक्ता हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","यहूदी नेतागदेसे थे पक्‍कान काना मुबा, ओच्‍छे दान्‍दे म्राङ्‌खम्‍बा हिन्‍ना भिसी विश्‍वास लबारी आखम्‍नी। थेतबासेलमा थेनीगदेसे थेला आबा आमादा ङ्‌योइसी, ");
INSERT INTO taj_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“चु एनीगदेलान झा हिन्‍ना? तिग चु न्‍हमान काना न्‍हबा हिन्‍ना? थेह्रङ् भिसम दान्‍दे चा चुसे खाह्रङ् लसी म्राङ्जी?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","जमाहेन्‍से थेला आबा आमासे चुह्रङ् भिसी भिजी, “हिन्‍ना, चु ङन्‍नान झा हिन्‍ना, चु न्‍हमान काना मुबा। ");
INSERT INTO taj_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","तर चुला मी खाल्‍से खम्‍ना लसी म्राङ्‌खम्‍जी भिबा ताम ङन्‍दा था आरे। चु दिङ छ्‍योसी जिन्‍बा म्‍हि हिन्‍ना, थेसे ह्राङला बारेरी ह्राङसेन पाङ्‌खम्‍ला। थेतबासेलमा ह्राङनीसे थेदान ङ्‌योइगो।” ");
INSERT INTO taj_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","यहूदी नेतागदेदेन छ्‌याम लोङ्सी थेनीगदेसे थेह्रङ् भिसी पाङ्बा हिन्‍ना। तिग्‍दा भिसम जुन म्‍हिसे येशूदा थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍ना भिसी विश्‍वास लला थेदा यहूदीगदे ह्रुप तबा दिमग्‍याम तेःतोःला भिसी यहूदीगदेसे ङाच्‍छान सल्‍लाह लसी जिन्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","थेतबासेलमान थेला आबा आमासे “चु दिङ छ्‍योसी जिन्‍बा म्‍हि हिन्‍ना, चुदान ङ्‌योइगो” भिसी पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","जमाहेन्‍से थेनीगदेसे दोःसीनोन थे काना म्‍हिदा ङ्‌योइसी, “एसे सत्‍य ताम पाङ्सी परमेश्‍वरदा मानदेन जयजयकार लउ, थे येशू चा पापी हिन्‍ना भिसी ङन्‍दा था मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","थे म्‍हिसे थेनीगदेदा “थे पापी हिन्‍ना कि आहिन भिबा ताम मी ङादा था आरे। तर ङाच्‍छा ङा काना मुबा, दान्‍दे ङाइ म्राङ्‌मुला भिबा ताम जे ङादा था मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","जमाहेन्‍से थेनीगदेसे थेदा “थे म्‍हिसे एदा तिग लजी? खाह्रङ् लसी थे म्‍हिसे एला मी खम्‍ना लजी?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","थेसे थेनीगदेदा “ङाइ ह्राङनीदा दोलोन पाङ्सी जिन्‍जी, तर ह्राङनीसे वास्‍तान आलनी दान्‍दे दोःसी तिग्‍दा ङ्‌योइबा, तिग ह्राङनीएनोन थेला चेला दोबारी म्‍हाइबा हिन्‍ना?” भिसी जोहाब पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","थेनीगदेसे थेदा खिसी लबान चुह्रङ् भिजी, “ए गा थेला चेला हिन्‍ना, ङनी मी मोशाला चेला हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","मोशादेन छ्‌याम परमेश्‍वरसे ताम लबा ङन्‍दा था मुला, तर चु म्‍हि चा खानङग्‍याम खजी थे ताम ङन्‍दाएनोन था आरे।” ");
INSERT INTO taj_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","जमाहेन्‍से थेसे थेनीगदेदा चुह्रङ् भिसी भिजी, “चु खाह्रङ्बा उदेकला ताम! येशूसे ङाला मी खम्‍ना लजी। तर ह्राङनीसे चा येशू खानङग्‍याम फेप्‍खजी भिबा ताम ङन्‍दा था आरे। ");
INSERT INTO taj_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","परमेश्‍वरसे पापी म्‍हिला ताम आङ्‌यान्‍मुला, तर थेदा मान लबादेन थेसे म्‍हन्‍बा अन्‍छार गे लबा म्‍हिला जे ताम ङ्‍यान्‍मुला भिसी य्‍हाङ जम्‍मादान था मुला। ");
INSERT INTO taj_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","जम्‍बुलिङ छ्‌यामाहेन्‍से दान्‍देधोना खालै म्‍हिसे न्‍हमान काना मुबा म्‍हिला मी खम्‍ना लजी भिबा ताम थेःबा आरे। ");
INSERT INTO taj_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","चु येशू परमेश्‍वरग्‍याम फेप्‍खबा आहिन्‍सम येशूसे चुह्रङ्बा तिगै गे लबारी आखम्‍सेला मुबा।” ");
INSERT INTO taj_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","थेनीगदेसे थेदा “ए पापरी न्‍हसी पापरीन छर्बा म्‍हिसे ङन्‍दा लोप्‍बारी म्‍हाइबा?” भिसी भिजी। ओच्‍छे थेनीगदेसे थेदा यहूदीगदे ह्रुप तबा दिमग्‍याम तेःजी। ");
INSERT INTO taj_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","यहूदीगदेसे थे काना म्‍हिदा यहूदीगदे ह्रुप तबा दिमग्‍याम तेःजी भिबा ताम येशूसे थेःजी। ओच्‍छे थेदेन छ्‌याम ह्रुप तसी येशूसे “तिग एसे परमेश्‍वरसे पुइखबा म्‍हिदा विश्‍वास लला?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","थेसे येशूदा “प्रभु, ङाइ थेदा विश्‍वास लबारी थे खाल हिन्‍ना?” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","येशूसे थेदा “थे म्‍हि एसे म्राङ्सी जिन्‍बा मुला, दान्‍दे थे म्‍हि एदेन छ्‌याम ताम लबान मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","चु ताम थेःसी थेसे येशूदा फ्‍या लबान, “प्रभु, ङाइ विश्‍वास लला” भिसी जयजयकार लजी। ");
INSERT INTO taj_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ओच्‍छे येशूसे, “कानागदेसे म्राङ्‍गै, ओच्‍छे ङा काना आहिन भिसी भिबा म्‍हिगदेसे चा थाम्राङ्‍गै भिसी निसाफ लबाला लागिरीन ङा चु जम्‍बुलिङरी खबा हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","चु ताम थेःसी थेरी मुबा कोइ कोइ फरिसीगदेसे येशूदा “तिग ङनीएनोन काना हिन्‍ना?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","जमाहेन्‍से येशूसे थेनीगदेदा “बरु एनीगदे कानान मुबा हिन्‍सम पापला दोष लगब आतसेला मुबा, तर एनीगदेसे ‘ङन्‍से म्राङ्‌मुला’ भिसी भिबासे लमा एनीगदेदा सदन पापला दोष तला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, ग्‍युला गोठेरी म्रापग्‍याम आवाङ्ना अर्गुपट्टिग्‍याम वाङ्बा म्‍हि चा य्‍होदेन डाँका हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","तर ग्‍युगदेला गोठालो चा म्रापग्‍याम वाङ्मुला। ");
INSERT INTO taj_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","गोठे ख्रुङ्बा म्‍हिसे गोठालोदा म्राप ठोङ्सी पिन्‍ना। जमाहेन्‍से गोठालोसे ग्‍युगदेदा मिन किन्‍सी किन्‍सी ङ्‌योइला। जमाहेन्‍से ग्‍युगदेसे गोठालोला काइ थेःला, ओच्‍छे गोठालोसे ग्‍युगदेदा मङग्‍यार भोर्ला। ");
INSERT INTO taj_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ह्राङला जम्‍मान ग्‍युगदे मङग्‍यार तेःसी जिन्‍माहेन्‍से गोठालो ङाच्‍छा ङाच्‍छा भ्रला, ओच्‍छे ग्‍युगदे चा गोठालोला लिच्‍छा लिच्‍छा भ्रला। तिग्‍दा भिसम ग्‍युगदेसे ह्राङला गोठालोला काइ ङोसेला। ");
INSERT INTO taj_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ङोआसेबा म्‍हिसे ङ्‌योइजी भिसम ग्‍युगदे थे म्‍हिदेन छ्‌याम आनि। बरु थे म्‍हिला काइ ङोआसेबासे लमा थेनीगदे लोङ्सी यार्ला।” ");
INSERT INTO taj_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","येशूसे थेनीगदेदा चु उखान सुङ्जी। तर थेनीगदेसे उखानना अर्थ आघोनी। ");
INSERT INTO taj_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","थेतबासेलमा दोःसीनोन येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, ग्‍युगदे वाङ्बा म्राप ङानोन हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ङा भन्‍दा ङाच्‍छा खबागदे चा जम्‍मान य्‍होदेन डाँका हिन्‍ना, तर ग्‍युगदेसे थेनीगदेला ताम आङ्‌यान्‍नी। ");
INSERT INTO taj_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","म्राप चा ङानोन हिन्‍ना, चुदे खालै म्‍हि ङाग्‍याम न्‍हङ‍री वाङ्‌जी भिसम थे जोगब तला। थेनीगदे गोठे न्‍हङ‍री निबा मङग्‍यार थोन्‍बा लला, ओच्‍छे पिङ पिङबा छे याङ्बा पाङरी चम्‍याङ्ला। ");
INSERT INTO taj_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“य्‍हो मी य्‍हो लबारी, साइबारी ओच्‍छे नाश लबारी भिसी जे खमुला। तर ङा मी थेनीगदेसे पूरान जुनी याङ्‌गै भिसी खबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ज्‍यबा गोठालो चा ङानोन हिन्‍ना। ह्राङला ग्‍युगदेदा जोगब लबाला लागिरी ज्‍यबा गोठालो चा सिबारीन तयार तमुला। ");
INSERT INTO taj_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","तर जुन म्‍हि ग्‍यु छबारी जे थान्‍ना ओच्‍छे थे साँच्‍चिलान गोठालो आहिन ओच्‍छे ग्‍युगदेएनोन थेला आहिन भिसम थेह्रङ्बा म्‍हि फार्बा खबा म्राङ्माहेन्‍से ग्‍युगदेदा ख्‍लासी यार्ला। ओच्‍छे फार्बासे ग्‍युगदेदा व्‍हाला, जमाहेन्‍से ग्‍युगदे ससा बङबङ तला। ");
INSERT INTO taj_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","थेसे ग्‍युगदेदा तिगै वास्‍ता आलना यार्ला। तिग्‍दा भिसम थे टाङगा किन्‍सी गे लबा म्‍हि जे हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“ज्‍यबा गोठालो चा ङानोन हिन्‍ना। आबासे ङादा, ङाइ आबादा ङोसेबा ह्रङ् लसी ङाइ ङाला ग्‍युगदेदा ङोसेमुला, ओच्‍छे ग्‍युगदेसेनोन ङादा ङोसेमुला। थेतबासेलमा ङाइ ङाला ग्‍युगदेला लागिरी ह्राङला ज्‍याननोन पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ङाला अर्गु ग्‍युगदेएनोन मुला, थेनीगदे चा चु गोठेला आहिन। ङाइ थेनीगदेदाएनोन भतोःबा मुला, थेनीगदेसे ङाला काइ थेःसी बगाल गिकनोन तला। ओच्‍छे थेनीगदेला गोठालोएनोन गिकनोन तला। ");
INSERT INTO taj_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“ङाइ ङाला प्राण पिन्‍बा चा दोःसी किन्‍बाला लागिरी हिन्‍ना। थेतबासेलमा ङाला आबासे ङादा माया लबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","खालैसे ङाग्‍याम ङाला प्राण किन्‍बारी आखम, तर ङाइ ङालान सेमसे ङाला प्राण पिन्‍ना। ङादा ङाला प्राण पिन्‍बा अधिकारएनोन मुला, दोःसी किन्‍बा अधिकारएनोन मुला। ङाला आबासे ङादा कुल्‍बा तामएनोन चुनोन हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","चु ताम थेःसी दोःसीनोन यहूदीगदे ह्राङ ह्राङ न्‍हङ‍री आढिक्‍नी। ");
INSERT INTO taj_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ल्‍हानान म्‍हिगदेसे येशूला बारेरी, “चु म्‍हङसे स्‍याप्‍सी म्‍योबा मुला। एनीगदेसे तिग्‍दा चुला ताम ङ्‌यान्‍बा?” भिसी ह्राङ ह्राङ न्‍हङ‍री पाङ्‌बान मुबा। ");
INSERT INTO taj_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","तर स्‍य्‍हान्‍दो म्‍हिगदेसे चा “म्‍हङसे स्‍याप्‍बा म्‍हिसे चुह्रङ्बा ताम लबारी आखम! तिग म्‍हङसे स्‍याप्‍बा म्‍हिसेनोन काना म्‍हिला मी खम्‍ना लबारी खम्‍ला?” भिसी पाङ्‌बान मुबा। ");
INSERT INTO taj_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","यरूशलेम शहररी परमेश्‍वरला मन्‍दिर अर्पण लबा चाड खबा मुबा। थे धुइ चा सेर्खरी मुबा। ");
INSERT INTO taj_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","येशू परमेश्‍वरला मन्‍दिरला सोलोमन भिबा दलानरी भ्रबान मुबा। ");
INSERT INTO taj_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","यहूदीगदे येशूला क्‍युर्सीन पोप तसी, “ह्राङसे ङन्‍दा खाइमाधोना अलमल तना लसी थान्‍बा? चुदे ह्राङ थार्बा पिन्‍बा ख्रीष्‍टनोन हिन्‍सम ङन्‍दा सिधान सुङ्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","जमाहेन्‍से येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “ङाइ ङाच्‍छान पाङ्सी जिन्‍बा मुला, तर एनीगदेसे विश्‍वास आलनी। ङाइ ङाला आबाग्‍याम अधिकार याङ्सी लबा गेग्‍यामसेन ङा खाल हिन्‍ना भिसी उन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","तर एनीगदेसे ङादा विश्‍वास आलनी, तिग्‍दा भिसम एनीगदे ङाला ग्‍युगदे आहिन। ");
INSERT INTO taj_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ङाला ग्‍युगदेसे ङाला काइ ङोसेमुला, ओच्‍छे ङाइएनोन थेनीगदेदा ङोसेमुला। थेनीगदे ङादेन छ्‌याम भ्रमुला। ");
INSERT INTO taj_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","थेनीगदे खाइमै नाश आत। तिग्‍दा भिसम ङाइ थेनीगदेदा जुकजुकधोनाला जुनी पिन्‍ना। ओच्‍छे खालैसेन थेनीगदेदा ङाग्‍याम ब्‍यन्‍सी भोर्बारी आखम। ");
INSERT INTO taj_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","चुगदे ङादा पिन्‍बा ङाला आबा चा जम्‍मान भन्‍दा घ्रेन मुला। थेग्‍यामसे मी झन खालैसेन चुगदेदा ब्‍यन्‍सी भोर्बारी आखम। ");
INSERT INTO taj_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","आबादेन ङा गिकनोन हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","चु ताम थेःसी यहूदी नेतागदेसे दोःसीनोन येशूदा तोबारी भिसी युङबा दुइजी। ");
INSERT INTO taj_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","तर येशूसे थेनीगदेदा “आबासे कुल्‍बा जम्‍मान ज्‍यबा गेगदे ङाइ एनीगदेला ओन्‍छाङरी लबा मुला। थे गेगदे न्‍हङला खजिबा गेला लागिरी एनीगदेसे ङादा युङबासे तोबारी म्‍हाइबा?” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","जमाहेन्‍से यहूदी नेतागदेसे येशूदा “एसे ज्‍यबा गे लबासे लमा ङन्‍से एदा युङबासे तोबारी म्‍हाइबा आहिन। तर एसे परमेश्‍वरला बिरोध लसी ताम लबासे लमान ङन्‍से एदा युङबासे तोबारी छ्‌याइबा हिन्‍ना। ए म्‍हि तसीनोन ह्राङसे ह्राङदान परमेश्‍वर स्‍होबा?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदेला ह्राङलान ठिमरी ‘एनीगदे ल हिन्‍ना’ भिसी परमेश्‍वरसे सुङ्बा ताम भ्रिबा आरे? ");
INSERT INTO taj_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","जुन म्‍हिगदे मुबा ग्‍लारी परमेश्‍वरला बचन खजी परमेश्‍वरसे थेनीगदेन ल हिन्‍ना भिसी पाङ्‌मा परमेश्‍वरला बचन न्‍होङ्बारी आखम्‍नी भिसम, ");
INSERT INTO taj_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","परमेश्‍वर आबासेन धम्‍सी चु जम्‍बुलिङरी पुइखबा म्‍हिसे ‘ङा परमेश्‍वरला झा हिन्‍ना’ भिसी पाङ्‌मा खाह्रङ् लसी ङाइ परमेश्‍वरला बिरोध लबा तला? ");
INSERT INTO taj_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","चुदे ङाइ ङाला आबाला गे लबा आरे भिसम ङादा विश्‍वास लआतोः। ");
INSERT INTO taj_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","तर चुदे ङाइ ङाला आबाला गे लसीनोन ङादा विश्‍वास आल भिसम चु गेगदेदा मी विश्‍वास लउ। जमाहेन्‍से एनीगदेसे परमेश्‍वर आबा ङादेन छ्‌याम ङा परमेश्‍वर आबादेन छ्‌याम मुला भिबा ताम पक्‍कान था याङ्ला।” ");
INSERT INTO taj_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","चु ताम थेःसी थेनीगदेसे दोःसीनोन येशूदा चुङ्बारी म्‍हाइजी। तर येशू थेनीगदेला याग्‍याम स्‍योर्जी। ");
INSERT INTO taj_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","येशू दोःसीनोन यर्दन स्‍योङला क्‍याम्‍सङ फेप्‍सी धन्‍छ्‌याजी। थे ग्‍लारी ङाच्‍छा यूहन्‍नासे बप्‍तिस्‍मा पिन्‍मुबा। ");
INSERT INTO taj_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ल्‍हानान म्‍हिगदे येशू मुबा ग्‍लारी खजी। ओच्‍छे थेनीगदेसे, “यूहन्‍नासे मी तिगै उदेकला गे आलनी, तर यूहन्‍नासे येशूला बारेरी जुन जुन ताम पाङ्मुबा थे जम्‍मान ताम सत्‍य चीम” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ओच्‍छे थेरी ल्‍हानान म्‍हिगदेसे येशूदा विश्‍वास लजी। ");
INSERT INTO taj_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","बेथानिया भिबा नाम्‍सारी लाजरस भिबा म्‍हि गिक आखम्‍बा मुबा। थेनोन नाम्‍सारी मरियमदेन थेला नाना मार्थाएनोन चिमुबा। ");
INSERT INTO taj_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","चुनोन मरियमसे तिरेम येशूला स्‍य्‍हापरी अत्तर फोर्सी ह्राङलान क्रासे फ्‍यामुबा। आखम्‍बा लाजरस चा चुनोन नाना आङाला आले मुबा। ");
INSERT INTO taj_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","मार्थादेन मरियमसे येशूदा “प्रभु, ह्राङसे माया लबा म्‍हि आखम्‍बा मुला” भिसी समाचार पुइजी। ");
INSERT INTO taj_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","चु समाचार थेःसी येशूसे “लाजरस आखम्‍बा मुला, तसैनोन थे आसि। तर चुह्रङ् तबा चा परमेश्‍वरला मानदेन जयजयकार तबाला लागिरी हिन्‍ना, ओच्‍छे चुग्‍यामसेन म्‍हिगदेसे परमेश्‍वरला झादाएनोन मानदेन जयजयकार लला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","येशूसे मार्था, मरियमदेन लाजरसदा ल्‍हानान माया लमुबा। ");
INSERT INTO taj_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","तसैनोन लाजरस आखम्‍बा मुला भिबा ताम थेःसी येशू अझ ह्राङ धन्‍छ्‌याबा ग्‍लारीन न्‍हीरेधोना धन्‍छ्‌याजी। ");
INSERT INTO taj_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","जमाहेन्‍से येशूसे ह्राङला चेलागदेदा “लु, दाहेन्‍से य्‍हाङ दोःसीनोन यहूदिया अञ्‍चलरी निइ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","चेलागदेसे येशूदा “गुरु, ओने जे ह्राङदा थेरी यहूदीगदेसे युङबासे तोबारी म्‍हाइमुबा, तिग दोःसीनोन ह्राङ थेरीन फेप्‍बारी म्‍हाइबा?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “तिग धिन गिकरी च्‍युक न्‍ही घण्‍टा आत? धिनीरी भ्रबा म्‍हिला काङ आठोक। तिग्‍दा भिसम थेसे जम्‍बुलिङरी धिनीग्‍याम य्‍हाल याङ्ला। ");
INSERT INTO taj_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","तर म्‍हुनङ भ्रबा म्‍हिला काङ ठोक्‍ला। तिग्‍दा भिसम म्‍हुनङ थेदेन छ्‌याम य्‍हाल आत।” ");
INSERT INTO taj_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","जमाहेन्‍से येशूसे थेनीगदेदा “य्‍हाङला ह्रो लाजरस म्‍हेर्बा मुला। तर ङा थेदा छिङ्बारी थेरी नितोःला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","चेलागदेसे येशूदा “प्रभु, थे म्‍हेर्बा जे हिन्‍सम थे खम्‍ला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","येशूसे सुङ्बा चा लाजरस सिसी जिन्‍जी भिसी सुङ्बा, तर थेनीगदेसे चा लाजरस म्‍हेर्बा जे चीम भिसी म्‍हन्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","थेतबासेलमा येशूसे थेनीगदेदा सिधान सुङ्जी, “लाजरस सिसी जिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","तर एनीगदेसे विश्‍वास लगै भिसी ङा थेरी तुरुन्‍तन आनिबा हिन्‍ना। थेतबासेलमा ङा ताङ्‍बा मुला। दाहेन्‍से भ्रउ, य्‍हाङ थे मुबा ग्‍लारी निइ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","जमाहेन्‍से येशूला चेला दिदुमस भिबा थोमासे स्‍य्‍हान्‍दो चेलागदेदा “लु, य्‍हाङएनोन गुरुदेन छ्‌याम निइ, सितोःसै गुरुदेन छ्‌यामनोन सिला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","येशू बेथानिया भिबा नाम्‍सारी धोखमा लाजरसदा धुर्सा न्‍हङ‍री थान्‍बा ब्‍लिरे तसी जिन्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","बेथानिया नाम्‍सा यरूशलेम शहरग्‍याम कोस गिक ते थारेङ मुबा। ");
INSERT INTO taj_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","मार्थादेन मरियमला आले सिबासे लमा ल्‍हानान यहूदीगदे मार्थादेन मरियमदा सम्‍झब लबारी खबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","येशू फेप्‍खबान मुला भिबा ताम थेःसी मार्था येशूदा स्‍याप्‍बारी निजी। तर मरियम चा दिमरीन चिजी। ");
INSERT INTO taj_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","जमाहेन्‍से मार्थासे येशूदा स्‍याप्‍सी चुह्रङ् भिजी, “प्रभु, ह्राङ मुबा हिन्‍सम ङाला आले आसिसेला मुबा। ");
INSERT INTO taj_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","तर दान्‍देनोन ह्राङसे परमेश्‍वरदेन छ्‌याम जुन स्‍हे ह्रीसैनोन परमेश्‍वरसे ह्राङदा पिन्‍ना भिबा ताम ङादा था मुला।” ");
INSERT INTO taj_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","येशूसे मार्थादा “एला आले दोःसी सोला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","मार्थासे येशूदा “चु जम्‍बुलिङ नाश तबा धुइरी जम्‍मान म्‍हि सिबाग्‍याम सोमा थेएनोन सोला भिबा ताम ङादा था मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","येशूसे थेदा चुह्रङ् भिसी सुङ्जी, “सिबाग्‍याम सोना लबादेन जुनी पिन्‍बा ङानोन हिन्‍ना। ङादा विश्‍वास लबा म्‍हि सिसैनोन सोला। ");
INSERT INTO taj_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ओच्‍छे ङादेन छ्‌याम भ्रबादेन ङादा विश्‍वास लबा म्‍हि खाइमै आसि। तिग एसे चु ताम विश्‍वास लखम्‍ला?” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","मार्थासे येशूदा “हिन्‍ना प्रभु, ङाइ ह्राङदा विश्‍वास लला, ह्राङ परमेश्‍वरला झा जम्‍बुलिङरी फेप्‍खबा थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","चुह्रङ् भिसी मार्था निजी, ओच्‍छे ह्राङला आङा मरियमदा सुटुक्‍क ङ्‌योइसी, “गुरु धोखजी, एदा गुरुसे ङ्‍योइबान मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","चु ताम थेःमैछ्‌याम मरियम तुरुन्‍तन येशू मुबा ग्‍लारी निजी। ");
INSERT INTO taj_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","थे धुइधोना येशू नाम्‍सारी धोखबा आरेमुबा। तर येशू मार्थासे स्‍याप्‍बा ग्‍लारीन मुबा। ");
INSERT INTO taj_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","थेन्‍ना दिमरी थेन्‍दा सम्‍झब लबारी खबा यहूदीगदेसे मरियम योना योना लसी निबा म्राङ्जी। थे आलेला धुर्सारी क्राबारी निबा हिन्‍ना भिसी म्‍हन्‍सी थेनीगदे मरियमला लिच्‍छा लिच्‍छा निजी। ");
INSERT INTO taj_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","मरियम येशू मुबा ग्‍लारी धोमाहेन्‍से येशूदा फ्‍या लबान, “प्रभु, ह्राङ चुरी मुबा हिन्‍सम ङाला आले आसिसेला मुबा” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","मरियम ओच्‍छे थेदेन छ्‌याम खबा जम्‍मान यहूदीगदे क्राबा म्राङ्सी येशूदा ल्‍हानान दुख ङ्‌हम्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","जमाहेन्‍से येशूसे थेनीगदेदा “एनीगदेसे थेदा खानङ थान्‍बा मुला?” भिसी ङ्‌योइमा, थेनीगदेसे येशूदा “प्रभु, फेप्‍खसी स्‍हीगो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","थे धुइरी येशूएनोन क्राजी। ");
INSERT INTO taj_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","थेतबासेलमा यहूदीगदेसे “च्‍यागो, येशूसे थेदा गाते माया लमुबा” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","तर कोइ कोइ म्‍हिसे चा “तिग काना म्‍हिला मी खम्‍ना लबा चु म्‍हिसे थेदा खम्‍ना लबारी आखम्‍नी?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","जमाहेन्‍से येशू दोःसीनोन ल्‍हानान दुख ङ्‍हम्‍सी धुर्सारी फेप्‍जी। थे धुर्सा चा ऊ ह्रङ्‌बा मुबा। थे धुर्साला म्रापरी युङबा थान्‍मुबा। ");
INSERT INTO taj_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","येशूसे थेनीगदेदा “धुर्साला म्रापरी थान्‍बा युङबा तेः‍गो” भिसी सुङ्मा, सिबा म्‍हिला नाना मार्थासे येशूदा “प्रभु दान्‍देधोना मी थे थाङ खसी जिन्तला। तिग्‍दा भिसम थे सिबा ब्‍लिरे तसी जिन्‍जी” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","येशूसे थेदा “एसे विश्‍वास लजी भिसम परमेश्‍वरला घ्रेन य्‍हालदेन शक्ति म्राङ्ला भिसी ङाइ एदा पाङ्बा आहिन?” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","थेनीगदेसे युङबा लेःमाहेन्‍से स्‍वर्गपट्टि स्‍हीसी येशूसे चुह्रङ् भिसी सुङ्जी, “आबा, ह्राङदा धन्‍यवाद मुला। तिग्‍दा भिसम ह्राङसे ङाला बिन्‍ती ङ्‌यान्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ह्राङसे ङाला ताम सदन ङ्‍यान्‍मुला भिबा ताम ङादा था मुला। तसैनोन ङादा ह्राङसे चु जम्‍बुलिङरी पुइखबा हिन्‍ना भिबा ताम चुरी मुबा म्‍हिगदेसे विश्‍वास लबारी खम्‍गै भिसीन ङाइ ह्राङदा चु ताम पाङ्बा हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","चुह्रङ् सुङ्सी जिन्‍माहेन्‍से येशूसे घ्रेन काइरी “लाजरस, ए मङग्‍यार खउ” भिसी क्रिङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","जमाहेन्‍से सिबा लाजरस रेःसी मङग्‍यार खजी। अझन थेला थोबोहेन्‍से काङधोना खीबा मुबा। येशूसे थेरी मुबा म्‍हिगदेदा “थेदा खीबा क्‍वान ब्‍लसी थेदा निपुङ्‍गो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","येशूसे लबा चुह्रङ्बा उदेकला गे म्राङ्सी मरियमदा ह्रुप तबारी खबा ल्‍हानान यहूदीगदेसे येशूदा विश्‍वास लजी। ");
INSERT INTO taj_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","तर थेनीगदे न्‍हङला कोइ कोइ चा फरिसीगदे मुबा ग्‍लारी निसी येशूसे लबा गेला बारेरी पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","जमाहेन्‍से परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन फरिसीगदेसे जम्‍मान भन्‍दा घ्रेन यहूदी सभाला म्‍हिगदेदा ङ्‌योइसी चुह्रङ् भिसी भिजी, “चु म्‍हिसे ल्‍हानान उदेकला गेगदे लमुला। दाहेन्‍से य्‍हाङसे तिग लइ? ");
INSERT INTO taj_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","चु म्‍हिदा तिगै आलना ओह्रङ्नोन ख्‍लाजी भिसम जम्‍मान म्‍हिगदेसे चुदा विश्‍वास लला। ओच्‍छे रोमी सिपाहीगदे खसी य्‍हाङला परमेश्‍वरला मन्‍दिरदेन य्‍हाङला य्‍हुल नाश लला।” ");
INSERT INTO taj_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","कैयाफा भिबा म्‍हि परमेश्‍वरला मन्‍दिररी पूजा लबा थे दिङला मुल म्‍हि मुबा। थेसे थेनीगदेदा चुह्रङ् भिसी भिजी, “एनीगदेदा तिगै ताम था आरे। ");
INSERT INTO taj_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","जम्‍मान य्‍हुल्‍सा नाश तबा भन्‍दा बरु जम्‍मान म्‍हिला लागिरी म्‍हि गिक सिबान एनीगदेला लागिरी ज्‍यबा तला भिसी एनीगदेसे घोबा आरे।” ");
INSERT INTO taj_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","चु ताम थेसे ह्राङला सेमग्‍याम पाङ्बा आहिन मुबा। तर थे परमेश्‍वरला मन्‍दिररी पूजा लबा थे दिङला मुल म्‍हि तबासे लमा यहूदी य्‍हुलला लागिरी येशू सिनोन तोःला भिसी परमेश्‍वरला ताम पाङ्बा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ओच्‍छे थेसे चु ताम यहूदी य्‍हुलला लागिरी जे पाङ्बा आहिन मुबा। तर ससा बङबङ तसी चिबा परमेश्‍वरला जम्‍मान म्‍हिगदेदाएनोन गिक स्‍होबाला लागिरी थेसे चु ताम पाङ्बा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","थेतबासेलमा थे धिनहेन्‍से यहूदी नेतागदेसे येशूदा साइबारी सल्‍लाह लजी। ");
INSERT INTO taj_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","जमाहेन्‍से यहूदीगदेला ङाच्‍छा येशू दोःसी ङाच्‍छाला ह्रङ् लसी आभ्रनी। तर थे ग्‍लाग्‍याम तोङतोङबा ग्‍लाला ङामरी मुबा एफ्राइम भिबा शहररी फेप्‍सी थेरीन चेलागदेदेन छ्‌याम धन्‍छ्‌याजी। ");
INSERT INTO taj_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","यहूदीगदे मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाड खबारी छ्‌याइमुबा। थेतबासेलमा चाड खबा भन्‍दा ङाच्‍छान ह्राङ ह्राङदा चोखो स्‍होबाला लागिरी नाम्‍सा नाम्‍साग्‍याम ल्‍हानान म्‍हिगदे यरूशलेम शहररी निजी। ");
INSERT INTO taj_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","थेनीगदेसे येशूदा जम्‍मान ग्‍लारी म्‍हाइजी, ओच्‍छे थेनीगदे जम्‍मान परमेश्‍वरला मन्‍दिररी ह्रुप तबा धुइरी “एनीगदेदा खाह्रङ्बा छोर्बा मुला, तिग थे चु चाडरी खला?” भिसी ह्राङ ह्राङ न्‍हङ‍री ताम लजी। ");
INSERT INTO taj_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन फरिसीगदेसे चा येशूदा चुङ्बाला लागिरी थे जुन ग्‍लारी मुसै था याङ्बा म्‍हिसे “ङन्‍दा पाङ्‍गो” भिसी कुल्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","मिश्र य्‍हुल्‍साग्‍याम फेबा धिन‍दा ढन्‍सी धङ्बा चाड खबा भन्‍दा ढुरे ङाच्‍छा येशू लाजरसदा सिबाग्‍याम सोना लबा बेथानिया भिबा नाम्‍सारी धोखजी। ");
INSERT INTO taj_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","येशूला लागिरी थेनीगदेसे जमाकुनु ङ्‍यसे थेरीन सोल स्‍होजी। मार्थासे चा जम्‍मादान क्‍योङ्बान मुबा। येशूदेन छ्‌यामनोन चिबागदे न्‍हङ‍री गिक चा लाजरस मुबा। ");
INSERT INTO taj_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","थेनोन धुइरी मरियमसे जटामसी भिबा दोङला टाग्‍याम स्‍होबा महँगो खाल्‍ला ज्‍यबा बास्‍ना खबा अत्तर लिटर गङसल ते भसी येशूला स्‍य्‍हापरी फोर्सी ह्राङलान क्रासे येशूला स्‍य्‍हाप फ्‍याजी। ओच्‍छे दिम नाङनोन थे अत्तरला बास्‍ना खजी। ");
INSERT INTO taj_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","तर येशूदा चुङ्सी पिन्‍बारी म्‍हाइबा चेला यहूदा इस्‍करियोतसे चुह्रङ् भिसी भिजी, ");
INSERT INTO taj_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“चु अत्तर मी ग्‍यार्जा सोम म्‍हुइला डबलरी चूङ्सी थे टाङगा प्राङबोगदेदा पिन्‍सै तसेला।” ");
INSERT INTO taj_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","तर थेसे प्राङबोगदेदा वास्‍ता लसी चु ताम पाङ्बा आहिन मुबा। तिग्‍दा भिसम थे य्‍हो मुबा, ओच्‍छे टाङगाएनोन थेदेन छ्‌यामनोन थान्‍सी थेसेन य्‍हो लमुबा। ");
INSERT INTO taj_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","येशूसे चुह्रङ् भिसी सुङ्जी, “थेदा तिगै थापाङ्‍गो, ङादा ल्‍हुबा धिनना लागिरी चुसे चुह्रङ् लबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","तिग्‍दा भिसम प्राङबो म्‍हिगदे मी एनीगदेदेन छ्‌याम सदन तला, तर ङा चा एनीगदेदेन छ्‌याम सदन आत।” ");
INSERT INTO taj_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","येशू बेथानिया भिबा नाम्‍सारी मुला भिबा था याङ्सी ल्‍हानान यहूदीगदे थेरी खजी, थेनीगदे येशूदा च्‍याबारी जे खबा आहिन मुबा। तर येशूसे सिबाग्‍याम सोना लबा लाजरसदाएनोन च्‍याबारी खबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","थेतबासेलमा परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेसे लाजरसदाएनोन साइबारी सल्‍लाह लजी। ");
INSERT INTO taj_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","तिग्‍दा भिसम लाजरसदा सिबाग्‍याम सोना लबासे लमा ल्‍हानान यहूदीगदेसे थेनीगदेदा ख्‍लासी येशूदा विश्‍वास लबान मुबा। ");
INSERT INTO taj_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","न्‍हङगरदङसे मिश्र य्‍हुल्‍साग्‍याम फेबा धिन‍दा ढन्‍सी धङ्बा चाडरी खबा ल्‍हानान म्‍हिगदेसे येशू यरूशलेमरी फेप्‍खबान मुला भिबा ताम थेःजी। ");
INSERT INTO taj_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","जमाहेन्‍से खजूरला हाँगागदे क्‍युइसी थोबान म्‍हिगदेसे “थेला जयजयकार तगै, परमप्रभुला मिनरी फेप्‍खबासे परमेश्‍वरग्‍याम मोलम याङ्‌गै इस्राएलला ग्‍लेदा परमेश्‍वरसे मोलम पिन्‍गै” भिसी क्रिङ्बान येशूदा मान लबारी खजी। ");
INSERT INTO taj_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","येशूसे गधाला कोला गिक स्‍याप्‍जी ओच्‍छे थेनोन गधाला कोलाथोरी क्रेःसी फेप्‍खजी। परमेश्‍वरला बचनरीनोन चुह्रङ् लसी भ्रिबा मुला, ");
INSERT INTO taj_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“सियोनना म्‍हिगदे, एनीगदे थालोङ्‍गो। च्‍यागो, एनीगदेला ग्‍ले गधाला कोलाथोरी क्रेःसी फेप्‍खबान मुला।” ");
INSERT INTO taj_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ङाच्‍छा मी चु ताम येशूला चेलागदेसेनोन आघोनी। तर येशू सिबाग्‍याम सोसी स्‍वर्गरी घ्रेन य्‍हालदेन शक्तिरी फेप्‍माहेन्‍से जे थेनीगदेसे येशूला बारेरी भ्रिबा जम्‍मान ताम घोजी। ");
INSERT INTO taj_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","येशूसे धुर्सारी थान्‍बा लाजरसदा ङ्‌योइसी सिबाग्‍याम सोना लबा धुइरी येशूदेन छ्‌यामनोन मुबा म्‍हिगदेसे येशूसे लबा गेला बारेरी पाङ्सी भ्रजी। ");
INSERT INTO taj_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","येशूसे चुह्रङ्बा उदेकला गे लबा मुबा भिबा ताम थेःबासे लमाएनोन म्‍हिगदे येशूदा ह्रुप तबारी निबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","थेतबासेलमा फरिसीगदे ह्राङ ह्राङ न्‍हङ‍री “खाइ, य्‍हाङसे तिग लखम्‍जी। च्‍यागो, जम्‍बुलिङला जम्‍मान म्‍हिगदे थेदेन छ्‌याम भ्रबारी छ्‌याइजी” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","कोइ कोइ ग्रीस य्‍हुल्‍साला म्‍हिगदे मिश्र य्‍हुल्‍साग्‍याम फेबा धिन‍दा ढन्‍सी धङ्बा चाडरी पूजा लबाला लागिरी यरूशलेम शहररी खबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","थेनीगदे गालील अञ्‍चलला बेथसेदा भिबा नाम्‍सारी चिबा फिलिप मुबा ग्‍लारी निसी, “ङनी येशूदेन छ्‌याम ह्रुप तबा सेम मुला” भिसी बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","जमाहेन्‍से फिलिप निसी अन्‍द्रियासदा चु ताम पाङ्जी, ओच्‍छे थेनीनोन निसी येशूदा पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “दाहेन्‍से परमेश्‍वरसे पुइखबा म्‍हिदा मान लबा धुइ खसी जिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, बु वारीरी ढ्वबा ग्‍वाला ब्‍लु आसिनी भिसम थे गिक जेन तला। तर थे सिजी भिसम फुइसी थेरी ल्‍हानान ग्‍वा रोला। ");
INSERT INTO taj_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","थेतबासेलमा जुन म्‍हिसे ह्राङला ज्‍यान जोगब लबा सेम लला थे म्‍हिसे जुकजुकधोनाला जुनी आयाङ्। तर जुन म्‍हिसे जम्‍बुलिङरी मुमा ह्राङला ज्‍यान‍ना वास्‍ता आलना ङादेन छ्‌याम भ्रला, थेसे जुकजुकधोनाला जुनी सदन जोगब लसी थान्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","खालै म्‍हिसे ङाला लागिरी गे लबा सेम लजी भिसम थे ङादेन छ्‌याम भ्रतोःला। ओच्‍छे ङा जुन ग्‍लारी चिला, ङाला गे लबा म्‍हिएनोन ङादेन छ्‌यामनोन तला। खालै म्‍हिसे ङाला लागिरी गे लजी भिसम ङाला आबासे थेला मान बढब लसी पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","येशूसे चुह्रङ् भिसी सुङ्जी, “दान्‍दे ङादा सेमरी ल्‍हानान दुख तबा मुला, ङाइ तिग पाङ्से? ‘आबा ङादा चु दुखग्‍याम जोगब लउ’ भिसी पाङ्‌बारी तला? आत, तिग्‍दा भिसम ङा चु दुख नाबाला लागिरीन खबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","आबा, ह्राङ जम्‍मान भन्‍दा घ्रेन परमेश्‍वर हिन्‍ना भिबा ताम उन्‍गो।” जमाहेन्‍से स्‍वर्गग्‍याम “ङाइ ङा जम्‍मान भन्‍दा घ्रेन परमेश्‍वर हिन्‍ना भिबा ताम उन्‍सी जिन्‍बा मुला, चु ताम ङाइ अझ उन्‍ना” भिबा काइ खजी। ");
INSERT INTO taj_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","चु ताम थेःसी थेरी मुबा म्‍हिगदेसे “चु मु गुर्बा हिन्‍ना” भिसी भिजी। तर स्‍य्‍हान्‍दोगदेसे चा “स्‍वर्गदूत थेदेन छ्‌याम ताम लबा हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “स्‍वर्गग्‍याम खबा चु काइ ङाला लागिरी आहिन, तर एनीगदेला लागिरी हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","दाहेन्‍से चु धुइ चा जम्‍बुलिङरी मुबा म्‍हिगदेला निसाफ लबा धुइ हिन्‍ना, ओच्‍छे चु जम्‍बुलिङदा तहरी थान्‍बादा मङग्‍यार भ्‍याङ्‍ला। ");
INSERT INTO taj_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ओच्‍छे ङादा जम्‍बुलिङग्‍याम तोर थीमाहेन्‍से जम्‍मान म्‍हिदा ङाइ ङा मुबा ग्‍लारी भला।” ");
INSERT INTO taj_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","येशूसे ह्राङ खाह्रङ् लसी सिबान मुला भिबा ताम म्‍हिगदेसे घोगै भिसी चुह्रङ् सुङ्बा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","जमाहेन्‍से म्‍हिगदेसे येशूदा “थार्बा पिन्‍बा ख्रीष्‍ट सदन सोला भिबा ताम ङन्‍से ठिमग्‍याम थेःबा मुला। ह्राङसे चा तिग्‍दा ‘परमेश्‍वरसे पुइखबा म्‍हिदा तोर थीनोन तोःला’ भिसी सुङ्बा? परमेश्‍वरसे पुइखबा चु म्‍हि चा खाल हिन्‍ना?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “अझ छिन्‍नङ य्‍हाल एनीगदेदेन छ्‌याम तला। थेतबासेलमा य्‍हाल एनीगदेदेन छ्‌याम मुबा धुइरीन ह्राङ भ्रतोःबा ग्‍यामरी भ्रउ। आहिन्‍सम एनीगदेदा धोपधोपसे घप्‍ला, धोपधोपरी भ्रबा म्‍हिदा ह्राङ खानङ निबान मुला भिबा तामनोन था आत। ");
INSERT INTO taj_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","य्‍हाल एनीगदेदेन छ्‌याम मुबा धुइरी एनीगदेसे थेदा विश्‍वास लउ। थेह्रङ् लजी भिसम एनीगदे य्‍हालला सन्‍तान दोला।” चु ताम सुङ्सी जिन्‍माहेन्‍से येशू थे ग्‍याम फेप्‍सी थेनीगदेसे आम्राङ्बा ग्‍लारी धन्‍छ्‌याजी। ");
INSERT INTO taj_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","येशूसे यहूदीगदेलान ओन्‍छाङरी ल्‍हानान उदेकला गेगदे लबा मुबा। तसैनोन थेनीगदेसे येशूदा विश्‍वास आलनी। ");
INSERT INTO taj_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","यशैया अगमवक्तासे पाङ्बा ताम पूरा तबारीन चुह्रङ् तबा हिन्‍ना। यशैया अगमवक्तासे “परमप्रभु, ङन्‍से पाङ्बा ताम खाल्‍से विश्‍वास लजी? ओच्‍छे ह्राङसे लबा शक्तिशाली गे खाल्‍से म्राङ्जी?” भिसी पाङ्बा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","थेनीगदेसे विश्‍वास लआखम्‍नी, तिग्‍दा भिसम यशैया अगमवक्तासे दोःसी चुह्रङ् भिसी पाङ्बा मुला, ");
INSERT INTO taj_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“प्रभुसे थेनीगदेला मी बन्‍द लसी पिन्‍बा मुला ओच्‍छे थेनीगदेला सेम कोङ्‌ना लबा मुला। आहिन्‍सम थेनीगदेसे म्राङ्सेला मुबा, सेमहेन्‍सेन घोसेला मुबा, ङापट्टि दोःसेला मुबा, ओच्‍छे थेनीगदेदा ङाइ खम्‍ना लसेला मुबा।” ");
INSERT INTO taj_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","यशैया अगमवक्तासे येशूला घ्रेन शक्ति म्राङ्सी येशूला बारेरीन चु ताम पाङ्बा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","तसैनोन ल्‍हानान यहूदी नेतागदेसे येशूदा विश्‍वास लजी। तर फरिसीगदेसे यहूदीगदे ह्रुप तबा दिमरी वाङ्बारी आपिन भिसी लोङ्सी थेनीगदेसे चु ताम खालैदान आपाङ्नी। ");
INSERT INTO taj_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","तिग्‍दा भिसम थेनीगदेसे परमेश्‍वरसे भन्‍दा म्‍हिगदेसे ज्‍यबा भिगै भिसी म्‍हन्‍मुबा। ");
INSERT INTO taj_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","येशूसे घ्रेन काइरी चुह्रङ् भिसी सुङ्जी, “ङादा विश्‍वास लबा म्‍हिगदेसे ङादा जे आहिन, तर ङादा पुइखबादाएनोन विश्‍वास लला। ");
INSERT INTO taj_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ओच्‍छे ङादा म्राङ्बा म्‍हिसे ङादा पुइखबादाएनोन म्राङ्ला। ");
INSERT INTO taj_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ङादा विश्‍वास लबा म्‍हिगदे धोपधोपरी भ्रआतोःगै भिसीन ङा जम्‍बुलिङरी य्‍हाल दोसी खबा मुला। ");
INSERT INTO taj_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“ङाला ताम थेःसीनोन ङाइ पाङ्बा अन्‍छार आभ्रबा म्‍हिगदेला निसाफ आल। तिग्‍दा भिसम ङा जम्‍बुलिङला म्‍हिगदेला निसाफ लबारी खबा आहिन। तर जम्‍बुलिङला म्‍हिगदेदा थार्ना लबारी खबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","तर ङादेन ङाला तामदा विश्‍वास आलबा म्‍हिगदेला निसाफ लबारी न्‍यायाधीश गिक मुला। थे न्‍यायाधीश चा ङाइ पाङ्बा तामनोन हिन्‍ना। थेसेन चु जम्‍बुलिङ नाश तबा धुइरी थेनीगदेला निसाफ लला। ");
INSERT INTO taj_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","तिग्‍दा भिसम चु ताम ङाइ ङाला सेमग्‍याम पाङ्बा आहिन, तर ङादा पुइखबा आबासे कुल्‍बा अन्‍छारनोन ङाइ पाङ्बा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ङादा पुइखबा आबासे कुल्‍बा ताम ङ्‌यान्‍बा म्‍हिदा जुकजुकधोनाला जुनी पिन्‍ना भिबा ताम ङादा था मुला। थेतबासेलमा आबासे जुन ताम पाङ्पुङ्ला थे ताम जे ङाइ पाङ्बा मुला।” ");
INSERT INTO taj_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाड खबा भन्‍दा ङाच्‍छान चु जम्‍बुलिङ ख्‍लासी आबा मुबा ग्‍लारी निबा धुइ तसी जिन्‍जी भिबा ताम येशूसे था याङ्सी जिन्‍बा मुबा। येशूसे जम्‍बुलिङरी मुबा ह्राङला चेलागदेदा ल्‍हानान माया लमुबा, ओच्‍छे थेनीगदेदा लिच्‍छाधोनान माया लजी। ");
INSERT INTO taj_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","येशू ह्राङला चेलागदेदेन छ्‌याम ङ्‍यसेला सोल छ्‌योइबान मुबा। थेनोन धुइरी येशूदा चुङ्सी पिन्‍बा सेम शैतानसे सिमोनना झा यहूदा इस्‍करियोतदा खना लसी जिन्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","परमेश्‍वरसे जम्‍मान अधिकार ह्राङदा पिन्‍बा मुला भिबा ताम येशूदा था मुबा। ओच्‍छे परमेश्‍वरग्‍यामनोन खसी दोःसी परमेश्‍वर मुबा ग्‍लारी निबान मुला भिबा तामएनोन येशूदा था मुबा ");
INSERT INTO taj_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","सोल छ्‍योइमाहेन्‍से येशू स्‍हेङ्‍जी, ओच्‍छे ह्राङसे नान्‍बा घ क्‍यार थान्‍सी क्रेप्‍सरी गम्‍सा खीजी। ");
INSERT INTO taj_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","जमाहेन्‍से येशूसे ताङ गिकरी क्‍युइ युजी, ओच्‍छे ह्राङला चेलागदेला काङ ख्रुसी ह्राङसे खीबा गम्‍सासे थेनीगदेला काङ फ्‍याजी। ");
INSERT INTO taj_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","येशूसे सिमोन पत्रुसला काङ ख्रुबारी छ्‌याइमा सिमोन पत्रुससे “प्रभु तिग ह्राङसे ङाला काङ ख्रुबारी छ्‌याइबा?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","येशूसे थेदा “ङाइ तिग लबान मुला, थे ताम एसे दान्‍दे आघो। तर चु ताम एसे लिच्‍छा घोला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","पत्रुससे येशूदा “ह्राङसे ङाला काङ खाइमै ख्रुबारी आत” भिसी भिमा, येशूसे थेदा “ङाइ एला काङ आख्रुनी भिसम ए ङाला म्‍हि आदो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","जमाहेन्‍से सिमोन पत्रुससे येशूदा “थेह्रङ् भिसम प्रभु, ङाला काङ जे आहिन, तर ङाला यादेन थोबोएनोन ख्रुसी पिन्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","जमाहेन्‍से येशूसे थेदा “नुहाब लसी जिन्‍बा म्‍हिसे काङ जे ख्रुतोःला। एनीगदे न्‍हङ‍री म्‍हि गिक बाहेक स्‍य्‍हान्‍दो जम्‍मान चोखो तसी जिन्‍बा मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","तिग्‍दा भिसम ह्राङदा खाल्‍से चुङ्सी पिन्‍बारी छ्‌याइबा मुला भिबा ताम येशूदा था मुबा। थेतबासेलमान येशूसे “एनीगदे न्‍हङला गिक चा चोखो तबा आरे” भिसी सुङ्बा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","थेनीगदेला काङ ख्रुसी जिन्‍माहेन्‍से ह्राङला घ नान्‍सी येशू दोःसी धन्‍छ्‌याजी। जमाहेन्‍से येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “ङाइ तिग्‍दा एनीगदेला काङ ख्रुजी भिबा ताम एनीगदेसे घोजी? ");
INSERT INTO taj_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","एनीगदेसे ङादा ‘गुरुदेन प्रभु’ भिसी पाङ्बा ताम सत्‍य हिन्‍ना, तिग्‍दा भिसम ङा एनीगदेला गुरुदेन प्रभुन हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","चुदे ङा प्रभुदेन गुरु तसीनोन ङाइ एनीगदेला काङ ख्रुजी भिसम एनीगदेसेनोन गिकसेम गिकला काङ ख्रुतोःला। ");
INSERT INTO taj_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ङाइ लबा ह्रङ्नोन एनीगदेसेनोन लगै भिसीन ङाइ चुह्रङ् लसी उन्‍बा हिन्‍ना। एनीगदेसेनोन चुह्रङ्‌नोन लउ। ");
INSERT INTO taj_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","थेतबासेलमा च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, मालिक भन्‍दा नोकर घ्रेन आत ओच्‍छे समाचार पुइबा म्‍हि भन्‍दा समाचार भोर्बा म्‍हिएनोन खाइमै घ्रेन आत। ");
INSERT INTO taj_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","चुदे एनीगदेसे चु ताम घोसी चुनोन अन्‍छार लजी भिसम एनीगदेसे परमेश्‍वरग्‍याम मोलम याङ्ला। ");
INSERT INTO taj_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“चु ताम ङाइ एनीगदे जम्‍मालान बारेरी पाङ्बा आहिन, ङाइ धम्‍बागदेदा ङाइ ज्‍यना लसी ङोसेमुला। तर ‘ङादेन छ्‌यामनोन गेङ चबा म्‍हिसे ङादा धोका पिन्‍ना’ भिसी परमेश्‍वरला बचनरी पाङ्बा ताम पूरा तबाला लागिरीन चुह्रङ् तबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","चु ताम तमाहेन्‍सेनोन एनीगदेसे ङादा “ङा थेनोन हिन्‍ना” भिसी विश्‍वास लबारी खम्‍गै भिसीन ङाइ चु ताम एनीगदेदा ङाच्‍छान पाङ्बा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","थेतबासेलमा च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, ङाइ पुइबा म्‍हिगदेदा मान लबा म्‍हिसे ङादाएनोन मान लला, ओच्‍छे ङादा मान लबा म्‍हिसे ङादा पुइखबादाएनोन मान लला।” ");
INSERT INTO taj_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","चु ताम सुङ्सी जिन्‍माहेन्‍से ल्‍हानान दुख ङ्‍हम्‍सी येशूसे चेलागदेदा “च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, एनीगदे न्‍हङलान गिकसे ङादा म्‍हिगदेला यारी जिम्‍मा पिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","येशूसे चु ताम खाल्‍ला बारेरी सुङ्बा हिन्‍ना भिबा आघोबासे लमा चेलागदेसे ह्राङ ह्राङ न्‍हङ‍री गिकसेम गिकला लीरी च्‍याबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","येशूसे ल्‍हानान माया लबा चेला चा येशूला ङामरीन चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","जमाहेन्‍से सिमोन पत्रुससे थेदा “येशूसे चु ताम खाल्‍ला बारेरी सुङ्बा हिन्‍ना? ङ्‌योइगो” भिसी मीला चाल लजी। ");
INSERT INTO taj_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","थे येशूला ङामरी चिबान येशूदा “प्रभु, थे म्‍हि खाल हिन्‍ना?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","येशूसे थेदा “ङाइ जुन म्‍हिदा गेङ तुइसी पिन्‍ना, थे म्‍हि थेनोन हिन्‍ना” भिसी सुङ्जी। ओच्‍छे येशूसे टोगल गिक गेङ तुइसी सिमोन इस्‍करियोतला झा यहूदा इस्‍करियोतदा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","थे गेङ किन्‍माहेन्‍से यहूदा इस्‍करियोत न्‍हङ‍री शैतान वाङ्‌जी। जमाहेन्‍से येशूसे थेदा “एसे तिग लबारी छ्‌याइबा मुला, थे योनान लउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","तर येशूसे थेदा तिग्‍दा थेह्रङ् भिसी सुङ्बा हिन्‍ना भिसी थेरी चबारी चिबागदे खालैसेन आघोनी। ");
INSERT INTO taj_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","थेनीगदेला टाङगा यहूदा इस्‍करियोतसे थान्‍बासे लमा कोइ कोइसे चा येशूसे थेदा चाडला लागिरी तोःबा स्‍हेगदे ग्‍लुउ भिसी सुङ्‍जीनम भिसी म्‍हन्‍जी। ओच्‍छे कोइ कोइसे चा येशूसे थेदा प्राङबोगदेदा तिगै पिन्‍गो भिसी सुङ्‍जीनम भिसी म्‍हन्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","येशूसे पिन्‍बा गेङ चमाहेन्‍से यहूदा इस्‍करियोत तुरुन्‍तन मङग्‍यार निजी। थे धुइरी धोप तसी जिन्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","यहूदा इस्‍करियोत मङग्‍यार निमाहेन्‍से येशूसे चुह्रङ् भिसी सुङ्जी, “दाहेन्‍से परमेश्‍वरसे पुइखबा म्‍हिसे घ्रेन मान याङ्बा मुला, ओच्‍छे थेग्‍याम परमेश्‍वरसेनोन घ्रेन मान याङ्बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","चुदे परमेश्‍वरसे पुइखबा म्‍हिग्‍याम परमेश्‍वरसे घ्रेन मान याङ्जी भिसम परमेश्‍वरसेनोन ह्राङसे पुइखबादा घ्रेन मान पिन्‍ना। ओच्‍छे परमेश्‍वरसे चु गे योनान लला। ");
INSERT INTO taj_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“कोलागदे, ङा एनीगदेदेन छ्‌याम छिन्‍नङ जे तला। एनीगदेसे ङादा म्‍हाइला, तर दाहेन्‍से ङाइ यहूदीगदेदा पाङ्बा ताम एनीगदेदाएनोन पाङ्ला, ‘ङा जुन ग्‍लारी निबान मुला, थेरी एनीगदे खबारी आखम।’ ");
INSERT INTO taj_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“दाहेन्‍से ङाइ एनीगदेदा छार ताम गिक कुल्‍ला, एनीगदेसे गिकसेम गिकदा माया लउ। ङाइ एनीगदेदा माया लबा ह्रङ् लसी एनीगदेसेनोन गिकसेम गिकदा माया लउ। ");
INSERT INTO taj_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","चुदे एनीगदेसे गिकसेम गिकदा माया लजी भिसम एनीगदे ङाला चेला हिन्‍बा चीम भिसी जम्‍मासेन ङोसेला।” ");
INSERT INTO taj_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","सिमोन पत्रुससे येशूदा “प्रभु, ह्राङ खानङ फेप्‍बारी छ्‌याइबा?” भिसी ङ्‌योइमा, येशूसे थेदा “ङा निबा ग्‍लारी ए दान्‍दे ङादेन छ्‌याम भ्रबारी आखम, तर लिच्‍छा चा भ्रला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","पत्रुससे येशूदा “प्रभु, तिग्‍दा ङा दान्‍देन ह्राङदेन छ्‌याम भ्रबारी आखम? ह्राङला लागिरी ङा सिबारीनोन तयार मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","जमाहेन्‍से येशूसे थेदा “तिग एसे ङाला लागिरी ह्राङला ज्‍याननोन पिन्‍खम्‍ला? च्‍यागो, एसे ङाला ताम ङ्‌यान्‍गो, नागा क्राबा भन्‍दा ङाच्‍छान एसे ङादा ङोसेबान आरे भिसी सोमरेमधोना पाङ्ला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","येशूसे ह्राङला चेलागदेदा चुह्रङ् भिसी सुङ्जी, “एनीगदेसे दुख थाम्‍हन्‍गो। एनीगदेसे परमेश्‍वरदा विश्‍वास लबा मुला, ओच्‍छे ङादाएनोन विश्‍वास लउ। ");
INSERT INTO taj_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ङाला आबाला दिमरी चिबा ग्‍ला ल्‍हानान मुला, ओच्‍छे ङा एनीगदेला लागिरी ग्‍ला स्‍होबारी निबान मुला। चुदे ग्‍ला आरेबा हिन्‍सम ङाइ एनीगदेदा चु ताम पाङ्‌नोन आपाङ्सेला मुबा। ");
INSERT INTO taj_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","एनीगदेला लागिरी ग्‍ला स्‍होसी जिन्‍माहेन्‍से ङा दोःसी खला, ओच्‍छे एनीगदे ङादेन छ्‌यामनोन चिबाला लागिरी एनीगदेदाएनोन ङा मुबा ग्‍लारीन भोर्ला। ");
INSERT INTO taj_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ङा निबारी छ्‌याइबा ग्‍याम एनीगदेदा थानोन मुला।” ");
INSERT INTO taj_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","थोमासे येशूदा “प्रभु, ह्राङ खानङ फेप्‍बान मुला भिबा ताम मी ङन्‍दा था आरे भिसम ह्राङ फेप्‍बा ग्‍याम मी झन ङन्‍से खाह्रङ् लसी था याङ्से?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","येशूसे चुह्रङ् भिसी सुङ्जी, “परमेश्‍वर मुबा ग्‍लारी भोर्बा ग्‍याम, सत्‍य ओच्‍छे जुनी ङानोन हिन्‍ना। ङाग्‍याम बाहेक खालैनोन परमेश्‍वर आबा मुबा ग्‍लारी निबारी आखम। ");
INSERT INTO taj_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","एनीगदेसे ङादा ङोसेबा हिन्‍सम ङाला आबादाएनोन ङोसेसेला मुबा। तर दाहेन्‍से एनीगदेसे ङाला आबादा ङोसेला, ओच्‍छे एनीगदेसे थेदा म्राङ्सी जिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","फिलिपसे येशूदा “प्रभु, ङन्‍दा परमेश्‍वर आबा उन्‍सी पिन्‍गो, चुदे लजी भिसम तला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","येशूसे थेदा चुह्रङ् भिसी सुङ्जी, “फिलिप, चुदे धिनधोना ङा एनीगदेदेन छ्‌याम चिजी, तसैनोन एसे ङादा ङोसेबा आरे? ङादा म्राङ्बा म्‍हिसे परमेश्‍वर आबादाएनोन म्राङ्सी जिन्‍बा मुला। तर ङादा म्राङ्सीनोन तिग्‍दा एसे ङन्‍दा परमेश्‍वर आबादा उन्‍सी पिन्‍गो भिसी भिबा? ");
INSERT INTO taj_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ङा आबादेन छ्‌याम गिक तबा मुला ओच्‍छे आबा ङादेन छ्‌याम गिक तबा मुला भिबा ताम एदा विश्‍वास आरे? जुन ताम ङाइ एनीगदेदा पाङ्बा मुला थे ताम ङाइ ङाला सेमग्‍याम पाङ्बा आहिन। तर ङादेन छ्‌याम गिक तबा आबासे ह्राङला गे ङाग्‍याम लबान मुला। ");
INSERT INTO taj_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ङा आबादेन छ्‌याम गिक तबा मुला ओच्‍छे आबा ङादेन छ्‌याम गिक तबा मुला भिबा ताम विश्‍वास लउ। आहिन्‍सम ङाइ लबा गेगदे च्‍यासीन विश्‍वास लउ। ");
INSERT INTO taj_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, ङादा विश्‍वास लबागदेसे ङाइ लबा ह्रङ्‌बान गे लबारी खम्‍ला, ओच्‍छे थे भन्‍दा घ्रेन घ्रेन गेगदेएनोन लबारी खम्‍ला। तिग्‍दा भिसम ङा परमेश्‍वर आबा मुबा ग्‍लारी निबान मुला। ");
INSERT INTO taj_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","एनीगदेसे ङादेन छ्‌याम जुन स्‍हे ह्रीसैनोन ङाग्‍याम परमेश्‍वर आबाला मान तगै भिसी ङाइ एनीगदेदा पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","एनीगदेसे ङाला मिनरी जुन स्‍हे ह्रीसै ङाइ एनीगदेदा पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“चुदे एनीगदेसे ङादा माया लबा मुसम ङाइ कुल्‍बा ताम एनीगदेसे ङ्‌यान्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ओच्‍छे ङाइ परमेश्‍वर आबादेन छ्‌याम बिन्‍ती लला, ङाला साटोरी परमेश्‍वर आबासे एनीगदेदा ह्रो लबा आत्‍मा पुइखला। थे सदन एनीगदेदेन छ्‌याम धन्‍छ्‌याला। ");
INSERT INTO taj_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","थे आत्‍मासे एनीगदेदा परमेश्‍वरला बारेरी सत्‍य ताम घोना लला। तर थेदा जम्‍बुलिङला म्‍हिगदेसे विश्‍वास आल, तिग्‍दा भिसम जम्‍बुलिङला म्‍हिगदेसे थेदा न्‍ह म्राङ्ला न्‍ह ङोसेला। तर एनीगदेसे मी थेदा ङोसेला, तिग्‍दा भिसम थे एनीगदेदेन छ्‌यामनोन मुला ओच्‍छे थे एनीगदे न्‍हङ‍री धन्‍छ्‌याला। ");
INSERT INTO taj_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“ङाइ एनीगदेदा टुहुरा स्‍होसी आथान, ङा दोःसी एनीगदे मुबा ग्‍लारी खला। ");
INSERT INTO taj_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","छिन्‍नङ लिच्‍छा जम्‍बुलिङला म्‍हिगदेसे ङादा खाइमै आम्राङ्, तर एनीगदेसे मी ङादा म्राङ्ला। तिग्‍दा भिसम ङा सोबासे लमा एनीगदेएनोन सोला। ");
INSERT INTO taj_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","थे धिन खमाहेन्‍से खाह्रङ् लसी एनीगदे ङादेन छ्‌याम गिक तसी चिबा मुला, ङाएनोन एनीगदेदेन छ्‌याम गिक तसी चिबा मुला, ओच्‍छे ङा परमेश्‍वर आबादेन छ्‌याम गिक तसी चिबा मुला भिबा ताम एनीगदेसे था याङ्ला। ");
INSERT INTO taj_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","जुन म्‍हिसे ङाइ कुल्‍बा ताम सेमरी थान्‍सी थे अन्‍छार भ्रला थेसे ङादा माया लला। ङादा माया लबा म्‍हिदा परमेश्‍वर आबासेनोन माया लला, ङाइएनोन थेदा माया लला ओच्‍छे ङा ह्राङनोन थे मुबा ग्‍लारी खला।” ");
INSERT INTO taj_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","यहूदा इस्‍करियोत चा आहिन, तर स्‍य्‍हान्‍दो यहूदासे येशूदा “प्रभु, ह्राङ तिग्‍दा ङनी मुबा ग्‍लारी चा फेप्‍खला, तर जम्‍बुलिङला स्‍य्‍हान्‍दो म्‍हिगदे मुबा ग्‍लारी चा आफेप्‍ख भिसी सुङ्बा?” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","येशूसे थेदा चुह्रङ् भिसी सुङ्जी, “चुदे खालैसे ङादा माया लमुला भिसम थेसे ङाइ कुल्‍बा तामएनोन ङ्‍यान्‍मुला। ओच्‍छे थेदा ङाला आबासेनोन माया लला, थेह्रङ् लसीन ङादेन ङाला आबा थे मुबा ग्‍लारी खसी थेदेन छ्‌यामनोन चिला। ");
INSERT INTO taj_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","तर ङादा माया आलबा म्‍हिगदेसे ङाइ कुल्‍बा तामएनोन आङ्‌यान्‍मुला। चु ताम ङाइ एनीगदेदा ङाला सेमग्‍याम पाङ्बा आहिन, तर ङादा पुइखबा परमेश्‍वर आबासेन सुङ्बा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“ङा एनीगदेदेन छ्‌याम मुबा धुइरीन चु ताम ङाइ एनीगदेदा पाङ्बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ङाला साटोरी आबासे एनीगदेदा ह्रो लबारी पुइखबा थेला आत्‍मासे एनीगदेदा जम्‍मान ताम लोप्‍ला ओच्‍छे ङाइ पाङ्बा जम्‍मान तामएनोन एनीगदेदा ढन्‍ना लला। ");
INSERT INTO taj_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“ङा एनीगदेदा शान्‍ति पिन्‍सी निबान मुला। एनीगदेदा पिन्‍बा शान्‍ति चा ङाला ह्राङलान शान्‍ति हिन्‍ना। चु शान्‍ति चा जम्‍बुलिङला म्‍हिगदेसे पाङ्बा ह्रङ्‌बा शान्‍ति आहिन। थेतबासेलमा दुख थाम्‍हन्‍गो ओच्‍छे थालोङ्‍गो। ");
INSERT INTO taj_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“‘ङा चुग्‍याम निबान मुला, तसैनोन ङा एनीगदे मुबा ग्‍लारी दोःसी खला’ भिसी ङाइ पाङ्बा ताम एनीगदेसे थेःबा मुला। एनीगदेसे ङादा पक्‍कान माया लबा हिन्‍सम ङा परमेश्‍वर आबा मुबा ग्‍लारी निबारी छ्‌याइबा मुला भिबा ताम थेःसी एनीगदे ताङ्सेला मुबा। तिग्‍दा भिसम ङा भन्‍दा मी परमेश्‍वर आबान घ्रेन हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","चु ताम पूरा तमाहेन्‍से एनीगदेसे ङादा विश्‍वास लगै भिसी चु ताम पूरा तबा भन्‍दा ङाच्‍छान ङाइ एनीगदेदा पाङ्सी जिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","दाहेन्‍से ङाइ एनीगदेदा चु भन्‍दा ल्‍हाना ताम आपाङ्। तिग्‍दा भिसम चु जम्‍बुलिङदा तहरी थान्‍बा चा खबान मुला। तसैनोन थेदेन छ्‌याम ङादा तिगै लबा शक्ति आरे। ");
INSERT INTO taj_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","तर ङाइ परमेश्‍वर आबादा माया लमुला भिबा ताम जम्‍बुलिङला म्‍हिगदेसे था याङ्‌गै भिसीन परमेश्‍वर आबासे कुल्‍बा अन्‍छारनोन ङाइ लबान मुला। दाहेन्‍से भ्रउ, य्‍हाङ चुग्‍याम निइ। ");
INSERT INTO taj_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“साँच्‍चिलान अङगुर दोङ चा ङानोन हिन्‍ना, ओच्‍छे ङाला आबा चा दोङदा सयार लबा म्‍हि हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","थेसे ङादेन छ्‌याम मुबा तिगै आरोबा हाँगा चा थासी भ्‍याङ्‍ला। तर रोबा हाँगागदेदा चा अझ ल्‍हाना रोगै भिसी जोगदे घ्‍याम्‍सी ज्‍यना लसी सयार लला। ");
INSERT INTO taj_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","थेह्रङ् लसीन एनीगदेला विश्‍वास अझ ल्‍हेगै भिसी ङाइ पाङ्बा चु बचनगदेसेन एनीगदेला सेम ज्‍यना लसी जिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","एनीगदे ङादेन छ्‌याम गिक तसी चिउ, ङाएनोन एनीगदेदेन छ्‌याम गिक तसी चिला। हाँगा दोङग्‍याम फेजी भिसम थे हाँगारी तिगै आरो। थेह्रङ् लसीन एनीगदेएनोन ङाग्‍याम फेसी चिजी भिसम एनीगदेसेनोन तिगै लबारी आखम। ");
INSERT INTO taj_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“अङगुरला दोङ ङानोन हिन्‍ना, एनीगदे चा हाँगागदे हिन्‍ना। चुदे खालै म्‍हि ङादेन छ्‌याम गिक तसी चिजी भिसम ङाएनोन थेदेन छ्‌याम गिक तसी चिला, ओच्‍छे थे विश्‍वासरी ल्‍हेसी ल्‍हानान ज्‍यबा गेगदे लला। तर ङाग्‍याम फेसी चिजी भिसम एनीगदेसे तिगै लबारी आखम। ");
INSERT INTO taj_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ङादेन छ्‌याम गिक तसी आचिबागदेदा चा थे हाँगागदेदा भ्‍याङ्‍बा ह्रङ् लसी भ्‍याङ्‍ला, ओच्‍छे थे खर्ला। थेह्रङ्बा हाँगागदेदा म्‍हिगदेसे ह्रुप लसी मेरी भ्‍याङ्‍ला, जमाहेन्‍से थे मेफ्रा दोला। ");
INSERT INTO taj_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","चुदे एनीगदे ङादेन छ्‌याम गिक तजी भिसम ओच्‍छे ङाला बचन एनीगदेला सेम न्‍हङ‍री थान्‍जी भिसम एनीगदेदा तोःबा स्‍हे ह्रीमा पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","चुदे एनीगदेसे ल्‍हानान ज्‍यबा गेगदे लसी ङाला चेला दोसी उन्‍जी भिसम ङाला आबाला मानदेन जयजयकार तला। ");
INSERT INTO taj_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“ङादा आबासे माया लबा ह्रङ् लसी ङाइएनोन एनीगदेदा ङाच्‍छाहेन्‍सेन माया लबा मुला। थेतबासेलमा एनीगदेसे ङाला माया थाम्‍लेःगो। ");
INSERT INTO taj_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ङाला आबासे कुल्‍बा ताम ङ्‍यान्‍बासे लमा आबाला माया सदन ङादेन छ्‌याम मुला। थेह्रङ् लसीन एनीगदेसेनोन ङाइ कुल्‍बा ताम ङ्‌यान्‍जी भिसम ङाला माया सदन एनीगदेदेन छ्‌याम तला। ");
INSERT INTO taj_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ङाला सेम ताङ्‍बा ह्रङ् लसी एनीगदेला सेमएनोन पूरान ताङ्‍खम्‍गै भिसीन ङाइ एनीगदेदा चु ताम पाङ्बा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“ङाइ एनीगदेदा माया लबा ह्रङ् लसी एनीगदेसेनोन ह्राङ ह्राङ न्‍हङ‍री गिकसेम गिकदा माया लउ भिसी ङाइ चु ताम कुल्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ह्रोला लागिरी ह्राङला ज्‍याननोन पिन्‍बा भन्‍दा घ्रेन माया अर्गु तिगैनोन आरे। ");
INSERT INTO taj_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","चुदे एनीगदेसे ङाइ कुल्‍बा ताम ङ्‌यान्‍जी भिसम एनीगदे ङाला ह्रो हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","दाहेन्‍से ङाइ एनीगदेदा नोकर भिसी आपाङ्, तिग्‍दा भिसम मालिकसे तिग लबान मुला भिसी नोकरदा था आत। तर ङाइ एनीगदेदा ह्रो भिसी पाङ्बा मुला, तिग्‍दा भिसम ङाला आबासे ङादा सुङ्बा जम्‍मान ताम ङाइ एनीगदेदा पाङ्सी जिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","एनीगदेसे ङादा धम्‍बा आहिन, तर एनीगदे सदन ज्‍यबा म्‍हि दोसी ज्‍यबा गे लगै भिसीन ङाइ एनीगदेदा धम्‍बा हिन्‍ना। थेह्रङ् लसी एनीगदेसे ङाला मिन किन्‍सी परमेश्‍वर आबादेन छ्‌याम ह्रीजी भिसम एनीगदेसे ह्रीबा स्‍हे परमेश्‍वर आबासे पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","थेतबासेलमा ङाइ कुल्‍बा अन्‍छार एनीगदेसे गिकसेम गिकदा माया लउ। ");
INSERT INTO taj_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“चुदे एनीगदेदा जम्‍बुलिङला म्‍हिगदेसे हेला लजी भिसम एनीगदेदा भन्‍दा ङाच्‍छा ङादा हेला लबा हिन्‍ना भिसी घोउ। ");
INSERT INTO taj_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","चुदे एनीगदे जम्‍बुलिङला म्‍हि हिन्‍बा हिन्‍सम थेनीगदेसे एनीगदेदा ह्राङला म्‍हि म्‍हन्‍सी माया लसेला मुबा। तर एनीगदे चु जम्‍बुलिङला म्‍हि आहिन। एनीगदेदा ङाइ चु जम्‍बुलिङग्‍याम धम्‍बा हिन्‍ना। थेतबासेलमा एनीगदेदा जम्‍बुलिङला म्‍हिगदेसे हेला लबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‘नोकर मालिक भन्‍दा घ्रेन आत’ भिसी ङाइ पाङ्बा ताम एनीगदेसे थाम्‍लेःगो। थेनीगदेसे ङादा दुख पिन्‍जी भिसम एनीगदेदाएनोन दुख पिन्‍ना। थेह्रङ् लसीन थेनीगदेसे ङाइ कुल्‍बा ताम ङ्‌यान्‍जी भिसम एनीगदेसे पाङ्बा तामएनोन ङ्‌यान्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","एनीगदे ङाला म्‍हि तबासे लमा थेनीगदेसे एनीगदेदा ल्‍हानान दुख पिन्‍ना। तिग्‍दा भिसम थेनीगदेसे ङादा पुइखबा परमेश्‍वर आबादा ङोसेबा आरे। ");
INSERT INTO taj_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","चुदे ङा आखबादेन ङाइ थेनीगदेदा आपाङ्बा हिन्‍सम थेनीगदेदा पापला दोष आतसेला मुबा। तर दाहेन्‍से थेनीगदेसे ह्राङला पापला लागिरी तिगै निउ लबा ग्‍ला आरे। ");
INSERT INTO taj_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ङादा हेला लबा म्‍हिसे ङाला आबादाएनोन हेला लला। ");
INSERT INTO taj_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","खालैसेन लबारी आखम्‍बा गेगदे ङाइ थेनीगदेला गुङरी आलबा हिन्‍सम थेनीगदेदा पापला दोष आतसेला मुबा। तर ङाइ लबा उदेकला गेगदे म्राङ्सीनोन थेनीगदेसे ङादेन ङाला आबादा हेला लबा मुला। ");
INSERT INTO taj_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","तर थेनीगदेला ह्राङलान ठिमरी ‘थेनीगदेसे ङादा थेह्रङ्नोन हेला लला’ भिसी भ्रिबा ताम पूरा तबाला लागिरीन चुह्रङ् तबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“ङाइ आबाग्‍याम सत्‍यला आत्‍मा एनीगदेदा ह्रो लबाला लागिरी पुइखला। थे खसी थेसेन ङाला बारेरी पाङ्ला। ");
INSERT INTO taj_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ओच्‍छे एनीगदे चा ङाच्‍छाहेन्‍सेन ङादेन छ्‌याम चिबासे लमा एनीगदेसेनोन ङाला बारेरी पाङ्ला। ");
INSERT INTO taj_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“एनीगदेला विश्‍वास म्‍हासी थानिगै भिसी ङाइ एनीगदेदा जम्‍मान ताम पाङ्बा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","एनीगदेदा थेनीगदेसे यहूदीगदे ह्रुप तबा दिमग्‍याम तेःला। ओच्‍छे एनीगदेदा साइबा म्‍हिगदेसे ‘ङन्‍से परमेश्‍वरदा तेन्‍बा मुला’ भिसी म्‍हन्‍बा धुइएनोन खबान मुला। ");
INSERT INTO taj_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","थेनीगदेसे एनीगदेदा थेह्रङ् लला, तिग्‍दा भिसम थेनीगदेसे परमेश्‍वर आबादा ङोसेबा आरे ओच्‍छे ङादाएनोन ङोसेबा आरे। ");
INSERT INTO taj_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","च्‍यागो, थे जम्‍मान ताम तबा धुइरी एनीगदेसे ‘चु जम्‍मान तामला बारेरी ङादा प्रभुसे ङाच्‍छान सुङ्सी जिन्‍बा मुबा’ भिबा ताम ढन्‍गै भिसी ङाइ एनीगदेदा चु ताम पाङ्‌बान मुला। दान्‍देधोना ङा एनीगदेदेन छ्‌यामनोन मुबासे लमा चु ताम ङाइ ङाच्‍छा एनीगदेदा आपाङ्नी। ");
INSERT INTO taj_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","दाहेन्‍से ङा ङादा पुइखबा परमेश्‍वर आबा मुबा ग्‍लारी निबान मुला। तर एनीगदे खालैसेन ङादा ‘ह्राङ खानङ फेप्‍बा?’ भिसी आङ्‍योइ। ");
INSERT INTO taj_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","तसैनोन ङाइ चु जम्‍मान ताम पाङ्बासे लमा एनीगदेदा सेमरी ल्‍हानान सुर्दा तबा मुला। ");
INSERT INTO taj_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","तसैनोन ङाइ एनीगदेदा सत्‍य ताम पाङ्बा मुला, ङा चुग्‍याम निबान एनीगदेदा ज्‍यबा हिन्‍ना। तिग्‍दा भिसम ङा चुग्‍याम आनिनी भिसम एनीगदेदा ह्रो लबा आत्‍मा एनीगदे मुबा ग्‍लारी आफेप्‍ख। तर ङा निजी भिसम ङाइ थेदा एनीगदे मुबा ग्‍लारी पुइखला। ");
INSERT INTO taj_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","थे फेप्‍खमाहेन्‍से थेसे जम्‍बुलिङला म्‍हिगदेदा परमेश्‍वरदा सेम निबा गेला बारेरीदेन परमेश्‍वरसे लबा निसाफला बारेरी, गल्‍ती गेला बारेरी ओच्‍छे पापला बारेरी उन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ङादा विश्‍वास आलबान पाप हिन्‍ना भिसी थेसे थेनीगदेदा घोना लला। ");
INSERT INTO taj_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","थेसे परमेश्‍वरदा सेम निबा गे तिग हिन्‍ना भिसी घोना लला। तिग्‍दा भिसम ङा परमेश्‍वर आबा मुबा ग्‍लारी निबान मुला, ओच्‍छे एनीगदेसे ङादा दोःसी आम्राङ्। ");
INSERT INTO taj_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","थेसे परमेश्‍वरसे लबा निसाफ भिबा तिग हिन्‍ना भिसीएनोन थेनीगदेदा घोना लला। तिग्‍दा भिसम चु जम्‍बुलिङदा तहरी थान्‍बादा परमेश्‍वरसे निसाफ लसी जिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“ङाइ एनीगदेदा पाङ्तोःबा ताम मी ल्‍हानान मुबा। तर एनीगदेसे दान्‍दे चु भन्‍दा ल्‍हाना घोबारी आखम। ");
INSERT INTO taj_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","तर थे सत्‍यला आत्‍मा फेप्‍खमाहेन्‍से सत्‍य ताम तिग हिन्‍ना भिसी थेसेन एनीगदेदा घोना लला। थेसे ह्राङला सेमग्‍याम एनीगदेदा तिगै ताम आसुङ्, थेसे जुन ताम थेःला थेनोन ताम जे एनीगदेदा सुङ्ला। ओच्‍छे थेसेन लिच्‍छा तसेला तामगदेएनोन एनीगदेदा घोना लला। ");
INSERT INTO taj_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","थेसे ङाला मानदेन जयजयकार लला, तिग्‍दा भिसम थेसे ङाइ पाङ्बा ताम थेःसी एनीगदेदा पाङ्ला। ");
INSERT INTO taj_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","परमेश्‍वर आबादेन छ्‌याम मुबा जम्‍मान स्‍हे जम्‍मान ङालान हिन्‍ना। थेतबासेलमा ङाइ पाङ्बा जम्‍मान ताम ‘सत्‍यला आत्‍मासे थेःसी एनीगदेदा घोना लला’ भिसी पाङ्बा हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","येशूसे ह्राङला चेलागदेदा “छिन्‍नङ लिच्‍छा एनीगदेसे ङादा आम्राङ्, तर दोःसी तिगै धिन लिच्‍छा मी एनीगदेसे ङादा म्राङ्ला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","चु ताम थेःसी येशूला कोइ कोइ चेलागदेसे “थेसे य्‍हाङदा ‘छिन्‍नङ लिच्‍छा एनीगदेसे ङादा आम्राङ् दोःसी छिन्‍नङ लिच्‍छा मी एनीगदेसे ङादा म्राङ्ला’ भिबादेन ‘तिग्‍दा भिसम ङा आबा मुबा ग्‍लारी निबान मुला’ भिसी सुङ्बाला अर्थ चा तिग हिन्‍ना?” भिसी ह्राङ ह्राङ न्‍हङ‍री ताम लजी। ");
INSERT INTO taj_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ओच्‍छे थेनीगदेसे दोःसी, “थेसे ‘छिन्‍नङ लिच्‍छा’ भिसी सुङ्बा तिग हिन्‍ना? थेसे सुङ्बा ताम य्‍हाङदा था आरे” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","थेनीगदेसे चु तामला बारेरी ङ्‌योइबा सेम लबा मुला भिसी था याङ्सी येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “ङाइ एनीगदेदा ‘छिन्‍नङ लिच्‍छा एनीगदेसे ङादा आम्राङ् भिबादेन छिन्‍नङ लिच्‍छा मी एनीगदेसे ङादा म्राङ्ला’ भिसी पाङ्बा तामला बारेरी एनीगदेसे ह्राङ ह्राङ न्‍हङ‍री ताम लबा आहिन? ");
INSERT INTO taj_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","थेतबासेलमा च्‍यागो, एनीगदेसे ङाला ताम ङ्‌यान्‍गो, एनीगदे क्राबा क्रिङ्बा लला, तर जम्‍बुलिङला म्‍हिगदे चा ताङ्ला। एनीगदेदा दुखदेन सुर्दा तला, तसैनोन एनीगदेला सुर्दा म्‍हासी दोःसी ताङ्म्‍याङ्ला। ");
INSERT INTO taj_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","कोला न्‍हबा धुइरी म्रिङम्‍हेमेदा ल्‍हानान दुख तमुला। तर कोला न्‍हमाहेन्‍से थेसे थे जम्‍मान दुख म्‍लेःमुला। तिग्‍दा भिसम जम्‍बुलिङरी कोला गिक न्‍हजी भिसी थे ल्‍हानान ताङ्मुला। ");
INSERT INTO taj_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","थेह्रङ् लसीन एनीगदेदा दान्‍दे दुख तबा मुला। तर ङा दोःसी एनीगदेदा ह्रुप तबारी खमा एनीगदे सेमरी ल्‍हानान ताङ्म्‍याङ्ला। ओच्‍छे एनीगदेला ताङ्‍बा खालैसेन म्‍हाना लबारी आखम। ");
INSERT INTO taj_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","थे धुइरी एनीगदेसे ङादेन छ्‌याम तिगै ताम आङ्‍योइ। च्‍यागो, ङाला मिनरी एनीगदेसे जुन स्‍हे ह्रीला थे स्‍हे एनीगदेदा परमेश्‍वर आबासे पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","दान्‍देधोना मी एनीगदेसे ङाला मिनरी तिगै ह्रीबा आरे। ह्री‍गो एनीगदेदा पिन्‍ना, ओच्‍छे एनीगदे पूरान ताङ्म्‍याङ्ला। ");
INSERT INTO taj_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“दान्‍दे चा ङाइ एनीगदेदा चु ताम उखानग्‍याम पाङ्बा मुला, तर धुइ तमाहेन्‍से परमेश्‍वरला बारेरी पाङ्‌मा चा उखान आपाङ्ना ङाइ एनीगदेदा प्रस्‍टन घोना लला। ");
INSERT INTO taj_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","थे धुइरी एनीगदे ह्राङसेन ङाला मिनरी ह्रीला। तर ङाइ एनीगदेला लागिरी परमेश्‍वर आबादेन छ्‌याम ह्रीसी पिन्‍आतोः। ");
INSERT INTO taj_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","तिग्‍दा भिसम परमेश्‍वर आबा ह्राङसेन एनीगदेदा माया लबा मुला। तिग्‍दा भिसम एनीगदेसे ङादा माया लबा मुला, ओच्‍छे ङा परमेश्‍वरग्‍याम खबा हिन्‍ना भिसीएनोन विश्‍वास लबा मुला। ");
INSERT INTO taj_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ङा परमेश्‍वर आबाग्‍यामसेन चु जम्‍बुलिङरी खबा हिन्‍ना, दान्‍दे दोःसी ङा चु जम्‍बुलिङदा ख्‍लासी परमेश्‍वर आबा मुबा ग्‍लारी निबान मुला।” ");
INSERT INTO taj_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","जमाहेन्‍से चेलागदेसे येशूदा चुह्रङ् भिसी भिजी, “दान्‍दे चा भिसम ह्राङसे ङन्‍दा उखान आसुङ्ना प्रस्‍टन घोना लजी। ");
INSERT INTO taj_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","दाहेन्‍से ह्राङदा जम्‍मान ताम था मुला भिबा ताम ङन्‍से था याङ्जी। दाहेन्‍से खालैसे ह्राङदा ङ्‍योइतोःबा ताम तिगै आरे। थेतबासेलमा ह्राङ परमेश्‍वरग्‍याम फेप्‍खबा हिन्‍ना भिसी ङन्‍से विश्‍वास लजी।” ");
INSERT INTO taj_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “तिग दान्‍दे मी एनीगदेसे ङादा विश्‍वास लबा मुला? ");
INSERT INTO taj_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","च्‍यागो, चुह्रङ्बा धुइएनोन खबान मुला, एनीगदे ससा बङबङ तसी ङा गिकदा जे ख्‍लासी ह्राङ ह्राङला दिमरी निला, पाङ्‌नोन तोःमा चु धुइ खसी जिन्‍बा मुला। तसैनोन थे धुइरी ङा गिक जे आत, तिग्‍दा भिसम ङाला आबा सदन ङादेन छ्‌याम मुला। ");
INSERT INTO taj_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","एनीगदे ङादेन छ्‌याम गिक तसी शान्‍ति याङ्सी चिबारी खम्‍गै भिसीन ङाइ एनीगदेदा चु जम्‍मान ताम पाङ्बा हिन्‍ना। जम्‍बुलिङरी एनीगदेदा ल्‍हानान दुख तला, तर एनीगदेसे आँट लउ, तिग्‍दा भिसम ङाइ जम्‍बुलिङला जम्‍मान नइबा तामदा ढासी जिन्‍बा मुला।” ");
INSERT INTO taj_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","चु जम्‍मान ताम सुङ्सी जिन्‍माहेन्‍से येशूसे स्‍वर्गपट्टि स्‍हीसी चुह्रङ् भिसी प्रार्थना लजी, “परमेश्‍वर आबा, दाहेन्‍से धुइ तसी जिन्‍बा मुला। ह्राङ गाते घ्रेन मुला भिसी उन्‍बाला लागिरी ह्राङसे ह्राङला झा गाते घ्रेन मुला भिसी उन्‍गो। ");
INSERT INTO taj_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ह्राङसे थेदा पिन्‍बा जम्‍मान म्‍हिगदेदा थेसे जुकजुकधोनाला जुनी पिन्‍खम्‍गै भिसी ह्राङसे थेदा जम्‍बुलिङला जम्‍मान म्‍हिगदेथोरी शासन लबा अधिकार पिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ह्राङ गिक जेन सत्‍य परमेश्‍वर हिन्‍ना भिसी ङोसेबादेन ह्राङसे पुइखबा येशू ख्रीष्‍टदा ङोसेबान जुकजुकधोनाला जुनी याङ्बा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ह्राङसे ङादा जिम्‍मा पिन्‍बा गे पूरा लसी ङाइ जम्‍बुलिङरी ह्राङदा मान लबा मुला। ");
INSERT INTO taj_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","परमेश्‍वर आबा, जम्‍बुलिङ स्‍होबा भन्‍दा ङाच्‍छा ङा ह्राङदेन छ्‌याम मुबा धुइरी गाते घ्रेन मानदेन जयजयकार मुबा। दाहेन्‍से थेह्रङ् लसीन ङादा ह्राङदेन छ्‌याम घ्रेन स्‍होउ। ");
INSERT INTO taj_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“ह्राङसे जम्‍बुलिङग्‍याम ङादा पिन्‍बा जम्‍मान म्‍हिगदेदा ङाइ ह्राङ खाल हिन्‍ना भिसी ङोसेना लबा मुला। थेनीगदे ह्राङलान म्‍हि मुबा, ओच्‍छे ह्राङसे ङादा पिन्‍जी। थेनीगदे ह्राङला बचन अन्‍छार भ्रबा मुला। ");
INSERT INTO taj_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ह्राङसे ङादा पिन्‍बा जम्‍मान ताम ह्राङग्‍यामसेन खबा हिन्‍ना भिसी दान्‍दे थेनीगदेसे था याङ्सी जिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","तिग्‍दा भिसम ह्राङसे ङादा पिन्‍बा बचन ङाइ थेनीगदेदा लोप्‍बा मुला, ओच्‍छे थेनीगदे थे अन्‍छार भ्रबान मुला। ङा ह्राङग्‍याम खबा हिन्‍ना भिसी थेनीगदेसे घोबा मुला, ओच्‍छे ङादा ह्राङसे पुइखबा हिन्‍ना भिसीएनोन थेनीगदेसे विश्‍वास लबा मुला। ");
INSERT INTO taj_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“ङाइ थेनीगदेलान लागिरी प्रार्थना लबान मुला, जम्‍बुलिङला म्‍हिगदेला लागिरी चा आहिन। तर ह्राङसे पिन्‍बा म्‍हिगदेलान लागिरी प्रार्थना लबान मुला, तिग्‍दा भिसम थेनीगदे ह्राङलान हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ङादेन छ्‌याम मुबा जम्‍मान ह्राङला हिन्‍ना, ह्राङदेन छ्‌याम मुबा जम्‍मान ङाला हिन्‍ना। ओच्‍छे थेनीगदेग्‍याम ङाला मानदेन जयजयकार तबा मुला। ");
INSERT INTO taj_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“दाहेन्‍से ङा ह्राङ मुबा ग्‍लारी खबान मुला। ल्‍हानान धिनधोना ङा चु जम्‍बुलिङरी आचि, तर चुगदे मी चु जम्‍बुलिङरीन चिला। थेतबासेलमा ङाला आबा परमप्रभु परमेश्‍वर, ह्राङदेन ङा गिक तबा ह्रङ् लसी चुगदेएनोन गिक तबाला लागिरी ह्राङसे ङादा पिन्‍बा ह्राङला मिनग्‍याम थेनीगदेदा जोगब लसी थान्‍गो। ");
INSERT INTO taj_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ङा थेनीगदेदेन छ्‌याम मुबा धुइरी ह्राङसे ङादा पिन्‍बा ह्राङला मिनग्‍याम ङाइ थेनीगदेदा जोगब लसी थान्‍जी। नाश ततोःबा म्‍हि बाहेक स्‍य्‍हान्‍दो खालैदान ङाइ नाश तआपुङ्नी। तिग्‍दा भिसम परमेश्‍वरला बचनरी भ्रिबा ताम पूरा तबाला लागिरीन चुह्रङ् तबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“तर दाहेन्‍से ङा ह्राङ मुबा ग्‍लारी खबान मुला। ङाग्‍याम याङ्बा ताङ्‍बा थेनीगदेसे पूरान याङ्‌गै भिसीन ङाइ चु ताम जम्‍बुलिङरी मुबा धुइरीन पाङ्बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ङा ह्राङसेन थेनीगदेदा ह्राङला बचन लोप्‍जी। तर थेनीगदेदा चु जम्‍बुलिङला म्‍हिगदेसे हेला लजी। तिग्‍दा भिसम ङा चु जम्‍बुलिङला आहिन्‍बा ह्रङ् थेनीगदेएनोन चु जम्‍बुलिङला आहिन। ");
INSERT INTO taj_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","थेनीगदेदा चु जम्‍बुलिङग्‍याम भोर्गो भिसी ङाइ प्रार्थना आल, तर थेनीगदेदा शैतानग्‍याम जोगब लसी थान्‍गो। ");
INSERT INTO taj_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ङा चु जम्‍बुलिङला आहिन्‍बा ह्रङ् थेनीगदेएनोन चु जम्‍बुलिङला आहिन। ");
INSERT INTO taj_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","थेनीगदेदा सत्‍य बचनग्‍याम ह्राङदा तेन्‍बा चोखो म्‍हि स्‍होउ। तिग्‍दा भिसम ह्राङला बचन सत्‍य मुला। ");
INSERT INTO taj_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ह्राङसे ङादा जम्‍बुलिङरी पुइखबा ह्रङ् लसी ङाइएनोन थेनीगदेदा जम्‍बुलिङरी पुइबा मुला। ");
INSERT INTO taj_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","थेनीगदेसे ह्राङसे ह्राङदान पूरान चोखो थान्‍गै भिसी ङाइनोन थेनीगदेला लागिरी ह्राङसे ह्राङदान चोखो स्‍होबा मुला। ");
INSERT INTO taj_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“ङाइ चुगदेला लागिरी जे आहिन, तर चुगदेला ताम थेःसी ङादा विश्‍वास लबा म्‍हिगदेला लागिरीनोन प्रार्थना लला। ");
INSERT INTO taj_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","थेनीगदे जम्‍मान गिक तसी चिबारी खम्‍गै। परमेश्‍वर आबा, ह्राङ ङादेन छ्‌याम ओच्‍छे ङा ह्राङदेन छ्‌याम गिक तबा ह्रङ् लसी थेनीगदेएनोन य्‍हाङदेन छ्‌याम गिक तबारी खम्‍गै। ओच्‍छे ङादा ह्राङसे पुइखबा हिन्‍ना भिसी जम्‍बुलिङला म्‍हिगदेसे विश्‍वास लबारी खम्‍गै। ");
INSERT INTO taj_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","य्‍हाङ गिक तबा ह्रङ् लसी थेनीगदेएनोन गिक तसी चिबारी खम्‍गै भिसी ह्राङसे ङादा मान याङ्बा म्‍हि स्‍होबा ह्रङ् लसी ङाइएनोन थेनीगदेदा मान याङ्बा म्‍हि स्‍होबा मुला। ");
INSERT INTO taj_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ङा थेनीगदेदेन छ्‌याम ओच्‍छे ह्राङ ङादेन छ्‌याम गिक तबा ह्रङ् लसी थेनीगदेएनोन पूरान गिक तबारी खम्‍गै। ओच्‍छे ङादा ह्राङसेन पुइखबा हिन्‍ना भिबादेन ह्राङसे ङादा माया लबा ह्रङ् लसी ह्राङसे थेनीगदेदाएनोन माया लमुला भिसी जम्‍बुलिङला जम्‍मान म्‍हिगदेसे था याङ्‌गै। ");
INSERT INTO taj_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“परमेश्‍वर आबा, ह्राङसे जम्‍बुलिङ स्‍होबा भन्‍दा ङाच्‍छाहेन्‍सेन ङादा माया लसी य्‍हालदेन शक्ति पिन्‍बा मुला। चु ताम म्राङ्बाला लागिरी ह्राङसे ङादा पिन्‍बा जम्‍मान म्‍हिगदे ङादेन छ्‌याम तगै भिबा ङाला सेम मुला। ");
INSERT INTO taj_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“ठीक निसाफ लबा परमेश्‍वर आबा, ह्राङदा जम्‍बुलिङला म्‍हिगदेसे ङोसेबा आरे, तर ङाइ ह्राङदा ङोसेबा मुला। ओच्‍छे ह्राङसेन ङादा पुइखबा हिन्‍ना भिसी ङाला चेलागदेसे था याङ्बा मुला। ");
INSERT INTO taj_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ह्राङसे ङादा लबा माया थेनीगदेदेन छ्‌याम तगै, ओच्‍छे ङा थेनीगदेदेन छ्‌याम तबारी खम्‍गै भिसी ङाइ थेनीगदेदा ह्राङ खाल हिन्‍ना भिसी ङोसेना लबा मुला। अझ ह्राङ खाल हिन्‍ना भिसी ङाइ थेनीगदेदा सदन पाङ्ला।” ");
INSERT INTO taj_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","प्रार्थना लसी जिन्‍माहेन्‍से येशू ह्राङला चेलागदेदेन छ्‌याम किद्रोन भिबा खोल्‍साला क्‍याम्‍सङपट्टि मुबा बगैँचारी फेप्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","थे ग्‍ला येशूदा चुङ्सी पिन्‍बा यहूदादाएनोन था मुबा। तिग्‍दा भिसम येशू ह्राङला चेलागदेदेन छ्‌याम थे ग्‍लारी ल्‍हानान ह्रङ्‌बा फेप्‍मुबा। ");
INSERT INTO taj_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","थे धुइरी फरिसीगदेदेन परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेसे पुइखबा परमेश्‍वरला मन्‍दिर ख्रुङ्बा सिपाहीदेन रोमी सिपाहीगदेदा भसी यहूदा येशू मुबा ग्‍लारी धोखजी। थेनीगदे हतियार थोसी नाङसलदेन मेदङ म्रासी खबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ह्राङदा तबारी छ्‌याइबा जम्‍मान ताम था याङ्सी थेनीगदेला ङाच्‍छापट्टि फेप्‍सी येशूसे थेनीगदेदा “एनीगदेसे खाल्‍दा म्‍हाइबा?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","जमाहेन्‍से थेनीगदेसे “नासरतला येशूदा म्‍हाइबा” भिसी भिमा, येशूसे थेनीगदेदा “ङा थेनोन हिन्‍ना” भिसी सुङ्जी। येशूदा चुङ्सी पिन्‍बा यहूदाएनोन थेनीगदेदेन छ्‌यामनोन राप्‍सी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","येशूसे थेनीगदेदा “ङा थेनोन हिन्‍ना” भिसी सुङ्बा थेःमैछ्‌याम थेनीगदे ग्‍यापपट्टि लेःमा जम्‍मान ह्रिल्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","दोःसी येशूसे थेनीगदेदा “एनीगदेसे खाल्‍दा म्‍हाइबान मुला?” भिसी सुङ्मा, थेनीगदेसे “नासरतला येशूदा म्‍हाइबा” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","येशूसे थेनीगदेदा “ङा थेनोन हिन्‍ना भिसी ङाइ एनीगदेदा दोलोन पाङ्सी जिन्‍जी। थेतबासेलमा एनीगदेसे ङादान म्‍हाइबा हिन्‍सम चु म्‍हिगदेदा चा निपुङ्‍गो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","“ह्राङसे ङादा पिन्‍बा म्‍हिगदे ङाइ गिकनोन नाश तपुङ्बा आरे” भिसी येशूसे ङाच्‍छान सुङ्बा ताम चुह्रङ् लसी पूरा तजी। ");
INSERT INTO taj_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","सिमोन पत्रुससे ह्राङदेन छ्‌याम मुबा तरवार तेःसी परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिला नोकरदा ताम्‍मा दाहिनेपट्टिला नाब्‍यङ च्‍वाट्टन थाजी। थेला मिन चा माल्‍खस मुबा। ");
INSERT INTO taj_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","येशूसे पत्रुसदा “एला तरवार स्‍युबारी झाङ्‍गो। तिग परमेश्‍वर आबासे नापुङ्बा दुख ङाइ थानागो?” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","जमाहेन्‍से रोमी सिपाहीगदेदेन थेनीगदेला कप्‍तान ओच्‍छे यहूदीगदेसे पुइबा परमेश्‍वरला मन्‍दिर ख्रुङ्बा सिपाहीगदेसे येशूदा चुङ्सी खीजी। ");
INSERT INTO taj_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ओच्‍छे ङाच्‍छा थेनीगदेसे येशूदा कैयाफाला केन हन्‍नास मुबा ग्‍लारी भोर्जी। कैयाफा चा परमेश्‍वरला मन्‍दिररी पूजा लबा थे दिङला मुल म्‍हि मुबा। ");
INSERT INTO taj_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","चुनोन कैयाफासे “जम्‍मान म्‍हिगदेला लागिरी म्‍हि गिक सिबा चा ज्‍यबा हिन्‍ना” भिसी यहूदी नेतागदेदा सल्‍लाह पिन्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","सिमोन पत्रुसदेन स्‍य्‍हान्‍दो चेला गिक चा येशूदेन छ्‌याम छ्‌याम निजी। थे स्‍य्‍हान्‍दो चेलासे चा परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिदा ज्‍यना लसी ङोसेमुबा। थेतबासेलमा थे येशूदेन छ्‌यामनोन परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिला दिमला ख्राङगारी निजी। ");
INSERT INTO taj_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","तर पत्रुस चा म्रापरीन राप्‍सी चिबा मुबा। थेतबासेलमा परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिदा ङोसेबा थे स्‍य्‍हान्‍दो चेला मङग्‍यार निसी म्रापरी चिबा म्रिङम्‍हेमेदा पाङ्सी पत्रुसदा न्‍हङ‍री भजी। ");
INSERT INTO taj_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","जमाहेन्‍से म्रापरी चिबा थे म्रिङम्‍हेमेसे पत्रुसदा “तिग एएनोन थे म्‍हिला चेला आहिन?” भिसी भिमा, पत्रुससे थेदा “ङा आहिन” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","खङ्बासे लमा थेरी नोकरगदेदेन पालेगदे मे दूसी चिबा मुबा। पत्रुसएनोन निसी थेनीगदेदेन छ्‌यामनोन मे दूबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिसे येशूदा थेला चेलागदेदेन छ्‌याम थेसे लोप्‍बा तामला बारेरी ङ्‌योइबा छार्बा लजी। ");
INSERT INTO taj_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","येशूसे थेदा चुह्रङ् भिसी सुङ्जी, “ङाइ जम्‍मालान ङाच्‍छा लोप्‍बा मुला। ङाइ सदन यहूदीगदे ह्रुप तबा दिमदेन परमेश्‍वरला मन्‍दिररी खबा जम्‍मान यहूदीगदेला ङाच्‍छा लोप्‍बा मुला। ङाइ खालैसे था आयाङ्ना लसी तिगै ताम पाङ्बा आरे। ");
INSERT INTO taj_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ङादा तिग्‍दा ङ्‌योइबा? ङाइ लोप्‍बा ताम थेःबागदेदा ङ्‌योइगो। ङाइ तिग पाङ्जी, तिग लोप्‍जी भिबा थेनीगदेदान था मुला।” ");
INSERT INTO taj_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","येशूसे चुह्रङ् सुङ्मा येशूला ङामरी राप्‍सी चिबा परमेश्‍वरला मन्‍दिरला सिपाही गिकसे येशूदा तोबान, “परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिदेन छ्‌याम चुह्रङ् लसी ताम लबारी तला?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","येशूसे थेदा “ङाइ पाङ्बा ताम ठीक आहिन्‍सम आहिन भिसी पाङ्‍गो। चुदे ङाइ पाङ्बा ताम ठीक हिन्‍सम तिग्‍दा ङादा तोबा?” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","जमाहेन्‍से हन्‍नाससे येशूदा आब्‍लानान परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हि कैयाफा मुबा ग्‍लारी पुइजी। ");
INSERT INTO taj_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","सिमोन पत्रुसएनोन राप्‍सी मे दूसी चिबा धुइरी थेरी मुबा म्‍हिगदेसे थेदा “एएनोन येशूलान चेला आहिन?” भिसी ङ्‌योइमा, थेसे थेनीगदेदा “आहिन, ङाइ थेदा ङोसेबान आरे” भिसी लुसीला ताम पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","पत्रुससे नाब्‍यङ थासी पिन्‍बा नोकरला ह्राङलान म्‍हिएनोन थेरी मे दूसी चिबा मुबा। थेएनोन परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिला नोकर मुबा। थेसे पत्रुसदा “ङाइ एदा थे म्‍हिदेन छ्‌यामनोन बगैँचारी म्राङ्बा आहिन?” भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","पत्रुससे दोःसीनोन आहिन, भिसी जोहाब पिन्‍जी। जोहाब पिन्‍मैछ्‌याम नागा क्राजी। ");
INSERT INTO taj_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","थेनीगदेसे येशूदा स्‍य्‍होरीन कैयाफाला दिमग्‍याम रोमी अञ्‍चलाधीशला दरबाररी भोर्जी। तर ह्राङ अशुद्ध तसी मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाडरी तिगै चबा स्‍हे चबारी आम्‍याङ् भिसी थेनीगदे चा लोङ्सी दरबार न्‍हङ‍री आवाङ्नी। ");
INSERT INTO taj_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","थेतबासेलमा रोमी हाकिम पिलातस मङग्‍यार खजी। ओच्‍छे थेसे थेनीगदेदा “एनीगदेसे चु म्‍हिला तिग दोष स्‍याप्‍जी?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","थेनीगदेसे थेदा “चुदे चु म्‍हिला दोष आस्‍याप्‍बा हिन्‍सम ङन्‍से चु म्‍हिदा ह्राङ मुबा ग्‍लारी आभसेला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","पिलातससे थेनीगदेदा “चु म्‍हिदा एनीगदेसेन भोर्गो, ओच्‍छे एनीगदेला ह्राङलान ठिम अन्‍छार चु म्‍हिला निसाफ लउ” भिसी भिजी। जमाहेन्‍से यहूदीगदेसे थेदा “खालै म्‍हिदा साइबाला सजाय पिन्‍बा ङन्‍ना लागिरी ठीक आरे” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ह्राङ खाह्रङ् लसी सितोःला भिसी येशूसेन सुङ्बा ताम पूरा तबाला लागिरीन चुह्रङ् तबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","दरबार न्‍हङ‍री निसी पिलातससे येशूदा ङ्‌योइजी, ओच्‍छे थेसे येशूदा “तिग ए यहूदीगदेला ग्‍ले हिन्‍ना?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","येशूसे पिलातसदा “चु ताम ह्राङसे ह्राङलान सेमग्‍याम सुङ्बा हिन्‍ना कि स्‍य्‍हान्‍दो खालै म्‍हिसे ह्राङदा ङाला बारेरी पाङ्बासे लमा चु ताम ङ्‌योइबा हिन्‍ना?” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","पिलातससे येशूदा “तिग ङा यहूदी हिन्‍ना? एलान य्‍हुलला म्‍हिगदेदेन परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेसे एदा चुरी भबा हिन्‍ना। एसे तिग लजी?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","येशूसे पिलातसदा “ङाइ शासन लबा चु जम्‍बुलिङरी आहिन। चुदे ङाइ चु जम्‍बुलिङरी शासन लबा हिन्‍सम ङादा यहूदीगदेला याग्‍याम जोगब लबारी ङाला म्‍हिगदे थेनीगदेदेन छ्‌याम छेसेला मुबा। तर ङाइ शासन लबा चुरी आहिन” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","पिलातससे येशूदा “थेह्रङ् भिसम ए ग्‍लेनोन हिन्‍ना?” भिसी ङ्‌योइमा, येशूसे पिलातसदा “ङा ग्‍ले हिन्‍ना भिसी मी ह्राङसेन सुङ्बा मुला। ङा ग्‍ले दोबाला लागिरी न्‍हबा हिन्‍ना, ओच्‍छे चुनोन सत्‍य ताम घोना लबाला लागिरी ङा चु जम्‍बुलिङरी खबा हिन्‍ना। थेतबासेलमा जुन म्‍हि सत्‍यला लिच्‍छा भ्रला थेसे ङाला ताम ङ्‌यान्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","पिलातससे येशूदा “खाह्रङ्बा सत्‍य ताम हिन्‍ना?” भिसी ङ्‌योइजी। चु तामगदे ङ्‍योइमैछ्‍याम पिलातस मङग्‍यार यहूदीगदे मुबा ग्‍लारी निसी चुह्रङ् भिसी भिजी, “ङाइ चु म्‍हिला तिगै दोष आस्‍याप्‍नी। ");
INSERT INTO taj_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","तर मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाडला धुइरी ङाइ एनीगदेला लागिरी म्‍हि गिकदा ख्‍लासी पिन्‍तोःमुबा। थेतबासेलमा ङाइ चु यहूदीगदेला ग्‍लेदा ख्‍लासी पिन्‍गै भिसी एनीगदेसे म्‍हन्‍बा मुला?” ");
INSERT INTO taj_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","तर थेनीगदेसे “चु म्‍हिदा आहिन, तर बारब्‍बादा ख्‍लासी पिन्‍गो” भिसी क्रिङ्बान भिजी। बारब्‍बासे चा आन्‍दोलन लसी म्‍हि साइबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","जमाहेन्‍से पिलातससे येशूदा भोर्सी कोर्रासे तोउ भिसी रोमी सिपाहीगदेदा कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","कोर्रासे तोमाहेन्‍से सिपाहीगदेसे पुजुला फेटा स्‍होसी येशूदा थोइसी पिन्‍जी, ओच्‍छे ग्‍लेसे क्‍वान्‍बा ह्रङ्‌बान वाला वाला पिङगै छोनना क्‍वानएनोन क्‍वान्‍सी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ओच्‍छे येशूला ङामरी खसी, “लास्‍सो यहूदीगदेला ग्‍ले, फ्‍याफुल्‍ला” भिसी येशूदा खिसी लबान ग्रम्‍बारी तोबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","पिलातस दोःसी मङग्‍यार खसी थेरी मुबा म्‍हिगदेदा “च्‍यागो, ङाइ चु म्‍हिदा सजाय पिन्‍बा तिगै दोष आस्‍याप्‍नी। चु ताम एनीगदेदा था तगै भिसी ङाइ थेदा मङग्‍यार भबा मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","येशू पुजुला फेटादेन वाला वाला पिङगै छोनना क्‍वान क्‍वान्‍सीन मङग्‍यार फेप्‍खजी। जमाहेन्‍से पिलातससे थेनीगदेदा “लु, च्‍यागो, चु म्‍हिदा!” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन सिपाहीगदेसे येशूदा म्राङ्मैछ्‍याम “चुदा क्रुसरी टाँगब लसी साइगो, क्रुसरी साइगो!” भिसी क्रिङ्बाला क्रिङ्बान लजी। जमाहेन्‍से पिलातससे थेनीगदेदा “चु म्‍हिदा एनीगदेसेन भोर्सी क्रुसरी टाँगब लउ, तिग्‍दा भिसम चु म्‍हिदा सजाय पिन्‍तोःबा तिगै दोष ङाइ आस्‍याप्‍नी” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","यहूदीगदेसे थेदा “ङन्‍ना ठिम गिक मुला थे ठिम अन्‍छार चुदा साइनोन तोःला। तिग्‍दा भिसम चुसे ह्राङसे ह्राङदान परमेश्‍वरला झा स्‍होबा मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","चु ताम थेःसी पिलातस झन लोङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","पिलातससे दोःसी दरबार न्‍हङरी वाङ्सी येशूदा “ए खानङला हिन्‍ना?” भिसी ङ्‌योइजी। तर येशूसे थेदा तिगै जोहाब आपिन्‍नी। ");
INSERT INTO taj_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","थेतबासेलमा पिलातससे येशूदा “तिग ए ङादेन छ्‌याम ताम आपाङ्? एदा ख्‍लासी पिन्‍बा अधिकार ङादा मुला, ओच्‍छे एदा क्रुसरी टाँगब लसी साइबा अधिकारएनोन ङादा मुला भिसी एदा था आरे?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","येशूसे थेदा “चु अधिकार परमेश्‍वरसे आपिन्‍बा हिन्‍सम ह्राङसे ङादा तिगै लबारी आखम्‍बसेला मुबा। थेतबासेलमा ङादा ह्राङला जिम्‍मारी पिन्‍बा म्‍हिदा झन ल्‍हाना पापला दोष तला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","चु ताम थेःसी पिलातससे झन येशूदा ख्‍लाबारी म्‍हाइजी। तर यहूदीगदेसे क्रिङ्बान चुह्रङ् भिसी भिजी, “चुदे ह्राङसे चु म्‍हिदा ख्‍लाजी भिसम ह्राङ रोमी ग्‍याल्‍बो कैसरला म्‍हि आहिन। जुन म्‍हिसे ह्राङसे ह्राङदान ग्‍ले हिन्‍ना भिसी पाङ्ला थे म्‍हिसे रोमी ग्‍याल्‍बो कैसरला बिरोध लबा हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","चु ताम थेःसी पिलातससे येशूदा मङग्‍यार भजी ओच्‍छे पिलातस युङबा तीबा ख्राङगारी निसाफ लबा ठिरी चिजी। थे युङबा तीबा ख्राङगादा हिब्रू ग्‍योइरी गब्‍बथा भिसी भिमुला। ");
INSERT INTO taj_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","थे धुइरी ओस्‍पन धिनना बाह्र बजब तसी जिन्‍बा मुबा। थे धिन चा मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाड धङ्‍बारी तयार लबा धिन मुबा। पिलातससे यहूदीगदेदा “च्‍यागो, एनीगदेला ग्‍ले” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","तर थेनीगदेसे “चुदा क्रुसरी टाँगब लसी साइबारी भोर्नोन तोःला” भिसी क्रिङ्बाला क्रिङ्बान लजी। जमाहेन्‍से पिलातससे थेनीगदेदा “थेह्रङ् भिसम ङाइ एनीगदेला ग्‍लेदा क्रुसरी टाँगब लसी साइगो?” भिसी भिमा, परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेसे “रोमी ग्‍याल्‍बो कैसर बाहेक ङन्‍ना स्‍य्‍हान्‍दो खालै ग्‍ले आरे” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","थेतबासेलमा चु ताम थेःसी पिलातससे येशूदा क्रुसरी टाँगब लसी साइगो भिसी थेनीगदेदा जिम्‍मा लसी पिन्‍जी। जमाहेन्‍से येशूला जिम्‍मा सिपाहीगदेसे किन्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","येशूसे ह्राङला क्रुस ह्राङसेन पुइसी, “खप्‍परला ग्‍ला” भिबा ग्‍लारी फेप्‍जी, चु ग्‍लादा हिब्रू ग्‍योइरी गलगथा भिमुबा। ");
INSERT INTO taj_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","थेरी धोमाहेन्‍से थेनीगदेसे येशूदा क्रुसरी टाँगब लजी, ओच्‍छे य्‍हो न्‍हीदाएनोन गिकदा येशूला दाहिनेपट्टि गिकदा देब्रेपट्टि क्रुसरी टाँगब लजी। येशूदा चा गुङरी थान्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","पिलातससे “नासरतला येशू, यहूदीगदेला ग्‍ले” भिसी भ्रिबा ताम येशूला थोबो भन्‍दा फिरी क्रुसरी ठोक्‍पुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","चु ताम ल्‍हानान यहूदीगदेसे पढब लजी। तिग्‍दा भिसम येशूदा क्रुसरी टाँगब लसी साइबा ग्‍ला शहरला ङामरीन मुबा। चु ताम हिब्रू, ल्‍याटिनदेन ग्रीक ग्‍योइरी भ्रिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","परमेश्‍वरला मन्‍दिररी पूजा लबा यहूदीगदेला मुल म्‍हिगदेसे पिलातसदा “‘यहूदीगदेला ग्‍ले’ भिसी आहिन, तर चुसे ङा यहूदीगदेला ग्‍ले हिन्‍ना भिजी भिसी भ्रिउ” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","पिलातससे थेनीगदेदा “ङाइ जुन ताम भ्रिसै, भ्रिसी जिन्‍जी, तजी” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","येशूदा क्रुसरी टाँगब लमाहेन्‍से सिपाहीगदेसे येशूला क्‍वान भो ब्‍लि लसी ह्राङ ह्राङ न्‍हङ‍री भो लजी। ओच्‍छे थेनीगदेसे येशूसे न्‍हङ‍री क्‍वान्‍बा क्‍वानएनोन किन्‍जी, तर थे क्‍वान चा आढुप्‍ना तोरहेन्‍से मारधोनान रासी स्‍होबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","थेतबासेलमा थेनीगदेसे “चु चा आढेगे, तर खाल्‍दा परब तबा चीम चिट्ठा युसी च्‍यागे” भिसी ह्राङ ह्राङ न्‍हङ‍री ताम लजी। बचनरी भ्रिबा ताम पूरा तबाला लागिरीन चुह्रङ् तबा मुबा। बचनरी “थेनीगदेसे ङाला क्‍वान ह्राङ ह्राङ न्‍हङ‍री भो लजी, ओच्‍छे ङाला क्‍वान किन्‍बाला लागिरी चा चिट्ठा युजी” भिसी भ्रिबा मुबा। थेतबासेलमा सिपाहीगदेसे चु गे लजी। ");
INSERT INTO taj_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","येशूला आमादेन येशूला आमाला आङा ओच्‍छे क्‍लोपासला म्रिङ मरियमदेन मरियम मग्‍दलिनी येशूला क्रुसला ङामरी राप्‍सी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","येशूसे ह्राङला आमादेन ह्राङसे माया लबा चेला ङामरी राप्‍सी चिबा म्राङ्सी आमादा “आमा च्‍यागो, दाहेन्‍से चु ह्राङला झा हिन्‍ना” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ओच्‍छे येशूसे थे चेलादाएनोन “च्‍यागो, दाहेन्‍से थे एला आमा हिन्‍ना” भिसी सुङ्जी। जमाकुनुहेन्‍से थे चेलासे येशूला आमा मरियमदा ह्राङला दिमरी भोर्जी। ");
INSERT INTO taj_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","“दाहेन्‍से ङाइ लतोःबा गे जिन्‍जी” भिसी येशूसे था याङ्सी बचनरी भ्रिबा जम्‍मान ताम पूरा तगै भिसी येशूसे “ङादा क्‍युइ फुइजी” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","थेरी अङगुरला कम्‍बा निङगु मुबा ताङ गिक मुबा। थेतबासेलमा सिपाहीगदेसे हिसप भिबा दोङला हाँगारी क्‍वानगेन खीसी थे निङगुरी ब्‍लुम्‍सी येशूदा ख्‍वाजी। ");
INSERT INTO taj_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","अङगुरला निङगु सोल्‍माहेन्‍से येशूसे “दाहेन्‍से ङाला गे जिन्‍जी” भिसी थोबो कु लजी। जमाहेन्‍से येशूला सा निजी। ");
INSERT INTO taj_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","थे धिन चा मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाड धङ्‍बारी तयार लबा धिन मुबा। चु धिन चा यहूदीगदेसे ब्‍लप्‍बा न्‍हबा धिनना ङाच्‍छाकुनु मुबा। न्‍हङगरदङ मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाड धङ्बा धिन परब तबासे लमा जमाकुनुला ब्‍लप्‍बा न्‍हबा धिन चा थेनीगदेला लागिरी मुल धिन मुबा। थेतबासेलमा थे मुल धिनकुनु क्रुसरी खालैलान लास आतगै भिसी यहूदीगदेसे ह्राङ ह्राङ न्‍हङ‍री सल्‍लाह लजी। ओच्‍छे थेनीगदे पिलातस मुबा ग्‍लारी निसी, “सिबाला सजाय पिन्‍बा म्‍हिगदे योनान सिगै भिसी थेनीगदेला काङ क्‍युइसी क्रुसग्‍याम मार तेःपुङ्‍गो” भिसी बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","जमाहेन्‍से सिपाहीगदे खसी ङाच्‍छा येशूदेन छ्‌यामनोन क्रुसरी टाँगब लबा म्‍हि न्‍हीला काङ क्‍युइजी। ");
INSERT INTO taj_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","येशूलाएनोन स्‍य्‍हाप क्‍युइबारी छ्‌याइमा थेनीगदेसे येशू ङाच्‍छान सिसी जिन्‍बा म्राङ्जी। थेतबासेलमा थेनीगदेसे येशूला स्‍य्‍हाप आक्‍युइनी। ");
INSERT INTO taj_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","तर सिपाही गिकसे येशूला राइरी भालासे भ्‍लोमा येशूला राइग्‍याम कादेन क्‍युइ थोन्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","एनीगदेसेनोन विश्‍वास लखम्‍गै भिसी चु म्राङ्बा म्‍हिसे जस्‍तो तबा म्राङ्बा मुबा थेह्रङ्बान पाङ्बा मुला। चु ताम सत्‍य हिन्‍ना भिबा थेदा था मुला। ");
INSERT INTO taj_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","“थेला नख्रु गिकनोन आक्‍युइ” भिसी बचनरी भ्रिबा ताम पूरा तबाला लागिरीन चुह्रङ् तबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","दोःसी बचनना अर्गु ग्‍लारी “जुन म्‍हिदा थेनीगदेसे भ्‍लोला, थेनोन म्‍हिदा थेनीगदेसे च्‍याला” भिसी भ्रिबा मुला। ");
INSERT INTO taj_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","यहूदीगदेदेन छ्‌याम लोङ्सी स्‍य्‍हान्‍दोसे था आयाङ्ना येशूदा विश्‍वास लबा अरिमाथिया भिबा शहरला योसेफ भिबा चेला गिक मुबा। थेसे पिलातसदेन छ्‌याम येशूला लास ह्रीजी, जमाहेन्‍से पिलातससे थेदा “तला, भोर्गो” भिसी भिजी। जमाहेन्‍से थे निसी येशूला लास क्रुसग्‍याम मार तेःसी भोर्जी। ");
INSERT INTO taj_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ओच्‍छे ङाच्‍छा म्‍हुनङ येशू मुबा ग्‍लारी निबा निकोदेमसएनोन बोगल गिकसे च्‍युक सोम किलो ते मूर्रदेन घ्‍युकुमारी दोङ्‌सी स्‍होबा ज्‍यबा बास्‍ना खबा अत्तर भसी खजी। ");
INSERT INTO taj_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","चुह्रङ् लसी थेनीगदेसे यहूदीगदेला ठिम अन्‍छार येशूला लासरी थे बास्‍ना खबा अत्तर फोर्सी मलमलला क्‍वानरी रिल्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","येशूदा क्रुसरी टाँगब लबा ग्‍लाला ङामरी बगैँचा गिक मुबा। थे बगैँचारी खालैलान लास आथान्‍बा छार धुर्सा गिक मुबा। ");
INSERT INTO taj_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","यहूदीगदेसे ब्‍लप्‍बा न्‍हबा धिनना ङाच्‍छाकुनुला धिन तबासे लमा थेनीगदेसे येशूला लास थे ङामरीन मुबा धुर्सारी थान्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","आइतवार स्‍य्‍होरीन मरियम मग्‍दलिनी येशूला लास थान्‍बा धुर्सारी निजी। धुर्सारी धोसी च्‍यामा थेसे धुर्साला म्रापरी मुबा युङबा लेःसी जिन्‍बा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","जमाहेन्‍से थे थेग्‍याम यार्बान सिमोन पत्रुसदेन येशूसे माया लबा चेला मुबा ग्‍लारी निसी, “थेनीगदेसे य्‍हाङला प्रभुदा धुर्साग्‍याम भोर्जीम! तर खानङ भोर्सी थान्‍जी भिबा ङन्‍दा था आरे” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","जमाहेन्‍से तुरुन्‍तन पत्रुसदेन थे चेला यार्बान धुर्सारी निजी। ");
INSERT INTO taj_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","थेन्‍नी छ्‌याम छ्‌यामनोन यार्सी निमा पत्रुसदा ख्‍लासी थे स्‍य्‍हान्‍दो चेला चा धुर्सारी ङाच्‍छा धोजी। ");
INSERT INTO taj_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","धुर्साला म्रापग्‍याम योइ तसी च्‍यामा थेसे ङाच्‍छा येशूदा बेरब लबा क्‍वान जे म्राङ्जी, तर थे धुर्सा न्‍हङ‍री आवाङ्नी। ");
INSERT INTO taj_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","सिमोन पत्रुसएनोन थे चेलाला लिच्‍छा लिच्‍छा खसी धुर्सा न्‍हङ‍री वाङ्सी च्‍याजी। थेसेनोन थेरी येशूदा बेरब लबा मलमलला क्‍वान जे म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","येशूला थोबोरी बेरब लबा क्‍वान चा मलमलला क्‍वानदेन छ्‌याम आरेबा। तर जजाकी क्‍याथाङपट्टि भसी पटट्‍याब लसी थान्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","जमाहेन्‍से पत्रुस भन्‍दा ङाच्‍छा धोखबा चेलाएनोन धुर्सा न्‍हङ‍री वाङ्सी च्‍याजी। चु म्राङ्माहेन्‍से थेसे येशू सिबाग्‍याम सोजीम भिसी विश्‍वास लजी। ");
INSERT INTO taj_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","तिग्‍दा भिसम येशू सिबाग्‍याम दोःसी सोनोन तोःला भिसी बचनरी भ्रिबा ताम थेनीगदेसे दान्‍देधोना घोबा आरेबा। ");
INSERT INTO taj_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","जमाहेन्‍से थे चेला न्‍ही ह्राङला दिमरी निजी। ");
INSERT INTO taj_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","तर मरियम मग्‍दलिनी चा क्राबान धुर्साला ङामरी राप्‍सी चिबा मुबा। क्राबान थेसे धुर्सा न्‍हङ‍री योइ तसी च्‍यामा, ");
INSERT INTO taj_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","येशूला लास थान्‍बा ग्‍लारी तार क्‍वान क्‍वान्‍बा स्‍वर्गदूत न्‍हीदा म्राङ्जी, गिक येशूला थोबोपट्टि गिक स्‍य्‍हापपट्टि मुबा। ");
INSERT INTO taj_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","थे स्‍वर्गदूत न्‍हीसे थेदा “माइ, ए तिग्‍दा क्राबा?” भिसी ङ्‌योइमा, थेसे थेनीगदेदा “म्‍हिगदेसे ङाला प्रभुदा भोर्जीम, थे म्‍हिगदेसे प्रभुदा खानङ भोर्सी थान्‍जी भिबा ङादा था आरे” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","चुह्रङ् भिसी थेसे ग्‍याप्‍पट्टि च्‍यामा येशू राप्‍सी स्‍य्‍हूबा म्राङ्जी। तर थेसे येशून हिन्‍ना भिसी ङोआसेनी। ");
INSERT INTO taj_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","येशूसे थेदा “माइ, ए तिग्‍दा क्राबा? एसे खाल्‍दा म्‍हाइबा?” भिसी सुङ्मा, थेसे येशूदा बगैँचारी म्‍हेन्‍दो क्‍वबा म्‍हि मुनम भिसी, “ज्‍योज्‍यो, ह्राङसे येशूदा चुग्‍याम भोर्बा हिन्‍सम खानङ थान्‍बा मुला ङादा सुङ्‍गो, ङाइ थेदा भोर्ला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","येशूसे थेदा “मरियम!” भिसी ङ्‌योइमा, फ्‍लिक दोःसी थेसे येशूदा, हिब्रू ग्‍योइरी “रब्‍बोनी” भिसी भिजी। “रब्‍बोनी” भिबा चा “ङाला गुरु” भिबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","येशूसे थेदा “ङादा चुङ्सी थाथान्‍गो, तिग्‍दा भिसम ङा दान्‍देधोना आबा मुबा ग्‍लारी निबा आरे। तर ए ङाला ज्‍योज्‍यो आले नाना आङागदे मुबा ग्‍लारी निसी थेनीगदेदा ‘ङाला आबादेन एनीगदेला आबा ओच्‍छे ङाला परमेश्‍वरदेन एनीगदेला परमेश्‍वर मुबा ग्‍लारी ङा निबान मुला’ भिसी पाङ्सी पिन्‍गो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","जमाहेन्‍से मरियम मग्‍दलिनी चेलागदे मुबा ग्‍लारी निसी, “ङाइ प्रभुदा म्राङ्जी” भिसी भिजी। ओच्‍छे येशूसे थेदा सुङ्बा ताम थेनीगदेदाएनोन पाङ्सी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","थेनोन धिनकुनु ङ्‍यसे येशूला चेलागदे यहूदी नेतागदेदेन छ्‌याम लोङ्सी म्राप ढुङ्सी चिबा मुबा। थे धुइरीन येशू थेनीगदे मुबा ग्‍लारी फेप्‍खसी थेनीगदेला गुङरी राप्‍सी धन्‍छ्‌याजी। ओच्‍छे येशूसे थेनीगदेदा “एनीगदेदा शान्‍ति तगै” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","चुह्रङ् सुङ्माहेन्‍से येशूसे थेनीगदेदा ह्राङला यादेन राइ उन्‍जी। प्रभुदा म्राङ्सी थेनीगदे ल्‍हानान ताङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","जमाहेन्‍से येशूसे दोःसीनोन थेनीगदेदा “एनीगदेदा शान्‍ति तगै! ङाला आबासे ङादा पुइखबा ह्रङ् लसी ङाइएनोन एनीगदेदा पुइबान मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","जमाहेन्‍से येशूसे थेनीगदेदा फू लसी चुह्रङ् भिसी सुङ्जी, “परमेश्‍वरला आत्‍मा किन्‍गो। ");
INSERT INTO taj_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","जुन म्‍हिला पाप एनीगदेसे माफ लला, थेनीगदेसे माफ याङ्ला, ओच्‍छे जुन म्‍हिला पाप एनीगदेसे माफ आल, थेनीगदेसे माफ आयाङ्।” ");
INSERT INTO taj_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","येशू फेप्‍खबा धुइरी च्‍युक न्‍ही चेलागदे न्‍हङ‍री दिदुमस भिबा थोमा चा थेनीगदेदेन छ्‌याम आरेमुबा। ");
INSERT INTO taj_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","थेतबासेलमा स्‍य्‍हान्‍दो चेलागदेसे थेदा “ङन्‍से प्रभुदा म्राङ्जी” भिसी भिजी। तर थेसे थेनीगदेदा “येशूला यारी खिल ठोक्‍बाला पोर आम्राङ्तेधोना, ओच्‍छे थे पोरदेन राइला पोररी ङाला या जुम्‍बी आझाङ्तेधोना ङाइ विश्‍वास आल” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","साता गिक लिच्‍छाएनोन चेलागदे दिमरीन म्राप ढुङ्सी चिबा मुबा। जमा चा थोमाएनोन थेनीगदेदेन छ्‌यामनोन मुबा। तर येशू थेनीगदे मुबा ग्‍लारी फेप्‍खसी थेनीगदेला गुङरी राप्‍सी धन्‍छ्‌याजी, ओच्‍छे “एनीगदेदा शान्‍ति तगै!” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","जमाहेन्‍से येशूसे ह्राङला छ्‌या उन्‍बान थोमादा “एला या जुम्‍बी चुरी थान्‍गो, ओच्‍छे ङाला या च्‍यागो। ओच्‍छे एला यासे ङाला राइरी थुर्सी च्‍यागो। एसे शङ्का थालउ, तर विश्‍वास लउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","थेनोन धुइरी थोमासे येशूदा “ङाला प्रभुदेन परमेश्‍वर!” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","येशूसे थेदा “एसे ङादा म्राङ्बासे लमा विश्‍वास लबा आहिन? तर जुन म्‍हिसे ङादा आम्राङ्सैनोन विश्‍वास लला, थेसे गाते ल्‍हानान मोलम याङ्ला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","येशूसे ह्राङला चेलागदेला ङाच्‍छा ल्‍हानान उदेकला गेदेन शक्तिशाली गेगदे लबा मुबा, थे तामगदे चु किताबरी भ्रिबा आरे। ");
INSERT INTO taj_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","तर एनीगदेसे येशू परमेश्‍वरला झा थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍ना भिसी विश्‍वास लगै भिसीन चु किताब भ्रिबा हिन्‍ना। थेदा विश्‍वास लसी एनीगदेसे जुकजुकधोनाला जुनी याङ्‌गै। ");
INSERT INTO taj_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","जमाहेन्‍से येशू दोःसी गालील अञ्‍चलला तिबेरियास भिबा समुन्‍द्रला कुनीरी ह्राङला चेलागदे मुबा ग्‍लारी फेप्‍खजी। चुह्रङ् लसी येशू थेनीगदे मुबा ग्‍लारी फेप्‍खजी। ");
INSERT INTO taj_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","थेरी सिमोन पत्रुस, दिदुमस भिबा थोमा, गालील अञ्‍चलला काना भिबा शहरला नथानेलदेन जब्‍दियाला झा न्‍ही, ओच्‍छे स्‍य्‍हान्‍दो चेला न्‍ही पोप तसी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","सिमोन पत्रुससे ह्राङला ह्रोगदेदा “दाहेन्‍से ङा मी तार्ङा साइबारी निला” भिसी भिमा, थेला ह्रोगदेसे “ङनीएनोन एदेन छ्‌यामनोन निला” भिसी भिजी। जमाहेन्‍से थेनीगदे दोँगारी क्रेःजी। तर थेनीगदेसे म्‍हुन गिकरी तार्ङा गिकनोन चुङ्बारी आखम्‍नी। ");
INSERT INTO taj_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","य्‍हाल तबारी छ्‌याइबा धुइरी येशू समुन्‍द्रला कुनीरी राप्‍सी धन्‍छ्‌याबा मुबा। तर चेलागदेसे येशून हिन्‍ना भिसी ङोआसेनी। ");
INSERT INTO taj_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","येशूसे थेनीगदेदा “कोलागदे, एनीगदेदेन छ्‌याम तार्ङा मुला?” भिसी ङ्‌योइमा, थेनीगदेसे “आरे” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","येशूसे थेनीगदेदा “एनीगदेसे दोँगाला दाहिनेपट्टि घ्‍याङ रोप्‍गो तार्ङा स्‍याप्‍ला” भिसी सुङ्जी। थेनीगदेसे येशूसे सुङ्बा ग्‍लारी घ्‍याङ रोप्‍मा ल्‍हानान तार्ङा स्‍याप्‍बासे लमा घ्‍याङनोन छेङ्बारी आखम्‍नी। ");
INSERT INTO taj_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","येशूसे माया लबा चेलासे पत्रुसदा “थे मी प्रभु गा चीम” भिसी भिजी। “थे मी प्रभु गा चीम” भिबा थेःसी सिमोन पत्रुस ह्राङला क्‍वान क्रेप्‍सरी खीसी समुन्‍द्ररी वाङ्‌जी। तिग्‍दा भिसम थेसे क्‍वान स्‍युबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","तर स्‍य्‍हान्‍दो चेलागदे चा दोँगारीन चिसी तार्ङासे प्‍लिङ्बा घ्‍याङ छेङ्बान समुन्‍द्रला कुनीरी खजी। समुन्‍द्रला कुनीग्‍याम थेनीगदे ल्‍हाना थारेङ आरेमुबा, ओस्‍पन ग्‍यार्जा गिक मिटर ते जे थारेङ मुबा। ");
INSERT INTO taj_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","समुन्‍द्रला कुनीरी धोखमाहेन्‍से थेनीगदेसे मेभुप्‍रारी तार्ङा म्राङ्जी ओच्‍छे गेङएनोन म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","येशूसे थेनीगदेदा “एनीगदेसे भर्खर चुङ्बा तार्ङा जजाकी भउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","जमाहेन्‍से सिमोन पत्रुस दोँगारी क्रेःसी घ्रेन घ्रेन तार्ङासे प्‍लिङ्बा घ्‍याङ छेङ्बान पाखारी भजी। थेरी ग्‍यार्जा गिकसे बोगल न्‍हीसे च्‍युक सोम तार्ङा मुबा। ओते ल्‍हाना मुसैनोन घ्‍याङ चा आढेनी। ");
INSERT INTO taj_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","येशूसे थेनीगदेदा “चबारी खउ” भिसी सुङ्जी। तर चेलागदे खालैसेन येशूदा “ह्राङ खाल हिन्‍ना?” भिसी ङ्‌योइबा सेम आलनी। तिग्‍दा भिसम येशू प्रभु हिन्‍ना भिसी थेनीगदेसे ङोसेसी जिन्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","येशू फेप्‍खसी थेनीगदेदा गेङदेन तार्ङा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","येशूदा सिबाग्‍याम सोना लमाहेन्‍से ह्राङला चेलागदे मुबा ग्‍लारी फेप्‍खबा चु सोमरेमला पालरी मुबा। ");
INSERT INTO taj_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","थेनीगदेसे चसी जिन्‍माहेन्‍से येशूसे सिमोन पत्रुसदा “यूहन्‍नाला झा सिमोन, तिग एसे ङादा चुगदेसे भन्‍दा ल्‍हाना माया लला?” भिसी सुङ्जी। जमाहेन्‍से पत्रुससे येशूदा “हिन्‍ना प्रभु, ङाइ ह्राङदा माया लमुला भिबा ताम ह्राङदान था मुला” भिसी भिमा, येशूसे थेदा “थेह्रङ् भिसम एसे ङाला ग्‍युला कोलागदेदा ज्‍यना लसी छउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","येशूसे दोःसी, “यूहन्‍नाला झा सिमोन, तिग एसे ङादा माया लला?” भिसी सुङ्जी। जमाहेन्‍से थेसे येशूदा “हिन्‍ना प्रभु, ङाइ ह्राङदा माया लमुला भिबा ताम ह्राङदान था मुला” भिसी भिमा, येशूसे थेदा “थेह्रङ् भिसम एसे ङाला ग्‍युगदेदा ज्‍यना लसी च्‍यागो” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","येशूसे दोःसीनोन थेदा “यूहन्‍नाला झा सिमोन, तिग एसे ङादा माया लला?” भिसी सुङ्जी। येशूसे चुह्रङ् लसी सोमरेमधोना “तिग एसे ङादा माया लला?” भिसी सुङ्बासे लमा ल्‍हानान आज्‍यना ङ्‍हम्‍सी पत्रुससे येशूदा “प्रभु, ह्राङदा जम्‍मान ताम था मुला। ङाइ ह्राङदा माया लमुला भिबा तामएनोन ह्राङदा था मुला” भिसी भिजी। जमाहेन्‍से येशूसे थेदा चुह्रङ् भिसी सुङ्जी, “थेह्रङ् भिसम एसे ङाला ग्‍युगदेदा ज्‍यना लसी छउ। ");
INSERT INTO taj_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","एसे ङाला ताम ङ्‌यान्‍गो, ए भ्‍योन मुबा धुइरी एसे ह्राङला केः ह्राङसेन खीमुबा, ओच्‍छे जुन ग्‍लारी निबा सेम लमुबा थेरीन निमुबा। तर खेप्‍बा दोमाहेन्‍से एसे तिगै लबारी आखम, एदा स्‍य्‍हान्‍दो म्‍हिसे केः खीसी पिन्‍ना ओच्‍छे जुन ग्‍लारी एदा निआम्‍हन थेरीन एदा भोर्ला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","चु ताम चा परमेश्‍वरदा मान लबादेन जयजयकार लबारी पत्रुस खाह्रङ् लसी सितोःला भिसी येशूसे सुङ्बा हिन्‍ना। चु ताम सुङ्सी जिन्‍माहेन्‍से येशूसे पत्रुसदा “ए ङादेन छ्‌याम भ्रउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","पत्रुससे ग्‍याप दोःसी च्‍यामा येशूसे माया लबा चेला लिच्‍छा लिच्‍छा खबान लबा म्राङ्जी। चुनोन चेलासे भोज चबा धुइरी येशूला ङामरी चिसी, “प्रभु, ह्राङदा चुङ्सी पिन्‍बा म्‍हि खाल हिन्‍ना?” भिसी ङ्‌योइबा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","थेदा म्राङ्सी पत्रुससे येशूदा “चुला चा तिग तला?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","जमाहेन्‍से येशूसे पत्रुसदा “ङा आखतेधोना थेसे ङादा भ्रान्‍सी चिइ भिबा ङाला सेम मुसैनोन एदा तिग्‍दा तोःजी? ए चा ङादेन छ्‌याम भ्रउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","थेतबासेलमा थे चेला आसिनम भिबा ताम स्‍य्‍हान्‍दो चेलागदेसे था याङ्जी। येशूसे मी थे आसि भिसी सुङ्बा आरेमुबा, तर “ङा आखतेधोना थेसे ङादा भ्रान्‍सी चिइ भिबा ङाला सेम मुसैनोन एदा तिग्‍दा तोःजी?” भिसी जे सुङ्बा मुबा। ");
INSERT INTO taj_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","चुनोन चेलासे चु जम्‍मान ताम पाङ्बा हिन्‍ना, ओच्‍छे थेसेन चु ताम भ्रिबा हिन्‍ना। थेसे पाङ्बा तामदेन भ्रिबा ताम सत्‍य मुला भिसी ङन्‍दा था मुला। ");
INSERT INTO taj_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","येशूसे अर्गुएनोन ल्‍हानान गेगदे लबा मुला। थे जम्‍मान गेला बारेरी भ्रिबा हिन्‍सम चु किताबगदे जम्‍बुलिङ नाङनोन आवाङ्सेला मुबा भिसी ङाइ म्‍हन्‍मुला।");
INSERT INTO taj_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","लास्‍सो, थियोफिलस, फ्‍याफुल्‍ला, ङाइ ह्राङदा येशूसे गे शुरु लबाहेन्‍से स्‍वर्गरी आभोर्तेधोना थेसे लबादेन लोप्‍बा जम्‍मान तामला बारेरी ङाच्‍छान भ्रिसी जिन्‍बा मुला। चु तबा भन्‍दा ङाच्‍छा येशूसे परमेश्‍वरला आत्‍माग्‍याम ह्राङसे धम्‍बा मुल चेलागदेसे तिग गे लतोःला भिसी सुङ्बा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","येशू सिसी जिन्‍माहेन्‍से ह्राङदा सिबाग्‍याम सोना लबा मुला भिबा ताम ल्‍हानान ग्‍यामसे उन्‍बाला लागिरी बोगल न्‍ही धिनधोना ह्राङला चेलागदे मुबा ग्‍लारी फेप्‍खजी। ओच्‍छे थेनीगदेदा परमेश्‍वरला य्‍हुल्‍साला बारेरी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","तिरेकुनु थेनीगदेदेन छ्‌याम धन्‍छ्‌यासी सोल छ्‌योइबा धुइरी येशूसे थेनीगदेदा चुह्रङ् भिसी कुल्‍जी, “एनीगदे यरूशलेम शहर ख्‍लासी खानङएनोन थानिउ। परमेश्‍वर आबासे ह्राङला आत्‍मा पिन्‍ना भिसी लबा कबुल आयाङ्‌तेधोना भ्रान्‍सी चिउ। थे कबुलला बारेरी ङाइ एनीगदेदा ङाच्‍छान पाङ्सी जिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","तिग्‍दा भिसम यूहन्‍नासे क्‍युइग्‍याम बप्‍तिस्‍मा पिन्‍जी, तर दाहेन्‍से तिगै धिन लिच्‍छा एनीगदेला बप्‍तिस्‍मा परमेश्‍वरला आत्‍माग्‍याम तला।” ");
INSERT INTO taj_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","थेतबासेलमा थेनीगदे पोप तसी चिबा धुइरी चेलागदेसे येशूदा “प्रभु, दान्‍दे ह्राङसे इस्राएल य्‍हुल्‍सादा दोःसी छार स्‍होबारी छ्‌याइबा हिन्‍ना?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","येशूसे थेनीगदेदा चुह्रङ् भिसी सुङ्जी, “चु ताम परमेश्‍वर आबासे तोगब लबा धिनदेन धुइगदेरी तनोन तला। तर थे तामगदे घोबारी म्‍हाइबा एनीगदेला गे आहिन। ");
INSERT INTO taj_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","तर परमेश्‍वरला आत्‍मा एनीगदेथोरी फेप्‍खमाहेन्‍से एनीगदेसे शक्ति याङ्ला। जमाहेन्‍से एनीगदे यरूशलेमहेन्‍से यहूदियादेन सामरिया अञ्‍चलरी, ओच्‍छे जम्‍बुलिङला कनाकुनीधोना ङाला साक्षी दोला।” ");
INSERT INTO taj_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","येशूसे चुह्रङ् सुङ्माहेन्‍से थेनीगदेसे च्‍याना च्‍यानान येशूदा स्‍वर्गरी भोर्जी। ओच्‍छे येशूदा खसुसे घप्‍जी। जमाहेन्‍से थेनीगदेसे येशूदा आम्राङ्‌नी। ");
INSERT INTO taj_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","थेनीगदे एकोहोरो तसी मुपट्टि च्‍यासी चिबा धुइरी तिक्‍खुरीन तार क्‍वान क्‍वान्‍बा म्‍हि न्‍ही थेनीगदेला ङामरी राप्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ओच्‍छे थे म्‍हि न्‍हीसे थेनीगदेदा “गालीलला म्‍हिगदे, तिग्‍दा एनीगदे मुपट्टि च्‍यासी राप्‍सी चिबा? एनीगदे मुबाग्‍याम स्‍वर्गरी फेप्‍बा चुनोन येशू दान्‍दे एनीगदेसे खाह्रङ् लसी स्‍वर्गरी फेप्‍बान लबा म्राङ्बा मुला। थेह्रङ् लसीन थे दोःसी फेप्‍खला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","जमाहेन्‍से थेनीगदे जैतून भिबा गङग्‍याम यरूशलेमपट्टि दोःजी। थेग्‍याम यरूशलेम शहररी धोबारी ओस्‍पन किलोमिटर गिक ते भ्रदोमुबा। ");
INSERT INTO taj_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","शहररी धोमाहेन्‍से थेनीगदे ह्राङ चिबा दिमला तलाथोला कोठारी वाङ्‌जी। थेनीगदे पत्रुस, यूहन्‍ना, याकूब, अन्‍द्रियास, फिलिप, थोमा, बारथोलोमाइ, मत्ती, अल्‍फयसला झा याकूब, ह्राङला य्‍हुल्‍सादा माया लबा म्‍हि भिबा सिमोन ओच्‍छे याकूबला झा यहूदा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","कोइ कोइ म्रिङम्‍हेमेगदेदेन येशूला आमा मरियम ओच्‍छे येशूला आलेगदेएनोन थेनीगदेदेन छ्‌याम सेम गिक लसी प्रार्थना लबाला लबान मुबा। ");
INSERT INTO taj_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","तिरेकुनु थेरी प्रभु येशूदा विश्‍वास लबा म्‍हिगदे ओस्‍पन ग्‍यार्जा गिकसे बोगल गिक ह्रुप तबा मुबा। थे धुइरी पत्रुस थेनीगदेला ङाच्‍छापट्टि राप्‍सी चुह्रङ् भिबारी छ्‌याइजी, ");
INSERT INTO taj_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“ज्‍योज्‍यो आले नाना आङागदे, परमेश्‍वरला बचनरी येशूदा चुङ्बा म्‍हिगदेला नेता यहूदाला बारेरी दाऊद ग्‍लेसे ङाच्‍छान परमेश्‍वरला आत्‍माग्‍याम पाङ्बा मुबा। थे बचनरी मुबा ताम पूरा तनोन तोःबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","यहूदाएनोन ङनीगदे न्‍हङला गिक मुबा। ङन्‍से ह्रङ्नोन प्रभुला गे लबाला लागिरी थेदाएनोन धम्‍बा मुबा।” ");
INSERT INTO taj_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ओच्‍छे यहूदासे आज्‍यबा गे लसी स्‍होबा टाङगासे बु गिक ग्‍लुजी। थे बुरी ह्राङनोन सिसी सरी ह्रिल्‍मा थेला फो थिसी ग्रुङ फो थोन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","थे ताम यरूशलेमला जम्‍मान म्‍हिगदेसे था याङ्जी, ओच्‍छे थेनीगदेसे थे बुला मिन ह्राङलान ग्‍योइरी “आखेल्‍दामा” भिसी थान्‍जी। थेला अर्थ चा काला बु भिबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","पत्रुससे दोःसी चुह्रङ् भिसी भिजी, “‘थेला दिम थान्‍थान तगै, थेरी खालै थाचिगै।’ ओच्‍छे ‘थेसे याङ्बा अधिकार स्‍य्‍हान्‍दोसेन जिम्‍मा किन्‍गै’ भिसी व्‍हाइला किताबरी भ्रिबा मुला। ");
INSERT INTO taj_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“थेतबासेलमा यहूदाला ग्‍लारी य्‍हाङदेन छ्‌याम मुबा म्‍हिगदे न्‍हङला गिक धम्‍तोःबा मुला। थे म्‍हि चा य्‍हाङ प्रभु येशूदेन छ्‌याम मुबा धुइरी सदन य्‍हाङदेन छ्‌यामनोन भ्रबा म्‍हि ततोःला। ");
INSERT INTO taj_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","थे म्‍हि यूहन्‍नासे बप्‍तिस्‍मा पिन्‍बा धुइहेन्‍से प्रभु येशू य्‍हाङ मुबाग्‍याम स्‍वर्गरी भोर्बा धुइधोना य्‍हाङदेन छ्‌यामनोन मुबा म्‍हि ततोःला। ओच्‍छे थे म्‍हि य्‍हाङदेन छ्‌याम तसी प्रभु येशू सिबाग्‍याम सोजी भिबा तामला साक्षी ततोःला।” ");
INSERT INTO taj_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","जमाहेन्‍से थेरी मुबा म्‍हिगदेसे म्‍हि न्‍हीला मिन पिन्‍जी। थे न्‍हीला मिन युस्‍तस भिबा योसेफ बारसाबासदेन मतियास मुबा। ");
INSERT INTO taj_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","थेनीगदेसे चुह्रङ् भिसी प्रार्थना लजी, “प्रभु, ह्राङदा जम्‍मान म्‍हिला सेमला ताम था मुला। थेतबासेलमा चु न्‍ही न्‍हङरी ह्राङसे खाल्‍दा धम्‍बा, ङन्‍दा उन्‍सी पिन्‍गो। ");
INSERT INTO taj_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ओच्‍छे थे म्‍हिसे चा यहूदासे लबा मुल चेलाला गे लखम्‍गै। तिग्‍दा भिसम यहूदा चा थे गे ख्‍लासी थे जुन ग्‍लारी नितोःमुबा थेनोन ग्‍लारी निसी सिजी।” ");
INSERT INTO taj_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","जमाहेन्‍से थेनीगदेसे थे म्‍हि न्‍हीला मिनरी चिट्ठा युजी, थे चिट्ठा मतियासला मिनरी परब तजी। जमाकुनुहेन्‍से थेदा च्‍युक गिक मुल चेलागदेदेन छ्‌याम झ्‍याजी। ");
INSERT INTO taj_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","पेन्‍तिकोसला धिनकुनु प्रभु येशूदा विश्‍वास लबा म्‍हिगदे जम्‍मान ग्‍ला गिकरीन पोप तबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","थे धुइरी तिख्‍खुरी स्‍वर्गग्‍याम लाबा खबा ह्रङ्‌बा घ्रेन काइ खजी। थे काइसे थेनीगदे चिबा दिम प्‍लिङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ओच्‍छे मेला ल्‍हाम ह्रङ्‌बा स्‍हेगदे थेनीगदे ह्राङ ह्राङथोरी भो भो तसी चिबा म्राङ्जी। थे मेला ल्‍हाम चा ले ह्रङ्‌बान म्राङ्‌मुबा। ");
INSERT INTO taj_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","जमाहेन्‍से थेनीगदे जम्‍मान परमेश्‍वरला आत्‍मासे प्‍लिङ्‌जी। ओच्‍छे परमेश्‍वरला आत्‍माग्‍याम पाङ्‌खम्‍बा शक्ति याङ्सी थेनीगदेसे पाङ्‌आसेबा अर्गु ग्‍योइगदेरी ताम पाङ्‌बारी छ्‌याइजी ");
INSERT INTO taj_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","थे धुइरी परमेश्‍वरदा तेन्‍बा यहूदीगदे जम्‍बुलिङला जम्‍मान य्‍हुल्‍साग्‍याम यरूशलेमरी खसी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","चुह्रङ्बा काइ थेःमाहेन्‍से थेरी म्‍हिगदे पोप तजी। ओच्‍छे प्रभु येशूदा विश्‍वास लबा म्‍हिगदेसे ह्राङ ह्राङला ग्‍योइरी ताम पाङ्बा म्राङ्सी थेनीगदे उदेक म्‍हन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","जमाहेन्‍से थेनीगदे उदेक तसी चुह्रङ् भिबारी छ्‌याइजी, “तिग चु ताम पाङ्बा जम्‍मान म्‍हिगदे गालीलला आहिन? ");
INSERT INTO taj_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","तर चुगदेसे खाह्रङ् लसी य्‍हाङ ह्राङ ह्राङला ग्‍योइ पाङ्‌खम्‍जी! ");
INSERT INTO taj_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","य्‍हाङ चुरी पार्थीला म्‍हिगदे, मादीला म्‍हिगदे, एलामला म्‍हिगदे, मेसोपोटामीयाला म्‍हिगदे, यहूदियाला म्‍हिगदे, कापाडोकियाला म्‍हिगदे, पोन्‍टसदेन एशियारी चिबा म्‍हिगदे हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ओच्‍छे फ्रिगियाला म्‍हिगदे, पामफिलियाला म्‍हिगदे, मिश्रदेन कुरेनीरी परब तबा लिबियाला ङाम ङामला ग्‍लागदेदेन रोमग्‍याम खबा ");
INSERT INTO taj_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","यहूदीदेन यहूदी धर्म तेन्‍बा अर्गु य्‍हुलला म्‍हिगदे मुला। ओच्‍छे क्रेट य्‍हुल्‍सारी चिबा म्‍हिगदेदेन अरबीला म्‍हिगदेएनोन मुला, थेनीगदेसे मी य्‍हाङला ह्राङ ह्राङलान ग्‍योइरी परमेश्‍वरसे लबा घ्रेन गेला बारेरी पाङ्‌बान चीम। ");
INSERT INTO taj_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","चुह्रङ्बा म्राङ्सी थेनीगदे जम्‍मान उदेक तसी अलमल तसी गिकसे गिकदा “चु तिग तबा?” भिसी ङ्‌योइबा छार्बा लबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","तर स्‍य्‍हान्‍दोगदेसे थेनीगदेदा “चुगदे मी कलिलो निङगुसे ङ्‌य्‍होइजीम” भिसी खिसी लजी। ");
INSERT INTO taj_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","जमाहेन्‍से पत्रुस च्‍युक गिक चेलागदेदेन छ्‌याम राप्‍सी जजाकी ङाच्‍छा निसी घ्रेन काइरी चुह्रङ् भिसी भिजी, “यहूदिया अञ्‍चलग्‍याम ज्‍योङ्‍खबा यहूदी ह्रोगदेदेन यरूशलेमरी स्‍य्‍हूबा जम्‍मान म्‍हिगदे चु तिग तबा हिन्‍ना ङाइ ह्राङनीदा घोना लला। ह्राङनीसे ङाला ताम ज्‍यना लसी ङ्‌यान्‍गो। ");
INSERT INTO taj_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ह्राङनीसे म्‍हन्‍बा ह्रङ् चुगदे ङ्‌य्‍होइबा आरे। दान्‍दे स्‍य्‍होला नौ बजब जे तबा मुला, चु धुइरी खालैसेन निङगु आथुङ्। ");
INSERT INTO taj_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","तर चु ताम तला भिसी योएल अगमवक्तासे पाङ्बा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘परमेश्‍वरसे सुङ्बा मुला, लिच्‍छाला धिनरी ङाइ जम्‍मान म्‍हिगदेथोरी ङाला आत्‍मा पुइखला, जमाहेन्‍से एनीगदेला झा झामेगदेसे अगमवाणी पाङ्ला, ओच्‍छे एनीगदेला ठिटा कोलागदेसे परमेश्‍वरसे उन्‍बा ताम म्राङ्ला, ओच्‍छे एनीगदेला आखे मम म्‍हेमेगदेसे म्‍हाङ म्राङ्ला। ");
INSERT INTO taj_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","थे धिनकुनु नोकरगदेथोरीनोन ङाइ ङाला आत्‍मा पुइखला, ओच्‍छे थेनीगदेसे लिच्‍छा तसेला ताम ङाच्‍छान पाङ्ला। ");
INSERT INTO taj_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ङाइ तोर मुरी उदेकला गेगदेदेन मार जम्‍बुलिङरी उदेकला चिनुगदे उन्‍ना। चु चिनुगदे चा का, मेदेन म्‍युगुला मुस्‍लो हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","परमप्रभु फेप्‍खबा घ्रेन य्‍हाल य्‍हाल्‍बा धिन भन्‍दा ङाच्‍छा धिनी धोपधोप तला ओच्‍छे लनी का ह्रङ्‌बान वाला तला। ");
INSERT INTO taj_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ओच्‍छे जुन म्‍हिसे परमप्रभुदा ङादा ह्रो लउ भिसी भिला, थे म्‍हिसे थार्बा याङ्ला।’ ");
INSERT INTO taj_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“इस्राएलला म्‍हिगदे ङाला ताम ङ्‌यान्‍गो, परमेश्‍वरसे येशूग्‍याम ह्राङनीला गुङरी शक्तिशाली गेगदे लबान उदेकला चिनुगदे उन्‍बा ताम ह्राङनीदा थानोन मुला। थे चिनुगदेग्‍याम परमेश्‍वरसे नासरतला येशूदा ङाइनोन पुइखबा हिन्‍ना भिसी उन्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","परमेश्‍वरसे ङाच्‍छान म्‍हन्‍बा अन्‍छार येशूदा ह्राङनीसे चुङ्‌जी। ओच्‍छे येशूदा ह्राङनीसे पापी म्‍हिगदेला यारी जिम्‍मा पिन्‍सी क्रुसरी टाँगब लसी साइपुङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","तर येशूदा सिबाला शक्तिसे साइबाला साइबान लबारी आखम्‍नी। तिग्‍दा भिसम परमेश्‍वरसे येशूदा सिबाला दुखग्‍याम फेसी सोना लजी। ");
INSERT INTO taj_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","तिग्‍दा भिसम दाऊद ग्‍लेसे येशूला बारेरी चुह्रङ् भिबा मुला, ‘ङाइ प्रभुदा सदन ङाला ङाच्‍छापट्टि म्राङ्‌मुला। थे ङादेन छ्‌यामनोन मुला। थेतबासेलमा ङाइ तिगै तामरी धन्‍दा सुर्दा लआतोः। ");
INSERT INTO taj_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","थेतबासेलमा ङा सेमहेन्‍सेन ताङ्‍बा मुला, ओच्‍छे ताङ्बान ङाइ सेमहेन्‍सेन ङाला सुङग्‍याम प्रभुला जयजयकार लबा मुला। ओच्‍छे ङाला ल्‍हुइ सिसी निसैनोन ङा दोःसी सोला भिसी ङाइ प्रभुथोरी आश लबा मुला। ");
INSERT INTO taj_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","तिग्‍दा भिसम ह्राङसे ङाला प्राणदा सिबागदे निबा ग्‍लारी आख्‍ला। ओच्‍छे ह्राङदा जे तेन्‍बा म्‍हिला ल्‍हुइदा ह्राङसे नइना आल। ");
INSERT INTO taj_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ह्राङसे ङादा ङा दोःसी सोला भिबा ताम उन्‍बा मुला, ओच्‍छे ह्राङ ङादेन छ्‌याम तसी ङादा ल्‍हानान ताङ्ना लला।’ ");
INSERT INTO taj_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“ज्‍योज्‍यो आले नाना आङागदे, ङाइ य्‍हाङला म्‍हेमे दाऊद ग्‍लेला बारेरी ढुक्‍क तसी पाङ्ला। थे सिसी ल्‍हुजी, ओच्‍छे दान्‍देधोना थेला धुर्सा मुनोन मुला। ");
INSERT INTO taj_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","दाऊद ग्‍ले अगमवक्ता तबासे लमा थेला ग्‍लारी ह्राङलान सन्‍तानना गिकदा परमेश्‍वरसे ग्‍ले स्‍होला भिसी परमेश्‍वरसे कबुल लबा ताम थेदा था मुबा। ");
INSERT INTO taj_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","परमेश्‍वरसे लिच्‍छा तिग लला भिसी दाऊदसे ङाच्‍छान म्राङ्‌मुबा। थेतबासेलमा थेसे थार्बा पिन्‍बा ख्रीष्‍ट सिबाग्‍याम सोला भिसी चुह्रङ् भिमुबा, ‘थेदा सिबागदे निबा ग्‍लारी आख्‍लानी ओच्‍छे थेला सिबा ल्‍हुइ नइना आलनी।’ ");
INSERT INTO taj_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“ओच्‍छे चुनोन येशूदा परमेश्‍वरसे सिबाग्‍याम सोना लजी। चु तामला ङनी जम्‍मान साक्षी मुला। ");
INSERT INTO taj_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","परमेश्‍वर आबासे येशूदा घ्रेन मान पिन्‍सी ह्राङला दाहिने छ्‌यापट्टि थान्‍जी, ओच्‍छे कबुल लबा अन्‍छार परमेश्‍वरसे येशूदा ह्राङला आत्‍मा पिन्‍जी। दान्‍दे ह्राङनीसे म्राङ्बा चु तामदेन थेःबा तामगदे थेनोन परमेश्‍वरला आत्‍मा प्रभु येशूसे ङन्‍दा पिन्‍बा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","दाऊद ह्राङनोन स्‍वर्गरी आनिनी, तर थेसे चुह्रङ् भिसी भिबा मुला, ‘परमप्रभुसे ङाला प्रभुदा चुह्रङ् भिसी सुङ्बा मुला, ङाइ एला शत्रुगदेदा भ्रेना आलतेधोना ए ङाला दाहिने यापट्टि चिउ’ ");
INSERT INTO taj_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“थेतबासेलमा इस्राएलला जम्‍मान म्‍हिगदेसे चु ताम पक्‍का हिन्‍ना भिसी था याङ्‌गै, जुन येशूदा ह्राङनीसे क्रुसरी टाँगब लसी साइबा मुबा, थेनोन येशूदा परमेश्‍वरसे प्रभुदेन थार्बा पिन्‍बा ख्रीष्‍ट स्‍होबा मुला।” ");
INSERT INTO taj_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","जमाहेन्‍से पत्रुसला ताम थेःसी थेनीगदेला सेमरी ल्‍हानान दुख तजी, ओच्‍छे पत्रुसदेन स्‍य्‍हान्‍दो मुल चेलागदेदा “दाहेन्‍से ङन्‍से तिग लतोःला ज्‍योज्‍यो आले?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","पत्रुससे थेनीगदेदा चुह्रङ् भिसी जोहाब पिन्‍जी, “दाहेन्‍से एनीगदेसे ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःगो। ओच्‍छे पाप माफ याङ्बाला लागिरी एनीगदेसे येशू ख्रीष्‍टला मिनरी बप्‍तिस्‍मा किन्‍गो। जमाहेन्‍से एनीगदेसे परमेश्‍वरला आत्‍माला मोलम याङ्ला। ");
INSERT INTO taj_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","तिग्‍दा भिसम परमेश्‍वरसे लबा चु कबुल एनीगदेदेन छ्‌याम एनीगदेला कोलागदेला लागिरी हिन्‍ना, ओच्‍छे य्‍हाङला प्रभु परमेश्‍वरसे ङ्‌योइबा थारेङ थारेङ चिबा जम्‍मान म्‍हिगदेला लागिरीनोन हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ओच्‍छे पत्रुससे ल्‍हानान तामग्‍याम होशियार तना लजी। ओच्‍छे थेनीगदेदा अर्ती पिन्‍बान, “दान्‍देला नइबा म्‍हिगदेथोरी खबारी छ्‌याइबा सजायग्‍याम एनीगदे ह्राङनोन जोगब तसी चिउ” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","जमाहेन्‍से ल्‍हानान म्‍हिगदेसे पत्रुससे पाङ्बा तामरी विश्‍वास लसी बप्‍तिस्‍मा किन्‍जी। थेनोन धिनकुनु थेनीगदेला गुङरी विश्‍वास लबा म्‍हिगदे ओस्‍पन हजार सोम ते बढब तजी। ");
INSERT INTO taj_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","जमाहेन्‍से थेनीगदेसे मुल चेलागदेसे लोप्‍बा ताम ङ्‌यान्‍मुबा, संगती लमुबा, प्रभु भोज चमुबा, ओच्‍छे सेम गिक तसी सदन प्रार्थना लमुबा। ");
INSERT INTO taj_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","मुल चेलागदेसे ल्‍हानान उदेकला गेगदेदेन उदेकला चिनुगदे उन्‍जी। थेतबासेलमा जम्‍मान म्‍हिगदेसे परमेश्‍वरदा ल्‍हानान मान लजी। ");
INSERT INTO taj_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","प्रभुदा विश्‍वास लबा जम्‍मान म्‍हिगदे ग्‍ला गिकरीन ह्रुप तमुबा, ओच्‍छे थेनीगदेदेन छ्‌याम मुबा स्‍हेगदे जम्‍मालान हिन्‍ना भिसी चलब लमुबा। ");
INSERT INTO taj_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ओच्‍छे थेनीगदेसे ह्राङदेन छ्‌याम मुबा सम्‍पत्तिदेन मालसामान चूङ्सी जुन जुन म्‍हिदा जुन जुन स्‍हे खाँचो तबा मुला थे स्‍हे जम्‍मादान भो लसी पिन्‍मुबा। ");
INSERT INTO taj_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ओच्‍छे थेनीगदे धिन धिननोन जम्‍मान सेम गिक तसी परमेश्‍वरला मन्‍दिररी ह्रुप तमुबा। ओच्‍छे थेनीगदे दिम दिमरी निसी प्रभु भोज चबादेन ज्‍यबा सेम थोसी ताङ्सी चबा थुङ्बा लमुबा। ");
INSERT INTO taj_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ओच्‍छे सदन परमेश्‍वरला जयजयकार लमुबा। स्‍य्‍हान्‍दो म्‍हिगदेसे थेनीगदेदा ज्‍यबा म्‍हि भिसी भिमुबा। ओच्‍छे थार्बा याङ्बा म्‍हिगदे धिन धिननोन प्रभुसे थेनीगदेला गुङरी बढब लसी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","तिरेकुनु पत्रुसदेन यूहन्‍ना धिनना तीन बजेरी परमेश्‍वरला मन्‍दिररी निबान मुबा। थे धुइ चा प्रार्थना लबा धुइ मुबा। ");
INSERT INTO taj_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","परमेश्‍वरला मन्‍दिर न्‍हङरी वाङ्बा म्‍हिगदेदेन छ्‍याम टाङगा ह्रीगै भिसी न्‍हमाहेन्‍सेन कुज्‍या मुबा म्‍हि गिकदा म्‍हिगदेसे सदन परमेश्‍वरला मन्‍दिररी वाङ्बा म्रापरी भसी थान्‍मुबा। थे म्रापदा जेबा म्राप भिसी भिमुबा। ");
INSERT INTO taj_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","थे कुज्‍या म्‍हिसे पत्रुसदेन यूहन्‍ना परमेश्‍वरला मन्‍दिर न्‍हङरी वाङ्बारी छ्‌याइबा म्राङ्सी टाङगा ह्रीजी। ");
INSERT INTO taj_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","जमाहेन्‍से पत्रुसदेन यूहन्‍नासे थे म्‍हिदा ज्‍यना लसी च्‍याजी, ओच्‍छे पत्रुससे थेदा “ङन्‍दा च्‍यागो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","थेतबासेलमा थेनीगदेसे तिगै पिन्‍ना वा भिसी थे कुज्‍या म्‍हिसे थेनीगदेदा सेम लसी च्‍याजी। ");
INSERT INTO taj_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","जमाहेन्‍से पत्रुससे “ङादेन छ्‌याम म्‍हरदेन म्‍हुइ आरे। तर ङादेन छ्‌याम तिग मुला थे ङाइ एदा पिन्‍ना। नासरतला येशू ख्रीष्‍टला मिनरी ए रेःसी भ्रउ!” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ओच्‍छे थेसे थे कुज्‍या म्‍हिला दाहिने यारी चुङ्सी थीजी, थीमैछ्‌याम थे कुज्‍या म्‍हिला काङदेन काङला जी जीरी भङ वाङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","जमाहेन्‍से थे कुज्‍या म्‍हि डोङ रेःसी क्‍यारमार भ्रबारी छ्‌याइजी। ओच्‍छे भ्रबान छ्‌योङ्‌सी परमेश्‍वरला जयजयकार लबान थेनीगदेदेन छ्‌याम परमेश्‍वरला मन्‍दिररी वाङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ओच्‍छे जम्‍मान म्‍हिगदेसे थेदा भ्रबान लबादेन परमेश्‍वरला जयजयकार लबा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","थेनीगदेसे थे म्‍हिदा परमेश्‍वरला मन्‍दिरला जेबा भिबा म्रापरी ह्रीसी चिबा चुनोन हिन्‍ना भिसी ङोसेजी। ओच्‍छे थे खम्‍बा म्राङ्सी थेनीगदे ल्‍हानान उदेक तजी। ");
INSERT INTO taj_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","थे म्‍हिसे पत्रुसदेन यूहन्‍नादा चुङ्सी भ्रबा म्राङ्सी म्‍हिगदे ल्‍हानान उदेक तसी सोलोमन भिबा दलानरी यार्बान थेनीगदे मुबा ग्‍लारी खजी। ");
INSERT INTO taj_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","चु म्राङ्सी पत्रुससे म्‍हिगदेदा चुह्रङ् भिसी भिजी, “इस्राएलला म्‍हिगदे, ह्राङनी तिग्‍दा चु तामरी उदेक म्‍हन्‍बा? तिग ङन्‍से ह्राङलान शक्तिदेन परमेश्‍वरदा तेन्‍बासे लमा चु म्‍हिदा भ्रना लखम्‍बा ह्रङ् छोर्सी ट्‌वल्‍ल तसी ङन्‍दा च्‍याबा? ");
INSERT INTO taj_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","य्‍हाङला आखे म्‍हेमे अब्राहाम, इसहाकदेन याकूबला परमेश्‍वरसे ह्राङला गे लबा येशूदा घ्रेन मान लजी। तर ह्राङनीसे चा चुङ्सी म्‍हिला यारी जिम्‍मा पिन्‍जी, ओच्‍छे पिलातससे येशूदा पुइबारी छ्‌याइमा ह्राङनीसे थेदा पुइबारी आत भिसी पिलातसला ङाच्‍छापट्टि भिमुबा। ");
INSERT INTO taj_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","तर ह्राङनीसे तिगै दोष आरेबादेन परमेश्‍वरसे म्‍हन्‍बा अन्‍छार भ्रबा म्‍हिदा चा पुइबारी आत, बरु म्‍हि साइबा म्‍हिदा चा पुइगो भिसी पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ओच्‍छे ह्राङनीसे जुनी पिन्‍बादा साइजी। तर थेनोन येशूदा परमेश्‍वरसे सिबाग्‍याम सोना लजी, चु ताम म्राङ्बा चा ङनीन हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","येशूलान मिनना शक्तिग्‍याम चु म्‍हिसे भङ याङ्जी। ह्राङनीसे म्राङ्बादेन ङोसेबा चु म्‍हिसे येशूदा विश्‍वास लबासे लमा ह्राङनी जम्‍मालान ङाच्‍छापट्टि चुदा खम्‍ना लबा मुला। ");
INSERT INTO taj_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“च्‍यागो ज्‍योज्‍यो आलेगदे, ह्राङनीसे लबा चु जम्‍मान गे आसेनान लबा हिन्‍ना भिसी ङादा था मुला। ओच्‍छे ह्राङनीला नेतागदेसेनोन थेह्रङ्नोन लजी। ");
INSERT INTO taj_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","तर थार्बा पिन्‍बा ख्रीष्‍टसे दुख नातोःला भिसी परमेश्‍वरसे ङाच्‍छान जम्‍मान अगमवक्तागदेग्‍याम सुङ्बा अन्‍छार परमेश्‍वरसे चु गे पूरा लजी। ");
INSERT INTO taj_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","थेतबासेलमा परमेश्‍वरसे ह्राङनीला पाप माफ लबाला लागिरी ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःगो। ");
INSERT INTO taj_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","जमाहेन्‍से परमेश्‍वरग्‍याम ह्राङनीसे सुखला धिन याङ्ला, थेह्रङ् लसीन परमेश्‍वरसे ह्राङनीला लागिरी ङाच्‍छान धम्‍बा थार्बा पिन्‍बा ख्रीष्‍ट येशूदा पुइखला। ");
INSERT INTO taj_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ओन्‍माहेन्‍सेन परमेश्‍वरसे ह्राङला अगमवक्तागदेग्‍याम सुङ्बा जम्‍मान स्‍हे दोःसी स्‍होबा धुइ आततेधोना येशू ख्रीष्‍ट स्‍वर्गरी धन्‍छ्‌यातोःबा मुला। ");
INSERT INTO taj_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","मोशासे चुह्रङ् भिसी पाङ्बा मुला, ‘एनीगदेला परमप्रभु परमेश्‍वरसे ङादा पुइखबा ह्रङ् लसी एनीगदेला ज्‍योज्‍यो आलेगदे न्‍हङ‌ग्‍यामसेन एनीगदेला लागिरी अगमवक्ता गिक पुइखला। थेसे पाङ्बा जम्‍मान ताम एनीगदेसे ङ्‌यान्‍तोःबा मुला। ");
INSERT INTO taj_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","थे अगमवक्ताला ताम आङ्‌यान्‍बा खजिबै म्‍हिदा चा परमेश्‍वरला म्‍हिगदेग्‍याम फेसी नाश लला।’ ");
INSERT INTO taj_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“शमूएल अगमवक्ताहेन्‍से लिच्‍छा खबा जम्‍मान अगमवक्तागदेसे चुनोन धिनगदेला बारेरी पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ह्राङनी थेनोन अगमवक्तागदेदेन परमेश्‍वरसे लबा थेनोन कबुलला सन्‍तान हिन्‍ना। थे कबुल ह्राङनीला म्‍हेमे अब्राहामदेन छ्‌याम परमेश्‍वरसे चुह्रङ् भिसी लमुबा, ‘एला सन्‍तानग्‍यामनोन जम्‍बुलिङला जम्‍मान म्‍हिगदेसे मोलम याङ्ला।’ ");
INSERT INTO taj_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ह्राङनीदा नइबा गेग्‍याम फेसी मोलम पिन्‍बाला लागिरी परमेश्‍वरसे ह्राङला झा येशूदा ङाच्‍छा ह्राङनी मुबा ग्‍लारी पुइखबा हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","पत्रुसदेन यूहन्‍ना म्‍हिगदेदेन छ्‌याम ताम लबान लमा परमेश्‍वरला मन्‍दिररी पूजा लबा म्‍हिगदेदेन मन्‍दिर च्‍याबा सिपाहीगदेला कप्‍तान ओच्‍छे सदुकीगदे थेनीगदे मुबा ग्‍लारी खजी। ");
INSERT INTO taj_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","थेनीगदेदा बोमो खजी, तिग्‍दा भिसम पत्रुसदेन यूहन्‍नासे येशू सिबाग्‍याम सोबा मुला, थेह्रङ् लसीन स्‍य्‍हान्‍दो सिबा म्‍हिगदेएनोन थेग्‍याम सोला भिसी म्‍हिगदेदा लोप्‍बान मुबा। ");
INSERT INTO taj_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","थेतबासेलमा थेनीगदेसे पत्रुसदेन यूहन्‍नादा चुङ्‌जी, ओच्‍छे थे धुइरी ङ्‍यसे तसी जिन्‍बासे लमा न्‍हङगरदङधोना झ्‍याल्‍खानरी थान्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","तर पत्रुसदेन यूहन्‍नासे पाङ्बा समाचार ङ्‌यान्‍बा म्‍हिगदे न्‍हङरी ल्‍हानान म्‍हिगदेसे विश्‍वास लजी। विश्‍वास लबा म्‍हिगदे न्‍हङरी ओस्‍पन हजार ङा ते ह्रेम्‍कोलागदे मुबा। ");
INSERT INTO taj_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ओच्‍छे न्‍हङगरदङ यहूदी नेतागदे, यहूदी धर्मगुरुगदेदेन यहूदी गन्‍बागदे यरूशलेमरी पोप तजी। ");
INSERT INTO taj_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","थेरी परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हि हन्‍नासदेन छ्‌याम कैयाफा, यूहन्‍ना, अलेक्‍जेन्‍डर ओच्‍छे मुल म्‍हिला स्‍य्‍हान्‍दो ह्राङला म्‍हिगदेएनोन मुबा। ");
INSERT INTO taj_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","जमाहेन्‍से थेनीगदेसे पत्रुसदेन यूहन्‍नादा ह्राङला गुङरी भसी, “एनीगदेसे चु गे खाह्रङ्बा शक्तिदेन खाल्‍ला मिनग्‍याम लबा हिन्‍ना?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","जमाहेन्‍से परमेश्‍वरला आत्‍मासे प्‍लिङ्‌सी पत्रुससे चुह्रङ् भिसी भिजी, “यहूदी नेतागदेदेन यहूदी गन्‍बागदे, ");
INSERT INTO taj_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","चुदे ह्राङनीसे चु कुज्‍या म्‍हिला लागिरी तिनी ङन्‍से ज्‍यबा गे लबासे लमा चु म्‍हिदा खाह्रङ् लसी खम्‍ना लजी भिसी ङ्‌योइबा छार्बा लबा हिन्‍सम, ");
INSERT INTO taj_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","चु ताम ह्राङनीदेन इस्राएलला जम्‍मान म्‍हिगदेदा था तगै, ह्राङनीसे क्रुसरी टाँगब लसी साइबादेन परमेश्‍वरसे सिबाग्‍याम सोना लबा नासरतला येशू ख्रीष्‍टला मिनरी चु म्‍हि ह्राङनीला ओन्‍छाङरी खम्‍सी राप्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","चुनोन येशूला बारेरी बचनरी चुह्रङ् भिसी भ्रिबा मुला, ‘ह्राङनी डकर्मीगदेसे गे आखेल भिसी भ्‍याङ्‍बा युङबा चुनोन हिन्‍ना, तर दान्‍दे चुनोन युङबा सुर युङबा दोबा मुला।’ ");
INSERT INTO taj_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ओच्‍छे थेसे बाहेक स्‍य्‍हान्‍दो खालैसे य्‍हाङदा थार्बा पिन्‍बारी आखम, तिग्‍दा भिसम जम्‍बुलिङला म्‍हिगदेला गुङरी य्‍हाङदा सोना लबारी स्‍य्‍हान्‍दो खालैला मिन आरे।” ");
INSERT INTO taj_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ओच्‍छे ल्‍हाना पढब आलबादेन तिगै तालिम आकिन्‍बा सोजो म्‍हि पत्रुसदेन यूहन्‍नासे म्‍हिगदेदा लोप्‍बा आँट लबा म्राङ्सी यहूदी नेतागदे, यहूदी धर्मगुरुगदेदेन यहूदी गन्‍बागदे उदेक म्‍हन्‍जी। जमाहेन्‍से थेनीगदेसे पत्रुसदेन यूहन्‍ना येशूदेन छ्‌याम चिबा चीम भिसी था याङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","थे कुज्‍या म्‍हि खम्‍सी पत्रुस, यूहन्‍नादेन छ्‌याम राप्‍सी चिबा म्राङ्बासे लमा थेनीगदेसे तिगै पाङ्‌बारी आखम्‍नी। ");
INSERT INTO taj_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","थेतबासेलमा थेनीगदेसे पत्रुसदेन यूहन्‍नादा अदालतग्‍याम मङग्‍यार निउ भिसी कुल्‍जी। ओच्‍छे थेनीगदे ह्राङ ह्राङ न्‍हङरी चुह्रङ् भिसी सल्‍लाह लबारी छ्‌याइजी, ");
INSERT INTO taj_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“दाहेन्‍से य्‍हाङसे चु न्‍हीदा तिग लबा? तिग्‍दा भिसम चु न्‍हीसे लबा उदेकला गे यरूशलेमरी चिबा जम्‍मान म्‍हिगदेसे था याङ्सी जिन्‍बा मुला। ओच्‍छे चु ताम य्‍हाङसेनोन आहिन भिबारी आखम। ");
INSERT INTO taj_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","तर चु ताम स्‍य्‍हान्‍दो म्‍हिगदेसे थाआयाङ्‌गै भिसी ‘दाहेन्‍से एनीगदेसे चु येशूला बारेरी खालै म्‍हिदा तिगै थापाङ्‍गो’ भिसी य्‍हाङसे चु न्‍हीदा पाङ्तोःला।” ");
INSERT INTO taj_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","जमाहेन्‍से थेनीगदेसे पत्रुसदेन यूहन्‍नादा ङ्‌योइसी, “च्‍यागो, दाहेन्‍से एनीगदेसे येशूला बारेरी खालैदा तिगै थापाङ्‍गो ओच्‍छे तिगै ताम थालोप्‍गो” भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","तर पत्रुसदेन यूहन्‍नासे थेनीगदेदा “परमेश्‍वरला ताम आङ्‌यान्‍ना ह्राङनीला ताम ङ्‌यान्‍बारी परमेश्‍वरला ङाच्‍छा ठीक हिन्‍ना कि आहिन ह्राङनीसेन म्‍हन्‍गो। ");
INSERT INTO taj_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","तिग्‍दा भिसम ङन्‍से म्राङ्बादेन थेःबा ताम आपाङ्ना ङनी चिनोन आखम” भिसी जोहाब पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","थेनीगदेसे पत्रुसदेन यूहन्‍नादा सजाय पिन्‍बारी तिगै ग्‍याम आम्राङ्‌माहेन्‍से पत्रुसदेन यूहन्‍नादा ल्‍हानान बङ्‌सी पुइजी। तिग्‍दा भिसम थेरी तबा उदेकला गेला लागिरी जम्‍मान म्‍हिगदेसे परमेश्‍वरला जयजयकार लबान मुबा। ");
INSERT INTO taj_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","तिग्‍दा भिसम थे उदेकला गेग्‍याम खम्‍बा म्‍हि बोगल न्‍ही दिङ भन्‍दा ल्‍हाना तबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","थेग्‍याम पुइमाहेन्‍से पत्रुसदेन यूहन्‍ना ह्राङला ह्रोगदे मुबा ग्‍लारी खजी। ओच्‍छे परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी गन्‍बागदेसे पाङ्बा जम्‍मान ताम ह्रोगदेदा पाङ्सी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","थेनीगदेसे चु ताम थेःमाहेन्‍से सेम गिक लसी परमेश्‍वरदेन छ्‌याम प्रार्थना लबारी छ्‌याइजी, “प्रभु, मु जम्‍बुलिङदेन समुन्‍द्र ओच्‍छे थेरी मुबा जम्‍मान स्‍हे ह्राङसेन स्‍होबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ओच्‍छे ह्राङला गे लबा ङन्‍ना आखे म्‍हेमे दाऊदला सुङग्‍याम ह्राङला आत्‍मासे चुह्रङ् सुङ्बा मुबा, ‘अर्गु य्‍हुलला म्‍हिगदे तिग्‍दा बोमो खबा, ओच्‍छे म्‍हिगदेसे तिग्‍दा गे आखेल्‍बा तामगदे म्‍हन्‍बा? ");
INSERT INTO taj_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","जम्‍बुलिङला ग्‍लेगदेदेन शासन लबागदे परमप्रभुदेन थेसे धम्‍बा थार्बा पिन्‍बा ख्रीष्‍टला बिरोधरी लडाइ लबाला लागिरी तयार तजी।’ ");
INSERT INTO taj_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“चु सत्‍य ताम हिन्‍ना, तिग्‍दा भिसम ह्राङसे धम्‍बा तिगै दोष आरेबा ह्राङला गे लबा येशूला बिरोधरी हेरोददेन पन्‍तियस पिलातस ओच्‍छे अर्गु य्‍हुलला म्‍हिगदे, इस्राएलीगदेदेन छ्‌याम चुनोन शहररी ह्रुप तबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ङाच्‍छान ह्राङला सेमसे म्‍हन्‍बादेन ह्राङला शक्तिसे तिग लबारी म्‍हाइमुबा थे पूरा तबा मुला। ");
INSERT INTO taj_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","दाहेन्‍से प्रभु, थेनीगदेसे ङन्‍दा लोङ्‌ना लबा ताम ह्राङसे ढन्‍गो, ओच्‍छे ह्राङला गे लबा म्‍हि ङन्‍दा ह्राङला बचन म्‍हिगदेदा थेःना लबारी भङ पिन्‍गो। ");
INSERT INTO taj_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ओच्‍छे ह्राङला शक्तिग्‍याम आखम्‍बा म्‍हिगदेदा खम्‍ना लमा ह्राङला गे लबा तिगै दोष आरेबा येशूला मिनग्‍याम उदेकला चिनुदेन गे तगै।” ");
INSERT INTO taj_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","चुह्रङ् लसी प्रार्थना लसी जिन्‍माहेन्‍से थेनीगदे पोप तबा ग्‍ला लिगलिग तजी, ओच्‍छे थेनीगदे जम्‍मान परमेश्‍वरला आत्‍मासे प्‍लिङ्‌जी। जमाहेन्‍से थेनीगदे आलोङ्ना परमेश्‍वरला बचन थेःना लबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","चु धुइरी चा प्रभु येशूदा विश्‍वास लबा म्‍हिगदे न्‍हङला खालैसेनोन ह्राङला धन सम्‍पत्ति चु ङाला हिन्‍ना भिसी आभिमुबा। थेनीगदे जम्‍मालान सेम गिकनोन तबासे लमा थेनीगदेदेन छ्‌याम मुबा जम्‍मान धन सम्‍पत्ति य्‍हाङला भिसी भिमुबा। ");
INSERT INTO taj_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","थे मुल चेलागदेसे परमेश्‍वरला घ्रेन शक्ति याङ्सी प्रभु येशू सिबाग्‍याम सोबा हिन्‍ना भिबा तामला साक्षी दोसी पाङ्मुबा, ओच्‍छे परमेश्‍वरसे थेनीगदे जम्‍मादान ल्‍हानान मोलम पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","थेनीगदेला न्‍हङरी खालैदान तिगै स्‍हेला खाँचो आतमुबा, तिग्‍दा भिसम वारी बु मुबादेन दिम मुबागदेसे थे चूङ्सी खबा टाङगा भसी, ");
INSERT INTO taj_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","मुल चेलागदेदा पिन्‍मुबा। ओच्‍छे जुन जुन म्‍हिदा खाँचो तमुबा थेनीगदेदा भो लसी पिन्‍मुबा। ");
INSERT INTO taj_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ओच्‍छे साइप्रस य्‍हुल्‍साला लेवी वंशला योसेफ भिबा म्‍हिदा मुल चेलागदेसे बारनाबास भिसी मिन थान्‍मुबा (बारनाबास भिबा चा आँट पिन्‍बाला झा हिन्‍ना), ");
INSERT INTO taj_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","थेसे ह्राङला वारी बु चूङ्‌जी, ओच्‍छे टाङगा भसी मुल चेलागदेदा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","तर थेरी हननिया भिबा म्‍हि गिक मुबा, थेदेन थेला म्रिङ सफीरासे ह्राङदेन छ्‌याम मुबा टोगल गिक वारी चूङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","थेन्‍नी ढिक्‍सी वारी चूङ्सी खबा टाङगाग्‍याम तिगै टाङगा चा ह्राङदेन छ्‌याम थान्‍जी। ओच्‍छे बाँकी टाङगा चा हननियासे मुल चेलागदे मुबा ग्‍लारी भसी जम्‍मान टाङगा चुदेन हिन्‍ना भिसी पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","जमाहेन्‍से पत्रुससे थेदा चुह्रङ् भिसी भिजी, “हननिया ए शैतानना तहरी चिसी तिग्‍दा परमेश्‍वरला आत्‍मादेन छ्‌याम लुसीला ताम पाङ्बा? ओच्‍छे ह्राङला वारी चूङ्सी खबा टाङगा तिग्‍दा छुम्‍सी थान्‍बा? ");
INSERT INTO taj_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","तिग थे वारी आचूङ्‌तेधोना एलान आहिन? ओच्‍छे चूङ्सी खबा टाङगाएनोन एलान मुबा, चु टाङगा एसे जे लइ म्‍हन्‍बा थेनोन लबारी खम्‍सेला मुबा। तर एदा चुह्रङ्बा गे लबा सेम खाह्रङ् लसी खजी? च्‍यागो, एसे म्‍हिगदेदा आहिन, तर परमेश्‍वरदा लुसीला ताम पाङ्बा मुला। ");
INSERT INTO taj_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","चुह्रङ्बा ताम थेःमैछ्‌याम हननिया सरी पाप्‍सी सिजी। जमाहेन्‍से चु ताम थेःबा म्‍हिगदे जम्‍मादान ल्‍हानान लोङ्‌बा खजी। ");
INSERT INTO taj_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","जमाहेन्‍से थेरी मुबा भ्‍योन म्‍हिगदे रेःसी थेला लास क्‍वानसे रिल्‍जी ओच्‍छे धुर्सारी भोर्सी ल्‍हुजी। ");
INSERT INTO taj_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ओस्‍पन घण्‍टा सोम लिच्‍छा चु ताम था आयाङ्‌नान हननियाला म्रिङ न्‍हङरी खजी। ");
INSERT INTO taj_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","जमाहेन्‍से पत्रुससे थेदा “एनीगदेसे वारी ओतेरीन चूङ्बा हिन्‍ना? ङादा पाङ्‍गो” भिसी भिमा, थेसे “लास्‍सो, ओतेरीन हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","जमाहेन्‍से पत्रुससे थेदा “एनीगदे ढिक्‍सी तिग्‍दा प्रभुला आत्‍मासे तिग लबा चीम भिसी च्‍याबारी म्‍हाइबा? च्‍यागो, एला ह्रेम्‍बोदा धुर्सारी ल्‍हुबागदे म्रापरीन मुला, एदाएनोन थेनीगदेसे मङग्‍यार भोर्ला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","थेह्रङ् भिमैछ्‌याम थे पत्रुसला काङ ङामरी पाप्‍सी सिजी। जमाहेन्‍से थेला ह्रेम्‍बोदा ल्‍हुसी खबा भ्‍योनगदे न्‍हङरी खमा थे सिसी जिन्‍मुबा, ओच्‍छे थेनीगदेसे थेदाएनोन भोर्सी थेला ह्रेम्‍बोला ङामरी ल्‍हुजी। ");
INSERT INTO taj_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","जमाहेन्‍से जम्‍मान मण्‍डलीदेन चु ताम थेःबा जम्‍मान म्‍हिगदेदा ल्‍हानान लोङ्‌बा खजी। ");
INSERT INTO taj_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","जमाहेन्‍से मुल चेलागदेग्‍याम म्‍हिगदेला गुङरी उदेकला गेगदे तबारी छ्‌याइजी, ओच्‍छे थेनीगदे जम्‍मान सोलोमनना दलानरी सेम गिकनोन तसी ह्रुप तमुबा। ");
INSERT INTO taj_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","तर प्रभु येशूदा विश्‍वास आलबा स्‍य्‍हान्‍दो म्‍हिगदे न्‍हङला खालैसेनोन प्रभु येशूदा विश्‍वास लबा म्‍हिगदेदेन छ्‌याम ढिक्‍सी चिबारी भङ आलनी, तसैनोन थेनीगदेसे प्रभु येशूदा विश्‍वास लबा म्‍हिगदेला बारेरी ज्‍यबान ताम लमुबा। ");
INSERT INTO taj_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","जमाहेन्‍से प्रभुदा विश्‍वास लबा ह्रेम्‍फेबेदेन म्रिङम्‍हेमेगदेला हुल झन बढब तबान निजी। ");
INSERT INTO taj_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","मुल चेलागदेसे लबा उदेकला गेला बारेरी थेःसी म्‍हिगदेसे आखम्‍बा म्‍हिगदेथोरी पत्रुस खमा थेला क्रिपसे जे भिसै स्‍याप्‍गै भिसी आखम्‍बा म्‍हिगदेदा थेनीगदेला तीबा नान्‍बादेन छ्‌यामनोन भसी ग्‍याम ग्‍यामरी थान्‍मुबा। ");
INSERT INTO taj_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ओच्‍छे यरूशलेमला क्‍यारक्‍युरला शहरग्‍यामसेनोन ल्‍हानान म्‍हिगदेसे आखम्‍बा म्‍हिगदेदेन म्‍हङसे स्‍याप्‍बा म्‍हिगदेदाएनोन थेरी भसी खमुबा। ओच्‍छे थे म्‍हिगदे जम्‍मान खम्‍मुबा। ");
INSERT INTO taj_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हि ओच्‍छे थेदेन छ्‌याम मुबा जम्‍मान सदुकीगदेसे मुल चेलागदेदा डाह लजी। ");
INSERT INTO taj_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ओच्‍छे मुल चेलागदेदा चुङ्सी झ्‍याल्‍खानरी झाङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","तर म्‍हुनङ प्रभुला दूत गिक खसी झ्‍याल्‍खानना म्राप ठोङ्सी थेनीगदेदा मङग्‍यार भसी चुह्रङ् भिसी भिजी, ");
INSERT INTO taj_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“एनीगदे निउ ओच्‍छे परमेश्‍वरला मन्‍दिररी राप्‍सी चु छार जुनीला बारेरी जम्‍मान ताम म्‍हिगदेदा थेःना लउ।” ");
INSERT INTO taj_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","स्‍वर्गदूतसे चुह्रङ् भिमाहेन्‍से थेनीगदे स्‍य्‍होरीन परमेश्‍वरला मन्‍दिररी वाङ्सी म्‍हिगदेदा लोप्‍बारी छ्‌याइजी। थेनोन धुइरी परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हि, थेदेन छ्‌याम मुबा म्‍हिगदे खजी, ओच्‍छे इस्राएली नेतागदे जम्‍मादान सभारी ङ्‌योइजी। जमाहेन्‍से मुल चेलागदेदा झ्‍याल्‍खानग्‍याम भबारी म्‍हिगदे पुइजी। ");
INSERT INTO taj_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","तर परमेश्‍वरला मन्‍दिरला सिपाहीगदे झ्‍याल्‍खानरी धोखसी च्‍यामा थेनीगदेसे थेरी खालैदा आम्राङ्‌नी। थेतबासेलमा थेनीगदे दोःसी निसी चु ताम पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“ङन्‍से झ्‍याल्‍खानरी ताल्‍चा लसी थान्‍बादेन पालेगदे म्रापरी राप्‍सी चिबा म्राङ्जी, तर ङन्‍से म्राप ठोङ्सी च्‍यामा न्‍हङरी खालैदा आस्‍याप्‍नी।” ");
INSERT INTO taj_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","परमेश्‍वरला मन्‍दिरला कप्‍तानदेन परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेसे चु ताम थेःमाहेन्‍से दाहेन्‍से तिग तला भिसी थेनीगदे अलमल तजी। ");
INSERT INTO taj_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","थेनोन धुइरी थेरी खालै म्‍हि गिक खसी, “च्‍यागो, ह्राङनीसे झ्‍याल्‍खानरी झाङ्‌सी थान्‍बा म्‍हिगदे मी परमेश्‍वरला मन्‍दिररी राप्‍सी म्‍हिगदेदा लोप्‍बान मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","जमाहेन्‍से सिपाहीगदेदेन छ्‌याम परमेश्‍वरला मन्‍दिरला कप्‍तान निसी थेनीगदेदा कर आलना भजी। तिग्‍दा भिसम म्‍हिगदेसे थेनीगदेदा युङबासे तोला भिसी थेनीगदे लोङ्‌मुबा। ");
INSERT INTO taj_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","थेनीगदेसे थे मुल चेलागदेदा सभारी भसी ङाच्‍छापट्टि राप्‍पुङ्जी। ओच्‍छे परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिसे मुल चेलागदेदा चुह्रङ् भिसी ङ्‌योइजी, ");
INSERT INTO taj_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“एनीगदेदा ङन्‍से येशूला मिन लसी खालैदा तिगै ताम थालोप्‍गो भिसी कुल्‍मुबा। तर च्‍यागो, एनीगदेसे लोप्‍बा चु ताम यरूशलेम नाङनोन थेःना लसी जिन्‍जीम, ओच्‍छे येशूदा साइबाला दोष एनीगदेसे ङन्‍दा लबारी म्‍हाइबा मुला।” ");
INSERT INTO taj_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","तर पत्रुसदेन स्‍य्‍हान्‍दो मुल चेलागदेसे चुह्रङ् भिसी भिजी, “ङन्‍से म्‍हिगदेसे कुल्‍बा ताम आहिन, बरु परमेश्‍वरसे कुल्‍बा ताम चा ङ्‌यान्‍नोन तोःमुला। ");
INSERT INTO taj_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ह्राङनीसे येशूदा क्रुसरी टाँगब लसी साइबा मुबा, तर य्‍हाङला आखे म्‍हेमेला परमेश्‍वरसे येशूदा सिबाग्‍याम सोना लजी। ");
INSERT INTO taj_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","परमेश्‍वरसे इस्राएलीगदेसे ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःगै भिसी ओच्‍छे थेनीगदेला पापला दोष मेटब लबारी येशूदा शासन लबा म्‍हिदेन थार्बा पिन्‍बा म्‍हि स्‍होसी ह्राङला दाहिने छ्‌यापट्टि थान्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","चु जम्‍मान तामला साक्षी ङनी मुला, थेह्रङ्नोन लसी परमेश्‍वरसे कुल्‍बा ताम ङ्‌यान्‍बा म्‍हिगदेदा पिन्‍बा परमेश्‍वरला आत्‍माएनोन साक्षी मुला।” ");
INSERT INTO taj_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","चु ताम थेःमाहेन्‍से थेनीगदेदा ल्‍हानान बोमो रेःजी, ओच्‍छे मुल चेलागदेदा साइबारी सल्‍लाह लबान मुबा। ");
INSERT INTO taj_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","तर यहूदी धर्मगुरुदेन छ्‌याम जम्‍मासेन मान लबा गमलिएल भिबा फरिसीसे सभाला ङाच्‍छा रेःसी थेनीगदेदा छिन्‍नङ मङग्‍यार निउ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ओच्‍छे थेसे सभाला म्‍हिगदेदा चुह्रङ् भिसी भिजी, “इस्राएलीगदे ह्राङनीसे चु म्‍हिगदेदा जे लबारी छ्‌याइबा मुला, थेरी होशियार तउ। ");
INSERT INTO taj_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","तिग्‍दा भिसम चु भन्‍दा ङाच्‍छाएनोन थूदास भिबा म्‍हिसे ङा घ्रेन म्‍हि हिन्‍ना भिसी भिमुबा। ओच्‍छे थेदेन छ्‌याम ओस्‍पन ग्‍यार्जा ब्‍लि म्‍हिगदे भ्रमुबा, ओच्‍छे थेदा साइजी। जमाहेन्‍से थेदेन छ्‌याम भ्रबा जम्‍मान म्‍हिगदे ससा बङबङ तजी, ओच्‍छे जम्‍मान गे आखेल्‍बा तजी। ");
INSERT INTO taj_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","चु म्‍हि भन्‍दा लिच्‍छाएनोन य्‍हुल्‍साला म्‍हि झ्‍याबा धुइरी गालीलग्‍याम यहूदा भिबा म्‍हि थोन्‍जी, ओच्‍छे ल्‍हानान म्‍हिगदे थेला लिच्‍छा भ्रजी, थेदाएनोन साइजी। जमाहेन्‍से थेदेन छ्‌याम भ्रबा म्‍हिगदे ससा बङबङ तजी। ");
INSERT INTO taj_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","दान्‍देला चु तामला बारेरीनोन ङाइ ह्राङनीदा पाङ्ला, चु म्‍हिगदेदा ह्राङनीसे तिगै आलना ख्‍लागो। तिग्‍दा भिसम चुगदेसे लबा चु गेदेन ताम म्‍हिगदेग्‍याम हिन्‍सम थे ह्रङ्नोन म्‍हासी निला। ");
INSERT INTO taj_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","तर चु गे परमेश्‍वरग्‍याम तबा हिन्‍सम ह्राङनीसे रोकब लबारी आखम। रोकब लबारी म्‍हाइजी भिसम ह्राङनी परमेश्‍वरला बिरोधरी रेःजीम भिबा ताम था तला।” जमाहेन्‍से थेनीगदेसे थेला ताम ङ्‌यान्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ओच्‍छे थेनीगदेसे मुल चेलागदेदा न्‍हङरी ङ्‌योइसी तोबा ग्‍याङ्‍बा लजी। ओच्‍छे “दोःसी खाइमै येशूला मिन किन्‍सी तिगै ताम थापाङ्‍गो” भिसी थेनीगदेदा पुइजी। ");
INSERT INTO taj_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","जमाहेन्‍से येशूला मिनरी बेइज्‍जत नाबाधोनाला तजी भिबा तामरी ताङ्सी ताङ्सी मुल चेलागदे थे सभाग्‍याम थोन्‍सी निजी। ");
INSERT INTO taj_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ओच्‍छे थेनीगदे धिन धिननोन परमेश्‍वरला मन्‍दिरदेन दिम दिमरी निसी येशून थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍ना भिसी थार्बा पिन्‍बा समाचार थेःना लबारी आख्‍लानी। ");
INSERT INTO taj_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","थे धुइरी येशूदा विश्‍वास लबा म्‍हिगदे बढब तबान निमुबा। जमाहेन्‍से हिब्रू ग्‍योइ पाङ्बा यहूदीगदेला बिरोधरी ग्रीक ग्‍योइ पाङ्बा यहूदीगदेसे तामगन लबारी छ्‌याइजी। तिग्‍दा भिसम ग्रीक ग्‍योइ पाङ्बा यहूदीगदेला ह्रेम्‍बो सिबा म्रिङम्‍हेमेगदेसे धिनना धिन तोःतेधोना चबा थुङ्बा आयाङ्‌मुबा। ");
INSERT INTO taj_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","जमाहेन्‍से च्‍युक न्‍ही चेलागदेसे येशूदा विश्‍वास लबागदेदा ङ्‌योइसी चुह्रङ् भिसी भिजी, “परमेश्‍वरला बचन थेःना लबा गे ख्‍लासी चबा थुङ्बा पिन्‍बा गे लबारी ङन्‍दा ठीक आत। ");
INSERT INTO taj_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","थेतबासेलमा आलेगदे, एनीगदे न्‍हङला परमेश्‍वरला आत्‍मादेन बुद्धिसे प्‍लिङ्बा, ओच्‍छे जम्‍मासेन मान लबा गोर निस म्‍हिदा धम्‍गो, ङन्‍से चु गे थेनीगदेदा जिम्‍मा पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","तर ङन्‍से चा प्रार्थना लबादेन परमेश्‍वरला बचन थेःना लबा गे लला।” ");
INSERT INTO taj_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","चु ताम येशूदा विश्‍वास लबा जम्‍मान म्‍हिगदेदा सेम निजी। ओच्‍छे थेरी मुबा जम्‍मादान थे ताम ज्‍यबा छोर्सी थेनीगदेसे पूरा विश्‍वास मुबादेन परमेश्‍वरला आत्‍मासे प्‍लिङ्बा स्‍तिफनस, फिलिप, प्रखरस, निकनोर, तीमोन, पर्मिनासदेन एन्‍टिओखिया भिबा शहरला यहूदी धर्म तेन्‍बा निकोलाउसदा धम्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ओच्‍छे थे म्‍हिगदेदा मुल चेलागदे मुबा ग्‍लारी भजी। जमाहेन्‍से मुल चेलागदेसे थे म्‍हिगदेथोरी ह्राङला या थान्‍सी प्रार्थना लजी। ");
INSERT INTO taj_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","परमेश्‍वरला बचन ल्‍हानान ग्‍लारी थेःबान निजी, ओच्‍छे यरूशलेमरी प्रभु येशूदा विश्‍वास लबा म्‍हिगदे बढब तबान निजी। परमेश्‍वरला मन्‍दिररी पूजा लबा म्‍हिगदे न्‍हङला ल्‍हानान म्‍हिगदेसेनोन प्रभु येशूदा विश्‍वास लजी। ");
INSERT INTO taj_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","जमाहेन्‍से स्‍तिफनस परमेश्‍वरला दयामायादेन शक्तिसे प्‍लिङ्‌सी म्‍हिगदेला गुङरी घ्रेन घ्रेन गेगदे लसी उदेकला चिनुगदे उन्‍बान मुबा। ");
INSERT INTO taj_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","तर दान्‍दे नोकर आहिन्‍बा म्‍हिगदे भिबा ह्रुप तबा दिमग्‍याम कोइ कोइ म्‍हिगदे स्‍तिफनस मुबा ग्‍लारी खसी आतोःबा आतोःबा ताम लबारी छ्‌याइजी। थे म्‍हिगदे चा अलेक्‍जेन्‍ड्रिया, कुरेनी, किलिकिया ओच्‍छे एशियाला म्‍हिगदे मुबा। ");
INSERT INTO taj_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","स्‍तिफनससे परमेश्‍वरला आत्‍मादेन बुद्धिग्‍याम पाङ्बा तामला जोहाब थेनीगदे खालैसेन पिन्‍आखम्‍नी। ");
INSERT INTO taj_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","जमाहेन्‍से थेनीगदेसे न्‍हङ न्‍हङरी म्‍हिगदेदा थीसी घुस पिन्‍बान चुह्रङ् भिसी पाङ्‌पुङ्‌जी, “चुसे परमेश्‍वरदेन मोशाला बिरोध लसी ताम पाङ्बा ङन्‍से थेःजी।” ");
INSERT INTO taj_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","चुह्रङ्बा ताम लसी थेनीगदेसे म्‍हिगदे, यहूदी गन्‍बागदेदेन यहूदी धर्मगुरुगदेदा थीजी। ओच्‍छे थेनीगदेसे स्‍तिफनसदा चुङ्सी यहूदी धर्मला अदालतरी भोर्जी। ");
INSERT INTO taj_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","जमाहेन्‍से थेनीगदेसे स्‍तिफनसला बिरोध लसी लुसीला ताम पाङ्बा म्‍हिगदेदा भजी। थे म्‍हिगदेसे चुह्रङ् भिसी पाङ्जी, “चु म्‍हिसे परमेश्‍वरला मन्‍दिरदेन मोशाला ठिमला बिरोध लसी ताम पाङ्‌बारी आख्‍लानी। ");
INSERT INTO taj_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","तिग्‍दा भिसम चुसे मी ‘नासरतला येशूसे परमेश्‍वरला चु मन्‍दिरदा फुप्‍ला ओच्‍छे मोशासे य्‍हाङदा पिन्‍बा रिमठिमएनोन पोसी पिन्‍ना’ भिबा ङन्‍से थेःजी।” ");
INSERT INTO taj_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","जमाहेन्‍से यहूदी धर्मला अदालतरी चिबा जम्‍मान म्‍हिगदेसे थेदा ज्‍यना लसी च्‍याजी। ओच्‍छे थेला ली स्‍वर्गदूतला ली ह्रङ्‌बान य्‍हाल य्‍हाल्‍बा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","जमाहेन्‍से परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिसे, “चु ताम सत्‍य हिन्‍ना?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","स्‍तिफनससे चुह्रङ् भिसी भिजी, “आबागदेदेन ज्‍योज्‍यो आलेगदे चु ताम ङ्‌यान्‍गो। जम्‍मान भन्‍दा घ्रेन शक्ति मुबा परमेश्‍वरसे य्‍हाङला आखे म्‍हेमे अब्राहाम हारान भिबा नाम्‍सारी फेप्‍बा भन्‍दा ङाच्‍छा मेसोपोटामिया भिबा ग्‍लारी स्‍य्‍हूबा धुइरी थेसे परमेश्‍वरदा ह्राङला ङाच्‍छापट्टि म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","परमेश्‍वरसे थेदा ‘ए ह्राङला य्‍हुल्‍सादेन ह्राङला म्‍हिगदे ख्‍लासी ङाइ उन्‍बा य्‍हुल्‍सारी निउ’ भिसी सुङ्बा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“जमाहेन्‍से थे कल्‍दीगदेला य्‍हुल्‍साग्‍याम थोन्‍सी हारान भिबा नाम्‍सारी खसी चिजी। ओच्‍छे थेला आबा सिमाहेन्‍से परमेश्‍वरसे थेदा थे ग्‍लाग्‍याम दान्‍दे ह्राङनी स्‍य्‍हूबान लबा चु शहररी भजी। ");
INSERT INTO taj_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","परमेश्‍वरसे थेदा थे ग्‍लारी निसी सम्‍पत्ति मी आहिन काङ थान्‍बा ग्‍ला सुत्तै आपिन्‍नी। तर सन्‍तान आरेसैनोन परमेश्‍वरसे थे ग्‍ला थेदेन थेला सन्‍तानदा पिन्‍ना भिसी कबुल लबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ओच्‍छे परमेश्‍वरसे थेदा “एला सन्‍तान अर्गु य्‍हुल्‍सारी निसी चितोःबा मुला, थे ग्‍लाला म्‍हिगदेसे थेनीगदेदा घ्‍यबा स्‍होसी ग्‍यार्जा ब्‍लि दिङधोना थेनीगदेसे नाआखम्‍बा दुख पिन्‍ना’ भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","दोःसी परमेश्‍वरसे चुह्रङ् भिसी सुङ्जी, ‘थेनीगदे जुन य्‍हुलला म्‍हिगदेला घ्‍यबा दोःसी चिला ङाइ थे य्‍हुलला म्‍हिगदेदा सजाय पिन्‍ना। जमाहेन्‍से थेनीगदे थे ग्‍लाग्‍याम थोन्‍सी चुनोन ग्‍लारी खसी ङादा तेन्‍ना।’ ");
INSERT INTO taj_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“परमेश्‍वरसे अब्राहामदेन छ्‌याम खतनाला कबुल लजी। ह्राङला झा इसहाक न्‍हसी भ्रेःरे तमाकुनु अब्राहामसे थेला खतना लजी। इसहाकसेनोन ह्राङला झा याकूबला खतना लजी, थेह्रङ् लसीन याकूबसेनोन ह्राङला च्‍युक न्‍ही कोलागदेला खतना लजी। ओच्‍छे थेला च्‍युक न्‍ही कोलागदे य्‍हाङ जम्‍मालान आखे म्‍हेमे दोजी। ");
INSERT INTO taj_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“थे आखे म्‍हेमेगदे न्‍हङरी योसेफ भिबादा थेला ज्‍योज्‍योगदेसे डाह लसी मिश्र य्‍हुल्‍सारी चूङ्सी पिन्‍जी। तसैनोन थेदेन छ्‌याम परमेश्‍वर मुबा। ");
INSERT INTO taj_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","योसेफदा परमेश्‍वरसे जम्‍मान दुखग्‍याम फेजी। ओच्‍छे परमेश्‍वरसे थेदा ज्‍यबा बुद्धि पिन्‍बासे लमा मिश्र य्‍हुल्‍साला ग्‍ले फारोसे थेदा सेम निसी मान लजी। जमाहेन्‍से थेदा मिश्र य्‍हुल्‍सादेन ग्‍लेखाङला हाकिम स्‍होजी। ");
INSERT INTO taj_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“लिच्‍छा मिश्र य्‍हुल्‍सादेन कनान य्‍हुल्‍सा नाङनोन अनिकाल तसी घ्रेन दुख तजी, थेतबासेलमा य्‍हाङला आखे म्‍हेमेसे चबा स्‍हे तिगैनोन आयाङ्नी। ");
INSERT INTO taj_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","तर याकूबसे मिश्र य्‍हुल्‍सारी चबा स्‍हे मुला भिबा ताम थेःमाहेन्‍से थेला झागदे य्‍हाङला आखे म्‍हेमेदा थेरी पुइजी। थेनीगदे मिश्र य्‍हुल्‍सारी निबा चु ङाच्‍छारेम मुबा। ");
INSERT INTO taj_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ओच्‍छे दोःसी ह्रुप तमा योसेफसे ह्राङला ज्‍योज्‍यो आलेगदेदा ह्राङ खाल हिन्‍ना भिसी ङोसेना लजी। जमाहेन्‍से योसेफला जम्‍मान म्‍हेमेला बारेरी फारो ग्‍लेसे था याङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","जमाहेन्‍से योसेफसे ह्राङला आबा याकूबदेन ह्राङला म्‍हिगदेदा चुरी भसी खउ भिसी पुइजी। याकूबला ह्राङला म्‍हेमेदेन ह्राङला म्‍हिगदे लसी बोगल सोमसे च्‍युक ङा म्‍हि मुबा। ");
INSERT INTO taj_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","जमाहेन्‍से याकूब ह्राङला जम्‍मान म्‍हिगदेदा भोर्सी मिश्र य्‍हुल्‍सारी निजी, ओच्‍छे थे थेरीन सिजी। थेह्रङ् लसीन थेला झागदे य्‍हाङला आखे म्‍हेमेगदेएनोन थेरीन सिजी। ");
INSERT INTO taj_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","लिच्‍छा मिश्र य्‍हुल्‍साग्‍याम थेनीगदेला सिबा ल्‍हुइदा शकेम भिबा ग्‍लारी भोर्सी धुर्सारी थान्‍जी। थे धुर्सा अब्राहामसे हमोर भिबा म्‍हिला झागदेदा टाङगा फासी ग्‍लुबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“परमेश्‍वरसे अब्राहामदेन छ्‌याम लबा कबुल पूरा तबारी छ्‌याइबा धुइ तसी जिन्‍बा मुबा, थे धुइरी मिश्र य्‍हुल्‍सारी य्‍हाङला आखे म्‍हेमेला सन्‍तानगदे ल्‍हानान बढब तबान निजी। ");
INSERT INTO taj_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","जमाहेन्‍से मिश्र य्‍हुल्‍सारी योसेफदा ङोआसेबा स्‍य्‍हान्‍दो ग्‍लेसे शासन लबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","थे ग्‍लेसे य्‍हाङला य्‍हुलला म्‍हिगदेदा धोका पिन्‍सी ल्‍हानान दुख पिन्‍जी। ओच्‍छे थेनीगदेसे य्‍हाङला आखे म्‍हेमेला भर्खर न्‍हबा कोलागदेदा मङग्‍यार थान्‍पुङ्‌जी। चुह्रङ् लसी भर्खर न्‍हबा जम्‍मान कोलागदेदा सिना लजी। ");
INSERT INTO taj_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“थेनोन धुइरी मोशा न्‍हजी। थे परमेश्‍वरला ङाच्‍छापट्टि जेबा म्‍हि मुबा। थेदा ला सोमधोना ह्राङलान आबाला दिमरी सयार लसी थान्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","थेदा मङग्‍यार भोर्सी थान्‍माहेन्‍से फारोला झामेसे थेदा भोर्जी, ओच्‍छे ह्राङलान झा स्‍होसी सयार लसी न्‍हजी। ");
INSERT INTO taj_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","जमाहेन्‍से मोशादा मिश्रीगदेला बुद्धि लोप्‍जी, ओच्‍छे मोशासे पाङ्बा तामदेन गे शक्तिशाली मुबा। ");
INSERT INTO taj_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“बोगल न्‍ही दिङ तमाहेन्‍से मोशासे ह्राङला इस्राएली ज्‍योज्‍यो आलेदेन छ्‌याम ह्रुप तबा सेम लजी। ");
INSERT INTO taj_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","मिश्री गिकसे ह्राङला इस्राएली ज्‍योज्‍यो आले न्‍हङला गिकदा अन्‍याय लबा म्राङ्सी मोशासे थेदा जोगब लसी थे मिश्रीदा साइसी ह्राङला आलेथोरी लबा अत्‍याचारला बदला किन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ङाग्‍यामसेन परमेश्‍वरसे थेनीगदेदा चु दुखग्‍याम फेला भिबा ताम ङाला ज्‍योज्‍यो आलेसे घोला भिसी मोशासे म्‍हन्‍बा मुबा। तर थेनीगदेसे थे ताम आघोनी। ");
INSERT INTO taj_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","न्‍हङगरदङ इस्राएली न्‍ही ह्राङ ह्राङ न्‍हङरी छेबा बङ्बा लसी चिबा धुइरी मोशा खजी, ओच्‍छे थेनीगदेदा ढिक्‍ना लबारी म्‍हाइसी ‘ह्रोगदे, एनीगदे मी ज्‍योज्‍यो आले हिन्‍ना, तिग्‍दा ह्राङ ह्राङ न्‍हङ‍री छेबा?’ ");
INSERT INTO taj_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“तर ह्राङला खिम्‍जेमदा अन्‍याय लबा म्‍हिसे थेदा धुर आङ्‍सी चुह्रङ् भिजी, ‘एदा ङन्‍दा शासन लबा म्‍हिदेन न्‍यायाधीश दोबारी खाल्‍से धम्‍जी? ");
INSERT INTO taj_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","तिग तिल्‍मा एसे थे मिश्रीदा साइबा ह्रङ्नोन ङादाएनोन साइबारी म्‍हाइबा?’ ");
INSERT INTO taj_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","चुह्रङ्बा ताम थेःसी मोशा मिद्यान भिबा य्‍हुल्‍सारी यार्सी विदेशी दोसी चिजी। थेरी थेला झा न्‍ही न्‍हजी। ");
INSERT INTO taj_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“मिद्यान य्‍हुल्‍सारी चिबा बोगल न्‍ही दिङ तमा मोशासे सीनै भिबा गङला ङामरी तोङतोङबा ग्‍लारी लुङ्बा झाङरी मे ल्‍हामरी स्‍वर्गदूत गिक म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","चु म्राङ्सी मोशा उदेक तजी, ओच्‍छे जजाकी ङामरी निसी च्‍यामा परमेश्‍वरसे चुह्रङ् भिसी सुङ्बा थेःजी। ");
INSERT INTO taj_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘ङा एला आखे म्‍हेमे अब्राहाम, इसहाकदेन याकूबला परमेश्‍वर हिन्‍ना।’ चु थेःसी मोशा लोङ्सी फितफित धर्सी थेपट्टि च्‍याबारीन आखम्‍नी। ");
INSERT INTO taj_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“जमाहेन्‍से परमेश्‍वरसे मोशादा चुह्रङ् भिसी सुङ्जी, ‘एला लखम स्‍युगो। तिग्‍दा भिसम ए राप्‍बा ग्‍ला चोखो ग्‍ला हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ङाइ मिश्र य्‍हुल्‍सारी मुबा ङाला म्‍हिगदेदा लबा अन्‍याय म्राङ्सी जिन्‍बा मुला, ओच्‍छे थेनीगदेला दुखला तामएनोन थेःसी जिन्‍बा मुला। थेतबासेलमा थेनीगदेदा थे अन्‍यायदेन दुखग्‍याम फेबाला लागिरी ङा मार फाप्‍बा हिन्‍ना। दाहेन्‍से ङाइ एदा मिश्र य्‍हुल्‍सारी पुइला।’ ");
INSERT INTO taj_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“चुनोन मोशादा थेनीगदेसे ‘एदा खाल्‍से ङन्‍दा शासन लबा म्‍हिदेन न्‍यायाधीश स्‍होजी’ भिसी पत्‍याब आतमुबा, थेनोन मोशादा परमेश्‍वरसे लुङ्बा झाङला मे ल्‍हामरी म्राङ्बा स्‍वर्गदूतग्‍याम शासन लबा म्‍हिदेन इस्राएलीगदेदा दुखग्‍याम फेबा म्‍हि स्‍होसी पुइजी। ");
INSERT INTO taj_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","चुनोन मोशासे मिश्र य्‍हुल्‍सारी, वाला भिबा समुन्‍द्रदेन बोगल न्‍ही दिङधोना तोङतोङबा ग्‍लारी उदेकला गेगदेदेन चिनुगदे उन्‍बान इस्राएलीगदेदा मिश्र य्‍हुल्‍साग्‍याम फेसी भबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“चुनोन मोशासे इस्राएलीगदेदा ‘परमेश्‍वरसे ङादा पुइखबा ह्रङ् लसी एनीगदे न्‍हङ‌ग्‍यामसेन एनीगदेला लागिरी अगमवक्ता गिक पुइखला’ भिसी पाङ्मुबा। ");
INSERT INTO taj_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","चुनोन मोशा तोङतोङबा ग्‍लारी म्‍हिगदेदेन छ्‌याम मुबा धुइरी स्‍वर्गदूतदेन छ्‌याम मुबा, थेनोन स्‍वर्गदूतसे सीनै भिबा गङरी य्‍हाङला आखे म्‍हेमेदेन छ्‌याम ताम पाङ्मुबा, थेसेन य्‍हाङदा पिन्‍बाला लागिरी छोन्‍बो बचन याङ्बा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“थेसे कुल्‍बा ताम आङ्‌यान्‍ना य्‍हाङला आखे म्‍हेमेसे थेदा ख्‍लासी मिश्र य्‍हुल्‍सारीन दोःसी निबा सेम लजी। ");
INSERT INTO taj_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","जमाहेन्‍से थेनीगदेसे हारूनदा ‘य्‍हाङला ङाच्‍छा ङाच्‍छा भ्रबा तिगै लगदे स्‍होसी पिन्‍गो। तिग्‍दा भिसम ङन्‍दा मिश्र य्‍हुल्‍साग्‍याम फेसी भबा चु मोशादा तिग तगेम य्‍हाङदा था आरे’ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","जमाहेन्‍से थेनीगदेसे म्‍हे बहरला मूर्ति गिक स्‍होसी थेरी बलि पिन्‍जी, ओच्‍छे ह्राङसे लबा गेरी थेनीगदे ल्‍हानान ताङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","थेतबासेलमा परमेश्‍वरसे थेनीगदेदा ख्‍लाजी, ओच्‍छे थेनीगदेसे म्‍हन्‍बा ह्रङ्नोन मुरी मुबा सारगदेदा तेन्‍बारी ख्‍लासी पिन्‍जी। चु ताम अगमवक्तागदेसे ङाच्‍छान परमेश्‍वरला बचनरी भ्रिबा मुबा, ‘इस्राएलीगदे तिग एनीगदे बोगल न्‍ही दिङधोना तोङतोङबा ग्‍लारी मुबा धुइरी एनीगदेसे ङादा जन्‍तुला बलिदेन भेटीगदे पिन्‍जी? आपिन्‍नी। ");
INSERT INTO taj_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","तर एनीगदेसे मोलोख भिबा लला पालदेन रेफन भिबा लला सार, ओच्‍छे एनीगदेसे तेन्‍बा लला मूर्तिगदे थीसी भोर्जी। थेतबासेलमा दाहेन्‍से ङाइ एनीगदेदा सजाय पिन्‍बाला लागिरी बेबिलोन भिबा ग्‍लाग्‍याम क्‍याम्‍सङपट्टि पुइला।’ ");
INSERT INTO taj_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“य्‍हाङला आखे म्‍हेमे तोङतोङबा ग्‍लारी मुबा धुइरी थेनीगदेदेन छ्‌याम परमेश्‍वर धन्‍छ्‌याबा पाल मुबा। थे पाल मोशासे म्राङ्बादेन परमेश्‍वरसे कुल्‍बा अन्‍छार स्‍होबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","परमेश्‍वरसे अर्गु य्‍हुलला म्‍हिगदेदा तेःसी थेनीगदेला य्‍हुल्‍सा य्‍हाङला आखे म्‍हेमेदा शासन लपुङ्‌जी। थे पाल यहोशूसे थेनीगदेला य्‍हुल्‍सा ढासी किन्‍बा धुइरी थेनीगदेदेन छ्‌यामनोन भजी। थेह्रङ् लसीन दाऊद ग्‍लेला धुइधोनान थे पाल थेनीगदेदेन छ्‌यामनोन मुबा। ");
INSERT INTO taj_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","दाऊद ग्‍लेसे परमेश्‍वरला दयामाया याङ्सी थेसे याकूबला परमेश्‍वरला लागिरी दिम स्‍होम्‍याङ्‌गै भिसी परमेश्‍वरदेन छ्‌याम बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","तर परमेश्‍वरला लागिरी दिम चा सोलोमन ग्‍लेसे स्‍होजी। ");
INSERT INTO taj_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“तर म्‍हिसे स्‍होबा दिमरी जम्‍मान भन्‍दा घ्रेन परमेश्‍वर धन्‍आछ्‌या, ओच्‍छे अगमवक्तागदेसेनोन चुह्रङ् पाङ्बा मुला। ");
INSERT INTO taj_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","परमेश्‍वरसे चुह्रङ् भिसी सुङ्बा मुला, ‘ङाला ठि स्‍वर्ग हिन्‍ना, ओच्‍छे जम्‍बुलिङ ङाला काङ थान्‍बा ग्‍ला हिन्‍ना। एनीगदेसे ङाला लागिरी खाह्रङ्बा दिम स्‍होजी? ओच्‍छे ङाइ ब्‍लप्‍बा न्‍हबा ग्‍ला खानङ मुला? ");
INSERT INTO taj_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","तिग चु जम्‍मान स्‍हे ङालान यासे स्‍होबा आहिन?’” ");
INSERT INTO taj_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","दोःसी स्‍तिफनससे चुह्रङ् भिसी भिजी, “युङबा ह्रङ्‌बा सेम थोबा म्‍हिगदे, एनीगदेसे ह्राङला सेमरी परमेश्‍वरदा खाइमै आथान्‍नी। ओच्‍छे एनीगदेला आखे म्‍हेमेगदेसे लबा ह्रङ्नोन एनीगदेसेनोन परमेश्‍वरला आत्‍मासे पाङ्‌बादा सदन बिरोध लजी। ");
INSERT INTO taj_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","एनीगदेला आखे म्‍हेमेगदेसे अगमवक्तागदे न्‍हङला खजिबा अगमवक्तादा चा दुख आपिन्‍नी तला? थेनीगदेसे परमेश्‍वरसे म्‍हन्‍बा अन्‍छार भ्रबा म्‍हि फेप्‍खबान मुला भिसी थेःना लबागदे जम्‍मादान साइजी। दान्‍दे ह्राङनी चा परमेश्‍वरसे धम्‍बा म्‍हिदा धोका पिन्‍बादेन साइबा म्‍हि दोजी। ");
INSERT INTO taj_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ह्राङनीसे स्‍वर्गदूतगदेला याग्‍याम पिन्‍बा मोशाला ठिम मी याङ्जी। तर ह्राङनीसे थे ठिम आङ्‌यान्‍नी।” ");
INSERT INTO taj_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","स्‍तिफनसला चुह्रङ्बा ताम थेःसी थेनीगदे बोमोसे म्‍लाङ म्‍लाङ तसी स्‍वा क्रेबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","तर स्‍तिफनस चा परमेश्‍वरला आत्‍मासे प्‍लिङ्‌सी एकोहोरो स्‍वर्गपट्टि च्‍याजी। ओच्‍छे थेसे परमेश्‍वरला घ्रेन य्‍हालरी येशूदा परमेश्‍वरला दाहिनेपट्टि राप्‍सी धन्‍छ्‌याबा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ओच्‍छे थेसे “च्‍यागो, ङाइ स्‍वर्ग ठोङ्‌बादेन परमेश्‍वरसे पुइखबा म्‍हि येशूदा परमेश्‍वरला दाहिनेपट्टि राप्‍सी धन्‍छ्‌याबा म्राङ्बा मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","तर थेनीगदेसे नाब्‍यङ ख्‍यासी घ्रेन काइ लसी क्रिङ्सी तिक्‍खुरीन स्‍तिफनसदा व्‍हाजी। ");
INSERT INTO taj_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","जमाहेन्‍से थेनीगदेसे युङबासे तोसी साइबाला लागिरी स्‍तिफनसदा शहरग्‍याम तेःसी भोर्जी। चुह्रङ् लबा म्राङ्बा म्‍हिगदेसे ह्राङ ह्राङला क्‍वान स्‍युसी शाऊल भिबा भ्‍योन म्‍हिदा जिम्‍मा लसी स्‍तिफनसदा युङबासे तोजी। ");
INSERT INTO taj_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","थेनीगदेसे चुह्रङ् लसी युङबासे तोबा धुइरी स्‍तिफनससे “प्रभु येशू ङाला आत्‍मा ह्राङसे किन्‍गो” भिसी प्रार्थना लजी। ");
INSERT INTO taj_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","जमाहेन्‍से थेसे पुइ जूसी घ्रेन काइ लसी, “प्रभु, चु पापला दोष थेनीगदेदा थाखगै” भिमैछ्‌याम थेला सा निजी। ");
INSERT INTO taj_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","स्‍तिफनसदा साइबारी शाऊलएनोन ढिक्‍बा मुबा। थेनोन धिनकुनुहेन्‍से यरूशलेमरी मुबा मण्‍डलीला बिरोधरी ल्‍हानान दुख तबारी छ्‌याइजी, ओच्‍छे मुल चेलागदे बाहेक थेनीगदे जम्‍मान ससा बङबङ तसी यहूदियादेन सामरियाला ग्‍लारीक्‍यार यार्जी। ");
INSERT INTO taj_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","जमाहेन्‍से परमेश्‍वरदा तेन्‍बा म्‍हिगदेसे स्‍तिफनसला लासदा भोर्सी ल्‍हुजी, थे सिबासे लमा थेनीगदे ल्‍हानान क्राबा क्रिङ्‌बा लजी। ");
INSERT INTO taj_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","तर शाऊलसे चा येशूदा विश्‍वास लबा म्‍हिगदेदा नाश लबारी छ्‌याइजी। ओच्‍छे दिम दिमरी वाङ्सी ह्रेम्‍फेबे, म्रिङम्‍हेमे जम्‍मादान छेङ्बान भोर्सी झ्‍याल्‍खानरी झाङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","जमाहेन्‍से थे ससा बङबङ तसी यार्बा म्‍हिगदेसे ह्राङ धोतेबा ग्‍लारी थार्बा पिन्‍बा समाचार थेःना लजी। ");
INSERT INTO taj_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","फिलिप चा सामरियाला शहर गिकरी निसी थार्बा पिन्‍बा ख्रीष्‍टला बारेरी पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","फिलिपसे पाङ्‌बादेन थेसे लबा उदेकला चिनु म्राङ्सी थेरी मुबा म्‍हिगदेसे थेला तामदा सेम लसी ङ्‌यान्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","तिग्‍दा भिसम थेरी मुबा ल्‍हानान म्‍हिला ल्‍हुइग्‍याम घ्रेन काइ लसी क्रिङ्‌बान म्‍हङ थोन्‍सी निबारी छ्‌याइजी। ओच्‍छे थेरी मुबा काङ या चलब आतबादेन कुज्‍या म्‍हिगदेदाएनोन खम्‍ना लबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","थेतबासेलमा थे शहरला म्‍हिगदे ल्‍हानान ताङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","थे शहररी सिमोन भिबा म्‍हि गिक मुबा। थेसे ङाच्‍छाहेन्‍सेन थे शहररी जादु लसी सामरियाला म्‍हिगदेदा उदेक तना लबा मुबा। ओच्‍छे थेसे ह्राङसे ह्राङदान ङा ह्रङ्‌बा खालै आरे भिसी म्‍हन्‍मुबा। ");
INSERT INTO taj_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","थेदा य्‍हुल्‍साला जजाबा म्‍हिहेन्‍से घ्रेनधोनाला जम्‍मान म्‍हिगदेसे “चु परमेश्‍वरला शक्ति हिन्‍ना” भिसी तेन्‍मुबा, “चुदा जम्‍मान भन्‍दा घ्रेन शक्ति भिमुला।” ");
INSERT INTO taj_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","थे ग्‍लाला म्‍हिगदेसे सिमोनसे भिबा ताम ङ्‌यान्‍सी थेदेन छ्‌याम भ्रमुबा। तिग्‍दा भिसम थेसे ल्‍हानान धुइहेन्‍से जादु लसी म्‍हिगदेदा उदेक तना लबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","तर थेनीगदेसे परमेश्‍वरला य्‍हुल्‍सादेन येशू ख्रीष्‍टला मिनना समाचार थेःना लबा फिलिपला तामरी विश्‍वास लजी। जमाहेन्‍से ह्रेम्‍फेबेदेन म्रिङम्‍हेमे जम्‍मासेन बप्‍तिस्‍मा किन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","सिमोनसेनोन विश्‍वास लसी बप्‍तिस्‍मा किन्‍जी, ओच्‍छे थे फिलिपदेन छ्‌याम भ्रबारी छ्‌याइजी। ओच्‍छे फिलिपसे लबा घ्रेन घ्रेन उदेकला गेदेन चिनुगदे म्राङ्सी सिमोन उदेक तजी। ");
INSERT INTO taj_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","सामरियाला म्‍हिगदेसे परमेश्‍वरला बचनरी विश्‍वास लजी भिबा थेःसी यरूशलेमरी मुबा मुल चेलागदेसे पत्रुसदेन यूहन्‍नादा थेनीगदे मुबा ग्‍लारी पुइजी। ");
INSERT INTO taj_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","थेनीगदे सामरियारी धोखसी थेरी मुबा विश्‍वासीगदेसे परमेश्‍वरला आत्‍मा याङ्‌गै भिसी पत्रुसदेन यूहन्‍नासे प्रार्थना लजी। ");
INSERT INTO taj_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","तिग्‍दा भिसम थे धुइधोना थेनीगदे न्‍हङला खालैथोरीनोन परमेश्‍वरला आत्‍मा फेप्‍खबा आरेमुबा। थेनीगदेला बप्‍तिस्‍मा प्रभु येशूला मिनरी जे तबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","पत्रुसदेन यूहन्‍नासे थेनीगदेथोरी या थान्‍सी प्रार्थना लमाहेन्‍से थेनीगदेसे परमेश्‍वरला आत्‍मा याङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","मुल चेलागदेसे या थान्‍मा परमेश्‍वरला आत्‍मा याङ्बा म्राङ्माहेन्‍से सिमोनसे थेनीगदेदा टाङगा पिन्‍बारी छ्‌याइबान, ");
INSERT INTO taj_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“ङादाएनोन चु शक्ति पिन्‍गो, ओच्‍छे ङाइ जुन म्‍हिथोरी या थान्‍ना थे म्‍हिसे परमेश्‍वरला आत्‍मा याङ्‌गै” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","तर पत्रुससे सिमोनदा चुह्रङ् भिसी भिजी, “एला टाङगा एदेन छ्‌यामनोन नाश तगै। तिग्‍दा भिसम परमेश्‍वरला मोलम टाङगासे ग्‍लुखम्‍ला भिसी एसे म्‍हन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","परमेश्‍वरला ङाच्‍छा एला सेमसे म्‍हन्‍बा ताम ठीक आरेबासे लमा चु गेरी एला तिगै भोदेन अधिकार आरे। ");
INSERT INTO taj_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","थेतबासेलमा एसे म्‍हन्‍बा चु आज्‍यबा नइबा तामदा ख्‍लासी परमेश्‍वरपट्टि दोःसी परमेश्‍वरदेन छ्‌याम प्रार्थना लसम एला सेमरी म्‍हन्‍बा चुह्रङ्बा तामदा परमेश्‍वरसे माफ पिन्‍ना तला। ");
INSERT INTO taj_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","तिग्‍दा भिसम एला सेम डाहसे प्‍लिङ्‌बादेन पापला तहरी मुला भिबा ताम ङादा था मुला।” ");
INSERT INTO taj_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","जमाहेन्‍से सिमोनसे “ह्राङनीसे सुङ्बा ताम ङाथोरी थाखगै भिसी ह्राङनीसेन परमेश्‍वरदेन छ्‌याम ङाला लागिरी प्रार्थना लसी पिन्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ओच्‍छे पत्रुसदेन यूहन्‍नासे येशूसे लबा ह्राङसेन म्राङ्बा गेदेन प्रभुला बचनग्‍याम घोना लमाहेन्‍से सामरीगदेला ल्‍हानान नाम्‍सागदेरी थार्बा पिन्‍बा समाचार थेःना लबान थेनीगदे यरूशलेमरी धोजी। ");
INSERT INTO taj_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","जमाहेन्‍से प्रभुला दूत गिकसे फिलिपदा “ए रेःसी ल्‍होपट्टि यरूशलेमग्‍याम गाजापट्टि निउ। थे ग्‍याम तोङतोङबा मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","थेतबासेलमा फिलिप रेःसी निजी, थेसे नपुंसक गिकदा स्‍याप्‍जी थे नपुंसक इथियोपिया भिबा य्‍हुल्‍साला कन्‍दाकी भिबा ग्‍लेस्‍याला टाङगाला गे लबा मुल म्‍हि मुबा। थे नपुंसक परमेश्‍वरदा तेन्‍बारी यरूशलेमरी निबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","थे नपुंसक ह्राङला दिमपट्टि दोःसी खबान मुबा, ओच्‍छे थे ह्राङला रथरी चिसी यशैया भिबा अगमवक्तासे भ्रिबा किताब पढब लबान मुबा। ");
INSERT INTO taj_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","जमाहेन्‍से परमेश्‍वरला आत्‍मासे फिलिपदा “ए थे रथला ङामरी निसी थेदेन छ्‌याम छ्‌यामनोन निउ” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","फिलिप थे मुबा ग्‍लारी यार्सी निमा थेसे यशैया भिबा अगमवक्तासे भ्रिबा किताब पढब लबान लबा थेःजी। जमाहेन्‍से फिलिपसे थेदा “ह्राङसे पढब लबान लबा चु ताम घोमुला?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","थेसे “खालैसे घोना आलतेधोना ङाइ खाह्रङ् लसी घोसे?” भिसी भिजी। जमाहेन्‍से थेसे फिलिपदा रथरी ङादेन छ्‌यामनोन चिउ भिसी पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","थेसे पढब लबा परमेश्‍वरला बचनरी चुह्रङ् भिसी भ्रिबा मुबा, थे साइबारी भोर्बा ग्‍यु ह्रङ्‌बान मुबा, ओच्‍छे ग्‍यु बोगो ह्राङला क्रा थामा कुटिसी चिमुला, थेह्रङ् लसीन थेसेनोन तिगै आसुङ्ना कुटिसी चिजी। ");
INSERT INTO taj_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","थेदा अत्‍याचार तबा धुइरी थेसे ठीक निसाफ आयाङ्नी। दाहेन्‍से थेला वंशला बारेरी खाल्‍से पाङ्ला? तिग्‍दा भिसम थेला जुनी जम्‍बुलिङग्‍याम भोर्जी। ");
INSERT INTO taj_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","जमाहेन्‍से थे नपुंसकसे फिलिपदा “चु अगमवक्तासे खाल्‍ला बारेरी पाङ्बा हिन्‍ना? थेसे ह्राङलान बारेरी पाङ्बा हिन्‍ना कि स्‍य्‍हान्‍दो खालै म्‍हिला बारेरी पाङ्बा हिन्‍ना? ङादा पाङ्सी पिन्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","जमाहेन्‍से फिलिपसे परमेश्‍वरला थेनोन बचनग्‍याम थेदा येशूला बारेरी थार्बा पिन्‍बा समाचार पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ओच्‍छे थेनीगदे निबान लबा धुइरी क्‍युइ मुबा ग्‍लारी धोजी। जमाहेन्‍से थे नपुंसकसे फिलिपदा “च्‍यागो, चुरी क्‍युइ मुबा चीम, दाहेन्‍से ङादा बप्‍तिस्‍मा किन्‍बारी तिग्‍से रोकब लखम्‍ला?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","फिलिपसे थे नपुंसकदा “ह्राङसे सेमहेन्‍सेन विश्‍वास लसम ह्राङसे किन्‍खम्‍ला” भिसी भिमा थे नपुंसकसे, “येशू ख्रीष्‍टनोन परमेश्‍वरला झा हिन्‍ना भिसी ङाइ विश्‍वास लबा मुला” भिसी जोहाब पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","जमाहेन्‍से थे नपुंसकसे रथ रोकब लपुङ्‌जी ओच्‍छे फिलिपदेन थे क्‍युइरी वाङ्‌जी, जमाहेन्‍से फिलिपसे थेदा बप्‍तिस्‍मा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","थेन्‍नीन क्‍युइग्‍याम पाखारी थोन्‍मैछ्‌याम प्रभुला आत्‍मासे फिलिपदा भोर्जी, जमाहेन्‍से नपुंसकसे फिलिपदा दोःसी आम्राङ्‌नी, ओच्‍छे थे ताङ्बान दिमरी निजी। ");
INSERT INTO taj_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","तर फिलिपसे ह्राङ अश्‍‍दोद भिबा ग्‍लारी धोजीम भिबा था याङ्जी। ओच्‍छे कैसरिया भिबा ग्‍लारी आदोतेधोना जम्‍मान शहरगदेरी थार्बा पिन्‍बा समाचार थेःना लबान निजी। ");
INSERT INTO taj_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","थेनोन धुइरी शाऊलसे अझ धाग उन्‍बान प्रभुला चेलागदेदा साइबारी परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हि मुबा ग्‍लारी निसी, ");
INSERT INTO taj_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","प्रभुदा विश्‍वास लबा ह्रेम्‍फेबेदेन म्रिङम्‍हेमे न्‍हङला जो स्‍याप्‍सै खीसी यरूशलेमरी भम्‍याङ्‌गै भिसी दमस्‍कस भिबा ग्‍लाला यहूदीगदे ह्रुप तबा दिमला नेतागदेला लागिरी चिठी भ्रिसी पिन्‍गो भिसी चिठी ह्रीजी। ");
INSERT INTO taj_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","जमाहेन्‍से शाऊल निबान लमा थे दमस्‍कस भिबा ग्‍लाला ङामरी धोजी। थेरी धोमा स्‍वर्गग्‍याम तिक्‍खुरीन थेला क्‍युर्नोन य्‍हाल तजी। ");
INSERT INTO taj_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","थे सरी ह्रिल्‍जी ओच्‍छे थेसे “शाऊल, शाऊल, एसे ङादा तिग्‍दा ल्‍हानान दुख पिन्‍बा?” भिबा काइ थेःजी। ");
INSERT INTO taj_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ओच्‍छे थेसे “प्रभु ह्राङ खाल हिन्‍ना?” भिसी भिमा चुह्रङ् भिबा काइ थेःजी, “ङा एसे ल्‍हानान दुख पिन्‍बा येशू हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","दाहेन्‍से ए रेःसी शहररी निउ, ओच्‍छे एसे तिग लतोःबा थे ताम एदा उन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","थेदेन छ्‌याम निबा म्‍हिगदेसे थे काइ चा थेःजी, तर क्‍यारमार च्‍यामा खालैदा आम्राङ्‌बासे लमा थेनीगदे थोम तसी चिजी। ");
INSERT INTO taj_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","जमाहेन्‍से शाऊल रेःसी मी ठोङ्सी च्‍यामा थेसे तिगै आम्राङ्‌नी, ओच्‍छे थेदेन छ्‌याम मुबागदेसे थेला यारी चुङ्सी दमस्‍कस भिबा ग्‍लारी भोर्जी। ");
INSERT INTO taj_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","थेसे सोमरेधोना तिगै आम्राङ्‌नी, ओच्‍छे चबा थुङ्‌बाएनोन आलनी। ");
INSERT INTO taj_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","दमस्‍कस भिबा ग्‍लारी हननिया भिबा प्रभुला चेला गिक मुबा। थेदा म्‍हाङरी प्रभुसे “हननिया” भिसी ङ्‌योइमा, थेसे “लास्‍सो प्रभु” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","जमाहेन्‍से प्रभुसे थेदा चुह्रङ् भिसी सुङ्जी, “ए ‘सोजो’ भिबा ग्‍यामपट्टि निउ, थेरी यहूदाला दिमरी शाऊल भिबा टार्सस शहररी चिबा म्‍हिदा म्‍हाइगो, च्‍यागो, थेसे दान्‍दे प्रार्थना लबान मुला। ");
INSERT INTO taj_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","थेसे म्‍हाङरी हननिया भिबा म्‍हि गिक खसी म्राङ्‌खम्‍गै भिसी ह्राङथोरी हननियासे या थान्‍बा म्राङ्बा मुला।” ");
INSERT INTO taj_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","तर हननियासे चुह्रङ् भिसी भिजी, “प्रभु, चु म्‍हिसे मी यरूशलेमरी मुबा ह्राङला म्‍हिगदेदा गाते नइबा गे लसी दुख पिन्‍जी भिबा ताम ङाइ ल्‍हानान म्‍हिगदेग्‍याम थेःबा मुला। ");
INSERT INTO taj_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","चुरीनोन ह्राङला मिन किन्‍बागदेदा खीबारी परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेग्‍याम अधिकार याङ्बा मुला।” ");
INSERT INTO taj_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","तर प्रभुसे थेदा चुह्रङ् भिसी सुङ्जी, “ए निउ, तिग्‍दा भिसम ङाइ थेदा ङादा तेन्‍बारी धम्‍बा मुला। थेसे अर्गु य्‍हुलला म्‍हिगदे, ग्‍लेगदेदेन इस्राएलीगदेदा ङाला मिन थेःना लला। ");
INSERT INTO taj_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","दाहेन्‍से थेसे ङाला लागिरी गाते दुख नातोःला भिबा ताम ङाइ थेदा उन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","जमाहेन्‍से हननिया निसी थे दिमरी वाङ्‌जी। ओच्‍छे शाऊलथोरी ह्राङला या न्‍हीनोन थान्‍सी चुह्रङ् भिसी भिजी, “शाऊल आले, ए ग्‍यामरी खबान लबा धुइरी ए मुबा ग्‍लारी फेप्‍खबा प्रभु येशूसेन ङादा पुइखबा हिन्‍ना। एसे म्राङ्बारी खम्‍गै ओच्‍छे परमेश्‍वरला आत्‍मासे प्‍लिङ्‌गै भिसी ए मुबा ग्‍लारी पुइखबा हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","हननियासे थेह्रङ् भिमैछ्‌याम थेला मीग्‍याम जजाबा पाप्रा ह्रङ्‌बा ताइजी ओच्‍छे थेला मीसे म्राङ्‌खम्‍जी। जमाहेन्‍से रेःसी थेसे बप्‍तिस्‍मा किन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ओच्‍छे थेसे चबा स्‍हे चसी भङ याङ्जी। शाऊल तिगै रेधोना येशूदा विश्‍वास लबागदेदेन छ्‌याम दमस्‍कसरी चिजी। ");
INSERT INTO taj_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ओच्‍छे तुरुन्‍तन शाऊल यहूदीगदे ह्रुप तबा दिमरी निसी, “येशू परमेश्‍वरला झा हिन्‍ना” भिसी पाङ्‌बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","चुह्रङ् भिबा थेःबा म्‍हिगदे जम्‍मान उदेक म्‍हन्‍सी चुह्रङ् भिजी, “येशूला मिन किन्‍बा यरूशलेमरी मुबा म्‍हिगदेदा नाश लबादेन चुरीनोन येशूला मिन किन्‍बा म्‍हिगदेदा खीसी परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदे मुबा ग्‍लारी भोर्बा सेमसे खबा चुनोन म्‍हि आहिन?” ");
INSERT INTO taj_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","तर शाऊलसे थेःना लबा ताम झन झन शक्तिशाली तबान निजी ओच्‍छे येशून थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍ना भिसी दमस्‍कसरी मुबा यहूदीगदेदा अलमल तना लजी। ");
INSERT INTO taj_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ल्‍हानान रे निमाहेन्‍से शाऊलदा साइबारी यहूदीगदे ढिक्‍सी सल्‍लाह लजी। ");
INSERT INTO taj_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","तर थेनीगदेसे ह्राङदा साइबारी म्‍हाइबा ताम शाऊलसे था याङ्जी। शाऊलदा साइबारी थेनीगदेसे दमस्‍कस शहरला म्राप म्रापरी धिन म्‍हुननोन ख्रुङ्‌सी चिमुबा। ");
INSERT INTO taj_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","तर शाऊलदा स्‍य्‍हान्‍दो विश्‍वासीगदेसे म्‍हुनङनोन छाङरी युसी थे शहरला पर्खालग्‍याम मार पुइजी। ");
INSERT INTO taj_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","शाऊल यरूशलेमरी खमाहेन्‍से थेरी मुबा येशूला चेलागदेदेन छ्‌याम ढिक्‍बारी म्‍हाइजी। तर थेनीगदेसे थे येशूला चेला हिन्‍ना भिसी विश्‍वास आतबासे लमा शाऊल म्राङ्सी जम्‍मान लोङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","तर बारनाबाससे मुल चेलागदे मुबा ग्‍लारी शाऊलदा ह्राङदेन छ्‌यामनोन भोर्जी। ओच्‍छे शाऊलसे प्रभुदा ग्‍यामरी म्राङ्बादेन प्रभुसे सुङ्बा तामला बारेरी पाङ्जी। थेह्रङ् लसीन दमस्‍कसरी आलोङ्नान येशूला बारेरी थेःना लजी भिबा ताम बारनाबाससे थेनीगदेदा पाङ्सी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","जमाहेन्‍से शाऊल यरूशलेमला जम्‍मान ग्‍लारी थेनीगदेदेन छ्‌याम छ्‌याम भ्रजी, ओच्‍छे शाऊल आलोङ्नान प्रभुला बारेरी थेःना लबान भ्रजी। ");
INSERT INTO taj_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ओच्‍छे शाऊलदेन ग्रीक ग्‍योइ पाङ्बा यहूदीगदे ह्राङ ह्राङ न्‍हङरी आढिक्‍बा ताम लमुबा, तर थे ग्रीक ग्‍योइ पाङ्बा यहूदीगदेसे चा शाऊलदा साइबारी म्‍हाइबान मुबा। ");
INSERT INTO taj_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","चु ताम था याङ्सी प्रभुदा विश्‍वास लबागदेसे शाऊलदा कैसरिया भिबा शहररी भोर्जी, ओच्‍छे थेग्‍याम टार्सस भिबा शहरपट्टि पुइजी। ");
INSERT INTO taj_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","जमाहेन्‍से यहूदियादेन गालील ओच्‍छे सामरिया भिबा ग्‍लारी मुबा जम्‍मान मण्‍डलीदा शान्‍ति तजी। ओच्‍छे प्रभुला चेलागदेसे परमेश्‍वरला आत्‍माग्‍याम आँट याङ्जी ओच्‍छे मण्‍डलीएनोन बढब तजी। चेलागदे परमेश्‍वरसे कुल्‍बा अन्‍छार भ्रमुबा ओच्‍छे प्रभुदा विश्‍वास लबा म्‍हिगदेएनोन ल्‍हानान तबान निजी। ");
INSERT INTO taj_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","पत्रुस क्‍यारमारला नाम्‍सागदेरी कोर्बान निबा धुइरी लुड्डा भिबा ग्‍लारी मुबा परमेश्‍वरला म्‍हिगदे मुबा ग्‍लारी धोखजी। ");
INSERT INTO taj_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","पत्रुससे थेरी एनियास भिबा कुज्‍या म्‍हि गिक म्‍हेर्सी चिबा स्‍याप्‍जी, थे म्‍हि कुज्‍या तबा भ्रेः दिङ तबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","जमाहेन्‍से पत्रुससे थे कुज्‍या म्‍हिदा “एनियास, एदा येशू ख्रीष्‍टसे खम्‍ना लला। थेतबासेलमा ए रेःसी ह्राङला तीबा नान्‍बा दुइगो” भिसी भिमैछ्‌याम थे कुज्‍या म्‍हि डोङ रेःजी। ");
INSERT INTO taj_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","थे कुज्‍या म्‍हि खम्‍बा म्राङ्सी लुड्डादेन शारोन भिबा ग्‍लारी चिबा जम्‍मान म्‍हिगदेसे प्रभुदा विश्‍वास लजी। ");
INSERT INTO taj_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","योप्‍पा भिबा शहररी तबीता भिबा चेला गिक मुबा, थेदा ग्रीक ग्‍योइरी डोरकास भिमुबा। थेसे सदन प्राङबोगदेदा ह्रो लबादेन ज्‍यबा गे लमुबा। ");
INSERT INTO taj_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","पत्रुस लुड्डा भिबा ग्‍लारी मुबा धुइरी थे तबीता आखम्‍ना सिजी, ओच्‍छे म्‍हिगदेसे थेला लास ख्रुसी तलाथोला कोठा गिकरी भोर्सी थान्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","लुड्डा भिबा ग्‍ला योप्‍पा शहरला ङामरीन तबासे लमा चेलागदेसे पत्रुस थेरी मुला भिबा ताम थेःसी, “ङनी मुबा ग्‍लारी योना फेप्‍खउ भिउ” भिसी म्‍हि न्‍हीदा थे मुबा ग्‍लारी पुइजी। ");
INSERT INTO taj_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","जमाहेन्‍से पत्रुस थेनीगदेदेन छ्‌याम निजी। थेरी धोखमाहेन्‍से थेनीगदेसे पत्रुसदा तलाथोला कोठारी भोर्जी। जमाहेन्‍से थेरी मुबा ह्रेम्‍बो सिबा म्रिङम्‍हेमेगदे पत्रुसला ङामरी राप्‍सी क्राबान मुबा, ओच्‍छे डोरकास भिबा तबीतासे थेनीगदेदेन छ्‌याम मुबा धुइरी राबा क्‍वान उन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","जमाहेन्‍से पत्रुससे थेनीगदे जम्‍मादान मङग्‍यार पुइसी पुइ जूसी प्रार्थना लजी, ओच्‍छे थे लासपट्टि च्‍यासी, “तबीता रेःगो” भिसी भिमा, तबीतासे मी ठोङ्‌जी ओच्‍छे थेसे पत्रुसदा म्राङ्सी रेःसी चिजी। ");
INSERT INTO taj_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","पत्रुससे तबीताला यारी चुङ्सी थीजी ओच्‍छे परमेश्‍वरला म्‍हिगदेदेन ह्रेम्‍बो सिबा म्रिङम्‍हेमेगदेदा ङ्‌योइसी तबीता सोजी भिसी उन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","जमाहेन्‍से चु ताम योप्‍पा शहर नाङनोन थेःजी, ओच्‍छे ल्‍हानान म्‍हिगदेसे प्रभुदा विश्‍वास लजी। ");
INSERT INTO taj_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ओच्‍छे पत्रुस ल्‍हानान धिनधोना ढिला गे लबा सिमोन भिबा म्‍हिदेन छ्‌याम योप्‍पा शहररीन चिजी। ");
INSERT INTO taj_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","कैसरिया भिबा ग्‍लारी कर्नेलियस भिबा म्‍हि गिक मुबा, थे म्‍हि रोमी य्‍हुलला इटालिया भिबा सिपाहीला कप्‍तान मुबा। ");
INSERT INTO taj_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","थेसे परमेश्‍वरदा तेन्‍मुबा, ओच्‍छे थेदेन थेला दिमला जम्‍मान म्‍हिगदेसे परमेश्‍वरसे कुल्‍बा ताम ङ्‌यान्‍मुबा। थेसे आरेबागदेदा ज्‍यबा सेमसे पिन्‍मुबा। ओच्‍छे परमेश्‍वरदेन छ्‌याम सदन प्रार्थना लमुबा। ");
INSERT INTO taj_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","तिरेकुनु थेसे धिनना तीन बजेरीक्‍यार प्रार्थना लबा धुइरी परमेश्‍वरला स्‍वर्गदूत गिक ह्राङ मुबा ग्‍लारी खबा म्राङ्जी। ओच्‍छे स्‍वर्गदूतसे थेदा “कर्नेलियस!” भिसी ङ्‌योइबा थेःजी। ");
INSERT INTO taj_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","जमाहेन्‍से कर्नेलियस लोङ्सी स्‍वर्गदूतदा ज्‍यना लसी च्‍यासी, “प्रभु, सुङ्‍गो” भिसी भिमा, स्‍वर्गदूतसे थेदा चुह्रङ् भिसी भिजी, “एसे लबा प्रार्थनादेन एसे प्राङबोगदेदा दया लसी चबा थुङ्बारी पिन्‍बा जम्‍मान गे परमेश्‍वरदा फुल्‍बा भेटी ह्रङ्‌बान दोबा मुला। ");
INSERT INTO taj_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","दाहेन्‍से एसे योप्‍पा भिबा शहररी म्‍हिगदे पुइसी पत्रुस भिबा सिमोनदा ङ्‌योइगो। ");
INSERT INTO taj_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","थे ढिला गे लबा सिमोन भिबा म्‍हिदेन छ्‌याम चिबा मुला, थे सिमोनना दिम समुन्‍द्रला कुनीरी मुला।” ");
INSERT INTO taj_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ओते पाङ्माहेन्‍से स्‍वर्गदूत कर्नेलियस मुबाग्‍याम फेसी निजी। जमाहेन्‍से कर्नेलियससे ह्राङला नोकरगदे न्‍हङला नोकर न्‍हीदेन सदन ह्राङदा क्‍योङ्बा ओच्‍छे परमेश्‍वरदा तेन्‍बा सिपाही गिकदा ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ओच्‍छे थेनीगदेदा चु जम्‍मान ताम पाङ्सी योप्‍पा भिबा शहररी पुइजी। ");
INSERT INTO taj_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","न्‍हङगरदङ थेनीगदे निबान लबा धुइरी धिनना बाह्र बजेरीक्‍यार योप्‍पा शहरला ङामरी धोखमा पत्रुस चा प्रार्थना लबारी दिमला कौसीरी निजी। ");
INSERT INTO taj_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","थे धुइरी पत्रुसदा फोख्रेन्‍जी, ओच्‍छे थेसे चबा स्‍हे चबारी म्‍हाइजी। तर स्‍य्‍हान्‍दोगदेसे चबा स्‍हे स्‍होबान मुबा, थेनोन धुइरी थे एकोहोरो तजी। ");
INSERT INTO taj_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","जमाहेन्‍से थेसे स्‍वर्ग ठोङ्‌बा म्राङ्जी ओच्‍छे कुनी ब्‍लिरीन खीबा तन्‍ना ह्रङ्‌बा स्‍वर्गग्‍याम जम्‍बुलिङपट्टि मार खबान लबा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","थे तन्‍नारी जम्‍बुलिङला काङ ब्‍लि मुबा ल्‍हानान थरीला जन्‍तुदेन सरी भ्रबा जन्‍तु ओच्‍छे चरागदे मुबा। ");
INSERT INTO taj_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","जमाहेन्‍से पत्रुससे चुह्रङ् भिबा काइ थेःजी, “पत्रुस, ए रेःसी चुदा साइसी चउ।” ");
INSERT INTO taj_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","तर पत्रुससे “आहिन प्रभु, ङाइ चुह्रङ्बा चबारी आतबा नइबा स्‍हे खाइमै चबा आरे” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","दोःसीनोन पत्रुससे “परमेश्‍वरसे चोखो स्‍होसी जिन्‍बा स्‍हेदा एसे नइबा स्‍हे थाम्‍हन्‍गो” भिबा काइ थेःजी। ");
INSERT INTO taj_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","सोमरेमधोना चुह्रङ्बा काइ थेःजी, ओच्‍छे थे तन्‍ना तुरुन्‍तन स्‍वर्गपट्टि भोर्जी। ");
INSERT INTO taj_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ह्राङसे म्राङ्बा तामला अर्थ तिग मुला तला भिसी पत्रुस अलमल तसी चिमुबा। थेनोन धुइरी कर्नेलियससे पुइबा म्‍हिगदे सिमोनना दिम म्‍हाइबान निमा दिम स्‍याप्‍सी म्रापरी राप्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ओच्‍छे घ्रेन काइ लसी, “पत्रुस भिबा सिमोन चुरी धन्‍छ्‌यामुला?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","थे धुइरी पत्रुस ह्राङसे म्राङ्बा तामला बारेरी म्‍हन्‍सी चिबा मुबा। थेनोन धुइरी परमेश्‍वरला आत्‍मासे पत्रुसदा चुह्रङ् भिसी सुङ्जी, “च्‍यागो, एदा म्‍हि सोमसे म्‍हाइबान मुला। ");
INSERT INTO taj_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","थेतबासेलमा ए रेःसी धिरी निउ, ओच्‍छे शङ्का आलना थेनीगदेदेन छ्‌याम निउ, तिग्‍दा भिसम थेनीगदेदा ङाइनोन पुइखबा हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","जमाहेन्‍से पत्रुस थेनीगदे मुबा ग्‍लारी निसी, “च्‍यागो, एनीगदेसे म्‍हाइबा म्‍हि ङानोन हिन्‍ना। एनीगदे चुरी तिग्‍दा खबा?” भिसी ङ्‌योइमा, ");
INSERT INTO taj_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","थेनीगदेसे पत्रुसदा “कर्नेलियस भिबा कप्‍तानसे ङन्‍दा पुइखबा हिन्‍ना। थे ज्‍यबा म्‍हिदेन परमेश्‍वरदा तेन्‍बा म्‍हि हिन्‍ना, ओच्‍छे यहूदीगदे जम्‍मासेन थेदा मान लमुला। थेला दिमरी ह्राङदा ङ्‌योइसी ह्राङसे सुङ्बा ताम ङ्‌यान्‍गो भिसी परमेश्‍वरला स्‍वर्गदूतगदे गिकसे कुल्‍बा मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","थेतबासेलमा थेनीगदेदा न्‍हङरी ङ्‌योइसी पत्रुससे थेनीगदेदा क्‍योङ्‌जी। न्‍हङगरदङ पत्रुस थेनीगदेदेन छ्‌याम निजी, ओच्‍छे येशूदा विश्‍वास लबा योप्‍पा शहररी मुबा कोइ कोइ म्‍हिगदेएनोन थेदेन छ्‌याम निजी। ");
INSERT INTO taj_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","रेनीदङ थेनीगदे कैसरिया भिबा ग्‍लारी धोजी। कर्नेलियससे चा ह्राङला म्‍हिगदेदेन ह्राङदेन छ्‌याम ढिक्‍बा ह्रोगदेदा ङ्‌योइसी थेनीगदेला ग्‍याम च्‍यासी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","पत्रुस न्‍हङरी खमाहेन्‍से कर्नेलियस थेदेन छ्‌याम ह्रुप तजी, ओच्‍छे थेदा फ्‍या लजी। ");
INSERT INTO taj_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","तर पत्रुससे थेदा थीसी, “रेःगो, ङाएनोन म्‍हि जे हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ओच्‍छे थेदेन छ्‌याम ताम पाङ्‌बान दिम न्‍हङरी वाङ्‌जी, थेरी पत्रुससे ल्‍हानान म्‍हिगदे ह्रुप तसी चिबा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","पत्रुससे थेनीगदेदा चुह्रङ् भिसी भिजी, “ङनी यहूदीगदेला ठिमसे अर्गु य्‍हुलला म्‍हिगदेदेन छ्‌याम ह्रुप तबारी आपिन्‍मुला भिबा ताम ह्राङनीदा थानोन मुला, तर परमेश्‍वरसे ङादा खजिबै म्‍हिदा नइबादेन गे आखेल्‍बा थाम्‍हन्‍गो भिसी उन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","थेतबासेलमा ह्राङनीसे ङ्‍योइमैछ्‍याम तिगै आम्‍हन्‍ना ङा ह्राङनी मुबा ग्‍लारी खबा हिन्‍ना। ह्राङनीसे ङादा चुरी तिग्‍दा ङ्‌योइबा हिन्‍ना ङादा सुङ्‍गो।” ");
INSERT INTO taj_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","जमाहेन्‍से कर्नेलियससे चुह्रङ् भिसी भिजी, “ब्‍लिरे ङाच्‍छा ओस्‍पन चुनोन धुइरी ङा दिमरी तीन बजेला प्रार्थना लबान मुबा थे धुइरी य्‍हाल य्‍हाल्‍बा क्‍वान क्‍वान्‍बा म्‍हि गिक ङाला ङाच्‍छापट्टि राप्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ओच्‍छे थे म्‍हिसे चुह्रङ् भिसी भिजी, ‘कर्नेलियस, एसे लबा प्रार्थना परमेश्‍वरसे थेःबा मुला, थेह्रङ् लसीन प्राङबोगदेदा दया लसी चबा थुङ्बा पिन्‍बा गे परमेश्‍वरसे ढन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","थेतबासेलमा एसे योप्‍पा शहररी म्‍हि पुइसी पत्रुस भिबा सिमोनदा ङ्‌योइगो। थे समुन्‍द्रला कुनीरी ढिला गे लबा सिमोनना दिमरी चिमुला।’ ");
INSERT INTO taj_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","थेतबासेलमा ङाइ तुरुन्‍तन ह्राङ मुबा ग्‍लारी म्‍हि पुइखबा हिन्‍ना, दान्‍दे ह्राङ ङन्‍ना लागिरी ल्‍हानान दुख लसी चुरी फेप्‍खजी। दाहेन्‍से प्रभुसे ह्राङदा कुल्‍बा जम्‍मान ताम ह्राङग्‍याम ङ्‌यान्‍बारी ङनी जम्‍मान परमेश्‍वरला ङाच्‍छापट्टि ह्रुप तबा मुला।” ");
INSERT INTO taj_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","जमाहेन्‍से पत्रुससे चुह्रङ् भिसी पाङ्‌बारी छ्‌याइजी, “चु ताम सत्‍य हिन्‍ना, परमेश्‍वरसे खालैला ली आच्‍याना जम्‍मादान गिकनोन व्‍यवहार लमुला भिबा ताम ङाइ म्राङ्बा मुला। ");
INSERT INTO taj_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","तर य्‍हुल य्‍हुलला म्‍हिगदे न्‍हङला जुन म्‍हिसे परमेश्‍वरदा मान लसी थेसे म्‍हन्‍बा अन्‍छारला गे लला थे म्‍हि परमेश्‍वरदा सेम निबा म्‍हि तला। ");
INSERT INTO taj_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ओच्‍छे येशू ख्रीष्‍टग्‍याम इस्राएलीगदेला गुङरी परमेश्‍वरसे पुइखबा शान्‍तिला समाचार ह्राङनीदा थानोन मुला। थेनोन येशू जम्‍मालान प्रभु हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","यूहन्‍नासे बप्‍तिस्‍माला बारेरी थेःना लमाहेन्‍से गालीलहेन्‍से यहूदियाला जम्‍मान ग्‍लारी तबा ताम ह्राङनीदा थानोन मुला। ");
INSERT INTO taj_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","खाह्रङ् लसी परमेश्‍वरसे नासरतला येशूथोरी ह्राङला आत्‍मादेन शक्ति पुइखजी। जमाहेन्‍से थेसे ज्‍यबा गेदेन शैतानसे दुख पिन्‍बा जम्‍मान म्‍हिगदेदा खम्‍ना लबान भ्रजी, तिग्‍दा भिसम थेदेन छ्‌याम परमेश्‍वर मुबा। ");
INSERT INTO taj_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“यहूदीगदेला य्‍हुल्‍सादेन यरूशलेमरी येशूसे लबा जम्‍मान गे ङन्‍से म्राङ्बा मुला। थेदा म्‍हिगदेसे क्रुसरी टाँगब लसी साइजी। ");
INSERT INTO taj_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","तर सोमरेमाकुनु परमेश्‍वरसे थेदा सोना लजी। थेतबासेलमा ङन्‍से दोःसी येशूदा म्राङ्‌म्‍याङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","थेदा जम्‍मान म्‍हिसे मी म्राङ्‌आम्‍याङ्‌नी, तर थे सिबाग्‍याम सोमाहेन्‍से थेदेन छ्‌यामनोन चबा थुङ्बा लसी भ्रबा म्‍हि ङन्‍से जे म्राङ्जी। चुनोन ताम उन्‍बाला लागिरी ङाच्‍छान परमेश्‍वरसे ङन्‍दा धम्‍बा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ओच्‍छे थार्बा पिन्‍बा समाचार थेःना लबारीदेन येशूदा सिबादेन सोबा म्‍हिगदेला निसाफ लबाला लागिरी परमेश्‍वरसे धम्‍बा हिन्‍ना भिसी पाङ्‍गो भिसी येशूसे ङन्‍दा कुल्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ओच्‍छे येशूथोरी विश्‍वास लबागदे जम्‍मालान पाप येशूला मिनरी माफ याङ्ला भिसी जम्‍मान अगमवक्तागदेसेनोन पाङ्बा मुला।” ");
INSERT INTO taj_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","पत्रुससे चु ताम पाङ्ना पाङ्नान पत्रुसला ताम थेःबा जम्‍मान म्‍हिथोरी परमेश्‍वरला आत्‍मा फेप्‍खजी। ");
INSERT INTO taj_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","अर्गु य्‍हुलला म्‍हिगदेथोरीएनोन परमेश्‍वरला आत्‍मा फेप्‍खबा म्राङ्सी पत्रुसदेन छ्‌याम खबा यहूदी विश्‍वासीगदे उदेक तजी। ");
INSERT INTO taj_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","तिग्‍दा भिसम थेनीगदेसे आसेबा ग्‍योइ पाङ्सी परमेश्‍वरला जयजयकार लबान लबा यहूदी विश्‍वासीगदेसे थेःजी। जमाहेन्‍से पत्रुससे चुह्रङ् भिसी पाङ्जी, ");
INSERT INTO taj_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“य्‍हाङसे ह्रङ्नोन परमेश्‍वरला आत्‍मा याङ्बा चु म्‍हिगदेदा दाहेन्‍से क्‍युइला बप्‍तिस्‍मा किन्‍बारी खाल्‍से रोकब लबा?” ");
INSERT INTO taj_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","थेतबासेलमा पत्रुससे थेनीगदेदा येशू ख्रीष्‍टला मिनरी बप्‍तिस्‍मा किन्‍गो भिसी कुल्‍जी। जमाहेन्‍से थेनीगदेसे पत्रुसदा तिगै धिन ङन्‍देन छ्‌याम स्‍य्‍हूगो भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","यहूदियारी मुबा मुल चेलादेन स्‍य्‍हान्‍दो आलेगदेसे अर्गु य्‍हुलला म्‍हिगदेसेनोन परमेश्‍वरला बचनरी विश्‍वास लजी भिबा ताम थेःजी। ");
INSERT INTO taj_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ओच्‍छे पत्रुस यरूशलेमरी धोखमाहेन्‍से खतना लनोन तोःला भिबा यहूदी विश्‍वासीगदेसे पत्रुसदा चुह्रङ् भिसी बिरोध लजी, ");
INSERT INTO taj_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“खतना आलबा म्‍हिगदेला दिमरी निसी थेनीगदेदेन छ्‌याम ह्राङसे तिग्‍दा चबा थुङ्बा लबा?” ");
INSERT INTO taj_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","जमाहेन्‍से पत्रुससे थेनीगदेदा मेलोसेन घोना लबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“च्‍यागो, ङा योप्‍पा भिबा शहररी प्रार्थना लमा सेम गिक तसी एकोहोरो तबा धुइरी कुनी ब्‍लिरी खीबा घ्रेन तन्‍ना ह्रङ्‌बा गिक मुग्‍याम मार खबान लबा तिगै स्‍हे ङाइ म्राङ्जी, थे तन्‍ना ह्रङ्‌बा स्‍हे ङा मुबा ग्‍लारी खजी। ");
INSERT INTO taj_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","थेरी ङाइ ज्‍यना लसी च्‍यामा जम्‍बुलिङरी मुबा काङ ब्‍लि मुबा ल्‍हानान थरीला जन्‍तुगदेदेन सरी भ्रबा जन्‍तुगदे ओच्‍छे चरागदेदा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","जमाहेन्‍से ‘पत्रुस रेःगो, एसे चुगदे साइसी चउ’ भिबा काइ ङाइ थेःजी। ");
INSERT INTO taj_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“तर ङाइ ‘आहिन प्रभु, चुह्रङ्बा चबारी आतबा नइबा स्‍हेगदे ङाइ खाइमै चबा आरे’ भिसी भिमा, ");
INSERT INTO taj_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“दोःसीनोन स्‍वर्गग्‍याम परमेश्‍वरसे चोखो स्‍होसी जिन्‍बा स्‍हेदा एसे नइबा स्‍हे भिसी थापाङ्‍गो भिबा काइ ङाइ थेःजी। ");
INSERT INTO taj_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","सोमरेमधोना चुह्रङ्‌नोन तजी, जमाहेन्‍से थे जम्‍मान स्‍हे दोःसी स्‍वर्गरीन भोर्जी। ");
INSERT INTO taj_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“थेनोन धुइरी कैसरिया भिबा ग्‍लाग्‍याम ङा मुबा ग्‍लारी पुइखबा म्‍हि सोम ङा चिबा दिमरी धोखजी। ");
INSERT INTO taj_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","परमेश्‍वरला आत्‍मासे ङादा थेनीगदेदेन छ्‌याम शङ्का आलना निउ भिसी सुङ्जी। ओच्‍छे चु ज्‍योज्‍यो आले ढुएनोन ङादेन छ्‌याम निमुबा, जमाहेन्‍से ङनी थे म्‍हिला दिम न्‍हङरी वाङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","थेसे ङन्‍दा चुह्रङ् भिसी पाङ्जी, स्‍वर्गदूत गिक थेला दिमरी राप्‍सी चुह्रङ् भिसी पाङ्‌बान लबा म्राङ्जी, ‘एसे योप्‍पा भिबा शहररी म्‍हि पुइसी सिमोन भिबा पत्रुसदा ङ्‌योइसी भउ। ");
INSERT INTO taj_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","थेसे एदा जुन ताम पाङ्ला थे तामग्‍याम एदेन एला दिमला जम्‍मान म्‍हिगदेसे थार्बा याङ्ला।’ ");
INSERT INTO taj_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“ङाइ पाङ्‌बारी छ्‌याइमाहेन्‍से, ङाच्‍छा य्‍हाङथोरी परमेश्‍वरला आत्‍मा फेप्‍खबा ह्रङ् लसी थेनीगदेथोरीनोन परमेश्‍वरला आत्‍मा फेप्‍खजी। ");
INSERT INTO taj_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","जमाहेन्‍से ‘यूहन्‍नासे एनीगदेदा क्‍युइग्‍याम बप्‍तिस्‍मा पिन्‍जी, तर दाहेन्‍से परमेश्‍वरला आत्‍माग्‍याम एनीगदेला बप्‍तिस्‍मा तला’ भिसी प्रभुसे सुङ्बा ताम ङाइ ढन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","प्रभु येशू ख्रीष्‍टदा विश्‍वास लमाहेन्‍से परमेश्‍वरसे य्‍हाङदा मोलम पिन्‍जी, थेनोन मोलम परमेश्‍वरसे थेनीगदेदाएनोन पिन्‍जी भिसम परमेश्‍वरदा रोकब लबा ङा खाल हिन्‍ना?” ");
INSERT INTO taj_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","चु ताम थेःमाहेन्‍से थेनीगदेसे बिरोध लबा ख्‍लाजी, जमाहेन्‍से थेनीगदेसे परमेश्‍वरदा जयजयकार लजी, ओच्‍छे “दाहेन्‍से परमेश्‍वरसे अर्गु य्‍हुलला म्‍हिगदेदाएनोन ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःसी सोबा मौका पिन्‍बा मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","स्‍तिफनसला बारेरी खबा दुखसे लमा ससा बङबङ तबागदेसे स्‍य्‍हान्‍दोगदेदा आहिन, तर यहूदीगदेदा जे थार्बा पिन्‍बा समाचार थेःना लबान, फोनिके भिबा ग्‍लादेन साइप्रस भिबा ग्‍ला ओच्‍छे एन्‍टिओखिया भिबा शहरधोना निजी। ");
INSERT INTO taj_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","तर थेनीगदे न्‍हङला कोइ कोइ चेलागदे साइप्रसदेन कुरेनी भिबा ग्‍लाला मुबा। थेनीगदे एन्‍टिओखिया भिबा शहररी खसी अर्गु य्‍हुलला म्‍हिगदेदाएनोन प्रभु येशूला बारेरी थार्बा पिन्‍बा समाचार थेःना लजी। ");
INSERT INTO taj_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","थेनीगदेदेन छ्‌याम प्रभुला शक्ति मुबासे लमा ल्‍हानान म्‍हिगदेसे विश्‍वास लसी प्रभुला चेला दोजी। ");
INSERT INTO taj_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","चु ताम यरूशलेमरी मुबा मण्‍डलीसे थेःजी, जमाहेन्‍से थेनीगदेसे एन्‍टिओखिया भिबा शहररी बारनाबासदा पुइजी। ");
INSERT INTO taj_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","बारनाबास थेरी खसी परमेश्‍वरसे दयामाया लबादेन मोलम पिन्‍बा म्राङ्सी ल्‍हानान ताङ्जी। ओच्‍छे थेसे थेनीगदे जम्‍मादान सदन सेमहेन्‍से प्रभुदा विश्‍वास लसी चिउ भिसी आँट पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","बारनाबास परमेश्‍वरला आत्‍मासे प्‍लिङ्‌बादेन विश्‍वासरी कोङ्बा ज्‍यबा म्‍हि मुबा। थेतबासेलमा ल्‍हानान म्‍हिगदेसे प्रभुदा विश्‍वास लजी। ");
INSERT INTO taj_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","जमाहेन्‍से बारनाबास शाऊलदा म्‍हाइबारी टार्सस भिबा शहररी निजी। ");
INSERT INTO taj_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","थेसे शाऊलदा स्‍याप्‍माहेन्‍से एन्‍टिओखिया भिबा शहररी भजी। जमाहेन्‍से थेनीगदेसे तिदिङधोना मण्‍डलीला म्‍हिगदेदेन छ्‌याम स्‍याप्‍बान ल्‍हानान म्‍हिगदेदा परमेश्‍वरला बचन लोप्‍बारी छ्‌याइजी। चेलागदेदा जम्‍मान भन्‍दा ङाच्‍छा एन्‍टिओखिया भिबा शहररीन ख्रीष्‍टियान भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","थे धुइरी कोइ कोइ अगमवक्तागदे यरूशलेमग्‍याम एन्‍टिओखिया भिबा शहररी खजी। ");
INSERT INTO taj_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","थे अगमवक्तागदे न्‍हङला अगाबस भिबा अगमवक्ता रेःजी, ओच्‍छे परमेश्‍वरला आत्‍मासे थेदा चु जम्‍बुलिङ नाङनोन घ्रेन अनिकाल तबारी छ्‌याइबा मुला भिसी पाङ्‌पुङ्‌जी। चु ताम लिच्‍छा क्‍लौडियस भिबा ग्‍लेला पालोरी पूरा तजी। ");
INSERT INTO taj_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","जमाहेन्‍से जम्‍मान चेलागदेसे ह्राङ ह्राङसे खम्‍तेधोना भेटी ह्रुप्‍सी यहूदिया भिबा ग्‍लारी चिबा विश्‍वासीगदेदा पिन्‍बारी पक्‍का लजी। ");
INSERT INTO taj_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","चुह्रङ् लसी बारनाबासदेन शाऊलसे भेटी ह्रुप्‍सी मण्‍डलीदा च्‍याबा म्‍हिगदे मुबा ग्‍लारी पुइजी। ");
INSERT INTO taj_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","थे धुइरी हेरोद अग्रिपा भिबा ग्‍लेसे मण्‍डलीला कोइ कोइ म्‍हिगदेदा चुङ्सी ल्‍हानान दुख पिन्‍बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","थे ग्‍लेसे यूहन्‍नाला ज्‍योज्‍यो याकूबदा तरवारसे थासी साइपुङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","चुह्रङ् लमा यहूदीगदे ताङ्‍बा म्राङ्सी हेरोद ग्‍लेसे पत्रुसदाएनोन चुङ्‌पुङ्‌जी। हेरोद ग्‍लेसे चुह्रङ् लबा खमीर आयुना गेङ चसी धङ्बा चाडला धुइरी मुबा। ");
INSERT INTO taj_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","हेरोद ग्‍लेसे पत्रुसदा चुङ्सी झ्‍याल्‍खानरी झाङ्‌माहेन्‍से सिपाहीगदेला समूह ब्‍लि स्‍होसी ख्रुङ्पुङ्जी। ओच्‍छे मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाड जिन्‍माहेन्‍से थेदा म्‍हिगदेला ङाच्‍छापट्टि भसी ङ्‌योइबा छार्बा लबा सेम लजी। ");
INSERT INTO taj_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","थेतबासेलमा पत्रुसदा झ्‍याल्‍खानरी झाङ्‌जी, तर मण्‍डलीसे पत्रुसला लागिरी परमेश्‍वरदेन छ्‌याम झन प्रार्थना लबाला लबान लजी। ");
INSERT INTO taj_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","हेरोद ग्‍लेसे पत्रुसदा म्‍हिगदेला ङाच्‍छापट्टि भबारी छ्‌याइबा धिनना ङाच्‍छाकुनुला म्‍हुनङ, पत्रुस सिपाही न्‍हीला गुङरी म्‍हेर्सी चिबा मुबा, थेदा च्‍याल्‍दा न्‍हीसे खीसी थान्‍बा मुबा। ओच्‍छे स्‍य्‍हान्‍दो सिपाहीगदेसेनोन झ्‍याल्‍खानना म्रापरी ख्रुङ्‌सी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","तिक्‍खुरीन प्रभुला दूत गिक पत्रुस मुबा ग्‍लारी खसी राप्‍जी, ओच्‍छे पत्रुसदा थान्‍बा कोठारी य्‍हाल तजी। ओच्‍छे थे स्‍वर्गदूतसे पत्रुसला राइरी थुर्सी, “ए योना रेःगो” भिसी पत्रुसदा छिङ्जी। स्‍वर्गदूतसे थेह्रङ् भिमैछ्‌याम पत्रुसला यारी खीबा च्‍याल्‍दा ह्रङ्नोन ब्‍लसी सरी ताइजी। ");
INSERT INTO taj_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","जमाहेन्‍से स्‍वर्गदूतसे थेदा “एसे क्‍वानदेन लखम क्‍वान्‍गो” भिसी भिमा थेसे थेह्रङ्नोन लजी। दोःसीनोन स्‍वर्गदूतसे पत्रुसदा “ए घ नान्‍सी ङाला लिच्‍छा लिच्‍छा खउ” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","स्‍वर्गदूतसे थेह्रङ् भिमाहेन्‍से पत्रुस स्‍वर्गदूतला लिच्‍छा लिच्‍छा भ्रबारी छ्‌याइजी। स्‍वर्गदूतसे लबा चु गे साँच्‍चिन हिन्‍ना भिसी पत्रुसदा थानोन आरेबा। तर पत्रुससे चु ङाइ म्‍हाङ म्राङ्बान मुला भिसी म्‍हन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","जमाहेन्‍से झ्‍याल्‍खानरी ख्रुङ्‌सी चिबा सिपाहीला समूह न्‍हीदा वाइसी थेनीगदे शहरपट्टि निबा फाइला म्रापरी धोजी, थेरी धोमैछ्‌याम थे म्राप ह्रङ्नोन ठोङ्‌जी, जमाहेन्‍से थेनीगदे थोन्‍सी गल्‍लीला ग्‍याम तसी निना निनान स्‍वर्गदूतसे पत्रुसदा ख्‍लासी निजी। ");
INSERT INTO taj_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","थे धुइरी चा तिग तजी भिबा ताम पत्रुससे था याङ्सी चुह्रङ् भिजी, “प्रभुसे ह्राङला दूत पुइखसी हेरोद ग्‍लेला याग्‍यामदेन यहूदीगदेसे लबारी छ्‌याइबा गेग्‍याम फेबा ताम पक्‍का हिन्‍ना।” ");
INSERT INTO taj_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","चु ताम था याङ्माहेन्‍से थे मर्कूस भिबा यूहन्‍नाला आमा मरियमला दिमरी निजी। थेरी ल्‍हानान म्‍हिगदे ह्रुप तसी प्रार्थना लसी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","थेसे म्राप ढ्वक ढ्वक लमाहेन्‍से रोदा भिबा नोकरस्‍या म्राप ठोङ्‌बारी खजी। ");
INSERT INTO taj_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","थेसे पत्रुसला काइ ङोसेसी ताङ्बासे लमा म्रापनोन आठोङ्‌ना न्‍हङरी यार्बान निसी, “पत्रुस म्रापरी राप्‍सी चिबा मुला” भिसी जम्‍मादान भिजी। ");
INSERT INTO taj_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","तर थेरी मुबागदेसे थेदा “ए म्‍योजीम” भिसी भिमा थेसे ढीपि लबान चु ताम पक्‍का हिन्‍ना भिसी भिजी। जमाहेन्‍से थेनीगदेसे “थे पत्रुसदा च्‍याबा स्‍वर्गदूत मुला तला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","तर पत्रुससे चा म्राप ढ्वक ढ्वक लबाला लबान लजी। जमाहेन्‍से म्राप ठोङ्‌मा पत्रुसदा म्राङ्सी थेनीगदे उदेक तजी। ");
INSERT INTO taj_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","तर पत्रुससे थेनीगदेदा “कुटिसी चिउ” भिसी यासे चाल लजी, ओच्‍छे प्रभुसे ह्राङदा खाह्रङ् लसी झ्‍याल्‍खानग्‍याम मङग्‍यार तेःजी भिबा ताम थेनीगदेदा पाङ्जी। ओच्‍छे चु ताम याकूबदेन विश्‍वास लबा स्‍य्‍हान्‍दो ज्‍योज्‍यो आले नाना आङागदेदाएनोन पाङ्सी पिन्‍गो भिसी पत्रुस थेनीगदे मुबा ग्‍लाग्‍याम अर्गु ग्‍लारी निजी। ");
INSERT INTO taj_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","स्‍य्‍हो तमाहेन्‍से पत्रुस खानङ निजी भिसी सिपाहीगदे न्‍हङरी ल्‍हानान हल्‍ली खल्‍ली तजी। ");
INSERT INTO taj_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","हेरोदसे पत्रुसदा म्‍हाइगो भिसी कुल्‍जी। तर थेनीगदेसे पत्रुसदा खानङएनोन आस्‍याप्‍नी। थेतबासेलमा सिपाहीगदेदा ङ्‌योइबा छार्बा लजी, तसैनोन तिगै जोहाब आपिन्‍माहेन्‍से थेनीगदेदा साइगो भिसी कुल्‍जी। जमाहेन्‍से हेरोद चा यहूदियाग्‍याम कैसरिया भिबा ग्‍लारी निसी थेरीन चिजी। ");
INSERT INTO taj_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","टुरोसदेन सीदोन य्‍हुल्‍साला म्‍हिगदेदेन छ्‌याम हेरोद ल्‍हानान बोमो खबा मुबा। थेतबासेलमा थेनीगदे ढिक्‍सी हेरोद मुबा ग्‍लारी खजी, ओच्‍छे ग्‍लेला गे लबा बलस्‍तस भिबा म्‍हिदा ह्रो स्‍होसी ग्‍लेदेन छ्‌याम ढिक्‍बाला लागिरी सल्‍लाह लजी। तिग्‍दा भिसम थेनीगदेला चबा स्‍हे हेरोद ग्‍लेला य्‍हुल्‍साग्‍याम खतोःबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","तोगब लबा धिनकुनु ग्‍लेसे जे क्‍वान्‍बा क्‍वान क्‍वान्‍सी हेरोद ग्‍ले निसाफ लबा ठिरी चिसी म्‍हिगदेला ङाच्‍छा भाषण लजी। ");
INSERT INTO taj_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","जमाहेन्‍से म्‍हिगदेसे “चु काइ मी लला काइ हिन्‍ना, म्‍हिला आहिन!” भिसी क्रिङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","तर परमेश्‍वरला मानदेन जयजयकार आलबासे लमा थेनोन धुइरी स्‍वर्गदूत गिकसे हेरोद ग्‍लेदा आखम्‍बा तना लजी, जमाहेन्‍से स्‍याउँ स्‍याउँ च्‍योलोङ तसी थे सिजी। ");
INSERT INTO taj_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","तर परमेश्‍वरला बचन जुन जुन ग्‍लारी थेःजी थेरी ल्‍हानान विश्‍वासीगदे बढब तबान निजी। ");
INSERT INTO taj_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ओच्‍छे बारनाबासदेन शाऊल ह्राङला गे जिन्‍ना लसी यरूशलेमग्‍याम दोःजी। थेनीगदेदेन छ्‌याम मर्कूस भिबा यूहन्‍नाएनोन मुबा। ");
INSERT INTO taj_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","एन्‍टिओखियाला मण्‍डलीरी मुबा अगमवक्तागदेदेन लोप्‍बा म्‍हिगदे चुनोन हिन्‍ना। बारनाबास, म्‍लाङगै भिबा शिमियोन, कुरेनी भिबा लुकियस, शासन लबा हेरोददेन छ्‌याम छर्बा मनेन ओच्‍छे शाऊल, ");
INSERT INTO taj_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","थेनीगदे फोइथान चिसी प्रार्थना लबान प्रभुदा तेन्‍बा धुइरी परमेश्‍वरला आत्‍मासे “बारनाबासदेन शाऊलदा ङाला लागिरी फेसी थान्‍गो, ङाइ थेन्‍नीदा ङाला गे लबाला लागिरी धम्‍बा मुला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","जमाहेन्‍से थेनीगदे फोइथान चिसी थेन्‍नीथोरी ह्राङ ह्राङला या थान्‍सी प्रार्थना लसी थेन्‍नीदा प्रभुला गे लबारी पुइजी। ");
INSERT INTO taj_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","परमेश्‍वरला आत्‍मासे बारनाबासदेन शाऊलदा पुइजी, ओच्‍छे थेन्‍नी सिलुकिया भिबा ग्‍लारी निजी। थे ग्‍लाग्‍याम पानी जहाजरी क्रेःसी साइप्रसपट्टि निजी। ");
INSERT INTO taj_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ओच्‍छे सलामिस भिबा ग्‍लारी धोखमाहेन्‍से थेन्‍नीसे यहूदीगदे ह्रुप तबा दिमरी परमेश्‍वरला बचन थेःना लजी। थेन्‍नीदा ह्रो लबारी मर्कूस भिबा यूहन्‍नाएनोन थेन्‍नीदेन छ्‌यामनोन मुबा। ");
INSERT INTO taj_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","जमाहेन्‍से थेनीगदे साइप्रस भिबा अञ्‍चलला शहर शहररी कोर्बान पाफोस भिबा ग्‍लाधोना धोखजी, थेरी थेनीगदेसे बार-येशू भिबा जादु लबा फट्टा यहूदी अगमवक्ता गिकदा स्‍याप्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","थे जादु लबा म्‍हि साइप्रस भिबा अञ्‍चलरी शासन लबा सर्गियस पौलुस भिबा म्‍हिला ह्रो मुबा। थे सर्गियस पौलुस बुद्धि मुबा म्‍हि मुबा। थेसे परमेश्‍वरला बचन ङ्‌यान्‍बा सेम लबासे लमा शाऊलदेन बारनाबासदा ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","तर जादु लबा एलुमाससे सर्गियस पौलुससे थेनीगदेला ताम विश्‍वास थालगै भिसी शाऊलदेन बारनाबासला बिरोध लजी। एलुमास भिबा चा ग्रीक ग्‍योइरी जादु लबा म्‍हि भिबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","तर शाऊल, थेदा पावलएनोन भिमुबा, परमेश्‍वरला आत्‍मासे प्‍लिङ्‌सी थे एलुमासदा एकोहोरो च्‍याबाला च्‍याबान लसी चुह्रङ् भिसी भिजी, ");
INSERT INTO taj_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“ए जम्‍मान ज्‍यबा गेला शत्रु, ओच्‍छे पापी सेमदेन नइबा सेमसे प्‍लिङ्बा शैतानना कोला, तिग एसे प्रभुग्‍याम लोप्‍बा सत्‍य तामगदेदा न्‍होङ्ना लबारी आख्‍ला? ");
INSERT INTO taj_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","च्‍यागो, दाहेन्‍से प्रभुसे एदा सजाय पिन्‍सी जिन्‍बा मुला, थेतबासेलमा छिन्‍नङधोना ए काना तसी धिनीला य्‍हालएनोन आम्राङ्” भिसी भिजी। थेह्रङ् भिमैछ्‌याम खसु ह्रङ्‌बा खसी थेला मी घप्‍जी, ओच्‍छे धोपधोप तसी थेसे तिगै आम्राङ्‌नी। जमाहेन्‍से खालैसे यारी चुङ्सी डोर्‍याब लला वा भिसी थे क्‍यारमार भ्रबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","चुह्रङ् तबा म्राङ्सी थे ग्‍लारी शासन लबा म्‍हिसे प्रभुदा विश्‍वास लजी। तिग्‍दा भिसम प्रभुला बचनग्‍याम लोप्‍बा तामरी थे उदेक तबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","पावलदेन थेला ह्रोगदे पाफोसग्‍याम पानी जहाजरी क्रेःसी पामफिलिया भिबा ग्‍लारी परब तबा पर्गा भिबा ग्‍लारी धोजी, ओच्‍छे मर्कूस भिबा यूहन्‍ना चा थेनीगदेग्‍याम फेसी यरूशलेमरी धोजी। ");
INSERT INTO taj_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","तर थेनीगदे चा पर्गा भिबा ग्‍लाग्‍याम पिसिदिया भिबा अञ्‍चलरी परब तबा एन्‍टिओखिया शहररी खजी, ओच्‍छे ब्‍लप्‍बा न्‍हबा धिनकुनु यहूदीगदे ह्रुप तबा दिम न्‍हङरी निसी चिजी। ");
INSERT INTO taj_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ओच्‍छे यहूदीगदे ह्रुप तबा दिमला नेतागदेसे मोशाला ठिमदेन अगमवक्तागदेसे भ्रिबा किताब पढब लमाहेन्‍से थेनीगदेदा “आलेगदे, ह्राङनीदेन छ्‌याम म्‍हिगदेदा अर्ती पिन्‍बा खाल्‍ला तिगै बचन मुसम सुङ्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","जमाहेन्‍से पावल राप्‍सी यासे चाल लबान चुह्रङ् भिबारी छ्‌याइजी, “इस्राएलला ङाला ज्‍योज्‍यो आलेदेन परमेश्‍वरदा तेन्‍बा अर्गु य्‍हुलला म्‍हिगदे ङाला ताम ङ्‌यान्‍गो। ");
INSERT INTO taj_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","य्‍हाङला आखे म्‍हेमेगदे मिश्र य्‍हुल्‍सारी चिबा धुइरी इस्राएल य्‍हुलला परमेश्‍वरसे थेनीगदेदा धम्‍सी घ्रेन म्‍हि स्‍होजी। जमाहेन्‍से परमेश्‍वरसे ह्राङला शक्तिशाली छ्‌यासे थेनीगदेदा थे य्‍हुल्‍साग्‍याम तेःसी भजी। ");
INSERT INTO taj_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ओच्‍छे तोङतोङबा ग्‍लारी थेनीगदेसे लबा आज्‍यबा बानीबेहोर नाबान ओस्‍पन बोगल न्‍ही दिङधोना परमेश्‍वरसे थेनीगदेदा ह्रो लजी। ");
INSERT INTO taj_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","जमाहेन्‍से परमेश्‍वरसे कनान य्‍हुल्‍साला गोर निस य्‍हुलला म्‍हिगदेदा नाश लजी। ओच्‍छे थे य्‍हुल्‍सा परमेश्‍वरसे थेनीगदेला अधिकाररी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","चु जम्‍मान ताम ओस्‍पन ग्‍यार्जा ब्‍लिसे बोगल न्‍हीसे च्‍युइ दिङधोना तजी। “जमाहेन्‍से शमूएल अगमवक्ताला पालोधोना परमेश्‍वरसे न्‍यायाधीश पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","जमाहेन्‍से म्‍हिगदेसे ग्‍ले ह्रीजी, थेतबासेलमा परमेश्‍वरसे बेन्‍यामीनना वंशला कीश भिबा म्‍हिला झा शाऊलदा बोगल न्‍ही दिङधोना शासन लपुङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ओच्‍छे परमेश्‍वरसे शाऊलदा तेःमाहेन्‍से दाऊददा थेनीगदेला ग्‍ले स्‍होजी। ओच्‍छे परमेश्‍वरसे दाऊदला बारेरी ‘ङाइ यिशै भिबा म्‍हिला झा दाऊददा ङाला सेमसे म्‍हन्‍बा ह्रङ्‌बान म्‍हि स्‍याप्‍जी, थेसे ङाइ म्‍हन्‍बा जम्‍मान गे लला’ भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“परमेश्‍वरसे कबुल लबा अन्‍छार चुनोन म्‍हिला सन्‍तानग्‍याम इस्राएलीगदेदा थार्बा पिन्‍बाला लागिरी येशूदा भजी। ");
INSERT INTO taj_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","येशू फेप्‍खबा भन्‍दा ङाच्‍छा यूहन्‍नासे इस्राएलला जम्‍मान म्‍हिगदेदा ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःसी बप्‍तिस्‍मा किन्‍गो भिसी थेःना लजी। ");
INSERT INTO taj_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","यूहन्‍नासे ह्राङला गे जिन्‍ना लबारी छ्‌याइमा ‘एनीगदेसे ङा खाल भिसी म्‍हन्‍बा मुला? ङा थे आहिन। तर च्‍यागो, थे ङा भन्‍दा लिच्‍छा फेप्‍खला, ङा थेला लखम स्‍युबाधोनाला आरे’ भिसी भिमुबा। ");
INSERT INTO taj_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“अब्राहामला सन्‍तान, ङाला ज्‍योज्‍यो आलेदेन परमेश्‍वरसे कुल्‍बा ताम ङ्‌यान्‍बा अर्गु य्‍हुलला आलेगदे चु थार्बा याङ्बा समाचार य्‍हाङला लागिरी पुइखबा मुला। ");
INSERT INTO taj_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","तर यरूशलेमरी चिबा म्‍हिगदेदेन ह्राङला नेतागदेसे थेदा ङोआसेनी, ओच्‍छे ब्‍लप्‍बा न्‍हबा धिनकुनु पढब लबा अगमवक्तागदेसे भ्रिबा बचन आघोना थेदा सिबाला सजाय पिन्‍सी थे बचन पूरा लजी। ");
INSERT INTO taj_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","सिबाला सजाय पिन्‍तोःबा तिगै ताम आस्‍याप्‍सैनोन थेनीगदेसे थेदा साइनोन तोःला भिसी पिलातसदा भिजी। ");
INSERT INTO taj_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ओच्‍छे थेनीगदेसे थेला बारेरी बचनरी भ्रिबा अन्‍छार जम्‍मान ताम लसी जिन्‍माहेन्‍से थेनीगदेसे थेदा क्रुसग्‍याम मार तेःसी धुर्सारी थान्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","तर परमेश्‍वरसे थेदा सिबाग्‍याम सोना लजी। ");
INSERT INTO taj_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ओच्‍छे गालीलग्‍याम यरूशलेमधोना ह्राङदेन छ्‌याम खबा म्‍हिगदेसे थेदा ल्‍हानान धिनधोना म्राङ्जी, दान्‍दे म्‍हिगदेला लागिरी थेनीगदे थेला साक्षी हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“परमेश्‍वरसे य्‍हाङला आखे म्‍हेमेदेन छ्‌याम लबा थे कबुलला समाचार ङन्‍से ह्राङनीदा पाङ्ला। ");
INSERT INTO taj_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","परमेश्‍वरसे येशूदा सिबाग्‍याम सोना लसी थेनीगदेला कोलागदे य्‍हाङला लागिरी थे ताम पूरा लसी पिन्‍जी, थेला बारेरी दाऊद ग्‍लेसे भ्रिबा न्‍हीरेमला व्‍हाइरी चुह्रङ् भिसी भ्रिबा मुला ‘ए ङाला झा हिन्‍ना, तिनी ङा एला आबा दोजी।’ ");
INSERT INTO taj_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","परमेश्‍वरसे येशूदा खाइमै नइना आलना सिबाग्‍याम सोना लबाला बारेरी चुह्रङ् भिसी सुङ्बा मुला, ‘ङाइ दाऊददा पिन्‍ना भिसी लबा कबुल चोखोदेन सत्‍य मोलम एनीगदेदा पिन्‍ना।’ ");
INSERT INTO taj_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ओच्‍छे अर्गु व्‍हाइरीनोन चुह्रङ् भिबा मुला, ‘परमेश्‍वरसे ह्राङदा जे तेन्‍बा म्‍हिला ल्‍हुइ धुर्सारी नइआपुङ्।’ ");
INSERT INTO taj_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","तर चु ताम दाऊदसे ह्राङला बारेरी पाङ्बा आहिन। तिग्‍दा भिसम दाऊदसे ह्राङ सोतेधोना परमेश्‍वरसे म्‍हन्‍बा ह्रङ्‌बान गे लसी सिजी। ओच्‍छे थेदा थेला आखे म्‍हेमे ल्‍हुबा ग्‍लारीन ल्‍हुजी, ओच्‍छे थेला ल्‍हुइ नइसी निजी। ");
INSERT INTO taj_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","तर परमेश्‍वरसे सिबाग्‍याम सोना लबा येशूला ल्‍हुइ चा आनइनी। ");
INSERT INTO taj_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“थेतबासेलमा ज्‍योज्‍यो आलेगदे चु येशूग्‍यामसेन य्‍हाङला पाप माफ तला भिसी ङाइ पाङ्बा चु ताम ह्राङनीदा था तगै। ");
INSERT INTO taj_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","मोशाला ठिमग्‍याम ह्राङनी परमेश्‍वरदा सेम निबा म्‍हि दोबारी आखम्‍नी। तर येशूदा विश्‍वास लबागदे जम्‍मान परमेश्‍वरदा सेम निबा म्‍हि दोबा मुला। ");
INSERT INTO taj_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","थेतबासेलमा होशियार लसी स्‍य्‍हूगो, आहिन्‍सम अगमवक्तागदेसे पाङ्बा चु ताम ह्राङनीथोरी खला। ");
INSERT INTO taj_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","अगमवक्तागदेसे चुह्रङ् भिसी पाङ्बा मुबा, ‘परमेश्‍वरसे सुङ्बा तामदा हेला लबागदे, उदेक तसी सिउ! एनीगदेला धुइरी ङाइ गे गिक लला, थे गेला बारेरी खालैसे पाङ्सी पिन्‍सैनोन एनीगदेसे खाइमै विश्‍वास आल।’” ");
INSERT INTO taj_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","पावलदेन बारनाबास यहूदीगदे ह्रुप तबा दिमग्‍याम थोन्‍सी निबारी छ्‌याइमुबा, जमा म्‍हिगदेसे खबा साताला ब्‍लप्‍बा न्‍हबा धिनकुनुएनोन ङन्‍दा चु ताम लोप्‍सी पिन्‍गो भिसी थेनीगदेदा पाङ्‌बाला पाङ्‌बान लजी। ");
INSERT INTO taj_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","यहूदीगदे ह्रुप तबा दिमग्‍याम थोन्‍माहेन्‍से ल्‍हानान यहूदीगदेदेन यहूदी धर्म तेन्‍बा अर्गु य्‍हुलला म्‍हिगदे पावलदेन बारनाबासला लिच्‍छा भ्रबारी छ्‌याइजी, जमाहेन्‍से पावलदेन बारनाबाससे थेनीगदेदा एनीगदे सदन परमेश्‍वरला दयामायारी चिउ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ब्‍लप्‍बा न्‍हबा अर्गु धिनकुनुएनोन शहरला जम्‍मान ह्रङ्‌बा म्‍हिगदे परमेश्‍वरला बचन ङ्‌यान्‍बारी पोप तजी। ");
INSERT INTO taj_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","चुदे ल्‍हाना म्‍हिला हुल म्राङ्सी कोइ कोइ यहूदीगदेदा ल्‍हानान डाह तजी, ओच्‍छे पावलसे पाङ्बा तामदा बिरोध लसी थेनीगदेसे पावलला बेइज्‍जत लजी। ");
INSERT INTO taj_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","तर पावलदेन बारनाबास ढुक्‍क तसी थेनीगदेदा चुह्रङ् भिसी भिजी, “जम्‍मान भन्‍दा ङाच्‍छा परमेश्‍वरला बचन एनीगदे यहूदीगदेदान थेःना लतोःबा मुबा। तसैनोन चुदा एनीगदेसे ङ्‌यान्‍बारीन आम्‍हाइनी। चुह्रङ् लसी एनीगदेसे ह्राङसे ह्राङदा जुकजुकधोनाला जुनी याङ्‍बाधोनाला म्‍हि हिन्‍ना भिसी आम्‍हन्‍बासे लमा दाहेन्‍से ङनी अर्गु य्‍हुलला म्‍हिगदे मुबा ग्‍लारी निसी परमेश्‍वरला बचन थेःना लला। ");
INSERT INTO taj_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","तिग्‍दा भिसम प्रभुसे ङन्‍दा चुह्रङ् भिसी कुल्‍बा मुला, ‘जम्‍बुलिङला कनाकुनीधोना थार्बा याङ्बा समाचार धोना लबारी ओच्‍छे अर्गु य्‍हुलला म्‍हिगदेला गुङरी य्‍हाल दोबारी ङाइ एनीगदेदा धम्‍बा मुला।’” ");
INSERT INTO taj_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","चु ताम थेःमाहेन्‍से अर्गु य्‍हुलला म्‍हिगदे ताङ्सी परमेश्‍वरला बचनला जयजयकार लजी, ओच्‍छे जुकजुकधोनाला जुनी याङ्बारी धम्‍बागदेसे परमेश्‍वरला बचनरी विश्‍वास लजी। ");
INSERT INTO taj_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","जमाहेन्‍से विश्‍वासीगदेसे जम्‍मान ग्‍लारी प्रभुला बचन थेःना लजी। ");
INSERT INTO taj_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","तर पावलदेन बारनाबासला बिरोध लसी यहूदीगदेसे म्‍हिगदेग्‍याम मान याङ्बा परमेश्‍वरसे कुल्‍बा ताम ङ्‌यान्‍बा म्रिङम्‍हेमेगदेदेन शहरला मुल म्‍हिगदेदा थीसी, पावलदेन बारनाबासदा ह्राङला ग्‍लाग्‍याम तेःजी। ");
INSERT INTO taj_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","थेतबासेलमा पावलदेन बारनाबाससे चा थेनीगदेला बिरोधरी ह्राङला काङला धुलु खर्सी आइकोनियन भिबा ग्‍लारी निजी। ");
INSERT INTO taj_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","तर एन्‍टिओखियारी मुबा चेलागदे चा परमेश्‍वरला आत्‍मासे प्‍लिङ्‌सी ल्‍हानान ताङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","थेह्रङ् लसीन बारनाबासदेन पावल आइकोनियन भिबा शहररीनोन यहूदीगदे ह्रुप तबा दिमरी निजी। ओच्‍छे थेनीगदेसे यहूदीगदे ह्रुप तबा दिम न्‍हङरी ज्‍यना लसी घोना लबासे लमा थेरी मुबा ल्‍हानान यहूदीगदेदेन अर्गु य्‍हुलला म्‍हिगदेसे प्रभु येशू ख्रीष्‍टदा विश्‍वास लजी। ");
INSERT INTO taj_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","तर विश्‍वास आलबा यहूदीगदेसे चा अर्गु य्‍हुलला म्‍हिगदेदा थीसी प्रभुरी विश्‍वास लबा ज्‍योज्‍यो आलेगदेला बिरोध लबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","तसैनोन पावलदेन बारनाबास ल्‍हानान धिनधोना थेरीन चिजी। थेन्‍नीसे प्रभुथोरी विश्‍वास थान्‍सी आलोङ्नान ताम लजी। थेनीगदेग्‍याम प्रभुसे उदेकला चिनुगदेदेन गेगदे लसी ह्राङला दयामायाला बचन सत्‍य हिन्‍ना भिसी उन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","तर थे शहरला म्‍हिगदे फेसी कोइ यहूदीगदेदेन छ्‌याम कोइ येशूला मुल चेलागदेदेन छ्‌याम ढिक्‍बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","जमाहेन्‍से अर्गु य्‍हुलला म्‍हिगदेदेन यहूदीगदे न्‍हीनोन नेतागदेदेन छ्‌याम ढिक्‍सी थेनीगदेदा दुख पिन्‍बादेन युङबासे तोबारी म्‍हाइजी। ");
INSERT INTO taj_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","पावलदेन बारनाबाससे चु था याङ्सी लुकोनिया भिबा शहरला लुस्‍त्रादेन डर्बी शहररी ओच्‍छे थे शहरला क्‍यारमारला जिल्‍ला तबान यार्सी निजी। ");
INSERT INTO taj_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","थेरीनोन थेनीगदेसे थार्बा पिन्‍बा समाचार थेःना लसीन चिजी। ");
INSERT INTO taj_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","लुस्‍त्रा भिबा शहररी काङ चलब आतबा म्‍हि गिक मुबा। थे म्‍हि न्‍हमान कुज्‍या मुबा, थे खाइमै भ्रबा आरेमुबा। ");
INSERT INTO taj_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","थे म्‍हिसे पावलसे पाङ्‌मा ङ्‌यान्‍बान मुबा। ओच्‍छे थे म्‍हिसे ङाएनोन खम्‍ला भिसी विश्‍वास लबा ताम था याङ्सी पावलसे थे म्‍हिदा एकोहोरो च्‍यासी, ");
INSERT INTO taj_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","“ए काङ जूसी डोङ रेःगो” भिसी घ्रेन काइसे पाङ्जी। थेह्रङ् पाङ्‌मैछ्‌याम थे म्‍हि डोङ रेःसी भ्रबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","म्‍हिला हुलसे पावलसे लबा चु गे म्राङ्माहेन्‍से लुकोनिया ग्‍योइरी क्रिङ्‌बान, “लगदे म्‍हि दोसी य्‍हाङ मुबा ग्‍लारी फेप्‍खजीम” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","जमाहेन्‍से थेनीगदेसे बारनाबासदा जिउस भिबा ल ओच्‍छे पावलदा हर्मेस ल भिसी भिबारी छ्‌याइजी, तिग्‍दा भिसम पावल चा ताम पाङ्बा मुल म्‍हि मुबा। ");
INSERT INTO taj_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","थे जिउसला मन्‍दिर थे शहरला ङामरीन मुबा। थेतबासेलमा थे मन्‍दिररी पूजा लबा म्‍हिसे बहरगदेदेन म्‍हेन्‍दोला लुङ भसी शहरला म्रापरी खजी। जमाहेन्‍से मुल चेला बारनाबासदेन पावलला ङाच्‍छापट्टि थे बाहरगदे बलि पिन्‍बारी ठीक लजी। ");
INSERT INTO taj_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","तर मुल चेलागदे बारनाबासदेन पावलसे चु ताम था याङ्माहेन्‍से थेनीगदेसे ह्राङ ह्राङला क्‍वान ढेबान म्‍हिला हुल न्‍हङरी यार्सी निसी क्रिङ्बान चुह्रङ् भिबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“म्‍हिगदे! ह्राङनीसे तिग्‍दा चुह्रङ्बा गे लबा? ङनीएनोन ह्राङनी ह्रङ्‌बान दुख सुख नासी भ्रबा म्‍हिगदे हिन्‍ना, ओच्‍छे चुह्रङ्बा नइबा गेगदे ख्‍लासी स्‍वर्गदेन जम्‍बुलिङ ओच्‍छे समुन्‍द्रदेन थेरी मुबा जम्‍मान स्‍हेगदे स्‍होबा छोन्‍बो परमेश्‍वरपट्टि दोःगै भिसी ह्राङनीदा सत्‍य ताम पाङ्‌बारी ङनी थार्बा पिन्‍बा समाचार भसी खबा हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","दङबो धुइरी परमेश्‍वरसे जम्‍मान य्‍हुलला म्‍हिगदेदा ह्राङ ह्राङला ठिम अन्‍छार भ्रपुङ्‌जी, ");
INSERT INTO taj_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","तसैनोन परमेश्‍वरसे ह्राङला दयामायाला गे लबा आख्‍लाना स्‍वर्गग्‍याम नाम ताइना लसी चबा स्‍हेगदे रोना लजी। ओच्‍छे ल्‍हानान चबा स्‍हेगदे पिन्‍सी म्‍हिगदेला सेम ताङ्ना लजी। चुनोन गेगदेसे परमेश्‍वरला साक्षी पिन्‍बा मुला।” ");
INSERT INTO taj_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","चुह्रङ् भिसैनोन बलि थालउ भिसी थे म्‍हिगदेदा रोकब लबारी थेनीगदेदा गाह्रो तजी। तसैनोन म्‍हिला हुलदा बलि पिन्‍आपुङ्‌नी। ");
INSERT INTO taj_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","जमाहेन्‍से एन्‍टिओखियादेन आइकोनियन भिबा शहरग्‍याम कोइ कोइ यहूदीगदे थेरी धोखजी। थेनीगदेसे म्‍हिगदेदा थीसी युङबासे तोपुङ्‌जी। जमाहेन्‍से जम्‍मान म्‍हिगदेसे युङबासे तोजी, ओच्‍छे सिजी भिसी म्‍हन्‍सी थेनीगदेसे पावलदा डुइबान शहरग्‍याम मङग्‍यार भोर्जी। ");
INSERT INTO taj_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","तर प्रभुला चेलागदे खसी पावलला क्‍यारक्‍युर पोप तमा थे रेःसी शहर न्‍हङरी निजी। ओच्‍छे न्‍हङगरदङ बारनाबासदेन छ्‌यामनोन थे डर्बी भिबा शहररी निजी। ");
INSERT INTO taj_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","थेन्‍नीसे डर्बी भिबा शहररी थार्बा पिन्‍बा समाचार थेःना लसी ल्‍हानान म्‍हिगदेदा येशूला चेला स्‍होजी। जमाहेन्‍से थेन्‍नी लुस्‍त्रादेन आइकोनियन ओच्‍छे एन्‍टिओखिया भिबा शहररी दोःसी निजी। ");
INSERT INTO taj_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","थेन्‍नीसे थेरी मुबा चेलागदेदा आँट पिन्‍बान सदन विश्‍वासरी चिउ भिसी भिजी। ओच्‍छे य्‍हाङ सेमरी ल्‍हानान दुख नासी परमेश्‍वरला य्‍हुल्‍सारी वाङ्‌तोःला भिसी थेनीगदेदा भिजी। ");
INSERT INTO taj_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","जमाहेन्‍से बारनाबासदेन पावलसे जम्‍मान मण्‍डलीरी मण्‍डलीदा च्‍याबा म्‍हिगदे धम्‍सी थान्‍जी। ओच्‍छे फोइथान चिसी प्रार्थना लसी थेनीगदेदा ह्राङसे विश्‍वास लबा प्रभुला छ्‌यारी जिम्‍मा पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","जमाहेन्‍से थेनीगदे पिसिदिया अञ्‍चलग्‍याम पामफिलिया भिबा अञ्‍चलरी खजी। ");
INSERT INTO taj_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ओच्‍छे पर्गा भिबा शहररी परमेश्‍वरला बचन थेःना लसी थेनीगदे अटालिया भिबा शहररी निजी। ");
INSERT INTO taj_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","थेनीगदे अटालियाग्‍याम पानी जहाजरी क्रेःसी एन्‍टिओखियारी दोःसी निजी। थेनोन शहररी पावलदेन बारनाबासदा प्रभुदा विश्‍वास लबा ज्‍योज्‍यो आलेगदेसे परमेश्‍वरला दयामायारी जिम्‍मा पिन्‍सी परमेश्‍वरला बचन थेःना लबारी पुइबा मुबा। दान्‍दे चु गे पावलदेन बारनाबाससे पूरा लजी। ");
INSERT INTO taj_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","एन्‍टिओखियारी धोखमाहेन्‍से पावलदेन बारनाबाससे मण्‍डलीला जम्‍मान म्‍हिगदेदा ङ्‌योइजी। ओच्‍छे परमेश्‍वर थेन्‍नीदेन छ्‌याम तसी लबा गेदेन अर्गु य्‍हुलला म्‍हिगदेसेनोन विश्‍वास लबारी खम्‍ला भिबा ताम थेनीगदेदा पाङ्सी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","जमाहेन्‍से थेनीगदे थेरी चेलागदेदेन छ्‌याम ल्‍हानान धिनधोना चिजी। ");
INSERT INTO taj_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","यहूदियाग्‍याम एन्‍टिओखियारी खबा कोइ कोइ म्‍हिगदेसे येशूदा विश्‍वास लबा ज्‍योज्‍यो आले नाना आङागदेदा “एनीगदेसे मोशाला ठिम अन्‍छार खतना आलनी भिसम एनीगदेसे थार्बा आयाङ्” भिसी लोप्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","पावलदेन बारनाबासला ताम थेनीगदेदेन छ्‌याम आढिक्‍बासे लमा थेनीगदेसे ह्राङ ह्राङलान ताम थान्‍जी। थेतबासेलमा पावलदेन बारनाबास ओच्‍छे कोइ कोइ विश्‍वासीगदेदा चु ताम सल्‍लाह लबारी यरूशलेमरी मुबा मुल चेलागदेदेन मण्‍डलीदा च्‍याबा म्‍हिगदे मुबा ग्‍लारी पुइबाला लागिरी धम्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","जमाहेन्‍से मण्‍डलीला म्‍हिगदेसे थेनीगदेदा थे ग्‍याम पुइजी। थेनीगदे फोनिकेदेन सामरियाग्‍याम तबान निबा धुइरी स्‍याप्‍बा विश्‍वासीगदेदा अर्गु य्‍हुलला म्‍हिगदेसेनोन प्रभुदा विश्‍वास लजी भिबा ताम पाङ्जी। चु ताम थेःसी थेरी मुबा विश्‍वासीगदे ल्‍हानान ताङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","थेनीगदे यरूशलेमरी धोखमाहेन्‍से थेनीगदेदा मण्‍डलीला म्‍हिगदेदेन मुल चेलागदे ओच्‍छे मण्‍डलीदा च्‍याबा म्‍हिगदेसे मान लजी। जमाहेन्‍से परमेश्‍वरसे थेनीगदेग्‍याम लबा जम्‍मान गे थेरी मुबागदेदा पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","जमाहेन्‍से फरिसी समूहला कोइ कोइ विश्‍वासीगदे राप्‍सी, “अर्गु य्‍हुलला म्‍हिगदेदाएनोन खतना लसी मोशाला ठिम अन्‍छार भ्रतोःला भिसी पाङ्तोःला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","चु तामला बारेरी सल्‍लाह लबाला लागिरी मुल चेलागदेदेन मण्‍डलीदा च्‍याबा म्‍हिगदे ह्रुप तजी। ");
INSERT INTO taj_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","थेनीगदे न्‍हङरी ल्‍हानान सल्‍लाह लसी जिन्‍माहेन्‍से पत्रुस राप्‍सी थेनीगदेदा चुह्रङ् भिबारी छ्‌याइजी, “आलेगदे, ल्‍हानान धुइ ङाच्‍छा अर्गु य्‍हुलला म्‍हिगदेसे ङाला सुङग्‍याम थोन्‍बा थार्बा पिन्‍बा समाचार थेःसी विश्‍वास लगै भिसी ह्राङनी न्‍हङ‍ग्‍याम परमेश्‍वरसे ङादा धम्‍बा ताम ह्राङनीदा थानोन मुला। ");
INSERT INTO taj_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ओच्‍छे परमेश्‍वर चा जम्‍मान म्‍हिला सेमला ताम था याङ्बा परमेश्‍वर हिन्‍ना। परमेश्‍वरसे य्‍हाङदा ह्रङ्नोन अर्गु य्‍हुलला म्‍हिगदेदाएनोन ह्राङला आत्‍मा पिन्‍सी थेनीगदे ङाला हिन्‍ना भिसी उन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ओच्‍छे परमेश्‍वरसे य्‍हाङदेन थेनीगदे खालैला ली आच्‍याना गे लसी थेनीगदेसे लबा विश्‍वासग्‍याम थेनीगदेला सेम साङसाङ तना लजी। ");
INSERT INTO taj_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","थेतबासेलमा तिग्‍दा अर्गु य्‍हुलला विश्‍वासीगदेदा चु धोइ काप्‍सी परमेश्‍वरदा बोमो खना लबारी म्‍हाइबा? तिग्‍दा भिसम चु धोइ य्‍हाङला आखे म्‍हेमेसेनोन पुइआखम्‍नी ओच्‍छे य्‍हाङसेनोन पुइआखम्‍नी। ");
INSERT INTO taj_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","तर य्‍हाङसे ह्रङ्नोन थेनीगदेसेनोन प्रभु येशूला दयामायाग्‍याम थार्बा याङ्बा मुला भिसी य्‍हाङसे विश्‍वास लबा मुला।” ");
INSERT INTO taj_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","पत्रुसला चुह्रङ्बा ताम थेःसी सभारी मुबा जम्‍मान म्‍हिगदे कुटिसी चिजी, ओच्‍छे अर्गु य्‍हुलला म्‍हिगदेला गुङरी परमेश्‍वरसे थेनीगदेग्‍याम खाह्रङ्बा उदेकला गेदेन चिनुगदे उन्‍बा ताम पावलदेन बारनाबाससे पाङ्‌मा थेनीगदे ङ्‌यान्‍सी चिजी। ");
INSERT INTO taj_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","पावलदेन बारनाबाससे पाङ्सी जिन्‍माहेन्‍से याकूबसे चुह्रङ् भिसी भिजी, “ज्‍योज्‍यो आलेगदे ङाला ताम ङ्‌यान्‍गो, ");
INSERT INTO taj_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","परमेश्‍वरसे दया लसी अर्गु य्‍हुलला म्‍हिगदेदा धम्‍सी ह्राङलान म्‍हि स्‍होजी। चु ताम मी सिमोनसे ह्राङदा दोलोन पाङ्सी जिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","चुनोन तामदेन छ्‌याम अगमवक्ताला बचनएनोन ढिक्‍मुला। परमप्रभुसे सुङ्बा ताम अगमवक्तासे चुह्रङ् लसी भ्रिबा मुला, ");
INSERT INTO taj_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘ङा दोःसी खला, ओच्‍छे दाऊदला फुप्‍बा दिम दोःसी स्‍होला, थेनोन फुप्‍बा दिमला जगथोरी दोःसी दिम स्‍होला, ");
INSERT INTO taj_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","थेह्रङ् लसीन बाँकी मुबा म्‍हिगदे ङा मुबा ग्‍लारी खगै, ओच्‍छे अर्गु य्‍हुलला म्‍हिगदेदाएनोन ङाला म्‍हि स्‍होबाला लागिरी ङाइ ङ्‌योइबा मुला। ");
INSERT INTO taj_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","चु ताम ङा परमप्रभुसे ल्‍हानान ङाच्‍छाहेन्‍सेन था तना लबा मुला।’ ");
INSERT INTO taj_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“थेतबासेलमा परमेश्‍वरपट्टि दोःबा अर्गु य्‍हुलला म्‍हिगदेदा य्‍हाङसे दुख आपिन्‍गे भिसी ङाइ म्‍हन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","तर य्‍हाङसे थेनीगदेदा चुह्रङ् भिसी भ्रिसी पुइगे, ‘एनीगदेसे मूर्तिदा फुल्‍बा स्‍हे थाचउ। ओच्‍छे स्‍य्‍हान्‍दोदेन छ्‌याम ब्रेल्‍सी थाभ्रउ, ओच्‍छे खारे च्‍यार्सी साइबा जन्‍तुला स्‍या थाचउ, ओच्‍छे तिगैलान का थाचउ।’ ");
INSERT INTO taj_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","तिग्‍दा भिसम ङाच्‍छाला म्‍हिगदेला धुइहेन्‍सेन जम्‍मान शहररी मोशाला ठिमग्‍याम लो‍प्बान मुला, चु ठिम चा ब्‍लप्‍बा न्‍हबा धिनरी यहूदीगदे ह्रुप तबा दिमरी पढब लमुबा।” ");
INSERT INTO taj_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","जमाहेन्‍से मुल चेलागदेदेन मण्‍डलीदा च्‍याबा म्‍हिगदे ओच्‍छे जम्‍मान मण्‍डली ढिक्‍सी ह्राङ न्‍हङला कोइ कोइ म्‍हिगदेदा धम्‍सी पावलदेन बारनाबासदा छ्‌यामनोन एन्‍टिओखियारी पुइबा ज्‍यबा तला भिसी म्‍हन्‍जी। ओच्‍छे विश्‍वासीगदे न्‍हङला मुल म्‍हिगदे यहूदा भिबा बारसाबासदेन सिलासदा धम्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","थेनीगदेदेन छ्‌याम चुह्रङ् भिसी भ्रिबा चिठी पुइजी, “ह्राङनीलान ज्‍योज्‍यो आले ङनी मुल चेलागदेदेन मण्‍डलीदा च्‍याबा म्‍हिगदेग्‍याम एन्‍टिओखियादेन सिरिया ओच्‍छे किलिकियारी मुबा अर्गु य्‍हुलला विश्‍वासीगदेदा फ्‍याफुल्‍ला। ");
INSERT INTO taj_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“ङनी न्‍हङला कोइ कोइसे ङन्‍से आपाङ्बा तामगदे ह्राङनीदा लोप्‍सी ह्राङनीला सेम धरमर तना लसी ह्राङनीदा ल्‍हानान तामग्‍याम दुख पिन्‍बा मुला भिबा ताम ङन्‍से थेःबा मुला। ");
INSERT INTO taj_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","थेतबासेलमा ङनी जम्‍मान ढिक्‍सी लबा सल्‍लाह अन्‍छार कोइ कोइ म्‍हिगदेदा धम्‍सी थेनीगदेदा ङन्‍ना सेम निबा ह्रो बारनाबास ओच्‍छे पावलदेन छ्‌याम ह्राङनी मुबा ग्‍लारी पुइखबा ज्‍यबा छोर्जी। ");
INSERT INTO taj_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","चुगदे चुह्रङ्बा म्‍हिगदे हिन्‍ना, चुगदेसे य्‍हाङला प्रभु येशू ख्रीष्‍टला लागिरी ह्राङला ज्‍याननोन पिन्‍बारी छ्‌याइबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","थेतबासेलमा ङन्‍से यहूदादेन सिलासदाएनोन पुइखबा मुला। थेनीगदेसेनोन चु ताम ह्राङनीदा पाङ्सी पिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","तिग्‍दा भिसम था ततोःबा ताम बाहेक अर्गु ल्‍हानान तामग्‍याम दुख आपिन्‍बा परमेश्‍वरला आत्‍मादेन ङन्‍दा ज्‍यबा छोर्जी। ");
INSERT INTO taj_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ह्राङनीदा था ततोःबा ताम चा चुनोन हिन्‍ना, ह्राङनीसे मूर्तिदा बलि पिन्‍बा तिगै स्‍हेगदे, कादेन खारे च्‍यार्सी साइबा जन्‍तुला स्‍या थासोल्‍गो, ओच्‍छे स्‍य्‍हान्‍दोदेन छ्‌याम ब्रेल्‍सी थाभ्रउ। चुह्रङ्बा तामगदेला संगतनोन आलनी भिसम ह्राङनीदा ज्‍यबा तला। दान्‍देदा चुदेन लास्‍सो फ्‍याफुल्‍ला।” ");
INSERT INTO taj_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","जमाहेन्‍से पावल, बारनाबास, यहूदादेन सिलास यरूशलेमग्‍याम एन्‍टिओखिया शहररी निजी। थेरी थेनीगदेसे विश्‍वासीगदेदा ग्‍ला गिकरी ङ्‌योइसी थेनीगदेदा थे चिठी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","चिठीरी भ्रिबा आँट पिन्‍बा ताम पढब लसी एन्‍टिओखियाला विश्‍वासीगदे ल्‍हानान ताङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","यहूदादेन सिलास चा अगमवक्ता मुबा। थेन्‍नीसे प्रभुदा विश्‍वास लबा ज्‍योज्‍यो आले नाना आङागदेदा बचनग्‍याम ल्‍हानान आँट पिन्‍सी विश्‍वासरी कोङ्‌ना लजी। ");
INSERT INTO taj_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","थेनीगदे तिगै रेधोना थेरी चिमाहेन्‍से थेरी मुबा आलेगदेसे थेनीगदेदा पुइखबागदे मुबा ग्‍लारी ढुक्‍क तसी फेप्‍गो भिसी पुइजी। ");
INSERT INTO taj_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","तर सिलासदा चा थेरीन चिबा ज्‍यबा छोर्जी। ");
INSERT INTO taj_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","तर पावलदेन बारनाबास चा म्‍हिगदेदा लोप्‍बादेन प्रभुला बचन थेःना लबान ल्‍हानान म्‍हिगदेदेन छ्‌याम एन्‍टिओखियारी चिजी। ");
INSERT INTO taj_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","तिगै धिन लिच्‍छा पावलसे बारनाबासदा “य्‍हाङसे ङाच्‍छा प्रभुला बचन थेःना लबा शहरला विश्‍वासीगदेदा दोःसी स्‍याप्‍बारी निइ ओच्‍छे थेनीगदे खाह्रङ्बा चीम च्‍यागे” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","बारनाबाससे मर्कूस भिबा यूहन्‍नादा भोर्बा सेम लजी। ");
INSERT INTO taj_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","तर पावलदा चा मर्कूसदा छ्‌यामनोन भोर्बारी ज्‍यबा आछोर्नी, तिग्‍दा भिसम पामफिलियारी मुबा धुइरी मर्कूस थेनीगदेग्‍याम फेसी निमुबा, ओच्‍छे थेनीगदेदेन छ्‌याम ढिक्‍सी गे लबा आरेमुबा। ");
INSERT INTO taj_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","चु तामरी पावलदेन बारनाबासला ताम आढिक्‍ना थेन्‍नी फेजी। ओच्‍छे बारनाबाससे मर्कूसदा भोर्सी पानी जहाजरी क्रेःसी साइप्रस भिबा ग्‍लारी निजी। ");
INSERT INTO taj_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","तर पावलसे चा सिलासदा धम्‍जी, ओच्‍छे प्रभुदा विश्‍वास लबा आलेगदेसे थेन्‍नीदा परमेश्‍वरला छ्‌यारी जिम्‍मा पिन्‍माहेन्‍से थेन्‍नी थेग्‍याम निजी। ");
INSERT INTO taj_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","पावलदेन सिलास सिरियादेन किलिकियारी निसी थेरी मुबा मण्‍डलीगदेदा विश्‍वासरी कोङ्‌ना लबान भ्रजी। ");
INSERT INTO taj_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","पावल डर्बीदेन लुस्‍त्रा शहररीएनोन खजी। थेरी तिमोथी भिबा चेला गिक मुबा। थेला आमा यहूदी विश्‍वासी मुबा, तर आबा चा ग्रीक मुबा। ");
INSERT INTO taj_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","लुस्‍त्रादेन आइकोनियन शहरला ज्‍योज्‍यो आले नाना आङागदेसे तिमोथीदा ज्‍यबा म्‍हि भिसी पाङ्मुबा। ");
INSERT INTO taj_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","पावलसे तिमोथीदाएनोन छ्‌यामनोन भोर्बा सेम लजी। ओच्‍छे थेरी चिबा यहूदीगदेसे लमा पावलसे थेदा भोर्सी खतना लसी पिन्‍जी। तिग्‍दा भिसम थेला आबा ग्रीक हिन्‍ना भिसी थेनीगदेदा था मुबा। ");
INSERT INTO taj_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","जमाहेन्‍से थेनीगदे शहर शहररी निबान यरूशलेमरी मुबा मुल चेलागदेदेन मण्‍डलीदा च्‍याबा म्‍हिगदेसे पक्‍का लबा ताम ङ्‌यान्‍गो भिसी पाङ्‌बान भ्रजी। ");
INSERT INTO taj_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","थेतबासेलमा मण्‍डलीगदे विश्‍वासरी कोङ्बान धिन धिननोन प्रभुदा विश्‍वास लबा म्‍हिगदे बढब तबान निजी। ");
INSERT INTO taj_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","परमेश्‍वरला आत्‍मासे पावल, सिलासदेन तिमोथीदा एशियारी बचन थेःना लआपुङ्‌बासे लमा थेनीगदे फ्रिगियादेन गलातियाला ग्‍लागदे तबान निजी। ");
INSERT INTO taj_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","माइसिया भिबा ग्‍लाला साँधरी धोखमाहेन्‍से थेनीगदे बिथिनिया भिबा ग्‍लापट्टि निबारी म्‍हाइजी। तर येशूला आत्‍मासे थेनीगदेदा थेपट्टि निआपुङ्‌नी। ");
INSERT INTO taj_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","थेतबासेलमा माइसिया तबान थेनीगदे त्रोआस भिबा ग्‍लारी निजी। ");
INSERT INTO taj_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","म्‍हुनङ म्‍हेर्बा धुइरी पावलसे माकेडोनियाला म्‍हि गिक राप्‍सी थेदा “माकेडोनियारी फेप्‍खउ ओच्‍छे ङन्‍दा ह्रो लसी पिन्‍गो” भिसी बिन्‍ती लसी चिबा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","थेसे चुह्रङ्बा म्राङ्माहेन्‍से ङनी माकेडोनियारी निबारी तयार तजी। तिग्‍दा भिसम थे ग्‍लाला म्‍हिगदेदा थार्बा पिन्‍बा समाचार थेःना लबारी परमेश्‍वरसे ङन्‍दा ङ्‌योइजीम भिबा ताम ङन्‍से था याङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","जमाहेन्‍से ङनी त्रोआसग्‍याम पानी जहाजरी क्रेःसी सोजोन सामोथ्रेस भिबा ग्‍लारी खजी, ओच्‍छे न्‍हङगरदङ नियापोलिस भिबा ग्‍लारी धोखजी। ");
INSERT INTO taj_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","थेग्‍याम माकेडोनियाला घ्रेन शहर फिलिप्‍पीरी निजी। थे शहररी चा रोमीगदेसे शासन लमुबा। थेरीन ङनी तिगै रेधोना चिजी। ");
INSERT INTO taj_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ब्‍लप्‍बा न्‍हबा धिनकुनु ङनी शहरग्‍याम थोन्‍सी स्‍योङला कुनीरी निजी। तिग्‍दा भिसम थेरी प्रार्थना लबा ग्‍ला मुला तला भिसी ङन्‍से म्‍हन्‍बा मुबा, थेरी कोइ कोइ म्रिङम्‍हेमेगदे ह्रुप तसी चिबा स्‍याप्‍जी। थेतबासेलमा ङनीएनोन थेनीगदेदेन छ्‌याम चिसी ताम लजी। ");
INSERT INTO taj_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","थेरी ङन्‍ना ताम ङ्‌यान्‍बागदे न्‍हङरी थिआटीरा भिबा शहररी चिबा वाला वाला पिङगै छोनना क्‍वान चूङ्बा परमेश्‍वरदा तेन्‍बा लिडिया भिबा म्रिङम्‍हेमे गिक मुबा। पावलसे पाङ्‌मा ज्‍यना लसी ङ्‌यान्‍सी घोखम्‍गै भिबा सेम प्रभुसे थेदा पिन्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","थेदेन थेला दिमला जम्‍मान म्‍हेमेगदेसे बप्‍तिस्‍मा किन्‍माहेन्‍से थेसे “चुदे ह्राङनीसे ङादा प्रभुदा विश्‍वास लबा म्‍हि म्‍हन्‍सम ङाला दिमरी फेप्‍खसी धन्‍छ्‌यागो” भिसी ङन्‍दा कर लसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ङनी प्रार्थना लबा ग्‍लारी निबान मुबा, थेरी ङन्‍से म्‍हङसे स्‍याप्‍बा नोकर स्‍या गिकदा स्‍याप्‍जी, थेसे थे म्‍हङला शक्तिग्‍याम म्‍हुदु च्‍यासी स्‍होबा ल्‍हानान टाङगा ह्राङला मालिकगदेदा पिन्‍मुबा। ");
INSERT INTO taj_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ओच्‍छे थे नोकरस्‍यासे “चु म्‍हिगदे शक्तिशाली परमेश्‍वरला गे लबा म्‍हिगदे हिन्‍ना। चुगदेसे एनीगदेदा थार्बा याङ्बा ग्‍यामला बारेरी पाङ्‌बान मुला” भिसी क्रिङ्‌बान पावलदेन छ्‌याम ङन्‍ना लिच्‍छा लिच्‍छा भ्रजी। ");
INSERT INTO taj_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","थे नोकरस्‍यासे ल्‍हानान धिनधोना चुह्रङ् पाङ्‌बाला पाङ्‌बान लबासे लमा पावल छेर्सी थेपट्टि फ्‍लिक दोःसी थे नोकरस्‍याला ल्‍हुइरी मुबा म्‍हङदा चुह्रङ् भिसी भिजी, “ए थेला ल्‍हुइग्‍याम येशू ख्रीष्‍टला मिनरी थोन्‍सी निउ भिसी ङाइ कुल्‍बा मुला।” पावलसे थेह्रङ् भिमैछ्‌याम थे म्‍हङ थोन्‍सी निजी। ");
INSERT INTO taj_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","थे नोकरस्‍याला मालिकगदेसे दाहेन्‍से चुला कमाइ चआम्‍याङनम भिबा म्राङ्सी पावलदेन सिलासदा चुङ्सी बजारला गुङरी मुबा नेतागदे मुबा ग्‍लारी डुइबा छेङ्‌बा लबान भोर्जी। ");
INSERT INTO taj_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ओच्‍छे थेनीगदेदा थे शहरला हाकिमगदे मुबा ग्‍लारी भसी चुह्रङ् भिसी भिजी, “चु म्‍हिगदे यहूदी हिन्‍ना, चुगदेसे य्‍हाङला शहररी आतोःबा ताम लोप्‍सी ङन्‍दा कोल्‍ना लजी। ");
INSERT INTO taj_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ओच्‍छे थेनीगदेसे य्‍हाङला ठिमसे लोप्‍बारी आतबा ताम लोप्‍बा मुला य्‍हाङ रोमी म्‍हिगदे तबासे लमा थेन्‍से लोप्‍बा ताम य्‍हाङसे विश्‍वास लसी ङ्‌यान्‍बारी आत।” ");
INSERT INTO taj_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","जमाहेन्‍से थेरी मुबा म्‍हिगदे पावलदेन सिलासला बिरोधरी रेःजी। थे शहरला हाकिमगदेसे थेनीगदेला क्‍वान ढेसी भ्‍याङ्‍जी, ओच्‍छे थेनीगदेदा तोउ भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","थेनीगदेदा ल्‍हानान तोमाहेन्‍से झ्‍याल्‍खानरी झाङ्‌सी झ्‍याल्‍खानना हाकिमदा चु कैदीगदेदा यार्बारी आखम्‍ना लसी थान्‍गो भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","चुह्रङ् भिमाहेन्‍से थे झ्‍याल्‍खानना हाकिमसे पावलदेन सिलासदा झ्‍याल्‍खानना न्‍हङला कोठारी भोर्सी ठिँगुरो लगब लसी थान्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","तर म्‍हुन गङसलरीक्‍यार पावलदेन सिलास प्रार्थना लबान परमेश्‍वरला व्‍हाइ गोबान मुबा, ओच्‍छे स्‍य्‍हान्‍दो कैदीगदेसे चा ङ्‌यान्‍बान मुबा। ");
INSERT INTO taj_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","जमाहेन्‍से थेरी तिक्‍खुरीन घ्रेन सङगुल खसी झ्‍याल्‍खानना जग य्‍हङ य्‍होङ तसी तुरुन्‍तन झ्‍याल्‍खानना म्रापगदे ठोङ्‌जी। ओच्‍छे थेनीगदे जम्‍मादान खीबा स्‍हेगदेएनोन ह्रङ्नोन ब्‍लजी। ");
INSERT INTO taj_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","थे झ्‍याल्‍खानना हाकिम फातछोर्मा झ्‍याल्‍खानना जम्‍मान म्राप ठोङ्‌बा म्राङ्सी थेसे जम्‍मान कैदीगदे यार्जी भिसी म्‍हन्‍सी ह्राङसे ह्राङदान साइबारी तरवार स्‍याजी। ");
INSERT INTO taj_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","तर पावलसे थेदा “ह्राङसे ह्राङदान तिगै थालउ, तिग्‍दा भिसम ङनी जम्‍मान चुरीन मुला” भिसी घ्रेन काइसे क्रिङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","जमाहेन्‍से थेसे नाङसल ह्रीसी छ्‌योङ्बान न्‍हङरी खजी, थे लोङ्सी फितफित धर्बान पावलदेन सिलासला ङाच्‍छापट्टि ख्‍लुप तजी। ");
INSERT INTO taj_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ओच्‍छे थेसे थेनीगदेदा मङग्‍यार भसी, “दाहेन्‍से ङाइ थार्बा याङ्बारी तिग लतोःला?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","पावलदेन सिलाससे “प्रभु येशू ख्रीष्‍टदा विश्‍वास लउ, ओच्‍छे ह्राङदेन ह्राङला जम्‍मान म्‍हेमेगदेसे थार्बा याङ्ला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","जमाहेन्‍से थेनीगदेसे थेदेन थेला दिमरी मुबा जम्‍मादान प्रभुला बचन थेःना लजी। ");
INSERT INTO taj_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","जमाकुनु म्‍हुनङला थेनोन धुइरी थेसे थेनीगदेदा भोर्सी थेनीगदेला पोर ख्रुसी पिन्‍जी। ओच्‍छे थेदेन थेला दिमरी मुबा जम्‍मासेन तुरुन्‍तन बप्‍तिस्‍मा किन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","जमाहेन्‍से थे झ्‍याल्‍खानना हाकिमसे पावलदेन सिलासदा ह्राङला दिमरी भसी सोल पिन्‍जी। ओच्‍छे थेसे परमेश्‍वरदा विश्‍वास लबासे लमा थेला दिमरी मुबा जम्‍मान म्‍हिगदे विश्‍वास लसी थेदेन छ्‌याम ल्‍हानान ताङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","तर य्‍हाल तमाहेन्‍से शहरला हाकिमगदेसे सिपाहीगदेदा “थे म्‍हिगदेदा पुइसी पिन्‍गो” भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","जमाहेन्‍से झ्‍याल्‍खानना हाकिमसे पावलदा “शहररी मुबा हाकिमगदेसे ह्राङनीदा पुइसी पिन्‍गो भिसी पाङ्बा मुला। थेतबासेलमा दाहेन्‍से ह्राङनी थोन्‍सी ढुक्‍क तसी फेप्‍गो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","तर पावलसे थे खबर भसी खबा सिपाहीगदेदा “ङनी रोमी म्‍हि तना तनान थेनीगदेसे रोमी ठिम अन्‍छार ङन्‍दा तिगै ङ्‌योइबा छार्बा आलना तोसी झ्‍याल्‍खानरी झाङ्‌जी। दान्‍दे चा ङन्‍दा सुटुक्‍क तेःबारी म्‍हाइबा? ङनी नीनोन आनि। थेह्रङ् भिसी कुल्‍बा हाकिमगदेन छ्‌याम खसी ङन्‍दा तेःतोःला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","जमाहेन्‍से सिपाहीगदे हाकिमगदे मुबा ग्‍लारी निसी पावलसे पाङ्बा ताम पाङ्जी। पावलदेन सिलास रोमी म्‍हि चीम भिबा थेःसी थेनीगदे लोङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","जमाहेन्‍से थेनीगदे खसी पावलदेन सिलासदा माफ ह्रीजी, ओच्‍छे पावलदेन सिलासदा झ्‍याल्‍खानग्‍याम मङग्‍यार भोर्सी, “ङन्‍ना शहर ख्‍लासी फेप्‍गो” भिसी बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","झ्‍याल्‍खानग्‍याम थोन्‍माहेन्‍से पावलदेन सिलास लिडिया भिबा म्रिङम्‍हेमेला दिमरी निजी। थेरी प्रभुदा विश्‍वास लबा ज्‍योज्‍यो आले नाना आङागदेदेन छ्‌याम ह्रुप तसी थेनीगदेदा प्रभुरी कोङ्‌सी चिउ भिसी आँट पिन्‍सी पावलदेन सिलास थेग्‍याम निजी। ");
INSERT INTO taj_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","जमाहेन्‍से पावलदेन सिलास अम्‍फिपोलिसदेन अ‍पोल्‍लोनिया भिबा शहरग्‍याम तबान थेसलोनिके भिबा शहररी खजी। थेरी यहूदीगदे ह्रुप तबा दिम गिक मुबा। ");
INSERT INTO taj_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","सदला ह्रङ्नोन लसी पावल थेनीगदे मुबा ग्‍लारी निजी, ओच्‍छे सोमरेम ब्‍लप्‍बा न्‍हबा धिनधोना परमेश्‍वरला बचनग्‍याम थेनीगदेदेन छ्‌याम छलफल लजी। ");
INSERT INTO taj_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","थेसे परमेश्‍वरला बचनग्‍याम ख्रीष्‍टसे दुख नासी सिबाग्‍याम सोनोन तोःला भिसी प्रस्‍टन उन्‍सी घोना लजी। “चुनोन येशू थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍ना भिसी ङाइ ह्राङनीदा पाङ्‌बान मुला,” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","जमाहेन्‍से थेनीगदे न्‍हङला कोइ कोइ म्‍हिगदेसे प्रभुदा विश्‍वास लजी। ओच्‍छे परमेश्‍वरदा तेन्‍बा ल्‍हानान ग्रीकगदेदेन स्‍य्‍हान्‍दोसे मान लबा ल्‍हानान म्रिङम्‍हेमेगदेसेनोन प्रभुदा विश्‍वास लसी पावल, सिलासदेन छ्‌याम ढिक्‍सी भ्रजी। ");
INSERT INTO taj_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","तर यहूदीगदेसे डाह लसी गे आलना न्‍होङ्‌सी भ्रबा म्‍हिगदेदा थीसी शहररी हुल दङगा लपुङ्‌जी, ओच्‍छे यासोन भिबा म्‍हिला म्राप झ्‍याल छ्‌याकछिक लसी पावलदेन सिलासदा म्‍हिगदेला ङाच्‍छापट्टि भबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","थेनीगदेसे पावलदेन सिलासदा आस्‍याप्‍माहेन्‍से यासोनदेन स्‍य्‍हान्‍दो कोइ कोइ ज्‍योज्‍यो आलेगदेदा शहररी मुबा शासन लबा म्‍हिगदे मुबा ग्‍लारी डुइबा छेङ्‌बा लसी चुह्रङ् भिसी क्रिङ्‌बान भिजी, “जम्‍बुलिङ नाङनोन हल्‍ली खल्‍ली तना लबा चु म्‍हिगदे चुरीनोन धोखजीम। ");
INSERT INTO taj_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","थे म्‍हिगदे यासोनना डोन्‍बो दोबा मुला, थेनीगदे जम्‍मासेन येशू भिबा स्‍य्‍हान्‍दोन ग्‍ले गिक मुला भिसी रोमी ग्‍याल्‍बो कैसरला ठिम अन्‍छार लतोःबा गेला बिरोध लबा मुला।” ");
INSERT INTO taj_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","चु थेःसी म्‍हिगदेदेन शहररी मुबा शासन लबा म्‍हिगदे आत्‍यब तजी। ");
INSERT INTO taj_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","जमाहेन्‍से यासोन ओच्‍छे थेदेन छ्‌याम मुबा बाँकी म्‍हिगदेदेन छ्‌याम धरौटी किन्‍सी पुइजी। ");
INSERT INTO taj_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","म्‍हुन तमैछ्‌याम पावलदेन सिलासदा विश्‍वासीगदेसे बेरिया भिबा ग्‍लारी पुइजी, ओच्‍छे थेनीगदे थेरी धोखमाहेन्‍से यहूदीगदे ह्रुप तबा दिमरी निजी। ");
INSERT INTO taj_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","थे ग्‍लाला यहूदीगदे थेसलोनिकेला म्‍हिगदे भन्‍दा ल्‍हानान फर्स्‍यालो मुबा। तिग्‍दा भिसम थेनीगदेसे परमेश्‍वरला बचन सेम लसी ङ्‌यान्‍मुबा, ओच्‍छे पावलसे पाङ्‌मा ढिक्‍बा चीम कि आढिक्‍बा चीम भिसी सदन परमेश्‍वरला बचनरी च्‍यामुबा। ");
INSERT INTO taj_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","थेतबासेलमा ल्‍हानान म्‍हिगदेसे प्रभुदा विश्‍वास लजी। ओच्‍छे स्‍य्‍हान्‍दोसे मान लबा ल्‍हानान ग्रीक म्रिङम्‍हेमेगदेदेन ह्रेम्‍फेबेगदेसेनोन प्रभुदा विश्‍वास लजी। ");
INSERT INTO taj_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","तर परमेश्‍वरग्‍यामला बचन बेरिया भिबा ग्‍लारीनोन पावलसे थेःना लबान मुला भिबा थेसलोनिकेला यहूदीगदेसे था याङ्माहेन्‍से थेनीगदे थेरीनोन हुल दङगा लबारी म्‍हिगदेदा सुर्‍याब लबारी खजी। ");
INSERT INTO taj_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","जमाहेन्‍से विश्‍वासीगदेसे पावलदा तुरुन्‍तन समुन्‍द्रधोना सनिजी। तर सिलासदेन तिमोथी चा थेरीन चिजी। ");
INSERT INTO taj_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","पावलदा सबारी निबागदेसे पावलदा एथेन्‍स भिबा ग्‍लाधोना सनिजी। थेरी धोमाहेन्‍से पावलसे सिलासदेन तिमोथीदा खम्‍तेधोना योना खउ भिउ भिसी पाङ्‍गो भिसी कुल्‍जी। जमाहेन्‍से थेदा सबागदे थेग्‍याम बेरियारी दोःसी निजी। ");
INSERT INTO taj_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","सिलासदेन तिमोथीदा पावलसे एथेन्‍स भिबा ग्‍लारी भ्रान्‍सी चिमा थेसे थे शहर नाङनोन लथाननोन लथान म्राङ्सी थेदा ल्‍हानान दुख ङ्‌हम्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","थेतबासेलमा थेसे यहूदीगदे ह्रुप तबा दिमरी परमेश्‍वरदा तेन्‍बा म्‍हिगदे, यहूदीगदेदेन छ्‌याम ओच्‍छे बजाररी स्‍याप्‍बा म्‍हिगदेदेन छ्‌याम धिन धिननोन ङ्‌योइबा छार्बा लमुबा। ");
INSERT INTO taj_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","इपिक्‍युरीदेन स्‍तोइ भिबा धर्म तेन्‍बा म्‍हिगदेसेनोन थेदेन छ्‌याम ङ्‌योइबा छार्बा लजी। ओच्‍छे थेनीगदे न्‍हङला कोइ कोइसे “चु फतफतेसे तिग पाङ्‌बारी म्‍हाइबा हिन्‍ना?” भिसी भिमा, स्‍य्‍हान्‍दोगदेसे “चुसे अर्गु य्‍हुल्‍साला ल लुला बारेरी पाङ्बा ह्रङ्‌बा मुला” भिसी भिजी। तिग्‍दा भिसम थेसे येशूदेन छ्‌याम सिबागदे दोःसी सोला भिबा तामला बारेरी पाङ्‌बान मुबा। ");
INSERT INTO taj_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","थेतबासेलमा थेनीगदेसे पावलदा अरियोपागसरी भोर्सी चुह्रङ् भिसी भिजी, “ह्राङसे लोप्‍बा चु छार ताम खाह्रङ्बा हिन्‍ना, ङन्‍सेनोन घोबारी तला? ");
INSERT INTO taj_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","तिग्‍दा भिसम ह्राङसे ङन्‍दा उदेकला ताम लोप्‍बान मुला। थेतबासेलमा चु खाह्रङ्बा ताम हिन्‍ना थे ताम ङन्‍दाएनोन घोबा सेम मुला।” ");
INSERT INTO taj_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","दान्‍दे एथेन्‍सला जम्‍मान म्‍हिगदेदेन थे ग्‍लारी चिबा अर्गु य्‍हुल्‍साला म्‍हिगदे छार छार ताम पाङ्‌बादेन ङ्‌यान्‍सीन धिन निना लमुबा। ");
INSERT INTO taj_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","थेतबासेलमा पावलसे अरियोपागस भिबा सभाला गुङरी राप्‍सी चुह्रङ् भिसी भिजी, “एथेन्‍सला म्‍हिगदे, ह्राङनी जम्‍मान तामरी धर्म लबा चीम भिसी ङाइ म्राङ्बा मुला। ");
INSERT INTO taj_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","तिग्‍दा भिसम ङा कोर्बान निमा ह्राङनीसे तेन्‍बा लथानगदे म्राङ्जी। ओच्‍छे ग्‍ला गिकला भेटी फुल्‍बा ग्‍लारी चा ‘ङोआसेबा लला लागिरी’ भिसी ठ्वाइसी भ्रिसी थान्‍बाएनोन स्‍याप्‍जी। थेतबासेलमा ङाइ ह्राङनीसे ङोआसेनान तेन्‍बा परमेश्‍वरला बारेरी ह्राङनीदा पाङ्ला। ");
INSERT INTO taj_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“चु जम्‍बुलिङदेन जम्‍बुलिङरी मुबा जम्‍मान स्‍हे स्‍होबा परमेश्‍वर स्‍वर्गदेन जम्‍बुलिङला प्रभु हिन्‍ना, थेतबासेलमा यासे स्‍होबा मन्‍दिररी परमेश्‍वर धन्‍आछ्‌या। ");
INSERT INTO taj_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ओच्‍छे म्‍हिला याग्‍याम फुल्‍बा स्‍हेगदे परमेश्‍वरदा तोःला भिसी थाम्‍हन्‍गो। तिग्‍दा भिसम परमेश्‍वर ह्राङसेन जम्‍मान म्‍हिगदेदा जुनी, सादेन तोःबा जम्‍मान स्‍हेगदे पिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","परमेश्‍वरसे म्‍हि गिकग्‍याम जम्‍बुलिङ नाङनोन चिबारी य्‍हुल य्‍हुलला म्‍हिगदे स्‍होजी। ओच्‍छे थेनीगदे सोबा धुइदेन चिबा ग्‍लाएनोन तोगब लसी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","चुह्रङ् लबा चा जम्‍मान य्‍हुलला म्‍हिगदेसे परमेश्‍वरदा आस्‍याप्‍तेधोना साम्‍सी म्‍हाइसी स्‍याप्‍गै भिबा परमेश्‍वरला सेम मुला। तसैनोन परमेश्‍वर य्‍हाङ जम्‍मानग्‍याम थारेङ आरे। ");
INSERT INTO taj_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","तिग्‍दा भिसम परमेश्‍वर य्‍हाङदेन छ्‌यामनोन मुबासे लमा य्‍हाङ सोबा मुला, य्‍हाङ क्‍यारमार भ्रबा मुला ओच्‍छे य्‍हाङ जम्‍बुलिङरी मुला। ह्राङनीलान व्‍हाइ भ्रिबा म्‍हिगदेसेनोन ‘य्‍हाङ पक्‍कान परमेश्‍वरला सन्‍तान हिन्‍ना’ भिसी भिबा मुला। ");
INSERT INTO taj_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","य्‍हाङ परमेश्‍वरला सन्‍तान तबासे लमा परमेश्‍वर म्‍हर, म्‍हुइदेन युङबागदेला ल ह्रङ्‌बा हिन्‍ना भिसी य्‍हाङसे म्‍हन्‍बारी आत। चुगदे चा म्‍हिला सेमसे म्‍हन्‍सी म्‍हिला सीपसे स्‍होबा स्‍हे जे हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","थेतबासेलमा ङाच्‍छा आसेना आघोना लबा धुइला गेदा परमेश्‍वरसे वास्‍ता आलनी। तर दाहेन्‍से परमेश्‍वरसे जम्‍मान म्‍हिगदेदा “ह्राङ ह्राङला पापगदे ख्‍लासी ङापट्टि दोःगो” भिसी कुल्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","तिग्‍दा भिसम परमेश्‍वर ह्राङसेन धम्‍बा म्‍हिग्‍याम खालैला ली आच्‍याना जम्‍बुलिङला निसाफ लबारी परमेश्‍वरसे थे धिन तोगब लसी जिन्‍बा मुला। ओच्‍छे जम्‍मान म्‍हिगदेदा चु धिन उन्‍बाला लागिरी येशूदा सिबाग्‍याम सोना लजी।” ");
INSERT INTO taj_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","सिबाग्‍याम सोना लजी भिबा ताम थेःसी थेनीगदे न्‍हङला कोइ कोइसे पावलदा खिसी लजी। तर स्‍य्‍हान्‍दोगदेसे चा “ह्राङसे पाङ्बा चु ताम ङन्‍दा दोःसी ङ्‌यान्‍बा सेम मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","जमाहेन्‍से पावल सभाग्‍याम थोन्‍सी निजी। ");
INSERT INTO taj_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","तर कोइ कोइ म्‍हिगदे थेदेन छ्‌याम भ्रसी प्रभुदा विश्‍वास लजी। थेनीगदे न्‍हङला अरियोपागस भिबा सभाला डियनुसियस भिबा म्‍हिदेन दामारिस भिबा म्रिङम्‍हेमे गिक मुबा ओच्‍छे स्‍य्‍हान्‍दोगदेसेनोन प्रभुदा विश्‍वास लजी। ");
INSERT INTO taj_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","जमाहेन्‍से पावल एथेन्‍सग्‍याम कोरिन्‍थ भिबा ग्‍लारी निजी। ");
INSERT INTO taj_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","थेरी पावलसे पोन्‍टस भिबा ग्‍लाला अकिलास भिबा यहूदी म्‍हि गिकदा स्‍याप्‍जी। थे म्‍हि तिगै धिन ङाच्‍छा जे ह्राङला म्रिङ प्रिस्‍किलादेन छ्‌याम इटालिया भिबा ग्‍लाग्‍याम खबा मुबा। तिग्‍दा भिसम क्‍लौडियस भिबा ग्‍याल्‍बोसे जम्‍मान यहूदीगदेदा रोमग्‍याम थोन्‍सी निउ भिसी कुल्‍बा मुबा। पावल थेनीगदेदा स्‍याप्‍बारी निजी। ");
INSERT INTO taj_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","पावलदेन थेनीगदेला गे गिकनोन तबासे लमा थेनीगदे छ्‌यामनोन चिजी। तिग्‍दा भिसम थेनीगदेएनोन पाल स्‍होबा गे लमुबा। ");
INSERT INTO taj_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ब्‍लप्‍बा न्‍हबा धिनदङसेन पावल यहूदीगदे ह्रुप तबा दिमरी निसी छलफल लमुबा, ओच्‍छे यहूदीदेन ग्रीकगदेदा घोना लबारी म्‍हाइमुबा। ");
INSERT INTO taj_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","सिलासदेन तिमोथी माकेडोनियाग्‍याम खबा धुइरी पावल परमेश्‍वरला बचन थेःना लबा गे लबादेन यहूदीगदेदा येशून थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍ना भिसी घोना लबा गे जे लमुबा। ");
INSERT INTO taj_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","तर यहूदीगदेसे पावलला बिरोध लबान तामगन लबारी छ्‌याइजी, जमाहेन्‍से पावलसे ह्राङला क्‍वान खर्सी, “एनीगदे ह्राङलान दोषसे लमा नाश तजी भिसम चुला दोष ङादा लगब आत। दाहेन्‍से, ङा अर्गु य्‍हुलला म्‍हिगदे मुबा ग्‍लारी निला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","जमाहेन्‍से पावल थेग्‍याम परमेश्‍वरदा तेन्‍बा तीतस युस्‍तस भिबा म्‍हिला दिमरी निजी। थेला दिम यहूदीगदे ह्रुप तबा दिमला ङामरीन मुबा। ");
INSERT INTO taj_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","थेरी यहूदीगदे ह्रुप तबा दिमला नेता क्रिस्‍पसदेन थेला दिमरी मुबा जम्‍मान म्‍हिगदेसे प्रभुदा विश्‍वास लजी, ओच्‍छे कोरिन्‍थला म्‍हिगदे न्‍हङला ल्‍हानान म्‍हिगदेसे पावलसे पाङ्बा परमेश्‍वरला बचन ङ्‌यान्‍सी विश्‍वास लसी बप्‍तिस्‍मा किन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","तिरेकुनु म्‍हुनङ म्‍हेर्बा धुइरी म्‍हाङरी पावलदा प्रभुसे चुह्रङ् भिसी भिजी, “ए थालोङ्‍गो, तर पाङ्‌बान निउ, ओच्‍छे कुटिसी थाचिउ। ");
INSERT INTO taj_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","तिग्‍दा भिसम ङा एदेन छ्‌याम मुला। थेतबासेलमा एदा खालैसे तिगै लआखम, तिग्‍दा भिसम चु शहररी ङाला म्‍हिगदे ल्‍हानान मुला।” ");
INSERT INTO taj_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","थेतबासेलमा परमेश्‍वरला बचन लोप्‍बान पावल दिङ गिकसे ला ढुधोना थेनीगदेदेन छ्‌यामनोन चिजी। ");
INSERT INTO taj_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","तर अखैया भिबा ग्‍लाला नेता गलियोनना धुइरी जम्‍मान यहूदीगदे ढिक्‍सी पावलदा चुङ्सी अदालतरी भोर्जी, ");
INSERT INTO taj_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ओच्‍छे चुह्रङ् भिसी भिजी, “चु म्‍हिसे मोशाला ठिमला बिरोध लसी परमेश्‍वरदा तेन्‍गो भिसी म्‍हिगदेदा व्‍हाम्‍बान लोप्‍बा मुला।” ");
INSERT INTO taj_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","पावलसे ताम पाङ्‌बारी छ्‌याइमा गलियोनसे थे यहूदीगदेदा चुह्रङ् भिसी भिजी, “यहूदीगदे, चुदे चु ताम अन्‍यायदेन आज्‍यबा गेला बारेरी हिन्‍सम ङाइ एनीगदेला ताम ङ्‌यान्‍नोन तोःबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","तर एनीगदेसे पाङ्बा चु तामदेन मिन मोशासे पिन्‍बा एनीगदेलान ठिमला बारेरी तबासे लमा एनीगदेसेन ढिक्‍ना लउ। चुह्रङ्बा तामला निसाफ चा ङाइ आल।” ");
INSERT INTO taj_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","जमाहेन्‍से गलियोनसे थेनीगदेदा अदालतग्‍याम तेःजी। ");
INSERT INTO taj_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","जमाहेन्‍से थेनीगदे जम्‍मासेन यहूदीगदे ह्रुप तबा दिमला सोस्‍थेनेस भिबा नेतादा चुङ्सी अदालत न्‍हङरीन तोजी। तर गलियोनसे थे तामला तिगै वास्‍ता आलनी। ");
INSERT INTO taj_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","पावल कोरिन्‍थरी तिगै धिनधोना चिजी। जमाहेन्‍से विश्‍वासीगदेग्‍याम फेसी पावल पानी जहाजरी क्रेःबारी किंक्रिया भिबा ग्‍लारी निजी। थेदेन छ्‌याम प्रिस्‍किलादेन अकिलासएनोन मुबा। सिरिया भिबा ग्‍लारी निबाला लागिरी पानी जहाजरी क्रेःबा भन्‍दा ङाच्‍छा ह्राङसे लबा कबुल पूरा लबाला लागिरी किंक्रिया भिबा ग्‍लारी पावलसे ह्राङला क्रा भ्रेजी। ");
INSERT INTO taj_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","जमाहेन्‍से थेनीगदे एफिसस भिबा ग्‍लारी धोखजी, ओच्‍छे पावलसे प्रिस्‍किलादेन अकिलासदा थेरीन ख्‍लाजी। तर ह्राङ चा यहूदीगदे ह्रुप तबा दिम गिकरी वाङ्सी यहूदीगदेदेन छ्‌याम छलफल लबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","पावलदा यहूदीगदेसे अझ तिगै धिनधोना चिउ भिसी भिमा पावलसे थेनीगदेला ताम आङ्‌यान्‍नी। ");
INSERT INTO taj_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","थेनीगदेग्‍याम फेबा धुइरी पावलसे थेनीगदेदा “परमेश्‍वरसे सेम लजी भिसम ङा दोःसी ह्राङनी मुबा ग्‍लारी खला” भिसी पावल पानी जहाजरी क्रेःसी एफिससरी निजी। ");
INSERT INTO taj_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","जमाहेन्‍से कैसरिया शहररी धोखसी पावल यरूशलेमरी निसी थेरी मुबा मण्‍डलीला म्‍हिगदेदेन छ्‌याम ह्रुप तजी। ओच्‍छे पावल एन्‍टिओखिया शहररी धोजी। ");
INSERT INTO taj_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","पावल तिगै धिनधोना थेरीन चिजी। जमाहेन्‍से पावल गलातियादेन फ्रिगियाला जम्‍मान ग्‍लागदेरी निबान जम्‍मान चेलागदेदा विश्‍वासरी कोङ्‌ना लबान भ्रजी। ");
INSERT INTO taj_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","अलेक्‍जेन्‍ड्रिया भिबा ग्‍लाला अपोल्‍लोस भिबा यहूदी गिक एफिससरी खजी। थे परमेश्‍वरला बचन सेबा घोबादेन ज्‍यना लसी ताम पाङ्‌खम्‍बा म्‍हि मुबा। ");
INSERT INTO taj_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","थेसे थार्बा पिन्‍बा प्रभु येशूला बारेरी थेःबा मुबा, थेतबासेलमा सेमहेन्‍सेन ताङ्सी प्रभु येशूला बारेरी ज्‍यना लसी लोप्‍मुबा। तसैनोन थेदा यूहन्‍नासे पिन्‍बा बप्‍तिस्‍माला बारेरी जे था मुबा। ");
INSERT INTO taj_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","थे ढुक्‍क तसी यहूदीगदे ह्रुप तबा दिमरी पाङ्‌बारी छ्‌याइजी। थेसे पाङ्‌मा प्रिस्‍किलादेन अकिलाससे थेःमाहेन्‍से थेनीगदेसे थेदा ह्राङला दिमरी भोर्जी। ओच्‍छे थेदा परमेश्‍वरला गेला बारेरी ज्‍यना लसी घोना लसी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","जमाहेन्‍से अपोल्‍लोस अखैया भिबा ग्‍लारी निबा सेम लजी। थेतबासेलमा एफिससरी मुबा चेलागदेसे थेदा निबारी आँट पिन्‍सी, अपोल्‍लोसदा मान लगै भिसी चिठी गिक भ्रिसी पुइजी। अखैयारी धोमाहेन्‍से प्रभुला दयामायाग्‍याम विश्‍वास लबा म्‍हिगदेदा थेसे ल्‍हानान ह्रो लजी। ");
INSERT INTO taj_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","तिग्‍दा भिसम थेसे परमेश्‍वरला बचनग्‍याम येशून थार्बा पिन्‍बा ख्रीष्‍ट हिन्‍ना भिसी म्‍हिगदेला ओन्‍छाङरी यहूदीगदेदा तिगै पाङ्‌आखम्‍बा तना लजी। ");
INSERT INTO taj_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","अपोल्‍लोस कोरिन्‍थरी मुबा धुइरी पावल एशियाला गुङग्‍याम तबान एफिसस भिबा शहररी खजी। थेरी पावलसे कोइ कोइ चेलागदेदा स्‍याप्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","जमाहेन्‍से पावलसे थेनीगदेदा “एनीगदेसे विश्‍वास लमाहेन्‍से परमेश्‍वरला आत्‍मा याङ्जी?” भिसी ङ्‌योइमा, थेनीगदेसे पावलदा “परमेश्‍वरला आत्‍मा मुला भिसी ङन्‍से थेःबै आरे” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","दोःसीनोन पावलसे थेनीगदेदा “एनीगदेसे खाह्रङ्बा बप्‍तिस्‍मा किन्‍जी?” भिसी ङ्‌योइमा, थेनीगदेसे पावलदा “यूहन्‍नासे लोप्‍बा अन्‍छारला बप्‍तिस्‍मा किन्‍जी” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","जमाहेन्‍से पावलसे थेनीगदेदा “यूहन्‍नासे पिन्‍बा बप्‍तिस्‍मा चा ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःगै भिसी पिन्‍बा बप्‍तिस्‍मा हिन्‍ना। थेसे ह्राङ भन्‍दा लिच्‍छा फेप्‍खबा म्‍हिदा विश्‍वास लउ भिसी म्‍हिगदेदा लोप्‍मुबा, थे म्‍हि येशू हिन्‍ना” भिसी पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","चु ताम थेःसी थेनीगदेसे प्रभु येशूला मिनरी बप्‍तिस्‍मा किन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","पावलसे थेनीगदेथोरी या थान्‍माहेन्‍से थेनीगदेथोरी परमेश्‍वरला आत्‍मा फेप्‍खजी, जमाहेन्‍से थेनीगदेसे आसेबा ग्‍योइदेन परमेश्‍वरग्‍याम खबा ताम पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","थेनीगदे ओस्‍पन च्‍युक न्‍ही ते मुबा। ");
INSERT INTO taj_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","जमाहेन्‍से पावल ढुक्‍क तसी यहूदीगदे ह्रुप तबा दिमरी वाङ्सी ला सोमधोना परमेश्‍वरला य्‍हुल्‍साला बारेरी थेनीगदेदेन छ्‌याम छलफल लबान म्‍हिगदेदा घोना लजी। ");
INSERT INTO taj_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","तर थेरी कोइ कोइ म्‍हिगदे अटेरी तसी विश्‍वास आलना येशूदा विश्‍वास लबा म्‍हिगदेला ओन्‍छाङरी थेरी मुबा समूहला बिरोध लबारी छ्‌याइजी। थेतबासेलमा पावल थेनीगदेग्‍याम फेसी चेलागदेदा छ्‌यामनोन भोर्सी टुरान्‍नस भिबा ग्‍लाला स्‍कूलरी धिन धिननोन छलफल लबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","चु गे लबा न्‍ही दिङ तमा एशियारी चिबा जम्‍मान यहूदीदेन ग्रीकगदेसे प्रभुला बचन थेःजी। ");
INSERT INTO taj_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","थेरी परमेश्‍वरसे पावलग्‍याम म्‍हिसे लबारी आखम्‍बा उदेकला गेगदे लजी। ");
INSERT INTO taj_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","पावलला ल्‍हुइरी रूमाल तसै घ तसै थुर्सी आखम्‍बा म्‍हिगदे मुबा ग्‍लारी भोर्सी थेनीगदेला ल्‍हुइरी थुर्माहेन्‍से आखम्‍बा म्‍हिगदे खम्‍मुबा ओच्‍छे थेनीगदेला ल्‍हुइग्‍याम म्‍हङ थोन्‍सी यार्मुबा। ");
INSERT INTO taj_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","जमाहेन्‍से ङाबा स्‍युइबा लबा कोइ कोइ यहूदीगदे क्‍यारमार निसी प्रभु येशूला मिनग्‍याम म्‍हङसे स्‍याप्‍बागदेदा “ङाइ एदा पावलसे थेःना लबा येशूला मिनरी थोन्‍सी निउ भिसी कुल्‍बा मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","चुह्रङ्बा गे लबा चा परमेश्‍वरला मन्‍दिररी पूजा लबा यहूदी मुल म्‍हि स्‍केवासला झा निस मुबा। ");
INSERT INTO taj_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","तर तिरेकुनु चा म्‍हङसे थेनीगदेदा “ङाइ येशूदा ङोसेमुला, ओच्‍छे पावलदाएनोन ङोसेबा मुला, तर एनीगदे चा खाल हिन्‍ना?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","जमाहेन्‍से थे म्‍हङसे स्‍याप्‍बा म्‍हि छ्‌योङ्बान थेनीगदे मुबा ग्‍लारी खजी, ओच्‍छे थेनीगदे जम्‍मादान लछार पछार लसी तहरी थान्‍जी, जमाहेन्‍से थेनीगदे लिगन्‍डी तसी घाइते तसी थे दिमग्‍याम थोन्‍सी यार्जी। ");
INSERT INTO taj_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","चु ताम एफिससरी चिबा जम्‍मान यहूदीदेन ग्रीकगदेसे थेःसी थेनीगदे जम्‍मान लोङ्जी। ओच्‍छे थेनीगदेसे प्रभु येशूला मिननोन जम्‍मान भन्‍दा घ्रेन हिन्‍ना भिसी भिबारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","जमाहेन्‍से विश्‍वास लबा ल्‍हानान म्‍हिगदे खजी ओच्‍छे थेनीगदे जम्‍मासेन ह्राङ ह्राङसे लबा आज्‍यबा गेगदे म्‍हिगदेला ओन्‍छाङरी पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","जादु लबा म्‍हिगदे न्‍हङला ल्‍हानान म्‍हिगदेसे ह्राङ ह्राङला जादुला किताब ह्रुप लसी भजी, ओच्‍छे जम्‍मान म्‍हिगदेला ओन्‍छाङरी ख्राङ्‌जी। थेनीगदेसे भबा किताबला सय लमा ओस्‍पन बोगल न्‍हीसे हजार च्‍युइ म्‍हुइला डबल तजी। ");
INSERT INTO taj_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","चुह्रङ् तसी प्रभुला शक्तिशाली बचन खानङदमान थेःसी ल्‍हेबान निजी। ");
INSERT INTO taj_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","चुह्रङ् तमाहेन्‍से पावलसे माकेडोनियादेन अखैया तबान यरूशलेमरी निबारी पक्‍का लजी। ओच्‍छे थेरी धोमाहेन्‍से “ङा रोमरीएनोन निनोन तोःला” भिसी पावलसे भिजी। ");
INSERT INTO taj_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ओच्‍छे पावलसे ह्राङदा ह्रो लबा तिमोथीदेन इरास्‍तसदा माकेडोनियारी ङाच्‍छा पुइजी। तर ह्राङ चा तिगै धिनधोना एशियारीन चिजी। ");
INSERT INTO taj_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","थे धुइरी थार्बा याङ्बा ग्‍यामला बारेरी थेःना लबासे लमा एफिससरी ल्‍हानान खल्‍बल तजी। ");
INSERT INTO taj_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","तिग्‍दा भिसम डेमेत्रियस भिबा म्‍हुइला मूर्तिगदे स्‍होबा म्‍हि गिकसे आर्तेमिस भिबा लुला जजाबा मन्‍दिरगदे स्‍होसी गे लबागदेदा ल्‍हानान गे पिन्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ओच्‍छे थेसे थे गे लबागदेदेन अर्गु थेह्रङ्बान गे लबागदे जम्‍मादान ग्‍ला गिकरी ह्रुप लसी चुह्रङ् भिसी भिजी, “ङाला ह्रोगदे, एनीगदेदा थानोन मुला, य्‍हाङदा चुनोन गेग्‍याम ल्‍हानान फाइदा मुला। ");
INSERT INTO taj_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","एनीगदेसे म्राङ्बादेन थेःबा तामगदे एफिससरी जे आहिन, तर एशियाला जम्‍मान ग्‍लारी पावल भिबा म्‍हिसे म्‍हिला याग्‍याम स्‍होबा ल लुगदे चा तिगै आहिन भिसी ल्‍हानान म्‍हिगदेदा व्‍हाम्‍सी भोर्बा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","थेतबासेलमा य्‍हाङला व्‍यापार म्‍हासी निबा जे आहिन, तर आर्तेमिस भिबा घ्रेन लुला मन्‍दिरएनोन गे आखेल्‍बा तला, ओच्‍छे एशियाला जम्‍मान ग्‍लादेन जम्‍बुलिङ न्‍हङ‌नोन घ्रेन मान पिन्‍बा लुदा तेन्‍बा ख्‍लाला।” ");
INSERT INTO taj_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","चु ताम थेःसी थेनीगदेदा ल्‍हानान बोमो रेःजी, ओच्‍छे “एफिससला म्‍हिगदेला आर्तेमिसनोन घ्रेन हिन्‍ना” भिसी थेनीगदे क्रिङ्बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ओच्‍छे शहर न्‍हङ‌नोन हल्‍ली खल्‍ली तजी। जमाहेन्‍से थेनीगदे जम्‍मान ढिक्‍सी माकेडोनियाला गायसदेन अरिस्‍तार्खस भिबा पावलला ह्रो न्‍हीदा चुङ्सी डुइबा छेङ्‌बा लसी रङगशाला न्‍हङरी भोर्जी। ");
INSERT INTO taj_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","पावलएनोन तिगै ताम पाङ्बा सेम लसी म्‍हिला हुल न्‍हङरी निबारी म्‍हाइजी, तर प्रभुदा विश्‍वास लबागदेसे थेदा निआपुङ्‌नी। ");
INSERT INTO taj_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","एशियाला सरकारला गे लबा कोइ कोइ मुल म्‍हिगदेएनोन पावलला ह्रो मुबा। ओच्‍छे थेनीगदेसेनोन पावलदा रङगशाला न्‍हङरी थानिउ भिसी पाङ्सी पिन्‍गो भिसी कुल्‍सी पुइजी। ");
INSERT INTO taj_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","थेनोन धुइरी थेनीगदे न्‍हङरी गिकसेम गिक ह्राङ ह्राङला ताम लबान क्रिङ्सी हल्‍ली खल्‍ली लबान मुबा। तिग्‍दा भिसम थेरी मुबा ल्‍हानान म्‍हिगदेदा ह्राङ तिग्‍दा पोप तजी भिबा ताम सुत्तै था आरेमुबा। ");
INSERT INTO taj_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","जमाहेन्‍से म्‍हिला हुल न्‍हङ‍ग्‍याम कोइ कोइ म्‍हिगदेसे अलेक्‍जेन्‍डर भिबा म्‍हिदा ङाच्‍छापट्टि भजी। थेदा यहूदीगदेसे तिगै ताम पाङ्सी चुगदेदा घोना लसी पिन्‍गो भिसी भिजी। ओच्‍छे अलेक्‍जेन्‍डरसे ह्राङ जोगब तबाला लागिरी याला चाल लबान तिगै पाङ्बा सेम लजी। ");
INSERT INTO taj_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","तर थेनीगदेसे थे म्‍हि यहूदी चीम भिबा था याङ्सी जम्‍मान म्‍हिगदे ढिक्‍सी ओस्‍पन घण्‍टा न्‍ही ते “एफिससला म्‍हिगदेला आर्तेमिसनोन घ्रेन हिन्‍ना” भिसी क्रिङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","जमाहेन्‍से शहरला हाकिमसे म्‍हिगदेदा कुटिसी चिना लमाहेन्‍से चुह्रङ् भिसी घोना लजी, “एफिससला म्‍हिगदे, एफिसस शहर चा घ्रेन आर्तेमिसला मन्‍दिरदेन मुग्‍याम ताइबा थेला मूर्तिदा जोगब लसी थान्‍बा मुला भिबा ताम खाल्‍दा था आरे? ");
INSERT INTO taj_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","चु ताम खालै म्‍हिसे आहिन भिसी पाङ्‌बारी आखम भिबा ह्राङनीदा थानोन मुला। थेतबासेलमा ह्राङनी कुटिसी स्‍य्‍हूगो, ओच्‍छे तिगै आम्‍हन्‍ना तिगै गे लबारी आत। ");
INSERT INTO taj_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","तिग्‍दा भिसम ह्राङनीसे भबा चु म्‍हिगदेसे य्‍हाङला लथान य्‍हो लबा आरे, ओच्‍छे य्‍हाङला लुदा बिरोधएनोन लबा आरे। ");
INSERT INTO taj_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","चुदे डेमेत्रियसदेन थेला गे लबागदेसे खालैला बिरोधरी उजुर लतोःबा मुसम अदालतगदे मुनोन मुला ओच्‍छे न्‍यायाधीशगदेएनोन मुनोन मुला। थेतबासेलमा थेनीगदेसे गिकसे गिकदा बिरोध लबा हिन्‍सम मुद्दा युगै। ");
INSERT INTO taj_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","तर चु बाहेक अर्गुन ताम पाङ्बा सेम मुसम थे तामला निसाफ य्‍हाङला ठिम अन्‍छार गन्‍बागदे ह्रुप तसी सदन लबा सभारी ढिक्‍ना लला। ");
INSERT INTO taj_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","तिग्‍दा भिसम तिनी तबा चु हुल दङगाला दोष य्‍हाङथोरी खबारी खम्‍ला, चु थेह्रङ्नोन तबा हुल दङगा तिग्‍दा तजी भिसी य्‍हाङसे घोना लबारी आखम।” ");
INSERT INTO taj_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","चुदे भिसी थे हाकिमसे थेरी मुबा म्‍हिगदेदा पुइजी। ");
INSERT INTO taj_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","थे हल्‍ली खल्‍ली म्‍हमाहेन्‍से पावलसे प्रभुदा विश्‍वास लबागदेदा ङ्‌योइबारी पुइजी, ओच्‍छे थेनीगदेदा आँट पिन्‍सी थेनीगदेग्‍याम फेसी थे माकेडोनिया भिबा ग्‍लापट्टि निजी। ");
INSERT INTO taj_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","माकेडोनियाग्‍याम तबान निमा थेसे प्रभुदा विश्‍वास लबा थे ग्‍लाला म्‍हिगदेदा ल्‍हानान आँट पिन्‍सी थे ग्रीस भिबा ग्‍लारी निजी। ");
INSERT INTO taj_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","थेरी पावल ला सोमधोना चिजी। ओच्‍छे पानी जहाजरी क्रेःसी सिरिया भिबा ग्‍लारी निबारी छ्‌याइमा थेदा यहूदीगदेसे साइबारी जाल लबा ताम था याङ्सी थेसे भ्रसीन माकेडोनिया तसी निबारी पक्‍का लजी। ");
INSERT INTO taj_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ओच्‍छे बेरिया भिबा ग्‍लाला पुरस भिबा म्‍हिला झा सोपात्रोस, थेसलोनिके भिबा ग्‍लाला अरिस्‍तार्खसदेन सिकन्‍दस ओच्‍छे डर्बी भिबा ग्‍लाला गायसदेन तिमोथी ओच्‍छे एशिया भिबा ग्‍लाला तुखिकसदेन त्रोफिमसएनोन थेदेन छ्‌याम निजी। ");
INSERT INTO taj_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","चुगदे ङाच्‍छान त्रोआस भिबा ग्‍लारी धोसी ङन्‍दा भ्रान्‍सी चिबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ङनी चा मिश्र य्‍हुल्‍साग्‍याम फेसी खबा धिन‍दा ढन्‍सी धङ्बा चाड निमाहेन्‍से फिलिप्‍पी भिबा ग्‍लाग्‍याम पानी जहाजरी क्रेःसी खमा ङारेकुनु थेनीगदे मुबा ग्‍ला त्रोआसरी धोखजी, ओच्‍छे थेरी ङनी ङारेधोना चिजी। ");
INSERT INTO taj_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","साताला ङाच्‍छाकुनु ङनी प्रभु भोज चबारी पोप तजी, ओच्‍छे पावल चा न्‍हङगरदङनोन निबा सेम लबासे लमा थेनीगदेदेन छ्‌याम म्‍हुन गङसलधोना ताम लसी चिजी। ");
INSERT INTO taj_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ङनी पोप तबा दिमला तलाथोला कोठारी चा ल्‍हानान नाङसलगदे मुबा। ");
INSERT INTO taj_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","युटिकस भिबा भ्‍योन म्‍हि चा झ्‍यालरी चिबा मुबा। पावलसे ल्‍हानान धुइधोना ताम लबासे लमा थेदा म्‍हेर्बा खसी छुप निजी। थेतबासेलमा थे तला सोमग्‍यामसे ताइजी, थेनीगदेसे थेदा थीमा सिसी जिन्‍बा स्‍याप्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","जमाहेन्‍से पावल मार फाप्‍जी, ओच्‍छे ख्‍लुप तसी थेदा हाप ख्‍वाइजी। पावलसे थेरी मुबागदेदा “थालोङ्‍गो, तिग्‍दा भिसम चु सोबान मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","जमाहेन्‍से थे तलाथोरी निजी ओच्‍छे गेङ क्‍युइसी चमाहेन्‍से य्‍हाल आततेधोना ताम लसी चिजी। जमाहेन्‍से थेनीगदेग्‍याम पावल फेसी निजी। ");
INSERT INTO taj_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ओच्‍छे थेनीगदेसे थे सिबाग्‍याम सोबा भ्‍योन म्‍हिदा दिमरी भोर्जी। ओच्‍छे थेनीगदेसे ल्‍हानान आँट याङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","त्रोआसग्‍याम पावल बाहेक ङनी जम्‍मान पानी जहाजरी क्रेःसी अस्‍सोस भिबा शहररी निजी। पावलसे चा अस्‍सोसधोना भ्रसी निबा सेम लबासे लमा थे अस्‍सोसधोना भ्रसी निजी। ओच्‍छे अस्‍सोसग्‍याम चा ङन्‍देन छ्‌यामनोन पानी जहाजरी क्रेःसी निबा पावलला सेम मुबा। ");
INSERT INTO taj_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ङनी अस्‍सोसरी धोखमाहेन्‍से पावलएनोन ङन्‍देन छ्‌यामनोन पानी जहाजरी क्रेःसी ङनी जम्‍मान छ्‌यामनोन मितिलेने भिबा शहररी निजी। ");
INSERT INTO taj_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","थेग्‍याम ङनी पानी जहाजरी निसी न्‍हङगरदङ खियस भिबा ग्‍लाला ङामरी धोखजी, ओच्‍छे रेनीदङ सामोस भिबा ग्‍लारी धोखजी। ओच्‍छे अर्गु धिनकुनु चा मिलेटस भिबा ग्‍लारी खजी। ");
INSERT INTO taj_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","पावलसे एशियारी चिबा सेम आलबासे लमा एफिससरी आवाङ्‌नान निबा सेम लजी। तिग्‍दा भिसम पावलसे खम्‍तेधोना पेन्‍तिकोसला धिनरी यरूशलेमरीन दोबारी भङ लबान मुबा। ");
INSERT INTO taj_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","पावलसे मिलेटसग्‍याम एफिससरी मुबा मण्‍डलीला मण्‍डलीदा च्‍याबा म्‍हिगदेदा ङ्‌योइबारी म्‍हि पुइजी। ");
INSERT INTO taj_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","थेनीगदे पावल मुबा ग्‍लारी धोखमाहेन्‍से पावलसे थेनीगदेदा चुह्रङ् भिसी भिजी, “एशियारी काङ न्‍हेःमाकुनुहेन्‍से ङा ह्राङनीला गुङरी खाह्रङ् लसी चिजी भिबा ताम ह्राङनीदा थानोन मुला। ");
INSERT INTO taj_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ओच्‍छे यहूदीगदेसे जाल लसी ङादा फसब लबारी म्‍हाइबासे लमा ङादा ल्‍हानान दुख तजी, तसैनोन ङा सोजो तसी क्राबान प्रभुला गे लजी। ");
INSERT INTO taj_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ओच्‍छे ह्राङनीदा ज्‍यबा ताम पाङ्बा धुइरी जम्‍मान म्‍हिला ओन्‍छाङरीदेन एनीगदे जम्‍मालान दिम दिमरी निसी ङाइ ह्राङनीदा लोप्‍बा धुइरी ङाइ तिगै ताम बाँकी आथान्‍ना लोप्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","यहूदीगदेदेन अर्गु य्‍हुलला म्‍हिगदेदाएनोन ङाइ ह्राङ ह्राङला पाप ख्‍लासी परमेश्‍वरपट्टि दोःगो ओच्‍छे य्‍हाङला प्रभु येशू ख्रीष्‍टदा विश्‍वास लउ भिसी पाङ्बा मुला। ");
INSERT INTO taj_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“च्‍यागो, ङा परमेश्‍वरला आत्‍माला करसे लमा यरूशलेमपट्टि निबान मुला, थेरी तिग तला भिबा ताम ङादा था आरे। ");
INSERT INTO taj_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","जम्‍मान शहररी ङादा दुख तबादेन झ्‍याल्‍खानरी झाङ्‌ला भिसी परमेश्‍वरला आत्‍मासे उन्‍बा ताम जे ङादा था मुला। ");
INSERT INTO taj_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","तसैनोन ङाइ ह्राङला ज्‍यानदा घ्रेन म्‍हन्‍बा आरे, तिग्‍दा भिसम परमेश्‍वरला दयामायाला बारेरी थार्बा पिन्‍बा समाचार थेःना लबादेन प्रभु येशूसे ङादा पिन्‍बा गे जिन्‍ना लखम्‍गै भिबा ङाला सेम मुला। ");
INSERT INTO taj_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“च्‍यागो, ङाइ ह्राङनी न्‍हङला जम्‍मादान परमेश्‍वरला य्‍हुल्‍साला समाचार थेःना लबान भ्रजी, दोःसी खाइमै य्‍हाङ ह्रुप आत भिबा ङादा था मुला। ");
INSERT INTO taj_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","थेतबासेलमा तिनी ङाइ ह्राङनीदा पाङ्ला, ह्राङनी न्‍हङला खालै नाश तसैनोन थेला दोष ङादा आत। ");
INSERT INTO taj_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","तिग्‍दा भिसम एनीगदेसे था याङ्‌गै भिसी परमेश्‍वरसे म्‍हन्‍बा जम्‍मान ताम ङाइ एनीगदेदा गिकनोन बाँकी आथान्‍ना पाङ्बा मुला। ");
INSERT INTO taj_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","“दाहेन्‍से ह्राङ ह्राङलान लागिरी ओच्‍छे परमेश्‍वरला आत्‍मासे ह्राङनीदा जिम्‍मा पिन्‍बा ग्‍युगदेला लागिरी होशियार तसी चिउ। परमेश्‍वरला मण्‍डलीदा ज्‍यना लसी च्‍याबा म्‍हि दोगो, तिग्‍दा भिसम प्रभु येशूसे थे म्‍हिगदेदा ह्राङलान कासे ग्‍लुबा मुला। ");
INSERT INTO taj_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","तिग्‍दा भिसम ङा निमाहेन्‍से एनीगदेला गुङरी लोङ्‌बा खबा फार्बागदे ह्रङ्‌बान लुसीला ताम लोप्‍बा म्‍हिगदे खला, थेसे म्‍हिगदेदा बाँकी आथान भिबा ताम ङादा था मुला। ");
INSERT INTO taj_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ह्राङनीलान गुङग्‍यामएनोन न्‍होङ्ना लबा ताम पाङ्बा म्‍हिगदे थोन्‍ना, थेनीगदेसे प्रभुदा विश्‍वास लबागदेदा ह्राङदेन छ्‌याम भोर्ला। ");
INSERT INTO taj_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","थेतबासेलमा ह्राङनी होशियार तसी स्‍य्‍हूगो, ङाइ सोम दिङधोना धिन म्‍हुननोन क्रासी क्रासी एनीगदे जम्‍मादान लोप्‍बा ताम थाम्‍लेःगो। ");
INSERT INTO taj_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“दाहेन्‍से ङाइ ह्राङनीदा परमेश्‍वरदेन थेला दयामायाला बचनरी जिम्‍मा पिन्‍ना, थे बचनसेन ह्राङनीदा विश्‍वासरी कोङ्‌ना लला, ओच्‍छे परमेश्‍वरसे ह्राङला लागिरी फेसी थान्‍बा म्‍हिगदेसे याङ्बा हक एनीगदेसेनोन याङ्ला। ");
INSERT INTO taj_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ङाइ खालै म्‍हिला म्‍हर, म्‍हुइदेन क्‍वान्‍ना लोभ आलनी। ");
INSERT INTO taj_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ओच्‍छे ङाइनोन गे लसी ङाला खाँचो ओच्‍छे ङादेन छ्‌याम मुबागदेदा खाँचो तबा स्‍हेगदे ङाइ पिन्‍बा ह्राङनीदा थानोन मुला। ");
INSERT INTO taj_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ह्राङनीसेनोन ङाइ ह्रङ् लसी कमजोर म्‍हिगदेदा ह्रो लगै भिसी ङाइ सेमहेन्‍सेन लबा जम्‍मान गे ह्राङनीदा उन्‍बा मुला, तिग्‍दा भिसम प्रभु येशूसेनोन ‘किन्‍बागदे भन्‍दा पिन्‍बागदेसे चा झन मोलम याङ्ला’ भिसी सुङ्बा मुला। थेतबासेलमा ह्राङनीसेनोन चु बचनदा ढन्‍सी ह्राङसेन गे लसी आखम्‍बागदेदा ह्रो लउ।” ");
INSERT INTO taj_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","चुदे पाङ्सी जिन्‍माहेन्‍से पावलसे पुइ जूसी थेनीगदेदेन छ्‌याम प्रार्थना लजी। ");
INSERT INTO taj_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ओच्‍छे थेनीगदे जम्‍मान क्रासी पावलदा हापख्‍वाइसी च्‍योक लजी। ");
INSERT INTO taj_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","पावलसे दोःसी खाइमै ह्रुप आत भिसी पाङ्बासे लमा थेनीगदेदा ल्‍हानान दुख ङ्‌हम्‍जी। ओच्‍छे थेनीगदेसे पावलदा पानी जहाज मुबा ग्‍लाधोना सबारी निजी। ");
INSERT INTO taj_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","थेनीगदेग्‍याम फेसी ङनी पानी जहाजरी क्रेःसी सोजोन कोस भिबा ग्‍लारी खजी, ओच्‍छे न्‍हङगरदङ रोडस भिबा ग्‍लारी धोखजी थेग्‍याम पटारा भिबा ग्‍लारी धोखजी। ");
INSERT INTO taj_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","जमाहेन्‍से फोनिके भिबा ग्‍लारी निबा पानी जहाज गिक स्‍याप्‍जी ओच्‍छे ङनी थेरीन क्रेःसी निजी। ");
INSERT INTO taj_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","साइप्रस भिबा ग्‍ला म्राङ्माहेन्‍से थे ग्‍लाला देब्रेपट्टिग्‍याम ङनी सिरियापट्टि निसी टुरोस भिबा ग्‍लारी फाप्‍जी। तिग्‍दा भिसम पानी जहाजरी भबा मालसामान थेरी तेःतोःबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ओच्‍छे प्रभुदा विश्‍वास लबागदेदा म्‍हाइसी स्‍याप्‍माहेन्‍से ङनी निसरेधोना थेरीन चिजी। थेनोन धुइरी प्रभुदा विश्‍वास लबागदेसे परमेश्‍वरला आत्‍माग्‍याम पावलदा यरूशलेमरी थानिउ भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","थे ग्‍लाग्‍याम निबा धुइ तमाहेन्‍से ङनी थे ग्‍लाग्‍याम थोन्‍जी। ओच्‍छे थेनीगदेला कोलागदेदेन म्‍हेमेगदे क्‍योङ्‌सेन ङन्‍दा शहर मङग्‍यारधोना सबारी खजी। जमाहेन्‍से ङनी जम्‍मासेन समुन्‍द्रला कुनीरी पुइ जूसी प्रार्थना लजी। ");
INSERT INTO taj_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","जमाहेन्‍से ङनी थेनीगदेग्‍याम फेसी पानी जहाजरी क्रेःजी, ओच्‍छे थेनीगदे चा ह्राङला दिमरी निजी। ");
INSERT INTO taj_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","टुरोसग्‍याम ङनी समुन्‍द्रला ग्‍याम तबान टोलेमाइस भिबा ग्‍लारी धोखजी। जमाहेन्‍से थेरी मुबा प्रभुदा विश्‍वास लबागदेदा स्‍याप्‍सी ङनी थेनीगदेदेन छ्‌याम तिरे चिजी। ");
INSERT INTO taj_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","न्‍हङगरदङ ङनी थे ग्‍लाग्‍याम थोन्‍सी कैसरिया भिबा शहररी धोखजी, ओच्‍छे ङनी थार्बा पिन्‍बा समाचार थेःना लबा फिलिप भिबा म्‍हिला दिमरी वाङ्‌जी। थे फिलिप यरूशलेमरी धम्‍बा गोर निस न्‍हङला गिक मुबा। ");
INSERT INTO taj_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","थे फिलिपला ब्‍याह आलबा झामे ब्‍लि मुबा। थेनीगदेसे परमेश्‍वरग्‍याम खबा ताम पाङ्मुबा। ");
INSERT INTO taj_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ङनी तिगै रेधोना थेरी चिबा धुइरी यहूदिया भिबा ग्‍लाग्‍याम अगाबस भिबा अगमवक्ता गिक ङनी मुबा ग्‍लारी खजी। ");
INSERT INTO taj_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","थे अगमवक्ता ङनी मुबा ग्‍लारी खसी पावलला केः किन्‍सी ह्राङलान काङ या खीजी। थेसे “चु केः जुन म्‍हिला हिन्‍ना थेदा यरूशलेमरी यहूदीगदेसे चुह्रङ्‌नोन लसी खीला। ओच्‍छे अर्गु य्‍हुलला म्‍हिगदेला यारी जिम्‍मा पिन्‍ना भिसी परमेश्‍वरला आत्‍मासे सुङ्बा मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","चु ताम थेःसी थेरी मुबागदेदेन ङन्‍से पावलदा यरूशलेमरी थाफेप्‍गो भिसी बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","तर पावलसे थेनीगदेदा “तिग्‍दा एनीगदे क्रासी ङाला सेम क्राना लबा? प्रभु येशूला लागिरी ङा झ्‍याल्‍खानरी चिबा जे आहिन, तर यरूशलेमरी सिबारीनोन तयार मुला” भिसी जोहाब पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ङन्‍से पावलला सेम दोःबारी आखम्‍माहेन्‍से “प्रभुसे जुन म्‍हन्‍बा मुला थे ताम पूरा तगै” भिसी ङनी कुटिसी चिजी। ");
INSERT INTO taj_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","जमाहेन्‍से ङनी ह्राङ ह्राङला सामानगदे तयार लसी यरूशलेमपट्टि निजी। ");
INSERT INTO taj_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ङन्‍देन छ्‌याम कैसरिया भिबा ग्‍लाला कोइ कोइ प्रभुदा विश्‍वास लबागदेएनोन निजी। ओच्‍छे थेनीगदेसे ङन्‍दा ङाच्‍छाहेन्‍सेन प्रभुदा विश्‍वास लबा साइप्रस भिबा ग्‍लाला मनासोन भिबा म्‍हिला दिमरी बास चिबाला लागिरी भजी। ");
INSERT INTO taj_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ङनी यरूशलेमरी धोखमाहेन्‍से थेरी मुबा ज्‍योज्‍यो आले नाना आङागदे ताङ्सी ङन्‍दा मान लजी। ");
INSERT INTO taj_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ओच्‍छे न्‍हङगरदङ पावल ङन्‍देन छ्‌याम याकूब मुबा ग्‍लारी निजी। थेरी जम्‍मान मण्‍डलीदा च्‍याबा म्‍हिगदे ह्रुप तबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","थेनीगदेदा लास्‍सो फ्‍याफुल्‍ला भिसी पाङ्माहेन्‍से पावलसे थेनीगदेदा ह्राङसे लबा गेग्‍याम अर्गु य्‍हुलला म्‍हिगदेला गुङरी परमेश्‍वरसे खाह्रङ्बा गेगदे लजी भिबा जम्‍मान ताम थेनीगदेदा पाङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","चु ताम थेःमाहेन्‍से थेनीगदेसे परमेश्‍वरला जयजयकार लजी। जमाहेन्‍से थेनीगदेसे पावलदा चुह्रङ् भिसी भिजी, “आले, चुरीनोन झ्‍यासीन झ्‍याबारी आखम्‍बाधोनाला यहूदीगदेसे परमेश्‍वरदा विश्‍वास लसी मोशासे पिन्‍बा ठिम अन्‍छार ज्‍यना लसी भ्रमुला। ");
INSERT INTO taj_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ह्राङसे अर्गु य्‍हुल्‍सारी चिबा यहूदीगदेदा एनीगदेसे ह्राङला कोलागदेला खतना थालउ। ओच्‍छे मोशासे पिन्‍बा ठिम अन्‍छार आलसै तला भिसी लोप्‍बा मुला रो भिबा ताम थेनीगदेसे थेःबा मुला। ");
INSERT INTO taj_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","दाहेन्‍से तिग लसे? थेनीगदेसे ह्राङ चुरी फेप्‍खजी भिबा पक्‍कान थेःला। ");
INSERT INTO taj_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","थेतबासेलमा ङन्‍से ह्राङदा पाङ्बा अन्‍छार लउ, चुरी परमेश्‍वरदेन छ्‌याम कबुल लबा म्‍हि ब्‍लि ङन्‍देन छ्‌याम मुला। ");
INSERT INTO taj_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","चुगदेदा भोर्सी ह्राङएनोन चुगदेदेन छ्‌यामनोन चोख्‍याब तउ, ओच्‍छे चुगदेदा तोःबा खर्च ह्राङसेन युसी पिन्‍गो। जमाहेन्‍से चुगदेसे क्रा भ्रेगै। ह्राङसे चुह्रङ् लसी मोशासे पिन्‍बा ठिम अन्‍छार लबा म्राङ्सी ह्राङला बारेरी चुगदेसे थेःबा जम्‍मान ताम सत्‍य आहिन्‍बा चीम भिसी था याङ्ला। ");
INSERT INTO taj_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","तर ङन्‍से सल्‍लाह लसी प्रभुदा विश्‍वास लबा अर्गु य्‍हुलला म्‍हिगदेदा ह्राङनीसे मूर्तिदा बलि पिन्‍बा तिगै स्‍हेगदे, कादेन खारे च्‍यार्सी साइबा जन्‍तुला स्‍या थाचउ, ओच्‍छे स्‍य्‍हान्‍दोदेन छ्‌याम ब्रेल्‍सी थाभ्रउ भिसी चिठी भ्रिबा मुला।” ");
INSERT INTO taj_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","जमाहेन्‍से न्‍हङगरदङ थे म्‍हि ब्‍लिदा भोर्सी ह्राङदाएनोन थेनीगदेदेन छ्‌यामनोन चोख्‍याब लजी, ओच्‍छे चोख्‍याब लबा धिन खाइमा जिन्‍ना भिबादेन थे म्‍हिगदेला लागिरी बलि खाइमा फुल्‍बा भिसी परमेश्‍वरला मन्‍दिररी पूजा लबा म्‍हिदा पाङ्‌बारी पावल परमेश्‍वरला मन्‍दिर न्‍हङरी वाङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","कबुल पूरा लबा निसरे तबारी छ्‌याइबा धुइरी एशियाला यहूदीगदेसे पावलदा परमेश्‍वरला मन्‍दिररी म्राङ्सी थेरी मुबा जम्‍मान म्‍हिगदेदा थीसी पावलदा चुङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","थेनीगदेसे क्रिङ्‌बान, “इस्राएलला म्‍हिगदे ङन्‍दा ह्रो लउ। तिग्‍दा भिसम खानङदमान य्‍हाङला य्‍हुलला म्‍हिगदेदेन य्‍हाङला ठिम ओच्‍छे चु ग्‍लाला बिरोध लसी लोप्‍सी भ्रबा म्‍हि चुनोन हिन्‍ना। चुदे जे आहिन, चुसे परमेश्‍वरला मन्‍दिररी अर्गु य्‍हुलला म्‍हिगदेदा भसी चु चोखो ग्‍लादा नइबा तना लबा मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","तिग्‍दा भिसम चु भन्‍दा ङाच्‍छा थे म्‍हिगदेसे एफिसस भिबा ग्‍लाला त्रोफिमस भिबा म्‍हिदा पावलदेन छ्‌याम म्राङ्बा मुबा। थेतबासेलमा पावलसे थेदा परमेश्‍वरला मन्‍दिररी भजी भिसी थे म्‍हिगदेसे म्‍हन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","जमाहेन्‍से शहर नाङनोन हल्‍ली खल्‍ली तसी म्‍हिगदे तिक्‍खुरीन यार्बान खजी। ओच्‍छे पावलदा चुङ्सी डुइबा छेङ्‌बा लसी परमेश्‍वरला मन्‍दिरग्‍याम मङग्‍यार तेःसी तुरुन्‍तन मन्‍दिरला म्राप ढुङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","थेनीगदेसे पावलदा साइबारी म्‍हाइबा धुइरी यरूशलेम नाङनोन हल्‍ली खल्‍ली तबा मुला भिबा ताम रोमी सिपाहीगदेला हाकिमसे थेःजी। ");
INSERT INTO taj_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","जमाहेन्‍से थेसे तुरुन्‍तन सिपाहीदेन कप्‍तानगदेदा छ्‌यामनोन भोर्सी यार्बान पावलदा तोबान लबा ग्‍लारी खजी। पावलदा तोबागदेसे हाकिमदेन सिपाहीगदेदा म्राङ्सी पावलदा तोबा ख्‍लाजी। ");
INSERT INTO taj_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ओच्‍छे रोमी सिपाहीगदेला हाकिम पावलला ङामरी खसी पावलदा चुङ्‌जी। ओच्‍छे चुदा च्‍याल्‍दा न्‍हीसे खीगो भिसी कुल्‍जी। जमाहेन्‍से थेसे चु म्‍हि खाल हिन्‍ना? चुसे तिग लजी? भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","तर थेरी मुबा म्‍हिगदे न्‍हङरी कोइसे तिग ताम लसी क्रिङ्सी हल्‍ली खल्‍ली लबासे लमा थेसे थे घटनाला बारेरी तिगै आघोनी। थेतबासेलमा थेसे पावलदा सिपाहीगदेला ब्‍यारेकरी भोर्गो भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","पावल चामरी धोमा म्‍हिगदेसे पावलदा तोबारी खबासे लमा सिपाहीगदेसे थेदा पुइसी भोर्जी। ");
INSERT INTO taj_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","तिग्‍दा भिसम म्‍हिला हुलसे “चुदा साइनोन तोःला” भिसी क्रिङ्‌बान लिच्‍छा लिच्‍छा भ्रबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","सिपाहीगदेला ब्‍यारेक न्‍हङरी भोर्बारी छ्‌याइमा पावलसे सिपाहीगदेला हाकिमदा “ह्राङसे ङादा ताम पाङ्‌पुङ्‌सम तिगै ताम पाङ्बा सेम मुला” भिसी भिमा सिपाहीगदेला हाकिमसे पावलदा चुह्रङ् भिसी भिजी, “एसे ग्रीक ग्‍योइ सेमुला? ");
INSERT INTO taj_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ङाच्‍छा रोमी सरकारदा बिरोध लसी हजार ब्‍लि बिरोध लबागदेदा तोङतोङबा ग्‍लारी भोर्सी निबा मिश्री एनोन आहिन?” ");
INSERT INTO taj_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","तर पावलसे “ङा मी किलिकिया भिबा ग्‍लाला टार्सस भिबा शहरला यहूदी हिन्‍ना, ङा जजाबा शहरला म्‍हि आहिन। थेतबासेलमा ङादा चु म्‍हिगदेदा तिगै पाङ्‌पुङ्‌गो” भिसी बिन्‍ती लजी। ");
INSERT INTO taj_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","जमाहेन्‍से “तला” भिसी भिमाहेन्‍से पावल चामरी राप्‍सी म्‍हिगदेदा यासे चाल लजी, ओच्‍छे म्‍हिगदे कुटिसी चिजी। जमाहेन्‍से थेसे हिब्रू ग्‍योइरी चुह्रङ् भिसी पाङ्‌बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“ङाला ह्रोगदे ह्राङनीला ओन्‍छाङरी ङाइ ङाला बारेरी पाङ्‌बारी छ्‌याइबा ताम ङ्‌यान्‍गो।” ");
INSERT INTO taj_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","पावलसे हिब्रू ग्‍योइरी ताम पाङ्बा थेःसी थेनीगदे झन कुटिसी चिजी। ");
INSERT INTO taj_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","जमाहेन्‍से पावलसे चुह्रङ् भिसी पाङ्‌बारी छ्‌याइजी, “ङा किलिकिया भिबा ग्‍लाला टार्सस शहररी न्‍हबा यहूदी हिन्‍ना। तर ङा यरूशलेम शहररी गमलिएल भिबा म्‍हिला कुरी छर्बा हिन्‍ना। गमलिएल गुरुग्‍यामनोन ङाइ य्‍हाङला आखे म्‍हेमेला ठिम अन्‍छार लोप्‍तोःबा जम्‍मान ताम लोप्‍जी। तिनी ह्राङनीसे सेमहेन्‍से परमेश्‍वरदा खाह्रङ् लसी तेन्‍बा मुला ङाइनोन थेह्रङ् लसीन तेन्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ओच्‍छे ङाइ थार्बा याङ्बा ग्‍यामरी भ्रबा म्‍हिगदेदा सिबाधोनान तोसी ह्रेम्‍फेबेदेन म्रिङम्‍हेमे न्‍हीदान चुङ्सी झ्‍याल्‍खानरी झाङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ङाइ पाङ्बा चु ताम सत्‍य हिन्‍ना भिसी परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिदेन यहूदीगदे ह्रुप तबा दिमला गन्‍बागदेसेनोन पाङ्‌खम्‍ला। थेनीगदेसेन दमस्‍कस भिबा ग्‍लारी मुबा यहूदी ज्‍योज्‍यो आलेगदेदा चिठी भ्रिसी ङादा पुइजी। थे चिठीरी प्रभु येशूदा विश्‍वास लबागदे जम्‍मादान चुङ्बा अधिकार ङादा पिन्‍बा मुबा। थेतबासेलमा थेनीगदेदा खीसी यरूशलेमरी भसी सजाय पिन्‍बा सेमसे ङा दमस्‍कसरी निबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“ङा दमस्‍कसला ङामरी धोमा ओस्‍पन धिनी गङसल तजी तला, थेनोन धुइरी स्‍वर्गग्‍याम तिक्‍खुरीन ङाला क्‍युर्नोन य्‍हाल खसी झ्‍वालङ् तजी। ");
INSERT INTO taj_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ङा सरी ह्रिल्‍जी, ओच्‍छे ङादा ‘शाऊल, शाऊल, एसे ङादा तिग्‍दा दुख पिन्‍बा?’ भिबा काइ थेःजी। ");
INSERT INTO taj_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“ओच्‍छे ङाइ ‘प्रभु, ह्राङ खाल हिन्‍ना?’ भिसी ङ्‌योइमा, थेसे ङादा ‘एसे दुख पिन्‍बान लबा नासरतला येशू ङानोन हिन्‍ना’ भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ङादेन छ्‌याम मुबागदेसे थे य्‍हाल मी म्राङ्जी, तर ङादेन छ्‌याम ताम पाङ्‌बाला काइ भिसम आथेःनी। ");
INSERT INTO taj_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“थेनोन धुइरी ङाइ ‘प्रभु, दाहेन्‍से ङाइ तिग लउ?’ भिसी भिमा, प्रभुसे ङादा ‘ए रेःगो ओच्‍छे दमस्‍कस शहररी निउ, एसे लतोःबा जम्‍मान गे थेरी पाङ्सी पिन्‍ना’ भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","थे य्‍हालसे लमा ङाइ तिगै आम्राङ्‌नी। थेतबासेलमा ङादेन छ्‌याम मुबागदेसे ङादा यारी चुङ्सी दमस्‍कस शहररी भजी। ");
INSERT INTO taj_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“थे शहररी हननिया भिबा मोशासे पिन्‍बा ठिम अन्‍छार भ्रबा म्‍हि गिक मुबा। थेदा दमस्‍कसरी चिबा जम्‍मान यहूदीगदेसे मान लमुबा। ");
INSERT INTO taj_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","थेनोन म्‍हि ङा मुबा ग्‍लारी खसी ङाला ङामरी राप्‍सी ङादा ‘शाऊल आले, एला मी दोःसी म्राङ्‍गै’ भिसी पाङ्‌मैछ्‌याम ङाइ म्राङ्‌खम्‍जी, ओच्‍छे ङाइ थेदा म्राङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“ओच्‍छे थेसे चुह्रङ् भिसी भिजी, ‘य्‍हाङला आखे म्‍हेमेला परमेश्‍वरला सेम घोबादेन परमेश्‍वरसे म्‍हन्‍बा अन्‍छार भ्रबा म्‍हिदा म्राङ्बारी ओच्‍छे थेसे पाङ्‌मा थेःबारी ह्राङदा धम्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","तिग्‍दा भिसम ह्राङसे थेला बारेरी म्राङ्बादेन थेःबा तामला साक्षी दोसी ह्राङसे जम्‍मान म्‍हिगदेदा थेःना लतोःबा मुला। ");
INSERT INTO taj_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","थेतबासेलमा दाहेन्‍से तिग्‍दा भ्रान्‍से? रेःगो, बप्‍तिस्‍मा किन्‍गो, ओच्‍छे थेला मिनरी विश्‍वास लमाहेन्‍से ह्राङला पाप धा‍ला।’ ");
INSERT INTO taj_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“यरूशलेमरी दोःसी खमाहेन्‍से परमेश्‍वरला मन्‍दिररी प्रार्थना लबा धुइरी सेम गिक तसी ङा एकोहोरो तजी। ");
INSERT INTO taj_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","एकोहोरो तबा धुइरी ङाइ प्रभुदा म्राङ्जी, थेसे ङादा ‘योना लसी ए यरूशलेमग्‍याम थोन्‍सी निउ। तिग्‍दा भिसम ङाला बारेरी एसे पाङ्‌मा थेनीगदेसे विश्‍वास आल’ भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“तर ङाइ चुह्रङ् भिसी पाङ्जी, ‘प्रभु, जम्‍मान यहूदीगदे ह्रुप तबा दिमरी निसी ह्राङदा विश्‍वास लबागदेदा तोबा ग्‍याङ्‍बा लसी झ्‍याल्‍खानरी झाङ्‌बा ताम यहूदीगदे जम्‍मादान था मुला। ");
INSERT INTO taj_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ओच्‍छे ह्राङला बारेरी पाङ्बा स्‍तिफनसदा साइबारी ङाएनोन ढिक्‍सी ङामरीन राप्‍सी स्‍तिफनसदा साइबागदेला क्‍वान ख्रुङ्‌सी चिबा मुबा।’ ");
INSERT INTO taj_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“जमाहेन्‍से प्रभुसे ङादा ‘ए निउ, तिग्‍दा भिसम ङाइ एदा अर्गु य्‍हुलला म्‍हिगदे मुबा ग्‍लारी थारेङ थारेङधोना पुइला’ भिसी सुङ्जी।” ");
INSERT INTO taj_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","पावलसे चुह्रङ् पाङ्‌तेधोना थेनीगदेसे ङ्‌यान्‍बान मुबा, ओच्‍छे ङ्‌यान्‍ना ङ्‌यान्‍नान “चुह्रङ्बा म्‍हिदा मी जम्‍बुलिङरी थान्‍बारी आत। तिग्‍दा भिसम सोबा भन्‍दा सिबान ज्‍यबा तला” भिसी थेनीगदे क्रिङ्बारी छ्‌याइजी। ");
INSERT INTO taj_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ओच्‍छे थेनीगदे ह्राङ ह्राङला क्‍वान स्‍युसी साप्रा स्‍वाबान क्रिङ्‌जी। ");
INSERT INTO taj_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","जमाहेन्‍से सिपाहीगदेला हाकिमसे चुह्रङ् भिसी कुल्‍जी, “चु म्‍हिगदेसे तिग्‍दा चुदा बिरोध लसी क्रिङ्‌बा चीम भिबा ताम था याङ्बाला लागिरी थेदा ब्‍यारेक न्‍हङरी भसी कोर्रासे तोबान ङ्‌योइबा छार्बा लउ।” ");
INSERT INTO taj_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","सिपाहीगदेसे पावलदा ढिला छोसे खीबारी छ्‌याइमा पावलसे ह्राङला ङामरी राप्‍सी चिबा कप्‍तानदा “तिग रोमीला ठिम अन्‍छार तिगै दोष आरेबा रोमी म्‍हिदा कोर्रासे तोबा ठीक हिन्‍ना?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","चु ताम थेःमाहेन्‍से कप्‍तान सिपाहीगदेला हाकिम मुबा ग्‍लारी खसी, “ह्राङसे चु तिग लबारी छ्‌याइबा? चु म्‍हि मी रोमी म्‍हि चीम” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","जमाहेन्‍से थे हाकिम खसी पावलदा “लु, ङादा पाङ्‍गो, ए पक्‍कान रोमी म्‍हि हिन्‍ना?” भिसी ङ्‌योइमा पावलसे “हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ओच्‍छे थे हाकिमसे “ङाइ ल्‍हानान टाङगा फासी ङा चु य्‍हुल्‍साला म्‍हि दोबा हिन्‍ना” भिसी जोहाब पिन्‍मा, पावलसे “तर ङा मी न्‍हमान रोमी म्‍हि हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","पावलदा ङ्‌योइबा छार्बा लबारी तयार तबागदे जम्‍मान थेग्‍याम तुरुन्‍तन लिच्‍छापट्टि लेःजी। ओच्‍छे पावल रोमी म्‍हि चीम भिबा ताम था याङ्सी सिपाहीगदेला हाकिमएनोन लोङ्जी। तिग्‍दा भिसम पावलदा खीगो भिसी थेसे कुल्‍बा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","न्‍हङगरदङ यहूदीगदेसे तिग्‍दा बिरोध लजीम भिबा ताम घोबा सेम लसी थेदा ब्‍लसी पिन्‍जी। ओच्‍छे परमेश्‍वरला मन्‍दिररी पूजा लबा जम्‍मान मुल म्‍हिगदेदेन यहूदीगदेला अदालतला नेतागदेदा पोप तउ भिसी कुल्‍जी। जमाहेन्‍से पावलदा अदालतरी भसी थेनीगदेला ङाच्‍छापट्टि राप्‍पुङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","पावलसे अदालतरी मुबागदे जम्‍मादान च्‍यासी, “ज्‍योज्‍यो आलेगदे, तिनीला धिनधोना ङा परमेश्‍वरला ङाच्‍छा ज्‍यबा सेमसे भ्रबा मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","चु ताम थेःसी परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हि हननियासे पावलला ङामरी राप्‍सी चिबागदेदा थेला ग्रम्‍बारी तोउ भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","जमाहेन्‍से पावलसे थेदा “ह्राङसे ह्राङदान ज्‍यबा म्‍हन्‍बा म्‍हि! च्‍यागो, एदाएनोन परमेश्‍वरसे सजाय पिन्‍ना। ए मोशासे पिन्‍बा ठिम अन्‍छार ङाला निसाफ लबारी चिसीनोन मोशाला ठिमदा ख्‍लासी एसे ङादा तोउ भिसी कुल्‍बा?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","पावलला ङामरी राप्‍सी चिबागदेसे पावलदा “तिग एसे परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिला बेइज्‍जत लबा?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","पावलसे थेनीगदेदा “ङाला ज्‍योज्‍यो आलेगदे, थे परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हि हिन्‍ना भिबा ङादा था आरेबा। तिग्‍दा भिसम ‘एसे ह्राङला य्‍हुलला नेताला बारेरी नइबा ताम थापाङ्‍गो’ भिसी परमेश्‍वरला बचनरी भ्रिबा मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","तर अदालतरी सदुकीगदेला समूहदेन फरिसीगदेला समूह चीम भिबा था याङ्सी पावलसे “ज्‍योज्‍यो आलेगदे, ङा फरिसीला कोला फरिसीन हिन्‍ना। ङाइ सिबागदे दोःसी सोला भिसी आश लबासे लमा ङादा चु मुद्दा तबा हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","पावलसे थेह्रङ् भिमाहेन्‍से फरिसीगदेदेन सदुकीगदेला ताम आढिक्‍ना थेनीगदे फेजी। ");
INSERT INTO taj_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","तिग्‍दा भिसम सदुकीगदेसे म्‍हि सिबाग्‍याम दोःसी आसो भिबादेन स्‍वर्गदूत ओच्‍छे आत्‍मा भिबा तिगै आरे भिसी भिमुबा। तर फरिसीगदेसे चा चु जम्‍मान मुला भिसी विश्‍वास लमुबा। ");
INSERT INTO taj_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","जमाहेन्‍से थेरी ल्‍हानान हल्‍ली खल्‍ली तजी। थेतबासेलमा फरिसी समूहला कोइ कोइ धर्मगुरुगदे राप्‍सी सदुकीगदेला बिरोध लबान, “ङन्‍से चु म्‍हिला तिगै दोष आस्‍याप्‍नी। तर आत्‍मा अथवा स्‍वर्गदूतसेन चु म्‍हिदा चुह्रङ् पाङ्बा हिन्‍सम तिग तजी?” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","थेरी थेनीगदेला ताम आढिक्‍ना छेबा बङ्बा तबासे लमा पावलदा थेनीगदेसे तोबा ग्‍याङ्‍बा लसी साइला भिसी सिपाहीगदेला हाकिम लोङ्सी पावलदा थेग्‍याम भसी ब्‍यारेक न्‍हङरी भोर्गो भिसी सिपाहीगदेदा कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","जमाकुनु म्‍हुनङ प्रभु पावलला ङामरी राप्‍सी, “पावल एसे भङ लउ। तिग्‍दा भिसम यरूशलेम शहररी एसे ङाला बारेरी पाङ्बा ह्रङ् लसी रोमरीनोन ङाला बारेरी पाङ्तोःला” भिसी सुङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","जमाहेन्‍से न्‍हङगरदङ स्‍य्‍होरी यहूदीगदे ह्रुप तसी पावलदा जाल लसी साइबारी सल्‍लाह लजी। ओच्‍छे पावलदा आसाइतेधोना तिगै चबा थुङ्बा आल भिसी घ्रान फाजी। ");
INSERT INTO taj_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","चुह्रङ् लसी जाल लबा म्‍हिगदे बोगल न्‍ही भन्‍दा ल्‍हानान मुबा। ");
INSERT INTO taj_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","थेनीगदे परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी गन्‍बागदे मुबा ग्‍लारी निसी चुह्रङ् भिसी भिजी, “ङन्‍से पावलदा आसाइतेधोना तिगै आच भिसी घ्रान फाबा मुला। ");
INSERT INTO taj_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","थेतबासेलमा ह्राङनीदेन अदालत ढिक्‍सी सिपाहीगदेला हाकिमदा चुह्रङ् भिसी पाङ्‍गो, चुला मुद्दाला बारेरी अझ ज्‍यना लसी छिनब लतोःला भिबा स्‍होसी थेदा तेःसी भउ। ओच्‍छे थे चुरी खना खनान ङन्‍से थेदा ग्‍यामरीन साइला।” ");
INSERT INTO taj_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","तर पावलला कोनसे चुह्रङ्बा जाल लबा था याङ्सी ब्‍यारेक न्‍हङरी निसी पावलदा पाङ्सी पिन्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","जमाहेन्‍से पावलसे कप्‍तानगदे न्‍हङला गिकदा ङ्‌योइसी, “चु भ्‍योन म्‍हिदा सिपाहीगदेला हाकिम मुबा ग्‍लारी ससी पिन्‍गो। तिग्‍दा भिसम चुसे थेदा पाङ्तोःबा ताम मुला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","थेतबासेलमा कप्‍तानसे थेदा सिपाहीगदेला हाकिम मुबा ग्‍लारी भोर्सी, “झ्‍याल्‍खानरी मुबा पावलसे ङादा ङ्‌योइसी चु भ्‍योन म्‍हिदा ह्राङ मुबा ग्‍लारी भोर्गो भिसी पाङ्जी। तिग्‍दा भिसम चुसे ह्राङदेन छ्‌याम तिगै ताम पाङ्बा सेम मुला रो” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","जमाहेन्‍से सिपाहीगदेला हाकिमसे थे भ्‍योन म्‍हिदा यारी चुङ्सी कुनी गिकरी भोर्सी, “एसे ङादा तिग ताम पाङ्‌बारी म्‍हाइबा?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ओच्‍छे थे भ्‍योन म्‍हिसे हाकिमदा चुह्रङ् भिसी भिजी, “यहूदीगदेसे पावलला बारेरी अझ ज्‍यना लसी ङ्‌योइबा छार्बा लतोःला भिबा निहुँ लसी न्‍हङगर थेदा अदालतरी भसी पिन्‍गो भिसी ह्राङदा बिन्‍ती लतोःला भिसी सल्‍लाह लबा मुला। ");
INSERT INTO taj_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","तर ह्राङसे थेनीगदेला ताम थाङ्‌यान्‍गो। तिग्‍दा भिसम बोगल न्‍ही भन्‍दा ल्‍हानान म्‍हिगदेसे थेदा आसाइतेधोना तिगै चबा थुङ्बा आल भिसी घ्रान फासी थेदा साइबारी ख्रुङ्‌सी चिबा मुला। दान्‍दे थेनीगदेसे ह्राङसे तिग सुङ्बा चीम थे ताम जे भ्रान्‍सी चिबा मुला।” ");
INSERT INTO taj_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","जमाहेन्‍से सिपाहीगदेला हाकिमसे थे भ्‍योन म्‍हिदा “एसे ङादा पाङ्बा चु ताम स्‍य्‍हान्‍दो खालैदा थापाङ्‍गो” भिसी पुइजी। ");
INSERT INTO taj_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","जमाहेन्‍से सिपाहीगदेला हाकिमसे कप्‍तानगदे न्‍हङला न्‍हीदा ङ्‌योइसी चुह्रङ् भिसी भिजी, “तिनी म्‍हुनना नौ बजेरीक्‍यार ग्‍यार्जा न्‍ही सिपाहीगदेदेन बोगल सोमसे च्‍युइ ताथोरी क्रेःबा म्‍हिगदे ओच्‍छे ग्‍यार्जा न्‍ही भाला पुइबा म्‍हिगदेदा कैसरिया भिबा ग्‍लाधोना निबारी ठीक लसी थान्‍गो। ");
INSERT INTO taj_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ओच्‍छे पावलला लागिरीनोन ता गिक ठीक लसी थेदा बिरोध लबा म्‍हिगदेग्‍याम जोगब लसी यहूदिया अञ्‍चलाधीश फेलिक्‍स मुबा ग्‍लारी भोर्गो।” ");
INSERT INTO taj_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","थेसे चुह्रङ् भिसी चिठी भ्रिजी, ");
INSERT INTO taj_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“माननीय अञ्‍चलाधीश फेलिक्‍सदा क्‍लौडियस लुसियसग्‍याम फ्‍याफुल्‍ला! ");
INSERT INTO taj_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","चु म्‍हिदा यहूदीगदेसे चुङ्सी साइबारी छ्‌याइबा मुबा। तर चु रोमी म्‍हि चीम भिसी ङाइ था याङ्सी सिपाहीगदेदेन छ्‌याम निसी चुदा जोगब लबारी थेनीगदेला याग्‍याम फेसी भजी। ");
INSERT INTO taj_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","तिग तामरी चुदा थेनीगदेसे दोष लजीम भिसी घोबाला लागिरी ङाइ चुदा थेनीगदेला अदालतरीनोन भोर्जी। ");
INSERT INTO taj_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","थेनीगदेसे ह्राङलान ठिमला ङ्‌योइबा तामला बारेरी चुदा दोष लजीम। तर ङाइ चुदा साइतोःबा अथवा झ्‍याल्‍खानरी झाङ्‌तोःबा ह्रङ्‌बा तिगै दोष आस्‍याप्‍नी। ");
INSERT INTO taj_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","चु म्‍हिदा जाल लसी साइबारी छ्‌याइबा ताम था याङ्सी ङाइ चु म्‍हिदा तुरुन्‍तन ह्राङ मुबा ग्‍लारी पुइखबा हिन्‍ना। ओच्‍छे चुदा बिरोध लबागदेदा ह्राङला ङाच्‍छापट्टि बयान पिन्‍गो भिसी ङाइ पाङ्बा मुला।” ");
INSERT INTO taj_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","जमाहेन्‍से सिपाहीगदेला हाकिमसे कुल्‍बा अन्‍छार पावलदा सिपाहीगदेसे म्‍हुनङनोन एन्‍टिपाट्रिस भिबा शहररी भोर्जी। ");
INSERT INTO taj_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","न्‍हङगरदङ ताथोरी क्रेःबा सिपाहीगदेदा पावलदेन छ्‌यामनोन निउ भिसी भिजी। ओच्‍छे भाला पुइबा सिपाहीगदे चा ब्‍यारेकरी दोःसी खजी। ");
INSERT INTO taj_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","कैसरिया भिबा ग्‍लारी धोमाहेन्‍से थेनीगदेसे कैसरियाला मुल हाकिमदा चिठी पिन्‍जी। ओच्‍छे पावलदाएनोन थेला ङाच्‍छापट्टि भजी। ");
INSERT INTO taj_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","थेसे थे चिठी पढब लसी जिन्‍माहेन्‍से पावलदा ए खजिबा जिल्‍लाला हिन्‍ना भिसी ङ्‌योइमा, पावल किलिकिया भिबा ग्‍लाला चीम भिबा था याङ्जी। ");
INSERT INTO taj_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","थेसे “एदा दोष लबागदे खमाहेन्‍से ङाइ एला मुद्दा च्‍याला” भिसी भिजी। ओच्‍छे पावलदा हेरोद ग्‍लेसे स्‍होबा ग्‍लेखाङरी थान्‍गो भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ङारे लिच्‍छा परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हि हननियादेन कोइ कोइ यहूदी गन्‍बागदे तर्तुल्‍लस भिबा वकीलदेन छ्‌याम थेरी खजी। थेनीगदेसे पावलदा बिरोध लबा ताम मुल हाकिम फेलिक्‍सदा घोना लजी। ");
INSERT INTO taj_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","पावलदा थेरी भमाहेन्‍से तर्तुल्‍लससे थेला बिरोध लसी चुह्रङ् भिबारी छ्‌याइजी, “माननीय फेलिक्‍स ह्राङग्‍याम ङन्‍से ल्‍हानान शान्‍ति याङ्बा मुला। ओच्‍छे ह्राङसे ङन्‍ना य्‍हुलला लागिरी ल्‍हानान ज्‍यबा गेगदे लबा मुला। ");
INSERT INTO taj_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","चु ताम ङन्‍से जम्‍मान ग्‍लारी सदन ढन्‍सी ह्राङदा ल्‍हानान धन्‍यवाद पिन्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ङादा ह्राङदेन छ्‌याम ल्‍हानान ताम पाङ्बा सेम आरे। तसैनोन दया लसी ह्राङसे ङन्‍ना ताम गिक ङ्‌यान्‍गो। ");
INSERT INTO taj_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“तिग्‍दा भिसम चु म्‍हि जम्‍बुलिङ नाङलान यहूदीगदेला गुङरी हल्‍ली खल्‍ली लबादेन खानङदमान दुख पिन्‍सी भ्रबा नासरी भिबा समूहला मुल नेता हिन्‍ना। ");
INSERT INTO taj_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ओच्‍छे चुसे परमेश्‍वरला मन्‍दिरदाएनोन नइबा तना लबारी छ्‌याइबान मुबा। थेनोन धुइरी ङन्‍से चुदा चुङ्‌जी। ङन्‍ना ठिम अन्‍छार निसाफएनोन लसेला मुबा। ");
INSERT INTO taj_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","तर सिपाहीगदेला हाकिम लुसियससे ङनी मुबा ग्‍लारी खसी जबरजस्‍ती थेदा ङनीग्‍याम ब्‍यन्‍सी भोर्जी। ");
INSERT INTO taj_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ओच्‍छे चुदा बिरोध लबागदेदा ह्राङला ङाच्‍छा निउ भिसी कुल्‍जी। दाहेन्‍से ङन्‍से चुदा बिरोध लसी पाङ्‌मा ठीक हिन्‍ना कि आहिन भिसी ह्राङसेनोन ङ्‌योइबा छार्बा लमाहेन्‍से था याङ्ला।” ");
INSERT INTO taj_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","थेदेन छ्‌याम खबा यहूदीगदेसेनोन “चु जम्‍मान ताम ठीक हिन्‍ना” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","अञ्‍चलाधीशसे पावलदा ताम पाङ्‌पुङ्‌माहेन्‍से पावलसे चुह्रङ् भिसी पाङ्जी, “ह्राङ ल्‍हानान दिङहेन्‍से यहूदी य्‍हुलला मुल हाकिमदेन न्‍यायाधीश हिन्‍ना भिबा ताम ङाइ था याङ्जी। थेतबासेलमा ह्राङला ङाच्‍छापट्टि ङादा बिरोध लबा तामला बारेरी पाङ्‌म्‍याङ्‌मा ङा ल्‍हानान ताङ्‍बा मुला। ");
INSERT INTO taj_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ङा परमेश्‍वरला मन्‍दिररी परमेश्‍वरदा तेन्‍बारी यरूशलेमरी निबा च्‍युक न्‍ही धिन भन्‍दा ल्‍हाना तबा आरे। चु ताम ह्राङसेनोन था याङ्‌खम्‍ला। ");
INSERT INTO taj_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ओच्‍छे चुगदेसे ङाइ खालै म्‍हिगदेदेन छ्‌याम छलफल लबाएनोन स्‍याप्‍बा आरे। ओच्‍छे परमेश्‍वरला मन्‍दिरदेन यहूदीगदे ह्रुप तबा दिमरी ओच्‍छे शहररी हुल दङगा लबाएनोन स्‍याप्‍बा आरे। ");
INSERT INTO taj_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ओच्‍छे दान्‍दे चुगदेसे ङादा लबा दोषला तिगै सत्‍य ताम ह्राङदा उन्‍बारी आखम। ");
INSERT INTO taj_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“तर चु ताम ङाइ ह्राङलान ङाच्‍छापट्टि पाङ्‌खम्‍ला। ङा थार्बा याङ्बा ग्‍यामरी भ्रसी ङन्‍ना आखे म्‍हेमेला परमेश्‍वरदा तेन्‍बा मुला। चुनोन थार्बा याङ्बा ग्‍यामदा चुगदेसे लुसीला ताम पाङ्बा म्‍हिगदेला समूह भिसी भिमुला। तर ङाइएनोन थेनीगदे भ्रबा ग्‍यामरीन भ्रसी मोशाला ठिमरी मुबा तामदेन अगमवक्तासे भ्रिबा किताबला जम्‍मान तामरी विश्‍वास लबान मुला। ");
INSERT INTO taj_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","थेनीगदेसे ह्रङ् लसीन परमेश्‍वरसे म्‍हन्‍बा अन्‍छारला गे लबा म्‍हिदेन परमेश्‍वरसे म्‍हन्‍बा अन्‍छारला गे आलबा म्‍हि न्‍हीनोन सिबाग्‍याम दोःसी सोला भिसी ङाइएनोन परमेश्‍वरथोरी आश लबा मुला। ");
INSERT INTO taj_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","थेतबासेलमा ङाइ सदन परमेश्‍वरदेन म्‍हिगदेला ङाच्‍छापट्टि ज्‍यबा सेम थोसी भ्रबा मुला। ");
INSERT INTO taj_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“ल्‍हानान दिङ लिच्‍छा ङा ह्राङलान यहूदीगदेदा टाङगा पिन्‍सी ह्रो लबारीदेन परमेश्‍वरदा भेटी फुल्‍बारी यरूशलेमरी खबा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","परमेश्‍वरला मन्‍दिररी भेटी फुल्‍बान लबा धुइरी चुगदेसे ङादा स्‍याप्‍बा हिन्‍ना। थे धुइरी ङाइ चोख्‍याब तबारी लतोःबा जम्‍मान गे लसी जिन्‍बा मुबा। चुगदेसे ङादा परमेश्‍वरला मन्‍दिररी स्‍याप्‍मा ङादेन छ्‌याम खालै म्‍हिला हुल आरेबा ओच्‍छे हुल दङगाएनोन तबा आरेबा। ");
INSERT INTO taj_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","तर एशिया भिबा ग्‍लाग्‍याम खबा कोइ कोइ यहूदीगदेसे ङादा परमेश्‍वरला मन्‍दिररी म्राङ्बा मुबा। चुदे ङाला बिरोधरी तिगै ताम पाङ्तोःबा मुसम थेनीगदे चा ह्राङ मुबा ग्‍लारी खसी ङाला बिरोधरी उजुर लदोमुबा। ");
INSERT INTO taj_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","आहिन्‍सम, ङा यहूदी अदालतला ङाच्‍छापट्टि राप्‍बा धुइरी ङाला तिग दोष स्‍याप्‍जी थे दोष चुरी मुबा म्‍हिगदेसेन पाङ्‌गै। ");
INSERT INTO taj_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","तर ङाइ थेनीगदेला ङाच्‍छा क्रिङ्सी चु ताम जे पाङ्बा हिन्‍ना, ‘सिबागदे दोःसी सोला’ भिसी विश्‍वास लबासे लमा तिनी ह्राङनीला ङाच्‍छा ङादा चु मुद्दा तबान मुला।” ");
INSERT INTO taj_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","चु तामला बारेरी फेलिक्‍सदा जम्‍मान ताम था तबासे लमा थेसे चु ताम थेःमाहेन्‍से पावलदा बिरोध लबागदेदा “सिपाहीगदेला हाकिम लुसियस चुरी खमाहेन्‍से ङाइ एनीगदेला मुद्दा छिनब लसी पिन्‍ना” भिबा स्‍होसी पुइजी। ");
INSERT INTO taj_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","जमाहेन्‍से फेलिक्‍ससे कप्‍तानदा “पावलदा ज्‍यना लसी ख्रुङ्‌सी चिउ, तर थेदा ल्‍हानान कडाएनोन थालउ। ओच्‍छे थेदा तोःबा स्‍हेगदे थेला ह्रोगदेसे पिन्‍बारी खमा थेला ह्रोगदेदा रोकब थालउ” भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","तिगै धिन लिच्‍छा फेलिक्‍ससे ह्राङला यहूदी म्रिङ द्रूसिल्‍लादा छ्‌यामनोन भसी खजी, ओच्‍छे थेसे पावलदा ङ्‌योइसी ख्रीष्‍ट येशूदा विश्‍वास लबा बारेला ताम पावलग्‍याम ङ्‌यान्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","पावलसे थेदा परमेश्‍वरदा सेम निबा गे लतोःबा मुला ओच्‍छे ह्राङसे ह्राङदान तहरी थान्‍सी परमेश्‍वरसे लबा निसाफला बारेरी पाङ्‌मा फेलिक्‍स आत्तेब तसी पावलदा “दान्‍देदा ए निउ, तजी भिसम ङाइ एदा ङ्‌योइला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","पावलसे थेदा टाङगा पिन्‍ना वा भिबा आश लसी पावलदा धुइ धुइरी ङ्‌योइसी ताम लमुबा। ");
INSERT INTO taj_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","न्‍ही दिङ लिच्‍छा फेलिक्‍सला ग्‍लारी पर्किअस फेस्‍तस भिबा हाकिम खजी। ओच्‍छे फेलिक्‍ससे यहूदीगदेदा ताङ्ना लबाला लागिरी पावलदा झ्‍याल्‍खानरीन थान्‍सी निजी। ");
INSERT INTO taj_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","फेस्‍तस मुल हाकिम दोबा सोमरे लिच्‍छा कैसरियाग्‍याम यरूशलेमरी निजी। ");
INSERT INTO taj_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","थेरी परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिगदेदेन यहूदी गन्‍बागदेसे पावलला बिरोधरी दोष लजी। ");
INSERT INTO taj_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ङन्‍ना लागिरी पावलदा यरूशलेमरी पुइखसी ङन्‍दा दया लउ भिसी बिन्‍ती लजी। तिग्‍दा भिसम थेनीगदेसे पावलदा ग्‍यामरी खना खनान साइबारी जाल लबान मुबा। ");
INSERT INTO taj_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","तर फेस्‍तससे थेनीगदेदा चुह्रङ् भिसी पाङ्जी, “पावलदा कैसरियारीन झ्‍याल्‍खानरी थान्‍बा मुला, ओच्‍छे ङाएनोन योनान कैसरियारी दोःसी निबा सेम मुला। ");
INSERT INTO taj_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","एनीगदे न्‍हङला कोइ कोइ नेतागदे ङादेन छ्‌यामनोन कैसरियारी भ्रउ, ओच्‍छे थे म्‍हिसे तिगै आज्‍यबा गे लबा मुसम थेरी थेला दोष उन्‍गो।” ");
INSERT INTO taj_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","जमाहेन्‍से थेनीगदे मुबा ग्‍लारी फेस्‍तस भ्रेःरे च्‍युइरे भन्‍दा ल्‍हाना आचिना कैसरियारी दोःसी निजी। ओच्‍छे न्‍हङगरदङ निसाफ लबा ठिरी चिसी पावलदा भसी खउ भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","पावल धोखमाहेन्‍से यरूशलेमग्‍याम खबा यहूदीगदे थेला क्‍युर्सीन राप्‍जी। ओच्‍छे पावलला बिरोधरी हिन्‍बा आहिन्‍बा तामला दोष लजी। तर थेनीगदे ह्राङसेन पाङ्‌मा सत्‍य हिन्‍ना भिसी उन्‍बारी आखम्‍नी। ");
INSERT INTO taj_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","जमाहेन्‍से पावलसे ह्राङला ताम पाङ्‌बान, “ङाइ यहूदीगदेदा मोशासे पिन्‍बा ठिम, परमेश्‍वरला मन्‍दिरला बिरोधरीदेन रोमी ग्‍याल्‍बो कैसरला बिरोधरी तिगै आज्‍यबा गे लबा आरे” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","तर फेस्‍तससे यहूदीगदेदा ताङ्ना लबाला लागिरी पावलदा “तिग ए यरूशलेमरी निसी थेरी ङाला ङाच्‍छा चु तामला बारेरी निसाफ लसी पिन्‍गै भिसी म्‍हन्‍बा मुला?” भिसी ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","तर पावलसे चुह्रङ् भिसी भिजी, “ङा रोमी ग्‍याल्‍बो कैसरसे निसाफ लबा ठिला ङाच्‍छा राप्‍सी चिबान मुला। थेतबासेलमा ङाला निसाफ चुरीन ततोःला। ङाइ यहूदीगदेदा तिगै नइबा गे लबा आरे भिबा ताम ह्राङदा थानोन मुला। ");
INSERT INTO taj_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","चुदे ङाइ ङादा साइतोःबाधोनाला गे लबा मुसम ङादा साइसैनोन ठीक मुला। तर ङादा यहूदीगदेसे लबा दोषला तिगै सत्‍य ताम उन्‍बारी आखम्‍सम ङादा खालैसे थेनीगदेला यारी जिम्‍मा पिन्‍बारी आम्‍याङ्। तर रोमी ग्‍याल्‍बो कैसरसेन ङाला चु मुद्दा च्‍यासी पिन्‍गै भिबा ङाला बिन्‍ती मुला।” ");
INSERT INTO taj_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","जमाहेन्‍से फेस्‍तससे ह्राङदा सल्‍लाह पिन्‍बा म्‍हिगदेदेन छ्‌याम सल्‍लाह लसी, “एसे रोमी ग्‍याल्‍बो कैसरदा बिन्‍ती लजी। थेतबासेलमा ए रोमी ग्‍याल्‍बो कैसर मुबा ग्‍लारीन नितोःला” भिसी भिजी। ");
INSERT INTO taj_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","तिगै धिन लिच्‍छा अग्रिपास ग्‍लेदेन थेला आङा बरनिकी फेस्‍तसदा मान लबारी कैसरियारी खजी। ");
INSERT INTO taj_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","थेरी थेनीगदे ल्‍हानान धिन चिमाहेन्‍से फेस्‍तससे पावलला मुद्दा ग्‍लेदा उन्‍बान चुह्रङ् भिसी भिजी, “चुरी फेलिक्‍ससे झ्‍याल्‍खानरी थान्‍बा म्‍हि गिक मुला। ");
INSERT INTO taj_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","थेला बारेरी ङा यरूशलेमरी निमा परमेश्‍वरला मन्‍दिररी पूजा लबा मुल म्‍हिदेन यहूदी गन्‍बागदेसे थेला बिरोधरी दोष लसी थेदा सिबाला सजाय पिन्‍तोःला भिसी ङादा पाङ्मुबा। ");
INSERT INTO taj_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","तर ङाइ थेनीगदेदा चुह्रङ् भिसी भिजी, ‘दोष आस्‍याप्‍तेधोना खालै म्‍हिदा सिबाला सजाय पिन्‍बा रोमीगदेला ठिम आरे। ओच्‍छे दोष लबा म्‍हिला ओन्‍छाङरी दोष तबा म्‍हिसे ह्राङला बारेरी ताम पाङ्‌म्‍याङ्‍तोःला।’ ");
INSERT INTO taj_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","थेतबासेलमा थेनीगदे चुरी खमाहेन्‍से ङाइ योना लसीन न्‍हङगरदङनोन निसाफ लबा ठिरी चिसी थेदा भसी खउ भिसी कुल्‍जी। ");
INSERT INTO taj_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","जमाहेन्‍से पावलदा दोष लबा म्‍हिगदेसे राप्‍सी पावलसे लबा आज्‍यबा गेला दोष उन्‍ना भिसी ङाइ म्‍हन्‍बा मुबा। तर थेनीगदेसे ङाइ म्‍हन्‍बा अन्‍छार तिगै दोष उन्‍बारी आखम्‍नी। ");
INSERT INTO taj_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","बरु थेनीगदे न्‍हङरी आढिक्‍बा ताम चा सिसी जिन्‍बा येशूला बारेरीदेन थेनीगदेलान धर्मला बारेरी मुबा। ओच्‍छे पावलसे चा येशू अझ सोबान मुला भिसी पाङ्बा मुबा। ");
INSERT INTO taj_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","जमाहेन्‍से चु ताम तिग हिन्‍ना भिसी सत्‍य ताम था याङ्बारी ङा अलमल तबासे लमा चु तामला बारेरी निसाफ लबारी यरूशलेमरी निबा सेम मुला कि भिसी ङाइ पावलदा ङ्‌योइजी। ");
INSERT INTO taj_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","तर पावलसे रोमी ग्‍याल‍बोग्‍याम छिनब आततेधोना ङादा चुरीन झ्‍याल्‍खानरी थान्‍गो भिसी बिन्‍ती लबासे लमा थेदा रोमी ग्‍याल्‍बो कैसर मुबा ग्‍लारी आ