﻿USE sofia;
DROP TABLE IF EXISTS sofia.tacNT_vpl;
CREATE TABLE tacNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tacNT_vpl WRITE;
INSERT INTO tacNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jena apélichi uchú suwábaga ralámuli rewalá, alué napu Esukristo rijimala nílige, alué napu 'ya mochígame nílige Esukristo ta'chó ochérachi. Alué Rabí 'lige Abraámi abiena rijimala nile alué Esukristo, alué ralámulika 'we 'ya ejperégame nílechigó ta'chó ochérichi Esukristo. ");
INSERT INTO tacNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Alué Abraámika Isaki o'nola nile. 'Lige Isákika Akobo o'nola nile. 'Lige Akóboka Jurá o'nola nile 'lige alué Jurá chega rijimala o'nola nile. ");
INSERT INTO tacNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","'Lige Juraka Páresi o'nola nile, 'lige abiena Sárachigó. Alué Páresi 'lige Sara eyélaka Tamari anilime nile. 'Lige Páresika Esromi o'nola nile. 'Lige Esrómika Arami o'nola nile. ");
INSERT INTO tacNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","'Lige Arámika Aminarabi o'nola nile. 'Lige Aminarábika Naasoni o'nola nile. 'Lige Naasónika Salmoni o'nola nile. ");
INSERT INTO tacNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","'Lige Salmónika Bosi o'nola nile. 'Lige Bosi eyélaka Rajabi anilime nile. 'Lige Bósika Oberi o'nola nile. 'Lige Oberi eyélaka Ruti anilime nile. 'Lige Obérika Isaí o'nola nile. ");
INSERT INTO tacNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","'Lige Isaíka alué wa'lula Rabí o'nola nile. 'Lige Rabika Salomoni o'nola nile. 'Lige Salomoni eyélaka Uríasi anilime rió 'yula nile. ");
INSERT INTO tacNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","'Lige Salomónika Roboami o'nola nile. 'Lige Roboámika Abíasi o'nola nile. 'Lige Abíasika Asa o'nola nile. ");
INSERT INTO tacNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","'Lige Ásaka Josapati o'nola nile. 'Lige Josapátika Jorami o'nola nile. 'Lige Jorámika Usíasi o'nola nile. ");
INSERT INTO tacNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","'Lige Usíasika Jotami o'nola nile. 'Lige Jotámika Akasio o'nola nile. 'Lige Akásioka Esekíasi o'nola nile. ");
INSERT INTO tacNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","'Lige Esekíasika Manasesi o'nola nile. 'Lige Manasésika Amoni o'nola nile. 'Lige Amónika Josíasi o'nola nile. ");
INSERT INTO tacNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","'Lige Josíasika Jekoníasi o'nola nile 'lige alué chega rijimálachigó. A'lige bamí o'tole alué sontalo Babilonia mochígame alué ralámuli israelita, preso o'tole. ");
INSERT INTO tacNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","A'kinana napu'lige ku sebasa alué ralámuli ku alé Israeli anilichi, Jekoníasika Salatieli o'nola nile. 'Lige Salatiélika Sorobabeli o'nola nile. ");
INSERT INTO tacNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","'Lige Sorobabélika Abiuri o'nola nile. 'Lige Abiúrika Eliakimi o'nola nile. 'Lige Eliakímika Asori o'nola nile. ");
INSERT INTO tacNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","'Lige Asórika Saroki o'nola nile. 'Lige Sarókika Akimi o'nola nile. 'Lige Akímika Eliuri o'nola nile. ");
INSERT INTO tacNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","'Lige Eliúrika Eleasari o'nola nile. 'Lige Eleasárika Matani o'nola nile. 'Lige Matánika Akobo o'nola nile. ");
INSERT INTO tacNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Akóboka José o'nola nile alué napu María 'yula nílige. 'Lige alué Maríaka Esusi eyela nile, alué napu Kristo anilime ju. (Krístoka aniame ju Onorúgamete julárigame. Jípeko Esukristo anilime júkuru.) ");
INSERT INTO tacNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Makué naómana chojkégame nile alué Abraámi rijimala Rabí ta'chó ochérachi, 'lige Rabí ochérale. 'Lige alué Rabí rijimala abechigó makué naómana chojkégame nile. 'Liko alué ralámuli israelita 'ma o'tóleru alé Babilonia anilichi. 'Lige a'kinana alué simírasa uchéchigo makué naómana chojkégame o'chérale. 'Liko bijí ta'chó ochérale alué Kristo, alué napu Onorúgame júlale. ");
INSERT INTO tacNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jipe 'la ruimé ne churigá ochériligo Esukristo: Maríaka tárigame nílekuru José 'yuga newímili nile, 'lige tabilé 'cho 'yuga gojchichi José alué María 'yuga, alué María 'ma wa'lú rojparale u'tátiri ajchágame nile rojpachí, Onorúgame Alawala 'sile napurigá rojparámala alué María. ");
INSERT INTO tacNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","'Lige José tabilé che ikisá nílele chu'simia. Alué Joseka uché bilé rió 'yuga gojchíligo mayele alué María. Tabiléchigo che aníleko, 'we a'lá ralámuli nile alué José, alué Joseka tabilé chojkila neraga che'wánilile alué María. Alué Joseka tabilé najkile napurigá chijunámala alué María uché jaré ralámuli 'yuga. Alekeri tabilé che aninálile, 'lige tabilé newima olale alué mukí 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","'Lige 'we 'nátale alarigá 'simia, 'lige bilé rukó remule bilé santo ánjeli. 'Lige alué santo ánjeli anele alué José: ―Mué José, mueka Rabí rijimala júkuru, alué 'we 'ya bejtégame. Tase majawa newía alué María 'yuga. Alué napu ranélimili ju María, alueka pecha bilé rió ranala nímalagó, pe Onorúgame Alawala 'sile napurigá ochéramala alué u'tátiri. ");
INSERT INTO tacNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Alué Maríaka bilé u'tátiri ranélimili júkuru, 'lige mueka Esusi anilime rewá ujchémili júkuru. Esusi aniáká alueka aniame júkuru «alué napu ralámuli buinámili ju alé resítirichi.» Asíriga 'la alarigá nímala. ");
INSERT INTO tacNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Suwábaga alarigá ikile napurigá anílige Onorúgame. Alué rió napu ruyame nile napu Onorúgame anele regá anile: ");
INSERT INTO tacNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Bilé mukí tabilé 'wesi rió 'yuga asigá pe bi'neli asigá rojparámala u'tátiri ajchágame nímala. 'Lige ochéramala alué u'tátiri, 'lige Emanueli anilime nímala. Emanuélika pe aniame ju «Onorúgame 'la ramué 'yuga ajtí.» ");
INSERT INTO tacNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Napu'lige José bujsasa, alarigá 'sile napurigá nulélige alué santo ánjeli alué napu Onorúgame júlale. 'Liko alué José 'ma o'tole María bo'né bejtélachi napurigá bo'né 'yula neraga. ");
INSERT INTO tacNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tabiléchigo 'yuga gojchile ko ta'chó ochérachi alué u'tátiri, 'lige 'ma ochérasa alué u'tátiri, Joseka Esusi anilime rewá ajchele alué u'tátiri. ");
INSERT INTO tacNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Esúsika Beleni anilichi ochérale, alé ejiro Jurea anilichi. Esúsika ochérale napu'lige Erore wa'lula nulame kachi alé alué we'é bo'ígichi. 'Lige alé we'ká riógichi Rusaleni anilichi sébale jaré rió so'pilí 'we machime. «Mago» anilime nile alué rió yolí ra'íchaga. 'Lige 'nákatu napu rayénali ma'chíname ju alé Rusaleni asiruga, aleka neraga jsile alué rió. ");
INSERT INTO tacNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","'Lige alué ralámuli «mago» alé we'ká riógichi Rusaleni sébaga rukele alué wa'lula Erore: ―¿Koche ajtí alué wa'lula ralámuli jurío nuleme alué napu kulí ochérale? Alé 'nákatu napu rayénali ma'chíname ju jena Rusaleni asiruga aleka enágame etératuru bilé so'pilí, 'lige alué so'pilika pe ruyame ju 'ma ochériligo alué napu Wa'lula nímili ju. Alekeri jsirúpá ramué 'we a'lá nirániliga. ");
INSERT INTO tacNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","'Lige alué wa'lula Erore akisá alué ra'íchali, asíriga we'ká 'nátale. 'Lige aminá uché jaré ralámulitiri alé Rusaleni mochígame asíriga we'ká 'nátalechigó alué ra'íchali akisá. ");
INSERT INTO tacNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","'Lige alué wa'lula Erore suwábaga balé e'wélala bayele, 'lige aminami alué e'wélala Moisesi nila nulalí benírame abiena bayéleru. 'Lige rukele koche ochérimili níliga alué Kristo, alué napu Onorúgame julámili nílige. ");
INSERT INTO tacNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","'Lige anile alué ralámuli: ―Alé Beleni anilichi ochéramili ke, alé napu Jurea anilime ejiro ju. Alarigá osale alué napu ruyame nílige napu Onorúgame anélige, napu 'ya bejtégame nile. 'Lige regá anime osale: ");
INSERT INTO tacNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Alé we'ká riógichi Beleni anilichi napu ju Jurea anilichi ejiro, pe u'kabi riógame ju alé Beleni, 'wéchigo najtékame kéréko me'tagá suwábaga we'ká riógachi, aléchigo ochérimili kame Wa'lula, alué napu ne'chí oyérame ralámuli israelita anilime repúmili ju abé i'libeko. ");
INSERT INTO tacNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","'Liko alué wa'lula Erore alué ralámuli «mago» bayele. Alué Eróreka tabilé najkile napurigá uché jaré ralámuli machimela alué rió 'yuga ra'ichálichi. 'Liko rukele chiéniko kachi ma'chíniliga alué so'pilí. ");
INSERT INTO tacNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","'Liko alé we'ká riógichi Beleni júlale, 'lige anele: ―'Mi alé Belénichi simáwagó alué u'tátiri e'nemia pala ajtigá. 'Lige 'la rewisúká alué u'tátiri, 'liko yati juláwaká bilé rió ne'chí ruyéniliga, néchigó simémpá alemi e'nemia, 'lige 'we a'lá niramia aminami. (Eróreka pe me'lináliga anile alué u'tátiri.) ");
INSERT INTO tacNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","'Lige gepusa alué ra'íchali napurigá anílige alué wa'lula Erore, 'liko yati simíbale alué «mago». 'Lige uchéchigo siné etele so'pilí. 'Lige alué so'pilí re'pami rewigáchimi neraga enale, bajchabemi enale napu e'yénale alué ralámuli «mago», 'mi alemi enale napu asale alué u'tátiri. 'Lige asíbale alué so'pilí alé amóbami neraga napu asale alué u'tátiri. ");
INSERT INTO tacNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Alué bakiá rió etesa alué so'pilí, asíriga ra'sálále. ");
INSERT INTO tacNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","'Lige galírale sébaga etele alué u'tátiri a'bé bo'igó eyela ajtígichi María anilime. 'Liko chojkóbisiga jábale 'we a'lá nirame kórigá alué u'tátiri. 'Lige gajoni i'pule, alué gajónika pe e'karúgame mochígame nile kónilime asíriga najteme. 'Oro kógile, 'lige aminami o'kuítiri, 'lige aminami bilé tábiri 'we a'lá suwé júkame «mira» anilime. ");
INSERT INTO tacNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","'Lige okoka bi'tigá alué «mago», Onorúgame remule, 'lige remugichi anele tabilé simánilile ku napu asálige alué Erore. Alekeri ku ejperélachi simíbale, se'wí boichí simárale. ");
INSERT INTO tacNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","A'kinana napu'lige alué ralámuli «mago» ku ejperélachi simasa, José bilé santo ánjeli etele remuka. 'Lige alué ánjeli anele alué José: ―'Ma asísawa, yati simigá 'ma mutuka alué u'tátiri 'lige 'ma 'yúriwa mué upila, wamí Ejipto anilime we'é bo'ígichi simawa. Alé mochiwa napu'lige ne aní a'lige si. Eróreka alué u'tátiri 'yaga einámala me'lináliga. Alekeri júmasawa jena mochiga. ");
INSERT INTO tacNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","'Lige José 'ma asísale 'lige u'tátiri mutule 'lige simile eyélatiri 'yuga, 'lige rukó júmasale, Ejipto simiba. ");
INSERT INTO tacNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Wamí 'mi alé Ejipto mochile napusí Erore mukusá. Onorúgame 'ya anile alarigá ikimeo. Alekeri lakile napurigá osale bilé rió napu ruyame nile napu anélige Onorúgame. Regá anile: «Neka bayékuru ne inolá alé Ejipto ajtígachi.» ");
INSERT INTO tacNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Napu'lige alué Erore machisá alué ralámuli «mago» ku simíbaligo tabilé ruigá, asíriga ayoga rejpile. 'Liko nulale me'líniliga suwábaga u'kuchítiri oká bamígame go'nágana, alé we'ká riógichi Beleni o'chérigame, 'lige aminami alé a'bemi we'ká riógichi o'chérigimetiri. Alué ralámuli «mago» bajchá etéligame so'pilí anilía 'ma oká bamí nílekuru, alekeri me'linálile u'kuchítiri alué Erore oká bamígame 'lige ta'chó oká bamime. ");
INSERT INTO tacNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","'Lige alarigá sébali ikile napurigá osale alué rió napu ruyame nile napu Onorúgame anélige napu Jeremíasi anilime nile, regá anime osilí: ");
INSERT INTO tacNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Suwábaga alué ralámuli alé we'ká riógichi Ramá mochígame asíriga akéturu 'we sewékame nalachi bilé mukí alué mukí Rakeli anilime asíriga nalá ajtigéturu 'kúchila na'temaka. 'Lige alué Rakeli tabilé najkíturu napurigá gu'íriwa, alué u'kuchítiri 'máchigo suwíligime. ");
INSERT INTO tacNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Napu'lige Erore mukusá a'kinana, José etele remuka bilé santo ánjeli. Onorúgame nuleme nile alué santo ánjeli. 'Lige alué José Ejipto asale. 'Lige anele alué santo ánjeli alué José: ");
INSERT INTO tacNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―'Ma asísawa, 'ma ku 'yúriwa ye u'tátiri 'lige eyélatiri, 'ma ku 'mi simawa Israeli anilichi. 'Máchigo suwíligame alué napu ye u'tátiri me'linálime nílige. Alekeri jípeko 'la júkuru ku 'mi alé simalia. ");
INSERT INTO tacNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","'Lige asísale alué José 'lige u'tátiri o'tole 'lige eyélatiri ku 'mi alé Israeli anilichi. ");
INSERT INTO tacNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","'Lige napu'lige José machisá alué Erore inolá Arkelao anilime wa'lula karao alé Jurea anilichi ejiro, asíriga majale alué José, tabilé siminálile 'mi alé. 'Lige José remule Onorúgame. 'Lige Onorúgame 'we a'lá anele alué José napurigá Galilea anilichi ejiro 'lina simela, alekeri simile alué José alé Galilea anilichi ejiro. ");
INSERT INTO tacNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","'Lige alé sebasa Nasareta anilichi we'ká riógichi simíbale ejperélimia. Alué 'ya mochígame ralámuli napu ruyame nílige, napu anele Onorúgame anile alé Nasarétachi bejtélimio alué Esusi. Anile «nasareno» anélime nímará Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","A'kinana we'ká bamí alué Juani napu ralámuli rewarame nílige, nawale alé Jurea anilime ejírochi napu ta'wesi galí jágichi nílige. 'Lige alé pee u'kume nile, 'lige ba'wí ename nile alé. 'Lige rejcholi ruwile alé sebasa. ");
INSERT INTO tacNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Anile: ―'Ma a'rewa alué chátiri 'nátili. 'Ma ku 'la na'tawa, 'máchigo pe 'we nawámili kame Onorúgame suwábaga ralámuli nulemia. ");
INSERT INTO tacNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Alué rió napu ruyame nílige napu anélige Onorúgame, 'we 'ya bejtégame nílige, alué napu Isaíasi anilime nile, alué 'sile osá alarigá nochamio alué Juani. Regá anime osale: Bilé ne'ome akerúguru alé napu pee u'kume nile. Regá e'wele ra'icháchane: «Newiwa bilé bowé Wa'lula Onorúgame. Newiwa bilé bowé 'la wajchígame.» ");
INSERT INTO tacNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","'Lige alué Juani o'páchalaka kameyo anilime ajágame gupala newárigime nile. 'Lige wi'chí wasíbaligame nile. 'Lige ojchí go'yame nile alué Juani, 'lige aminami ijampre ba'wila melalo go'yame nile, alué napu jami nerúgame 'ínili. ");
INSERT INTO tacNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","'Lige wamí 'naka we'ká riógachika Rusaleni anilíchika jsile ralámuli alué rejcholi akimea, 'lige we'kaná riógichika jsile alé Jurea anilichi ejiro mochígame. 'Lige abiena jsile uché bilena we'kaná riógame na'lebo 'nálige wa'lú bakó bo'ígichi ejperégame, Jorani anilime bakó. ");
INSERT INTO tacNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Napu'lige ralámuli ruisá 'we resí nokigá járome koriá, najkigá nokale napurigá Onorúgame 'la e'kámala, 'liko Juani rewarale alué ralámuli alé Jorani anilichi bakochi. ");
INSERT INTO tacNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","'Lige jaré rió jurío sébale okaná chojkégame. Ye okaná chojkégame bariseo nile jaré, 'lige saruseo nile jaré. 'We benírame nile napurigá 'we a'lá gatewa bilé nóchali, a'boi 'lina tabiléchigo sébali olame nílekó. Alueka pe jsile najkigá napurigá rewarawa ba'wichí bokobuga Juánite. 'Lige Juani anele e'wele ra'íchaga: ―¡'Émika pe napurigá sinowí 'kúchila alarigá júkuru, asíriga 'yégame júkuru 'emi! ¿Chieri aníbeché júmasiwa napurigá tabilé gastigáriwa? ");
INSERT INTO tacNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","'Ma a'réwaguru alué tabilé 'la nóchali nocha napurigá suwábaga ralámuli 'la etémala 'emi 'ma ku 'we a'lá 'nátili 'nátame ko. ");
INSERT INTO tacNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","'Émika Abraámi rijimala korime júkuru, alué 'we 'ya ajtígame, alekeri mayé 'emi Onorúgame 'la e'kamio. Tase alarigá na'tawa, tabilé chéré rekó rijimala nírige Abraámi. Onorúgameka pe napuyépiri ralámuli e'kame ju, pe 'la Onorúgame 'yuga 'nátame nísaká alué ralámuli. Onorúgame alarigá na'tásaká rejtétiri 'ma Abraámi rijimala gainámaleké. ");
INSERT INTO tacNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Rejpilaka 'ma listo bo'í napurigá rojá me'tépua. Suwábaga rojá napu ekí tabilé rakeme ju 'ma me'tékime júkuru 'lige e'kósilime ju. ");
INSERT INTO tacNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Neka pe iligá ba'wite rewaráguru, napurigá ralámuli etémala 'emi 'ma a'réligo alué chátiri 'nátili. Abé i'libeko uché bilé sebámala abéchigo najtékame me'tigá ne'chí. Alueka Onorúgame Alawala 'yámala ralámuli. Neka tabilé ikiáré napurigá ne alué rió akalá o'toa napurigá pioni neraga. ");
INSERT INTO tacNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Alueka 'ma wejpamoa chujkúkuru ri'ligó sonolá e'kósimia. 'Lige rakálaka 'ma gatémala bilena rekóachi, 'lige sonolaka 'ma e'kósamala na'ite. 'Lige tajsiné cho'mela alué na'í. Yeka pe tétali ju. ");
INSERT INTO tacNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","'Lige sébale Esusi alé bakochi Jorani anilichi, alé Galilea anilíchika simile alué Esusi. 'Lige alé ilile Juani, 'lige Esusi najkile napurigá rewarawa alué Juánite. ");
INSERT INTO tacNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Napu'lige sebasa alué Esusi, 'lige Juánika tabilé rewaránilile alué Esusi, 'lige anele Juani alué Esusi: ―Ne 'nalina rewarárigame nímili júkuru muete. ¿Chonigá najkí mué napurigá ne mué rewarámala? ");
INSERT INTO tacNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","'Lige Esusi anile: ―Abiena 'la julke mué ne'chí rewará. Onorúgameka larigá najkiame, 'la 'we a'lá sébali oliame júkuru napurigá najkí Onorúgame. 'Liko Juani rewarale alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Napu'lige Esusi rewarásiga ba'ichí bokobuga 'lige ku ma'chínasa aminá suwemi, 'pa rewagachi 'ma i'púriga ilíbale 'lige Esusi etele Onorúgame Alawala 'pákana enágichi napuyeri bilé baloma neraga. ");
INSERT INTO tacNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","'Lige bilé ra'íchame anile 'pa rewigáchika. Regá anile: ―Ye júkuru ne Inolá napu 'we galé ne. Asíriga 'la ganíliga ajtí ne alué 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","'Liko Onorúgame Alawálate o'tóleru Esusi 'mi bilena tabilé riógachi. Remónisika 'we 'yégali olánilile Esusi napurigá Esusi tabilé 'la nochámala. ");
INSERT INTO tacNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Esúsika oká liá rawé 'lige rukomi tabilé go'ale. A'kinana kulí e'luíle. ");
INSERT INTO tacNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","'Lige Remónisika a'bé nawile 'yéginiliga Esusi, 'lige anele Remónisi alué Esusi: ―'La bijchiá Onorúgame Inolá níriká, baní gaináriwagó alué we'ká rejté. ");
INSERT INTO tacNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","'Lige Esusi nejele: ―Onorúgame nila ra'íchali aní: «Tase pe go'ámecho go'gá ejperélamala ralámuli, abiena semátiri ra'íchali Onorúgame nila rejcholi 'nátaga ejperélamala ralámuli.» ");
INSERT INTO tacNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","'Liko alué Remónisi Rusaleni o'tole Esusi 'lige asíriga re'pá ilígame wa'lú re'obachi amoba 'mórale, ");
INSERT INTO tacNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","'lige anele: ―'La bijchiá Onorúgame Inolá níriká 'légana o'pachípuagó jena iligá. Regá aní Onorúgame nila ra'íchali: We'ká santo ánjeli julámala ne napurigá mué repúmala. Alué santo ánjeli nokimela mué cha'piá sekate napurigá ta iwégame chibámala mué 'légana wijchí. ");
INSERT INTO tacNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","'Lige Esusi anile: ―Abiena regá aní Onorúgame nila ra'íchali: «Tabilé o'pochípua napurigá Onorúgame mué gu'írimala, mueka pe tonto neraga re'eme kame.»Onorúgameka tabilé najkí napurigá bilé tonto neraga o'pachípua. ");
INSERT INTO tacNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","'Lige alué Remónisi uchéchigo siné o'tole Esusi bilena rabó re'pá ilígame, ");
INSERT INTO tacNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","'lige anele alé o'tosá: ―'Nee, aka e'nébá bochígimi gawichí napu ma'chí 'lige suwábaga ralámuli etéru'é napu ekí mochí jena wijchimoba, aka e'nébá asíriga 'la suwétiri kámpá. 'Lige suwábaga ye 'yámala ne mué 'la chojkóbisiga iligá nirásaká mué ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","'Lige Esúsika anele: ―'Mi simigá mué Satanasi, cha 'yégame ke. Regá aní Onorúgame ra'ichálila: «Pe alué Wa'lula Onorúgamecho 'la niraga etewa, pe alekecho 'la e'wiwa.» ");
INSERT INTO tacNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","'Liko alué Remónisi 'ma waná simile alé Esusi ajtígichi. 'Liko yati neraga jsile santo ánjeli go'ame 'yamia Esusi, 'lige aminami gu'írimia. ");
INSERT INTO tacNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Esusi akele Juani galírale bajcháriga ajtigó. 'Lige simile Esusi uchéchigo ku Nasareta anilichi Galilea ejírochi. ");
INSERT INTO tacNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tabiléchigo bejterálekó alé Nasareta anilichi, pe chebilena we'ká riógichi simile bejteramia Kapernaumi anilichi. Alé a'bé nile wa'lú ba'wí ilígichi. 'Yako alé sébale alué ralámuli israelita napu Sabuloni chojkégame nile, 'lige napu Neptalí chojkégame nile napu'lige bajchá sébalige alué ralámuli israelita alé Kanani. Makué oká chojkégame nile alué ralámuli israelita. ");
INSERT INTO tacNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Alueka alé simílekuru, alarigáchigo osáligime 'ya bejtégame rió Isaíasi anilime, napu ruyame nílige napu Onorúgame anélige alarigá ikimeo. Regá anime osale: ");
INSERT INTO tacNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Alué we'é Sabuloni anilime 'lige Neptalí anilime, napu wa'lú ba'wí ilí, alé simírame bowé bo'í, alé ju, alé napu Jorani anilime bakó bo'í, alemi napu bokuíme ju rayénali Jorani anilichi asiruga, napu jipe ju ejiro Galilea anilime, napu ejperégame nile ralámuli tabilé jurío. ");
INSERT INTO tacNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Alué ralámulika tabilé machime ju Onorúgame. Jípeko 'máchigo sébako Onorúgame Inolá napurigá bilé ra'ósali neraga. 'Lige alué ralámuli asíriga resítiri nóchali nocha mochile. Jípeko 'ma sébaguru 'we a'lá semátiri ra'ósali. Jípeko 'ma námamaleké alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","'Lige alé sebasa Esusi, a'lige kulí o'wínale rejcholi beniria. Regá anile: ―'Ma a'rewa alué resítiri nóchali. 'Ma amulí seba raweli napurigá Onorúgame suwábaga ralámuli nulémala. Alekeri 'ma ku 'la 'nátame gainawa. ");
INSERT INTO tacNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Esusi enale suweke wa'lú ba'wí ilígichi Galilea anilichi. 'Lige alué Esusi oká rió etele bi'lepi o'nógame. Bilé Simoni anilime nile. Oká rewégame nile alué Simoni, Pegro anilime nílechigó. 'Lige uché bileka Antresi anilime nile. 'Lige alué rió ba'ichíkana pa uchule alué morali ro'chí cha'pináliga alué morálite. ");
INSERT INTO tacNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","'Lige anele Esusi alué oká rió: ―Jeka simasi ne'chí 'yuga. Jípeko 'emi nokimela ralámuli gu'iria buyana chátiri bowechi e'yéname. ");
INSERT INTO tacNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","'Lige alué oká rió a'rele alué morali 'lige simíbale alué Esusi 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","'Lige abé a'mibemi e'yéniga Esusi uchéchigo jaré rió etele. Santiago anilime nile bilé, 'lige uché bilé Juani anilime nile. Sebereo 'kúchila nile alué oká rió. Bilé bárkochi mochile alué oká rió o'nola 'yuga morali napisua. 'Lige Esúsika bayele alué rió. ");
INSERT INTO tacNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","'Lige 'ma a'rele alué barko o'nola 'yúriga, 'lige simíbale Esusi 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Esusi bochígimi eyénale alé Galilea anilichi ejiro. Napu ekiná we'ká riógichi Esusi ruwile Onorúgame ra'ichálila ra'íchali 'lige napu ekiná u'kuchí jurío re'obálachi alé «sinagoga» anilichi. 'We a'lá semáriga ruwile alué ra'íchali churigá nulamio Onorúgame. 'Lige suwábaga ralámuli sa'wale napu ekí nayúkame nile. ");
INSERT INTO tacNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","'Liko suwábaga ralámuli napu ichúrimi ejperégame nílige Siria anilichi 'ma akele alarigá nocha ajtigó Esusi. 'Lige a'pale suwábaga ralámuli napu ekí nayúkame nílige, jaré asíriga a'wágame o'kome, 'lige jaré u'kuchípala remónisi mochígame, 'lige jaré rekúpame, 'lige jaré sujírigame. 'Lige Esúsika 'ma suwábaga sa'wale. ");
INSERT INTO tacNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","'Lige asíriga we'ká ralámuli najátale alué Esusi. Alé Galilea anilime ejiro mochígame, 'lige ejiro Rekápolisi mochígame ralámuli abiena najátale Esusi, 'lige Rusaleni mochígame ralámuli abiena najátale Esusi. 'Lige Jurea ejiro mochígame ralámuli abiena najátele Esusi. 'Lige alé bakochi Jorani na'lebo 'nálige 'omi niraga napu ma'chínami ju rayénali we'ká riógachi mochígame ralámuli abiena najátale Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Napu'lige Esusi suwábaga ralámuli etesa, bilena rabomi simile 'lige asíbale alé rabomi. 'Lige alué oyérame ralámulika a'bé mochíbale. ");
INSERT INTO tacNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","'Lige Esusi o'wínale ra'icha ralámuli beniria. ");
INSERT INTO tacNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Regá anile Esusi: ―Onorúgameka 'we ganíliga eteme ju (yolí ra'íchagaká ‹‹dichoso›› anime chujkú) alué ralámuli 'la machime rokárikó Onorúgame a'walila. Onorúgame 'we a'lá nulémala alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","› Onorúgame 'we ganíliga eteme ju alué ralámuli napu jipe 'we seweka mochí, alué ralámuli 'we a'lá semati raweli 'yawa Onorúgamete. ");
INSERT INTO tacNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","› Onorúgame 'we ganíliga eteme ju alué ralámuli napu tabilé riólame ju. Alué ralámulika 'la narémala alué napu Onorúgame nejímili ju. ");
INSERT INTO tacNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","› Onorúgame 'we ganíliga eteme ju alué ralámuli napu 'we a'lá bijchiá e'wánilime ju napu Onorúgame nulame ju. Onorúgameka 'we a'lá nabí gu'írimala alué ralámuli napurigá 'la bi'lepi na'támala senibí Onorúgame 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","› Onorúgame 'we ganíliga eteme ju alué ralámuli napu 'we na'temame ju uché jaré ralámuli. Onorúgamechigó a'chigóriga na'temámala alué ralámuli napu na'temame ju alué uché jaré ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","› Onorúgame 'we ganíliga eteme ju alué ralámuli napu Onorúgame 'yuga 'nátame ju. Bilé rawé etémala Onorúgame alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","› Onorúgame 'we ganíliga eteme ju alué ralámuli napu gu'írime ju uché jaré ralámuli, napurigá alué uché jaré ralámuli 'la bi'lepi 'nátame nímala. Alué ralámulika regá anéwali Onorúgamete: «'Émika ne 'kúchila ju.» ");
INSERT INTO tacNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","› Onorúgame 'we ganíliga eteme ju alué ralámuli napu 'we resí oliame ju ralámulite napu 'la sébali olame ju napurigá najkí Onorúgame. Onorúgameka asíriga 'la semáriga nulémala alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","› Onorúgame 'we ganíliga eteme ju 'emi napu'lige resí anilíe ralámulite ne'chí oyérame kóriká, 'lige aminami 'we 'yégiga ra'ichasa alué ralámuli 'emi 'yuga napurigá sairúgame neraga. ");
INSERT INTO tacNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","'We ra'sáligá mochíwaká napu'lige alarigá nokachi ralámuli, 'émika 'wéchigo 'la semátiri raweli narémili kame 'pa rewagachi. Alué chátiri ralámuli abiena cha olale alué 'ya ejperégame ralámuli napu ruyame nílige napu anele Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","› Jénaka bilé tétali ruyame ju. 'Émika pe napurigá oná ju. Napurigá 'we a'lá ajkágame newame ju go'ame, 'lige aminami napurigá tabilé bikamela sa'pá oná ajchésiga, 'émika gu'írame ju ralámuli napurigá tabilé aminabi resí nokísimala. Oná 'ma najsawísaká tabilé ra'ígame gainasa pecha sirbe nímalawé. Pecha uchéchigo ku 'la gainámalagó. 'Liko pe pálime nímala alué oná, 'lige ralámulika amoba e'yénamala re'keka. 'We a'lá na'tawa choniame ka ye tétali. ");
INSERT INTO tacNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","› Jena uchéchigo bilé tétali ruwime ju. 'Émika napurigá ra'ósali ju jena wijchimoba. Bilena we'ká riógachi wa'lú gawichí amoba, pecha gainámili júkó napurigá chíbamala, abirigá ma'chí iliméleke senibí. ");
INSERT INTO tacNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Abiena tabilé rajeme ju ralámuli lámpara, 'lige pachárale elamia napu bo'í bilé gajoni, iligá uché bilena elame ju napu abé 'la ma'chígime rajisáré, napurigá suwábaga ralámuli galírale mochígame 'la ma'chígichi mochímala. ");
INSERT INTO tacNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ye tétalika aniame ju 'we a'lá sébali olawa napu nulá Onorúgame, 'lige napu'lige etea ralámuli, 'we a'lá niraga etémala O'nó Onorúgame 'pa rewagachi ajtígame. ");
INSERT INTO tacNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","› 'Émika bijchigi ne alué Moisesi nulalila suwábimia nawigó, 'lige abiena bijchigi 'emi ne nawigó suwábimia alué 'ya nerúgame rejcholi, napu ruyame nile alué ralámuli napu Onorúgame anélige. Neka pecha se'wí pamia nawako alué nulalí nibilé alué ra'íchali rejcholi. Neka nawákuru ralámuli gu'írimia napurigá 'la námamala ralámuli alué nulalí. ");
INSERT INTO tacNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Neka 'la bijchiá aníguru, bijí 'la bo'ígichi ye gawí 'lige rewagátiri, tabilé 'wesi osilí bujéwili ju alué ra'íchali Onorúgame nila, napusí 'ma sébili ikí napu sébili ikimeli ju jena wijchimoba. ");
INSERT INTO tacNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Alekeri napu'lige bilé rió tabilé e'wasa napurigá aní alué nulalí, 'lige uché jaré ralámuli sulisa napurigá alué ralámuli tabilé e'wámala alué nulalí, 'liko alué rió ta'mé najtékame nímala napu'lige Onorúgame nulechi alué ralámuli. Bilé rió 'we a'lá e'wame nísaká napurigá aní alué nulalí, 'lige benírame nisa uché jaré ralámuli napurigá a'chigóriga nochámala, 'liko alué rió asíriga najtékame nímala napu'lige Onorúgame nulechi alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Neka anéguru 'emi: Alué bariseo 'lige alué Moisesi nila nulalila benírame, 'we ra'íchame ju Onorúgame nulalila tabiléchigo sébali olame júkó rekó lanime ke. 'Emi tabilé e'wásaká napu nulá Onorúgame me'tagá alué bariseo 'lige alué Moisesi nila nulalí benírame, Onorúgame tabilé nulémala 'emi. ");
INSERT INTO tacNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","› 'Emi 'we a'lá machí regá anélirigo alué 'ya mochígame: «Tase me'ligá ilírowa ralámuli. Apiépiri rió uché bilé rió me'lisá, alueka wa'lú gastigo rewimeli ju.» ");
INSERT INTO tacNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Neka regáchigo anígó: Apiépiri rió napu ayóniga eté uché jaré ralámuli, abiena wa'lú gastigo 'yáwili ju Onorúgamete rekó ta me'ae. 'Lige bilé ralámuli tabilé 'la ra'ichasa uché jaré ralámuli olagá, alueka gastigáriwili ju alué e'wélalate napu nuleme ju ralámuli jurío. 'Lige bilé rió anesa chebilé rió: «Mueka pecha najtékame júkó, mueka pe tonto ju», alué alanímeká gastigáriwili ju Onorúgamete na'ichí e'kósiga 'légana injiérnochi. ");
INSERT INTO tacNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","› Alekeri, go'ame o'ká simisá mué alé mésachi napu Onorúgame go'ame i'lime ju, 'lige alé sebasa nelasa mué, mué bo'né se'winá oláligo uché bilé rió, ");
INSERT INTO tacNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","'liko abalé a'rélime júkuru alué go'ame 'na o'weka neraga napu ilí alué mesa. 'Lige alé a'resa, ku 'mi simibóká gatewa alué rió 'yuga. Napu'lige 'ma 'la sébali gatesa, a'lige kuka simibóká, a'lige kulí jawáwaká alué go'ame alé mésachi. ");
INSERT INTO tacNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","› Mué se'winá 'sisa bilé rió 'yuga, 'lige alué rió wa'lúlachi nejímala mué, 'liko ta'chó seba 'we a'lá gatélime júkuru. Alué riote nejísiga mué alé wa'lúlachi, 'liko galírale bajcháwili ju mué. ");
INSERT INTO tacNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ne 'la aní mué tabilé ma'chínimio. Napu'lige 'ma suwábaga najtétasa mué napu ekí goblala alué wa'lula, a'lige kulí ma'chínamala mué. ");
INSERT INTO tacNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","› 'Émika 'we a'lá machí regá anélirigo alué 'ya mochígame: «Tase 'yuga gochiboa uché jaré umugí alué napu tabilé 'emi 'yula ju.» ");
INSERT INTO tacNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Neka regáchigo anígó: Bilé rió rekó tabilé gochié uché bilé mukí 'yuga, 'lige pe 'we 'yuga gochináliga etesa 'liko alué rioka 'ma resítiri alawégame nímili júkuru rekó ta 'yuga gochié. ");
INSERT INTO tacNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","› Chátiri na'tasa mué alieti etega, 'liko ma'chí pápua alué busí 'lige pápuaká. Abé 'la nímala pe busílacho we'kawa mué, tabilé 'la ju suwábaga mué sa'pala 'légana injiérnochi pasía. ");
INSERT INTO tacNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","'Lige alué mué sekala wajtoná ilígame 'sísaká napurigá nochawa alué resítiri nóchali, 'ma rejpúniga pápua. Abé 'la kéréko seká we'kawa mué, tabilé 'la ju suwábaga mué sa'pala 'légana injiérnochi pasía. ");
INSERT INTO tacNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","› Abiena anime nile 'ya mochígame: «Bilé rió mukí a'resa bo'né 'yula, 'liko bilé apeli i'lime júkuru anigá 'ma a'réguru mué mukí.» ");
INSERT INTO tacNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Neka uché bilé rejcholi ruwimela. Bilé rió bo'né upila a'resa, 'lige alué mukí uché bilé rió rewisá, 'liko alué mukí wa'lú resítiri alawégame nímala. Alué bajchá ajtígame rió chojkila nímala chonigá a'reme ju mukí. Alué nujubá ajtígame rioka abiena tabilé 'la nóchame kárélamala. Alué mukí tabilé alué rió nila ju. 'Lige alué mukí se'nú rió 'yuga gochime nisa ta'chó a'relía alué bajchabé riote, 'liko alué rioka tabilé resítiri alawégame gainámala rekó alué mukí a'rigé. ");
INSERT INTO tacNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","› Abiena 'we a'lá machí 'emi regá anélirigo alué 'ya mochígame: «Onorúgame e'negá ajtí 'la sébali olamio ne, alekeri 'la sébali olámala ne.» ");
INSERT INTO tacNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tase aniboa: «Onorúgame 'la e'negá ajtí alekeri 'la sébali olámala ne.» Pe 'la sébali olawa. 'Lige tase aniboa: «'La sébali olámala ne, 'la e'negá ajtigame rewagá.» Tase regá aniboa: «Alé rewagachi nulá ajtigame Onorúgame.» ");
INSERT INTO tacNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Tase aniboa: «Gawí 'la machí 'la sébali olamio ne.» Tase aniboa alieti, gawika kame napu teka ajtí Onorúgame. 'Lige tase alarigá aniboa: «Rusalénika 'we a'lá machí 'la sébali olámala ne.» Tase alarigá aniboa alué Rusalénika Onorúgame nila kame. ");
INSERT INTO tacNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tase aniboa: «Ne bo'né mo'ola 'la machiame 'we a'lá sébali olamio ne.» Tase alarigá aniboa mueka pecha gainámalagó newá rosákame o chókame mué bo'né gupala, nibilé bi'lepi gupá. ");
INSERT INTO tacNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Napu'lige 'la sébali olámorisá mué, 'la sébali olawa. Tabilé gainásaká sébali olá, pe aniboa: «Tabilé ikíromala ne.» Tabilé siné 'yégili rupoa. 'Yégiliká pe Remónisi ra'ichálila ju. ");
INSERT INTO tacNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","› Abiena 'we a'lá machí 'emi regá aníligo alué 'ya mochígame: «Bilé ralámuli busila ma'chí pasa uché bilé rió, 'liko a'chigóriga oliame júkuru alué ralámuli. Bilé ralámuli ramé o'linasa uché bilé rió, 'liko a'chigóriga o'linálime júkuru alué rió ramalá.» ");
INSERT INTO tacNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Neka regá aní: «Tase ayóniwa bilé rió 'we nejkome. Bilé rió nejchósaká bilena banichí, uchéchigo bilena gu'líwaká napurigá uché bilena banachí o'chómala. ");
INSERT INTO tacNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Bilé rió bujénasaká mué o'páchala, yati 'yáwaká, 'lige abiena 'yáwachigó alué we'lí o'pacha o'páchiga inálime. ");
INSERT INTO tacNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Sontalo rejósaká napurigá o'toboa bilé tábiri bilé mili metro mejká, mueka abéchigo noli oká mili metro o'tobóká. ");
INSERT INTO tacNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Apiépiri ralámuli táachi tábiri, yati 'yáwaká. Bilé ralámuli tanega tásaká bilé tábiri, yati tanéwaká.» ");
INSERT INTO tacNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","› Abiena 'we a'lá machí 'emi regá anélirigo alué 'ya mochígame: «'La galewa mué amígola, 'lige tase galewa mué saíla.» ");
INSERT INTO tacNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Neka regá aní: 'La 'we a'lá galewa mué saíla. 'La 'we a'lá gu'íriwa alué ralámuli, alué napu tabilé ganílime ju 'emi 'yuga. 'La tániwa Onorúgame napurigá Onorúgame 'la gu'írimala alué chátiri ra'íchame ralámuli, abiena alué napu cha nokame ralámuli ju 'emi 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Alarigá nokiáká 'emi, 'la alué O'nó Onorúgame 'kúchila nímala 'emi, alué Onorúgame napu 'pa rewagachi ajtí, alué nuleme ju rayénali napurigá 'we a'lá ma'chígime rainámala alué chátiri ralámuli mochígichi, 'lige 'we a'lá ralámuli mochígichi. Nuleme ju u'kí napurigá u'kumela alé napu mochí ralámuli napu 'la e'wime ju Onorúgame, 'lige abiena alé napu mochí ralámuli napu tabilé e'wime ju Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mué pe alué 'we a'lá nirame ralámuli 'we a'lá nirásaká, 'liko mueka tabilé 'la narémala Onorúgame nila tábiri alarigá 'síkariká. Alué napu goblálome ju enomí alarigá nokame júchigó. ");
INSERT INTO tacNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","'Emi pe a'boi amígola 'la repórisa, tachiri najtékame nímalawé. Alué ralámuli tabilé Onorúgame oyérame, alueka abiena alarigá nokame ju. 'Émika 'we a'lá semáriga nokimeli júkuru, tase napurigá alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","'We a'lá sébali 'nátame ralámuli niwa napurigá O'nó Onorúgame 'pa rewagachi ajtígame. ");
INSERT INTO tacNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","› Tase che nokigá nokiboa napurigá ralámuli etémala 'emi napu'lige Onorúgame nulá. Tase anigá e'yénawa: «Ramueka 'we a'lá Onorúgame oyérame niru.» Pe alieti 'nátaga nokisáká 'emi, 'liko 'emi O'nola 'pa rewagachi ajtígame tabilé 'yámala 'emi semati raweli. ");
INSERT INTO tacNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Napu'lige gu'írilia alué tabilé nígame ralámuli 'we resíriká ejperégame, tase we'ká ralámuli etériga gu'íriwa. Alarigá nokame ju ralámuli 'we riólame napu'lige bilé tábiri 'ya alué ralámuli tabilé nígame alé u'kuchí re'obachi «sinagoga» anilime mochígichi. Alué alarigá nokame ralámulika pe najkigá nokame ju napurigá 'we a'lá nerawa ralámulite. Peka 'la sébali olame ke a'bopi. ");
INSERT INTO tacNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Napu'lige ralámuli tabilé nígame gu'íria mué, napu'lige tabilé 'wesi riógachi a'lige gu'íriwaká. 'Lige aminami tabilé 'wesi ruyéwaká, nibilé mué amígola rekó 'we a'lá amigo ke. (Ralámuli israelita regá anime nile: «Tase a'rewa napurigá mué sekala o'iná ilígame etémala napu 'siá 'smi mué sekala wajtoná ilígame.») ");
INSERT INTO tacNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","'Liko mué asíriga 'la narémala O'nó Onorúgame nila semati raweli, alueka suwábaga eteme kame napu ekí tábiri nóchachi ramué. ");
INSERT INTO tacNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","› Napu'lige Onorúgame 'yuga ra'icha 'emi, tase o'weti jaga tániwa iwérali Onorúgame alé pachá u'kuchí re'obachi «sinagoga» anilime pe napurigá etewa suwábaga ralámulite. Alarigá nokame ju riólame ralámuli, peka 'la sébali olame ke a'bopi. 'Lige aminami alé bilena napu we'ká ralámuli mochí, alemi jaga tánime ju iwérali Onorúgame, pe napurigá etewa suwábaga ralámulite. 'We ganílime ju alieti nóchaga. pe u'kabi rawé 'we ganíliga mochímala, Onorúgameka tabilé 'yámili ju semati raweli alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Napu'lige mué Onorúgame 'yuga ra'ichánalasa, bi'neli simibóká pachami galírale 'lige 'yérawaká yochi, 'lige kulí ra'icháwaka mué O'nola Onorúgame 'yuga. Pecha etérame júkó Onorúgame kaka, alueka abiénachigo 'la etiágó iwérali tánachi mué, 'liko Onorúgameka asíriga 'la semati raweli nejímala. ");
INSERT INTO tacNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","› Napu'lige iwérali tania 'emi Onorúgame, tabilé we'sá simérawa bilé ra'íchali, 'lige aminami tabilé ra'ichawa alué tabilé námatame ra'íchali. Ralámuli tabilé machime Onorúgame pe alarigá nokame ju. Alueka abé 'la we'ká ra'ichálika 'we a'lá gepumia mayeme ju Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tase alarigá nokiboa napurigá nokame ju alué ralámuli. Alué 'emi O'nola Onorúgameka 'la machí aleké najkió bajchá ta'chó táachi 'emi. ");
INSERT INTO tacNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Alekeri napu'lige ra'ichalia Onorúgame 'yuga, regá anewa: Mué O'nó 'pa rewagachi ajtígame, ramueka najkiáke'é napurigá nerawa mué ralámulite, ");
INSERT INTO tacNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","najkiáke'é napurigá sebámala raweli napurigá suwábaga ralámuli nulémala mué. Abiena najkiáke'é napurigá nulámala mué jena wijchimoba napurigá nulame ju mué 'pa rewagachi. 'Lige abiena najkiáke'é napurigá 'la sébali ikimela napu mué najkí. ");
INSERT INTO tacNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Pe rekó 'yáwagó ramué go'ame napu senibí rawé nejime ju mué. ");
INSERT INTO tacNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ramueka 'ma e'karu ralámuli alué napu cha nokálige ramué 'yuga, alekeri ramueka tánili e'kali mué cha nokogá nokigáriká. ");
INSERT INTO tacNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Pe rekó anáchaga 'yáwagó a'walí ramué napurigá 'la umérowa Remónisi napu'lige alué Remónisi se'wí 'lúnilichi ramué. Tase a'rewa ramué napurigá na'tawa alué chátiri 'nátili. 'Lige Esusi anile: ");
INSERT INTO tacNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","―'Emi 'la e'kásaká uché jaré ralámuli napu'lige alué ralámuli e'káali tasa cha nokisá 'emi 'yuga, 'liko 'emi O'nola Onorúgame napu rewagachi ajtí 'la e'kámalachigó 'emi. ");
INSERT INTO tacNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","'Emi tabilé e'kásaká 'lige tabilé niraga etesa alué cha nokame ralámuli, 'liko 'emi O'nola Onorúgame tabilé e'kámala napu'lige 'emi cha nokisá. ");
INSERT INTO tacNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","› Napu'lige ayunalia 'emi, tabilé sewékame neraga e'yénawa. Alué 'we riólame ralámuli alarigá nokame ju peka 'la sébali olame ke, pecha sewékame kéréko, pe najkime ju napurigá niraga etewa ralámulite. Pe tabilé 'nátame ju Onorúgame 'yuga. Tabilé narémili ju napu Onorúgame nejímili ju. ");
INSERT INTO tacNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Napu'lige ayunalia 'emi bajchá bisigówaguru 'lige 'we a'lá techípuaka, ");
INSERT INTO tacNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","napurigá tabilé machimela ralámuli mué ayúnachi, pe mué O'nola Onorúgame 'la machimela, 'liko 'la 'we 'la semati raweli nejímala Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","› Tase niga mochiwa e'karúgame tábiri 'we najteme jena wijchimoba mochiga, jena wijchimóbaka 'we o'chérame ju nowí 'lige 'ma pe i'nime ju suwábaga tábiri gatériga mochígame. Suwábaga suwime ju. 'Lige chigórigame abiena mo'ime ju chigomia alué gatériga mochígame. ");
INSERT INTO tacNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Tase we'ká na'tawa ye tábiri, iligá abé a'lá ju Onorúgame 'yuga na'talia. Alarigáká 'we a'lá semáriga narémala 'emi semati raweli napu'lige seba 'pa rewagachi. Tase nerume ju 'pa rewagachi nowí, 'lige tabilé i'nime ju tábiri gatérigime, 'lige tabilé e'yéname ju chigórigame. ");
INSERT INTO tacNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Bilé rió we'ká tábiri nígame nisa 'we najteme, 'lige pe alekecho na'tasa, tabilé na'támala Onorúgame 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","› Mué 'la gu'írisaká uché jaré ralámuli napu 'yáliru mué Onorúgamete 'yale mué, 'la Onorúgame 'yuga 'nátaga gu'írisaká mué uché jaré, 'liko 'we a'lá 'nátame ju mué, 'liko 'we a'lá bi'wígame alawégame nímala mué. ");
INSERT INTO tacNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mué tabilé gu'írisaká ralámuli napu 'yáliru mué Onorúgame 'yale mué, tabilé 'la bi'wígame alawégame nímala mué. Chókame nímala mué alawala. ");
INSERT INTO tacNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","› Oká e'wélala 'yuga nóchame nísaká alué pioni, pe tabilé ganíliga eteme ju bilé alué wa'lula, 'lige uché bilé wa'lúlaka 'la ganíliga eteme ju. 'Lige alué pioni bilé wa'lula 'la niraga etémala, 'lige bilé tabilé niraga etémala. Yeka anime ju: Bilé rió tabilé gainámala Onorúgame 'yuga 'nata, pe we'ká enomí mékame na'tásaká. 'Lige alarigáká tabilé gainámala Onorúgame oyeria. ");
INSERT INTO tacNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","› Neka alekeri aníguru: Tase regá na'tawa: «Jipe rawé ¿tachiri go'póaché?, 'lige ¿tachiri bajíwaché?, peka i'tékuru ba'wí. 'Lige ¿tachiri o'pachátuwaché? Peka i'tékuru napurigá raliboa nuebo o'pacha.» ¿Tacha abé najteme júkó alawá me'tigá go'ame? 'Lige ¿tacha abé najteme júkó mué alawala me'tigá alué o'pacha? ");
INSERT INTO tacNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Onorúgameka abiena 'la nejímili júkuru go'ame 'lige o'páchatiri. 'We a'lá na'táwabala aka alué chulugí i'niga oyame: tabilé echame ke, tajsiné 'wime ka'e, 'lige tajsiné gateme ke go'ame rekóachi. Onorúgameka alué napu 'pa rewagachi ajtígame ju 'la 'yame ká'é go'ame. ¿Tacha abé najtékame ju 'emi me'tigá alué chulugí? ");
INSERT INTO tacNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Chieri 'la ochéramalawé uché pe'tá o'wétiri rekó 'we ochérinilie? Rekó uché rajpé ochérinilie 'emi, tase uché rajpé abé re'pá jágame gainámala 'emi. Onorúgame 'sime ju newá re'pá jágame 'lige re'lé jágame. ");
INSERT INTO tacNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","› ¿Tachiri sirbe nímalawé pe o'páchacho na'talia? 'We a'lá na'táwabala churigá o'chérame ka sewá jami nerúgame. Aka alué sewaka peka nóchame júkuru, nibilé o'páchati newame júkuru. ");
INSERT INTO tacNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Neka aníguru abéchigo 'la semátiri ko me'tigá alué wa'lula 'ya bejtégame. Alué napu 'we nígame nílige, alué suwábaga me'tigá 'we nígame ka Salomoni anilime nile. Asíriga we'ká e'karúgame nígame nile napurigá chiní 'lige o'páchatiri asíriga jino, abirigáchigo ta'mé semati nílekó abe tase napurigá alué sewá jami nerúgame. ");
INSERT INTO tacNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Onorúgameka nabí asíriga 'la semátiri sewame gajsalá echame ju jami, 'lige pe 'ma wakime ju alué gajsalá 'lige ralámulika 'ma e'kósime júkuru. 'Émika abé rajpé najtékame júkuru me'tigá alué gajsalá. 'Émika tabilé bijchigi Onorúgame nejkúrimio o'pacha nejía. ");
INSERT INTO tacNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","'Liko tabilé we'ká 'nata mochiwa: «¿Tachiri go'póbeché jipe? ¿Tachiri bajíwaché jipe? ¿Tachiri o'pachátawaché jipe?» ");
INSERT INTO tacNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Alarigá nokame ju ralámuli tabilé bijchígime Onorúgame nila ra'íchali. Alué ralámuli asíriga 'nátame ju ye tábiri. Alué 'emi O'nola Onorúgame alué 'pa rewagachi bejtégame, asíriga 'la machí tachiri tábiri resílá 'emi. ");
INSERT INTO tacNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Iligá bajchá Onorúgame 'yuga na'tálime júkuru najkigá napurigá Onorúgame nulámala. 'La newalime júkuru napu Onorúgame najkí. Alarigá olásaká 'emi Onorúgame 'la nejímala nejkúrali napurigá niga mochímala go'ame 'lige o'páchatiri. ");
INSERT INTO tacNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Alekeri tabilé na'támili ju: «Chukimeli ju ne be'lí.» Iligá napu 'nata ajtí mué jipe alué 'lina na'táwaguru. Asíriga we'ká nerúkuru napurigá gatewa jipe yati. Be'lika uché bilé rawé ju. ");
INSERT INTO tacNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","› Tase chojkila che'wawa uché jaré ralámuli. Mué chojkila neraga che'wásaká, 'liko Onorúgame chojkila neraga che'wámala mué. ");
INSERT INTO tacNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Onorúgameka a'chigóriga animela 'emi olagá napurigá aneme ju 'emi uché jaré ralámuli. 'Emi tabilé niraga etésaká, 'liko Onorúgamechigó tabilé niraga etémala 'emi. 'We a'lá tétaga nejísaká 'emi, 'la bochí ajchigá, 'liko 'we a'lá sébali tétiga narémala 'émichigó, 'la bochí ajchigá. ");
INSERT INTO tacNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","'Lige ta machisá mué bo'né wa'lú wejkolí ajchágame ko mué bo'né busílachi, 'liko ¿chonigá regá aneme ju mué uché jaré ralámuli: «Muérigo, aka ne ma'chí pátirigo alué u'tá wejkolí mué busílachi ajtígame.» 'La ma'chí pápua mué bo'né bajchá alué wa'lú wejkolí mué busílachi ajtígame, a'liko 'la ma'chí pámala mué alué u'tá wejkolí alué rió busílachi ajtígame. (Yeka aniame ju 'emi chojkila neraga che'wásaká uché jaré pe u'tá tábiriti kachi, tabilé 'nátaga mué bo'né abéchigo chojkila ke, tabilé 'la ju.) ");
INSERT INTO tacNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Mué 'we resítiri nocha asisá, ¿chonémala mué bilé amigo? ¿Regá anémala mué?: «Ne 'la nejkúrimala ma'chí paa alué resítiri napu mué nocha ajtí.» ");
INSERT INTO tacNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Iligá bajchá a'réwaguru alué chátiri 'nátili napu mué 'nata ajtí, 'liko 'la sébali 'nátame nímala mué Onorúgame 'yuga napurigá gu'írimala mué amígola. Mueka pecha gainámili júkó pe u'tá wejkolí ma'chí paa uché bilé ralámuli busílachi chujkúgame, mué bilé gutumoli elágame nísaká bo'né busílachi. ");
INSERT INTO tacNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","› Tase 'yáwaká go'ame o'kochí alué go'ame Onorúgame kógirime nísaká. 'Lige aminami tase 'lúpuaká alemi napu uchú gowí alué 'we najteme rejté. Mué alarigá olásaká, 'liko gowika pe re'keka e'yénamala, 'lige siné kachi ku gu'liga 'emi i'kímala alué gowí. (Ye tétali júkuru aniame: 'We a'lá na'táwará napu'lige Onorúgame nila ra'íchali ruyá alué tabilé Onorúgame oyérame ralámuli 'yuga. Jaré ralámuli tabilé galeme ju alué ra'íchali.) ");
INSERT INTO tacNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","› Abichilubi tániwa Onorúgame, 'liko Onorúgame nejímala 'nátili. Abichilubi 'yáawa 'emi 'lige 'la rewimela 'emi. Bayéwaká Onorúgame 'lige Onorúgame e'wame júkuru. ");
INSERT INTO tacNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Apiépiri ralámuli 'la támeká 'la i'lime júkuru. 'Lige alué 'la 'yáameká 'la rewame júkuru. Alué bayémeka 'la nejélime júkuru. ");
INSERT INTO tacNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","› 'Emi 'kúchila baní tasa, 'émika tabilé rejté 'yámili júkuru. ");
INSERT INTO tacNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","'Lige ro'chí tasa 'emi 'kúchila, tabilé sinowí 'yámili júkuru 'emi alué u'kuchítiri. ");
INSERT INTO tacNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","'Emi napu chátiri 'nátame ke abiénachigo 'la jebénigame júkó 'emi 'we a'lá go'ame kógiga 'emi a'boi 'kúchila. 'Liko abéchigo 'la a'ká nejímala mué O'nola Onorúgame 'pa rewagachi ajtígame alué napu tánime ju. ");
INSERT INTO tacNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","› 'Emi najkisáká napurigá 'we a'lá nejkúrimala apiépiri ralámuli, 'liko 'emi bajchá 'we a'lá niraga gu'írimili júkuru apiépiri ralámuli. Alarigá ju napurigá nulame ju alué ra'íchali nulalí napu Moisesi osale 'we 'ya 'lige napu osale alué ralámuli napu ruyame nílige napu Onorúgame anélige. ");
INSERT INTO tacNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","› 'We e'wérali olawa napurigá mo'iboa alé u'tá yógame galichi. Wa'lú yógame ju alé napu simárame ju ralámuli injiérnochi simamia 'lige we'lé bo'ígime ju bowé napu sébame alé injiérnochi, 'lige we'ká ralámuli alué bowé simíbame ju, cháchigo 'la we'lé bo'ígime kame alué bowé. ");
INSERT INTO tacNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","'Lige pe u'kabi ralámuli simíbame ju alé bowechi tabilé we'lé bo'ígime mo'imea alé u'tá yochi alé ejperélimia senibí Onorúgame 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","› 'We majawa alué 'yégame ralámuli napu ruwime korí napu ané Onorúgame napu 'we a'lá Onorúgame oyérame korime ju, peka Onorúgame oyérame ke. 'We a'lá a'ká ralámuli kárigá jsime ju, asíriga chátiri 'nátame kéréko sulachika. ");
INSERT INTO tacNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","'We a'lá nérékuru 'we a'lá 'nátame ko 'we a'lá nóchali nochasa. Tabilé 'la ralámuli nísaká, 'liko tabilé 'la nóchali newámala. Tabilé rakémala i'wilí ('uba) alé golalachi, 'lige aminami tabilé rakémala alué chuná alé bilena bitáyachi. ");
INSERT INTO tacNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Abiena alué 'we a'lá rojaka 'we a'ká rakeme ju, 'lige alué ta'mé 'la rojaka ta'mé 'la rakeme ju. ");
INSERT INTO tacNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","'Lacha chátiri rakémalawé alué 'la a'ká rojá tabilé nayume, 'lige 'lacha a'ká rakémalawé bilé rojá nayume. ");
INSERT INTO tacNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Suwábaga rojá tabilé 'la a'ká rakémeka 'ma pe me'teka 'lúpili ju alé na'ichí napurigá 'ma rajimela. ");
INSERT INTO tacNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","'Liko 'we a'lá machimela 'emi alué ralámuli pala 'la bijchiá 'la bijchígili rejcholi nejime ka. Pe e'néniga napu nokame ju 'la machiboa. ");
INSERT INTO tacNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","› Tabilé suwábaga ralámuli moinámala 'pa rewagachi napu Onorúgame nulame ju rekó Wa'lula aneme ke ne'chí. Pe alué ralámuli napu ekí 'la sébali olame ju napurigá najkí ne O'nola Onorúgame 'pa rewagachi ajtígame, pe alueka 'la sebámala. ");
INSERT INTO tacNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Napu'lige seba raweli napu Onorúgame gustisia olámala (napu Onorúgame animela chieri 'la sébali oláligo 'lige chieri tabile 'la sébali oláligo), we'ká ralámuli anémala ne'chí: «Mué Wa'lula nulame, mué a'walila gite ramueka 'we a'lá rejcholi 'yáruturu ralámuli, 'lige abiena buináruturu u'kuchípala remónisi napu ralámuli mochiga mochílige, 'lige abiena sa'wáruturu nayúkame.» ");
INSERT INTO tacNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Alarigá animela. 'Lige neka 'we a'lá ma'chígime ruyémala regá: «Neka pecha siné machime kétego 'emi. 'Émika tabilé a'lá nóchali nóchame júkuru. 'Mi simíbaga.» ");
INSERT INTO tacNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","› 'Lige a'pílipi rió neraga 'la gepúsaká ye ra'íchali, 'lige 'la e'wasa ye ra'íchali, 'liko alué rió napurigá 'we machime rió neraga nímala, napurigá alué rió galí newágame 'we re'lé joka elale galí. ");
INSERT INTO tacNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","'Lige wa'lú u'kusá 'lige 'ma bochile alé gomichi 'lige galírale sébale, 'lige aminami asíriga ekale, 'lige tabilé na'mínale alué galí, cha 'la newárigime níligame alué galí 'we re'lé joka. ");
INSERT INTO tacNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","A'pili ralámuli neraga 'we a'lá gepúsaká ye ra'íchali ne ra'ichálila, 'lige tabilé e'wasa alué ra'íchali, 'liko pe napurigá bilé rió tabilé 'nátame, pe alarigá nímala, pe napurigá bilé galí satebó galirárigime pe alarigá nímala. ");
INSERT INTO tacNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","'Lige wa'lú u'kusá 'lige aminami asíriga ekesá, 'lige 'ma bochile ba'wí alé gomichi, 'lige 'ma omarúgame na'mínale alué galí. ");
INSERT INTO tacNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Napu'lige Esusi 'ma suwénasa ye ra'íchali beniria, ralámulika 'we ra'sálále napurigá benírale ");
INSERT INTO tacNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","napugiti Esúsika 'we a'lá benigá benírale, bo'né 'we a'lá sébali machime nile, tabilé benile uché jaré benírame 'yuga, tase napurigá alué Moisesi nila nulalí benírame. ");
INSERT INTO tacNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","'Liko napu'lige Esusi 'pa rabókana re'kínasa asíriga we'ká ralámuli najátale. ");
INSERT INTO tacNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","'Liko bilé rió nayume sa'pachí amoba chojkóbisiga ilíbale 'na o'weka neraga napu enale alué Esusi. 'Lige anile: ―Muérigo Wa'lula, mué 'la 'yónalisiká ne'chí, ne'chí 'yówaká napurigá ne 'la lisensia nígame nímala napurigá bajkimela ne alé re'obachi pachá. ");
INSERT INTO tacNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","'Lige Esusi nochale bo'né sekálate alué rió, 'lige anile: ―'La nímala, 'ma 'la sa'wígame nímala mué. 'Lige yati neraga sa'wile alué rió. ");
INSERT INTO tacNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","'Lige anele Esusi alué rió: ―Tabilé 'wesi ruyéwaká ne mué sa'wáligo. Iligá simibóká balé ajtígichi napurigá etémala mué 'ma sa'wígame ko. 'Lige go'ame kógiwaká Onorúgame napurigá nulálige Moisesi. 'La suwábaga alarigá olásaká mué, 'liko uchéchigo siné 'we a'lá sébali niraga etewa mué ralámulite. ");
INSERT INTO tacNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Napu'lige Esusi Kapernaumi anilichi sébachi, bilé gapitani sontalo romano sébale Esusi ilígichi bilé nejkúrali tániniliga. 'Lige anile alué sontalo gapitani Esusi olagá: ");
INSERT INTO tacNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","―Mué Wa'lula, ne piónila sujírigame ju, tabilé gayena noká 'lige 'we resí nilia ajtí. ");
INSERT INTO tacNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","'Liko anele Esusi alué gapitani: ―Simé ne 'yomia. ");
INSERT INTO tacNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","'Lige anile alué gapitani: ―Neka tabilé najtékame rió ju napurigá mué bajkimela ne bejtélachi, neka pe apiépiri rió ju. Pe iligá aniboa: «Sa'wisá 'la nímala alué pioni», 'lige alué piónika 'ma sa'wimela, mueka cha wa'lú nígame kame a'walí napurigá alarigá nulámala. ");
INSERT INTO tacNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Neka 'la machí alarigá nulálime ko wa'lula níriga. Alué uché jaré wa'lula ne'chí nuleme ju, 'lige neka u'kuchípala sontalo nuleme ju. «Simawa», aneme ju ne jaré alué sontalo, 'lige yati simíbame ju. 'Lige «Jeka simí», aneme ju ne bilé, 'lige yati jeka simime ju. 'Lige bilé tábiri newánilime ju ne piónila, 'lige alué piónika yati e'wame ju. ");
INSERT INTO tacNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","'Lige napu'lige Esusi akisá, pe i'kilí ilíbale e'negá. 'Lige Esusi anele alué ralámuli Esusi najátame: ―'La bijchiá ye rioka 'la sébali bijchígame ju 'we a'lá sa'wame ko ne Onorúgame Alawala gite. Jena napu ejperé ralámuli israelita pecha 'wesi ralámuli i'tékó uché abé bijchígame napurigá ye rió. ");
INSERT INTO tacNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Neka aníguru napu'lige Onorúgame piesta newachi 'pa rewagachi Abraámi 'yuga 'lige Isaki 'yuga 'lige Akobo 'yuga, asíriga we'ká ralámuli napuímio bochígimi gawichí mochígame. ");
INSERT INTO tacNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","We'ká ralámuli israelita tabilé sebámala alé piéstachi rekó Onorúgameka 'we gu'írilige alué ralámuli, jaré pecha Onorúgame 'yuga 'nátame níligo tase napurigá ye rió. Alué ralámulika pe ma'chige mochímala tabilé mochímala alé pachá piesta nerúgichi. Pe ma'chige 'lúpili ju asíriga chonárale. 'Lige nalá mochímala alué ralámuli aminami chi'ná mochímala ramelá. ");
INSERT INTO tacNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","'Lige Esusi anele alué sontalo gapitani: ―Ku simigá galírale. A'chigóriga ikimela napurigá mué bijchígale. 'Liko pe aba'lige yati sa'wile alué pioni. ");
INSERT INTO tacNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Napu'lige Esusi sebasa Pegro galílachi, Esusi etele alué Pegro wasila 'we nayua bo'igó. Asíriga iná bo'ile alué Pegro wasila. ");
INSERT INTO tacNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","'Lige Esusi nochale Pegro wasila sekala, 'lige yati ajchábale inuí alué Pegro wasila. 'Liko asísale alué Pegro wasila, 'lige yati go'ame newale napurigá Esusi go'mela 'lige uché jaré ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Napu'lige rayénali bokuísa, a'páliru we'ká ralámuli u'kuchípala remónisi mochígame pachágana. 'Lige Esusi 'ma buyánale alué u'kuchípala remónisi pe nuligá. Abiena Esusi 'yole uché jaré nayúkame ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Alarigá 'sile napurigá 'la sébali ikimela napurigá anílige 'ya bejtégame rió Isaíasi anilime napu ruyame nílige napu Onorúgame anele. Regá anile: «Alué bo'né o'tole nawilí napu ramué nayume nírige.» ");
INSERT INTO tacNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","'Lige uché bilé rawé asíriga we'ká ralámuli napuíle. Napu'lige Esusi etesa, nulale napurigá listo ujchagá mochímala bilé barko simea na'lebo 'nálige. ");
INSERT INTO tacNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ta'chó simíbachi, bilé alué Moisesi nila nulalí benírame a'bé nawile Esusi, 'lige anile: ―Neka mué 'yuga inánili panápuri simichi mué. ");
INSERT INTO tacNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","'Liko Esusi anile: ―Geyóchika 'la nígame júkuru resó, 'lige chulugika 'la ra'sógame júkuru. Ne napu nawá 'pa rewagáchika napurigá rió neraga, neka tabilé asé galégame ju napurigá gojchimela. ");
INSERT INTO tacNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","'Liko uchéchigo bilé rió alué Esusi oyérame, anele: ―Mué Wa'lula, neka mué si simela, pe iligá elíwagó ne napurigá ne o'nola tómala, a'lige simé ne mué 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","'Liko Esusi anile: ―Alué ralámuli tabilé Onorúgame oyérame, alué nokimela alué mukúgame toa. Mueka ne'chí 'yuga simiboa. ");
INSERT INTO tacNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","'Liko Esusi bárkochi 'mole alué makué oká oyérame 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Napu'lige 'ma bárkochi e'yénigichi, asíriga a'wágame ekénale, 'lige ba'wí asíriga re'pá ilírale 'lige bárkochi bajkile ba'wí. 'Lige Esúsika gojchigá bo'ile. ");
INSERT INTO tacNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","'Liko alué ralámuli Esusi oyérame 'ma ajchale Esusi gojchigá bo'ígichi. 'Lige anele ajchigá: ―¡Muérigo Wa'lula, asá nejkuri, 'ma bokuíchi ye barko! ");
INSERT INTO tacNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","'Lige Esúsika anile: ―¿Chonigá aliena majáliché 'emi? 'Émika tabilé bijchígilia Onorúgame 'la nejkúrimio napurigá 'la tabilé bokuímala ye barko. 'Lige asísale Esusi, 'lige ená anele Esusi alué eká 'lige ba'wítiri. 'Lige 'ma gelale alué eká 'lige ba'wítiri. ");
INSERT INTO tacNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","'Lige alué oyérameka pe i'kilí jábele Esusi e'negá. 'Lige regá anile: ―¿Tachiri a'walí nígame júpeché alué rió 'siá? 'La e'wenti júkuru eká 'lige ba'wí. ");
INSERT INTO tacNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Napu'lige Esusi na'lebo 'nálige Garara anilichi sebasa, oká rió buyale gaposántichika. 'Lige a'bé nawíleru Esusi alué oká riote. 'Lige alué okáraga rió u'kuchípala remónisi mochígame nile, 'lige alué rió asíriga jobátigame nile, tabilé a'reme nile napurigá ralámuli simáramala alemi. ");
INSERT INTO tacNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","'Lige e'wele ra'íchale: ―Mué Onorúgame Inolá, ¿chonigá nawá mué jeka ramué mochígichi? ¿Ramué gastigárimia nawá mué? Ta'chó sébachi raweli gastigo narékime. ");
INSERT INTO tacNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","'Lige pe abé mejkabé we'ká gowí e'yénale go'gá. ");
INSERT INTO tacNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","'Lige alué u'kuchípala remónisi 'we tánele Esusi, regá anile: ―Mué buinásaká ramué jena ye riochi mochígichi, 'liko 'mi we'ká gowichi juláwagó ramué. ");
INSERT INTO tacNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","'Liko Esúsika anele: ―¡Yati simásigó! 'Lige buyásiga yati simíbale, 'liko pachágana gowichi mo'ile, 'liko suwábaga gowí iwégame juma mo'íbele 'légana rejchíkana. 'Ma rujsule wa'lú ba'wí ilígichi, alésíko 'ma suwile. ");
INSERT INTO tacNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","'Liko alué gowí neseme, 'ma júmasale majaga, asíriga iwégame júmasaga sébale we'ká riógichi. 'Lige ruwile alakíligo alué rió u'kuchípala remónisi mochígame. ");
INSERT INTO tacNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","'Liko suwábaga ralámuli napu ekí ejperégame nílige alé we'ká riógichi simíbale Esusi e'nemia. Napu'lige etesa, asíriga iwégame anele napurigá simela. ");
INSERT INTO tacNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","'Lige Esusi bárkochi 'mole, 'lige na'lebo 'nálige simile. 'Lige bo'né bejtélachi sébale Kapernaumi anilichi we'ká riógichi. ");
INSERT INTO tacNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","'Lige alé sebasa, bilé rió o'tóleru sujírigame tabilé gayéname eyena. Pe tabachi rekagá o'tóleru. Napu'lige Esusi etesa alué ralámuli 'la bijchígio Esusi 'la umabamio alué sujírigame sa'wá, 'liko Esusi anele alué nayume: ―'We iwera towí, alué chátiri mué na'tálila 'lige napu 'sile mué 'ma e'kárigime ju. ");
INSERT INTO tacNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","'Liko jaré alué Moisesi nila nulalí benírame ralámuli mochile alé, 'lige akele alanichi Esusi, 'lige anile a'bopi 'nátaga: «Pe Onorúgamecho ju napu e'kame ju chátiri 'nátili. Ye rioka bo'nepi mayé Onorúgame ko. 'La enárigarigá julke 'liko.» ");
INSERT INTO tacNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","'Lige Esusi 'we a'lá machile alieri 'nata mochigo alué benírame. 'Lige anele Esusi: ―¿Chonigá aliena chátiri 'nátili 'nata mochípeché 'emi? ");
INSERT INTO tacNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Churigá anilía 'nalina abé a'lá nítéko? ¿Pa'lá regá anilía: «Mué rió 'ma bujé ne mué alué chátiri 'nátili napurigá 'la moinámala mué rewagachi», regáchala aniá: «O'weti ilísiga yati einawa»? ");
INSERT INTO tacNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Jipe ne napu 'pa rewagáchika nawágame ju napurigá rió neraga, 'la machírimala ne 'emi ralámuli wa'lú a'walí nígame ko ne Onorúgame nila napurigá bujémala ne chátiri 'nátili jena wijchimoba nerúgame. 'Lige Esusi anele alué rió sujírigame: ―Yati ilísiwa. 'Lige yati ku galírale simiboa, 'ma pabega gemá. ");
INSERT INTO tacNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","'Lige 'ma sa'wígame ilísale alué rió, 'lige 'ma ku galírale simile. ");
INSERT INTO tacNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","'Lige ralámuli napu ekí alé mochílige e'negá asíriga ra'sálále. 'Lige anile alué ralámuli: ―Asíriga 'la ju Onorúgame, 'yale a'walí ye rió napurigá ralámuli sa'wámala. ");
INSERT INTO tacNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","'Lige Esusi 'we enale chebilénami simiá, 'lige alué Esusi bilé rió etele i'kilí ajtígame bilena u'tá galichi enomí goblalia, gobierno 'yuga nóchame. Mateo anilime nile alué rió enomí goblálome. 'Liko Esusi anele alué rió: ―Nabá ne 'yuga. 'Lige alué rioka o'weti ilísiga yati simile Esusi 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","'Lige abé alí, Esusi 'lige alué oyérame ralámuli 'yuga i'kilí mochile bilena galírale go'ame go'yá. 'Lige we'ká mochile alé Esusi si napuíka go'ame go'yá alué enomí goblálome 'lige uché jaré ralámuli napu tabilé oyérame nílige alué Moisesi nulalila. ");
INSERT INTO tacNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","'Lige alé sébale jaré bariseo, 'lige anele alué Esusi oyérame olagá: ―Alué 'emi benírame enomí goblálome 'yuga ajtíkuru go'yá, 'lige uché jaré cha nokame ralámulitiri 'yuga. ¿Chonigá alué 'yuga go'áaché? ");
INSERT INTO tacNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Napu'lige Esusi akisá alué ra'íchali, bilé tétali ruwile: ―Ralámuli 'we a'lá a'ká tabilé nayume, pecha najkime júkó bilé 'yome. Alué 'we nayume ralámulika, 'la najkime ju bilé 'yome. 'Lige uché rajpé ruwile: ");
INSERT INTO tacNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","―Yati simawa beniboa alué napu ne ruimeli ju: «Neka najkí napurigá ralámuli na'temaka járomala a'bopi. Yeka abéchigo najtékame júkó me'tigá go'ame kógilia Onorúgame.» Neka nawákuru ralámuli bayemia napu 'la machime ju cha nokame ko. Neka tabilé nawá ralámuli bayemia napu tabilé bijchígame ju cha nokame ko. ");
INSERT INTO tacNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","'Lige pe'tá i'libékorikáchi sébale Juani oyérame ralámuli, alué Juani napu ralámuli rewarame nílige. 'Lige anile alué ralámuli Esusi olagá: ―Ramué 'lige bariseo 'we ayúname niru. Aka mué oyérameka, ¿chonigá tabilé ayúnabeché? 'Lige Esúsika regá anele: ");
INSERT INTO tacNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","―Napu'lige bilé rió newímichi, alué gompaniérola napu nejkúrimili ju napu'lige newichi, asíriga ra'sáligá mochímala. Alekeri tabilé ayunámala. 'Lige bilé rawé sebámala napu'lige alué newímili rió o'toboa. A'lige kulí ayunámala alué rió newímili gompaniérola, cháchigo seweka mochímime kame. (Yeka ruwime ju bilé rawé smeo jaré rió Esusi o'tomea. A'lige kulí 'we seweka mochimio Esusi oyérame.) ");
INSERT INTO tacNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","'Lige aminami anele: ―Uché bilé tétali ruyémala ne 'emi. Napu'lige o'páchala 'la nisa kárélasa napurigá pachókawa, tase nuebo chinite pachókawa, pe abéchigo we'lé chi'wámala'é ichósiga cho'yoga. ");
INSERT INTO tacNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","'Lige aminami tabilé ro'áwaká ajkágame i'wilí ba'wila o'chérame chiliwílachi wi'chite newárigime. Napu'lige alué i'wilí ba'wila ronasá 'ma chi'wámala alué chiliwila. 'Lige 'ma go'límala alué i'wilí ba'wila. 'Lige aminami 'ma tabilé sirbe nímala alué chiliwila. Bijí pe kulí 'la ronoa ilígichi alué i'wilí ba'wila se'wí ro'ilime júkuru abé nuebo chiliwílachi, 'liko alarigá 'la tabilé 'wesi najsawímala. Yeka ruwime ju napurigá tabilé na'lowawa Esusi nila rejcholi 'lige uché bilé rejcholi 'yúriga. ");
INSERT INTO tacNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Napu'lige Esusi bijí ra'icha ilígichi, bilé rió sébale alemi u'tá re'obachi nulame «sinagoga» anilime, 'lige chojkóbisiga ilíbale alé a'bé napu ilile alué Esusi, 'lige alué rió anele alué Esusi: ―Ne malala pe i'pebi mukú, pe rekó anáchaga, simibóaká sekate nochamia napurigá ku ajánamala. ");
INSERT INTO tacNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","'Liko Esusi simile alué rió 'yuga, 'lige alué Esusi oyérame abiena simíbale. ");
INSERT INTO tacNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","'Ma boichimi 'yénigichi, bilé mukí a'bé nawiga chébale Esusi o'páchala. Alué mukí nayume nile asíriga we'lisi, rojpachí nayume nile, tabilé siné ajchábame nile elenia, 'ma makué oká bamí nile alué mukí nayua. ");
INSERT INTO tacNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","'Lige alué mukí 'nátale: «Pe chébamala ne alué Esusi o'páchala napurigá 'la sa'wimela ne.» ");
INSERT INTO tacNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","'Lige Esusi gu'liga e'nénale alué mukí, 'lige anele: ―'We iwera mué mukí. Mueka 'la bijchígalekurú ne 'la umabamio mué sa'wá, alekeri 'la sa'wíkurú mué jipe. Pe yati neraga sa'wile alué mukí. ");
INSERT INTO tacNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","'Lige napu'lige Esusi bajkisá alué wa'lula galílachi, «sinagoga» anilichi nulame, etele «flauta» bujchigá rabisime jágichi, 'lige aminami asíriga we'ká ralámuli e'wele nalame. ");
INSERT INTO tacNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","'Lige anele Esusi alué ralámuli: ―Buyásiga 'emi. Ye iweka pecha mukigá bo'iko, pe gojchigá bo'íkurú. 'Liko alué ralámuli achile alué Esusi lanichi, pe tabilé bijchígale, 'máchigo mukugá bo'íligame. ");
INSERT INTO tacNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Napu'lige ralámuli ma'chige buyasa Esusi pachá galírale bajkile napu bo'ile alué iwé mukúgame. 'Lige sekachí cha'pile Esusi alué iwé, 'lige yati asísale alué iwé. ");
INSERT INTO tacNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","'Liko suwábaga ralámuli ra'íchiga e'yénale alué alieti bochígimi riógachi napu echulú nílige alé ejiro. ");
INSERT INTO tacNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Napu'lige Esusi 'ma boichimi enágichi, oká rió tabilé ma'chílime guwánaka e'yénale e'wele ra'ichasia Esusi olagá: ―¡'La na'temápua ramué, mué Rabí rijimala! ");
INSERT INTO tacNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Napu'lige Esusi bilena galírale pachami bajkisá, alué oká rió abiena alé sébale. 'Lige rukele Esusi alué oká rió: ―¿'Émika 'la bijchígilia ne 'la umabamio 'emi sa'wá? ―Ramueka 'we a'lá bijchígilia ―anile alué oká rió. ");
INSERT INTO tacNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","'Liko alué Esusi nochale alé alué oká rió busílachi. 'Lige anele nochagá: ―'Emi 'la bijchígasaká ne 'la umabamio 'yoa, 'liko ku 'la gainámala e'nena 'emi. ");
INSERT INTO tacNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","'Liko yati ku 'la ma'chílale. 'Lige Esusi 'we anele alué oká rió: ―Tabilé 'wesi ralámuli ruyéwaká ye alieti. ");
INSERT INTO tacNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","'Lige alué oká rioka arigáchigo 'we ruwile a'kinana, asíriga we'ká ralámuli ruyele alé ichúrimi riógichi. ");
INSERT INTO tacNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Napu'lige pe kulí simíbachi alué oká napu tabilé ma'chílime nílige, jaré rió bilé rió a'pale tabilé gayéname ra'icha, pe u'kuchípala remónisi mochígame nile. ");
INSERT INTO tacNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Napu'lige Esusi 'ma buinasa alué u'kuchípala remónisi, 'liko 'ma gayénale ra'icha alué rió. 'Lige suwábaga ralámuli pe i'kilí jale e'negá, 'we ra'sáláme kéréle rekó pe i'kilí jage, 'lige anile: ―Tajsiné alarigá 'ínilituru jena Israeli. ");
INSERT INTO tacNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","'Lige alué bariseo tabilé ganíliga mochile alarigá ikisá. 'Lige anile alué bariseo: ―Pe alué wa'lula remónisi napu Satanasi anilime ju 'smi a'walí 'yaa napurigá ye rió 'la buinámala u'kuchípala remónisi. ");
INSERT INTO tacNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","'Liko Esusi bochígimi we'ká riógachi simírale benírisia, 'lige u'kuchí re'obachi alé «sinagoga» anilime simírale benírisia Onorúgame nila ra'íchali napurigá Onorúgame 'ma 'la semáriga nulamio suwábaga ralámuli alawálachi, 'lige abiena we'ká e'karúgame nawalí sa'wasia. ");
INSERT INTO tacNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Napu'lige we'ká ralámuli sebasa Esusi e'nemia, alué Esusi asíriga na'temaka etele alué ralámuli, tabilé a'walí nígame niraga etele alué ralámuli, pe napurigá bo'á tabilé bo'élime, alarigá etele. ");
INSERT INTO tacNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","'Lige Esusi anele alué bo'né gompaniérola: ―Asíriga we'lé ju ri'ligó echerúgime, 'lige alué 'wímeka asíriga u'kabi ju. ");
INSERT INTO tacNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Alekeri Onorúgame tániwaguru napurigá uché rajpé julámala 'wime napurigá gu'írimala alué uché jaré 'wime. ");
INSERT INTO tacNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","'Lige Esusi bayele alué makué oká rió bo'né 'yuga járome napurigá a'bé jámala alé Esusi ilígichi. 'Lige a'walí 'yale Esusi alué makué oká rió napurigá u'kuchípala remónisi buinámala, 'lige aminami napurigá we'ká e'karúgame nawalí sa'wámala. ");
INSERT INTO tacNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jena uchú alué makué oká rió rewalá Esusi 'yuga járome: alué Simoni napu oká rewégame nílige, Pegro anilime níligechigó alué Simoni, 'lige bilé Antresi anilime nílige napu Simoni bonila nílige, 'lige bilé Santiago anilime nílige alué napu Sebereo inolá nílige, 'lige bilé Juani anilime nílige napu Santiago bonila nílige, ");
INSERT INTO tacNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","'lige Belipe, 'lige Bartolomé, 'lige Romasi, 'lige Mateo alué napu enomí goblálome nílige, 'lige Santiago anilime nile bilé, alué napu Alipeo inolá nílige, 'lige Tareo anilime rewégame nile uché bilé, ");
INSERT INTO tacNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","'lige Simoni, alué napu geriyero nílige, 'lige Jurasi Iskariote napu Esusi saíla gu'írile Esusi cha'piachi. ");
INSERT INTO tacNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ye makué oká rió nulele Esusi regá anigá: ―Tase simáwaká alé tabilé jurío ralámuli ejperélachi. Aminami tabilé simawa alé we'ká riógichi Samaritano ralámuli ejperélachi. ");
INSERT INTO tacNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Iligá si'né simáwaká alué ralámuli israelita ejperélachi. Alué ralámulika napurigá bo'á e'wegágame, alarigá e'yéname ju. ");
INSERT INTO tacNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Napu'lige simalia, rejcholi nejíwaká alué napu regá anime ju: «Amulí seba raweli napurigá Onorúgame nulámala ralámuli alawálachi.» ");
INSERT INTO tacNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","'Lige asíriga 'yóowaká nayúkame ralámuli, 'lige aminami ku ajánawa alué ralámuli suwígame napurigá ku ajagá mochímala. 'Lige abiena sa'wawa alué nayume amoba sa'pachí napurigá 'la lisensia nígame nímala re'obachi simiba. 'Lige ralámuli u'kuchípala remónisi mochígame 'ma buináwaká alué u'kuchípala remónisi. Tabilé najtegachi narele 'emi alué a'walí napurigá ralámuli 'yómala, tase goblálowa 'emi alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","› Tabilé o'ká simawa enomí napu ju alué 'oro, plata, 'lige kobre. ");
INSERT INTO tacNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nibilé morali napurigá tábiriti ajchawa, nibilé rasígame o'páchiga simawa. Aminami nibilé rasígame akega simawa, nibilé bilé resola o'ká e'nawa, napugiti nóchaga e'yéname ka, ralámulika 'la gu'írimala 'lige kógimala go'ame. ");
INSERT INTO tacNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","› Panápuri we'ká riógichi sebásiga, bilé rió galila 'yáwaká 'we a'lá rió bejtélachi 'lige alé che'lebáwaká napusí simalia uchéchigo bilénami. ");
INSERT INTO tacNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Bilena galírale sebásiga, 'la repóriwa ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Alué ralámuli alé galírale mochígame 'we a'lá nísaká, 'liko Onorúgame 'we a'lá gu'írimala alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","'Emi tabilé lisensia 'yásiga napurigá alé che'lebámala, 'lige tabilé akinálisa 'emi ra'ichálila, 'liko 'ma yati simáwaká alé galírale mochiga. 'Lige alé we'ká riógichi 'ma simawa. 'Ma sawéwaká we'é bemolila ronochí chujkúgame. (Alueka pe ruyame neraga nímala ye alué ralámuli alé we'ká riógichi mochígame gastigo naremio.) ");
INSERT INTO tacNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Neka 'la bijchiá aníguru, napu'lige seba raweli napurigá Onorúgame gustisia olámala ralámuli 'yuga, alué gastígoká napu narémala alué we'ká riógichi mochígame, abéchigo enátiri nímala alué gastigo napu narémili ju alué cha nokame ralámuli napu Soroma ejperégame nile 'lige Gomora ejperégame. ");
INSERT INTO tacNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","› ¡Neka cha nokame ralámuli ejperélachi jula 'emi, alué ralámuli napurigá olí bo'á go'nálime! 'We a'lá 'nátiga mochiwa napu'lige alué ralámuli 'yuga mochíriga napurigá tabilé che ikiboa. ");
INSERT INTO tacNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","'We a'lá 'nátaga mochiwa, alué cha nokame ralámuli o'tomela 'emi alé we'ká riógichi napu e'wélala mochí. 'Lige wejpisómala gujsite alé u'kuchí re'obachi jáwoga «sinagoga» anilime. ");
INSERT INTO tacNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","'Lige aminami o'toboli ju 'emi alé napu mochí alué e'wélala selígame nulame, 'lige napu ajtí alué wa'lula rey napurigá alué nokimela gustisia olá 'emi 'yuga, 'la ne'chí oyérame kóriká, alekeri lolámala. 'Lige alarigá 'la ra'ichámala 'emi ne nila ra'íchali alué ralámuli e'wélala napu tabilé jurío ju. ");
INSERT INTO tacNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Napu'lige 'emi alé napu mochí e'wélala o'tosuga, tase we'ká na'táwaká: «¿Tachiri chonimé ne? ¿Churigá ruyémala ne?» Napu'lige seba, Onorúgame 'we nejkúrimala napurigá 'la semáriga ra'ichawa, ");
INSERT INTO tacNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","napugiti tabilé 'emi nímala napu na'támala alué ra'íchali napu ra'íchame ju 'emi, O'nó Onorúgame Alawala 'símala nejía alué 'nátili. ");
INSERT INTO tacNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","› Jaré pe rijimala ke ba'chila o bonila saíla gainámala. 'Lige alé e'wélala mochígichi nejímala napurigá alué e'wélala nokimela me'á. 'Lige bilé o'nó abiena 'ma nejímala bo'né inolá. Tabilé na'temámala rekó bo'né inolá kachi. 'Lige inolaka 'ma alué bo'né o'nola 'lige eyélatiri saíla gainámala, 'lige nejímala alé e'wélala mochígichi napurigá alué e'wélala nokimela me'á. ");
INSERT INTO tacNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ne'chí oyérame kóriká, suwábaga ralámulite cha anewa 'emi. 'Emi tabilé guwana rujsúsaká, abirigá jasa napusí suwí ne'chí oyériga, 'liko 'pa rewagachi o'tomé ne 'emi. ");
INSERT INTO tacNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Napu'lige cha nokisá bilena we'ká riógichi mochígame ralámuli, najátaga e'yénasa 'emi me'lináliga 'liko yati chebilena júmasawaguru. Neka 'la bijchiá aníguru, bajchabé nawamio alué napu nawale 'pa rewagáchika napurigá rió neraga 'emi ta'chó suwábichi ne nila ra'íchali beniria bochígimi we'ká riógachi jena Israeli anilichi. ");
INSERT INTO tacNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","› Tase majawa napu'lige cha anichi ralámuli. Ne abiénachigó cha anilime júchigó, 'lige ne'chí alarigá anésiga, alué ralámuli abiena cha animela 'emi olagá. Alarigá ju bilé benime 'yuga, napurigá alué benírame. Bilé nóchame ju napurigá wa'lula. 'Lige Belsebú anésiga ne'chí, napu aniame ju Wa'lula Suwábaga 'Yégili, alué ralámuli abiena alarigá anémala 'emi olagá. ");
INSERT INTO tacNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","› Tase majawa alué ralámuli. Rekó cha nokachi rukó tabilé ma'chígichi, Onorúgameka abiena 'la etea ajtí suwábaga 'lige abé a'kinana 'ma machiboli ju suwábaga napu alué ralámuli nokogá e'yena. ");
INSERT INTO tacNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","'Liko tase majáwaguru. Napu'lige ne ruwichi bilé ra'íchali rukó, 'émika rawé ruipóguru. Ne ruisáká i'kilí ra'íchaga 'emi najkálichi a'bé chujká napurigá tabilé akémala uché jaré, tase majáwaguru e'wele ra'íchaga ruigá rawé galimopa jaga napurigá we'ká ralámuli akimela. ");
INSERT INTO tacNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tase majawa alué ralámuli napu uché jaré ralámuli me'agá e'yéname ju, alué ralámulika rekó me'ame ke pecha umubámalagó 'emi alawala me'á. Majáwaguru Onorúgame 'nalina napu 'la alawala 'nalina me'ame ju napu 'ma 'légana injiérnochi pame ju 'ma me'lisá. ");
INSERT INTO tacNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","› ¿'Émika ralineme ju alué oká chulugí pe bilé pésochi? Tabilé 'me najteme ju alué chulugí, O'nó Onorúgame 'we a'lá machime ju napu'lige suwichi alué chulugí. 'Lige alué chulugí suwime ju napu lisensia 'yame ju Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Onorúgame asíriga 'la tétiga ajtí a'pílipi gujpá 'emi mo'ólachi jágame, 'lige asíriga repume ju aminami. ");
INSERT INTO tacNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","'Lige alarigá tabilé majawa, Onorúgameka asíriga 'la repúmili júkuru 'emi me'tigá alué chulugí, 'émika abéchigo 'la najtékame kame me'tigá alué we'ká chulugí. ");
INSERT INTO tacNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","› Alué rió tase chijúnaga ruisá alué uché jaré ralámuli ne'chí oyérame ko, 'lige néchigó abiena 'we a'lá ruyémala Onorúgame 'pa rewagachi ajtígame alué rió ne'chí oyérame ko. ");
INSERT INTO tacNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Jaré 'emi tabilé ne'chí oyérame korigá ruyésaká uché jaré ralámuli, 'liko neka tabilé machime korimela 'emi O'nó Onorúgame 'pa rewagachi ajtígame ruyea. ");
INSERT INTO tacNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","› ¿'Lacha mayé 'emi ralámuli ne nawáligo ra'mamia 'emi ralámuli jena wijchimoba nakoga ejperégame? Neka ruwí tase ra'mamia nawagó. Neka iligá nawákuru sairárimia. ");
INSERT INTO tacNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","'Lige bilé ralámuli bo'né o'nola sairámala. 'Lige bilé mukí bo'né eyela sairámala. 'Lige mo'lila bo'né wasila sairámala. ");
INSERT INTO tacNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Alué napu bi'lénapi galírale ejperégame ju a'bópika sairámala. Alarigá ikimela napu'lige ralámuli o'wina ne'chí oyeria. ");
INSERT INTO tacNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","› Bilé ralámuli 'we galeme nisa bo'né o'nola 'lige bo'né eyela me'tigá ne'chí, 'liko alué ralámulika tabilé ne'chí oyérame nímala. Bilé ralámuli 'we galeme nisa bo'né inolá 'lige bo'né malala me'tigá ne'chí, 'liko alué ralámuli tabilé ne'chí oyérame nímala. ");
INSERT INTO tacNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Bilé ralámuli tabilé e'wame napu nulá Onorúgame 'lige tabilé resí ikinálime, alueka tabilé ne'chí oyérame nímala rekó ne'chí 'yuga eyéname ke. ");
INSERT INTO tacNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Alué ralámuli majame ka ne'chí oyériga, alueka tase rewimela semati raweli. Bilé ralámuli tabilé majáme ka mukigá ne'chí oyériga, alueka 'we semáriga na'támala Onorúgame 'yuga. Tabilé chéré rekó mukugé, alué ralámuli abiena 'la Onorúgame 'yuga asimela. ");
INSERT INTO tacNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","› Jaré ralámuli 'la nirásaká 'emi, pe a'chigóriga ju napurigá ne'chí niralia. Jaré ralámuli 'la nirásaká ne'chí, pe a'chigóriga ju napurigá Onorúgame niralia, alué napu 'sile ne'chí jula. ");
INSERT INTO tacNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Bilé rió 'la nirasa apiépiri alué napu ruyame ju napu Onorúgame anele, 'liko alué rió asíriga 'la semati raweli narémala, a'chigóriga napurigá nareme ju alué rió napu ruyame ju napu Onorúgame anele. Bilé rió 'la nirásaká uché bilé 'we a'lá rió napu 'we a'lá sébali olame ju napu Onorúgame najkí, 'liko alué rió asíriga 'la semati raweli narémala napurigá nareme ju alué rió napu 'we a'lá sébali olame ju napu najkí Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Apiépiri ralámuli 'la 'yásaká pe bilé baso ba'wí ne 'yuga járome napurigá bajímala, 'we a'lá semati raweli narémala. Alueka 'we a'lá bijchiá ju. ");
INSERT INTO tacNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Napu'lige alué Esusi 'we a'lá ruyesa alué makué oká rió Esusi 'yuga járome, alésíko alué Esusi 'ma simile we'kanami pueblo ralámuli benírisia rejcholi Onorúgame nila. ");
INSERT INTO tacNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","'Lige Juani galírale bajcháriga asigá akele Esusi 'we a'lá benirio ralámuli Onorúgame ra'ichálila 'lige 'we a'lá sa'wao nayúkame, alué Juani regá 'nátele: «Pe ye Esusi kéréko Onorúgamete julárigame napurigá gu'írimala ramué, siné kachi pe alué kéréko Kristo anilime.» Alarigá 'nátele alué Juani. 'Liko júlale jaré rió alué Juani napu aba alué Juani gompaniérola nile ");
INSERT INTO tacNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","napurigá regá rukémala: ―¿Mué ju napu nawámili nílige ramué gu'írimia, o chebiléchala ju? ");
INSERT INTO tacNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","'Lige Esusi nejele: ―Simasi Juani ruyewa churigá ka ra'íchali napu 'emi akele jena jipe, 'lige abiena ruyéwaká napu 'emi etewá jipe. ");
INSERT INTO tacNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ruyéwaká alué tabilé ma'chílime 'ma ku ma'chilio, 'lige sujírigame ralámuli 'ma ku 'la gayenio e'yenia, 'lige alué ralámuli amoba sa'pachí nayume 'ma ku sa'wíligo 'lige 'ma lisensia nígame ko napurigá simámala re'obachi, 'lige alué najkacholo ralámuli 'ma ku akeo, 'lige suwígame 'ma ku ajanio, 'lige tabilé nígame 'ma akea mochigo alué 'we a'lala ra'íchali Onorúgame nila ra'íchali. ");
INSERT INTO tacNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","'We ganíliga eté Onorúgame alué ralámuli napu tabilé guwana rujsú. ");
INSERT INTO tacNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Napu'lige alué rió Juani gompaniérola simasa, Esusi chojkile ruyea ralámuli alarigáriga níligo Juani. Regá anile: ―Napu'lige 'emi 'mi alé simíbalige alé napu tabilé 'me u'kume ju, alé napu Juani asálige nawésali ruyea ralámuli 'yuga, ¿tachiri e'nemia simárupeché? ¿Pe bilé rió napuyépiri rejcholi oyérame? ");
INSERT INTO tacNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Tachiri e'nemia simárukó 'liko? ¿Simáruchalá e'nemia bilé rió 'we a'lá semátiri o'páchigime? 'Emi 'la machilke alué 'we a'lá a'ká o'páchigime ralámulika alué e'wélala galílachi mochime ko. ");
INSERT INTO tacNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿'Liko tachiri e'nemia simárupeché? ¿Bilé rió napu ruyame ju napu anele Onorúgame, alué e'nemia simaru? Ju, alué e'nemia simíbale 'emi. Aminami alueka 'we najtékame nóchali nígame júpá, me'tigá alué uché jaré ralámuli napu ruyame nílige napu anélige Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Pe alué Juani olagá aní alué osilí 'we 'ya nerúgame napu regá aní: Neka julámala bilé rió napurigá ralámuli ruyémala mué sebámili ko jena wijchimoba. 'Lige alué 'símala gatea bowé napurigá mué sebámala alé. Alué Onorúgamete julárigame ka pe Juani ju. ");
INSERT INTO tacNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Neka 'la bijchía aníguru: Alué Juani napu ralámuli rewarame nílige, alué ju suwábaga ralámuli me'tigá najtékame napu ekí mochí jena wijchimoba. Neka abiena ruwí bilé rió tase najtékame ko, napu'lige a'resa napurigá Onorúgame nulémala, 'liko 'we a'lá najtékame nimio Onorúgame níriga me'tigá Juani nochálila. ");
INSERT INTO tacNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","› Napusí Juani we'ká ralámuli benírasa, we'ká ralámuli cha nokame sairuga mochí napu nulá Onorúgame. 'Lige 'ma na'minánili alué nulalí (Alué ralámuli ju napurigá bo'á go'lechi uchúkame. Napu'lige nawame ju bo'elo i'pumia, júmaka buyame ju.) ");
INSERT INTO tacNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Suwábaga ralámuli 'we 'ya mochígame napu ruyame nile napu anile Onorúgame, 'lige abiena alué Moisesi nila ra'íchali, ruwile churigá nímili níliga alué Juani ralámuli rewarame ba'wichí jáwaga. ");
INSERT INTO tacNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Alué ralámuli anime ke uché bilé napurigá Elíasi nawamio. Neka aníguru alué Juani ko alué Elíasi ju napu nawámili níligo. ");
INSERT INTO tacNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","'La najkégame níriká napurigá akiboa, asíriga 'la gepúlime júkuru. ");
INSERT INTO tacNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","› ¿'La chieti alué ralámuli jipe mochígame? Pe alué okaná chojkégame kuchí 'kuchi kárékuru napu mochime ju alé we'ká riógachi nasípami re'ea, napu re'énilime ju uché jaré 'yuga, napu regá aneme ju alué uché bilena chojkégame kuchítiri napu re'eme ju: ");
INSERT INTO tacNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","«Bucheru alué baká napurigá 'emi yawimela, tabiléchigo yawíkó 'emi. 'Lige 'we sewékame wiká wikaráruturu, 'lige 'emi tabilé nalákuru.» ");
INSERT INTO tacNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","'Lige nawákuru Juani alué napu tabilé we'ká tábiri go'yame nílige, tase napurigá uché jaré ralámuli, 'lige aminami tabilé bajime nílige alué i'wilí ba'wila rekútame 'lige regá aneme júkuru alué ralámuli jipe mochígame: «Alueka pe u'kuchípala remónisi ajchágame ju.» ");
INSERT INTO tacNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","'Lige nawákuru alué Onorúgamete julárigame 'pa rewagáchika, 'lige suwábaga go'ame go'yame júkuru napu ekí go'yame ju ralámuli jena wijchimoba mochígame, 'lige abiena bajime júkuru alué i'wilí ba'wila rekútame. 'Lige regá anéguru ralámuli: «Alueka 'ma rasíriga go'yame júkuru, 'lige aminami asíriga bajime júkuru, 'lige aminami 'we a'lá amigo ju ralámuli 'yuga enomí goblálome 'lige chejaré ralámulitiri alué 'we resítiri sulégame.» 'Wéchigo 'la ma'chígime néréko 'we a'lá benégame ko Onorúgame, 'we a'lá ma'chígime nérékuru 'ma 'la we'ká ralámuli sa'wáligo. Suwábaga a'lá sébali olame nile. ");
INSERT INTO tacNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","'Liko Esusi chojkile ená anea alué cha nokame ralámuli alé we'ká riógachi alé napu 'yólige we'ká nayúkame alué Esusi. Ená anele pecha a'réligame alué chátiri nóchali. Regá anele: ");
INSERT INTO tacNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Resía 'emi ralámuli Korasini anilichi ejperégame! ¡Resía 'emi ralámuli Betsáira anilichi ejperégame! Neka 'we a'lá sa'wigéturu alé ejperégame ralámuli Onorúgame a'walílate napu tabilé 'wesi ralámuli gayéname ju alarigá sa'wá, 'lige 'emi abirigá tabilé a'réturu alué resítiri nóchali. Ralámuli 'ya ejperégame alé Tiro anilichi ejperégame 'lige Sironi anilichi ejperégame abiena asíriga 'we cha nokame ralámuli kéturu. Ne 'we a'lá sa'wasa alué ralámuli alé, 'lige o'pachátimituru alué o'pacha 'we chajótigame, 'lige mochíbimituru bilena najpisochi napurigá machimela ralámuli 'ma a'réligo alué chátiri 'nátili. ");
INSERT INTO tacNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Napu'lige seba raweli gastigo narémichi 'emi ralámuli Korasini ejperégame 'lige Betsáira ejperégame, a'lige rawé 'emi ralámuli uché rajpé a'wágame gastigo narémala me'tigá alué ralámuli cha nokame alé Tiro ejperégame 'lige Sironi ejperégame. ");
INSERT INTO tacNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","'Emi ralámuli Kapernaumi anilichi we'ká riógichi ejperégame, ¿'émika 'la bijchiá bijchigi 'pa rewagachi moinamio 'emi? Onorúgameka tabilé alarigá 'nata. 'Émika wamí 'légana injiérnochi simámili júkuru. Neka alé we'ká riógichi 'emi ejperélachi asíriga 'la sa'wigéturu ne nayúkame, 'émika tabiléchigo a'rélekó alué chátiri 'nátili. Alué chátiri ralámuli 'ya ejperégame Soroma anilichi we'ká riógichi, etésaká aliena 'la umébigo ne sa'wá ralámuli, 'ma a'rémitibá alué chátiri 'nátili, 'lige bijí 'la we'ká riólimiturubá alé we'ká riógichi Soroma anilichi. ");
INSERT INTO tacNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Neka anéguru 'emi ralámuli Kapernaumi anilichi we'ká riógichi ejperégame, napu'lige raweli sebasa napurigá Onorúgame wanápamia chátiri 'nátame ralámuli (gustisia olámala), uché rajpé a'wágame gastigo narémala me'tigá alué ralámuli napu Soroma anilichi ejperégame nílige. ");
INSERT INTO tacNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","'Liko regá anile Esusi: ―Mué O'nó Onorúgame, mueka asíriga wa'lú júkuru 'lige mueka rewagachi nulame júkuru, 'lige aminami jena wijchimoba. Neka 'we a'lá ra'íchame ju mué olagá, mueka tabilé lisensia 'yale alué ralámuli riólame napurigá námamala alarigá ko mué, alué ralámuli napu 'nátame ju a'bopi 'we a'lá ejpénigime ko. Mueka 'wéchigo a'lá gu'írame júkó alué ralámuli tabilé riólame napurigá námamala churigá ko mué. Ralámuli alué tabilé riólame ka, alueka 'we listo ju, alueka 'la 'we a'lá námaka akeme ju. ");
INSERT INTO tacNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Mué O'nó Onorúgame, alarigá ju. Alarigá newigá ganílame ju mué. ");
INSERT INTO tacNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","'Lige Esusi anile: ―Ne O'nola suwábaga 'yáturu ne'chí nóchali, 'nátili 'lige a'walí. Tase 'wesi machí churigá ko Onorúgame Inolá, pe O'nó Onorúgame 'la machí. 'Lige tabilé 'wesi machí churigá ko Onorúgame, pe alué Onorúgame Inolá 'la machime ju churigá ko O'nó Onorúgame. Ne, Onorúgame Inolá, 'we gu'írame ju ne uché jaré ralámuli napu ne najkí napurigá alué uché jaré ralámuli 'la námamala churigá ko Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Suwábaga 'emi napu ekí 'we resibaka mochí we'ká 'nátaga, jeka simasi, ne 'la nejkúramala napurigá 'emi 'la resíbamala. ");
INSERT INTO tacNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","'La eliwa ne napurigá ne 'símala benira, 'liko napurigá oká oisí bulurúgame nímala ramué araro banasuka e'yénigime, siné kachi 'la benimela nóchali ne benírichi. Neka 'we i'kilí ju. 'Lige aminami tabilé riólame ju ne. Ne'chí 'yuga beniáká 'la tabilé we'ká 'nátame niwa, neka alé asimémpá 'emi gu'íria. 'Lige aminami asíriga 'la resíbapua. ");
INSERT INTO tacNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ralámuli ne'chí 'yuga nóchameka asíriga 'la ganíliga mochímala. Tabilé bejtégame ju ne'chí 'yuga nochalia. ");
INSERT INTO tacNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","A'kinana bilé rawé resíbalichi ri'ligó echégachimi eyénale Esusi alué bo'né 'yuga járome 'yuga. 'Lige alué bo'né 'yuga járome e'luíle 'lige rejpúnele ri'ligó mulalá 'lige go'ale rakala mojsika. ");
INSERT INTO tacNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Napu'lige bariseo etesa alieti, anele Esusi: ―'We a'lá e'né alué mué 'yuga járome. Jipe rawé resíbilichi júkuru tabilé nochálichi ju, pecha rijpunálime júkó ri'ligó. ");
INSERT INTO tacNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","'Lige Esusi anele alué bariseo: ―¿Tacha leérame ju 'emi osilichi napu ruyame ju churigá 'síligo alué 'ya bejtégame rió Rabí anilime napu'lige Rabí e'luísa 'lige aminami alué ralámuli Rabí 'yuga e'yéname nílige? ");
INSERT INTO tacNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Alueka alé Onorúgame galílachi bajkile 'lige baní o'tole Onorúgame kógilime alé pachá Onorúgame galílachi mochígame. Alué Rabika 'lige alué ralámuli Rabí 'yuga e'yéname go'ale alué baní, tabilé lisensia nígame nile napurigá go'mela alué baní, pe baleka 'la lisensia nígame nile. ");
INSERT INTO tacNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Tabilé siné leérame ju 'emi alué apeli napu chujkú Moisesi osilila, balé tabilé resíbame ko bilé rawé resíbilichi? Abirigá pecha resítiri júkó rekó alué balé noche bilé rawé resíbilichi. ");
INSERT INTO tacNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Neka aníguru, napu ne nulá abé najtékame ju me'tigá alué Moisesi nila nulalí. ");
INSERT INTO tacNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","'Émika pecha 'la námaka leérame júkó alué Onorúgame nila ra'íchali. Regá aní Onorúgame nila ra'íchali: «Neka najkí napurigá 'emi 'we na'temaka etémala uché jaré ralámuli, tase pe ajágame me'liame najkí ne ne'chí kógilime.» 'Emi 'we a'lá námasaká 'liko pecha chojkila neraga che'wámiko alué ralámuli tabilé resí nokágame, ");
INSERT INTO tacNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","napugiti ne kame Onorúgamete julárigame 'pa rewagáchika napurigá rió neraga wa'lula kame ne resíbalichi rawé. ");
INSERT INTO tacNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","'Lige Esusi uchéchigo bilena simile, simile bilé u'tá re'obá ilígichi «sinagoga» anilime. ");
INSERT INTO tacNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","'Lige alé asale bilé rió bilena sekala sujírigame sekégame, 'lige alemi jale jaré bariseo 'lige rukele pe machináliga choniá anirá alué Esusi, nejiwa olale se'wináriga anisáká. Regá rukele: ―¿'La ju napurigá bilé rawé resíbilichi 'yowa nayúkame? ");
INSERT INTO tacNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","'Lige Esúsika nejele: ―Bilé rawé bilé bo'á wijchisá 'emi bujkula bilena rejkolíchimi bilé rawé resíbilichi, ¿'Lacha ta ma'chí pámala 'we 'emi na'temaka? ");
INSERT INTO tacNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Tacha abé najtékame júkó bilé ralámuli me'tigá bilé bo'á? Bilé ralámulika uché rajpé najtékame júkuru me'tigá bilé bo'á. 'Liko abiena 'la ikiáréleke napurigá 'yowa ralámuli nayume bilé rawé resíbilichi. ");
INSERT INTO tacNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","'Liko Esusi anele alué nayume: ―'Ma ku wajchinábá seká. Napu'lige wajchinasa 'ma ku sa'wile. ");
INSERT INTO tacNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","'Liko bariseo ma'chige simíbale 'lige chojkile ra'icha a'boi churigá 'la nítiká me'liá Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Napu'lige Esusi machisá me'libólikó bariséote, 'liko Esusi yati simile. 'Lige simisá asíriga we'ká ralámuli najátele guwana. 'Lige Esusi 'we 'yole ralámuli nayume napu alemi e'yénale alemi guwánami, ");
INSERT INTO tacNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","'lige 'we anile ralámuli napurigá ralámuli tabilé ruwimela chieri ko bo'né, ");
INSERT INTO tacNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","napurigá 'la sébali ikimela napurigá ruyélege Onorúgame alué abé 'ya bejtégame rió Isaíasi anilime napu ruyame nile napu Onorúgame anélige ta'chó ochérachi Esusi. Anile: ");
INSERT INTO tacNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","'We a'lá e'nésibá. Ye júkuru ne 'yuga nóchame. Yeka ne cha'píturu ne bo'né. Neka 'we galé ye rió, asíriga ganíliga ajtí ne ye rió 'yuga. Neka ne alawala 'yama oláguru. 'Lige alué 'símala suwábaga chojkégame ralámuli ruyea alué napu ne najkí. ");
INSERT INTO tacNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Alueka tabilé resí animela, nibilé e'wele ra'ichámala, nibilé sinámala alemi napu we'ká riógachi ju. ");
INSERT INTO tacNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Alueka 'we a'lá niraga etémala alué ralámuli tabilé nígame napu tabilé gayéname ju bo'nepi nemía. Alueka abisibi 'we nulámala napusí 'ma a'lá sébali olá ralámuli napu nulá Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Suwábaga chojkégame ralámuli jena wijchimoba mochígame 'we a'lá bijchígimala 'we a'lá gu'írimia alué. ");
INSERT INTO tacNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","'Liko Esusi bilé rió tabilé machílime o'tóleru, 'lige aminami tabilé gayéname nile alué rió ra'icha, u'kuchípala remónisi ajchágame rió nile. 'Lige Esusi 'ma 'yóole, 'liko 'ma ma'chílile, 'lige aminami 'ma gayénale ra'icha. ");
INSERT INTO tacNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","'Lige alué ralámuli napu najátale Esusi rukele a'bopi napurigá majáganti neraga: ―¿Ye jule Esusi Rabí rijimala, alué napu ramué gu'írimili ju? Tabilé machirúbá. ");
INSERT INTO tacNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","'Lige alué bariseo akisá alanichi alué ralámuli, 'lige anile: ―Napu'lige buyana u'kuchípala remónisi ye rió, pe alué u'kuchípala remónisi o'nola nejílala a'walite buyáname ju, alué u'kuchípala remónisi o'nola napu Belsebú anilime ju 'lige aminami Satanasi anilime ju. ");
INSERT INTO tacNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Esusi 'we a'lá machile alieti 'nata mochigo alué bariseo, alekeri anele: ―Bilena ejiro pe a'bopi na'áwasa ralámuli, 'liko tabilé sirbe nímala alué ejiro. Abiena a'chigóriga ju ralámuli we'ká riógichi mochígame, abiena alarigá 'ínili ralámuli bilena galírale rijimá we'kaka napuíka riógame nisa 'lige pe na'áwame nisa a'boi, tabilé gayéname ju bilé tábiri nóchali newá. ");
INSERT INTO tacNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","'Lige alué Satanasi ma'chí pasa alué u'tabela remónisi, ¿'lacha a'wálimalawé alué Satanasi alarigá 'sísaká? Tabilé gainámala bo'né nila nóchali newá. ");
INSERT INTO tacNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","'Lige ne ma'chí pame nísaká alué u'kuchípala remónisi Belsebú a'walílate, ¿chieri 'yame júkó a'walí alué 'emi gompaniérola napu'lige buyáname ju alué u'kuchípala remónisi? Remónisi nejime júlé. 'Émika tabilé remónisi 'sime kóríguru. 'Liko tabilé machigá aní 'emi ne'chí chojkila neraga che'wáa. ");
INSERT INTO tacNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Neka Onorúgame Alawala a'walílate buyáname júkuru u'kuchípala remónisi. Yeka pe aniame ju Onorúgame 'ma nulá ajtigó jena. ");
INSERT INTO tacNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","› Bilé rió tabilé gainámala chigoa bilé rió a'wágame galílachi, alué rió a'wágame tabilé buluruga asisáká. Napu'lige alué rió buluruga ajtígichi, a'liko 'la gainámala tábiri chigoa. ");
INSERT INTO tacNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","› Tabilé ne'chí oyérame ka pe ne saíla ju. Tabilé nejkura mochime ka alué oyérame ralámuli bailichi, alueka mejká jula mochime ju alé napu ne ajtí, napurigá olí bo'á majárime ju. Alarigá ju alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","› Abiena ruimé ne bilé ra'íchali: Onorúgameka 'la e'kame júkuru suwábaga alué chátiri ra'íchali napu ra'íchame ju ralámuli, nobi tabiléchigo e'kame júkó alué ralámuli napu 'we resí anegá ra'íchame ju Onorúgame Alawala olagá. ");
INSERT INTO tacNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Jaré ralámuli 'we gawéliga ra'ichasa Onorúgamete julárigame 'pa rewagáchika olagá, Onorúgameka abiena 'la e'kámala alué ralámuli. Onorúgame Alawala gawéliga ra'ichásaká, 'liko Onorúgameka tabilé siné e'kámala. Tabilé siné e'kámala jipe jena wijchimoba nibilé abé i'libeko napu'lige mukusuga. ");
INSERT INTO tacNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","› 'We a'lá repúpua bilé rojá 'liko 'la a'ká rakémala. Bilé rojá tabilé a'lá repútigame, alueka tabilé a'ká rakémala. Rakala e'néniga machiame júturu pala 'la ka alué rojá o tabilé 'la ko ma. ");
INSERT INTO tacNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡'Émika pe napurigá sinowí 'kúchila júkuru! 'Émika asíriga cha nokame ralámuli júkuru, 'lige ¿'lacha a'ká ra'íchali ra'ichámiliwé 'emi, pe cha nokame ralámuli ke? ");
INSERT INTO tacNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Bilé rió 'we a'lá 'nátame ka 'we a'lá ra'íchame júkuru, alué rioka 'wéchigo a'lá 'nátame nímime. Bilé rió tabilé a'lá 'nátame ka, alué rioka tabilé a'lá tábiri ra'íchame júkuru, alueka pecha a'lá 'nátili 'nátame nímime. ");
INSERT INTO tacNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Neka aníguru, napu'lige raweli sébasa napurigá Onorúgame gustisia olámala, a'pílipi rió neraga ruimeli ju cha anigá eyéniligó. ");
INSERT INTO tacNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mué ra'ichálila 'we a'lá nejkúrisa napurigá tabilé narémala gastigo 'we a'lá a'ká nísaká alué ra'íchali. Tabilé a'ká nísaká alué ra'íchali, 'liko mué wa'lú gastigo narémala. ");
INSERT INTO tacNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","'Liko jaré bariseo 'lige jaré Moisesi nila nulalí benírame anele Esusi: ―Mué rió Onorúgame nila ra'íchali benírame, ramueka 'we eténili alué 'we semátiri tábiri newachi mué, alué napu ta'wesi rió gayéname ju newá. ");
INSERT INTO tacNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","'Lige Esúsika anele: ―Ye 'we i'nílime ralámuli, tabilé sébali olame napu najkí Onorúgame 'la sébali olámirisá, rejoa aníguru napurigá ne newámala 'we semátiri tábiri napu tabilé gayéname ju ralámuli. Neka tabiléchigo newámalagó napurigá 'emi 'la machimela. Pe bi'lepi tábiri newámala ne abé i'libeko, pe alué napu ne newámili ju pe aba alieri nímala napu ikílige alué 'ya bejtégame rió napu ruyame nile napu Onorúgame anele, Jonasi anilime. ");
INSERT INTO tacNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Alueka ro'chí rojpálichi asálekurú bakiá rawé 'lige bakiá rukó, alué wa'lú ro'chí napu wa'lú ba'wichí oyame ju. Alarigá ikimela alué Onorúgamete julárigame 'pa rewagáchika, pachá jena gawichí bo'imela bakiá rawé 'lige bakiá rukó. ");
INSERT INTO tacNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Alé we'ká riógichi napu Jonasi rejcholi nejile, aleka Nínibe anilichi nile. Napu'lige alué ralámuli akisá alé alué rejcholi, 'la a'rélekuru alué chátiri 'nátali 'nata. Napu'lige 'emi ruyechi ne ye rejcholi, 'émika tabilé a'reme júkuru alué chátiri 'nátali 'nata. Neka abéchigo wa'lú najtékame júkuru me'tigá alué Jonasi. Napu'lige seba raweli napu Onorúgame gustisia olámala alué ralámuli chátiri 'nátame, 'liko alué ralámuli Nínibe mochígame chojkila neraga che'wámala 'emi tabilé ku guwana 'nátame koriká. ");
INSERT INTO tacNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Napu'lige sebasa raweli gastigo (juicio) narémichi ralámuli jipe ejperégame, alué wa'lula mukí napu nulame nile alé Saba anilichi napu 'we 'ya bejtégame nile ku ajánamala a'lige rawé, 'lige ra'ichámala sairúgame neraga alué ralámuli jipe ejperégame olagá. Alué mukika napu'lige bijí ajagá asigá 'we mejkaka nawálekuru gepumia alué Salomoni nila rejcholi 'we benegá ra'íchame, 'lige jipe jena ajtíkuru ne napu abé benegá ra'íchame ju me'tigá alué Salomoni, 'lige 'émika tabilé gepúnili ne nila rejcholi. ");
INSERT INTO tacNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","› Napu'lige alué u'tabela remónisi ma'chínasa bilé ralámulichi jami wakígichimi simime júkuru 'yásiga bilena 'we a'lá suérikáchi resíbamia, nobi tabiléchigo rewame júkó. ");
INSERT INTO tacNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","'Liko regá anime ju: «Ku simé ne napu ajtí alué rió napu ne galila nílige, 'lige ku pachágana bajkimé ne, alé pacháganaka ne galílachi kame.» 'Lige ku alé sébaga 'we a'lá bi'wigá ilígame eteme ju abé 'la gatérigime pechítigame, (pe tabilé che'sime neraga etéwili ju alué rió. Abirigáchigo tabilé ajchágame kéréko Onorúgame Alawala pachágana sulachí.) ");
INSERT INTO tacNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","'Liko alué u'tabela remónisi chéchigo gichao u'kuchípala remónisi, abéchigo enátiri napabume ju, 'lige suwábaga alué lakí remónisi alé pachágana alué riochi mo'ime ju. 'Lige alué rioka abéchigo cha nokame nímala me'tigá bajchabé rawé. Alarigá ikimela ye ralámuli tabilé a'ká. Pe i'sínimi a'reme júkuru 'emi alué chátiri nóchali, 'lige 'emi tabilé ajchágame nísaká Onorúgame Alawala a'kinana rawé, abéchigo cha nokame gainámala 'emi. ");
INSERT INTO tacNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Napu'lige Esusi bijí ra'icha ilígichi ralámuli 'yuga, sébale Esusi eyela 'lige suwábaga alué nasípasi bonila 'lige nasípasi waíla alé ma'chige. 'Lige ma'chige jale Esusi 'yuga ra'ichánilia. ");
INSERT INTO tacNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","'Lige bilé rió anele Esusi: ―Mué eyela 'lige mué bonila 'lige mué waíla ma'chige jawí, mué si ra'ichánilirí. ");
INSERT INTO tacNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","'Lige Esusi anele alué napu simile ruimea: ―¿Chieri júkó ne eyela, chieri júkó ne bonila 'lige ne waíla? ");
INSERT INTO tacNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","'Liko e'nénele alué oyérame, 'lige majoga regá anile: ―Ye ne 'yuga járome ralámuli júkuru ne eyélaka 'lige ne bonila 'lige ne waíla. ");
INSERT INTO tacNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Apiépiri napu ekí 'la e'wame ju napurigá nulá ne O'nola Onorúgame, alué napu 'pa rewagachi ajtí, suwábaga alué júkuru ne bonila 'lige ne waíla 'lige ne eyela. ");
INSERT INTO tacNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","A'lige rawé Esusi 'ma simile alé galírale asigá 'lige 'mi wa'lú ba'í ilígichi suwékimi asíbale. ");
INSERT INTO tacNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","'Lige asíriga we'ká ralámuli napuíle alé napu asale Esusi. 'Lige alekeri alé bárkochi 'mole Esusi, 'lige suwábaga ralámuli alé ba'wichí suweke jale. ");
INSERT INTO tacNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","'Liko Esusi chojkile ralámuli beniria we'ká tétali rejcholi. Regá anele: ―Bilé rió ri'ligó echimea simile weroka. ");
INSERT INTO tacNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Jaré pe u'kabi talí boichimi rujsule. 'Lige chulugí jsile, 'lige 'ma go'ale alué ri'ligó. ");
INSERT INTO tacNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","'Lige jaré talí pe 'we rejtérale rujsule, tabilé 'me wa'lú ajtígichi we'é, 'lige yati ya'wile. ");
INSERT INTO tacNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","'Lige rayénilite 'ma wakíbale alué ri'ligó ya'wisá, pecha re'lé nawégame níligame. ");
INSERT INTO tacNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","'Lige jaré asíriga ro'rúgachi rujsule wejchá jágichi. 'Lige 'ma 'yale alué wejchá sawala, 'liko tabilé gayénale alué ri'ligó e'wele o'chera. ");
INSERT INTO tacNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","'Lige jaré talí 'we a'lá we'égachi rujsule, 'lige alueka 'we a'lá ya'wile 'lige asíriga 'la 'wíliru. Jaré ri'ligó mulalá bilé siento ri'ligó rakele. 'Lige jaré usánisa makué rakele. 'Lige jaré baisá makué rakele. ");
INSERT INTO tacNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","'Emi 'la najkégame níriká napurigá akiboa, asíriga 'la gepúlime júkuru ye ra'íchali. ");
INSERT INTO tacNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","'Liko alué Esusi 'yuga járome a'bé mochíbale napu asale alué Esusi, 'lige regá anele alué Esusi: ―¿Chonigá alarigá anéché mué alué ralámuli alué tételite peka 'la námame kachi alarigá ra'íchachi mué? ");
INSERT INTO tacNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","'Lige Esúsika anele: ―'Émika 'we a'lá ma'chígime ruyémala ne napu tabilé námale 'emi. 'Lige uché jaré ralámulika tabilé 'la ma'chígime ruyémala ne, napurigá alué ralámuli tabilé pe'tá námaka ejtebímala rekó 'we a'lá akee 'lige rekó 'we a'lá etee. ");
INSERT INTO tacNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Alué napu 'la námame ju bilé ra'íchali rejcholi ruilía churigá nulame ko Onorúgame, Onorúgameka uché rajpé 'yámili ju 'nátili. Alué napu tabilé námame ju 'lige tabilé beninálime ju Onorúgame tabilé lisensia 'yámala napurigá benimela, 'liko alué u'kabi napu námame ju 'ma we'kuámala. ");
INSERT INTO tacNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Alekeri alarigá ra'icha ne, napugiti alueka rekó 'la etee, tabilé eteme kame, 'lige aminami rekó 'la akeme ke, tabilé akeme kame, 'lige aminami tabilé námame rekó 'la akeme ke. ");
INSERT INTO tacNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Alarigá ikíbá napurigá sébali ikimela napu anele Onorúgame 'ya alué rió Isaíasi anile. Regá anele: Rekó akeme ke Onorúgame nila ra'íchali, tabiléchigo námame júkó. Rekó 'we a'lá eteme ke, tabiléchigo námame júkó. ");
INSERT INTO tacNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Jipe ejperégame ralámulika tabilé a'lá 'nátame ju, 'ma na'ole najkala 'lige 'ma busílatiri 'ma na'ole napurigá tabilé etémala 'lige napurigá tabilé akimela, 'lige napurigá tabilé 'la námamala alué, napurigá tabilé ku smela, 'lige napurigá 'yómala ne. ");
INSERT INTO tacNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","› Onorúgame 'we ganíliga ajtí napugiti 'emi 'we a'lá ma'chílime buségame kame, 'lige aminami 'we a'lá akeme najkégame kame 'emi. ");
INSERT INTO tacNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Neka 'la bijchiá aníguru. Asíriga we'ká mochile 'we 'ya alué napu ruyame nile napu Onorúgame anele, 'lige aminami asíriga we'ká ralámuli 'we a'lá, 'lige asíriga eténilie ye tábiri napu 'emi etiá jipe, tabiléchigo etéliko 'lige aminami asíriga gepúnilituru alué ye ra'íchali napu 'emi gepua mochí jipe, pecha i'téligime ye ra'íchali. ");
INSERT INTO tacNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","› 'We a'lá gepuwa chonigá anime ko alué tétali bilé rió echame ri'ligó. ");
INSERT INTO tacNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ralámuli alué ra'íchali gepume, alué napu ruyame ju alarigá nulame ko Onorúgame ralámuli alawálachi, 'lige pe tabilé námame ju, pe napurigá alué talí napu boichimi rujsule alarigá ju 'emi. Nawame ju Remónisi 'lige 'ma bujeme ju pe'kabi ra'íchali napu 'la námale. ");
INSERT INTO tacNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Alué talí napu rejtérale rujsule, alueka pe napurigá ralámuli ra'íchali gepume 'we semáriga, pe alarigá ju, ");
INSERT INTO tacNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","nobi tabiléchigo 'la re'lesi nawégame júkó, tabilé we'lisi oyérame ju Onorúgame. Napu'lige ralámuli cha anisá alué ralámuli olagá, 'we gawélesa Onorúgame oyérame kóriká, 'liko alué ralámulika 'ma a'reme ju alué 'we a'lá ra'íchali oyeria. ");
INSERT INTO tacNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Alué talí wejchégichi rujsúkame ka, alueka pe napurigá ralámuli pe tábiricho 'we korume pe alarigá ju, alué ralámuli napu 'we korume ju o'pacha, go'ame 'lige aminami enomí. 'Liko 'ma a'reme ju Onorúgame ra'ichálila oyeria. ");
INSERT INTO tacNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Alué talí 'we a'lá we'echi echerúgime ka, alueka ju napurigá ralámuli Onorúgame ra'ichálila gepume, pe alarigá ju. 'Lige 'we a'lá námame ju alué ralámuli, 'lige asíriga 'la e'wame ju napurigá aní Onorúgame nila ra'íchali. Jaré alué ralámuli napurigá ri'ligó mulalá, alué napu bilé siento rakégame ju, pe alarigá ju. 'Lige jaré napurigá usánisa makué rakégame, pe alarigá ju. 'Lige jaré napurigá baisá makué rakégame, pe alarigá ju. ");
INSERT INTO tacNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Esusi uché bilé tétali ruwile, regá anile: ―Napu'lige ralámuli 'la oyérasa napurigá nulá Onorúgame, pe napurigá bilé rió ri'ligó echágame 'we a'lá we'é bo'ígichi, pe alarigá ju. ");
INSERT INTO tacNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Napu'lige gojchigá bi'tígichi, sairúgame bajkile alemi echerúgichi 'lige alé echale alué chátiri gajsalá rakala. 'Lige napieri ri'ligó alieri ya'wime nile alué gajsalá. 'Lige 'ma simile alué sairúgame alué gajsalá rakala echisá. ");
INSERT INTO tacNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Napu'lige ri'ligó o'chérasa, 'ma mulele alué ri'ligó, a'lige kulí ma'chí néréle alué chátiri gajsalá nerugo alé ri'ligó echégichi. ");
INSERT INTO tacNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","'Liko nóchame alé ri'ligó echégichi, simíbale ruyemia alué ri'ligó echágame. Regá anele: «Mué, ¿'la a'ká ke alué talí napu mué echálige? ¿Kócheka ma'chínalepeché alué chátiri gajsalá?» ");
INSERT INTO tacNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","'Lige anile ri'ligó echágame: «Bilé sairúgame nokálegeréko alieti echá.» 'Lige alué nóchame rukele alué ri'ligó echágame rió: «¿Pala simawa alué chátiri gajsalá bo'naboa?» ");
INSERT INTO tacNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","'Lige anile alué rió ri'ligó echame: «Tase, pecha 'la nímalawé, pe ri'ligó 'yúriga bo'nuímaleké. ");
INSERT INTO tacNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pe a'réwagó napurigá ri'ligó 'yuga o'chéramala. Napu'lige 'wílichi ne bo'né nulémala ralámuli nóchame napurigá rojániga napabúmala alué chátiri gajsalá, 'lige bulugá ro'igá e'kósamala. 'Lige ri'ligoka abé nujubá gatewa rekóachi.» (Alué chátiri gajsalaka pe napurigá Remónisi gompaniérola ju.) ");
INSERT INTO tacNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Esusi abiena ruwile uché bilé tétali. Anile: ―Napu'lige Onorúgame chojkichi nulá ralámuli alawálachi, pe napurigá gilibá a'lásini echerúgime 'we a'lá we'echi, pe alarigá ju. ");
INSERT INTO tacNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Asíriga u'kichí ju alué talí a'lásini rakala, 'lige asíriga e'wele ochérame ju alué gilibá ya'wisá, me'tigá alué ri'ligó. 'Lige chulugí jsime ju 'lige alé kábame ju. ");
INSERT INTO tacNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","'Lige uchéchigo bilé tétali ruwile Esusi ralámuli beniria. Regá anile: ―Napu'lige Onorúgame chojkichi nulá ralámuli alawálachi a'chigóriga ju napurigá bilé mukí napu 'wile pe'tá kawali, napu ba'raga ro'ele alé arínachi 'lige alué kawali ba'rárigame bochígimi nabale alué arínachi. ");
INSERT INTO tacNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Esusi pe tétalicho ra'íchale ralámuli 'yuga, pe alarigacho ruyele. ");
INSERT INTO tacNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Alarigá ra'íchale Esusi napurigá 'la alarigá ikimela napurigá anile alué 'ya ajtígame rió napu ruyame nile napu Onorúgame anele. Regá anile alué rió: Pe tétalicho ruyema ne ralámuli. Regá ruyema ne ralámuli alué ra'íchali napu 'we nóchali kame ju námalia. Napusí Onorúgame newálige ye gawí, ralámulika tabilé námale ye tétali. ");
INSERT INTO tacNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","'Lige Esusi 'ma ku júlale suwábaga ralámuli napu mochile alemi, 'lige bajkile alé pachá galírale 'lige alué 'yuga járome anele alué Esusi: ―Mué Wa'lula, ruyérigó ramué choniame ju alué gajsalá ri'ligochi jágame. ");
INSERT INTO tacNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","'Lige anile Esusi: ―Alué napu 'we a'lá talí echame ka, alueka pe Onorúgamete julárigame ju 'pa rewagáchika. ");
INSERT INTO tacNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Alé we'échika napu echale alué talí echame, aleka pe napurigá wijchimoba ju. Alué 'we a'lá talí aniáká, alueka pe ralámuli 'we a'ká ralámuli aniame ju, alué napu 'la a'reme ju napurigá Onorúgame nulámala. Gajsalá aniáká alueka pe ralámuli Remónisi oyérame aniame ju. ");
INSERT INTO tacNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Alué sairúgameka napu echale alué chátiri gajsalá, alueka pe Remónisi kéré. 'Lige alué 'wílime aniáká, alueka napu'lige gawí amulí suwíbachi aniame ju. 'Lige alué 'wime aniáká, alueka santo ánjeli aniame ju. ");
INSERT INTO tacNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","A'chigóriga napurigá oliame ju alué chátiri gajsalá, a'chigóriga oláwili ju alué Remónisi oyérame napu'lige ye gawí suwíbachi. 'Emi 'we a'lá machí pe na'ichí 'lúlime ko alué chátiri gajsalá. ");
INSERT INTO tacNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Alué rió Onorúgamete julárigame 'pa rewigáchika, alueka santo ánjeli nulémala napurigá a'miná 'lúmala alué chátiri ralámuli jena wijchimoba mochígame, alué napu chátiri 'nátili 'yame ju uché jaré ralámuli, alé napu Onorúgame nulame ju. ");
INSERT INTO tacNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","'Ma na'ichí 'lúpua. 'Lige alué chátiri ralámuli nalá mochímala 'we resí níliga, 'lige majaga. ");
INSERT INTO tacNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","'Liko ralámuli 'la sébali olame napurigá nulá Onorúgame, alueka napurigá Onorúgame alarigá nímala. 'Émi ralámuli 'we a'lá najkégame níriká, 'la 'we a'lá gepuwa ye ra'íchali. ");
INSERT INTO tacNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","› Napu'lige Onorúgame 'we a'lá semáriga nulachi ralámuli alawálachi, pe napurigá enomí we'echi tótigame, alarigá ju. Bilé rió we'ká enomí tótigame rewisá, abajá nasosa we'ete o'póliga. 'Liko asíriga ra'sáligá asimela alué rió, 'ma simela ralinemia suwábaga tábiri napu ekí tábiri nígame ju bo'né. 'Lige alué enomite ralimela alué gawí napurigá bo'né niga neraga asimela alué enomí. ");
INSERT INTO tacNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","› Abiena napu'lige Onorúgame 'we semáriga nulachi ralámuli alawálachi, pe a'chigóriga ju napurigá bilé rió ralinega nóchame, rejté 'yaga eyéname alué 'we rojsákame re'wame ba'wichí nerúgame napu «perla» anilime ju yolí ra'íchaga. ");
INSERT INTO tacNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Napu'lige rewisá bilé 'we a'lá jino rejté «perla» alué napu 'we najteme ju, 'lige alué rioka ralinémala napu ekí tábiri ni bo'né, 'lige alué enomite ralimela alué 'we jino rejté. ¿Pala 'la námata 'emi ye tétali? ");
INSERT INTO tacNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","'Lige Esusi uchéchigo bilé tétali ruyele ralámuli churigá nulamio Onorúgame ralámuli 'yuga. Regá anile: ―Pe napurigá bilé morali ro'chí i'mula ba'wichí pasa bilé rió ro'chí i'mume, we'ká buinasa napu ekí ro'chí oyame ju ba'wichí. ");
INSERT INTO tacNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Napu'lige bochisa alé morálichi, alué ro'chí i'múmeka 'mi suwemi o'tome ju alué morali, 'lige alé mochíbame ju abé a'kalala ro'chí rojana, alué 'lina ro'ámala waná atabechi. 'Lige alué ta'mé a'kátirika alueka 'ma 'lúmala. ");
INSERT INTO tacNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Alarigá nímala napu'lige gawí suwíbachi. Santo ánjeli buyámala ralámuli wanápamia alué cha nokame alé a'ká ralámuli mochígichi. ");
INSERT INTO tacNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","'Lige alué cha nokame ralámulika 'ma na'ichí 'lúpili ju, asíriga enárikáchi rajachi. 'Lige nalámala alué cha nokame ralámuli 'we resí níliga. ");
INSERT INTO tacNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","'Lige Esusi rukele: ―¿'La námilia 'emi ye we'ká tétali? 'Lige anile alué Esusi 'yuga járome: ―Ramueka 'la námilia. ");
INSERT INTO tacNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","'Lige Esusi anele: ―Bilé rió napu benírame ju Moisesi nila nulalí napu 'we a'lá benime ju churigá nulame ko Onorúgame, alueka pe napurigá bilé rió galí nígame, alarigá ju. Rekóachi ma'chí buyáname ju tabiri o'chéranti 'lige nuebo abiena. Alué rioka 'la machimela Onorúgame ra'ichálila, alueka 'la námamala 'ya nerúgame rejcholi 'lige jipe nerúgame rejcholi abiena, alué napu ne ruwí. ");
INSERT INTO tacNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Napu'lige Esusi 'ma guwárisa ye tétali ruyá, 'we ilile uchéchigo bilénami simiá. ");
INSERT INTO tacNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Napu'lige sebasa alé we'ká riógichi napu bejtégame nílige alué bo'né Esusi re'malí ka (Nasareta anilichi), chojkile ralámuli ra'íchali beniria alé u'tá re'obachi «sinagoga» anilime. 'Lige ralámulika 'we e'negá jale. Pe laa jale alué ralámuli: ―¿Koche benílepeché suwábaga ye ra'íchali? ¿Koche narélepeché a'walí napurigá newámala ye 'we semátiri tábiri napu tabilé gayéname ju newá ralámuli? ―regá rukele a'bopi ra'íchaga—. ");
INSERT INTO tacNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Tacha ye ju alué sía 'lige mesa newame inolá alué napu José anilime nílige? ¿Tacha ye ju alué María ranala? ¿Tacha ye ju alué Jacobo ba'chila 'lige José 'lige Simoni 'lige Jurasi? ");
INSERT INTO tacNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Tacha jena ejperégame ju alué rió waíla jena we'ká riógachi? ¿Koche benílepeché ye rió suwábaga alué tábiri? ");
INSERT INTO tacNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Alekeri alué ralámuli majale 'lige tabilé beninálile alué rejcholi. Alekeri Esusi anele alué ralámuli: ―Bilé ra'íchali nerú regá anime: «Bilé rió napu ruyame ju napu ané Onorúgame eyénachi alé napu ochérame ju, aleka tabilé niraga etélime ju. Uché bilénami einásaká, 'we a'lá nirálime ju. 'Emi alarigá nokáguru ne'chí 'yuga.» ");
INSERT INTO tacNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Alué ralámuli tabilé bijchígale alué Esusi ra'ichálila, alekeri alué Esusi tabilé we'ká ralámuli sa'wale. ");
INSERT INTO tacNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","A'kinana rawé Erore, alué napu wa'lula nílige alé Galilea anilime ejiro, akele alarigá nóchame ko Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","'Liko alué Erore anele alué bo'né 'yuga nóchame: ―¿Chieri júpeché alué Esusi anilime? Siné kachi pe Juani kerékó, alué napu ralámuli rewarame nílige. Siné kachi 'ma ku ajánalegerékó. Alekeri 'la nígame nisa a'walí napurigá sa'wámala ralámuli napu 'ma tabile sa'wimeli nile. ");
INSERT INTO tacNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Aluéchigo bo'né Erore nuláligime Juani cha'píniliga abé 'yabé 'lige 'ma galírale bajchale karénate bulugá pe alué Eroríasi chojkila gite napu Belipe upila nile alué bo'né Erore ba'chila. Alué Belípeka se'nú eyégame nile. ");
INSERT INTO tacNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Juánika anélige alué Erore tabilé ikiárekó alué mukí rewisá alué Belipe 'yula. Alarigá anélige alué Juani: ―Tase 'yula neraga asiboa alué mukí, alué mué bonila upila. ");
INSERT INTO tacNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Alésíko alué Erore 'we me'lináliga etele Juani, pe iligá 'we majale ralámuli. Ralámulika 'wéchigo 'la niráligime alué Juani, 'la machíligame Onorúgame nila ra'íchali nareme níligo. ");
INSERT INTO tacNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","'Lige napu'lige bamíbali sebárichi alué Erore, Erore bilé piesta newale. 'Lige alué mukí iwé Eroríasi ranala yawile alé piéstachi. 'Lige alué Erore asíriga galele alué iwé yawisá. ");
INSERT INTO tacNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","'Lige alué Erore asíriga we'ká e'karúgame tábiri 'yámoríle alué iwé yawigórika, napu ekí tábiri najkió 'yámoríle, 'lige aminami suwábaga ralámuli akele napu anile. ");
INSERT INTO tacNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","'Liko alué iweka anile: ―Neka najkí napurigá jeka a'pámala mué Juani mo'ola bilé bejtólichi ajchagá. Alarigá anile 'máchigo 'la anérigime níligame eyélate. ");
INSERT INTO tacNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","'Liko asíriga we'ká 'nátale alué wa'lula Erore. Tabilé 'la nerale, 'lige 'máchigo akéleko suwábaga ralámuli napurigá anílige alué wa'lula Erore we'ká e'karúgame 'yámoríligo. ");
INSERT INTO tacNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Alekeri nulale napurigá rijpunawa alué Juani mo'ola. 'Liko 'ma gujtachí rejpináleru Juani. ");
INSERT INTO tacNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","'Lige bejtólichi ajchigá a'páliru alué Juani mo'ola, 'lige alué iwé 'yáleru, 'lige alué iweka eyela 'yale. ");
INSERT INTO tacNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","'Liko Juani gompaniérola ralámuli jsile 'lige 'ma o'tole alué Juani gatemia. 'Lige simíbale Esusi ruyemia. ");
INSERT INTO tacNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Napu'lige alieti akisá alué Esusi, 'ma simile bilé bárkochi 'mi bilena tabilé riógachi. 'Lige ralámuli machile alemi simiá enáligo alué Esusi, 'lige alué ralámuli 'ma simíbale 'mimi wijchí jaga napu sebámili nile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Napu'lige sebasa Esusi bárkochi, asíriga we'ká ralámuli etele, 'lige asíriga na'temaka etele, 'lige 'yole napu ekí nayume nile alemi sígame ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Napu'lige 'ma alí kachi, alué makué oká Esusi 'yuga járome ralámuli anele Esusi: ―Asíriga tabilé 'wesi riógachi ju jena. 'Lige 'ma alí júkuru. Juláwaguru ralámuli napurigá 'mi a'tabemi riógachi simámala go'ame ralimea. ");
INSERT INTO tacNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","'Lige Esúsika nejele: ―Tabilé asemi julawa, aba jena mochíralekó o'maka. 'Emi a'boi 'yáwaguru go'ame napurigá go'mela ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","'Lige anile alué oyérame: ―Pe malígipi baní nerúgeréke'é 'lige pe okabi ro'chí. ");
INSERT INTO tacNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","'Lige anile Esusi: ―Jeka o'tosígó alué baní 'lige ro'chítiri. ");
INSERT INTO tacNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","'Lige nulale napurigá i'kilí mochíbamala ralámuli alé wijchí gajsalachi amoba. 'Lige napu'lige u'sá alué maligi baní 'lige alué oká ro'chí, anele Onorúgame: ―Cheliérabá mué O'nó Onorúgame. 'Lige a'tabé chi'wánale alué baní. 'Lige 'yale alué makué oká bo'né 'yuga járome napurigá ralámuli 'yámala. ");
INSERT INTO tacNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Suwábaga ralámuli go'ale 'lige asíriga bosaga ejtebile alué baní go'sá ro'chí 'yúriga. 'Lige alué oyérame napubule a'tabé rasíriginti alué baní 'lige ro'chí 'lige atabechi ajchale. 'Lige makué oká atabé bochile. ");
INSERT INTO tacNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","We'ká ralámuli go'ale, riótiri, 'lige umugítiri, 'lige u'kuchítiri, maligi mili nile pe e'wele riocho. ");
INSERT INTO tacNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pe'tá i'libeko Esusi júlale alué makué oká bo'né 'yuga járome napurigá bárkochi jímamala napurigá simámala uché bilena. 'Lige Esúsika alé rejpile. ");
INSERT INTO tacNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Napu'lige 'ma ralámuli simasa, 'liko Esusi 'ma simile bilena rabó Onorúgame 'yuga ra'ichamia. 'Lige 'ma chonasa, alué Esúsika pe bi'neli asale. ");
INSERT INTO tacNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","'Lige bárkoka 'ma 'mi nasipa wa'lú ba'wichí enale, 'lige asíriga iwégame ekénale alemi enágichi alué barko. 'Lige aminami asíriga re'pá ilírole alué ba'wí, a'wágame chíbale ba'wí alé bárkochi o'weka neraga. Tabilé gayénale simiá. ");
INSERT INTO tacNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","'Lige 'ma amulí che'lachi, Esusi simile o'weti iligá ba'ichí amoba alé 'mi napu barko enale. ");
INSERT INTO tacNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Napu'lige alué Esusi 'yuga járome etesa Esusi alé ba'ichí amoba enágichi, asíriga majale. ―¡Pe chu'í káwé alué! ―anile. 'Lige bochí anile majaga. ");
INSERT INTO tacNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","'Lige Esúsika anele: ―¡Tase majawa, pe ne ju! ");
INSERT INTO tacNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","'Lige anile alué Pegro: ―Mué Wa'lula Esusi nísaká, ne'chí nulébá napurigá ne ba'ichí amoba teka enegá sebámala napu mué ilí. ");
INSERT INTO tacNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","―Jeka simígó 'liko ―anile alué Esusi. 'Liko alué Pegro re'kísele bárkochi, 'lige amoba ba'ichí enale 'mi alé simiá napu ilile alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Napu'lige ne nílasa 'we ekao, 'ma majale. 'Lige i'kilí bokuíle alé ba'wichí, 'lige napu'lige 'ma bokuía, e'wele ra'íchaga bayele Esusi: ―¡Muérigo Wa'lula, ma'chí paki ne'chí! ");
INSERT INTO tacNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","'Lige Esúsika yati cha'pile sekate, 'lige anele: ―¡Mueka 'we pee bijchígame ju! ");
INSERT INTO tacNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Napu'lige 'ma okáraga jímasa ku bárkochi, 'liko 'ma asíbale eká. ");
INSERT INTO tacNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","'Liko suwábaga rió napu ekí mochílige alé bárkochi, asíriga 'la neraga etele Esusi, 'lige anele: ―'La bijchiá mueka 'la Onorúgame Inolá júkuru. ");
INSERT INTO tacNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","'Lige sébale alé ejiro Genesareta anilichi. ");
INSERT INTO tacNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Napu'lige alé ejperégame ralámuli machisá alé ajtigó Esusi, júlale jaré ralámuli napurigá chejaré ralámuli ruyémala alé a'bemi mochígame suwábaga. 'Lige ralámulika suwábaga nayúkame a'pagá jsile. ");
INSERT INTO tacNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","'Lige alué ralámuli napu nayúkame a'pagá jsile lisensia tánele Esusi napurigá alué nayúkame Esusi o'páchilichi chébimia. Suwábaga napu ekí chébale alé Esusi o'páchilichi, 'ma sa'wile. ");
INSERT INTO tacNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","'Lige jaré bariseo 'lige jaré alué Moisesi nila nulalí benírame Rusalénika sígame, sébale alé Esusi ajtígichi. 'Lige anile Esusi olagá: ");
INSERT INTO tacNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―Mué 'yuga járome ka tabilé 'la sébali olá alué nulalí panígilime napu nulale alué 'ya mochígame. ¿Chonigá alarigá nokame ju? Alueka tabilé panígime ju napu'lige go'ame go'mea napurigá nokiame niru ramué. ");
INSERT INTO tacNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","'Lige Esúsika rukele: ―'Émika ¿chonigá tabilé 'la sébali oliágó napu nulale Onorúgame 'we 'ya? Pe a'lá sébali olame júkuru 'emi nulalila. ");
INSERT INTO tacNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Regá nulale Onorúgame: «'La niraga etewa a'boi o'nola 'lige a'boi eyélatiri.» 'Lige abiena nulale: «Napuyépiri napu chíbiriga ra'íchame ju o'nola olagá 'lige eyela olagá, alueka me'liboli ju.» ");
INSERT INTO tacNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","'Émika anime júkuru 'we a'lá ko bilé rió regá anea o'nola eyélatiri: «Tabilé nejkúrimala ne, neka Onorúgame 'yámolá suwábaga napu ekí nígame ju ne», ");
INSERT INTO tacNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","'lige apiépiri napu anime ju regá, 'ma tabilé gu'írimili ju bo'né o'nola 'lige eyela. Neka aníguru 'ma tabilé 'la sébali olame ko 'emi alué napu nulale Onorúgame, tabilé 'la nirá 'emi Onorúgame nila nulalí, 'lige pe 'emi a'boi nila 'nátili cha'pigá mochigo 'emi. ");
INSERT INTO tacNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡'Émika 'la tabilé 'nátanti! 'Émika asíriga 'la semáriga ra'íchame júkuru kaka ra'ichálilaká, nobi tabiléchigo 'la 'nátame kéréko 'emi a'boika, 'lige tabilé 'la sébali olame ju 'emi. Alué 'ya bejtégame Isaíasi anilime rió napu ruyame nile napu Onorúgame anele, osale napurigá anílige Onorúgame. Asíriga 'la ma'chígime anile pe 'emi olagá. Regá osale: ");
INSERT INTO tacNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ye ralámulika asíriga 'la semáriga ra'íchame júkuru ne'chí olagá, ne napu ju Onorúgame, tabiléchigo oyérame júkó ne'chí. Pe se'wináriga 'nátame ju. ");
INSERT INTO tacNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","'We a'lá nerame korime ju ne'chí, tabiléchigo 'la nirame kéréko, 'we a'lá semáriga ra'icha nobi pe ralámuli nulalila benírame kame, tabilé Onorúgame nulalila. ");
INSERT INTO tacNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","'Lige Esúsika alué we'ká ralámuli bayele, 'lige regá anele: ―'La 'we a'lá gepuwa. ¿Pala 'la námata 'emi? ");
INSERT INTO tacNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Bariséoka anime ju Onorúgame tabilé 'wimio alué rió go'ame go'sá tabilé panígisa. Neka aníguru tabilé chéré Onorúgame níriká go'ame ka bajkime ju bilé ralámulichi. Onorúgame níriká abé najtékame ju alué ra'íchali napu buyame ju chu'álachi. Chátiri ra'íchali buyásaká 'liko Onorúgame tabilé e'wémala alué rió. ");
INSERT INTO tacNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","'Liko alué Esusi 'yuga járome a'bé jábele, 'lige rukéliru alué Esusi: ―¿Machí mué alué bariseo tabilé ganíliga ejtebíligo alué mué ra'ichálila ajkisá? ");
INSERT INTO tacNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","'Lige Esúsika nejele: ―Napiépiri gajsalá, rojátiri, tabilé ne O'nola 'pa rewagachi ajtígame echágame, alueka 'ma bo'narúgme nímala. Alarigá ikimela alué bariseo. ");
INSERT INTO tacNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pe a'réwagó. Pe napurigá bilé rió tabilé ma'chílime uché jaré tabilé ma'chílime o'tome, pe alarigá ju. Bilé rió tabilé ma'chílime uché bilé rió tabilé ma'chílime o'tome pe okáraga rujsúmala bilena rejkolichi. ");
INSERT INTO tacNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","'Liko Pégroka anele Esusi: ―¿Chonime ke aní mué? Aka ruwíbá. ");
INSERT INTO tacNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","'Lige Esúsika anele: ―¿'Émichigó tabilé 'la námaliachigó? ");
INSERT INTO tacNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Tacha machí 'emi suwábaga go'ame napu chu'ichíkana bajkí wamí rojpachíkana simírame ko, a'kinana ma'chíname ko? Tabilé chátiri alawégame gayéname ju. ");
INSERT INTO tacNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nobi ra'íchali chu'ichika ma'chíname ka, alueka ma'chíname júkó napurigá 'nátame ju bilé rió. 'Liko alué ra'íchali tabilé 'la nísaká, 'liko alué rió 'ma chátiri alawégame gayéname ju. ");
INSERT INTO tacNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Bilé rió chátiri 'nátame, pe ralámuli me'gá einámala alué rió, 'lige aminami pe apiépiri umugí 'yuga gojchigá einámala 'lige aminami pe riótiri 'yuga gojchigá einámala, 'lige chigoga einámala aminami, 'lige aminami 'we 'yégiga einámala, 'lige pe sairúgame neraga ra'íchame nímala apiépiri ralámuli olagá. ");
INSERT INTO tacNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Alué chátiri 'nátili 'nátaga ra'íchasa, ralámuli 'ma chátiri alawégame gayéname ju, Onorúgame tabilé ganíliga etémala alué ralámuli, pecha chéréko rekó ta panige sekala go'ame go'mea. ");
INSERT INTO tacNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","'Liko Esusi simile alé Tiro anilichi we'ká riógichi 'lige Sironi anilichi we'ká riógichi, napu ejperégame nile alué ralámuli tabilé israelita. (Alué ralámuli israelita napurigá o'kochí alarigá neraga etele alué ralámuli.) ");
INSERT INTO tacNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","'Lige bilé mukí alé bejtégame napu tabilé israelita nílige, alemi sébale napu enale Esusi 'lige anile e'wele ra'íchaga: ―¡Muérigo Wa'lula, Rabí rijimala, 'la na'temápuaká ne'chí! Ne ranala iwé bilé u'tabela remónisi ajchágame ju, 'lige asíriga resí nilia ajtí. ");
INSERT INTO tacNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","'Lige Esusi tabilé nejele. 'Lige alué 'yuga járomeka anele Esusi: ―'Ma julawa alué mukí jena, jeka guwánaka e'wele ra'icha aníguru. ");
INSERT INTO tacNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","'Lige anile Esusi: ―Pe ralámuli israelítacho gu'íriniliga nulérigime ju ne Onorúgamete. Alué mukika pecha israelita júkó. ");
INSERT INTO tacNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","'Lige alué mukí sébale alé napu ilile Esusi, 'lige chojkóbisiga ilíbale, 'lige anele: ―¡Mué Wa'lula nulame, ne'chí gu'iri! ");
INSERT INTO tacNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","'Lige Esusi anele: ―Tabilé 'la ju u'tátiri baní bujilía 'lige o'kochí 'yamia. ");
INSERT INTO tacNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Abichilubi 'we anele alué mukí: ―Bijchiá ju napu aní mué, alué o'kochí abirigá go'yame ju alué kuchí baní mojágame rujsúkame. ");
INSERT INTO tacNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","'Liko Esusi anele: ―¡Mué mukí, mueka 'la bijchigi 'la sa'wame ko ne apiépiri nawilí! 'La sa'wimela mué ranala. 'Lige yati neraga sa'wile alué mukí ranala. ");
INSERT INTO tacNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","'Liko Esúsika simile alé asigá 'lige sébale suweke wa'lú ba'wí manígichi Galilea anilichi, 'lige 'pami rabó simile 'lige alé rabomi asale. ");
INSERT INTO tacNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","'Lige asíriga we'ká ralámuli sébale alé napu asale alué Esusi, 'lige we'ká nayume a'pale ralámuli sujírigame, 'lige aminami tabilé ma'chílime, 'lige aminami tabilé gayéname ra'icha, 'lige alé a'bé a'páliru napu Esusi ajtile. 'Lige Esúsika sa'wale alué nayúkame ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","'Lige ralámulika 'we ra'sálále napu'lige 'ma ku ra'íchachi alué tabilé ra'íchame, 'lige alué sujíriginti 'ma ku 'la e'yénachi, 'lige tabilé ma'chílime 'ma ku ma'chílichi. 'Liko alué ralámuli anile asíriga 'la nejkúrame ko Onorúgame, alué Onorúgame napu gu'írime ju alué ralámuli israelita. ");
INSERT INTO tacNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","'Liko Esusi bayele alué 'yuga járome 'lige anele: ―Neka 'we na'temá ye ralámuli. 'Ma bakiá rawé mochíkuru jena ne'chí 'yuga, 'lige tabilé nutugégeme júkuru napurigá go'mela. Pe arigá simásaká ku galírale, pe boichimi rekupámala e'luíka. ");
INSERT INTO tacNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","'Lige alué Esusi 'yuga járomeka anele: ―¿Churigá kóchimiyéna rewibówé go'ame napurigá ye ralámuli go'mela? Jénaka pe jami júkuru tabilé riógichi. ");
INSERT INTO tacNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","'Lige Esusi rukele alué bo'né 'yuga járome: ―¿Chekí baní o'kame nírukó 'emi? 'Lige nejele alué oyérame: ―Ramueka pe gichao baní o'kame niru, 'lige pe u'kabi ro'chí 'yúriga ―anile. ");
INSERT INTO tacNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","'Lige Esusi anele: ―Nulewa ralámuli napurigá i'kilí mochímala wijchí. ");
INSERT INTO tacNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","'Lige cha'pile alué gichao baní, 'lige o'wétiri rewagachi e'nénaga cheliera 'yale Onorúgame. 'Lige nasípasi chi'wánale baní 'lige ro'chítiri. 'Lige alué oyérame 'yale napurigá nachutámala, 'lige nachútele. ");
INSERT INTO tacNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","'Liko suwábaga go'ale 'lige asíriga 'la ganíliga ejtebile asíriga bosaga. We'liko 'ma o'pasasa alué ralámuli, gichao atabé bochile rasírigame go'ame. ");
INSERT INTO tacNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Naó mili nile pe riocho tase tétiga umugí 'lige aminami tase tétiga u'kuchítiri. ");
INSERT INTO tacNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Abé i'libeko Esusi suwábaga ralámuli julasa ku ejperélachi, Esusi 'lige alué 'yuga járome si, 'ma jímale bárkochi 'lige 'mi a'bé Magarani anilichi we'ká riógachi simíbale. ");
INSERT INTO tacNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Jaré bariseo 'lige saruseo simíbale Esusi e'nemia. Owile napurigá 'we semátiri tábiri newámala napu ralámuli tabilé gayéname ju, pe machináliga nokale pa'lá Onorúgamete julárigame ko. Mayele tabilé gainamio newá 'lige alarigá ralámuli tabilé oyéramio Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","'Lige Esúsika anele: ―Napu'lige 'emi 'pa rewagachi e'nesa, 'we a'lá machime júleké u'kumeo o tabilé u'kumeo ma. 'Lige 'emi etea rewigá 'we sejtániga ilígichi alí, asíriga 'la machime júlké 'emi melénala rawé tabilé nolégame rainamio. ");
INSERT INTO tacNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Napu'lige be'á be'lí 'we sejtániga ilisá 'pa rewagachi 'lige aminami nolega ilisá, a'lige abiena 'la machime júkuru 'emi u'kumeo. 'La tabilé 'nátanti 'emi, aka 'émika 'we a'lá námame képá ye tábiri kaka nobi uchéchigo jaré tábiri tabiléchigo námame júkó 'emi. Neka asíriga we'ká e'karúgame newame júkuru 'we semátiri napu tabilé 'wesi gayéname ju ralámuli newá, 'émika tabiléchigo námame júkó tachiri ruyame ko alué. ");
INSERT INTO tacNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","'Emi cha nokame ralámuli 'ma a'reme ju Onorúgame na'tálila 'lige uché bilé tábiri oyérame ju 'nalina napu tabilé Onorúgame ju, pe aminacho eténilime júkuru alué 'we semátiri tábiri. Pe bi'lepi tábiri etémala 'emi 'we semátiri. 'Émika etémala 'we semáriga ikichi ne i'libeko rawé, alué napu etémala 'emi pe ruyame nímala napu ikile alué Jonasi anilime rió. Alueka bakiá rawé bo'ílekuru pachágana ro'chí rojpálichi. Pe bilé tábiri ruwime kéréle alakiá Jonasi. 'Lige Esusi simile alé asigá. ");
INSERT INTO tacNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","'Lige Esusi simile bo'né 'yuga járome si ba'wichí bajuniga na'lebo 'nálige, 'lige tabilé nélegá simíbale baní alué Esusi 'yuga járome. ");
INSERT INTO tacNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","'Lige Esúsika anele: ―'La 'we a'lá 'nátaga alué bariseo nila kawali 'lige saruseo nílatiri. ");
INSERT INTO tacNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","'Lige alué oyérame anile a'bopi ra'íchaga: ―¿Chonigá alaníbiché? ¿Pe baní tabilé a'pásiga alaniéréko? ");
INSERT INTO tacNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","'Lige Esusi 'la machile alaniá mochígichi, 'lige rukele: ―'Émika 'we pee bijchígime júkuru Onorúgame 'we a'lá nejkúrimio. ¿Chonigá ra'icha 'emi a'boi tabilé a'pigárika baní? ");
INSERT INTO tacNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ta'chó nama 'emi, 'lige tabilé nélá 'emi pe maligi banite bosárigo ne maligi mili rió? ¿Tabilé nélá 'emi chekí atabé rasírigo baní? ");
INSERT INTO tacNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Abiena tabilé nélá 'emi pe gichao banite bosárigo ne naó mili ralámuli? ¿'Lige chekí atabé go'ame rasírigo? ");
INSERT INTO tacNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿'Lacha tabilé námatu pe tabilé baní olagá anió ne? Uchéchigo siné ruimé ne, 'la 'we 'la 'nátaga alué bariseo nila kawali, 'lige saruseo nílatiri. ");
INSERT INTO tacNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","'Liko 'ma námale tabilé alué kawali olagá aníligo alué Esusi, námale 'we a'lá 'nátaga mochímilikó 'nalina napurigá tabilé oilámala alué bariseo nile rejcholi, 'lige alué saruseo nila rejcholi. ");
INSERT INTO tacNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Napu'lige Esusi sebasa alé a'bé Sesarea Bilipo rewégichi we'ká riógachi, 'lige Esusi rukele alué makué oká rió bo'né 'yuga járome: ―¿Chonígó ralámuli, chieri korí ne napu nawale 'pa rewagáchika rió neraga? ");
INSERT INTO tacNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","'Lige anile alué bo'né 'yuga járome: ―Jaré ralámuli aní mué Juani kará, alué napu ralámuli rewarame nílige. 'Lige jaré aní mué Elíasi kará, alué napu ruyame nílige napu anélige Onorúgame, alué napu 'ya bejtégame nílige. 'Lige jaré aní mué Jeremíasi kará napu abiena ruwime nílechigó napu anele Onorúgame. 'Lige jaré aní mué kará uché bilé napu ruwime ju napu anele Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","―'Lige 'émika, ¿chieri koriágó ne'chí? —anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","'Lige Simoni napu abiena Pegro anilime nile anile: ―Mueka pe Kristo ju Onorúgame Inolá, alué Onorúgame napu nabí ajagá ajtime ju. ");
INSERT INTO tacNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","'Lige Esúsika anile: ―Mué Simoni, Jonasi inolá, pe Onorúgame 'smi mué gu'ira napurigá mué 'la námamala chieri ko ne, 'lige ralámulika tabilé gu'írile napurigá námamala mué. ");
INSERT INTO tacNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mué Pegro, mué rewalá «rejté» aniame kéré. Mueka napurigá bilé rejté napu ajchilime ju alé re'lé chojkichí napu galí eláwili ju, alarigá ju mué. Mueka napurigá bilé benírame nímala ne'chí oyérame ralámuli benírame. 'Lige rekó suwigé abiena ne'chí si mochímala 'pa rewagachi. ");
INSERT INTO tacNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Neka mué 'yámala lisensia napurigá nulame nímala mué. Mué anisáká 'we a'lá ko bilé 'nátili, Onorúgame 'we a'lá nirámalachigó alué 'nátili. Mué anisáká tabilé 'la ko bilé 'nátili, Onorúgamechigó tabilé 'la nirámala alué 'nátili. ");
INSERT INTO tacNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","'Lige Esusi 'we a'lá anele bo'né 'yuga járome napurigá tabilé 'wesi ruyémala Kristo ko bo'né, Onorúgamete julárigame. ");
INSERT INTO tacNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","A'lige Esusi chojkile ruyea alué bo'né 'yuga járome 'ma simeo alé Rusaleni anilichi. 'Lige alué e'wélala nulame, 'lige alué e'wélala balé, 'lige alué Moisesi nila nulalí benírame 'we resí olamio alué Esusi 'lige 'ma me'limeo, 'lige bakiá rawé kachi 'ma ku ajánimio. ");
INSERT INTO tacNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","'Lige Pegro a'mibemi chakena bayérale Esusi, 'lige ne'óchale, regá anele: ―¡Mué wa'lula tase alarigá ra'ichawa, tajsiné sebárimili júkuru alué rawé! ¡Onorúgame tabilé a'rémala mué alarigá ikichi! ");
INSERT INTO tacNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","'Lige Esusi o'wé e'nele alué Pegro, 'lige anele: ―¡Mué Satanasi, se'wí, simigá 'mimi mejkami! Mueka pe nejkumega eyena ne'chí 'yuga. Mueka 'nátame ju napurigá 'nátame ju ralámuli, tase napurigá Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","'Lige anele Esusi alué bo'né 'yuga járome: ―Jaré ralámuli ne'chí oyéranilisaká, nabí rawé e'wámili ju napu ne nulá 'lige 'ma a'rémili ju alué napu bo'né najkí. Rekó 'we resí nílie abirigáchigo senibí rawé 'we a'lá oyéramili ju ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Alué rió napu majame ju me'libólikó ne'chí oyérame kóriká, alueka tase rewimela semati raweli. Alué rió napu ne'chí oyérame ju 'lige bilé rawé me'lisuga ne'chí oyérame kóriká, alueka 'la semati raweli rewimela 'pa rewagachi. ");
INSERT INTO tacNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tabilé a'lá ju rekó bilé rió we'ká meme ke enomí, alué rió alawálaka wamí 'légana injiérnochi simeli júkuru. ¿Chekí najtétimala alué rió napurigá bo'né alawala tabilé simela injiérnochi? ");
INSERT INTO tacNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","'Ma pe'wé uchéchigo siné nawámala alué napu ju Onorúgamete julárigame 'pa rewigáchika, 'lige asíriga 'la semáriga nawámala Onorúgame a'walílate 'lige aminami santo ánjeli si smela, 'lige ralámuli napu 'la sébali olale Onorúgame 'yuga 'la narémili ju napu Onorúgame 'yámili ju. Alué ralámuli napu tabilé 'la sébali olale Onorúgame 'yuga, alueka gastigo narémili ju. ");
INSERT INTO tacNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Neka 'la bijchiá aníguru, jaré ralámuli napu jena mochí, tabilé 'cho suwimela napusí etesa alué napu 'pa rewagáchika nawale rió neraga 'we semáriga nulachi. ");
INSERT INTO tacNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","A'kinana usani rawé kachi Esusi o'tole Pegro 'lige Santiago, 'lige Juani, Santiago bonila, 'lige simíbale bilena re'pá rabó. ");
INSERT INTO tacNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","'Lige alé Esusi 'ma se'winátiri gayénale alemi alué bakiá rió Esusi 'yuga járome jágichi. Banalá napuyeri rayénali alieri gayénale. 'Lige o'páchalaka rojsákame gayénale 'la rapanti napurigá ra'ósali. ");
INSERT INTO tacNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","'Lige pe anaga neraga etele oká rió Esusi si ra'icha jágichi, bilé Moisesi nile 'lige uché bilé Elíasi, alué napu 'ya ejperégame nílige. ");
INSERT INTO tacNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","'Lige Pegro anele Esusi: ―Muérigo nulame, ¡'láchigo jena napuítiko'é ramué! 'La ikisá koko newáwa'é bakiá galí rojsate, napurigá 'emi mochímala alé, bilé mué galila 'lige bilé Moisesi galila, 'lige bilé Elíasi galila. ");
INSERT INTO tacNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Napu'lige Pegro bijí ra'icha ilígichi, bilé nolí rapame re'kínale 'pa rewigáchikana, 'lige 'ma na'pólale suwábaga. 'Lige bilé ra'íchame anile nolíralekana e'wele ra'íchame, pe Onorúgame nile, regá anile: ―Ye Esusi ne Inolá júkuru, asíriga galé ne. Asíriga ganíliga ajtí ne alué 'yuga. 'We a'lá gepuwa napu aní alué. ");
INSERT INTO tacNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","'Lige alué akigá wijchí ajkaná bi'tíbale alué bakiánika, pe asíriga charigá majale. ");
INSERT INTO tacNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","'Lige Esusi a'bé nawile 'lige nochale 'lige anele: ―Yati ku o'michísawa, tase majawa. ");
INSERT INTO tacNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Napu'lige e'nénale alué bakiá rió, 'ma tabilé 'wesi i'tele, pe Esúsicho. ");
INSERT INTO tacNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Napu'lige ku 'pákana rabókana e'yéniga Esusi 'we sulile napurigá tabilé 'wesi ruyémala alieti etéligo. Regá anele: ―Tabilé 'wesi ruyewa etéligo 'emi alué Moisesi 'lige Elíasi napusí alué Onorúgamete julárigame 'pa rewagáchika 'ma ku ajánisa, a'lige kulí ruyewa. ");
INSERT INTO tacNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","'Lige alué oyérameka rukele: ―¿Chonigá alué Moisesi nila nulalí benírimeka aniáníché Elíasi bajchá nawámili ko 'lige alué uché bilélaka napu Onorúgame julámili ju 'pa rewigáchika napurigá ralámuli gu'írimala, alueka nujubá nawámili ko? ");
INSERT INTO tacNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","'Lige Esúsika nejele: ―'We bijchiá ju Elíasi bajchá nawamio napurigá gatemio suwábaga. ");
INSERT INTO tacNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Neka aníguru Elíasika 'ma nawáligó, 'lige alué ra'íchali benírame pecha machígó. Tabilé machile, iligá 'we cha olale. Alué e'wélala jena wijchimoba mochígame jipe 'we resí olámalachigó alué 'pa rewigáchika julárigame napurigá rió neraga. ");
INSERT INTO tacNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","'Lige 'la machile alué Esusi 'yuga járome Juani olagá anió alué Esusi, alué Juani napu ralámuli rewarame nílige, Juánika níligo napurigá Elíasi. ");
INSERT INTO tacNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Napu'lige Esusi sebasa alué bakiá bo'né 'yuga járome 'yuga alé napu mochile we'ká ralámuli, 'lige bilé rió a'bé nawile Esusi, 'lige chojkóbisiga ilíbale alué rió alé o'wemi napu ilile Esusi, 'lige anele alué rió: ");
INSERT INTO tacNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Mué Wa'lula, pe rekó na'temápuaka ne inolá. Asíriga rekúpame ju, 'lige aminami asíriga resí níliga ajtime ju. I'sínimi 'ma na'ichí wijchime ju 'lige aminami ba'ichimi. ");
INSERT INTO tacNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Jena a'pigéturu ne napurigá sa'wámala alué mué oyérame, alueka tabiléchigo umébatigó sa'wá. ");
INSERT INTO tacNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","'Lige Esúsika anile: ―¡Tachiti ralámuli! ¿Tabilé bijchígime ju 'emi Onorúgame a'walí nígame ko napurigá 'la umbámala sa'wá? ¿Chekí rawé asiati káréko ne 'emi 'yuga napurigá 'emi 'we a'lá benimela? ¿Chiéniko si anachamio ne 'emi 'yuga? Jeka o'tobógó 'liko alué re'malí. ");
INSERT INTO tacNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","'Liko Esusi ne'óchale alué u'tabela remónisi 'lige ma'chínale alué u'tabela remónisi alué re'malichi, 'liko 'ma sa'wile alué re'malí, a'lige si tabilé uché rekúpale. ");
INSERT INTO tacNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","'Lige pe'tá i'libékorikáchi alué Esusi 'yuga járome Esusi si ra'íchale aminami, a'mibemi waná rukele: ―¿Chonigá tabilé umabárupeché ramué alué u'tabela remónisi ma'chí pa? ");
INSERT INTO tacNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","'Lige Esusi anele: ―'Émika tabilé bijchígame kanko 'la umébame ko ne ralámuli sa'wá. 'Emi rekó pe bijchígie 'la a'walí nígame ka Onorúgame, 'liko regá anesa 'emi bilé rabó: «Uchéchigo bilena ilibáwaká», 'la yati e'wámikuru alué rabó. ");
INSERT INTO tacNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Napu'lige Esusi alé Galilea anilichi ejiro asigá, anele alué Esusi alué bo'né 'yuga járome: ―Onorúgamete julárigame 'pa rewagáchika, alué cha nokame ralámulite cha'piboli ju. ");
INSERT INTO tacNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","'Lige 'ma me'liboli ju. 'Lige bakiá rawé kachi ku ajánamala. Napu'lige alué Esusi 'yuga járome akisá alué ra'íchali, asíriga seweka mochíbale. ");
INSERT INTO tacNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Napu'lige Esusi sebasa alué bo'né 'yuga járome 'yuga alé Kapernaumi anilichi we'ká riógichi, alué ralámuli napu enomí goblálome nile wa'lú re'obachi unélime Rusaleni ilígame re'obá, Pegro e'nemia simíbale, 'lige rukele: ―¿Pala najtétame júkó alué wa'lula mué benírame? ");
INSERT INTO tacNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","'Lige Pégroka nejele: ―Abiena. Napu'lige galírale sebasa, Esusi bajchá ra'íchale Pegro 'yuga, regá anele: ―Mué Simoni, ¿mueka chonígobá? ¿Chieri najtétamarágo enomí alué e'wélala nulame, napu jena wijchimoba mochí, a'boi 'kúchila gobláliga aní o uchéchigo jaré ralámuli? ");
INSERT INTO tacNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","―Uchéchigo jaré ralámuli ―anile Pegro. 'Lige anile Esusi: ―Kúchika pecha najtétimili júkó. ");
INSERT INTO tacNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Alarigá júkuru ramué 'yuga, ramueka Wa'lula O'nó Onorúgame 'kúchila nírukuru, ramueka pecha najtétilime júkó alué o'nó 'yuga. Jípeko abirigá najtétawaleké napurigá tabilé ayoga ejtebímala alué enomí goblálome. Alekeri 'mi ba'wí ilígichi simibógó benolí pamia, napu'lige mué ro'chí chewasa, alé alué ro'chí chu'álachi rewimela mué bilé enomí plata, 'lige ma'chí pápuaká, 'lige alué enomí goblálome 'yáwaká. Aluete 'ma suwábaga najtétarigime nímala, nétiri 'lige 'émitiri. ");
INSERT INTO tacNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","A'lígerikáchi alué Esusi 'yuga járome alemi a'bemi jábale napu asale Esusi 'lige regá anele: ―¿Chieri abé najtékame ju napu'lige Onorúgame nulachi ralámuli alawálachi? ");
INSERT INTO tacNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","'Lige Esúsika bayele bilé u'tá towí 'lige alé nasipa elale, 'lige regá anele alué bo'né 'yuga járome: ");
INSERT INTO tacNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","―Neka 'la bijchiá aníguru. Tabilé a'résaká 'emi gunarua, 'lige niwa napurigá ye u'tátiri napu tabilé riólame ju, 'liko 'emi tabilé siné elímala napurigá Onorúgame 'emi nulémala. ");
INSERT INTO tacNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Alué tabilé riólame alué 'nalina abé najtékame ju napu'lige Onorúgame nulachi ralámuli alawálachi. ");
INSERT INTO tacNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","'Emi 'la na'temaka eteme nísaká ye towí napu ne 'we na'temaka eté, 'liko 'la ne'chí oyérame nímala 'emi. ");
INSERT INTO tacNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","› Bilé rió resítiri 'nátili 'yame bilé ta towí kulí benime Onorúgame nila ra'íchali, abé 'la nímala ba'ichí rojkógachi pásiga wa'lú majtá golótiga. ");
INSERT INTO tacNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡'We sewékame ju ralámuli jena wijchimoba mochígame cha we'ká ralámuli mochígame 'we resí nokame, alué napu rejome ju uché jaré ralámuli napurigá oilámala resí nokiachi! ¡Alarigá ikimela, nobi 'we resítiri nímala alué rió uché jaré ralámuli oilárisa resítiri nochálichi! ");
INSERT INTO tacNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","› Bilé 'emi sekala o ronola kómá 'we resí nokisá, rejpúnaga 'lúpua 'lina. Abé a'lá ju rewagachi moinalia tpe bi'lepi sekega o pe bi'lepi ronega. Tabilé 'la nímala 'la okánika sekega, o okánika ronega simiá 'légana injiérnochi napu senibí rajá ilí. ");
INSERT INTO tacNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","'Lige bilé 'emi 'we chátiri na'tasa pe bilé tábiri etega, ma'chí pápua alué busí 'lige 'ma pápua, abé 'la nímala 'pa rewagachi simiá, napu'lige mukusuga pe bi'lepi busega. Tabilé 'la nímala 'la okánika busega simiá 'légana injiérnochi napu rajá ilí. ");
INSERT INTO tacNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","› Tase gawéliga etewa ye u'kuchítiri. Neka 'la bijchiá aní, alé 'pa rewagachi senibí tani mochí alué santo ánjeli Onorúgame, napurigá Onorúgame gu'írimala alué u'kuchítiri. ");
INSERT INTO tacNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Alué Onorúgamete julárigameka nawáligime 'la bowechi jawamia alué ralámuli 'we i'níliga e'yéname. ");
INSERT INTO tacNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","› ¿'Émika choniágó? Bilé rió bujkégame nisa bilé siento bo'á 'lige bilé bo'á we'kasa, ¿tacha yati simime júkó 'yamia alué bo'á we'kágame, alé jami a'resa alué gi makuesa makué na gi makué? ");
INSERT INTO tacNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","'Lige ku rewisá alué bo'á we'kágame, 'we ra'sáláme ju alué bo'á we'kágame etea, me'tigá alué bo'á tabilé we'kágame napu a'rele alé jami alué we'kágame 'yamia simea. ");
INSERT INTO tacNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","'Emi o'nola 'pa rewagachi ajtígame tabilé najkíchigó napurigá bilé u'kuchítiri we'kámala. ");
INSERT INTO tacNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","› Mué cha olásiga bilé riote napu Onorúgame oyérame korime ju, yati 'yuga ra'ichawa waná 'la bi'neli, 'lige 'we a'lá ruyewa bilé rejcholi napurigá 'la tabilé che 'sika inámala. 'Ma 'la tabilé che 'símorisáká 'liko 'ma neyúrigame kérélamala mué. ");
INSERT INTO tacNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","'Lige tabilé 'la nirásiká mué alué riote, 'liko oká ralámuli bayewa napurigá testigo nímala 'la rejcholi ruyéligo mué. ");
INSERT INTO tacNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","'Lige tabilé e'wísachigó alué oká ralámuli, 'liko ruyewa alué e'wélala re'obachi nóchame 'we cha olárigo mué alué riote, 'lige tabilé e'wasa alué rió rekó alué e'wélala 'la rejcholi ruyesa, 'liko a'rewa 'lige etewa napurigá bilé rió tabilé Onorúgame oyérame. ");
INSERT INTO tacNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","› Neka 'la bijchiá aníguru, Onorúgame 'we a'lá niramio napu 'emi nulé alué Onorúgame oyérame. ");
INSERT INTO tacNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","› Abiena regá ané ne, oká 'emi bi'lepi 'nátaga tánisa Onorúgame napurigá nejkúramala, 'liko ne O'nola Onorúgame, alué napu 'pa rewagachi ajtí, yati nejkúramala. ");
INSERT INTO tacNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Oká bakiami rió napuísaká bi'lepi 'nátili 'nátaga ne'chí 'yuga, 'liko ne alawala alé asimela napu napuíle alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","'Liko Pegro rukele Esusi: ―Mué Wa'lula, bilé rió Onorúgame oyérame abisibi cha olasa ne'chí, ¿chekisá e'kawa? ¿Gicháosa? ");
INSERT INTO tacNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","'Lige Esúsika anile: ―Neka pecha gicháosa anígó. Pe ikisá cha'sichi nabí e'kálime júkuru, 'lige aminami nabí 'we a'lá etélime júkuru rekó we'sá cha'sié. ");
INSERT INTO tacNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","› Ne bilé tétali ruwimela churigá ka napu'lige Onorúgame nulachi. Pe a'chigóriga ju napurigá bilé wa'lula rey goblálile alué bo'né 'yuga nóchame wikame. ");
INSERT INTO tacNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","'Lige júlale bilé wikame bayéniliga, 'lige bilé nawale alué abé we'ká miyoni wikame, ");
INSERT INTO tacNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","'lige alué rió tabilé enomígame nile napurigá najtétamala. Alekeri alué wa'lula rey nulale napurigá ralinewa alué rió 'ma mukí 'yúriga, 'lige 'ma 'kúchilatiri 'lige suwábaga napu ekí nígame nile. 'Lige alué enomika alué wa'lula rey o'ká rejpímili nile, alué enomite 'ma najtétirigime nímili nile alué nóchame wikalila, napu ekí wikame nílige alué nóchame. ");
INSERT INTO tacNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","'Liko alué nóchameka chojkóbisiga ilíbale alé a'bé alué wa'lula ajtígichi, 'lige anile amulí nalaka: «Muérigo wa'lula 'la na'temápua ne'chí, 'la i'libesi buwewa abiena 'la najtétamala ne suwábaga.» ");
INSERT INTO tacNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","'Liko alué wa'lula rey 'we na'tamale alué nóchame, 'liko 'ma tabilé goblálomoríle, 'liko 'ma tabilé najtétimili nile alué nóchame. 'Lige 'ma su'pánale. ");
INSERT INTO tacNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Napu'lige 'ma ma'chínasa alué rió napu 'we na'temáliru alué wa'lula reyte, alué rioka najtépale uché bilé rió nóchame napu alué rió wikeme nile 'lige gujtachí gamínale 'lige anele: «¡Yati najtétawa ne suwábaga napu ekí wiké mué ne'chí!» ");
INSERT INTO tacNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","'Liko alué rió chojkóbisiga ilíbale alé a'bé napu ilile alué napu na'temaka etéliru alué wa'lula reyte, 'lige anele: «'La na'temápua ne'chí 'la i'libesi buwewa, abiena 'la suwábaga najtétamala ne.» ");
INSERT INTO tacNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","'Lige alué napu 'we na'temaka etéliru alué wa'lula reyte tabilé najkile, iligá 'ma galírale bajchale, napusí najtétasa ma'chí pame olale. ");
INSERT INTO tacNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Napu'lige uché jaré nóchame akisá ala'síligo asíriga seweka mochíbale 'lige simíbale wa'lula rey e'nemia, 'lige suwábaga ruyele. ");
INSERT INTO tacNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","'Lige alué wa'lula reyka júlale bayéniliga alué nóchame napu 'la na'temaka etélige 'lige anele: «Mué cha'sime, neka 'la na'temaka etégituru mué 'lige, alekeri pe arigá a'rigéturu ne napurigá tabilé najtétimala mué. ");
INSERT INTO tacNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Muéchigó a'chigóriga na'temá télikuru alué nóchame 'yuga, a'chigóriga napurigá ne mué na'temake.» ");
INSERT INTO tacNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","'Lige wa'lula asíriga ayole. Nulale napurigá gastigáriwa napusí najteta suwábaga napu ekí wikame nílige. ");
INSERT INTO tacNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","'Liko Esusi 'ma guwárasa ye tétali ruwiyá, anile: ―O'nó Onorúgame 'pa rewagachi ajtígame, a'chigóriga gastigárimili júkuru 'emi, 'emi tabilé na'temásaká uché bilé Onorúgame oyérame. 'La e'kálime júkuru, 'lige uchéchigo siné ku 'la neraga etélime júkuru. ");
INSERT INTO tacNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Napu'lige alué Esusi 'ma suwénasa alué rejcholi ruyá, 'ma simile alé Galilea anilichi ejiro asigá, simile na'lebo 'nálige alé Jorani anilichi bakochi 'omi neraga napu ma'chíname ju rayénali. ");
INSERT INTO tacNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","'Lige we'ká ralámuli alemi guwánami simíbale, 'lige Esúsika alemi 'we 'yole nayúkame. ");
INSERT INTO tacNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","'Lige jaré bariseo jsile alemi napu Esusi asale 'lige rukele Esusi machináliga chonirá Esusi, se'wináriga nejésaká alué Esusi, 'liko nejimo lale. Regá rukele: ―¿Churigá aní ramué nila nulalí? ¿'La ju bilé mukí a'rilía 'ma newíkame níriga? ");
INSERT INTO tacNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","'Lige Esúsika regá rukele: ―¿Tacha leérame júkó 'emi alué osilí Onorúgame nila napu ruwime ju rió 'lige mukí newáligo pe kulí newá ralámuli jena wijchimoba? ");
INSERT INTO tacNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","'Lige alarigá rukesa, kúchigo regá anele Esusi alué bariseo: ―Alekeri regá anile Onorúgame, bilé rió 'ma a'rémili ko bo'né o'nola 'lige bo'né eyela, 'lige rewimeli ko bilé mukí 'lige okaka 'la bi'lepi 'nátili na'támili ko. ");
INSERT INTO tacNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Alésíko 'ma tabilé oká ralámuli neraga nímala, pe bi'lepi kárélamala. Onorúgame napubule, alekeri tabilé 'la ju rojanalia alué newíkame. ");
INSERT INTO tacNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","'Lige alué bariséoka anele: ―¿'Liko chonigá 'la anile ko alué Moisesi 'la ko napurigá bilé apeli newawa alé ra'íchali gatélichi ruwime 'ma a'réligo bo'né upila? ");
INSERT INTO tacNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","'Lige Esúsika anele: ―'Emi cháchigo resí nokagá járome kanko umugí a'regá 'lige uchéchigo bilé rewigá, alekeri Moisesi anile 'la ko pe bilé apeli newagá a'rilía bilé mukí. 'Ya chojkiná raweka tabiléchigo alarigá nílekó. Onorúgameka tabilé najkile napurigá rojámala. ");
INSERT INTO tacNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Neka regá aníbá: Bilé rió a'resa bo'né upila 'lige uché bilé mukí rewisá, alué alarigaka 'we resíriga ju. Abiena newisa uché bilé mukí a'rérigame 'yuga, abiénachigó wa'lú resítiri ju. Bilé rió rewisá bo'né upila se'nú rió 'yuga gojchichi, 'liko 'la ju a'rilía alué mukí, 'liko 'la ju uché bilé mukí 'yuga newilia. ");
INSERT INTO tacNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","'Lige alué Esusi 'yuga járome ka regá anele Esusi: ―Alarigá nísaká rió níriga, 'liko abé 'la ju tabilé newilia. ");
INSERT INTO tacNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","'Liko Esúsika anele alué bo'né 'yuga járome: ―Tabilé o'má ralámuli nama ye napu ne ruwimela, pe alué ralámulicho napu Onorúgame wanápule napurigá 'la námamala. ");
INSERT INTO tacNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Jaré rió o'chérame ju napurigá ga'libúrigame neraga. 'Lige jaré 'ma e'wele o'chérisa ga'libume ju uché jaré riote. 'Lige jaré tabilé newime ju Onorúgame nila nóchali nóchiga. 'La námapua ye 'la námame níriká. ");
INSERT INTO tacNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","'Lige alué we'ká ralámuli a'pile jaré u'kuchí 'kuchi Esusi alemi napu ilile, napurigá nochagá iwérali 'yámala alué u'kuchítiri 'kuchi, 'lige napurigá iwérali tánimala Onorúgame, 'lige alué makué oká rió Esusi 'yuga járomeka yati sulile napurigá tabilé a'pámala u'kuchítiri alé. ");
INSERT INTO tacNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","'Lige Esúsika anele: ―A'rewa napurigá alué u'kuchítiri jeka smela tase suliwa. Onorúgame nuleme ju sulachí alué ralámuli napu ju napurigá u'kuchí 'kuchi napu yati nareme ju napu'lige i'lía bilé tábiri. ");
INSERT INTO tacNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","'Lige alué Esusi alué u'kuchítiri nochagá tánale Onorúgame napurigá 'we a'lá repúmala alué u'kuchítiri 'kuchi, 'lige simile. ");
INSERT INTO tacNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","'Lige Esusi boichimi enágichi, alemi nápale bilé re'malí 'lige regá rukele: ―Mué benírame, ¿tachiri chu'simía 'we a'lá ju napurigá moinawa 'pa rewagachi alé asimea senibí? ");
INSERT INTO tacNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","'Lige Esúsika anele alué re'malí: ―Mueka, ¿chonigá rukéché mué tachiri 'la ko? Onorúgamecho ju 'we a'lá sébali olame. 'La moinánilisaká 'pa rewagachi mué, 'liko 'la sébali olawa napu nulale Moisesi 'we 'ya. ");
INSERT INTO tacNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","'Lige alué re'malika rukele: ―¿Tachiri nulálekó alué Moisesi? 'Lige Esúsika anele: ―Tase me'liboa ralámuli. Tase e'sena umugí 'yuga gojchiboa, pe mué bo'né upílacho 'yuga gojchiboa. Tase chigowa. Tase 'wesi ralámuli 'yuga 'yega ra'ichawa. ");
INSERT INTO tacNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","'We a'lá nirawa mué bo'né eyela 'lige mué bo'né o'nola. 'We a'lá niraga etewa apiépiri uché jaré ralámuli napurigá nirá mué bo'nepi. ");
INSERT INTO tacNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","'Lige alué re'malika nejele: ―Suwábaga alué 'la sébali olame ju ne 'yasi u'tá towí ka. ¿Tachiri chu'sílime rokáréko? ");
INSERT INTO tacNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","'Lige Esúsika regá anele: ―Ralinewa napu ekí tábiri ni mué, 'lige kógiwa alué enomí alué tabilé nígame, 'liko ne 'yuga einawa, a'liko a'kinana semati raweli narémala mué 'pa rewagachi. ");
INSERT INTO tacNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Alarigá anesa alué Esusi, alué re'malí 'we sewele, 'lige 'ma ku simile cháchigo we'ká i'karúgame nígame níligame. ");
INSERT INTO tacNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","'Liko Esusi anele alué bo'né 'yuga járome: ―Neka 'la bijchiá aníbá, 'we nóchali nímala bilé rió 'we nígame níriga sébali olá napurigá najkí Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","We'ká ralámuli 'we nígame, we'ká bujkégame akasí, chibátiri, bo'átiri, tabilé néléme ju Onorúgame, alekeri tabilé moinámili ju napu ajtí Onorúgame. Abé 'la néléme ju Onorúgame alué tabilé nígame. ");
INSERT INTO tacNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Alué Esusi 'yuga járome tabilé námale alieti akea, 'lige rukele: ―¿Chieri 'la rewagachi moinámala napu'lige mukusá? ");
INSERT INTO tacNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","'Lige Esúsika e'nénele 'lige anele: ―Bilé rió bo'né 'nátaga tabilé lisensia 'yame ju napurigá Onorúgamete nulewa, Onorúgameka 'la nejkúrime ju, alarigaka 'la sebawa rewagachi. Onorúgame níriká suwábaga tabilé nóchali kame ju. ");
INSERT INTO tacNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","'Liko alué Pégroka anele alué Esusi: ―Ramueka 'ma a'reru suwábaga tábiri napu nígame nírige ramué mué 'yuga e'yénimia. Alekeri tachiri nóchali 'yámala Onorúgame ramué 'pa rewagachi. ");
INSERT INTO tacNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","'Lige Esúsika anele: ―Neka 'we a'lá bijchiá aní, napu'lige jena wijchimoba ku 'we a'lá kachi, napu'lige alué napu Onorúgamete julárigame ju napurigá rió neraga 'ma chojkiasa nulá alé 'pa rewagachi, suwábaga 'emi abiena mochíbamalachigó alé makué oká e'wele síachi napu mochime ju alué e'wélala nulame. 'Lige alaké makué okaná síachi mochiga, nulámala 'emi alué makué okaná chojkégame ralámuli Israeli anilichi mochígame. ");
INSERT INTO tacNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Apiépiri rió napu a'rele bo'né galila, 'lige bonila, 'lige ba'chila, 'lige go'chila, 'lige waílatiri, 'lige o'nólatiri, 'lige eyélatiri, 'lige upila, 'lige 'kúchilatiri, ne'chí oyériniliga, alueka bilé siento uché rajpé 'yámala Onorúgame. 'Lige 'la 'pa rewagachi simela alé asimea senibí. ");
INSERT INTO tacNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","We'ká napu bajchá jánili, alueka pe guwana juláwili ju. 'Lige alué 'we guwana jágame ka, alueka 'mi bajchá juláwili ju. We'ká alué napu 'we nígame ju, alueka tabilé narémili ju semati raweli 'pa rewagachi, 'lige we'ká napu tabilé nígame ju jena wijchimoba, alueka 'we a'lá semati raweli narémili ju 'pa rewagachi. ");
INSERT INTO tacNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","› Napu'lige Onorúgame nulachi ralámuli alawálachi, pe a'chigóriga ju napurigá bilé rió we'ká i'wilí echágame, napu simile jaré nóchame owimia napurigá nochámala alué i'wilí echégichi. ");
INSERT INTO tacNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","'La gatele alué nóchame 'yuga, 'we a'lá najtétimoríle napu ekí meme nile bilé rió nóchaga bilé rawé, 'lige júlale alé i'wilí echégichi. ");
INSERT INTO tacNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Be'á, pe'wera rainasa, uchéchigo simile alé napu we'ká napuíme nile ralámuli, 'lige alemi etele uché jaré rió pe alemi mochíginti tabilé nocha. ");
INSERT INTO tacNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","'Lige anele: «'Émichigó simasi nochawa alé we'ká i'wilí echégichi, 'lige 'la sébali najtétimala ne», anele. 'Lige alué rioka yati simíbale nochamia. ");
INSERT INTO tacNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Alué i'wilí echágame 'ma rawilí uchéchigo simile alé napu we'ká ralámuli napuíme nile, 'lige 'ma abé aligítili uchéchigo simile alé napu we'ká ralámuli napuíme nílige, 'lige owile jaré rió napurigá simámala nochamia alé i'wilí echégichi. ");
INSERT INTO tacNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","'Lige 'ma abé alí, 'ma amulí rapagachi, uchéchigo simile alé we'ká rioga ilígichi nasípami, 'lige etele alemi uchéchigo jaré rió pe mochigo alemi tabilé nocha, 'lige rukele: «¿Chonigá pe jemi mochíripeché 'émika rukuchégame tabilé nóchaga?» ");
INSERT INTO tacNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","'Lige alué pe alemi mochígame rioka nejele: «Ramueka pe jemi mochiru pecha 'wesi rejome nochálichi», anile. 'Lige alué we'ká i'wilí echágame rió anele: «'Émichigó simáwaguru nochawa alé napu echá ne i'wilí, 'lige 'we a'lá najtétimala ne.» ");
INSERT INTO tacNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","› 'Lige napu'lige 'ma chonasa, alué rió alué we'ká i'wilí echágame regá anele alué nóchame nuleme: «Bayewa alué nóchame 'lige najtétiwaká, bajchá alué abé alí mo'ígame najtétiwa, 'lige kúchigo abé ta'mé alí mo'ígame, 'lige abé nujubaka alué be'á mo'ígame pe kulí rayénachi.» ");
INSERT INTO tacNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","'Lige alemi jsile alué rió napu 'ma alí mo'ile nochamia 'ma amulí rapagachi, 'lige rekó pe'wera nóchaga mele napu ekí meme nile bilé rió rukuchégame nóchaga. ");
INSERT INTO tacNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","'Lige alué be'á chojkime nocha pe kulí rayénachi, alué najtétiru, 'lige mayele abé we'ká memio me'tigá alué alí mo'ígame, 'lige pe alakí mele napu ekí mele alué 'we alí rapagachi chojkime. ");
INSERT INTO tacNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","'Lige alué be'á mo'ígame nocha 'ma najtétisiga chojkile ayonia alué echerúgime nígame, ");
INSERT INTO tacNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","regá anigá: «Ye ralámuli 'ma alí mo'ígame nocha asíriga 'la mékuru 'la napu ekí metu ramué napu 'la rukachégame nocharu 'we rajtáliga raminá.» ");
INSERT INTO tacNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","'Liko alué echerúgime nígame regá anele alué bilé ayome rió: «Mué rió, neka tase gaweli mué, neka tase abé u'kabi najtétiniliga 'smi mué, neka 'la sébali najteti mué napu ekí najtétimiorié ne mué, ¿tacha 'la ra'ichárukó bajchá pe bilé rawé nochárigime najtétimio ne? ");
INSERT INTO tacNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Yati nareki napu ekí mele mué 'lige yati ku simiboa. Neka abiena pe alakí najtétima olá ne alué napu abé alí chojkile nocha, a'chigó ekí napu ekí mele 'emi. ");
INSERT INTO tacNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Tacha 'la júkó napurigá najtétimala ne napurigá ne bo'né najkí?, napugiti ye enomika pe ne nila kame. O ¿'wéchala enowéliru ala'sichi ne, 'we a'lá najtétichi ne, neka 'wéchigo a'lá sébali olame rió kame?» ");
INSERT INTO tacNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Alarigá alué ralámuli napu 'nátame ju 'we najtékame ko me'tigá uché jaré ralámuli, machimela tabilé najtékame ko, 'lige alué napu 'la machime ju tabilé najtékame ko, alueka machimela 'we najtékame ko ―anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Boichimi 'yéniga Rusaleni simiba, 'lige alué Esúsika waná bayele alué makué oká Esusi 'yuga járome, 'lige regá anele: ");
INSERT INTO tacNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―'La gepúsibá, ya 'ma simawa alé 'pa rabó alé Rusaleni anilichi. Ramueka 'a e'nárukuru Rusaleni simiba. Alué napu Onorúgamete julárigame ju 'pa rewagáchika 'ma cha'piboli ju, 'lige 'ma o'toboli ju alé napu mochí alué e'wélala wa'lú re'obachi nulame 'lige alué Moisesi nila nulalí benírame. Alueka animela me'liáté alué rió, ");
INSERT INTO tacNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","'lige 'ma o'tomela e'sena ralámuli mochígichi napurigá me'liboa. 'Lige ta'chó me'á, alué sontalo 'we gawélimala 'lige a'kachípamala 'lige wejpisópua, 'lige gulusichi ujchagá me'liboa, 'lige pe bakiá rawé kachi ku ajánamala ―anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","A'lige alué Sebereo 'kúchila eyela nawale alemi alué Sebereo 'kúchila 'yuga, 'lige alemi sébaga yati chojkóbaka ilíbale o'wemi Esusi ilígichi 'lige tánale napurigá bilé nóchali 'yawa alué ejtemali. ");
INSERT INTO tacNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","'Lige Esúsika anele: ―¿Tachiri nóchali i'lime najkí mué alué ejtemali? 'Lige alué mukika anele: ―Napu'lige 'ma chojkichi nulá mué 'pa rewagachi, nuláwaká napurigá ye oká ejtemali ne 'kúchila mochímala alé mué 'yuga, bilé o'iná 'lige bilé wajtoná. ");
INSERT INTO tacNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","'Liko Esúsika anele: ―Tabilé machí mué napu najkí. ¿'La anachámala 'emi resí nilia napurigá ne? 'Lige alué ejtemálika anele: ―Aka 'lágurú. ");
INSERT INTO tacNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","―'La bijchiá ju 'emi 'we resí nílamala napurigá ne ―anele Esusi― iligá tabilé ne 'símala mochía alé napu ne asimela alé a'naguka. Onorúgame bo'né 'la machí chieri mochiamia alé a'naguka napu ne asimela nulá. ");
INSERT INTO tacNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Napu'lige alué oká rijimá alanichi, akele alué uché jaré makué rió Esusi 'yuga járome, 'lige 'we na'áwale alué oká rió 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","'Liko Esúsika bayele alué makué oká rió bo'né 'yuga járome, 'lige anele: ―Alué e'wélala rey napu nuleme ju ralámuli tabilé bijchígame Onorúgame ra'ichálila, alueka 'we nochárime ju alué ralámuli napurigá ajágame neraga. ");
INSERT INTO tacNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","'Emi e'wélala nínilisaká, tabilé alarigá nokimeli ju 'emi, bajchá 'we a'lá gu'írimili júkuru ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Alué napu wa'lula nínili, bajchá pe nóchame niraga nímili júkuru, 'lige aminami tabilé gunarume nímili júkuru. ");
INSERT INTO tacNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nímili ju napurigá alué 'pa rewagáchika julárigame Onorúgamete napurigá rió neraga. Tase nawale napurigá gu'íriwa ralámulite, alueka iligá nawale gu'írimia ralámuli, 'lige mukumea we'ká ralámuli gu'íriga. ");
INSERT INTO tacNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Napu'lige alué Esusi 'lige alué 'yuga járome 'ma simasa alé Jerikó anilichi mochiga, we'ká ralámuli najátale. ");
INSERT INTO tacNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","'Lige oká rió tabilé ma'chílime mochile alé boichimi, 'lige akisá alemi enegó Esusi, yati chojkile ra'icha, regá anea: ―¡Muérigo Wa'lula Nulame Rabí rijimala, 'we a'lá na'temápua ramué! ");
INSERT INTO tacNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","'Lige ralámuli alemi si e'yénigime sulile alanichi alué oká rió tabilé ma'chílime, 'lige alué oká rioka aminabi abé a'wágame bayea mochile: ―¡Muérigo Wa'lula Nulame Rabí rijimala, pe rekó 'we na'temápua ramué! ");
INSERT INTO tacNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","'Lige alué Esúsika ilíbale 'lige bayele alué tabilé ma'chílime, 'lige anele: ―¿Tachiri choliame najkígó 'emi? ");
INSERT INTO tacNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","'Lige alué tabilé ma'chílimeka anile: ―Mué Wa'lula Nulame, ramueka najkiá napurigá ku 'la ma'chílime gainámala ramué busila. ");
INSERT INTO tacNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","'Liko Esúsika 'we na'temale, 'lige nochale busila, 'lige pe yati 'ma ku 'la ma'chílile alué oká rió tabilé ma'chílime, 'lige Esusi 'yuga simíbale alué oká rió. ");
INSERT INTO tacNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Napu'lige 'ma a'mulipi e'yéniga amulí seba Rusaleni rewégichi, sébale alé bilena a'bé Be'tagé rewégichi, Olibo anilichi rabó re'leberi. Alé sebasa Esusi júlale oká alué bo'né 'yuga járome, ");
INSERT INTO tacNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","'lige anele: ―Simíbaga 'mi alé riógachi, 'mi alé napu ma'chigá ju, 'lige alé riógichi sebasa 'emi, etémala 'emi bilé bulito mukila chériga chujkúgame bilé u'tá bulito ranégame. Su'panasa, jeka a'páwaká alué bulito mukila 'ma alué ranala 'yúriga. ");
INSERT INTO tacNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","'Lige bilé rió rukisá chonigá su'panalio alué bulito, yati anewa: «Alué Wa'lula Esusi najkí napurigá tanewa ye bulito, pe yati ku rolonawa ramué», anewa ―anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Alarigá ikile napurigá 'la sébali ikimela napurigá anílige 'we 'ya alué rió napu ruyame nílige napu anélige Onorúgame, napu'lige regá anile: ");
INSERT INTO tacNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Regá anéwaká alué Sioni (Rusaleni) ejperégame ralámuli: «'Emi ralámuli, alué wa'lula rey napu 'emi nuleme ju, aleka ená, 'we a'lá i'kilí tabilé che anisia, bilé bulito ranala asigá.›› ");
INSERT INTO tacNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","'Liko alué Esusi 'yuga járome yati simíbale 'lige alarigá sébali olale napurigá nulélige Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Yati a'pale alué bulito mukila 'lige alué bulito ranala 'yúriga, 'lige alué okánika bulito pérale alué Esusi 'yuga járome alué a'boi gemala chiní i'weli, 'lige alué Esúsika yati asele bulito ranala, napu tabilé siné asérigame nile. ");
INSERT INTO tacNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","'Lige suwábaga ralámuli napu we'ká nile, alemi wijchí pesia e'yénale alué chiní i'weli a'boi gemala alemi boichimi, 'lige jaréchigo rajkú sawala ro'asia e'yénale boichimi. ");
INSERT INTO tacNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","'Lige suwábaga ralámuli guwánami e'yénigime 'lige bajchabemi e'yénigime 'we ra'sálásia e'yénale regá anisia: ―¡Hosana (salva)! ¡'La sébakuru mué jena! ¡Mué Esusi Rabí rijimala, mueka wa'lula nímala napurigá alué wa'lula Rabí anilime 'ya ajtígame! ¡'We a'lá semáriga nulale alué, alarigá nulámala mué! ¡Hosana! ¡'Láchigo sébakuru mué jena! ");
INSERT INTO tacNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Napu'lige alué Esusi 'ma sebasa alé Rusaleni rewégichi we'ká riógichi, ralámulika majale 'lige anile: ―¿Chieri júché ye rió? ");
INSERT INTO tacNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","'Lige we'ká ralámuli anile: ―Ye rioka pe ju Esusi, napu ruyame ju napu ané Onorúgame, alé Nasareta ejiro Galilea bejtégame. ");
INSERT INTO tacNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","'Lige bajkile Esusi alé wa'lú re'obachi ra'pichí Onorúgame galílachi, 'lige 'ma mabule suwábaga napu ralineme nile, 'lige napu ralame nile alé pachá re'obachi ra'pichí mochiga, 'lige 'ma re'nubuga 'lule suwábaga mesa napu enomí nakulílichi nile, 'lige 'ma re'nubule alué banko napu jale alué wakali chulugí baloma ralinélime. ");
INSERT INTO tacNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","'Lige regá anele: ―Aka osiruga chujkúché osilichi: «Ne galílaká Onorúgame 'yuga ra'ichálime júkuru», 'lige 'émika chigórigame resola newálekuru. ");
INSERT INTO tacNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","'Lige jsile alemi alé Esusi ilírachi tabilé ma'chílime ralámuli 'lige jaré na'lime, 'lige yati sa'wale Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","'Lige alué e'wélala balé 'lige alué Moisesi nila nulalí benírame ralámuli etele alué Esusi 'we a'lá sa'wáligo alué nayúkame, 'lige aminami akele alué u'kuchí ejtemali regá anichi: ―¡Hosana! ¡'La sébakuru mué jena! ¡Mué Esusi Rabí rijimala, mueka wa'lula nímala napurigá alué Wa'lula Rabí anilime 'ya ajtígame! Alieti akisá, 'we ayole alué e'wélala balé 'lige alué Moisesi nila nulalí benírame, ");
INSERT INTO tacNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","'lige regá anéliru Esusi: ―Mué Esusi, ¿'la aké mué alaniá jago alué ralámuli? 'Lige Esúsika anele: ―Ju, 'la aké ne. ¿Tabilecha siné leera 'emi Onorúgame nila ra'íchalichi napu aní: Alué u'kuchítiri 'kuchi bijí chi'ime chu'álachika ma'chínamala Onorúgame wikala? ");
INSERT INTO tacNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","'Lige alemi a'rigá alué ralámuli, 'ma simile alé we'ká riógachi asigá, Betania anilichi simile 'lige alé che'lébale. ");
INSERT INTO tacNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Melénala rawé ku Rusaleni simiá enale Esusi, e'lowile. ");
INSERT INTO tacNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","'Lige etele bilé chuná 'lige simile e'nemia 'lige etele tabilé pe'tá rakégame ko alué chuná, pe sawálacho, we'ká sawégame rewale, 'lige anele alué chuná: ―¡Tabilé siné go'mela ralámuli mué chuná rakala, 'máchigo ta siné rakémempá mué! ―anele. 'Lige pe yati wakíbale alué chuná. ");
INSERT INTO tacNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Alieti etega alué Esusi 'yuga járome tabilé námaka regá anile: ―¿Churigá 'la wakíbalaché pe yati pe alanésiga alué chuná? ");
INSERT INTO tacNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","'Lige Esúsika regá anele: ―'La bijchiá ruwí ne, 'we a'lá bijchígime nísaká 'emi wa'lú a'walí nígame ko Onorúgame, pecha pe bilé chuná wakebáchimiko 'emi, 'émika 'la umabámikuru 'mimi wa'lú ba'wí manígichi elá ye wa'lú rabó pe regá anegá: «Se'wí iliboa, iliboa alé nasipa wa'lú ba'wí ilígichi», 'lige yati e'wámikuru ye rabó. ");
INSERT INTO tacNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","'We a'lá bijchígiga tánisa 'emi Onorúgame, 'liko suwábaga napu tani 'emi, Onorúgame 'we a'lá nejímala. ");
INSERT INTO tacNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Napu'lige alé ra'pichí wa'lú re'obachi bajkisá alué Esusi, 'lige alemi ilígichi alué Esusi ralámuli beniria, yati alemi jsile alué e'wélala balé 'lige alué jurío ralámuli nuleme, 'lige anele: ―¿Tachiri gite buyánaché mueka alué ralámuli alé wa'lú re'obachi ra'pichí mochígame ralinea? ¿Chiérite ajchárigame júkó mué Wa'lula neraga? ¿Tachiri najtékame nóchali nígame júkó mué 'siá? ");
INSERT INTO tacNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","'Lige Esúsika anele: ―Ne abichigó rukémala bilé ra'íchali, 'lige 'la ma'chígime nejiásaká 'emi, ne 'la ruwimela chonigá tachiri gite buyánigo ne ralámuli jena ra'pichí mochígame ralinea. ");
INSERT INTO tacNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Chieri júlale Juani ralámuli rewarániliga, Onorúgame chalá o ralámuli chalá? 'Lige alué e'wélala balé 'lige alué jurío ralámuli nuleme a'bopi rukele, regá anile: ―Onorúgame júlale anisúká 'liko animela alué Esusi: «¿'Lige chonigá ta bijchígirupaché 'emi napu anié Juani?» anile. ");
INSERT INTO tacNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","'Lige anésiká pe ralámuli júlaligo alué Juani, 'liko pe majá mochiwa ralámuli, siné kachi pe ramué saíla niraga mochíbamala ralámuli, napugiti suwábaga ralámuli 'we a'lá machigá mochígame Juani ruwime níligo napu anele Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","'Liko pe regá anile: ―Tabilé machirú'é chiérite julárigame níligo alué Juani. 'Liko alué Esusi anélechigó: ―Néchigó tabilé ruwimela tachiri gite buyánigo ne suwábaga ralámuli jena ye ra'pichí wa'lú re'obachi mochígame ralinea. ");
INSERT INTO tacNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","› 'Émika ¿choniágó? Bilé rió oká 'kúchigame nile, 'lige alemi a'bemi simigá napu ajtile alué bilé, regá anele: «Simigá mué jipe nochawa alé we'ká i'wilí echégichi.» ");
INSERT INTO tacNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","'Lige alué towika anile: «¡Tabilé siminali ne!» Nobi 'wéchigo cha lálekó alanisá 'lige pe'tá i'libeko yati simile nochamia. ");
INSERT INTO tacNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","'Lige alué rió o'ká 'kúchigame a'bemi simigá napu ajtile alué uché bilela, 'lige a'chigóriga anélechigó napurigá anélige alué uché bilela, 'lige alueka regá nejele: «'La ju, kulipi simé ne.» Tabiléchigo simílekó. ");
INSERT INTO tacNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Chieri 'nalina 'la e'wálekobá napu o'nola nulele? 'Liko alué e'wélala balé 'lige jurío ralámuli nuleme regá anile: ―Alué bajchá nulérimeguru. 'Lige Esúsika anile: ―Neka 'la bijchiá aníbá, alué enomí goblálome 'lige alué we'ká rió 'yuga okome umugí, alueka bajchá 'la lisensia 'yámala napurigá Onorúgamete nulewa alawálachi, tase napurigá 'emi, ");
INSERT INTO tacNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","napugiti 'émika tabilé bijchígiligame 'la rejcholi ruwichi alué Juani 'la o'wé jawamia ralámuli, 'lige alué enomí goblálome 'lige alué we'ká rió 'yuga okome umugí 'we a'lá bijchígile rejcholi nejichi alué Juani, 'lige rekó 'emi 'la etege suwágaba yeti, tabilé pe'tá ku guwana 'nátalekuru. ");
INSERT INTO tacNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","› Gepúsibá uché bilé tétali: Bilé rió we'lé nígame wajsá. We'ká banawá jáwale i'wilí anilime, 'lige 'we a'lá 'yele, 'lige jole bilénami i'pichí alé me'chomia alué i'wilí rakala, napu'lige rakesa alué ba'wila ma'chí pamia, 'lige newale bilé galí re'pá ilígame napurigá alué tebume alé asigá repúmala alué we'ká banawá i'wilí. › 'Lige owile repúniliga jaré rió alé nóchame, 'lige bo'neka simile bilénami mejkami. ");
INSERT INTO tacNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Napu'lige sebasa rawé i'wíliame, alué gawígameka 'naka júlale jaré bo'né piónila napurigá rojanámala nasípasi, 'yamia napu ekí mélapá alué repume. ");
INSERT INTO tacNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Alué tebuka mochígameka tabilé rojanánile 'lige 'ma cha'píliru alué gawígame piónila alemi jsichi. Bilé 'ma cho'náliru, 'lige uché bilela ka 'ma me'áliru, 'lige uché bilela ka 'ma bajsibúliru. ");
INSERT INTO tacNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","'Lige alué gawígame ka uchéchigo jaré bo'né piónila júlale, 'lige alué banawá rakeme repume ka a'chigóriga olale napurigá alué bajchá julárigame pioni. ");
INSERT INTO tacNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","› 'Lige 'ma guwichímiká bo'né inolá júlale alué gawígame regá 'nátaga: «Ne inolaka 'la niraga etéwarékó.» ");
INSERT INTO tacNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","'Lige alué banawá tebume ka, napu'lige etesa alué gawígame inolá, regá anile a'bopi: «Alué bi'lepi júkuru alué rió gawígame inolá, 'lige alué júkuru alué o'nola nila nachuámili napu'lige o'nola mukusá, alekeri me'liboa. Alarigá 'la ramué niga ejtebiwa ye gawí o'nola mukusá», anile. ");
INSERT INTO tacNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","'Lige cha'pisá 'ma me'ale 'lige i'rachi ma'chige pale. ");
INSERT INTO tacNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","› Napu'lige nawasa alué gawígame, ¿cholámalawé alué banawá repume? ");
INSERT INTO tacNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","'Liko alué e'wélala balé 'lige alué jurío ralámuli nuleme anele Esusi: ―Alué 'we ená nokágame ka 'ma me'liboli ju tabilé na'temaka, 'lige uché jaré 'yámala repúniliga alué we'ká banawá jágame, 'lige alueka 'la rojanámala alué banawá rakala napu'lige 'ma rakesa. ");
INSERT INTO tacNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","'Lige Esúsika anile: ―¿Tabilé siné leérame ju 'emi osilí Onorúgame nila?, alé napu anime ju: Bilé rejté tabilé galegá etérigame alué galí newame ralámulite tabilé machime nile 'we a'lá ko alué rejté chijtochi ajchilía. 'Lige alué rejté abé a'lá nile alé chijtochi ajchalía. Onorúgame bo'né alarigá elale. Napu Onorúgame 'sile newá 'we a'lá semátiri ju ramué níriga. ");
INSERT INTO tacNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","› Neka 'we a'lá bijchiá aníbá Onorúgame 'ma tabilé nulamio 'emi alawálachi, 'lige alué Onorúgame nulémala uché jaré ralámuli napu 'we a'lá e'wímili ju Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","'Lige napiépiri rió alé rejtechi bo'ibasa, 'ma chi'wámala. 'Lige bilé rió me'táchisa alué rejtete, 'ma chi'laga rejpímala. ");
INSERT INTO tacNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","'Lige alué ra'íchali akigá alué e'wélala balé 'lige alué ralámuli bariseo, machile pe alué olagá aníligo alué Esusi alieti ra'íchaga. ");
INSERT INTO tacNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","'Liko alué e'wélala balé 'lige alué bariseo 'we cha'pinálile alué Esusi, pe iligá 'we majale cha'pigá, 'wéchigo 'la bijchígilime suwábaga ralámuli 'la Onorúgame ra'ichálila nareme níligo Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","'Lige Esúsika uchéchigo siné ruwile bilé tétali, regá anile: ");
INSERT INTO tacNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Napu'lige Onorúgame nulachi ralámuli alawálachi, a'chigóriga ju napurigá napu'lige bilé wa'lula rey napu wa'lú piesta newile bo'né inolá newichi. ");
INSERT INTO tacNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Júlale bo'né 'yuga nóchame bayéniliga we'ká ralámuli napurigá smela go'mea, napu 'ma bayérigame nílige, 'lige alué bayérigame tabilé simánili alué newigime nerúgichi go'ame go'mea. ");
INSERT INTO tacNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","'Liko alué newime o'nólaka júlale uchéchigo jaré bo'né 'yuga nóchame napurigá regá anémala alué 'ma bayérigame: «Ruyéwaká alué ralámuli napu 'ma baigé ne 'yabé 'ma newáriga iligó go'ame, nuligó ne me'línaliga akasí 'lige ajágame abé 'la sa'pégame 'lige suwábaga 'ma 'la listo iligó, yati bayewa napurigá jeka smela go'ame go'mea.» ");
INSERT INTO tacNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","'Lige alué napu 'ma bayérigame nílige go'ame go'achi tabilé simíbale go'ame go'mea alé newigime nerúgichi, jaré pe 'mi wasá bo'ígichi simíbale nochamia 'lige jaré pe che jarénami simíbale nochamia, ");
INSERT INTO tacNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","'lige jaréchigo napu tabilé simánale alé newigime nerúgichi 'ma cha'pile alué wa'lula rey 'yuga nóchame, 'lige 'we resí oláliru 'lige me'áliru. ");
INSERT INTO tacNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","'Liko alué newime o'nólaka napu wa'lula rey nile, 'we ayole machisá 'ma me'lílirigo alué ralámuli julárigame alué ralámuli bayéniliga, 'lige júlale bo'né sontálola napurigá me'limela alué ralámuli cha nokame, napu 'ma me'ale alué wa'lula reyte julárigame, 'lige 'ma me'líliru alué cha nokame 'lige 'ma e'kósiliru suwábaga galí. ");
INSERT INTO tacNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","'Liko alué wa'lula rey alué newime re'malí o'nola anele alué bo'né piónila napu mochile alemi, regá anele: «Go'ámeka 'ma listo ilí, iligá alué napu bayérigame nílige, alueka tabilé simánili, 'ma tabilé lisensia nígame ju napurigá smela. ");
INSERT INTO tacNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Alekeri yati simawa alé napu e'yéname ju ralámuli, 'lige apiépiri ralámuli napu eteru alemi bayéwaká napurigá smela go'ame go'mea jena newigíme nerúgichi.» ");
INSERT INTO tacNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","'Lige alué wa'lula rey piónila ka simíbale alemi napu napuíme ju ralámuli 'lige yati bayele suwábaga napu ekí najtépale alemi, napurigá simámala go'ame go'mea alé newigime nerúgichi, alarigá 'la we'ká ralámuli jsile alé alué re'malí newichi, suwábaga 'la go'ale alué go'ame. ");
INSERT INTO tacNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","› 'Lige alemi bajkile alué wa'lula rey alué newime re'malí o'nola, napu go'yá mochile alué ralámuli bayérigame newíkichi, 'lige etele bilé rió tabilé o'páchigime alué o'pacha napu o'páchaga simiame nile bilénami newigime nerúgichi. ");
INSERT INTO tacNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","'Lige regá anele alué rió: «Mué rió, ¿churigá 'la bajkíché mué jena peka o'páchaga nawasa napu o'páchaga nawilime ju bilé newigime nerúgichi?» 'Lige alué rioka tabilé pe'tá nejele rukilía. ");
INSERT INTO tacNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","'Liko alué wa'lula reyka anele alué napu go'ame ro'ame nile: «Ronola bulesi ye rió 'ma sekala 'yúriga, 'lige alé ma'chige pápua chonárale napu nalámala resí níliga 'lige napu chi'namela ramalá majaga.» ");
INSERT INTO tacNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","We'káchigo kame bayérigame 'lige u'kabi ju napu 'la sébame ju alé newigime nerúgichi. ");
INSERT INTO tacNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","A'lige pe'tá i'libeko alué bariseo simíbale alué Esusi rukemia jaré ra'íchali pe machináliga chonirá. Se'winá anisáká yati cha'pibó olale. ");
INSERT INTO tacNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","'Lige alué bariseo júlale jaré a'boi gompaniérola 'lige alué wa'lula Erore gompaniérola napurigá regá anémala alué Esusi: ―Mué Esusi, ramueka 'we a'lá machiaa 'we a'lá ganílime ko mué 'la o'wé ra'íchiga tase 'yégiga, 'lige 'we a'lá benírame ko mué churigá ka alué 'we a'lala bowé. 'Lige 'we a'lá machiaa ramué mué 'la niraga eteme ko ralámuli, rekó e'wélala kachi 'lige rekó pioni kachi. ");
INSERT INTO tacNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Alekeri najkiá napurigá ruwimela mué: ¿Pala 'la ju nejilia alué enomí napu nejílime ju alué wa'lula rey Sesar i'lime? ¿Tabiléchala? ");
INSERT INTO tacNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Alué Esúsika 'we a'lá machile pe resítiri 'nátaga aníligo alué ralámuli, machile pe Esusi resí olániliga aníligo, 'lige anile Esusi: ―¿Chonigá alaníbiché 'émika pe resí olániliga ne'chí? 'Émika 'we a'lá ra'íchame ju pe iligá chátiri 'nátame júkó. ");
INSERT INTO tacNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Aka jeka a'pásigo bilé enomí chijtúligame napu najtétiwili ju alué wa'lula rey. ");
INSERT INTO tacNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","'Lige Esúsika anele alué bariseo 'lige alué Erore gompaniérola: ―¿Chieri mo'ola ju ye mo'ó jena enomichi ajtígame, 'lige chieri rewalá chujkú ye enomichi? ");
INSERT INTO tacNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","'Lige alué bariseo 'lige alué Erore gompaniérola anele: ―Aka alué wa'lula rey Sesar anilime. 'Lige Esúsika anile: ―Napu alué wa'lula Sesar nila ju, alueka alué wa'lula Sesar 'yáwaguru, 'lige alué napu Onorúgame nila ju, alueka Onorúgame 'yáwaguru ―anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Alieti akigá tabilé machile churigá nejemia 'lige simíbale, tabilé che olale. ");
INSERT INTO tacNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Pe a'lige rawé alué saruseo anilime ralámuli, alué napu anime ju tabilé sébame ko rewagachi alué suwígame alawala, Esusi 'yuga ra'íchale, regá anele: ");
INSERT INTO tacNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Mué Esusi, ralámuli benírame. Moisesi a'rele bilé osilí regá anime 'we 'ya: Bilé rió mukusá 'lige bi'neli rejpisa mukí tabilé 'cho 'wesi 'kúchiga, alué mukúgame bonila rewimeli ju alué mukí napurigá 'kúchigame nímala alué mukí gunámakame, alué mukúgame bonila 'yuga asigá, 'lige alué mukúgame bonila 'kúchila o'chérisa napurigá alué mukúgame 'kúchila kárélamala ―anile alué ralámuli saruseo. 'Lige abiena regá anele: ");
INSERT INTO tacNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","―Sinéchigo mochile gichao ejtemali bi'lepi o'nógame, 'lige alué wa'lula ba'chila rewale sineko, 'lige mukule ba'chila tabilé 'cho 'wesi 'kúchiga, 'lige alué abé u'tabela alué chega bonila rewale alué mukí gunámakame, 'lige 'ma mukúlechigó tabilé 'cho 'wesi 'kúchiga. ");
INSERT INTO tacNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","'Lige alarigá ikile alué u'tabela 'lige alué abé u'tabélachigó, 'lige alarigá suwile suwábaga a'boi najarémala. ");
INSERT INTO tacNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Alué gichao rió suwírisa, mukule alué mukí gunámakame. ");
INSERT INTO tacNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","'Lige alarigá anesa, kúchigo regá rukéliru Esusi: ―Napu'lige alé rewagachi sebasa alué gichao ejtemali 'lige alué mukí aleka, ¿chieri 'nalina upila nímalawé alué mukí? Jena wijchimóbaka suwábaga gichao ejtemali upila níligame. ");
INSERT INTO tacNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","'Liko Esúsika regá anele alué ralámuli: ―'Émika tabilé machigá mochí. Tabilé machí 'emi Onorúgame nila ra'íchali, nibilé machí 'emi churigá ko Onorúgame a'walila. ");
INSERT INTO tacNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Alué napu ekí seba rewagachi, nibilé umugí nibilé riótiri newímala, aleka suwábaga ralámuli napurigá santo ánjeli rewagachi mochígame nímala. ");
INSERT INTO tacNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Aka alué bo'né Moisesi osálige'é pe u'kabi osilí, napu Onorúgame anílige napu ruwí rewagachi simíbame ko alué ralámuli suwisá. ¿Tabilé siné leérame ju 'emi alué ra'íchali? Anime ju: ");
INSERT INTO tacNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","«Ne ju Onorúgame napu Abraámi, Isaki 'lige Akobo oyérame ju.» Onorúgame níriká tabilé 'wesi suwígame kéré, suwábaga ajágame ju. ");
INSERT INTO tacNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Alieti ra'íchali akisá, we'ká 'nátale alué ralámuli, aliena 'la benigá ruwichi alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","'Liko alué bariseo abé i'libeko kachi akele 'we a'lá benigá nejéligo alué Esusi, 'lige tabilé aminabi ra'íchiga jábigo alué ralámuli saruseo, 'liko alué bariséoka napuíle o'maka 'lige simíbale napu ajtile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","'Lige bilé rió napu Moisesi nila nulalí benírame nile, regá rukele alué Esusi pecha olániliga se'winá anisáká: ");
INSERT INTO tacNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Mué Esusi, benírame ralámuli Onorúgame nila ra'íchali, ¿tachiri júkó alué nulalí rejcholi 'we najtékame? ");
INSERT INTO tacNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","'Lige Esúsika nejele: ―'We galewa Onorúgame, 'la bi'lepi 'nátili 'nátiga. ");
INSERT INTO tacNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Alué ju abé najtékame nulalí rejcholi. ");
INSERT INTO tacNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","'Lige alué uché bilé nulalí rejcholi regá anime ju: «Napurigá galé 'emi a'boi alawala, alarigá galewa uché jaré ralámuli.» ");
INSERT INTO tacNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","'We a'lá sébali e'wásaká 'emi ye oká nulalí rejcholi 'we najtékame, 'liko 'we a'lá sébali olámala 'emi suwábaga alué uché jaré nulalí rejcholi napu osale Moisesi, 'lige uché jaré napu ruyame ju napu ané Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Napu'lige napuíka mochígichi alué bariseo, Esusi regá rukele alué bariseo: ");
INSERT INTO tacNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―'Émika ¿choniágó, chieri koriágó alué Kristo? ¿Chieri rijimala korí 'emi alué? 'Lige alué bariséoka anile: ―Pe Rabí. ");
INSERT INTO tacNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","'Lige Esúsika anile: ―¿'Lige chonigá wa'lula aneme júché alué Rabí alué Kristo olagá? Onorúgame Alawala gu'írale napurigá animela regá: ");
INSERT INTO tacNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Onorúgame anele alué Wa'lula Kristo ne'chí nuleme: «Jena asá wajtoná napusí neyuro ne mué saíla 'yuga.» ");
INSERT INTO tacNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Aka alué bo'né Rabí aneme ju «ne'chí nuleme» alué Kristo, 'liko abéchigo najtékame júleké alué Kristo me'tigá alué Rabí. ");
INSERT INTO tacNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","'Lige tabilé 'wesi ralámuli 'la gayénale nejea, 'lige aleké rawé si tabilé 'wesi e'wérali olale rukea aminabi ra'íchali. ");
INSERT INTO tacNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pe'tá i'libeko Esusi ra'íchale alué we'ká ralámuli 'yuga 'lige alué bo'né 'yuga járome, regá anele: ");
INSERT INTO tacNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Alué ralámuli Moisesi nila nulalí benírame 'lige alué bariseo, alueka abé machí churigá ko alué Moisesi nila nulalí. ");
INSERT INTO tacNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","'Émika 'we 'la e'wiwa tabiri tábiri napu nulá, pe iligá tase alarigá nokiboa, napurigá nokame ju alué bariseo, 'lige alué Moisesi nila nulalí benírame, napugiti alueka regá anime kame: «Jípeko regá nochátékuru.» 'Lige pe se'wináriga nóchame ju bilé nóchali, tase napurigá anílige. ");
INSERT INTO tacNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","'We a'wágame nuleme ju ralámuli, 'lige alué a'boika tabilé tábiri nóchame ju. ");
INSERT INTO tacNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Alueka 'we ganílime ju ujchagá e'yénaga gorá, 'lige sekachí korea bulugá e'yéname ju napu osirúgime ju pe u'kabi ra'íchali Onorúgame nila ra'íchali, napurigá ralámuli etémala. 'Lige aminami i'weli reboso gemagá e'yéname ju, napu a'naguchi chitochi i'weli se'wégame ju. Alarigá nokame ju napurigá ralámuli na'támala 'we a'lá sébali oyérame ko Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","'Lige najkime ju napurigá 'we a'lá semáriga kógiwa bilena wa'lú go'ame go'achi. 'Lige mochime ju alé napu mochímili ju alué abé e'wélala alé u'kuchí re'obachi pachá «sinagoga» rewégame, ");
INSERT INTO tacNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","'lige aminami najkime ju napurigá 'we 'la niraga repóriwa uché jaré ralámulite alemi napu we'ká ralámuli mochí. 'Lige najkime ju napurigá regá anewa ebreo ra'íchaga: «Rabbí» (napu aniame kéré benírame). ");
INSERT INTO tacNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","› 'Émika tabiléchigo alarigá nokibógó, tase najkime niwa napurigá anewa «benírame», péchigo bi'lepi kame alué benírame Onorúgame nila ra'íchali, pe alué napu ju Kristo, 'lige suwábaga 'émika bi'lepi O'nógame júkuru napu ju Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","'Lige tabilé 'wesi «o'nó» anewa alué uché jaré ralámuli, O'noka péchigo bi'lepi kame, pe aluecho napu 'pa rewagachi ajtí. ");
INSERT INTO tacNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","'Lige tabilé najkiá mochiwa napurigá «benírame» anewa 'emi napugiti bo'né benírame ka pe bi'lepi kame pe Krístocho Onorúgamete julárigame. ");
INSERT INTO tacNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Alué napu wa'lula ju suwábaga gu'írimili ju. ");
INSERT INTO tacNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Alué rió napu mayeme ju 'we najtékame ko, alueka pe tabilé najtékame kérélamala. Alué napu tabilé riólame ju, alué 'nalina nímala abé najtékame Onorúgame níriga. ");
INSERT INTO tacNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","› ¡Resí 'emi Moisesi nila nulalí benírame 'lige 'emi bariseo, tabilé sébali olame ju 'emi 'la sébali olámirisá! 'Émika tabilé a'reme kame ralámuli napurigá e'wímala Onorúgame napurigá Onorúgame alué ralámuli nulémala. 'Lige 'emi tabilé e'wame ju. Aminami tase elime ju 'emi napurigá sébali olámala alué uché jaré ralámuli napu 'la sébali olánilime ju. ");
INSERT INTO tacNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","› ¡Resía 'emi ralámuli Moisesi nila nulalí benírame 'lige 'emi bariseo, tabilé 'la sébali olame ju 'emi! 'Émika 'ma bujeme ju galí alué umugí gunámakame galila, 'lige jame ju 'emi Onorúgame tania iwérali re'obachi we'lisi napurigá suwábaga ralámulite etewa 'emi. Alekeri 'émika abéchigo wa'lú gastigo narémala. ");
INSERT INTO tacNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","› ¡Resía 'emi ralámuli Moisesi nila nulalí benírame 'lige 'emi bariseo, tabilé 'la sébali olame ju 'emi 'la sébali olámirisá! 'Émika ichúrimi e'yéname ju ralámuli 'yuga ra'íchiga napurigá alué oyérame gainámala, 'lige 'emi oyérame gainasa abéchigo resí nokame ju me'tigá 'emi, 'lige simámala injiérnochi napurigá 'emi. ");
INSERT INTO tacNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","› ¡Resía 'emi, 'émika uchéchigo jaré beníriniliguru nobi tabiléchigo námame júkó 'emi! ¡'Émika pe siego neraga ju uché bilé ralámuli siego o'tome! 'Émika aní bilé ralámuli 'we a'lá sébali olama orisá Onorúgame 'yuga, anigá alué re'obá e'negá iligó napurigá 'la sébali olámala, alarigaka tabilé najtékame ju. 'La sébali olama orisá Onorúgame 'yuga anigá alué 'oro pachá re'obachi ajtígame e'negá iligó, napurigá 'la sébali olámala, alueka 'la najtékame ju. ");
INSERT INTO tacNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡'Émika pe tonto julke 'lige aminami siego! ¿Tachiri abé najtékame júkó, 'oro o re'obáchala alé napu 'oro nerú? Tabilé nerúlasaká 'oro alé re'obachi Onorúgame galílachi, 'liko pe tabilé 'me najtékame nímiliké. ");
INSERT INTO tacNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Abiena anisá 'emi: «'We a'lá sébali olama olá ne Onorúgame 'yuga mesa e'negá iligame alé pachá wa'lú re'obachi ilígame», 'liko tabilé sébali olámili ju. 'Lige regá anisá 'emi: «'We a'lá sébali olame ne Onorúgame 'yuga, e'negá iligame go'ame re'pá mésachi ilígame», 'liko 'we a'lá sébali olame ne. ");
INSERT INTO tacNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡'Emi 'we siego ju! ¿Tachiri abé najtékame ju, go'ame Onorúgame kógilime o mésachala? Tabilé mésachi jásaká go'ame, 'liko pe napuyépiri go'ame neraga jámilike. ");
INSERT INTO tacNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Alué rió napu 'we a'lá sébali olámorí anigá alué mesa pachá re'obachi ilígame e'negá iligó, pe abiena anigá aní alué go'ame mésachi jágame abiena e'negá jago. ");
INSERT INTO tacNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Alué rió napu aní 'we a'lá sébali olámorí anigá re'obá e'nagá iligó, abiena anigá aní Onorúgame e'negá ajtigó napu alé pachá re'obachi bejtégame ju, alekeri 'we a'lá sébali olámorí. ");
INSERT INTO tacNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Alué rió napu 'we a'lá sébali olámorí anigá rewagá e'negá ajtigó, pe abiena anigá aní e'negá iligó alué wa'lú sía napu Onorúgame ajtime ju, 'lige abiena e'negá ajtigó Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","› ¡Resía 'emi Moisesi nila nulalí benírame 'lige 'emi bariseo, tabilé sébali olame ju 'emi napu aní! 'Émika wanápame ju pe'tá alué gajsalá 'we a'lá semá júkame napu go'ame ajchilime ju (yerbabuena, anís, komino) Onorúgame kógilime, 'lige alué abé a'lá najtékame 'nátilika 'ma tabilé néléme ju 'emi. Tabilé sébali olame ju 'emi napu nulá Moisesi alé bilena osilichi, alué napu ju 'we a'lá sébali gatélime ra'íchali ralámuli 'yuga, 'lige 'la na'temaka etélime ralámuli, 'lige 'la bi'lepi oyérilime pe Onorúgamecho. Suwábaga ye júkuru napu 'la sébali olámili ju 'emi. ");
INSERT INTO tacNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡'Émika pe siego neraga kéré napu o'tonálime ju uché jaré ralámuli bilénami! ¡'Émika a'lá saweme ju alué ba'wí tabilé 'yúriga bajimia u'kuchí se'walí, nobi 'máchigo a'wame júkó 'emi alué wa'lú ajágame kameyo anilime! ");
INSERT INTO tacNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","› ¡Resía 'emi ralámuli Moisesi nila nulalila benírame 'lige bariseo, 'émika tabilé e'wame ju napu aní 'emi! 'Emi 'we a'lá bi'weme ju alué baso 'lige alué bejtoli pe amoba, 'lige pacháganaka 'we chóligame ju. ");
INSERT INTO tacNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","'Emi bariseo siego: 'we a'lá bi'wewa alué baso pachágana 'lige bejtoli, napurigá 'la bi'wígame nímalachigó ma'chímana. 'Émika napurigá alué baso 'lige alué bejtoli alarigá ju 'emi. Amóbaka 'we bi'igá e'yéname ju nobi pacháganaka 'we chátiri 'nátame ju 'emi. Abiena 'we a'lá bi'wígame niwa pacháganachigó napurigá alué baso. ");
INSERT INTO tacNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","› ¡Resía 'emi ralámuli Moisesi nila nulalí benírame 'lige bariseo, 'émika tabilé e'wame ju napu aní 'emi! 'Émika ju napuyeri suwígame bi'tígichi galila, napu 'we a'lá semáriga ju ma'chígiká, nobi pacháganaka we'ká bi'tígame kéréko alué suwígame o'chilá 'lige we'ká sa'pá bikágame. ");
INSERT INTO tacNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Alarigá ju 'emi, 'émika 'we a'lá ralámuli káré e'nériká péchigo tabilé 'la 'nátame júkó 'emi, pe chibiyeti 'nátame kéréko. ");
INSERT INTO tacNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","› ¡Resía 'emi ralámuli Moisesi nila nulalí benírame 'lige bariseo, 'émika tabilé e'wame ju napu aní 'emi! 'Émika pe galírime ju amoba napu bi'tí alué 'ya suwígame ralámuli napu ruyame nile napu Onorúgame anélige, 'lige e'karúgame 'we a'lá semátiri tábiri jáwame ju 'emi alé amoba napu bi'tí tótiga ralámuli 'we a'lá sébali olame, ");
INSERT INTO tacNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","'lige regá anime ju 'emi: «'Ya ejperélisiga ramué pecha síchigo nokibókó ramué me'á alué ralámuli, napu ruwime nílige napu Onorúgame anele.» ");
INSERT INTO tacNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Alanigá 'emi a'boi aníguru alué 'ya mochígame rijimala ko 'emi alué napu me'ale alué 'ya mochígame ralámuli, napu ruwime nile napu Onorúgame anélige. ");
INSERT INTO tacNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Suwénisigó 'liko napu 'ma o'wínalepa alué 'ya mochígame 'emi rijimala! ");
INSERT INTO tacNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","› ¡'Émika ju napurigá sinowí! ¿Churigá 'la neyúsimala 'emi napurigá tabilé rujsúmala 'légana injiérnochi? ");
INSERT INTO tacNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Alemi julámala ne jaré ralámuli ruwime napu ané Onorúgame, 'lige jaréchigo 'we ejebénigame 'lige jaréchigo benírame, 'lige 'émika jaré 'ma me'limela gulusichi ujchagá, 'lige jaréchigo 'ma wejpisómala 'emi alemi u'kuchí re'obachi «sinagoga» rewégame mochígichi, 'lige jaréchigo 'ma najátamala 'emi ichúrimi we'kanami we'ká riógichi e'yénachi me'lináliga. ");
INSERT INTO tacNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Alekeri 'emi narémala alué wa'lú gastigo suwigórikábá suwábaga alué 'we a'lá ralámuli, suwábaga alué napu me'líliru napusí me'líliru alué Abeli anilime rió 'we 'ya ajtígame. Alué Abeli me'lisuga akiná si we'ká me'líliru napusí ochero alué Sakaríasi, Berekíasi inolá. 'Émika alé ra'pichí me'ale alué Sakaríasi alé nasipa napu e'kósime nile ajágame Onorúgame kógimia, 'lige alué wa'lú re'obá ilígichi. ");
INSERT INTO tacNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Neka 'we a'lá bijchiá aníbá suwábaga ralámuli jipe ejperégame wa'lú gastigo naremio, cha we'ká ralámuli me'lílirigime 'we 'ya. 'Émika pe aleké chátiri 'nátili 'nátame ju napurigá 'nátame nile alué ralámuli 'ya mochígame. ");
INSERT INTO tacNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","› ¡'Emi ralámuli Rusaleni ejperégame, 'émika me'ame ju alué napu ruwime napu Onorúgame ané, 'lige aminami rejtete bajsibuga me'ame ju 'emi alué ralámuli Onorúgamete julárigame! ¡Neka we'sá 'we napabúnilige 'emi napurigá bilé o'tolí ra'kome ju bo'né a'tanala, nobi 'émika tabiléchigo elárigó! ");
INSERT INTO tacNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","'We a'lá e'nésibá, 'emi ejperélachi tabilé rioga rejpímala, 'lige Onorúgame tabilé asimela alé. ");
INSERT INTO tacNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Neka 'we a'lá bijchiá aní, jípesí 'ma tabilé etémala 'emi ne'chí napusí regá anichi 'emi: «¡'We a'lá ju alué napu ju Onorúgamete julárigame!» ");
INSERT INTO tacNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Esusi ma'chínale alé wa'lú re'obachi ra'pichila, 'lige alué 'yuga járome a'bé nawile Esusi napu'lige ma'chige ilígichi, 'lige anele: ―Asíriga wa'lú ju alué re'obá, asíriga semati. ");
INSERT INTO tacNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","'Lige Esúsika anele: ―¿'La etiá 'emi alué re'obá? Neka 'la bijchiá aní, 'ma na'mináwili ko ye re'obá. Tabilé pe bilé rejté rejpimio uché bilé rejtechi amoba. ");
INSERT INTO tacNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","'Liko alé rabó simíbale Olibo anilichi. Napu'lige Esusi i'kilí ajtígachi alé alué makué okáraga Esusi 'yuga járome nawile Esusi rukemia. 'Lige tabilé najkile napurigá uché jaré ralámuli akimela ra'íchachi. Regá anele: ―Ramueka machinálilike'é, ramué ruyéwaká chiéniko na'mináwili ko alué wa'lú re'obá. ¿Chieti tábiri nerúlamala ruyame mué ku sebamio? ¿Chieti tábiri nerúlamala napu'lige gawí suibámichi? ");
INSERT INTO tacNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","'Liko Esúsika anele: ―'La 'nátiga mochiwa napurigá tase 'yégiga ra'ichámala che jaré ralámuli 'emi 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","We'ká ralámuli smela Onorúgamete julárigame korísiga, a'chigóriga a'wágame a'walí nígame korimela napurigá ne. Regá animela: «Ne ju Kristo, alué napu ju Onorúgamete julárigame.» 'Lige alanigá asíriga we'ká ralámuli 'yégamala. ");
INSERT INTO tacNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","'Emi 'la akiméleké 'we nakóráo ralámuli ichúrimi, tabiléchigo majáwagó 'emi níriga. Abirigá alarigá nímili júkuru, nobi ta'chóchigo gajúmalagó gawíká. ");
INSERT INTO tacNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ralámuli bilena se'wináriga ra'íchame nakómala uché jaré ralámuli se'wináriga ra'íchame 'yuga. Bilé gobierno julámala we'ká sontalo napurigá sayega nakómala uché jaré sontalo 'yuga. 'Lige aminami asíriga gurúlamala go'ame. 'Lige aminami gawítiri nokimela ichúrimi. ");
INSERT INTO tacNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Alué tábirika pe kulí 'la ruwime nímala alarigá nimio abé i'libeko. ");
INSERT INTO tacNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","› 'Liko alé napu gatélime ju ra'íchali nejíwili ju 'emi napurigá alué wa'lula cha olámala. 'Lige aminami 'ma me'liboa 'emi. Suwábaga ralámuli jena wijchimoba mochígame asíriga ayómala 'emi 'yuga ne'chí oyérame kóriká, alekeri asíriga cha olawa 'emi. ");
INSERT INTO tacNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Napu'lige alarigá ikisá, we'ká ralámuli ne'chí oyérame 'ma tabilé oyéramala ne'chí, pe na'áwamala uché jaré ne'chí oyérame 'yuga, 'ma sairúgame neraga mochímala. 'Lige alé napu ra'íchali gatélime ju nejímala. ");
INSERT INTO tacNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","'Lige aminami asíriga we'ká ralámuli nímala 'yégame. Onorúgamete 'yárigame korimela nóchali, 'lige pe lanigá asíriga we'ká ralámuli 'yégamala. ");
INSERT INTO tacNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Aminacho we'ká tábiri buyámili ju asíriga enátiri. 'Ma amulí suwábaga ralámuli tabilé ganíliga járomala a'bopi. ");
INSERT INTO tacNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Bilé rió 'la abisibi oyérasaká ne'chí napusí alué tábiri simiro, alueka 'la sebámili júkuru rewagachi ne'chí 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Alué 'we semátiri ra'íchali, alué napu ruyeme churigá nulamio Onorúgame ralámuli alawálachi, alueka bochígimi ruitúgame nímala jena wijchimoba napurigá suwábaga chojkégame ralámuli akimela. Napu'lige 'ma suwábaga chojkégame ralámuli akisá, a'lige kulí suibámala suwábaga. ");
INSERT INTO tacNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","› Alekeri napu'lige etea alué chátiri tábiri alé re'obachi, alué napu 'ma gajúname ju suwábaga tábiri (Ranieli 'sile osá ye ra'íchali napu ruwime nile napu Onorúgame anele, ta'lá námata 'emi.), ");
INSERT INTO tacNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","'emi Jurea anilichi ejiro mochígame, 'ma júmasimili júkuru wamí 'pami rabó. ");
INSERT INTO tacNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Alué rió re'pá galichí amoba ilígame tabilé re'kínimili júkuru tábiri 'mea, iligá pe 'másimili júkuru. ");
INSERT INTO tacNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Alué rió jami nóchame pecha simeli júkó ku galírale alué we'lí o'pacha nolamia, pe iligá 'mi 'másimili júkuru. ");
INSERT INTO tacNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Asíriga enáriga nímala umugí o'pachágame níriga! ¡'Lige alué u'kuchítiri chi'íranti níriga abiena 'we enárigá nímala! ¿Churigá júmasamalawé? ");
INSERT INTO tacNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","'La tániwa Onorúgame napurigá tabilé alarigá nímala 'we rulágachi, nibilé rawé resíbilichi. ");
INSERT INTO tacNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","'We enárigá nímala a'lige rawé. Tajsiné alarigá ikí napu'lige Onorúgame gawí newasa, 'lige tajsiné alarigá nímala abé i'libeko. ");
INSERT INTO tacNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Onorúgame tabilé a'rémala napurigá we'lisi nerúlamala ye resítiri tábiri. Tabilé alarigá nísaká, pecha we'lisi anachámili ko ye ralámuli. Onorúgame 'we galeme ju ralámuli napu bo'né wanápilige, alekeri tabilé a'rémala napurigá we'lisi nerúlamala ye chátiri tábiri. ");
INSERT INTO tacNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","› 'Liko tase bijchígiwa rekó regá anichi bilé ralámuli: «Jena ajtípá alué Onorúgamete julárigame», o regá anisá ma: «'Mi ajtípá alué Onorúgamete julárigame.» ");
INSERT INTO tacNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Asíriga smela ralámuli 'yégame. 'Lige jaré ralámuli Kristo korimela Onorúgamete julárigame napurigá ralámuli gu'írimala. 'Lige jaré ralámuli ruwime kolimela napu anele Onorúgame, 'lige aminami asíriga semá nokimela ralámuli 'yéginiliga. 'Lige 'la umabásaká abiena 'yégimala alué ralámuli napu Onorúgame anile bo'né oyérame nímalagó. ");
INSERT INTO tacNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","'Ma ruyékuru ne 'emi ye tábiri bijí ta'chó sébachi napurigá 'la listo mochímala. ");
INSERT INTO tacNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","'Lige napu'lige anisá ralámuli: «Néguru, 'mi alé ajtíkuru Kristo alé napu tabilé rió», tase simawa e'newa. 'Lige aminami anisá: «Néguru, jena ajtíkuru chíboka», tase bijchígiwaká 'emi alanichi ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Napu'lige alué Onorúgamete julárigame napurigá rió neraga ku nawá napurigá alué u'kí ne'wílala 'we ra'ósame napu bochígimi ma'chígime ju, alarigá nímala. ");
INSERT INTO tacNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Suwábaga ralámuli machime ju alé napu napuíme ju alué wilú, alé bo'igó bilé mukúgame. Alarigá nímala napu ne ku nawachi, suwábaga ralámuli machimela. ");
INSERT INTO tacNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","› Yati neraga pe simírisa alué resítiri raweli, rayénali 'ma chóniga asibámala, 'lige mechaka tabilé ra'ósiga asimela, 'lige so'plika 'ma rujsúmala 'pákana rewagáchikana. Suwábaga napu ekí nerú 'pa rewagachi 'ma nokimela. ");
INSERT INTO tacNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","A'liko 'la nélélamala 'pa rewagachi e'nénilia alué ko napu Onorúgame júlale jékana wijchimoba. Suwábaga chojkégame ralámuli jena wijchimoba mochígame 'ma nalámala sinaka 'we cha lagá. 'Lige etémala alué ralámuli alué rió Onorúgamete julárigame napurigá rió neraga 'pákana enágichi nolíralekana. 'Lige asíriga a'wagá nawámala 'lige ra'ósaga. ");
INSERT INTO tacNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","'Lige akémala bilé trompeta gusuchi, 'lige akigá alué santo ánjeli simámala bochígimi gawichí napabumia suwábaga ralámuli napu ekí wanápilige bo'né 'kúchila neraga. ");
INSERT INTO tacNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","› Jípeko 'la benibóká alué tétali churigá ka alué chuná: Napu'lige 'we chi'lame kachi chalawala 'lige yáachi sawala, 'liko 'émika 'ma machime ju amulí seba bamunú. ");
INSERT INTO tacNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Napu'lige 'emi etea ye resítiri tábiri, abiena 'la machigá mochiwa 'emi 'ma sebio alué napu ne ruwílige. ");
INSERT INTO tacNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Neka 'la bijchiá ruwí suwábaga alarigá ikimeo bajchabé ta'chó suwichi we'ká ralámuli jipe ejperégame. ");
INSERT INTO tacNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Alué rewagá 'lige gawí suwibámili júkuru, ne nila ra'íchalika tabiléchigo siné suwibámalagó. ");
INSERT INTO tacNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","› Pecha 'wesi machígó a'lige rawé suwibamio, o alué 'ora alakimeo alué tábiri. Alué santo ánjeli 'pa rewagachi mochígame pecha machígóchigó, nibilé alué Onorúgame Inolá machígó, pe Onorúgameka 'la machí. ");
INSERT INTO tacNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","› Napu'lige uché nawachi alué 'pa rewagáchika julárigame napurigá rió neraga, pe a'chigóriga nímala napurigá 'ya napu'lige Noé asálige. ");
INSERT INTO tacNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Napu'lige wa'lú u'kule, a'lige pe bajchabé ralámulika asíriga ganíliga go'yá mochígeturu 'lige aminami i'wilí ba'wila bajiga rekútame, 'lige aminami umugítiri rewigá, napusí napu'lige Noé bajkisá bárkochi. ");
INSERT INTO tacNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ralámulika tabilé u'kirá mayele 'lige arigá 'ma wa'lú u'kule, 'lige 'ma u'lísale suwábaga alué ralámuli. Alarigá nímala napu'lige alué Onorúgame julálila nawámala 'pa rewagáchika napurigá rió neraga. ");
INSERT INTO tacNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Napu'lige sebasa, 'lige oká rió nokisá asarachi, bilé o'toboli ju, 'lige bilé abajá a'réwili ju. ");
INSERT INTO tacNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","'Lige oká umugí uchusa rusiá bilé 'ma o'toboli ju, 'lige alué uché bilélaka abajá a'réwali ju. ");
INSERT INTO tacNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","› Alekeri 'la e'negá mochílime júkuru, pecha machimea 'emi aliéniko nawamio alué wa'lula 'emi nuleme. ");
INSERT INTO tacNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Bilé rió galí nígame 'la machisáká alué 'ora nawamio chigórigame rukó, 'we a'lá listo asimékuru tabilé a'remia alé galírale bajkichi. ");
INSERT INTO tacNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","'Émika 'we listo mochímili júkuru pecha machiá 'emi alué 'ora nawamio alué rió 'pa rewagáchika julárigame Onorúgamete, pe bilé rawé nawámili júkuru tabilé 'me buwechi. ");
INSERT INTO tacNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","› Ruwimé ne churigá nóchame ko bilé nóchame 'we a'lá sébali nóchame. Napu'lige bilé batroni a'resa bilé nóchame napurigá 'yámala go'ame uché jaré nóchame, 'liko alué 'we a'lá sébali olámili ju. 'La 'yámili ju go'ame. ");
INSERT INTO tacNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","'Lige alué wa'lula ku sebasa 'lige etesa alué nejkúrime 'we a'lá nóchachi, 'liko alué nejkúrime 'we a'lá semátiri narémala tábiri alué wa'lula nila. ");
INSERT INTO tacNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Neka 'la bijchiá aníguru, alué wa'lula 'la nejímala napurigá suwábaga tábiri nocha asiboa alué wa'lula nila nóchali. ");
INSERT INTO tacNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Siné kachi anisáká alué tebútiga ajchárigame: «Asíriga we'ká rawé tabilé ne 'siá'é alué wa'lula. Pecha 'we nawámaréko.» ");
INSERT INTO tacNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","'Lige o'winasa alué che jaré nóchame wejpisoa, 'lige go'sá 'lige bajisa tégali 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","'Liko napu'lige ku seba wa'lula, ta'mé buwechi 'lige aminami ta'mé listo ajtígachi, ");
INSERT INTO tacNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","alué wa'lula asíriga a'wágame wejpisómala alué nóchame, 'lige julámala alé napu mochí alué uché jaré ralámuli napu tabilé sébali olale. 'Lige alué ralámulika 'ma nalámala 'lige aminami nolo chi'námala ramalá resí níliga. ");
INSERT INTO tacNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","'Lige Esusi uché rajpé anile: ―Uchéchigo siné ruimé ne churigá ka napu'lige Onorúgame nulachi ralámuli alawálachi. Pe napurigá makué i'wé napu simíbale alué rió newímili najtepamia lámpara o'ká aseite ro'ilime. Bilena newigime nerúgichi, pe alarigá ju. ");
INSERT INTO tacNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","'Lige alué maligi i'wé 'we a'lá 'nátame nile, 'lige alué uché jaré malígika tabilé 'la 'nátame nile. ");
INSERT INTO tacNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Alué maligi napu tabilé 'la 'nátame nile, alueka tabilé o'tole aseite uché ro'ilime 'ma cho'isá alué lámpara. ");
INSERT INTO tacNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","'Lige alué napu ekí 'la 'nátame ka, alueka 'la o'tole aseite botéachi ro'igá. ");
INSERT INTO tacNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","'Lige 'ma alíile 'lige ta'wé nawale alué newímili rió, 'lige alué iweka 'ma gojchinálile, 'lige arigá 'ma okole. ");
INSERT INTO tacNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","'Liko nasipa rukórikáchi ma'chí anile bilé siname, 'lige regá anile: «¡'Ma aleka ená alué newímili rió, yati buyásiga najtepawa!» ");
INSERT INTO tacNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","'Liko suwábaga alué i'wé 'ma o'mochísale lámpara rajemia. ");
INSERT INTO tacNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","'Lige alué tabilé 'la 'nátame napu tabilé o'tole aseite anele alué uché jarela i'wé: «Ramué aseite tanéwaká, 'ma tabilé rajinali ye lámpara.» ");
INSERT INTO tacNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","'Lige alué i'wé 'we a'lá 'nátame ka anile: «Tabilé, 'emi tanésiká tabilé nachuwawa ramué nibilé 'emi. Napurigá tabilé rokárélamala, simáwagó raliboa aseite 'mi ralinélichi.» ");
INSERT INTO tacNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","'Lige pe kulí a'minami e'yénigichi alué aseite ralimea alué newímili rioka 'ma nawale. 'Lige alué i'wé napu 'la niga mochile aseite mo'ile alué newímili rió galílachi napu piesta oláwili nile newika, 'lige alué rió newímili 'ma 'yérale yochi. ");
INSERT INTO tacNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","'Lige alué i'wé aseite ralagá e'yénameká, abé i'libeko sébale 'lige anile: «¡Mué Wa'lula, i'pú yochi!» ");
INSERT INTO tacNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","'Lige alué rió newímili anele: «Tabilé. Neka 'la bijchiá aníguru tabilé machí ne 'emi.» 'Lige tabilé i'pule. ");
INSERT INTO tacNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","› Alekeri 'emi 'we a'lá listo mochiwa, pecha machiame 'emi aliéniko nawamio alué napu Onorúgame julámala 'pa rewagáchika. ");
INSERT INTO tacNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","› Napu'lige Onorúgame nulachi ralámuli alawálachi, pe a'chigóriga ju napurigá bilé rió napu'lige ta'chó simiá bilénami mejká bayele alué bo'né 'yuga nóchame 'lige alué 'yale enomí. ");
INSERT INTO tacNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","› Bilé rió maligi mili ijchirúlime enomí plata 'yale. 'Lige uché bilélaka pe oká mili 'yale. 'Lige uché bilélaka pe bilé mili 'yale. Alué abé benégame nóchaga, alueka abé we'ká 'yáleru. 'Lige alué ta'mé jebénigame nóchaga, alueka pe u'kabi 'yáliru. 'Lige alarigá 'yasa 'ma simile mejkami. ");
INSERT INTO tacNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","'Lige alué maligi mili ichirúlame enomí 'yárigame yati simile nochamia alué enomite, 'lige uchéchigo maligi mili enomí mele. ");
INSERT INTO tacNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","'Lige alué oká mili 'yárigame abiena nóchale 'lige mele uchéchigo oká mili. ");
INSERT INTO tacNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Alué bilé mili 'yárigame ka, alueka jole we'echi, 'lige alé gatele toka alué enomí plata alué wa'lula nila. ");
INSERT INTO tacNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","› 'Lige a'kinana 'ma we'ká rawé kachi ku nawale alué wa'lula, 'lige bayele alué nóchame machináliga chekí méliga alué enomí nóchame 'yárigame. ");
INSERT INTO tacNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","'Lige alué maligi mili enomí narékame sébale alé, 'lige yati 'yale alué wa'lula makué mili. 'Lige anele i'gá alué enomí nejígame repúniliga: «Mué wa'lula, maligi mili ijchirúligame enomí nejígeturu mué, 'lige alué maligi mílite uchéchigo maligi mili mératuru ne.» ");
INSERT INTO tacNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","'Liko alué wa'lula enomí nígame anele: «'We a'lá ju, asíriga 'la nóchame ju mué 'lige aminami asíriga 'la sébali olame. Mué 'we a'lá sébali olákuru rekó pe u'kabi 'yásiga, jípeko uché rajpé nejímala ne, 'we a'lá ganíliga asiboa ne 'yuga nocha.» ");
INSERT INTO tacNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","'Lige abé we'liko nawale alué oká mili enomí narékame, 'lige anile: «Mué wa'lula, oká mili nejígeturu mué, jena mochí, 'lige alué oká mílite uchéchigo oká mili meráturu ne, jena mochíkuru.» ");
INSERT INTO tacNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","'Liko alué wa'lula enomí nígame anele: «'We a'lá ju, asíriga 'la nóchame ju mué, 'lige aminami asíriga 'la sébali olame. Mué 'we a'lá sébali olákuru rekó pe u'kabi 'yásiga, jípeko uché rajpé nejímala ne, 'we a'lá ganíliga asiboa ne 'yuga nocha.» ");
INSERT INTO tacNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","'Lige pe'tá nujubapi sébale alué pe bilé mili enomí narékame, 'lige alueka anile: «Mué wa'lula, neka 'we a'lá machí tabilé 'wesi na'temame ko mué, mueka panápuri 'wíime júturu rekó tabilé asemi echasá, 'lige napubume ju mué ri'ligó napu mué tabilé wejpimole. ");
INSERT INTO tacNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Alekeri neka majawáturu, alekeri toka mochíturu ne mué enomila. Jena mochíkuru alué enomí napu mué nejí 'sié.» ");
INSERT INTO tacNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","'Liko alué wa'lula enomí nígameka anele: «'La tachiti rió, 'la tabilé sébali olanti, 'la machié panápuri 'wíime ko ne rekó tabilé asemi echigé ne, 'lige napubume ko ne ri'ligó rekó tabilé wejpimoke ne. ");
INSERT INTO tacNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Alekeri 'yátéliko ye enomí bilé rió enomí nígame napurigá nochárimala alué enomite, alarigá 'la mémikuru enomí pe u'kabi kabá.» ");
INSERT INTO tacNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","'Liko alué enomí nígame anele alué ralámuli napu jale alemi: «Bujewa alué enomí ye rió, 'lige 'yawa alué rió makué enomí nígame, ");
INSERT INTO tacNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","napugiti alué abé nígame, alueka uché rajpé 'yáwili kame, 'lige alué napu tabilé nígame ju, alueka 'ma bujéwili ju alué pe u'kabi napu ekí ni. ");
INSERT INTO tacNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","'Lige alué nóchame tabilé 'nátame ka, alueka ma'chí pápua chóniga ilígichi, 'lige alé asigá nalámala 'lige chi'námala ramalá resí níliga.» ");
INSERT INTO tacNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","› Napu'lige uchéchigo nawá wa'lú a'walí niga jena wijchimoba alué Onorúgamete julárigame 'pa rewagáchika napurigá rió neraga, 'lige suwábaga santo ánjeli 'yuga, a'lige kulí asibámala wa'lula neraga alué Onorúgamete julárigame. ");
INSERT INTO tacNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","A'lige napuímala suwábaga ralámuli jena wijchimoba mochígame, 'lige rojanámala ralámuli napurigá rojáname ju bilé rió alué chibá bo'á 'yuga uchusa, waná uchúchame ju chibá 'lige waná uchúchame ju bo'á. ");
INSERT INTO tacNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","'Lige wajtoná mochiámala alué ralámuli tabilé resí nokame, 'lige o'iná mochíamala alué ralámuli resí nokame. ");
INSERT INTO tacNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","› A'lígeko alué Wa'lula Onorúgamete julárigame alé nasipa asigá regá anémala alué wajtoná mochígame: «Jeka simasi 'emi napu iwérali 'yárigame ju Onorúgamete. Jeka simasi napu ajtí ne napurigá ne 'kúchila neraga. Neka 'ma 'la gatega ajtí 'we 'yasi napu'lige gawí newálige Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Napu'lige ne e'lowika eyénachi, 'émika 'we a'lá kónaturu go'ame. Napu'lige ne balámachi 'émika 'we a'lá nejíturu ba'wí bajílime. Pe mejkaka nawágame kéturu ne 'lige 'émika 'la bayéturu ne'chí napurigá pachá galírale bajkimela ne. ");
INSERT INTO tacNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","'Lige ne tabilé o'páchigime kéturu, 'lige 'émika nejíturu o'pacha. 'Lige ne 'we nayume kéturu, 'lige 'émika asíriga 'la nesératuru ne'chí. 'Lige ne galírale bajcháriga ajtigéturu, 'lige 'émika asíriga 'la jsime kéturu alemi ne'chí e'nemia.» ");
INSERT INTO tacNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","'Lige alué a'ká ralámulika animela: «Mué wa'lula, ¿chiéniko etérukó ramué 'we e'lowika eyénachi mué napurigá go'ame 'yawa mué? Ramueka tajsiné 'yalíwé go'ame mué. ¿Chiéniko etérukó ramué 'we balámaka eyénachi mué napurigá ba'wí 'yawa mué? Ramueka tajsiné 'yalíwé ba'wí mué. ");
INSERT INTO tacNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Chiéniko etérukó ramué mejkaka nawachi mué napurigá galírale bayériwa mué? Ramueka tasiné etéliwé mejkaka nawachi mué 'lige ta siné bailíwé galírale. ¿Chiéniko etérukó ramué tabilé o'páchiga ajtígame mué napurigá o'pacha kógiwa? Ramueka tasiné 'yalíwé o'pacha mué. ");
INSERT INTO tacNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Chiéniko etérukó ramué 'we nayua ajtigó mué o galírale bajcháriga ajtígichi mué napurigá simawa alemi e'newa alemi mué ajtígichi?» ");
INSERT INTO tacNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","'Lige alué wa'lula animela: «Neka 'we a'lá bijchiá aníbá, napu'lige 'emi gu'írile suwábaga ralámuli ne'chí oyérame, napu tabilé nígame nile, pe ne'chí gu'írime kéréle.» ");
INSERT INTO tacNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","› 'Lige alué wa'lula abiena regá anémala alué o'iná mochígame: «Se'wí, a'minami simasi 'emi napu ekí gastigáriwili ju alé na'ichí napu tabilé siné cho'ime ju, alé napu pápili ju alué Remónisi alué bo'né gompaniérola u'kuchípala remónisi 'yúriga. ");
INSERT INTO tacNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Napu'lige ne asíriga e'lowika eyénachi 'émika tabilé pe'tá nejíturu go'ame. Napu'lige ne asíriga balámaka eyénachi 'émika tabilé pe'tá nejíturu ba'wí. ");
INSERT INTO tacNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Neka mejkaka nawáturu 'lige 'émika tabilé repáraturu napurigá ne 'emi galílachi bajkimela. Neka tabilé o'páchigime kéturu 'lige 'émika tabilé nejíturu o'pacha. Ne galírale bajcháriga ajtígichi, 'émika tajsiné nolínaturu ne'chí e'nemia.» ");
INSERT INTO tacNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","'Liko alué 'we i'nílime ralámuli rukémala alué wa'lula: «Mué Wa'lula, ¿chiéniko tabilé 'yárukó go'ame mué e'lowika eyénachi 'lige balámaka eyénachi? ¿Chiéniko tabilé 'yárukó o'pacha tabilé o'páchaga eyénachi mué? ¿'Lige chiéniko tabilé e'nénilekó mué napu'lige galírale bajcháriga ajtígichi mué?» ");
INSERT INTO tacNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","'Liko alué wa'lula animela: «Neka 'we a'lá bijchiá aníbá, 'emi napu tabilé gu'írile alué ralámuli ne'chí oyérame tabilé nígame, tabilé gu'írame kéré ne'chí.» ");
INSERT INTO tacNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","'Liko alué ralámuli tabilé nejkúrame simámala bilena 'we resírikáchi gastigo naremia, alé napu senibí resí nilia mochime ju ralámuli. 'Lige alué 'la a'ká ralámulika 'we ganíliga mochímala Onorúgame 'yuga 'pa rewagachi senibí. ");
INSERT INTO tacNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Napu'lige Esusi 'ma 'we a'lá ruisá ye ra'íchali, anele alué bo'né 'yuga járome: ");
INSERT INTO tacNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―'Emi 'la machilke 'ma okabi rawé rokárikó Páskua anilime piesta sebamio, 'lige ye piéstachi cha'piboli ju alué rió 'pa rewagáchika julárigame Onorúgamete napurigá rió neraga, 'lige 'ma me'liboli ju gulusichi ujchagá. ");
INSERT INTO tacNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","A'lige rawé napuíle alué e'wélala balé, alué Moisesi nila nulalí benírame, 'lige alué e'wélala ralámuli jurío nuleme. Napuíle alué abé wa'lula balé galílachi, alué napu Kaipasi rewégame nile. ");
INSERT INTO tacNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","'Lige alé napuísa 'we a'lá ra'íchale a'bopi churigá cha'pimea Esusi 'yégiga, 'lige me'limea olale cha'pisá. ");
INSERT INTO tacNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Regá anile: ―Pecha che nokiame júkó piéstachika, 'ma ayómala ralámuli bo'né gompaniérola, alué ralámulika cháchigo 'la niraga etéeme Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","'Lige Esusi simile Betania anilichi we'ká riógichi, 'lige alé Simoni galílachi ajtile, alué Simoni napu 'we nayume nílige sa'pachí amoba abé i'bé. ");
INSERT INTO tacNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","'Lige alé sébale bilé mukí, 'lige bilé botea rejtete newárigime o'kame nile. Pachágana botéachi ro'ágame nile ba'wí semá júkame, 'lige asíriga najteme nile. Napu'lige Esusi alé mesa ilígichi ajtígichi, alué mukika alué ba'wí semá júkame mo'chí ro'ele Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Napu'lige alué Esusi 'yuga járome etesa alieti, asíriga ayole 'lige anile: ―¿Chonigá najsabúché alué mukika alué ba'wí semá júkame? ");
INSERT INTO tacNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Iligá ralineti asíriga we'ká enomichi, 'lige alué tabilé nígame ralámuli gu'íritékuru alué enomite. ");
INSERT INTO tacNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","'Lige Esusi machigá alanichi alué ralámuli, anele: ―¿Chonigá alanilíbaché ye mukí? Neka 'we a'lá niraga etiá ye mukí alué ba'wí semá júkame ro'echi. ");
INSERT INTO tacNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Abiena mochímala jena ralámuli tabilé nígame 'emi 'yuga, neka tabiléchigo asimélagó. ");
INSERT INTO tacNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Napu 'sile ye mukí, alanokame ju bilé ralámuli mukusá, ba'wí 'we semá júkame ro'eme ju. 'We a'lá na'tawa tachiri ruwime ko ne. 'Ma listáriga 'smi ne'chí napu'lige gatéwili ju ne bilena resochí ne mukusá. ");
INSERT INTO tacNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Neka 'la bijchiá aníguru. Panápuri ra'icháwili ju napurigá 'síligo ne, abiena ra'icháwili ju napurigá 'síligo ye mukí. Alarigá 'la tabilé we'káwaga mochímala ralámuli ala'síligo ye mukí. ");
INSERT INTO tacNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","'Liko bilé alué makué oká Esusi 'yuga járome, napu Jurasi Iskariote rewégame nile, simile alé napu e'wélala balé mochile, ");
INSERT INTO tacNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","'lige rukele: ―¿Chekí enomí najtétamala 'emi, ne nejkúrisa Esusi cha'piá? 'Liko alué e'wélala baleka baisá makué ijchirúlime enomí plata najtétamoríle nejkúrisaká Esusi cha'piachi. ");
INSERT INTO tacNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","A'lige si chojkile alué Jurasi Iskariote 'nata chiéniko 'la níliga alué Esusi cha'piá. ");
INSERT INTO tacNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Napu'lige sebasa raweli Páskua piéstachi baní go'yachi tase kawali ro'igá newárigime, a'lige rawé alué Esusi 'yuga járome rukele alué Esusi, regá: ―¿Koche 'la nítéko go'ame newalía napurigá go'mela mué o'rako rukó? ");
INSERT INTO tacNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","'Lige Esúsika anile: ―Simíbaga alé we'ká riógichi, 'lige sebawa bilé rió galílachi napu 'ma machí 'emi, 'lige anéwaká: «Alué Wa'lula ramué nuleme regá aní: 'Ma pe u'kabi rawé rokáré napurigá me'liboa ne. Mué galílachi newámala ne go'ame jipe go'yame Páskua piéstachi, ne 'yuga járome 'yuga go'mé olá ne.» ");
INSERT INTO tacNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","'Lige alué Esusi 'yuga járome simíbale alé we'ká riógichi napurigá nulélige Esusi, 'lige newale go'ame a'lige rukó go'yame. ");
INSERT INTO tacNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","'Ma rukó 'ma chonasa, Esusi alé re'lé ilígame mésachi a'bé kilí bo'íbale gayena sekate machoka wijchí, alué makué oká bo'né 'yuga járome 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Napu'lige alé go'yá mochiga, Esúsika anile: ―Neka 'la bijchiá aníbá, bilé 'emi, ne saíla gu'írimio ne'chí cha'piachi. ");
INSERT INTO tacNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","'Lige alué Esusi 'yuga járome ka 'we cha lale alieti akisá,'lige chojkile regá rukea Esusi: ―Mué Wa'lula, ¿ne júpá ala'símili? ");
INSERT INTO tacNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","'Liko Esúsika anile: ―Alué rió napu chua chujkú jena bejtólichi ne 'yuga, alué 'símala nejkura ne'chí cha'piachi. ");
INSERT INTO tacNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Neka regá ruwíbá, alué napu ju Onorúgamete julárigame 'pa rewagáchika napurigá rió neraga, mukumeli ju napurigá aní Onorúgame nila ra'íchali, 'lige resía alué napu nejkúrimala cha'piachi alué napu ju Onorúgamete julárigame 'pa rewagáchika napurigá rió. Abé a'lá nílige tabilé ocheria alué rió. ");
INSERT INTO tacNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","A'liko alué Jurasi rewégame, alué napu nejímili nile Esusi saíla napurigá cha'pimela Esusi, anile: ―Mué benírame, ¿ne ju alué? 'Lige Esúsika anele: ―Juli, mué ju. ");
INSERT INTO tacNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Napu'lige go'yá mochiga go'ame, Esúsika 'wile bilé baní, alué baní napu tabilé ro'igá newárigime nile kawali, 'lige cheliera 'yale Onorúgame, 'lige 'ma cheliera 'yasa Onorúgame, 'lige chi'wánale, 'lige 'yale alué bo'né 'yuga járome 'lige regá anele: ―Go'sí, yeka ne sa'pala ju. ");
INSERT INTO tacNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","'Lige 'wile alué baso i'wilí ba'wila ro'ágame napu rekútame ju, 'lige 'ma cheliera 'yasa Onorúgame, 'yale alué bo'né 'yuga járome regá anigá: ―Bajisi o'maka. ");
INSERT INTO tacNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ye pachágana manígime ne elalá ju, alué elá napu ma'chínimili ju ne me'liachi, 'lige ne mukugá wa'lú gu'írimili ju ne 'emi ralámuli, 'liko Onorúgame 'la e'kámala. Regá gatele Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Neka 'la ruwí tabilé uché bajimio ne ye pachágana manígime i'wilí ba'wila napusí chojkí nulá Onorúgame ralámuli alawálachi. ");
INSERT INTO tacNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","'Ma go'sá go'ame, wikarale Onorúgame wikálala, 'lige wikarasa simíbale na'lebo rabó Olibo rewégichi. ");
INSERT INTO tacNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","'Lige Esúsika anele: ―Suwábaga 'emi makué oká rió ne 'yuga járome, 'ma a'rémala 'emi ne'chí jipe rukó. Aka regá anime chujkúché alé Onorúgame nila osilichi: «'Ma me'limé ne alué bo'á bo'élome, 'lige alué bo'aka 'ma ra'lá mo'bámala.» ");
INSERT INTO tacNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","'Lige neka a'kinana ku ajánasa, alé Galilea simé ne bajcháchigo ta'chó jsichi 'emi alemi. ");
INSERT INTO tacNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","'Lige Pégroka regá anele: ―Rekó suwábaga uché jaré 'ma simíbige, 'ma bi'neli a'resa mué, neka abichilubi mué 'yuga einámala. ");
INSERT INTO tacNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","'Lige Esúsika anele alué Pegro: ―Neka 'we a'lá bijchiá aníbá, jipe rukó be'bé ta'chó sinachi o'tolí, baisá animela mué: «Tabilé machí ne Esusi.» ");
INSERT INTO tacNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","'Lige alué Pégroka uchéchigo abichilubi regá anele: ―Rekó me'liáe ne, neka tabilé majámala ruigá 'we a'lá machime ko ne mué. Suwábaga alué Esusi 'yuga járome alanílechigó. ");
INSERT INTO tacNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","'Lige Esusi simile alué bo'né 'yuga járome si, 'lige sébale alé bilena Jetsemaní rewégichi we'ká rojégichi olibo anilime rojá. 'Lige alé alué Esusi regá anele alué bo'né 'yuga járome: ―Jena mochisi buigá, pe'wera simé ne Onorúgame tánimia iwérali alé 'minami simigá. ");
INSERT INTO tacNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","'Lige bayérole alué Pegro 'lige okánika alué Sebereo 'kúchila (Santiago 'lige Juani) napurigá alué 'yuga simámala, 'lige alé 'we sewele, 'lige aminami asíriga we'ká 'nátale Esusi alemi waná. ");
INSERT INTO tacNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","'Lige alemi Esusi regá anele alué bo'né 'yuga járome: ―Asíriga sewé nili ne pachágana ne alawálachi, amulí mukú ne seweka. 'Émika jena ejtebíwagó 'lige 'la e'negá mochíwaká. ");
INSERT INTO tacNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","'Lige Esúsika abé a'mibemi simile, 'lige ajkaná chujkíbale gorá wijchí chega, 'lige regá anele Onorúgame: ―Mué O'nó, neka tabilé najkí napurigá ralámuli resí olámala ne'chí. Mué alarigá najkisáká, a'lá ju, resí ikiméleké ne. ");
INSERT INTO tacNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","'Lige nawale ku alé napu ejtebílige alué bakiá rió bo'né 'yuga járome, 'lige 'ma okoka bi'tígame rewale, 'lige anele Pegro: ―¿Tabilé anacharu e'negá mochiga bilé 'ora? ");
INSERT INTO tacNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","'We a'lá e'negá mochiwa, 'lige 'we a'lá tania mochiwa Onorúgame napurigá ta neyúrimala Remónisi na'tálila. 'Émika 'we a'lá sébali olánili, tabiléchigo nígame júkó a'walí. ");
INSERT INTO tacNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","'Lige uchéchigo simile Esusi Onorúgame 'yuga ra'ichamia, 'lige regá anele Onorúgame: ―Mué O'nó Onorúgame, resí ikimeli nísaká ne a'lá ju, resí ikiméleké ne. A'lá sébali olánili ne napu najkí mué. ");
INSERT INTO tacNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Uchéchigo ku nawale alué Esusi 'lige okókame rewale, 'wéchigo gojchinalia mochíligime. ");
INSERT INTO tacNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","'Lige alé a'rele okókame 'lige uchéchigo simile Onorúgame 'yuga ra'ichamia a'chigóriga napurigá be'bepi. ");
INSERT INTO tacNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","'Lige Esusi uchéchigo nawale alemi napu bi'tile okoka alué bo'né 'yuga járome 'lige Esusi anele: ―¿'A bijí okoka bi'tí 'emi? 'Ma sébapá raweli, 'lige alué Onorúgamete julárigame 'pa rewagáchika napurigá rió neraga, 'ma cha'piboli ju alué i'nílime ralámulite. ");
INSERT INTO tacNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","O'weti mochisi, 'ma a'beka ená alué napu ne 'yuga eyéname nílige, 'ma a'beka ená nejkúrimia ne'chí cha'piachi. Nabá najtepawa. ");
INSERT INTO tacNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Bijí ra'icha ilígachi alué Esusi alemi sébale alué Jurasi napu Esusi 'yuga ilírome nílige. Alué Jurasi we'ká rió 'yuga enale, 'lige alué we'ká rió siparina o'ká e'yénale, 'lige e'wele gujsítiri. Alué e'wélala balé 'lige alué e'wélala ralámuli jurío nuleme, aluete julárigame nile alué we'ká rió Esusi cha'píniliga. ");
INSERT INTO tacNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Alué Jurasi napu nejkúrisia enale cha'piachi Esusi, 'ma 'la regá anélige alué we'ká rió: ―Alué napu chu'migá repori ne alué ju Esusi, yati cha'pibóaká 'lige o'tobóaká. ");
INSERT INTO tacNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","'Lige alemi sébaga Jurasi regá anele alué Esusi: ―¡Kuira mué benírame! 'Lige alarigá anesa yati chu'mile banichí. ");
INSERT INTO tacNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","'Lige Esúsika anele: ―Mué gompaniero, 'la sébali olawa napu 'sima olá mué. 'Liko alué we'ká rió napu 'yuga enale Jurasi a'bemi jábale, 'lige yati cha'pile alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","'Lige bilé rió napu Esusi 'yuga eyéname nile yati ma'chí pale siparina 'lige alué wa'lula balé piónila najkala rejpúnale. ");
INSERT INTO tacNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","'Liko Esúsika anele: ―Tase che 'sípua alué siparínate, ku gaté alé gatélachi. Suwábaga napu ekí siparínate me'ame ju, siparínate me'liboli júchigó. ");
INSERT INTO tacNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Mueka mayé tabilé julamio Onorúgame jipe tánisa ne, napurigá julámala 'pa rewagáchika we'ká mili santo ánjeli napurigá ne'chí repúmala? ");
INSERT INTO tacNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","'Lige Onorúgame ne'chí gu'írasaká jipe, ¿churigá 'la sébali ikimélewé napu anime chujkú osilichi? ");
INSERT INTO tacNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","A'lígerikáchi regá anele Esusi alué ralámuli Esusi saíla: ―¿'Émika chonigá i'weli siparíniga 'lige gujsíliga síché ne'chí cha'pimea napurigá bilé chigórigame neraga? Neka nabí rawé ajtime kéturu alé ra'pichí wa'lú re'obachi beniria Onorúgame nila rejcholi, 'lige aleka tabilé siné cha'píturu 'emi ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Peba alarigá nímili nílige napurigá aní alué osilí napu osale alué 'ya mochígame napu ruwime nile napu Onorúgame anélige. Alésíko suwábaga alué Esusi 'yuga járome 'ma bi'neli a'rele Esusi, 'ma júmasale. ");
INSERT INTO tacNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Alué ralámuli Esusi cha'pígame 'ma o'tole Esusi alé napu ajtí alué abé wa'lula balé alué Kaipasi rewégame, alé napu napuíka mochile alué Moisesi nila nulalí benírame, 'lige alué ralámuli jurío nuleme. ");
INSERT INTO tacNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Napu'lige Esusi o'tiachi alemi guwánami enale alué Pegro, 'lige alué Pegro alemi ra'pichimi si sébale alé wa'lula balé galílachi ra'pichí, 'lige alé asíbale sujkáliga re'obachi tebume 'yuga. Machináliga 'sílige chukumeli nílige Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","'Lige alué e'wélala balé 'lige suwábaga alué uché jaré e'wélala, pe najkigá nokale churigá 'la níligo gastigárilia, 'lige me'liá alué Esusi. Alekeri owile jaré testigo pe 'yégali ra'íchame. ");
INSERT INTO tacNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","We'ká ralámuli ra'íchale Esusi e'chéwaga, pe 'yega ra'íchale, tabilé chátiri nile napu anile alué 'yégame, alekeri tabilé umébale me'á. 'Lige abé i'libeko alemi jsile oká rió ");
INSERT INTO tacNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","napu anile: ―Ye rioka aniéturu: «Neka na'minámala alué wa'lú re'obá Onorúgame galila, 'lige bakiá rawé kachi uchéchigo bilé newámala ne.» ");
INSERT INTO tacNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","'Lige o'weti ilísaga alué wa'lula balé rukele Esusi: ―¿Tabilé aké mué napu aní mué e'chéwaga? ¿Tabilé pe'tá nejé mué? ¿Chongá lanilí mué alué ralámulite? ");
INSERT INTO tacNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","'Lige Esúsika pe i'kilí ilile tabilé nejega. 'Liko alué wa'lula balé anele: ―Alué Wa'lula Onorúgame alué napu ajagá ajtí, 'we a'lá e'negá ajtí, alekeri 'we a'lá ra'ichálime júkuru 'la bijchiga 'we a'lá ruyéwagó ramué, ¿pala 'la Kristo ka mué, alué napu Onorúgame Inolá ju? ");
INSERT INTO tacNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","'Lige Esúsika anele: ―Ju, aka mué 'we a'lá ma'chígime aníché, 'lige aminami aní ne etemio 'emi alué napu nile Onorúgamete julárigame 'pa rewagáchika napurigá rió neraga, alé wajtoná ajtígame napu ajtí Onorúgame wa'lú a'walí nígame. 'Lige aminami abiena etémala 'emi ku 'pákana rewigáchikana nolíraleka enágame. ");
INSERT INTO tacNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","'Liko alué wa'lula balé banasuka chi'wánale bo'né o'páchala, regá anigá: ―¡Ye rió tabilé niráchine Onorúgame! Ya 'ma 'we a'lá sébali akirúke'é, tase rokáré uché bilé rió testigo. 'Émi 'we a'lá akékuru tabilé 'la niráchinio Onorúgame ye rió Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","'Émika ¿choniágó? 'Lige alué we'ká ralámulika anile: ―Me'liáté alué rió alanime. ");
INSERT INTO tacNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","'Liko bulele buichí bilé ba'nisólite, 'lige a'kachípale banachí 'lige wejpale sekate banachí ");
INSERT INTO tacNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","regá anegá: ―Mué Kristo, ruwíbá, ¿chieri ka napu mué wejpá? ");
INSERT INTO tacNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Loliachi Esusi, Pégroka alé ma'chige asale ra'pichí, 'lige alemi nawile bilé mukí go'ame newame, 'lige regá anele: ―Muéchigó Esusi 'yuga eyéname kéturu alué Esusi Galilea anilichi bejtégame. ");
INSERT INTO tacNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","'Lige alué Pégroka 'yégale regá anigá suwábaga akériga: ―Neka tabilé machí chonigá anió mué. ");
INSERT INTO tacNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","'Lige Pégroka alemi yochi ilíbale, ma'chimi simea enale, 'lige uché bilé mukí etele, 'lige alué mukíchigó anele alué alemi yochi jágame: ―Ye rió abiena Esusi 'yuga eyéname kéturuchigó, alué Nasareno anilime. ");
INSERT INTO tacNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","'Lige alué Pégroka uchéchigo 'yégale, regá anigá: ―Neka 'la bijchiá aní. Neka tabilé machiáwé alué rió. ");
INSERT INTO tacNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","'Lige pe'tá nujubapi alué ralámuli napu alemi jale a'bemi jábale napu ilile Pegro, 'lige anele: ―Mueka Esusi 'yuga eyéname kánkoke'é, napugiti mueka napurigá alué galileo ralámuli ra'íchame kame. ");
INSERT INTO tacNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","'Lige Pégroka yati regá anile: ―Neka 'la bijchiá aní. Neka tabilé machiáwé alué rió. Onorúgame ne'chí gastigárimala tabilé bijchiá anisáká ne. A'lígerikáchi sinale o'tolí. ");
INSERT INTO tacNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","'Liko alué Pegro nélále napu anílige Esusi rapakónala alí. Esúsika anélige alué Pegro: «Ta'chó sinachi bilé o'tolí, baisá animela mué tabilé machiórió mué ne'chí.» 'Lige alué Pegro ma'chínale alé 'minami, 'lige nalale 'we chálagá. ");
INSERT INTO tacNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Napu'lige che'lisá, suwábaga balé e'wélala, 'lige alué e'wélala ralámuli jurío nuleme, 'we a'lá anile Esusi me'limea. ");
INSERT INTO tacNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","'Lige 'ma bulugá o'tóleru 'lige sontálochi nejíleru, alué Ponsio Pilato sontálola. Alué Ponsio Pilátoka pe wa'lula selígame nile Rómaka julárigame. ");
INSERT INTO tacNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Napu'lige Jurasi, alué napu Esusi nejílige, etesa Esusi me'libólikó, asíriga seweka asíbale ala'síkariká, 'ma ku 'yale alué baisá makué ijchirúlime enomí plata alué e'wélala balé 'lige alué e'wélala ralámuli jurío nuleme. ");
INSERT INTO tacNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","'Lige Jurasi anele: ―Ne bo'né 'we resí 'síleke'é. Nejíleke'é ne bilé rió peka chojkila kachi napurigá me'liboa. 'Lige alué e'wélalaka anile: ―Ramueka pecha che aniágó alieti, mué bo'né machíliké. ");
INSERT INTO tacNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","'Liko alué Jurasi alé re'obachi pachá 'lule alué enomí, 'lige 'ma simile gujtachí ojaga mukumea. ");
INSERT INTO tacNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","'Liko alué balé e'wélala 'wile alué enomí, 'lige anile: ―Pecha 'la júlkó alé gajónichi ajchilía ye enomí, napu ralámuli mochime ju enomí Onorúgame kogia, ye enomika pe bilé rió me'lináliga najtétarigime kame. ");
INSERT INTO tacNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","'Lige 'we a'lá anigá ejtebile napurigá bilé we'é ralimea a'boi, 'lige alué we'eka «Sikolí Newalichi» anilime rewégame nile. Alué we'é ralale ralámuli tomia alé Rusaleni suwígame, alué napu tabilé alé ejperégame nílige. ");
INSERT INTO tacNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","A'lígesí «Elá We'é» anilime ju alué we'é. ");
INSERT INTO tacNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Alarigá sébali oláleru napurigá anílige alué Jeremíasi napu ruwime nile napu Onorúgame anélige. Regá anile alué Jeremíasi: «Alué e'wélala israelita unele alué enomí baisá makué ijchirúlime enomí plata, napu alué najtegala nile, ");
INSERT INTO tacNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","'lige alué enomite ralálekuru alué we'é Sikolí Newálichi. Alarigá nuláleturu alué Wa'lula Onorúgame.» ");
INSERT INTO tacNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Esusi Pilato ajtígichi o'tóleru. Alué Pilátoka wa'lula selígame nile. 'Lige rukéleru Esusi: ―¿Mué ju wa'lula ralámuli jurío nuleme? 'Lige nejele: ―Alarigá ju napurigá mué aní. ");
INSERT INTO tacNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","'Liko napu'lige alué e'wélala balé 'lige alué e'wélala ralámuli jurío nuleme, sairúgame neraga ra'ichasa alué Esusi olagá, Esúsika tabilé nejele. ");
INSERT INTO tacNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Alekeri alué Pilato anile: ―¿Tabilé aké mué suwábaga napu aní mué olagá sairúgame neraga? ");
INSERT INTO tacNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","'Lige Esúsika abiena tabilé nejele. 'Liko alué selígameka pe i'kilí ilíbale. ");
INSERT INTO tacNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pe nabí bamí alarigá sime nile alué wa'lula selígame piesta nerúgichi Páskua anilime, bilé rió ma'chí pame nile galírale bajchárigame, alué napu 'la ikí ralámuli napurigá ma'chí pápua. ");
INSERT INTO tacNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","A'lígerikáchi ajtile bilé rió galírale bajcháriga 'lige ralámuli 'we machime nile alué rió. Barabasi anilime nile alué rió galírale bajcháriga ajtígame. ");
INSERT INTO tacNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","'Liko napu'lige 'ma suwábaga ralámuli napuíka mochígichi, alué wa'lula Pilato rukele suwábaga ralámuli chieri 'la ka ma'chí pasía. Regá anile: ―¿Chieri 'la nerago 'émika napurigá ma'chí pápua, Barabasi o Esusi, alué napu Kristo anilime ju? ");
INSERT INTO tacNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","'Lige alué Pilato 'we a'lá machile alué e'wélala jurío nokáligo Esusi nejía pe Esusi gichiga. Alekeri 'we a'lá 'nátale churigá su'panamio Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Bijí Pilato gustisia olá ajtígichi, alué mukí Pilato 'yula nulale napurigá anewa: «Tase che olawa alué Esusi, alué rioka pecha chojkila júkó. Neka asíriga resí nílaturu alué rió remuka be'áruko rukó.» ");
INSERT INTO tacNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","'Lige alué e'wélala balé, 'lige alué e'wélala ralámuli jurío nuleme, 'we anele ralámuli napurigá alué ralámuli 'we anémala Pilato napurigá ma'chí pámala Barabasi, 'lige aminami napurigá Esusi me'liboa. ");
INSERT INTO tacNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","'Lige alué selígame uchéchigo siné rukele alué we'ká ralámuli: ―¿Chieri 'la niti káréko napurigá su'panawa? 'Lige ralámulika anele: ―¡Barabasi! ");
INSERT INTO tacNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","'Lige Pilátoka anile: ―'Lige Esúsika, alué napu Kristo anelime ju, ¿cholámala ne? 'Lige suwábaga nejele: ―¡Alueka gulusichi ujchigá me'libógurú! ");
INSERT INTO tacNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","'Lige Pilátoka rukele: ―¿Chonigá? ¿Tachiri najsabúgime kékó? Ralámulika pe abisibi bochí aniá jale tabilé akeme neraga: ―¡Me'liboa gulusichi ujchigá! ―anile. ");
INSERT INTO tacNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Napu'lige Pilato etea tabilé e'wamio alué ralámuli, aminacho boichí aniá jago, 'liko pe'tá ba'wí tale 'lige alué ba'wite panígile alué bo'né sekala napurigá suwábaga ralámuli etémala. 'Lige anile: ―Neka tabilé chojkila nímala ye rió me'lisuga. 'Emi a'boi chojkila nímalaké ―anile panígiga. ");
INSERT INTO tacNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","'Lige ralámulika anile: ―'We a'lá ju alarigá, gastigo nerúlasaká, ye rió me'lisuga, ramué narépuli júkuru, 'lige ramué 'kúchilatiri abiena narémili júkuru alué gastigo. ");
INSERT INTO tacNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","'Liko alué Pilato 'ma ma'chí pale Barabasi, 'lige nulale napurigá Esusi wejpisópua, 'lige 'ma lisensia nejile napurigá gulusichi ujchigá me'liboa. ");
INSERT INTO tacNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","'Liko alué selígame sontálola 'ma o'tole Esusi alé napu mochime ju alué sontalo, 'lige alé suwábaga sontalo noligá napuíle napu ilílige alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","'Lige 'ma bujele o'páchala, 'lige uchéchigo bilé o'pacha sejtákame we'lí ujchele. ");
INSERT INTO tacNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","'Lige aminami bilé gorona wejchégame mo'kótale mo'chí. 'Lige bilé baká wajtoná sekachí cha'pírale, alué baká napurigá bilé resó wa'lula uneme nile. 'Lige sontáloka chojkóbisiga jábele alé a'bé napu ilile alué Esusi, 'lige asíriga gawélele. Regá anele: ―¡Kuira wa'lula ralámuli jurío nuleme! ");
INSERT INTO tacNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","'Lige aminami a'kachípale. 'Lige alué baká 'wile, 'lige alekete wejpale mo'ólachi. ");
INSERT INTO tacNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","'Lige 'ma alarigá gawélesa, 'liko 'ma bujele we'lí o'pacha sejtákame, 'liko bo'né o'páchala o'pachátirile. 'Liko 'ma o'tole me'limea gulusichi ujchigá. ");
INSERT INTO tacNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Napu'lige simiba e'yéniga, boichimi bilé rió najtépale. Alué rió Sirene anilichi we'ká riógichi bejtégame nile. 'Lige alué rioka Simoni rewégame nile. 'Lige alué sontáloka alué rió nulele napurigá gulusí majtóramala napu Esusi ujcháwili nile. ");
INSERT INTO tacNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Alarigá sébale alé rabó Gólgota anilichi (napu aniame ju «Anayáwali Mo'ola»). ");
INSERT INTO tacNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","'Lige alé 'yáleru Esusi i'wilí ba'wila pee a'wágame 'we chijpúgame na'lóriga. (Alué ba'wílaka nile napurigá tabilé o'kómala alué Esusi.) Chébale Esusi chu'álachi alué ba'wila, nobi Esúsika tabiléchigo chunurúlekó. ");
INSERT INTO tacNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Napu'lige Esusi 'ma gulusichi ujchásiga, alué sontáloka i'taga re'ele. «¿Chieri meta Esusi o'páchala?» anile. ");
INSERT INTO tacNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","'Lige abajá mochile Esusi repuka alué sontalo. ");
INSERT INTO tacNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","'Lige alé napu Esusi mo'ega chujkule re'pá amóbige ujchale bilé rabileta osirúgime, napu ruwime nile chonigá me'lílirugo Esusi, regá anime nile: «Yeka Esusi júkuru Wa'lula Rey ralámuli jurío nuleme.» ");
INSERT INTO tacNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","'Lige abiena uchucháliru gulusichi oká chigórigame, bilé wajtoná ujcháleru napu Esusi chujkule 'lige bilé o'iná. ");
INSERT INTO tacNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ralámuli alé a'bemi simáriga mo'loka, asíriga chátiri ra'íchali ra'íchale Esusi olagá. ");
INSERT INTO tacNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Regá anile: ―Mué júkuru alué wa'lú re'obá na'minámili, 'lige bakiá rawé kachi uchéchigo siné ku newámili júkuru mué. Bo'nepi nejkúriwaguru. 'La Onorúgame Inolá níriká, 'ma re'kísiwaguru alé gulusichi. ");
INSERT INTO tacNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Abiena a'chigóriga gawélile Esusi alué balé e'wélala, 'lige alué Moisesi nila nulalí benírame, 'lige alué ralámuli napu nuleme nile ralámuli jurío. Regá anile a'boi ra'íchaga: ");
INSERT INTO tacNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Alueka uché jaré buyánale chátiri bowechi, alué bo'népika tabilé gayena gu'iria. Wa'lula nísaká israelita nuleme 'la re'kísimala ke alé gulusichi, a'liko 'la bijchígiwimpá ramué Onorúgame júlaligo. ");
INSERT INTO tacNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Alueka anime ke Onorúgame 'we a'lá gu'írame ko, jípeko Onorúgame gu'írimalaké, aluéchigo bo'né koriame Onorúgame Inolá. ");
INSERT INTO tacNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","'Ma alué chigórigametiri napu gulusichi uchule abiena gawélele Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","'Liko rawilírikáchi 'ma chóniga ilíbale bochígimi gawichí, 'ma nasípagana enegá ku rayénale alué rayénali, ");
INSERT INTO tacNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","'lige 'ma abé alírikáchi ta'chó ma'chígichi, Esusi e'wele ne'ole bo'né ra'ichálila ra'íchaga. Regá anile: ―Elí, Elí, ¿lama sabáktani? Yeka pe aniame nile, «O'nó Onorúgame, O'nó Onorúgame, ¿chonigá bi'neli a'répaché mué ne'chí?» ");
INSERT INTO tacNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","'Lige jaré anile alé a'bemi jáginti akisá: ―Ye rioka baigá aní alué napu ruyame nílige napu Onorúgame anélige, alué 'ya bejtégame napu Elíasi anilime nílige. ");
INSERT INTO tacNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","'Lige bilé rió alé a'bemi ilígame, yati iwégame 'male bilé chiní nolamia, 'lige sa'nabáchale i'wilí ba'wila chijpúgame, 'lige iguchi ujchale alé re'pá Esusi chu'álachi chébimia, napurigá Esusi chunurúmala alué i'wilí ba'wila. ");
INSERT INTO tacNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","'Lige uché jaré ralámuli anile: ―A'réwagó, pala nawara Elíasi napurigá gu'írimala. ");
INSERT INTO tacNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","'Lige Esusi uchéchigo siné sinale asíriga a'wágame. 'Liko 'ma mukule. ");
INSERT INTO tacNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","'Liko aba'lige napu'lige e'wele sinale Esusi, alué wa'lú chiní napu wa'lú re'obachi chujkúgame nílige, 'ma chi'wale oká neraga nílale. 'Pákana chi'wale, wamí 'légana si. 'Lige gawítiri abiena nokale, 'lige rejté e'wele 'ma gajsile. ");
INSERT INTO tacNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","'Lige 'ma i'púriga jábale alé napu bi'tile suwígame. 'Lige asíriga we'ká ralámuli suwígame ku ajánele, alué napu Onorúgame oyérame nílige. ");
INSERT INTO tacNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","A'kinana 'ma Esusi bajchá ajánasa, 'lige alueka asíriga we'ká riógachi mo'ile alé Rusaleni anilichi, 'lige alé we'ká ralámuli etele. ");
INSERT INTO tacNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","'Liko alué gapitani 'lige sontálotiri napu Esusi repuka mochílige, napu'lige etesa gawí nokao, 'we majale 'lige anile: ―'La bijchiá Onorúgame Inolá nílekuru ye rió. ");
INSERT INTO tacNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","'Lige asíriga we'ká umugí jale alé mejkabeka e'negá. Alué umugika Esusi oyérame nile alé ejiro Galilea anilíchika sígame, 'lige aminami gu'írame nile. ");
INSERT INTO tacNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Bilé mukí María anilime nile Magalena bejtégame. 'Lige uchéchigo bilé mukí María anilímechigó, Santiago eyela 'lige Osétiri. 'Lige uché bilé mukí Sebereo 'kúchila eyela nile. ");
INSERT INTO tacNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Napu'lige 'ma alí kachi, bilé rió sébale 'we nígame enomí José anilime rió. Arimatea anilichi we'ká riógichi bejtégame nile alué rió. Alué rioka abiena 'we oyérame nile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","'Lige Pilato e'nemia simile, 'lige tánale Esusi mukúgame. 'Lige Pilátoka yati lisensia 'yale. ");
INSERT INTO tacNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","'Liko Joseka yati o'tole alué Esusi mukúgame. 'Lige 'we a'lá chiní rosákame bi'wígamechi kabile, ");
INSERT INTO tacNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","'lige rekale bilena ewachi napu rekáwili nile bilé mukúgame, napu bo'né nulálige newániliga abé i'bé alé bilena wejtosá rejtechi. 'Lige 'ma 'yérasa alé yochi bilé wa'lú rejtete, 'liko 'ma simile. ");
INSERT INTO tacNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","'Lige María Magalena bejtégame alé asale e'negá, 'lige uchéchigo bilé María abiena asale alé, alé 'na o'weka ewachi neraga mochile napu rekáleru alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Melénala rawé sawalachi, napu'lige resíbame nile alué ralámuli jurío, alué e'wélala balé 'lige bariseo, simíbale alué Pilato 'yuga ra'ichamia. ");
INSERT INTO tacNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Regá anele: ―Mué Wa'lula, néláruke'é alué rió 'yégame napu aniá anié: «A'kinana bakiá rawé kachi ku ajánamala ne.» Alarigá anime kéturu napu'lige bijí ajagá asigá. ");
INSERT INTO tacNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Alekeri nulawa mué repúniliga bakiá rawé alé napu gatéliru Esusi, napurigá tabilé smela alué oyérame rukó chigomia alué Esusi mukúgame, napurigá tabilé animela ralámuli abé i'libeko: «'Ma ku ajánale.» 'Liko alué 'yégali abéchigo enátiri nímala, me'tigá alué 'yégali napu ra'íchale abijí ajagá asigá napu'lige anile, «Kristo ju ne.» ");
INSERT INTO tacNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","'Lige Pilátoka anele: ―'Liko jaré sontalo 'yuga simáwagó, 'lige asíriga 'la repúpua alé napu bo'í alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","'Lige simíbale 'lige sebasa bile tábiri ujchele alé resochí yochi napu 'yérigame nile, machináliga pala ta'wesi i'pura yochi. 'Lige sontáloka abajá a'réleru tebuka. ");
INSERT INTO tacNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Napu'lige simírasa alué rawé resíbilichi pe kulí rajpé siné che'limechi romíkichi, alué María Magalena anilime 'lige uchéchigo bilé María, 'mi ewachi simíbale e'nemia. ");
INSERT INTO tacNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","'Lige yati neraga nokale gawí. 'Lige bilé santo ánjeli Onorúgame 'yuga nóchame re'kínale 'pákana rewagáchika, 'lige alé ewachi sebasa 'ma bujele rejté alé yochi ajtígame, 'lige amoba rejtechi asíbale. ");
INSERT INTO tacNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","'Lige alué santo ánjeli napurigá u'kí ne'wime aliena ra'ósame nile, 'lige o'páchalaka napuyeri gepá aliena rojsákame nile. ");
INSERT INTO tacNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","'Lige alué sontalo, alué Esusi tebúkame, 'ma 'áwale majaga. 'Lige napurigá suwígame alarigá bi'tíbale. ");
INSERT INTO tacNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","'Lige alué santo ánjeli anele alué umugí: ―Tase majawa, neka 'la machí 'emi Esusi 'yaga e'yenio, alué napu gulusichi ujchigá me'lílirige. ");
INSERT INTO tacNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Alueka pecha bo'íkó jena, alueka 'ma uchéchigo narélekuru a'walí napurigá ku ajagá asimela jena wijchimoba, napurigá bo'né anílige 'ya. Aka jeka simáwabala e'newa napu bo'ílige. ");
INSERT INTO tacNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","'Lige yati simáwaká kumi, 'lige anéwaká alué oyérame: «Alueka mukúlekuru kaka nobi 'máchigo ku ajagá ajtíkó. 'Lige simela alé Galilea anilime ejiro alé buwemia, alé etémaleké 'emi.» Pe ye ra'íchilicho ruimeo oláturu ne. ");
INSERT INTO tacNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","'Liko alué umugí yati ku simíbale asíriga iwégame napurigá majame neraga, 'lige 'we ra'sálagá e'yénale. 'Lige asíriga iwégame júmale ra'íchali ruyemia alué oyérame. ");
INSERT INTO tacNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","'Lige 'ma e'yénale napu'lige Esusi ma'chínale alemi napu e'yénilige alué umugí, 'lige Esusi repórale alué umugí. 'Lige alué umugika a'bé nawile alué Esusi asíriga 'la neraga gomurule chajpáchigana. ");
INSERT INTO tacNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","'Liko anile Esusi alué umugí olagá: ―Tase majawa. Yati simawa ne'chí oyérame ruyewa napurigá Galilea anilichi ejiro simámala, 'lige alé etémalawé ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Bijí boichimi e'yénigichi alué umugí, jaré alué sontalo napu tebume nílige alé napu Esusi bo'ílige 'mi we'ká riógichi simíbale. 'Lige ruyele alué e'wélala balé alakíligo 'mi alé. ");
INSERT INTO tacNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","'Liko alué e'wélalaka simíbale ruyemia alué e'wélala ralámuli jurío nuleme, napurigá 'la ra'ichamia a'bopi chonokimeo. 'Lige asíriga we'ká enomí najtétiliru alué sontalo. ");
INSERT INTO tacNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","'Lige anéleru: ―Anéwaká ralámuli rukechi: «Okoka bi'tirúgichi, alué Esusi oyérame 'ma chigole alué Esusi mukúgame.» ");
INSERT INTO tacNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","'Lige alué wa'lula selígame Pilato machisáká, 'liko ramuéchigó 'we a'lá ra'íchawa alué wa'lula selígame 'yuga, napurigá tajché anewa 'emi, 'lige 'émika tabilé che olawa. ");
INSERT INTO tacNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","'Liko natétisiga alué sontalo, 'ma simíbale alarigá ra'ichamia napurigá anélirige. Alarigá ruwime júkuru juríoka jipe rawé si. ");
INSERT INTO tacNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","'Liko alué makué bilé Esusi 'yuga járome, 'ma simíbale alé Galilea anilime ejírochi alé bilena rabó napurigá anélige Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","'Liko napu'lige sébale alé Esusi e'nemia, asíriga 'la galegá etele. 'Lige jaré aba tabilé 'cho 'me 'la machile pala 'la bijchiá Esusi ko. ");
INSERT INTO tacNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","'Liko Esusi a'bé nawile alué oyérame, 'lige anele: ―Onorúgameka a'walí 'yákuru ne'chí napurigá nulámala ne bochígimi 'pa rewagachi, 'lige aminami jemi wijchimoba. ");
INSERT INTO tacNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Napu'lige simásiga 'emi alé napu suwábaga chojkégame ralámuli mochí, 'la benírawaká churigá ka ne'chí oyérilia. Rewaráwaká alué ralámuli napurigá 'la machimela churigá ko O'nó Onorúgame, 'lige alué Onorúgame Inolá, 'lige alué Onorúgame Alawala. ");
INSERT INTO tacNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","'Lige 'la benírawaká napurigá 'la sébali olámala napu ne nuligé. 'Lige neka senibí asimela 'emi 'yuga, napusí suwiba gawí. Pe ikí képá ye ra'íchali. Wa'lú cheliérabá.");
INSERT INTO tacNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ye ju semátiri ra'íchali napu ruwime ju alué nóchali Esukristo nochálila, alué napu ju Onorúgame Inolá. ");
INSERT INTO tacNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Peba alarigá o'wínale ye ra'íchili 'we 'ya napurigá chujkú jena apélichi napu Isaíasi anilime rió osale, alué rió napu ruyame nile napu anele Onorúgame. Isaíasi regá anime osale: Alemi julámala ne bilé rió ne'chí gu'írame bajchabé neraga napurigá 'la o'wé jawámala ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Alué rió 'we e'wele ra'ichámala jami tabilé riógichi, napu 'we wakígame gawí ju. Alué ralámuli alé sebámala napu ajtí alué bo'né, 'lige regá animela: «'La bi'ígame 'nata mochiwa, 'ma pe 'we nawámala Wa'lula.» Alarigá osale alué rió Isaíasi. ");
INSERT INTO tacNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","'Lige alakile napurigá anile ye ra'íchili, nawale alué Onorúgame gu'írome, Juani anilime rió. 'Lige chojkile rewará, alé ba'wichí jáwaga. Anele alué ralámuli 'ma a'réwagó alué chátiri 'nátili 'lige rewaráwagó napurigá Onorúgame 'la e'kámala. ");
INSERT INTO tacNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","We'ká rawé nokale simiba we'ká ralámuli Rusaleni mochígame 'lige we'kaná riógichi mochígame alé napu nile Jurea anilichi ejiro ra'íchili akimea Juani ra'ichálila 'lige akisá alué ra'íchili 'lige ruwile 'we resítiri 'nátili 'nátame ko alué a'boi ralámuli. 'Lige Juánika rewarale suwábaga alué ralámuli napu ekí e'kali tánele Onorúgame alé napu ename ju wa'lú ba'wí Jorani anilime bakochi. ");
INSERT INTO tacNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juánika o'páchigime nile kameyo anilime ajágame gupala newárigimete, 'lige wi'chí wajsíbalagame nile, 'lige ojchí go'yame nile, 'lige jami nerúgame ijampre ba'wila abiena go'yame nílechigó. ");
INSERT INTO tacNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","'Lige regá anime rejcholi ruyele suwábaga ralámuli: ―Pe abé i'libeko nawámala bilé rió abé najtékame me'tagá ne'chí. Neka pe abé u'tabela ju, napurigá bilé pioni alarigá ju ne. Napu'lige sebasa alué abé najtékame, 'we a'lá niraga etémala ne alué rió. ");
INSERT INTO tacNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Neka pe rewarákuru suwábaga 'emi. Alué wa'lúlaka abé semá 'símala. Alueka Onorúgame Alawala nejímala napurigá 'émichi mochímala bejtega alué Onorúgame Alawala. ");
INSERT INTO tacNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","A'lige bilé rawé napu'lige Juani rewará ilígichi, Esusi nawale alé Galilea ejíroka simigá. Simile alé napu Juani ilile. A'lige Juánika rewarale alé napu ename ju wa'lú ba'wí Jorani anilime bakochi. ");
INSERT INTO tacNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Napu'lige ma'chínasa Esusi ba'wichika, etele ewagá ilíbago rewagá, 'lige etele Onorúgame Alawala 'pákana enágichi napuyeri bilé baloma neraga. ");
INSERT INTO tacNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","A'lígerikáchi anile Onorúgame 'pa rewagáchika: ―Mué ju ne Inolá. 'We galé ne mué. 'We ganíliga ajtí ne mué 'yuga ―anile Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","A'lige pe yati Onorúgame Alawala o'tole Esusi bilénami jami 'we wakígichi tabilé rojégichi 'lige tabilé riógichi. ");
INSERT INTO tacNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Esusi alé 'mi asale oká liá rawé. 'Lige Satanasi (Remónisi) alemi nawile 'yégimia napurigá Esusi 'la e'wímala Satanasi. Esúsika tabilé e'wile. A'lige napu'lige Esusi alé jami tabilé riógichi ajtígichi, alé napu 'we nerú tábiri ajágame jobátigame, Onorúgame júlale we'ká santo ánjeli napurigá Esusi gu'íromala. ");
INSERT INTO tacNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Galírale bajcháliru alué Juani, 'lige a'kinana Esúsika ku Galilea ejiro anilichi simile, 'lige ra'íchale alué a'lala Onorúgame nila ra'íchali. ");
INSERT INTO tacNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Regá anile: ―'Ma seba raweli napu sebámili nílige napurigá Onorúgame nulámala ralámuli alawálachi napurigá e'wámala ralámuli. A'resi alué resítiri 'nátili, tase cha nokiboa. 'La bijchígiwaká alué ra'íchili 'we a'lá semátiri Onorúgame nila ra'íchili ―anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Esusi enale bilena ba'wichí suweke, we'lesi manígime ba'wí Galilea anilime. 'Lige oká rió ro'chí e'mume etele. Alué oká rió wa'lú morali iwíate newárigime o'kame, 'lige alué morálite i'mua uchule ro'chí. Bilé Simoni anilime nile 'lige uché bilé Antresi anilime nile, Simoni bonila. ");
INSERT INTO tacNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Esusi regá anele alué oká rió: ―Nabá ne'chí 'yuga, ralámuli napabúniliga nulémala ne 'emi. ");
INSERT INTO tacNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Pe yati simíbale alué ralámuli Esusi 'yuga alué wa'lú morali ro'chí wejiame alé a'resa. ");
INSERT INTO tacNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","A'lige Esusi simile uché rajpé. 'Lige pe kulí e'télimi enagá Akobo najtépale 'lige Juani síchigó napu Sebereo 'kúchila nile okánika. Alé bárkochi mochile alué ralámuli ku mo'yea alué morali ro'chí wejiame napu chi'wale. ");
INSERT INTO tacNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","'Lige Esusi yati bayérole alué oká rióchigó. 'Lige yati simíbale okánika 'ma alé a'resa a'boi onolá Sebereo anilime alué bo'né nóchame 'yúriga. ");
INSERT INTO tacNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Esusi 'lige alué 'yuga járome sébale 'lige alé Kapernaumi anilichi. 'Ma sébachi resíbulichi rawé, Esusi bajkile alé bilena u'tá re'obachi «sinagoga» anilime, 'lige ra'íchale Onorúgame ra'ichálila. ");
INSERT INTO tacNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ralámulika pe i'kilí mochíbale e'negá napu'lige ra'íchachi Esusi, 'wéchigo 'la semáriga ra'íchaligame, 'we a'lá benegá, tase napurigá alué Moisesi nila nulalí beníriame. Esúsika 'la Onorúgame a'walílate ra'íchame nile. ");
INSERT INTO tacNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Bilé rió asale alé pachá u'tá re'obachi, alué rioka chátiri alawá ajchágame nile, 'lige alué chatiri alawá e'wele ne'oka ra'ichárile alué rió: ");
INSERT INTO tacNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―Mué Esusi Nasareta anilichi ajtígame Rabí rijimala, mueka pe nejkumemia nawale. ¿Mueka nawapa ramué me'limea? Ne 'la machí Onorúgamete wanápurigame ko mué ―anile alué rió chátiri alawá ajchágame. ");
INSERT INTO tacNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","A'lige alué Esúsika a'wágame ne'óchale alué chátiri alawá, anele: ―¡Kilí asá! ¡Yati ma'china ye riochi! ");
INSERT INTO tacNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","A'lige alué chátiri alawá alué rió wijchí rekábale 'we rawaruka chi'poka bo'írale alué rió. Alué chátiri alawá iwégame sinaka ma'chínale alé riochi. ");
INSERT INTO tacNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Suwábaga ralámuli napu ekí e'negá jale pe i'kilí jábale. 'Lige regá rukegá jale a'bopi: ―¿Chieri júché ye rió? Tabilé siné akirume kéturu sineko ye tétili. 'La semáriga ra'íchanti júkuru 'la benegá. Alueka 'la wa'lula neraga nulame ju ne'óchiga alué chátiri alawá, 'lige 'la e'weme ju alué chátiri alawá. ");
INSERT INTO tacNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","'We yati akele suwábaga ralámuli Galilea anilichi ejiro ejperégame, ala'síligo Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Napu a'lige buyasa alé u'tá re'obachi «sinagoga» anilime, Esusi simile Akobo 'yuga 'lige Juani 'yúgachigó napu ejperégame nile Simoni 'lige Antresi. ");
INSERT INTO tacNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simoni wasila 'we iná bo'ile. Napu'lige Esusi sebasa yati ruyéleru 'we nayua bo'igá Simoni wasila. ");
INSERT INTO tacNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","A'lige Esusi a'bemi nawile, sekala cha'pigá o'weti ajchale. A'lige yati sa'wile alué mukí. Sa'wisá yati go'ame newale napurigá Esusi 'lige alué Esusi 'yuga járome go'mela. ");
INSERT INTO tacNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Napu'lige rayénali bokuíchi, 'ma chónachi, suwábaga ralámuli alé riógichi mochígame napaíle alé yochi napu Esusi ajtile. 'Lige a'pili ralámuli, nayúkame a'pagá jsile, 'lige abiena ralámuli u'kuchípala remónisi mochígame. ");
INSERT INTO tacNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Esusi sa'wale suwábaga nayúkome, 'lige abiena buyánale alué chátiri alawá. Esusi tabilé a'rele napurigá ra'ichámala alué chátiri alawá, alué chátiri alawá 'la machíligame chieri ko alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Be'á amulí che'lachi, bijí chóniga ilígichi, Esusi asísiga simile 'miná mejká tabilé riógichi napurigá ta nejkumémala ralámuli ra'ichálichi Onorúgame 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","A'lige napu o'mochísisa Simoni 'lige alué uché jaré Esusi 'yuga járome, simíbale Esusi 'yamia. ");
INSERT INTO tacNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Napu'lige rewisá, regá anele: ―We'ká ralámuli mué 'yaga e'yena. ");
INSERT INTO tacNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","A'lige Esúsika anile: ―Nabá jarénami riógichi napu ta'mé mejká ju. 'La ruyema olá néchigó alué ralámuli Onorúgame nila ra'íchili. Alekeri nawá ne jena wijchimoba. ");
INSERT INTO tacNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","A'lige Esusi bochígimi eyénale Galilea anilichi ejiro, 'lige napu ekiná u'kuchí re'obachi «sinagoga» anilime sébaga ruwile Onorúgame nila ra'ichálila, 'lige buyánale suwábaga chátiri alawá napu ekí ajchágame nile we'ká ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Bilé rawé bilé rió 'we chátiri nayume «lepra» anilime, alé a'bé simile napu Esusi ajtile, 'lige chojkóbisiga ilíbale, 'lige anele: ―Mué bo'né 'la machílike pala 'la umubátiká ye nawilí sa'wá napurigá 'la eliwa ne alé u'tá re'obachi bajkichi. ");
INSERT INTO tacNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Esúsika 'we na'temale alué rió, 'lige sekate nochale 'lige anele: ―Neka najkí napurigá sa'wimela mué. ");
INSERT INTO tacNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Pe alanisá alué Esusi, yati sa'wile alué rió. ");
INSERT INTO tacNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Bajchabé ta'chó simichi, rejcholi ruyele Esusi alué rió, regá anele: ");
INSERT INTO tacNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Tabilé 'wesi ralámuli ruyewa ne 'síligo sa'wá mué. 'Mi alé simibóaká napu ajtí alué balé napurigá 'la machimela 'ma tabilé nayume ko mué, 'lige go'ame kógiwaká Onorúgame napurigá nulale Moisesi, napurigá suwábaga ralámuli machimela 'ma tabilé nayume ko mué, napurigá 'ma 'la eliwa mué napurigá 'la bajkimela alé u'tá re'obachi. ");
INSERT INTO tacNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","'Lige simile alué rió. 'Lige alué rió tabilé e'wale napurigá anélirige Esúsite. Pe ruwile bochígimi riógichi eyénaga 'ma sa'wigá nayua. Alekeri Esusi mejká tabilé riógichi asale we'ká rawé napurigá tabilé 'wesi ralámuli etémala. Esusi tabilé najkile napurigá we'ká ralámuli sebámala alé Esusi e'nemia. Rekó 'mi alé ajtígichi, we'ká ralámuli sébale. ");
INSERT INTO tacNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","A'kinana rawé Esusi uchéchigo nawale alé we'ká riógichi Kapernaumi anilichi, 'lige suwábaga ralámuli akele ku alé riógichi ajtigó Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","'Lige we'ká ralámuli napaíle alé galírale napu ajtile Esusi. We'ká ralámuli jsile, 'ma bochí ilíbale alé pachá napusí tabilé gainárume ju alemi nasípami simírilia. 'Lige alé ma'chige si abiena we'ká ralámuli jale, 'ma tabilé ganárume alé yochi bajkiá. Onorúgame nila ra'íchili beniria ilile Esusi alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Napu'lige Esusi ra'icha ilígichi, naó rió jsile bilé sujígame majtoga bilena tabachi rekagá. Alué nayúmeka tabilé gayéname nile ronola noká. ");
INSERT INTO tacNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tabilé gayénale mo'yá alé napu Esusi ilile, cha we'ká rioga ilíligame alé. A'liko arigá alé galimopa o'tole alué nayume, 'lige alé galimopa ewarale napu ilile Esusi ra'íchili ruyá, 'lige alégana re'kibule alué nayume bilé gemachi rekagá, alé napu ilile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Napu'lige Esusi etesa alué ralámuli alanokachi, 'la bijchigio alué ralámuli, a'lige anele alué nayume: ―Mué re'malí, ya 'ma e'kárigime ju mué alué chátiri 'nátili ―anele. ");
INSERT INTO tacNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Alé mochile jaré rió Moisesi nila nulalí beníriame. Alué akele alanichi Esusi. A'lige alué Moisesi nila nulalí beníriame regá 'nátale: ");
INSERT INTO tacNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Alué Esúsika pe Onorúgame gawéliga aní alaniá. Pe Onorúgameka 'la e'kámaleké resítiri 'nátili.» Alarigá 'nátale alué Moisesi nila nulalí beníriame. ");
INSERT INTO tacNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Esusi 'la machile alarigá 'nata mochígichi alué ralámuli. Alekeri regá anele: ―Tabilé 'la 'nata mochí 'emi, 'émika 'nata Onorúgame gawéliga anió ne. ");
INSERT INTO tacNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Chieri abé nóchali kame ju, e'kalia o 'yolia? ¿Regá anilía: «'Ma e'káragime ju mué», o regáchala: «O'weti asá, ro'miná mué gemala 'lige simigá ku galírale»? ");
INSERT INTO tacNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Jipe 'la machimela 'emi, ne napu ju Onorúgamete julárigame 'pa rewagáchika napurigá rió neraga 'la nígame ju ne Onorúgame a'walila 'lige lisensia nígame ju ne napurigá e'kámala apiépiri ralámuli. A'lige Esusi anele alué nayume: ");
INSERT INTO tacNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―O'weti ilísiwa, ro'miná mué alué gemá 'lige simigá ku galírale ―anele. ");
INSERT INTO tacNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","A'lige alanésiga alué nayume, pe yati sa'wile, 'lige ma'chínale gemá majtoga. Suwábaga ralámuli napu ekí mochílige alemi, pe kilí mochíbale napurigá majágame neraga, 'we ra'sáláme kéréle abiena rekó kilí mochige napurigá majame. 'Lige anile: ―¡Uja, 'la wa'lú ju Onorúgame! ¡Tabilé siné etérige ramué aliena semátiri nóchali newachi alué napu eteru jipe! ―anile. ");
INSERT INTO tacNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","A'kinana uché simile Esusi alé wa'lú ba'wichí suweke Galilea anilichi. Pe yati we'ká ralámuli napaíle alé, 'lige Esúsika benírale Onorúgame nila ra'íchili. ");
INSERT INTO tacNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","'Lige alemi etele bilena galírale bilé rió enomí gobilala ajtigó, enomí napu napubúlime nile alué wa'lula rey romano i'lime, 'lige alué rioka Lebí anilime nile, Alipeo anilime rió inolá. 'Lige Esúsika regá anele: ―Nabá, muéchigó ne'chí 'yuga ilírome niwa. 'Lige Lebí ilísale, 'lige simile Esusi 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","'Lige a'kinana rawé Esusi 'lige Esusi 'yuga járome bayéleru napurigá simámala go'mea Lebí bejtélachi. A'lige rawé we'ká napu nóchame nile enomí gobilalia, enomí napu nejílime nile, 'lige uché jaré ralámuli napu cha nokame nile, alé mochile go'yá Esusi 'yuga 'lige alué Esusi si járome 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jaré Moisesi nulalila beníriame 'lige jaré bariseo abiena mochile alé, 'lige anele alué Esusi 'yuga járome: ―Alué Esusi tabilé go'meli júkuru alué enomí goblálome 'yuga, 'lige nibilé alué uché jaré ralámuli cha nokame 'yúgachigó ―anele. ");
INSERT INTO tacNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Esúsika akele alanichi, 'lige anele: ―Bilé 'yome ka, nayúkame 'yome júkuru, tase tabilé nayume. Neka a'chigóriga 'sime júkuru. Neka gu'írimia nawákuru suwábaga napu ekí 'la machí resítiri raweli nígame ko a'boi. Alué 'we a'lá bi'ígame alawégame korime ka, alué alieri ralámulika tabilé gu'írimala ne. ");
INSERT INTO tacNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Bilé rawé Juani 'yuga járome 'lige jaré alué bariseo ayuna mochígichi, 'lige jaré ralámuli jsile alé napu ajtile Esusi, 'lige anele: ―¿Chonigá ta ayuna mué 'yuga járome ka? Juani 'yuga járome 'lige bariséochigó suwábaga alueka 'la ayuna ―anele. ");
INSERT INTO tacNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Esúsika regá nejele: ―Napu'lige bilé rió newichi, ralámulika tabilé ayúname ju alué rió 'yuga mochiga. 'Ma tabilé ajtígachi alué rió, a'lige kulí ayunámala. 'Lige alarigá nokiame niru ramué. Ne 'yuga járome ka tabilé ayúnachigó jipe, ");
INSERT INTO tacNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","nobi pe 'we nawámalagó ne saíla ne'chí o'tomea, a'lige kulí 'la ayunámala suwábaga alué ne 'yuga járome. ");
INSERT INTO tacNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","› Ne 'yuga járome ne nila rejcholi oyérame nísaká, 'lige 'ya nerúgame rejcholi oyérame nísachigó, pe napurigá chiní pachókime nímala napurigá pachokia bilé chiní o'chérame bilé nuebo chinite. Tabilé 'la ju alarigá sukia, bilé chiní nuéboká 'we cho'yome kame 'lige abéchigo we'lesi chi'wame ju alé napu pachókirige. ");
INSERT INTO tacNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Abiena regá anile Esusi: ―Pe i'wilí ('uba) ba'wila rekútume ro'linti kárélamala bilena o'chérame chiliwílachi wi'chite newárigime. Alué i'wilí ba'wila rekútume pe kulí ro'árigame ka chiliwílachi wi'chite newárigime asíriga a'wágame ronome ju, 'lige alué wi'chí chiliwila o'chérame nísaká 'ma chi'wame ju 'lige 'ma go'lime ju alué i'wilí ba'wila rekútume, 'lige alué chiliwílaka 'ma pe chi'wámala. Pe kulí newalime i'wilí ba'wílaka 'la nuebo chiliwílachi wi'chite newárigime ro'lime ju ―anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Bilé rawé resíbilichi, Esusi simírole bo'né 'yuga járome 'yuga bilena ri'ligó echégichi. Alé sebasa, alué Esusi 'yuga járome ka ri'ligó mulalá rejpúniga mosika go'ale. Jaré bariseo etele alanokachi alué Esusi 'yuga járome. ");
INSERT INTO tacNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Alué bariséoka anele alué Esusi: ―E'né chonoká noká mué 'yuga járome. 'Ya mochígame nulale napurigá tabilé alarigá nokiboa resíbilichi rawé. ");
INSERT INTO tacNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","A'lige Esúsika anele: ―Tabilé siné akenti ka aniání 'emi aleké ra'íchili napurigá 'sile alué 'ya ajtígame Rabí anilime rió e'lowika. ");
INSERT INTO tacNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Alué rioka bajkile Onorúgame galílachi napu'lige Abiata anilime wa'lula kachi alé Onorúgame galílachi, 'lige go'lé alué baní napu Onorúgame kógilime nile. Tabilé lisensia nile napurigá go'mela bilé rió napu tabilé balé nile, pe alué balecho 'la nígame nile lisensia napurigá go'mela alué baní. Nobi Rabika arigáchigo go'ale ko rekó tabilé balé ke, 'lige nachútaga go'ale alué napu bo'né 'yuga oyame nílige. ");
INSERT INTO tacNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","'Lige aminami regá anele: ―Onorúgameka newale alué rawé resíbilime napurigá gu'írowa ralámuli, tabilé nejile napurigá gastigáririgame neraga mochiwa. ");
INSERT INTO tacNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ne, Onorúgamete julárigame 'pa rewagáchika napurigá rió neraga, ne ju nulame resíbilichi rawé. ");
INSERT INTO tacNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","A'kinana uché bilé rawé resíbilichi Esusi simile alé u'tá re'obachi «sinagoga» rewégame. Alé asale bilé rió sujígame sekégame. ");
INSERT INTO tacNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jaré bariseo alé jale e'negá pala 'yoa sita aniá. Tabilé lisensia nile napurigá 'yowa bilé nayume resíbilichi rawé, alarigá anime nile alué ralámuli jurío nulalila. Esusi alué nayume 'yósaká a'liko alué bariseo yati ruyema olale e'wélala napurigá Esusi gastigáriwa. ");
INSERT INTO tacNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","A'lige alué Esúsika anele alué sujígame sekégame: ―Jeka simí. Jena nasipa ilí. ");
INSERT INTO tacNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","A'lige Esúsika rukele bariseo: ―¿Choní 'emi nila nulalí? ¿Chu'simía 'la ju resíbilichi rawé? ¿Tachiri abé a'lá ju, ralámuli nayúkame sa'walía o tabilé sa'walía chalá? ¿Cha 'sika enalia o tabilé cha 'sika enalia? ¿Gu'írilia o me'liá? Bariséoka pe i'kilí jábale tabilé pe'tá ra'íchiga. ");
INSERT INTO tacNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","'Lige Esúsika 'we ayole alué bariseo 'yuga, 'lige 'we seweka ilíbale machisá tabilé na'temao alué uché jaré ralámuli alué bariseo. 'Lige Esúsika anele alué sujígame sekégame rió: ―Wajchiná mué alué seká. A'lige alué rió wajchínale sekala sujígame. 'Lige yati sa'wile. ");
INSERT INTO tacNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Napu'lige etesa alué alieti yati ma'chimi simíbale alué bariseo. A'lige napaíle alué bariseo, 'lige jaré alué ralámuli jurío napu nirame nile alué wa'lula Eróresi anilime, 'lige 'we a'lá suériga ra'íchale churigá 'la nítikó Esusi me'liá. ");
INSERT INTO tacNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Bilé rawé Esusi simile bo'né 'yuga járome si alé wa'lú ba'wí manígichi Galilea anilichi. 'Lige we'ká ralámuli Galilea ejiro mochígame najátale. ");
INSERT INTO tacNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Napu'lige Esusi ajtígichi alé, jsile we'ká ralámuli Jurea anilichi ejiro mochígame, 'lige Rusaleni anilichi we'ká riógichi mochígame abiena jsílechigó, 'lige Irumea anilichi ejiro mochígame abiena jsílechigó, 'lige Jorani anilichi bakochi na'lebo baona mochígame abiena jsílechigó, 'lige Tiro anilichi we'ká riógichi mochígame abiena jsílechigó, 'lige Sironi anilichi we'ká riógachi mochígame abiena jsílechigó, machíligame 'we a'lá 'yóome ko Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Esusi we'ká nayúkome sa'wale, alekeri noli rajkibuga uchútale alué ralámuli Esusi nochániliga sa'wináliga. 'Liko anele alué Esusi bo'né 'yuga járome: ―Senibí 'la 'nátaga mochiwa 'la ujchugá bilé barko. Siné kachi we'ká napuísa ralámuli bárkochi 'moma ne ―anile. ");
INSERT INTO tacNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Alemi jálechigó jaré ralámuli napu chátiri alawá ajchágame nile. Napu'lige sebasa alé a'bé napu Esusi ilile, alé napu Esusi ilile o'wemi neraga, alué chátiri alawá wijchí 'lule alué ralámuli 'lige a'wágame ra'íchale: ―¡Mué ju Onorúgame Inolá, napu re'pá rewagáchika nawale! ―anile. ");
INSERT INTO tacNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","'Lige Esusi 'we anele napurigá tabilé ruwimela chieri ka bo'né. ");
INSERT INTO tacNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Abé alí Esusi simile bilena rabó bo'né 'yuga járome si. ");
INSERT INTO tacNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Alé sebasa alué ralámuli, makué oká owile bo'né napurigá 'la nabí bo'né 'yuga járome nímala Onorúgame ra'ichálila beniria. ");
INSERT INTO tacNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Abiena 'la 'yale a'walí napurigá 'la buinámala chátiri alawá napu ajchágame nile jaré ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ye ju napu nile alué makué oká rió napu Esusi 'yuga járomili nile nabí: Simoni, napu Pegro anilime rewá 'yáleru Esúsite, ");
INSERT INTO tacNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jakobo 'lige Juani, napu Sebereo inolá nile okánika, napu Boanérjesi anilime rewá 'yáleru okánika Esúsite. Boanérjesika aniame ju «ralámuli jobátigame». ");
INSERT INTO tacNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","'Lige abiena Antresi, Belipe, Bartolomé, Mateo napu Lebí anilime nile siné abé 'yako, Romasi 'lige Santiago, napu Aripeo inolá nile, 'lige Tareo, 'lige uché bilé Simoni, alué napu 'we a'lá benégame nile ra'íchaga ralámuli gu'íriga (siné kachi nekoga oyame níligeréko), ");
INSERT INTO tacNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","'lige Jurasi Iskariote, alué napu Esusi saíla neraga ilíbale a'kinana rawé. A'lige pe yati ku sébale bilena galírale Esusi alué makué oká rió 'yuga, alué napu bo'né 'yuga e'yéname nílige. ");
INSERT INTO tacNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Uchéchigo we'ká ralámuli napaíle. Tabilé cherigá ikírole Esusi go'ame go'yá 'lige alué bo'né gompaniérolachigó, cha we'ká rióligame. ");
INSERT INTO tacNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Napu'lige alué Esusi chega rijimala machisá we'ká ralámuli jsíligo alemi alué Esusi ajtígichi, alué rijimálaka yati o'tomé olale. Anile: ―'Ma lo'iro alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","'Lige jaré Moisesi nila nulalí beníriame sébale Rusalénika simíbaga, 'lige alueka anile: ―Alué Esúsika pe Remónisi alawala ajchágame ju, alué wa'lula remónisi Belsebú anilime, 'lige alué 'sime ju a'walí 'ya napurigá alué Esusi 'la buinámala alué chátiri alawá napu mochígame ju jaré ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","A'lige Esúsika bayele alué Moisesi nila nulalí beníriame, 'lige ruyele bilé ra'íchili oká tétili ruwime. Anile: ―Alué wa'lula remónisi tabilé buyáname ju alué chátiri alawá napu pe bo'né 'yuga járome ju. ");
INSERT INTO tacNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Bilé selígame 'lige bo'né 'yuga járome 'ma na'áwasa a'bopi, tabilé we'lisi napuíka nochámala. ");
INSERT INTO tacNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Onolá 'lige 'kúchila 'ma na'áwasa, tabilé we'lisi anachámala 'kúchila alé mochiga onolá 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Alarigá ju Satanasi ra'ichálilachigó. Satanasi wa'lula tabilé nulame ju napurigá buinawa alué chátiri alawá napu jaré ralámuli niga mochí. Pe alué bo'né nulésaká napurigá ku buyásimala alué chátiri alawá, a'liko 'ma najsuímala alué Remónisi nochálila. Tabilé we'lisi anachámala alué Satanasi wa'lula asagá. ");
INSERT INTO tacNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","› 'We a'lá na'tawa napurigá animela ne jena. Bilé rió chigónilisa bilena galírale bilé a'wágame rió bejtélachi, bulumeli júkuru bajchá a'lige kulí 'la umubámala chigoa. A'chigóriga 'smíkuru ne, 'ma bulékuru ne alué wa'lula Satanasi. Alekeri 'la buinámala ne alué chátiri u'kuchípala alawá napu mochí alé jaré ralámulichi. ");
INSERT INTO tacNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","› 'La gepusi napu ruwimela ne jipe. Onorúgame 'la anáchame ju napu'lige ralámuli Onorúgame gawéliga ra'íchachi, Onorúgame 'la e'kame ju alarigá ra'íchachi alué ralámuli, 'la Onorúgame tánasaká alué ralámuli napurigá e'kámala, ");
INSERT INTO tacNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","nobi neruko jaré abé chátiri ra'íchili napu Onorúgame tabilé ganílime ju napu'lige alarigá ra'íchachi ralámuli, 'we chátiri ra'íchili ju napu'lige ralámuli anichi pe Remónisi alawala ko napu ralámuli nayúkome sa'wao napu'lige pe Onorúgame Alawala kachi napu ralámuli nayúkome sa'wá. Onorúgame tabilé e'kame ju alué alieri ra'íchame ralámuli rekó alué ralámuli Onorúgame tanie napurigá e'kámala. ");
INSERT INTO tacNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Alarigá anele Esusi alué ralámuli 'yuga ra'íchaga, Remónisi alawala ajchágame koríligame Esusi olagá alué e'wélala napu Moisesi nila nulalí beníriame nile. ");
INSERT INTO tacNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","A'lige pe yati sébale Esusi eyela 'lige jaré napu nile Esusi nasípasi waíla 'lige nasípasi bonila. Tabilé chérigá sebasa nílile Esusi ajtígichi, cha we'ká ralámuli mochíligame, a'lige pe ma'chika jábale. ");
INSERT INTO tacNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","'Lige júlale jaré ralámuli Esusi bayéniliga. 'Lige alarigá machile ralámuli alé ma'chika iligó alué Esusi eyela 'lige jaré alué Esusi bonila 'lige waíla. 'Lige regá anele alué ralámuli napu mochile alé a'bé pachá galírale napu ajtile alué Esusi: ―Mué eyela alé ma'chika ilí 'lige mué bonila alé ma'chika jáchigó 'lige mué waíla alé ma'chika ja chigó, mué 'yaga e'yena. ");
INSERT INTO tacNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","'Lige Esúsika nejele: ―Jipe 'la animé ne chieri ka ne eyela, 'lige ne waíla, 'lige ne bonila. ");
INSERT INTO tacNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","'Lige e'nénaga alemi noligá mochígame, anile: ―Jena mochí ne eyela 'lige ne bonila 'lige ne waíla. ");
INSERT INTO tacNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Suwábaga napu 'la bijchiá Onorúgame oyérame ju, alueka napurigá ne bonila ju, 'lige napurigá ne waíla, 'lige napurigá ne eyela, alarigá etewá ne suwábaga alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Uché bilé rawé Esusi o'wínale beniria Onorúgame nila ra'íchili ba'wichí suweke, alé wa'lú ba'wí manígichi Galilea anilichi. We'ká ralámuli napaíle alé ba'wichí suweke. Alekeri Esusi tabilé ga ra'íchale, arigá alé bárkochi 'mole 'lige pe abé rokógichi o'tole alué barko alé asagá ra'ichamia, 'lige alué ralámulika pe alé suwé rejpile. ");
INSERT INTO tacNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","'Lige alé bárkochi asagá rejcholi ruyele ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","'Lige anele: ―'We a'lá gepusi. Bilé rawé bilé rió weroka echale ri'ligó, ");
INSERT INTO tacNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","'lige jaré alué talí weroka echerúgime boichimi rujsule, alueka 'ma chulugí go'ale. ");
INSERT INTO tacNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","'Lige jaré alué talí rujsule alé bilena i'pichí napu tabilé ru'nágame we'é ajtígichi, alueka aba'lá yati ya'wile, ");
INSERT INTO tacNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","nobi péchigo abiéniko wakíbale ko sawala 'lige nawálatiri, pe abiéniko wakíbale tabiléchigo 'la a'wágame nawégame níligame. ");
INSERT INTO tacNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","'Lige uché jaré alué talí rujsule napu alué we'ká nawala wejchá bi'tile, 'lige 'yale alué nawá, 'liko tabilé 'la semáriga ya'wile alué talí napu rujsule alé. ");
INSERT INTO tacNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","'Lige alué uché jaré alué talí rujsusa bilena napu 'we a'lá we'echi nile, alué talika 'we a'lá semáriga ya'wile. 'Lige alué ralámuli we'ká 'wile alué ri'ligó. ");
INSERT INTO tacNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","'Lige Esusi aminami anile: ―'La bijchiá beninálisaká 'emi Onorúgame nila rejcholi, 'liko 'we a'lá semáriga gepuwa napurigá aní ne. ");
INSERT INTO tacNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Napu'lige Esusi 'ma suwénasa ra'icha, napu'lige 'ma simasa amulí suwábaga ralámuli, alué makué oká bo'né Esusi 'yuga járome 'lige uché jaré ralámuli rukele alué Esusi: ―Ruwí, ¿chonime ke aní alué tétili? ");
INSERT INTO tacNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","A'lige Esúsika anele: ―'Emi 'la 'yáleru Onorúgamete lisensia napurigá 'la machimela churigá nuleo Onorúgame 'emi ralámuli, nobi mochí ko jaré ralámuli tabilé oyérame ne'chí, alué ralámuli tabilé 'la nirame, tabilé siné námamala. ");
INSERT INTO tacNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Alué ralámulika senibí e'negá jame ju nobi tabiléchigo siné eteme júkó alué 'we semátiri napu nejí Onorúgame. Alué ralámulika senibí gepua jame ju nobi tabiléchigo siné námame júkó napu aní Onorúgame nila ra'íchili. Yeka pe ruwime júkuru tabilé Onorúgame oyérame ko alué ralámuli. 'La námame nísaká alué ralámuli e'kali tánimili ju 'lige 'la e'káwili ju alué ralámuli Onorúgamete. ");
INSERT INTO tacNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Esusi abiena 'la ruyele alué ralámuli: ―¿Tabilé 'la nama 'emi ye ra'íchili? A'liko ¿churigá 'la inámamaché 'emi uché bilé ra'íchili rejcholi oká 'nátili ruwime? 'Lige ruyele choniame ka alaniá: ");
INSERT INTO tacNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","―Alué rió napu echale, alué rioka napurigá Onorúgame nila ra'íchili beníriame, alarigá júkuru. ");
INSERT INTO tacNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Napurigá ikí jaré ralámuli jipe, pe a'chigóriga ju napurigá ikile ri'ligó weroka echerúgime napu bowé bo'ígichi rujsule. 'Lige alué ralámuli akisá Onorúgame nila ra'íchili, yati neraga nawame ju Satanasi 'lige se'winátiri 'nátili 'yame ju napurigá alué rió yati we'kuámala Onorúgame nila ra'íchili. ");
INSERT INTO tacNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","'Lige napurigá ikí jaré ralámuli jipe, pe a'chigóriga ju napurigá ikile alué ri'ligó weroka echerúgime napu rujsule tabilé ru'nágame we'é chujkúgichi i'pichí. 'La gepume ju Onorúgame ra'ichálila 'lige 'la ganíliga oyérame ju nobi tabiléchigo we'lisi námame júkó alué a'lala rejcholi. ");
INSERT INTO tacNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Napu'lige e'karú anilía uché jaré ralámulite Onorúgame oyérame kóriká, yati seweka mochíbame ju, a'liko 'ma a'reme ju Onorúgame nila ra'íchili oyeria. ");
INSERT INTO tacNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","'Lige napurigá ikí jaré ralámuli jipe pe a'chigóriga ju napurigá ikile alué ri'ligó weroka echerúgime napu rujsule wejchá nawala bi'tígichi. Alué ralámulika 'we a'lá gepume ju Onorúgame nila ra'íchili, nobi senibí rawé 'we resí lagá e'yéname júkó e'karúgame tábiri, 'we nóchame ju pe 'nátaga churigáriga 'la we'ká enomígame gainátiká, 'lige churigá 'la we'ká e'karúgame nígame ganátiká. Pe alieti 'nátaga, 'ma tabilé 'nátame ju Onorúgame nila ra'íchili, 'lige tabilé siné sébili 'nátame gayéname ju. ");
INSERT INTO tacNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nobi uché jaré ralámulika se'winá ikí jipe, 'lige alué ralámulika a'chigóriga ikí napurigá ikile alué ri'ligó weroka echerúgime napu rujsule alué 'we a'lala we'é nerúgichi. Napu'lige ye ralámuli 'we 'la gepusa ye ra'íchili Onorúgame nila ra'íchili, 'we a'lá nirame ju, 'lige 'we a'lá ganíliga ejperégame ju senibí rawé, 'lige tabilé resílagá e'yéname ju we'ká e'karúgame tábiri. Alué ralámulika napurigá ri'ligó 'we a'lá o'chérigame, alarigá ju, 'we ganíliga ejperégame ju. 'Lige we'ká ralámuli 'la oyérame ju alué ra'íchili Onorúgame nila ra'íchili napu beníriame ju alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","A'lige anélechigó: ―'Lige apiépiri ralámuli bilé chojpé rajesa napurigá 'la ma'chílimala, tabilé o'pólime ju bilé sikolite, nibilé gojchílachi pachárale tabátale rekame ju, alué ralámulika bilena re'pami elame ju 'nalina napurigá 'la ma'chílimala. A'chigóriga júchigó ye ra'íchili Onorúgame nila. ");
INSERT INTO tacNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ye ra'íchilika osirúgime ju napurigá alué ralámuli 'la inámomala alué 'nátili napu tabilé inámome nile. ");
INSERT INTO tacNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","› 'La akeme níriká 'emi, 'la gepuwa ye ra'íchili ―anélechigó. ");
INSERT INTO tacNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","'Lige abiena anélechigó: ―'We a'lá gepusi napu animela ne jipe, 'émi 'we a'lá sébali olásaká napu 'la namo 'liko Onorúgame 'la gu'írimala 'emi napurigá 'la inámomala uché rajpé. ");
INSERT INTO tacNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","'Emi 'we a'lá sébali oyérasaká Onorúgame ra'ichálila 'liko 'la sébali inámomalachigó Onorúgame ra'ichálila. 'Lige ralámuli napu ekí 'we najsíname ka, Onorúgame tabilé gu'íromala alué ralámuli napurigá námamala cherajpé. ");
INSERT INTO tacNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","'Lige abiena anílechigó Esusi: ―A'chigóriga ju napu'lige Onorúgame nulechi ralámuli alawálachi a'chigóriga ju napurigá bilé rió echisá talí. ");
INSERT INTO tacNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","'Ma suwénasa echá, senibí alí gojchime ju alué rió echágame 'lige senibí be'á asísime ju. Alué talika ya'wisá abichilubi o'chera jame ju. 'Lige alué rió echágameká tabilé machime ju churigá o'chera jago. ");
INSERT INTO tacNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Pe alué we'é 'sime ju yaria alué talí echerúgime. Bajchá sawala ochérame ju, 'lige arigá 'ma muleme ju, arigá 'ma kilimi uláname ju alué ri'ligó. ");
INSERT INTO tacNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Napu'lige 'ma ulánasa, 'liko alué rió echágame 'ma 'wime ju alué we'ká ri'ligó. ");
INSERT INTO tacNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","'Lige anélechigó: ―¿Churigá ju Onorúgame nulechi ralámuli alawálachi? ¿Churigá ra'ichawa napurigá 'la a'chigóyéri nímala napurigá Onorúgame nulechi ralámuli alawálachi, 'lige napurigá 'la inámomala 'emi? ");
INSERT INTO tacNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Napurigá 'smi Onorúgame ralámuli gu'iria, pe alarigá júchigó napurigá alué a'lásini rakala napu 'we u'tá ju me'tagá ri'ligó rakala. ");
INSERT INTO tacNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Alué gilibá rakálaka 'we u'tá ju nobi 'wéchigo wa'lú ochérame júkó napu'lige ya'wisá, 'lige chulugí alé jsime ju kábimia. ");
INSERT INTO tacNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Esusi 'we ra'íchale rejcholi pe tétalite tabilé inámutume napu'lige Onorúgame nila ra'íchili beniria ralámuli napurigá 'nata mochímala chonime níligo alué rejcholi 'we nóchili kame inámalia. ");
INSERT INTO tacNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Pe alué bo'né 'yuga járomeka 'la ruyeme nile chonime níligo alué ra'íchili napu'lige 'oni ejtebisa. ");
INSERT INTO tacNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Aba'lige alí Esusi anele alué bo'né 'yuga járome: ―Jípeko bajoniwa ye wa'lú ba'wichí 'lebo 'nálige sebawa. ");
INSERT INTO tacNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","A'lige Esusi 'yuga járome ka jímole alé bárkochi napu Esusi ajtile. 'Lige ariosi anisá, simíbale alemi o'wépomi bajonimia. Aminami uché jaré barko e'yénale alemi. ");
INSERT INTO tacNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nasipa wa'lú ba'wichí enágichi alué barko, nolínale alué 'we a'wágame eká, asíriga re'pá ilírole ba'wí, wa'lú maníbale alé u'tá bárkochi, amulí bochile ba'wí alé bárkochi, 'lige amulí bokuíle alué barko re'lé ba'wichí. ");
INSERT INTO tacNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Esúsika gojchigá bo'ile. Alué 'yuga járomeka ajchale alué Esusi. 'Lige e'wele ra'íchiga anele: ―¡Mué Wa'lula! ¿Tabilé chélá mué rekó ye barko ba'wichí bokuíchi? ");
INSERT INTO tacNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","'Liko Esusi asísiga ne'óchale alué eká 'lige anele alué ba'wí asíriga re'pá ilírochi: ―¡'Ma tase ayowa mué ba'wí! ―anele. 'Lige yati 'ma tabilé ekale 'lige alué ba'wí tabilé ená 'sile. ");
INSERT INTO tacNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","A'lige Esúsika anele alué makué oká bo'né 'yuga járome: ―¿Chonigá aliena majáché 'emi? ¿'Emi tabilé 'cho 'la bijchigi Onorúgame 'la sébali nejkúrame ko? ―anele. ");
INSERT INTO tacNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Esusi 'yuga járomeka 'we majale. 'Lige pe a'bopi ra'íchale: ―¿Chieri júché ye rió? ¡Ba'wí 'lige eká 'la akérinti júkuru! ");
INSERT INTO tacNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","A'lige sébale aminá suwé, aleka 'ma Gerasa anilichi ejiro nile. ");
INSERT INTO tacNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Alé bárkochi re'kisa Esusi, bilé rió we'ká chátiri alawá Remónisi u'kuchípala ajchágame nawale. Alué rió bo'né bejtélachika simigá nawale, 'lige alué rioka napu suwígame bi'tí alé bejtégame nile. ");
INSERT INTO tacNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","'We lo'íriga eyénale alué rió, tabilé 'wesi umébale i'kilí ajchá karénate bulegá. ");
INSERT INTO tacNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","We'sá ajchárigame nile karénate bulegá ronola 'lige sekala, 'lige senibí 'ma rijpúnaga pame nile karena. Tabilé 'wesi tábiri nirale alué rió. ");
INSERT INTO tacNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Rukomi 'lige rawemi nabí eyéname nile napu bo'né bejtégame nile, panápuri eyéname nile sinaka ejeliga rejtete me'choga bo'né. ");
INSERT INTO tacNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Aleké rawé napu'lige Esusi etele mejkaka iligá, 'maga sébale alué rió 'mi alé napu Esusi ilile, 'lige chojkóbisiga ilíbale alé a'bé sébaga napu Esusi ilile. ");
INSERT INTO tacNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","'Lige alué Remónisi alawala ra'ichárile alué rió. E'wele ra'íchaga anele alué Esusi olagá: ―Mué Esusi, Onorúgame Inolá, ¿tachiri najkí mué ne'chí 'yuga? Tase nijkumewa ne'chí 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Alarigá anele e'wele ra'íchaga alué rió, regá anéligame alué Esusi alué we'ká remónisi u'kuchípala: ―Yati buyasi aleké riochi. ");
INSERT INTO tacNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","A'lige rukele Esusi alué rió: ―¿Cho anilime ju mué? 'Lige alué rioka anile: ―Neka Lejioni anilime ju, ramueka we'ká nírigime ―anile. ");
INSERT INTO tacNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","A'lige alué rió 'we tánale Esusi: ―¡Tase mejká juláwaka ramué! ―alarigá ra'ichárile alué we'ká u'kuchípala remónisi alué rió. ");
INSERT INTO tacNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Alé a'bemi we'ká uchule gowí gajsalá go'yá. ");
INSERT INTO tacNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","A'lige anile alué rió: ―Lisensia 'yawa ramué napurigá ramué mo'iboa alé we'ká gowíchigana. ");
INSERT INTO tacNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","A'lige Esúsika lisensia 'yale napurigá alué chátiri alawá mo'imela alé gowíchigana. A'lige alué chátiri alawá alué riochi buyásiga mo'ile alé we'ká gowíchigana. We'ká gowí uchule alé, amulí oká mili. 'Lige 'ma júmasele alé alué gowí. 'Le o'wékana juma mo'ibásale, ba'ichí rujsule, alé suwile si'lika. ");
INSERT INTO tacNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","'Lige alué rioka gowí neseme majaga júmasele ruyemia suwábaga ralámuli alé we'ká riógichi 'lige a'tabemi riógichi. We'ká ralámuli simíbale e'nemia alemi chukíliga alué gowí. ");
INSERT INTO tacNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","'Lige sebasa alué ralámuli alé napu Esusi ajtile, alemi etele 'ma 'la o'páchiga, 'ma 'we a'lá kilí ajtígame alué rió napu Lejioni rewégame korílige. Napu'lige etesa alué rió, 'we majale suwábaga alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Napu ekí mochílige alé napu'lige suwichi gowí, ruyele uché jaré ralámuli jsichi. ");
INSERT INTO tacNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","'Lige suwábaga alué ralámuli alemi sígame ayole Esusi 'yuga, 'lige anele: ―¡Mejká simigá! ―anéleru Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Napu'lige Esusi 'mochi ku bárkochi, alué napu Lejioni anilime kóríle, alué rioka si siminálioríle alué Esusi 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Esúsika tabilé a'rele napurigá si simela alué rió 'lige anele: ―Ku galírale simibógó, 'lige ruyéwaká mué rijimala 'we a'lá gu'írilirigo mué Onorúgamete 'lige 'we na'temáliru mué. ");
INSERT INTO tacNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","'Lige alué rió bochígimi simírale Rekápolichi ejiro ruyesia suwábaga ralámuli 'we a'lá gu'írilirigo Esúsite. 'Lige suwábaga napu ekí akele 'we ra'sálále 'lige tabilé námale napu 'sile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Napu'lige Esusi bajonisa wa'lú ba'wí ilígichi 'na bilena suwé, uchéchigo siné napaíle we'ká ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Bijí ajtígichi Esusi alé ba'wichí suweke, bilé rió sébale Jairo anilime, u'tá re'obachi nulame «sinagoga» anilime. 'Lige a'bé simile napu Esusi ajtile e'negá, chojkóbisiga ilíbale alé o'wemi. ");
INSERT INTO tacNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","'Lige anele: ―Ne malala 'we nayua bo'í. Amulí mukú. Nabá e'newa yati ne'chí 'yuga nocháwaká mué napurigá sa'wimela napurigá 'la we'ká bamí asimela ajagá. ");
INSERT INTO tacNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Esusi simile alué rió 'yuga, 'lige we'ká ralámuli simíbale Esusi 'yuga. Tabilé ga simile Esusi, cha we'ká ralámuli 'yéniligime boichimi. ");
INSERT INTO tacNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Bilé mukí enale alemi nasípami napu makué oká bamílige elá ma'china, nabí tabilé rejpúrile ma'china elá. ");
INSERT INTO tacNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","We'ká 'yome 'yole napurigá sa'wimela alué mukí, tabilé 'wesi umébale sa'wá, abéchigo rajpé resí ikime nile alué mukí 'yolia. Suwábaga enomí suwábale 'yome najtétiga. ");
INSERT INTO tacNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Alué mukí akele sa'wame ko Esusi, alekeri 'nátale: «Ne Esusi o'páchala pe nochasa sa'wiméréko ne», regá 'nátale alué mukí. 'Lige guwánaka simigá nochale Esusi o'páchala. ");
INSERT INTO tacNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","'Lige yati machile 'ma sa'wíliga bo'né, abisí tabilé ma'chínale elá. ");
INSERT INTO tacNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Aba'lige yati sayele Esusi, bo'né Esusi a'walílate bilé ralámuli sa'wáliga. Abajá ilíbale, 'lige gu'liga rukele ralámuli: ―¿Chieri nochá ne'chí o'páchala? ");
INSERT INTO tacNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","'Lige Esusi 'yuga járomeka anele: ―¿Chonigá rukéché mué chieri nocháligo mué o'páchala? Aliena we'ká rajchiga e'yénachi kachi ralámuli jena ―anele. ");
INSERT INTO tacNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","'Lige Esúsika abiena echúromi e'nena ilile machináliga chieri 'síligo nochá. ");
INSERT INTO tacNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Alué mukí 'we majaga chojkóbisiga ilíbale, 'áwalia ilile majaga, 'wéchigo 'la machíligame sa'wíliga bo'né. ―Ne 'siétigó mué nochá ―anile alué mukí alé iligá chojkóbisiga. ");
INSERT INTO tacNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","'Liko Esusi anele: ―Resía mué mukí, mueka 'we a'lá 'nátale 'la sa'wame ko ne. Alekeri Onorúgame 'la sa'wákuru mué. Jipe 'we ganíliga simiboa mué ku galírale, 'ma tabilé nayume kame mué. Tabilé uchéchigo siné ujchábamala mué ye nawilí. ");
INSERT INTO tacNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Napu'lige Esusi bijí ra'icha ilígichi alué mukí 'yuga, jaré rió jsile Jairo galílachika simíbaga, 'lige anéleru Jairo alué ralámulite: ―'Ma mukúpá mué malala, 'ma tabilé nejkumewa ―anele alé sigá. ");
INSERT INTO tacNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","'Lige Esusi, napu'lige alanichi alué ralámuli, anile: ―Jairo, tase che lawa, 'we a'lá niraga etewa ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","'Lige Jairo bejtélachi simile Esusi Jairo 'yuga, pe bakiá bo'né 'yuga járome 'yuga: Pegro, Akobo, 'lige Juani Akobo bonila. ");
INSERT INTO tacNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Esusi sébachi alé galírale, ralámuli nalá mochile, 'lige sinaka nalá 'ma mukugáriká ta tewé. ");
INSERT INTO tacNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","'Lige Esusi bajkile alé pachami. 'Lige anele ralámuli: ―¿Chonigá aliena nalá mochípeché 'emi? Alué ta tewé pecha mukugá bo'íkó, pe gojchigá bo'í. ");
INSERT INTO tacNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ralámulika pe achile alanichi Esusi. Ralámuli 'la machile mukugá bo'igó alué ta tewé. A'lige Esúsika ma'chí júlale ralámuli, a'lige simile alé napu bo'ile ta tewé, alué ta tewé o'nola 'yuga, eyélatiri, 'lige alué bakiá rió napu 'yuga járome nile. ");
INSERT INTO tacNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","'Lige alué ta tewé sekala cha'pile Esusi 'lige anele: ―Talita kumi ―anele arameo ra'íchaga napu ra'íchame nile Esusi. (Alueka pe anigá anile: «Mué tewé, asísiwa.») 'Lige alanésiga alué tewé, ");
INSERT INTO tacNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","pe abiéniko neraga o'weti asísile alué u'tá tewé makué oká bamígame, 'lige eyénale. 'Lige o'nola 'lige eyélatiri 'ma ra'sálále. 'Lige lale: «¿Churigá 'la ku ajcháleché ye tewé mukúgame?» ");
INSERT INTO tacNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","'Lige Esúsika anile: ―Tabilé 'wesi ralámuli ruyewa ye tewé ku ajánilirigo ne. 'Lige anílechigó: ―'La 'yasi go'ame ye tewé. ");
INSERT INTO tacNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","'Lige simíbale ku 'mi Esusi bejtélachi napu bejtégame nile re'malí, alué 'yuga járome abiena si 'yuga 'yénale. ");
INSERT INTO tacNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Resíbilichi rawé sebasa, simile u'tá re'obachi «sinagoga» anilime, Onorúgame ra'ichálila benírimia. We'ká ralámuli kilí mochile gepuga Esusi ra'íchachi. 'Lige ra'íchale rukigá a'bopi: ―¿Koche ma'chí páleché ye 'nátili? ¿Koche beníleché alueka alakí ra'íchili? 'We a'lá sa'wame ju nayúkome 'lige 'la ajalí 'yame ju suwígame. ");
INSERT INTO tacNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Tacha pe alué mesa newame ju, María ranala, Akobo ba'chila, José ba'chila, Jurasi ba'chila, 'lige Simoni ba'chílachigó? ¿Tacha jena riógichi mochí alué rió waíla? ―anile alué ralámuli. Tabilé niraga etele. ");
INSERT INTO tacNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","A'lige anile Esusi: ―Bilé rió napu ruyame ju napu ané Onorúgame 'we a'lá nirálime ju bochígimi riógichi, nobi alé we'ká riógachi napu ochérale tabilé 'la nirálime júkó, nibilé bo'né galílachi, nibilé bo'né rijimálate. ");
INSERT INTO tacNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Alekeri Esusi tabilé we'ká sa'wale alé napu bejtégame nile re'malí ka. Esusi pe u'kabi 'la 'yole sekate nochigá mo'ola. ");
INSERT INTO tacNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","'Lige Esúsika lale: ¿Chonigá ta bijchígiché ne ra'ichálila? 'Lige Esusi we'kaná riógichi eyénale Onorúgame ra'ichálila beníriga. ");
INSERT INTO tacNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","'Lige bilena sebasa, bayele alué makué oká 'yuga járome 'lige yati napaíle, 'lige a'walí 'yale napurigá 'la gainámala buyana alué chátiri alawá napu mochígame nile alué we'ká ralámulichi. Júlale oká riocho. ");
INSERT INTO tacNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Esusi anele: ―Arigá simáwaká, tabilé tábiri o'ká, tabilé go'ame o'ká, tabilé gemátiri, tabilé enomítiri, pe bilé gujsí resola o'ká simáwaká. ");
INSERT INTO tacNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tabilé o'ká simáwaká o'pacha, pe alué o'pacha napu o'páchaga e'yena 'emi, pe aluecho o'páchaga simáwaká. ");
INSERT INTO tacNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","'Lige abiena anélechigó: ―Napu'lige sebasa alé bilena we'ká riógichi, 'lige bayérisiga alé bilena riógichi, alé mochíwaká we'lisi. Uché jaré repárasa aminá uché jarena galírale, tase simáwaká. ");
INSERT INTO tacNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Sebasa bilena we'ká riógichi, 'lige tabilé 'wesi repárasa napurigá simámala 'emi alé bilena galírale o tabilé gepúnilisa napu ra'icha 'emi, a'liko sawéwaká we'é ronochí chujkúgame napurigá 'la machimela alué 'ma tabilé gu'írimio Onorúgame alué ralámuli, a'lige aminá simáwaká uché bilena we'ká riógichi. ");
INSERT INTO tacNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","A'liko simíbale alué Esusi 'yuga járome 'la ruyemia ralámuli napurigá 'la a'rémala alué resítiri 'nátili. ");
INSERT INTO tacNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","'Ma buyánale alué chátiri alawá alué ralámulichi mochígame. 'Lige jaré nayúkome aseite ujchéliru mo'ólachi 'lige alarigá sa'wale. ");
INSERT INTO tacNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Alué wa'lula Erore akele 'we semá 'sime ko Esusi 'wéchigo ruigá e'yénilagime suwábaga ralámuli 'we a'lá umébame ko Esusi nayúkome sa'wá. 'Lige anile: ―Alué rió Juani ju napu rewarame ke, alekeri 'we a'lá nígame ju a'walí 'lige 'la umébame ju sa'wá nayúkome. ");
INSERT INTO tacNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","'Lige jaréchigo anile: ―Pe Elíasi ju, alué napu 'ya ajtígame nile napu ruyame nile napu anele Onorúgame. 'Lige jaréchigo anile: ―Pe uché bilé rió ju napu ruwime ju napu ruwí Onorúgame, a'chigóyéri napurigá 'ya mochígame nílige. ");
INSERT INTO tacNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","'Lige Eróreka napu'lige akisá alanichi alué we'ká ralámuli, anile: ―Pe Juani ju alué rió, alué napu rewarame ke, napu ne nulagé mo'ola rijpunániliga. 'Ma ku ajánale ―anile. ");
INSERT INTO tacNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Aluéchigo bo'né Erore nuláligime cha'píniliga alué Juani abé 'yabé 'lige 'ma galírale bajchálige karénate bulugá pe alué Erore upila chojkila gite, napu Eroríasi anilime nile, napu Belipe upila nile bajchá. Alué Belípeka alué Erore ba'chila nile, se'nú eyégame nile Belípeka. ");
INSERT INTO tacNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Alué Juánika pe anélige alué Erore napu'lige 'ma bujesa alué ba'chila upila: ―¿Chonigá bujéché mueka alué mué ba'chila upila? Moisesi nulalila tabilé elá napurigá alarigá nokiboa. ");
INSERT INTO tacNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","'Lige alésíko alué Erore upila (napu Eroríasi anilime nile) 'we me'lináliga ilírome nile alué Juani eligá alué Erore tabilé elile napurigá me'limela alué Juani ");
INSERT INTO tacNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","napugiti alué Erore 'wéchigo majáligime alué Juani me'agá, Juánika 'wéchigo 'la rió níligame 'we a'lá Onorúgame oyérame. Erore 'we ganílime nile Juani si ra'íchaga nobi tabilé siné námame nile alué Juani ra'ichálila. ");
INSERT INTO tacNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","A'lige bamime nile Erore. Piesta newale, bayele e'wélala nulame, alué sontalo e'wélalachigó 'lige chéchigo jaré we'ká enomí nígame alé Galilea mochígame, abiena bayélechigó. 'Ma napaísa alé mochile go'yá. ");
INSERT INTO tacNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Alemi bajkile bilé mukí iwé alué mukí Eroríasi ranala, napu rió mochile alemi yawile alué mukí iwé. 'We ganílile alué we'ká rió alué iwé yawichi. Alué Erore anele alué iwé: ―Táwaká suwábaga tábiri napu najkí mué, ne 'la nejímala. ");
INSERT INTO tacNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Neka 'la bijchiga aní. We'é najkisúká nasípasi we'é nejímala ne napu nulame ju ne ―anele. 'Lige alué iweka tabilé nejega, yati simile eyela rukemia. 'Lige regá rukele: ―¿Tachiri tániwa alué wa'lula Erore? ");
INSERT INTO tacNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","A'lige eyélaka nejele: ―Juani mo'ola tániwagó. ");
INSERT INTO tacNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Alué iwé 'we yati ku nawale alé napu asale alué wa'lula Erore, 'lige anele: ―Neka najkí napurigá jeka a'pawa bejtólichi ajchagá alué Juani mo'ola, alué napu rewarame ju ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","'Lige Eróreka 'we seweka asíbale napu'lige alanisá alué iwé. Tabilé pe arigá rejpínale 'máchigo akéligime suwábaga ralámuli napu mochile alé go'yá piesta nerúgichi, 'la 'máchigo 'la sébili olámoríligame napu anélige bo'né, 'lige 'la sébili olale. ");
INSERT INTO tacNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Erore pe yati bilé sontalo júlale Juani mo'ola rejpunániliga. ");
INSERT INTO tacNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","'Lige alué sontáloka bajkile alé pachá galírale napu ajtile alué Juani galírale bajcháriga, 'lige Juani mo'ola rejpúnale, 'lige a'pale Juani mo'ola bilena bejtólichi ajchagá, 'lige alué mukí iwé 'yáleru alué Juani mo'ola, 'lige alué iweka eyela 'yale. ");
INSERT INTO tacNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Napu'lige machisá Juani 'yuga járome Juani 'ma me'lírigo, simíbale nolamia 'lige gatele bilena resochí newárigime napu gatélime nile suwígame. Alarigá me'líliru Juani. ");
INSERT INTO tacNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","'Lige alué makué oká Esusi 'yuga járome ku napaíle echúromi we'kaná riógichi e'yénasa Onorúgame nila rejcholi beníriga, ruwile suwábaga napu nokáligo alué a'boi 'lige napu 'yóligo, 'lige napu ekí beníriligo Onorúgame nila rejcholi. ");
INSERT INTO tacNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","We'ká jsile ralámuli. Jaré simíbachi uchéchigo jaré jsile, alekeri tabilé chérigá go'sá nílile Esusi 'lige bo'né 'yuga járomechigó. A'lige Esusi anele alué bo'né 'yuga járome: ―Nabá 'mi napu tabilé rió napurigá 'la ganíliga resíbupua. ");
INSERT INTO tacNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bilena bárkochi jímale 'lige alé mochiga simíbale resíbimia 'mi alé napu tabilé riole. ");
INSERT INTO tacNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nobi we'káchigo ralámuli etélekó simíbachi, 'lige machile kochiena simiba 'yénaligo. Bochígimi ejperégame ralámuli júmale ba'wichí suweke, bajchabé sébale alué ralámuli alé napu alué barko sebámili nílige. ");
INSERT INTO tacNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Napu'lige re'kínachi alué Esusi alé bárkochi 'ma we'ká rioga ilile, 'lige Esusi alué ralámuli etesa, na'temale, machíligame pe 'oni mochigo napurigá bo'á tabilé bo'éligime, alekeri benírile Onorúgame nila ra'íchili 'lige we'ká rejcholi. ");
INSERT INTO tacNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","'Lige abé alí bo'né 'yuga járome anile: ―'Ma alí ju, kulipi chonámala, jena tabilé i'té go'ame. ");
INSERT INTO tacNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Julawa ralámuli 'mimi riógichi napurigá go'ame ralimela napurigá go'mémpá. ");
INSERT INTO tacNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","'Lige Esúsika anele: ―'Emi 'yáwaguru go'ame. 'Lige Esusi 'yuga járomeka nejele: ―Asíriga we'ká enomí najkibóleké napurigá 'la umubawa alakí ralámuli go'yame go'ame ralá, napu ekí meme ju bilé rió osá naó mechá nóchaga ―nejele. ");
INSERT INTO tacNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","'Lige Esúsika anele: ―Rukéwagó ralámuli chekí baní nu'tugégame ka. 'Lige alué makué oká Esusi 'yuga járomeka simíbale rukemia, 'lige ku sébaga anele: ―Pe maligi baní o'kame ju ralámuli 'lige oká ro'chí 'yúriga. ");
INSERT INTO tacNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","'Lige Esusi nulele ralámuli napurigá mochímala 'mimi gajsalachi amoba, napurigá e'megami namó mochímala nasipa siento neraga, 'lige bilé siento neraga. ");
INSERT INTO tacNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","'Liko Esusi 'wile alué maligi baní 'lige alué oká ro'chí 'yúriga, 'lige o'weti rewagachi e'negá iligá 'lige cheliera 'yale Onorúgame. A'lige tabé chi'wánaga alué baní, 'yale alué bo'né makué oká 'yuga járome napurigá alué ralámuli kógimala. Abiena a'chigó olale alué ro'chíchigó, chi'wánale alué oká ro'chí 'lige ralámuli kógile. ");
INSERT INTO tacNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Suwábaga ralámuli bosaga go'ale alué baní ro'chí 'yúriga. ");
INSERT INTO tacNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","'Lige makué oká atabé bochile alué u'kuchí baní mojágame rasírigame ro'chítiri 'yúriga. ");
INSERT INTO tacNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Maligi mili rió nile napu alué baní go'ale 'lige ro'chítiri. Abiena go'ale we'ká umugí 'lige we'ká u'kuchítiri. ");
INSERT INTO tacNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","A'lige pe yati nulale Esusi napurigá alué bo'né 'yuga járome jímamala alé bárkochi 'lige júlale napurigá bajonímala alé wa'lú ba'wí ilígichi napurigá simámala alé Betsáira anilichi. 'Lige Esúsika abajá rejpile ralámuli kumi galírale julia. ");
INSERT INTO tacNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Esusi pe i'libeko simile re'pá bilena rabomi 'lige Onorúgame 'yuga ra'íchale. ");
INSERT INTO tacNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Napu'lige 'ma chonaso 'lige alué barko nasipa wa'lú ba'wichí enale, 'lige Esúsika bijí alé re'pá rabó ilile. ");
INSERT INTO tacNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","'Lige amulí che'lachi 'lige Esusi etele 'we nóchali olao alué barko o'toa alué bo'né 'yuga járome 'we a'wágame ekáligime, 'lige Esúsika simile ba'wichí amoba simigá tabilé a'kega bajonimia na'lebo tabilé asigá barko 'lige sébale napu alué bo'né 'yuga járome mochile bárkochi. ");
INSERT INTO tacNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","'Lige alué bo'né 'yuga járomeka majale alué Esusi etesa alé ba'wichí amoba enágichi. Mayele bilé mukúgame alawala ko 'lige bochí anile majaga. 'Lige Esúsika yati anele: ―¡Ne Esusi ju, tase majawa! ");
INSERT INTO tacNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","'Lige 'mole alé bárkochi Esusi, 'lige 'ma asíbale eká. 'Lige alué 'yuga járomeka 'nátale: «¿Churigá 'la yati asíbale eká? ¿Churigá 'la eyena ba'wichí amoba?» ");
INSERT INTO tacNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","'Lige aminami 'nátale: «¿Churigá 'la bosárile alakí ralámuli pe maligi banite 'lige oká ro'chite?» Alarigá 'nátale tabilé 'cho machíligame chieri ko Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Napu'lige sebasa wa'lú ba'wichí suwé alé napu Genesareta anilichi nile, alé a'rele chega alué barko. ");
INSERT INTO tacNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Napu'lige pe kulí re'kichi Esusi, suwábaga ralámuli alé ejperégame machile Esusi ko alué bárkochi re'kime. ");
INSERT INTO tacNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","'Lige ralámuli simíbale nayúkame nolamia echúrimi riógichi 'lige a'pale alemi napu Esusi eyénale, panápuri napu eyénale Esusi alemi a'pile nayúkame 'lige tánale Esusi napurigá nayúkame Esusi o'páchala nochámala. Suwábaga nayúkame napu ekí nochale Esusi o'páchala sa'wile nayua. ");
INSERT INTO tacNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Bilé rawé jaré bariseo 'lige jaré Moisesi nila nulalí beníriame a'bemi jábale napu Esusi asale, 'lige alué ralámulika Rusalénika jsílige. ");
INSERT INTO tacNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Napu'lige etesa tabilé panígisa go'yó go'ame alué Esusi 'yuga járome napurigá nokame nile alué a'boi, a'liko ruyele ayoga tabilé 'la ko alarigá nokiá. ");
INSERT INTO tacNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Bariséoka 'lige alué ralámuli Moisesi nila nulalí beníriame pe ralámuli jurío nile 'lige alué ralámuli panígime nile sekala napu'lige go'mea a'chigóriga napurigá nokame nile alué 'ya mochígame. Tase regá 'nátaga nokame nile: «Panígime nébá cha chóligame sekégame kame ne», pe eligá regá 'nátaga nokame nile: «Panígime neba go'mea, alarigá Onorúgame abichilubi 'la na'temámala ne'chí.» ");
INSERT INTO tacNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Napu'lige go'ame ralimea simasa ku sébaga yati panígime nile tabilé 'cho go'yá go'ame. 'We a'lá panígisiká 'la Onorúgame 'kúchila kolale a'boi 'la sébili olame kóriká. Aminami 'we a'lá pagome nílechigó bejtoli 'lige sikolí regá 'nátaga: «'We a'lá pagómala ne bejtoli 'lige sikolí, alarigá Onorúgame abichilubi na'temámala ne'chí», 'lige we'ká e'karúriga nokale napurigá nokame nile a'boi.) ");
INSERT INTO tacNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","A'lige bariseo 'lige alué Moisesi nila nulalí beníriame si rukele Esusi: ―¿Chonigá mué 'yuga járome ka tabilé panígisa go'áché, napurigá nokale alué 'ya mochígame ralámuli? ―anele. ");
INSERT INTO tacNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","'Lige Esúsika anele: ―'Émika 'we a'lá 'nátame kolale ke, peka alarigá nulame kachi Onorúgame. 'We a'lá bijchiá anile napu'lige rejcholi nejía 'ya alué Isaíasi alué napu ruwime nile napu anélige Onorúgame, alué regá osale: Ra'icha 'emi napurigá 'la nirame Onorúgame, nobi tabiléchigo Onorúgame 'yuga 'nátame kéréko 'emi. ");
INSERT INTO tacNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Rekó 'la piesta newae pecha 'la júkó pecha 'la Onorúgame 'yuga 'nátame ka 'emi, 'émika pe a'boi nulalila beníriame ju, 'lige 'la Onorúgame nulalila korime ju 'emi alué nóchili newagá. Ye rejcholi nejile alué Isaíasi. ");
INSERT INTO tacNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Alarigá ju 'emi bariseo 'lige 'emi Moisesi nulalila beníriame. 'Emi 'ma tabilé e'wame ju napu nulá Onorúgame, pe napurigá nokame ju 'emi a'boi, pe alueka 'la oyérame ju 'emi. ");
INSERT INTO tacNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Abiena anele Esusi: ―Gu'línaga ra'icha 'emi, 'ma a'rele 'emi Onorúgame nila ra'íchili, 'ma tabilé nirame ju 'emi Onorúgame nila ra'íchali, pe a'boi ra'ichálila 'la nirá 'emi. ");
INSERT INTO tacNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Alué Moisesi osale Onorúgame ra'ichálila 'ya, regá anime: ");
INSERT INTO tacNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","«'La niraga etéwaká mué bo'né o'nola 'lige eyélatiri. Bilé towí o'nola 'lige eyela saíla neraga ra'íchame, alué towika o'toboli ju me'liboa.» Alarigá anime osale Moisesi. ");
INSERT INTO tacNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nobi 'emi ralámuika beníriame júkó 'we a'lá kóriká tabilé gu'írilia bo'né o'nola, eyélatiri, 'emi 'we a'lá beníriame ju ralámuli napurigá animela: «Tabilé ni ne enomí, suwábaga napu ni ne alueka ‹korban› ju.» (Korban aniáká: «Onorúgame kógilime» aniame ju.) 'Lige anime júchigó 'emi suwábaga napu ekí alanime ka 'ma tabilé gu'írimili ju bo'né o'nola 'lige eyélatiri. ");
INSERT INTO tacNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Alarigá nokogá 'ma Onorúgame saíla neraga ra'icha 'emi, 'lige abiena uché jaré we'ká ra'íchali benime ju 'emi, alué ra'íchali Onorúgame tabilé galeme ju ―anele Esusi alué bariseo 'lige alué Moisesi nila nulalí beníriame. ");
INSERT INTO tacNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","A'lige Esusi ralámuli bayele, 'lige anele: ―'We a'lá gepusi ye ra'íchili. Ta'lá námota 'emi. ");
INSERT INTO tacNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Bilé rió chóligame sekégame ka, alueka tabilé resítiri alawégame kérélamala. Bilé rió pe charigá 'nátaga 'lige chárigá ra'íchaga resítiri alawégame ju. ");
INSERT INTO tacNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","'We a'lá beninálisiká 'we a'lá gepuwa napu aní ne ―anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pe'tá i'libeko Esusi ralámuli a'rele, 'lige galírale bajkile. 'Lige alué bo'né 'yuga járomeka 'we rukele napurigá Esusi ruwimela chonime ke aníliga Esusi napu'lige alaniá. ");
INSERT INTO tacNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","'Lige Esúsika anele: ―¿'Émichigó tabilé namo napu aní ne? ¿Tabilé machí 'emi tabilé go'ame ko napu ralámuli resítiri alawégame newá? Go'ame ka tabilé resítiri ju. ");
INSERT INTO tacNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Go'ame ka pecha sulachí asíbame júkó. Go'ámeka pe rojpachí asíbame ju 'lige ma'chíname ju. (Alarigá anile Esusi, Onorúgame tabilé resítiri neraga eteo ralámuli rekó pe apiépiri go'ame go'yachi ralámuli.) ");
INSERT INTO tacNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Esúsika abichilubi ra'íchale 'lige anile: ―Ralámulika resítiri gayéname ju we'ká e'karúgame 'nátaga 'lige chátiri nóchali nóchaga. ");
INSERT INTO tacNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Suwábaga resítiri 'nátili sulachí ochérame ju. ");
INSERT INTO tacNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Bilé rió chátiri 'nátame pe apiépiri umugí 'yuga gojchigá einámala, apiépiri ralámuli me'ligá einámala, pe chigoga einámala, we'ká e'karúgame tábiri koruka einámala, 'lige 'yégiga einámala, 'we rióliga einámala, 'we gichiga einámala uché jaré ralámuli, 'we se'wináriga ra'íchaga einámala peka 'la bijchiá kachi (chisme), ruigá einámala napu nokame ju uché jaré ralámuli peka nóchali nígame ke napurigá ruigá einámala, 'we gawéliga einámala uché jaré ralámuli, tabilé 'la niraga eteme nímala uché jaré ralámuli, 'lige e'karúriga 'símala, suwábaga alué resítiri 'nátaliká sulachí o'chérame ju. ");
INSERT INTO tacNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Suwábaga yeri 'nátili pe ralámulichika buyame ju, 'lige alarigá na'tasa 'ma cha ikime kéré alawala. ");
INSERT INTO tacNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Alé yéniga, Esusi simile alé Tiro anilichi we'ká riógichi. Napu'lige sebasa bilena galírale bajkile napurigá tabilé 'wesi ralámuli machimela alé ajtigó. Abirigá machile ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Pe abiéniko machile bilé mukí 'we a'lá ma'chí pame ko Esusi apiépiri chátiri alawá. Alué mukika bilé iwé chátiri alawá ajchágame eyela nile, 'lige alué iwé eyela galírale a'resa alué iwé, simile alé napu ajtile Esusi 'lige chojkóbisiga ilíbale alemi o'wemi neraga napu Esusi ilile, 'lige 'we e'wérili anele napurigá ma'chí pámala alué chátiri alawá napu ajchágame nile alué iwé. ");
INSERT INTO tacNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Alué mukí iwé eyélaka tabilé ralámuli israelita nile, se'nú ra'íchame nile, pe griego ra'íchame nile. ");
INSERT INTO tacNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","'Lige Esúsika anele: ―'La a'rewa napurigá bajchá go'mela go'ame 'kuchi, tabilé 'la ju 'ma bujilía alué go'ame 'lige pe o'kochí i'lía alué go'ame. (Yeka pe aniame nile tabilé 'la ko bajchá ralámuli tabilé israelita gu'írilia.) ");
INSERT INTO tacNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","'Lige alué mukika nejele: ―Alarigá ju napurigá aní mué, nobi abiena o'kochí mésachi pachárale mochime, napu'lige bilé u'tátiri go'yachi abiena pe'tá nachume ju rujsúkame alué o'kochí. ");
INSERT INTO tacNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","'Lige Esúsika anele: ―Mueka 'we a'lá ma'chígame aní. Simigá ku galírale. Ya'má ma'china alué chátiri alawala mué ranálachi. ");
INSERT INTO tacNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","'Lige alué mukika yati simile galírale, 'lige rewale ranala kilí bo'ígime tabachi gojchílachi 'ma tabilé chátiri alawégame. Alué chátiri alawá 'ma ma'chínilige. ");
INSERT INTO tacNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","A'kinana rawé Esusi simile we'ká riógichi Sironi anilichi. Abiena simile ejiro Rekápoli anilichi. A'lige ku sébale alé wa'lú ba'wí ilígichi Galilea anilichi. ");
INSERT INTO tacNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","'Lige alemi bilé rió o'tóleru najkicholo, tabilé 'me 'la gayéname ra'icha. 'Lige alué ralámuli 'we anele napurigá nochámala sekate napurigá sa'wimela. ");
INSERT INTO tacNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Esúsika o'tole a'miná chajkénami, 'lige makúsate nochale najkachí. A'lige Esusi a'kasole makúsala, 'lige nochale inalá nayume. ");
INSERT INTO tacNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","A'lige e'nénale rewagachi, sewékame iwile. 'Lige anile Esusi arameo ra'íchaga: ―¡Epata! («I'puga ilibawa», anime ke anile.) ");
INSERT INTO tacNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","A'lige yati 'we 'la akeme gayénale alué rió, 'lige 'ma 'la gayénale ra'icha, 'lige o'wínale ra'icha 'we a'lá ma'chígame. 'Lige Esúsika anele ralámuli: ―Tase rupóaká 'emi ralámuli sa'wáligo ne ye najkacholo 'lige tabilé gayéname ra'icha. ");
INSERT INTO tacNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","'Lige alué ralámulika tabilé e'wale. Abiénachigo ruwílikó ralámuli rekó we'sá anelíe. ");
INSERT INTO tacNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Suwábaga alué ralámuli napu akele, anile: ―¿Churigá 'la umébame júché sa'wá alué tabilé 'la ra'íchame 'lige tabilé akeme? 'We a'lá 'yole. Najkacholo 'ma 'la akeme newale. Tabilé ra'íchame 'ma 'la ra'íchame newale. ");
INSERT INTO tacNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","A'kinana napu'lige alué Esusi bijí alemi eyénachi, uchéchigo siné we'ká napaíle ralámuli alé napu Esusi ajtile. 'Lige bakiá rawé kachi 'ma suwale nu'tugala. A'lige bayele Esusi alué bo'né Esusi 'yuga járome, 'lige regá anele: ");
INSERT INTO tacNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Na'temá ne ralámuli. Bakiá rawé mochígame jena ne'chí 'yuga. 'Ma suwale nu'tugala. ");
INSERT INTO tacNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ku galírale julámala ne, boichimi rekupámala jeloka, jaré 'we e'megá ejperégame nisa ―anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","―Jena tabilé 'wesi bejté. Tabilé asé reiboa go'ame ―anele alué Esusi 'yuga járome. ");
INSERT INTO tacNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","'Lige rukele Esusi: ―¿Chekí baní o'kame niru 'emi? ―Gichao ―anile alué 'yuga járome. ");
INSERT INTO tacNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","A'lige Esusi nulele napurigá wijchí mochímala ralámuli. 'Lige 'wile baní, cheliera 'yale Onorúgame, a'tabé chi'wánale, 'lige 'yuga járome 'yale. 'Lige alué Esusi 'yuga járome ralámuli 'yale. ");
INSERT INTO tacNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Abiena bi'tile pe u'kabi u'kuchí ro'chí. 'Lige Esusi cheliera 'yale Onorúgame, 'lige alué 'yuga járome 'yale alué ro'chí napurigá 'yámala ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Naó mili rasígame ralámuli nile. Suwábaga ralámuli go'ale, suwábaga o'pasale. 'Lige alué 'yuga járome gichao morali bochile go'ame rasírigame. 'Lige Esusi júlale alué we'ká ralámuli ku ejperélachi, ");
INSERT INTO tacNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","'lige Esusi 'mole bárkochi 'yuga járome si, 'lige simíbale alé Ralmanuta anilichi. ");
INSERT INTO tacNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Napu a'lige Esusi sebasa alé, jaré bariseo simíbale Esusi e'nemia. Alé o'wínale ra'icha alué Esusi 'yuga regá anigá: ―Aka sa'wawa bilé nayume o 'yawa a'walí bilé mukúgame. Machináliru ramué pala 'la bijchiá Onorúgamete julárigame ka mué. ");
INSERT INTO tacNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","'Liko Esusi sewékame iwile. Tabilé galele 'lige regá anele: ―¿Chonigá machinali 'emi pala 'la Onorúgame júlaligo ne'chí? 'Emi etériga tabilé che'simia ne napu 'emi tani ne'chí ―anele. ");
INSERT INTO tacNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","'Lige bárkochi 'mole 'yuga járome si. Simíbale na'lebo 'nálige. (Pe a'bé nile napu alué ralámuli simíbale.) ");
INSERT INTO tacNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Esusi 'yuga járome ta néléle baní. Alé bárkochi bi'lepi baní o'ká mochile. ");
INSERT INTO tacNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","'Lige Esusi anele alué 'yuga járome: ―'La 'nátaga. Alué bariseo, Erore si, napurigá kawali baní ro'ilime alarigá ju ―anele. ");
INSERT INTO tacNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","―Esúsika alaní tabiléchigo a'páligame ramué baní ―anile alué Esusi 'yuga járomeka a'bopi. ");
INSERT INTO tacNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","18","Esusi 'la machile tabilé inámiligó. 'Lige anele: ―¿Chonigá alaniáché 'emi: «Tabilé a'paru baní»? ¿Tabilé inámolia 'emi? Rekó 'la buségame ke 'emi tabilé ma'chili 'emi. Rekó 'la najkégame ke 'emi, tabilé aké 'emi. ¿Tabilé nélá 'emi, ");
INSERT INTO tacNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","napu a'lige ne chi'wana maligi baní a'tabé, maligi mili miná rasígame ralámuli kógimia? ¿Tabilé nélá 'emi alakí rasírigo baní a'tabé chi'wágame? ―Makué oká atabé rasiro ―regá nejele alué Esusi 'yuga járomeka. ");
INSERT INTO tacNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Aminami abé 'yabé napu a'lige chi'wana ne gichao baní a'tabé, naó mili rasígame ralámuli kógimia, ¿chekí rasírikó a'lige a'tabé chi'wágame baní? ―rukele Esusi. 'Lige alué Esusi 'yuga járomeka anile: ―Gichao morali rasiro a'liko. ");
INSERT INTO tacNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","A'lige anile: ¿Chonigá tabilé 'cho námuliché 'lige? ―anele Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Napu'lige sebasa Betsáira anilichi, jaré rió a'pale bilé rió tabilé ma'chílime alé Esusi ajtígichi. 'Lige 'we anele Esusi napurigá sa'wámala nochagá. ");
INSERT INTO tacNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","'Liko Esusi cha'pile sekala, o'tole a'miná suwemi tabilé riógichi. Alé a'kachípale busila. A'lige nochale busila, 'lige rukele: ");
INSERT INTO tacNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","―¿Jipe 'la ma'chí? ¿'La etiá mué tábiri? ―Etiá ne ralámuli e'yéname, 'la rojá kárépaché ―nejele alué rió. ");
INSERT INTO tacNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","'Lige Esusi uchéchigo siné nochale busila, 'lige alué rioka abé 'la ma'chílile. ");
INSERT INTO tacNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","'Lige Esusi anele: ―Jipe simigá ku galírale, tase simibóaká alé we'ká riógichi. ");
INSERT INTO tacNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Esusi, 'lige alué makué oká rió bo'né 'yuga járome, simíbale Sesarea Belipo anilichi ejiro a'tabemi riógichi. Boichimi enagá rukele Esusi bo'né 'yuga járome: ―¿Chieri korí ralámuli ne'chí? ");
INSERT INTO tacNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","'Lige alué 'yuga járomeka nejele: ―Jaré aní mué ko Juani ralámuli rewarame, ku ajánaligo mayé. 'Lige jaré aní mué kará Elíasi, napu ruwime nile napu anélige Onorúgame 'we 'ya. 'Lige jaré aní mué kará uchéchigo bilé 'we 'ya ajtígame napu ruwime nílige napu anélige Onorúgame ―anele alué Esusi 'yuga járome. ");
INSERT INTO tacNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","―¿'Émika, choniágó? ―rukele Esusi. 'Lige alésíko Pegro nejele: ―Mueka ju Wa'lula Kristo. ");
INSERT INTO tacNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","'Lige Esúsika anele: ―Tabilé 'wesi ruyéwaká. ");
INSERT INTO tacNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","A'lige Esusi ruyele bo'né 'yuga járome, alué Onorúgamete julárigame napurigá rió neraga 'we ejelímio 'lige 'we gawélimio alué e'wélala jurío 'lige alué e'wélala balé 'lige alué Moisesi nila rejcholi beníriame 'lige 'ma me'libólikó 'lige bakiá rawé kachi ku ajánimio. ");
INSERT INTO tacNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Suwábaga 'we a'lá ma'chígame ruyele. A'lige Pégroka Esusi o'tole a'mibemi 'lige ne'óchale: ―Tase alarigá ra'ichawa. ");
INSERT INTO tacNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Esusi gu'lile e'nemia uché jarela bo'né 'yuga járome. A'lige Esusi ne'óchale Pegro. Anele: ―Se'wí alé. Mueka ra'icha napurigá Remónisi. Mueka tabilé 'nata napurigá Onorúgame najkí. Mueka 'nata napurigá pe ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","A'lige Esusi bayele ralámuli, 'lige bo'né 'yuga járome. 'Lige anele: ―Bilé rió ne'chí oyérame nisa, tabilé na'támili ju alué rió napurigá najkí alué bo'né. Na'támili júkuru napurigá najkíbá ne bo'né. Anáchaga asimeli júkuru rekó resí oliae 'lige tabilé a'rigá ne'chí oyeria. ");
INSERT INTO tacNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Bilé rió tabilé mukunálime resí níliga ne'chí oyérame kóriká abiena mukumeli ju, tabilé simela re'pá rewagachi. Bilé rió me'lisuga ne'chí oyérame kóriká Onorúgame nila ra'íchili beníriga eyénaga, yati re'pá rewagachi simela alué rió bejtélimia Onorúgame 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Pecha 'la júkó rekó bilé rió we'ká e'karúgame nígame ke, tabilé 'la Onorúgame oyérame nísaká, 'ma chátiri gainámala bo'né alawala. ");
INSERT INTO tacNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Alésíko 'ma tabilé gainámala rewagachi moyena. Abéchigo najtékame ju bi'wígame alawega enalia. ");
INSERT INTO tacNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Bilé rió chijunasa ne'chí oyériga 'lige ne ra'ichálila beníriga a'lige ne napu ju Onorúgamete julárigame napurigá bilé rió neraga, 'we chijunámala néchigó alué rió 'yuga napu'lige ne uché nawá rewagáchika wa'lú a'walí niga Onorúgame nila, santo ánjeli 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","'Lige aminami regá anele: ―Neka 'we a'lá ma'chígame ruwí jaré 'emi napu mochí jena tabilé suwimeo 'ma 'la etesa bajchá aliena 'la semáriga nulao Onorúgame jena wijchimoba. ");
INSERT INTO tacNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ujsani rawé kachi a'kinana, Esusi simile re'pá rabó Pegro si, 'lige Jakobo si, 'lige Juani si. Napu a'lige moinasa, Esusi se'winati gayénale pe'wera. ");
INSERT INTO tacNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","O'páchala rosákame gayénale, 'we chárigá rosákame ta'wesi anaga. ");
INSERT INTO tacNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Yati jsile alé oká rió 'we 'ya ejperégame Elíasi 'lige Moisesi. Ra'íchale Esusi 'yuga. 'Lige alué bakiá rió Esusi 'yuga járomeka etele. ");
INSERT INTO tacNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","'Lige Pégroka anele Esusi: ―Mué Wa'lula, 'we a'lá ju ramué jena jágichi. Jipe bakiá kuchí galí newawa, bilé mué galila, 'lige bilé Moisesi galila, 'lige bilé Elíasi galila. ");
INSERT INTO tacNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pe alarigá ra'íchale, tabilé machile chonimea. 'We majale alué bakiá rió Esusi 'yuga járome. ");
INSERT INTO tacNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","A'lige yati nótale alé rabó napu'lige alé mochígichi. 'Lige ma'chí anile bilé ra'íchili alé nolíraleka. Regá anime: ―Yeka ne Inolá ju napu 'we galé ne. E'wáwaká napurigá nulá ne Inolá. ");
INSERT INTO tacNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","A'lige 'we yati neraga, alué bakiá rió Esusi 'yuga járome echúromi e'nénale 'lige tabilé rewale Elíasi 'lige Moisesi. Esusi bi'neli ilígame etele. ");
INSERT INTO tacNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Napu'lige ku e'tegínasa, Esusi anile: ―Tase ruyéwaká ralámuli napu eteru. Napu a'lige ne, napu julárigame ju Onorúgamete napurigá rió neraga, ku ajánasa, a'liko 'la ju ruyá. ");
INSERT INTO tacNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","'Lige alué bakiá rió tabilé ruwile. We'sá anile a'bopi: «¿Chonigá alanílepué ku asísimio?» anile a'boi. ");
INSERT INTO tacNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","A'kinana, boichimi 'yéniga, alué Esusi 'yuga járome rukele alué Esusi: ―¿Chonigá aní alué Moisesi nila nulalí beníriame sebamio bajchabé bilé rió Elíasi rewégame ta'chó nawachi alué Kristo? ");
INSERT INTO tacNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","'Lige Esúsika regá anele: ―Elíasi bajchá sébale 'we a'lá o'wé bowechi jawamia ralámuli jena wijchimoba napurigá 'la sébili mochímala napu'lige sébachi alué Onorúgamete julárigame. 'Lige 'ma sebasa alué Elíasi ralámuli o'wé ajawamia, ¿chonigá alué osilí alarigá ruwí 'we resí olawa alué Onorúgamete julárigame napurigá rió neraga? ");
INSERT INTO tacNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","'We a'lá animé ne. Rekó we'ká ralámuli 'we a'lá e'wílige alué Elíasi, abiena 'we resí oláliru, napurigá resí oláwili ju alué Onorúgamete julárigame napurigá rió. Suwábaga alué 'we 'ya osirúgime nile alarigá ikimeo jipe. ");
INSERT INTO tacNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Napu a'lige Esusi ku sebasa napu mochile alué Esusi 'yuga járome, Esúsika etele we'ká ralámuli mochigo alemi 'lige etele jaré Moisesi nila nulalí beníriame e'wele ra'íchachi ayoga alué Esusi 'yuga járome 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Napu a'lige etesa aleka enagó Esusi yati simíbale repórimia 'we ra'sálagá suwábaga alué we'ká ralámuli, 'lige 'we a'lá niraga repórile. ");
INSERT INTO tacNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","A'lige Esusi rukele alué ralámuli: ―'Émika ¿tachiri ra'ichalia alué Moisesi nila nulalí beníriame si? Bochí aniá aníchaneguru. ");
INSERT INTO tacNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","'Lige bilé ralámuli nejele: ―Mué beníriame, jeka a'pá ne ye towí, ne inolá, chátiri alawá ajchágame ju, tabilé gayéname ju ra'icha. A'pá ne napurigá mué ma'chí pámala alué chátiri alawá. ");
INSERT INTO tacNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Wijchí rekábame ju, ronuega bo'írame ju chu'ala, chi'name ju ramalá a'wágame i'kiga, a'wáraga bo'írame ju rekúpaga, 'ma ruyé ne mué 'yuga járome, tabilé umeba ma'chí 'pa alué chátiri alawá. ");
INSERT INTO tacNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Esúsika anele ralámuli: ―¿Chéniko si 'la machimélaché 'emi ralámuli 'lige 'emi ne 'yuga járome churigá 'yólime ka? 'Ma we'ká rawé ajtíkuru ne 'emi 'yuga. Jeka o'tó alué towí. ");
INSERT INTO tacNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","'Liko alé o'tóliru alué towí. Napu'lige alué towí etesa Esusi, alué chátiri alawá yati wijchí rekábale alué towí gajpalaka, ronuégame chu'ega. ");
INSERT INTO tacNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Esusi rukele o'nola: ―¿Chekí rawé ju alué chátiri alawala bajkisá ye towichi? 'Lige o'nólaka nejele: ―'Ma wa'lubé kachi bajkile. ");
INSERT INTO tacNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Alué chátiri alawá panápurimi pame ju na'ichimi, 'lige ba'wichimi, me'lináliga. Na'temápuaká ramué. Gu'írowaká ramué 'la umubásaká mué. ");
INSERT INTO tacNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","'Lige Esúsika anele: ―¿Mueka chonigá anéché «'la umubásiká mué»? Mué 'la bijchígasaká 'la umébame ko ne, 'la umubámala ne. ");
INSERT INTO tacNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Alué towí o'nólaka anile: ―Ne 'la bijchigi 'la umébame ko mué. Tabilé we'ká namo ne. Gu'írowaká ne napurigá abé 'la bijchígimala ne uché rajpé 'la umébame ko mué. ");
INSERT INTO tacNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Napu'lige Esusi etea namó mochíbachi ralámuli alemi napu ilile, anele alué chátiri alawá alué towichi ajtígame: ―Mué 'sile najkacholo newá ye towí. Mué 'sile tabilé ra'íchame newá ye towí. ¡Ma'chini, tabilé siné uché bajkibóaká ye towichi! ―anele Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","'Ma ma'chínamia alué chátiri alawá, a'wágame sinale 'lige gajpalaka rekárale alué towí ronuega chu'ega, 'lige ma'chínale, wijchí rekábasa a'rele napurigá mukúgame neraga alué towí. 'Lige ralámulika anile alué towí etega: ―¡'Ma mukúgame ju! ");
INSERT INTO tacNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","A'liko Esusi cha'pile sekala, 'lige o'weti elale. Ajágame nile. ");
INSERT INTO tacNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Napu'lige bilena galírale mochiga, Esusi 'yuga járomeka rukele alué Esusi: ―¿Chonigá tabilé gainárupeché ramueka ma'chí 'pa alué chátiri alawá? ");
INSERT INTO tacNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","'Lige Esúsika nejele: ―Napu'lige ma'chí 'pa bilé chátiri alawá bilé ralámulichi ajtígame, 'we a'lá na'tawa Onorúgame 'yuga 'lige iwérali tánisa a'lige kulí gainámala 'emi ma'chí pa alieti alawá. Tabilé tánisa 'emi iwérali Onorúgame, tabilé umubámala 'emi ―anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","A'kinana simile Esusi 'lige bo'né 'yuga járome. Simíbale alé ejiro Galilea anilichi. 'Lige Esusi tabilé najkile napurigá ralámuli Galilea ejperégame machimela alé mochigo alé Galilea alué Esusi 'lige 'yuga járome. ");
INSERT INTO tacNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Alué Esusi bi'neli asinálile beniria bo'né 'yuga járome, 'lige regá anele: ―Napu ju Onorúgamete julárigame 'pa rewagáchika napurigá rió neraga 'ma cha'piboli ju pe 'wemi 'lige 'ma me'liboli ju. Me'lisuga, pe bakiá rawé kachi ku ajánamala. (Alué Esúsika pe bo'né olagá anime ke anile.) ");
INSERT INTO tacNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Alué Esusi 'yuga járomeka tabilé námale napu anile Esusi. Majale rukegá. A'kinana Esusi 'yuga járome boichimi 'yéniga ra'íchale a'boi: ―¿Chieri 'nalina abé Wa'lula júpué ramué? ―anile. ");
INSERT INTO tacNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Napu'lige sebasa we'ká riógachi Kapernaumi anilichi mo'ile pachá galírale napu che'labámili nile 'lige Esúsika rukele alué bo'né 'yuga járome: ―¿Tachiri choniae 'emi boichika 'yénaga? ");
INSERT INTO tacNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","'Lige alué Esusi 'yuga járome ka tabilé nejele machíligame ayomio Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","'Liko asíbale Esusi, 'lige bayele alué makué oká bo'né Esusi 'yuga járome 'lige anele: ―Wa'lula nínilisiká, gu'írimili júkuru suwábaga ralámuli. Tabilé bo'nepi na'temámili júkuru. ");
INSERT INTO tacNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","A'lige Esusi mutule bilé ta towí 'lige anele alué makué oká rió: ");
INSERT INTO tacNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―'Emi napu 'we a'lá niraga eté bilé ta towí 'la ne'chí oyériga, 'liko 'we a'lá nirame ju ne'chí. 'Emi ne'chí nirasa 'liko 'la nirame ju Onorúgame, alué napu júlale ne'chí ―alarigá anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","'Lige alué Juani, napu Esusi 'yuga ilírome nile, anele Esusi: ―Mué Wa'lula, alé 'mi ajtí bilé rió 'we buyáname u'kuchí remónisi alawala ralámulichi mochígame regá anigá: «Esusi a'walílate buyasa 'la képá 'emi chátiri alawá, yati buyasi, a'rewa ye rió.» 'Lige ramueka sulíruturu, pecha ramué 'yuga oyame kame alué rió. ");
INSERT INTO tacNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","'Liko Esúsika anele: ―Tabilé che anétéliko. Bilé rió buyáname chátiri alawá regá anigá: «Esusi a'walílate buyasa 'la képá 'emi chátiri alawá», bilé rió alarigá nóchame ka 'we a'lá ra'ichámala ne'chí olagá. ");
INSERT INTO tacNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ralámuli tabilé saíla nisa ramué, ramué gompaniérola kéré. ");
INSERT INTO tacNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Bilé rió rekó pe bilé alabá ba'wí 'yae 'emi ne'chí oyérame kóriká, 'liko Onorúgame 'la semati raweli 'yámala alué rió. ");
INSERT INTO tacNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","› Bilé rió resiti 'nátili 'yame bilé ta towí kulí benime Onorúgame nila ra'íchili, abé 'la nímala si'lika mukusá ba'ichí rojkógachi pásiga majtá golótiga. ");
INSERT INTO tacNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mué 'we cha 'sisa mué bo'né sekálate, 'ma rejpunawa alué seká. Abé a'lá nímala Onorúgame e'wilia tabilé sekega, tase simiá oká sekega o'wékana jiérnochi alé napu tabilé siné cho'ime ju na'í. ");
INSERT INTO tacNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Alé alué kuchili tabilé siné a'rémili ju ralámuli sa'pala go'yá. 'Lige alé nabí rajame ju na'í. Tabilé siné cho'ime ju. ");
INSERT INTO tacNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Mué resí 'sika enasa mué ronólate, rejpunawa ronola. Abé a'lá ju Onorúgame e'wilia tabilé ronega, tase simiá re'lé jiérnochi oká ronega. ");
INSERT INTO tacNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Alé alué kuchili tabilé siné a'reme ju ralámuli sa'pala go'yá. 'Lige alé nabí rajame ju na'í. Tabilé siné cho'ime ju. ");
INSERT INTO tacNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mué 'we chátiri na'tasa chátiri etega, ma'chí buinawa alué busí. Abé a'lá nímala Onorúgame e'wilia tabilé busega, tase simiá re'lé jiérnochi oká busega, ");
INSERT INTO tacNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","alé napu alué kuchili tabilé siné a'reme ju ralámuli sa'pala go'yá. 'Lige alé nabí rajame ju na'í. Tabilé siné cho'ime ju. ");
INSERT INTO tacNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","› Apiépiri ralámuli ne'chí najátasaká resí ikimela. Alué resí ikiame ju napurigá oná. ");
INSERT INTO tacNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Oná 'we a'lá ju 'la ajkabasa go'ame. Tabilé ajkabasa go'ame, pe tabilé 'la ajkabame ju alué oná. Alarigá ju alué resí ikiame napurigá oná. Alué resí ikiame 'la gu'írame nisa ralámuli 'we a'lá 'nata Onorúgame 'yuga a'liko napurigá oná 'la ajkabame alarigá ju. Alué resí ikiame tabilé gu'írome nísaká alué ralámuli 'we a'lá 'nata Onorúgame 'yuga, a'liko tabilé 'la ju. 'Liko alué resí ikiame ju napurigá oná tabilé ajkabame. Tase we'kuawa alué resí ikiame gu'írome ko Onorúgame si na'talia 'liko 'we ganíliga ejperélamala 'emi suwábaga. ");
INSERT INTO tacNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Alé Kapernaumi asigá, simile alé bilena alé a'bé bakochi Jorani anilichi, aleka napu ma'chíname ju alué rayénali napu Jurea anilime nílechigó napurigá alué ejiro Jurea anilime. Nabí rawé we'ká ralámuli napaíle. 'Lige Esúsika benírale rejcholi alué ralámuli. Alarigá 'sime nile. ");
INSERT INTO tacNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","'Lige alé jsile bariseo pe rukemia chonirá Esusi. 'Lige rukele: ―¿'La ju bilé rió mukí a'rea newíkame? ");
INSERT INTO tacNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","'Lige Esúsika rukele: ―¿Tachiri rejcholi nejile ko alué rió Moisesi 'ya? ―rukele Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","'Lige alué bariséoka anile: ―Moisesi anile 'la ko bilé mukí a'rilía, bilé apeli 'yásiká regá anime: «Jípesí 'ma tabilé napaíka ejperélamala napugiti 'ma rojágame kame ye oká ralámuli, 'ma tabilé newíkame», anime nísaká alué apeli. ");
INSERT INTO tacNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Esúsika anele: ―Ralámuli cha nokame kame. Alekeri Moisesi benírele alué rejcholi. ");
INSERT INTO tacNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","'Ya bajchabé Onorúgame tabilé benírele alué rejcholi. Onorúgame nila ra'íchili regá aní: «Napu'lige Onorúgame newale gawí, newale bilé rió, 'lige bilé mukí.» ");
INSERT INTO tacNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Alekeri newime ju 'lige waná galírime ju, ");
INSERT INTO tacNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","'lige napuíka okome ju. Alésíko napurigá bi'lepi ralámuli 'nátame nímala okaka, ");
INSERT INTO tacNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","'lige Onorúgame tabilé najkí napurigá rojanawa napu bo'né napabule. ");
INSERT INTO tacNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Abé alí, napu'lige galírale mochiga, alué Esusi 'yuga járome ka rukele Esusi: ―¿Chonime ke napu mué ruyá anié kulipi? ");
INSERT INTO tacNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","'Lige Esúsika nejele: ―Bilé rió mukí a'resa, uché bilé mukí rewame ju, tabilé 'la ju alué 'nátili. ");
INSERT INTO tacNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Abiena 'we resítiri ju ala'simía bilé mukí rió a'resa uché bilé rió rewisá, tabilé 'la ju alué 'nátili. 'We resítiri ju ala'simía. ");
INSERT INTO tacNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ralámulika u'kuchí 'kuchi a'pile alemi alué Esusi napurigá cha'pimela sekate. Napu a'lige machisá alué 'yuga járome, ne'óchale alué ralámuli u'kuchítiri. ");
INSERT INTO tacNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Esúsika ayole alué Esusi 'yuga járome 'yuga. Anele: ―Tase che anewa, a'rewa 'nalina napurigá jeka smela alué u'kuchítiri. 'Emi alué u'kuchítiri etega, benimela 'emi Onorúgame e'wiga. Suwábaga ralámuli napu 'we a'lá e'wame ju napurigá ye u'kuchítiri, alueka 'we a'lá nulalíame ju sulachí Onorúgamete. ");
INSERT INTO tacNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Neka 'we a'lá bijchiga aní. 'Emi tabilé e'wisa Onorúgame napurigá nokame ju ye u'kuchítiri, tabilé siné ganíliga e'yénamala 'emi Onorúgame 'yuga. Napurigá bilé u'tátiri 'we yati e'wime Onorúgame, a'chigóriga nímili júkuru 'émichigó napurigá alué u'tátiri 'la yati e'wime Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","A'lige alué Esusi mutule alué u'kuchítiri 'lige mo'ola nochale 'lige tánale Onorúgame napurigá repúmala. ");
INSERT INTO tacNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Bilé rawé Esusi enale simiá, 'lige bilé rió nawá 'we 'maga, 'lige chokóbasiga ilíbale alé o'wemi napu Esusi iligé. 'Lige alué rió anele alué Esusi: ―Mué 'we a'lá beníriame, ¿tachiri chu'simía 'la ju napurigá bejtélamala ne 'pa rewagachi nabí? ―anile alué rió. ");
INSERT INTO tacNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","'Lige Esúsika anele: ―¿Chonigá aníché mué: «'We a'lá beníriame»? Pe bi'neli Onorúgame ju 'we a'lá beníriame. ");
INSERT INTO tacNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","'La machí mué napu Onorúgame nulale. Regá nulale Onorúgame: «Tabilé me'liboa ralámuli, tabilé chigowa aminami, tabilé se'nú mukí 'yuga gojchiboa, tabilé 'yega ra'icháwaká, tase bujewa bilé rió tábiri o'ká enágame 'yégiga, 'la niraga etewa mué o'nola 'lige mué eyela» ―alarigá anele Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","'Lige alué rioka anile a'lige: ―Neka 'we a'lá sébali olá suwábaga alué nulalí u'tá ka jipe abiena si. ");
INSERT INTO tacNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","'Lige Esúsika 'we na'temale, 'lige anele: ―Aba bilé tábiri rokáré. Bilé tábiri tabilé 'cho 'la sébali olá mué. Simigá ralinéwaká suwábaga alué mué nila tábiri, 'lige kógiwaká alué enomí alué ralámuli tabilé nígame. 'Lige ne'chí najátawa. Alarigáká 'la narémala mué semati raweli 'pa rewagachi. ");
INSERT INTO tacNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","'Liko alué rió kilí ilíbale, seweka simiá kíbale cha we'ká tábiri nígame níligame. Tabilé ralinénele bo'né nila. ");
INSERT INTO tacNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","'Liko Esusi e'néniga bo'né 'yuga járome, anele: ―We'ká alué ralámuli 'we nígame we'ká e'karúgame tabilé elime ju napurigá Onorúgamete nulewa sulachí. Pe napurigá a'boi 'nata, pe alarigá 'la sébili nirá. ");
INSERT INTO tacNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","'Lige alué Esusi 'yuga járome ka lale: «¿Chonigá aníché Esusi alaniá?» 'Lige Esúsika anele uchéchigo siné: ―We'ká ralámuli napu 'we 'nátame ju we'ká e'karúgame niga asinálime, tabilé najkime ju napurigá Onorúgamete nulewa sulachí. ");
INSERT INTO tacNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","We'ká rió we'ká bukégame akasí, chibátiri, bo'átiri, tabilé nélé Onorúgame. Bo'né bi'neli 'nata. 'We nóchili olámala alué rió napurigá lisensia 'yámala Onorúgame napurigá Onorúgame nulémala. ");
INSERT INTO tacNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","'Lige akisá alué Esusi 'yuga járome, tabilé inámole. 'Lige anile a'bopi: ―¿Chieri 'la sebámalawé alé rewagachi? ");
INSERT INTO tacNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","'Lige Esúsika e'néniga anele: ―Bilé rió bo'né 'nátaga tabilé sebámala rewagachi. Onorúgameka 'la nejkúrime ju, alarigáká 'la sebawa rewagachi. ");
INSERT INTO tacNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","A'lige Pégroka anele: ―Ramueka suwábaga tábiri a'réruché mué 'yuga e'yénimia ―anile Pegro. ");
INSERT INTO tacNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","'Lige Esúsika anele: ―Apiépiri rió a'resa galí, rejimátiri, o'nólatiri, eyélatiri, 'kúchitiri, gawítiri, ne 'yuga e'yénimia, benírimia ralámuli Onorúgame nila ra'íchili, ");
INSERT INTO tacNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Onorúgame wa'lú ganílili 'yámala. 'We ganílimala alué ralámuli Onorúgame oyérame 'yuga. Abiena 'we resí olawa 'lige resí anewa cha nokame ralámulite. 'Lige mukusá 'pa rewagachi asiméleké nabí. ");
INSERT INTO tacNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Alué napu bajchá ilinálime ju, alueka pe guwana juláwili ju. 'Lige alué 'we guwana ilígame, alueka 'mi bajchá eláwili ju. ");
INSERT INTO tacNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","E'yénale bowesia Rusaleni simiba. Esusi bajchá enale. 'Lige alué we'ká oyérameka nujubami 'yénale, 'lige regá na'tasia e'yénale: «¡Esúsika 'la tabilé majanti!» napugiti Esúsika abirigá alemi Rusaleni simiá enáligime rekó machié me'liboli ko alé Rusaleni. Uchéchigo jaré napu abé guwana e'yénale 'we majale. 'Lige Esúsika waná bi'neli o'tole alué makué oká rió bo'né 'yuga járome. ");
INSERT INTO tacNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","'Lige regá anele: ―Ramueka 'a e'nárukuru Rusaleni simiba. Alué napu ju Onorúgamete julárigame 'pa rewagáchika napurigá rió neraga 'ma cha'piboli ju, 'lige 'ma o'toboli ju napu mochí alué e'wélala balé 'lige alué Moisesi nila nulalí beníriame. Alué e'wélala o'tomela a'miná uchéchigo bilena e'sena ralámuli mochígichi napu tabilé jurío ju napurigá alemi me'liboa. ");
INSERT INTO tacNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","'Lige tabilé 'cho me'á, alué ralámuli 'we gawélimala 'lige a'kachípamala 'lige wejpisópua, 'lige me'liboli ju. Mukusá pe bakiá rawé kachi ku ajánamala ―anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","A'lige Jakobo, 'lige Juani, Sebereo 'kúchila, ");
INSERT INTO tacNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","a'bemi simíbale Esusi ajtígachi 'lige anele: ―Mué beníriame, pe rekó, nóchali 'yáwaká ramué. ");
INSERT INTO tacNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","―¿Tachiri nóchali najkiá 'emi? ―rukele Esusi. ―Napu'lige mué wa'lula selígame asibasa, ramueka a'naguka mochíwaká mué ajtígichi napurigá e'sélikame u'kuchípala nímala ramué, bilé wajtoná, bilé o'iná. ");
INSERT INTO tacNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","'Lige Esusi anele: ―'Emi tabilé machí aliena nóchali ko. ¿'Lacha anachasa júkó 'emi ne'chí 'yuga? ¿'Lacha anachámala 'emi resí ikiá napurigá ne resí ikimela? ");
INSERT INTO tacNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","―Abiena 'la anacháwaleké ―nejele Akobo 'lige Juani. ―Bijchiá resí ikimela 'emi. Me'liboa ne. Abiena me'liboa 'emi. ");
INSERT INTO tacNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tabilé ne 'símala a'naguka e'wélala mochía 'emi. Pe Onorúgameka 'la machí chieri mochiamio napurigá nochámala alué nóchali ―anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Uché jaré Esusi 'yuga járome machile nóchali táligo, alekeri na'áwale. 'Lige Esusi bayele suwábaga alué makué oká bo'né 'yuga járome, ");
INSERT INTO tacNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","'lige anele: ―'Emi 'la machíguru napu ekí e'wélala 'we riólame ka, 'lige 'we iwégame nulame ka, napuchibi olagá ralámuli, 'lige alué e'sélikame u'kuchípala a'chigóriga nulame ju. ");
INSERT INTO tacNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","'Emi tabilé alarigá nulámili júkuru. ");
INSERT INTO tacNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Alué abé wa'lula nínilisi ka, gu'írimili júkuru uché jaré ralámuli, tabilé rióliga, napurigá nóchame neraga. ");
INSERT INTO tacNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Alué Onorúgamete julárigame 'pa rewagáchika napurigá rió neraga tabilé nawápá napurigá gu'íriwa ralámulite. Alueka nawákuru gu'írimia uché jaré ralámuli, alué bo'nepi mukugá buinamia chátiri bowechi we'ká ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","A'lige sébale we'ká riógichi Jerikó anilichi. Napu'lige Esusi 'ma simichi alé Jerikó yéniga alué bo'né 'yuga járome si, 'lige we'ká ralámuli napu Kapernaúmika si 'yénale, 'lige alemi boichimi asale bilé rió tabilé ma'chílime, Bartimeo anilime (Bartimeo aniáká Timeo inolá aniame ju). Alé asale boichí suwemi enomí taa. ");
INSERT INTO tacNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Napu a'lige alué tabilé ma'chílime machisá Esusi Nasareta bejtégame a'bemi enegó, a'wágame ra'íchaga bayele regá anigá: ―¡Mué Esusi, Rabí rijimala, Rabí 'we 'ya ajtígame, pe rekó na'temápuaká ne'chí! ―anile. ");
INSERT INTO tacNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","We'kaka sulile alanichi napurigá tabilé aminabi a'wágame ra'ichámala. 'Lige alué rioka tabilé e'wale. Aminabi anile rekó sulílie: ―¡Mué Esusi, Rabí rijimala, alué rabí napu 'we 'ya asale, pe rekó, na'temápogó ne! ―anele. ");
INSERT INTO tacNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Akisá yati kilí ilíbale Esusi, 'lige anile: ―Jeka bayéwagó. 'Lige alué Esusi 'yuga járomeka simíbale bayemia. 'Lige anele nawiga: ―Tase chéláwa. 'Mi simérá mué. Esusi repá 'naka. ");
INSERT INTO tacNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","'Liko alué rió tabilé ma'chílime alué gemá wijchí pasa, iwégame o'pochile, 'lige simile alé napu Esusi ilile. ");
INSERT INTO tacNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Esúsika rukele: ―¿Tachiri najkí mué? 'Lige alué tabilé ma'chílimeka nejele: ―Mué beníriame, najkí ne napurigá ne'chí 'yómala mué napurigá 'la ma'chílimala ne ku. ");
INSERT INTO tacNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Esúsika anele: ―Simigá ku mué bejtélachi. Sa'wíkuru mué, 'la bijchígiligame mué 'la sa'wame ko ne ―anele. Yati 'la ma'chílile alué tabilé ma'chílime. 'Lige tabiléchigo simíleko galírale, pe simile alemi guwánami napu we'ká ralámuli 'yénale. ");
INSERT INTO tacNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Napu'lige 'ma amulí seba 'yéniga alé Rusaleni alué Esusi 'lige gompaniérola jábale alé Olibo rewégichi rabó re'leberi, alé napu okaná we'ká riógachi nile, bilena Be'tagé 'lige uché bilena Betania rewégachi. ");
INSERT INTO tacNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","'Lige Esúsika anele oká alué bo'né 'yuga járome: ―Simíbaga alé 'mi we'ká riógachi, 'mi alé napu ma'chigá ju, 'lige alé riógichi sebasa, 'emi etémala bilé bulito u'tá chériga chujkúgame tabilé 'cho asilime. 'Lige 'ma su'panasa jeka o'tobóaká baníriga. ");
INSERT INTO tacNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","'Lige bilé rió rukisá chonigá su'panalio alué bulito, yati anewa: «Alué Wa'lula najkí napurigá tanewa ye bulito, pe yati ku ronolawa ramué», anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","'Liko alué oká rió Esusi 'yuga járome yati simíbale 'lige alé bilénami riógichi sebasa etele bilé bulito u'tá chériga chujkúgame bilé o'tónachi alé a'bé yochi galírale, 'lige su'pánale. ");
INSERT INTO tacNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","'Lige jaré rió jale alé 'lige bilé alué rió alemi ajtígame rukele: ―¿Chonigá su'panaru alué bulito? ");
INSERT INTO tacNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","'Liko alué Esúsite julárigame ruyele 'la sébili napurigá anélige Esusi. 'Liko alué rió rukeme yati 'la elile napurigá 'la o'tomela. ");
INSERT INTO tacNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Alésíko yati o'tole alué bulito napu alé Esusi ajtile. 'Lige alué a'pasa alué bulito, bujale alué i'weli o'pacha a'boi o'páchala 'lige pérale alué bulito, 'lige Esúsika yati asele alué bulito, 'lige asigá simile. ");
INSERT INTO tacNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","'Lige we'ká ralámuli pésiga 'yénale boichimi a'boi o'páchala i'weli, 'lige alué bulito alemi amóbami simírole, 'lige jaréchigo sa'ó sawala ro'asia e'yénale alemi boichimi. ");
INSERT INTO tacNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Suwábaga ralámuli guwánami 'yénigame 'lige bajchabemi 'yénigame 'we ra'sálásia 'yénale regá anisia: ―¡Wa'lula ju Onorúgame! ¡'We a'lá semá 'sime ju alué Onorúgamete julárigame! ");
INSERT INTO tacNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Onorúgame 'ma a'lá nulémala ralámuli! ¡'Ma nawá alué Rabí rijimala! ¡Suwábaga 'we semátiri nímala! ");
INSERT INTO tacNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Alarigá bajkile Esusi alé we'ká riógichi Rusaleni anilichi aleké bulito asigá 'lige re'kile bulítochi 'lige re'kisa bajkile abé pachami alé wa'lú re'obá ilígichi ra'pichí, 'lige 'we a'lá e'nesa bochígimi alé ra'pichí, 'ma simile alé Betania rewégichi ta'mé we'ká riógachi, 'ma 'we alí níligame amulí chónachi, alué makué oká rió 'yuga simile bo'né 'yuga járome. ");
INSERT INTO tacNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Melénala be'á 'ma simíbale alé Betania mochige, 'lige boichimi e'yéniga 'we e'lowile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","'Lige etele bilé chuná alemi ilígame boichimi a'bemi 'lige Esúsika yati simile e'nemia pala rakégame ka alué chuná, tabilé rakega ilile alué chuná, pe 'we a'lá sawega ilile, tabilé 'cho sébale raweli napu rakeme nile alué chuná.» ");
INSERT INTO tacNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","'Liko Esúsika anele alué chuná: ―Tabilé siné go'mela ralámuli mué chuná rakala, 'máchigo tabilé siné rakémili kame mué ―anele. 'Lige alué Esusi 'yuga járomeka akele alanichi Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","A'lige sebasa ku alé Rusaleni, Esusi bajkile alé wa'lú re'obachi ra'pichí, 'lige chojkile buyana alué ralámuli napu ekí ralinea jale 'lige tábiri alé ra'pichí, 'ma re'nubuga 'lule suwábaga mesa napu enomí nakulílichi nile, 'lige mutuka 'ma re'nubule chulugí baloma ralinélime wakali. ");
INSERT INTO tacNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Tabilé a'rele napurigá alemi ra'pichí mochiámala ra'lánaga we'ká e'karúgame tábiri ralinélime. ");
INSERT INTO tacNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","'Lige alué e'karúgame tábiri rujsuna 'lige gajuna 'we ruyele Onorúgame nila ra'íchili. Regá anele: ―¿Tacha machí 'emi regá anime chujkugó alé osilichi napu Onorúgame nila ra'íchili chujkú? Regá anime chujkúché: «Ne galílaká uneme nímala suwábaga ralámuli jena gawichí ejperégame napurigá ra'ichámala Onorúgame 'yuga 'lige napurigá iwérali tánamala. Alarigá aní Onorúgame nila ra'íchili. 'Émika unéguru ye re'obá Onorúgame galila napurigá pe bilé resó pe chigórigame resola niraga, tabilé 'la nirá 'emi ―anele. ");
INSERT INTO tacNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","'Lige alué e'wélala balé abiena alué Moisesi nila nulalí beníriame akele alanichi alué Esusi 'lige chojkile 'nata churigá 'la nítikó me'liá alué Esusi. Me'linálile 'lige 'nátale majaga «we'ká ralámuli alué rió oyera.» 'Lige tabilé chérigá me'ale alué Esusi napugiti 'we majáligime alué ralámuli, cha we'ká níligame alué ralámuli alemi jágame 'we a'lá 'nátaga gepua alué Esusi benírachi alué rejcholi. ");
INSERT INTO tacNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","'Ma alí 'ma chónachi simile Esusi bo'né 'yuga járome 'yuga. 'Ma simíbale alé Rusaleni mochige. ");
INSERT INTO tacNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Uché melénala be'á simíbale alé a'bemi alué chuná ilígichi 'lige etele alué chuná 'ma wakígame chojkichí si, 'ma nawala 'yúriga wakíbale alué chuná. ");
INSERT INTO tacNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","'Lige Pegro nélále napu anile alué Esusi rapakónala. Regá anile Pegro: ―Mué Esusi Wa'lula, e'nérigo ye chuná napu mué ne'óchale 'we ená anigá rapako, 'ma wakile. ");
INSERT INTO tacNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","'Lige Esúsika nejele 'lige regá anele: ―Aka 'we a'lá bijchígiwaguru 'la wa'lú a'walí nígame ko Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Neka 'we a'lá bijchiga aní, 'emi nulesa ye gawí Olibo anilime 'liko 'la simela 'mi mejká wa'lú ba'wí ilígichi napu e'wele barko e'yéname ju, 'lige 'we a'lá bijchígiga anesa 'emi 'we a'lá nejkúromio Onorúgame bo'né a'walílate, 'liko Onorúgame 'la nejkúromala, 'liko 'la simela ye gawí 'mi wa'lú ba'wí ilígichi. ");
INSERT INTO tacNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Apiépiri tábiri 'la nejkúromala Onorúgame 'la bijchiá bijchígiga tánasaká mué alué nejkúrili. ");
INSERT INTO tacNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Napu'lige Onorúgame 'yuga ra'íchachi mué, 'la e'kawa apiépiri ralámuli alué napu 'we resí 'sika ilírome nile mué 'yuga. Mué 'la e'kásaká alué rió 'liko Onorúgame 'la e'kámalachigó mué napu'lige iwérili tánichi mué. Mué tabilé e'kásaká 'liko alué Onorúgame rewagachi ajtígame tabilé e'kámalachigó ―anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","'Lige ku sébale alé Rusaleni, 'lige alemi wa'lú re'obá ilígichi ra'pichí eyénachi alué Esusi, yati alemi jsile alué e'wélala balé, abiena alué Moisesi nila nulalí beníriame, 'lige alué ralámuli jurío nuleme. ");
INSERT INTO tacNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","'Lige anele: ―Mué Esusi, ¿tachiri najtékame nóchali nígame ju mué? ¿Chiérite ajcharu mué napurigá Wa'lula nulame nímala mué? ¿Tachiri gite buyánaché mué ralámuli wa'lú re'obá ra'pichí mochígame ralinea? ");
INSERT INTO tacNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","'Lige Esúsika anele: ―Ne abiénachigó rukimela bilé ra'íchili, 'la ma'chígame nejiáwaká, 'lige 'la ma'chígame nejiásaká 'emi ne 'la ruwimela chonigá tachiri gite buyánigo ne ralámuli jena ra'pichí mochígame ralinea. Nejiásibá: ");
INSERT INTO tacNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Chieri júlaliga Juani ralámuli rewarániliga? ¿Onorúgame o pe ralámuli? ");
INSERT INTO tacNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","A'liko alué e'wélala o'maka chojkile ra'icha a'bopi rukegá, regá anile: ―¿Churigá nejiawa? «Onorúgame júlale», anisúká 'liko animela alué Esusi, ");
INSERT INTO tacNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","«'Liko ¿chonigá ta bijchígirupaché 'emi napu anié Juani?» animela alué Esusi. «Aka pe ralámuli nuléleché», anisúká, alué ralámuli jena ra'pichí mochígame 'we ayómala ramué 'yuga, 'wéchigo 'la bijchígiligame o'maka ralámuli 'we 'la Onorúgamete julárigame níligo alué Juani. ");
INSERT INTO tacNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","A'lígeko regá anile alué ralámuli Esusi olagá: ―Tabilé machiáwé chiérite julárigame níligo alué Juani ralámuli rewarániliga. 'Liko Esusi anile: ―Néchigó tabilé ruwimélachigó tachiri gite buyánigo ne suwábaga ralámuli jena ra'pichí ye wa'lú re'obachi mochígame ralinea. ");
INSERT INTO tacNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","'Lige chojkile Esusi regá anea alué ralámuli: ―Bilé rió 'yele we'lé alé bo'né gawílachi, 'lige we'lé echale we'ká banawá go'ame rakeme i'wilí anilime. Rejkolichi newale bilena i'pichí alé me'chomia alué banawá rakala napu'lige rakesa alué ba'wila ma'chí pamia, 'lige newale bilé galí re'pá ilígame napurigá alué tebume alé asagá tebúmala alué we'ká banawá rakeme. › 'Lige owile jaré rió nóchame napurigá tebúmala, nasípasi meka alué banawá rakala, 'lige alué rió gawígameka simile bilénami mejkami. ");
INSERT INTO tacNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Napu'lige sebasa rawé 'wíliame, alué gawígame 'naka júlale bilé piónila napurigá rojanámala nasípasi napu nachume nile alué rió gawígame. ");
INSERT INTO tacNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Alué tebuka mochígameka tabilé nejínile 'lige 'ma cha'pile alué gawígame piónila alé nawachi, 'ma cho'nale 'lige 'ma kumi júlale 'we ejechasa. 'Liko alué rió 'ma kumi simile tabilé o'ká alué banawá rakala. ");
INSERT INTO tacNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","'Liko alué gawígame uchéchigo bilé piónila júlale, 'lige 'ma sébachi alué piónila alé 'mi 'ma che'wáliru mo'ola bajsibuga rejtete 'lige 'ma kumi juláliru ne'ochasa. ");
INSERT INTO tacNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","'Liko alué gawígame uchéchigo bilé piónila júlale, 'lige 'ma sébachi alué piónila yati me'líliru. Alarigá oláliru suwábaga napu ekí sísiame alemi napu júlale alué gawígame alé. Jaré 'we ejelígame a'rele 'lige jaré 'ma me'ale. ");
INSERT INTO tacNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","› Alésíko pe alué gawígame inolacho rejpile napu 'we a'lá eteme nile 'we a'lá galegá, 'lige abiena aluéchigó júlale mayega 'we a'lá niraga etemio. Regá 'nátale: «Yeka 'la niraga etémalaké ne inolá kame.» Napu'lige alué gawígame inolá sébachi 'mi alé alué banawá jágichi, 'lige anile alué a'boi tebúkame: ");
INSERT INTO tacNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","«Pe aluecho ju alué rió gawígame inolá, 'lige alué júkuru alué o'nola nila nachuámili ye gawí napu'lige o'nola mukusá, alekeri me'liboa, alarigá 'la ramué niga ejtebiwa ye gawí o'nola mukusá», anile. ");
INSERT INTO tacNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","'Lige cha'pisá 'ma me'ale 'lige 'ma pale i'rachi ma'chímana ―anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","'Lige abichilubi anile Esusi: ―¿Alésíko chu'símalawé alué gawígame? Alueka nawámala suwábaga me'limea alué tebume, 'lige uché jaré mochiámala tebútiga alé. ");
INSERT INTO tacNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","› ¿Tabiléchala machí 'emi napurigá aní alué osilí napu chujkú Onorúgame nila ra'íchili? Alué rejté napu gawélile nóchame galí newame, 'lige alué rejteka abé a'lá ma'chínale alé chijtochi ajchalía. ");
INSERT INTO tacNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Onorúgame bo'né alarigá elale. 'Lige ramué a'boi níriga 'we a'lá semáriga na'tawa 'lige 'we a'lá ganíliga mochiwa 'we a'lá semáriga nejkúrichi Onorúgame ―anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Alué e'wélala balé, abiena alué Moisesi nulalila beníriame, 'lige abiena alué ralámuli jurío nuleme, abichilubi 'we me'linalia jale alué Esusi 'we a'lá inámaka akéligime suwábaga alué e'wélala ne'óchiga aníligo alué Esusi alaniá, iligá 'we majale cháchigo we'ká jáligame ralámuli alemi. Alésíko pe a'rele alué Esusi 'lige 'ma simíbale, tabilé che olale. ");
INSERT INTO tacNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Alésíko alué e'wélala balé 'lige alué Moisesi nulalila beníriame, 'lige alué e'wélala napu nuleme ju alué ralámuli jurío, júlale jaré bariseo 'lige jaré Erore gompaniérola rukéniliga jaré ra'íchili pe machináliga chonirá Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","'Lige alué bariseo 'lige alué Erore gompaniérola alemi sigá napu ajtile alué Esusi. Regá rukele: ―Mué beníriame Onorúgame nila ra'íchili, suwábaga ramué 'we a'lá machiaa 'we a'lá bijchiga anió mué suwábaga napu aní mué. Tabilé chéláme ko mué napu aní uché jaré ralámuli. Rekó cha anichi ralámuli mueka abisibi 'we a'lá beníriame ju Onorúgame nila ra'íchili. Mueka tabilé 'yégali ra'íchili beníriame ju. ¿Pala 'la ju nejilia alué enomí napu jena nejílime ju alué wa'lula rey Sesar i'lime? ¿Tabiléchala? ");
INSERT INTO tacNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Alué Esúsika 'we a'lá machile pe resítiri 'nátaga anió alué ralámuli, machile pe resí olániliga anió Esusi alué ralámuli 'yégiga ra'íchanelega, 'lige anile alué Esusi: ―¿Chonigá alaníbiché 'émika pe resí olániliga 'yégiga ra'íchaga? Aka jeka a'pásigo bilé enomí. ");
INSERT INTO tacNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","'Liko alué bariseo 'lige jaré alué Erore gompaniérola yati a'pile bilé enomí chijtúligame bewárigame alué Esusi, 'lige Esúsika rukele: ―¿Chieri mo'ola ju ye mo'ó jena enomichi ajtígame, 'lige chieri rewalá chujkú ye enomichi? 'Liko alué bariséoka 'lige alué Erore gompaniérola anele: ―Pe alué Wa'lula Sesar. ");
INSERT INTO tacNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","'Liko Esúsika anile: ―Napu alué Wa'lula Sesar nila ju, alueka alué Wa'lula Sesar 'yáwaguru, 'lige alué napu Onorúgame nila ju, alueka alué Onorúgame 'yáwaguru ―anile Esusi. 'Lige alué bariséoka 'lige alué jaré Erore gompaniérola 'ma aminabi tabilé che anele, 'ma umérasiga Esúsite. ");
INSERT INTO tacNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Abiena jsile alemi alué saruseo anilime ralámuli, alué napu anime ju tabilé sébame ko rewagachi alué suwígame, 'lige Esusi 'yuga ra'íchale pe'wera, regá anele: ");
INSERT INTO tacNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Mué Esusi ralámuli beníriame, Moisesi a'rele bilé osilí 'we 'ya regá anime: Bilé rió mukusá, 'lige a'resa mukí tabilé 'cho 'wesi 'kúchiga, 'liko alué mukúgame bonila rewimeli ju alué mukí napurigá 'kúchigame nímala alué mukí gunámakame alué mukúgame bonila 'yuga asigá, 'lige alué mukúgame bonila 'kúchila o'chérisa napurigá alué mukúgame 'kúchila kárélamala ―anele alué ralámuli saruseo. 'Lige abiena regá anele: ");
INSERT INTO tacNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","―Sinéchigo mochile gichao ejtemali napu rejimá nile, 'lige alué wa'lula ba'chila rewale mukí sineko, 'lige mukule ba'chila tabilé 'cho 'wesi 'kúchiga. ");
INSERT INTO tacNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","'Lige alué bonila rewale alué repola 'lige 'ma mukúlechigó tabilé 'cho 'wesi 'kúchiga, ");
INSERT INTO tacNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","'lige alué abé u'tabela rewale alué repola 'lige 'ma mukúlechigó tabilé 'cho 'wesi 'kúchigachigó. 'Lige alarigá ikile alué gichao napu chega rijimala nile. Alarigá suwile suwábaga alué rijimá. Alué gichao ejtemali suwírisa, mukule alué mukí ―anile alué ralámuli saruseo. 'Lige alarigá anesa, 'lige regá rukele: ");
INSERT INTO tacNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","―Napu'lige alé rewagachi sebasa alué gichao ejtemali 'lige alué mukí, aleka ¿chieri 'nalina upila nímalawé alué mukí napu alué gichao rió gunámakame nile? ");
INSERT INTO tacNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","'Lige Esúsika nejele: ―Tabilé 'la námaka mochí 'emi tabilé 'la machí 'emi Onorúgame nila ra'íchili, tabilé machí 'emi churigá ko Onorúgame a'walila. ");
INSERT INTO tacNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Alué napu ekí seba rewagachi nibilé umugí nibilé riótiri newímala, aleka suwábaga ralámuli napurigá santo ánjeli nímala, alué 'pa rewagachi mochígame santo ánjeli. ");
INSERT INTO tacNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Aka alué bo'né Moisesi osálige'é pe'kabi osilí napu ruwí rajá ilíligo alué u'tá rojá, alé pe'kabi osilichi ruwí rewagachi simíbame ko ralámuli suwisá. 'Lige alé ruwí regá: «Ne ju Onorúgame 'lige Abraámi ne'chí oyérame ju, 'lige Isaki 'lige Akobo», anime chujkúturu alé osilichi. ");
INSERT INTO tacNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Onorúgame níriká tabilé i'té suwígame. Suwábaga ajágame ju. 'Émika tabilé machí. ");
INSERT INTO tacNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Alemi nawale bilé alué napu Moisesi nila nulalí beníriame nile, alué benírameka akea asale alieri benírachi Esusi, akea asale 'we a'lá nejechi alué Esusi. 'Lige alué benírameka regá rukele alué Esusi: ―¿Tachiri júkó alué nulalí 'we najtékame? ");
INSERT INTO tacNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","'Lige Esúsika nejele: ―Alué 'we najtékame nulalí regá anime júché: «'Emi ralámuli israelita, 'we a'lá 'nátaga gepúwaká ye ra'íchili. Bi'lepi ju Onorúgame abé Wa'lula. Tabilé 'wesi i'té uché bilé. ");
INSERT INTO tacNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","O'maka 'we galewa Onorúgame, 'la bi'lepi 'nátili 'nátaga Onorúgame 'yuga.» Alué ju 'we najtékame nulalí rejcholi. 'Lige uché bilé nulalí rejcholi regá anime júché: ");
INSERT INTO tacNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","«Napurigá galé 'emi a'boi alawala, alarigá galewa uché jaré ralámuli.» Ye oká nulalí rejcholi 'we najtékame ju. Tabilé i'té uché bilé nulalí abé najtékame ―anile alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","'Liko alué benírameka regá anile: ―'We a'lá ju napurigá aní mué, 'we a'lá bijchiga aníbá mué bi'lepi ko Onorúgame, 'lige tabilé 'wesi i'tego uché bilé Onorúgame. Abiena 'we a'lá ju napu aní mué, regá aniá: ");
INSERT INTO tacNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","«O'maka 'we galewa Onorúgame, 'la bi'lepi 'nátili 'nátaga Onorúgame 'yuga. Napurigá galé 'emi a'boi alawala alarigá galewa uché jaré ralámuli.» 'We a'lá ju napurigá aní mué alarigá olásiká 'we a'lá ganíliga asimeo Onorúgame. Onorúgame níriká pecha 'me najtékame kéréko go'ame kógilia napu ju senteno 'lige ri'ligó 'lige baní 'lige me'liá ajágame napu ju akasí, bo'á, 'lige chibá e'kósimia alé amoba napu e'kósilime ju ajágame mayega 'we a'lá nejkúrimio Onorúgame alarigá olásiká ―anile alué beníriame. ");
INSERT INTO tacNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","'Liko Esúsika akisá 'we a'lá machigá ra'íchachi alué Moisesi nila nulalí beníriame, regá anele: ―Amulí 'we a'lá elí mué Onorúgame napurigá alué Onorúgamete nulalime nímala mué alawálachi ―anele. 'Lige alésíko 'ma ta'wesi aminabi rukele. ");
INSERT INTO tacNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Esusi alemi ilile alé wa'lú re'obachi ra'pichí ralámuli beniria Onorúgame nila rejcholi. 'Lige Esusi regá rukele alué ralámuli napu jale alemi gepua: ―¿Chonigá aníché alué napu Moisesi nila nulalí beníriame ju ralámuli, pe Rabí inolá ko alué Kristo? ");
INSERT INTO tacNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Aka aba alué bo'né Rabí aníleché 'ya, 'lige Onorúgame Alawala gu'írile: Alué Wa'lula (Kristo) ne'chí nuleme ju. 'Lige Onorúgame anele alué Wa'lula: «Jena asá wajtoná napusí neyuro ne mué saíla 'yuga.» ");
INSERT INTO tacNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Rabí «Wa'lula» aneme ju 'lige ¿'lacha Rabí inolá nímalawé alué Wa'lula? 'Lige alué ralámulika 'we a'lá gepua jale 'we ra'sálagá. ");
INSERT INTO tacNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","'Lige Esúsika abichilubi 'we benírile alué we'ká ralámuli, regá anile: ―'Emi suwábaga ralámuli tase 'yuga e'yénawa alué we'ká ralámuli Moisesi nila nulalí beníriame, alueka 'we riólame ju i'weli o'páchaga e'yénaga, 'lige 'we najkime ju napurigá 'we a'lá niraga repóriwa alemi we'ká riógichi. ");
INSERT INTO tacNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","'Lige mochínilime ju alé napu mochime ju alué abé najtékame ralámuli alé pachá u'kuchí re'obachi «sinagoga» anilime. 'Lige mochínilime ju go'ame go'mea napu mochime ju ralámuli abé najtékame napu'lige piesta nerúgichi. ");
INSERT INTO tacNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","'Lige we'lisi jame ju iwérali tania Onorúgame alé re'obachi napurigá pe a'boi najkime ju napurigá suwábaga ralámuli machimela. 'We a'lá 'nátaga, alué Moisesi nila nulalí beníriame 'ma bujeme ju galí alué umugí gunámakame. Alueka abéchigo wa'lú gastigo narémalagó. ");
INSERT INTO tacNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Esusi alé re'obachi asagá kilí a'bé napu gajoni bo'ile enomí mochígame, alé etele Esusi we'ká rió 'we inígame enomí mochichi alé gajónichi. ");
INSERT INTO tacNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Abiena etele bilé mukí gunámakame mochichi oká enomí ejchirúligame 'we pee najteme. ");
INSERT INTO tacNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","'Liko alué Esusi bayele alué bo'né 'yuga járome, 'lige anele: ―'La bijchiá ye mukí gunámakame 'we resítiri tabilé we'ká enomí mochíkuru enomí pe napu ekí nígame nílige. Onorúgame níriká abé najtékame ju napurigá 'sile alué mukí me'tagá alué ralámuli 'we enomígame, ");
INSERT INTO tacNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","napugiti suwábaga ralámuli 'we enomígameka nejime ju enomí pe rasírigame, 'lige ye mukika 'ma nejíkuru suwábaga napu ekí nígame nílige, go'ame raliméleké aleké enomite. Tabilé nígame nile uchérajpé ―anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Napu'lige ma'chínasa Esusi alé ra'pichí wa'lú re'obachi, bilé alué 'yuga eyéname anele: ―E'né mué, ramué beníriame, ¡chiena 'la e'wele rejtete newáriliga ye re'obá, 'lige chiena 'la wa'lú re'obá newáliru, 'we semátiri! ");
INSERT INTO tacNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","'Lige Esúsika nejele regá anigá: ―Júwé, 'we semati júke'é, nobi 'máchigo gajunáwili júkó bilé rawé, suwábaga ye rejté napu eté 'emi ye wa'lú re'obá newárigime wijchí mochímala gajuga. ");
INSERT INTO tacNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","A'lige Esusi simile alé na'lebo 'nálige gomichi Olibo rewégame rabó 'lige alemi asíbale. 'Lige alué 'yuga járome Pegro, 'lige Santiago, 'lige Juani 'lige Antresi, alé mochiga rukele alué naó rió alué Esusi: ");
INSERT INTO tacNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―¿Chiéniko gajúmala alué wa'lú re'obá napurigá anié mué? ¿Churigá 'la machiboa 'ma sebamio raweli 'ma gajúmili ko alué wa'lú re'obá? ");
INSERT INTO tacNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","'Lige Esúsika nejele, regá anile: ―'We a'lá 'nátaga mochiwa napurigá tabilé 'wesi 'yégamala se'nú ra'íchili ruigá napurigá oyéramala 'emi. ");
INSERT INTO tacNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","E'yénamala we'ká ralámuli regá anisia: «Ne júkuru 'la bijchiá Onorúgamete julárigame», animela. ");
INSERT INTO tacNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","› 'Lige we'ká ralámuli bijchígimala alué 'yégali. 'Lige napu'lige ruyésiga 'emi nakó nerúlimio, tabilé majawa napugiti nerúlimili kame nakólime bajchá, nobi tabiléchigo 'cho suwibámili júkó ye gawí. ");
INSERT INTO tacNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Alué we'ká ralámuli bilena gawichí ejperégame nakómala uché bilena gawichí ejperégame sayega 'yuga. 'Lige gawí a'wágame nokamela ichúrimi gawichí, 'lige 'we gurúlamala go'ame, tabilé i'télimempá go'ame, 'lige nerúlamala naulítiri. Alakichi, tabilé 'cho sebámala aleké rawé, uché rajpé resíriga nímala abe. ");
INSERT INTO tacNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Abiena anele alué Esusi alué naó rió bo'né 'yuga járome: ―'We a'lá 'nátaga mochiwa 'emi. Sebámala bilé rawé napu a'lige o'toboli ju 'emi galírale mo'amia. Abiena o'toboli ju 'emi alé u'kuchí re'obachi napu «sinagoga» anilime ju, alé o'togá wejpisópua 'emi, 'lige abiena o'toboa 'emi alé napu e'wélala selígame mochí 'lige alé napu ajtí alué wa'lula rey ruwimela 'emi 'we a'lá bijchígime ko 'emi Onorúgame ra'ichálila. ");
INSERT INTO tacNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Bajchibé ta'chó gajuchi gawí, bochígimi gawichí sebámili júkuru ye ra'íchili 'we a'lala Onorúgame nila. ");
INSERT INTO tacNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Napu'lige o'towá 'emi galírale mo'amia, tase we'ká na'táwaká alarigáriga animea. Napu'lige o'wina 'emi ra'icha 'mi alé ra'íchili gatélichi, Onorúgame nejímala iwérali napurigá 'la gainámala 'emi ra'icha, pe bi'lepi 'nátili ra'ichámala 'emi, pe alué 'nátili napu nejí Onorúgame napugiti tabilé 'oni nímala 'emi ra'íchame, Onorúgame Alawala ra'ichámala 'emi chu'álachi. ");
INSERT INTO tacNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","'Lige bilé rió ba'chirúgame tabilé oyérame ne'chí, bo'né bonila nejímala alé 'mi ra'íchili gatélachi napurigá cha'piboa 'lige napurigá me'liboa cha'pisá pe ne'chí oyérame kóriká. O'nola tabilé oyérame nisa ne'chí, 'lige 'kúchila 'la oyérame nisa ne'chí, o'nola 'ma nejímala alé ra'íchili gatélachi alué 'kúchila napurigá me'liboa alué 'kúchila ne'chí oyérame kóriká. 'Lige jaré 'kuchi tabilé oyérame nisa ne'chí 'lige o'nólaka 'la oyérame nisa, 'ma nejímala alué a'boi o'nola o eyela ma napurigá me'liboa ne'chí oyérame kóriká. ");
INSERT INTO tacNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Suwábaga alué ralámuli ne'chí oyérame, we'ká ralámulite tabilé galewa. Suwábaga ralámuli ne'chí oyérame 'la anachasa napusí suwí, alueka 'la 'pa rewagachi sebámala. ");
INSERT INTO tacNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","› Napu'lige etea 'emi alué rió pe 'yégali ruwime alé pachá re'obachi, 'we 'yégame napurigá Remónisi, 'we a'lá na'tawa napurigá anime osale alué Ranieli 'we 'ya. Napu ekí 'la osilí ra'íchame nile alué apeli 'we a'lá inámaka ra'íchawa. A'lige rawé napu ekí mochírupá alé Jurea anilichi ejiro 'lige etésiga alué 'yégali ruyeme ralámuli yati júmisiwa chíbimia alé gawichíkami. ");
INSERT INTO tacNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","'Lige napu ekí alé galimopa mochiga etésiga alué 'yégali beníriame ralámuli, tase mo'iboa alé a'boi galílachi pachá tábiri 'mea, yati júmisiwa 'nalina. ");
INSERT INTO tacNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","'Lige apiépiri ralámuli alé 'mi asarachi mochisa napu ju echiachi, alé mochiga etesa alué 'yégali beníriame ralámuli tabilé simawa ku galírale we'lí o'pacha nolamia, aminá júmisiwa 'nalina. ");
INSERT INTO tacNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Resía alué umugí napu rojpega mochí a'lige rawé o napu ekí u'kuchí 'kúchiga mochí a'lige rawé, tabilé gainámala júmasia! ");
INSERT INTO tacNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Onorúgame tániwa napurigá tabilé romó nolínamala alué rió 'yégali beníriame ralámuli, ");
INSERT INTO tacNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","napugiti cha resíriká nímempá a'lige rawé, ta'wesi rawé anaga. 'Yako tabilé siné aliena enárigá nile, napusí sebasa alué rió 'yégali ruyeme ralámuli a'lige kulí 'we enárigá nímala. 'Lige abé a'kinana tabilé enárigá nímala. ");
INSERT INTO tacNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Onorúgame tabilé elámala napurigá we'ká rawé resí ikimela ralámuli. Onorúgame elásaká napurigá we'ká rawé resí nílamala ralámuli 'liko 'ma suwimela suwábaga ralámuli. Onorúgame 'we galé alué ralámuli napu ekí 'la bijchígame ju Onorúgame nila ra'íchili, alekeri pe'wera resí nílimala ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Abiena anele Esusi: ―Napu'lige sebasa raweli, tase bijchígiwaká napu aní ralámuli. Jaré ralámuli regá animela: «E'nésibá, jena ajtí alué Onorúgamete julárigame rió o'wé jawániliga.» 'Lige jaréchigo animela: «E'nesi, 'mi ajtí alué Onorúgamete julárigame rió o'wé jawániliga.» Tase oilawa, tabilé Onorúgamete julárigame ju alué rió. ");
INSERT INTO tacNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","We'ká sebámala alué 'yégame Onorúgamete julárigame korime ralámuli o'wé jawániliga, 'lige jaréchigo ruwime korimela napu anele Onorúgame. 'La suériga ra'íchiga 'yegámala, 'we a'lá semá nokimela, 'la 'yonti ka nokimela, napurigá 'la najátamala suwábaga napu ju 'emi ne'chí oyérame. ");
INSERT INTO tacNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","'We a'lá 'nátaga, ne 'we a'lá ruwíguru jipe bajchabé tabilé 'cho alakichi. ");
INSERT INTO tacNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","› Napu'lige 'ma simírisa alué resítiri raweli, rukuámala, 'lige alué rayénali 'ma tabilé ra'ósiga asimela, 'ma tabilé mechega ilimela rukó, ");
INSERT INTO tacNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","'lige so'pilí rujsúmala, 'lige suwábaga nokomela alé rewagachi nerúgame. ");
INSERT INTO tacNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","A'lige etémala 'emi re'kíname alué Onorúgamete julárigame alé 'pa rewagáchikana napurigá rió neraga nolíralekana (napu ju Esusi) , 'we a'wágame 'lige 'we semátiri, 'we a'lá nirálime. ");
INSERT INTO tacNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","'Lige yati julámala we'ká santo ánjeli alé 'pa rewagachi mochígame alué ralámuli napubúniliga napu ju alué Onorúgame oyérame ralámuli, bochígimi gawichí julámala alué santo ánjeli 'lige bochígimi alé 'pami rewagachi julámala napubúniliga. ");
INSERT INTO tacNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","› 'We a'lá benisíbá ye 'nátili churigá ka bilé chuná: Napu'lige ku uché 'we chi'lame kachi alué chuná atawala guwala, 'lige 'ma ku sawarachi, «'ma amulí seba bamunú» aniame júturu. ");
INSERT INTO tacNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","A'chigóriga júkuru, napu'lige 'ma mukusá rayénali 'lige rujsuchi so'pilí, machiboa 'ma a'mulipi ko raweli Onorúgamete Julárigame ku nawámichi. ");
INSERT INTO tacNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Neka 'la bijchiá 'la ruwí, suwábaga alarigá ikimeo ta'chó suwichi ralámuli jipe ejperégame. ");
INSERT INTO tacNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Rewagá 'lige gawítiri siné rawé 'ma tabilé ne ikimela nobi ne nila ra'íchalika tabiléchigo siné we'kámalagó. ");
INSERT INTO tacNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","› Tabiléchigo 'wesi machígó aliéniko alakimeo, nibilé alué santo ánjeli 'pa rewagachi mochígame machí, nibilé alué Onorúgame Inolá machí, pe Onorúgamecho 'la machí aliéniko alakimeo. ");
INSERT INTO tacNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","› 'We a'lá 'nátaga mochiwa, 'lige 'we a'lá tania mochiwa Onorúgame a'walila napurigá tabilé che ikimela 'emi, pecha 'wesi machigá mochígame aliéniko ku uché nawamio Onorúgame Inolá. ");
INSERT INTO tacNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Alué 'nátilika a'chigóriga ju napurigá alué rió napu simile mejkami, 'lige a'rele alué bo'né galila 'lige nóchame a'rele repútiga alué galí, 'lige a'pílipi nóchame 'yasa a'rele nóchali i'wana, 'lige ajchale bilé rió alé yochi 'lige 'we a'lá anele napurigá 'we a'lá 'nátaga asimela 'we a'lá repuka. ");
INSERT INTO tacNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","'We a'lá 'nátaga mochísigó, pecha 'wesi 'la machigá mochígame aliéniko nawamio alué galí nígame, chónachi nawámaré siné kachi o nasipa rukomi nawámaréma siné kachi, o'tolí sinachi sebámaréma siné kachi, 'ma che'lachi sebámaréma, pecha machirua. ");
INSERT INTO tacNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","'We a'lá 'nátaga mochiwa 'la e'negá, napurigá 'la tabilé okoka bi'tígame rewimela ku nawagá. ");
INSERT INTO tacNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ye ra'íchili napu ruyé ne 'emi, ruwí ne napurigá suwábaga ralámuli machigá mochímala. ¡'We a'lá e'negá mochísigó! ");
INSERT INTO tacNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","'Ma oká rawé rokáréle sebamia raweli wa'lú omégachi napu wa'lú piesta newame nile ralámuli jurío, Páskua anilime omali napu baní go'yame nile alué ralámuli jurío, tase kawali (lebarura) ro'igá newárigime baní. 'Lige alué e'wélala balé 'lige alué we'ká rió Moisesi nílala nulalí beníriame 'nátale churigá 'la níligo cha'piá Esusi 'yégiga ra'íchaga, 'lige me'liá. ");
INSERT INTO tacNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","'Lige jaré alué balé 'lige jaré alué Moisesi nílala nulalí beníriame anile: ―Tabilé chérigá me'liboa wa'lú piesta nerúgichi, cha we'ká rioga ilimémpá, we'ká ralámuli mochímala Esusi machime, 'lige bochí animela akiná. ");
INSERT INTO tacNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Esúsika simílige alé we'ká riógichi Betania rewégichi, Simoni rewégame rió bejtélachi napu abé 'yabé 'we nayume nílige alué 'we chátiri wejchagoni («lepra» anilime nayulí yolí ra'íchaga). Napu'lige alé galírale ajtígichi go'ame go'yá alé re'lé ilígame mésachi kilí gayena asagá go'yame nile go'ame, a'lige bajkile bilé mukí alemi bilé u'tá botea rejtete newárigime o'ká nawá ba'wila ro'ágame 'we semá júkame. (Yolí ra'íchaga «nardo» anilime ju alué nawá.) 'We najteme nile, tabilé na'lógame ba'wí. Alué mukí 'ma gajsínale alué u'tá botea o'palala 'lige Esusi mo'ólachi ro'ele alué ba'wí 'we semá júkame. ");
INSERT INTO tacNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","'Lige jaré alemi mochígame tabilé galele, 'we ayole, 'lige regá anile a'boi: ―¿Chonigá suwábaga ro'éleché alué nawá ba'wila Esusi mo'ólachi? 'Ma cha olákuru, 'ma suwábaga go'líkuru. ");
INSERT INTO tacNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","'We a'lá najtegachi ralinétélikuru, napu ekí meme ju bilé rió bilé bamí nóchaga. 'Lige suwábaga alué enomí alué 'we resítiri ralámuli kógitélikuru tabilé enomígame. Alarigá anile alué ralámuli 'lige 'we ayoa mochile alué mukí 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","'Liko Esúsika anele alué ralámuli: ―'Ma tabilé chati 'nata mochisi. Ye mukika 'we a'lá semá 'smíkuru alué nawá ba'wila 'we semá júkame ro'ea ne'chí mo'ola. ");
INSERT INTO tacNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Alué 'we resítiri ralámuli tabilé nígame, alueka senibí mochímala napu 'emi mochí, 'lige 'la gu'írinilisiká 'emi, gu'íriwagó alué ralámuli tabilé nígame enomí napu'lige 'emi gu'írinilisa, nobi neka tabiléchigo we'lisi asimélagó 'emi 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ye mukika 'ma bajchabé neraga ro'ékuru ne'chí alué nawá ba'wila 'we semá júkame napu ro'émili nílige ne'chí napu'lige ne mukú. Ye mukika 'we a'lá semá 'smíkuru. ");
INSERT INTO tacNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Neka 'we a'lá bijchiá aníbá, napu'lige ralámuli napunápurimi gawichí beniria Onorúgame nila ra'íchili, 'we a'lá ruká ra'ichámala napurigá 'sile ye mukí jipe rawé, alarigá 'la machigá mochímala ralámuli, 'lige tabilé siné we'kuámala. ");
INSERT INTO tacNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","A'lígerikáchi alué Jurasi Iskariote, bilé alué makué oká Esusi 'yuga járome, simile alué e'wélala balé 'yuga ra'ichamia, regá anemia: ―Ne 'la nejkúrimala Esusi cha'piá. ");
INSERT INTO tacNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Napu'lige akisá alué e'wélala balé 'we a'lá nerale 'lige 'we ra'sálále, 'lige regá anile: ―Ramué najtétiwa mué 'la nejkúrisaká Esusi cha'piachi. Alésíko alué Jurasi Iskariote chojkile 'nata chiéniko kochiena 'la ko Esusi cha'piá. ");
INSERT INTO tacNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Sébale raweli Páskua piesta oliame, baní go'achi tase kawali ro'igá newárigime, a'lige rawé napu ekiná riógichi me'liame nile galírale bilé bo'á Onorúgame kógimia. (Alueka pe 'nátaga nokame nile napu'lige alué santo ánjeli tabilé me'ale alué bajchá o'chérigame ejtemali israelita alé Ejipto.) A'lige rawé alué Esusi 'yuga járome rukele alué Esusi: ―¿Koche 'la nítékó alué go'ame newalía Páskua piesta oliachi go'yame? ");
INSERT INTO tacNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","'Lige Esúsika júlale oká alué bo'né 'yuga járome regá anegá: ―Simíbaga alé Rusaleni, 'lige alé najtepámala 'emi bilé rió ba'wí o'kame bilena sikolichi, 'lige yati najátawa, ");
INSERT INTO tacNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","'lige napu bajkí alé galírale osámana ilígame, anewa alué rió galí nígame: «Alué wa'lula ramué nuleme regá aní: ¿Koche go'mela ne go'ame ne 'yuga járome 'yuga alué go'ame jipe alí go'yame Páskua anilime piesta sebasa?» ");
INSERT INTO tacNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","'Lige alé o'toboli ju 'emi bilé galí osámana ilígame, alué galí amoba ilígame tanéwili ju 'emi, 'lige regá animela alué galí nígame: «Ye galí amoba ilígame unéwagó, jena newawa go'ame, 'ma 'la sébali nerúturu suwábaga tábiri napu unémala 'emi», animela. 'Lige 'emi alé newawa go'ame, o'maka ramué go'ame. ");
INSERT INTO tacNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","'Lige alué oká rió Esusi 'yuga járome simíbale alé Rusaleni 'lige najtépale bilé rió ba'wí o'kame bilena sikolichi, 'lige yati najátale 'lige mo'ile 'pa amoba osámana ilígame galichi, 'lige etele 'ma 'la sébale nerugo suwábaga tábiri go'ame newala, 'lige alé newale alué go'ame Páskua anilime piesta sébachi go'yame. ");
INSERT INTO tacNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","A'lige 'ma chonaso sébale Esusi bo'né 'yuga járome 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","'Lige 'ma alé mésachi mochiga go'yá, Esusi anele alué bo'né makué oká 'yuga járome: ―Bilé 'emi ne bo'né 'yuga eyéname napu go'yá ajtí jena ne 'yuga, 'ma ne saíla kéré. Nejkúrimala ne'chí cha'piachi. ");
INSERT INTO tacNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Napu'lige akisá alué Esusi 'yuga járome alanichi Esusi, suwábaga 'we sewele, 'lige a'pílipi anele alué Esusi: ―Neka tabilé júché. ");
INSERT INTO tacNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","'Lige Esúsika regá anele: ―Pe bilé ne 'yuga járome ju, napu ne 'yuga go'yá ajtí jena. ");
INSERT INTO tacNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Onorúgamete julárigame 'pa rewagáchika napurigá rió neraga 'ma me'liboli ju napurigá aní osilichi napu ju Onorúgame nila. 'Lige alué rió napu nejkúrimala ne'chí cha'piá wa'lú gastigo rewimela. Abé 'la nítélige alué rió tabilé ocheria. ");
INSERT INTO tacNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Napu'lige go'yá mochiga go'ame, Esúsika 'wile bilé baní, alué baní napu tabilé ro'igá newárigime nile kawali, 'lige cheliera 'yale Onorúgame, 'lige 'ma cheliera 'yasa Onorúgame, chi'wánale alué baní, 'lige 'yale alué makué oká rió bo'né 'yuga járome, 'lige regá anele: ―Go'sí, yeka ne sa'pala ju. 'Lige go'ale. ");
INSERT INTO tacNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","'Lige 'wile alué baso napu ro'agá bajílime nile i'wilí ba'wila rekútame, 'lige 'ma cheliera 'yasa Onorúgame, 'yale alué bo'né 'yuga járome 'lige o'maka bajile, ");
INSERT INTO tacNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","'lige Esusi regá anele alué bo'né 'yuga járome: ―Ye i'wilí ba'wila pachágana manígime ne elalá ju, alué elá napu ma'chínimili ju ne me'liachi, 'lige ne mukugá wa'lú gu'írimili ju ne 'emi ralámuli, regá gatele Onorúgame ralámuli jipe ejperégame gu'írimia napurigá 'la bi'wígame alawégame nímala. ");
INSERT INTO tacNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Neka 'la ruwí, tabilé uché bajimio ne ye pachágana manígime i'wilí ba'wila, napu'lige uché chokía ralámuli Onorúgame nulea, a'lige kulí uchéchigo bajímala ne. ");
INSERT INTO tacNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","'Ma go'sá 'lige wikarale Onorúgame wikala, 'lige wikarasa simíbale na'lebo 'nálige rabó Olibo rewégichi. ");
INSERT INTO tacNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","'Lige Esusi regá anele alué makué oká rió bo'né 'yuga járome alé rabó: ―Jipe rukó, suwábaga 'emi ne 'yuga járome, 'ma a'rémala 'emi ne'chí. Aka regá anime chujkúché bilena alé Onorúgame nila apélichi: «'Ma me'liboli ju alué bo'á neseme, 'lige alué bo'aka 'ma ra'lá mo'bámala ichúrimi.» ");
INSERT INTO tacNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","'Lige ne ku ajánasa, alé Galilea simé ne bajchabé ta'chó jsichi 'emi alemi ―anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","'Lige Pégroka anele Esusi: ―Rekó uché jaré 'ma suwábaga simíbige, neka abichilubi mué 'yuga einámala. ");
INSERT INTO tacNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","'Lige Esúsika regá anele alué Pegro: ―Jipe rukó be'bé ta'chó sinachi o'tolí osá, baisá animela mué: «Tabilé machí ne Esusi.» ");
INSERT INTO tacNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","'Lige Pégroka uchéchigo abichilubi, regá anele: ―Rekó me'liáe ne, neka tabilé majámala ruigá 'we a'lá machime ko ne mué. Suwábaga alué Esusi 'yuga járome alanílechigó. ");
INSERT INTO tacNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","'Lige sébale alé we'ká Olibo nerúgachi Jetsemaní rewégichi, 'lige alé alué Esusi regá anele alué bo'né 'yuga járome: ―Jena ejtebíwagó 'emi, neka Onorúgame tánimala iwérali. ");
INSERT INTO tacNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","'Lige pe alué Pegro 'yuga simile alué Esusi, abiena alué Santiago (Akobo) 'lige alué Juani, 'lige 'we sewele alemi alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Regá anele alué Esusi alué bakiá rió: ―'We chálá ne, amulí mukú ne seweka. 'Emi bakiá jena ejtebíwagó, 'lige tase okópua, 'la e'negá mochiwa. ");
INSERT INTO tacNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Alésíko alué Esusi simile abé a'mibemi waná Onorúgame 'yuga ra'ichamia, iwérali tánimia, 'lige alé wijchí chujkíbale ajkaná, 'lige tánale Onorúgame napurigá tabilé resí ikimela alué bo'né Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Regá anile Esusi: ―Mué ne O'nola («Abba» anile bo'né ra'ichálila.), mueka wa'lú a'walí nígame ju, neka tabilé najkí napurigá ralámuli resí olámala ne'chí. Mué najkisáká, abirigá resí ikiméleké ne ―anile. ");
INSERT INTO tacNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","'Lige sébale ku alé napu a'rélige alué bakiá bo'né 'yuga járome, 'lige 'ma okókame rewale. 'Lige Esusi anele alué Simoni (napu abiena Pegro anilime nile): ―¿Gojchigá bo'í mué Simoni? ¿Nibilé pe bilé 'ora anáchapá mué tabilé gojchigá? ");
INSERT INTO tacNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","'We a'lá e'negá mochiwa, 'we tana mochiwa Onorúgame napurigá ta neyúrimala Remónisi nila 'nátili. 'Émika 'we a'lá sébali olánilime ju, eligá 'emi tabilé sébali olame ju. ");
INSERT INTO tacNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Esúsika uchéchigo simile Onorúgame 'yuga ra'ichamia iwérali tánimia a'chigóriga napurigá pe be'bepi. ");
INSERT INTO tacNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","'Lige uchéchigo siné ku sébale napu a'rélige alué bo'né 'yuga járome 'lige uchéchigo siné okókame rewale. Noli 'ma tabilé gayena e'negá mochiga, 'lige nobi tabilé chérigá nejiasa nílile rukilía Esúsite chonigá okoka bi'tigó. ");
INSERT INTO tacNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","'Lige uchéchigo siné simile Onorúgame si ra'ichamia 'lige uchéchigo nawale Esusi alé napu a'rélige bo'né 'yuga járome, 'ma baisá nile. 'Lige regá anele bo'né 'yuga járome: ―¿Abijí okoka bi'tirú? 'A bujsirésibá. 'Ma we'lisi okole 'emi, ya 'ma cha'piboli júpá ne jipe kulipi alué napu Onorúgamete julárigame ju 'pa rewagáchika napurigá rió neraga. 'Ma aleka e'yena alué ralámuli cha nokame. ");
INSERT INTO tacNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡O'weti mochisi, 'ma simawa, 'ma a'beka ená alué napu ne 'yuga eyéname nílige, 'ma a'beka ená nejkúrimia ne'chí cha'piá! ");
INSERT INTO tacNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Bijí ra'icha ilígichi Esusi alemi sébale alué Jurasi napu 'yabeko Esusi 'yuga eyéname nílige. Jurasi we'ká rió 'yuga enale 'lige alué we'ká rió siparina o'ká e'yénale 'lige i'weli gusítiri. 'Lige alué e'wélala balé 'lige alué Moisesi nila nulalí beníriame 'lige alué jurío ralámuli nuleme, aluete julárigame nile alué ralámuli Esusi cha'píniliga. ");
INSERT INTO tacNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","'Lige alué Jurasi napu nejkúrisia enale cha'piachi Esusi, regá anele alué we'ká ralámuli: «Alué napu chu'migá repori ne alué ju Esusi, yati cha'pibóaká 'lige o'tobóaká», regá anele. ");
INSERT INTO tacNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","'Lige alemi sébaga alué Jurasi regá anele alué Esusi: ―¡Mué Wa'lula ramué beníriame! 'Lige alarigá anesa, yati chu'mile banachí. ");
INSERT INTO tacNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Alésíko alué we'ká ralámuli yati cha'pile alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","'Lige bilé rió Esusi 'yuga eyéname yati ma'chí pale siparina 'lige 'ma rejpúnale najkala bilé alué wa'lula balé piónila. ");
INSERT INTO tacNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","'Lige Esúsika regá anele alué we'ká ralámuli: ―¿Chonigá sirúpaché siparina o'ká igútiri ne'chí cha'pimea? ¿Chigórigame ju ne? ");
INSERT INTO tacNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Aka ne alé wa'lú re'obachi ra'pichí a'sáché 'emi beniria Onorúgame nila ra'íchili, aka aleka peka siné cha'píché 'emi ne'chí. Peba alarigá nímili nílige, siné rawé cha'piboli nílige ne napurigá aní alué Onorúgame nila ra'íchili. ");
INSERT INTO tacNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","'Liko suwábaga alué Esusi 'yuga járome 'ma júmasale, 'ma bi'neli a'réleru Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Napu'lige Esusi o'tiachi, nujubá enale bilé re'malí, pe bilé chiní manta gemagá, tase o'páchaga, 'lige alué Esusi o'tome ka me'lísale alué re'malí 'lige pe alué chiní manta cha'pile, ");
INSERT INTO tacNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","iligá alué re'malika neyúsale 'lige 'ma 'yeri 'ma kíbale, pe alué chiní manta cha'pigá rejpile alué cha'pime ka. ");
INSERT INTO tacNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","'Lige 'ma o'tóliru alué Esusi alué wa'lula balé bejtélachi. Alé napaíle alué e'wélala balé, 'lige alué jurío ralámuli nuleme, 'lige alué Moisesi nila nulalí beníriame. ");
INSERT INTO tacNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Napu'lige Esusi o'tiachi, alemi guwánami enale alué Pegro 'naka boichika, 'lige alué Pegro alemi ra'pichimi sébale alé wa'lula balé galílachi ra'pichí, 'lige alé asíbale sujkáliga re'obachi tebume 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","'Lige alué e'wélala balé 'lige suwábaga alué e'wélala nuleme 'we jale rukea e'karúriga, pe machináliga chonirá 'lige churigáriga 'la níliga me'liá alué Esusi, tabilé rewale napurigá me'liboa Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Jaré 'we jale 'yégali ruyá, tabiléchigo neyúrale ko pe ichúromi chibirigá ruwíligame, 'lige jaréchigo se'wináriga ruwíligame, tabilé bi'lepi 'nátale. ");
INSERT INTO tacNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","'Lige jaréchigo abiénachigó pe 'yégiga, regá anile: ");
INSERT INTO tacNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Ramueka akirúturu regá anichi ye: «Ye wa'lú re'obá ralámuli newálala 'ma gajunámala ne 'lige bakiá rawé kachi uchéchigo bilé newámala ne, alueka tabilé ralámuli newalila nímala» aniéturu. ");
INSERT INTO tacNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","We'ká ra'íchale kákobá, tabiléchigo bi'lepi 'nátali ra'íchale ko, cha ichúromi chibirigá ruwíligame. ");
INSERT INTO tacNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","'Liko alué wa'lula balé o'weti ilísale, 'lige alé iligá rukele alué Esusi: ―¿Bijchiga aní ye ralámuli napurigá aní? ¿Chonigá ta nejé mué? ");
INSERT INTO tacNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Esúsika tabilé nejele. 'Liko alué balé wa'lula uchéchigo rukele, regá anele: ―¿Mué ju alué Kristo, alué Onorúgame Inolá? ");
INSERT INTO tacNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","―Júwé, ne ju ―anile alué Esusi―. 'Lige 'emi etémala alué napu Onorúgamete julárigame ju 'pa rewagáchika rió neraga napu'lige ku 'pa rewagachi ajtígachi Onorúgame 'yuga, 'lige abiena etémala 'emi napu'lige ku 'pa rewagáchikana nolíralekana enágichi. ");
INSERT INTO tacNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","'Liko alué wa'lula balé banasuka chi'wánale bo'né o'páchala. (Alueka ruwime nile 'we ayóligo alué wa'lula balé alanichi alué Esusi.) 'Lige regá anile: ―Ya 'ma 'we a'lá sébali akirúke'é, tase rokáré uché bilé rió napurigá ra'ichámala Esusi saíla neraga. ");
INSERT INTO tacNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Suwábaga 'emi 'we a'lá aké Onorúgame saíla niraga ra'ichio ye Esusi. ¿'Émika chonígó? ¿Cholátékobá? 'Lige suwábaga ralámuli 'we anile napurigá me'liboa alué Esusi ra'íchaligo Onorúgame saíla neraga. ");
INSERT INTO tacNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jaré ralámuli a'kachípale gawéliga alué Esusi, 'lige bulele busila 'lige a'wágame o'chole, 'lige regá anele: ―¡Machígobá chieri 'siá mué o'choa! 'Lige alué re'obachi repúmeka 'we o'chole Esusi banachí sekate. ");
INSERT INTO tacNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Napu'lige Pegro alé ra'pichí ajtígichi, alemi nawale bilé mukí napu newime nile go'ame wa'lula balé, ");
INSERT INTO tacNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","'lige alué mukí Pegro etesa alemi ajtígame sujkáliga, we'lisi e'negá ilile, 'lige anele: ―Muéchigó abiena 'yuga eyénituru alué Esusi Nasareta bejtégame. ");
INSERT INTO tacNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","'Lige Pégroka anele: ―Neka tabilé machime ju alué Esusi, neka pecha machígó chonigá anió mué. 'Lige abé a'mibemi simile Pegro alé yochi. A'lígerikáchi sinale bilé o'tolí owila. ");
INSERT INTO tacNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","'Lige alué mukí go'ame newime balé wa'lula napu'lige etesa alé yochi alué Pegro, anele uché jaré napu e'yénale alemi yochi: ―Ye rió Esusi 'yuga eyéname ju. ");
INSERT INTO tacNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","A'liko Pégroka chéchigo siné anile: ―Neka tabilé machiáwé Esusi. 'Lige alué ralámulika regá anile: ―Bijchiá mué alué Esusi 'yuga eyéname ju, mué Galilea bejtégame kámechigó, napugiti napurigá Galilea ejperégame ra'íchame kame mué. ");
INSERT INTO tacNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","'Liko Pégroka uchéchigo siné tabilé machióríle Esusi: ―Onorúgame gastigárime ke ne'chí ta bijchiga anisáká ne ―anile Pegro. ");
INSERT INTO tacNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","A'lige uché sinale o'tolí, 'ma osá nile siná. 'Liko alué Pegro nélále napu anélige Esusi. Regá anélige Esusi: «Mué Pegro, ta'chó osá sinachi o'tolí owila, baisá 'yegámala mué, tabilé machióriméla mué ne'chí.» Alieti nélegá, e'wele nalale alué Pegro. ");
INSERT INTO tacNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Napu'lige che'lisá, napaíle alé alué e'wélala balé 'lige alué jurío ralámuli nuleme 'lige alué Moisesi nulalila beníriame, napaíle alé o'maka ra'ichamia machimea cholátiká alué Esusi. 'Ma suwénasa ra'icha, o'tole alué Esusi 'we a'lá bulugá sekala alé 'mi wa'lula selígame Pilato ajtígichi. ");
INSERT INTO tacNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","'Lige alemi o'tosá Pilátoka rukele Esusi: ―¿Mué ju Wa'lula rey alué ralámuli jurío nuleme? 'Lige Esúsika anile: ―Júwé, tase napurigá mué 'nata ―anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","'Lige alué balé e'wélalaka abiena we'ká ra'icha jale alué Esusi sayega, 'we cha 'síkame kóríle Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","'Liko alué Pilato uchéchigo rukele: ―¿Ta nejiama olá mué? 'La chekí tábiri ruyáníguru alué e'wélala balé. ");
INSERT INTO tacNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Esúsika abirigá tabilé pe'tá nejele. Alué wa'lula selígame Pilátoka lale: «¿'La chonigá tabilé majáché? Peka nejé aníguru», 'lale. ");
INSERT INTO tacNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nabí bamí Páskua piéstachi, Pilato su'páchame nile bilé nejkógame galírale bajcháriga ajtígame. Ralámuli a'boi 'la anime nile chieri 'la nítiká ma'chí pasía. ");
INSERT INTO tacNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","A'lige rawé mochile jaré rió me'ágame galírale mo'áriga, 'lige bilé Barabasi anilime nile. Barabasi 'lige alué uché jaré rió napuíka e'yéname nile nakoga. ");
INSERT INTO tacNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","'Lige alemi napaíle ralámuli, 'lige tánale alué wa'lula selígame Pilato napurigá ma'chí pámala bilé napurigá 'sime nile alué Pilato napu'lige alué Páskua piesta nerúgichi. ");
INSERT INTO tacNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","'Lige Pilátoka rukele ralámuli: ―¿Najkí 'emi napurigá su'panawa alué Wa'lula Rey ralámuli jurío nuleme? (Pe Esusi olagá anile alué Pilato.) ");
INSERT INTO tacNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Alarigá anile alué Pilato, 'we a'lá machíligame pe gichiga o'tóligo alué e'wélala balé. ");
INSERT INTO tacNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","'Lige alué e'wélala baleka abéchigo 'we jale ruyea ralámuli napurigá 'we animela ralámuli ma'chí pánalia alué Barabasi 'nalina tase alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","'Lige Pilato uchéchigo siné rukele alué ralámuli: ―¿'Émika choliame najkí alué napu 'emi Wa'lula Rey ralámuli jurío nuleme aneme ju? ");
INSERT INTO tacNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","'Lige ralámuli regá anile a'wágame: ―¡Gulusichi ujchawa! ―noli bochí anile. ");
INSERT INTO tacNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","'Lige Pilátoka uchéchigo rukele: ―¿Tachiri chu'síkame júkó ye rió? 'Lige ralámulika uchéchigo anile abé a'wágame: ―¡Gulusichi ujchawa! ―anile o'maka alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","'Liko alué Pilátoka ma'chí pale alué Barabasi pe napurigá 'la ra'sálagá ejtebímala ralámuli, tabilé ayoga alué Pilato 'yuga. 'Lige nulale napurigá we'sá wejpisópua alué Esusi wi'chite jiero uchúkame 'lige o'chí. 'Lige 'ma wejpisosa, 'ma lisensia nejile napurigá gulusichi ujchawa alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Alésíko alué sontalo o'tole alué Esusi alé ra'pichí wa'lula selígame bejtélachi, 'lige alé bayele suwábaga sontalo. ");
INSERT INTO tacNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","We'lí o'pachátirile chónaga sejtákame chinite newárigime, 'lige ujchele mo'chí gorona banawá wejchégame newárigime. ");
INSERT INTO tacNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","'Lige repórale regá anigá: ―¡Kuira mué Wa'lula Rey ralámuli jurío nuleme! ");
INSERT INTO tacNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","'Lige mo'chí wejpale we'sá bakate 'lige a'kachípale, 'lige chojkóbaka jaga napurigá 'we 'la nirame, pe gawéliga anime ke anile. ");
INSERT INTO tacNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","'Ma suwénasa gawelia Esusi, 'ma ku bujele alué we'lí o'pacha chóname sejtákame chinite newárigime, 'lige ku o'pachátale bo'né Esusi o'páchala, (Bujéliru o'pacha alué Esusi napu'lige Pilato nuláligo wejpisóniliga.) 'lige alésíko 'ma o'tóleru gulusichi ujchamia. ");
INSERT INTO tacNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Napu'lige pe kulí alemi o'towachi alué Esusi gulusichi ujchamia, bilé rió Sirene bejtégame Simoni anilime alemi seba enale napu Alejantro o'nola nile 'lige Rupo o'nola. 'Lige alué rió nuléleru alué sontálote napurigá nejkúrimala alué gulusí o'towachi. ");
INSERT INTO tacNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","'Lige o'tóleru Esusi bilena rabó alé napu Gólgota anilichi nile, napu «Anayáwali Mo'ola», aniame kéré. ");
INSERT INTO tacNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Napu'lige alé sebasa i'wilí rakala ba'wila 'yáleru rekútume «mira» anilime na'lógame, 'lige Esúsika tabilé chunule. ");
INSERT INTO tacNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","A'lige re'pá gulusichi ujcháleru klabo jáwaga sekala, 'lige alué sontáloka nachútale alué Esusi o'páchala bilé re'gí re'eka (napu «dado» anilime ju yolí ra'íchaga). ");
INSERT INTO tacNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Be'á tabilé 'cho rawilichi, (Bakiá 'ora enágichi rayénali ma'chínasa.) a'lige ujcháliru Esusi gulusichi. ");
INSERT INTO tacNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","'Lige alué sontáloka ujchale alué bilé rabileta osirúgime alé napu Esusi mo'ega chujkule re'pá amóbige napu ruwime nile chonigá ujchálirigo alué Esusi alé gulusichi, regá anime nile alué osilí: «Wa'lula rey, ralámuli jurío nuleme», anime nile alué osilí. ");
INSERT INTO tacNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","'Lige abiena ujchucháleru oká chigórigame gulusichi alé a'bé napu Esusi chujkúlige. Bilé chigórigame wajtoná ujcháleru, 'lige bilé o'iná ujcháleru. ");
INSERT INTO tacNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Alarigá sébali olale napurigá aní alué Onorúgame nila ra'íchili regá anime: «Resí oláliru alué ralámuli cha nokame 'yúriga.» ");
INSERT INTO tacNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Napu ekí ralámuli simárole alé, napu chibi anele, regá anele mo'loka: ―¡Ajá, mué napu na'minámorié alué wa'lú re'obá, 'lige napu pe bakiá rawé kachi ku newámorié mué uché alué wa'lú re'obá! ");
INSERT INTO tacNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Ku re'kiwa 'lige bo'nepi neyúsiwagó! ");
INSERT INTO tacNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Alué balé e'wélala, 'lige alué Moisesi nulalila beníriame, 'lige alué Esusi gawéliga regá anile a'bopi: ―Esusi we'ká ralámuli gu'írile, bo'népika peka gayénaché neyusia. ");
INSERT INTO tacNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","'Lige aminami regá anile 'we gawéliga: ―Re'kisa 'la képá alé gulusichi alué Kristo, alué wa'lula selígame rey israelita ralámuli nuleme, napurigá 'la bijchígiwa 'la bijchiá 'la nóchali 'yárigame ko Onorúgamete ―aniá jale. 'Lige okánika chigórigame napu uchule Esusi chujkúgichi a'naguka, abiena 'we cha anele gawéliga. ");
INSERT INTO tacNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","'Lige 'ma rawilichi 'lige 'ma chónale rayénali, 'lige chónaga ilíbale bochígimi alé gawichí. Nasípagana enagá ku rayénale alué rayénali. ");
INSERT INTO tacNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Aba'lige 'ma ku rayénachi alué rayénali, Esusi e'wele ra'íchaga regá anile: ―Eloi, Eloi ¿lama sabáktani? (Pe arameo ra'íchaga anile.) Pe regá anigá anile: «Muérigo Onorúgame ne O'nola, ¿chonigá a'réché mué ne'chí?» ");
INSERT INTO tacNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","'Lige alué ralámuli napu ekí jale alé a'bé, napu akele alanichi Esusi, anile: ―¡Gepusi! ¡Elíasi bayéchane, napu ruwime nile napu anélige Onorúgame 'we 'ya! Tabilé 'la námaka akele alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","A'lige biléchigo yati 'male bilé chiní sa'nabáchamia banawá rakala ba'wílachi pee rekútume 'we chijpúgame 'lige iguchi ujchale ba'nasoli kaboka, 'lige 'pa owele chu'chí napurigá Esusi chunumela ba'wila, regá anigá owele: ―Akabá pala nolínara Elíasi re'kibumia gulusichi ye rió ―anigá 'sile. ");
INSERT INTO tacNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","'Lige Esúsika a'wágame sinale, 'lige 'ma mukule. ");
INSERT INTO tacNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","'Lige yati chi'wale o'wékana re'kínaga alué wa'lú chiní pachá wa'lú re'obachi chujkúgame. ");
INSERT INTO tacNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","'Lige alué wa'lula sontalo napu ilile alé o'wemi napu Esusi chujkule, etesa se'wináriga mukuchi Esusi, tase napurigá uché jaré rió, anile: ―Bijchiá 'la Onorúgame Inolá nile ye rió. ");
INSERT INTO tacNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Abiena jale jaré umugí e'negá mejkaka, alé ilile María Magalena, Magalena anilichi bejtégame, 'lige uché bilé María Santiago eyela 'lige José eyela (Santiago José bonila nile), 'lige uché bile mukí Salomé anilime. ");
INSERT INTO tacNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Alué umugí Esusi gu'írome nílige napu'lige eyénachi Esusi ejiro Galilea. 'Lige uché jaré umugí jale alé, napu abiena moyénalige alé we'ká riógichi Rusaleni anilichi Esusi 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Asale bilé rió José rewégame, Arimatea bejtégame we'ká riógachi. Alué rió 'lige uché jaré ralámuli e'wélala, alué ralámuli jurío nuleme nile. Alué rioka 'we a'lá najkílige napurigá yati sebámala raweli napurigá nulame nímala Onorúgame ralámuli alawálachi. 'Lige alemi ilile alué José etea me'liachi Esusi. 'Lige 'ma amulí chónachi rapakónala resíbilichi rawé, alué José simile napu Pilato asale lisensia tánimia o'tomea alué Esusi gatemia, napugiti chonásaká 'ma resíbilichi níligame. ");
INSERT INTO tacNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","'Lige Pilátoka lale: «'Macha mukúlepué.» 'Lige yati bayele alué wa'lula sontalo, 'lige rukele: ―¿Pala bijchiá mukule Esusi? 'Lige alué wa'lula sontáloka anele: ―Ya 'ma mukule. ");
INSERT INTO tacNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","'Liko Pilato alieri akisá, Pilato yati 'la elile José napurigá o'tomela Esusi mukúgame, ");
INSERT INTO tacNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","'lige Joseka yati ralale bilé chiní rojsákame, 'lige re'kabusa alué Esusi gulusichi ujchárigame, alué chinite kabisa, o'tole gatemia 'mi alé ewarárigichi wejtosá rejtechi pachami, yóchika u'tá nile 'lige pachaka we'lé nile, 'lige 'yérale alé yochi bilé wa'lú chijtúligame rejtete 'we bejtégame. ");
INSERT INTO tacNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","'Lige alué María Magalena anilime, 'lige alué María, José ('lige Santiago) eyela, 'we a'lá etea jale alé rekalíachi Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Rawé resíbilichi simírasa, a'lige alué María Magalena anilime, 'lige uché bilé María Santiago (Akobo) eyela, 'lige Salomé, alué bakiá umugí ralale yowí rakala Esusi bo'ígichi mochiamia 'lige abiena ralale yowí rusurúgame 'we semá júkame alué Esusi ujchemia. ");
INSERT INTO tacNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","'Lige 'ma romíkichi, be'á rayénali ma'chínachi, simíbale alué yowí 'we semá júkame ujchemia alué Esusi napu rekáliru Esusi, ");
INSERT INTO tacNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","'lige anisia e'yénale alué bakiá umugí: ―¿Chieri 'la nejkúrimala alué wa'lú rejté se'wí ajchalichi alé yochi ajtígame? ");
INSERT INTO tacNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Napu'lige sebasa alé yochi a'bemi, etele 'ma tabilé alé yochi ajtigó alué wa'lú rejté. ");
INSERT INTO tacNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","'Lige mo'ile alé pachami ewarágichi alué bakiá umugí. 'Lige etele alé mo'isá bilé santo ánjeli re'malí wajtoná ajtígame. We'lí o'páchigime nile alué santo ánjeli 'we rojsákame o'pacha. 'Lige alué umugika 'we majale, ");
INSERT INTO tacNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","'lige alué santo ánjelika anele: ―Tase majasi. Ne 'la machí Esusi 'yaga e'yéneo 'emi, alué Esusi napu Nasareno anilime nile, napu gulusichi ujchagá me'líliru. 'Ma ku ajánale, tabilé bo'í jena, aka e'nésibá jena napu rekáliru, 'ma tabilé néré. ");
INSERT INTO tacNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Simíbaga 'lige anéwaká Pegro 'lige alué uché jaré Esusi 'yuga járome, Esusi 'ma simela bajchabé alé Galilea rewégichi ta'chó sébachi 'emi alemi, napurigá anílige ta'chó mukiá. Alé Galilea etémala 'emi napurigá anílige bo'né Esusi. ");
INSERT INTO tacNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","'Liko alué umugí júmaka buyásele 'áwalisia majaga, 'lige tabilé 'wesi ruyele boichimi e'yénaga majaga. (Jaré osilí osirúgime 'we 'ya nerúgame pe jena suwéname ju. 'Lige jaré osilí osirúgime abé we'ká osirúgime ju, napu ma'chíname ju abé re'légana.) ");
INSERT INTO tacNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Napu'lige ku ajánasa Esusi, María Magalena napu Magalena bejtégame nile, alué bajchá etele alué Esusi be'á be'lí napu'lige chojkichi tarali (romíkichi). Abé 'yabé Esusi buyánilige gichao remónisi u'kuchípala alawá alaké mukichi. ");
INSERT INTO tacNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Alué mukika simile ruyemia alué uché jarela napu nile Esusi 'yuga járome napu 'we seweka mochile nalá bijí. Ruyele Esusi 'ma ku ajánaligo. ");
INSERT INTO tacNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Akisá alué Esusi 'yuga járome, tabilé bijchígale. ");
INSERT INTO tacNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","A'kinana, boichimi e'yénale oká ralámuli napu 'we a'lá niraga eteme nílige 'yabé ta'chó mukuchi Esusi. Alemi boichimi ma'chínale Esusi napuyeri pe apiépiri rió 'lige alué oká rioka tabilé machile. ");
INSERT INTO tacNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Napu'lige 'ma 'la machisá pe Esusi níligo, ku ro'ile 'lige ku sébaga ruyele alué uché jarela Esusi 'yuga járome, 'lige alueka tabilé bijchígale. ");
INSERT INTO tacNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","A'kinana alué makué bilé rió Esusi 'yuga járome go'yá mochile, 'lige alemi ma'chiná ilíbale Esusi napu'lige go'yá mochígichi mésachi. 'Lige Esusi a'wágame ne'óchale alué makué bilé rió tabilé bijchígiligame ku ajániligo Esusi, napu'lige regá anésiga abé 'yabé uché jaré ralámulite: «Eteru ramué Esusi, ku ajánale.» ");
INSERT INTO tacNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","'Lige anele Esusi alué makué bilé Esusi 'yuga járome: ―Bochígimi gawichí simárowaká alué 'we a'lala ra'íchili benírisia suwábaga ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ralámuli napu ekí 'la bijchígame ju Onorúgame nila ra'íchili 'lige napu a'ré alué chátiri bowé 'lige napu cha'pí alué 'we a'lala bowé, alueka napu'lige mukusá tabilé resí ikimela, alué alawálaka 'pa rewagachi moinámala mukusá. 'Lige suwábaga napu ekí tabilé bijchigi napu aní alué Onorúgame nila ra'íchili, alueka 'we resí ikimela, 'légana na'ichí mo'ibámala. ");
INSERT INTO tacNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Napu ekí 'la bijchigi napu aní Onorúgame nila ra'íchili, ne 'yámala a'walí napurigá 'la buinámala remónisi u'kuchípala alawala ralámulichi pachágana mochígame. 'Lige 'la gainámala se'nú ra'íchili ra'icha yati neraga, ");
INSERT INTO tacNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","cha'pimela sinowí 'we oporúgime 'lige tabilé che ikimela alué oyérame, 'lige bajisa bilé tábiri sowé tabilé che ikimela, 'lige sekate nochasa bilé nayume, yati sa'wimela. ");
INSERT INTO tacNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Napu'lige alué Esusi suwénasa ra'icha alué 'yuga járome si, Onorúgame rewagachi o'tole Esusi. Alé sebasa, wajtoná asíbale Onorúgame ajtígichi. ");
INSERT INTO tacNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Esusi 'yuga járomeka e'yénale bochígimi gawichí ralámuli benírisia Onorúgame nila ra'íchili rejcholi. 'Lige Esusi Alawala gu'írile alué Esusi bo'né 'yuga járome napurigá 'la sa'wámala nayúkame napurigá 'la oyéramala alué Onorúgame nila ra'íchili rejcholi 'lige aminami napurigá 'la bijchígimala 'la wa'lú a'walí nígame ko Onorúgame. Pe ikí képá ye ra'íchili. Wa'lú cheliérabá.");
INSERT INTO tacNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","We'ká ralámuli osale apélichi napu nóchale 'lige napu benírale Esusi jena wijchimoba. ");
INSERT INTO tacNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Osale napu akele napurigá ruwile alué ralámuli napu Esusi 'yuga e'yénale alué napu a'kinana ralámuli benírime gayénale Esusi ra'ichálila 'we a'lá ra'íchali rejcholi. ");
INSERT INTO tacNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Mué rió Teópilo, 'we 'la nirá ne mué. Ne bo'né 'we a'lá 'nátaga ruké we'sá alué ralámuli Esusi 'yuga e'yéname regá: «¿Churigá ochérale u'tá towí ka 'lige churigá nóchale Esusi napu'lige si chojkile nocha alué Esusi 'lige napusí suwénale nocha 'lige churigá 'yole nayúkame 'lige churigá benírale suwábaga ralámuli?» Regá ruké ne alué ralámuli. Ne 'la nerá nili napu ruwile, alekeri osá ne ye osilí jena apélichi 'la sébili ruigá suwábaga churigá nile, ");
INSERT INTO tacNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","napurigá mué Teópilo 'la sébali machigá asimela alarigá níliga napu mué Teópilo beníriliru alué we'ká ra'íchali. ");
INSERT INTO tacNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Napu'lige alué Erore wa'lula selígame kachi alé alué wa'lú gawí bo'ígichi Jurea anilichi, a'lige bejtele bilé balé wa'lú re'obachi Onorúgame galílachi nulame Sakaríasi rewégame. Alué baleka alué Abíasi chojkégame gompaniérola nile, alué Abíasi napu 'we 'ya bejtégame balé nile me'tagá Sakaríasi, Sakaríasika a'kinana ochérigame nile. Alué Sakaríasi upila Sabeli rewégame nile. Alué mukí Sabélika Aroni rijimala nile, Arónika 'we 'ya bejtégame nile 'lige Sabélika 'we a'kinana ochérale. ");
INSERT INTO tacNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Alué Sakaríasi 'lige upila si 'we a'lá sébali e'wame nile suwábaga napu Onorúgame nulale 'we 'ya, 'lige Onorúgame 'we a'lá galegá etele alué okánika. ");
INSERT INTO tacNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tabilé siné 'kúchigame nile alué ralámuli. Aminami 'ma 'we o'chérame nile okánika. ");
INSERT INTO tacNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sébale bilé rawé napu nóchame nile Sakaríasi alué we'ká balé 'yuga alé wa'lú re'obachi alué balé napu alé wa'lú re'obachi nulame nile. ");
INSERT INTO tacNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Re'eme nile, 'lige Sakaríasi mele re'eka bajkiame abé pachá o'kuí molélachi alé wa'lú re'obachi. ");
INSERT INTO tacNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Napu'lige Sakaríasi molea ilígachi, ralámuli 'we jale Onorúgame 'yuga ra'icha iwérali tania ma'chige. ");
INSERT INTO tacNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","'Lige yati neraga ma'chiná ilíbale bilé santo ánjeli Onorúgamete julárigame rewagáchika, alé wajtoná ilíbale alé mésachi napu e'kósilime nile o'kuí alé napu ilile Sakaríasi. ");
INSERT INTO tacNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Napu'lige etesa Sakaríasi alué santo ánjeli, 'we majale. ");
INSERT INTO tacNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","'Lige alué santo ánjelika anele: ―Mué Sakaríasi, tase majawa. Onorúgame 'we a'lá aké mué alué Onorúgame 'yuga ra'íchachi tániga napurigá ranélamala mué upila. 'Lige mué upila Sabeli ranélamala bilé towí. Mué ajchémala rewá alué towí «Juani» anilime rewá. ");
INSERT INTO tacNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","'We ganílimala 'lige mué. Abiena we'ká ralámuli 'we ra'sálámala alué towí ochérasa, ");
INSERT INTO tacNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","napugiti alué Onorúgame Wa'lula neraga etémempá wa'lú ochérasa alué towí. Aminami tabilé siné bajímala i'wilí ('uba) ba'wila rekútame. 'La Onorúgame Alawala ajchágame nímala pachágana bajchabé ta'chó ocheria. ");
INSERT INTO tacNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","We'ká ralámuli alé Israeli ejperégame ku o'wé jábamala, Wa'lula Onorúgame oyérame gainámala alué Juani rejchólila akigá. ");
INSERT INTO tacNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Alué Juánika rejcholi ruyeme nímala alué ralámuli wa'lú a'walite alué Onorúgame nila, napurigá alué Elíasi rewégame napu ruwime nile napu anele Onorúgame 'we 'ya. Alué Juánika ku o'wé jawámala alué we'ká ralámuli napu 'kúchiga mochímala, ku ge'láramala napurigá ku ganíliga ejperélamala 'kúchila 'yuga, abiena napurigá ku a'lá o'wé na'támala alué ralámuli napu 'we resí nokagá járome nímala a'lige. Juánika bajchá ta'chó nawachi alué Wa'lula, 'we semáriga beníriga asimela we'ká ralámuli, napurigá alué ralámuli 'we a'lá galegá etémala nawachi alé alué bi'neli neyúriga Wa'lula. ");
INSERT INTO tacNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakaríasika rukele alué santo ánjeli: ―¿Churigá 'la bijchígamala ne alarigá nimio suwábaga napu aní mué? Aka neka 'ma 'we o'chérame júpaché, 'lige ne upílachigó 'we o'chérame ju. ");
INSERT INTO tacNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","'Lige alué santo ánjelika regá anele: ―Neka santo ánjeli ju Gabrieli rewégame. Neka Onorúgame 'yuga ajtime ju. Alué nulé ne'chí napurigá ne mué ruyémala mué upila ranélimio bilé towí mué inolá. ");
INSERT INTO tacNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Jipe mué tabilé bijchigi ye ra'íchali napu ne mué ruyé. Jípeko tase ra'íchame gainámala mué napusí ochérisa mué inolá, a'lige kulí gainámala mué ku ra'icha. 'La bijchiá alarigá nímala napurigá aní ne. ");
INSERT INTO tacNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","'Lige Sakaríasi pachá ilígichi, ralámulika ma'chige jale buigá, aniá: ―¿Chonigá ta'wé ma'chínaché alué Sakaríasika alé pachaka ye wa'lú re'obáchika? ―anile we'ká 'nátaga. ");
INSERT INTO tacNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Arigá ma'chínale alué Sakaríasi, 'ma tabilé gayéname ra'icha. Tabilé gayénale alué rió ra'icha ma'chínasa aleka, yati 'we machile ralámuli Onorúgame alarigá rekíligo alué rió alé pachá wa'lú re'obachi. Pe sekate ra'íchale Sakaríasi, pecha gayéniliga ra'icha. ");
INSERT INTO tacNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","'Ma sébali olasa alé wa'lú re'obachi napu ekí rawé nochámili nílige alué Sakaríasi, 'ma ku galírale simile. ");
INSERT INTO tacNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","A'kinana alué mukí Sakaríasi 'yula Sabeli rojparale. 'Lige maligi mechá tabilé asé eyénaga asale. 'Lige 'nátale alué mukí: ");
INSERT INTO tacNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Alué Wa'lula Onorúgame bo'né alarigá rekile ne'chí ye raweli napurigá ranélamala ne, napurigá 'la tase gawélimala ralámuli ne'chí tabilé 'kúchime kóriká.» ");
INSERT INTO tacNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Usani mechá a'kinana rojparasa Sabeli, Onorúgame júlale bilé santo ánjeli Gabrieli rewégame 'mi alé we'ká riógachi Nasareta anilichi napu pachá ju Galilea anilime gawí bo'ígichi napurigá bilena ejiro. ");
INSERT INTO tacNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Júlale alué mukí iwé María rewégame e'néniliga. Alué mukika amulí newímili nile alué rió José rewégame 'yuga. Alué José Rabí rijimala nile, Rabí napu abé 'ya bejtégame nile ta'chó ochérachi José. ");
INSERT INTO tacNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","'Lige alué santo ánjeli sébale napu asale María, 'lige anele: ―Kuira mué mukí wanápurigame Onorúgamete. Wa'lula Onorúgame 'we a'lá semáriga gu'iri mué mukí. ");
INSERT INTO tacNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Alué mukí alué santo ánjeli etesa, majaga we'ká 'nátale 'lige lale: «Yeka ¿chonigá alarigá reparábaché?» ");
INSERT INTO tacNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","'Lige alué santo ánjeli uchéchigo ra'íchale, 'lige anele: ―Mué María tase majawa. Onorúgame alarigá rekile raweli mué. ");
INSERT INTO tacNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Jipe rojparámala mué 'lige ranélamala mué bilé u'tátiri towí. 'Lige ajchémala mué Esusi anilime rewá. ");
INSERT INTO tacNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Alué rioka 'we najtékame nímala. Regá anélime nímala «Wa'lula Onorúgame Rewagachi Ajtígame Inolá.» Onorúgame Wa'lula selígame anémala a'chigóriga napurigá alué 'we 'ya bejtégame Rabí, ");
INSERT INTO tacNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","napurigá nuleme nímala alué we'ká ralámuli israelita senibí rawé. ");
INSERT INTO tacNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","'Liko Maríaka rukele alué santo ánjeli: ―¿'Lacha ranélamalawé ne? Neka tabilé 'yúgame júpaché rió. ");
INSERT INTO tacNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","'Liko alué santo ánjelika anele: ―Onorúgame Alawala gite rojparámala mué tabilé 'yuga asagá rió, Onorúgame a'walila alarigá elímala mué. Alekeri alué mué inolá 'la wanáparigame nímala Onorúgamete, 'lige Onorúgame Inolá anélime nímala. ");
INSERT INTO tacNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mué rijimala Sabeli abiena ranélamala rekó o'chérame ke. 'Ma usani mechá ju wa'lú rojpega asagá. We'ká ralámuli mayé tase ranélimio. ");
INSERT INTO tacNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Onorúgameka suwábaga gayéname ju napurigá bo'né 'nata. Alekeri bilé mukí rekó 'ma o'chérame ke 'la ranélamala Onorúgame alarigá elásaká. ");
INSERT INTO tacNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","'Liko Maríaka anile: ―Neka pe nóchame ju alué Onorúgame 'yuga. Onorúgame alarigá elísaká ne'chí napurigá aní mué ranélamaréko ne 'liko bilé towí. Alésíko 'ma tané ikiá kíbale alué santo ánjeli. ");
INSERT INTO tacNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","A'lige pe a'kinana rawé alué María 'we jigaga simile alé bilena we'ká riógachi iwérachi napu nile Jurea anilime gawí bo'ígichi. ");
INSERT INTO tacNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","'Lige sebasa Sakaríasi bejtélachi, pachá galírale bajkile 'lige repórale pe a'bemi iligá alué Sabeli. ");
INSERT INTO tacNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Napu'lige akisá alué Sabeli María reporachi, alué u'tátiri Sabeli rojpálachi ajtígame nokale. 'Lige Onorúgame Alawala bajkile alué Sabélichi pachágana ");
INSERT INTO tacNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","'lige e'wele ra'íchaga anile Sabeli: ―'We a'lá semáriga gu'írilia mué María Onorúgamete ta'wesi uché jaré umugí anaga 'lige mué ranala abiénachigó. ");
INSERT INTO tacNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Chieri júpaché ne napurigá nawámala mué María ne'chí e'nemia mué napu ju alué Onorúgamete julárigame eyela nímili? ");
INSERT INTO tacNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Napu'lige akisá ne mué reporachi, 'lige yati noká u'tátiri ne rojpálachi ra'sálagá. ");
INSERT INTO tacNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mueka 'we a'lá sébali bijchígime napurigá anile alué Onorúgame. Alekeri gite 'we ganíliga bejtélamala mué. ");
INSERT INTO tacNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","'Liko Maríaka anile: Neka wa'lú cheliera 'ya Onorúgame napu bi'neli Wa'lula ju. Neka 'we ra'sálá napugiti Onorúgame ne'chí bujéligame resítiri 'nátili. ");
INSERT INTO tacNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Onorúgameka 'we 'la nirá ne'chí rekó ne peka najtékame kachi. Jípesí aminako ralámuli 'we a'lá niraga etémala ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Alué Onorúgame wa'lú a'walí nígame ju, 'we a'lá semáriga gu'iri ne'chí. Onorúgame rewalá 'we najtékame ju. ");
INSERT INTO tacNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Onorúgame senibí 'la na'temame ju alué ralámuli napu 'la nirame ju Onorúgame, ");
INSERT INTO tacNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","machírile ralámuli wa'lú a'walí nígame ko. 'La umérole alué ralámuli 'we gunarume. ");
INSERT INTO tacNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Alué e'sélikame rió 'ma bujele nóchali, alué tabilé nígame 'nalina 'we najtékame nóchali 'yale. ");
INSERT INTO tacNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Alué ralámuli 'we e'lowika ejperégame 'ma 'we nígame newale go'ame, 'lige alué 'we nígame rioka pe sekega a'rele. ");
INSERT INTO tacNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","'We a'lá semáriga gu'írile alué we'ká ralámuli israelita napu Onorúgame nochálilachi nóchame ju. Tase siné a'rele na'temá alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Alarigá gu'írimioríle Onorúgame alué 'we 'ya bejtégame Abraámi aminami alué Abraámi rijimala 'we a'kinana o'chérigame napu ramué rijimala júchigó, senibí gu'írimioríle. Regá ra'íchale alué María. ");
INSERT INTO tacNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Alué María alé asale bakiá mechá alué Sabeli 'yuga, arigá a'kinana kumi bejtélachi simile. ");
INSERT INTO tacNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Sebárale raweli a'kinana napu ochérimili nile alué towí Sabeli ranala, 'lige Sabeli ranele bilé towí. ");
INSERT INTO tacNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Alué u'tátiri ochérasa, alué a'mulipi riógame 'lige abiena alué rijimala napuíle alé napu asale Sabeli, 'we ra'sálagá simíbale o'maka e'nemia alué Sabeli, machisá Onorúgame 'we semati raweli rekíligo alué mukí napurigá ranélamala rekó 'we o'chérame kachi. ");
INSERT INTO tacNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Osánó rawé ajtígachi ochéraga, sikiréliru pe'tá isílala wi'chila napurigá nokame nile alué ralámuli israelita. 'Lige ralámulika ujchénale o'nola rewalá Sakaríasi anilime rewá. ");
INSERT INTO tacNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Eyélaka anile: ―Tase. Juani anilime rewá ujchewa. ");
INSERT INTO tacNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","'Liko rukele alué ralámuli: ―¿Chonigá? Tase 'wesi i'tépaché alarigá rewégame alué Sakaríasi rijimala. ");
INSERT INTO tacNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","'Liko pe sekate ra'íchaga rukéliru alué Sakaríasi machináliga chonilime rewá ujchénelia. ");
INSERT INTO tacNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","'Liko Sakaríasika tale bilé rabileta alé osimea, 'lige osale regá anime: «Juani anilime rewá ujchewa.» 'Liko suwábaga alué ralámulika lale: «¿Chonigá alanilime rewá ujchéneleché?» lale. ");
INSERT INTO tacNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","A'lige yati neraga ku ra'íchale alué Sakaríasi, 'lige anele Onorúgame 'we ra'sálagá: ―Mué Onorúgame 'we a'lá semáriga gu'iri mué ne'chí ―anele. ");
INSERT INTO tacNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Suwábaga alué ralámuli alemi a'mulipi ejperégame 'we majale machisá. Abiena we'ká ralámuli napu ejperele alemi iwérachi napu Jurea anilichi nile ruigá e'yénale suwábaga tábiri napurigá ikile alé. ");
INSERT INTO tacNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Suwábaga ralámuli napu ekí akele alué ra'íchali anigá e'yénale a'bopi: ―¿Tachiri nóchame nímalawé alué towí wa'lú ochérasa? Alarigá anile napugiti 'la bijchiá machíligame a'lígesí wa'lú a'walí 'yáligo Onorúgame alué towí. ");
INSERT INTO tacNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Alué Juani o'nola Sakaríasi 'we a'lá rejcheruga ra'íchale Onorúgame Alawala gite napurigá ikimeli níliga abé nujubami, regá anile: ");
INSERT INTO tacNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Wa'lú a'walí nígame ju alué Onorúgame napu gu'írime ju ramué ralámuli israelita. Jipe 'a nawákuru jena we'ká riógachi a'kabámana jawamia ramué. ");
INSERT INTO tacNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","'Ma júlale Onorúgame alué resítiri 'nátili bujeme ralámuli Rabí rijimala 'we 'ya ajtígame, alué Rabí napu Onorúgame nochálilachi nóchame nile ");
INSERT INTO tacNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","napurigá ruyele Onorúgame alué 'ya ejperégame ralámuli napu ruwime nile napu anele Onorúgame, ");
INSERT INTO tacNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","semáriga nejkúrimio napurigá ta neyúrimala ramué saíla, abiena alué 'we gichime ramué, ");
INSERT INTO tacNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","'we na'temamio alué 'ya mochígame ramué rijimala, 'we 'la nélegá asimeo, 'lige julamio alué wa'lula ramué gu'írime, jipe 'ma júlale. ");
INSERT INTO tacNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Alarigá gatele Onorúgame Abraámi 'yuga julamio Onorúgame alué ramué gu'írime. ");
INSERT INTO tacNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ruwile Onorúgame ramué gu'írimio napurigá umérowa ramué saíla, napurigá nochawa Onorúgame nochálilachi tase majaga, ");
INSERT INTO tacNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","'la bi'ígame alawega, 'la sébali olagá napu aní Onorúgame nila ra'íchali. ");
INSERT INTO tacNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Mué Juani, ne inolá, mueka bilé rió nímala ruyame napu ané Onorúgame. Mueka ra'íchali rejcholi ruyeme nímala ralámuli napurigá 'la niraga etémala Wa'lula Onorúgamete Julárigame sébachi, ");
INSERT INTO tacNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","78","napurigá machiboa ramué ralámuli israelita 'ma bujérigame nírigo alué resiti 'nátili, 'lige Onorúgame 'la nejkúrimio 'we 'la na'temaka napurigá ta aminabi chátiri na'tawa. Ramué O'nola Onorúgame 'we galegá na'temá ramué. Wa'lula Onorúgame wamí 'paka rewagachi asagá 'we a'lá nejkuria ajtí ");
INSERT INTO tacNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","napurigá 'la bi'wígame raweli narépua resíriga ejperégame ralámuli, napurigá pe bi'lepi semáriga 'nátame niwa, napurigá 'nátame niwa wa'lú nejkúrame ko Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Alué towí Juani 'we rejchirúgame ochérale, 'lige 'we a'lá nirame Onorúgame, 'lige simile bilénami jami tase ba'égichi, tase rojégichi, 'lige tase gajsalégichi, 'lige we'ká bamí bejtele alé jami napusí chojkile ralámuli ra'íchali rejcholi ruyea alué we'ká ralámuli israelita alemi jsísime. ");
INSERT INTO tacNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","'Ya a'lige u'tá kachi Juani, asale wa'lula nulame rey Augusto rewégame. Alué rioka nuleme nile ralámuli romano 'lige israelita. Alué wa'lúlaka nulale apélichi uchuchánilia rewalá napurigá a'kinana enomí nejímala suwábaga ralámuli wa'lúlachi. ");
INSERT INTO tacNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Pe kulí siné nile ralámuli simiba a'boi rewalá uchuchamia apélichi wa'lúlachi Sirenio selígame kachi alé Siria anilichi. ");
INSERT INTO tacNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Suwábaga simámili nile napu o'chérigame nile 'ya siné apélichi uchuchamia a'boi rewalá. ");
INSERT INTO tacNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Joseka simile alé Beleni we'ká riógachi Nasareta asagá. Nasarétaka alé pachá nile Galilea rewégame gawí bo'ígichi. Sébale alé Beleni napu nile alé pachá Jurea rewégame gawí bo'ígichi, napu ochérigame nile alué wa'lula selígame rey Rabí 'we 'ya, alué Joseka Rabí rijimala nile, abé 'ya ajtígame we'ká bamí ta'chó ochérachi José. ");
INSERT INTO tacNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Joseka simile alé Beleni apélichi ujchamia bo'né rewalá. María abiena si simile, alué José 'yuga newímili, 'lige alué mukika 'ma wa'lú rojpégame nile. ");
INSERT INTO tacNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Napu'lige alé Beleni mochiga, ");
INSERT INTO tacNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","sebárale raweli napurigá ochéramala alué María ranala Esusi, 'lige 'ma ochérale alué u'tá towí Esusi. Pe kulí bilé nile María ranala alué towí ochérachi. 'Lige eyélaka gemele ba'nisólite, 'lige rekale bilénami ganuwachi 'we 'la kabika napu go'yame nile akasí. Alemi rekale alué u'tátiri pecha bilena galichi níligame napu ochérale alué towí Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Alemi jami Beleni rewégachi a'mulipi mochile jaré bo'elo bo'á repuka rukó. ");
INSERT INTO tacNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","'Lige pe yati neraga ma'chiná ilíbale alemi bilé santo ánjeli. 'Lige alué Wa'lula Onorúgame a'walila gite noligá ra'ósiga ilíbale alé napu mochile alué bo'elo. 'Lige alué bo'éloka 'we majale. ");
INSERT INTO tacNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","'Liko alué santo ánjelika anele: ―Tase majawa 'emi. Neka 'we a'lá semati ra'íchali ruimea nawá. Suwábaga ralámuli 'we ra'sálámala akisá ye a'lala ra'íchali. ");
INSERT INTO tacNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Jipe 'ma ocheri bilé towí jena we'ká riógachi napu ochérilige Rabí 'we 'ya. Alueka bujémala alué chátiri 'nátali 'emi 'lige suwábaga ralámuli, alueka Onorúgamete julárigame ju napu wa'lula nímala suwábaga ralámuli nuleme. ");
INSERT INTO tacNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Napurigá abé a'lá bijchígimala 'emi, etémala 'emi alué towí gemériga bo'ígime alé ganuwachi. Napu'lige etesa 'emi, 'la machimela 'la bijchiá ko suwábaga napu aní ne. ");
INSERT INTO tacNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","A'lígerikáchi pe yati we'ká santo ánjeli ma'chiná jábale 'pa rewagáchika simíbagame alé napu ilile alué uché bilela santo ánjeli, 'lige anile 'we ra'sálagá: ");
INSERT INTO tacNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡'We a'lá ju Onorúgame 'pa rewagachi ajtígame! ¡'We ganíliga ejperélamala alué ralámuli napu semáriga gu'írilia Onorúgamete! ");
INSERT INTO tacNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Napu'lige alué santo ánjeli ku 'pa rewagachi simasa, 'liko alué bo'elo anile a'bopi regá anigá: ―Simáwa'é 'liko alé Beleni e'newa napu ruwí alué santo ánjeli napu alué Wa'lula Onorúgame júlale ramué ruyénaliga alué ra'íchali. ");
INSERT INTO tacNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","'We sajpuka simíbale e'nemia, 'lige sébale alé napu mochile María, 'lige José, 'lige u'tá simaloni alué napu bo'ile bilena ganuwachi. ");
INSERT INTO tacNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Napu'lige etesa, simíbale ichúrimi we'ká ralámuli ruyemia napu ruwile alué santo ánjeli churigá nimia alué u'tá towí. ");
INSERT INTO tacNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Alué we'ká ralámuli napu akele alarigá nímaráo wa'lú ochérasa alué towí, 'we ra'sálále. ");
INSERT INTO tacNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maríaka a'lá nirale suwábaga napu anile alué bo'elo, pe bo'nepi 'nátaga. ");
INSERT INTO tacNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Alué bo'éloka ku sébale napu a'rélige alué bo'á wa'lú cheliera 'yasia Onorúgame, 'we ra'sálagá napugiti 'la bijchiá níligame napurigá anílige alué ánjeli. ");
INSERT INTO tacNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Osá naó rawé ajtígachi ochéraga alué towí, sikiréliru pe'tá isílala wi'chila napurigá nokame nile alué ralámuli israelita. 'Lige ujchele Esusi anilime rewá. Alué santo ánjeli nulélige 'yabé alué María napurigá Esusi anilime rewá ujchémala ta'chó rojparachi alué María. ");
INSERT INTO tacNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Napu'lige 'ma simírisa oká liá rawé omawa alué María, alésíko simile alé Rusaleni alué towí Esusi mutuka alé wa'lú re'obá ilígichi ruyemia Onorúgame alué Onorúgame nochálilachi nochamio alué towí wa'lú ochérasa, 'lige aminami bi'wimea alué María napurigá nulale alué Moisesi 'ya bejtégame. Abiena si simile alué José. ");
INSERT INTO tacNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Alemi wa'lú re'obachi o'tóleru alué towí napugiti bo'né Onorúgame alarigá nuláligime osilichi, suwábaga alué bajchabé o'chérigame towí 'we najtékame nimio, Onorúgame 'yuga nóchame nimio. ");
INSERT INTO tacNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Abiena kógile go'ame Onorúgame napurigá nulale Onorúgame 'we 'ya oká baloma oká cho'lopoki kómá. ");
INSERT INTO tacNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","'Ya a'lige rawé bejtele bilé rió Simioni rewégame alé Rusaleni. Alué rioka 'we a'lá oyérame nile Onorúgame, 'lige buigá asale napurigá Onorúgame julámala bilé wa'lula, ra'ámame, napurigá 'ma 'la i'kilí mochímala alué ralámuli israelita ku 'we 'la ganíliga. Alué Onorúgame Alawala 'we a'lá semáriga gu'írile alué Simioni ");
INSERT INTO tacNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","napurigá machimela ta'chó etea ka alué Onorúgamete julárigame tabilé 'cho mukumeo, etesa kulí mukumeo. ");
INSERT INTO tacNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Alué Simioni 'we siminali nílile alé wa'lú re'obá ilígachi, Onorúgame alarigá na'tárile. Napu'lige alué Esusi o'nola 'lige eyela a'pasa alué towí Esusi alé wa'lú re'obachi Onorúgame galila sébali olagá napurigá nulale Onorúgame nila osilí, ");
INSERT INTO tacNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","alué Simiónika mutule alué towí, 'lige Onorúgame 'yuga ra'íchale 'we a'lá niraga, regá: ");
INSERT INTO tacNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Mué Wa'lula Nulame, jípesíko 'la nímala napurigá ne mué oyérame mukimela, mueka ya 'ma sébali olá napurigá ané mué ne'chí 'yabé, 'we ganíliga ajtí ne. ");
INSERT INTO tacNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Jípesíko 'ma etiákuru ne alué napu bujémala chátiri 'nátili ralámuli ");
INSERT INTO tacNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","napu mué júlale jena wijchimoba napurigá suwábaga ralámuli etémala. ");
INSERT INTO tacNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Alué nímala Wa'lula bujsireli 'yame alué tase ralámuli israelita, alekeri alué napu ju tabilé ralámuli israelita 'we 'la nirámala alué ralámuli israelita mué 'kúchila. ");
INSERT INTO tacNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Alué Esusi eyela 'lige o'nola we'ká 'nátaga ejtebile 'we ra'sálagá akisá alarigá nímili níliga alué towí. ");
INSERT INTO tacNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","'Liko alué Simioni anele Onorúgame napurigá iwérili 'yámala alué bakiánika, 'lige anele alué Esusi eyela María: ―Ye towí wa'lú ochérasa rejcholi ruyémala jena alué ralámuli israelita. Ye towí wa'lú ochérasa 'la ma'chí nérélamala we'ká ralámuli tabilé oyerio Onorúgame 'lige we'ká ralámuli 'la oyerio Onorúgame. We'ká ralámuli tabilé galémala ye towí wa'lú ochérasa, gichiga etémala 'lige 'we resí olámala, ");
INSERT INTO tacNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","'lige 'la ma'chígime nériká ilibámala churigá ka alué ralámuli na'tálila. 'Lige mué María níriga, 'we chálámala etega alarigá ikichi. ");
INSERT INTO tacNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Alé re'obachi asale bilé mukí napu nile alué Onorúgame nila ra'íchali benírame ralámuli Ana rewégame, Panueli malala. Aseri chojkégame gompaniérola nile alué Ana. Alué mukika 'ma 'we o'chérame nile. 'We u'tá iwé ka newile alué mukí, pe gichao bamí bejtele gunega 'lige mukírile riola. ");
INSERT INTO tacNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","'Ma osánósa makué miná naó bamí nile bi'neli asagá alué mukí gunámasa. Alué Ana 'we nawame nile alé wa'lú re'obachi ayunamia. Alé asame nile che'lébali 'lige rukachégame Onorúgame 'yuga ra'icha iwérali tania. ");
INSERT INTO tacNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Napu'lige alé wa'lú re'obachi mochígichi alué José, alué María, 'lige alué u'tá towí Esusi, sébale alé alué Ana anilime mukí, 'lige wa'lú cheliera 'yale Onorúgame, 'lige ruyele suwábaga alué ralámuli Rusaleni ejperégame churigá nímili níliga alué u'tá towí Esusi wa'lú ochérisa napu ekí buigá mochile napurigá bujémala alué chátiri 'nátili. ");
INSERT INTO tacNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Napu'lige 'ma sébali olasa alé wa'lú re'obachi, ku Nasareta simíbale napu ju pachá wa'lú gawí bo'ígichi Galilea rewégame. ");
INSERT INTO tacNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","'Lige alué towí wa'lú ochérale 'we a'lá rejchirúgame 'we a'lá 'nátame napugiti Onorúgame 'we a'lá semáriga gu'íriligime. ");
INSERT INTO tacNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Alué Esusi o'nola 'lige eyela nabí bamí simíbame nile alé Rusaleni alué Páskua anilime omali sébachi napu o'inálime nile yawiyame. ");
INSERT INTO tacNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Napu'lige Esusi bamisá makué oká, 'liko simíbale bakiánika alé Rusaleni napurigá nokame nile alué omali sebasa. ");
INSERT INTO tacNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Napu'lige o'nola 'lige eyela ku ejperélachi simíbachi 'ma guwárasa alué omali, alué towí Esúsika abajá Rusaleni rejpile. 'Lige alué o'nola 'lige eyela tase machile abajá rejpíligo. ");
INSERT INTO tacNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Mayele alué towí Esusi enegó 'yuga alué we'ká ralámuli. Alarigá bilé rawé simíbale bowesia. Arigá chojkile 'yaa 'lige rukea rijimala 'lige machirume, ");
INSERT INTO tacNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","'lige tase asé rewale. 'Liko ku simíbale 'yáamia alé Rusaleni. ");
INSERT INTO tacNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","'Ma bakiá rawé kachi kulí rewale alé wa'lú re'obachi alé Rusaleni. Alé ajtile alué re'malí Esusi alué we'ká rió 'yuga ra'icha napu nile Moisesi nila ra'íchali rejchólila benírame. Abiena gepua asale ra'íchali abiena rukea. ");
INSERT INTO tacNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Alué jaré rió Moisesi a'rélala ra'íchali rejcholi benírame akisá Esusi ra'íchachi 'we a'lá rejchiruga ra'icho, 'we a'lá niraga, regá anile: «Asíriga machime ju ye towí», anile alué benírame. ");
INSERT INTO tacNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Napu'lige alué o'nola 'lige eyela etesa aliena benegá ra'icha ajtígichi alué ralámuli 'yuga, pe i'kilí jábale, 'lige pe'tá nujubapi eyélaka anele: ―Mué towí, ¿mueka chonigá ala'simípiché? Ramueka 'we chálagá e'yénilie 'yaga mué. ");
INSERT INTO tacNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","'Liko alué re'malí Esusi anele: ―¿Chonigá 'yárupaché 'émika ne'chí? ¿Tacha machíché 'émika neka nochámali ko ne O'nola galílachi? ");
INSERT INTO tacNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","'Lige o'nola 'lige eyela tase námale alieti olagá anió. ");
INSERT INTO tacNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","'Liko simile ku Nasareta rewégachi o'nola 'lige eyela 'yuga, alé asagá a'lá sébali e'wile o'nola 'lige eyela. Eyélaka bo'nepi tabilé we'káwaga ilírome nile napu ikile 'yasi napusí alué santo ánjeli alué María 'yuga ra'íchale ranélimio María bilé towí. ");
INSERT INTO tacNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","'Lige alué Esusi aminacho wa'lú ochérale abiena 'we a'lá rejchirúgame, 'lige 'we a'lá galegá etéliru Onorúgamete, abiena alué we'ká ralámulite. ");
INSERT INTO tacNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","'Ma makué maligi bamí wa'lula gobierno kachi alué Tiberio, 'lige e'sélikameka nile Ponsio Pilato 'lige Erore 'lige Lisania. Alué Ponsio Pilátoka alé Jurea rewégame gawí bo'ígichi nulame nile. 'Lige alué Eróreka nulame nile Galilea rewégame gawí bo'ígichi. 'Lige alué Belípeka nulame nile okaná gawichí Iturea 'lige Trakonite rewégachi. 'Lige alué Lisániaka nulame nile alé Abilinia rewégame gawí bo'ígichi. 'Lige alué gobierno Tibérioka nulame nile alé bochígimi napu nulame nile alué e'sélikame. ");
INSERT INTO tacNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Abiena mochile oká e'wélala balé Anasi 'lige Kaipasi. A'lige bamí alué Onorúgame alué Juani Sakaríasi inolá 'yuga ra'íchale alé bilénami jami gawichí tabilé 'me u'kume nile, tabilé gasalégichi, 'lige tabilé rojégichi, 'lige alé a'bemi ename nile ba'wí Jorani rewégame bakó. ");
INSERT INTO tacNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Alué Juánika simile alemi suweke bakochi rejcholi ruyemia ralámuli napurigá a'rémala alué resítiri 'nátili, ruigá alarigá 'la e'kamio Onorúgame alué ralámuli. Anele: ―'La rewarárigame niwa ba'wichí bokuíka napurigá machiboa 'ma a'reo 'emi chátiri 'nátili. ");
INSERT INTO tacNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","'La bijchiá alarigá ikile napurigá anile alué osilí napu osale alué rió 'we 'ya ajtígame napu ruyame nílige napu anélige Onorúgame, alué Isaíasi rewégame. Alué osilí regá anime: Ma'chí animela bilé a'wágame ra'íchali rejcholi alé jami, regá anime: ‹‹Newiwa bilé bowé Wa'lula Onorúgame, newiwa bilé bowé 'la wajchígame, ");
INSERT INTO tacNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Bochígimi re'ná newiwa, tabilé nerúlamala gomí, nibilé gawí re'pá jágame, 'lige alué bowé nojkóligime 'la wajchígame nímala, 'lige 'la re'wame nímala, bochígimi napurigá epó neraga ilibámala. ");
INSERT INTO tacNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","'Lige 'la etémala suwábaga ralámuli alué napu Onorúgame julámala bujéniliga ralámuli resítiri 'nátili.›› ");
INSERT INTO tacNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Napu'lige alué ralámuli sébachi alé rewarárigame nimia ba'wichí, 'lige Juánika anele: ―'We chátiri 'nátame ju 'emi. ¿Chieri ané 'emi tabilé naremio alué gastigo napu jipe 'ma a'mulípika ená? ¿Mayé 'emi tabilé naremio alué gastigo 'ma rewarárigame kóriká? Rekó 'la rewarárigame ke 'emi 'lige cha nokogá járome nisa 'emi, abirigá narémala 'emi gastigo. ");
INSERT INTO tacNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","'We a'lá sébali olawa napurigá nulá Onorúgame, a'rewa chati nocha napurigá 'la ma'chígime nérélamala ku guwana 'nata 'emi. Tase lawa 'emi a'bopi: «Abraámi rijimala niru ramué, alué 'we 'ya ajtígame, 'lige 'we najtékame niru ramué.» Neka regá aníbá: Onorúgame tabilé nejkúrimala rekó alarigá 'nátachi 'emi. Bo'né Onorúgame najkisáká rekó pe rejté kachi 'la Abraámi rijimala newámala. ");
INSERT INTO tacNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","'Émika napurigá masana tabilé rakeme alarigá ju, alué masana napu 'ma na'minálime ju rejpulate me'teka chojkichí ajchagá 'lige e'kósilime ju ta rakésaká. Yeka ruwime kéré 'emi 'ma e'kósiwili ko na'ichí mochiga tabilé 'la nóchame kame 'emi. ");
INSERT INTO tacNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","'Lige alué ralámulika rukele: ―¿Cho nokibóché 'liko? ");
INSERT INTO tacNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juánika regá anele: ―Jaré 'emi oká o'páchigime nisa, 'lige bilé kógimili júkuru alué tabilé nígame. 'Lige jaré 'emi 'we 'la nígame nisa go'ame abiena kógimili júkuru alué tabilé nígame. ");
INSERT INTO tacNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Abiena jsile rewarárigame nimia jaré rió enomí nareme alué enomí napu nejílame nile alé wa'lúlachi, 'lige rukéliru Juani: ―Muérigo benírame, ¿ramueka churigá nochawa? ");
INSERT INTO tacNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","'Liko Juánika anele: ―Tase rasígame tániwa enomí ralámuli, pe sébali tániwa enomí ralámuli napu ekí nejímili ju. ");
INSERT INTO tacNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Abiena jaré sontalo regá rukele: ―Ramuégó ¿churigá nochawa? 'Lige Juánika regá anele: ―Tase bujewa ralámuli tábiri resí anigá majáriga, aminami tase e'chewawa alué ralámuli tabilé chojkila kachi. 'La ganíliga ejtebiwa 'emi napu ekí meme ju 'emi. ");
INSERT INTO tacNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ralámulika 'we buigá mochílige alué Kristo, 'lige sebasa Juani 'nátale ralámuli a'bopi: «¿Pala alué júpué Kristo?» ");
INSERT INTO tacNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Juánika regá anele alué we'ká ralámuli: ―Neka rewarame ju ba'wichí jáwaga, nobi uché bilé sebámalagó abé najtékame. Alueka abé wa'lú a'walí nígame ju me'tagá ne'chí. Neka pecha anámalagó alué. Alueka 'la bi'wémala 'emi alawala Onorúgame Alawálate, 'lige 'we a'lá sébali olámala gustisia. ");
INSERT INTO tacNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Alué rioka 'ma o'ká ená ri'ligó ekisula. 'Ma gatémala alué ri'ligó rakala alé rekóachi, 'lige sa'nagálaka 'minami ajchagá e'kósimala na'ichí, alué na'í napu tasiné cho'ime ju. ");
INSERT INTO tacNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ye 'we a'lala ra'íchali rejcholi ruigá Juani ruwime ke anile 'ma pe 'wemi sebamio bilé rió ralámuli buyáname chátiri bowechi. ");
INSERT INTO tacNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Aminami alué Juani ne'óchale alué selígame Erore rewégame napugiti mukí bujéligame alué ba'chila Belipe rewégame, alué mukí napu Eroríasi rewégame nile. Belipe se'nú eyégame nile. Aminami we'ká e'karúgame chati nóchigariká alué Erore, ");
INSERT INTO tacNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","nobi alué Eróreka abéchigo cha 'sile ko, galírale bajchale Juani. ");
INSERT INTO tacNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Bajchabé ta'chó galírale bajchilichi Juani, we'ká ralámuli sébale alemi napu Juani asale rewarárigame nimia, abiena nawale Esusi rewarárigame nimia 'lige rewaráliru alué Esusi. Napu'lige Esusi Onorúgame 'yuga ra'icha ilígachi, 'lige rewagá ewagá ilíbale, ");
INSERT INTO tacNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","'lige alué Onorúgame Alawala re'kínale alé napu ilile Esusi napuyeri bilé baloma neraga. 'Lige rewagáchika ma'chí anile bilé ra'íchali regá anime: ―Mué ju ne Inolá napu 'we galé ne. Neka 'we ra'sálagá ajtí mué etega. ");
INSERT INTO tacNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Mayelia Esusi chojkíligo beniria Onorúgame nila ra'íchali baisá makué bamígame ka. Esúsika napurigá José inolá nile. Joseka alué Elí inolá nile. ");
INSERT INTO tacNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elika alué Matati inolá nile. Matátika alué Lebí inolá nile. Lebika alué Melkí inolá nile. Melkika alué Jana inolá nile. Jánaka alué José inolá nile. Joseka alué Matatía inolá nile. ");
INSERT INTO tacNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matatíaka alué Amosi inolá nile. Amósika alué Naumi inolá nile. Naúmika alué Esli inolá nile. Eslika alué Nagaí inolá nile. ");
INSERT INTO tacNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaíka alué Maati inolá nile. Máatika alué Matatíasi inolá nile. Matatíasika alué Semeí inolá nile. Semeíka alué Oseki inolá nile. Osékika alué Jurá inolá nile. ");
INSERT INTO tacNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Juraka alué Joana inolá nile. Joánaka alué Resa inolá nile. Résaka alué Sorobabeli inolá nile. Sorobabélika alué Salatieli inolá nile. Salatiélika alué Neri inolá nile. ");
INSERT INTO tacNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nérika alué Melkí inolá nile. Melkika alué Ari inolá nile. Árika alué Kosami inolá nile. Kosámika alué Elmorami inolá nile. Elmorámika alué Eri inolá nile. ");
INSERT INTO tacNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","30","Erika alué Josué inolá nile. Josueka alué Elieseri inolá nile. Eliesérika alué Jorimi inolá nile. Jorímika alué Matati inolá nile. Matátika alué Lebí inolá nile. Lebika alué Simioni inolá nile. Simiónika alué Jurá inolá nile. Juraka alué José inolá nile. Joseka alué Jonami inolá nile. Jonámika alué Eliakimi inolá nile. Eliakímika alué Melea inolá nile. ");
INSERT INTO tacNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Meléaka alué Mainani inolá nile. Mainánika alué Matata inolá nile. Matátaka alué Natani inolá nile. Natánika alué Rabí inolá nile. Rabika alué Isaí inolá nile. ");
INSERT INTO tacNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Isaíka alué Oberi inolá nile. Obérika alué Bosi inolá nile. Bósika alué Salmoni inolá nile. Salmónika alué Naasoni inolá nile. ");
INSERT INTO tacNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasónika alué Aminarabi inolá nile. Aminarábika alué Arami inolá nile. Arámika alué Esromi inolá nile Esrómika alué Páresi inolá nile. Páresika alué Jurá inolá nile. ");
INSERT INTO tacNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juraka alué Akobo inolá nile. Akóboka alué Isaki inolá nile. Isákika alué Abraámi inolá nile. Abraámika alué Taré inolá nile. Tareka alué Nakori inolá nile. ");
INSERT INTO tacNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakórika alué Serugi inolá nile. Serúgika alué Ragau inolá nile. Ragáuka alué Pelegi inolá nile. Pelégika alué Eberi inolá nile. Ebérika alué Sala inolá nile. ");
INSERT INTO tacNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sálaka alué Kainani inolá nile. Kainánika alué Arpásari inolá nile. Arpásarika alué Semi inolá nile. Sémika alué Noé inolá nile. Noeka alué Lameki inolá nile. ");
INSERT INTO tacNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamékika alué Matusaleni inolá nile. Matusalénika alué Enoko inolá nile. Enókoka alué Jareri inolá nile. Jarérika alué Majalaleli inolá nile. Majalalélika alué Kainani inolá nile. ");
INSERT INTO tacNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainánika alué Enosi inolá nile. Enósika alué Seti inolá nile. Sétika alué Arani inolá nile. Alué Aránika Onorúgame newale 'ya kulí siné ta'chó 'wesi ralámuli i'tégichi jena gawichí. ");
INSERT INTO tacNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Alué Esusi 'we a'lá sébali e'wagá alué Onorúgame Alawala simile alé bakochi Jorani rewégachi asagá. Simile alemi tabilé riógachi, tabilé ba'wégichi, 'we wakígichi, tabilé i'tégichi nibilé rojá, nibilé gajsalá. Alé asale oká liá rawé. ");
INSERT INTO tacNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","'Lige alué Remónisika alemi nawile 'yégimia alué Esusi napurigá tabilé e'wímala Onorúgame, napurigá pe alué Remónisicho e'wímala. 'Lige alué Esusi tase go'ale go'ame alakí rawé, arigá 'ma e'lowile. ");
INSERT INTO tacNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","'Liko alué Remónisika anele: ―'La bijchiá Onorúgame Inolá níriká, nulewa 'liko ye rejté napurigá baní gainámala. ");
INSERT INTO tacNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Esúsika regá nejele: ―Alué Onorúgame nila osilí regá aní: «Tase pe go'ame go'gá ejperélamala ralámuli, abiena alué semati ra'íchali Onorúgame nila rejcholi 'nátaga ejperélamala ralámuli.» ");
INSERT INTO tacNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","'Liko alué Remónisika o'tole alué Esusi bilena re'pá rabó, alé tabilé rojégichi 'lige tabilé gasalégichi, 'lige etérele pe yati neraga si'népiriga suwábaga gawí napu echilú ju jena wijchimoba. 'Lige anele: ");
INSERT INTO tacNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","―Mué 'la e'wásaká, aminami 'la sébali nirasa mué ne'chí, 'liko ne nejímala alué ye suwábaga napu echulú eteri ne mué ye gawí, bochígimi gawichí nulame nímala mué. Neka 'yárigame kame wa'lú nóchali 'we najtékame jena wijchimoba, 'lige ne alué nóchali 'yámala mué napugiti neka a'lá lisensia nígame kame napurigá 'yámala alué nóchali apiépiri napu 'yánili ne, napu'lige nulame kachi mué 'la niraga etewa mué suwábaga ralámulite. ");
INSERT INTO tacNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Esúsika regá nejele: ―Alué Onorúgame nila osilí regá aní: «Pe alué Wa'lula Onorúgamecho 'we a'lá nirawa, pe aluecho e'wewa.» ");
INSERT INTO tacNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pe nujubapi Remónisi o'tole alé we'ká riógachi Rusaleni anilichi, 'lige alé sebasa, abé re'pá alué wa'lú re'obachi Onorúgame galila 'mórale, 'lige anele: ―'La bijchiá Onorúgame Inolá níriká, 'légana o'pochíkabá jena iligá. ");
INSERT INTO tacNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Aka alué osilí napu ruwí churigá ka Onorúgame regá aníché: Onorúgame julámala we'ká santo ánjeli napurigá repúmala mué. ");
INSERT INTO tacNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Cha'pimela sekate napurigá ta iwégame chibámala mué 'légana wijchí. ");
INSERT INTO tacNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Esúsika regá nejele: ―Aka abiena regá aníché alué Onorúgame nila osilí: «Tase nochawa bilé nóchali machináliga pala bijchiá nira napu aní Onorúgame.» ");
INSERT INTO tacNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Alésíko alué Remónisi tase umubásaká umeria alué Esusi, 'liko a'rele pe u'kabi rawé. ");
INSERT INTO tacNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","'Lige Esusi ku simile alé Galilea, Onorúgame Alawala 'we a'lá gu'írile alemi enágichi, 'lige suwábaga ralámuli napu ekí riole bochígimi alé Galilea anile: ―Alué rió Esúsika 'la bijchiá Onorúgamete gu'írilia ―regá anile a'bopi machíligame 'we a'lá gu'írilio Esusi Onorúgamete. ");
INSERT INTO tacNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","'Lige napu ekiná riógachi sébaga 'we benírale alué Onorúgame nila ra'íchali rejcholi alé u'kuchí re'obachi «sinagoga» rewégame. 'Lige suwábaga ralámuli 'we a'lá nirale alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Esusi ku simile alé Nasareta we'ká riógachi napu 'ya alé asagá wa'lú ochérigame nile. 'Lige bilé rawé resíbulichi bajkile alé bilena u'tá re'obachi «sinagoga» rewégame napurigá 'sime nile bo'né 'lige alé asíbale pachá. 'Lige pe'tá i'libeko o'weti ilísale osilí ra'ichamia. ");
INSERT INTO tacNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","'Lige 'yáliru apeli kabítigame osilí napu osálige Isaíasi 'we 'ya ochérigame napu'lige ta'chó ochérachi Esusi napu nile Onorúgame nila ra'íchali rejcholi benírame ralámuli. Napu'lige ra'lanasa alué apeli kabítigame, 'lige pe'wera 'yáasa alé rewale 'lige ra'íchale osilí regá anime: ");
INSERT INTO tacNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Alué Wa'lula Onorúgame Alawala 'we a'lá gu'iri ne'chí, napugiti wanápuligame ne'chí nóchali 'yagá napurigá ne beníramala semati rejcholi alué ralámuli tabilé nígame enomí. Jula ne'chí su'lanánaliga Remónisite cha'piruga mochígame ralámuli, abiena napurigá ma'chílime newámala ne alué tase ma'chílime ralámuli, abiena napurigá gu'írimala alué resí oliame ralámuli napurigá tabilé aminabi resí olawa, ");
INSERT INTO tacNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","abiena napurigá ruwimela ne 'ma sebio raweli 'we a'lá semáriga gu'írimio Onorúgame 'emi. ");
INSERT INTO tacNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Alésíko alué Esusi ku kabile alué apeli, 'lige 'yale alé u'tá re'obachi nóchame rió 'lige kilí asíbale. Suwábaga ralámuli napu ekí mochile alé abichilubi 'we e'nagá mochile aleké Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","'Lige alué Esúsika ra'íchile, regá anele: ―'Ma 'la machí 'emi alarigá ikiá napurigá ruwile alué Isaíasi ye osilichi, napu ruwime nile churigá nímili níliga ne. Regá anele Esusi. Alueka pe bo'nepi olagá anile bo'né ala'simio. ");
INSERT INTO tacNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","'Liko suwábaga ralámuli Esusi saega ra'íchale napugiti ta'mé a'lá semáriga ra'íchaligame Esusi alué ralámuli níriga. 'Lige anile a'bopi: ―Ye rioka pe José inolá ke, 'lige ruyá aníguru ralámuli gu'írame nimio. ");
INSERT INTO tacNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","'Liko Esúsika anele: ―'Emi ralámuli anémala ne'chí: «Mué, ralámuli 'yome, ralámuli 'yowa jipe jena.» 'Lige aminami anémala ne'chí: «Jena Nasarétachi napu mué ochérale, a'chigóriga nochawa napu aké ramué semátiri nóchali nóchaligo mué alé we'ká riógachi Kapernaumi anilichi.» 'Lige aminabi 'we ra'íchale, anile: ");
INSERT INTO tacNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","―Neka 'la bijchiá ruwimela tabilé 'wesi rió napu ruyame ju napu ané Onorúgame tabilé galegá etélime 'ínilio napu bo'né ochérale. ");
INSERT INTO tacNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Neka 'la machí we'ká umugí gunámakame mochíligo jena wa'lú gawí bo'ígichi Israeli anilichi 'ya napu'lige bejtele alué rió Elíasi napu'lige tabilé u'kule bakiá bamí miná nasipa 'lige napu 'we gurule go'ame bochígimi jena Israeli anilichi. ");
INSERT INTO tacNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Elíasi tase juláliru umugí gunámakame gu'írimia jena Israeli, iligá 'nalina juláliru wamí chebilena mejká riógachi Sarépata rewégachi napurigá gu'írimala alé ajtígame mukí gunámakame a'mulipi alé Sironi rewégachi we'ká riógachi. ");
INSERT INTO tacNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Abiena mochile we'ká rió jena Israeli sa'pachí amoba nayume napu'lige asale alué Eliseo rewégame rió napu ruyame nílige napu anélige Onorúgame, 'lige tase 'wesi ralámuli israelita nayúkame 'yóleru Eliséote, pe alué 'mi mejká bejtégame riocho Namani rewégame Siria rewégame gawí bo'ígichi bejtégame 'yóliru ―anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Alué ra'íchali akisá alué we'ká ralámuli alé pachá mochígame 'we ayole, pe ne'óchaga anime kéréligame ralámuli alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","'Lige yati jásiga, wamí o'tole alé we'ká riógachi suwé bilena rabó pamia rajkibuga bilena rejkuata. ");
INSERT INTO tacNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","'Lige alué Esúsika tabilé neti neyúsale alemi, pe nasípami simírole 'minami simiá. ");
INSERT INTO tacNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nasareta asagá Esusi alé Kapernaumi rewégachi we'ká riógachi re'kínale. Kapernaúmika Galilea rewégame gawí bo'ígichi pachá nile. 'Lige alé Kapernaumi 'we benírame nile Onorúgame nila ra'íchali rejcholi alué we'ká ralámuli rawé resíbulichi alé pachá u'tá re'obachi «sinagoga» anilime. ");
INSERT INTO tacNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ralámulika 'we ra'sálále akigá alarigá benírachi, napugiti 'la bijchiá Onorúgame a'walila gite ra'íchaligame 'we rejchiruga. ");
INSERT INTO tacNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Alé pachá napu napuíme nile alué ralámuli jurío asale bilé rió chátiri remónisi u'tabela ajchágame, 'lige alué remónisi u'tabela e'wele ra'ichárile alué rió regá: ");
INSERT INTO tacNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―¡Wamí simigá mué! Mueka ¿chonigá nawíbaché ne'chí mué Esusi Nasareta bejtégame? ¿Mueka nawá cha olamia ramué? Neka 'la machí mué: ¡Mueka wanápurigame ju Onorúgamete! ");
INSERT INTO tacNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","'Lige Esúsika ma'chí pale alué chátiri remónisi u'tabela alué riochi regá anegá: ―¡Tase che anigá, a'rewa ye rió! 'Liko alué remónisi u'tabela wijchí rekábale alué rió alué we'ká ralámuli jágichi, 'lige ma'chínale alé riochi tabilé ejelíriga. ");
INSERT INTO tacNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","'Liko suwábaga ralámuli 'we majale, 'lige anile a'bopi ra'íchaga: ―¿Churigá 'la uméroché ye rioka alué remónisi u'tabela pe ra'íchaga, 'la ma'chípá 'smíguru alué u'tabela remónisi ye riochi? ");
INSERT INTO tacNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","'Lige suwábaga ralámuli ichúrimi riógachi machile 'lige ra'íchale a'bopi 'we a'lá sa'wame ko alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","'Lige Esusi simile alé u'tá re'obachi asagá «sinagoga» rewégame, 'lige simile Simoni galílachi. Alué Simoni wasila 'we iná bo'ile, 'lige alué Esusi 'we e'wérili tániliru ralámulite napurigá 'yómala alué mukí. ");
INSERT INTO tacNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","'Liko Esúsika rojpóchaga chujkíbale alé a'bé 'lige ma'chí pale alué nayulí inawí regá anegá: ―¡A'rewa ye mukí! 'Liko alué mukí yati sa'wile iná. 'Lige yati asísiga kógile go'ame alué ralámuli alemi mochígame. ");
INSERT INTO tacNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Rayénali bokuíchi, we'ká ralámuli nayúkame a'píliru alué Esusi, we'ká e'karúgame nawilite nayume ralámuli. 'Lige Esúsika nochale alué a'pílipi nayume 'lige yati sa'wile alué nayúkame. ");
INSERT INTO tacNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jaré alué we'ká ralámuli nayume remónisi u'kuchípala mochígame nile, alué u'kuchípala remónisi abiena 'ma buyánale, 'lige ne'ole buyásiga regá: ―¡Mueka Onorúgame Inolá júkuru! 'Lige alué Esúsika tase najkile napurigá alarigá anewa, alekeri ne'óchale, tase a'rele napurigá ra'ichámala alué u'kuchípala remónisi napugiti alué u'kuchípala remónisika machime níligame Kristo ko alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Che'lachi simile alé we'ká riógachi asagá alué Esusi, simile a'minami tase riógachi. 'Lige ralámulika 'we 'yáale, 'lige napu'lige rewisá ralámulika tase najkile napurigá simela. ");
INSERT INTO tacNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","'Lige Esúsika anele: ―Neka benírimili júkuru alué a'lala rejcholi Onorúgame nila alé uché bilena riógame ralámuli churigá nimio napu'lige nulachi Onorúgame jena wijchimoba napu'lige 'ma 'la sébali ikisá napurigá najkí bo'né Onorúgame. Alekeri gite julárigame kame neka Onorúgamete. ");
INSERT INTO tacNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Alésíko eyénale Esusi beníriga alué rejcholi we'kanami u'kuchí re'obachi «sinagoga» rewégame alemi Jurea rewégame gawí bo'ígichi. ");
INSERT INTO tacNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Sinéchigo rawé alué Esusi beniria ilígachi alé suweke wa'lú ba'wí ilígichi Galilea rewégachi, we'ká ralámuli napuíle alé, rajchiní járole akináliga Esusi ruwichi tachiri najkiá Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Esusi etele oká u'kuchí barko ro'chí i'mula alé ba'wichí suweke uchúkame arikame. Alué ro'chí i'mume rioka 'ma e'tegílige, alemi ba'wichí suweke uchule morali pagoa ro'chí wejila. ");
INSERT INTO tacNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","'Lige Esúsika 'mole alé bilena bárkochi alé chujkúgame ba'wichí suweke napu nile Simoni nila. 'Lige nulale napurigá abé a'mibemi ba'wichí o'toboa alué u'tá barko. 'Lige Esusi alé bárkochi 'mole 'lige asíbale, 'lige alé asagá abichilubi 'we benírale alué ra'íchali tachiri najkiá Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Napu'lige suwénasa ra'íchali rejcholi beniria, anele alué Simoni: ―O'tó ye barko 'mi 'we rojkógachi, alé pápua alué morali ro'chí wejila, we'ká ro'chí chewimela alé. ");
INSERT INTO tacNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simónika regá nejele: ―Mué benírame, ramueka che'lebaru i'mua ro'chí, 'lige tabilé 'wesi ro'chí chewaru. Abirigáchigo pámalagó ne ye morali mué alarigá nulame. ");
INSERT INTO tacNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Napu'lige pasa alué morali alé, 'liko we'ká ro'chí che'wale, amulí chi'wale morali bejtéliga. ");
INSERT INTO tacNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","'Liko sekate ra'íchaga bayele alué chebilena u'tá bárkochi mochígame rió napurigá nejkúrimala. 'Liko alué rió yati simíbale alemi nejkúrimia. We'ká nile alué ro'chí, napu'lige wejiá 'ma bochile okánika alué u'kuchí barko 'lige amulí bokuíle bejtéliga ro'chí. ");
INSERT INTO tacNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Etesa we'ká ro'chí chewíligo, alué Simoni Pegro chojkóbisiga ilíbale alé a'bé napu ilile Esusi. 'Lige anele: ―Mué Wa'lula, pe rekó simigá 'minami uché bilénami napugiti neka 'we resítiri alawégame kame. ");
INSERT INTO tacNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Alarigá anile napugiti majáligime napugiti machíligame Onorúgame a'walila gite chewíligo alué we'ká ro'chí. Abiena majale alué uché jaré rió napu alé u'tá bárkochi mochile si etesa we'ká ro'chí chewichi. ");
INSERT INTO tacNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Abiena majale alué Sebereo 'kúchila Santiago 'lige alué Juani napu alué Simoni 'yuga nóchame nile. 'Lige alué Esúsika anele alué Simoni: ―Tase majawa mué rió, jípesíko 'ma tabilé ro'chí i'mume nímala mué. Jípesíko ra'íchali rejcholi ruyeme nímala mué ralámuli napurigá ku 'la na'támala. ");
INSERT INTO tacNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","'Lige alué u'kuchí barko o'tosá 'miná wakígichi, alé a'rele alué u'kuchí barko 'lige suwábaga tábiri, 'lige simíbale Esusi 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Bilé rawé Esusi ajtígachi alé bilena we'ká riógachi we'ká galí jágichi, 'lige bilé rió nawale alé sa'pachí amoba nayume «lepra» anilime nawilí yolí ra'íchaga. 'Lige alué rió etesa alué Esusi, alé a'bé ilíbale chojkóbaka 'lige rojpóchaga chujkíbiga. 'Lige regá anele: ―Mué Esusi, mueka 'we a'lá umébame ju sa'wá Onorúgame gite. Sa'wánilisaká sa'wawa ne'chí ye chati nayulí. ");
INSERT INTO tacNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","'Liko Esusi nochale sekate regá anigá: ―'La nímala. ¡Jípeko sa'wimela mué! 'Lige pe yati sa'wile alué nayume. ");
INSERT INTO tacNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","'Lige Esusi 'we a'lá anele: ―Si'né simiboa mué napu ajtí alué balé, tase ichúrimi riógachi eyénaga. Kógiwa go'ame Onorúgame napurigá nulale alué Moisesi 'we 'ya, a'lígeko alué we'ká ralámuli 'la machimela mué 'ma 'la sa'wígame ko, 'lige 'la lisensia nígame ko mué napurigá 'yuga einámala mué alué 'la a'ká ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Esusi sa'wasa alué rió, aminacho 'we machile we'ká ralámuli 'la umébame ko sa'wá Esusi, 'lige we'ká ralámuli napuíme nile alemi napu eyéname nile Esusi, Esusi ra'ichálila gepumia, 'lige jaré napurigá 'yowa nayume nísaká. ");
INSERT INTO tacNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","'Lige Esúsika i'sínimi a'mibemi uché bilénami simime nile tabilé riógachi 'lige alemi iligá ra'íchame nile Onorúgame 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Bilé rawé Esusi beniria ilígichi ra'íchali rejcholi ralámuli, 'lige mochile jaré ralámuli bariseo chojkégame alemi a'mulipi, 'lige abiena jaré rió benírame ra'íchali rejcholi napu a'rele Moisesi we'kaná riógachika sígame Galilea rewégame gawí bo'ígichi 'lige Jurea rewégame gawí bo'ígichi, abiena sígame Rusalénika we'ká riógachi. 'Lige Esusi Onorúgame a'walila gite 'we a'lá semáriga sa'wale alué we'ká ralámuli nayume alemi sígame. ");
INSERT INTO tacNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","'Lige jsile jaré rió majtógame bilé rió sujírigame tabachi rekagá. 'Lige pachá galírale o'tonálile a'bé rekamia alé napu ilile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","'Lige tase gayénale pachá mo'yá napugiti cha rajchiní jáligame ralámuli alé yochi. 'Liko jímole galimopa galichi 'lige ewarale alé 'lige alégana re'kibule alué nayume, gemachi o'wiga iwíate, nasipa we'ká ralámuli jágichi alé a'bé Esusi ilígichi. ");
INSERT INTO tacNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Napu'lige Esusi machisá 'we a'lá bijchigio alué ralámuli alué nayume a'págame 'we a'lá sa'wame ko Esusi, 'liko anele alué nayume: ―Mué rió, 'ma bujé ne mué nila chátiri 'nátili, jípeko 'we a'lá bi'wígame alawégame ju mué napurigá 'la moinámala rewagachi. ");
INSERT INTO tacNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","'Lige alué rió Moisesi rejchólila benírame abiena alué bariseo 'nátale: «¿Chieri júpaché ye rioka síkaniá tabilé niranti Onorúgame? 'La bujenti koriá aníguru ralámuli chátiri 'nátili napurigá 'la moinámala rewagachi. Pecha 'wesi rió bujémalagó chátiri 'nátili ralámuli, pe Onorúgameka 'la bujémala napurigá 'la moinámala rewagachi», 'nátale. Alué bariseo níriká 'we chátiri nile alué napurigá 'sile Esusi bujea chátiri 'nátili. ");
INSERT INTO tacNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","'Lige Esúsika 'la machile alarigá 'nátachi alué ralámuli, 'lige rukele: ―'Émika ¿chonigá alieri 'nata mochípeché? ");
INSERT INTO tacNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Churigá anilía 'nalina abé 'la nítékó pala regá anilía?: «Mué rió, 'ma bujé ne mué nila chátiri 'nátili napurigá 'la moinámala mué rewagachi», regáchala anilía: «¡O'weti ilísiga, yati einawa!» ");
INSERT INTO tacNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Jipe ne napu julárigame ju Onorúgamete 'pa rewagáchika napurigá rió neraga, 'la machírimala ne 'emi ralámuli wa'lú a'walí nígame ko ne Onorúgame nila napurigá bujémala ne chátiri 'nátili ralámuli jena wijchimoba ejperégame. 'Lige anele alué rió sujírigame: ―O'weti ilisi mué, simigá kumi galírale 'ma majtoga gemá. ");
INSERT INTO tacNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","'Lige alué rió sujírigame yati ilísale alué we'ká ralámuli etériga, 'wile alué gemá napu ajchagá re'kibúlirige, alésíko simile kumi galírale, wa'lú cheliera 'yasia enale Onorúgame, 'ma 'la sa'wígame. ");
INSERT INTO tacNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Alésíko alué we'ká ralámuli 'we ra'sálále, 'lige wa'lú cheliera 'yale Onorúgame. 'Lige aminámichigó pe'tá majaga regá anile: ―Jipe rawé eteru alué Onorúgame a'walílate sa'wame. Tabilé 'wesi ralámuli alarigá sa'wame ju bilé sujírigame. ");
INSERT INTO tacNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","'Lige pe nujubapi Esusi ma'chínale, 'lige etele bilé rió alemi ajtígame enomí goblalia alé napu ajtime nile enomí narea, Lebí rewégame. Alué enomika alué wa'lula i'lime nile alé Roma nulame. 'Lige Esúsika anele: ―Nabá ne'chí 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","'Liko alué Lebí ilísile, suwábaga abajá a'resa alué nóchali simile Esusi 'yuga 'we 'la oyériga. ");
INSERT INTO tacNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","'Lige Lebí pe abé alí wa'lú go'ame newile alué Esusi alé bo'né Lebí galílachi. 'Lige we'ká rió enomí goblálome napuíle alé, abiena uché jaré we'ká ralámuli mochile alé a'bé mésachi alué Esusi 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","'Lige jaré rió bariseo, 'lige jaré rió Moisesi nila ra'íchali rejcholi benírame, chojkile ra'icha alué Esusi 'yuga benime sayega. Regá anele: ―¿Chonigá go'áché 'emi 'lige bají 'emi alué ralámuli enomí goblálome 'yuga 'lige aminami alué ralámuli 'we chátiri 'nátame 'yuga? ");
INSERT INTO tacNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","'Lige Esúsika regá anele: ―Ralámuli tase nayume tase najkí bilé rió 'yome, pe alué nayume ralámulika 'la najkimela bilé 'yome. ");
INSERT INTO tacNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Neka tabilé nawákuru alué a'ká ralámuli gu'írimia, iligá nawá ne ra'íchali rejcholi benírimia alué resiti alawégame chátiri 'nátame ralámuli napurigá 'ma a'rémala alué chátiri 'nátili. Neka nawákuru e'nemia napu ralámuli 'we resílá mochí bilé nejkúrime. ");
INSERT INTO tacNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","'Lige alué ralámuli rukele alué Esusi: ―Alué Juani 'yuga benime, abiena alué ralámuli bariseo, ¿chonigá 'we ayúname ju 'lige 'we tánime iwérali Onorúgame? 'Lige ¿chonigá mué 'yuga benímeka tabilé siné alarigá nokame júché? ");
INSERT INTO tacNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","'Lige alué Esúsika nejele regá anigá: ―¿'Lacha nulémalawé 'emi napurigá ayunámala alué ralámuli kólime newigichi sígame alué rió newímili si ajtígachi? Tabilé nulémala 'emi. ");
INSERT INTO tacNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nobi sebámalagó bilé rawé napu'lige me'liboli ju alué newímili, 'lige alué ralámuli sígame ka 'oni ejtebímala. A'lige kulí ayunámala. ");
INSERT INTO tacNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Abiena uché bilé ra'íchili ruyele regá anime: ―Ta'wesi ralámuli chi'wanámala alué uché bilé o'pacha tabilé unérigame pachókimia alué o'pacha o'chérame. 'Lige alarigá olásiga alué o'pacha tabilé unérigame 'ma najsuímala, aminami alué o'pacha o'chérigame tase 'la ikiárélamala alué tabilé unérigame chiní 'yúriga. ");
INSERT INTO tacNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","A'chigóriga alué i'wilí ba'wila bijí gayena ilígame tase ro'alime júkuru 'we o'chérame chiliwílachi wi'chite newárigime. Alué i'wilí ba'wila bijí gayena ilígame alé ro'ásiga, 'ma a'támala alué chiliwila, 'lige alué i'wilí ba'wila bijí gayena ilígame 'ma go'límala. ");
INSERT INTO tacNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Alekeri alué i'wilí ba'wila bijí gayena ilígame tabilé unérigame chiliwílachi ro'alime ju napurigá ta a'támala. Alué chiliwila tabilé unérigame 'la ojtome ju alué i'wilí ba'wila bijí gayena ilígame ro'ásiga. ");
INSERT INTO tacNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ralámuli napu bajime ju alué i'wilí ba'wila 'ma 'we 'la gayénigime tase bajínilime ju alué bijí gayena ilígame napugiti abé korume kame alué i'wilí ba'wila 'ma 'we gayéniga ilígame. Esúsika pe regá anime ke anile: ―Tabilé 'wesi a'rénili ra'íchali rejcholi 'ya nerúgame. Neka benírimia nawá alué jipe nerúgame ra'íchali ne ra'ichálila nobi tabiléchigo 'wesi benináligó, pe alué o'chérigame ra'íchali 'nalina 'we galé. ");
INSERT INTO tacNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Bilé rawé resíbulichi alué Esusi enale alemi ri'ligó echégichi alué bo'né benírame 'yuga, 'lige alué ralámulika rejpunasia e'yénale ri'ligó mulalá 'lige mojsika go'sisia rakala. ");
INSERT INTO tacNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","'Lige alué jaré rió bariseo etele 'lige rukele: ―¿Chonigá alarigá nokáché 'émika jipe rawé resíbulichi? 'Emi 'we a'lá machí osáligo Moisesi ra'íchali rejcholi napu ruwime ju Onorúgame tabilé lisensia nejío napurigá rijpunawa nibilé pe u'kabi ri'ligó mulalá rawé resíbulichi. ");
INSERT INTO tacNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Esúsika regá rukele: ―¿Tacha machíché 'emi alarigá 'sílego siné rawé alué Rabí 'ya bejtégame e'lowisa 'lige aminami alué rió 'yuga e'yéname? ");
INSERT INTO tacNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Bajkílekuru alué rió Rabí pachá Onorúgame galílachi, 'lige 'wílekuru alué baní Onorúgame kógirigame 'lige go'ale, abiena kógile bo'né 'yuga e'yéname rekó tabilé nígame ke lisensia napurigá go'mela. Pe alué we'ká balecho 'la go'yame nile alué baní. ");
INSERT INTO tacNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Abiena regá anele: ―Ne napu julárigame ju Onorúgamete 'pa rewagáchika napurigá rió neraga, neka 'la nulame ju resíbulichi rawé. ");
INSERT INTO tacNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Uché bilé rawé resíbulichi Esusi bajkile alé u'tá re'obachi «sinagoga» rewégame, 'lige beniria ilígichi ralámuli, 'lige alé asale bilé rió sujírigame sekégame wajtoná. ");
INSERT INTO tacNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","'Lige alué ralámuli Moisesi a'rélala ra'íchali rejcholi benírame 'lige abiena alué ralámuli bariseo 'we e'negá mochile alué Esusi machináliga pala 'yósíta rawé resíbulichi. 'Yósaká 'liko nejiwa olale alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","'Lige alué Esúsika 'la machile alarigá 'nátachi alué ralámuli, 'lige anele alué rió sujírigame sekégame: ―O'weti ilí alé nasipa. 'Liko alué rió o'weti ilísale 'lige alé nasipa ilíbale. ");
INSERT INTO tacNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","'Lige alué Esusi anele alué uché jaré ralámuli: ―Ne bilé ra'íchali rukirá 'emi. ¿Tachiri chu'simía 'la lisensia ju rawé resíbulichi? ¿Gu'írilia ralámuli, resí oliáchalá? ¿Sa'walia ralámuli, a'rilíachalá napurigá mukumela? ¿Churigá nulale alué Moisesi? ");
INSERT INTO tacNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","'Liko alué Esusi e'néniga a'pílipi alué ralámuli napu ekí mochile alemi tachiri nejé anirá, 'lige tabilé nejechi alué ralámuli anele alué rió sujírigame sekégame: ―¡Wajchiná mué sekala! 'Lige alué rioka yati e'wale 'lige 'ma sa'wile. ");
INSERT INTO tacNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","'Lige alué bariséoka 'lige alué Moisesi a'rélala ra'íchali rejcholi benírame ralámuli 'we ayole etesa sa'wachi. Alésíko chojkile ra'icha a'bopi churigá 'la níliga alué Esusi me'liá. ");
INSERT INTO tacNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Siné rawé Esusi simile bilena rabó Onorúgame 'yuga ra'ichamia, 'lige che'lébale Onorúgame 'yuga ra'icha. ");
INSERT INTO tacNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","'Lige rayénali chíbachi, bayele alué bo'né 'yuga benime we'ká ralámuli, 'lige wanápale makué oká rió napurigá nulámala bo'né nochálalachi. ");
INSERT INTO tacNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Bilé alué Simoni nile, 'lige ujchele uché bilé rewá Pegro anilime. Uché bilé alué Antresi nile. Alueka nile Simoni bonila. 'Lige uché bilé alué Santiago nile, uché bilé alué Juani nile, uché bilé alué Belipe nile, uché bilé alué Bartolomé nile, ");
INSERT INTO tacNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","uché bilé alué Mateo nile, uché bilé alué Romasi nile, uché bilé alué Santiago nile alué Alipeo inolá, 'lige uché bilela Simoni napu nile geriyero bilé chojkégame geriyero gompaniérola alué alé Roma mochígame ralámuli saíla, ");
INSERT INTO tacNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","uché bilé alué Jurasi nile alué Santiago bonila, 'lige uché bilela Jurasi Iskariote napu a'kinana Esusi cha olale nejía. ");
INSERT INTO tacNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Esusi 'ma ku re'kínale alué makué oká rió 'yuga, 'lige sébale alé bilena epomi. 'Lige alé epomi jale we'ká ralámuli napu ejperégame nile we'kaná riógachi Jurea gawí bo'ígichi, abiena napu ejperégame nile we'ká riógachi Rusaleni rewégachi, abiena napu ejperégame nile okaná we'ká riógachi Tiro 'lige Sironi napu nile suweke alé wa'lú ba'wí ilígichi Meriteráneo rewégame ba'wí. Alué ralámulika napuíle alé gepumia alué Esusi rejchólila abiena napurigá 'yóowa jaré ralámuli nayume, ");
INSERT INTO tacNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","abiena alué nayume alué chátiri u'kuchípala remónisi mochígame. ");
INSERT INTO tacNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Esusi 'ma buyánale alué u'kuchípala remónisi. Suwábaga alué ralámuli nochánilia jale alué Esusi, abiena pe o'páchala ke nochánilia jale, napugiti pe nochasa alué ralámuli yati ma'chíname níligame alué Esusi a'walila, 'lige yati sa'wime nile alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","'Lige alué Esusi e'nele alué bo'né benírime, 'lige anele: ―Onorúgame 'we ganíliga eteme ju 'emi (yolí ra'íchagaká anime chujkú ‹‹dichoso››) rekó tabilé enomígame ke 'emi napugiti 'we a'lá gu'írilime 'emi Onorúgamete. ");
INSERT INTO tacNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","› Onorúgame 'we ganíliga eteme ju 'emi napugiti rekó jipe e'lowika ejperege, 'we 'la o'pasaga ejperélimili kame 'emi. › Onorúgame 'we ganíliga eteme ju 'emi napugiti rekó jipe nalaka ejperege 'we chálagá, 'we ra'sálagá ejperélimili kame 'emi. ");
INSERT INTO tacNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","› Onorúgame 'we ganíliga eteme ju 'emi rekó ta galilíe, rekó 'mi mabulie, rekó resí anilíe, rekó chibi anilíe pe ne'chí oyérame kóriká ne napu ju 'pa rewagáchika nawágame napurigá rió neraga. ");
INSERT INTO tacNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Alarigá anilíe, 'we ra'sáláwa 'emi ralámuli napugiti narémili kame 'emi semati raweli 'pa rewagachi. Alué 'ya ejperégame napu ruwime nílige napu anélige Onorúgame a'chigóriga aliena resí oláliru alué tabilé a'ká ralámulite napu nile rijimala alué jipe mochígame ralámuli tabilé a'ká. ");
INSERT INTO tacNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","› Resía 'emi ralámuli 'we nígame, 'émika we'ká rawé ganíliga ejperékuru nobi tabiléchigo narémiligó 'emi semati raweli 'pa rewagachi nerúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","› Resía 'emi ralámuli jipe 'la o'pasaga ejperégame, pe a'kinánami 'we e'lowika ejperélamala 'emi. › Resía 'emi ralámuli jipe riólaga ejperégame 'we ra'sálagá, 'we nígariká suwábaga tábiri, pe a'kinánami 'we nalaka ejperélamala 'emi chalagá. ");
INSERT INTO tacNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","› Resía 'emi ralámuli 'we a'ká ralámuli ko ruwame ralámulite. Alué ralámuli 'ya ejperégame anime nílechigó 'we a'ká níligo alué ralámuli napu ruwime nile napu anele Onorúgame. Abiena anele: ");
INSERT INTO tacNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","―Neka nulé regá anegá 'emi ralámuli napu gepua ja: Rekó sairúgame ralámuli ke, a'lá galewa, 'la gu'íriwa alué ralámuli 'emi gichime, ");
INSERT INTO tacNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","'la niraga ra'ichawa alué ralámuli 'yuga alué ralámuli chátiri 'nátame 'emi gichiga, tániwa Onorúgame napurigá Onorúgame 'la e'kámala alué ralámuli napu 'emi resí aneme ju. ");
INSERT INTO tacNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Bilé rió nejchosa bilena banachí, 'lige abiena owewa uché bilela banalá napurigá nejchómala. Bilé rió nejposa alué gemá chiní gemagá enálime, abiena 'yawa alué o'pacha. ");
INSERT INTO tacNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Apiépiri rió táachi bilé tábiri, yati 'yawa, 'lige bilé rió 'wísisa tábiri, tase ku tániwa. ");
INSERT INTO tacNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","'Emi najkisáká napurigá 'la niraga nejkúramala apiépiri ralámuli, 'liko 'emi bajchá 'we 'la niraga gu'írimili júkuru apiépiri ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","› 'Lige 'emi ralámuli galésaká pe alué ralámuli napu 'emi machime ju, ¿'wecha a'lá ju alarigá nokiá? Alarigá nokame ju alué ralámuli napu galeme ju aminá uché jaré ralámuli napurigá 'la galéwachigó. 'Émika 'la galémili júkuru alué ralámuli 'emi galeme, abiénachigó alué ralámuli tabilé galeme 'emi. ");
INSERT INTO tacNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","'Emi ralámuli 'la gu'írisa pe alué ralámuli napu 'emi gu'írame ju, ¿'wecha a'lá ju alarigá nokiá? Alarigá nokame ju alué ralámuli tabilé oyérame Onorúgame. 'Émika abé a'ká ralámuli nímili júkuru, me'tagá alué ralámuli tabilé oyérame Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","'Emi tanesa tábiri alué bilé rió napu ku 'la gu'linásaré, ¿'wecha a'lá nímalawé alarigá nokiá? Alarigá nokame ju alué ralámuli tabilé oyérame Onorúgame. Tanesa, buigá mochime ju ku gu'línilime. ");
INSERT INTO tacNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","'La galewa 'nalina alué sairúgame, 'la semáriga gu'íriwa, tanewa tábiri alué ralámuli 'lige tase 'nata mochiwa 'lige buigá napurigá ku nejímala e'karúgame tábiri napu tanele 'emi. Alarigá 'la ma'chí nérélamala Onorúgame 'kúchila ko 'emi alué Onorúgame napu 'we galeme ju alué ralámuli napu tabilé néléme ju Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","'Emi 'la na'temame niwa alué we'ká ralámuli, a'chigóriga napurigá Onorúgame 'we na'temame ju 'emi. Alarigáká 'we a'lá ju. Abiena anele: ");
INSERT INTO tacNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","―Tabilé che anewa ralámuli a'bopi 'we resí nokagá járome níriká, 'we cha anésaká 'emi, a'boi 'we resí nokagá e'yéname ke 'liko Onorúgamete gastigáriwa 'emi. Tase na'áuka ejperélawa 'emi ralámuli, alarigá Onorúgame tase ayónamala 'emi. 'La e'kawa 'emi uché jaré ralámuli 'lige alarigá e'kámala Onorúgame 'emi. ");
INSERT INTO tacNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","'La kógiwa 'emi tábiri uché jaré ralámuli, alarigá Onorúgame uché rajpé we'ká tábiri 'yámala 'emi ralámuli. 'We a'lá sébali tétiga nejísaká 'emi, 'la rajchiní ajchagá, 'liko 'we a'lá sébali tétiga narémala 'émichigó, 'la rajchiní ajchagá. ");
INSERT INTO tacNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","'Lige aminami alué Esusi rukele: ―¿'La 'yúrimeréle bilé rió tase ma'chílime uché bilé rió tase ma'chílime? ¿Ta rujsúmerélé okáraga alé bilénami rejkolichi? ");
INSERT INTO tacNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tase 'wesi alué benime anaga benégame nímala alué benírame. Napusí suwénasa 'ma suwábaga beniá 'liko 'la anámala alué benírame. ");
INSERT INTO tacNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","› 'Lige ta machisá mué bo'né wa'lú wejkolí ajchágame ko mué bo'né busílachi, 'lige ¿chonigá regá aneme ju mué alué rió: «Muérigó, aka ne ma'chí pátirigo alué u'tá wejkolí mué busílachi ajtígame»? 'La ma'chí pápua mué bo'né bajchá alué wa'lú wejkolí mué busílachi ajtígame a'liko 'la ma'chí pámala mué alué u'tá wejkolí alué rió busílachi ajtígame. ");
INSERT INTO tacNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Abiena anele: ―Bilé masana tabilé nayume tabilé chátiri masana rakémala, 'we a'lá a'ká rakémala. Alué masana nayume tabilé a'ká masana rakémala, alueka chátiri masana rakémala. ");
INSERT INTO tacNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","A'pílipi rojá bilena galírale jágame napu rakeme ju pe rakala etega 'la machirume ju. Tase rakémala alué chuná rakala go'ame alé bilena masana rojala atuálachi. Tase rakémala i'wilí alé golálachi. ");
INSERT INTO tacNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Alué 'we a'lala rió 'we semati ra'íchame ju napugiti 'we a'lá 'nátame kame. Alué 'we cha'sime rioka 'we chátiri ra'íchame ju napugiti 'we chátiri 'nátame kame. Bilé rió ra'íchame ju napurigá 'nata bo'né. Abiena anele: ");
INSERT INTO tacNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","―'Émika ¿chonigá wa'lula nulame anéché ne'chí, peka sébali olame ke napurigá nulé ne 'emi? ");
INSERT INTO tacNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Neka 'la ruyémala 'emi ralámuli tachiri káriká alué rió napu jeka nawame ju rejcholi gepumia 'lige 'la sébali olame napurigá nulé ne. ");
INSERT INTO tacNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Alué rioka kárékuru alué bilé rió napu 'la re'lé joka elale galí napu tabilé na'mile rekó a'wágame rajkichochi alué ba'wí wa'lú u'kusá 'lige wa'lú bo'ibasa ba'wí napugiti 'we 'la re'lé ilíligame, 'we a'lá a'wagá. ");
INSERT INTO tacNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Alué rió napu akeme ju ra'íchali 'lige tase e'wame, alué rioka káré napurigá alué bilé rió 'we amoba elágame galí tase re'lé joka napu 'ma na'mínaga pale alué ba'wí wa'lú u'kusá 'lige wa'lú bo'ibasa, a'wágame rajkichoga. Suwábaga ye ra'íchali rejcholi ruwile Esusi alemi epomi. ");
INSERT INTO tacNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Esusi suwénasa ra'íchali beniria alué we'ká ralámuli, a'lige simile pe u'kabi riógachi Kapernaumi rewégachi. Alé asale bilé wa'lula sontalo romano. ");
INSERT INTO tacNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Alué nulame sontalo ajchagá asale bilé rió nóchame napu 'we galeme nile. Alué nóchame tabilé meka nóchame nile enomí napurigá oliame nile jaré ralámuli 'we 'ya. Alué nóchame 'we nayua bo'ile, amulí mukiá bo'ile. ");
INSERT INTO tacNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","'Lige alué nulame sontalo akisá sa'wame ko alué Esusi, 'lige júlale jaré rió ralámuli jurío nuleme Esusi bayénaliga napurigá 'we sajpuka nawámala 'yomia alué rió nóchame nayua bo'ígime. ");
INSERT INTO tacNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","'Lige alué rió julárigame Esusi bayénaliga sebasa alé Esusi ajtígachi, nawile a'bé alué Esusi, 'lige 'we sajpuka 'we e'wérili bayérole, regá anegá: ―Alué rió nulame sontalo 'la níté gu'írilia ");
INSERT INTO tacNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","napugiti 'we a'lá galeme ramué ralámuli jurío. 'Lige alué gite 'la gayénarukuru ramué nila «sinagoga». ");
INSERT INTO tacNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","'Liko alué Esusi yati simile alué ralámuli 'yuga. Napu'lige 'ma a'mulipi e'yénigichi seba alé galírale, alué nulame sontalo jaré machirume ralámuli júlale regá anéniliga alué Esusi: ―Mué Wa'lula, tase chérekará rekó mué ta sébage alé pachá galírale, napugiti pe apiépiri rió koriame alué sontalo, ");
INSERT INTO tacNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","alekeri tase nawagórí mué 'yuga ra'ichamia. Pe jena iligá sa'wámará mué alué nayume Onorúgame a'walila gite alué sontalo piónila. ");
INSERT INTO tacNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Alué sontáloka nulélime korí e'wélalate, abiena nuleme korí sontalo u'kuchípala napu nuleme ju bo'né. Napu'lige julasa bilé sontalo alué bo'né, yati simime kará, 'lige napu'lige bayesa bilé sontalo alué bo'né, yati nawame kará, 'lige napu'lige nulesa alué bo'né 'yuga nóchame, yati e'wame kará. ");
INSERT INTO tacNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ye ra'íchali akisá, Esusi napurigá nábole alué sontalo, 'liko 'we ra'sálále, 'lige e'nele alué we'ká ralámuli napu alemi si e'yénale, 'lige anele: ―'La bijchiá ye rioka 'la sébili bijchígame ju 'we a'lá sa'wame ko ne Onorúgame a'walila gite. Jena napu ejperé ralámuli israelita pecha 'wesi ralámuli i'teko uché jaré aliena 'la sébali bijchígime 'we a'lá sa'wame ko ne. ");
INSERT INTO tacNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Napu'lige alué julárigame ku galírale sebasa, rewale 'ma a'lá sa'wígame alué rió nóchame. ");
INSERT INTO tacNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pe a'kinana Esusi simile uché bilena we'ká riógachi Naíni rewégachi, 'lige si e'yénale alué bo'né benírame abiena uché jaré we'ká ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","'Lige alé we'ká riógachi seba etele bilé re'malí mukúgame o'towame tomia bilena tabachi rekagá majtoga. 'Lige alué mukúgame pe bi'neli nile, napugiti pe alué bi'lepi ranégame níligame alué eyela gunamia. We'ká ralámuli alemi riógame e'yénale alué mukúgame o'towachi. ");
INSERT INTO tacNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","'Lige alué Esusi etesa alué mukí, 'we na'temale, 'lige anele: ―'Ma tase nalápua mué mukí. ");
INSERT INTO tacNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","'Lige alué Esusi a'bé nawile alué mukúgame, 'lige nochale alué tabali. 'Lige alué ralámuli majtoga e'yénigime ka kilí jábale. 'Lige alué Esusi anele alué mukúgame: ―¡Mué re'malí, o'weti asá! ");
INSERT INTO tacNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","'Liko alué mukúgame ku ajánale 'lige o'weti asísale, 'lige chojkile ra'icha alué re'malí. 'Lige Esúsika anele alué eyela: ―Ku o'togá mué inolá re'malí. ");
INSERT INTO tacNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","'Lige alué we'ká ralámuli etesa alué Esusi mukúgame ajániligo, 'we majale, 'lige wa'lú cheliera 'yale Onorúgame 'lige anile: ―Onorúgame 'ma júlale bilé rió napu ruwime ju napu ané Onorúgame napurigá ramué gu'írame nímala. ");
INSERT INTO tacNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Suwábaga ralámuli napu ekí ejperele alé Jurea rewégame gawí bo'ígichi abiena a'mulipi ejperégame machile alarigá Esusi ajánaligo bilé mukúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juani ralámuli rewarame machile sa'wáligo we'ká nayúkame 'lige ajániligo bilé re'malí mukúgame alué Esusi napugiti ruyéligame alué ralámuli napu Juani benírame ju, ");
INSERT INTO tacNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","'lige júlale oká alué bo'né benírame alé napu asale Esusi rukéniliga pala alué níliga nejkúrame napu nawámili nílige jena wijchimoba, uché bilé chalá buwémili níliga. ");
INSERT INTO tacNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Alué oká rió napu júlale Juani sébale alé napu asale Esusi, 'lige anele: ―Juánite jularu ramué, alué Juani ralámuli rewarame, rukéniliga napurigá ruwimela mué, ¿pala mué ka napu nawámili nílige Onorúgamete julárigame? ¿Uché chalá bilé buwewa? ");
INSERT INTO tacNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Alué oká rió sebasa alemi, Esusi 'we 'yoa ilile we'ká ralámuli sa'wá e'karúgame naulite nayume ralámuli, abiena buyana u'kuchípala remónisi ralámulichi mochígame, abiena ma'chiria alué ralámuli tase ma'chílime. Abichilubi 'we 'yole. ");
INSERT INTO tacNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Pe'tá i'libeko Esusi regá nejele: ―Ya kumi simíbaga ruyewa Juani napu etiá 'emi aminami napu aké 'emi. Ruyewa alué tase ma'chílime ralámuli ku sa'wao ne, sujírigame abiena ku sa'wao ne, alué sa'pachí amoba nayume ku sa'wao ne, alué najkacholo ku 'la akeme newao ne, alué suwígame ku ajanio ne, 'lige alué ralámuli resiti tase nígame enomí a'lá ruyeo ne alué a'lala ra'íchali Onorúgame nila. ");
INSERT INTO tacNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","'We ganíliga mochí apiépiri ralámuli napu tase ayoga gepume ju ne ra'ichálila. ");
INSERT INTO tacNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Napu'lige 'ma ku simasa alué oká rió napu Juani júlale, Esúsika chojkile ra'íchali ruyea alué ralámuli churigá níliga alué Juani, regá rukega: ―Napu'lige 'emi e'yenia e'néniga alué Juani alé jami, ¿chieti mayéliko alué rió? ¿Péchala mayelie nimio napurigá pe bilé gajsalá ekate noká ilime? ");
INSERT INTO tacNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","'Lige ta alieti rió e'néniga e'yénisiká 'emi, 'liko ¿tachiri e'néniga e'yéniliché 'emi alemi? ¿E'néniga e'yénilie 'emi bilé rió 'we semati o'páchigime? 'Lige 'emi 'we machíguru alué rió 'we semati o'páchigime ka 'we ganíliga semárikáchi bejtégame ko alé wa'lú galichi napurigá bilé rió 'we enomígame. 'Liko ¿tachiri e'néniga e'yéniliché 'emi alemi alué ralámuli? ");
INSERT INTO tacNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿E'néniga e'yénale 'emi alué napu ruwime ju napu ané Onorúgame? Ju, alué e'néniga e'yénale 'emi, alueka júkuru abé wa'lú a'walí nígame me'tagá alué uché jaré napu ruwime ju napu ané Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","'Lige alué Juani júkuru napu alé Onorúgame nila osilichi ruwí. Alé osilichi ka 'we a'lá sébali ruwí alarigá nímili níliga alué Juani, pe aba alé osilichi napu ruwile 'we 'ya Onorúgame churigá nímili níliga ne. Regá ruwí alé osilichi: Ne jula bilé rió ne nila ra'íchali ruwime bajchabé ta'chó sébachi mué napurigá beniá mochímala alué ralámuli ne nila ra'íchali. Alarigá 'we a'lá niraga etémala mué sébachi. Regá aní alé osilichi. ");
INSERT INTO tacNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","› Alué rió napu Onorúgame júlale pe Juani ju. Neka 'la ruwí tase 'wesi ralámuli i'tego jena wijchimoba 'we najtékame nóchali nígame me'tagá alué Juani. Neka abiena ruwí bilé rió tase najtékame ke, 'ma bi'wisá alawala alué rió 'liko 'we najtékame nimio Onorúgame níriga me'tigá Juani nochálila. ");
INSERT INTO tacNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Mochile alé alué enomí goblálome 'lige uché jaré ralámuli napu 'la niraga bijchígale napu nulale Onorúgame abé 'yabé napu 'la elile napurigá rewarawa alué Juánite 'yabé bajchabé rawé, alueka 'we 'la niraga akele alué Esusi ra'ichálila. ");
INSERT INTO tacNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","'Lige alué bariséoka 'lige alué Moisesi rejchólila benírame tabilé elile 'ya rawé napurigá rewarawa Juánite, alarigá gawélele Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Alué Esusi abiena regá anele: ―¡'La chieti ralámuli jipe riógame! ");
INSERT INTO tacNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Pe alué okaná chojkégame kuchí 'kuchi kárékuru napu mochime ju alé we'ká riógachi nasípami re'ea, napu re'énilime ju napurigá pe a'bocho najkí. Napu regá aneme ju alué bilena chojkégame kuchítiri napu 'yuga re'eme ju: Simérukuru ramué bilé wiká napurigá yawimela 'emi, 'lige 'emi tase yawí. Wikarárukuru ramué bilé wiká 'we sewékame, 'lige 'emi tase nalagá. 'Lige abichilubi ra'íchale Esusi regá: ");
INSERT INTO tacNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","―Nawálekuru alué Juani 'lige tase we'ká e'karúgame go'ame go'yame ju 'lige tase bajime ju rekútame, 'lige ralámuli jipe ejperégame tabilé e'wime júkuru, 'lige u'tabela remónisi ajchágame korí alué Juani ralámuli rewarame. ");
INSERT INTO tacNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","'Lige nawákuru ne napu 'pa rewagáchika nawágame ju napurigá rió neraga, neka go'yame júkuru we'ká e'karúgame go'ame, abiena bajime alué i'wilí ba'wila a'wágame newárigime. 'Lige 'emi 'we cha ané ne'chí, go'yechi ané, 'lige bajechi ané 'emi ne'chí, 'lige aní 'emi gompaniérola ko ne alué resí nokogá járome ralámuli, abiena alué enomí nareme alué wa'lula romano nareme. ");
INSERT INTO tacNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nobi 'láchigo ma'chígime néréko Onorúgame a'walila ne nochálila gite, 'lige Juani nochálila gite. ");
INSERT INTO tacNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Bilé rió bariseo bayérale Esusi bo'né galílachi go'ame kógimia. 'Lige alué Esúsika simile alé alué bariseo bejtélachi, alé sebasa asíbale a'bé mésachi. ");
INSERT INTO tacNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","'Lige bilé mukí we'ká rió 'yuga gojchime napu bejtele alé we'ká riógachi, machisá Esusi simíligo alé bariseo bejtélachi go'ame go'mea, alué mukika yati alemi sébale bilé u'tá botea gajpílame rejtete newárigime o'ká ba'wí 'we semá júkame ro'ágame. ");
INSERT INTO tacNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","'Lige 'we nalaka a'bé Esusi ajtígichi alé a'bé ralachí chujkíbale rojpóchaga. 'Lige chojkile pagoa Esusi ralala alué bo'né mukí bo'né o'kiálate, 'lige wakele bo'né gupálate. Abiena 'we chu'mile ralala napurigá nokame nile, 'lige ro'ele alué ba'wí 'we semá júkame. ");
INSERT INTO tacNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Etesa bo'né bariseo napu Esusi bayélige, regá 'nátale: «'La bijchiá ruwime nísaká napu Onorúgame ané, 'liko machimékuru alieti mukí ka ye mukí, 'we chátiri mukí júkuru we'ká rió 'yuga gojchime.» ");
INSERT INTO tacNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","'Liko Esúsika machigá alarigá 'nata ajtigó alué bariseo anele: ―Mué Simoni, ne bilé ra'íchali ruwimela. 'Lige alué rió bariséoka regá nejele: ―Ruwígó mué benírame. ");
INSERT INTO tacNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Esúsika anile: ―Oká rió wikele bilé rió enomí taneme, 'lige bilé rió maligi siento enomí wikame nile, bilé wikame nile malígisa makué. ");
INSERT INTO tacNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","'Lige okánika tase umébale ku gu'lina. 'Lige alué enomí tanémeká 'la e'kale alué wikame okánika alué rió. ¿Chieri 'nalina abé ganíliga rejpílekobá alué rió enomí taneme 'yuga? ");
INSERT INTO tacNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simónika regá nejele: ―Alué rió napu abé we'ká wikame nile. Esúsika regá anile: ―'La bijchiá aní mué. ");
INSERT INTO tacNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","'Liko alué Esusi e'néniga alué mukí anele alué Simoni: ―'La etiá mué ye mukí alarigá 'sichi. Neka bajkíkuru mué galílachi, 'lige mueka tase nejíkuru ba'wí napurigá ne ralala pagómala. 'Lige ye mukika ne'chí ralala pagókuru alué bo'né o'kiálate, 'lige wakékuru bo'né gupálate. ");
INSERT INTO tacNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mueka tase chu'míkuru ne'chí napurigá nokiame niru ramué, 'lige ye mukika napusí seba tase a'ré ne'chí ralala chu'miá napugiti 'we a'lá nirame ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Aminami mueka tase ujchékuru alué aseite ne mo'ólachi 'we a'lá niraga napurigá nokame niru ramué, 'lige ye mukika ro'ékuru ne ralálachi alué ba'wí 'we semá júkame. ");
INSERT INTO tacNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Alekeri aní ne: «Ye mukika wa'lú e'kárigime ju», ma'chígime nérékuru napugiti 'we a'lá nirame ne'chí. Alué ta'mé wa'lú e'kárigime ka, pee semá 'sime ju. ");
INSERT INTO tacNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Alésíko alué Esusi anele alué mukí: ―Mué mukí, wa'lú e'kárigime ju mué. Jípeko 'la sebámala mué 'pa rewagachi. ");
INSERT INTO tacNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Alué ralámuli bayérigame napu mochile alé si, alueka chojkile ra'icha a'bopi, regá anigá: ―¿Chieri júché ye rió síkaniá napu 'la e'kágorianíguru? Pe alué Onorúgameka 'la e'kame ju. ");
INSERT INTO tacNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","'Lige Esusi abiena uchéchigo anele alué mukí: ―Mué mukí, mueka 'we 'la bijchigi 'la e'kame ko ne ralámuli, alekeri 'ma tabilé gastigáriwa mué Onorúgamete. Ganíliga enawa kumi. ");
INSERT INTO tacNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pe a'kinana alué Esusi we'kaná we'ká riógachi eyénale abiena pe tabemi riógachi benírisia Onorúgame nila ra'íchali rejcholi, 'we a'lá ma'chígime ruigá churigá ka napu'lige 'ma 'la sébali ikisá napu najkí Onorúgame. 'Lige e'yénale si alué makué oká rió napu nulame nile Esusi nochálilachi, ");
INSERT INTO tacNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","abiena si e'yénale alué jaré umugí napu alué Esusi buyánilige u'kuchípala remónisi pachágana alué umugichi mochígame, abiena napu Esusi sa'wálige nayulí. Bilé alué mukí María rewégame nile napu ochérigame nile Magalena anilichi, alué mukí napu gichao u'kuchípala remónisi buyánirigame nile Esúsite. ");
INSERT INTO tacNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Abiena si enale Juana rewégame mukí, alué Chusa rewégame rió upila, alué rió napu wa'lula nulame nile alé wa'lula selígame Erore bejtélachi. Abiena si eyénale bilé mukí Rusana rewégame, abiena uché jaré we'ká umugí. Suwábaga alué umugí napu si e'yénale Esusi 'yuga alemi a'pame nile tábiri go'ame napurigá go'mela Esusi 'lige alué makué oká rió napu nulame nile Esusi nochálilachi. ");
INSERT INTO tacNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","'Lige we'ká ralámuli napuíle napu sébale Esusi, napuíle we'kaná riógachi ejperégame ralámuli. Alué ralámuli alemi napuísa, Esúsika ra'íchale, regá anigá: ");
INSERT INTO tacNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Bilé rió simile ri'ligó echimea, 'lige weroka echale 'ma sebasa bo'né gawílachi. 'Lige alé bo'né gawílachi nasipa bo'ígime nile bilé bowé 'lige jaré ri'ligó rakala rujsule alé bowechi napu bo'ile alemi asarachi, 'lige 'ma re'keréle ralámuli alemi simáriga, abiena 'ma chulugí go'lele. ");
INSERT INTO tacNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","'Lige jaré ri'ligó rujsule alemi napu nile i'pichí tabilé ru'nágame we'é ajtígichi, 'lige alué ri'ligó ya'wisá alé, 'ma wakíbale, pecha sa'mime níliga alué we'é. ");
INSERT INTO tacNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","'Lige jaré ri'ligó rujsule pe alemi suwékimi wejchárale, 'lige tabilé 'la ya'wile alué ri'ligó. ");
INSERT INTO tacNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","'Lige jaré ri'ligó rujsule 'we a'lá asarachi 'we a'lá sa'michi, 'lige 'we a'lá ya'wile, 'lige alué ri'ligoka 'la we'ká rakele. We'ká 'wile alué rió echágame. Regá anisá Esusi, aminami regá anílechigó a'wágame ra'íchaga: ―'Emi ralámuli 'la akeme niri ka, 'la námaka gepuwa ―regá anile. ");
INSERT INTO tacNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","'Lige alué makué oká ralámuli Esusi benírimeka anele: ―Ruyá aníguru mué jaré ri'ligó rujsúligo tabilé 'la we'echi 'lige tabilé 'la rakéligo, 'lige jaré ri'ligó rakala rujsúligo 'we a'lá we'echi 'lige 'we a'lá rakéligo. 'Lige rukele: ―¿Tachiri ruwime ke aní mué? ");
INSERT INTO tacNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Esúsika anele: ―'Émika a'lá ma'chígime ruyémala ne napu tabilé námale 'emi. 'Lige uché jaré ralámulika tabilé 'la ma'chígime ruyémala ne ta'mé námutame, napurigá alué ralámuli tabilé pe'tá námaka ejtebímala rekó 'la etee 'lige rekó abiena 'la akeé. ");
INSERT INTO tacNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","'Lige aminami anele alué Esusi: ―Ye ra'íchalika ruwime kéré Onorúgame nila ra'íchali neraga ko alué ri'ligó rakala. ");
INSERT INTO tacNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Alué boweka ruwime kéré alué ralámuli napu pe kulí chojkime ju Onorúgame ra'ichálila beniá 'lige alué Remónisi nawasa 'ma bujeme ko alué Onorúgame ra'ichálila napurigá ta oyéramala napurigá ta bi'wimela alawala. ");
INSERT INTO tacNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","'Lige alué we'é tase ru'nágame ka ruwime kéré alué ralámuli napu akeme ju Onorúgame nila ra'íchali rejcholi, ganíliga gepume ko sineko 'lige tase we'lisi námaka mochime ko. Napu'lige resí ikiá ku a'reme ko alué ra'íchali rejcholi. ");
INSERT INTO tacNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","› Alué wejchaka, alueka ruwime kéré alué ralámuli rekó 'la 'nátaga akeme ke alué Onorúgame nila ra'íchali rejcholi 'lige tase a'reme ko alué tabilé Onorúgame nila ra'íchali rejcholi, 'we 'nátame ko enomí méliame 'lige alué uché jaré e'karúgame tábiri nochálime tase 'la Onorúgame nila, 'lige tase 'la o'wé nóchaga e'yéname ko Onorúgame nochálalachi. ");
INSERT INTO tacNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","'Lige alué we'é a'lálaká alueka ruwime kéré alué ralámuli napu ra'íchali rejcholi akeme ju 'la sébali e'wame ko, tasiné a'reme ko e'wá alué Onorúgame nila ra'íchali rejcholi, senibí 'la sébali olame ko. Abiena Esusi anele: ");
INSERT INTO tacNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","―Tabilé 'wesi ralámuli rajeme ju bilé chojpé wa'lú bejtólite o'póliga rekamia, nibilé elamia bilénami sejkóchimi rajagá, iligá re'pabo elame ju napurigá 'la ma'chílimala ralámuli alemi mo'ime. ");
INSERT INTO tacNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ye ra'íchalika ruwime kéré jena wijchimóbaka tase 'wesi 'nátili nerúlimio nasótigame, abiena a'kinana 'ma suwábaga machiboli ko churigá 'nata ajtigó bilé ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","'Liko 'la 'nátaga gepusi 'emi: Alué napu 'la námame ju bile ra'íchali rejcholi ruilía 'lige uché jaré ralámuli benírame alué ra'íchali rejcholi, alueka uchérajpé 'yáwali ju 'nátili Onorúgamete. Alué napu 'la námame ju bilé ra'íchali rejcholi 'lige tabilé benírame uché jaré ralámuli alué ra'íchali rejcholi, alué u'kabi napu ekí námale 'ma we'kuámala ―regá anele Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Napu'lige Esusi bijí ra'icha ilígichi, alué Esusi eyela 'lige suwábaga alué nasípasi bonila 'lige nasípasi waíla sébale alé napu asale 'lige tase cherigá a'bé nawile cha we'ká jáligame ralámuli alemi. ");
INSERT INTO tacNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","'Lige bilé ralámuli ruyele alué Esusi regá: ―Mué eyela 'lige mué bonila 'lige mué waíla alé ma'chika jawí 'lige mué 'yuga ra'ichánili ―anele. ");
INSERT INTO tacNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","'Lige Esúsika anile: ―Alué napu 'la 'nátaga gepume ju Onorúgame nila rejcholi abiena 'la sébali olame napurigá aní alué rejcholi, alueka 'la napurigá ne eyela júkuru 'lige napurigá ne bonila 'lige napurigá ne waíla. ");
INSERT INTO tacNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Bilé rawé Esusi 'mole 'yuga alué makué oká rió alué bo'né Esusi benírame bilé u'tá bárkochi, 'lige anele: ―Wamí 'lebo bajoniwa ye bárkochi mochiga jena wa'lú ba'wí ilígichi Galilea anilime. 'Lige simíbale alé u'tá bárkochi mochiga. ");
INSERT INTO tacNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","'Lige alemi nasipa ba'wichí e'yénaga Esúsika gojchile. 'Lige pe yati neraga a'wágame ekénale alemi, 'lige a'wágame chíbale ba'wí alé bárkochi, wa'lú maníbale alé pachágana, amulí bokuíle. ");
INSERT INTO tacNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","'Lige alué makué oká rió yati ajchale Esusi regá anegá: ―¡Muérigo ramué nuleme! ¡'Ma bokuíchi ye barko! ¡'Ma amulí si'lilia ramué! 'Liko alué Esusi asísale 'lige a'wágame ne'óchale alué eká 'lige alué ba'wí, 'ma kilí elábale alué eká abiena alué ba'wí a'wágame chíbachi alé bárkochi, alésíko 'ma asíbale alué eká. 'Lige anele alué makué oká rió: ");
INSERT INTO tacNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","―¿Chukirúpeché? ¿Chonigá tabilé bijchigi 'emi pe Onorúgame gite 'la asibamio ye eká? 'Lige alué ralámulika e'karúgame 'nátaga, a'bopi rukele: ―¿Chieri júché ye rió? Aka 'la e'wárinti ka'e ekátiri. ");
INSERT INTO tacNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Arigá sébale na'lebo baona napu ejperégame nile alué ralámuli Garáraka sígame, alué gawika bo'ile na'lebo bajoniga o'wépoka Galilea rewégachi gawí. ");
INSERT INTO tacNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Esusi re'kisa alé bárkochi 'lige sébale bilé rió alemi abalemi bejtégame. Alué rioka 'ma we'ká bamí lo'í nile alué remónisi u'kuchípala gite. 'We chátiri na'tárime nile alué u'kuchípala remónisi. Alué rioka tase o'pachátame nile, aminami tase bejtégame nile bilena galírale, pe resochí bejtégame nile napu ro'ilime nile suwígame. ");
INSERT INTO tacNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","'Lige alué rió Esusi etesa a'wágame sinale, 'lige 'male a'bemi napu ilile Esusi 'lige a'bé ilíbale chojkóbisiga napu ilile Esusi, 'lige e'wele ne'oka anile: ―¿Tachiri najkí mué Esusi, Onorúgame 'pa rewagachi ajtígame inolá? ¡Pe rekó tase resí olawa ne'chí! ");
INSERT INTO tacNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Alarigá anile napugiti alué Esusi nuléligime bilé remónisi u'tabela napurigá ma'chínamala alé riochi. Alué remónisi u'tabela i'sínimi 'we a'wágame newame nile alué rió 'lige 'we lo'í. Ralámulika buleme nile sekala alué rió abiena ronola karénate napurigá ta ichúrimi júmamala, 'lige alué rioka pe gáriga rejpúname nile alué karena. Alué remónisi u'tabela gite 'másame nile jami lo'íriga. ");
INSERT INTO tacNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Esúsika rukele alué lo'í: ―¿Chonilime ju mué? Alué lo'ika regá nejele: ―Neka Lejioni rewégame ju. Alarigá anile alué rió napugiti we'ká remónisi u'kuchípala mochígame níligame pachágana alué riochi. ");
INSERT INTO tacNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","'Liko alué remónisi u'kuchípala anele Esusi napurigá ta 'lúpua bilena 'we re'lé ewágachi tajsiné chibálime. ");
INSERT INTO tacNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","'Lige alemi a'mulipi we'ká gowí uchule rojí go'yá, 'lige alué remónisi u'kuchípala lisensia tánale alé gowichi mo'imea. 'Lige alué Esúsika 'la lisensia 'yale. ");
INSERT INTO tacNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","'Lige alué remónisi u'kuchípala buyale alé riochi, 'lige mo'ile alé gowichi. 'Lige alué gowí 'ma lo'írile, alésíko júmasele bilena 'we go'nágana 'we enárikáchi alué wa'lú ba'wí ilígichi Galilea rewégame, 'lige alé 'ma suwile alué gowí si'lika. ");
INSERT INTO tacNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Alué gowí neseme etesa alarigá ikisao yati júmasele majaga, simíbale ruyemia ralámuli alé we'ká riógachi abiena alemi 'we e'megá riógachi. ");
INSERT INTO tacNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","'Liko alué ralámuli akisá alué ra'íchali yati júmale e'nemia pala bijchiá níliga. 'Lige sebasa alé napu ilile alué Esusi, etele alué rió napu Esusi we'ká u'kuchípala remónisi buyánale, etele a'bé ajtígame ralachí chega napu ilile Esusi, 'ma 'la o'páchiga abiena ku 'la rió. 'Liko alé ajtígame etesa ralámuli, majale. ");
INSERT INTO tacNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","'Lige alué ralámuli napu etele sa'wichi alué rió lo'í ruyele uché jaré ralámuli sa'wíligo alué rió napu we'ká u'kuchípala remónisi mochígame nílige pachágana. ");
INSERT INTO tacNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Suwábaga ralámuli Garara rewégachi ejperégame chojkile alué Esusi mabua napurigá uché bilénami simela napugiti alué ralámulika majáligime. 'Liko Esúsika ku 'mole alé bárkochi 'lige simile alué barko asagá. ");
INSERT INTO tacNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","'Lige alué rió napu Esusi we'ká u'kuchípala remónisi buyánirile, ta'chó simichi Esusi, anele: ―Neka si siminali mué 'yuga. 'Lige Esúsika tabilé elile napurigá si simela, 'lige Esúsika anele: ");
INSERT INTO tacNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Mueka ku galírale simiboa, 'lige suwábaga rupoa alarigá gu'íriliriga mué Onorúgamete. 'Lige alué rioka yati simile 'lige chojkile we'ká ralámuli ruyea alemi we'ká riógachi ejperégame 'we a'lá gu'íriliga Esúsite. ");
INSERT INTO tacNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Esusi ku sebasa alé na'lebo, 'lige alué we'ká ralámulika 'we ra'sálále ku nawachi Esusi napugiti suwábaga 'we buigá mochíligame. ");
INSERT INTO tacNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","'Lige alemi nawale bilé rió Jairo rewégame. Alué rioka nulame nile alé u'tá re'obachi «sinagoga» rewégame. Alué rioka alé a'bé Esusi ralálachi ilíbale chojkóbisiga, 'lige 'we e'wérali bayérale regá anigá: ―Pe rekó, nabá ne bejtélachi ");
INSERT INTO tacNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","napurigá 'yómala mué ne malala ―anele. Alué rioka pe alué bi'lepi malégame nile makué oká bamígame, 'lige 'we nayua bo'ile alué iwé, amulí mukiá bo'ile. ―'La ju. Nabágó 'líkó ―anele alué Esusi. 'Lige alué Esusi alé Jairo bejtélachi simiá enágichi, we'ká ralámuli si simíbale rajchiní namó járole simiba napu Esusi enale. ");
INSERT INTO tacNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","'Lige alemi si enale bilé mukí 'ma makué oká bamí nayume, alué mukika rojpachí nayume nile, tabilé siné sa'wime nile elena rojpachí, rasígame eléname nile. 'Lige 'ma suwábalige suwábaga enomí 'yome najtétiga, 'lige tase 'wesi umébale sa'wá. ");
INSERT INTO tacNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","'Lige alué mukika a'bé nawile alué Esusi alemi guwana simigá, 'lige nochale alué Esusi o'páchala we'lí se'wala, 'lige alarigá 'sisa alué mukí, 'lige yati sa'wile. ");
INSERT INTO tacNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","'Liko Esúsika rukele: ―¿Chieri nochá ne'chí o'páchala se'wala? 'Lige o'maka anile: ―Ta'wésigurú. 'Lige Pégroka anile: ―Mué Wa'lula, alué ralámulika 'we namó járo'é jemi 'we rajchiní. «¿Chieri nochá ne'chí o'páchala se'wala?», aniá aníguru mueka. Ramueka tabilé machirú. ");
INSERT INTO tacNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","'Lige Esúsika regá anile: ―Aka bilé ralámuli nochátubá ne o'páchala se'wala, aka ne 'la ne nili níliché sa'wá alué ne nila a'walite. ");
INSERT INTO tacNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","'Liko alué mukí tabilé ikírisa mejkabemi simiá chíbamia, 'liko simile áwalisia, 'lige a'bé chujkíbale rojpóchaga napu ilile Esusi. 'Liko anele we'ká ralámuli akériga sa'wináliga gite nocháligo alué Esusi o'páchala we'lí se'wala, 'lige anele yati sa'wíligo alué Esusi o'páchala se'wala nochasa. ");
INSERT INTO tacNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","'Liko alué Esúsika anele: ―Mué mukí, jípeko 'ma sa'wígame ju mué 'lige 'ma 'la bi'wígame alawégame napugiti 'we a'lá sébali bijchígiligame mué a'walí nígame ko ne. Jípeko 'we ra'sálagá enawa kumi. ");
INSERT INTO tacNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Bijí ra'icha ilígichi alué Esusi alué mukí 'yuga, 'lige sébale alé bilé rió alué wa'lula Jairo galílachika simígame. 'Lige anele alué Jairo: ―Mué malala 'ma mukú. 'Ma tase aminabi bayérowa ye benírame Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","'Lige Esusi akisá alué ra'íchali, anele: ―Tase majawa mué rió mayega 'ma bijchiá mukúligo, pe 'la bijchígiwa 'la a'walí nígame ko ne, 'lige mué malala ku ajánamala. ");
INSERT INTO tacNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Napu'lige sebasa alé galírale Jairo bejtélachi, 'lige Esúsika tase elile napurigá uché jaré ralámuli si mo'imela alé pachá, pe bakiá bo'né benírime Pegro, Santiago, 'lige Juani, 'lige alué tewé eyela, abiena alué tewé o'nola. ");
INSERT INTO tacNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","'Lige alué tewé we'kasa, alué we'ká ralámuli suwábaga 'we nalá jale sulachí o'choa a'bopi napurigá nokame nile alué ralámuli. 'Lige Esúsika anele: ―Tase nalasi 'emi. Ye u'tá teweka tase mukugá bo'í, pe gojchigá bo'í. ");
INSERT INTO tacNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","'Lige ralámulika tase bijchígile, pe gawélele, 'la machíligame mukugá bo'igó alué iwé. ");
INSERT INTO tacNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","'Lige Esúsika bajkile napu bo'ile alué iwé, 'lige cha'pile sekala, 'lige anele e'wele ra'íchaga: ―¡Mué iwé, asísiwa! ");
INSERT INTO tacNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","'Lige alué iwé ku ajánale, 'lige yati ku o'weti asísale. 'Lige Esusi nulale napurigá kógiwa go'ame. ");
INSERT INTO tacNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","'Lige alué o'nola eyela si 'we ra'sálále. 'Lige alué Esúsika nulele napurigá tabilé 'wesi ralámuli ruyémala ku ajánilirigo. ");
INSERT INTO tacNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Esusi bayele alué makué oká rió Esusi benírame, 'lige 'yale a'walí 'lige nóchali napurigá ma'chí buinámala alué remónisi u'kuchípala ralámulichi pachágana mochígame abiena napurigá sa'wámala alué nayúkame. ");
INSERT INTO tacNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Júlale napurigá beníramala churigá nimia napu'lige sébali ikichi jena wijchimoba napu najkí Onorúgame, ");
INSERT INTO tacNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Regá anegá júlale: ―Tabilé tábiri o'ká simawa. Tase o'ká simawa resola, nibilé sibula, nibilé enomí, nibilé nutugega. Tase pabega simawa uché bilé o'pacha re'lé ujchalime nujubami o'pachátilime. ");
INSERT INTO tacNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Alé bilena we'ká riógachi sebasa, 'la bi'lénapi galírale mochiga nochawa napu'lige 'yoa ichúrimi e'yéniga, napusí simiba uché bilena we'ká riógachi a'lige kulí a'rewa alué galí. ");
INSERT INTO tacNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","'Lige aminami alemi we'ká riógachi sebasa 'emi, 'lige alé tase galésiga 'emi, 'liko yati uché bilena we'ká riógichimi simawa. 'Lige 'we a'lá sawesa simawa we'é ronochí chujkíbigame. Alueka ruyame nímala Onorúgame gastigárimio alué ralámuli tabilé nejígoriká bilé galí napurigá alé mochiga nochámala 'emi ralámuli 'yoa ichúrimi e'yéniga. ");
INSERT INTO tacNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Alésíko simíbale alué makué oká rió ichúrimi, we'ká riógachi e'yénale benírisia ralámuli alué 'we a'lala rejcholi Onorúgame nila, abiena nayúkame sa'wasia. ");
INSERT INTO tacNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Alué wa'lula selígame rió Erore rewégame akisá suwábaga alarigá 'sió alué Esusi 'lige alué makué oká rió, e'karúriga 'nátale 'lige tase machile chieri rió ka alué napugiti aníligame jaré ralámuli: ―Juani ku ajánale. Jaréchigo mayele alué 'ya ajtígame ko Elíasi rewégame napu ruwime nílige napu anele Onorúgame, alué ku ajánaligo mayele. 'Lige jaréchigo mayele ku ajánaligo uché bilé rió alué 'ya ajtígame napu ruwime nílige napu anélige Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","'Lige alué wa'lula selígame Erore Antípasi rewégameka regá anile: ―Aka 'ma nuligéché ne me'líniliga Juánika 'lige 'ma a'pírigeturu ne alué Juani mo'ola rijpúniga gujtala, 'lige ¿chieri júché alué rió? 'We ruwanti júkuru alué rió. 'Lige alué wa'lula selígame Erore eténale alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Napu'lige ku sebasa alué Esusi nochálilachi nulame alué makué oká rió, ruyele 'la beníriligo Onorúgame nila ra'íchali rejcholi ralámuli 'lige 'yóligo ralámuli. 'Lige alué Esúsika bayérole alué makué oká rió alé 'minami tase riógachi alé a'mulipi pe'kabi riógachi Betsáira rewégachi. ");
INSERT INTO tacNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","'Lige ralámulika machisá alemi simíbaligo, yati najátale. 'Lige Esúsika 'we galegá etele alué we'ká ralámuli, 'lige ruyele churigá nulame ko Onorúgame, abiena sa'wale ralámuli nayúkame. ");
INSERT INTO tacNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","'Lige 'ma alichi, alué makué oká rió nawile a'bé alué Esusi, 'lige anele: ―Mué Esusi, ya a'rewa ye ralámuli napurigá simámala 'minami resíbamia go'ame 'yáamia 'minami we'kaná a'tabemi riógachi. Jena napu ramué mochiru tabilé i'té go'ame. ");
INSERT INTO tacNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","'Lige alué Esúsika anele: ―Aka 'emi kógiwagurú go'ame. 'Lige alué makué oká rioka anile: ―Tase we'ká nerú baní, pe malígipi mochí, 'lige pe okabi ro'chí bi'tí. Wa'lú ralisúká go'ame 'la nímaleké 'liko 'la o'pasámaleké ye we'ká ralámuli. ¿Koche ralibóaché alakí go'ame? ―anile alué makué oká rió. ");
INSERT INTO tacNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","We'ká ralámuli mochile alé, we'ká umugí 'lige we'ká u'kuchítiri. Siné kachi maligi mili mochíligeréko pe riocho. 'Lige alué Esúsika anele alué makué oká rió: ―We'kaná chojkégame neraga mochiawa malígisa makué neraga. ");
INSERT INTO tacNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","'Liko alué makué oká rió yati alarigá nulele ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","'Lige Esusi 'wile alué maligi baní 'lige alué oká ro'chí, 'lige 'pa rewagachi e'negá iligá wa'lú cheliera 'yale Onorúgame. 'Lige Esusi nasípasi chi'wanasa alué maligi baní 'lige alué oká ro'chí, 'yale alué makué oká rió kóginiliga alué we'ká ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","'Lige alué we'ká ralámuli 'we a'lá sébali o'pasale, 'lige pe nujubapi napubule alué makué oká rió alué go'ame rasírigame, 'lige bochile makué oká e'wele atabé alué baní a'tabé rasírigame abiena ro'chí 'yúriga. ");
INSERT INTO tacNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Bilé rawé alué Esusi Onorúgame 'yuga ra'icha ilígachi waná bi'neli alué makué oká rió alué Esúsite benírilime alemi mochílechigó. 'Lige rukele: ―¿Chieri korí alué ralámuli ne'chí? ");
INSERT INTO tacNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Alué ralámulika regá nejele: ―Jaré ralámuli aní mué Juani ko napu ralámuli rewarame nile ba'wichí jáwaga. 'Lige jaréchigo ralámuli aní Elíasi ko mué. Jaréchigo ralámuli aní mué ko bilé alué 'ya mochígame napu ruwígame nílige napu anélige Onorúgame ku ajánaligo mayé. ");
INSERT INTO tacNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","'Liko Esúsika rukele: ―'Émika ¿chieri koriágó ne'chí? Pégroka anile: ―Mueka pe alué Kristo ju. ");
INSERT INTO tacNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","'Lige alué Esúsika 'we a'lá ruyele alué makué oká rió napurigá ta'wesi ruyémala. ");
INSERT INTO tacNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","'Lige anele Esusi alué makué oká rió: ―Ne napu julárigame ju Onorúgamete 'pa rewagáchika napurigá rió neraga 'we resí ikimela ne. 'We gawélimala ne'chí alué e'wélala ralámuli jurío nulame abiena alué e'wélala balé, abiena alué ralámuli napu benírame ju alué nulalí napu a'rele 'we 'ya alué Moisesi. 'Lige arigá 'ma me'liboa ne, pe bakiá rawé mukugá bo'mé ne 'lige Onorúgame ku ajánirimala ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","A'lige pe nujubapi Esusi anele alué makué oká rió: ―Alué ne'chí oyérinilime, nabí rawé e'wámili ju napu ne nulá, 'lige 'ma a'rémili ju chátiri 'nátili 'nata. Alueka 'la sébali machigá asimeli júkuru tabilé majaga rekó ralámuli 'ma me'linálichi ne'chí oyérame kóriká. 'Lige senibí rawé 'la oyérimili júkuru ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Alué rió majame mukugá ne'chí oyériga, alueka tase rewimela semati raweli. Alué rió napu ne'chí oyérame ju 'lige bilé rawé mukusá, alueka 'la semati raweli rewimela rewagachi. ");
INSERT INTO tacNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Churigá 'la nímalawé rekó bilé rió 'we a'lá nígame ke peka 'la 'nátame rió ke pe chibi 'sika eyéname ke? ");
INSERT INTO tacNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","'Lige bilé rió 'we chijúname ne'chí oyériga mayega 'we cha anéwali ko uché jaré ralámulite ne'chí oyérame kóriká, 'liko ne napu nawágame ju 'pa rewagáchika napurigá rió neraga chijunámalachigó alué rió 'yuga napu'lige ne ku nawasa wa'lú ra'ósili noligá, niga alué a'walí ne bo'né O'nola nila, abiena alué santo ánjeli a'walila niga. ");
INSERT INTO tacNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Jaré 'emi napu jena mochí jipe, bajchabé ta'chó suwiyá 'la machimela churigá nulame ko Onorúgame ―regá anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ye ra'íchali ruisá, osánó rawé kachi nerágirigá a'kinana, Esusi simile bilénami re'pá rabó Onorúgame 'yuga ra'ichamia alué bakiá rió 'yuga, Pegro, Santiago, 'lige Juani. ");
INSERT INTO tacNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","'Lige bijí Onorúgame 'yuga ra'icha iligá alué Esusi, se'winati gayénale bo'né banalá, abiena o'páchala, 'we rojsákame gayénale, 'we rapame. ");
INSERT INTO tacNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","'Lige yati neraga jsile oká rió alé napu 'we 'ya ejperégame nile ta'chó ajtígachi Esusi, 'lige Esusi 'yuga ra'íchale. 'Lige bilé nile Moisesi, 'lige uché bilélaka Elíasi. ");
INSERT INTO tacNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","'Lige alé noligá 'we ra'ósaga ilíbale. 'Lige alé ra'íchale o'maka churigá mukimeo Esusi alé we'ká riógachi Rusaleni pe a'kinana. ");
INSERT INTO tacNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","'Lige alué Pegro 'lige okánika alué gompaniérola okoka bi'tile 'lige yati bujsale, 'lige etele 'we ra'ósiga iligó noligá napu jale alué bakiá rió. ");
INSERT INTO tacNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","'Lige alué Moisesi 'lige Elíasi 'ma simiba e'yénigichi alé Esusi ilígachi, Pégroka anele alué Esusi: ―Mué nulame, 'láchigo jena napuítuke'é ramué. 'Lige newawa bakiá galí rojsate, bilé mué Esusi nila, uché bilé Moisesi nila, 'lige uché bilé Elíasi nila. 'Lige alué Pégroka tabilé machigá, pe ra'íchaga alarigá anile. ");
INSERT INTO tacNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","'Lige bijí ra'icha jágichi, re'kínale bilé nolí 'lige 'ma na'pólale suwábaga alué usani rió. 'Lige 'we majale alué Esúsite benírilime nolite na'pólisa. ");
INSERT INTO tacNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","'Lige anile bilé ra'íchali alé nolírale regá anime: ―Ye Esusi ne Inolá ju napu ne nóchali 'ya, 'we a'lá e'wiwa 'emi bakiá rió ye rió nulachi. ");
INSERT INTO tacNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Alué ra'íchali ma'chí anisá, pe a'lige yati neraga alué bakiá rió etele Esusi bi'neli ilígame. 'Lige alué bakiá rioka tase 'wesi ruyele tabilé 'cho mukuchi ka alué Esusi alakíligo alemi. ");
INSERT INTO tacNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Melénala rawé ku e'tegínele alé rabókana, 'lige we'ká ralámuli simíbale najtepamia alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","'Lige bilé rió anile alemi we'ká ralámuli jágichi nasípami iligá a'wágame ra'íchaga: ―Muérigo Benírame, pe rekó na'temaki ne inolá re'malí, pe ye bi'lepi inógame ju ne. ");
INSERT INTO tacNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Alué u'tabela remónisite cha'piame ju ye re'malí alawala, abiena ronowégame chu'ega bo'írame ju. 'We resí olasa, ku a'reme ju. ");
INSERT INTO tacNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Neka 'ma nulugé mué 'yuga benime napurigá ma'chí pámala alué u'tabela remónisi, 'lige tabiléchigo umébalekó. ");
INSERT INTO tacNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","'Lige Esúsika regá anile: ―'Emi ralámuli cha nokame tabilé bijchígime, chiéniko si asimélaché ne 'emi 'yuga napurigá 'la bijchígamala 'emi. Jeka o'tó mué inolá. ");
INSERT INTO tacNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Napu'lige alué re'malí o'nola alé sekachí cha'pigá o'tochi alé Esusi ilígachi alué re'malí, 'lige alué remónisi u'tabela yati wijchí rekábale alué re'malí, 'lige bo'írale ronobútiga chu'ala. 'Lige Esúsika ne'óchale alué remónisi u'tabela, 'lige ma'chí pale. 'Lige ku o'nola 'yuga júlale. ");
INSERT INTO tacNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","'Lige suwábaga ralámuli napu ekí etele, 'we ra'sálále etesa alachilú a'walí nígame ko Onorúgame. Napu'lige suwábaga alué ralámuli 'we ra'sálagá mochígichi etesa Esusi ma'chí pachi alué u'tabela remónisi, 'liko Esúsika anele alué makué oká rió aba alué bo'né Esúsite benírilime: ");
INSERT INTO tacNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―'We a'lá 'nátaga gepusi ye ra'íchali, tase siné we'kuawa: Ne napu nawágame ju 'pa rewagáchika napurigá rió neraga, bilé rawé o'toboli ju ne alé sairúgame mochígichi. ");
INSERT INTO tacNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","'Lige alué makué oká rioka tase námale alieti olagá anió Esusi, napugiti bo'né abalarigá ra'íchaligame napurigá ta námamala, 'lige alué ralámuli Esúsite benírilimeka majale rukegá napurigá abé a'lá ruwimela alieti olagá anió Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","'Lige alué makué oká rió chojkile ra'icha a'bopi abé najtékame nínilia bilé. ");
INSERT INTO tacNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","'Lige alué Esúsika machile alieti 'nata jago alué ralámuli, 'liko bilé towí bayele 'lige alé a'bé elale. ");
INSERT INTO tacNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","'Lige anele alué ralámuli: ―'Emi a'lá na'temaka etéeme nísaká ye towí napu ne 'we a'lá na'temaka eté 'liko 'la ne'chí nirame nímala 'emi. 'Lige ne'chí niráká 'emi, 'liko 'la nirame ju 'emi Onorúgame. Alué a'lá na'temaka eteme suwábaga ralámuli, alué nímala abé najtékame Onorúgame níriga. ");
INSERT INTO tacNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","'Liko Juánika anele alué Esusi: ―Mué Wa'lula, ramueka eteru bilé rió u'kuchípala remónisi buyánachi napurigá buyáname ju mué. 'Lige alué rió regá anigá buyáname ju alué u'kuchípala remónisi: «Esusi a'walila gite 'la buyasa 'la képá muechi alué u'kuchípala remónisi.» 'Lige ramueka suliru, alueka pecha lisensia nígame kame napurigá ralámuli 'yoga einámala, pecha ramué 'yuga eyéname ka alué rió. ");
INSERT INTO tacNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","'Liko alué Esúsika anele: ―Tase suliwa alué rió. Alué tase sairúgame ju ramué 'yuga, alueka ramué gompaniérola ju. ");
INSERT INTO tacNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Napu'lige 'ma sébachi raweli Esusi ku rewagachi moinámichi, 'we 'la iwega a'lá bi'lepi 'nátaga simile Esusi alé Rusaleni. ");
INSERT INTO tacNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Alé boichimi enegá júlale jaré rió bajchá alé bilénami ralámuli samaritano ejperélachi 'yániliga galí okola. 'Lige alué ralámulika yati simíbale bajchá galí 'yamia alé samaritano ejperélachi. ");
INSERT INTO tacNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","'Lige alué ralámuli samaritánoka tase 'yale galí napurigá alemi gojchimela alué Esusi 'lige alué 'yuga e'yénigime napugiti machíligame alué Esusi Rusaleni simiá enáligo. ");
INSERT INTO tacNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","'Liko alué oká rió Esúsite benírilime, Santiago 'lige Juani, anele alué Esusi: ―Mué Wa'lula, ¿ta najkí mué napurigá nulawa napurigá bilé na'í 'pa rewagáchikana re'kínamala napurigá suwábaga rajimela alué ralámuli alé riógame napurigá 'sile alué 'ya ajtígame rió Elíasi rewégame napu ruwime nílige napu anele Onorúgame? ");
INSERT INTO tacNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","'Lige alué Esúsika e'nele alué oká rió, 'lige ne'óchale regá anigá: ―¿Chonigá e'kósiniliché 'émika alué ralámuli? ");
INSERT INTO tacNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Alésíko simíbale uché bilena riógachi. ");
INSERT INTO tacNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","'Lige boichimi e'yéniga alué ralámuli, najtépale bilé rió 'lige anele alué Esusi: ―Mué Wa'lula, neka 'we a'lá sébali oyérinili mué. ");
INSERT INTO tacNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","'Lige Esúsika regá nejele: ―Geyóchika nígame júkuru resó, 'lige chulugika 'la ra'sógame júkuru. Ne napu nawágame ju 'pa rewagáchika napurigá rió neraga, neka tabilé asé galégame ju napurigá gojchimela ne. 'Lige mueka 'la siminálirí, mué bo'né ma'chíleké. ");
INSERT INTO tacNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Esusi anele uché bilé rió: ―Nabá ne'chí 'yuga ne'chí oyériga. 'Liko alué rioka anile: ―Mué Wa'lula, pe'wera buwé ne'chí, ne o'nola mukúgame tomia simé ne bajchá. ");
INSERT INTO tacNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","'Lige Esúsika regá anele: ―Nulewa alué tase oyérame Onorúgame napurigá tómala alué mué o'nola mukúgame. Mueka simiboa 'nalina we'kaná ichúrimi ralámuli ruyemia churigá ka napu'lige 'ma 'la sébali ikisá napu najkí Onorúgame jena wijchimoba. ");
INSERT INTO tacNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","'Lige anile uchéchigo bilé rió: ―Mué Wa'lula, néchigó abiena siminali mué 'yuga. Iligá pe'wera buwéwago ne galírale ro'ísa'é ruyemia galírale mochígame. ");
INSERT INTO tacNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","'Lige Esúsika anele: ―Alué bilé rió asará chujkúgame, 'lige ku guwana e'nasia ename, alueka tase wajchígame asarámala. ");
INSERT INTO tacNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pe nujubapi Esusi wanápale gicháosa makué miná oká rió, 'lige júlale bajchabemi pe okacho neraga i'wana chojkégame. Júlale alemi we'kaná riógachi napu simírimili nílige alué Esusi. Tabilé júlale si alué makué oká rió bo'né benírame. ");
INSERT INTO tacNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Regá anegá júlale: ―'We we'lé ju ri'ligó echerúgime, 'lige alué 'wime ka 'we u'kabi ju. Alekeri alué echerúgime nígame anewa napurigá julámala 'wíniliga uché jaré 'wime. ");
INSERT INTO tacNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","'Lige anele: ―Simíbaga 'emi okacho neraga. Neka jula 'emi napu mochí 'we jobátigame ralámuli napurigá u'kuchí bo'á a'tanala alé napu olí e'yéname ju. ");
INSERT INTO tacNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tase o'ká simawa sibula go'ame ra'kólime, aminami tase enomí ra'kola, 'lige tabilé pabega aká nujubami akarálime. Aminami tase jábawa boichimi ralámuli 'yuga we'lisi ra'icha. Pe bi'lepi 'nátaga e'yénawa pe benírilimecho ralámuli Onorúgame nila ra'íchali. ");
INSERT INTO tacNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","› Napu'lige seba bilena galírale, repóriwa alué ralámuli regá anegá: «Onorúgamete 'la 'yásiga 'la ke 'emi semati raweli jena galírale.» ");
INSERT INTO tacNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Alé galírale 'we ganíliga ejperélasa alué ralámuli, 'liko abéchigo ganíliga ejperélamala Onorúgame nila ra'íchali akisá. Ta ganíliga ejperégame nísaká 'liko abé tabilé ganíliga ejtebímala tabilé 'la nirasa Onorúgame nila ra'íchali. ");
INSERT INTO tacNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","'La bi'lénapi galírale okópua alé bilena we'ká riógachi, tase ichúrimi galírale okópua alé. 'Lige go'poa go'ame napu koni alué ralámuli alé riógame, napugiti nóchameka go'ame meka nóchame kame. ");
INSERT INTO tacNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","› Bilena riógachi sébachi 'emi, 'la ganíliga etésiga 'emi alé, 'lige go'ame kógisiga, yati go'poa alué go'ame tabilé gawéliga. ");
INSERT INTO tacNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Abiena 'la sa'wawa ralámuli nayume alé galírale riógame, 'lige anewa: «'Ma sébapá raweli napu 'la sébali ikimeli nílige jena wijchimoba napurigá najkí Onorúgame.» ");
INSERT INTO tacNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","'Lige 'emi sebasa alé bilena riógachi 'lige tase galegá etésiga 'emi, yati sawewa alué we'é ralachí chujkíbigame napurigá suwábaga ralámuli etémala 'lige regá aniboa: ");
INSERT INTO tacNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","«Ye we'é napu chujkiba ramué ralálachi jemi 'emi ejperélachi, 'ma sawilí ramueka. Yeka ruwime ju 'ma tabilé cheri kame nírigo ramué 'emi si. 'Lige Onorúgame 'ma tabilé gu'írimala 'emi. 'La machigá mochiwa 'ma sébigo alué raweli napu'lige Onorúgame nulámili nile jena napu 'emi ejperé, 'émika tabiléchigo najkígó napurigá nulámala.» Alarigá anesa 'liko yati simawa 'minami uché bilena riógachi. ");
INSERT INTO tacNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Neka 'la ruwíbá napu'lige seba alué gastigo alé riógachi napu tabilé ganíliga etéliru 'emi, alué gastígoká uchéchigo rajpé abé a'wágame nimio me'tagá alué napu Soroma sébale napu 'we cha nokame ralámuli riole 'we 'ya. ");
INSERT INTO tacNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","› Resía alué ralámuli Korasini ejperégame. Resía alué ralámuli Betsaira ejperégame. 'We a'lá semáriga sa'wagéturu ne alé ejperégame ralámuli Onorúgame a'walílate napu tabilé 'wesi ralámuli gayéname ju alarigá sa'wá, 'lige 'emi abirigá tabilé a'réturu alué resítiri nóchali. 'Lige ne a'chigóriga semáriga gu'írisa alé Tiro ejperégame ralámuli 'lige Sironi rewégachi napu ejperé alué cha nokame ralámuli, alueka o'pachátimikuru o'pacha 'we chajótigame 'lige mochíbimikuru bilena najpisochi napurigá machimela ralámuli 'ma ku guwana 'nátame ko. Alué ralámulika ya 'ma 'la Onorúgame oyérame nímikuru. Alué Korasini ejperégame 'lige alué Betsaira ejperégame etiáturu semáriga nejkúrichi ne 'lige tabilé ku guwana 'nátaturu. ");
INSERT INTO tacNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Napu'lige seba raweli gastigo narémichi alué ralámuli Korasini ejperégame 'lige alué Betsáira ejperégame, a'lige rawé alué ralámuli uchérajpé a'wágame gastigo narémala me'tigá alué Tiro ejperégame 'lige Sironi ejperégame. ");
INSERT INTO tacNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","'Lige alué ralámuli Kapernaumi ejperégame 'we gunarume, 'we a'ká ralámuli ko lame a'boi 'lige mayeme o'toboli ko alé 'pa rewagachi, iligá 'lúpili ju 'légana Remónisi bejtélachi ―anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","'Lige anele alué ralámuli alemi jágame makué gichao miná oká: ―Napu 'la bijchigi 'emi ra'ichálila, alueka 'la ne'chí oyérame nímala napugiti 'emi ra'ichálila ka, alueka kame napu ne 'ya 'emi. Alué napu tabilé 'la nirá 'emi ra'ichálila, alueka pe tabilé 'la nirame kérélamala ne ra'ichálila. 'Lige alué ralámuli tabilé 'la nirame ne'chí, alueka tabilé 'la nirame júchigó Onorúgame napu ne'chí júlale. ");
INSERT INTO tacNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","'Lige ku sebasa alué gicháosa makué miná oká rió, 'we ra'sálagá sébale, regá anesia Esusi: ―Mué Wa'lula, alué remónisi u'kuchípala 'we a'lá e'wí ramué mué a'walila gite. ");
INSERT INTO tacNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Esúsika anele: ―Ne 'la etiátigó alué wa'lula Remónisi 'pákana rewagáchikana pasichi Onorúgamete. ");
INSERT INTO tacNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Neka wa'lú a'walí 'ya 'emi napurigá tajché olawa alué sinowite 'lige alué majchílite napu'lige amóbami re'keka simárochi 'emi, 'lige napurigá ta umérowa 'emi Remónisite. ");
INSERT INTO tacNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","'Lige 'emi tabilé ra'sáláwa umérome kóriká remónisi u'kuchípala, iligá 'we ra'sáláwa 'nalina napugiti 'émi rewalá 'ma uchuchárigame kame alé Onorúgame nila apélichi alé rewagachi. ");
INSERT INTO tacNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","A'lígirikáchi Esusi 'we ra'sálále alué Onorúgame Alawala gite, 'lige anile: ―Mué Onorúgame 'pa rewagachi ajtígame abiena jena wijchimoba, neka 'we ra'sálagá ajtí etega 'we a'lá semáriga gu'írichi mué ralámuli jena wijchimoba ejperégame. Mueka 'la 'ya 'nátili suwábaga 'la kilí ralámuli napurigá 'la ma'chígime námamala churigá nejkúrime ka mué Onorúgame jena wijchimoba, alué 'nátili napu tabilé 'yale mué alué 'we jebénigame ralámuli, alarigá najkíligame mué bo'né O'nó ―alarigá anele Esusi alué Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","'Lige regá anile aminami: ―Ne O'nola suwábaga 'ya ne'chí nóchali, 'nátili, 'lige a'walí. Tase 'wesi machí chieri ko Onorúgame Inolá napu ne ju, pe ne O'nola Onorúgame 'la machí, 'lige ta'wesi machí chieri ka ne O'nola Onorúgame, pe bo'né Inolaka 'la machí, pe neka 'la machí. 'Lige 'la machimélachigó alué ralámuli napu ekí 'la najkí ne napurigá machimela. ");
INSERT INTO tacNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","'Lige e'nele alué makué oká rió bo'né benírame, 'lige anele: ―'We ganíliga mochí alué ralámuli napu etémala napu 'emi etiá 'we a'lá semáriga 'yochi ne, 'la semáriga benírachi ne, 'lige 'la semáriga gu'írichi ralámuli ne. ");
INSERT INTO tacNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","'Lige alué 'ya mochígame napu ruwime nílige napu anélige Onorúgame 'we eténelie 'we a'lá semáriga 'yochi ne, 'we a'lá semáriga benírachi ne 'lige 'we a'lá semáriga gu'írichi ne ralámuli, abiena alué e'wélala nulame rey eténelie ye napu etiá 'emi, tabiléchigo etélekó. Abiena akinálile ye napu 'emi aké, tabiléchigo akéleko. ");
INSERT INTO tacNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","'Lige bilé rió ra'íchali benírame, alué ra'íchali napu a'rele Moisesi 'we 'ya, simile a'bé Esusi 'yuga ra'ichamia rukemia pe machináliga churigáriga anirá pala pe'tá chajkena nejiara, 'lige regá rukele: ―Mué Benírame, ¿chu'símala ne napurigá 'la moinámala ne 'pa rewagachi? ");
INSERT INTO tacNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Esúsika regá rukele: ―¿Churigá anígó alué ra'íchali napu a'rele Moisesi? ¿Churigá námogo mué? ");
INSERT INTO tacNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Alué rioka regá nejele: ―Regá aníché alué ra'íchalika: «'We a'lá nirawa Onorúgame 'la bi'lepi 'nátaga. 'We a'lá niraga etewa apiépiri uché jaré ralámuli napurigá nirá mué bo'nepi.» ");
INSERT INTO tacNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","'Liko Esúsika regá anele: ―'We a'lá sébali nejé mué. 'We 'la sébali olásaká mué napurigá aní mué, a'liko 'la moinámala mué rewagachi. ");
INSERT INTO tacNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","'Lige alué rió ra'íchali benírameka alué ra'íchali napu a'rele Moisesi 'we 'ya, napurigá a'lá rió neraga regá rukele chonirá Esusi, pala pe'tá chajkena nejiara: ―¿Chieri ju alué uché jaré ralámuli napu 'la niraga etémili ju ne? ");
INSERT INTO tacNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","'Liko Esúsika anele: ―Bilé rió enale re'kínasia go'nágana alé Rusaleni 'yéniga Jerikó simea. 'Lige jaré rió chigórigame najtépale boichimi, 'lige 'ma chigóliru suwábaga tábiri 'ma o'páchatiri, abiena 'we wejpisosa a'réliru, amulí mukume a'réliru. ");
INSERT INTO tacNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","'Lige bilé rió balé enale alemi boichimi 'lige etesa pe chajkena simírole. ");
INSERT INTO tacNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","'Lige uché bilé rió alué wa'lú re'obá tebume Onorúgame galila enale alemi boichimi, 'lige etesa alué rió abiena chajkena simírole. ");
INSERT INTO tacNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","'Lige uché bilé rió enale alemi boichimi Samaria bejtégame, alué rioka bulito 'mékame nile, alué rioka 'la na'temale etesa alemi bo'ígichi alué rió. ");
INSERT INTO tacNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","'Lige a'bé nawile alué rió, 'lige 'yole chi'wágichi, ujchele yowí, abiena bulele ba'nisólite. 'Lige alé re'pá bulítochi ajchale, 'lige o'tole alé bilena galírale galí gojchiame ilígachi, 'lige alé repule. ");
INSERT INTO tacNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","'Lige melénala be'á alué rió samaritano 'ma simea, najtétile oká enomí alué rió galí nígame, 'lige anele: «'La tebúpua ye rió, 'lige wikagá rejpísaká ye rió, kuka simíriga najtétimala ne.» ");
INSERT INTO tacNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Esúsika 'ma suwénasa ye ra'íchali ruyá, rukele: ―¿Chieri alué bakiá rió abé na'temaka etélekobá? ");
INSERT INTO tacNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","'Lige alué rió Moisesi a'rélala ra'íchali benírameka anile: ―Alué rióguru napu 'yole alué rió. 'Lige alué Esúsika anele: ―Muéchigó 'we na'temápua suwábaga ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Regá anisá Esusi uchéchigo abichilubi 'we simile bowesia 'lige sébale alé bilena pe'kabi riógachi. 'Lige sébale alé galírale Marta bejtélachi, 'lige Mártaka 'la ganíliga repórale Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Alué Marta binégame nile María rewégame. 'Lige alué Maríaka yati a'bé asíbale Esusi ra'ichálila gepumia. ");
INSERT INTO tacNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","'Lige alué Mártaka, ta'mé ikiá níliga tabilé nejkúrachi alué binila go'ame newilichi, 'lige a'bé nawile Esusi 'lige anele: ―Mué Esusi bi'neli neyúriga wa'lula, ¿tabilé chélá mué rekó ne binila tabilé gu'írie ne'chí go'ame newalichi? Pe rekó nulérigó napurigá gu'írimala ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Alué Esúsika nejele: ―Mué Marta, mueka pe we'ká go'ámecho newalime 'nata jipe kulipi rekó ne jena ajtígichi. ");
INSERT INTO tacNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","'Lige jipe kulipi abé a'lá ju pe bi'lepi 'nátili, abé a'lá ju ne ra'ichálila gepulia 'emi níriga, 'lige Maríaka pe alué 'nátili pe ne'chí gepugímecho cha'pile, 'lige tabilé 'wesi bujémala alué 'nátili ne'chí gepugime. ");
INSERT INTO tacNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sinéchigo alué Esusi Onorúgame 'yuga ra'icha ilile alé bilena, 'lige suwénasa, bilé alué bo'né benírame anele: ―Mué Wa'lula, ramué beniri churigá ra'icháliame ka Onorúgame 'yuga napurigá Juani benírale alué bo'né benírame, alué Juani ralámuli rewarame ba'wichí jáwaga. ");
INSERT INTO tacNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","'Lige Esúsika anele: ―Napu'lige Onorúgame 'yuga ra'icha ka, regá anibóaguru: Mué O'nó 'pa rewagachi ajtígame. Ramué najkiáke'é napurigá 'we a'lá nirawa mué suwábaga ralámulite. 'We yati nulasa 'la kékuru mué jena wijchimoba. ");
INSERT INTO tacNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","'La sébali 'yawa go'ame ramué jipe rawé. ");
INSERT INTO tacNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","E'kawa ramué suwábaga chátiri 'nátili, ramueka abiena 'la e'kálime kame alué resí nokogá járome ralámuli resí olagá ramué. Tase a'rewa ramué napurigá rujsúpua alé napu nerú chátiri 'nátili, iligá gu'íriwa ramué. ");
INSERT INTO tacNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","'Lige regá anile bilé alué bo'né benírame 'yuga ra'icha: ―Mué bilé rió machime nisa, 'lige mué bejtélachi sebasa nasipa rukó 'lige anésiga mué ma'chika iligá: «Muérigo gompaniero, pe rekó anáchaga ne'chí 'yárigó bakiá baní, ");
INSERT INTO tacNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","alué bilé machirume sébake'é alé ne bejtélachi, 'lige tase nike ne baní napurigá kógimala.» ");
INSERT INTO tacNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","'Lige mueka tabilé regá nejiámala alé pachaka galírale: «Tase nejkumewa mué, 'ma 'yériga ilí jena yochi, 'lige ne 'kúchila 'we okoka bi'tí jena yochi ne'chí 'yuga a'bé yochi. Tase cherigá umubámala ne i'pua yochi.» Tabilé regá nejiámala mué. ");
INSERT INTO tacNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Abirigá asísimala mué 'yamia go'ame alué rió alemi ilígame go'ame taa napugiti pe alarigá nokame kame ralámuli jemi, napurigá tabilé se'winá lámala alué nawágame go'ame táame 'lige uché jaré ralámuli. Asísamala mué regá 'nátaga: «Resía ye rió, 'yama ne baní.» Bilena galírale 'yériga ilisá yochi, e'wérali olawa napurigá i'púmala yochi alué pachá mochígame ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","› Onorúgame senibí 'la 'yámala semati raweli napu abé 'la nirá bo'né. Alekeri abichilubi tániwa Onorúgame semati raweli, 'liko Onorúgameka nejímala semati raweli. 'Yáawa 'emi 'lige abiena 'la rewimela 'emi. Napu'lige tabilé 'la semáriga simichi bilé nóchali, tániwa Onorúgame 'lige alué nejímala 'nátili churigá nochátiká napugiti alué kame ramué O'nola. Apiépiri rió napu 'la tánime ju iwérali Onorúgame, alueka 'la narémala iwérali. ");
INSERT INTO tacNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","› Mué inógame nisa, 'lige alué mué inolá remé táachi, ¿'lacha rejté 'yámalawé mué? 'Lige bilé ro'chí táachi mué inolá, ¿'lacha sinowí 'yámalawé mué? ");
INSERT INTO tacNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","'Lige bilé ga'wá táachi mué inolá, ¿'lacha majchili 'yámalawé mué? ");
INSERT INTO tacNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mué rió 'we resí 'sime ke, 'la bi'wígame go'ame 'yame ju mué bo'né inolá, 'lige alué Wa'lula Onorúgame 'pa rewagachi ajtígame, alueka abéchigo semáriga 'yámala alué bo'né alawala alué ralámuli napu taní Onorúgame Alawala. ");
INSERT INTO tacNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Esúsika bilé rawé ma'chí pa ilile u'tabela remónisi alé bilé riochi ajtígame napu tase ra'íchame newale. Napu'lige alué chátiri Remónisi 'ma ma'chínasa alé riochi, alué rioka yati ku ra'íchale. 'Lige jaré ralámulika 'we ra'sálále 'la ku ra'íchame gainasa. ");
INSERT INTO tacNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","'Lige uché jaré ralámulika tabilé galele, 'lige anile: ―Ye rioka alué wa'lula remónisi Belsebú gompaniérola ju alekeri 'la buyáname ju remónisi u'kuchípala. ");
INSERT INTO tacNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","'Lige jaré ralámuli anele Esusi pe gawéliga 'lige umériniliga: ―Aka re'kibúbá bilé na'í 'pa rewigáchika 'la Onorúgame nila a'walí ajchágame níriká. ");
INSERT INTO tacNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","'Lige bo'né Esúsika 'la machile chátiri 'nátaga anió alué ralámuli, 'lige anele: ―Bilena gawichí 'ma pe na'áwasa ralámuli, pe 'ma suwimela a'bopi nakoga. Alué ralámuli bilena galichi riógame na'áwasa a'bopi, pe na'áuka ejperélamala. ");
INSERT INTO tacNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","'Lige alué wa'lula remónisi sairasa u'kuchípala remónisi, 'ma bi'neli rejpímala alué wa'lula remónisi. 'Lige neka alarigá ruwíguru, 'émika cha cha aniame, 'émika aníguru ma'chí buyáname ko ne alué chátiri u'kuchípala remónisi alué wa'lula remónisi Belsebú a'walílate. ");
INSERT INTO tacNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ne alué Belsebú gompaniérola nísaká, ¿'lacha buinámapué ne alué u'kuchípala remónisi ralámulichi pachágana mochígame? 'Emi 'yuga nóchame 'la buyáname ju alué remónisi u'kuchípala Onorúgame gite, a'lígeko 'emi abiena 'la machí buyáname ko ne u'kuchípala remónisi Onorúgame gite, pe iligá tabilé 'la ma'chígime ruwíguru 'emi. ");
INSERT INTO tacNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","'Lige neka 'la bijchiá alué Onorúgame a'walílate buyáname júkuru alué chátiri remónisi u'kuchípala. Yeka ruyame ju Onorúgame 'ma nulao jena napu 'emi mochí. ");
INSERT INTO tacNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","› Napu'lige bilé rió 'we a'wágame 'we a'lá siparínaga asisá, 'lige 'we a'lá semáriga repuka asimela bo'né galila. Alué we'ká tábiri alé nerúgame tase che ikimela. ");
INSERT INTO tacNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","'Lige sebasa uché bilé 'lige abé a'wágame nílasa me'tagá alué rió 'we a'lá siparínagame, 'lige alueka 'ma umérimala, 'lige 'ma bujémala alué siparina napu mayele alué rió alué siparina gite tabilé 'wesi chigomio, 'lige 'ma bujémala suwábaga tábiri 'lige 'ma nachutámala alué gompaniérola alué tábiri. ");
INSERT INTO tacNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","› Alué napu ta ne'chí gu'írame ju, alueka pe ne'chí sairúgame ju. Alué napu tabilé gu'írame ju ne'chí ralámuli repua, alueka pe chátiri 'nátili ruigá eyéname ju ralámuli napurigá tabilé oyéramala ne'chí. Esusi abichilubi regá anele: ");
INSERT INTO tacNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","―Alué bilé u'tabela remónisi ma'chínasa alé bilé riochi, eyéname ju jami gawichí wakígichi 'yaga bilena resíbulime, 'lige tase asé rewisá alemi resíbulime 'liko 'nátame ju: «Ku simé ne napu ajtigé ne 'yabé siné.» ");
INSERT INTO tacNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","'Lige ku sebasa napu bejtélige, rewame ju 'we a'lá pechítigame. ");
INSERT INTO tacNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","'Lige simime ju uché jaré gichao u'kuchípala remónisi bayemia abéchigo chátiri, 'lige suwábaga mo'ime ju ejperélimia alé riochi. 'Liko alué rió abéchigo cha 'sime gayéname ju me'tigá 'ya bajchá rawé napu'lige pe bi'lepi u'tabela remónisi ajtígachi. ");
INSERT INTO tacNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Napu'lige alué Esusi bijí ruyá ilígachi ye ra'íchali, bilé mukí alemi we'ká ralámuli jágichi a'wágame ra'íchale regá anigá: ―¡'We a'lá ganíliga ajtí alué mukí napu ju mué eyela napu mué ochéririle 'lige napu chi'íririle mué! ");
INSERT INTO tacNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","'Liko Esúsika anile: ―Abé a'lá ganíliga ejperé alué ralámuli napu 'la námaka akeme ju abiena 'la e'wame napurigá nulá Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Alué ralámulika aminacho we'ká napuíle alé noligá napu Esusi ilile, 'liko Esúsika regá anile: ―Ralámuli jipe ejperégameká 'we chátiri 'nátame ju, alué ralámulika aniá aníguru: «Aka re'kibúbá bilé na'í 'pa rewigáchika 'la Onorúgame nila a'walí ajchágame níriká.» Neka 'wéchigo 'la ma'chígime ruimélagó alué napurigá 'sile alué Jonasi 'we 'ya ajtígame napu ruwime nile napu anele Onorúgame: ");
INSERT INTO tacNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Alueka ne'óchale alué Nínibe ejperégame ralámuli. 'Lige a'chigóriga olámalachigó ne jipe ejperégame ralámuli, ne'ochámala ne alué ralámuli, ne napu nawágame ju 'pa rewagáchika napurigá rió neraga. 'Emi níriká 'ma tabilé nulétékuru ne'chí napurigá re'kibúmala ne na'í 'pa rewagáchika, pe 'la e'wátékuru napu nulá ne. ");
INSERT INTO tacNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Napu'lige sebasa raweli gastigo narémichi jipe ejperégame, 'lige alué wa'lula nulame mukí napu 'we 'ya bejtégame nile 'mimi o'iná 'tumi rayénali bokuíchi e'negá iliruga ku ajánamala a'lige rawé, 'lige ne'ochámala 'emi ralámuli. Alué mukika napu'lige bijí ajagá asagá, 'we mejkaka nawálekuru gepumia alué Salomoni nila rejcholi 'we benegá ra'íchame, 'lige jipe jena ajtíkuru ne napu abéchigo benegá ra'íchame ju me'tigá alué Salomoni, 'lige 'émika tabilé gepúnili ne nila ra'íchali. ");
INSERT INTO tacNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Alué ralámuli napu ejperégame nile alé Nínibe rewégachi abiena ku ajánamala a'lige rawé gastigo narémichi jipe ejperégame ralámuli 'lige ne'ochawa 'emi alué mukite, napugiti alué ralámuli Nínibe ejperégame 'la ku guwana 'nátaligame napu'lige Jonasi ruyele Onorúgame nila rejcholi. 'Lige jena ajtí ne napu abéchigo benegá ra'íchame ju me'tagá Jonasi 'lige 'emi tase a'rénili resítiri 'nátili. Esusi abiena anele: ");
INSERT INTO tacNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","―Tase 'wesi ralámuli rajeme ju bilé chojpé nasoka elamia, iligá 'we a'lá re'pá ma'chí elame ju napurigá 'la ma'chílimala ralámuli alemi mo'igá. ");
INSERT INTO tacNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","35","Aminami napu'lige bilé rió rajesa bilé chojpé, 'lige 'we a'lá ma'chílame nisa, 'la ma'chílimala. Tabilé 'la ma'chílame nísaká, tabilé 'la ma'chílimala rekó 'la rajériga ilígichi chojpé. ");
INSERT INTO tacNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mué 'la sébali 'nátaga inásaká, 'lige tabilé chátiri 'nátame nisa mué, alarigáká nímala napurigá bilena 'la ma'chigá ilígachi chojpé rajachi rukó. ");
INSERT INTO tacNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Napu'lige alué Esusi a'resa ra'icha, 'lige bilé rió bariseo bayérale galírale go'ame go'achi. 'Lige Esúsika yati oyérale, 'lige bajkile alé pachá galírale 'lige asíbale alé a'bé mésachi, alué mesa 'we re'lé ilígame gayena bo'igá go'yame. ");
INSERT INTO tacNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","'Lige alué rió bariséoka se'winá lale etesa tabilé panígisa go'yachi alué Esusi napurigá nokame nile a'boi napurigá 'we a'lá oyéranti neraga Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","'Lige alué Esúsika anele: ―'Emi ralámuli bariseo pe ma'chíminachó pagome ju bejtoli 'lige pacháganaka tabilé pagome ju napu'lige Onorúgame kogia go'ame napurigá 'la najtékame nímala Onorúgame níriga. 'Émika 'la semáriga panígisa go'yame ju napurigá 'we a'lá semáriga oyérame Onorúgame nobi pacháganaka 'wéchigo chátiri alawégame kéré ko 'emi. ");
INSERT INTO tacNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡'La churikanti 'emi ralámuli! 'Émika ¿tacha machíbeché alué Onorúgame newáligo 'emi sa'pala abiena alué 'emi alawala? ");
INSERT INTO tacNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","'We 'la semáriga gu'írinilisaká 'emi alué tabilé nígame bajchá 'la bi'wígame 'nátame niwa. 'La bi'wígame 'nátame nísaká 'emi 'liko 'la semáriga gu'írimala 'emi apiépiri ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","› Resía 'emi ralámuli bariseo, 'la senibí 'la kógime ju 'emi go'ame alué Onorúgame, nobi tase 'la sébali olame júkó 'emi ralámuli 'yuga, aminami tase 'la sébali nirame ju 'emi Onorúgame. 'La ju kógilia Onorúgame nobi abiena tabiléchigo a'réwagó nirá alué Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","› Resía 'emi ralámuli bariseo, 'émika pe rióchaga mochime ju alé mutélachi alé napu mochime ju alué e'wélala alé u'kuchí re'obachi «sinagoga» rewégame, aminami najkime ju 'emi napurigá 'we a'lá niraga repóriwa uché jaré ralámulite alemi nasípami we'ká rioga ilígichi. ");
INSERT INTO tacNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","› Resía 'emi, 'émika ju pe napurigá bilena suwígame bi'tígichi 'we tabilé ma'chiná bi'tígame 'lige ralámuli amóbami e'yéname ju tabilé machigá alemi bi'tigó alué suwígame tótiga. ");
INSERT INTO tacNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","'Liko bilé rió alué ra'íchali benírame napu Moisesi benírale ralámuli nejele regá anigá: ―Mué Esusi ralámuli benírame, mué alarigá ne'óchaga alué bariseo, pe 'ma ramué 'yúriga ne'óchame ke aní mué, ramué napu rejcholi benírilime niru ralámuli alué ra'íchali rejcholi napu Moisesi ralámuli benírale 'we 'ya. ");
INSERT INTO tacNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","'Lige Esúsika regá anele: ―Resía 'emi ralámuli ra'íchali benírame napu Moisesi benírale ralámuli 'we 'ya, 'emi we'ká e'karúgame nóchali nuleme ju alué ralámuli, 'lige 'émika tabilé pe'tá gu'írame júkuru. ");
INSERT INTO tacNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","› Resía 'emi ralámuli, 'emi ralámulika pe galírame ju amoba napu bi'tí alué 'ya suwígame ralámuli napu ruwime nílige napu Onorúgame anélige napu me'ale alué ralámuli 'ya ejperégame 'emi rijimala. ");
INSERT INTO tacNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","'Lige 'emi ralámuli abalaké nóchali oyérame júkuru, chátiri nóchali napu nóchale 'emi rijimala 'ya riógame. ");
INSERT INTO tacNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","› Alekeri Onorúgame bo'né 'la machigá alakimeo a'kinana regá anile: «Julámala ne, ne napu ju Onorúgame, jaré rió ne nila ra'íchali ruyeme ralámuli 'lige jaré rió ne nila nóchali nulame, 'lige jaré 'ma me'liboa cha nokame ralámulite, jaré najátaga cha'piboli nímala», regá anile Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Abichilubi 'we ra'íchale Esusi regá: ―'Lige alué ralámuli jipe ejperégame Onorúgameka wa'lú gastigo 'yámala. Alueka tabilé me'ale alué 'ya mochígame ralámuli napu ruwime nílige napu anélige Onorúgame, Onorúgameka abirigáchigo gastigárimalagó napugiti a'chigóriga cha resí nokagá járome kámechigó napurigá alué rijimala 'we 'ya ejperégame. Alué 'we 'ya ejperégame ralámuli cha olale, me'ale Onorúgame nila ra'íchali benírame ralámuli 'we 'ya ejperégame, ");
INSERT INTO tacNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","napu'lige pe kulí bilé rió me'líliru Abeli rewégame 'ya ajtígame, 'lige abé guwichí a'kinana Sakaríasi me'líliru napu me'líliru alé wa'lú re'obá ilígichi, Onorúgame galílachi ma'chímana a'mulipi napu ilile tegoli mesa napu kógime nile go'ame ajágame Onorúgame alué ralámuli. 'Lige alekeri 'la ruwí ne, alué Onorúgameka 'emi ralámuli jipe ejperégame gastigárimio suwigóriká alué 'ya ejperégame ralámuli Onorúgame nila ra'íchali rejcholi benírame ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","› Resía 'emi ralámuli benírame ra'íchali rejcholi napu Moisesi benírale ralámuli 'we 'ya, tabilé sébali olame ju 'emi napurigá aní ra'íchali napu Moisesi benírale ralámuli, aminami tase elime ju 'emi napurigá sébali olámala alué uché jaré ralámuli napu 'la sébali olánilime ju. ");
INSERT INTO tacNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Napu'lige Esusi ruyesa ye ra'íchali, alué ralámuli ra'íchali rejcholi benírame napu Moisesi benírale ralámuli 'we 'ya abiena alué ralámuli bariseo, 'we ayole Esusi 'yuga 'lige we'ká e'karúgame ra'íchali rukele, ");
INSERT INTO tacNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","machináliga pala 'la sébali nejiara, 'lige se'wináriga nejiásaká nejínaliga nokale. ");
INSERT INTO tacNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","'Lige we'ká mili ralámuli napuíle alé napu ilile Esusi, rajchiní járole cha we'ká níligame. 'Lige Esúsika chojkile ra'icha alué bo'né benírame 'yuga. Regá anele: ―'La 'nátaga mochiwa 'emi, alué bariséoka 'we semáriga ra'íchame ju, tabiléchigo 'la sébali olame kéré ko. Tase alarigá nokiboa 'émichigó, ");
INSERT INTO tacNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","napugiti abirigá machiboli kame a'kinana rekó nasoka se'wináriga nokisá 'emi, ");
INSERT INTO tacNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","alekeri rekó 'emi ra'íchalige jami chonárale jaga, abiena akimeli ju ralámuli alué ra'íchali melénala rawé. 'Lige suwábaga napu 'emi ra'íchalige nasoka 'yériga mochiga pachá galírale a'bé najkachí, uché jaré ralámulika asíriga a'wágame ra'ichámala napu nasoka ra'íchale 'emi. Aminami regá anélechigó: ");
INSERT INTO tacNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","―'Emi ruyé ne ye ra'íchali ralámuli ne'chí 'yuga e'yéname: tase majaga járowa 'emi alué ralámuli me'ame. ");
INSERT INTO tacNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Neka 'la ruwimela chieri 'nalina 'la majátiká. Majawa 'nalina Onorúgame, alué napu nígame ju wa'lú a'walí napurigá me'limela 'lige napurigá 'lúmala 'emi alé 'légana na'ichí. Alueka 'la 'we majawa. ");
INSERT INTO tacNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","› 'Émika tabilé najtegachi ralinéame ju alué u'kuchí maligi chulugí, pe oká pésochi ralineme ju 'emi, nobi Onorúgameka 'wéchigo a'lá repuka ajtíkó alué maligi u'kuchí chulugí. ");
INSERT INTO tacNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Abiena alué gupá 'emi mo'ólachi jágame, Onorúgameka 'la sébali tétega ajtí a'pílipi alué gupá. Tase majawa 'emi, 'émika uché rajpé najtékame ju me'tagá alué we'ká u'kuchí chulugí. Abiena anele Esusi: ");
INSERT INTO tacNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","―Alué rió tase chijúnaga ruyeme alué uché jaré ralámuli ne'chí oyérame ko, 'lige ne napu nawágame ju 'pa rewagáchika napurigá rió neraga, abiena 'la semáriga ruyémala ne alué we'ká santo ánjeli ne'chí oyérame ko alué rió. ");
INSERT INTO tacNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","'Lige bilé alué rió tabilé ne'chí oyérame korisá, 'liko ne ruyémala alué we'ká santo ánjeli tabilé ne'chí oyérame ko alué rió. ");
INSERT INTO tacNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","› Apiépiri rió se'winá anesa ne'chí, ne napu nawágame ju 'pa rewagáchika napurigá rió neraga, alué rioka aba'lá e'káwili ju Onorúgamete 'la e'kali tánisaká Onorúgame. Bilé rió enáriga ra'íchame alué Onorúgame Alawala olagá, alueka tase siné e'káwili ju Onorúgamete rekó 'we tachi e'kali. ");
INSERT INTO tacNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","› Napu'lige 'emi o'tosuga alé u'tá re'obachi «sinagoga» rewégame, siné kachi o'tosuga 'ma 'emi alé napu ra'íchali gatélachi ju, 'lige 'émika tase we'ká na'tawa alarigáriga animea, ");
INSERT INTO tacNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","'emi sebasa alé, alué Onorúgame Alawala 'we a'lá semáriga gu'írimala 'emi churigáriga ra'ichátiká 'emi níriga. ");
INSERT INTO tacNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","'Lige bilé rió alemi nasípami we'ká napuíka jágichi alemi iligá anele alué Esusi: ―Mué Esusi ralámuli benírame, nulewa alué ne ba'chila napurigá ne'chí 'yámala alué napu ne nachuámili ju napu ne o'nola nila nile. ");
INSERT INTO tacNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","'Liko Esúsika regá anele: ―Mué rió, ¿chieri 'ya ko ne'chí nóchali napurigá ne ra'íchali gateme nímala, rojáname alué tábiri? ");
INSERT INTO tacNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Aminami Esusi anile: ―'We a'lá 'nátaga, tase najkiboa alué we'ká tábiri. Rekó bilé rió we'ká tábiri nígame ke, alué we'ká tábiri ka tase nejkúrimala Onorúgame oyérilichi. ");
INSERT INTO tacNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","'Lige aminami regá anele: ―Bejtele bilé rió we'lé echame bo'né gawílachi, 'lige alué go'ame napu echale 'we rakele. ");
INSERT INTO tacNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","'Lige alué rioka 'nátale: «¿Cholama ne jipe alakí go'ame?» lale. «Tase níkuru ne wa'lú rekoa alé gatélime alakí go'ame.» ");
INSERT INTO tacNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","'Lige arigá regá 'nátale: «Gajunámala ne ye rekoa, 'lige bilé abé wa'lú rekoa newámala ne. 'Lige alé gatémala ne ye go'ame, abiena alué uché jaré we'ká tábiri.» ");
INSERT INTO tacNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","'Lige lámala ne bo'nepi: «Jípeko we'ká go'ame iní ne gatérigime we'ká bamí go'yáame. A'rema ne echá pe'kabi bamí, 'we ganíliga bejtémala ne, abiena 'we bajía asimé ne.» ");
INSERT INTO tacNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","› 'Lige alué Onorúgameka anele: «Mué rió tase 'la 'nátame, rekó we'ká 'wige mué go'ame, jipe rukó mukumela mué rió. Alué we'ká go'ame napu mué 'wile, alueka ¿chieri niga rejpímala 'lige?» ");
INSERT INTO tacNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","› Pe alarigá ikime ju alué rió napu we'ká tábiri niga asinálime ju bo'né bi'neli, 'lige ta'mé 'la oyérame ju Onorúgame, pee suériga oyérame ju. ");
INSERT INTO tacNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Pe nujubapi Esusi anele alué bo'né benírame: ―Neka 'la ruwí: Tase pe go'ámecho mélime na'tawa jena wijchimoba ejperega, aminami tase pe o'páchacho najkiboa. ");
INSERT INTO tacNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Pe alarigá na'tálika tabilé 'la ju, iligá Onorúgame 'yuga 'we a'lá sébali na'tálime ju 'nalina. ");
INSERT INTO tacNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Aka alué golachi ta siné echame ke, senibí go'yame ká'é go'ame napugiti Onorúgame 'we a'lá gu'írame kame. ¡'Émika abé najtékame ju Onorúgame níriga me'tagá alué golachi! ");
INSERT INTO tacNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Rekó 'we re'pá jágame gainánilie 'emi, tase uché rajpé re'pá jágame gainámala 'emi. ");
INSERT INTO tacNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tabilé aminabi ochérame nísaká bilé rió pe napu echilú ju, 'liko ¿chonigá cha lámala? 'Lige aminami ¿chonigá 'we cha lámala tabilé nígariká go'ame, enomí 'lige galí, 'lige e'karúgame tabiri tábiri? ");
INSERT INTO tacNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","› Aka 'we 'la 'nátaga e'nésibá Sempuali jami jágame aka chiena 'la semáriga o'chérame ká'é. Tase siné nóchame ju nibilé sume ju o'pacha, nobi 'wéchigo semáriga jame júkó sewagá. Alué wa'lula selígame Salomoni rekó 'we semati o'pachátame ke tabiléchigo aliena semati go anaga alué Sempuali jami jágame. ");
INSERT INTO tacNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Onorúgameka pe gajsalá kachi 'la semáriga nesérome ká'é, alué gajsalá napu pe jami jame ju jipe, alué napu pe 'ma na'yáwili ju bilé rawé. 'La tabilé machinti 'emi abéchigo 'la semáriga gu'íriwili ko 'emi Onorúgamete. ");
INSERT INTO tacNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Alekeri 'emi tase na'tawa pe go'ámecho. ");
INSERT INTO tacNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Alué ralámuli jemi wijchimoba ejperégame pe alieti 'nátaga ejperégame ju. Onorúgameka napu 'emi oyérame ju 'la sébali machí 'emi alieti resí laa mochigo. ");
INSERT INTO tacNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","'Émika tase alarigá 'nátaga e'yénawa, abichilubi 'la sébali machigá mochiwa churigá nulame ka Onorúgame, 'lige suwábaga 'we a'lá sébali nejímala Onorúgame resí lasa 'emi bilé tábiri. Abiena anílechigó Esusi: ");
INSERT INTO tacNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","―Tase majawa 'emi napu ne 'we a'lá semáriga repú. Rekó pe u'kabi ke 'emi, Onorúgame 'emi O'nola 'we a'lá semáriga ganíliga ajtí bo'né a'walila 'yamia 'emi. ");
INSERT INTO tacNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ralinewa 'emi napu ekí tábiri nílige, 'lige kógiwa alué enomí napu resí lame ju. 'La sébali olawa napurigá najkí bo'né Onorúgame, alarigaka 'la 'yawa 'emi semati raweli Onorúgamete 'lige tabilé 'wésite bujewa 'emi alué semati raweli. ");
INSERT INTO tacNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Suwábaga tábiri napu ni 'emi, pe aluecho 'la repugime 'nátame ju 'emi, tabilé 'la nélegá Onorúgame bilé rió pe we'ká umugí 'yuga gojchiame 'nátame nisa, alueka tabilé 'la nirame ju Onorúgame. Abiena anile Esusi: ");
INSERT INTO tacNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","―'La 'nátaga mochiwa alué Onorúgamete julárigame nawachi. ");
INSERT INTO tacNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Niwa napurigá jaré rió nóchame napu buigá mochime ju bilé rió wa'lula napu eyena kóliga alé newíkime nerúgichi, napu yati i'pume ju yochi kuka nawachi. ");
INSERT INTO tacNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","'We ra'sálagá etéwili ju alué ralámuli rukó nóchame galí repume 'la tase gojchigá mochime rukó, 'la e'negá mochime buigá alué wa'lula, na'igá napusí seba, rekó alué wa'lula nawachi nasipa rukó che'láchimi kómá. 'Lige alué wa'lúlaka 'we ra'sálagá etémala, 'lige mochiámala alé mésachi go'ame kógimia. 'Lige alué wa'lula anémala «Neka 'we ra'sálá. 'Emi tabilé okole rekó 'we we'liko rukó sébachi ne.» ");
INSERT INTO tacNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","› Aka gepúsibá: Bilé rió galí nígame 'la machisá aliéniko nawamia alué chigórigame alé galírale, 'liko e'negá asimeli júkuru napurigá alué chigórigame ta i'púmala alué galí tábiri chigomia. ");
INSERT INTO tacNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","'Lige a'chigóriga 'emi 'la 'nátaga mochíwachigó. Bilé rawé tase sanátiga nolínamala ne napu nawágame ju 'pa rewagáchika napurigá rió neraga. ");
INSERT INTO tacNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","'Liko Pégroka rukele: ―Mué Wa'lula, ¿chieri 'nalina ruigá aní mué ye ra'íchali? ¿Pe ramuecho, suwábaga chalá? ");
INSERT INTO tacNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","'Liko rukele alué Esusi: ―¿Chieri kárékobá alué bilé rió wa'lubela nóchalichi nulame 'la sébali olame? ¿Pala alué rió kárékobá napu galí nígame a'reme ju repúniliga alué galí napurigá kógimala go'ame alué ralámuli nóchame 'la sébali alé, 'la tase 'cho 'we charigá e'lowichi alué ralámuli? ");
INSERT INTO tacNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","'We 'la ra'sálagá etéwili ju alué rió alué galí nígamete alué rió 'la semáriga nóchaga ajtígame alé galírale napu'lige ku nawachi alué galí nígame. ");
INSERT INTO tacNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","'Liko alué galí nígame nulémala napurigá nulame nímala 'lige repume napu ekí tábiri nerú alé. ");
INSERT INTO tacNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pe iligá tabilé 'la sébali olame nísaká alué rió galí tebua ajtígame mayesa we'liko sebamio alué galí nígame, 'lige chojkiasa resí olá alué nóchame abiena alué umugí alé galírale nóchame, aminami chojkiasa go'ame go'yá napu tabilé go'meli nílige abiena chokiasa bajía rekuka, ");
INSERT INTO tacNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","'lige alué galí nígame ku alé nawasa tase sayétiga alué galí tebua ajtígame, sebasa napu'lige tase buigá ajtígichi pe bajía i'wilí ba'wila rekútame, alésíko alué galí nígame wa'lú gastigo 'we chátiri 'yámala, 'lige 'ma o'tomela alé napu mochí alué uché jaré ralámuli tase 'la sébali olame. ");
INSERT INTO tacNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","› Bilé rió nóchame 'we machime nisa alarigá najkió alué wa'lula 'lige tase sébali olasa, aminami tase e'wasa, 'liko wa'lú gastigo 'yáwili ju 'we wejpisoka. ");
INSERT INTO tacNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","'Lige bilé rió nóchame ta machigá 'sílasa 'lige chati nochasa, alueka ta'mé we'sá wejpisópili ju gastigo 'yaa. Bilé rió wa'lú nóchali 'yárigame Onorúgamete, 'la sébali nochámili ju ralámuli 'yuga. Alué rió 'la niraga etélime, alueka 'we owigime nímala. Abiena anile Esusi: ");
INSERT INTO tacNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","―Neka nawákuru na'áwali o'inamia jena 'emi ralámuli ejperélachi. ");
INSERT INTO tacNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","'Lige neka siné rawé resí nílimili júkuru mukiá. Najkí ne napurigá yati alarigá ikimela. ");
INSERT INTO tacNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿'Lacha mayé 'emi ralámuli ne nawáligo ra'mamia 'emi ralámuli jena wijchimoba nakoga ejperégame? Neka ruwí tase ra'mamia nawagó. Neka iligá nawákuru sairárimia. ");
INSERT INTO tacNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Jipe si aminako maligi ralámuli riógame bilena galírale, bakiá alué ralámuli alué uché jarela oká ralámuli sayégame nímala. ");
INSERT INTO tacNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Alué o'nólaka bo'né 'kúchila ejtemali sairámala. Alué eyélaka alué ranala tewé sairámala. Alué wasirúgameka mo'lila sairámala. ");
INSERT INTO tacNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Alésíko alué Esusi alué we'ká ralámuli 'yuga ra'íchale, regá anele: ―'Emi ralámuli etesa alué nolí o'wichi alé tuaka, 'lige 'la machime ju 'emi u'kumeo, 'lige 'la bijchiá u'kume ju. ");
INSERT INTO tacNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Napu'lige ekachi o'inaka rayénali bokuíchi e'negá iliruga, 'la machime ju 'emi rajtálimio. ");
INSERT INTO tacNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Rekó 'émika 'la machime ke chiéniko u'kumeo 'lige chiéniko rajtálimio, 'lige ¿chonigá ta machíché 'emi alarigá ikimeo nujubami rawé rekó 'la etee ne'chí nochálila 'lige rekó 'la akéeme ke ne ra'ichálila? Abiena anile Esusi: ");
INSERT INTO tacNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","―¿Chonigá ta gateme júkó 'emi a'boi alué na'áwali? ");
INSERT INTO tacNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Bilé riote nejísiga mué alé wa'lúlachi, 'lige simiboa alué rió 'yuga, 'lige ta'chó sebalia alé napu ajtí alué wa'lula, gatewa alué na'áwali waná 'emi napurigá ta sebawa alé napu ajtí alué wa'lula. Alé sebásiká, alué wa'lúlaka nulémala alué sontalo galírale bajchániliga mué. Alésíko alé galírale bajchawa mué. ");
INSERT INTO tacNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","'Lige neka 'la ruwí we'ká rawé asimeo mué alé galírale 'lige 'ma suwábaga najtétisa mué a'lige kulí ma'chínimio mué alé galírale bajcháriga asagá. ");
INSERT INTO tacNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Pe aba'lige yati ruyele jaré ralámuli alué Esusi ye ra'íchali: ―Kulí me'lílirigará jaré rió jena Galilea ejperégame alé wa'lú re'obá ilígachi alé Rusaleni napu ajágame me'lisá jale alé ra'pichí Onorúgame kógimia. Alué wa'lula selígame Pilato rewégame nulálegara alué ralámuli me'líniliga. ");
INSERT INTO tacNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","'Lige alué Esúsika rukele: ―Aka 'we a'lá na'tásibá 'emi, ¿mayé 'emi me'lílirigo alué we'ká rió galileo 'we resí nokame kóriká me'tagá alué uché jaré rió galileo? ");
INSERT INTO tacNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","'Lige anile pe aba alué bo'né Esusi: ―Tabilé, pe a'chigóriga resí nokame nile suwábaga. 'Lige 'emi ralámuli tase ku guwana na'tasa alué 'nátili 'lige resí ikimela 'émichigó. ");
INSERT INTO tacNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","'Lige uchéchigo rukele: ―¿'La bijchiá mayé 'emi ralámuli wa'lú gastigo nígame níligo alué makué osánó ralámuli napu suwile alé Siloé alué re'pá ilígame galite me'táchaga, me'tagá alué uché jaré pe abalé Rusaleni ejperégame? 'Lige anele: ");
INSERT INTO tacNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","―Tabilé, pe a'chigóriga aliena resítiri chátiri alawégame nile suwábaga. 'Lige 'emi tase ku guwana na'tasa, resí ikimela 'émichigó. ");
INSERT INTO tacNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Aminami Esusi anele: ―Bilé rió echágame nile bilé chuná alé nasípami we'ká i'wilí jágichi. 'Lige simile e'nemia pala rakega iligá, 'lige tase rakega ilile. ");
INSERT INTO tacNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","'Liko anele alué rió napu repume nile alemi echerúgime: «Neka 'ma bakiá bamí nawáguru jena e'nemia ye chuná pala rakega iligá, 'lige tasiné rakéguru ye chuná. 'Ma me'teka pápua, pe nejkumea ilí jena i'wilí jágichi.» ");
INSERT INTO tacNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","› 'Lige alué echerúgime repúmeka regá anile: «Mué wa'lula, pe a'réwa'é bijí ye bamicho. 'Lige ne we'pínamala alué we'é alé chojkirá 'lige wa'lú bo'ita ajchémala ne. ");
INSERT INTO tacNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Alarigá siné kachi 'la rakésabá, 'lige jipe bamí ta rakésaká 'ma me'tépua.» ");
INSERT INTO tacNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sinéchigo rawé resíbulichi, alué Esusi Onorúgame ra'ichálila beniria ilile ralámuli bilena u'tá re'obachi «sinagoga» rewégame, ");
INSERT INTO tacNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","'lige asale alé bilé mukí 'ma makué osánó bamí nayume. Wa'lú rumúligame nile rejpopa alué mukí. Alarigá a'réliru bilé u'tabela remónisite. Alué mukika tase gayéname nile wajchía, rojpóchaga oyame nile. ");
INSERT INTO tacNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","'Lige alué Esusi etesa, bayele 'lige nochale rejpopa 'lige anele: ―Mué mukí, jípeko ya 'ma sa'wí mué alué nayulí napu nayume nile mué. ");
INSERT INTO tacNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","A'lige alué mukika pe yati 'la wajchile, 'ma 'la sa'wile alésíko. 'Lige alué mukí chojkile wa'lú cheliera 'yaa Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","'Lige alué nulame alé u'tá re'obachi 'we ayole napugiti alué Esusi 'yóligame rawé resíbulichi. 'Lige alué nulame anele alué we'ká ralámuli: ―Nerú usani rawé napurigá 'yoboa, a'lige rawé 'yoboa, tase rawé resíbulichi ka. ");
INSERT INTO tacNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","'Liko Esúsika regá anele alué nulame: ―¡Tabilé sébali olame ju 'emi napurigá aní a'bopi! ¿Tacha su'páname ju 'emi alué roló alué bulito kómá rawé resíbulichi o'tomea ba'wí bajírimia? ");
INSERT INTO tacNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ye mukika Abraámi rijimala ju a'chigóriga napurigá niru ramué, 'lige nayua ajtíkuru ye mukí cha olásiga u'tabela remónisite, makué osánó bamí nayume júkuru. ¿'Lige tacha 'yówaché ye rawé resíbulichi? ");
INSERT INTO tacNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","'Lige alué Esusi regá anisá, 'lige suwábaga alué ralámuli Esusi saíla chijúniga ejtebile, 'lige alué ralámuli tabilé Esusi saílaka 'we ganíliga ejtebile asíriga ra'sálagá alué Esusi 'we a'lá sa'wasa alué mukí nayume. ");
INSERT INTO tacNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","19","'Lige anile Esusi: ―¿Churigá ruyésiga 'la nímalaché 'emi napurigá 'la námamala churigá ka napu'lige ralámuli 'la sébali olachi alué napu nulá Onorúgame? Bajchá bilé ralámuli benime ju Onorúgame ra'ichálila 'lige uché jaré ralámuli benírame ju, 'lige pe yati we'ká ralámuli 'la oyérame ju alué ra'íchali. Alué Onorúgame ra'ichálilaka napurigá alué a'lásini rakala, alarigá ju. 'We u'tá ju nobi 'wéchigo wa'lú ochérame ju me'tigá ri'ligó, 'lige chulugí alé jsime ju kábimia. › Ruwimé ne bilé ra'íchali: Bilé gajsalá rakala 'we u'tá ke 'lige alué gajsalá rakala ya'wisá wa'lú ochérame ju re'pá ilígame, 'lige alué chulugí jsime ju 'lige alé mochíbame ju. Alarigá júkuru Onorúgame nulachi jena wijchimoba. ");
INSERT INTO tacNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Abiena anile Esusi: ―¿Churigá ruyésiga 'la nímalaché napurigá 'la námamala 'emi churigá ka napu'lige ralámuli 'la sébali olachi Onorúgame ra'ichálila? ");
INSERT INTO tacNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Alueka ju napurigá alué kawali (lebarura) alué arina na'loasa bilé mukí. 'Lige bochígimi nabame ju alué kawali, 'lige 'la semáriga a'pome ju alué arina wejsótigame. Alué kawálika káréke'é bilé rió nawasa bilena riógichimi Onorúgame ra'ichálila benírimia 'lige pe i'kilimi aminacho we'ká ralámuli oyérame ju Onorúgame ra'ichálila. ");
INSERT INTO tacNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Alué Esusi enegá bowesia alé Rusaleni simiá, 'lige 'we benírisia enale Onorúgame nila ra'íchali rejcholi alemi we'kaná we'ká riógachi simíraga abiena pe u'kabi riógachimi. ");
INSERT INTO tacNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","'Lige bilé rió rukele: ―Mué Wa'lula, ¿pala pe u'kabi ju alué ralámuli napu moinámili ju rewagachi napu'lige suwisá? Esúsika anele: ");
INSERT INTO tacNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―'We e'wérali olawa napurigá mo'iboa alé u'tá yógame galichi. Neka ruwí we'ká ralámuli 'we mo'inálimio alé yochi 'lige tase gainamio mo'yá napugiti 'ma 'yériga ilimémpá alué galí. ");
INSERT INTO tacNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Alué rió galí nígame ilísiga 'yérisa 'yera 'lige 'emi ralámuli jaré ma'chika jaga regá animela: «Mué rió, i'pú yochi.» 'Lige alué galí nígameka animela: «Neka tase machí chieri ka 'emi.» ");
INSERT INTO tacNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","› 'Liko 'emi ralámuli regá animela: «Ramueka napuíka go'tuge go'ame, abiena mué ruigéturu semati rejcholi alemi ramué ejperélachi.» ");
INSERT INTO tacNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","› 'Lige alué rioka pachaka iligá animela: «Neka 'ma ruwí tase machiá chieri ka 'emi. ¡Ku simíbaga 'emi suwábaga chátiri resítiri nóchame!» ");
INSERT INTO tacNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","› 'Lige nalámala 'emi, abiena 'we chi'námala ramalá 'we ayoga etega alé pachá mochigo Abraámi, abiena Isaki abiena Akobo abiena alué we'ká rió napu ruwime nílige napu anélige Onorúgame, 'lige nalámala 'emi ma'chika a'résiga. ");
INSERT INTO tacNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Alé pachá mo'imela ralámuli, bochígimi mejkaka sígame mo'imela alé pachá. 'Lige alé pachá mochíbamala go'ame go'mea Onorúgame 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","We'ká alué ralámuli jurío napu bajchá akele alué Onorúgame ra'ichálila, alueka tabilé mo'imela alé pachá galichi. 'Lige we'ká alué ralámuli tabilé jurío napu akele abé nujubapi, alueka 'la mo'imela alé pachá galichi. ");
INSERT INTO tacNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Pe a'lige rawé sébale jaré bariseo, 'lige anele Esusi: ―Mué Esusi, 'másawa jena Galilea asagá, alué wa'lula selígame Erore me'linali mué. ");
INSERT INTO tacNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","'Lige alué Esúsika regá nejele: ―Simasi e'newa alué cha'sime rió napu pe majáriga mabúnili ne'chí, 'lige ruyewa jipe rawé 'lige be'lí ma'chí buinamio ne alué remónisi u'kuchípala, abiena sa'wamio ne alué nayúkame ralámuli, 'lige anuwí kulí suwénamio ne. ");
INSERT INTO tacNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","'Lige jipe raweka abiena 'we enámili júkuru ne bowesia Rusaleni simiá, ne napu ruwime ju napu ané Onorúgame alé Rusaleni mukumeli kame, tase uché bilena. ");
INSERT INTO tacNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","› ¡'Emi ralámuli Rusaleni ejperégame, me'ame ju alué ralámuli napu ruwime ju napu ané Onorúgame, 'lige aminami rejtete bajsibuga me'ame ju 'emi alué ralámuli napu Onorúgame júlale! Neka we'sá 'we napubúnilige 'emi napurigá bilé o'tolí ra'kome ju bo'né a'tanala, 'lige 'émika tasiné napuíkuru. ");
INSERT INTO tacNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","'Lige alekeri Onorúgame 'ma tabilé asimela 'emi 'yuga. 'Lige jípeko tabilé siné etewa ne napusí seba alué raweli napu'lige 'emi regá animela: «'We a'lá sébali nóchame ju alué wa'lú a'walí nígame napu Onorúgame neraga nawá.» ");
INSERT INTO tacNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Bilé rawé resíbulichi alué Esusi simile go'ame go'mea alé galírale bilé wa'lula bejtélachi bariseo selínala, 'lige uché jaré bariseo e'negá mochile e'negá chu'siá sita aleké resíbulichi rawé pe cha'pináliga. ");
INSERT INTO tacNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","'Lige alé a'bemi asale bilé rió bajíbichigime, 'we nayume. ");
INSERT INTO tacNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","'Lige alué Esúsika rukele alué ra'íchali benírame ra'íchali napu Moisesi benírale ralámuli, abiena alué bariseo alemi mochígame: ―¿Tacha 'la lisensia ju 'yólichi bilé rió nayume rawé resíbulichi? ");
INSERT INTO tacNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","'Lige alué ralámulika kilí mochile tase nejega. 'Liko Esúsika cha'pile alué nayume, 'lige sa'wale, 'lige kumi júlale. ");
INSERT INTO tacNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","'Lige Esúsika ra'íchale alué bariseo 'yuga 'lige alué benírame 'yuga, 'lige rukele: ―Bilé 'emi inolá wijchisá rawé resíbulichi, bilé roló kómá 'emi bujkula alé rejkolichi napu maníbame ju ba'wí bajílime i'pichí napu newalime niru ramué jena Israeli 'we rojkógachi, ¿tacha ku ma'chí pámala 'emi? ¿Abajáchala a'rémala 'emi? ");
INSERT INTO tacNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","'Lige alué ralámulika tabilé anigá ejtebile. ");
INSERT INTO tacNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Alué jaré ralámuli bayérigame alé alué bariseo bejtélachi go'achi, alueka alemi sigá yati mochíbale bajchami napu mochime nile alué ralámuli e'wélala. 'Lige alué Esúsika etesa alarigá nokachi, 'la ruyele bilé bariseo uché jarela akériga: ");
INSERT INTO tacNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Napu'lige mué bayésiga alé newigime nerúgichi, tase asibawa alé mutélachi alué abé 'la semáriga bayérigame ralámuli mochímichi 'we semáriga bayérigame kóriká bo'nepi. Sebasa alué rió abé 'la semáriga bayérigame alé mutélachi asibámala, ");
INSERT INTO tacNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","'lige alué repágame newigichi nolínamala regá anisia: «Pe rekó 'ya ye rió alué mutela napu mué ajtí.» 'Lige chijunámala mué ilísiga alé mutélachi, 'lige simela mué 'yamia uché bilé mutela napu mochime ju alué tabilé 'la semáriga bayérigame. ");
INSERT INTO tacNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Napu'lige bayésiga mué, 'lige sebasa mué alé newigime nerúgichi, iligá asibawa alé 'na guwánaka, 'lige alarigá alué napu repale regá animela: «Mueka asiboa 'mi bajchá napu mochímili ju abé 'la semáriga bayérigame.» Alé bajchámana ajchásiga mué, alarigá 'la machimela alué uché jaré ralámuli mué rió abé 'la semáriga bayérigame ko. ");
INSERT INTO tacNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Yeka aniame kérékuru alué rió napu mayeme ju 'we najtékame ka Onorúgame níriga, alueka pe tabilé najtékame kérélamio. Alué pe kilí rió, alué 'nalina nímio abé najtékame Onorúgame níriga. ");
INSERT INTO tacNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","'Lige Esusi abiena regá anele alué bariseo napu repale: ―Napu'lige go'ame kogia mué alué ralámuli, 'lige tase bayewa alué ralámuli mué gompaniérola, aminami tase bayewa mué ba'chila, mué go'chila, mué bonila, mué waíla, abiena tase bayewa mué rijimala, abiena tase bayewa alué ralámuli 'we nígame jemi a'mulipi riógame najkigá napurigá ku repámala a'kinana. ");
INSERT INTO tacNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Napu'lige go'ame newá mué go'mea we'ká ralámuli 'yuga, iligá bayéwaká alué ralámuli 'we resítiri tase nígame, 'lige alué tase gayéname e'yena, alué sujírigame, alué tase ma'chílime. ");
INSERT INTO tacNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","'Liko 'we ganíliga etewa mué alué ralámulite. Alueka tabilé siné rawé ku gu'línamala nibilé pe'tá go'ame, 'lige alarigá wa'lú raweli rewimela mué 'lige 'pa rewagachi moinámala mué napu'lige mukusá. ");
INSERT INTO tacNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Alué ye ra'íchali akisá alué alé mésachi mochígame, bilé rió napu asale alé anele alué Esusi: ―Asíriga ganílimala alué ralámuli napu'lige go'ame go'yá alé rewagachi Onorúgame nila go'ame. ");
INSERT INTO tacNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","'Liko Esúsika anele: ―Bilé rió nulale wa'lú go'ame newániliga. Bajchabé ta'chó newá go'ame we'ká ralámuli bayele napurigá go'ame go'mela. ");
INSERT INTO tacNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Napu'lige sebasa raweli go'ame go'mechi ralámuli bayérigame, 'ma gayéniga ilígichi alué go'ame, júlale bilé rió bo'né 'yuga nóchame bayéniliga alué ralámuli napurigá smela alé galírale go'ame go'mea. ");
INSERT INTO tacNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Alué ralámuli bailime ka tase ikíromoríle simiba go'ame go'mea. Alué bilé rió anile: «Ralá ne bilé wasá, 'lige simé olá ne e'nemia, tabilé ikírimala ne alemi simiá go'ame go'mea.» ");
INSERT INTO tacNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","'Lige uché bilé regá anile: «Ralá ne malígana chojkégame oisí asarame, 'lige asarama olá ne pala 'la asarara. Tabilé ikírime ne simiá.» ");
INSERT INTO tacNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","'Lige uché bilé rió regá anile: «'We kulí newíkame ju ne, tabilé ikírime ne simiá.» ");
INSERT INTO tacNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","'Lige alué rió nóchame ku sebasa, ruyele alué nulágame go'ame newániliga tabilé 'wesi jsnali. 'Liko alué nulágame 'we ayole, 'lige anile: «Jípeko uché bilena simiboa 'liko 'we sajpuka alemi napu mochí alué ralámuli 'we resítiri tabilé nígame 'lige alué sujírigame 'lige tase ma'chílime, jeka bayéwaká.» ");
INSERT INTO tacNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","'Lige pe abé alimi alué nóchame ku nawagá anile: «Mué rió, neka a'má sébali olá napurigá nulá mué, 'lige 'we u'kabi rewá ne ralámuli, 'lige go'ame ka 'we wa'lú ju.» ");
INSERT INTO tacNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","'Liko alué nulágame go'ame newániliga anele alué nóchame: «Uchéchigo simigá 'yawa uchérajpé ralámuli pe alemi we'kanami boichimi e'yénigime, 'lige 'la sébali napabuwa napu ekí najkí ne. ");
INSERT INTO tacNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","'Lige alué ralámulika 'la semáriga bayérigame tase jsíkuru napu bajchá baigé ne, jípesíko alué ralámuli tase siné go'mela go'ame jena ne bejtélachi» ―regá anile Esusi alé a'bé mésachi asagá. ");
INSERT INTO tacNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","We'ká ralámuli Esusi 'yuga e'yénale, 'lige Esúsika gu'lile 'lige anele alué we'ká ralámuli: ");
INSERT INTO tacNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Bilé rió, abé nirame nisa bo'né o'nola, bo'né eyela, bo'né upila, bo'né 'kúchila, bo'né ba'chila, bo'né go'chila, bo'né bonila, bo'né waíla, 'lige bo'nepi, me'tigá ne'chí, a'lígeko tabilé ne'chí oyérame nímala alué rió. ");
INSERT INTO tacNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tabilé resí ikinálasa alué rió ne'chí 'yuga eyenia, tabilé ne'chí oyérame nímala. ");
INSERT INTO tacNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","'Lige bilé rió wa'lú galí re'pá ilígame newánilisa, bajchako 'we a'lá e'némili júkuru alué rió chekí enomí sebátiká. ");
INSERT INTO tacNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","'Lige ta'lá sébali e'nesa 'lige chojkiasa newá galí, 'lige rokárélasa alué we'ká enomí, 'liko alué we'ká ralámuli etéeme gawélime ju alué rió. ");
INSERT INTO tacNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Anime ju: «Alué rioka pe chojkiasa, tase gayénale.» ");
INSERT INTO tacNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","'Lige anélechigó Esusi: ―Bilé rió wa'lula selígame rey tase nejkome ju bilé liá mili sontalo sayega makué mili gompaniéroga, senibí bajchá 'we a'lá 'nátame ju. ");
INSERT INTO tacNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","'Lige tase chérigá neyúrasa nílasa ka, 'liko ta'chó seba, júlame ju jaré rió ruyéniliga alué saíla tabilé nejkónilio. ");
INSERT INTO tacNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Bilé rió ne'chí oyérinilisa ka tase 'we chárigá najkime nímala suwábaga alué e'karúgame napu ekí tábiri ni. 'Lige 'we chárigá najkime nisa ka bilé rió alué we'ká tábiri, tase ne'chí oyérame nímala. Abiena anile Esusi: ");
INSERT INTO tacNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","―Onaka 'la ju napu'lige bijí ajkágame kachi. Alué oná 'ma najsuwisa, tase siné ku a'lá gainámala. ");
INSERT INTO tacNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Aminami tase go'mela ajágame, pe pápili ju alésíko. 'We a'lá 'nátaga gepusi ye ra'íchali. ");
INSERT INTO tacNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","We'ká rió enomí goblálome alué enomí napu nejílime nile alé wa'lúlachi. 'Lige abiena alué resí nokogá járome rió, alemi jsile gepumia alué Esusi ra'íchachi. ");
INSERT INTO tacNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","'Lige alué napu benírame nile ralámuli Moisesi nila ra'íchali, abiena alué bariseo napu jálechigó alemi, tase galele alué Esusi, a'bopi ra'íchaga regá anile: ―Ye rioka 'la galeme ju alué resí nokogá járome ralámuli 'lige 'yuga go'yame ju go'ame. ");
INSERT INTO tacNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","'Liko Esúsika anele: ");
INSERT INTO tacNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Bilé rió bujkégame nisa bilé siento bo'á, 'lige bilé bo'á we'kasa, ¿tacha yati simime ju 'yamia alué bilé we'kágame alé jami a'resa alué gi makuesa makué miná gi makué? Napusí rewisá a'reme ju 'yaa. ");
INSERT INTO tacNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","'Lige yati gujtámachi rekagá o'tome ju rewisá alué bo'á 'we ra'sálagá. ");
INSERT INTO tacNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","'Lige sebasa ku galírale, bayeme ju alué abé machirume abiena alué a'mulipi riógame, 'lige regá aneme ju: «Bilé bo'á we'káwige ne 'lige 'ma ku rewá ne alué bo'á we'kágame, 'lige 'we ra'sálagá eyena ne 'lige alekeri repari ne galírale go'ame go'achi», animela. ¿'Emi ta lonikiméréchigó? ");
INSERT INTO tacNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Alué Onorúgameka a'chigóriga ra'sálámala etega ku guwana 'nátachi bilé rió. 'Lige etega alué gi makuesa makué na gi makué ralámuli napu mayeme ju 'we a'ká ralámuli ko a'bopi, alué etega ka tase 'me alarigá ra'sálámala Onorúgame. Aminami anile Esusi: ");
INSERT INTO tacNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","―Abiena, bilé mukí makué enomígame enomí plata 'lige we'kawasa bilé alué enomí, ¿'lige tacha rajémalawé chopé 'yamia alué enomí 'lige arigá tacha 'ma pechímalawé 'yaga 'la kilí alé galírale napusí rewá si alué enomí? ");
INSERT INTO tacNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","'Lige rewisá alué enomí, alué abé machirume umugí 'lige alué uché jaré umugí alemi a'mulipi riógame regá anémala: «'We ra'sálá ne napugiti 'ma ku rewagame ne alué enomí napu we'káwage ne, 'lige alekeri repari ne galírale go'ame go'achi», regá anémala. ");
INSERT INTO tacNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Neka 'la ruwí, aliena semáriga ra'sálalí nerúlamio alé re'pá rewagachi napu mochí alué santo ánjeli Onorúgame 'yuga nóchame ku guwana na'tasa bilé rió resí 'sika ilírome. ");
INSERT INTO tacNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Esusi abiena regá anile: ―Bilé rió oká inógame nile. ");
INSERT INTO tacNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","'Lige alué abé u'tabela re'malí anele alué bo'né o'nola: «Ne'chí ya'má 'yawa alué we'ká tábiri napu ne nachuámili ju mué mukusá.» 'Liko o'nólaka 'ma rojánale, 'yale alué we'ká tábiri alué oká ejtemali. ");
INSERT INTO tacNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","'Lige pe u'kabi rawé kachi a'kinana, alué re'malí abé u'tabela 'ma re'wániga ralinele alué napu ekí tábiri nachule. Alésíko mejká simile uché bilena gawichí. Alé gawichí asagá 'ma suwábaga suwábale alué enomí, tabilé 'la repule. ");
INSERT INTO tacNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Napu'lige 'ma suwábaga suwábasa enomí alué re'malí, 'lige sébale raweli 'we resítiri, 'we gurule go'ame alé gawichí. ");
INSERT INTO tacNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Alésíko simile bilé rió e'nemia we'lé nígame gawí nóchali tánimia. 'Lige alué rió gawí nígame júlale gowí neséniliga na'minami bo'né nila wasachi. ");
INSERT INTO tacNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Alemi eyénaga gowí nesegá 'we e'lowile alué re'malí pe alué rojí go'ale napu gowí go'gá e'yénale. Ta'wesi ralámuli kógile go'ame alué re'malí. ");
INSERT INTO tacNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","› 'Liko regá 'nátale: «We'ká ralámuli ne o'nola 'yuga nóchame, alueka 'we ganíliga noká nocha tabilé e'lowika. ¡Neka jemi eyéniga 'ma amulí mukú e'lowika! ");
INSERT INTO tacNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Alekeri kumi simé ne ne o'nola bejtélachi, 'lige regá anémala ne: ‹‹Mué o'nó, neka 'we resí 'siá 'sile 'yabé napu'lige bijí mué 'yuga bejtega napu tabilé 'la ju Onorúgame níriga 'lige mué níriga. ");
INSERT INTO tacNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","'Ma tase napurigá mué inolá neraga etewa ne. Jípeko pe bilé rió mué 'yuga nóchame neraga etewa ne, alarigá anémala ne.›› ");
INSERT INTO tacNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","› A'liko kumi simile alué re'malí bo'né o'nola bejtélachi. › 'Lige bijí a'nabeka enágichi alué re'malí, alué bo'né o'nólaka etele, 'lige 'we na'temaka etele aleké re'malí. 'Lige 'male najtepamia, 'lige najtépaga gomuruka repórile. ");
INSERT INTO tacNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","'Lige alué re'malí regá anile: «Mué o'nó, jípeko chátiri alawégame ju ne. Neka 'we resí 'sile napu tabilé 'la ju Onorúgame níriga 'lige mué níriga 'lige uché jaré ralámuli níriga, alekeri 'ma tase napurigá mué inolá neraga etewa ne.» ");
INSERT INTO tacNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","› 'Lige alué re'malí o'nólaka anele alué bilé bo'né 'yuga nóchame: «'We sapuka ma'chí pápua o'pacha 'we a'lala, 'lige o'pachátiriwa ye re'malí, abiena ujchewa makúsachi alué bilé u'tá jiero chijtúligame 'we najteme. Abiena akáriwa. ");
INSERT INTO tacNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","'Lige abiena nolawa alué u'tá roló abé a'lá sa'pégame, 'lige me'liboa. 'Lige abiena wa'lú go'ame newasa ra'sálagá go'poa o'maka ramué. ");
INSERT INTO tacNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ye re'malika napurigá 'ma mukúgame neraga ke, jípeko 'ma napurigá ku ajánigame ju. 'Lige 'we chátiri 'nátame ke 'yabeko, jípeko 'ma ku guwana 'nátale. 'Lige napurigá we'kágame ke 'yabeko, jípeko napurigá ku rewurúgame ju napugiti 'ma ku nawagame», alarigá anile alué o'nola. Abichilubi ra'íchale Esusi: ");
INSERT INTO tacNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","―Alésíko chojkile alué wa'lú yawiyame. Alué re'malí ba'chílaka 'mimi epomi echégichi eyénale. 'Lige kuka seba a'nabeka enegá akele rabisime yawiyame. ");
INSERT INTO tacNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","'Liko bayele bilé alué rió nóchame 'lige rukele: «¿Tachiri gite rabisía mochí ralámuli alé galírale?» ");
INSERT INTO tacNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","'Lige alué nóchameka regá anele: «Alué mué bonila 'ma ku nawá, 'lige mué o'nola nulá me'línalia bilé roló ranala abé sa'pégame napurigá o'maka go'poa, napugiti a'lá nawagame tase nayume.» ");
INSERT INTO tacNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","› 'Lige alué re'malí ba'chílaka 'we ayole alarigá ruyésiga. Alésíko alué re'malí ba'chila tase sebánale alé galírale o'nola bejtélachi. 'Lige alué o'nólaka ma'chínale bayemia napurigá bajkimela pachá galírale. ");
INSERT INTO tacNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","'Lige alué re'malika anele alué o'nola: «Mué 'la sébali machí alakí bamí gu'iria ne mué. 'Lige neka senibí 'la e'weme ju mué, 'lige mueka tasiné nejime ju nibilé rekó pe bilé chibá u'tátiri kachi napurigá ne newámala bilé yawiyame ne gompaniérola 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","'Lige jípeko nawálekuru mué inolá napu mué nila enomí suwábaga suwábale umugí 'yuga eyénaga, 'lige alueka 'la me'líguru mué alué besero napu abé sa'pégame nile.» ");
INSERT INTO tacNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","› 'Lige anile alué o'nólaka: «Mué ne inolá, mueka senibí nejkúrime ju, 'lige suwábaga napu ne nígame ju mué nila ju.» ");
INSERT INTO tacNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Jípeko 'la ju newalía ye go'ame go'yame ra'sálagá napugiti mué bonila napurigá mukúgame níligame 'lige jípeko napurigá ku ajánagame ju. We'kálige we'ká rawé 'lige jipe napurigá rewurúgame ju. ");
INSERT INTO tacNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Alué Esusi abiena anele alué bo'né benírame: ―Bejtele bilé rió nochálichi nulame, alué rioka nile gu'írame bilé rió we'lé nígame gawí. 'Lige jaré alué nóchame simíbale ruyemia alué abé wa'lula echerúgime nígame regá: «Tabilé 'la nocha alué nóchalichi nulame.» ");
INSERT INTO tacNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","'Liko alué nóchali nígame bilé rió júlale bayéniliga alué nulame, 'lige 'ma nawasa alué nulame, anele: «Tabilé 'la nóchame kará mué. Jípeko 'ma ku nejiwa mué alué nóchali, 'ma suwábaga alué apeli 'yúriga. 'Ma tabilé nochámala mué ne 'yuga.» ");
INSERT INTO tacNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","› 'Lige alué nóchalichi nulámeka 'nátale regá: «Jípeko ¿tachiri nochámalaché ne bujésiga nóchali? Tase benégame ju ne bejtégame nóchaga, 'lige chijuna ne pe taga go'gá», alarigá 'nátale alué rió. ");
INSERT INTO tacNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","'Lige kúchigo regá 'nátale: «Pe regá olásiga 'la kéréko, napurigá ne 'la galewa bilena galírale napu'lige 'ma tabilé nocha ne, a'lige ta'chó suwábaga nejía ne ye apeli, i'pílipi bayémala ne alué ralámuli napu wikeme ju alué wa'lula nóchali nígame.» ");
INSERT INTO tacNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","› 'Lige bayesa alué bilé rió, rukele: «¿Chekí wiké mué alué wa'lula nóchali nígame?» ");
INSERT INTO tacNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","'Lige alué rioka regá nejele: «Bilé siento miná usánisa makué bote bilé liá litro chewame olibo rakala ba'wila wiké ne.» 'Liko anile alué rió nóchalichi nulame: «'La bijchiá ju, jena chujkú napu mué wiká, asíriga we'ká wiká mué. Alekeri gu'írimala ne mué, pe nasípasi najtétimala mué, pe osá nosa makué bote olibo rakala ba'wila, 'lige pe alakí ujchawa jena apélichi mué bo'né.» ");
INSERT INTO tacNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","› 'Lige uché bilé rukele: «Mueka ¿chekí wikégó alué wa'lula nóchali nígame?» 'Lige alué rió rukilime ka regá nejele: «Neka bilé siento gostali ri'ligó wikáre'é.» 'Liko anile alué rió nóchalichi nulame: «'La bijchiá ju, jena chujkú napu mué wiká, asíriga we'ká wiká mué, alekeri gu'írimala ne mué, pe osá nosa makué gostali ri'ligó najtétimala mué, 'lige pe alakí ujchawa jena apélichi mué bo'né.» ");
INSERT INTO tacNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","› 'Lige alué echerúgime nígameka anile alué nulame 'we rejchirúgame níligo pe u'kabi gobláligo alué wikame ralámuli. › Apiépiri rió chati nóchame 'we rejchirúgame ju a'boi nochálilachi nóchaga. 'Lige Esusi abiena regá anile: ");
INSERT INTO tacNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","―Neka 'la ruwí: 'We 'la semáriga gu'írowa ralámuli kógiga we'ká e'karúgame tábiri napu iní 'emi jena wijchimoba napurigá we'ká gompaniérogame nímala 'emi, 'lige napurigá Onorúgame nejímala napu tabilé siné suwíbame ju napu'lige 'ma suwibasa suwábaga alué e'karúgame tábiri. ");
INSERT INTO tacNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","› Bilé rió pee nígame nisa, 'lige 'we gu'írame nisa ralámuli, a'lígeko abé we'ká tábiri nígame nisa 'la we'ká ralámuli gu'írimala. 'Lige pee nígame nisa 'lige tabilé gu'írame nisa ralámuli, a'kinana rekó we'ká tábiri nígame ke, tabilé gu'írimala ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","'Lige alué rió tabilé 'la semáriga uneme nisa alué we'ká tábiri napu iní jena wijchimoba, a'lígeko churigá 'la semáriga uneme nímalawé alué Onorúgame nila semátiri 'nátili. ");
INSERT INTO tacNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","'Lige tabilé 'la repume nisa alué tábiri uché jaré ralámuli nila, alésíko 'ma tabilé 'yawa Onorúgamete alué tábiri napu 'yáwali nílige napurigá bo'né niga neraga asimela. ");
INSERT INTO tacNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","› Alué bilé rió nóchame tase a'lá nochámala oká rió nóchali nígame 'yuga, napugiti alué rió nóchame tase galémili ju bilé alué nóchali nígame. Pe bi'lepi 'la sébali e'wímala. Yeka regá ruwime kéré: Tase 'we najkiboa pe enomicho 'lige we'ká tábiri napu ni 'emi, iligá 'we a'lá oyérawa Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Alué ralámuli bariseo pe enomicho najkime, aké mochile alarigá ra'íchachi alué Esusi, 'lige 'we gawélele i'kirú anigá. ");
INSERT INTO tacNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","'Liko Esúsika regá anele: ―'Emi ralámulika 'la a'ká ralámuli korime ju a'bopi, nobi Onorúgameka 'wéchigo a'lá machígó 'emi alarigá 'nátame ko. Ralámuli 'nátachi 'we a'lá ko a'bopi 'lige 'we najtékame korisá a'bopi, Onorúgameka 'we gichime ju alué ralámuli na'tálila. ");
INSERT INTO tacNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","› 'We 'ya ta'chó ochérachi alué Juani ralámuli rewarame, ya 'ma nerule alué Moisesi nila ra'íchali rejcholi, 'lige alué ra'íchali rejcholi napu ruwime nile napu anele Onorúgame abiena nerúlechigó. Alué Juani ochérasa a'lige si akiná nerú ra'íchali rejcholi napu ruwime ju churigá ka napu'lige 'we 'la 'nátaga eyénachi bilé rió Onorúgame 'yuga. We'ká ralámuli 'nátame ju pe napurigá a'boi 'nata. Jaré noli nakome ju uché jaré ralámuli 'yuga regá anigá: «Alarigá nulá Onorúgame napurigá nakowa.» ");
INSERT INTO tacNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ralámulika tabilé siné lisensia nílamala napurigá nokimela napurigá a'boi najkí. Suwábaga alué Onorúgame rejchólila senibí nerúlamala, 'lige 'we a'lá sébali olámili ju ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","› Aka regáriga anírubá alué Onorúgame nila rejcholi: Bilé rió a'resa bo'né upila 'lige uché bilé mukí 'yuga rewisá, alarigáká 'we resíriga ju. Abiena rewisá uché bilé mukí a'rérigame 'yuga, abiénachigó wa'lú resítiri ju. Abichilubi ra'íchale Esusi, regá anile: ");
INSERT INTO tacNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","―Bejtele bilé rió 'we enomígame, 'we a'kalala o'pacha o'pachátame 'we najteme, nabí rawé 'la e'karúgame go'ame go'yame 'we ra'sati 'we najteme. ");
INSERT INTO tacNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","'Lige bilé rió bejtele tabilé enomígame 'we nayume wejchagónite, Lasro rewégame. Alé yochi alué rió 'we nígame bejtélachi ajchalime nile napurigá go'ame rujsúkame go'mela, 'lige alué o'kochí alemi nawime nile cha'mimea alé wejchágachi. ");
INSERT INTO tacNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","'Lige bilé rawé arigá 'ma mukule alué Lasro 'lige alué alawala o'tole alué santo ánjeli 'pa rewagáchika sígame alé ajchamia napu ajtí Abraámi 'we semárikáchi. Alué rió 'we enomígame abiena mukúlechigó a'kinana, 'lige o'tóliru na'polamia. ");
INSERT INTO tacNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","› 'Lige alué rió 'we enomígame alawala asagá alé re'lé na'ichí napu mochime ju alué cha nokame ralámuli suwígame alawala, 'we resí nilia asale, 'lige etele wamí 'pa rewagachi ajtígame alué Abraámi alué Lasro 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","'Lige e'wele ne'ole regá: «Muérigo Abraámi, neka mué rijimala ju 'we a'kinana ochérigame, mueka 'we 'ya bejtele, pe rekó na'temákarigó ne'chí. Nulewa alué Lasro napurigá sa'nabáchamala pe'tá alué makúsala 'lige napurigá jeka simela rulabáchamia ne'chí inalá, asíriga resí nília ajtí ne jena re'lé na'ichí.» ");
INSERT INTO tacNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraámika regá nejele: «Muérigo towí, aka 'we a'lá na'tábá, mué asíriga 'la ganíliga bejtele bijí ajagá asagá, 'lige alué Lásroka 'we resí níliga bejtele bijí ajagá asagá. 'Lige ye Lásroka jipe 'we a'lá ganíliga ajtí jena, 'lige mueka 'we resí nilia ajtí alé re'lé na'ichí. ");
INSERT INTO tacNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Aminami 'we re'lé enari kachi ju alemi, tase chérigá gainawa ramué alemi e'tegía, aminami muéchigó tase chérigá gainámala jeka 'moa.» ");
INSERT INTO tacNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","› 'Liko anile alué rió napu 'we enomígame nílige alé na'ichí asagá: «Muérigo Abraámi, 'liko juláwagó alué Lasro alé 'mi ne o'nola bejtélachi, ");
INSERT INTO tacNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","alé napu mochí ne ba'chila 'lige ne bonila, maligi ju, napurigá simela Onorúgame nila ra'íchali rejcholi ruyemia napurigá 'la tase 'lúpua jeka na'ichí 'we resí ikiachi.» ");
INSERT INTO tacNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","'Liko alué Abraámika anile: «Ya 'ma we'sá gepú alué napu mué ba'chila ju 'lige bonila alué ra'íchali rejcholi Onorúgame nila alué napu Moisesi osale abiena alué napu osale alué napu ruwime nile napu anele Onorúgame. Alueka alué ra'íchali rejcholi gepúrale ko 'nalina.» ");
INSERT INTO tacNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","› 'Lige alué rioka napu 'we enomígame nílige regá anele: «Muérigo Abraámi, alué ralámulika tase bijchígime ju rejcholi ruilía, 'lige alué Lasro mukúgame aluete nawísiká alué ralámuli, ku guwana na'támala resiti nocha.» ");
INSERT INTO tacNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","› 'Lige alué Abraámika regá anile: «'Lige tase bijchígisa napurigá ruwile alué Moisesi abiena napu ruwile alué napu ruwime nile napu anele Onorúgame, abichilubi tabilé a'rémala chátiri 'nata rekó ku ajánige bilé mukúgame.» ");
INSERT INTO tacNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Esúsika regá anele alué bo'né benírame: ―Senibí rawé mochímala jaré rió alué semati 'nátili najsibume, rekó 'ma simíbage 'lige rekó 'ma tané ikigé, aba nawámala uché bilé rió ra'íchali najsibume, resía 'lige alué rió. ");
INSERT INTO tacNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Wamí wa'lú ba'wichí pátéke'é alué rioka wa'lú rejté ri'ligó rusume golótiga napurigá tabilé aminabi benírimala chátiri 'nátili alué uché jaré ralámuli ta'chó 'la sébali machime Onorúgame nila ra'íchali. ");
INSERT INTO tacNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡'We a'lá 'nátaga 'emi! › Cha anésiga mué bilé riote, ruyewa alué rió alué 'we a'lala rejcholi, 'lige a'lá sébali gepúsaká alué rejcholi, 'liko ku 'we a'lá galegá etewa. ");
INSERT INTO tacNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Napu ekisá cha anisá alué rió 'lige ku e'kali tasa, yati ku e'kawa alué rió. ");
INSERT INTO tacNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","'Lige alué makué oká rió nulame Esusi nochálilachi anile: ―'Yáwagó ramué alué 'nátili napurigá abé a'lá bijchígiwa napu aní Onorúgame ra'ichálila. ");
INSERT INTO tacNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","'Lige alué Esúsika anele: ―Rekó 'emi péemili bijchígame nisa Onorúgame ra'ichálila 'liko anesa 'emi Onorúgame: «O'pó mué alué rojá 'lige elawa alé wamí wa'lú ba'wichí nasipa 'lige wa'lú ochéririwa», 'lige Onorúgameka yati e'wámala. ");
INSERT INTO tacNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Abiena anile Esusi: ―Bilé rió nóchali nígame bilé rió ralisá tabilé najtétiga nochárimia 'lige 'minami julasa asarániliga, 'lige kuka nawasa alemi 'sisa asará, 'mimi einasa 'ma ajágame nesigá, 'lige ¿'lacha regá anémalawé alué rió nóchali nígame?: «Pachaka asagá, go'yá asá remé», ¿'lacha regá anémalawé? ");
INSERT INTO tacNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tase alarigá anémala alué rió, pe regá 'nalina anémala: «Wajsewa go'ame, 'lige 'la e'negá asiboa tachiri rokárika jena mésachi ne go'yá ajtígachi. Pe nejubapi go'poa muéká.» ");
INSERT INTO tacNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","'Lige ¿'lacha aneme júkó alué rió 'ma bosasa cheliérabá? ¿Tacha alieri 'íniligo jaré ralámuli? ");
INSERT INTO tacNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","› A'chigóriga 'emi napu'lige ya 'ma sébali olasa suwábaga nóchali napu nulá Onorúgame, regá aniboa 'emi: «Mué Onorúgame, ramueka pe nóchame niru, 'lige napu mué nulá sébali olaru.» ");
INSERT INTO tacNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Esusi enegá alé Rusaleni simiá, simírole alemi napu napuí alué Samaria rewégame gawí Galilea rewégame gawí si. ");
INSERT INTO tacNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","'Lige a'mulipi enágichi alé bilena u'kabi riógachi, alé simíbale Esusi najtepamia makué rió sa'pachí amoba nayume lepra anilime naulite yolí ra'íchaga. 'Lige alé a'nabeka jábale alué nayúkame rió, ");
INSERT INTO tacNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","'lige regá anele Esusi a'wágame ra'íchiga: ―¡Muérigo Wa'lula Esusi, pe rekó na'temápua ramué! ");
INSERT INTO tacNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","'Lige alué Esusi etesa, regá anele: ―Simíbaga balé e'newa u'tá re'obá ilígachi «sinagoga» rewégame. 'Lige boichimi eyéniga 'ma tané ikile alué naulí alué makué rió sa'pálachi. ");
INSERT INTO tacNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","'Lige bilé alué rió etesa 'ma tané ikíligo alué naulí, yati ku ro'ile, 'lige ku sébaga napu ilile Esusi, wa'lú cheliera 'yale Onorúgame e'wele ra'íchaga, ");
INSERT INTO tacNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","chojkóbisiga rojpóchaga chujkíbale a'bé napu ilile Esusi wa'lú cheliera i'gá. Alué rioka Samaria bejtégame nile. ");
INSERT INTO tacNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","'Liko alué Esusi regá rukele alué ralámuli alé jágame e'negá: ―¿Tacha makué rió ke sa'wígame? 'Lige ¿koche mo'íbaleché alué uché jaré gi makué rió? ");
INSERT INTO tacNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ye riocho uché bilena gawichí bejtégame 'la kuka nolina wa'lú cheliera 'yamia Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","'Lige Esusi anele alué rió: ―Ilísiga, ya 'ma bi'wígame alawégame ju mué jípesí. Yati ku simigá. ");
INSERT INTO tacNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Alué ralámuli bariseo rukele Esusi: ―¿Chiéniko si 'la machí nérélamala Onorúgame 'ma nulao? 'Lige Esúsika regá nejele: ―Napu'lige nulachi Onorúgame, tase 'wesi etémala, ");
INSERT INTO tacNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","napugiti alué Onorúgameka pachágana sulachí asimémpá, pecha 'wesi regá animela: «¡Jena ajtí nulá Onorúgame!» «¡Alé 'miná ajtí nulá Onorúgame!» ");
INSERT INTO tacNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","'Liko regá anele bo'né benírame: ―Sebámala bilé rawé napu buwémala 'emi ne'chí, ne napu nawágame ju 'pa rewagáchika napurigá rió neraga, tabiléchigo etémalagó 'emi. ");
INSERT INTO tacNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","'Lige jaré regá animela: «Jena 'ma nulá Onorúgame», 'lige jaré regá animela: «Alé 'miná 'ma nulá Onorúgame.» 'Lige 'emi tase simawa e'newa, aminami tase najátawa alué alanime ralámuli, pecha bijchiá nimia. ");
INSERT INTO tacNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ne napu nawágame ju 'pa rewagáchika napurigá rió neraga, napurigá u'kí ne'wílala 'we ra'ósame alarigá nímala nawachi ne alé 'pákana rewagachi napu'lige alué raweli sebasa. ");
INSERT INTO tacNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","'Lige bajchako me'liboa ne ralámulite jipe ejperégame. We'ká ralámuli pe gawéliga gepúmala ra'íchali rejcholi ruwichi ne. ");
INSERT INTO tacNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","27","Alué ralámuli napu ejperele 'ya napu'lige bejtele Noé rewégame rió, alué ralámulika pe ejperégame nile, pe mo'norúacho mochime nile 'lige go'ame go'yá 'lige bajía rekútame, aminami pe resítiri nocha. Napusí Noé bajkile bilena wa'lú bárkochi a'rele resítiri nocha napugiti wa'lú u'kúligame 'lige suwábaga ralámuli suwile si'lika. A'chigóriga nímalachigó napu'lige sébachi ne napu nawágame ju 'pa rewagáchika napurigá rió neraga. 'We chátiri nocha mochímala ralámuli 'lige tabilé sayémala nawachi ne. Abichilubi anile: ");
INSERT INTO tacNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","―A'chigóriga ejperele alué 'ya ejperégame ralámuli napu'lige bejtele alué Loti rewégame rió. Pe go'ame go'yacho mochime nile, 'lige bajía rekútume, 'lige ralagá tábiri 'lige ralinea, 'lige pe echá mochime nile, abiena pe galí newagá ejperégame nile, ");
INSERT INTO tacNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","napusí alué rió Loti 'másasa alé we'ká riógachi Soroma asagá, napu'lige na'í rujsule abiena asupre rewégame rejté rajame 'pákana rewagáchika, 'ma re'wániga suwile alué ralámuli, 'ma suwábaga tábiri 'ma galítiri 'yúriga rajale. ");
INSERT INTO tacNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","'We resíriga nímalachigó uchéchigo nawachi ne napu ju bi'neli neyúriga tabilé se'winá 'sime. Chátiri nocha mochímala ralámuli 'lige tabilé sayémala nawachi ne. ");
INSERT INTO tacNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","› Napu'lige sebasa rawé napu'lige ne kuka sébachi 'pa rewagáchika, 'lige jaré ralámuli galichi amoba mochisa, 'lige alué we'ká tábiri alué ralámuli nila alé re'lé pachá galírale mochisa, tase e'tegímili ju buinamia alué tábiri o'tomea júmisimia. 'Lige jaré ralámuli wasachi e'yénasa, tase ku galírale simámili ju. ");
INSERT INTO tacNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Aka churigá ikíliga'é alué mukí Loti upila, ku guwana e'nesa 'ma oná gayénale. ");
INSERT INTO tacNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Alué napu jena wijchimoba nerúgame tábiricho 'we koruka eteme ju 'lige majame ju Onorúgame ra'ichálila beníriga ralámuli pe me'liboa mayega, alueka tabilé narémala semati raweli. Alué napu tabilé majame ju mukigá Onorúgame nochálilachi nóchiga, alueka 'la narémala semati raweli 'pa rewagachi. ");
INSERT INTO tacNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","› Neka 'la bijchiá ruwí. A'lige rukó oká ralámuli bi'timela alé bi'lénapi tabachi okoka, 'lige alué bilé o'toboli ju 'pa rewagachi, 'lige bilé abajá a'réwali ju. ");
INSERT INTO tacNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Oká umugí napuíka rusiá uchusa, bilé o'toboli ju 'pa rewagachi, 'lige bilé abajá a'réwali ju. ");
INSERT INTO tacNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Oká rió nokisá nocha wasachi, 'lige bilé o'toboli ju 'pa rewagachi, 'lige bilé abajá a'réwali ju. ");
INSERT INTO tacNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","'Lige alué benímeka rukele Esusi: ―Mué Wa'lula, ¿koche ikimela 'lige alué alarigá? 'Lige Esúsika regá nejele: ―Alé napu bo'í mukúgame, alé napuímala gonoli 'lige wilú. ");
INSERT INTO tacNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Aminami Esusi ra'íchale alué bo'né benírame 'yuga bilé ra'íchali napu ruwime nile senibí ra'ichálime ka Onorúgame 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Regá anele: ―Bejtele bilé rió ra'íchali gateme alé bilena we'ká riógachi. Alué rioka tase nirame nile Onorúgame, aminami tase nirame nile ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Abalé we'ká riógachi bejtélechigó bilé mukí gunámakame. 'Lige alué mukika ya 'ma we'sá simílige alué rió ra'íchali gateme e'nemia napurigá gu'írowa na'áwili gatélichi. ");
INSERT INTO tacNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","› 'Lige we'ká rawé alué ra'íchali gateme tase gu'írile alué mukí na'áwili gatea. 'Lige arigá regá 'nátale: «Rekó ne ta nirame ke Onorúgame aminami ta'wesi ralámuli, ");
INSERT INTO tacNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","abirigá 'la gu'írimala ne ye mukí gunámakame napugiti cha nejkumeme napurigá ta aminabi nejkumémala 'lige napurigá ta che animela ralámuli akiná.» ");
INSERT INTO tacNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","'Lige anile alué Esusi: ―'La na'tásibá alué rió ra'íchali gateme tase 'la sébali nóchame rió ke, aka alué rió 'la gu'írilige'é alué mukí, ");
INSERT INTO tacNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","'lige alué Onorúgameka, ¿'lacha ta'lá semáriga gu'írimalawé ralámuli Onorúgame oyérame alué napu Onorúgame 'yuga ra'íchame ju iwérali tániga? ");
INSERT INTO tacNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Alueka tase we'lisi buwémala, 'we yati gu'írimala. Ne rukérabá bilé ra'íchali 'emi: Napu'lige uchéchigo nawá ne napu nawágame ju 'pa rewagáchika napurigá rió neraga, ¿'la rewiméréle ne alué ralámuli bijí 'la bijchigia mochígame 'we a'lá nejkúrame ko Onorúgame napu'lige iwérali táachi apiépiri ralámuli? ");
INSERT INTO tacNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Esusi abiena anele alué jaré ralámuli napu mochime nile alemi 'we gunarume 'lige gawéliga eteme uché jaré ralámuli. Regá anele: ");
INSERT INTO tacNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Oká rió simíbale alé re'pá rabó wa'lú re'obá ilígachi, 'lige bilé alué rió bariseo nile, 'lige alué uché bilé rioka enomí nareme nile napu nejílime nile alé wa'lula ajtígachi. ");
INSERT INTO tacNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","'Lige alué rió bariséoka o'weti iligá Onorúgame 'yuga ra'íchale bo'nepi 'we gunaruga regá: «Mué Onorúgame, neka wa'lú cheliera 'ya mué napugiti neka 'we a'lá rió kame, tase chigoga oyame, tase chati nóchaga oyame, tase we'ká umugí 'yuga gojchime, 'lige tase napurigá alué rió enomí goblálome. ");
INSERT INTO tacNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Neka 'we ayúname ju tabilé go'gá che'lébaga 'lige melénala rawé rukachégame 'yúriga. Osá ayúname ju ne alarigá bilé tarali. Makué peso mesa ne, bilé peso 'yame ju ne mué Onorúgame.» ");
INSERT INTO tacNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","› 'Lige alué enomí goblálomeka 'mi waná ilile rojpóchaga tase e'nénaga 'pa rewagachi, pe iligá mo'loa ilile rojpóchaga, regá aniá: «Mué Onorúgame, pe rekó e'kárigó ne'chí, 'we chátiri alawégame ju ne.» ");
INSERT INTO tacNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","'Lige alué rió enomí goblálome 'ma ku galírale simile, 'we a'lá e'káriga Onorúgamete, napugiti bilé ralámuli napu abé wa'lula neraga 'nátame ka bo'nepi me'tagá uché jaré ralámuli, alueka tabilé na'temaka etewa Onorúgamete. Alué bariséoka tabilé na'temaka etéliru Onorúgamete. 'Lige alué abé a'lá niraga eteme uché jaré ralámuli me'tagá bo'nepi, alueka 'we na'temaka etewa Onorúgamete. ");
INSERT INTO tacNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","'Lige alué we'ká ralámuli a'pile jaré u'kuchítiri Esusi alé napurigá cha'pimela Esusi alué u'kuchítiri, 'lige alué Esúsite benírilime ralámuli etesa u'kuchítiri a'pichi ralámuli, yati sulile napurigá tabilé a'pímala alué u'kuchítiri alé. ");
INSERT INTO tacNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","'Lige Esúsika bayele alué ralámuli bo'né benírame, 'lige anele: ―A'rewa napurigá alué u'kuchítiri jeka smela, tase suliwa. Onorúgame 'yame ju a'walí alué ralámuli napu ju napurigá u'kuchí 'kuchi napu yati nareme ju napu'lige i'lía bilé tábiri. ");
INSERT INTO tacNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Neka 'la bijchígaga ruwí, alué ralámuli tase alarigá nokisá napurigá alué u'kuchí 'kuchi, tasiné elimio Onorúgame napurigá nulémala alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Bilé wa'lula ralámuli jurío nuleme rukele alué Esusi: ―Mué, benírame, 'we a'lá rió, ¿tachiri nochámili ju ne napurigá moinámala ne re'pá rewagachi nabí alé asimea? ");
INSERT INTO tacNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Esúsika regá nejele: ―Mueka ¿chonigá «'we a'lá rió» anéché ne'chí? Alué 'we a'laka pe Onorúgame ju. ");
INSERT INTO tacNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mué 'la sébali machíguru alué osilí napu a'rele Moisesi napu anime chujkú: «Tase we'ká umugí 'yuga gojchiboa, pe mué bo'né upílacho 'yuga gojchiboa, tase me'liboa ralámuli, tase chigowa, tase 'wesi ralámuli 'yuga 'yégiga ra'ichawa, 'la nirawa mué bo'né o'nola abiena mué eyela.» ");
INSERT INTO tacNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","'Lige alué rioka regá anile: ―Neka 'we a'lá rió ju 'yasi bijí u'tá rió ka napurigá nulá alué Moisesi nila rejcholi. ");
INSERT INTO tacNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","'Lige Esúsika alué ra'íchali akisá, regá anele: ―Bijí tabilé 'cho bi'wígame alawégame rió kéré mué: Suwábaga tábiri ralinewa napu ekí ni mué, 'lige kógiwa mué alué enomí alué tabilé nígame ralámuli, alésíko 'la bi'wígame alawégame rió nímala mué Onorúgame níriga. Alarigá 'la mémala mué alué bi'wígame raweli 'pa rewagachi. Napu'lige suwábaga tábiri ralinesa mué, ku nawawa ne'chí 'yuga einamia. ");
INSERT INTO tacNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","'Lige alué rió alarigá nulésiga, 'we sewele napugiti we'ká tábiri nígame níligame alué rió. ");
INSERT INTO tacNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","'Lige alué Esusi etesa 'we sewéligo alué rió, regá anele: ―'We nóchali nímala bilé rió 'we nígame níriga sébali olá napurigá najkí Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Bilé rió 'we nígame pe 'we korua ajtime ju e'karúgame tábiri napu ni bo'nepi tabilé nélagá Onorúgame, alué rioka tabilé sebámala 'pa rewagachi. ");
INSERT INTO tacNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","'Lige alué ralámuli napu akele alué ra'íchali, regá anile: ―'Liko ¿chieri la sébali olámalaché napurigá Onorúgame nulá napurigá sebámala rewagachi? ");
INSERT INTO tacNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","'Liko Esúsika regá anile: ―Ralámuli jena wijchimoba ejperégameka tabilé gayéname ju 'la sébali olá napurigá 'la o'toboa Onorúgamete 'pa rewagachi, pe Onorúgame gite ka 'la sébali olame ju 'la moinamia 'pa rewagachi. ");
INSERT INTO tacNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Alué Pegro abiena alé eyénale Esusi 'yuga, 'lige anile: ―Ramueka 'ma suwábaga a'reru alué we'ká tábiri napu nígame nírige ramué mué 'yuga e'yénimia. ");
INSERT INTO tacNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","'Liko Esúsika regá anile: ―Tase 'me a'lá ju Onorúgame níriga rekó 'we galegá etee alué tábiri napu ni bo'né bilé rió, 'lige rekó 'we a'lá galegá etee bo'né upila, bo'né ba'chila, bo'né bonila, bo'né go'chila, bo'né waíla, bo'né o'nola, bo'né eyela, 'lige bo'né 'kúchila, peka a'lá sébali olae alué rió napurigá najkí Onorúgame. Abé a'lá ju 'la sébali olá bilé rió napurigá najkí Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Alarigá sébali olame nisa bilé rió 'liko Onorúgame 'la 'yámala alué 'la bi'wígame raweli jena wijchimoba ajtígachi, 'lige 'pa rewagachi ajtígachi senibí. Abiena bilé mukí níriga a'chigóriga júchigó. ");
INSERT INTO tacNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Alué Esusi waná bayele alué makué oká rió Esusi nochálalachi nulame 'lige regá anele: ―'La gepúsibá, ya'má simawa alé 'pa rabó Rusaleni anilichi. Alé sebámala raweli napurigá osale alué 'ya ejperégame napu ruwime nile napu anele Onorúgame alarigá ikimeo ne napu nawágame ju 'pa rewagáchika napurigá rió neraga. ");
INSERT INTO tacNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","O'toboli ju ne alé napu mochí tabilé jurío ralámuli, 'lige 'we gawéliwili ju ne abiena 'we resí anéwali ju ne, noli a'kachípali ju ne. ");
INSERT INTO tacNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Aminami 'we wejpisópili ju ne 'lige 'ma me'liboli ju ne. 'Lige neka pe bakiá rawé kachi ku ajánamala me'lisuga. ");
INSERT INTO tacNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","'Lige alué makué oká rioka tabilé námale alarigá anichi alué Esusi. Onorúgame tabilé 'yale 'nátali napurigá námamala chonigá aníligo alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Napu'lige Esusi 'ma a'mulipi enágichi alé we'ká riógachi Jerikó rewégachi, 'lige bilé rió tabilé ma'chílime asale alemi boichimi taa enomí. ");
INSERT INTO tacNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","'Lige akisá we'ká ralámuli simárochi alemi, rukele: ―¿Cho nokogá aní alué ralámuli? ");
INSERT INTO tacNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","'Lige ralámulika anele: ―Alué Esusi Nasareta bejtégame 'naka ená we'ká ralámuli 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","'Liko e'wele ra'íchale alué rió: ―¡Muérigo Esusi, Rabí rijimala alué 'ya ajtígame, pe rekó na'temaki ne'chí! ");
INSERT INTO tacNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","'Lige alué ralámuli bajchabemi e'yénigime sulile napurigá tajché aniá asimela alué rió, 'lige alué rioka aminacho e'wele ra'íchale: ―¡Muérigo Esusi, Rabí rijimala, pe rekó na'temaki ne'chí! ");
INSERT INTO tacNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","'Liko Esusi ilíbale 'lige nulale napurigá aleka a'piwa alué rió tabilé ma'chílime. 'Lige 'ma alé a'písiga alué rió, rukele: ");
INSERT INTO tacNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Tachiri choliame najkí mué? 'Lige alué rió tase ma'chílime ka regá anile: ―Mué bi'neli neyúriga wa'lú a'walí nígame, neka najkí napurigá mué ne'chí 'yómala busila napurigá ku 'la ma'chílamala ne. ");
INSERT INTO tacNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","'Lige Esúsika regá anele: ―Ku ma'chílimala mué, napugiti 'we a'lá sébali bijchígame mué Onorúgamete julárigame ko ne. ");
INSERT INTO tacNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","'Lige pe yati ku ma'chílale alué rió, 'lige alué Esusi 'yuga simile, wa'lú cheliera 'yasia enale Onorúgame ra'sálagá. 'Lige alué we'ká ralámuli napu ekí etele ku 'la ma'chilio alué rió, abiena wa'lú cheliera 'yasia e'yénale Onorúgame ra'sálagáchigó. ");
INSERT INTO tacNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","'Lige Esusi sébale alé we'ká riógachi Jerikó rewégachi. Enale alemi nasípami we'ká galí jágichi. ");
INSERT INTO tacNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","'Lige alé bejtele bilé rió 'we enomígame Sakeo rewégame. Alueka wa'lula nile enomí nareme alé Roma anilichi wa'lúlachi enomí nejílichi. ");
INSERT INTO tacNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Alué rioka 'we eténile alué Esusi alemi enágichi, 'lige tase chérigá etele alemi wijchí iligá, cha we'ká rióligame alemi 'lige aminami alué Sakeo cha re'lé ilígame rió níligame. ");
INSERT INTO tacNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","'Liko alué rió bajchami 'male 'lige re'pá rojachi 'mole, alé iligá e'nemia Esusi. Alemi simírimili níligame alué Esusi we'ká ralámuli 'yuga. Alué rojaka napuyeri chuná nile jami jágame 'we re'pá jágame. ");
INSERT INTO tacNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","'Lige alué Esusi alemi enegá, e'nele alé re'pami rojachi, 'lige etesa Sakeo anele: ―Muérigo Sakeo, 'we sapuka re'kí, nabá mué bejtélachi, neka simeli ju alemi mué galílachi. ");
INSERT INTO tacNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","'Lige alué Sakeo 'we sapuka re'kile, 'lige 'we ra'sálagá anele: ―Nabágó 'liko. ");
INSERT INTO tacNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Alué we'ká ralámuli etesa alué Sakeo galílachi bajkigó Esusi go'ame go'mea, 'lige alué ralámuli chojkile a'bopi ra'icha sayega alué Esusi. Anile alué Esusi bajkíligo alé galírale enomí bujeme ralámuli rió bejtélachi. ");
INSERT INTO tacNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","'Lige alué Sakeo 'ma go'sá o'weti ilísale, 'lige anele alué Esusi: ―Mué Wa'lula, neka nasípasi kógimala alué ralámuli tase nígame alué we'ká tábiri napu ne ni, 'lige chigógite'é ne enomí 'yégiga alué ralámuli, jípeko naosa rasígame ku 'yámala ne a'pílipi. ");
INSERT INTO tacNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","'Lige Esúsika regá anile: ―Ne napu nawágame ju 'pa rewagáchika napurigá rió neraga, neka 'yasia nawá resí nokagá ejperégame ralámuli semati rejcholi ruyemia, jipe ya 'ma ku a'rele ye rió chátiri 'nátili napu ju Abraámi rijimala, alué Abraámi napu 'we 'ya bejtégame nile. Alekeri gu'iri ne napurigá ku guwana na'támala, 'lige 'la ku guwana 'nata. ");
INSERT INTO tacNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Alué ralámuli napu alemi mochile gepua alué ye ra'íchali, 'lige mayele a'lige yati pe alé Rusaleni sebasa o'maka Wa'lula Rey gainamio Esusi alé Israeli nulame. ");
INSERT INTO tacNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","'Lige Esúsika regá anele se'wináriga 'nata mochígichi: ―Bejtele bilé rió 'we enomígame, 'lige mejká simile wa'lula rey ajtígachi napurigá wa'lula selígame ajchawa, selígame nawamia bo'né gawílachi. ");
INSERT INTO tacNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","'Lige ta'chó simiá, bayele alué makué rió bo'né 'yuga nóchame, 'lige 'yale a'pílipi makué enomí 'we najteme 'lige anele: «Nocháriwa 'emi ye enomí napusí ku nawachi ne.» ");
INSERT INTO tacNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","› 'Lige we'ká ralámuli alé ejperégame napu bejtele alué 'we enomígame rió tase galele alué rió napurigá selígame nímala, 'lige júlale nujubami sulíniliga alé 'mi wa'lula nulame ajtígachi riógame ralámuli regá anéniliga: «Tabilé najkiá ramueka napurigá wa'lula selígame nímala ye rió ramué gawílachi.» ");
INSERT INTO tacNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","› Alué rioka abirigá wa'lula selígame ajcháliru, 'lige ku sébale bo'né bejtélachi. 'Lige ku sebasa bo'né galílachi, 'lige bayele alué makué rió bo'né 'yuga nóchame rukemia chekí méliga enomí nocháriga alué a'pílipi rió. ");
INSERT INTO tacNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","› 'Lige alué bilé rió bajchá nawágame regá anile: «Mué Wa'lula, alué enomí napu mué nejí 'sié makué enomí 'we najteme merá bilé siento enomí.» ");
INSERT INTO tacNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","› 'Liko alué enomí nígame regá anele: «'We a'lá sébali nóchame rió ju mué, alekeri nulame newámala ne mué makuémina we'ká riógachi.» ");
INSERT INTO tacNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","› 'Lige uché bilé rió nóchame sébale alé. Alueka regá anele: «Mué Wa'lula, alué makué enomí napu mué nejí 'sié, alueka pe malígisa makué méte'é.» ");
INSERT INTO tacNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","› 'Liko alué enomí nígame anele alué rió: «Mué rió, malígina we'ká riógachi nulame nímala mué.» ");
INSERT INTO tacNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","› 'Lige uché bilé rió nóchame sébale alé, 'lige anele: «Mué Wa'lula, jena mochí ye enomí napu mué nejí 'sié. Neka ye enomí banítochi ra'koga gatega ajtigé ");
INSERT INTO tacNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","napurigá ta e'wagámala, napugiti mué rió 'we ená anime kame. Mueka niga asíbame ju napu tabilé mué bo'né nila ju, mueka 'wíime ju bilena peka echisá.» ");
INSERT INTO tacNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","› 'Lige anile alué rió enomí nígame: «Tabilé 'nátanti. Mué 'la sébali machí ne 'we ená anime rió ko, niga asíbame ko ne napu tabilé ne nila ju, 'lige 'wíime ko ne napu tabilé echá. ");
INSERT INTO tacNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","'Lige ¿chonigá ta nochari ko mué alué enomí alé enomí gatélachi mo'ogá? Alarigaka 'la uché rajpé narémikuru ne alué enomí ku nawagá.» ");
INSERT INTO tacNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","› 'Lige alué rió enomí nígame anele alué ralámuli napu jale alemi: «Bujewa alué enomí ye rió, 'lige 'yawa alué napu mele bilé siento.» ");
INSERT INTO tacNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","› 'Lige alué ralámulika anile: «¡Mué Wa'lula, aka 'máchigo ni ko alueka bilé siento enomí napu mele!» ");
INSERT INTO tacNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","› 'Lige alué rió enomí nígameka regá nejele: «Neka 'la sébali ruwí, alué abé mékame enomí nocháriga, alueka abéchigo abé we'ká 'yámala ne. 'Lige alué tase mékame enomí nocháriga, alueka bujémala ne napu ekí 'ya ne. ");
INSERT INTO tacNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","'Lige alué ralámuli sairúgame napu tase najkile napurigá ne wa'lula selígame nímala, alueka jeka a'pawa 'lige 'ma me'liboa jena ne'chí etériga», alarigá anele. ");
INSERT INTO tacNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Pe nujubapi 'ma alarigá ra'ichasa alué Esusi, uché 'we simile Rusaleni simea, alésíko rewiná nile. ");
INSERT INTO tacNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","'Lige amulí seba Be'tagé 'lige Betania 'ámuli riógachi napu nile re'leberi Olibo rewégachi rabó 'lige alé yéniga júlale oká rió bajchá napu nile bo'né benírime, regá anigá: ");
INSERT INTO tacNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","―Simawa alé 'pari pe'kabi riógachi Be'tagé rewégachi 'lige 'emi alemi sébaga rewimela 'emi bilé bulito o'wiga ujchárigame bijí ranala ta'chó murútilime. 'Lige su'panasa jeka o'toboa o'wiga alué bulito. ");
INSERT INTO tacNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","'Lige ralámuli rukésaká chonigá su'panalia alué bulito, regá anewa: «Alué Wa'lula najkí bulito.» ");
INSERT INTO tacNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","'Lige alué oká rió bo'né Esusi benírame simíbale 'lige 'la rewale bulito napurigá anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","'Lige alué bulito su'pana uchúkachi, alué upugégame ka anele: ―¿Chonigá su'panáliché 'emi alué bulito? ");
INSERT INTO tacNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","'Lige alué oká rioka regá nejele: ―Alué Onorúgame a'walila nígame najkí ye bulito. ");
INSERT INTO tacNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Alésíko o'tóile alué bulito Esusi alé na'légana, 'lige alué oká rió gemala chiní i'weli bujusá pérale alué bulito 'lige alé asérale alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","'Lige alé rabó moyena alué we'ká ralámuli bajchabemi pésiga e'yénale gemala chiní i'weli napurigá nokame nile napu'lige nawasa napunápuri riógachi bilé wa'lula rey. ");
INSERT INTO tacNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","38","'Lige alé rabó Olibo na'kolígana e'yéniga napu pe 'wechi ma'chígime nile Rusaleni, suwábaga alué we'ká ralámuli alué Esusi oyérame chojkile e'wele sinaka ra'icha ra'sálagá, abiena 'we a'lá niraga ra'icha Onorúgame. Regá anigá: ―¡Jipe 'ma seba alué Wa'lula Rey Onorúgamete julárigame, Onorúgame a'walila nígame, ramueka 'we a'lá niralia ye rió! ¡Wa'lú ra'sálalí nerú 'pa rewagachi! Regá anile alué ralámuli napugiti wa'lú a'walí nígame níligame alué Esusi, 'we sa'wame nile ralámuli tabilé ma'chílime, 'lige ajánarime nile alué suwígame. Abiena 'la o'pasárale maligi mili ralámuli 'ya bajchabé rawé maligi banite 'lige oká ro'chite. Onorúgame 'yame nile a'walí bo'né nila. ");
INSERT INTO tacNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","'Lige jaré bariseo napu jale alemi we'ká ralámuli jágichi, alueka anile: ―Muérigo benírame, suliwa alué mué 'yuga e'yéname napurigá kilí jámala. ");
INSERT INTO tacNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","'Liko alué Esúsika regá nejele: ―Neka 'la bijchiá aní, ye ralámuli a'résaká siná a'liko rejté sinaka ra'ichámala. ");
INSERT INTO tacNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Napu'lige Esusi enagá alé 'ma bochígimi ma'chígichi Rusaleni, 'lige nalale alué we'ká alé riógame ralámuli na'temaka, ");
INSERT INTO tacNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","regá anigá: ―Neka 'we seweka ená jipe alué ralámuli na'temaka. 'We 'la képá alué ralámuli 'la 'nátaga akisá jipe rawé 'la bi'wígame alawégame gayéname ko apiépiri ralámuli 'la 'nátaga akeme aleké ra'íchali rejcholi napu benírige ne alué ralámuli 'yabé rawé, jípeko 'máchigo nasótiga ajtíkó alué rejcholi, pecha bijchígilime alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","'Lige sebámala bilé rawé 'we resí ikimeli alué ralámuli. Alué saíla alé a'beka tegóchika we'é namó ajchámala nakomia aleka uchuka, mo'imea pachami, ");
INSERT INTO tacNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","'lige 'ma re'wániga me'limela alué ralámuli Rusaleni ejperégame, abiena 'ma re'wániga gajunámala galí. Alarigá ikimela alué ralámuli pecha bijchígiligame Onorúgame nawachi ralámuli gu'írimia ku guwana ro'inamia alué resiti nóchame. ");
INSERT INTO tacNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","'Lige alué Esusi bajkile alé ra'pichí wa'lú re'obachi Onorúgame galílachi, 'lige 'ma ma'chí buyánale alué ajágame ralineme ralámuli alé. ");
INSERT INTO tacNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","'Lige anele: ―Alé bilena apélichi regá ruwí: «Ne galílaká Onorúgame 'yuga ra'ichálime nímala 'lige iwérali tánilime», 'lige 'émika uné napurigá resó chigórigame nila. ");
INSERT INTO tacNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Alué Esúsika senibí rawé benírime nile Onorúgame nila ra'íchali alé wa'lú re'obachi Onorúgame galílachi, 'lige alué e'wélala balé abiena alué Moisesi a'rélala ra'íchali benírame ralámuli abiena alué e'wélala nulame alé we'ká riógachi, alueka 'nátale churigá 'la nimio me'liá alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","'Lige tabilé che ikisá nílile alarigá 'la nímio me'liá, cha we'ká ralámuli jáligame alé alué ra'íchali rejcholi gepuga 'lige 'nata. ");
INSERT INTO tacNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Bilé rawé napu'lige Esusi ajtígichi alé ra'pichí re'obá ilígichi Onorúgame galila, beniria Onorúgame nila ra'íchali we'ká ralámuli 'lige aminami rejcholi ruyea napurigá 'we a'lá e'wámala napu nulá Onorúgame. A'lige alemi a'bemi jábale alué e'wélala balé, abiena alué napu benírame nile alué ra'íchali rejcholi napu a'rele Moisesi 'we 'ya, abiena alué ralámuli jurío nuleme. ");
INSERT INTO tacNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","'Lige alué ralámulika regá anele alué Esusi: ―Mué Esusi, ¿tachiri najtékame nóchali nígame ju mué? ¿Wa'lula ju mué? ¿Chiérite ajcharu mué napurigá wa'lula nímala mué? ");
INSERT INTO tacNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","'Liko Esúsika regá anele: ―Ne abichigó rukumela bilé ra'íchali, 'lige chonirá 'emi: ");
INSERT INTO tacNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","«¿Chieri júlale Juani napurigá rewarámala ralámuli ba'ichí jáwaga, Onorúgame o pe apiépiri ralámuli?» ");
INSERT INTO tacNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","'Liko alué ralámulika chojkile ra'icha a'bopi rukegá, regá anile: ―¿Churigá nejiawa? «Onorúgame júlale», anisúgaká, 'liko regá animela: «¿'Lige chonigá ta bijchígileché 'emi?» animela. ");
INSERT INTO tacNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","'Lige tase chérigá rupoa pe apiépiri ralámulite julárigame níligo. Alarigá ruisúká ramué 'liko 'ma me'limela ralámuli bajsibuga ramué napugiti 'la machigá mochígime Juani 'la Onorúgamete julárigame níligo. ");
INSERT INTO tacNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Alarigá anile majaga alekeri tase machióríle aluete julárigame níligo alué Juani ralámuli rewarániliga ba'ichí jáwaga. ");
INSERT INTO tacNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","'Liko Esúsika regá anele: ―Néchigó tabilé ruwimela 'liko chiérite ajchárigame ka ne wa'lula neraga. ");
INSERT INTO tacNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","'Lige chojkile Esusi ra'icha ralámuli 'yuga, regá anigá: ―Bilé rió jáwale we'ká i'wilí bo'né gawílachi, 'lige owile repúniliga jaré rió nóchame, 'lige alué bo'né rió i'wilí nígame ka simile bilénami mejká. Alé mejká asale we'kabé bamí, alakí bamí kachi 'ma chojkile rakea alué i'wilí. ");
INSERT INTO tacNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Napu'lige 'ma rakesa 'lige 'ma wachi, júlale bilé rió nóchame napurigá 'wímala alué i'wilí rakala napu nachuámili nile alué rió i'wilí nígame. 'Lige alué owítigime i'wilí repúkichi 'ma wejpisole alué rió julárigame 'wíniliga, 'lige pe sekega júlale kumi. ");
INSERT INTO tacNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","'Liko alué rió i'wilí nígame uchéchigo bilé rió nóchame júlale 'wíniliga. Abiena alué rió 'we ne'ocháliruchigó, abiena wejpisóliru, abiena tase 'yáliru alué i'wilí rakala napu 'núliga juláliru. ");
INSERT INTO tacNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","'Lige alué i'wilí nígame uchéchigo bilé nóchame rió júlale i'wilí 'wíniliga, 'lige abiénachigó 'we jéchiga wejpisole, 'lige 'ma kumi júlale. ");
INSERT INTO tacNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","› 'Lige arigá 'nátale alué i'wilí nígame: «¿Churigá olásiga 'la nímalaché? Jípeko julámala ne ne bo'né inolá. Siné kachi alueka 'la niráwaréko.» ");
INSERT INTO tacNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","› 'Liko alué owítigime ralámuli i'wilí jáwame repúniliga etesa alué rió alé a'nabeka enágichi, 'liko anile a'bopi ra'íchaga: «Alué rió júkuru alué o'nola nila nachuámili napu'lige o'nola mukusá, alekeri me'liboa alué rió, alarigá 'la ramué niga ejtebiwa ye wasá i'wilí jawárigame.» ");
INSERT INTO tacNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","'Liko alésíko 'minami mejkabé o'togá me'ale. Alarigá anele Esusi alué ralámuli 'lige rukele: ―¿Cholámalawé alué wasá i'wilí nígame alué ralámuli alué re'malí me'ágame? ");
INSERT INTO tacNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Alemi simela 'lige 'ma me'limela alué ralámuli owítigime i'wilí jawárigame repúniliga, 'lige uché jaré 'yámala alué i'wilí jawárigame repúniliga. 'Lige akisá alué ralámuli alanichi Esusi, 'lige regá anile: ―¡Tase siné alarigá nokisuga 'la képá! ―anile majaga. ");
INSERT INTO tacNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","'Lige Esúsika e'néniga anele: ―¿'Lige tachiri ruwime ju alué osilí napu uchú osiruga alé bilena apélichi napu uchú Onorúgame wikárila regá anime?: Jaré rió galí newame gawélele bilé rejté, 'lige alué rejteka 'we a'lá a'wagá asíbale alé chijtochi ajchásiga. Alanime júturu alué osilí napu uchú alé bilena apélichi napu uchú Onorúgame wikárila. ");
INSERT INTO tacNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","'Lige uchérajpé anile alué Esusi: ―Apiépiri rió alé rejtechi bo'ibasa, 'ma chi'wámala. 'Lige bilé rió me'táchisa alué rejtete, 'ma chi'laga rejpímala. Alué rejté aniáká pe ne'chí olagá aniame kéré. ");
INSERT INTO tacNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","E'wélala balé 'lige alué Moisesi a'rélala ra'íchali rejcholi benírame ralámuli, alueka cha'pinálile alué Esusi a'lige yati alé, napugiti alué ralámulika 'we a'lá machíligame alieti olagá anió alué Esusi rejté gawélirigime ruyá, aminami 'we a'lá machile ne'ochalia alué ralámuli, iligá alué ralámulika majale alué uché jaré ralámuli, alekeri tabilé cha'pile. ");
INSERT INTO tacNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","'Lige júlale jaré rió napurigá pe i'kilí e'yénamala Esusi e'néniga, 'la a'ká ralámuli neraga pala se'winá anigá enara alué Esusi 'lige se'winá anigá einásaká yati cha'piboa olale o'tomea alé wa'lula selígame ajtígachi. ");
INSERT INTO tacNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","'Lige arigá siné rawé regá rukele: ―Mué, benírame, ramueka 'la machiaa 'we semáriga benírame ko mué, suwábaga ralámuli 'la nirame ko mué, 'lige 'la sébali benírame ko mué napurigá nulá Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ruwíbá mué, ¿pala a'lá ju enomí i'lía alué wa'lula selígame rey alé Roma ajtígame, tabiléchala 'la ju? ");
INSERT INTO tacNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Alué Esúsika 'la machile chátiri 'nátaga rukeo alué ralámuli, 'lige anele: ");
INSERT INTO tacNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","―'Emi bilé ralámuli, jeka o'tóbá bilé enomí. 'Lige bilé ralámuli yati 'yale bilé enomí chijtúligame bawérigame. 'Lige Esúsika rukele alué we'ká ralámuli: ―¿Chieri mo'ola ju ye mo'ó jena enomichi ajtígame? 'Lige ¿chieri rewalá ju napu chujkú jena? 'Lige alué ralámulika regá nejele: ―Aka aluéguru wa'lula gobierno enomí nareme. ");
INSERT INTO tacNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","'Liko Esusi anele alué ralámuli: ―Napu alué wa'lula nila ju, alueka ku aba alué 'yáwaguru, 'lige alué napu Onorúgame nila ju, alueka alué Onorúgame 'yáwaguru. ");
INSERT INTO tacNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","'Lige alué Esusi tabilé se'wináriga nejele, alekeri tabilé che ikile alué ralámuli rekó o'tonalie. Alésíko kilí jábale alué ralámuli, suwábaga tábiri 'we benegá nejéligime alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Pe nujubapi jaré alué saruseo chojkégame ralámuli simíbale Esusi 'yuga ra'ichamia. Alué ralámuli saruseo napu tase bijchígime nile rewagachi simíbame ko ralámuli suwisá, regá anele alué Esusi: ");
INSERT INTO tacNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Mué, benírame, bilé rió mukusá 'lige bi'neli rejpisa upila tase 'cho 'kúchiga alué rió 'yuga, 'lige alué rió mukúgame ba'chila o bonila rewimeli kará alué mukí gunámakame, 'lige 'kúchigame nímará alué mukí 'yuga, 'lige alué rió 'kúchilaka alué mukúgame 'kúchila kárélamará. Alaníché alué osilí napu osale alué Moisesi 'we 'ya ajtígame. ");
INSERT INTO tacNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Sinéchigo mochile gichao ejtemali a'boi rijimala. Newile bilé alué re'malí bajchá ochérigame, 'lige 'ma mukule ta'chó 'wesi 'kúchiga alué mukí 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","'Liko alué rió mukúgame bonila newile alué mukí gunámakame 'yuga, abiena 'ma mukúlechigó tase 'kúchiga. ");
INSERT INTO tacNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Alarigá nokale suwábaga alué gichao ejtemali repola 'yuga newía, 'lige suwábaga gichao ejtemali tase 'kúchiga suwile. ");
INSERT INTO tacNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Alésíko arigá 'ma mukule alué mukí. ");
INSERT INTO tacNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Napu'lige alé rewagachi sebasa alué we'ká ejtemali 'lige alué mukí, aleka ¿chieri 'nalina upila nímalawé alué mukí? Alarigá rukele rekó tabilé bijchígime ke rewagachi simíbame ko suwígame. ");
INSERT INTO tacNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","'Lige Esúsika nejele: ―Jena wijchimoba ka rió 'lige umugítiri newime ju, ");
INSERT INTO tacNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","alué napu ekí seba rewagachi nibilé umugí nibilé riótiri newime ju ");
INSERT INTO tacNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","aminami tabilé siné suwimeli ju. Aleka suwábaga ralámuli napurigá santo ánjeli nímala. 'Lige Onorúgame 'kúchila nímala alé 'pa rewagachi 'ma senibí neraga. ");
INSERT INTO tacNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Aka aba alué bo'né Moisesi osálige'é pe'kabi osilí napu ruwí rajá ilíligo alué bilé u'tá rojá, alé pe'kabi osilichi ruwí rewagachi simíbame ko ralámuli suwisá. Alé pe'kabi osilichi ruwí alué Abraámi 'lige Isaki 'lige Akobo alé 'pa rewagachi mochigo jipe Onorúgame 'yuga, alué bakiá napu suwile 'we 'ya napu'lige ta'chó o'chérachi Moisesi. ");
INSERT INTO tacNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Onorúgame níriká tabilé 'wesi suwígame kéré. ");
INSERT INTO tacNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","A'lígeko jaré e'wélala alué Moisesi rejchólila benírame anele: ―Mué, benírame, 'la bijchiá ju. ");
INSERT INTO tacNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Alésíko 'ma tabilé aminabi rukele alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Esúsika rukele alué e'wélala: ―'Émika ¿chonigá regá aní Onorúgamete julárigame pe alué Rabí rijimala ko alué Rabí 'we 'ya ajtígame? ");
INSERT INTO tacNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Aka alué bo'né Rabí osáleché alé osilichi Onorúgame Wikálala: Alué Onorúgameka anéturu alué wa'lula ne'chí nuleme: «Asagá ne 'yuga jena wajtoná ");
INSERT INTO tacNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","napusí ne 'ma umérasa mué saíla.» ");
INSERT INTO tacNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Aka alué Rabí osálige'é 'wa'lula ne'chí nuleme» anime, 'liko alué Onorúgamete julárigame abé najtékame ju me'tigá Rabí. ");
INSERT INTO tacNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","We'ká ralámuli gepua mochile, 'lige alué Esúsika anele alué benírame: ");
INSERT INTO tacNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―'We a'lá 'nátaga alué 'yuga napu ju ra'íchali rejcholi benírame napu Moisesi a'rele 'we 'ya, alueka 'we riólame ju i'weli o'páchaga e'yénaga, 'lige najkime ju napurigá 'la niraga repóriwa alemi we'ká riógachi. 'Lige mochínilime ju alé napu mochime ju alué e'wélala najtékame nóchali nígame alé u'kuchí re'obachi «sinagoga» rewégame, 'lige najkime ju napurigá 'la semáriga kógiwa bilénami wa'lú go'achi. ");
INSERT INTO tacNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","'Ma bujeme ju galí alué umugí gunámakame. We'lisi jame ju Onorúgame tania iwérali re'obachi we'lisi napurigá pe a'boi najkime ju napurigá suwábaga ralámuli etémala. Nobi alueka abéchigo wa'lú gastigo narémalagó. ");
INSERT INTO tacNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Esúsika etele alué 'we enomígame ralámuli mochichi enomí alé gajónichi alé wa'lú re'obachi Onorúgame galila, ");
INSERT INTO tacNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","'lige etélechigó bilé mukí gunámakame 'we resiti pe u'kabi enomígame suwábaga mochichi napu ekí enomígame nile, pe okabi ejchirúligame enomí nile 'we pee najteme. ");
INSERT INTO tacNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","A'lígeko alué Esusi anile: ―'La bijchiá ye mukí gunámakame 'we resítiri tabilé we'ká enomígame pe oká enomí mochíkuru, pe napu ekí nígame nile. ");
INSERT INTO tacNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Suwábaga ralámuli 'we enomígame ka pe u'kabi mochime 'ínile alué enomí pe rasírigame 'lige ye mukika 'ma nejí suwábaga napu ekí nígame nile. ");
INSERT INTO tacNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Esusi abiena etélechigó jaré ralámuli ra'icha mochigo alarigá níligo alué wa'lú re'obá Onorúgame galila, 'lige aliena semati níligo alué e'wele rejté alué wa'lú re'obá newárigime, 'lige 'we semati níligo alué suwábaga tábiri napu uchúchale 'lige napu jáwale ralámuli alé pachá re'obachi napu ralámuli a'pime nile Onorúgame. 'Lige Esúsika anile: ");
INSERT INTO tacNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Sebámala bilé rawé napu'lige ye wa'lú re'obá Onorúgame galila 'ma gajunáwili ju, suwábaga ye rejté napu eté 'emi wa'lú re'obá newárigime wijchí mochímala gajuga. ");
INSERT INTO tacNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","A'liko rukéliru alué Esusi: ―Mué Wa'lula, ¿chiéniko gajunáwili júkó ye wa'lú re'obá? ¿Churigá 'la machiboa 'ma sebamio raweli gajunáwili ko ye wa'lú re'obá? ");
INSERT INTO tacNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Esúsika nejele: ―'We a'lá 'nátaga mochiwa napurigá tabilé 'wesi 'yégamala se'nú ra'íchali ruigá napurigá oyéramala 'emi. E'yénamala we'ká ralámuli ichúrimi ra'laga anisia: «Ne júkuru 'la bijchiá Onorúgamete julárigame. 'Ma seba raweli napu 'emi gu'írimili nílige ne.» Alarigá animela alué ralámuli, nobi 'émika tabiléchigo bijchígiwagó. ");
INSERT INTO tacNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","―'Lige napu'lige ruyésiga 'emi nakó nerúlimio, tabilé majawa napugiti nerúlimili kame nakoli bajchá, nobi tabiléchigo 'cho suwibámili nímalagó ye gawí a'lige. ");
INSERT INTO tacNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","'Lige aminabi ruwile alué Esusi: ―Alué we'ká ralámuli bilena gawichí ejperégame nakómala chebilena gawichí ejperégame sayega. ");
INSERT INTO tacNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","A'wágame nokimela ichúrimi gawichí, 'lige abiena gurúlamala go'ame, 'lige nerúlamala naulítiri, 'lige 'pa rewagachi 'we e'karúgame chátiri buyame etémala ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","› Tabilé 'cho alarigá ikichi suwábaga ye tábiri, 'we najátawili ju 'emi 'lige 'ma cha'piboli ju 'emi. 'Lige 'ma o'toboli ju 'emi e'wérali rukemia ra'íchali alé u'kuchí re'obachi «sinagoga» rewégame, 'lige 'ma mo'áwili ju 'emi galírale ne'chí oyérame kóriká, 'lige 'ma o'toboli ju 'emi alué e'wélala mochígichi ra'íchali gatélachi. ");
INSERT INTO tacNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","A'lige alé o'tosuga 'emi, 'émika 'la sébali ma'chígime rupoa alarigá ko ne. ");
INSERT INTO tacNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tabilé e'karúganti na'tawa bajchabé churigá nemítiká, ");
INSERT INTO tacNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ne 'nalina 'la nejímala semátiri 'nátili churigá nemímala 'emi. A'liko tabilé umérowa 'emi. ");
INSERT INTO tacNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","'Lige o'toboli ju 'emi napurigá galírale mo'awa 'emi o'nólate 'lige 'emi e'yélate, 'lige 'emi ba'chílate 'lige 'emi rijimálate, 'lige 'emi 'yuga oyame. 'Lige jaré 'emi 'ma me'liboli ju. ");
INSERT INTO tacNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","'Lige suwábaga ralámulite gichíwili ju 'emi ne'chí oyérame kóriká, ");
INSERT INTO tacNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","nobi neka 'la senibí repuka asimélagó 'emi. ");
INSERT INTO tacNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","'La anachásaká 'emi rekó gichilie a'lígeko 'la sebámala 'emi rewagachi. ");
INSERT INTO tacNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","› Napu'lige 'emi etea noligá mochigo sontalo jena Rusaleni we'ká riógachi, machiboa 'ma pe yati gajunáwili ko alué we'ká galí. ");
INSERT INTO tacNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","A'lígeko suwábaga 'emi napu mochí a'lige alé Jurea anilichi gawichí 'ma júmasiwa re'pá rabomi. 'Lige suwábaga 'emi napu mochí a'lige jena Rusaleni, 'ma júmisiwa. 'Lige suwábaga napu mochí a'lige alé 'mi jami, tabilé ku sboa jena Rusaleni ");
INSERT INTO tacNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","napugiti 'we enárélamala a'lige alakichi. A'lige 'ma alarigá ikimela suwábaga napurigá aní wa'lú apélichi chujkúgame osilí Onorúgame ra'ichálila alué apeli kabítigame. ");
INSERT INTO tacNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Resía umugí alué napu a'lige rawé rojpega mochígichi, 'lige alué umugí napu u'kuchí 'kúchigame bijí chi'ime a'lige rawé, napugiti 'we resíriká nímala a'lige rawé jena wijchimoba. Onorúgame alarigá elámala. ");
INSERT INTO tacNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ajaré siparínate ejchega me'liboa, 'lige jaré 'ma cha'piboli ju 'lige bochígimi gawichí o'toboli ju. 'Lige alué tabilé ralámuli israelita 'ma neyúriga mochímala jena Rusaleni napusí seba raweli napu'lige Onorúgame 'ma tabilé gu'írimala semátiri na'tálilate alué ralámuli tabilé israelita. ");
INSERT INTO tacNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","› 'We e'karúgame chátiri buyámala alé re'pá rayénalichi 'lige mechachi 'lige so'pilichi. Alueka ruwime nímala 'ma gajumio gawí. 'Lige jena wijchimoba we'ká ralámuli we'kaná riógame tabilé machimela chonigá ala'sió a'lige rawé, 'lige 'we majámala ená 'sichi a'wágame rolochi alué wa'lú ba'wí jena wijchimoba ilígame. ");
INSERT INTO tacNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","'Lige alué we'ká ralámulika 'ma rekupámala majaga etega alarigá ikíichi ye gawí napugiti a'wágame nokimémpá rayénali, 'lige mechátiri, 'lige so'plítiri alué 'pa rewagachi mochígame. ");
INSERT INTO tacNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","A'lígeko etémala 'emi ne'chí aleka enágichi ne re'kínasia bilena nolichi wa'lú a'walí niga 'lige ra'ósali ne napu nawágame ju 'pa rewagáchika napurigá rió neraga. ");
INSERT INTO tacNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Napu'lige ya 'ma alakichi, 'we a'lá iwériga mochiwa 'lige buigá mochiwa napugiti pe a'kinana 'ma tabilé resí ikiá mochímempá 'emi. ");
INSERT INTO tacNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Abiena regá anele: ―'Emi 'la machí napu'lige rojá ");
INSERT INTO tacNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","yáachi, a'kinana sebamio bamunúsili. ");
INSERT INTO tacNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","A'chigóriga napu'lige 'emi etea i'kirú ikichi alé 'pa rewagachi, 'we a'lá machiboa 'emi pe a'kinana uché ku nawamio ne. ");
INSERT INTO tacNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","› Neka 'la bijchiá ruwí, suwábaga alarigá ikimeo bajchabé ta'chó suwichi ralámuli jipe ejperégame. ");
INSERT INTO tacNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Rewagá 'lige gawítiri siné rawé 'ma tabilé ne ikimela, nobi ne nila ra'íchalika tabiléchigo siné we'kámalagó. ");
INSERT INTO tacNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","› 'We 'la 'nátaga e'yénawa 'emi, tase 'nátaga e'yénawa bajílime 'lige e'karúgame tábiri mélime napu nerú jena wijchimoba, a'lige rawé tase sanátiga sebámala ne napu 'emi mochí napu'lige 'emi tabilé 'nátaga mochígichi ");
INSERT INTO tacNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","napugiti yati neraga nawámili kame ne 'lige suwábaga ralámulite etéwili kame ne. ");
INSERT INTO tacNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","'We 'la 'nátaga mochiwa Onorúgame 'yuga ra'icha, a'walí tania napurigá 'emi tabilé che ikimela napu'lige e'karúgame tábiri cha ikichi jena wijchimoba, napurigá 'la simámala 'emi tabilé chijúniga alé napu asimela ne, ne napu nawágame ju 'pa rewagáchika napurigá rió neraga ―alanele Esusi alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Esúsika rawé 'we benírame nile alé wa'lú re'obachi Onorúgame galílachi, 'lige rukoka simime nile alé na'lébori nasípari Olibo rewégame rabó. ");
INSERT INTO tacNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","We'ká ralámuli simíbame nile senibí be'á alé wa'lú re'obachi gepumia Esusi ra'ichálila. ");
INSERT INTO tacNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","'Ma a'mulipi enale raweli sebamia Páskua anilime omali napu baní go'ame nile tase lebarura ajchigá newárigime, ");
INSERT INTO tacNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","'lige alué e'wélala balé 'lige alué we'ká rió ra'íchali rejcholi benírame ralámuli napu Moisesi a'rele 'we 'ya, 'nátale churigá 'la níliga Esusi me'liá 'we nasoka napugiti 'we majáligime alué we'ká ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","'Liko alué Remónisi alawala chátiri bajkile alé Jurasi Iskariote sa'pálachi, alué Jurasi napu nile bilé alué makué oká rió nulame Esusi nochálalachi. ");
INSERT INTO tacNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","'Lige alué rioka simile e'nemia alué balé e'wélala, abiena alué e'wélala sontalo wa'lú re'obachi tebume Onorúgame galila, 'lige alé sebasa anele: ―Ne 'la nejkúrimala cha'piá alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","'Lige alué ralámulika 'we ra'sálále, 'lige enomite najtétimoríle alué Jurasi. ");
INSERT INTO tacNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Alésíko Jurasi chojkile 'nata: «¿Churigá chiéniko 'la nímalawé cha'piá Esusi tase etériga ralámuli?» regá 'nátale. ");
INSERT INTO tacNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Sébale raweli Páskua omégachi baní go'yachi tase kawali ro'igá newárigime. A'lige rawé napu ekiná riógachi galírale me'liame nile bilé bo'á Onorúgame kógimia. ");
INSERT INTO tacNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","'Lige Esusi júlale alué Pegro 'lige Juani, regá anegá: ―Simíbaga, newawa alué go'ame ramué go'yame o'rako alí chónachi. ");
INSERT INTO tacNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","'Lige alué oká rioka rukele: ―¿Koche 'la nítéko alué go'ame newalía? ");
INSERT INTO tacNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","'Lige alué Esúsika regá anele: ―Napu'lige 'emi sebasa alé we'ká riógachi, alé najtepámala 'emi bilé rió sikolí majtochi iligá enágame ba'wí ro'ágame, 'lige 'emi alué rió najátawa napusí seba bilena galichi, 'lige sebámala bilena galírale osámana ilígame, ");
INSERT INTO tacNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","'lige anewa 'emi alué rió galí nígame ne napu ju benírame najkió bilé galí napurigá go'mé ne 'emi makué oká rió 'yuga o'rako alí chónachi. ");
INSERT INTO tacNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","'Lige 'emi alué galí amoba ilígime 'nalina 'yáwili ju abiena 'ma 'we a'lá pechítigame, 'lige alé newawa 'emi alué go'ame. ");
INSERT INTO tacNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","'Lige alué rioka simíbale 'lige rewale alué rió sikolí majtochi iligá enágame napurigá anílige alué Esusi 'lige najátale. 'Lige jímole bilena galichi osámana ilígamechi, 'lige newale alé alué go'ame a'lige rawé Páskua omégachi go'yáame. ");
INSERT INTO tacNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Napu'lige 'ma wajsigá ilígichi go'ame 'lige 'ma ro'áriga ilígichi, sébale Esusi go'mea, alé re'lé ilígame mésachi kilí bo'íbale gayena sekate machoka wijchí, alué makué oká rió nulame 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","'Lige anile Esusi: ―Neka 'we najkié napurigá napuíka go'poa ramué ye go'ame jipe alí chónachi Páskua omégachi bajchabé ta'chó mukiá ne. ");
INSERT INTO tacNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Pe jipe go'sá go'ame 'emi 'yuga, we'lisi tabilé uché ku napuíka go'poa napusí 'ma 'la sébali ikisá napu najkí Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","'Lige cha'pile alué baso i'wilí ba'wila rekútame ro'ágame, 'lige 'ma cheliera 'yasa Onorúgame, regá anele bo'né benírame: ―Nachútaga bajisi 'emi ye i'wilí ba'wila rekútame. ");
INSERT INTO tacNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Neka 'la ruwí, tabilé uché bajimia ne napusí 'ma 'la sébali ikisá napu najkí Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pe nujubapi 'wile alué baní tabilé kawali ro'igá newárigime 'lige wa'lú cheliera 'yasa Onorúgame, chi'wánale alué baní 'lige 'yale alué makué oká rió, 'lige anele: ―Go'sí 'emi. Ye baní ne sa'pala ju. Yeka ruwime ju 'ma me'liboli ko ne, 'lige mukimeli ko ne 'emi neraga. 'Lige 'emi 'la senibí a'chigóriga nokoboa a'kinana ne mukusá ne'chí nélegá. ");
INSERT INTO tacNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","'Lige abiena 'wile alué baso i'wilí ba'wila ro'ágame napu rekútame ju, 'lige anile: ―Ye pachágana manígime i'wilí ba'wila ne elalá ju, alué elá napu ma'chínamili ju ne me'liá, 'lige ne mukugá wa'lú gu'írimili ju 'emi ralámuli. Regá gatele Onorúgame ralámuli jipe ejperégame gu'írimia napurigá 'la bi'wígame alawégame nímala. 'Lige a'lá sébali alarigá ikimeli júkuru ne napurigá aní Onorúgame nila ra'íchali. ");
INSERT INTO tacNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","'Lige alué rió napu gu'írimili ju ne saíla ne'chí cha'piá jena ajtíkuru jipe ramué 'yuga jena mésachi. ");
INSERT INTO tacNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ne Esusi napu nawágame ju 'pa rewagáchika napurigá rió neraga mukumeli júkuru ne napurigá najkí bo'né Onorúgame, 'lige resía alué rió napu gu'írimili ju ne saíla ne'chí cha'piá. ");
INSERT INTO tacNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Alésíko chojkile rukea a'bopi alué makué oká rió chieri níliga gu'írimili Esusi saíla Esusi cha'piá. ");
INSERT INTO tacNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Alésíko chojkile alué makué oká rió ra'icha 'we bochí anigá a'pílipi e'wélala neraga mochíniliga. ");
INSERT INTO tacNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","'Lige Esúsika anele: ―Alué e'wélala selígame alé bilena wa'lú gawichí nulame, alueka 'we nochárime ju alué ralámuli napurigá ajágame, 'lige alué ralámuli e'wélalaka 'la semáriga gu'írame mayeme ju alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","'Lige 'emi ralámulika tase alarigá niwa. Alué bilé rió abé najtékame ka, alueka nímili júkuru napurigá alué bilé rió re'malí nóchame tabilé gunarume. Alué nulame ka nejkúrime nímili júkuru napurigá pe bilé nóchame. ");
INSERT INTO tacNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Chieri júkó abé najtékame, alué mésachi asíbame go'ame go'mea, alué chalá go'ame ro'ame? ¿Tacha alué mésachi ajtígame abé najtékame ju? Neka pe napurigá bilé rió ju go'ame ro'ame. 'Émichigó a'chigóriga niwa napurigá ne. ");
INSERT INTO tacNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","'Émika senibí ne'chí 'yuga e'yénale ne'chí resí olánilichi ne saíla. ");
INSERT INTO tacNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Neka alekeri 'yámala 'emi a'walí napurigá ne O'nola 'yale ne'chí ");
INSERT INTO tacNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","napurigá go'mela 'emi 'lige bajímala alé ne nila mésachi mochiga napu'lige ne uché ku sebasa, 'lige alé mochíbamala 'emi mutélachi napu ju e'wélala mochime napurigá gatémala 'emi ra'íchali alué makué okaná chojkégame ralámuli israelita 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Alésíko alué Esusi Simoni 'yuga ra'íchale regá: ―Mué Simoni, alué Remónisika tala resí olániliga 'emi, wejpisóniliga napurigá ri'ligó wejpimókime napurigá a'rémala 'emi oyeria ne nila ra'íchali rejcholi. ");
INSERT INTO tacNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Neka 'wéchigo tánigo Onorúgame napurigá tase siné a'rémala mué bijchigia 'la gu'írilime ko mué Onorúgamete napu'lige 'ma chajkena o'tosuga mué alué Remónisite. Napu'lige 'ma ku uchéchigo ku oyérasa mué ne'chí, 'lige gu'íriwa mué gompaniérola ruigá wa'lú a'walí nígame ko Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","'Lige Pégroka anele: ―Mué Wa'lula, neka aba'lá simé olá mué 'yuga rekó galírale bajchalíe, rekó me'liruge. ");
INSERT INTO tacNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","'Liko Esúsika nejele regá anegá: ―Pegro, be'lí be'á napu'lige ta'chó sinachi o'tolí, baisá 'yegámala mué ta machióriká ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","'Lige Esusi rukele aba alué makué oká rió: ―¿'We rokáré bilé tábiri napu'lige júlige ne 'emi tabilé o'ká sibula tabilé enomítiri, 'lige tabilé pabega aká nujubami akarálime? 'Lige alué ralámulika nejele: ―Tabilé tábiri rokáré. ");
INSERT INTO tacNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","A'lígeko Esusi regá anele: ―Jípeko 'la o'toboa chiwela, 'lige enomítiri. 'Lige bilé 'emi tabilé nílasaká siparina 'liko ralinewa bo'né o'páchala, siparina raliboa 'lige. ");
INSERT INTO tacNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Neka 'la ruwí: Bijchiá me'liboli ju ne napurigá aní alué osilí Onorúgame nila 'we 'ya newárigime ta'chó ochérachi ne, regá anime: «'We resí oláwili ju alué rió, napurigá pe apiépiri rió cha 'sime alarigá etéwili ju.» Alarigá ruwí alué osilí, 'lige 'la bijchiá alarigá ikimeli ju napurigá ruwí alué osilí Onorúgame nila. ");
INSERT INTO tacNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","'Lige bilé alué makué oká rioka anele: ―Mué Onorúgame a'walila nígame, jena bi'tí oká siparina. 'Lige Esúsika regá anele: ―A'lá ju. ");
INSERT INTO tacNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","'Lige Esusi simile Rusaleni na'lebo rabori Olibo rewégachi napu simime nile bo'né Onorúgame 'yuga ra'ichamia, 'lige alué 'yuga benime najátale. ");
INSERT INTO tacNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","'Lige sebasa alé rabori anele: ―Tániwa iwérali Onorúgame napurigá ta neyúrimala Remónisi na'tálila. ");
INSERT INTO tacNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","'Lige Esusi alé a'mibemi waná simile, 'lige alé chojkóbisiga ilíbale Onorúgame 'yuga ra'ichamia, 'lige Onorúgame 'yuga ra'icha regá anele: ");
INSERT INTO tacNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","―Mué O'nó, neka tabilé najkí napurigá ralámuli resí olámala ne'chí. Mué abalarigá najkisáká, abirigá resí ikiméleké ne. ");
INSERT INTO tacNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","'Lige pe yati neraga ma'chínale bilé santo ánjeli alé 'paka rewagáchika simígame a'walí 'yamia Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","'Lige Esusi we'ká 'nátaga resí níliga, 'we iwégame ra'íchaga Onorúgame 'yuga 'we chilénale napieri elá 'lige wijchí pachule. ");
INSERT INTO tacNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","'Lige ku o'weti ilísisa alé napu chojkóbaga ilile Onorúgame 'yuga ra'icha, 'lige ku simile napu mochile bo'né nochálalachi nulame, 'lige 'ma okókame rewale, 'ma okole resibaka chálagá we'ká 'nátaga. ");
INSERT INTO tacNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","'Lige anele: ―¿Chonigá okoka bi'tirúché 'émika? Mochísiga o'weti, ra'ichawa Onorúgame 'yuga, iwérili tániwa napurigá ta neyúrimala Remónisi nila 'nátili. ");
INSERT INTO tacNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Esusi bijí ra'icha ilígichi, alué Jurásika napu nílige bilé alué makué oká rió Esusi nila nóchali nulame we'ká ralámuli 'yuga sébale alemi. 'Lige a'bé nawile Esusi, banachí chu'migá repórile napurigá nokame nile alué ralámuli, ");
INSERT INTO tacNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","'lige Esúsika anele: ―Mué Jurásika ne'chí chu'miá banachí pe ruigá 'smi mué ne ko Esusi napu 'yaga e'yena ne saíla, ne alué rió napu nawágame ju 'pa rewagáchika napurigá rió neraga. ");
INSERT INTO tacNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Alué Esusi benírameka etesa alarigá oliachi Esusi, regá rukele: ―Mué Onorúgame a'walila nígame, ¿pala sásiwa ramué siparínate? ");
INSERT INTO tacNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","'Lige bilé alué Esusi nila nóchalichi nulame rejpúnale najkala wajtoná ilígame alué rió wa'lula balé 'yuga nóchame. ");
INSERT INTO tacNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","'Lige Esúsika anele: ―¡Tase che olawa, a'rewa 'emi! 'Liko Esusi ku na'chúchale alué rió najkala. ");
INSERT INTO tacNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","'Lige Esusi anele alué e'wélala balé abiena alué e'wélala sontalo alué wa'lú re'obá Onorúgame galila tebume abiena alué e'wélala rió ralámuli jurío nuleme, napu sébale o'tomea alué Esusi: ―'Émika we'ká siparina, igútiri o'ká si. ¿Chigórigame ju ne? ");
INSERT INTO tacNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Napu'lige ne nabí rawé ajtígachi alé wa'lú re'obachi, 'lige tase siné che olá 'emi ne'chí. 'Lige jípeko a'má seba raweli napu'lige 'emi resí olámala ne'chí. 'Ma umérilia 'emi resiti 'nátalite. ");
INSERT INTO tacNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","'Lige alésíko cha'píliru alué Esusi 'lige o'tóliru alé wa'lula balé bejtélachi. 'Lige alué Pégroka najátasia enale pe mejkabeka. ");
INSERT INTO tacNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","'Lige alé ra'pichí nasipa na'yasa mochíbale alué saíla, alemi mochíbale sujkáliga, Pegro abiena alemi asíbalechigó. ");
INSERT INTO tacNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","'Lige bilé mukí go'ame newame etesa alemi ajtígachi Pegro sujkáliga, kilí ilíbale e'negá, 'lige anile: ―Neka eteme ke ye rió Esusi 'yuga eyénachi. ");
INSERT INTO tacNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","'Lige alué Pégroka 'yégale regá anigá: ―Mué mukí, neka tase machí alué rió. ");
INSERT INTO tacNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","'Lige pe nujubapi bilé rió etele alué Pegro, 'lige anele: ―Ne abiena eté mué Esusi 'yuga eyénachi. 'Lige Pégroka nejele: ―¡Mué rió, neka tase 'yuga eyene alué rió! ");
INSERT INTO tacNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pe nujubapi uché bilé rió anile: ―'La bijchiá ye rioka Esusi 'yuga eyéname ju, napugiti napurigá Galilea rewégachi ejperégame, alarigá ra'íchame kame. ");
INSERT INTO tacNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","'Lige alué Pégroka regá anele: ―¡Mué rió, neka tase machí tachiri olagá aniá mué! Pe aba'lige yati bijí ra'icha ajtígachi alué Pegro, sinale bilé o'tolí. ");
INSERT INTO tacNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","'Lige alué Esúsika gu'lile 'lige e'nele alué Pegro. 'Lige alué Pégroka nélále alarigá anésiga alué Esúsite rapakónala alí, 'yegamio baisá alué Pegro ta'chó sinachi bilé o'tolí. ");
INSERT INTO tacNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","'Liko alué Pegro ma'chínale alé 'minami, 'we chálagá nalale. ");
INSERT INTO tacNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Alué ralámuli Esusi tebúkame 'we gawélale alué Esusi 'lige a'kuérami chibi olale abichilubi 'we gawéliga. ");
INSERT INTO tacNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Busila bulesa ba'nasólite abichilubi 'we chibi olale 'lige rukele: ―Machígobá ¿chieri 'siá nejchoa? ");
INSERT INTO tacNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Aminami we'ká e'karúriga chíbiriga anele. ");
INSERT INTO tacNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","'Lige che'lachi napuíle e'wélala ralámuli jurío nuleme, abiena alué e'wélala balé, 'lige alué Moisesi rejchólila benírame, 'lige o'tóliru alué Esusi alé ra'íchali gatélichi. ");
INSERT INTO tacNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","'Lige alé iwégame rukéliru: ―Ruwí: ¿Pala mué ju nejkúrimili Onorúgamete julárigame? 'Lige alué Esúsika nejele: ―Rekó anisá ne «ne ju», 'emi tase bijchígimala, ");
INSERT INTO tacNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","'lige ne rukisá 'emi chieri ka ne, 'lige tase ruwimela 'emi chieri ka ne. ");
INSERT INTO tacNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ne napu nawágame ju 'pa rewagáchika napurigá rió neraga, jípesíko asimela ne alé 'we najtechi napu ajtí alué Onorúgame wa'lú a'walí nígame. ");
INSERT INTO tacNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","'Lige suwábaga alué ralámuli regá rukele: ―¿'Liko mué Onorúgame Inolá korime ke aní mué? 'Liko Esúsika regá nejele: ―Ju, aka 'emi 'we a'lá ma'chígime aníché a'boi. ");
INSERT INTO tacNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","'Liko regá anile alué ralámuli: ―Ya 'ma 'la sébali machirúke'é, tase rokáré uché bilé rió machime napugiti bo'né 'la sébali ruyame. ");
INSERT INTO tacNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Alésíko suwábaga alué e'wélala jásele 'lige o'tole Esusi alé napu asale alué selígame Pilato anilime, napu nóchali 'yárigame nile alué romano e'wélalate napurigá alé Jurea nulámala. ");
INSERT INTO tacNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","'Lige alé chojkile e'chewa regá anegá: ―Ramueka etelia ye rió ramué ejperélachi ramué nila gawí bo'ígichi se'nú ra'íchali ruyachi, tase najtétiwará ramué alué wa'lula gobierno Roma nulame, abiena ruwí alué Onorúgamete julárigame ka, 'lige aminami wa'lula gobierno korí. ");
INSERT INTO tacNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","'Liko rukele alué selígame Pilato: ―¿Mué ju wa'lula rey ralámuli jurío nuleme? Esúsika regá nejele: ―Ju, ne ju. ");
INSERT INTO tacNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Alésíko alué Pilato ruyele alué wa'lula balé abiena alué uché jaré ralámuli regá anegá: ―Ne níriká, tabilé cheri kanti káwé ye rió. ");
INSERT INTO tacNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","'Liko alué ralámulika aminabi anele 'we a'wágame ra'íchaga: ―Tabilé 'la ra'íchali beniri ralámuli jena Jurea rewégame gawí bo'ígichi ejperégame. Alé Galilea anilime gawí bo'ígichi chojkile sineko, 'lige jípeko 'ma jeka Jurea seba. ");
INSERT INTO tacNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","'Lige alué Pilato akisá alé Galilea anilichi chojkíligo, rukele pala Galilea bejtégame ka alué rió Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","'Lige ruyésiga Galilea bejtégame ko Esusi, 'liko nulale o'tóniliga alé napu asale alué selígame Erore napu nile selígame alé Galilea anilime gawí bo'ígichi nulame. A'lige rawé eyénale alué wa'lula selígame Erore alé Rusaleni rewégachi. ");
INSERT INTO tacNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","'Lige alué wa'lula selígame Erore Esusi etesa 'we ra'sálále. Abé 'yabesi we'ká rawé 'we eténilia asálige alué Esusi, napugiti akéligime Onorúgame a'walila nígame ko alué Esusi. 'Lige 'we eténile asálige pala 'la bijchiá ko a'walí nígame ko. ");
INSERT INTO tacNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","'Lige we'ká ra'íchali rukele 'lige alué Esúsika tase nejele. ");
INSERT INTO tacNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Abiena alé jale alué e'wélala balé abiena alué ralámuli ra'íchali rejcholi benírame alué Moisesi a'rélala, 'lige 'we iwégame e'chewa jale. ");
INSERT INTO tacNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","'Liko alué selígame Erore 'lige abiena alué sontalo chojkile gawelia. 'Lige o'pachátarile alué o'pacha 'we semati napu alué bo'né selígame Erore o'pachátame nile, 'lige pe gawéliga lolale. 'Lige alué selígame Erore nulale napurigá ku alé Pilato ajtígachi o'toboa alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","'Lige alésíko alué selígame Erore 'lige selígame Pilato 'we a'lá gompaniero gayénale, 'yabé bajchabé raweka na'áuka járome nílige. ");
INSERT INTO tacNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","'Liko alué selígame Pilato bayele alué e'wélala balé, abiena uché jaré rió e'wélala, abiena we'ká ralámuli, ");
INSERT INTO tacNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","'lige anele: ―'Émika akiná a'pá ye rió ra'íchali najsibuga eyéname kóriká. 'Lige neka 'ma 'la rukékuru 'emi akériga, 'lige ne níriká tabilé se'winá 'síkame ká'é ye rió napurigá 'emi e'chewámala ye rió ra'íchali najsibuga eyéname ko. ");
INSERT INTO tacNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nibilé alué selígame Erore níriga tabilé chieri kame ká'é napurigá me'liboa ye rió. ");
INSERT INTO tacNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Pe nulámala ne napurigá wejpisópua ye rió, 'lige pe yati ku elímala ne napurigá simela a'minami ―anile Pilato. ");
INSERT INTO tacNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Napu'lige Páskua omégachi sebasa senibí bamí, alué Pilato ma'chí pame nile bilé rió galírale bajchárigame, alekeri pe wejpisosa a'rémoríle alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Iligá alué we'ká ralámuli tase elale, 'lige chojkile ne'oa regá anegá: ―¡Tase pe wejpisosa a'rewa alué rió! ¡Barabasi 'nalina ma'chí pápua! ");
INSERT INTO tacNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Alué rió Barabásika galírale bajcháriga asale napugiti nakó o'wínaligime alé Rusaleni we'ká riógachi abiena me'álige bilé rió. ");
INSERT INTO tacNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato tabilé bajchánile galírale alué Esusi, alekeri uchéchigo siné ruwile pe yati ku elimio napurigá 'minami simela, ");
INSERT INTO tacNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","'lige alué ralámulika abéchigo a'wágame ne'ole 'liko regá anigá: ―¡Gulusichi ujchawa! ¡Gulusichi ujchawa! ");
INSERT INTO tacNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","'Lige Pilato uchéchigo regá anile, alésíko 'ma baisá nile: ―¿Tachiri chátiri nasibule ko ye rió? Ne níriká tabilé se'winá 'síkame ju ye rió napurigá me'liboa. 'Lige neka pe nulámala napurigá wejpisópua, 'lige pe yati ku elímala ne napurigá simela 'minami. ");
INSERT INTO tacNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","'Lige alué ralámulika abichilubi 'we nulale e'wele ne'oka napurigá gulusichi ujchawa alué Esusi. 'Lige 'we ne'ole alué ralámuli abiena alué e'wélala balé, arigá 'ma umébale anigá napurigá najkile a'boi. ");
INSERT INTO tacNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","'Liko alué Pilato e'wale napurigá najkile alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","'Liko ma'chí pale alué uché bilé rió galírale bajchárigame napu alué ralámuli najkile ma'chí pasime napu nakó o'wínalige alé Rusaleni we'ká riógachi abiena napu me'álige bilé rió. 'Liko alué Pilato elile alué e'wélala balé napurigá alarigá olámala napurigá najkile a'boi. ");
INSERT INTO tacNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Napu'lige sontalo 'ma 'yuga e'yéniga Esusi gulusí majtóriga alé gulusichi ujchamia, 'lige bilé rió cha'pile alemi eyéname kóliga Siréneka nawágame Simoni rewégame napurigá gu'írimala gulusí majtórilichi. 'Lige majtóriliru napurigá guwana enámala majtoga napu Esusi enale. ");
INSERT INTO tacNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","'Lige we'ká ralámuli e'yénale najátasia, abiena we'ká umugí e'wele nalasia e'yénale chálagá na'temaka Esusi o'towachi. ");
INSERT INTO tacNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","'Lige alué Esúsika e'nele 'lige anele: ―'Emi umugí jena Rusaleni ejperégame, tase nalápua ne'chí na'temaka, pe iligá 'emi a'bopi na'temaka 'nalina nalápua abiena 'emi a'boi 'kúchila. ");
INSERT INTO tacNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Sebámala raweli 'we resiti raweli tase anachárume 'lige alué umugí chi'ime a'tanégame abiena ojtabégame alueka uchérajpé abé resí nílimala, 'lige ta'mé 'we rasigá resí nílimala alué umugí tabilé 'kúchigame ka. ");
INSERT INTO tacNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Abiena anile: «Alué we'ká ralámuli najkimela napurigá amoba gajúmala re'pá jágame rabó nokogá.» «Abiena najkimela napurigá na'póliwa re'lé jágame rabote.» ");
INSERT INTO tacNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","'We cha nokame ju ye ralámuli, ne 'la Onorúgamete julárigame kachi chiena 'we resí oliá ne, 'lige a'kinana abéchigo resí oláwili júkuru 'emi. ");
INSERT INTO tacNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Abiena 'yuga e'yénale oká rió gulusí majtórigachigó 'we i'nílime me'limea alué Esusi 'yúrigachigó. ");
INSERT INTO tacNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","'Lige sebasa bilena rabó Anayáwali Mo'ola rewégachi, gulusichi ujcháliru Esusi me'limea, nasipa ujcháliru. ");
INSERT INTO tacNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","'Lige alué Esusi alé re'pá gulusichi ujchásiga Onorúgame 'yuga ra'íchale regá: ―Mué O'nó, pe rekó e'káwagó ye ralámuli rekó lonokachi, tase machí resí nokao ye ralámulika. Alésíko alué sontáloka chojkile re'ea chieri meta alué Esusi o'páchala. ");
INSERT INTO tacNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","'Lige alué we'ká ralámuli alemi jale e'negá, abiena alué e'wélala ralámuli jurío nuleme, 'lige 'we gawélele alué Esusi, regá anegá a'bopi: ―Esusi we'ká ralámuli gu'írile, jípeko bo'nepi neyúsamale ke 'la bijchiá Onorúgamete julárigame nísaká. ");
INSERT INTO tacNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Alué we'ká sontalo abiena gawélele alué Esusi a'bemi jaga i'wilí ba'wila pee a'wágame 'we cho'kógame owigá ");
INSERT INTO tacNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","regá anegá: ―Mué Wa'lula, rey níriká ralámuli jurío nuleme, bo'nepi neyúsiwagó. ");
INSERT INTO tacNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","'Lige alué sontáloka ujchale bilé rabileta osirúgime alé gulusichi alé mo'rákana napu Esusi chujkule regá anime: «Ye ju wa'lula rey, ralámuli jurío nuleme.» ");
INSERT INTO tacNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Abiena alué bilé rió cha 'sime alé chujkúgame 'we gawélele, regá anegá: ―¡Mué níriká Onorúgamete julárigame, bo'né neyúsiwa, abiena gu'íriwa ramué napurigá neyúsiwa! ");
INSERT INTO tacNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","'Lige alué uché bilé rioka ne'óchale alué uché bilé rió, regá anegá: ―Mueka ¿tacha majawáché alué Onorúgame? Ramueka a'chigóriga me'liboli júkuru napurigá ye rió. ");
INSERT INTO tacNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ramueka asíriga wa'lú gastigo narigíguru, najtétiga napu resí nokarúpá ramué. 'Lige ye rioka tabilé inílame rió júkuru. ");
INSERT INTO tacNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","'Lige alarigá anesa alué rió 'lige Esusi 'yuga ra'íchale. Anele: ―Mué Esusi, 'we a'lá sébali néléwa mué ne'chí napu'lige rewagachi moinasa 'ma 'la sébali olasa jena wijchimoba. ");
INSERT INTO tacNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","'Lige Esúsika regá nejele: ―Mué rió 'we a'lá nirá ne'chí, alekeri jípesíko 'we a'lá sebámala mué ne'chí 'yuga asimea alé 'pa rewagachi. ");
INSERT INTO tacNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","'Lige 'ma rawilichi 'ma chónale rayénali, 'lige chónaga ilíbale bochígimi gawichí. Nasípagana enagá ku rayénale alué rayénali. ");
INSERT INTO tacNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Napu'lige chóniga ilibasa, alué chiní alé wa'lú re'obachi Onorúgame galílachi chujkúgame nasípagana chi'wale. ");
INSERT INTO tacNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","'Lige Esusi a'wágame ra'íchaga regá anele Onorúgame: ―Mué O'nó, 'ma ku o'tobógó ne alawala, 'lige 'we 'la repúpua. Alarigá anisá, 'ma mukule. ");
INSERT INTO tacNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Napu'lige alué sontalo wa'lula we'ká sontalo nuleme etesa alarigá ikisá, 'lige 'we a'lá niraga ra'íchale Onorúgame regá anigá: ―'La bijchiá ye rió 'we a'lá rió nile, tase se'winá 'síkame. ");
INSERT INTO tacNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","'Lige alué we'ká ralámuli napu jale etea mukuchi Esusi 'lige we'ká e'karúriga ikichi, 'minami simíbale sulachí o'chosia chálagá napurigá nokame nile a'boi bile ralámuli mukusá. ");
INSERT INTO tacNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Alué we'ká ralámuli napu ekí nile alué Esusi machime, abiena alué we'ká umugí napu si e'yénale Galiléaka Esusi 'yuga, alueka a'nabeka mejkabé jale e'negá alarigá oliachi. ");
INSERT INTO tacNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ajtile bilé rió jurío 'we a'lá rió José rewégame, Arimatea rewégachi ochérigame we'ká riógachi napu nile pachá Jurea rewégame gawí bo'ígichi, alueka bilé wa'lula nile ralámuli jurío nuleme. ");
INSERT INTO tacNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Alué rió Joseka tase najkílige napurigá me'liboa Esusi. Uché jaré e'wélala juríoka 'we najkílige napurigá me'liboa Esusi. Alué Joseka 'we a'lá oyérame nile alué Onorúgame nila rejcholi, 'lige buigá asale bilé rawé napu sebámili nile napu'lige 'ma 'la sébali ikimeli nílige jena wijchimoba napurigá najkile Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","'Lige alué rió simile e'nemia alué Pilato, 'lige lisensia tánale alé gulusichi chujkúgame mukúgame Esusi re'kibumia o'tomea a'minami gatemia. ");
INSERT INTO tacNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","'Lige re'kibusa alé gulusichi chujkúgame, 'lige kabile rojsákame chinichi, 'lige o'tole 'lige rekale bilena ewarárigichi wejtosá rejtechi pachami bajkigá napu ta'chó 'wesi mukúgame gatérigime nile alé. ");
INSERT INTO tacNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","A'lige rawé 'we jigale ta'chó rapagachi alaké yanchi rawé, napugiti rapagásaká 'ma resíbilichi níligame melénala rukuchégame abiena. ");
INSERT INTO tacNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","'Lige alué umugí napu si e'yénale alué Esusi 'yuga Galiléaka, alueka 'la etele alemi alarigáriga gatélichi alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","'Lige ku sebasa alé galírale napu bejtébaga mochile, 'lige gajsalá basule 'we semá júkame alué mukúgame ro'emia alué gajsalá ba'wila, 'lige gajsalá yowí rusule alué Esusi mukúgame ujchemia. 'Lige resíbulichi, resíbale napurigá nulame nile Moisesi nila ra'íchali rejcholi. ");
INSERT INTO tacNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Romíkichi 'we be'á simíbale alué umugí alé napu bo'ile alué Esusi pachá napu rekálirige gatériga. 'Lige o'ká simíbale alué ba'wí 'we semá júkame 'lige alué gajsalá yowí rusurúgame o'ká. ");
INSERT INTO tacNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","'Lige alé ewágachi sébaga, etele chajkena ajtigó rejté napu ajchárigame nile ma'chímanaka 'yériga alé napu rekáliru Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","'Lige mo'ile, 'lige tase rewale Esusi mukúgame alé gatérigime. ");
INSERT INTO tacNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Alésíko kilí jale 'nata: «¿Chukíleché Esusi?» laa jale. 'Lige yati neraga etele oká santo ánjeli napu Onorúgamete julárigame nile, o'tosákame ra'ósame o'páchigime alé a'bemi jágame. ");
INSERT INTO tacNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","'Lige alué umugika majaga wijchí rojpóchaga uchúpale. 'Lige bilé alué santo ánjelika rukele: ―¿Chonigá 'yamíché 'émika Esusi jemi suwígame gatélachi? ");
INSERT INTO tacNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","¡'Ma ku ajánaleché, tabilé néré jemi! Aka 'la na'tásibá alarigá ra'íchaligo alé Galilea asagá. ");
INSERT INTO tacNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ruwile alué napu nawágame ju 'pa rewagáchika napurigá rió neraga, nejíwili níliga alé e'wélala ralámuli mochígichi napu 'we resí nokame ju, 'lige alué bo'né Esusi 'ma gulusichi ujchagá resí oláwili níliga, 'lige 'ma mukumeli níliga alé gulusichi chujkugá, 'lige pe bakiá rawé kachi ku ajánamio. ");
INSERT INTO tacNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","'Liko alué umugika nélále alarigá anélirigo alué Esúsite. ");
INSERT INTO tacNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","'Lige pe nujubapi yati kumi simíbale galírale, 'lige ruyele alué makué bilé rió Esusi nochálilachi nulame abiena suwábaga alué uché jaré ralámuli alé. ");
INSERT INTO tacNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Alué umugí napu e'yénale alé napu Esusi gatélirige nile María Magalena rewégachi bejtégame, 'lige Juana, 'lige María alué Santiago eyela, 'lige uché jaré umugí. Alué umugí nokale ruyea alué makué bilé rió Esusi nochálalachi nulame. ");
INSERT INTO tacNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","'Lige tabilé bijchígile alué makué bilé rioka alué umugí alarigá ruwichi, iligá regá 'nátale: «¿'Lacha bijchiá nímalawé napurigá aní ye umugí?» ");
INSERT INTO tacNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","'Lige alué Pégroka ma'chínale 'lige yati 'male e'nemia alé 'mi napu bo'ílige gatériga Esusi. 'Lige alé sebasa pe chinicho rewale, 'liko ku galírale simile, 'we na'tasia enale kumi ta rewisáká alué Esusi gatérigime alé ewarárigichi. ");
INSERT INTO tacNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","A'lige rawé napu alué Pegro ro'ínasa napu bo'ile alué Esusi gatériga, a'lige rawé simile alué rió Kleopasi rewégame 'lige uché bilé ralámuli 'yuga, simíbale alé pe'kabi riógachi Emausi rewégachi napu ejperégame nile alué ralámuli. Emaúsika pe a'mulipi nile alé Rusaleni. Alué oká ralámulika tabilé nulame nile Esusi nochálilachi, pe gompaniérola nile alué Esusi 'yuga nóchame makué bilé rió. ");
INSERT INTO tacNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","'Lige alemi boichimi e'yénaga bijí ra'ichasia e'yénale 'we chálagá etesa mukúligo alué Esusi alé gulusichi. ");
INSERT INTO tacNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","'Lige ra'ichasia e'yénigichi alué ralámuli, 'lige pe yati neraga ma'chínale alemi Esusi, 'lige si simile. ");
INSERT INTO tacNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Rekó 'la etee 'lige tase machile alué Esusi ko. ");
INSERT INTO tacNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","'Lige Esúsika rukele: ―¿'Émika tachiri ra'ichasia i'nárikó jemi bowesia? ");
INSERT INTO tacNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","'Liko alué rió Kleopasi regá nejele chálagá: ―Suwábaga ralámuli machíché alarigá ikíliga kulírikáchi alé Rusaleni. 'Lige ¿pe muecho tabilé machí alarigá ikíliga alé? ");
INSERT INTO tacNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","'Lige Esúsika rukele: ―¿Chukirú ko alé? 'Lige bilé alué ralámulika regá anile: ―'Ma me'líliru alué Esusi Nasareta bejtégame, alué napu ruwime nile napu anele Onorúgame. 'We 'la benégame nile we'ká e'karúgame nóchaga abiena rejcholi ruigá napugiti Onorúgame a'walila nígame níligame. Onorúgame 'we a'lá nirale suwábaga napurigá 'sile alué Esusi abiena ralámulichigó. ");
INSERT INTO tacNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","'Lige alué e'wélala balé 'lige ramué nuleme e'wélala 'ma nejile napurigá me'liboa gulusichi ujchagá alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ramueka mayelie alué Esusi 'simio aminá jula alué ramué saíla napurigá taché olawa ramué jena Israeli ejperégame. Ya 'ma bakiá rawé ju mukusá Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Aminami jaré umugí ramué 'yuga e'yéname simíbale che'lachi alé napu bo'ile gatériga Esusi, ");
INSERT INTO tacNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","'lige tabilé rewale alué Esusi gatérigime. 'Lige ku jsíturu galírale ruwisia jaré santo ánjeli Onorúgamete julárigame etéliga, 'lige alué santo ánjeli ruwíligo ku ajániligo alué Esusi. Rekó 'la ma'chígime ruwichi ramueka ta'mé 'la bijchíguru. ");
INSERT INTO tacNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Jaré alué Esusi nochálilachi nulame simíbale alé ewarárigichi napu Esusi gatériga bo'ile, 'lige alueka abiena etele napurigá anile alué umugí, etele tabilé nérekó Esusi alé. ");
INSERT INTO tacNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","A'lígeko alué Esusi anele: ―¡'La tabilé 'nátanti ju 'emi, tabilé o'má bijchíginti napu anílige alué 'ya mochígame napu ruwime nile napu anele Onorúgame! ");
INSERT INTO tacNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Tabilecha resí oláwili nílige alué rió Onorúgamete julárigame napu'lige ta'chó moyena ku rewagachi Onorúgame 'yuga asimea? ");
INSERT INTO tacNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","'Lige chojkile ruyea suwábaga alué ra'íchali napu uchú alé apélichi Moisesi osilila 'lige abiena suwábaga napu ruwile napu anele Onorúgame napu ruwime júchigó churigá nochámili níliga alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Napu'lige sebasa pe u'kabi riógachi Emausi rewégichi napu simiba e'yénale alué Kleopasi 'lige alué uché bilé ralámuli, 'lige Esúsika aminabi abichilubi 'we siméliti ka 'siá 'sile. ");
INSERT INTO tacNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","'Lige alué ralámulika bayérole alemi galírale, regá anegá: ―Jena che'lebáwaguru ramué 'yuga ramué galílachi, 'ma 'we alí kame, 'ma amulí chona. 'Liko Esúsika simile alemi galírale. ");
INSERT INTO tacNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","'Lige alué oká ralámuli 'yuga asagá alé mésachi, 'wile alué baní napuyeri remé, 'lige Onorúgame cheliera 'yasa, 'lige nasípasi 'yale a'pílipi alué oká ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","A'lige alué ralámulika pe yati neraga machile pe Esusi ko alué rió. 'Lige pe yati abajá tané ikiá kíbale. ");
INSERT INTO tacNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","'Lige regá anile a'bopi ra'íchaga: ―'La bijchiá alué Esusi nílige alué rió, gite 'we a'lá ga kanti ra'íchaniétigó 'naka boichika enegá ruyá alué Onorúgame nila ra'íchali rejcholi. Bochígimi sulachí 'we a'lá ga kéturu akiá alué ra'íchali. ");
INSERT INTO tacNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","'Liko tase we'ká 'nátaga, ku yati simíbale alé Rusaleni. 'Lige rewale napuíka mochígame alué makué bilé rió nulame Esusi nochálalachi, abiena mochile uché jaré ralámuli Esusi oyérame. ");
INSERT INTO tacNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","'Lige alué we'ká ralámuli anele alué oká ralámuli: ―¡'La bijchiá ku ajánale alué Esusi! Aka alué Simoni (Pegro) 'la bijchiá etégoríché. ");
INSERT INTO tacNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","'Liko alué oká ralámulika ruwile alé boichimi ma'chínaga ikíligo bilé rió. 'Lige napu'lige alué rió baní 'yasa alué oká ralámuli alé galírale a'lige kulí machíligo Esusi níligo alué rió. ");
INSERT INTO tacNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Napu'lige bijí ra'icha jágichi alué ra'íchali, 'lige yati neraga ilíbale alé nasipa alué Esusi, 'lige reporale regá anegá: ―Riosi kuira. ");
INSERT INTO tacNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Alué ralámulika 'we majale, pe bilé alawá ko lale. ");
INSERT INTO tacNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nobi Esúsika anele ko: ―¿Chonigá majawíché 'emi? 'Émika tabilé 'cho bijchigi ne Esusi ku ajániligo. ");
INSERT INTO tacNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Aka e'nésibá ne'chí sekala, 'lige ne'chí ronola. Chieti ka go. Ne'chí nochásibá, bilé alawaka tabilé sa'pégame ju 'lige tabilé o'chégame napurigá etiá 'emi ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","'Lige regá anesa, etérale bo'né sekala 'lige bo'né ronola. ");
INSERT INTO tacNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","'Lige alué ralámulika etea alué Esusi lale: «¿'Lacha Esusi júpué? Aka Esúsika 'ma me'líliruché. ¿Ku ajánalegerémá?» A'kuérami 'la bijchígale. 'Lige Esúsika rukele: ―¿Ta nerú go'ame jena? ");
INSERT INTO tacNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","'Lige alué ralámulika 'yale pe'tá ro'chí awérigame, ");
INSERT INTO tacNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","'lige Esúsika yati nareka go'ale alué ralámuli etériga. ");
INSERT INTO tacNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","'Lige anele: ―'La sébali alarigá ikile napurigá ne ruiyé napu'lige ne bijí 'emi 'yuga eyena, 'la alarigá ikimeli nílige ne napurigá aní alué Moisesi nila ra'íchali rejcholi, abiena napurigá aní alué osilí 'we 'ya osirúgime napu osale alué napu ruwime nile napu anélige Onorúgame, 'lige napurigá aní alué apeli Onorúgame Wikárilime uchúkame. ");
INSERT INTO tacNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","'Liko Esusi 'ma 'la machírale alué osilí Onorúgame ra'ichálila chujkúgame, ");
INSERT INTO tacNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","regá anegá: ―Alué osilika ruwime ju mukumeli níliga ne Onorúgamete julárigame 'lige pe bakiá rawé kachi ku ajánamili níliga ne me'lisuga. ");
INSERT INTO tacNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","'Lige alué ra'íchili 'we a'lá ra'lanárigame nímala napurigá suwábaga ralámuli 'la machimela alarigá ikimeli níligo ne. Jena Rusaleni o'winámala 'emi, suwábaga ralámuli jena wijchimoba mochígame ruyea ye rejcholi napurigá ku guwana na'támala alué ralámuli chátiri resitiri nóchaga járome. ");
INSERT INTO tacNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","'Lige 'emi 'la machigá mochímili júkuru, 'lige 'la ma'chígime ruyémili ju ralámuli ku ajániligo ne. ");
INSERT INTO tacNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","'Lige ne nejímala alué a'walí napu Onorúgame nejímoríle napu alé 'pa rewagachi asagá 'yámorílige, 'lige 'émika jena mochiwa we'ká riógachi Rusaleni napusí 'ma naré 'emi alué a'walí Onorúgame nejílala ―alarigá anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Alué Esúsika 'yuga simile alué we'ká ralámuli alé na'pami rabó chebilena riógachi Betania anilichi a'mulipi. 'Lige bo'né sekala o'wíniga, iwérali 'yale suwábaga alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","'Lige 'ma iwérali 'yasa, 'ma simile rewagachi. ");
INSERT INTO tacNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Alué ralámulika 'ma ku e'tegínele Rusaleni 'we ra'sálagá. ");
INSERT INTO tacNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","'Lige alé wa'lú re'obachi Onorúgame galílachi senibí mochime nile 'we ra'sálagá semáriga ra'icha a'walí nígame ko Onorúgame. Pe ikipi képá ye ra'íchali. Wa'lú cheliérabá.");
INSERT INTO tacNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ta'chó nerúgichi gawí 'lige rewagá, alué Kristo Onorúgame 'yuga bejtégame nile. Nabí asame nile, Onorúgame nile. ");
INSERT INTO tacNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Alué Krístoka Onorúgame si asale 'ya bajchá rawé napu'lige Onorúgame ta'chó newachi ye gawí 'lige rewagátiri. ");
INSERT INTO tacNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","'Ya bajchá tabilé tábiri nerule, 'lige napu alué Kristo 'nátale, yati neraga nerule gawí 'lige rewagá. Suwábaga napu ekí nerú jena, alué 'sile newá pe bo'né 'nátaga. ");
INSERT INTO tacNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Alué Krístoka bo'né alawala 'yale ralámuli jena wijchimoba mochígame napurigá 'la na'támala Onorúgame 'yuga 'lige napurigá tabilé e'yénamala chónagachi. ");
INSERT INTO tacNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Alué Onorúgame na'tálilaká ju napurigá ra'ósali 'lige 'ma sébale alé napu mochí alué ralámuli chátiri 'nátili 'nátame, nobi alué chátiri 'nátaliká tabiléchigo neyúramalagó Onorúgame na'tálila 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Jena asale bilé rió Juani anilime. Onorúgameka júlale napurigá benírimala ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Alué Juani benírale ralámuli churigá ko alué napu rewigáchikana nawale. Alueka pe ruwime nile napurigá alué ralámuli 'la bijchígimala alué ra'íchali alué napu rewigáchika nawale. ");
INSERT INTO tacNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Tabilé Juani nile napu rewigáchika nawálige. Alueka pe iligá benírale napurigá alué ralámuli 'la bijchígimala alué ra'ichálila alué napu rewigáchika nawale napu ju napurigá ra'ósali. ");
INSERT INTO tacNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Alué napu rewigáchika nawale, alué rioka 'la bijchígili ra'íchame nile, 'lige alué rioka a'pílipi rió 'yame nile 'nátili napu ju napurigá ra'ósali napurigá a'pílipi rió 'la námamala churigá ko Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Alueka suwábaga tábiri newale napu ekí nerú jena wijchimoba nobi ralámulika tabiléchigo machigá etélekó alué rió. ");
INSERT INTO tacNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nawale jena wijchimoba napu mochile alué ralámuli Onorúgamete rojanárigame, nobi alué ralámulika tabilé galeme nile, 'lige tabilé nirame nile. Pe u'kábika 'la nirale, ");
INSERT INTO tacNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","'lige suwábaga napu ekí 'la nirale, alué napu 'la bijchígale napu Onorúgame anile, alueka 'la lisensia 'yáleru napurigá 'la Onorúgame 'kúchila nímala alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","'Liko alué ralámuli narele Onorúgame Alawala, alekeri Onorúgame 'kúchila ju. Tabilé alué alawá alawega o'chérame ju ralámuli napu'lige o'chérasa, se'nú alawá nareme ju alué ralámuli 'ma Onorúgame oyérasaká. ");
INSERT INTO tacNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ye rió napu rewagáchika nawale pe jena ochérale 'lige wa'lú rió ochérale napurigá ralámuli, 'lige aba jena ajtile bejtega ramué 'yuga, ramueka eteru wa'lú a'waliga ochérigo napurigá Onorúgame Inolá. Alueka tabilé tábiri resílále napu Onorúgame nejime ju, pe bi'lepi bo'né nila níligame, suwábaga napu ekí ra'íchale asíriga 'la suwábaga 'la bijchiá nile. ");
INSERT INTO tacNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juani 'we a'lá ruwile churigá nimio alué napu 'pákana rewagáchika nawámili nílige, regá anile iwégame ra'íchiga: ―Neka 'ma ruyéturu 'emi churigá nimio ye rió. Regá aniéturu ne: «Alué rió napu nawámili ju, alué rioka abéchigo najtékame ju me'tagá ne'chí. Alueka asíriga 'yasi bejtégame nile, napu'lige ne tabilé 'cho ochérachi 'ma asale.» ");
INSERT INTO tacNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Alué rioka asíriga 'la sébali 'nátame ju. Aminami 'we a'lá semátiri 'nátili nejime ju. Ramueka asíriga o'maka naretu alué semátiri 'nátili napurigá 'nátame ju alué rió. ");
INSERT INTO tacNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","'Yako narétuturu nulalí Moisesi nejílala. Onorúgame 'yale alué nulalí napurigá Moisésika ramué beníramala. Jípeko abéchigo 'la semátiri 'nátili nejí Esukristo, peba alué bo'né 'smíguru nejkuria rekó se'nú 'nátili 'nátame nírige, 'lige aminami asíriga 'la bijchiá beniri ramué. ");
INSERT INTO tacNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ralámuli jemi mochígame ka pecha siné etégó alué Onorúgame, pe iligá machiaa napu ruwile alué rió napu pe napuyépiri rió neraga nawale rewagáchika napu ju Onorúgame Inolá. Jípeko Onorúgame si ajtí uchéchigo siné. ");
INSERT INTO tacNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Alué e'wélala jurío Rusaleni anilichi mochígame napu'lige machisá ralámuli rewará ajtigó Juani, a'lige juláliru jaré balé, 'lige jaré ralámuli napu lebita anilime nile, napurigá regá rukémala alué Juani: ―¿Chieri ju mué? ");
INSERT INTO tacNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","'Lige Juánika 'we a'lá ma'chígime ruyele napurigá 'la sébali námamala. Regá nejele: ―Tabilé ne ju alué napu rewigáchika juláwili nile ralámuli gu'írimia, alué napu Kristo anilime ju, neka tabilé alué ju. ");
INSERT INTO tacNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","'Liko rukéleru Juani alué ralámulite: ―A'lígeko, ¿mué ju alué 'ya bejtégame napu Elíasi anilime nílige, alué napu ruwime nile napu anele Onorúgame? 'Lige Juánika anele: ―Neka tabilé ju. 'Lige ralámuli uchéchigo siné rukele: ―¿Alué napu ruwime nile napu anele Onorúgame, alué napu nawámaráe, alué júleke'é mué 'liko? ―anile alué ralámuli. 'Lige Juánika anele: ―Tabilé. ");
INSERT INTO tacNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","'Lige alué ralámulika anele: ―¿Chieri ju mué 'liko? 'La rupóagurú napurigá ramué 'la ma'chígime ruyéwampá alué e'wélala ku sebasa. ¿Chonígó mueka? ");
INSERT INTO tacNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","'Lige Juánika anele napu anile alué rió 'ya ajtígame Isaíasi anilime, alué napu ruwime nile napu anele Onorúgame. Anele Juani: ―Neka pe bilé rió e'wele ra'íchame ju, alué napu e'wele ra'íchame ju alé napu pee u'kume ju regá anigá: «'We a'lá o'wé gatesi alué bowé napu simírimili ju Wa'lula Onorúgame.» (Yeka anime ju suwábaga ralámuli 'ma tabilé chátiri 'nátili 'nátame nímili ko.) ");
INSERT INTO tacNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Uché jaré napu julárigame nile alé Rusalénachika, alueka bariseo nile, ");
INSERT INTO tacNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","'lige alueka rukele: ―Mué tabilé alué rewagáchika nawágame nísaká, 'lige tabilé Elíasi nísaká mué, 'lige tabilé alué uché bilé rió nísaká mué napu ruwime nile napu anele Onorúgame, 'liko ¿chonigá rewará mué ralámuli? ");
INSERT INTO tacNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","'Lige Juánika nejele: ―Neka pe iligá ba'wite rewarame ju. Bilé rió ajtí jena a'bé napu mochí 'emi, napu 'emi tabilé machí chieri ko alué rió. ");
INSERT INTO tacNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Alué napu pe'wé nawámili ju, abé wa'lula ju me'tigá ne'chí. Neka ju napurigá bilé pioni, pe abé u'tabela ju ne. ");
INSERT INTO tacNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Alakile alé Betania anilichi, alé bajoniga bakochi Jorani anilichi 'omi niraga napu rayénali ma'chíname ju, alé napu asale Juani ralámuli rewará. ");
INSERT INTO tacNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","'Lige melénala rawé be'á be'lí Juánika etele Esusi a'mibeka enágichi. 'Lige Juánika anele ralámuli: ―¡'We a'lá e'nesi, jeka enákuru bilé rió napu Onorúgame júlale pe napurigá bilé bo'á neraga napu me'liboli ju napu alué ralámuli buinámili ju chátiri bowechi! ");
INSERT INTO tacNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","¿Tacha nélá 'emi napu ne ruyánié 'yabé? Regáriga aniéturu ne: «Pe 'we nawámala bilé rió abé rajpé najtékame me'tigá ne'chí. Alueka abéchigo 'yasi bejtégame nile ta'chó ochérichi ne. Alueka nabí bejtégame ju.» ");
INSERT INTO tacNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Neka tabilé machiéke'é alué ko. Neka iligá pe rewaramia nawá ba'wite ralámuli israelita napurigá alué ralámuli israelita 'la machimela churigá ko alué napu nawámili ju rewagáchika. ");
INSERT INTO tacNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","'Lige siné rawé Juani anile: ―Neka 'la etéturu Onorúgame Alawala sébachi jena wijchimoba, napurigá bilé baloma neraga, alarigá nawáturu, 'lige alué baloma Esúsichi asíbaturu. ");
INSERT INTO tacNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Neka pecha machié ko chieri rió nimio, napu'lige Onorúgame ne'chí nulé ralámuli rewarániliga ba'wite a'lige ruyé Onorúgame ne'chí regá: «Napu'lige mué etea Onorúgame Alawala 'pa rewigáchika re'kínichi alé alué riochi asibasa, alué rió nímala ralámuli rewarame bo'né Onorúgame Alawálate, ye Onorúgame Alawala 'yámala ralámuli.» ");
INSERT INTO tacNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","'Lige etéturu ne narechi Onorúgame Alawala, neka 'emi ruyéguru ye rioka Wa'lula Onorúgame Inolá ko. ");
INSERT INTO tacNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Melénala rawé alué Juani ilile uché jaré oká rió 'yuga bo'né 'yuga járome. ");
INSERT INTO tacNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","'Lige Juánika uchéchigo siné etele Esusi alemi eyénachi 'lige anile alué Juani: ―¡'We a'lá e'nesi, alué ju Onorúgame julálila 'pa rewigáchika pe napurigá bilé bo'á neraga napu me'liboli ju napurigá alué ralámuli buinámala alé tabilé 'la bowechi e'yéname! ");
INSERT INTO tacNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","'Liko napu'lige alué oká rió akisá alanichi Juani, yati simíbale Esusi najátamia. ");
INSERT INTO tacNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","'Liko Esusi, napu'lige gu'lía etele alué oká rió guwánaka e'yénigo, 'lige rukele: ―¿Tachiri 'yaga e'yénili 'emi? ―anele. 'Lige alué oká rioka nejele: ―Mué benírame, ¿koche che'lébame ju mué? ");
INSERT INTO tacNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","'Liko Esúsika anele: ―Ne'chí 'yuga simasi, a'lige 'la machimela 'emi. Pe be'á be'lí nile pe'wera rainasa napu'lige nápale Esusi. 'Lige simíbale alué Esusi 'yuga, 'lige 'la machile alemi che'lébame níligo. 'Lige alé mochile alué 'yuga rukachégame rawé. ");
INSERT INTO tacNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ye oká rió, Antresi anilime nile bilé, napu Simoni Pegro bonila nile. ");
INSERT INTO tacNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","'Lige alué Antresi yati simile bo'né ba'chila 'yamia Simoni (Pegro) anilime, 'lige rewisá anele: ―'Ma rewirú alué Mesíasi. (Mesíasi aniáká pe Kristo aniame ju.) ");
INSERT INTO tacNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","'Lige 'mi o'turú Simoni bo'né bonílate Antresi anilime alé napu asale Esusi. 'Lige Esúsika Simoni etesa, regá anele: ―Mueka Simoni anilime ju Juani inolá. A'kinana rawé Sepasi anilime nímala mué. (Sepasi aniáká pe Pegro aniame ju. Alué okánika, Sepasi 'lige Pegro, pe rejté aniame ju.) ");
INSERT INTO tacNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Melénala rawé Esusi simeli nílige Galilea anilichi ejiro, 'lige simile, 'lige alé Galilea anilichi najtépale Belipe anilime rió. 'Lige Esusi anele alué rió: ―Nabá. Ne'chí oyériwa. ");
INSERT INTO tacNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Belípeka Betsáira anilichi riógichi bejtégame nile, 'lige alué Antresi 'lige alué Pegro abiena alé Betsaira ejperégame nílechigó. ");
INSERT INTO tacNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","'Lige alué Belípeka Natanaeli najtépale, 'lige anele: ―Moisesi osale 'we 'ya bilé rió nawamio, napu Onorúgame julámili nílige, 'lige abiénachigó alarigá osale alué ralámuli napu ruwime nílige napu anele Onorúgame, jipe 'ma eteru. Pe Esusi ju napu Nasareta anilichi riógichi bejtégame ju, napu José inolá nílige. ");
INSERT INTO tacNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","'Lige Natanaélika anele: ―Tabilé 'wesi i'té a'ká ralámuli alé Nasareta anilichi. 'Lige Belípeka anele: ―Jeka simigá e'newa, 'liko 'la machiboa. ");
INSERT INTO tacNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Napu'lige Esusi etesa alué Natanaeli sébachi napu Esusi asale, Esúsika regá anele: ―E'né, aleka ená bilé israelita asíriga 'la, tasiné 'yégiga ra'íchame. ");
INSERT INTO tacNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaélika akele alanichi Esusi 'lige anile: ―¿Churigá machígó mué ne'chí? 'Lige Esúsika nejele: ―Neka alé 'mi chunachi pachárale ilígichi eté ne mué abé bajchabé ta'chó bailichi mué Belípete. ");
INSERT INTO tacNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","'Lige Natanaélika anele: ―Mué benírame, mué ju Onorúgame Inolá. Mué ju Wa'lula ralámuli israelita nuleme. ");
INSERT INTO tacNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","'Lige Esúsika nejele: ―Neka 'la machigá ajtigéturu mué bilé chuná ilígichi pachárale ajtigó, alekeri 'la nirá mué ne'chí. Abé i'libeko rawé abéchigo 'la semátiri e'karúgame etémala mué. ");
INSERT INTO tacNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","'Lige regá anele uchérapé: ―Neka 'la bijchiá anígurú. Mueka etémili júkuru rewagá ra'pachi, 'lige abiena etémala mué alué santo ánjeli jímochi 'pari rewagachi, 'lige abiena etémala mué alué santo ánjeli e'tigichi napu ajtí ne. Neka bilé rió ju pe napurigá 'emi. Ne ju rewagáchika nawágame napurigá rió neraga. ");
INSERT INTO tacNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","'Lige a'kinana bakiá rawé kachi bilé newigime nerule alé we'ká riógichi Kaná anilichi, napu alé wa'lú ejiro bo'ígichi Galilea anilime, 'lige alé asale Esusi eyela. ");
INSERT INTO tacNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Esusi 'lige alué Esusi 'yuga járome abiena bayérigame nile alé newigime nerúgichi. ");
INSERT INTO tacNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","'Liko alé newigime nerúgichi i'wilí ba'wila rekútame 'ma suwile. 'Lige Esusi eyela anele alué Esusi: ―'Ma suwí i'wilí ba'wila. ");
INSERT INTO tacNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","'Lige Esusi nejele: ―¿Mueka, chonigá alaníché? Ta'chó sébago ne nila raweli. ");
INSERT INTO tacNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","'Liko, Esusi eyela anele alué we'ká ralámuli nóchame: ―'La e'wawa suwábaga napu nulá alué. ");
INSERT INTO tacNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Usani sikolí jale alé, rejtete newárigime sikolí. A'pili sikolí osá naosa makué litro aminá pe u'tá bochime nile. ");
INSERT INTO tacNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","'Lige Esúsika anele alué nóchame ralámuli: ―Bochiasi ba'wí alé sikolichi. 'Lige o'maka nóchame 'ma bochiasa a'rele, ");
INSERT INTO tacNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","'liko Esúsika anele: ―Jípeko bilé alabate 'tuka ma'chí pasi pe'tá ba'wí, 'lige o'towa napurigá bajímala ye jena newigime nulame. 'Lige alarigá nokale alué ralámuli nóchame. ");
INSERT INTO tacNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","'Lige alué newigime nulame bajile alué ba'wí. Napu'lige alué rió bajichi alué ba'wí 'ma i'wilí ba'wila gayénigime nile, 'lige tabilé machile koche yénika ma'chínigame níligo alué i'wilí ba'wila, alué we'ká nóchame ka 'la machile. 'Lige alué newigime repúmeka bayele alué rió napu newímili nílige, ");
INSERT INTO tacNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","'lige anele: ―Suwábaga ralámuli bajchá ma'chí pame ju i'wilí ba'wila 'we a'lá gayénigime bajchá bajimia. 'Lige napu'lige 'ma suwábaga suwasa a'lige kulí ma'chí pame ju alué abé ta'mé ená kame i'wilí ba'wila. Nobi mueka tabiléchigo alarigá 'smíkó. Mueka nujubá ma'chí pákuru 'we 'la gayénigame i'wilí ba'wila. ");
INSERT INTO tacNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ye nílekuru napu newálige alué Esusi 'we semátiri napu tabilé gayéname ju newá apiépiri rió tabilé gu'írasaká Onorúgame. Alé Kaná anilichi riógichi newale ba'wite alué i'wilí ba'wila rekútame pe bo'né 'nátaga. Alarigá 'la machile ralámuli alué Esusi 'la gayenio 'we semátiri newá. Alué Esusi 'yuga járome ka asíriga 'la bijchígale alué Esusi níligo napu Onorúgame julámioríle. ");
INSERT INTO tacNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","'Lige pe abé i'libeko simíbale alé wa'lú gomíchitu 'tumi neraga, Kapernaumi anilichi we'ká riógichi simíbale, alé suwékimi napu ilí alué wa'lú ba'wí Galilea anilime. 'Lige simile Esusi alué bo'né eyela 'yuga 'lige bo'né nasípasi bonila 'yuga, 'lige bo'né nasípasi waíla 'yuga, 'lige alué Esusi oyéramechigó, 'lige alé Kapernaumi anilichi mochile pe u'kabi rawé. ");
INSERT INTO tacNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Napu'lige 'ma amulí sébachi wa'lú piesta Páskua anilime napu ralámuli jurío newame ju nélegá napu'lige alué Onorúgame ánjelila tabilé me'áligo alué abé bajchá o'chérigame u'kuchítiri israelita alé Ejipto anilichi, 'lige Esusi moyénale Rusaleni anilichi. ");
INSERT INTO tacNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","'Lige alé wa'lú re'obá ra'pichílachi rewale jaré ralámuli o'toló ralinea mochígame, 'lige bo'átiri, 'lige baloma ralinea mochígame. Alué ajágame ralisá, Onorúgame kógilime nile. 'Lige abiena etele jaré ralámuli enomí nakulía mochígame, alué romano enomila 'lige jurío enomila. ");
INSERT INTO tacNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","'Liko Esusi 'ma mabule suwábaga ralámuli napu ekí alé mochílige alé re'obá ra'pichílachi, 'lige alué bo'átiri, 'lige alué o'tolótiri. Esusi jaré iwía napubusa 'lige mo'yesa, aluete wejpísiga 'mélele alué ajágame alé uchúkame. 'Lige alué we'ká mesa napu alé jale enomí mochígame 'ma na'mínale, 'lige alué enomika 'ma rujsule ra'laga alemi. ");
INSERT INTO tacNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","'Lige Esusi e'wele ra'íchaga anele alué baloma ralineme: ―'Ma buinasi ye baloma jena jágame. Ye galika ne o'nola galila júkuru. Ye galí pecha alekeri newárigime júkó napurigá ralinewa jena. ¡'Ma a'rélime júkuru yeti nocha! ");
INSERT INTO tacNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","A'lige alué Esusi 'yuga járomeka nélále a'kinana ku ajánasa Esusi alué ra'íchili napu uchule 'ya osirúgime Onorúgame ra'ichálila. Regá anime ra'íchili: ―Neka asíriga galé ye galí ne o'nola galila 'lige 'we a'lá repú ne, alekeri me'liboli júkuru ne. ");
INSERT INTO tacNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","'Liko napu'lige etea 'ma suwábaga ralámuli mabuchi, alué ralámuli juríoka anile: ―Mué a'lá nulérigime nísaká Onorúgamete napurigá ala'símala, newáwagó 'liko bo'né 'nátaga 'we semátiri tábiri napu tabilé gayéname ju ralámuli newá napurigá ramué machibómpá 'la Onorúgamete 'yárigame ko mué alieri a'walí. ");
INSERT INTO tacNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","'Lige Esúsika nejele: ―'Ma na'minasi ye re'obá ne ku newámampá, pe bakiá rawé kachi 'ma gainámala ne newá. ");
INSERT INTO tacNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","'Lige anile alué ralámuli jurío: ―Oká liá aminá usani bamí nochárigame ju ye re'obá newá, mueka pe bakiá rawé kachi 'ma gayénimorí. ¿Churigá 'la gayénimi oláché mué aliena yati pe bakiá rawé kachi? ");
INSERT INTO tacNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tabilé námale alué ralámuli jurío Esusi tabilé alué re'obá olagá aníligo napu napuíme nílige alué ralámuli jurío, pe bo'nepi olagá anile, napu'lige me'lisuga alué Esusi ku ajánamio pe bakiá rawé kachi. ");
INSERT INTO tacNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","'Liko a'kinana napu'lige me'lisuga 'lige uchéchigo siné ku ajánasa alué Esusi, alué Esusi 'yuga járome nélále napu anílige alué Esusi, a'liko abéchigo 'la bijchígile napurigá anile Onorúgame nila osilí 'ya nerúgame, 'lige alué Esusi ra'ichálilatiri. ");
INSERT INTO tacNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Napu'lige Rusaleni anilichi asagá piesta Páskua nerúgichi, asíriga we'ká ralámuli etele alué Esusi 'we semá 'sichi pe bo'né 'nátaga, 'lige asíriga 'la galegá etéleru Esusi alué ralámulite 'lige aminami asíriga 'la machile Onorúgamete julárigame ko. ");
INSERT INTO tacNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Esúsika tabiléchigo 'me we'ká ra'íchale ko alué ralámuli 'yuga. Tabilé 'la ruwile chieri níligo alué bo'né. Bo'neka 'we a'lá machile churigá ko ralámuli, aliena tabilé 'la 'nátame ko. ");
INSERT INTO tacNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Esúsika asíriga 'la machile alieri ko alué ralámuli na'tálila, tabilé ruilime najkile Esusi alué uché jaré ralámulite, pe bo'neka 'we a'lá machile. ");
INSERT INTO tacNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Bilé rió bariseo asale Nikoremio anilime, alué rioka wa'lula nile ralámuli jurío nuleme. ");
INSERT INTO tacNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Chíboka simile bilé rukó napu asale Esusi, 'lige anele: ―Mué benírame, 'we a'lá machiaa ramué Onorúgamete nulérigime ko mué napurigá beníramala. Pe Onorúgame A'walílate 'la gainawa alué semati e'karúgame napu newá mué pe bo'né 'nátaga. ");
INSERT INTO tacNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","'Liko Esusi anele: ―Neka 'la bijchiá ruwígurú, bilé rió tabilé osá neraga ochérasaká 'liko tabilé lisensia 'yámala alué rió napurigá Onorúgame nulémala. Onorúgame tabilé siné 'yámala a'walí. ");
INSERT INTO tacNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","'Lige Nikorémioka rukele: ―¿Churigá 'la uchéchigo siné ochérimalewé bilé rió 'ma we'ká bamígame nisa? ¿Ku eyela rojpálachi bajkimela napurigá uchéchigo siné ochéramala? ");
INSERT INTO tacNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","'Lige Esúsika nejele: ―Neka 'la bijchiá anígurú. Bilé rió napu'lige ochérasa, alawégame ju nobi rokáré ko alué uché bilé alawá 'la bi'wígame, alué Onorúgame Alawala. Ta naresi ka Onorúgame Alawala, tabilé lisensia 'yámala napurigá Onorúgamete nulewa. ");
INSERT INTO tacNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Bilé rioka alawá nareme ju napu'lige ochérasa bo'né eyélachi, nobi a'kinana napu'lige 'la elisa Onorúgame napurigá nulewa Onorúgamete, 'liko Onorúgameka bo'né Alawala 'yámili júkuru. Yeka uchéchigo siné ochérilime niraga júkuru. ");
INSERT INTO tacNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","'Liko tase we'ká na'tawa regá anichi ne: «Osá niraga ochérimili júkuru suwábaga ralámuli tabilé injiérnochi siminálisaká.» ");
INSERT INTO tacNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ekaka panápuri oyame júkuru. I'sínimi akirume júkuru eká nobi tabiléchigo machirume júkó aleka enegó nibilé etérume júchigó alemi 'mao. Alueka tabilé etérume ju. Alarigá júkuru Onorúgame Alawálachigó, tabilé etérame ju, panápuri eyéname ju, 'lige tabilé machiaa chieri ralámulichi bajkimeli ko, nobi 'láchigo machirume júkó napu'lige bilé ralámuli 'la naréligo alué Onorúgame Alawala, 'ma ku a'kabámana 'nátame ju. ");
INSERT INTO tacNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","'Liko Nikorémioka uchéchigo rukele: ―¿Churigá 'la alarigá nímalawé ye? ¿Churigá 'la gainámalawé bilé rió Onorúgame Alawala narea? ");
INSERT INTO tacNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","'Lige Esúsika nejele: ―Mué Nikoremio, mueka benírame júkuru alué ralámuli israelita 'lige tabilé námaguru mué ye. ¿Chonigá? ");
INSERT INTO tacNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Neka 'la bijchiá aní: Ramué napu alawégame niru Onorúgame Alawala napu ekí ejebénigame niru 'lige napu ekí eteru pe lakí ruyáguru, nobi mueka tabiléchigo bijchígigo ye ramué ra'ichálila. ");
INSERT INTO tacNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mueka tabilé bijchigi ye ra'íchili napu ne ruwí, ye ra'íchilika ruyame júkuru alakió jena wijchimoba. 'Liko ne ruisáká alakió 'pa rewagachi, a'liko abéchigo pecha námamalagó mué. ");
INSERT INTO tacNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","› Tabilé 'wesi moyénale rewagachi, pe aluecho napu 'pa rewagáchika nawale napurigá rió neraga. ");
INSERT INTO tacNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Alarigá napu 'sile Moisesi alé napu tabilé 'me u'kume nile, Moisesi ujchale bilé sinowí jiérote newárigime bilena iguchi 'lige o'weti elale napurigá tabilé suwimela ralámuli. Alarigá oláwili ju alué rió napu nawale 'pa rewagáchika, bilena gulusichi ujcháwili ju. ");
INSERT INTO tacNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","A'liko suwábaga napu ekí nirame ju napurigá 'sime ju alué rió (napu ju ne Esusi) ralámuli gu'íriga, alué ralámulika 'la rewagachi mochímili júkuru napu'lige suwisá. ");
INSERT INTO tacNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","› Onorúgameka 'we galele ralámuli, alekeri bo'né bi'lepi Inolá júlale napurigá alué 'símala ralámuli gu'iria. Suwábaga ralámuli napu ekí 'la Onorúgame Inolá oyérame ju, alueka tabilé simámili júkuru injiérnochi. Alueka 'pa rewagachi simámili júkuru ejperélimia nabí. ");
INSERT INTO tacNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Onorúgameka pecha júlalekó bo'né Inolá napurigá 'légana injiérnochi julámala ralámuli. Alueka júlale napurigá buinámala ralámuli chátiri bowechi. ");
INSERT INTO tacNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","› Bilé rió 'la narésaká alué Onorúgame Inolá na'tálila, 'liko Onorúgameka tabilé siné saíla neraga etémala alué rió. Bilé rió tabilé bijchígime ka napurigá 'sile alué Onorúgame Inolá, alueka asíriga wa'lú gastigo narémala napugiti pecha bijchígime kame churigá nile alué bi'lepi rió Onorúgame Inolá. ");
INSERT INTO tacNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Alué Onorúgame Inolá nawale napurigá ra'ósili jena gawichí, nobi ralámulika abéchigo niráleko 'lina alué chónali napu ju alué 'nátili napu pe Remónisi nejí. Alué ralámulika gastigáriwili ju. ");
INSERT INTO tacNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Suwábaga napu ekí tabilé 'la nirame ju, tabilé narénilime ju alué semátiri a'walí Onorúgame nila. Tabilé najkí napurigá Onorúgamete etewa 'we cha nokame ko a'boi, napugiti pecha najkiá napurigá Onorúgamete gastigáriwa. ");
INSERT INTO tacNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Bilé rió 'la sébili olame napurigá Onorúgame najkí, alué rioka tabilé majame ju Onorúgamete etelia, alué rioka najkí napurigá ralámuli 'la machimela 'la Onorúgame na'tálila 'nátame ko. Alué rioka tabilé chónigichi eyéname ju. Alueka 'la ra'ósigichi eyéname ju, tabilé chonárale. ");
INSERT INTO tacNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","A'kinana Esusi simile bo'né 'yuga járome si alé Rusaleni mochiga 'lige 'letu gomichi simíbale. 'Lige alé gomichi mochiga rewarale ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","'Lige abiena eyénale alé a'bemi alué Juani, alué Juani ta'chó bajchalía galírale. Enoni anilichi ajtile, a'bé alé Salima anilichi. 'Lige wa'lú ba'wí ilígame nile alé. 'Lige ralámulika simíbale alé Juani ajtígichi, 'lige Juánika rewarale ba'ichí bokobuga suwábaga ralámuli alé jsime. ");
INSERT INTO tacNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","'Lige boichí anile na'áwaka jaré alué Juani 'yuga járome bilé ralámuli jurío 'yuga machináliga tachiri ruwime ko napu'lige bilé rió ba'wichí bokobuga rewaralia. ");
INSERT INTO tacNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","'Lige Juani 'yuga e'yénameka simíbale Juani ajtígichi, 'lige anele: ―Mué benírame, alué rió napu mué si ajtigáriké 'yabé Jorani anilichi bakochi na'lebo 'nálige bajoniga, alué napu mué ra'ichia anié, ralámuli rewará ajtí, 'lige suwábaga ralámuli simiba napu alué rió ajtí. ");
INSERT INTO tacNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","'Lige Juánika anele: ―Bilé rió pecha nígame júkó alué nóchali Onorúgame tabilé 'yásaká alué rió napurigá alué rió ralámuli rewarámala. ");
INSERT INTO tacNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","'Emi a'boi 'la néláwa napu ne anié: «Neka tabilé Kristo ju napu nawá 'pa rewagáchika, neka pe bajchabemi enágame júkuru gatesia ralámuli 'yuga.» ");
INSERT INTO tacNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ralámulika alué si simíbaguru napugiti alué kame wa'lula abé najtékame me'tigá ne'chí. Neka pe nejkúrame júkuru. Neka pe napurigá bilé amígola ju napu gu'írime ju napu'lige newichi bilé rió. 'Lige napu'lige aké ne alué rió ra'íchachi 'we ra'sáláme ju ne, 'lige jípeko 'we ganíliga ajtí ne. ");
INSERT INTO tacNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Alué rioka abé najtékame nímili júkuru, 'lige neka 'ma ta'mé najtékame nímili júkuru. ");
INSERT INTO tacNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Abiena anile Juani: ―Alué 'pa rewagáchika nawágame, alué ju suwábaga ralámuli nuleme. Neka pe jena wijchimoba bejtégame ju, neka pe napu ekí bení jena wijchimoba pe lakí ra'íchame ju ne. Alué napu rewagáchika nawágame ju, alué júkuru suwábaga benégame 'lige suwábaga nulame. ");
INSERT INTO tacNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Alueka ruwime júkuru napu etele bo'né 'lige napu akele alé 'pa rewagachi, nobi we'ká ralámuli jena wijchimoba mochígame tabilé bijchígigó. ");
INSERT INTO tacNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ralámuli 'la bijchígime ka alué ra'íchali, 'we a'lá machimela 'la bijchígili ra'íchame ko Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Alué napu Onorúgame júlale 'pa rewagáchika, alueka ra'íchame ju napu anéliru Onorúgamete. Onorúgameka asíriga 'la ra'sáligá 'yale alawá bo'né alawala, napurigá alué rió 'la gainámala Onorúgame ra'ichálila ra'icha. Alué rioka tabilé resí lame ju napugiti Onorúgame 'yame kame suwábaga. ");
INSERT INTO tacNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Alué O'nó Onorúgameka 'we galé bo'né Inolá, 'lige a'walí 'yale napurigá suwábaga ralámuli nulémala. ");
INSERT INTO tacNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Bilé rió 'la oyérasaká Onorúgame Inolá, alueka asíriga 'la semáriga na'támala jena wijchimoba asagá, 'lige aminami nabí bejtega asimela Onorúgame 'yuga 'pa rewagachi napu'lige mukusá. Bilé rió sairúgame nísaká Onorúgame Inolá 'yuga, alueka tajsiné bejtélamala Onorúgame 'yuga, Onorúgameka pe aminacho resítiri raweli 'ya asimela. ");
INSERT INTO tacNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Alué we'ká bariseo machile abéchigo we'ká ralámuli oyérame ko alué Esusi me'tagá alué Juani, 'lige aminami abé we'ká rewarao ralámuli alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Tabiléchigo Esusi nílikó napu rewarale, pe alué bo'né oyérame nokale rewará.) ");
INSERT INTO tacNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","'Lige alué Esusi 'we a'lá machile alieti 'nata mochigo alué bariseo. Tabilé najkile napurigá nakó nerúmala alué bariseo 'yuga alekeri simile alé Jurea anilichi asagá. Simile uché bilena alé 'mimi niraga napu bo'í alué ejiro Galilea anilichi. ");
INSERT INTO tacNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","5","Simíroma olale napu bo'í Samaria rewégame ejiro, 'lige sébale alé napu nile ejiro Samaria Sikari anilichi we'ká riógachi. A'bé nile alé we'é bo'ígichi napu Akobo 'yálige alué bo'né inolá José anilime. ");
INSERT INTO tacNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","'Lige alé ilile bilé poso 'we re'lé jótigime napu alué Akobo jólige 'we 'ya. 'Lige alué Esusi 'we risibaka sébale alé, 'lige alé a'bé asíbale alé jótigichi, rawilí nile. ");
INSERT INTO tacNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","'Lige alé sébale bilé mukí Samaria anilichi bejtégame, alué mukika sébale ba'wí 'tumia. 'Lige Esusi anele alué mukí: ―To pe'tá ba'wí, 'we balama ne. ");
INSERT INTO tacNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Alué Esusi oyérameka alé we'ká riógachi simíbalige go'ame ralimea, 'lige ta'chó sébale kuka alué go'ame pabega. ");
INSERT INTO tacNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","'Lige alué mukí Samaria bejtégame ka anele: ―Mueka ralámuli jurío ju. Ralámuli Samaria ejperégame ka tabilé 'yuga ra'íchame ju alué ralámuli jurío 'yuga. ¿Mueka chonigá tánibaché ne'chí ba'wí bajimia? Neka Samaria bejtégame mukí júkuru. ");
INSERT INTO tacNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","'Liko nejele Esusi: ―Mué 'la machisáká alieti nejime ko Onorúgame, 'lige mué 'la machisáká chieri ko napu aní: «To pe'tá ba'wí», 'liko támili júkuru mué 'lige neka nejímili júkuru alué ba'wí bajichi ma'chíname napu ename ju. (Alueka ruwime kéré Onorúgame a'walila ko.) ");
INSERT INTO tacNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","'Lige alué mukika tabilé námale 'lige anile: ―Mué Wa'lula, mueka tabilé ni bilé sikolí, asíriga re'lé rojkógichi ilí ba'wí. 'Liko ¿koche ni mué alué ba'wí napu ená ilí? ");
INSERT INTO tacNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Mueka ju abé najtékame me'tagá alué Akobo napu ramué rijimala nílige, napu 'we 'ya bejtégame nílige? Alué 'sílekuru ye rekolí newá 'lige aminami jena bajílekuru ba'wí alué rió, 'lige aminami alué 'kúchilatiri abiena bajile, 'lige alué ajágame alué rió bujkula abiena jena bajile ba'wí. ");
INSERT INTO tacNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","'Lige Esusi nejele: ―Suwábaga napu ekí bajime ba'wí jena ilígame uchéchigo siné balámumala. ");
INSERT INTO tacNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Alué ba'wí bajísaká napu ne nejímili ju tajsiné balámumala 'emi. Alué ba'wí napu ne nejímili ju, alué ba'wí tajsiné suwimeli ju, nabí ená ilimela. Alué ba'wí bajísaká 'la nabí ejperega mochiwa Onorúgame 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","'Liko anele alué mukí: ―Mué Wa'lula, ne'chí 'ya alué ba'wí napurigá ne tajsiné rawé balámaka einámala, 'lige aminami napurigá tajsiné 'túmimpá ne alué ba'wí jena ilígame. ");
INSERT INTO tacNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","'Lige Esusi anele alué mukí: ―Jeka bayéwagó alué rió mué gunala, 'lige muéchigó uchéchigo siné nawawa alué rió 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","'Lige anile alué mukí: ―Neka tabiléchigo 'yúgame júkó rió. 'Lige Esúsika anele: ―Mueka 'la bijchiá aní tabilé 'yúgame korí mué rió. ");
INSERT INTO tacNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Mué mukika maligi rió 'yúgame nílekuru, 'lige alué napu mué 'yuga ajtí jipe, tabilé 'la mué 'yula ju. ");
INSERT INTO tacNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","'Lige anile alué mukí: ―Mué Wa'lula, mué ra'íchanti ju napurigá bilé rió napu ruwime ju napu ané Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ramué samaritano nabí jena rabó newalime kéturu alué go'ame Onorúgame kógimia, nobi 'emi juríoka anígó pe alé Rusalénicho nímili ko alué go'ame kógilime. ");
INSERT INTO tacNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","'Lige Esúsika anele: ―Mué mukí, 'la bijchígiwa ye: bilé rawé sebámala napu tabilé kógiwa go'ame O'nó Onorúgame nibilé jena nibilé alé Rusaleni. ");
INSERT INTO tacNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","'Émika piesta newame júkuru nobi tabiléchigo machime júkó alué ko Onorúgame. Ramué juríoka asíriga 'la machiaa chonigá newilime ka piesta. Alué rió napu ralámuli a'kabámana jawámili ju, alué rioka pe jurío rió nímili ju. Alekeri newalime júkuru piesta ramué jena wijchimoba. ");
INSERT INTO tacNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Sébakuru raweli napurigá Onorúgame Alawala ralámuli gu'írimala napurigá 'la Onorúgame 'yuga 'nátaga mochímala nabí rawé panápuri mochiga. Alué wa'lú O'nó Onorúgameka 'yaga eyena chieri a'lá e'wame ko alué Onorúgame ra'ichálila. ");
INSERT INTO tacNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Onorúgame pe alawá ju. Alué júkuru ralámuli alawá 'yame. Alekeri 'we a'lá bi'lepi 'nátaga mochílime júkuru Onorúgame Alawala 'yuga, 'lige 'la e'wiwa Onorúgame Alawala. ");
INSERT INTO tacNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","'Lige alué mukí anele: ―Neka 'la machí nawamio bilé rió napurigá ramué buinámala alé chátiri bowechi, alué napu Kristo (Mesíasi) anilime ju. Napu'lige alué sebasa, suwábaga tábiri beníramala ramué. ");
INSERT INTO tacNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","'Lige Esusi anele: ―Alué napu mué 'yuga ra'icha ilí jipe pe Kristo ju. Ne júkuru alué. ");
INSERT INTO tacNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","A'lige ra'icha jágichi, sébale alué ralámuli Esusi oyérame, 'lige alué oyérame pe i'kilí jale e'negá 'nata: «¿Chonigá 'yuga ra'icha ilípaché alué mukí Samaria bejtégame 'yuga?» Tabiléchigo che aníleko nibilé tábiri rukélechigó. ");
INSERT INTO tacNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","'Lige alué mukí 'ma simile, abajá a'resa sikolí, 'lige simile alué mukí 'mi we'ká riógachi, 'lige anele ralámuli alé ejperégame: ");
INSERT INTO tacNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―'Mi ajtíte'é bilé rió, neka tajsiné eteme kéte'é alué rió 'yako, 'lige suwábaga ruwíguru, 'lige aminami abiena machí alieri nóchaga oyame ko ne. Nabá e'newa alé 'mi. Kristo kérémá siné kachi alué. ");
INSERT INTO tacNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","'Lige simíbale alué ralámuli alué Esusi e'nemia. ");
INSERT INTO tacNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","'Lige ta'chó sébachi alué ralámuli we'ká riógichi mochígame, alué ralámuli Esusi oyérame ka 'we go'núlale Esusi alué go'ame napu ralálige, anele: ―Mué Benírame, yati go'á. ");
INSERT INTO tacNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","'Lige alueka anile: ―Neka nígame ju go'ame napurigá go'mela. 'Émika tabilé machí chieti ka alué go'ame. ");
INSERT INTO tacNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","'Lige alué oyérameka tabilé námale napu anile alué Esusi, 'lige anile alué oyérame a'bopi ra'íchaga: ―¿Siné kachi pe jaré ralámuli a'pílegeréko go'ame? ");
INSERT INTO tacNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","'Lige alué Esusi abé 'la ruyele alué oyérame, regá anele: ―Neka tabilé chélá ye go'ame. Neka 'we a'lá sébali olánili alué nóchali napu 'yálige Onorúgame ne'chí. 'Lige aminami anele: ");
INSERT INTO tacNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","―Tabilé aniboa: «Naó mechá rokáré napurigá 'wiwa go'ame.» Neka aníguru: «'We 'la e'newa 'la 'nátaga alué echerúgime. 'Ma 'la níté 'wilia.» Ralámuli we'ká mochíkuru 'we resíláme, 'lige 'we a'lá listo mochiwa 'emi napurigá nejkúrimala alué ralámuli. Pecha builime júkó. ");
INSERT INTO tacNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nóchame ka yati najtétilime ju echerúgime 'wisa. (Echerúgime aniame kéré napurigá 'la benimela ralámuli Onorúgame ra'ichálila, alué ralámulika 'we a'lá ejperélamala nabí Onorúgame 'yuga 'pa rewagachi.) Alué echámeka asíriga ganíliga mochí napu'lige 'we we'lé nerúgichi echerúgime, 'lige abiénachigó alué 'wime abiena asíriga 'la ganíliga mochí. ");
INSERT INTO tacNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Bilé ra'íchali nerú regá anime: «Bilé rió echame júkuru 'lige uché bilé napabume júkuru napu'lige 'ma rakesa alué echerúgime.» Ye ra'íchalika asíriga 'la bijchiá ju. ");
INSERT INTO tacNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","'Émika pecha bajchá benírele ko ye ra'íchali, uché jaré asíriga a'wágame nóchale ye ra'íchali beníriga. Alekeri napu'lige benírame ju 'emi, we'ká ralámuli 'we a'lá oyérame ju alué ra'íchali. 'Émika 'wime júkuru napu uché jaré echale. ");
INSERT INTO tacNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Napu'lige alué ralámuli Samaria ejperégame ta'chó simíbachi alé we'ká riógichi mochiga, alué mukí anele alué ralámuli Esusi 'we a'lá ruwíligo alieri nóchaga oyame níligo alué mukí abé 'ya bajchabé rawé. Esúsika rekó tabilé etee abiena machióríle. 'Liko alué ralámuli yeti ra'íchale akisá, asíriga 'la bijchígale alué rioka Onorúgamete julárigame níligo 'pa rewigáchika. ");
INSERT INTO tacNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","'Liko alué Samaria ejperégame sebasa alé napu asale Esusi, 'lige 'we owile napurigá alé asimela Esusi alué ralámuli 'yuga. 'Liko Esusi oká rawé asale alé. ");
INSERT INTO tacNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","'Liko alué uché jaré ralámuli Samaria ejperégame napu'lige alué ra'íchili gepusa alué Esusi ra'ichálila, asíriga a'lá bijchígale alué we'ká ralámuli Esusi Onorúgamete julárigame níligo. ");
INSERT INTO tacNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","'Lige alué ralámuli anele alué mukí: ―Bajchá 'la bijchíguru napu mué ruyánié alanió ye rió. Jípeko ramué a'boi akiáguru alué ra'ichálila, alekeri 'la machiáguru ye rioka 'we a'lá bijchiá alué ko napu suwábaga ralámuli buyáname ju alé resítiri bowechi. ");
INSERT INTO tacNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Anawínala Esusi simile alé asisá, 'mimi simile uché bilena ejiro Galilea anilichi. ");
INSERT INTO tacNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","45","Alé napu Galilea anilime ejiro bo'ígichika, alé wa'lú ochérale alué Esusi. (Esúsika anílige: «Ralámuli tabilé nirame ju bilé rió napu ruwime ju napu ané Onorúgame bo'né bejtélachi asagá.») Napu'lige Esusi sébachi alé Galilea, alué ralámuli alé mochígame 'we a'lá ganíliga repórale, a'boika 'la etéligame napu 'sile alé Rusaleni napu'lige nerule alué piesta Páskua anilime. Pe bo'né 'nátaga we'ká ralámuli sa'wale. ");
INSERT INTO tacNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","'Liko alué Esusi uchéchigo siné simile alé Kaná anilichi we'ká riógichi. Alé we'ká riógichi nile napu alué Esusi pe bo'né na'tálilate newale i'wilí ba'wila rekútame pe ba'wite. 'Lige alé sébale bilé wa'lula romano Esusi bayérimia alé Kapernaumi anilichi napurigá sa'wámala alué rió inolá, 'we nayume nile alué rió inolá. ");
INSERT INTO tacNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Alé Kapernaumi asale alué wa'lula romano, 'lige napu'lige akisáká Kaná sébaligo Esusi, 'lige alué rioka simile alé Kaná anilichi we'ká riógachi owimia Esusi napurigá simela alué rió inolá 'yomia, 'ma amulí mukiá bo'ile alué rió inolá. ");
INSERT INTO tacNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","'Lige Esusi anele alué rió: ―'Émika ta etéaká ne sa'wá bilé ralámuli pe bo'né a'walílate, tabilé bijchigi ne ra'ichálila. ");
INSERT INTO tacNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","'Lige alué wa'lula románoka anele: ―Mué Wa'lula, nabá yati ta'chó mukuchi ne inolá. ");
INSERT INTO tacNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","'Lige Esusi anele: ―'Ma ku galírale simiboa. 'La ku sa'wimela mué inolá. Alué rioka 'we a'lá bijchígile napu anile alué Esusi, 'lige yati simile. ");
INSERT INTO tacNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Napu'lige ta'chó sébachi galírale, alué bo'né piónila najtépale 'lige ruwile 'ma a'lá sa'wigá ajtigó alué nayume. ");
INSERT INTO tacNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Napu'lige rukechi chiéniko sa'wíligo, anéleru: ―Rapako rawilí ajchábaturu iná. ");
INSERT INTO tacNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","'Liko alué rió nayume o'nola 'we a'lá machile pe a'lige yati sa'wíligo napu'lige Esusi ruwílige sa'wiméráo alué nayume napu'lige regá anélige: «'La ku sa'wimela mué inolá.» 'Liko alué u'tátiri o'nola 'we a'lá bijchígile Esusi ra'ichálila. Suwábaga alué ralámuli napu ejperégame nile alé napu alué nayume ajtime nile, suwábaga oyérale alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Pe kulí nawá Esusi alé Kaná Juréaka simigá, i'wilí ba'wila rekútume newale ba'wite pe bo'né 'nátaga. Uché osá nawagá, sa'wale alué towí nayume pe bo'né a'walílate bo'né 'nátaga. ");
INSERT INTO tacNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Abé a'kinana rawé, uchéchigo siné simile Esusi alé Rusaleni piesta nerúgichi napu newame nile ralámuli jurío. ");
INSERT INTO tacNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Tegótigame nile 'we re'pá ilígame tegoli noligá alé we'ká riógichi Rusaleni anilichi. We'kaná yógame nile alué tegoli napurigá mo'imela ralámuli 'lige ajágamechigó. Bilena yochi Bo'á Simárome anilime nile, 'lige a'bé alé yochi wa'lú ba'wí manígime nile napu Betsata anilime nile. Betsátaka bilé ra'íchali ju ebreo ra'ichálila (o arameo ra'ichálila). Maligi ulumí rojsate netétigime jale a'bé alé ba'wí manígichi. ");
INSERT INTO tacNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Alué ulumí jágichi we'ká nayume ralámuli bi'tile 'we resítiri. Jaré tabilé ma'chílime nile, jaré tabilé gayéname o'weti jasia, tabilé gayéname simiba, napurigá sujírigame, 'lige jaré ta'mé nokame bochígimi sa'pálachi. ");
INSERT INTO tacNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Pe i'sínimi nokame nile alué ba'wí, pe napu'lige sebasa bilé ánjeli 'pa rewagáchika. 'Lige apiépiri ralámuli bajchá bajkisá alégana ba'wichíkana napu'lige noká ilígichi alué ba'wí, yati sa'wime nile alué ralámuli apiépiri nawilí. ");
INSERT INTO tacNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Bo'ile alé bilé rió napu 'ma baisá makué na osá naó bamí nayume nile. ");
INSERT INTO tacNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Esúsika etele i'kilí bo'ígichi alué nayume 'lige machile we'ká bamió alué nayua. A'lige Esusi rukele: ―¿Sa'winale mué? ");
INSERT INTO tacNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","'Lige alué nayúmeka nejele: ―Mué Wa'lula, alué ba'wí nokachi tabilé 'wesi i'té napurigá ne'chí o'tomela alé ba'ichí. Neka tabilé gayena simiá 'lige senibí neyuro uché jaré. ");
INSERT INTO tacNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Esúsika anele: ―O'weti ilisi, ro'miná mué gemala, 'lige simigá. ");
INSERT INTO tacNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Pe abiéniko 'ma sa'wile alué nayume. 'Lige 'ma ro'minasa bo'né gemala 'lige simile. Alué rawé napu alué rió 'yóliru bilé rawé sawalachi nile napu alué ralámuli jurío resíbame nile. ");
INSERT INTO tacNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","'Liko alué e'wélala ralámuli jurío anele alué 'yórigame olagá: ");
INSERT INTO tacNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","―Jipe raweka wa'lú resíbulichi júkuru 'lige bo'né gemala o'tuáká wa'lú resíbulichi rawé tabilé nerálime niraga júkuru ramué nila nulalí. 'Lige alué rioka nejele: ―Alué rió napu ne'chí sa'wale ané ne'chí: «Ro'miná mué gemala 'lige simigá.» ");
INSERT INTO tacNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","A'lige rukéleru alué rió: ―¿Chieri júkó alué rió napu anile: «Ro'miná mué gemala 'lige simigá»? ");
INSERT INTO tacNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Alué rió 'yórigame ka tabilé machile chieri níligo alué rió. Abiéniko tané ikíligame Esúsika, cha we'ká rióligame alé. ");
INSERT INTO tacNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Abé a'kinana Esusi etele alué rió alé ra'pichí wa'lú re'obachi, 'lige anele: ―'La machíguru mué, 'ma 'la sa'wígame rió júkuru mué. Ya 'ma pe alé si a'rewa cha 'siá. Tabilé a'resa ka mué alué chátiri 'nátili, a'liko abéchigo cha ikimela mué. ");
INSERT INTO tacNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","'Liko simile alué rió 'lige ruyele alué ralámuli jurío e'wélala Esusi 'síligo alué rió 'yoa. ");
INSERT INTO tacNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","'Liko alué ralámuli jurío e'wélala Esusi najátale chibi olániliga, napugiti 'yóligame alué rawé resíbulichi. ");
INSERT INTO tacNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","'Liko Esusi anele alué e'wélala jurío: ―Ne O'nola Onorúgame senibí nocha ajtí rekó resíbilichi rawé kachi, néchigó abiena alarigá nocha. ");
INSERT INTO tacNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","'Liko alué e'wélala juríoka me'linálile Esusi. 'We ayole alué nayume sa'wárigoriká Esusi alué rawé resíbilichi. 'Lige 'we ayoa mochílechigó napugiti anéligame Onorúgame bo'né O'nola ko. Yeka anime nile a'chigóriga kóríle napurigá Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","A'lige Esusi anele alué ralámuli jurío e'wélala: ―'La bijchiá ju napu ne ruwimela jena. Alué napu ju Onorúgame Inolá (napu ne ju) pecha bo'né benile ko 'yoga. Alué rioka pe a'chigóriga 'smíguru napurigá etele ala'sichi alué bo'né O'nola Onorúgame. Bilé towika a'chigóriga 'smíguru napurigá 'smi bo'né o'nola. ");
INSERT INTO tacNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Bilé o'noka 'la 'we 'la niraga eteme ju bo'né inolá 'lige benírame ju suwábaga napu newá bo'né. Onorúgame ne o'nola benírimala ne'chí bilé 'nátili abé semátiri me'tigá napu'lige sa'wale ne alué rió. 'Lige 'emi e'negá jábamala. ");
INSERT INTO tacNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Wa'lula O'nó Onorúgame alawá ku 'yame ju suwígame napurigá uchéchigo ajánamala. 'Lige Onorúgame Inolá abiena 'yame ju alawáchigó napu ekí alué bo'né najkí. ");
INSERT INTO tacNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","'Lige alué O'nó Onorúgame tabilé gustisia olame ju ralámuli. Alué Onorúgameka ye nóchali 'yale alué bo'né Inolá. ");
INSERT INTO tacNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Onorúgame 'yale ye nóchali alué bo'né Inolá napurigá ralámuli animela alué Onorúgame Inolá wa'lula ko 'lige aminami napurigá 'we a'lá nirawa. Bilé rió tabilé niraga eteme Onorúgame Inolá tabilé niraga eteme júchigó O'nola napu ju Onorúgame, Onorúgame napu júlale bo'né Inolá. ");
INSERT INTO tacNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","› Abiena 'la bijchiá ju napu ne ruwimela jena. Alué rió napu 'la gepú ne ra'ichálila 'lige napu 'la nirá Onorúgame, alué rioka 'la senibí bejtélamala Onorúgame 'yuga. Onorúgameka tabilé siné gastigárimala alué rió napu 'la nirá Onorúgame, alué rioka 'máchigo naréligime Onorúgame Alawala. Tabilé siné waná bejtélamala napu Onorúgame bejté. ");
INSERT INTO tacNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Neka 'la bijchiá aníguru. Jipe ya 'ma seba raweli napu'lige ralámuli akémala alué Onorúgame Inolá ra'íchachi, alué ralámuli napu tabilé machime ju Onorúgame ko Wa'lula, 'lige alué napu 'la gepume ju 'lige e'wame ju 'la semáriga ejperélamala Onorúgame 'yuga 'nátiga. ");
INSERT INTO tacNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ne O'nola Onorúgame bo'né Alawala nígame ju napurigá uché jaré 'yámala. 'Lige Onorúgame bo'né Alawala 'yale alué rió bo'né Inolá napurigá uché jaré 'yámala. ");
INSERT INTO tacNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Onorúgameka ne'chí 'yákuru napurigá gustisia olámempá ne alué ralámuli napugiti neka nawagame 'pa rewagáchika napurigá rió neraga. ");
INSERT INTO tacNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Tase e'karúgame na'tawa 'emi napu ne alanichi. Bilé rawé sebámala napu suwábaga suwígame akimela ne ra'íchachi alé gaposántochi. ");
INSERT INTO tacNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","'Lige alué ralámuli napu 'la semáriga nokale napu bijí ta'chó suwiyá, alué ralámulika ku ajánamala napurigá 'la semáriga ejperélimala Onorúgame 'yuga, 'lige alué ralámuli napu 'we cha nokálige, alueka ku ajánamala wa'lú gastigo naremia. ");
INSERT INTO tacNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","› Neka pecha bo'né 'nátiga gustisia olago ralámuli, neka napurigá Onorúgame nulá alarigá e'wáguru. 'Lige napu ne aní 'la bijchiá ju. Neka pecha napu ne bo'né 'nata, pecha alarigá ruwígó. Neka ruwíguru napurigá aní alué napu ne'chí jula. 'Lige Esusi aminabi ra'íchale, regá anile: ");
INSERT INTO tacNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","―Ne bo'nepi ruisáká chu'sime ko ne, alué ra'íchali ka tabilé najtékame ju. ");
INSERT INTO tacNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Neka aníguru uché bilé 'ma ruigó chieti ko ne, 'lige alué rioka Juani anilime nílekuru. Neka 'la machí 'la bijchiá ko napu anile. ");
INSERT INTO tacNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","'Lige 'émika júlale jaré rió Juani rukéniliga chieti ko ne, 'lige Juánika tabilé 'yégiga ruwile. ");
INSERT INTO tacNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Neka tabiléchigo resí lágó napurigá bilé rió 'la semáriga ruwimela ne'chí olagá churigá ko ne. Neka pe ruwíguru ye ra'íchali 'emi gu'íriga 'lige napurigá 'la buyásamala 'emi alé resítirichi. ");
INSERT INTO tacNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juánika napurigá bilé ra'ósali nile napurigá 'emi 'la etémala chónagachi. Alueka tabilé 'yégali ruwílekuru 'lige 'la gu'írilikuru suwábaga ralámuli Onorúgame 'yuga na'tálichi. Alueka ruwílekuru chieti ko ne, 'lige 'émika 'we a'lá ra'sálagá mochile 'we ganíliga pe u'kabi rawé alué ra'íchali akisá. ");
INSERT INTO tacNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","'We najtékame ju napu Juani ruwile, napu ne ruwí abéchigo najtékame ju. Etega alué nóchali napu ne newá, a'lige kulí 'la námamala 'emi Onorúgamete julárigame ko ne. ");
INSERT INTO tacNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","O'nó Onorúgame napu ne'chí júlale jékana, alué bo'né ruwí chieri ko ne. 'Émika tabilé siné 'cho aké Onorúgame ra'íchachi, 'lige aminami 'émika tabilé siné etéchigó Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Tabilé bijchigi 'emi napu aní alué napu Onorúgame júlale napugiti 'émika tabilé oyera Onorúgame ra'ichálila. ");
INSERT INTO tacNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","'Émika 'we a'lá benime ju Onorúgame ra'ichálila aminabi benináliga. 'Émika 'la benimeli mayé ye ra'íchali churigá ejperélatikó Onorúgame 'yuga senibí niraga, nobi tabiléchigo námago 'emi ye ra'íchali. Ye ra'íchali Onorúgame ra'ichálila ruwí chieti ko ne, ");
INSERT INTO tacNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","nobi 'émika tabiléchigo bijchíginiligó napu ne ruwí napurigá 'la ganíliga ejperélamala 'emi Onorúgame 'yuga 'nata. ");
INSERT INTO tacNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","› Neka tabilé chélá rekó 'la nirachi ne'chí 'emi o rekó tabilé 'la nirachi ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Neka 'we a'lá sébali machí 'emi, 'lige 'la machí ne 'emi tabilé 'la ganíliga eteo Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ne O'nola Onorúgame jula ne'chí 'pa rewagáchika, bi'lepi 'nátame niru ramueka, 'lige 'émika tabilé 'la oyeri ne'chí. Siné kachi bilé rió sebasa bilé nóchali o'ká napu pe bo'né 'nata, a'lígeko 'emi 'la semáriga oyéramala alué rió. ");
INSERT INTO tacNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","'Émika 'we ganílime ju tabiri nóchali newigá napurigá uché jaré 'la semáriga nirámala, napurigá 'we a'lá niraga ra'ichámala 'emi olagá. Nobi tabiléchigo 'la 'nátago 'la semá nokiame napurigá 'we a'lá niraga ra'ichámala Onorúgame 'emi olagá. Alekeri tabilé 'la bijchígamala napu ne ruwí. ");
INSERT INTO tacNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","'Emi tase mayewa ne 'emi saíla niraga ra'ichamio napu'lige Onorúgame 'yuga ra'íchachi ne. Uchéchigo bilé rió 'ma ra'íchale 'emi saíla niraga. Moisesi ju alué napu 'emi saíla niraga ra'íchale, alué napu 'emi 'we galele. 'Émika buwé mochí napurigá gu'írimala nobi alueka 'máchigo 'emi saíla niraga ra'íchale ko, 'lige osiruga chujkú apélichi napu ra'íchale Moisesi. ");
INSERT INTO tacNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","'La bijchiá ju 'emi tabilé bijchígiligo Moisesi ra'ichálila, alueka ne'chí gu'íriga osale 'lige 'émika tabilé bijchíginiligó napu ne ruwí. ");
INSERT INTO tacNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","'Emi tabilé bijchígasaká napu Moisesi osale, 'liko tabilé bijchígimala napu ruwimela ne. ");
INSERT INTO tacNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","'Lige nujubapi 'ma ra'ichasa Esusi ye ralámuli 'yuga alé Rusaleni, simile alé wa'lú ba'wí ilígichi napu Galilea anilime ju. 'Lige abiena Tibériasi anilime nílechigó alé napu alué ba'wí maní. 'Lige bajonile alé wa'lú ba'wí manígichi. ");
INSERT INTO tacNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","We'ká ralámuli Esusi najátale, etéligame alué ralámuli 'we a'lá semáriga sa'wachi jaré ralámuli 'we nayume. Pe bo'né 'nátaga sa'wale Onorúgame a'walílate. Alué ralámuli etele Onorúgame gu'írio alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","'Lige Esúsika bilena rabomi simile 'lige alemi asale alué makué oká rió Esusi oyérame 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pe u'kabi rawé rokáréle napurigá sebámili nílige raweli napu piesta newame nile alué ralámuli jurío napu Páskua aneme nile alué a'boi. ");
INSERT INTO tacNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Esúsika etele we'ká ralámuli moyena e'yénigichi alérimi Esusi ajtígichi. A'lige Esusi anele Belipe: ―¿Koche raliboa baní napurigá go'mela alakí ralámuli? ");
INSERT INTO tacNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Alarigá anele Esusi, pe machináliga pa'lá bijchigio wa'lú a'walí nígame ko Esusi. Esúsika 'ma 'la machile churigá 'yamio go'ame alakí ralámuli, Esúsika pe rukele. ");
INSERT INTO tacNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Belípeka nejele: ―Ne, rekó enomígame nísaká osá naó mechá nochárigame, pecha sebárimilikó ne baní ralá alakí ralámuli kógimia, pecha o'má nachuámiligó rekó nasípasi chi'wánaga 'yalía a'pílipi ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","'Lige Antresi, napu Simoni Pegro ba'chila nile, alué napu abiena Esusi oyérame nílechigó, 'lige alué rioka anele Esusi: ");
INSERT INTO tacNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Jena ajtí bilé re'malí maligi baní o'kame sebárate newárigime 'lige oká ro'chí, nobi asíriga u'tá go'ame júkó napurigá go'mela alakí ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","'Lige Esusi anile: ―Jena rabó kilí mochíniliwa ralámuli. 'We gajsalégichi nile alé rabó. I'kilí mochíbale alué maligi mili pe riocho tétiga, tabilé tétiga umugí nibilé u'kuchítiri. ");
INSERT INTO tacNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","'Lige Esusi alué baní 'wile 'lige cheliera 'yale Onorúgame 'lige suwábaga ralámuli 'yale alé mochígichi. A'chigóriga olale alué ro'chí 'yuga. Ralámuli kógile napusí 'ma bosasa. ");
INSERT INTO tacNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Napu'lige 'ma bosasa alué ralámuli, Esúsika alué bo'né gompaniérola nulele: ―'Ma napubuwa suwábaga napu rasírigame. Tabilé pe'tá pápua. ");
INSERT INTO tacNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","'Ma napubule suwábaga go'ame rasírigame 'lige bilé rosena a'tabé bochile. ");
INSERT INTO tacNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","'Lige etesa alué ralámuli ala'sichi Esusi, alué ralámulika anile: ―Bijchiá ye rió ruwime ju napu ané Onorúgame, alué napu nawámili nílige jena wijchimoba. ");
INSERT INTO tacNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Esúsika machile umériga o'toboli ko alué ralámulite wa'lula rey nulame newániliga, alekeri chíbika simile bilena rabó bi'neli asináliga. ");
INSERT INTO tacNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pe a'lige rawé 'ma alí, alué makué oká ralámuli Esusi 'yuga járome ku wa'lú ba'wí manígichi simíbale, pe a'bé nile napu go'ame go'ale ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","'Lige bilé bárkochi jímole alué ralámuli 'lige simíbale alé we'ká riógichi niraga Kapernaumi anilichi, pe alé ba'ichí bajuniga ju alé we'ká riógichi Kapernaumi. 'Ma chónale bijí bárkochi mochiga e'yénigichi alué ralámuli. Tabilé enale Esusi alué ralámuli 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Asíriga a'wágame eká ilile 'lige 'we o'pochía ilile ba'wí alé bárkochi. ");
INSERT INTO tacNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Napu'lige 'ma we'límana e'yénaga alué barko asagá maligi o usani kilómetro we'límana alé ba'ichí amoba, 'lige alué makué oká Esusi 'yuga járome etele Esusi 'naka enágichi ba'ichí amóbaka, napurigá we'echi amoba neraga enale ba'ichí kachi, 'lige 'we majale suwábaga alué makué oká ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","'Lige Esúsika regá anele: ―Pe ne ju, tase majawa. ");
INSERT INTO tacNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","'Liko 'ma tabilé majale alué ralámuli, bayele napurigá mómala Esusi alé bárkochi alué ralámuli 'yuga. 'Lige pe yati neraga 'ma sébale alué barko alé we'ká riógichi. ");
INSERT INTO tacNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","'Lige melénala rawé ralámuli napu ta'chó bajuniga ejtebile alé ba'wí manígichi, alué ralámulika machile pe bi'lepi barko chujkúligo alé, 'lige Esusi oyérame alé bárkochi simíboligo, 'lige Esusi tabilé simíligo alé bárkochi alué ralámuli 'yuga. A'liko regá 'nátale: «¿Kochiena ajtí Esusi?» ");
INSERT INTO tacNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","'Lige jaré barko jsile alé we'ká riógichi Tibériasika simíbigame. Alé a'bé sébale re'lege napu alué we'ká ralámuli go'álige baní napu Esusi cheliera 'yálige Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","'Lige machisáká tabilé ajtigó Esusi 'lige alué bo'né Esusi oyérame, suwábaga alué ralámuli jímole alé jaré bárkochi 'lige simíbale we'ká riógachi Kapernaumi anilichi Esusi 'yamia. ");
INSERT INTO tacNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","'Lige 'ma seba bajuniga, alé asale Esusi, 'lige alué ralámulika rukele: ―Mué benírame, ¿chiéniko seba mué jena? ");
INSERT INTO tacNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Esúsika nejele: ―Neka 'la bijchiá aní, 'émika ne'chí 'yaga e'yena 'láchigo semáriga bosáligimempá 'emi alué banite napu ne 'ya. ");
INSERT INTO tacNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tabilé 'la ju pe go'ámecho meka go'náliga nochalia. Go'ámeka tabilé anáchame ju. Abé a'lá júkuru 'yamía alué abé a'lá 'nátili napu nejí alué rió napu nawá 'pa rewagáchika. Alué a'lala 'nátili cha'pisúká 'la nabí mochímala 'emi 'pa rewagachi. Alué 'nátili abé a'lá ju me'tigá go'ame. O'nó Onorúgameka 'we ra'sáligá ajtí alué rió 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","'Liko alué ralámulika regá anele: ―¿Chonikiboli ju ramué napurigá 'la cha'piboa alué 'nátili? ");
INSERT INTO tacNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","'Lige Esúsika regá anele: ―Onorúgameka pe najkíguru napurigá 'la bijchígiwa alué rió ra'ichálila napu Onorúgame júlale. ");
INSERT INTO tacNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","'Lige anile alué ralámuli: ―Newágó pe bo'né a'walílate 'nátaga alué nóchali 'we semátiri napurigá 'la etéwampá ramué. A'lígeko 'la oyériwa alué mué na'tálila. ¿Chu'simi olágó mué? ");
INSERT INTO tacNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Moisésika newale bilé nóchali semátiri napurigá narémili nílige alué rijimala 'ya mochígame. Alé 'we wakígichi, Moisesi 'yale go'ame rewagachi nerúgame napu maná anilime nile. Regá aní 'ya nerúgame ra'íchali. Mué Esúsika, ¿chu'simi olágó? ");
INSERT INTO tacNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Esúsika anile: ―Neka 'la bijchiá aníguru. Oká baní nerúkuru rewigáchika sígame. Napu Moisesi 'yáleru alueka pe go'ame nile. Uché bilélaka abé najtékame ju. Ne O'nola Onorúgame 'sime ju nejía. ");
INSERT INTO tacNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Onorúgame nila baní, alueka ju alué rió napu rewagáchika nawágame ju 'lige alawá 'yame ju ralámuli jena wijchimoba mochígame. ");
INSERT INTO tacNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","'Lige ralámulika anele: ―Mué Wa'lula, ramué 'yawa alué baní senibí rawé. ");
INSERT INTO tacNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","'Lige Esúsika nejele: ―Ne ju alué baní napu alawá nejime ju. Alué ralámuli napu 'la oyera napu aní ne senibí 'la iwériga bejtélamala, tabilé siné e'luímala 'lige tabilé siné balámumala. ");
INSERT INTO tacNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nobi 'émika 'láchigo etégó ne'chí napu newá ne, abirigáchigo tabilé oyéramala 'emi ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ne O'nola Onorúgame 'ya ne'chí nóchali 'lige we'ká ralámuli, 'lige ne 'yuga nokísamala alué ralámuli. Neka tabilé mabúmala alué ralámuli. Neka 'la gu'írimala alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ne rewigáchika nawákuru tase pe napu ne newánili newamia. Neka 'la newamia nawákuru napu najkí alué ne O'nola napu ne'chí júlale. ");
INSERT INTO tacNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Alué ne O'nólaka najkí napurigá tabilé 'wesi we'kuámala ne alué ralámuli napu 'ya ne'chí. Onorúgameka najkí napurigá ku 'la ajánamala napu'lige Onorúgame gustisia olachi alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ne O'nola Onorúgameka najkí suwábaga alué ralámuli napu ekí oyérame ju ne'chí napu Onorúgame Inolá ju ne. Neka ku ajánirimala alué ralámuli napu'lige 'ma guwichí kachi ye gawí. Alué ralámulika ejperélamala Onorúgame 'yuga 'pa rewagachi senibí. ");
INSERT INTO tacNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","'Liko ralámuli jurío Esusi saíla neraga ra'íchale napugiti bo'nepi regá aníligame Esusi: «Ne ju baní rewigáchika nawágame.» ");
INSERT INTO tacNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","'Lige rukigá járiga a'bopi anile: ―¿Tacha Esusi ju ye rió, alué José inolá? 'We a'lá machiame ke ye rió o'nola, 'lige 'we a'lá machiáa ye rió eyela. A'lígeko ¿chonigá rewigáchika nawágame koríbeché? ");
INSERT INTO tacNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","'Lige regá nejele Esusi: ―'Ma a'rewa alieti ra'icha. ");
INSERT INTO tacNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tabilé 'wesi oyéramala ne'chí tabilé bayésaká Onorúgame alué ralámuli, alué Onorúgame napu ne'chí jula 'pa rewagáchika, uchéchigo ku ajánirimala alué ralámuli napu'lige seba raweli Onorúgame nawámili gustisia olamia ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Regá anime osale alué ralámuli 'we 'ya napu ruyame nile napu anele Onorúgame: «Onorúgame benírimili ju suwábaga alué ralámuli.» Alué napu 'la bení Onorúgame ra'ichálila 'lige napu 'la námaka benime ju, alué ralámuli júkuru napu ne'chí oyérame ju. ");
INSERT INTO tacNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","› Jena tabilé 'wesi etiáguru O'nó Onorúgame, pe necho, neka napu Onorúgame ajtí aleka nawagámpá. Pe necho júkuru Onorúgame etégame. ");
INSERT INTO tacNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","'La bijchígowa ne ra'ichálila. Alué ralámuli napu 'la oyera ne'chí ra'ichálila 'lige napu 'la e'wá napu ne nulá, alueka 'la Onorúgame 'yuga asimeli júkuru senibí. ");
INSERT INTO tacNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ne júkuru napurigá alué baní a'walí nejime napurigá 'la ejperélawa jena gawichí. ");
INSERT INTO tacNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Alué baní napu go'ale alué 'emi rijimala 'ya mochígame, maná anilime, alué baní napu go'ale bilena wakígichi e'yéniga tabilé riógichi, alué banika tabilé 'yale iwérali alué ralámuli napurigá sebámala rewagachi. ");
INSERT INTO tacNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ne júkuru alué baní napu 'pa rewagáchika nawágame ju, 'lige alué ralámuli napu 'la bijchígime ju napu ne ruyé, alueka 'la senibí ejperélamala. ");
INSERT INTO tacNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","'Lige aminabi anele: ―Neka napurigá baní ju, alué napu rewigáchika nawale. Bilé rió ye baní go'sáká, senibí niraga bejtélimili júkuru. Ye banika ne sa'pala júkuru 'lige neka ne bo'né sa'pala nejíguru napurigá me'liboa ne napurigá ralámuli jena wijchimoba ejperégame buyásimala chátiri bowechi ―alarigá anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","'Lige ralámuli jurío 'we ayoga ra'íchale a'bópika. 'Lige anile: ―¿Churigá bo'né sa'pala nejímalabeché ye rió napurigá go'mela ralámuli? Alarigá anile tabiléchigo námalakó napu anile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","'Lige Esúsika aminabi anile: ―Neka 'la bijchiá aníguru, 'emi tabilé go'sáká ne sa'pala, ne napu nawágame ju 'pa rewagáchika napurigá rió neraga, 'lige tabilé bajísaká ne elalá, 'liko 'emi tabilé Onorúgame Alawala alawégame nímala. Tabilé 'la na'támala Onorúgame 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Bilé rió napu ne sa'pala go'yame ju 'lige ne elalá bajime ju, alueka 'la Onorúgame Alawala nígame ju 'lige 'la senibí 'la Onorúgame 'yuga bejtélamala. (Esúsika pe anigá anile: «Alué rió napu 'la cha'pime ju ne ra'ichálila 'lige 'la e'wame ju, alueka 'la Onorúgame 'yuga asimela.») 'Lige anile: ―Neka alawá 'yámala uchéchigo siné napu'lige 'emi suwisá. Regá 'símala ne napu'lige seba raweli napu'lige Onorúgame wanápachi alué ralámuli chátili 'nátame 'lige 'we a'lá 'nátame. ");
INSERT INTO tacNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ne sa'pala go'sáká abé a'lá ju me'tagá go'ame go'yáa. Alueka 'la bijchiá 'la rewagachi sebárime kame. Abiénachigó abé a'lá ju ne elalá bajilia, alué kame 'la bijchiá sebárime ju 'pa rewagachi. ");
INSERT INTO tacNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Alué napu go'á ne sa'pala 'lige napu bají ne elalá, alueka 'la ne'chí sa'pálachi asimeli ju 'lige neka alué sa'pálachi asimeli júchigó. (Yeka regá anime júkuru, 'emi 'la oyérasaká ne'chí, neka tabilé siné a'rémala 'emi. Ne alawálaka 'la senibí 'la 'emi sa'pálachi asimela.) ");
INSERT INTO tacNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","O'nó Onorúgame júkuru alawá nejime, alué 'sílekuru ne'chí jula 'pa rewagáchika. Neka alué alawálate bejtékuru napu 'ya ne'chí. Bilé rió 'la oyérasaká ne'chí, a'lige neka bo'né alawala 'yámala alué rió. ");
INSERT INTO tacNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Alarigá ju baní napu rewagáchika nawá. Tabilé napurigá baní ju napu go'ale alué israelita 'ya mochígame, alué banika napu go'ale alué 'ya mochígame tabilé gu'írale rewagachi moyena. Bilé rió 'la go'yame ka ne nila baní, alueka 'la senibí bejtélamala. Rekó 'ma mukigé, uchéchigo siné ku narémala alawá. (Ye ra'íchalika regá anime júkuru: Bilé rió 'la e'wame Onorúgame ra'ichálila, alueka 'la tabilé injiérnochi simela.) ");
INSERT INTO tacNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Alarigá ra'íchale Esusi napu'lige benírile jurío ralámuli alé u'tá re'obachi «sinagoga» anilime, alé Kapernaumi anilichi we'ká riógichi. ");
INSERT INTO tacNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Napu'lige akesa ye ra'íchali we'ká Esusi oyérame, anile a'bopi: ―Asíriga nóchali kame ju ye ra'íchali beniaa. Tabilé 'wesi námamala. ");
INSERT INTO tacNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Esúsika tabilé akele regá ra'íchachi ye ralámuli, nobi 'láchigo machíleko se'wináriga ra'icha jago alué ralámuli, 'lige regá rukele: ―¿Ya 'ma guwana rujsúnale 'emi tabilé námame kóriká? ¿'Ma tabilé oyéranili 'emi ne'chí? ");
INSERT INTO tacNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","'We e'karúgame na'tálika ne 'la ruwichi ye ra'íchali, ¿chulámalaché 'emi ne'chí etea napu'lige re'pá rewagachi simichi ne napu asale ne 'yabé bajchabé rawé? ");
INSERT INTO tacNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Onorúgame Alawala júkuru iwérali nejime napurigá 'la semáriga ejperélawa. Ralámulika tabilé 'la semáriga ejperélamala tabilé Onorúgame Alawala 'yúgaká. 'La oyérasaká ra'íchali napu ne ra'icha, a'lige 'la nílamala 'emi alawá napu nejí ne. ");
INSERT INTO tacNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nobi jaré 'emi tabiléchigo bijchíginiligó ne ra'ichálila. Esúsika 'la machile napusí o'wínale ye nóchali, chieri ralámuli tabilé bijchígimili ye ra'íchali 'lige 'la machílechigó chieri 'símio nejía alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","'Lige aminabi ra'íchale Esusi: ―Jaré 'emi tabilé bijchíginili ne ra'ichálila, alekeri anéturu ne 'emi 'yabé bajchabé rawé tabilé 'wesi gainamio ne'chí oyeria tabilé narésaká O'nó Onorúgame nila iwérali. ");
INSERT INTO tacNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","'Liko we'ká Esusi 'yuga e'yéname 'ma tabilé aminabi si simíbale Esusi 'yuga, 'máchigo guwana rujsúligame. ");
INSERT INTO tacNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","'Lige Esusi rukele alué makué oká rió Esusi oyérame napu abé gompaniérola nile Esusi 'yuga: ―¿'Émichigó simánili 'lige 'ma a'rénili 'emi ne'chí? ");
INSERT INTO tacNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","'Lige Simoni Pégroka regá anele: ―Mué Wa'lula, ¿chieri 'yuga simáwawé ramué? Mué júkuru napu ra'íchame ju ra'íchali napu 'la nejkúrame ju napurigá rewagachi sebawa 'lige 'la Onorúgame 'yuga ejperélewa senibí niraga. ");
INSERT INTO tacNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","'La bijchígiliguru ramué mué ra'ichálila 'lige 'la machiáachigó mué ko Onorúgamete wanápurigame napurigá gu'írimala ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","'Liko Esusi anele: ―Ne bo'né wanapa 'emi makué oká rió, 'lige 'emi bilé tabilé 'la 'nata, ¡'ma riablo na'tálila 'nátale! ");
INSERT INTO tacNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jurasi olagá anile, alué napu Simoni Iskariote inolá nile. Jurásika bilé nile alué makué oká rió Esusi oyérame, nobi abé i'libékomi 'ma nejíliru Esusi alué riote napurigá Esusi 'ma o'toboa alué Esusi saíla mochígichi. ");
INSERT INTO tacNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","'Ma a'kinana Esúsika eyénale bochígimi ejiro Galilea anilichi. Tabilé eyénale alé Jurea anilichi napugiti alué e'wélala ralámuli jurío nuleme 'yaga e'yéniligime alué Esusi me'lináliga. ");
INSERT INTO tacNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","'Ma amulí sébachi nile alué piesta napu newame nile rojsate u'kuchí galí 'lige alé okome nile. (Alarigá nokame nile alué ralámuli jurío nélegá churigá nokame níligo 'we 'ya napu'lige e'yénilige alué ralámuli israelita Moisesi 'yuga 'we wakígachi tabilé rojégichi.) ");
INSERT INTO tacNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","A'lige alué Esusi nasípasi bonila 'lige nasípasi waíla regá anéleru Esusi: ―'Ma a'rewa ye ejiro Galilea, 'mi Jurea anilichi ejiro simiboa napurigá mué oyérame ralámuli 'la etémempá 'we semá 'sichi mué. ");
INSERT INTO tacNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Najkiáká napurigá we'ká ralámulite najátawa mué, tabilé chíbaka rejpílime júkuru. 'La simiame júkuru napurigá ralámuli 'la etémala. Mueka we'ká e'karúgame semá 'smíguru pe bo'né 'nátaga. Alekeri simibóaguru napurigá ralámuli 'la etémala. ");
INSERT INTO tacNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Regá aniá jale, tabilé bijchígiga Onorúgamete julárigame níligo Esusi. ");
INSERT INTO tacNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","'Lige Esusi regá anile: ―Tabilé 'cho seba raweli napu'lige Onorúgame jula ne'chí alé napu Jurea anilichi ejiro ju. Pe 'émika 'la simámala napuyéniko simánili. Tabilé chéré rekó pe napuyéniko simibie, 'émika pecha Onorúgamete nulérigime ka. ");
INSERT INTO tacNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Cha nokame ralámuli jena mochígame ka tabilé ayoga etiá 'emi a'bopi. 'Lige 'émika tabilé ayoga etiáchigó alué ralámuli, pe a'bopi kame 'emi, nobi ne'chika tabiléchigo ganíliga etiágó alué ralámuli. Neka 'la ruyéguru ralámuli jena wijchimoba ejperégame tabilé 'la ko napurigá noká alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Simasi 'emi alé piesta nerúgichi. Neka tabilé 'cho simela, tabilé 'cho sébampá raweli napurigá simeli ju ne. ");
INSERT INTO tacNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Regá anigá, alé Galilea anilichi rejpile. ");
INSERT INTO tacNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","'Lige napu'lige 'ma simasa alué Esusi nasípasi bonila 'lige nasípasi waíla alué piesta kólimia, Esusi abiena simile abé nujubapi. Esúsika chíbika simile. Tabilé najkile napurigá alué we'ká ralámuli etémala. ");
INSERT INTO tacNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Alué ralámuli jurío e'wélala 'we 'yaga e'yénale Esusi alé piéstachi, regá anigá a'bopi: ―¿Koche ajtípué alué rió? ");
INSERT INTO tacNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","'Lige alué ralámuli jurío tabilé e'wélala abiena ra'íchiga e'yénale alarigá ko Esusi, pe i'kilí ra'íchaga e'yénale alué ralámulika napurigá tabilé akimela alué uché jaré ralámuli alanigá e'yénachi alué ralámuli. Jaré ralámuli 'we a'lá rió kóríle Esusi. Jaréchigo tabilé 'la rió kóríle Esusi, 'lige pe 'yégiga ra'íchame kóríle. ");
INSERT INTO tacNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Alué ralámuli juríoka napu ekí tabilé e'wélala 'we majaga e'yénale alué jurío e'wélala, alekeri i'kilí ra'íchiga e'yénale. ");
INSERT INTO tacNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Alué piesta 'ma osá no rawé kachi suwíbame nile, 'lige 'ma nasípasi rawé enágichi alué piesta newásiga, 'lige Esúsika simile alé wa'lú re'obachi ra'pichí 'lige benírale. ");
INSERT INTO tacNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","'Lige jurío e'wélala pe e'negá ejtebile, 'lige regá anile alué ralámuli a'bopi: ―Ye rioka tabilé simígame ke eskuélachi. ¿Churigá 'la machíbeché suwábaga alué ra'íchali? ");
INSERT INTO tacNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Esúsika akele alanichi alué ralámuli, 'lige regá nejele: ―Ye ra'íchalika napu ne beniri tabilé ne nila ju. Ye ra'íchalika Onorúgame nila ju, alué napu ne'chí júlale. ");
INSERT INTO tacNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Bilé rió 'la sébali olánalisaká napu Onorúgame najkí, a'lígeko alué rió 'la machimela 'la Onorúgame nila ko ne ra'ichálila o tabilé Onorúgame nila ko. ");
INSERT INTO tacNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Bilé rió wa'lúlate julárigame napurigá rejcholi ruyémala uché jaré ralámuli, 'lige alué rió rejcholi ruyésaká uché jaré ralámuli napurigá 'we a'lá niraga etewa alué bo'né tase alué wa'lula, alarigá ka tabiléchigo 'la júkó. Nobi bilé rió 'la najkime ka napurigá 'la nerawa alué wa'lula napu ajchame ju, alueka 'we a'lá ra'íchame ju tabilé 'yégali. Alué rioka 'la semáriga 'nátame ju. Esúsika aminabi ra'íchiga rukele: ");
INSERT INTO tacNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","―¿'La bijchiá ju Moisesi 'síligo beniria alué nulalí 'emi? 'Lige 'emi tabilé 'wesi 'la sébali olá alué nulalí. 'Liko ¿chonigá ne'chí 'yaga e'yénaché 'emi ne'chí me'lináliga? ");
INSERT INTO tacNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","'Lige ralámulika anile: ―Mueka Remónisi alawala ajchágame ju. ¿Chieri rió me'linali mué? ");
INSERT INTO tacNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","'Lige Esúsika anile: ―Ne bilé rió 'yóturu sawalachi rawé, napu ju resíbalichi rawé, 'lige 'émika 'we e'karúgame 'nata mochíkuru. ");
INSERT INTO tacNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisésika 'emi nulélekuru napurigá rijpunawa isílala pe'tá guwala wi'chila u'kuchí kachi osá naó rawé kachi ochérisa, 'lige i'sínimi 'emi abirigá rijpúname ju napu'lige rawé resíbulichi ju osá naó rawé ajtígachi. ('Lige aminámichigó 'émika pe we'kaga ra'íchale tabilé machigá. Moisésika tabilé alué bo'né 'sile ye ra'íchali newá. Ye ra'íchali nulalí 'we 'yasi nerúgame nile ta'chó ochérachi Moisesi.) ");
INSERT INTO tacNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","'Lige pe 'la sébali olániliga napurigá nulale Moisesi, 'lige ¿chonigá ayóbeché 'emi ne'chí 'yuga 'la 'yochi ne bilé rió sawalachi rawé napu resíbulichi ju? ");
INSERT INTO tacNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tabilé ayowa ne'chí 'yuga pe etega napu 'smi ne. 'We a'lá na'tawa Onorúgame 'yuga. Alarigá machimela 'emi ne 'we a'lá sébali olao. ");
INSERT INTO tacNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","'Lige jaré ralámuli napu Rusaleni ejperégame nile regá anile: ―¿Tabilé ye rió ju napu e'wélala me'lináliga e'yena? ");
INSERT INTO tacNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ma'chiná ra'icha ilíkuru 'lige alué e'wélalaka tabilé che anégurú. ¿'Ma mayéligirémá alué ko napu Onorúgame julámorílige jena napurigá ralámuli gu'írimala, alué Kristo anilime? ");
INSERT INTO tacNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ramueka tabilé mayelia Kristo ko ye rió. Kristo sebásaká pecha machibógó chieri puébloka nawigó. Ramueka 'la machiaa kochiénaka nawigó ye rió. ");
INSERT INTO tacNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","'Lige alieti akigá Esusi napu'lige beniria ilile alé ra'pichí, anile a'wágame ra'íchaga: ―'Émika 'la machí ne'chí, 'lige kochiena bejtégame ko ne, nobi tabiléchigo machígó 'emi alué wa'lula napu ne'chí jula jékana. Neka tabilé pe bo'né 'nátaga nawá jena. Neka julárigame júkuru alué gite napu 'la bijchiá ju. 'Lige 'émika tabilé machí alué. ");
INSERT INTO tacNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Neka 'la machí, neka alué 'yuga bejtégame kame. Alué 'smi ne'chí jula jékana. ");
INSERT INTO tacNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","'Lige alué ralámuli Esusi cha'pinánile nobi tabiléchigo umébale ko alué ralámuli. Onorúgame tabilé 'cho najkile napurigá ralámuli Esusi cha'pimela. ");
INSERT INTO tacNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","We'ká ralámuli 'la bijchígile Onorúgamete julárigame ko Esusi, 'lige anile: ―Ye rioka 'la semátiri nóchame ju pe bo'né 'nátaga napu tabilé umébame ju newá uché jaré ralámuli. ¿Chieri uché bilé arigá 'nátame nímalawé? Bi'neli alué Kristo júkuru 'we a'lá semáriga newame pe bo'nepi 'nátaga. ");
INSERT INTO tacNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Jaré bariseo machile alarigá ra'íchiga e'yenio uché jaré ralámuli pe tabilé bariseo. A'lige jaré alué bariseo 'lige balé e'wélala júlale jaré alué 'yuga nóchame sontalo Esusi cha'píniliga. ");
INSERT INTO tacNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","'Lige Esusi regá anile: ―Neka pe u'kabi mechá asimela jena 'emi 'yuga, 'lige 'ma simea olá ne ku napu ajtí alué napu ne'chí jula. ");
INSERT INTO tacNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","'Émika ne'chí 'yáamala, 'máchigo tabilé rewimélagó 'emi ne'chí. Pecha gainámalagó seba napu ne asimela. ");
INSERT INTO tacNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","'Lige alué ralámuli jurío a'bopi regá anile: ―¿Kochiena simé oláwé ye rió napu ramué tabilé rewiboa? ¿Alé uché bilena riógachi simé olale napu jaré ralámuli jurío mochí alué uché jaré ralámuli 'yuga napu se'wináriga ra'íchame ju, amináchigo uché jaré ralámuli benírimia? ");
INSERT INTO tacNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ye rió aní ramué simáwaráo 'yawa alué rió 'lige tabilé rewibóráo, 'lige aminami tabilé sebáwaráo napu asimeo bo'né. ¿Chonióríbeché alarigá? ");
INSERT INTO tacNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","'Lige 'ma abé guwichí kachi, napu abé wa'lúlachi rawé kachi, Esúsika o'weti ilísale 'lige bilé ra'íchali ruwile a'wágame ra'íchiga: ―'We balámisiká 'lige 'la oyérasaká ne ra'ichálila, akiná simasi 'lige bajiwa ba'wí. ");
INSERT INTO tacNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Alarigá anime nile Onorúgame ra'ichálila 'ya nerúgame: «Alué rió napu 'la oyeri ne'chí aleké riochi ba'wí ma'chínamala ba'wí napu nejime ju iwérali napurigá 'la ejperélawa.» ");
INSERT INTO tacNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ye ra'íchali ka ruwime nile ralámuli napu ekí 'la bijchígime ju Esusi ra'ichálila 'la narémili níligo Onorúgame Alawala. Ralámulika tabilé 'cho narea mochile alué Alawá, tabilé 'cho 'moga asáligame Esusi ku 'pa rewagachi. ");
INSERT INTO tacNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jaré ralámuli akesa alanichi Esusi, anile alué ralámuli: ―'La bijchiá ye rió ruwime ju napu ané Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","'Lige jaré regá anile: ―Ye rió Esusi alué Kristo ju, napu ralámuli buinámili ju chátiri bowechi. 'Lige jaré regá anile: ―Krístoka pecha ejiro Galiléachi ochérimili júkó. ");
INSERT INTO tacNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","'Ya nerúgame ra'íchalika Onorúgame ra'ichálila aní Kristo Rabí rijimala nimio 'lige alé Beleni anilichi ochérimio napu bejtégame nile Rabí. ");
INSERT INTO tacNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","'Lige we'ká 'nata mochile, 'lige we'ká ra'íchale a'bopi. Jaréchigo 'la galeme nile Esusi, 'lige jaréchigo tabilé galeme nile. Alarigá 'nata mochile. ");
INSERT INTO tacNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Jaré ralámuli Esusi cha'pinánile nobi tabiléchigo 'wésite cha'píliriko Esusi. ");
INSERT INTO tacNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","'Lige 'ma ku ro'isa alué sontalo, alué e'wélala balé 'lige bariseo rukele alué sontalo regá: ―¿Chonigá tabilé a'párupaché? ");
INSERT INTO tacNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","'Lige sontáloka nejele: ―Tabilé siné akeme nírige ramué aliena semátiri ra'íchame napuyena alué rió. ");
INSERT INTO tacNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","'Lige bariséoka anile: ―¿'Ma umériru 'émichigó alué riote alarigá ra'íchiga? ");
INSERT INTO tacNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Alué e'wélala ralámuli jurío nuleme 'lige alué bariseo e'wélala 'ma bijchígile alué rió ra'ichálila? Tabilé siné bijchígilime niru ramueka nibilé alué e'wélala. ");
INSERT INTO tacNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ralámulika napu ekí Esusi ra'ichálila bijchígame tabilé pe'tá machí Moisesi nila rejcholi. Alué Esusi oyérameka pe se'wináriga 'nátame ju. Onorúgame 'ma suwábamala suwábaga alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","'Liko bilé rió Nikoremio anilime ruwile bilé ra'íchali. Alué rioka bariseo nile 'lige simile bilé rukó Esusi e'nemia 'Lige anile: ");
INSERT INTO tacNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Regá aní ramué nila ra'íchalika: tabilé lisensia nígame niru ramué napurigá gastigáriwa bilé rió tabilé akésiga ramué a'boi alanichi bilé rió. 'La 'we a'lá machiame júkuru bajchá. ");
INSERT INTO tacNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","―¿Chonigá alaníbiché mué? ―anile uché jaré ralámuli―. ¿Muéchigó Galilea bejtégame júchigó? ¿Alué rió gompaniérola niraga ra'icha mué? 'We a'lá e'newa osilí 'ya nerúgame Onorúgame nila. 'Lige alé machimela mué tabilé Galiléaka nawamio bilé rió napu ruwime ju napu ané Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","A'lige a'pílipi ralámuli simíbale ku a'boi ejperélachi. ");
INSERT INTO tacNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Esúsika simile alé rabomi alé a'bé napu ju Rusaleni anilichi napu we'ká jale rojá Olibo anilime. ");
INSERT INTO tacNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","'Lige melénala 'ma che'lisá, Esúsika alé wa'lú re'obachi ra'pichí simile. Suwábaga ralámuli napu alé wa'lú re'obachi ra'pichí mochile a'bemi jábale alemi napu Esusi sébachi, 'liko Esusi alé asíbale 'lige benírale. ");
INSERT INTO tacNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","A'lige alué we'ká benírame napu Moisesi ra'ichálila benírame nile 'lige aminami jaré bariseo bilé mukí a'pale alé. Alué mukika bilénami rewirúgame nile uché bilé rió 'yuga gojchichi napu tabilé alué bo'né mukí 'yula nile. 'Lige alé nasipa elale. ");
INSERT INTO tacNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","'Lige anéliru Esusi: ―Mué benírame, ye mukika cha'pirú gojchiá bo'ígichi bilé rió 'yuga napu tabilé bo'né 'yula nílige. ");
INSERT INTO tacNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisesi ra'ichálila anime júturu me'liame ko rejtete basibuga bilé mukí ala'sime napurigá 'sile ye mukí. ¿Mueka chonígó? ");
INSERT INTO tacNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Alué ralámuli benírame 'lige bariseo alarigá rukele. Alué ralámulika pe najkigá nokáligime napurigá Esusi se'wináriga animela tase napurigá anile Moisesi, 'lige gastigáriniliga nokale Esusi se'winá anisáká. 'Liko Esusi rojpóchiga wijchí e'nagá asíbale 'lige osale makúsate wijchí we'echi. ");
INSERT INTO tacNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","'Lige alué we'ká benírame 'lige bariseo aminabi rukele, 'lige Esusi o'weti ilísiga alué ralámuli mochígichi e'nele 'lige anele: ―Apiépiri napu tabilé resí 'sika ilírome ju, alué bajchá basibúmili ju ye mukí. ");
INSERT INTO tacNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Uchéchigo ku rojpóchiga asíbale 'lige abichilubi osale wijchí we'echi. ");
INSERT INTO tacNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","'Lige ralámuli akisá alanichi Esusi, 'liko alué ralámuli simíbale. Bilé bajchá simile 'lige uchéchigo bilé. Abé bajchá simíbale alué abé o'chérame ralámuli. 'Ma bi'neli rejpile Esusi alé pe alué mukicho 'yuga napu bijí alé ilile. ");
INSERT INTO tacNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","A'lige Esusi o'weti ilísiga, 'lige rukele: ―¿Koche simíbale? Tabilé 'wesi i'tékuru napu mué bajsibuga me'linálile. 'Lige alué mukika regá nejele: ");
INSERT INTO tacNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","―'Ma tabilé 'wesi i'té. 'Lige Esúsika anele: ―Néchigó tabilé che olámala mué. Jípeko simigá 'lige tase se'winá 'sika einawa. ");
INSERT INTO tacNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","'Liko Esusi uchéchigo ra'íchale alué ralámuli 'yuga alé ra'pichí, regá ra'íchiga: ―Ne júkuru napu ra'ósili nejime ju jena gawichí. Pe necho ju ralámuli gu'írime Onorúgame 'yuga na'tálichi. Alué napu ne'chí oyérame ju, alueka 'la nílimala Onorúgame nila 'nátili napurigá 'la machimela churigá ko Onorúgame, 'lige aminami napurigá 'la machimela chieti ko ralámuli cha nokame. Alué ne'chí oyérame ka tabilé Remónisi 'yuga na'támala. Alueka tabilé chónagachi niraga e'yénamala. ");
INSERT INTO tacNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","'Liko alué bariseo regá anele: ―Mueka ruwí churigá ko mué bo'nepi. Tabilé najtékame ju alarigá. Rokáré bilé rió napurigá ruwimela churigá ko mué. ");
INSERT INTO tacNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","A'lige Esusi regá anele: ―Tabilé chéré rekó bo'nepi ruyé ne churigá ko ne. Ye ra'íchali napu ruwí ne 'we najtékame ju. Neka 'la machí kochiénaka nawagó ne 'lige kochiena simea ne, 'émika pecha machígó kochiénaka nawagó ne 'lige kochiena simea ne. ");
INSERT INTO tacNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","'Émika tabilé e'wame ju napu aní Onorúgame, 'émika pe e'wame ju napu aní ralámuli. Neka 'la e'wame ju napu aní Onorúgame 'lige tabilé gustisia olame ju ne ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ne gustisia olásaká jaré ralámuli, 'lige napu ne ruimeli ju 'la bijchiá nímala, néchigó 'yuga ajtigámpá alué Wa'lula O'nó napu ne'chí jula. ");
INSERT INTO tacNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","'Emi bariseo nila ra'íchalika anime júkuru: napu'lige oká rió 'la a'chigóriga ruwisá bilé ra'íchali, 'la najtékame ko alué ra'íchali napu ruwí alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Neka ruwíguru napu nocha ne bo'né 'lige alué ne O'nola napu júlale ne'chí ruwíguruchigó napu nocha ne. Alekeri 'la najtékame ju napu ne ruwí. ");
INSERT INTO tacNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","'Liko rukéliru Esusi alué ralámulite: ―¿Kochiena ajtí mué o'nola? 'Lige Esúsika regá anele: ―'Émika tabilé machí chieri ko ne, 'lige tabilé machí chieri ko ne O'nola. 'La machime nísaká 'emi chieri ko ne a'lígeko 'la machimeli ke 'emi chieri ko ne O'nola. ");
INSERT INTO tacNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Esusi ye ra'íchali ruwile alé wa'lú re'obachi alé ra'pichí iligá alé napu enomí ajchame nile ralámuli Onorúgame kógiga. A'lige tabilé 'wésite cha'píliru Esusi, tabiléchigo 'cho sébachi níligame raweli napurigá cha'piboa Esusi. ");
INSERT INTO tacNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","'Liko Esusi regá anele: ―Neka simela 'lige 'émika ne'chí 'yáamala, 'lige suwimela 'emi tabilé bi'wigá chátiri 'nátili. 'Émika pecha gainámalawé simiba napu ne simeli ju. ");
INSERT INTO tacNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","'Lige alué ralámuli jurío e'wélala regá anile: ―Alué rioka ruwíguru tabilé siné gaináwaráo simiba ramué alé napu simeli ju alué bo'né. ¿Pe bo'nepi me'lináliga aniéréma? ¿Ala'síniliga aniéréma napurigá tabilé rewibómpá ramué simásiga alué 'yasia? ");
INSERT INTO tacNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Esúsika regá anele: ―'Émika pe napurigá ralámuli jena wijchimoba mochígame alarigá 'nátame ju. Neka napurigá Onorúgame alarigá 'nátame júkuru. 'Émika jena wijchimoba ejperégame júkuru. Neka jena wijchimoba bejtégame ju, nobi 'pa rewagáchika nawágame júkó ne. ");
INSERT INTO tacNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Neka 'ma 'la aniéturu suwimeo 'emi tabilé 'la bi'wigá alué chátiri 'nátili, 'emi 'yuga rejpimio alué chátiri 'nátili. Tabilé bijchígasaká 'emi ne ko napu aní ne 'liko suwimela 'emi chátiri 'nátili 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","'Lige alué ralámuli jurío regá rukele: ―¿Chieri ju mué? 'Lige Esúsika regá nejele: ―Neka 'ma ruwíturu 'yabé bajchibé rawé. ");
INSERT INTO tacNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","We'ká e'karúgame ra'íchali nerú napu tabilé ruimé néká rekó ne 'emi saíla niraga ra'íchie, 'we cha nokágame kórigá 'emi, nobi tabiléchigo ruiméligó ne napu ne bo'né 'nata. Jena wijchimóbaka pe napu aké ne alué wa'lula ra'ichálila, pe aluecho ruwimela ne. Alué wa'lula napu júlale ne'chí, alueka nabí 'la tabilé 'yégiga ra'íchame ju. ");
INSERT INTO tacNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Alué ralámuli tabilé machile alué O'nó Onorúgame olagá anió. ");
INSERT INTO tacNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","'Lige Esusi regá anele alué ralámuli: ―Jípeko napurigá bilé rió, alarigá ju ne napurigá 'emi. Napu'lige ne gulusichi ujchagá me'lisuga, ne napu ju Onorúgamete nulérigime 'pa rewagáchika napurigá rió neraga, 'lige 'ma ku rewagachi simisá ne, a'lige kulí machimela 'emi ne ko napu ne koriání ne bo'né. Neka tabilé 'wesi nóchali newame ju ralámuli na'tálilate. Neka pe napurigá nuleru O'nó Onorúgamete, pe alarigacho nóchame ju ne. ");
INSERT INTO tacNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Alué napu ne'chí jula, ne 'yuga ajtí jena wijchimoba. Ne O'nola tabilé bi'neli a'ré ne'chí. Neka nabí 'la sébali olame ju napu 'la galeme ju alué bo'né, alekeri jena ajtí ne'chí 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ye ra'íchali ruyá ilígichi Esusi, we'ká ralámuli 'la bijchígale. 'La bijchígale alué rió ko napu korílige bo'né. ");
INSERT INTO tacNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","'Liko Esusi regá anele alué ralámuli jurío napu 'la bijchígile alué Esusi ra'ichálila: ―'Emi aminabi cha'písiga nokísasaká ye ra'íchali ne ra'ichálila, a'lígeko 'la bijchiá ne'chí oyérame nímala 'emi. ");
INSERT INTO tacNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","A'lige 'we 'la machimela 'emi 'la bijchiá ra'íchali. 'Lige tabilé cha'piruga mochímala 'emi alué Remónisi na'tálilate. 'Lige tabilé nochámala 'emi pe napurigá ralirúgame niraga. ");
INSERT INTO tacNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","'Lige alué ralámuli juríoka regá anile: ―Ramueka Abraámi rijimala niru 'we 'ya bejtégame. 'Lige tabilé siné napurigá ralirúgame ralámuli niru ramué bilé wa'lúlate. A'lígibeché, ¿chonigá alaníché mué napurigá bilé wa'lúlate ralirúgame ralámuli nírigo ramué? Peka ralirúgame nírigichi ramué. ");
INSERT INTO tacNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","'Lige Esúsika regá anele: ―Neka tabilé 'yégiga aníguru. Bilé rió 'we resí 'sime, alué rioka chátiri 'nátalite cha'pirúgame júkuru. ");
INSERT INTO tacNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Bilé rió 'la bo'né o'nola ranálaka 'la lisensia nígame ju napurigá nulámala bo'né bejtélachi a'chigóriga napurigá bo'né o'nola, 'lige bilé pe ralirúgame, alueka tabilé lisensia nígame ju napurigá nulámala alé galírale. O'nó mukusáká, pe bo'né inolacho niga rejpímala alué o'nola nila. ");
INSERT INTO tacNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","'La námasaká 'emi ne ra'ichálila, 'liko 'la Onorúgame 'kúchila nímala 'emi, tase napurigá bilé rió ralirúgame nímala 'emi. ");
INSERT INTO tacNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Neka 'la machí Abraámi rijimala ko 'emi, nobi tabiléchigo bijchíginiligó 'emi napu ruwí ne, 'lige alekeri 'émika 'ma me'linali ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Neka 'la sébali oláguru napu ne O'nola nulé ne'chí. 'Lige 'émika 'la sébali oláguru napu 'emi o'nola nulé. ");
INSERT INTO tacNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Alué ralámuli juríoka regá anele: ―Ramueka Abraámi rijimala niru. Alueka pe napurigá ramué o'nola, alarigá ju. Nobi Esúsika regáchigo anélekó: ―'Emi 'la bijchiá Abraámi rijimala nísaká, a'chigóriga nokimélaké 'emi napurigá 'sile Abraámi. ");
INSERT INTO tacNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Neka tabilé 'yégiga ruwíguru churigá benírigo Onorúgame ne'chí, nobi abirigáchigo 'ma me'lináligo 'emi ne'chí. Abraámika tabilé siné alarigá 'sile. ");
INSERT INTO tacNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","'Émika a'chigóriga nokáguru napurigá nokame nile alué 'émi o'nola. 'Lige alué ralámuli juríoka regá anele: ―Ramueka 'la bijchiá Onorúgame 'kúchila niru. Tabilé waná o'nógame. Ramueka pe bi'lepi Wa'lula O'nógame niru napu ju Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","'Lige Esúsika regá anele: ―'La bijchiá Onorúgame 'kúchila nísaká 'emi, a'lige 'emi 'la ganíliga etémiliké 'emi ne'chí, neka Onorúgamechika nawágame kame 'lige nocha ajtí ne jena nóchali napu bo'né Onorúgame 'ya ne'chí. Neka tase pe bo'né 'nátaga nawá jena wijchimoba. Alué napu ne'chí jula, alué 'smi ne'chí ajchá jena. ");
INSERT INTO tacNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Chonigá tabilé námaché 'emi napu ruwí ne? ¿Tabilé akénili ne ra'ichálila? ");
INSERT INTO tacNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","'Émika Remónisi 'kúchila júleké 'liko, 'lige 'we a'lá e'wéguru 'emi napu nulá alué 'emi o'nola. Remónisika 'we nejkógame ju we'ká ralámuli me'ágame 'lige tabilé siné 'la bijchígame ju alué 'la tabilé 'yégali ra'íchali. Alueka tabilé pe'tá bijchigi alué 'la semátiri ra'íchali 'la tabilé 'yégali. Alué ju 'la bijchiá 'yégame me'tigá suwábaga, 'lige o'nola ju suwábaga ralámuli napu 'yégiga ra'íchame ju. Alueka senibí napu ra'icha, pe 'yégalicho ra'íchame ju. Alieri ju alué Remónisi. ");
INSERT INTO tacNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Neka tabilé 'yégiga ruwíguru 'lige 'émika tabilé bijchíginili ye ne nila ra'íchali. ");
INSERT INTO tacNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Chieri 'emi 'la machígó ne cha 'sika ilírome ka? Ruisígó. Neka peka siné 'yégiga ra'íchame kachi, 'lige ¿chonigá tabilé bijchígibeché 'emi napu aní alué ra'íchali? ");
INSERT INTO tacNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Bilé ralámuli napu 'la Onorúgame ranala ju, alueka 'we a'lá gepume ju Onorúgame ra'ichálila. 'Émika tabilé gepúnilime ju ye ra'íchali, tabilé Onorúgame 'kúchila kame 'emi. ");
INSERT INTO tacNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","'Liko alué ralámuli jurío regá rukele: ―¿Tabilé bijchiá ju alé wa'lú ejiro Samaria anilichi bejtégame ko mué? 'Lige ¿remónisi u'kuchípala alawala ajchágame ju mué? ");
INSERT INTO tacNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Esúsika regá nejele: ―Neka tabilé remónisi u'kuchípala alawala ajchágame ju. Neka 'la nirame ju ne O'nola, nobi 'émika tabiléchigo nirágó ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Napu'lige semá 'sichi ne, neka tabilé najkigá 'smi napurigá ralámuli wa'lula neraga etémala ne'chí. Abiena ajtí uché bilé napu najkí napurigá ralámuli 'la wa'lula neraga etémala ne'chí 'lige 'we a'lá niraga. Alué napu gustisia olame ju ralámuli, alueka Onorúgame ju. ");
INSERT INTO tacNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Neka tabilé 'yégiga aníguru, 'la bijchiá ju napu ruwí ne. Bilé rió 'la sébali olásaká napu nulá ne nila ra'íchali, alué rioka tabilé siné mukumela. ");
INSERT INTO tacNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Regá anile 'liko alué ralámuli jurío: ―Jípeko abé 'la bijchiá mayelia bilé remónisi ajchágame ko mué. 'Ma mukule Abraámi 'lige alué 'ya mochígame ralámuli napu ruwime nile napu anele Onorúgame, 'lige mueka aní: «Bilé rió 'la sébali olásaká napu nulá ne nila ra'íchali, alué rioka tabilé siné mukumela.» ");
INSERT INTO tacNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Mueka abé najtékame ju me'tigá alué Abraámi napu ramué rijimala ju, alué napu 'ya asale jena? Alueka 'ma 'ya mukule 'lige alué ralámuli napu ruwime nile napu anele Onorúgame 'ya mochígame abiénachigó 'ma suwile. ¿Mueka chieri korígó mué bo'nepi? ");
INSERT INTO tacNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","'Lige Esúsika anele: ―Bo'né anisáká ne 'we najtékame ko ne, 'lige 'we a'wágame ko ne, wa'lú nígame ko ne a'walí, a'liko tabilé najtékame ju alué ra'íchali. Neka tabiléchigo alarigá anígó. Ne O'nola Onorúgame ju napu aní 'we najtékame ko ne, 'lige alué ju napu ne'chí 'ya iwérali. 'Émika abiena alaníchigó 'emi O'nola ko alué Onorúgame. Aba alué ju napu 'we a'lá niraga eté ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","'Émika tabilé machí alué Onorúgame nobi neka 'we a'lá machígó. Ne anisáká tabilé machime ko ne alué Wa'lula Onorúgame, 'liko 'we 'yégame nímili ke ne napurigá 'emi. Neka 'láchigo machígó alué Onorúgame 'lige 'la sébali olame ju ne napu ne'chí nulé Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","'Emi rijimala, alué napu 'we 'ya bejtégame nile, Abraámi anilime, 'we ra'sáligá asale, alueka 'máchigo 'la machigá asáligame siné rawé nawámili níligo ne jena wijchimoba. Alueka etele ne'chí, alekeri 'we ra'sálále. ");
INSERT INTO tacNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","'Lige alué ralámuli juríoka regá anile: ―Mueka pecha malígisa makué bamígame júkó, 'lige mueka 'la etégorí alué Abraámi. Napu'lige bejtele alué Abraámi jena 'ma we'ká siento bamí júkuru. ");
INSERT INTO tacNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","―Neka 'la bijchiá aní ―anile Esusi― tabilé 'cho ochérachi Abraámi, neka 'ma jena ajtigéturu. Neka nabí jena ajtime ju. Alarigá ju. ");
INSERT INTO tacNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","'Liko rejté 'wile alué ralámuli jurío Esusi basibumia, nobi Esúsika simile alé nasipa we'ká jágichi ralámuli alé ra'pichí wa'lú re'obachi. ");
INSERT INTO tacNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","'Lige Esusi abisibi 'we eyénale, 'lige alemi enegá etele bilé rió tabilé ma'chílime, alué rioka aba alieri ochérigame nile. ");
INSERT INTO tacNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","'Lige alué Esusi oyérame rukele: ―Mué benírame, ¿chonigá tabilé ma'chílime ochérile ye rió? ¿Cha nokale alué bo'né o'nola 'lige eyela, alekeri gite alarigá ochérale? O ¿alué bo'né 'we resí 'sika ilírome nile? ");
INSERT INTO tacNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","'Lige Esúsika nejele: ―Alué rioka tabilé siné resí 'sika oyame nile napurigá nayúmala, nibilé alué o'nólatiri cha 'sika oyame nile nibilé eyélatiri. Ye rioka tabilé ma'chílime júkuru napurigá ralámuli etémala chiena a'wágame ko Onorúgame, 'lige 'la bijchiá sa'wame ko Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Neka 'yóma olágurú jipe. Abirigá sa'wámili júkuru ne napurigá nulá Onorúgame jipe ta'chó sébachi resítiri raweli. Pe 'we sebámili júkuru chátiri raweli, 'lige ta'wesi ralámuli gainámala sa'wá bilé nayume. ");
INSERT INTO tacNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ne bijí jena wijchimoba eyena 'we gu'íriga suwábaga ralámuli napurigá 'la machimela chiena a'wágame ka Onorúgame. Napurigá bilé ra'ósali niraga ju ne napurigá alarigá 'la buyásiwa alé resítiri bowechi. ");
INSERT INTO tacNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Pe nujubapi alué Esusi napu'lige ra'ichasa, alé wijchí a'kichile 'lige pe'tá we'é wejsole a'kiate, 'lige alué rió tabilé ma'chílime busílachi ujchele. ");
INSERT INTO tacNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","'Lige anele: ―Simigá bisigome alé 'mi wa'lú ba'wichí napu Siloé anilichi ju. Siloeka pe, «julárigame» aniame ju. 'Liko Esúsite julásiga alué rió tabilé ma'chílime, 'liko simile 'lige bisigole, 'ma pagole bo'né busila, 'lige napu'lige 'ma ku nawá 'ma ma'chílime nawale. ");
INSERT INTO tacNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","'Liko alé a'bemi riógame napu 'yasi eteme nile alué rió tabilé ma'chílime, anile a'bopi: ―¿Tabilé ye rió ju alué napu i'kilí asagá enomí táame ke? ");
INSERT INTO tacNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","'Lige jaré anile: ―Alué rió júpeché. 'Lige jaré anile: ―A lalanti júke'é kaka, nobi tabiléchigo alué júkó. 'Lige alué rió bo'né anile: ―Ne júpeché. ");
INSERT INTO tacNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","'Liko rukéleru: ―¿Churigá 'la ma'chili mué jípeko? ");
INSERT INTO tacNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","'Lige alué rioka regá nejele: ―Alué rió napu Esusi anilime ju pe'tá we'é wejsó a'kiate 'lige ujché ne busílachi, 'lige aníturu: «Simigá 'mi wa'lú ba'wichí Siloé anilime 'lige bisigówaká.» 'Lige neka yati simíturu alé wa'lú ba'wichí bisigomia. 'Lige 'ma bisigosa ne, yati 'la gayénaturu ne ma'chilia. ");
INSERT INTO tacNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","'Liko rukéleru: ―¿Koche ajtiko alué rió? 'Liko alué rió anele: ―Neka tabilé machí. ");
INSERT INTO tacNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","'Liko cha'pigá o'tóleru alué rió napu tabilé ma'chílime nílige alé 'mi napu mochile bariseo. ");
INSERT INTO tacNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","A'lige rawé napu'lige Esusi 'yole alué tabilé ma'chílime wa'lú rawé nile sawalachi rawé napu jurío resíbume nile, alueka tabilé nóchame nile 'lige tabilé 'yome nile a'lige rawé. A'lige alekeri alué ralámuli cha'pile alué rió napu tabilé ma'chílime nílige 'lige o'tóleru 'mi alé napu mochile alué bariseo. ");
INSERT INTO tacNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Alué bariséoka tabilé ganílile Esusi alieti 'yosa a'lige rawé wa'lú rawé resíbulichi, alekeri 'we iwégame rukéleru alué 'yórigame rió churigá 'la ma'chilia. 'Lige alué rioka regá nejele: ―Wejsogá ujché ne busílachi 'lige neka bisigóturu, 'lige 'we a'lá ma'chili ne jipe. ");
INSERT INTO tacNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","'Liko jaré bariseo anile: ―Alué rioka napu ye 'yole pecha Onorúgamete nulérigime júkó, napugiti pecha nerame kame wa'lú rawé. Alekeri tabilé Onorúgame oyérame júkuru alué rió. 'Lige jaré anile: ―¿Churigá 'la gayénabeché aliena 'la sa'wá napu 'we resí 'sika ilírome ke? Tabiléchigo 'la a'chigóriga 'nátiga aníleko alué bariséoka. ");
INSERT INTO tacNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","'Liko uchéchigo siné rukéleru alué rió napu tabilé ma'chílime nílige abé 'ya: ―Mueka, ¿chonígó alué rió olagá napu 'yole mué? 'Lige alué rioka anile: ―Neka aníguru pe bilé rió ko napu ruwime ju napu ané Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","'Lige alué jurío e'wélala tabilé bijchígale alué rió tabilé ma'chílime níligo 'lige 'yólirigo Esúsite alué rió. 'Liko alué rió o'nola 'lige eyela bayéleru. ");
INSERT INTO tacNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","'Lige rukéleru: ―¿'Emi inolá ju ye rió napu tabilé ma'chílime koriánié 'emi, napu tabilé ma'chílime ochérigame koriánié 'emi? ¿Churigá 'la ma'chílibeché jipe? ");
INSERT INTO tacNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","'Lige eyela 'lige o'nola regá nejele: ―'La machiáguru ye rió ramué inolá ko 'lige aminami tabilé ma'chílime ochérigo 'ya. ");
INSERT INTO tacNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Tabiléchigo machiágó churigá jipe 'la ma'chilia, 'lige aminami tabilé machiáguru chieri 'síligo busila 'yoa. Rukéwagó bo'né, 'ma 'la ruméleké alué 'síligo 'yoa, 'ma wa'lú kame. ");
INSERT INTO tacNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Alué eyela 'lige o'nola pe lanile majaga. 'Wéchigo 'la machíligame mabúwilikó ne'óchiga alué juríote alé u'tá re'obachi napu «sinagoga» anilime ju napuyépiri ralámuli napu bijchigi Esusi Onorúgamete julárigame ko. ");
INSERT INTO tacNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Alekeri aniá mochile: «Alué bo'né rukéwaguru, 'máchigo wa'lú rió kame.» ");
INSERT INTO tacNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","'Liko alué bariseo uchéchigo siné bayele alué rió napu tabilé ma'chílime nílige 'ya, 'lige anele: ―'La ma'chígime rupoa, Onorúgame gastigárimala mué tabilé 'la ruisáká, ramueka 'la machiáguru asíriga wa'lú resítiri 'síkame ko alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","'Liko alué rioka anile: ―Neka tabilé machí alarigá ko alué rió aliena resítiri ko. Neka pe bi'lepi tábiri machíguru, ne tabilé ma'chílime kéturu 'lige jípeko 'la ma'chíliguru ne. ");
INSERT INTO tacNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","'Lige uchéchigo siné rukéleru alué rió: ―¿Churigá 'la sa'wárukó mué alué riote? ");
INSERT INTO tacNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","'Lige alué rioka regá nejele: ―'Ma ruwí ne, 'émika tabiléchigo bijchíginiligó. ¿Chonigá najkíché 'emi napurigá uchéchigo siné ruyewa? ¿'Émichigó alué oyérame gainánili? ");
INSERT INTO tacNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","'Liko alué bariséoka asíriga ená anigá ra'íchale alué rió olagá. 'Lige anele: ―Mueka alué rió oyérame júkuru, 'lige ramueka Moisesi oyérame nírukuru. ");
INSERT INTO tacNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ramueka 'we a'lá machiáguru Onorúgame Moisesi 'yuga ra'íchiligo, nobi alué uché bilé rioka tabilé machiaa. Tabilé machiaa alemi bejtégame ko alué rió. ");
INSERT INTO tacNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","'Liko alué rió regá nejele: ―¿'La choninti 'emi? ¿'Émika tacha e'wélala niru? Ye rioka asíriga 'la nóchali nóchiga eyénaguru, 'la sa'wákuru ne'chí. 'Lige 'émika tabilé machióríguru kochiena ajtígame ko. ¿'Émika tacha machíbeché ye? ");
INSERT INTO tacNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","'We a'lá machirúguru Onorúgameka tabilé gepume ko alué ralámuli napu 'we resí nokigá e'yéname ju, Onorúgameka pe alué napu tabilé resí nokigá e'yéname ju, pe aluecho gepume ju, pe aluecho napu 'la e'wame ju napu Onorúgame nulá. ");
INSERT INTO tacNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tajsiné akiame kéturu bilé rió Onorúgame a'walila nígame ko napurigá bilé ralámuli sa'wámala tabilé ma'chílime ochérigame. ");
INSERT INTO tacNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Alué rió tabilé nígame nísaká Onorúgame a'walila 'liko pecha gainámalakó sa'wá bilé rió tabilé ma'chílime ochérigame. ");
INSERT INTO tacNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","'Liko alué bariseo anele 'we ayóniga: ―Mueka, asíriga resítiri sulega ochérale, alekeri tabilé ma'chílime ochérale mué. ¿Churigá 'la benírumalawé mué ramué? 'Liko 'ma mabúliru alé napu e'wélala mochile. ");
INSERT INTO tacNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","'Liko alué Esusi akele 'ma mabúlirigo alé u'tá re'obachi alué rió napu tabilé ma'chílime nílige, 'lige Esusi simile 'yamia alué rió 'lige 'ma rewisá alué rió, anele: ―¿Mueka 'la bijchigi 'ma nawáligo alué Onorúgamete julárigame 'pa rewagáchika napurigá rió niraga? ");
INSERT INTO tacNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","'Lige alué rioka anile: ―Mué Wa'lula, ne'chí ruyéwagó chieri ka alué napurigá ne 'la nirámempá aminami 'la bijchígimempá ne alué rió ra'ichálila. ");
INSERT INTO tacNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","'Lige Esúsika nejele: ―'Ma etiá mué. Alué napu mué 'yuga ra'icha, alué júkuru. Ne júkuru. ");
INSERT INTO tacNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","'Liko alué rioka chojkóbisiga ilíbale alé o'wemi niraga napu ilile Esusi, 'lige anele: ―Mué Wa'lula, neka 'la bijchigi alué ra'íchali napurigá mué aniá aní. Alué rioka asíriga 'la niraga etele alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","'Liko anile alué Esusi: ―Neka jena wijchimoba nawákuru gustisia olamia ralámuli. 'Lige abiena nawá ne 'yomia alué napu tabilé ma'chílime ju, 'lige alué tabilé ma'chílime newamia alué napu 'la ma'chílime ju. ");
INSERT INTO tacNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jaré bariseo napu Esusi si napuíka jale akele alanichi alué Esusi. 'Lige alué bariseo alieti akisá rukele: ―¿Tachiri ra'íchali júpeché alué? ¿Ramuéchigó tabilé ma'chílime niru? ");
INSERT INTO tacNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","'Liko Esúsika aminabi ra'íchale regá anigá: ―Tabilé ma'chílime nísaká 'emi, pecha 'emi chojkila nímelikó wa'lú resí nokágame ka 'emi. 'Émika asíriga 'la ma'chílime kóríguru. Yeka aniame júkuru 'émika 'we a'lá námame ko Onorúgame ra'ichálila, iligá 'émika tabilé sébali olame júkuru napurigá nulá Onorúgame, alekeri 'we chojkila ju 'emi. ");
INSERT INTO tacNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","'Liko Esusi anile: ―Bilé go'lé iligéturu rejtete tegoka newárigime, 'lige 'yérigame kéturu alué tegoli. 'Lige bilé rió ilime kéturu yochi tebuka. 'Lige bilé rió sébaturu alé go'lechi 'lige alué rió tabilé bajkigéturu alé yochi simíriga, pe re'pami amóbami 'máraturu, alué rioka pe bilé rió chigórigame júkuru. ");
INSERT INTO tacNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Alué bujkégame ka napu bo'á neseme ju 'mimi jami, alueka 'la alé yochi bajkimeli júkuru. ");
INSERT INTO tacNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","'Lige alué napu tebuka ilime ju alé yochi, alueka i'púmili júkuru alué bo'á neseme sebasa alé. 'Lige alué bo'aka asíriga 'la gepume júkuru alué bo'elo ra'ichálila. 'Lige alueka asíriga 'la rewagá bayeme júkuru a'pílipi alué bo'á bo'né bujkula, 'lige alué bo'aka yati buyásime júkuru. ");
INSERT INTO tacNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Napu'lige 'ma suwábaga buyasa alué bo'né bujkula, 'liko alué bo'éloka bajchá ename júkuru 'lige alué bo'aka guwana e'yéname júkuru alué bo'elo najátiga, napugiti 'wéchigo 'la machime kame aleké aníchinio ne'oa. ");
INSERT INTO tacNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tabilé siné najátamala alué bo'á bilé ralámuli tabilé machime nísaká alué bo'á alué bo'elo. ");
INSERT INTO tacNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Esúsika ye ra'íchali ra'íchame nile nobi ralámulika tabiléchigo námame nílekó alieti ruyame ko ye ra'íchali. ");
INSERT INTO tacNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Alekeri Esúsika uchéchigo bilé ra'íchali ruyele. Regá anele: ―Neka 'la bijchiá aní. Neka napurigá bilé yochi napu bo'á simárame ju, pe alarigá ju ne. Yeka aniame júkuru ralámuli napu ekí 'la moinánilime ju rewagachi, asíriga 'la e'wámili júkuru napu ne nulá. ");
INSERT INTO tacNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Suwábaga rió napu ekí sébale alé go'lechi bajchá ta'chó sébachi ne pe napurigá chigórigame nile, pe alarigá nile alué ralámuli. 'Lige alué bo'aka tabilé e'wame ju alué ralámuli nulachi. Pe a'chigóriga ju alué ne oyérame 'yuga. Alueka tabilé e'wame ju uché jaré ralámuli nulachi, pe ne'chika 'la e'wime ju. ");
INSERT INTO tacNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Napu'lige alué bo'á 'ma mo'isá alé pachami go'lechi 'liko alué bo'á 'ma tabilé che ikimeli júkuru. Napu'lige buyásisa alué bujkégame 'yuga abiena tabilé che ikimeli ju. Pe a'chigóriga ju ralámuli alué ne'chí oyérame. ");
INSERT INTO tacNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","› Bilé rió chigórigame ka pe chigomia nawame ju alé go'lechi, pe me'ligá suwábimia suwábaga ajágame. Neka pecha ala'símia nawákó. Neka ralámuli gu'írimia nawákuru napurigá abé 'la ganíliga ejperélamala, napurigá 'we a'lá sébali ralámuli nímala. ");
INSERT INTO tacNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Neka pe napurigá bilé rió bo'elo ju napu 'we a'lá nesérame ju bo'né bujkula bo'á. Bilé rió bujkégame bo'á 'we a'lá neseme ju bujkula, alueka tabilé chéláme ju rekó mukié nemika napu'lige ajágame jami oyame o ralámuli chigórigame chigónilichi alué bo'á alué rió bujkula. ");
INSERT INTO tacNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Bilé rió pe iligá enomí meka neseme ajágame, alueka tabilé alarigá ju napurigá bukégame rió, napu'lige etea bilé olí (lobo) 'naka enágichi pe a'reme ju bo'á. Pe bo'nepi na'temame ju, alekeri 'másame ju. Tabilé chéláme ju 'lige tabilé na'temame ju alué rió pecha bo'né bujkula kame alué ajágame napu neseka eyena. 'Lige alué olí bo'á me'lísachi 'lige uché jaré bo'aka 'ma suwábaga ra'lá mo'ibámili júkuru majaga. ");
INSERT INTO tacNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Alué rioka pe 'másame ju napugiti alué rioka péchigo nóchame kame, tabilé chéláme ju rekó alué ajágame o'lite chigórige pecha bo'né bujkula kame. Pe enomí meka nóchame kame. ");
INSERT INTO tacNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","› Neka asíriga 'la repume ju alué ne'chí oyérame ralámuli. Neka asíriga 'la machíguru alué ne'chí oyérame ko, 'lige alué ne'chí oyérameka asíriga 'la machíguru ne'chí, ");
INSERT INTO tacNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","napurigá ne O'nola 'we a'lá machí ne'chí, 'lige néchigó 'we a'lá machí ne bo'né O'nola. Neka mukumeli júkuru alué ne'chí oyérame gu'íriga, a'lígeko 'ma listo ajtí ne mukumea. ");
INSERT INTO tacNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Uchéchigo jaré ralámuli mochí, alué napu tabilé ralámuli jurío ju. Aluéchigó abiena ne'chí oyéramili ju, alueka gepúmili júkuru napurigá aní ne, 'lige abiena ne'chí oyérame gainámala a'chigóriga napurigá alué ralámuli jurío. Neka Wa'lula nímili júkuru suwábaga ralámuli nuleme, napurigá bilé bo'á neseme. ");
INSERT INTO tacNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","› Neka 'ma listo ajtíkuru mukumea 'lige uchéchigo siné naremia alawá napurigá uchéchigo ajagá asimémpá ne. Alekeri ne O'nola Onorúgame 'we galé ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ta'wesi me'limela ne'chí, ne tabilé nejísaká lisensia napurigá ne'chí me'limela. Neka 'la lisensia níkuru, neka mukumeli júkuru napu'lige ne bo'né mukunali, 'lige abiena 'la lisensia nígame ju ne napurigá ku ajánamala ne. Alué ne O'nola Onorúgame nulá ye 'nátili. ");
INSERT INTO tacNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Napu'lige alué ralámuli jurío akisá ye ra'íchali, ta'mé 'la ganíliga ejtebile. ");
INSERT INTO tacNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Jaré alué ralámuli jurío regá anile: ―Alueka bilé remónisi alawala ajchágame ju pachágana, pe lo'í ju. ¿Chonigá gepúlibeché? ");
INSERT INTO tacNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","'Lige jaré anile: ―Bilé rió u'tabela remónisi alawala ajchágame nísaká pachágana pecha aliena 'la semátiri ra'ichámilikó napurigá ra'icha ye rió. Bilé u'tabela remónisika pecha gainámalagó bilé ralámuli tabilé ma'chílime sa'wá. ");
INSERT INTO tacNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Romó nile a'lige. Alé we'ká riógichi Rusaleni anilichi wa'lú piesta nerule, alué piesta nélálime aliéniko gatélirigo alué wa'lú re'obá, nabí bamí piesta newame nile a'lige rawé. ");
INSERT INTO tacNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","'Lige Esúsika alé wa'lú re'obachi ra'pichí eyénale napu bilé bortali ilile napu Salomoni anilime nile alué bortali. ");
INSERT INTO tacNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","'Liko we'ká ralámuli jurío napuíle noligá alé napu ilile Esusi rukéniliga uché rajpé. 'Lige rukele: ―¿Chiéniko ruimé olá mué chieri ko mué bo'né? 'La bijchiá ruipóguru, ¿mué ju Kristo napu buinámala ralámuli chátiri bowechi? ");
INSERT INTO tacNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","'Lige Esúsika nejele: ―'Ma ruwí ne, tabiléchigo bijchíginiligó 'emi. Ne O'nola Onorúgame 'ya ne'chí bilé nóchali napurigá 'we a'lá semátiri tábiri nochámala ne bo'né 'nátaga napu ta'wesi rió newame ju. 'Emi 'ma etiáturu ne alieri nóchachi, alekeri 'la machiati kárékuru chieri ko ne. ");
INSERT INTO tacNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nobi 'émika tabilé bijchígigo napu ne ruwí, pecha ne'chí oyérame kame. 'Émika napurigá bo'á tabilé ne bujkula, alarigá ju 'emi. ");
INSERT INTO tacNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Alué bo'á 'la ne bujkúlaka, alueka asíriga 'la machime ju ne ra'ichálila, alekeri 'la najátame ju ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Neka alawá 'yáguru alué ne'chí oyérame napurigá uchéchigo siné ku ajánamala napu'lige suwisá, 'lige alué ne'chí oyérame ka pecha 'wesi nejpósimalagó. ");
INSERT INTO tacNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Alué ne'chí oyérame ne O'nola nejíkuru. Alueka asíriga wa'lú júkuru suwábaga me'tigá, napu ekí alué nílaka pecha 'wesi umabámalawé bujea, napugiti bo'né neseme kame. ");
INSERT INTO tacNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ne 'lige ne O'nola si pe bi'lepi 'nátili 'nátame niru. ");
INSERT INTO tacNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","'Liko alué ralámuli bariseo uchéchigo siné bajsibúnilile alué Esusi napurigá abé i'bé. ");
INSERT INTO tacNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","'Lige Esúsika anele: ―Neka asíriga we'ká semátiri nóchali nóchaturu napurigá 'emi etémala, O'nó Onorúgame a'walílate newáturu ne alué semátiri nóchali. ¿Tachiri nóchame korigá bajsibúwaché ne? ");
INSERT INTO tacNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","'Lige alué ralámuli juríoka regá nejele: ―Tabilé alekeri gite bajsibuwa mué 'we semátiri tábiri newigáriká. Bajsibuwa mué napugiti pecha nirame kame mué alué Onorúgame. Mueka pe apiépiri rió ju, pe alarigá júkuru, pe iligá napurigá Onorúgame neraga ra'icha mué, peka Onorúgame ke, pe iligá rió ke. ");
INSERT INTO tacNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","'Lige Esúsika regá anile: ―Alué 'emi nila ra'íchalika regá aní, alué napu Onorúgame anílige: «'Émika napurigá Onorúgame júkuru.» ");
INSERT INTO tacNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","'We 'la machiáguru alué napurigá anile Onorúgame 'we 'ya ('lige napu anile Onorúgame 'ya abiena sirbe ju jipe). Onorúgame anele alué ralámuli «napurigá Onorúgame ju 'emi», alué ralámuli napu ruwime nile napu anele Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","'Lige alarigá nisa, 'lige ¿chonigá gastigáriniliché ne'chí Onorúgame Inolá korichi ne bo'né? Onorúgameka ne'chí wanápale 'lige alekeri júlale ne'chí jékana wijchimoba. ¿Chonigá laníché 'émika ne tabilé nirame ko Onorúgame? ");
INSERT INTO tacNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ne tabilé sébali olásaká napu najkí ne O'nola, 'liko tabilé bijchígilime júkuru ne ra'ichálila. ");
INSERT INTO tacNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Tabilé bijchígiliká napu ne aní, abirigáchigo 'la bijchígilime júkó napu ne sébali olá napu Onorúgame najkí. Siné kachi 'la e'wame nísaká ne napu nulá alué Onorúgame, 'liko 'emi níriga 'la bijchígilime júkuru ne wa'lú a'walí nígame ko napu Onorúgame 'yale ne'chí. Aminami neka 'we a'lá 'nátaga eyéname ju Onorúgame na'tálila. ");
INSERT INTO tacNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","'Lige uchéchigo siné cha'pinálile, pe iligá tabilé cha'píliru Esusi. ");
INSERT INTO tacNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","'Liko alué Esusi simile alé bakochi na'lebo 'nálige Jorani anilichi 'omi niraga napu rayénali ma'chíname ju, 'lige alé sébale Esusi (napu Betánea anilichi ju). Alé ju bilena napu 'ya asale Juani rewará ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","We'ká ralámuli simíbale alemi e'nemia Esusi, 'lige anile a'boi ra'íchaga: ―Juánika tajsiné newáturu 'we semátiri nóchali napurigá Esusi, tabilé siné sa'wale ralámuli nayúkame. Suwábaga napu ra'íchale Juani alué Esusi olagá, 'we a'lá bijchiá nílekuru. ");
INSERT INTO tacNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","We'ká ralámuli napu ekí alé napuíle 'we bijchígale napu anile Esusi alé, aminami asíriga 'la e'wele napu anile. ");
INSERT INTO tacNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Bilé rió asale Lasro anilime, 'we nayua, 'lige alué rió Betania anilichi pe'kabi riógichi ejiro Jurea bejtégame nile. Alué umugí Lasro go'chila María anilime nile bilé, 'lige Marta anilime nile uché bilé, abiena alé ejperégame nile. ");
INSERT INTO tacNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ye María 'símili nile alué napu botéachi manígime a'kinana ro'émili nile alué Esusi ronola, ba'wí 'we semá júkame, 'lige yati wakémili nile bo'né gupálate alué bo'né María. ");
INSERT INTO tacNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","'Lige alué oká umugí júlale jaré rió Esusi ruyéniliga: ―Mué Wa'lula, alemi jula ramué mué ruyénaliga 'we nayua bo'igó alué rió napu mué gompaniérola ju. ");
INSERT INTO tacNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Napu'lige alué Esusi akisá alanichi ralámuli, anile: ―Mukumeli júkuru nobi tabiléchigo mukugá rejpímili júkó. Alué rioka 'we a'wágame nayulí chujkélekuru pe napurigá machiboa chiena 'la semá 'sime ko Onorúgame, 'lige abiena chiena 'la semá 'sime ko Onorúgame Inolá. ");
INSERT INTO tacNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Esusi 'we galegá eteme nile alué bakiá rijimá, ");
INSERT INTO tacNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","nobi napu'lige Esusi akisá ra'íchali 'we nayua bo'igó Lasro, tabilé yati simile e'nemia, uchéchigo oká rawé rejpile alé napu asálige. ");
INSERT INTO tacNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","'Liko anele alué oyérame: ―Nabá uchéchigo siné alé 'mi Jurea anilichi ejiro. ");
INSERT INTO tacNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","'Liko alué oyérame anele: ―Mué Benírame, pe kulírikáchi alué ralámuli jurío alé mochígame mué me'linálituru bajsibuga. ¿Chonigá uchéchigo ku alé siminali che mué? ");
INSERT INTO tacNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","'Liko Esúsika nejele: ―Makué oká 'ora ma'chigá ilime ju ra'ósiga. 'La rawé e'yéniliká tabilé toroka e'yéniwa 'wéchigo 'la ma'chigá ilime kame raweka. ");
INSERT INTO tacNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Rukó e'yéniliká asíriga toroka e'yéniwa napugiti pecha ma'chigá ilime kame rukóká. ");
INSERT INTO tacNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","'Lige Esusi uchéchigo rajpé anile: ―Alué Lasro ne gompaniérola ka, 'ma gojchílekuru, nobi neka 'ma ajchámalagó. ");
INSERT INTO tacNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","'Liko alué oyérameka regá anile: ―Mué Wa'lula, ¿pe gojchigá bo'isáká, a'liko 'la sa'wimela? ");
INSERT INTO tacNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Bo'né Esúsika anigá anile: «'Ma mukugá bo'í.» 'Lige alué oyérameka 'la bijchígale pe gojchigá bo'igó alué Lasro. Tabilé námale ralámuli alarigá ra'íchachi Esusi. ");
INSERT INTO tacNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","'Liko 'we a'lá ma'chígime ruyele: ―Lásroka 'ma mukúlekuru. ");
INSERT INTO tacNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ra'sá la ne tabilé asisá alé napu'lige Lasro mukuchi. Alarigá 'we a'lá ju napurigá bijchígimala Onorúgame a'walí 'yame ko ne'chí. Nabá e'newa. ");
INSERT INTO tacNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","'Liko alué Romasi napu Kuate anilime nílige, anile uché jaré oyérame 'yuga: ―Ramué abiena simasa Esusi 'yuga, alué ralámuli jurío me'limela ramué. Chu'símalawé rekó suwiyae ramué, Esusi 'yuga simawa. ");
INSERT INTO tacNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","'Liko napu'lige sebasa alé Betania anilichi, alué Lásroka 'ma naó rawé bo'ile mukugá alé resochí ewachi. ");
INSERT INTO tacNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Alé Betania pe a'bé nile Rusaleni anilichi pe bakiá kilómetro niraga. ");
INSERT INTO tacNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","We'ká ralámuli jurío e'yénale alemi e'néniga alué María 'lige alué Marta napurigá tabilé chélámala alué bonila mukusá. ");
INSERT INTO tacNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Napu'lige alué Marta akisá aleka enegáráo Esusi, yati ma'chínale najtepamia. Alué Maríaka pe galírale rejpile. ");
INSERT INTO tacNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","'Liko alué Marta anele alué Esusi: ―Mué Wa'lula, mué jena asisáká, pecha mukumeli ke ko ne bonila. ");
INSERT INTO tacNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nobi neka 'láchigo machígó Onorúgame suwábaga nejimio napu mué tani. ");
INSERT INTO tacNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","'Lige Esúsika anele: ―Mué bonílaka ku ajánamala. ");
INSERT INTO tacNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","'Liko alué Marta anile: ―Neka 'la machí ku ajánimio napu'lige 'ma guwichí kachi napu'lige Onorúgame nawasa ralámuli gustisia olamia. ");
INSERT INTO tacNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","'Lige Esusi anele: ―Ne júkuru ralámuli ku 'yáame alawá napu'lige suwisá napurigá ku ajagá mochímala, 'lige aminami ne ju ralámuli a'walí 'yame napurigá 'we ganíliga ejperélamala. Tabilé chéré rekó bilé rió mukugé, pe 'la bijchígame nísaká Wa'lula ko ne, 'liko 'la 'yámala ne alawá napu'lige mukusá. ");
INSERT INTO tacNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Suwábaga napu ekí nígame ju ne alawala 'lige aminami napu ekí 'la bijchígime ju ne ra'ichálila, rekó mukugé, bo'né alawálaka tabiléchigo mukuméligó. ¿'La bijchigi mué napu ne aní? ");
INSERT INTO tacNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","'Lige Mártaka anele: ―Juli mué wa'lula, neka 'we a'lá bijchigi mué ko Kristo anilime Onorúgame Inolá, alué napu nawámili nílige jena wijchimoba. ");
INSERT INTO tacNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Abé we'liko napu'lige 'ma ra'ichasa Marta, 'ma simile María bayemia. 'Lige i'kilí ra'íchale tabilé akériga uché jaré ralámuli. Regá anele: ―Jena ajtí alué benírame, 'lige mué bayea ajtíkuru. ");
INSERT INTO tacNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Napu'lige akisá alué ra'íchali yati niraga ilísale 'lige yati simile alé napu ajtile alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","'Lige Esusi tabilé 'cho sébalige alé pe'kabi riógichi, alé 'mi ajtile abajá napu najtépilige alué Marta. ");
INSERT INTO tacNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","'Lige alué ralámuli jurío napu María 'yuga mochile alé María galílachi, napu'lige etesa María ilísachi 'lige simichi ma'chimi, yati simíbalechigó alué ralámuli jurío María najátasia. Alué ralámuli juríoka pe 'mimi simea mayele resochí nalamia napu bo'ile Lasro, alarigá mayele. ");
INSERT INTO tacNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","'Liko alué María napu'lige sebasa alé Esusi ajtígichi, yati niraga chojkóbisiga ilíbale alé a'bemi Esusi ronólachi anigá nalale: ―Mué Wa'lula, mué jena asisáká pecha mukumeli ke ko ne bonila. ");
INSERT INTO tacNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Napu'lige Esusi etesa alué María nalachi, 'lige etélechigó alué ralámuli jurío abiena nalásiga e'yénigo, 'lige asíriga sewele Esusi, ");
INSERT INTO tacNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","'lige anile: ―¿Kochiena rekaru ko alué mukúgame? 'Lige anéleru: ―Mué Wa'lula, aka simáwa'é e'newa. ");
INSERT INTO tacNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","'Lige Esúsika 'ma nalálechigó. ");
INSERT INTO tacNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Alekeri anile alué ralámuli jurío: ―Alueka asíriga 'la gompaniérola níligekuru alué Lasro. ");
INSERT INTO tacNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nobi jaréchigo ralámuli jurío se'winá anile ko, regá anile: ―Alueka bilé tabilé ma'chílime 'la ku sa'wáturu. ¿Chonigá tabilé 'yóleché alué Lasro napurigá tabilé mukumela? ");
INSERT INTO tacNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","'Lige Esusi alé resochí sébale alé ewachi napu bo'ílige alué Lasro, 'lige uchéchigo siné 'we sewele, asíriga we'ká 'nátale. 'Lige bilé wa'lú rejté ajcháriga ajtile alé resochí yochi. ");
INSERT INTO tacNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","'Lige anile alué Esusi: ―Se'wí ajchawa alué rejté. 'Liko anile alué Marta alué mukúgame go'chila: ―Mué Wa'lula, asíriga cha jubáleké alé pachami, 'máchigo naó rawé kame mukusá. ");
INSERT INTO tacNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","'Lige Esúsika anele: ―Ne 'ma anéturu mué 'la bijchígasaká napurigá aní ne, 'liko 'la machimela mué chiena a'wágame ko Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","'Liko 'ma se'wí ajchale alué wa'lú rejté. 'Lige alué Esusi 'pa rewagachi e'negá iligá anile: ―Mué O'nó, wa'lú cheliera 'ya ne mué, mué 'we a'lá semáriga gepúmpá ne ra'ichálila. ");
INSERT INTO tacNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Neka 'la machí mué nabí 'la akeo ne'chí. Pe yecho aní ne napurigá ye ralámuli 'la machimela ye 'nátili, napurigá 'la bijchígimempá mué 'síligo ne'chí jula. ");
INSERT INTO tacNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","'Lige abé i'libeko ye ra'ichasa, e'wele ra'íchale: ―¡Mué Lasro, yati ma'china! ");
INSERT INTO tacNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","'Lige 'ma ma'chínale alué napu mukúlige. 'Lige bochígimi o'póligime nile asíriga we'lí chinite. 'Lige mo'chí bilé banito o'póligime nile. 'Lige Esusi anele alué ralámuli: ―'Ma bujewa ye chiní 'lige banito abiena bujewa, 'lige a'rewa simichi. ");
INSERT INTO tacNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","'Lige alieti etega we'ká ralámuli jurío napu napuílige María bejtélachi 'la bijchígale Onorúgame Inolá ko alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nobi jaréchigo pe iligá bariseo 'yuga ra'ichamia simíbale ko. 'Lige ruyele napu 'sile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","'Lige jaré bariseo 'lige alué e'wélala balé júlale napurigá napabúniliga alué uché jaré e'wélala, 'lige anile a'boi ra'íchaga: ―¿Chonokiboa? Ye rioka asíriga i'kirú 'siá simíguru tabilé siné etérume. ");
INSERT INTO tacNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","A'résaká ye rió napurigá aminabi alieri 'símala 'liko asíriga we'ká ralámuli oyéramala ye rió, a'lige alué sontalo romano napu jena nulame ju 'ma tabilé elámala napurigá nocha mochímala ramué jena wa'lú re'obachi 'lige aminami bochígimi jena Israeli. ");
INSERT INTO tacNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","'Lige alué bilé Kaipasi anilime nile, alué napu wa'lula balé nile bi'neli neyúriga nulame 'ya a'lige bamí, alueka anile: ―'Émika tabilé machime ju. ");
INSERT INTO tacNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Abé 'la ju bi'lepi rió mukusá, uché jaré tabilé suwisá 'la ju. ¿Tabilé machí 'emi ye 'nátili? ");
INSERT INTO tacNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Alueka tabilé bo'né 'nátalite anile ye ra'íchali. Alué nile wa'lula balé, alekeri Onorúgame 'yale 'nátili napurigá 'la gainámala ruiyá a'kinana mukumeo Esusi alué ralámuli jurío gu'íriga. ");
INSERT INTO tacNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","'Lige abiena alué Esusi mukugá wa'lú nejkúramili ju uché jaré ralámuli 'yuga. Asíriga we'ká ralámuli gu'írimili ju Onorúgame 'kúchila napu ekí ejperégame ju jena wijchimoba. Nejkúramili ju napurigá 'la bi'lepi 'nátame nímala Onorúgame na'tálilacho. ");
INSERT INTO tacNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","'Liko a'lige rawé alué jurío e'wélala 'we a'lá 'nátale alarigá me'liati ko alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Alekeri alué Esusi 'ma tabilé 'me eyénale alé we'ká ralámuli jurío mochígichi. Uché bilena we'ká riógichi simile alé a'bemi napu tabilé we'ká mochile alué Esusi me'linálime, alé pe'kabi riógachika Epraíni anilichi nile alé a'bé wa'lú gawí wakígachi napu tabilé 'me u'kume nile. Alé asale Esusi alué ralámuli oyérame 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pe u'kabi rawé rokáréle napurigá sebámala ralámuli jurío piéstala alué Páskua anilime piesta. Asíriga we'ká ralámuli simíbale alé 'pa Rusaleni anilichi ba'wichí mo'imea ta'chó sébachi alué piesta, napurigá 'la gainawa bajkiá alé wa'lú re'obachi. ");
INSERT INTO tacNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","'Lige ralámulika 'we 'yaga e'yénale Esusi. Napu'lige ra'icha jale alé wa'lú re'obachi ra'pichí, regá rukigá járale a'bopi: ―¿'Émika choniágó? ¿Pala nawamio mayelia 'émika Esusi napu'lige nerúgichi alué piesta? ");
INSERT INTO tacNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Alué bariseo 'lige alué e'wélala balé galírale bajchamio olale Esusi, alekeri júlale jaré ralámuli rukéniliga 'la machisáká 'la rumémpá koche ajtigó Esusi, 'lige ruyésiga pe cha'pináliga. ");
INSERT INTO tacNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ujsani rawé kachi bajchabé ta'chó sébachi alué piesta, Esusi uchéchigo simile alé Betania napu bejtégame nile alué Lasro, alué napu Esusi ku ajánalige napu'lige mukúlige alué Lasro. ");
INSERT INTO tacNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","'Lige go'ame newale alé Lasro bejtélachi napurigá Esusi go'mela, 'lige uchéchigo jaré bayele. Alué Marta nejkúrale go'ame 'yaa ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","'Lige María ba'wí a'pale nasípasi litro neraga 'we semá júkame ba'wí. Alué ba'wí 'we najteme nile. 'Lige Esusi ronólachi ro'ele, 'lige bo'né gupálate wakele. Bochígimi pachá galírale 'we semá juka ilíbale. ");
INSERT INTO tacNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","'Lige napu'lige alué go'ame go'yá mochígichi ralámuli, alé asale alué Jurasi Iskariote anilime, Simoni inolá. Alué rioka bilé nile alué makué oká rió napu Esusi oyérame nile. 'Lige alué Jurasi 'símili nile alué Esusi nejía napurigá cha olawa alué Esusi saílate. Anile: ");
INSERT INTO tacNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Chonigá tabilé ralinérupeché ye ba'wí 'we semá júkame napurigá alué enomí tabilé nígame ralámuli kógiwa? Asíriga najteme júkuru alué ba'wí semá júkame, napu ekí meme ju bilé rió bilé bamí nóchiga. ");
INSERT INTO tacNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Jurásika pecha 'la ralámuli tabilé nígame na'temaka aníleko, alueka pe lanílekuru napugiti pe chigórigame níligame 'sika aniá, pe bo'né cha'pináliga anile alué enomí. Alueka nile enomí ajchala repume napu ajchame nile alué makué oká rió Esusi oyérame, 'lige chigome nile alué Jurasi alué enomí. ");
INSERT INTO tacNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","'Liko Esúsika anele: ―A'réwagó. Ye mukika 'ma bajchabé niraga ro'éguru ne'chí alué ba'wí 'we semá júkame napu ro'émili ju ne'chí napu'lige ne mukú. ");
INSERT INTO tacNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Alué ralámuli tabilé nígame senibí 'emi 'yuga mochímala, nobi neka tabiléchigo nabí 'yuga asiméligó 'emi. ");
INSERT INTO tacNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","We'ká jurío akele Esusi alemi ajtigáráo, 'lige simíbale e'nemia. 'Lige abiena e'nema olale alué napu Lasro anilime nile, alué napu ku ajánilige Esusi. ");
INSERT INTO tacNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Alué e'wélala balé 'we a'lá ra'íchale a'bopi, abiena me'liméoríle Lasro. ");
INSERT INTO tacNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","We'ká alué jurío asíriga 'la nirale etesa Esusi 'yochi alué Lasro, 'lige alué juríoka 'máchigo 'la oyera mochíligame alué Esusi. Alekeri alué e'wélala balé 'ma me'linálile alué Lasro 'lige Esúsitiri. ");
INSERT INTO tacNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","'Lige melénala rawé Esusi 'mimi Rusaleni anilichi neraga enale. We'ká ralámuli mochile alé Rusaleni napugiti piesta nerúligime. Napu'lige akisá alué ralámuli enegáráo Esusi, ");
INSERT INTO tacNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","rajkú sawala o'ká simíbale najtepamia, 'lige a'wágame ra'íchaga regá anile: ―¡Hosana (salva)! ¡'We a'lá ju Onorúgame! ¡'We a'lá ju alué Onorúgamete julárigame! ¡'We a'lá júkuru alué Wa'lula alué ralámuli Israeli ejperégame nuleme! ");
INSERT INTO tacNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","'Lige Esúsika bilé bulito majalégame asagá enale. Alarigá nile napurigá anílige Onorúgame ra'ichálila 'we 'ya. Regá anile: ");
INSERT INTO tacNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Tase majawa 'emi ralámuli jena Rusaleni mochígame. Aleka ená wa'lula mué nuleme bulito ranala asagá. ");
INSERT INTO tacNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Alué Esusi oyérameka tabilé námale tachiri ruyame ko alué ra'íchali Onorúgame ra'ichálila churigá ko Esusi, 'lige a'kinánaka 'la námale. Napu'lige Esusi uchéchigo siné naresa alawá napu'lige mukusá, 'liko alué oyérame 'la námale ye ra'íchali 'la ruwíligo churigá 'simio alué Esusi. 'La nélále bijchiá a'chigóriga níligo napurigá anílige Onorúgame ra'ichálila 'we 'ya. ");
INSERT INTO tacNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","We'ká ralámuli sébale alé napu enale Esusi bulito asagá napugiti ralámuli etéligame napu'lige Esusi ku ajánilige Lasro. Alué napu etele simíbale ra'ichasia, 'lige we'ká ralámuli akele. ");
INSERT INTO tacNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Alekeri we'ká jsile alé Esusi e'nemia. ");
INSERT INTO tacNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","'Lige alekeri alué bariseo anile a'boi ra'íchiga pe Esusi ayóniga, regá anile: ―¡Alué rioka 'ma neyúraguru! ¡Suwábaga ralámuli 'ma alué rió oyéraguru! ");
INSERT INTO tacNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","'Lige jaré ralámuli sébale alé Rusaleni piesta nerúgichi Onorúgame niramia. Griego ra'íchame nile alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","'Lige a'bé jábale Belipe anilime rió ilígichi. Alué Belípeka alé Betsáira anilichi bejtégame nile ejiro Galilea anilichi. Alueka Esusi oyérame nile. 'Lige alué jaré rió regá anele: ―Mué rió, ramueka Esusi si ra'ichamia jsirú. ");
INSERT INTO tacNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","'Lige simile Belipe 'lige Antresi ruyele, 'lige okaka simíbale Esusi ruyemia. ");
INSERT INTO tacNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","'Lige Esúsika anele: ―Ne ju alué rió napu nawágame ju 'pa rewagáchika napurigá rió neraga. Ya 'ma sébaguru raweli napurigá ralámuli ne'chí etémala churigá ko ne. Asíriga 'la niraga etémala Onorúgame ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Jena ruimé ne bilé ra'íchali. 'We a'lá bijchiá ju napu ruwí ye ra'íchali. Bilé ri'ligó tabilé we'echi echiruga asisáká, pecha ya'wime júkó. 'Lige tabilé nerúlamala napurigá 'wiwa. Napu'lige 'la we'ete o'póliga echiruga asisáká, 'liko 'we a'lá ya'wimela. Neka napurigá ri'ligó rakala alarigá ju ne. ");
INSERT INTO tacNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ralámuli jena wijchimoba mochígame napu 'we nígame ju asíriga ganíliga ejperégame ju aminacho 'nata tabiri tábiri korua nobi a'kinana suwábaga tábiri tabilé niga mochíbamala. Alué ralámuli napu tabilé 'nátame ju tabiri tábiri niga asinálime, alueka abisibi 'we a'lá ganíliga bejtégame ju jena wijchimoba 'lige abiena 'pa rewagachi. ");
INSERT INTO tacNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Bilé 'la nejkúrinilisa nóchame niraga ne 'yuga, alueka ne'chí najátimili júkuru. Napu ne ajtí, alé simámili júkuru alué nóchamechigó. 'Lige ne O'nólaka asíriga 'la niraga etémala alué ne'chí gu'írime. ");
INSERT INTO tacNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","'Lige Esusi aminabi anile: ―Jípeko asíriga we'ká 'nata ne. We'ká 'nata ajtí ne alakimeo ne. ¿Chonimela ne? ¿Tánamala ne O'nola Onorúgame napurigá tabilé che ikimela ne napu'lige resí ikimeli ju ne pe 'we? Tabilé tánamala ne alieti. Neka jena wijchimoba nawákuru resí ikimea. ");
INSERT INTO tacNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","'Liko Esusi anele Onorúgame: ―Mué O'nó, ralámuli etériwa chiena 'la semá 'sime ko mué. 'Liko Onorúgame 'pa rewigáchika, regá anile: ―Neka 'ma eteri ralámuli aliena 'la semá 'sime ko ne, 'lige uchéchigo siné etérimio olá ne. ");
INSERT INTO tacNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ralámuli alé jágame akele alé alué ra'íchali. Jaré bilé re'ome anióríle 'pa rewagachi. 'Lige jaré bilé santo ánjeli ra'icha orile. ");
INSERT INTO tacNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","'Liko anile alué Esusi: ―Onorúgameka pecha ne'chí gu'íriga anile ko e'wele ra'icha. Alueka e'wele ra'íchalekuru napurigá 'emi akimela. ");
INSERT INTO tacNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","'Ma pe'wé nawámili ko Onorúgame gustisia olámia. 'Ma pe'wé nawámala Onorúgame alué wa'lula Remónisi rekábamia, alué napu nulá ajtí jena wijchimoba. ");
INSERT INTO tacNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Re'pá bilé gulusichi ujchásiga ne, suwábaga ralámuli machimela chieri ko ne. ");
INSERT INTO tacNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Alarigá anile Esusi napurigá machimémpá ralámuli alarigá mukumeo. ");
INSERT INTO tacNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","'Lige ralámuli anile: ―Alué Onorúgame ra'ichálila 'ya nerúgame 'we a'lá ruwime ju alué rió napu ramué buinámili ju alé resítiri bowechi, alué rió 'la nabí bejtélimili ju. 'Lige ¿chonigá laní mué alué rewigáchika nawágame gulusichi chujkugá mukumeli ko? ¿Chieri júpaché 'lige alué rió 'pa rewigáchika nawágame? ");
INSERT INTO tacNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","'Lige Esúsika anile: ―Alué 'we a'lá nejkúramiliká napurigá 'we a'lá na'támala 'emi 'ma pe u'kabi rawé asimeli ju jena napurigá ra'ósali. 'La alué 'yuga na'tálime júkuru bijí jena ajtígachi alué, napurigá tabilé neyúramala alué chátiri 'nátili. Bilé rió chátiri 'nátiga oyame ka tabilé machime ju alemi enegó bo'né. Alueka napurigá bilé rió rukó oyame neraga ju, nobi bilé rió 'la e'wame ka ne ra'ichálila, alueka 'la rawé neraga eyéname ju. ");
INSERT INTO tacNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ne júkuru abé 'la 'nátili nejime. Bijí jena asagá, 'la bijchígilime júkuru ne ra'ichálila napurigá 'la Onorúgame 'kúchila niwa Onorúgame na'tálila 'nátame. Napu'lige 'ma guwárisa ra'icha, 'ma simile, 'ma chíbale, 'lige tabilé 'wesi ralámuli etele. ");
INSERT INTO tacNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Esúsika pe bo'né 'nátaga e'karúgame semati newale, nobi ralámulika tabilé bijchígili ko Onorúgamete julárigame níligo Esusi. ");
INSERT INTO tacNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Alarigá nímili nílekuru, asíriga 'ya osirúgime nílekuru alué osilí napu osálige alué Isaíasi anilime rió napu ruwime nile napu anele Onorúgame. Regá anime nile: Mué Wa'lula, ralámulika tabilé bijchigi ramué ra'ichálila. ¿Chieri ralámuli etiágó chiena a'wágame ka mué? ");
INSERT INTO tacNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Alué Isaíasi abiena osale chonigá tabilé bijchígia alué ralámuli. Anile: ");
INSERT INTO tacNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Onorúgame bo'né alarigá rekile 'nátili napurigá tabilé námamala, napurigá siego niraga mochímala, napurigá tabilé námamala alué 'we a'lá semátiri 'nátili napurigá tabilé Onorúgame oyérame nímala, 'lige napurigá neka tabilé buinámala resítiri bowechi. ");
INSERT INTO tacNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Alanile Isaíasika Onorúgame etériligime. 'Lige etele Esusi ta'chó nawachi, etele nawamia 'we semáriga nochamia jena wijchimoba. ");
INSERT INTO tacNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","We'ká ralámuli jurío bijchígale Esusi ra'ichálila. We'ká alué jurío e'wélala 'la bijchígale, pe iligá tabilé che anile napugiti 'wéchigo majá mochíligame alué bariseo. 'Nátale bariseo mabúnilia mayele alé u'tá re'obachi «sinagoga» anilichi mochígichi. ");
INSERT INTO tacNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Alué e'wélalaka najkile napurigá 'la niraga etémala ralámuli alué a'bopi, tabilé chélále rekó Onorúgame ta nirae. ");
INSERT INTO tacNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","'Liko a'wágame ra'íchale Esusi: ―Napu'lige bilé rió ne'chí oyérame, tabilé ne'chicho oyérame ju, abiena oyérame ju napu ne'chí júlale 'pa rewagáchika. ");
INSERT INTO tacNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Napu'lige bilé rió ne'chí etee abiena eté alué napu ne'chí júlale 'pa rewigáchika. ");
INSERT INTO tacNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Neka pe napurigá ra'ósali ju. Neka jena wijchimoba nawákuru ralámuli gu'írimia napurigá tabilé chonárale e'yénamala. ");
INSERT INTO tacNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ne ra'ichálila gepume ka 'lige tabilé e'wásaká alué ra'íchali, neka tabilé alué ju napu gustisia olámili ju alué ralámuli. Neka ralámuli buinamia nawákuru alé resítiri 'nátalichi. ");
INSERT INTO tacNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Bilé ralámuli tabilé oyérame ne'chí 'lige aminami tabilé e'wasa napu ne nulá, Onorúgame gastigárimili ju alué ralámuli. Onorúgameka ruyémala tabilé bijchígiligo alué ra'íchali napu ne ruyé. ");
INSERT INTO tacNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Neka pecha bo'né 'nátaga ra'íchakó. Alué ne O'nola Onorúgame napu ne'chí júlale, alué nuláturu tachiri rupoa 'lige churigá rupoa. ");
INSERT INTO tacNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Alué ra'íchalika napu ne ruyéleru Onorúgamete napurigá ra'ichámala ne, alué ra'íchalika ju napurigá ralámuli 'la nabí ejperélamala 'pa rewagachi. Alué napu ne ruwí pe a'chigóriga ju napurigá nulele Onorúgame ne'chí napurigá ra'ichámala ne ralámuli 'yuga. 'Lige bilé ralámuli tabilé bijchígisa ne ra'ichálila pe tabilé bijchígime kéré Onorúgame nila ra'íchali. ");
INSERT INTO tacNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","'Ma amulí sébachi alué piesta Páskua anilime 'lige rapakónala nile, Esúsika 'we a'lá machile 'ma sebio raweli napurigá 'ma simeo jena wijchimoba asagá 'ma tabilé jena bejtélimio, ya 'ma simeli nílekuru bo'né O'nola Onorúgame 'yuga. Esúsika asíriga nabí 'la galeme nile ralámuli jena wijchimoba mochígame, alué napu Onorúgame oyérame nile. Tabilé we'káwale alué ralámuli, nabí 'la galegá etele. ");
INSERT INTO tacNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Esusi 'lige alué Esusi oyérame go'yá mochile alí. Jurasi Iskariote anilime, Simoni inolá, abiena alé asálechigó. Riábloka 'ma chátiri 'nátili ajchele alé Jurasi sulálachi, 'nátili ajchele napurigá Esusi nejímala. ");
INSERT INTO tacNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Esusi 'we a'lá sébali machile Onorúgame nejíligo a'walí napurigá Wa'lula nímala Esusi. Abiena machílechigó bo'né Esusi Onorúgame 'síligo jula 'pákana rewagáchika, 'lige a'kinana rawé simeo ku 'pa napu Onorúgame ajtí. ");
INSERT INTO tacNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Alarigá 'nátaga alué Esusi o'weti ilísale go'yá ajtigé, 'lige o'pacha bujale we'lí amoba chujkúgame, 'lige bilé chinite bulale alé umichipo, ");
INSERT INTO tacNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","'lige ba'wí ro'ale bilena sikolichi. 'Lige alué makué oká Esusi oyérame ronola pagole alué ba'wite. 'Lige 'ma wakele alué chinite napu umichipo bulálige bo'né. ");
INSERT INTO tacNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Napu'lige pagoma olálige alué Simoni Pegro ronola, ye rió Simoni Pégroka regá rukele: ―Mué Wa'lula, ¿ne'chí ronola pagoma olá mué? ");
INSERT INTO tacNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","'Lige Esúsika nejele: ―Jípeko tabilé námaguru mué chonigá pagó ne 'emi ronola, nobi abé i'libékoka 'láchigo námamalagó mué. ");
INSERT INTO tacNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","'Lige Pégroka anele: ―Ne'chika pecha siné pagómalagó mué, mueka pecha pioni ka. 'Lige Esúsika anele: ―Ne tabilé pagósaká mué ronola, a'lígeko tabilé ne gompaniérola nímala mué. ");
INSERT INTO tacNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","'Lige anile alué Simoni Pegro: ―'Liko mué Wa'lula, 'la ju, pagókigó 'liko ne'chí ronola, sekala 'lige mo'ola abiénachigó. ");
INSERT INTO tacNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","'Lige Esúsika anile: ―Alué 'ma 'úbigame ka 'ma bi'ígame júkuru, pecha uchéchigo siné pagókime júkó, pe ronólacho pagókime júkuru napugiti ronoka cha a'kué chóligame gayéname kame. 'Emi suwábaga asíriga 'la bi'wígame júkuru, pe bi'lepi tabilé. ");
INSERT INTO tacNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Alué u'bárigame aniáká, pe anime ke anile Esusi 'ma bujéligo alué wa'lú resítiri gastigo. 'Lige abiena ruwile bilé rió tabilé bi'wígame karao, 'we machile cha 'simio alué rió. Pe Esusi resí olánilia ajtíligo alué rió. ");
INSERT INTO tacNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","'Lige Esusi napu'lige 'ma pagosa ronola, 'liko 'ma uché ku o'pachátale alué amoba chujkúgame o'pacha. 'Lige uchéchigo siné asíbale alé mésachi, 'lige rukele: ―¿'La námilia chonigá pagó ne 'emi ronola? Neka pagókuru mué ronola napurigá 'la námamala 'emi, churigá gu'íritika ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","'Émika benírame aneme júturu ne'chí 'lige aminami wa'lúlatiri, napugiti 'émika 'láchigo machigá aniame, neka aluéchigo kame napu 'emi aní. ");
INSERT INTO tacNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Neka benírame júkuru 'lige wa'lúlatiri. Ne 'emi ronola pagosa, 'émichigó abiena pagómili júkuru ronola a'nagupi nakúriga. ");
INSERT INTO tacNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Neka pagókuru mué ronola napurigá 'emi alarigá nokimela, napurigá tabilé riólame niwa asíriga 'la suwábaga gu'írilime júkuru. 'La a'chigóriga nochálime júkuru napurigá nocha ne. ");
INSERT INTO tacNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Neka 'we a'lá bijchiá ruwíguru. Bilé rió nóchame ka pecha abé najtékame júkó me'tigá bilé batroni. Napu'lige bilé rió julasa uchéchigo bilé rió tábiriti 'núliga, alué napu a'pame ka pecha abé wa'lula júkó me'tigá alué nulame. ");
INSERT INTO tacNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","'La námasaká 'emi ye ra'íchali 'lige aminami 'la sébali olásaká, alarigá nokisáká napurigá aní ye ra'íchali 'liko 'we ra'sálagá mochímala 'emi. ");
INSERT INTO tacNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","› Neka pecha suwábaga 'emi 'yágó ye rejcholi. Neka 'la machí alué napu ne cha'píligo napurigá ne'chí oyéramala. Aba alarigá ikimeli júkuru napurigá anílige Onorúgame ra'ichálila 'we 'ya. Regá anile: «Alué napu ne'chí si ajtile go'yá, alueka 'ma sairúgame gayénale jipe ne'chí 'yuga.» ");
INSERT INTO tacNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Neka ye ra'íchali ruwíguru ta'chó sébachi raweli. Napu'lige sebasa ye raweli 'liko 'emi abéchigo 'la námamala ne ko alué napu senibí bejtégame ju. ");
INSERT INTO tacNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Neka 'la bijchiá aníguru. Napu'lige bilé rió oyérasa napu ne jula, pe a'chigóriga ju napurigá oyérilia ne'chí, 'lige bilé rió ne'chí oyérasaká, pe a'chigóriga ju napurigá Onorúgame oyérilia, alué napu ne'chí júlale. ");
INSERT INTO tacNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","'Lige napu'lige 'ma ra'ichasa ye ra'íchali, asíriga seweka asíbale Esusi. 'Lige 'la ma'chígime anele: ―Neka 'we a'lá bijchiá ruwíguru, 'emi makué oká ne'chí oyérame bilé júkuru ne'chí saíla niraga gainámili. ");
INSERT INTO tacNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","'Lige alué Esusi oyérameka a'nagupi e'nénale a'bopi, tabilé machile alué olagá anió Esusi. ");
INSERT INTO tacNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Bilé alué makué oká rió Esusi oyérame napu Juani anilime nile napu Esusi 'we galélige, alueka Esusi si go'yá asale. ");
INSERT INTO tacNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simoni Pegro sekate ra'íchale Juani 'lige anele: ―Ruké chieri ka alué rió napu Esusi saíla gainamio. ");
INSERT INTO tacNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","'Liko alué Juani abéchigo a'bé asíbale napu asálige alué Esusi, 'lige rukele: ―Mué Wa'lula, ¿chieri júkó? ");
INSERT INTO tacNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","'Lige Esúsika anile: ―Pe'tá baní sa'nabáchamala ne, 'lige alué napu kógira ne, alué rió ju napu ne saíla gainámala. 'Liko alarigá 'sile, baní sa'nabáchale, 'lige alué Jurasi 'yale, alué Simoni Iskariote inolá. ");
INSERT INTO tacNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Abiéniko neraga Jurasi baní go'sá, Remónisi alawala yati neraga pachágana Jurásichi bajkile. 'Liko Esusi anele alué Jurasi: ―Alué napu mué 'símili ju, 'we yati oláwagó. ");
INSERT INTO tacNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Alué aminá jareka napu ekí go'yá mochílige tabilé 'wesi námale alanime ko alué ra'íchali Esusi ra'ichálila. ");
INSERT INTO tacNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Alué Jurasi nile repume alué makué oká Esusi oyérame enomila. Alekeri jaré mayele júliga anió Esusi alué rió napurigá ralimela bilé tábiri alé piéstachi o'towame, o napurigá go'ame 'yawa ralámuli tabilé nígame. ");
INSERT INTO tacNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Napu'lige alué Jurasi go'sá alué baní, yati simile. 'Ma rukó nile. ");
INSERT INTO tacNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Abé we'liko napu'lige Jurasi 'ma simisá, Esusi anile: ―Ne júkuru alué rió napu nawágame ju 'pa rewagáchika napurigá rió neraga, jipe asíriga 'la etémala 'emi aliena 'la semá 'sime ko ne. Alué nóchali napu ne nocha, ralámulika etémala 'we a'lá semáriga nochio Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","'Lige ralámuli 'we a'lá nirásaká Onorúgame etega 'we a'lá semáriga nóchachi ne, 'liko Onorúgame 'we a'lá niraga etémala ne'chí, ne napu nawágame ju 'pa rewagáchika napurigá rió neraga. 'Lige Onorúgame 'we yati gatémala ye 'nátili. ");
INSERT INTO tacNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Neka 'we galé 'emi napurigá ne bo'né 'kúchila neraga. 'Ma pecha we'lisi asimeli júkó ne 'emi 'yuga. 'Émika ne'chí 'yaga e'yénimili júkuru, nobi tabiléchigo gainámalagó simiba alé napu simeli ju ne. Neka 'we 'ya anéturu ye ra'íchali alué e'wélala jurío, jípeko 'emi ruyéguru ne. ");
INSERT INTO tacNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Neka nuebo nulalí nejíguru: 'We a'lá niraga járilime júkuru 'emi a'bopi, 'lige 'we a'lá niraga járilime júkuru uché jaré ralámuli. Neka asíriga 'la galegá eteme kéturu 'emi. Alarigá 'la galegá eteti kárékuru 'emi a'boi a'nagupi. ");
INSERT INTO tacNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","'Emi 'la galegá e'yénasaká a'bopi 'lige 'la niraga 'liko ralámuli jena wijchimoba mochígame 'la machimela 'emi 'la ne'chí oyérame ko. ");
INSERT INTO tacNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Napu'lige Esusi anílige tabilé gainamio simiba ralámuli napu simeli nílige bo'né, 'lige Simoni Pegro Esusi rukele: ―Mué Wa'lula, ¿koche simé olá mué? 'Lige Esúsika nejele: ―Napu simé olá ne, tabilé gainámala mué ne'chí najatia. Pe abé i'libeko najátamala mué ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","'Liko Pégroka anele: ―¿Chonigá tabilé najátawa mué jipe? Tabilé chéré rekó me'liruge ne, neka abirigá 'we a'lá listo ajtíkuru mué si simea. ");
INSERT INTO tacNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","'Lige Esusi nejele: ―¿'La bijchiá listo ajtí mué napurigá me'liboa mué ne'chí gu'írame kóriká? Neka ta'mé mayé nili. Neka 'la bijchiá aníguru. Be'lí be'á o'tolí ta'chó sinachi, tabilé machióriméla mué ne'chí baisá neraga. ");
INSERT INTO tacNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","'Lige Esusi anile: ―Tase seweka mochiwa tase we'ká 'nátiga. 'La nerawa Onorúgame, 'lige 'la nerawa ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Alé 'pa ne O'nola galílachi asíriga we'kaná nerú napurigá ejperega mochímala 'emi. Ta bijchiá nísaká, pecha animé ko ne alé simeo 'we a'lá gatemia napurigá 'emi ejperélamala. ");
INSERT INTO tacNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","'Lige a'kinana ne simisá 'lige 'ma gatesa, uchéchigo ku nawama olá ne 'emi o'tomea 'pa rewagachi napurigá 'emi alé bilena mochímempá napu ne asimé olá. ");
INSERT INTO tacNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","'Émi 'la machíguru bowé napu sébame ju napu ne simé olá. ");
INSERT INTO tacNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","'Lige anele alué Romasi: ―Mué Wa'lula, tabilé machiaa ramué alé napu simé olá mué. 'Lige ¿churigá machibówé alué ko bowé alé simime? ");
INSERT INTO tacNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","'Lige Esusi regá anele: ―Ne júkuru alué bowé. Neka 'la bijchiga ruwíguru, ne júkuru uché rajpé nejime a'walí napurigá 'la ajagá mochiwa. Tabilé 'wesi sebámala napu ajtí O'nó Onorúgame bo'né a'walila gite, ne a'walila gite 'la sebámala 'emi. ");
INSERT INTO tacNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","'Emi 'ma asíriga 'la machí alué ko ne. Alekeri 'we a'lá machimela 'emi ne O'nola Onorúgame. 'Ma machíguru 'emi Onorúgame, 'máchigo we'sá eteme kame Onorúgame, ne'chí etega. ");
INSERT INTO tacNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","'Liko alué Belipe anele: ―Mué Wa'lula, 'la elawa napurigá ramué e'newa alué O'nó Onorúgame. Pe e'nésiga a'lá nímaleké. ");
INSERT INTO tacNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","'Liko Esusi anile: ―Mué Belipe, 'ma asíriga we'ká rawé ajtíkuru ne 'emi 'yuga, ¿bijí tabilé 'cho machí mué ne'chí? Bilé rió ne'chí eteme ka, alueka ne O'nola Onorúgame abiena eteme júkuru. 'Liko ¿chonigá tánebeché mué ne'chí napurigá elawa napurigá mué 'la etémala alué O'nó Onorúgame? ");
INSERT INTO tacNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Tabilé bijchigi mué ne O'nó Onorúgamechi ajtigó ne 'lige O'nó Onorúgameka ne'chichi ajtigó? Alué Onorúgame 'lige ne si pe bi'lepi 'nátame niru. Alué ra'íchili napu ne ruwí, alueka pecha bo'né 'nátiga ruwígó ne, alué O'nó Onorúgame napu ne sa'pálachi ajtí, alué 'smíguru nocharia ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","'We a'lá bijchígiwa ne ra'ichálila, neka Onorúgamechi ajtíkuru 'lige Onorúgameka ne sa'pálachi ajtíkuru. Tabilé bijchíginilisaká alué ra'íchali napu ne ruwí, pe a'lá bijchígisa 'la ju alué nóchali napu ne nocha. ");
INSERT INTO tacNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Neka 'we a'lá bijchiá aní, alué napu ekí 'la nirame ju ne'chí, alueka 'la gainámala sa'wá napurigá ne, 'lige aminami abé wa'lú nóchali newámala. Neka alé napu wa'lula O'nó Onorúgame ajtí, alé simé oláguru. 'Liko alé asigá 'yámala ne a'walí 'emi. ");
INSERT INTO tacNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","'Lige 'emi ne'chí tánasaká a'walí bi'lepi 'nátili 'nátaga ne'chí 'yuga, 'liko 'la 'yámala ne napu ta 'emi. Neka ala'sima oláguru napurigá ralámuli etémala chiena 'la ka O'nó Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","'Emi tásaká napuyépiri tábiri 'la niraga ne'chí, 'liko 'we ganíliga nejkúrimili júkuru ne. ");
INSERT INTO tacNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","'Lige Esusi aminabi anile: ―'Emi 'la nirásaká ne'chí 'liko 'la 'we a'lá e'wámala napu nulá ne. ");
INSERT INTO tacNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","'La e'wásaká 'emi 'liko tánime ne Onorúgame napurigá Onorúgame julámempá uché bilé nejkúrame 'lige nabí 'emi 'yuga asimémpá. ");
INSERT INTO tacNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ye nejkúrame ka pe Onorúgame Alawala ju, alueka asíriga 'la bijchígili benírame ju. Ralamuli tabilé ne'chí oyérame ka, alueka tabilé narémala alué alawá, pecha námame kame ye 'nátili churigá ka Onorúgame Alawala, alekeri tabilé gainámala narea, nobi 'émika 'láchigo machígó. Ye alawaka 'emi 'yuga rejpímili ko 'lige aminami 'emi sapálachi rejpímili ko. ");
INSERT INTO tacNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Tabilé 'oni a'rémala ne 'emi napurigá ba'ligéchili. Abiena nawámala ne 'emi si asimea. ");
INSERT INTO tacNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Pe u'kabi rawé kachi ralámuli napu ekí tabilé ne'chí oyérame ju, alueka tabilé uché etémala ne'chí, 'émika 'la etémala ne'chí. Neka uchéchigo ajánamili júkuru mukusá 'lige 'émichigó. ");
INSERT INTO tacNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","A'lige rawé napu'lige ne naresa alawá uchéchigo siné napurigá ku ajánamala ne, a'lige 'la machimela 'emi Onorúgame si ajtigó ne. Neka bo'né alawala 'yámili júkuru 'emi napurigá 'emi ne'chí 'yuga na'támala. ");
INSERT INTO tacNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Alué napu 'la akeme ju ne nulalila 'lige 'la e'wame ju, alueka 'we a'lá galeme júkuru ne'chí. 'Liko ne O'nola Onorúgame 'we a'lá ganíliga asimela alué ralámuli 'yuga, 'lige néchigó 'we ganíliga asimela alué ralámuli 'yuga. Ne bo'né 'la machírimala churigá ko ne bo'né. ");
INSERT INTO tacNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","'Lige Jurasi asale alé, alué napu tabilé Jurasi Iskariote nile, 'lige anile: ―Mué Wa'lula, ¿churigáriga júpaché? ¿Chonigá pe ramuecho benírama oláché mué chieri ko mué, 'lige chonigá tabilé benírama oláché mué uché jaré ralámuli chieri ko mué? ");
INSERT INTO tacNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","'Lige Esúsika nejele. ―'Émika 'we galéguru ne'chí, 'lige uché jareka tabilé galé ne'chí. Alué napu ekí 'we galé ne'chí, alueka 'la e'wame júkuru alué 'nátili ne nejílala. Ne O'nola Onorúgame 'we galémala alué ralámuli napu ekí ne'chí 'we galeme ju. Ne O'nola 'lige ne si mo'iboa alé riochi, 'lige abalé ejperélawa ramué. Alueka ramué alawala nígame nímili júkuru. ");
INSERT INTO tacNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ne'chí tabilé galeme ka, alueka tabilé e'wame ju ne ra'ichálila. Ne ra'ichálilaka pecha ne bo'né na'tálilate ma'chíname júkó, pe ne O'nola Onorúgame na'tálila júkuru, napu ne'chí júlale. ");
INSERT INTO tacNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","› Neka suwábaga ye ra'íchili ruwíguru jipe bijí 'emi 'yuga asagá jena. ");
INSERT INTO tacNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Napu'lige ne simisá napu Onorúgame ajtí, Onorúgame náomala bo'né alawala ne gite. Alueka 'la bijchiá ruimeli júkuru napurigá 'la nélámala 'emi suwábaga napu ne ruwílige. ");
INSERT INTO tacNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","› Neka a'walí a'réguru napurigá tabilé we'ká 'nátaga ejtebímala 'emi, tabilé seweka, napurigá 'we a'lá sébali ralámuli nímala 'emi. Ye a'walika pe ne bo'né nila júkuru. Ralámuli jena wijchimoba mochígame 'we benírame ju churigá ka alué a'walí napurigá tabilé we'ká 'nátaga mochiwa, tabiléchigo nígame júkó ne a'walila. 'Emi níriga tabilé we'ká 'nátaga mochílime júkuru, tase majaga. ");
INSERT INTO tacNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","'Ma akele 'emi ralámuli ne 'ma simeo, 'lige uchéchigo siné nawamio ne 'emi si asimea. 'Emi 'we galésaká ne'chí, 'liko 'we ra'sálámilikuru ne simichi O'nó bejtélachi, alué kame abéchigo najtékame me'tigá ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Neka bajchabé neraga ruwíguru ta'chó sébachi alué rawé. Napu'lige sébachi alué rawé, 'émika 'ma 'nátaga mochímala ne aníligo ye ruyá. 'Liko abéchigo 'la semátiri narémala ne nila 'nátili. ");
INSERT INTO tacNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","› Tabilé we'ká ra'ichámala ne 'emi 'yuga, ya'má nawámili kame alué wa'lula jena wijchimoba, alué Remónisi anilime. Alueka tabilé nígame ju a'walí napurigá ne'chí uméramala. ");
INSERT INTO tacNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Abirigáchigo a'rema olágó neka napurigá resí olámala ne'chí alué Remónisi, napurigá ralámuli jena wijchimoba mochígame 'la machimémpá ne 'we galeo O'nó Onorúgame, napurigá 'la etémempá ne 'la e'wame ko napu ne O'nola Onorúgame nulá. 'Liko Esusi anele alué oyérame: ―'Ma mochísiwa. 'Ma simawa. ");
INSERT INTO tacNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","'Liko Esusi bilé tétilite ra'íchali ruwile. Regá anile: ―Neka pe napurigá bilé baniá 'we ra'ígame rakeme, pe alarigá ju ne. Alué ne O'nola Onorúgame 'sime ju baniá repua. ");
INSERT INTO tacNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Alueka 'ma rejpúname júkuru napuyépiri atuala tabilé rakeme. 'Lige alué wakígame a'tuwégame nísaká 'ma rejpúname ju napurigá 'la rakémala alué baniá. ");
INSERT INTO tacNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","'Émika 'ma bi'wígame alawégame júkuru 'we a'lá oyériligame ne nila ra'ichálila. ");
INSERT INTO tacNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","'La bi'lepi 'nátaga nokísiwa pe ne na'tálilacho 'lige ne bi'lepi 'nátili na'támala 'emi 'yuga. Bilé baniá atuala pecha rakémalawé 'ma rijpunásiká alué a'tuwá. Abirigá chégame nímili júkuru abe alé baniachi. Yeka ruwime júkuru 'emi tabilé gainamio 'we semátiri 'nátili 'nata tabilé ne'chí 'yuga na'tásaká 'emi. ");
INSERT INTO tacNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","› Neka napurigá bilé baniá alarigá ju, 'émika napurigá alué baniá atuala ju. Bilé rió ne'chí 'yuga 'nátaga inásaká 'lige ne abiena 'we 'yasa iwérali, alueka asíriga 'la semáriga bejtélamala. Tabilé nígame nísaká ne nila a'walí, 'liko tabilé 'la semáriga bejtélamala. ");
INSERT INTO tacNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Bilé rió tabilé ne'chí 'yuga 'nátaga rejpísaká, alueka pe napurigá bilé chalawá pátigime niraga rejpímala. 'Ma wakisáká chalawá 'lige alueka pe e'kósilime júkuru. ");
INSERT INTO tacNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","› 'Emi 'la ne'chí 'yuga na'tásaká 'lige aminami 'la e'wásaká, 'liko 'we támili júkuru e'karúginti, 'liko asíriga 'la nejímala ne. ");
INSERT INTO tacNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Napu'lige 'emi 'we a'lá sébali olasa, 'liko 'we a'lá machimela ralámuli 'emi ne'chí oyérame ko. 'Lige aminami ralámuli asíriga 'la nerámala Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ne O'nola Onorúgameka asíriga galéguru ne'chí, alekeri néchigó 'we galéguru 'emi. 'We a'lá na'tawa ne'chí 'yuga napurigá 'la ganíliga e'yénawa 'emi a'bopi. ");
INSERT INTO tacNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","'La e'wásaká 'emi alué napu ne nulá, 'we a'lá ganíliga asimela ne 'emi 'yuga. Alarigá júkuru ne ne O'nola 'yuga. Neka 'la e'wíguru Onorúgame napu ne'chí nuleme ju, alekeri alueka 'we galé ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","› Neka alarigá ruyéguru 'emi napurigá 'we ganíliga mochímala napurigá ne. Alarigaka 'la ra'sálagá mochiwa. ");
INSERT INTO tacNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ne nulalílaka ye júkuru: 'We a'lá ganíliga járowa 'emi a'bopi 'lige aminami uché jaré 'yuga, a'chigóriga napurigá galeme ju ne 'emi. ");
INSERT INTO tacNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Bilé rió mukusáká bo'né amígola gu'íriga, tabilé nerú bilé 'nátili abé semátiri me'tigá alieri 'nátili. 'Liko alarigá 'la machiboa ye rió 'we galéligo alué bo'né amígola. ");
INSERT INTO tacNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","'Émika ne'chí amígola júkuru 'la e'wásaká napu ne nulá. ");
INSERT INTO tacNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Neka 'ma tabilé «pioni» anémili júkuru 'emi. Bilé piónika pecha machime júkó alué batroni na'tálila. Neka «amigo» aneme ju 'emi. Suwábaga napu ekí beniri O'nó Onorúgame ne'chí, neka 'emi beníruguru suwábagachigó. ");
INSERT INTO tacNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","'Émika pecha owile ne'chí. Neka 'la owíkuru 'emi napurigá si simámala 'emi napurigá semátiri ra'íchali benírimia alué ralámuli, 'lige aminabi nokísimala benírisia, 'lige uché jaré abiénachigó alarigá nokísimala, 'lige tabilé ku guwana rujsuka nokísimala. 'Liko O'nó Onorúgame 'la suwábaga nejímala napu ekí tánili 'la ne na'tálila 'nátame niri ka. ");
INSERT INTO tacNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ye nulalí júkuru napu ne nejí: 'We 'la ganíliga járowa a'bopi. ");
INSERT INTO tacNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","› Ralámuli tabilé oyérame Onorúgame tabilé siné ganíliga eteme ju 'emi. Nibilé néchigó ganíliga etélime kéturu 'yako, ne ta'chó 'yuga eyénachi 'emi. ");
INSERT INTO tacNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","'Emi alué ralámuli gompaniérola nísaká, 'liko 'we galémilikuru 'emi napurigá galeme ju a'boi gompaniérola, nobi tabiléchigo alarigá júkó. 'Émika 'yako alué cha nokame ralámuli gompaniérola nílekuru, 'lige ne bayéturu 'emi. Jípeko 'ma pecha alué gompaniérola júkó 'emi. Alekeri tabilé ganíliga mochí alué cha nokame ralámuli 'emi 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","'La néláwa napurigá anílige ne: «Bilé nóchame ka pecha abé najtékame júkó me'tigá bilé batroni.» Ne'chí cha anesa, 'emi abiénachigó resí anéwali júkuru. Alué ralámuli napu ekí 'la e'wale ne nila rejcholi, abiénachigó e'wámala alué rejcholi napu 'emi nila ju. ");
INSERT INTO tacNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Alué cha nokame ralámuli 'we cha olámala 'emi ne'chí oyérame kórigá. Alueka tabilé machime ju alué napu ne'chí júlale, alekeri 'we resí oláwili ju 'emi. ");
INSERT INTO tacNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","› Neka jena nawáturu 'lige ralámuli 'yuga ra'íchaturu ne. Alekeri napu'lige 'we resí nokigá járisa, asíriga wa'lú chojkila ju. 'La machime ju napu'lige chátiri nóchiligo. ");
INSERT INTO tacNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ralámuli tabilé galeme ka ne'chí tabilé galeme júchigó ne O'nola. ");
INSERT INTO tacNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Neka asíriga 'la semátiri 'nátaga newáturu napu ta'wesi rió gayéname ju newá. 'Lige alué ralámuli etiáturu alué napu ne bo'né 'nátaga newá, 'lige rekó etee alué semati e'karúgame newárigime, tabilé ganíliga etele ne'chí, 'lige alué ne O'nola 'yúgachigó. ");
INSERT INTO tacNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","'We 'ya osirúgime osilí regá aní: «Neka peka chátiri nóchige abirigáchigo nabí tabilé ganíliga etuí ne.» 'Liko alué cha nokame ralámuli jipe ejperégame 'ma sébali oláguru napurigá anile 'ya nerúgame ra'íchali. Alarigá nímili nílekuru, tabilé galéwili nile ne. ");
INSERT INTO tacNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","› Bilé rawé sebámala Onorúgame Alawala napu 'we na'temame ju. Ye alawaka asíriga 'la bijchiga ra'íchame nímala, 'lige asíriga 'la ruwimela alieti eteme ka larigá nóchame ko ne. ");
INSERT INTO tacNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","'Émichigó abiena ruyémili ju uché jaré ralámuli alieti etéligo 'emi ne'chí 'yuga e'yéniga 'ya kulí siné. ");
INSERT INTO tacNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","› Neka ye ra'íchali ruwíguru napurigá 'emi tabilé a'rémala ne nila rejcholi. ");
INSERT INTO tacNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","'Lige 'emi 'ma mabuwa alé u'tá re'obachi «sinagoga» anilime mochígichi alué cha nokame ralámulite. 'Ma pe'wé alué ralámuli 'ma 'emi me'linálimala Onorúgame gu'írame kóriká. ");
INSERT INTO tacNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Alanokimela alué ralámuli napugiti pecha siné oyérame ka O'nó Onorúgame nibilé ne'chítiri. ");
INSERT INTO tacNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Neka yeti ruwíguru napurigá 'emi napu'lige ye raweli sébachi 'la nelámempá ne aníligo yeti ikimeo jena wijchimoba. Neka sinékó tabilé che anéturu 'emi ye ra'íchali bijí 'emi 'yuga ajtigá. ");
INSERT INTO tacNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","› Jípeko 'ma simé ne alué napu ne'chí júlale jékana alué 'yuga asimea. 'Lige 'émika tabilé ruké ne'chí: «¿Koche simé olá mué?» ");
INSERT INTO tacNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Iligá 'émika 'we sewelákuru alanichi ne. ");
INSERT INTO tacNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Neka 'we a'lá bijchiá aní. Napu'lige ne simisá, julámala ne alué Onorúgame Alawala. Alekeri 'emi níriká abé 'la júkuru napurigá ne simela. Ne tabilé simisáká 'liko pecha nawámalagó alué napu 'we na'temame ju ralámuli, alué napu Onorúgame Alawala ju. Ne simisáká 'liko 'la julámala ne alué na'temame jeka napurigá 'emi gu'ira asimémpá. ");
INSERT INTO tacNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Napu'lige alué ralámuli na'temame nawasa, yati machírimala ralámuli jena wijchimoba ejperégame napurigá námamala 'we chátiri 'nátali 'nátaga e'yenio, 'lige 'we a'lá ruwimela nerugo bilé 'nátili 'we semátiri 'lige 'we animela napurigá oyériwa alué 'nátili, 'lige abiena ruwimela Onorúgame gustisia olamio ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","'We a'lá ma'chígame nérélamala 'we chátiri 'nátali 'nátaga e'yéname ko alué ralámuli napugiti tabilé 'la oy'érime nímime ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","'Lige 'we a'lá ma'chígame nérélamala alué a'lala 'nátali, napugiti Onorúgame 'yuga simiá kibámimpá ne napu 'emi tabilé 'wesi etémala ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","'Lige 'we a'lá ma'chígame nérélamala Onorúgame 'we a'lá sébali olame ko gustisia, napugiti Onorúgameka 'ma umériga asimémpá alué napu ju jena wijchimoba nulame napu júpá Remónisi, neyúriga asimela Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","› Asíriga we'ká ra'íchali ruimeli júkuru ne, iligá 'emi 'lina tabilé anachámala jipe. ");
INSERT INTO tacNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Napu'lige sebasa alué Alawá 'we a'lá bijchiá benírame 'la ruwimela suwábaga 'la bijchiá. Pecha bo'né 'nátaga benírimiligó. Alueka benírimili júkuru pe napurigá nulé Onorúgame. 'Lige abiena ruwimela alakimeo abé i'libeko jena wijchimoba. ");
INSERT INTO tacNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ye alawaka ralámuli benírimili júkuru. Ye alawaka asíriga 'la akeme ju ne ra'ichálila napurigá aní ne, 'lige ku 'emi ruyeme ju. 'Lige ralámuli asíriga 'la niraga etémala ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Suwábaga napu ekí nígame ju ne O'nola, néchigó abiena si nila ju. Alekeri aníguru ne ye alawaka 'la gepume ju ne'chí 'lige 'emi ruyémala. ");
INSERT INTO tacNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","› 'Ma pe'wé 'émika pecha etémalagó ne'chí, nobi pe abé i'libeko 'la etémala 'emi ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","'Liko anile jaré alué oyérame a'bopi ra'íchaga: ―¿Tachiri ju alué napu ruyá aní? Regá aniáníguru: «Pe u'kabi rawé kachi pecha etémalawé 'emi ne'chí.» 'Lige aniáníguru: «Pe abé i'libeko 'la etémala 'emi ne'chí.» 'Lige aminami aniáníguru: «Neka O'nó bejtélachi simeo oláguru, alekeri tabilé etémala 'emi ne'chí.» ");
INSERT INTO tacNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","'Lige alué oyérame uché rajpé rukele: ―¿Tachiri ruyame ju napu'lige alarigá ra'icha «pe u'kabi rawé» kachi aniá? Tabilé námalia ramué alieti ra'íchiga anió. ");
INSERT INTO tacNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","'Lige Esusi machile e'karúgame rukénilia jago, 'lige Esusi anele: ―Neka aniéturu pe u'kabi rawé kachi 'emi 'ma tabilé etemio ne'chí. 'Lige aníturu ne pe'kabi rawé kachi 'ma ku etemio 'emi ne'chí. ¿Alué ju napu 'emi a'bopi rukea mochí? ");
INSERT INTO tacNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Neka 'la bijchiá aníguru. 'Émika nalámala 'lige aminami asíriga seweka mochímala, nobi alué ralámuli napu tabilé oyérame ju ne'chí, alueka asíriga ganíliga mochímala. Nujubaka ku 'we a'lá ra'sálagá mochímala 'emi. ");
INSERT INTO tacNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Napu'lige bilé mukí ranélimili nisa, asíriga seweka ajtime ju, 'láchigo machime kame o'komio. Napu'lige 'ma ranega asagaka 'liko 'ma we'káwame ju alué o'kólime. 'Ma asíriga 'la ra'sálagá ajtime ju napugiti 'ma ochériligame alué u'tátiri. ");
INSERT INTO tacNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Alarigá júkuru 'emi 'yuga. Jípeko 'we seweka mochíkuru 'emi, nobi pe'wé ku 'la asíriga ra'sálagá mochímala 'emi 'lige aminami tabilé 'wesi gainámala 'emi sewelégame newá uchéchigo siné. ");
INSERT INTO tacNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","› Napu'lige seba raweli 'liko 'ma pecha rukémala 'emi ne'chí, Onorúgame Alawálaka 'máchigo 'la beniria asimémpá. 'Lige alué O'nó Onorúgame nejímala napu'lige 'emi tánisa bilé tábiri napu nígame ju alué bo'né, 'emi 'la bi'lepi 'nátiga mochísaká pe ne'chicho 'nátiga, 'lige 'emi 'la e'wásaká napu ne nulá. ");
INSERT INTO tacNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","'Émika ta'chó tániguru Onorúgame, pecha 'cho 'la bi'lepi 'nátame kame 'emi. Jípeko 'la júkuru tánilia, yati nejímala 'lige 'émika yati narémalachigó, 'lige asíriga wa'lú ganílili narémala 'emi. ");
INSERT INTO tacNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","› Neka tétilite ruwíguru napu'lige bijí jena wijchimoba asagá napurigá na'támala 'emi churigá ko ne na'tálila, nobi pe 'we 'ma tabilé alarigá ra'ichama olago ne, pe iligá 'we a'lá bi'wígame ra'ichama olá ne napurigá 'la námamala 'emi churigá ko ne O'nola Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","'Émika 'la tánimili júkuru Onorúgame, ne'chí 'yuga 'nátaga. Neka tabilé tánamala Onorúgame napurigá 'emi gu'írimala, ");
INSERT INTO tacNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Onorúgame 'we galeme ju 'emi. Onorúgame 'emi galéguru napugiti 'émika ne'chí galeme kame, 'lige 'émika 'we a'lá bijchígile ne ra'ichálila. 'Émika 'la machíguru Onorúgame bejtélachika nawágame ko ne. ");
INSERT INTO tacNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Neka Onorúgame bejtélachika nawáturu, 'lige jeka wijchimoba nawáturu ne. 'Lige jípeko 'ma simé olá ne, 'ma ku O'nó Onorúgame bejtélachi. ");
INSERT INTO tacNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","'Lige alué oyérameka anile: ―Jípeko 'la námatame ra'icha mué, 'we a'lá námilia ramué alué ra'íchali. ");
INSERT INTO tacNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","'We a'lá machirú mueka suwábaga 'la namio, mueka 'we a'lá machí alieti 'nata mochigo ralámuli, asíriga 'la nejiámala napu chibiyeti rukinali ta'chó rukilichi. Alekeri 'la machiaa Onorúgame bejtélachika nawágame ko mué. ");
INSERT INTO tacNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","'Lígeko Esusi rukele: ―¿'La bijchiá bijchigi 'emi? ");
INSERT INTO tacNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","'Ma pe'wé 'emi 'ma pecha napuíka mochímala. Asíriga ra'laga mochímala 'emi. 'Ma bi'neli a'rémala 'emi ne'chí, nobi alué ne O'nola Onorúgame síchigo ajtíkó ne 'yuga. Alekeri tabilé bi'neli ajtí ne. ");
INSERT INTO tacNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Neka ye ra'íchali ruwíguru napurigá 'emi 'la sébali ralámuli nímala tabilé we'ká 'nátame, 'lige aminami napurigá 'la bi'lepi 'nátame nímala 'emi. 'Émika asíriga resí nílimala jena wijchimoba, nobi tabiléchigo seweka mochíwagó, 'we iwériga mochiwa tabilé seweka, napugiti neka 'máchigo umérigame alué chátiri 'nátili. ");
INSERT INTO tacNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","'Ma ruwisá Esusi ye ra'íchali, pa o'wétiri e'nele 'lige Onorúgame 'yuga ra'íchale, regá anile: ―Mué O'nó, 'ma seba raweli, mué Inolá ju ne, gu'iri ne'chí napurigá suwábaga ralámuli 'la námaka etémala chiena semá 'sime ko ne. Ne napu mué Inolá ju, 'la suwábaga ralámuli gu'írimala beniria chiena semá 'sime ko mué Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Mué ne'chí a'walí 'ya napurigá ne nulémala suwábaga ralámuli napu mué wanápale, 'lige napurigá 'la rewagachi ejperélamala senibí niraga mué 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","'La mué Onorúgame oyérasaká ye ralámuli 'lige ne'chí oyérasaká, 'liko 'la rewagachi simámala alué ralámuli. Mué júkuru 'la bijchiá bi'neli Wa'lula Onorúgame, 'lige mueka ne'chí júlakuru jena wijchimoba. ");
INSERT INTO tacNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","› Ne beniri alué ralámuli chiena a'lá ko mué, 'ma suwaba ne alué nóchali napu mué nulá. ");
INSERT INTO tacNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Mué O'nó, jípeko mué 'yuga asinali ne uchéchigo siné. Ne'chí 'yawa alué a'walí uchéchigo siné napurigá nile 'yabé ta'chó nerúgichi ye gawí, napu'lige mué 'yuga ajtigé ne. ");
INSERT INTO tacNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","› Alué ralámuli napu mué wanápale 'ya napurigá ne'chí oyérame nímala 'lige ne 'la ruyéturu chieri ka mué. Mué ju alué Wa'lula alué ralámuli nuleme 'lige repume 'lige mué 'ya ne'chí a'walí napurigá ne 'símala nulea alué ralámuli. Suwábaga alué ralámuli 'la e'wá napu nulá mué ra'ichálila. ");
INSERT INTO tacNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ne ruyé alué ralámuli, suwábaga napu ne nígame ju, alueka mué Onorúgame nejíturu. ");
INSERT INTO tacNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ne ruyé alué ra'íchali napu mué 'ya ne'chí, alué ralámuli 'la bijchigi ye ra'íchali. 'La machí alué ralámuli napu mué ajtí, aleka nawáligo ne. 'Lige 'la bijchígile mué 'síligo ne'chí jula jena wijchimoba. ");
INSERT INTO tacNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","› Ne taní napurigá 'la gu'írimala mué alué ne'chí oyérame. Tabilé taní ne napurigá suwábaga ralámuli gu'írowa, pe alué ralámulicho napu mué 'ya ne'chí napurigá nulémala ne. Alué ralámuli mué nila ju. ");
INSERT INTO tacNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Suwábaga alué ralámuli napu ne nulé mué nila ju, 'lige suwábaga alué ralámuli napu mué nila ju abiena ne nila ju, 'lige etega uché jaré ralámuli chiena 'la sébali olame ko alué ne'chí oyérame, 'lige 'we a'lá nirá ne'chí. Napu'lige uché jaré ralámuli machisá churigá ko ye ralámuli mué ra'ichálila oyérame, a'lige 'la machimela rewagáchika nawagó ne napu mué ajtí. ");
INSERT INTO tacNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","› Ne pe'wé simé olá napu mué ajtí, tabilé jena wijchimoba asimé olá ne. Suwábaga napu ne'chí oyérame ju, alueka jena wijchimoba mochímala. 'La repúpuaka mué alawálate alué ralámuli napu mué wanápale. Mué O'nó, mué ju bi'lepi Onorúgame, 'lige mué alawala ju napu ralámuli gu'írame ju napurigá 'la bi'lepi 'nátili 'nátame nímala napurigá mué 'lige ne si 'la bi'lepi 'nátili 'nátame niru. ");
INSERT INTO tacNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Napu'lige ne bijí alué ralámuli 'yuga eyena, neka mué alawálate repume kéturu alué ralámuli. Ne repume kéturu 'lige tabilé 'cho we'ká, abiena we'ká bilé, Jurasi anilime ju alué rió. Alarigá anile Onorúgame ra'ichálila 'ya nerúgame, 'lige 'la sébali ikimeli ju napurigá anílige alué ra'íchali. ");
INSERT INTO tacNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","› Pe 'we simé olá ne napu mué ajtí. Ne ruyé ralámuli alué ra'íchali bijí jena wijchimoba asagá, napurigá 'la ganíliga mochímala napurigá ne. ");
INSERT INTO tacNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ne 'la beniri alué ralámuli ramué oyérame alué ra'íchali napu beniri mué ne'chí. Suwábaga ralámuli napu tabilé oyérame ju ne'chí senibí tabilé ganíliga mochime ju napugiti tabilé a'chigóriga 'nátame kame. Neka tabilé 'nata napurigá 'nátame ju alué ralámuli tabilé oyérame ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Tabilé taní ne napurigá 'ma buinawa jena gawichí alué ralámuli ne'chí oyérame, pe 'we repúkiame najkí ne napurigá 'la tabilé cha'pimela alué chátiri 'nátili. ");
INSERT INTO tacNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Neka tabilé oyérame ju alué chátiri 'nátili napu nerú jena gawichí, alué ralámuli napu ne si e'yéname ju, alueka tabilé oyérame ju alué chátiri 'nátili. ");
INSERT INTO tacNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","'We a'lá niraga etewa alué napu mué oyérame ju, nóchali 'yawa napurigá mué najkí. 'La 'nátili 'yawa napurigá 'la rejchirúgame nímala beníriga mué ra'ichálila. Mué ra'ichálila 'la bijchiá ju. ");
INSERT INTO tacNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ne nulé alué ralámuli napurigá gu'írimala uché jaré ralámuli napurigá mué nulé ne'chí suwábaga ralámuli gu'íriniliga. ");
INSERT INTO tacNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Jena ajtí ne 'la listo mukumea napurigá alué ralámuli ne'chí oyérame 'la bi'wígame alawégame nímala napurigá waná mochímala, tase napurigá alué ralámuli chátiri alawégame. ");
INSERT INTO tacNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","› Neka abiena ta ajtí napurigá gu'írowa alué ralámuli napu nujubá oyéramili ju ne'chí napu'lige akisá alué ra'íchali napu ruimeli ju alué ne'chí oyérame ralámuli jipe mochígame. ");
INSERT INTO tacNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mué O'nó, taní ne napurigá gu'írimala mué napurigá 'la bi'lepi 'nátili 'nátame nímala suwábaga alué ne'chí oyérame. Najkí ne napurigá 'la bi'lepi 'nátili na'támala pe ramuecho 'yuga, napurigá ne 'la pe bi'lepi 'nátili 'nata pe muecho 'yuga. Bi'lepi na'tálime najkí ne napurigá bijchígimala uché jaré ralámuli mué 'síligo ne'chí jula. ");
INSERT INTO tacNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Neka 'we a'lá nirá alué ralámuli napurigá mué 'we a'lá nirá ne'chí napurigá 'la bi'lepi 'nátame nímala napurigá ramué bi'lepi 'nátame niru. ");
INSERT INTO tacNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mué 'smi alawá 'ya ne'chí 'lige néchigó alawá 'ya alué ralámuli napurigá 'la sébali bi'lepi 'nátili 'nátame nímala, napurigá uché jaré ralámuli 'la machimela mué 'síligo ne'chí ajchá jena napu ajtí ne jipe, 'lige napurigá 'la machimela mué 'we galeo ne alué ralámuli napurigá galé mué ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","› Mué O'nó, mué 'sile ne'chí 'ya suwábaga ye ralámuli napu 'la oyérame ju ne'chí, 'lige najkí ne napurigá suwábaga alué ralámuli ne 'yuga mochímala senibí, 'lige napurigá 'la machimela chieri ko ne, napurigá 'la machimela 'we a'lá ganíliga etéligo mué 'lige iwérali 'yáligo mué ne'chí. Mué 'we a'lá galegá etele ne'chí napu'lige tabilé 'cho nerúgichi ye gawí. ");
INSERT INTO tacNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Mué O'nó, mué ju napu 'la sébali olame ju. Tabilé 'me suwábaga ralámuli machí chieri ko mué, neka 'láchigo machígó chieri ko mué, 'lige alué ralámuli napu 'la oyérame ju ne'chí 'la bijchiga nirá mué 'síligo ne'chí jula. ");
INSERT INTO tacNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ne 'ma 'la sébali ruyé chieri ko mué, 'lige aminabi ruyémala ne napurigá 'la galegá etémala mué alué ralámuli a'chigóriga napurigá galé mué ne'chí, 'lige napurigá 'la ne alawala alawega mochímala. ");
INSERT INTO tacNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","'Ma ra'ichasa Esusi ye ra'íchali, simírole alé gomichi napu Segroni anilime gomí nile, suwábaga alué makué bilé rió napu Esusi 'yuga járome nile. Alé bilena napu we'ká jale rojá olibo anilime, alé simile bo'né 'yuga járome 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jurasi, napu Esusi saíla gayénale, alué rióchigó abiena machime nile alé, Esusi 'ma we'sá napubúlige alué ralámuli alé. ");
INSERT INTO tacNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","'Lige alué rió Jurásika simile najátasia Esusi we'ká sontalo 'yuga, alué gobierno romano sontálola, 'lige jaré sontalo 'yúgachigó, alué wa'lú re'obachi tebume. Júlale alué e'wélala balé 'lige alué bariseo. E'wele siparínaga 'yénele alué sontalo. Lámpara aseite ro'érigame o'ká e'yénele 'lige chojpé rajigáchigó. ");
INSERT INTO tacNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Esúsika 'ma machigá asale suwábaga alakimeo, alekeri etesa, pe'tá simile najtepamia, 'lige rukele: ―¿Chieri 'yamía 'emi? ");
INSERT INTO tacNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","'Lige nejele alué sontalo: ―Esusi, Nasareta anilichi bejtégame. A'lige Esusi anele: ―Ne ju. Alué Jurasi abiena alé ilílechigó alué sontalo 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Napu'lige Esusi anesa, «Ne ju», suwábaga alué sontalo guwana bi'tíbale wijchí. ");
INSERT INTO tacNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","A'lígeko Esusi uchéchigo siné rukele: ―¿Chieri 'yamía 'emi? 'Lige sontáloka nejele: ―Esusi, Nasareta anilichi bejtégame. ");
INSERT INTO tacNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","―Ya'má ruwíkuru ne ko ―anile Esusi―. Ne'chí 'yamía ka, ye uché jaré ralámuli a'rewa napurigá simámala. ");
INSERT INTO tacNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Regá anile napurigá a'lá alarigá nímala napurigá anile 'yabé bajchabé rawé. Anile bo'né: «Tabilé 'wesi ralámuli we'kámala, alué ralámuli napu O'nó Onorúgame wanápale napurigá ne bo'né repúmala.» ");
INSERT INTO tacNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","A'lige Simoni Pegro anilime bilé siparina o'kame nile, 'lige ma'chí pale, 'lige rejpúnale bilé rió najkala Malko anilime, wajtoná ilígame najká. Málkoka alué wa'lula balé piónila nile. ");
INSERT INTO tacNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","'Lige Esúsika nulele Pegro: ―Ku reká alué siparina alé napu ma'chí pa mué. Ne O'nola Onorúgamete ajchárigame ju ne napurigá ejelímala. ¿Tabilé mayé mué 'la sébali olamio ne ye resí ikiame? ");
INSERT INTO tacNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","A'lige alué sontalo romano 'lige alué wa'lula sontalo si, 'lige alué uché jaré sontalo 'ma cha'pile Esusi, 'lige 'ma bulele, ");
INSERT INTO tacNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","'lige Anasi bejtélachi o'tóleru. Alué rió Anásika Kaipasi si'lá nile napu wa'lula balé nile aleké bamí. ");
INSERT INTO tacNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ye Kaipásika pe aba alué nile napu anile tabilé mukusáká Esusi a'lígeko alué sontalo romano we'ká jurío me'liméráo, 'lige abé 'la nirale napurigá pe bi'lepi rió mukiáriká tase we'ká. ");
INSERT INTO tacNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Napu'lige 'ma o'tosuga Esusi, Simoni Pégroka 'lige uché bilé Esusi oyérame Esusi najátasia e'yénale. Alué rió napu Pegro 'yuga enale 'ma we'sá etérigame nile alué balé wa'lúlate, alekeri napu'lige Esusi bajkichi alé ra'pichí alué wa'lula galílachi, abiena 'la 'yáleru lisensia alué rió alué yochi repúmete napurigá 'la bajkimela alé ra'pichí. ");
INSERT INTO tacNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pégroka ma'chika rejpile alé a'bé yóchika. A'lige alué uché bilé rió napu bajkile alé ra'pichí ku yati ma'chínale 'lige ra'íchale alué mukí 'yuga napu tebuka ilile alé yochi. A'lige ku uchéchigo bajkile, Pegro 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","'Lige alué mukika alé yochi repume regá rukele Pegro: ―¿Tabilé alué ju mué alué rió gompaniérola napu a'paru? ―Tabilé ―anile Pégroka―. Tabilé alué gompaniérola ju ne. ");
INSERT INTO tacNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","'We rulágachi nile, 'lige alué sontalo wa'lú re'obachi tebume 'lige nóchamechigó na'yasa sujkáliga jale. 'Lige Pégrochigó alé simile sujkálimia alué ralámuli 'yuga. ");
INSERT INTO tacNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pachá galírale, alué wa'lula balé chojkile rukea Esusi chieri ko alué suwábaga ralámuli napu Esusi gompaniérola níligo 'lige tachiri níligo napu alué Esusi benírile alué ralámuli Esusi oyérame. ");
INSERT INTO tacNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Esúsika regá anile: ―Neka 'la senibí 'la benírite'é alé bilena napu 'la suwábaga alué ralámuli 'la ma'chígime akimela. 'Ma suwábaga beniri ne alé u'tá re'obachi «sinagoga» anilime 'lige abiena alé wa'lú re'obachi ra'pichí, alé kame napu we'ká ralámuli napuíme ju, tase siné chíboka beniri ne. ");
INSERT INTO tacNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Chonigá ne'chí rukéliaché suwábaga ye ra'íchali? Alué ralámuli napu ne'chí gepule, alué rukéwaguru suwábaga ra'íchali rukewa napu aníligo ne. Alué ralámuli 'la machí suwábaga napu aníligo ne. ");
INSERT INTO tacNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Regá anichi Esusi, bilé sontáloka, alué wa'lú re'obachi nóchame, Esusi wejpale banachí, 'lige regá anele: ―¿Alarigá nejeme ju mué ye wa'lula balé? ");
INSERT INTO tacNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Esúsika regá nejele: ―Ne se'winá charigá aniákó, ruwígó churigá ko. 'Láchigo 'la bijchiá kágobá napu aní ne. ¿'Lige chonigá wejpápaché mué ne'chí? ");
INSERT INTO tacNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","A'lige Anásika Esusi júlale sekachí bulugá Kaipasi ajtígichi. ");
INSERT INTO tacNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Napu'lige alakichi ye, Simoni Pégroka bijí sujkáliga ilile alé a'bé na'beta. 'Lige uchéchigo rukéleru Pegro uché jaré ralámulite, regá rukéleru: ―¿Tacha Esusi gompaniérola ju mué? 'Lige Pégroka 'yégiga nejele: ―Neka tabilé Esusi gompaniérola ju. ");
INSERT INTO tacNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Alé ilile bilé rió alué wa'lula balé piónila, alué rió rijimala napu Pegro najkala rejpúnale. 'Lige regá rukéleru Pegro alué riote: ―¿Tacha eté ne mué alé napu we'ká ja rojá olibo Esusi 'yuga eyénachi mué? ");
INSERT INTO tacNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","'Lige uchéchigo siné anile Pegro tabilé alué rió ko. A'lígerikáchi bilé o'tolí sinale. ");
INSERT INTO tacNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","'Ma che'lachi ma'chí páliru Esusi Kaipasi galílachi, o'tóleru Esusi alué wa'lula selígame romano bejtélachi. Alué jurío e'wélala napu o'tole Esusi, alueka tabilé mo'ile alé galichi Esusi 'yuga, napugiti alarigá nokame níligame alué a'bopi ka, alué juríoka tabilé mo'ime nile tabilé jurío bejtélachi bilé piesta nerúgichi. Wa'lú piesta nile Páskua anilime. 'Ma mo'isáká a'lígeko tabilé elílime nile alué go'ame go'yachi piesta nerúgichi. ");
INSERT INTO tacNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Alekeri alué selígame Pilato anilime ma'chínale alé pachaka galíraleká, 'lige regá rukele: ―¿Tachiri gite nejiga e'yénilia 'emi ye rió? ");
INSERT INTO tacNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Regá nejele alué e'wélala jurío: ―Tabilé cha 'sísaká ye rió, a'lígeko pecha a'páwili ko ramué ye rió. ");
INSERT INTO tacNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilátoka regá anile: ―'Emi o'togá go, 'lige bilé gastigo 'yawa 'we a'lá sébali napurigá oliame ju. Alué e'wélala juríoka ku regá nejele: ―Ramué juríoka tabilé lisensia nígame niru napurigá me'liboa bilé ralámuli, pe 'emi ralámuli románoka 'la lisensia nígame ju. ");
INSERT INTO tacNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","('Ya bajchabé rawé Esusi alarigá anile bilé gulusichi chujkugá mukuméoríle.) ");
INSERT INTO tacNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilátoka ku pachá simile bo'né galílachi Esusi bayemia 'yuga ra'ichamia. 'Lige regá anile: ―¿Mué ju alué jurío wa'lula rey? ");
INSERT INTO tacNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","'Lige Esusi regá nejele: ―¿Mué bo'né alarigá machinali? ¿O péchala pe iligá ruké mué napugiti uché jaré ralámuli aniame? ");
INSERT INTO tacNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilátoka regá nejele: ―Neka tabilé chélá wa'lula ko mué o tabilé wa'lula ko mué. Neka tabilé jurío ju. Alué ralámuli jurío 'lige alué balé e'wélala nokale mué nejía. Mué jurío júchigó. ¿Tachiri chu'síkame júkó mué? ");
INSERT INTO tacNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Esúsika regá nejele: ―Napu ne nulame ju, tabilé jena wijchimoba ju. Alarigá nísaká, a'lígeko suwábaga ne gompaniérola nakómiliké napurigá tabilé o'toboa ne alé napu mochí e'wélala jurío. Neka tabilé nulámili ju jena wijchimoba. ");
INSERT INTO tacNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","A'lige Pilátoka regá rukele: ―'Liko ¿mué ju wa'lula rey ralámuli jurío nuleme? Esúsika regá nejele: ―Wa'lula ju ne napurigá aní mué. Nawá ne jena wijchimoba 'lige jena ochérigame ju ne napurigá wa'lula nímala. Nawá ne bilé ra'íchali ra'ichamia 'we najtékame. Suwábaga ralámuli napu 'la e'wame ju alué 'la bijchiá ra'íchali, 'la gepume ju ye ra'íchali napu ra'icha ne. ");
INSERT INTO tacNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","'Lige Pilátoka regá rukele: ―¿Tachiri júkó alué 'la bijchiá ra'íchali? 'Lige 'ma rukésaká, Pilátoka ma'chínale alué ralámuli jurío 'yuga ra'ichamia, 'lige regá anele: ―Neka tabilé se'wináriga etiá ye rió napurigá me'liboa. Tabilé cha 'síkame ju. ");
INSERT INTO tacNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Senibí bamí Páskuachi bilé jurío su'páname ju ne napu 'yériga mochí, 'lige 'ma su'panásaká, 'ma tabilé uché ku cha'piame ju alué. ¿Najkí 'emi napurigá su'panawa ye rió Esusi, wa'lula rey ralámuli jurío nuleme? ");
INSERT INTO tacNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","A'lígeko suwábaga alué ralámuli jurío anile: ―¡Ye rioka tabilé supanawa! ¡Barabasi 'lina su'panawa! Barabásika geriyero nile, napu galírale bajcháriga ajtile. ");
INSERT INTO tacNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","'Lige Pilato jaré sontalo nulele napurigá o'tomela Esusi wejpisomia. ");
INSERT INTO tacNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","'Lige alué sontalo newale bilé gorona wejchate 'lige Esusi mo'ólachi ajchele. A'lígeko bilé chónaga sejtákame chinite gemele napurigá bilé wa'lula neraga. ");
INSERT INTO tacNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","A'liko alué sontalo alé a'bé jábale Esusi ilígichi 'lige regá anele, chibi anigá gawéliga: ―¡Mué rió jurío Wa'lula Rey, we'ká bamí bejtélasa 'la ju! 'Lige banachí wejpigá nokigá anile alué ralámuli sontalo. ");
INSERT INTO tacNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","A'lige Pilato uchéchigo ma'chínale 'lige ra'íchale alué ralámuli jurío 'yuga, 'lige regá anele: ―'La e'nesi, ma'chí pámala ne ye rió napugiti tabilé machiame ne chonigá me'liboli ko ye rió. ");
INSERT INTO tacNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","'Lige pachaka ma'chínale Esusi wejchá gorónaga, 'lige chónaga sejtákame chiní gemagá. A'lige Pilato regá anile: ―¡'La e'nesi, jena ilíkuru ye rió! ");
INSERT INTO tacNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","'Lige alué balé e'wélala 'lige alué sontalo napu repume ju alué wa'lú re'obá, Esusi etesa, a'wágame ra'íchaga anile: ―¡Bilé gulusichi ujchugá me'libóguru alué rió! A'lige Pilato regá anile: ―'Emi a'bopi o'togágó. 'Lige bilé gulusichi ujchugá me'liboa. Neka tabilé machí tachiri chu'síkame ka ye rió napurigá me'liboa. ");
INSERT INTO tacNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Alué ralámuli juríoka regá anile: ―Ramueka regáriga machiaa ye ra'íchali Onorúgame nulalila, ye rió me'liátikó, alué rió Onorúgame Inolá koriánturu. Tabilé che animeli ju ye rió napuyeti Onorúgame koriá. Abirigá mukumeli ke. ");
INSERT INTO tacNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Napu Pilato akisá regá anichi ye ralámuli, uché abé majale. ");
INSERT INTO tacNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ku pachá galírale bajkile Esusi 'yuga, 'lige rukele: ―¿Koche bejtégame ju mué? Esúsika tabilé tábiri nejele. ");
INSERT INTO tacNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","A'lige Pilato regá anele: ―¿Ne'chí tabilé nejémala mué? ¿Tabilé machí mué ne ko wa'lula napurigá nulámala ne mué me'liachi bilé gulusichi ujchugá, 'lige napurigá su'panámala napurigá simela mué? ¿Tabilé machí mué? ");
INSERT INTO tacNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Esúsika regá nejele: ―Mué tabilé lisensia 'yásiga Onorúgamete napurigá wa'lula nímala mué, tabilé nulémilikuru mué ne'chí me'líniliga. Alué ralámuli napu ne'chí a'pale jena, alué ralámuli abé wa'lú cha nokágame ju, peka napurigá mué. Alué ralámulika se'winá nokale, tabilé napurigá nulá Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","A'lige si Pilato 'we 'nátale churigá su'panamio Esusi. Tabilé najkile napurigá me'liboa. 'Lige uchéchigo siné ra'íchale ralámuli jurío 'yuga, 'lige alué ralámuli jurío e'wele ra'íchaga anile: ―'Ma su'panásaká mué Esusi, a'lígeko tabilé alué wa'lula nulame rey gompaniérola ju mué, alué napu Roma ajtí. Alué bo'né Esusi aniéturu wa'lula rey ko, suwábaga ralámuli nuleme, a'lígeko saíla ju alué wa'lula 'yuga Roma ajtígame. ");
INSERT INTO tacNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Napu'lige Pilato akisá alanichi alué ralámuli jurío, ma'chí pale Esusi uchéchigo siné. 'Lige Pilato asíbale alé bilé síachi napu gustisia oliame nile ralámuli alé napu anilime nile Gabata ebreo ra'íchaga. Gabata aniáká «Rejté Chijpérigime Pétigame» aniame kéré. ");
INSERT INTO tacNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Bilé rawé bajchabé nile napu newame nile wa'lú piesta Páskua anilime. Amulí rawilí nile. A'lígeko Pilato regá anele alué ralámuli jurío: ―¡Jena ilí wa'lula rey 'emi nuleme! ");
INSERT INTO tacNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Alué suwábaga ralámuli jurío uchéchigo a'wágame ra'íchaga regá anile: ―¡O'togá, o'togá ye rió, bilé gulusichi ujchugá me'liboa! Pilátoka regá anile: ―¿Najkiá 'emi napurigá me'liboa ye rió 'emi nuleme bilé gulusichi ujchugá? 'Lige alué e'wélala balé regá nejele: ―Alué rioka tabilé wa'lula ju ramué nuleme. Bi'lepi wa'lula ju, alué napu ajtí alé Roma anilichi. ");
INSERT INTO tacNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","A'lige Pilato lisensia nejile napurigá me'liboa Esusi bilé gulusichi ujchugá. A'lige sontalo 'ma o'tole Esusi. ");
INSERT INTO tacNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Esusi bo'né o'tole alué gulusí majtoga, 'lige sébale bilena rabó Anayáwali Mo'ola anilichi. Alué ralámuli jurío Gólgota aneme nile. ");
INSERT INTO tacNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Alé wijchí rekagá klabo jáwale sekachí 'lige ronólachi, 'lige o'weti elale alué gulusí. Abiena uché jaré oká rió ujchálechigó uché jaré gulusichi alé a'bé napu ujcháliru Esusi, 'lige Esusi alé nasipa ujcháliru alué oká rió uchúkichi. ");
INSERT INTO tacNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilátoka nulele alué sontalo romano napurigá ujchawa bilé rabileta osirúgime alé gulusichi, mo'ochí amóbage napu chujkule Esusi. Regá anime osilí: «Esusi Nasareta anilichi bejtégame, alué wa'lula rey ralámuli jurío nuleme.» ");
INSERT INTO tacNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","We'ká ralámuli jurío e'nénale 'lige leérale alué osilí, a'bé níligame Rusaleni anilichi napu ujcháliru Esusi alué uché oká rió 'yúriga. Alué osilí bakiá se'wináriga ra'íchiga osirúgime nile, napurigá ra'íchame nile ralámuli jurío, 'lige romano, 'lige griégochigó. ");
INSERT INTO tacNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Alué e'wélala balé tabilé galele napurigá regá ujchawa alué osilí. 'Lige alekeri anele alué Pilato: ―‹‹Wa'lula rey ralámuli jurío nuleme», anime ju alué osilí, 'lige ramueka tase najkiae napurigá alanime ujchawa. Regá anime ujchawa 'lina: «Ye rió Wa'lula rey korí ralámuli jurío nuleme.» ");
INSERT INTO tacNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","'Lige Pilátoka anele: ―Napurigá ujchá ne, alarigá rejpímala. ");
INSERT INTO tacNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","'Lige alué sontalo 'ma re'pá gulusichi ujchasa Esusi, 'ma napabule Esusi o'páchala, 'lige chi'wánale naómana neraga alué o'pacha 'lige alué a'bópika nachútale. Naó sontalo nile alué noká. 'Lige ajtílechigó bilé o'pacha we'lí Esusi o'páchala napu re'lé ujchame nile (napu túnika aniame ju yolí ra'íchaga), mo'yériga newárigime nile, tabilé suka newárigime. ");
INSERT INTO tacNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","'Lige alué sontalo anile a'bópika: ―Tabilé chi'wanawa alué we'lí o'pacha, bilé re'gí re'épua napurigá 'la machiboa chieri neyúrira. Alarigá 'la sébali ikile napurigá anile Onorúgame ra'ichálila 'yabé bajchabé rawé, regá anime ra'íchili: «'Ma nachútale ne o'páchala, 'lige bilé re'gí re'ele ne o'páchala méniliga.» Alarigá nokale alué sontalo. ");
INSERT INTO tacNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Esusi eyela, 'lige Esusi i'chilala, 'lige María napu Kleopasi 'yula nile, 'lige Maríachigó napu Magalena anilichi bejtégame nile, suwábaga alué ralámuli alé jale, alé a'bé napu Esusi chujkule gulusichi. ");
INSERT INTO tacNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Esusi etele alué bo'né eyela 'lige bilé alué Esusi gompaniérola 'yúriga etélechigó, alué napu Esusi 'we galegá eteme nile. A'lige Esusi anele alué bo'né eyela: ―'La repúpua ka ye rió napurigá mué bo'né ranala neraga. ");
INSERT INTO tacNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","A'lígechigó alué rió anéleru Esúsite: ―'La repúpua ka ye mukí napurigá mué bo'né eyela neraga. A'lige si 'we a'lá repule ye rió 'la napurigá bo'né eyela neraga. ");
INSERT INTO tacNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Esúsika machigá anile napu 'ma sébali oláligo napu aníligo alué Onorúgame ra'ichálila 'yabé bajchabé rawé. A'lige regá anile: ―'We balamu ne. ");
INSERT INTO tacNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Alé a'bé ilile bilé sikolí i'wilí ba'wila 'we cho'kógame ro'árigame. Bilé ba'nasoli sa'nabáchasa alué i'wilí ba'wílate, bilé balichi ujchale alué ba'nasoli, 'lige Esusi chu'álachi owele alué ba'nasoli. ");
INSERT INTO tacNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","'Lige napu'lige Esusi 'ma chunusá alué ba'nasoli regá anile: ―Suwábaga 'ma 'la sébali olá ne. A'lígeko 'ma go'ná rojpóchiga chujkíbale mo'ola, 'ma mukule. ");
INSERT INTO tacNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Bilé rawé rapakónala nile napu newame nile wa'lú piesta Páskua anilime 'lige sawalachi nímili nile resíbulichi rawé, 'lige alué ralámuli jurío tabilé najkile napurigá bakiánika rió gulusichi ejtebímala resíbulichi rawé. Alekeri alué ralámuli anele Pilato: ―'Ma gajponawa alué bakiá rió gulusichi uchúkame gajsila napurigá abé a'lá yati suwirálikó. Abiena najkílechigó alué ralámuli napurigá 'ma re'kabuwa alué ralámuli alé gulusichi uchúkame. ");
INSERT INTO tacNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","A'lige alué sontalo simíbale alué bakiá rió gajsila gajponamia. Bajchá bilé rió gajsila gajpónale. 'Lige uché bilé rió gajsila gajpónale. ");
INSERT INTO tacNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Alué sontalo machile 'ma mukugá chujkúligo alué Esusi, alekeri tabilé gajponáliru Esusi gajsila. ");
INSERT INTO tacNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Abirigáchigo bilé sontalo bilé selá o'kame nílekó 'lige ejchele aluete a'chigachi re'lege, 'lige Esusi wa'lú elénale aminami ba'wítiri ma'chínalechigó. ");
INSERT INTO tacNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Alué rió Esusi oyérame suwábaga ye etele, 'lige a'kinana ruwí napurigá 'la machimela 'emi alakíligo. Alué ra'íchali napu ruwile ye rió 'la bijchiá ju. Alué bo'né 'la machí 'la bijchiga ra'íchiligo napurigá 'emi 'la bijchígimala. ");
INSERT INTO tacNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Alakile ye suwábaga napurigá 'la sébali nimia napurigá anile Onorúgame 'ya bajchabé rawé. Regá anile: «Tabilé 'wesi o'chila gajponáwili ju.» ");
INSERT INTO tacNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Alué Onorúgame ra'ichálila anílechigó 'ya bajchabé rawé: «'Emi etémala alué napu ejchéliru selate.» ");
INSERT INTO tacNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","'Lige 'ma suwábaga alakisá, bilé rió José anilime Arimatea anilichi bejtégame, lisensia tánale Pilato alué Esusi o'tomeo. Joseka bilé Esusi oyérame nile, tasiné ruwile Esusi oyérame ko alué e'wélala jurío majaga. Pilátoka 'la lisensia 'yale, a'lígeko alué rió José anilime o'tole Esusi 'ma mukúgame. ");
INSERT INTO tacNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Abiena enálechigó alué Nikoremio anilime, alué napu 'yabé siné rukó simile Esusi 'yuga ra'ichamia. Alué rió Nikoremio baisá makué kilo niraga o'ká enale gajsalá yowí, oká na'lórigame, alué Esusi mukúgame ujchemia. Alué okaná chojkégame gajsalá «mira» anilime nile bilé 'lige «áloe» anilime nile uché bilé gajsalá. ");
INSERT INTO tacNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Alué oká rió kabile Esusi we'lí chinite 'lige alué gajsalá na'lórigame ajchigá alégana chinichi. Alanokale alué oká rió napurigá nokame nile alué ralámuli jurío bilé mukúgame gatemia. ");
INSERT INTO tacNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Alé a'bé napu mukule Esusi ajaré iwisí rakeme jale 'lige alé a'bé ilile bilé resó newárigime napurigá bilé mukúgame rekawa. Tabilé 'wesi mukúgame rekárigame nile alé ewachi. ");
INSERT INTO tacNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Alé rekáliru alué Esusi 'la a'bé níligame, 'lige 'ma chojkiámichi nile resíbilichi napu'lige suwábaga ralámuli jurío resíbame nile. Resíbilichika yanchi alí chojkime nile rapagachi 'lige sawalachi alí suwéname nile. ");
INSERT INTO tacNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Romíkichi be'á ta'chó che'lachi, María, napu Magalena anilichi bejtégame nile, simile alé napu rekáliru alué Esusi mukúgame. Alé sébaga etele alué wa'lú rejté 'ma se'wí ajtigó napu ajchárigame nile alé resó 'yériga. ");
INSERT INTO tacNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ku 'we 'maga simile alé napu asale Simoni Pegro 'lige alué uché bilé rió napu Esusi 'we galeme nile, 'lige regá anele: ―'Ma tabilé i'té alué mukúgame napu alé resochí rekárige, tabilé machí ne koche bo'igó. ");
INSERT INTO tacNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","'Lige Pegro 'lige uché bilé rió simíbale alé resochí napu rekáliru Esusi. ");
INSERT INTO tacNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Okánika rió 'we a'wágame júmaka simíbale. Pégroka ta'mé 'we sajpume nile, alué uché bilé rió bajchá sébale alé napu Esusi bo'ílige. ");
INSERT INTO tacNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","'Lige alué rió pachami resochí e'nénale. 'Lige pe alué chiní rosákamecho etele alemi 'lútiga mochigo, tabiléchigo bajkíleko pachami resochí. ");
INSERT INTO tacNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","'Lige sébale Simoni Pegro. Alueka bajkile pachami resochí, abiena pe chiní rosákamecho etele. ");
INSERT INTO tacNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","'Lige abiena etele Pegro alué uché bilé chiní napu Esusi mo'ola buléliru. 'La suériga ro'mináriga ajtile waná. ");
INSERT INTO tacNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","'Lige alué uché bilé rió bajkile 'lige aluéchigó tabilé asemi etele alué mukúgame, a'lige 'la bijchígile napu anílige María. ");
INSERT INTO tacNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tabilé 'cho 'la námale alué ralámuli napu anílige Onorúgame 'yabé bajchabé rawé Esusi ku ajanamio. ");
INSERT INTO tacNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","'Lige alué oká rió napu Esusi oyérame nile ku galírale simíbale. ");
INSERT INTO tacNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Uchéchigo siné sébale María alé resochí 'lige alé resochí ma'chika asíbale nalá. Bijí nalaka pachami e'nénale, ");
INSERT INTO tacNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","'Lige oká santo ánjeli etele pachami mochigo napu Esusi rekárilige. Bilé napu Esusi mo'ega bo'ile, alé ajtile alué santo ánjeli, 'lige bilé napu ronega bo'ile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","'Lige alué santo ánjelika rukele alué María: ―Mué mukí, ¿chonigá nalá mué? Maríaka regá nejele: ―'Ma pecha néréko Esusi jena napu rekárilige, 'lige tabilé machí ne kochiena bo'igó. ");
INSERT INTO tacNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Regá anisá 'ma pe'tá guwana simile 'ma ku simea, 'lige alé etele bilé rió. Tabilé machile Esusi níligo. ");
INSERT INTO tacNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","'Lige Esusi regá anele: ―Mué mukí, ¿chonagá nalá mué? ¿Chieri 'yaga eyena mué? 'Lige María alué repume mayega, regá anele: ―Mué rió, mué 'sísaká alué Esusi o'toa, ruyewa ne koche bo'igó, 'lige ne bo'né 'símala ku jena a'pá. ");
INSERT INTO tacNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","'Lige Esúsika regá anele: ―¡María! 'Lige Maríaka gu'lile napu Esusi ilile, 'lige regá anele jurío ra'ichálila ra'íchaga: ―¡Raboni! (Raboni aniá ka pe benírame anióríle alué a'bopi ralámuli jurío.) ");
INSERT INTO tacNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","'Liko regá anele Esusi: ―Ta'chó cha'piboa ne, tabilé 'cho seba ne napu Onorúgame ajtí, 'lige anewa ka alué ne gompaniérola ralámuli, ne 'ma simeo napu ajtí Onorúgame napu ne O'nola ju 'lige alué ne oyérame O'nola júchigó, alué Onorúgame napu ne'chí tebume ju 'lige abiena tebume ju 'emi. ");
INSERT INTO tacNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Alué María napu Magalena anilichi bejtégame nile yati simile alué Esusi oyérame ruyemia alué Wa'lula Esusi etéligo 'lige ruyémiachigó napu aníligo Esusi alé napu María etele. ");
INSERT INTO tacNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","A'lige 'ma abé alí romíkichi, suwábaga Esusi oyérame napuíka mochile bilena galírale 'we 'la 'yériga. 'We majá mochile e'wélala jurío sirá mayega. A'lige alé ma'chiná ilíbale Esusi pe yati neraga, suwábaga alué ralámuli mochígichi ilíbale, 'lige anele: ―'La sébali ralámuli niwa 'emi Onorúgame 'yuga 'nátame. ");
INSERT INTO tacNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","'Ma alanisá, bo'né Esusi getúrile alué ralámuli bo'né sekala napu klabo jale alé gulusichi chujkúgichi, 'lige napu ejchéliru alué selate. Suwábaga alué ralámuli 'we ra'sálále alué Wa'lula etega. ");
INSERT INTO tacNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","'Lige Esusi uchéchigo anele: ―'La sébali ralámuli niwa 'emi, bi'lepi 'nátili 'nátame niwa pe Onorúgamecho 'yuga. Onorúgame ne'chí júlale 'lige neka 'emi nuléguru. ");
INSERT INTO tacNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Esúsika buchigá anele alué ralámuli: ―Naresi Onorúgame Alawala. ");
INSERT INTO tacNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","'Emi e'kásaká alué ralámuli cha nokame, Onorúgame chigó 'la e'kámala alué ralámuli. 'Emi tabilé e'kásaká alué ralámuli cha nokame, Onorúgamechigó tabilé e'kámala alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Alé nawachi Esusi alué oyérame 'yuga, tabilé asale Romasi anilime rió napu nile bilé alué makué oká Esusi oyéramechigó. Romásika «Kuate» anélime nile. ");
INSERT INTO tacNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","'Ma i'libeko kulí ruyele alué ralámuli alué Romasi etesa, regá anele: ―Eteru ramué alué Wa'lula Esusi. 'Ma tabilé mukugá bo'í. 'Lige Romasi anile: ―Tabilé etésaká ne alué Esusi sekala napu klábote ulunáluru, 'lige tabilé nochasa ne alé a'chigachi re'lebege, a'lígeko tabilé bijchígamala ne Esusi ko alué rió. ");
INSERT INTO tacNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","'Ma bilé tarali kachi, alué ralámuli Esusi oyérame bilena galírale mochile, 'lige Romasi 'la ajtile a'lige rawé. 'We a'lá 'yériga mochile yochi, 'lige Esusi alé ma'chiná ilíbale tabilé i'puga yochi, alé nasipa ilíbale alué ralámuli mochígichi. 'Lige regá anigá repórale regá anigá: ―'La sébali ralámuli niwa 'emi Onorúgame 'yuga 'nátame. ");
INSERT INTO tacNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","'Lige regá anele Romasi olagá: ―Ne sekala e'nébá, makúsate nochá, 'lige sekate nochábá napu ejcheru ne selate 'lige 'la bijchígiwa pe abalué ko ne. 'La bijchígiwa uchéchigo ku ajagá ajtigó ne. ");
INSERT INTO tacNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","'Lige Romásika regá anele: ―¡Mué ju Wa'lula ne nuleme 'lige aminami Onorúgamechigó! ");
INSERT INTO tacNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","A'lige Esusi regá anele: ―Mué 'ma eté ne'chí, alekeri 'la bijchígiwa ku ajagá ajtigó ne. Uché jaré ralámuli 'la bijchígimala ku ajagá ajtigó ne rekó tabilé etee ne'chí. 'Lige alué ralámuli 'we a'lá narémala napu nejí Onorúgame. 'We a'lá ganíliga mochímala rekó tabilé etee ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Esusi bijí alué bo'né oyérame 'yuga asagá, pe bo'né 'nátaga e'karúgame semáriga newale napu tabilé 'wesi ralámuli gayéname ju a'chigóriga noká. Tabilé osá ne suwábaga jena líbrochi napu 'sile Esusi. ");
INSERT INTO tacNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Napu osá ne ye jena líbrochi bilé ra'íchali ju napurigá 'la bijchígamala 'emi Esusi ko alué Kristo, napu julárigame nile Onorúgamete rewagáchika, alué Onorúgame Inolá. 'Lige 'emi 'la bijchígiga mochisa ye rió Esusi Onorúgame náboligo, a'lige 'la nareka mochímala 'emi iwérali napurigá 'la ganíliga ejperélamala 'emi jena wijchimoba 'lige alarigá simámala 'emi 'pa rewagachi ejperélimia. ");
INSERT INTO tacNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Abé a'kinana Esusi ma'chínale alé napu alué bo'né gompaniérola mochile alé wa'lú ba'wí manígichi alé napu Tibériasi anilichi nile napu Galilea anilime nílechigó. ");
INSERT INTO tacNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Napuíka mochile Simoni Pegro, 'lige Romasi napu «Kuate» anélime nile, 'lige Natanaeli napu Kaná anilichi bejtégame nile Galilea ejiro, 'lige oká rió Sebereo anilime rió 'kúchila, 'lige uché jaré oká ralámuli Esusi gompaniérola. ");
INSERT INTO tacNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","'Lige Simoni Pegro anele suwábaga alué ralámuli: ―Ro'chí i'mumia simé olá ne. ―Ramuéchigó simawa mué 'yuga ―anile alué uché jaré ralámuli. 'Lige bilena bárkochi simíbale alué ralámuli, 'lige che'lébale ro'chí i'mua tabiléchigo 'wesi ro'chí ma'chí pale ko. ");
INSERT INTO tacNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","'Ma che'lachi nile 'lige Esusi alé suwé ilíbale, nobi alué bárkochi e'yéname tabiléchigo machile Esusi ko. ");
INSERT INTO tacNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","A'lige regá rukele Esusi alué bárkochi e'yéname: ―'Emi gompaniero, ¿tabilé 'wesi ro'chí boinaru? 'Lige nejele alué ralámuli: ―Tabilé 'wesi. ");
INSERT INTO tacNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","'Lige Esusi regá anele: ―Pasi alué morali alé 'mi wajtoná, a'lige 'la boinámala ro'chí 'emi. Alarigá nokale alué ralámuli, a'lige we'ká ro'chí buyánale alué morálite, 'we bejtégame asíbale 'ma tabilé umébale banisúká o'toa. ");
INSERT INTO tacNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","'Lige alué rió napu Esusi 'we najkílige anele Pegro: ―¡Alué rió ju Wa'lula Esusi! Simoni Pegro akisá Wa'lula ko Esusi, alué bo'né o'páchala umuchipo bulisá, ba'wichí o'pochile. ");
INSERT INTO tacNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","A'kega sébale alé suwé napu Esusi ilile. Uché jaré ralámulika alué bárkochi mochiga sébale, alué morali o'ká sébale baníriga bochí ajchagá ro'chí. Alé napu ro'chí wejale, bilé siento metro niraga nile sebamia alé ba'wichí suwé. ");
INSERT INTO tacNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Bárkochi e'tigisa 'yénale alué ralámuli, 'lige etele rajá iligó 'lige aminami etele bilé ro'chí alé amoba sawichi bo'ígame 'lige abiena etélechigó bilé baní. ");
INSERT INTO tacNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Esusi regá anele: ―Jeka a'pasi pe'kabi ro'chí alué napu pe kulipi wejá 'emi. ");
INSERT INTO tacNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","'Lige Simoni Pegro 'mole alé u'tá bárkochi 'lige wijchí baníriga o'tole a'bemi suwé alué morali bochí ajchigá ro'chí. Bilé siento malígisa makué na bakiá ro'chí bi'tile alé morálichi. 'La we'ká ro'chí kachi tabilé chi'wale alué morali. ");
INSERT INTO tacNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","'Lige Esusi regá anele: ―Jeka simasi, 'ma go'poa. Suwábaga alué ralámuli mayele ye rió Wa'lula Esusi ko, nobi majale ko rukea pala 'la Wa'lula Esusi ko. ");
INSERT INTO tacNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","'Lige Esusi abé na'ibeta ilíbale, 'lige alué baní 'wile 'lige nachútale suwábaga ralámuli. Alué ro'chí abiena nachútale. ");
INSERT INTO tacNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","A'lígesí 'ma baisá nile napu'lige alué ralámuli ku etea Esusi 'ma ku ajánasa. ");
INSERT INTO tacNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","'Ma go'sá go'ame, Esúsika Simoni Pegro 'yuga ra'íchale, 'lige regá anele: ―Simoni Pegro, Juani inolá, ¿'we a'lá galegá eté mué ne'chí me'tigá ye ralámuli 'lige tábiri? 'Lige Simoni Pégroka regá anele: ―Alarigá ju. Mué 'la machí, ramué okaka 'we a'lá gompaniero niru. 'Lige Esusi regá anele: ―'Liko 'we a'lá semáriga 'yawa go'ame ne bujkula bo'á. ");
INSERT INTO tacNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","'Lige uchéchigo siné rukele Esusi: ―Simoni Pegro, Juani inolá, ¿'we 'la galegá eté mué ne'chí? Simoni Pégroka regá nejele: ―Alarigá ju, mué 'we a'lá machí 'we a'lá gompaniero nírigo. 'Lige Esusi regá anele: ―'We a'lá repúpua ne bukula bo'á. ");
INSERT INTO tacNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","'Lige 'ma baisá niraga rukele Esusi: ―Simoni Pegro, Juani inolá, ¿'we a'lá gompaniero niru ramué? 'Lige Simoni Pégroka 'we seweka asíbale uchéchigo alarigá rukésiga. A'lige regá nejele Simoni Pegro 'we seweka: ―Esusi mué 'la machí suwábaga. Mué 'la sébali machí 'we a'lá gompaniero nírigo. Esusi regá anele: ―'We a'lá semáriga 'yawa go'ame ne bukula bo'á. ");
INSERT INTO tacNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","'La bijchiá aní ne. Abijí re'malí ka mué bo'né o'pochátime kéturu ichúrimi einamia, napu'lige mué o'chérame ka sekala wajchínaga o'pochátiriwa mué 'lige 'ma o'toboa mué rekó tabilé siminalie. ");
INSERT INTO tacNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ye ra'íchalika pe ruwime nile churigá mukumeo Simoni Pegro abé a'kinana bamí, 'lige Simoni Pegro mukusá we'ká ralámuli 'we a'lá niramio Onorúgame. Esusi regá anele: ―¡Nabágó! ");
INSERT INTO tacNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Simoni Pégroka gu'lile 'lige etele alué rió enágichi, alué rió napu Esusi 'we galeme nílige, alué rió napu a'bé asale go'yá Esusi 'yuga napu'lige napuíka go'álige bijí ta'chó cha'piá Esusi, alué napu regá rukele: «¿Chieri ju alué napu mué sayega ilibámala?» ");
INSERT INTO tacNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Simoni Pégroka etesa alué rió enágichi, regá rukele alué Esusi: ―Mué Wa'lula Esusi, ¿alué rioka chukimeli ju? ");
INSERT INTO tacNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Esúsika regá nejele: ―Ne bo'né a'résaká napurigá tabilé mukumela ye rió napusí ne ku bo'né nawasa, ¿tachiri chureko mué si? Mueka pe iligá ne'chí 'yuga enáwaguru. ");
INSERT INTO tacNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Alekeri chojkile a'bopi ra'icha alué we'ká ralámuli Esusi oyérame, alué ra'íchali napu regá anime ju «tabilé mukumeli ju ye rió», nobi Esúsika tabiléchigo alarigá anime ke anile. Pe anile: «Ne bo'né nerásaká napurigá tabilé mukumela ye rió napusí ne ku bo'né nawasa, ¿tachiri chureko mué si?» pe regá anile. ");
INSERT INTO tacNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Alué bo'né rió anile ye ra'íchili ruyá 'lige bilé apélichi osale. 'Lige alué rió ne ke. 'La sébali machirú 'la bijchiá ko ye ra'íchali. ");
INSERT INTO tacNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Abechigó we'ká e'karú 'sile Esusi. Suwábaga osisuga ka apélichi, tabilé asemi nerúlimaleké gawichí bilena napu mochiawa alué apeli ra'íchali newárigime, 'ma bochímikuru, asíriga we'ká nímiliké. Pe ikipi ra'íchali ruimé nébá. Wa'lú cheliérabá.");
INSERT INTO tacNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Ne Lukasi 'we 'ya nábolige uché bilé osilí apélichi ujchachárigame mué ruigá napurigá 'sile Esukristo bijí jena wijchimoba asagá ta'chó simiá alé 'pa rewagachi. 'We a'lá benírale rejcholi alué napu bo'né Esusi owile. 'Lige Onorúgame Alawala gu'írile alué Esusi napurigá 'la 'we semáriga benírimala. Alué Esusi mukusá, ku ajánale. ");
INSERT INTO tacNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","'Lige ku ajánisa Esusi, ra'íchale alué makué bilé rió 'yuga, oká liá rawé 'yuga eyénale napurigá alué ralámuli 'la machimela 'la bijchiá ajágame ko alué bo'né Esusi. 'Lige abiena ruyele Esusi alué ralámuli churigá nulame ko Onorúgame jena wijchimoba. ");
INSERT INTO tacNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Bilé rawé napu'lige go'yá mochílige, Esusi anele alué makué bilé rió: ―Tase simawa 'emi ralámuli jena wa'lú we'ká riógachi Rusaleni anilichi, 'emi ralámuli 'la buwigá mochiwa Onorúgame Alawala. Onorúgame bo'né 'la aniéturu 'ya napurigá nejimio bo'né alawala, julámorié alé 'pákana rewagáchikana, napurigá 'we semáriga gu'írimala 'emi ralámuli jami ichúrimi e'yénachi alué rejcholi ruigá. 'Lige alué ra'íchali 'ma ruyéturu ne 'emi 'ya. ");
INSERT INTO tacNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","'Yako, Juani anilime rió nulea ilime nile napurigá mo'imela alé wa'lú ba'wichí alué ralámuli napurigá machiboa Onorúgame oyérame ko, alarigá rewarame nile alué Juani. Pe u'kabi rawé kachi Onorúgame rewarámili ju 'emi ralámuli bo'né alawálate ―alarigá anile alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","'Lige alé ajtígachi, rukele alué ralámuli alué Esusi, anele: ―Mué Wa'lula, ¿jípeko mué e'wélala niraga mochiámala ramué ralámuli israelita napurigá nílige 'ya napurigá tabilé piónila niraga mochímala ramué? ―alarigá rukéleke'é alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","'Lige Esúsika anele: ―Onorúgame tabilé elá napurigá 'emi machimela alué 'nátili alarigá nimio, bi'neli machí Onorúgame, alueka wa'lula kame, bo'né 'we 'la sébali machí. ");
INSERT INTO tacNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","'Émika 'ma pe'wé narémala Onorúgame Alawala. Napu'lige naresa 'emi, a'liko 'we 'la sébali a'wágame alawega mochímala 'emi. 'Liko 'la ichúrimi e'yénamala 'emi. 'Émika ruyémala ralámuli chieri ka ne, napurigá 'sile ne, napu benírilige ne. 'Emi ruyémala ralámuli jena we'ká riógichi Rusaleni ejperégame, 'lige alué ralámuli ejiro Jurea mochígame, alé ejiro Samaria mochígame abiénachigó. 'Lige 'emi ruyémala bochígimi gawichí ejperégame ―anele. ");
INSERT INTO tacNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","'Lige suwénasa ra'icha, Esusi rewagachi simile. Suwábaga ralámuli etele napu ekí riólige alé, Esusi 'párimi bokuí kíbachi nolírilimi. Alésíko 'ma tabilé etéleke'é ralámuli rekó 'pari e'negá jage. ");
INSERT INTO tacNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ralámuli 'pari e'negá jágichi, sébale oká santo ánjeli, o'tosákame o'páchigime. ");
INSERT INTO tacNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Anele: ―'Emi ralámuli Galilea ejperégame, tase e'negá jawa o'wétiri. Esúsika 'ma ku 'pa rewagachi simile, pe nujubapi ku nolínamaleké pe abalieri napuyeri kíbige. ");
INSERT INTO tacNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","'Lige alué ralámuli suwábaga, 'légana simíbale alé rabó mochige. (Alé rabó Olibo anilichi alé yéniga simile Esusi rewagachi.) A'lige ku Rusaleni simíbale alué ralámuli, pe a'bé nile. ");
INSERT INTO tacNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Alé sebásaká, simíbale 'miná bilena galírale osámana ilígame galí. Alé sebásaká jímole alé napu che'lébame nile. Alé mochile we'ká rió napu nile Pegro, Santiago, Juani, Antresi, Belipe, Romasi, Bartolomé, Mateo, uché bilé Santiago napu Alipeo inolá nile, 'lige Simoni napu geriyero nile, 'lige Jurasi napu Santiago inolá nile. ");
INSERT INTO tacNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Uché jaré ralámuli abiena mochílechigó alé. Alué Esusi nasípasi bonila 'lige nasípasi waíla, 'lige Esusi eyela María abiena asálechigó alé, uché jaré umugí abiena we'ká mochile alé. Nabí rawé napuíle ralámuli alé galírale cheliera 'yamia Onorúgame 'lige 'we a'lá 'nátaga tánimia Onorúgame. ");
INSERT INTO tacNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Alé napuíle ralámuli bilé siento rasígame miná bilé liátiri mayelia. Suwábaga alué ralámuli Esukristo oyérame nile. 'Lige bilé rawé alé nasipa napu suwábaga alué ralámuli napuíka jale alé iligá alué Pegro, 'lige anele: ");
INSERT INTO tacNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―'Emi Esukristo oyérame napurigá ne, 'yako Onorúgame Alawala gu'írale osachi alué 'ya bejtégame Rabí anilime rió, osálekuru napurigá 'símala alué rió Jurasi. Osálekuru 'we 'ya Jurasi gu'írimili níligo cha'piachi Esusi alué Esusi saílate. A'chigóriga napurigá osálige alarigá nímili nile a'lige a'kinana. ");
INSERT INTO tacNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Alué Jurasi ramué gompaniérola nile 'yako, ramué 'yuga nóchame nile. ");
INSERT INTO tacNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","'Lige Jurasi gu'írile Esusi saíla napurigá cha'pimela Esusi. Alué Esusi saíla najtétale we'ká enomí alué Jurasi napurigá nejkúrimala. A'kinana ojale bo'nepi alué rió Jurasi bilé rojá atuálachi 'lige alé chujkugá mukule. 'Lige alé chujkugá, 'ma wijchile, 'ma a'tale rojpala, 'lige ma'chínale siwala. 'Lige alué ralámuli e'wélala jurío ralale gawí alué Jurasi enomílate 'ma mukusá alué rió. ");
INSERT INTO tacNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","A'lige alué ralámuli Rusaleni ejperégame machisá mukúligo alué rió Jurasi, 'lige alué gawí Akelama anilime rewá ujchele napu elá aniame ju. ");
INSERT INTO tacNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Alué Rabí osale bilé ra'íchili 'we 'ya ta'chó ochérachi Jurasi: Ta'wesi bejtégame nímala alé gawichí. Alué gawika nabí bi'neli ilimela. Abiena osale alué Rabí: Alué nóchili napu iní alué rió, uché bilé rió 'yáwagó. Anigá osale alué Rabí 'ya a'lige. ");
INSERT INTO tacNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","› Alekeri uché bilé rió 'yáwa'é alué nóchali. Bilé rió napu 'la etele Juani rewarachi ba'wite, 'lige napu alué Wa'lula Esusi 'yuga eyénilige, 'lige napu 'la etele alué Esusi rewagachi simichi, alué rió 'yawa nóchali. Alué rioka 'la ruyémala uché jaré ralámuli alarigá ku ajánaligo alué Esusi. ");
INSERT INTO tacNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","'Lige wanápale oká rió. Matíasi anilime nile bilé. Uché bilé José napu Barsabasi anilime nile. Abiena Justo anilime nile. Bakiá rewégame nile alué rió. ");
INSERT INTO tacNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","A'lige alué ralámuli tániga nejkúrali Onorúgame, anele: ―Mué Onorúgame, mué 'la sébali machí alarigá 'nátame ko ralámuli. ¿Chieri 'nalina 'yawa alué nóchali, ");
INSERT INTO tacNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","alué nóchali napu Jurasi a'rélige? 'Yako alué Esusi 'yálige alué nóchali, 'lige alué Jurasi tabilé 'la 'nátale, 'ma simile napu simeli nile ―alarigá anele. ");
INSERT INTO tacNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","A'lige u'kuchí rejté 'luka re'ele. ―¿Chieri meta? ―anigá nokale. Alué Matíasi mele. 'Lige 'yáleru nóchali napu Jurasi nila nílige. Alésíko kúchigo 'ma 'la makué oká rió nile uchéchigo. ");
INSERT INTO tacNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Napu'lige sébale piesta ri'ligó 'wílichi (napu Pentekostesi anilime nile yolí ra'íchaga), napuíle suwábaga napu ekí alué Esukristo oyérame nile. ");
INSERT INTO tacNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","'Lige alé mochiga akele napurigá iwégame ekame. Alarigá aníchane 'pa rewagáchikana. Sébale 'lige alé galírale napu mochílige alué ralámuli. Bochígimi alé pachami bajkile alué napurigá eká anime 'pákana. ");
INSERT INTO tacNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","'Lige napuyeri na'í alieri re'kínale alé mo'ochíkana a'pili ralámuli mo'ólachi, napurigá na'í rajame cha'mélome niraga. ");
INSERT INTO tacNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Pe Onorúgame Alawala kéréle alué na'í. Alarigá narele Onorúgame Alawala alué Esukristo oyérame. A'lige o'wínale ra'icha we'ká se'wináriga ra'icha, a'bópika tabilé siné benile alué ra'íchali. Onorúgame Alawala gu'írile. Sineko tabilé alarigá ra'íchame nile. ");
INSERT INTO tacNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","We'ká ralámuli jurío simíbale Rusaleni anilichi piesta olamia, ichúrimi mochígame ralámuli jsile alé. 'Nátale piesta newalime, alarigá nakió mayele Onorúgame. 'We a'lá oyérame nile Onorúgame alué ralámuli. Ra'íchale we'ká ra'íchili se'wináriga. Onorúgame Alawala gu'írile alué ralámuli Esukristo oyérame napurigá 'la gainámala ra'icha se'winátiri ra'íchali napu ra'íchame nile alué ichúrimi e'megá mochígame ralámuli napu sébale alé. ");
INSERT INTO tacNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Napu'lige akisá alué ichúrimi mochígame, we'ká napuíle ralámuli alé. 'We 'nata jale. Anile: ");
INSERT INTO tacNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","―¿Churigá 'la alarigá ra'íchabaché alué ralámuli Esukristo oyérame? Pe Galiléachi ejperégame káwé alué ralámuli, tabilé ramué ejperélachi mochígame káwé alué ralámuli. ");
INSERT INTO tacNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Aka abalieri ra'íchame júpaché? ¿Churigá júpaché? Ramueka wanáchigo ejperégame niru. ");
INSERT INTO tacNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Jaré Partia ejperégame ralámuli ju ramué. Uché jaré chéchigo bilena ejperégame Melia anilichi ejperégame ju jaré. Uché jaré Elami ejperégame ju. Uché jaré Jurea ejperégame ju. Uché jaré Mesopotamia ejperégame ju. Uché jaré Kaparosia ejperégame ju. Uché jaré Ponto ejperégame ju. Uché jaré Asia ejperégame ju. ");
INSERT INTO tacNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Uché jaré Pirigia ejperégame ju. Uché jaré Pampilia ejperégame ju. Uché jaré Ejipto ejperégame ju. Uché jaré Libia anilichi ejperégame ju, pe a'bé ju Sirene anilichi. Jaré Roma anilichi mochígame ju. ");
INSERT INTO tacNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Jaré ralámuli jurío ju. Uché jaré tabilé jurío ju, 'ma jurío gayénale jípeko. Abiena mochí ralámuli Kreta ejperégame, alé Arabia ejperégame abiénachigó. 'We 'la ra'íchame ju alué ralámuli Esukristo oyérame ramué ra'ichálila, we'ká se'wináriga ra'íchali. Ra'íchame ju napurigá Onorúgame newale e'karúgame 'we semátiri ―alarigá anile. ");
INSERT INTO tacNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Suwábaga alé jale e'negá. Tabilé machiá alarigá ko. Jaré rukele machináliga: ―¿Chonigá alieri ra'icháliché? ―anile. ");
INSERT INTO tacNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Uché jaré gawélele. Anile: ―Wa'lú bajile alué i'wilí ('uba) ba'wila rekútame nokogá aniá ―anile. ");
INSERT INTO tacNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","'Lige Pegro, uché jaré makué bilé rió napu Esusi 'yálige nóchali, alué suwábaga o'weti jásele, e'wele ra'íchaga anele Pegro alué ralámuli napu napuíle alé: ―'Emi Jurea ejperégame, suwábaga ralámuli napu ekí mochí jena Rusaleni ejperégame abiénachigó, 'we 'la gepúsigobá ne ra'ichálila. ");
INSERT INTO tacNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tabilé tégili niru ramué, pecha bajilia. 'We be'á ju bijí. ");
INSERT INTO tacNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","'We 'yako osale bilé rió napu ruwime nile napu anele Onorúgame, Joeli anilime. Osale napu ruyele Onorúgame. Onorúgame ruyele alué rió churigá nimio jipe. Anele Onorúgame: ");
INSERT INTO tacNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Napu'lige gawí amulí gajuchi, a'lige julámala ne ne Alawala. Napu'lige naresa 'emi 'kúchila ne Alawala, a'lige alueka ra'ichámala ne ra'ichálila. Ne Alawálate etérimala alué ejtemali 'lige umugí i'wé napurigá we'ká tábiri etémala. Ne Alawala gu'írimala alué o'chérame napurigá remúmala ne'chí. ");
INSERT INTO tacNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Alué ralámuli napu ekí ne'chí 'yuga nóchame ju, ne 'yámala ne Alawala. A'liko 'la ruwimela napurigá aní ne. ");
INSERT INTO tacNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","'We e'karúriga 'símala rewagá. Rayénali mukumela. Mechá sejtákame nílimala napuyeri elá. Jena wijchimoba we'ká e'karúriga 'símalachigó. Pe neka 'la gainámala alarigá nocha. 'We nerúmala elá, na'ítiri, molítiri. Napu'lige 'ma simarsa alué we'ká e'karúgame, a'lige nawámala Wa'lula Onorúgame ralámuli gu'írimia. Alué rawé nímala wa'lú rawé 'we semati. ");
INSERT INTO tacNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Napu ekí 'la taní e'kali alué wa'lula Onorúgame, 'liko 'la buyásamala alué ralámuli chátiri bowechi e'yéname. Alarigá anele Onorúgame alué Joeli 'we 'ya. ");
INSERT INTO tacNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","