﻿USE sofia;
DROP TABLE IF EXISTS sofia.syls_vpl;
CREATE TABLE syls_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES syls_vpl WRITE;
INSERT INTO syls_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ꠙꠄꠟꠣꠃ ꠀꠟ꠆ꠟꠣꠄ ꠀꠍꠝꠣꠘ ꠀꠞ ꠖꠥꠘꠤꠀ ꠙꠄꠖꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","ꠖꠥꠘꠤꠀꠁ ꠘꠤꠞꠣꠇꠣꠞ ꠀꠞ ꠈꠣꠟꠤ ꠀꠍꠤꠟ, ꠉꠁꠘ ꠙꠣꠘꠤꠞ ꠃꠙꠞꠦ ꠙꠥꠞꠣ ꠀꠘ꠆ꠖꠣꠁꠞ ꠀꠍꠤꠟ। ꠀꠟ꠆ꠟꠣꠞ ꠞꠥꠢꠥ ꠄꠞ ꠃꠙꠞꠦ ꠌꠟꠣꠌꠟ ꠇꠞꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","ꠛꠣꠖꠦ ꠀꠟ꠆ꠟꠣꠄ ꠚꠞꠝꠣꠁꠟꠣ ꠚꠞ ꠅꠃꠇ, ꠀꠞ ꠚꠞ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","ꠀꠟ꠆ꠟꠣꠄ ꠖꠦꠈꠟꠣ ꠚꠞ ꠜꠣꠟꠣ। ꠔꠣꠁꠘ ꠀꠘ꠆ꠖꠣꠁꠞ ꠕꠣꠇꠤ ꠚꠞꠞꠦ ꠀꠟꠉꠣ ꠇꠞꠤꠀ ");
INSERT INTO syls_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ꠄꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠖꠤꠘ, ꠀꠞ ꠀꠘ꠆ꠖꠣꠁꠞꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠞꠣꠁꠔ। ꠢꠣꠁꠘ꠆ꠎꠣ ꠉꠦꠟ, ꠛꠤꠀꠘꠅ ꠉꠦꠟ, ꠁꠇꠐꠣ ꠅꠁꠟ ꠙꠄꠟꠣ ꠖꠤꠘ। ");
INSERT INTO syls_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","ꠛꠣꠖꠦ ꠀꠟ꠆ꠟꠣꠄ ꠚꠞꠝꠣꠁꠟꠣ, ꠙꠣꠘꠤꠞ ꠝꠣꠎꠦ ꠉꠥꠝ꠆ꠛꠥꠎꠞ ꠟꠣꠈꠣꠘ ꠚꠣꠇ ꠎꠣꠉꠣ ꠅꠃꠇ, ꠀꠞ ꠙꠣꠘꠤ ꠖꠥꠁ ꠜꠣꠉ ꠅꠁꠎꠣꠃꠇ। ");
INSERT INTO syls_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","ꠀꠞ ꠀꠟ꠆ꠟꠣꠄ ꠚꠣꠇ ꠎꠣꠉꠣ ꠙꠄꠖꠣ ꠇꠞꠤꠀ, ꠔꠟꠞ ꠀꠞ ꠃꠙꠞꠞ ꠙꠣꠘꠤ ꠀꠟꠉꠣ ꠇꠞꠟꠣ। ꠀꠞ ꠅꠃꠟꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","ꠀꠟ꠆ꠟꠣꠄ ꠉꠥꠝ꠆ꠛꠥꠎꠞ ꠟꠣꠈꠣꠘ ꠎꠦ ꠎꠣꠉꠣ ꠛꠣꠘꠣꠁꠟꠣ, ꠔꠣꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠀꠍꠝꠣꠘ। ꠢꠣꠁꠘ꠆ꠎꠣ ꠉꠦꠟ, ꠛꠤꠀꠘꠅ ꠉꠦꠟ, ꠁꠇꠐꠣ ꠅꠁꠟ ꠖꠥꠁ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ। ");
INSERT INTO syls_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","ꠄꠞꠛꠣꠖꠦ ꠀꠟ꠆ꠟꠣꠄ ꠚꠞꠝꠣꠁꠟꠣ, ꠀꠍꠝꠣꠘꠞ ꠔꠟꠞ ꠙꠣꠘꠤ ꠄꠇ ꠎꠣꠉꠣꠔ ꠖꠟꠣ ꠅꠃꠇ, ꠀꠞ ꠢꠥꠇꠘꠣ ꠎꠣꠉꠣ ꠖꠦꠈꠣ ꠎꠣꠃꠇ। ꠀꠞ ꠅꠃꠟꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","ꠀꠟ꠆ꠟꠣꠄ ꠢꠥꠇꠘꠣ ꠎꠣꠉꠣꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠎꠝꠤꠘ ꠀꠞ ꠎꠝꠣꠁꠟ ꠙꠣꠘꠤꠞ ꠘꠣꠝ ꠖꠞꠤꠀ। ꠔꠣꠁꠘ ꠖꠦꠈꠟꠣ ꠁꠔꠣ ꠜꠣꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ꠛꠣꠖꠦ ꠀꠟ꠆ꠟꠣꠄ ꠚꠞꠝꠣꠁꠟꠣ, ꠎꠝꠤꠘꠅ ꠊꠣꠡ ꠚꠟꠃꠇ; ꠀꠞ ꠢꠇꠟ ꠎꠣꠔꠞ ꠛꠤꠌꠀꠟꠣ ꠟꠔꠣ-ꠙꠣꠔꠣ ꠉꠣꠍ-ꠉꠣꠍꠣꠟꠤꠞ ꠎꠘꠝ ꠅꠃꠇ। ꠀꠞ ꠎꠝꠤꠘꠞ ꠃꠙꠞꠦ ꠢꠇꠟ ꠎꠣꠔꠞ ꠚꠟꠞ ꠉꠣꠍꠅ ꠅꠃꠇ, ꠄꠞꠣ ꠘꠤꠎꠞ ꠎꠣꠔꠝꠔ ꠚꠟ ꠗꠞꠛ ꠀꠞ ꠚꠟꠞ ꠝꠣꠎꠦ ꠎꠣꠞꠎꠤꠞ ꠛꠤꠌꠅ ꠕꠣꠇꠛ। ꠀꠞ ꠅꠃꠟꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ꠎꠝꠤꠘꠅ ꠊꠣꠡ ꠚꠟꠤꠟ, ꠢꠇꠟ ꠎꠣꠔꠞ ꠛꠤꠌꠀꠟꠣ ꠟꠔꠣ-ꠙꠣꠔꠣ ꠉꠣꠍ-ꠛꠤꠞꠤꠇ ꠎꠘꠝꠤꠟ। ꠎꠝꠤꠘꠞ ꠃꠙꠞꠦ ꠢꠇꠟ ꠎꠣꠔꠞ ꠚꠟꠞ ꠉꠣꠍ ꠅꠁꠟ ꠎꠦꠔꠣꠄ ꠎꠣꠞꠎꠤꠞ ꠎꠣꠔꠝꠔ ꠚꠟ ꠗꠞꠦ, ꠢꠤ ꠚꠟꠞ ꠝꠣꠎꠦ ꠎꠣꠞꠎꠤꠞ ꠛꠤꠌꠅ ꠀꠍꠦ। ꠀꠟ꠆ꠟꠣꠄ ꠖꠦꠈꠟꠣ ꠁꠔꠣ ꠜꠣꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","ꠢꠣꠁꠘ꠆ꠎꠣ ꠉꠦꠟ, ꠛꠤꠀꠘꠅ ꠉꠦꠟ, ꠁꠇꠐꠣ ꠅꠁꠟ ꠔꠤꠘ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ। ");
INSERT INTO syls_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","ꠛꠣꠖꠦ ꠀꠟ꠆ꠟꠣꠄ ꠚꠞꠝꠣꠁꠟꠣ, ꠀꠍꠝꠣꠘꠞ ꠝꠣꠎꠦ ꠅꠃꠟꠣ ꠌꠦꠞꠣꠉ ꠅꠇꠟ ꠅꠃꠇ, ꠎꠣꠞꠣ ꠞꠣꠁꠔ ꠕꠣꠇꠤ ꠖꠤꠘꠞꠦ ꠀꠟꠉꠣ ꠇꠞꠦ। ꠁꠔꠣ ꠀꠟꠉꠣ ꠀꠟꠉꠣ ꠖꠤꠘ, ꠛꠍꠞ ꠀꠞ ꠁꠖ-ꠃꠔꠡꠛꠞ ꠘꠤꠡꠣꠘꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ꠀꠍꠝꠣꠘ ꠕꠣꠇꠤ ꠔꠣꠞꠣ ꠖꠥꠘꠤꠀꠁꠞ ꠃꠙꠞꠦ ꠚꠞ ꠖꠤꠛ। ꠅꠃꠟꠣꠃ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","ꠀꠟ꠆ꠟꠣꠄ ꠖꠥꠁꠐꠣ ꠛꠠ ꠌꠦꠞꠣꠉ ꠛꠣꠘꠣꠁꠟꠣ, ꠄꠞꠝꠣꠎꠦ ꠛꠠꠐꠣꠞꠦ ꠖꠤꠘꠞ ꠃꠙꠞꠦ ꠛꠣꠖꠡꠣꠁ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠀꠞ ꠢꠥꠞꠥꠐꠣꠞꠦ ꠞꠣꠁꠔꠞ ꠃꠙꠞꠦ। ꠁꠔꠣ ꠍꠣꠠꠣ ꠔꠣꠁꠘ ꠔꠦꠞꠣ ꠅꠇꠟꠅ ꠙꠄꠖꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","ꠔꠣꠁꠘ ꠄꠞꠣꠞꠦ ꠀꠍꠝꠣꠘꠞ ꠝꠣꠎꠦ ꠛꠅꠀꠁꠟꠣ ꠎꠣꠔꠦ ꠔꠣꠞꠣ ꠖꠥꠘꠤꠀꠁꠔ ꠚꠞ ꠖꠦꠄ। ");
INSERT INTO syls_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ꠄꠞꠣ ꠖꠤꠘ ꠀꠞ ꠞꠣꠁꠔꠞ ꠃꠙꠞꠦ ꠛꠣꠖꠡꠣꠁ ꠇꠞꠦ, ꠀꠘ꠆ꠖꠣꠁꠞ ꠕꠣꠇꠤ ꠚꠞꠞꠦ ꠀꠟꠉꠣ ꠇꠞꠦ। ꠀꠟ꠆ꠟꠣꠄ ꠖꠦꠈꠟꠣ ꠁꠔꠣ ꠜꠣꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","ꠢꠣꠁꠘ꠆ꠎꠣ ꠉꠦꠟ, ꠛꠤꠀꠘꠅ ꠉꠦꠟ, ꠁꠇꠐꠣ ꠅꠁꠟ ꠌꠣꠁꠞ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ। ");
INSERT INTO syls_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","ꠛꠣꠖꠦ ꠀꠟ꠆ꠟꠣꠄ ꠚꠞꠝꠣꠁꠟꠣ, ꠙꠣꠘꠤꠞ ꠝꠣꠎꠦ ꠎꠣꠘꠖꠣꠞ ꠅꠇꠟ ꠙꠣꠟꠦ ꠙꠣꠟꠦ ꠜꠞꠤ ꠎꠣꠃꠇ, ꠀꠞ ꠖꠥꠘꠤꠀꠁꠞ ꠃꠙꠞꠦ ꠀꠍꠝꠣꠘꠞ ꠝꠣꠎꠦ ꠙꠣꠈꠤꠘ ꠃꠠꠃꠇ। ");
INSERT INTO syls_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","ꠀꠞ ꠀꠟ꠆ꠟꠣꠄ ꠖꠞꠤꠀꠞ ꠛꠤꠞꠣꠐ ꠎꠣꠘꠖꠣꠞ ꠅꠇꠟ, ꠀꠞ ꠙꠣꠘꠤꠞ ꠝꠣꠎꠦ ꠙꠣꠟ ꠛꠣꠘ꠆ꠖꠤꠀ ꠊꠥꠞꠞꠣ ꠢꠇꠟ ꠎꠣꠔꠞ ꠎꠣꠘꠖꠣꠞ ꠙꠄꠖꠣ ꠇꠞꠟꠣ, ꠀꠞ ꠢꠇꠟ ꠎꠣꠔꠞ ꠙꠣꠈꠤꠅ ꠙꠄꠖꠣ ꠇꠞꠟꠣ। ꠔꠣꠁꠘ ꠖꠦꠈꠟꠣ ꠁꠔꠣ ꠜꠣꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ꠔꠣꠁꠘ ꠔꠣꠞꠣ ꠢꠇꠟꠞꠦ ꠅꠃ ꠟꠣꠈꠣꠘ ꠛꠞꠇꠔ ꠘꠣꠎꠤꠟ ꠇꠞꠟꠣ, ꠔꠥꠝꠞꠣ ꠚꠟꠀꠟꠣ ꠅꠁꠀ ꠛꠣꠠꠅ ꠀꠞ ꠖꠞꠤꠀꠞ ꠙꠣꠘꠤ ꠜꠞꠤ ꠎꠣꠅ, ꠖꠥꠘꠤꠀꠁꠞ ꠝꠣꠎꠦ ꠙꠣꠈꠤ ꠅꠇꠟꠅ ꠛꠣꠠꠃꠇ। ");
INSERT INTO syls_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","ꠢꠣꠁꠘ꠆ꠎꠣ ꠉꠦꠟ, ꠛꠤꠀꠘꠅ ꠉꠦꠟ, ꠁꠇꠐꠣ ꠅꠁꠟ ꠙꠣꠌ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ। ");
INSERT INTO syls_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","ꠄꠞꠛꠣꠖꠦ ꠀꠟ꠆ꠟꠣꠄ ꠚꠞꠝꠣꠁꠟꠣ, ꠝꠣꠐꠤ ꠕꠣꠇꠤ ꠅꠃꠟꠣ ꠎꠣꠘꠖꠣꠞ ꠅꠃꠇ ꠎꠣꠞꠣꠞ ꠘꠤꠎꠞ ꠎꠣꠔ ꠅꠇꠟꠞꠦ ꠛꠣꠠꠣꠁꠛ, ꠄꠞꠣꠞ ꠝꠣꠎꠦ ꠙꠣꠟꠣ ꠢꠦꠝꠣꠘ, ꠝꠣꠐꠤꠔ ꠌꠟꠞꠣ ꠢꠥꠞꠥ-ꠝꠥꠞꠥ ꠎꠣꠘꠖꠣꠞ ꠀꠞ ꠎꠋꠟꠤ ꠎꠣꠘꠥꠀꠞ ꠅꠇꠟꠅ। ꠅꠃꠟꠣꠃ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","ꠀꠟ꠆ꠟꠣꠄ ꠖꠥꠘꠤꠀꠁꠞ ꠝꠣꠎꠦ ꠢꠇꠟ ꠎꠣꠔꠞ ꠎꠋꠟꠤ ꠎꠣꠘꠥꠀꠞ, ꠙꠣꠟꠣ ꠢꠦꠝꠣꠘ ꠀꠞ ꠝꠣꠐꠤꠞ ꠝꠣꠎꠦ ꠛꠥꠇꠦ ꠌꠟꠞꠣ ꠎꠣꠘꠖꠣꠞ ꠛꠣꠘꠣꠁꠟꠣ। ꠔꠣꠁꠘ ꠖꠦꠈꠟꠣ ꠁꠔꠣ ꠜꠣꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ꠄꠞꠛꠣꠖꠦ ꠀꠟ꠆ꠟꠣꠄ ꠚꠞꠝꠣꠁꠟꠣ, ꠀꠅ ꠀꠝꠞꠣꠞ ꠍꠥꠞꠔꠦ ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠝꠤꠟ ꠞꠣꠈꠤꠀ ꠝꠣꠘꠥꠡ ꠛꠣꠘꠣꠁ। ꠔꠣꠞꠣ ꠖꠞꠤꠀꠞ ꠝꠣꠍ, ꠀꠍꠝꠣꠘꠞ ꠙꠣꠈꠤ, ꠎꠣꠘꠥꠀꠞ, ꠝꠣꠐꠤꠞ ꠝꠣꠎꠦ ꠛꠥꠇꠦ ꠌꠟꠞꠣ ꠎꠣꠘꠖꠣꠞ, ꠀꠞ ꠀꠡ꠆ꠔꠣ ꠖꠥꠘꠤꠀꠁꠞ ꠃꠙꠞꠦ ꠛꠣꠖꠡꠣꠁ ꠇꠞꠃꠇ। ");
INSERT INTO syls_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","ꠔꠣꠁꠘ ꠔꠣꠘ ꠘꠤꠎꠞ ꠍꠥꠞꠔꠦ ꠝꠣꠘꠥꠡ ꠙꠄꠖꠣ ꠇꠞꠟꠣ, ꠄꠇ꠆ꠇꠦꠞꠦ ꠘꠤꠎꠞ ꠝꠔ ꠇꠞꠤ ꠙꠄꠖꠣ ꠇꠞꠟꠣ, ꠙꠄꠖꠣ ꠇꠞꠟꠣ ꠛꠦꠐꠣ ꠀꠞ ꠛꠦꠐꠤ। ");
INSERT INTO syls_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","ꠀꠞ ꠔꠣꠞꠣꠞꠦ ꠛꠞꠇꠔ ꠘꠣꠎꠤꠟ ꠇꠞꠤꠀ ꠇꠁꠟꠣ, ꠔꠥꠝꠤꠔꠣꠁꠘ ꠚꠟꠀꠟꠣ ꠅꠁꠀ ꠛꠣꠠꠤꠀ ꠖꠥꠘꠤꠀꠁ ꠜꠞꠤ ꠎꠣꠅ। ꠖꠥꠘꠤꠀꠁꠞꠦ ꠡꠣꠡꠘ ꠇꠞꠅ, ꠀꠞ ꠖꠞꠤꠀꠞ ꠝꠣꠍ, ꠀꠍꠝꠣꠘꠞ ꠙꠣꠈꠤ, ꠝꠣꠐꠤꠞ ꠃꠙꠞꠦ ꠌꠟꠞꠣ ꠢꠇꠟ ꠎꠣꠘꠖꠣꠞꠞ ꠃꠙꠞꠦ ꠛꠣꠖꠡꠣꠁ ꠇꠞꠅ। ");
INSERT INTO syls_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ꠄꠞꠛꠣꠖꠦ ꠀꠟ꠆ꠟꠣꠄ ꠚꠞꠝꠣꠁꠟꠣ, ꠢꠥꠘꠅ, ꠖꠥꠘꠤꠀꠞ ꠃꠙꠞꠞ ꠢꠇꠟ ꠎꠣꠔꠞ ꠛꠤꠌꠀꠟꠣ ꠉꠣꠍ-ꠛꠤꠞꠤꠇ, ꠀꠞ ꠢꠇꠟ ꠎꠣꠔꠞ ꠚꠟꠞ ꠉꠣꠍ ꠎꠣꠞꠣꠞ ꠘꠤꠎꠞ ꠎꠣꠔꠝꠔ ꠚꠟ ꠗꠞꠦ ꠎꠣꠞ ꠚꠟꠞ ꠝꠣꠎꠦ ꠔꠣꠞꠣꠞ ꠘꠤꠎꠞ ꠛꠤꠌ ꠀꠍꠦ, ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠈꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠖꠤꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","ꠖꠥꠘꠤꠀꠞ ꠙꠞꠔꠦꠇ ꠎꠣꠘꠥꠀꠞ, ꠀꠍꠝꠣꠘꠞ ꠙꠣꠈꠤꠘ, ꠝꠣꠐꠤꠞ ꠝꠣꠎꠦ ꠛꠥꠇꠦ ꠌꠟꠞꠣ ꠎꠣꠘꠖꠣꠞ, ꠁꠔꠣ ꠢꠇ꠆ꠇꠟ ꠎꠣꠘꠖꠣꠞꠞ ꠈꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠀꠝꠤ ꠢꠇꠟ ꠟꠔꠣ-ꠙꠣꠔꠣ ꠀꠞ ꠊꠣꠡ ꠖꠤꠟꠣꠝ। ꠅꠃꠟꠣꠃ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠘ ꠙꠄꠖꠣ ꠇꠞꠣ ꠢꠇꠟꠔꠣ ꠖꠦꠈꠟꠣ, ꠁꠔꠣ ꠢꠇꠟꠔꠣꠃ ꠈꠥꠛ ꠜꠣꠟꠣ ꠅꠁꠍꠦ। ꠢꠣꠁꠘ꠆ꠎꠣ ꠉꠦꠟ, ꠛꠤꠀꠘꠅ ꠉꠦꠟ। ꠁꠇꠐꠣ ꠅꠁꠟ ꠍꠄ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ। ");
INSERT INTO syls_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","ꠅꠃ ꠟꠣꠈꠣꠘ ꠀꠍꠝꠣꠘ-ꠎꠝꠤꠘ ꠀꠞ ꠄꠞ ꠝꠣꠎꠞ ꠢꠇꠟꠔꠣ ꠙꠄꠖꠣ ꠇꠞꠣ ꠡꠦꠡ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ꠀꠟ꠆ꠟꠣꠄ ꠁ ꠢꠇꠟ ꠇꠣꠝ ꠡꠦꠡ ꠇꠞꠤꠀ ꠢꠣꠞꠟꠦ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠀꠞꠣꠝ ꠇꠞꠟꠣ, ꠔꠣꠁꠘ ꠁꠖꠤꠘ ꠀꠞ ꠇꠥꠘ꠆ꠔꠣ ꠙꠄꠖꠣ ꠇꠞꠟꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","ꠅꠃ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘꠞꠦ ꠛꠞꠇꠔ ꠘꠣꠎꠤꠟ ꠇꠞꠤꠀ ꠙꠣꠇ ꠖꠤꠘ ꠇꠞꠟꠣ, ꠔꠣꠘ ꠢꠇꠟꠔꠣ ꠙꠄꠖꠣ ꠇꠞꠣ ꠡꠦꠡ ꠇꠞꠤ ꠔꠣꠁꠘ ꠅꠃ ꠖꠤꠘ ꠎꠤꠞꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","ꠅꠃ ꠅꠁꠟ ꠀꠍꠝꠣꠘ ꠀꠞ ꠎꠝꠤꠘ ꠙꠄꠖꠣꠞ ꠛꠄꠀꠘ। ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠎꠦꠛꠟꠣ ꠀꠍꠝꠣꠘ ꠀꠞ ꠎꠝꠤꠘ ꠙꠄꠖꠣ ꠇꠞꠍꠤꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ꠁ ꠡꠝꠄ ꠎꠝꠤꠘꠞ ꠃꠙꠞꠦ ꠇꠥꠘꠥꠎꠣꠔꠞ ꠉꠣꠍ-ꠙꠣꠟꠣ ꠀꠍꠤꠟ ꠘꠣ ꠀꠞ ꠇꠥꠘꠥ ꠟꠔꠣ-ꠙꠣꠔꠣꠅ ꠚꠟꠤꠍꠦ ꠘꠣ, ꠇꠣꠞꠘ ꠔꠣꠁꠘ ꠎꠝꠤꠘꠞ ꠃꠙꠞꠦ ꠝꠦꠊ ꠖꠤꠍꠂꠘ ꠘꠣ, ꠀꠞ ꠎꠝꠤꠘ ꠀꠛꠣꠖ ꠇꠞꠣꠞ ꠝꠣꠘꠥꠡꠅ ꠀꠍꠤꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ꠅꠃ ꠡꠝꠄ ꠝꠣꠐꠤꠞ ꠝꠥꠞ ꠕꠣꠇꠤ ꠙꠣꠘꠤ ꠃꠑꠔ ꠀꠞ ꠎꠝꠤꠘ ꠜꠤꠎꠔ। ");
INSERT INTO syls_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠚꠦꠇ ꠝꠣꠐꠤ ꠖꠤꠀ ꠝꠣꠘꠥꠡ ꠛꠣꠘꠣꠁꠀ ꠔꠣꠞ ꠘꠣꠇꠞ ꠝꠣꠎꠦ ꠚꠥ ꠖꠤꠀ ꠎꠣꠘ ꠢꠣꠞꠣꠁꠟꠣ। ꠀꠞ ꠅꠃ ꠝꠣꠘꠥꠡ ꠎꠣꠘꠖꠣꠞ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠙꠥꠛꠦꠖꠤ ꠀꠖꠣꠘ ꠘꠣꠝꠞ ꠎꠣꠉꠣꠔ ꠄꠇ ꠛꠣꠉꠣꠘ ꠇꠞꠍꠤꠟꠣ, ꠢꠘꠅ ꠔꠣꠘꠞ ꠛꠣꠘꠣꠁꠟ ꠅꠃ ꠝꠣꠘꠥꠡꠞꠦ ꠞꠣꠈꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","ꠢꠤꠈꠣꠘꠞ ꠝꠣꠐꠤꠔ ꠔꠣꠁꠘ ꠅꠃ ꠟꠣꠈꠣꠘ ꠉꠣꠍ ꠅꠇꠟ ꠚꠟꠣꠁꠍꠟꠣ, ꠎꠦꠔꠣ ꠖꠦꠈꠔꠦ ꠈꠥꠛ ꠡꠥꠘ꠆ꠖꠞ ꠀꠞ ꠚꠟꠅ ꠈꠣꠁꠔꠦ ꠈꠥꠛ ꠝꠎꠣ। ꠀꠞ ꠛꠣꠉꠣꠘꠞ ꠝꠣꠎꠈꠣꠘꠅ ꠔꠣꠁꠘ “ꠎꠤꠘ꠆ꠖꠦꠉꠤ-ꠉꠣꠍ” ꠀꠞ “ꠘꠦꠇꠤ-ꠛꠖꠤꠞ ꠀꠈꠟ ꠖꠦꠅꠞꠣ ꠉꠣꠍ” ꠘꠣꠝꠞ ꠖꠥꠁꠐꠣ ꠉꠣꠍꠅ ꠞꠣꠈꠍꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ꠢꠃ ꠛꠣꠉꠣꠘꠅ ꠙꠣꠘꠤ ꠎꠥꠉꠣꠁꠀ ꠖꠤꠔ ꠄꠇ ꠉꠣꠋ ꠀꠍꠤꠟ, ꠎꠦꠇꠐꠣ ꠀꠖꠣꠘꠞ ꠝꠣꠎꠦꠖꠤ ꠛꠣꠞ ꠅꠁꠀ ꠌꠣꠁꠞ ꠜꠣꠉ ꠅꠁꠉꠦꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","ꠙꠄꠟꠣ ꠉꠣꠋꠉꠞ ꠘꠣꠝ ꠀꠍꠤꠟ ꠙꠤꠡꠥꠘ, ꠁꠇꠐꠣ ꠀꠡ꠆ꠔꠣ ꠢꠛꠤꠟꠣ ꠖꠦꠡꠞ ꠜꠤꠔꠞꠦ ꠖꠤꠀ ꠉꠦꠍꠦ। ꠁꠘꠅ ꠡꠥꠘꠣ ꠙꠣꠅꠀ ꠎꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ꠀꠞ ꠅꠃ ꠖꠦꠡꠞ ꠡꠥꠘꠣ ꠈꠥꠛ ꠈꠣꠐꠤ, ꠁꠔꠣ ꠍꠣꠠꠣꠅ ꠢꠤꠘꠅ ꠝꠦꠡꠇꠦ-ꠀꠝ꠆ꠛꠞ ꠀꠞ ꠀꠇꠤꠇ ꠝꠘꠤ ꠙꠣꠅꠀ ꠎꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","ꠖꠥꠁ ꠘꠝ꠆ꠛꠞ ꠉꠣꠋꠉꠞ ꠘꠣꠝ ꠎꠤꠢꠥꠘ, ꠁꠇꠐꠣ ꠀꠡ꠆ꠔꠣ ꠇꠥꠡ ꠖꠦꠡꠞ ꠜꠤꠔꠞꠦ ꠖꠤꠀ ꠉꠦꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","ꠔꠤꠘ ꠘꠝ꠆ꠛꠞ ꠉꠣꠋꠉꠞ ꠘꠣꠝ ꠖꠎꠟꠣ, ꠁꠇꠐꠣ ꠀꠡꠤꠞꠤꠀ ꠖꠦꠡꠞ ꠙꠥꠛꠦ ꠖꠤꠀ ꠉꠦꠍꠦ। ꠀꠞ ꠌꠣꠁꠞ ꠘꠝ꠆ꠛꠞ ꠉꠣꠋꠉꠞ ꠘꠣꠝ ꠅꠁꠟ ꠚꠥꠞꠣꠔ। ");
INSERT INTO syls_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠅꠃ ꠝꠣꠘꠥꠡꠞꠦ ꠀꠖꠣꠘ ꠛꠣꠉꠣꠘꠅ ꠞꠣꠈꠟꠣ, ꠢꠤꠘꠅ ꠈꠦꠔ-ꠈꠣꠝꠣꠞ ꠀꠞ ꠢꠦꠚꠣꠎꠔ ꠇꠞꠣꠞ ꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","ꠔꠣꠁꠘ ꠀꠖꠝꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠟꠣ, “ꠔꠥꠝꠤ ꠔꠥꠝꠣꠞ ꠈꠥꠡꠤꠝꠔ ꠁ ꠛꠣꠉꠤꠌꠣꠞ ꠎꠦꠇꠥꠘꠥ ꠉꠣꠍꠞ ꠚꠟ ꠈꠣꠁꠔꠣꠄ ꠙꠣꠞꠛꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ꠈꠣꠟꠤ ꠘꠦꠇꠤ-ꠛꠖꠤꠞ ꠀꠈꠟꠞ ꠉꠣꠍꠞ ꠚꠟ ꠈꠣꠁꠅ ꠘꠣ, ꠎꠦꠖꠤꠘ ꠔꠥꠝꠤ ꠅꠃ ꠉꠣꠍꠞ ꠚꠟ ꠈꠣꠁꠛꠣꠄ ꠁꠖꠤꠘ ꠔꠥꠝꠤ ꠝꠞꠛꠣꠄꠃ ꠝꠞꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠇꠁꠟꠣ, “ꠝꠣꠘꠡꠞ ꠟꠣꠉꠤ ꠄꠇꠟꠣ ꠕꠣꠇꠣ ꠜꠣꠟꠣ ꠘꠣꠄ। ꠀꠝꠤ ꠔꠣꠞ ꠟꠣꠈ ꠄꠇꠎꠘ ꠎꠥꠠꠤ ꠛꠣꠘꠣꠁꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","ꠀꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠖꠥꠘꠤꠀꠁꠞ ꠢꠇꠟ ꠎꠣꠘꠖꠣꠞ ꠀꠞ ꠀꠍꠝꠣꠘꠞ ꠢꠇꠟ ꠙꠣꠈꠤ ꠝꠣꠐꠤꠖꠤ ꠛꠣꠘꠣꠁꠀ ꠅꠃ ꠝꠣꠘꠡꠞ ꠍꠣꠝꠘꠦ ꠀꠘꠟꠣ, ꠖꠦꠈꠟꠣ ꠄꠁꠘ ꠁꠔꠣꠞꠦ ꠇꠤꠔꠣ ꠇꠁꠀ ꠒꠣꠇꠂꠘ, ꠀꠞ ꠔꠣꠁꠘ ꠎꠣꠞꠦ ꠎꠦ ꠘꠣꠝꠦ ꠒꠣꠇꠟꠣ, ꠔꠣꠞ ꠅꠃ ꠘꠣꠝ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","ꠀꠖꠝꠦ ꠢꠇꠟ ꠙꠣꠟꠣ ꠢꠦꠝꠣꠘ, ꠀꠍꠝꠣꠘꠞ ꠙꠣꠈꠤ ꠀꠞ ꠎꠋꠟꠤ ꠎꠣꠘꠥꠀꠞꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ, ꠁꠔꠣꠞ ꠝꠣꠎꠦ ꠔꠣꠘ ꠟꠣꠈ ꠇꠥꠘꠥ ꠎꠥꠠꠤ ꠝꠤꠟꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","ꠄꠞꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠀꠖꠝꠞ ꠝꠣꠎꠦ ꠛꠦꠢꠥꠡꠤ ꠊꠥꠝ ꠀꠘꠟꠣ। ꠅꠃ ꠊꠥꠝꠞ ꠝꠣꠎꠦ ꠔꠣꠘ ꠙꠣꠁꠘ꠆ꠎꠞꠞ ꠄꠇꠐꠣ ꠀꠒ꠆ꠒꠤ ꠈꠥꠟꠤꠀ ꠘꠤꠀ ꠎꠣꠉꠣꠐꠣ ꠛꠘ꠆ꠖ ꠇꠞꠤ ꠖꠤꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","ꠀꠞ ꠅꠃ ꠀꠒ꠆ꠒꠤ ꠖꠤꠀ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠄꠇ ꠛꠦꠐꠤꠝꠣꠘꠥꠡ ꠛꠣꠘꠣꠁꠀ ꠀꠖꠝꠞ ꠉꠦꠍꠦ ꠀꠘꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","ꠔꠣꠘꠦ ꠖꠦꠈꠤꠀ ꠀꠖꠝꠦ ꠇꠁꠟꠣ, “ꠅꠈꠘ ꠅꠁꠍꠦ, ꠔꠣꠁ ꠀꠝꠣꠞ ꠀꠒ꠆ꠒꠤꠞ ꠀꠒ꠆ꠒꠤ, ꠉꠥꠡ꠆ꠔꠞ ꠉꠥꠡ꠆ꠔ। ꠔꠣꠁꠞ ꠘꠣꠝ ꠅꠁꠛ ꠘꠣꠞꠤ, ꠔꠣꠁꠞꠦ ꠘꠞ ꠕꠣꠇꠤ ꠘꠦꠅꠀ।” ");
INSERT INTO syls_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","ꠄꠞꠟꠣꠉꠤ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠦ ꠝꠣ-ꠛꠣꠚꠞꠦ ꠍꠣꠠꠤꠀ ꠛꠃꠞ ꠟꠉꠦ ꠞꠁꠛꠣ, ꠔꠣꠞꠣ ꠖꠥꠁꠅꠎꠘ ꠄꠇ ꠡꠞꠤꠟ ꠅꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","ꠀꠖꠝ ꠀꠞ ꠔꠣꠘ ꠛꠤꠛꠤꠞ ꠡꠞꠤꠟ ꠃꠖꠣꠝ ꠕꠣꠇꠔ, ꠁꠔꠣ ꠇꠥꠘꠥ ꠡꠞꠝ ꠀꠍꠤꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠙꠄꠖꠣ ꠇꠞꠣ ꠎꠝꠤꠘꠞ ꠢꠇꠟ ꠎꠣꠘꠖꠣꠞꠞ ꠝꠣꠎꠦ ꠢꠣꠚ ꠅꠁꠟ ꠢꠇꠟ ꠕꠣꠇꠤ ꠚꠘ꠆ꠖꠤꠛꠣꠎ। ꠅꠃ ꠢꠣꠚꠦ ꠄꠇꠖꠤꠘ ꠢꠤ ꠛꠦꠐꠤ ꠝꠣꠘꠡꠞꠦ ꠇꠁꠟ, “ꠀꠟ꠆ꠟꠣꠄ ꠢꠣꠍꠣꠃ ꠔꠥꠝꠣꠔꠣꠘꠞꠦ ꠇꠁꠍꠂꠘ ꠘꠤ, ꠛꠣꠉꠣꠘꠞ ꠢꠇꠟ ꠉꠣꠍꠞ ꠚꠟ ꠔꠥꠝꠞꠣ ꠈꠣꠁꠔꠣꠄ ꠙꠣꠞꠔꠣꠄ ꠘꠣꠄ?” ");
INSERT INTO syls_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","ꠛꠦꠐꠤꠄ ꠇꠁꠟꠣ, “ꠛꠣꠉꠣꠘꠞ ꠎꠦꠇꠥꠘꠥ ꠉꠣꠍꠞ ꠚꠟ ꠀꠝꠞꠣ ꠈꠣꠁꠔꠣꠝ ꠙꠣꠞꠤ, ");
INSERT INTO syls_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ꠈꠣꠟꠤ ꠛꠣꠉꠣꠘꠞ ꠝꠣꠎꠈꠣꠘꠅ ꠎꠦ ꠉꠣꠍꠐꠣ ꠀꠍꠦ, ꠀꠟ꠆ꠟꠣꠄ ꠇꠁꠍꠂꠘ, ꠔꠥꠝꠞꠣ ꠄꠞ ꠚꠟ ꠈꠣꠁꠅ ꠘꠣ, ꠍꠁꠅ-ꠅ ꠘꠣ, ꠍꠁꠟꠦꠃ ꠝꠞꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","ꠅꠃ ꠢꠣꠚꠦ ꠔꠣꠘꠞꠦ ꠇꠁꠟ, “ꠘꠣ, ꠇꠥꠘꠥꠝꠘ꠆ꠔꠦꠃ ꠝꠞꠔꠣꠄ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","ꠀꠟ꠆ꠟꠣꠄ ꠔ ꠎꠣꠘꠂꠘ, ꠎꠦꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠁ ꠉꠣꠍꠞ ꠚꠟ ꠈꠣꠁꠟꠤꠛꠣꠄ ꠁꠖꠤꠘ ꠔꠥꠝꠞꠣꠞ ꠌꠃꠈ ꠈꠥꠟꠤꠎꠤꠛ, ꠀꠞ ꠘꠦꠇꠤ-ꠛꠖꠤꠞ ꠀꠈꠟ ꠙꠣꠁꠀ ꠔꠥꠝꠞꠣ ꠀꠟ꠆ꠟꠣꠞ ꠟꠣꠈꠣꠘ ꠅꠁꠎꠤꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","ꠛꠦꠐꠤꠄ ꠎꠦꠛꠟꠣ ꠛꠥꠎꠟꠣ, ꠅꠃ ꠉꠣꠍꠞ ꠚꠟ ꠈꠣꠁꠔꠦ ꠝꠎꠣ ꠅꠁꠛ, ꠖꠦꠈꠔꠦꠅ ꠡꠥꠘ꠆ꠖꠞ, ꠀꠞ ꠀꠈꠟꠖꠣꠞꠅ ꠅꠁꠎꠤꠝꠥ, ꠅꠃ ꠔꠣꠁꠘ ꠚꠟ ꠙꠣꠠꠤꠀ ꠈꠣꠁꠟꠣ, ꠀꠞ ꠔꠣꠘ ꠎꠣꠝꠣꠁꠞꠦꠅ ꠖꠤꠟꠣ ꠀꠞ ꠎꠣꠝꠣꠁꠄꠅ ꠈꠣꠁꠟꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","ꠟꠉꠦ ꠟꠉꠦ ꠔꠣꠞꠣ ꠖꠥꠁꠅ ꠎꠘꠞ ꠌꠃꠈ ꠈꠥꠟꠤꠉꠦꠟ, ꠀꠞ ꠛꠥꠎꠟꠣ ꠔꠣꠁꠘ-ꠔꠣꠁꠘ ꠟꠦꠝꠐꠣ। ꠅꠃ ꠔꠣꠞꠣ ꠒꠥꠝꠥꠞ ꠉꠣꠍꠞ ꠇꠄꠐꠣ ꠙꠣꠔꠣ ꠍꠤꠠꠤꠀ ꠡꠤꠟꠣꠁ ꠇꠞꠤ ꠟꠦꠝꠐꠤ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","ꠢꠣꠁꠘ꠆ꠎꠣ ꠛꠣꠟꠣ ꠔꠣꠞꠣ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠀꠅꠀꠎ ꠢꠥꠘꠟꠣ, ꠔꠣꠁꠘ ꠛꠣꠉꠣꠘꠞ ꠝꠣꠎꠦ ꠙꠣꠇꠣꠘꠤꠔ ꠀꠁꠞꠣ। ꠔꠦꠃ ꠀꠖꠝ ꠀꠞ ꠔꠣꠘ ꠛꠃ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠍꠣꠝꠘꠦ ꠘꠣ ꠙꠠꠣꠞ ꠟꠣꠉꠤ ꠛꠣꠉꠣꠘꠞ ꠉꠣꠍꠞ ꠀꠅꠠꠦ ꠟꠥꠇꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠀꠖꠝꠞꠦ ꠒꠣꠇ ꠖꠤꠀ ꠎꠤꠇꠣꠁꠟꠣ, “ꠔꠥꠝꠤ ꠇꠥꠀꠁ?” ");
INSERT INTO syls_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠛꠣꠉꠣꠘꠞ ꠝꠣꠎꠦ ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠀꠅꠀꠎ ꠢꠥꠘꠍꠤ। ꠀꠝꠤ ꠔ ꠟꠦꠝꠐꠣ, ꠄꠞꠟꠣꠉꠤ ꠒꠞꠣꠁꠀ ꠟꠥꠇꠣꠁ ꠞꠁꠍꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","ꠔꠦꠃ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠎꠤꠇꠣꠁꠟꠣ, “ꠔꠥꠝꠤ ꠎꠦ ꠟꠦꠝꠐꠣ ꠇꠦ ꠇꠁꠟ? ꠎꠦ ꠉꠣꠍꠞ ꠚꠟ ꠈꠣꠁꠔꠦ ꠔꠥꠝꠣꠞꠦ ꠘꠣ ꠇꠞꠍꠤꠟꠣꠝ, ꠈꠣꠁꠟꠤꠍ ꠘꠣ ꠇꠤꠔꠣ?” ");
INSERT INTO syls_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","ꠀꠖꠝꠦ ꠇꠁꠟꠣ, “ꠎꠦ ꠛꠦꠐꠤꠝꠣꠘꠥꠡ ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠟꠉꠦ ꠖꠤꠍ, ꠔꠣꠁ ꠅꠃ ꠉꠣꠍꠞ ꠚꠟ ꠀꠝꠣꠞꠦ ꠈꠣꠅꠀꠁꠍꠦ।” ");
INSERT INTO syls_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","ꠅꠃ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠛꠦꠐꠤꠞꠦ ꠎꠤꠇꠣꠁꠟꠣ, “ꠔꠥꠝꠤ ꠁꠔꠣ ꠇꠤꠔꠣ ꠇꠞꠟꠣꠄ?” ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠢꠣꠚꠦ ꠀꠝꠣꠞꠦ ꠍꠣꠟ꠆ꠟꠣ ꠖꠤꠀ ꠈꠣꠅꠀꠁꠍꠦ।” ");
INSERT INTO syls_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","ꠔꠦꠃ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠢꠣꠚꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠁ ꠇꠣꠝꠞ ꠟꠣꠉꠤ ꠢꠇꠟ ꠙꠣꠟꠣ ꠢꠦꠝꠣꠘ ꠀꠞ ꠢꠇꠟ ꠎꠋꠟꠤ ꠎꠣꠘꠥꠀꠞꠞ ꠝꠣꠎꠦ ꠔꠥꠝꠤꠃ ꠟꠣꠘ꠆ꠘꠔꠤ ꠅꠁꠟꠣꠄ। ꠔꠥꠝꠤ ꠎꠤꠘ꠆ꠖꠦꠉꠤꠜꠞ ꠙꠦꠐꠅ ꠜꠞꠖꠤ ꠌꠟꠛꠣꠄ ꠀꠞ ꠗꠥꠟꠣ-ꠛꠣꠟꠥ ꠈꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠀꠞ ꠛꠦꠐꠤꠞ ꠝꠣꠎꠦ, ꠔꠥꠝꠣꠞ ꠛꠋꠡ ꠀꠞ ꠛꠦꠐꠤ ꠝꠣꠘꠡꠞ ꠛꠋꠡꠞ ꠝꠣꠎꠦ ꠖꠥꠡꠝꠘꠤ ꠙꠄꠖꠣ ꠇꠞꠝꠥ। ꠢꠤ ꠛꠋꠡꠦ ꠔꠥꠝꠣꠞ ꠇꠟ꠆ꠟꠣ ꠉꠥꠠꠣ ꠇꠞꠛ, ꠀꠞ ꠔꠥꠝꠤ ꠔꠣꠞ ꠙꠣꠅꠞ ꠝꠥꠞꠣꠔ ꠇꠣꠝꠠꠣꠁꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","ꠀꠞ ꠔꠣꠁꠘ ꠛꠦꠐꠤꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠅꠁꠛꠣꠞ ꠡꠝꠄ ꠔꠥꠝꠣꠞ ꠝꠍꠤꠛꠔ ꠈꠥꠛ ꠛꠣꠠꠣꠁ ꠖꠤꠝꠥ, ꠔꠥꠝꠤ ꠈꠥꠛ ꠇꠡ꠆ꠐ ꠇꠞꠤꠀ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠙꠄꠖꠣ ꠇꠞꠛꠣꠄ। ꠎꠣꠝꠣꠁꠞ ꠛꠣꠄ ꠔꠥꠝꠣꠞ ꠈꠥꠛ ꠈꠣꠁꠡ ꠕꠣꠇꠛ, ꠀꠞ ꠢꠦ ꠔꠥꠝꠣꠞ ꠃꠙꠞꠦ ꠛꠦꠐꠣꠉꠤꠞꠤ ꠇꠞꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","ꠔꠣꠁꠘ ꠀꠖꠝꠞꠦ ꠇꠁꠟꠣ, “ꠎꠦ ꠉꠣꠍꠞ ꠚꠟ ꠀꠝꠤ ꠢꠣꠞꠣꠝ ꠇꠞꠤꠀ ꠖꠤꠍꠟꠣꠝ, ꠔꠥꠝꠤ ꠔꠥꠝꠣꠞ ꠛꠃꠞ ꠇꠕꠣ ꠢꠥꠘꠤꠀ ꠁꠔꠣ ꠈꠣꠁꠍ, ꠅꠃ ꠇꠣꠞꠘꠦ ꠎꠝꠤꠘꠞꠦ ꠟꠣꠘ꠆ꠘꠔꠤ ꠇꠞꠣ ꠅꠁꠟ। ꠎꠤꠘ꠆ꠖꠦꠉꠤꠜꠞ ꠎꠛꠞ ꠔꠇꠟꠤꠚ ꠇꠞꠤꠀ ꠔꠥꠝꠤ ꠎꠝꠤꠘꠞ ꠚꠡꠟ ꠈꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ꠔꠥꠝꠣꠞ ꠟꠣꠉꠤ ꠝꠣꠐꠤꠞ ꠝꠣꠎꠦ ꠇꠣꠐꠣ-ꠉꠍꠣ ꠀꠞ ꠛꠤꠡꠀꠟꠣ ꠎꠋꠉꠟ ꠎꠘꠝꠣꠁꠛ, ꠀꠞ ꠔꠥꠝꠣꠞ ꠈꠣꠘꠤ ꠅꠁꠛ ꠅꠃ ꠝꠣꠐꠤꠞ ꠚꠄ-ꠚꠡꠟ। ");
INSERT INTO syls_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","ꠎꠦ ꠝꠣꠐꠤ ꠕꠣꠇꠤ ꠔꠥꠝꠣꠞꠦ ꠙꠄꠖꠣ ꠇꠞꠍꠟꠣꠝ, ꠢꠃ ꠝꠣꠐꠤꠔ ꠚꠤꠞꠤꠀ ꠘꠣ ꠎꠣꠅꠀ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠔꠥꠝꠣꠞ ꠝꠣꠕꠣꠞ ꠊꠣꠝ ꠙꠣꠅꠔ ꠚꠣꠟꠣꠁꠀ ꠈꠣꠘꠤ ꠈꠣꠁꠛꠣꠄ। ꠔꠥꠝꠣꠞ ꠝꠣꠐꠤꠞ ꠡꠞꠤꠟ, ꠝꠣꠐꠤꠔꠃ ꠝꠤꠡꠤꠎꠤꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","ꠀꠖꠝꠦ ꠔꠣꠘ ꠛꠤꠛꠤꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠢꠣꠅꠀ ꠝꠣꠘꠤ, ꠎꠤꠘ꠆ꠖꠦꠉꠤ-ꠖꠦꠅꠞꠣ, ꠇꠣꠞꠘ ꠔꠣꠁꠘ ꠢꠇꠟ ꠎꠤꠘ꠆ꠖꠣ ꠝꠣꠘꠡꠞ ꠝꠣ ꠅꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","ꠀꠖꠝ ꠀꠞ ꠔꠣꠘ ꠛꠤꠛꠤꠞ ꠟꠣꠉꠤ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠎꠣꠘꠥꠀꠞꠞ ꠌꠣꠝꠠꠣꠖꠤ ꠟꠦꠛꠣꠍ ꠛꠣꠘꠣꠁꠀ ꠚꠤꠘ꠆ꠖꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠇꠁꠟꠣ, “ꠖꠦꠈꠅ, ꠘꠦꠇꠤ-ꠛꠖꠤꠞ ꠀꠈꠟ ꠙꠣꠁꠀ ꠝꠣꠘꠥꠡ ꠀꠝꠞꠣꠞ ꠟꠣꠈꠣꠘ ꠅꠁꠉꠦꠍꠦ, ꠅꠈꠘ ꠢꠦ ꠎꠣꠔꠦ ꠀꠔ ꠛꠣꠠꠣꠁꠀ ꠎꠤꠘ꠆ꠖꠦꠉꠤ-ꠉꠣꠍꠞ ꠚꠟ ꠈꠣꠁꠀ ꠢꠣꠝꠦꠡꠣ ꠎꠤꠘ꠆ꠖꠣ ꠘꠣ ꠞꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","ꠅꠃ ꠇꠕꠣ ꠇꠁꠀ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠎꠦ ꠝꠣꠐꠤ ꠖꠤꠀ ꠝꠣꠘꠡꠞꠦ ꠙꠄꠖꠣ ꠇꠞꠍꠟꠣ, ꠢꠃ ꠝꠣꠐꠤꠔ ꠈꠦꠔ-ꠈꠣꠝꠣꠞ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠔꠣꠞꠦ ꠀꠖꠣꠘ ꠛꠣꠉꠣꠘ ꠕꠣꠇꠤ ꠈꠦꠖꠣꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ꠈꠦꠖꠣꠁ ꠖꠤꠀ ꠔꠣꠁꠘ ꠎꠤꠘ꠆ꠖꠦꠉꠤ-ꠉꠣꠍꠞ ꠉꠦꠍꠦ ꠎꠣꠅꠀꠞ ꠙꠕ ꠙꠣꠞꠣ ꠖꠦꠅꠀꠞ ꠟꠣꠉꠤ ꠀꠖꠣꠘ ꠛꠣꠉꠣꠘꠞ ꠙꠥꠛꠦꠖꠤ ꠇꠣꠞꠥꠛꠤ ꠚꠤꠞꠤꠡ꠆ꠔꠣ ꠅꠇꠟ ꠞꠣꠈꠟꠣ ꠀꠞ ꠀꠉꠥꠁꠘꠞ ꠔꠟꠥꠀꠞꠅ ꠊꠥꠞꠣꠘꠤꠔ ꠞꠣꠈꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","ꠀꠖꠝꠦ ꠔꠣꠘ ꠛꠤꠛꠤ ꠢꠣꠅꠀꠞ ꠟꠉꠦ ꠝꠤꠟꠣꠞ ꠛꠣꠖꠦ ꠔꠣꠘ ꠙꠦꠐꠅ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠀꠁꠟ, ꠀꠞ ꠇꠣꠛꠤꠟ ꠘꠣꠝꠦ ꠔꠣꠘ ꠄꠇ ꠙꠥꠀꠞ ꠎꠘꠝ ꠅꠁꠟ। ꠔꠦꠃ ꠛꠤꠛꠤ ꠢꠣꠅꠀꠄ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍ ꠕꠘꠦ ꠀꠝꠤ ꠄꠇ ꠝꠣꠘꠥꠡ ꠇꠛꠥꠟ ꠇꠞꠍꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ꠢꠤꠞꠛꠣꠞ ꠔꠣꠘ ꠊꠞꠅ ꠇꠣꠛꠤꠟꠞ ꠜꠣꠁ ꠢꠣꠛꠤꠟꠞ ꠎꠘꠝ ꠅꠁꠟ। ꠢꠣꠛꠤꠟꠦ ꠍꠣꠉꠟ-ꠝꠦꠠꠣ ꠞꠣꠈꠔ, ꠀꠞ ꠇꠣꠛꠤꠟꠦ ꠈꠦꠔ ꠇꠞꠔ। ");
INSERT INTO syls_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","ꠛꠣꠖꠦ ꠄꠇꠖꠤꠘ ꠇꠣꠛꠤꠟꠦ ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍꠦ ꠔꠣꠞ ꠈꠦꠔꠞ ꠚꠄ-ꠚꠡꠟ ꠀꠘꠤꠀ ꠟꠤꠟ꠆ꠟꠣ ꠖꠤꠟ ");
INSERT INTO syls_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ꠀꠞ ꠢꠣꠛꠤꠟꠦꠅ ꠔꠣꠞ ꠙꠣꠟꠞ ꠝꠣꠎꠦ ꠙꠄꠟꠣ ꠎꠘꠝꠤꠍꠦ ꠅꠃꠟꠣ ꠇꠄꠐꠣ ꠍꠣꠉꠟ-ꠝꠦꠠꠣ ꠎꠛ ꠇꠞꠤꠀ ꠌꠞ꠆ꠛꠤꠀꠟꠣ ꠅꠋꠡ ꠟꠤꠟ꠆ꠟꠣ ꠖꠤꠟ। ꠝꠣꠛꠥꠖꠦ ꠢꠣꠛꠤꠟ ꠀꠞ ꠔꠣꠞ ꠟꠤꠟ꠆ꠟꠣ ꠇꠛꠥꠟ ꠇꠞꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ꠇꠣꠛꠤꠟ ꠀꠞ ꠔꠣꠞ ꠟꠤꠟ꠆ꠟꠣ ꠇꠛꠥꠟ ꠇꠞꠟꠣ ꠘꠣ, ꠉꠔꠤꠇꠦ ꠢꠦ ꠈꠥꠛ ꠉꠥꠍꠣ ꠇꠞꠤꠀ ꠝꠥꠈ ꠇꠣꠟꠣ ꠇꠞꠟ। ");
INSERT INTO syls_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","ꠝꠣꠛꠥꠖꠦ ꠇꠣꠛꠤꠟꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠉꠥꠍꠣ ꠇꠞꠞꠣꠄ ꠇꠦꠘꠦ, ꠀꠞ ꠇꠤꠔꠣꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠤ ꠝꠥꠈ ꠇꠣꠟꠣ ꠇꠞꠍ? ");
INSERT INTO syls_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","ꠔꠥꠝꠤ ꠜꠣꠟꠣ ꠇꠣꠝ ꠇꠞꠟꠦ ꠔꠥꠝꠣꠞ ꠝꠥꠈ ꠚꠞ ꠅꠁꠟ ꠅꠘꠦ? ꠀꠞ ꠘꠣ ꠇꠞꠟꠦ ꠔ ꠉꠥꠘꠣꠄ ꠔꠥꠝꠣꠞꠦ ꠗꠞꠣꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠣꠞ ꠖꠥꠀꠞꠅ ꠃꠛꠣꠁ ꠞꠁꠍꠦ। ꠁꠉꠥꠞ ꠃꠙꠞꠦ ꠔꠥꠝꠤ ꠎꠤꠔꠔꠦ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","ꠛꠣꠖꠦ ꠇꠣꠛꠤꠟꠦ ꠔꠣꠞ ꠜꠣꠁ ꠢꠣꠛꠤꠟꠞꠦ ꠒꠣꠇꠤꠀ ꠇꠁꠟ, “ꠀꠅ ꠀꠝꠞꠣ ꠛꠘ꠆ꠖꠅ ꠎꠣꠁ।” ꠀꠞ ꠛꠘ꠆ꠖꠅ ꠉꠤꠀ ꠔꠣꠞ ꠜꠣꠁ ꠢꠣꠛꠤꠟꠞ ꠃꠙꠞꠦ ꠀꠈꠔꠣ ꠢꠣꠝꠟꠣ ꠇꠞꠤꠀ ꠈꠥꠘ ꠇꠞꠟ। ");
INSERT INTO syls_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","ꠢꠦꠡꠦ ꠝꠣꠛꠥꠖꠦ ꠇꠣꠛꠤꠟꠞꠦ ꠎꠤꠇꠣꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠜꠣꠁ ꠇꠥꠀꠁ?” ꠇꠣꠛꠤꠟꠦ ꠇꠁꠟ, “ꠀꠝꠤ ꠎꠣꠘꠤ ꠘꠣ, ꠀꠝꠣꠞ ꠜꠣꠁꠞꠦ ꠀꠝꠤ ꠖꠦꠈꠣ-ꠢꠥꠘꠣ ꠇꠞꠤ ꠘꠤ?” ");
INSERT INTO syls_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","ꠔꠦꠃ ꠝꠣꠛꠥꠖꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠁꠔꠣ ꠇꠤꠔꠣ ꠇꠞꠟꠣꠄ? ꠖꠦꠈꠅ, ꠎꠝꠤꠘ ꠕꠣꠇꠤ ꠔꠥꠝꠣꠞ ꠜꠣꠁꠞ ꠟꠃꠄ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠚꠞꠤꠀꠖ ꠇꠞꠦꠞ। ");
INSERT INTO syls_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ꠎꠝꠤꠘꠦ ꠎꠦꠛꠟꠣ ꠔꠥꠝꠣꠞ ꠇꠣꠞꠘꠦ ꠔꠥꠝꠣꠞ ꠜꠣꠁꠞ ꠟꠃ ꠈꠣꠁꠟ, ꠅꠃ ꠡꠝꠄ ꠔꠥꠝꠤ ꠟꠣꠘ꠆ꠘꠔꠤ ꠅꠁꠀ ꠎꠝꠤꠘ ꠕꠣꠇꠤ ꠈꠦꠖꠣꠁꠟ ꠅꠁꠟꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","ꠔꠥꠝꠤ ꠎꠦꠛꠟꠣ ꠎꠝꠤꠘꠅ ꠈꠦꠔ ꠇꠞꠛꠣꠄ, ꠎꠝꠤꠘꠦ ꠀꠞ ꠔꠥꠝꠣꠞꠦ ꠚꠡꠟ ꠖꠤꠔ ꠘꠣꠄ। ꠔꠥꠝꠤ ꠛꠂꠔꠟ ꠅꠁꠀ ꠖꠥꠘꠤꠀꠁ ꠎꠥꠠꠤ ꠊꠥꠞꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","ꠔꠦꠃ ꠇꠣꠛꠤꠟꠦ ꠝꠣꠛꠥꠖꠞꠦ ꠇꠁꠟ, “ꠁ ꠡꠣꠡ꠆ꠔꠤ ꠀꠝꠣꠞ ꠀꠋꠉꠣꠎ ꠅꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ꠀꠁꠎ ꠔꠥꠝꠤ ꠀꠝꠣꠞꠦ ꠎꠝꠤꠘ ꠕꠣꠇꠤ ꠈꠦꠖꠣꠁ ꠖꠤꠞꠣꠄ, ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠕꠘꠦ ꠢꠞꠤ ꠎꠣꠁꠝꠥꠉꠤ। ꠀꠞ ꠛꠂꠔꠟ ꠅꠁꠀ ꠎꠦꠛꠟꠣ ꠀꠝꠤ ꠖꠥꠘꠤꠀꠁꠔ ꠊꠥꠞꠝꠥ, ꠅꠃ ꠡꠝꠄ ꠎꠣꠞ ꠍꠣꠝꠘꠦꠃ ꠀꠝꠤ ꠙꠠꠝꠥ, ꠢꠦ-ꠃ ꠀꠝꠣꠞꠦ ꠈꠥꠘ ꠇꠞꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","ꠝꠣꠛꠥꠖꠦ ꠔꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠦ ꠔꠥꠝꠣꠞꠦ ꠎꠦ ꠈꠥꠘ ꠇꠞꠛ, ꠔꠣꠞ ꠃꠙꠞꠦ ꠀꠝꠤ ꠡꠣꠔꠉꠥꠘ ꠛꠖꠟꠣ ꠟꠁꠝꠥ।” ꠅꠃ ꠇꠕꠣ ꠇꠁꠀ ꠝꠣꠛꠥꠖꠦ ꠇꠣꠛꠤꠟꠞꠦ ꠄꠇꠐꠣ ꠌꠤꠘ꠆ꠘꠔ ꠖꠤꠟꠣ, ꠎꠣꠔꠦ ꠇꠦꠃ ꠔꠣꠞꠦ ꠀꠔꠅ ꠙꠣꠁꠀꠅ ꠘꠣ ꠝꠣꠞꠦ। ");
INSERT INTO syls_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","ꠄꠞꠛꠣꠖꠦ ꠇꠣꠛꠤꠟ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘ ꠕꠣꠇꠤ ꠢꠞꠤꠀ ꠀꠖꠣꠘꠞ ꠙꠥꠛꠦꠖꠤ ꠘꠥꠖ ꠝꠣꠘꠤ, ꠊꠥꠞꠣ-ꠚꠤꠞꠣ ꠖꠦꠡꠅ ꠉꠦꠟꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","ꠀꠞ ꠇꠣꠛꠤꠟ ꠔꠣꠞ ꠛꠃꠞ ꠟꠉꠦ ꠝꠤꠟꠣꠄ ꠔꠣꠁꠞ ꠙꠦꠐꠅ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠀꠁꠟ, ꠀꠞ ꠢꠘꠥꠇꠞ ꠎꠘꠝ ꠅꠁꠟ। ꠇꠣꠛꠤꠟꠦ ꠄꠇꠐꠣ ꠐꠣꠃꠘ ꠛꠣꠘꠣꠁꠀ ꠔꠣꠞ ꠙꠥꠀꠞ ꠘꠣꠝꠦ ꠐꠣꠃꠘꠞ ꠘꠣꠝ ꠞꠣꠈꠟ ꠢꠘꠥꠇ। ");
INSERT INTO syls_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ꠢꠘꠥꠇꠞ ꠙꠥꠀ ꠁꠞꠖ, ꠁꠞꠖꠞ ꠙꠥꠀ ꠝꠢꠥꠀꠁꠄꠟ, ꠝꠢꠥꠀꠁꠄꠟꠞ ꠙꠥꠀ ꠝꠕꠥꠡꠣꠁꠄꠟ, ꠝꠕꠥꠡꠣꠁꠄꠟꠞ ꠙꠥꠀ ꠟꠦꠝꠇ। ");
INSERT INTO syls_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","ꠟꠦꠝꠇꠦ ꠖꠥꠁ ꠛꠤꠀ ꠇꠞꠍꠟꠣ, ꠄꠇ ꠛꠃꠞ ꠘꠣꠝ ꠀꠖꠣ, ꠀꠞꠇ ꠛꠃꠞ ꠘꠣꠝ ꠡꠤꠟ꠆ꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ꠀꠖꠣꠞ ꠊꠞꠅ ꠎꠣꠛꠟꠞ ꠎꠘꠝ ꠅꠁꠟ, ꠎꠣꠞꠣ ꠔꠣꠝ꠆ꠛꠥꠔ ꠕꠣꠇꠦ ꠀꠞ ꠙꠡꠥ ꠙꠣꠟꠦ, ꠅꠃ ꠎꠣꠛꠟ ꠔꠣꠞꠣꠞ ꠝꠥꠟ ꠛꠣꠚ। ");
INSERT INTO syls_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","ꠎꠣꠛꠟꠞ ꠜꠣꠁꠞ ꠘꠣꠝ ꠎꠥꠛꠟ। ꠎꠣꠞꠣ ꠛꠣꠡꠤ ꠀꠞ ꠛꠤꠘ ꠛꠣꠎꠣꠄ, ꠅꠃ ꠎꠥꠛꠟ ꠔꠣꠞꠣꠞ ꠝꠥꠟ ꠛꠣꠚ। ");
INSERT INTO syls_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","ꠡꠤꠟ꠆ꠟꠣꠞ ꠙꠦꠐꠅ ꠔꠥꠛꠟ-ꠇꠣꠛꠤꠟꠞ ꠎꠘꠝ ꠅꠁꠟ। ꠙꠤꠔꠟ ꠀꠞ ꠟꠥꠀꠞ ꠀꠔꠤꠀꠞ ꠛꠣꠘꠣꠘꠤ ꠀꠍꠤꠟ ꠔꠣꠞ ꠇꠣꠝ। ꠔꠣꠞ ꠛꠁꠘꠞ ꠘꠣꠝ ꠘꠣꠁꠄꠝꠣ। ");
INSERT INTO syls_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","ꠄꠇꠖꠤꠘ ꠟꠦꠝꠇꠦ ꠔꠣꠞ ꠖꠥꠁ ꠛꠃꠞꠦ ꠇꠁꠟ, “ꠅ ꠀꠖꠣ ꠀꠞ ꠡꠤꠟ꠆ꠟꠣ, ꠀꠝꠣꠞ ꠇꠕꠣ ꠢꠥꠘ, ꠟꠦꠝꠇꠞ ꠛꠤꠛꠤꠘ, ꠀꠝꠣꠞ ꠇꠕꠣꠄ ꠖꠦꠅ ꠇꠣꠘ। ꠎꠦ ꠛꠦꠐꠣꠄ ꠀꠝꠣꠞꠦ ꠇꠞꠤꠟ ꠎꠈꠝ, ꠎꠦ ꠛꠦꠐꠣꠄ ꠀꠝꠣꠞ ꠉꠣꠔ ꠔꠥꠟꠟ ꠀꠔ, ꠢꠦꠞꠦ ꠀꠝꠤ ꠇꠞꠤꠟꠣꠝ ꠘꠤꠙꠣꠔ। ");
INSERT INTO syls_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ꠇꠣꠛꠤꠟꠞ ꠈꠥꠘꠞ ꠛꠖꠟꠣ ꠎꠥꠖꠤ ꠡꠣꠔ ꠉꠥꠘ ꠅꠄ, ꠟꠦꠝꠇꠞ ꠛꠖꠟꠣ ꠡꠣꠔꠔ꠆ꠔꠁꠞ ꠉꠥꠘ ꠘꠤꠌ꠆ꠌꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","ꠄꠞꠝꠣꠎꠦ ꠀꠖꠝꠦ ꠢꠤꠞꠛꠣꠞ ꠔꠣꠘ ꠛꠃꠞ ꠟꠉꠦ ꠝꠤꠟꠣꠄ, ꠔꠣꠘ ꠙꠦꠐꠅ ꠀꠞꠇ ꠙꠥꠀ ꠅꠁꠟ, ꠢꠣꠅꠀꠄ ꠔꠣꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠡꠤꠡ। ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠇꠣꠛꠤꠟꠦ ꠢꠣꠛꠤꠟꠞꠦ ꠈꠥꠘ ꠇꠞꠍꠦ ꠇꠞꠤ ꠀꠟ꠆ꠟꠣꠄ ꠢꠣꠛꠤꠟꠞ ꠛꠖꠟꠣ ꠀꠝꠣꠞꠦ ꠄꠇ ꠌꠦꠞꠣꠉ ꠎꠥꠉꠣꠁ ꠖꠤꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","ꠛꠣꠖꠦ ꠡꠤꠡꠞꠅ ꠄꠇ ꠙꠥꠀ ꠅꠁꠟ, ꠢꠦ ꠔꠣꠞ ꠘꠣꠝ ꠞꠣꠈꠟ ꠀꠘꠥꠡ, ꠅꠃ ꠡꠝꠄ ꠕꠘꠦ ꠝꠣꠘꠡꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝ ꠟꠅꠀ ꠡꠥꠞꠥ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ꠁꠔꠣ ꠅꠁꠟ ꠀꠖꠝꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠇꠟꠝꠛꠘ꠆ꠖꠤ ꠛꠄꠀꠘ। ꠝꠣꠘꠥꠡ ꠙꠄꠖꠣ ꠇꠞꠣꠞ ꠡꠝꠄ ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠘ ꠘꠤꠎꠞ ꠍꠥꠞꠔꠦ ꠙꠄꠖꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ꠙꠄꠖꠣ ꠇꠞꠟꠣ ꠛꠦꠐꠣ ꠀꠞ ꠛꠦꠐꠤ, ꠀꠞ ꠔꠣꠞꠣꠞꠦ ꠝꠣꠛꠥꠖꠦ ꠛꠞꠇꠔ ꠖꠤꠟꠣ, ꠙꠄꠖꠣ ꠇꠞꠤꠀ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠀꠖꠝ। ");
INSERT INTO syls_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","ꠀꠖꠝꠞ ꠄꠇ-ꠡ ꠔꠤꠡ ꠛꠞꠍ ꠛꠄꠅꠡꠅ ꠔꠣꠘ ꠟꠉꠦ ꠝꠤꠟ ꠞꠣꠈꠤꠀ ꠔꠣꠘ ꠍꠥꠞꠔꠦ ꠄꠇ ꠙꠥꠀ ꠅꠁꠟ। ꠔꠣꠁꠘ ꠄꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠡꠤꠡ। ");
INSERT INTO syls_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","ꠡꠤꠡꠞ ꠎꠘꠝꠞ ꠛꠣꠖꠦ ꠀꠖꠝ ꠀꠞꠅ ꠀꠐ-ꠡ ꠛꠞꠍ ꠛꠣꠌꠟꠣ, ꠄꠞ ꠝꠣꠎꠦ ꠔꠣꠘ ꠀꠞꠅ ꠙꠥꠀ-ꠙꠥꠠꠤꠘ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ꠝꠥꠐ ꠘꠄ-ꠡ ꠔꠤꠡ ꠛꠞꠍ ꠎꠤꠘ꠆ꠖꠣ ꠕꠣꠇꠣꠞ ꠛꠣꠖꠦ ꠀꠖꠝ ꠝꠣꠞꠣ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","ꠡꠤꠡꠞ ꠄꠇ-ꠡ ꠙꠣꠌ ꠛꠞꠍ ꠛꠄꠅꠡꠅ ꠔꠣꠘ ꠙꠥꠀ ꠀꠘꠥꠡꠞ ꠎꠘꠝ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ꠀꠘꠥꠡꠞ ꠎꠘꠝꠞ ꠛꠣꠖꠦ ꠡꠤꠡ ꠀꠞꠅ ꠀꠐ-ꠡ ꠡꠣꠔ ꠛꠞꠍ ꠛꠣꠌꠟꠣ। ꠄꠞ ꠝꠣꠎꠦ ꠔꠣꠘ ꠀꠞꠅ ꠙꠥꠀ-ꠙꠥꠠꠤ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","ꠝꠥꠐ ꠘꠄ-ꠡ ꠛꠣꠞꠅ ꠛꠞꠍ ꠛꠣꠌꠣꠞ ꠛꠣꠖꠦ ꠡꠤꠡ ꠝꠣꠞꠣ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ꠀꠘꠥꠡꠞ ꠘꠛ꠆ꠛꠁ ꠛꠞꠍ ꠛꠄꠅꠡꠅ ꠔꠣꠘ ꠙꠥꠀ ꠇꠤꠘꠣꠘꠞ ꠎꠘꠝ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","ꠇꠤꠘꠣꠘꠞ ꠎꠘꠝꠞ ꠛꠣꠖꠦ ꠀꠘꠥꠡ ꠀꠞꠅ ꠀꠐ-ꠡ ꠙꠘꠞ ꠛꠞꠍ ꠛꠣꠌꠟꠣ। ꠄꠞ ꠝꠣꠎꠦ ꠔꠣꠘ ꠀꠞꠅ ꠙꠥꠀ-ꠙꠥꠠꠤ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ꠝꠥꠐ ꠘꠄ-ꠡ ꠙꠣꠌ ꠛꠞꠍ ꠛꠣꠌꠣꠞ ꠛꠣꠖꠦ ꠀꠘꠥꠡ ꠝꠣꠞꠣ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","ꠇꠤꠘꠣꠘꠞ ꠡꠔ꠆ꠔꠁꠞ ꠛꠞꠍ ꠛꠄꠅꠡꠅ ꠔꠣꠘ ꠙꠥꠀ ꠝꠣꠢꠟꠣꠁꠟꠞ ꠎꠘꠝ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","ꠝꠣꠢꠟꠣꠁꠟꠞ ꠎꠘꠝꠞ ꠛꠣꠖꠦ ꠇꠤꠘꠣꠘ ꠀꠞꠅ ꠀꠐ-ꠡ ꠌꠣꠟ꠆ꠟꠤꠡ ꠛꠞꠍ ꠛꠣꠌꠟꠣ। ꠄꠞ ꠝꠣꠎꠦ ꠔꠣꠘ ꠀꠞꠅ ꠙꠥꠀ-ꠙꠥꠠꠤ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","ꠝꠥꠐ ꠘꠄ-ꠡ ꠖꠡ ꠛꠞꠍ ꠛꠣꠌꠣꠞ ꠛꠣꠖꠦ ꠇꠤꠘꠣꠘ ꠝꠣꠞꠣ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","ꠝꠣꠢꠟꠣꠁꠟꠞ ꠙꠄꠡꠐ꠆ꠐꠤ ꠛꠞꠍ ꠛꠄꠅꠡꠅ ꠔꠣꠘ ꠙꠥꠀ ꠁꠀꠞꠦꠖꠞ ꠎꠘꠝ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","ꠁꠀꠞꠦꠖꠞ ꠎꠘꠝꠞ ꠛꠣꠖꠦ ꠝꠣꠢꠟꠣꠁꠟ ꠀꠞꠅ ꠀꠐ-ꠡ ꠔꠤꠡ ꠛꠞꠍ ꠛꠣꠌꠟꠣ। ꠄꠞ ꠝꠣꠎꠦ ꠔꠣꠘ ꠀꠞꠅ ꠙꠥꠀ-ꠙꠥꠠꠤ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","ꠝꠥꠐ ꠀꠐ-ꠡ ꠙꠌꠣꠘꠛ꠆ꠛꠁ ꠛꠞꠍ ꠛꠣꠌꠣꠞ ꠛꠣꠖꠦ ꠝꠣꠢꠟꠣꠁꠟ ꠝꠣꠞꠣ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","ꠁꠀꠞꠦꠖꠞ ꠄꠇ-ꠡ ꠛꠣꠡꠐ꠆ꠐꠤ ꠛꠞꠍ ꠛꠄꠅꠡꠅ ꠔꠣꠘ ꠙꠥꠀ ꠁꠖ꠆ꠞꠤꠍꠞ ꠎꠘꠝ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ꠁꠖ꠆ꠞꠤꠍꠞ ꠎꠘꠝꠞ ꠛꠣꠖꠦ ꠁꠀꠞꠦꠖ ꠀꠞꠅ ꠀꠐ-ꠡ ꠛꠞꠍ ꠛꠣꠌꠟꠣ, ꠄꠞ ꠝꠣꠎꠦ ꠔꠣꠘ ꠀꠞꠅ ꠙꠥꠀ-ꠙꠥꠠꠤ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","ꠝꠥꠐ ꠘꠄ-ꠡ ꠛꠣꠡꠐ꠆ꠐꠤ ꠛꠞꠍ ꠛꠣꠌꠣꠞ ꠛꠣꠖꠦ ꠁꠀꠞꠦꠖ ꠝꠣꠞꠣ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ꠁꠖ꠆ꠞꠤꠍꠞ ꠙꠄꠡꠐ꠆ꠐꠤ ꠛꠞꠍ ꠛꠄꠅꠡꠅ ꠔꠣꠘ ꠙꠥꠀ ꠝꠣꠔꠥꠡꠣꠟꠣꠈꠞ ꠎꠘꠝ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","ꠝꠣꠔꠥꠡꠣꠟꠣꠈꠞ ꠎꠘꠝꠞ ꠛꠣꠖꠦ ꠔꠤꠘ-ꠡ ꠛꠞꠍ ꠙꠞ꠆ꠎꠘ꠆ꠔ, ꠀꠟ꠆ꠟꠣꠞ ꠟꠉꠦ ꠁꠖ꠆ꠞꠤꠍꠞ ꠈꠣꠍ ꠖꠤꠖꠣꠞ ꠀꠍꠤꠟ। ꠄꠞ ꠝꠣꠎꠦ ꠔꠣꠘ ꠀꠞꠅ ꠙꠥꠀ-ꠙꠥꠠꠤ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ꠁꠖ꠆ꠞꠤꠍ ꠝꠥꠐ ꠔꠤꠘ-ꠡ ꠙꠄꠡꠐ꠆ꠐꠤ ꠛꠞꠍ ꠖꠥꠘꠤꠀꠁꠔ ꠀꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ꠄꠞꠛꠣꠖꠦ ꠔꠣꠘꠦ ꠀꠞ ꠖꠦꠈꠣ ꠉꠦꠟ ꠘꠣ। ꠀꠟ꠆ꠟꠣꠞ ꠟꠉꠦ ꠔꠣꠘ ꠈꠣꠍ ꠖꠤꠖꠣꠞ ꠀꠍꠤꠟ ꠉꠔꠤꠇꠦ ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠘꠞꠦ ꠎꠤꠘ꠆ꠖꠣ ꠢꠣꠟꠔꠦ ꠘꠤꠎꠞ ꠉꠦꠍꠦ ꠘꠤꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","ꠝꠣꠔꠥꠡꠣꠟꠣꠈꠞ ꠄꠇ-ꠡ ꠡꠣꠔꠣꠡꠤ ꠛꠞꠍ ꠛꠄꠅꠡꠅ ꠔꠣꠘ ꠙꠥꠀ ꠟꠣꠝꠣꠇꠞ ꠎꠘꠝ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","ꠟꠣꠝꠣꠇꠞ ꠎꠘꠝꠞ ꠛꠣꠖꠦ ꠝꠣꠔꠥꠡꠣꠟꠣꠈ ꠀꠞꠅ ꠡꠣꠔ-ꠡ ꠛꠤꠞꠣꠡꠤ ꠛꠞꠍ ꠛꠣꠌꠟꠣ। ꠄꠞ ꠝꠣꠎꠦ ꠔꠣꠘ ꠀꠞꠅ ꠙꠥꠀ-ꠙꠥꠠꠤ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","ꠝꠥꠐ ꠘꠄ-ꠡ ꠃꠘꠥꠡꠔ꠆ꠔꠁꠞ ꠛꠞꠍ ꠛꠣꠌꠣꠞ ꠛꠣꠖꠦ ꠝꠣꠔꠥꠡꠣꠟꠣꠈ ꠝꠣꠞꠣ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","ꠟꠣꠝꠣꠇꠞ ꠄꠇ-ꠡ ꠛꠤꠞꠣꠡꠤ ꠛꠞꠍ ꠛꠄꠅꠡꠅ ꠔꠣꠘ ꠄꠇ ꠙꠥꠀ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ꠔꠣꠁꠘ ꠄꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠘꠥꠢ ꠀꠞ ꠇꠁꠟꠣ, “ꠢꠦ ꠀꠝꠞꠣꠞ ꠀꠔꠞ ꠁ ꠖꠥꠈ-ꠝꠍꠤꠛꠔꠞ ꠇꠣꠝ ꠕꠣꠇꠤ, ꠝꠣꠛꠥꠖꠞ ꠟꠣꠘ꠆ꠘꠔꠤ ꠎꠝꠤꠘ ꠕꠣꠇꠤ ꠅꠈꠘ ꠀꠞꠣꠝ ꠖꠤꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","ꠘꠥꠢꠞ ꠎꠘꠝꠞ ꠛꠣꠖꠦ ꠟꠣꠝꠣꠇ ꠀꠞꠅ ꠙꠣꠌ-ꠡ ꠙꠌꠣꠘꠛ꠆ꠛꠁ ꠛꠞꠍ ꠛꠣꠌꠟꠣ, ꠄꠞ ꠝꠣꠎꠦ ꠔꠣꠘ ꠀꠞꠅ ꠙꠥꠀ-ꠙꠥꠠꠤ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","ꠝꠥꠐ ꠡꠣꠔ-ꠡ ꠡꠣꠔꠔ꠆ꠔꠁꠞ ꠛꠞꠍ ꠛꠣꠌꠣꠞ ꠛꠣꠖꠦ ꠟꠣꠝꠣꠇ ꠝꠣꠞꠣ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","ꠘꠥꠢꠞ ꠙꠣꠌ-ꠡ ꠛꠞꠍ ꠛꠄꠅꠡꠞ ꠛꠣꠖꠦ ꠔꠣꠘ ꠙꠥꠀꠂꠘ ꠡꠣꠝ, ꠢꠣꠝ ꠀꠞ ꠁꠀꠚꠦꠔꠞ ꠎꠘꠝ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","ꠖꠥꠘꠤꠀꠞ ꠃꠙꠞꠦ ꠎꠦꠛꠟꠣ ꠝꠣꠘꠥꠡ ꠛꠣꠠꠣ ꠀꠞꠝ꠆ꠛ ꠅꠁꠟ, ꠀꠞ ꠛꠃꠔ ꠙꠥꠠꠤꠘ꠆ꠔꠞꠅ ꠎꠘꠝ ꠅꠁꠟ, ");
INSERT INTO syls_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ꠔꠦꠃ ꠉꠣꠁꠛꠤ ꠡꠇ꠆ꠔꠤꠀꠟꠣ ꠅꠇꠟꠦ ꠅꠃ ꠙꠥꠠꠤꠘ꠆ꠔꠞꠦ ꠈꠥꠛꠍꠥꠞꠔ ꠖꠦꠈꠤꠀ, ꠎꠦ ꠎꠣꠞꠦ ꠈꠥꠡꠤ ꠔꠣꠁꠞꠦ ꠙꠍꠘ꠆ꠖ ꠇꠞꠤ ꠘꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","ꠁꠔꠣ ꠖꠦꠈꠤꠀ ꠝꠣꠛꠥꠖꠦ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠞꠥꠢꠥ ꠢꠣꠝꠦꠡꠣ ꠝꠣꠘꠡꠞ ꠟꠉꠦ ꠕꠣꠇꠔ ꠘꠣꠄ। ꠝꠣꠘꠥꠡ ꠔ ꠈꠣꠟꠤ ꠉꠥꠡ꠆ꠔꠞ ꠇꠣꠄꠀ, ꠅꠈꠘ ꠕꠣꠇꠤ ꠀꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠄꠇ-ꠡ ꠛꠤꠡ ꠛꠞꠍ ꠢꠣꠄꠀꠔ ꠖꠤꠀꠞ।” ");
INSERT INTO syls_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ꠅꠃ ꠙꠥꠠꠤꠘ꠆ꠔꠞ ꠟꠉꠦ ꠢꠃ ꠉꠣꠁꠛꠤ ꠡꠇ꠆ꠔꠤꠀꠟꠣ ꠅꠇꠟꠞ ꠝꠤꠟꠣ-ꠝꠤꠡꠣꠞ ꠇꠣꠞꠘꠦ ꠎꠦ ꠀꠅꠟꠣꠖꠞ ꠎꠘꠝ ꠅꠁꠟ, ꠔꠣꠞꠣ ꠀꠍꠟꠣ ꠙꠥꠞꠣꠘꠣ ꠎꠝꠣꠘꠣꠞ ꠙꠄꠟꠥꠀꠘ ꠅꠇꠟ। ꠢꠤ ꠡꠝꠄ ꠛꠣ ꠔꠣꠞ ꠛꠣꠖꠦꠅ ꠖꠥꠘꠤꠀꠁꠔ ꠘꠦꠚꠤꠟꠤ ꠎꠣꠔꠞ ꠝꠣꠘꠥꠡ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","ꠝꠣꠛꠥꠖꠦ ꠖꠦꠈꠟꠣ, ꠖꠥꠘꠤꠀꠁꠔ ꠝꠣꠘꠡꠞ ꠘꠣꠚꠞꠝꠣꠘꠤ ꠈꠥꠛ ꠛꠣꠠꠤ ꠉꠦꠍꠦ, ꠀꠞ ꠔꠣꠞꠣꠞ ꠖꠤꠟꠞ ꠈꠣꠁꠡ, ꠈꠤꠀꠟ-ꠈꠥꠡꠤ ꠈꠣꠟꠤ ꠈꠣꠞꠣꠙꠤꠞ ꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ꠁꠔꠣ ꠖꠦꠈꠤꠀ ꠝꠣꠛꠥꠖꠦ ꠈꠥꠛ ꠔꠇꠟꠤꠚ ꠙꠣꠁꠟꠣ, ꠔꠣꠁꠘ ꠖꠥꠘꠤꠀꠁꠔ ꠝꠣꠘꠥꠡ ꠙꠄꠖꠣ ꠇꠞꠍꠤꠟꠣ ꠇꠞꠤ ꠈꠥꠛ ꠛꠦꠎꠣꠞ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","ꠀꠞ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠙꠄꠖꠣ ꠇꠞꠣ ꠝꠣꠘꠡꠞꠦ, ꠀꠞ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠢꠇꠟ ꠎꠣꠔꠞ ꠎꠣꠘꠥꠀꠞ, ꠝꠣꠐꠤꠔ ꠌꠟꠞꠣ ꠢꠥꠞꠥ-ꠝꠥꠞꠥ ꠎꠣꠘꠖꠣꠞ ꠀꠞ ꠀꠍꠝꠣꠘꠞ ꠙꠣꠈꠤꠅ ꠈꠔꠝ ꠇꠞꠤ ꠖꠤꠝꠥ। ꠁꠔꠣꠞꠦ ꠙꠄꠖꠣ ꠇꠞꠤꠀ ꠀꠝꠣꠞ ꠖꠤꠟꠅ ꠖꠥꠈ ꠟꠣꠉꠦꠞ।” ");
INSERT INTO syls_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","ꠅꠁꠟꠦ ꠘꠥꠢꠞ ꠃꠙꠞꠦ ꠝꠣꠛꠥꠖ ꠈꠥꠡꠤ ꠀꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","ꠁꠔꠣ ꠅꠁꠟ ꠘꠥꠢꠞ ꠎꠤꠘ꠆ꠖꠦꠉꠤꠞ ꠛꠄꠀꠘ। ꠘꠥꠢ ꠄꠇꠎꠘ ꠇꠣꠝꠤꠟ ꠝꠣꠘꠥꠡ, ꠔꠣꠘ ꠀꠝꠟꠞ ꠝꠣꠘꠡꠞ ꠝꠣꠎꠦ ꠔꠣꠁꠘꠃ ꠀꠍꠟꠣ ꠙꠣꠇ-ꠙꠞꠦꠎꠉꠣꠞ। ꠀꠟ꠆ꠟꠣꠞ ꠟꠉꠦ ꠔꠣꠘꠞ ꠈꠣꠍ ꠖꠤꠖꠣꠞ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","ꠡꠣꠝ, ꠢꠣꠝ ꠀꠞ ꠁꠀꠚꠦꠔ ꠘꠣꠝꠞ ꠔꠣꠘ ꠔꠤꠘ ꠙꠥꠀ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","ꠁ ꠡꠝꠄ ꠀꠟ꠆ꠟꠣꠞ ꠌꠈꠥꠔ ꠢꠣꠞꠣ ꠖꠥꠘꠤꠀꠁ ꠉꠥꠘꠣꠄ ꠙꠌꠤ ꠉꠦꠍꠦ ꠀꠞ ꠎꠥꠞ-ꠎꠥꠟꠥꠝꠦ ꠜꠞꠤ ꠉꠦꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","ꠀꠟ꠆ꠟꠣꠄ ꠖꠥꠘꠤꠀꠞ ꠛꠣꠄ ꠌꠣꠁꠀ ꠖꠦꠈꠟꠣ, ꠁꠔꠣ ꠉꠥꠘꠣꠄ ꠙꠌꠤ ꠉꠦꠍꠦ। ꠇꠣꠞꠘ ꠖꠥꠘꠤꠀꠞ ꠝꠣꠘꠡꠞ ꠈꠣꠁꠍꠟꠔ ꠛꠦ-ꠙꠕꠦ ꠉꠦꠍꠦꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ꠁꠔꠣ ꠖꠦꠈꠤꠀ ꠀꠟ꠆ꠟꠣꠄ ꠘꠥꠢꠞꠦ ꠇꠁꠟꠣ, “ꠔꠣꠝꠣꠝ ꠝꠣꠘꠥꠡ ꠎꠣꠔꠞꠦ ꠀꠝꠤ ꠈꠔꠝ ꠇꠞꠤꠟꠣꠁꠔꠣꠝ ꠑꠤꠇ ꠇꠞꠍꠤ। ꠝꠣꠘꠡꠞ ꠟꠣꠉꠤ ꠖꠥꠘꠤꠀꠁ ꠎꠥꠞ-ꠎꠥꠟꠥꠝꠦ ꠜꠞꠤ ꠉꠦꠍꠦ। ꠝꠣꠘꠡꠞ ꠟꠉꠦ ꠟꠉꠦ ꠖꠥꠘꠤꠀꠞ ꠢꠇꠟꠔꠣ ꠀꠝꠤ ꠡꠦꠡ ꠇꠞꠤꠟꠤꠔꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","ꠔꠥꠝꠤ ꠉꠚꠞꠞ ꠔꠇ꠆ꠔꠣ ꠖꠤꠀ ꠔꠥꠝꠣꠞ ꠟꠣꠉꠤ ꠄꠇꠈꠣꠘ ꠎꠣꠎ ꠛꠣꠘꠣꠅ। ꠄꠞ ꠜꠤꠔꠞꠦ ꠀꠟꠉꠣ ꠀꠟꠉꠣ ꠇꠥꠑꠣ ꠕꠣꠇꠛ। ꠀꠞ ꠎꠣꠎꠞ ꠛꠣꠞꠦ-ꠜꠤꠔꠞꠦ ꠀꠟꠇꠣꠔꠞꠣ ꠟꠣꠉꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","ꠎꠣꠎꠈꠣꠘ ꠟꠣꠝ꠆ꠛꠣꠄ ꠔꠤꠘ-ꠡ ꠀꠔ, ꠙꠣꠡꠦ ꠙꠁꠘ꠆ꠌꠣꠡ ꠀꠔ ꠀꠞ ꠈꠣꠠꠣ-ꠃꠛꠤ ꠔꠤꠡ ꠀꠔ ꠛꠣꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","ꠀꠞ ꠌꠣꠟꠅ ꠕꠣꠇꠤ ꠄꠇ ꠀꠔ ꠔꠟꠦ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠈꠤꠠꠇꠤ ꠞꠣꠈꠛꠣꠄ, ꠀꠞ ꠖꠥꠀꠞ ꠖꠤꠛꠣꠄ ꠎꠣꠎꠞ ꠄꠇ ꠇꠣꠘ꠆ꠖꠣꠔ। ꠎꠣꠎꠈꠣꠘ ꠔꠤꠔꠣꠟꠣ ꠛꠣꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","ꠖꠦꠈꠤꠅ, ꠀꠝꠤ ꠖꠥꠘꠤꠀꠁꠔ ꠅꠟꠣ ꠛꠁꠘ꠆ꠘꠣ ꠖꠤꠝꠥ, ꠀꠍꠝꠣꠘꠞ ꠔꠟꠦ ꠎꠔ ꠎꠣꠘꠖꠣꠞꠦ ꠖꠝ ꠚꠣꠟꠣꠄ ꠢꠇꠟꠔꠣꠃ ꠛꠤꠘꠣꠡ ꠅꠁꠎꠤꠛ। ꠖꠥꠘꠤꠀꠁꠞ ꠢꠇꠟ ꠎꠣꠘꠖꠣꠞꠃ ꠝꠞꠤꠎꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","ꠈꠣꠟꠤ ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠀꠝꠣꠞ ꠅꠀꠖꠣ ꠎꠣꠞꠤ ꠞꠣꠈꠝꠥ। ꠔꠥꠝꠤ ꠉꠤꠀ ꠎꠣꠎꠅ ꠃꠑꠛꠣꠄ, ꠀꠞ ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠔꠥꠝꠣꠞ ꠙꠥꠀꠂꠘ, ꠔꠥꠝꠣꠞ ꠛꠤꠛꠤ ꠀꠞ ꠔꠥꠝꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠛꠃ-ꠅ। ");
INSERT INTO syls_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","ꠀꠞ ꠎꠣꠘ ꠛꠣꠌꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠤ ꠢꠇꠟ ꠎꠣꠔꠞ ꠎꠣꠘꠖꠣꠞꠞ ꠛꠦꠐꠣ-ꠛꠦꠐꠤꠞ ꠎꠥꠠꠣ ꠝꠤꠟꠣꠁꠀ ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠎꠣꠎꠅ ꠔꠥꠟꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","ꠙꠞꠔꠦꠇ ꠎꠣꠔꠞ ꠙꠣꠈꠤ, ꠢꠦꠝꠣꠘ-ꠎꠣꠘꠥꠀꠞ ꠀꠞ ꠝꠣꠐꠤꠞ ꠝꠣꠎꠦ ꠛꠥꠇꠦ ꠌꠟꠞꠣ ꠎꠣꠘꠖꠣꠞꠞꠦ ꠛꠣꠌꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠎꠥꠠꠣ ꠎꠥꠠꠣ ꠇꠞꠤ ꠔꠥꠝꠣꠞ ꠉꠦꠍꠦ ꠀꠘꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","ꠀꠞ ꠔꠥꠝꠤ ꠢꠇꠟ ꠎꠣꠔꠞ ꠟꠣꠉꠤ ꠈꠣꠘꠤꠞ ꠎꠤꠘꠤꠡ ꠎꠥꠉꠣꠠ ꠇꠞꠤ ꠞꠣꠈꠛꠣꠄ। ꠁꠔꠣ ꠔꠥꠝꠣꠞ ꠀꠞ ꠔꠣꠞꠣꠞ ꠈꠣꠘꠤ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","ꠘꠥꠢꠦ ꠀꠟ꠆ꠟꠣꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠢꠇꠟꠔꠣꠃ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠘꠥꠢꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠀꠞ ꠔꠥꠝꠣꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠢꠇꠟ ꠀꠁꠀ ꠎꠣꠎꠅ ꠃꠑꠛꠣꠄ। ꠀꠝꠤ ꠖꠦꠈꠤꠀꠞ ꠁ ꠎꠝꠣꠘꠣꠞ ꠝꠣꠘꠡꠞ ꠝꠣꠎꠦ ꠔꠥꠝꠤꠃ ꠈꠣꠟꠤ ꠖꠤꠘꠖꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","ꠔꠥꠝꠤ ꠢꠣꠟꠣꠟ ꠎꠣꠘꠥꠀꠞ ꠅꠇꠟ ꠕꠣꠇꠤ ꠘꠞ-ꠝꠦꠖꠤ ꠝꠤꠟꠣꠁꠀ ꠡꠣꠔ ꠎꠥꠠꠣ ꠇꠞꠤ ꠀꠞ ꠢꠣꠞꠣꠝ ꠎꠣꠘꠥꠀꠞ ꠕꠣꠇꠤ ꠄꠇ ꠎꠥꠠꠣ ꠇꠞꠤ ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠟꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ꠀꠍꠝꠣꠘꠅ ꠃꠠꠞꠣ ꠙꠣꠈꠤꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠘꠞ-ꠝꠦꠖꠤ ꠝꠤꠟꠣꠁꠀ ꠡꠣꠔ ꠎꠥꠠꠣ ꠇꠞꠤ ꠟꠁꠅ। ꠖꠥꠘꠤꠀꠞ ꠝꠣꠎꠦ ꠄꠞꠣꠞ ꠛꠋꠡ ꠛꠣꠌꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠁꠈꠣꠘ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","ꠀꠝꠤ ꠡꠣꠔ ꠖꠤꠘ ꠛꠣꠖꠦ ꠖꠥꠘꠤꠀꠁꠞ ꠃꠙꠞꠦ ꠌꠣꠟ꠆ꠟꠤꠡ ꠖꠤꠘ ꠌꠣꠟ꠆ꠟꠤꠡ ꠞꠣꠁꠔ ꠄꠇꠟꠣꠉꠣꠞꠦ ꠝꠦꠊ ꠖꠤꠝꠥ, ꠀꠞ ꠢꠇꠟ ꠎꠣꠘꠖꠣꠞꠞꠦ ꠖꠥꠘꠤꠀ ꠕꠣꠇꠤ ꠈꠔꠝ ꠇꠞꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠘꠥꠢꠦ ꠢꠇꠟ ꠇꠣꠝ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","ꠛꠁꠘ꠆ꠘꠣ ꠡꠥꠞꠥꠞ ꠡꠝꠄ ꠘꠥꠢꠞ ꠛꠄꠅꠡ ꠀꠍꠤꠟ ꠍꠄ-ꠡ ꠛꠞꠍ। ");
INSERT INTO syls_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","ꠛꠁꠘ꠆ꠘꠣ ꠕꠣꠇꠤ ꠛꠣꠌꠣꠞ ꠟꠣꠉꠤ ꠘꠥꠢ, ꠔꠣꠘ ꠛꠤꠛꠤ, ꠔꠣꠘ ꠙꠥꠀꠂꠘ ꠀꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠛꠃꠞꠦ ꠟꠁꠀ ꠎꠣꠎꠅ ꠉꠤꠀ ꠃꠑꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","ꠀꠟ꠆ꠟꠣꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠢꠣꠟꠣꠟ-ꠢꠣꠞꠣꠝ ꠎꠣꠘꠥꠀꠞ, ꠙꠣꠈꠤ, ꠛꠥꠇꠦ ꠌꠟꠞꠣ ꠎꠣꠘꠖꠣꠞꠞ ꠘꠞ-ꠝꠦꠖꠤ ꠝꠤꠟꠤꠀ ꠎꠥꠠꠣ ꠎꠥꠠꠣ ꠅꠁꠀ ꠘꠥꠢꠞ ꠉꠦꠍꠦ ꠀꠁꠀ ꠎꠣꠎꠅ ꠢꠣꠝꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ꠅꠃ ꠡꠣꠔ ꠖꠤꠘ ꠛꠣꠖꠦ ꠖꠥꠘꠤꠀꠁꠔ ꠛꠁꠘ꠆ꠘꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","ꠘꠥꠢꠞ ꠍꠄ-ꠡ ꠛꠍꠞꠞ ꠡꠝꠄ ꠖꠥꠍꠞꠣ ꠝꠣꠡꠞ ꠡꠔꠞ ꠔꠣꠞꠤꠈ ꠙꠣꠔꠣꠟꠞ ꠢꠇꠟ ꠙꠣꠘꠤ ꠛꠣꠞ ꠅꠁꠔ ꠟꠣꠉꠟ, ꠀꠞ ꠀꠍꠝꠣꠘ ꠎꠦꠘꠥ ꠚꠣꠐꠤ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","ꠌꠣꠟ꠆ꠟꠤꠡ ꠖꠤꠘ ꠌꠣꠟ꠆ꠟꠤꠡ ꠞꠣꠁꠔ ꠖꠥꠘꠤꠀꠁꠞ ꠃꠙꠞꠦ ꠝꠦꠊ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ꠎꠦꠖꠤꠘ ꠝꠦꠊ ꠡꠥꠞꠥ ꠅꠁꠟ, ꠁꠖꠤꠘ ꠘꠥꠢ, ꠔꠣꠘ ꠛꠤꠛꠤ, ꠔꠣꠘ ꠙꠥꠀꠂꠘ ꠡꠣꠝ, ꠢꠣꠝ, ꠁꠀꠚꠦꠔ ꠀꠞ ꠔꠣꠞꠣꠞ ꠛꠃ ꠅꠇꠟꠅ ꠎꠣꠎꠅ ꠀꠁꠀ ꠃꠑꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠎꠥꠠꠣ ꠎꠥꠠꠣ ꠇꠞꠤ ꠢꠇꠟ ꠎꠣꠔꠞ ꠎꠋꠟꠤ ꠎꠣꠘꠥꠀꠞ, ꠙꠣꠟꠣ ꠢꠦꠝꠣꠘ, ꠝꠣꠐꠤꠞ ꠝꠣꠎꠦ ꠛꠥꠇꠦ ꠌꠟꠞꠣ ꠎꠣꠘꠖꠣꠞ, ꠙꠣꠈꠤ ꠀꠞ ꠒꠣꠈꠘꠣ ꠀꠟꠣ ꠢꠇꠟꠔꠣꠅ ꠃꠑꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","ꠖꠝ ꠚꠣꠟꠣꠁꠀ ꠛꠣꠌꠦ ꠁꠟꠣ ꠢꠇꠟ ꠎꠣꠔꠞ ꠎꠣꠘꠖꠣꠞ ꠘꠥꠢꠞ ꠉꠦꠍꠦ ꠀꠁꠀ ꠎꠣꠎꠅ ꠃꠑꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","ꠀꠟ꠆ꠟꠣꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇꠃ ꠘꠞ-ꠝꠦꠖꠤꠞ ꠎꠥꠠꠣ ꠝꠤꠟꠤꠀ ꠔꠣꠞꠣ ꠃꠑꠍꠤꠟ। ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠎꠣꠎꠞ ꠖꠥꠀꠞ ꠛꠘ꠆ꠖ ꠇꠞꠤ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","ꠌꠣꠟ꠆ꠟꠤꠡ ꠖꠤꠘ ꠗꠞꠤ ꠖꠥꠘꠤꠀꠁꠔ ꠙꠣꠘꠤ ꠛꠣꠠꠔꠦꠃ ꠕꠣꠇꠟ। ꠙꠣꠘꠤ ꠛꠣꠠꠤ ꠎꠣꠅꠀꠄ ꠎꠣꠎꠈꠣꠘ ꠝꠣꠐꠤ ꠕꠣꠇꠤ ꠃꠙꠞꠦ ꠜꠣꠁꠀ ꠃꠑꠟ। ");
INSERT INTO syls_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","ꠛꠣꠖꠦ ꠙꠣꠘꠤ ꠈꠥꠛ ꠛꠣꠠꠟ ꠀꠞ ꠎꠣꠎꠈꠣꠘ ꠙꠣꠘꠤꠞ ꠃꠙꠞꠦ ꠌꠟꠣꠌꠟ ꠇꠞꠟ। ");
INSERT INTO syls_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","ꠀꠞ ꠙꠣꠘꠤ ꠛꠣꠠꠔꠦꠃ ꠕꠣꠇꠟ। ꠄꠞꠟꠣꠉꠤ ꠎꠦꠘꠅ ꠎꠔ ꠛꠠ ꠛꠠ ꠙꠣꠠ ꠀꠍꠤꠟ, ꠢꠇ꠆ꠇꠟꠔꠣ ꠛꠥꠠꠤ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","ꠢꠇꠟ ꠙꠣꠠ-ꠙꠞꠛꠔ ꠛꠥꠠꠤꠀ ꠙꠣꠘꠤ ꠀꠞꠅ ꠙꠘꠞ ꠀꠔ ꠃꠙꠞꠦ ꠃꠑꠟ। ");
INSERT INTO syls_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","ꠀꠞ ꠖꠥꠘꠤꠀꠁꠔ ꠌꠟꠞꠣ ꠢꠇꠟ ꠎꠣꠘꠖꠣꠞ, ꠝꠣꠘꠤ ꠙꠣꠈꠤ, ꠙꠣꠟꠣ ꠢꠦꠝꠣꠘ, ꠎꠋꠟꠤ ꠎꠣꠘꠥꠀꠞ ꠀꠞ ꠙꠣꠟ ꠛꠣꠘ꠆ꠖꠤꠀ ꠊꠥꠞꠞꠣ ꠢꠇꠟꠔꠣ, ꠝꠣꠘꠡꠞ ꠟꠉꠦ ꠛꠤꠘꠣꠡ ꠅꠁꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","ꠝꠣꠐꠤꠞ ꠃꠙꠞꠦ ꠎꠔ ꠞꠇꠝꠞ ꠎꠔ ꠎꠣꠘꠖꠣꠞ ꠖꠝ ꠚꠣꠟꠣꠁꠀ ꠛꠣꠌꠦ ꠁꠔꠣ ꠢꠇꠟꠔꠣꠃ ꠝꠞꠤꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","ꠀꠟ꠆ꠟꠣꠄ ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠎꠝꠤꠘꠞ ꠢꠇꠟ ꠎꠣꠘꠖꠣꠞ ꠖꠥꠘꠤꠀꠁꠞ ꠃꠙꠞ ꠕꠣꠇꠤ ꠚꠥꠍꠤꠟꠣꠁꠟꠣ। ꠄꠔꠦ ꠝꠣꠘꠥꠡ, ꠎꠣꠘꠥꠀꠞ, ꠛꠥꠇꠦ ꠌꠟꠞꠣ ꠎꠣꠘꠖꠣꠞ ꠀꠞ ꠀꠍꠝꠣꠘꠞ ꠙꠣꠈꠤ ꠖꠥꠘꠤꠀꠁ ꠕꠣꠇꠤ ꠍꠣꠚ ꠅꠁꠉꠦꠟ। ꠈꠣꠟꠤ ꠘꠥꠢ ꠀꠞ ꠔꠣꠘ ꠟꠉꠦ ꠎꠣꠞꠣ ꠀꠍꠤꠟ, ꠔꠣꠞꠣꠃ ꠛꠣꠌꠤꠀ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","ꠖꠥꠘꠤꠀ ꠖꠦꠠ-ꠡ ꠖꠤꠘ ꠙꠣꠘꠤꠔ ꠛꠥꠠꠣꠁꠟ ꠞꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ꠎꠣꠎꠅ ꠘꠥꠢ ꠀꠞ ꠔꠣꠘ ꠟꠉꠦ ꠎꠔ ꠎꠣꠘꠖꠣꠞ ꠀꠞ ꠙꠣꠟꠣ ꠢꠦꠝꠣꠘ ꠀꠍꠤꠟ, ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠞꠣꠞ ꠇꠕꠣꠅ ꠚꠣꠃꠞꠤꠟꠣ ꠘꠣ। ꠔꠣꠁꠘ ꠖꠥꠘꠤꠀꠁꠔ ꠛꠣꠔꠣꠡ ꠌꠣꠟꠣꠁꠟꠦ ꠙꠣꠘꠤ ꠇꠝꠣ ꠡꠥꠞꠥ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ꠝꠣꠐꠤꠞ ꠔꠟ ꠕꠣꠇꠤ ꠙꠣꠘꠤ ꠛꠣꠞꠘꠤ ꠀꠞ ꠀꠍꠝꠣꠘ ꠕꠘꠦ ꠝꠦꠊ ꠙꠠꠣꠞ ꠚꠣꠐꠣ ꠛꠘ꠆ꠖ ꠅꠁꠉꠦꠟ, ꠀꠞ ꠝꠦꠊꠅ ꠖꠝ ꠟꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","ꠝꠣꠐꠤꠞ ꠃꠙꠞꠞ ꠙꠣꠘꠤ ꠢꠞꠤ ꠉꠦꠟ, ꠀꠞ ꠖꠦꠠ-ꠡ ꠖꠤꠘ ꠛꠣꠖꠦ ꠖꠦꠈꠣ ꠉꠦꠟ ꠙꠣꠘꠤ ꠛꠃꠔ ꠇꠝꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠝꠣꠡꠞ ꠡꠔꠞ ꠔꠣꠞꠤꠈ ꠎꠣꠎꠈꠣꠘ ꠀꠞꠣꠞꠣꠔꠞ ꠙꠣꠠꠤ ꠄꠟꠣꠇꠣꠔ ꠉꠤꠀ ꠀꠐꠇꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","ꠄꠞꠛꠣꠖꠦꠅ ꠙꠣꠘꠤ ꠇꠝꠣꠔ ꠕꠣꠇꠟ, ꠀꠞ ꠖꠡ ꠘꠝ꠆ꠛꠞ ꠝꠣꠡꠞ ꠙꠄꠟꠣ ꠖꠤꠘ ꠙꠣꠠ ꠅꠇꠟꠞ ꠝꠣꠕꠣ ꠖꠦꠈꠣ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","ꠄꠞ ꠌꠣꠟ꠆ꠟꠤꠡ ꠖꠤꠘ ꠛꠣꠖꠦ ꠘꠥꠢꠦ ꠎꠣꠎꠞ ꠈꠤꠠꠇꠤ ꠈꠥꠟꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ꠀꠞ ꠈꠤꠠꠇꠤꠛꠣꠄ ꠄꠇ ꠇꠣꠃꠀ ꠍꠣꠠꠟꠣ। ꠝꠣꠐꠤ ꠕꠣꠇꠤ ꠙꠣꠘꠤ ꠘꠣ ꠢꠥꠇꠣꠘꠤ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠇꠣꠃꠀꠐꠣ ꠀꠅꠀ-ꠎꠣꠅꠀꠔ ꠞꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ꠝꠣꠐꠤꠞ ꠃꠙꠞ ꠕꠘꠦ ꠙꠣꠘꠤ ꠇꠝꠍꠦ ꠇꠤ ꠘꠣ ꠖꠦꠈꠣꠞ ꠟꠣꠉꠤ ꠘꠥꠢꠦ ꠛꠣꠖꠦ ꠄꠇꠐꠣ ꠙꠣꠞꠅ ꠍꠣꠠꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ꠁ ꠡꠝꠄꠅ ꠀꠡ꠆ꠔꠣ ꠖꠥꠘꠤꠀꠁꠔ ꠙꠣꠘꠤ ꠀꠍꠤꠟ ꠇꠞꠤ ꠙꠣꠅ ꠕꠁꠛꠣꠞ ꠎꠣꠉꠣ ꠘꠣ ꠙꠣꠁꠀ ꠙꠣꠞꠅꠐꠣ ꠢꠤꠞꠛꠣꠞ ꠚꠤꠞꠤꠀ ꠀꠁꠟ। ꠔꠣꠁꠘ ꠀꠔ ꠛꠣꠠꠣꠁꠀ ꠔꠣꠞꠦ ꠜꠤꠔꠞꠦ ꠀꠘꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","ꠢꠦꠡꠦ ꠔꠣꠁꠘ ꠀꠞꠅ ꠡꠣꠔ ꠖꠤꠘ ꠛꠣꠞ ꠌꠣꠁꠀ ꠢꠤꠞꠛꠣꠞ ꠔꠣꠞꠦ ꠍꠣꠠꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ꠢꠣꠁꠘ꠆ꠎꠣ ꠛꠣꠟꠣ ꠢꠦ ꠔꠣꠘ ꠉꠦꠍꠦ ꠚꠤꠞꠤꠀ ꠀꠁꠟ, ꠀꠞ ꠔꠣꠞ ꠑꠥꠐꠅ ꠀꠍꠤꠟ ꠎꠄꠔꠥꠘ ꠉꠣꠍꠞ ꠢꠣꠎꠝꠣ ꠙꠣꠔꠣ, ꠔꠣꠁꠘ ꠛꠥꠎꠟꠣ ꠝꠣꠐꠤꠞ ꠃꠙꠞ ꠕꠣꠇꠤ ꠙꠣꠘꠤ ꠇꠝꠤ ꠉꠦꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","ꠀꠞꠅ ꠡꠣꠔ ꠖꠤꠘ ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠢꠤꠞꠛꠣꠞ ꠙꠣꠞꠅꠐꠣ ꠍꠣꠠꠟꠣ, ꠁꠇꠐꠣ ꠀꠞ ꠚꠤꠞꠤꠀ ꠀꠁꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","ꠘꠥꠢꠞ ꠛꠄꠅꠡ ꠍꠄ-ꠡ ꠄꠇ ꠛꠍꠞꠞ ꠡꠝꠄ ꠙꠄꠟꠣ ꠝꠣꠡꠞ ꠙꠄꠟꠣ ꠖꠤꠘ ꠝꠣꠐꠤꠞ ꠃꠙꠞ ꠕꠣꠇꠤ ꠙꠣꠘꠤ ꠢꠞꠤ ꠉꠦꠟ, ꠀꠞ ꠘꠥꠢꠦ ꠎꠣꠎꠞ ꠌꠣꠟ ꠈꠥꠟꠤꠀ ꠌꠣꠁꠀ ꠖꠦꠈꠟꠣ, ꠝꠣꠐꠤ ꠢꠥꠇꠣꠘꠤ ꠗꠞꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","ꠖꠥꠍꠞꠣ ꠝꠣꠡꠞ ꠡꠣꠔꠣꠁꠡ ꠖꠤꠘꠞ ꠖꠤꠘ ꠝꠣꠐꠤ ꠄꠇꠁꠛꠣꠞꠦ ꠢꠥꠇꠣꠁ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠘꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“ꠔꠥꠝꠤ ꠔꠥꠝꠣꠞ ꠛꠤꠛꠤ, ꠔꠥꠝꠣꠞ ꠙꠥꠀꠂꠘ ꠀꠞ ꠔꠥꠝꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠛꠃꠞꠦ ꠟꠁꠀ ꠎꠣꠎ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁꠀ ꠀꠅ। ");
INSERT INTO syls_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","ꠀꠞ ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠎꠔ ꠎꠣꠔꠞ ꠎꠣꠘꠖꠣꠞ ꠀꠍꠦ - ꠙꠣꠈꠤ, ꠎꠣꠘꠥꠀꠞ ꠀꠞ ꠝꠣꠐꠤꠞ ꠝꠣꠎꠦ ꠛꠥꠇꠦ ꠌꠟꠞꠣ ꠎꠣꠘꠖꠣꠞ - ꠔꠣꠞꠣꠞꠦꠅ ꠛꠣꠞ ꠇꠞꠤ ꠟꠁꠀ ꠀꠅ, ꠎꠦꠘꠥ ꠢꠣꠞꠣ ꠖꠥꠘꠤꠀꠁ ꠎꠥꠠꠤ ꠔꠣꠞꠣ ꠍꠤꠔ꠆ꠞꠤꠀ ꠉꠤꠀ ꠚꠟꠀꠟꠣ ꠅꠁꠀ ꠛꠣꠠꠦ।” ");
INSERT INTO syls_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","ꠔꠦꠃ ꠘꠥꠢꠦ, ꠔꠣꠘ ꠛꠤꠛꠤ, ꠔꠣꠘ ꠙꠥꠀꠂꠘ ꠀꠞ ꠔꠣꠞꠣꠞ ꠛꠃꠞꠦ ꠟꠁꠀ ꠎꠣꠎ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠖꠥꠘꠤꠀꠁꠞ ꠢꠇꠟ ꠎꠣꠘꠥꠀꠞ, ꠝꠣꠐꠤꠔ ꠌꠟꠞꠣ ꠢꠥꠞꠥ-ꠝꠥꠞꠥ ꠎꠣꠘꠖꠣꠞ, ꠀꠞ ꠙꠣꠈꠤ, ꠄꠇ ꠇꠕꠣꠄ ꠖꠥꠘꠤꠀꠁꠔ ꠌꠟꠞꠣ ꠢꠇꠟ ꠎꠣꠘꠖꠣꠞ, ꠎꠣꠞꠎꠤꠞ ꠎꠣꠔꠝꠔ ꠛꠣꠞ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","ꠛꠣꠖꠦ ꠘꠥꠢꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠄꠇꠈꠣꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠁꠟꠣ, ꠀꠞ ꠙꠞꠔꠦꠇ ꠎꠣꠔꠞ ꠢꠣꠟꠣꠟ ꠙꠡꠥ-ꠙꠣꠈꠤ ꠕꠣꠇꠤ ꠄꠇ ꠄꠇꠐꠣ ꠟꠁꠀ ꠎꠛ ꠇꠞꠤꠀ, ꠎꠣꠟꠣꠁꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","ꠝꠣꠛꠥꠖ ꠁ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠈꠥꠡꠤ ꠅꠁꠟꠣ, ꠀꠞ ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠝꠣꠘꠡꠞ ꠟꠣꠉꠤ ꠀꠝꠤ ꠀꠞ ꠇꠥꠘꠥ ꠡꠝꠄꠅ ꠝꠣꠐꠤꠞꠦ ꠟꠣꠘ꠆ꠘꠔ ꠖꠤꠔꠣꠝ ꠘꠣꠄ, ꠎꠥꠖꠤꠅ ꠢꠥꠞꠥꠛꠣꠟꠣ ꠕꠣꠇꠤꠃ ꠝꠣꠘꠡꠞ ꠝꠘꠞ ꠈꠤꠀꠟ ꠈꠣꠞꠣꠙꠤꠞ ꠛꠣꠄ ꠕꠣꠇꠦ। ꠁꠚꠤꠞꠣ ꠎꠦꠟꠣ ꠢꠇꠟ ꠎꠣꠘꠖꠣꠞꠞꠦ ꠝꠣꠞꠍꠤ, ꠁꠟꠣꠈꠣꠘ ꠀꠞ ꠇꠥꠘꠥ ꠖꠤꠘꠃ ꠝꠣꠞꠔꠣꠝ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","ꠎꠔꠖꠤꠘ ꠁ ꠖꠥꠘꠤꠀꠁ ꠕꠣꠇꠛ, ꠅꠔꠖꠤꠘ ꠘꠤꠅꠝꠝꠔ ꠛꠤꠌ ꠚꠣꠟꠣꠘꠤ ꠀꠞ ꠚꠡꠟ ꠇꠣꠐꠣ, ꠑꠣꠘ꠆ꠒꠣ ꠀꠞ ꠉꠞꠝ, ꠛꠣꠞꠤꠡꠣ ꠀꠞ ꠄꠅꠔ, ꠖꠤꠘ ꠀꠞ ꠞꠣꠁꠔ ꠌꠟꠔꠦꠃ ꠕꠣꠇꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","ꠀꠟ꠆ꠟꠣꠄ ꠘꠥꠢ ꠀꠞ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠛꠞꠇꠔ ꠖꠤꠀ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤꠔꠣꠁꠘ ꠚꠟꠀꠟꠣ ꠅꠁꠀ ꠛꠣꠠꠤꠀ ꠖꠥꠘꠤꠀꠁ ꠜꠞꠤ ꠎꠣꠅ। ");
INSERT INTO syls_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","ꠖꠥꠘꠤꠀꠁꠞ ꠎꠣꠘꠥꠀꠞ, ꠀꠍꠝꠣꠘꠞ ꠙꠣꠈꠤ, ꠝꠣꠐꠤꠞ ꠝꠣꠎꠦ ꠛꠥꠇꠦ ꠌꠟꠞꠣ ꠎꠣꠘꠖꠣꠞ ꠀꠞ ꠖꠞꠤꠀꠞ ꠝꠣꠍ, ꠢꠇꠟꠦꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠒꠞ-ꠜꠄ ꠇꠞꠤ ꠌꠟꠛ। ꠁꠔꠣꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠀꠔꠅ ꠖꠦꠅꠀ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","ꠎꠦꠟꠣ ꠔꠥꠝꠞꠣꠞꠦ ꠈꠦꠔꠞ ꠚꠟ-ꠚꠡꠟ ꠀꠞ ꠔꠞꠤ-ꠔꠞꠇꠣꠞꠤ ꠖꠤꠍꠟꠣꠝ, ꠅꠃꠟꠣ ꠅꠈꠘ ꠎꠤꠔꠣ ꠎꠣꠘꠖꠣꠞ ꠢꠇꠟꠞꠦꠅ ꠔꠥꠝꠞꠣꠞ ꠈꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠖꠤꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","ꠈꠣꠟꠤ ꠟꠃ ꠡꠢ ꠉꠥꠡ꠆ꠔ ꠔꠥꠝꠞꠣ ꠈꠣꠁꠅ ꠘꠣ, ꠟꠃ ꠅꠁꠟꠉꠤ ꠎꠣꠘ। ");
INSERT INTO syls_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","ꠇꠦꠃ ꠎꠥꠖꠤ ꠝꠣꠘꠡꠞꠦ ꠈꠥꠘ ꠇꠞꠦ ꠔꠦ ꠀꠝꠤ ꠅꠛꠡ꠆ꠡꠃ ꠔꠣꠞ ꠈꠥꠘꠞ ꠛꠖꠟꠣ ꠟꠁꠝꠥ। ꠢꠦ ꠎꠣꠘꠥꠀꠞ ꠅꠃꠇ ꠛꠣ ꠝꠣꠘꠥꠡ ꠅꠃꠇ, ꠝꠣꠘꠡꠞ ꠎꠣꠘ ꠎꠦ ꠘꠦꠄ, ꠔꠣꠞ ꠎꠣꠘꠅ ꠖꠦꠅꠘ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","ꠝꠣꠘꠡꠞ ꠟꠃ ꠎꠦ ꠛꠣꠞ ꠇꠞꠦ, ꠝꠣꠘꠡꠦꠅ ꠔꠣꠞ ꠟꠃ ꠛꠣꠞ ꠇꠞꠛ, ꠇꠣꠞꠘ ꠀꠟ꠆ꠟꠣꠄ ꠝꠣꠘꠡꠞꠦ ꠘꠤꠎꠞ ꠍꠥꠞꠔꠦ ꠛꠣꠘꠣꠁꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","ꠔꠥꠝꠤꠔꠣꠁꠘ ꠛꠦꠡ ꠇꠞꠤ ꠚꠟꠀꠟꠣ ꠅꠁꠀ ꠛꠣꠠꠅ ꠀꠞ ꠖꠥꠘꠤꠀꠁꠔ ꠍꠤꠔ꠆ꠞꠤꠀ ꠎꠣꠅ।” ");
INSERT INTO syls_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","ꠛꠣꠖꠦ ꠀꠟ꠆ꠟꠣꠄ ꠘꠥꠢ ꠀꠞ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“ꠢꠥꠘꠅ, ꠀꠝꠤ ꠎꠛꠣꠘ ꠖꠤꠀꠞ, ꠔꠥꠝꠞꠣ ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠖꠞ ꠢꠇꠟ ꠝꠣꠘꠡꠞꠦ, ");
INSERT INTO syls_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ꠀꠞ ꠙꠣꠈꠤ, ꠙꠣꠟꠣ ꠢꠦꠝꠣꠘ ꠀꠞ ꠖꠥꠘꠤꠀꠁꠞ ꠎꠔ ꠎꠣꠘꠥꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠎꠣꠎ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁꠍꠦ, ꠔꠣꠞꠣꠞꠦꠅ। ");
INSERT INTO syls_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","ꠎꠛꠣꠘꠐꠣ ꠅꠁꠟ, ꠛꠣꠘꠞ ꠙꠣꠘꠤ ꠖꠤꠀ ꠀꠞ ꠇꠥꠘꠥ ꠡꠝꠄꠃ ꠢꠇ꠆ꠇꠟ ꠎꠣꠘꠖꠣꠞꠞꠦ ꠝꠣꠞꠣ ꠅꠁꠔ ꠘꠣꠄ, ꠀꠞ ꠔꠣꠝꠣꠝ ꠖꠥꠘꠤꠀꠁ ꠍꠣꠚ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠁꠟꠣ ꠇꠥꠘꠥ ꠛꠣꠘꠅ ꠅꠁꠔ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","ꠀꠟ꠆ꠟꠣꠄ ꠀꠞꠅ ꠇꠁꠟꠣ, “ꠎꠦ ꠎꠛꠣꠘ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠞ ꠎꠣꠘꠖꠣꠞ ꠅꠇꠟꠞꠦ ꠖꠤꠟꠣꠝ, ꠁꠇꠐꠣ ꠇꠤꠀꠝꠔ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠛꠅꠀꠁꠟ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ꠀꠞ ꠝꠦꠊꠞ ꠇꠣꠟꠘꠤꠞ ꠝꠣꠎꠦ ꠀꠝꠣꠞ ꠞꠋꠗꠦꠘꠥ ꠖꠤꠟꠣꠝ, ꠁꠇꠐꠣ ꠅꠁꠟ ꠖꠥꠘꠤꠀꠁꠔ ꠀꠝꠣꠞ ꠎꠛꠣꠘꠞ ꠘꠤꠡꠣꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","ꠎꠦꠛꠟꠣ ꠀꠝꠤ ꠖꠥꠘꠤꠀꠁꠞ ꠃꠙꠞꠦ ꠇꠣꠟꠘꠤ ꠖꠤꠝꠥ, ꠁ ꠡꠝꠄ ꠅꠃ ꠞꠋꠗꠦꠘꠥ ꠖꠦꠈꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ꠀꠞ ꠅꠃ ꠡꠝꠄꠃ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠀꠞ ꠢꠇꠟ ꠎꠣꠘꠖꠣꠞꠞ ꠟꠉꠦ ꠀꠝꠣꠞ ꠎꠛꠣꠘꠞ ꠇꠕꠣ ꠁꠀꠖ ꠇꠞꠝꠥ। ꠀꠞ ꠇꠥꠘꠥ ꠡꠝꠄꠃ ꠛꠁꠘ꠆ꠘꠣ ꠅꠁꠀ ꠢꠇꠟ ꠎꠣꠘꠖꠣꠞꠞꠦ ꠙꠣꠘꠤ ꠖꠤꠀ ꠗꠁꠀ ꠘꠤꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","ꠇꠣꠟꠘꠤꠞ ꠝꠣꠎꠦ ꠎꠦꠛꠟꠣ ꠢꠤ ꠞꠋꠗꠦꠘꠥ ꠖꠦꠈꠣ ꠎꠣꠁꠛ ꠅꠃ ꠡꠝꠄ ꠀꠝꠤ ꠖꠥꠘꠤꠀꠁꠞ ꠢꠇꠟ ꠎꠣꠘꠖꠣꠞꠞ ꠟꠉꠦ ꠀꠝꠣꠞ ꠁ ꠢꠣꠝꠦꠡꠣꠇꠥꠞ ꠎꠛꠣꠘꠞ ꠇꠕꠣ ꠁꠀꠖ ꠇꠞꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","ꠢꠦꠡꠦ ꠀꠟ꠆ꠟꠣꠄ ꠘꠥꠢꠞꠦ ꠇꠁꠟꠣ, “ꠖꠥꠘꠤꠀꠁꠞ ꠢꠇꠟ ꠎꠣꠘꠖꠣꠞꠞ ꠟꠉꠦ ꠀꠝꠤ ꠎꠦ ꠎꠛꠣꠘ ꠖꠤꠍꠤ, ꠁꠇꠐꠣ ꠅꠁꠟ ꠔꠣꠞ ꠘꠤꠡꠣꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","ꠎꠣꠎ ꠕꠘꠦ ꠘꠥꠢꠞ ꠎꠦ ꠙꠥꠀꠂꠘ ꠛꠣꠞ ꠅꠁꠍꠟꠣ, ꠔꠣꠞꠣꠞ ꠘꠣꠝ ꠅꠁꠟ ꠡꠣꠝ, ꠢꠣꠝ ꠀꠞ ꠁꠀꠚꠦꠔ। ꠅꠃ ꠢꠣꠝ ꠅꠁꠟ ꠇꠦꠘꠣꠘꠞ ꠛꠣꠚ। ");
INSERT INTO syls_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","ꠘꠥꠢꠞ ꠅꠃ ꠔꠤꠘꠅ ꠙꠥꠀꠞ ꠈꠣꠘ꠆ꠖꠣꠘ ꠅꠇꠟ ꠢꠣꠞꠣ ꠖꠥꠘꠤꠀꠁꠔ ꠍꠤꠔ꠆ꠞꠤ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","ꠘꠥꠢꠦ ꠈꠦꠔ-ꠈꠣꠝꠣꠞ ꠡꠥꠞꠥ ꠇꠞꠤꠀ ꠄꠇ ꠀꠋꠉꠥꠞ-ꠈꠦꠔ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","ꠀꠞ ꠀꠋꠉꠥꠞꠞ ꠡꠞꠣꠛ ꠈꠣꠁꠀ ꠐꠣꠟ ꠅꠁꠀ ꠔꠣꠝ꠆ꠛꠥꠞ ꠜꠤꠔꠞꠦ ꠃꠖꠣꠝ ꠅꠁꠀ ꠙꠠꠤ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","ꠇꠦꠘꠣꠘꠞ ꠛꠣꠚ ꠢꠣꠝꠦ ꠀꠁꠀ ꠔꠣꠞ ꠛꠣꠚꠞ ꠅꠃ ꠢꠣꠟ ꠖꠦꠈꠤꠀ ꠛꠣꠞꠦ ꠉꠤꠀ ꠔꠣꠞ ꠖꠥꠁꠅ ꠜꠣꠁꠞ ꠉꠦꠍꠦ ꠇꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","ꠅꠁꠟꠦ ꠡꠣꠝ ꠀꠞ ꠁꠀꠚꠦꠔꠦ ꠇꠣꠘ꠆ꠖꠅ ꠇꠞꠤ ꠄꠇꠈꠣꠘ ꠇꠣꠙꠠ ꠟꠁꠀ ꠙꠤꠍꠦ ꠀꠐꠤꠀ ꠛꠣꠚꠞꠦ ꠅꠃ ꠇꠣꠙꠠꠖꠤ ꠉꠥꠞꠤꠀ ꠖꠤꠟꠣ, ꠔꠣꠞꠣꠞ ꠌꠃꠈ ꠃꠟꠐꠣꠛꠣꠄ ꠕꠣꠇꠣꠄ ꠛꠣꠚꠞꠦ ꠛꠦ-ꠀꠛꠞꠥ ꠢꠣꠟꠔꠦ ꠖꠦꠈꠟꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","ꠘꠤꠡꠣ ꠇꠝꠤ ꠎꠣꠅꠀꠞ ꠛꠣꠖꠦ ꠘꠥꠢꠦ ꠔꠣꠘ ꠙꠥꠀꠞ ꠇꠣꠘ꠆ꠒ ꠢꠥꠘꠤꠀ ");
INSERT INTO syls_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ꠇꠁꠟꠣ, “ꠇꠦꠘꠣꠘꠞ ꠃꠙꠞꠦ ꠟꠣꠘ꠆ꠘꠔ ꠙꠠꠃꠇ, ꠢꠦ ꠔꠣꠞ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞ ꠉꠦꠍꠦ ꠉꠥꠟꠣꠝꠞ ꠉꠥꠟꠣꠝ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ꠔꠣꠁꠘ ꠀꠞꠅ ꠇꠁꠟꠣ, “ꠢꠇꠟ ꠔꠣꠞꠤꠚ ꠡꠣꠝꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ, ꠇꠦꠘꠣꠘ ꠡꠣꠝꠞ ꠉꠥꠟꠣꠝ ꠅꠃꠇ। ");
INSERT INTO syls_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","ꠀꠟ꠆ꠟꠣꠄ ꠁꠀꠚꠦꠔꠞꠦ ꠛꠃꠔꠔꠣ ꠖꠦꠃꠇ꠆ꠇꠣ, ꠢꠦ ꠡꠣꠝꠞ ꠔꠣꠝ꠆ꠛꠥꠔ ꠕꠣꠇꠃꠇ, ꠀꠞ ꠇꠦꠘꠣꠘ ꠔꠣꠞ ꠉꠥꠟꠣꠝ ꠅꠃꠇ।” ");
INSERT INTO syls_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","ꠛꠣꠘꠞ ꠛꠣꠖꠦ ꠘꠥꠢ ꠀꠞꠅ ꠡꠣꠠꠦ ꠔꠤꠘ-ꠡ ꠛꠞꠍ ꠛꠣꠌꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","ꠝꠥꠐ ꠡꠣꠠꠦ ꠘꠄ-ꠡ ꠛꠞꠍ ꠛꠄꠅꠡꠅ ꠔꠣꠁꠘ ꠝꠣꠞꠣ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","ꠘꠥꠢꠞ ꠙꠥꠀꠂꠘ ꠡꠣꠝ, ꠢꠣꠝ, ꠀꠞ ꠁꠀꠚꠦꠔꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠛꠄꠀꠘ। ꠛꠣꠘꠞ ꠛꠣꠖꠦ ꠔꠣꠞꠣꠞ ꠙꠥꠀ-ꠙꠥꠠꠤ ꠅꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","ꠁꠀꠚꠦꠔꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠘꠣꠝ: ꠉꠥꠝꠞ, ꠝꠣꠎꠥꠎ, ꠝꠣꠖꠄ, ꠁꠀꠛꠣꠘ, ꠔꠥꠛꠟ, ꠝꠦꠡꠇ ꠀꠞ ꠔꠤꠞꠡ। ");
INSERT INTO syls_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","ꠉꠥꠝꠞꠞ ꠙꠥꠀꠂꠘ: ꠅꠡ꠆ꠇꠤꠘꠡ, ꠞꠤꠚꠔ ꠀꠞ ꠔꠥꠉꠞ꠆ꠝ। ");
INSERT INTO syls_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","ꠁꠀꠛꠣꠘꠞ ꠙꠥꠀꠂꠘ ꠅꠁꠟꠣ: ꠁꠟꠤꠡꠣꠢ, ꠔꠞ꠆ꠡꠤꠡ, ꠇꠤꠔ꠆ꠔꠤꠝ ꠀꠞ ꠞꠥꠖꠣꠘꠤꠝ। ");
INSERT INTO syls_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","ꠄꠞꠣꠞ ꠛꠋꠡꠞ ꠝꠣꠘꠡꠦ ꠘꠣꠘꠣꠘ ꠎꠣꠔꠞ ꠝꠣꠔ-ꠇꠕꠣ, ꠙꠞꠤꠛꠣꠞ ꠀꠞ ꠎꠣꠔ ꠢꠤꠡꠣꠛꠦ ꠖꠞꠤꠀꠞ ꠙꠣꠞꠞ ꠘꠣꠘꠣꠘ ꠖꠦꠡꠅ ꠍꠤꠔ꠆ꠞꠤ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","ꠢꠣꠝꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠘꠣꠝ: ꠇꠥꠡ, ꠝꠤꠡꠞ, ꠙꠥꠐ ꠀꠞ ꠇꠦꠘꠣꠘ। ");
INSERT INTO syls_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","ꠇꠥꠡꠞ ꠙꠥꠀꠂꠘ: ꠍꠛꠣ, ꠢꠛꠤꠟꠣ, ꠍꠙ꠆ꠔꠣ, ꠞꠄꠝꠣ ꠀꠞ ꠍꠙ꠆ꠔꠇꠣ। ꠞꠄꠝꠣꠞ ꠙꠥꠀꠂꠘ ꠅꠁꠟꠣ: ꠡꠣꠛꠣ ꠀꠞ ꠖꠖꠣꠘ। ");
INSERT INTO syls_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","ꠇꠥꠡꠞ ꠄꠇ ꠙꠥꠀꠞ ꠘꠣꠝ ꠀꠍꠤꠟ ꠘꠝꠞꠥꠖ। ꠅꠃ ꠘꠝꠞꠥꠖ ꠖꠥꠘꠤꠀꠁꠔ ꠙꠄꠟꠥꠀꠘ ꠅꠁꠀ ꠃꠑꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍꠦ ꠢꠦ ꠀꠍꠤꠟ ꠙꠄꠟꠥꠀꠘ ꠡꠤꠇꠣꠞꠤ। ꠄꠞꠟꠣꠉꠤ ꠒꠣꠇꠞ ꠇꠕꠣ ꠀꠍꠦ, ꠝꠣꠘꠥꠡꠐꠣ ꠎꠦꠘ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠘꠝꠞꠥꠖꠞ ꠟꠣꠈꠣꠘ ꠙꠄꠟꠥꠀꠘ ꠡꠤꠇꠣꠞꠤ। ");
INSERT INTO syls_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","ꠡꠤꠘꠣꠞ ꠖꠦꠡꠞ ꠛꠣꠛꠤꠟ, ꠄꠞꠇ, ꠅꠇ꠆ꠇꠖ ꠀꠞ ꠇꠟꠘꠤ ꠘꠣꠝꠞ ꠐꠣꠃꠘ ꠅꠇꠟ ꠟꠁꠀ ꠢꠦ ꠛꠣꠖꠡꠣꠁ ꠡꠥꠞꠥ ꠇꠞꠟ। ");
INSERT INTO syls_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","ꠅꠘ ꠕꠣꠇꠤ ꠔꠣꠞ ꠞꠣꠁꠎ꠆ꠎ ꠛꠣꠠꠤꠀ ꠀꠡꠤꠞꠤꠀ ꠖꠦꠡ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠉꠦꠟ। ꠢꠈꠣꠘꠞ ꠘꠤꠘꠜ, ꠞꠢꠛꠔꠙꠥꠞ, ꠇꠦꠟꠢ ");
INSERT INTO syls_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ꠀꠞ ꠞꠦꠡꠘ ꠘꠣꠝꠞ ꠐꠣꠃꠘ ꠅꠇꠟꠅ ꠔꠣꠞ ꠛꠣꠘꠣꠁꠟ। ꠞꠦꠡꠘ ꠀꠍꠤꠟ ꠘꠤꠘꠜ ꠀꠞ ꠇꠦꠟꠢꠞ ꠝꠣꠎꠈꠣꠘꠅ, ꠁ ꠔꠤꠘꠐꠣꠄ ꠝꠤꠟꠤꠀ ꠄꠇ ꠛꠤꠞꠣꠐ ꠡꠢꠞ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","ꠝꠤꠡꠞꠞ ꠛꠋꠡ ꠅꠁꠟꠣ ꠅꠃ ꠎꠣꠔ ꠅꠇꠟ: ꠟꠥꠖꠤ, ꠅꠘꠣꠝꠤ, ꠟꠢꠣꠛꠤ, ꠘꠙ꠆ꠔꠥꠢꠤ, ");
INSERT INTO syls_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ꠙꠕ꠆ꠞꠥꠡꠤ, ꠇꠡꠟꠥꠢꠤ, ꠀꠞ ꠇꠙ꠆ꠔꠥꠞꠤ, ꠅꠃ ꠇꠙ꠆ꠔꠥꠞ ꠖꠤꠙ ꠕꠣꠇꠤ ꠚꠤꠟꠤꠡ꠆ꠔꠤꠘꠤ ꠅꠇꠟ ꠛꠣꠞ ꠅꠁꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","ꠇꠦꠘꠣꠘꠞ ꠛꠠ ꠙꠥꠀ ꠍꠤꠖꠘ, ꠛꠣꠖꠞ ꠙꠥꠀ ꠢꠤꠐ, ꠢꠤꠐ꠆ꠐꠤ ꠎꠣꠔꠤꠞ ꠝꠥꠟ ꠛꠣꠚ। ");
INSERT INTO syls_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ꠇꠦꠘꠣꠘ ꠀꠍꠟꠣ ꠎꠤꠛꠥꠎꠤ, ꠀꠝꠥꠞꠤ, ꠉꠤꠞ꠆ꠉꠣꠡꠤ, ");
INSERT INTO syls_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ꠢꠤꠛ꠆ꠛꠤ, ꠀꠞ꠆ꠇꠤ, ꠍꠤꠘꠤ, ");
INSERT INTO syls_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ꠀꠞ꠆ꠛꠣꠖꠤ, ꠎꠝꠣꠞꠤ ꠀꠞ ꠢꠣꠝꠣꠔꠤ, ꠅꠃ ꠎꠣꠔꠤ ꠅꠇꠟꠞ ꠝꠥꠟ ꠛꠣꠚ। ꠢꠦꠡꠦ ꠅꠃ ꠇꠦꠘꠣꠘꠤ ꠅꠇꠟ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠍꠤꠔ꠆ꠞꠤ ꠉꠦꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ꠍꠤꠖꠘ ꠐꠣꠃꠘ ꠕꠣꠇꠤ ꠉꠦꠞꠣꠞꠞ ꠝꠥꠈꠣ ꠉꠣꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ, ꠀꠞ ꠉꠣꠎꠣ ꠕꠣꠇꠤ ꠍꠣꠖꠥꠝ, ꠀꠝꠥꠞꠣ, ꠅꠖꠝꠣ ꠀꠞ ꠍꠛꠂꠁꠝ ꠎꠣꠅꠀꠞ ꠙꠕꠦ ꠟꠣꠡꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠇꠦꠘꠣꠘꠤ ꠅꠇꠟꠞ ꠞꠣꠎꠔ꠆ꠔ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","ꠙꠞꠤꠛꠣꠞ, ꠝꠣꠔ-ꠇꠕꠣ, ꠖꠦꠡ ꠀꠞ ꠎꠣꠔ ꠢꠤꠡꠣꠛꠦ ꠄꠞꠣ ꠀꠍꠤꠟ ꠢꠣꠝꠞ ꠈꠣꠘ꠆ꠖꠣꠘ। ");
INSERT INTO syls_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","ꠁꠀꠚꠦꠔꠞ ꠛꠠ ꠜꠣꠁ ꠡꠣꠝꠞꠅ ꠙꠥꠀ-ꠙꠥꠠꠤꠘ ꠅꠁꠍꠟꠣ। ꠡꠣꠝ ꠅꠁꠟꠣ ꠀꠛꠦꠞ ꠀꠞ ꠔꠣꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠛꠣꠚ। ");
INSERT INTO syls_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","ꠡꠣꠝꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠘꠣꠝ: ꠁꠟꠣꠝ, ꠀꠡꠥꠞ, ꠀꠞ꠆ꠚꠣꠇꠍꠣꠖ, ꠟꠥꠖ ꠀꠞ ꠅꠞꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","ꠅꠞꠣꠝꠞ ꠙꠥꠀꠂꠘ: ꠃꠎ, ꠢꠥꠟ, ꠉꠦꠕꠞ ꠀꠞ ꠝꠡ। ");
INSERT INTO syls_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","ꠀꠞ꠆ꠚꠣꠇꠍꠣꠖꠞ ꠙꠥꠀ ꠡꠣꠟꠦꠈ, ꠀꠞ ꠡꠣꠟꠦꠈꠞ ꠙꠥꠀꠞ ꠘꠣꠝ ꠀꠛꠦꠞ। ");
INSERT INTO syls_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ꠀꠛꠦꠞꠞ ꠖꠥꠁ ꠙꠥꠀ ꠅꠁꠍꠟꠣ, ꠄꠇꠎꠘꠞ ꠘꠣꠝ ꠚꠣꠟꠦꠎ ꠝꠣꠘꠤ, ꠀꠟꠉꠣ, ꠔꠣꠘ ꠡꠝꠄ ꠖꠥꠘꠤꠀ ꠀꠟꠉ ꠅꠁꠍꠤꠟ ꠇꠞꠤ ꠔꠣꠘ ꠅꠃ ꠘꠣꠝ ꠅꠁꠟ। ꠚꠣꠟꠦꠎꠞ ꠜꠣꠁꠞ ꠘꠣꠝ ꠁꠀꠇꠔꠣꠘ। ");
INSERT INTO syls_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","ꠁꠀꠇꠔꠣꠘꠞ ꠙꠥꠀꠂꠘ ꠅꠁꠟꠣ: ꠅꠟꠝꠥꠖꠖ, ꠡꠦꠟꠚ, ꠢꠣꠎꠞꠣꠝꠣꠅꠔ, ꠎꠦꠞꠢ, ");
INSERT INTO syls_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ꠢꠖꠥꠞꠣꠝ, ꠃꠎꠣꠟ, ꠖꠤꠇ꠆ꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ꠅꠛꠟ, ꠅꠛꠤꠝꠣꠁꠄꠟ, ꠡꠣꠛꠣ, ");
INSERT INTO syls_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ꠅꠚꠤꠞ, ꠢꠛꠤꠟꠣ ꠀꠞ ꠎꠥꠛꠛ। ꠄꠞꠣ ꠢꠇꠟ ꠅꠁꠟꠣ ꠁꠀꠇꠔꠣꠘꠞ ꠙꠥꠀꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","ꠝꠦꠡꠣ ꠕꠣꠇꠤ ꠙꠥꠛꠦꠖꠤ ꠍꠦꠚꠣꠞꠅ ꠎꠣꠅꠀꠞ ꠙꠕꠅ ꠎꠦ ꠙꠣꠠꠤ ꠎꠣꠉꠣ ꠀꠍꠦ, ꠅꠘꠅ ꠔꠣꠞꠣ ꠕꠣꠇꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","ꠙꠞꠤꠛꠣꠞ, ꠝꠣꠔ-ꠇꠕꠣ, ꠖꠦꠡ, ꠀꠞ ꠎꠣꠔ ꠢꠤꠡꠣꠛꠦ ꠄꠞꠣ ꠅꠁꠟꠣ ꠡꠣꠝꠞ ꠈꠣꠘ꠆ꠖꠣꠘ। ");
INSERT INTO syls_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","ꠎꠣꠔ ꠀꠞ ꠛꠋꠡ ꠢꠤꠡꠣꠛꠦ ꠄꠞꠣ ꠅꠁꠟ ꠘꠥꠢꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠙꠞꠤꠛꠣꠞ। ꠛꠣꠘꠞ ꠛꠣꠖꠦ ꠄꠞꠣꠞ ꠛꠋꠡ ꠅꠇꠟꠦ ꠘꠣꠘꠣꠘ ꠎꠣꠔ ꠅꠁꠀ ꠀꠡ꠆ꠔꠣ ꠖꠥꠘꠤꠀꠁꠔ ꠍꠤꠔ꠆ꠞꠤ ꠉꠦꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ꠢꠤ ꠎꠝꠣꠘꠣꠔ ꠀꠡ꠆ꠔꠣ ꠖꠥꠘꠤꠀꠁꠔ ꠈꠣꠟꠤ ꠄꠇ ꠜꠣꠡꠣꠄ ꠝꠣꠔꠔꠣ, ꠀꠞ ꠔꠣꠞꠣꠞ ꠛꠥꠟꠤ ꠅꠇꠟꠅ ꠄꠇꠟꠣꠈꠣꠘꠃ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ꠔꠣꠞꠣ ꠙꠥꠛꠦꠖꠤ ꠀꠉꠥꠀꠁꠀ ꠎꠣꠁꠔꠦ ꠎꠣꠁꠔꠦ ꠡꠤꠘꠣꠞ ꠖꠦꠡꠞ ꠄꠇ ꠢꠝꠣꠘ ꠎꠣꠉꠣ ꠙꠣꠁꠀ ꠢꠈꠣꠘꠅꠃ ꠛꠡꠔ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","ꠔꠣꠞꠣ ꠄꠇꠦ-ꠅꠁꠘ꠆ꠘꠞꠦ ꠇꠁꠟ, “ꠀꠅ, ꠀꠝꠞꠣ ꠁꠐ ꠛꠣꠘꠣꠁꠀ ꠀꠉꠥꠁꠘꠖꠤ ꠎꠣꠟꠣꠁ।” ꠇꠁꠀꠃ ꠔꠣꠞꠣ ꠙꠣꠔ꠆ꠔꠞꠞ ꠛꠖꠟꠣ ꠁꠐ ꠀꠞ ꠌꠥꠘ-ꠡꠥꠞꠇꠤꠞ ꠛꠖꠟꠣ ꠔꠣꠞꠔꠦꠟ ꠟꠣꠉꠣꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ꠔꠣꠞꠣ ꠀꠞꠅ ꠇꠁꠟ, “ꠀꠅ, ꠀꠝꠞꠣꠞ ꠘꠤꠎꠞ ꠟꠣꠉꠤ ꠄꠇꠐꠣ ꠡꠢꠞ ꠛꠣꠘꠣꠁ, ꠀꠞ ꠅꠃꠟꠣ ꠄꠇꠐꠣ ꠊꠞꠅ ꠛꠣꠘꠣꠁ, ꠎꠦꠇꠐꠣꠞ ꠝꠤꠘꠣꠞ ꠉꠤꠀ ꠀꠍꠝꠣꠘ ꠟꠣꠉꠣꠟ ꠙꠣꠁꠛ। ꠔꠦꠃ ꠀꠝꠞꠣꠞ ꠘꠣꠝꠅ ꠅꠁꠛ ꠀꠞ ꠀꠝꠞꠣ ꠖꠥꠘꠤꠀꠁꠔ ꠍꠤꠔ꠆ꠞꠤꠔꠣꠝꠅ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","ꠝꠣꠘꠡꠦ ꠎꠦ ꠃꠌꠣ ꠊꠞ ꠀꠞ ꠡꠢꠞ ꠛꠣꠘꠣꠁꠞꠣ ꠁꠇꠐꠣ ꠖꠦꠈꠣꠔ ꠝꠣꠛꠥꠖ ꠟꠣꠝꠤ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","ꠀꠞ ꠇꠁꠟꠣ, “ꠄꠞꠣ ꠄꠇ ꠎꠣꠔꠞ ꠝꠣꠘꠥꠡ, ꠄꠞꠣꠞ ꠝꠣꠔ-ꠇꠕꠣꠅ ꠄꠇ; ꠄꠞꠟꠣꠉꠤ ꠔꠣꠞꠣ ꠅꠃ ꠇꠣꠝꠞ ꠝꠣꠎꠦ ꠀꠔ ꠖꠤꠍꠦ। ꠘꠤꠎꠞ ꠝꠔꠟꠛ ꠢꠣꠍꠤꠟꠞ ꠟꠣꠉꠤ ꠄꠞꠣ ꠀꠞ ꠇꠥꠘꠥ ꠛꠣꠗꠣꠃ ꠝꠣꠘꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","ꠔꠦ ꠀꠅ, ꠀꠝꠞꠣ ꠟꠣꠝꠤꠀ ꠉꠤꠀ ꠔꠣꠞꠣꠞ ꠛꠥꠟꠤꠞ ꠝꠣꠎꠦ ꠉꠥꠟꠝꠣꠟ ꠟꠣꠉꠣꠁ ꠖꠦꠁ, ꠎꠣꠔꠦ ꠔꠣꠞꠣ ꠄꠇꠎꠘꠦ ꠀꠞꠇ ꠎꠘꠞ ꠝꠣꠔ ꠛꠥꠎꠔ ꠘꠣ ꠙꠣꠞꠦ।” ");
INSERT INTO syls_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠢꠃ ꠎꠣꠉꠣ ꠕꠣꠇꠤ ꠔꠣꠞꠣꠞꠦ ꠀꠡ꠆ꠔꠣ ꠖꠥꠘꠤꠀꠁꠔ ꠍꠤꠔ꠆ꠞꠣꠁ ꠖꠤꠟꠣ। ꠀꠞ ꠔꠣꠞꠣꠞ ꠢꠃ ꠡꠢꠞ ꠛꠣꠘꠣꠘꠤꠞ ꠇꠣꠝꠅ ꠛꠘ꠆ꠖ ꠅꠁꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","ꠅꠃ ꠇꠣꠞꠘꠦ ꠢꠃ ꠎꠣꠉꠣꠞ ꠘꠣꠝ ꠅꠁꠟ ꠛꠣꠛꠤꠟ ꠝꠣꠘꠤ, ꠉꠥꠟꠝꠣꠟ, ꠢꠈꠣꠘꠅꠃ ꠝꠣꠛꠥꠖꠦ ꠢꠣꠞꠣ ꠖꠥꠘꠤꠀꠁꠞ ꠛꠥꠟꠤꠞ ꠝꠣꠎꠦ ꠉꠥꠟꠝꠣꠟ ꠟꠣꠉꠣꠁ ꠖꠤꠍꠟꠣ। ꠢꠈꠣꠘ ꠕꠣꠇꠤꠃ ꠔꠣꠁꠘ ꠔꠣꠞꠣꠞꠦ ꠀꠡ꠆ꠔꠣ ꠖꠥꠘꠤꠀꠁꠔ ꠍꠤꠔ꠆ꠞꠣꠁꠟꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","ꠅꠃ ꠅꠁꠟ ꠡꠣꠝꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠛꠄꠀꠘ। ꠛꠣꠘꠞ ꠖꠥꠁ ꠛꠞꠍ ꠛꠣꠖꠦ ꠡꠣꠝꠞ ꠛꠄꠅꠡ ꠎꠦꠛꠟꠣ ꠄꠇ-ꠡ ꠛꠞꠍ, ꠅꠃ ꠡꠝꠄ ꠔꠣꠘ ꠙꠥꠀ ꠀꠞ꠆ꠚꠣꠇꠍꠣꠖꠞ ꠎꠘꠝ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","ꠀꠞ꠆ꠚꠣꠇꠍꠣꠖꠞ ꠎꠘꠝꠞ ꠛꠣꠖꠦ ꠡꠣꠝ ꠀꠞꠅ ꠙꠣꠌ-ꠡ ꠛꠞꠍ ꠛꠣꠌꠤꠀ ꠀꠍꠟꠣ। ꠄꠞ ꠝꠣꠎꠦ ꠔꠣꠘ ꠀꠞꠅ ꠙꠥꠀ-ꠙꠥꠠꠤꠘ ꠅꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","ꠀꠞ꠆ꠚꠣꠇꠍꠣꠖꠞ ꠙꠣꠄꠔꠤꠡ ꠛꠍꠞꠞ ꠡꠝꠄ ꠔꠣꠘ ꠙꠥꠀ ꠡꠣꠟꠦꠈꠞ ꠎꠘꠝ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","ꠡꠣꠟꠦꠈꠞ ꠎꠘꠝꠞ ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠀꠞꠅ ꠌꠣꠁꠞ-ꠡ ꠔꠤꠘ ꠛꠞꠍ ꠛꠣꠌꠤꠀ ꠀꠍꠟꠣ। ꠄꠞ ꠝꠣꠎꠦ ꠔꠣꠘ ꠀꠞꠅ ꠙꠥꠀ-ꠙꠥꠠꠤ ꠅꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","ꠡꠣꠟꠦꠈꠞ ꠔꠤꠡ ꠛꠞꠍ ꠛꠄꠅꠡꠞ ꠡꠝꠄ ꠔꠣꠘ ꠙꠥꠀ ꠀꠛꠦꠞꠞ ꠎꠘꠝ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ꠀꠛꠦꠞꠞ ꠎꠘꠝꠞ ꠛꠣꠖꠦ ꠡꠣꠟꠦꠈ ꠀꠞꠅ ꠌꠣꠁꠞ-ꠡ ꠔꠤꠘ ꠛꠞꠍ ꠛꠣꠌꠤꠀ ꠀꠍꠟꠣ। ꠄꠞ ꠝꠣꠎꠦ ꠔꠣꠘ ꠀꠞꠅ ꠙꠥꠀ-ꠙꠥꠠꠤ ꠅꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ꠀꠛꠦꠞꠞ ꠌꠃꠔꠤꠡ ꠛꠍꠞꠞ ꠡꠝꠄ ꠔꠣꠘ ꠙꠥꠀ ꠚꠣꠟꠦꠎꠞ ꠎꠘꠝ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","ꠚꠣꠟꠦꠎꠞ ꠎꠘꠝꠞ ꠛꠣꠖꠦ ꠀꠛꠦꠞ ꠀꠞꠅ ꠌꠣꠁꠞ-ꠡ ꠔꠤꠡ ꠛꠞꠍ ꠛꠣꠌꠤꠀ ꠀꠍꠟꠣ। ꠄꠞ ꠝꠣꠎꠦ ꠔꠣꠘ ꠀꠞꠅ ꠙꠥꠀ-ꠙꠥꠠꠤ ꠅꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","ꠚꠣꠟꠦꠎꠞ ꠔꠤꠡ ꠛꠞꠍ ꠛꠄꠅꠡꠞ ꠡꠝꠄ ꠔꠣꠘ ꠙꠥꠀ ꠞꠣꠃꠞ ꠎꠘꠝ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ꠞꠣꠃꠞ ꠎꠘꠝꠞ ꠛꠣꠖꠦ ꠚꠣꠟꠦꠎ ꠀꠞꠅ ꠖꠥꠁ-ꠡ ꠘꠄ ꠛꠞꠍ ꠛꠣꠌꠤꠀ ꠀꠍꠟꠣ। ꠄꠞ ꠝꠣꠎꠦ ꠔꠣꠘ ꠀꠞꠅ ꠙꠥꠀ-ꠙꠥꠠꠤ ꠅꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","ꠞꠣꠃꠞ ꠛꠔ꠆ꠔꠤꠡ ꠛꠍꠞꠞ ꠡꠝꠄ ꠔꠣꠘ ꠙꠥꠀ ꠍꠣꠞꠥꠎꠞ ꠎꠘꠝ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","ꠍꠣꠞꠥꠎꠞ ꠎꠘꠝꠞ ꠛꠣꠖꠦ ꠞꠣꠃ ꠀꠞꠅ ꠖꠥꠁ-ꠡ ꠡꠣꠔ ꠛꠞꠍ ꠛꠣꠌꠤꠀ ꠀꠍꠟꠣ। ꠄꠞ ꠝꠣꠎꠦ ꠔꠣꠘ ꠀꠞꠅ ꠙꠥꠀ-ꠙꠥꠠꠤ ꠅꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","ꠍꠣꠞꠥꠎꠞ ꠔꠤꠡ ꠛꠍꠞꠞ ꠡꠝꠄ ꠔꠣꠘ ꠙꠥꠀ ꠘꠣꠢꠥꠞꠞ ꠎꠘꠝ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","ꠘꠣꠢꠥꠞꠞ ꠎꠘꠝꠞ ꠛꠣꠖꠦ ꠍꠣꠞꠥꠎ ꠀꠞꠅ ꠖꠥꠁ-ꠡ ꠛꠞꠍ ꠛꠣꠌꠤꠀ ꠀꠍꠟꠣ। ꠄꠞ ꠝꠣꠎꠦ ꠔꠣꠘ ꠀꠞꠅ ꠙꠥꠀ-ꠙꠥꠠꠤ ꠅꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","ꠘꠣꠢꠥꠞꠞ ꠃꠘꠔꠤꠡ ꠛꠍꠞꠞ ꠡꠝꠄ ꠔꠣꠘ ꠙꠥꠀ ꠔꠣꠞꠦꠈꠞ ꠎꠘꠝ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","ꠔꠣꠞꠦꠈꠞ ꠎꠘꠝꠞ ꠛꠣꠖꠦ ꠘꠣꠢꠥꠞ ꠀꠞꠅ ꠄꠇ-ꠡ ꠃꠘ꠆ꠘꠤꠡ ꠛꠞꠍ ꠛꠣꠌꠤꠀ ꠀꠍꠟꠣ। ꠄꠞ ꠝꠣꠎꠦ ꠔꠣꠘ ꠀꠞꠅ ꠙꠥꠀ-ꠙꠥꠠꠤ ꠅꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","ꠔꠣꠞꠦꠈꠞ ꠡꠔ꠆ꠔꠁꠞ ꠛꠍꠞꠞ ꠡꠝꠄ ꠔꠣꠘ ꠙꠥꠀꠂꠘ ꠀꠛ꠆ꠞꠣꠝ (ꠔꠣꠘ ꠛꠣꠖꠞ ꠘꠣꠝ ꠁꠛ꠆ꠞꠣꠢꠤꠝ), ꠘꠣꠢꠥꠞ ꠀꠞ ꠢꠣꠞꠘꠞ ꠎꠘꠝ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","ꠅꠃ ꠅꠁꠟ ꠔꠣꠞꠦꠈꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠛꠄꠀꠘ। ꠔꠣꠞꠦꠈꠞ ꠙꠥꠀꠞ ꠘꠣꠝ ꠀꠍꠤꠟ ꠀꠛ꠆ꠞꠣꠝ, ꠘꠣꠢꠥꠞ ꠀꠞ ꠢꠣꠞꠘ। ꠀꠞ ꠢꠣꠞꠘꠞ ꠙꠥꠀꠞ ꠘꠣꠝ ꠟꠥꠔ। ");
INSERT INTO syls_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ꠢꠣꠞꠘ ꠔꠣꠘ ꠛꠣꠛꠣ ꠎꠤꠘ꠆ꠖꠣ ꠕꠣꠇꠔꠦꠃ, ꠔꠣꠘ ꠎꠘꠝ-ꠝꠣꠐꠤ ꠛꠣꠛꠤꠟ ꠖꠦꠡꠞ ꠃꠞ ꠐꠣꠃꠘꠅ ꠝꠣꠞꠣ ꠉꠦꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","ꠀꠛ꠆ꠞꠣꠝ ꠀꠞ ꠘꠣꠢꠥꠞ ꠖꠥꠁꠎꠘꠦ ꠛꠤꠀ ꠇꠞꠍꠟꠣ। ꠀꠛ꠆ꠞꠣꠝꠞ ꠛꠃꠞ ꠘꠣꠝ ꠀꠍꠤꠟ ꠍꠣꠞꠣ। ꠀꠞ ꠘꠣꠢꠥꠞꠞ ꠛꠃꠞ ꠘꠣꠝ ꠝꠤꠟꠇꠣ। ꠝꠤꠟꠇꠣ ꠀꠞ ꠁꠍꠇꠣ ꠀꠍꠟꠣ ꠢꠣꠞꠘꠞ ꠙꠥꠠꠤꠘ। ");
INSERT INTO syls_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","ꠅꠁꠟꠦ ꠍꠣꠞꠣꠞ ꠇꠥꠘꠥ ꠙꠥꠀ-ꠙꠥꠠꠤ ꠀꠍꠤꠟ ꠘꠣ, ꠔꠣꠁꠘ ꠘꠤꠀꠅꠟꠣꠖꠤ ꠀꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","ꠔꠣꠞꠦꠈꠦ ꠀꠛ꠆ꠞꠣꠝ, ꠟꠥꠔ ꠀꠞ ꠍꠣꠞꠣꠞꠦ ꠟꠁꠀ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠎꠣꠅꠀꠞ ꠟꠣꠉꠤ ꠛꠣꠛꠤꠟ ꠖꠦꠡꠞ ꠃꠞ ꠐꠣꠃꠘ ꠕꠣꠇꠤ ꠞꠅꠀꠘꠣ ꠅꠁꠟꠣ। ꠀꠛ꠆ꠞꠣꠝ ꠅꠁꠟꠣ ꠔꠣꠞꠦꠈꠞ ꠙꠥꠀ, ꠢꠣꠞꠘꠞ ꠙꠥꠀ ꠟꠥꠔ ꠅꠁꠟꠣ ꠔꠣꠞꠦꠈꠞ ꠘꠣꠔꠤ, ꠀꠞ ꠍꠣꠞꠣ ꠅꠁꠟꠣ ꠔꠣꠞꠦꠈꠞ ꠙꠥꠀ ꠀꠛ꠆ꠞꠣꠝꠞ ꠛꠃ। ꠙꠄꠟꠣ ꠔꠣꠞꠣ ꠢꠣꠞꠣꠘ ꠘꠣꠝꠦ ꠄꠇ ꠐꠣꠃꠘꠅ ꠉꠦꠟꠣ ꠀꠞ ꠢꠈꠣꠘꠅ ꠛꠡꠔ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","ꠔꠣꠞꠦꠈ ꠖꠥꠁ-ꠡ ꠙꠣꠌ ꠛꠞꠍ ꠛꠄꠅꠡꠅ ꠢꠣꠞꠣꠘ ꠐꠣꠃꠘꠅ ꠝꠣꠞꠣ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠀꠛ꠆ꠞꠣꠝꠞꠦ ꠚꠞꠝꠣꠁꠟꠣ, “ꠔꠥꠝꠤ ꠔꠥꠝꠣꠞ ꠘꠤꠎꠞ ꠖꠦꠡ, ꠈꠦꠡ-ꠇꠥꠐꠥꠝ, ꠀꠞ ꠛꠣꠛꠣꠁꠔꠤ ꠜꠤꠐꠣ-ꠝꠣꠐꠤ ꠍꠣꠠꠤꠀ ꠀꠝꠤ ꠎꠦ ꠖꠦꠡ ꠖꠦꠈꠣꠁꠝꠥ ꠢꠃ ꠖꠦꠡꠅ ꠎꠣꠅ। ");
INSERT INTO syls_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","ꠔꠥꠝꠣꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠀꠝꠤ ꠛꠃꠔ ꠛꠠ ꠄꠇ ꠎꠣꠔꠤ ꠙꠄꠖꠣ ꠇꠞꠝꠥ। ꠔꠥꠝꠣꠞꠦ ꠞꠢꠝ-ꠛꠞꠇꠔ ꠖꠤꠝꠥ। ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠛꠠ ꠁꠎ꠆ꠎꠔꠤ ꠛꠣꠘꠣꠁꠝꠥ, ꠀꠞ ꠔꠥꠝꠣꠞ ꠃꠍꠤꠟ꠆ꠟꠣꠄ ꠀꠡ꠆ꠔꠣ ꠖꠥꠘꠤꠀꠞ ꠝꠣꠘꠡꠦ ꠞꠢꠝ-ꠛꠞꠇꠔ ꠙꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","ꠀꠞ ꠢꠥꠘꠅ, ꠔꠥꠝꠣꠞꠦ ꠎꠣꠞꠣ ꠖꠥꠀ ꠖꠤꠛꠣ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠞꠢꠝ-ꠛꠞꠇꠔ ꠖꠤꠝꠥ, ꠅꠁꠟꠦ ꠎꠣꠞꠣ ꠔꠥꠝꠣꠞꠦ ꠛꠖ꠆ꠖꠥꠀ ꠖꠤꠛꠣ, ꠀꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠟꠣꠘ꠆ꠘꠔ ꠖꠤꠝꠥ। ꠖꠥꠘꠤꠀꠞ ꠢꠇꠟ ꠎꠣꠔꠤꠄ ꠔꠥꠝꠣꠞ ꠃꠍꠤꠟ꠆ꠟꠣꠄ ꠞꠢꠝ-ꠛꠞꠇꠔ ꠙꠣꠁꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠔꠃ ꠀꠛ꠆ꠞꠣꠝ ꠛꠣꠞ ꠅꠁꠉꠦꠟꠣ, ꠔꠣꠘ ꠜꠣꠔꠤꠎꠣ ꠟꠥꠔꠅ ꠔꠣꠘ ꠟꠉꠦ ꠉꠦꠟꠣ। ꠢꠣꠞꠣꠘ ꠐꠣꠃꠘ ꠚꠣꠟꠣꠁꠀ ꠎꠣꠅꠀꠞ ꠡꠝꠄ ꠀꠛ꠆ꠞꠣꠝꠞ ꠛꠄꠅꠡ ꠀꠍꠤꠟ ꠙꠌꠔ꠆ꠔꠁꠞ ꠛꠞꠍ। ");
INSERT INTO syls_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ꠔꠣꠘ ꠛꠤꠛꠤ ꠍꠣꠞꠣ ꠀꠞ ꠜꠣꠔꠤꠎꠣ ꠟꠥꠔꠞꠦ ꠟꠁꠀ ꠔꠣꠁꠘ ꠛꠣꠞ ꠅꠁꠟꠣ। ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠟꠁꠀ ꠀꠞ ꠎꠦ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠞꠦ ꠔꠣꠁꠘ-ꠔꠣꠁꠘ ꠢꠣꠞꠣꠘ ꠄꠟꠣꠇꠣꠔ ꠙꠣꠁꠍꠟꠣ ꠔꠣꠞꠣꠞꠦ ꠟꠁꠀ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠎꠣꠁꠔꠣ ꠇꠞꠤ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣ। ꠢꠦꠡꠦ ꠢꠘꠅ ꠉꠤꠀ ꠙꠃꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ꠇꠦꠘꠣꠘꠞ ꠝꠣꠎꠦꠖꠤ ꠎꠣꠁꠔꠦ ꠎꠣꠁꠔꠦ ꠀꠛ꠆ꠞꠣꠝ ꠡꠤꠈꠤꠝꠅ ꠀꠁꠀ ꠝꠥꠞꠤꠞ ꠄꠟꠘ ꠉꠣꠍꠞ ꠉꠦꠍꠦ ꠎꠤꠞꠣꠁꠟꠣ। ꠁ ꠡꠝꠄ ꠇꠦꠘꠣꠘꠤ ꠅꠇꠟ ꠢꠃ ꠖꠦꠡꠅ ꠛꠡꠔ ꠇꠞꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","ꠝꠣꠛꠥꠖꠦ ꠀꠛ꠆ꠞꠣꠝꠞꠦ ꠖꠞꠡꠘ ꠖꠤꠀ ꠇꠁꠟꠣ, ꠁ ꠖꠦꠡꠈꠣꠘ ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡꠞꠦ ꠖꠤꠟꠣꠁꠝꠥ। ꠀꠛ꠆ꠞꠣꠝꠞꠦ ꠎꠦꠁꠘ ꠖꠦꠈꠣ ꠖꠤꠟꠣ, ꠢꠃ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠔꠣꠁꠘ ꠢꠘꠅ ꠄꠇ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ꠢꠘ ꠕꠣꠇꠤ ꠔꠣꠁꠘ ꠛꠦꠕꠦꠟ ꠐꠣꠃꠘꠞ ꠙꠥꠛꠦꠖꠤ ꠙꠣꠠꠤ ꠄꠟꠣꠇꠣꠔ ꠀꠉꠥꠀꠁ ꠉꠦꠟꠣ, ꠉꠤꠀ ꠙꠁꠌꠝꠦ ꠛꠦꠕꠦꠟ ꠙꠥꠛꠦ ꠅꠄ ꠐꠣꠃꠘꠞ ꠝꠣꠎꠈꠣꠘꠅ ꠔꠣꠁꠘ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠟꠣ। ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠔꠣꠁꠘ ꠁꠘꠅ ꠄꠇ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠁꠟꠣ ꠀꠞ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝ ꠟꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠢꠤꠘ ꠕꠣꠇꠤ ꠢꠞꠔꠦ ꠢꠞꠔꠦ ꠘꠦꠉꠦꠜ ꠘꠣꠝꠞ ꠖꠃꠇꠘꠞ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠛꠣꠄꠖꠤ ꠉꠦꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","ꠁ ꠡꠝꠄ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠘꠤꠖꠣꠘ ꠖꠦꠈꠣ ꠖꠤꠟ। ꠁ ꠘꠤꠖꠣꠘ ꠈꠥꠛ ꠇꠑꠤꠘ ꠅꠀꠄ, ꠀꠛ꠆ꠞꠣꠝꠦ ꠝꠥꠍꠣꠚꠤꠞ ꠅꠁꠀ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠉꠦꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","ꠝꠤꠡꠞꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠀꠁꠀ ꠀꠛ꠆ꠞꠣꠝꠦ ꠔꠣꠘ ꠛꠤꠛꠤ ꠍꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠢꠥꠘꠅ, ꠀꠝꠤ ꠎꠣꠘꠤ ꠔꠥꠝꠤ ꠈꠥꠛ ꠡꠥꠘ꠆ꠖꠞꠤ। ");
INSERT INTO syls_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ꠔꠥꠝꠤ ꠎꠦꠛꠟꠣ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠌꠃꠈꠅ ꠙꠠꠛꠣꠄ, ꠔꠦꠃ ꠔꠣꠞꠣ ꠛꠥꠎꠛ ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠛꠃ, ꠀꠞ ꠔꠥꠝꠣꠞꠦ ꠞꠣꠈꠤꠀ ꠀꠝꠣꠞꠦ ꠈꠥꠘ ꠇꠞꠤꠟꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","ꠄꠞꠟꠣꠉꠤ ꠇꠁꠅ, ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠛꠁꠘ। ꠄꠔꠦ ꠔꠥꠝꠣꠞ ꠟꠣꠉꠤ ꠀꠝꠣꠞ ꠜꠣꠟꠣ ꠅꠁꠛ, ꠀꠞ ꠀꠝꠣꠞꠦ ꠛꠣꠌꠣꠁꠀ ꠞꠣꠈꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","ꠀꠛ꠆ꠞꠣꠝ ꠝꠤꠡꠞꠅ ꠀꠁꠀ ꠢꠣꠞꠟꠦ ꠝꠤꠡꠞꠞ ꠝꠣꠘꠡꠦ ꠖꠦꠈꠟꠣ ꠍꠣꠞꠣ ꠈꠥꠛ ꠡꠥꠘ꠆ꠖꠞꠤ। ");
INSERT INTO syls_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ꠝꠤꠡꠞꠞ ꠛꠣꠖꠡꠣ ꠚꠦꠞꠣꠃꠘꠞ ꠉꠥꠁꠀ ꠅꠇꠟꠦ ꠔꠣꠘꠦ ꠖꠦꠈꠤꠀ ꠚꠦꠞꠣꠃꠘꠞ ꠉꠦꠍꠦ ꠉꠤꠀ ꠔꠣꠘ ꠔꠣꠞꠤꠚ ꠇꠞꠤꠀ ꠛꠃꠔꠔꠣ ꠇꠁꠟꠣ। ꠀꠞ ꠍꠣꠞꠣꠞꠦ ꠞꠣꠎꠛꠣꠠꠤꠞ ꠜꠤꠔꠞꠦ ꠘꠦꠅꠀ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","ꠍꠣꠞꠣꠞ ꠟꠣꠉꠤ ꠚꠦꠞꠣꠃꠘꠦ ꠀꠛ꠆ꠞꠣꠝꠞꠦ ꠝꠣꠄꠀ ꠇꠞꠔꠣ ꠟꠣꠉꠟꠣ। ꠔꠣꠁꠘ ꠀꠛ꠆ꠞꠣꠝꠞꠦ ꠛꠃꠔ ꠉꠞꠥ-ꠍꠣꠉꠟ, ꠉꠣꠗꠣ-ꠉꠣꠗꠤ, ꠃꠐ, ꠀꠞ ꠛꠣꠘ꠆ꠖꠤ-ꠉꠥꠟꠣꠝ ꠃꠙꠢꠣꠞ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","ꠅꠁꠟꠦ ꠛꠤꠛꠤ ꠍꠣꠞꠣꠞ ꠟꠣꠉꠤ ꠝꠣꠛꠥꠖꠦ ꠚꠦꠞꠣꠃꠘ ꠀꠞ ꠔꠣꠞ ꠛꠣꠠꠤꠞ ꠢꠇꠟ ꠝꠣꠘꠡꠞ ꠝꠣꠎꠦ ꠛꠦꠡꠦꠛꠣ ꠛꠦꠝꠣꠞ ꠙꠄꠖꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","ꠔꠦꠃ ꠚꠦꠞꠣꠃꠘꠦ ꠀꠛ꠆ꠞꠣꠝꠞꠦ ꠘꠤꠀ ꠎꠤꠇꠣꠁꠟꠣ, “ꠀꠙꠘꠦ ꠀꠝꠣꠞ ꠟꠉꠦ ꠁꠔꠣ ꠇꠤꠔꠣ ꠇꠞꠟꠣ? ꠔꠣꠘꠞꠦ ꠇꠦꠘꠦ ꠀꠙꠘꠣꠞ ꠛꠃ ꠘꠣ ꠇꠁꠀ ");
INSERT INTO syls_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","ꠛꠁꠘ ꠇꠁꠟꠣ? ꠀꠞ ꠀꠝꠤ ꠔ ꠔꠣꠘꠞꠦ ꠛꠤꠀ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠘꠦꠅꠀꠁꠍꠟꠣꠝ। ꠄꠁꠘ ꠔ ꠀꠙꠘꠣꠞ ꠛꠤꠛꠤ, ꠄꠘꠦ ꠟꠁꠀ ꠀꠙꠘꠦ ꠁꠘ ꠕꠣꠇꠤ ꠢꠞꠤ ꠎꠣꠃꠇ꠆ꠇꠣꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","ꠅꠃ ꠇꠕꠣ ꠇꠁꠀ ꠚꠦꠞꠣꠃꠘꠦ ꠔꠣꠘ ꠝꠣꠘꠡꠞꠦ ꠢꠥꠇꠥꠝ ꠇꠞꠟꠣ, ꠀꠞ ꠔꠣꠞꠣ ꠀꠛ꠆ꠞꠣꠝꠞ ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠡꠢ ꠔꠣꠘꠦ ꠀꠞ ꠔꠣꠘ ꠛꠤꠛꠤꠞꠦ ꠛꠤꠖꠣꠄ ꠇꠞꠤ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","ꠔꠦꠃ ꠀꠛ꠆ꠞꠣꠝ ꠀꠞ ꠔꠣꠘ ꠛꠤꠛꠤꠄ ꠢꠇꠟꠔꠣ ꠟꠁꠀ ꠝꠤꠡꠞ ꠖꠦꠡ ꠚꠣꠟꠣꠁꠀ ꠘꠦꠉꠦꠜ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠉꠦꠟꠣꠉꠤ, ꠟꠥꠔꠅ ꠔꠣꠘ ꠟꠉꠦ ꠀꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","ꠀꠛ꠆ꠞꠣꠝ ꠈꠥꠛ ꠗꠘꠤ ꠀꠍꠟꠣ, ꠔꠣꠘ ꠛꠃꠔ ꠢꠦꠝꠣꠘ-ꠎꠣꠘꠥꠀꠞ ꠀꠞ ꠡꠥꠘꠣ-ꠞꠥꠙꠣ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠘꠦꠉꠦꠜ ꠕꠣꠇꠤ ꠢꠞꠔꠦ ꠢꠞꠔꠦ ꠛꠦꠕꠦꠟ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠉꠦꠟꠣ। ꠉꠤꠀ ꠔꠣꠁꠘ ꠛꠦꠕꠦꠟ ꠀꠞ ꠅꠄ ꠐꠣꠃꠘꠞ ꠝꠣꠎꠈꠣꠘꠅ ꠙꠃꠍꠟꠣ, ꠎꠦ ꠎꠣꠉꠣꠔ ꠔꠣꠁꠘ ꠀꠉꠦ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠍꠟꠣ ");
INSERT INTO syls_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ꠀꠞ ꠙꠄꠟꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠁꠍꠟꠣ। ꠅꠘꠅ ꠉꠤꠀ ꠔꠣꠁꠘ ꠢꠤꠞꠛꠣꠞ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝ ꠟꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","ꠀꠛ꠆ꠞꠣꠝꠞ ꠟꠉꠦ ꠝꠥꠍꠣꠚꠤꠞ ꠀꠍꠟꠣ ꠔꠣꠘ ꠜꠣꠔꠤꠎꠣ ꠟꠥꠔ, ꠄꠘꠅ ꠛꠃꠔ ꠉꠞꠥ-ꠍꠣꠉꠟ ꠀꠞ ꠔꠣꠝ꠆ꠛꠥ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ꠅꠁꠟꠦ ꠎꠣꠉꠣꠐꠣ ꠁꠟꠣ ꠀꠍꠤꠟ ꠘꠣ ꠎꠦꠘ, ꠖꠥꠁꠅꠎꠘꠞ ꠙꠡꠥꠞ ꠙꠣꠟꠦ ꠄꠇꠟꠉꠦ ꠈꠣꠁꠔꠣ ꠙꠣꠞꠛꠣ। ꠉꠞꠥ-ꠍꠣꠉꠟ ꠀꠞ ꠔꠣꠝ꠆ꠛꠥ ꠅꠔ ꠛꠦꠡꠤ ꠀꠍꠤꠟ ꠎꠦꠘ, ꠁꠔꠣ ꠟꠁꠀ ꠔꠣꠞꠣꠞ ꠕꠣꠇꠣꠞ ꠃꠙꠣꠄ ꠀꠍꠤꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ꠄꠞꠟꠣꠉꠤ ꠀꠛ꠆ꠞꠣꠝ ꠀꠞ ꠟꠥꠔꠞ ꠞꠣꠈꠣꠟ ꠅꠇꠟꠦ ꠢꠣꠝꠦꠡꠣ ꠖꠞꠛꠣꠞ-ꠇꠣꠁꠎ꠆ꠎꠣ ꠇꠞꠔꠣ। ꠀꠞ ꠢꠤ ꠡꠝꠄ ꠇꠦꠘꠣꠘꠤ ꠀꠞ ꠚꠣꠞꠤꠎꠤ ꠅꠇꠟꠅ ꠢꠤ ꠖꠦꠡꠅ ꠛꠡꠔ ꠇꠞꠔ। ");
INSERT INTO syls_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","ꠔꠦꠃ ꠀꠛ꠆ꠞꠣꠝꠦ ꠟꠥꠔꠞꠦ ꠇꠁꠟꠣ, “ꠢꠥꠘꠅ, ꠀꠝꠞꠣ ꠔ ꠖꠥꠁꠅꠎꠘꠃ ꠀꠙꠘ। ꠔꠦ ꠔꠥꠝꠣꠞ-ꠀꠝꠣꠞ ꠝꠣꠎꠦ ꠀꠞ ꠔꠥꠝꠣꠞ-ꠀꠝꠣꠞ ꠞꠣꠈꠣꠟꠞ ꠝꠣꠎꠦꠅ ꠖꠞꠛꠣꠞ-ꠇꠣꠁꠎ꠆ꠎꠣ ꠇꠞꠣ ꠑꠤꠇ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ꠢꠣꠞꠣ ꠖꠦꠡꠐꠣꠃ ꠔꠥꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠙꠠꠤ ꠞꠁꠍꠦ। ꠔꠦ ꠀꠅ, ꠀꠝꠞꠣ ꠀꠟꠉꠣ ꠅꠁꠎꠣꠁ। ꠔꠥꠝꠤ ꠛꠣꠃꠄ ꠙꠍꠘ꠆ꠖ ꠇꠞꠟꠦ, ꠀꠝꠤ ꠒꠣꠁꠘꠦ, ꠀꠞ ꠔꠥꠝꠤ ꠒꠣꠁꠘꠦ ꠉꠦꠟꠦ, ꠀꠝꠤ ꠛꠣꠃꠄ ꠎꠣꠁꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","ꠟꠥꠔꠦ ꠌꠣꠁꠀ ꠖꠦꠈꠟꠣ, ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠕꠟ ꠎꠣꠉꠣꠞ ꠢꠇꠟꠛꠣꠄ ꠍꠥꠀꠞ ꠉꠣꠃ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠛꠃꠔ ꠙꠣꠘꠤ ꠀꠍꠦ, ꠝꠣꠛꠥꠖꠞ ꠛꠣꠉꠤꠌꠣ ꠛꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠟꠣꠈꠣꠘ ꠁ ꠎꠣꠉꠣꠅ ꠊꠣꠡ-ꠙꠣꠘꠤ ꠀꠟꠣ। ꠅꠃ ꠡꠝꠄꠅ ꠝꠣꠛꠥꠖꠦ ꠍꠣꠖꠥꠝ ꠀꠞ ꠀꠝꠥꠞꠣ ꠐꠣꠃꠘ ꠛꠤꠘꠣꠡ ꠇꠞꠍꠂꠘ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","ꠄꠞꠟꠣꠉꠤ ꠟꠥꠔꠦ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠢꠇꠟ ꠕꠟ ꠎꠣꠉꠣ ꠘꠤꠎꠞ ꠟꠣꠉꠤ ꠛꠣꠍꠤꠀ ꠙꠥꠛꠦꠖꠤ ꠢꠞꠤꠀ ꠉꠦꠟꠣꠉꠤ। ꠅꠃꠟꠣ ꠔꠣꠞꠣ ꠀꠟꠉꠣ ꠅꠁꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","ꠀꠛ꠆ꠞꠣꠝ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠞꠁꠟꠣ, ꠀꠞ ꠟꠥꠔ ꠢꠃ ꠕꠟ ꠎꠝꠤꠘꠞ ꠐꠣꠃꠘ ꠅꠇꠟꠞ ꠇꠣꠍꠣꠔ ꠉꠤꠀ ꠛꠡꠔ ꠇꠞꠟꠣ। ꠔꠣꠁꠘ ꠍꠣꠖꠥꠝ ꠐꠣꠃꠘꠞ ꠇꠤꠘꠣꠞꠅ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠟ꠆ꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","ꠍꠣꠖꠥꠝꠞ ꠝꠣꠘꠥꠡ ꠅꠇꠟ ꠈꠥꠛ ꠈꠛꠤꠍ ꠀꠍꠤꠟ, ꠝꠣꠛꠥꠖꠞ ꠘꠎꠞꠅ ꠔꠣꠞꠣ ꠛꠦꠕꠣꠄꠀ ꠉꠥꠘꠣꠉꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","ꠟꠥꠔ ꠀꠟꠉꠣ ꠅꠀꠞ ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠀꠛ꠆ꠞꠣꠝꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠎꠦ ꠎꠣꠉꠣꠔ ꠃꠛꠣꠁꠍ, ꠁꠈꠣꠘ ꠕꠣꠇꠤ ꠃꠔꠞꠦ-ꠖꠃꠇꠘꠦ, ꠙꠥꠛꠦ-ꠙꠁꠌꠝꠦ ꠄꠇꠛꠣꠞ ꠌꠣꠁꠀ ꠖꠦꠈꠅ। ");
INSERT INTO syls_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","ꠎꠦ ꠎꠣꠉꠣ ꠅꠇꠟ ꠔꠥꠝꠤ ꠖꠦꠈꠞꠣꠄ, ꠁꠔꠣ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠀꠞ ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡ ꠅꠇꠟꠞꠦ ꠢꠣꠝꠦꠡꠣꠇꠥꠞ ꠟꠣꠉꠤ ꠖꠤꠟꠣꠁꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡꠞꠦ ꠖꠥꠘꠤꠀꠁꠞ ꠗꠥꠁꠟ-ꠛꠣꠟꠥꠞ ꠟꠣꠈꠣꠘ ꠛꠦꠢꠤꠡꠣꠛ ꠇꠞꠝꠥ। ꠖꠥꠘꠤꠀꠞ ꠗꠥꠁꠟ-ꠛꠣꠟꠥ ꠎꠥꠖꠤ ꠇꠦꠃ ꠉꠘꠤꠀ ꠚꠥꠠꠣꠁꠔ ꠙꠣꠞꠦ, ꠔꠦ ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡꠞꠦꠅ ꠉꠘꠔ ꠙꠣꠞꠛ। ");
INSERT INTO syls_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ꠃꠑꠅ, ꠀꠡ꠆ꠔꠣ ꠖꠦꠡꠐꠣ ꠔꠥꠝꠤ ꠄꠇꠛꠣꠞ ꠊꠥꠞꠤꠀ ꠀꠅ, ꠅꠃ ꠖꠦꠡꠃ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠖꠤꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","ꠔꠦꠃ ꠀꠛ꠆ꠞꠣꠝꠦ ꠔꠣꠘ ꠔꠣꠝ꠆ꠛꠥ ꠔꠥꠟꠤꠀ, ꠢꠦꠛꠞꠘ ꠄꠟꠣꠇꠣꠔ ꠝꠝ꠆ꠞꠤꠞ ꠄꠟꠘ ꠛꠘꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠘꠤꠀ ꠉꠣꠠꠤꠟꠣ। ꠢꠈꠣꠘꠅ ꠔꠣꠁꠘ ꠝꠣꠛꠥꠖꠞ ꠟꠣꠉꠤ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","ꠛꠣꠛꠤꠟ ꠖꠦꠡꠞ ꠛꠣꠖꠡꠣ ꠅꠝ꠆ꠞꠣꠚꠦꠟ, ꠁꠟ꠆ꠟꠣꠡꠞꠞ ꠛꠣꠖꠡꠣ ꠀꠞꠤꠀꠇ, ꠁꠟꠣꠝꠞ ꠛꠣꠖꠡꠣ ꠇꠖꠞ-ꠟꠣꠃꠝꠞ ꠀꠞ ꠉꠥꠁꠝꠞ ꠛꠣꠖꠡꠣ ꠔꠤꠖꠤꠅꠟ, ꠄꠞꠣ ꠌꠣꠁꠞꠅꠎꠘꠦ ꠄꠇ ꠅꠁꠀ ");
INSERT INTO syls_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ꠍꠣꠖꠥꠝꠞ ꠛꠣꠖꠡꠣ ꠛꠤꠞꠣ, ꠀꠝꠥꠞꠣꠞ ꠛꠣꠖꠡꠣ ꠛꠤꠞꠡꠣ, ꠅꠖꠝꠣꠞ ꠛꠣꠖꠡꠣ ꠡꠤꠘꠣꠛ, ꠍꠛꠂꠁꠝꠞ ꠛꠣꠖꠡꠣ ꠡꠤꠝꠦꠛꠞ ꠀꠞ ꠛꠤꠟꠣꠞ ꠛꠣ ꠍꠥꠀꠞꠞ ꠛꠣꠖꠡꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠎꠥꠖ꠆ꠖ ꠇꠞꠣꠔ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","ꠅꠃ ꠙꠣꠌꠎꠘ ꠛꠣꠖꠡꠣꠄ ꠔꠣꠞꠣꠞ ꠍꠤꠙꠣꠁ ꠅꠇꠟꠞꠦ ꠄꠇꠈꠣꠘꠅ ꠇꠞꠤꠀ ꠍꠤꠖ꠆ꠖꠤꠝꠞ ꠔꠟ ꠎꠣꠉꠣꠔ ꠟꠁꠀ ꠉꠦꠟꠣ। ꠁ ꠎꠣꠉꠣꠞꠦ ꠟꠥꠘꠣ ꠡꠣꠉꠞ ꠇꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","ꠢꠤ ꠛꠣꠖꠡꠣ ꠅꠇꠟꠦ ꠛꠣꠞꠅ ꠛꠞꠍ ꠛꠣꠖꠡꠣ ꠇꠖꠞ-ꠟꠣꠃꠝꠞꠞ ꠉꠥꠟꠣꠝꠤ ꠇꠞꠤꠀ ꠔꠦꠞꠅ ꠛꠍꠞꠞ ꠡꠝꠄ ꠛꠤꠖ꠆ꠞꠥꠢ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","ꠄꠞ ꠛꠣꠖꠞ ꠛꠞꠍ ꠛꠣꠖꠡꠣ ꠇꠖꠞ-ꠟꠣꠃꠝꠞ ꠀꠞ ꠔꠣꠘ ꠟꠉꠞ ꠛꠣꠖꠡꠣ ꠅꠇꠟꠦ ꠉꠤꠀ ꠅꠡ꠆ꠔꠞꠥꠕ-ꠇꠞ꠆ꠘꠄꠁꠝꠅ ꠞꠚꠣꠄꠁ ꠅꠇꠟꠞꠦ, ꠢꠝꠅ ꠉꠤꠀ ꠎꠥꠎꠤ ꠅꠇꠟꠞꠦ, ꠀꠞ ꠡꠣꠛꠤ-ꠇꠤꠞꠤꠀꠔꠣꠁꠝꠅ ꠉꠤꠀ ꠄꠁꠝꠤ ꠅꠇꠟꠞꠦ ꠀꠞꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ꠛꠣꠖꠦ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠇꠣꠍꠣꠞ ꠄꠟ-ꠚꠣꠞꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠍꠦꠁꠞ ꠙꠣꠠꠞ ꠢꠥꠞꠤꠅ ꠅꠇꠟꠞꠦꠅ ꠀꠞꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ꠢꠦꠡꠦ ꠅꠃ ꠛꠣꠖꠡꠣ ꠅꠇꠟꠦ ꠊꠥꠞꠤꠀ ꠉꠤꠀ ꠅꠂꠘ-ꠝꠤꠡꠙꠐꠅ ꠛꠣ ꠇꠣꠖꠦꠡ ꠉꠦꠟꠣ। ꠔꠣꠞꠣ ꠀꠝꠣꠟꠦꠇꠤ ꠅꠇꠟꠞ ꠀꠡ꠆ꠔꠣ ꠖꠦꠡ ꠖꠈꠟ ꠇꠞꠟꠣ ꠀꠞ ꠢꠣꠎꠣꠎꠘ-ꠔꠣꠝꠣꠞ ꠐꠣꠃꠘꠅ ꠎꠦ ꠀꠝꠥꠞꠤ ꠅꠇꠟ ꠀꠍꠤꠟ ꠔꠣꠞꠣꠞꠦꠅ ꠖꠈꠟ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","ꠛꠣꠖꠦ ꠍꠣꠖꠥꠝ, ꠀꠝꠥꠞꠣ, ꠅꠖꠝꠣ, ꠍꠛꠂꠁꠝ ꠀꠞ ꠛꠤꠟꠣ ꠛꠣ ꠍꠥꠀꠞꠞ ꠛꠣꠖꠡꠣ ꠅꠇꠟꠦ ");
INSERT INTO syls_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ꠁꠟꠣꠝꠞ ꠛꠣꠖꠡꠣ ꠇꠖꠞ-ꠟꠣꠃꠝꠞ, ꠉꠥꠁꠝꠞ ꠛꠣꠖꠡꠣ ꠔꠤꠖꠤꠅꠟ, ꠛꠣꠛꠤꠟꠞ ꠛꠣꠖꠡꠣ ꠅꠝ꠆ꠞꠣꠚꠦꠟ ꠀꠞ ꠁꠟ꠆ꠟꠣꠡꠞꠞ ꠛꠣꠖꠡꠣ ꠀꠞꠤꠀꠇꠞ ꠟꠉꠦ ꠎꠥꠖ꠆ꠖ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠍꠤꠖ꠆ꠖꠤꠝ ꠘꠣꠝꠞ ꠔꠟ ꠎꠣꠉꠣꠔ ꠔꠣꠞꠣꠞ ꠍꠤꠙꠣꠁ ꠅꠇꠟ ꠢꠣꠎꠣꠁꠟꠣ। ꠌꠣꠁꠞ ꠛꠣꠖꠡꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠙꠣꠌ ꠛꠣꠖꠡꠣꠄ ꠟꠣꠉꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","ꠍꠤꠖ꠆ꠖꠤꠝꠞ ꠔꠟ ꠎꠣꠉꠣꠔ ꠔꠣꠞꠔꠦꠟꠞ ꠛꠃꠔ ꠉꠣꠔ-ꠉꠣꠠꠣ ꠀꠍꠤꠟ। ꠍꠣꠖꠥꠝ ꠀꠞ ꠀꠝꠥꠞꠣꠞ ꠛꠣꠖꠡꠣꠁꠘ ꠎꠦꠛꠟꠣ ꠜꠣꠉꠤꠀ ꠎꠣꠁꠞꠣ, ꠁ ꠡꠝꠄ ꠔꠣꠞꠣꠞ ꠟꠉꠞ ꠇꠦꠃ ꠇꠦꠃ ꠅꠃ ꠔꠣꠞꠔꠦꠟꠞ ꠉꠣꠔꠅ ꠙꠠꠤ ꠉꠦꠟꠣ, ꠀꠞ ꠛꠣꠇꠤ ꠅꠇꠟꠦ ꠜꠣꠉꠤꠀ ꠙꠣꠠꠅ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","ꠔꠦꠃ ꠔꠣꠞꠣꠞ ꠖꠥꠡꠝꠘ ꠅꠇꠟꠦ ꠍꠣꠖꠥꠝ-ꠀꠝꠥꠞꠣꠞ ꠢꠇꠟ ꠗꠘ-ꠍꠣꠝꠣꠘꠣ ꠀꠞ ꠈꠣꠘꠤ-ꠖꠣꠘꠤꠞ ꠢꠇꠟꠔꠣ ꠟꠥꠐꠤꠀ ꠟꠁꠀ ꠉꠦꠟꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","ꠀꠞ ꠔꠣꠞꠣ ꠀꠛ꠆ꠞꠣꠝꠞ ꠜꠣꠔꠤꠎꠣ ꠟꠥꠔꠞ ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠡꠥꠖ꠆ꠖꠣ ꠢꠃ ꠟꠥꠔꠞꠦꠃ ꠗꠞꠤꠀ ꠟꠁꠀ ꠉꠦꠟꠣꠉꠤ, ꠇꠣꠞꠘ ꠄꠁꠘꠦꠃ ꠍꠣꠖꠥꠝ ꠐꠣꠃꠘꠅ ꠞꠁꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","ꠔꠦꠃ ꠄꠇꠎꠘꠦ ꠜꠣꠉꠤꠀ ꠀꠁꠀ ꠁꠛꠞꠣꠘꠤ ꠀꠛ꠆ꠞꠣꠝꠞꠦ ꠅꠃ ꠈꠛꠞ ꠖꠤꠟ। ꠀꠛ꠆ꠞꠣꠝ ꠁ ꠡꠝꠄ ꠀꠝꠥꠞꠤ ꠝꠝ꠆ꠞꠤꠞ ꠄꠟꠘ ꠛꠘꠞ ꠇꠣꠍꠣꠔ ꠕꠣꠇꠔꠣ। ꠁ ꠝꠝ꠆ꠞꠤ ꠀꠍꠟꠣ ꠀꠡꠇꠥꠟ ꠀꠞ ꠀꠘꠦꠞꠞ ꠜꠣꠁ, ꠀꠛ꠆ꠞꠣꠝꠞ ꠟꠉꠦ ꠄꠞꠣꠞ ꠎꠥꠖ꠆ꠖꠞ ꠡꠣꠁꠎ꠆ꠎꠞ ꠌꠥꠇ꠆ꠔꠤ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","ꠔꠣꠘ ꠜꠣꠔꠤꠎꠣꠞꠦ ꠗꠞꠤꠀ ꠟꠁꠀ ꠉꠦꠍꠂꠘꠉꠤ ꠢꠥꠘꠤꠀ ꠀꠛ꠆ꠞꠣꠝꠦ ꠟꠣꠠꠣꠁ ꠎꠣꠘꠞꠣ ꠘꠤꠎꠞ ꠔꠤꠘ-ꠡ ꠀꠑꠣꠞ ꠎꠘ ꠉꠥꠟꠣꠝꠞꠦ ꠟꠁꠀ ꠖꠣꠘ ꠐꠣꠃꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠖꠥꠡꠝꠘꠞ ꠈꠞꠦ ꠈꠞꠦ ꠉꠦꠟꠣ। ꠅꠃ ꠉꠥꠟꠣꠝ ꠅꠇꠟ ꠔꠣꠘ ꠛꠣꠠꠤꠔꠃ ꠎꠘꠝꠤꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","ꠞꠣꠁꠔꠇꠥꠞ ꠛꠣꠟꠣ ꠖꠥꠡꠝꠘ ꠖꠟꠞ ꠟꠣꠉꠣꠟ ꠙꠣꠁꠀ ꠄꠞꠣ ꠢꠣꠝꠟꠣ ꠇꠞꠤꠀ ꠢꠦꠞꠣꠞꠦ ꠀꠞꠣꠁꠟ꠆ꠟꠣ, ꠀꠞ ꠈꠦꠖꠣꠁꠔꠦ ꠈꠦꠖꠣꠁꠔꠦ ꠖꠣꠝꠦꠡ꠆ꠇ ꠐꠣꠃꠘꠞ ꠃꠔꠞꠦ ꠢꠥꠛꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","ꠟꠥꠐ ꠇꠞꠣ ꠢꠇ꠆ꠇꠟ ꠎꠤꠘꠤꠡ ꠔꠣꠁꠘ ꠚꠤꠞꠣꠁꠀ ꠀꠘꠟꠣ, ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠡꠥꠖ꠆ꠖꠣ ꠔꠣꠘ ꠜꠣꠔꠤꠎꠣ ꠟꠥꠔꠞꠦꠅ ꠃꠖ꠆ꠖꠣꠞ ꠇꠞꠟꠣ। ꠄꠞ ꠟꠉꠦ ꠢꠇꠟ ꠛꠦꠐꠤꠘ꠆ꠔꠞꠦ ꠀꠞ ꠢꠇꠟ ꠝꠣꠘꠡꠞꠦꠅ ꠃꠖ꠆ꠖꠣꠞ ꠇꠞꠤ ꠀꠘꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","ꠇꠖꠞ-ꠟꠣꠃꠝꠞ ꠀꠞ ꠔꠣꠞ ꠟꠉꠞ ꠛꠣꠖꠡꠣ ꠅꠇꠟꠞꠦ ꠀꠞꠣꠁꠀ ꠀꠛ꠆ꠞꠣꠝ ꠚꠤꠞꠤꠀ ꠀꠅꠀꠞ ꠡꠝꠄ ꠍꠣꠖꠥꠝꠞ ꠛꠣꠖꠡꠣꠄ ꠔꠣꠘ ꠟꠉꠦ ꠖꠦꠈꠣ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠡꠣꠛꠤ ꠛꠣ ꠛꠣꠖꠡꠣ ꠘꠣꠝꠞ ꠔꠟ ꠎꠣꠉꠣꠔ ꠛꠣꠞ ꠅꠁꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","ꠀꠞ ꠡꠣꠟꠦꠝꠞ ꠛꠣꠖꠡꠣ ꠝꠣꠟꠇꠤ-ꠍꠤꠖ꠆ꠖꠤꠇꠦ ꠀꠛ꠆ꠞꠣꠝꠞ ꠟꠣꠉꠤ ꠞꠥꠐꠤ ꠀꠞ ꠀꠋꠉꠥꠞꠞ ꠡꠞꠛꠔ ꠟꠁꠀ ꠀꠁꠟꠣ, ꠔꠣꠁꠘ ꠅꠁꠟꠣ ꠀꠟ꠆ꠟꠣꠔꠣꠟꠣꠞ ꠙꠍꠘ꠆ꠖꠞ ꠁꠝꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ꠔꠣꠁꠘ ꠀꠛ꠆ꠞꠣꠝꠞꠦ ꠖꠥꠀ ꠇꠞꠤꠀ ꠇꠁꠟꠣ, “ꠎꠦꠁꠘ ꠀꠍꠝꠣꠘ ꠀꠞ ꠎꠝꠤꠘ ꠙꠄꠖꠣ ꠇꠞꠍꠂꠘ, ꠢꠃ ꠀꠟ꠆ꠟꠣꠔꠣꠟꠣ ꠀꠛ꠆ꠞꠣꠝꠞꠦ ꠛꠞꠇꠔ ꠖꠣꠘ ꠇꠞꠃꠇ꠆ꠇꠣ। ");
INSERT INTO syls_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","ꠀꠙꠘꠣꠞ ꠖꠥꠡꠝꠘ ꠅꠇꠟꠞꠦ ꠎꠦꠁꠘ ꠀꠙꠘꠣꠞ ꠀꠔꠅ ꠡꠙꠤꠍꠂꠘ, ꠔꠣꠘ ꠘꠣꠝ ꠗꠁꠘ꠆ꠘ ꠅꠃꠇ।” ꠅꠃ ꠀꠛ꠆ꠞꠣꠝꠦ ꠔꠣꠘ ꠢꠇ꠆ꠇꠟꠔꠣꠞ ꠖꠡꠛꠣꠐꠞ ꠄꠇꠛꠣꠐ ꠝꠣꠟꠇꠤ-ꠍꠤꠖ꠆ꠖꠤꠇꠞꠦ ꠖꠤꠟꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","ꠀꠞ ꠍꠣꠖꠥꠝꠞ ꠛꠣꠖꠡꠣꠄ ꠀꠛ꠆ꠞꠣꠝꠞꠦ ꠇꠁꠟꠣ, “ꠀꠙꠘꠦ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠢꠇꠟꠔꠣ ꠞꠣꠈꠤ ꠖꠦꠃꠇ꠆ꠇꠣ, ꠈꠣꠟꠤ ꠝꠣꠘꠥꠡ ꠉꠥꠁꠘ ꠀꠝꠣꠞꠦ ꠚꠤꠞꠔ ꠖꠤꠟꠣꠁꠘ।” ");
INSERT INTO syls_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","ꠀꠛ꠆ꠞꠣꠝꠦ ꠍꠣꠖꠥꠝꠞ ꠛꠣꠖꠡꠣꠞꠦ ꠇꠁꠟꠣ, “ꠎꠦꠁꠘ ꠀꠍꠝꠣꠘ-ꠎꠝꠤꠘ ꠙꠄꠖꠣ ꠇꠞꠍꠂꠘ ꠢꠃ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠔꠣꠟꠣꠞ ꠘꠣꠝꠦ ꠀꠝꠤ ꠀꠔ ꠔꠥꠟꠤꠀ ꠇꠍꠝ ꠇꠞꠍꠤ, ");
INSERT INTO syls_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ꠀꠙꠘꠣꠞ ꠇꠥꠘꠥ ꠎꠤꠘꠤꠡꠃ, ꠄꠇꠍꠣ ꠡꠥꠔꠣꠃ ꠛꠣ ꠙꠣꠅꠞ ꠎꠥꠔꠣꠞ ꠄꠇꠍꠣ ꠚꠤꠔꠣꠅ ꠀꠝꠤ ꠘꠤꠔꠣꠝ ꠘꠣꠄ। ꠀꠞꠘꠣꠄ ꠛꠣꠖꠦ ꠀꠙꠘꠦ ꠇꠁꠛꠣ, ꠀꠝꠣꠞ ꠗꠘꠦꠃ ꠀꠛ꠆ꠞꠣꠝ ꠗꠘꠤ ꠅꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","ꠀꠝꠣꠞ ꠝꠣꠘꠡꠦ ꠎꠦꠔꠣ ꠈꠣꠁꠟꠤꠍꠂꠘ ꠁꠔꠣ ꠍꠣꠠꠣ ꠀꠝꠤ ꠀꠞ ꠇꠤꠌ꠆ꠍꠥ ꠘꠤꠔꠣꠝ ꠘꠣꠄ। ꠈꠣꠟꠤ ꠀꠘꠦꠞ, ꠀꠡꠇꠥꠟ ꠀꠞ ꠝꠝ꠆ꠞꠤ ꠎꠦꠞꠣ ꠀꠝꠣꠞ ꠟꠉꠦ ꠉꠦꠍꠟꠣ, ꠔꠣꠞꠣꠞ ꠙꠣꠅꠘꠣ ꠛꠣꠐ ꠔꠣꠞꠣ ꠘꠦꠃꠇ꠆ꠇꠣꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ꠅꠔꠣ ꠊꠐꠘꠣ ꠅꠇꠟꠞ ꠛꠣꠖꠦ ꠅꠢꠤꠞ ꠝꠣꠎꠦ ꠝꠣꠛꠥꠖꠞ ꠇꠣꠟꠣꠝ ꠀꠛ꠆ꠞꠣꠝꠞ ꠉꠦꠍꠦ ꠘꠣꠎꠤꠟ ꠅꠁꠟ। ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠅ ꠀꠛ꠆ꠞꠣꠝ, ꠒꠞꠣꠁꠅ ꠘꠣ, ꠀꠝꠤꠃ ꠔꠥꠝꠣꠞ ꠢꠦꠚꠣꠎꠔꠇꠣꠞꠤ, ꠔꠥꠝꠣꠞ ꠛꠃꠔ ꠛꠠ ꠙꠥꠞꠥꠡ꠆ꠇꠣꠞ।” ");
INSERT INTO syls_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","ꠀꠛ꠆ꠞꠣꠝꠦ ꠇꠁꠟꠣ, “ꠅ ꠝꠣꠛꠥꠖ ꠝꠃꠟꠣ, ꠀꠝꠣꠞꠦ ꠇꠤꠔꠣ ꠖꠤꠔꠣꠄ? ꠀꠝꠤ ꠔ ꠘꠤꠀꠅꠟꠣꠖꠤ। ꠀꠝꠤ ꠝꠞꠣꠞ ꠛꠣꠖꠦ ꠖꠣꠝꠦꠡ꠆ꠇꠞ ꠄꠟꠤꠄꠎꠦꠞ ꠀꠝꠣꠞ ꠡꠝ꠆ꠙꠔ꠆ꠔꠤꠞ ꠝꠣꠟꠤꠇ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","ꠔꠥꠝꠤ ꠔ ꠀꠝꠣꠞꠦ ꠇꠥꠘꠥ ꠀꠅꠟꠣꠖ ꠖꠤꠟꠣꠄ ꠘꠣ, ꠄꠞꠟꠣꠉꠤ ꠀꠝꠣꠞ ꠛꠣꠠꠤꠞ ꠉꠥꠟꠣꠝ ꠀꠝꠣꠞ ꠅꠀꠞꠤꠡ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","ꠅꠃ ꠝꠣꠛꠥꠖꠦ ꠀꠛ꠆ꠞꠣꠝꠞꠦ ꠇꠁꠟꠣ, “ꠘꠣ, ꠢꠦ ꠘꠣꠄ, ꠔꠥꠝꠣꠞ ꠘꠤꠎꠞ ꠛꠃꠞ ꠀꠅꠟꠣꠖꠃ ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","ꠝꠣꠛꠥꠖꠦ ꠀꠛ꠆ꠞꠣꠝꠞꠦ ꠛꠣꠞꠦ ꠀꠘꠤꠀ ꠇꠁꠟꠣ, “ꠀꠍꠝꠣꠘꠞ ꠛꠣꠄ ꠌꠣꠅ, ꠀꠞ ꠙꠣꠞꠟꠦ ꠅꠃ ꠔꠦꠞꠣ ꠅꠇꠟ ꠉꠘꠤꠀ ꠚꠥꠠꠣꠅ, ꠔꠥꠝꠣꠞ ꠛꠋꠡꠞ ꠅꠀꠞꠤꠡ ꠅꠃꠟꠣ ꠛꠦꠢꠤꠡꠣꠛ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","ꠀꠛ꠆ꠞꠣꠝꠦ ꠝꠣꠛꠥꠖꠞ ꠅꠃ ꠅꠀꠖꠣꠞꠦ ꠄꠇꠤꠘ ꠇꠞꠟꠣ, ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠢꠃ ꠄꠇꠤꠘꠞꠦ ꠖꠤꠘꠖꠣꠞꠤ ꠇꠣꠝ ꠢꠤꠡꠣꠛꠦ ꠇꠛꠥꠟ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","ꠀꠞ ꠔꠣꠁꠘ ꠀꠛ꠆ꠞꠣꠝꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤꠃ ꠝꠣꠛꠥꠖ। ꠁ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠞ ꠅꠗꠤꠇꠣꠞꠤ ꠅꠁꠛꠣꠞ ꠟꠣꠉꠤ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠛꠣꠛꠤꠟ ꠖꠦꠡꠞ ꠃꠞ ꠐꠣꠃꠘ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤꠀ ꠀꠘꠍꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","ꠅꠃ ꠀꠛ꠆ꠞꠣꠝꠦ ꠇꠁꠟꠣ, “ꠅ ꠝꠣꠛꠥꠖ ꠝꠃꠟꠣ, ꠀꠝꠤ ꠁꠔꠣꠞ ꠝꠣꠟꠤꠇ ꠅꠁꠝꠥ ꠇꠞꠤ ꠇꠤꠟꠣ ꠛꠥꠎꠝꠥ?” ");
INSERT INTO syls_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠔꠤꠘ ꠛꠍꠞꠞ ꠄꠇꠐꠣ ꠇꠞꠤ ꠒꠦꠇꠤ, ꠍꠣꠉꠤ, ꠀꠞ ꠝꠦꠠꠣꠞ ꠙꠣꠑꠣ ꠀꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠟꠁꠀ ꠀꠅ, ꠄꠞ ꠟꠉꠦ ꠄꠇꠐꠣ ꠒꠥꠙꠤ ꠙꠣꠈꠤ ꠀꠞ ꠄꠇꠐꠣ ꠙꠣꠞꠅꠞ ꠛꠣꠁꠌ꠆ꠌꠣꠅ ꠀꠘꠤꠅ।” ");
INSERT INTO syls_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ꠀꠛ꠆ꠞꠣꠝꠦ ꠅꠃꠟꠣ ꠇꠞꠟꠣ। ꠔꠣꠁꠘ ꠁꠔꠣ ꠢꠇꠟꠐꠤ ꠀꠘꠤꠀ ꠖꠥꠁ ꠐꠥꠇꠞꠣ ꠇꠞꠤꠀ ꠃꠟꠐꠣ-ꠃꠟꠐꠤ ꠇꠞꠤ ꠢꠣꠎꠣꠁꠀ ꠞꠣꠈꠟꠣ, ꠈꠣꠟꠤ ꠙꠣꠈꠤ ꠅꠇꠟꠞꠦ ꠐꠥꠇꠞꠣꠁꠟꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","ꠔꠦꠃ ꠢꠇꠥꠘ ꠀꠁꠀ ꠅꠃ ꠐꠥꠇꠞꠣ ꠅꠇꠟꠞ ꠃꠙꠞꠦ ꠙꠠꠟꠦ, ꠀꠛ꠆ꠞꠣꠝꠦ ꠈꠦꠖꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","ꠡꠥꠞꠥꠎ ꠒꠥꠛꠣꠞ ꠡꠝꠄ ꠀꠛ꠆ꠞꠣꠝꠞ ꠄꠇ ꠛꠦꠃꠡꠤ ꠊꠥꠝ ꠀꠁꠟ। ꠊꠥꠝꠞ ꠝꠣꠎꠦ ꠛꠦꠕꠣꠄꠀ ꠒꠞ ꠀꠞ ꠀꠘ꠆ꠖꠣꠁꠞꠦ ꠔꠣꠘꠦ ꠀꠍꠞ ꠇꠞꠟ। ");
INSERT INTO syls_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","ꠅꠃ ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠘꠤꠌ꠆ꠌꠄ ꠅꠁꠀ ꠎꠣꠘꠤꠅ, ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡ ꠅꠇꠟꠦ ꠅꠃꠟꠣ ꠖꠦꠡꠅ ꠉꠤꠀ ꠞꠁꠛꠣ ꠎꠦꠇꠐꠣ ꠔꠣꠞꠣꠞ ꠘꠤꠎꠞ ꠘꠣꠄ। ꠢꠘꠅ ꠔꠣꠞꠣ ꠈꠥꠛ ꠎꠥꠟꠥꠝ-ꠝꠍꠤꠛꠔꠞ ꠝꠣꠎꠦ ꠞꠁꠀ ꠌꠣꠁꠞ-ꠡ ꠛꠞꠍ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠉꠥꠟꠣꠝꠤ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","ꠀꠞ ꠎꠦ ꠎꠣꠔꠤꠄ ꠔꠣꠞꠣꠞꠦ ꠉꠥꠟꠣꠝ ꠛꠣꠘꠣꠁꠛꠣ, ꠀꠝꠤ ꠢꠤ ꠎꠣꠔꠤꠞ ꠛꠤꠌꠣꠞ ꠇꠞꠝꠥ। ꠛꠣꠖꠦ ꠔꠣꠞꠣ ꠛꠃꠔ ꠗꠘ-ꠖꠃꠟꠔ ꠟꠁꠀ ꠢꠘ ꠕꠘꠦ ꠛꠣꠞ ꠅꠁꠀ ꠀꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","ꠀꠞ ꠔꠥꠝꠤ ꠡꠣꠘ꠆ꠔꠤꠄ ꠔꠥꠝꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠉꠦꠍꠦ ꠎꠣꠁꠛꠣꠄ। ꠔꠥꠝꠤ ꠙꠥꠞꠣ ꠝꠥꠞꠛ꠆ꠛꠤ ꠛꠄꠅꠡꠅ ꠇꠄꠛꠞꠅ ꠢꠣꠝꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","ꠔꠥꠝꠣꠞ ꠌꠣꠁꠞ ꠍꠤꠠꠤ ꠛꠣꠖꠦ ꠄꠞꠣ ꠅꠘꠅ ꠚꠤꠞꠤꠀ ꠀꠁꠛꠣ, ꠇꠣꠞꠘ ꠀꠝꠥꠞꠤ ꠅꠇꠟꠞ ꠉꠥꠘꠣ ꠅꠈꠘꠅ ꠙꠥꠞꠣ ꠅꠁꠍꠦ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","ꠡꠥꠞꠥꠎ ꠒꠥꠛꠤꠀ ꠎꠦꠛꠟꠣ ꠀꠘ꠆ꠖꠣꠁꠞ ꠅꠁꠉꠦꠟ ꠅꠃ ꠡꠝꠄ ꠗꠥꠝꠣꠄ ꠜꠞꠣ ꠄꠇ ꠃꠘ꠆ꠖꠣꠟ ꠀꠞ ꠀꠉꠥꠘꠤꠞ ꠝꠥꠡꠣꠟ ꠢꠃ ꠢꠣꠎꠣꠁꠀ ꠞꠣꠈꠣ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠐꠥꠇꠞꠣꠁꠘ꠆ꠔꠞ ꠝꠣꠎꠦꠖꠤ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ꠝꠣꠛꠥꠖꠦ ꠢꠃ ꠖꠤꠘꠃ ꠀꠛ꠆ꠞꠣꠝꠞ ꠟꠉꠦ ꠅꠃꠟꠣ ꠅꠀꠖꠣ ꠇꠞꠟꠣ, “ꠝꠤꠡꠞꠞ ꠉꠣꠋ ꠕꠘꠦ ꠛꠠ ꠉꠣꠋ ꠚꠥꠞꠣꠔ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠀꠡ꠆ꠔꠣ ꠖꠦꠡ ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡꠞꠦ ꠖꠤꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ꠁꠇꠐꠣ ꠅꠁꠟ ꠇꠦꠘꠤ, ꠇꠘꠤꠎꠤ, ꠇꠖꠝꠥꠘꠤ, ");
INSERT INTO syls_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ꠢꠤꠐ꠆ꠐꠤ, ꠚꠣꠞꠤꠎꠤ, ꠞꠚꠣꠄꠁ, ");
INSERT INTO syls_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ꠀꠝꠥꠞꠤ, ꠇꠦꠘꠣꠘꠤ, ꠉꠤꠞ꠆ꠉꠣꠡꠤ ꠀꠞ ꠎꠤꠛꠥꠎꠤ ꠅꠇꠟꠞ ꠖꠦꠡ।” ");
INSERT INTO syls_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","ꠛꠤꠛꠤ ꠍꠣꠞꠣꠞ ꠙꠦꠐꠅ ꠀꠛ꠆ꠞꠣꠝꠞ ꠇꠥꠘꠥ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠅꠁꠍꠂꠘ ꠘꠣ, ꠅꠁꠟꠦ ꠢꠣꠎꠦꠞꠣ ꠘꠣꠝꠦ ꠍꠣꠞꠣꠞ ꠄꠇ ꠝꠤꠡꠞꠤ ꠛꠣꠘ꠆ꠖꠤ ꠛꠦꠐꠤ ꠀꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","ꠄꠇꠖꠤꠘ ꠍꠣꠞꠣꠄ ꠀꠛ꠆ꠞꠣꠝꠞꠦ ꠇꠁꠟꠣ, “ꠢꠥꠘꠅ, ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞꠦ ꠘꠤꠀꠅꠟꠣꠖꠤ ꠇꠞꠍꠂꠘ। ꠔꠦ ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠛꠣꠘ꠆ꠖꠤꠞ ꠇꠣꠍꠣꠔ ꠎꠣꠅ, ꠇꠤꠛꠣ ꠔꠣꠁꠞꠦ ꠖꠤꠀ ꠀꠝꠤ ꠀꠅꠟꠣꠖ ꠙꠣꠁꠟꠤꠔꠣꠝ ꠙꠣꠞꠤ।” ꠅꠃ ꠀꠛ꠆ꠞꠣꠝꠅ ꠍꠣꠞꠣꠞ ꠝꠣꠔꠦ ꠞꠣꠎꠤ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠀꠛ꠆ꠞꠣꠝ ꠖꠡ ꠛꠞꠍ ꠞꠅꠀꠞ ꠛꠣꠖꠦ ꠍꠣꠞꠣꠄ ꠔꠣꠘ ꠝꠤꠡꠞꠤ ꠛꠣꠘ꠆ꠖꠤ ꠢꠣꠎꠦꠞꠣꠞꠦ ꠘꠤꠎꠞ ꠎꠣꠝꠣꠁ ꠀꠛ꠆ꠞꠣꠝꠞ ꠟꠉꠦ ꠛꠤꠀ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","ꠛꠣꠖꠦ ꠀꠛ꠆ꠞꠣꠝ ꠀꠞ ꠢꠣꠎꠦꠞꠣ ꠄꠇꠈꠣꠘꠅ ꠞꠁꠟꠦ ꠔꠣꠁꠞ ꠙꠦꠐꠅ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠀꠁꠟ। ꠢꠣꠎꠦꠞꠣꠄ ꠎꠦꠛꠟꠣ ꠛꠥꠎꠟ ꠔꠣꠁꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠅꠁꠔꠣ ꠔꠦꠃ ꠔꠣꠁꠞ ꠝꠣꠟꠤꠇ ꠛꠤꠛꠤꠞ ꠛꠣꠄ ꠛꠠꠣꠁ ꠖꠦꠈꠣꠘꠤꠔ ꠟꠣꠉꠟ। ");
INSERT INTO syls_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","ꠅꠃ ꠍꠣꠞꠣꠄ ꠀꠛ꠆ꠞꠣꠝꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠛꠣꠄ ꠔꠣꠁꠞ ꠛꠦꠀꠖꠛꠤꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠤꠃ ꠖꠣꠄꠁ। ꠀꠝꠣꠞ ꠁ ꠛꠣꠘ꠆ꠖꠤꠞꠦ ꠀꠝꠤꠃ ꠔꠥꠝꠣꠞ ꠛꠤꠍꠘꠣꠔ ꠔꠥꠟꠤꠀ ꠖꠤꠍꠟꠣꠝ, ꠀꠞ ꠅꠈꠘ ꠔꠣꠁꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠅꠁꠔꠣ ꠇꠞꠤ ꠀꠝꠣꠞꠦ ꠛꠠꠣꠁ ꠖꠦꠈꠣꠞ। ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠣꠞ-ꠀꠝꠣꠞ ꠛꠤꠌꠣꠞ ꠇꠞꠃꠇ꠆ꠇꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","ꠀꠛ꠆ꠞꠣꠝꠦ ꠍꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠖꠦꠈꠅ, ꠔꠥꠝꠣꠞ ꠛꠣꠘ꠆ꠖꠤ ꠔ ꠔꠥꠝꠣꠞ ꠀꠔꠅꠃ ꠀꠍꠦ। ꠔꠥꠝꠣꠞ ꠎꠦꠟꠣ ꠜꠣꠟꠣ ꠝꠘꠦ ꠇꠄ ꠅꠟꠣꠃ ꠇꠞꠅ।” ꠅꠃ ꠍꠣꠞꠣꠄ ꠢꠣꠎꠦꠞꠣꠞꠦ ꠅꠃꠟꠣ ꠖꠥꠈ ꠖꠤꠟꠣ, ꠖꠥꠈꠦ ꠔꠣꠁ ꠔꠣꠘ ꠉꠦꠍ ꠕꠣꠇꠤ ꠜꠣꠉꠤꠀ ꠉꠦꠟꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","ꠙꠕꠅ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠝꠣꠎꠦ ꠄꠇꠐꠣ ꠙꠣꠘꠤꠞ ꠁꠘ꠆ꠖꠣꠞꠣꠞ ꠇꠣꠍꠣꠔ ꠝꠣꠛꠥꠖꠞ ꠚꠤꠞꠤꠡ꠆ꠔꠣꠄ ꠢꠣꠎꠦꠞꠣꠞꠦ ꠙꠣꠁꠟꠣ। ꠁ ꠁꠘ꠆ꠖꠣꠞꠣ ꠀꠍꠤꠟ ꠡꠥꠞ ꠘꠣꠝꠞ ꠎꠣꠉꠣꠔ ꠎꠣꠅꠀꠞ ꠙꠕꠅ। ");
INSERT INTO syls_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ꠚꠤꠞꠤꠡ꠆ꠔꠣꠄ ꠇꠁꠟꠣ, “ꠅ ꠍꠣꠞꠣꠞ ꠛꠣꠘ꠆ꠖꠤ ꠢꠣꠎꠦꠞꠣ, ꠔꠥꠝꠤ ꠇꠁ ꠕꠣꠇꠤ ꠀꠁꠞꠣꠄ ꠀꠞ ꠇꠁ ꠎꠣꠁꠔꠣꠄ?” ꠢꠣꠎꠦꠞꠣꠄ ꠇꠁꠟ, “ꠀꠝꠤ ꠀꠝꠣꠞ ꠝꠣꠟꠤꠇ ꠛꠤꠛꠤ ꠍꠣꠞꠣꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠜꠣꠉꠤꠀ ꠎꠣꠁꠞꠣꠝꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","ꠔꠦꠃ ꠝꠣꠛꠥꠖꠞ ꠚꠤꠞꠤꠡ꠆ꠔꠣꠄ ꠇꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠝꠣꠟꠤꠇ ꠛꠤꠛꠤꠞ ꠉꠦꠍꠦ ꠚꠤꠞꠤꠀ ꠉꠤꠀ ꠇꠟ꠆ꠟꠣ ꠘꠥꠀꠁꠀ ꠢꠤꠞꠛꠣꠞ ꠔꠣꠘ ꠈꠦꠎꠝꠔꠅ ꠟꠣꠉꠅ।” ");
INSERT INTO syls_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","ꠔꠣꠁꠘ ꠀꠞꠅ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡ ꠅꠃꠟꠣ ꠛꠣꠠꠣꠁ ꠖꠤꠝꠥ, ꠔꠣꠞꠣꠞꠦ ꠉꠘꠤꠀ ꠚꠥꠠꠣꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","ꠢꠥꠘꠅ, ꠔꠥꠝꠣꠞ ꠙꠦꠐꠅ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠀꠍꠦ। ꠔꠥꠝꠣꠞ ꠄꠇ ꠙꠥꠀ ꠅꠁꠛ, ꠔꠣꠞ ꠘꠣꠝ ꠞꠣꠈꠤꠅ ꠁꠍꠝꠣꠁꠟ ꠝꠣꠘꠤ, ꠀꠟ꠆ꠟꠣꠄ ꠢꠥꠘꠂꠘ, ꠇꠣꠞꠘ ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠣꠞ ꠖꠥꠈ ꠢꠥꠘꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","ꠀꠞ ꠛꠠ ꠅꠁꠟꠦ ꠢꠦ ꠟꠣꠉꠣꠝ ꠍꠣꠠꠣ ꠊꠥꠠꠣꠞ ꠟꠣꠈꠣꠘ ꠅꠁꠛ। ꠢꠦ ꠢꠇ꠆ꠇꠟꠞ ꠛꠣꠄ ꠀꠔ ꠔꠥꠟꠛ, ꠀꠞ ꠢꠇ꠆ꠇꠟꠦ ꠔꠣꠞ ꠛꠣꠄ ꠀꠔ ꠔꠥꠟꠛꠣ। ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞ ꠟꠉꠦ ꠢꠣꠝꠦꠡꠣ ꠔꠣꠞ ꠟꠣꠉ ꠕꠣꠇꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","ꠀꠞ ꠢꠣꠎꠦꠞꠣꠞ ꠟꠉꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠣꠔꠤꠟꠣ ꠇꠞꠤ, ꠔꠣꠁ ꠔꠣꠘ ꠘꠣꠝ ꠖꠤꠟ “ꠔꠥꠝꠤ ꠖꠦꠈꠣ ꠖꠦꠘꠦꠀꠟꠣ ꠀꠟ꠆ꠟꠣ”; ꠔꠣꠁ ꠇꠁꠟ, “ꠎꠦꠁꠘ ꠀꠝꠣꠞꠦ ꠖꠦꠈꠂꠘ, ꠀꠝꠤ ꠅꠘꠅꠃ ꠔꠣꠘꠞꠦ ꠖꠦꠈꠟꠣꠝ ꠘꠣꠄ ꠘꠤ?” ");
INSERT INTO syls_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","ꠄꠞꠟꠣꠉꠤ ꠇꠣꠖꠦꠡ ꠀꠞ ꠛꠦꠞꠦꠖꠞ ꠝꠣꠎꠞ ꠢꠤ ꠇꠥꠀꠞ ꠘꠣꠝ ꠅꠁꠟ, ꠛꠦꠞ-ꠟꠢꠄ-ꠞꠥꠁ ꠝꠣꠘꠤ, ꠎꠦꠁꠘ ꠎꠤꠘ꠆ꠖꠣ ꠀꠞ ꠀꠝꠣꠞꠦ ꠖꠦꠈꠞꠣ, ꠔꠣꠘ ꠇꠥꠀ। ");
INSERT INTO syls_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ꠛꠣꠖꠦ ꠡꠝꠄ ꠀꠁꠟꠦ ꠢꠣꠎꠦꠞꠣꠞ ꠊꠞꠅ ꠄꠇ ꠙꠥꠀ ꠅꠁꠟ, ꠀꠛ꠆ꠞꠣꠝꠦ ꠅꠃ ꠙꠥꠀꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠁꠍꠝꠣꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","ꠀꠛ꠆ꠞꠣꠝꠞ ꠛꠄꠅꠡ ꠎꠦꠛꠟꠣ ꠍꠤꠀꠡꠤ ꠛꠍꠞ ꠅꠁꠉꠦꠍꠦ, ꠅꠃ ꠡꠝꠄ ꠢꠣꠎꠦꠞꠣꠞ ꠊꠞꠅ ꠁꠍꠝꠣꠁꠟꠞ ꠎꠘꠝ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","ꠀꠛ꠆ꠞꠣꠝꠞ ꠘꠤꠞꠣꠘ꠆ꠘꠛ꠆ꠛꠁ ꠛꠞꠍꠞ ꠡꠝꠄ ꠝꠣꠛꠥꠖꠦ ꠢꠤꠞꠛꠣꠞ ꠔꠣꠘꠞꠦ ꠖꠤꠖꠣꠞ ꠖꠤꠀ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠡꠞ꠆ꠛ-ꠡꠇ꠆ꠔꠤꠝꠣꠘ ꠀꠟ꠆ꠟꠣ। ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠖꠦꠅꠀ ꠙꠕꠅ ꠕꠣꠇꠤꠀ ꠇꠣꠝꠤꠟ ꠅꠅ। ");
INSERT INTO syls_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","ꠀꠝꠤ ꠔꠥꠝꠣꠞ-ꠀꠝꠣꠞ ꠝꠣꠎꠦ ꠌꠥꠇ꠆ꠔꠤ ꠇꠣꠁꠝ ꠇꠞꠝꠥ ꠀꠞ ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡ ꠈꠥꠛ ꠛꠦꠡꠤ ꠛꠣꠠꠣꠁ ꠖꠤꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","ꠔꠦꠃ ꠀꠛ꠆ꠞꠣꠝ ꠍꠁꠎꠖꠣꠔ ꠙꠠꠟꠣ, ꠀꠞ ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠘ ꠟꠉꠦ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠤ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠀꠝꠤ ꠅꠀꠖꠣ ꠇꠣꠁꠝ ꠇꠞꠤꠀꠞ, ꠔꠥꠝꠤ ꠛꠃꠔ ꠎꠣꠔꠤꠞ ꠝꠥꠟ ꠛꠣꠚ ꠅꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","ꠔꠥꠝꠣꠞꠦ ꠀꠞ ꠀꠛ꠆ꠞꠣꠝ ꠝꠣꠘꠤ, ꠛꠠ ꠛꠣꠚ ꠇꠁꠀ ꠒꠣꠇꠣ ꠅꠁꠔ ꠘꠣꠄ, ꠅꠈꠘ ꠕꠣꠇꠤ ꠔꠥꠝꠣꠞ ꠘꠣꠝ ꠅꠁꠟ ꠁꠛ꠆ꠞꠣꠢꠤꠝ ꠝꠣꠘꠤ, ꠛꠃꠔ ꠎꠣꠔꠤꠞ ꠛꠣꠚ, ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠛꠃꠔ ꠎꠣꠔꠤꠞ ꠝꠥꠟ ꠛꠣꠚ ꠛꠣꠘꠣꠁꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠛꠃꠔ ꠚꠟꠀꠟꠣ ꠇꠞꠝꠥ, ꠀꠞ ꠔꠥꠝꠣꠞ ꠝꠣꠎ ꠕꠘꠦ ꠛꠃꠔ ꠎꠣꠔꠤ ꠀꠞ ꠛꠣꠖꠡꠣ ꠅꠇꠟ ꠙꠄꠖꠣ ꠇꠞꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠀꠞ ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠅꠇꠟꠞ ꠟꠉꠦ ꠎꠦ ꠌꠥꠇ꠆ꠔꠤ ꠇꠣꠁꠝ ꠇꠞꠝꠥ, ꠁꠇꠐꠣ ꠢꠞ-ꠢꠣꠝꠦꠡꠣ ꠛꠅꠀꠁꠟ ꠕꠣꠇꠛ, ꠅꠃ ꠃꠍꠤꠟ꠆ꠟꠣꠄ ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠀꠞ ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠅꠇꠟꠞ ꠀꠟ꠆ꠟꠣ ꠅꠁꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","ꠀꠞ ꠎꠦ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠔꠥꠝꠤ ꠅꠈꠘ ꠝꠥꠍꠣꠚꠤꠞ ꠅꠁꠀ ꠕꠣꠇꠞꠣꠄ, ꠁ ꠙꠥꠞꠣꠐꠣꠃ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠀꠞ ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡ ꠅꠇꠟꠞꠦ ꠢꠞ-ꠢꠣꠝꠦꠡꠣꠇꠥꠞ ꠖꠈꠟꠞ ꠟꠣꠉꠤ ꠖꠤꠝꠥ। ꠀꠝꠤ ꠔꠣꠞꠣꠞ ꠀꠟ꠆ꠟꠣ ꠅꠁꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ꠀꠟ꠆ꠟꠣꠄ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠇꠣꠁꠝ ꠇꠞꠣ ꠌꠥꠇ꠆ꠔꠤ ꠝꠣꠘꠤꠅ, ꠔꠥꠝꠤ ꠀꠞ ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠅꠇꠟꠦꠅ ꠝꠣꠘꠤꠀ ꠌꠟꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠅꠀꠞꠤꠡꠞ ꠟꠉꠦ ꠀꠝꠣꠞ ꠅꠃꠟꠣ ꠌꠥꠇ꠆ꠔꠤ ꠇꠣꠁꠝ ꠅꠁꠟ, ꠔꠥꠝꠞꠣꠞ ꠢꠇꠟ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠞ ꠝꠍꠟꠝꠣꠘꠤ ꠇꠣꠝ ꠇꠞꠣꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","ꠔꠥꠝꠞꠣ ꠢꠇꠟꠦ ꠘꠤꠎꠞ ꠙꠥꠞꠥꠡ ꠅꠋꠉꠞ ꠝꠥꠈꠣꠞ ꠌꠣꠝꠠꠣ ꠇꠣꠐꠛꠣꠄ। ꠅꠇꠐꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠀꠞ ꠀꠝꠣꠞ ꠝꠣꠎꠦ ꠛꠅꠀꠁꠟ ꠇꠞꠣ ꠌꠥꠇ꠆ꠔꠤꠞ ꠘꠤꠡꠣꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤꠀ ꠔꠥꠝꠞꠣꠞ ꠢꠇꠟ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠎꠘꠝꠞ ꠀꠐ ꠖꠤꠘꠞ ꠖꠤꠘ ꠝꠍꠟꠝꠣꠘꠤ ꠇꠞꠣꠁꠛꠣꠄ। ꠎꠣꠞꠣ ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡ ꠘꠣꠄ, ꠈꠣꠟꠤ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠠꠤꠔ ꠎꠘꠝꠤꠍꠦ ꠛꠣ ꠔꠥꠝꠞꠣꠞ ꠈꠞꠤꠖꠣ ꠉꠥꠟꠣꠝ, ꠔꠣꠞꠣꠞꠅ ꠝꠍꠟꠝꠣꠘꠤ ꠇꠞꠣꠘꠤ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","ꠔꠥꠝꠞꠣꠞ ꠊꠞꠅ ꠎꠘꠝꠤꠍꠦ ꠛꠣ ꠈꠞꠤꠖꠣ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠞꠦ ꠘꠤꠌꠄ ꠝꠍꠟꠝꠣꠘꠤ ꠇꠞꠣꠁꠛꠣꠄ। ꠔꠥꠝꠞꠣꠞ ꠡꠞꠤꠟꠅ ꠎꠣꠞꠤ ꠇꠞꠣ ꠀꠝꠣꠞ ꠁ ꠌꠥꠇ꠆ꠔꠤ ꠢꠞ-ꠢꠣꠝꠦꠡꠣꠇꠥꠞ ꠌꠥꠇ꠆ꠔꠤ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","ꠎꠦ ꠛꠦꠐꠣꠄ ꠙꠥꠞꠥꠡ ꠅꠋꠉꠞ ꠝꠥꠈꠣꠞ ꠌꠣꠝꠠꠣ ꠇꠣꠐꠔ ꠘꠣꠄ, ꠔꠣꠞꠦ ꠔꠣꠞ ꠎꠣꠔꠤꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠚꠥꠍꠤꠀ ꠚꠣꠟꠣꠁꠟ ꠅꠁꠛ। ꠢꠦ ꠔ ꠀꠝꠣꠞ ꠌꠥꠇ꠆ꠔꠤꠞ ꠛꠞꠈꠦꠟꠣꠚ ꠇꠞꠍꠦ।” ");
INSERT INTO syls_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","ꠀꠟ꠆ꠟꠣꠄ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠛꠤꠛꠤꠞꠦ ꠀꠞ ꠍꠣꠞꠣ ꠇꠁꠀ ꠒꠣꠇꠤꠅ ꠘꠣ। ꠄꠘ ꠘꠣꠝ ꠅꠁꠛ ꠍꠣꠄꠞꠣ ꠝꠣꠘꠤ, ꠞꠣꠘꠤ। ");
INSERT INTO syls_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","ꠀꠝꠤ ꠔꠣꠁꠞꠦ ꠛꠞꠇꠔ ꠘꠣꠎꠤꠟ ꠇꠞꠝꠥ, ꠔꠣꠁꠞ ꠊꠞꠅ ꠔꠥꠝꠣꠞ ꠄꠇ ꠙꠥꠀ ꠖꠤꠝꠥ। ꠀꠞ ꠛꠞꠇꠔ ꠘꠣꠎꠤꠟ ꠇꠞꠤꠀ ꠛꠃꠔ ꠎꠣꠔꠤꠞ ꠝꠥꠟ ꠝꠣ ꠛꠣꠘꠣꠁꠝꠥ, ꠀꠞ ꠛꠃꠔ ꠝꠥꠟ꠆ꠟꠥꠇꠞ ꠛꠣꠖꠡꠣ ꠅꠇꠟꠅ ꠙꠄꠖꠣ ꠅꠁꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","ꠅꠃ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠝꠣꠐꠤꠔ ꠍꠁꠎꠖꠣꠔ ꠙꠠꠤ ꠀꠡꠤꠀ ꠝꠘꠦ ꠝꠘꠦ ꠇꠁꠟꠣ, “ꠢꠣꠍꠣꠃ ꠄꠇ-ꠡ ꠛꠍꠞꠞ ꠛꠥꠠꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠅꠁꠔ ꠘꠤ! ꠔꠣ-ꠅ ꠘꠛ꠆ꠛꠁ ꠛꠍꠞꠞ ꠛꠥꠠꠤ ꠍꠣꠄꠞꠣꠞ ꠙꠦꠐꠅ?” ");
INSERT INTO syls_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","ꠔꠣꠁꠘ ꠀꠟ꠆ꠟꠣꠞꠦ ꠇꠁꠟꠣ, “ꠀꠢ! ꠁꠍꠝꠣꠁꠟꠉꠥ ꠎꠣꠘꠥ ꠔꠥꠝꠣꠞ ꠞꠢꠝꠔꠦ ꠛꠣꠌꠤꠀ ꠕꠣꠇꠦ।” ");
INSERT INTO syls_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","ꠅꠃ ꠀꠟ꠆ꠟꠣꠄ ꠚꠞꠝꠣꠁꠟꠣ, “ꠑꠤꠇ ꠀꠍꠦ। ꠅꠁꠟꠦ ꠔꠥꠝꠣꠞ ꠛꠤꠛꠤ ꠍꠣꠄꠞꠣꠞ ꠙꠦꠐꠅ ꠢꠣꠍꠣꠃ ꠔꠥꠝꠣꠞ ꠙꠥꠀ ꠅꠁꠛ, ꠔꠥꠝꠤ ꠔꠣꠞ ꠘꠣꠝ ꠞꠣꠈꠛꠣꠄ ꠁꠍꠢꠣꠇ ꠝꠣꠘꠤ, ꠢꠦ ꠀꠡꠦ। ꠔꠣꠞ ꠟꠉꠦ ꠀꠝꠣꠞ ꠌꠥꠇ꠆ꠔꠤ ꠇꠣꠁꠝ ꠇꠞꠝꠥ, ꠔꠣꠞ ꠅꠀꠞꠤꠡꠞ ꠟꠉꠦ ꠁꠇꠐꠣ ꠀꠝꠣꠞ ꠢꠞ-ꠢꠣꠝꠦꠡꠣꠇꠥꠞ ꠌꠥꠇ꠆ꠔꠤ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","ꠀꠞ ꠁꠍꠝꠣꠁꠟꠞ ꠟꠣꠉꠤꠅ ꠔꠥꠝꠣꠞ ꠖꠥꠀ ꠢꠥꠘꠍꠤ। ꠢꠥꠘꠅ, ꠀꠝꠤ ꠔꠣꠞꠦꠅ ꠛꠞꠇꠔ ꠘꠣꠎꠤꠟ ꠇꠞꠝꠥ ꠀꠞ ꠔꠣꠞꠦ ꠚꠟꠀꠟꠣ ꠇꠞꠤꠀ ꠛꠃꠔ ꠛꠣꠠꠣꠁ ꠖꠤꠝꠥ। ꠢꠦ ꠛꠣꠞꠅꠎꠘ ꠞꠣꠎꠣꠞ ꠛꠣꠚ ꠅꠁꠛ ꠀꠞ ꠔꠣꠞ ꠝꠣꠎꠦꠖꠤ ꠀꠝꠤ ꠛꠤꠞꠣꠐ ꠎꠣꠔꠤ ꠙꠄꠖꠣ ꠇꠞꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","ꠍꠣꠝꠘꠞ ꠛꠞꠍ ꠁ ꠌꠣꠘ꠆ꠖꠅ ꠍꠣꠄꠞꠣꠞ ꠊꠞꠅ ꠔꠥꠝꠣꠞ ꠎꠦ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠅꠁꠛ, ꠢꠃ ꠁꠍꠢꠣꠇꠞ ꠟꠉꠦ ꠀꠝꠤ ꠀꠝꠣꠞ ꠌꠥꠇ꠆ꠔꠤ ꠇꠣꠁꠝ ꠇꠞꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠟꠉꠦ ꠛꠣꠔꠌꠤꠔ ꠡꠦꠡ ꠇꠞꠤꠀ ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠘ ꠉꠦꠍ ꠕꠣꠇꠤ ꠃꠑꠤꠀ ꠔꠡꠞꠤꠚ ꠘꠤꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ꠀꠟ꠆ꠟꠣꠞ ꠢꠥꠇꠥꠝ ꠝꠔ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠢꠃ ꠖꠤꠘꠃ ꠁꠍꠝꠣꠁꠟꠞꠦ ꠝꠍꠟꠝꠣꠘꠤ ꠇꠞꠣꠁꠟꠣ। ꠄꠞ ꠟꠉꠦ ꠈꠞꠤꠖꠣ ꠉꠥꠟꠣꠝ ꠅꠇꠟ ꠀꠞ ꠔꠣꠘ ꠛꠣꠠꠤꠔ ꠎꠘꠝꠤꠍꠦ ꠁꠟꠣ ꠢꠇꠟ ꠉꠥꠟꠣꠝꠞꠦ, ꠛꠣꠠꠤꠞ ꠢꠇ꠆ꠇꠟ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠞꠦ ꠝꠍꠟꠝꠣꠘꠤ ꠇꠞꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠘꠤꠎꠞ ꠝꠍꠟꠝꠣꠘꠤ ꠇꠣꠝ ꠇꠞꠣꠘꠤꠞ ꠡꠝꠄ ꠔꠣꠘ ꠛꠄꠅꠡ ꠀꠍꠤꠟ ꠘꠤꠞꠣꠘ꠆ꠘꠛ꠆ꠛꠁ ꠛꠞꠍ, ");
INSERT INTO syls_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ꠀꠞ ꠔꠣꠘ ꠙꠥꠀ ꠁꠍꠝꠣꠁꠟꠞ ꠛꠄꠅꠡ ꠔꠦꠞꠅ। ");
INSERT INTO syls_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","ꠄꠇ ꠖꠤꠘꠦꠃ ꠁꠛ꠆ꠞꠣꠢꠤꠝ ꠀꠞ ꠔꠣꠘ ꠙꠥꠀ ꠁꠍꠝꠣꠁꠟꠞ ꠝꠍꠟꠝꠣꠘꠤ ꠇꠞꠣꠁꠟ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ꠢꠤ ꠖꠤꠘ ꠛꠣꠠꠤꠞ ꠢꠇꠟ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠞ, ꠎꠣꠞꠣ ꠔꠣꠘ ꠛꠣꠠꠤꠔ ꠎꠘꠝꠤꠍꠤꠟ ꠀꠞ ꠎꠦꠞꠣꠞꠦ ꠛꠤꠖꠦꠡ ꠕꠣꠇꠤ ꠟꠁꠀ ꠀꠘꠍꠂꠘ, ꠁꠔꠣ ꠢꠇꠟꠞꠃ ꠝꠍꠟꠝꠣꠘꠤ ꠇꠣꠝ ꠄꠇꠟꠉꠦ ꠇꠞꠣꠁꠟ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","ꠛꠣꠖꠦ ꠝꠝ꠆ꠞꠤꠞ ꠄꠟꠘ ꠛꠘꠞ ꠇꠣꠍꠣꠔ ꠝꠣꠛꠥꠖꠦ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞꠦ ꠖꠦꠈꠣ ꠖꠤꠟꠣ। ꠔꠣꠁꠘ ꠖꠤꠘꠞ ꠉꠞꠝꠞ ꠡꠝꠄ ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠞꠎꠣꠔ ꠛꠅꠀꠔ ꠀꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","ꠅꠃꠟꠣ ꠡꠝꠄ ꠌꠃꠈ ꠔꠥꠟꠤꠀ ꠖꠦꠈꠟꠣ, ꠔꠣꠘ ꠍꠣꠝꠘꠦ ꠔꠤꠘꠎꠘ ꠝꠣꠘꠥꠡ ꠃꠛꠣꠁ ꠞꠁꠍꠂꠘ। ꠖꠦꠈꠤꠀꠃ ꠔꠣꠁꠘ ꠖꠞꠎꠣꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠖꠃꠠꠣꠁꠀ ꠉꠤꠀ, ꠝꠣꠐꠤꠔ ꠍꠁꠎꠖꠣ ꠇꠞꠤꠀ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","“ꠅ ꠝꠥꠘꠤꠛ, ꠀꠝꠤ ꠎꠥꠖꠤ ꠀꠙꠘꠣꠞꠣꠞ ꠝꠣꠄꠀꠞ ꠇꠥꠘꠥ ꠝꠣꠘꠥꠡ ꠅꠁ, ꠔꠣꠁꠟꠦ ꠀꠙꠘꠣꠞꠣꠞ ꠁ ꠉꠥꠟꠣꠝꠞꠦ ꠚꠣꠟꠣꠁꠀ ꠎꠣꠁꠘ ꠘꠣ ꠎꠦꠘ। ");
INSERT INTO syls_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","ꠀꠝꠤ ꠕꠥꠠꠣ ꠙꠣꠘꠤ ꠀꠘꠤꠀ ꠖꠤꠀꠞ ꠀꠙꠘꠣꠞꠣ ꠀꠔ-ꠙꠣꠅ ꠗꠁꠀ, ꠅꠃ ꠉꠣꠍ ꠔꠟꠣꠔ ꠎꠤꠞꠣꠃꠇ꠆ꠇꠣ। ");
INSERT INTO syls_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ꠀꠞ ꠁ ꠉꠥꠟꠣꠝꠞ ꠇꠣꠍꠣꠔ ꠎꠦꠛꠟꠣ ꠀꠁꠍꠂꠘ, ꠔꠦ ꠕꠥꠠꠣ ꠈꠣꠘꠤ ꠀꠘꠤꠀ ꠖꠦꠁ, ꠅꠔꠣ ꠈꠣꠁꠀ ꠎꠣꠘꠅ ꠀꠞꠣꠝ ꠅꠁꠟꠦ ꠀꠙꠘꠣꠞꠣ ꠢꠤꠞꠛꠣꠞ ꠞꠅꠀꠘꠣ ꠖꠤꠛꠣꠘꠦ।” ꠔꠣꠞꠣ ꠇꠁꠟꠣ, “ꠜꠣꠟꠣ, ꠀꠙꠘꠦ ꠎꠦꠛꠟꠣ ꠇꠁꠞꠣ, ꠔꠦ ꠇꠞꠃꠇ꠆ꠇꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠟꠉꠦ ꠟꠉꠦ ꠜꠤꠔꠞꠦ ꠉꠤꠀ ꠍꠣꠄꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠎꠟꠖꠤ ꠇꠞꠤꠀ ꠔꠤꠘ ꠙꠦꠐꠥ ꠜꠣꠟꠣ ꠝꠄꠖꠣ ꠝꠣꠈꠤꠀ ꠙꠤꠑꠣ ꠛꠣꠘꠣꠅ।” ");
INSERT INTO syls_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","ꠔꠣꠁꠘ ꠖꠃꠠꠣꠁꠀ ꠉꠤꠀ ꠉꠞꠥꠞ ꠙꠣꠟ ꠕꠘꠦ ꠈꠥꠛ ꠜꠣꠟꠣ ꠄꠇꠐꠣ ꠇꠍꠝꠣ ꠛꠣꠍꠥꠞ ꠀꠘꠤꠀ ꠔꠣꠘ ꠉꠥꠟꠣꠝꠞꠦ ꠖꠤꠟꠣ। ꠢꠦ-ꠅ ꠎꠟꠖꠤ ꠇꠞꠤ ꠅꠇꠐꠣ ꠞꠣꠘ꠆ꠖꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ꠅꠃ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠖꠥꠗ, ꠖꠁ ꠀꠞ ꠉꠥꠡ꠆ꠔ ꠀꠘꠤꠀ ꠔꠣꠞꠣꠞꠦ ꠈꠣꠁꠛꠣꠞ ꠖꠤꠟꠣ, ꠔꠣꠞꠣ ꠈꠣꠅꠀ-ꠖꠣꠅꠀ ꠇꠞꠟꠣ। ꠔꠣꠁꠘ ꠔꠣꠞꠣꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠉꠣꠍ ꠔꠟꠣꠔ ꠃꠛꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","ꠔꠣꠞꠣ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞꠦ ꠎꠤꠇꠣꠁꠟꠣ, “ꠀꠙꠘꠣꠞ ꠛꠤꠛꠤ ꠍꠣꠄꠞꠣ ꠇꠁ?” ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠅꠃꠘꠥ, ꠔꠣꠝ꠆ꠛꠥꠞ ꠜꠤꠔꠞꠦ ꠀꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","ꠅꠃ ꠄꠞꠣꠞ ꠝꠣꠎꠦ ꠄꠇꠎꠘꠦ ꠇꠁꠟꠣ, “ꠍꠣꠝꠘꠞ ꠛꠞꠍ ꠁ ꠌꠣꠘ꠆ꠖꠅ ꠀꠝꠤ ꠅꠛꠡ꠆ꠡꠃ ꠀꠙꠘꠣꠞ ꠉꠦꠍꠦ ꠀꠁꠝꠥ। ꠖꠦꠈꠛꠣ, ꠅꠃ ꠡꠝꠄ ꠀꠙꠘꠣꠞ ꠛꠤꠛꠤ ꠍꠣꠄꠞꠣꠞ ꠇꠥꠟꠅ ꠄꠇ ꠙꠥꠀ ꠕꠣꠇꠛ।” ꠍꠣꠄꠞꠣꠄ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠈꠞꠦ ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠞꠎꠣꠔ ꠃꠛꠣꠁꠀ ꠁꠔꠣ ꠢꠥꠘꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","ꠁ ꠡꠝꠄ ꠁꠛ꠆ꠞꠣꠢꠤꠝ ꠀꠞ ꠍꠣꠄꠞꠣ ꠛꠥꠠꠣ-ꠎꠁꠚ ꠅꠁꠉꠦꠍꠂꠘ, ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠅꠀꠞ ꠟꠣꠈꠣꠘ ꠛꠄꠅꠡꠅ ꠍꠣꠄꠞꠣꠞ ꠞꠁꠍꠤꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","ꠄꠞꠟꠣꠉꠤ ꠍꠣꠄꠞꠣꠄ ꠝꠘꠦ ꠝꠘꠦ ꠀꠡꠤꠀ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠅꠃꠟꠣ ꠢꠦꠡꠇꠣꠟꠤ ꠛꠄꠅꠡꠅ ꠁꠔꠣ ꠈꠥꠡꠤ ꠀꠞ ꠀꠁꠛ ꠘꠤ? ꠀꠝꠣꠞ ꠝꠣꠟꠤꠇꠅ ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠁꠉꠦꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","ꠔꠦꠃ ꠝꠣꠛꠥꠖꠦ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞꠦ ꠇꠁꠟꠣ, “ꠍꠣꠄꠞꠣꠄ ꠇꠤꠔꠣꠞ ꠟꠣꠉꠤ ꠁꠔꠣ ꠇꠁꠀ ꠀꠡꠟ ꠎꠦꠘ, ꠢꠣꠍꠣꠃ ꠀꠝꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠅꠁꠛ ꠘꠤ, ꠀꠝꠤ ꠔ ꠛꠥꠠꠤ? ");
INSERT INTO syls_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","ꠝꠣꠛꠥꠖꠦ ꠙꠣꠞꠂꠘ ꠘꠣ ꠁꠟꠣ ꠇꠥꠘ꠆ꠔꠣ ꠀꠍꠦ ꠘꠤ? ꠖꠦꠈꠤꠅ, ꠑꠤꠇ ꠡꠝꠄꠄ ꠀꠝꠤ ꠢꠤꠞꠛꠣꠞ ꠔꠥꠝꠣꠞ ꠉꠦꠍꠦ ꠀꠁꠝꠥ, ꠀꠞ ꠁ ꠡꠝꠄ ꠍꠣꠄꠞꠣꠞ ꠇꠥꠟꠅ ꠙꠥꠀ ꠕꠣꠇꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","ꠍꠣꠄꠞꠣꠄ ꠒꠞꠣꠁꠀ ꠇꠁꠟꠣ, “ꠎꠤ ꠘꠣ, ꠀꠝꠤ ꠔ ꠀꠡꠍꠤ ꠘꠣ।” ꠅꠃ ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠘꠣ ꠞꠦꠉ, ꠔꠥꠝꠤ ꠘꠥ ꠀꠡꠤꠟꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ꠄꠞꠛꠣꠖꠦ ꠢꠃ ꠔꠤꠘꠎꠘꠦ ꠁꠘ ꠕꠘꠦ ꠃꠑꠤꠀ ꠍꠣꠖꠥꠝꠞ ꠛꠣꠄ ꠌꠣꠁꠟꠣ। ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠅꠁꠀ ꠛꠤꠖꠣꠄ ꠖꠦꠅꠀꠔ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","ꠔꠦꠃ ꠝꠣꠛꠥꠖꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠎꠦꠔꠣ ꠇꠞꠔꠣꠝ ꠌꠣꠁꠀꠞ, ꠁꠔꠣ ꠇꠥꠘꠥ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞꠦ ꠟꠥꠇꠣꠁꠔꠣꠝ ꠘꠤ? ");
INSERT INTO syls_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","ꠁꠛ꠆ꠞꠣꠢꠤꠝ ꠕꠣꠇꠤꠀꠃ ꠔ ꠀꠝꠤ ꠄꠇ ꠝꠢꠣꠘ ꠢꠤꠝ꠆ꠝꠔꠀꠟꠣ ꠎꠣꠔꠤ ꠙꠄꠖꠣ ꠇꠞꠝꠥ, ꠖꠥꠘꠤꠀꠁꠞ ꠢꠇꠟ ꠎꠣꠔꠤꠄ ꠅꠘ ꠕꠘꠦ ꠛꠞꠇꠔ ꠇꠣꠝꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","ꠄꠞꠟꠣꠉꠤꠃ ꠀꠝꠤ ꠔꠣꠞꠦ ꠈꠣꠔꠤꠞ ꠇꠞꠍꠤ, ꠢꠦ ꠔꠣꠞ ꠅꠀꠞꠤꠡ ꠀꠞ ꠔꠣꠞ ꠘꠤꠎꠞ ꠢꠇꠟꠞꠦ ꠀꠝꠣꠞ ꠝꠞ꠆ꠎꠤ ꠝꠣꠘꠤꠀ ꠢꠇ ꠀꠞ ꠁꠘꠍꠣꠚꠞ ꠇꠣꠝ ꠇꠞꠣꠞ ꠢꠥꠇꠥꠝ ꠖꠦꠄ। ꠔꠣꠞꠣꠅ ꠎꠥꠖꠤ ꠅꠃ ꠟꠣꠈꠣꠘ ꠌꠟꠦ, ꠔꠣꠁꠟꠦ ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠛꠦꠙꠣꠞꠦ ꠎꠔꠔꠣ ꠇꠁꠍꠤ, ꠢꠇꠟꠔꠣꠃ ꠙꠥꠞꠣ ꠇꠞꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠇꠁꠟꠣ, “ꠍꠣꠖꠥꠝ ꠀꠞ ꠀꠝꠥꠞꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠈꠥꠛ ꠘꠣꠟꠤꠡ ꠀꠞ ꠚꠞꠤꠀꠖ ꠢꠥꠘꠤꠀꠞ, ꠔꠣꠞꠣꠞ ꠉꠥꠘꠣꠅ ꠈꠥꠛ ꠛꠦꠎꠥꠁꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ꠄꠞꠟꠣꠉꠤ ꠀꠝꠤ ꠔꠟꠦ ꠟꠣꠝꠤꠀ ꠉꠤꠀ ꠖꠦꠈꠤ, ꠀꠝꠤ ꠎꠦꠟꠣ ꠘꠣꠟꠤꠡ ꠢꠥꠘꠤꠀꠞ, ꠁꠔꠣ ꠢꠣꠍꠣꠃ ꠅꠃꠟꠣ ꠈꠣꠞꠣꠙ ꠇꠤ ꠘꠣ। ꠀꠞ ꠘꠣ ꠅꠁꠟꠦꠅ ꠔ ꠖꠦꠈꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","ꠅꠃ ꠢꠤ ꠖꠥꠁꠅꠎꠘꠦ ꠚꠤꠞꠤꠀ ꠍꠣꠖꠥꠝꠞ ꠛꠣꠄ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣ ꠀꠞ ꠁꠛ꠆ꠞꠣꠢꠤꠝ ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍꠦ ꠃꠛꠣꠁ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","ꠛꠣꠖꠦ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠝꠣꠛꠥꠖꠞ ꠛꠣꠄ ꠀꠉꠥꠀꠁꠀ ꠉꠤꠀ ꠇꠁꠟꠣ, “ꠀꠙꠘꠦ ꠉꠥꠘꠣꠉꠣꠞꠞ ꠟꠉꠦ ꠢꠇ ꠝꠣꠘꠥꠡ ꠅꠇꠟꠞꠦꠅ ꠝꠣꠞꠤꠟꠣꠁꠔꠣ ꠘꠤ? ");
INSERT INTO syls_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","ꠐꠣꠃꠘꠞ ꠝꠣꠎꠦ ꠎꠥꠖꠤ ꠙꠁꠘ꠆ꠌꠣꠡ ꠎꠘ ꠢꠇ ꠝꠣꠘꠥꠡ ꠕꠣꠇꠦ ꠔꠣꠁꠟꠦ ꠢꠃ ꠙꠁꠘ꠆ꠌꠣꠡ ꠎꠘꠞ ꠈꠣꠔꠤꠞꠦ ꠐꠣꠃꠘꠞꠦ ꠝꠦꠢꠦꠞꠛꠣꠘꠤ ꠘꠣ ꠇꠞꠤꠀ ꠛꠤꠘꠣꠡ ꠇꠞꠤꠟꠣꠁꠛꠣ ꠘꠤ? ");
INSERT INTO syls_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ꠔꠦ ꠀꠙꠘꠣꠞ ꠇꠣꠝ ꠔ ꠅꠃꠟꠣ ꠘꠣꠄ, ꠢꠇ ꠀꠞ ꠉꠥꠘꠣꠉꠣꠞꠞꠦ ꠄꠇꠟꠉꠦ ꠝꠣꠞꠤꠟꠣꠅꠀ, ꠄꠇ ꠢꠝꠣꠘ ꠡꠣꠎꠣ ꠖꠦꠅꠀ, ꠀꠙꠘꠣꠞ ꠟꠣꠉꠤ ꠔ ꠑꠤꠇ ꠘꠣꠄ। ꠎꠦꠁꠘ ꠢꠣꠞꠣ ꠖꠥꠘꠤꠀꠞ ꠛꠤꠌꠣꠞ ꠇꠞꠂꠘ, ꠔꠣꠁꠘ ꠇꠥꠘꠥ ꠢꠇ ꠁꠘꠍꠣꠚ ꠇꠞꠔꠣ ꠘꠣꠄ ꠘꠤ?” ");
INSERT INTO syls_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","ꠝꠣꠛꠥꠖꠦ ꠇꠁꠟꠣ, “ꠎꠥꠖꠤ ꠍꠣꠖꠥꠝ ꠐꠣꠃꠘꠅ ꠙꠁꠘ꠆ꠌꠣꠡ ꠎꠘꠅ ꠢꠇ ꠝꠣꠘꠥꠡ ꠕꠣꠇꠂꠘ, ꠔꠣꠁꠟꠦ ꠔꠣꠞꠣꠞ ꠈꠣꠔꠤꠞꠦ ꠀꠝꠤ ꠀꠡ꠆ꠔꠣ ꠐꠣꠃꠘꠞꠦ ꠞꠦꠢꠣꠁ ꠖꠤꠟꠣꠁꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠇꠁꠟꠣ, “ꠖꠦꠈꠃꠇ꠆ꠇꠣ, ꠀꠝꠤ ꠔ ꠗꠥꠁꠟ ꠀꠞ ꠍꠣꠟꠤ ꠍꠣꠠꠣ ꠇꠥꠘ꠆ꠔꠣ ꠘꠣꠄ, ꠔꠣ-ꠅ ꠀꠝꠤ ꠡꠣꠅꠡ ꠇꠞꠤꠀ ꠀꠝꠣꠞ ꠝꠣꠟꠤꠇꠞ ꠟꠉꠦ ꠝꠣꠔꠤꠀꠞ। ");
INSERT INTO syls_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ꠗꠞꠃꠇ꠆ꠇꠣ, ꠎꠥꠖꠤ ꠙꠁꠘ꠆ꠌꠣꠡ ꠎꠘ ꠢꠇ ꠝꠣꠘꠥꠡ ꠘꠣ ꠅꠁꠀ ꠙꠣꠌ ꠎꠘ ꠇꠝ ꠅꠄ, ꠔꠣꠁꠟꠦ ꠇꠤꠔꠣ ꠅꠃ ꠙꠣꠌ ꠎꠘ ꠇꠝꠞ ꠟꠣꠉꠤ ꠀꠙꠘꠦ ꠀꠡ꠆ꠔꠣ ꠐꠣꠃꠘ ꠛꠤꠘꠣꠡ ꠇꠞꠤꠟꠣꠁꠛꠣ ꠘꠤ?” ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠎꠥꠖꠤ ꠢꠤꠘꠅ ꠙꠄꠔꠣꠟ꠆ꠟꠤꠡ ꠎꠘꠞꠦ ꠙꠣꠁ, ꠔꠣꠁꠟꠦ ꠁꠇꠐꠣ ꠛꠤꠘꠣꠡ ꠇꠞꠔꠣꠝ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠔꠣꠘꠞꠦ ꠢꠤꠞꠛꠣꠞ ꠇꠁꠟꠣ, “ꠗꠞꠃꠇ꠆ꠇꠣ, ꠎꠥꠖꠤ ꠢꠤꠘꠅ ꠌꠣꠟ꠆ꠟꠤꠡ ꠎꠘ ꠙꠣꠅꠀ ꠎꠣꠄ?” ꠝꠣꠛꠥꠖꠦ ꠇꠁꠟꠣ, “ꠢꠃ ꠌꠣꠟ꠆ꠟꠤꠡ ꠎꠘꠞ ꠈꠣꠔꠤꠞꠦ ꠀꠝꠤ ꠛꠤꠘꠣꠡ ꠇꠞꠔꠣꠝ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠝꠣꠟꠤꠇ ꠎꠣꠘꠥ ꠀꠝꠣꠞ ꠝꠣꠔꠦ ꠘꠣꠞꠣꠎ ꠘꠣ ꠅꠁꠘ। ꠀꠁꠌ꠆ꠍꠣ, ꠎꠥꠖꠤ ꠢꠤꠘꠅ ꠔꠤꠡ ꠎꠘꠞꠦ ꠙꠣꠅꠀ ꠎꠣꠄ?” ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠎꠥꠖꠤ ꠀꠝꠤ ꠔꠤꠡ ꠎꠘꠞꠦꠅ ꠙꠣꠁ, ꠔꠣꠁꠟꠦꠅ ꠀꠝꠤ ꠛꠤꠘꠣꠡ ꠇꠞꠔꠣꠝ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠎꠦꠛꠟꠣ ꠢꠤꠝ꠆ꠝꠔ ꠇꠞꠤꠀ ꠝꠣꠟꠤꠇꠞ ꠟꠉꠦ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠤꠀꠞ ꠔꠦ ꠢꠤꠞꠛꠣꠞ ꠇꠁꠀꠞ, ꠎꠥꠖꠤ ꠢꠤꠘꠅ ꠛꠤꠡ ꠎꠘꠞꠦ ꠙꠣꠅꠀ ꠎꠣꠄ?” ꠝꠣꠛꠥꠖꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠢꠃ ꠛꠤꠡ ꠎꠘꠞ ꠈꠣꠔꠤꠞꠦꠃ ꠀꠝꠤ ꠁꠇꠐꠣ ꠛꠤꠘꠣꠡ ꠇꠞꠔꠣꠝ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","ꠢꠦꠡꠦ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠝꠣꠟꠤꠇ ꠎꠣꠘꠥ ꠘꠣꠞꠣꠎ ꠘꠣ ꠅꠁꠘ, ꠀꠝꠤ ꠈꠣꠟꠤ ꠀꠞꠅ ꠄꠇꠛꠣꠞꠔꠣ ꠇꠁꠀꠞ, ꠎꠥꠖꠤ ꠢꠤꠘꠅ ꠖꠡ ꠎꠘ ꠕꠣꠇꠂꠘ?” ꠝꠣꠛꠥꠖꠦ ꠇꠁꠟꠣ, “ꠢꠃ ꠖꠡ ꠎꠘꠞ ꠈꠣꠔꠤꠞꠦꠃ ꠀꠝꠤ ꠁꠇꠐꠣ ꠛꠤꠘꠣꠡ ꠇꠞꠔꠣꠝ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠟꠉꠦ ꠝꠣꠛꠥꠖꠞ ꠛꠣꠔ-ꠍꠅꠀꠟ ꠡꠦꠡ ꠅꠁꠀ ꠢꠣꠞꠟꠦ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣꠁꠟꠣ, ꠀꠞ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠅ ꠔꠣꠘ ꠛꠣꠠꠤꠔ ꠚꠤꠞꠤꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ꠛꠣꠖꠦ ꠢꠣꠁꠘ꠆ꠎꠣ ꠛꠣꠟꠣ ꠢꠃ ꠖꠥꠁꠎꠘ ꠚꠤꠞꠤꠡ꠆ꠔꠣ ꠍꠣꠖꠥꠝ ꠐꠣꠃꠘꠅ ꠉꠦꠟꠣ। ꠁ ꠡꠝꠄ ꠟꠥꠔ ꠐꠣꠃꠘꠞ ꠝꠥꠟ ꠉꠦꠁꠐꠞ ꠉꠦꠍꠦ ꠛꠅꠀꠔ ꠀꠍꠟꠣ, ꠄꠞꠣꠞꠦ ꠖꠦꠈꠤꠀ ꠔꠣꠁꠘ ꠃꠛꠣꠁꠟꠣ ꠀꠞ ꠝꠣꠐꠤꠔ ꠍꠁꠎꠖꠣ ꠇꠞꠤꠀ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“ꠅ ꠀꠝꠣꠞ ꠝꠣꠟꠤꠇ ꠅꠇꠟ, ꠀꠝꠤ ꠝꠤꠘꠔꠤ ꠇꠞꠤ ꠇꠁꠀꠞ, ꠖꠄꠀ ꠇꠞꠤ ꠀꠙꠘꠣꠞꠣꠞ ꠅꠃ ꠉꠥꠟꠣꠝꠞ ꠊꠞꠅ ꠔꠡꠞꠤꠚ ꠀꠘꠤꠟꠣꠃꠇ꠆ꠇꠣ ꠀꠞ ꠀꠔ-ꠙꠣꠅ ꠗꠁꠀ ꠞꠣꠁꠔꠈꠣꠘ ꠇꠣꠐꠣꠃꠇ꠆ꠇꠣ। ꠛꠤꠀꠘꠦ ꠢꠤꠞꠛꠣꠞ ꠞꠅꠀꠘꠣ ꠅꠁꠛꠣꠘꠦ।” ꠄꠞꠣ ꠇꠁꠟꠣ, “ꠘꠣ, ꠀꠝꠞꠣ ꠅꠃ ꠐꠣꠃꠘꠞ ꠝꠄꠖꠣꠘꠅ ꠞꠣꠁꠔ ꠇꠣꠐꠣꠁꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","ꠔꠣꠁꠘ ꠎꠦꠛꠟꠣ ꠈꠥꠛ ꠝꠤꠘꠔ-ꠇꠣꠎ꠆ꠎꠤ ꠇꠞꠞꠣ ꠅꠃ ꠡꠝꠄ ꠄꠞꠣ ꠔꠣꠘ ꠛꠣꠠꠤꠔ ꠢꠣꠝꠣꠁꠟꠣ। ꠛꠣꠖꠦ ꠟꠥꠔꠦ ꠞꠥꠐꠤ ꠛꠣꠘꠣꠁꠀ ꠄꠞꠣꠞ ꠟꠣꠉꠤ ꠈꠣꠘꠣ-ꠖꠣꠘꠣ ꠎꠥꠁꠔ ꠇꠞꠟꠣ, ꠀꠞ ꠔꠣꠞꠣ ꠈꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","ꠄꠞꠣꠞ ꠢꠥꠔꠤꠛꠣꠞ ꠀꠉꠦꠃ ꠍꠣꠖꠥꠝ ꠐꠣꠃꠘꠞ ꠢꠇ꠆ꠇꠟ ꠎꠥꠀꠘ-ꠛꠥꠠꠣ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠦ ꠀꠁꠀ ꠢꠤ ꠛꠣꠠꠤꠞꠦ ꠛꠦꠞꠤꠟꠣꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ꠀꠞ ꠟꠥꠔꠞꠦ ꠒꠣꠇꠤꠀ ꠇꠁꠟꠣ, “ꠀꠁꠎ ꠞꠣꠁꠔ ꠎꠦ ꠖꠥꠁꠎꠘ ꠝꠣꠘꠥꠡ ꠔꠞ ꠁꠘꠅ ꠀꠁꠍꠦ, ꠔꠣꠞꠣ ꠇꠁ? ꠅꠔꠣꠞꠦ ꠛꠣꠞ ꠇꠞꠤꠀ ꠀꠝꠞꠣꠞ ꠉꠦꠍꠦ ꠀꠘ। ꠀꠝꠞꠣ ꠅꠔꠣꠞ ꠟꠉꠦ ꠝꠃꠎ ꠇꠞꠔꠣꠝ।” ");
INSERT INTO syls_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","ꠅꠃ ꠡꠝꠄ ꠟꠥꠔꠦ ꠖꠞꠎꠣꠞ ꠛꠣꠞꠦ ꠉꠤꠀ ꠔꠣꠘ ꠈꠞꠞ ꠖꠞꠎꠣ ꠛꠘ꠆ꠖ ꠇꠞꠤꠀ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“ꠜꠣꠁꠀꠁꠘꠞꠦ, ꠀꠝꠤ ꠝꠤꠘꠔ ꠇꠞꠤꠀꠞ, ꠔꠥꠝꠞꠣ ꠁꠟꠣ ꠛꠖ ꠇꠣꠝ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","ꠖꠦꠈꠅ, ꠀꠝꠣꠞ ꠖꠥꠁꠐꠣ ꠡꠔꠤ ꠙꠥꠠꠤ ꠀꠍꠦ। ꠀꠝꠤ ꠛꠣꠞ ꠇꠞꠤꠀ ꠔꠥꠝꠞꠣꠞ ꠉꠦꠍꠦ ꠟꠁꠀ ꠀꠁꠀꠞ, ꠔꠣꠞꠣ ꠇꠥꠘꠥ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠞ ꠉꠦꠍꠦ ꠞꠁꠍꠂꠘ ꠘꠣ, ꠔꠥꠝꠞꠣꠞ ꠎꠦꠔꠣ ꠝꠘꠦ ꠌꠣꠄ ꠇꠞꠅ; ꠔꠣ-ꠅ, ꠁ ꠝꠣꠘꠡꠞ ꠟꠉꠦ ꠔꠥꠝꠞꠣ ꠇꠥꠘ꠆ꠔꠣ ꠇꠞꠤꠅ ꠘꠣ, ꠄꠞꠣ ꠀꠝꠣꠞ ꠊꠞꠅ ꠀꠡꠞꠄ ꠟꠁꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","ꠅꠁꠟꠦ ꠔꠣꠞꠣ ꠇꠁꠟ, “ꠎꠣ, ꠎꠣ, ꠙꠕ ꠕꠣꠇꠤ ꠢꠞ!” ꠔꠣꠞꠣ ꠀꠞꠅ ꠇꠁꠟ, “ꠅꠂ ꠛꠦꠐꠣ, ꠔꠥꠁ ꠄꠇꠟꠣ ꠛꠂꠔꠟ ꠅꠁꠀ ꠀꠁꠍꠍ ꠀꠞ ꠈꠣꠟꠤ ꠀꠝꠞꠣꠞ ꠃꠙꠞꠦ ꠘꠦꠔꠣꠉꠤꠞꠤ ꠇꠞꠞꠦ। ꠅꠈꠘ ꠄꠞꠣꠞ ꠌꠣꠁꠔꠦ ꠔꠞ ꠟꠉꠦ ꠀꠞꠅ ꠛꠦꠡꠤ ꠈꠛꠤꠍꠤ ꠇꠞꠝꠥ।” ꠇꠁꠀꠃ ꠔꠣꠞꠣ ꠟꠥꠔꠞꠦ ꠑꠦꠟꠤꠀ ꠢꠞꠣꠁꠀ ꠖꠞꠎꠣ ꠜꠣꠋꠉꠔ ꠌꠣꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","ꠅꠃ ꠡꠝꠄ ꠢꠃ ꠖꠥꠁꠎꠘꠦ ꠀꠔ ꠛꠣꠠꠣꠁꠀ, ꠟꠥꠔꠞꠦ ꠊꠞꠞ ꠜꠤꠔꠞꠦ ꠐꠣꠘꠤꠀ ꠘꠤꠀ ꠖꠞꠎꠣ ꠛꠘ꠆ꠖ ꠇꠞꠤ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ꠀꠞ ꠖꠞꠎꠣꠞ ꠛꠣꠞꠦ ꠃꠛꠣꠁꠟ ꠢꠥꠞꠥ-ꠛꠠ ꠢꠇꠟ ꠀꠈꠔꠣꠃ ꠀꠘ꠆ꠖꠣ ꠅꠁꠉꠦꠟ, ꠀꠞ ꠖꠞꠎꠣ ꠔꠥꠇꠣꠁꠔꠦ ꠔꠥꠇꠣꠁꠔꠦ ꠢꠦꠞꠣꠘ ꠅꠁꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ꠛꠣꠖꠦ ꠢꠃ ꠖꠥꠁꠅꠎꠘꠦ ꠟꠥꠔꠞꠦ ꠎꠤꠇꠣꠁꠟꠣ, “ꠁꠘꠅ ꠔꠥꠝꠣꠞ ꠀꠞ ꠇꠦ ꠇꠦ ꠀꠍꠦ? ꠔꠥꠝꠣꠞ ꠙꠥꠀ-ꠙꠥꠠꠤ ꠀꠞ ꠖꠣꠝꠣꠘ꠆ꠖꠞꠦ ꠟꠁꠀ ꠁꠘ ꠕꠘꠦ ꠢꠞꠤꠀ ꠎꠣꠅꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ꠇꠣꠞꠘ ꠀꠝꠞꠣ ꠁ ꠎꠣꠉꠣꠞꠦ ꠍꠣꠞꠈꠣꠞ ꠇꠞꠤꠟꠣꠁꠀꠞ। ꠁꠘꠞ ꠝꠣꠘꠡꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍꠦ ꠅꠃꠟꠣ ꠛꠦꠎꠥꠁꠔꠣ ꠘꠣꠟꠤꠡ ꠅꠁꠍꠦ ꠎꠦꠘ, ꠁꠇꠐꠣ ꠛꠤꠘꠣꠡ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠔꠣꠁꠘ ꠀꠝꠞꠣꠞꠦ ꠙꠣꠑꠣꠁꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","ꠅꠃ ꠟꠥꠔꠦ ꠛꠣꠞꠦ ꠉꠤꠀ ꠔꠣꠘ ꠖꠣꠝꠣꠘ꠆ꠖ ꠅꠇꠟꠞꠦ ꠇꠁꠟꠣ, “ꠀꠅ, ꠔꠥꠝꠞꠣ ꠁ ꠎꠣꠉꠣ ꠍꠣꠠꠤꠀ ꠛꠣꠞꠅ ꠇꠣꠞꠘ ꠝꠣꠛꠥꠖꠦ ꠁ ꠐꠣꠃꠘꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠔꠤꠀꠞ ꠅꠁꠞꠁꠍꠂꠘ।” ꠅꠁꠟꠦ ꠔꠣꠞꠣ ꠝꠘꠦ ꠇꠞꠟ, ꠔꠣꠁꠘ ꠁꠔꠣ ꠔꠣꠝꠡꠣ ꠇꠞꠞꠣ। ");
INSERT INTO syls_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","ꠙꠔꠣꠛꠣꠟꠣ ꠢꠃ ꠚꠤꠞꠤꠡ꠆ꠔꠣꠄ ꠟꠥꠔꠞꠦ ꠔꠣꠉꠖꠣ ꠖꠤꠀ ꠇꠁꠟꠣ, “ꠃꠑꠅ, ꠎꠟꠖꠤ ꠇꠞꠤ ꠔꠥꠝꠣꠞ ꠛꠃ ꠀꠞ ꠁ ꠖꠥꠁꠅ ꠙꠥꠠꠤꠞꠦ ꠟꠁꠀ ꠅꠘ ꠕꠘꠦ ꠎꠣꠅꠉꠤ। ꠘꠣꠁꠟꠦ ꠅꠃ ꠉꠎꠛꠞ ꠝꠣꠎꠦ ꠙꠠꠤꠀ ꠛꠤꠘꠣꠡ ꠅꠁꠎꠤꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","ꠟꠥꠔꠦ ꠎꠣꠁ-ꠎꠣꠁꠞꠣꠝ ꠅꠃꠟꠣ ꠇꠞꠞꠣ। ꠅꠁꠟꠦ ꠝꠣꠛꠥꠖꠞ ꠝꠣꠄꠀ ꠔꠣꠘ ꠃꠙꠞꠦ ꠀꠍꠤꠟ ꠇꠞꠤ ꠢꠃ ꠖꠥꠁꠅꠎꠘꠦ, ꠔꠣꠁꠘ ꠀꠞ ꠔꠣꠘ ꠛꠃ ꠀꠞ ꠔꠣꠘ ꠖꠥꠁꠅ ꠙꠥꠠꠤꠘ꠆ꠔꠞ ꠀꠔꠅ ꠗꠞꠤ ꠐꠣꠘꠤꠀ ꠐꠣꠃꠘꠞ ꠛꠣꠞꠦ ꠟꠁꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","ꠢꠇꠟꠞꠦ ꠛꠣꠞ ꠇꠞꠤꠀ ꠀꠘꠣꠞ ꠛꠣꠖꠦ ꠔꠣꠞꠣ ꠇꠁꠟꠣ, “ꠛꠣꠌꠔꠦ ꠌꠣꠁꠟꠦ ꠜꠣꠉꠅ, ꠈꠞꠦꠖꠤ ꠌꠣꠁꠅ ꠘꠣ, ꠜꠣꠉꠤꠀ ꠙꠣꠠꠅ ꠎꠣꠅ, ꠁ ꠕꠟ ꠎꠣꠉꠣꠞ ꠇꠥꠘꠥꠈꠣꠘꠅ ꠃꠛꠣꠁꠅ ꠘꠣ ꠀꠞꠘꠣꠄ ꠔꠥꠝꠞꠣꠅ ꠝꠞꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","ꠅꠃ ꠟꠥꠔꠦ ꠇꠁꠟꠣ, “ꠅ ꠀꠝꠣꠞ ꠝꠣꠟꠤꠇ ꠅꠇꠟ, ꠁꠟꠣ ꠇꠞꠂꠘ ꠘꠣ ꠎꠦꠘ; ");
INSERT INTO syls_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","ꠖꠦꠈꠃꠇ꠆ꠇꠣ, ꠀꠙꠘꠣꠞ ꠁ ꠉꠥꠟꠣꠝꠞꠦ ꠀꠙꠘꠦ ꠝꠦꠢꠦꠞꠛꠣꠘꠤ ꠇꠞꠍꠂꠘ, ꠀꠞ ꠀꠝꠣꠞ ꠎꠣꠘ ꠛꠣꠌꠣꠁꠛꠣꠞ ꠟꠣꠉꠤ ꠀꠙꠘꠦ ꠀꠝꠣꠞꠦ ꠝꠢꠣ ꠖꠄꠀ ꠖꠦꠈꠣꠁꠍꠂꠘ। ꠅꠁꠟꠦ ꠀꠝꠤ ꠜꠣꠉꠤꠀ ꠙꠣꠠꠅ ꠎꠣꠁꠔꠣꠝ ꠙꠣꠞꠔꠣꠝ ꠘꠣꠄ। ꠢꠄꠔ ꠁ ꠛꠤꠙꠖ ꠀꠁꠀ ꠀꠝꠣꠞꠦ ꠎꠣꠔꠣ ꠝꠣꠞꠤ ꠗꠞꠟꠦ, ꠀꠝꠤꠅ ꠝꠞꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","ꠖꠦꠈꠃꠇ꠆ꠇꠣ, ꠜꠣꠉꠤꠀ ꠎꠣꠁꠔꠦ ꠔ ꠅꠃ ꠢꠥꠞꠥ ꠉꠣꠃꠐꠣ ꠇꠣꠍꠣꠔ ꠀꠍꠦ। ꠎꠣꠘ ꠛꠣꠌꠣꠁꠛꠣꠞ ꠟꠣꠉꠤ ꠀꠝꠣꠞꠦ ꠅꠘꠅ ꠙꠣꠑꠣꠁ ꠖꠦꠃꠇ꠆ꠇꠣ। ꠉꠣꠃꠐꠣ ꠢꠥꠞꠥ-ꠝꠥꠞꠥ ꠀꠍꠦ।” ");
INSERT INTO syls_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠑꠤꠇ ꠀꠍꠦ, ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠁ ꠀꠞꠎꠤ ꠝꠣꠘꠟꠣꠝ। ꠔꠥꠝꠤ ꠎꠦ ꠉꠣꠃꠞ ꠇꠕꠣ ꠇꠁꠟꠣꠄ, ꠁꠐꠣ ꠀꠝꠤ ꠗꠋꠡ ꠇꠞꠔꠣꠝ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","ꠎꠟꠖꠤ ꠇꠞꠤ ꠢꠤꠘꠅ ꠎꠣꠅ। ꠔꠥꠝꠤ ꠢꠘꠅ ꠘꠣ ꠙꠃꠍꠣꠘꠤ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠀꠝꠤ ꠇꠥꠘ꠆ꠔꠣ ꠇꠞꠔꠣꠝ ꠙꠣꠞꠤꠀꠞ ꠘꠣ।” ꠟꠥꠔꠞ ꠇꠕꠣꠞ ꠟꠣꠉꠤ ꠢꠃ ꠉꠣꠃꠞ ꠘꠣꠝ ꠅꠁꠟ ꠍꠥꠀꠞ ꠝꠣꠘꠤ, ꠢꠥꠞꠥ। ");
INSERT INTO syls_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","ꠟꠥꠔꠦ ꠎꠦꠛꠟꠣ ꠍꠥꠀꠞꠅ ꠉꠤꠀ ꠙꠃꠍꠟꠣ ꠁ ꠡꠝꠄ ꠡꠥꠞꠥꠎ ꠃꠑꠤꠉꠦꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","ꠄꠞꠛꠣꠖꠦꠃ ꠝꠣꠛꠥꠖꠦ ꠀꠍꠝꠣꠘ ꠕꠣꠇꠤ ꠍꠣꠖꠥꠝ ꠀꠞ ꠀꠝꠥꠞꠣꠞ ꠃꠙꠞꠦ ꠀꠉꠥꠁꠘ ꠀꠞ ꠉꠘ꠆ꠖꠇꠞ ꠉꠎꠛ ꠍꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","ꠔꠣꠁꠘ ꠢꠤ ꠐꠣꠃꠘ ꠅꠇꠟ, ꠢꠇꠟ ꠕꠟ ꠎꠣꠉꠣ, ꠢꠇ꠆ꠇꠟ ꠝꠣꠘꠥꠡ ꠀꠞ ꠢꠤ ꠝꠣꠐꠤꠞ ꠃꠙꠞꠞ ꠢꠇ꠆ꠇꠟꠔꠣ ꠗꠋꠡ ꠇꠞꠤꠟꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","ꠄꠞꠝꠣꠎꠦ ꠟꠥꠔꠞ ꠛꠃꠄ ꠈꠞꠦꠖꠤ ꠚꠤꠞꠤꠀ ꠌꠣꠅꠀꠄ, ꠔꠣꠁꠘ ꠄꠇꠐꠣ ꠘꠥꠘꠞ ꠌꠣꠇ꠆ꠇꠣ ꠅꠁꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","ꠛꠣꠖꠞ ꠖꠤꠘ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠛꠤꠀꠘꠦ ꠃꠑꠤꠀ ꠢꠃ ꠎꠣꠉꠣꠔ ꠉꠦꠟꠣ ꠎꠦꠘꠅ ꠀꠉꠞ ꠖꠤꠘ ꠔꠣꠁꠘ ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍꠦ ꠃꠛꠣꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","ꠔꠣꠁꠘ ꠔꠟꠦ ꠍꠣꠖꠥꠝ, ꠀꠝꠥꠞꠣ ꠀꠞ ꠢꠇꠟ ꠕꠟ ꠎꠣꠉꠣꠞ ꠛꠣꠄ ꠌꠣꠁꠀ ꠖꠦꠈꠟꠣ, ꠁꠐ-ꠜꠣꠐ꠆ꠐꠣ ꠕꠣꠇꠤ ꠎꠦꠟꠣ ꠗꠥꠝꠣ ꠛꠣꠞꠅꠄ, ꠅꠃ ꠟꠣꠈꠣꠘ ꠢꠃ ꠄꠟꠣꠇꠣ ꠕꠣꠇꠤ ꠗꠥꠝꠣ ꠃꠠꠦꠞ। ");
INSERT INTO syls_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","ꠀꠞ ꠟꠥꠔꠦ ꠎꠦꠈꠣꠘꠅ ꠛꠡꠔ ꠇꠞꠔꠣ, ꠢꠃ ꠕꠟ ꠎꠣꠉꠣꠞ ꠐꠣꠃꠘ ꠅꠇꠟ ꠗꠋꠡ ꠇꠞꠣꠞ ꠡꠝꠄ, ꠀꠟ꠆ꠟꠣꠄ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠇꠕꠣ ꠝꠘꠅ ꠇꠞꠤꠀ ꠟꠥꠔꠞꠦ ꠢꠤꠘꠞ ꠉꠎꠛꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠢꠞꠣꠁꠀ ꠀꠘꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","ꠍꠥꠀꠞ ꠉꠣꠃꠔ ꠞꠁꠔꠦ ꠒꠞꠣꠁꠟꠣ ꠇꠞꠤ, ꠟꠥꠔꠦ ꠔꠣꠘ ꠖꠥꠁꠅ ꠙꠥꠠꠤꠞꠦ ꠟꠁꠀ ꠢꠤꠘ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁꠀ ꠙꠣꠠꠅ ꠀꠁꠀ, ꠄꠇ ꠉꠣꠔꠞ ꠜꠤꠔꠞꠦ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ꠄꠇꠖꠤꠘ ꠔꠣꠘ ꠛꠠ ꠙꠥꠠꠤꠄ ꠢꠥꠞꠥ ꠛꠁꠘꠞꠦ ꠇꠁꠟ, “ꠛꠣꠛꠣ ꠔ ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠁꠉꠦꠍꠂꠘ। ꠀꠞ ꠎꠉꠔꠞ ꠡꠝꠣꠎꠞ ꠘꠤꠅꠝ ꠝꠔ ꠀꠝꠞꠣꠞꠦ ꠛꠤꠀ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠁꠘꠅ ꠇꠥꠘꠥ ꠛꠦꠐꠣꠁꠘꠅ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","ꠔꠦ ꠀꠄ, ꠀꠝꠞꠣ ꠛꠣꠛꠣꠞꠦ ꠡꠞꠣꠛ ꠈꠣꠅꠀꠁꠀ ꠔꠣꠘ ꠇꠣꠍꠣꠔ ꠞꠁ। ꠔꠦꠃ ꠛꠣꠛꠣꠞꠦꠖꠤ ꠀꠝꠞꠣꠞ ꠛꠋꠡ ꠛꠣꠌꠣꠁꠔꠣꠝ ꠙꠣꠞꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","ꠅꠃ ꠔꠣꠞꠣ ꠖꠥꠁꠅꠎꠘꠦ ꠞꠣꠁꠔꠞ ꠛꠣꠟꠣ ꠔꠣꠘꠞꠦ ꠡꠞꠣꠛ ꠈꠣꠅꠀꠁꠀ ꠐꠣꠟ ꠛꠣꠘꠣꠁꠟ। ꠛꠣꠖꠦ ꠛꠠ ꠛꠁꠘ ꠛꠣꠚꠞ ꠉꠦꠍꠦ ꠢꠥꠔꠤꠔ ꠉꠦꠟ, ꠅꠁꠟꠦ ꠇꠥꠘ ꠡꠝꠄ ꠢꠥꠔꠤꠟ ꠀꠞ ꠇꠥꠘ ꠡꠝꠄ ꠃꠑꠤꠟ, ꠛꠣꠚꠦ ꠇꠥꠘ꠆ꠔꠣꠃ ꠐꠦꠞ ꠙꠣꠁꠟꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","ꠛꠣꠖꠞ ꠖꠤꠘ ꠛꠠꠉꠥꠄ ꠢꠥꠞꠥꠉꠥꠞꠦ ꠇꠁꠟ, “ꠖꠦꠈ, ꠇꠣꠁꠟ ꠞꠣꠁꠔ ꠀꠝꠤ ꠛꠣꠛꠣꠞ ꠉꠦꠍꠦ ꠢꠥꠔꠤꠍꠟꠣꠝ। ꠀꠄ, ꠀꠁꠎ ꠞꠣꠁꠔꠅ ꠔꠣꠘꠦ ꠅꠃꠟꠣ ꠡꠞꠣꠛ ꠈꠣꠅꠀꠁꠀ ꠐꠣꠟ ꠛꠣꠘꠣꠁ, ꠛꠣꠖꠦ ꠔꠥꠁꠅ ꠉꠤꠀ ꠔꠣꠘ ꠉꠦꠍꠦ ꠢꠥꠔꠤꠍ। ꠔꠦ ꠛꠣꠛꠣꠞꠦꠖꠤ ꠀꠝꠞꠣꠞ ꠛꠋꠡ ꠛꠣꠌꠣꠁꠔꠣꠝ ꠙꠣꠞꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","ꠅꠃ ꠟꠣꠈꠣꠘ ꠔꠣꠞꠣ ꠢꠃ ꠞꠣꠁꠔꠅ ꠔꠣꠞꠣꠞ ꠛꠣꠚꠞꠦ ꠡꠞꠣꠛ ꠈꠣꠅꠀꠁꠀ ꠐꠣꠟ ꠛꠣꠘꠣꠁꠟ, ꠀꠞ ꠢꠥꠞꠥ ꠙꠥꠠꠤ ꠔꠣꠁꠞ ꠛꠣꠚꠞ ꠉꠦꠍꠦ ꠢꠥꠔꠤꠟ। ꠔꠣꠁ ꠇꠥꠘ ꠡꠝꠄ ꠢꠥꠔꠤꠟ ꠀꠞ ꠇꠥꠘ ꠡꠝꠄ ꠃꠑꠤꠟ, ꠁꠔꠣ ꠔꠣꠁꠘ ꠇꠥꠘ꠆ꠔꠣꠃ ꠐꠦꠞ ꠙꠣꠁꠟꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠟꠥꠔꠞ ꠖꠥꠁꠅ ꠙꠥꠠꠤꠞ ꠙꠦꠐꠅ ꠛꠣꠚꠞꠦꠖꠤ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠀꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","ꠛꠣꠖꠦ ꠛꠠ ꠙꠥꠠꠤꠞ ꠊꠞꠅ ꠙꠥꠀ ꠅꠁꠟꠦ, ꠄꠞ ꠘꠣꠝ ꠞꠣꠈꠟ ꠝꠥꠀꠛ ꠝꠣꠘꠤ, ꠛꠣꠛꠣꠞ ꠉꠦꠍ ꠕꠘꠦ। ꠅꠃ ꠝꠥꠀꠛꠃ ꠅꠈꠘꠇꠥꠞ ꠝꠥꠀꠛꠤ ꠅꠇꠟꠞ ꠝꠥꠟ ꠛꠣꠚ। ");
INSERT INTO syls_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","ꠀꠞ ꠢꠥꠞꠥ ꠙꠥꠠꠤꠞꠅ ꠄꠇ ꠙꠥꠀ ꠅꠁꠟ, ꠄꠞ ꠘꠣꠝ ꠞꠣꠈꠟ ꠛꠤꠘ-ꠅꠝ꠆ꠝꠤ ꠝꠣꠘꠤ, ꠀꠝꠣꠞ ꠝꠥꠟ꠆ꠟꠥꠇꠞ ꠙꠥꠀ। ꠢꠦ ꠅꠈꠘꠇꠥꠞ ꠛꠘꠤ-ꠀꠝ꠆ꠝꠣꠘꠞ ꠝꠥꠟ ꠛꠣꠚ। ");
INSERT INTO syls_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ꠀꠞ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠢꠤꠘ ꠕꠘꠦ ꠘꠦꠉꠦꠜꠞ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠛꠣꠄ ꠉꠤꠀ ꠇꠣꠖꠦꠡ ꠀꠞ ꠡꠥꠞꠞ ꠝꠣꠎꠈꠣꠘꠅ ꠉꠦꠞꠣꠞ ꠖꠦꠡꠅ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","ꠢꠘꠅ ꠢꠤꠞꠛꠣꠞ ꠔꠣꠘ ꠛꠃ ꠍꠣꠄꠞꠣꠞꠦ ꠘꠤꠎꠞ ꠛꠁꠘ ꠇꠁꠀ ꠙꠞꠤꠌꠄ ꠖꠤꠟꠣ। ꠄꠞꠟꠣꠉꠤ ꠢꠤꠘꠞ ꠛꠣꠖꠡꠣ ꠀꠛꠤꠝꠣꠟꠤꠇꠦ ꠝꠣꠘꠥꠡꠖꠤ ꠍꠣꠄꠞꠣꠞꠦ ꠔꠣꠘ ꠉꠦꠍꠦ ꠘꠤꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","ꠀꠞ ꠞꠣꠁꠔ ꠀꠟ꠆ꠟꠣꠄ ꠀꠛꠤꠝꠣꠟꠤꠇꠞꠦ ꠈꠥꠀꠛꠦ ꠇꠁꠟꠣ, “ꠢꠥꠘꠅ, ꠅꠃ ꠎꠦ ꠛꠦꠐꠤꠞꠦ ꠔꠥꠝꠤ ꠟꠁꠀ ꠀꠁꠍ, ꠔꠣꠁꠞ ꠔ ꠎꠣꠝꠣꠁ ꠀꠍꠦ, ꠄꠞꠟꠣꠉꠤ ꠔꠥꠝꠤ ꠅꠈꠘ ꠝꠃꠔꠞ ꠝꠥꠈꠅ।” ");
INSERT INTO syls_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","ꠀꠛꠤꠝꠣꠟꠤꠇ ꠅꠈꠘꠅ ꠍꠣꠄꠞꠣꠞ ꠉꠦꠍꠦ ꠉꠦꠍꠂꠘ ꠘꠣ। ꠄꠞꠟꠣꠉꠤ ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠅ ꠝꠣꠟꠤꠇ, ꠘꠤ-ꠅꠙꠞꠣꠗꠤ ꠎꠣꠔꠤ ꠅꠁꠟꠦꠅ ꠇꠤꠔꠣ ꠀꠙꠘꠦ ꠝꠣꠞꠤꠟꠣꠁꠔꠣ ꠘꠤ? ");
INSERT INTO syls_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","ꠅꠃ ꠝꠣꠘꠥꠡꠐꠣꠄ ꠔ ꠘꠤꠎꠦꠃ ꠇꠁꠍꠦ, ꠄꠁꠘ ꠔꠣꠞ ꠛꠁꠘ। ꠀꠞ ꠅꠃ ꠛꠦꠐꠤꠄꠅ ꠇꠁꠍꠂꠘ ꠘꠣ ꠘꠤ, ꠄꠁꠘ ꠔꠣꠘ ꠜꠣꠁ? ꠀꠝꠤ ꠔ ꠡꠞꠟ ꠝꠘꠦ ꠘꠤ-ꠅꠙꠞꠣꠗꠤ ꠀꠔꠦ ꠁ ꠇꠣꠝ ꠇꠞꠍꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","ꠀꠟ꠆ꠟꠣꠄ ꠈꠥꠀꠛꠦ ꠔꠣꠘꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤꠅ ꠎꠣꠘꠤ, ꠔꠥꠝꠤ ꠡꠞꠟ ꠝꠘꠦ ꠁ ꠇꠣꠝ ꠇꠞꠍ। ꠄꠞꠟꠣꠉꠤ ꠔꠥꠝꠣꠞꠦ ꠉꠥꠘꠣꠞ ꠇꠣꠝ ꠕꠣꠇꠤ ꠀꠝꠤ ꠖꠝ ꠟꠅꠀꠁꠟꠣꠝ। ꠔꠣꠁꠞꠦ ꠍꠁꠔꠦ ꠖꠤꠟꠣꠝ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ꠅꠈꠘ ꠔꠥꠝꠤ ꠔꠣꠘ ꠛꠤꠛꠤꠞꠦ ꠔꠣꠘ ꠉꠦꠍꠦ ꠚꠤꠞꠔ ꠖꠤꠟꠣꠅ। ꠔꠣꠁꠘ ꠄꠇꠎꠘ ꠘꠛꠤ। ꠔꠣꠁꠘ ꠔꠥꠝꠣꠞ ꠟꠣꠉꠤ ꠖꠥꠀ ꠇꠞꠛꠣ, ꠔꠦꠃ ꠔꠥꠝꠣꠞ ꠎꠣꠘ ꠛꠣꠌꠛ। ꠀꠞ ꠎꠥꠖꠤ ꠔꠣꠁꠞꠦ ꠚꠤꠞꠔ ꠘꠣ ꠖꠦꠅ, ꠔꠦ ꠎꠣꠘꠤꠟꠤꠅ, ꠔꠥꠝꠤ ꠀꠞ ꠔꠥꠝꠣꠞ ꠢꠇꠟꠃ ꠘꠤꠌꠄ ꠝꠞꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","ꠅꠃ ꠀꠛꠤꠝꠣꠟꠤꠇꠦ ꠚꠎꠞꠦ ꠃꠑꠤꠀ ꠔꠣꠘ ꠘꠤꠎꠞ ꠃꠎꠤꠞ-ꠘꠣꠎꠤꠞ ꠅꠇꠟꠞꠦ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠇꠁꠟꠣ, ꠁꠔꠣ ꠢꠥꠘꠤꠀ ꠔꠣꠞꠣ ꠈꠥꠛ ꠛꠦꠡꠤ ꠒꠞꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","ꠛꠣꠖꠦ ꠀꠛꠤꠝꠣꠟꠤꠇꠦ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞꠦ ꠀꠘꠣꠁꠀ ꠇꠁꠟꠣ, “ꠀꠙꠘꠦ ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠁꠔꠣ ꠇꠥꠘ ꠎꠣꠔꠞ ꠛꠦꠛꠢꠣꠞ ꠇꠞꠟꠣ? ꠀꠝꠤ ꠀꠙꠘꠣꠞ ꠉꠦꠍꠦ ꠇꠤꠔꠣ ꠖꠥꠡ ꠇꠞꠍꠤ ꠎꠦꠘ, ꠀꠙꠘꠦ ꠀꠝꠣꠞꠦ ꠀꠞ ꠀꠝꠣꠞ ꠛꠣꠖꠡꠣꠁꠞꠦ ꠅꠔ ꠛꠠ ꠉꠥꠘꠣꠞ ꠖꠣꠄꠄ ꠚꠣꠟꠣꠁꠟꠣ? ꠀꠙꠘꠦ ꠔ ꠀꠝꠣꠞ ꠟꠉꠦ ꠁꠔꠣ ꠅꠁꠘ꠆ꠘꠣꠄ ꠇꠣꠝ ꠇꠞꠟꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","ꠀꠛꠤꠝꠣꠟꠤꠇꠦ ꠀꠞꠅ ꠇꠁꠟꠣ, “ꠀꠙꠘꠦ ꠇꠤꠔꠣ ꠖꠦꠈꠤꠀ ꠁꠟꠣ ꠇꠣꠝ ꠇꠞꠟꠣ?” ");
INSERT INTO syls_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠀꠝꠤ ꠝꠘꠦ ꠇꠞꠍꠟꠣꠝ, ꠁ ꠎꠣꠉꠣꠞ ꠝꠣꠘꠡꠞ ꠀꠟ꠆ꠟꠣꠞ ꠛꠣꠄ ꠇꠥꠘꠥ ꠒꠞ-ꠜꠄ ꠘꠣꠄ, ꠄꠞꠟꠣꠉꠤ ꠀꠝꠣꠞ ꠛꠃꠞ ꠟꠣꠟꠌꠦ ꠢꠄꠔ ꠔꠣꠞꠣ ꠀꠝꠣꠞꠦ ꠈꠥꠘ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","ꠀꠞ ꠔꠣꠁ ꠢꠣꠍꠣꠃ ꠀꠝꠣꠞ ꠛꠁꠘ ꠟꠣꠉꠦ, ꠇꠣꠞꠘ ꠔꠣꠁ ꠀꠝꠣꠞ ꠢꠣꠔꠘ ꠊꠞꠞ ꠛꠁꠘ, ꠀꠞ ꠅꠈꠘ ꠀꠝꠣꠞ ꠛꠃ। ");
INSERT INTO syls_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","ꠀꠟ꠆ꠟꠣꠄ ꠎꠦꠛꠟꠣ ꠀꠝꠣꠞꠦ ꠀꠝꠣꠞ ꠛꠣꠚꠞ ꠛꠣꠠꠤ ꠕꠘꠦ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠟꠣ, ꠅꠃ ꠡꠝꠄ ꠀꠝꠤ ꠔꠣꠁꠞꠦ ꠇꠁꠍꠟꠣꠝ, ‘ꠔꠥꠝꠤ ꠀꠝꠣꠞꠦ ꠅꠃ ꠝꠣꠄꠀꠈꠣꠘ ꠇꠞꠤꠅ, ꠀꠝꠞꠣ ꠎꠦꠘꠅꠃ ꠎꠣꠁ ꠘꠣ ꠇꠦꠘꠦ, ꠔꠥꠝꠤ ꠀꠝꠣꠞꠦ ꠔꠥꠝꠣꠞ ꠜꠣꠁ ꠇꠁꠀ ꠙꠞꠤꠌꠄ ꠖꠤꠅ।’ ” ");
INSERT INTO syls_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","ꠛꠣꠖꠦ ꠀꠛꠤꠝꠣꠟꠤꠇꠦ ꠇꠔꠐꠣ ꠝꠦꠠꠣ-ꠉꠞꠥ, ꠛꠣꠘ꠆ꠖꠤ-ꠉꠥꠟꠣꠝ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞꠦ ꠖꠤꠟꠣ ꠀꠞ ꠔꠣꠘ ꠛꠤꠛꠤ ꠍꠣꠄꠞꠣꠞꠦꠅ ꠚꠤꠞꠔ ꠖꠤꠟꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","ꠀꠛꠤꠝꠣꠟꠤꠇꠦ ꠇꠁꠟꠣ, “ꠖꠦꠈꠃꠇ꠆ꠇꠣ, ꠀꠝꠣꠞ ꠀꠡ꠆ꠔꠣ ꠖꠦꠡꠐꠣꠃ ꠀꠙꠘꠣꠞ ꠍꠣꠝꠘꠦ ꠙꠠꠤ ꠞꠁꠍꠦ, ꠔꠦ ꠀꠙꠘꠣꠞ ꠎꠦꠘꠅ ꠙꠍꠘ꠆ꠖ ꠅꠘꠅꠃ ꠞꠃꠇ꠆ꠇꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","ꠔꠣꠁꠘ ꠍꠣꠄꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠖꠦꠈꠃꠇ꠆ꠇꠣ, ꠀꠝꠤ ꠀꠙꠘꠣꠞ ꠜꠣꠁꠞꠦ ꠄꠇ ꠀꠎꠣꠞ ꠞꠥꠙꠣꠞ ꠐꠦꠇꠣ ꠖꠤꠟꠣꠝ। ꠀꠞ ꠀꠙꠘꠣꠞ ꠁꠎ꠆ꠎꠔꠞ ꠢꠇꠟ ꠛꠤꠌꠣꠞꠞ ꠚꠄꠍꠣꠟꠣ ꠅꠁꠟ।” ");
INSERT INTO syls_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","ꠛꠣꠖꠦ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠀꠟ꠆ꠟꠣꠞ ꠉꠦꠍꠦ ꠖꠥꠀ ꠇꠞꠟꠣ, ꠀꠞ ꠀꠟ꠆ꠟꠣꠄ ꠀꠛꠤꠝꠣꠟꠤꠇ, ꠔꠣꠘ ꠛꠃ ꠀꠞ ꠔꠣꠘ ꠛꠣꠘ꠆ꠖꠤ ꠅꠇꠟꠞꠦ ꠡꠤꠚꠣ ꠇꠞꠟꠣ ꠀꠞ ꠔꠣꠞꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠅ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","ꠇꠣꠞꠘ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠛꠤꠛꠤ ꠍꠣꠄꠞꠣꠞ ꠟꠣꠉꠤ ꠝꠣꠛꠥꠖꠦ ꠀꠛꠤꠝꠣꠟꠤꠇꠞ ꠛꠣꠠꠤꠞ ꠢꠇꠟ ꠛꠦꠐꠤꠘ꠆ꠔꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠅꠀ ꠛꠘ꠆ꠖ ꠇꠞꠤ ꠖꠤꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘ ꠇꠣꠟꠣꠝ ꠝꠥꠔꠣꠛꠦꠇ ꠛꠤꠛꠤ ꠍꠣꠄꠞꠣꠞꠦ ꠢꠦꠚꠣꠎꠔ ꠇꠞꠟꠣ, ꠔꠣꠁꠘ ꠎꠦꠟꠣ ꠅꠀꠖꠣ ꠇꠞꠍꠟꠣ, ꠅꠟꠣꠃ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","ꠀꠞ ꠛꠤꠛꠤ ꠍꠣꠄꠞꠣꠞ ꠙꠦꠐꠅ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠀꠁꠟ। ꠀꠟ꠆ꠟꠣꠄ ꠎꠦ ꠡꠝꠄꠇꠥꠞ ꠇꠕꠣ ꠇꠁꠍꠟꠣ, ꠢꠃ ꠡꠝꠄꠄꠃ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠝꠥꠞꠛ꠆ꠛꠤ ꠛꠄꠅꠡꠅ ꠔꠣꠘ ꠙꠥꠀꠞ ꠎꠘꠝ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠍꠣꠄꠞꠣꠞ ꠊꠞꠞ ꠔꠣꠘ ꠅꠃ ꠙꠥꠀꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠁꠍꠢꠣꠇ ꠝꠣꠘꠤ, ꠀꠡꠣ। ");
INSERT INTO syls_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","ꠀꠟ꠆ꠟꠣꠞ ꠢꠥꠇꠥꠝ ꠝꠔ ꠔꠣꠁꠘ ꠀꠐ ꠖꠤꠘꠞ ꠖꠤꠘ ꠔꠣꠘ ꠙꠥꠀ ꠁꠍꠢꠣꠇꠞ ꠝꠍꠟꠝꠣꠘꠤ ꠇꠣꠝ ꠇꠞꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠄꠇ-ꠡ ꠛꠍꠞꠞ ꠡꠝꠄ ꠔꠣꠘ ꠙꠥꠀ ꠁꠍꠢꠣꠇꠞ ꠎꠘꠝ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","ꠛꠤꠛꠤ ꠍꠣꠄꠞꠣꠄ ꠇꠁꠟꠣ, “ꠀꠟ꠆ꠟꠣꠄ ꠀꠝꠣꠞ ꠝꠥꠈꠅ ꠀꠡꠤ ꠛꠣꠞ ꠇꠞꠟꠣ, ꠀꠞ ꠁꠔꠣ ꠎꠦ ꠢꠥꠘꠛ, ꠢꠦ-ꠅ ꠀꠝꠣꠞ ꠟꠉꠦ ꠀꠡꠤꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","ꠔꠣꠁꠘ ꠀꠞꠅ ꠇꠁꠟꠣ, “ꠍꠣꠄꠞꠣꠄ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠛꠥꠇꠥꠞ ꠖꠥꠗ ꠈꠣꠅꠀꠁꠛ, ꠁꠔꠣ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞꠦ ꠇꠦ ꠇꠁꠟ ꠅꠘꠦ? ꠀꠞ ꠅꠈꠘ ꠔ ꠅꠃ ꠛꠥꠠꠣ ꠛꠄꠅꠡꠅ, ꠀꠝꠣꠞ ꠙꠦꠐꠅ ꠔꠣꠘ ꠙꠥꠀ ꠙꠄꠖꠣ ꠅꠁꠟ।” ");
INSERT INTO syls_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ꠁꠍꠢꠣꠇ ꠛꠠ ꠅꠀꠞ ꠛꠣꠖꠦ ꠎꠦꠖꠤꠘ ꠔꠣꠘꠦ ꠝꠣʼꠞ ꠖꠥꠗ ꠍꠣꠠꠣꠁꠟ ꠅꠁꠟ, ꠢꠃꠖꠤꠘ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠄꠇ ꠛꠠ ꠝꠦꠎꠛꠣꠘꠤ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ꠀꠞ ꠝꠤꠡꠞꠤ ꠢꠣꠎꠦꠞꠣꠞ ꠙꠦꠐꠅ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠎꠦ ꠙꠥꠀ ꠅꠁꠍꠤꠟ, ꠍꠣꠄꠞꠣꠄ ꠖꠦꠈꠟꠣ ꠢꠦ ꠔꠣꠝꠡꠣ ꠇꠞꠦꠞ। ");
INSERT INTO syls_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ꠅꠃ ꠔꠣꠁꠘ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞꠦ ꠇꠁꠟꠣ, “ꠙꠥꠀ ꠡꠢ ꠁ ꠛꠣꠘ꠆ꠖꠤꠞꠦ ꠛꠣꠞ ꠇꠞꠤ ꠖꠦꠅ, ꠛꠣꠘ꠆ꠖꠤꠞ ꠙꠥꠀ ꠀꠝꠣꠞ ꠁꠍꠢꠣꠇꠞ ꠟꠉꠦ ꠅꠋꠡꠤꠖꠣꠞ ꠅꠁꠔ ꠙꠣꠞꠔ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ꠙꠥꠀꠞ ꠁꠔꠣ ꠢꠥꠘꠤꠀ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠝꠘꠅ ꠈꠥꠛ ꠔꠇꠟꠤꠚ ꠙꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","ꠅꠃ ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠘꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠛꠣꠘ꠆ꠖꠤ ꠀꠞ ꠔꠣꠁꠞ ꠙꠥꠀꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠤ ꠛꠦꠎꠣꠞ ꠅꠁꠅ ꠘꠣ। ꠍꠣꠄꠞꠣꠄ ꠎꠦꠟꠣ ꠔꠥꠝꠣꠞꠦ ꠇꠁꠍꠦ ꠅꠃꠟꠣ ꠇꠞꠅ, ꠇꠣꠞꠘ ꠔꠥꠝꠣꠞ ꠙꠥꠀ ꠁꠍꠢꠣꠇꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞꠦꠃ ꠔꠥꠝꠣꠞ ꠈꠣꠘ꠆ꠖꠣꠘ ꠇꠁꠀ ꠉꠘꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","ꠀꠞ ꠁ ꠛꠣꠘ꠆ꠖꠤꠞ ꠔꠞꠚꠣ ꠙꠥꠀ ꠕꠣꠇꠤꠅ ꠀꠝꠤ ꠄꠇꠐꠣ ꠎꠣꠔꠤ ꠔꠂꠀꠞ ꠇꠞꠝꠥ, ꠇꠣꠞꠘ ꠢꠦ-ꠅ ꠔ ꠔꠥꠝꠣꠞ ꠀꠅꠟꠣꠖ।” ");
INSERT INTO syls_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","ꠅꠃ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠀꠉꠥꠀꠘ ꠃꠑꠤꠀ ꠇꠤꠍꠥ ꠞꠥꠐꠤ ꠀꠞ ꠙꠣꠘꠤ ꠜꠞꠣ ꠄꠇꠐꠣ ꠌꠣꠝꠠꠣꠞ ꠕꠟꠤ ꠢꠣꠎꠣꠁꠀ ꠢꠣꠎꠦꠞꠣꠞ ꠇꠣꠘ꠆ꠖꠅ ꠔꠥꠟꠤꠀ ꠖꠤꠀ, ꠙꠥꠀꠉꠥꠞꠦ ꠔꠣꠁꠞ ꠀꠔꠅ ꠡꠙꠤꠀ ꠛꠤꠖꠣꠄ ꠇꠞꠟꠣ। ꠢꠤꠘ ꠕꠘꠦ ꠛꠣꠞ ꠅꠁꠀ ꠢꠣꠎꠦꠞꠣꠄ ꠛꠦꠞ-ꠡꠦꠛꠣꠞ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠝꠣꠎꠦ ꠌꠇ꠆ꠇꠞ ꠖꠤꠔꠣ ꠟꠣꠉꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","ꠕꠟꠤꠞ ꠙꠣꠘꠤ ꠡꠦꠡ ꠅꠁꠉꠦꠟꠦ ꠔꠣꠁꠘ ꠙꠥꠀꠞꠦ ꠄꠇꠐꠣ ꠎꠋꠟꠣꠞ ꠔꠟꠦ ꠢꠥꠔꠣꠁꠀ ꠕꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ꠀꠞ ꠄꠇ ꠒꠣꠇꠞ ꠙꠞꠤꠝꠣꠘ ꠖꠥꠞꠁ ꠉꠤꠀ ꠔꠣꠁꠘ ꠛꠁꠞꠁꠟꠣ। “ꠙꠥꠀꠞ ꠝꠃꠔ ꠎꠣꠔꠦ ꠀꠝꠣꠞ ꠌꠃꠈꠦ ꠘꠣ ꠖꠦꠈꠤ,” ꠝꠘꠦ ꠝꠘꠦ ꠇꠁꠀ, ꠔꠣꠁꠘ ꠢꠘꠅ ꠛꠁꠀꠃ ꠌꠤꠟ꠆ꠟꠣꠁꠀ ꠇꠣꠘ꠆ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","ꠙꠥꠀꠉꠥꠞ ꠇꠣꠘ꠆ꠖꠘ ꠀꠟ꠆ꠟꠣꠄ ꠢꠥꠘꠟꠣ, ꠀꠞ ꠀꠟ꠆ꠟꠣꠞ ꠚꠤꠞꠤꠡ꠆ꠔꠣꠄ ꠀꠍꠝꠣꠘ ꠕꠘꠦ ꠒꠣꠇꠤꠀ ꠢꠣꠎꠦꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠢꠣꠎꠦꠞꠣ, ꠅ ꠢꠣꠎꠦꠞꠣ, ꠔꠥꠝꠣꠞ ꠇꠤꠔꠣ ꠅꠁꠍꠦ? ꠒꠞꠣꠁꠅ ꠘꠣ, ꠙꠥꠀꠉꠥ ꠎꠦꠘꠅ ꠀꠍꠦ, ꠢꠘ ꠕꠣꠇꠤꠃ ꠔꠣꠞ ꠇꠣꠘ꠆ꠖꠘ ꠀꠟ꠆ꠟꠣꠄ ꠢꠥꠘꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ꠔꠥꠝꠤ ꠃꠑꠤꠀ ꠙꠥꠀꠉꠥꠞ ꠀꠔꠅ ꠗꠞꠅ, ꠀꠝꠤ ꠔꠣꠞꠦꠖꠤ ꠄꠇ ꠛꠤꠞꠣꠐ ꠎꠣꠔꠤ ꠙꠄꠖꠣ ꠇꠞꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","ꠅꠃ ꠀꠟ꠆ꠟꠣꠄ ꠢꠣꠎꠦꠞꠣꠞ ꠌꠃꠈ ꠈꠥꠟꠤꠀ ꠖꠤꠟꠣ, ꠀꠞ ꠔꠣꠁꠘ ꠄꠇ ꠇꠥꠀ ꠖꠦꠈꠟꠣ। ꠢꠤ ꠇꠥꠀ ꠕꠘꠦ ꠌꠣꠝꠠꠣꠞ ꠕꠟꠤꠔ ꠙꠣꠘꠤ ꠜꠞꠤ ꠀꠘꠤꠀ ꠙꠥꠀꠞꠦ ꠈꠣꠅꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","ꠀꠟ꠆ꠟꠣꠄ ꠢꠃ ꠙꠥꠀꠞꠦ ꠢꠦꠚꠣꠎꠔ ꠇꠞꠟꠣ। ꠢꠦ ꠛꠠ ꠅꠁꠟ, ꠀꠞ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠕꠣꠇꠤꠀ ꠔꠤꠞ-ꠗꠘꠥꠇ ꠌꠣꠟꠣꠘꠤꠞ ꠃꠡ꠆ꠔꠣꠖ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","ꠢꠦ ꠚꠣꠞꠣꠘ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠕꠣꠇꠔ। ꠔꠣꠞ ꠝꠣʼꠄ ꠝꠤꠡꠞꠞ ꠄꠇ ꠙꠥꠠꠤꠞꠦ ꠀꠘꠤꠀ ꠔꠣꠞꠦ ꠛꠤꠀ ꠇꠞꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ꠢꠃ ꠡꠝꠄ ꠀꠛꠤꠝꠣꠟꠤꠇ ꠀꠞ ꠔꠣꠘ ꠡꠦꠘꠣꠙꠔꠤ ꠚꠤꠈꠥꠟꠦ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞꠦ ꠇꠁꠟꠣ, “ꠀꠙꠘꠦ ꠎꠦꠔꠣꠃ ꠇꠞꠂꠘ, ꠅꠔꠣꠔꠃ ꠀꠟ꠆ꠟꠣꠄ ꠀꠙꠘꠣꠞ ꠟꠉꠦ ꠕꠣꠇꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","ꠄꠞꠟꠣꠉꠤ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠦ ꠀꠙꠘꠦ ꠅꠈꠘ ꠅꠘꠅ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠇꠍꠝ ꠇꠞꠃꠇ꠆ꠇꠣ, ꠀꠝꠣꠞ ꠛꠣ ꠀꠝꠣꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠞ ꠟꠉꠦ, ꠀꠙꠘꠦ ꠇꠥꠘꠥ ꠛꠦꠁꠝꠣꠘꠤ ꠇꠞꠔꠣ ꠘꠣꠄ। ꠀꠞ ꠀꠝꠤ ꠎꠦꠟꠣ ꠀꠙꠘꠣꠞꠦ ꠖꠄꠀ ꠖꠦꠈꠣꠁꠍꠤ, ꠀꠙꠘꠦꠅ ꠀꠝꠣꠞ ꠟꠉꠦ ꠀꠞ ꠀꠙꠘꠣꠞ ꠝꠥꠍꠣꠚꠤꠞꠤꠞ ꠎꠣꠉꠣ, ꠁ ꠖꠦꠡꠞ ꠟꠉꠦ ꠅꠃꠟꠣ ꠖꠄꠀꠞ ꠘꠎꠞ ꠞꠣꠈꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠇꠁꠟꠣ, “ꠎꠤꠅꠄ, ꠇꠍꠝ ꠇꠞꠟꠣꠝ।” ");
INSERT INTO syls_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","ꠀꠞ ꠀꠛꠤꠝꠣꠟꠤꠇꠞ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠦ ꠄꠇꠐꠣ ꠙꠣꠘꠤꠞ ꠇꠥꠀ ꠎꠥꠞꠦ ꠘꠤꠍꠤꠟꠉꠤ ꠇꠞꠤ, ꠔꠣꠁꠘ ꠘꠣꠟꠤꠡ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","ꠀꠛꠤꠝꠣꠟꠤꠇꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠁꠔꠣ ꠇꠣꠝ ꠇꠦ ꠇꠞꠍꠦ ꠀꠝꠤ ꠔ ꠎꠣꠘꠤ ꠘꠣ। ꠀꠙꠘꠦꠅ ꠀꠝꠣꠞꠦ ꠁꠔꠣ ꠇꠁꠍꠂꠘ ꠘꠣ, ꠀꠁꠎꠃ ꠀꠝꠤ ꠁꠇꠐꠣ ꠢꠥꠘꠟꠣꠝ।” ");
INSERT INTO syls_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","ꠛꠣꠖꠦ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠇꠤꠍꠥ ꠝꠦꠠꠣ ꠀꠞ ꠉꠞꠥ ꠀꠘꠤꠀ ꠀꠛꠤꠝꠣꠟꠤꠇꠞꠦ ꠖꠤꠟꠣ ꠀꠞ ꠖꠥꠁꠅꠎꠘꠦ ꠌꠥꠇ꠆ꠔꠤ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","ꠀꠞ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠙꠣꠟ ꠕꠘꠦ ꠡꠣꠔꠉꠥ ꠝꠦꠠꠤ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠀꠟꠉꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","ꠀꠛꠤꠝꠣꠟꠤꠇꠦ ꠔꠣꠘꠦ ꠎꠤꠇꠣꠁꠟꠣ, “ꠁ ꠝꠦꠠꠤ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠡꠣꠔꠉꠥ ꠀꠟꠉꠣ ꠇꠞꠣꠞ ꠝꠣꠘꠤ ꠇꠤꠔꠣ?” ");
INSERT INTO syls_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠇꠁꠟꠣ, “ꠀꠙꠘꠦ ꠅꠉꠥꠁꠘ꠆ꠔꠞꠦ ꠘꠦꠃꠇ꠆ꠇꠣ। ꠁ ꠇꠥꠀꠐꠣ ꠎꠦ ꠀꠝꠤ ꠈꠥꠖꠍꠤ ꠁꠇꠐꠣ ꠅꠁꠟ ꠔꠣꠞ ꠙꠞꠝꠣꠘ।” ");
INSERT INTO syls_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","ꠄꠞꠟꠣꠉꠤ ꠅꠃ ꠎꠣꠉꠣꠞ ꠘꠣꠝ ꠅꠁꠟ ꠛꠦꠞ-ꠡꠦꠛꠣ ꠝꠣꠘꠤ, ꠇꠍꠝꠞ ꠇꠥꠀ, ꠅꠘꠅꠃ ꠔꠣꠞꠣ ꠖꠥꠁꠅ ꠎꠘꠦ ꠇꠍꠝ ꠇꠞꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","ꠔꠣꠞꠣ ꠛꠦꠞ-ꠡꠦꠛꠣꠔ ꠅꠃ ꠌꠥꠇ꠆ꠔꠤ ꠇꠞꠣꠞ ꠛꠣꠖꠦ, ꠀꠛꠤꠝꠣꠟꠤꠇ ꠀꠞ ꠔꠣꠘ ꠡꠦꠘꠣꠙꠔꠤ ꠚꠤꠈꠥꠟ ꠃꠑꠤꠀ ꠚꠤꠟꠤꠡ꠆ꠔꠤꠘꠤ ꠅꠇꠟꠞ ꠖꠦꠡꠅ ꠚꠤꠞꠤꠀ ꠉꠦꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","ꠛꠣꠖꠦ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠛꠦꠞ-ꠡꠦꠛꠣꠔ ꠄꠇꠐꠣ ꠏꠣꠃ ꠉꠣꠍ ꠞꠥꠁꠟꠣ, ꠀꠞ ꠎꠦ ꠝꠣꠛꠥꠖꠞ ꠡꠥꠞꠥꠅ ꠘꠣꠄ ꠡꠦꠡꠅ ꠘꠣꠄ, ꠔꠣꠘ ꠄꠛꠣꠖꠔ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ꠀꠞ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠚꠤꠟꠤꠡ꠆ꠔꠤꠘꠤ ꠅꠇꠟꠞ ꠖꠦꠡꠅ ꠛꠃꠔ ꠖꠤꠘ ꠇꠣꠐꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","ꠁ ꠊꠐꠘꠣꠞ ꠛꠣꠖꠦ ꠀꠟ꠆ꠟꠣꠄ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠄꠇ ꠙꠞꠤꠇ꠆ꠇꠣ ꠟꠁꠟꠣ। ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠘꠞꠦ ꠒꠣꠇ ꠖꠤꠟꠣ, “ꠁꠛ꠆ꠞꠣꠢꠤꠝ!” ꠔꠣꠁꠘ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠅꠃꠘꠥ ꠀꠝꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","ꠝꠣꠛꠥꠖꠦ ꠚꠞꠝꠣꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠙꠥꠀꠞꠦ, ꠎꠣꠞꠦ ꠔꠥꠝꠤ ꠅꠔ ꠝꠢꠛ꠆ꠛꠔ ꠇꠞꠅ, ꠢꠃ ꠈꠣꠍ ꠝꠣꠄꠀꠞ ꠙꠥꠔ ꠁꠍꠢꠣꠇꠞꠦ ꠟꠁꠀ ꠔꠥꠝꠤ ꠝꠥꠞꠤꠀ ꠄꠟꠣꠇꠣꠔ ꠎꠣꠅ। ꠢꠈꠣꠘꠅ ꠎꠦ ꠙꠣꠠꠞ ꠇꠕꠣ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠇꠁꠝꠥ, ꠄꠞ ꠃꠙꠞꠦ ꠔꠣꠞꠦ ꠘꠤꠀ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅ।” ");
INSERT INTO syls_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","ꠔꠦꠃ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠚꠎꠞꠦ ꠃꠑꠤꠀ ꠉꠣꠗꠣꠞ ꠙꠤꠑꠤꠔ ꠉꠖ꠆ꠖꠤ ꠟꠣꠉꠣꠁꠀ ꠔꠣꠘ ꠙꠥꠀ ꠁꠍꠢꠣꠇ, ꠖꠥꠁꠎꠘ ꠉꠥꠟꠣꠝ ꠀꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠟꠣꠇꠠꠤ ꠇꠣꠐꠤꠀ ꠟꠁꠀ, ꠎꠦ ꠎꠣꠉꠣꠞ ꠇꠕꠣ ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠘꠞꠦ ꠇꠁꠍꠟꠣ, ꠢꠛꠣꠄꠖꠤ ꠞꠅꠀꠘꠣ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","ꠔꠤꠘ ꠖꠤꠘꠞ ꠖꠤꠘ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠌꠃꠈ ꠔꠥꠟꠤꠀ ꠌꠣꠁꠔꠦꠃ ꠖꠥꠞꠁ ꠕꠣꠇꠤ ꠢꠃ ꠎꠣꠉꠣꠈꠣꠘ ꠖꠦꠈꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","ꠅꠃ ꠔꠣꠘ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠉꠣꠗꠣꠐꠣ ꠟꠁꠀ ꠅꠘꠅ ꠃꠛꠣꠅ, ꠀꠝꠤ ꠀꠞ ꠀꠝꠣꠞ ꠙꠥꠀ ꠢꠘꠅ ꠉꠤꠀ ꠄꠛꠣꠖꠔꠤ ꠡꠦꠡ ꠇꠞꠤꠀ ꠢꠣꠞꠟꠦ ꠔꠥꠝꠞꠣꠞ ꠉꠦꠍꠦ ꠀꠁꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠇꠠꠤꠞ ꠀꠐꠣ ꠔꠣꠘ ꠙꠥꠀ ꠁꠍꠢꠣꠇꠞ ꠇꠣꠘ꠆ꠖꠅ ꠔꠥꠟꠤꠀ ꠖꠤꠀ ꠘꠤꠎꠦ ꠀꠉꠥꠁꠘꠞ ꠙꠣꠔꠤꠟ ꠀꠞ ꠍꠥꠞꠤ ꠟꠁꠀ, ꠖꠥꠁꠅ ꠎꠘꠦ ꠍꠣꠝꠘꠞ ꠛꠣꠄ ꠀꠉꠥꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ꠅꠃ ꠁꠍꠢꠣꠇꠦ ꠔꠣꠘ ꠛꠣꠚꠞꠦ ꠇꠁꠟꠣ, “ꠛꠣꠛꠣ।” ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠇꠤꠔꠣꠞꠦ ꠛꠣꠚ ꠇꠅ?” ꠁꠍꠢꠣꠇꠦ ꠇꠁꠟꠣ, “ꠁꠘꠅ ꠔ ꠟꠣꠇꠠꠤ ꠀꠞ ꠀꠉꠥꠁꠘ ꠀꠍꠦ, ꠔꠦ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠇꠥꠀꠁ?” ");
INSERT INTO syls_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","ꠔꠣꠁꠘ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠛꠣꠛꠣꠞꠦ, ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠀꠟ꠆ꠟꠣꠄ ꠘꠤꠎꠦꠃ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠎꠥꠉꠣꠁꠛꠣ।” ꠅꠔꠣ ꠝꠣꠔꠔꠦ ꠝꠣꠔꠔꠦ ꠔꠣꠞꠣ ꠀꠉꠥꠀꠁ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ꠀꠟ꠆ꠟꠣꠞ ꠙꠍꠘ꠆ꠖꠞ ꠎꠣꠉꠣꠔ ꠙꠃꠍꠤꠀ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠁꠀ, ꠟꠣꠇꠠꠤ ꠢꠣꠎꠣꠁꠟꠣ। ꠛꠣꠖꠦ ꠘꠤꠎꠞ ꠙꠥꠀ ꠁꠍꠢꠣꠇꠞꠦ ꠛꠣꠘ꠆ꠖꠤꠀ ꠅꠃ ꠖꠣꠞꠥꠞ ꠃꠙꠞꠦ ꠢꠥꠔꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","ꠀꠞ ꠔꠣꠁꠘ ꠘꠤꠎꠞ ꠙꠥꠀꠞꠦ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠍꠥꠞꠤ ꠀꠔꠅ ꠟꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ꠅꠃ ꠝꠣꠛꠥꠖꠞ ꠚꠤꠞꠤꠡ꠆ꠔꠣꠄ ꠀꠍꠝꠣꠘ ꠕꠘꠦ ꠔꠣꠘꠦ ꠒꠣꠇ ꠖꠤꠟꠣ, “ꠁꠛ꠆ꠞꠣꠢꠤꠝ! ꠅ ꠁꠛ꠆ꠞꠣꠢꠤꠝ!” ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠅꠃꠘꠥ ꠀꠝꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","ꠚꠤꠞꠤꠡ꠆ꠔꠣꠄ ꠇꠁꠟꠣ, “ꠙꠥꠀꠉꠥꠞ ꠛꠣꠄ ꠔꠥꠝꠣꠞ ꠀꠔ ꠔꠥꠟꠤꠅ ꠘꠣ, ꠔꠣꠞꠦ ꠀꠞ ꠇꠥꠘ꠆ꠔꠣꠃ ꠇꠞꠤꠅ ꠘꠣ। ꠔꠥꠝꠤ ꠎꠦꠘ ꠀꠟ꠆ꠟꠣꠞꠦ ꠒꠞꠣꠅ ꠁꠔꠣ ꠛꠥꠎꠣ ꠉꠦꠍꠦ, ꠇꠣꠞꠘ ꠀꠝꠣꠞꠦ ꠔꠥꠝꠣꠞ ꠙꠥꠀ, ꠔꠥꠝꠣꠞ ꠈꠣꠍ ꠝꠣꠄꠀꠞ ꠙꠥꠀ ꠖꠣꠘ ꠇꠞꠔꠦꠅ ꠘꠣ-ꠈꠥꠡ ꠅꠁꠍ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠌꠃꠈ ꠔꠥꠟꠤ ꠌꠣꠁꠀ ꠖꠦꠈꠂꠘ, ꠔꠣꠘ ꠈꠞꠦ ꠄꠇꠐꠣ ꠖꠥꠝ꠆ꠛꠣ ꠀꠞ ꠔꠣꠞ ꠢꠤꠋ ꠎꠋꠉꠟꠞ ꠝꠣꠎꠦ ꠀꠐꠇꠤ ꠞꠁꠍꠦ। ꠅꠃ ꠔꠣꠁꠘ ꠉꠤꠀ ꠖꠥꠝ꠆ꠛꠣꠐꠣ ꠀꠘꠤꠀ, ꠘꠤꠎꠞ ꠙꠥꠀꠞ ꠛꠖꠟꠣ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","ꠔꠣꠁꠘ ꠢꠤ ꠎꠣꠉꠣꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠁꠀꠅꠄꠢ-ꠎꠤꠞꠤꠢ ꠝꠣꠘꠤ, ꠝꠣꠛꠥꠖꠦ ꠎꠥꠉꠣꠁꠘ। ꠄꠞꠟꠣꠉꠤ ꠅꠈꠘꠅ ꠝꠣꠘꠡꠦ ꠇꠂꠘ, “ꠝꠣꠛꠥꠖꠞ ꠙꠣꠠꠅ ꠎꠥꠉꠣꠁꠟ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","ꠝꠣꠛꠥꠖꠞ ꠚꠤꠞꠤꠡ꠆ꠔꠣꠄ ꠀꠍꠝꠣꠘ ꠕꠘꠦ ꠢꠤꠞꠛꠣꠞ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞꠦ ꠒꠣꠇꠤꠀ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“ꠢꠥꠘꠅ, ꠝꠣꠛꠥꠖꠦ ꠇꠁꠞꠣ, ꠔꠥꠝꠤ ꠅꠃꠟꠣ ꠇꠞꠟꠣꠄ, ꠔꠥꠝꠣꠞ ꠙꠥꠀꠞꠦ, ꠔꠥꠝꠣꠞ ꠈꠣꠍ ꠝꠣꠄꠀꠞ ꠙꠥꠀꠞꠦ ꠖꠣꠘ ꠇꠞꠔꠦꠅ ꠘꠣꠞꠣꠎ ꠅꠁꠟꠣꠄ ꠘꠣ। ꠄꠞꠟꠣꠉꠤ ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠇꠍꠝ ꠇꠞꠤꠀ ꠇꠁꠀꠞ, ");
INSERT INTO syls_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ꠀꠝꠤ ꠘꠤꠌꠄ ꠔꠥꠝꠣꠞꠦ ꠛꠞꠇꠔ ꠘꠣꠎꠤꠟ ꠇꠞꠝꠥ, ꠔꠥꠝꠣꠞ ꠛꠋꠡꠞꠦ ꠀꠍꠝꠣꠘꠞ ꠔꠦꠞꠣ ꠀꠞ ꠖꠞꠤꠀꠞ ꠌꠞꠞ ꠛꠣꠟꠥꠞ ꠟꠣꠈꠣꠘ ꠛꠦꠢꠤꠡꠣꠛ ꠇꠞꠝꠥ। ꠔꠥꠝꠣꠞ ꠛꠋꠡꠄ ꠔꠣꠞꠣꠞ ꠖꠥꠡꠝꠘꠞ ꠐꠣꠃꠘ ꠅꠇꠟ ꠖꠈꠟ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ꠀꠞ ꠔꠥꠝꠣꠞ ꠛꠋꠡꠞ ꠃꠍꠤꠟ꠆ꠟꠣꠄ ꠖꠥꠘꠤꠀꠞ ꠢꠇꠟ ꠎꠣꠔꠤꠄ ꠛꠞꠇꠔ ꠢꠣꠍꠤꠟ ꠇꠞꠛꠣ। ꠇꠣꠞꠘ ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠘꠍ।” ");
INSERT INTO syls_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ꠛꠣꠖꠦ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠔꠣꠘ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠞ ꠉꠦꠍꠦ ꠚꠤꠞꠤꠀ ꠀꠁꠟꠣ, ꠀꠞ ꠔꠣꠞꠣ ꠄꠇꠟꠉꠦ ꠛꠦꠞ-ꠡꠦꠛꠣ ꠘꠣꠝꠞ ꠎꠣꠉꠣꠔ ꠉꠦꠟꠣ। ꠅꠃ ꠎꠣꠉꠣꠔꠃ ꠔꠣꠁꠘ ꠛꠡꠔꠤ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ꠁ ꠊꠐꠘꠣꠞ ꠛꠣꠖꠦ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠈꠛꠞ ꠙꠣꠁꠟꠣ, ꠔꠣꠘ ꠜꠣꠁ ꠘꠣꠢꠥꠞꠞ ꠛꠤꠛꠤ ꠝꠤꠟꠇꠣꠞ ꠇꠄꠉꠥ ꠙꠥꠀꠂꠘ ꠅꠁꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","ꠄꠞ ꠛꠠ ꠙꠥꠀꠞ ꠘꠣꠝ ꠀꠃꠎ, ꠔꠣꠞ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞ ꠘꠣꠝ ꠛꠥꠎ, ꠀꠞ ꠅꠞꠣꠝꠞ ꠛꠣꠚ ꠇꠝꠥꠄꠟ, ");
INSERT INTO syls_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ꠄꠞꠛꠣꠖꠦ ꠇꠦꠍꠖ, ꠢꠡꠅ, ꠙꠤꠟꠖꠡ, ꠎꠤꠖꠟꠚ ꠀꠞ ꠛꠕꠥꠄꠟ। ꠛꠕꠥꠄꠟꠞ ꠙꠥꠠꠤꠞ ꠘꠣꠝ ꠞꠦꠛꠦꠇꠣ। ");
INSERT INTO syls_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠜꠣꠁ ꠘꠣꠢꠥꠞꠞ ꠛꠤꠛꠤ ꠝꠤꠟꠇꠣꠞ ꠙꠦꠐꠅ ꠕꠣꠇꠤ ꠁ ꠀꠐꠎꠘ ꠙꠥꠀꠞ ꠎꠘꠝ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ꠘꠣꠢꠥꠞꠞ ꠄꠇ ꠢꠣꠋꠉꠣꠞ ꠛꠃ ꠀꠍꠤꠟ, ꠔꠣꠁꠞ ꠘꠣꠝ ꠞꠃꠝꠣ। ꠔꠣꠁꠞ ꠙꠦꠐꠅ ꠐꠦꠛꠢ, ꠉꠢꠝ, ꠔꠢꠡ ꠀꠞ ꠝꠣꠈꠣꠞ ꠎꠘꠝ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","ꠛꠤꠛꠤ ꠍꠣꠄꠞꠣ ꠄꠇ-ꠡ ꠡꠣꠔꠣꠁꠡ ꠛꠞꠍ ꠛꠣꠌꠤꠟꠣ; ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠘꠦ ꠅꠔꠖꠤꠘꠞ ꠢꠣꠄꠀꠔꠤ ꠖꠤꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ꠛꠣꠖꠦ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠞ ꠇꠤꠞꠤꠅꠔ-ꠅꠞ꠆ꠛ ꠝꠣꠘꠤ ꠢꠦꠛꠞꠘꠅ ꠁꠘ꠆ꠔꠦꠇꠣꠟ ꠇꠞꠟꠣ। ꠀꠞ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠔꠣꠘ ꠟꠣꠉꠤ ꠛꠃꠔ ꠇꠣꠘ꠆ꠖꠣ-ꠇꠣꠐꠤ ꠀꠞ ꠀꠢꠣꠎꠣꠞꠤ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","ꠢꠦꠡꠦ ꠔꠣꠘ ꠝꠥꠞ꠆ꠖꠣ ꠛꠤꠛꠤꠞ ꠉꠦꠍ ꠕꠘꠦ ꠢꠞꠤꠀ ꠉꠤꠀ ꠢꠃ ꠖꠦꠡꠞ ꠢꠤꠐ꠆ꠐꠤ ꠅꠇꠟꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“ꠀꠝꠤ ꠔ ꠛꠤꠖꠦꠡꠤ ꠝꠥꠍꠣꠚꠤꠞ ꠅꠁꠀ ꠀꠙꠘꠣꠞꠣꠞ ꠅꠘꠅ ꠞꠁꠀꠞ। ꠝꠦꠢꠦꠞꠛꠣꠘꠤ ꠇꠞꠤ ꠇꠛꠞꠡ꠆ꠕꠣꠘ ꠛꠣꠘꠣꠁꠛꠣꠞ ꠟꠣꠉꠤ ꠀꠝꠣꠞꠦ ꠕꠥꠠꠣ ꠎꠝꠤ ꠖꠦꠃꠇ꠆ꠇꠣ, ꠀꠝꠤ ꠀꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠕꠘꠦ ꠀꠝꠣꠞ ꠝꠥꠞ꠆ꠖꠣꠞꠦ ꠖꠣꠚꠘ ꠇꠞꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","ꠢꠤꠐ꠆ꠐꠤ ꠅꠇꠟꠦ ꠔꠣꠘꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“ꠢꠥꠎꠥꠞ, ꠀꠝꠞꠣꠞ ꠇꠕꠣ ꠢꠥꠘꠃꠇ꠆ꠇꠣ। ꠀꠙꠘꠦ ꠔ ꠀꠝꠞꠣꠞ ꠝꠣꠎꠦ ꠀꠟ꠆ꠟꠣꠞ ꠝꠢꠛ꠆ꠛꠔꠞ ꠛꠥꠎꠥꠞ꠆ꠉ। ꠀꠝꠞꠣꠞ ꠉꠥꠞꠥꠡ꠆ꠕꠣꠘꠞ ꠝꠣꠎꠦ ꠎꠦꠘꠅ ꠙꠍꠘ꠆ꠖ ꠅꠄ, ꠅꠘꠅꠃ ꠀꠙꠘꠣꠞ ꠝꠥꠞ꠆ꠖꠣꠞꠦ ꠖꠣꠚꠘ ꠇꠞꠃꠇ꠆ꠇꠣ। ꠔꠣꠘꠞꠦ ꠖꠣꠚꠘ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠀꠝꠞꠣꠞ ꠇꠦꠃ-ꠃ ꠘꠤꠎꠞ ꠛꠣꠘꠣꠁꠟ ꠇꠄꠛꠞ ꠍꠣꠠꠔꠦ ꠅꠝꠔ ꠇꠞꠔ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","ꠅꠃ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠃꠛꠣꠁꠀ ꠢꠤꠘꠞ ꠢꠤꠐ꠆ꠐꠤ ꠅꠇꠟꠞ ꠍꠣꠝꠘꠦ ꠝꠣꠕꠣ ꠘꠥꠀꠁꠀ ꠁꠎ꠆ꠎꠔ ꠇꠞꠤ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","“ꠀꠝꠣꠞ ꠛꠤꠛꠤꠞꠦ ꠁꠘꠅ ꠖꠣꠚꠘ ꠇꠞꠣꠔ ꠎꠥꠖꠤ ꠀꠙꠘꠣꠞꠣꠞ ꠇꠥꠘꠥ ꠅꠝꠔ ꠘꠣ ꠕꠣꠇꠦ, ꠔꠦ ꠖꠄꠀ ꠇꠞꠤ ꠀꠝꠣꠞ ꠀꠞꠎꠤꠈꠣꠘ ꠢꠥꠘꠃꠇ꠆ꠇꠣ। ꠀꠙꠘꠣꠞꠣ ꠀꠝꠣꠞ ꠅꠁꠀ ꠡꠥꠢꠞꠞ ꠙꠥꠀ ꠁꠚ꠆ꠞꠥꠘꠞꠦ ꠇꠃꠇ꠆ꠇꠣ, ");
INSERT INTO syls_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ꠔꠣꠘ ꠎꠝꠤꠘꠞ ꠢꠦꠡ ꠝꠣꠕꠣꠔ ꠝꠇꠙꠦꠟꠣ ꠎꠦ ꠉꠥꠢꠣ ꠀꠍꠦ, ꠅꠈꠣꠘꠔꠣ ꠎꠦꠘꠥ ꠇꠛꠞꠡ꠆ꠕꠣꠘ ꠛꠣꠘꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠔꠣꠁꠘ ꠙꠥꠞꠣ ꠖꠣꠝ ꠟꠁꠀ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠛꠦꠌꠤꠟꠣꠁꠘ।” ");
INSERT INTO syls_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","ꠀꠞꠅ ꠢꠤꠐ꠆ꠐꠤ ꠅꠇꠟꠞ ꠟꠉꠦ ꠁ ꠡꠝꠄ ꠁꠚ꠆ꠞꠥꠘꠅ ꠢꠘꠅ ꠛꠅꠀꠔ ꠀꠍꠟꠣ। ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠝꠣꠔꠞ ꠎꠥꠀꠙꠦ ꠢꠃ ꠢꠤꠐ꠆ꠐꠤ ꠅꠇꠟꠞ ꠍꠣꠝꠘꠦ ꠁꠚ꠆ꠞꠥꠘꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“ꠘꠣ, ꠘꠣ, ꠀꠙꠘꠦ ꠖꠄꠀ ꠇꠞꠤ ꠀꠝꠣꠞ ꠝꠣꠔꠈꠣꠘ ꠢꠥꠘꠃꠇ꠆ꠇꠣ। ꠀꠝꠤ ꠢꠇꠟꠞ ꠍꠣꠝꠘꠦꠃ ꠁ ꠎꠝꠤ ꠀꠞ ꠉꠥꠢꠣ ꠀꠙꠘꠣꠞꠦ ꠖꠤꠟꠣꠁꠟꠣꠝ, ꠀꠙꠘꠣꠞ ꠝꠥꠞ꠆ꠖꠣꠞꠦ ꠖꠣꠚꠘ ꠇꠞꠤꠟꠣꠁꠘ।” ");
INSERT INTO syls_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","ꠔꠦꠃ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠢꠤꠞꠛꠣꠞ ꠢꠤꠘꠞ ꠢꠇꠟꠞ ꠍꠣꠝꠘꠦ ꠝꠣꠕꠣ ꠘꠥꠀꠁꠀ, ");
INSERT INTO syls_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ꠢꠤ ꠖꠦꠡꠞ ꠢꠇ꠆ꠇꠟꠞꠦ ꠢꠥꠘꠣꠁꠀ ꠁꠚ꠆ꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, “ꠢꠥꠘꠃꠇ꠆ꠇꠣ, ꠎꠝꠤꠈꠣꠘꠞ ꠖꠣꠝ ꠀꠝꠤ ꠖꠤꠟꠣꠁ। ꠀꠙꠘꠦꠅ ꠎꠝꠤꠈꠣꠘꠞ ꠖꠣꠝ ꠘꠦꠃꠇ꠆ꠇꠣꠉꠤ, ꠛꠣꠖꠦ ꠀꠝꠣꠞ ꠝꠥꠞ꠆ꠖꠣꠞꠦ ꠅꠘꠅ ꠖꠣꠚꠘ ꠇꠞꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","ꠁꠚ꠆ꠞꠥꠘꠦ ꠔꠣꠘꠞꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“ꠢꠥꠎꠥꠞ, ꠀꠝꠣꠞ ꠇꠕꠣ ꠢꠥꠘꠃꠇ꠆ꠇꠣ, ꠅꠃ ꠎꠝꠤꠈꠣꠘꠞ ꠖꠣꠝ ꠅꠁꠟꠉꠤ ꠌꠣꠁꠞ-ꠡ ꠔꠟꠣ ꠞꠥꠙꠣ, ꠔꠦ ꠀꠙꠘꠣꠞ-ꠀꠝꠣꠞ ꠟꠣꠉꠤ ꠁꠔꠣ ꠇꠥꠘ꠆ꠔꠣꠃ ꠘꠣꠄ। ꠀꠙꠘꠣꠞ ꠝꠥꠞ꠆ꠖꠣꠞꠦ ꠇꠄꠛꠞ ꠖꠤꠟꠣꠃꠇ꠆ꠇꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","ꠅꠃ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠁꠚ꠆ꠞꠥꠘꠞ ꠇꠕꠣ ꠝꠣꠘꠤꠀ ꠢꠤꠐ꠆ꠐꠤ ꠅꠇꠟꠞ ꠍꠣꠝꠘꠦ ꠔꠣꠁꠘ, ꠁꠚ꠆ꠞꠥꠘꠞ ꠌꠣꠅꠀ ꠖꠣꠝ ꠝꠣꠚꠤꠇ, ꠙꠣꠁꠇꠣꠞꠤ ꠝꠣꠙꠦ ꠌꠣꠁꠞ-ꠡ ꠔꠟꠣ ꠞꠥꠙꠣ ꠔꠣꠘꠞꠦ ꠝꠣꠙꠤꠀ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","ꠅꠃ ꠟꠣꠈꠣꠘ ꠝꠝ꠆ꠞꠤ ꠐꠣꠃꠘꠞ ꠉꠦꠍꠦ ꠝꠇꠙꠦꠟꠣꠔ ꠁꠚ꠆ꠞꠥꠘꠞ ꠎꠦ ꠎꠝꠤꠘ ꠀꠍꠤꠟ ꠢꠃ ꠎꠝꠤꠘ ꠀꠞ ꠢꠘꠞ ꠉꠥꠢꠣ ꠀꠞ ꠎꠝꠤꠘꠞ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠎꠔ ꠉꠣꠍ-ꠉꠣꠍꠣꠟꠤ ꠀꠍꠤꠟ, ");
INSERT INTO syls_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ꠁꠔꠣ ꠢꠇꠟꠔꠣꠃ ꠢꠤꠘꠞ ꠢꠤꠐ꠆ꠐꠤ ꠅꠇꠟ ꠀꠞ ꠐꠣꠃꠘꠞ ꠝꠥꠈꠞ ꠢꠇꠟꠞ ꠍꠣꠝꠘꠦ, ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠝꠣꠟꠤꠇꠣꠘꠣꠄ ꠀꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ꠛꠣꠖꠦ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠞ ꠝꠝ꠆ꠞꠤ ꠐꠣꠃꠘ ꠛꠣ ꠢꠦꠛꠞꠘꠞ ꠝꠇꠙꠦꠟꠣꠞ ꠉꠥꠢꠣꠔ ꠔꠣꠘ ꠛꠤꠛꠤ ꠍꠣꠄꠞꠣꠞꠦ ꠖꠣꠚꠘ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ꠅꠃ ꠟꠣꠈꠣꠘ ꠝꠇꠙꠦꠟꠣꠞ ꠅꠃ ꠉꠥꠢꠣ ꠡꠢ ꠀꠡ꠆ꠔꠣ ꠎꠝꠤꠘꠈꠣꠘ ꠉꠥꠞꠥꠡ꠆ꠕꠣꠘꠞ ꠟꠣꠉꠤ, ꠢꠤꠐ꠆ꠐꠤ ꠅꠇꠟꠞ ꠀꠔ ꠕꠘꠦ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠀꠔꠅ ꠀꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ꠁꠛ꠆ꠞꠣꠢꠤꠝ ꠁ ꠡꠝꠄ ꠈꠥꠛ ꠝꠥꠞꠛ꠆ꠛꠤ ꠀꠞ ꠎꠣꠅꠀꠉꠤꠞ ꠙꠕꠤ ꠅꠁꠉꠦꠍꠂꠘ। ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘꠞꠦ ꠢꠇꠟꠛꠣꠄ ꠕꠘꠦ ꠛꠞꠇꠔ ꠘꠣꠎꠤꠟ ꠇꠞꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","ꠀꠞ ꠔꠣꠘ ꠈꠣꠍ ꠉꠥꠟꠣꠝ, ꠛꠣꠠꠤꠞ ꠙꠥꠞꠣꠘ ꠎꠦ ꠉꠥꠟꠣꠝꠞ ꠃꠙꠞꠦ ꠔꠣꠘ ꠢꠇꠟꠔꠣꠞ ꠜꠣꠞ ꠖꠦꠅꠀ ꠀꠍꠤꠟ ꠔꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠀꠔꠈꠣꠘ ꠀꠝꠣꠞ ꠃꠞꠣꠔꠞ ꠔꠟꠦ ꠢꠣꠞꠣꠅ। ");
INSERT INTO syls_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠀꠍꠝꠣꠘ-ꠎꠝꠤꠘꠞ ꠝꠣꠟꠤꠇ ꠀꠟ꠆ꠟꠣ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠇꠍꠝ ꠇꠞꠣꠁꠀꠞ, ꠀꠝꠤ ꠎꠦ ꠇꠦꠘꠣꠘꠤ ꠅꠇꠟꠞ ꠝꠣꠎꠦ ꠕꠣꠇꠤꠀꠞ, ꠔꠣꠞꠣꠞ ꠇꠥꠘꠥ ꠙꠥꠠꠤꠞꠦ ꠀꠝꠣꠞ ꠙꠥꠀꠞ ꠛꠃ ꠛꠣꠘꠣꠁꠀ ꠔꠥꠝꠤ ꠀꠘꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠖꠦꠡꠅ ꠉꠤꠀ, ꠀꠝꠣꠞ ꠙꠥꠀ ꠁꠍꠢꠣꠇꠞ ꠟꠣꠉꠤ ꠀꠝꠣꠞ ꠈꠦꠡ-ꠇꠥꠐꠥꠝꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠄꠉꠥ ꠇꠁꠘꠣ ꠌꠣꠁꠀ ꠀꠘꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","ꠅꠃ ꠢꠤ ꠉꠥꠟꠣꠝꠦ ꠔꠣꠘꠞꠦ ꠇꠁꠟꠣ, “ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠙꠥꠠꠤꠄ ꠀꠝꠣꠞ ꠟꠉꠦ ꠁ ꠖꠦꠡꠅ ꠀꠁꠔꠦ ꠞꠣꠎꠤ ꠘꠣ ꠅꠁꠘ, ꠔꠣꠁꠟꠦ ꠎꠦ ꠖꠦꠡ ꠍꠣꠠꠤꠀ ꠀꠙꠘꠦ ꠀꠁꠍꠂꠘ, ꠀꠙꠘꠣꠞ ꠙꠥꠀꠞꠦ ꠀꠝꠤ ꠢꠘꠅ ꠟꠁꠀ ꠎꠣꠁꠔꠣꠝ ꠘꠤ?” ");
INSERT INTO syls_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠈꠛꠞꠖꠣꠞ! ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠙꠥꠀꠞꠦ ꠇꠥꠘꠥꠝꠘ꠆ꠔꠦꠃ ꠢꠤꠘꠅ ꠟꠁꠀ ꠎꠣꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","ꠎꠦ ꠀꠍꠝꠣꠘꠤ ꠀꠟ꠆ꠟꠣ ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞꠦ, ꠀꠝꠣꠞ ꠛꠣꠚꠞ ꠛꠣꠠꠤ ꠀꠞ ꠎꠘꠝ ꠝꠣꠐꠤ ꠕꠘꠦ ꠛꠣꠞ ꠇꠞꠤꠀ ꠀꠘꠍꠂꠘ, ꠔꠣꠁꠘ ꠀꠝꠣꠞ ꠟꠉꠦ ꠛꠣꠔ-ꠍꠅꠀꠟ ꠇꠞꠤ ꠇꠍꠝ ꠇꠞꠤꠀ ꠇꠁꠍꠂꠘ, ꠁ ꠖꠦꠡꠈꠣꠘ ꠔꠣꠁꠘ ꠀꠝꠣꠞ ꠅꠀꠞꠤꠡ ꠅꠇꠟꠞꠦ ꠖꠤꠛꠣ। ꠔꠣꠁꠘ ꠔꠥꠝꠣꠞ ꠀꠉꠦꠃ ꠔꠣꠘ ꠚꠤꠞꠤꠡ꠆ꠔꠣꠞꠦ ꠢꠘꠅ ꠙꠣꠑꠣꠁꠛꠣ, ꠎꠣꠔꠦ ꠀꠝꠣꠞ ꠙꠥꠀꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠤ ꠢꠘ ꠕꠘꠦ ꠄꠉꠥ ꠇꠁꠘꠣ ꠀꠘꠔꠣꠄ ꠙꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠙꠥꠠꠤꠄ ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠀꠁꠔꠦ ꠞꠣꠎꠤ ꠘꠣ ꠅꠄ, ꠔꠦ ꠀꠝꠣꠞ ꠁ ꠇꠍꠝ ꠕꠣꠇꠤ ꠔꠥꠝꠤ ꠈꠣꠟꠣꠍ; ꠔꠣ-ꠅ ꠀꠝꠣꠞ ꠙꠥꠀꠞꠦ ꠔꠥꠝꠤ ꠇꠥꠘꠥ ꠟꠣꠈꠣꠘꠃ ꠢꠤꠘꠅ ꠟꠁꠀ ꠎꠣꠁꠅ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","ꠅꠃ ꠢꠤ ꠉꠥꠟꠣꠝꠦ ꠔꠣꠘ ꠝꠥꠘꠤꠛ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠃꠞꠣꠔꠞ ꠔꠟꠦ ꠀꠔ ꠢꠣꠞꠣꠁꠀ ꠅꠃꠟꠣ ꠇꠍꠝ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ꠛꠣꠖꠦ ꠢꠃ ꠉꠥꠟꠣꠝꠦ ꠔꠣꠘ ꠝꠥꠘꠤꠛꠞ ꠃꠐꠞ ꠙꠣꠟ ꠕꠣꠇꠤ ꠖꠡꠐꠣ ꠃꠐ ꠟꠁꠟꠣ। ꠀꠞ ꠝꠥꠘꠤꠛꠞ ꠜꠣꠟꠣ ꠜꠣꠟꠣ ꠎꠤꠘꠤꠡ ꠅꠇꠟ ꠟꠁꠀ, ꠅꠞꠣꠝ-ꠘꠢꠞꠄꠁꠝ ꠖꠦꠡꠞ ꠎꠦꠘꠅ ꠘꠣꠢꠥꠞ ꠕꠣꠇꠔꠣ ꠢꠛꠣꠄꠖꠤ ꠞꠅꠀꠘꠣ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","ꠀꠞ ꠢꠣꠁꠘ꠆ꠎꠣ ꠛꠣꠟꠣ ꠎꠦꠛꠟꠣ ꠛꠦꠐꠤꠘ꠆ꠔꠦ ꠙꠣꠘꠤ ꠀꠘꠣꠔ ꠛꠣꠞ ꠅꠁꠘ, ꠅꠃ ꠡꠝꠄ ꠢꠤ ꠉꠥꠟꠣꠝꠦ ꠐꠣꠃꠘꠞ ꠛꠣꠞꠦ ꠄꠇ ꠇꠥꠀꠞ ꠇꠣꠍꠣꠔ ꠔꠣꠘ ꠃꠐ ꠅꠇꠟꠞꠦ ꠕꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","ꠕꠁꠀ ꠅꠃ ꠖꠥꠀ ꠇꠞꠟꠣ, “ꠅ ꠝꠣꠛꠥꠖ, ꠀꠝꠣꠞ ꠝꠥꠘꠤꠛ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠀꠟ꠆ꠟꠣ, ꠀꠞꠎ ꠇꠞꠤ, ꠀꠁꠎ ꠀꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠇꠣꠝꠤꠀꠛꠤ ꠎꠣꠁꠞ ꠇꠞꠅ, ꠀꠞ ꠀꠝꠣꠞ ꠝꠥꠘꠤꠛ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞꠦ ꠝꠦꠢꠦꠞꠛꠣꠘꠤ ꠇꠞꠅ। ");
INSERT INTO syls_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","ꠖꠦꠈꠅ, ꠁ ꠐꠣꠃꠘꠞ ꠙꠥꠠꠤꠘ꠆ꠔꠦ ꠙꠣꠘꠤ ꠘꠦꠅꠀꠔ ꠀꠁꠞꠣ ꠀꠞ ꠀꠝꠤ ꠁꠘꠅ ꠇꠥꠀꠞ ꠇꠣꠍꠣꠔ ꠃꠛꠣꠁ ꠞꠁꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ꠔꠦ ꠅꠃ ꠙꠥꠠꠤꠘ꠆ꠔꠞ ꠝꠣꠎꠦ ꠀꠝꠤ ꠎꠣꠞꠦ ꠇꠁꠝꠥ, ‘ꠀꠙꠘꠣꠞ ꠈꠂꠟꠣ ꠟꠣꠝꠣꠁꠀ ꠀꠝꠣꠞꠦ ꠕꠥꠠꠣ ꠙꠣꠘꠤ ꠈꠣꠅꠀꠃꠇ꠆ꠇꠣ’, ꠄꠞ ꠎꠥꠀꠙꠦ ꠎꠥꠖꠤ ꠢꠃ ꠙꠥꠠꠤꠄ ꠇꠂꠘ, ‘ꠀꠙꠘꠦ ꠙꠣꠘꠤ ꠈꠣꠃꠇ꠆ꠇꠣ ꠀꠞ ꠀꠙꠘꠣꠞ ꠃꠐ ꠅꠇꠟꠞꠦꠅ ꠀꠝꠤ ꠙꠣꠘꠤ ꠈꠣꠅꠀꠁꠝꠥ’ ꠔꠣꠁꠟꠦ ꠅꠃ ꠙꠥꠠꠤꠃ ꠎꠣꠘꠥ ꠔꠥꠝꠣꠞ ꠉꠥꠟꠣꠝ ꠁꠍꠢꠣꠇꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠣꠞ ꠙꠍꠘ꠆ꠖꠞ ꠙꠥꠠꠤ ꠅꠁꠘ। ꠔꠦꠃ ꠀꠝꠤ ꠛꠥꠎꠝꠥ, ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠝꠥꠘꠤꠛꠞꠦ ꠝꠦꠢꠦꠞꠛꠣꠘꠤ ꠇꠞꠟꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ꠔꠣꠘ ꠖꠥꠀ ꠡꠦꠡ ꠘꠣ ꠅꠁꠔꠦꠃ ꠛꠕꠥꠄꠟꠞ ꠙꠥꠠꠤ ꠞꠦꠛꠦꠇꠣꠄ ꠇꠣꠈꠅ ꠈꠂꠟꠣ ꠟꠁꠀ ꠐꠣꠃꠘ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁꠀ ꠀꠁꠟꠣ। ꠅꠃ ꠛꠕꠥꠄꠟ ꠅꠁꠟꠣ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠜꠣꠁ ꠘꠣꠢꠥꠞꠞ ꠛꠤꠛꠤ ꠝꠤꠟꠇꠣꠞ ꠙꠥꠀ। ");
INSERT INTO syls_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","ꠞꠦꠛꠦꠇꠣ ꠀꠍꠟꠣ ꠈꠥꠛ ꠡꠥꠘ꠆ꠖꠞꠤ, ꠀꠛꠤꠀꠔꠤ, ꠡꠔꠤ ꠘꠣꠞꠤ। ꠔꠣꠁꠘ ꠇꠥꠀ ꠕꠣꠇꠤ ꠈꠂꠟꠣ ꠜꠞꠤꠀ ꠎꠦꠛꠟꠣ ꠃꠑꠤꠀ ꠀꠁꠞꠣ, ");
INSERT INTO syls_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ꠅꠃ ꠡꠝꠄꠃ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠉꠥꠟꠣꠝꠦ ꠖꠃꠠꠣꠁꠀ ꠔꠣꠘ ꠉꠦꠍꠦ ꠉꠤꠀ ꠇꠁꠟꠣ, “ꠖꠄꠀ ꠇꠞꠤ ꠀꠙꠘꠣꠞ ꠈꠂꠟꠣ ꠕꠣꠇꠤ ꠀꠝꠣꠞꠦ ꠕꠥꠠꠣ ꠙꠣꠘꠤ ꠈꠣꠅꠀꠃꠇ꠆ꠇꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","ꠞꠦꠛꠦꠇꠣꠄ ꠇꠁꠟꠣ, “ꠢꠥꠎꠥꠞ, ꠙꠣꠘꠤ ꠈꠣꠃꠇ꠆ꠇꠣ।” ꠅꠃ ꠇꠕꠣ ꠇꠁꠀꠃ ꠔꠣꠁꠘ ꠎꠟꠖꠤ ꠇꠞꠤ ꠈꠂꠟꠣꠐꠣ ꠇꠣꠈꠅ ꠕꠘꠦ ꠀꠔꠅ ꠀꠘꠤꠀ ꠙꠣꠘꠤ ꠈꠣꠁꠔꠦ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","ꠙꠣꠘꠤ ꠈꠣꠅꠀꠁꠛꠣꠞ ꠛꠣꠖꠦ ꠞꠦꠛꠦꠇꠣꠄ ꠔꠣꠘꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠀꠙꠘꠣꠞ ꠃꠐ ꠅꠇꠟꠞꠦꠅ ꠔꠣꠞꠣꠞ ꠙꠤꠀꠍ ꠝꠤꠐꠣꠁꠀ ꠙꠣꠘꠤ ꠈꠣꠅꠀꠁꠝꠥ, ꠔꠣꠞꠣ ꠙꠦꠐ ꠜꠞꠤꠀ ꠙꠣꠘꠤ ꠈꠣꠁꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","ꠇꠁꠀꠃ ꠔꠣꠁꠘ ꠎꠟꠖꠤ ꠇꠞꠤ ꠙꠣꠘꠤꠞ ꠉꠣꠝꠟꠣꠔ ꠈꠂꠟꠣꠞ ꠙꠣꠘꠤ ꠓꠣꠟꠤꠀ ꠢꠤꠞꠛꠣꠞ ꠖꠃꠠꠣꠁꠀ ꠇꠥꠀꠞ ꠉꠦꠍꠦ ꠉꠦꠟꠣ। ꠀꠞ ꠢꠇꠟ ꠃꠐꠞꠦ ꠙꠣꠘꠤ ꠔꠥꠟꠤ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘ ꠁ ꠍꠚꠞ ꠇꠣꠝꠤꠀꠛ ꠇꠞꠍꠂꠘ ꠇꠤ ꠘꠣ ꠁꠐꠣ ꠎꠣꠘꠣꠞ ꠟꠣꠉꠤ ꠢꠤ ꠉꠥꠟꠣꠝꠦ ꠘꠤꠞꠛꠦ ꠞꠦꠛꠦꠇꠣꠞ ꠛꠣꠄ ꠌꠣꠁ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ꠃꠐ ꠅꠇꠟꠦ ꠙꠣꠘꠤ ꠈꠣꠁꠀ ꠢꠣꠞꠟꠦ, ꠔꠣꠁꠘ ꠀꠗꠣ ꠔꠟꠣꠞ ꠄꠇꠐꠣ ꠡꠥꠘꠣꠞ ꠘꠣꠇꠞ ꠘꠕ ꠀꠞ ꠖꠥꠁ ꠀꠔꠅ ꠖꠡ ꠔꠟꠣꠞ ꠖꠥꠁꠐꠣ ꠡꠥꠘꠣꠞ ꠛꠣꠟꠣ ꠞꠦꠛꠦꠇꠣꠞꠦ ꠖꠤꠀ ꠎꠤꠇꠣꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","“ꠀꠙꠘꠣꠞ ꠛꠣꠛꠣꠞ ꠘꠣꠝ ꠇꠤꠔꠣ? ꠀꠙꠘꠦ ꠇꠃꠇ꠆ꠇꠣ ꠌꠣꠁꠘ, ꠀꠙꠘꠣꠞ ꠛꠣꠚꠞ ꠛꠣꠠꠤꠔ ꠀꠝꠞꠣꠞ ꠞꠣꠁꠔ ꠕꠣꠇꠣꠞ ꠎꠣꠉꠣ ꠅꠁꠛ ꠘꠤ?” ");
INSERT INTO syls_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","ꠞꠦꠛꠦꠇꠣꠄ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠛꠣꠛꠣꠞ ꠘꠣꠝ ꠛꠕꠥꠄꠟ। ꠖꠣꠖꠣꠞ ꠘꠣꠝ ꠘꠣꠢꠥꠞ ꠀꠞ ꠖꠣꠖꠤꠞ ꠘꠣꠝ ꠝꠤꠟꠇꠣ। ");
INSERT INTO syls_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","ꠔꠦ ꠀꠙꠘꠣꠞ ꠃꠐꠞ ꠈꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠀꠝꠞꠣꠞ ꠛꠣꠠꠤꠔ ꠛꠃꠔ ꠈꠦꠞ-ꠜꠥꠡꠤ ꠀꠍꠦ ꠀꠞ ꠞꠁꠛꠣꠞ ꠎꠣꠉꠣꠅ ꠀꠍꠦ।” ");
INSERT INTO syls_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ꠅꠃ ꠢꠤ ꠉꠥꠟꠣꠝꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠁꠎꠖꠣ ꠇꠞꠤꠀ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“ꠢꠇ꠆ꠇꠟ ꠙ꠆ꠞꠡꠋꠡꠣ ꠝꠣꠛꠥꠖꠞ, ꠎꠦꠁꠘ ꠀꠝꠣꠞ ꠝꠥꠘꠤꠛ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠀꠟ꠆ꠟꠣ। ꠔꠣꠁꠘ ꠀꠝꠣꠞ ꠝꠣꠟꠤꠇꠞꠦ ꠔꠣꠘ ꠖꠦꠅꠀ ꠅꠀꠖꠣ ꠞꠣꠈꠔꠦ ꠀꠞ ꠁꠝꠣꠘꠖꠣꠞꠤ ꠖꠦꠈꠣꠁꠔꠦ ꠚꠣꠃꠞꠤꠍꠂꠘ ꠘꠣ। ꠔꠣꠁꠘ ꠀꠝꠣꠞꠦꠅ ꠙꠕ ꠌꠤꠘꠣꠁꠀ ꠀꠝꠣꠞ ꠝꠥꠘꠤꠛꠞ ꠇꠥꠐꠝꠞ ꠛꠣꠠꠤꠔ ꠟꠁꠀ ꠀꠁꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","ꠞꠦꠛꠦꠇꠣꠄ ꠖꠃꠠꠣꠁꠀ ꠉꠤꠀ ꠔꠣꠘ ꠝꠣʼꠞ ꠛꠣꠠꠤꠞ ꠢꠇꠟꠞꠦ ꠁꠔꠣ ꠎꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","ꠞꠦꠛꠦꠇꠣꠞ ꠄꠇ ꠜꠣꠁꠞ ꠘꠣꠝ ꠀꠍꠤꠟ ꠟꠣꠛꠘ। ꠅꠃ ꠟꠣꠛꠘꠦ ꠖꠃꠠꠣꠁꠀ ꠇꠥꠀꠞ ꠇꠣꠍꠣꠔ ꠀꠁꠟꠣ ꠄꠘꠞꠦ ꠖꠦꠈꠔꠣ ꠇꠞꠤ। ");
INSERT INTO syls_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","ꠛꠘꠤꠞ ꠀꠔꠞ ꠛꠣꠟꠣ ꠀꠞ ꠘꠣꠇꠞ ꠘꠕ ꠖꠦꠈꠤꠀ, ꠀꠞ ꠢꠤ ꠝꠣꠘꠡꠦ ꠎꠦꠔꠣ ꠇꠁꠍꠦ ꠁꠔꠣ ꠢꠥꠘꠤꠀ, ꠔꠣꠁꠘ ꠀꠁꠀ ꠖꠦꠈꠟꠣ, ꠝꠣꠘꠥꠡꠐꠣ ꠇꠥꠀꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠔꠣꠞ ꠃꠐꠞ ꠉꠦꠍꠦ ꠃꠛꠣꠁ ꠞꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","ꠟꠣꠛꠘꠦ ꠔꠣꠘꠞꠦ ꠇꠁꠟꠣ, “ꠅ ꠝꠣꠛꠥꠖꠞ ꠞꠢꠝꠔꠞ ꠝꠣꠘꠥꠡ, ꠀꠃꠇ꠆ꠇꠣ। ꠛꠣꠞꠦ ꠃꠛꠣꠁ ꠞꠁꠍꠂꠘ ꠇꠦꠘꠦ? ꠀꠝꠤ ꠀꠙꠘꠣꠞꠣꠞ ꠟꠣꠉꠤ ꠊꠞ, ꠀꠞ ꠃꠐꠞ ꠟꠣꠉꠤ ꠎꠣꠉꠣ ꠎꠥꠁꠔ ꠇꠞꠤꠀ ꠀꠁꠍꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ꠅꠃ ꠢꠤ ꠉꠥꠟꠣꠝꠦ ꠔꠣꠞꠣꠞ ꠛꠣꠠꠤꠔ ꠉꠤꠀ ꠃꠐ ꠅꠇꠟꠞ ꠉꠣꠁꠐ ꠟꠣꠝꠣꠁꠔꠦꠃ, ꠟꠣꠛꠘꠦ ꠈꠦꠞ ꠀꠞ ꠜꠥꠡꠤ ꠀꠘꠤꠀ ꠖꠤꠟꠣ। ꠔꠣꠘꠦ ꠀꠞ ꠔꠣꠘ ꠟꠉꠞ ꠢꠇꠟꠞꠦ ꠀꠔ-ꠙꠣꠅ ꠗꠅꠀꠞ ꠙꠣꠘꠤꠅ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","ꠛꠣꠖꠦ ꠔꠣꠘ ꠍꠣꠝꠘꠦ ꠈꠣꠘꠤ ꠖꠦꠅꠀ ꠅꠁꠟ, ꠔꠦꠃ ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠇꠤꠔꠣꠞ ꠟꠣꠉꠤ ꠁꠘꠅ ꠀꠁꠍꠤ, ꠁꠔꠣ ꠘꠣ ꠢꠥꠘꠣꠁꠀ ꠈꠣꠘꠤ ꠈꠣꠁꠔꠣꠝ ꠘꠣꠄ।” ꠟꠣꠛꠘꠦ ꠇꠁꠟꠣ, “ꠔꠦ ꠇꠁꠟꠣꠃꠇ꠆ꠇꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","ꠅꠃ ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠉꠥꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","ꠀꠝꠣꠞ ꠝꠣꠟꠤꠇꠞꠦ ꠝꠣꠛꠥꠖꠦ ꠛꠃꠔ ꠛꠞꠇꠔ ꠘꠣꠎꠤꠟ ꠇꠞꠍꠂꠘ, ꠀꠁꠎ ꠔꠣꠁꠘ ꠛꠃꠔ ꠗꠘꠤ-ꠝꠣꠘꠤ। ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘꠞꠦ ꠛꠃꠔ ꠉꠞꠥ-ꠝꠦꠠꠣ, ꠃꠐ-ꠉꠣꠗꠣ, ꠡꠥꠘꠣ-ꠞꠥꠙꠣ, ꠀꠞ ꠛꠣꠘ꠆ꠖꠤ-ꠉꠥꠟꠣꠝ ꠖꠤꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","ꠔꠣꠘ ꠛꠤꠛꠤ ꠍꠣꠄꠞꠣꠞ ꠝꠥꠞꠛ꠆ꠛꠤ ꠛꠄꠅꠡꠅ ꠝꠥꠘꠤꠛꠞ ꠄꠇꠎꠘ ꠙꠥꠀ ꠅꠁꠍꠂꠘ, ꠀꠞ ꠅꠃ ꠙꠥꠀꠞꠦꠃ ꠔꠣꠁꠘ, ꠔꠣꠘ ꠢꠇꠟꠔꠣ ꠖꠤꠟꠣꠁꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","ꠔꠣꠁꠘ ꠀꠝꠣꠞꠦ ꠇꠍꠝ ꠇꠞꠣꠁꠀ ꠇꠁꠍꠂꠘ ꠎꠦꠘ, ꠔꠣꠁꠘ ꠎꠦ ꠖꠦꠡꠅ ꠛꠡꠔ ꠇꠞꠞꠣ, ꠢꠤ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠞ ꠇꠥꠘꠥ ꠙꠥꠠꠤꠞꠦ ꠎꠣꠔꠦ ꠔꠣꠘ ꠙꠥꠀꠞ ꠛꠃ ꠘꠣ ꠛꠣꠘꠣꠁ। ");
INSERT INTO syls_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ꠄꠞ ꠛꠖꠟꠣ ꠔꠣꠘ ꠛꠣꠚꠞ ꠀꠞ ꠔꠣꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠛꠣꠠꠤꠔ ꠉꠤꠀ ꠔꠣꠘ ꠙꠥꠀꠞ ꠟꠣꠉꠤ ꠄꠇꠎꠘ ꠇꠁꠘꠣ ꠌꠣꠁꠀ ꠘꠦꠁ। ");
INSERT INTO syls_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","ꠅꠃ ꠀꠝꠤ ꠀꠝꠣꠞ ꠝꠥꠘꠤꠛꠞꠦ ꠇꠁꠟꠣꠝ, ‘ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠙꠥꠠꠤ ꠀꠝꠣꠞ ꠟꠉꠦ ꠀꠁꠔꠦ ꠞꠣꠎꠤ ꠘꠣ ꠅꠁꠘ?’ ");
INSERT INTO syls_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","ꠔꠣꠁꠘ ꠇꠁꠟꠣ, ‘ꠝꠣꠛꠥꠖ, ꠎꠣꠘꠞꠦ ꠀꠝꠤ ꠈꠦꠎꠝꠔ ꠇꠞꠤ, ꠔꠣꠁꠘꠃ ꠔꠣꠘ ꠚꠤꠞꠤꠡ꠆ꠔꠣꠞꠦ ꠙꠣꠑꠣꠁ ꠖꠤꠛꠣ, ꠎꠣꠔꠦ ꠔꠥꠝꠣꠞ ꠍꠚꠞ ꠇꠣꠝꠤꠀꠛ ꠅꠄ। ꠀꠞ ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠘꠤꠎꠞ ꠛꠋꠡ ꠀꠞ ꠀꠝꠣꠞ ꠛꠣꠚꠞ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠘꠦ, ꠄꠉꠥ ꠙꠥꠠꠤꠞꠦ ꠀꠝꠣꠞ ꠙꠥꠀꠞ ꠟꠣꠉꠤ ꠌꠣꠁꠀ ꠀꠘꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","ꠔꠣꠞꠣꠞ ꠢꠤꠘꠅ ꠉꠦꠟꠦ ꠎꠥꠖꠤ ꠔꠣꠞꠣ ꠇꠥꠘꠥ ꠙꠥꠠꠤꠞꠦ ꠘꠣ ꠖꠦꠁꠘ, ꠔꠣꠁꠟꠦ ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠁ ꠇꠍꠝ ꠕꠣꠇꠤ ꠈꠣꠟꠣꠍ ꠙꠣꠁꠛꠣꠄ।’ ");
INSERT INTO syls_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“ꠅꠃ ꠀꠁꠎ ꠀꠝꠤ ꠇꠥꠀꠞ ꠉꠦꠍꠦ ꠀꠁꠀ ꠖꠥꠀ ꠇꠞꠟꠣꠝ, ‘ꠅ ꠝꠣꠛꠥꠖ, ꠀꠝꠣꠞ ꠝꠥꠘꠤꠛ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠀꠟ꠆ꠟꠣ, ꠔꠥꠝꠤ ꠎꠥꠖꠤ ꠀꠝꠣꠞ ꠁ ꠍꠚꠞ ꠇꠣꠝꠤꠀꠛ ꠇꠞꠅ ꠔꠣꠁꠟꠦ, ");
INSERT INTO syls_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ꠖꠦꠈꠅ, ꠀꠝꠤ ꠅꠃ ꠜꠞꠣ ꠇꠥꠀꠞ ꠉꠦꠍꠦ ꠃꠛꠣꠁ ꠞꠁꠍꠤ, ꠀꠞ ꠇꠥꠘꠥ ꠙꠥꠠꠤꠄ ꠅꠘꠅ ꠙꠣꠘꠤ ꠘꠦꠅꠀꠔ ꠀꠁꠟꠦ ꠀꠝꠤ ꠇꠁꠝꠥ, ꠈꠂꠟꠣ ꠕꠣꠇꠤ ꠀꠝꠣꠞꠦ ꠕꠥꠠꠣ ꠙꠣꠘꠤ ꠈꠣꠅꠀꠅ। ");
INSERT INTO syls_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ꠀꠞ ꠎꠥꠖꠤ ꠔꠣꠁ ꠇꠄ, ‘ꠔꠥꠝꠤꠅ ꠙꠣꠘꠤ ꠈꠣꠅ ꠀꠞ ꠔꠥꠝꠣꠞ ꠃꠐ ꠅꠇꠟꠞꠦꠅ ꠀꠝꠤ ꠙꠣꠘꠤ ꠔꠥꠟꠤꠀ ꠖꠤꠝꠥ’, ꠔꠣꠁꠟꠦ ꠅꠃ ꠙꠥꠠꠤꠃ ꠎꠣꠘꠥ ꠀꠝꠣꠞ ꠝꠥꠘꠤꠛꠞ ꠙꠥꠀꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠣꠞ ꠙꠍꠘ꠆ꠖ ꠇꠞꠣ ꠙꠥꠠꠤ ꠅꠄ।’ ");
INSERT INTO syls_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“ꠀꠝꠣꠞ ꠖꠥꠀ ꠡꠦꠡ ꠘꠣ ꠅꠁꠔꠦꠃ ꠖꠦꠈꠤ, ꠞꠦꠛꠦꠇꠣꠄ ꠈꠂꠟꠣ ꠇꠣꠈꠅ ꠟꠁꠀ ꠇꠥꠀꠔ ꠀꠁꠞꠣ ꠙꠣꠘꠤ ꠔꠥꠟꠔꠣ। ꠙꠣꠘꠤ ꠔꠥꠟꠣꠞ ꠛꠣꠖꠦ ꠀꠝꠤ ꠇꠁꠟꠣꠝ, ‘ꠖꠄꠀ ꠇꠞꠤꠀ ꠀꠝꠣꠞꠦ ꠕꠥꠠꠣ ꠙꠣꠘꠤ ꠈꠣꠅꠀꠃꠇ꠆ꠇꠣ।’ ");
INSERT INTO syls_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","ꠔꠣꠁꠘ ꠎꠟꠖꠤ ꠇꠞꠤ ꠇꠣꠈꠅ ꠕꠘꠦ ꠈꠂꠟꠣ ꠟꠣꠝꠣꠁꠀ ꠀꠝꠣꠞꠦ ꠇꠁꠟꠣ, ‘ꠅꠃ ꠘꠦꠁꠘ, ꠙꠣꠘꠤ ꠈꠣꠁꠘ। ꠀꠝꠤ ꠀꠙꠘꠣꠞ ꠃꠐ ꠅꠇꠟꠞꠦꠅ ꠙꠣꠘꠤ ꠈꠣꠅꠀꠁꠝꠥ।’ ꠔꠦꠃ ꠀꠝꠤ ꠙꠣꠘꠤ ꠈꠣꠁꠟꠣꠝ, ꠀꠞ ꠔꠣꠁꠘ ꠀꠝꠣꠞ ꠃꠐ ꠅꠇꠟꠞꠦꠅ ꠙꠣꠘꠤ ꠈꠣꠅꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","ꠛꠣꠖꠦ ꠀꠝꠤ ꠔꠣꠘꠦ ꠎꠤꠇꠣꠁꠟꠣꠝ, ‘ꠀꠙꠘꠦ ꠇꠣꠞ ꠙꠥꠠꠤ?’ ꠔꠣꠁꠘ ꠇꠁꠟꠣ, ‘ꠀꠝꠤ ꠛꠕꠥꠄꠟꠞ ꠙꠥꠠꠤ, ꠀꠝꠣꠞ ꠖꠣꠖꠣꠞ ꠘꠣꠝ ꠘꠣꠢꠥꠞ ꠀꠞ ꠖꠣꠖꠤꠞ ꠘꠣꠝ ꠝꠤꠟꠇꠣ।’ ꠅꠃ ꠀꠝꠤ ꠔꠣꠘ ꠘꠣꠇꠅ ꠘꠕ ꠀꠞ ꠀꠔꠅ ꠛꠣꠟꠣ ꠚꠤꠘ꠆ꠖꠣꠁꠀ ꠖꠤꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ꠛꠣꠖꠦ ꠀꠝꠤ ꠝꠣꠛꠥꠖꠞ ꠍꠁꠎꠖꠣ ꠇꠞꠟꠣꠝ। ꠀꠞ ꠎꠦꠁꠘ ꠀꠝꠣꠞ ꠝꠥꠘꠤꠛ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠀꠟ꠆ꠟꠣ, ꠢꠃ ꠝꠣꠛꠥꠖꠞ ꠡꠥꠇꠥꠞ ꠀꠖꠣꠄ ꠇꠞꠟꠣꠝ, ꠔꠣꠁꠘꠃ ꠀꠝꠣꠞꠦ ꠑꠤꠇ ꠙꠕꠦ ꠌꠣꠟꠣꠁꠀ ꠀꠘꠍꠂꠘ ꠎꠣꠔꠦ ꠀꠝꠤ ꠀꠝꠣꠞ ꠝꠥꠘꠤꠛꠞ ꠜꠣꠔꠤꠎꠤꠞꠦ, ꠔꠣꠘ ꠙꠥꠀꠞ ꠟꠣꠉꠤ ꠔꠥꠇꠣꠁꠀ ꠙꠣꠁ। ");
INSERT INTO syls_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ꠔꠦꠃ ꠅꠈꠘ ꠀꠙꠘꠣꠞꠣ ꠀꠝꠣꠞ ꠝꠥꠘꠤꠛꠞ ꠛꠣꠄ ꠖꠞꠖ ꠀꠞ ꠁꠘꠍꠣꠚ ꠇꠞꠛꠣ ꠘꠤ, ꠇꠃꠇ꠆ꠇꠣ। ꠎꠥꠖꠤ ꠘꠣ ꠇꠞꠂꠘ ꠔꠣ-ꠅ ꠇꠃꠇ꠆ꠇꠣ, ꠎꠣꠔꠦ ꠀꠝꠤ ꠒꠣꠁꠘꠦ-ꠛꠣꠃꠄ ꠎꠣꠁꠔꠣꠝ ꠙꠣꠞꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","ꠅꠃ ꠟꠣꠛꠘ ꠀꠞ ꠛꠕꠥꠄꠟꠦ ꠇꠁꠟꠣ, “ꠊꠐꠘꠣ ꠔ ꠝꠣꠛꠥꠖ ꠕꠣꠇꠤꠃ ꠅꠁꠍꠦ। ꠅꠈꠘ ꠀꠝꠞꠣꠞ ꠜꠣꠟꠣ-ꠛꠥꠞꠣ ꠝꠣꠔꠣꠞ ꠇꠥꠘ꠆ꠔꠣꠃ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","ꠅꠃ ꠖꠦꠈꠃꠇ꠆ꠇꠣ, ꠞꠦꠛꠦꠇꠣ ꠔ ꠅꠘꠅ ꠀꠍꠦ, ꠔꠦ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠔ ꠀꠙꠘꠣꠞ ꠝꠥꠘꠤꠛꠞ ꠙꠥꠀꠞ ꠛꠃ ꠛꠣꠘꠣꠁꠛꠣꠞ ꠟꠣꠉꠤ ꠄꠞꠦ ꠟꠁꠀ ꠎꠣꠁꠔꠣ ꠙꠣꠞꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ꠁ ꠝꠣꠔ ꠢꠥꠘꠤꠀ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠉꠥꠟꠣꠝꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠁꠎꠖꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","ꠄꠞꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠡꠥꠘꠣ-ꠞꠥꠙꠣꠞ ꠉꠄꠘꠣ-ꠉꠣꠐꠤ ꠀꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠛꠣꠞ ꠇꠞꠤꠀ ꠞꠦꠛꠦꠇꠣꠞꠦ ꠖꠤꠟꠣ, ꠄꠞ ꠟꠉꠦ ꠞꠦꠛꠦꠇꠣꠞ ꠝꠣ-ꠜꠣꠁꠞꠦꠅ ꠛꠃꠔ ꠖꠣꠝꠤ ꠖꠣꠝꠤ ꠃꠙꠢꠣꠞ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠀꠞ ꠔꠣꠘ ꠟꠉꠞ ꠢꠇꠟꠦ ꠈꠣꠅꠀ-ꠖꠣꠅꠀ ꠡꠦꠡ ꠇꠞꠤꠀ ꠢꠈꠣꠘꠅꠃ ꠞꠣꠁꠔ ꠇꠣꠐꠣꠁꠟꠣ। ꠛꠤꠀꠘꠦ ꠊꠥꠝ ꠕꠣꠇꠤ ꠃꠑꠤꠀ ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠝꠥꠘꠤꠛꠞ ꠉꠦꠍꠦ ꠎꠣꠅꠀꠞ ꠟꠣꠉꠤ ꠀꠝꠣꠞꠦ ꠛꠤꠖꠣꠄ ꠖꠤꠟꠣꠃꠇ꠆ꠇꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","ꠔꠦꠃ ꠞꠦꠛꠦꠇꠣꠞ ꠝꠣ ꠀꠞ ꠜꠣꠁꠄ ꠇꠁꠟꠣ, “ꠙꠥꠠꠤꠉꠥ ꠀꠞꠅ ꠖꠡꠈꠣꠘ ꠖꠤꠘ ꠀꠝꠞꠣꠞ ꠉꠦꠍꠦ ꠕꠣꠇꠃꠇ, ꠛꠣꠖꠦ ꠎꠣꠁꠛꠘꠦ।” ");
INSERT INTO syls_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","ꠅꠃ ꠢꠤ ꠉꠥꠟꠣꠝꠦ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠦ ꠎꠦꠛꠟꠣ ꠀꠝꠣꠞ ꠁ ꠍꠚꠞ ꠇꠣꠝꠤꠀꠛ ꠇꠞꠍꠂꠘ, ꠔꠣꠁꠟꠦ ꠀꠝꠣꠞꠦ ꠖꠦꠞꠤ ꠘꠣ ꠇꠞꠣꠁꠀ ꠛꠤꠖꠣꠄ ꠖꠤꠟꠣꠃꠇ꠆ꠇꠣ, ꠀꠝꠣꠞ ꠝꠥꠘꠤꠛꠞ ꠉꠦꠍꠦ ꠎꠣꠁꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","ꠄꠞꠣ ꠇꠁꠟꠣ, “ꠀꠝꠞꠣ ꠔꠣꠁꠟꠦ ꠙꠥꠠꠤꠞꠦ ꠍꠣꠝꠘꠦ ꠀꠘꠤꠀ ꠎꠤꠇꠣꠁꠟꠣꠁ।” ");
INSERT INTO syls_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","ꠀꠞ ꠞꠦꠛꠦꠇꠣꠞꠦ ꠒꠣꠇꠤꠀ ꠀꠘꠤꠀ ꠎꠤꠇꠣꠁꠟꠣ, “ꠔꠥꠝꠤ ꠇꠤꠔꠣ ꠔꠣꠘ ꠟꠉꠦ ꠎꠣꠁꠛꠣꠄ ꠘꠤ ꠉ?” ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠀꠁꠌ꠆ꠍꠣ, ꠎꠣꠁꠝꠥꠘꠦ।” ");
INSERT INTO syls_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","ꠅꠃ ꠔꠣꠞꠣ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠉꠥꠟꠣꠝ ꠀꠞ ꠔꠣꠘ ꠟꠉꠞ ꠝꠣꠘꠡꠞ ꠟꠉꠦ ꠔꠣꠞꠣꠞ ꠛꠁꠘ ꠀꠞ ꠔꠣꠘ ꠛꠣꠘ꠆ꠖꠤ ꠛꠦꠐꠤꠞꠦ ꠛꠤꠖꠣꠄ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","ꠀꠞ ꠞꠦꠛꠦꠇꠣꠞꠦ ꠖꠥꠀ ꠇꠞꠤꠀ ꠇꠁꠟꠣ, “ꠛꠁꠘ ꠉ, ꠔꠥꠝꠤ ꠟꠣꠈ ꠟꠣꠈ ꠀꠅꠟꠣꠖꠞ ꠝꠣ ꠅꠅ। ꠔꠥꠝꠣꠞ ꠀꠅꠟꠣꠖꠦ ꠖꠥꠡꠝꠘ ꠅꠇꠟꠞꠦ ꠊꠣꠁꠟ ꠇꠞꠃꠇ।” ");
INSERT INTO syls_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","ꠞꠦꠛꠦꠇꠣ ꠀꠞ ꠔꠣꠘ ꠛꠣꠘ꠆ꠖꠤ ꠅꠇꠟꠦ ꠔꠂꠀꠞ ꠅꠁꠀ ꠃꠐꠞ ꠃꠙꠞꠦ ꠌꠠꠤꠀ, ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠉꠥꠟꠣꠝꠞ ꠈꠞꠦ ꠅꠁꠀ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣ। ꠅꠃ ꠟꠣꠈꠣꠘ ꠢꠃ ꠉꠥꠟꠣꠝꠦ ꠞꠦꠛꠦꠇꠣꠞꠦ ꠟꠁꠀ ꠛꠣꠞ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ꠁꠍꠢꠣꠇ ꠁ ꠡꠝꠄ ꠘꠦꠉꠦꠜꠅ ꠕꠣꠇꠔꠣ। ꠔꠣꠁꠘ ꠛꠦꠞ-ꠟꠢꠄ-ꠞꠥꠁ ꠘꠣꠝꠞ ꠎꠣꠉꠣ ꠕꠘꠦ ꠚꠤꠞꠔ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ꠄꠇꠖꠤꠘ ꠛꠤꠀꠟꠤ ꠛꠣꠟꠣ ꠔꠣꠁꠘ ꠛꠘ꠆ꠖꠦꠖꠤ ꠀꠐꠣꠔ ꠛꠣꠞ ꠅꠁꠟꠣ। ꠀꠈꠔꠣꠃ ꠌꠃꠈ ꠔꠥꠟꠤꠀ ꠌꠣꠁꠀ ꠖꠦꠈꠟꠣ, ꠇꠄꠐꠣ ꠃꠐ ꠀꠁꠞꠣ। ");
INSERT INTO syls_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","ꠞꠦꠛꠦꠇꠣꠄꠅ ꠖꠥꠞꠁ ꠕꠘꠦ ꠁꠍꠢꠣꠇꠞꠦ ꠖꠦꠈꠤꠀꠃ ꠃꠐꠞ ꠃꠙꠞ ꠕꠣꠇꠤ ꠟꠣꠝꠤ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ꠀꠞ ꠢꠃ ꠉꠥꠟꠣꠝꠞꠦ ꠎꠤꠇꠣꠁꠟꠣ, “ꠅꠃ ꠎꠦꠁꠘ ꠛꠘ꠆ꠖꠞ ꠝꠣꠎꠦꠖꠤ ꠀꠝꠞꠣꠞ ꠛꠣꠄ ꠀꠁꠞꠣ, ꠄꠁꠘ ꠇꠦ?” ꠉꠥꠟꠣꠝꠦ ꠇꠁꠟꠣ, “ꠄꠁꠘ ꠔ ꠀꠝꠣꠞ ꠝꠥꠘꠤꠛ।” ꠅꠃ ꠞꠦꠛꠦꠇꠣꠄ ꠛꠥꠞꠇꠣꠞ ꠙꠞ꠆ꠖꠣ ꠟꠣꠝꠣꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ꠀꠞ ꠢꠤ ꠉꠥꠟꠣꠝꠦ ꠎꠦꠔꠣ ꠎꠦꠔꠣ ꠇꠞꠤꠀ ꠀꠁꠍꠂꠘ, ꠢꠇꠟꠔꠣ ꠁꠍꠢꠣꠇꠞꠦ ꠎꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ꠁꠍꠢꠣꠇꠦ ꠔꠣꠘ ꠝꠣ ꠛꠤꠛꠤ ꠍꠣꠄꠞꠣꠞ ꠔꠣꠝ꠆ꠛꠥꠔ ꠞꠦꠛꠦꠇꠣꠞꠦ ꠟꠁꠀ ꠉꠤꠀ ꠔꠣꠘꠦ ꠛꠤꠀ ꠇꠞꠟꠣ। ꠀꠞ ꠔꠣꠘꠞꠦ ꠝꠣꠄꠀ ꠇꠞꠟꠣ। ꠔꠣꠘ ꠝꠣʼꠞ ꠝꠃꠔꠞ ꠛꠣꠖꠦ, ꠞꠦꠛꠦꠇꠣꠞ ꠝꠣꠄꠀꠄꠃ ꠔꠣꠘ ꠎꠣꠘꠅ ꠡꠣꠘ꠆ꠔꠤ ꠙꠣꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠇꠣꠔꠥꠞꠣ ꠘꠣꠝꠞ ꠀꠞꠅ ꠄꠇꠎꠘ ꠛꠦꠐꠤꠞꠦ ꠛꠤꠀ ꠇꠞꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","ꠔꠣꠘ ꠙꠦꠐꠅ ꠎꠤꠝ꠆ꠞꠘ, ꠎꠇꠡꠘ, ꠝꠖꠣꠘ, ꠝꠣꠖꠤꠀꠘ, ꠎꠤꠡꠛꠇ ꠀꠞ ꠡꠥꠢꠣꠞ ꠎꠘꠝ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","ꠡꠣꠛꠣ ꠀꠞ ꠖꠖꠣꠘ ꠅꠁꠟꠣ ꠎꠇꠡꠘꠞ ꠀꠅꠟꠣꠖ। ꠀꠡꠥꠞꠤ, ꠟꠐꠥꠡꠤ, ꠟꠤꠃꠝ꠆ꠝꠤ ꠅꠇꠟ ꠅꠁꠟꠣ ꠖꠖꠣꠘꠞ ꠀꠅꠟꠣꠖ। ");
INSERT INTO syls_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","ꠝꠣꠖꠤꠀꠘꠞ ꠀꠅꠟꠣꠖ ꠅꠁꠟꠣ ꠅꠂꠚꠣ, ꠄꠚꠞ, ꠢꠘꠥꠇ, ꠅꠛꠤꠖ ꠀꠞ ꠁꠟꠖꠣꠄꠀ। ꠄꠞꠣ ꠢꠇꠟꠃ ꠇꠣꠔꠥꠞꠣꠞ ꠀꠅꠟꠣꠖ। ");
INSERT INTO syls_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠔꠣꠘ ꠢꠇꠟꠔꠣ ꠁꠍꠢꠣꠇꠞꠦ ꠖꠤꠟꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ꠅꠁꠟꠦ ꠔꠣꠁꠘ ꠎꠤꠘ꠆ꠖꠣ ꠕꠣꠇꠔꠦꠃ, ꠔꠣꠘ ꠢꠦꠡꠞ ꠛꠤꠀꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠞꠦꠅ ꠀꠟꠉꠣ ꠀꠟꠉꠣ ꠖꠣꠘ ꠇꠞꠤꠀ, ꠄꠞꠣꠞꠦ ꠁꠍꠢꠣꠇꠞ ꠟꠉꠦ ꠘꠣ ꠞꠣꠈꠤꠀ ꠙꠥꠛꠦꠖꠤ, ꠙꠥꠛꠞ ꠖꠦꠡꠅ ꠙꠣꠑꠣꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","ꠁꠛ꠆ꠞꠣꠢꠤꠝ ꠄꠇ-ꠡ ꠙꠌꠔ꠆ꠔꠁꠞ ꠛꠞꠍ ꠛꠣꠌꠤꠟꠣ, ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠘꠦ ꠅꠔꠖꠤꠘꠞ ꠢꠣꠄꠀꠔꠤ ꠖꠤꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","ꠔꠣꠁꠘ ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠁꠀ ꠙꠥꠞꠣꠙꠥꠞ ꠛꠥꠠꠣ ꠛꠄꠅꠡꠅ ꠁꠘ꠆ꠔꠦꠇꠣꠟ ꠇꠞꠟꠣ, ꠀꠞ ꠔꠣꠘ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠉꠦꠍꠦ ꠉꠤꠀ ꠀꠎꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","ꠢꠦꠡꠦ ꠔꠣꠘ ꠙꠥꠀ ꠁꠍꠝꠣꠁꠟ ꠀꠞ ꠁꠍꠢꠣꠇꠦ ꠝꠝ꠆ꠞꠤ ꠐꠣꠃꠘꠞ ꠙꠥꠛꠦꠖꠤ, ꠢꠤꠐ꠆ꠐꠤ ꠡꠥꠢꠞꠞ ꠙꠥꠀ ꠁꠚ꠆ꠞꠥꠘꠞ ꠎꠝꠤꠞ ꠝꠇꠙꠦꠟꠣ-ꠉꠥꠢꠣꠔ, ꠔꠣꠘꠞꠦ ꠖꠣꠚꠘ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ꠁ ꠎꠝꠤꠈꠣꠘ ꠔꠣꠁꠘ ꠢꠤꠐ꠆ꠐꠤ ꠅꠇꠟꠞ ꠉꠦꠍ ꠕꠘꠦ ꠟꠁꠍꠟꠣ। ꠅꠘꠅꠃ ꠔꠣꠘ ꠛꠤꠛꠤ ꠍꠣꠄꠞꠣꠞꠦ ꠀꠞ ꠔꠣꠘꠦ ꠖꠣꠚꠘ ꠇꠞꠣ ꠅꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠝꠃꠔꠞ ꠛꠣꠖꠦ ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠘ ꠙꠥꠀ ꠁꠍꠢꠣꠇꠞꠦ ꠛꠞꠇꠔ ꠘꠣꠎꠤꠟ ꠇꠞꠟꠣ। ꠔꠣꠁꠘ ꠛꠦꠞ-ꠟꠢꠄ-ꠞꠥꠁꠞ ꠉꠦꠍꠦ ꠞꠁꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","ꠅꠃ ꠅꠁꠟ ꠁꠍꠝꠣꠁꠟꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠛꠄꠀꠘ। ꠛꠤꠛꠤ ꠍꠣꠄꠞꠣꠞ ꠛꠣꠘ꠆ꠖꠤ ꠝꠤꠡꠞꠤ ꠢꠣꠎꠦꠞꠣꠞ ꠙꠦꠐꠅ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠙꠥꠀ ꠁꠍꠝꠣꠁꠟꠞ ꠎꠘꠝ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ꠅꠃ ꠅꠁꠟ ꠁꠍꠝꠣꠁꠟꠞ ꠀꠅꠟꠣꠖꠞ ꠘꠣꠝ ꠀꠞ ꠉꠥꠡ꠆ꠐꠤꠞ ꠛꠄꠀꠘ। ꠔꠣꠘ ꠛꠠ ꠙꠥꠀꠞ ꠘꠣꠝ ꠘꠣꠛꠣꠃꠔ, ꠛꠣꠖꠦ ꠇꠣꠄꠖꠣꠞ, ꠅꠖꠛꠦꠟ, ꠝꠤꠛꠍꠝ, ");
INSERT INTO syls_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ꠝꠤꠡꠝꠣ, ꠖꠥꠝꠣ, ꠝꠣꠍꠣ, ");
INSERT INTO syls_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ꠢꠖꠖ, ꠔꠦꠝꠣ, ꠎꠤꠐꠥꠞ, ꠘꠣꠚꠤꠡ ꠀꠞ ꠇꠦꠖꠝꠣ। ");
INSERT INTO syls_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ꠁꠍꠝꠣꠁꠟꠞ ꠅꠃ ꠛꠣꠞꠅꠎꠘ ꠙꠥꠀ ꠀꠍꠟꠣ ꠛꠣꠞꠅ ꠉꠥꠡ꠆ꠐꠤꠞ ꠡꠞ꠆ꠖꠣꠞ। ꠔꠣꠞꠣꠞ ꠘꠣꠝꠞ ꠟꠣꠈꠣꠘ ꠢꠤ ꠉꠣꠃ ꠀꠞ ꠔꠣꠝ꠆ꠛꠥ ꠛꠤꠍꠣꠁꠟ ꠎꠣꠉꠣꠞꠅ ꠅꠃ ꠘꠣꠝ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ꠁꠍꠝꠣꠁꠟꠞ ꠢꠣꠄꠀꠔ ꠄꠇ-ꠡ ꠡꠣꠠꠔꠤꠡ ꠛꠞꠍ ꠀꠍꠤꠟ, ꠢꠦꠡꠦ ꠔꠣꠁꠘ ꠝꠣꠞꠣ ꠉꠦꠟꠣ ꠀꠞ ꠔꠣꠘ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠉꠦꠍꠦ ꠉꠦꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","ꠢꠛꠤꠟꠣ ꠕꠘꠦ ꠀꠡꠤꠞꠤꠀꠞ ꠛꠣꠄ ꠝꠤꠡꠞꠞ ꠍꠣꠝꠘꠞ ꠡꠥꠞ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠔꠣꠘ ꠀꠅꠟꠣꠖ ꠅꠇꠟ ꠞꠁꠔꠣ। ꠁꠍꠝꠣꠁꠟꠦ ꠔꠣꠘ ꠢꠇꠟ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞ ꠉꠣꠟꠣꠛꠣꠄ ꠞꠅꠀꠞ ꠎꠣꠉꠣ ꠙꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","ꠅꠃ ꠅꠁꠟ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠙꠥꠀ ꠁꠍꠢꠣꠇꠞ ꠈꠣꠘ꠆ꠖꠣꠘ-ꠘꠣꠝꠣ। ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠊꠞꠅ ꠁꠍꠢꠣꠇꠞ ꠎꠘꠝ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ꠁꠍꠢꠣꠇꠦ ꠌꠣꠟ꠆ꠟꠤꠡ ꠛꠞꠍ ꠛꠄꠅꠡꠅ ꠔꠣꠘ ꠝꠣꠝꠥꠞ ꠊꠞꠞ ꠛꠁꠘ ꠞꠦꠛꠦꠇꠣꠞꠦ ꠀꠘꠣꠁꠀ ꠛꠤꠀ ꠇꠞꠟꠣ। ꠞꠦꠛꠦꠇꠣ ꠅꠁꠟꠣ ꠙꠖ꠆ꠖꠘ-ꠁꠞꠣꠝ ꠖꠦꠡꠞ ꠅꠞꠣꠝꠤ ꠛꠕꠥꠄꠟꠞ ꠙꠥꠠꠤ, ꠅꠞꠣꠝꠤ ꠟꠣꠛꠘꠞ ꠛꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ꠔꠣꠘ ꠛꠃ ꠘꠤꠀꠅꠟꠣꠖꠤ ꠀꠍꠟꠣ ꠉꠔꠤꠇꠦ, ꠁꠍꠢꠣꠇꠦ ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍꠦ ꠖꠥꠀ ꠇꠞꠟꠣ। ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘ ꠖꠥꠀ ꠇꠛꠥꠟ ꠇꠞꠟꠣ, ꠀꠞ ꠞꠦꠛꠦꠇꠣꠞ ꠙꠦꠐꠅ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠀꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","ꠛꠣꠖꠦ ꠙꠦꠐꠞ ꠜꠤꠔꠞꠦ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠄ ꠟꠠꠣ-ꠌꠠꠣ ꠇꠞꠣꠔ ꠟꠣꠉꠟꠣ। ꠅꠃ ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠙꠦꠐꠅ ꠁꠟꠣ ꠟꠣꠉꠦꠞ ꠇꠦꠘꠦ?” ꠇꠣꠞꠘ ꠎꠣꠘꠣꠞ ꠟꠣꠉꠤ ꠔꠣꠁꠘ ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍꠦ ꠖꠥꠀ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠙꠦꠐꠅ ꠖꠥꠁꠐꠣ ꠎꠣꠔꠤ ꠀꠍꠦ, ꠙꠦꠐꠅ ꠕꠘꠦꠃ ꠔꠣꠞꠣ ꠖꠥꠁ ꠛꠋꠡ ꠅꠁꠀ ꠙꠄꠖꠣ ꠅꠁꠛꠣ। ꠄꠇ ꠛꠋꠡ ꠕꠘꠦ ꠀꠞꠇ ꠛꠋꠡ ꠡꠇ꠆ꠔꠤꠀꠟꠣ ꠅꠁꠛ, ꠀꠞ ꠛꠠꠉꠥꠄ ꠢꠥꠞꠥꠉꠥꠞ ꠈꠦꠎꠝꠔ ꠇꠞꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠙꠄꠖꠣꠞ ꠛꠣꠟꠣ ꠖꠦꠈꠂꠘ, ꠢꠣꠍꠣꠃ ꠔꠣꠘ ꠙꠦꠐꠅ ꠎꠥꠠꠞ ꠙꠥꠀ। ");
INSERT INTO syls_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","ꠙꠄꠟꠣ ꠎꠣꠞ ꠎꠘꠝ ꠅꠁꠟ ꠢꠦ ꠟꠣꠟ ꠞꠋꠉꠞ ꠀꠞ ꠔꠣꠞ ꠡꠞꠤꠟꠅ ꠙꠡꠝꠤ ꠇꠣꠙꠠꠞ ꠟꠣꠈꠣꠘ ꠞꠥꠝꠣꠄ ꠜꠞꠣ। ꠔꠣꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠁꠡ ꠝꠣꠘꠤ, ꠞꠥꠝꠣꠀꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ꠛꠣꠖꠦ ꠁꠡʼꠞ ꠙꠣꠅꠞ ꠝꠥꠞꠣꠔ ꠗꠞꠤ ꠔꠣꠞ ꠜꠣꠁꠞ ꠎꠘꠝ ꠅꠁꠟ, ꠄꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠁꠀꠇꠥꠛ ꠝꠣꠘꠤ, ꠙꠣꠅꠔ ꠗꠞꠞꠣ। ꠁꠍꠢꠣꠇꠞ ꠡꠣꠁꠐ ꠛꠞꠍ ꠛꠄꠅꠡꠅ ꠄꠞꠣ ꠎꠥꠠꠦ ꠙꠄꠖꠣ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","ꠅꠃ ꠙꠥꠀꠂꠘ ꠛꠠ ꠅꠀꠞ ꠛꠣꠖꠦ ꠁꠡ ꠈꠥꠛ ꠜꠣꠟꠣ ꠡꠤꠇꠣꠞꠤ ꠀꠞ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠙꠣꠇꠣꠅꠞꠣ ꠅꠁꠟꠣ, ꠅꠁꠟꠦ ꠁꠀꠇꠥꠛ ꠀꠍꠟꠣ ꠘꠤꠞꠣꠁ-ꠎꠤꠞꠣꠁ, ꠔꠣꠁꠘ ꠔꠣꠝ꠆ꠛꠥꠔ ꠕꠣꠇꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ꠡꠤꠇꠣꠞꠞ ꠉꠥꠡ꠆ꠔ ꠝꠎꠣ ꠟꠣꠉꠔ ꠇꠞꠤ ꠁꠍꠢꠣꠇꠦ ꠁꠡʼꠞꠦ ꠝꠣꠄꠀ ꠇꠞꠔꠣ, ꠀꠞ ꠞꠦꠛꠦꠇꠣꠄ ꠁꠀꠇꠥꠛꠞꠦ ꠝꠣꠄꠀ ꠇꠞꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ꠄꠇꠖꠤꠘ ꠁꠀꠇꠥꠛꠦ ꠒꠣꠁꠟ ꠞꠣꠘ꠆ꠖꠤꠍꠂꠘ, ꠅꠃ ꠡꠝꠄ ꠔꠣꠘ ꠛꠠ ꠜꠣꠁ ꠁꠡ ꠝꠞꠥꠜꠥꠝꠤ ꠕꠣꠇꠤ ꠙꠦꠐꠞ ꠜꠥꠇꠦ ꠈꠥꠛ ꠇꠣꠔꠞ ꠅꠁꠀ ꠀꠁꠟꠣ, ꠀꠁꠀ ꠢꠥꠞꠥ ꠜꠣꠁ ꠁꠀꠇꠥꠛꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","“ꠜꠣꠁꠞꠦ, ꠀꠝꠣꠞ ꠈꠥꠛ ꠜꠥꠇ ꠟꠣꠉꠍꠦ। ꠔꠦ ꠅꠃ ꠞꠋꠉꠤꠟ, ꠞꠋꠉꠤꠟ ꠅꠔꠣ ꠀꠝꠣꠞꠦ ꠙꠦꠐ ꠜꠞꠤ ꠈꠣꠁꠔꠦ ꠖꠦ।” ꠅꠃ ꠇꠕꠣꠞ ꠟꠣꠉꠤ ꠔꠣꠘ ꠌꠤꠠ ꠟꠣꠉꠟ ꠁꠖꠥꠝ ꠝꠣꠘꠤ, ꠞꠋꠉꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","ꠁꠀꠇꠥꠛꠦ ꠇꠁꠟꠣ, “ꠔꠣꠁꠟꠦ ꠛꠠ ꠜꠣꠁ ꠅꠀꠞ ꠝꠣꠟꠤꠇꠣꠘꠣ, ꠔꠥꠝꠤ ꠀꠁꠎ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠛꠦꠌꠤꠟꠣꠅ।” ");
INSERT INTO syls_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","ꠁꠡꠦ ꠇꠁꠟꠣ, “ꠖꠦꠈꠅ, ꠀꠝꠣꠞ ꠎꠣꠘ ꠛꠣꠞ ꠅꠁꠎꠣꠞ, ꠀꠞ ꠛꠠ ꠜꠣꠁꠞ ꠝꠣꠟꠤꠇꠣꠘꠣꠖꠤ ꠀꠞ ꠇꠤꠔꠣ ꠇꠞꠔꠣꠝ?” ");
INSERT INTO syls_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","ꠁꠀꠇꠥꠛꠦ ꠇꠁꠟꠣ, “ꠀꠉꠦ ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠇꠍꠝ ꠇꠞꠅ।” ꠅꠃ ꠁꠡꠦ ꠇꠍꠝ ꠇꠞꠤꠀ ꠛꠠ ꠜꠣꠁ ꠅꠀꠞ ꠝꠣꠟꠤꠇꠣꠘꠣ ꠁꠀꠇꠥꠛꠞ ꠉꠦꠍꠦ ꠛꠦꠌꠤꠟꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","ꠛꠣꠖꠦ ꠁꠀꠇꠥꠛꠦ ꠁꠡʼꠞꠦ ꠒꠣꠁꠟ ꠀꠞ ꠞꠥꠐꠤ ꠈꠣꠁꠔꠦ ꠖꠤꠟꠣ। ꠈꠣꠅꠀ-ꠖꠣꠅꠀ ꠇꠞꠤꠀ ꠔꠣꠁꠘ ꠃꠑꠤꠀ ꠉꠦꠟꠣꠉꠤ। ꠅꠃ ꠟꠣꠈꠣꠘ ꠁꠡꠦ ꠛꠠ ꠙꠥꠀ ꠅꠀꠞ ꠇꠥꠘꠥ ꠖꠣꠝꠃ ꠞꠣꠈꠟꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠎꠝꠣꠘꠣꠞ ꠟꠣꠈꠣꠘ ꠁꠚꠤꠞꠣꠅ ꠖꠦꠡꠅ ꠢꠤꠞꠛꠣꠞ ꠄꠇ ꠘꠤꠖꠣꠘ ꠖꠦꠈꠣ ꠖꠤꠟ। ꠔꠦꠃ ꠁꠍꠢꠣꠇ ꠉꠦꠞꠣꠞ ꠐꠣꠃꠘꠅ ꠚꠤꠟꠤꠡ꠆ꠔꠤꠘꠤ ꠅꠇꠟꠞ ꠛꠣꠖꠡꠣ ꠀꠛꠤꠝꠣꠟꠤꠇꠞ ꠉꠦꠍꠦ ꠉꠦꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠁꠍꠢꠣꠇꠞꠦ ꠖꠤꠖꠣꠞ ꠖꠤꠀ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠝꠤꠡꠞꠅ ꠟꠣꠝꠤꠀ ꠎꠣꠁꠅ ꠘꠣ। ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠎꠦ ꠖꠦꠡꠞ ꠇꠕꠣ ꠇꠁꠝꠥ, ꠅꠘꠅꠃ ꠕꠣꠇꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","ꠅꠃ ꠖꠦꠡꠅ ꠔꠥꠝꠤ ꠝꠥꠍꠣꠚꠤꠞ ꠅꠁꠀ ꠞꠅ। ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠞꠁꠀ, ꠔꠥꠝꠣꠞꠦ ꠛꠞꠇꠔ ꠘꠣꠎꠤꠟ ꠇꠞꠝꠥ। ꠁ ꠖꠦꠡ ꠅꠇꠟ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠀꠞ ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡ ꠅꠇꠟꠞꠦ ꠖꠤꠝꠥ। ꠀꠞ ꠔꠥꠝꠣꠞ ꠛꠣꠚ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠉꠦꠍꠦ ꠀꠝꠤ ꠎꠦ ꠇꠍꠝ ꠇꠞꠍꠟꠣꠝ, ꠅꠇꠐꠣ ꠙꠥꠞꠣ ꠇꠞꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡ ꠅꠇꠟꠞꠦ ꠀꠍꠝꠣꠘꠞ ꠔꠦꠞꠣꠞ ꠟꠣꠈꠣꠘ ꠛꠦꠢꠤꠡꠣꠛ ꠇꠞꠝꠥ, ꠅꠃ ꠖꠦꠡ ꠅꠇꠟꠅ ꠔꠣꠞꠣꠞꠦ ꠖꠤꠝꠥ। ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡꠞꠦꠖꠤ, ꠖꠥꠘꠤꠀꠁꠞ ꠢꠇꠟ ꠎꠣꠔꠤꠄ ꠛꠞꠇꠔ ꠙꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠀꠝꠣꠞ ꠝꠣꠔ ꠢꠥꠘꠤꠀ, ꠀꠝꠣꠞ ꠢꠥꠇꠥꠝ, ꠀꠝꠣꠞ ꠀꠁꠘ ꠀꠞ ꠀꠝꠣꠞ ꠡꠞꠤꠅꠔ ꠅꠇꠟ ꠀꠝꠟ ꠇꠞꠍꠦ।” ");
INSERT INTO syls_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","ꠔꠦꠃ ꠁꠍꠢꠣꠇ ꠉꠦꠞꠣꠞ ꠐꠣꠃꠘꠅ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","ꠀꠞ ꠢꠤꠘꠞ ꠝꠣꠘꠡꠦ ꠔꠣꠘ ꠛꠃꠞ ꠇꠕꠣ ꠎꠤꠇꠣꠁꠟꠦ, ꠔꠣꠁꠘ ꠇꠁꠟꠣ ꠄꠁꠘ ꠀꠝꠣꠞ ꠛꠁꠘ। ꠄꠘꠞꠦ ꠛꠃ ꠇꠁꠔꠦ ꠔꠣꠁꠘ ꠒꠞꠣꠁꠟꠣ, ꠝꠘꠦ ꠇꠞꠟꠣ, ꠞꠦꠛꠦꠇꠣ ꠡꠥꠘ꠆ꠖꠞꠤ ꠇꠞꠤꠀ ꠢꠤꠘꠞ ꠝꠣꠘꠡꠦ ꠞꠦꠛꠦꠇꠣꠞꠦ ꠘꠦꠅꠀꠞ ꠟꠣꠉꠤ ꠔꠣꠘꠞꠦ ꠈꠥꠘ ꠇꠞꠤꠟꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","ꠁꠍꠢꠣꠇ ꠛꠃꠔ ꠖꠤꠘ ꠢꠘꠅ ꠞꠅꠀꠞ ꠛꠣꠖꠦ ꠄꠇꠖꠤꠘ ꠚꠤꠟꠤꠡ꠆ꠔꠤꠘꠤ ꠅꠇꠟꠞ ꠛꠣꠖꠡꠣ ꠀꠛꠤꠝꠣꠟꠤꠇꠦ ꠔꠣꠘ ꠈꠤꠠꠇꠤ ꠛꠣꠄꠖꠤ ꠌꠣꠁꠀ ꠖꠦꠈꠟꠣ, ꠁꠍꠢꠣꠇꠦ ꠔꠣꠘ ꠛꠤꠛꠤ ꠞꠦꠛꠦꠇꠣꠞꠦ ꠝꠣꠄꠀ ꠇꠞꠞꠣ। ");
INSERT INTO syls_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","ꠖꠦꠈꠤꠀ ꠔꠣꠁꠘ ꠁꠍꠢꠣꠇꠞꠦ ꠘꠦꠅꠀꠁꠀ ꠇꠁꠟꠣ, “ꠖꠦꠈꠃꠇ꠆ꠇꠣ, ꠞꠦꠛꠦꠇꠣ ꠔ ꠀꠍꠟꠦ ꠀꠙꠘꠣꠞ ꠛꠤꠛꠤ, ꠔꠦ ꠀꠙꠘꠦ ꠇꠦꠘꠦ ꠔꠣꠘꠞꠦ ꠀꠙꠘꠣꠞ ꠛꠁꠘ ꠇꠁꠟꠣ?” ꠁꠍꠢꠣꠇꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠀꠝꠤ ꠝꠘꠦ ꠇꠞꠍꠟꠣꠝ ꠔꠣꠁꠞ ꠟꠣꠉꠤ ꠀꠝꠣꠞ ꠎꠣꠘ ꠀꠞꠣꠁꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","ꠔꠦꠃ ꠀꠛꠤꠝꠣꠟꠤꠇꠦ ꠇꠁꠟꠣ, “ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠀꠙꠘꠦ ꠁꠔꠣ ꠇꠤꠔꠣ ꠛꠦꠛꠢꠣꠞ ꠇꠞꠟꠣ? ꠎꠦꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠔ ꠀꠙꠘꠣꠞ ꠛꠤꠛꠤꠞ ꠟꠉꠦ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠔ ꠌꠣꠁꠟ ꠅꠘꠦ ꠀꠞ ꠀꠙꠘꠦ ꠀꠝꠞꠣꠞꠦ ꠖꠥꠡꠤ ꠛꠣꠘꠣꠁꠟꠣ ꠅꠘꠦ।” ");
INSERT INTO syls_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","ꠛꠣꠖꠦ ꠀꠛꠤꠝꠣꠟꠤꠇꠦ ꠢꠇꠟ ꠝꠣꠘꠡꠞꠦ ꠅꠃ ꠢꠥꠇꠥꠝ ꠎꠣꠞꠤ ꠇꠞꠟꠣ, ꠇꠦꠃ ꠎꠥꠖꠤ ꠁꠍꠢꠣꠇ ꠛꠣ ꠔꠣꠘ ꠛꠤꠛꠤꠞ ꠡꠞꠤꠟꠅ ꠀꠔ ꠖꠦꠄ, ꠔꠣꠞꠦ ꠘꠤꠌꠄ ꠎꠣꠘꠦ ꠝꠣꠞꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ꠀꠞ ꠁꠍꠢꠣꠇꠦ ꠢꠤ ꠛꠞꠍ ꠈꠦꠔ ꠇꠞꠤꠀ ꠔꠣꠘ ꠎꠝꠤꠘꠅ ꠞꠥꠀ ꠛꠤꠌ ꠕꠣꠇꠤ ꠄꠇ-ꠡ ꠉꠥꠘ ꠛꠦꠡꠤ ꠚꠡꠟ ꠙꠣꠁꠟꠣ, ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘꠞꠦ ꠅꠃꠟꠣ ꠛꠞꠇꠔ ꠘꠣꠎꠤꠟ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","ꠔꠣꠘ ꠈꠣꠟꠤ ꠛꠣꠠꠔꠦꠃ ꠟꠣꠉꠟ, ꠀꠡ꠆ꠔꠦ ꠀꠡ꠆ꠔꠦ ꠔꠣꠁꠘ ꠈꠥꠛ ꠝꠣꠟꠖꠣꠞ ꠅꠁꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","ꠔꠣꠘ ꠉꠞꠥ-ꠍꠣꠉꠟ ꠀꠞ ꠉꠥꠟꠣꠝ-ꠛꠣꠘ꠆ꠖꠤ ꠅꠃꠟꠣ ꠛꠣꠠꠟ ꠎꠦꠘ, ꠁꠔꠣ ꠖꠦꠈꠤꠀ ꠚꠤꠟꠤꠡ꠆ꠔꠤꠘꠤ ꠅꠇꠟꠦ ꠁꠋꠡꠣꠁꠔꠣ ꠟꠣꠉꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","ꠀꠞ ꠔꠣꠘ ꠛꠣꠚ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠀꠝꠟꠅ, ꠔꠣꠘ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠦ ꠎꠦ ꠇꠥꠀ ꠅꠇꠟ ꠈꠥꠖꠤꠍꠟꠣ, ꠚꠤꠟꠤꠡ꠆ꠔꠤꠘꠤ ꠅꠇꠟꠦ ꠁꠉꠥꠁꠘ ꠝꠣꠐꠤꠖꠤ ꠜꠞꠤꠀ ꠛꠘ꠆ꠖ ꠇꠞꠤꠟꠣꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","ꠛꠣꠖꠦ ꠀꠛꠤꠝꠣꠟꠤꠇꠦ ꠁꠍꠢꠣꠇꠞꠦ ꠇꠁꠟꠣ, “ꠀꠙꠘꠦ ꠀꠝꠞꠣꠞ ꠉꠦꠍ ꠕꠘꠦ ꠎꠣꠃꠇ꠆ꠇꠣꠉꠤ, ꠀꠙꠘꠦ ꠔ ꠀꠝꠞꠣ ꠕꠘꠦ ꠛꠦꠡꠤ ꠡꠇ꠆ꠔꠤꠀꠟꠣ ꠅꠁꠉꠦꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","ꠅꠃ ꠁꠍꠢꠣꠇꠦ ꠢꠘ ꠕꠘꠦ ꠢꠞꠤꠀ ꠉꠤꠀ ꠉꠦꠞꠣꠞ ꠝꠞꠣ ꠉꠣꠋꠉꠞ ꠌꠞꠅ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠀ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","ꠀꠞ ꠔꠣꠘ ꠛꠣꠚ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠀꠝꠟꠞ ꠈꠥꠖꠣ ꠇꠥꠀꠁꠘ, ꠔꠣꠁꠘ ꠢꠤꠞꠛꠣꠞ ꠈꠥꠖꠤꠟꠣ, ꠇꠣꠞꠘ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠝꠃꠔꠞ ꠛꠣꠖꠦ ꠚꠤꠟꠤꠡ꠆ꠔꠤꠘꠤ ꠅꠇꠟꠦ ꠁꠔꠣ ꠜꠞꠤꠟꠣꠁꠍꠟꠣ। ꠀꠞ ꠔꠣꠘ ꠛꠣꠚꠦ ꠅꠃ ꠇꠥꠀꠁꠘ꠆ꠔꠞ ꠎꠦ ꠘꠣꠝ ꠞꠣꠈꠍꠟꠣ, ꠔꠣꠁꠘꠅ ꠅꠃ ꠘꠣꠝ ꠞꠣꠈꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ꠁꠍꠢꠣꠇꠞ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠦ ꠅꠃ ꠉꠣꠋꠉꠞ ꠌꠞꠅ ꠈꠥꠖꠤꠀ ꠙꠣꠘꠤꠞ ꠚꠥꠔꠀꠟꠣ ꠄꠇ ꠇꠥꠀ ꠙꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ꠀꠞ ꠉꠦꠞꠣꠞꠞ ꠞꠣꠈꠣꠟ ꠅꠇꠟꠦ ꠔꠣꠘ ꠞꠣꠈꠣꠟ ꠅꠇꠟꠞ ꠟꠉꠦ ꠖꠞꠛꠣꠞ ꠇꠞꠤꠀ ꠇꠁꠟ, ꠁ ꠙꠣꠘꠤ ꠀꠝꠞꠣꠞ। ꠅꠃ ꠔꠣꠁꠘ ꠁ ꠇꠥꠀꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠄꠡꠇ ꠝꠣꠘꠤ, ꠖꠞꠛꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ꠛꠣꠖꠦ ꠁꠍꠢꠣꠇꠞ ꠞꠣꠈꠣꠟ ꠅꠇꠟꠦ ꠀꠞꠅ ꠄꠇ ꠇꠥꠀ ꠈꠥꠖꠤꠟꠣ, ꠀꠞ ꠁꠐꠣ ꠟꠁꠀꠅ ꠔꠣꠞꠣ ꠖꠞꠛꠣꠞ ꠇꠞꠟꠣ। ꠅꠃ ꠔꠣꠁꠘ ꠁꠐꠣꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠡꠤꠐꠘꠣ ꠝꠣꠘꠤ, ꠖꠥꠡꠝꠘꠤ। ");
INSERT INTO syls_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ꠢꠦꠡꠦ ꠔꠣꠁꠘ ꠢꠘ ꠕꠘꠦ ꠢꠞꠤꠀ ꠉꠤꠀ ꠀꠞꠅ ꠄꠇ ꠇꠥꠀ ꠈꠥꠖꠣꠁꠟꠣ, ꠁꠚꠤꠞꠣ ꠔꠣꠞꠣ ꠀꠞ ꠇꠥꠘꠥ ꠖꠞꠛꠣꠞ ꠇꠞꠟꠣ ꠘꠣ। ꠔꠦꠃ ꠁꠍꠢꠣꠇꠦ ꠅꠃ ꠇꠥꠀꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠞꠢꠛꠔ ꠝꠣꠘꠤ, ꠛꠃꠔ ꠎꠣꠉꠣ। ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠅꠈꠘ ꠝꠣꠛꠥꠖꠦꠃ ꠀꠝꠞꠣꠞꠦ ꠛꠃꠔ ꠎꠣꠉꠣ ꠖꠤꠟꠣ, ꠀꠝꠞꠣ ꠁ ꠖꠦꠡꠅ ꠀꠞꠅ ꠛꠣꠠꠔꠣꠝ ꠙꠣꠞꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","ꠛꠣꠖꠦ ꠁꠍꠢꠣꠇꠦ ꠢꠘ ꠕꠘꠦ ꠢꠞꠤꠀ ꠛꠦꠞ-ꠡꠦꠛꠣꠔ ꠉꠦꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","ꠢꠃ ꠞꠣꠁꠔꠃ ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘꠞꠦ ꠖꠤꠖꠣꠞ ꠖꠤꠀ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠛꠣꠚ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠀꠟ꠆ꠟꠣ। ꠔꠥꠝꠤ ꠒꠞꠣꠁꠅ ꠘꠣ, ꠀꠝꠣꠞ ꠉꠥꠟꠣꠝ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠈꠣꠔꠤꠞꠦ ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠀꠍꠤ। ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠛꠞꠇꠔ ꠘꠣꠎꠤꠟ ꠇꠞꠝꠥ ꠀꠞ ꠔꠥꠝꠣꠞ ꠛꠋꠡ ꠛꠣꠠꠣꠁꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ꠅꠃ ꠁꠍꠢꠣꠇꠦ ꠢꠘꠅ ꠄꠇꠈꠣꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠁꠀ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝ ꠟꠁꠟꠣ। ꠢꠘꠅ ꠔꠣꠁꠘ ꠔꠣꠘ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠟꠣ ꠀꠞ ꠔꠣꠘ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠦ ꠄꠇ ꠇꠥꠀ ꠈꠥꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ꠛꠣꠖꠦ ꠀꠛꠤꠝꠣꠟꠤꠇꠦ ꠔꠣꠘ ꠃꠎꠤꠞ ꠅꠢꠥꠎꠔ ꠀꠞ ꠡꠦꠘꠣꠙꠔꠤ ꠚꠤꠈꠥꠟꠞꠦ ꠟꠁꠀ ꠉꠦꠞꠣꠞ ꠕꠣꠇꠤ ꠁꠍꠢꠣꠇꠞ ꠉꠦꠍꠦ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ꠁꠍꠢꠣꠇꠦ ꠄꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠀꠙꠘꠣꠞꠣ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠇꠤꠔꠣꠞ ꠟꠣꠉꠤ ꠀꠁꠟꠣ? ꠀꠙꠘꠣꠞꠣ ꠔ ꠁꠋꠡꠣ ꠇꠞꠤꠀ ꠀꠝꠣꠞꠦ ꠀꠙꠘꠣꠞꠣꠞ ꠉꠦꠍ ꠕꠘꠦ ꠈꠦꠖꠣꠁ ꠖꠤꠟꠣꠁꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","ꠔꠣꠞꠣ ꠇꠁꠟꠣ, “ꠀꠝꠞꠣ ꠅꠈꠘ ꠍꠣꠚ ꠛꠥꠎꠤꠀꠞ ꠎꠦꠘ, ꠝꠣꠛꠥꠖ ꠀꠙꠘꠣꠞ ꠟꠉꠦ ꠀꠍꠂꠘ। ꠄꠞꠟꠣꠉꠤ ꠀꠙꠘꠣꠞ ꠟꠉꠦ ꠀꠝꠞꠣꠞ ꠄꠉꠥ ꠅꠀꠖꠣ ꠅꠁꠎꠣꠃꠇ। ꠀꠃꠇ꠆ꠇꠣ, ꠀꠝꠞꠣ ꠄꠇ ꠌꠥꠇ꠆ꠔꠤ ꠇꠞꠤꠟꠣꠁ। ");
INSERT INTO syls_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ꠀꠝꠞꠣ ꠎꠦꠟꠣ ꠀꠙꠘꠣꠞꠦ ꠍꠁꠍꠤ ꠘꠣ ꠀꠞ ꠀꠙꠘꠣꠞ ꠜꠣꠟꠣꠁ ꠍꠣꠠꠣ ꠇꠥꠘꠥ ꠈꠦꠔꠤ ꠇꠞꠍꠤ ꠘꠣ, ꠎꠦꠟꠣ ꠀꠙꠘꠣꠞꠦ ꠡꠣꠘ꠆ꠔꠤꠄ ꠛꠤꠖꠣꠄ ꠖꠤꠍꠤ, ꠅꠃꠟꠣ ꠀꠙꠘꠦꠅ ꠀꠝꠞꠣꠞꠦ ꠈꠦꠔꠤ ꠇꠞꠔꠣ ꠘꠣ। ꠀꠙꠘꠦꠃ ꠔ ꠝꠣꠛꠥꠖꠞ ꠛꠞꠇꠔꠞ ꠝꠣꠘꠥꠡ।” ");
INSERT INTO syls_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","ꠛꠣꠖꠦ ꠁꠍꠢꠣꠇꠦ ꠔꠣꠞꠣꠞ ꠟꠣꠉꠤ ꠈꠣꠘꠣ-ꠖꠣꠘꠣ ꠎꠥꠁꠔ ꠇꠞꠟꠦ, ꠔꠣꠞꠣ ꠈꠣꠘꠣ-ꠖꠣꠘꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","ꠛꠣꠖꠞ ꠖꠤꠘ ꠛꠤꠀꠘꠦ ꠃꠑꠤꠀ ꠔꠣꠞꠣ ꠖꠥꠁꠅꠎꠘꠦ ꠇꠍꠝ ꠇꠞꠟꠣ। ꠀꠞ ꠁꠍꠢꠣꠇꠦ ꠔꠣꠞꠣꠞꠦ ꠛꠤꠖꠣꠄ ꠖꠤꠟꠦ, ꠔꠣꠞꠣ ꠖꠤꠟꠞ ꠝꠣꠎꠦ ꠡꠣꠘ꠆ꠔꠤ ꠙꠣꠁꠀ ꠞꠅꠀꠘꠣ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ꠢꠃ ꠖꠤꠘꠃ ꠔꠣꠘ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠦ ꠀꠁꠀ ꠔꠣꠞꠣꠞ ꠈꠥꠖꠣ ꠄꠇ ꠇꠥꠀꠞ ꠈꠛꠞ ꠎꠣꠘꠣꠁꠟꠣ, ꠔꠣꠞꠣ ꠙꠣꠘꠤꠞ ꠟꠣꠉꠣꠟ ꠙꠣꠁꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","ꠅꠃ ꠔꠣꠁꠘ ꠄꠞ ꠘꠣꠝ ꠖꠤꠟꠣ ꠡꠦꠛꠣ ꠝꠣꠘꠤ, ꠇꠍꠝ। ꠄꠞꠟꠣꠉꠤ ꠀꠁꠎꠅ ꠢꠤꠘꠞ ꠘꠣꠝ ꠛꠦꠞ-ꠡꠦꠛꠣ ꠞꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ꠁꠡꠦ ꠌꠣꠟ꠆ꠟꠤꠡ ꠛꠞꠍ ꠛꠄꠅꠡꠅ ꠢꠤꠐ꠆ꠐꠤ ꠛꠦꠞꠤꠞ ꠙꠥꠠꠤ ꠎꠤꠢꠥꠖꠤꠕ ꠀꠞ ꠢꠤꠐ꠆ꠐꠤ ꠄꠟꠘꠞ ꠙꠥꠠꠤ ꠛꠣꠡꠝꠔꠞꠦ ꠡꠣꠖꠤ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ꠁ ꠖꠥꠁꠅ ꠛꠦꠐꠤꠄ ꠁꠍꠢꠣꠇ ꠀꠞ ꠞꠦꠛꠦꠇꠣꠞ ꠎꠣꠘꠞ ꠝꠣꠎꠦ ꠈꠥꠛ ꠖꠥꠈ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ꠝꠥꠞꠛ꠆ꠛꠤ ꠛꠄꠅꠡꠅ ꠁꠍꠢꠣꠇꠞ ꠌꠃꠈꠞ ꠎꠥꠔꠤ ꠇꠝꠤ ꠎꠣꠅꠀꠄ ꠔꠣꠁꠘ ꠀꠞ ꠌꠃꠈꠦ ꠖꠦꠈꠔꠣ ꠘꠣ। ꠔꠣꠁꠘ ꠔꠣꠘ ꠛꠠ ꠙꠥꠀ ꠁꠡʼꠞꠦ ꠀꠘꠣꠁꠀ ꠇꠁꠟꠣ, “ꠛꠣꠛꠣꠞꠦ।” ꠁꠡꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠅꠃꠘꠥ ꠀꠝꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠖꠦꠈꠅ, ꠀꠝꠤ ꠔ ꠛꠥꠠꠣ ꠅꠁꠉꠦꠍꠤ, ꠇꠥꠘꠖꠤꠘ ꠝꠞꠤꠎꠤꠝꠥ ꠇꠁꠔꠣꠝ ꠙꠣꠞꠤꠀꠞ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ꠔꠥꠝꠤ ꠄꠉꠥ ꠇꠣꠝ ꠇꠞꠅ; ꠔꠥꠝꠣꠞ ꠀꠔꠤꠀꠞ, ꠔꠤꠞ-ꠗꠘꠥꠇ ꠟꠁꠀ ꠎꠋꠉꠟꠅ ꠡꠤꠇꠣꠞꠅ ꠎꠣꠅ, ꠀꠞ ꠀꠝꠣꠞ ꠟꠣꠉꠤ ꠇꠥꠘ꠆ꠔꠣ ꠡꠤꠇꠣꠞ ꠇꠞꠤꠀ, ");
INSERT INTO syls_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","ꠀꠝꠣꠞ ꠙꠍꠘ꠆ꠖꠞ ꠜꠣꠟꠣ ꠈꠣꠘꠤ ꠔꠂꠀꠞ ꠇꠞꠤ ꠀꠘꠅ, ꠔꠦꠃ ꠝꠞꠣꠞ ꠀꠉꠦ ꠁꠔꠣ ꠈꠣꠁꠀ ꠀꠝꠣꠞ ꠎꠣꠘꠦ ꠔꠥꠝꠣꠞꠦ ꠖꠥꠀ ꠖꠤꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ꠁꠍꠢꠣꠇꠦ ꠎꠦꠛꠟꠣ ꠔꠣꠘ ꠙꠥꠀ ꠁꠡʼꠞ ꠟꠉꠦ ꠁꠔꠣ ꠝꠣꠔꠤꠞꠣ, ꠁ ꠡꠝꠄ ꠞꠦꠛꠦꠇꠣꠄ ꠁꠔꠣ ꠢꠥꠘꠍꠤꠟꠣ। ꠔꠦꠃ ꠁꠡ ꠎꠦꠛꠟꠣ ꠡꠤꠇꠣꠞꠅ ꠉꠦꠟꠣꠉꠤ, ");
INSERT INTO syls_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ꠔꠣꠁꠘ ꠀꠁꠀ ꠔꠣꠘ ꠙꠥꠀ ꠁꠀꠇꠥꠛꠞꠦ ꠇꠁꠟꠣ, “ꠢꠥꠘꠅ, ꠀꠝꠤ ꠢꠥꠘꠟꠣꠝ ꠔꠥꠝꠣꠞ ꠛꠣꠚꠦ ꠔꠥꠝꠣꠞ ꠜꠣꠁ ꠁꠡʼꠞꠦ ꠇꠁꠞꠣ, ");
INSERT INTO syls_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠟꠣꠉꠤ ꠇꠥꠘ꠆ꠔꠣ ꠡꠤꠇꠣꠞ ꠇꠞꠤ ꠜꠣꠟꠣ ꠈꠣꠘꠤ ꠔꠂꠀꠞ ꠇꠞꠅ, ꠔꠦꠃ ꠀꠝꠤ ꠝꠞꠣꠞ ꠀꠉꠦ ꠅꠔꠣ ꠈꠣꠁꠀ, ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠔꠥꠝꠣꠞꠦ ꠖꠥꠀ ꠖꠤꠝꠥ।’ ");
INSERT INTO syls_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","ꠔꠦ ꠞꠦ ꠙꠥꠔ, ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠅꠈꠘ ꠎꠦꠔꠣ ꠇꠞꠔꠣꠄ ꠇꠁꠝꠥ, ꠔꠥꠝꠤ ꠅꠃꠟꠣ ꠢꠥꠘꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","ꠔꠥꠝꠤ ꠉꠤꠀ ꠙꠣꠟ ꠕꠣꠇꠤ ꠖꠥꠁꠐꠣ ꠔꠣꠎꠣ ꠈꠡꠤ ꠀꠘꠅ। ꠀꠝꠤ ꠁꠔꠣꠖꠤ ꠔꠥꠝꠣꠞ ꠛꠣꠚꠞ ꠡꠈꠞ ꠈꠣꠘꠤ, ꠀꠌꠣꠘꠇ ꠝꠎꠣ ꠇꠞꠤ ꠞꠣꠘ꠆ꠖꠤꠀ ꠖꠦꠁ। ");
INSERT INTO syls_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ꠔꠦꠃ ꠔꠥꠝꠤ ꠅꠔꠣ ꠟꠁꠀ ꠔꠥꠝꠣꠞ ꠛꠣꠚꠞ ꠉꠦꠍꠦ ꠎꠣꠁꠅ, ꠔꠣꠁꠘ ꠁꠔꠣ ꠈꠣꠁꠀ ꠝꠞꠣꠞ ꠀꠉꠦ ꠔꠥꠝꠣꠞꠦ ꠖꠥꠀ ꠇꠞꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","ꠁꠀꠇꠥꠛꠦ ꠔꠣꠘ ꠝꠣʼꠞꠦ ꠇꠁꠟꠣ, “ꠢꠥꠘꠅ, ꠀꠝꠣꠞ ꠜꠣꠁ ꠁꠡʼꠞ ꠡꠞꠤꠟ ꠔ ꠞꠥꠝꠣꠀꠟꠣ, ꠀꠝꠣꠞ ꠡꠞꠤꠟꠅ ꠔ ꠞꠥꠝꠣ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","ꠎꠥꠖꠤ ꠛꠣꠛꠣꠄ ꠀꠝꠣꠞ ꠡꠞꠤꠟꠅ ꠀꠔꠣꠁꠘ, ꠔꠦ ꠝꠘꠅ ꠇꠞꠛꠣ ꠀꠝꠤ ꠔꠣꠘꠦ ꠗꠥꠇꠣ ꠖꠤꠀꠞ, ꠔꠣꠁꠟꠦ ꠀꠝꠤ ꠖꠥꠀꠞ ꠛꠖꠟꠣ ꠀꠞꠅ ꠟꠣꠘ꠆ꠘꠔ ꠒꠣꠇꠤꠀ ꠀꠘꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","ꠔꠦꠃ ꠔꠣꠘ ꠝꠣʼꠄ ꠇꠁꠟꠣ, “ꠙꠥꠔꠞꠦ, ꠔꠥꠝꠣꠞ ꠁ ꠟꠣꠘ꠆ꠘꠔ ꠀꠝꠣꠞ ꠃꠙꠞꠦꠃ ꠙꠠꠃꠇ। ꠔꠥꠝꠤ ꠈꠣꠟꠤ ꠀꠝꠣꠞ ꠝꠣꠔꠈꠣꠘ ꠢꠥꠘꠅ ꠀꠞ ꠈꠡꠤꠉꠥꠁꠘ ꠀꠘꠤꠀ ꠖꠦꠅ।” ");
INSERT INTO syls_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","ꠅꠃ ꠁꠀꠇꠥꠛꠦ ꠉꠤꠀ ꠈꠡꠤ ꠀꠘꠤꠀ ꠔꠣꠘ ꠝꠣʼꠞꠦ ꠖꠤꠟꠣ। ꠀꠞ ꠔꠣꠘ ꠛꠣꠚꠦ ꠎꠦꠟꠣ ꠡꠈ ꠇꠞꠂꠘ, ꠔꠣꠁꠘ ꠅꠃꠟꠣ ꠝꠎꠣ ꠇꠞꠤ ꠞꠣꠘ꠆ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠊꠞꠞ ꠝꠣꠎꠦ ꠕꠅꠀ ꠛꠠ ꠙꠥꠀ ꠁꠡʼꠞ ꠜꠣꠟꠣ ꠜꠣꠟꠣ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠀꠘꠤꠀ ꠔꠣꠘ ꠢꠥꠞꠥ ꠙꠥꠀ ꠁꠀꠇꠥꠛꠞꠦ ꠚꠤꠘ꠆ꠖꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ꠁꠀꠇꠥꠛꠞ ꠀꠔꠅ ꠀꠞ ꠉꠟꠣꠔ ꠎꠦ ꠎꠣꠉꠣꠔ ꠞꠥꠝꠣ ꠘꠣꠄ, ꠢꠃ ꠎꠣꠉꠣꠔ ꠅꠃ ꠈꠡꠤꠞ ꠌꠣꠝꠠꠣ ꠟꠣꠉꠣꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ꠀꠞ ꠘꠤꠎꠞ ꠞꠣꠘ꠆ꠖꠣ ꠢꠃ ꠝꠎꠣꠞ ꠈꠣꠘꠤ ꠀꠞ ꠞꠥꠐꠤ ꠔꠣꠘ ꠙꠥꠀ ꠁꠀꠇꠥꠛꠞ ꠀꠔꠅ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","ꠁꠀꠇꠥꠛꠦ ꠔꠣꠘ ꠛꠣꠚꠞ ꠉꠦꠍꠦ ꠉꠤꠀ ꠒꠣꠇ ꠖꠤꠟꠣ, “ꠛꠣꠛꠣ।” ꠁꠍꠢꠣꠇꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠅꠃꠘꠥ ꠀꠝꠤ, ꠔꠥꠝꠤ ꠇꠦ ꠞꠦ ꠙꠥꠔ?” ");
INSERT INTO syls_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","ꠁꠀꠇꠥꠛꠦ ꠔꠣꠘ ꠛꠣꠚꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠀꠙꠘꠣꠞ ꠛꠠ ꠙꠥꠀ ꠁꠡ। ꠀꠙꠘꠦ ꠀꠝꠣꠞꠦ ꠎꠦꠟꠣ ꠇꠁꠍꠟꠣ, ꠀꠝꠤ ꠅꠃꠟꠣ ꠇꠞꠍꠤ। ꠖꠄꠀ ꠇꠞꠤ ꠃꠑꠤꠀ ꠛꠃꠇ꠆ꠇꠣ, ꠀꠝꠣꠞ ꠡꠤꠇꠣꠞꠞ ꠉꠥꠡ꠆ꠔ ꠈꠣꠃꠇ꠆ꠇꠣ, ꠈꠣꠁꠀ ꠢꠣꠞꠟꠦ ꠀꠙꠘꠦ ꠀꠝꠣꠞꠦ ꠖꠥꠀ ꠖꠤꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ꠁꠍꠢꠣꠇꠦ ꠔꠣꠘ ꠙꠥꠀꠞꠦ ꠇꠁꠟꠣ, “ꠛꠣꠛꠣꠞꠦ, ꠔꠥꠝꠤ ꠅꠔ ꠎꠟꠖꠤ ꠡꠤꠇꠣꠞ ꠙꠣꠁꠟꠣꠄ ꠇꠤꠟꠣ?” ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠀꠙꠘꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠝꠤꠟꠣꠁ ꠖꠤꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","ꠅꠃ ꠁꠍꠢꠣꠇꠦ ꠁꠀꠇꠥꠛꠞꠦ ꠇꠁꠟꠣ, “ꠛꠣꠛꠣ, ꠀꠝꠣꠞ ꠇꠣꠍꠣꠔ ꠀꠅ ꠔꠦꠃ ꠔꠥꠝꠣꠞ ꠉꠔꠞꠅ ꠀꠔ ꠖꠤꠀ ꠛꠥꠎꠝꠥ, ꠔꠥꠝꠤ ꠢꠣꠍꠣꠃ ꠀꠝꠣꠞ ꠙꠥꠀ ꠁꠡ ꠘꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","ꠁꠀꠇꠥꠛ ꠔꠣꠘ ꠛꠣꠚ ꠁꠍꠢꠣꠇꠞ ꠀꠞꠅ ꠇꠣꠍꠣꠔ ꠉꠦꠟꠣ। ꠔꠣꠁꠘ ꠡꠞꠤꠟꠅ ꠀꠔꠣꠁꠀ ꠇꠁꠟꠣ, “ꠉꠟꠣꠞ ꠀꠅꠀꠎꠐꠣ ꠁꠀꠇꠥꠛꠞ, ꠅꠁꠟꠦ ꠀꠔ ꠖꠥꠁꠅꠈꠣꠘ ꠔ ꠁꠡʼꠞ।” ");
INSERT INTO syls_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ꠁꠀꠇꠥꠛꠞ ꠀꠔ ꠔꠣꠘ ꠜꠣꠁ ꠁꠡʼꠞ ꠝꠔ ꠞꠥꠝꠦ ꠜꠞꠣ ꠀꠍꠤꠟ ꠇꠞꠤ ꠁꠍꠢꠣꠇꠦ ꠔꠣꠘꠞꠦ ꠌꠤꠘꠟꠣ ꠘꠣ। ꠅꠃ ꠔꠣꠁꠘ ꠁꠀꠇꠥꠛꠞꠦ ꠖꠥꠀ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ꠔꠣꠁꠘ ꠎꠤꠇꠣꠁꠟꠣ, “ꠔꠥꠝꠤ ꠇꠤꠔꠣ ꠢꠣꠍꠣꠃ ꠀꠝꠣꠞ ꠙꠥꠀ ꠁꠡ ꠘꠤ?” ꠁꠀꠇꠥꠛꠦ ꠇꠁꠟꠣ, “ꠎꠤꠅꠄ ꠛꠣꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","ꠅꠃ ꠁꠍꠢꠣꠇꠦ ꠇꠁꠟꠣ, “ꠙꠥꠀꠞ ꠡꠤꠇꠣꠞꠞ ꠉꠥꠡ꠆ꠔ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠀꠘꠅ, ꠁꠔꠣ ꠈꠣꠁꠀ ꠢꠣꠞꠟꠦ ꠀꠝꠣꠞ ꠎꠣꠘꠦ ꠔꠥꠝꠣꠞꠦ ꠖꠥꠀ ꠖꠤꠛ।” ꠁꠀꠇꠥꠛꠦ ꠉꠥꠡ꠆ꠔ ꠟꠁꠀ ꠀꠁꠟꠦ ꠔꠣꠁꠘ ꠈꠣꠁꠟꠣ। ꠛꠣꠖꠦ ꠔꠣꠘꠞꠦ ꠀꠋꠉꠥꠞꠞ ꠡꠞꠛꠔ ꠖꠤꠟꠦ ꠔꠣꠁꠘ ꠄꠅꠔꠣ ꠈꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","ꠢꠦꠡꠦ ꠔꠣꠘ ꠛꠣꠚꠦ ꠇꠁꠟꠣ, “ꠅ ꠙꠥꠔ ꠀꠅ, ꠇꠣꠍꠣꠔ ꠀꠁꠀ ꠀꠝꠣꠞꠦ ꠢꠥꠋꠉꠣ ꠖꠦꠅ।” ");
INSERT INTO syls_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","ꠅꠃ ꠁꠀꠇꠥꠛꠦ ꠇꠣꠍꠣꠔ ꠉꠤꠀ ꠢꠥꠋꠉꠣ ꠖꠤꠟꠣ, ꠀꠞ ꠁꠍꠢꠣꠇꠦ ꠔꠣꠘ ꠡꠞꠤꠟꠞ ꠇꠣꠙꠠꠞ ꠊꠦꠞꠣꠘ ꠢꠥꠋꠉꠤꠀ ꠔꠣꠘꠞꠦ ꠖꠥꠀ ꠖꠤꠟꠣ, “ꠖꠦꠈꠅ, ꠀꠝꠣꠞ ꠙꠥꠀꠞ ꠊꠦꠞꠣꠘ ꠔ ꠝꠣꠛꠥꠖꠞ ꠛꠞꠇꠔꠤ ꠈꠦꠔꠞ ꠊꠦꠞꠣꠘꠞ ꠟꠣꠈꠣꠘ। ");
INSERT INTO syls_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","ꠀꠟ꠆ꠟꠣꠄ ꠀꠍꠝꠣꠘꠞ ꠈꠥꠀ ꠕꠘꠦ ꠀꠞ ꠞꠡꠣꠁꠟ ꠎꠝꠤꠘ ꠕꠘꠦ ꠔꠥꠝꠣꠞꠦ ꠖꠦꠃꠇ꠆ꠇꠣ; ꠛꠃꠔ ꠚꠡꠟ ꠀꠞ ꠀꠋꠉꠥꠞꠞ ꠡꠞꠛꠔ ꠔꠥꠝꠣꠞꠦ ꠖꠦꠃꠇ꠆ꠇꠣ। ");
INSERT INTO syls_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","ꠢꠇꠟ ꠝꠣꠘꠥꠡ ꠔꠥꠝꠣꠞ ꠉꠥꠟꠣꠝ ꠅꠃꠇ, ꠢꠇꠟ ꠎꠣꠔꠤꠄ ꠔꠥꠝꠣꠞ ꠉꠦꠍꠦ ꠝꠣꠕꠣ ꠘꠥꠀꠃꠇ। ꠘꠤꠎꠞ ꠎꠣꠔꠞ ꠝꠣꠎꠦ ꠔꠥꠝꠤ ꠛꠠ ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠅ, ꠔꠥꠝꠣꠞ ꠝꠣʼꠞ ꠙꠦꠐꠞ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠦ ꠔꠥꠝꠣꠞ ꠉꠦꠍꠦ ꠝꠣꠕꠣ ꠘꠥꠀꠃꠇ। ꠎꠦ ꠔꠥꠝꠣꠞꠦ ꠟꠣꠘ꠆ꠘꠔ ꠖꠤꠛ, ꠔꠣꠞ ꠃꠙꠞꠦ ꠟꠣꠘ꠆ꠘꠔ ꠙꠠꠃꠇ। ꠎꠦ ꠔꠥꠝꠣꠞꠦ ꠖꠥꠀ ꠇꠞꠛ, ꠢꠦ ꠞꠢꠝꠔꠤ ꠅꠃꠇ।” ");
INSERT INTO syls_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ꠁꠍꠢꠣꠇꠦ ꠁꠀꠇꠥꠛꠞꠦ ꠖꠥꠀ ꠇꠞꠣ ꠡꠦꠡ ꠅꠁꠟꠦ, ꠁꠀꠇꠥꠛ ꠔꠣꠘ ꠛꠣꠚ ꠁꠍꠢꠣꠇꠞ ꠍꠣꠝꠘꠦ ꠕꠘꠦ ꠢꠞꠔꠦꠃ, ꠔꠣꠘ ꠜꠣꠁ ꠁꠡꠦ ꠡꠤꠇꠣꠞ ꠟꠁꠀ ꠊꠞꠅ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","ꠔꠣꠁꠘꠅ ꠜꠣꠟꠣ ꠈꠣꠘꠤ ꠔꠂꠀꠞ ꠇꠞꠤꠀ ꠛꠣꠚꠞ ꠉꠦꠍꠦ ꠟꠁꠀ ꠀꠁꠀ ꠇꠁꠟꠣ, “ꠛꠣꠛꠣ, ꠃꠑꠤꠀ ꠛꠁꠀ ꠀꠙꠘꠣꠞ ꠙꠥꠀꠞ ꠡꠤꠇꠣꠞꠞ ꠉꠥꠡ꠆ꠔ ꠈꠣꠃꠇ꠆ꠇꠣ, ꠈꠣꠁꠀ ꠢꠣꠞꠟꠦ ꠀꠙꠘꠣꠞ ꠎꠣꠘꠦ ꠀꠝꠣꠞꠦ ꠖꠥꠀ ꠖꠤꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","ꠅꠃ ꠔꠣꠘ ꠛꠣꠚꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠇꠦ?” ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠛꠣꠛꠣ, ꠀꠝꠤ ꠔ ꠀꠙꠘꠣꠞ ꠛꠠ ꠙꠥꠀ ꠁꠡ।” ");
INSERT INTO syls_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ꠀꠞ ꠁꠍꠢꠣꠇꠞ ꠡꠞꠤꠟꠅ ꠛꠦꠎꠥꠁꠔꠣ ꠇꠣꠙꠣ ꠡꠥꠞꠥ ꠅꠁꠟ। ꠇꠣꠙꠤ ꠇꠣꠙꠤ ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠔꠣꠁꠟꠦ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠡꠤꠇꠣꠞꠞ ꠉꠥꠡ꠆ꠔ ꠟꠁꠀ ꠎꠦ ꠀꠁꠍꠤꠟ, ꠁꠉꠥ ꠇꠦ? ꠔꠥꠝꠤ ꠀꠁꠛꠣꠞ ꠀꠉꠦꠃ ꠀꠝꠤ ꠅꠔꠣ ꠈꠣꠁꠀ ꠔꠣꠞꠦ ꠖꠥꠀ ꠖꠤꠍꠤ, ꠀꠞ ꠖꠥꠀꠞ ꠚꠟ ꠢꠦ-ꠃ ꠙꠣꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","ꠛꠣꠚꠞ ꠝꠣꠔ ꠢꠥꠘꠤꠀꠃ ꠁꠡꠦ ꠄꠇꠦꠛꠣꠞꠦ ꠛꠥꠇ ꠜꠣꠋꠉꠤꠀ ꠌꠤꠟ꠆ꠟꠣꠁꠀ ꠔꠣꠘ ꠛꠣꠚꠞꠦ ꠇꠁꠟꠣ, “ꠛꠣꠎꠣꠘ, ꠀꠝꠣꠞꠦ, ꠀꠝꠣꠞꠦꠅ ꠖꠥꠀ ꠇꠞꠅ!” ");
INSERT INTO syls_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","ꠁꠍꠢꠣꠇꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠜꠣꠁꠄ ꠀꠁꠀ ꠌꠔꠥꠞꠤ ꠇꠞꠤꠀ ꠔꠥꠝꠣꠞ ꠙꠣꠅꠘꠣ ꠖꠥꠀ ꠘꠤꠍꠦꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","ꠁꠡꠦ ꠇꠁꠟꠣ, “ꠔꠣꠞ ꠘꠣꠝ ꠁꠀꠇꠥꠛ ꠝꠣꠘꠤ, ꠗꠥꠇꠣꠛꠣꠎ ꠘꠣꠄ ꠘꠤ? ꠢꠣꠍꠣꠃ ꠢꠦ ꠖꠥꠁꠛꠣꠞ ꠀꠝꠣꠞꠦ ꠗꠥꠇꠣ ꠖꠤꠍꠦ। ꠛꠠ ꠙꠥꠀ ꠢꠤꠡꠣꠛꠦ ꠀꠝꠣꠞ ꠝꠣꠟꠤꠇꠣꠘꠣ ꠢꠦ ꠀꠉꠦ ꠌꠥꠞꠤ ꠇꠞꠤ ꠘꠤꠍꠤꠟ, ꠀꠞ ꠖꠦꠈꠃꠇ꠆ꠇꠣ, ꠁꠚꠤꠞꠣ ꠀꠝꠣꠞ ꠖꠥꠀꠅ ꠟꠁꠀ ꠉꠦꠟꠉꠤ।” ꠔꠣꠁꠘ ꠚꠤꠞꠤꠀ ꠇꠁꠟꠣ, “ꠀꠙꠘꠦ ꠀꠝꠣꠞ ꠟꠣꠉꠤ ꠇꠥꠘꠥ ꠖꠥꠀꠃ ꠞꠣꠈꠍꠂꠘ ꠘꠣ ꠘꠤ?” ");
INSERT INTO syls_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ꠁꠍꠢꠣꠇꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠢꠥꠘꠅ, ꠀꠝꠤ ꠔꠣꠞꠦ ꠔꠥꠝꠣꠞ ꠘꠦꠔꠣ ꠛꠣꠘꠣꠁꠍꠤ, ꠀꠞ ꠔꠣꠞ ꠉꠥꠡ꠆ꠐꠤꠞꠦ ꠔꠣꠞ ꠉꠥꠟꠣꠝ ꠛꠣꠘꠣꠁꠍꠤ, ꠔꠣꠞꠦ ꠚꠡꠟ ꠀꠞ ꠀꠋꠉꠥꠞꠞ ꠡꠞꠛꠔ ꠖꠤꠀ ꠍꠣꠝꠣꠘꠤ ꠇꠞꠍꠤ; ꠅꠈꠘ ꠔꠥꠝꠣꠞ ꠟꠣꠉꠤ ꠀꠞ ꠇꠤꠔꠣ ꠇꠞꠔꠣꠝꠞꠦ ꠙꠥꠔ?” ");
INSERT INTO syls_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","ꠁꠡꠦ ꠚꠤꠞꠤꠀ ꠔꠣꠘ ꠛꠣꠚꠞꠦ ꠇꠁꠟꠣ, “ꠅ ꠛꠣꠎꠣꠘ, ꠀꠙꠘꠣꠞ ꠉꠦꠍꠦ ꠇꠤꠔꠣ ꠅꠃ ꠄꠇ ꠖꠥꠀꠃ ꠀꠍꠤꠟ ꠘꠤ? ꠛꠣꠎꠣꠘ ꠞꠦꠛꠣ, ꠀꠙꠘꠦ ꠀꠝꠣꠞꠦ, ꠀꠝꠣꠞꠦꠅ ꠖꠥꠀ ꠇꠞꠃꠇ꠆ꠇꠣ!” ꠅꠔꠣ ꠇꠁꠀ ꠔꠣꠁꠘ ꠎꠥꠞꠦ ꠎꠥꠞꠦ ꠌꠤꠟ꠆ꠟꠣꠁꠀ ꠇꠣꠘ꠆ꠖꠣꠔ ꠟꠣꠉꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","ꠅꠃ ꠔꠣꠘ ꠛꠣꠚ ꠁꠍꠢꠣꠇꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠛꠡꠔꠈꠣꠘꠣꠞ ꠝꠣꠐꠤ ꠘꠤꠞꠡ ꠅꠁꠛ, ꠢꠤꠘꠅ ꠀꠍꠝꠣꠘꠞ ꠈꠥꠀꠅ ꠙꠠꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","ꠔꠟꠥꠀꠞꠃ ꠔꠥꠝꠣꠞ ꠎꠤꠘ꠆ꠖꠦꠉꠤ ꠅꠁꠛ, ꠀꠞ ꠘꠤꠎꠞ ꠜꠣꠁꠞ ꠉꠥꠟꠣꠝ ꠅꠁꠛꠣꠄ; ꠅꠁꠟꠦ ꠎꠦꠛꠟꠣ ꠔꠥꠝꠤ ꠘꠣ-ꠝꠣꠘꠞꠣ ꠅꠁꠎꠤꠛꠣꠄ, ꠅꠃ ꠡꠝꠄ ꠘꠤꠎꠞ ꠉꠞ꠆ꠖꠘꠣ ꠕꠣꠇꠤ ꠔꠣꠞ ꠎꠥꠀꠟ ꠢꠞꠣꠁꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","ꠁꠀꠇꠥꠛꠦ ꠔꠣꠘ ꠛꠣꠚꠞ ꠉꠦꠍ ꠕꠘꠦ ꠖꠥꠀ ꠙꠣꠁꠍꠟꠣ ꠇꠞꠤ ꠁꠡꠦ ꠔꠣꠘꠞꠦ ꠁꠋꠡꠣꠁꠔꠣ ꠟꠣꠉꠟꠣ। ꠁꠡꠦ ꠝꠘꠦ ꠝꠘꠦ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠛꠣꠚꠞ ꠟꠣꠉꠤ ꠝꠃꠔꠞ ꠇꠣꠘ꠆ꠖꠘꠞ ꠖꠤꠘ ꠀꠁꠌ꠆ꠌꠦ। ꠄꠞꠛꠣꠖꠦꠃ ꠔꠣꠞꠦ ꠈꠥꠘ ꠇꠞꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","ꠞꠦꠛꠦꠇꠣꠄ ꠔꠣꠘ ꠛꠠ ꠙꠥꠀ ꠁꠡʼꠞ ꠁꠔꠣ ꠝꠣꠔꠣ-ꠝꠣꠔꠤ ꠢꠥꠘꠟꠣ, ꠔꠦꠃ ꠢꠥꠞꠥ ꠙꠥꠀ ꠁꠀꠇꠥꠛꠞꠦ ꠀꠘꠣꠁꠀ ꠇꠁꠟꠣ, “ꠢꠥꠘꠅ, ꠔꠥꠝꠣꠞ ꠜꠣꠁ ꠁꠡꠦ ꠔꠥꠝꠣꠞꠦ ꠈꠥꠘ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠖꠤꠟꠞꠦ ꠛꠣꠘ꠆ꠖꠤꠟꠣꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ꠀꠝꠣꠞ ꠙꠥꠔ, ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠝꠣꠔꠈꠣꠘ ꠢꠥꠘꠅ, ꠔꠥꠝꠤ ꠢꠣꠞꠣꠘ ꠐꠣꠃꠘꠅ ꠀꠝꠣꠞ ꠜꠣꠁ ꠟꠣꠛꠘꠞ ꠉꠦꠍꠦ ꠢꠞꠤꠀ ꠎꠣꠅꠉꠤ, ");
INSERT INTO syls_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ꠀꠞ ꠔꠥꠝꠣꠞ ꠜꠣꠁꠞ ꠉꠥꠍꠣ ꠘꠣ ꠇꠝꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠔꠣꠘ ꠉꠦꠍꠦ ꠕꠣꠇꠅ। ");
INSERT INTO syls_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ꠔꠣꠞ ꠉꠥꠍꠣ ꠇꠝꠤꠉꠦꠟꠦ, ꠔꠥꠝꠤ ꠔꠣꠞ ꠟꠉꠦ ꠎꠦꠔꠣ ꠇꠞꠍ ꠁꠔꠣ ꠢꠦ ꠚꠣꠃꠞꠤꠟꠤꠟꠦ, ꠀꠝꠤ ꠈꠛꠞꠤꠀꠖꠤ ꠔꠥꠝꠣꠞꠦ ꠀꠘꠣꠁꠝꠥ। ꠇꠤꠔꠣꠟ꠆ꠟꠣꠉꠤ ꠀꠝꠤ ꠄꠇꠖꠤꠘꠦ ꠔꠥꠝꠞꠣ ꠖꠥꠁꠅꠎꠘꠞꠦ ꠀꠞꠣꠁꠔꠣꠝ?” ");
INSERT INTO syls_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","ꠛꠣꠖꠦ ꠞꠦꠛꠦꠇꠣꠄ ꠁꠍꠢꠣꠇꠞꠦ ꠇꠁꠟꠣ, “ꠅꠃ ꠢꠤꠐ꠆ꠐꠤ ꠙꠥꠠꠤꠘ꠆ꠔꠞ ꠟꠣꠉꠤ ꠀꠝꠣꠞ ꠀꠞ ꠛꠣꠌꠣꠞ ꠡ꠆ꠛꠣꠖ ꠘꠣꠁ। ꠁꠀꠇꠥꠛꠦꠅ ꠎꠥꠖꠤ ꠅꠃ ꠟꠣꠈꠣꠘ, ꠁ ꠖꠦꠡꠞ ꠇꠥꠘꠥ ꠢꠤꠐ꠆ꠐꠤ ꠙꠥꠠꠤꠞꠦ ꠡꠣꠖꠤ ꠇꠞꠤꠟꠣꠄ, ꠔꠣꠁꠟꠦ ꠀꠝꠣꠞ ꠀꠞ ꠛꠣꠌꠤꠀꠃ ꠟꠣꠜ ꠇꠤꠔꠣ?” ");
INSERT INTO syls_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ꠞꠦꠛꠦꠇꠣꠞ ꠝꠣꠔ ꠢꠥꠘꠤꠀ ꠁꠍꠢꠣꠇꠦ, ꠁꠀꠇꠥꠛꠞꠦ ꠀꠘꠣꠁꠀ ꠖꠥꠀ ꠇꠞꠟꠣ ꠀꠞ ꠅꠃ ꠢꠥꠇꠥꠝ ꠖꠤꠟꠣ, “ꠔꠥꠝꠤ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠞ ꠇꠥꠘꠥ ꠙꠥꠠꠤꠞꠦ ꠛꠤꠀ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","ꠔꠥꠝꠤ ꠙꠖ꠆ꠖꠘ-ꠁꠞꠣꠝ ꠖꠦꠡꠅ ꠔꠥꠝꠣꠞ ꠘꠣꠘꠣ ꠛꠕꠥꠄꠟꠞ ꠛꠣꠠꠤꠔ ꠎꠣꠅꠉꠤ, ꠢꠘꠅ ꠔꠥꠝꠣꠞ ꠝꠣꠝꠥ ꠟꠣꠛꠘꠞ ꠇꠥꠘꠥ ꠙꠥꠠꠤꠞꠦ ꠛꠤꠀ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","ꠡꠞ꠆ꠛ-ꠡꠇ꠆ꠔꠤꠝꠣꠘ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠣꠞꠦ ꠛꠞꠇꠔ ꠘꠣꠎꠤꠟ ꠇꠞꠃꠇ꠆ꠇꠣ ꠀꠞ ꠚꠟꠖꠣꠞ ꠇꠞꠤꠀ ꠛꠃꠔ ꠛꠣꠠꠣꠃꠇ꠆ꠇꠣ, ꠎꠣꠔꠦ ꠇꠞꠤ ꠔꠥꠝꠤ ꠛꠃꠔ ꠉꠥꠡ꠆ꠐꠤꠀꠟꠣ ꠎꠣꠔꠤ ꠅꠅ। ");
INSERT INTO syls_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ꠎꠦ ꠛꠞꠇꠔ ꠔꠣꠁꠘ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞꠦ ꠘꠣꠎꠤꠟ ꠇꠞꠍꠟꠣ, ꠢꠃ ꠛꠞꠇꠔ ꠔꠣꠁꠘ ꠔꠥꠝꠣꠞꠦ ꠀꠞ ꠔꠥꠝꠣꠞ ꠛꠋꠡꠞꠦ ꠖꠣꠘ ꠇꠞꠃꠇ꠆ꠇꠣ। ꠀꠞ ꠎꠦ ꠖꠦꠡ ꠀꠟ꠆ꠟꠣꠄ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞꠦ ꠖꠤꠍꠂꠘ, ꠎꠦꠈꠣꠘꠅ ꠔꠥꠝꠤ ꠅꠈꠘ ꠝꠥꠍꠣꠚꠤꠞ ꠀꠍ, ꠁ ꠖꠦꠡꠈꠣꠘ ꠎꠣꠘꠥ ꠔꠥꠝꠣꠞ ꠅꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ꠛꠣꠖꠦ ꠁꠍꠢꠣꠇꠦ ꠁꠀꠇꠥꠛꠞꠦ ꠛꠤꠖꠣꠄ ꠖꠤꠟꠣ, ꠀꠞ ꠔꠣꠁꠘ ꠙꠖ꠆ꠖꠘ-ꠁꠞꠣꠝꠅ ꠅꠞꠣꠝꠤ ꠛꠕꠥꠄꠟꠞ ꠙꠥꠀ ꠟꠣꠛꠘꠞ ꠉꠦꠍꠦ ꠞꠅꠀꠘꠣ ꠅꠁꠟꠣ। ꠟꠣꠛꠘ ꠅꠁꠟꠣ ꠞꠦꠛꠦꠇꠣꠞ ꠜꠣꠁ, ꠁꠀꠇꠥꠛ ꠀꠞ ꠁꠡʼꠞ ꠝꠣꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","ꠁꠡꠦ ꠎꠦꠛꠟꠣ ꠢꠥꠘꠟꠣ, ꠁꠍꠢꠣꠇꠦ ꠁꠀꠇꠥꠛꠞꠦ ꠖꠥꠀ ꠇꠞꠤꠀ ꠛꠤꠀ ꠇꠞꠣꠘꠤꠞ ꠘꠤꠅꠔꠦ ꠙꠖ꠆ꠖꠘ-ꠁꠞꠣꠝꠅ ꠙꠣꠑꠣꠁꠍꠂꠘ ꠀꠞ ꠇꠦꠘꠣꠘꠤ ꠙꠥꠠꠤꠘ꠆ꠔꠞꠦ ꠛꠤꠀ ꠇꠞꠔꠦ ꠘꠤꠡꠦꠗ ꠇꠞꠍꠂꠘ, ");
INSERT INTO syls_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ꠀꠞ ꠁꠀꠇꠥꠛꠦ ꠔꠣꠘ ꠝꠣ-ꠛꠣꠚꠞ ꠢꠥꠇꠥꠝꠦ ꠙꠖ꠆ꠖꠘ-ꠁꠞꠣꠝꠅ ꠉꠦꠍꠂꠘꠉꠤ, ");
INSERT INTO syls_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ꠅꠃ ꠁꠡꠦ ꠛꠥꠎꠟꠣ ꠎꠦꠘ, ꠔꠣꠘ ꠛꠣꠚ ꠁꠍꠢꠣꠇ ꠇꠦꠘꠣꠘꠤ ꠛꠦꠐꠤꠘ꠆ꠔꠞ ꠃꠙꠞꠦ ꠈꠥꠡꠤ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ꠄꠞꠟꠣꠉꠤ ꠖꠥꠁ ꠛꠃ ꠕꠣꠇꠟꠦꠅ ꠔꠣꠁꠘ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠙꠥꠀ ꠁꠍꠝꠣꠁꠟꠞ ꠉꠦꠍꠦ ꠉꠤꠀ ꠔꠣꠘ ꠙꠥꠠꠤ ꠝꠢꠟꠔꠞꠦ ꠛꠤꠀ ꠇꠞꠟꠣ। ꠝꠢꠟꠔ ꠅꠁꠟꠣ ꠘꠣꠛꠣꠃꠔꠞ ꠛꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","ꠀꠞ ꠁꠀꠇꠥꠛꠦ ꠛꠦꠞ-ꠡꠦꠛꠣ ꠍꠣꠠꠤꠀ ꠔꠣꠘ ꠝꠣꠝꠥꠞ ꠛꠣꠠꠤ ꠢꠣꠞꠣꠘ ꠐꠣꠃꠘꠞ ꠛꠣꠄ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","ꠙꠕꠅ ꠄꠇ ꠎꠣꠉꠣꠔ ꠡꠥꠞꠥꠎ ꠒꠥꠛꠤ ꠉꠦꠟꠦ ꠔꠣꠁꠘ ꠢꠘꠅꠃ ꠞꠣꠁꠔ ꠇꠣꠐꠣꠁꠟꠣ। ꠢꠘꠞ ꠙꠣꠔ꠆ꠔꠞꠖꠤ ꠢꠤꠔꠣꠘ ꠖꠤꠀ ꠁꠀꠇꠥꠛꠦ ꠊꠥꠝꠣꠁꠔꠣ ꠇꠞꠤ ꠢꠥꠔꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","ꠢꠥꠔꠤꠀ ꠢꠣꠞꠟꠦ ꠈꠥꠀꠛꠦ ꠖꠦꠈꠟꠣ, ꠖꠥꠘꠤꠀꠁꠞ ꠃꠙꠞꠦ ꠄꠇꠈꠣꠘ ꠝꠁ ꠃꠛꠣꠁ ꠞꠁꠍꠦ, ꠁ ꠝꠁꠞ ꠝꠣꠕꠣ ꠀꠍꠝꠣꠘꠅ ꠟꠣꠉꠣꠁꠟ। ꠔꠣꠁꠘ ꠖꠦꠈꠟꠣ ꠀꠟ꠆ꠟꠣꠞ ꠚꠤꠞꠤꠡ꠆ꠔꠣ ꠅꠇꠟꠦ ꠅꠉꠥꠛꠣꠄ ꠃꠑꠣ-ꠘꠣꠝꠣ ꠇꠞꠞꠣ, ");
INSERT INTO syls_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠄꠞ ꠃꠙꠞꠦ ꠃꠛꠣꠁꠀ ꠇꠁꠞꠣ, “ꠀꠝꠤ ꠝꠣꠛꠥꠖ, ꠔꠥꠝꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠁꠘ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠀꠟ꠆ꠟꠣ ꠀꠞ ꠁꠍꠢꠣꠇꠞ ꠀꠟ꠆ꠟꠣ। ꠔꠥꠝꠤ ꠅꠃ ꠎꠦ ꠎꠝꠤꠘꠅ ꠢꠥꠔꠤꠍ, ꠁꠐꠣ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠀꠞ ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡ ꠅꠇꠟꠞꠦ ꠖꠤꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡ ꠅꠇꠟ ꠖꠥꠘꠤꠀꠁꠞ ꠗꠥꠁꠟ-ꠛꠣꠟꠥꠞ ꠟꠣꠈꠣꠘ ꠛꠦꠢꠤꠡꠣꠛ ꠅꠁꠛꠣ। ꠀꠞ ꠙꠥꠛꠦ-ꠙꠁꠌꠝꠦ, ꠃꠔꠞꠦ-ꠖꠃꠇꠘꠦ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠝꠦꠟꠤꠎꠤꠛꠣ। ꠔꠥꠝꠤ ꠀꠞ ꠔꠥꠝꠣꠞ ꠛꠋꠡꠞ ꠝꠣꠎꠦꠖꠤ ꠖꠥꠘꠤꠀꠁꠞ ꠢꠇ꠆ꠇꠟ ꠎꠣꠔꠤꠄ ꠛꠞꠇꠔ ꠢꠣꠍꠤꠟ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠟꠉꠦ ꠀꠍꠤ, ꠔꠥꠝꠤ ꠎꠦꠘꠅꠃ ꠎꠣꠅ ꠘꠣ ꠇꠦꠘꠦ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠢꠦꠚꠣꠎꠔ ꠇꠞꠝꠥ ꠀꠞ ꠅꠃ ꠖꠦꠡꠅ ꠢꠤꠞꠛꠣꠞ ꠔꠥꠝꠣꠞꠦ ꠚꠤꠞꠣꠁꠀ ꠀꠘꠝꠥ। ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠎꠦꠔꠣ ꠎꠦꠔꠣ ꠇꠁꠍꠤ ꠁꠔꠣ ꠢꠣꠍꠤꠟ ꠅꠀꠞ ꠀꠉꠦ, ꠔꠥꠝꠣꠞꠦ ꠍꠣꠠꠔꠣꠝ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","ꠛꠣꠖꠦ ꠁꠀꠇꠥꠛꠦ ꠊꠥꠝ ꠕꠣꠇꠤ ꠃꠑꠤꠀ ꠇꠁꠟꠣ, “ꠔꠣꠁꠟꠦ ꠢꠣꠍꠣꠃ ꠝꠣꠛꠥꠖ ꠁꠘꠅ ꠀꠍꠂꠘ, ꠀꠝꠤ ꠔ ꠎꠣꠘꠔꠣꠝ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","ꠅꠃ ꠔꠣꠁꠘ ꠒꠞꠣꠁꠀ ꠇꠁꠟꠣ, “ꠇꠤꠎꠣꠔ ꠉꠞꠝ ꠁ ꠎꠣꠉꠣ! ꠁꠈꠣꠘ ꠘꠤꠌ꠆ꠌꠄ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞ, ꠅꠈꠣꠘꠅꠃ ꠛꠦꠢꠦꠡ꠆ꠔꠞ ꠖꠥꠀꠞ।” ");
INSERT INTO syls_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","ꠔꠣꠁꠘ ꠚꠎꠞꠞ ꠡꠝꠄ ꠃꠑꠤꠀ, ꠎꠦ ꠙꠣꠔ꠆ꠔꠞꠐꠣ ꠔꠣꠘ ꠝꠣꠕꠣꠞ ꠔꠟꠦ ꠢꠤꠔꠣꠘ ꠖꠤꠍꠟꠣ, ꠁꠇꠐꠣ ꠈꠥꠐꠤꠞ ꠝꠔ ꠇꠞꠤ ꠉꠣꠠꠤꠀ ꠄꠞ ꠃꠙꠞꠦ ꠔꠦꠟ ꠓꠣꠟꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","ꠀꠞ ꠢꠤ ꠎꠣꠉꠣꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠛꠦꠕꠦꠟ ꠝꠣꠘꠤ, ꠛꠣꠄꠔꠥꠟ꠆ꠟꠣ, ꠁꠘꠞ ꠀꠉꠞ ꠘꠣꠝ ꠀꠍꠤꠟ ꠟꠥꠎ। ");
INSERT INTO syls_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","ꠛꠣꠖꠦ ꠁꠀꠇꠥꠛꠦ ꠇꠍꠝ ꠈꠣꠁꠀ ꠇꠁꠟꠣ, “ꠀꠟ꠆ꠟꠣꠄ ꠎꠥꠖꠤ ꠀꠝꠣꠞ ꠁ ꠍꠚꠞꠅ ꠢꠦꠚꠣꠎꠔ ꠇꠞꠂꠘ, ꠔꠣꠁꠘ ꠀꠝꠣꠞ ꠈꠣꠘꠤ-ꠈꠥꠞꠣꠇ, ꠚꠤꠘ꠆ꠖꠣꠞ ꠟꠦꠛꠣꠍ ꠎꠥꠉꠣꠁ ꠖꠦꠁꠘ, ");
INSERT INTO syls_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ꠀꠝꠤ ꠢꠤꠞꠛꠣꠞ ꠍꠢꠤ-ꠍꠣꠟꠣꠝꠔꠦ ꠛꠣꠚꠞ ꠛꠣꠠꠤꠔ ꠚꠤꠞꠤꠀ ꠀꠁ, ꠔꠦ ꠅꠃ ꠝꠣꠛꠥꠖꠞꠦꠃ ꠀꠝꠣꠞ ꠀꠟ꠆ꠟꠣ ꠝꠣꠘꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ꠀꠞ ꠅꠃ ꠎꠦ ꠙꠣꠔ꠆ꠔꠞ ꠀꠝꠤ ꠈꠥꠐꠤ ꠉꠣꠠꠤꠀ ꠕꠁꠟꠣꠝ, ꠅꠘꠅ ꠛꠣꠄꠔꠥꠟ꠆ꠟꠣ ꠡꠞꠤꠚ ꠅꠁꠛ। ꠀꠞ ꠔꠥꠝꠤ ꠀꠝꠣꠞꠦ ꠎꠔꠔꠣ ꠖꠤꠛꠣꠄ, ꠄꠞ ꠖꠡ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ ꠀꠝꠤ ꠘꠤꠌ꠆ꠌꠄ ꠔꠥꠝꠣꠞꠦ ꠖꠤꠟꠣꠁꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","ꠛꠣꠖꠦ ꠁꠀꠇꠥꠛꠦ ꠀꠐꠤ ꠀꠐꠤ ꠙꠥꠛꠞ ꠖꠦꠡꠞ ꠝꠣꠘꠡꠞ ꠄꠟꠣꠇꠣꠔ ꠉꠦꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","ꠉꠤꠀ ꠢꠘꠞ ꠛꠘ꠆ꠖꠞ ꠝꠣꠎꠦ ꠄꠇ ꠇꠥꠀ ꠖꠦꠈꠟꠣ। ꠢꠃ ꠇꠥꠀꠞ ꠉꠦꠍꠦ ꠔꠤꠘ ꠙꠣꠟ ꠝꠦꠠꠣ ꠢꠥꠔꠤ ꠞꠁꠍꠦ; ꠞꠣꠈꠣꠟ ꠅꠇꠟꠦ ꠅꠘ ꠕꠘꠦ ꠔꠣꠞꠣꠞꠦ ꠙꠣꠘꠤ ꠈꠣꠅꠀꠂꠘ। ꠀꠞ ꠇꠥꠀꠞ ꠝꠥꠈꠅ ꠛꠠ ꠄꠇ ꠙꠣꠔ꠆ꠔꠞ ꠕꠅꠀ ꠅꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","ꠢꠇꠟ ꠝꠦꠠꠣꠞ ꠙꠣꠟ ꠎꠦꠛꠟꠣ ꠄꠇꠈꠣꠘꠅ ꠅꠁꠔ, ꠔꠦꠃ ꠞꠣꠈꠣꠟ ꠅꠇꠟꠦ ꠇꠥꠀꠞ ꠝꠥꠈ ꠕꠘꠦ ꠙꠣꠔ꠆ꠔꠞꠉꠥ ꠢꠞꠣꠁ ꠖꠤꠀ ꠝꠦꠠꠣꠁꠘ꠆ꠔꠞꠦ ꠙꠣꠘꠤ ꠈꠣꠅꠀꠁꠔ। ꠛꠣꠖꠦ ꠙꠣꠔ꠆ꠔꠞꠞꠦ ꠢꠤꠞꠛꠣꠞ ꠇꠥꠀꠞ ꠝꠥꠈꠅ ꠕꠁꠔ। ");
INSERT INTO syls_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","ꠁꠀꠇꠥꠛꠦ ꠔꠣꠞꠣꠞꠦ ꠎꠤꠇꠣꠁꠟꠣ, “ꠜꠣꠁ ꠅꠇꠟ, ꠀꠙꠘꠣꠞꠣ ꠇꠥꠘ ꠎꠣꠉꠣꠞ ꠝꠣꠘꠥꠡ?” ꠔꠣꠞꠣ ꠇꠁꠟꠣ, “ꠢꠣꠞꠣꠘ ꠐꠣꠃꠘꠞ।” ");
INSERT INTO syls_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","ꠅꠃ ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠀꠙꠘꠣꠞꠣ ꠘꠣꠢꠥꠞꠞ ꠘꠣꠔꠤ ꠟꠣꠛꠘꠞꠦ ꠌꠤꠘꠂꠘ ꠘꠤ?” ꠔꠣꠞꠣ ꠇꠁꠟꠣ, “ꠎꠤꠅꠄ, ꠌꠤꠘꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","ꠁꠀꠇꠥꠛꠦ ꠎꠤꠇꠣꠁꠟꠣ, “ꠔꠣꠁꠘ ꠜꠣꠟꠣ ꠀꠍꠂꠘ ꠘꠤ?” ꠔꠣꠞꠣ ꠇꠁꠟꠣ, “ꠎꠤꠅꠄ, ꠜꠣꠟꠣ ꠀꠍꠂꠘ। ꠅꠃꠘꠥ ꠔꠣꠘ ꠙꠥꠠꠤ ꠞꠣꠢꠦꠟꠣꠄ ꠝꠦꠠꠣꠞ ꠙꠣꠟ ꠟꠁꠀ ꠀꠁꠞꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠖꠦꠈꠃꠇ꠆ꠇꠣ, ꠅꠈꠘꠅ ꠛꠃꠔ ꠛꠦꠁꠟ ꠀꠍꠦ। ꠔꠦ ꠙꠡꠥ ꠅꠇꠟ ꠄꠇꠈꠣꠘꠅ ꠅꠁꠛꠣꠞ ꠡꠝꠄ ꠔ ꠅꠁꠍꠦ ꠘꠣ। ꠀꠙꠘꠣꠞꠣ ꠝꠦꠠꠣꠁꠘ꠆ꠔꠞꠦ ꠙꠣꠘꠤ ꠈꠣꠅꠀꠁꠀ ꠢꠤꠞꠛꠣꠞ ꠞꠣꠈꠣꠔ ꠟꠁꠀ ꠎꠣꠁꠘꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","ꠔꠣꠞꠣ ꠇꠁꠟꠣ, “ꠘꠣ, ꠀꠝꠞꠣ ꠁꠟꠣ ꠇꠞꠔꠣꠝ ꠙꠣꠞꠤ ꠘꠣ, ꠢꠇ꠆ꠇꠟ ꠙꠣꠟ ꠄꠇꠈꠣꠘꠅ ꠖꠟꠣ ꠅꠁꠟꠦ ꠛꠣꠖꠦ ꠇꠥꠀꠞ ꠝꠥꠈ ꠕꠘꠦ ꠙꠣꠔ꠆ꠔꠞ ꠢꠞꠣꠁꠀ ꠀꠝꠞꠣ ꠝꠦꠠꠣꠁꠘ꠆ꠔꠞꠦ ꠙꠣꠘꠤ ꠈꠣꠅꠀꠁ।” ");
INSERT INTO syls_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","ꠔꠣꠁꠘ ꠅꠈꠘꠅ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠝꠣꠔꠅ ꠞꠁꠍꠂꠘ, ꠅꠃ ꠡꠝꠄ ꠞꠣꠢꠦꠟꠣꠄ ꠔꠣꠘ ꠛꠣꠚꠞ ꠝꠦꠠꠣꠞ ꠙꠣꠟ ꠟꠁꠀ ꠅꠘꠅ ꠀꠁꠟꠣ, ꠔꠣꠁꠘ ꠁ ꠙꠣꠟꠞ ꠞꠣꠈꠣꠟꠤꠔ ꠀꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","ꠁꠀꠇꠥꠛꠦ ꠔꠣꠘ ꠝꠣꠝꠥ ꠟꠣꠛꠘꠞ ꠙꠥꠠꠤ ꠞꠣꠢꠦꠟꠣꠞꠦ ꠀꠞ ꠔꠣꠘ ꠝꠦꠠꠣꠞ ꠙꠣꠟ ꠖꠦꠈꠤꠀꠃ ꠇꠥꠀꠞ ꠉꠦꠍꠦ ꠉꠤꠀ ꠇꠥꠀꠞ ꠝꠥꠈ ꠕꠘꠦ ꠙꠣꠔ꠆ꠔꠞꠐꠣ ꠢꠞꠣꠁꠀ ꠝꠦꠠꠣꠁꠘ꠆ꠔꠞꠦ ꠙꠣꠘꠤ ꠈꠣꠅꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠞꠣꠢꠦꠟꠣꠞꠦ ꠝꠣꠄꠀ ꠖꠤꠀ ꠎꠥꠞꠦ ꠎꠥꠞꠦ ꠇꠣꠘ꠆ꠖꠤꠔꠣ ꠟꠣꠉꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","ꠀꠞ ꠔꠣꠁꠘ ꠞꠣꠢꠦꠟꠣꠞꠦ ꠇꠁꠟꠣ ꠎꠦꠘ, ꠔꠣꠁꠘ ꠟꠣꠛꠘꠞ ꠜꠣꠁꠉꠘꠣ, ꠞꠦꠛꠦꠇꠣꠞ ꠙꠥꠀ। ꠅꠃ ꠞꠣꠢꠦꠟꠣꠄ ꠖꠃꠠꠣꠁꠀ ꠉꠤꠀ ꠔꠣꠘ ꠛꠣꠚꠞꠦ ꠁ ꠈꠛꠞ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","ꠟꠣꠛꠘꠦ ꠔꠣꠘ ꠜꠣꠁꠉꠘꠣ ꠁꠀꠇꠥꠛꠞ ꠈꠛꠞ ꠢꠥꠘꠤꠀ ꠖꠃꠠꠣꠁꠀ ꠔꠣꠘ ꠟꠉꠦ ꠖꠦꠈꠣ ꠇꠞꠣꠔ ꠀꠁꠟꠣ। ꠔꠣꠘꠞꠦ ꠀꠁꠘ꠆ꠎꠣ ꠇꠞꠤ ꠗꠞꠤꠀ ꠢꠥꠋꠉꠣ ꠖꠤꠀ ꠛꠣꠠꠤꠔ ꠟꠁꠀ ꠉꠦꠟꠣ। ꠉꠤꠀ ꠢꠣꠞꠟꠦ ꠁꠀꠇꠥꠛꠦ ꠟꠣꠛꠘꠞꠦ ꠔꠣꠘ ꠀꠁꠛꠣꠞ ꠢꠇ꠆ꠇꠟꠔꠣ ꠎꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","ꠟꠣꠛꠘꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠔ ꠀꠝꠣꠞꠃ ꠎꠣꠘ ꠀꠞ ꠀꠝꠣꠞꠃ ꠉꠥꠡ꠆ꠔ।” ꠀꠞ ꠁꠀꠇꠥꠛ ꠟꠣꠛꠘꠞ ꠛꠣꠠꠤꠔ ꠄꠇ ꠝꠣꠡ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ꠄꠇ ꠝꠣꠡ ꠛꠣꠖꠦ ꠟꠣꠛꠘꠦ ꠁꠀꠇꠥꠛꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠇꠥꠐꠥꠝ ꠅꠁꠟꠣꠄ ꠇꠞꠤ ꠛꠤꠘꠣ ꠛꠦꠔꠘꠦ ꠀꠝꠣꠞ ꠌꠣꠇꠞꠤ ꠇꠞꠔꠣꠄ ꠘꠤ ꠛꠣ? ꠔꠥꠝꠣꠞꠦ ꠇꠤꠔꠣ ꠖꠤꠔꠣꠝ, ꠇꠁꠟꠣꠅ।” ");
INSERT INTO syls_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","ꠟꠣꠛꠘꠞ ꠖꠥꠁꠐꠣ ꠙꠥꠠꠤ ꠀꠍꠤꠟ। ꠛꠠꠉꠥꠞ ꠘꠣꠝ ꠟꠦꠀ ꠀꠞ ꠢꠥꠞꠥꠉꠥꠞ ꠘꠣꠝ ꠞꠣꠢꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","ꠟꠦꠀꠞ ꠈꠣꠟꠤ ꠌꠃꠈꠃ ꠡꠥꠘ꠆ꠖꠞ ꠀꠍꠤꠟ, ꠅꠁꠟꠦ ꠞꠣꠢꠦꠟꠣꠞ ꠉꠑꠘ ꠀꠞ ꠌꠦꠢꠣꠞꠣ-ꠍꠥꠞꠔ, ꠢꠇ꠆ꠇꠟꠔꠣ ꠡꠥꠘ꠆ꠖꠞ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ꠁꠀꠇꠥꠛꠦ ꠞꠣꠢꠦꠟꠣꠞꠦ ꠙꠍꠘ꠆ꠖ ꠇꠞꠔꠣ ꠇꠞꠤ ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠀꠙꠘꠣꠞ ꠢꠥꠞꠥ ꠙꠥꠠꠤ ꠞꠣꠢꠦꠟꠣꠞ ꠟꠣꠉꠤ ꠀꠝꠤ ꠡꠣꠔ ꠛꠞꠍ ꠀꠙꠘꠣꠞ ꠉꠥꠟꠣꠝꠤ ꠇꠞꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","ꠟꠣꠛꠘꠦ ꠇꠁꠟꠣ, “ꠞꠣꠢꠦꠟꠣꠞꠦ ꠝꠣꠘꠡꠞ ꠀꠔꠅ ꠖꠦꠅꠀꠞ ꠌꠣꠁꠔꠦ ꠔꠥꠝꠣꠞ ꠉꠦꠍꠦ ꠖꠦꠅꠀꠃ ꠜꠣꠟꠣ। ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠞꠅ।” ");
INSERT INTO syls_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","ꠔꠦꠃ ꠁꠀꠇꠥꠛꠦ ꠞꠣꠢꠦꠟꠣꠞ ꠟꠣꠉꠤ ꠡꠣꠔ ꠛꠞꠍ ꠉꠥꠟꠣꠝꠤ ꠇꠞꠟꠣ। ꠞꠣꠢꠦꠟꠣꠞꠦ ꠝꠢꠛ꠆ꠛꠔ ꠇꠞꠔꠣ ꠇꠞꠤ, ꠁꠔꠣ ꠄꠇꠅ ꠛꠞꠍ ꠔꠣꠘ ꠉꠦꠍꠦ ꠄꠇ ꠖꠤꠘꠞ ꠢꠝꠣꠘ ꠝꠘꠅ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ꠢꠦꠡꠦ ꠔꠣꠁꠘ ꠟꠣꠛꠘꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠉꠥꠟꠣꠝꠤꠞ ꠝꠤꠀꠖ ꠙꠥꠞꠤ ꠉꠦꠍꠦ। ꠅꠈꠘ ꠀꠝꠣꠞ ꠛꠃꠞꠦ ꠀꠝꠣꠞ ꠀꠔꠅ ꠡꠝꠎꠣꠁꠀ ꠖꠦꠃꠇ꠆ꠇꠣ, ꠀꠝꠤ ꠔꠣꠁꠞ ꠉꠦꠍꠦ ꠞꠁꠔꠣꠝ ꠌꠣꠁ।” ");
INSERT INTO syls_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","ꠔꠦꠃ ꠟꠣꠛꠘꠦ ꠢꠃ ꠄꠟꠣꠇꠣꠞ ꠢꠇꠟ ꠝꠣꠘꠡꠞꠦ ꠛꠤꠀꠞ ꠖꠣꠅꠔ ꠇꠞꠤꠀ ꠈꠣꠘꠣ-ꠖꠣꠘꠣ ꠈꠣꠅꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","ꠢꠦꠡꠦ ꠞꠣꠁꠔ ꠅꠁꠟꠦ ꠔꠣꠁꠘ ꠔꠣꠘ ꠙꠥꠠꠤ ꠟꠦꠀꠞꠦ ꠁꠀꠇꠥꠛꠞ ꠉꠦꠍꠦ ꠖꠤꠟꠣ, ꠀꠞ ꠁꠀꠇꠥꠛꠦ ꠄꠘ ꠟꠉꠦ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","ꠟꠣꠛꠘꠦ ꠘꠤꠎꠞ ꠛꠣꠘ꠆ꠖꠤ ꠎꠤꠟꠙꠣꠞꠦ, ꠔꠣꠘ ꠙꠥꠠꠤ ꠟꠦꠀꠞ ꠛꠣꠘ꠆ꠖꠤ ꠉꠤꠞꠤꠔ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","ꠅꠁꠟꠦ ꠛꠤꠀꠘꠦ ꠃꠑꠤꠀ ꠖꠦꠈꠂꠘ, ꠄꠁꠘ ꠔ ꠟꠦꠀ। ꠔꠦꠃ ꠁꠀꠇꠥꠛꠦ ꠟꠣꠛꠘꠞꠦ ꠇꠁꠟꠣ, “ꠀꠙꠘꠦ ꠀꠝꠣꠞ ꠟꠉꠦ ꠁꠔꠣ ꠇꠥꠘ ꠎꠣꠔꠞ ꠇꠣꠝ ꠇꠞꠟꠣ? ꠅꠔ ꠖꠤꠘ ꠀꠝꠤ ꠞꠣꠢꠦꠟꠣꠞ ꠟꠣꠉꠤ ꠀꠙꠘꠣꠞ ꠉꠥꠟꠣꠝꠤ ꠇꠞꠍꠤ ꠘꠣꠄ ꠘꠤ? ꠔꠦ ꠀꠝꠣꠞꠦ ꠗꠥꠇꠣ ꠖꠤꠟꠣ ꠇꠦꠘꠦ?” ");
INSERT INTO syls_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","ꠟꠣꠛꠘꠦ ꠇꠁꠟꠣ, “ꠛꠠ ꠙꠥꠠꠤꠞ ꠀꠉꠦ ꠢꠥꠞꠥ ꠙꠥꠠꠤꠞ ꠛꠤꠀ ꠖꠦꠅꠀ ꠀꠝꠞꠣꠞ ꠖꠦꠡꠞ ꠌꠟ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","ꠔꠥꠝꠤ ꠛꠤꠀꠞ ꠈꠥꠡꠤ-ꠛꠣꠡꠤꠞ ꠢꠣꠙ꠆ꠔꠣꠐꠣ ꠙꠣꠞ ꠅꠁꠔꠦ ꠖꠦꠅ। ꠔꠦꠃ ꠢꠤ ꠙꠥꠠꠤꠞꠦꠅ ꠔꠥꠝꠣꠞ ꠉꠦꠍꠦ ꠛꠤꠀ ꠖꠤꠝꠥ, ꠅꠁꠟꠦ ꠔꠥꠝꠤ ꠀꠞꠅ ꠡꠣꠔ ꠛꠞꠍ ꠀꠝꠣꠞ ꠉꠥꠟꠣꠝꠤ ꠇꠞꠔꠦ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","ꠁꠀꠇꠥꠛꠦ ꠔꠣꠘ ꠇꠕꠣ ꠝꠣꠘꠤꠀ ꠅꠃ ꠈꠥꠡꠤ-ꠛꠣꠡꠤꠞ ꠢꠣꠙ꠆ꠔꠣ ꠙꠣꠞ ꠇꠞꠟꠣ। ꠛꠣꠖꠦ ꠟꠣꠛꠘꠦ ꠔꠣꠘ ꠙꠥꠠꠤ ꠞꠣꠢꠦꠟꠣꠞꠦꠅ ꠁꠀꠇꠥꠛꠞ ꠉꠦꠍꠦ ꠡꠣꠖꠤ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","ꠀꠞ ꠔꠣꠘ ꠛꠣꠘ꠆ꠖꠤ ꠛꠤꠟꠢꠣꠞꠦ ꠞꠣꠢꠦꠟꠣꠞ ꠛꠣꠘ꠆ꠖꠤ ꠉꠤꠞꠤꠔ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","ꠁꠀꠇꠥꠛꠦ ꠞꠣꠢꠦꠟꠣꠞ ꠟꠉꠦꠅ ꠞꠁꠟꠣ, ꠔꠣꠁꠘ ꠟꠦꠀꠞ ꠌꠣꠁꠔꠦ ꠞꠣꠢꠦꠟꠣꠞꠦ ꠛꠦꠡꠤ ꠝꠣꠄꠀ ꠇꠞꠔꠣ। ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠀꠞꠅ ꠡꠣꠔ ꠛꠞꠍ ꠔꠣꠘ ꠝꠣꠝꠥ ꠟꠣꠛꠘꠞ ꠉꠥꠟꠣꠝꠤ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","ꠅꠁꠟꠦ ꠟꠦꠀꠞꠦ ꠝꠣꠄꠀ ꠘꠣ ꠇꠞꠣꠄ, ꠝꠣꠛꠥꠖꠦ ꠟꠦꠀꠞꠦ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠙꠄꠖꠣꠞ ꠈꠦꠝꠔꠣ ꠖꠤꠟꠣ, ꠀꠞ ꠞꠣꠢꠦꠟꠣ ꠘꠤꠀꠅꠟꠣꠖꠤ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","ꠀꠞ ꠟꠦꠀꠞ ꠊꠞꠅ ꠄꠇ ꠙꠥꠀ ꠅꠁꠟ। ꠔꠣꠁꠘ ꠙꠥꠀꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠞꠥꠛꠦꠘ ꠝꠣꠘꠤ, ꠙꠥꠀꠞꠦ ꠖꠦꠈꠅ। ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞ ꠖꠥꠈ ꠖꠦꠈꠍꠂꠘ, ꠅꠈꠘ ꠘꠤꠌ꠆ꠌꠄ ꠀꠝꠣꠞ ꠎꠣꠝꠣꠁꠄ ꠀꠝꠣꠞꠦ ꠝꠣꠄꠀ ꠇꠞꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","ꠛꠣꠖꠦ ꠢꠤꠞꠛꠣꠞ ꠔꠣꠘ ꠊꠞꠅ ꠄꠇ ꠙꠥꠀ ꠅꠁꠟ। ꠔꠣꠁꠘ ꠙꠥꠀꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠡꠤꠝꠤꠅꠘ ꠝꠣꠘꠤ, ꠢꠥꠘꠂꠘ, ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞꠦ ꠄꠟꠣꠝꠤ ꠇꠞꠣꠞ ꠇꠕꠣ ꠝꠣꠛꠥꠖꠦ ꠢꠥꠘꠍꠂꠘ, ꠄꠞꠟꠣꠉꠤ ꠔꠣꠁꠘ ꠀꠝꠣꠞꠦ ꠅꠃ ꠙꠥꠀ ꠖꠤꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","ꠛꠣꠖꠦ ꠢꠤꠞꠛꠣꠞ ꠔꠣꠘ ꠊꠞꠅ ꠄꠇ ꠙꠥꠀ ꠅꠁꠟ। ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠅꠈꠘ ꠀꠝꠣꠞ ꠎꠣꠝꠣꠁꠄ ꠀꠝꠣꠞ ꠟꠉꠦ ꠀꠡꠤꠇ ꠅꠁꠛꠣ, ꠔꠣꠘ ꠔꠤꠘꠐꠣ ꠙꠥꠀ ꠀꠝꠣꠞ ꠙꠦꠐ ꠕꠘꠦ ꠙꠄꠖꠣ ꠅꠁꠟ।” ꠅꠃ ꠄꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠟꠦꠛꠤ ꠝꠣꠘꠤ, ꠀꠡꠤꠇ। ");
INSERT INTO syls_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","ꠛꠣꠖꠦ ꠢꠤꠞꠛꠣꠞ ꠔꠣꠘ ꠀꠞꠅ ꠄꠇ ꠙꠥꠀ ꠅꠁꠟꠦ ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠁꠚꠤꠞꠣ ꠀꠝꠤ ꠝꠣꠛꠥꠖꠞ ꠔꠣꠞꠤꠚ ꠇꠞꠝꠥ।” ꠀꠞ ꠔꠣꠁꠘ ꠅꠃ ꠙꠥꠀꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠄꠢꠥꠖꠣ ꠝꠣꠘꠤ, ꠔꠣꠞꠤꠚ। ꠄꠞꠛꠣꠖꠦ ꠔꠣꠘ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠅꠀ ꠛꠘ꠆ꠖ ꠅꠁꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","ꠞꠣꠢꠦꠟꠣꠄ ꠎꠦꠛꠟꠣ ꠖꠦꠈꠟꠣ, ꠔꠣꠘ ꠊꠞꠅ ꠁꠀꠇꠥꠛꠞ ꠇꠥꠘꠥ ꠀꠅꠟꠣꠖ ꠅꠁꠞꠣ ꠘꠣ, ꠅꠃ ꠡꠝꠄ ꠔꠣꠘ ꠛꠘꠤꠞ ꠛꠣꠄ ꠁꠋꠡꠣ ꠙꠄꠖꠣ ꠅꠁꠟ। ꠔꠣꠁꠘ ꠁꠀꠇꠥꠛꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞꠦ ꠀꠅꠟꠣꠖ ꠖꠦꠅ, ꠘꠣꠁꠟꠦ ꠀꠝꠤ ꠝꠞꠤꠎꠤꠝꠥ!” ");
INSERT INTO syls_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","ꠔꠦꠃ ꠞꠣꠢꠦꠟꠣꠞ ꠟꠉꠦ ꠁꠀꠇꠥꠛꠦ ꠈꠥꠛ ꠉꠥꠍꠣ ꠇꠞꠤꠀ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠇꠥꠘꠥ ꠀꠟ꠆ꠟꠣ ꠘꠤ? ꠔꠣꠁꠘꠃ ꠔ ꠔꠥꠝꠣꠞ ꠙꠦꠐ ꠛꠘ꠆ꠖ ꠇꠞꠤ ꠖꠤꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","ꠞꠣꠢꠦꠟꠣꠄ ꠇꠁꠟꠣ, “ꠢꠥꠘꠃꠇ꠆ꠇꠣ, ꠀꠝꠣꠞ ꠛꠣꠘ꠆ꠖꠤ ꠛꠤꠟꠢꠣ ꠅꠘꠅ ꠀꠍꠦ, ꠀꠙꠘꠦ ꠔꠣꠁꠞ ꠉꠦꠍꠦ ꠎꠣꠃꠇ꠆ꠇꠣ, ꠔꠣꠁꠞꠦꠖꠤ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠙꠣꠁꠀ ꠀꠝꠤꠅ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠀꠟꠣ ꠅꠁꠎꠤꠔꠣꠝ ꠙꠣꠞꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","ꠅꠈꠣꠘ ꠇꠁꠀ ꠢꠣꠞꠤ ꠞꠣꠢꠦꠟꠣꠄ ꠔꠣꠘ ꠛꠣꠘ꠆ꠖꠤ ꠛꠤꠟꠢꠣꠞꠦ ꠁꠀꠇꠥꠛꠞ ꠉꠦꠍꠦ ꠢꠣꠋꠉꠣ ꠖꠤꠟꠣ, ꠀꠞ ꠁꠀꠇꠥꠛ ꠔꠣꠁꠞ ꠉꠦꠍꠦ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ꠔꠦꠃ ꠛꠤꠟꠢꠣꠞ ꠊꠞꠅ ꠁꠀꠇꠥꠛꠞ ꠄꠇ ꠙꠥꠀ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","ꠀꠞ ꠞꠣꠢꠦꠟꠣꠄ ꠇꠁꠟꠣ, “ꠀꠟ꠆ꠟꠣꠄ ꠀꠝꠣꠞꠦ ꠁꠘꠍꠣꠚ ꠇꠞꠍꠂꠘ, ꠀꠞ ꠀꠝꠣꠞ ꠀꠢꠣꠎꠣꠞꠤ ꠢꠥꠘꠤꠀ ꠄꠉꠥ ꠙꠥꠀ ꠖꠤꠍꠂꠘ।” ꠔꠣꠁꠘ ꠁ ꠙꠥꠀꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠖꠣꠘ ꠝꠣꠘꠤ, ꠁꠘꠍꠣꠚ। ");
INSERT INTO syls_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","ꠛꠣꠖꠦ ꠞꠣꠢꠦꠟꠣꠞ ꠛꠣꠘ꠆ꠖꠤ ꠛꠤꠟꠢꠣꠞ ꠊꠞꠅ ꠢꠤꠞꠛꠣꠞ ꠁꠀꠇꠥꠛꠞ ꠖꠥꠍꠞꠣ ꠙꠥꠀ ꠙꠄꠖꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","ꠀꠞ ꠞꠣꠢꠦꠟꠣꠄ ꠇꠁꠟꠣ, “ꠛꠁꠘꠞ ꠟꠉꠦ ꠝꠢꠣ ꠟꠣꠠꠣꠁꠔ ꠀꠝꠤ ꠎꠤꠔꠍꠤ।” ꠅꠃ ꠔꠣꠁꠘ ꠁ ꠙꠥꠀꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠘꠙ꠆ꠔꠣꠟꠤ ꠝꠣꠘꠤ, ꠟꠣꠠꠣꠁ। ");
INSERT INTO syls_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","ꠟꠦꠀꠄ ꠎꠦꠛꠟꠣ ꠖꠦꠈꠟꠣ ꠔꠣꠘ ꠊꠞꠅ ꠀꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠅꠁꠞꠣ ꠘꠣ, ꠔꠦꠃ ꠔꠣꠁꠘꠅ ꠔꠣꠘ ꠛꠣꠘ꠆ꠖꠤ ꠎꠤꠟꠙꠣꠞꠦ ꠁꠀꠇꠥꠛꠞ ꠉꠦꠍꠦ ꠢꠣꠋꠉꠣ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ꠔꠦꠃ ꠟꠦꠀꠞ ꠛꠣꠘ꠆ꠖꠤ ꠎꠤꠟꠙꠣꠞ ꠙꠦꠐꠅ ꠁꠀꠇꠥꠛꠞ ꠄꠇ ꠙꠥꠀ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","ꠀꠞ ꠟꠦꠀꠄ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠇꠙꠣꠟ ꠈꠥꠟꠍꠦ!” ꠔꠣꠁꠘ ꠄꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠍꠣꠖꠥ ꠝꠣꠘꠤ, ꠇꠙꠣꠟ। ");
INSERT INTO syls_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ꠛꠣꠖꠦ ꠟꠦꠀꠞ ꠛꠣꠘ꠆ꠖꠤ ꠎꠤꠟꠙꠣꠞ ꠊꠞꠅ ꠁꠀꠇꠥꠛꠞ ꠀꠞꠇ ꠙꠥꠀ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","ꠀꠞ ꠟꠦꠀꠄ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠇꠔ ꠡꠥꠈ! ꠢꠇꠟ ꠛꠦꠐꠤꠘ꠆ꠔꠦ ꠀꠝꠣꠞꠦ ꠡꠥꠈꠤ ꠇꠁꠛꠣ।” ꠔꠦꠃ ꠔꠣꠁꠘ ꠁ ꠙꠥꠀꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠀꠡꠤꠞ ꠝꠣꠘꠤ, ꠡꠥꠈꠤ। ");
INSERT INTO syls_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","ꠉꠝ ꠖꠣꠅꠀꠞ ꠡꠝꠄ ꠞꠥꠛꠦꠘꠦ ꠛꠘ꠆ꠖꠅ ꠉꠤꠀ ꠇꠤꠍꠥ ꠗꠥꠔꠞꠣ-ꠉꠥꠐꠣ ꠙꠣꠁꠀ, ꠔꠣꠘ ꠝꠣ ꠟꠦꠀꠞ ꠉꠦꠍꠦ ꠀꠘꠤꠀ ꠖꠤꠟꠣ। ꠀꠞ ꠞꠣꠢꠦꠟꠣꠄ ꠟꠦꠀꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠙꠥꠀꠞ ꠇꠄꠉꠥ ꠗꠥꠔꠞꠣ-ꠉꠥꠐꠣ ꠀꠝꠣꠞꠦ ꠖꠦꠅꠌꠣꠁꠘ।” ");
INSERT INTO syls_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","ꠟꠦꠀꠄ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠎꠣꠝꠣꠁꠞꠦ ꠖꠈꠟ ꠇꠞꠍ, ꠁꠔꠣꠄ ꠅꠁꠍꠦ ꠘꠣ ꠘꠤ? ꠅꠈꠘ ꠀꠝꠣꠞ ꠙꠥꠀꠞ ꠗꠥꠔꠞꠣ-ꠉꠥꠐꠣꠅ ꠌꠣꠁꠞꠣꠄ ꠘꠤ?” ꠞꠣꠢꠦꠟꠣꠄ ꠇꠁꠟꠣ, “ꠔꠣꠁꠟꠦ ꠔꠥꠝꠣꠞ ꠙꠥꠀꠞ ꠗꠥꠔꠞꠣ-ꠉꠥꠐꠣꠞ ꠛꠖꠟꠣ ꠀꠁꠎ ꠞꠣꠁꠔ ꠔꠣꠁꠘ ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠞꠁꠛꠣ ꠘꠦ।” ");
INSERT INTO syls_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ꠢꠣꠁꠘ꠆ꠎꠣ ꠛꠣꠟꠣ ꠁꠀꠇꠥꠛꠦ ꠛꠘ꠆ꠖꠅ ꠕꠘꠦ ꠀꠁꠔꠦꠃ ꠟꠦꠀꠄ ꠛꠣꠞ ꠅꠁꠀ ꠔꠣꠘꠦ ꠇꠁꠟꠣ, “ꠀꠁꠎ ꠀꠝꠣꠞ ꠟꠉꠦ ꠞꠁꠛꠣꠄ, ꠇꠣꠞꠘ ꠀꠝꠣꠞ ꠙꠥꠀꠞ ꠗꠥꠔꠞꠣ-ꠉꠥꠐꠣꠞ ꠛꠖꠟꠣ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠀꠅꠟꠣꠔ ꠘꠤꠍꠤ।” ꠅꠃ ꠢꠤ ꠞꠣꠁꠔ ꠔꠣꠁꠘ ꠟꠦꠀꠞ ꠊꠞꠅ ꠢꠥꠔꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","ꠀꠟ꠆ꠟꠣꠄ ꠟꠦꠀꠞ ꠖꠥꠀ ꠇꠛꠥꠟ ꠇꠞꠣꠄ, ꠔꠣꠘ ꠊꠞꠅ ꠁꠀꠇꠥꠛꠞ ꠙꠣꠌ ꠘꠝ꠆ꠛꠞ ꠙꠥꠀꠞ ꠎꠘꠝ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","ꠅꠃ ꠟꠦꠀꠄ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠎꠣꠝꠣꠁꠞ ꠉꠦꠍꠦ ꠀꠝꠣꠞ ꠛꠣꠘ꠆ꠖꠤꠞꠦ ꠖꠤꠍꠟꠣꠝ ꠇꠞꠤ, ꠀꠟ꠆ꠟꠣꠄ ꠀꠝꠣꠞꠦ ꠄꠞ ꠛꠖꠟꠣ ꠖꠤꠟꠣ।” ꠄꠞꠟꠣꠉꠤ ꠔꠣꠁꠘ ꠁ ꠙꠥꠀꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠁꠍꠣꠈꠞ ꠝꠣꠘꠤ, ꠛꠖꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","ꠛꠣꠖꠦ ꠢꠤꠞꠛꠣꠞ ꠟꠦꠀꠞ ꠊꠞꠅ ꠁꠀꠇꠥꠛꠞ ꠍꠄ ꠘꠝ꠆ꠛꠞ ꠙꠥꠀꠞ ꠎꠘꠝ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","ꠟꠦꠀꠄ ꠇꠁꠟꠣ, “ꠀꠟ꠆ꠟꠣꠄ ꠀꠝꠣꠞꠦ ꠛꠃꠔ ꠛꠠ ꠄꠇ ꠘꠤꠀꠝꠔ ꠖꠤꠟꠣ। ꠅꠈꠘ ꠀꠝꠣꠞ ꠎꠣꠝꠣꠁꠄ ꠀꠝꠣꠞꠦ ꠖꠣꠝ ꠖꠤꠛꠣ, ꠇꠣꠞꠘ ꠀꠝꠤ ꠔꠣꠘ ꠍꠄꠉꠥ ꠙꠥꠀꠞ ꠎꠘꠝ ꠖꠤꠍꠤ।” ꠔꠣꠁꠘ ꠁ ꠙꠥꠀꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠍꠛꠥꠟꠘ ꠝꠣꠘꠤ, ꠖꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ꠢꠦꠡꠦ ꠟꠦꠀꠞ ꠄꠇ ꠙꠥꠠꠤ ꠅꠁꠟ, ꠔꠣꠁꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠖꠤꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","ꠀꠟ꠆ꠟꠣꠄ ꠞꠣꠢꠦꠟꠣꠞ ꠛꠣꠄꠅ ꠈꠤꠀꠟ ꠇꠞꠟꠣ। ꠔꠣꠁꠘ ꠞꠣꠢꠦꠟꠣꠞ ꠖꠥꠀ ꠇꠛꠥꠟ ꠇꠞꠤꠀ, ꠔꠣꠘꠞꠦ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠙꠄꠖꠣꠞ ꠔꠣꠇ꠆ꠇꠔ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","ꠀꠞ ꠞꠣꠢꠦꠟꠣꠞ ꠊꠞꠅ ꠄꠇ ꠙꠥꠀ ꠅꠁꠟꠦ ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠀꠟ꠆ꠟꠣꠄ ꠀꠝꠣꠞ ꠡꠞꠝ ꠢꠞꠣꠁꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ꠔꠣꠁꠘ ꠁ ꠙꠥꠀꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠁꠃꠍꠥꠚ ꠝꠣꠘꠤ, ꠛꠣꠠꠣꠘꠤ। ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞꠦ ꠀꠞꠅꠉꠥ ꠙꠥꠀ ꠛꠣꠠꠣꠁ ꠖꠦꠃꠇ꠆ꠇꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","ꠞꠣꠢꠦꠟꠣꠞ ꠊꠞꠅ ꠁꠃꠍꠥꠚ ꠅꠀꠞ ꠛꠣꠖꠦ, ꠁꠀꠇꠥꠛꠦ ꠟꠣꠛꠘꠞꠦ ꠇꠁꠟꠣ, “ꠅꠈꠘ ꠀꠝꠣꠞꠦ ꠛꠤꠖꠣꠄ ꠖꠤꠟꠣꠃꠇ꠆ꠇꠣ, ꠀꠝꠤ ꠘꠤꠎꠞ ꠖꠦꠡꠞ ꠛꠣꠠꠤꠔ ꠎꠣꠁꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","ꠀꠙꠘꠦ ꠔ ꠎꠣꠘꠂꠘ, ꠀꠝꠤ ꠇꠤꠟꠣ ꠀꠙꠘꠣꠞ ꠉꠥꠟꠣꠝꠤ ꠇꠞꠍꠤ, ꠀꠝꠤ ꠀꠝꠣꠞ ꠛꠃꠀꠁꠘ ꠀꠞ ꠙꠥꠀ-ꠙꠥꠠꠤꠞ ꠟꠣꠉꠤ ꠀꠙꠘꠣꠞ ꠉꠥꠟꠣꠝꠤ ꠇꠞꠍꠤ। ꠅꠈꠘ ꠔꠣꠞꠣꠞꠦ ꠟꠁꠀ ꠀꠝꠣꠞꠦ ꠎꠣꠁꠔꠦ ꠖꠦꠃꠇ꠆ꠇꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","ꠟꠣꠛꠘꠦ ꠔꠣꠘꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠟꠣꠉꠤ ꠎꠥꠖꠤ ꠔꠥꠝꠣꠞ ꠝꠣꠄꠀ ꠕꠣꠇꠦ, ꠔꠦ ꠎꠣꠁꠅ ꠘꠣ। ꠀꠝꠤ ꠀꠟꠣꠝꠔꠦ ꠛꠥꠎꠤꠀꠞ ꠎꠦꠘ, ꠔꠥꠝꠣꠞ ꠈꠣꠔꠤꠞꠦ ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞꠦꠅ ꠛꠞꠇꠔ ꠘꠣꠎꠤꠟ ꠇꠞꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","ꠔꠥꠝꠣꠞ ꠛꠦꠔꠘ ꠔꠥꠝꠤ ꠘꠤꠎꠦꠃ ꠇꠁꠟꠣꠅ। ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠅꠟꠣꠃ ꠖꠤꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","ꠅꠃ ꠁꠀꠇꠥꠛꠦ ꠔꠣꠘꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠇꠤꠟꠣ ꠀꠙꠘꠣꠞ ꠉꠥꠟꠣꠝꠤ ꠇꠞꠍꠤ, ꠀꠞ ꠀꠝꠣꠞ ꠀꠔꠅ ꠀꠙꠘꠣꠞ ꠙꠡꠥꠞ ꠙꠣꠟ ꠇꠤꠟꠣꠈꠣꠘ ꠅꠁꠍꠦ, ꠁꠔꠣ ꠀꠙꠘꠦꠃ ꠎꠣꠘꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","ꠀꠝꠤ ꠀꠅꠀꠞ ꠀꠉꠦ ꠀꠙꠘꠦ ꠉꠞꠤꠛ ꠀꠍꠟꠣ। ꠀꠞ ꠅꠈꠘ ꠔ ꠛꠣꠠꠤꠀ ꠛꠃꠔꠔꠣ ꠅꠁꠍꠦ। ꠀꠝꠣꠞ ꠇꠣꠞꠘꠦ ꠝꠣꠛꠥꠖꠦ ꠀꠙꠘꠣꠞꠦ ꠛꠃꠔ ꠛꠞꠇꠔ ꠖꠤꠍꠂꠘ। ꠅꠁꠟꠦ ꠀꠝꠣꠞ ꠘꠤꠎꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠟꠣꠉꠤ ꠇꠥꠘꠖꠤꠘ ꠇꠣꠝꠣꠁ ꠇꠞꠔꠣꠝ?” ");
INSERT INTO syls_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","ꠔꠦꠃ ꠟꠣꠛꠘꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠇꠤꠔꠣ ꠖꠤꠔꠣꠝ?” ꠁꠀꠇꠥꠛꠦ ꠇꠁꠟꠣ, “ꠀꠙꠘꠦ ꠀꠝꠣꠞꠦ ꠇꠥꠘ꠆ꠔꠣꠃ ꠘꠣ ꠖꠤꠀ ꠎꠥꠖꠤ ꠀꠝꠣꠞ ꠄꠉꠥ ꠝꠣꠔ ꠞꠣꠈꠂꠘ, ꠔꠦ ꠀꠝꠤ ꠢꠤꠞꠛꠣꠞ ꠀꠙꠘꠣꠞ ꠙꠡꠥꠞ ꠙꠣꠟꠞ ꠈꠦꠎꠝꠔ ꠇꠞꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","ꠀꠝꠤ ꠀꠁꠎ ꠀꠙꠘꠣꠞ ꠙꠡꠥꠞ ꠙꠣꠟꠞ ꠝꠣꠎꠦ ꠉꠤꠀ, ꠚꠥꠐꠣ ꠚꠥꠐꠣ ꠖꠣꠉꠀꠟꠣ ꠀꠞ ꠇꠣꠟꠣ ꠀꠞ ꠍꠤꠔ꠆ꠞꠣ ꠝꠦꠠꠣꠁꠘ ꠀꠞ ꠍꠣꠉꠟꠞ ꠝꠣꠎꠦ ꠍꠤꠔ꠆ꠞꠣ ꠀꠞ ꠚꠥꠐꠣ ꠚꠥꠐꠣ ꠞꠋꠉꠞ ꠢꠇ꠆ꠇꠟꠐꠤ ꠀꠝꠣꠞ ꠛꠦꠔꠘ ꠛꠣꠛꠔ ꠘꠤꠝꠥꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","ꠔꠦꠃ ꠀꠙꠘꠦ ꠎꠦꠛꠟꠣꠃ ꠛꠦꠔꠘꠞ ꠇꠣꠞꠘꠦ ꠀꠁꠛꠣ, ꠁ ꠡꠝꠄ ꠖꠦꠈꠛꠣ, ꠀꠝꠣꠞ ꠁꠝꠣꠘꠖꠣꠞꠤꠄ ꠀꠝꠣꠞ ꠟꠣꠉꠤ ꠎꠥꠀꠙ ꠖꠤꠛ। ꠀꠞ ꠚꠥꠐꠣ ꠚꠥꠐꠣ ꠖꠣꠉꠀꠟꠣ ꠀꠞ ꠇꠣꠟꠣ ꠀꠞ ꠍꠤꠔ꠆ꠞꠣ ꠝꠦꠠꠣꠁꠘ ꠀꠞ ꠍꠣꠉꠟꠞ ꠝꠣꠎꠦ ꠍꠤꠔ꠆ꠞꠣ ꠀꠞ ꠚꠥꠐꠣ ꠚꠥꠐꠣ ꠞꠋꠉꠞꠔꠣ ꠍꠣꠠꠣ ꠀꠞ ꠇꠥꠘ꠆ꠔꠣ ꠙꠣꠁꠟꠦ ꠝꠘꠅ ꠇꠞꠛꠣ, ꠀꠝꠤ ꠌꠥꠞꠤ ꠇꠞꠍꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","ꠅꠃ ꠟꠣꠛꠘꠦ ꠇꠁꠟꠣ, “ꠀꠁꠌ꠆ꠍꠣ, ꠔꠥꠝꠣꠞ ꠇꠕꠣꠃ ꠑꠤꠇ ꠕꠣꠇꠃꠇ।” ");
INSERT INTO syls_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","ꠟꠣꠛꠘꠦ ꠢꠃ ꠖꠤꠘꠃ ꠙꠣꠟ ꠕꠣꠇꠤ ꠟꠣꠝ꠆ꠛꠣ ꠖꠣꠉꠀꠟꠣ ꠀꠞ ꠍꠤꠔ꠆ꠞꠣ ꠍꠣꠉꠟ, ꠚꠥꠐꠣ ꠚꠥꠐꠣ ꠖꠣꠉ ꠀꠞ ꠍꠤꠔ꠆ꠞꠣ ꠕꠥꠠꠣ ꠕꠥꠠꠣ ꠗꠟꠣ ꠍꠣꠉꠤꠘ ꠀꠞ ꠇꠣꠟꠣ ꠝꠦꠠꠣ ꠅꠇꠟ ꠀꠟꠉꠣꠁꠀ ꠘꠤꠎꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠉꠦꠍꠦ ꠖꠤꠟꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ꠖꠤꠀ ꠔꠣꠁꠘ ꠁꠀꠇꠥꠛꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠔꠤꠘ ꠖꠤꠘꠞ ꠙꠕ ꠖꠥꠞꠁ ꠢꠞꠤꠀ ꠉꠦꠟꠣꠉꠤ ꠀꠞ ꠁꠀꠇꠥꠛꠦ ꠟꠣꠛꠘꠞ ꠛꠣꠇꠤ ꠙꠣꠟ ꠅꠇꠟꠞꠦ ꠞꠣꠈꠣꠔ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","ꠁꠀꠇꠥꠛꠦ ꠟꠤꠛꠘꠤ, ꠟꠣꠃꠎ ꠀꠞ ꠀꠞ꠆ꠝꠥꠘ ꠉꠣꠍꠞ ꠇꠣꠌꠣ ꠒꠣꠟ ꠇꠣꠐꠤꠀ ꠃꠙꠞꠦ ꠕꠣꠇꠤ ꠛꠣꠇꠟ ꠚꠣꠟꠣꠁꠀ ꠒꠣꠟꠞ ꠝꠣꠎꠦ ꠟꠣꠝ꠆ꠛꠣ ꠟꠣꠝ꠆ꠛꠣ ꠗꠟꠣ ꠖꠣꠉ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","ꠍꠣꠉꠟꠞ ꠙꠣꠟꠦ ꠀꠁꠀ ꠎꠦꠈꠣꠘꠅ ꠙꠣꠘꠤ ꠈꠣꠁꠘ, ꠔꠣꠁꠘ ꠅꠃ ꠛꠣꠇꠟ ꠚꠣꠟꠣꠁꠟ ꠖꠣꠉꠀꠟꠣ ꠒꠣꠟ ꠅꠇꠟ, ꠢꠘꠅ ꠙꠣꠘꠤꠞ ꠉꠣꠝꠟꠣꠞ ꠍꠣꠝꠘꠦ ꠕꠁꠟꠣ। ꠀꠞ ꠙꠣꠘꠤ ꠈꠣꠅꠀꠞ ꠡꠝꠄ ꠄꠞꠣ ꠚꠣꠟ ꠈꠣꠁꠔ। ");
INSERT INTO syls_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ꠔꠦꠃ ꠅꠃ ꠒꠣꠟꠞ ꠉꠦꠍꠦ ꠀꠁꠀ ꠚꠣꠟ ꠈꠣꠅꠀꠄ ꠔꠣꠞꠣꠞ ꠛꠣꠁꠌ꠆ꠌꠣꠁꠘꠅ ꠍꠤꠔ꠆ꠞꠣ, ꠟꠣꠝ꠆ꠛꠣ ꠖꠣꠉꠀꠟꠣ ꠀꠞ ꠚꠥꠐꠣ ꠚꠥꠐꠣ ꠞꠋꠉꠞ ꠅꠁꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠅꠃ ꠛꠣꠁꠌ꠆ꠌꠣꠁꠘ ꠀꠟꠉꠣꠁꠔꠣ, ꠀꠞ ꠟꠣꠛꠘꠞ ꠒꠥꠞꠣꠀꠟꠣ ꠀꠞ ꠇꠣꠟꠣ ꠝꠦꠠꠣꠁꠘ꠆ꠔꠞ ꠛꠣꠄ ꠝꠦꠠꠤꠘ꠆ꠔꠞ ꠌꠃꠈ ꠞꠣꠈꠣꠁꠔꠣ। ꠅꠃ ꠟꠣꠈꠣꠘ ꠔꠣꠁꠘ, ꠔꠣꠘ ꠘꠤꠎꠞ ꠙꠣꠟꠞꠦ ꠟꠣꠛꠘꠞ ꠙꠣꠟꠞ ꠟꠉꠦ ꠝꠤꠟꠣꠁꠔꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","ꠀꠞ ꠎꠥꠞꠀꠟꠣ ꠝꠦꠠꠤ-ꠍꠣꠉꠤꠘ꠆ꠔꠦ ꠚꠣꠟ ꠈꠣꠅꠀꠞ ꠡꠝꠄ, ꠔꠣꠁꠘ ꠉꠣꠝꠟꠣꠔ ꠔꠣꠞꠣꠞ ꠌꠃꠈꠞ ꠍꠣꠝꠘꠦ ꠅꠃ ꠒꠣꠟ ꠅꠇꠟ ꠕꠁꠔꠣ, ");
INSERT INTO syls_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ꠅꠁꠟꠦ ꠇꠝꠎꠥꠞ ꠙꠡꠥꠞ ꠍꠣꠝꠘꠦ ꠁ ꠒꠣꠟꠣꠁꠘ ꠕꠁꠔꠣ ꠘꠣ। ꠔꠦꠃ ꠟꠣꠛꠘꠞ ꠙꠡꠥꠁꠘ ꠅꠁꠔꠣ ꠇꠝꠎꠥꠞ, ꠀꠞ ꠁꠀꠇꠥꠛꠞ ꠙꠡꠥꠁꠘ ꠅꠁꠔꠣ ꠎꠥꠞꠀꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠣꠝ ꠇꠞꠤꠀ ꠔꠣꠁꠘ ꠛꠃꠔ ꠗꠘꠤ ꠅꠁꠟꠣ। ꠔꠣꠘ ꠉꠥꠟꠣꠝ-ꠛꠣꠘ꠆ꠖꠤ, ꠃꠐ-ꠉꠣꠗꠣ ꠀꠞ ꠙꠡꠥꠞ ꠙꠣꠟ ꠛꠃꠔ ꠛꠣꠠꠤꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","ꠛꠣꠖꠦ ꠁꠀꠇꠥꠛꠞ ꠇꠣꠘꠅ ꠀꠁꠟ ꠟꠣꠛꠘꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠝꠣꠔꠤꠞꠣ ꠎꠦꠘ, “ꠁꠀꠇꠥꠛꠦ ꠀꠝꠞꠣꠞ ꠛꠣꠚꠞ ꠢꠇ꠆ꠇꠟꠔꠣ ꠘꠤꠍꠦꠉꠤ, ꠀꠞ ꠀꠝꠞꠣꠞ ꠛꠣꠚꠞ ꠝꠣꠟ ꠖꠤꠀꠃ ꠢꠦ ꠝꠣꠟꠖꠣꠞ ꠅꠁꠉꠦꠍꠦ।” ");
INSERT INTO syls_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","ꠀꠞ ꠁꠀꠇꠥꠛꠦꠅ ꠈꠤꠀꠟ ꠇꠞꠟꠣ, ꠔꠣꠘꠛꠣꠄꠖꠤ ꠟꠣꠛꠘꠞ ꠀꠉꠞ ꠢꠤ ꠝꠘꠞ ꠜꠣꠛ ꠀꠞ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","ꠝꠣꠛꠥꠖꠦ ꠁꠀꠇꠥꠛꠞꠦ ꠇꠁꠟꠣ, ꠔꠥꠝꠤ ꠔꠥꠝꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠖꠦꠡꠅ ꠘꠤꠎꠞ ꠝꠣꠘꠡꠞ ꠉꠦꠍꠦ ꠚꠤꠞꠤꠀ ꠎꠣꠅꠉꠤ। ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠕꠣꠇꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","ꠅꠃ ꠁꠀꠇꠥꠛꠦ ꠈꠛꠞꠤꠀ ꠙꠣꠑꠣꠁꠀ ꠟꠦꠀ ꠀꠞ ꠞꠣꠢꠦꠟꠣꠞꠦ ꠛꠘ꠆ꠖꠅ ꠔꠣꠘ ꠙꠡꠥꠞ ꠙꠣꠟꠞ ꠉꠦꠍꠦ ꠀꠘꠣꠁꠀ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","“ꠀꠝꠤ ꠔꠥꠝꠣꠞꠔꠣꠘꠞ ꠛꠣꠚꠞ ꠝꠥꠈ ꠖꠦꠈꠤꠀ ꠛꠥꠎꠤꠀꠞ, ꠔꠣꠘ ꠀꠉꠞ ꠢꠤ ꠝꠘꠞ ꠜꠣꠛ ꠀꠝꠣꠞ ꠛꠣꠄ ꠘꠣꠄ, ꠅꠁꠟꠦ ꠀꠝꠣꠞ ꠛꠣꠚꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣ ꠀꠝꠣꠞ ꠟꠉꠦ ꠟꠉꠦ ꠞꠁꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","ꠔꠥꠝꠤꠔꠣꠁꠘ ꠔ ꠎꠣꠘ ꠎꠦꠘ, ꠀꠝꠤ ꠀꠝꠣꠞ ꠢꠇꠟ ꠡꠇ꠆ꠔꠤ ꠖꠤꠀꠃ ꠔꠣꠘ ꠇꠔ ꠉꠥꠟꠣꠝꠤ ꠇꠞꠍꠤ, ");
INSERT INTO syls_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ꠔꠣ-ꠅ ꠔꠣꠁꠘ ꠀꠝꠣꠞꠦ ꠐꠉꠤꠍꠂꠘ ꠀꠞ ꠖꠡ-ꠖꠡꠛꠣꠞ ꠇꠞꠤꠀ ꠀꠝꠣꠞ ꠛꠦꠔꠘ ꠛꠖꠟꠣꠁꠍꠂꠘ, ꠅꠁꠟꠦ ꠀꠟ꠆ꠟꠣꠄ ꠀꠝꠣꠞ ꠇꠥꠘꠥ ꠈꠦꠔꠤ ꠅꠁꠔꠦ ꠖꠤꠍꠂꠘ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","ꠔꠣꠁꠘ ꠎꠦꠛꠟꠣ ꠇꠁꠟꠣ, ꠔꠥꠝꠣꠞ ꠛꠦꠔꠘ ꠅꠁꠛ, ꠚꠥꠐꠣ ꠚꠥꠐꠣ ꠞꠋꠉꠞ ꠙꠡꠥ, ꠔꠦꠃ ꠙꠣꠟꠞ ꠢꠇꠟ ꠙꠡꠥꠄ ꠅꠃ ꠟꠣꠈꠣꠘ ꠛꠣꠁꠌ꠆ꠌꠣ ꠖꠤꠟ। ꠢꠤꠞꠛꠣꠞ ꠔꠣꠁꠘ ꠎꠦꠛꠟꠣ ꠇꠁꠟꠣ, ꠔꠥꠝꠣꠞ ꠛꠦꠔꠘ ꠅꠁꠛ ꠒꠥꠞꠣꠀꠟꠣ ꠙꠡꠥ, ꠔꠦꠃ ꠙꠣꠟꠞ ꠢꠇꠟ ꠙꠡꠥꠄ ꠒꠥꠞꠣꠀꠟꠣ ꠛꠣꠁꠌ꠆ꠌꠣ ꠖꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","ꠀꠟ꠆ꠟꠣꠄ ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠞꠤ ꠔꠣꠘ ꠙꠣꠟꠞ ꠙꠡꠥ ꠀꠘꠤꠀ ꠀꠝꠣꠞꠦ ꠖꠤꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“ꠄꠇꠛꠣꠞ ꠙꠡꠥꠁꠘ꠆ꠔꠦ ꠚꠣꠟ ꠈꠣꠅꠀꠞ ꠡꠝꠄ ꠀꠝꠤ ꠈꠥꠀꠛꠦ ꠖꠦꠈꠟꠣꠝ, ꠝꠦꠠꠤ-ꠍꠣꠉꠤꠘ꠆ꠔꠞ ꠃꠙꠞꠦ ꠎꠦ ꠙꠣꠑꠣ ꠅꠇꠟ ꠃꠑꠤꠞꠣ, ꠁꠉꠥꠁꠘ ꠒꠥꠞꠣꠀꠟꠣ, ꠍꠤꠔ꠆ꠞꠣ ꠀꠞ ꠚꠥꠐꠣ ꠚꠥꠐꠣ ꠞꠋꠉꠞ। ");
INSERT INTO syls_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ꠈꠥꠀꠛꠞ ꠝꠣꠎꠦ ꠀꠟ꠆ꠟꠣꠞ ꠚꠤꠞꠤꠡ꠆ꠔꠣꠄ ꠀꠝꠣꠞꠦ ꠒꠣꠇꠤꠟꠣ, ‘ꠁꠀꠇꠥꠛ!’ ꠀꠝꠤ ꠇꠁꠟꠣꠝ, ‘ꠅꠃꠘꠥ ꠀꠝꠤ।’ ");
INSERT INTO syls_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","ꠔꠣꠁꠘ ꠇꠁꠟꠣ, ‘ꠔꠥꠝꠤ ꠌꠃꠈ ꠔꠥꠟꠤꠀ ꠖꠦꠈꠅ, ꠝꠦꠠꠤ-ꠍꠣꠉꠤꠘ꠆ꠔꠞ ꠃꠙꠞꠦ ꠎꠦꠔꠣ ꠙꠣꠑꠣꠁꠘ ꠃꠑꠤꠞꠣ, ꠢꠇ꠆ꠇꠟꠐꠤ ꠒꠥꠞꠣꠀꠟꠣ, ꠍꠤꠔ꠆ꠞꠣ ꠀꠞ ꠚꠥꠐꠣ ꠚꠥꠐꠣ ꠞꠋꠉꠞ। ꠟꠣꠛꠘꠦ ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠎꠦꠔꠣ ꠎꠦꠔꠣ ꠇꠞꠍꠦ, ꠁꠔꠣ ꠢꠇꠟꠔꠣꠃ ꠀꠝꠤ ꠖꠦꠈꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","ꠀꠝꠤ ꠢꠃ ꠛꠦꠕꠦꠟꠞ ꠀꠟ꠆ꠟꠣ, ꠎꠦꠘꠅ ꠔꠥꠝꠤ ꠈꠥꠐꠤꠞ ꠃꠙꠞꠦ ꠔꠦꠟ ꠓꠣꠟꠤꠀ ꠀꠝꠣꠞ ꠘꠣꠝꠦ ꠇꠍꠝ ꠇꠞꠍꠟꠣꠄ। ꠅꠈꠘ ꠌꠟꠅ, ꠁ ꠖꠦꠡ ꠍꠣꠠꠤꠀ ꠔꠥꠝꠣꠞ ꠎꠘꠝ ꠝꠣꠐꠤꠔ ꠚꠤꠞꠔ ꠎꠣꠅ।’ ” ");
INSERT INTO syls_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","ꠅꠃ ꠟꠦꠀ ꠀꠞ ꠞꠣꠢꠦꠟꠣꠄ ꠇꠁꠟꠣ, “ꠛꠣꠛꠣꠞ ꠡꠝ꠆ꠙꠔ꠆ꠔꠤꠞ ꠇꠥꠘꠥ ꠖꠣꠛꠤ ꠀꠞ ꠀꠝꠞꠣꠞ ꠞꠁꠟ ꠘꠤ? ");
INSERT INTO syls_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","ꠔꠣꠁꠘ ꠔ ꠀꠝꠞꠣꠞꠦ ꠛꠦꠉꠣꠘꠣ ꠝꠣꠘꠥꠡ ꠝꠘꠅ ꠇꠞꠤꠀ, ꠀꠝꠞꠣꠞꠦ ꠛꠦꠌꠤꠟꠣꠁꠍꠂꠘ ꠀꠞ ꠀꠝꠞꠣꠞ ꠢꠇ꠆ꠇꠟꠔꠣꠃ ꠈꠣꠁꠟꠤꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","ꠄꠞꠟꠣꠉꠤ ꠀꠟ꠆ꠟꠣꠄ ꠀꠝꠞꠣꠞ ꠛꠣꠛꠣꠞ ꠍꠣꠝꠣꠘꠣ ꠕꠘꠦ ꠎꠔꠔꠣ ꠘꠤꠍꠂꠘ, ꠁ ꠢꠇ꠆ꠇꠟꠐꠤꠃ ꠅꠈꠘ ꠀꠝꠞꠣꠞ ꠀꠞ ꠀꠝꠞꠣꠞ ꠀꠅꠟꠣꠖꠞ ꠅꠁꠍꠦ। ꠔꠦ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠇꠞꠍꠂꠘ, ꠔꠥꠝꠤꠅ ꠅꠃꠟꠣ ꠇꠞꠅ।” ");
INSERT INTO syls_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","ꠛꠣꠖꠦ ꠁꠀꠇꠥꠛꠦ ꠔꠣꠘ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ ꠀꠞ ꠛꠤꠛꠤꠘ꠆ꠔꠞꠦ ꠃꠐꠞ ꠃꠙꠞꠦ ꠔꠥꠟꠤꠀ, ");
INSERT INTO syls_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ꠙꠖ꠆ꠖꠘ-ꠁꠞꠣꠝꠅ ꠔꠣꠘ ꠇꠣꠝꠣꠁꠟ ꠙꠡꠥ ꠅꠇꠟ ꠀꠞ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠢꠇ꠆ꠇꠟꠔꠣ ꠟꠁꠀ, ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠔꠣꠘ ꠛꠣꠚ ꠁꠍꠢꠣꠇꠞ ꠉꠦꠍꠦ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","ꠢꠃ ꠡꠝꠄ ꠟꠣꠛꠘꠦ ꠔꠣꠘ ꠝꠦꠠꠣꠁꠘ꠆ꠔꠞ ꠞꠥꠝꠣ ꠇꠣꠐꠣꠞ ꠟꠣꠉꠤ ꠉꠦꠍꠟꠣ, ꠀꠞ ꠅꠃ ꠚꠣꠇꠦ ꠞꠣꠢꠦꠟꠣꠄ ꠔꠣꠘ ꠛꠣꠚꠞ ꠝꠥꠞ꠆ꠔꠤ ꠅꠇꠟ ꠌꠥꠞꠤ ꠇꠞꠤꠟꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","ꠁꠀꠇꠥꠛꠦ ꠔꠣꠘ ꠎꠣꠅꠀꠞ ꠇꠕꠣ ꠅꠞꠣꠝꠤ ꠟꠣꠛꠘꠞꠦ ꠘꠣ ꠎꠣꠘꠣꠁꠀ ꠔꠣꠘꠞꠦ ꠐꠉꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","ꠀꠞ ꠔꠣꠁꠘ ꠢꠇ꠆ꠇꠟꠔꠣ ꠟꠁꠀ ꠜꠣꠉꠤꠀ, ꠚꠥꠞꠣꠔ ꠉꠣꠋ ꠙꠣꠞ ꠅꠁꠀ ꠉꠤꠟꠤꠅꠖꠞ ꠙꠣꠠꠞ ꠍꠣꠝꠘꠦꠖꠤ ꠎꠣꠅꠀꠔ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","ꠎꠣꠅꠀꠞ ꠔꠤꠘ ꠖꠤꠘ ꠛꠣꠖꠦ ꠟꠣꠛꠘꠦ ꠢꠥꠘꠟꠣ ꠎꠦꠘ, ꠁꠀꠇꠥꠛ ꠜꠣꠉꠤꠀ ꠉꠦꠍꠂꠘꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","ꠅꠃ ꠔꠣꠁꠘ ꠈꠦꠡ-ꠇꠥꠐꠥꠝꠞꠦ ꠟꠁꠀ, ꠁꠀꠇꠥꠛꠞ ꠈꠞꠦ ꠅꠁꠀ ꠡꠣꠔ ꠖꠤꠘꠞ ꠙꠕ ꠉꠤꠀ, ꠉꠤꠟꠤꠅꠖꠞ ꠙꠣꠠꠅ ꠔꠣꠞꠣꠞ ꠟꠣꠉꠣꠟ ꠙꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","ꠅꠁꠟꠦ ꠞꠣꠁꠔꠞ ꠛꠣꠟꠣ ꠀꠟ꠆ꠟꠣꠄ ꠈꠥꠀꠛꠦ ꠅꠞꠣꠝꠤ ꠟꠣꠛꠘꠞ ꠉꠦꠍꠦ ꠀꠁꠀ ꠇꠁꠟꠣ, “ꠈꠛꠞꠖꠣꠞ! ꠁꠀꠇꠥꠛꠞꠦ ꠜꠣꠟꠣ-ꠛꠥꠞꠣ ꠇꠥꠘ꠆ꠔꠣꠃ ꠇꠁꠅ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","ꠁꠀꠇꠥꠛꠦ ꠙꠣꠠꠞ ꠝꠣꠎꠦ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠍꠟꠣ, ꠀꠞ ꠟꠣꠛꠘꠦ ꠉꠤꠀ ꠔꠣꠘꠞꠦ ꠅꠘꠅꠃ ꠟꠣꠉꠣꠟ ꠙꠣꠁꠟꠤꠟꠣ, ꠔꠦꠃ ꠟꠣꠛꠘ ꠀꠞ ꠔꠣꠘ ꠈꠦꠡ-ꠇꠥꠐꠥꠝ ꠅꠇꠟꠦꠅ ꠉꠤꠟꠤꠅꠖꠞ ꠢꠃ ꠙꠣꠠꠞ ꠝꠣꠎꠦ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","ꠛꠣꠖꠦ ꠟꠣꠛꠘꠦ ꠁꠀꠇꠥꠛꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠇꠦꠘꠦ ꠁꠔꠣ ꠇꠞꠟꠣꠄ? ꠀꠝꠣꠞꠦ ꠐꠉꠤꠀ ꠀꠝꠣꠞ ꠙꠥꠠꠤꠘ꠆ꠔꠞꠦ ꠇꠦꠘꠦ ꠎꠥꠖ꠆ꠖꠞ ꠛꠘ꠆ꠖꠤꠞ ꠟꠣꠈꠣꠘ ꠟꠁꠀ ꠀꠁꠟꠣꠄ? ");
INSERT INTO syls_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","ꠇꠦꠘꠦ ꠔꠥꠝꠤ ꠗꠥꠇꠣ ꠖꠤꠀ ꠀꠝꠣꠞꠦ ꠘꠣ ꠎꠣꠘꠣꠁꠀ, ꠟꠥꠇꠣꠁꠀ ꠜꠣꠉꠤꠀ ꠀꠁꠟꠣꠄ? ꠀꠝꠣꠞꠦ ꠎꠣꠘꠣꠁꠟꠦ ꠔ ꠀꠝꠤ ꠈꠥꠡꠤ-ꠛꠣꠡꠤ ꠇꠞꠤꠀ, ꠖꠥꠔꠣꠞꠣ ꠀꠞ ꠝꠘ꠆ꠖꠤꠞꠣ ꠛꠣꠎꠣꠁꠀ ꠉꠣꠘ ꠉꠣꠁꠀ, ꠔꠥꠝꠣꠞꠦ ꠛꠤꠖꠣꠄ ꠖꠤꠟꠣꠝ ꠅꠘꠦ। ");
INSERT INTO syls_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠙꠥꠠꠤꠘ꠆ꠔꠞꠦ ꠀꠞ ꠘꠣꠔꠤꠘꠡꠣꠞꠦꠅ ꠢꠥꠋꠉꠣ ꠖꠤꠔꠦꠅ ꠖꠤꠟꠣꠄ ꠘꠣ, ꠛꠦꠀꠈꠟꠞ ꠝꠔ ꠇꠣꠝ ꠇꠞꠟꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","ꠅꠈꠘ ꠀꠝꠤ ꠔ ꠔꠥꠝꠞꠣꠞ ꠈꠦꠔꠤ ꠇꠞꠔꠣꠝ ꠙꠣꠞꠝꠥ, ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠀꠟ꠆ꠟꠣꠄ ꠉꠔ ꠞꠣꠁꠔ ꠀꠝꠣꠞꠦ ꠇꠁꠍꠂꠘ, ‘ꠈꠛꠞꠖꠣꠞ! ꠁꠀꠇꠥꠛꠞꠦ ꠜꠣꠟꠣ-ꠛꠥꠞꠣ ꠇꠥꠘ꠆ꠔꠣꠃ ꠇꠁꠅ ꠘꠣ।’ ");
INSERT INTO syls_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","ꠔꠥꠝꠣꠞ ꠛꠣꠚꠞ ꠛꠣꠠꠤꠔ ꠎꠣꠅꠀꠞ ꠟꠣꠉꠤ ꠝꠘꠦ ꠇꠣꠘ꠆ꠖꠤꠍꠤꠟ ꠇꠞꠤ, ꠔꠥꠝꠤ ꠜꠣꠉꠤꠀ ꠀꠁꠍ ꠝꠣꠘꠟꠣꠝ, ꠔꠦ ꠀꠝꠣꠞ ꠖꠦꠛꠔꠣ ꠅꠇꠟ ꠇꠦꠘꠦ ꠌꠥꠞꠤ ꠇꠞꠟꠣꠄ?” ");
INSERT INTO syls_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","ꠁꠀꠇꠥꠛꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠀꠝꠤ ꠒꠞꠣꠁꠍꠟꠣꠝ, ꠝꠘꠅ ꠇꠞꠍꠟꠣꠝ, ꠀꠙꠘꠦ ꠎꠥꠞ ꠇꠞꠤꠀ ꠀꠙꠘꠣꠞ ꠙꠥꠠꠤꠘ꠆ꠔꠞꠦ, ꠀꠝꠣꠞ ꠉꠦꠍ ꠕꠘꠦ ꠇꠣꠠꠤꠀ ꠞꠣꠈꠤ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ꠔꠦ ꠅꠈꠘ ꠎꠣꠞ ꠉꠦꠍꠦ ꠀꠙꠘꠣꠞ ꠖꠦꠛꠔꠣꠁꠘ ꠙꠣꠁꠛꠣ, ꠔꠣꠞꠦ ꠎꠤꠔꠣ ꠞꠣꠈꠔꠣꠝ ꠘꠣꠄ। ꠀꠝꠞꠣꠞ ꠈꠦꠡ-ꠇꠥꠐꠝꠞ ꠍꠣꠝꠘꠦ ꠢꠇ꠆ꠇꠟꠔꠣ ꠔꠣꠟ꠆ꠟꠣꠡ ꠇꠞꠤꠀ ꠎꠥꠖꠤ ꠀꠙꠘꠣꠞ ꠇꠥꠘ꠆ꠔꠣ ꠙꠣꠁꠘ, ꠔꠣꠁꠟꠦ ꠘꠦꠃꠇ꠆ꠇꠣꠉꠤ।” ꠢꠃ ꠝꠥꠞ꠆ꠔꠤ ꠅꠇꠟ ꠎꠦꠘ ꠞꠣꠢꠦꠟꠣꠄ ꠌꠥꠞꠤ ꠇꠞꠍꠂꠘ, ꠁꠔꠣ ꠔ ꠁꠀꠇꠥꠛꠦ ꠎꠣꠘꠂꠘ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","ꠅꠃ ꠟꠣꠛꠘꠦ ꠁꠀꠇꠥꠛ, ꠟꠦꠀ ꠀꠞ ꠖꠥꠁꠅ ꠛꠣꠘ꠆ꠖꠤꠞ ꠔꠣꠝ꠆ꠛꠥꠔ ꠢꠣꠝꠣꠁꠀ ꠢꠇꠟꠔꠣ ꠔꠥꠇꠣꠁꠀ ꠇꠥꠘ꠆ꠔꠣ ꠘꠣ ꠙꠣꠁꠀ, ꠢꠦꠡꠦ ꠟꠦꠀꠞ ꠔꠣꠝ꠆ꠛꠥ ꠕꠘꠦ ꠞꠣꠢꠦꠟꠣꠞ ꠔꠣꠝ꠆ꠛꠥꠔ ꠉꠤꠀ ꠢꠣꠝꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","ꠞꠣꠢꠦꠟꠣꠄ ꠁ ꠝꠥꠞ꠆ꠔꠤ ꠅꠇꠟ ꠘꠤꠀ ꠃꠐꠞ ꠉꠖ꠆ꠖꠤꠞ ꠜꠤꠔꠞꠦ ꠕꠁꠀ, ꠔꠣꠁꠘ ꠅꠃ ꠉꠖ꠆ꠖꠤꠞ ꠃꠙꠞꠦ ꠛꠁꠟꠣ। ꠟꠣꠛꠘꠦ ꠔꠣꠘ ꠔꠣꠝ꠆ꠛꠥꠞ ꠢꠇꠟꠔꠣ ꠔꠥꠇꠣꠁꠀ ꠢꠘꠅ-ꠅ ꠁꠔꠣ ꠙꠣꠁꠟꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","ꠀꠞ ꠞꠣꠢꠦꠟꠣꠄ ꠔꠣꠘ ꠛꠣꠚꠞꠦ ꠇꠁꠟꠣ, “ꠛꠣꠎꠣꠘ ꠀꠝꠤ ꠃꠑꠤꠀ ꠃꠛꠣꠁꠔꠣꠝ ꠙꠣꠞꠤꠀꠞ ꠘꠣ ꠇꠞꠤ ꠀꠙꠘꠦ ꠛꠦꠎꠣꠞ ꠅꠁꠘ ꠘꠣ ꠎꠦꠘ, ꠛꠦꠐꠤꠀꠞꠣ ꠛꠦꠝꠣꠞꠞ ꠟꠣꠉꠤ ꠀꠝꠣꠞ ꠡꠞꠤꠟ ꠈꠣꠞꠣꠙ।” ꠅꠃ ꠟꠣꠛꠘꠦ ꠢꠤ ꠝꠥꠞ꠆ꠔꠤ ꠅꠇꠟ ꠀꠞ ꠔꠥꠇꠣꠁꠀ ꠙꠣꠁꠟꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","ꠢꠦꠡꠦ ꠁꠀꠇꠥꠛꠦ ꠉꠥꠍꠣ ꠅꠁꠀ ꠟꠣꠛꠘꠞꠦ ꠍꠤꠠꠣꠁꠀ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠅꠙꠞꠣꠗ ꠇꠤꠀꠘꠅ? ꠀꠝꠤ ꠇꠤꠔꠣ ꠖꠥꠡ ꠇꠞꠍꠤ, ꠀꠙꠘꠦ ꠀꠝꠣꠞ ꠈꠞꠦ ꠅꠁꠀ ꠅꠃꠟꠣ ꠈꠦꠖꠣꠘꠤꠔ ꠀꠁꠟꠣ? ");
INSERT INTO syls_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","ꠀꠝꠣꠞ ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠀꠃꠟꠣꠁꠀ ꠀꠙꠘꠣꠞ ꠊꠞꠞ ꠇꠥꠘ ꠎꠤꠘꠤꠡꠈꠣꠘ ꠙꠣꠁꠟꠣ? ꠙꠣꠁꠟꠦ ꠁꠔꠣ ꠀꠙꠘꠣꠞ-ꠀꠝꠣꠞ ꠈꠦꠡ-ꠇꠥꠐꠝꠞ ꠍꠣꠝꠘꠦ ꠞꠣꠈꠃꠇ꠆ꠇꠣ, ꠔꠣꠞꠣ ꠀꠝꠞꠣꠞ ꠛꠤꠌꠣꠞ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","ꠀꠝꠤ ꠁ ꠛꠤꠡ ꠛꠞꠍ ꠀꠙꠘꠣꠞ ꠟꠉꠦ ꠀꠍꠟꠣꠝ। ꠄꠞ ꠝꠣꠎꠦ ꠀꠙꠘꠣꠞ ꠇꠥꠘꠥ ꠝꠦꠠꠤ ꠛꠣ ꠍꠣꠉꠤꠞ ꠙꠦꠐꠞ ꠛꠣꠁꠌ꠆ꠌꠣ ꠘꠡ꠆ꠐ ꠅꠁꠍꠦ ꠘꠣ ꠛꠣ ꠀꠙꠘꠣꠞ ꠙꠣꠟꠞ ꠇꠥꠘꠥ ꠝꠦꠠꠣꠅ ꠀꠝꠤ ꠈꠣꠁꠍꠤ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","ꠀꠞ ꠎꠋꠟꠤ ꠎꠣꠘꠥꠀꠞꠦ ꠝꠣꠞꠣ ꠇꠥꠘꠥ ꠙꠡꠥꠅ ꠀꠙꠘꠣꠞ ꠉꠦꠍꠦ ꠀꠘꠍꠤ ꠘꠣ, ꠁꠔꠣ ꠀꠝꠤ ꠘꠤꠎꠦꠃ ꠙꠥꠞꠤꠀ ꠖꠤꠍꠤ। ꠖꠤꠘꠅ ꠛꠣ ꠞꠣꠁꠔ ꠇꠥꠘꠥ ꠙꠡꠥ ꠌꠥꠞꠤ ꠅꠁꠟꠦ, ꠀꠙꠘꠦ ꠀꠝꠣꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠜꠞꠤꠀ ꠟꠁꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","ꠀꠝꠤ ꠅꠃꠟꠣ ꠖꠤꠘ ꠇꠣꠐꠣꠁꠍꠤ, ꠖꠤꠘꠅ ꠎꠟꠍꠤ ꠉꠞꠝꠦ ꠀꠞ ꠞꠣꠁꠔꠦ ꠇꠣꠙꠍꠤ ꠡꠤꠔꠦ। ꠀꠝꠣꠞ ꠌꠈꠥꠔ ꠊꠥꠝ ꠀꠁꠔ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","ꠎꠦ ꠛꠤꠡ ꠛꠞꠍ ꠀꠙꠘꠣꠞ ꠛꠣꠠꠤꠔ ꠞꠁꠍꠤ, ꠄꠞ ꠌꠃꠖ꠆ꠖ ꠛꠞꠍ ꠀꠝꠤ ꠀꠙꠘꠣꠞ ꠖꠥꠁ ꠙꠥꠠꠤꠞ ꠟꠣꠉꠤ ꠉꠥꠟꠣꠝꠤ ꠇꠞꠍꠤ, ꠀꠞ ꠍꠄ ꠛꠞꠍ ꠉꠦꠍꠦ ꠀꠙꠘꠣꠞ ꠙꠡꠥꠞ ꠟꠣꠉꠤ। ꠄꠞ ꠝꠣꠎꠦ ꠀꠙꠘꠦ ꠖꠡ-ꠖꠡꠛꠣꠞ ꠀꠝꠣꠞ ꠛꠦꠔꠘꠅ ꠛꠖꠟꠣꠁꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","ꠀꠟ꠆ꠟꠣ ꠙꠣꠇ, ꠎꠣꠘꠞꠦ ꠀꠝꠣꠞ ꠛꠣꠚ ꠁꠍꠢꠣꠇꠦ ꠝꠣꠛꠥꠖ ꠢꠤꠡꠣꠛꠦ ꠒꠞꠣꠁꠔꠣ, ꠎꠦꠁꠘ ꠀꠝꠣꠞ ꠖꠣꠖꠣ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞꠅ ꠝꠣꠛꠥꠖ, ꠔꠣꠁꠘ ꠎꠥꠖꠤ ꠀꠝꠣꠞ ꠟꠉꠦ ꠘꠣ ꠕꠣꠇꠔꠣ, ꠔꠦ ꠢꠣꠍꠣꠃ ꠅꠈꠘ ꠀꠙꠘꠦ ꠀꠝꠣꠞꠦ ꠈꠣꠟꠤ ꠀꠔꠦ ꠛꠤꠖꠣꠄ ꠖꠤꠟꠣ ꠅꠘꠦ। ꠀꠟ꠆ꠟꠣꠄ ꠀꠝꠣꠞ ꠝꠦꠘꠔ ꠀꠞ ꠖꠥꠈ ꠖꠦꠈꠍꠂꠘ। ꠄꠞꠟꠣꠉꠤꠃ ꠔꠣꠁꠘ ꠇꠣꠁꠟ ꠞꠣꠁꠔ ꠀꠙꠘꠣꠞꠦ ꠗꠝꠇꠣꠁꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","ꠟꠣꠛꠘꠦ ꠁꠀꠇꠥꠛꠞꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠁ ꠙꠥꠠꠤꠘ ꠀꠝꠣꠞꠃ ꠙꠥꠠꠤꠘ, ꠀꠞ ꠅꠃ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ ꠀꠝꠣꠞꠃ ꠘꠣꠔꠤꠘꠡꠣ, ꠀꠞ ꠁ ꠙꠡꠥꠞ ꠙꠣꠟ ꠅꠇꠟꠅ ꠀꠝꠣꠞ। ꠔꠥꠝꠤ ꠅꠘꠅ ꠎꠔꠔꠣ ꠖꠦꠈꠞꠣꠄ, ꠢꠇꠟꠔꠣꠃ ꠀꠝꠣꠞ, ꠔꠣ-ꠅ ꠀꠝꠣꠞ ꠙꠥꠠꠤꠘ꠆ꠔꠞꠦ ꠛꠣ ꠔꠣꠞꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ꠆ꠔꠞꠦ ꠀꠝꠤ ꠀꠞ ꠇꠤꠔꠣ ꠇꠞꠝꠥ? ");
INSERT INTO syls_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ꠀꠅ, ꠀꠝꠞꠣ ꠖꠥꠁꠅꠎꠘꠦ ꠄꠇ ꠌꠥꠇ꠆ꠔꠤ ꠇꠞꠤꠟꠣꠁ। ꠅꠃ ꠌꠥꠇ꠆ꠔꠤꠞ ꠘꠤꠡꠣꠘꠣꠐꠣ ꠔꠥꠝꠣꠞ-ꠀꠝꠣꠞ ꠝꠣꠎꠦ ꠡꠣꠇ꠆ꠇꠤ ꠞꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","ꠅꠃ ꠁꠀꠇꠥꠛꠦ ꠄꠇ ꠙꠣꠔ꠆ꠔꠞ ꠟꠁꠀ ꠈꠥꠐꠤ ꠉꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","ꠀꠞ ꠔꠣꠘ ꠈꠦꠡ-ꠇꠥꠐꠥꠝ ꠅꠇꠟꠞꠦ ꠇꠁꠟꠣ, “ꠀꠙꠘꠣꠞꠣꠅ ꠙꠣꠔ꠆ꠔꠞ ꠀꠘꠃꠇ꠆ꠇꠣ।” ꠔꠦꠃ ꠔꠣꠞꠣꠅ ꠙꠣꠔ꠆ꠔꠞ ꠀꠘꠤꠀ ꠄꠇ ꠜꠤꠐꠣ ꠛꠣꠘꠣꠁꠟꠣ, ꠢꠦꠡꠦ ꠅꠃ ꠜꠤꠐꠣꠞ ꠉꠦꠍꠦ ꠈꠣꠘꠤ ꠈꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ꠟꠣꠛꠘꠦ ꠢꠃ ꠜꠤꠐꠣꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠎꠤꠉꠞ-ꠡꠣꠢꠖꠥꠔꠣ ꠝꠣꠘꠤ, ꠡꠣꠇ꠆ꠇꠤ-ꠜꠤꠐꠣ ꠅꠁꠟꠦ ꠁꠀꠇꠥꠛꠦ ꠄꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠉꠟ-ꠄꠖ। ");
INSERT INTO syls_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","ꠟꠣꠛꠘꠦ ꠇꠁꠟꠣ, “ꠅꠃ ꠜꠤꠐꠣ ꠅꠈꠘ ꠕꠘꠦ ꠔꠥꠝꠣꠞ-ꠀꠝꠣꠞ ꠡꠣꠇ꠆ꠇꠤ ꠅꠁꠟ।” ꠄꠞꠟꠣꠉꠤ ꠅꠃ ꠜꠤꠐꠣꠞ ꠘꠣꠝ ꠅꠁꠟ ꠉꠟ-ꠄꠖ, ");
INSERT INTO syls_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ꠀꠞ ꠅꠃ ꠈꠥꠐꠤꠞ ꠘꠣꠝ ꠅꠁꠟ ꠝꠤꠡꠙꠣ ꠝꠣꠘꠤ, ꠙꠣꠢꠣꠞꠣꠞ ꠎꠣꠉꠣ। ꠟꠣꠛꠘꠦ ꠇꠁꠟꠣ, “ꠀꠝꠞꠣ ꠎꠦꠛꠟꠣ ꠢꠞꠤꠀ ꠎꠣꠁꠝꠥꠉꠤ ꠅꠃ ꠡꠝꠄ ꠝꠣꠛꠥꠖꠦꠃ ꠔꠥꠝꠣꠞ-ꠀꠝꠣꠞ ꠙꠣꠢꠣꠞꠣ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","ꠔꠥꠝꠤ ꠎꠥꠖꠤ ꠀꠝꠣꠞ ꠙꠥꠠꠤꠘ꠆ꠔꠞꠦ ꠖꠥꠈ ꠖꠦꠅ ꠛꠣ ꠀꠝꠣꠞ ꠙꠥꠠꠤꠘ ꠍꠣꠠꠣ ꠀꠞ ꠇꠦꠃꠞꠞꠦ ꠛꠤꠀ ꠇꠞꠅ, ꠔꠣꠁꠟꠦ ꠇꠥꠘꠥ ꠝꠣꠘꠥꠡ ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠘꠣ ꠞꠁꠟꠦꠅ ꠀꠟ꠆ꠟꠣ ꠀꠝꠞꠣꠞ ꠡꠣꠇ꠆ꠇꠤ ꠞꠁꠟꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","ꠟꠣꠛꠘꠦ ꠁꠀꠇꠥꠛꠞꠦ ꠀꠞꠅ ꠇꠁꠟꠣ, “ꠅꠃ ꠜꠤꠐꠣ ꠛꠣꠄ ꠀꠞ ꠅꠃ ꠈꠥꠐꠤꠞ ꠛꠣꠄ ꠌꠣꠅ, ꠁꠐꠣ ꠔꠥꠝꠣꠞ-ꠀꠝꠣꠞ ꠝꠣꠎꠈꠣꠘꠅ ꠀꠝꠤ ꠉꠣꠠꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ꠁ ꠖꠥꠁꠅꠐꠣ ꠔꠥꠝꠣꠞ-ꠀꠝꠣꠞ ꠡꠣꠇ꠆ꠇꠤ ꠞꠁꠟ। ꠔꠥꠝꠤꠅ ꠁꠋꠡꠣ ꠇꠞꠤ ꠅꠃ ꠜꠤꠐꠣ ꠀꠞ ꠈꠥꠐꠤ ꠒꠤꠋꠉꠣꠁꠀ ꠀꠁꠛꠣꠄ ꠘꠣ ꠀꠞ ꠀꠝꠤꠅ ꠛꠥꠞꠣꠁꠞ ꠘꠤꠅꠔꠦ ꠁꠔꠣ ꠒꠤꠋꠉꠣꠁꠀ ꠎꠣꠁꠔꠣꠝ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠀꠟ꠆ꠟꠣ, ꠘꠣꠢꠥꠞꠞ ꠃꠙꠞꠀꠟꠣ ꠀꠞ ꠔꠣꠞꠣꠞ ꠛꠣꠚꠞ ꠃꠙꠞꠀꠟꠣꠄ ꠔꠥꠝꠣꠞ-ꠀꠝꠣꠞ ꠛꠤꠌꠣꠞ ꠇꠞꠛꠣ।” ꠀꠞ ꠁꠀꠇꠥꠛꠦ, ꠔꠣꠘ ꠛꠣꠚ ꠁꠍꠢꠣꠇꠦ ꠎꠣꠘꠞꠦ ꠒꠞꠣꠁꠔꠣ ꠔꠣꠘ ꠘꠣꠝꠦ ꠇꠍꠝ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","ꠁꠀꠇꠥꠛꠦ ꠢꠃ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠞꠤꠀ ꠔꠣꠘ ꠈꠦꠡ-ꠇꠥꠐꠥꠝ ꠅꠇꠟꠞꠦ ꠈꠣꠅꠀꠞ ꠖꠣꠅꠀꠔ ꠖꠤꠟꠣ। ꠈꠣꠅꠀ-ꠖꠣꠅꠀ ꠡꠦꠡ ꠇꠞꠤꠀ ꠢꠣꠞꠤ ꠔꠣꠞꠣ ꠢꠃ ꠙꠣꠠꠞ ꠝꠣꠎꠦ ꠞꠣꠁꠔ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","ꠛꠣꠖꠞ ꠖꠤꠘ ꠚꠎꠞꠦ ꠟꠣꠛꠘꠦ ꠔꠣꠘ ꠙꠥꠠꠤꠘ꠆ꠔꠞꠦ ꠀꠞ ꠘꠣꠔꠤꠘꠡꠣꠞꠦ ꠢꠥꠋꠉꠣ ꠖꠤꠀ ꠖꠥꠀ ꠇꠞꠟꠣ, ꠢꠦꠡꠦ ꠔꠣꠘ ꠛꠣꠠꠤ ꠝꠥꠈꠣ ꠙꠕ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","ꠁꠀꠇꠥꠛꠅ ꠔꠣꠘ ꠙꠕꠦ ꠞꠅꠀꠘꠣ ꠅꠁꠟꠦ, ꠀꠟ꠆ꠟꠣꠞ ꠚꠤꠞꠤꠡ꠆ꠔꠣ ꠅꠇꠟꠦ ꠔꠣꠘꠞꠦ ꠖꠦꠈꠣ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","ꠄꠞꠣꠞꠦ ꠖꠦꠈꠤꠀ ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠁꠔꠣ ꠀꠟ꠆ꠟꠣꠞ ꠚꠃꠎ।” ꠀꠞ ꠁ ꠎꠣꠉꠣꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠝꠢꠘꠄꠁꠝ ꠝꠣꠘꠤ, ꠖꠥꠁ ꠚꠃꠎ। ");
INSERT INTO syls_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","ꠁꠀꠇꠥꠛꠦ ꠔꠣꠘ ꠀꠉꠦ ꠇꠞꠤ ꠍꠦꠁꠞ ꠛꠣ ꠁꠖꠥꠝ ꠖꠦꠡꠅ, ꠔꠣꠘ ꠛꠠ ꠜꠣꠁ ꠁꠡʼꠞ ꠉꠦꠍꠦ ꠇꠄꠎꠘ ꠈꠛꠞꠤꠀ ꠙꠣꠑꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","ꠔꠣꠁꠘ ꠄꠞꠣꠞꠦ ꠢꠤꠇꠣꠁ ꠖꠤꠟꠣ, “ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠝꠥꠘꠤꠛ ꠁꠡʼꠞꠦ ꠇꠁꠅ, ꠔꠣꠘ ꠉꠥꠟꠣꠝ ꠁꠀꠇꠥꠛꠦ ꠇꠁꠍꠦ, ꠀꠝꠤ ꠅꠔꠖꠤꠘ ꠕꠘꠦ ꠀꠝꠞꠣꠞ ꠝꠣꠝꠥ ꠟꠣꠛꠘꠞ ꠉꠦꠍꠦ ꠝꠥꠍꠣꠚꠤꠞꠤꠔ ꠀꠍꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","ꠀꠝꠣꠞ ꠉꠞꠥ-ꠉꠣꠗꠣ, ꠍꠣꠉꠟ-ꠝꠦꠠꠣ ꠀꠞ ꠉꠥꠟꠣꠝ-ꠛꠣꠘ꠆ꠖꠤ ꠢꠇꠟꠔꠣꠃ ꠀꠍꠦ। ꠀꠝꠣꠞ ꠝꠥꠘꠤꠛꠞ ꠉꠦꠍꠦ ꠖꠄꠀ ꠙꠣꠅꠀꠞ ꠀꠡꠣꠄ ꠔꠥꠝꠞꠣꠞꠦ ꠙꠣꠑꠣꠁꠟꠣꠝ।” ");
INSERT INTO syls_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","ꠈꠛꠞꠤꠀ ꠅꠇꠟꠦ ꠚꠤꠞꠤꠀ ꠀꠁꠀ ꠁꠀꠇꠥꠛꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠞꠣ ꠀꠙꠘꠣꠞ ꠜꠣꠁ ꠁꠡʼꠞ ꠉꠦꠍꠦ ꠉꠦꠍꠟꠣꠝ। ꠔꠣꠁꠘ ꠌꠣꠁꠞ-ꠡ ꠝꠣꠘꠡꠞꠦ ꠟꠁꠀ ꠀꠙꠘꠣꠞ ꠟꠉꠦ ꠝꠥꠟꠣꠇꠣꠔ ꠇꠞꠣꠔ ꠀꠁꠞꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ꠅꠃ ꠁꠀꠇꠥꠛꠦ ꠒꠞꠣꠁꠀ ꠈꠥꠛ ꠅꠡ꠆ꠕꠤꠞ ꠅꠁꠉꠦꠟꠣ। ꠔꠣꠁꠘ ꠟꠉꠞ ꠢꠇꠟ ꠝꠣꠘꠡꠞꠦ, ꠉꠞꠥ-ꠍꠣꠉꠟ, ꠝꠦꠠꠣ-ꠝꠦꠠꠤ ꠀꠞ ꠃꠐ-ꠉꠣꠗꠣ ꠅꠇꠟꠞꠦ ꠖꠥꠁ ꠖꠟꠦ ꠀꠟꠉꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","ꠔꠣꠁꠘ ꠇꠁꠟꠣ, ꠜꠣꠁꠄ ꠀꠁꠀ ꠄꠇ ꠖꠟꠞꠦ ꠢꠣꠝꠟꠣ ꠇꠞꠟꠦꠅ ꠀꠞꠇ ꠖꠟ ꠘꠤꠞꠣꠙꠖꠦ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ꠀꠞ ꠁꠀꠇꠥꠛꠦ ꠖꠥꠀ ꠇꠞꠟꠣ, “ꠅ ꠀꠟ꠆ꠟꠣ, ꠀꠝꠣꠞ ꠖꠣꠖꠣ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠝꠣꠛꠥꠖ ꠀꠞ ꠀꠝꠣꠞ ꠛꠣꠚ ꠁꠍꠢꠣꠇꠞ ꠝꠣꠛꠥꠖ, ꠔꠥꠝꠤꠃ ꠀꠝꠣꠞꠦ ꠢꠥꠇꠥꠝ ꠇꠞꠍ ꠎꠦꠘ, ‘ꠔꠥꠝꠣꠞ ꠖꠦꠡꠅ ꠔꠥꠝꠣꠞ ꠘꠤꠎꠞ ꠝꠣꠘꠡꠞ ꠉꠦꠍꠦ ꠚꠤꠞꠤꠀ ꠎꠣꠅ, ꠔꠦꠃ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠞꠢꠝ ꠇꠞꠝꠥ।’ ");
INSERT INTO syls_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ꠔꠥꠝꠣꠞ ꠁ ꠉꠥꠟꠣꠝꠞ ꠛꠣꠄ ꠎꠦ ꠞꠢꠝ ꠀꠞ ꠁꠝꠣꠘꠖꠣꠞꠤ ꠖꠦꠈꠣꠁꠍ, ꠀꠝꠤ ꠁꠔꠣ ꠇꠥꠘ꠆ꠔꠣꠞꠃ ꠟꠣꠈ ꠘꠣꠄ। ꠀꠝꠤ ꠔ ꠄꠉꠥ ꠟꠣꠑꠤ ꠟꠁꠀ ꠁ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋ ꠙꠣꠞ ꠅꠁꠍꠟꠣꠝ, ꠀꠞ ꠅꠈꠘ ꠖꠥꠁ ꠖꠟ ꠅꠁꠉꠦꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","ꠝꠣꠛꠥꠖ, ꠀꠝꠤ ꠀꠞꠎ ꠇꠞꠤꠀꠞ, ꠀꠝꠣꠞ ꠜꠣꠁ ꠁꠡʼꠞ ꠀꠔ ꠕꠘꠦ ꠀꠝꠣꠞꠦ ꠛꠣꠌꠣꠅ। ꠀꠝꠣꠞ ꠒꠞ ꠇꠞꠦꠞ, ꠢꠦ ꠀꠁꠀ ꠛꠃ ꠙꠥꠀ-ꠙꠥꠠꠤꠞ ꠟꠉꠦ ꠀꠝꠣꠞꠦꠅ ꠈꠥꠘ ꠇꠞꠛ। ");
INSERT INTO syls_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","ꠔꠥꠝꠤꠃ ꠔ ꠅꠀꠖꠣ ꠇꠞꠍ, ‘ꠀꠝꠤ ꠅꠛꠡ꠆ꠡꠃ ꠔꠥꠝꠣꠞ ꠜꠣꠟꠣꠁ ꠇꠞꠝꠥ, ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡ ꠅꠇꠟꠞꠦ ꠖꠞꠤꠀꠞ ꠙꠣꠞꠞ ꠛꠣꠟꠥꠞ ꠟꠣꠈꠣꠘ ꠛꠦꠢꠤꠡꠣꠛ ꠇꠞꠝꠥ, ꠎꠦꠟꠣ ꠉꠘꠤꠀ ꠚꠥꠠꠣꠄ ꠘꠣ।’ ” ");
INSERT INTO syls_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","ꠁꠀꠇꠥꠛꠦ ꠁ ꠞꠣꠁꠔ ꠢꠘꠅ ꠞꠁꠟꠣ ꠀꠞ ꠔꠣꠘ ꠎꠔꠔꠣ ꠀꠍꠤꠟ ꠄꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠇꠔꠈꠣꠘ ꠟꠁꠀ ꠔꠣꠘ ꠜꠣꠁ ꠁꠡʼꠞ ꠟꠣꠉꠤ ꠄꠇ ꠃꠙꠢꠣꠞ ꠔꠂꠀꠞ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","ꠁꠔꠣ ꠅꠁꠟ ꠖꠥꠁ-ꠡ ꠍꠣꠉꠤ, ꠇꠥꠠꠤꠐꠣ ꠍꠣꠉꠟ, ꠖꠥꠁ-ꠡ ꠝꠦꠠꠤ, ꠇꠥꠠꠤꠐꠣ ꠝꠦꠠꠣ, ");
INSERT INTO syls_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ꠔꠤꠡꠉꠥ ꠛꠣꠁꠌ꠆ꠌꠣꠀꠟꠣ ꠖꠥꠗꠞ ꠃꠐ, ꠖꠥꠁ ꠇꠥꠠꠤ ꠉꠣꠁ, ꠖꠡꠉꠥ ꠛꠤꠍꠣꠟ, ꠄꠇ ꠇꠥꠠꠤ ꠉꠣꠗꠤ ꠀꠞ ꠖꠡꠉꠥ ꠉꠣꠗꠣ, ");
INSERT INTO syls_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠄꠇ ꠄꠇ ꠉꠥꠟꠣꠝꠞ ꠀꠔꠅ ꠄꠇ ꠄꠇ ꠙꠣꠟ ꠡꠝꠎꠣꠁ ꠖꠤꠀ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠀꠉꠦ ꠅꠁꠀ ꠎꠣꠅ ꠀꠞ ꠄꠇ ꠙꠣꠟ ꠕꠣꠇꠤ ꠀꠞꠇ ꠙꠣꠟꠞ ꠝꠣꠎꠦ ꠚꠣꠇ ꠞꠣꠈꠤꠅ।” ");
INSERT INTO syls_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","ꠙꠄꠟꠣ ꠖꠟꠞ ꠉꠥꠟꠣꠝꠞꠦ ꠔꠣꠁꠘ ꠢꠤꠇꠣꠁ ꠖꠤꠟꠣ, “ꠀꠝꠣꠞ ꠜꠣꠁ ꠁꠡʼꠞ ꠟꠉꠦ ꠖꠦꠈꠣ ꠅꠀꠞ ꠛꠣꠖꠦ ꠎꠦꠛꠟꠣ ꠎꠤꠇꠣꠁꠛꠣ, ‘ꠇꠁ ꠎꠣꠁꠔꠣꠄ ꠛꠣ? ꠔꠥꠝꠤ ꠇꠣꠞ ꠝꠣꠘꠥꠡ? ꠔꠥꠝꠣꠞ ꠢꠝꠈꠞ ꠙꠡꠥꠁꠘ ꠇꠣꠞ?’ ");
INSERT INTO syls_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ꠔꠥꠝꠤ ꠎꠥꠀꠙ ꠖꠤꠅ, ‘ꠁꠔꠣ ꠀꠙꠘꠣꠞ ꠉꠥꠟꠣꠝ ꠁꠀꠇꠥꠛꠞ। ꠔꠣꠁꠘ ꠀꠝꠣꠞ ꠝꠥꠘꠤꠛ ꠁꠡʼꠞ ꠟꠣꠉꠤ, ꠁꠔꠣ ꠃꠙꠢꠣꠞ ꠙꠣꠑꠣꠁꠍꠂꠘ। ꠀꠞ ꠔꠣꠁꠘ ꠀꠝꠞꠣꠞ ꠈꠞꠦ ꠅꠁꠀ ꠀꠁꠞꠣ।’ ” ");
INSERT INTO syls_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","ꠅꠃ ꠟꠣꠈꠣꠘ ꠔꠣꠁꠘ ꠖꠥꠁ ꠘꠝ꠆ꠛꠞ, ꠔꠤꠘ ꠘꠝ꠆ꠛꠞ ꠖꠟꠞ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠞꠦꠅ ꠢꠤꠇꠣꠁ ꠖꠤꠟꠣ ꠎꠦꠘ, “ꠁꠡʼꠞ ꠟꠉꠦ ꠖꠦꠈꠣ ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣꠅ ꠅꠃꠟꠣ ꠇꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","ꠀꠞ ꠢꠦꠡꠦ ꠇꠁꠅ, ꠀꠙꠘꠣꠞ ꠉꠥꠟꠣꠝ ꠁꠀꠇꠥꠛꠅ ꠀꠝꠞꠣꠞ ꠈꠞꠦ ꠅꠁꠀ ꠀꠁꠞꠣ।” ꠁꠀꠇꠥꠛꠦ ꠝꠘꠅ ꠇꠞꠟꠣ, “ꠀꠉꠦ ꠃꠙꠢꠣꠞ ꠅꠇꠟ ꠙꠣꠑꠣꠁꠀ ꠔꠣꠘꠦ ꠑꠣꠘ꠆ꠒꠣ ꠇꠞꠝꠥ, ꠛꠣꠖꠦ ꠔꠣꠘ ꠟꠉꠦ ꠖꠦꠈꠣ-ꠡꠣꠁꠇ꠆ꠇꠣꠔ ꠇꠞꠝꠥ, ꠔꠦ ꠔꠣꠁꠘ ꠀꠝꠣꠞꠦ ꠝꠣꠄꠀ ꠇꠞꠤꠟꠤꠔꠣ ꠙꠣꠞꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","ꠔꠣꠘ ꠀꠉꠦ ꠅꠁꠀ ꠃꠙꠢꠣꠞ ꠅꠇꠟ ꠉꠦꠟꠉꠤ, ꠅꠁꠟꠦ ꠔꠣꠁꠘ ꠞꠣꠁꠔ ꠔꠣꠘ ꠒꠦꠞꠣꠔ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ꠢꠦꠡꠦ ꠞꠣꠁꠔ ꠃꠑꠤꠀ ꠔꠣꠘ ꠖꠥꠁꠅ ꠛꠤꠛꠤꠘ, ꠖꠥꠁꠅ ꠛꠣꠘ꠆ꠖꠤ ꠀꠞ ꠄꠉꠣꠞꠅꠉꠥ ꠙꠥꠀꠞꠦ ꠟꠁꠀ ꠙꠣꠅꠄ ꠀꠐꠤꠀ, ꠎꠣꠛ꠆ꠛꠥꠇ ꠈꠣꠟꠞ ꠢꠙꠣꠞꠅ ꠕꠁꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","ꠔꠣꠁꠘ ꠄꠞꠣꠞꠦ ꠈꠣꠟ ꠙꠣꠞ ꠇꠞꠣꠁꠀ ꠔꠣꠘ ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣꠅ ꠢꠘꠅ ꠙꠣꠑꠣꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ꠀꠞ ꠔꠣꠁꠘ ꠄꠇꠟꠣ ꠅꠘꠅ ꠞꠁꠟꠣ, ꠔꠦꠃ ꠉꠣꠁꠛꠤ ꠄꠇꠎꠘ ꠝꠣꠘꠥꠡ ꠀꠁꠀ ꠔꠣꠘ ꠟꠉꠦ ꠞꠣꠁꠔꠜꠞ ꠇꠥꠡ꠆ꠔꠣ-ꠇꠥꠡ꠆ꠔꠤ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","ꠅꠁꠟꠦ ꠔꠣꠁꠘ ꠁꠀꠇꠥꠛꠞꠦ ꠇꠣꠛꠥ ꠇꠞꠔꠣ ꠘꠣ ꠙꠣꠞꠣꠄ ꠄꠘ ꠃꠞꠣꠔꠞ ꠎꠥꠠꠣꠔ ꠝꠣꠞꠟꠣ ꠀꠞ ꠁꠀꠇꠥꠛꠞ ꠃꠞꠣꠔꠞ ꠀꠠ ꠎꠣꠉꠣ ꠕꠘꠦ ꠒꠥꠟꠤ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ꠢꠦꠡꠦ ꠢꠤ ꠝꠣꠘꠡꠦ ꠇꠁꠟꠣ, “ꠚꠎꠞ ꠅꠁꠎꠣꠞ, ꠅꠈꠘ ꠔꠥꠝꠤ ꠀꠝꠣꠞꠦ ꠍꠣꠠꠤ ꠖꠦꠅ।” ꠁꠀꠇꠥꠛꠦ ꠇꠁꠟꠣ, “ꠀꠙꠘꠦ ꠀꠝꠣꠞꠦ ꠖꠥꠀ ꠘꠣ ꠇꠞꠟꠦ ꠍꠣꠠꠔꠣꠝ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","ꠢꠤ ꠝꠣꠘꠡꠦ ꠎꠤꠇꠣꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠘꠣꠝ ꠇꠤꠔꠣ?” ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠁꠀꠇꠥꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ꠅꠃ ꠢꠦꠁꠘ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠀꠟ꠆ꠟꠣ ꠀꠞ ꠝꠣꠘꠡꠞ ꠟꠉꠦ ꠟꠣꠠꠣꠁ ꠇꠞꠤꠀ ꠎꠤꠔꠍ ꠇꠞꠤ, ꠔꠥꠝꠣꠞ ꠘꠣꠝ ꠀꠞ ꠁꠀꠇꠥꠛ ꠞꠁꠔ ꠘꠣꠄ, ꠔꠥꠝꠣꠞ ꠘꠣꠝ ꠅꠁꠟ ꠁꠍꠞꠣꠁꠟ ꠝꠣꠘꠤ, ꠀꠟ꠆ꠟꠣꠞ ꠟꠉꠦ ꠇꠥꠡ꠆ꠔꠤ ꠇꠞꠞꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","ꠁꠀꠇꠥꠛꠦ ꠔꠣꠘꠞꠦ ꠇꠁꠟꠣ, “ꠀꠙꠘꠣꠞ ꠘꠣꠝꠈꠣꠘ ꠇꠤꠔꠣ ꠇꠃꠇ꠆ꠇꠣ।” ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠇꠤꠔꠣꠞ ꠟꠣꠉꠤ ꠀꠝꠣꠞ ꠘꠣꠝ ꠎꠤꠇꠣꠁꠞꠣꠄ?” ꠢꠦꠡꠦ ꠔꠣꠁꠘ ꠁꠀꠇꠥꠛꠞꠦ ꠖꠥꠀ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","ꠅꠃ ꠁꠀꠇꠥꠛꠦ ꠁ ꠎꠣꠉꠣꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠙꠘꠥꠄꠟ ꠝꠣꠘꠤ, ꠀꠟ꠆ꠟꠣꠞ ꠍꠥꠞꠔ। ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠀꠟ꠆ꠟꠣ ꠙꠣꠇꠞꠦ ꠝꠥꠈꠣꠝꠥꠈꠤ ꠖꠦꠈꠤꠀꠅ ꠎꠤꠘ꠆ꠖꠣ ꠞꠁꠍꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","ꠀꠞ ꠁꠀꠇꠥꠛꠦ ꠙꠘꠥꠄꠟ ꠙꠣꠞꠘꠤꠞ ꠛꠣꠖꠦ ꠡꠥꠞꠥꠎ ꠃꠑꠤꠉꠦꠟ। ꠔꠣꠘ ꠃꠞꠣꠔꠞ ꠝꠣꠁꠞꠞ ꠟꠣꠉꠤ ꠟꠦꠋꠠꠣꠁꠔꠣ ꠟꠣꠉꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","ꠄꠞꠟꠣꠉꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠅꠈꠘꠅ ꠞꠣꠘꠞ ꠎꠥꠠꠣꠞ ꠉꠥꠡ꠆ꠔ ꠈꠣꠁꠘ ꠘꠣ, ꠇꠣꠞꠘ ꠔꠣꠁꠘ ꠃꠞꠣꠔꠞ ꠎꠥꠠꠣꠞ ꠞꠉꠞ ꠝꠣꠎꠦ ꠁꠀꠇꠥꠛꠞꠦ ꠝꠣꠞꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","ꠁꠀꠇꠥꠛꠦ ꠌꠣꠁꠀ ꠖꠦꠈꠟꠣ, ꠔꠣꠘ ꠛꠠ ꠜꠣꠁ ꠁꠡꠦ ꠌꠣꠁꠞ-ꠡ ꠝꠣꠘꠥꠡ ꠟꠁꠀ ꠀꠉꠥꠀꠁꠀ ꠀꠁꠞꠣ। ꠅꠃ ꠔꠣꠁꠘ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ꠆ꠔꠞꠦ ꠔꠣꠘ ꠛꠤꠛꠤꠘ ꠟꠦꠀ ꠀꠞ ꠞꠣꠢꠦꠟꠣ ꠀꠞ ꠖꠥꠁꠅ ꠛꠣꠘ꠆ꠖꠤꠞ ꠉꠦꠍꠦ ꠛꠣꠐꠤꠀ ꠖꠤꠟꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","ꠔꠣꠁꠘ ꠔꠣꠘ ꠛꠣꠘ꠆ꠖꠤꠘ ꠀꠞ ꠔꠣꠞꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ꠆ꠔꠞꠦ ꠍꠣꠝꠘꠞ ꠇꠣꠔꠣꠞꠅ ꠞꠣꠈꠟꠣ। ꠛꠣꠖꠦ ꠟꠦꠀ ꠀꠞ ꠔꠣꠘ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ꠆ꠔꠞꠦ, ꠢꠇꠟ ꠢꠦꠡꠦ ꠞꠣꠈꠟꠣ ꠞꠣꠢꠦꠟꠣ ꠀꠞ ꠁꠃꠍꠥꠚꠞꠦ। ");
INSERT INTO syls_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","ꠀꠞ ꠘꠤꠎꠦ ꠄꠞꠣꠞ ꠀꠉꠦ ꠉꠤꠀ ꠡꠣꠔꠛꠣꠞ ꠝꠣꠐꠤꠔ ꠍꠁꠎꠖꠣ ꠇꠞꠤꠀ ꠔꠣꠘ ꠜꠣꠁꠞ ꠉꠦꠍꠦ ꠀꠎꠤꠞ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","ꠔꠦꠃ ꠁꠡꠦ ꠔꠣꠘ ꠉꠦꠍꠦ ꠖꠃꠠꠣꠁꠀ ꠀꠁꠀ ꠀꠁꠘ꠆ꠎꠣ ꠇꠞꠤ ꠉꠟꠣꠔ ꠗꠞꠤꠀ ꠢꠥꠋꠉꠣ ꠖꠤꠟꠣ, ꠀꠞ ꠖꠥꠁꠅꠎꠘꠦ ꠇꠣꠘ꠆ꠖꠤꠔꠣ ꠟꠣꠉꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ꠛꠣꠖꠦ ꠁꠡꠦ ꠝꠥꠈ ꠔꠥꠟꠤꠀ ꠅꠃ ꠛꠦꠐꠤꠘ ꠀꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ꠆ꠔꠞꠦ ꠖꠦꠈꠤꠀ ꠎꠤꠇꠣꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠄꠞꠣ ꠇꠦꠉꠥ?” ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠘ ꠞꠢꠝꠔꠦ ꠀꠙꠘꠣꠞ ꠉꠥꠟꠣꠝꠞꠦ ꠁ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ ꠖꠤꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","ꠔꠦꠃ ꠙꠄꠟꠣ ꠛꠣꠘ꠆ꠖꠤ ꠅꠇꠟꠦ ꠁꠡʼꠞ ꠇꠣꠍꠣꠔ ꠀꠁꠀ ꠔꠣꠞꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠟꠁꠀ ꠝꠣꠕꠣ ꠘꠥꠀꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ꠛꠣꠖꠦ ꠟꠦꠀꠄꠅ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ꠆ꠔꠞꠦ ꠟꠁꠀ ꠀꠉꠥꠀꠁꠀ ꠝꠣꠕꠣ ꠘꠥꠀꠁꠟꠣ, ꠢꠦꠡꠦ ꠁꠃꠍꠥꠚ ꠀꠞ ꠞꠣꠢꠦꠟꠣꠄ ꠉꠤꠀ ꠝꠣꠕꠣ ꠘꠥꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","ꠔꠦꠃ ꠁꠡꠦ ꠇꠁꠟꠣ, “ꠙꠕꠅ ꠎꠦꠔꠣ ꠖꠟꠛꠟ ꠖꠦꠈꠟꠣꠝ, ꠁꠔꠣ ꠇꠤꠅꠞ ꠟꠣꠉꠤ?” ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠝꠥꠘꠤꠛꠞ ꠉꠦꠍꠦ ꠖꠄꠀ ꠙꠣꠅꠀꠞ ꠟꠣꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","ꠁꠡꠦ ꠇꠁꠟꠣ, “ꠜꠣꠁꠞꠦ, ꠀꠝꠣꠞ ꠛꠃꠔꠔꠣ ꠀꠍꠦ, ꠔꠥꠝꠣꠞ ꠁꠔꠣ ꠔꠥꠝꠣꠞꠃ ꠕꠣꠇꠃꠇ।” ");
INSERT INTO syls_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠎꠤ ꠘꠣ, ꠀꠝꠤ ꠝꠤꠘꠔ ꠇꠞꠤꠀ ꠇꠁꠀꠞ, ꠎꠥꠖꠤ ꠀꠝꠣꠞ ꠛꠣꠄ ꠀꠙꠘꠣꠞ ꠖꠄꠀ ꠅꠄ, ꠔꠣꠁꠟꠦ ꠀꠝꠣꠞ ꠖꠦꠅꠀ ꠁ ꠖꠣꠘ-ꠖꠇ꠆ꠇꠤꠘꠣ ꠀꠙꠘꠦ ꠘꠦꠃꠇ꠆ꠇꠣ। ꠀꠙꠘꠦ ꠎꠦꠛꠟꠣ ꠀꠝꠣꠞꠦ ꠈꠥꠡꠤ ꠝꠘꠦ ꠇꠛꠥꠟ ꠇꠞꠍꠂꠘ, ꠔꠦ ꠀꠙꠘꠣꠞ ꠝꠥꠈ ꠖꠦꠈꠣ ꠀꠞ ꠀꠟ꠆ꠟꠣꠞ ꠖꠤꠖꠣꠞ ꠙꠣꠅꠀ ꠀꠝꠣꠞ ꠟꠣꠉꠤ ꠢꠝꠣꠘ। ");
INSERT INTO syls_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ꠀꠟ꠆ꠟꠣꠄ ꠀꠝꠣꠞꠦ ꠞꠢꠝꠔ ꠖꠣꠘ ꠇꠞꠍꠂꠘ, ꠀꠝꠣꠞ ꠛꠃꠔꠔꠣ ꠀꠍꠦ ꠀꠞ ꠅꠃ ꠎꠦꠔꠣ ꠃꠙꠢꠣꠞ ꠀꠙꠘꠣꠞ ꠟꠣꠉꠤ ꠀꠘꠍꠤ, ꠁꠔꠣ ꠀꠙꠘꠦ ꠘꠦꠃꠇ꠆ꠇꠣ।” ꠔꠣꠁꠘ ꠅꠃꠟꠣ ꠝꠤꠘꠔ-ꠇꠣꠎ꠆ꠎꠤ ꠇꠞꠣꠄ, ꠁꠡꠦ ꠁꠔꠣ ꠇꠛꠥꠟ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","ꠁꠡꠦ ꠇꠁꠟꠣ, “ꠌꠟꠅ, ꠀꠝꠞꠣ ꠞꠅꠀꠘꠣ ꠅꠁ, ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠞꠁꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","ꠁꠀꠇꠥꠛꠦ ꠔꠣꠘꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠝꠥꠘꠤꠛꠦ ꠔ ꠎꠣꠘꠞꠣ, ꠁ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠅꠇꠟꠅ ꠢꠥꠞꠥ ꠀꠞ ꠖꠥꠗꠣꠟ ꠉꠣꠁꠀꠁꠘ-ꠝꠦꠠꠤꠘꠅ ꠟꠉꠦ ꠀꠍꠦ, ꠛꠦꠎꠣꠘ ꠅꠁꠀ ꠁꠔꠣꠞꠦ ꠄꠇꠖꠤꠘꠃ ꠀꠐꠣꠁꠟꠦ, ꠢꠇ꠆ꠇꠟꠐꠤ ꠝꠞꠤꠎꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ꠔꠦ ꠝꠥꠘꠤꠛ, ꠀꠙꠘꠦ ꠀꠝꠣꠞ ꠀꠉꠦ ꠎꠣꠃꠇ꠆ꠇꠣꠉꠤ, ꠙꠡꠥꠞ ꠙꠣꠟ ꠀꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠅꠇꠟꠞ ꠌꠟꠣꠞ ꠈꠦꠝꠔꠣ ꠛꠥꠎꠤꠀ ꠀꠝꠤ ꠀꠡ꠆ꠔꠦ ꠀꠡ꠆ꠔꠦ ꠍꠦꠁꠞ ꠄꠟꠣꠇꠣꠔ ꠀꠙꠘꠣꠞ ꠉꠦꠍꠦ ꠀꠁꠞꠣꠝ।” ");
INSERT INTO syls_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","ꠁꠡꠦ ꠇꠁꠟꠣ, “ꠔꠣꠁꠟꠦ ꠀꠝꠣꠞ ꠟꠉꠞ ꠅꠔꠣ ꠇꠄꠎꠘꠞꠦ ꠔꠥꠝꠣꠞ ꠉꠦꠍꠦ ꠕꠁꠀ ꠎꠣꠁꠉꠤ।” ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠁꠔꠣꠞ ꠖꠞꠇꠣꠞ ꠇꠤꠔꠣ? ꠀꠝꠣꠞ ꠝꠥꠘꠤꠛꠞ ꠉꠦꠍꠦ ꠀꠝꠤ ꠎꠦ ꠞꠢꠝ ꠙꠣꠁꠍꠤ, ꠅꠐꠣꠃ ꠔ ꠛꠃꠔꠔꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","ꠀꠞ ꠁꠡ ꠢꠃ ꠖꠤꠘꠃ ꠍꠦꠁꠞꠞ ꠛꠣꠄ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","ꠅꠁꠟꠦ ꠁꠀꠇꠥꠛꠦ ꠡꠥꠇ꠆ꠇꠔꠅ ꠙꠃꠍꠤꠀ ꠘꠤꠎꠞ ꠟꠣꠉꠤ ꠒꠦꠞꠣ ꠛꠣꠘꠣꠁꠀ, ꠙꠡꠥꠞ ꠙꠣꠟꠞ ꠟꠣꠉꠤꠅ ꠇꠄꠈꠣꠘ ꠛꠣꠕꠣꠘ ꠛꠣꠘꠣꠁꠟꠣ, ꠔꠦꠃ ꠁ ꠎꠣꠉꠣꠞ ꠘꠣꠝ ꠅꠁꠟ ꠡꠥꠇ꠆ꠇꠔ ꠝꠣꠘꠤ, ꠒꠦꠞꠣ ꠅꠇꠟ। ");
INSERT INTO syls_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","ꠙꠖ꠆ꠖꠘ-ꠁꠞꠣꠝ ꠕꠘꠦ ꠛꠣꠞ ꠅꠁꠀ ꠁꠀꠇꠥꠛꠦ, ꠍꠢꠤ-ꠍꠣꠟꠣꠝꠔꠦ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠞ ꠡꠤꠈꠤꠝ ꠐꠣꠃꠘꠅ ꠀꠁꠀ, ꠐꠣꠃꠘꠞ ꠛꠣꠞꠦ ꠔꠣꠝ꠆ꠛꠥꠁꠘ ꠉꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","ꠢꠦꠡꠦ ꠅꠃ ꠔꠣꠝ꠆ꠛꠥꠀꠟꠣ ꠎꠝꠤꠘꠈꠣꠘ ꠔꠣꠁꠘ, ꠡꠤꠈꠤꠝꠞ ꠛꠣꠚ ꠢꠝꠥꠞꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠉꠦꠍ ꠕꠘꠦ, ꠞꠥꠙꠣꠞ ꠄꠇ-ꠡ ꠐꠦꠇꠣ ꠖꠤꠀ ꠈꠞꠤꠖ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","ꠀꠞ ꠢꠘꠅ ꠄꠇꠈꠣꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠁꠀ ꠄꠞ ꠘꠣꠝ ꠖꠤꠟꠣ ꠄꠟ-ꠁꠟꠥꠢꠦ-ꠁꠍꠞꠣꠁꠟ ꠝꠣꠘꠤ, ꠀꠟ꠆ꠟꠣ, ꠁꠍꠞꠣꠁꠟꠞ ꠃꠙꠞꠀꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","ꠟꠦꠀꠞ ꠊꠞꠅ ꠖꠤꠘꠣ ꠘꠣꠝꠦ ꠁꠀꠇꠥꠛꠞ ꠎꠦ ꠙꠥꠠꠤ ꠅꠁꠍꠤꠟ, ꠄꠁꠘ ꠄꠇꠖꠤꠘ ꠢꠘꠞ ꠙꠥꠠꠤꠘ꠆ꠔꠞ ꠟꠉꠦ ꠖꠦꠈꠣ ꠇꠞꠣꠔ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","ꠀꠞ ꠡꠤꠈꠤꠝ ꠘꠣꠝꠞ ꠄꠇꠎꠘ ꠝꠣꠘꠡꠞ ꠌꠃꠈꠅ ꠙꠠꠟꠣ। ꠁ ꠡꠤꠈꠤꠝ ꠀꠍꠤꠟ ꠢꠤꠛ꠆ꠛꠤ ꠎꠣꠔꠤꠞ ꠡꠞ꠆ꠖꠣꠞ ꠢꠝꠥꠞꠞ ꠙꠥꠀ। ꠡꠤꠈꠤꠝꠦ ꠄꠞꠦ ꠎꠥꠞ ꠇꠞꠤ ꠗꠞꠤꠀ ꠘꠤꠀ ꠈꠛꠤꠍꠤ ꠇꠣꠝ ꠇꠞꠤꠟ꠆ꠟ। ");
INSERT INTO syls_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","ꠖꠤꠘꠣꠞ ꠛꠣꠄ ꠔꠣꠞ ꠖꠤꠟ ꠀꠡꠤꠇ ꠅꠁꠉꠦꠟ। ꠢꠦ ꠄꠞꠦ ꠝꠢꠛ꠆ꠛꠔ ꠇꠞꠤ ꠄꠞ ꠟꠉꠦ ꠝꠤꠑꠣ ꠝꠤꠑꠣ ꠝꠣꠔ ꠝꠣꠔꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","ꠛꠣꠖꠦ ꠡꠤꠈꠤꠝꠦ ꠔꠣꠞ ꠛꠣꠚ ꠢꠝꠥꠞꠞꠦ ꠇꠁꠟ, “ꠔꠥꠝꠤ ꠅꠃ ꠇꠁꠘꠣꠞꠦ ꠀꠝꠣꠞ ꠟꠉꠦ ꠛꠤꠀꠞ ꠛꠘ꠆ꠖꠛꠡ꠆ꠔ ꠇꠞꠅ।” ");
INSERT INTO syls_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","ꠁꠀꠇꠥꠛꠦ ꠈꠛꠞ ꠙꠣꠁꠟꠣ, ꠡꠤꠈꠤꠝꠦ ꠔꠣꠘ ꠙꠥꠠꠤꠞꠦ ꠛꠦꠁꠎ꠆ꠎꠔꠤ ꠇꠞꠍꠦ, ꠅꠁꠟꠦ ꠔꠣꠘ ꠙꠥꠀꠂꠘ ꠙꠡꠥꠞ ꠙꠣꠟ ꠟꠁꠀ ꠛꠘ꠆ꠖꠅ ꠕꠣꠇꠣꠄ, ꠔꠣꠁꠘ ꠘꠣ-ꠝꠣꠔꠤꠀ ꠘꠤꠞꠣꠁ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","ꠡꠤꠈꠤꠝꠞ ꠛꠣꠚ ꠢꠝꠥꠞꠦ ꠁꠀꠇꠥꠛꠞ ꠉꠦꠍꠦ ꠛꠤꠀꠞ ꠝꠣꠔ ꠟꠁꠀ ꠀꠁꠟ, ");
INSERT INTO syls_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ꠀꠞ ꠁ ꠈꠛꠞ ꠢꠥꠘꠤꠀ ꠁꠀꠇꠥꠛꠞ ꠙꠥꠀꠂꠘꠅ ꠛꠘ꠆ꠖꠅ ꠕꠘꠦ ꠀꠁꠟꠣ। ꠔꠣꠞꠣ ꠛꠦꠕꠣꠄꠀ ꠉꠥꠍꠣ ꠀꠞ ꠉꠞꠝ ꠅꠁꠟꠣ, ꠇꠣꠞꠘ ꠁꠀꠇꠥꠛꠞ ꠙꠥꠠꠤꠞꠦ ꠛꠦꠁꠎ꠆ꠎꠔꠤ ꠇꠞꠣꠄ ꠡꠤꠈꠤꠝꠦ ꠀꠡ꠆ꠔꠣ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠉꠦ ꠛꠦꠁꠎ꠆ꠎꠔꠤ ꠀꠞ ꠘꠣꠎꠣꠁꠎ ꠇꠣꠝ ꠇꠞꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","ꠔꠦꠃ ꠢꠝꠥꠞꠦ ꠄꠞꠣꠞꠦ ꠇꠁꠟ, “ꠀꠙꠘꠣꠞꠣꠞ ꠇꠁꠘꠣꠞ ꠟꠣꠉꠤ ꠀꠝꠣꠞ ꠙꠥꠀ ꠀꠡꠤꠇ ꠅꠁꠉꠦꠍꠦ। ꠖꠄꠀ ꠇꠞꠤ, ꠀꠝꠣꠞ ꠙꠥꠀꠞ ꠟꠉꠦ ꠄꠞ ꠡꠣꠖꠤ ꠖꠤꠟꠣꠃꠇ꠆ꠇꠣ। ");
INSERT INTO syls_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠇꠥꠐꠥꠝꠤꠔꠣ ꠇꠞꠃꠇ꠆ꠇꠣ, ꠀꠝꠞꠣꠞ ꠇꠁꠘꠣꠁꠘ꠆ꠔꠞꠦ ꠀꠙꠘꠣꠞꠣ ꠘꠦꠃꠇ꠆ꠇꠣ ꠀꠞ ꠀꠙꠘꠣꠞꠣꠞꠔꠣ ꠀꠝꠞꠣꠞꠦ ꠖꠦꠃꠇ꠆ꠇꠣ। ");
INSERT INTO syls_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ꠀꠞ ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠕꠣꠇꠃꠇ꠆ꠇꠣ, ꠁ ꠀꠡ꠆ꠔꠣ ꠖꠦꠡꠃ ꠔ ꠍꠣꠝꠘꠦ ꠞꠁꠍꠦ, ꠀꠙꠘꠣꠞꠣ ꠅꠘꠅꠃ ꠕꠣꠇꠂꠘ, ꠇꠣꠄ-ꠇꠣꠞꠛꠣꠞ ꠇꠞꠤꠀ, ꠘꠤꠎꠞ ꠝꠣꠟꠤꠇꠣꠘꠣ ꠇꠣꠁꠝ ꠇꠞꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","ꠡꠤꠈꠤꠝꠦ ꠖꠤꠘꠣꠞ ꠛꠣꠚ-ꠜꠣꠁꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠛꠣꠄ ꠀꠙꠘꠣꠞꠣ ꠖꠄꠀ ꠇꠞꠂꠘ, ꠀꠙꠘꠣꠞꠣ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠎꠦꠔꠣ ꠌꠣꠁꠛꠣ, ꠀꠝꠤ ꠅꠔꠣꠃ ꠖꠤꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","ꠝꠢꠞꠣꠘꠣ ꠀꠞ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠀꠙꠘꠣꠞꠣ ꠎꠦꠔꠣ ꠖꠣꠛꠤ ꠇꠞꠛꠣ ꠀꠝꠤ ꠖꠤꠝꠥ, ꠎꠦꠇꠥꠘꠥ ꠟꠣꠈꠣꠘꠃ ꠖꠤꠘꠣꠞꠦ ꠀꠝꠣꠞ ꠟꠉꠦ ꠛꠤꠀ ꠖꠦꠃꠇ꠆ꠇꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","ꠡꠤꠈꠤꠝꠦ ꠔꠣꠞꠣꠞ ꠛꠁꠘꠞꠦ ꠛꠦꠁꠎ꠆ꠎꠔꠤ ꠇꠞꠍꠤꠟ ꠇꠞꠤ ꠁꠀꠇꠥꠛꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠔꠣꠞꠦ ꠀꠞ ꠔꠣꠞ ꠛꠣꠚ ꠢꠝꠥꠞꠞꠦ ꠜꠣꠘꠣ ꠖꠦꠈꠣꠁꠀ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“ꠝꠍꠟꠝꠣꠘꠤ ꠇꠣꠝ ꠘꠣ ꠇꠞꠣꠁꠟ ꠇꠥꠘꠥ ꠖꠣꠝꠣꠘ꠆ꠖꠞ ꠟꠉꠦ ꠀꠝꠞꠣꠞ ꠛꠁꠘꠞꠦ ꠛꠤꠀ ꠖꠤꠟꠦ ꠀꠝꠞꠣꠞ ꠛꠦꠁꠎ꠆ꠎꠔꠤ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","ꠅꠁꠟꠦ ꠅꠃ ꠇꠣꠝ ꠇꠞꠟꠦ ꠀꠝꠞꠣ ꠞꠣꠎꠤ ꠅꠁꠝꠥ, ꠀꠙꠘꠣꠞꠣ ꠢꠇꠟ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠦ ꠝꠍꠟꠝꠣꠘꠤ ꠇꠞꠣꠁꠀ, ꠀꠝꠞꠣꠞ ꠟꠣꠈꠣꠘ ꠅꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ꠔꠣꠁꠟꠦ ꠀꠝꠞꠣꠞ ꠙꠥꠠꠤꠘ꠆ꠔꠞꠦ ꠀꠙꠘꠣꠞꠣꠞ ꠉꠦꠍꠦ ꠖꠤꠝꠥ ꠀꠞ ꠀꠙꠘꠣꠞꠣꠞ ꠙꠥꠠꠤꠘ꠆ꠔꠞꠦꠅ ꠀꠝꠞꠣ ꠀꠘꠝꠥ, ꠀꠝꠞꠣꠅ ꠀꠙꠘꠣꠞꠣꠞ ꠟꠉꠦ ꠄꠇ ꠎꠣꠔꠤ ꠅꠁꠀ ꠛꠡꠔ ꠇꠞꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","ꠅꠁꠟꠦ ꠀꠙꠘꠣꠞꠣ ꠁ ꠝꠍꠟꠝꠣꠘꠤꠞ ꠇꠕꠣ ꠘꠣ ꠝꠣꠘꠟꠦ, ꠀꠝꠞꠣꠞ ꠇꠁꠘꠣꠞꠦ ꠟꠁꠀ ꠎꠣꠁꠝꠥꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","ꠔꠦꠃ ꠔꠣꠞꠣꠞ ꠁ ꠝꠣꠔꠦ ꠢꠝꠥꠞ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀ ꠡꠤꠈꠤꠝ ꠈꠥꠡꠤ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ꠅꠃ ꠡꠤꠈꠤꠝ ꠅꠁꠟ ꠉꠥꠡ꠆ꠐꠤꠞ ꠝꠣꠎꠦ ꠢꠇꠟ ꠕꠘꠦ ꠖꠣꠝꠤ ꠝꠣꠘꠥꠡ। ꠢꠦ ꠖꠦꠞꠤ ꠘꠣ ꠇꠞꠤꠀ ꠇꠕꠣ ꠝꠣꠘꠤꠟꠣꠁꠟ, ꠇꠣꠞꠘ ꠁꠀꠇꠥꠛꠞ ꠙꠥꠠꠤꠞ ꠛꠣꠄ ꠢꠦ ꠀꠡꠤꠇ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ꠛꠣꠖꠦ ꠐꠣꠃꠘꠞ ꠖꠥꠀꠞꠞ ꠉꠦꠍꠦ ꠀꠁꠀ, ꠢꠝꠥꠞ ꠀꠞ ꠔꠣꠘ ꠙꠥꠀꠄ ꠢꠇ꠆ꠇꠟ ꠝꠣꠘꠡꠞ ꠟꠉꠦ ꠝꠣꠔꠤꠀ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“ꠁ ꠝꠣꠘꠥꠡꠉꠥꠁꠘ꠆ꠔꠦ ꠀꠝꠞꠣꠞꠦ ꠇꠥꠘꠥ ꠎꠣꠝꠦꠟꠣ ꠇꠞꠦꠞ ꠘꠣ। ꠀꠝꠞꠣꠞ ꠖꠦꠡꠅ ꠄꠞꠣꠞ ꠕꠣꠇꠣꠞ ꠟꠣꠉꠤ ꠛꠃꠔ ꠎꠣꠉꠣꠅ ꠀꠍꠦ, ꠔꠦ ꠄꠞꠣ ꠅꠘꠅꠃ ꠕꠣꠇꠃꠇ ꠀꠞ ꠇꠣꠄ-ꠇꠣꠞꠛꠣꠞ ꠇꠞꠃꠇ, ꠀꠝꠞꠣ ꠄꠞꠣꠞ ꠙꠥꠠꠤꠘ꠆ꠔꠞꠦ ꠛꠤꠀ ꠇꠞꠤꠀ ꠀꠘꠤ ꠀꠞ ꠀꠝꠞꠣꠞ ꠙꠥꠠꠤꠘ꠆ꠔꠞꠦꠅ ꠔꠣꠞꠣꠞ ꠉꠦꠍꠦ ꠖꠦꠁ। ");
INSERT INTO syls_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","ꠅꠁꠟꠦ ꠀꠝꠞꠣ ꠄꠇꠈꠣꠘ ꠇꠣꠝ ꠇꠞꠟꠦ, ꠔꠣꠞꠣ ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠄꠇ ꠎꠣꠔꠤ ꠅꠁꠔꠦ ꠞꠣꠎꠤ ꠀꠍꠂꠘ। ꠇꠣꠝꠐꠣ ꠅꠁꠟ, ꠔꠣꠞꠣꠞ ꠟꠣꠈꠣꠘ ꠀꠝꠞꠣꠞꠅ ꠢꠇ꠆ꠇꠟ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠞ ꠝꠍꠟꠝꠣꠘꠤ ꠇꠞꠣꠘꠤ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","ꠀꠞ ꠔꠣꠞꠣꠞ ꠉꠞꠥ-ꠝꠦꠠꠣ, ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠢꠇ꠆ꠇꠟꠔꠣꠃ ꠔ ꠀꠝꠞꠣꠞ ꠅꠁꠛ, ꠔꠣꠞꠣꠞ ꠇꠕꠣꠄ ꠞꠣꠎꠤ ꠅꠁꠟꠦꠃ ꠔꠣꠞꠣ ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠕꠣꠇꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","ꠅꠃ ꠐꠣꠃꠘꠞ ꠢꠇꠟ ꠛꠦꠐꠣꠁꠘ ꠢꠝꠥꠞ ꠀꠞ ꠔꠣꠘ ꠙꠥꠀ ꠡꠤꠈꠤꠝꠞ ꠝꠣꠔꠦ ꠞꠣꠎꠤ ꠅꠁꠟ, ꠀꠞ ꠔꠣꠞꠣ ꠢꠇꠟꠞ ꠝꠍꠟꠝꠣꠘꠤ ꠇꠣꠝ ꠇꠞꠣꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","ꠢꠦꠡꠦ ꠔꠤꠘ ꠖꠤꠘꠞ ꠖꠤꠘ ꠎꠦꠛꠟꠣ ꠢꠇꠟ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠦ ꠝꠍꠟꠝꠣꠘꠤꠞ ꠛꠦꠖꠘꠣꠄ ꠇꠡ꠆ꠐ ꠙꠣꠁꠞꠣ, ꠅꠃ ꠡꠝꠄ ꠖꠤꠘꠣꠞ ꠀꠙꠘ ꠜꠣꠁ ꠁꠀꠇꠥꠛꠞ ꠖꠥꠁ ꠙꠥꠀ ꠡꠤꠝꠤꠅꠘ ꠀꠞ ꠟꠦꠛꠤ, ꠔꠣꠞꠣꠞ ꠔꠟꠥꠀꠞ ꠟꠁꠀ ꠐꠣꠃꠘꠅ ꠢꠣꠝꠣꠁꠀ, ꠄꠞꠣꠞꠦ ꠛꠦ-ꠈꠤꠀꠟꠅ ꠙꠣꠁꠀ ꠢꠇꠟ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠞꠦ ꠝꠣꠞꠤꠟꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ꠔꠣꠞꠣ ꠢꠝꠥꠞ ꠀꠞ ꠔꠣꠘ ꠙꠥꠀ ꠡꠤꠈꠤꠝꠞꠦꠅ ꠔꠟꠥꠀꠞꠖꠤ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠀ ꠡꠤꠈꠤꠝꠞ ꠊꠞ ꠕꠘꠦ ꠖꠤꠘꠣꠞꠦ ꠟꠁꠀ ꠀꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","ꠄꠞꠣ ꠔꠣꠞꠣꠞ ꠛꠁꠘꠞꠦ ꠛꠦꠁꠎ꠆ꠎꠔꠤ ꠇꠞꠍꠤꠟ ꠇꠞꠤ, ꠁꠀꠇꠥꠛꠞ ꠢꠇꠟ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠝꠞꠣ ꠟꠣꠡꠞ ꠉꠦꠍꠦ ꠀꠁꠀ ꠐꠣꠃꠘꠅ ꠟꠥꠐ-ꠔꠞꠣꠎ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","ꠀꠞ ꠐꠣꠃꠘꠞ ꠜꠤꠔꠞ-ꠛꠣꠁꠞꠞ ꠉꠞꠥ-ꠉꠣꠗꠣ, ꠍꠣꠉꠟ-ꠝꠦꠠꠣ, ꠀꠞ ꠈꠦꠔꠞ ꠢꠇꠟꠔꠣ ꠟꠥꠐꠤꠀ ꠟꠁꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ, ꠙꠥꠀ-ꠙꠥꠠꠤꠘ, ꠛꠦꠐꠤꠘ, ꠀꠞ ꠊꠞꠞ ꠢꠇꠟꠔꠣꠅ ꠟꠥꠐ-ꠙꠣꠐ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","ꠢꠦꠡꠦ ꠁꠀꠇꠥꠛꠦ ꠡꠤꠝꠤꠅꠘ ꠀꠞ ꠟꠦꠛꠤꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠁ ꠖꠦꠡꠞ ꠇꠦꠘꠣꠘꠤ ꠀꠞ ꠚꠣꠞꠤꠎꠤ ꠅꠇꠟꠞ ꠉꠦꠍꠦ ꠀꠝꠣꠞꠦ ꠙꠌꠣ-ꠊꠤꠘ꠆ꠘꠣꠞ ꠝꠣꠘꠥꠡ ꠛꠣꠘꠣꠁꠀ ꠝꠍꠤꠛꠔꠅ ꠚꠣꠟꠣꠁꠍ। ꠀꠝꠣꠞ ꠝꠣꠘꠥꠡ ꠇꠝ, ꠅꠈꠘ ꠔꠣꠞꠣ ꠄꠇꠈꠣꠘꠅ ꠅꠁꠀ ꠀꠝꠣꠞꠦ ꠢꠣꠝꠟꠣ ꠇꠞꠟꠦ, ꠀꠝꠤ ꠙꠞꠤꠛꠣꠞꠞ ꠢꠇ꠆ꠇꠟꠞꠦ ꠟꠁꠀ ꠝꠞꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","ꠔꠣꠞꠣ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠢꠦ ꠀꠝꠞꠣꠞ ꠛꠁꠘꠞꠦ ꠘꠤꠀ ꠈꠣꠘꠇꠤ ꠛꠣꠘꠣꠁꠟꠤꠔ ꠘꠤ?” ");
INSERT INTO syls_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ꠄꠞꠛꠣꠖꠦ ꠀꠟ꠆ꠟꠣ ꠙꠣꠇꠦ ꠁꠀꠇꠥꠛꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠢꠤꠞꠛꠣꠞ ꠛꠦꠕꠦꠟꠅ ꠎꠣꠅꠉꠤ। ꠔꠥꠝꠣꠞ ꠜꠣꠁ ꠁꠡʼꠞ ꠉꠦꠍ ꠕꠘꠦ ꠜꠣꠉꠤꠛꠣꠞ ꠛꠣꠟꠣ, ꠎꠦꠁꠘ ꠔꠥꠝꠣꠞꠦ ꠖꠞꠡꠘ ꠖꠤꠍꠟꠣ, ꠢꠃ ꠀꠟ꠆ꠟꠣ ꠙꠣꠇꠞ ꠘꠣꠝꠦ ꠔꠥꠝꠤ ꠢꠘꠅ ꠄꠇꠈꠣꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠅ।” ");
INSERT INTO syls_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","ꠔꠦꠃ ꠁꠀꠇꠥꠛꠦ ꠔꠣꠘ ꠀꠙꠘ ꠝꠣꠘꠡꠞꠦ ꠀꠞ ꠟꠉꠞ ꠢꠇꠟꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣꠞ ꠉꠦꠍꠦ ꠖꠦꠛꠔꠣꠞ ꠎꠦꠔꠣ ꠝꠥꠞ꠆ꠔꠤꠘ ꠀꠍꠦ, ꠁꠔꠣ ꠢꠇ꠆ꠇꠟꠐꠤ ꠚꠣꠟꠣꠅ; ꠀꠞ ꠢꠇꠟꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠅꠁꠀ, ꠍꠣꠚ-ꠍꠥꠔꠞꠣ ꠟꠦꠛꠣꠍ ꠚꠤꠘ꠆ꠖꠅ। ");
INSERT INTO syls_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ꠀꠞ ꠌꠟꠅ, ꠀꠝꠞꠣ ꠛꠦꠕꠦꠟꠅ ꠎꠣꠁꠔꠣꠝꠉꠤ। ꠢꠘꠅ ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠦ ꠄꠇꠈꠣꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠁꠝꠥ, ꠎꠦꠁꠘ ꠝꠍꠤꠛꠔꠞ ꠖꠤꠘꠅ ꠀꠝꠣꠞ ꠖꠥꠀ ꠇꠛꠥꠟ ꠇꠞꠍꠟꠣ, ꠀꠞ ꠀꠝꠣꠞ ꠍꠚꠞꠞ ꠟꠉꠤ ꠅꠁꠍꠟꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","ꠔꠦꠃ ꠔꠣꠞꠣꠞ ꠎꠔ ꠟꠣꠈꠣꠘ ꠖꠦꠛꠔꠣꠞ ꠝꠥꠞ꠆ꠔꠤꠘ ꠀꠞ ꠇꠣꠘꠞ ꠎꠦꠅꠞꠣꠔ ꠀꠍꠤꠟ, ꠢꠇꠟꠔꠣ ꠁꠀꠇꠥꠛꠞ ꠀꠔꠅ ꠖꠤꠟꠣꠁꠟꠣ। ꠔꠣꠁꠘ ꠁꠔꠣ ꠘꠤꠀ ꠡꠤꠈꠤꠝ ꠐꠣꠃꠘꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠄꠟꠘ ꠉꠣꠍꠞ ꠔꠟꠦ ꠉꠣꠠꠤꠟꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","ꠛꠣꠖꠦ ꠔꠣꠞꠣ ꠢꠘ ꠕꠘꠦ ꠞꠅꠀꠘꠣ ꠅꠁꠟꠣ ꠀꠞ ꠀꠟ꠆ꠟꠣꠄ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠢꠇꠟ ꠉꠣꠃ-ꠉꠦꠞꠣꠝꠅ ꠄꠇ ꠒꠞ ꠙꠄꠖꠣ ꠇꠞꠟꠣ, ꠔꠦꠃ ꠢꠤꠘꠞ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠁꠀꠇꠥꠛꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠈꠦꠖꠣꠘꠤꠔ ꠉꠦꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","ꠢꠦꠡꠦ ꠁꠀꠇꠥꠛ ꠀꠞ ꠔꠣꠘ ꠟꠉꠞ ꠢꠇꠟꠦ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠞ ꠟꠥꠎ ꠘꠣꠝꠞ ꠎꠣꠉꠣ, ꠝꠣꠘꠤ ꠛꠦꠕꠦꠟꠅ ꠀꠁꠀ ꠙꠃꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","ꠅꠘꠅ ꠔꠣꠁꠘ ꠄꠇ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠁꠀ, ꠅꠃ ꠎꠣꠉꠣꠞ ꠘꠣꠝ ꠖꠤꠟꠣ ꠄꠟ-ꠛꠦꠕꠦꠟ ꠝꠣꠘꠤ, ꠛꠦꠕꠦꠟꠞ ꠀꠟ꠆ꠟꠣ, ꠇꠣꠞꠘ ꠜꠣꠁꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠜꠣꠉꠤꠛꠣꠞ ꠛꠣꠟꠣ ꠀꠟ꠆ꠟꠣꠄ ꠅꠘꠅꠃ ꠔꠣꠘꠞꠦ ꠖꠤꠖꠣꠞ-ꠖꠞꠡꠘ ꠖꠤꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","ꠀꠞ ꠞꠦꠛꠦꠇꠣꠞ ꠖꠣꠁꠝꠣ ꠖꠛꠥꠞꠣ ꠝꠣꠞꠣ ꠉꠦꠟꠣ। ꠔꠣꠘꠦ ꠛꠦꠕꠦꠟꠞ ꠟꠣꠝꠣꠔ ꠄꠇ ꠄꠟꠘ ꠉꠣꠍꠞ ꠔꠟꠦ ꠝꠣꠐꠤ ꠖꠤꠟꠣ, ꠔꠦꠃ ꠁ ꠎꠣꠉꠣꠞ ꠘꠣꠝ ꠅꠁꠟ ꠄꠟꠘ-ꠛꠣꠈꠥꠔ ꠝꠣꠘꠤ, ꠇꠣꠘ꠆ꠖꠘꠞ ꠉꠣꠍ। ");
INSERT INTO syls_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","ꠁꠀꠇꠥꠛꠦ ꠙꠖ꠆ꠖꠘ-ꠁꠞꠣꠝ ꠕꠣꠇꠤ ꠀꠅꠀꠞ ꠛꠣꠖꠦ, ꠀꠟ꠆ꠟꠣꠄ ꠢꠤꠞꠛꠣꠞ ꠔꠣꠘꠞꠦ ꠖꠤꠖꠣꠞ ꠖꠤꠀ ꠛꠞꠇꠔ ꠘꠣꠎꠤꠟ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ꠀꠟ꠆ꠟꠣꠄ ꠇꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠘꠣꠝ ꠔ ꠁꠀꠇꠥꠛ; ꠅꠁꠟꠦ ꠝꠣꠘꠡꠦ ꠔꠥꠝꠣꠞꠦ ꠀꠞ ꠁꠀꠇꠥꠛ ꠇꠁꠀ ꠒꠣꠇꠔꠣ ꠘꠣꠄ, ꠔꠥꠝꠣꠞꠦ ꠁꠍꠞꠣꠁꠟ ꠇꠁꠛꠣ।” ꠔꠦꠃ ꠔꠣꠘ ꠘꠣꠝ ꠅꠁꠟ ꠁꠍꠞꠣꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠘꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤꠃ ꠡꠞ꠆ꠛ-ꠡꠇ꠆ꠔꠤꠝꠣꠘ ꠀꠟ꠆ꠟꠣ। ꠔꠥꠝꠤ ꠚꠟꠀꠟꠣ ꠅꠁꠀ ꠛꠣꠠꠅ। ꠔꠥꠝꠣ ꠕꠘꠦ ꠄꠇ ꠎꠣꠔꠤ ꠙꠄꠖꠣ ꠅꠁꠛ, ꠁꠐꠣ ꠅꠁꠛ ꠛꠃꠔ ꠉꠥꠡ꠆ꠐꠤꠀꠟꠣ ꠎꠣꠔꠤ, ꠀꠞ ꠔꠥꠝꠣꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠅ ꠛꠣꠖꠡꠣ ꠅꠇꠟ ꠙꠄꠖꠣ ꠅꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","ꠀꠝꠤ ꠁꠛ꠆ꠞꠣꠢꠤꠝ ꠀꠞ ꠁꠍꠢꠣꠇꠞꠦ ꠎꠦ ꠖꠦꠡ ꠖꠣꠘ ꠇꠞꠍꠤ, ꠢꠃ ꠖꠦꠡ ꠅꠈꠘ ꠔꠥꠝꠣꠞꠦ ꠀꠞ ꠔꠥꠝꠣꠞ ꠛꠣꠖꠞ ꠅꠀꠞꠤꠡꠞꠦ ꠖꠤꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ꠀꠟ꠆ꠟꠣꠄ ꠢꠘꠅ ꠁꠀꠇꠥꠛꠞ ꠟꠉꠦ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠤꠀ ꠢꠣꠞꠟꠦ ꠀꠍꠝꠣꠘꠅ ꠔꠡꠞꠤꠚ ꠘꠤꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","ꠁꠀꠇꠥꠛꠦ ꠢꠃ ꠛꠣꠔꠌꠤꠔꠞ ꠎꠣꠉꠣꠔ ꠙꠣꠔ꠆ꠔꠞꠞ ꠄꠇ ꠈꠥꠐꠤ ꠉꠣꠠꠤꠀ, ꠄꠞ ꠃꠙꠞꠦ ꠔꠣꠁꠘ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠦ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣ ꠓꠣꠟꠤꠟꠣ, ꠢꠦꠡꠦ ꠔꠦꠟꠅ ꠓꠣꠟꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","ꠀꠟ꠆ꠟꠣꠄ ꠎꠦꠈꠣꠘꠅ ꠔꠣꠘꠞꠦ ꠖꠤꠖꠣꠞ ꠖꠤꠍꠟꠣ, ꠁꠀꠇꠥꠛꠦ ꠁ ꠎꠣꠉꠣꠞ ꠘꠣꠝ ꠞꠣꠈꠍꠟꠣ ꠛꠦꠕꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ꠛꠣꠖꠦ ꠁꠀꠇꠥꠛ ꠀꠞ ꠔꠣꠘ ꠟꠉꠞ ꠢꠇꠟꠦ ꠛꠦꠕꠦꠟ ꠕꠣꠇꠤ ꠞꠅꠀꠘꠣ ꠇꠞꠤꠀ ꠁꠚ꠆ꠞꠣꠕꠅ ꠙꠃꠍꠣꠞ ꠛꠣꠇ꠆ꠇꠣ ꠀꠉꠦ, ꠞꠣꠢꠦꠟꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠅꠀꠞ ꠛꠤꠡꠦ ꠗꠞꠟ, ꠔꠣꠘ ꠈꠥꠛ ꠔꠇꠟꠤꠚ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠅꠀꠞ ꠛꠤꠡ ꠀꠞꠅ ꠛꠣꠠꠟ, ꠔꠦꠃ ꠖꠣꠁ ꠛꠦꠐꠤꠄ ꠇꠁꠟ, “ꠒꠞꠣꠁꠅ ꠘꠣ ꠉ, ꠁꠛꠣꠞꠅ ꠔꠥꠝꠣꠞ ꠊꠞꠅ ꠙꠥꠀ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","ꠅꠁꠟꠦ ꠞꠣꠢꠦꠟꠣ ꠝꠣꠞꠣ ꠉꠦꠟꠣ। ꠝꠞꠣꠞ ꠡꠝꠄ ꠔꠣꠁꠘ ꠙꠥꠀꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠛꠤꠘ-ꠅꠘꠤ ꠝꠣꠘꠤ, ꠀꠝꠣꠞ ꠔꠇꠟꠤꠚꠞ ꠙꠥꠀ ꠅꠁꠟꠦ ꠛꠣꠚꠦ ꠔꠣꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠛꠤꠘ-ꠁꠀꠝꠤꠘ ꠝꠣꠘꠤ, ꠀꠝꠣꠞ ꠛꠟꠞ ꠙꠥꠀ। ");
INSERT INTO syls_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ꠞꠣꠢꠦꠟꠣꠞ ꠝꠃꠔꠞ ꠛꠣꠖꠦ ꠁꠚ꠆ꠞꠣꠕ, ꠝꠣꠘꠤ ꠛꠦꠕꠦꠟꠢꠣꠝ, ꠎꠣꠅꠀꠞ ꠙꠕꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠔꠣꠘꠞꠦ ꠝꠣꠐꠤ ꠖꠦꠅꠀ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","ꠝꠣꠐꠤ ꠖꠤꠀ ꠢꠣꠞꠟꠦ ꠁꠀꠇꠥꠛꠦ ꠔꠣꠘ ꠇꠄꠛꠞꠞ ꠃꠙꠞꠦ ꠄꠇ ꠙꠣꠔ꠆ꠔꠞꠞ ꠈꠥꠐꠤ ꠉꠣꠠꠟꠣ, ꠁ ꠈꠥꠐꠤ ꠀꠁꠎꠅ ꠅꠘꠅ ꠀꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ꠅꠘ ꠕꠘꠦ ꠁꠍꠞꠣꠁꠟꠦ ꠢꠤꠞꠛꠣꠞ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣ, ꠀꠞ ꠄꠖꠞ ꠝꠤꠘꠣꠞ ꠚꠣꠟꠣꠁꠀ ꠀꠁꠀ ꠔꠣꠘ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ꠁꠍꠞꠣꠁꠟ ꠎꠦꠛꠟꠣ ꠢꠘꠅ ꠞꠁꠞꠣ, ꠅꠃ ꠚꠣꠇꠅ ꠞꠥꠛꠦꠘꠦ ꠉꠤꠀ ꠔꠣꠞ ꠛꠣꠚꠞ ꠛꠣꠖꠞ ꠛꠤꠀꠞ ꠛꠃ ꠛꠤꠟꠢꠣꠞ ꠟꠉꠦ ꠎꠤꠘꠣ ꠇꠞꠟ ꠀꠞ ꠁꠔꠣ ꠁꠍꠞꠣꠁꠟꠞ ꠇꠣꠘꠅ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","ꠁꠀꠇꠥꠛꠞ ꠛꠣꠞꠅꠎꠘ ꠙꠥꠀ ꠀꠍꠟꠣ, ꠟꠦꠀꠞ ꠔꠞꠚꠣ ꠔꠣꠘ ꠛꠠ ꠙꠥꠀ ꠞꠥꠛꠦꠘ, ꠛꠣꠖꠦ ꠡꠤꠝꠤꠅꠘ, ꠟꠦꠛꠤ, ꠄꠢꠥꠖꠣ, ꠁꠍꠣꠈꠞ ꠀꠞ ꠍꠛꠥꠟꠘ। ");
INSERT INTO syls_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","ꠞꠣꠢꠦꠟꠣꠞ ꠔꠞꠚꠣ ꠁꠃꠍꠥꠚ ꠀꠞ ꠛꠤꠘ-ꠁꠀꠝꠤꠘ। ");
INSERT INTO syls_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","ꠞꠣꠢꠦꠟꠣꠞ ꠛꠣꠘ꠆ꠖꠤ ꠛꠤꠟꠢꠣꠞ ꠔꠞꠚꠣ, ꠖꠣꠘ ꠀꠞ ꠘꠙ꠆ꠔꠣꠟꠤ। ");
INSERT INTO syls_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","ꠟꠦꠀꠞ ꠛꠣꠘ꠆ꠖꠤ ꠎꠤꠟꠙꠣꠞ ꠔꠞꠚꠣ, ꠍꠣꠖꠥ ꠀꠞ ꠀꠡꠤꠞ। ꠔꠣꠘ ꠅꠃ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠅꠇꠟ ꠙꠖ꠆ꠖꠘ-ꠁꠞꠣꠝꠅ ꠅꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","ꠢꠦꠡꠦ ꠁꠀꠇꠥꠛ ꠇꠤꠞꠤꠅꠔ-ꠅꠞ꠆ꠛꠞ, ꠝꠣꠘꠤ ꠢꠦꠛꠞꠘꠞ ꠇꠣꠍꠣꠔ ꠝꠝ꠆ꠞꠤ ꠘꠣꠝꠞ ꠎꠣꠉꠣꠔ, ꠔꠣꠘ ꠛꠣꠚ ꠁꠍꠢꠣꠇꠞ ꠉꠦꠍꠦ ꠀꠁꠟꠣ। ꠅꠃ ꠎꠣꠉꠣꠔ ꠁꠛ꠆ꠞꠣꠢꠤꠝ ꠀꠞ ꠁꠍꠢꠣꠇꠦꠅ ꠛꠡꠔ ꠇꠞꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ꠁꠍꠢꠣꠇꠞ ꠛꠄꠅꠡ ꠄꠇ-ꠡ ꠀꠡꠤ ꠛꠞꠍ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ꠀꠞ ꠁꠍꠢꠣꠇ ꠙꠥꠞꠣꠙꠥꠞ ꠛꠥꠠꠣ ꠅꠁꠀ, ꠝꠥꠞꠛ꠆ꠛꠤ ꠛꠄꠅꠡꠅ ꠝꠣꠞꠣ ꠉꠤꠀ ꠔꠣꠘ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠉꠦꠍꠦ ꠉꠤꠀ ꠀꠎꠤꠟꠣ। ꠔꠣꠘ ꠙꠥꠀ ꠁꠡ ꠀꠞ ꠁꠀꠇꠥꠛꠦ ꠔꠣꠘꠞꠦ ꠖꠣꠚꠘ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","ꠅꠃ ꠅꠁꠟ ꠁꠡ ꠛꠣ ꠁꠖꠥꠝꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠛꠄꠀꠘ। ");
INSERT INTO syls_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","ꠁꠡꠦ ꠇꠦꠘꠣꠘꠤ ꠖꠥꠁ ꠙꠥꠠꠤꠞꠦ ꠛꠤꠀ ꠇꠞꠍꠟꠣ। ꠄꠞꠣ ꠅꠁꠟꠣ ꠢꠤꠐ꠆ꠐꠤ ꠄꠟꠘꠞ ꠙꠥꠠꠤ ꠀꠖꠣ, ꠀꠞ ꠢꠤꠛ꠆ꠛꠤ ꠎꠤꠛꠤꠅꠘꠞ ꠘꠣꠔꠤꠘ, ꠅꠘꠣꠞ ꠙꠥꠠꠤ ꠅꠢꠟꠤꠛꠣꠝꠣ। ");
INSERT INTO syls_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ꠄꠞꠣꠞ ꠛꠣꠖꠦꠅ ꠔꠣꠁꠘ ꠁꠍꠝꠣꠁꠟꠞ ꠙꠥꠠꠤ ꠘꠣꠛꠣꠃꠔꠞ ꠛꠁꠘ ꠛꠣꠡꠝꠔꠞꠦ ꠛꠤꠀ ꠇꠞꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","ꠀꠖꠣꠞ ꠙꠦꠐꠅ ꠁꠟꠤꠚꠎ ꠀꠞ ꠛꠣꠡꠝꠔꠞ ꠙꠦꠐꠅ ꠞꠥꠄꠟꠞ ꠎꠘꠝ ꠅꠁꠍꠤꠟ, ");
INSERT INTO syls_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ꠀꠞ ꠅꠢꠟꠤꠛꠣꠝꠣꠞ ꠙꠦꠐꠅ ꠎꠤꠃꠡ, ꠎꠣꠟꠝ ꠀꠞ ꠇꠥꠞꠢꠞ ꠎꠘꠝ ꠅꠁꠍꠤꠟ। ꠁꠡʼꠞ ꠁ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠎꠘꠝ ꠅꠁꠍꠤꠟ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ। ");
INSERT INTO syls_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ꠛꠣꠖꠦ ꠁꠡꠦ ꠔꠣꠘ ꠛꠃꠀꠁꠘ, ꠙꠥꠀ-ꠙꠥꠠꠤꠘ, ꠊꠞꠞ ꠢꠇꠟ ꠝꠣꠘꠥꠡ ꠀꠞ ꠙꠡꠥꠞ ꠙꠣꠟꠣꠁꠘ, ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠇꠣꠝꠣꠁ ꠇꠞꠣ ꠢꠇꠟ ꠗꠘ-ꠖꠃꠟꠔ ꠟꠁꠀ, ꠔꠣꠘ ꠜꠣꠁ ꠁꠀꠇꠥꠛꠞ ꠉꠦꠍ ꠕꠘꠦ ꠢꠞꠤꠀ ꠀꠞꠇ ꠖꠦꠡꠅ ꠉꠦꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","ꠁꠡ ꠀꠞ ꠁꠀꠇꠥꠛꠞ ꠙꠡꠥꠞ ꠙꠣꠟ, ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠅꠔ ꠛꠦꠡꠤ ꠀꠍꠤꠟ ꠎꠦꠘ, ꠄꠞꠣ ꠄꠇꠈꠣꠘꠅ ꠞꠁꠔꠦ ꠢꠤ ꠖꠦꠡꠞ ꠁ ꠎꠣꠉꠣꠄ ꠀꠞ ꠇꠥꠟꠣꠁꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","ꠔꠦꠃ ꠁꠡ ꠍꠦꠁꠞꠞ ꠙꠣꠠꠤ ꠄꠟꠣꠇꠣꠔ ꠉꠤꠀ ꠛꠡꠔ ꠇꠞꠟꠣ। ꠄꠁꠘꠃ ꠁꠖꠥꠝ। ");
INSERT INTO syls_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","ꠅꠃ ꠅꠁꠟ ꠍꠦꠁꠞꠞ ꠙꠣꠠꠞ ꠁꠖꠥꠝꠤ ꠅꠇꠟꠞ ꠝꠥꠟ ꠛꠣꠚ ꠁꠡʼꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠛꠄꠀꠘ। ");
INSERT INTO syls_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ꠁꠡʼꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠘꠣꠝ ꠅꠁꠟ, ꠁꠟꠤꠚꠎ ꠀꠞ ꠞꠥꠄꠟ। ꠁꠟꠤꠚꠎ ꠀꠖꠣꠞ ꠙꠥꠀ, ꠞꠥꠄꠟ ꠛꠣꠡꠝꠔꠞ ꠙꠥꠀ। ");
INSERT INTO syls_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","ꠁꠟꠤꠚꠎꠞ ꠙꠥꠀꠂꠘ ꠅꠁꠟꠣ, ꠔꠂꠝꠘ, ꠅꠝꠣꠞ, ꠎꠚꠅ, ꠉꠣꠕꠣꠝ ꠀꠞ ꠇꠦꠘꠣꠎ। ");
INSERT INTO syls_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ꠁꠡʼꠞ ꠙꠥꠀ ꠁꠟꠤꠚꠎꠞ ꠔꠤꠝꠘꠣ ꠘꠣꠝꠞ ꠄꠇ ꠢꠣꠋꠉꠣꠞ ꠛꠃ ꠀꠍꠤꠟ, ꠄꠞ ꠊꠞꠅ ꠀꠝꠣꠟꠦꠇꠞ ꠎꠘꠝ ꠅꠁꠍꠤꠟ। ꠄꠞꠣ ꠢꠇꠟꠦꠃ ꠁꠡʼꠞ ꠛꠃ ꠀꠖꠣꠞ ꠀꠅꠟꠣꠖ। ");
INSERT INTO syls_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","ꠞꠥꠄꠟꠞ ꠙꠥꠀꠂꠘ ꠅꠁꠟꠣ ꠘꠢꠕ, ꠎꠣꠞꠣꠢ, ꠡꠝ꠆ꠝ ꠀꠞ ꠝꠤꠎ꠆ꠎꠣ। ꠄꠞꠣ ꠁꠡʼꠞ ꠛꠃ ꠛꠣꠡꠝꠔꠞ ꠀꠅꠟꠣꠖ। ");
INSERT INTO syls_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ꠎꠤꠛꠤꠅꠘꠞ ꠘꠣꠔꠤꠘ, ꠅꠘꠣꠞ ꠙꠥꠠꠤ ꠅꠢꠟꠤꠛꠣꠝꠣꠞ ꠔꠞꠚꠣ ꠁꠡʼꠞ ꠙꠥꠀꠂꠘ ꠅꠁꠟꠣ ꠎꠤꠃꠡ, ꠎꠣꠟꠝ ꠀꠞ ꠇꠥꠞꠢ। ");
INSERT INTO syls_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ꠁꠡʼꠞ ꠀꠅꠟꠣꠖꠞ ꠝꠣꠎꠦ ꠄꠞꠣ ꠀꠍꠟꠣ ꠉꠥꠡ꠆ꠐꠤꠞ ꠘꠦꠔꠣ। ꠁꠡʼꠞ ꠛꠠ ꠙꠥꠀ ꠁꠟꠤꠚꠎꠞ ꠙꠥꠀꠂꠘ ꠅꠁꠟꠣ ꠔꠂꠝꠘ, ꠅꠝꠣꠞ, ꠎꠚꠅ, ꠇꠦꠘꠣꠎ, ");
INSERT INTO syls_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ꠇꠥꠞꠢ, ꠉꠣꠕꠣꠝ, ꠀꠞ ꠀꠝꠣꠟꠦꠇ। ꠄꠞꠣ ꠅꠁꠟꠣ ꠁꠖꠥꠝ ꠖꠦꠡꠅ, ꠀꠖꠣꠞ ꠙꠥꠀ ꠁꠟꠤꠚꠎꠞ ꠀꠅꠟꠣꠖ। ");
INSERT INTO syls_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","ꠁꠡʼꠞ ꠙꠥꠀ ꠞꠥꠄꠟꠞ ꠙꠥꠀꠂꠘ ꠎꠦꠞꠣ ꠉꠥꠡ꠆ꠐꠤꠞ ꠘꠦꠔꠣ ꠅꠁꠍꠟꠣ, ꠔꠣꠞꠣ ꠅꠁꠟꠣ ꠘꠢꠕ, ꠎꠣꠞꠣꠢ, ꠡꠝ꠆ꠝ ꠀꠞ ꠝꠤꠎ꠆ꠎꠣ। ꠄꠞꠣ ꠅꠁꠟꠣ ꠁꠖꠥꠝ ꠖꠦꠡꠅ ꠁꠡʼꠞ ꠛꠃ ꠛꠣꠡꠝꠔꠞ ꠙꠥꠀ ꠞꠥꠄꠟꠞ ꠀꠅꠟꠣꠖ। ");
INSERT INTO syls_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","ꠁꠡʼꠞ ꠛꠃ ꠅꠢꠟꠤꠛꠣꠝꠣꠞ ꠎꠦ ꠙꠥꠀꠂꠘ ꠉꠥꠡ꠆ꠐꠤꠞ ꠘꠦꠔꠣ ꠅꠁꠍꠟꠣ, ꠔꠣꠞꠣ ꠅꠁꠟꠣ ꠎꠤꠃꠡ, ꠎꠣꠟꠝ ꠀꠞ ꠇꠥꠞꠢ। ꠄꠞꠣ ꠀꠍꠟꠣ ꠅꠘꠣꠞ ꠙꠥꠠꠤ ꠅꠢꠟꠤꠛꠣꠝꠣꠞ ꠀꠅꠟꠣꠖ। ");
INSERT INTO syls_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","ꠄꠞꠣ ꠅꠁꠟꠣ ꠁꠡ ꠛꠣ ꠁꠖꠥꠝꠞ ꠈꠣꠘ꠆ꠖꠣꠘ ꠀꠞ ꠉꠥꠡ꠆ꠐꠤꠞ ꠘꠦꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","ꠢꠘꠞ ꠢꠥꠞꠤꠅ ꠍꠦꠁꠞꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠘꠣꠝ ꠅꠁꠟ ꠟꠥꠐꠘ, ꠡꠥꠛꠟ, ꠎꠤꠛꠤꠅꠘ, ꠅꠘꠣ, ");
INSERT INTO syls_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ꠖꠤꠡꠥꠘ, ꠄꠕꠡꠞ ꠀꠞ ꠖꠤꠡꠣꠘ। ꠄꠞꠣ ꠢꠇꠟꠦ ꠁꠖꠥꠝ ꠖꠦꠡꠅ ꠍꠦꠁꠞꠞ ꠙꠥꠀꠂꠘ, ꠢꠥꠞꠤꠅ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠘꠦꠔꠣ ꠀꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","ꠟꠥꠐꠘꠞ ꠙꠥꠀꠞ ꠘꠣꠝ ꠅꠁꠟ ꠢꠥꠞꠤ ꠀꠞ ꠢꠦꠝꠣꠝ, ꠀꠞ ꠛꠘꠤꠞ ꠘꠣꠝ ꠔꠤꠝꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","ꠡꠥꠛꠟꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠘꠣꠝ ꠅꠁꠟ ꠅꠟꠛꠘ, ꠝꠣꠘꠢꠕ, ꠁꠛꠣꠟ, ꠡꠚꠅ ꠀꠞ ꠅꠘꠝ। ");
INSERT INTO syls_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","ꠎꠤꠛꠤꠅꠘꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠘꠣꠝ ꠅꠁꠟ ꠅꠄꠀ ꠀꠞ ꠅꠘꠣ। ꠅꠃ ꠅꠘꠣꠃ ꠔꠣꠘ ꠛꠣꠛꠣ ꠎꠤꠛꠤꠅꠘꠞ ꠉꠣꠗꠣ ꠞꠣꠈꠣꠔ ꠉꠤꠀ, ꠝꠞꠥꠜꠥꠝꠤꠞ ꠝꠣꠎꠦ ꠉꠞꠝ ꠙꠣꠘꠤꠞ ꠁꠘ꠆ꠖꠣꠞꠣ ꠅꠇꠟ ꠔꠥꠇꠣꠁꠀ ꠙꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","ꠅꠘꠣꠞ ꠙꠥꠀꠞ ꠘꠣꠝ ꠖꠤꠡꠥꠘ ꠀꠞ ꠙꠥꠠꠤꠞ ꠘꠣꠝ ꠅꠢꠟꠤꠛꠣꠝꠣ। ");
INSERT INTO syls_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","ꠖꠤꠡꠥꠘꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠘꠣꠝ ꠅꠁꠟ ꠢꠤꠝꠖꠘ, ꠁꠡꠛꠘ, ꠎꠤꠔ꠆ꠞꠘ ꠀꠞ ꠇꠦꠞꠣꠘ। ");
INSERT INTO syls_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","ꠄꠕꠡꠞꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠘꠣꠝ ꠅꠁꠟ ꠛꠤꠟꠢꠘ, ꠎꠣꠅꠀꠘ ꠀꠞ ꠀꠇꠘ। ");
INSERT INTO syls_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","ꠖꠤꠡꠣꠘꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠘꠣꠝ ꠅꠁꠟ ꠀꠃꠎ ꠀꠞ ꠅꠞꠣꠘ। ");
INSERT INTO syls_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","ꠢꠥꠞꠤꠅ ꠅꠇꠟꠞ ꠘꠦꠔꠣ ꠅꠁꠟꠣ ꠟꠥꠐꠘ, ꠡꠥꠛꠟ, ꠎꠤꠛꠤꠅꠘ, ꠅꠘꠣ, ");
INSERT INTO syls_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ꠖꠤꠡꠥꠘ, ꠄꠕꠡꠞ ꠀꠞ ꠖꠤꠡꠣꠘ। ꠄꠞꠣ ꠅꠁꠟꠣ ꠍꠦꠁꠞ ꠖꠦꠡꠞ ꠢꠥꠞꠤꠅ ꠉꠥꠡ꠆ꠐꠤꠞ ꠘꠦꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠎꠦ ꠛꠣꠖꠡꠣꠁ ꠢꠥꠇꠥꠝꠔ ꠀꠁꠛꠣꠞ ꠀꠉꠦ, ꠁꠖꠥꠝ ꠖꠦꠡꠅ ꠄꠞꠣꠃ ꠞꠣꠎꠣ ꠀꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","ꠛꠣꠃꠞꠞ ꠙꠥꠀ ꠛꠦꠟꠣ ꠁꠖꠥꠝꠞ ꠞꠣꠎꠣ ꠅꠁꠟꠣ। ꠔꠣꠘ ꠞꠣꠎꠗꠣꠘꠤꠞ ꠘꠣꠝ ꠀꠍꠤꠟ ꠖꠤꠘꠢꠣꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","ꠛꠦꠟꠣ ꠝꠞꠣꠞ ꠛꠣꠖꠦ, ꠔꠣꠘ ꠎꠣꠉꠣꠔ ꠛꠡꠞꠣ ꠐꠣꠃꠘꠞ ꠎꠣꠞꠣꠢꠞ ꠙꠥꠀ ꠎꠥꠛꠛ ꠞꠣꠎꠣ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","ꠎꠥꠛꠛ ꠝꠞꠣꠞ ꠛꠣꠖꠦ ꠔꠂꠝꠘ ꠖꠦꠡꠞ ꠢꠥꠡꠝ ꠢꠘꠞ ꠞꠣꠎꠣ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","ꠢꠥꠡꠝ ꠝꠞꠣꠞ ꠛꠣꠖꠦ ꠔꠣꠘ ꠎꠣꠉꠣꠔ ꠛꠖꠖꠞ ꠙꠥꠀ ꠢꠖꠖ ꠞꠣꠎꠣ ꠅꠁꠟꠣ। ꠔꠣꠁꠘ ꠎꠥꠖ꠆ꠖ ꠇꠞꠤ ꠝꠥꠀꠛ ꠖꠦꠡꠞ ꠝꠣꠖꠤꠀꠘꠤ ꠅꠇꠟꠞꠦ ꠀꠞꠣꠁꠟꠣ। ꠔꠣꠘ ꠞꠣꠎꠗꠣꠘꠤꠞ ꠘꠣꠝ ꠅꠁꠟ ꠅꠛꠤꠕ। ");
INSERT INTO syls_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ꠢꠖꠖ ꠝꠞꠣꠞ ꠛꠣꠖꠦ ꠝꠡ꠆ꠞꠦꠇꠣ ꠐꠣꠃꠘꠞ ꠍꠣꠝꠟꠣ ꠢꠘꠞ ꠞꠣꠎꠣ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","ꠍꠣꠝꠟꠣ ꠝꠞꠣꠞ ꠛꠣꠖꠦ ꠢꠘꠞ ꠚꠥꠞꠣꠔ ꠉꠣꠋꠉꠞ ꠙꠣꠞꠞ ꠞꠢꠛꠔ ꠐꠣꠃꠘꠞ ꠡꠃꠟ ꠞꠣꠎꠣ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","ꠡꠃꠟ ꠝꠞꠣꠞ ꠛꠣꠖꠦ ꠔꠣꠘ ꠎꠣꠉꠣꠔ ꠀꠇꠛꠣꠞꠞ ꠙꠥꠀ ꠛꠣꠀꠟ-ꠢꠣꠘꠘ ꠞꠣꠎꠣ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","ꠀꠇꠛꠣꠞꠞ ꠙꠥꠀ ꠛꠣꠀꠟ-ꠢꠣꠘꠘ ꠝꠞꠣꠞ ꠛꠣꠖꠦ ꠔꠣꠘ ꠎꠣꠉꠣꠔ ꠢꠖꠞ ꠞꠣꠎꠣ ꠅꠁꠟꠣ। ꠔꠣꠘ ꠞꠣꠎꠗꠣꠘꠤꠞ ꠘꠣꠝ ꠀꠍꠤꠟ ꠙꠣꠃ, ꠀꠞ ꠔꠣꠘ ꠛꠃꠞ ꠘꠣꠝ ꠀꠍꠤꠟ ꠝꠢꠦꠐꠣꠛꠦꠟ। ꠄꠁꠘ ꠝꠐꠞꠦꠖꠞ ꠙꠥꠠꠤ ꠀꠞ ꠝꠦꠎꠣꠢꠣꠛꠞ ꠘꠣꠔꠤꠘ। ");
INSERT INTO syls_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","ꠁꠡʼꠞ ꠎꠦꠔꠣ ꠀꠅꠟꠣꠖ ꠅꠇꠟ ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠄꠟꠣꠇꠣꠞ ꠘꠦꠔꠣ ꠀꠍꠟꠣ, ꠔꠣꠞꠣꠞ ꠘꠣꠝ ꠅꠁꠟ, ꠔꠤꠝꠘꠣ, ꠅꠟꠛꠣ ꠀꠞ ꠎꠤꠔꠦꠕ, ");
INSERT INTO syls_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ꠅꠢꠟꠤꠛꠣꠝꠣ, ꠄꠟꠣ, ꠙꠤꠘꠥꠘ, ");
INSERT INTO syls_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ꠇꠦꠘꠣꠎ, ꠔꠂꠝꠘ, ꠝꠤꠛꠎꠣꠞ, ");
INSERT INTO syls_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ꠝꠉꠖꠤꠄꠟ ꠀꠞ ꠅꠞꠣꠝ। ꠄꠞꠣ ꠀꠍꠟꠣ ꠎꠣꠞꠎꠤꠞ ꠖꠦꠡꠞ, ꠎꠣꠞꠎꠤꠞ ꠄꠟꠣꠇꠣꠞ ꠁꠖꠥꠝꠤ ꠘꠦꠔꠣ। ꠁꠖꠥꠝꠤ ꠅꠇꠟꠞ ꠝꠥꠟ ꠛꠣꠚ ꠁꠡʼꠞ ꠛꠄꠀꠘ ꠅꠘꠅꠃ ꠡꠦꠡ। ");
INSERT INTO syls_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","ꠁꠀꠇꠥꠛ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅꠃ ꠞꠁꠟꠣ, ꠔꠣꠘ ꠛꠣꠚꠅ ꠢꠘꠅ ꠝꠥꠍꠣꠚꠤꠞ ꠅꠁꠀ ꠀꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","ꠅꠃ ꠅꠁꠟ ꠁꠀꠇꠥꠛꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠛꠄꠀꠘ। ꠁꠃꠍꠥꠚꠦ ꠡꠔꠞ ꠛꠞꠍ ꠛꠄꠅꠡ ꠕꠘꠦ ꠔꠣꠘ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞ ꠟꠉꠦ ꠝꠦꠠꠣ-ꠍꠣꠉꠟ ꠞꠣꠈꠔꠣ। ꠔꠣꠁꠘ ꠢꠥꠞꠥꠝꠣꠘ ꠕꠘꠦꠃ ꠔꠣꠘ ꠢꠣꠔꠘ ꠝꠣ ꠛꠤꠟꠢꠣ ꠀꠞ ꠎꠤꠟꠙꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠟꠉꠦ ꠞꠁꠔꠣ। ꠀꠞ ꠄꠞꠣꠞ ꠢꠇꠟ ꠛꠣꠖ ꠌꠣꠟ-ꠌꠟꠘꠞ ꠈꠛꠞ ꠛꠣꠚꠞꠦ ꠎꠣꠘꠣꠁꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","ꠁꠃꠍꠥꠚ, ꠁꠍꠞꠣꠁꠟꠞ ꠛꠥꠠꠣ ꠛꠄꠅꠡꠞ ꠙꠥꠀ ꠉꠔꠤꠇꠦ, ꠔꠣꠁꠘ ꠄꠞꠦ ꠢꠇꠟ ꠕꠘꠦ ꠛꠦꠡꠤ ꠝꠣꠄꠀ ꠇꠞꠔꠣ। ꠔꠣꠁꠘ ꠄꠞꠦ ꠄꠇ ꠈꠣꠘ꠆ꠖꠣꠘꠤ ꠎꠥꠛ꠆ꠛꠣ ꠛꠣꠘꠣꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","ꠛꠣꠚꠦ ꠁꠃꠍꠥꠚꠞꠦ ꠢꠇꠟ ꠕꠘꠦ ꠛꠦꠡꠤ ꠝꠣꠄꠀ ꠇꠞꠂꠘ ꠖꠦꠈꠤꠀ, ꠜꠣꠁꠀꠁꠘ꠆ꠔꠦ ꠔꠣꠘꠞꠦ ꠊꠤꠘ꠆ꠘꠣꠁꠔꠣ। ꠔꠣꠞꠣ ꠄꠘ ꠟꠉꠦ ꠜꠣꠟꠣ ꠝꠘꠦ ꠝꠣꠔ-ꠇꠕꠣꠅ ꠝꠣꠔꠔꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ꠁꠃꠍꠥꠚꠦ ꠄꠇ ꠈꠥꠀꠛ ꠖꠦꠈꠤꠀ ꠔꠣꠘ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞꠦ ꠢꠥꠘꠣꠁꠟꠣ, ꠔꠦꠃ ꠔꠣꠞꠣ ꠀꠞꠅ ꠛꠦꠡꠤ ꠊꠤꠘ꠆ꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠈꠥꠀꠛꠦ ꠇꠤꠔꠣ ꠖꠦꠈꠍꠤ ꠢꠥꠘꠅ: ");
INSERT INTO syls_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","ꠀꠝꠤ ꠖꠦꠈꠟꠣꠝ, ꠀꠝꠞꠣ ꠈꠦꠔꠞ ꠝꠣꠎꠦ ꠗꠣꠘꠞ ꠝꠥꠁꠐ ꠛꠣꠘ꠆ꠖꠤꠀꠞ ꠀꠞ ꠀꠝꠣꠞ ꠛꠣꠘ꠆ꠖꠣ ꠝꠥꠁꠐꠈꠣꠘ ꠃꠛꠣꠁꠉꠦꠟ, ꠔꠦꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠥꠁꠐ ꠅꠇꠟꠦ ꠀꠝꠣꠞ ꠝꠥꠁꠐꠞꠦ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠛꠦꠞꠤꠀ ꠍꠁꠎꠖꠣ ꠇꠞꠦꠞ।” ");
INSERT INTO syls_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","ꠅꠃ ꠔꠣꠘ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠦ ꠇꠁꠟꠣ, “ꠔꠥꠁ ꠢꠣꠍꠣꠃ ꠀꠝꠞꠣꠞ ꠞꠣꠎꠣ ꠅꠁꠔꠦ ꠌꠣꠁꠞꠦ ꠘꠤ? ꠔꠥꠁ ꠞꠣꠎꠣ ꠅꠁꠀ ꠀꠝꠞꠣꠞ ꠃꠙꠞꠦ ꠛꠦꠐꠣꠉꠤꠞꠤ ꠇꠞꠔꠦ ꠘꠤ?” ꠔꠦꠃ ꠔꠣꠘ ꠈꠥꠀꠛ ꠀꠞ ꠔꠣꠘ ꠝꠣꠔꠞ ꠟꠣꠉꠤ ꠔꠣꠞꠣ ꠀꠞꠅ ꠛꠦꠡꠤ ꠊꠤꠘ꠆ꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ꠁꠃꠍꠥꠚꠦ ꠢꠤꠞꠛꠣꠞ ꠄꠇ ꠈꠥꠀꠛ ꠖꠦꠈꠤꠀ ꠔꠣꠘ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞꠦ ꠢꠥꠘꠣꠁꠟꠣ। ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠢꠥꠘꠅ, ꠀꠝꠤ ꠢꠤꠞꠛꠣꠞ ꠈꠥꠀꠛꠦ ꠖꠦꠈꠍꠤ, ꠌꠣꠘ-ꠡꠥꠞꠥꠎ ꠀꠞ ꠄꠉꠣꠞꠅꠐꠣ ꠔꠦꠞꠣꠄ ꠀꠝꠣꠞꠦ ꠍꠁꠎꠖꠣ ꠇꠞꠦꠞ।” ");
INSERT INTO syls_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","ꠔꠣꠁꠘ ꠁ ꠈꠥꠀꠛꠞ ꠇꠕꠣ ꠔꠣꠘ ꠛꠣꠚ ꠀꠞ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞ ꠉꠦꠍꠦ ꠇꠁꠀ ꠢꠣꠞꠟꠦ, ꠛꠣꠚꠦ ꠔꠣꠘꠞꠦ ꠗꠝꠇꠣꠁꠀ ꠇꠁꠟꠣ, “ꠔꠥꠁꠘ ꠁꠔꠣ ꠇꠥꠘ ꠎꠣꠔꠞ ꠈꠥꠀꠛ ꠖꠦꠈꠟꠦ, ꠞꠦ ꠙꠥꠔ? ꠔꠞ ꠝꠣ-ꠜꠣꠁꠀꠁꠘ ꠀꠞ ꠀꠝꠤꠅ ꠇꠤꠔꠣ ꠢꠣꠍꠣꠃ ꠔꠞꠦ ꠍꠁꠎꠖꠣ ꠇꠞꠔꠣꠝ ꠘꠤ?” ");
INSERT INTO syls_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","ꠀꠞ ꠁꠃꠍꠥꠚꠞꠦ ꠔꠣꠘ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠦ ꠈꠥꠛ ꠁꠋꠡꠣꠁꠔꠣ। ꠅꠁꠟꠦ ꠛꠣꠚꠦ ꠁ ꠈꠥꠀꠛꠞ ꠇꠕꠣ ꠝꠘꠅ ꠞꠣꠈꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","ꠀꠞ ꠔꠣꠘ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠦ ꠛꠣꠚꠞ ꠙꠡꠥꠞ ꠙꠣꠟ ꠟꠁꠀ ꠡꠤꠈꠤꠝꠅ ꠞꠣꠈꠣꠔ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ꠔꠦꠃ ꠁꠍꠞꠣꠁꠟꠦ ꠁꠃꠍꠥꠚꠞꠦ ꠇꠁꠟꠣ, “ꠔꠞ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠦ ꠙꠡꠥꠞ ꠙꠣꠟ ꠞꠣꠈꠣꠔ ꠡꠤꠈꠤꠝꠅ ꠉꠦꠍꠂꠘ, ꠔꠦ ꠀꠄ, ꠀꠝꠤ ꠔꠞꠦꠅ ꠢꠘꠅ ꠙꠣꠑꠣꠁ।” ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠀꠁꠌ꠆ꠍꠣ, ꠀꠝꠤ ꠎꠣꠁꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","ꠁꠍꠞꠣꠁꠟꠦ ꠔꠣꠘꠦ ꠇꠁꠟꠣ, “ꠔꠥꠁ ꠉꠤꠀ ꠔꠞ ꠜꠣꠁꠀꠁꠘ ꠀꠞ ꠙꠡꠥꠞ ꠙꠣꠟꠞ ꠈꠛꠞ-ꠀꠘ꠆ꠔꠞ ꠢꠥꠘꠤꠀ ꠀꠁꠀ ꠀꠝꠣꠞꠦ ꠇꠁꠍ।” ꠔꠦꠃ ꠔꠣꠁꠘ ꠁꠃꠍꠥꠚꠞꠦ ꠢꠦꠛꠞꠘ ꠕꠘꠦ ꠡꠤꠈꠤꠝꠅ ꠙꠣꠑꠣꠁꠟꠣ। ꠀꠞ ꠁꠃꠍꠥꠚꠅ ꠉꠤꠀ ꠡꠤꠈꠤꠝꠅ ꠀꠎꠤꠞ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ꠀꠁꠀ ꠢꠣꠞꠟꠦ ꠔꠣꠘꠞꠦ ꠈꠦꠔꠞ ꠝꠣꠎꠦ ꠊꠥꠞꠣ-ꠚꠤꠞꠣꠔ ꠖꠦꠈꠤꠀ ꠄꠇ ꠛꠦꠐꠣꠄ ꠎꠤꠇꠣꠁꠟꠣ, “ꠔꠥꠝꠤ ꠇꠤꠔꠣ ꠔꠥꠇꠣꠁꠞꠣꠄ ꠛꠣ?” ");
INSERT INTO syls_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","ꠁꠃꠍꠥꠚꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠀꠝꠣꠞ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞꠦ ꠔꠥꠇꠣꠁꠀꠞ। ꠀꠙꠘꠦ ꠎꠣꠘꠂꠘ ꠘꠤ, ꠄꠞꠣ ꠙꠡꠥꠞ ꠙꠣꠟ ꠇꠥꠘ ꠎꠣꠉꠣꠔ ꠞꠣꠈꠞꠣ?” ");
INSERT INTO syls_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","ꠢꠤ ꠛꠦꠐꠣꠄ ꠇꠁꠟꠣ, “ꠔꠣꠞꠣ ꠁꠘ ꠕꠘꠦ ꠉꠦꠍꠂꠘꠉꠤ। ꠀꠝꠤ ꠢꠥꠘꠍꠤ ꠔꠣꠞꠣ ꠝꠣꠔꠤꠞꠣ, ꠀꠅ, ꠀꠝꠞꠣ ꠖꠥꠕꠘꠅ ꠎꠣꠁꠉꠤ।” ꠅꠃ ꠁꠃꠍꠥꠚꠦ ꠔꠥꠇꠣꠁ ꠔꠥꠇꠣꠁ ꠖꠥꠕꠘꠅ ꠉꠤꠀ ꠔꠣꠞꠣꠞꠦ ꠙꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","ꠜꠣꠁꠀꠁꠘ꠆ꠔꠦ ꠖꠥꠞꠁ ꠕꠘꠦ ꠔꠣꠘꠞꠦ ꠖꠦꠈꠟ, ꠀꠞ ꠔꠣꠞꠣꠞ ꠉꠦꠍꠦ ꠙꠃꠍꠣꠞ ꠀꠉꠦꠃ ꠔꠣꠞꠣ ꠄꠘꠦ ꠈꠥꠘ ꠇꠞꠣꠞ ꠝꠔꠟꠛ ꠇꠞꠟ। ");
INSERT INTO syls_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","ꠔꠣꠞꠣ ꠄꠇꠎꠘꠦ ꠀꠞꠇ ꠎꠘꠞꠦ ꠇꠁꠟ, “ꠅꠃ ꠖꠦꠈꠅ, ꠈꠥꠀꠛ ꠖꠦꠈꠞꠣ ꠍꠣꠛ ꠀꠁꠞꠣ। ");
INSERT INTO syls_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ꠀꠅ, ꠅꠈꠘꠃ ꠀꠝꠞꠣ ꠄꠘꠦ ꠈꠔꠝ ꠇꠞꠤꠀ ꠅꠃ ꠉꠣꠔꠅ ꠚꠣꠟꠣꠁ ꠖꠦꠁ; ꠛꠣꠖꠦ ꠇꠁꠝꠥ, ꠇꠥꠘꠥ ꠎꠋꠟꠤ ꠎꠣꠘꠥꠀꠞꠦ ꠈꠣꠁꠟꠣꠁꠍꠦ, ꠢꠦꠡꠦ ꠖꠦꠈꠝꠥꠘꠦ, ꠔꠣꠞ ꠈꠥꠀꠛꠞ ꠖꠡꠣ ꠇꠤꠔꠣ ꠅꠄ?” ");
INSERT INTO syls_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","ꠅꠁꠟꠦ ꠞꠥꠛꠦꠘꠦ ꠁꠔꠣ ꠢꠥꠘꠤꠀ ꠔꠣꠞꠣꠞ ꠀꠔ ꠕꠣꠇꠤ ꠄꠘꠞꠦ ꠛꠣꠌꠣꠁꠛꠣꠞ ꠟꠣꠉꠤ ꠇꠁꠟꠣ, “ꠔꠣꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠅ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","ꠔꠣꠁꠘ ꠄꠞꠣꠞꠦ ꠙꠞꠣꠝꠤꠡ ꠖꠤꠟꠣ, “ꠈꠥꠘ-ꠈꠣꠞꠣꠙꠤ ꠇꠞꠣꠔ ꠎꠣꠁꠅ ꠘꠣ, ꠘꠤꠎꠞ ꠀꠔꠦ ꠘꠣ ꠝꠣꠞꠤꠀ ꠅꠉꠥꠞꠦ ꠄꠝꠘꠦꠃ ꠉꠣꠔꠞ ꠝꠣꠎꠦ ꠚꠣꠟꠣꠁ ꠖꠦꠅ।” ꠅꠃꠟꠣ ꠔꠣꠁꠘ ꠁꠃꠍꠥꠚꠞꠦ ꠔꠣꠞꠣꠞ ꠀꠔ ꠕꠘꠦ ꠛꠣꠌꠣꠁꠀ, ꠛꠣꠚꠞ ꠀꠔꠅ ꠙꠣꠑꠣꠘꠤꠞ ꠌꠦꠡ꠆ꠐꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","ꠁꠃꠍꠥꠚ ꠔꠣꠘ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞ ꠉꠦꠍꠦ ꠀꠁꠔꠦꠃ ꠔꠣꠞꠣ, ꠔꠣꠘ ꠉꠔꠞ ꠕꠘꠦ ꠎꠥꠛ꠆ꠛꠣ ꠈꠥꠟꠤꠟꠣꠁꠟꠣ, ꠢꠃ ꠈꠣꠘ꠆ꠖꠣꠘꠤ ꠎꠥꠛ꠆ꠛꠣꠐꠣ ꠐꠣꠘꠤꠀ ꠈꠥꠟꠤꠟꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ꠀꠞ ꠔꠣꠘꠦ ꠗꠞꠤꠀ ꠉꠣꠔꠞ ꠝꠣꠎꠦ ꠚꠣꠟꠣꠁ ꠖꠤꠟꠣ। ꠁ ꠉꠣꠔ ꠢꠥꠇꠘꠣ ꠀꠍꠤꠟ, ꠇꠥꠘꠥ ꠙꠣꠘꠤ ꠀꠍꠤꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","ꠢꠦꠡꠦ ꠔꠣꠞꠣ ꠈꠣꠅꠀꠔ ꠛꠁꠀ ꠌꠣꠁꠀ ꠖꠦꠈꠟꠣ, ꠉꠤꠟꠤꠅꠖ ꠕꠣꠇꠤ ꠁꠍꠝꠣꠁꠟꠤ ꠄꠇ ꠛꠦꠙꠣꠞꠤꠞ ꠖꠟ ꠁꠛꠣꠄ ꠀꠞ। ꠄꠞꠣ ꠃꠐꠞ ꠙꠤꠑꠤꠔ ꠇꠞꠤ ꠈꠥꠡꠛꠄ ꠝꠡꠟꠣ, ꠀꠉꠞ, ꠀꠞ ꠝꠦꠡꠇꠦ-ꠀꠝ꠆ꠛꠞ ꠟꠁꠀ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠎꠣꠁꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","ꠅꠃ ꠄꠢꠥꠖꠣꠄ ꠔꠣꠞ ꠜꠣꠁꠀꠁꠘꠞꠦ ꠇꠁꠟ, “ꠗꠞꠅ, ꠜꠣꠁꠞꠦ ꠈꠥꠘ ꠇꠞꠤꠀ ꠀꠝꠞꠣ ꠟꠥꠇꠣꠁꠟꠤꠟꠣꠝ, ꠔꠦꠃ ꠀꠝꠞꠣꠞ ꠇꠤꠔꠣ ꠟꠣꠜ ꠅꠁꠛ? ");
INSERT INTO syls_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","ꠢꠦ ꠔ ꠀꠝꠞꠣꠞꠃ ꠜꠣꠁ, ꠀꠝꠞꠣꠞ ꠀꠙꠘ ꠟꠃ ꠀꠞ ꠉꠥꠡ꠆ꠔ। ꠔꠦ ꠔꠣꠞ ꠡꠞꠤꠟꠅ ꠀꠔ ꠘꠣ ꠖꠤꠀ ꠀꠅ, ꠁꠍꠝꠣꠁꠟꠤ ꠅꠇꠟꠞ ꠉꠦꠍꠦ ꠔꠣꠞꠦ ꠛꠦꠌꠤꠟꠣꠁ।” ꠅꠃ ꠜꠣꠁꠀꠁꠘꠅ ꠞꠣꠎꠤ ꠅꠁꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ꠢꠃ ꠝꠣꠖꠤꠀꠘꠤ ꠛꠦꠙꠣꠞꠤ ꠅꠇꠟ ꠇꠣꠍꠣꠔ ꠀꠁꠔꠦꠃ, ꠜꠣꠁꠀꠁꠘ꠆ꠔꠦ ꠁꠃꠍꠥꠚꠞꠦ ꠉꠣꠔꠅ ꠕꠘꠦ ꠐꠣꠘꠤꠀ ꠔꠥꠟꠟꠣ ꠀꠞ ꠄꠇ ꠇꠥꠠꠤ ꠞꠥꠙꠣꠞ ꠐꠦꠇꠣꠞ ꠛꠖꠟꠣ, ꠁꠍꠝꠣꠁꠟꠤ ꠅꠇꠟꠞ ꠉꠦꠍꠦ ꠔꠣꠘꠦ ꠛꠦꠌꠤꠟꠣꠁꠟꠣ। ꠄꠞꠣ ꠁꠃꠍꠥꠚꠞꠦ ꠟꠁꠀ ꠝꠤꠡꠞꠅ ꠉꠦꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","ꠛꠣꠖꠦ ꠞꠥꠛꠦꠘꠦ ꠢꠃ ꠉꠣꠔꠞ ꠉꠦꠍꠦ ꠀꠁꠀ ꠁꠃꠍꠥꠚꠞꠦ ꠘꠣ ꠖꠦꠈꠤꠀ, ꠔꠣꠘ ꠉꠔꠞꠞ ꠇꠥꠞ꠆ꠔꠣ ꠚꠣꠞꠤꠟ꠆ꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞ ꠉꠦꠍꠦ ꠉꠤꠀ ꠇꠁꠟꠣ, “ꠙꠥꠀꠉꠥ ꠔ ꠁꠘꠅ ꠘꠣꠄ। ꠅꠈꠘ ꠀꠝꠤ ꠇꠤꠔꠣ ꠇꠞꠔꠣꠝ?” ");
INSERT INTO syls_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","ꠅꠃ ꠔꠣꠞꠣ ꠄꠇ ꠛꠇꠞꠤ ꠝꠣꠞꠤꠀ, ꠄꠞ ꠟꠃ ꠁꠃꠍꠥꠚꠞ ꠢꠃ ꠎꠥꠛ꠆ꠛꠣꠔ ꠟꠣꠉꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","ꠛꠣꠖꠦ ꠝꠣꠘꠥꠡꠖꠤ ꠅꠃ ꠎꠥꠛ꠆ꠛꠣ ꠔꠣꠞꠣꠞ ꠛꠣꠚꠞ ꠉꠦꠍꠦ ꠙꠣꠑꠣꠁꠀ ꠇꠁꠟꠣ, “ꠁꠐꠣ ꠀꠝꠞꠣ ꠙꠕꠅ ꠙꠣꠁꠍꠤ, ꠔꠦ ꠀꠙꠘꠦ ꠜꠣꠟꠣ ꠇꠞꠤꠀ ꠖꠦꠈꠃꠇ꠆ꠇꠣ, ꠁꠐꠣ ꠀꠙꠘꠣꠞ ꠙꠥꠀꠞ ꠎꠥꠛ꠆ꠛꠣ ꠘꠤ?” ");
INSERT INTO syls_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","ꠁꠀꠇꠥꠛꠦ ꠁ ꠎꠥꠛ꠆ꠛꠣ ꠌꠤꠘꠤꠀ ꠇꠁꠟꠣ, “ꠁꠐꠣ ꠔ ꠀꠝꠣꠞ ꠙꠥꠀꠞꠃ। ꠔꠣꠞꠦ ꠇꠥꠘꠥ ꠎꠋꠟꠤ ꠎꠣꠘꠥꠀꠞꠦ ꠈꠣꠁꠟꠤꠍꠦ, ꠔꠣꠞꠦ ꠘꠤꠌꠄ ꠍꠤꠠꠤ-ꠛꠤꠠꠤꠟꠣꠁꠍꠦ।” ");
INSERT INTO syls_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","ꠔꠣꠁꠘ ꠚꠤꠘ꠆ꠘꠞ ꠇꠣꠙꠠ ꠍꠤꠠꠤꠀ, ꠇꠝꠞꠅ ꠍꠟꠣꠞ ꠌꠐ ꠛꠣꠘ꠆ꠖꠤꠀ, ꠙꠥꠀꠞ ꠟꠣꠉꠤ ꠛꠃꠔ ꠖꠤꠘ ꠝꠣꠔ꠆ꠔꠝ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","ꠔꠣꠘ ꠢꠇꠟ ꠙꠥꠀ-ꠙꠥꠠꠤꠄ ꠔꠣꠘꠦ ꠛꠥꠎꠣꠁꠔꠣ ꠌꠣꠁꠟꠣ, ꠅꠁꠟꠦ ꠇꠥꠘꠥ ꠛꠥꠎꠦꠃ ꠔꠣꠘ ꠛꠥꠇ ꠑꠣꠘ꠆ꠒꠣ ꠅꠁꠟ ꠘꠣ। ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠝꠣꠔ꠆ꠔꠝ ꠇꠞꠤ ꠇꠞꠤ ꠀꠝꠣꠞ ꠙꠥꠀꠞ ꠉꠦꠍꠦ ꠇꠄꠛꠞꠅ ꠢꠣꠝꠣꠁꠝꠥ।” ꠙꠥꠀꠞ ꠟꠣꠉꠤ ꠔꠣꠁꠘ ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠣꠘ꠆ꠖꠣ-ꠇꠣꠐꠤꠔ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","ꠄꠞ ꠝꠣꠎꠦ ꠝꠣꠖꠤꠀꠘꠤ ꠅꠇꠟꠦ ꠁꠃꠍꠥꠚꠞꠦ ꠝꠤꠡꠞꠅ ꠘꠤꠀ, ꠚꠦꠞꠣꠃꠘꠞ ꠇꠞ꠆ꠝꠌꠣꠞꠤ ꠀꠎꠤꠎꠞ ꠉꠦꠍꠦ ꠛꠦꠌꠤꠟꠣꠁꠟꠣ, ꠁ ꠇꠞ꠆ꠝꠌꠣꠞꠤ ꠀꠍꠟꠣ ꠔꠣꠘ ꠙꠞꠗꠣꠘ ꠉꠣꠒ। ");
INSERT INTO syls_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","ꠄꠢꠥꠖꠣꠄ ꠔꠣꠞ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞꠦ ꠕꠁꠀ ꠅꠖꠥꠟ꠆ꠟꠝ ꠉꠣꠃꠞ ꠢꠤꠞꠣ ꠘꠣꠝꠞ ꠄꠇ ꠝꠣꠘꠡꠞ ꠟꠉꠦ ꠞꠅꠀꠔ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","ꠢꠘꠅ ꠞꠁꠀ ꠡꠥꠀ ꠘꠣꠝꠞ ꠄꠇ ꠇꠦꠘꠣꠘꠤ ꠝꠣꠘꠡꠞ ꠙꠥꠠꠤꠞ ꠟꠉꠦ ꠖꠦꠈꠣ ꠅꠁꠟ, ꠖꠦꠈꠤꠀ ꠢꠦ ꠅꠃ ꠙꠥꠠꠤꠞꠦ ꠛꠤꠀ ꠇꠞꠟ। ");
INSERT INTO syls_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ꠛꠤꠀꠞ ꠛꠣꠖꠦ ꠢꠃ ꠛꠦꠐꠤꠞ ꠊꠞꠅ ꠄꠇ ꠙꠥꠀ ꠅꠁꠟ, ꠄꠢꠥꠖꠣꠄ ꠔꠣꠞ ꠘꠣꠝ ꠞꠣꠈꠟ ꠄꠁꠞ। ");
INSERT INTO syls_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ꠢꠤꠞꠛꠣꠞ ꠛꠦꠐꠤꠞ ꠊꠞꠅ ꠀꠞꠇ ꠙꠥꠀ ꠅꠁꠟꠦ, ꠝꠣʼꠄ ꠔꠣꠞ ꠘꠣꠝ ꠞꠣꠈꠟ ꠅꠘꠘ। ");
INSERT INTO syls_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ꠢꠦꠡꠦ ꠅꠃ ꠛꠦꠐꠤꠞ ꠀꠞꠇ ꠙꠥꠀ ꠅꠁꠟꠦ, ꠔꠣꠞ ꠘꠣꠝ ꠞꠣꠈꠟ ꠡꠦꠟꠣ। ꠁ ꠡꠝꠄ ꠔꠣꠞꠣ ꠇꠡꠤꠛ ꠉꠣꠃꠔ ꠞꠁꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","ꠀꠞ ꠄꠢꠥꠖꠣꠄ ꠔꠣꠞ ꠛꠠ ꠙꠥꠀ ꠄꠁꠞꠞ ꠟꠉꠦ ꠔꠣꠝꠣꠞ ꠘꠣꠝꠞ ꠄꠇ ꠙꠥꠠꠤꠞꠦ ꠛꠤꠀ ꠖꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","ꠅꠁꠟꠦ ꠔꠣꠞ ꠁ ꠙꠥꠀ ꠝꠣꠛꠥꠖꠞ ꠘꠎꠞꠅ ꠈꠥꠛ ꠈꠛꠤꠍ ꠀꠍꠤꠟ ꠉꠔꠤꠇꠦ, ꠝꠣꠛꠥꠖꠦ ꠔꠣꠞꠦ ꠝꠣꠞꠤꠟꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","ꠅꠃ ꠄꠢꠥꠖꠣꠄ ꠅꠘꠘꠞꠦ ꠇꠁꠟ, “ꠔꠥꠝꠣꠞ ꠜꠣꠛꠤꠞꠦ ꠛꠤꠀ ꠇꠞꠤꠟꠣꠅ। ꠔꠣꠁꠞ ꠖꠦꠅꠞ ꠅꠀꠄ ꠔꠥꠝꠣꠞ ꠎꠦꠔꠣ ꠇꠞꠣ ꠎꠞꠥꠞ ꠀꠍꠦ, ꠁꠔꠣ ꠀꠖꠣꠄ ꠇꠞꠅ ꠀꠞ ꠘꠤꠎꠞ ꠜꠣꠁꠞ ꠅꠀꠞꠤꠡ ꠙꠄꠖꠣ ꠇꠞꠅ।” ");
INSERT INTO syls_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ꠅꠘꠘꠦ ꠎꠣꠘꠔ, ꠁ ꠅꠀꠞꠤꠡ ꠔꠣꠞ ꠘꠤꠎꠞ ꠅꠁꠔ ꠘꠣꠄ, ꠀꠞ ꠔꠣꠞ ꠜꠣꠁꠞ ꠅꠀꠞꠤꠡ ꠞꠣꠈꠔꠦ ꠔꠣꠞ ꠈꠤꠀꠟ ꠀꠍꠤꠟ ꠘꠣ ꠉꠔꠤꠇꠦ, ꠔꠣꠁꠞ ꠟꠉꠦ ꠝꠤꠟꠣ-ꠝꠤꠡꠣꠞ ꠡꠝꠄ ꠔꠣꠞ ꠛꠤꠎ ꠛꠣꠁꠞꠦ ꠝꠣꠐꠤꠔ ꠚꠣꠟꠣꠁ ꠖꠤꠔ। ");
INSERT INTO syls_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","ꠝꠣꠛꠥꠖꠦ ꠔꠣꠞ ꠁ ꠇꠣꠝꠦ ꠘꠣꠞꠣꠎ ꠅꠁꠟꠣ, ꠔꠣꠁꠘ ꠄꠁꠞꠞꠦꠅ ꠝꠣꠞꠤꠟꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","ꠅꠃ ꠄꠢꠥꠖꠣꠄ ꠔꠣꠞ ꠙꠥꠀꠞ ꠛꠃ ꠔꠣꠝꠣꠞꠞꠦ ꠇꠁꠟ, “ꠀꠝꠣꠞ ꠙꠥꠀ ꠡꠦꠟꠣ ꠎꠔꠖꠤꠘ ꠛꠠ ꠘꠣ ꠅꠄ, ꠅꠔꠖꠤꠘ ꠔꠥꠝꠣꠞ ꠛꠣꠚꠞ ꠛꠣꠠꠤꠔ ꠉꠤꠀ ꠠꠣꠠꠤ ꠅꠁꠀꠃ ꠞꠅ।” ꠄꠢꠥꠖꠣꠄ ꠒꠞꠣꠁꠟ, ꠡꠦꠟꠣꠅ ꠔꠣꠞ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞ ꠟꠣꠈꠣꠘ ꠝꠞꠤꠎꠤꠛ। ꠀꠞ ꠔꠣꠝꠣꠞ ꠛꠣꠚꠞ ꠛꠣꠠꠤꠔ ꠉꠦꠟꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","ꠛꠣꠇ꠆ꠇꠣ ꠇꠄꠖꠤꠘ ꠛꠣꠖꠦ ꠄꠢꠥꠖꠣꠞ ꠛꠃ, ꠡꠥꠀꠞ ꠙꠥꠠꠤ ꠝꠞꠤꠉꠦꠟ, ꠔꠦꠃ ꠇꠣꠘ꠆ꠖꠣ-ꠇꠣꠐꠤ ꠇꠞꠣꠞ ꠛꠣꠖꠦ ꠄꠢꠥꠖꠣꠄ ꠡꠣꠘ꠆ꠔꠤ ꠅꠁꠀ ꠅꠖꠥꠟ꠆ꠟꠝ ꠉꠣꠃꠞ ꠔꠣꠞ ꠖꠥꠡ꠆ꠔ ꠢꠤꠞꠣꠞ ꠟꠉꠦ ꠔꠤꠝꠘꠣ ꠉꠣꠃꠔ, ꠔꠣꠞ ꠝꠦꠠꠣꠞ ꠙꠣꠟꠞ ꠞꠥꠝꠣ ꠇꠣꠐꠞꠣ ꠝꠣꠘꠡꠞ ꠉꠦꠍꠦ ꠞꠅꠀꠘꠣ ꠖꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","ꠀꠞ ꠔꠣꠝꠣꠞꠞꠦ ꠉꠤꠀ ꠇꠦꠃ ꠈꠛꠞ ꠖꠤꠟ “ꠔꠥꠝꠣꠞ ꠢꠃꠞꠦ ꠔꠣꠘ ꠝꠦꠠꠣꠞ ꠞꠥꠝꠣ ꠇꠣꠐꠣꠞ ꠟꠣꠉꠤ ꠔꠤꠝꠘꠣꠔ ꠎꠣꠁꠞꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","ꠔꠣꠝꠣꠞꠦ ꠖꠦꠈꠟ, ꠡꠦꠟꠣ ꠛꠠ ꠅꠁꠟꠦꠅ ꠢꠃꠞꠦ ꠡꠦꠟꠣꠞ ꠟꠉꠦ ꠔꠣꠁꠞ ꠛꠤꠀ ꠖꠤꠞꠣ ꠘꠣ, ꠅꠃ ꠔꠣꠁ ꠠꠣꠠꠤꠞ ꠇꠣꠙꠠ ꠛꠖꠟꠣꠁꠀ ꠢꠣꠎꠤ-ꠙꠣꠠꠤ ꠝꠥꠈꠅ ꠊꠥꠝꠐꠣ ꠖꠤꠀ, ꠀꠄꠘꠣꠁꠝꠞ ꠙꠕꠞ ꠝꠥꠈꠅ ꠉꠤꠀ ꠛꠁꠟ। ꠀꠄꠘꠣꠁꠝ ꠀꠍꠤꠟ ꠔꠤꠝꠘꠣꠔ ꠎꠣꠅꠀꠞ ꠙꠕꠅ। ");
INSERT INTO syls_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","ꠀꠞ ꠔꠣꠁ ꠝꠥꠈ ꠟꠥꠇꠣꠁꠀ ꠞꠣꠈꠣꠄ, ꠄꠢꠥꠖꠣꠄ ꠝꠘꠅ ꠇꠞꠟ ꠁꠉꠥ ꠍꠤꠟꠣꠘ ꠛꠦꠐꠤ। ");
INSERT INTO syls_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ꠔꠦꠃ ꠄꠢꠥꠖꠣꠄ ꠙꠥꠀꠞ ꠛꠃꠞꠦ ꠘꠣ ꠌꠤꠘꠣꠄ, ꠙꠕꠞ ꠗꠣꠞꠅ ꠔꠣꠝꠣꠞꠞ ꠉꠦꠍꠦ ꠉꠤꠀ ꠇꠁꠟ, “ꠀꠅ, ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠤ।” ꠔꠣꠝꠣꠞꠦ ꠇꠁꠟ, “ꠔꠦ ꠀꠝꠣꠞꠦ ꠇꠤꠔꠣ ꠖꠤꠛꠣꠄ?” ");
INSERT INTO syls_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","ꠢꠦ ꠇꠁꠟ, “ꠀꠝꠣꠞ ꠙꠣꠟ ꠕꠘꠦ ꠛꠇꠞꠤ ꠛꠣꠁꠌ꠆ꠌꠣ ꠄꠉꠥ ꠙꠣꠑꠣꠁ ꠖꠤꠝꠥ।” ꠔꠣꠝꠣꠞꠦ ꠇꠁꠟ, “ꠁꠐꠣ ꠙꠣꠑꠣꠘꠤꠞ ꠀꠉꠦ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠇꠥꠘ꠆ꠔꠣ ꠎꠤꠝ꠆ꠝꠣ ꠕꠁꠀ ꠎꠣꠃꠇ꠆ꠇꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","ꠄꠢꠥꠖꠣꠄ ꠇꠁꠟ, “ꠇꠤꠔꠣ ꠕꠁꠔꠣꠝ?” ꠔꠣꠁ ꠇꠁꠟ, “ꠀꠙꠘꠣꠞ ꠅꠃ ꠚꠤꠔꠣꠀꠟꠣ ꠡꠤꠟ ꠀꠞ ꠀꠙꠘꠣꠞ ꠀꠔꠞ ꠟꠣꠑꠤ ꠕꠁꠀ ꠎꠣꠃꠇ꠆ꠇꠣ।” ꠔꠦꠃ ꠄꠢꠥꠖꠣꠄ ꠅꠉꠥꠁꠘ ꠎꠤꠝ꠆ꠝꠣ ꠕꠁꠀ ꠔꠣꠁꠞ ꠟꠉꠦ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠟ ꠀꠞ ꠔꠣꠝꠣꠞꠞ ꠙꠦꠐꠅ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠀꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ꠛꠣꠖꠦ ꠔꠣꠝꠣꠞ ꠃꠑꠤꠀ ꠉꠦꠟꠉꠤ ꠀꠞ ꠢꠤ ꠇꠣꠙꠠ ꠛꠖꠟꠣꠁꠀ ꠢꠤꠞꠛꠣꠞ ꠠꠣꠠꠤꠞ ꠇꠣꠙꠠ ꠚꠤꠘ꠆ꠖꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","ꠢꠦꠡꠦ ꠅꠃ ꠛꠦꠐꠤꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠎꠤꠝ꠆ꠝꠣꠞ ꠝꠣꠟ ꠚꠤꠞꠔ ꠘꠤꠛꠣꠞ ꠟꠣꠉꠤ, ꠔꠣꠞ ꠅꠖꠥꠟ꠆ꠟꠝꠞ ꠖꠥꠡ꠆ꠔꠞꠦ ꠖꠤꠀ ꠍꠣꠉꠟꠞ ꠛꠣꠁꠌ꠆ꠌꠣ ꠄꠉꠥ ꠙꠣꠑꠣꠁꠟ। ꠢꠦ ꠀꠁꠀ ꠔꠣꠁꠞꠦ ꠔꠥꠇꠣꠁꠀ ꠙꠣꠁꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","ꠅꠃ ꠢꠦ ꠢꠘꠞ ꠝꠣꠘꠡꠞꠦ ꠎꠤꠇꠣꠁꠟ, “ꠀꠄꠘꠣꠁꠝꠞ ꠙꠕꠞ ꠗꠣꠞꠅ ꠄꠇ ꠡꠦꠛꠇ ꠛꠦꠐꠤ ꠀꠍꠤꠟ, ꠅꠉꠥ ꠇꠁ?” ꠔꠣꠞꠣ ꠇꠁꠟꠣ, “ꠁꠘꠅ ꠔ ꠁꠟꠣ ꠇꠥꠘꠥ ꠛꠦꠐꠤ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","ꠔꠦꠃ ꠢꠦ ꠄꠢꠥꠖꠣꠞ ꠉꠦꠍꠦ ꠉꠤꠀ ꠇꠁꠟ, “ꠀꠝꠤ ꠉꠤꠀ ꠔꠣꠁꠞꠦ ꠔꠥꠇꠣꠁꠀ ꠙꠣꠁꠟꠣꠝ ꠘꠣ। ꠢꠘꠞ ꠝꠣꠘꠡꠦꠅ ꠇꠁꠟꠣ, ꠁꠘꠅ ꠔ ꠁꠟꠣ ꠇꠥꠘꠥ ꠛꠦꠐꠤ ꠀꠁꠍꠦ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","ꠄꠢꠥꠖꠣꠄ ꠇꠁꠟ, “ꠔꠦ ꠁꠔꠣ ꠀꠞ ꠔꠣꠁꠞ ꠉꠦꠍꠦꠃ ꠕꠣꠇꠃꠇ। ꠘꠣꠁꠟꠦ ꠀꠝꠞꠣ ꠡꠞꠝꠤꠘ꠆ꠖꠣ ꠅꠁꠝꠥ। ꠍꠣꠉꠟꠞ ꠛꠣꠁꠌ꠆ꠌꠣ ꠔ ꠙꠣꠑꠣꠁꠟꠣꠝ, ꠔꠣ-ꠅ ꠔꠥꠝꠤ ꠄꠞꠦ ꠔꠥꠇꠣꠁꠀ ꠙꠣꠁꠟꠣꠄ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ꠅꠘꠥꠝꠣꠘ ꠔꠤꠘ ꠝꠣꠡ ꠛꠣꠖꠦ ꠄꠢꠥꠖꠣꠄ ꠢꠥꠘꠟ, ꠔꠣꠞ ꠙꠥꠀꠞ ꠛꠃ ꠔꠣꠝꠣꠞꠦ ꠎꠤꠘꠣ ꠇꠞꠍꠦ, ꠄꠞꠟꠣꠉꠤ ꠔꠣꠁꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠅꠁꠔꠣ। ꠅꠃ ꠄꠢꠥꠖꠣꠄ ꠇꠁꠟ, “ꠅꠉꠥꠞꠦ ꠛꠣꠞꠦ ꠘꠤꠀ ꠀꠉꠥꠁꠘꠖꠤ ꠎꠣꠟꠣꠁꠟꠣꠅ।” ");
INSERT INTO syls_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","ꠔꠣꠝꠣꠞꠞꠦ ꠎꠦꠛꠟꠣ ꠛꠣꠞꠦ ꠘꠤꠞꠣ, ꠅꠃ ꠡꠝꠄ ꠔꠣꠁꠞ ꠢꠃꠞꠞꠦ ꠈꠛꠞ ꠖꠤꠟ ꠎꠦꠘ, “ꠎꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠀꠝꠣꠞ ꠙꠦꠐꠅ ꠀꠍꠦ, ꠅꠃ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠅꠇꠟ ꠔꠣꠞ। ꠔꠦ ꠖꠦꠈꠃꠇ꠆ꠇꠣ, ꠅꠃ ꠚꠤꠔꠣꠀꠟꠣ ꠡꠤꠟ ꠀꠞ ꠟꠣꠑꠤꠉꠥ ꠇꠣꠞ ꠌꠤꠘꠂꠘ ꠘꠤ?” ");
INSERT INTO syls_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","ꠄꠢꠥꠖꠣꠄ ꠁꠔꠣ ꠖꠦꠈꠤꠀ ꠇꠁꠟ, “ꠔꠣꠁ ꠔ ꠀꠝꠣ ꠕꠣꠇꠤ ꠛꠃꠔ ꠛꠠ ꠙꠞꠦꠎꠉꠣꠞ। ꠀꠝꠣꠞ ꠙꠥꠀ ꠡꠦꠟꠣꠞ ꠟꠉꠦ ꠔꠣꠁꠞꠦ ꠛꠤꠀ ꠇꠞꠣꠁꠍꠤ ꠘꠣ।” ꠄꠞꠛꠣꠖꠦ ꠄꠢꠥꠖꠣꠄ ꠀꠞ ꠇꠥꠘꠥꠖꠤꠘꠅ ꠔꠣꠝꠣꠞꠞ ꠉꠦꠍꠦ ꠢꠥꠔꠤꠍꠦ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠅꠁꠛꠣꠞ ꠛꠣꠟꠣ ꠖꠦꠈꠂꠘ, ꠔꠣꠝꠣꠞꠞ ꠙꠦꠐꠅ ꠎꠥꠠꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","ꠙꠄꠟꠣ ꠄꠉꠥꠄ ꠔꠣꠞ ꠀꠔ ꠛꠣꠞ ꠇꠞꠟ ꠀꠞ ꠖꠣꠁ ꠛꠦꠐꠤꠄ ꠟꠣꠟ ꠡꠥꠔꠣ ꠄꠇꠍꠣ ꠔꠣꠞ ꠀꠔꠅ ꠛꠣꠘ꠆ꠖꠤꠀ ꠇꠁꠟ, “ꠁꠉꠥ ꠙꠄꠟꠣ ꠙꠄꠖꠣ ꠅꠁꠟ।” ");
INSERT INTO syls_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","ꠅꠁꠟꠦ ꠢꠦ ꠀꠔ ꠐꠣꠘ ꠖꠤꠀ ꠜꠤꠔꠞꠦ ꠘꠤꠟꠉꠤ, ꠔꠦꠃ ꠔꠣꠞ ꠜꠣꠁ ꠙꠄꠟꠣ ꠛꠣꠞ ꠅꠁꠟ ꠀꠞ ꠖꠣꠁ ꠛꠦꠐꠤꠄ ꠇꠁꠟ, “ꠔꠥꠝꠤ ꠇꠤꠟꠣ ꠚꠣꠇ ꠇꠞꠤꠀ ꠛꠣꠞ ꠅꠁꠟꠣꠄ?” ꠄꠞꠟꠣꠉꠤ ꠄꠞ ꠘꠣꠝ ꠅꠁꠟ ꠚꠤꠞꠥꠎ ꠝꠣꠘꠤ, ꠚꠣꠇ ꠇꠞꠣ। ");
INSERT INTO syls_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ꠛꠣꠖꠦ ꠔꠣꠞ ꠜꠣꠁ ꠟꠣꠟ ꠡꠥꠔꠣ ꠀꠔꠅ ꠛꠣꠘ꠆ꠖꠣ ꠟꠁꠀ ꠛꠣꠞ ꠅꠁꠟ, ꠔꠣꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠎꠣꠞꠣꠢ। ");
INSERT INTO syls_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","ꠁꠃꠍꠥꠚꠞꠦ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠟꠁꠀ ꠎꠣꠅꠀꠞ ꠛꠣꠖꠦ, ꠁꠍꠝꠣꠁꠟꠤ ꠅꠇꠟꠞ ꠉꠦꠍ ꠕꠘꠦ, ꠀꠎꠤꠎ ꠘꠣꠝꠞ ꠚꠦꠞꠣꠃꠘꠞ ꠄꠇꠎꠘ ꠝꠤꠡꠞꠤ ꠇꠞ꠆ꠝꠌꠣꠞꠤꠄ, ꠁꠃꠍꠥꠚꠞꠦ ꠈꠞꠤꠖ ꠇꠞꠟꠣ। ꠀꠎꠤꠎ ꠅꠁꠟꠣ ꠚꠦꠞꠣꠃꠘꠞ ꠙꠞꠗꠣꠘ ꠉꠣꠒ। ");
INSERT INTO syls_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","ꠝꠣꠛꠥꠖꠦ ꠁꠃꠍꠥꠚꠞ ꠟꠉꠤ ꠅꠁꠟꠣ, ꠄꠞꠟꠣꠉꠤ ꠁꠃꠍꠥꠚ ꠢꠇꠟ ꠇꠣꠝꠅ ꠇꠣꠝꠤꠀꠛ ꠅꠁꠟꠣ। ꠔꠣꠁꠘ ꠢꠃ ꠝꠤꠡꠞꠤ ꠝꠥꠘꠤꠛꠞ ꠛꠣꠠꠤꠔ ꠇꠣꠝ ꠇꠞꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","ꠝꠣꠛꠥꠖ ꠔꠣꠘ ꠟꠉꠦ ꠟꠉꠦ ꠀꠍꠂꠘ ꠀꠞ ꠢꠇꠟ ꠇꠣꠝꠅ ꠔꠣꠘꠦ ꠇꠣꠝꠤꠀꠛ ꠇꠞꠞꠣ, ꠔꠣꠘ ꠝꠥꠘꠤꠛꠦꠅ ꠁꠔꠣ ꠛꠥꠎꠤꠟꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ꠔꠦꠃ ꠝꠥꠘꠤꠛꠦ ꠁꠃꠍꠥꠚꠞꠦ ꠝꠣꠄꠀ ꠇꠞꠔꠣ ꠟꠣꠉꠟꠣ, ꠔꠣꠘꠦ ꠝꠥꠘꠤꠛꠞ ꠈꠣꠍ ꠈꠦꠎꠝꠔꠉꠣꠞ ꠛꠣꠘꠣꠁꠟꠣ ꠀꠞ ꠔꠣꠘ ꠛꠣꠠꠤꠞ ꠢꠇꠟꠔꠣ ꠖꠦꠈꠣ-ꠢꠥꠘꠣꠞ ꠜꠣꠞꠅ ꠁꠃꠍꠥꠚꠞ ꠉꠦꠍꠦ ꠡꠝꠎꠣꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","ꠁꠃꠍꠥꠚꠞꠦ ꠔꠣꠘ ꠛꠣꠠꠤꠞ ꠀꠞ ꠢꠇꠟꠔꠣꠞ ꠜꠣꠞ ꠡꠙꠤ ꠖꠦꠅꠀꠞ ꠛꠣꠖꠦ ꠕꠘꠦ, ꠝꠣꠛꠥꠖꠦ ꠁꠃꠍꠥꠚꠞ ꠟꠣꠉꠤꠃ, ꠔꠣꠘ ꠝꠥꠘꠤꠛꠞ ꠢꠇꠟꠔꠣꠞ ꠝꠣꠎꠦ ꠛꠞꠇꠔ ꠘꠣꠎꠤꠟ ꠇꠞꠟꠣ। ꠀꠎꠤꠎꠞ ꠛꠣꠠꠤꠔ ꠀꠞ ꠈꠦꠔ-ꠈꠣꠝꠣꠞ, ꠢꠇꠟ ꠎꠣꠉꠣꠔ ꠝꠣꠛꠥꠖꠦ ꠛꠞꠇꠔ ꠘꠣꠎꠤꠟ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","ꠁꠔꠣ ꠖꠦꠈꠤꠀ ꠀꠎꠤꠎꠦ ꠔꠣꠘ ꠢꠇꠟꠔꠣꠞ ꠜꠣꠞ ꠁꠃꠍꠥꠚꠞ ꠃꠙꠞꠦ ꠡꠙꠤ ꠖꠤꠟꠣ, ꠔꠣꠘ ꠘꠤꠎꠞ ꠈꠣꠘꠣ-ꠖꠣꠘꠣ ꠍꠣꠠꠣ ꠀꠞ ꠇꠥꠘ꠆ꠔꠣꠞꠃ ꠈꠛꠞ ꠟꠁꠔꠣ ꠘꠣ। ꠁꠃꠍꠥꠚꠞ ꠡꠞꠤꠟꠞ ꠉꠑꠘ ꠀꠞ ꠌꠦꠢꠣꠞꠣꠅ ꠡꠥꠘ꠆ꠖꠞ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ꠁꠔꠣ ꠖꠦꠈꠤꠀ ꠔꠣꠘ ꠝꠥꠘꠤꠛꠞ ꠛꠃꠄ ꠔꠣꠘ ꠛꠣꠄ ꠟꠣꠟꠌ ꠇꠞꠟ। ꠔꠣꠁ ꠁꠃꠍꠥꠚꠞꠦ ꠇꠁꠟ, “ꠀꠝꠣꠞ ꠛꠤꠍꠘꠣꠔ ꠀꠅ।” ");
INSERT INTO syls_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","ꠅꠁꠟꠦ ꠁꠃꠍꠥꠚ ꠞꠣꠎꠤ ꠘꠣ ꠅꠁꠀ ꠝꠥꠘꠤꠛꠞ ꠛꠃꠞꠦ ꠇꠁꠟꠣ, “ꠖꠦꠈꠃꠇ꠆ꠇꠣ, ꠁ ꠛꠣꠠꠤꠔ ꠇꠤꠔꠣ ꠇꠤꠔꠣ ꠀꠍꠦ, ꠀꠝꠣꠞ ꠝꠥꠘꠤꠛꠦ ꠇꠥꠘ꠆ꠔꠣꠃ ꠈꠛꠞ ꠟꠂꠘ ꠘꠣ, ꠢꠇꠟꠔꠣꠞ ꠜꠣꠞ ꠀꠝꠣꠞ ꠃꠙꠞꠦ ꠡꠝꠎꠣꠁ ꠖꠤꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ꠁ ꠛꠣꠠꠤꠔ ꠀꠝꠣ ꠕꠘꠦ ꠛꠠ ꠀꠞ ꠇꠦꠃ ꠘꠣꠄ। ꠀꠙꠘꠦ ꠔ ꠔꠣꠘ ꠛꠤꠛꠤ, ꠄꠞꠟꠣꠉꠤ ꠀꠙꠘꠣꠞꠦ ꠍꠣꠠꠣ ꠀꠞ ꠢꠇꠟꠞꠦ ꠔꠣꠁꠘ ꠀꠝꠣꠞ ꠎꠤꠝ꠆ꠝꠣꠄ ꠞꠣꠈꠍꠂꠘ, ꠔꠦ ꠀꠝꠤ ꠇꠤꠟꠣ ꠅꠔ ꠛꠠ ꠄꠇ ꠎꠊꠁꠘ꠆ꠘ ꠇꠣꠝ ꠇꠞꠤꠀ ꠀꠟ꠆ꠟꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠉꠥꠘꠣ ꠇꠞꠔꠣꠝ?” ");
INSERT INTO syls_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","ꠔꠣꠁ ꠢꠣꠝꠦꠡꠣ ꠁꠃꠍꠥꠚꠞꠦ ꠅꠃꠟꠣ ꠝꠤꠘꠔ ꠇꠞꠟꠦꠅ ꠁꠃꠍꠥꠚꠦ ꠔꠣꠁꠞ ꠉꠦꠍꠦ ꠢꠥꠔꠔꠦ ꠛꠣ ꠇꠣꠍꠣꠔ ꠞꠁꠔꠦꠅ ꠞꠣꠎꠤ ꠅꠁꠟꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ꠢꠦꠡꠦ ꠄꠇꠖꠤꠘ ꠇꠥꠘꠥ ꠄꠇ ꠇꠣꠝꠞ ꠟꠣꠉꠤ ꠁꠃꠍꠥꠚ ꠊꠞꠞ ꠜꠤꠔꠞꠦ ꠢꠣꠝꠣꠁꠟꠣ, ꠅꠃ ꠡꠝꠄ ꠀꠞ ꠇꠦꠃ ꠢꠤꠘꠅ ꠀꠍꠤꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ꠔꠦꠃ ꠀꠎꠤꠎꠞ ꠛꠃꠄ ꠁꠃꠍꠥꠚꠞ ꠇꠣꠙꠠꠅ ꠗꠞꠤ ꠇꠁꠟ, “ꠀꠝꠣꠞ ꠛꠤꠍꠘꠣꠔ ꠀꠄ।” ꠅꠁꠟꠦ ꠁꠃꠍꠥꠚꠦ ꠔꠣꠘ ꠇꠣꠙꠠ ꠚꠣꠟꠣꠁꠀ ꠖꠃꠠꠤꠀ ꠉꠦꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","ꠁꠃꠍꠥꠚꠦ ꠔꠣꠁꠞ ꠀꠔꠅ ꠇꠣꠙꠠ ꠕꠁꠀ ꠖꠃꠠꠣꠁꠀ ꠉꠦꠟꠣꠉꠤ ꠇꠞꠤ, ");
INSERT INTO syls_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ꠀꠎꠤꠎꠞ ꠛꠃꠄ ꠊꠞꠞ ꠝꠣꠘꠡꠞꠦ ꠒꠣꠇꠤꠀ ꠇꠁꠟ, “ꠢꠥꠘꠅ, ꠔꠣꠁꠘ ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠔꠣꠝꠡꠣ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠁ ꠁꠛꠞꠣꠘꠤ ꠛꠦꠐꠣꠞꠦ ꠀꠘꠍꠂꠘ। ꠢꠦ ꠀꠝꠣꠞꠦ ꠛꠦꠁꠎ꠆ꠎꠔꠤ ꠇꠞꠣꠞ ꠝꠔꠟꠛꠦ ꠀꠝꠣꠞ ꠛꠤꠍꠘꠣꠔ ꠀꠁꠍꠤꠟ, ꠅꠃ ꠀꠝꠤ ꠌꠤꠟ꠆ꠟꠣꠁꠀ ꠃꠑꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ꠀꠝꠣꠞ ꠌꠤꠟ꠆ꠟꠣꠘꠤ ꠢꠥꠘꠤꠀ ꠢꠦ ꠔꠣꠞ ꠚꠤꠘ꠆ꠘꠞ ꠇꠣꠙꠠ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠕꠁꠀ ꠜꠣꠉꠤꠍꠦ।” ");
INSERT INTO syls_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","ꠁꠃꠍꠥꠚꠞ ꠝꠥꠘꠤꠛ ꠛꠣꠠꠤꠔ ꠘꠣ ꠀꠅꠀ ꠙꠞ꠆ꠎꠘ꠆ꠔ, ꠁ ꠇꠣꠙꠠ ꠔꠣꠁ ꠘꠤꠎꠞ ꠉꠦꠍꠦ ꠞꠣꠈꠟ। ");
INSERT INTO syls_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","ꠔꠣꠁꠘ ꠀꠁꠀ ꠢꠣꠞꠟꠦ ꠔꠣꠁ ꠘꠣꠟꠤꠡ ꠖꠤꠟ, “ꠔꠥꠝꠤ ꠎꠦ ꠁꠛꠞꠣꠘꠤ ꠉꠥꠟꠣꠝꠞꠦ ꠀꠝꠞꠣꠞ ꠉꠦꠍꠦ ꠀꠘꠍ, ꠢꠦ ꠀꠝꠣꠞꠦ ꠛꠦꠁꠎ꠆ꠎꠔꠤ ꠇꠞꠣꠞ ꠝꠔꠟꠛꠦ ꠀꠝꠣꠞ ꠊꠞꠅ ꠢꠣꠝꠣꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ꠅꠁꠟꠦ ꠀꠝꠣꠞ ꠢꠣꠃꠇꠣ-ꠢꠣꠃꠇꠤ ꠀꠞ ꠌꠤꠟ꠆ꠟꠣꠘꠤꠄ ꠢꠦ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠔꠣꠞ ꠇꠣꠙꠠ ꠚꠣꠟꠣꠁ ꠕꠁꠀ ꠜꠣꠉꠤꠍꠦ।” ");
INSERT INTO syls_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","ꠛꠃꠞ ꠝꠣꠔ ꠢꠥꠘꠤꠀ ꠁꠃꠍꠥꠚꠞ ꠝꠥꠘꠤꠛꠦ ꠉꠥꠍꠣꠄ ꠀꠉꠥꠁꠘ ꠅꠁꠉꠦꠟꠣ। ꠔꠣꠘ ꠛꠃꠄ ꠇꠁꠟ, “ꠔꠥꠝꠣꠞ ꠉꠥꠟꠣꠝꠦ ꠀꠝꠣꠞ ꠟꠉꠦ ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠣꠝ ꠇꠞꠍꠦ।” ");
INSERT INTO syls_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ꠔꠦꠃ ꠀꠎꠤꠎꠦ ꠁꠃꠍꠥꠚꠞꠦ ꠘꠤꠀ ꠎꠦꠟ ꠈꠣꠘꠣꠔ ꠢꠣꠞꠣꠁꠟꠣ। ꠝꠤꠡꠞꠞ ꠛꠣꠖꠡꠣꠞ ꠛꠘ꠆ꠖꠤ ꠅꠇꠟꠞꠦ ꠎꠦꠘꠅ ꠞꠣꠈꠂꠘ, ꠔꠣꠘꠦꠅ ꠢꠃ ꠎꠦꠟ ꠈꠣꠘꠣꠔ ꠕꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","ꠅꠁꠟꠦ ꠁꠃꠍꠥꠚꠞ ꠃꠙꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠄꠀ ꠀꠍꠤꠟ, ꠔꠣꠁꠘ ꠁꠃꠍꠥꠚꠞꠦ ꠛꠠ ꠎꠦꠟꠣꠞ ꠍꠣꠛꠞ ꠉꠦꠍꠦ ꠝꠣꠄꠀꠞ ꠝꠣꠘꠥꠡ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ꠛꠠ ꠎꠦꠟꠣꠞ ꠍꠣꠛꠦ ꠎꠦꠟ ꠈꠣꠘꠣꠞ ꠢꠇꠟ ꠛꠘ꠆ꠖꠤ ꠅꠇꠟꠞ ꠡꠞ꠆ꠖꠣꠞꠤ ꠁꠃꠍꠥꠚꠞ ꠃꠙꠞꠦ ꠍꠣꠠꠤ ꠖꠤꠟꠣ, ꠔꠦꠃ ꠢꠘꠞ ꠢꠇꠟ ꠇꠣꠝ-ꠇꠣꠎ ꠁꠃꠍꠥꠚꠞ ꠢꠥꠇꠥꠝꠦ ꠌꠟꠔ। ");
INSERT INTO syls_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","ꠀꠞ ꠛꠠ ꠎꠦꠟꠣꠞ ꠍꠣꠛꠦ ꠇꠥꠘ꠆ꠔꠣꠃ ꠖꠦꠈꠣ-ꠢꠥꠘꠣ ꠇꠞꠣ ꠟꠣꠉꠔ ꠘꠣ, ꠇꠣꠞꠘ ꠝꠣꠛꠥꠖ ꠁꠃꠍꠥꠚꠞ ꠟꠉꠦ ꠀꠍꠟꠣ, ꠄꠞꠟꠣꠉꠤ ꠁꠃꠍꠥꠚꠦ ꠎꠦꠔꠣꠔ ꠀꠔ ꠖꠤꠔꠣ, ꠝꠣꠛꠥꠖꠦ ꠁꠔꠣ ꠇꠣꠝꠤꠀꠛ ꠇꠞꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ꠁꠔꠣꠞ ꠛꠣꠖꠦ ꠝꠤꠡꠞꠞ ꠛꠣꠖꠡꠣꠞ ꠖꠞꠛꠣꠞꠞ ꠡꠞꠣꠛ ꠛꠤꠟꠣꠁ ꠖꠦꠅꠞꠣ ꠀꠞ ꠞꠥꠐꠤ ꠛꠣꠘꠣꠅꠞꠣ ꠁ ꠖꠥꠁꠅꠎꠘꠦ ꠛꠣꠖꠡꠣꠞ ꠉꠦꠍꠦ ꠇꠍꠥꠞ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ꠔꠦꠃ ꠚꠦꠞꠣꠃꠘ ꠔꠣꠞꠣ ꠖꠥꠁꠅꠎꠘꠞ ꠃꠙꠞꠦ ꠉꠥꠍꠣ ꠅꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ꠔꠣꠁꠘ ꠄꠞꠣꠞꠦ ꠛꠘ꠆ꠖꠤ ꠇꠞꠤꠀ ꠔꠣꠘ ꠛꠠ ꠎꠟ꠆ꠟꠣꠖꠞ ꠛꠣꠠꠤꠞ ꠎꠦꠟꠅ ꠢꠣꠞꠣꠁꠟꠣ। ꠅꠃ ꠎꠦꠟꠅ ꠁꠃꠍꠥꠚꠅ ꠀꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","ꠛꠠ ꠎꠟ꠆ꠟꠣꠖꠦ ꠁ ꠖꠥꠁꠅ ꠇꠄꠖꠤꠞ ꠜꠣꠞꠅ ꠁꠃꠍꠥꠚꠞ ꠀꠔꠅ ꠖꠤꠟꠣ, ꠀꠞ ꠁꠃꠍꠥꠚꠦ ꠔꠣꠞꠣꠞ ꠈꠦꠎꠝꠔ ꠇꠞꠔꠣ ꠟꠣꠉꠟꠣ। ꠅꠃꠟꠣ ꠄꠞꠣ ꠇꠤꠍꠥꠖꠤꠘ ꠎꠦꠟꠅ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ꠛꠣꠖꠦ ꠝꠤꠡꠞꠞ ꠛꠣꠖꠡꠣꠞ ꠢꠃ ꠞꠥꠐꠤ ꠛꠣꠘꠣꠅꠞꠣ ꠀꠞ ꠡꠞꠣꠛ ꠛꠤꠟꠣꠅꠞꠣ ꠖꠥꠁꠅꠎꠘꠦ ꠄꠇ ꠞꠣꠁꠔꠦ ꠖꠥꠈꠣꠘ ꠈꠥꠀꠛ ꠖꠦꠈꠟꠣ, ꠔꠣꠞꠣꠞ ꠈꠥꠀꠛꠞ ꠝꠣꠘꠤꠅ ꠀꠍꠤꠟ ꠖꠥꠁ ꠟꠣꠈꠣꠘ। ");
INSERT INTO syls_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","ꠛꠤꠀꠘꠦ ꠁꠃꠍꠥꠚꠦ ꠔꠣꠞꠣꠞ ꠉꠦꠍꠦ ꠉꠤꠀ ꠖꠦꠈꠟꠣ, ꠔꠣꠞꠣ ꠈꠥꠛ ꠝꠘ-ꠝꠞꠣ ꠅꠁꠞꠁꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","ꠁꠃꠍꠥꠚꠦ ꠔꠣꠞꠣꠞꠦ ꠎꠤꠇꠣꠁꠟꠣ, “ꠇꠤꠔꠣ ꠅꠁꠍꠦ, ꠀꠁꠎ ꠅꠔ ꠛꠦꠎꠣꠞ ꠇꠦꠘꠦ?” ");
INSERT INTO syls_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","ꠔꠣꠞꠣ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠀꠝꠞꠣ ꠔ ꠈꠥꠀꠛ ꠖꠦꠈꠍꠤ, ꠅꠁꠟꠦ ꠄꠞ ꠔꠣꠛꠤꠞ ꠛꠥꠎꠣꠁ ꠖꠦꠅꠞꠣ ꠇꠦꠃ ꠘꠣꠄ।” ꠁꠃꠍꠥꠚꠦ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠝꠣꠘꠤ ꠛꠥꠎꠣꠘꠤꠞ ꠈꠦꠝꠔꠣ ꠇꠤꠔꠣ ꠀꠟ꠆ꠟꠣꠄ ꠖꠦꠁꠘ ꠘꠣ ꠘꠤ? ꠖꠦꠈꠤ ꠌꠣꠁꠘ, ꠀꠝꠣꠞꠦ ꠢꠥꠘꠣꠃꠇ꠆ꠇꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","ꠅꠃ ꠢꠤ ꠡꠞꠣꠛ ꠛꠤꠟꠣꠅꠞꠣꠄ, ꠔꠣꠘ ꠡ꠆ꠛꠙꠘ ꠁꠃꠍꠥꠚꠞꠦ ꠢꠥꠘꠣꠁꠟꠣ। ꠢꠦ ꠇꠁꠟ, “ꠀꠝꠤ ꠖꠦꠈꠟꠣꠝ, ꠀꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠄꠇ ꠀꠋꠉꠥꠞꠞ ꠉꠣꠍ। ");
INSERT INTO syls_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ꠉꠣꠍꠞ ꠔꠤꠘꠉꠥ ꠒꠣꠟ ꠀꠍꠦ; ꠢꠃ ꠒꠣꠟꠅ ꠇꠥꠠꠤ ꠛꠣꠞꠘꠤꠞ ꠟꠉꠦ ꠟꠉꠦ ꠚꠥꠟ ꠗꠞꠟ, ꠀꠞ ꠍꠠꠣ ꠍꠠꠣ ꠀꠋꠉꠥꠞ ꠗꠞꠤ ꠙꠣꠇꠤ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ꠅꠃ ꠡꠝꠄ ꠚꠦꠞꠣꠃꠘꠞ ꠡꠞꠛꠔꠞ ꠙꠤꠀꠟꠣ ꠀꠝꠣꠞ ꠀꠔꠅ ꠀꠍꠤꠟ। ꠀꠝꠤ ꠢꠃ ꠀꠋꠉꠥꠞ ꠅꠇꠟ ꠌꠤꠙꠤꠀ ꠞꠡ ꠛꠣꠞ ꠇꠞꠤ ꠚꠦꠞꠣꠃꠘꠞ ꠀꠔꠅ ꠖꠤꠟꠣꠝ।” ");
INSERT INTO syls_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","ꠁꠃꠍꠥꠚꠦ ꠔꠣꠞꠦ ꠇꠁꠟꠣ, “ꠀꠙꠘꠣꠞ ꠡ꠆ꠛꠙꠘꠞ ꠝꠣꠘꠤ ꠅꠁꠟ, ꠔꠤꠘ ꠒꠣꠟ ꠝꠣꠘꠤ ꠔꠤꠘ ꠖꠤꠘ। ");
INSERT INTO syls_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ꠅꠃ ꠔꠤꠘ ꠖꠤꠘꠞ ꠝꠣꠎꠦ ꠚꠦꠞꠣꠃꠘꠦ ꠀꠙꠘꠣꠞꠦ ꠛꠣꠞ ꠇꠞꠤꠀ ꠢꠤꠞꠛꠣꠞ ꠀꠉꠞ ꠇꠣꠝꠅ ꠟꠣꠉꠣꠁꠛꠣ। ꠀꠙꠘꠦ ꠢꠤꠞꠛꠣꠞ ꠀꠉꠞ ꠟꠣꠈꠣꠘ ꠚꠦꠞꠣꠃꠘꠞ ꠀꠔꠅ ꠙꠤꠀꠟꠣ ꠔꠥꠟꠤ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","ꠅꠁꠟꠦ ꠀꠙꠘꠣꠞꠦ ꠝꠤꠘꠔꠤ ꠇꠞꠤ ꠇꠁꠀꠞ, ꠀꠙꠘꠣꠞ ꠜꠣꠟꠣꠁ ꠅꠀꠞ ꠛꠣꠖꠦ ꠀꠝꠣꠞꠦ ꠝꠘꠅ ꠇꠞꠛꠣ ꠀꠞ ꠖꠄꠀ ꠇꠞꠤ ꠚꠦꠞꠣꠃꠘꠞ ꠉꠦꠍꠦ ꠀꠝꠣꠞ ꠇꠕꠣ ꠇꠁꠀ, ꠁ ꠎꠦꠟꠈꠣꠘꠣ ꠕꠘꠦ ꠀꠝꠣꠞꠦ ꠈꠣꠟꠣꠍ ꠇꠞꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ꠁꠛꠞꠣꠘꠤ ꠅꠇꠟꠞ ꠖꠦꠡ ꠕꠘꠦ ꠀꠝꠣꠞꠦ ꠎꠥꠞ ꠇꠞꠤ ꠗꠞꠤꠀ ꠀꠘꠣ ꠅꠁꠍꠦ। ꠀꠞ ꠅꠘꠅ ꠀꠁꠀꠅ ꠀꠝꠤ ꠎꠦꠟ ꠈꠣꠐꠣꠞ ꠝꠔ ꠄꠝꠘ ꠇꠥꠘ꠆ꠔꠣ ꠇꠞꠍꠤ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","ꠛꠣꠖꠦ ꠢꠤ ꠞꠥꠐꠤ ꠛꠣꠘꠣꠅꠞꠣꠄ ꠎꠦꠛꠟꠣ ꠖꠦꠈꠟ ꠎꠦꠘ, ꠡꠞꠣꠛ ꠛꠤꠟꠣꠅꠞꠣꠞ ꠈꠥꠀꠛꠞ ꠝꠣꠘꠤ ꠜꠣꠟꠣ ꠀꠍꠦ, ꠔꠦꠃ ꠢꠦ ꠁꠃꠍꠥꠚꠞꠦ ꠇꠁꠟ, “ꠀꠝꠤꠅ ꠈꠥꠀꠛꠦ ꠖꠦꠈꠍꠤ, ꠖꠦꠈꠟꠣꠝ ꠎꠦꠘ ꠀꠝꠣꠞ ꠝꠣꠕꠣꠔ ꠔꠤꠘ ꠐꠥꠇꠞꠤ ꠝꠄꠖꠣꠞ ꠞꠥꠐꠤ ꠟꠁꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ꠀꠞ ꠃꠙꠞꠞ ꠐꠥꠇꠞꠤꠔ ꠀꠍꠤꠟ, ꠚꠦꠞꠣꠃꠘꠞ ꠟꠣꠉꠤ ꠛꠃꠔ ꠎꠣꠔꠞ ꠙꠤꠑꠣ; ꠔꠦꠃ ꠙꠣꠈꠤ ꠅꠇꠟꠦ ꠀꠁꠀ, ꠀꠝꠣꠞ ꠝꠣꠕꠣꠞ ꠃꠙꠞꠞ ꠐꠥꠇꠞꠤ ꠕꠣꠇꠤ ꠁꠔꠣ ꠈꠣꠁꠟꠤꠞꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","ꠁꠃꠍꠥꠚꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠁ ꠡ꠆ꠛꠙꠘꠞ ꠔꠣꠛꠤꠞ ꠅꠁꠟ, ꠔꠤꠘ ꠐꠥꠇꠞꠤ ꠝꠣꠘꠤ ꠔꠤꠘ ꠖꠤꠘ। ");
INSERT INTO syls_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ꠅꠃ ꠔꠤꠘ ꠖꠤꠘꠞ ꠝꠣꠎꠦ, ꠚꠦꠞꠣꠃꠘꠦ ꠀꠙꠘꠣꠞ ꠗꠠ ꠕꠘꠦ ꠇꠟ꠆ꠟꠣ ꠀꠟꠉꠣꠁꠀ, ꠉꠣꠍꠞ ꠝꠣꠎꠦ ꠟꠐꠇꠣꠁꠛꠣ, ꠢꠦꠡꠦ ꠙꠣꠈꠤꠘ꠆ꠔꠦ ꠀꠁꠀ ꠀꠙꠘꠣꠞ ꠗꠠꠞ ꠉꠥꠡ꠆ꠔ ꠈꠣꠁꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","ꠄꠞ ꠔꠤꠘ ꠖꠤꠘꠞ ꠖꠤꠘ ꠚꠦꠞꠣꠃꠘꠞ ꠎꠘꠝ ꠖꠤꠘ ꠀꠍꠤꠟ। ꠚꠦꠞꠣꠃꠘꠦ ꠔꠣꠘ ꠖꠞꠛꠣꠞꠞ ꠢꠇꠟ ꠝꠣꠘꠡꠞ ꠟꠣꠉꠤ, ꠈꠣꠘꠤ ꠔꠤꠀꠞ ꠇꠞꠣꠁꠟꠣ। ꠀꠞ ꠢꠃ ꠞꠥꠐꠤ ꠛꠣꠘꠣꠅꠞꠣ ꠀꠞ ꠡꠞꠣꠛ ꠛꠤꠟꠣꠅꠞꠣ ꠖꠥꠁꠅꠎꠘꠞꠦ ꠀꠘꠣꠁꠀ ꠔꠣꠘ ꠖꠞꠛꠣꠞꠞ ꠍꠣꠝꠘꠦ ꠀꠎꠤꠞ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ꠔꠣꠁꠘ ꠡꠞꠣꠛ ꠛꠤꠟꠣꠅꠞꠣꠞꠦ ꠢꠤꠞꠛꠣꠞ ꠔꠣꠘ ꠇꠣꠝꠅ ꠟꠣꠉꠣꠁꠟꠣ, ꠢꠦ ꠚꠦꠞꠣꠃꠘꠞ ꠀꠔꠅ ꠢꠤꠞꠛꠣꠞ ꠙꠤꠀꠟꠣ ꠔꠥꠟꠤꠀ ꠖꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ꠅꠁꠟꠦ ꠞꠥꠐꠤ ꠛꠣꠘꠣꠅꠞꠣꠞꠦ ꠉꠣꠍꠅ ꠟꠐꠇꠣꠁꠟꠣ। ꠁꠃꠍꠥꠚꠦ ꠎꠦꠟꠣ ꠇꠁꠍꠟꠣ, ꠄꠇ꠆ꠇꠦꠞꠦ ꠅꠃꠟꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","ꠔꠣ-ꠅ ꠁꠃꠍꠥꠚꠞ ꠇꠕꠣ ꠢꠤ ꠡꠞꠣꠛ ꠛꠤꠟꠣꠅꠞꠣꠞ ꠁꠀꠖ ꠞꠁꠟ ꠘꠣ, ꠢꠦ ꠚꠣꠃꠞꠤꠟꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","ꠄꠞ ꠙꠥꠞꠣ ꠖꠥꠁ ꠛꠞꠍ ꠛꠣꠖꠦ ꠚꠦꠞꠣꠃꠘꠦ ꠈꠥꠀꠛꠦ ꠖꠦꠈꠟꠣ। ꠔꠣꠁꠘ ꠖꠦꠈꠟꠣ, ꠘꠤꠟ ꠘꠖꠞ ꠉꠦꠍꠦ ꠔꠣꠁꠘ ꠃꠛꠣꠁ ꠞꠁꠍꠂꠘ, ");
INSERT INTO syls_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ꠀꠞ ꠘꠤꠟ ꠘꠖ ꠕꠘꠦ ꠡꠣꠔꠉꠥ ꠡꠥꠘ꠆ꠖꠞ ꠔꠞꠔꠣꠎꠣ ꠉꠞꠥ ꠃꠑꠤꠀ ꠀꠁꠀ ꠘꠟ ꠛꠘꠞ ꠝꠣꠎꠦ ꠀꠐꠤꠀ ꠈꠣꠁꠞꠣ। ");
INSERT INTO syls_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","ꠄꠞꠛꠣꠖꠦ ꠖꠦꠈꠂꠘ, ꠀꠞꠅ ꠡꠣꠔꠉꠥ ꠢꠣꠟꠣꠇ ꠀꠞ ꠈꠛꠤꠍꠞ ꠟꠣꠈꠣꠘ ꠉꠞꠥ ꠃꠑꠤꠀ ꠀꠁꠀ, ꠘꠤꠟ ꠘꠖꠞ ꠙꠣꠞꠞ ꠢꠃ ꠉꠞꠥꠁꠘ꠆ꠔꠞ ꠇꠣꠍꠣꠔ ꠃꠛꠣꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ꠢꠦꠡꠦ ꠅꠃ ꠢꠣꠟꠣꠇ ꠀꠞ ꠈꠛꠤꠍꠞ ꠟꠣꠈꠣꠘ ꠉꠞꠥꠁꠘ꠆ꠔꠦ ꠢꠃ ꠡꠥꠘ꠆ꠖꠞ ꠀꠞ ꠔꠞꠔꠣꠎꠣ ꠡꠣꠔꠅ ꠉꠞꠥꠞꠦ ꠈꠣꠁꠟꠤꠟ, ꠔꠦꠃ ꠚꠦꠞꠣꠃꠘꠞ ꠊꠥꠝ ꠜꠣꠋꠉꠤ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠢꠤꠞꠛꠣꠞ ꠊꠥꠝꠣꠁꠟꠣ ꠀꠞ ꠖꠥꠀꠞꠣ ꠈꠥꠀꠛꠦ ꠖꠦꠈꠟꠣ, ꠄꠇ ꠉꠝꠞ ꠒꠦꠐꠣꠔ ꠡꠣꠔꠉꠥ ꠙꠥꠡ꠆ꠐ ꠀꠞ ꠔꠣꠎꠣ ꠍꠠꠣ ꠛꠣꠞ ꠅꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ꠢꠦꠡꠦ ꠛꠣꠞ ꠅꠁꠟ, ꠙꠥꠛꠣꠟꠤ ꠛꠣꠔꠣꠡꠞ ꠉꠞꠝꠦ ꠢꠥꠇꠘꠣ ꠡꠣꠔꠉꠥ ꠇꠝ ꠙꠥꠡ꠆ꠐ ꠍꠥꠍꠣꠀꠟꠣ ꠍꠠꠣ, ");
INSERT INTO syls_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","ꠀꠞ ꠅꠃ ꠇꠝ ꠙꠥꠡ꠆ꠐ ꠍꠠꠣꠄ ꠢꠃ ꠡꠣꠔꠅ ꠙꠥꠡ꠆ꠐ-ꠔꠣꠎꠣ ꠍꠠꠣꠞꠦ ꠉꠤꠟꠤꠟꠣꠁꠟ। ꠛꠣꠖꠦ ꠚꠦꠞꠣꠃꠘꠞ ꠊꠥꠝ ꠜꠣꠋꠉꠤ ꠉꠦꠟ, ꠔꠣꠁꠘ ꠛꠥꠎꠟꠣ ꠎꠦꠘ ꠁꠔꠣ ꠔ ꠈꠥꠀꠛ। ");
INSERT INTO syls_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","ꠛꠤꠀꠘꠦ ꠔꠣꠘ ꠝꠘ ꠅꠡ꠆ꠕꠤꠞ ꠅꠁꠉꠦꠟ, ꠔꠦꠃ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠢꠇꠟ ꠎꠣꠖꠥꠉꠤꠞ ꠀꠞ ꠙꠘ꠆ꠒꠤꠔꠞꠦ ꠈꠛꠞꠤꠀꠖꠤ ꠀꠘꠣꠁꠀ, ꠔꠣꠘ ꠈꠥꠀꠛ ꠔꠣꠞꠣꠞꠦ ꠢꠥꠘꠣꠁꠟꠣ, ꠅꠁꠟꠦ ꠄꠞꠣꠞ ꠇꠦꠃ ꠄꠞ ꠔꠣꠛꠤꠞ ꠇꠁꠔ ꠙꠣꠞꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ꠢꠦꠡꠦ ꠚꠦꠞꠣꠃꠘꠞ ꠢꠃ ꠡꠞꠣꠛ ꠛꠤꠟꠣꠅꠞꠣꠄ ꠇꠁꠟ, “ꠢꠥꠎꠥꠞ, ꠀꠁꠎ ꠀꠝꠣꠞ ꠄꠇ ꠖꠥꠡ ꠝꠘꠅ ꠅꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ꠛꠃꠔ ꠖꠤꠘ ꠀꠉꠦ ꠢꠥꠎꠥꠞꠦ ꠘꠤꠎꠞ ꠖꠥꠁ ꠉꠥꠟꠣꠝꠞ ꠃꠙꠞꠦ ꠉꠥꠍꠣ ꠇꠞꠍꠟꠣ, ꠔꠣꠁꠘ ꠀꠝꠣꠞꠦ ꠀꠞ ꠞꠥꠐꠤ ꠛꠣꠘꠣꠅꠞꠣꠞꠦ ꠛꠠ ꠎꠦꠟꠣꠞ ꠍꠣꠛꠞ ꠛꠣꠠꠤꠞ ꠎꠦꠟꠅ ꠕꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ꠀꠞ ꠄꠇ ꠞꠣꠁꠔꠦ ꠀꠝꠞꠣ ꠖꠥꠁꠅꠎꠘꠦ ꠀꠟꠉ ꠀꠟꠉ ꠈꠥꠀꠛ ꠖꠦꠈꠟꠣꠝ, ꠖꠥꠁꠅ ꠈꠥꠀꠛꠞ ꠖꠥꠁ ꠟꠣꠈꠣꠘ ꠔꠣꠛꠤꠞ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","ꠁ ꠡꠝꠄ ꠎꠦꠟꠣꠞ ꠍꠣꠛꠞ, ꠄꠇ ꠁꠛꠞꠣꠘꠤ ꠎꠥꠀꠘ ꠉꠥꠟꠣꠝꠅ ꠅꠘꠅ ꠀꠍꠤꠟ। ꠔꠣꠞꠦ ꠀꠝꠞꠣꠞ ꠈꠥꠀꠛꠞ ꠇꠕꠣ ꠢꠥꠘꠣꠁꠟꠣꠝ, ꠀꠞ ꠢꠦ ꠀꠝꠞꠣꠞ ꠈꠥꠀꠛꠞ ꠔꠣꠛꠤꠞ ꠇꠁꠀ ꠖꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","ꠢꠦ ꠀꠝꠞꠣꠞ ꠈꠥꠀꠛꠞ ꠔꠣꠛꠤꠞ ꠎꠦꠟꠣ ꠇꠁꠍꠤꠟ, ꠄꠇ꠆ꠇꠦꠞꠦ ꠅꠃ ꠟꠣꠈꠣꠘꠃ ꠚꠟꠤꠟ। ꠢꠥꠎꠥꠞꠦ ꠀꠝꠣꠞꠦ ꠢꠤꠞꠛꠣꠞ ꠔꠣꠘ ꠇꠣꠝꠅ ꠟꠣꠉꠣꠁꠟꠣ, ꠅꠁꠟꠦ ꠞꠥꠐꠤ ꠛꠣꠘꠣꠅꠞꠣꠞꠦ ꠉꠣꠍꠅ ꠟꠐꠇꠣꠁꠟꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","ꠅꠃ ꠚꠦꠞꠣꠃꠘꠦ ꠁꠃꠍꠥꠚꠞꠦ ꠀꠘꠣꠞ ꠟꠣꠉꠤ ꠝꠣꠘꠥꠡ ꠙꠣꠑꠣꠁꠟꠣ, ꠔꠣꠞꠣ ꠉꠤꠀ ꠎꠟꠖꠤ ꠇꠞꠤ ꠎꠦꠟꠈꠣꠘꠣ ꠕꠘꠦ ꠔꠣꠘꠞꠦ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠟꠣ। ꠁꠃꠍꠥꠚꠦ ꠖꠣꠠꠤ-ꠝꠥꠍ ꠇꠣꠝꠣꠁꠀ, ꠇꠣꠙꠠ ꠛꠖꠟꠣꠁꠀ ꠚꠦꠞꠣꠃꠘꠞ ꠖꠞꠛꠣꠞꠅ ꠀꠎꠤꠞ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ꠚꠦꠞꠣꠃꠘꠦ ꠔꠣꠘꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠄꠇꠈꠣꠘ ꠈꠥꠀꠛ ꠖꠦꠈꠍꠤ, ꠅꠁꠟꠦ ꠄꠞ ꠔꠣꠛꠤꠞ ꠇꠦꠃ ꠇꠁꠔ ꠙꠣꠞꠦꠞ ꠘꠣ। ꠔꠦ ꠀꠝꠤ ꠢꠥꠘꠟꠣꠝ ꠎꠦꠘ ꠔꠥꠝꠣꠞ ꠉꠦꠍꠦ ꠈꠥꠀꠛ ꠢꠥꠘꠣꠁꠟꠦ, ꠔꠥꠝꠤ ꠄꠞ ꠔꠣꠛꠤꠞ ꠇꠁꠔꠣꠄ ꠙꠣꠞ।” ");
INSERT INTO syls_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","ꠁꠃꠍꠥꠚꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠢꠤ ꠈꠦꠝꠔꠣ ꠔ ꠀꠝꠣꠞ ꠘꠣꠄ, ꠀꠟ꠆ꠟꠣ ꠙꠣꠇꠦ ꠝꠢꠣꠞꠣꠎꠞ ꠖꠤꠟꠞ ꠡꠣꠘ꠆ꠔꠤꠞ ꠎꠥꠀꠙ ꠛꠣꠔꠣꠁꠀ ꠖꠤꠛꠣ ꠘꠦ।” ");
INSERT INTO syls_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","ꠚꠦꠞꠣꠃꠘꠦ ꠁꠃꠍꠥꠚꠞꠦ ꠇꠁꠟꠣ, “ꠈꠥꠀꠛꠦ ꠖꠦꠈꠟꠣꠝ, ꠀꠝꠤ ꠘꠤꠟ ꠘꠖꠞ ꠙꠣꠞꠅ ꠃꠛꠣꠁ ꠞꠁꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ꠀꠞ ꠖꠦꠈꠤ, ꠉꠣꠋꠉꠅ ꠕꠘꠦ ꠡꠣꠔꠉꠥ ꠡꠥꠘ꠆ꠖꠞ, ꠔꠞꠔꠣꠎꠣ ꠉꠞꠥ ꠃꠑꠤꠀ ꠀꠁꠀ ꠘꠟ ꠛꠘꠞ ꠝꠣꠎꠦ ꠀꠐꠤꠀ ꠈꠣꠁꠞꠣ। ");
INSERT INTO syls_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ꠄꠞꠛꠣꠖꠦ ꠀꠞꠅ ꠡꠣꠔꠉꠥ ꠉꠞꠥ ꠃꠑꠤꠀ ꠀꠁꠟ। ꠁꠔꠣ ꠢꠣꠟꠣꠇ ꠀꠞ ꠈꠛꠤꠍꠞ ꠟꠣꠈꠣꠘ, ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠇꠥꠘꠥ ꠈꠣꠘꠅ ꠁꠟꠣꠈꠣꠘ ꠛꠦ-ꠍꠥꠞꠔ ꠉꠞꠥ ꠇꠥꠘꠥ ꠖꠤꠘꠅ ꠖꠦꠈꠍꠤ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","ꠛꠣꠖꠦ ꠅꠃ ꠢꠣꠟꠣꠇ ꠀꠞ ꠛꠦ-ꠍꠥꠞꠔ ꠉꠞꠥꠁꠘ꠆ꠔꠦ, ꠀꠉꠞ ꠢꠤ ꠡꠣꠔꠅ ꠔꠞꠔꠣꠎꠣ ꠉꠞꠥꠞꠦ ꠈꠣꠁꠟꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ꠅꠁꠟꠦ ꠔꠣꠞꠣ ꠁꠔꠣꠞꠦ ꠉꠤꠟꠣꠞ ꠛꠣꠖꠦ, ꠈꠣꠁꠍꠦ ꠇꠞꠤ ꠛꠥꠎꠣꠅ ꠉꠦꠟ ꠘꠣ, ꠇꠣꠞꠘ ꠔꠣꠞꠣ ꠀꠉꠞ ꠟꠣꠈꠣꠘꠃ ꠢꠣꠟꠣꠇ ꠀꠞ ꠛꠦ-ꠍꠥꠞꠔ ꠞꠁꠟ। ꠢꠦꠡꠦ ꠀꠝꠣꠞ ꠊꠥꠝ ꠜꠣꠋꠉꠤ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","ꠛꠣꠖꠦ ꠀꠝꠤ ꠢꠤꠞꠛꠣꠞ ꠖꠦꠈꠟꠣꠝ, ꠉꠝꠞ ꠄꠇ ꠒꠦꠐꠣꠞ ꠝꠣꠎꠦ ꠡꠣꠔꠉꠥ ꠛꠠ ꠀꠞ ꠙꠥꠡ꠆ꠐ ꠍꠠꠣ ꠛꠣꠞ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ꠙꠥꠛꠣꠟꠤ ꠢꠣꠅꠀꠞ ꠉꠞꠝꠦ ꠢꠥꠇꠘꠣ ꠡꠣꠔꠉꠥ ꠇꠝ ꠙꠥꠡ꠆ꠐ ꠍꠥꠍꠣꠀꠟꠣ ꠍꠠꠣꠅ ꠛꠣꠞ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ꠀꠞ ꠅꠃ ꠡꠣꠔꠅ ꠍꠠꠣꠄ, ꠢꠃ ꠔꠣꠎꠣ ꠡꠣꠔꠅ ꠍꠠꠣꠞꠦ ꠉꠤꠟꠤꠟꠤꠟ। ꠁ ꠈꠥꠀꠛ ꠀꠝꠤ ꠎꠣꠖꠥꠉꠤꠞ ꠅꠇꠟꠞꠦ ꠢꠥꠘꠣꠁꠍꠟꠣꠝ, ꠅꠁꠟꠦ ꠇꠦꠃ ꠄꠞ ꠝꠣꠘꠤ ꠇꠁꠔ ꠙꠣꠞꠍꠦ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","ꠁꠃꠍꠥꠚꠦ ꠚꠦꠞꠣꠃꠘꠞꠦ ꠇꠁꠟꠣ, “ꠢꠥꠎꠥꠞ, ꠁ ꠖꠥꠁꠅ ꠈꠥꠀꠛꠃ ꠀꠖꠔꠦ ꠄꠇ। ꠀꠟ꠆ꠟꠣꠄ ꠎꠦꠔꠣ ꠇꠞꠔꠣ ꠌꠣꠁꠞꠣ, ꠁꠔꠣ ꠀꠙꠘꠣꠞꠦ ꠖꠦꠈꠣꠁꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","ꠅꠃ ꠔꠞꠔꠣꠎꠣ ꠡꠣꠔꠅ ꠉꠞꠥꠞ ꠝꠣꠘꠤ ꠡꠣꠔ ꠛꠞꠍ, ꠀꠞ ꠙꠥꠡ꠆ꠐ ꠡꠣꠔꠅ ꠉꠝꠞ ꠍꠠꠣꠞ ꠝꠣꠘꠤꠅ ꠡꠣꠔ ꠛꠞꠍ। ꠖꠥꠁꠅ ꠈꠥꠀꠛꠃ ꠄꠇ। ");
INSERT INTO syls_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","ꠀꠞ ꠢꠦꠡꠦ ꠃꠑꠤꠀ ꠀꠅꠀ ꠡꠣꠔꠅ ꠢꠣꠟꠣꠇ ꠀꠞ ꠛꠦ-ꠍꠥꠞꠔ ꠉꠞꠥ, ꠀꠞ ꠙꠥꠛꠣꠟꠤ ꠢꠣꠅꠀꠞ ꠉꠞꠝꠦ ꠢꠥꠇꠘꠣ ꠡꠣꠔꠅ ꠉꠝꠞ ꠍꠠꠣ, ꠄꠞꠣꠞ ꠝꠣꠘꠤ ꠅꠁꠟ, ꠀꠇꠣꠟꠞ ꠡꠣꠔ ꠛꠞꠍ। ");
INSERT INTO syls_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","ꠔꠦ ꠀꠟ꠆ꠟꠣꠄ ꠎꠦꠔꠣ ꠇꠞꠔꠣ ꠌꠣꠁꠞꠣ, ꠁꠔꠣ ꠝꠢꠣꠞꠣꠎꠞꠦ ꠖꠦꠈꠣꠁꠍꠂꠘ। ꠅꠃ ꠇꠕꠣꠃ ꠀꠝꠤ ꠀꠙꠘꠣꠞꠦ ꠀꠉꠦ ꠇꠁꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","ꠢꠥꠘꠃꠇ꠆ꠇꠣ, ꠢꠣꠞꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠡꠣꠔ ꠛꠞꠍ ꠈꠥꠛ ꠛꠦꠡꠤ ꠚꠡꠟ ꠚꠟꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ꠄꠞꠛꠣꠖꠦꠃ ꠀꠁꠛ ꠀꠇꠣꠟꠞ ꠡꠣꠔ ꠛꠞꠍ। ꠔꠦꠃ ꠀꠉꠞ ꠢꠤ ꠛꠦꠡꠤ ꠚꠡꠟꠞ ꠇꠕꠣ ꠝꠣꠘꠡꠦ ꠚꠣꠃꠞꠤꠟꠤꠛꠣ, ꠀꠞ ꠀꠇꠣꠟꠦ ꠖꠦꠡꠞꠦ ꠡꠦꠡ ꠇꠞꠤ ꠖꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ꠅꠃ ꠀꠇꠣꠟꠞ ꠖꠞꠥꠘ, ꠀꠉꠞ ꠢꠤ ꠚꠡꠟꠞ ꠇꠕꠣ ꠝꠣꠘꠡꠞ ꠝꠘꠅ ꠞꠁꠔ ꠘꠣꠄ। ꠁ ꠀꠇꠣꠟ ꠅꠁꠛ ꠈꠥꠛ ꠛꠦꠎꠥꠁꠔꠣ ꠝꠍꠤꠛꠔꠞ। ");
INSERT INTO syls_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","ꠁ ꠈꠥꠀꠛ ꠀꠙꠘꠣꠞꠦ ꠖꠥꠁꠛꠣꠞ ꠖꠦꠈꠣꠘꠤꠞ ꠝꠣꠘꠤ ꠅꠁꠟ, ꠀꠟ꠆ꠟꠣꠄ ꠁ ꠖꠡꠣ ꠊꠐꠣꠁꠛꠣ, ꠄꠇ꠆ꠇꠦꠞꠦ ꠑꠤꠇ ꠇꠞꠤꠟꠣꠁꠍꠂꠘ, ꠁꠔꠣ ꠈꠥꠛ ꠎꠟꠖꠤ ꠇꠞꠤꠃ ꠊꠐꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","ꠅꠈꠘ ꠢꠥꠎꠥꠞꠦ ꠄꠇꠎꠘ ꠌꠔꠥꠞ-ꠛꠥꠎꠖꠣꠞ ꠙꠘ꠆ꠒꠤꠔ ꠝꠣꠘꠡꠞꠦ ꠔꠥꠇꠣꠁꠀ, ꠄꠘ ꠉꠦꠍꠦ ꠝꠤꠡꠞꠞꠦ ꠡꠙꠤ ꠖꠦꠃꠇ꠆ꠇꠣ। ");
INSERT INTO syls_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ꠀꠞ ꠀꠙꠘꠦ ꠅꠃꠟꠣ ꠇꠞꠃꠇ꠆ꠇꠣ, ꠖꠦꠡꠅ ꠀꠙꠘꠣꠞ ꠇꠞ꠆ꠝꠌꠣꠞꠤ ꠟꠣꠉꠣꠁꠘ, ꠅꠃ ꠡꠣꠔ ꠛꠍꠞꠦ ꠎꠦꠛꠟꠣ ꠈꠥꠛ ꠛꠦꠡꠤ ꠚꠡꠟ ꠚꠟꠛ, ꠁ ꠡꠝꠄ ꠔꠣꠞꠣ ꠄꠞ ꠙꠣꠌ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ ꠖꠟꠣ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","ꠔꠣꠞꠣ ꠅꠃ ꠡꠥꠖꠤꠘꠞ ꠛꠍꠞꠞ ꠗꠣꠘ ꠖꠟꠣ ꠇꠞꠤꠀ ꠢꠥꠎꠥꠞꠞ ꠖꠈꠟꠦ, ꠛꠣꠎꠣꠞꠦ ꠛꠣꠎꠣꠞꠦ ꠉꠥꠖꠣꠝꠅ ꠜꠞꠤꠀ ꠕꠃꠇ ꠀꠞ ꠢꠦꠚꠣꠎꠔ ꠇꠞꠃꠇ। ");
INSERT INTO syls_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ꠡꠣꠔ ꠛꠞꠍ ꠗꠞꠤ ꠝꠤꠡꠞꠅ ꠎꠦ ꠀꠇꠣꠟ ꠅꠁꠛ, ꠢꠃ ꠀꠇꠣꠟꠞ ꠟꠣꠉꠤ ꠗꠣꠘ ꠎꠝꠣꠁꠀ ꠞꠣꠈꠛꠣ, ꠔꠦꠃ ꠀꠇꠣꠟꠦ ꠖꠦꠡꠞ ꠝꠣꠘꠥꠡ ꠝꠞꠔꠣ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ꠁꠃꠍꠥꠚꠞ ꠁ ꠝꠣꠔ, ꠚꠦꠞꠣꠃꠘ ꠀꠞ ꠔꠣꠘ ꠖꠞꠛꠣꠞꠞ ꠢꠇꠟꠞ ꠉꠦꠍꠦ ꠈꠥꠛ ꠜꠣꠟꠣ ꠝꠘꠅ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ꠚꠦꠞꠣꠃꠘꠦ ꠔꠣꠘ ꠃꠎꠤꠞ-ꠘꠣꠎꠤꠞ ꠅꠇꠟꠞꠦ ꠇꠁꠟꠣ, “ꠁ ꠛꠦꠌꠣꠠꠣꠞ ꠟꠣꠈꠣꠘ ꠀꠟ꠆ꠟꠣꠞ ꠞꠥꠢꠀꠟꠣ ꠝꠣꠘꠥꠡ ꠀꠝꠤ ꠇꠥꠀꠁ ꠔꠥꠇꠣꠁꠀ ꠙꠣꠁꠝꠥ?” ");
INSERT INTO syls_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ꠅꠃ ꠚꠦꠞꠣꠃꠘꠦ ꠁꠃꠍꠥꠚꠞꠦ ꠇꠁꠟꠣ, “ꠀꠟ꠆ꠟꠣꠄ ꠎꠦꠛꠟꠣ ꠔꠥꠝꠣꠞ ꠉꠦꠍꠦ ꠁꠔꠣ ꠢꠇ꠆ꠇꠟꠔꠣ ꠎꠣꠁꠞ ꠇꠞꠍꠂꠘ, ꠔꠦ ꠔꠥꠝꠣꠞ ꠟꠣꠈꠣꠘ ꠛꠥꠎꠖꠣꠞ ꠀꠞ ꠛꠤꠛꠦꠇꠝꠣꠘ ꠔ ꠀꠞ ꠇꠦꠃ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","ꠅꠈꠘ ꠞꠣꠎꠛꠣꠠꠤꠞ ꠢꠇ꠆ꠇꠟꠔꠣ ꠔꠥꠝꠤꠃ ꠌꠣꠟꠣꠁꠛꠣꠄ। ꠀꠝꠣꠞ ꠢꠇꠟ ꠙ꠆ꠞꠎꠣ ꠔꠥꠝꠣꠞ ꠢꠥꠇꠥꠝꠦ ꠌꠟꠛꠣ। ꠈꠣꠟꠤ ꠛꠣꠖꠡꠣꠞ ꠔꠈ꠆ꠔꠅ, ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠃꠙꠞꠦ ꠕꠣꠇꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ꠔꠣꠁꠘ ꠁꠃꠍꠥꠚꠞꠦ ꠇꠁꠟꠣ, “ꠢꠥꠘꠅ, ꠀꠝꠤ ꠀꠡ꠆ꠔꠣ ꠝꠤꠡꠞ ꠖꠦꠡ ꠔꠥꠝꠣꠞ ꠀꠔꠅ ꠡꠙꠤ ꠖꠤꠟꠣꠝ।” ");
INSERT INTO syls_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ꠀꠞ ꠚꠦꠞꠣꠃꠘꠦ ꠘꠤꠎꠞ ꠀꠋꠉꠥꠁꠟ ꠕꠣꠇꠤ ꠛꠣꠖꠡꠣꠁ ꠡꠤꠟꠞ ꠀꠋꠐꠤ ꠈꠥꠟꠤꠀ ꠁꠃꠍꠥꠚꠞ ꠀꠔꠅ ꠚꠤꠘ꠆ꠖꠣꠁꠟꠣ, ꠔꠣꠘ ꠉꠟꠣꠔ ꠡꠥꠘꠣꠞ ꠢꠣꠞ ꠖꠤꠟꠣ ꠀꠞ ꠖꠣꠝꠤ ꠇꠣꠙꠠꠞ ꠡꠣꠖꠣ ꠟꠦꠛꠣꠍꠅ ꠚꠤꠘ꠆ꠖꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠁꠃꠍꠥꠚꠞꠦ ꠔꠣꠘ ꠞꠣꠁꠎ꠆ꠎꠞ ꠖꠥꠁ ꠘꠝ꠆ꠛꠞ ꠞꠕꠞ ꠝꠣꠎꠦ ꠔꠥꠟꠟꠣ ꠀꠞ ꠁꠃꠍꠥꠚꠞ ꠀꠉꠦ ꠀꠉꠦ ꠄꠟꠣꠘ ꠇꠞꠣ ꠅꠁꠟ, “ꠙꠞꠘꠣꠝ ꠇꠞꠅ! ꠙꠞꠘꠣꠝ ꠇꠞꠅ!” ꠅꠃ ꠟꠣꠈꠣꠘ ꠔꠣꠁꠘ ꠁꠃꠍꠥꠚꠞ ꠃꠙꠞꠦ ꠀꠡ꠆ꠔꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠜꠣꠞ ꠡꠝꠎꠣꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ꠚꠦꠞꠣꠃꠘꠦ ꠁꠃꠍꠥꠚꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤꠃ ꠚꠦꠞꠣꠃꠘ, ꠝꠤꠡꠞꠞ ꠛꠣꠖꠡꠣ! ꠅꠁꠟꠦ ꠔꠥꠝꠣꠞ ꠢꠥꠇꠥꠝ ꠍꠣꠠꠣ, ꠀꠡ꠆ꠔꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠇꠦꠃ ꠞꠥꠝꠣꠅ ꠟꠣꠠꠣꠁꠔ ꠙꠣꠞꠔ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ꠚꠦꠞꠣꠃꠘꠦ ꠁꠃꠍꠥꠚꠞ ꠘꠄꠀ ꠘꠣꠝ ꠞꠣꠈꠟꠣ, ꠡꠣꠚꠘꠕ-ꠙꠣꠘꠦꠢ। ꠔꠣꠁꠘ ꠅꠃꠘ ꠝꠘ꠆ꠖꠤꠞꠞ ꠛꠣꠛꠘ-ꠑꠣꠇꠥꠞ ꠙꠥꠐꠤꠚꠦꠞꠣꠞ ꠙꠥꠠꠤ ꠀꠡꠘꠔꠞꠦ ꠁꠃꠍꠥꠚꠞ ꠟꠉꠦ ꠛꠤꠀ ꠖꠤꠟꠣ ꠀꠞ ꠁꠃꠍꠥꠚꠦ ꠀꠡ꠆ꠔꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠊꠥꠞꠣꠊꠥꠞꠤ ꠇꠞꠣꠔ ꠟꠣꠉꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","ꠁꠃꠍꠥꠚꠦ ꠔꠤꠡ ꠛꠞꠍ ꠛꠄꠅꠡꠅ, ꠝꠤꠡꠞꠞ ꠛꠣꠖꠡꠣ ꠚꠦꠞꠣꠃꠘꠞ ꠇꠣꠝꠅ ꠟꠣꠉꠟꠣ, ꠔꠣꠁꠘ ꠚꠦꠞꠣꠃꠘꠞ ꠖꠞꠛꠣꠞ ꠕꠘꠦ ꠛꠣꠞ ꠅꠁꠀ ꠖꠦꠡꠞ ꠢꠇꠟ ꠎꠣꠉꠣ ꠍꠚꠞ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ꠀꠞ ꠛꠦꠡꠤ ꠚꠡꠟꠞ ꠅꠃ ꠡꠣꠔ ꠛꠍꠞꠦ ꠖꠦꠡꠅ ꠛꠃꠔ ꠚꠡꠟ ꠚꠟꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","ꠔꠦꠃ ꠁꠃꠍꠥꠚꠦ ꠁ ꠡꠥꠖꠤꠘꠞ ꠡꠣꠔ ꠛꠍꠞꠦ ꠝꠤꠡꠞꠞ ꠢꠇꠟ ꠗꠣꠘ, ꠛꠣꠎꠣꠞꠞ ꠉꠥꠖꠣꠝ ꠊꠞꠣꠁꠘ꠆ꠔꠅ ꠎꠝꠣ ꠇꠞꠣꠁꠀ ꠕꠁꠟꠣ। ꠔꠣꠁꠘ ꠢꠇ꠆ꠇꠟ ꠛꠣꠎꠣꠞꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠞ ꠗꠣꠘ ꠅꠇꠟ, ꠢꠃ ꠛꠣꠎꠣꠞꠞ ꠉꠥꠖꠣꠝꠅ ꠎꠝꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","ꠔꠣꠁꠘ ꠖꠞꠤꠀꠞ ꠛꠣꠟꠥꠞ ꠟꠣꠈꠣꠘ ꠅꠃꠟꠣ ꠛꠦꠢꠤꠡꠣꠛ ꠗꠣꠘ ꠖꠟꠣ ꠇꠞꠟꠣ ꠎꠦꠘ, ꠁꠔꠣ ꠀꠞ ꠝꠣꠙꠤꠀ ꠚꠥꠠꠣꠁꠔꠣ ꠙꠣꠞꠟꠣ ꠘꠣ, ꠔꠦꠃ ꠝꠣꠙꠣ-ꠝꠣꠙꠤ ꠇꠞꠣ ꠛꠣꠖ ꠖꠤꠟꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","ꠀꠞ ꠀꠇꠣꠟꠞ ꠀꠉꠦ ꠅꠃꠘ ꠝꠘ꠆ꠖꠤꠞꠞ ꠛꠣꠛꠘ-ꠑꠣꠇꠥꠞ, ꠙꠥꠐꠤꠚꠦꠞꠣꠞ ꠙꠥꠠꠤ ꠀꠡꠘꠔꠞ ꠙꠦꠐꠅ ꠁꠃꠍꠥꠚꠞ ꠖꠥꠁ ꠙꠥꠀ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","ꠁꠃꠍꠥꠚꠦ ꠔꠣꠘ ꠛꠠ ꠙꠥꠀꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠝꠣꠘꠡꠣ ꠝꠣꠘꠤ, ꠚꠣꠃꠞꠤꠟꠣꠅꠀ। ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠀꠟ꠆ꠟꠣꠄ ꠀꠝꠣꠞ ꠢꠇꠟ ꠔꠇꠟꠤꠚ ꠀꠞ ꠛꠣꠚꠞ ꠛꠣꠠꠤꠞ ꠢꠇ꠆ꠇꠟꠔꠣ, ꠀꠝꠣꠞ ꠖꠤꠟ ꠕꠘꠦ ꠚꠣꠃꠞꠣꠁꠟꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","ꠛꠣꠖꠦ ꠔꠣꠘ ꠖꠥꠍꠞꠣ ꠙꠥꠀꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠀꠚꠞꠣꠁꠝ ꠝꠣꠘꠤ, ꠚꠟꠖꠣꠞ। ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠎꠦ ꠖꠦꠡꠅ ꠔꠇꠟꠤꠚ ꠙꠣꠁꠍꠤ, ꠢꠃ ꠖꠦꠡꠅꠃ ꠀꠟ꠆ꠟꠣꠄ ꠀꠝꠣꠞꠦ ꠚꠟꠖꠣꠞ ꠛꠣꠘꠣꠁꠟꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ꠀꠞ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠈꠥꠛ ꠛꠦꠡꠤ ꠚꠡꠟꠞ ꠢꠤ ꠡꠣꠔ ꠛꠞꠍ ꠙꠥꠞꠤꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ꠔꠦꠃ ꠁꠃꠍꠥꠚꠦ ꠎꠦꠟꠣ ꠇꠁꠍꠟꠣ, ꠅꠃꠟꠣ ꠀꠇꠣꠟꠞ ꠢꠃ ꠡꠣꠔ ꠛꠞꠍ ꠀꠁꠀ ꠀꠎꠤꠟ। ꠄꠞ ꠟꠉꠦ ꠇꠣꠘ꠆ꠖꠣ-ꠇꠣꠍꠣꠞ ꠢꠇꠟ ꠖꠦꠡꠅ-ꠅ ꠘꠤꠖꠣꠘ ꠖꠦꠈꠣ ꠖꠤꠟ ꠅꠁꠟꠦ ꠝꠤꠡꠞꠞ ꠇꠥꠘꠥ ꠎꠣꠉꠣꠔ ꠈꠣꠘꠤ-ꠈꠥꠞꠣꠇꠤꠞ ꠅꠜꠣꠛ ꠅꠁꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ꠢꠦꠡꠦ ꠀꠡ꠆ꠔꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠀꠇꠣꠟ ꠖꠦꠈꠣ ꠖꠤꠟꠦ, ꠙ꠆ꠞꠎꠣ ꠅꠇꠟꠦ ꠀꠁꠀ ꠚꠦꠞꠣꠃꠘꠞ ꠉꠦꠍꠦ ꠈꠣꠘꠤ ꠝꠣꠉꠤꠟꠣ, ꠔꠦꠃ ꠚꠦꠞꠣꠃꠘꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠁꠃꠍꠥꠚꠞ ꠉꠦꠍꠦ ꠎꠣꠅ। ꠄꠁꠘ ꠎꠦꠟꠣ ꠇꠂꠘ, ꠑꠤꠇꠃ ꠅꠃꠟꠣ ꠇꠞꠅ।” ");
INSERT INTO syls_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","ꠁ ꠀꠇꠣꠟ ꠀꠡ꠆ꠔꠣ ꠖꠦꠡ ꠎꠥꠠꠤ ꠖꠦꠈꠣ ꠖꠤꠟ। ꠛꠣꠖꠦ ꠀꠞꠅ ꠛꠦꠎꠥꠁꠔꠣ ꠅꠀꠄ ꠁꠃꠍꠥꠚꠦ ꠢꠇꠟ ꠎꠣꠉꠣꠞ ꠉꠥꠖꠣꠝ ꠊꠞꠣꠁꠘ ꠈꠥꠟꠤꠀ, ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠉꠦꠍꠦ ꠗꠣꠘ ꠛꠦꠌꠣꠔ ꠟꠣꠉꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ꠀꠡ꠆ꠔꠣ ꠖꠥꠘꠤꠀꠁꠔ ꠘꠤꠖꠣꠘ ꠖꠦꠈꠣ ꠖꠤꠟ ꠀꠞ ꠢꠇꠟ ꠖꠦꠡꠞ ꠝꠣꠘꠡꠦ ꠗꠣꠘ ꠈꠞꠤꠖ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠁꠃꠍꠥꠚꠞ ꠉꠦꠍꠦ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","ꠁꠀꠇꠥꠛꠦꠅ ꠢꠥꠘꠟꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠗꠣꠘ ꠀꠍꠦ, ꠅꠃ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠄꠉꠥꠄ ꠀꠞꠉꠥꠞ ꠝꠥꠈꠞ ꠛꠣꠄ ꠌꠣꠁ ꠞꠁꠍ ꠇꠦꠘꠦ? ");
INSERT INTO syls_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","ꠢꠥꠘꠅ, ꠀꠝꠤ ꠢꠥꠘꠍꠤ, ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠗꠣꠘ ꠀꠍꠦ, ꠔꠥꠝꠞꠣ ꠢꠘꠅ ꠉꠤꠀ ꠀꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠇꠤꠍꠥ ꠗꠣꠘ ꠟꠁꠀ ꠀꠘꠅ, ꠔꠦꠃ ꠀꠝꠞꠣ ꠁ ꠝꠞꠘ ꠕꠣꠇꠤꠀ ꠎꠣꠘꠦ ꠛꠣꠌꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","ꠅꠃ ꠁꠃꠍꠥꠚꠞ ꠖꠡꠅ ꠜꠣꠁꠄ ꠗꠣꠘ ꠟꠁꠀ ꠀꠘꠣꠞ ꠟꠣꠉꠤ ꠝꠤꠡꠞꠅ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ꠅꠁꠟꠦ ꠁꠀꠇꠥꠛꠦ ꠁꠃꠍꠥꠚꠞ ꠀꠙꠘ ꠝꠣʼꠞ ꠙꠦꠐꠞ ꠜꠣꠁ ꠛꠤꠘ-ꠁꠀꠝꠤꠘꠞꠦ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠎꠣꠁꠔꠦ ꠖꠤꠟꠣ ꠘꠣ, ꠔꠣꠁꠘ ꠇꠁꠟꠣ, ꠄꠞ ꠇꠥꠘꠥ ꠛꠤꠙꠖ ꠅꠁꠎꠤꠔ ꠙꠣꠞꠦ। ");
INSERT INTO syls_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","ꠗꠣꠘ ꠈꠞꠤꠖꠞ ꠟꠣꠉꠤ ꠇꠦꠘꠣꠘ ꠖꠦꠡ ꠕꠣꠇꠤ ꠎꠦꠞꠣ ꠝꠤꠡꠞꠅ ꠉꠦꠟ, ꠁꠍꠞꠣꠁꠟꠞ ꠙꠥꠀꠂꠘꠅ ꠔꠣꠞꠣꠞ ꠖꠟꠞ ꠟꠉꠅ ꠅꠁꠀ ꠉꠦꠟꠣ, ꠇꠣꠞꠘ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ-ꠅ ꠀꠇꠣꠟ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","ꠁ ꠡꠝꠄ ꠁꠃꠍꠥꠚꠃ ꠀꠍꠟꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠢꠇ꠆ꠇꠟꠔꠣꠞ ꠝꠣꠟꠤꠇ। ꠖꠦꠡꠞ ꠢꠇꠟ ꠝꠣꠘꠡꠞ ꠉꠦꠍꠦ ꠔꠣꠁꠘꠃ ꠗꠣꠘ ꠛꠦꠌꠔꠣ। ꠔꠦꠃ ꠁꠃꠍꠥꠚꠞ ꠜꠣꠁꠀꠁꠘꠅ ꠔꠣꠘ ꠉꠦꠍꠦ ꠉꠤꠀ, ꠔꠣꠞꠣ ꠝꠣꠕꠣꠞꠦ ꠝꠣꠐꠤꠔ ꠟꠣꠉꠣꠁꠀ ꠔꠣꠘꠞꠦ ꠁꠎ꠆ꠎꠔ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","ꠁꠃꠍꠥꠚꠦ ꠔꠣꠘ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞꠦ ꠖꠦꠈꠤꠀꠃ ꠌꠤꠘꠤꠟꠤꠟꠣ, ꠅꠁꠟꠦ ꠘꠣ ꠌꠤꠘꠣꠞ ꠜꠣꠘ ꠇꠞꠤꠀ, ꠔꠣꠁꠘ ꠈꠥꠛ ꠇꠠꠣ ꠉꠟꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠎꠤꠇꠣꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠇꠥꠀꠁ ꠕꠣꠇꠤ ꠀꠁꠍ?” ꠔꠣꠞꠣ ꠇꠁꠟꠣ, “ꠀꠝꠞꠣ ꠇꠦꠘꠣꠘ ꠖꠦꠡ ꠕꠘꠦ ꠀꠁꠍꠤ, ꠗꠣꠘ ꠘꠤꠛꠣꠞ ꠟꠣꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","ꠁꠃꠍꠥꠚꠦ ꠔꠣꠘ ꠜꠣꠁꠀꠁꠘꠞꠦ ꠢꠣꠍꠣꠞꠞ ꠌꠤꠘꠟꠦꠅ, ꠜꠣꠁꠀꠁꠘ꠆ꠔꠦ ꠔꠣꠘꠞꠦ ꠌꠤꠘꠟꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","ꠔꠣꠁꠘ ꠄꠞꠣꠞꠦ ꠟꠁꠀ ꠈꠥꠀꠛꠦ ꠎꠦꠔꠣ ꠖꠦꠈꠍꠟꠣ, ꠢꠃ ꠇꠕꠣ ꠔꠣꠘ ꠝꠘꠅ ꠅꠁꠟ। ꠅꠃ ꠔꠣꠁꠘ ꠄꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠔ ꠉꠥꠁꠀ! ꠀꠝꠞꠣꠞ ꠖꠦꠡꠞ ꠚꠣꠇ-ꠚꠥꠇꠞ ꠅꠔꠣ ꠖꠦꠈꠣꠔ ꠀꠁꠍ।” ");
INSERT INTO syls_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","ꠔꠣꠞꠣ ꠇꠁꠟꠣ, “ꠎꠤ ꠘꠣ ꠢꠥꠎꠥꠞ, ꠀꠙꠘꠣꠞ ꠁ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠦ ꠈꠣꠟꠤ ꠗꠣꠘ ꠟꠅꠀꠔ ꠀꠁꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ꠀꠝꠞꠣ ꠔ ꠢꠇꠟ ꠄꠇ ꠛꠣꠚꠞ ꠀꠅꠟꠣꠖ ꠀꠞ ꠍꠣꠁꠌ꠆ꠌꠣ ꠝꠣꠘꠥꠡ; ꠀꠙꠘꠣꠞ ꠁ ꠉꠥꠟꠣꠝ ꠅꠇꠟ ꠇꠥꠘꠥ ꠉꠥꠁꠀ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","ꠁꠃꠍꠥꠚꠦ ꠢꠤꠞꠛꠣꠞ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠘꠣ, ꠘꠣ, ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠖꠦꠡꠞ ꠚꠣꠇ-ꠚꠥꠇꠞ ꠖꠦꠈꠣꠔ ꠀꠁꠍ।” ");
INSERT INTO syls_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","ꠔꠣꠞꠣ ꠇꠁꠟꠣ, “ꠀꠙꠘꠣꠞ ꠉꠥꠟꠣꠝ ꠅꠇꠟ, ꠢꠇꠟꠦ ꠝꠤꠟꠤꠀ ꠛꠣꠞꠅ ꠜꠣꠁ। ꠀꠝꠞꠣ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠞ ꠄꠇ ꠛꠣꠚꠞ ꠀꠅꠟꠣꠖ। ꠀꠝꠞꠣꠞ ꠢꠥꠞꠥ ꠜꠣꠁ ꠅꠈꠘ ꠛꠣꠛꠣꠞ ꠉꠦꠍꠦ ꠞꠁꠍꠦ, ꠀꠞ ꠀꠞꠇ ꠜꠣꠁ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","ꠁꠃꠍꠥꠚꠦ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠘꠣ, ꠘꠣ, ꠀꠝꠤ ꠑꠤꠇꠃ ꠇꠁꠍꠤ, ꠔꠥꠝꠞꠣ ꠉꠥꠁꠀꠃ! ");
INSERT INTO syls_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","ꠔꠦ ꠔꠥꠝꠞꠣꠞ ꠙꠞꠤꠇ꠆ꠇꠣ ꠅꠟꠣꠃ ꠅꠁꠎꠣꠃꠇ: ꠀꠝꠤ ꠚꠦꠞꠣꠃꠘꠞ ꠎꠣꠘꠞ ꠇꠍꠝ ꠇꠞꠤ ꠇꠁꠀꠞ, ꠔꠥꠝꠞꠣꠞ ꠢꠥꠞꠥ ꠜꠣꠁ ꠅꠘꠅ ꠘꠣ ꠀꠁꠟꠦ, ꠔꠥꠝꠞꠣꠅ ꠁꠘ ꠕꠘꠦ ꠍꠣꠠꠣ ꠙꠣꠁꠔꠣꠄ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","ꠔꠥꠝꠞꠣꠞ ꠄꠇꠎꠘꠞꠦ ꠙꠣꠑꠣꠁꠀ, ꠔꠥꠝꠞꠣꠞ ꠢꠃ ꠜꠣꠁꠞꠦ ꠀꠘꠣꠅ ꠀꠞ ꠛꠣꠇꠤ ꠢꠇꠟꠦ ꠛꠘ꠆ꠖꠤ ꠞꠅ। ꠅꠃ ꠙꠞꠤꠇ꠆ꠇꠣꠄ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠔꠞ ꠢꠣꠍꠣ-ꠝꠤꠍꠣ ꠛꠥꠎꠝꠥ। ꠔꠣꠞꠦ ꠘꠣ ꠀꠘꠟꠦ, ꠀꠝꠤ ꠚꠦꠞꠣꠃꠘꠞ ꠎꠣꠘꠞ ꠇꠍꠝ ꠇꠞꠤ ꠇꠁꠀꠞ, ꠔꠥꠝꠞꠣ ꠘꠤꠌꠄ ꠉꠥꠁꠀ!” ");
INSERT INTO syls_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","ꠀꠞ ꠁꠃꠍꠥꠚꠦ ꠔꠤꠘ ꠖꠤꠘ ꠔꠣꠞꠣꠞꠦ ꠀꠎꠔ ꠈꠣꠘꠣꠔ ꠛꠘ꠆ꠖꠤ ꠇꠞꠤ ꠕꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","ꠢꠦꠡꠦ ꠔꠤꠘ ꠖꠤꠘꠞ ꠖꠤꠘ, ꠁꠃꠍꠥꠚꠦ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠢꠥꠘꠅ, ꠀꠝꠤ ꠔ ꠀꠟ꠆ꠟꠣꠞꠦ ꠒꠞꠣꠁ, ꠔꠥꠝꠞꠣ ꠛꠣꠌꠔꠦ ꠌꠣꠁꠟꠦ, ꠀꠝꠤ ꠎꠦꠟꠣ ꠇꠁ, ꠅꠃꠟꠣ ꠇꠞꠅ। ");
INSERT INTO syls_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","ꠔꠥꠝꠞꠣ ꠢꠣꠍꠣꠞꠞ ꠍꠣꠁꠌ꠆ꠌꠣ ꠝꠣꠘꠥꠡ ꠅꠁꠟꠦ, ꠔꠥꠝꠞꠣꠞ ꠄꠇ ꠜꠣꠁ ꠀꠎꠔꠅ ꠕꠣꠇꠃꠇ ꠀꠞ ꠛꠣꠇꠤ ꠢꠇꠟꠦ ꠔꠥꠝꠞꠣꠞ ꠀꠇꠣꠟꠤ ꠙꠞꠤꠛꠣꠞꠞ ꠟꠣꠉꠤ ꠗꠣꠘ ꠟꠁꠀ ꠎꠣꠅꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","ꠔꠥꠝꠞꠣꠞ ꠝꠣꠔ ꠢꠣꠍꠣ ꠇꠤ ꠘꠣ ꠁꠐꠣ ꠛꠥꠎꠣꠞ ꠟꠣꠉꠤ, ꠔꠥꠝꠞꠣꠞ ꠢꠥꠞꠥ ꠜꠣꠁꠞꠦ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠟꠁꠀ ꠀꠁꠅ। ꠔꠦꠃ ꠔꠥꠝꠞꠣ ꠝꠞꠔꠣꠄ ꠘꠣꠄ।” ꠅꠃ ꠔꠣꠞꠣꠅ ꠞꠣꠎꠤ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ꠛꠣꠖꠦ ꠔꠣꠞꠣ ꠝꠣꠔꠣ-ꠝꠣꠔꠤ ꠇꠞꠟꠣ, “ꠢꠣꠍꠣꠃ ꠔ, ꠀꠝꠞꠣꠞ ꠢꠤ ꠜꠣꠁꠞ ꠟꠉꠦ ꠎꠦꠔꠣ ꠇꠞꠍꠤ ꠁꠔꠣ ꠅꠁꠘ꠆ꠘꠣꠄ। ꠢꠦ ꠀꠝꠞꠣꠞ ꠉꠦꠍꠦ ꠇꠣꠎ-ꠝꠤꠘꠔꠤ ꠇꠞꠟꠦꠅ, ꠀꠝꠞꠣ ꠔꠣꠞ ꠝꠣꠔꠅ ꠇꠣꠘ ꠖꠤꠍꠤ ꠘꠣ। ꠄꠞꠟꠣꠉꠤ ꠀꠝꠞꠣꠞ ꠃꠙꠞꠦ ꠁ ꠝꠍꠤꠛꠔ ꠀꠁꠍꠦ।” ");
INSERT INTO syls_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","ꠔꠦꠃ ꠞꠥꠛꠦꠘꠦ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠔ ꠔꠥꠝꠞꠣꠞꠦ ꠇꠁꠍꠟꠣꠝ, ꠔꠣꠞ ꠃꠙꠞꠦ ꠇꠥꠘꠥ ꠎꠥꠟꠥꠝ ꠇꠞꠤꠅ ꠘꠣ, ꠔꠥꠝꠞꠣ ꠢꠥꠘꠟꠣꠄ ꠘꠣ। ꠖꠦꠈꠅ, ꠅꠈꠘ ꠔꠣꠞ ꠟꠃꠞ ꠢꠤꠡꠣꠛ-ꠘꠤꠇꠣꠡ ꠖꠤꠔꠦ ꠅꠞ।” ");
INSERT INTO syls_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","ꠅꠁꠟꠦ ꠁꠃꠍꠥꠚꠦ ꠎꠦꠘ ꠔꠣꠞꠣꠞ ꠝꠣꠔ ꠛꠥꠎꠞꠣ, ꠁꠔꠣ ꠔꠣꠞꠣ ꠎꠣꠘꠟ ꠘꠣ। ꠇꠣꠞꠘ ꠔꠣꠁꠘ ꠝꠣꠔ ꠛꠥꠎꠣꠅꠞꠣ ꠄꠇꠎꠘꠞꠦ ꠝꠣꠎꠦ ꠞꠣꠈꠤꠀ, ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠝꠣꠔꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","ꠔꠦꠃ ꠁꠃꠍꠥꠚꠦ ꠔꠣꠞꠣꠞ ꠉꠦꠍ ꠕꠘꠦ ꠢꠞꠤꠀ ꠉꠤꠀ ꠇꠣꠘ꠆ꠖꠤꠔꠣ ꠟꠣꠉꠟꠣ। ꠛꠣꠖꠦ ꠢꠤꠞꠛꠣꠞ ꠀꠁꠀ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠝꠣꠔꠤꠟꠣ ꠀꠞ ꠔꠣꠁꠘ ꠡꠤꠝꠤꠅꠘꠞꠦ ꠗꠞꠤꠀ ꠔꠣꠞꠣꠞ ꠍꠣꠝꠘꠦꠃ ꠛꠣꠘ꠆ꠖꠣꠁꠟ꠆ꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","ꠛꠣꠖꠦ ꠁꠃꠍꠥꠚꠦ ꠔꠣꠞꠣꠞ ꠛꠡ꠆ꠔꠣꠞ ꠝꠣꠎꠦ ꠗꠣꠘ ꠜꠞꠣꠁꠀ, ꠎꠣꠞꠎꠤꠞ ꠐꠦꠇꠣ ꠔꠣꠞ ꠛꠡ꠆ꠔꠣꠔ ꠚꠤꠞꠣꠁ ꠖꠤꠀ, ꠄꠞꠣꠞ ꠙꠕꠞ ꠈꠣꠘꠤꠞ ꠝꠍꠣ ꠖꠦꠅꠀꠞ ꠟꠣꠉꠤ ꠢꠥꠇꠥꠝ ꠖꠤꠟꠣ। ꠀꠞ ꠅꠃꠟꠣ ꠇꠞꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","ꠢꠦꠡꠦ ꠔꠣꠞꠣ ꠎꠣꠞꠎꠤꠞ ꠉꠣꠗꠣꠞ ꠙꠤꠑꠤꠔ ꠗꠣꠘꠞ ꠉꠣꠁꠐ ꠛꠣꠘ꠆ꠖꠤꠀ ꠞꠅꠀꠘꠣ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","ꠙꠕꠅ ꠎꠤꠞꠣꠘꠤꠞ ꠎꠣꠉꠣꠔ ꠉꠤꠀ ꠎꠦꠛꠟꠣ ꠄꠇꠎꠘꠦ ꠉꠣꠗꠣꠞꠦ ꠈꠣꠅꠀꠘꠤꠞ ꠟꠣꠉꠤ ꠛꠡ꠆ꠔꠣ ꠈꠥꠟꠟ, ꠀꠞ ꠖꠦꠈꠟ, ꠛꠡ꠆ꠔꠣꠞ ꠝꠥꠈꠅ ꠔꠣꠞ ꠐꠦꠇꠣꠞ ꠈꠥꠔꠤ। ");
INSERT INTO syls_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","ꠅꠃ ꠢꠦ ꠔꠣꠞ ꠜꠣꠁꠀꠁꠘꠞꠦ ꠇꠁꠟ, “ꠖꠦꠈꠅ, ꠖꠦꠈꠅ, ꠀꠝꠣꠞ ꠐꠦꠇꠣ ꠀꠝꠣꠞ ꠛꠡ꠆ꠔꠣꠔ ꠚꠤꠞꠔ ꠖꠦꠅꠀ ꠅꠁꠍꠦ।” ꠖꠦꠈꠤꠀꠃ ꠔꠣꠞꠣꠞ ꠎꠣꠘ ꠃꠠꠤ ꠉꠦꠟ ꠀꠞ ꠒꠞꠣꠁꠀ ꠇꠣꠙꠔꠦ ꠇꠣꠙꠔꠦ ꠇꠁꠟ, “ꠀꠟ꠆ꠟꠣꠄ ꠀꠝꠞꠣꠞꠦ ꠁꠔꠣ ꠇꠤꠔꠣ ꠇꠞꠟꠣ?” ");
INSERT INTO syls_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","ꠛꠣꠖꠦ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠉꠤꠀ ꠔꠣꠞꠣꠞ ꠛꠣꠚ ꠁꠀꠇꠥꠛꠞ ꠉꠦꠍꠦ ꠀꠎꠤꠞ ꠅꠁꠀ, ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠢꠥꠘꠣꠁꠀ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“ꠢꠤ ꠖꠦꠡꠞ ꠝꠣꠟꠤꠇꠦ, ꠀꠝꠞꠣꠞꠦ ꠈꠥꠛ ꠇꠠꠣ ꠉꠟꠣꠄ ꠇꠁꠍꠂꠘ, ꠀꠝꠞꠣ ꠉꠥꠁꠀ ꠅꠁꠀ ꠢꠤ ꠖꠦꠡꠅ ꠉꠦꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","ꠀꠝꠞꠣ ꠇꠁꠍꠤ, ꠀꠝꠞꠣ ꠢꠇ ꠝꠣꠘꠥꠡ, ꠇꠥꠘꠥ ꠉꠥꠁꠀ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ꠀꠝꠞꠣ ꠛꠣꠞꠅꠎꠘ ꠜꠣꠁ, ꠄꠇ ꠛꠣꠚꠞ ꠛꠣꠞꠅ ꠙꠥꠀ, ꠅꠁꠟꠦ ꠀꠝꠞꠣꠞ ꠄꠇꠎꠘ ꠘꠣꠄ ꠀꠞ ꠢꠇꠟ ꠕꠘꠦ ꠢꠥꠞꠥ ꠜꠣꠁ ꠅꠈꠘ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠛꠣꠛꠣꠞ ꠉꠦꠍꠦ ꠞꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","ꠅꠃ ꠢꠤ ꠝꠣꠘꠡꠦ, ꠎꠦꠁꠘ ꠢꠤ ꠖꠦꠡꠞ ꠝꠣꠟꠤꠇ, ꠔꠣꠁꠘ ꠀꠝꠞꠣꠞꠦ ꠇꠁꠟꠣ, ‘ꠀꠝꠤ ꠅꠃꠟꠣ ꠛꠥꠎꠝꠥ ꠎꠦꠘ, ꠔꠥꠝꠞꠣ ꠢꠇ ꠝꠣꠘꠥꠡ। ꠔꠥꠝꠞꠣꠞ ꠄꠇ ꠜꠣꠁꠞꠦ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠕꠁꠀ, ꠔꠥꠝꠞꠣꠞ ꠀꠇꠣꠟꠤ ꠙꠞꠤꠛꠣꠞꠞ ꠟꠣꠉꠤ ꠗꠣꠘ ꠟꠁꠀ ꠎꠣꠅ। ");
INSERT INTO syls_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠢꠥꠞꠥ ꠜꠣꠁꠞꠦ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠟꠁꠀ ꠀꠁꠅ। ꠔꠦꠃ ꠀꠝꠤ ꠛꠥꠎꠝꠥ, ꠔꠥꠝꠞꠣ ꠢꠇ ꠝꠣꠘꠥꠡ, ꠇꠥꠘꠥ ꠉꠥꠁꠀ ꠘꠣꠄ। ꠛꠣꠖꠦ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠜꠣꠁꠞꠦ ꠚꠤꠞꠣꠁ ꠖꠤꠝꠥ ꠀꠞ ꠔꠥꠝꠞꠣ ꠁ ꠖꠦꠡꠅ ꠇꠣꠄ-ꠇꠣꠞꠛꠣꠞ ꠇꠞꠔꠣꠄ ꠙꠣꠞꠛꠣꠄ।’ ” ");
INSERT INTO syls_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","ꠛꠣꠖꠦ ꠔꠣꠞꠣ ꠛꠡ꠆ꠔꠣ ꠕꠘꠦ ꠗꠣꠘ ꠓꠣꠟꠔꠦꠃ ꠖꠦꠈꠂꠘ, ꠔꠣꠞꠣꠞ ꠢꠇꠟꠞ ꠐꠦꠇꠣꠞ ꠈꠥꠔꠤ ꠛꠡ꠆ꠔꠣꠞ ꠝꠣꠎꠦ ꠞꠁꠍꠦ। ꠁꠔꠣ ꠖꠦꠈꠤꠀ ꠔꠣꠞꠣꠞ ꠛꠣꠚꠦ ꠀꠞ ꠔꠣꠞꠣꠅ ꠒꠞꠣꠁꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","ꠔꠦꠃ ꠛꠣꠚꠦ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞꠦ ꠀꠅꠟꠣꠖ ꠍꠣꠠꠣ ꠛꠣꠘꠣꠁꠍ। ꠁꠃꠍꠥꠚ ꠘꠣꠄ, ꠡꠤꠝꠤꠅꠘꠅ ꠘꠣꠄ ꠀꠞ ꠅꠈꠘ ꠔꠥꠝꠞꠣ ꠢꠤꠞꠛꠣꠞ ꠛꠤꠘ-ꠁꠀꠝꠤꠘꠞꠦꠅ ꠘꠤꠔꠣꠄ ꠌꠣꠁꠞꠣꠄ। ꠁꠔꠣ ꠢꠇꠟꠔꠣꠃ ꠀꠝꠣꠞ ꠎꠥꠟꠥꠝ।” ");
INSERT INTO syls_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","ꠞꠥꠛꠦꠘꠦ ꠔꠣꠘ ꠛꠣꠚꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠛꠤꠘ-ꠁꠀꠝꠤꠘꠞꠦ ꠔꠥꠝꠣꠞ ꠉꠦꠍꠦ ꠚꠤꠞꠣꠁꠀ ꠀꠘꠔꠦ ꠘꠣ ꠙꠣꠞꠟꠦ, ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠖꠥꠁꠅ ꠙꠥꠀꠞꠦ ꠈꠥꠘ ꠇꠞꠤꠟꠤꠅ। ꠔꠣꠞꠦ ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠀꠔꠅ ꠍꠣꠠꠤ ꠖꠦꠅ, ꠀꠝꠤ ꠔꠣꠞꠦ ꠔꠥꠝꠣꠞ ꠉꠦꠍꠦ ꠚꠤꠞꠣꠁꠀ ꠀꠘꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","ꠁꠀꠇꠥꠛꠦ ꠇꠁꠟꠣ, “ꠘꠣ, ꠀꠝꠣꠞ ꠁ ꠙꠥꠀ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠖꠤꠔꠣꠝ ꠘꠣꠄ। ꠔꠣꠞ ꠜꠣꠁ ꠝꠞꠤꠉꠦꠍꠦ, ꠀꠞ ꠅꠈꠘ ꠢꠦ ꠄꠇꠟꠣ ꠎꠤꠔꠣ ꠀꠍꠦ। ꠔꠥꠝꠞꠣꠞ ꠎꠣꠅꠀꠞ ꠙꠕꠅ ꠎꠥꠖꠤ ꠔꠣꠞ ꠇꠥꠘꠥ ꠛꠤꠙꠖ ꠅꠄ, ꠔꠦ ꠅꠃ ꠙꠣꠇꠘꠣ ꠌꠥꠟꠦ ꠛꠃꠔ ꠖꠥꠈ ꠖꠤꠀ ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞꠦ ꠇꠄꠛꠞꠅ ꠢꠣꠞꠣꠁꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","ꠇꠦꠘꠣꠘ ꠖꠦꠡꠞ ꠀꠇꠣꠟꠞ ꠖꠡꠣ ꠀꠞꠅ ꠛꠦꠢꠣꠟ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ꠀꠞ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠘꠦ ꠎꠦꠔꠣ ꠗꠣꠘ ꠘꠤꠍꠟꠣ, ꠁꠔꠣ ꠚꠥꠠꠣꠁ ꠉꠦꠟꠦ ꠁꠍꠞꠣꠁꠟꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠢꠤꠞꠛꠣꠞ ꠉꠤꠀ ꠀꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠀꠞꠅ ꠇꠤꠍꠥ ꠈꠣꠘꠤ-ꠈꠥꠞꠣꠇꠤ ꠟꠁꠀ ꠀꠘꠅꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","ꠔꠦꠃ ꠄꠢꠥꠖꠣꠄ ꠔꠣꠘꠞꠦ ꠇꠁꠟ, “ꠢꠃ ꠝꠣꠘꠡꠦ ꠀꠝꠞꠣꠞꠦ ꠈꠥꠛ ꠇꠠꠣ ꠜꠣꠡꠣꠄ ꠇꠁꠀ ꠖꠤꠍꠂꠘ, ‘ꠔꠥꠝꠞꠣꠞ ꠜꠣꠁ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠘꠣ ꠀꠁꠟꠦ ꠔꠥꠝꠞꠣ ꠀꠞ ꠀꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠀꠁꠅ ꠘꠣ।’ ");
INSERT INTO syls_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","ꠅꠈꠘ ꠔꠥꠝꠤ ꠀꠝꠞꠣꠞ ꠜꠣꠁꠞꠦ ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠇꠞꠤ ꠖꠦꠅ, ꠔꠦꠃ ꠀꠝꠞꠣ ꠉꠤꠀ ꠔꠥꠝꠣꠞ ꠟꠣꠉꠤ ꠈꠣꠘꠤ ꠟꠁꠀ ꠀꠁꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ꠀꠞ ꠔꠣꠞꠦ ꠟꠉꠦ ꠘꠣ ꠖꠤꠟꠦ ꠀꠝꠞꠣꠅ ꠎꠣꠁꠔꠣꠝ ꠘꠣꠄ। ꠢꠤ ꠝꠣꠘꠡꠦ ꠀꠝꠞꠣꠞꠦ ꠇꠁꠀ ꠖꠤꠍꠂꠘ, ‘ꠔꠥꠝꠞꠣꠞ ꠜꠣꠁꠞꠦ ꠟꠉꠦ ꠘꠣ ꠀꠘꠟꠦ, ꠔꠥꠝꠞꠣ ꠀꠞ ꠀꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠀꠁꠅ ꠘꠣ।’ ” ");
INSERT INTO syls_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","ꠁꠍꠞꠣꠁꠟꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠇꠦꠘꠦ ꠀꠝꠣꠞ ꠟꠉꠦ ꠅꠃꠟꠣ ꠚꠣꠔꠞꠣꠝꠤ ꠇꠞꠟꠣꠄ? ꠔꠥꠝꠞꠣꠞ ꠀꠞꠇ ꠜꠣꠁ ꠀꠍꠦ, ꠁꠔꠣ ꠔꠣꠘꠞꠦ ꠇꠦꠘꠦ ꠇꠁꠟꠣꠄ?” ");
INSERT INTO syls_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","ꠔꠣꠞꠣ ꠇꠁꠟꠣ, “ꠢꠤ ꠝꠣꠘꠡꠦ ꠀꠝꠞꠣꠞ ꠀꠞ ꠀꠝꠞꠣꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠀꠉꠣ-ꠉꠥꠠꠤ ꠢꠇ꠆ꠇꠟꠔꠣ ꠎꠤꠇꠣꠁꠍꠂꠘ, ‘ꠔꠥꠝꠞꠣꠞ ꠛꠣꠚ ꠇꠤꠔꠣ ꠅꠈꠘꠅ ꠎꠤꠘ꠆ꠖꠣ ꠀꠍꠂꠘ ꠘꠤ? ꠔꠥꠝꠞꠣꠞ ꠀꠞ ꠇꠥꠘꠥ ꠜꠣꠁ ꠀꠍꠂꠘ ꠘꠤ?’ ꠀꠝꠞꠣ ꠈꠣꠟꠤ ꠔꠣꠘ ꠍꠅꠀꠟꠞ ꠎꠥꠀꠙ ꠖꠤꠍꠟꠣꠝ, ꠀꠝꠞꠣ ꠇꠥꠘꠥ ꠎꠣꠘꠔꠣꠝ ꠘꠤ, ꠔꠣꠁꠘ ꠇꠁꠛꠣ ꠔꠥꠝꠞꠣꠞ ꠜꠣꠁꠞꠦꠅ ꠟꠁꠀ ꠀꠁꠅ?” ");
INSERT INTO syls_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","ꠄꠢꠥꠖꠣꠄ ꠔꠣꠘ ꠛꠣꠚꠞꠦ ꠇꠁꠟꠣ, “ꠔꠣꠞꠦ ꠀꠝꠣꠞ ꠟꠉꠦ ꠇꠞꠤ ꠖꠤꠟꠣꠅ, ꠀꠝꠞꠣ ꠎꠟꠖꠤ ꠎꠟꠖꠤ ꠞꠅꠀꠘꠣ ꠅꠁꠎꠣꠁ, ꠔꠦꠃ ꠔꠥꠝꠤ, ꠀꠝꠞꠣ ꠀꠞ ꠀꠝꠞꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ ꠢꠇ꠆ꠇꠟꠃ ꠎꠣꠘꠦ ꠛꠣꠌꠝꠥ, ꠇꠦꠃ ꠝꠞꠔꠣꠝ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","ꠀꠝꠤ ꠘꠤꠎꠦꠃ ꠔꠣꠞ ꠟꠣꠉꠤ ꠎꠣꠝꠤꠘ ꠞꠁꠟꠣꠝ, ꠔꠣꠞꠦ ꠀꠝꠣꠞ ꠉꠦꠍ ꠕꠘꠦ ꠡꠝꠎꠤꠀ ꠘꠤꠅ। ꠀꠝꠤ ꠔꠣꠞꠦ ꠔꠥꠝꠣꠞ ꠉꠦꠍꠦ ꠚꠤꠞꠣꠁꠀ ꠘꠣ ꠀꠘꠟꠦ, ꠔꠥꠝꠣꠞ ꠉꠦꠍꠦ ꠀꠎꠤꠞ ꠘꠣ ꠇꠞꠟꠦ, ꠢꠣꠞꠣ ꠎꠤꠘ꠆ꠖꠦꠉꠤ ꠜꠞꠣ ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠉꠦꠍꠦ ꠖꠣꠄꠁ ꠞꠁꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","ꠀꠞ ꠅꠔ ꠖꠦꠞꠤ ꠘꠣ ꠇꠞꠟꠦ, ꠀꠝꠞꠣ ꠅꠔꠖꠤꠘꠦ ꠖꠥꠁꠛꠣꠞ ꠊꠥꠞꠤꠀ ꠀꠁꠔꠣꠝ ꠙꠣꠞꠟꠣꠝ ꠅꠘꠦ।” ");
INSERT INTO syls_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","ꠅꠃ ꠔꠣꠞꠣꠞ ꠛꠣꠚ ꠁꠍꠞꠣꠁꠟꠦ ꠇꠁꠟꠣ, “ꠅꠃꠟꠣ ꠅꠁꠟꠦ ꠄꠇ ꠇꠣꠝ ꠇꠞꠅ, ꠔꠥꠝꠞꠣ ꠎꠣꠞꠎꠤꠞ ꠛꠦꠉꠞ ꠝꠣꠎꠦ ꠅꠘꠞ ꠜꠣꠟꠣ ꠜꠣꠟꠣ ꠝꠣꠟ, ꠀꠉꠞ, ꠝꠃ, ꠈꠥꠡꠛꠄ ꠝꠡꠟꠣ, ꠝꠦꠡꠇꠦ-ꠀꠝ꠆ꠛꠞ, ꠙꠦꠡ꠆ꠔꠣ ꠀꠞ ꠛꠣꠖꠣꠝ ꠜꠞꠤꠀ ꠢꠃ ꠝꠣꠘꠡꠞ ꠟꠣꠉꠤ ꠍꠣꠟꠣꠝꠤ ꠟꠁꠀ ꠎꠣꠅ। ");
INSERT INTO syls_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠇꠞꠤ ꠀꠉꠞ ꠒꠣꠛꠥꠟ ꠐꠦꠇꠣ ꠘꠦꠅ, ꠛꠡ꠆ꠔꠣꠞ ꠝꠥꠈꠅ ꠎꠦ ꠐꠦꠇꠣ ꠚꠤꠞꠔ ꠀꠁꠍꠦ, ꠔꠣ-ꠅ ꠢꠤꠞꠛꠣꠞ ꠟꠁꠀ ꠎꠣꠅ, ꠇꠤ ꠎꠣꠘꠤ ꠇꠥꠘꠥ ꠜꠥꠟ ꠅꠁꠉꠦꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","ꠔꠥꠝꠞꠣꠞ ꠁ ꠜꠣꠁꠞꠦ ꠟꠉꠦ ꠟꠁꠀ, ꠎꠟꠖꠤ ꠇꠞꠤ ꠢꠃ ꠝꠣꠘꠡꠞ ꠉꠦꠍꠦ ꠎꠣꠅ। ");
INSERT INTO syls_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","ꠡꠞ꠆ꠛ-ꠡꠇ꠆ꠔꠤꠝꠣꠘ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠢꠃ ꠝꠣꠘꠡꠞ ꠖꠤꠟꠅ ꠝꠦꠢꠦꠞꠛꠣꠘꠤ ꠙꠄꠖꠣ ꠇꠞꠃꠇ꠆ꠇꠣ, ꠎꠣꠔꠦ ꠔꠣꠁꠘ ꠔꠥꠝꠞꠣꠞ ꠢꠃ ꠜꠣꠁ ꠀꠞ ꠛꠤꠘ-ꠁꠀꠝꠤꠘꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠀꠔꠅ ꠚꠤꠞꠔ ꠖꠦꠁꠘ। ꠀꠞ ꠀꠝꠣꠞ ꠙꠥꠀ ꠈꠥꠀꠘꠤ ꠉꠦꠟꠦ, ꠘꠣ ꠅꠄ ꠉꠦꠟꠃ।” ");
INSERT INTO syls_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","ꠔꠦꠃ ꠔꠣꠞꠣ ꠢꠃ ꠍꠣꠟꠣꠝꠤ, ꠒꠣꠛꠥꠟ ꠐꠦꠇꠣ ꠀꠞ ꠛꠤꠘ-ꠁꠀꠝꠤꠘꠞꠦ ꠟꠁꠀ ꠞꠅꠀꠘꠣ ꠅꠁꠀ, ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠙꠃꠍꠤꠀ ꠁꠃꠍꠥꠚꠞ ꠍꠣꠝꠘꠦ ꠀꠎꠤꠞ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠛꠤꠘ-ꠁꠀꠝꠤꠘꠞꠦ ꠖꠦꠈꠤꠀ ꠁꠃꠍꠥꠚꠦ ꠔꠣꠘ ꠛꠣꠠꠤꠞ ꠈꠣꠖꠤꠝꠞꠦ ꠇꠁꠟꠣ, “ꠅꠃ ꠝꠣꠘꠥꠡ ꠅꠇꠟꠞꠦ ꠛꠣꠠꠤꠞ ꠜꠤꠔꠞꠦ ꠘꠦꠅ ꠀꠞ ꠈꠡꠤ ꠎꠛ ꠇꠞꠤꠀ ꠉꠥꠡ꠆ꠔ ꠞꠣꠘ꠆ꠖꠅ। ꠔꠣꠞꠣ ꠝꠣꠗꠣꠘꠦ ꠀꠝꠣꠞ ꠟꠉꠦ ꠈꠣꠁꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ꠁꠃꠍꠥꠚꠦ ꠎꠦꠟꠣ ꠇꠁꠟꠣ, ꠈꠣꠖꠤꠝꠦꠅ ꠑꠤꠇ ꠅꠃꠟꠣ ꠇꠞꠟ, ꠢꠦ ꠄꠞꠣꠞꠦ ꠛꠣꠠꠤꠞ ꠜꠤꠔꠞꠦ ꠟꠁꠀ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","ꠀꠞ ꠢꠦ ꠄꠞꠣꠞꠦ ꠁꠃꠍꠥꠚꠞ ꠛꠣꠠꠤꠞ ꠜꠤꠔꠞꠦ ꠘꠦꠅꠀꠄ, ꠔꠣꠞꠣ ꠒꠞꠣꠁꠀ ꠝꠣꠔꠣ-ꠝꠣꠔꠤ ꠇꠞꠟꠣ, “ꠀꠉꠞ ꠚꠤꠞꠣ ꠎꠦ ꠐꠦꠇꠣ ꠀꠝꠞꠣꠞ ꠛꠡ꠆ꠔꠣꠔ ꠇꠞꠤ ꠚꠤꠞꠔ ꠉꠦꠍꠤꠟ, ꠅꠔꠣꠞ ꠟꠣꠉꠤꠃ ꠀꠝꠞꠣꠞꠦ ꠅꠘꠅ ꠘꠤꠞꠣ, ꠅꠈꠘ ꠀꠝꠞꠣꠞ ꠖꠥꠡ ꠖꠦꠈꠣꠁꠀ ꠝꠣꠁꠞ-ꠗꠁꠞ ꠇꠞꠤꠀ ꠀꠝꠞꠣꠞꠦ ꠉꠥꠟꠣꠝ ꠛꠣꠘꠣꠁꠛꠣ, ꠀꠞ ꠉꠣꠗꠣ ꠅꠇꠟꠅ ꠇꠣꠠꠤꠀ ꠘꠤꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","ꠔꠦꠃ ꠁꠃꠍꠥꠚꠞ ꠛꠣꠠꠤꠞ ꠖꠞꠎꠣꠞ ꠍꠣꠝꠘꠦ ꠀꠁꠀ ꠔꠣꠞꠣ ꠛꠣꠠꠤꠞ ꠈꠣꠖꠤꠝꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“ꠢꠥꠎꠥꠞ, ꠀꠝꠞꠣ ꠄꠞ ꠀꠉꠦꠅ ꠗꠣꠘ ꠟꠅꠀꠔ ꠀꠁꠍꠟꠣꠝ, ");
INSERT INTO syls_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ꠢꠦꠡꠦ ꠚꠤꠞꠔ ꠎꠣꠅꠀꠞ ꠛꠣꠟꠣ, ꠖꠝ ꠟꠁꠛꠣꠞ ꠎꠣꠉꠣꠔ ꠙꠃꠍꠤꠀ, ꠛꠡ꠆ꠔꠣ ꠈꠥꠟꠔꠦꠃ ꠖꠦꠈꠤ, ꠀꠝꠞꠣꠞ ꠙꠥꠞꠣ ꠐꠦꠇꠣ-ꠙꠄꠡꠣ ꠎꠣꠞꠎꠤꠞ ꠛꠡ꠆ꠔꠣꠞ ꠝꠥꠈꠅ ꠞꠁꠍꠦ, ꠅꠈꠘ ꠅꠃ ꠐꠦꠇꠣ ꠚꠤꠞꠔ ꠀꠘꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ꠀꠞ ꠗꠣꠘ ꠘꠦꠅꠀꠞ ꠟꠣꠉꠤ ꠀꠞꠅ ꠐꠦꠇꠣ ꠀꠘꠍꠤ, ꠅꠁꠟꠦ ꠢꠤ ꠐꠦꠇꠣ ꠀꠝꠞꠣꠞ ꠛꠡ꠆ꠔꠣꠞ ꠜꠤꠔꠞꠦ ꠇꠦ ꠕꠁꠍꠤꠟ ꠎꠣꠘꠤ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","ꠅꠃ ꠈꠣꠖꠤꠝꠦ ꠇꠁꠟ, “ꠔꠥꠝꠞꠣꠞ ꠜꠣꠟꠣꠁ ꠅꠃꠇ, ꠒꠞꠣꠁꠅ ꠘꠣ। ꠔꠥꠝꠞꠣꠞ ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠚꠞ ꠀꠟ꠆ꠟꠣꠄ, ꠁ ꠉꠣꠁꠛꠤ ꠗꠘ ꠔꠥꠝꠞꠣꠞ ꠛꠡ꠆ꠔꠣꠞ ꠝꠣꠎꠦ ꠖꠤꠍꠂꠘ। ꠔꠥꠝꠞꠣꠞ ꠐꠦꠇꠣ ꠀꠝꠤ ꠙꠣꠁꠍꠤ।” ꠛꠣꠖꠦ ꠢꠦ ꠡꠤꠝꠤꠅꠘꠞꠦ ꠛꠣꠞ ꠇꠞꠤꠀ ꠔꠣꠞꠣꠞ ꠉꠦꠍꠦ ꠟꠁꠀ ꠀꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ꠢꠦ ꠢꠇꠟꠞꠦ ꠁꠃꠍꠥꠚꠞ ꠛꠣꠠꠤꠞ ꠜꠤꠔꠞꠦ ꠘꠤꠀ ꠙꠣꠘꠤ ꠖꠤꠟ ꠔꠣꠞꠣ ꠙꠣꠅ ꠗꠥꠁꠟꠣ ꠀꠞ ꠢꠦ ꠔꠣꠞꠣꠞ ꠉꠣꠗꠣ ꠅꠇꠟꠞꠦꠅ ꠈꠣꠘꠤ ꠖꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ꠁꠃꠍꠥꠚ ꠝꠣꠗꠣꠘꠦ ꠀꠁꠛꠣ ꠉꠔꠤꠇꠦ, ꠄꠞꠣ ꠔꠣꠞꠣꠞ ꠍꠣꠟꠣꠝꠤ ꠅꠇꠟ ꠎꠥꠁꠔ ꠇꠞꠟꠣ। ꠔꠣꠞꠣ ꠢꠥꠘꠍꠟꠣ ꠎꠦꠘ, ꠔꠣꠘ ꠟꠉꠦꠃ ꠔꠣꠞꠣꠞ ꠈꠣꠘꠣ-ꠖꠣꠘꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","ꠛꠣꠖꠦ ꠁꠃꠍꠥꠚ ꠛꠣꠠꠤꠔ ꠀꠁꠟꠦ, ꠔꠣꠞꠣꠞ ꠢꠃ ꠍꠣꠟꠣꠝꠤ ꠅꠇꠟ ꠊꠞꠞ ꠜꠤꠔꠞꠦ ꠘꠤꠀ ꠔꠣꠘꠞꠦ ꠖꠤꠟꠣ, ꠖꠤꠀ ꠢꠣꠞꠟꠦ ꠔꠣꠘꠞꠦ ꠍꠁꠎꠖꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","ꠔꠣꠞꠣꠞ ꠜꠣꠟꠣ-ꠛꠥꠞꠣ ꠈꠛꠞ ꠢꠥꠘꠤꠀ ꠔꠣꠁꠘ ꠎꠤꠇꠣꠁꠟꠣ, “ꠔꠥꠝꠞꠣꠞ ꠎꠦ ꠝꠥꠞꠛ꠆ꠛꠤ ꠛꠣꠚꠞ ꠇꠕꠣ ꠇꠁꠍꠟꠣꠄ, ꠔꠣꠁꠘ ꠜꠣꠟꠣ ꠀꠍꠂꠘ ꠘꠤ? ꠔꠣꠁꠘ ꠎꠤꠘ꠆ꠖꠣ ꠀꠍꠂꠘ ꠘꠤ?” ");
INSERT INTO syls_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","ꠔꠣꠞꠣ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠎꠤꠅꠄ, ꠀꠙꠘꠣꠞ ꠉꠥꠟꠣꠝ ꠀꠝꠞꠣꠞ ꠛꠣꠛꠣ ꠅꠈꠘꠅ ꠎꠤꠘ꠆ꠖꠣ ꠀꠍꠂꠘ ꠀꠞ ꠜꠣꠟꠣ ꠀꠍꠂꠘ।” ꠢꠦꠡꠦ ꠔꠣꠞꠣ ꠝꠣꠕꠣ ꠘꠥꠀꠁꠀ ꠔꠣꠘꠞꠦ ꠁꠎ꠆ꠎꠔ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","ꠁꠃꠍꠥꠚꠦ ꠌꠃꠈ ꠔꠥꠟꠤꠀ ꠔꠣꠘ ꠘꠤꠎꠞ ꠜꠣꠁ ꠛꠤꠘ-ꠁꠀꠝꠤꠘꠞꠦ ꠖꠦꠈꠤꠀ ꠇꠁꠟꠣ, “ꠅꠃꠘꠤ ꠔꠥꠝꠞꠣꠞ ꠢꠃ ꠢꠥꠞꠥ ꠜꠣꠁ, ꠎꠣꠞ ꠇꠕꠣ ꠀꠉꠦ ꠇꠁꠍꠟꠣꠄ?” ꠔꠣꠁꠘ ꠛꠤꠘ-ꠁꠀꠝꠤꠘꠞꠦ ꠇꠁꠟꠣ, “ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠣꠞꠦ ꠞꠢꠝ ꠇꠞꠃꠇ꠆ꠇꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","ꠜꠣꠁꠞꠦ ꠖꠦꠈꠤꠀ ꠁꠃꠍꠥꠚꠞ ꠖꠤꠟ ꠇꠣꠘ꠆ꠖꠤꠔ ꠟꠣꠉꠟ। ꠔꠣꠁꠘ ꠎꠟꠖꠤ ꠇꠞꠤ ꠛꠣꠞ ꠅꠁꠀ, ꠘꠤꠎꠞ ꠇꠥꠑꠣꠔ ꠉꠤꠀ ꠇꠣꠘ꠆ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","ꠛꠣꠖꠦ ꠌꠃꠈ-ꠝꠥꠈ ꠗꠁꠀ ꠛꠣꠞ ꠅꠁꠀ ꠀꠁꠟꠣ ꠀꠞ ꠘꠤꠎꠞꠦ ꠡꠣꠝꠟꠣꠁꠀ ꠈꠣꠘꠤ ꠛꠤꠟꠣꠁꠛꠣꠞ ꠢꠥꠇꠥꠝ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","ꠅꠃ ꠁꠃꠍꠥꠚꠞꠦ, ꠔꠣꠘ ꠜꠣꠁꠀꠁꠘꠞꠦ ꠀꠞ ꠔꠣꠘ ꠟꠉꠦ ꠈꠣꠘꠦꠀꠟꠣ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞꠦ ꠀꠟꠉ ꠀꠟꠉ ꠎꠣꠉꠣꠔ ꠈꠣꠘꠤ ꠖꠤꠟꠣ। ꠇꠣꠞꠘ ꠝꠤꠡꠞꠤꠘ꠆ꠔꠦ ꠁꠛꠞꠣꠘꠤ ꠅꠇꠟꠞ ꠟꠉꠦ ꠛꠁꠀ ꠈꠣꠘꠣ-ꠖꠣꠘꠣ ꠇꠞꠔ ꠘꠣ, ꠁꠔꠣ ꠔꠣꠞꠣ ꠊꠤꠘ ꠇꠞꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","ꠔꠣꠞꠣ ꠁꠃꠍꠥꠚꠞ ꠍꠣꠝꠘꠦ ꠔꠣꠘ ꠜꠣꠁꠀꠁꠘꠞꠦ ꠛꠠꠞꠦ ꠛꠠꠞ ꠎꠣꠉꠣꠔ, ꠢꠥꠞꠥꠞꠦ ꠢꠥꠞꠥꠞ ꠎꠣꠉꠣꠔ ꠛꠅꠀꠁꠟꠣ, ꠔꠦꠃ ꠔꠣꠞꠣ ꠔꠣꠁꠎ꠆ꠎꠥꠛ ꠅꠁꠀ ꠄꠇꠎꠘꠦ ꠀꠞꠇ ꠎꠘꠞ ꠛꠣꠄ ꠌꠣꠁ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","ꠀꠞ ꠁꠃꠍꠥꠚꠦ ꠘꠤꠎꠞ ꠕꠣꠟꠞ ꠈꠣꠘꠤ ꠕꠘꠦ ꠔꠣꠘ ꠜꠣꠁꠀꠁꠘꠞꠦ ꠖꠦꠅꠀꠁꠟꠣ, ꠅꠁꠟꠦ ꠛꠤꠘ-ꠁꠀꠝꠤꠘꠞꠦ ꠢꠇꠟ ꠕꠘꠦ ꠙꠣꠌ ꠉꠥꠘ ꠛꠦꠡꠤ ꠖꠦꠅꠀ ꠅꠁꠟ। ꠈꠣꠁꠀ ꠢꠣꠞꠟꠦ ꠔꠣꠞꠣ ꠈꠥꠡꠤ ꠅꠁꠀ ꠃꠑꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","ꠛꠣꠖꠦ ꠁꠃꠍꠥꠚꠦ ꠔꠣꠘ ꠛꠣꠠꠤꠞ ꠈꠣꠖꠤꠝꠞꠦ ꠅꠃ ꠟꠣꠈꠣꠘ ꠢꠥꠇꠥꠝ ꠖꠤꠟꠣ, “ꠁ ꠝꠣꠘꠥꠡ ꠅꠇꠟꠞ ꠛꠡ꠆ꠔꠣꠔ ꠎꠔ ꠗꠣꠘ ꠎꠣꠉꠣ ꠅꠄ, ꠜꠞꠤꠀ ꠖꠤꠟꠣꠅ ꠀꠞ ꠎꠣꠞꠎꠤꠞ ꠐꠦꠇꠣ ꠔꠣꠞ ꠛꠡ꠆ꠔꠣꠞ ꠝꠥꠈꠅ ꠕꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","ꠅꠁꠟꠦ ꠅꠃ ꠢꠥꠞꠥ ꠎꠘꠞ ꠛꠡ꠆ꠔꠣꠞ ꠝꠥꠈꠅ ꠔꠣꠞ ꠐꠦꠇꠣꠞ ꠟꠉꠦ ꠀꠝꠣꠞ ꠞꠥꠙꠣꠞ ꠛꠣꠐꠤꠅ ꠕꠁꠅ।” ꠁꠃꠍꠥꠚꠦ ꠔꠣꠞꠦ ꠎꠦꠟꠣ ꠇꠁꠟꠣ, ꠢꠦ ꠅꠃꠟꠣ ꠇꠞꠟ। ");
INSERT INTO syls_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","ꠛꠣꠖꠞ ꠖꠤꠘ ꠛꠤꠀꠘꠦꠃ ꠔꠣꠞꠣ ꠉꠣꠗꠣ ꠟꠁꠀ ꠛꠤꠖꠣꠄ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","ꠔꠣꠞꠣ ꠐꠣꠃꠘ ꠕꠣꠇꠤ ꠕꠥꠠꠣ ꠖꠥꠞꠁ ꠎꠣꠁꠔꠦꠃ ꠁꠃꠍꠥꠚꠦ ꠔꠣꠘ ꠛꠣꠠꠤꠞ ꠈꠣꠖꠤꠝꠞꠦ ꠇꠁꠟꠣ, “ꠎꠟꠖꠤ ꠇꠞꠤ ꠄꠞꠣꠞ ꠈꠞꠦ ꠖꠃꠠꠣꠁꠀ ꠉꠤꠀ, ꠄꠞꠣꠞ ꠟꠣꠉꠣꠟ ꠙꠣꠁꠀ ꠢꠣꠞꠟꠦ ꠇꠁꠛꠣꠄ, ꠔꠥꠝꠞꠣ ꠃꠙꠇꠣꠞꠞ ꠛꠖꠟꠣ ꠇꠦꠘꠦ ꠈꠦꠔꠤ ꠇꠞꠟꠣꠄ? ꠀꠝꠣꠞ ꠝꠥꠘꠤꠛꠞ ꠞꠥꠙꠣꠞ ꠛꠣꠐꠤ ꠇꠦꠘꠦ ꠌꠥꠞꠤ ꠇꠞꠟꠣꠄ? ");
INSERT INTO syls_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","ꠅꠃ ꠛꠣꠐꠤꠔ ꠇꠞꠤꠀ ꠔ ꠔꠣꠁꠘ ꠡꠞꠛꠔ-ꠙꠣꠘꠤ ꠈꠣꠁꠘ ꠀꠞ ꠔꠖꠛꠤꠞꠞ ꠇꠣꠝꠅ ꠇꠞꠂꠘ। ꠔꠥꠝꠞꠣ ꠁꠔꠣ ꠈꠥꠛ ꠅꠁꠘ꠆ꠘꠣꠄ ꠇꠞꠍ।” ");
INSERT INTO syls_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","ꠢꠤ ꠈꠣꠖꠤꠝꠦ ꠔꠣꠞꠣꠞ ꠈꠞꠦꠖꠤ ꠉꠤꠀ ꠟꠣꠉꠣꠟ ꠙꠣꠁꠀ ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","ꠅꠁꠟꠦ ꠔꠣꠞꠣ ꠇꠁꠟꠣ, “ꠢꠥꠎꠥꠞ ꠁꠟꠣ ꠝꠣꠔ ꠇꠦꠘꠦ ꠝꠣꠔꠤꠞꠣ? ꠀꠙꠘꠣꠞ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠦ ꠇꠥꠘꠥ ꠟꠣꠈꠣꠘꠃ ꠁꠔꠣ ꠇꠣꠝ ꠇꠞꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ꠖꠦꠈꠃꠇ꠆ꠇꠣ, ꠀꠉꠞꠛꠣꠞ ꠀꠝꠞꠣꠞ ꠛꠡ꠆ꠔꠣꠞ ꠝꠥꠈꠅ ꠎꠦ ꠐꠦꠇꠣ ꠙꠣꠁꠍꠟꠣꠝ, ꠁꠔꠣ ꠀꠝꠞꠣ ꠇꠦꠘꠣꠘ ꠖꠦꠡ ꠕꠘꠦ ꠢꠤꠞꠛꠣꠞ ꠀꠙꠘꠣꠞ ꠉꠦꠍꠦ ꠚꠤꠞꠔ ꠀꠘꠍꠤ, ꠔꠦ ꠀꠝꠞꠣ ꠇꠥꠘꠥ ꠀꠙꠘꠣꠞ ꠝꠥꠘꠤꠛꠞ ꠛꠣꠠꠤ ꠕꠘꠦ ꠡꠥꠘꠣ-ꠞꠥꠙꠣ ꠌꠥꠞꠤ ꠇꠞꠝꠥ ꠘꠤ? ");
INSERT INTO syls_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","ꠀꠙꠘꠣꠞ ꠁ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠞ ꠝꠣꠎꠦ ꠎꠣꠞ ꠉꠦꠍꠦ ꠅꠃ ꠛꠣꠐꠤ ꠙꠣꠁꠛꠣ, ꠔꠣꠞꠦ ꠝꠣꠞꠤꠟꠣꠁꠛꠣ ꠀꠞ ꠀꠝꠞꠣꠅ ꠢꠥꠎꠥꠞꠞ ꠉꠥꠟꠣꠝ ꠅꠁꠎꠤꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","ꠔꠦꠃ ꠈꠣꠖꠤꠝꠦ ꠇꠁꠟ, “ꠜꠣꠟꠣ ꠇꠕꠣ, ꠔꠦ ꠔꠥꠝꠞꠣ ꠎꠦꠟꠣ ꠇꠁꠟꠣꠄ, ꠅꠃꠟꠣꠃ ꠅꠃꠇ। ꠎꠣꠞ ꠉꠦꠍꠦ ꠅꠃ ꠛꠣꠐꠤ ꠝꠤꠟꠛ, ꠈꠣꠟꠤ ꠔꠣꠞꠦ ꠀꠝꠣꠞ ꠉꠥꠟꠣꠝ ꠛꠣꠘꠣꠁꠝꠥ ꠀꠞ ꠛꠣꠇꠤ ꠢꠇꠟ ꠈꠣꠟꠣꠍ ꠙꠣꠁꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","ꠅꠃ ꠔꠣꠞꠣ ꠎꠟꠖꠤ ꠇꠞꠤ ꠢꠇꠟꠞ ꠛꠡ꠆ꠔꠣ ꠝꠣꠐꠤꠔ ꠟꠣꠝꠣꠁꠀ ꠈꠥꠟꠟ। ");
INSERT INTO syls_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ꠀꠞ ꠈꠣꠖꠤꠝꠦ ꠛꠠ ꠜꠣꠁ ꠕꠘꠦ ꠢꠥꠞꠥ ꠜꠣꠁ ꠔꠞꠤ ꠢꠇꠟꠞ ꠛꠡ꠆ꠔꠣ ꠔꠥꠇꠣꠁꠟꠦꠅ ꠢꠦꠡꠦ ꠛꠤꠘ-ꠁꠀꠝꠤꠘꠞ ꠛꠡ꠆ꠔꠣꠔ ꠢꠤ ꠛꠣꠐꠤ ꠝꠤꠟꠟ। ");
INSERT INTO syls_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","ꠔꠦꠃ ꠔꠣꠞꠣ ꠎꠣꠞꠎꠤꠞ ꠚꠤꠘ꠆ꠘꠞ ꠇꠣꠙꠠ ꠚꠣꠠꠤꠟ꠆ꠟꠣ, ꠛꠣꠖꠦ ꠢꠤꠞꠛꠣꠞ ꠉꠣꠗꠣꠞ ꠙꠤꠑꠤꠔ ꠉꠣꠁꠐ ꠛꠣꠘ꠆ꠖꠤꠀ ꠐꠣꠃꠘꠅ ꠀꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","ꠔꠦꠃ ꠄꠢꠥꠖꠣ ꠀꠞ ꠔꠣꠞ ꠜꠣꠁꠀꠁꠘ ꠁꠃꠍꠥꠚꠞ ꠛꠣꠠꠤꠔ ꠉꠦꠟꠣ, ꠁ ꠡꠝꠄ ꠔꠣꠁꠘ ꠢꠘꠅ ꠀꠍꠟꠣ। ꠔꠣꠞꠣ ꠔꠣꠘ ꠍꠣꠝꠘꠦ ꠉꠤꠀ ꠝꠣꠐꠤꠔ ꠙꠠꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","ꠁꠃꠍꠥꠚꠦ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠁꠔꠣ ꠇꠤꠔꠣ ꠇꠞꠟꠣꠄ? ꠀꠝꠤ ꠎꠦꠘ ꠢꠇꠟꠔꠣ ꠉꠘꠔꠣꠝ ꠙꠣꠞꠤ, ꠁꠔꠣ ꠔꠥꠝꠞꠣ ꠎꠣꠘ ꠘꠣ ꠘꠤ?” ");
INSERT INTO syls_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","ꠄꠢꠥꠖꠣꠄ ꠇꠁꠟ, “ꠢꠥꠎꠥꠞꠞ ꠉꠦꠍꠦ ꠀꠝꠞꠣ ꠇꠤꠔꠣ ꠇꠁꠝꠥ? ꠇꠤꠔꠣ ꠎꠥꠀꠙ ꠖꠤꠝꠥ? ꠀꠞ ꠇꠤꠟꠣ ꠀꠝꠞꠣꠞꠦ ꠛꠦ-ꠇꠍꠥꠞ ꠇꠁꠔꠣꠝ? ꠀꠟ꠆ꠟꠣꠄꠃ ꠔꠣꠘ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠞ ꠖꠥꠡ ꠖꠦꠈꠣꠁ ꠖꠤꠍꠂꠘ, ꠔꠦ ꠎꠣꠞ ꠉꠦꠍꠦ ꠁ ꠛꠣꠐꠤ ꠝꠤꠟꠍꠦ, ꠢꠦ ꠀꠞ ꠀꠝꠞꠣ ꠢꠇꠟꠦꠃ ꠢꠥꠎꠥꠞꠞ ꠉꠥꠟꠣꠝ ꠅꠁꠟꠣꠝ।” ");
INSERT INTO syls_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","ꠅꠁꠟꠦ ꠁꠃꠍꠥꠚꠦ ꠇꠁꠟꠣ, “ꠘꠣ, ꠘꠣ, ꠀꠝꠤ ꠁ ꠇꠣꠝ ꠇꠥꠘꠥ ꠟꠣꠈꠣꠘꠃ ꠇꠞꠔꠣꠝ ꠘꠣꠄ। ꠎꠣꠞ ꠉꠦꠍꠦ ꠅꠃ ꠛꠣꠐꠤ ꠝꠤꠟꠍꠦ, ꠢꠦ-ꠃ ꠀꠝꠣꠞ ꠉꠥꠟꠣꠝ ꠅꠁꠛ, ꠛꠣꠇꠤ ꠡꠛ ꠍꠢꠤ-ꠍꠣꠟꠣꠝꠔꠦ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠚꠞ ꠉꠦꠍꠦ ꠎꠣꠅꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","ꠔꠦꠃ ꠄꠢꠥꠖꠣꠄ ꠁꠃꠍꠥꠚꠞ ꠇꠣꠍꠣꠔ ꠉꠤꠀ ꠇꠁꠟ, “ꠢꠥꠎꠥꠞ ꠀꠙꠘꠦ ꠔ ꠚꠦꠞꠣꠃꠘꠞ ꠢꠝꠣꠘ, ꠔꠦ ꠖꠄꠀ ꠇꠞꠤ ꠀꠙꠘꠣꠞ ꠉꠥꠟꠣꠝꠞꠦ ꠄꠇꠈꠣꠘ ꠝꠣꠔ ꠝꠣꠔꠣꠞ ꠡꠥꠎꠥꠉ ꠖꠦꠃꠇ꠆ꠇꠣ। ꠀꠙꠘꠣꠞ ꠉꠥꠟꠣꠝꠞ ꠃꠙꠞꠦ ꠉꠥꠍꠣ ꠅꠁꠘ ꠘꠣ ꠎꠦꠘ। ");
INSERT INTO syls_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","ꠢꠥꠎꠥꠞꠦ ꠀꠉꠦ ꠁ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠞꠦ ꠎꠤꠇꠣꠁꠍꠟꠣ, ꠔꠥꠝꠞꠣꠞ ꠛꠣꠚ ꠛꠣ ꠇꠥꠘꠥ ꠜꠣꠁ ꠀꠍꠂꠘ ꠘꠤ। ");
INSERT INTO syls_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","ꠀꠝꠞꠣ ꠎꠥꠀꠙ ꠖꠤꠍꠟꠣꠝ, ꠀꠝꠞꠣꠞ ꠝꠥꠞꠛ꠆ꠛꠤ ꠛꠣꠛꠣ ꠎꠤꠘ꠆ꠖꠣ ꠀꠍꠂꠘ, ꠀꠞ ꠔꠣꠘ ꠢꠦꠡꠇꠣꠟꠤ ꠛꠄꠅꠡꠞ ꠄꠉꠥ ꠙꠥꠀ ꠀꠍꠦ। ꠔꠣꠞ ꠜꠣꠁ ꠝꠞꠤꠉꠦꠍꠦ, ꠀꠞ ꠢꠦ ꠄꠇ ꠝꠣʼꠞ ꠄꠇ ꠙꠥꠔ ꠉꠔꠤꠇꠦ ꠛꠣꠛꠣꠄ ꠔꠣꠞꠦ ꠈꠥꠛ ꠝꠣꠄꠀ ꠇꠞꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","ꠛꠣꠖꠦ ꠀꠙꠘꠣꠞ ꠁ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠞꠦ ꠇꠁꠍꠟꠣ, ꠔꠣꠞꠦ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠟꠁꠀ ꠀꠁꠅ, ꠀꠝꠤ ꠔꠣꠞꠦ ꠘꠤꠎꠞ ꠌꠃꠈꠦ ꠖꠦꠈꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ꠢꠤ ꠡꠝꠄ ꠀꠝꠞꠣ ꠢꠥꠎꠥꠞꠞꠦ ꠇꠁꠍꠟꠣꠝ, ꠛꠣꠛꠣꠞꠦ ꠕꠁꠀ ꠢꠦ ꠀꠁꠔ ꠙꠣꠞꠔ ꠘꠣꠄ ꠀꠞ ꠕꠁꠀ ꠀꠁꠟꠦꠅ ꠛꠣꠛꠣ ꠝꠣꠞꠣ ꠎꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ꠅꠁꠟꠦ ꠀꠙꠘꠦ ꠁ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠞꠦ ꠇꠁꠍꠟꠣ, ꠔꠥꠝꠞꠣꠞ ꠢꠥꠞꠥ ꠜꠣꠁꠞꠦ ꠟꠉꠦ ꠘꠣ ꠀꠘꠟꠦ, ꠔꠥꠝꠞꠣ ꠀꠞ ꠀꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠀꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","ꠄꠞꠟꠣꠉꠤ ꠀꠝꠞꠣ ꠚꠤꠞꠤꠀ ꠉꠤꠀ ꠀꠙꠘꠣꠞ ꠉꠥꠟꠣꠝ, ꠀꠝꠞꠣꠞ ꠛꠣꠛꠣꠞꠦ ꠢꠥꠎꠥꠞꠞ ꠢꠇꠟ ꠇꠕꠣ ꠢꠥꠘꠣꠁꠍꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","ꠛꠣꠖꠦ ꠛꠣꠛꠣꠄ ꠇꠁꠟꠣ, ꠔꠥꠝꠞꠣ ꠢꠤꠞꠛꠣꠞ ꠉꠤꠀ ꠀꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠀꠞꠅ ꠕꠥꠠꠣ ꠗꠣꠘ ꠟꠁꠀ ꠀꠘꠅꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ꠔꠦꠃ ꠀꠝꠞꠣ ꠇꠁꠟꠣꠝ, ꠀꠝꠞꠣꠞ ꠢꠥꠞꠥ ꠜꠣꠁꠞꠦ ꠟꠉꠦ ꠖꠤꠟꠦ ꠀꠝꠞꠣ ꠎꠣꠁꠝꠥ, ꠀꠞꠘꠣꠄ ꠀꠝꠞꠣ ꠉꠤꠀ ꠢꠤ ꠝꠣꠘꠡꠞ ꠍꠣꠝꠘꠦ ꠝꠥꠈ ꠖꠦꠈꠣꠁꠔꠣꠝ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","ꠅꠃ ꠀꠙꠘꠣꠞ ꠉꠥꠟꠣꠝ, ꠀꠝꠞꠣꠞ ꠛꠣꠛꠣꠄ ꠇꠁꠟꠣ, ꠔꠥꠝꠞꠣ ꠔ ꠎꠣꠘ, ꠀꠝꠣꠞ ꠁ ꠛꠤꠛꠤꠞ ꠔꠞꠚꠣ ꠖꠥꠉꠥ ꠙꠥꠀ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","ꠄꠞꠣꠞ ꠄꠇꠎꠘ ꠀꠝꠣꠞ ꠌꠈꠥꠞ ꠍꠣꠝꠘ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁꠀ ꠉꠦꠟ, ꠀꠞ ꠔ ꠇꠥꠘꠥꠖꠤꠘ ꠔꠣꠞꠦ ꠖꠦꠈꠟꠣꠝ ꠘꠣ, ꠀꠝꠤ ꠛꠥꠎꠟꠣꠝ ꠎꠦꠘ, ꠘꠤꠌꠄ ꠇꠥꠘꠥ ꠎꠣꠘꠥꠀꠞꠦ ꠔꠣꠞꠦ ꠍꠤꠠꠤ-ꠛꠤꠠꠤꠟꠣꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","ꠅꠈꠘ ꠔꠥꠝꠞꠣ ꠄꠞꠦꠅ ꠀꠝꠣꠞ ꠉꠦꠍ ꠕꠘꠦ ꠘꠤꠟꠦꠉꠤ ꠀꠞ ꠄꠞ ꠇꠥꠘꠥ ꠈꠦꠔꠤ ꠅꠁꠟꠦ, ꠔꠣꠞ ꠖꠥꠈꠦ ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞꠦ ꠅꠃ ꠙꠣꠇꠘꠣ ꠌꠥꠟꠦ ꠇꠄꠛꠞꠅ ꠢꠣꠞꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","ꠄꠞꠟꠣꠉꠤ ꠅꠈꠘ ꠎꠥꠖꠤ ꠀꠙꠘꠣꠞ ꠉꠥꠟꠣꠝ, ꠀꠝꠣꠞ ꠛꠣꠛꠣꠞ ꠉꠦꠍꠦ ꠀꠝꠤ ꠎꠣꠁ ꠀꠞ ꠔꠣꠘ ꠁ ꠙꠥꠀꠞꠦ ꠟꠉꠦ ꠘꠣ ꠖꠦꠈꠂꠘ, ꠔꠦ ꠄꠞ ꠎꠣꠘꠞ ꠟꠉꠦ ꠔꠣꠘ ꠎꠣꠘ ꠄꠇꠈꠣꠘꠅ ꠛꠣꠘ꠆ꠖꠣ ꠉꠔꠤꠇꠦ, ");
INSERT INTO syls_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ꠔꠣꠞꠦ ꠘꠣ ꠖꠦꠈꠟꠦ, ꠔꠣꠁꠘ ꠘꠤꠌꠄ ꠝꠣꠞꠣ ꠎꠣꠁꠛꠣ। ꠀꠙꠘꠣꠞ ꠉꠥꠟꠣꠝ, ꠀꠝꠞꠣꠞ ꠝꠥꠞꠛ꠆ꠛꠤ ꠛꠣꠚ ꠛꠃꠔ ꠖꠥꠈꠦ ꠙꠣꠇꠘꠣ ꠌꠥꠟ ꠟꠁꠀ ꠇꠄꠛꠞꠅ ꠢꠣꠝꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","ꠀꠞ ꠀꠙꠘꠣꠞ ꠉꠥꠟꠣꠝ ꠀꠝꠤ, ꠀꠝꠣꠞ ꠛꠣꠛꠣꠞ ꠉꠦꠍꠦ ꠔꠣꠞ ꠟꠣꠉꠤ ꠎꠣꠝꠤꠘ ꠅꠁꠀ ꠇꠁꠍꠤ ꠎꠦꠘ, ꠔꠣꠞꠦ ꠚꠤꠞꠣꠁꠀ ꠀꠘꠔꠦ ꠘꠣ ꠙꠣꠞꠟꠦ, ꠢꠣꠞꠣ ꠎꠤꠘ꠆ꠖꠦꠉꠤ ꠜꠞꠣ ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠉꠦꠍꠦ ꠖꠣꠛꠤꠔ ꠞꠁꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","ꠔꠦ ꠢꠥꠎꠥꠞ ꠀꠝꠤ ꠝꠤꠘꠔꠤ ꠇꠞꠤꠀꠞ, ꠔꠣꠞ ꠛꠖꠟꠣ ꠀꠝꠤ ꠀꠙꠘꠣꠞ ꠉꠥꠟꠣꠝꠤ ꠇꠞꠝꠥ ꠀꠞ ꠔꠣꠞꠦ ꠀꠙꠘꠦ ꠄꠞꠣꠞ ꠟꠉꠦ ꠎꠣꠁꠛꠣꠞ ꠖꠤꠟꠣꠃꠇ꠆ꠇꠣ। ");
INSERT INTO syls_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","ꠄꠞꠦ ꠟꠉꠦ ꠘꠣ ꠘꠤꠀ ꠀꠝꠤ ꠇꠤꠟꠣ ꠛꠣꠛꠣꠞ ꠉꠦꠍꠦ ꠎꠣꠁꠝꠥ? ꠘꠣꠁꠟꠦ ꠛꠣꠛꠣꠞ ꠎꠣꠘꠞ ꠡꠞ꠆ꠛꠘꠣꠡ ꠀꠝꠣꠞ ꠘꠤꠎꠞ ꠌꠃꠈꠦ ꠖꠦꠈꠘ ꠟꠣꠉꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","ꠁꠃꠍꠥꠚꠦ ꠔꠣꠘ ꠇꠞ꠆ꠝꠌꠣꠞꠤ ꠅꠇꠟꠞ ꠍꠣꠝꠘꠦ ꠘꠤꠎꠞꠦ ꠀꠞ ꠑꠤꠇ ꠞꠣꠈꠔꠣ ꠙꠣꠞꠟꠣ ꠘꠣ, ꠔꠣꠁꠘ ꠌꠤꠟ꠆ꠟꠣꠁꠀ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠉꠦꠍ ꠕꠘꠦ ꠢꠇ꠆ꠇꠟ ꠢꠞꠤ ꠎꠣꠅ!” ꠔꠦꠃ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞ ꠉꠦꠍꠦ ꠘꠤꠎꠞ ꠙꠞꠤꠌꠄ ꠖꠦꠅꠀꠞ ꠡꠝꠄ ꠔꠣꠘ ꠍꠣꠝꠘꠦ ꠀꠞ ꠇꠦꠃ ꠞꠁꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","ꠔꠣꠁꠘ ꠌꠤꠟ꠆ꠟꠣꠁꠀ ꠇꠣꠘ꠆ꠖꠘ ꠡꠥꠞꠥ ꠇꠞꠟꠣ, ꠔꠦꠃ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠦ ꠁꠔꠣ ꠢꠥꠘꠟꠣ ꠀꠞ ꠚꠦꠞꠣꠃꠘꠞ ꠛꠣꠠꠤꠞ ꠝꠣꠘꠡꠦꠅ ꠁ ꠈꠛꠞ ꠙꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","ꠁꠃꠍꠥꠚꠦ ꠔꠣꠘ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠁꠃꠍꠥꠚ; ꠀꠝꠣꠞ ꠛꠣꠛꠣ ꠅꠈꠘꠅ ꠎꠤꠘ꠆ꠖꠣ ꠀꠍꠂꠘ ꠘꠤ?” ꠅꠃ ꠔꠣꠘ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠦ ꠒꠞꠣꠁꠀ ꠎꠛꠣꠘ ꠛꠘ꠆ꠖ ꠅꠁꠉꠦꠟ, ꠝꠣꠔꠔꠣ ꠙꠣꠞꠟꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","ꠔꠦꠃ ꠁꠃꠍꠥꠚꠦ ꠔꠣꠘ ꠜꠣꠁꠀꠁꠘꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠇꠣꠍꠣꠔ ꠀꠅ।” ꠔꠣꠞꠣ ꠇꠣꠍꠣꠔ ꠀꠁꠟꠦ ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠢꠃ ꠜꠣꠁ ꠁꠃꠍꠥꠚ, ꠝꠤꠡꠞꠅ ꠎꠣꠅꠞꠣ ꠛꠦꠙꠣꠞꠤ ꠅꠇꠟꠞ ꠉꠦꠍꠦ, ꠔꠥꠝꠞꠣ ꠎꠣꠞꠦ ꠛꠦꠌꠤꠟꠣꠁꠍꠟꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞꠦ ꠛꠦꠌꠤꠍꠟꠣꠄ ꠇꠞꠤ ꠅꠈꠘ ꠛꠦꠎꠣꠞ ꠅꠁꠅ ꠘꠣ, ꠛꠣ ꠘꠤꠎꠞ ꠃꠙꠞꠦ ꠘꠣꠞꠣꠎ ꠅꠁꠅ ꠘꠣ। ꠝꠣꠘꠡꠞ ꠎꠣꠘꠞ ꠢꠦꠚꠣꠎꠔꠞ ꠟꠣꠉꠤ, ꠀꠟ꠆ꠟꠣꠄꠃ ꠔꠥꠝꠞꠣꠞ ꠀꠉꠦ ꠀꠝꠣꠞꠦ ꠅꠘꠅ ꠙꠣꠑꠣꠁꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","ꠀꠇꠣꠟ ꠌꠟꠦꠞ ꠅꠃ ꠖꠥꠁ ꠛꠞꠍ ꠗꠞꠤ, ꠔꠦ ꠀꠞꠅ ꠙꠣꠌ ꠛꠞꠍ ꠇꠥꠘꠥ ꠈꠦꠔ-ꠈꠣꠝꠣꠞ ꠛꠣ ꠚꠡꠟ ꠚꠟꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","ꠖꠥꠘꠤꠀꠁꠔ ꠔꠥꠝꠞꠣꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠞꠦ ꠛꠣꠌꠣꠁꠀ ꠞꠣꠈꠣꠞ ꠟꠣꠉꠤ ꠀꠟ꠆ꠟꠣꠄꠃ ꠔꠣꠘ ꠇꠥꠖꠞꠔꠦ ꠔꠥꠝꠞꠣꠞ ꠀꠉꠦ ꠀꠝꠣꠞꠦ ꠙꠣꠑꠣꠁꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","ꠔꠦꠃ ꠛꠥꠎꠣ ꠎꠣꠄ ꠎꠦꠘ, ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞꠦ ꠁꠘꠅ ꠙꠣꠑꠣꠁꠍ ꠘꠣ, ꠀꠟ꠆ꠟꠣꠄꠃ ꠙꠣꠑꠣꠁꠍꠂꠘ। ꠔꠣꠁꠘ ꠀꠝꠣꠞꠦ ꠚꠦꠞꠣꠃꠘꠞ ꠛꠣꠚꠞ ꠢꠝꠣꠘꠤ ꠇꠞꠤꠀ ꠔꠣꠘ ꠙꠞꠤꠛꠣꠞꠞ ꠌꠣꠟꠇꠖꠣꠞ ꠛꠣꠘꠣꠁꠍꠂꠘ, ꠀꠞ ꠢꠣꠞꠣ ꠝꠤꠡꠞ ꠖꠦꠡ ꠡꠣꠡꠘꠞ ꠄꠈꠔꠤꠀꠞ ꠖꠤꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","ꠅꠈꠘ ꠔꠥꠝꠞꠣ ꠎꠟꠖꠤ ꠇꠞꠤ ꠛꠣꠛꠣꠞ ꠉꠦꠍꠦ ꠉꠤꠀ ꠇꠅ, ꠔꠣꠘ ꠙꠥꠀ ꠁꠃꠍꠥꠚꠦ ꠇꠁꠍꠦ, ꠀꠟ꠆ꠟꠣꠄ ꠀꠝꠣꠞꠦ ꠢꠣꠞꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠌꠣꠟꠇꠖꠣꠞ ꠛꠣꠘꠣꠁꠍꠂꠘ, ꠔꠦ ꠔꠥꠝꠤ ꠀꠞ ꠖꠦꠞꠤ ꠘꠣ ꠇꠞꠤꠀ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠀꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","ꠔꠥꠝꠤ, ꠔꠥꠝꠣꠞ ꠙꠥꠀ-ꠙꠥꠠꠤꠘ, ꠘꠣꠔꠤ-ꠙꠥꠔꠤ, ꠉꠞꠥ-ꠝꠦꠠꠣꠞ ꠙꠣꠟ ꠀꠞ ꠔꠥꠝꠣꠞ ꠎꠔꠔꠣ ꠀꠍꠦ, ꠢꠇ꠆ꠇꠟꠔꠣ ꠟꠁꠀ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠉꠥꠡꠘ ꠄꠟꠣꠇꠣꠔ ꠞꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ꠢꠘꠅ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠖꠦꠈꠣ-ꠢꠥꠘꠣ ꠇꠞꠝꠥ, ꠀꠇꠣꠟ ꠔ ꠀꠞꠅ ꠙꠣꠌ ꠛꠞꠍ ꠞꠁꠛ, ꠀꠞꠘꠣꠄ ꠔꠥꠝꠤꠔꠣꠁꠘ ꠢꠇꠟꠦ ꠁ ꠀꠇꠣꠟꠦ ꠛꠦꠢꠣꠟꠔ ꠅꠁꠎꠤꠔꠣꠄ ꠙꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","ꠀꠝꠣꠞ ꠀꠙꠘ ꠜꠣꠁ ꠛꠤꠘ-ꠁꠀꠝꠤꠘꠦ ꠀꠞ ꠔꠥꠝꠞꠣ ꠢꠇꠟꠦ ꠘꠤꠎꠞ ꠌꠃꠈꠦ ꠖꠦꠈꠞꠣꠄ ꠎꠦꠘ, ꠀꠝꠤ ꠘꠤꠎꠞ ꠝꠥꠈꠦ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠝꠣꠔꠞꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠀꠝꠣꠞ ꠎꠦꠔꠣ ꠖꠣꠙꠐ, ꠝꠣꠘ-ꠁꠎ꠆ꠎꠔ ꠖꠦꠈꠞꠣꠄ, ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠛꠣꠛꠣꠞꠦ ꠁꠔꠣ ꠇꠁꠛꠣꠄ, ꠀꠞ ꠔꠣꠘꠞꠦ ꠎꠟꠖꠤ ꠇꠞꠤ ꠅꠈꠣꠘꠅ ꠟꠁꠀ ꠀꠁꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","ꠢꠦꠡꠦ ꠁꠃꠍꠥꠚꠦ ꠔꠣꠘ ꠜꠣꠁ ꠛꠤꠘ-ꠁꠀꠝꠤꠘꠞ ꠉꠟꠣꠔ ꠀꠁꠘ꠆ꠎꠣ ꠇꠞꠤ ꠗꠞꠤꠀ ꠇꠣꠘ꠆ꠖꠘ ꠡꠥꠞꠥ ꠇꠞꠟꠣ ꠀꠞ ꠛꠤꠘ-ꠁꠀꠝꠤꠘꠦꠅ ꠉꠟꠣꠔ ꠗꠞꠤ ꠇꠣꠘ꠆ꠖꠣ-ꠇꠣꠐꠤ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","ꠛꠣꠖꠦ ꠁꠃꠍꠥꠚꠦ ꠔꠣꠘ ꠢꠇꠟ ꠜꠣꠁꠀꠁꠘꠞꠦ ꠢꠥꠋꠉꠣ ꠖꠤꠟꠣ ꠀꠞ ꠔꠣꠞꠣꠞ ꠉꠟꠣꠔ ꠗꠞꠤꠅ ꠇꠣꠘ꠆ꠖꠤꠟꠣ। ꠔꠦꠃ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠦꠅ ꠔꠣꠘ ꠟꠉꠦ ꠝꠣꠔ-ꠇꠕꠣ ꠝꠣꠔꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","ꠁꠃꠍꠥꠚꠞ ꠜꠣꠁꠀꠁꠘ ꠀꠅꠀꠞ ꠈꠛꠞ ꠚꠦꠞꠣꠃꠘꠞ ꠛꠣꠠꠤꠔ ꠙꠃꠍꠤꠟꠦ, ꠚꠦꠞꠣꠃꠘ ꠀꠞ ꠔꠣꠘ ꠇꠞ꠆ꠝꠌꠣꠞꠤ ꠅꠇꠟ ꠈꠥꠡꠤ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ꠚꠦꠞꠣꠃꠘꠦ ꠁꠃꠍꠥꠚꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠜꠣꠁꠀꠁꠘꠞꠦ ꠇꠅ ꠎꠦꠘ, ꠔꠥꠝꠞꠣ ꠉꠣꠗꠣꠞ ꠙꠤꠑꠤꠔ ꠗꠣꠘꠞ ꠛꠡ꠆ꠔꠣ ꠛꠣꠘ꠆ꠖꠤꠀ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠉꠤꠀ, ");
INSERT INTO syls_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ꠛꠣꠛꠣꠞꠦ ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠢꠇ꠆ꠇꠟꠞꠦ ꠟꠁꠀ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠀꠁꠅ। ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠝꠤꠡꠞꠞ ꠜꠣꠟꠣ ꠜꠣꠟꠣ ꠌꠤꠎ ꠅꠇꠟ ꠖꠤꠝꠥ ꠀꠞ ꠔꠥꠝꠞꠣ ꠖꠦꠡꠞ ꠢꠇꠟ ꠕꠘꠦ ꠜꠣꠟꠣ ꠎꠣꠉꠣꠅ ꠙꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","ꠀꠞ ꠔꠥꠝꠞꠣꠞꠦ ꠀꠝꠤ ꠢꠥꠇꠥꠝ ꠖꠤꠀꠞ, ꠔꠥꠝꠞꠣ ꠎꠣꠞꠎꠤꠞ ꠛꠃ, ꠙꠥꠀ-ꠙꠥꠠꠤꠘ꠆ꠔꠞ ꠟꠣꠉꠤ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠉꠣꠠꠤ ꠟꠁꠀ ꠉꠤꠀ, ꠔꠣꠞꠣꠞꠦ ꠀꠞ ꠛꠣꠛꠣꠞꠦ ꠟꠁꠀ ꠀꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","ꠀꠞ ꠢꠘꠅ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣꠞ ꠟꠣꠉꠤ ꠝꠣꠄꠀ ꠖꠦꠈꠣꠁꠅ ꠘꠣ, ꠢꠣꠞꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠜꠣꠟꠣ ꠜꠣꠟꠣ ꠌꠤꠎ ꠅꠇꠟ ꠔ ꠔꠥꠝꠞꠣꠞꠃ।” ");
INSERT INTO syls_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","ꠁꠍꠞꠣꠁꠟꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠅꠃꠟꠣꠃ ꠇꠞꠟꠣ। ꠚꠦꠞꠣꠃꠘꠞ ꠢꠥꠇꠥꠝꠦ ꠁꠃꠍꠥꠚꠦ ꠔꠣꠞꠣꠞ ꠟꠣꠉꠤ ꠉꠣꠠꠤ ꠀꠞ ꠙꠕꠞ ꠈꠣꠘꠤꠞ ꠝꠍꠣ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","ꠔꠣꠁꠘ ꠄꠞꠣ ꠢꠇ꠆ꠇꠟꠞꠦ ꠄꠇ ꠡꠦꠐ ꠇꠞꠤꠀ ꠇꠣꠙꠠ ꠖꠤꠟꠣ, ꠅꠁꠟꠦ ꠛꠤꠘ-ꠁꠀꠝꠤꠘꠞꠦ ꠖꠤꠟꠣ ꠙꠣꠌ ꠡꠦꠐ ꠇꠣꠙꠠ ꠀꠞ ꠔꠤꠘ-ꠡ ꠞꠥꠙꠣꠞ ꠐꠦꠇꠣ। ");
INSERT INTO syls_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","ꠔꠣꠁꠘ ꠔꠣꠘ ꠛꠣꠚꠞ ꠟꠣꠉꠤ ꠖꠡꠉꠥ ꠉꠣꠗꠣꠞ ꠙꠤꠑꠤꠔ ꠇꠞꠤ ꠝꠤꠡꠞꠞ ꠜꠣꠟꠣ ꠜꠣꠟꠣ ꠌꠤꠎ ꠅꠇꠟ, ꠀꠞ ꠖꠡꠉꠥ ꠉꠣꠗꠤꠞ ꠙꠤꠑꠤꠔ ꠇꠞꠤ ꠈꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠞꠥꠐꠤ ꠀꠞ ꠗꠣꠘ ꠛꠥꠏꠣꠁ ꠇꠞꠤ ꠙꠣꠑꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","ꠅꠃ ꠟꠣꠈꠣꠘ ꠔꠣꠘ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞꠦ ꠛꠤꠖꠣꠄ ꠖꠤꠟꠣ, ꠛꠤꠖꠣꠄ ꠛꠣꠟꠣ ꠔꠣꠁꠘ ꠄꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠙꠕꠅ ꠟꠣꠉꠣ-ꠟꠣꠉꠤ ꠇꠞꠤꠅ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","ꠛꠣꠖꠦ ꠔꠣꠞꠣ ꠝꠤꠡꠞ ꠕꠘꠦ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ, ꠔꠣꠞꠣꠞ ꠛꠣꠚ ꠁꠀꠇꠥꠛꠞ ꠉꠦꠍꠦ ꠉꠤꠀ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","“ꠁꠃꠍꠥꠚ ꠅꠈꠘꠅ ꠎꠤꠘ꠆ꠖꠣ ꠀꠍꠦ। ꠢꠦ ꠔ ꠅꠈꠘ ꠀꠡ꠆ꠔꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠅꠞ꠆ꠔꠣꠇꠞ꠆ꠔꠣ।” ꠅꠁꠟꠦ ꠁꠔꠣ ꠢꠥꠘꠤꠀ ꠁꠀꠇꠥꠛꠞ ꠢꠥꠡ ꠃꠠꠤ ꠉꠦꠟ, ꠔꠣꠘ ꠛꠤꠡ꠆ꠛꠣꠡꠃ ꠅꠁꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","ꠛꠣꠖꠦ ꠁꠃꠍꠥꠚꠦ ꠔꠣꠞꠣꠞꠦ ꠎꠦꠔꠣ ꠇꠁꠀ ꠖꠤꠍꠟꠣ ꠁꠔꠣ ꠢꠥꠘꠤꠀ, ꠀꠞ ꠔꠣꠘꠦ ꠘꠦꠅꠀꠞ ꠟꠣꠉꠤ ꠁꠃꠍꠥꠚꠞ ꠙꠣꠑꠣꠁꠟ ꠉꠣꠠꠤꠘ ꠖꠦꠈꠤꠀ, ꠔꠣꠞꠣꠞ ꠛꠣꠚ ꠁꠀꠇꠥꠛꠞ ꠢꠥꠡ ꠑꠤꠇ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ꠁꠍꠞꠣꠁꠟꠦ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠙꠥꠀ ꠁꠃꠍꠥꠚ ꠎꠦꠘ ꠅꠈꠘꠅ ꠎꠤꠔꠣ ꠀꠍꠦ, ꠅꠐꠣꠃ ꠔ ꠛꠃꠔ, ꠝꠞꠣꠞ ꠀꠉꠦ ꠀꠝꠤ ꠉꠤꠀ ꠔꠣꠞꠦ ꠖꠦꠈꠣꠃ ꠟꠣꠉꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","ꠁꠍꠞꠣꠁꠟꠦ ꠔꠣꠘ ꠢꠇ꠆ꠇꠟꠔꠣ ꠟꠁꠀ ꠛꠣꠞ ꠅꠁꠉꠦꠟꠣ। ꠀꠞ ꠛꠦꠞ-ꠡꠦꠛꠣꠔ ꠀꠁꠀ ꠔꠣꠘ ꠛꠣꠚ ꠁꠍꠢꠣꠇꠞ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","ꠛꠣꠖꠦ ꠞꠣꠁꠔꠞ ꠛꠣꠟꠣ ꠀꠟ꠆ꠟꠣꠄ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠖꠤꠖꠣꠞ ꠖꠤꠀ ꠇꠁꠟꠣ, “ꠅ ꠁꠀꠇꠥꠛ, ꠁꠀꠇꠥꠛ!” ꠔꠣꠁꠘ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠅꠃꠘꠥ ꠀꠝꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","ꠀꠟ꠆ꠟꠣꠄ ꠚꠞꠝꠣꠁꠟꠣ, “ꠀꠝꠤ ꠀꠟ꠆ꠟꠣ, ꠔꠥꠝꠣꠞ ꠛꠣꠚꠞ ꠝꠣꠛꠥꠖ। ꠔꠥꠝꠤ ꠝꠤꠡꠞꠅ ꠎꠣꠁꠔꠦ ꠒꠞꠣꠁꠅ ꠘꠣ, ꠢꠘꠅ ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠄꠇ ꠛꠤꠞꠣꠐ ꠎꠣꠔꠤ ꠙꠄꠖꠣ ꠇꠞꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠟꠉꠦ ꠝꠤꠡꠞꠅ ꠎꠣꠁꠝꠥ, ꠀꠞ ꠀꠝꠤꠃ ꠔꠥꠝꠣꠞꠦ ꠢꠤꠞꠛꠣꠞ ꠚꠤꠞꠣꠁꠀ ꠀꠘꠝꠥ ꠀꠞ ꠔꠥꠝꠣꠞ ꠙꠥꠀ ꠁꠃꠍꠥꠚꠦ ꠔꠥꠝꠣꠞ ꠌꠃꠈ ꠝꠥꠎꠣꠁꠀ ꠖꠤꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ꠛꠣꠖꠦ ꠁꠀꠇꠥꠛꠦ ꠛꠦꠞ-ꠡꠦꠛꠣ ꠕꠣꠇꠤ ꠞꠅꠀꠘꠣ ꠅꠁꠟꠣ। ꠚꠦꠞꠣꠃꠘꠦ ꠔꠣꠞꠣꠞꠦ ꠘꠦꠅꠀꠞ ꠟꠣꠉꠤ ꠎꠦꠔꠣ ꠉꠣꠠꠤꠘ ꠖꠤꠍꠟꠣ, ꠁꠍꠞꠣꠁꠟꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠅꠔꠣꠔ ꠇꠞꠤ ꠔꠣꠞꠣꠞ ꠛꠣꠚꠞꠦ ꠀꠞ ꠔꠣꠞꠣꠞ ꠛꠃ, ꠙꠥꠀ-ꠙꠥꠠꠤꠘꠞꠦ ꠟꠁꠀ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","ꠢꠦꠡꠦ ꠁꠀꠇꠥꠛ, ꠔꠣꠘ ꠙꠥꠀꠂꠘ ꠀꠞ ꠔꠣꠘ ꠙꠥꠞꠣ ꠉꠥꠡ꠆ꠐꠤ, ꠙꠡꠥꠞ ꠙꠣꠟ ꠅꠇꠟ ꠀꠞ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠇꠣꠝꠣꠁ ꠇꠞꠣ ꠢꠇ꠆ꠇꠟ ꠗꠘ-ꠖꠃꠟꠔ ꠟꠁꠀ ꠝꠤꠡꠞꠅ ꠙꠃꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","ꠅꠃ ꠟꠣꠈꠣꠘ ꠁꠀꠇꠥꠛꠦ ꠔꠣꠘ ꠙꠥꠀ-ꠙꠥꠠꠤꠘ, ꠘꠣꠔꠤ-ꠘꠣꠔꠤꠘ, ꠙꠥꠞꠣ ꠉꠥꠡ꠆ꠐꠤꠞ ꠢꠇ꠆ꠇꠟꠞꠦ ꠟꠁꠀ ꠝꠤꠡꠞꠅ ꠙꠣꠞ ꠅꠁꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ, ꠝꠣꠘꠤ ꠁꠀꠇꠥꠛ ꠀꠞ ꠔꠣꠘ ꠀꠅꠟꠣꠖ ꠅꠇꠟ ꠎꠦꠞꠣ ꠝꠤꠡꠞꠅ ꠉꠦꠍꠟꠣ, ꠔꠣꠞꠣꠞ ꠈꠣꠘ꠆ꠖꠣꠘ-ꠘꠣꠝꠣ ꠅꠁꠟ: ꠁꠀꠇꠥꠛꠞ ꠛꠠ ꠙꠥꠀ ꠞꠥꠛꠦꠘ; ");
INSERT INTO syls_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ꠀꠞ ꠞꠥꠛꠦꠘꠞ ꠙꠥꠀꠂꠘ: ꠢꠘꠥꠇ, ꠚꠣꠟꠥ, ꠢꠣꠍꠤꠞ ꠀꠞ ꠇꠞ꠆ꠝꠤ। ");
INSERT INTO syls_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","ꠡꠤꠝꠤꠅꠘꠞ ꠙꠥꠀꠂꠘ: ꠎꠤꠝꠥꠄꠟ, ꠎꠣꠝꠤꠘ, ꠅꠢꠖ, ꠎꠣꠈꠤꠘ, ꠡꠥꠢꠞ, ꠀꠞ ꠇꠦꠘꠣꠘꠤ ꠛꠃꠞ ꠔꠞꠚꠣ ꠡꠃꠟ। ");
INSERT INTO syls_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","ꠟꠦꠛꠤꠞ ꠙꠥꠀꠂꠘ: ꠎꠣꠞꠍꠥꠘ, ꠇꠣꠢꠣꠔ ꠀꠞ ꠝꠣꠞꠣꠞꠤ। ");
INSERT INTO syls_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","ꠄꠢꠥꠖꠣꠞ ꠙꠥꠀꠂꠘ: ꠄꠁꠞ, ꠅꠘꠘ, ꠡꠦꠟꠣ, ꠚꠤꠞꠥꠎ ꠀꠞ ꠎꠣꠞꠣꠢ। ꠅꠁꠟꠦ ꠅꠘꠘ ꠀꠞ ꠄꠁꠞ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅꠃ ꠝꠞꠤ ꠉꠦꠍꠟꠣ। ꠚꠤꠞꠥꠎꠞ ꠙꠥꠀꠂꠘ: ꠢꠣꠍꠤꠞ ꠀꠞ ꠢꠣꠝꠥꠟ। ");
INSERT INTO syls_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ꠁꠍꠣꠈꠞꠞ ꠙꠥꠀꠂꠘ: ꠔꠟꠣ, ꠚꠅꠀ, ꠎꠣꠡꠥꠛ ꠀꠞ ꠡꠤꠝꠞꠘ। ");
INSERT INTO syls_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","ꠍꠛꠥꠟꠘꠞ ꠙꠥꠀꠂꠘ: ꠍꠦꠞꠦꠖ, ꠄꠟꠘ ꠀꠞ ꠎꠢꠟꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","ꠔꠣꠞꠣ ꠅꠁꠟꠣ ꠟꠦꠀꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ, ꠙꠖ꠆ꠖꠘ-ꠁꠞꠣꠝꠅ ꠟꠦꠀꠞ ꠔꠞꠚꠣ ꠁꠀꠇꠥꠛꠞ ꠁ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ ꠀꠞ ꠔꠣꠘ ꠙꠥꠠꠤ ꠖꠤꠘꠣꠞ ꠎꠘꠝ ꠅꠁꠍꠤꠟ, ꠄꠞꠣ ꠢꠇ꠆ꠇꠟꠔꠣꠄ ꠔꠦꠔ꠆ꠞꠤꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","ꠍꠣꠖꠥꠞ ꠙꠥꠀꠂꠘ ꠅꠁꠟꠣ: ꠍꠤꠚꠘ, ꠢꠉꠤ, ꠡꠥꠘꠤ, ꠁꠡꠛꠥꠘ, ꠄꠁꠞꠤ, ꠅꠞꠥꠖꠤ ꠀꠞ ꠅꠞꠦꠟꠤ। ");
INSERT INTO syls_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","ꠀꠡꠤꠞꠞ ꠙꠥꠀꠂꠘ: ꠁꠝꠘꠣ, ꠎꠤꠍꠛꠣ, ꠎꠤꠍꠛꠤ, ꠛꠞꠤꠀ ꠀꠞ ꠔꠣꠞꠣꠞ ꠛꠁꠘ ꠍꠦꠞꠣ। ꠛꠞꠤꠀꠞ ꠙꠥꠀꠂꠘ: ꠢꠦꠛꠞ ꠀꠞ ꠝꠟꠇꠤꠄꠟ। ");
INSERT INTO syls_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","ꠔꠣꠞꠣ ꠅꠁꠟꠣ ꠎꠤꠟꠙꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ, ꠟꠣꠛꠘꠦ ꠔꠣꠘ ꠙꠥꠠꠤ ꠟꠦꠀꠞ ꠟꠉꠦ ꠅꠃ ꠛꠣꠘ꠆ꠖꠤ ꠎꠤꠟꠙꠣꠞꠦ ꠖꠤꠍꠟꠣ, ꠄꠞꠣ ꠢꠇꠟꠃ ꠔꠣꠁꠞ ꠔꠞꠚꠣ ꠁꠀꠇꠥꠛꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ, ꠅꠃ ꠡꠥꠟ꠆ꠟ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","ꠁꠀꠇꠥꠛꠞ ꠛꠤꠛꠤ ꠞꠣꠢꠦꠟꠣꠞ ꠙꠥꠀꠂꠘ ꠅꠁꠟꠣ: ꠁꠃꠍꠥꠚ ꠀꠞ ꠛꠤꠘ-ꠁꠀꠝꠤꠘ। ");
INSERT INTO syls_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","ꠁꠃꠍꠥꠚꠞ ꠙꠥꠀꠂꠘ ꠝꠣꠘꠡꠣ ꠀꠞ ꠀꠚꠞꠣꠁꠝ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠎꠘꠝꠤꠍꠟꠣ। ꠄꠞꠣꠞ ꠝꠣ ꠅꠁꠟꠣ ꠅꠃꠘ ꠝꠘ꠆ꠖꠤꠞꠞ ꠛꠣꠛꠘ-ꠑꠣꠇꠥꠞ, ꠙꠥꠐꠤꠚꠦꠞꠣꠞ ꠙꠥꠠꠤ ꠀꠡꠘꠔ। ");
INSERT INTO syls_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","ꠛꠤꠘ-ꠁꠀꠝꠤꠘꠞ ꠙꠥꠀꠂꠘ: ꠛꠦꠟꠣ, ꠛꠦꠈꠞ, ꠅꠡꠛꠦꠟ, ꠉꠦꠞꠣ, ꠘꠣꠝꠣꠘ, ꠄꠢꠤ, ꠞꠥꠡ, ꠝꠥꠙ꠆ꠙꠤꠝ, ꠢꠥꠙ꠆ꠙꠤꠝ ꠀꠞ ꠅꠞ꠆ꠖ। ");
INSERT INTO syls_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","ꠔꠣꠞꠣ ꠅꠁꠟꠣ ꠞꠣꠢꠦꠟꠣꠞ ꠔꠞꠚꠣ ꠁꠀꠇꠥꠛꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ, ꠅꠃ ꠌꠃꠖ꠆ꠖ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","ꠖꠣꠘꠞ ꠙꠥꠀ: ꠢꠥꠡꠤꠝ। ");
INSERT INTO syls_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","ꠘꠙ꠆ꠔꠣꠟꠤꠞ ꠙꠥꠀꠂꠘ: ꠎꠢꠡꠤꠄꠟ, ꠉꠥꠘꠤ, ꠁꠎꠦꠞ ꠀꠞ ꠡꠤꠟ꠆ꠟꠦꠝ। ");
INSERT INTO syls_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","ꠔꠣꠞꠣ ꠅꠁꠟꠣ ꠛꠤꠟꠢꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ, ꠟꠣꠛꠘꠦ ꠔꠣꠘ ꠙꠥꠠꠤ ꠞꠣꠢꠦꠟꠣꠞ ꠟꠉꠦ ꠅꠃ ꠛꠣꠘ꠆ꠖꠤ ꠛꠤꠟꠢꠣꠞꠦ ꠖꠤꠍꠟꠣ। ꠄꠞꠣ ꠢꠇꠟꠃ ꠔꠣꠁꠞ ꠔꠞꠚꠣ ꠁꠀꠇꠥꠛꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ, ꠅꠃ ꠡꠣꠔ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","ꠁꠀꠇꠥꠛꠞ ꠘꠣꠘꠣꠘ ꠔꠞꠚꠣꠞ ꠎꠘꠝꠞ ꠎꠣꠞꠣ ꠝꠤꠡꠞꠅ ꠀꠁꠟꠣ, ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠛꠃ ꠛꠣꠖ ꠖꠤꠀ ꠄꠞꠣ ꠢꠇꠟꠦ ꠝꠤꠟꠤꠀ ꠍꠄꠡꠐ꠆ꠐꠤ ꠎꠘ ꠀꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠁꠃꠍꠥꠚꠞ ꠖꠥꠁꠎꠘ ꠙꠥꠀ ꠎꠘꠝꠤꠍꠟꠣ। ꠄꠞꠣ ꠡꠢ ꠁꠀꠇꠥꠛꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠎꠣꠞꠣ ꠝꠤꠡꠞꠅ ꠀꠁꠟꠣ, ꠔꠣꠞꠣ ꠝꠥꠐ ꠡꠔ꠆ꠔꠁꠞ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ꠄꠞ ꠀꠉꠦ ꠁꠀꠇꠥꠛꠦ ꠄꠢꠥꠖꠣꠞꠦ ꠁꠃꠍꠥꠚꠞ ꠉꠦꠍꠦ ꠙꠣꠑꠣꠁꠟꠣ, ꠉꠥꠡꠘꠅ ꠎꠣꠅꠀꠞ ꠙꠕ ꠌꠤꠘꠣꠞ ꠟꠣꠉꠤ, ꠔꠦꠃ ꠔꠣꠞꠣ ꠢꠇ꠆ꠇꠟ ꠅꠘꠅ ꠉꠤꠀ ꠙꠃꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","ꠀꠞ ꠁꠃꠍꠥꠚꠦꠅ ꠊꠥꠠꠣꠞ ꠉꠣꠠꠤ ꠢꠣꠎꠣꠁꠀ ꠔꠣꠘ ꠛꠣꠚ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠉꠦ ꠉꠥꠡꠘꠅ ꠖꠦꠈꠣ ꠇꠞꠣꠔ ꠉꠦꠟꠣ, ꠀꠞ ꠔꠣꠘꠞꠦ ꠖꠦꠈꠤꠀꠃ ꠀꠁꠘ꠆ꠎꠣ ꠇꠞꠤ ꠉꠟꠣꠔ ꠗꠞꠤꠀ ꠛꠃꠔ ꠡꠝꠄ ꠇꠣꠘ꠆ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ꠔꠦꠃ ꠁꠍꠞꠣꠁꠟꠦ ꠁꠃꠍꠥꠚꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠎꠦꠘ ꠎꠤꠘ꠆ꠖꠣ ꠀꠍ ꠞꠦ ꠙꠥꠔ, ꠁꠐꠣ ꠘꠤꠎꠞ ꠌꠃꠈꠦ ꠖꠦꠈꠟꠣꠝ। ꠅꠈꠘ ꠡꠣꠘ꠆ꠔꠤꠄꠃ ꠝꠞꠔꠣꠝ ꠙꠣꠞꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","ꠅꠃ ꠁꠃꠍꠥꠚꠦ ꠔꠣꠘ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞꠦ ꠀꠞ ꠔꠣꠘ ꠛꠣꠚꠞ ꠟꠉꠞ ꠢꠇꠟꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠉꠤꠀ ꠚꠦꠞꠣꠃꠘꠞꠦ ꠎꠣꠘꠣꠁꠝꠥ, ꠀꠝꠣꠞ ꠜꠣꠁꠀꠁꠘ ꠀꠞ ꠀꠝꠣꠞ ꠛꠣꠚꠞ ꠛꠣꠠꠤꠞ ꠢꠇꠟ, ꠇꠦꠘꠣꠘ ꠖꠦꠡ ꠕꠘꠦ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠀꠁꠌ꠆ꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","ꠔꠣꠞꠣꠞ ꠇꠣꠝ ꠅꠁꠟ ꠙꠡꠥ ꠙꠣꠟꠣ। ꠔꠣꠞꠣ ꠔ ꠍꠣꠉꠟ-ꠝꠦꠠꠣ ꠙꠣꠟꠂꠘ, ꠀꠞ ꠔꠣꠞꠣꠞ ꠙꠡꠥꠞ ꠙꠣꠟ ꠅꠇꠟ ꠀꠞ ꠢꠇ꠆ꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠟꠁꠀ ꠀꠁꠌ꠆ꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","ꠚꠦꠞꠣꠃꠘꠦ ꠎꠦꠛꠟꠣ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠤꠇꠣꠁꠛꠣ, ꠀꠙꠘꠣꠞꠣ ꠇꠤꠔꠣ ꠇꠣꠝ ꠇꠞꠂꠘ? ");
INSERT INTO syls_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ꠅꠃ ꠡꠝꠄ ꠔꠥꠝꠞꠣ ꠇꠁꠅ, ꠀꠙꠘꠣꠞ ꠁ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠦ ꠀꠞ ꠔꠣꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣ ꠅꠇꠟꠦꠅ ꠢꠥꠞꠥꠝꠣꠘ ꠕꠘꠦꠃ ꠙꠡꠥ ꠙꠣꠟꠤꠀ ꠛꠣꠌꠂꠘ। ꠔꠦꠃ ꠔꠥꠝꠞꠣ ꠉꠥꠡꠘꠅ ꠞꠁꠔꠣꠄ ꠙꠣꠞꠛꠣꠄ। ꠇꠣꠞꠘ ꠙꠡꠥ ꠙꠣꠟꠞꠣ ꠝꠣꠘꠡꠞꠦ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠦ ꠊꠤꠘ ꠇꠞꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","ꠁꠃꠍꠥꠚꠦ ꠚꠦꠞꠣꠃꠘꠞ ꠉꠦꠍꠦ ꠉꠤꠀ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠛꠣꠛꠣ ꠀꠞ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠦ, ꠔꠣꠞꠣꠞ ꠉꠞꠥ-ꠍꠣꠉꠟ ꠀꠞ ꠔꠣꠞꠣꠞ ꠢꠇ꠆ꠇꠟꠔꠣ ꠟꠁꠀ, ꠇꠦꠘꠣꠘ ꠖꠦꠡ ꠍꠣꠠꠤꠀ ꠀꠁꠍꠂꠘ। ꠔꠣꠞꠣ ꠀꠁꠀ ꠉꠥꠡꠘꠅ ꠙꠃꠍꠤ ꠉꠦꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞ ꠝꠣꠎꠦ ꠙꠣꠌ ꠎꠘꠞꠦ ꠘꠤꠀ ꠔꠣꠁꠘ ꠚꠦꠞꠣꠃꠘꠞ ꠍꠣꠝꠘꠦ ꠀꠎꠤꠞ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ꠚꠦꠞꠣꠃꠘꠦ ꠔꠣꠞꠣꠞꠦ ꠎꠤꠇꠣꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠇꠤꠔꠣ ꠇꠣꠝ ꠇꠞꠅ?” ꠔꠣꠞꠣ ꠇꠁꠟꠣ, “ꠀꠙꠘꠣꠞ ꠁ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠦ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠀꠝꠟ ꠕꠣꠇꠤꠃ ꠙꠡꠥ ꠙꠣꠟꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","ꠔꠣꠞꠣ ꠢꠤꠞꠛꠣꠞ ꠇꠁꠟꠣ, “ꠀꠝꠞꠣ ꠁ ꠖꠦꠡꠅ ꠝꠥꠍꠣꠚꠤꠞ ꠅꠁꠀ ꠕꠣꠇꠣꠞ ꠟꠣꠉꠤ ꠀꠁꠍꠤ। ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠅꠈꠘ ꠛꠦꠎꠥꠁꠔꠣ ꠘꠤꠖꠣꠘ ꠌꠟꠦꠞ ꠇꠞꠤ, ꠢꠤꠘꠅ ꠀꠝꠞꠣꠞ ꠙꠡꠥꠞ ꠙꠣꠟꠞ ꠈꠥꠞꠣꠇꠤ ꠘꠣꠄ। ꠄꠞꠟꠣꠉꠤ ꠖꠄꠀ ꠇꠞꠤ ꠀꠙꠘꠣꠞ ꠁ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠞꠦ, ꠉꠥꠡꠘꠅ ꠞꠁꠛꠣꠞ ꠡꠥꠎꠥꠉ ꠖꠦꠃꠇ꠆ꠇꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ꠚꠦꠞꠣꠃꠘꠦ ꠁꠃꠍꠥꠚꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠛꠣꠚ-ꠜꠣꠁꠀꠁꠘ ꠔꠥꠝꠣꠞ ꠉꠦꠍꠦ ꠀꠁꠍꠂꠘ; ");
INSERT INTO syls_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ꠀꠡ꠆ꠔꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠃ ꠔ ꠔꠥꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠙꠠꠤ ꠞꠁꠍꠦ। ꠖꠦꠡꠞ ꠢꠇꠟ ꠕꠣꠇꠤ ꠜꠣꠟꠣ ꠎꠣꠉꠣꠔ ꠔꠣꠞꠣꠞꠦ ꠞꠁꠔꠦ ꠖꠦꠅ, ꠔꠣꠞꠣ ꠉꠥꠡꠘꠅꠃ ꠕꠣꠇꠃꠇ ꠀꠞ ꠄꠞꠣꠞ ꠝꠣꠎꠦ ꠎꠁꠉ꠆ꠉ ꠝꠣꠘꠥꠡ ꠙꠣꠁꠟꠦ, ꠔꠣꠞꠣꠞꠦ ꠀꠝꠣꠞ ꠙꠡꠥꠞ ꠙꠣꠟꠞ ꠌꠣꠟꠇꠖꠣꠞ ꠛꠣꠘꠣꠁꠟꠣꠅ।” ");
INSERT INTO syls_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ꠛꠣꠖꠦ ꠁꠃꠍꠥꠚꠦ ꠔꠣꠘ ꠛꠣꠚ ꠁꠀꠇꠥꠛꠞꠦ ꠚꠦꠞꠣꠃꠘꠞ ꠍꠣꠝꠘꠦ ꠀꠘꠣꠁꠟꠣ ꠀꠞ ꠁꠀꠇꠥꠛꠦ ꠚꠦꠞꠣꠃꠘꠞꠦ ꠖꠥꠀ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ꠚꠦꠞꠣꠃꠘꠦ ꠁꠀꠇꠥꠛꠞꠦ ꠎꠤꠇꠣꠁꠟꠣ, “ꠀꠙꠘꠣꠞ ꠛꠄꠅꠡ ꠇꠔ ꠅꠁꠍꠦ?” ");
INSERT INTO syls_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","ꠁꠀꠇꠥꠛꠦ ꠇꠁꠟꠣ, “ꠖꠥꠘꠤꠀꠁꠔ ꠀꠝꠣꠞ ꠝꠥꠍꠣꠚꠤꠞꠤꠞ ꠀꠄꠃ ꠄꠇ-ꠡ ꠔꠤꠡ ꠛꠞꠍ ꠅꠁꠍꠦ, ꠁꠔꠣ ꠔ ꠛꠦꠡꠤ ꠘꠣꠄ, ꠀꠞ ꠈꠥꠛ ꠔꠇꠟꠤꠚꠦꠃ ꠁ ꠖꠤꠘ ꠇꠣꠐꠍꠦ; ꠀꠝꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠝꠥꠍꠣꠚꠤꠞꠤꠞ ꠀꠄꠃꠞ ꠢꠝꠣꠘ ꠅꠈꠘꠅ ꠅꠁꠍꠦ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","ꠢꠦꠡꠦ ꠁꠀꠇꠥꠛꠦ ꠚꠦꠞꠣꠃꠘꠞꠦ ꠖꠥꠀ ꠇꠞꠤꠀ ꠛꠤꠖꠣꠄ ꠟꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","ꠔꠦꠃ ꠁꠃꠍꠥꠚꠦ ꠚꠦꠞꠣꠃꠘꠞ ꠢꠥꠇꠥꠝ ꠝꠔ, ꠔꠣꠘ ꠛꠣꠚ-ꠜꠣꠁꠀꠁꠘꠞꠦ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠢꠇꠟ ꠕꠣꠇꠤ ꠜꠣꠟꠣ ꠎꠣꠉꠣ, ꠞꠣꠝꠣꠡꠦꠡ ꠄꠟꠣꠇꠣꠔ ꠞꠁꠔꠣ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","ꠁꠃꠍꠥꠚꠦ ꠔꠣꠘ ꠛꠣꠚ-ꠜꠣꠁꠀꠁꠘ ꠀꠞ ꠔꠣꠞꠣꠞ ꠙꠞꠤꠛꠣꠞꠞꠦ ꠎꠣꠞꠎꠤꠞ ꠖꠞꠇꠣꠞꠤ, ꠈꠣꠘꠤ-ꠈꠥꠞꠣꠇꠤ ꠢꠇꠟꠔꠣ ꠎꠥꠉꠣꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","ꠛꠣꠖꠦ ꠀꠇꠣꠟ ꠀꠞꠅ ꠛꠦꠕꠣꠄꠀ ꠅꠁꠟ, ꠖꠦꠡꠞ ꠇꠥꠘꠥ ꠎꠣꠉꠣꠔ ꠈꠣꠘꠤꠞ ꠇꠥꠘ꠆ꠔꠣ ꠀꠍꠤꠟ ꠘꠣ। ꠔꠦꠃ ꠝꠤꠡꠞ ꠀꠞ ꠇꠦꠘꠣꠘ ꠖꠦꠡ ꠄꠇ꠆ꠇꠦꠛꠣꠞꠦ ꠇꠣꠢꠤꠟ ꠅꠁꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","ꠝꠤꠡꠞ ꠀꠞ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠞ ꠝꠣꠘꠡꠞ ꠎꠔ ꠐꠦꠇꠣ-ꠙꠄꠡꠣ ꠡꠥꠘꠣ-ꠞꠥꠙꠣ ꠀꠍꠤꠟ, ꠁꠔꠣꠖꠤ ꠔꠣꠞꠣ ꠗꠣꠘ ꠈꠞꠤꠖ ꠇꠞꠣꠄ, ꠁꠃꠍꠥꠚꠦ ꠅꠔꠣ ꠖꠟꠣ ꠇꠞꠤꠀ ꠚꠦꠞꠣꠃꠘꠞ ꠜꠣꠘ꠆ꠒꠣꠞꠅ ꠎꠝꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","ꠝꠤꠡꠞ ꠀꠞ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠞ ꠢꠇꠟ ꠡꠥꠘꠣ-ꠞꠥꠙꠣ ꠎꠦꠛꠟꠣ ꠚꠥꠠꠣꠁ ꠉꠦꠟ, ꠔꠦꠃ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠦ ꠀꠁꠀ ꠁꠃꠍꠥꠚꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠞꠣꠞꠦ ꠈꠣꠘꠤꠞ ꠇꠥꠘ꠆ꠔꠣ ꠖꠦꠃꠇ꠆ꠇꠣ। ꠀꠝꠞꠣꠞ ꠡꠥꠘꠣ-ꠞꠥꠙꠣ ꠚꠥꠠꠣꠁ ꠉꠦꠍꠦ ꠇꠞꠤ ꠀꠙꠘꠣꠞ ꠌꠃꠈꠞ ꠍꠣꠝꠘꠦ ꠝꠞꠤꠎꠤꠔꠣꠝ ꠘꠤ?” ");
INSERT INTO syls_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","ꠁꠃꠍꠥꠚꠦ ꠇꠁꠟꠣ, “ꠔꠣꠁꠟꠦ ꠔꠥꠝꠞꠣꠞ ꠙꠡꠥ ꠅꠇꠟ ꠀꠘꠤꠀ ꠖꠦꠅ, ꠡꠥꠘꠣ-ꠞꠥꠙꠣ ꠚꠥꠠꠣꠁ ꠉꠦꠟꠦꠅ ꠙꠡꠥ ꠅꠇꠟꠞ ꠛꠖꠟꠣ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠈꠣꠘꠤ-ꠈꠥꠞꠣꠇꠤ ꠖꠤꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","ꠔꠦꠃ ꠔꠣꠞꠣ ꠎꠣꠞꠎꠤꠞ ꠉꠞꠥ-ꠍꠣꠉꠟ, ꠊꠥꠠꠣ-ꠝꠦꠠꠣ, ꠉꠣꠗꠣ-ꠉꠣꠗꠤ ꠁꠃꠍꠥꠚꠞ ꠉꠦꠍꠦ ꠀꠘꠟꠣ ꠀꠞ ꠁꠃꠍꠥꠚꠦ ꠄꠞ ꠛꠖꠟꠣ ꠔꠣꠞꠣꠞꠦ ꠗꠣꠘ ꠖꠤꠟꠣ। ꠅꠃ ꠟꠣꠈꠣꠘ ꠔꠣꠞꠣꠞ ꠢꠇ꠆ꠇꠟ ꠙꠡꠥꠞ ꠛꠖꠟꠣ, ꠢꠤ ꠛꠍꠞꠞ ꠈꠥꠞꠣꠇꠤ ꠌꠣꠟꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","ꠀꠞ ꠢꠤ ꠛꠞꠍ ꠉꠦꠟ, ꠄꠞ ꠛꠣꠖꠞ ꠛꠞꠍ ꠝꠣꠘꠡꠦ ꠀꠁꠀ ꠁꠃꠍꠥꠚꠞꠦ ꠇꠁꠟꠣ, “ꠢꠥꠎꠥꠞꠞ ꠉꠦꠍꠦ ꠀꠝꠞꠣ ꠇꠥꠘ꠆ꠔꠣꠃ ꠟꠥꠇꠣꠁꠀꠞ ꠘꠣ, ꠀꠝꠞꠣꠞ ꠢꠇꠟ ꠡꠥꠘꠣ-ꠞꠥꠙꠣ ꠡꠦꠡ ꠅꠁꠉꠦꠍꠦ ꠀꠞ ꠙꠡꠥ ꠅꠇꠟꠅ ꠀꠙꠘꠣꠞꠦ ꠖꠤꠟꠣꠁꠍꠤ। ꠅꠈꠘ ꠀꠝꠞꠣꠞ ꠀꠞ ꠇꠥꠘ꠆ꠔꠣꠃ ꠞꠁꠍꠦ ꠘꠣ, ꠈꠣꠟꠤ ꠅꠃ ꠡꠞꠤꠟ ꠀꠞ ꠎꠣꠉꠣ-ꠎꠝꠤꠘ ꠍꠣꠠꠣ। ");
INSERT INTO syls_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ꠄꠞꠟꠣꠉꠤ ꠀꠙꠘꠣꠞ ꠌꠃꠈꠞ ꠍꠣꠝꠘꠦ ꠎꠝꠤ-ꠎꠝꠣ ꠡꠢ ꠀꠝꠞꠣ ꠇꠤꠟꠣ ꠝꠞꠤꠎꠤꠔꠣꠝ? ꠔꠦ ꠀꠙꠘꠦ ꠀꠝꠞꠣꠞꠦꠅ ꠀꠞ ꠀꠝꠞꠣꠞ ꠢꠇꠟ ꠎꠝꠤ-ꠎꠝꠣꠅ ꠟꠁꠟꠣꠃꠇ꠆ꠇꠣ, ꠀꠝꠞꠣ ꠚꠦꠞꠣꠃꠘꠞ ꠉꠥꠟꠣꠝꠤ ꠇꠞꠝꠥ, ꠔꠣ-ꠅ ꠀꠝꠞꠣꠞꠦ ꠈꠣꠘꠤ ꠖꠦꠃꠇ꠆ꠇꠣ ꠀꠞ ꠛꠤꠌ ꠖꠦꠃꠇ꠆ꠇꠣ, ꠔꠦꠃ ꠀꠝꠞꠣꠅ ꠝꠞꠣ ꠕꠘꠦ ꠛꠣꠌꠝꠥ ꠀꠞ ꠎꠝꠤꠘ ꠈꠣꠘꠣꠁꠘꠅ ꠛꠞꠛꠣꠖ ꠅꠁꠔ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","ꠅꠃ ꠁꠃꠍꠥꠚꠦ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠢꠇ꠆ꠇꠟ ꠎꠝꠤꠘ ꠚꠦꠞꠣꠃꠘꠞ ꠘꠣꠝꠦ ꠟꠁꠟꠤꠟꠣ, ꠇꠣꠞꠘ ꠁ ꠀꠇꠣꠟ ꠅꠃꠟꠣ ꠛꠦꠎꠥꠁꠔꠣ ꠅꠁꠍꠤꠟ ꠎꠦꠘ, ꠝꠤꠡꠞꠞ ꠢꠇꠟꠦꠃ ꠔꠣꠞꠣꠞ ꠎꠣꠉꠣ-ꠎꠝꠤꠘ ꠛꠦꠌꠤꠟꠣꠁꠟꠣ। ꠔꠦꠃ ꠖꠦꠡꠞ ꠢꠇꠟ ꠎꠝꠤꠘ ꠚꠦꠞꠣꠃꠘꠞ ꠀꠔꠅ ꠀꠁꠟ꠆ꠟ। ");
INSERT INTO syls_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ꠀꠞ ꠁꠃꠍꠥꠚꠦ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠄꠇ ꠝꠣꠕꠣ ꠕꠣꠇꠤ ꠀꠞꠇ ꠝꠣꠕꠣꠞ ꠢꠇꠟ ꠝꠣꠘꠡꠞꠦ ꠐꠣꠃꠘꠅ ꠙꠣꠞ ꠇꠞꠤꠟꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","ꠈꠣꠟꠤ ꠛꠣꠛꠘ ꠅꠇꠟꠞ ꠎꠣꠉꠣ-ꠎꠝꠤꠘ ꠔꠣꠁꠘ ꠟꠁꠟꠣ ꠘꠣ, ꠇꠣꠞꠘ ꠄꠞꠣꠞꠦ ꠚꠦꠞꠣꠃꠘꠦ ꠛꠦꠔꠘ ꠖꠤꠔꠣ, ꠀꠞ ꠅꠔꠣ ꠖꠤꠀꠃ ꠔꠣꠞꠣ ꠌꠟꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","ꠢꠦꠡꠦ ꠁꠃꠍꠥꠚꠦ ꠝꠣꠘꠡꠞꠦ ꠇꠁꠟꠣ, “ꠢꠥꠘꠅ, ꠚꠦꠞꠣꠃꠘꠞ ꠘꠣꠝꠦ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠢꠇꠟ ꠎꠣꠉꠣ-ꠎꠝꠤꠘꠅ ꠟꠁꠟꠤꠟꠣꠝ। ꠅꠈꠘ ꠔꠥꠝꠞꠣ ꠅꠃ ꠛꠤꠌ ꠅꠇꠟ ꠘꠦꠅ ꠀꠞ ꠎꠝꠤꠘꠅ ꠛꠣꠁꠘ ꠇꠞꠅ। ");
INSERT INTO syls_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","ꠔꠦꠃ ꠎꠝꠤꠘꠅ ꠎꠦꠔꠣ ꠚꠡꠟ ꠚꠟꠤꠛ, ꠄꠞ ꠙꠣꠌ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ ꠚꠦꠞꠣꠃꠘꠞꠦ ꠖꠤꠅ ꠀꠞ ꠛꠣꠇꠤ ꠌꠣꠁꠞ ꠛꠣꠐ, ꠎꠝꠤꠘꠞ ꠛꠤꠌ, ꠔꠥꠝꠞꠣ ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠙꠞꠤꠛꠣꠞ ꠀꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ꠆ꠔꠞ ꠈꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠘꠤꠅꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","ꠔꠦꠃ ꠝꠣꠘꠡꠦ ꠇꠁꠟꠣ, “ꠀꠙꠘꠦ ꠀꠝꠞꠣꠞ ꠎꠣꠘ ꠛꠣꠌꠣꠁꠟꠣ। ꠢꠥꠎꠥꠞꠦ ꠀꠝꠞꠣꠞꠦ ꠖꠄꠀ ꠇꠞꠟꠦ, ꠀꠝꠞꠣ ꠚꠦꠞꠣꠃꠘꠞ ꠉꠥꠟꠣꠝꠤ ꠇꠞꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","ꠛꠣꠖꠦ ꠁꠃꠍꠥꠚꠦ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠎꠣꠉꠣ-ꠎꠝꠤꠘꠞ ꠟꠣꠉꠤ ꠅꠃ ꠀꠁꠘ ꠎꠣꠞꠤ ꠇꠞꠟꠣ, ꠢꠇꠟ ꠚꠡꠟꠞ ꠙꠣꠌ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ ꠚꠦꠞꠣꠃꠘꠦ ꠙꠣꠁꠛꠣ, ꠈꠣꠟꠤ ꠛꠣꠛꠘ ꠅꠇꠟꠞ ꠎꠝꠤꠘ ꠛꠣꠖꠦ। ꠅꠃ ꠀꠁꠘ ꠅꠈꠘꠅ ꠌꠟꠦꠞ। ");
INSERT INTO syls_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠉꠥꠡꠘꠅ ꠛꠡꠔ ꠇꠞꠟꠣ। ꠔꠣꠞꠣ ꠢꠘꠞ ꠖꠈꠟꠖꠣꠞꠤ ꠙꠣꠁꠀ, ꠈꠥꠛ ꠚꠟꠀꠟꠣ ꠅꠁꠟꠣ ꠀꠞ ꠔꠣꠞꠣꠞ ꠛꠃꠔ ꠀꠅꠟꠣꠖ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠀꠁꠀ ꠁꠀꠇꠥꠛ ꠡꠔꠞ ꠛꠞꠍ ꠎꠤꠘ꠆ꠖꠣ ꠞꠁꠟꠣ। ꠔꠦꠃ ꠔꠣꠁꠘ ꠢꠇꠟꠔꠣꠄ ꠄꠇ-ꠡ ꠡꠣꠔꠌꠣꠟ꠆ꠟꠤꠡ ꠛꠞꠍ ꠛꠣꠌꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","ꠁꠍꠞꠣꠁꠟꠞ ꠝꠃꠔꠞ ꠖꠤꠘ ꠇꠣꠍꠣꠁꠀ ꠀꠁꠟꠦ ꠔꠣꠘ ꠙꠥꠀ ꠁꠃꠍꠥꠚꠞꠦ ꠈꠛꠞ ꠖꠤ ꠀꠘꠣꠁꠀ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠛꠣꠄ ꠔꠥꠝꠣꠞ ꠝꠦꠢꠦꠞꠛꠣꠘꠤ ꠅꠁꠟꠦ ꠄꠇꠈꠣꠘ ꠅꠍꠤꠅꠔ ꠇꠞꠣꠁꠔꠣꠝ, ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠃꠞꠣꠔꠞ ꠔꠟꠦ ꠔꠥꠝꠣꠞ ꠀꠔꠈꠣꠘ ꠢꠣꠞꠣꠅ, ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠛꠣꠄ ꠖꠄꠀ ꠀꠞ ꠢꠣꠟꠣꠟꠤ ꠖꠦꠈꠣꠁꠅ, ꠀꠝꠣꠞꠦ ꠝꠤꠡꠞꠅ ꠖꠣꠚꠘ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ꠀꠝꠤ ꠎꠦꠛꠟꠣ ꠀꠝꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠉꠦꠍꠦ ꠎꠣꠁꠝꠥꠉꠤ, ꠅꠃ ꠡꠝꠄ ꠔꠥꠝꠤ ꠀꠝꠣꠞꠦ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠘꠤꠀ, ꠀꠝꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠇꠛꠞꠡ꠆ꠕꠣꠘꠅ ꠖꠣꠚꠘ ꠇꠞꠤꠅ।” ꠁꠃꠍꠥꠚꠦ ꠇꠁꠟꠣ, “ꠀꠙꠘꠦ ꠎꠦꠟꠣ ꠇꠁꠟꠣ, ꠅꠃꠟꠣꠃ ꠇꠞꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","ꠔꠦꠃ ꠁꠀꠇꠥꠛꠦ ꠇꠁꠟꠣ, “ꠔꠦ ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠇꠍꠝ ꠇꠞꠅ।” ꠁꠃꠍꠥꠚꠦ ꠇꠍꠝ ꠇꠞꠟꠣ। ꠅꠃ ꠁꠍꠞꠣꠁꠟꠦ ꠔꠣꠘ ꠛꠤꠍꠘꠣꠞ ꠢꠤꠔꠣꠘ ꠛꠣꠄ ꠇꠣꠁꠔ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","ꠄꠞꠛꠣꠖꠦ ꠁꠃꠍꠥꠚꠦ ꠈꠛꠞ ꠙꠣꠁꠟꠣ, ꠔꠣꠘ ꠛꠣꠚ ꠛꠦꠝꠣꠞ, ꠅꠃ ꠔꠣꠘ ꠖꠥꠁꠅ ꠙꠥꠀ ꠝꠣꠘꠡꠣ ꠀꠞ ꠀꠚꠞꠣꠁꠝꠞꠦ ꠟꠁꠀ ꠛꠣꠚꠞꠦ ꠖꠦꠈꠣꠔ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","ꠁꠀꠇꠥꠛꠦ ꠎꠦꠛꠟꠣ ꠢꠥꠘꠟꠣ, ꠔꠣꠘ ꠙꠥꠀ ꠁꠃꠍꠥꠚ ꠀꠁꠍꠂꠘ, ꠅꠃ ꠔꠣꠁꠘ ꠡꠞꠤꠟꠞ ꠢꠇꠟ ꠛꠟ ꠈꠣꠐꠣꠁꠀ, ꠃꠑꠤꠀ ꠛꠤꠍꠘꠣꠔ ꠛꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ꠀꠞ ꠔꠣꠁꠘ ꠁꠃꠍꠥꠚꠞꠦ ꠇꠁꠟꠣ, “ꠡꠞ꠆ꠛ-ꠡꠇ꠆ꠔꠤꠝꠣꠘ ꠀꠟ꠆ꠟꠣꠄ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠞ ꠟꠥꠎ ꠐꠣꠃꠘꠅ, ꠀꠝꠣꠞꠦ ꠖꠤꠖꠣꠞ ꠖꠤꠀ ꠛꠞꠇꠔ ꠖꠣꠘ ꠇꠞꠤꠀ ꠇꠁꠍꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","‘ꠢꠥꠘꠅ, ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠚꠟꠖꠣꠞ ꠇꠞꠝꠥ ꠀꠞ ꠛꠃꠔ ꠀꠅꠟꠣꠖ ꠖꠤꠝꠥ, ꠔꠥꠝꠣ ꠕꠘꠦ ꠛꠃꠔ ꠉꠥꠡ꠆ꠐꠤꠀꠟꠣ ꠄꠇ ꠎꠣꠔꠤ ꠙꠄꠖꠣ ꠇꠞꠝꠥ ꠀꠞ ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡ ꠅꠇꠟꠞꠦ, ꠢꠣꠝꠦꠡꠣꠇꠥꠞ ꠟꠣꠉꠤ ꠁ ꠖꠦꠡꠞ ꠝꠣꠟꠤꠇꠣꠘꠣ ꠖꠤꠝꠥ।’ ");
INSERT INTO syls_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠉꠦꠍꠦ ꠝꠤꠡꠞꠅ ꠀꠁꠛꠣꠞ ꠀꠉꠦ, ꠔꠥꠝꠣꠞ ꠎꠦ ꠖꠥꠁꠅ ꠙꠥꠀ ꠝꠤꠡꠞꠅ ꠎꠘꠝꠤꠍꠂꠘ, ꠔꠣꠞꠣ ꠀꠝꠣꠞꠃ। ꠞꠥꠛꠦꠘ ꠀꠞ ꠡꠤꠝꠤꠅꠘ ꠎꠦꠟꠣ ꠀꠝꠣꠞ, ꠅꠃꠟꠣ ꠝꠣꠘꠡꠣ ꠀꠞ ꠀꠚꠞꠣꠁꠝꠅ ꠀꠝꠣꠞ ꠅꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","ꠅꠁꠟꠦ ꠄꠞꠣꠞ ꠛꠣꠖꠦ ꠔꠥꠝꠣꠞ ꠎꠦꠔꠣ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠅꠁꠍꠂꠘ, ꠔꠣꠞꠣ ꠔꠥꠝꠣꠞꠃ ꠞꠁꠛꠣ, ꠀꠞ ꠔꠣꠞꠣꠞ ꠜꠣꠁꠞ ꠘꠣꠝꠦꠃ ꠄꠞꠣꠞ ꠝꠣꠟꠤꠇꠣꠘꠣ ꠇꠣꠁꠝ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","ꠀꠞ ꠙꠖ꠆ꠖꠘ ꠕꠣꠇꠤ ꠀꠝꠞꠣ ꠀꠅꠀꠞ ꠡꠝꠄ, ꠇꠦꠘꠣꠘ ꠖꠦꠡꠞ ꠁꠚ꠆ꠞꠣꠕ ꠕꠣꠇꠤ ꠕꠥꠠꠣ ꠖꠥꠞꠁ ꠕꠣꠇꠔꠦꠃ, ꠞꠣꠢꠦꠟꠣ ꠝꠣꠞꠣ ꠉꠦꠟꠣ। ꠔꠦꠃ ꠀꠝꠤ ꠢꠘꠞ ꠁꠚ꠆ꠞꠣꠕꠅ, ꠛꠦꠕꠦꠟꠢꠣꠝꠞ ꠙꠕꠞ ꠗꠣꠞꠅ ꠔꠣꠘꠞꠦ ꠖꠣꠚꠘ ꠇꠞꠟꠣꠝ।” ");
INSERT INTO syls_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","ꠛꠣꠖꠦ ꠁꠃꠍꠥꠚꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠛꠣꠄ ꠌꠣꠁꠀ ꠁꠍꠞꠣꠁꠟꠦ ꠎꠤꠇꠣꠁꠟꠣ, “ꠄꠞꠣ ꠇꠦ?” ");
INSERT INTO syls_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","ꠁꠃꠍꠥꠚꠦ ꠔꠣꠘꠞꠦ ꠇꠁꠟꠣ, “ꠄꠞꠣ ꠀꠝꠣꠞ ꠙꠥꠀꠂꠘ, ꠀꠟ꠆ꠟꠣꠄ ꠅꠃ ꠖꠦꠡꠅꠃ ꠄꠞꠣꠞꠦ ꠖꠤꠍꠂꠘ।” ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠄꠞꠣꠞꠦ ꠀꠝꠣꠞ ꠇꠣꠍꠣꠔ ꠀꠘꠅ। ꠀꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠖꠥꠀ ꠇꠞꠔꠣꠝ।” ");
INSERT INTO syls_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","ꠝꠥꠞꠛ꠆ꠛꠤ ꠛꠄꠅꠡꠅ ꠌꠃꠈꠞ ꠎꠥꠔꠤ ꠇꠝꠤ ꠎꠣꠅꠀꠄ ꠁꠍꠞꠣꠁꠟꠦ ꠜꠣꠟꠣ ꠇꠞꠤ ꠖꠦꠈꠔꠣ ꠘꠣ। ꠔꠦꠃ ꠄꠞꠣ ꠇꠣꠍꠣꠔ ꠀꠁꠟꠦ, ꠁꠍꠞꠣꠁꠟꠦ ꠔꠣꠞꠣꠞꠦ ꠀꠁꠘ꠆ꠎꠣ ꠇꠞꠤ ꠗꠞꠤꠀ ꠢꠥꠋꠉꠣ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ꠔꠣꠁꠘ ꠁꠃꠍꠥꠚꠞꠦ ꠇꠁꠟꠣ, “ꠛꠣꠛꠣꠞꠦ, ꠀꠝꠤ ꠝꠘꠅ ꠇꠞꠍꠟꠣꠝ ꠔꠥꠝꠣꠞ ꠝꠥꠈ ꠀꠞ ꠇꠥꠘꠥ ꠖꠤꠘ ꠖꠦꠈꠔꠣꠝ ꠘꠣꠄ, ꠅꠁꠟꠦ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠣꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠞꠦꠅ ꠖꠦꠈꠣꠁꠟꠤꠟꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","ꠔꠦꠃ ꠁꠃꠍꠥꠚꠦ ꠔꠣꠘ ꠛꠣꠚꠞ ꠉꠦꠍ ꠕꠘꠦ, ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠢꠞꠣꠁꠀ ꠝꠣꠐꠤꠔ ꠍꠁꠎꠖꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","ꠀꠞ ꠁꠃꠍꠥꠚꠦ ꠔꠣꠘ ꠖꠥꠁꠅ ꠙꠥꠀꠞꠦ ꠟꠁꠀ, ꠒꠣꠁꠘ ꠀꠔ ꠖꠤꠀ ꠀꠚꠞꠣꠁꠝꠞꠦ ꠗꠞꠤꠀ ꠁꠍꠞꠣꠁꠟꠞ ꠛꠣꠃ ꠉꠣꠟꠣꠔ, ꠀꠞ ꠛꠣꠃ ꠀꠔ ꠖꠤꠀ ꠝꠣꠘꠡꠣꠞꠦ ꠗꠞꠤꠀ ꠁꠍꠞꠣꠁꠟꠞ ꠒꠣꠁꠘ ꠉꠣꠟꠣꠔ ꠀꠘꠤꠀ ꠀꠎꠤꠞ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","ꠅꠁꠟꠦ ꠁꠍꠞꠣꠁꠟꠞ ꠘꠤꠎꠞ ꠀꠈꠟꠦ, ꠔꠣꠘ ꠀꠔ ꠀꠠꠣ-ꠀꠠꠤ ꠇꠞꠤꠀ, ꠒꠣꠁꠘꠞ ꠀꠔ ꠢꠥꠞꠥ ꠙꠥꠀ ꠀꠚꠞꠣꠁꠝꠞ ꠝꠣꠕꠣꠔ ꠀꠞ ꠁꠃꠍꠥꠚꠞ ꠛꠠ ꠙꠥꠀ ꠝꠣꠘꠡꠣꠞ ꠝꠣꠕꠣꠔ ꠕꠁꠟꠣ ꠔꠣꠘ ꠛꠣꠃ ꠀꠔ। ");
INSERT INTO syls_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠁꠃꠍꠥꠚꠞꠦ ꠖꠥꠀ ꠇꠞꠤꠀ ꠇꠁꠟꠣ, “ꠢꠃ ꠀꠟ꠆ꠟꠣ, ꠎꠣꠘ ꠝꠞ꠆ꠎꠤꠄ ꠀꠝꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣ, ꠁꠛ꠆ꠞꠣꠢꠤꠝ ꠀꠞ ꠁꠍꠢꠣꠇꠦ ꠌꠟꠔꠣ, ꠢꠃ ꠀꠟ꠆ꠟꠣ, ꠎꠦꠁꠘ ꠙꠄꠟꠣ ꠕꠣꠇꠤ ꠀꠁꠎ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠀꠝꠣꠞꠦ ꠙꠣꠟꠤꠀ ꠀꠁꠞꠣ, ");
INSERT INTO syls_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ꠢꠃ ꠚꠤꠞꠤꠡ꠆ꠔꠣ, ꠎꠦꠁꠘ ꠀꠝꠣꠞꠦ ꠢꠇꠟ ꠝꠍꠤꠛꠔ ꠕꠣꠇꠤ ꠛꠣꠌꠣꠁꠍꠂꠘ, ꠔꠣꠁꠘꠃ ꠅꠃ ꠖꠥꠁꠅ ꠙꠥꠀꠞꠦ ꠛꠞꠇꠔ ꠘꠣꠎꠤꠟ ꠇꠞꠃꠇ꠆ꠇꠣ। ꠄꠞꠣꠞꠦ ꠖꠤꠀꠃ ꠁꠛ꠆ꠞꠣꠢꠤꠝ ꠀꠞ ꠁꠍꠢꠣꠇ ꠀꠞ ꠀꠝꠣꠞ ꠘꠣꠝ ꠎꠤꠘ꠆ꠖꠣ ꠕꠣꠇꠃꠇ। ꠖꠥꠘꠤꠀꠁꠞ ꠝꠣꠎꠦ ꠔꠣꠞꠣꠞ ꠛꠃꠔ ꠉꠥꠡ꠆ꠐꠤ ꠅꠃꠇ।” ");
INSERT INTO syls_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","ꠛꠣꠚꠦ ꠔꠣꠘ ꠒꠣꠁꠘ ꠀꠔ ꠀꠚꠞꠣꠁꠝꠞ ꠝꠣꠕꠣꠔ ꠞꠣꠈꠟꠣ ꠇꠞꠤ ꠁꠃꠍꠥꠚ ꠛꠦꠎꠣꠞ ꠅꠁꠉꠦꠟꠣ। ꠀꠞ ꠀꠚꠞꠣꠁꠝꠞ ꠝꠣꠕꠣ ꠕꠣꠇꠤ ꠢꠞꠣꠁꠀ, ꠝꠣꠘꠡꠣꠞ ꠝꠣꠕꠣꠔ ꠖꠦꠅꠀꠞ ꠟꠣꠉꠤ, ꠔꠣꠘ ꠛꠣꠚꠞ ꠀꠔ ꠃꠌꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","ꠔꠣꠁꠘ ꠀꠔꠅ ꠗꠞꠤꠀ ꠇꠁꠟꠣ, “ꠛꠣꠛꠣ, ꠁ ꠟꠣꠈꠣꠘ ꠘꠣꠄ। ꠅꠃꠘꠥ ꠀꠝꠣꠞ ꠛꠠ ꠙꠥꠀ, ꠔꠦ ꠀꠙꠘꠣꠞ ꠒꠣꠁꠘ ꠀꠔ ꠔꠣꠞ ꠝꠣꠕꠣꠔ ꠞꠣꠈꠃꠇ꠆ꠇꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","ꠅꠁꠟꠦ ꠔꠣꠘ ꠛꠣꠚꠦ ꠘꠣ-ꠈꠥꠡ ꠅꠁꠀ ꠇꠁꠟꠣ, “ꠛꠣꠛꠣꠞꠦ, ꠀꠝꠤ ꠁꠔꠣ ꠎꠣꠘꠤ, ꠀꠝꠤ ꠁꠔꠣ ꠎꠣꠘꠤꠞꠦ ꠙꠥꠔ। ꠔꠣꠞꠅ ꠄꠇ ꠎꠣꠔꠤ ꠅꠁꠛ ꠀꠞ ꠝꠢꠣꠘ ꠅꠁꠛ, ꠅꠁꠟꠦ ꠔꠣꠞ ꠢꠥꠞꠥ ꠜꠣꠁ ꠔꠣꠞ ꠌꠣꠁꠔꠦꠅ ꠝꠢꠣꠘ ꠅꠁꠛ, ꠀꠞ ꠔꠣꠞ ꠀꠅꠟꠣꠖꠞ ꠛꠃꠔ ꠉꠥꠡ꠆ꠐꠤ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","ꠁꠍꠞꠣꠁꠟꠦ ꠄꠞꠛꠣꠖꠦ ꠅꠃ ꠖꠥꠁꠅ ꠘꠣꠔꠤꠞꠦ ꠖꠥꠀ ꠇꠞꠤꠀ ꠇꠁꠟꠣ, “ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠞꠦ ꠖꠥꠀ ꠇꠞꠟꠦ ꠅꠃꠟꠣ ꠇꠁꠛꠣ, ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠣꠞꠦ ꠀꠚꠞꠣꠁꠝ ꠀꠞ ꠝꠣꠘꠡꠣꠞ ꠟꠣꠈꠣꠘ ꠇꠞꠃꠇ꠆ꠇꠣ।” ꠅꠃꠟꠣ ꠔꠣꠁꠘ ꠝꠣꠘꠡꠣꠞ ꠌꠣꠁꠔꠦ ꠀꠚꠞꠣꠁꠝꠞꠦ ꠛꠠ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","ꠢꠦꠡꠦ ꠢꠎꠞꠔ ꠁꠍꠞꠣꠁꠟꠦ ꠁꠃꠍꠥꠚꠞꠦ ꠇꠁꠟꠣ, “ꠖꠦꠈꠅ, ꠀꠝꠣꠞ ꠝꠞꠘꠞ ꠅꠇ꠆ꠔ ꠀꠁꠌ꠆ꠌꠦ। ꠀꠟ꠆ꠟꠣ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠞꠁꠛꠣ, ꠀꠞ ꠔꠥꠝꠞꠣꠞꠦ ꠢꠤꠞꠛꠣꠞ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠖꠦꠡꠅ ꠘꠤꠌ꠆ꠌꠄ ꠚꠤꠞꠣꠁꠀ ꠘꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","ꠔꠥꠝꠣꠞ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞ ꠌꠣꠁꠔꠦ ꠔꠥꠝꠣꠞꠦ ꠄꠇ ꠛꠣꠐ ꠛꠦꠡꠤ ꠖꠤꠟꠣꠝ। ꠅꠃ ꠛꠣꠐ ꠔ ꠡꠤꠈꠤꠝ ꠄꠟꠣꠇꠣ, ꠁꠔꠣ ꠀꠝꠣꠞ ꠔꠟꠥꠀꠞ-ꠗꠘꠥꠇ ꠖꠤꠀ ꠀꠝꠥꠞꠤ ꠅꠇꠟꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠀꠘꠍꠟꠣꠝ।” ");
INSERT INTO syls_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ꠛꠣꠖꠦ ꠁꠀꠇꠥꠛꠦ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠀꠘꠣꠁꠀ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠢꠇ꠆ꠇꠟ ꠄꠇꠈꠣꠘꠅ ꠅꠅ। ꠜꠛꠤꠡꠔꠦ ꠔꠥꠝꠞꠣꠞ ꠎꠤꠘ꠆ꠖꠦꠉꠤ ꠇꠤꠟꠣ ꠎꠣꠁꠛ, ꠁꠔꠣ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠇꠁꠞꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","ꠁꠀꠇꠥꠛꠞ ꠙꠥꠀꠂꠘ, ꠔꠥꠝꠞꠣ ꠄꠇꠈꠣꠘꠅ ꠀꠅ; ꠔꠥꠝꠞꠣꠞ ꠛꠣꠚ ꠁꠍꠞꠣꠁꠟꠞ ꠛꠥꠟꠤ ꠢꠥꠘꠅ। ");
INSERT INTO syls_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","ꠞꠥꠛꠦꠘ ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠛꠠ ꠙꠥꠀ, ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠛꠟ, ꠀꠝꠣꠞ ꠎꠥꠀꠘꠇꠤꠞ ꠙꠄꠟꠣ ꠚꠟ; ꠔꠥꠝꠤ ꠢꠇꠟ ꠕꠣꠇꠤ ꠔꠦꠎꠤ ꠀꠞ ꠢꠤꠝ꠆ꠝꠔꠤ। ");
INSERT INTO syls_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","ꠔꠥꠝꠤ ꠃꠔꠞꠣꠁꠟ ꠉꠞꠝ ꠙꠣꠘꠤꠞ ꠟꠣꠈꠣꠘ, ꠔꠥꠝꠣꠞ ꠛꠠꠣꠁ ꠞꠁꠔ ꠘꠣꠄ; ꠔꠥꠝꠤ ꠀꠙꠘ ꠛꠣꠚꠞ ꠛꠤꠍꠘꠣꠔ ꠉꠦꠍ, ꠢꠣꠔꠘ ꠝꠣʼꠞ ꠟꠉꠦ ꠘꠣꠙꠣꠇꠤ ꠇꠣꠝ ꠇꠞꠍ। ");
INSERT INTO syls_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","ꠡꠤꠝꠤꠅꠘ ꠀꠞ ꠟꠦꠛꠤ ꠖꠥꠁ ꠜꠣꠁ; ꠔꠣꠞꠣꠞ ꠔꠟꠥꠀꠞ ꠎꠣꠟꠤꠝꠞ ꠀꠔꠤꠀꠞ। ");
INSERT INTO syls_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","ꠅ ꠀꠝꠣꠞ ꠎꠣꠘ, ꠔꠣꠞꠣꠞ ꠝꠎꠟꠤꠍꠅ ꠢꠣꠝꠣꠁꠅ ꠘꠣ; ꠅ ꠀꠝꠣꠞ ꠡꠣꠘ, ꠔꠣꠞꠣꠞ ꠡꠝꠣꠎꠅ ꠎꠣꠁꠅ ꠘꠣ। ꠔꠣꠞꠣ ꠉꠥꠍꠣ ꠇꠞꠤ ꠈꠥꠘ ꠇꠞꠟ; ꠀꠠꠥꠀꠝꠤ ꠇꠞꠤ ꠛꠤꠍꠣꠟꠞ ꠞꠉ ꠇꠣꠐꠟ। ");
INSERT INTO syls_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","ꠔꠣꠞꠣꠞ ꠉꠥꠍꠣ ꠔ ꠟꠣꠘ꠆ꠘꠔꠤ, ꠁꠔꠣ ꠛꠠ ꠛꠦꠎꠥꠁꠔꠣ; ꠟꠣꠘ꠆ꠘꠔꠤ ꠔꠣꠞꠣꠞ ꠎꠥꠟꠥꠝ, ꠁꠔꠣ ꠔ ꠙꠣꠡꠣꠘ। ꠀꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠁꠀꠇꠥꠛꠞ ꠝꠣꠎꠦ ꠛꠣꠐꠤꠝꠥ; ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠎꠦ ꠍꠤꠔ꠆ꠞꠣꠁ ꠖꠤꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","ꠄꠢꠥꠖꠣ, ꠔꠥꠝꠣꠞ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠦ ꠔꠥꠝꠣꠞ ꠔꠣꠞꠤꠚ ꠇꠞꠛꠣ; ꠔꠥꠝꠤ ꠖꠥꠡꠝꠘꠞ ꠉꠞ꠆ꠖꠘꠣꠔ ꠗꠞꠛꠣꠄ; ꠔꠥꠝꠣꠞ ꠛꠣꠚꠞ ꠅꠀꠞꠤꠡ ꠅꠇꠟꠦ, ꠔꠥꠝꠣꠞ ꠉꠦꠍꠦ ꠝꠣꠕꠣ ꠘꠥꠀꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","ꠔꠥꠝꠤ ꠔ ꠡꠤꠋꠢꠞ ꠛꠣꠁꠌ꠆ꠌꠣ ꠄꠢꠥꠖꠣ। ꠔꠥꠝꠤ ꠡꠤꠇꠣꠞꠞ ꠉꠥꠡ꠆ꠔ ꠈꠣꠁꠀ ꠢꠞꠤꠀ ꠀꠁꠟꠣꠄ; ꠢꠦ ꠡꠤꠋꠢꠞ ꠟꠣꠈꠣꠘ ꠟꠦꠐꠤꠀ ꠢꠥꠔꠤꠀ ꠉꠠꠤꠀꠁꠟ; ꠡꠤꠋꠢꠤꠞꠦ ꠇꠦꠉꠥꠄ ꠊꠥꠝ ꠜꠣꠋꠉꠣꠁꠔ? ");
INSERT INTO syls_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","ꠄꠢꠥꠖꠣꠞ ꠀꠔ ꠕꠘꠦ ꠔ ꠞꠣꠎ-ꠟꠣꠑꠤ ꠢꠞꠔ ꠘꠣꠄ; ꠔꠣꠞ ꠖꠥꠁꠅ ꠙꠣꠅꠞ ꠝꠣꠎ ꠕꠘꠦ ꠛꠤꠌꠣꠞꠞ ꠉꠖꠣ ꠎꠣꠁꠔ ꠘꠣꠄ; ꠎꠔꠖꠤꠘ ꠡꠤꠟꠅ ꠘꠣ ꠀꠁꠛꠣ, ꠀꠞ ꠢꠇꠟ ꠎꠣꠔꠤ ꠔꠣꠘ ꠢꠥꠇꠥꠝꠦ ꠌꠟꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","ꠢꠦ ꠀꠋꠉꠥꠞ ꠉꠣꠍꠅ ꠛꠣꠘꠛ ꠔꠣꠞ ꠉꠣꠗꠣ; ꠀꠋꠉꠥꠞꠞ ꠡꠥꠘ꠆ꠖꠞ ꠒꠣꠟꠅ ꠛꠣꠘꠛ ꠉꠣꠗꠣꠞ ꠛꠣꠁꠌ꠆ꠌꠣ; ꠟꠣꠟ ꠀꠋꠉꠥꠞꠞ ꠞꠡꠖꠤ ꠗꠥꠁꠛ ꠔꠣꠞ ꠎꠥꠛ꠆ꠛꠣ, ꠀꠋꠉꠥꠞꠞ ꠟꠃꠖꠤ ꠇꠞꠛ ꠟꠦꠛꠣꠍ ꠍꠚꠣ। ");
INSERT INTO syls_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","ꠔꠣꠞ ꠌꠃꠈ ꠀꠋꠉꠥꠞꠞ ꠞꠡꠦ ꠟꠣꠟ ꠐꠇꠐꠇꠣ, ꠀꠞ ꠔꠣꠞ ꠖꠣꠔ ꠖꠥꠗꠞ ꠟꠣꠈꠣꠘ ꠗꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","ꠍꠛꠥꠟꠘ ꠖꠞꠤꠀꠞ ꠙꠣꠞꠅ ꠛꠡꠔ ꠇꠞꠤꠛ, ꠢꠦ ꠎꠣꠎ ꠜꠤꠠꠣꠘꠤꠞ ꠊꠣꠐ ꠅꠁꠛ, ꠍꠤꠖꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠔꠣꠞ ꠡꠤꠝꠣꠘꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","ꠁꠍꠣꠈꠞ ꠄꠉꠥ ꠛꠟꠀꠟꠣ ꠉꠣꠗꠣ, ꠢꠦ ꠈꠥꠅꠠꠞ ꠜꠤꠔꠞꠦ ꠢꠥꠔꠦ। ");
INSERT INTO syls_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ꠢꠦ ꠖꠦꠈꠟ ꠎꠤꠞꠣꠘꠤꠞ ꠎꠣꠉꠣꠈꠣꠘ ꠜꠣꠟꠣ, ꠖꠦꠡꠈꠣꠘ ꠡꠥꠘ꠆ꠖꠞ; ꠔꠦꠃ ꠉꠣꠁꠐ ꠛꠁꠛꠣꠞ ꠟꠣꠉꠤ ꠇꠣꠘ꠆ꠖ ꠟꠣꠝꠣꠁꠟ, ꠀꠞ ꠎꠥꠞꠞ ꠉꠥꠟꠣꠝ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","ꠖꠣꠘꠦ ꠔꠣꠞ ꠘꠤꠎꠞ ꠙ꠆ꠞꠎꠣ ꠅꠇꠟꠞ ꠛꠤꠌꠣꠞ ꠇꠞꠛ, ꠁꠍꠞꠣꠁꠟꠞ ꠄꠇ ꠉꠥꠡ꠆ꠐꠤꠞ ꠟꠣꠈꠣꠘ। ");
INSERT INTO syls_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","ꠢꠦ ꠅꠁꠛ ꠡꠠꠇꠞ ꠗꠣꠞꠞ ꠢꠣꠚ, ꠙꠕꠞ ꠛꠤꠡꠀꠟꠣ ꠀꠟꠖ; ꠎꠦꠉꠤꠄ ꠊꠥꠠꠣꠞ ꠙꠣꠅꠔ ꠇꠣꠝꠠ ꠝꠣꠞꠦ, ꠊꠥꠠ-ꠍꠅꠀꠞ ꠈꠞꠦꠖꠤ ꠃꠟꠐꠤꠀ ꠙꠠꠦ। ");
INSERT INTO syls_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","ꠅ ꠝꠣꠛꠥꠖ, ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠘꠣꠎꠣꠔꠞ ꠝꠥꠈꠣ ꠌꠣꠁ ꠞꠁꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","ꠍꠣꠖꠥꠞꠦ ꠟꠥꠐꠞꠣ ꠖꠟꠦ ꠢꠣꠝꠟꠣ ꠇꠞꠛ, ꠛꠣꠖꠦ ꠢꠦ-ꠅ ꠔꠣꠞꠣꠞ ꠈꠞꠦꠖꠤ ꠟꠥꠐꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","ꠀꠡꠤꠞꠞ ꠈꠥꠛ ꠜꠣꠟꠣ ꠚꠡꠟ ꠚꠟꠤꠛ, ꠢꠦ ꠛꠣꠖꠡꠣꠞ ꠎꠥꠇꠣ ꠈꠣꠘꠤ ꠎꠥꠉꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","ꠘꠙ꠆ꠔꠣꠟꠤ ꠅꠁꠟ ꠍꠣꠠꠣ ꠢꠞꠤꠘꠤ, ꠔꠣꠞ ꠝꠥꠈꠅ ꠀꠍꠦ ꠝꠤꠑꠣ ꠝꠤꠑꠣ ꠝꠣꠔ। ");
INSERT INTO syls_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","ꠁꠃꠍꠥꠚ ꠚꠟꠀꠟꠣ ꠉꠣꠍꠞ ꠒꠣꠟ, ꠁꠘ꠆ꠖꠣꠞꠣꠞ ꠗꠣꠞꠞ ꠚꠟꠀꠟꠣ ꠉꠣꠍꠞ ꠒꠣꠟ; ꠔꠣꠞ ꠒꠣꠟꠣꠁꠘ ꠛꠦꠠ ꠙꠣꠞ ꠅꠁꠎꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","ꠔꠤꠞ-ꠗꠘꠥꠇ ꠀꠟꠣꠁꠘ꠆ꠔꠦ ꠔꠣꠞꠦ ꠛꠦꠎꠥꠁꠔꠣ ꠔꠇꠟꠤꠚ ꠖꠤꠍꠟꠣ, ꠔꠤꠞ ꠝꠣꠞꠤꠀ ꠔꠣꠞꠦ ꠛꠦꠇꠣꠄꠖꠣꠔ ꠚꠣꠟꠣꠁꠍꠟꠣ; ");
INSERT INTO syls_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ꠅꠁꠟꠦ ꠔꠣꠞ ꠗꠘꠥꠇ ꠝꠎꠛꠥꠔ ꠞꠁꠟ, ꠔꠣꠞ ꠀꠔꠞ ꠢꠘꠣꠔ ꠛꠟ ꠞꠁꠟ; ꠁꠀꠇꠥꠛꠞ ꠢꠃ ꠝꠢꠣꠘ ꠡꠇ꠆ꠔꠤꠀꠟꠣꠞ ꠀꠔ ꠖꠤꠀ, ꠎꠦꠁꠘ ꠁꠍꠞꠣꠁꠟꠞ ꠀꠡꠞꠄ ꠐꠤꠟ꠆ꠟꠣ, ꠔꠣꠘꠞꠦ ꠖꠤꠀ। ");
INSERT INTO syls_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","ꠔꠥꠝꠣꠞ ꠛꠣꠚꠞ ꠢꠃ ꠀꠟ꠆ꠟꠣꠞꠦ ꠖꠤꠀ, ꠎꠦꠁꠘ ꠔꠥꠝꠣꠞꠦ ꠡꠣꠁꠎ꠆ꠎ ꠇꠞꠛꠣ; ꠢꠃ ꠡꠞ꠆ꠛ-ꠡꠇ꠆ꠔꠤꠝꠣꠘꠞꠦ ꠖꠤꠀ, ꠎꠦꠁꠘ ꠔꠥꠝꠣꠞꠦ ꠛꠞꠇꠔ ꠘꠣꠎꠤꠟ ꠇꠞꠛꠣ; ꠃꠙꠞꠦ ꠕꠅꠀ ꠀꠍꠝꠣꠘ ꠕꠣꠇꠤ ꠟꠣꠝꠞꠣ ꠛꠞꠇꠔꠦ, ꠔꠟꠦ ꠛꠤꠍꠣꠁꠟ ꠙꠣꠘꠤ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠀ ꠏꠞꠘꠣꠞ ꠛꠞꠇꠔꠦ, ꠛꠥꠇꠥꠞ ꠖꠥꠗ ꠀꠞ ꠙꠦꠐ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠀ ꠛꠞꠇꠔꠦ। ");
INSERT INTO syls_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","ꠀꠝꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠖꠥꠀ ꠕꠣꠇꠤ, ꠔꠥꠝꠣꠞ ꠛꠣꠚꠞ ꠖꠦꠅꠀ ꠖꠥꠀ ꠛꠃꠔ ꠜꠣꠟꠣ ꠅꠃꠇ; ꠁꠔꠣ ꠢꠣꠝꠦꠡꠣꠇꠥꠞ ꠈꠣꠠꠣ ꠢꠣꠎꠣꠁꠟ ꠙꠣꠠ-ꠙꠞꠛꠔ ꠕꠣꠇꠤ ꠟꠣꠝꠃꠇ। ꠢꠃ ꠖꠥꠀ ꠁꠃꠍꠥꠚꠞ ꠝꠣꠕꠣꠔ ꠙꠠꠃꠇ; ꠜꠣꠁꠀꠁꠘ ꠕꠣꠇꠤ ꠀꠟꠉꠞ ꠝꠣꠕꠣꠞ ꠔꠣꠟꠥꠔ ꠙꠠꠃꠇ। ");
INSERT INTO syls_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","ꠛꠤꠘ-ꠁꠀꠝꠤꠘ ꠅꠁꠟ ꠛꠠ-ꠛꠣꠊꠞ ꠟꠣꠈꠣꠘ, ꠢꠦ ꠛꠤꠀꠘꠦ ꠈꠣꠄ ꠡꠤꠇꠣꠞꠞ ꠉꠥꠡ꠆ꠔ, ꠀꠞ ꠢꠣꠁꠘ꠆ꠎꠣꠄ ꠛꠤꠟꠣꠄ ꠟꠥꠐꠞ ꠝꠣꠟ।” ");
INSERT INTO syls_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ꠄꠞꠣ ꠅꠁꠟꠣ ꠁꠍꠞꠣꠁꠟꠞ ꠛꠣꠞꠅ ꠉꠥꠡ꠆ꠐꠤ, ꠔꠣꠞꠣꠞ ꠛꠣꠚꠦ ꠔꠣꠞꠣꠞ ꠟꠣꠉꠤ ꠖꠥꠀꠞ ꠡꠝꠄ ꠅꠃꠟꠣ ꠇꠁꠟꠣ। ꠔꠣꠁꠘ ꠄꠞꠣ ꠢꠇ꠆ꠇꠟꠞꠦ ꠎꠣꠞꠎꠤꠞ ꠙꠣꠅꠘꠣ ꠖꠥꠀ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ꠛꠣꠖꠦ ꠁꠀꠇꠥꠛꠦ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠅꠍꠤꠅꠔ ꠇꠞꠣꠁꠟꠣ ꠎꠦꠘ, “ꠀꠝꠣꠞ ꠔ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠉꠦꠍꠦ ꠎꠣꠅꠀꠞ ꠡꠝꠄ ꠅꠁꠉꠦꠍꠦ, ꠔꠦ ꠢꠤꠐ꠆ꠐꠤ ꠁꠚ꠆ꠞꠥꠘꠞ ꠎꠝꠤꠘꠞ ꠉꠥꠢꠣꠔ, ꠀꠝꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠀꠝꠣꠞꠦ ꠖꠣꠚꠘ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ꠁ ꠉꠥꠢꠣ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠞ, ꠝꠝ꠆ꠞꠤꠞ ꠗꠣꠞꠅ ꠝꠇꠙꠦꠟꠣꠞ ꠎꠝꠤꠔ। ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ ꠢꠤꠐ꠆ꠐꠤ ꠁꠚ꠆ꠞꠥꠘꠞ ꠉꠦꠍ ꠕꠘꠦ ꠅꠃ ꠎꠝꠤꠘ ꠟꠁꠍꠟꠣ ꠇꠛꠞꠡ꠆ꠕꠣꠘ ꠛꠣꠘꠣꠘꠤꠞ ꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","ꠅꠘꠅꠃ ꠁꠛ꠆ꠞꠣꠢꠤꠝ ꠀꠞ ꠔꠣꠘ ꠛꠤꠛꠤ ꠍꠣꠄꠞꠣꠞꠦ ꠖꠣꠚꠘ ꠇꠞꠣ ꠅꠁꠍꠦ, ꠁꠍꠢꠣꠇ ꠀꠞ ꠔꠣꠘ ꠛꠤꠛꠤ ꠞꠦꠛꠦꠇꠣꠞꠦꠅ ꠅꠘꠅ ꠖꠣꠚꠘ ꠇꠞꠣ ꠅꠁꠍꠦ, ꠀꠞ ꠀꠝꠤ ꠟꠦꠀꠞꠦꠅ ꠅꠘꠅ ꠖꠣꠚꠘ ꠇꠞꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ꠁ ꠎꠝꠤꠘ ꠀꠞ ꠄꠞ ꠝꠣꠎꠞ ꠉꠥꠢꠣ ꠢꠤꠐ꠆ꠐꠤ ꠅꠇꠟꠞ ꠉꠦꠍ ꠕꠘꠦ ꠟꠁꠍꠟꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","ꠁꠀꠇꠥꠛꠦ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠅꠍꠤꠅꠔ ꠇꠞꠣ ꠡꠦꠡ ꠅꠁꠟꠦ, ꠛꠤꠍꠘꠣꠞ ꠃꠙꠞꠦ ꠔꠣꠘ ꠖꠥꠁꠅ ꠙꠣꠅ ꠄꠇꠈꠣꠘꠅ ꠇꠞꠟꠣ ꠀꠞ ꠀꠈꠦꠞꠤ ꠖꠝ ꠍꠣꠠꠤꠀ ꠔꠣꠘ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠉꠦꠍꠦ ꠉꠦꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","ꠁꠃꠍꠥꠚꠦ ꠔꠣꠘ ꠛꠣꠚꠞ ꠝꠥꠈꠞ ꠃꠙꠞꠦ ꠝꠥꠈ ꠟꠣꠉꠣꠁꠀ ꠇꠣꠘ꠆ꠖꠤꠔꠣ ꠟꠣꠉꠟꠣ ꠀꠞ ꠔꠣꠘꠞꠦ ꠢꠥꠋꠉꠣ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠘꠤꠎꠞ ꠅꠗꠤꠘꠞ ꠢꠦꠇꠤꠝ ꠅꠇꠟꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠟꠣ, ꠔꠣꠞꠣ ꠔꠣꠘ ꠛꠣꠚꠞ ꠟꠣꠡꠞꠦ ꠝꠝꠤ ꠛꠣꠘꠣꠁꠛꠣꠞ ꠟꠣꠉꠤ। ꠔꠦꠃ ꠔꠣꠞꠣ ꠔꠣꠘ ꠉꠔꠞꠅ ꠝꠝꠤꠞ ꠝꠡꠟꠣ ꠟꠣꠉꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","ꠔꠣꠞꠣ ꠁ ꠇꠣꠝꠅ ꠌꠣꠟ꠆ꠟꠤꠡ ꠖꠤꠘ ꠟꠣꠉꠣꠁꠟꠣ, ꠅꠃ ꠇꠣꠝꠅ ꠔ ꠌꠣꠟ꠆ꠟꠤꠡ ꠖꠤꠘꠃ ꠟꠣꠉꠦ। ꠀꠞ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠦ ꠔꠣꠘ ꠟꠣꠉꠤ ꠡꠔ꠆ꠔꠁꠞ ꠖꠤꠘ ꠜꠞꠤꠀ ꠀꠢꠣꠎꠣꠞꠤ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","ꠅꠃ ꠀꠢꠣꠎꠣꠞꠤꠞ ꠖꠤꠘꠞ ꠛꠣꠖꠦ, ꠁꠃꠍꠥꠚꠦ ꠚꠦꠞꠣꠃꠘꠞ ꠛꠣꠠꠤꠞ ꠝꠣꠘꠡꠞꠦ ꠇꠁꠟꠣ, “ꠀꠙꠘꠣꠞꠣ ꠎꠥꠖꠤ ꠀꠝꠣꠞꠦ ꠖꠄꠀ ꠇꠞꠂꠘ, ꠔꠦ ꠚꠦꠞꠣꠃꠘꠞꠦ ꠀꠝꠣꠞ ꠅꠃ ꠇꠕꠣꠈꠣꠘ ꠎꠣꠘꠣꠃꠇ꠆ꠇꠣ ꠎꠦꠘ। ");
INSERT INTO syls_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","ꠛꠣꠛꠣꠄ ꠀꠝꠣꠞꠦ ꠇꠍꠝ ꠇꠞꠣꠁꠀ ꠇꠁꠍꠟꠣ, ‘ꠢꠥꠘꠅ, ꠀꠝꠤ ꠔ ꠝꠞꠤꠎꠤꠝꠥ, ꠔꠦ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠀꠝꠣꠞ ꠟꠣꠉꠤ ꠎꠥꠁꠔ ꠇꠞꠣ ꠇꠄꠛꠞꠅ ꠀꠝꠣꠞꠦ ꠖꠣꠚꠘ ꠇꠞꠤꠅ।’ ꠔꠦꠃ ꠅꠈꠘ ꠔꠣꠘꠞꠦ ꠖꠣꠚꠘꠞ ꠟꠣꠉꠤ, ꠖꠄꠀ ꠇꠞꠤ ꠀꠝꠣꠞꠦ ꠎꠣꠁꠔꠦ ꠖꠦꠃꠇ꠆ꠇꠣ, ꠛꠣꠛꠣꠞꠦ ꠇꠄꠛꠞ ꠖꠤꠀꠃ ꠀꠝꠤ ꠢꠤꠞꠛꠣꠞ ꠀꠁꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ꠚꠦꠞꠣꠃꠘꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠔꠣꠁꠘ ꠔꠥꠝꠣꠞꠦ ꠎꠦꠟꠣ ꠇꠍꠝ ꠇꠞꠣꠁꠍꠂꠘ, ꠔꠥꠝꠤ ꠉꠤꠀ ꠅꠃꠟꠣꠃ ꠇꠞꠅ।” ");
INSERT INTO syls_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","ꠔꠦꠃ ꠁꠃꠍꠥꠚꠦ ꠔꠣꠘ ꠛꠣꠚꠞꠦ ꠖꠣꠚꠘꠞ ꠟꠣꠉꠤ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣ; ꠀꠞ ꠚꠦꠞꠣꠃꠘꠞ ꠢꠇꠟ ꠉꠥꠟꠣꠝꠦ, ꠔꠣꠘ ꠖꠞꠛꠣꠞꠞ ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟꠦ ꠀꠞ ꠝꠤꠡꠞꠞ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟꠦ, ");
INSERT INTO syls_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ꠁꠃꠍꠥꠚꠞ ꠘꠤꠎꠞ ꠙꠞꠤꠛꠣꠞ, ꠔꠣꠘ ꠜꠣꠁꠀꠁꠘ ꠀꠞ ꠔꠣꠘ ꠛꠣꠚꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠢꠇꠟꠦ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣ। ꠉꠥꠡꠘꠅ ꠈꠣꠟꠤ ꠔꠣꠞꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ ꠀꠞ ꠉꠞꠥ-ꠝꠦꠠꠣꠞ ꠙꠣꠟꠣꠁꠘ ꠕꠁꠀ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","ꠔꠣꠞꠣ ꠛꠃꠔ ꠊꠥꠠꠣꠞ ꠉꠣꠠꠤ ꠀꠞ ꠊꠥꠠ-ꠍꠅꠀꠞ ꠅꠇꠟ ꠟꠁꠀ ꠄꠇ ꠛꠤꠞꠣꠐ ꠖꠟ ꠢꠣꠎꠤꠀ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","ꠀꠞ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠢꠙꠣꠞꠅ ꠀꠐꠣꠖꠞ ꠗꠣꠘ ꠝꠣꠠꠣꠞ ꠎꠣꠉꠣꠔ ꠉꠤꠀ, ꠔꠣꠞꠣ ꠢꠇꠟꠦ ꠡꠣꠔꠖꠤꠘ ꠗꠞꠤ ꠁꠃꠍꠥꠚꠞ ꠛꠣꠚꠞ ꠟꠣꠉꠤ ꠈꠥꠛ ꠀꠢꠣꠎꠣꠞꠤ ꠀꠞ ꠛꠤꠟꠣꠙ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","ꠀꠐꠣꠖꠞ ꠗꠣꠘ ꠝꠣꠠꠣꠞ ꠎꠣꠉꠣꠔ ꠔꠣꠞꠣꠞꠦ ꠁꠟꠣ ꠀꠢꠣꠎꠣꠞꠤ ꠇꠞꠣꠔ ꠖꠦꠈꠤꠀ, ꠢꠤ ꠖꠦꠡꠞ ꠛꠣꠡꠤꠘ꠆ꠖꠣ ꠇꠦꠘꠣꠘꠤ ꠅꠇꠟꠦ ꠇꠁꠟꠣ, ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠟꠣꠉꠤ ꠁꠐꠣ ꠈꠥꠛ ꠛꠦꠎꠥꠁꠔꠣ ꠀꠢꠣꠎꠣꠞꠤ; ꠄꠞꠟꠣꠉꠤ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠙꠣꠞꠞ ꠅꠃ ꠎꠣꠉꠣꠞ ꠘꠣꠝ ꠅꠁꠉꠦꠟ, ꠀꠛꠦꠟ-ꠝꠤꠡꠞꠄꠁꠝ ꠝꠣꠘꠤ, ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠀꠢꠣꠎꠣꠞꠤ। ");
INSERT INTO syls_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","ꠁꠍꠞꠣꠁꠟꠦ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠎꠦꠟꠣ ꠅꠍꠤꠅꠔ ꠇꠞꠍꠟꠣ, ꠔꠣꠞꠣ ꠔꠣꠘꠞꠦ ꠅꠟꠣꠃ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","ꠔꠣꠞꠣ ꠔꠣꠘ ꠟꠣꠡ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠟꠁꠀ ꠉꠦꠟꠣ, ꠀꠞ ꠝꠝ꠆ꠞꠤꠞ ꠉꠦꠍꠦ ꠝꠇꠙꠦꠟꠣꠞ ꠎꠝꠤꠘꠞ, ꠉꠥꠢꠣꠞ ꠝꠣꠎꠦ ꠔꠣꠘꠞꠦ ꠖꠣꠚꠘ ꠇꠞꠟꠣ। ꠁꠐꠣ ꠇꠛꠞꠡ꠆ꠕꠣꠘ ꠛꠣꠘꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠦ, ꠢꠤꠐ꠆ꠐꠤ ꠁꠚ꠆ꠞꠥꠘꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠟꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","ꠛꠣꠚꠞꠦ ꠖꠣꠚꠘ ꠇꠞꠣꠞ ꠛꠣꠖꠦ ꠁꠃꠍꠥꠚ, ꠔꠣꠘ ꠜꠣꠁꠀꠁꠘ ꠀꠞ ꠎꠔ ꠝꠣꠘꠥꠡ ꠔꠣꠘ ꠛꠣꠚꠞꠦ ꠖꠣꠚꠘ ꠇꠞꠣꠔ ꠟꠉꠦ ꠉꠦꠍꠟꠣ, ꠔꠣꠞꠣ ꠢꠇꠟꠦ ꠝꠤꠡꠞꠅ ꠚꠤꠞꠤꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","ꠛꠣꠚ ꠝꠞꠤꠉꠦꠍꠂꠘ ꠖꠦꠈꠤꠀ ꠁꠃꠍꠥꠚꠞ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠦ ꠝꠣꠔꠣ-ꠝꠣꠔꠤ ꠇꠞꠟꠣ, ꠁꠃꠍꠥꠚꠦ ꠇꠤꠛꠣ ꠀꠝꠞꠣꠞꠦ ꠊꠤꠘ꠆ꠘꠣꠁꠛ ꠀꠞ ꠀꠝꠞꠣ ꠔꠣꠞ ꠎꠦꠔꠣ ꠈꠦꠔꠤ ꠇꠞꠍꠤ, ꠅꠈꠘ ꠁꠔꠣ ꠢꠇ꠆ꠇꠟꠔꠣꠞ ꠛꠖꠟꠣ ꠟꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","ꠔꠦꠃ ꠔꠣꠞꠣ ꠁꠃꠍꠥꠚꠞ ꠉꠦꠍꠦ ꠈꠛꠞꠤꠀ ꠙꠣꠑꠣꠁꠀ ꠇꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠛꠣꠚꠦ ꠝꠞꠣꠞ ꠀꠉꠦ ꠁ ꠅꠍꠤꠅꠔ ꠇꠞꠍꠟꠣ ꠎꠦꠘ, ");
INSERT INTO syls_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","ꠔꠥꠝꠞꠣ ꠁꠃꠍꠥꠚꠞꠦ ꠅꠃ ꠇꠕꠣꠈꠣꠘ ꠇꠁꠅ, ꠔꠥꠝꠣꠞ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠦ ꠔꠥꠝꠣꠞ ꠎꠦꠔꠣ ꠈꠦꠔꠤ ꠇꠞꠍꠂꠘ, ꠖꠄꠀ ꠇꠞꠤ ꠔꠥꠝꠤ ꠔꠣꠞꠣꠞ ꠢꠤ ꠅꠁꠘ꠆ꠘꠣꠄ ꠀꠞ ꠉꠥꠘꠣ ꠝꠣꠚ ꠇꠞꠤ ꠖꠤꠅ। ꠄꠞꠟꠣꠉꠤ ꠀꠝꠞꠣ ꠝꠤꠘꠔ ꠇꠞꠤꠀꠞ, ꠔꠥꠝꠣꠞ ꠛꠣꠚꠞ ꠀꠟ꠆ꠟꠣꠞ ꠅꠃ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠞꠦ ꠝꠣꠚ ꠇꠞꠤ ꠖꠤꠟꠣꠅ।” ꠔꠣꠞꠣꠞ ꠝꠣꠔ ꠢꠥꠘꠤꠀ ꠁꠃꠍꠥꠚꠞ ꠇꠣꠘ꠆ꠖꠘ ꠀꠁꠟ꠆ꠟ। ");
INSERT INTO syls_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","ꠛꠣꠖꠦ ꠔꠣꠘ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠦ ꠔꠣꠘ ꠍꠣꠝꠘꠦ ꠀꠁꠀ ꠝꠣꠐꠤꠔ ꠙꠠꠤꠀ ꠇꠁꠟꠣ, “ꠢꠥꠘꠅ, ꠀꠝꠞꠣ ꠔ ꠔꠥꠝꠣꠞ ꠉꠥꠟꠣꠝ।” ");
INSERT INTO syls_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","ꠅꠁꠟꠦ ꠁꠃꠍꠥꠚꠦ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠒꠞꠣꠁꠅ ꠘꠣ। ꠀꠝꠤ ꠇꠥꠘꠥ ꠀꠟ꠆ꠟꠣꠞ ꠈꠟꠤꠚꠣ ꠘꠤ? ");
INSERT INTO syls_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","ꠔꠥꠝꠞꠣ ꠔ ꠀꠝꠣꠞ ꠈꠦꠔꠤ ꠇꠞꠔꠣꠄ ꠌꠣꠁꠍꠟꠣꠄ, ꠅꠁꠟꠦ ꠀꠟ꠆ꠟꠣꠄ ꠁꠔꠣꠞꠦ ꠜꠣꠟꠣꠁ ꠛꠣꠘꠣꠁꠟ꠆ꠟꠣ, ꠎꠦꠟꠣ ꠀꠁꠎ ꠖꠦꠈꠞꠣꠄ, ꠔꠦ ꠔꠣꠘ ꠈꠤꠀꠟ ꠀꠍꠤꠟ ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠞꠤ ꠛꠃꠔ ꠝꠣꠘꠡꠞ ꠎꠣꠘ ꠛꠣꠌꠣꠁꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ꠔꠥꠝꠞꠣ ꠅꠈꠘ ꠒꠞꠣꠁꠅ ꠘꠣ। ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠙꠥꠀ-ꠙꠥꠠꠤꠘ꠆ꠔꠞꠦ ꠖꠦꠈꠣ-ꠢꠥꠘꠣ ꠇꠞꠝꠥ।” ꠔꠣꠁꠘ ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠞꠤ ꠔꠣꠞꠣꠞꠦ ꠛꠥꠎ ꠖꠤꠟꠣ ꠀꠞ ꠈꠥꠡ ꠖꠤꠟꠦ ꠝꠣꠔ-ꠇꠕꠣ ꠝꠣꠔꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","ꠛꠣꠖꠦ ꠁꠃꠍꠥꠚ ꠀꠞ ꠔꠣꠘ ꠛꠣꠚꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠦ ꠝꠤꠡꠞꠅ ꠛꠡꠔ ꠇꠞꠣꠔ ꠞꠁꠟꠣ। ꠁꠃꠍꠥꠚ ꠄꠇ-ꠡ ꠖꠡ ꠛꠞꠍ ꠎꠤꠘ꠆ꠖꠣ ꠀꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ꠔꠣꠁꠘ ꠀꠚꠞꠣꠁꠝꠞ ꠘꠣꠔꠤꠘꠡꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠖꠦꠈꠟꠣ ꠀꠞ ꠝꠣꠘꠡꠣꠞ ꠙꠥꠀ ꠝꠣꠈꠤꠞꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘꠅ ꠁꠃꠍꠥꠚꠞ ꠀꠔꠅ ꠙꠄꠖꠣ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","ꠛꠣꠖꠦ ꠁꠃꠍꠥꠚꠦ ꠔꠣꠘ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠔ ꠝꠃꠔꠞ ꠅꠇ꠆ꠔ ꠀꠁꠌ꠆ꠌꠦ, ꠘꠤꠌꠄ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠄ ꠘꠎꠞ ꠞꠣꠈꠛꠣ। ꠔꠣꠁꠘ ꠁꠛ꠆ꠞꠣꠢꠤꠝ, ꠁꠍꠢꠣꠇ ꠀꠞ ꠁꠀꠇꠥꠛꠞ ꠉꠦꠍꠦ ꠎꠦ ꠖꠦꠡ ꠖꠤꠔꠣ ꠇꠞꠤ ꠇꠍꠝ ꠇꠞꠍꠂꠘ, ꠔꠥꠝꠞꠣꠞꠦ ꠅꠘ ꠕꠣꠇꠤ ꠢꠃ ꠖꠦꠡꠅ ꠟꠁꠀ ꠎꠣꠁꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","ꠀꠞ ꠁꠃꠍꠥꠚꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠅꠃ ꠅꠍꠤꠅꠔ ꠇꠞꠣꠁꠟꠣ, “ꠘꠤꠌꠄ ꠀꠟ꠆ꠟꠣꠄ ꠇꠥꠘꠥꠖꠤꠘ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠄ ꠘꠎꠞ ꠇꠞꠛꠣ। ꠔꠦ ꠅꠘ ꠕꠣꠇꠤ ꠎꠣꠅꠀꠞ ꠛꠣꠟꠣ ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠀꠒ꠆ꠒꠤ ꠅꠇꠟ ꠔꠥꠟꠤꠀ ꠟꠁꠀ ꠎꠣꠁꠅ।” ");
INSERT INTO syls_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","ꠢꠦꠡꠦ ꠄꠇ-ꠡ ꠖꠡ ꠛꠞꠍ ꠛꠄꠅꠡꠅ ꠁꠃꠍꠥꠚ ꠝꠣꠞꠣ ꠉꠦꠟꠣ। ꠔꠦꠃ ꠝꠣꠘꠡꠦ ꠔꠣꠘ ꠟꠣꠡꠞꠦ ꠈꠥꠡꠛꠥ-ꠝꠡꠟꠣꠖꠤ ꠝꠣꠈꠤꠀ ꠝꠝꠤ ꠛꠣꠘꠣꠁꠀ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠄꠇ ꠇꠣꠚꠘꠞ ꠛꠣꠇ꠆ꠡꠞ ꠜꠤꠔꠞꠦ ꠕꠁꠟꠣ॥");
INSERT INTO syls_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","ꠀꠟ꠆ꠟꠣꠄ ꠢꠎꠞꠔ ꠁꠀꠇꠥꠛꠞ ꠘꠄꠀ ꠘꠣꠝ ꠖꠤꠍꠟꠣ ꠁꠍꠞꠣꠁꠟ, ꠄꠞꠟꠣꠉꠤ ꠔꠣꠘ ꠛꠋꠡꠞ ꠘꠣꠝ ꠅꠁꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ। ꠁꠀꠇꠥꠛꠦ ꠔꠣꠘ ꠛꠤꠛꠤꠘ-ꠛꠣꠁꠌ꠆ꠌꠣꠁꠘ ꠀꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠢꠇꠟꠞꠦ ꠟꠁꠀ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠉꠦꠟꠣꠉꠤ। ꠅꠃ ꠡꠝꠄ ꠔꠣꠘ ꠟꠉꠦ ꠅꠁꠀ ꠎꠦꠞꠣ ꠉꠦꠟꠣ, ꠄꠞꠣꠞ ꠘꠣꠝ ꠅꠁꠟ, ");
INSERT INTO syls_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","ꠞꠥꠛꠦꠘ, ꠡꠤꠝꠤꠅꠘ, ꠟꠦꠛꠤ, ꠄꠢꠥꠖꠣ, ");
INSERT INTO syls_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ꠁꠍꠣꠈꠞ, ꠍꠛꠥꠟꠘ, ꠛꠤꠘ-ꠁꠀꠝꠤꠘ, ");
INSERT INTO syls_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ꠖꠣꠘ, ꠘꠙ꠆ꠔꠣꠟꠤ, ꠍꠣꠖꠥ ꠀꠞ ꠀꠡꠤꠞ। ");
INSERT INTO syls_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","ꠁꠀꠇꠥꠛꠞ ꠛꠋꠡꠞ ꠢꠇ꠆ꠇꠟꠔꠣꠄ ꠝꠤꠟꠤꠀ ꠡꠔ꠆ꠔꠁꠞ ꠎꠘ ꠀꠍꠟꠣ। ꠀꠞ ꠁꠃꠍꠥꠚ ꠀꠉ ꠕꠣꠇꠤꠃ ꠝꠤꠡꠞꠅ ꠕꠣꠇꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","ꠛꠣꠖꠦ ꠁꠃꠍꠥꠚ, ꠔꠣꠘ ꠜꠣꠁꠀꠁꠘ, ꠀꠞ ꠢꠤ ꠀꠝꠟꠞ ꠢꠇꠟ ꠝꠣꠞꠣ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ꠅꠁꠟꠦ ꠔꠣꠞꠣꠞ ꠛꠣꠖꠞ ꠛꠋꠡꠗꠞ ꠛꠣꠠꠤꠀ ꠈꠥꠛ ꠛꠟꠀꠟꠣ ꠅꠁꠟꠣ। ꠄꠞꠣ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠍꠤꠔ꠆ꠞꠤꠀ ꠀꠡ꠆ꠔꠣ ꠝꠤꠡꠞ ꠖꠦꠡ ꠜꠞꠤꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","ꠄꠞꠝꠣꠎꠦ ꠝꠤꠡꠞꠅ ꠄꠇꠎꠘ ꠘꠄꠀ ꠛꠣꠖꠡꠣ ꠅꠁꠟꠣ, ꠄꠁꠘ ꠁꠃꠍꠥꠚꠞꠦ ꠌꠤꠘꠂꠘ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","ꠄꠁꠘ ꠘꠤꠎꠞ ꠙ꠆ꠞꠎꠣ ꠅꠇꠟꠞꠦ ꠇꠁꠟꠣ, “ꠌꠣꠁꠀ ꠖꠦꠈꠅ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠀꠝꠞꠣ ꠕꠣꠇꠤ ꠛꠦꠡꠤꠅ ꠀꠞ ꠛꠟꠀꠟꠣꠅ। ");
INSERT INTO syls_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","ꠔꠦ ꠀꠅ, ꠀꠝꠞꠣ ꠄꠇ ꠚꠘ꠆ꠖꠤ ꠇꠞꠤ, ꠁꠔꠣ ꠎꠦꠘꠥ ꠀꠞ ꠘꠣ ꠛꠣꠠꠂꠘ। ꠀꠞꠘꠣꠄ ꠔꠣꠞꠣ ꠛꠣꠠꠤꠀ ꠢꠦꠡꠦ ꠎꠥꠖ꠆ꠖꠞ ꠇꠣꠟꠅ ꠀꠝꠞꠣꠞ ꠖꠥꠡꠝꠘꠞ ꠟꠉꠦ ꠝꠤꠟꠤꠀ ꠀꠝꠞꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠎꠥꠖ꠆ꠖ ꠇꠞꠛ, ꠛꠣꠖꠦ ꠀꠝꠞꠣꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠎꠣꠁꠛꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","ꠔꠦꠃ ꠔꠣꠞꠣ ꠡꠞ꠆ꠖꠣꠞ ꠟꠣꠉꠣꠁꠟꠣ ꠄꠞꠣꠞꠦ ꠝꠣꠞꠤꠀ-ꠗꠞꠤꠀ ꠎꠥꠞ-ꠎꠥꠟꠥꠝ ꠇꠞꠤꠀ ꠇꠣꠝ ꠇꠞꠣꠘꠤꠞ ꠟꠣꠉꠤ। ꠄꠞꠣ ꠚꠦꠞꠣꠃꠘꠞ ꠚꠡꠟ ꠞꠣꠈꠣꠞ ꠟꠣꠉꠤ ꠙꠤꠕꠥꠝ ꠀꠞ ꠞꠣꠝꠣꠡꠦꠡ ꠘꠣꠝꠞ ꠖꠥꠁꠐꠣ ꠐꠣꠃꠘꠅ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","ꠅꠁꠟꠦ ꠄꠞꠣꠞ ꠃꠙꠞꠦ ꠎꠔ ꠛꠦꠡꠤ ꠎꠥꠞ-ꠎꠥꠟꠥꠝ ꠇꠞꠣ ꠅꠁꠟ, ꠄꠞꠣꠅ ꠅꠔ ꠛꠦꠡꠤ ꠛꠣꠠꠤꠟꠣ ꠀꠞ ꠍꠤꠔ꠆ꠞꠤꠟꠣ। ꠄꠞꠟꠣꠉꠤ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠈꠥꠛ ꠒꠞꠣꠁꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ꠒꠞꠣꠁꠀ ꠄꠞꠣꠞꠦꠖꠤ ꠀꠞꠅ ꠇꠑꠤꠘ ꠇꠣꠝ ꠇꠞꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ꠝꠣꠐꠤ ꠇꠣꠝ, ꠁꠐꠞ ꠇꠣꠝ ꠀꠞ ꠈꠦꠔꠞ ꠝꠣꠎꠦ ꠇꠡ꠆ꠐꠞ ꠇꠣꠝ ꠇꠞꠣꠁꠀ ꠄꠞꠣꠞ ꠎꠣꠘꠞꠦ ꠔꠤꠔ꠆ꠔꠣ ꠛꠣꠘꠣꠁꠟꠤꠟ। ꠀꠞ ꠔꠣꠞꠣ ꠎꠥꠞ-ꠎꠥꠟꠥꠝ ꠇꠞꠤꠀ ꠘꠤꠡ꠆ꠑꠥꠞ-ꠙꠣꠡꠣꠘꠞ ꠟꠣꠈꠣꠘ ꠇꠣꠝ ꠇꠞꠣꠁꠔ। ");
INSERT INTO syls_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","ꠛꠣꠖꠦ ꠝꠤꠡꠞꠞ ꠛꠣꠖꠡꠣꠄ ꠡꠤꠚ꠆ꠞꠣ ꠀꠞ ꠚꠥꠀ ꠘꠣꠝꠞ ꠖꠥꠁꠎꠘ ꠁꠛꠞꠣꠘꠤ ꠖꠣꠁ ꠛꠦꠐꠤꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“ꠔꠥꠝꠞꠣ ꠁꠛꠞꠣꠘꠤ ꠛꠦꠐꠤꠘ꠆ꠔꠞ ꠖꠣꠁ ꠉꠤꠞꠤꠔ ꠉꠤꠀ, ꠁꠔꠣꠞ ꠙꠥꠀꠂꠘ ꠙꠄꠖꠣ ꠅꠁꠟꠦꠃ ꠝꠣꠞꠤꠟꠣꠁꠅ, ꠈꠣꠟꠤ ꠙꠥꠠꠤꠘ꠆ꠔꠞꠦ ꠎꠤꠔꠣ ꠞꠣꠈꠤꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","ꠅꠁꠟꠦ ꠢꠤ ꠖꠣꠁ ꠛꠦꠐꠤꠘ꠆ꠔꠦ ꠀꠟ꠆ꠟꠣꠞꠦ ꠒꠞꠣꠁꠔꠣ ꠉꠔꠤꠇꠦ, ꠝꠤꠡꠞꠤ ꠛꠣꠖꠡꠣꠞ ꠢꠥꠇꠥꠝ ꠘꠣ ꠝꠣꠘꠤꠀ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦꠅ ꠎꠤꠔꠣ ꠞꠣꠈꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","ꠔꠦꠃ ꠛꠣꠖꠡꠣꠄ ꠄꠞꠣꠞꠦ ꠘꠤꠀ ꠎꠤꠇꠣꠁꠟꠣ, “ꠁꠔꠣ ꠇꠣꠝ ꠇꠦꠘꠦ ꠇꠞꠟꠣꠄ? ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠇꠦꠘꠦ ꠎꠤꠔꠣ ꠞꠣꠈꠟꠣꠄ?” ");
INSERT INTO syls_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","ꠔꠣꠞꠣ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠁꠛꠞꠣꠘꠤ ꠛꠦꠐꠤꠘ ꠝꠤꠡꠞꠤ ꠛꠦꠐꠤꠘ꠆ꠔꠞ ꠟꠣꠈꠣꠘ ꠘꠣꠄ, ꠔꠣꠞꠣ ꠛꠃꠔ ꠛꠟꠀꠟꠣ। ꠖꠣꠁꠛꠦꠐꠤ ꠔꠣꠞꠣꠞ ꠇꠣꠍꠣꠔ ꠎꠣꠁꠛꠣꠞ ꠀꠉꠦꠃ ꠔꠣꠞꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠙꠄꠖꠣ ꠅꠁꠎꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","ꠅꠃ ꠖꠥꠁꠅ ꠛꠦꠐꠤꠄ ꠀꠟ꠆ꠟꠣꠞꠦ ꠒꠞꠣꠁꠔꠣ ꠇꠞꠤ, ꠀꠟ꠆ꠟꠣꠄ ꠞꠢꠝꠔ ꠇꠞꠤꠀ ꠔꠣꠞꠣꠞꠦꠅ ꠀꠅꠟꠣꠖ ꠖꠤꠟꠣ। ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠅ ꠀꠞꠅ ꠛꠦꠡꠤ ꠇꠞꠤ ꠛꠣꠠꠤꠀ ꠈꠥꠛ ꠡꠇ꠆ꠔꠤꠝꠣꠘ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ꠁꠔꠣ ꠖꠦꠈꠤꠀ ꠚꠦꠞꠣꠃꠘꠦ ꠘꠤꠎꠞ ꠙ꠆ꠞꠎꠣ ꠅꠇꠟꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠟꠣ, “ꠁꠛꠞꠣꠘꠤ ꠅꠇꠟꠞ ꠇꠥꠘꠥ ꠙꠥꠀꠂꠘ ꠅꠁꠟꠦꠃ ꠔꠥꠝꠞꠣ ꠘꠤꠟ ꠘꠖꠅ ꠚꠣꠟꠣꠁ ꠖꠤꠅ, ꠈꠣꠟꠤ ꠙꠥꠠꠤꠘ꠆ꠔꠞꠦ ꠎꠤꠔꠣ ꠞꠣꠈꠤꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","ꠄꠞꠝꠣꠎꠦ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠄꠇꠎꠘ ꠝꠣꠘꠡꠦ, ꠔꠣꠘ ꠘꠤꠎꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠄꠇ ꠇꠁꠘꠣꠞꠦ ꠡꠣꠖꠤ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ꠅꠃ ꠇꠁꠘꠣꠞ ꠊꠞꠅ ꠄꠇ ꠙꠥꠀꠞ ꠎꠘꠝ ꠅꠁꠟ। ꠙꠥꠀꠉꠥ ꠖꠦꠈꠔꠦ ꠈꠥꠛ ꠡꠥꠘ꠆ꠖꠞ ꠅꠀꠄ, ꠔꠤꠘ ꠝꠣꠡ ꠗꠞꠤ ꠟꠥꠇꠣꠁ ꠞꠣꠈꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","ꠢꠦꠡꠦ ꠀꠞ ꠟꠥꠇꠣꠁꠔꠣ ꠘꠣ ꠙꠣꠞꠤꠀ, ꠔꠣꠁꠘ ꠘꠟ-ꠈꠣꠉꠠꠣꠞ ꠄꠇ ꠐꠥꠇꠞꠤ ꠟꠁꠟꠣ। ꠅꠃ ꠐꠥꠇꠞꠤꠔ ꠝꠣꠐꠤꠀ ꠔꠦꠟ ꠀꠞ ꠀꠟꠇꠣꠔꠞꠣ ꠟꠦꠙꠤꠀ ꠅꠉꠥꠞ ꠜꠤꠔꠞꠦ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠞꠦ ꠢꠣꠞꠣꠁꠀ, ꠉꠣꠋꠉꠞ ꠌꠞꠞ ꠘꠟ ꠛꠘꠞ ꠝꠣꠎꠦ ꠕꠁꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","ꠀꠞ ꠄꠞ ꠇꠤꠔꠣ ꠖꠡꠣ ꠅꠄ ꠖꠦꠈꠣꠞ ꠟꠣꠉꠤ, ꠔꠣꠞ ꠛꠁꠘ ꠖꠥꠞꠁ ꠃꠛꠣꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","ꠕꠥꠠꠣ ꠛꠣꠖꠦ ꠚꠦꠞꠣꠃꠘꠞ ꠙꠥꠠꠤ ꠉꠣꠋꠉꠅ ꠘꠣꠅꠀꠔ ꠀꠁꠟꠣ। ꠉꠣꠋꠉꠞ ꠙꠣꠞꠅ ꠔꠣꠘ ꠛꠣꠘ꠆ꠖꠤ ꠅꠇꠟ ꠊꠥꠞꠣꠊꠥꠞꠤꠔ ꠀꠍꠤꠟ। ꠔꠣꠁꠘ ꠌꠞꠞ ꠘꠟ-ꠈꠣꠉꠠꠣꠞ ꠝꠣꠎꠦ ꠅꠃ ꠐꠥꠇꠞꠤ ꠖꠦꠈꠤꠀ, ꠔꠣꠘ ꠛꠣꠘ꠆ꠖꠤꠞꠦ ꠇꠁꠟꠣ, “ꠅꠃ ꠐꠥꠇꠞꠤꠉꠥ ꠀꠘ।” ");
INSERT INTO syls_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","ꠐꠥꠇꠞꠤꠞ ꠒꠣꠟꠣ ꠈꠥꠟꠤꠀ ꠖꠦꠈꠟꠣ, ꠄꠞ ꠜꠤꠔꠞꠦ ꠄꠇ ꠙꠥꠀꠄ ꠇꠣꠘ꠆ꠖꠦꠞ। ꠖꠦꠈꠤꠀ ꠔꠣꠘ ꠝꠣꠄꠀ ꠟꠣꠉꠤꠉꠦꠟ। ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠁꠡ, ꠁꠉꠥ ꠔ ꠇꠥꠘꠥ ꠁꠛꠞꠣꠘꠤꠞ ꠙꠥꠀ।” ");
INSERT INTO syls_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","ꠅꠃ ꠡꠝꠄ ꠙꠥꠀꠞ ꠛꠁꠘ ꠀꠁꠀ ꠚꠦꠞꠣꠃꠘꠞ ꠙꠥꠠꠤꠞꠦ ꠎꠤꠇꠣꠁꠟ, “ꠞꠣꠘꠤ ꠝꠣ, ꠁ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠞꠦ ꠖꠥꠗ ꠈꠣꠅꠀꠘꠤꠞ ꠟꠣꠉꠤ ꠇꠥꠘꠥ ꠁꠛꠞꠣꠘꠤ ꠛꠦꠐꠤꠞꠦ ꠙꠣꠁꠟꠦ ꠀꠙꠘꠣꠞ ꠉꠦꠍꠦ ꠀꠘꠔꠣꠝ ꠘꠤ?” ");
INSERT INTO syls_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","ꠚꠦꠞꠣꠃꠘꠞ ꠙꠥꠠꠤꠄ ꠇꠁꠟꠣ, “ꠎꠣ ꠀꠘꠉꠤ।” ꠔꠦꠃ ꠙꠥꠠꠤꠄ ꠉꠤꠀ ꠙꠥꠀꠞ ꠝꠣʼꠞꠦ ꠟꠁꠀ ꠀꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ꠚꠦꠞꠣꠃꠘꠞ ꠙꠥꠠꠤꠄ ꠔꠣꠘꠞꠦ ꠇꠁꠟꠣ, “ꠅꠉ, ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠛꠦꠔꠘ ꠖꠤꠝꠥꠘꠦ, ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠅꠁꠀ ꠅꠃ ꠙꠥꠀꠉꠥꠞꠦ ꠛꠥꠇꠥꠞ ꠖꠥꠗ ꠈꠣꠅꠀꠅ।” ꠅꠃ ꠢꠤ ꠛꠦꠐꠤꠄ ꠘꠤꠀ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠞꠦ ꠖꠥꠗ ꠈꠣꠅꠀꠁꠀ ꠙꠣꠟꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","ꠙꠥꠀꠉꠥ ꠇꠤꠍꠥ ꠛꠠ ꠅꠀꠞ ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠘꠤꠀ ꠚꠦꠞꠣꠃꠘꠞ ꠙꠥꠠꠤꠞ ꠉꠦꠍꠦ ꠖꠤꠟꠣꠁꠟꠣ। ꠚꠦꠞꠣꠃꠘꠞ ꠙꠥꠠꠤꠄ ꠄꠘꠞꠦ ꠘꠤꠎꠞ ꠙꠥꠀ ꠛꠣꠘꠣꠁꠀ ꠙꠣꠟꠤꠟꠣ। ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠔꠣꠞꠦ ꠙꠣꠘꠤ ꠕꠣꠇꠤ ꠐꠣꠘꠤꠀ ꠔꠥꠟꠍꠤ।” ꠄꠞꠟꠣꠉꠤ ꠔꠣꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠝꠥꠍꠣ ꠝꠣꠘꠤ, ꠐꠣꠘꠤꠀ ꠔꠥꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","ꠢꠦꠡꠦ ꠝꠥꠍꠣ ꠛꠠ ꠅꠁꠉꠦꠟꠦ ꠄꠇꠖꠤꠘ ꠔꠣꠘ ꠘꠤꠎꠞ ꠎꠣꠔꠤꠞ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞ ꠉꠦꠍꠦ ꠉꠤꠀ ꠖꠦꠈꠟꠣ, ꠔꠣꠞꠣ ꠈꠥꠛ ꠇꠡ꠆ꠐꠞ ꠇꠣꠝ ꠇꠞꠞꠣ। ꠄꠞꠝꠣꠎꠦ ꠖꠦꠈꠟꠣ, ꠔꠣꠘ ꠘꠤꠎꠞ ꠁꠛꠞꠣꠘꠤ ꠎꠣꠔꠤꠞ ꠄꠇ ꠛꠦꠐꠣꠞꠦ, ꠄꠇ ꠝꠤꠡꠞꠤꠄ ꠝꠣꠁꠞ-ꠗꠁꠞ ꠇꠞꠦꠞ। ");
INSERT INTO syls_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","ꠖꠦꠈꠤꠀ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠌꠣꠁꠀ ꠀꠞ ꠇꠥꠘꠥ ꠝꠣꠘꠥꠡ ꠘꠣ ꠖꠦꠈꠣꠄ, ꠔꠣꠁꠘ ꠢꠃ ꠝꠤꠡꠞꠤꠞꠦ ꠈꠥꠘ ꠇꠞꠤꠀ ꠛꠣꠟꠥꠞ ꠔꠟꠦ ꠉꠣꠠꠤꠟ꠆ꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","ꠛꠣꠖꠞ ꠖꠤꠘꠅ ꠔꠣꠁꠘ ꠢꠤꠞꠛꠣꠞ ꠛꠣꠞꠦ ꠉꠦꠟꠣ। ꠉꠤꠀ ꠖꠦꠈꠟꠣ, ꠖꠥꠁꠎꠘ ꠁꠛꠞꠣꠘꠤꠄ ꠘꠤꠎꠦ ꠘꠤꠎꠦ ꠝꠣꠞꠣ-ꠝꠣꠞꠤ ꠇꠞꠦꠞ। ꠅꠃ ꠔꠣꠁꠘ ꠖꠥꠡꠤ ꠎꠘꠞꠦ ꠇꠁꠟꠣ, “ꠅꠛꠣ, ꠔꠥꠝꠣꠞ ꠜꠣꠁꠞꠦ ꠇꠦꠘꠦ ꠝꠣꠞꠞꠣꠄ?” ");
INSERT INTO syls_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","ꠢꠦ ꠇꠁꠟ, “ꠔꠥꠝꠣꠞꠦ ꠇꠦꠉꠤꠄ ꠀꠝꠞꠣꠞ ꠢꠣꠇꠤꠝ ꠛꠣꠘꠣꠁꠀ ꠛꠤꠌꠣꠞ ꠇꠞꠣꠔ ꠙꠣꠑꠣꠁꠟ? ꠇꠣꠁꠟ ꠎꠦꠟꠣ ꠢꠃ ꠝꠤꠡꠞꠤꠞꠦ ꠈꠥꠘ ꠇꠞꠍ, ꠅꠃꠟꠣ ꠀꠝꠣꠞꠦꠅ ꠈꠥꠘ ꠇꠞꠤꠟꠔꠣꠄ ꠌꠣꠁꠞꠣꠄ ꠘꠤ?” ꠅꠃ ꠝꠥꠍꠣꠄ ꠒꠞꠣꠁꠉꠦꠟꠣ। ꠔꠣꠁꠘ ꠛꠥꠎꠟꠣ ꠁꠔꠣ ꠔ ꠎꠣꠘꠣ-ꠎꠣꠘꠤ ꠅꠁꠉꠦꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","ꠀꠞ ꠚꠦꠞꠣꠃꠘꠦꠅ ꠁꠔꠣ ꠢꠥꠘꠤꠀ ꠝꠥꠍꠣꠞꠦ ꠝꠣꠞꠤꠟꠔꠣ ꠌꠣꠁꠟꠣ। ꠅꠃ ꠡꠝꠄ ꠝꠥꠍꠣ ꠚꠦꠞꠣꠃꠘꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠜꠣꠉꠤ ꠉꠦꠟꠣ। ꠜꠣꠉꠤꠀ ꠝꠣꠖꠤꠀꠘ ꠖꠦꠡꠅ ꠛꠡꠔ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠀꠁꠟꠣ। ꠀꠁꠀ ꠢꠘꠞ ꠄꠇ ꠇꠥꠀꠞ ꠇꠣꠍꠣꠔ ꠛꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","ꠝꠣꠖꠤꠀꠘ ꠖꠦꠡꠅ ꠡꠥꠀꠁꠛ ꠘꠣꠝꠞ ꠄꠇ ꠁꠝꠣꠝ ꠍꠣꠛ ꠀꠍꠟꠣ। ꠔꠣꠘ ꠡꠣꠔꠎꠘ ꠙꠥꠠꠤꠘ ꠀꠍꠂꠘ। ꠅꠃ ꠙꠥꠠꠤꠘ꠆ꠔꠦ ꠇꠥꠀꠞ ꠙꠣꠞꠅ ꠀꠁꠀ, ꠔꠣꠞꠣꠞ ꠛꠣꠚꠞ ꠍꠣꠉꠟ-ꠝꠦꠠꠣꠞꠦ ꠙꠣꠘꠤ ꠈꠣꠅꠀꠘꠤꠞ ꠟꠣꠉꠤ ꠉꠣꠝꠟꠣ ꠜꠞꠣꠔ ꠟꠣꠉꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","ꠅꠃ ꠡꠝꠄ ꠅꠁꠘ꠆ꠘ ꠞꠣꠈꠣꠟ ꠅꠇꠟꠦ ꠔꠣꠞꠣꠞꠦ ꠈꠦꠖꠣꠁꠀ ꠖꠤꠟꠣꠁꠟ। ꠅꠁꠟꠦ ꠝꠥꠍꠣ ꠃꠛꠣꠁꠀ ꠔꠣꠞꠣꠞꠦ ꠡꠣꠁꠎ꠆ꠎ ꠇꠞꠟꠣ, ꠀꠞ ꠔꠣꠞꠣꠞ ꠙꠣꠟꠞꠦ ꠙꠣꠘꠤ ꠈꠣꠅꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","ꠔꠣꠞꠣ ꠔꠣꠞꠣꠞ ꠛꠣꠚꠞ ꠗꠣꠞꠅ ꠉꠤꠀ ꠢꠣꠞꠟꠦ ꠔꠣꠁꠘ ꠎꠤꠇꠣꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠀꠁꠎ ꠅꠔ ꠎꠟꠖꠤ ꠇꠦꠝꠘꠦ ꠀꠁꠟꠣꠄ?” ");
INSERT INTO syls_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","ꠔꠣꠞꠣ ꠇꠁꠟꠣ, “ꠄꠇ ꠝꠤꠡꠞꠤ ꠛꠦꠐꠣꠄ ꠀꠝꠞꠣꠞꠦ ꠞꠣꠈꠣꠟ ꠅꠇꠟꠞ ꠀꠔ ꠕꠣꠇꠤ ꠛꠣꠌꠣꠁꠍꠂꠘ। ꠄꠁꠘ ꠀꠝꠞꠣꠞ ꠍꠣꠉꠟ-ꠝꠦꠠꠣꠞꠦ ꠙꠣꠘꠤ ꠔꠥꠟꠤꠀ ꠈꠣꠅꠀꠁꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","ꠔꠦꠃ ꠔꠣꠁꠘ ꠎꠤꠇꠣꠁꠟꠣ, “ꠁ ꠝꠣꠘꠥꠡꠉꠥ ꠇꠥꠀꠁ? ꠔꠥꠝꠞꠣ ꠔꠣꠞꠦ ꠕꠁꠀ ꠀꠁꠟ꠆ꠟꠣꠄ ꠇꠦꠘꠦ? ꠄꠞꠦ ꠒꠣꠇꠤꠀ ꠀꠘꠤꠀ ꠈꠣꠘꠣ ꠈꠣꠅꠀꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","ꠄꠞꠛꠣꠖꠦ ꠝꠥꠍꠣꠄ ꠅꠃ ꠁꠝꠣꠝꠞ ꠛꠣꠠꠤꠔ ꠞꠁꠔꠦ ꠞꠣꠎꠤ ꠅꠁꠟꠣ। ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠔꠣꠘ ꠙꠥꠠꠤ ꠍꠚꠥꠞꠣꠞꠦ ꠝꠥꠍꠣꠞ ꠟꠉꠦ ꠡꠣꠖꠤ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","ꠛꠣꠖꠦ ꠍꠚꠥꠞꠣꠞ ꠊꠞꠅ ꠄꠇ ꠙꠥꠀ ꠅꠁꠟꠦ ꠝꠥꠍꠣꠄ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠔ ꠛꠂꠔꠟ ꠛꠘꠤꠀ ꠛꠤꠖꠦꠡꠅ ꠞꠁꠞꠣꠝ।” ꠄꠞꠟꠣꠉꠤ ꠅꠃ ꠙꠥꠀꠞ ꠘꠣꠝ ꠞꠣꠈꠟꠣ ꠎꠣꠞꠍꠥꠝ ꠝꠣꠘꠤ, ꠛꠂꠔꠟ। ");
INSERT INTO syls_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","ꠛꠃꠔ ꠖꠤꠘ ꠛꠣꠖꠦ ꠝꠤꠡꠞꠞ ꠛꠣꠖꠡꠣ ꠝꠞꠤꠉꠦꠟꠣ। ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠉꠥꠟꠣꠝꠤꠞ ꠟꠣꠉꠤ ꠇꠣꠔꠞ ꠅꠁꠀ ꠇꠣꠘ꠆ꠖꠣ-ꠇꠣꠐꠤ ꠇꠞꠟ। ꠔꠣꠞꠣꠞ ꠇꠣꠘ꠆ꠖꠘ ꠀꠟ꠆ꠟꠣꠞ ꠉꠦꠍꠦ ꠇꠛꠥꠟ ꠅꠁꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠞꠣꠞ ꠚꠞꠤꠀꠖ ꠢꠥꠘꠟꠣ। ꠔꠣꠁꠘ ꠁꠛ꠆ꠞꠣꠢꠤꠝ, ꠁꠍꠢꠣꠇ ꠀꠞ ꠁꠀꠇꠥꠛꠞ ꠟꠉꠦ ꠔꠣꠘ ꠅꠀꠖꠣꠞ ꠇꠕꠣ ꠁꠀꠖ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠛꠣꠄ ꠝꠥꠈ ꠚꠤꠞꠣꠁꠟꠣ, ꠖꠄꠀꠞ ꠘꠎꠞꠦ ꠔꠣꠞꠣꠞ ꠛꠣꠄ ꠌꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","ꠅꠃ ꠡꠝꠄ ꠝꠥꠍꠣꠄ ꠔꠣꠘ ꠢꠃꠞ ꠝꠣꠖꠤꠀꠘ ꠎꠣꠔꠤꠞ ꠁꠝꠣꠝ ꠍꠣꠛ ꠢꠎꠞꠔ ꠡꠥꠀꠁꠛꠞ ꠍꠣꠉꠟ-ꠝꠦꠠꠣ ꠞꠣꠈꠔꠣ। ꠄꠇꠖꠤꠘ ꠔꠣꠘ ꠍꠣꠉꠟꠞ ꠙꠣꠟ ꠟꠁꠀ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠢꠦꠡ ꠉꠣꠟꠣꠔ ꠀꠟ꠆ꠟꠣꠞ ꠢꠃ ꠔꠥꠞ ꠙꠣꠠꠞ ꠇꠣꠍꠣꠔ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","ꠢꠘꠅ ꠄꠇ ꠎꠋꠟꠣꠞ ꠝꠣꠎꠦ ꠝꠣꠛꠥꠖꠞ ꠚꠤꠞꠤꠡ꠆ꠔꠣꠄ ꠀꠉꠥꠘꠤꠞ ꠟꠣꠈꠣꠘ ꠘꠥꠞꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠔꠣꠘꠞꠦ ꠖꠦꠈꠣ ꠖꠤꠟꠣ। ꠝꠥꠍꠣꠄ ꠖꠦꠈꠟꠣ, ꠎꠋꠟꠣꠞ ꠝꠣꠎꠦ ꠀꠉꠥꠁꠘ ꠎꠟꠦꠞ ꠅꠁꠟꠦ ꠎꠋꠟꠣ ꠎꠟꠦꠞ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","ꠅꠃ ꠔꠣꠁꠘ ꠔꠣꠁꠎ꠆ꠎꠥꠛ ꠅꠁꠀ ꠇꠁꠟꠣ, “ꠎꠋꠟꠣ ꠎꠦ ꠎꠟꠦꠞ ꠘꠣ, ꠄꠞ ꠇꠣꠞꠘ ꠇꠤꠔꠣ? ꠔꠦ ꠀꠞꠅ ꠇꠣꠍꠣꠔ ꠉꠤꠀ ꠖꠦꠈꠤ ꠌꠣꠁꠘ।” ");
INSERT INTO syls_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","ꠀꠟ꠆ꠟꠣꠄ ꠎꠦꠛꠟꠣ ꠖꠦꠈꠟꠣ ꠄꠁꠘ ꠖꠦꠈꠣꠞ ꠟꠣꠉꠤ ꠇꠣꠍꠣꠔ ꠎꠣꠁꠞꠣꠉꠤ, ꠅꠃ ꠡꠝꠄ ꠔꠣꠁꠘ ꠎꠋꠟꠣꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠒꠣꠇꠤꠀ ꠇꠁꠟꠣ, “ꠝꠥꠍꠣ, ꠅ ꠝꠥꠍꠣ!” ꠝꠥꠍꠣꠄ ꠇꠁꠟꠣ, “ꠅꠃꠘꠥ ꠀꠝꠤ।” ");
INSERT INTO syls_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","ꠀꠟ꠆ꠟꠣꠄ ꠇꠁꠟꠣ, “ꠀꠞ ꠍꠣꠝꠘꠦ ꠀꠉꠥꠀꠁꠅ ꠘꠣ। ꠔꠥꠝꠣꠞ ꠙꠣꠅ ꠕꠣꠇꠤ ꠎꠥꠔꠣ ꠈꠥꠟꠤꠟꠣꠅ। ꠎꠣꠘ ꠘꠤ, ꠔꠥꠝꠤ ꠅꠈꠘ ꠎꠦ ꠎꠣꠉꠣꠔ ꠃꠛꠣꠁꠍ ꠁꠈꠣꠘ ꠙꠣꠇ ꠎꠣꠉꠣ। ");
INSERT INTO syls_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","ꠢꠥꠘꠅ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠣꠞ ꠛꠣꠚꠞ ꠝꠣꠛꠥꠖ, ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠝꠣꠛꠥꠖ, ꠁꠍꠢꠣꠇꠞ ꠝꠣꠛꠥꠖ ꠀꠞ ꠁꠀꠇꠥꠛꠞ ꠝꠣꠛꠥꠖ।” ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀꠃ ꠝꠥꠍꠣꠄ ꠔꠣꠘ ꠝꠥꠈ ꠟꠥꠇꠣꠁꠟ꠆ꠟꠣ। ꠀꠟ꠆ꠟꠣꠞ ꠛꠣꠄ ꠌꠣꠁꠔꠦ ꠔꠣꠘ ꠖꠤꠟꠅ ꠒꠞ ꠢꠣꠝꠣꠁꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","ꠝꠣꠛꠥꠖꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠀꠝꠣꠞ ꠛꠘ꠆ꠖꠣ ꠅꠇꠟꠞ ꠖꠥꠈ-ꠝꠍꠤꠛꠔ ꠖꠦꠈꠤꠀꠞ। ꠝꠤꠡꠞꠤ ꠡꠞ꠆ꠖꠣꠞ ꠅꠇꠟꠞ ꠎꠥꠟꠥꠝꠞ ꠟꠣꠉꠤ ꠔꠣꠞꠣꠞ ꠇꠣꠘ꠆ꠖꠘ ꠢꠥꠘꠤꠀꠞ। ꠔꠣꠞꠣꠞ ꠖꠥꠈ-ꠇꠡ꠆ꠐ ꠢꠇꠟꠔꠣ ꠀꠝꠤ ꠖꠦꠈꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","ꠖꠦꠈꠤꠀ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠀꠔ ꠕꠣꠇꠤ ꠔꠣꠞꠣꠞꠦ ꠛꠣꠌꠣꠁꠔꠣꠝ ꠇꠞꠤ ꠀꠝꠤ ꠘꠤꠎꠦ ꠟꠣꠝꠤꠀ ꠀꠁꠍꠤ। ꠔꠦ ꠀꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠢꠞꠣꠁꠀ ꠘꠤꠝꠥꠉꠤ। ꠘꠤꠀ ꠞꠡꠣꠁꠟ ꠎꠝꠤꠞ ꠛꠃꠔ ꠛꠠ ꠡꠥꠘ꠆ꠖꠞ ꠄꠇ ꠖꠦꠡ ꠖꠤꠝꠥ। ꠁꠈꠣꠘ ꠖꠥꠗ ꠀꠞ ꠝꠃꠞ ꠜꠣꠘ꠆ꠒꠣꠞ ꠀꠟꠣ ꠖꠦꠡ। ꠅꠃ ꠖꠦꠡ ꠅꠁꠟ ꠅꠈꠘꠇꠥꠞ ꠇꠦꠘꠣꠘꠤ, ꠢꠤꠐ꠆ꠐꠤ, ꠀꠝꠥꠞꠤ, ꠚꠣꠞꠤꠎꠤ, ꠢꠤꠛ꠆ꠛꠤ ꠀꠞ ꠎꠤꠛꠥꠎꠤ ꠅꠇꠟꠞ ꠖꠦꠡ। ");
INSERT INTO syls_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠚꠞꠤꠀꠖ ꠀꠝꠣꠞ ꠖꠞꠛꠣꠞꠅ ꠀꠁꠍꠦ, ꠝꠤꠡꠞꠤ ꠅꠇꠟꠦ ꠔꠣꠞꠣꠞꠦ ꠎꠦꠟꠣ ꠍꠣꠔꠣꠁꠞꠣ, ꠁꠔꠣ ꠀꠝꠤ ꠖꠦꠈꠤꠀꠞ। ");
INSERT INTO syls_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ꠄꠞꠟꠣꠉꠤ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠚꠦꠞꠣꠃꠘꠞ ꠉꠦꠍꠦ ꠙꠣꠑꠣꠁꠀꠞ। ꠔꠥꠝꠤ ꠎꠣꠅ, ꠉꠤꠀ ꠀꠝꠣꠞ ꠛꠘ꠆ꠖꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤꠀ ꠀꠘꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","ꠝꠥꠍꠣꠄ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠀꠝꠤ ꠀꠞꠇ ꠎꠘ ꠇꠦ, ꠎꠦꠁꠘ ꠚꠦꠞꠣꠃꠘꠞ ꠍꠣꠝꠘꠦ ꠉꠤꠀ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠔꠣꠞꠣꠞꠦ ꠢꠞꠣꠁꠔꠣꠝ ꠙꠣꠞꠝꠥ?” ");
INSERT INTO syls_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","ꠀꠟ꠆ꠟꠣꠄ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠔ ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠟꠉꠦ ꠞꠁꠝꠥ। ꠔꠥꠝꠤ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠝꠣꠘꠡꠞꠦ ꠢꠞꠣꠁꠀ ꠀꠘꠤꠀ, ꠔꠣꠞꠣꠞꠦ ꠟꠁꠀ ꠅꠃ ꠙꠣꠠꠅ ꠀꠝꠣꠞ ꠄꠛꠣꠖꠔ ꠇꠞꠛꠣꠄ। ꠔꠦꠃ ꠛꠥꠎꠛꠣꠄ ꠀꠝꠤꠃ ꠔꠥꠝꠣꠞꠦ ꠙꠣꠑꠣꠁꠍꠤ।” ");
INSERT INTO syls_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","ꠝꠥꠍꠣꠄ ꠀꠞꠎ ꠇꠞꠟꠣ, “ꠖꠦꠈꠃꠇ꠆ꠇꠣ, ꠀꠝꠤ ꠎꠦꠛꠟꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠉꠤꠀ ꠇꠁꠝꠥ, ꠔꠥꠝꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞꠦ ꠙꠣꠑꠣꠁꠍꠂꠘ, ꠅꠃ ꠡꠝꠄ ꠔꠣꠞꠣ ꠎꠥꠖꠤ ꠎꠤꠇꠣꠁꠘ ꠔꠣꠘ ꠘꠣꠝ ꠇꠤꠔꠣ, ꠔꠦ ꠔꠣꠞꠣꠞꠦ ꠇꠤꠔꠣ ꠎꠥꠀꠙ ꠖꠤꠔꠣꠝ?” ");
INSERT INTO syls_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","ꠀꠟ꠆ꠟꠣꠄ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠎꠦꠁꠘ ꠀꠍꠤ, ꠀꠍꠤꠃ। ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠅꠃꠟꠣ ꠇꠁꠅ, ꠎꠦꠘ ꠘꠣꠝ ‘ꠀꠝꠤ ꠀꠍꠤ’ ꠔꠣꠁꠘ ꠀꠝꠣꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠉꠦꠍꠦ ꠙꠣꠑꠣꠁꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","ꠔꠣꠁꠘ ꠀꠞꠅ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠉꠤꠀ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠅ, ‘ꠢꠃ ꠀꠟ꠆ꠟꠣ ꠎꠦꠁꠘ ꠢꠞ-ꠢꠣꠝꠦꠡꠣ ꠀꠍꠂꠘ, ꠄꠁꠘ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠝꠣꠛꠥꠖ, ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠝꠣꠛꠥꠖ, ꠁꠍꠢꠣꠇꠞ ꠝꠣꠛꠥꠖ ꠀꠞ ꠁꠀꠇꠥꠛꠞ ꠝꠣꠛꠥꠖ, ꠄꠁꠘꠃ ꠀꠝꠣꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠉꠦꠍꠦ ꠙꠣꠑꠣꠁꠍꠂꠘ।’ “ꠀꠝꠣꠞ ꠢꠞ-ꠢꠣꠝꠦꠡꠣꠇꠥꠞ ꠘꠣꠝ ‘ꠀꠝꠤ ꠎꠦꠁꠘ ꠀꠍꠤ’। ꠎꠥꠉꠦ ꠎꠥꠉꠦ, ꠙꠥꠞꠥꠡꠦ ꠙꠥꠞꠥꠡꠦ ꠅꠃ ꠘꠣꠝ ꠇꠣꠁꠝ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","ꠔꠥꠝꠤ ꠎꠣꠅ, ꠉꠤꠀ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟꠞꠦ ꠄꠇꠈꠣꠘꠅ ꠖꠟꠣ ꠇꠞꠤꠀ ꠇꠅ, ꠢꠃ ꠀꠟ꠆ꠟꠣ, ꠎꠦꠁꠘ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠝꠣꠛꠥꠖ, ꠁꠛ꠆ꠞꠣꠢꠤꠝ, ꠁꠍꠢꠣꠇ ꠀꠞ ꠁꠀꠇꠥꠛꠞ ꠝꠣꠛꠥꠖ, ꠔꠣꠁꠘ ꠀꠝꠣꠞꠦ ꠖꠤꠖꠣꠞ ꠖꠤꠀ ꠇꠁꠍꠂꠘ, ꠔꠣꠁꠘ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠄ ꠈꠤꠀꠟ ꠇꠞꠍꠂꠘ, ꠔꠥꠝꠞꠣꠞ ꠃꠙꠞꠞ ꠎꠥꠟꠥꠝ-ꠝꠍꠤꠛꠔ ꠖꠦꠈꠍꠂꠘ, ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠄ ꠎꠦꠔꠣ ꠇꠞꠣ ꠅꠞ ꠄꠅꠔꠣ ꠔꠣꠁꠘ ꠈꠤꠀꠟ ꠇꠞꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ꠅꠈꠘ ꠔꠣꠁꠘ ꠇꠁꠞꠣ, ꠝꠤꠡꠞꠞ ꠉꠥꠟꠣꠝꠤ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠛꠣꠌꠣꠁꠀ ꠇꠦꠘꠣꠘꠤ, ꠢꠤꠐ꠆ꠐꠤ, ꠀꠝꠥꠞꠤ, ꠚꠣꠞꠤꠎꠤ, ꠢꠤꠛ꠆ꠛꠤ ꠀꠞ ꠎꠤꠛꠥꠎꠤ ꠅꠇꠟꠞ ꠖꠥꠗ ꠀꠞ ꠝꠃꠞ ꠜꠣꠘ꠆ꠒꠣꠞ ꠀꠟꠣ ꠖꠦꠡꠅ ꠔꠣꠁꠘ ꠔꠥꠝꠞꠣꠞꠦ ꠘꠤꠛꠣꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","ꠀꠟ꠆ꠟꠣꠄ ꠀꠞꠅ ꠇꠁꠟꠣ, “ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟꠦ ꠔꠥꠝꠣꠞ ꠇꠕꠣ ꠢꠥꠘꠛꠣ, ꠔꠥꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠟꠉꠦ ꠟꠁꠀ ꠝꠤꠡꠞꠞ ꠛꠣꠖꠡꠣꠞ ꠉꠦꠍꠦ ꠎꠣꠁꠅ। ꠉꠤꠀ ꠇꠁꠅ, ‘ꠀꠟ꠆ꠟꠣ ꠎꠦꠁꠘ ꠁꠛꠞꠣꠘꠤ ꠅꠇꠟꠞ ꠝꠣꠛꠥꠖ, ꠔꠣꠁꠘ ꠀꠝꠣꠞꠦ ꠖꠞꠡꠘ ꠖꠤꠍꠂꠘ। ꠄꠞꠟꠣꠉꠤ ꠀꠝꠞꠣ ꠔꠣꠘ ꠘꠣꠝꠦ ꠄꠇꠈꠣꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠞꠔꠣꠝ ꠌꠣꠁꠀꠞ, ꠀꠝꠞꠣ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠛꠣꠄ ꠔꠤꠘ ꠖꠤꠘꠞ ꠙꠕ ꠉꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠝꠥ, ꠔꠦ ꠀꠝꠞꠣꠞꠦ ꠎꠣꠅꠀꠞ ꠅꠘꠥꠝꠔꠤ ꠖꠦꠃꠇ꠆ꠇꠣ।’ ");
INSERT INTO syls_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","ꠅꠁꠟꠦ ꠀꠝꠤ ꠎꠣꠘꠤ ꠝꠤꠡꠞꠞ ꠛꠣꠖꠡꠣꠄ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠣꠁꠔꠦ ꠖꠤꠔ ꠘꠣꠄ, ꠎꠥꠞ-ꠎꠛꠞꠖꠡ꠆ꠔꠤ ꠇꠞꠟꠦꠅ ꠖꠤꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","ꠔꠦꠃ ꠀꠝꠤ ꠀꠝꠣꠞ ꠇꠥꠖꠞꠔꠤ ꠀꠔ ꠟꠣꠉꠣꠁꠝꠥ ꠀꠞ ꠅꠃꠟꠣ ꠀꠌꠣꠘꠇ ꠉꠎꠛ ꠘꠣꠎꠤꠟ ꠇꠞꠝꠥ, ꠎꠣꠔꠦ ꠢꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠣꠁꠔꠦ ꠖꠦꠄ। ");
INSERT INTO syls_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","ꠀꠞ ꠀꠝꠤ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠖꠤꠟꠞ ꠝꠣꠎꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠛꠣꠄ ꠄꠝꠘ ꠄꠇ ꠖꠄꠀꠞ ꠜꠣꠛ ꠙꠄꠖꠣ ꠇꠞꠣꠁꠝꠥ, ꠄꠞꠣ ꠎꠣꠘꠥ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠈꠣꠟꠤ ꠀꠔꠦ ꠘꠣ ꠎꠣꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","ꠢꠇꠟ ꠁꠍꠞꠣꠁꠟꠤ ꠛꠦꠐꠤꠘ꠆ꠔꠦ ꠔꠣꠞꠣꠞ ꠀꠞꠤ-ꠚꠞꠤ ꠛꠣ ꠎꠦꠞꠣꠞ ꠛꠣꠠꠤꠔ ꠔꠣꠞꠣ ꠞꠂꠘ, ꠅꠃꠟꠣ ꠝꠤꠡꠞꠤ ꠛꠦꠐꠤꠘ꠆ꠔꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠔꠣꠞꠣꠞ ꠡꠥꠘꠣ-ꠞꠥꠙꠣꠞ ꠉꠄꠘꠣ-ꠉꠣꠐꠤ ꠀꠞ ꠜꠣꠟꠣ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠈꠥꠎꠤꠀ ꠘꠤꠅ। ꠅꠔꠣ ꠖꠤꠀ ꠔꠥꠝꠞꠣꠞ ꠙꠥꠀ-ꠙꠥꠠꠤꠘꠞꠦꠅ ꠢꠣꠎꠣꠁꠅ, ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠔꠥꠝꠞꠣ ꠝꠤꠡꠞꠤꠘ꠆ꠔꠞ ꠗꠘ-ꠍꠣꠝꠣꠘꠣ ꠖꠈꠟ ꠇꠞꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","ꠝꠥꠍꠣꠄ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠅ ꠝꠣꠛꠥꠖ, ꠔꠣꠞꠣ ꠎꠥꠖꠤ ꠀꠝꠣꠞꠦ ꠄꠇꠤꠘ ꠘꠣ ꠇꠞꠂꠘ, ꠀꠝꠣꠞ ꠝꠣꠔ ꠘꠣ ꠢꠥꠘꠂꠘ ꠛꠣ ꠔꠣꠞꠣ ꠎꠥꠖꠤ ꠇꠂꠘ, ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠣꠞꠦ ꠖꠞꠡꠘ ꠖꠤꠍꠂꠘ ꠘꠣ, ꠔꠦ ꠀꠝꠤ ꠇꠤꠔꠣ ꠇꠞꠔꠣꠝ?” ");
INSERT INTO syls_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","ꠔꠦꠃ ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠘꠦ ꠎꠤꠇꠣꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠀꠔꠅ ꠁꠉꠥ ꠇꠤꠔꠣ?” ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠄꠉꠥ ꠟꠣꠑꠤ।” ");
INSERT INTO syls_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","ꠀꠟ꠆ꠟꠣꠄ ꠇꠁꠟꠣ, “ꠅꠇꠐꠣ ꠝꠣꠐꠤꠔ ꠚꠣꠟꠣꠅ।” ꠝꠥꠍꠣꠄ ꠟꠣꠑꠤꠞꠦ ꠝꠣꠐꠤꠔ ꠚꠣꠟꠣꠁꠔꠦꠃ ꠁꠐꠣ ꠢꠣꠚ ꠅꠁꠉꠦꠟ। ꠢꠣꠚ ꠖꠦꠈꠤꠀꠃ ꠔꠣꠁꠘ ꠚꠣꠟꠖꠤ ꠢꠞꠤ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠘꠦ ꠢꠥꠇꠥꠝ ꠇꠞꠟꠣ, “ꠀꠔ ꠛꠣꠠꠣꠁꠀ ꠅꠉꠥꠞ ꠟꠦꠘ꠆ꠎꠅ ꠗꠞꠅ।” ꠀꠞ ꠔꠣꠁꠘ ꠗꠞꠣꠞ ꠟꠉꠦ ꠟꠉꠦ ꠅꠉꠥ ꠢꠤꠞꠛꠣꠞ ꠟꠣꠑꠤ ꠅꠁꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","ꠛꠣꠖꠦ ꠀꠟ꠆ꠟꠣꠄ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤꠅ ꠅꠃꠟꠣ ꠇꠞꠤꠅ, ꠔꠦꠃ ꠔꠣꠞꠣ ꠢꠣꠍꠣꠃ ꠄꠇꠤꠘ ꠇꠞꠛꠣ ꠔꠣꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠁꠘ꠆ꠔꠞ ꠝꠣꠛꠥꠖ, ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠝꠣꠛꠥꠖ, ꠁꠍꠢꠣꠇꠞ ꠝꠣꠛꠥꠖ ꠀꠞ ꠁꠀꠇꠥꠛꠞ ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠣꠞꠦ ꠖꠞꠡꠘ ꠖꠤꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","ꠀꠟ꠆ꠟꠣꠄ ꠀꠞꠅ ꠇꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠀꠔ ꠔꠥꠝꠣꠞ ꠌꠣꠖ꠆ꠖꠞꠞ ꠔꠟꠦ ꠢꠣꠞꠣꠅ।” ꠔꠣꠁꠘ ꠀꠔ ꠢꠣꠞꠣꠁꠟꠣ, ꠀꠞ ꠛꠣꠞ ꠇꠞꠣꠞ ꠛꠣꠖꠦꠃ ꠔꠣꠘ ꠀꠔ ꠇꠥꠡ꠆ꠑ-ꠗꠟꠛꠦꠖꠣ ꠛꠦꠝꠣꠞꠦ ꠖꠥꠗꠞ ꠟꠣꠈꠣꠘ ꠗꠟꠣ ꠅꠁꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","ꠀꠟ꠆ꠟꠣꠄ ꠇꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠀꠔ ꠢꠤꠞꠛꠣꠞ ꠢꠘꠅ ꠢꠣꠞꠣꠅ।” ꠔꠣꠁꠘ ꠢꠣꠞꠣꠁꠟꠣ ꠀꠞ ꠌꠣꠖ꠆ꠖꠞꠞ ꠔꠟ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤꠀ ꠖꠦꠈꠂꠘ, ꠀꠉꠞ ꠟꠣꠈꠣꠘ ꠜꠣꠟꠣ ꠅꠁꠉꠦꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","ꠀꠟ꠆ꠟꠣꠄ ꠇꠁꠟꠣ, “ꠔꠣꠞꠣ ꠎꠥꠖꠤ ꠔꠥꠝꠣꠞꠦ ꠄꠇꠤꠘ ꠘꠣ ꠇꠞꠂꠘ, ꠔꠦ ꠔꠥꠝꠣꠞ ꠟꠣꠑꠤꠞꠦ ꠢꠣꠚ ꠅꠀ ꠖꠦꠈꠟꠦ ꠄꠇꠤꠘ ꠇꠞꠛꠣ, ꠀꠞ ꠄꠅꠐꠣꠄ ꠄꠇꠤꠘ ꠘꠣ ꠇꠞꠟꠦ ꠔꠥꠝꠣꠞ ꠀꠔꠞ ꠛꠦꠝꠣꠞꠞ ꠇꠦꠞꠣꠝꠔꠤ ꠖꠦꠈꠟꠦ ꠔꠣꠞꠣ ꠄꠇꠤꠘ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","ꠀꠞ ꠎꠥꠖꠤ ꠁ ꠖꠥꠁꠅ ꠇꠦꠞꠣꠝꠔꠤꠄꠅ ꠄꠇꠤꠘ ꠘꠣ ꠇꠞꠂꠘ, ꠔꠥꠝꠣꠞ ꠇꠕꠣ ꠘꠣ ꠝꠣꠘꠂꠘ, ꠔꠦ ꠔꠥꠝꠤ ꠘꠤꠟ ꠘꠖ ꠕꠣꠇꠤ ꠕꠥꠠꠣ ꠙꠣꠘꠤ ꠀꠘꠤꠀ ꠢꠥꠇꠘꠣ ꠝꠣꠐꠤꠔ ꠚꠣꠟꠣꠁꠅ, ꠖꠦꠈꠛꠣꠄ ꠝꠣꠐꠤꠔ ꠙꠠꠤꠀꠃ ꠁ ꠙꠣꠘꠤ ꠟꠃ ꠅꠁꠎꠤꠛ।” ");
INSERT INTO syls_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","ꠅꠃ ꠝꠥꠍꠣꠄ ꠝꠣꠛꠥꠖꠞꠦ ꠇꠁꠟꠣ, “ꠅ ꠝꠣꠟꠤꠇ, ꠀꠝꠤ ꠔ ꠜꠣꠟꠣ ꠇꠞꠤ ꠝꠣꠔ-ꠇꠕꠣꠃ ꠝꠣꠔꠔꠣꠝ ꠙꠣꠞꠤ ꠘꠣ, ꠀꠉꠦꠅ ꠙꠣꠞꠔꠣꠝ ꠘꠣ ꠀꠞ ꠀꠙꠘꠦ ꠁ ꠉꠥꠟꠣꠝꠞ ꠟꠉꠦ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠣꠞ ꠛꠣꠖꠦꠅ ꠙꠣꠞꠤ ꠘꠣ, ꠀꠝꠣꠞ ꠔ ꠎꠤꠚꠞꠣ ꠛꠣꠠꠥꠀ।” ");
INSERT INTO syls_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","ꠀꠟ꠆ꠟꠣꠄ ꠇꠁꠟꠣ, “ꠝꠣꠘꠡꠞ ꠝꠥꠈ ꠇꠦ ꠛꠣꠘꠣꠁꠍꠦ, ꠀꠝꠤ ꠘꠣꠄ ꠘꠤ? ꠇꠦ ꠝꠣꠘꠡꠞꠦ ꠛꠥꠛꠣ, ꠈꠣꠟꠥꠀ ꠛꠣ ꠀꠘ꠆ꠖꠣ ꠛꠣꠘꠣꠁꠘ? ꠌꠃꠈꠦ ꠖꠦꠈꠣꠞ ꠟꠣꠉꠤ ꠌꠈꠥꠞ ꠙꠣꠅꠀꠞ ꠇꠦ ꠖꠦꠁꠘ? ꠁꠔꠣ ꠔ ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠄꠃ ꠖꠦꠁ ꠘꠣ ꠘꠤ? ");
INSERT INTO syls_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","ꠔꠦ ꠔꠥꠝꠤ ꠎꠣꠅ, ꠉꠤꠀ ꠇꠤꠔꠣ ꠝꠣꠔꠤꠔꠣꠄ ꠀꠝꠤ ꠢꠤꠇꠣꠁꠀ ꠖꠤꠝꠥ। ꠔꠥꠝꠣꠞ ꠝꠥꠈꠞ ꠎꠛꠣꠘꠞꠦ ꠀꠝꠤ ꠡꠣꠁꠎ꠆ꠎ ꠇꠞꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠅ ꠝꠣꠟꠤꠇ, ꠀꠝꠤ ꠝꠤꠘꠔ ꠇꠞꠤꠀꠞ, ꠅꠁꠘ꠆ꠘ ꠇꠦꠃꠞꠞꠦ ꠙꠣꠑꠣꠁ ꠖꠦꠃꠇ꠆ꠇꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","ꠅꠃ ꠝꠥꠍꠣꠞ ꠃꠙꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠉꠥꠍꠣ ꠃꠑꠟ। ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠜꠣꠁ ꠢꠣꠞꠥꠘ ꠛꠤꠘ ꠟꠦꠛꠤ ꠀꠍꠦ ꠘꠣ ꠘꠤ? ꠀꠝꠤ ꠎꠣꠘꠤ, ꠢꠦ ꠜꠣꠟꠣ ꠛꠇ꠆ꠔꠤꠔꠣ ꠖꠤꠔ ꠙꠣꠞꠦ। ꠢꠦ ꠅꠈꠘ ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠖꠦꠈꠣ ꠇꠞꠣꠔ ꠀꠞ, ꠔꠥꠝꠣꠞꠦ ꠖꠦꠈꠤꠀ ꠢꠦ ꠈꠥꠛ ꠈꠥꠡꠤ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","ꠔꠥꠝꠤ ꠢꠤꠇꠣꠁꠀ ꠖꠤꠅ ꠀꠞ ꠇꠁꠅ ꠢꠦ ꠇꠤꠔꠣ ꠝꠣꠔꠤꠔ। ꠀꠝꠤ ꠔꠥꠝꠞꠣ ꠖꠥꠁꠅꠎꠘꠞ ꠝꠥꠈꠞ ꠎꠛꠣꠘꠞꠦ ꠡꠣꠁꠎ꠆ꠎ ꠇꠞꠝꠥ। ꠀꠞ ꠢꠘꠅ ꠉꠤꠀ ꠇꠤꠔꠣ ꠇꠞꠔꠣꠄ ꠀꠝꠤ ꠢꠤꠇꠣꠁꠀ ꠖꠤꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","ꠔꠥꠝꠣꠞ ꠜꠣꠁ ꠢꠣꠞꠥꠘꠞ ꠝꠥꠈ ꠅꠁꠛ ꠔꠥꠝꠣꠞ ꠝꠥꠈ, ꠢꠦ ꠔꠥꠝꠣꠞ ꠅꠁꠀ ꠝꠣꠘꠡꠞ ꠟꠉꠦ ꠝꠣꠔꠤꠛ। ꠙꠦꠉꠣꠝ꠆ꠛꠞ ꠅꠇꠟꠦ ꠎꠦꠟꠣ ꠀꠟ꠆ꠟꠣꠞ ꠇꠣꠟꠣꠝ ꠇꠂꠘ, ꠢꠣꠞꠥꠘꠦ ꠅꠃꠟꠣ ꠔꠥꠝꠣꠞ ꠛꠥꠟꠤ ꠇꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","ꠅꠃ ꠟꠣꠑꠤ ꠔꠥꠝꠣꠞ ꠀꠔꠅ ꠞꠣꠈꠤꠅ, ꠁꠐꠣ ꠖꠤꠀ ꠢꠃ ꠇꠦꠞꠣꠝꠔꠤ-ꠝꠥꠎꠦꠎꠣ ꠅꠇꠟ ꠎꠣꠁꠞ ꠇꠞꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","19","ꠝꠣꠖꠤꠀꠘ ꠖꠦꠡꠅ ꠕꠣꠇꠔꠦꠃ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠢꠥꠇꠥꠝ ꠇꠞꠍꠟꠣ, “ꠔꠥꠝꠤ ꠝꠤꠡꠞꠅ ꠎꠣꠅꠉꠤ, ꠇꠣꠞꠘ ꠝꠤꠡꠞꠞ ꠎꠦꠔꠣ ꠝꠣꠘꠡꠦ ꠔꠥꠝꠣꠞꠦ ꠈꠥꠘ ꠇꠞꠔꠣ ꠌꠣꠁꠍꠟꠣ, ꠁꠔꠣ ꠅꠈꠘ ꠝꠞꠤ ꠉꠦꠍꠂꠘ।” ꠔꠦꠃ ꠝꠥꠍꠣꠄ ꠔꠣꠘ ꠢꠃꠞ ꠡꠥꠀꠁꠛꠞ ꠇꠣꠍꠣꠔ ꠉꠤꠀ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠀꠝꠣꠞ ꠎꠘꠝ ꠝꠣꠐꠤ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠎꠣꠁꠔꠣꠝ ꠌꠣꠁꠞꠣꠝ, ꠀꠝꠣꠞ ꠈꠦꠡ-ꠇꠥꠐꠥꠝ ꠅꠇꠟ ꠎꠤꠔꠣ ꠀꠍꠂꠘ ꠇꠤ ꠘꠣ, ꠔꠣꠞꠣꠞ ꠢꠣꠟ-ꠢꠇꠤꠇꠔ ꠖꠦꠈꠣꠔ ꠎꠣꠁꠔꠣꠝ, ꠔꠦ ꠀꠝꠣꠞꠦ ꠎꠣꠅꠀꠞ ꠅꠘꠥꠝꠔꠤ ꠖꠦꠃꠇ꠆ꠇꠣ।” ꠢꠃꠞꠦ ꠇꠁꠟꠣ, “ꠀꠁꠌ꠆ꠍꠣ, ꠍꠢꠤ-ꠍꠣꠟꠣꠝꠔꠦ ꠎꠣꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","ꠅꠃ ꠝꠥꠍꠣꠄ ꠔꠣꠘ ꠛꠤꠛꠤ ꠀꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠉꠣꠗꠣꠞ ꠃꠙꠞꠦ ꠌꠠꠣꠁꠀ ꠝꠤꠡꠞꠞ ꠙꠕꠦ ꠞꠅꠀꠘꠣ ꠅꠁꠟꠣ। ꠔꠣꠘ ꠀꠔꠅ ꠀꠟ꠆ꠟꠣꠁ ꠇꠦꠞꠣꠝꠔꠤꠞ ꠢꠃ ꠟꠣꠑꠤ ꠞꠣꠈꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","ꠀꠟ꠆ꠟꠣꠄ ꠝꠥꠍꠣꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠟꠣ, “ꠔꠥꠝꠤ ꠝꠤꠡꠞꠅ ꠉꠤꠀ ꠢꠣꠞꠟꠦ ꠀꠝꠣꠞ ꠖꠦꠅꠀ ꠇꠦꠞꠣꠝꠔꠤ ꠅꠇꠟ ꠚꠦꠞꠣꠃꠘꠞ ꠍꠣꠝꠘꠦ ꠖꠦꠈꠣꠁꠅ, ꠅꠁꠟꠦ ꠀꠝꠤ ꠔꠣꠞ ꠖꠤꠟꠞꠦ ꠙꠣꠡꠣꠘ ꠛꠣꠘꠣꠁꠟꠤꠝꠥ, ꠢꠦ ꠝꠣꠘꠡꠞꠦ ꠍꠣꠠꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","ꠔꠥꠝꠤ ꠚꠦꠞꠣꠃꠘꠞꠦ ꠇꠁꠅ, ꠝꠣꠛꠥꠖꠦ ꠘꠤꠎꠦ ꠇꠁꠍꠂꠘ, ‘ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠔ ꠀꠝꠣꠞ ꠙꠄꠟꠣ ꠙꠥꠔꠞ ꠟꠣꠈꠣꠘ। ");
INSERT INTO syls_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","ꠀꠝꠤ ꠘꠤꠎꠦ ꠔꠥꠝꠣꠞꠦ ꠢꠥꠇꠥꠝ ꠇꠞꠍꠟꠣꠝ, ꠀꠝꠣꠞ ꠄꠛꠣꠖꠔꠅ ꠎꠣꠁꠔꠣ ꠇꠞꠤ ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠙꠥꠔꠞꠦ ꠍꠣꠠꠤ ꠖꠤꠔꠣꠄ, ꠅꠁꠟꠦ ꠔꠥꠝꠤ ꠝꠣꠘꠍ ꠘꠣ। ꠄꠞꠖꠣꠄ ꠀꠝꠤꠅ ꠔꠥꠝꠣꠞ ꠙꠄꠟꠣ ꠙꠥꠔꠞꠦ ꠝꠣꠞꠤꠟꠤꠝꠥ।’ ” ");
INSERT INTO syls_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","ꠛꠣꠖꠦ ꠝꠤꠡꠞꠅ ꠎꠣꠅꠀꠞ ꠙꠕꠅ ꠞꠣꠁꠔ ꠇꠣꠐꠣꠁꠛꠣꠞ ꠎꠣꠉꠣꠔ ꠀꠁꠟꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠝꠣꠞꠤꠟꠤꠔꠣ ꠇꠞꠤ ꠝꠥꠈꠣꠝꠥꠈꠤ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","ꠅꠁꠟꠦ ꠔꠣꠘ ꠛꠤꠛꠤ ꠍꠚꠥꠞꠣꠄ ꠄꠇꠈꠣꠘ ꠗꠣꠞꠣꠁꠟ ꠙꠣꠔ꠆ꠔꠞ ꠟꠁꠀ ꠔꠣꠘ ꠙꠥꠀꠞ ꠝꠍꠟꠝꠣꠘꠤ ꠇꠞꠣꠁꠟ꠆ꠟꠣ ꠀꠞ ꠅꠇꠐꠣ ꠔꠣꠘ ꠎꠣꠝꠣꠁ ꠝꠥꠍꠣꠞ ꠙꠣꠅꠞ ꠝꠣꠎꠦ ꠍꠥꠀꠁꠀ ꠇꠁꠟꠣ, “ꠟꠃꠞ ꠛꠖꠟꠣ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠎꠣꠝꠣꠁ ꠢꠤꠡꠣꠛꠦ ꠙꠣꠁꠍꠤ।” ");
INSERT INTO syls_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","ꠔꠦꠃ ꠝꠥꠍꠣꠞꠦ ꠝꠣꠛꠥꠖꠦ ꠍꠣꠠꠤꠖꠤꠟꠣ। ꠝꠍꠟꠝꠣꠘꠤ ꠇꠣꠝꠞ ꠛꠦꠙꠣꠞꠦ ꠍꠚꠥꠞꠣꠄ ꠔ ꠅꠃ ꠇꠕꠣꠃ ꠇꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","ꠄꠞꠝꠣꠎꠦ ꠝꠣꠛꠥꠖꠦ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠉꠤꠀ ꠝꠥꠍꠣꠞ ꠟꠉꠦ ꠖꠦꠈꠣ ꠇꠞꠅ।” ꠅꠃ ꠔꠣꠁꠘ ꠉꠦꠟꠣ ꠀꠞ ꠀꠟ꠆ꠟꠣꠞ ꠙꠣꠠ ꠔꠥꠞꠞ ꠉꠦꠍꠦ ꠀꠁꠀ ꠝꠥꠍꠣꠞꠦ ꠙꠣꠁꠀ ꠌꠥꠝꠣ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠎꠦꠔꠣ ꠎꠦꠔꠣ ꠇꠁꠛꠣꠞ ꠟꠣꠉꠤ ꠝꠥꠍꠣꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠝꠥꠍꠣꠄ ꠁꠔꠣ ꠢꠇ꠆ꠇꠟꠔꠣ ꠢꠣꠞꠥꠘꠞꠦ ꠎꠣꠘꠣꠁꠟꠣ। ꠝꠣꠛꠥꠖꠦ ꠎꠔ ꠟꠣꠈꠣꠘ ꠇꠦꠞꠣꠝꠔꠤ-ꠝꠥꠎꠦꠎꠣ ꠖꠦꠈꠣꠘꠤꠞ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠂꠘ, ꠁꠔꠣ ꠢꠇꠟꠔꠣꠃ ꠔꠣꠁꠘ ꠢꠣꠞꠥꠘꠞꠦ ꠛꠥꠎꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","ꠛꠣꠖꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠉꠤꠀ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠢꠇꠟ ꠝꠥꠞꠛ꠆ꠛꠤꠞꠦ ꠖꠟꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠎꠔꠔꠣ ꠇꠁꠍꠟꠣ, ꠢꠣꠞꠥꠘꠦ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠔꠣꠞꠣꠞꠦ ꠎꠣꠘꠣꠁꠟꠣ, ꠀꠞ ꠢꠃ ꠇꠦꠞꠣꠝꠔꠤ ꠅꠇꠟꠅ ꠝꠣꠘꠡꠞ ꠍꠣꠝꠘꠦ ꠖꠦꠈꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ꠄꠞꠟꠣꠉꠤ ꠝꠣꠘꠡꠦ ꠁꠔꠣ ꠄꠇꠤꠘ ꠇꠞꠟꠣ। ꠔꠣꠞꠣ ꠎꠦꠛꠟꠣ ꠢꠥꠘꠟꠣ, ꠝꠣꠛꠥꠖꠦ ꠔꠣꠞꠣꠞ ꠛꠣꠄ ꠈꠤꠀꠟ ꠇꠞꠍꠂꠘ, ꠔꠣꠞꠣꠞ ꠃꠙꠞꠞ ꠎꠥꠟꠥꠝ-ꠝꠍꠤꠛꠔ ꠖꠦꠈꠍꠂꠘ, ꠅꠃ ꠔꠣꠞꠣ ꠔꠣꠘꠞꠦ ꠍꠁꠎꠖꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠦ ꠉꠤꠀ ꠚꠦꠞꠣꠃꠘꠞꠦ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖ, ꠎꠦꠁꠘ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠀꠟ꠆ꠟꠣ, ꠔꠣꠁꠘ ꠘꠤꠎꠦ ꠇꠁꠍꠂꠘ, ꠀꠝꠣꠞ ꠛꠘ꠆ꠖꠣ ꠅꠇꠟꠞꠦ ꠔꠥꠝꠤ ꠍꠣꠠꠤ ꠖꠦꠅ, ꠀꠝꠣꠞ ꠘꠣꠝꠦ ꠢꠎ ꠇꠞꠣꠞ ꠟꠣꠉꠤ, ꠔꠣꠞꠣ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠢꠤꠎꠞꠔ ꠇꠞꠔꠦ ꠅꠁꠛ, ꠔꠥꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠍꠣꠠꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","ꠚꠦꠞꠣꠃꠘꠦ ꠎꠥꠀꠙ ꠖꠤꠟ, “ꠁ ꠝꠣꠛꠥꠖ ꠀꠞꠇ ꠎꠘ ꠇꠦ, ꠎꠦꠘ ꠢꠥꠇꠥꠝ ꠝꠣꠘꠤꠀ ꠀꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠍꠣꠠꠤ ꠖꠤꠔꠣꠝ? ꠁꠟꠣ ꠇꠥꠘꠥ ꠝꠣꠛꠥꠖꠞꠦ ꠀꠝꠤ ꠌꠤꠘꠤ ꠘꠣ, ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦꠅ ꠀꠝꠤ ꠍꠣꠠꠔꠣꠝ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","ꠔꠣꠞꠣ ꠇꠁꠟꠣ, “ꠁꠛꠞꠣꠘꠤ ꠅꠇꠟꠞ ꠀꠟ꠆ꠟꠣꠄ ꠀꠝꠞꠣꠞꠦ ꠖꠞꠡꠘ ꠖꠤꠍꠂꠘ। ꠄꠞꠟꠣꠉꠤ ꠀꠝꠞꠣ ꠝꠤꠘꠔ ꠇꠞꠤꠀꠞ ꠀꠝꠞꠣꠞꠦ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠛꠣꠄ ꠔꠤꠘ ꠖꠤꠘꠞ ꠙꠕ ꠉꠤꠀ, ꠀꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠞꠔꠦ ꠖꠦꠃꠇ꠆ꠇꠣ, ꠀꠞꠘꠣꠄ ꠔꠣꠁꠘ ꠀꠝꠞꠣꠞꠦ ꠉꠎꠛꠤ ꠛꠦꠝꠣꠞ ꠖꠤꠀ ꠛꠣ ꠎꠥꠖ꠆ꠖꠞ ꠝꠣꠎꠦ ꠚꠣꠟꠣꠁꠀ ꠝꠣꠞꠤꠟꠣꠁꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","ꠝꠤꠡꠞꠞ ꠛꠣꠖꠡꠣꠄ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠅ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘ, ꠔꠥꠝꠞꠣ ꠝꠣꠘꠡꠞꠦ ꠇꠦꠘꠦ ꠇꠣꠝꠅ ꠕꠣꠇꠤ ꠚꠤꠞꠣꠁꠞꠣꠄ? ꠎꠣꠅ, ꠔꠥꠝꠞꠣꠅ ꠉꠤꠀ ꠇꠣꠝꠅ ꠟꠣꠉꠅ। ");
INSERT INTO syls_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","ꠖꠦꠈꠞꠣꠄ ꠘꠤ, ꠖꠦꠡꠅ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠘꠥꠡ ꠛꠃꠔ ꠛꠣꠠꠤꠉꠦꠍꠂꠘ, ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠁ ꠙꠣꠁꠀ ꠁꠔꠣꠄ ꠇꠥꠘꠥ ꠇꠣꠝ ꠇꠞꠞꠣ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","ꠅꠃ ꠚꠦꠞꠣꠃꠘꠦ ꠢꠃ ꠖꠤꠘꠃ ꠝꠤꠡꠞꠤ ꠎꠣꠟꠤꠝ ꠡꠞ꠆ꠖꠣꠞ ꠀꠞ ꠁꠛꠞꠣꠘꠤ ꠍꠥꠛꠦꠖꠣꠞ ꠅꠇꠟꠞꠦ ꠢꠥꠇꠥꠝ ꠇꠞꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“ꠁꠐ ꠛꠣꠘꠣꠁꠛꠣꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠞꠣ ꠝꠣꠘꠡꠞꠦ ꠀꠉꠞ ꠟꠣꠈꠣꠘ ꠈꠦꠞ-ꠘꠦꠞꠣ ꠀꠘꠤꠀ ꠖꠤꠅ ꠘꠣ, ꠔꠣꠞꠣ ꠉꠤꠀ ꠁꠔꠣ ꠎꠥꠉꠣꠠ ꠇꠞꠃꠇ। ");
INSERT INTO syls_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ꠅꠁꠟꠦ ꠀꠉꠦ ꠔꠣꠞꠣ ꠎꠔꠈꠣꠘ ꠁꠐ ꠛꠣꠘꠣꠁꠔ ꠅꠈꠘꠅ ꠅꠔꠈꠣꠘ ꠛꠣꠘꠣꠁꠔꠦ ꠅꠁꠛ, ꠄꠇꠈꠣꠘꠅ ꠇꠝ ꠅꠁꠔ ꠘꠣꠄ। ꠁꠔꠣ ꠀꠟꠡꠤꠀ ꠅꠁꠉꠦꠍꠂꠘ ꠇꠞꠤ, ꠅꠘꠅ ꠀꠁꠀ ꠔꠣꠞꠣꠞ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠞꠔꠣ ꠇꠁꠀ ꠌꠤꠟ꠆ꠟꠣꠁꠞꠣ। ");
INSERT INTO syls_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","ꠔꠥꠝꠞꠣ ꠔꠣꠞꠣꠞꠦ ꠀꠞꠅ ꠇꠡ꠆ꠐꠞ ꠇꠣꠝꠅ ꠟꠣꠉꠣꠅ, ꠔꠦꠃ ꠁꠔꠣꠄ ꠇꠥꠘꠥ ꠟꠣꠈꠣꠘ ꠛꠣꠎꠦ ꠝꠣꠔ ꠘꠣ ꠢꠥꠘꠤꠀ ꠇꠣꠝꠞ ꠝꠣꠎꠦ ꠝꠘ ꠖꠤꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","ꠅꠃ ꠢꠤ ꠡꠞ꠆ꠖꠣꠞ ꠀꠞ ꠍꠥꠛꠦꠖꠣꠞ ꠅꠇꠟ ꠛꠣꠞ ꠅꠁ ꠉꠤꠀ ꠝꠣꠘꠡꠞꠦ ꠇꠁꠟꠣ, “ꠚꠦꠞꠣꠃꠘꠦ ꠇꠁꠍꠂꠘ, ꠅꠈꠘ ꠕꠣꠇꠤ ꠔꠣꠁꠘ ꠀꠞ ꠁꠐ ꠛꠣꠘꠣꠘꠤꠞ ꠈꠦꠞ ꠎꠥꠉꠣꠁ ꠖꠤꠔꠣ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","ꠔꠥꠝꠞꠣ ꠎꠦꠘ ꠕꠣꠇꠤ ꠙꠣꠞ ꠈꠦꠞ-ꠘꠦꠞꠣ ꠎꠥꠉꠣꠁꠅ, ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣꠞ ꠇꠣꠝ ꠇꠥꠘ꠆ꠔꠣꠃ ꠇꠝꠣꠁꠟ ꠅꠁꠔ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","ꠅꠃ ꠝꠣꠘꠡꠦ ꠈꠦꠞ-ꠘꠦꠞꠣ ꠔꠥꠇꠣꠁꠛꠣꠞ ꠟꠣꠉꠤ ꠢꠣꠞꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠍꠤꠔ꠆ꠞꠤ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","ꠀꠞ ꠡꠞ꠆ꠖꠣꠞ ꠅꠇꠟꠦ ꠛꠣꠞꠦ ꠛꠣꠞꠦ ꠔꠣꠉꠖꠣ ꠖꠤꠀ ꠇꠁꠟ, “ꠀꠉꠦ ꠈꠦꠞ ꠎꠥꠉꠣꠁꠀ ꠖꠦꠅꠀꠞ ꠛꠣꠟꠣ ꠔꠥꠝꠞꠣ ꠙꠞꠔꠦꠇ ꠖꠤꠘ ꠎꠔꠈꠣꠘ ꠁꠐ ꠛꠣꠘꠣꠁꠔꠣꠄ, ꠅꠈꠘꠅ ꠅꠔꠈꠣꠘ ꠛꠣꠘꠣꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ꠚꠦꠞꠣꠃꠘꠞ ꠎꠣꠟꠤꠝ ꠡꠞ꠆ꠖꠣꠞ ꠅꠇꠟꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠃꠙꠞꠦ ꠎꠦ ꠍꠥꠛꠦꠖꠣꠞ ꠟꠣꠉꠣꠁꠍꠤꠟ, ꠢꠃ ꠡꠞ꠆ꠖꠣꠞ ꠅꠇꠟ ꠀꠁꠀ ꠍꠥꠛꠦꠖꠣꠞ ꠅꠇꠟꠞꠦ ꠝꠣꠁꠞ-ꠗꠁꠞ ꠇꠞꠤꠀ ꠎꠤꠇꠣꠁꠟ, “ꠔꠥꠝꠞꠣ ꠀꠉꠦ ꠎꠔꠈꠣꠘ ꠁꠐ ꠖꠤꠔꠣꠄ, ꠅꠈꠘ ꠅꠔꠈꠣꠘ ꠖꠦꠅ ꠘꠣ ꠇꠦꠘꠦ?” ");
INSERT INTO syls_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","ꠅꠃ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠍꠥꠛꠦꠖꠣꠞ ꠅꠇꠟꠦ ꠀꠁꠀ ꠚꠦꠞꠣꠃꠘꠞ ꠉꠦꠍꠦ ꠘꠣꠟꠤꠡ ꠖꠤꠟꠣ, “ꠀꠙꠘꠣꠞ ꠁ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠞ ꠟꠉꠦ ꠁꠟꠣ ꠛꠦꠛꠢꠣꠞ ꠇꠦꠘꠦ ꠇꠞꠞꠣ? ");
INSERT INTO syls_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","ꠡꠞ꠆ꠖꠣꠞ ꠅꠇꠟꠦ ꠀꠝꠞꠣꠞꠦ ꠈꠦꠞ-ꠘꠦꠞꠣ ꠎꠥꠉꠣꠁ ꠖꠦꠁꠘ ꠘꠣ, ꠔꠣ-ꠅ ꠁꠐ ꠛꠣꠘꠣꠁꠛꠣꠞ ꠢꠥꠇꠥꠝ ꠖꠦꠁꠘ ꠀꠞ ꠀꠙꠘꠣꠞ ꠁ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠞꠦ ꠝꠣꠁꠞ-ꠗꠁꠞ ꠇꠞꠂꠘ, ꠅꠁꠟꠦ ꠖꠥꠡ ꠔ ꠀꠙꠘꠣꠞ ꠘꠤꠎꠞ ꠡꠞ꠆ꠖꠣꠞꠞ।” ");
INSERT INTO syls_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","ꠚꠦꠞꠣꠃꠘꠦ ꠎꠥꠀꠙ ꠖꠤꠟ, “ꠔꠥꠝꠞꠣ ꠀꠟꠡꠤꠀ, ꠇꠥꠠꠤꠀ, ꠄꠞꠟꠣꠉꠤ ꠇꠁꠞꠣꠄ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠞꠣꠔ ꠎꠣꠁꠔꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","ꠎꠣꠅ, ꠇꠣꠝ ꠇꠞꠅ ꠉꠤꠀ। ꠔꠥꠝꠞꠣꠞꠦ ꠈꠦꠞ ꠖꠦꠅꠀ ꠎꠣꠁꠔ ꠘꠣꠄ, ꠔꠣ-ꠅ ꠙꠞꠔꠦꠇ ꠖꠤꠘ ꠎꠔꠈꠣꠘ ꠁꠐ ꠛꠣꠘꠣꠁꠛꠣꠞ ꠇꠕꠣ ꠀꠍꠤꠟ, ꠅꠔꠈꠣꠘꠃ ꠛꠣꠘꠣꠁꠔꠦ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","ꠅꠃ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠍꠥꠛꠦꠖꠣꠞ ꠅꠇꠟꠦ ꠛꠥꠎꠟꠣ, ꠔꠣꠞꠣ ꠛꠤꠙꠖꠞ ꠝꠣꠎꠦ ꠙꠠꠍꠂꠘ, ꠇꠣꠞꠘ ꠔꠣꠞꠣꠞꠦ ꠢꠥꠇꠥꠝ ꠇꠞꠣ ꠅꠁꠍꠦ, ꠀꠉꠦ ꠎꠔꠈꠣꠘ ꠁꠐ ꠛꠣꠘꠣꠘꠤ ꠟꠣꠉꠔ, ꠅꠈꠘꠅ ꠅꠔꠈꠣꠘ ꠁꠐ ꠛꠣꠘꠣꠁꠔꠦ ꠅꠁꠛ, ꠇꠝ ꠅꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","ꠔꠣꠞꠣ ꠚꠦꠞꠣꠃꠘꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠎꠣꠅꠀꠞ ꠙꠕꠅ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞ ꠟꠉꠦ ꠖꠦꠈꠣ ꠅꠁꠟ, ꠄꠞꠣ ꠃꠛꠣꠁꠀ ꠛꠣꠞ ꠌꠣꠅꠀꠔ ꠀꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","ꠍꠥꠛꠦꠖꠣꠞ ꠅꠇꠟꠦ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠦ ꠀꠙꠘꠣꠞꠣꠞ ꠙꠣꠅꠘꠣ ꠡꠣꠎꠣ ꠖꠤꠛꠣ, ꠀꠙꠘꠣꠞꠣ ꠚꠦꠞꠣꠃꠘ ꠀꠞ ꠔꠣꠞ ꠃꠎꠤꠞ-ꠘꠣꠎꠤꠞꠞ ꠉꠦꠍꠦ ꠀꠝꠞꠣꠞꠦ ꠙꠌꠣ-ꠉꠣꠘ꠆ꠖꠣ ꠛꠣꠘꠣꠁꠀ, ꠀꠝꠞꠣꠞꠦ ꠈꠥꠘ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠔꠟꠥꠀꠞ ꠘꠤꠀ ꠔꠣꠞꠣꠞ ꠀꠔꠅ ꠖꠤꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","ꠅꠃ ꠝꠥꠍꠣꠄ ꠢꠤꠞꠛꠣꠞ ꠉꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍꠦ ꠚꠞꠤꠀꠖ ꠇꠞꠟꠣ, “ꠅ ꠖꠤꠘ ꠖꠥꠘꠤꠀꠞ ꠝꠣꠟꠤꠇ, ꠔꠥꠝꠤ ꠇꠦꠘꠦ ꠔꠥꠝꠣꠞ ꠛꠘ꠆ꠖꠣꠞꠦ ꠝꠍꠤꠛꠔꠅ ꠚꠣꠟꠣꠁꠟꠣꠄ? ꠀꠞ ꠀꠝꠣꠞꠦ ꠇꠤꠔꠣꠟ꠆ꠟꠣꠉꠤ ꠙꠣꠑꠣꠁꠟꠣꠄ? ");
INSERT INTO syls_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","ꠚꠦꠞꠣꠃꠘꠞ ꠉꠦꠍꠦ ꠔꠥꠝꠣꠞ ꠇꠕꠣ ꠢꠥꠘꠣꠘꠤꠞ ꠛꠣꠖ ꠕꠣꠇꠤꠃ ꠔꠥꠝꠣꠞ ꠛꠘ꠆ꠖꠣ ꠅꠇꠟꠞ ꠃꠙꠞꠦ ꠎꠥꠟꠥꠝ ꠔ ꠀꠞꠅ ꠛꠣꠠꠤꠍꠦ। ꠅꠁꠟꠦ ꠔꠥꠝꠤ ꠔ ꠇꠥꠘ꠆ꠔꠣꠃ ꠇꠞꠟꠣꠄ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠚꠦꠞꠣꠃꠘꠞ ꠇꠤꠔꠣ ꠖꠡꠣ ꠅꠄ ꠔꠥꠝꠤ ꠖꠦꠈꠤꠅ, ꠀꠝꠣꠞ ꠀꠔꠞ ꠎꠥꠞ ꠖꠦꠈꠟꠦꠃ ꠢꠦ ꠝꠣꠘꠡꠞꠦ ꠍꠣꠠꠤ ꠖꠤꠛ। ꠎꠥꠞꠀꠟꠣ ꠀꠔꠞ ꠇꠥꠖꠞꠔ ꠖꠦꠈꠟꠦꠃ ꠢꠦ ꠔꠣꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠄꠞꠣꠞꠦ ꠈꠦꠖꠣꠁ ꠖꠤꠛ।” ");
INSERT INTO syls_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","ꠀꠟ꠆ꠟꠣꠄ ꠝꠥꠍꠣꠞ ꠟꠉꠦ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠤ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠘꠣꠝꠃ ‘ꠀꠟ꠆ꠟꠣ ꠎꠦꠁꠘ ꠀꠍꠂꠘ’। ");
INSERT INTO syls_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ꠀꠝꠤ ꠁꠛ꠆ꠞꠣꠢꠤꠝ, ꠁꠍꠢꠣꠇ ꠀꠞ ꠁꠀꠇꠥꠛꠞ ꠉꠦꠍꠦ ꠡꠞ꠆ꠛ-ꠡꠇ꠆ꠔꠤꠝꠣꠘ ꠀꠟ꠆ꠟꠣ ꠘꠣꠝꠦ ꠖꠤꠖꠣꠞ ꠖꠤꠔꠣꠝ, ‘ꠀꠟ꠆ꠟꠣ ꠎꠦꠁꠘ ꠀꠍꠂꠘ’ ꠘꠣꠝꠦ ꠔꠣꠞꠣꠞꠦ ꠖꠤꠖꠣꠞ ꠖꠤꠔꠣꠝ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","ꠀꠝꠤ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠅꠃ ꠅꠀꠖꠣ ꠇꠞꠍꠟꠣꠝ, ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠇꠦꠘꠣꠘ ꠖꠦꠡ ꠖꠤꠝꠥ, ꠎꠦ ꠖꠦꠡꠅ ꠔꠥꠝꠞꠣ ꠝꠥꠍꠣꠚꠤꠞ ꠅꠁꠀ ꠞꠅ, ꠅꠃ ꠖꠦꠡꠃ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠤꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","ꠈꠣꠍ ꠇꠞꠤ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠉꠥꠟꠣꠝꠤ ꠇꠞꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠞꠣꠞ ꠇꠣꠘ꠆ꠖꠘ ꠢꠥꠘꠤꠀ, ꠀꠝꠣꠞ ꠢꠃ ꠅꠀꠖꠣ ꠅꠈꠘ ꠁꠀꠖ ꠇꠞꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","ꠄꠞꠟꠣꠉꠤ ꠔꠥꠝꠤ ꠉꠤꠀ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠅ, ꠝꠣꠛꠥꠖꠦ ꠇꠁꠍꠂꠘ, ꠀꠝꠤ ꠝꠣꠛꠥꠖ, ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠔꠟ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤꠀ ꠀꠘꠝꠥ, ꠔꠣꠞꠣꠞ ꠉꠥꠟꠣꠝꠤ ꠕꠣꠇꠤ ꠀꠎꠣꠖ ꠇꠞꠝꠥ। ꠔꠣꠞꠣꠞꠦ ꠖꠦꠈꠣꠞ ꠝꠔ ꠡꠣꠎꠣ ꠖꠤꠀ, ꠀꠝꠣꠞ ꠇꠥꠖꠞꠔꠤ ꠀꠔꠖꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠈꠣꠟꠣꠍ ꠇꠞꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","ꠢꠦꠡꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠀꠝꠣꠞ ꠘꠤꠎꠞ ꠛꠘ꠆ꠖꠣ ꠛꠣꠘꠣꠁꠝꠥ, ꠀꠝꠤ ꠘꠤꠎꠦ ꠔꠥꠝꠞꠣꠞ ꠀꠟ꠆ꠟꠣ ꠅꠁꠝꠥ। ꠔꠦꠃ ꠔꠥꠝꠞꠣ ꠛꠥꠎꠛꠣꠄ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ, ꠀꠞ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠜꠣꠞꠞ ꠔꠟ ꠕꠣꠇꠤ ꠀꠝꠤꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠛꠣꠌꠣꠁꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","ꠀꠝꠤ ꠁꠛ꠆ꠞꠣꠢꠤꠝ, ꠁꠍꠢꠣꠇ, ꠁꠀꠇꠥꠛꠞ ꠟꠉꠦ ꠎꠦ ꠖꠦꠡꠞ ꠇꠕꠣ ꠅꠀꠖꠣ ꠇꠞꠍꠤ, ꠢꠃ ꠖꠦꠡꠅ ꠔꠥꠝꠞꠣꠞꠦ ꠟꠁꠀ ꠎꠣꠁꠝꠥ, ꠔꠥꠝꠞꠣ ꠢꠃ ꠖꠦꠡꠞ ꠝꠣꠟꠤꠇ ꠅꠁꠛꠣꠄ। ꠀꠝꠤꠃ ꠝꠣꠛꠥꠖ।” ");
INSERT INTO syls_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","ꠝꠥꠍꠣꠄ ꠉꠤꠀ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠔꠣꠞꠣꠞꠦ ꠎꠣꠘꠣꠁꠟꠣ, ꠅꠁꠟꠦ ꠢꠤ ꠛꠦꠕꠣꠄꠀ ꠎꠥꠟꠥꠝ-ꠔꠇꠟꠤꠚ ꠀꠞ ꠉꠥꠟꠣꠝꠤ ꠇꠞꠔꠦ ꠇꠞꠔꠦ ꠝꠘ-ꠝꠞꠣ ꠅꠁꠎꠣꠅꠀꠄ, ꠔꠣꠞꠣ ꠀꠞ ꠝꠥꠍꠣꠞ ꠝꠣꠔꠦ ꠇꠣꠘ ꠖꠤꠟꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","ꠅꠃ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“ꠔꠥꠝꠤ ꠉꠤꠀ ꠝꠤꠡꠞꠞ ꠛꠣꠖꠡꠣ ꠚꠦꠞꠣꠃꠘꠞꠦ ꠇꠅ, ꠢꠦ ꠎꠣꠘꠥ ꠔꠣꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠄꠞꠣꠞꠦ ꠎꠣꠁꠔꠦ ꠖꠦꠄ।” ");
INSERT INTO syls_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","ꠝꠥꠍꠣꠄ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦꠃ ꠎꠦꠛꠟꠣ ꠀꠝꠣꠞ ꠝꠣꠔ ꠢꠥꠘꠦꠞ ꠘꠣ, ꠔꠦ ꠚꠦꠞꠣꠃꠘꠦ ꠇꠤꠟꠣ ꠢꠥꠘꠛ? ꠀꠞ ꠀꠝꠣꠞ ꠔ ꠝꠣꠔꠔꠦ ꠝꠥꠈꠅ ꠟꠣꠉꠤꠎꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","ꠔꠦꠃ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠀꠞ ꠝꠤꠡꠞꠞ ꠞꠣꠎꠣ ꠚꠦꠞꠣꠃꠘꠞꠦ ꠇꠅ, ꠝꠣꠛꠥꠖꠦ ꠀꠝꠞꠣꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠂꠘ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤ ꠘꠦꠅꠀꠞ ꠟꠣꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠎꠣꠔꠤꠞ ꠝꠥꠟ ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠁꠟꠣ ꠢꠎꠞꠔ ꠁꠀꠇꠥꠛ, ꠀꠟ꠆ꠟꠣꠄ ꠅꠃ ꠁꠀꠇꠥꠛꠞ ꠘꠄꠀ ꠘꠣꠝ ꠖꠤꠍꠟꠣ ꠁꠍꠞꠣꠁꠟ। ꠔꠣꠘ ꠙꠥꠀꠂꠘ ꠅꠁꠟꠣ ꠞꠥꠛꠦꠘ, ꠡꠤꠝꠤꠅꠘ, ꠟꠦꠛꠤ ꠡꠢ ꠝꠥꠐ ꠛꠣꠞꠅꠎꠘ। ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘ ꠅꠁꠟꠣ ꠅꠃ ꠢꠎꠞꠔ ꠟꠦꠛꠤꠞ ꠛꠋꠡꠗꠞ। ꠁꠍꠞꠣꠁꠟꠞ ꠛꠠ ꠙꠥꠀ ꠞꠥꠛꠦꠘꠞ ꠙꠥꠀꠂꠘ ꠅꠁꠟꠣ ꠢꠘꠥꠇ, ꠚꠣꠟꠥ, ꠢꠣꠍꠤꠞ ꠀꠞ ꠇꠞ꠆ꠝꠤ, ꠄꠞꠣ ꠔ ꠞꠥꠛꠦꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠘꠣꠘꠣꠘ ꠉꠥꠡ꠆ꠐꠤꠞ ꠝꠥꠟ ꠝꠥꠞꠛ꠆ꠛꠤ। ");
INSERT INTO syls_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","ꠡꠤꠝꠤꠅꠘꠞ ꠙꠥꠀꠂꠘ ꠅꠁꠟꠣ ꠎꠤꠝꠥꠄꠟ, ꠎꠣꠝꠤꠘ, ꠅꠢꠖ, ꠎꠣꠈꠤꠘ, ꠡꠥꠢꠞ ꠀꠞ ꠔꠣꠞ ꠇꠦꠘꠣꠘꠤ ꠛꠃꠞ ꠔꠞꠚꠣ ꠙꠥꠀ ꠡꠃꠟ, ꠄꠞꠣ ꠡꠤꠝꠤꠅꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠘꠣꠘꠣꠘ ꠉꠥꠡ꠆ꠐꠤꠞ ꠝꠥꠟ ꠝꠥꠞꠛ꠆ꠛꠤ। ");
INSERT INTO syls_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","ꠈꠣꠘ꠆ꠖꠣꠘ ꠔꠣꠟꠤꠇꠣ ꠢꠤꠡꠣꠛꠦ ꠢꠎꠞꠔ ꠟꠦꠛꠤꠞ ꠙꠥꠀꠂꠘ ꠅꠁꠟꠣ ꠎꠣꠞꠍꠥꠘ, ꠇꠣꠢꠣꠔ ꠀꠞ ꠝꠣꠞꠣꠞꠤ। ꠟꠦꠛꠤ ꠄꠇ-ꠡ ꠡꠣꠠꠔꠤꠡ ꠛꠞꠍ ꠛꠣꠌꠤꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","ꠎꠣꠞꠎꠤꠞ ꠉꠥꠡ꠆ꠐꠤꠞ ꠙꠞꠗꠣꠘ ꠢꠤꠡꠣꠛꠦ ꠎꠣꠞꠍꠥꠘꠞ ꠙꠥꠀꠂꠘ ꠅꠁꠟꠣ ꠟꠤꠛꠘꠤ ꠀꠞ ꠡꠤꠝꠦꠁ। ");
INSERT INTO syls_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","ꠇꠣꠢꠣꠔꠞ ꠙꠥꠀꠂꠘ ꠅꠁꠟꠣ ꠁꠝꠞꠣꠘ, ꠁꠎꠢꠣꠞ, ꠢꠦꠛꠞꠘ ꠀꠞ ꠃꠎ꠆ꠎꠟ। ꠇꠣꠢꠣꠔ ꠄꠇ-ꠡ ꠔꠦꠔ꠆ꠞꠤꠡ ꠛꠞꠍ ꠛꠣꠌꠤꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","ꠝꠣꠞꠣꠞꠤꠞ ꠙꠥꠀꠂꠘ ꠅꠁꠟꠣ, ꠝꠢꠟꠤ ꠀꠞ ꠝꠥꠡꠤ। ꠄꠞꠣꠃ ꠅꠁꠟꠣ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠘꠣꠘꠣꠘ ꠉꠥꠡ꠆ꠐꠤꠞ ꠝꠥꠟ ꠝꠥꠞꠛ꠆ꠛꠤ। ");
INSERT INTO syls_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","ꠁꠝꠞꠣꠘꠞ ꠙꠥꠀꠂꠘ ꠅꠁꠟꠣ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘ। ꠁꠝꠞꠣꠘꠦ ꠔꠣꠘ ꠚꠥꠚꠥ ꠁꠃꠈꠣꠛꠦꠎꠞꠦ ꠛꠤꠀ ꠇꠞꠍꠟꠣ, ꠔꠣꠘ ꠙꠦꠐꠅ ꠄꠞꠣꠞ ꠎꠘꠝ ꠅꠁꠍꠤꠟ। ꠁꠝꠞꠣꠘ ꠄꠇ-ꠡ ꠡꠣꠠꠔꠤꠡ ꠛꠞꠍ ꠛꠣꠌꠤꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","ꠁꠎꠢꠣꠞꠞ ꠙꠥꠀꠂꠘ ꠅꠁꠟꠣ ꠇꠥꠞꠣꠢ, ꠘꠦꠚꠉ, ꠎꠤꠈꠞꠤ। ");
INSERT INTO syls_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","ꠃꠎ꠆ꠎꠟꠞ ꠙꠥꠀꠂꠘ ꠝꠤꠡꠣꠄꠄꠟ, ꠄꠟꠎꠣꠚꠘ ꠀꠞ ꠎꠤꠔꠞꠤ। ");
INSERT INTO syls_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","ꠀꠞ ꠢꠣꠞꠥꠘꠦ ꠀꠝꠤꠘꠣꠖꠣꠛꠞ ꠙꠥꠠꠤ ꠘꠣꠢꠤꠡꠞ ꠛꠁꠘ ꠁꠟꠤꠡꠦꠛꠣꠞꠦ ꠛꠤꠀ ꠇꠞꠣꠄ, ꠔꠣꠘ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠅꠁꠟꠣ ꠘꠣꠖꠣꠛ, ꠀꠛꠤꠢꠥ, ꠀꠟꠤ-ꠀꠎꠞ ꠀꠞ ꠁꠍꠣꠝꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","ꠇꠥꠞꠣꠢꠞ ꠙꠥꠀꠂꠘ ꠅꠁꠟꠣ ꠅꠡꠤꠞ, ꠁꠟꠇꠣꠘꠣ, ꠅꠛꠤꠀꠡꠚ। ꠄꠞꠣ ꠇꠥꠞꠣꠢꠤ ꠅꠇꠟꠞ ꠘꠣꠘꠣꠘ ꠉꠥꠡ꠆ꠐꠤꠞ ꠝꠥꠟ ꠝꠥꠞꠛ꠆ꠛꠤ। ");
INSERT INTO syls_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","ꠀꠟꠤ-ꠀꠎꠞꠞ ꠙꠥꠀ ꠅꠁꠟꠣ ꠙꠤꠘꠢꠡ। ꠢꠣꠞꠥꠘꠞ ꠙꠥꠀ ꠀꠟꠤ-ꠀꠎꠞꠦ ꠙꠥꠐꠤꠄꠟꠞ ꠙꠥꠠꠤꠞꠦ ꠛꠤꠀ ꠇꠞꠣꠄ ꠔꠣꠁꠞ ꠙꠦꠐꠅ ꠙꠤꠘꠢꠡꠞ ꠎꠘꠝ ꠅꠁꠍꠤꠟ। ꠄꠞꠣ ꠅꠁꠟꠣ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠘꠣꠘꠣꠘ ꠉꠥꠡ꠆ꠐꠤꠞ ꠝꠥꠟ ꠝꠥꠞꠛ꠆ꠛꠤ। ");
INSERT INTO syls_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","ꠅꠃ ꠢꠣꠞꠥꠘ ꠀꠞ ꠝꠥꠍꠣꠞꠦ ꠝꠣꠛꠥꠖꠦ ꠢꠥꠇꠥꠝ ꠇꠞꠍꠟꠣ, ꠔꠥꠝꠞꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠍꠤꠙꠣꠁ ꠖꠟꠞ ꠟꠣꠈꠣꠘ ꠢꠣꠎꠤꠀ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠅ। ");
INSERT INTO syls_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠦꠃ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠣꠞ ꠇꠕꠣ ꠝꠤꠡꠞꠞ ꠛꠣꠖꠡꠣ ꠚꠦꠞꠣꠃꠘꠞ ꠟꠉꠦ ꠝꠣꠔꠤꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞ ꠟꠉꠦ ꠎꠦꠖꠤꠘ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ꠢꠃ ꠖꠤꠘ ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠝꠣꠛꠥꠖ। ꠔꠦ ꠔꠥꠝꠣꠞꠦ ꠅꠈꠘ ꠎꠦꠔꠣ ꠎꠦꠔꠣ ꠇꠁꠝꠥ, ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠔꠥꠝꠤ ꠝꠤꠡꠞꠞ ꠛꠣꠖꠡꠣ ꠚꠦꠞꠣꠃꠘꠞꠦ ꠇꠁꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","ꠝꠥꠍꠣꠄ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠀꠞꠎ ꠇꠞꠟꠣ, “ꠖꠦꠈꠃꠇ꠆ꠇꠣ, ꠀꠝꠣꠞ ꠔ ꠝꠣꠔꠔꠦ ꠝꠥꠈꠅ ꠟꠣꠉꠤꠎꠣꠄ, ꠚꠦꠞꠣꠃꠘꠦ ꠇꠥꠘꠥ ꠀꠝꠣꠞ ꠝꠣꠔ ꠢꠥꠘꠛ ꠘꠤ?” ");
INSERT INTO syls_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","ꠅꠃ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ “ꠢꠥꠘꠅ, ꠀꠝꠤ ꠚꠦꠞꠣꠃꠘꠞ ꠉꠦꠍꠦ ꠔꠥꠝꠣꠞꠦ ꠀꠟ꠆ꠟꠣꠞ ꠟꠣꠈꠣꠘ ꠛꠣꠘꠣꠁꠝꠥ। ꠀꠞ ꠔꠥꠝꠣꠞ ꠜꠣꠁ ꠢꠣꠞꠥꠘꠞꠦ ꠛꠣꠘꠣꠁꠝꠥ ꠔꠥꠝꠣꠞ ꠘꠛꠤ। ");
INSERT INTO syls_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠇꠞꠝꠥ, ꠔꠥꠝꠤ ꠅꠃꠟꠣ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠛꠣꠄ, ꠀꠞ ꠢꠣꠞꠥꠘꠦ ꠅꠔꠣ ꠚꠦꠞꠣꠃꠘꠞꠦ ꠇꠁꠛ; ꠎꠣꠔꠦ ꠢꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠔꠣꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠍꠣꠠꠤ ꠖꠦꠄ। ");
INSERT INTO syls_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","ꠅꠁꠟꠦ ꠀꠝꠤ ꠚꠦꠞꠣꠃꠘꠞ ꠖꠤꠟꠞꠦ ꠙꠣꠡꠣꠘ ꠇꠞꠤꠟꠤꠝꠥ। ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠀꠝꠤ ꠛꠃꠔ ꠇꠦꠞꠣꠝꠔꠤ ꠀꠞ ꠇꠥꠖꠞꠔꠤ ꠟꠤꠟꠣ-ꠈꠦꠟꠣ ꠖꠦꠈꠣꠁꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ꠔꠣꠞ ꠛꠣꠖꠦꠅ ꠚꠦꠞꠣꠃꠘꠦ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠔꠞ ꠖꠣꠝ ꠖꠤꠔ ꠘꠣꠄ। ꠔꠦꠃ ꠀꠝꠤ ꠝꠤꠡꠞꠞ ꠃꠙꠞꠦ ꠀꠝꠣꠞ ꠀꠔ ꠟꠣꠉꠣꠁꠀ, ꠖꠦꠈꠣꠞ ꠝꠔ ꠡꠣꠎꠣ ꠖꠤꠀ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠀꠝꠣꠞ ꠘꠤꠎꠞ ꠛꠘ꠆ꠖꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠍꠤꠙꠣꠁꠞ ꠟꠣꠈꠣꠘ ꠖꠟꠦ ꠖꠟꠦ ꠛꠣꠞ ꠇꠞꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","ꠝꠤꠡꠞꠞ ꠝꠣꠎꠦ ꠀꠝꠣꠞ ꠘꠤꠎꠞ ꠀꠔ ꠟꠣꠉꠣꠁꠝꠥ, ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠛꠣꠞ ꠇꠞꠤꠀ ꠀꠘꠝꠥ, ꠅꠃꠖꠤꠘ ꠔꠣꠞꠣ ꠛꠥꠎꠛꠣ ꠀꠝꠤꠃ ꠝꠣꠛꠥꠖ।” ");
INSERT INTO syls_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","ꠛꠣꠖꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠦ ꠅꠃꠟꠣ ꠇꠞꠟꠣ, ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠇꠣꠝ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","ꠚꠦꠞꠣꠃꠘꠞ ꠟꠉꠦ ꠝꠣꠔ-ꠇꠕꠣꠞ ꠡꠝꠄ ꠝꠥꠍꠣꠞ ꠛꠄꠅꠡ ꠀꠍꠤꠟ ꠀꠡꠤ, ꠀꠞ ꠢꠣꠞꠥꠘꠞ ꠔꠤꠞꠣꠡꠤ ꠛꠞꠍ। ");
INSERT INTO syls_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","ꠅꠃ ꠡꠝꠄ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“ꠚꠦꠞꠣꠃꠘꠦ ꠎꠦꠛꠟꠣ ꠇꠁꠛ, ꠔꠥꠝꠞꠣꠞ ꠘꠤꠎꠞ ꠇꠥꠘꠥ ꠇꠦꠞꠣꠝꠔꠤ ꠇꠣꠝ ꠖꠦꠈꠣꠅ, ꠔꠦꠃ ꠔꠥꠝꠤ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠅ, ꠔꠣꠞ ꠟꠣꠑꠤ ꠘꠤꠀ ꠚꠦꠞꠣꠃꠘꠞ ꠍꠣꠝꠘꠦ ꠚꠣꠟꠣꠁꠔ, ꠚꠣꠟꠣꠘꠤꠞ ꠟꠉꠦ ꠟꠉꠦꠃ ꠁꠐꠣ ꠢꠣꠚ ꠅꠁꠎꠤꠛ।” ");
INSERT INTO syls_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","ꠛꠣꠖꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘ ꠚꠦꠞꠣꠃꠘꠞ ꠉꠦꠍꠦ ꠉꠦꠟꠣ, ꠉꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠇꠣꠝ ꠇꠞꠟꠣ। ꠢꠣꠞꠥꠘꠦ ꠚꠦꠞꠣꠃꠘ ꠀꠞ ꠔꠣꠞ ꠃꠎꠤꠞ-ꠘꠣꠎꠤꠞꠞ ꠍꠣꠝꠘꠦ ꠢꠃ ꠟꠣꠑꠤ ꠚꠣꠟꠣꠘꠤꠞ ꠟꠉꠦ ꠟꠉꠦꠃ ꠁꠐꠣ ꠢꠣꠚ ꠅꠁꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ꠅꠃ ꠚꠦꠞꠣꠃꠘꠦꠅ ꠔꠣꠞ ꠉꠥꠘꠤꠘ ꠀꠞ ꠎꠣꠖꠥꠉꠤꠞ ꠅꠇꠟꠞꠦ ꠀꠘꠣꠁꠟ, ꠔꠣꠞꠣꠅ ꠔꠣꠞꠣꠞ ꠎꠣꠖꠥ-ꠝꠘꠔ꠆ꠞ ꠖꠤꠀ ꠅꠃꠟꠣ ꠖꠦꠈꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","ꠔꠣꠞꠣ ꠢꠇꠟꠦꠃ ꠎꠣꠞꠎꠤꠞ ꠟꠣꠑꠤ ꠍꠣꠠꠟ, ꠀꠞ ꠄꠅꠔꠣ ꠢꠣꠚ ꠅꠁꠉꠦꠟ, ꠅꠁꠟꠦ ꠢꠣꠞꠥꠘꠞ ꠟꠣꠑꠤꠄ ꠔꠣꠞꠣꠞ ꠢꠇ꠆ꠇꠟ ꠟꠣꠑꠤꠞꠦ ꠉꠤꠟꠤꠟꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ꠁꠔꠣ ꠖꠦꠈꠤꠀꠅ ꠚꠦꠞꠣꠃꠘꠞ ꠖꠤꠟ ꠙꠣꠡꠣꠘ ꠞꠁꠟ, ꠢꠦ ꠄꠞꠣꠞ ꠝꠣꠔꠦ ꠇꠣꠘ ꠖꠤꠟ ꠘꠣ, ꠎꠦꠟꠣ ꠝꠣꠛꠥꠖꠦ ꠀꠉꠦ ꠇꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠚꠦꠞꠣꠃꠘꠞ ꠖꠤꠟ ꠔ ꠙꠣꠡꠣꠘ, ꠢꠦ ꠝꠣꠘꠡꠞꠦ ꠍꠣꠠꠔꠦ ꠞꠣꠎꠤ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","ꠔꠦ ꠔꠥꠝꠤ ꠛꠤꠀꠘꠤ ꠛꠣꠟꠣ ꠚꠦꠞꠣꠃꠘꠞ ꠉꠦꠍꠦ ꠎꠣꠁꠅ, ꠉꠦꠟꠦ ꠖꠦꠈꠛꠣꠄ ꠢꠦ ꠙꠣꠘꠤꠞ ꠉꠦꠍꠦ ꠎꠣꠁꠛ, ꠔꠥꠝꠤ ꠔꠣꠞ ꠟꠉꠦ ꠖꠦꠈꠣ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠘꠤꠟ ꠘꠖꠞ ꠙꠣꠞꠅ ꠃꠛꠣꠁꠅ। ꠔꠥꠝꠣꠞ ꠎꠦ ꠟꠣꠑꠤ ꠢꠣꠚ ꠅꠁꠍꠤꠟ, ꠅꠃ ꠟꠣꠑꠤ ꠀꠔꠅ ꠇꠞꠤ ꠘꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","ꠘꠤꠀ ꠔꠣꠞꠦ ꠇꠁꠅ, ‘ꠝꠣꠛꠥꠖ, ꠎꠦꠁꠘ ꠁꠛꠞꠣꠘꠤ ꠅꠇꠟꠞ ꠀꠟ꠆ꠟꠣ, ꠔꠣꠁꠘ ꠘꠤꠎꠦ ꠀꠝꠣꠞꠦ ꠙꠣꠑꠣꠁꠍꠂꠘ ꠀꠙꠘꠣꠞꠦ ꠅꠈꠣꠘ ꠇꠁꠔꠣꠝ, ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠛꠘ꠆ꠖꠣ ꠅꠇꠟꠞꠦ ꠍꠣꠠꠤ ꠖꠦꠅ, ꠔꠣꠞꠣ ꠀꠝꠣꠞ ꠛꠘ꠆ꠖꠦꠉꠤ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠢꠤꠎꠞꠔ ꠇꠞꠃꠇ, ꠔꠣ-ꠅ ꠅꠈꠘꠅ ꠔꠥꠝꠤ ꠢꠥꠘꠞꠣꠄ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","ꠄꠞꠟꠣꠉꠤ ꠅꠈꠘ ꠔꠥꠝꠤ ꠛꠥꠎꠛꠣꠄ, ꠀꠝꠤꠃ ꠝꠣꠛꠥꠖ।’ ꠅꠈꠣꠘ ꠇꠁꠀ ꠢꠣꠞꠤ ꠔꠥꠝꠤ ꠇꠁꠅ, ‘ꠖꠦꠈꠃꠇ꠆ꠇꠣ, ꠀꠝꠤ ꠘꠤꠎꠞ ꠀꠔꠞ ꠟꠣꠑꠤ ꠖꠤꠀ ꠅꠃ ꠘꠤꠟ ꠘꠖꠞ ꠙꠣꠘꠤꠔ ꠛꠣꠠꠤ ꠝꠣꠞꠝꠥ, ꠀꠞ ꠢꠇ꠆ꠇꠟ ꠙꠣꠘꠤ ꠟꠃ ꠅꠁꠎꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","ꠢꠇ꠆ꠇꠟ ꠝꠣꠍ ꠝꠞꠤꠎꠤꠛ ꠀꠞ ꠙꠌꠣ ꠉꠘ꠆ꠖ ꠛꠣꠞ ꠅꠁꠛ, ꠔꠦꠃ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠦ ꠅꠃ ꠘꠤꠟ ꠘꠖꠞ ꠙꠣꠘꠤ ꠈꠣꠁꠔꠣ ꠙꠣꠞꠔꠣ ꠘꠣꠄ।’ ” ");
INSERT INTO syls_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠢꠣꠞꠥꠘꠞꠦ ꠅꠃ ꠇꠕꠣ ꠇꠅ, ꠔꠥꠝꠤ ꠘꠤꠎꠞ ꠟꠣꠑꠤ ꠟꠁꠀ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠢꠇ꠆ꠇꠟ ꠙꠣꠘꠤꠞ ꠃꠙꠞꠦ, ꠖꠦꠡꠞ ꠉꠣꠋ-ꠘꠣꠟꠣ, ꠈꠣꠟ-ꠛꠤꠟ, ꠀꠅꠞ-ꠛꠣꠅꠞ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠔꠥꠝꠣꠞ ꠀꠔ ꠛꠣꠠꠣꠅ, ꠔꠦꠃ ꠁꠔꠣꠞ ꠢꠇ꠆ꠇꠟ ꠙꠣꠘꠤ ꠟꠃ ꠅꠁꠎꠤꠛ। ꠙꠣꠔ꠆ꠔꠞ ꠈꠥꠖꠤꠀ ꠛꠣꠘꠣꠁꠟ ꠛꠣ ꠟꠣꠇꠠꠤꠞ ꠙꠣꠔꠤꠟ-ꠇꠟꠡꠞ ꠝꠣꠎꠦ ꠕꠅꠀ ꠙꠣꠘꠤꠅ ꠟꠃ ꠅꠁꠎꠤꠛ।” ");
INSERT INTO syls_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","ꠅꠃ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠦ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠅꠃꠟꠣ ꠇꠞꠟꠣ, ꠔꠣꠁꠘ ꠟꠣꠑꠤ ꠃꠌꠣ ꠇꠞꠤ ꠚꠦꠞꠣꠃꠘ ꠀꠞ ꠔꠣꠞ ꠃꠎꠤꠞ-ꠘꠣꠎꠤꠞꠞ ꠍꠣꠝꠘꠦ ꠘꠤꠟ ꠘꠖꠞ ꠙꠣꠘꠤꠔ ꠛꠣꠠꠤ ꠝꠣꠞꠟꠣ, ꠔꠦꠃ ꠢꠇꠟ ꠙꠣꠘꠤ ꠟꠃ ꠅꠁꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","ꠘꠤꠟ ꠘꠖꠞ ꠢꠇꠟ ꠝꠣꠍ ꠝꠞꠤꠉꠦꠟ, ꠢꠇꠟ ꠙꠣꠘꠤꠔ ꠙꠌꠣ ꠉꠘ꠆ꠖ ꠛꠣꠞ ꠅꠁꠟ, ꠝꠤꠡꠞꠤ ꠅꠇꠟꠦ ꠙꠣꠘꠤ ꠀꠞ ꠈꠣꠁꠔꠣ ꠙꠣꠞꠟꠣ ꠘꠣ, ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠢꠇꠟ ꠙꠣꠘꠤ ꠟꠃ ꠅꠁꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","ꠝꠤꠡꠞꠤ ꠎꠣꠖꠥꠉꠤꠞ ꠅꠇꠟꠦꠅ ꠔꠣꠞꠣꠞ ꠎꠣꠖꠥ-ꠝꠘꠔ꠆ꠞ ꠍꠣꠠꠤꠀ ꠅꠃꠟꠣ ꠇꠞꠟ, ꠄꠔꠦ ꠚꠦꠞꠣꠃꠘꠞ ꠖꠤꠟ ꠙꠣꠡꠣꠘ ꠞꠁꠟ। ꠢꠦ ꠄꠞꠣꠞ ꠝꠣꠔꠅ ꠇꠣꠘ ꠖꠤꠟ ꠘꠣ, ꠎꠦꠟꠣ ꠝꠣꠛꠥꠖꠦ ꠀꠉꠦ ꠇꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","ꠛꠣꠖꠦ ꠚꠦꠞꠣꠃꠘꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠙꠤꠍ ꠖꠤꠀ ꠔꠣꠞ ꠞꠣꠎꠛꠣꠠꠤꠔ ꠉꠦꠟꠉꠤ, ꠁꠔꠣ ꠇꠥꠘ꠆ꠔꠣꠔꠃ ꠇꠣꠘ ꠖꠤꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ꠅꠁꠟꠦ ꠇꠥꠘꠥ ꠝꠤꠡꠞꠤꠄ ꠉꠣꠋꠉꠞ ꠙꠣꠘꠤ ꠈꠣꠁꠔꠦ ꠘꠣ ꠙꠣꠞꠣꠄ, ꠙꠣꠘꠤ ꠈꠣꠅꠀꠞ ꠟꠣꠉꠤ ꠉꠣꠋꠉꠞ ꠙꠣꠞꠞ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠔꠣꠞꠣ ꠉꠣꠔ ꠈꠥꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","ꠘꠤꠟ ꠘꠖꠞ ꠙꠣꠘꠤꠔ ꠝꠣꠛꠥꠖꠞ ꠉꠎꠛ ꠘꠣꠎꠤꠟ ꠅꠀꠞ ꠛꠣꠖꠦ ꠡꠣꠔ ꠖꠤꠘ ꠉꠥꠎꠞꠤ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","ꠅꠃ ꠡꠣꠔ ꠖꠤꠘ ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠚꠦꠞꠣꠃꠘꠞ ꠉꠦꠍꠦ ꠎꠣꠅ, ꠉꠤꠀ ꠔꠣꠞꠦ ꠇꠅ, ꠝꠣꠛꠥꠖꠦ ꠘꠤꠎꠦ ꠇꠁꠞꠣ, ꠀꠝꠣꠞ ꠈꠦꠎꠝꠔ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠀꠝꠣꠞ ꠛꠘ꠆ꠖꠣ ꠅꠇꠟꠞꠦ ꠍꠣꠠꠤ ꠖꠦꠅ। ");
INSERT INTO syls_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","ꠔꠣꠞꠣꠞꠦ ꠘꠣ ꠍꠣꠠꠤꠀ ꠇꠥꠘꠥ ꠛꠣꠗꠣ ꠖꠤꠟꠦ, ꠀꠝꠤ ꠛꠦꠋ ꠖꠤꠀ ꠔꠥꠝꠣꠞ ꠀꠡ꠆ꠔꠣ ꠖꠦꠡꠅ ꠉꠎꠛ ꠓꠣꠟꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","ꠀꠡ꠆ꠔꠣ ꠘꠤꠟ ꠘꠖ ꠛꠦꠋꠉꠦ ꠜꠞꠤꠎꠤꠛꠣ, ꠀꠞ ꠁꠔꠣ ꠀꠁꠀ ꠔꠥꠝꠣꠞ ꠞꠣꠎꠛꠣꠠꠤꠔ, ꠢꠥꠔꠤꠛꠣꠞ ꠊꠞꠅ, ꠔꠥꠝꠣꠞ ꠛꠤꠍꠘꠣꠔ ꠃꠑꠤꠛꠣ। ꠀꠞ ꠔꠥꠝꠣꠞ ꠃꠎꠤꠞ-ꠘꠣꠎꠤꠞꠞ ꠊꠞꠅ, ꠔꠥꠝꠣꠞ ꠙ꠆ꠞꠎꠣ ꠅꠇꠟꠞ ꠊꠞꠅ, ꠔꠥꠝꠣꠞ ꠃꠘ꠆ꠖꠣꠟ ꠀꠞ ꠙꠤꠑꠣ ꠛꠣꠘꠣꠁꠛꠣꠞ ꠉꠣꠝꠟꠣꠔꠅ ꠀꠁꠀ ꠢꠣꠝꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","ꠔꠥꠝꠣꠞ, ꠀꠞ ꠔꠥꠝꠣꠞ ꠃꠎꠤꠞ-ꠘꠣꠎꠤꠞꠞ, ꠀꠞ ꠙ꠆ꠞꠎꠣ ꠅꠇꠟꠞ ꠉꠔꠞꠅ ꠛꠦꠋ ꠃꠑꠤꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠢꠣꠞꠥꠘꠞꠦ ꠇꠅ, ꠔꠥꠝꠤ ꠘꠤꠟ ꠘꠖ ꠀꠞ ꠈꠣꠟ-ꠛꠤꠟꠞ ꠃꠙꠞꠦ ꠢꠃ ꠟꠣꠑꠤ ꠀꠟꠣ ꠀꠔ ꠛꠣꠠꠣꠁꠀ ꠀꠡ꠆ꠔꠣ ꠝꠤꠡꠞꠅ ꠛꠦꠋ ꠀꠘꠣꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","ꠅꠃ ꠢꠣꠞꠥꠘꠦ ꠝꠤꠡꠞꠞ ꠢꠇꠟ ꠙꠣꠘꠤꠞ ꠃꠙꠞꠦ ꠔꠣꠘ ꠀꠔ ꠛꠣꠠꠣꠁꠟꠣ, ꠔꠦꠃ ꠛꠦꠋꠉꠣꠁꠘ꠆ꠔꠦ ꠀꠁꠀ ꠝꠤꠡꠞ ꠖꠦꠡ ꠜꠞꠤꠀ ꠎꠣꠝ ꠅꠁꠉꠦꠟꠣ, ꠇꠥꠘꠥ ꠎꠣꠉꠣ ꠈꠣꠟꠤ ꠞꠁꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","ꠅꠁꠟꠦ ꠎꠣꠖꠥꠉꠤꠞ ꠅꠇꠟꠦꠅ ꠔꠣꠞꠣꠞ ꠎꠣꠖꠥ-ꠝꠘꠔ꠆ꠞ ꠖꠤꠀ ꠝꠤꠡꠞꠅ ꠅꠃꠟꠣ ꠛꠦꠋ ꠀꠘꠟ। ");
INSERT INTO syls_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","ꠛꠣꠖꠦ ꠚꠦꠞꠣꠃꠘꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠀꠘꠣꠁꠀ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍꠦ ꠀꠞꠎ ꠇꠞꠅ, ꠔꠣꠁꠘ ꠀꠝꠣꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠀꠞ ꠀꠝꠣꠞ ꠙ꠆ꠞꠎꠣ ꠅꠇꠟꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠁ ꠛꠦꠋ ꠅꠇꠟ ꠢꠞꠣꠁꠀ ꠘꠦꠃꠇ꠆ꠇꠣ, ꠔꠣꠁꠟꠦ ꠀꠝꠤ ꠝꠣꠘꠡꠞꠦ ꠍꠣꠠꠤ ꠖꠤꠝꠥ, ꠎꠣꠔꠦ ꠔꠣꠞꠣ ꠉꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠞꠔ ꠙꠣꠞꠦ।” ");
INSERT INTO syls_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","ꠅꠃꠉꠤ ꠝꠥꠍꠣꠄ ꠚꠦꠞꠣꠃꠘꠞꠦ ꠇꠁꠟꠣ, “ꠀꠙꠘꠦ ꠀꠝꠣꠞꠦ ꠑꠤꠇ ꠇꠞꠤ ꠇꠃꠇ꠆ꠇꠣ, ꠀꠝꠤ ꠇꠥꠘ ꠡꠝꠄꠇꠥꠞ ꠟꠣꠉꠤ ꠝꠤꠘꠔꠤ ꠇꠞꠔꠣꠝ, ꠇꠥꠘ ꠡꠝꠄ ꠀꠙꠘꠣꠞ ꠊꠞ, ꠀꠙꠘꠣꠞ ꠃꠎꠤꠞ-ꠘꠣꠎꠤꠞ ꠀꠞ ꠙ꠆ꠞꠎꠣ ꠅꠇꠟꠞ ꠊꠞ ꠕꠣꠇꠤ ꠛꠦꠋ ꠅꠇꠟ ꠢꠞꠤꠀ ꠎꠣꠁꠔꠣꠉꠤ, ꠉꠤꠀ ꠈꠣꠟꠤ ꠉꠣꠋꠉꠅ ꠞꠁꠔꠣ?” ");
INSERT INTO syls_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","ꠔꠣꠁꠘ ꠇꠁꠟꠣ “ꠇꠣꠁꠟꠇꠥꠞ ꠟꠣꠉꠤ।” ꠅꠃ ꠝꠥꠍꠣꠄ ꠇꠁꠟꠣ, “ꠀꠙꠘꠣꠞ ꠎꠛꠣꠘ ꠝꠔꠃ ꠅꠃꠇ, ꠎꠣꠔꠦ ꠀꠙꠘꠦ ꠛꠥꠎꠔꠣ ꠙꠣꠞꠂꠘ, ꠀꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠢꠝꠣꠘꠤ ꠀꠞ ꠇꠦꠃ ꠘꠣꠁ। ");
INSERT INTO syls_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","ꠛꠦꠋꠉꠣꠁꠘ꠆ꠔꠦ ꠀꠙꠘꠣꠞ ꠉꠦꠍ ꠕꠣꠇꠤ, ꠀꠙꠘꠣꠞ ꠊꠞ-ꠛꠣꠠꠤ ꠕꠣꠇꠤ, ꠀꠙꠘꠣꠞ ꠃꠎꠤꠞ-ꠘꠣꠎꠤꠞ ꠀꠞ ꠙ꠆ꠞꠎꠣ ꠅꠇꠟꠞ ꠊꠞ ꠕꠣꠇꠤ ꠢꠞꠤꠀ ꠉꠤꠀ ꠈꠣꠟꠤ ꠘꠤꠟ ꠘꠖꠅ ꠞꠁꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘ ꠚꠦꠞꠣꠃꠘꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠛꠣꠞꠦ ꠉꠦꠟꠣ, ꠉꠤꠀ ꠝꠥꠍꠣꠄ ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍꠦ ꠚꠞꠤꠀꠖ ꠇꠞꠟꠣ, ꠚꠦꠞꠣꠃꠘꠞ ꠃꠙꠞ ꠕꠣꠇꠤ ꠛꠦꠋꠉꠞ ꠉꠎꠛ ꠢꠞꠣꠘꠤꠞ ꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞ ꠀꠞꠎꠤ ꠇꠛꠥꠟ ꠇꠞꠣꠄ, ꠔꠣꠞꠣꠞ ꠛꠣꠠꠤ-ꠊꠞ, ꠃꠑꠣꠘ ꠀꠞ ꠛꠘ꠆ꠖꠞ ꠢꠇꠟ ꠛꠦꠋ ꠝꠞꠤꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","ꠀꠞ ꠝꠣꠘꠡꠦ ꠁꠔꠣꠞꠦ ꠎꠣꠉꠣꠄ ꠎꠣꠉꠣꠄ ꠖꠟꠣ ꠇꠞꠟꠦ, ꠙꠌꠤꠀ ꠖꠦꠡꠅ ꠉꠘ꠆ꠖ ꠛꠣꠞ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","ꠅꠁꠟꠦ ꠚꠦꠞꠣꠃꠘꠦ ꠎꠦꠛꠟꠣ ꠖꠦꠈꠟ, ꠉꠎꠛ ꠔ ꠢꠞꠤꠉꠦꠍꠦ, ꠅꠃ ꠢꠦ ꠔꠣꠞ ꠖꠤꠟ ꠙꠣꠡꠣꠘ ꠇꠞꠤꠟ꠆ꠟ। ꠄꠞꠣꠞ ꠝꠣꠔꠅ ꠀꠞ ꠇꠣꠘ ꠖꠤꠟ ꠘꠣ, ꠎꠦꠟꠣ ꠝꠣꠛꠥꠖꠦ ꠀꠉꠦ ꠇꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠅ, ꠔꠥꠝꠤ ꠔꠥꠝꠣꠞ ꠟꠣꠑꠤ ꠛꠣꠠꠣꠁꠀ ꠝꠣꠐꠤꠞ ꠗꠥꠟꠤꠔ ꠛꠣꠠꠤ ꠝꠣꠞꠅ, ꠔꠦꠃ ꠁ ꠗꠥꠁꠟ ꠝꠡꠣ ꠅꠁꠀ ꠀꠡ꠆ꠔꠣ ꠝꠤꠡꠞ ꠖꠦꠡ ꠜꠞꠤꠎꠤꠛ।” ");
INSERT INTO syls_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","ꠔꠣꠞꠣ ꠅꠃꠟꠣ ꠇꠞꠟꠣ, ꠢꠣꠞꠥꠘꠦ ꠔꠣꠘ ꠟꠣꠑꠤ ꠀꠟꠣ ꠀꠔ ꠛꠣꠠꠣꠁꠀ ꠝꠣꠐꠤꠞ ꠗꠥꠟꠤꠔ ꠛꠣꠠꠤ ꠝꠣꠞꠟꠣ, ꠔꠦꠃ ꠝꠣꠐꠤꠞ ꠢꠇ꠆ꠇꠟ ꠗꠥꠁꠟ ꠝꠡꠣ ꠅꠁꠉꠦꠟ। ꠅꠃ ꠝꠡꠣꠄ ꠝꠣꠘꠥꠡ, ꠎꠣꠘꠥꠀꠞ ꠀꠞ ꠝꠤꠡꠞꠞ ꠢꠇ꠆ꠇꠟꠛꠣꠄ ꠜꠞꠤꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","ꠀꠞ ꠎꠣꠖꠥꠉꠤꠞ ꠅꠇꠟꠦꠅ ꠔꠣꠞꠣꠞ ꠎꠣꠖꠥ-ꠝꠘꠔ꠆ꠞ ꠖꠤꠀ ꠅꠃꠟꠣ ꠝꠡꠣ ꠛꠣꠘꠣꠁꠔ ꠌꠣꠁꠟ, ꠅꠁꠟꠦ ꠙꠣꠞꠟ ꠘꠣ। ꠝꠣꠘꠥꠡ ꠀꠞ ꠎꠣꠘꠥꠀꠞꠞ ꠝꠣꠎꠦ ꠝꠡꠣ ꠞꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","ꠔꠦꠃ ꠎꠣꠖꠥꠉꠤꠞ ꠅꠇꠟꠦ ꠚꠦꠞꠣꠃꠘꠞꠦ ꠇꠁꠟꠣ, “ꠁꠔꠣ ꠔ ꠀꠟ꠆ꠟꠣꠞ ꠇꠥꠖꠞꠔ।” ꠔꠣ-ꠅ ꠚꠦꠞꠣꠃꠘꠞ ꠖꠤꠟ ꠙꠣꠡꠣꠘ ꠞꠁꠟ, ꠢꠦ ꠄꠞꠣꠞ ꠝꠣꠔꠦ ꠇꠣꠘ ꠖꠤꠟ ꠘꠣ, ꠎꠦꠟꠣ ꠝꠣꠛꠥꠖꠦ ꠀꠉꠦ ꠇꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠚꠎꠞꠦ ꠃꠑꠤꠀ ꠚꠦꠞꠣꠃꠘꠞ ꠉꠦꠍꠦ ꠀꠎꠤꠞ ꠅꠅ, ꠉꠦꠟꠦ ꠖꠦꠈꠛꠣꠄ ꠢꠦ ꠙꠣꠘꠤꠞ ꠉꠦꠍꠦ ꠀꠁꠛ। ꠔꠥꠝꠤ ꠔꠣꠞꠦ ꠅꠃꠟꠣ ꠇꠁꠅ, ꠝꠣꠛꠥꠖꠦ ꠘꠤꠎꠦ ꠇꠁꠞꠣ, ꠀꠝꠣꠞ ꠈꠦꠎꠝꠔ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠛꠘ꠆ꠖꠣ ꠅꠇꠟꠞꠦ ꠍꠣꠠꠤ ꠖꠦꠅ। ");
INSERT INTO syls_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","ꠎꠥꠖꠤ ꠘꠣ ꠍꠣꠠꠅ ꠔꠣꠁꠟꠦ ꠀꠝꠤ ꠔꠥꠝꠣꠞ, ꠔꠥꠝꠣꠞ ꠃꠎꠤꠞ-ꠘꠣꠎꠤꠞ, ꠔꠥꠝꠣꠞ ꠙ꠆ꠞꠎꠣ ꠅꠇꠟꠞ ꠃꠙꠞꠦ, ꠀꠞ ꠔꠥꠝꠣꠞ ꠊꠞꠣꠁꠘ꠆ꠔꠞ ꠝꠣꠎꠦ ꠇꠣꠝꠠꠣꠅꠞꠣ ꠒꠣꠡ-ꠝꠣꠍꠤꠞ ꠙꠣꠟ ꠙꠣꠑꠣꠁꠝꠥ, ꠁꠔꠣ ꠙꠣꠟꠦ ꠙꠣꠟꠦ ꠀꠁꠀ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠊꠞꠅ ꠀꠞ ꠔꠣꠞꠣꠞ ꠛꠡꠔ-ꠜꠤꠐꠣ ꠡꠢ ꠢꠇꠟ ꠎꠣꠉꠣꠔ ꠎꠣꠝ ꠅꠁꠎꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","ꠅꠁꠟꠦ ꠀꠝꠤ ꠀꠝꠣꠞ ꠛꠘ꠆ꠖꠣ ꠅꠇꠟꠞ ꠛꠡꠔ ꠈꠣꠘꠣ ꠉꠥꠡꠘ ꠄꠟꠣꠇꠣꠞꠦ ꠁꠔꠣ ꠕꠣꠇꠤ ꠛꠣꠌꠣꠁꠝꠥ, ꠁꠘꠅ ꠒꠣꠡ-ꠝꠣꠍꠤꠞ ꠙꠣꠟ ꠀꠁꠔꠣ ꠘꠣꠄ। ꠔꠦꠃ ꠔꠥꠝꠤ ꠛꠥꠎꠔꠣꠄ ꠙꠣꠞꠛꠣꠄ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣ ꠁ ꠖꠦꠡꠅ ꠀꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","ꠀꠝꠤ ꠔ ꠀꠝꠣꠞ ꠛꠘ꠆ꠖꠣ ꠀꠞ ꠔꠥꠝꠣꠞ ꠙ꠆ꠞꠎꠣꠞ ꠝꠣꠎꠦ ꠔꠚꠣꠔ-ꠙꠣꠞ꠆ꠕꠇ꠆ꠇ ꠇꠞꠝꠥ, ꠇꠣꠁꠟ ꠁ ꠘꠝꠥꠘꠣ ꠖꠦꠈꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠅꠃꠟꠣ ꠇꠞꠟꠣ, ꠚꠦꠞꠣꠃꠘ ꠀꠞ ꠔꠣꠞ ꠃꠎꠤꠞ-ꠘꠣꠎꠤꠞꠞ ꠊꠞꠅ ꠇꠣꠝꠠꠣꠅꠞꠣ ꠒꠣꠡ-ꠝꠣꠍꠤꠞ ꠙꠣꠟ ꠀꠁꠟ, ꠀꠡ꠆ꠔꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠢꠇ꠆ꠇꠟꠛꠣꠄ ꠒꠣꠡ-ꠝꠣꠍꠤꠞ ꠟꠣꠉꠤ ꠡꠞ꠆ꠛꠘꠣꠡ ꠅꠁꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","ꠔꠦꠃ ꠚꠦꠞꠣꠃꠘꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠒꠣꠇꠣꠁꠀ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠎꠣꠅ, ꠖꠦꠡꠞ ꠜꠤꠔꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠞꠅꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","ꠝꠥꠍꠣꠄ ꠇꠁꠟꠣ, “ꠁꠟꠣ ꠇꠞꠣ ꠑꠤꠇ ꠘꠣꠄ, ꠇꠣꠞꠘ ꠀꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠦ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠊꠤꠘ꠆ꠘꠣ ꠇꠞꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠞꠔꠦ ꠅꠁꠛ। ꠀꠞ ꠖꠦꠈꠃꠇ꠆ꠇꠣ, ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠍꠣꠝꠘꠦ ꠔꠣꠞꠣꠞ ꠊꠤꠘ꠆ꠘꠣ ꠇꠞꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠞꠟꠦ ꠔꠣꠞꠣ ꠔ ꠀꠝꠞꠣꠞꠦ ꠙꠣꠔ꠆ꠔꠞꠖꠤ ꠁꠐꠣꠁꠀ ꠝꠣꠞꠤꠟꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","ꠔꠦ ꠀꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠇꠞꠛꠣ, ꠀꠝꠞꠣ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠛꠣꠄ ꠔꠤꠘ ꠖꠤꠘꠞ ꠙꠕ ꠢꠞꠤꠀ ꠉꠤꠀ, ꠔꠣꠘ ꠘꠣꠝꠦ ꠅꠃꠟꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠞꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","ꠚꠦꠞꠣꠃꠘꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠍꠣꠠꠤ ꠖꠤꠀꠞ, ꠔꠥꠝꠞꠣ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠉꠤꠀ ꠔꠥꠝꠞꠣꠞ ꠀꠟ꠆ꠟꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠞꠅ। ꠅꠁꠟꠦ ꠛꠦꠡꠤ ꠖꠥꠞꠁ ꠎꠣꠁꠅ ꠘꠣ, ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠟꠣꠉꠤꠅ ꠝꠤꠘꠔ ꠇꠞꠤꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","ꠅꠃ ꠝꠥꠍꠣꠄ ꠇꠁꠟꠣ, “ꠖꠦꠈꠃꠇ꠆ꠇꠣ, ꠀꠝꠤ ꠀꠙꠘꠣꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠢꠞꠤꠀ ꠉꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍꠦ ꠝꠤꠘꠔꠤ ꠇꠞꠝꠥ, ꠔꠦꠃ ꠇꠣꠁꠟ ꠀꠙꠘꠣꠞ ꠉꠦꠍ ꠕꠣꠇꠤ, ꠀꠙꠘꠣꠞ ꠃꠎꠤꠞ-ꠘꠣꠎꠤꠞ ꠀꠞ ꠀꠙꠘꠣꠞ ꠙ꠆ꠞꠎꠣ ꠅꠇꠟꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠒꠣꠡ-ꠝꠣꠍꠤꠞ ꠙꠣꠟ ꠢꠞꠤꠎꠤꠛꠣ। ꠅꠁꠟꠦ ꠝꠣꠘꠡꠦ ꠝꠣꠛꠥꠖꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠞꠣꠔ ꠎꠣꠁꠔꠦ ꠀꠙꠘꠦ ꠀꠞ ꠇꠥꠘꠥ ꠜꠣꠅꠔꠣꠛꠣꠎꠤ ꠇꠞꠂꠘ ꠘꠣ ꠎꠣꠘꠥ।” ");
INSERT INTO syls_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","ꠛꠣꠖꠦ ꠝꠥꠍꠣꠄ ꠚꠦꠞꠣꠃꠘꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠉꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍꠦ ꠝꠤꠘꠔꠤ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞ ꠀꠞꠎꠤ ꠝꠣꠚꠤꠇ ꠇꠣꠝ ꠇꠞꠟꠣ। ꠚꠦꠞꠣꠃꠘ, ꠔꠣꠞ ꠃꠎꠤꠞ-ꠘꠣꠎꠤꠞ ꠀꠞ ꠔꠣꠞ ꠙ꠆ꠞꠎꠣ ꠅꠇꠟꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠢꠇ꠆ꠇꠟ ꠒꠣꠡ-ꠝꠣꠍꠤ ꠢꠞꠤꠉꠦꠟꠣ, ꠄꠉꠥꠅ ꠞꠁꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","ꠅꠁꠟꠦ ꠢꠤꠞꠛꠣꠞ ꠚꠦꠞꠣꠃꠘꠦ ꠔꠣꠞ ꠖꠤꠟ ꠙꠣꠡꠣꠘ ꠇꠞꠤꠟ꠆ꠟ, ꠝꠣꠘꠡꠞꠦ ꠍꠣꠠꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠚꠦꠞꠣꠃꠘꠞ ꠇꠣꠍꠣꠔ ꠉꠤꠀ ꠔꠣꠞꠦ ꠇꠅ, ꠝꠣꠛꠥꠖ, ꠎꠦꠁꠘ ꠁꠛꠞꠣꠘꠤ ꠅꠇꠟꠞ ꠀꠟ꠆ꠟꠣ, ꠔꠣꠁꠘ ꠘꠤꠎꠦ ꠇꠁꠞꠣ, ꠀꠝꠣꠞ ꠄꠛꠣꠖꠔ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠀꠝꠣꠞ ꠛꠘ꠆ꠖꠣ ꠅꠇꠟꠞꠦ ꠍꠣꠠꠤ ꠖꠦꠅ। ");
INSERT INTO syls_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","ꠔꠣꠞꠣꠞꠦ ꠍꠣꠠꠔꠦ ꠞꠣꠎꠤ ꠘꠣ ꠅꠁꠀ ꠅꠈꠘꠅ ꠛꠣꠗꠣ ꠖꠤꠟꠦ, ");
INSERT INTO syls_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ꠢꠥꠘꠤꠀ ꠞꠣꠈꠅ, ꠛꠘ꠆ꠖꠞ ꠝꠣꠎꠦ ꠔꠥꠝꠣꠞ ꠙꠡꠥꠁꠘ꠆ꠔꠞ ꠃꠙꠞꠦ, ꠊꠥꠠꠣꠁꠘ꠆ꠔꠞ, ꠉꠣꠗꠣꠁꠘ꠆ꠔꠞ, ꠃꠐ, ꠀꠞ ꠉꠞꠥ-ꠍꠣꠉꠟ, ꠝꠦꠠꠣꠁꠘ꠆ꠔꠞ ꠃꠙꠞꠦꠅ ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠀꠔ ꠖꠤꠝꠥ, ꠛꠦꠕꠣꠄꠀ ꠛꠦꠝꠣꠞꠞ ꠝꠞꠇꠤ ꠍꠣꠠꠤꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","ꠅꠁꠟꠦ ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠝꠤꠡꠞꠞ ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠙꠡꠥꠞ ꠝꠣꠎꠦ ꠔꠚꠣꠔ ꠇꠞꠝꠥ; ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠇꠥꠘꠥ ꠙꠡꠥ ꠝꠞꠔꠣ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠡꠝꠄꠅ ꠑꠤꠇ ꠇꠞꠤꠀ ꠖꠤꠟꠣꠁꠟꠣ, ꠍꠣꠝꠘꠞ ꠇꠣꠁꠟ ꠔꠣꠁꠘ ꠖꠦꠡꠅ ꠁ ꠇꠣꠝ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","ꠢꠣꠍꠣꠃ ꠛꠣꠖꠞ ꠖꠤꠘ ꠝꠣꠛꠥꠖꠦ ꠅꠃꠟꠣꠃ ꠇꠞꠟꠣ, ꠔꠦꠃ ꠝꠤꠡꠞꠞ ꠢꠇ꠆ꠇꠟ ꠙꠡꠥ ꠝꠞꠤꠉꠦꠟꠣ, ꠅꠁꠟꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠄꠉꠥ ꠙꠡꠥꠅ ꠝꠞꠟꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ꠚꠦꠞꠣꠃꠘꠦ ꠝꠣꠘꠥꠡꠖꠤ ꠈꠛꠞ ꠟꠁꠀ ꠖꠦꠈꠟ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠄꠉꠥ ꠙꠡꠥꠅ ꠝꠞꠍꠂꠘ ꠘꠣ; ꠔꠣ-ꠅ ꠔꠣꠞ ꠖꠤꠟ ꠙꠣꠡꠣꠘ ꠞꠁꠟ, ꠢꠦ ꠝꠣꠘꠡꠞꠦ ꠍꠣꠠꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","ꠅꠃ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠖꠥꠁꠅꠎꠘꠦ ꠝꠥꠁꠐ ꠜꠞꠤꠀ ꠃꠘ꠆ꠖꠣꠟꠞ ꠍꠣꠟꠤ ꠀꠘꠅ, ꠀꠘꠤꠀ ꠝꠥꠍꠣꠄ ꠅꠃ ꠍꠣꠟꠤꠞꠦ ꠚꠦꠞꠣꠃꠘꠞ ꠍꠣꠝꠘꠦ ꠃꠙꠞꠦꠖꠤ ꠍꠤꠐꠣꠁ ꠖꠦꠅ। ");
INSERT INTO syls_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","ꠖꠦꠈꠛꠣꠄꠘꠦ, ꠁꠔꠣ ꠢꠣꠞꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠝꠣꠎꠦ ꠙꠣꠔꠟꠣ ꠗꠥꠁꠟ ꠅꠁꠀ ꠢꠇꠟ ꠎꠣꠉꠣꠞ ꠝꠣꠘꠥꠡ ꠀꠞ ꠙꠡꠥꠁꠘ꠆ꠔꠞ ꠉꠔꠞꠅ ꠉꠎꠛꠤ ꠛꠤꠡ-ꠚꠥꠞꠤ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","ꠔꠦꠃ ꠔꠣꠞꠣ ꠃꠘ꠆ꠖꠣꠟꠞ ꠍꠣꠟꠤ ꠀꠘꠤꠀ ꠚꠦꠞꠣꠃꠘꠞ ꠍꠣꠝꠘꠦ ꠃꠛꠣꠁꠀ, ꠝꠥꠍꠣꠄ ꠃꠙꠞꠦꠖꠤ ꠍꠤꠐꠣꠁ ꠖꠤꠟꠣ, ꠄꠔꠦ ꠝꠣꠘꠡꠞ ꠀꠞ ꠙꠡꠥꠁꠘ꠆ꠔꠞ ꠉꠔꠞꠅ ꠛꠤꠡ-ꠚꠥꠞꠤ ꠚꠥꠐꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","ꠀꠞ ꠅꠃ ꠚꠥꠞꠤꠞ ꠟꠣꠉꠤ ꠎꠣꠖꠥꠉꠤꠞ ꠅꠇꠟꠦ ꠝꠥꠍꠣꠞ ꠍꠣꠝꠘꠦ ꠃꠛꠣꠁꠔꠣ ꠙꠣꠞꠟꠣ ꠘꠣ, ꠢꠇꠟ ꠝꠤꠡꠞꠤ ꠀꠞ ꠎꠣꠖꠥꠉꠤꠞ ꠅꠇꠟꠞ ꠉꠔꠞꠅ-ꠅ ꠛꠤꠡ-ꠚꠥꠞꠤ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","ꠅꠁꠟꠦ ꠝꠣꠛꠥꠖꠦ ꠚꠦꠞꠣꠃꠘꠞ ꠖꠤꠟ ꠙꠣꠡꠣꠘ ꠇꠞꠤꠟ꠆ꠟꠣ। ꠢꠦ ꠄꠞꠣꠞ ꠝꠣꠔꠦ ꠇꠣꠘ ꠖꠤꠟ ꠘꠣ, ꠎꠦꠟꠣ ꠝꠣꠛꠥꠖꠦ ꠀꠉꠦ ꠇꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠛꠤꠀꠘꠦ ꠃꠑꠤꠀ ꠚꠦꠞꠣꠃꠘꠞ ꠍꠣꠝꠘꠦ ꠃꠛꠣꠁꠀ ꠅꠃꠟꠣ ꠇꠁꠅ, ꠝꠣꠛꠥꠖ, ꠎꠦꠁꠘ ꠁꠛꠞꠣꠘꠤ ꠅꠇꠟꠞ ꠀꠟ꠆ꠟꠣ, ꠔꠣꠁꠘ ꠘꠤꠎꠦ ꠇꠁꠞꠣ, ꠀꠝꠣꠞ ꠄꠛꠣꠖꠔ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠀꠝꠣꠞ ꠛꠘ꠆ꠖꠣ ꠅꠇꠟꠞꠦ ꠍꠣꠠꠤ ꠖꠦꠅ। ");
INSERT INTO syls_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","ꠘꠣꠁꠟꠦ ꠁꠚꠤꠞꠣ ꠀꠝꠤ ꠔꠥꠝꠣꠞ, ꠔꠥꠝꠣꠞ ꠃꠎꠤꠞ-ꠘꠣꠎꠤꠞ ꠀꠞ ꠔꠥꠝꠣꠞ ꠙ꠆ꠞꠎꠣ ꠅꠇꠟꠞ ꠝꠣꠎꠦ ꠀꠝꠣꠞ ꠢꠇ꠆ꠇꠟ ꠎꠣꠔꠞ ꠉꠎꠛ ꠍꠣꠠꠤꠝꠥ। ꠔꠦꠃ ꠔꠥꠝꠤ ꠛꠥꠎꠛꠣꠄ, ꠢꠣꠞꠣ ꠖꠥꠘꠤꠀꠁꠔ ꠀꠝꠣꠞ ꠢꠝꠣꠘꠤ ꠇꠦꠃ ꠘꠣꠁ। ");
INSERT INTO syls_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","ꠄꠞ ꠀꠉꠦꠃ ꠀꠝꠤ ꠀꠝꠣꠞ ꠀꠔ ꠛꠣꠠꠣꠁꠀ ꠛꠦꠕꠣꠄꠀ ꠝꠞꠇꠤ ꠖꠤꠀ ꠔꠥꠝꠣꠞꠦ ꠀꠞ ꠔꠥꠝꠣꠞ ꠙ꠆ꠞꠎꠣ ꠅꠇꠟꠞꠦ ꠝꠣꠞꠔꠣꠝ ꠙꠣꠞꠟꠣꠝ ꠅꠘꠦ, ꠔꠥꠝꠤ ꠖꠥꠘꠤꠀꠁ ꠕꠣꠇꠤ ꠛꠤꠘꠣꠡ ꠅꠁꠉꠦꠟꠣꠄ ꠅꠘꠦ। ");
INSERT INTO syls_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","ꠀꠍꠟꠦ ꠄꠞꠟꠣꠉꠤꠃ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠖꠥꠘꠤꠀꠁꠔ ꠅꠔꠖꠤꠘ ꠛꠣꠌꠣꠁꠍꠤ, ꠎꠣꠔꠦ ꠔꠥꠝꠣꠞꠦ ꠀꠝꠣꠞ ꠟꠤꠟꠣ-ꠈꠦꠟꠣ ꠖꠦꠈꠣꠁ, ꠀꠞ ꠢꠣꠞꠣ ꠖꠥꠘꠤꠀꠁꠔ ꠀꠝꠣꠞ ꠘꠣꠝ ꠎꠣꠁꠞ ꠅꠄ। ");
INSERT INTO syls_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","ꠔꠥꠝꠤ ꠅꠈꠘꠅ ꠀꠝꠣꠞ ꠛꠘ꠆ꠖꠣ ꠅꠇꠟꠞꠦ ꠍꠣꠠꠞꠣꠄ ꠘꠣ, ꠔꠥꠝꠣꠞ ꠛꠦꠐꠣꠉꠤꠞꠤ ꠖꠦꠈꠣꠁꠞꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","ꠔꠦ ꠖꠦꠈꠤꠅ, ꠇꠣꠁꠟ ꠁ ꠡꠝꠄꠄ ꠀꠝꠤ ꠅꠃ ꠟꠣꠈꠣꠘ ꠢꠤꠟ-ꠔꠥꠚꠣꠘ ꠀꠞ ꠝꠦꠊ ꠖꠤꠝꠥ, ꠎꠦꠔꠣ ꠝꠤꠡꠞꠞ ꠎꠘꠝ ꠕꠣꠇꠤ ꠀꠁꠎ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠇꠥꠘꠥꠖꠤꠘ ꠅꠁꠍꠦ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","ꠄꠞꠟꠣꠉꠤ ꠛꠘ꠆ꠖꠞ ꠝꠣꠎꠦ ꠔꠥꠝꠣꠞ ꠙꠡꠥꠁꠘ ꠀꠞ ꠎꠔꠔꠣ ꠀꠍꠦ, ꠁꠔꠣꠞꠦ ꠀꠘꠤꠀ ꠊꠞꠅ ꠢꠣꠞꠣꠅ; ꠝꠣꠘꠥꠡ ꠛꠣ ꠙꠡꠥꠁꠘ ꠎꠦꠔꠣ ꠊꠞꠅ ꠢꠣꠝꠣꠁꠔꠣ ꠘꠣꠄ, ꠁꠔꠣꠞ ꠃꠙꠞꠦ ꠢꠤꠟ ꠙꠠꠤꠀ ꠢꠇ꠆ꠇꠟꠐꠤ ꠝꠞꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ꠔꠦꠃ ꠚꠦꠞꠣꠃꠘꠞ ꠃꠎꠤꠞ-ꠘꠣꠎꠤꠞꠞ ꠝꠣꠎꠦ ꠎꠦꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠎꠛꠣꠘꠦ ꠒꠞꠣꠁꠟꠣ, ꠔꠣꠞꠣ ꠎꠟꠖꠤ ꠇꠞꠤ ꠘꠤꠎꠞ ꠉꠥꠟꠣꠝ ꠀꠞ ꠙꠡꠥꠁꠘ꠆ꠔꠞꠦ ꠊꠞꠞ ꠜꠤꠔꠞꠦ ꠀꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","ꠅꠁꠟꠦ ꠝꠣꠛꠥꠖꠞ ꠎꠛꠣꠘꠞꠦ ꠎꠦꠔꠣꠄ ꠖꠣꠝ ꠖꠤꠟ ꠘꠣ, ꠔꠣꠞꠣꠞ ꠉꠥꠟꠣꠝ ꠀꠞ ꠙꠡꠥꠁꠘ꠆ꠔꠞꠦ ꠛꠘ꠆ꠖꠞ ꠝꠣꠎꠦ ꠕꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠀꠍꠝꠣꠘꠞ ꠛꠣꠄ ꠘꠤꠎꠞ ꠀꠔ ꠛꠣꠠꠣꠅ, ꠔꠦꠃ ꠝꠤꠡꠞꠞ ꠢꠇ꠆ꠇꠟ ꠎꠣꠉꠣꠔ ꠢꠤꠟ-ꠔꠥꠚꠣꠘ ꠅꠁꠛ, ꠝꠤꠡꠞꠞ ꠝꠣꠘꠥꠡ, ꠙꠡꠥ ꠀꠞ ꠈꠦꠔꠞ ꠢꠇꠟ ꠉꠣꠍ-ꠉꠣꠍꠣꠟꠤꠞ ꠃꠙꠞꠦ ꠁꠔꠣ ꠙꠠꠛ।” ");
INSERT INTO syls_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","ꠅꠃ ꠝꠥꠍꠣꠄ ꠔꠣꠘ ꠀꠔꠞ ꠟꠣꠑꠤ ꠃꠙꠞꠦꠖꠤ ꠔꠥꠟꠟꠣ, ꠝꠣꠛꠥꠖꠦ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠃꠙꠞꠦ ꠝꠦꠊꠞ ꠒꠣꠇ-ꠎꠤꠟꠇꠣꠘꠤꠞ ꠟꠉꠦ ꠢꠤꠟ-ꠔꠥꠚꠣꠘ ꠖꠦꠅꠀꠁꠟꠣ; ꠀꠞ ꠀꠍꠝꠣꠘꠤ ꠑꠣꠐꠣ ꠎꠝꠤꠘꠅ ꠙꠠꠟ। ");
INSERT INTO syls_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","ꠅꠃ ꠢꠤꠟꠞ ꠟꠉꠦ ꠝꠦꠊꠞ ꠎꠤꠟꠇꠣꠘꠤ ꠀꠞ ꠑꠣꠐꠣꠅ ꠀꠍꠤꠟ। ꠁ ꠟꠣꠈꠣꠘ ꠉꠎꠛꠤ ꠢꠤꠟ-ꠔꠥꠚꠣꠘ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠎꠘꠝ ꠕꠣꠇꠤ ꠇꠥꠘꠥꠖꠤꠘꠅ ꠅꠁꠍꠦ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ꠢꠣꠞꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠛꠘ꠆ꠖꠞ ꠝꠣꠎꠞ ꠢꠇ꠆ꠇꠟ ꠝꠣꠘꠥꠡ ꠀꠞ ꠙꠡꠥꠁꠘ꠆ꠔꠞ ꠃꠙꠞꠦꠅ ꠈꠥꠛ ꠎꠥꠞꠦ ꠎꠥꠞꠦ ꠢꠤꠟ ꠙꠠꠟ, ꠀꠞ ꠈꠦꠔꠞ ꠢꠇꠟ ꠚꠡꠟ ꠘꠡ꠆ꠐ ꠅꠁꠉꠦꠟ ꠀꠞ ꠢꠇꠟ ꠉꠣꠍ-ꠉꠣꠍꠣꠟꠤꠅ ꠜꠣꠋꠉꠤ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","ꠈꠣꠟꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠛꠡꠔ ꠈꠣꠘꠣ ꠉꠥꠡꠘ ꠄꠟꠣꠇꠣꠔ ꠢꠤꠟ-ꠔꠥꠚꠣꠘ ꠅꠁꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","ꠛꠣꠖꠦ ꠚꠦꠞꠣꠃꠘꠦ ꠝꠣꠘꠥꠡ ꠙꠣꠑꠣꠁꠀ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠀꠘꠣꠁꠀ ꠇꠁꠟ, “ꠁꠚꠤꠞꠣ ꠀꠝꠤ ꠅꠙꠞꠣꠗ ꠇꠞꠍꠤ। ꠝꠣꠛꠥꠖ ꠔ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ, ꠅꠁꠟꠦ ꠀꠝꠤ ꠀꠞ ꠀꠝꠣꠞ ꠙ꠆ꠞꠎꠣ ꠅꠇꠟ ꠅꠙꠞꠣꠗꠤ। ");
INSERT INTO syls_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","ꠔꠦ ꠉꠎꠛꠤ ꠝꠦꠊꠞ ꠒꠣꠇ ꠀꠞ ꠢꠤꠟ-ꠔꠥꠚꠣꠘ ꠔ ꠛꠃꠔ ꠅꠁꠍꠦ, ꠀꠞ ꠎꠣꠞꠔꠣꠝ ꠙꠣꠞꠤꠀꠞ ꠘꠣ। ꠄꠞꠟꠣꠉꠤ ꠀꠝꠤ ꠅꠈꠘ ꠔꠥꠝꠞꠣꠞꠦ ꠍꠣꠠꠤ ꠖꠤꠝꠥ, ꠀꠞ ꠀꠐꠇꠣꠁꠔꠣꠝ ꠘꠣꠄ। ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠟꠣꠉꠤ ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍꠦ ꠝꠤꠘꠔ ꠇꠞꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","ꠝꠥꠍꠣꠄ ꠔꠣꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠐꠣꠃꠘꠞ ꠛꠣꠁꠞꠦ ꠉꠤꠀꠃ ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍꠦ ꠀꠔ ꠔꠥꠟꠝꠥ, ꠔꠦꠃ ꠝꠦꠊꠞ ꠒꠣꠇ, ꠢꠤꠟ-ꠔꠥꠚꠣꠘ ꠛꠘ꠆ꠖ ꠅꠁꠎꠤꠛ, ꠎꠣꠔꠦ ꠀꠙꠘꠦ ꠛꠥꠎꠔꠣ ꠙꠣꠞꠂꠘ ꠁ ꠖꠥꠘꠤꠀꠁ ꠔ ꠝꠣꠛꠥꠖꠞ। ");
INSERT INTO syls_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","ꠅꠁꠟꠦ ꠀꠝꠤ ꠔ ꠎꠣꠘꠤ, ꠀꠙꠘꠦ ꠛꠣ ꠀꠙꠘꠣꠞ ꠃꠎꠤꠞ-ꠘꠣꠎꠤꠞ ꠅꠇꠟꠦ ꠅꠈꠘꠅ ꠀꠟ꠆ꠟꠣ ꠝꠣꠛꠥꠖꠞꠦ ꠒꠞꠣꠁꠞꠣ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","ꠁ ꠡꠝꠄ ꠈꠦꠔꠞ ꠢꠇꠟ ꠘꠣꠟꠤꠀ ꠉꠣꠍ ꠀꠞ ꠛꠣꠞ꠆ꠟꠤ ꠚꠡꠟ ꠘꠡ꠆ꠐ ꠅꠁꠉꠦꠟ, ꠇꠣꠞꠘ ꠘꠣꠟꠤꠀ ꠉꠣꠍꠞ ꠚꠥꠟ ꠀꠞ ꠛꠣꠞ꠆ꠟꠤꠞ ꠍꠠꠣ ꠛꠣꠞ ꠅꠁꠉꠦꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","ꠅꠁꠟꠦ ꠇꠥꠘꠥꠎꠣꠔꠞ ꠉꠝꠞ ꠉꠣꠍ ꠛꠠ ꠘꠣ ꠅꠀꠄ ꠁꠔꠣꠞ ꠈꠦꠔꠤ ꠅꠁꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","ꠔꠦꠃ ꠝꠥꠍꠣꠄ ꠚꠦꠞꠣꠃꠘꠞ ꠍꠣꠝꠘꠦ ꠕꠣꠇꠤ ꠐꠣꠃꠘꠞ ꠛꠣꠞꠦ ꠉꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍꠦ ꠀꠔ ꠔꠥꠟꠟꠣ, ꠟꠉꠦ ꠟꠉꠦ ꠝꠦꠊꠞ ꠒꠣꠇ, ꠢꠤꠟ-ꠔꠥꠚꠣꠘ ꠛꠘ꠆ꠖ ꠅꠁꠟ, ꠝꠦꠊꠞ ꠎꠠꠤꠅ ꠛꠘ꠆ꠖ ꠅꠁꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","ꠅꠁꠟꠦ ꠚꠦꠞꠣꠃꠘ ꠀꠞ ꠔꠣꠞ ꠃꠎꠤꠞ-ꠘꠣꠎꠤꠞ ꠅꠇꠟꠦ ꠝꠦꠊ, ꠝꠦꠊꠞ ꠒꠣꠇ ꠀꠞ ꠢꠤꠟ ꠙꠠꠣ ꠛꠘ꠆ꠖ ꠅꠁꠉꠦꠍꠦ ꠖꠦꠈꠤꠀ ꠔꠣꠞꠣꠞ ꠖꠤꠟ ꠙꠣꠡꠣꠘ ꠇꠞꠤꠟ꠆ꠟꠣ। ꠚꠦꠞꠣꠃꠘꠦ ꠢꠤꠞꠛꠣꠞ ꠉꠥꠘꠣ ꠇꠞꠟ। ");
INSERT INTO syls_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","ꠔꠣꠞ ꠖꠤꠟ ꠙꠣꠡꠣꠘ ꠅꠁꠎꠣꠅꠀꠄ, ꠢꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠍꠣꠠꠟ ꠘꠣ, ꠝꠣꠛꠥꠖꠦ ꠀꠉꠦ ꠎꠦꠟꠣ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠚꠦꠞꠣꠃꠘꠞ ꠉꠦꠍꠦ ꠎꠣꠅ; ꠀꠝꠤ ꠔ ꠔꠣꠞ ꠀꠞ ꠔꠣꠞ ꠃꠎꠤꠞ-ꠘꠣꠎꠤꠞꠞ ꠖꠤꠟꠞꠦ ꠙꠣꠡꠣꠘ ꠇꠞꠤꠟꠤꠍꠤ, ꠎꠣꠔꠦ ꠔꠣꠞꠣꠞ ꠍꠣꠝꠘꠦ ꠀꠝꠤ ꠀꠝꠣꠞ ꠇꠥꠖꠞꠔꠤ ꠟꠤꠟꠣ-ꠈꠦꠟꠣ ꠖꠦꠈꠣꠁꠔꠣꠝ ꠙꠣꠞꠤ। ");
INSERT INTO syls_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ꠀꠝꠤ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠃꠙꠞꠦ ꠎꠦꠔꠣ ꠎꠦꠔꠣ ꠇꠑꠤꠘ ꠉꠎꠛ ꠖꠤꠍꠤ, ꠔꠣꠞꠣꠞ ꠝꠣꠎꠦ ꠇꠥꠖꠞꠔꠤ ꠎꠦꠔꠣ ꠟꠤꠟꠣ-ꠈꠦꠟꠣ ꠎꠣꠁꠞ ꠇꠞꠍꠤ, ꠔꠥꠝꠤ ꠁꠔꠣ ꠔꠥꠝꠣꠞ ꠀꠅꠟꠣꠖ ꠀꠞ ꠘꠣꠔꠤ-ꠙꠥꠔꠤꠞ ꠉꠦꠍꠦ ꠉꠚ ꠇꠞꠔꠣꠄ ꠙꠣꠞ, ꠀꠞ ꠀꠝꠤꠃ ꠎꠦꠘ ꠝꠣꠛꠥꠖ ꠁꠐꠣ ꠛꠥꠎꠔꠣꠄ ꠙꠣꠞ।” ");
INSERT INTO syls_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","ꠔꠦꠃ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠦ ꠚꠦꠞꠣꠃꠘꠞ ꠉꠦꠍꠦ ꠉꠤꠀ ꠇꠁꠟꠣ, “ꠀꠟ꠆ꠟꠣ, ꠎꠦꠁꠘ ꠁꠛꠞꠣꠘꠤ ꠅꠇꠟꠞ ꠝꠣꠛꠥꠖ, ꠔꠣꠁꠘ ꠘꠤꠎꠦ ꠇꠁꠞꠣ, ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠝꠣꠕꠣ ꠘꠥꠀꠁꠔꠦ ꠀꠞ ꠇꠔꠖꠤꠘ ꠢꠞꠣꠁꠟ ꠞꠁꠔꠣꠄ? ꠢꠥꠘꠅ, ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠛꠘ꠆ꠖꠣ ꠅꠇꠟꠞꠦ ꠀꠝꠣꠞ ꠄꠛꠣꠖꠔ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠍꠣꠠꠤ ꠖꠦꠅ। ");
INSERT INTO syls_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","ꠔꠣꠞꠣꠞꠦ ꠍꠣꠠꠔꠦ ꠞꠣꠎꠤ ꠘꠣ ꠅꠁꠟꠦ ꠖꠦꠈꠤꠅ, ꠀꠝꠤ ꠇꠣꠁꠟ ꠔꠥꠝꠣꠞ ꠡꠤꠝꠣꠘꠣꠔ ꠙꠋꠉꠙꠣꠟ ꠅꠇꠟ ꠍꠣꠠꠤꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ꠁꠔꠣꠄ ꠀꠁꠀ ꠔꠥꠝꠣꠞ ꠀꠡ꠆ꠔꠣ ꠎꠝꠤꠘꠞꠦ ꠅꠃꠟꠣ ꠛꠦꠞꠤꠟꠤꠛꠣ, ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠝꠣꠐꠤ ꠖꠦꠈꠔ ꠙꠣꠞꠔ ꠘꠣꠄ। ꠢꠤꠟ-ꠔꠥꠚꠣꠘ ꠕꠣꠇꠤ ꠎꠔꠔꠣ ꠛꠣꠌꠤꠉꠦꠍꠦ, ꠈꠦꠔꠞ ꠝꠣꠎꠦ ꠎꠔ ꠉꠣꠍ-ꠉꠣꠍꠣꠟꠤ ꠞꠁꠍꠦ, ꠁꠔꠣ ꠢꠇ꠆ꠇꠟꠔꠣ ꠔꠣꠞꠣ ꠈꠣꠁꠟꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","ꠔꠥꠝꠣꠞ ꠘꠤꠎꠞ ꠊꠞ-ꠛꠣꠠꠤ, ꠔꠥꠝꠣꠞ ꠃꠎꠤꠞ-ꠘꠣꠎꠤꠞꠞ ꠊꠞꠣꠁꠘ, ꠀꠞ ꠢꠇ꠆ꠇꠟ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠊꠞꠣꠁꠘ ꠜꠞꠤꠀ ꠎꠣꠝ ꠅꠁꠎꠤꠛꠣ। ꠔꠥꠝꠣꠞ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤ ꠀꠞ ꠔꠣꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣ ꠅꠇꠟꠦꠅ ꠖꠥꠘꠤꠀꠁꠔ ꠔꠣꠞꠣꠞ ꠎꠘꠝ ꠕꠣꠇꠤ ꠀꠁꠎ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠇꠥꠘꠥꠖꠤꠘ ꠅꠃꠟꠣ ꠖꠦꠈꠍꠂꠘ ꠘꠣ।” ꠅꠈꠣꠘ ꠇꠁꠀꠃ ꠔꠣꠁꠘ ꠝꠥꠈ ꠚꠤꠞꠣꠁꠀ ꠚꠦꠞꠣꠃꠘꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠛꠣꠞꠦ ꠉꠦꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","ꠚꠦꠞꠣꠃꠘꠞ ꠃꠎꠤꠞ-ꠘꠣꠎꠤꠞꠦ ꠔꠣꠞꠦ ꠇꠁꠟꠣ, “ꠁ ꠛꠦꠐꠣꠄ ꠀꠞ ꠇꠔꠖꠤꠘ ꠀꠝꠞꠣꠞꠦ ꠍꠣꠔꠣꠁꠔ? ꠅꠔꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠄꠛꠣꠖꠔꠞ ꠟꠣꠉꠤ ꠅꠔꠣꠞꠦ ꠍꠣꠠꠤ ꠖꠦꠃꠇ꠆ꠇꠣ। ꠀꠙꠘꠦ ꠅꠈꠘꠅ ꠇꠥꠘ꠆ꠔꠣ ꠛꠥꠎꠞꠣ ꠘꠣ ꠘꠤ, ꠀꠡ꠆ꠔꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠘꠥ ꠍꠣꠞꠈꠣꠞ ꠅꠁꠎꠣꠞ?” ");
INSERT INTO syls_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","ꠅꠃ ꠚꠦꠞꠣꠃꠘꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠢꠤꠞꠛꠣꠞ ꠀꠘꠣꠁꠟ, ꠀꠘꠣꠁꠀ ꠇꠁꠟ, “ꠔꠥꠝꠞꠣ ꠎꠣꠅꠉꠤ, ꠉꠤꠀ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠄꠛꠣꠖꠔ ꠇꠞꠅ। ꠅꠁꠟꠦ ꠇꠦ ꠇꠦ ꠎꠣꠁꠔꠣꠄ ꠌꠣꠁꠞꠣꠄ?” ");
INSERT INTO syls_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","ꠝꠥꠍꠣꠄ ꠇꠁꠟꠣ, “ꠀꠝꠞꠣ ꠔ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠢꠎꠅ ꠎꠣꠁꠞꠣꠝ। ꠔꠦ ꠀꠝꠞꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ, ꠝꠥꠞꠛ꠆ꠛꠤ, ꠙꠥꠀ-ꠙꠥꠠꠤꠘ ꠀꠞ ꠉꠞꠥ-ꠍꠣꠉꠟ ꠟꠁꠀ ꠎꠣꠁꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ꠚꠦꠞꠣꠃꠘꠦ ꠇꠁꠟ, “ꠀꠁꠌ꠆ꠍꠣ, ꠀꠝꠤ ꠎꠥꠖꠤ ꠢꠣꠍꠣꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠢꠥꠞꠥꠔ꠆ꠔꠣ-ꠝꠥꠞꠥꠔ꠆ꠔꠣ ꠖꠤꠀ ꠍꠣꠠꠤ ꠖꠦꠁ, ꠔꠦ ꠔꠥꠝꠞꠣꠞ ꠅꠃ ꠝꠣꠛꠥꠖꠅ ꠎꠣꠘꠥ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠅꠁꠀ ꠎꠣꠄꠉꠤ। ꠈꠛꠞꠖꠣꠞ! ꠔꠥꠝꠞꠣꠞ ꠝꠔꠟꠛ ꠔ ꠜꠣꠟꠣ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","ꠘꠣ, ꠁꠟꠣ ꠔ ꠅꠁꠔ ꠘꠣꠄ, ꠔꠥꠝꠞꠣꠞ ꠢꠇ꠆ꠇꠟꠔꠣ ꠘꠤꠔꠦ ꠖꠤꠔꠣꠝ ꠘꠣꠄ। ꠔꠥꠝꠞꠣ ꠎꠦꠛꠟꠣ ꠎꠣꠁꠔꠣꠄꠃ ꠌꠣꠁꠞꠣꠄ, ꠔꠦ ꠈꠣꠟꠤ ꠛꠦꠐꠣꠁꠘ ꠎꠣꠅꠉꠤ।” ꠅꠈꠣꠘ ꠇꠁꠀ ꠢꠣꠞꠤ ꠚꠦꠞꠣꠃꠘꠦ ꠔꠣꠞ ꠍꠣꠝꠘꠦ ꠕꠣꠇꠤ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠈꠦꠖꠣꠁ ꠖꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","ꠔꠦꠃ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠃꠙꠞꠦ ꠙꠋꠉꠙꠣꠟꠞ ꠟꠣꠉꠤ ꠀꠔ ꠔꠥꠟꠅ, ꠙꠋꠉꠙꠣꠟꠦ ꠀꠁꠀ ꠝꠤꠡꠞꠞ ꠎꠝꠤꠘꠞ ꠢꠇꠟ ꠉꠣꠍ-ꠉꠣꠍꠣꠟꠤ ꠈꠣꠁꠟꠤꠛ। ꠢꠤꠟ-ꠔꠥꠚꠣꠘ ꠕꠣꠇꠤ ꠎꠔꠔꠣ ꠛꠣꠌꠤꠍꠦ, ꠁꠔꠣ ꠢꠇ꠆ꠇꠟꠔꠣ ꠈꠣꠁꠟꠤꠛ।” ");
INSERT INTO syls_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","ꠝꠥꠍꠣꠄ ꠝꠤꠡꠞꠞ ꠃꠙꠞꠦ ꠔꠣꠘ ꠟꠣꠑꠤ ꠝꠦꠟꠤꠀ ꠗꠞꠟꠣ, ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠢꠣꠞꠣ ꠖꠤꠘ ꠢꠣꠞꠣ ꠞꠣꠁꠔ ꠖꠦꠡꠞ ꠝꠣꠎꠦ ꠙꠥꠛꠣꠟꠤ ꠢꠣꠅꠀ ꠍꠣꠠꠟꠣ, ꠅꠃ ꠙꠥꠛꠣꠟꠤ ꠢꠣꠅꠀꠄ ꠛꠤꠀꠘꠦ ꠙꠋꠉꠙꠣꠟ ꠟꠁꠀ ꠀꠎꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","ꠢꠣꠞꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠃꠙꠞꠦ ꠙꠋꠉꠙꠣꠟꠦ ꠎꠣꠝ ꠅꠁꠉꠦꠟꠣ। ꠝꠤꠡꠞꠞ ꠢꠇꠟ ꠎꠣꠉꠣꠔ ꠙꠋꠉꠙꠣꠟꠦ ꠉꠤꠍꠉꠤꠍ ꠇꠞꠟꠣ, ꠈꠥꠛ ꠛꠦꠡꠤ ꠙꠋꠉꠙꠣꠟ ꠀꠁꠟꠣ, ꠅꠔ ꠙꠋꠉꠙꠣꠟ ꠄꠞ ꠀꠉꠦꠅ ꠇꠥꠘꠥꠖꠤꠘ ꠅꠁꠍꠂꠘ ꠘꠣ ꠀꠞ ꠛꠣꠖꠦꠅ ꠇꠥꠘꠥꠖꠤꠘ ꠅꠁꠔꠣ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","ꠔꠣꠞꠣ ꠀꠡ꠆ꠔꠣ ꠎꠝꠤꠘꠞ ꠃꠙꠞ ꠉꠥꠞꠤꠟꠤꠟꠣ, ꠖꠦꠡ ꠀꠘ꠆ꠖꠣꠁꠞ ꠅꠁꠉꠦꠟ, ꠀꠞ ꠎꠝꠤꠘꠞ ꠎꠔ ꠈꠦꠔ, ꠉꠣꠍ-ꠉꠣꠍꠣꠟꠤ ꠢꠤꠟ-ꠔꠥꠚꠣꠘ ꠕꠣꠇꠤ ꠛꠣꠌꠤꠉꠦꠍꠤꠟ, ꠁꠔꠣ ꠢꠇ꠆ꠇꠟꠔꠣ ꠈꠣꠁꠟꠤꠟꠣ। ꠀꠡ꠆ꠔꠣ ꠝꠤꠡꠞꠞ ꠇꠥꠘꠥ ꠉꠣꠍ-ꠉꠣꠍꠣꠟꠤ ꠛꠣ ꠈꠦꠔꠞ ꠚꠡꠟ ꠇꠥꠘ꠆ꠔꠣꠃ ꠞꠁꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","ꠚꠦꠞꠣꠃꠘꠦ ꠎꠟꠖꠤ ꠇꠞꠤ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠀꠘꠣꠁꠀ ꠇꠁꠟ, “ꠀꠝꠤ ꠔ ꠔꠥꠝꠞꠣ ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠉꠦꠍꠦ ꠉꠥꠘꠣꠉꠣꠞ ꠅꠁꠉꠦꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","ꠔꠦ ꠝꠤꠘꠔ ꠇꠞꠤꠀꠞ, ꠈꠣꠟꠤ ꠄꠇꠈꠣꠘ ꠛꠣꠞ ꠀꠝꠣꠞ ꠉꠥꠘꠣ ꠝꠣꠚ ꠇꠞꠤ ꠖꠦꠅ। ꠀꠝꠣꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠁ ꠝꠞꠘ ꠀꠙꠖꠞꠦ ꠢꠞꠣꠁ ꠘꠦꠅꠀꠞ ꠟꠣꠉꠤ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞꠦ ꠝꠤꠘꠔ ꠇꠞꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","ꠅꠃ ꠝꠥꠍꠣꠄ ꠚꠦꠞꠣꠃꠘꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠢꠞꠤꠀ ꠉꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍꠦ ꠝꠤꠘꠔ ꠇꠞꠟꠣ; ");
INSERT INTO syls_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠈꠥꠛ ꠎꠥꠞꠦ ꠙꠌ꠆ꠌꠤꠝꠣ ꠢꠣꠅꠀ ꠍꠣꠠꠟꠣ, ꠁꠔꠣꠄ ꠙꠋꠉꠙꠣꠟ ꠅꠇꠟꠞꠦ ꠈꠦꠖꠣꠁꠀ ꠍꠣꠚ ꠇꠞꠤꠀ ꠘꠤꠟ ꠖꠞꠤꠀꠔ ꠚꠣꠟꠣꠁꠟ, ꠝꠤꠡꠞꠞ ꠇꠥꠘꠥ ꠎꠣꠉꠣꠔ ꠄꠉꠥ ꠙꠥꠇꠅ ꠞꠁꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","ꠅꠁꠟꠦ ꠝꠣꠛꠥꠖꠦ ꠚꠦꠞꠣꠃꠘꠞ ꠖꠤꠟ ꠙꠣꠡꠣꠘ ꠇꠞꠤꠟ꠆ꠟꠣ, ꠢꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠍꠣꠠꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠀꠍꠝꠣꠘ ꠝꠥꠈꠣ ꠔꠥꠝꠣꠞ ꠀꠔ ꠛꠣꠠꠣꠅ; ꠔꠦꠃ ꠢꠣꠞꠣ ꠖꠦꠡꠅ ꠅꠔ ꠊꠘ ꠀꠘ꠆ꠖꠣꠁꠞ ꠅꠁꠛ, ꠁ ꠀꠘ꠆ꠖꠣꠁꠞ ꠀꠔ ꠖꠤꠀ ꠍꠥꠀ ꠎꠣꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","ꠝꠥꠍꠣꠄ ꠀꠍꠝꠣꠘ ꠝꠥꠈꠣ ꠀꠔ ꠛꠣꠠꠣꠁꠟꠦ ꠔꠤꠘ ꠖꠤꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠣꠞꠣ ꠝꠤꠡꠞ ꠖꠦꠡ ꠈꠥꠛ ꠊꠘ ꠀꠘ꠆ꠖꠣꠁꠞ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ꠔꠤꠘ ꠖꠤꠘ ꠇꠦꠃ ꠇꠦꠃꠞꠞ ꠝꠥꠈꠅ ꠖꠦꠈꠔ ꠙꠣꠞꠟ ꠘꠣ, ꠇꠦꠃ ꠎꠣꠉꠣ ꠕꠣꠇꠤ ꠟꠠꠔ ꠙꠣꠞꠟ ꠘꠣ। ꠅꠁꠟꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠢꠇꠟ ꠊꠞꠅ ꠇꠥꠘꠥ ꠞꠥꠡꠘꠤꠞ ꠅꠜꠣꠛ ꠀꠍꠤꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","ꠚꠦꠞꠣꠃꠘꠦ ꠝꠥꠍꠣꠞꠦ ꠀꠘꠣꠁꠀ ꠇꠁꠟ, “ꠎꠣꠅ, ꠔꠥꠝꠞꠣ ꠉꠤꠀ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖꠞ ꠄꠛꠣꠖꠔ ꠇꠞꠅ, ꠔꠥꠝꠞꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘꠞꠦꠅ ꠘꠦꠅꠉꠤ, ꠈꠣꠟꠤ ꠔꠥꠝꠞꠣꠞ ꠉꠞꠥ-ꠍꠣꠉꠟꠞ ꠙꠣꠟ ꠕꠣꠇꠃꠇ।” ");
INSERT INTO syls_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","ꠝꠥꠍꠣꠄ ꠇꠁꠟꠣ, “ꠀꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠦ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ, ꠙꠡꠥ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠁꠘ ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠘꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠅꠁꠀ ꠀꠝꠞꠣꠞ ꠙꠡꠥꠁꠘꠅ ꠎꠣꠁꠛꠣ, ꠙꠡꠥꠞ ꠄꠇꠈꠣꠘ ꠈꠥꠞꠣꠅ ꠕꠁꠀ ꠎꠣꠁꠔꠣꠝ ꠘꠣꠄ। ꠀꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠄꠛꠣꠖꠔꠞ ꠟꠣꠉꠤ ꠅꠘ ꠕꠣꠇꠤ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠞꠣ ꠟꠣꠉꠛ, ꠀꠞ ꠇꠤꠔꠣ ꠇꠤꠔꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠞꠔꠣꠝ, ꠁꠔꠣ ꠀꠝꠞꠣ ꠢꠘꠅ ꠘꠣ ꠉꠦꠟꠦ ꠇꠁꠔꠣꠝ ꠙꠣꠞꠔꠣꠝ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","ꠅꠁꠟꠦ ꠝꠣꠛꠥꠖꠦ ꠚꠦꠞꠣꠃꠘꠞ ꠖꠤꠟ ꠙꠣꠡꠣꠘ ꠇꠞꠤꠟ꠆ꠟꠣ, ꠢꠦ ꠄꠞꠣꠞꠦ ꠍꠣꠠꠔꠦ ꠞꠣꠎꠤ ꠅꠁꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","ꠚꠦꠞꠣꠃꠘꠦ ꠇꠁꠟ, “ꠀꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠕꠣꠇꠤ ꠜꠣꠉꠅ। ꠈꠛꠞꠖꠣꠞ! ꠀꠝꠣꠞ ꠝꠥꠈꠞ ꠍꠣꠝꠘꠦ ꠀꠞ ꠇꠥꠘꠥꠖꠤꠘ ꠀꠁꠅ ꠘꠣ। ꠀꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠎꠦꠖꠤꠘ ꠀꠁꠛꠣꠄ, ꠢꠤꠖꠤꠘ ꠎꠣꠘ ꠈꠥꠀꠁꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","ꠝꠥꠍꠣꠄ ꠇꠁꠟꠣ, “ꠜꠣꠟꠣꠞꠦ ꠜꠣꠟꠣ! ꠀꠝꠤ ꠡꠈ ꠇꠞꠤꠀ ꠇꠥꠘꠥꠖꠤꠘꠃ ꠀꠙꠘꠣꠞ ꠝꠥꠈ ꠖꠦꠈꠣꠔ ꠀꠁꠔꠣꠝ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠚꠦꠞꠣꠃꠘ ꠀꠞ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠃꠙꠞꠦ ꠀꠞ ꠝꠣꠔ꠆ꠞ ꠄꠇꠐꠣ ꠉꠎꠛ ꠍꠣꠠꠝꠥ, ꠄꠞꠛꠣꠖꠦ ꠢꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠅꠘꠕꠘꠦ ꠍꠣꠠꠤꠖꠤꠛ, ꠍꠣꠠꠣꠞ ꠛꠣꠟꠣ ꠢꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠄꠇ꠆ꠇꠦꠛꠣꠞꠦ ꠈꠦꠖꠣꠁ ꠖꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠢꠤꠇꠣꠁ ꠖꠦꠅ, ꠢꠇ꠆ꠇꠟ ꠛꠦꠐꠣꠁꠘ-ꠛꠦꠐꠤꠘ꠆ꠔꠦ ꠔꠣꠞꠣꠞ ꠝꠤꠡꠞꠤ ꠀꠞꠤ-ꠚꠞꠤꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠡꠥꠘꠣ-ꠞꠥꠙꠣꠞ ꠉꠄꠘꠣ-ꠉꠣꠐꠤ ꠈꠥꠎꠤꠀ ꠘꠦꠃꠇ।” ");
INSERT INTO syls_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","ꠅꠃ ꠢꠣꠟꠔꠅ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠘꠎꠞꠅ ꠝꠣꠄꠀ ꠙꠣꠁꠔꠦ ꠝꠣꠛꠥꠖꠦ ꠡꠣꠁꠎ꠆ꠎ ꠇꠞꠟꠣ। ꠄꠞꠝꠣꠎꠦ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠚꠦꠞꠣꠃꠘꠞ ꠃꠎꠤꠞ-ꠘꠣꠎꠤꠞ ꠀꠞ ꠙ꠆ꠞꠎꠣ ꠅꠇꠟꠞ ꠉꠦꠍꠦ ꠢꠎꠞꠔ ꠝꠥꠍꠣ ꠈꠥꠛ ꠁꠎ꠆ꠎꠔꠤ ꠛꠘꠤꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","ꠝꠥꠍꠣꠄ ꠚꠦꠞꠣꠃꠘꠞꠦ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠦ ꠘꠤꠎꠦ ꠇꠁꠞꠣ, ꠀꠝꠤ ꠀꠗꠣ ꠞꠣꠁꠔꠇꠥꠞ ꠛꠣꠟꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠝꠣꠎꠖꠤ ꠎꠣꠁꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ꠄꠔꠦ ꠉꠖꠤꠔ ꠛꠅꠀ ꠚꠦꠞꠣꠃꠘꠞ ꠛꠠ ꠙꠥꠀ ꠕꠣꠇꠤ ꠛꠣꠞꠣ-ꠜꠣꠘꠞꠣ ꠛꠣꠘ꠆ꠖꠤꠞ ꠙꠥꠀ ꠙꠞ꠆ꠎꠘ꠆ꠔ, ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠝꠣꠎꠦ ꠞꠅꠞꠣ ꠢꠇ꠆ꠇꠟ ꠙꠞꠤꠛꠣꠞꠞ ꠛꠠ ꠙꠥꠀꠂꠘ ꠝꠞꠤꠎꠤꠛꠣ। ꠄꠞꠟꠉꠦ ꠢꠇꠟ ꠙꠡꠥꠁꠘ꠆ꠔꠞ ꠙꠄꠟꠣ ꠝꠦꠖꠣ ꠛꠣꠁꠌ꠆ꠌꠣꠅ ꠝꠞꠤꠎꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","ꠁ ꠟꠣꠈꠣꠘ ꠖꠡꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠇꠥꠘꠥꠖꠤꠘ ꠅꠁꠍꠦꠅ ꠘꠣ ꠀꠞ ꠅꠁꠔ-ꠅ ꠘꠣꠄ, ꠀꠡ꠆ꠔꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠣꠘ꠆ꠖꠘ ꠇꠣꠘ꠆ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","ꠅꠁꠟꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠇꠥꠘꠥ ꠝꠣꠘꠥꠡ ꠛꠣ ꠙꠡꠥꠞ ꠛꠣꠄ ꠄꠉꠥ ꠇꠥꠔ꠆ꠔꠣꠄꠅ ꠃꠢ ꠇꠞꠔ ꠘꠣꠄ, ꠎꠣꠔꠦ ꠀꠙꠘꠣꠞꠣ ꠛꠥꠎꠔꠣ ꠙꠣꠞꠂꠘ ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠝꠤꠡꠞꠤ ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠎꠦ ꠔꠚꠣꠔ ꠇꠞꠤ।” ");
INSERT INTO syls_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","ꠢꠦꠡꠦ ꠝꠥꠍꠣꠄ ꠚꠦꠞꠣꠃꠘꠞꠦ ꠇꠁꠟꠣ, “ꠅꠃ ꠡꠝꠄ ꠀꠙꠘꠣꠞ ꠢꠇ꠆ꠇꠟ ꠃꠎꠤꠞ-ꠘꠣꠎꠤꠞꠦ ꠀꠁꠀ ꠀꠝꠣꠞ ꠙꠣꠅꠔ ꠙꠠꠤꠀ ꠇꠁꠛꠣ, ꠀꠙꠘꠦ ꠀꠙꠘꠣꠞ ꠢꠇꠟ ꠝꠣꠘꠡꠞꠦ ꠟꠁꠀ ꠛꠤꠖꠣꠄ ꠘꠦꠁꠘꠉꠤ, ꠄꠞꠛꠣꠖꠦ ꠀꠝꠤ ꠛꠣꠞ ꠅꠁꠝꠥ।” ꠅꠈꠣꠘ ꠇꠁꠀ ꠔꠣꠁꠘ ꠉꠥꠍꠣꠄ ꠀꠉꠥꠁꠘ ꠅꠁꠀ ꠚꠦꠞꠣꠃꠘꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠢꠞꠤꠀ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠍꠟꠣ, “ꠚꠦꠞꠣꠃꠘꠦ ꠔꠥꠝꠣꠞ ꠇꠕꠣ ꠝꠣꠘꠔ ꠘꠣꠄ, ꠎꠣꠔꠦ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠀꠝꠣꠞ ꠇꠦꠞꠣꠝꠔꠤꠞ ꠙꠞꠤꠝꠣꠘ ꠀꠞꠅ ꠛꠣꠠꠦ।” ");
INSERT INTO syls_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","ꠄꠞꠟꠣꠉꠤ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠦ ꠚꠦꠞꠣꠃꠘꠞ ꠍꠣꠝꠘꠦ ꠅꠃ ꠇꠦꠞꠣꠝꠔꠤ ꠅꠇꠟ ꠖꠦꠈꠣꠁꠟꠣ। ꠅꠁꠟꠦ ꠝꠣꠛꠥꠖꠦ ꠚꠦꠞꠣꠃꠘꠞ ꠖꠤꠟꠞꠦ ꠙꠣꠡꠣꠘ ꠇꠞꠤꠟ꠆ꠟꠣ, ꠢꠦ ꠘꠤꠎꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠍꠣꠠꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","ꠛꠣꠖꠦ ꠅꠃ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠜꠤꠔꠞꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“ꠁ ꠌꠣꠘ꠆ꠖꠈꠣꠘ ꠛꠍꠞꠞ ꠙꠄꠟꠣ ꠌꠣꠘ꠆ꠖ ꠅꠁꠛ, ꠔꠥꠝꠞꠣ ꠁ ꠌꠣꠘ꠆ꠖꠞꠦ ꠛꠍꠞꠞ ꠙꠄꠟꠣ ꠌꠣꠘ꠆ꠖ ꠉꠘꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","ꠔꠥꠝꠤꠔꠣꠁꠘ ꠔꠣꠝꠣꠝ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠖꠟꠣ ꠇꠞꠤ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠅꠃ ꠌꠣꠘ꠆ꠖꠞ ꠖꠡ ꠔꠣꠞꠤꠈꠅ ꠔꠥꠝꠞꠣꠞ ꠢꠇꠟ ꠙꠞꠤꠛꠣꠞꠞ ꠝꠥꠞꠛ꠆ꠛꠤꠄ, ꠎꠣꠞꠎꠤꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠇꠞꠤ ꠝꠦꠠꠣ ꠛꠣ ꠍꠣꠉꠟꠞ ꠛꠣꠁꠌ꠆ꠌꠣ ꠘꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ꠅꠁꠟꠦ ꠇꠥꠘꠥ ꠙꠞꠤꠛꠣꠞꠅ ꠄꠞ ꠉꠥꠡ꠆ꠔ ꠈꠣꠅꠀꠞ ꠝꠣꠘꠥꠡ ꠇꠝ ꠅꠁꠟꠦ, ꠟꠣꠉꠣ ꠊꠞꠞ ꠝꠣꠘꠡꠞ ꠟꠉꠦ ꠝꠤꠟꠤꠀ, ꠖꠥꠁꠅ ꠙꠞꠤꠛꠣꠞꠦ ꠎꠔꠈꠣꠘ ꠈꠣꠁꠔꠣ ꠙꠣꠞꠂꠘ, ꠢꠃ ꠅꠘꠥꠝꠣꠘꠦ ꠝꠦꠠꠣ ꠛꠣ ꠍꠣꠉꠟꠞ ꠛꠣꠁꠌ꠆ꠌꠣ ꠘꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","ꠁ ꠛꠣꠁꠌ꠆ꠌꠣ ꠅꠁꠛ ꠘꠤꠈꠥꠔ, ꠄꠇ ꠛꠞꠍ ꠛꠄꠅꠡꠞ ꠙꠣꠑꠣ ꠛꠣꠁꠌ꠆ꠌꠣ ꠅꠁꠔꠦ ꠅꠁꠛ; ꠔꠥꠝꠞꠣ ꠝꠦꠠꠣ ꠛꠣ ꠍꠣꠉꠟꠞ ꠛꠣꠁꠌ꠆ꠌꠣ ꠘꠤꠔꠣꠄ ꠙꠣꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","ꠀꠞ ꠅꠃ ꠌꠣꠘ꠆ꠖꠞ ꠌꠃꠖ꠆ꠖ ꠔꠣꠞꠤꠈ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠁꠐꠣꠞ ꠎꠔꠘ ꠇꠞꠛꠣꠄ, ꠛꠣꠖꠦ ꠔꠣꠝꠣꠝ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠄꠇꠟꠉꠦ ꠝꠤꠟꠤꠀ, ꠔꠣꠞꠣ ꠢꠣꠁꠘ꠆ꠎꠣ ꠛꠣꠟꠣ ꠎꠣꠞꠎꠤꠞ ꠙꠞꠤꠛꠣꠞꠦ ꠅꠃ ꠛꠣꠁꠌ꠆ꠌꠣꠁꠘ ꠎꠛ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","ꠎꠛ ꠇꠞꠣꠞ ꠛꠣꠖꠦ ꠔꠣꠞꠣ ꠄꠞ ꠇꠤꠍꠥ ꠟꠃ ꠘꠤꠀ ꠎꠔ ꠊꠞꠅ ꠄꠞ ꠉꠥꠡ꠆ꠔ ꠈꠣꠁꠛꠣ, ꠅꠔ ꠊꠞꠞ ꠖꠥꠀꠞꠞ ꠌꠃꠇꠣꠑꠞ ꠖꠥꠁꠅ ꠉꠣꠟꠣꠔ ꠀꠞ ꠃꠙꠞꠞ ꠌꠃꠇꠣꠑꠅ ꠅꠃ ꠟꠃ ꠟꠣꠉꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","ꠢꠃ ꠞꠣꠁꠔꠃ ꠔꠣꠞꠣ ꠁ ꠉꠥꠡ꠆ꠔ ꠀꠉꠥꠁꠘꠖꠤ ꠍꠦꠇꠤꠀ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠞꠥꠐꠤ ꠀꠞ ꠔꠤꠔ꠆ꠔꠣ ꠢꠣꠉꠞ ꠟꠉꠦ ꠝꠤꠟꠣꠁꠀ ꠈꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","ꠁ ꠉꠥꠡ꠆ꠔ ꠔꠥꠝꠞꠣ ꠇꠣꠌꠣ, ꠛꠣ ꠙꠣꠘꠤꠖꠤ ꠞꠣꠘ꠆ꠖꠤꠀ ꠈꠣꠁꠅ ꠘꠣ। ꠈꠣꠟꠤ ꠀꠉꠥꠁꠘꠖꠤ ꠍꠦꠇꠤꠀ ꠈꠣꠁꠅ, ꠄꠞ ꠑꠦꠋ, ꠇꠟ꠆ꠟꠣ ꠡꠥꠖ꠆ꠖꠣ ꠜꠤꠔꠞꠞ ꠢꠇ꠆ꠇꠟꠔꠣ ꠄꠇꠈꠣꠘꠅ ꠍꠦꠇꠤꠅ, ꠛꠣꠖꠦ ꠈꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","ꠞꠣꠁꠔ ꠙꠥꠀꠘꠤꠞ ꠀꠉꠦ ꠈꠣꠘꠤ ꠡꠦꠡ ꠇꠞꠤꠅ, ꠛꠤꠀꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠇꠥꠘ꠆ꠔꠣꠃ ꠛꠣꠇꠤ ꠕꠁꠅ ꠘꠣ। ꠎꠥꠖꠤ ꠇꠥꠘ꠆ꠔꠣ ꠛꠣꠇꠤ ꠞꠁꠎꠣꠄ, ꠔꠦ ꠀꠉꠥꠁꠘꠖꠤ ꠎꠣꠟꠣꠁꠟꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","ꠁ ꠈꠣꠘꠤ ꠈꠣꠅꠀꠞ ꠛꠣꠟꠣ ꠔꠥꠝꠞꠣꠞ ꠇꠝꠞꠞ ꠇꠣꠙꠠ ꠝꠎꠛꠥꠔ ꠇꠞꠤ ꠚꠤꠘ꠆ꠖꠤꠅ, ꠙꠣꠅꠔ ꠎꠥꠔꠣ ꠟꠣꠉꠣꠁꠅ, ꠀꠔꠞ ꠟꠣꠑꠤ ꠟꠁꠅ। ꠎꠟꠖꠤ ꠇꠞꠤ ꠈꠣꠘꠤ ꠈꠣꠁꠅ। ꠁꠐꠣ ꠅꠁꠟ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠞ ꠀꠎꠣꠖꠤ ꠁꠖ। ");
INSERT INTO syls_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","ꠢꠃ ꠞꠣꠁꠔꠃ ꠀꠝꠤ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠝꠣꠎꠖꠤ ꠎꠣꠁꠝꠥ, ꠖꠦꠡꠞ ꠢꠇ꠆ꠇꠟ ꠝꠣꠘꠡꠞ ꠛꠠ ꠙꠥꠀꠞꠦ ꠀꠞ ꠙꠡꠥꠞ ꠙꠄꠟꠣ ꠝꠦꠖꠣ ꠛꠣꠁꠌ꠆ꠌꠣꠞꠦꠅ ꠝꠣꠞꠤꠟꠤꠝꠥ। ꠝꠤꠡꠞꠞ ꠢꠇꠟ ꠖꠦꠛ-ꠖꠦꠛꠤꠞ ꠛꠤꠌꠣꠞ ꠇꠞꠤꠀ ꠡꠣꠎꠣ ꠖꠤꠝꠥ; ꠀꠝꠤꠃ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣꠞ ꠖꠥꠀꠞꠞ ꠌꠃꠇꠣꠑꠅ ꠟꠦꠙꠣ ꠟꠃ ꠖꠦꠈꠟꠦ ꠀꠝꠤ ꠛꠥꠎꠝꠥ ꠁ ꠊꠞꠅ ꠔꠥꠝꠞꠣ ꠞꠅ। ꠄꠞꠟꠣꠉꠤ ꠀꠝꠤ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠉꠎꠛ ꠓꠣꠟꠤꠛꠣꠞ ꠡꠝꠄ, ꠟꠃ ꠟꠦꠙꠣ ꠅꠃ ꠊꠞ ꠛꠣꠖ ꠖꠤꠀ ꠍꠣꠝꠘꠦꠖꠤ ꠎꠣꠁꠝꠥ। ꠝꠃꠔꠞ ꠉꠎꠛ ꠕꠘꠦ ꠔꠥꠝꠞꠣ ꠞꠦꠢꠣꠁ ꠙꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","ꠅꠃ ꠖꠤꠘꠞꠦ ꠔꠥꠝꠞꠣ ꠁꠀꠖ ꠞꠣꠈꠤꠅ ꠀꠞ ꠀꠝꠤ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠁꠖꠞ ꠖꠤꠘ ꠝꠣꠘꠤꠅ। ꠁ ꠁꠖꠞꠦ ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠢꠥꠇꠥꠝ ꠝꠘꠅ ꠇꠞꠤꠀ ꠢꠞ-ꠢꠣꠝꠦꠡꠣ ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠝꠣꠘꠤꠀ ꠎꠣꠁꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","ꠝꠣꠛꠥꠖꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠡꠣꠔ ꠖꠤꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠞꠥꠐꠤ ꠈꠣꠁꠛꠣꠄ। ꠙꠄꠟꠣ ꠖꠤꠘꠃ ꠎꠣꠞꠎꠤꠞ ꠊꠞ ꠕꠣꠇꠤ ꠢꠇꠟ ꠈꠣꠝꠤꠞ ꠚꠣꠟꠣꠁ ꠖꠤꠛꠣꠄ। ꠁ ꠡꠣꠔꠅ ꠖꠤꠘꠞ ꠝꠣꠎꠦ ꠎꠦꠉꠥꠄ ꠈꠣꠝꠤꠞ ꠀꠟꠣ ꠘꠣꠘ ꠞꠥꠐꠤ ꠈꠣꠁꠛ, ꠔꠣꠞꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠕꠘꠦ ꠚꠥꠍꠤꠀ ꠚꠣꠟꠣꠁꠟ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","ꠙꠄꠟꠣ ꠖꠤꠘ ꠀꠞ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠙꠛꠤꠔ꠆ꠞ ꠝꠤꠟꠘ-ꠝꠣꠢꠚꠤꠟ ꠀꠖꠣꠄ ꠇꠞꠛꠣꠄ, ꠁ ꠖꠥꠁ ꠖꠤꠘ ꠈꠣꠟꠤ ꠎꠞꠥꠞꠤ ꠈꠣꠅꠀ-ꠖꠣꠅꠀ ꠍꠣꠠꠣ ꠖꠥꠍꠞꠣ ꠇꠥꠘꠥ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠛꠣꠄ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","ꠅꠃ ꠟꠣꠈꠣꠘ ꠔꠥꠝꠞꠣ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠞꠥꠐꠤꠞ ꠁ ꠁꠖ ꠀꠖꠣꠄ ꠇꠞꠤꠅ, ꠀꠝꠣꠞ ꠢꠥꠇꠥꠝ ꠝꠘꠅ ꠇꠞꠤꠀ ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠢꠞ-ꠢꠣꠝꠦꠡꠣ ꠁ ꠁꠖ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ꠅꠃ ꠖꠤꠘꠃ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠍꠤꠙꠣꠁ ꠖꠟꠞ ꠟꠣꠈꠣꠘ ꠇꠞꠤ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","ꠔꠥꠝꠞꠣ ꠙꠄꠟꠣ ꠌꠣꠘ꠆ꠖꠞ ꠌꠃꠖ꠆ꠖ ꠔꠣꠞꠤꠈꠞ ꠢꠣꠁꠘ꠆ꠎꠣ ꠕꠣꠇꠤ ꠡꠥꠞꠥ ꠇꠞꠤꠀ, ꠄꠇꠥꠁꠡ ꠔꠣꠞꠤꠈꠞ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠞꠥꠐꠤ ꠈꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","ꠅꠃ ꠡꠣꠔ ꠖꠤꠘ ꠎꠣꠔꠦ ꠔꠥꠝꠞꠣꠞ ꠊꠞꠅ ꠈꠣꠝꠤꠞꠞ ꠇꠥꠘꠥ ꠘꠣꠝ-ꠘꠤꠡꠣꠘꠣ ꠘꠣ ꠕꠣꠇꠦ, ꠅꠃ ꠡꠝꠄ ꠇꠦꠃ ꠎꠥꠖꠤ ꠈꠣꠝꠤꠞ ꠀꠟꠣ ꠈꠣꠘꠤ ꠈꠣꠄ, ꠔꠦ ꠢꠦ ꠔꠥꠝꠞꠣꠞ ꠘꠤꠎꠞ ꠎꠣꠔꠤꠞ ꠅꠃꠇ ꠛꠣ ꠜꠤꠘ ꠎꠣꠔꠤꠞ ꠅꠃꠇ, ꠔꠣꠞꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠡꠝꠣꠎ ꠕꠣꠇꠤ ꠚꠥꠍꠤꠀ ꠚꠣꠟꠣꠁꠟ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","ꠁ ꠡꠣꠔ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠎꠦꠘꠅꠃ ꠞꠅ ꠘꠣ ꠇꠦꠘꠦ ꠈꠣꠝꠤꠞ ꠀꠟꠣ ꠇꠥꠘ꠆ꠔꠣꠃ ꠈꠣꠁꠅ ꠘꠣ; ꠈꠣꠟꠤ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠞꠥꠐꠤ ꠈꠣꠁꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","ꠝꠥꠍꠣꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠢꠇꠟ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤꠞꠦ ꠖꠟꠣ ꠇꠞꠤꠀ ꠇꠁꠟꠣ, “ꠀꠙꠘꠣꠞꠣ ꠎꠣꠃꠇ꠆ꠇꠣ, ꠉꠤꠀ ꠎꠣꠞꠎꠤꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠟꠣꠉꠤ ꠀꠎꠣꠖꠤ ꠁꠖꠞ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠀꠘꠤꠀ ꠎꠛ ꠇꠞꠃꠇ꠆ꠇꠣ। ");
INSERT INTO syls_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","ꠀꠞ ‘ꠄꠍꠥꠛ’ ꠉꠣꠍꠞ ꠄꠇ ꠀꠐꠤ ꠒꠦꠐꠣ ꠟꠁꠀ, ꠙꠣꠔꠤꠟꠅ ꠕꠅꠀ ꠟꠃꠔ ꠛꠥꠠꠣꠁꠀ ꠖꠥꠀꠞꠞ ꠌꠃꠇꠣꠑꠞ ꠖꠥꠁꠅ ꠉꠣꠟꠣꠔ ꠀꠞ ꠃꠙꠞꠦ ꠟꠣꠉꠣꠁꠅ। ꠡꠣꠛꠗꠣꠘ! ꠡꠥꠞꠥꠎ ꠃꠑꠣꠞ ꠀꠉꠦ ꠇꠦꠃ ꠊꠞꠞ ꠛꠣꠞꠦ ꠛꠣꠞ ꠅꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞꠦ ꠝꠣꠞꠣꠞ ꠟꠣꠉꠤ ꠝꠣꠛꠥꠖꠦ ꠎꠦꠛꠟꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠝꠣꠎꠖꠤ ꠔꠡꠞꠤꠚ ꠘꠤꠛꠣ, ꠅꠃ ꠡꠝꠄ ꠔꠥꠝꠞꠣꠞ ꠌꠃꠇꠣꠑꠞ ꠃꠙꠞꠦ ꠀꠞ ꠖꠥꠁꠅ ꠉꠣꠟꠣꠔ ꠟꠃ ꠖꠦꠈꠟꠦ, ꠔꠣꠁꠘ ꠁ ꠊꠞ ꠛꠣꠖ ꠖꠤꠀ ꠍꠣꠝꠘꠦꠖꠤ ꠀꠉꠥꠀꠁꠛꠣ। ꠀꠎꠞꠣꠁꠟ ꠚꠤꠞꠤꠡ꠆ꠔꠣꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠊꠞꠅ ꠢꠣꠝꠣꠁꠀ ꠝꠣꠞꠔꠦ ꠖꠤꠔꠣ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“ꠀꠝꠣꠞ ꠛꠣꠔꠣꠁꠟ ꠢꠥꠇꠥꠝ ꠝꠘꠅ ꠇꠞꠤꠀ ꠔꠥꠝꠞꠣ ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠦ ꠁ ꠁꠖꠞꠦ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","ꠀꠝꠤ ꠀꠝꠣꠞ ꠘꠤꠎꠞ ꠅꠀꠖꠣ ꠝꠣꠚꠤꠇ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦ ꠖꠦꠡ ꠖꠤꠝꠥ, ꠢꠃ ꠖꠦꠡꠅ ꠉꠤꠀ ꠢꠣꠞꠟꠦꠅ ꠔꠥꠝꠞꠣ ꠁ ꠁꠖ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","ꠔꠥꠝꠞꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ꠆ꠔꠦ ꠎꠦꠛꠟꠣ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠤꠇꠣꠁꠛꠣ, ꠁ ꠁꠖꠞ ꠇꠣꠞꠘ ꠇꠤꠔꠣ? ꠁꠐꠣ ꠇꠤꠟꠣ ꠀꠁꠍꠦ? ");
INSERT INTO syls_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ꠔꠦ ꠔꠥꠝꠞꠣ ꠎꠥꠀꠙ ꠖꠤꠅ, ꠁꠐꠣ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠎꠣꠖꠤ ꠁꠖꠞ ꠇꠥꠞꠛꠣꠘꠤ। ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞꠦ ꠝꠣꠞꠛꠣꠞ ꠛꠣꠟꠣ ꠔꠣꠁꠘ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠊꠞ ꠛꠣꠖ ꠖꠤꠀ ꠍꠣꠝꠘꠦꠖꠤ ꠀꠉꠥꠀꠁ ꠉꠤꠀ, ꠀꠝꠞꠣꠞꠦ ꠀꠎꠣꠖ ꠇꠞꠍꠟꠣ।” ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠢꠇꠟ ꠝꠣꠘꠡꠦ ꠝꠣꠛꠥꠖꠞꠦ ꠍꠁꠎꠖꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠝꠣꠛꠥꠖꠦ ꠎꠦꠟꠣ ꠛꠣꠔꠣꠁ ꠖꠤꠍꠟꠣ, ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠔꠣꠞꠣꠞ ꠊꠞꠅ ꠉꠤꠀ ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠣꠝ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","ꠢꠦꠡꠦ ꠝꠣꠎ ꠞꠣꠁꠔꠦ ꠅꠃ ꠟꠣꠈꠣꠘ ꠊꠐꠟ, ꠝꠣꠛꠥꠖꠦ ꠉꠖꠤꠔ ꠛꠅꠀ ꠚꠦꠞꠣꠃꠘꠞ ꠙꠥꠀ ꠕꠘꠦ ꠎꠦꠟ ꠈꠣꠘꠣꠞ ꠛꠘ꠆ꠖꠤꠞ ꠙꠥꠀ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠇ꠆ꠇꠟꠞꠦ ꠝꠣꠞꠤꠟꠤꠟꠣ। ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠢꠇ꠆ꠇꠟ ꠙꠞꠤꠛꠣꠞꠞ ꠛꠠ ꠙꠥꠀꠂꠘ ꠀꠞ ꠙꠡꠥꠁꠘ꠆ꠔꠞ ꠙꠄꠟꠣ ꠝꠦꠖꠣ ꠛꠣꠁꠌ꠆ꠌꠣꠞꠦꠅ ꠔꠣꠁꠘ ꠝꠣꠞꠤꠟꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ꠔꠦꠃ ꠚꠦꠞꠣꠃꠘ ꠀꠞ ꠔꠣꠞ ꠃꠎꠤꠞ-ꠘꠣꠎꠤꠞ ꠅꠇꠟ, ꠝꠤꠡꠞꠞ ꠢꠇꠟ ꠝꠣꠘꠥꠡ ꠢꠎꠣꠉ ꠅꠁꠀ ꠃꠑꠟꠣ, ꠀꠡ꠆ꠔꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠛꠦꠕꠣꠄꠀ ꠇꠣꠘ꠆ꠖꠘꠞ ꠞꠥꠁꠟ ꠙꠠꠟ; ꠇꠣꠞꠘ ꠅꠟꠣ ꠇꠥꠘꠥ ꠊꠞ ꠞꠁꠍꠤꠟ ꠘꠣ, ꠎꠦ ꠊꠞꠅ ꠇꠦꠃ ꠘꠣ ꠇꠦꠃ ꠝꠞꠍꠦ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","ꠢꠃ ꠞꠣꠁꠔꠃ ꠚꠦꠞꠣꠃꠘꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠀꠘꠣꠁꠀ ꠇꠁꠟ, “ꠔꠥꠝꠞꠣ ꠎꠟꠖꠤ ꠎꠣꠅ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠟꠁꠀ ꠀꠝꠣꠞ ꠙ꠆ꠞꠎꠣꠞ ꠉꠦꠍ ꠕꠘꠦ ꠢꠞꠅ। ꠔꠥꠝꠞꠣ ꠎꠦꠟꠣ ꠇꠁꠍ, ꠅꠃꠟꠣ ꠉꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠄꠛꠣꠖꠔ ꠇꠞꠅ। ");
INSERT INTO syls_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","ꠔꠥꠝꠞꠣꠞ ꠎꠛꠣꠘ ꠝꠔꠃ ꠔꠥꠝꠞꠣꠞ ꠉꠞꠥ-ꠝꠦꠠꠣꠞ ꠙꠣꠟ ꠅꠇꠟꠞꠦꠅ ꠘꠦꠅꠉꠤ। ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞꠦꠅ ꠘꠦꠇ ꠖꠥꠀ ꠖꠦꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","ꠝꠤꠡꠞꠤ ꠅꠇꠟꠦ ꠈꠥꠛ ꠒꠞꠣꠁꠟꠣ, ꠔꠣꠞꠣ ꠝꠘꠅ ꠇꠞꠟꠣ ꠔꠣꠞꠣꠅ ꠝꠞꠤꠎꠤꠛꠣ। ꠄꠞꠟꠣꠉꠤ ꠔꠣꠞꠣ ꠔꠣꠉꠖꠣ ꠖꠤꠔꠣ ꠟꠣꠉꠟꠣ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠎꠟꠖꠤ ꠇꠞꠤ ꠛꠤꠖꠣꠄ ꠅꠁꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠔꠣꠞꠣꠞ ꠝꠄꠖꠣꠞ ꠈꠣꠁꠞ ꠝꠣꠎꠦ ꠈꠣꠝꠤꠞ ꠙꠥꠞꠣꠁꠛꠣꠞ ꠀꠉꠦꠃ, ꠈꠣꠁ ꠡꠢ ꠉꠣꠝꠟꠣꠁꠘ ꠇꠣꠙꠠꠖꠤ ꠉꠣꠁꠐ ꠛꠣꠘ꠆ꠖꠤꠀ ꠇꠣꠘ꠆ꠖꠅ ꠟꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠝꠥꠍꠣꠞ ꠙꠞꠣꠝꠤꠡ ꠝꠔ, ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠡꠥꠘꠣ-ꠞꠥꠙꠣꠞ ꠉꠄꠘꠣ-ꠉꠣꠐꠤ ꠀꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠈꠥꠎꠤꠀ ꠘꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","ꠝꠣꠛꠥꠖꠦ ꠀꠉ ꠕꠘꠦꠃ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠖꠤꠟꠞ ꠝꠣꠎꠦ ꠄꠇ ꠖꠄꠀ-ꠝꠣꠄꠀ ꠙꠄꠖꠣ ꠇꠞꠍꠟꠣ, ꠎꠣꠔꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠎꠦꠔꠣ ꠈꠥꠎꠤꠛꠣ, ꠅꠔꠣꠃ ꠎꠣꠘꠥ ꠔꠣꠞꠣꠞꠦ ꠖꠦꠁꠘ। ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠞꠤ ꠔꠣꠞꠣ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠛꠃꠔ ꠗꠘ-ꠖꠃꠟꠔꠅ ꠇꠛꠎꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","ꠅꠔꠣ ꠘꠤꠀ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠞꠣꠝꠣꠡꠦꠡ ꠄꠟꠣꠇꠣ ꠕꠣꠇꠤ ꠡꠥꠇ꠆ꠇꠔꠞ ꠝꠥꠈꠣ ꠞꠅꠀꠘꠣ ꠅꠁꠟꠣ। ꠔꠣꠞꠣꠞ ꠝꠣꠎꠦ ꠅꠘꠥꠝꠣꠘ ꠍꠄ ꠟꠣꠈ ꠡꠛꠟ ꠛꠦꠐꠣꠁꠘ ꠀꠐꠤꠀ ꠉꠦꠟꠣ। ꠄꠞꠣꠞ ꠟꠉꠦ ꠛꠦꠐꠤꠘ ꠀꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘꠅ ꠀꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠛꠣꠖꠦꠅ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠞꠅꠞꠣ ꠀꠞꠅ ꠛꠃꠔ ꠝꠣꠘꠥꠡ, ꠉꠞꠥ-ꠝꠦꠠꠣꠞ ꠙꠣꠟ ꠢꠇꠟꠔꠣ ꠝꠤꠟꠤꠀ ꠛꠃꠔ ꠛꠠ ꠖꠟ ꠛꠣꠘ꠆ꠖꠤꠀ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","ꠛꠣꠖꠦ ꠔꠣꠞꠣ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠀꠘꠣ ꠢꠃ ꠝꠄꠖꠣꠞ ꠈꠣꠁ ꠖꠤꠀ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠞꠥꠐꠤ ꠛꠣꠘꠣꠁꠟꠣ। ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠔꠣꠞꠣꠞꠦ ꠎꠟꠖꠤ ꠇꠞꠤ ꠛꠤꠖꠣꠄ ꠖꠦꠅꠀꠄ ꠁ ꠈꠣꠁꠔ ꠈꠣꠝꠤꠞ ꠝꠣꠈꠣꠁꠛꠣꠞ ꠡꠝꠄꠃ ꠙꠣꠁꠍꠟꠣ ꠘꠣ, ꠀꠞ ꠙꠕꠞ ꠟꠣꠉꠤ ꠇꠥꠘꠥ ꠝꠍꠣꠅ ꠘꠤꠔꠣ ꠙꠣꠞꠍꠟꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠝꠤꠡꠞꠅ ꠢꠇ꠆ꠇꠟꠔꠣꠄ ꠌꠣꠁꠞ-ꠡ ꠔꠤꠡ ꠛꠞꠍ ꠛꠡꠔ ꠇꠞꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","ꠑꠤꠇ ꠅꠃ ꠌꠣꠁꠞ-ꠡ ꠔꠤꠡ ꠛꠞꠍ ꠙꠥꠞꠣ ꠅꠁꠛꠣꠞ ꠖꠤꠘꠅ ꠝꠣꠛꠥꠖꠞ ꠢꠇ꠆ꠇꠟ ꠛꠘ꠆ꠖꠣ, ꠍꠤꠙꠣꠁ ꠖꠟꠞ ꠟꠣꠈꠣꠘ ꠢꠣꠎꠤꠀ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","ꠅꠃ ꠞꠣꠁꠔ ꠝꠣꠛꠥꠖꠦ ꠀꠙꠘ ꠇꠥꠖꠞꠔꠤ ꠍꠣꠄꠀꠄ ꠙꠣꠢꠣꠞꠣ ꠖꠤꠀ ꠔꠣꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤꠀ ꠀꠘꠣꠄ, ꠁ ꠞꠣꠁꠔꠈꠣꠘ ꠄꠛꠣꠖꠔꠤꠞ ꠞꠣꠁꠔ। ꠢꠇ꠆ꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠣꠉꠤ ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ, ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠃꠎꠣꠉꠞꠤ ꠇꠞꠣꠞ ꠄꠇ ꠈꠣꠍ ꠞꠣꠁꠔ। ");
INSERT INTO syls_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, “ꠀꠎꠣꠖꠤ ꠁꠖꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠢꠤꠇꠣꠁ ꠖꠤꠀꠞ। ꠢꠥꠘꠅ, ꠅꠁꠘ꠆ꠘ ꠇꠥꠘꠥ ꠎꠣꠔꠤꠞ ꠝꠣꠘꠡꠞꠦ ꠄꠞ ꠉꠥꠡ꠆ꠔ ꠈꠣꠁꠔꠦ ꠖꠤꠛꠣꠄ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ꠅꠁꠟꠦ ꠈꠞꠤꠖꠣ ꠉꠥꠟꠣꠝꠦ ꠝꠍꠟꠝꠣꠘꠤ ꠇꠞꠣꠘꠤꠞ ꠛꠣꠖꠦ ꠁꠔꠣ ꠈꠣꠁꠔ ꠙꠣꠞꠛ। ");
INSERT INTO syls_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","ꠅꠁꠘ꠆ꠘ ꠎꠦꠇꠥꠘꠥ ꠎꠣꠔꠤꠞ ꠝꠥꠍꠣꠚꠤꠞ ꠛꠣ ꠛꠦꠔꠘꠖꠣꠞꠤ ꠇꠣꠝꠟꠣꠞꠦꠅ ꠁꠔꠣ ꠈꠣꠅꠀꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","ꠔꠥꠝꠞꠣ ꠎꠣꠞ ꠛꠣꠠꠤꠔ ꠙꠡꠥ ꠎꠛ ꠇꠞꠛꠣꠄ ꠢꠃ ꠛꠣꠠꠤꠔꠃ ꠄꠞ ꠉꠥꠡ꠆ꠔ ꠈꠣꠁꠔꠦ ꠅꠁꠛ; ꠛꠣꠠꠤꠞ ꠛꠣꠞꠦ ꠇꠥꠘ꠆ꠔꠣꠃ ꠘꠤꠛꠣꠄ ꠘꠣ, ꠙꠡꠥꠞ ꠇꠥꠘꠥ ꠀꠒ꠆ꠒꠤ ꠜꠣꠋꠉꠤꠛꠣꠄ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","ꠔꠣꠝꠣꠝ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠅꠃ ꠁꠖ ꠀꠖꠣꠄ ꠇꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠞꠅꠞꠣ ꠇꠥꠘꠥ ꠀꠛꠣꠖꠤꠄ ꠎꠥꠖꠤ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠞ ꠁ ꠁꠖ ꠝꠣꠘꠔ ꠌꠣꠄ, ꠔꠦ ꠙꠄꠟꠣ ꠔꠣꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠢꠇꠟ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠞ ꠝꠍꠟꠝꠣꠘꠤ ꠇꠞꠣꠘꠤ ꠟꠣꠉꠛ। ꠛꠣꠖꠦ ꠢꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠣꠈꠣꠘ ꠁꠖ ꠀꠖꠣꠄ ꠇꠞꠔ ꠙꠣꠞꠛ। ꠅꠁꠟꠦ ꠝꠍꠟꠝꠣꠘꠤ ꠇꠞꠣꠘꠤ ꠍꠣꠠꠣ ꠇꠦꠃ ꠁ ꠉꠥꠡ꠆ꠔ ꠈꠣꠁꠔ ꠙꠣꠞꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠣꠉꠤ ꠀꠞ ꠀꠛꠣꠖꠤꠞ ꠟꠣꠉꠤꠅ ꠄꠇ ꠢꠝꠣꠘ ꠀꠁꠘ ꠎꠣꠞꠤ ꠅꠁꠟ।” ");
INSERT INTO syls_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠢꠣꠍꠣꠞꠞ ꠅꠃꠟꠣꠃ ꠀꠝꠟ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","ꠝꠣꠛꠥꠖꠦ ꠢꠃ ꠖꠤꠘꠃ ꠍꠤꠙꠣꠁ ꠖꠟꠞ ꠟꠣꠈꠣꠘ ꠇꠞꠤ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠅꠇꠟꠞꠦ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠢꠇ꠆ꠇꠟ ꠙꠞꠤꠛꠣꠞꠞ ꠛꠠ ꠙꠥꠀꠂꠘꠞꠦ ꠀꠝꠣꠞ ꠘꠣꠝꠦ ꠀꠟꠉ ꠇꠞꠤꠀ ꠡꠙꠤꠀ ꠖꠦꠅ। ꠁꠔꠣ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠞ ꠙꠥꠀ ꠅꠃꠇ ꠛꠣ ꠙꠡꠥꠞ ꠛꠣꠁꠌ꠆ꠌꠣ ꠅꠃꠇ। ꠢꠇꠟꠔꠣꠞ ꠛꠠ ꠙꠥꠀꠂꠘ ꠈꠣꠟꠤ ꠀꠝꠣꠞꠃ।” ");
INSERT INTO syls_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","ꠔꠦꠃ ꠝꠥꠍꠣꠄ ꠝꠣꠘꠡꠞꠦ ꠇꠁꠟꠣ, “ꠁ ꠖꠤꠘ ꠈꠣꠘꠞꠦ ꠔꠥꠝꠞꠣ ꠁꠀꠖ ꠞꠣꠈꠤꠅ, ꠅꠃ ꠖꠤꠘꠃ ꠔꠥꠝꠞꠣ ꠝꠤꠡꠞꠞ ꠉꠥꠟꠣꠝꠤ ꠕꠣꠇꠤ ꠀꠎꠣꠖ ꠅꠁꠍ। ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘ ꠇꠥꠖꠞꠔꠤ ꠀꠔ ꠖꠤꠀ ꠔꠥꠝꠞꠣꠞꠦ ꠢꠘ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠍꠂꠘ। ꠁ ꠖꠤꠘ ꠇꠥꠘꠥꠎꠣꠔꠞ ꠈꠣꠝꠤꠞ ꠀꠟꠣ ꠈꠣꠘꠣ ꠈꠣꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","ꠀꠛꠤꠛ ꠌꠣꠘ꠆ꠖꠞ ꠅꠃ ꠔꠣꠞꠤꠈꠅ ꠔꠥꠝꠞꠣ ꠛꠣꠞ ꠅꠁꠟꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠉꠦꠍꠦ ꠅꠀꠖꠣ ꠇꠞꠍꠂꠘ, ꠇꠦꠘꠣꠘꠤ, ꠢꠤꠐ꠆ꠐꠤ, ꠀꠝꠥꠞꠤ, ꠢꠤꠛ꠆ꠛꠤ ꠀꠞ ꠎꠤꠛꠥꠎꠤ ꠅꠇꠟꠞ ꠖꠦꠡꠅ ꠔꠥꠝꠞꠣꠞꠦ ꠘꠤꠛꠣꠉꠤ। ꠁ ꠖꠦꠡ ꠖꠥꠗ ꠀꠞ ꠝꠃꠞ ꠜꠣꠘ꠆ꠒꠣꠞ ꠀꠟꠣ ꠖꠦꠡ। ꠔꠦ ꠢꠘꠅ ꠉꠤꠀ ꠢꠣꠞꠟꠦꠅ ꠔꠥꠝꠞꠣ ꠙꠞꠔꠦꠇ ꠛꠍꠞ ꠀꠛꠤꠛ ꠌꠣꠘ꠆ꠖꠞ ꠅꠃ ꠁꠖ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","“ꠔꠥꠝꠞꠣ ꠡꠣꠔ ꠖꠤꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠞꠥꠐꠤ ꠈꠣꠁꠅ, ꠛꠣꠖꠦ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘꠅ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠁꠖ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ꠁ ꠡꠣꠔꠅ ꠖꠤꠘ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠞꠥꠐꠤ ꠈꠣꠅꠀ ꠟꠣꠉꠛ, ꠔꠥꠝꠞꠣꠞ ꠉꠦꠍꠦ ꠈꠣꠝꠤꠞ ꠀꠟꠣ ꠇꠥꠘꠥꠎꠣꠔꠞ ꠈꠣꠘꠣ ꠎꠣꠔꠦ ꠘꠣ ꠖꠦꠈꠤ, ꠔꠥꠝꠞꠣꠞ ꠀꠡ꠆ꠔꠣ ꠖꠦꠡꠞ ꠜꠤꠔꠞꠦꠅ ꠎꠣꠘꠥ ꠇꠥꠘꠥ ꠈꠣꠝꠤꠞ ꠘꠣ ꠝꠤꠟꠦ। ");
INSERT INTO syls_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","ꠁ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠢꠇꠟꠦ ꠎꠣꠞꠎꠤꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠇꠁꠅ, ‘ꠀꠝꠞꠣ ꠎꠦꠛꠟꠣ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁꠀ ꠀꠁꠍꠟꠣꠝ, ꠅꠃ ꠡꠝꠄ ꠝꠣꠛꠥꠖꠦ ꠀꠝꠞꠣꠞꠦ ꠎꠦꠟꠣ ꠞꠢꠝ ꠇꠞꠍꠟꠣ, ꠅꠔꠣꠞꠦ ꠝꠘꠅ ꠞꠣꠈꠣꠞ ꠟꠣꠉꠤ ꠀꠝꠤꠅ ꠅꠈꠘ ꠅꠟꠣ ꠇꠞꠞꠣꠝ।’ ");
INSERT INTO syls_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","ꠅꠃ ꠟꠣꠈꠣꠘ ꠔꠥꠝꠞꠣ ꠎꠣꠞꠎꠤꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠔꠣꠟꠤꠝ ꠖꠤꠅ, ꠎꠣꠔꠦ ꠔꠥꠝꠞꠣꠞ ꠝꠘꠅ ꠞꠄ, ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘ ꠇꠥꠖꠞꠔꠤ ꠀꠔ ꠖꠤꠀ ꠔꠥꠝꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠍꠂꠘ। ꠔꠥꠝꠞꠣꠞ ꠀꠔꠞ ꠛꠣ ꠇꠙꠣꠟꠞ ꠔꠣꠛꠤꠎ-ꠇꠛꠎꠞ ꠟꠣꠈꠣꠘ, ꠅꠃ ꠔꠣꠟꠤꠝꠞꠦꠅ ꠢꠣꠝꠦꠡꠣ ꠌꠈꠥꠞ ꠍꠣꠝꠘꠦ ꠞꠣꠈꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","ꠄꠞꠟꠣꠉꠤ ꠙꠞꠔꠦꠇ ꠛꠞꠍ ꠅꠃ ꠅꠇ꠆ꠔ ꠀꠁꠟꠦꠃ ꠔꠥꠝꠞꠣ ꠁ ꠘꠤꠅꠝ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞ ꠉꠦꠍꠦ ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠁꠘ꠆ꠔꠞ ꠉꠦꠍꠦ ꠎꠦꠟꠣ ꠅꠀꠖꠣ ꠇꠞꠍꠂꠘ, ꠅꠃ ꠅꠀꠖꠣ ꠝꠣꠚꠤꠇ ꠔꠣꠁꠘ ꠔꠥꠝꠞꠣꠞꠦ ꠇꠦꠘꠣꠘꠤ ꠅꠇꠟꠞ ꠖꠦꠡ ꠖꠣꠘ ꠇꠞꠍꠂꠘ। ꠔꠦ ꠝꠣꠛꠥꠖꠦ ꠢꠘꠅ ꠘꠤꠀ ꠢꠣꠞꠟꠦ, ");
INSERT INTO syls_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ꠔꠥꠝꠞꠣ ꠎꠣꠞꠎꠤꠞ ꠛꠠ ꠙꠥꠀꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠡꠙꠤꠀ ꠖꠤꠟꠣꠁꠅ; ꠄꠞꠟꠉꠦ ꠔꠥꠝꠞꠣꠞ ꠢꠇꠟ ꠙꠡꠥꠁꠘ꠆ꠔꠞ ꠙꠄꠟꠣ ꠝꠦꠖꠣ ꠛꠣꠁꠌ꠆ꠌꠣꠞꠦꠅ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠖꠤꠟꠣꠁꠅ, ꠁꠔꠣ ꠔ ꠝꠣꠛꠥꠖꠞꠃ। ");
INSERT INTO syls_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","ꠅꠁꠟꠦ ꠢꠇꠟ ꠉꠣꠗꠤꠘ꠆ꠔꠞ ꠙꠄꠟꠣ ꠝꠦꠖꠣ ꠛꠣꠁꠌ꠆ꠌꠣꠞ ꠛꠖꠟꠣ, ꠔꠥꠝꠞꠣ ꠄꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠖꠤꠀ ꠈꠣꠟꠣꠍ ꠇꠞꠣꠁꠅ। ꠈꠣꠟꠣꠍ ꠘꠣ ꠇꠞꠣꠁꠟꠦ ꠉꠣꠗꠣ ꠛꠣꠁꠌ꠆ꠌꠣꠞ ꠉꠞ꠆ꠖꠘꠣ ꠜꠣꠋꠉꠤ ꠖꠤꠅ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠔꠥꠝꠞꠣꠞ ꠢꠇ꠆ꠇꠟ ꠙꠞꠤꠛꠣꠞꠞ ꠛꠠ ꠙꠥꠀꠂꠘꠞꠦ ꠈꠣꠟꠣꠍ ꠇꠞꠣꠘꠤ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“ꠔꠥꠝꠞꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠎꠦꠛꠟꠣ ꠎꠤꠇꠣꠁꠛꠣ, ꠁꠔꠣ ꠇꠤꠔꠣꠞ ꠟꠣꠉꠤ ꠇꠞꠣ ꠟꠣꠉꠦ? ꠔꠥꠝꠞꠣ ꠎꠥꠀꠙ ꠖꠤꠅ, ‘ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘ ꠇꠥꠖꠞꠔꠤ ꠀꠔ ꠖꠤꠀ ꠀꠝꠞꠣꠞꠦ ꠝꠤꠡꠞꠞ ꠉꠥꠟꠣꠝꠤ ꠕꠣꠇꠤ ꠀꠎꠣꠖ ꠇꠞꠤ ꠀꠘꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ꠚꠦꠞꠣꠃꠘꠦ ꠘꠣ-ꠢꠥꠝꠣꠞꠤ ꠇꠞꠤꠀ ꠎꠦꠛꠟꠣ ꠀꠝꠞꠣꠞꠦ ꠀꠁꠔꠦ ꠖꠤꠟ ꠘꠣ, ꠅꠃ ꠡꠝꠄ ꠝꠣꠛꠥꠖꠦ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠢꠇꠟ ꠙꠞꠤꠛꠣꠞꠞ ꠛꠠ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ, ꠝꠣꠘꠡꠞ ꠙꠥꠀꠂꠘ ꠀꠞ ꠙꠡꠥꠁꠘ꠆ꠔꠞ ꠙꠄꠟꠣ ꠝꠦꠖꠣ ꠛꠣꠁꠌ꠆ꠌꠣꠁꠘꠞꠦ ꠝꠣꠞꠤꠟ꠆ꠟꠣ। ꠅꠃ ꠇꠣꠞꠘꠦ ꠀꠝꠞꠣꠞ ꠛꠠ ꠙꠥꠀꠂꠘꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠈꠣꠟꠣꠍ ꠇꠞꠣꠁ, ꠀꠞ ꠙꠡꠥꠞ ꠙꠄꠟꠣ ꠝꠦꠖꠣ ꠛꠣꠁꠌ꠆ꠌꠣꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠁ। ");
INSERT INTO syls_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","ꠁꠐꠣ ꠅꠝꠘ ꠄꠇ ꠁꠀꠖꠉꠣꠞꠤꠞ ꠁꠖ, ꠀꠔ ꠛꠣ ꠇꠙꠣꠟꠅ ꠛꠣꠘ꠆ꠖꠣ ꠔꠣꠛꠤꠎ-ꠇꠛꠎꠞ ꠟꠣꠈꠣꠘ ꠎꠣꠘꠥ ꠢꠣꠝꠦꠡꠣ ꠌꠈꠥꠞ ꠍꠣꠝꠘꠦ ꠞꠄ, ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘ ꠇꠥꠖꠞꠔꠤ ꠀꠔ ꠖꠤꠀ ꠀꠝꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠍꠂꠘ, ꠅꠈꠣꠘ ꠝꠘꠅ ꠞꠄ।’ ” ");
INSERT INTO syls_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ꠚꠦꠞꠣꠃꠘꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠍꠣꠠꠣꠞ ꠛꠣꠖꠦ, ꠚꠤꠟꠤꠡ꠆ꠔꠤꠘꠤ ꠅꠇꠟꠞ ꠖꠦꠡꠞ ꠝꠣꠎꠖꠤ ꠡꠤꠗꠣ ꠙꠕ ꠕꠣꠇꠟꠦꠅ ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠢꠤ ꠙꠕꠦꠖꠤ ꠘꠤꠟꠣ ꠘꠣ। ꠀꠟ꠆ꠟꠣꠄ ꠇꠁꠟꠣ, ꠢꠦꠡꠦ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠎꠥꠖ꠆ꠖꠞ ꠝꠥꠇꠣꠛꠤꠟꠣ ꠇꠞꠣ ꠟꠣꠉꠦ, ꠔꠦ ꠝꠣꠘꠡꠦ ꠎꠥꠖ꠆ꠖꠞ ꠒꠞꠦ ꠢꠤꠞꠛꠣꠞ ꠝꠤꠡꠞꠅ ꠚꠤꠞꠤꠎꠤꠔ ꠙꠣꠞꠦ। ");
INSERT INTO syls_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","ꠄꠞꠟꠣꠉꠤ ꠔꠣꠁꠘ ꠝꠣꠘꠡꠞꠦ ꠘꠤꠟ ꠖꠞꠤꠀꠞ ꠙꠣꠞꠦꠖꠤ ꠝꠞꠥꠜꠥꠝꠤ ꠛꠣꠄ ꠘꠦꠅꠀꠁꠟꠣ; ꠔꠣꠝꠣꠝ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠍꠤꠙꠣꠁ ꠖꠟꠞ ꠟꠣꠈꠣꠘ ꠢꠣꠎꠤ-ꠙꠣꠠꠤ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠞꠅꠀꠘꠣ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","ꠎꠣꠅꠀꠞ ꠛꠣꠟꠣ ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠢꠎꠞꠔ ꠁꠃꠍꠥꠚꠞ ꠇꠄꠛꠞ ꠕꠣꠇꠤ ꠔꠣꠘ ꠀꠒ꠆ꠒꠤ-ꠉꠥꠒ꠆ꠒꠤ ꠟꠉꠦ ꠇꠞꠤ ꠘꠤꠟꠣ। ꠁꠃꠍꠥꠚꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠝꠎꠛꠥꠔ ꠇꠞꠤ ꠇꠍꠝ ꠇꠞꠣꠁ ꠇꠁꠍꠟꠣ, “ꠀꠟ꠆ꠟꠣꠄ ꠘꠤꠌꠄ ꠔꠥꠝꠞꠣꠞꠦ ꠢꠦꠚꠣꠎꠔ ꠇꠞꠛꠣ, ꠔꠦ ꠔꠥꠝꠞꠣ ꠎꠣꠅꠀꠞ ꠛꠣꠟꠣ ꠀꠝꠣꠞ ꠀꠒ꠆ꠒꠤꠉꠥꠁꠘ ꠔꠥꠟꠤꠀ ꠟꠉꠦ ꠇꠞꠤ ꠘꠤꠅꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","ꠛꠣꠖꠦ ꠔꠣꠞꠣ ꠡꠥꠇ꠆ꠇꠔ ꠉꠣꠅ ꠕꠣꠇꠤ ꠞꠅꠀꠘꠣ ꠅꠁꠀ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠇꠤꠘꠣꠞꠅ ꠄꠕꠝ ꠘꠣꠝꠞ ꠎꠣꠉꠣꠔ ꠀꠁꠀ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠔꠣꠞꠣꠞꠦ ꠙꠕ ꠌꠤꠘꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠖꠤꠘꠞ ꠛꠣꠟꠣ ꠝꠦꠊꠞ ꠈꠥꠐꠤꠞ ꠍꠥꠞꠔꠦ ꠞꠁꠔꠣ, ꠀꠞ ꠞꠣꠁꠔꠞ ꠛꠣꠟꠣꠄ ꠚꠞ ꠖꠦꠈꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠀꠉꠥꠘꠤꠞ ꠈꠥꠐꠤꠞ ꠍꠥꠞꠔꠦ ꠔꠣꠞꠣꠞ ꠀꠉꠦ ꠀꠉꠦ ꠎꠣꠁꠔꠣ, ꠄꠞꠟꠣꠉꠤ ꠔꠣꠞꠣ ꠞꠣꠁꠔ-ꠖꠤꠘ ꠢꠝꠣꠘꠦ ꠌꠟꠔꠣ ꠙꠣꠞꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","ꠝꠣꠘꠡꠞ ꠍꠣꠝꠘꠦ ꠢꠣꠝꠦꠡꠣ ꠖꠤꠘꠞ ꠛꠣꠟꠣ ꠝꠦꠊꠞ ꠈꠥꠐꠤ ꠀꠞ ꠞꠣꠁꠔꠞ ꠛꠣꠟꠣ ꠀꠉꠥꠘꠤꠞ ꠈꠥꠐꠤ ꠞꠁꠔ। ");
INSERT INTO syls_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠅ, ꠔꠣꠞꠣ ꠊꠥꠞꠤꠀ ꠀꠁꠀ ꠚꠣꠝꠣ-ꠢꠤꠞꠥꠔ ꠘꠣꠝꠞ ꠎꠣꠉꠣꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠝꠤꠉꠖꠥꠟ ꠀꠞ ꠖꠞꠤꠀꠞ ꠝꠣꠎꠣꠝꠣꠎꠤ, ꠛꠣꠀꠟ-ꠎꠣꠚꠘ ꠄꠟꠣꠇꠣꠞ ꠍꠣꠝꠘꠦ ꠖꠞꠤꠀꠞ ꠌꠞꠞ ꠝꠣꠎꠦ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","ꠁꠔꠣ ꠖꠦꠈꠟꠦ ꠚꠦꠞꠣꠃꠘꠦ ꠝꠘꠅ ꠇꠞꠛ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠇꠥꠘꠥꠛꠣꠄ ꠙꠕ ꠘꠣ ꠙꠣꠁꠀ ꠊꠥꠞꠣꠊꠥꠞꠤ ꠇꠞꠔꠦ ꠇꠞꠔꠦ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠀꠐꠇꠤ ꠉꠦꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","ꠀꠝꠤ ꠚꠦꠞꠣꠃꠘꠞ ꠖꠤꠟꠞꠦ ꠙꠣꠡꠣꠘ ꠛꠣꠘꠣꠁꠝꠥ, ꠢꠦ ꠔꠥꠝꠞꠣꠞ ꠈꠞꠦ ꠈꠞꠦ ꠈꠦꠖꠣꠘꠤꠔ ꠀꠁꠛ। ꠔꠦꠃ ꠚꠦꠞꠣꠃꠘ ꠀꠞ ꠔꠣꠞ ꠍꠤꠙꠣꠁ ꠅꠇꠟꠞꠦꠖꠤ ꠀꠝꠣꠞ ꠘꠣꠝ ꠃꠎꠤꠟꠣ ꠅꠁꠛ; ꠁꠔꠣ ꠖꠦꠈꠤꠀ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠦꠅ ꠛꠥꠎꠤꠟꠤꠛꠣ, ꠀꠝꠤꠃ ꠝꠣꠛꠥꠖ।” ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠅꠃꠟꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","ꠢꠣꠍꠣꠃ ꠝꠤꠡꠞꠞ ꠛꠣꠖꠡꠣ ꠚꠦꠞꠣꠃꠘꠦ ꠎꠦꠛꠟꠣ ꠈꠛꠞ ꠙꠣꠁꠟ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠅꠇꠟ ꠜꠣꠉꠤ ꠉꠦꠍꠂꠘ, ꠢꠥꠘꠤꠀꠃ ꠚꠦꠞꠣꠃꠘ ꠀꠞ ꠔꠣꠞ ꠃꠎꠤꠞ-ꠘꠣꠎꠤꠞꠞ ꠖꠤꠟ ꠚꠤꠞꠤꠉꠦꠟ। ꠔꠣꠞꠣ ꠇꠁꠟꠣ, “ꠢꠣꠄ, ꠢꠣꠄ! ꠀꠝꠞꠣ ꠁꠔꠣ ꠇꠤꠔꠣ ꠇꠞꠍꠤ? ꠁꠔꠣꠞꠦ ꠀꠝꠞꠣꠞ ꠉꠥꠟꠣꠝꠤ ꠕꠣꠇꠤ ꠇꠦꠘꠦ ꠍꠣꠠꠟꠣꠝ?” ");
INSERT INTO syls_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","ꠅꠈꠣꠘ ꠇꠁꠀꠃ ꠚꠦꠞꠣꠃꠘꠦ ꠔꠣꠞ ꠎꠥꠖ꠆ꠖꠞ ꠊꠥꠠꠣꠞ ꠉꠣꠠꠤ ꠢꠣꠎꠣꠘꠤꠞ ꠢꠥꠇꠥꠝ ꠖꠤꠀ, ꠔꠣꠞ ꠍꠤꠙꠣꠁ ꠅꠇꠟꠞꠦ ꠎꠥꠁꠔ ꠇꠞꠣꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ꠢꠦ ꠔꠣꠞ ꠈꠣꠍ ꠡꠇ꠆ꠔꠤꠝꠣꠘ ꠍꠄꠡ ꠊꠥꠠꠣꠞ ꠉꠣꠠꠤ, ꠝꠤꠡꠞꠞ ꠡꠛ ꠊꠥꠠꠣꠞ ꠉꠣꠠꠤꠘ ꠀꠞ ꠄꠞꠣꠞ ꠌꠣꠟꠇꠖꠣꠞ ꠍꠤꠙꠣꠁꠞꠦꠅ ꠟꠉꠦ ꠟꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","ꠝꠣꠛꠥꠖꠦ ꠝꠤꠡꠞꠞ ꠛꠣꠖꠡꠣ ꠚꠦꠞꠣꠃꠘꠞ ꠖꠤꠟꠞꠦ ꠙꠣꠡꠣꠘ ꠇꠞꠤꠟ꠆ꠟꠣ, ꠢꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠈꠞꠦ ꠈꠞꠦ ꠈꠦꠖꠣꠘꠤꠔ ꠀꠁꠟ। ꠄꠞꠣ ꠎꠦꠛꠟꠣ ꠢꠤꠝ꠆ꠝꠔ ꠇꠞꠤ ꠀꠐꠤꠀ ꠎꠣꠁꠞꠣ, ꠅꠃ ꠡꠝꠄ ꠢꠦ ꠄꠞꠣꠞꠦ ꠗꠞꠣꠔ ꠀꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","ꠢꠦ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠢꠇꠟ ꠊꠥꠠ-ꠍꠅꠀꠞ ꠍꠤꠙꠣꠁ, ꠊꠥꠠꠣꠞ ꠉꠣꠠꠤꠀꠟꠣ ꠍꠤꠙꠣꠁ ꠡꠢ ꠀꠡ꠆ꠔꠣ ꠀꠞ꠆ꠝꠤ ꠖꠟ ꠟꠁꠀ ꠄꠞꠣꠞꠦ ꠗꠞꠣꠞ ꠟꠣꠉꠤ ꠄꠞꠣꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠀꠁꠟ꠆ꠟ। ꠅꠃ ꠡꠝꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠅꠇꠟ ꠖꠞꠤꠀꠞ ꠙꠣꠞꠅ ꠛꠣꠀꠟ-ꠎꠣꠚꠘꠞ ꠍꠣꠝꠘꠦ ꠚꠣꠝꠣ-ꠢꠤꠞꠥꠔꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠀꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ꠔꠣꠞꠣ ꠇꠣꠘ꠆ꠖꠣꠔ ꠀꠁꠔꠦꠃ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠌꠣꠁꠀ ꠖꠦꠈꠟꠣ, ꠔꠣꠞꠣꠞ ꠈꠞꠦ ꠅꠁꠀ ꠝꠤꠡꠞꠤ ꠍꠤꠙꠣꠁ ꠀꠁꠞꠣ; ꠖꠦꠈꠤꠀꠃ ꠎꠣꠘꠞ ꠒꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠇꠣꠘ꠆ꠖꠘ ꠟꠣꠉꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","ꠔꠣꠞꠣ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠝꠤꠡꠞꠅ ꠇꠄꠛꠞ ꠖꠤꠛꠣꠞ ꠎꠣꠉꠣ ꠘꠣꠁ ꠖꠦꠈꠤꠀ, ꠀꠝꠞꠣꠞꠦ ꠝꠣꠞꠔꠣꠄ ꠇꠞꠤ ꠅꠃ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠟꠁꠀ ꠀꠁꠍ ꠘꠤ? ꠔꠥꠝꠤ ꠁꠔꠣ ꠇꠤꠔꠣ ꠇꠞꠟꠣꠄ? ꠇꠦꠘꠦ ꠀꠝꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠟꠣꠄ? ");
INSERT INTO syls_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","ꠝꠤꠡꠞꠞ ꠜꠤꠔꠞꠦ ꠀꠝꠞꠣ ꠔꠥꠝꠣꠞꠦ ꠇꠁꠍꠤ ꠘꠣ ꠘꠤ, ꠀꠝꠞꠣꠞꠦ ꠅꠘꠅ ꠞꠁꠔꠦ ꠖꠦꠅ, ꠀꠝꠞꠣ ꠝꠤꠡꠞꠤꠘ꠆ꠔꠞ ꠉꠥꠟꠣꠝꠤ ꠇꠞꠤ? ꠁ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠝꠞꠣꠞ ꠌꠣꠁꠔꠦ ꠝꠤꠡꠞꠤꠘ꠆ꠔꠞ ꠉꠥꠟꠣꠝꠤ ꠇꠞꠣꠃ ꠔ ꠀꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠜꠣꠟꠣ ꠀꠍꠤꠟ।” ");
INSERT INTO syls_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","ꠝꠥꠍꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠒꠞꠣꠁꠅ ꠘꠣ। ꠢꠇꠟꠦ ꠘꠤꠞꠣꠁ ꠅꠁꠀ ꠖꠦꠈꠅ, ꠝꠣꠛꠥꠖꠦ ꠀꠁꠎ ꠇꠤꠟꠣ ꠛꠣꠌꠣꠁꠘ। ꠅꠃ ꠎꠦꠔꠣ ꠝꠤꠡꠞꠤꠘ꠆ꠔꠞꠦ ꠅꠈꠘ ꠖꠦꠈꠞꠣꠄ, ꠁꠔꠣꠞꠦ ꠀꠞ ꠇꠥꠘꠥꠖꠤꠘꠃ ꠖꠦꠈꠔꠣꠄ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","ꠔꠥꠝꠞꠣ ꠅꠈꠘ ꠡꠣꠘ꠆ꠔꠤ ꠅꠅ, ꠖꠦꠈꠅ, ꠝꠣꠛꠥꠖꠦꠃ ꠔꠥꠝꠞꠣꠞ ꠙꠇ꠆ꠇ ꠅꠁꠀ ꠎꠥꠖ꠆ꠖ ꠇꠞꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠇꠦꠘꠦ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠇꠣꠘ꠆ꠖꠤꠞꠣꠄ? ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠅ ꠘꠣ, ꠍꠣꠝꠘꠦꠖꠤ ꠀꠉꠥꠀꠁꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","ꠀꠞ ꠔꠥꠝꠣꠞ ꠀꠔꠞ ꠟꠣꠑꠤꠞꠦ ꠛꠣꠠꠣꠁꠀ ꠖꠞꠤꠀꠞ ꠃꠙꠞꠦ ꠃꠌꠣ ꠇꠞꠤ ꠗꠞꠅ, ꠖꠞꠤꠀꠞꠦ ꠖꠥꠁ ꠜꠣꠉ ꠇꠞꠤꠟꠣꠅ। ꠔꠦꠃ ꠔꠣꠝꠣꠝ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠢꠥꠇꠘꠣ ꠛꠣꠄ ꠀꠐꠤꠀ ꠖꠞꠤꠀ ꠙꠣꠞ ꠅꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","ꠈꠤꠀꠟ ꠞꠣꠈꠤꠅ, ꠀꠝꠤ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠖꠤꠟ ꠅꠟꠣ ꠙꠣꠡꠣꠘ ꠛꠣꠘꠣꠁꠝꠥ, ꠔꠣꠞꠣ ꠄꠞꠣꠞꠦ ꠗꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠖꠞꠤꠀꠔ ꠢꠣꠝꠣꠁꠛꠣ। ꠄꠞꠛꠣꠖꠦ ꠚꠦꠞꠣꠃꠘ, ꠔꠣꠞ ꠍꠤꠙꠣꠁ, ꠔꠣꠞ ꠊꠥꠠꠣꠞ ꠉꠣꠠꠤꠘ, ꠔꠣꠞ ꠊꠥꠠ-ꠍꠅꠀꠞ ꠅꠇꠟꠞ ꠝꠣꠎꠖꠤ ꠀꠝꠣꠞ ꠎꠣꠟꠣꠟ-ꠡꠣꠘ ꠎꠣꠁꠞ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","ꠚꠦꠞꠣꠃꠘꠞ ꠢꠣꠟ-ꠢꠇꠤꠇꠔ ꠖꠦꠈꠤꠀ ꠛꠣꠇꠤ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠦꠅ ꠛꠥꠎꠤꠟꠤꠛꠣ, ꠀꠝꠤꠃ ꠝꠣꠛꠥꠖ।” ");
INSERT INTO syls_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","ꠄꠞꠝꠣꠎꠦ ꠀꠟ꠆ꠟꠣꠞ ꠎꠦ ꠚꠤꠞꠤꠡ꠆ꠔꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠀꠉꠦ ꠅꠁꠀ ꠎꠣꠅꠀꠔ ꠀꠍꠟꠣ, ꠄꠁꠘ ꠎꠣꠉꠣ ꠛꠖꠟꠣꠁꠀ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠈꠞꠦ ꠉꠦꠟꠣꠉꠤ। ꠄꠘ ꠟꠉꠦ ꠅꠁꠀ ꠇꠥꠖꠞꠔꠤ ꠢꠃ ꠝꠦꠊꠞ ꠈꠥꠐꠤꠅ ꠍꠣꠝꠘꠦ ꠕꠣꠇꠤ ꠢꠞꠤꠀ ꠈꠞꠦ ꠀꠁꠟ꠆ꠟ। ");
INSERT INTO syls_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ꠈꠞꠦ ꠀꠁꠀ ꠝꠤꠡꠞꠤ ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠤ ꠖꠥꠁꠅ ꠖꠟꠞ ꠝꠣꠎꠈꠣꠘꠅ ꠃꠛꠣꠁꠟ। ꠄꠞꠟꠣꠉꠤ ꠅꠃ ꠝꠦꠊꠞ ꠈꠥꠐꠤꠞ ꠀꠘ꠆ꠖꠣꠁꠞꠦ ꠝꠤꠡꠞꠤ ꠅꠇꠟ ꠀꠘ꠆ꠖꠣꠞꠤꠔ ꠙꠠꠤꠉꠦꠟꠣ, ꠔꠣꠞꠣ ꠞꠣꠁꠔꠞ ꠛꠣꠟꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠇꠣꠘ꠆ꠖꠣ ꠟꠁꠔꠣ ꠙꠣꠞꠟꠣ ꠘꠣ। ꠅꠁꠟꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠍꠣꠝꠘꠦ ꠞꠣꠁꠔꠞ ꠛꠣꠟꠣꠅ ꠝꠦꠊꠞ ꠈꠥꠐꠤꠞ ꠚꠞꠡꠣ ꠞꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","ꠛꠣꠖꠦ ꠝꠥꠍꠣꠄ ꠖꠞꠤꠀꠞ ꠃꠙꠞꠦ ꠔꠣꠘ ꠀꠔ ꠛꠣꠠꠣꠁꠟꠣ, ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠢꠣꠞꠣ ꠞꠣꠁꠔ ꠈꠥꠛ ꠎꠥꠞꠦ ꠙꠥꠛꠣꠟꠤ ꠢꠣꠅꠀ ꠖꠤꠀ ꠖꠞꠤꠀꠞ ꠙꠣꠘꠤ ꠢꠞꠣꠁꠀ ꠖꠥꠁ ꠛꠣꠐ ꠇꠞꠤꠟ꠆ꠟꠣ, ꠖꠞꠤꠀ ꠢꠥꠇꠣꠁꠀ ꠝꠣꠎꠦꠖꠤ ꠢꠥꠇꠘꠣ ꠙꠕ ꠛꠣꠞ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠅꠇꠟꠦ ꠢꠥꠇꠘꠣ ꠙꠣꠅꠄ ꠖꠞꠤꠀꠞ ꠝꠣꠎꠖꠤ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣ, ꠖꠞꠤꠀꠞ ꠙꠣꠘꠤ ꠔꠣꠞꠣꠞ ꠒꠣꠁꠘꠦ-ꠛꠣꠃꠄ ꠅꠀꠟꠞ ꠟꠣꠈꠣꠘ ꠃꠛꠣꠁ ꠞꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","ꠁꠔꠣ ꠖꠦꠈꠤꠀ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠦ ꠔꠣꠞꠣꠞꠦ ꠈꠦꠖꠣꠁꠀ ꠖꠞꠤꠀꠞ ꠢꠃ ꠢꠥꠇꠘꠣ ꠙꠕꠦꠖꠤ ꠉꠦꠟꠣ। ꠚꠦꠞꠣꠃꠘꠞ ꠢꠇ꠆ꠇꠟ ꠊꠥꠠꠣꠞ ꠉꠣꠠꠤ, ꠊꠥꠠꠣ, ꠀꠞ ꠊꠥꠠ-ꠍꠅꠀꠞ ꠅꠇꠟ ꠈꠦꠖꠣꠁ ꠈꠦꠖꠣꠁ ꠖꠞꠤꠀꠞ ꠢꠃ ꠙꠕꠅ ꠉꠤꠀ ꠢꠣꠝꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","ꠀꠞ ꠙꠔꠣꠛꠣꠟꠣ ꠝꠣꠛꠥꠖꠦ ꠢꠃ ꠇꠥꠖꠞꠔꠤ ꠀꠉꠥꠁꠘ ꠀꠞ ꠝꠦꠊꠞ ꠈꠥꠐꠤ ꠕꠣꠇꠤ ꠝꠤꠡꠞꠤ ꠍꠤꠙꠣꠁꠞ ꠛꠣꠄ ꠟꠣꠘ꠆ꠘꠔꠤ ꠘꠎꠞꠦ ꠌꠣꠁꠟꠣ, ꠔꠦꠃ ꠔꠣꠞꠣ ꠛꠦꠖꠤꠡꠣ ꠟꠣꠉꠤꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","ꠔꠣꠁꠘ ꠄꠞꠣꠞ ꠊꠥꠠꠣꠞ ꠉꠣꠠꠤꠞ ꠌꠣꠇ꠆ꠇꠣ ꠘꠡ꠆ꠐ ꠇꠞꠤ ꠖꠤꠟꠣ, ꠄꠞꠟꠣꠉꠤ ꠔꠣꠞꠣꠞ ꠈꠥꠛ ꠇꠡ꠆ꠐ ꠇꠞꠤꠀꠅ ꠉꠣꠠꠤ ꠌꠣꠟꠣꠘꠤꠔ ꠞꠁꠟ; ꠄꠞꠝꠣꠎꠦ ꠔꠣꠞꠣ ꠄꠇꠦ-ꠅꠁꠘ꠆ꠘꠞꠦ ꠇꠁꠟ, “ꠅꠁꠍꠦ, ꠀꠞ ꠛꠣꠖ ꠖꠦꠅ, ꠀꠝꠞꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠈꠞ ꠕꠘꠦ ꠢꠞꠤ ꠎꠣꠁ। ꠝꠣꠛꠥꠖꠦ ꠘꠤꠎꠦ ꠔꠣꠞꠣꠞ ꠙꠇ꠆ꠇ ꠅꠁꠀ ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠎꠥꠖ꠆ꠖ ꠇꠞꠞꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","ꠅꠃ ꠡꠝꠄ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠖꠞꠤꠀꠞ ꠃꠙꠞꠦ ꠢꠤꠞꠛꠣꠞ ꠀꠔ ꠛꠣꠠꠣꠅ। ꠔꠥꠝꠣꠞ ꠀꠔ ꠛꠣꠠꠣꠁꠟꠦ ꠙꠣꠘꠤ ꠢꠤꠞꠛꠣꠞ ꠝꠤꠡꠞꠤꠘ꠆ꠔꠞ ꠃꠙꠞꠦ, ꠔꠣꠞꠣꠞ ꠊꠥꠠꠣꠞ ꠉꠣꠠꠤ ꠀꠞ ꠊꠥꠠ-ꠍꠅꠀꠞꠞ ꠃꠙꠞꠦ ꠀꠁꠛ꠆ꠛ।” ");
INSERT INTO syls_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","ꠝꠥꠍꠣꠄ ꠖꠞꠤꠀꠞ ꠃꠙꠞꠦ ꠀꠔ ꠛꠣꠠꠣꠁꠟꠣ, ꠀꠞ ꠛꠤꠀꠘ ꠅꠀꠞ ꠀꠉꠦꠃ ꠖꠞꠤꠀꠞ ꠙꠣꠘꠤ ꠢꠤꠞꠛꠣꠞ ꠢꠝꠣꠘ ꠅꠁꠉꠦꠟ; ꠝꠤꠡꠞꠤꠘ꠆ꠔꠦ ꠒꠣꠁꠘꠦ-ꠛꠣꠃꠄ ꠖꠃꠠꠣ-ꠖꠃꠠꠤ ꠟꠣꠉꠣꠁꠟꠣ, ꠅꠁꠟꠦ ꠝꠣꠛꠥꠖꠦ ꠔꠣꠞꠣꠞꠦ ꠖꠞꠤꠀꠞ ꠙꠣꠘꠤꠖꠤ ꠜꠣꠅꠀꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","ꠙꠣꠘꠤ ꠢꠤꠞꠛꠣꠞ ꠎꠣꠉꠣꠔ ꠀꠁꠟ꠆ꠟ, ꠔꠣꠞꠣꠞ ꠊꠥꠠꠣꠞ ꠉꠣꠠꠤꠘ, ꠍꠤꠙꠣꠁꠘ, ꠀꠞ ꠊꠥꠠ-ꠍꠅꠀꠞ ꠅꠇꠟ, ꠝꠣꠘꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠈꠞꠦ ꠅꠁꠀ ꠈꠦꠖꠣꠘꠤꠔ ꠀꠅꠞꠣ ꠢꠇ꠆ꠇꠟꠔꠣ ꠙꠣꠘꠤꠄ ꠛꠥꠠꠤꠉꠦꠟ, ꠄꠉꠥꠅ ꠎꠤꠔꠣ ꠞꠁꠟꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","ꠅꠁꠟꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠅꠇꠟꠦ ꠢꠥꠇꠘꠣ ꠙꠕꠦ ꠖꠞꠤꠀꠞ ꠝꠣꠎꠖꠤ ꠉꠦꠟꠣ, ꠔꠣꠞꠣꠞ ꠒꠣꠁꠘꠦ-ꠛꠣꠃꠄ ꠙꠣꠘꠤ ꠅꠀꠟꠞ ꠟꠣꠈꠣꠘ ꠃꠛꠣꠁ ꠞꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠝꠣꠛꠥꠖꠦ ꠢꠤ ꠖꠤꠘ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠀꠔ ꠕꠣꠇꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠛꠣꠌꠣꠁꠟꠣ, ꠔꠣꠞꠣ ꠘꠤꠎꠞ ꠌꠃꠈꠦ ꠖꠦꠈꠟꠣ, ꠝꠤꠡꠞꠤꠘ꠆ꠔꠞ ꠝꠞꠣ ꠟꠣꠡ ꠖꠞꠤꠀꠞ ꠌꠞꠅ ꠙꠠꠤꠀ ꠞꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","ꠝꠤꠡꠞꠤꠘ꠆ꠔꠞ ꠃꠙꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠇꠥꠖꠞꠔꠤ ꠟꠤꠟꠣ-ꠈꠦꠟꠣ ꠖꠦꠈꠤꠀ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦꠅ ꠝꠣꠛꠥꠖꠞꠦ ꠒꠞꠣꠁꠉꠦꠟꠣ। ꠔꠣꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠃꠙꠞꠦ ꠀꠞ ꠔꠣꠘ ꠉꠥꠟꠣꠝ ꠢꠎꠞꠔ ꠝꠥꠍꠣꠞ ꠃꠙꠞꠦ ꠙꠥꠞꠣꠙꠥꠞ ꠁꠝꠣꠘ ꠀꠘꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","ꠀꠟ꠆ꠟꠣꠞ ꠇꠥꠖꠞꠔꠦ ꠘꠤꠟ ꠖꠞꠤꠀ ꠙꠣꠞ ꠅꠁꠀ ꠀꠁꠀ ꠢꠣꠞꠟꠦ, ꠢꠎꠞꠔ ꠝꠥꠍꠣ ꠀꠞ ꠔꠣꠝꠣꠝ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠅꠃ ꠡꠥꠇꠥꠞꠣꠘꠣ ꠉꠎꠟ ꠉꠣꠁꠟꠣ: “ꠀꠝꠤ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠉꠎꠟ ꠉꠣꠁ, ꠢꠇꠟꠞ ꠍꠣꠝꠘꠦ ꠔꠣꠘ ꠇꠥꠖꠞꠔꠤ ꠝꠢꠤꠝꠣ ꠛꠣꠠꠤꠍꠦ, ꠊꠥꠠ-ꠍꠅꠀꠞ ꠡꠥꠖ꠆ꠖꠣ ꠊꠥꠠꠣꠁꠘꠞꠦ ꠔꠣꠁꠘꠃ ꠖꠞꠤꠀꠞ ꠙꠣꠘꠤꠔ ꠚꠣꠟꠣꠁꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","ꠀꠟ꠆ꠟꠣꠃ ꠔ ꠀꠝꠣꠞ ꠛꠟ, ꠔꠣꠁꠘꠃ ꠀꠝꠣꠞ ꠉꠎꠟ, ꠀꠝꠣꠞꠦ ꠛꠣꠌꠣꠘꠤꠞ ꠇꠟ-ꠇꠛꠎꠣ ꠔꠣꠘ ꠀꠔꠅ ꠀꠍꠦ। ꠅꠃ ꠀꠟ꠆ꠟꠣꠃ ꠀꠝꠣꠞ ꠝꠣꠛꠥꠖ, ꠀꠝꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠝꠣꠛꠥꠖ, ꠀꠝꠤ ꠔꠣꠘ ꠢꠣꠝꠖ ꠉꠣꠁꠝꠥ, ꠔꠣꠘ ꠟꠤꠟꠣ-ꠈꠦꠟꠣꠞ ꠛꠄꠀꠘ ꠇꠞꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","ꠝꠣꠛꠥꠖ ꠅꠁꠟꠣ ꠙꠄꠟꠥꠀꠘ ꠍꠤꠙꠣꠁ, ꠔꠣꠘ ꠘꠣꠝꠃ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ꠚꠦꠞꠣꠃꠘꠞ ꠊꠥꠠꠣꠞ ꠉꠣꠠꠤꠞꠦ ꠀꠞ ꠍꠤꠙꠣꠁꠞꠦ ꠔꠣꠁꠘ ꠙꠣꠘꠤꠔ ꠚꠣꠟꠣꠁꠟꠣ, ꠔꠣꠞ ꠘꠣꠝꠇꠞꠣ ꠍꠥꠛꠦꠖꠣꠞ ꠅꠇꠟ ꠘꠤꠟ ꠖꠞꠤꠀꠔ ꠛꠥꠠꠤꠀ ꠝꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","ꠉꠁꠘ ꠙꠣꠘꠤꠄ ꠔꠣꠞꠣꠞꠦ ꠉꠤꠟꠤꠟ꠆ꠟ, ꠀꠞ ꠜꠣꠞꠤ ꠙꠣꠔ꠆ꠔꠞꠞ ꠟꠣꠈꠣꠘ ꠔꠣꠞꠣ ꠖꠞꠤꠀꠞ ꠔꠟꠦ ꠉꠦꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","ꠅ ꠝꠣꠛꠥꠖ, ꠔꠥꠝꠣꠞ ꠒꠣꠁꠘ ꠀꠔꠈꠣꠘ ꠇꠥꠖꠞꠔꠤ ꠟꠤꠟꠣꠄ ꠜꠞꠣ, ꠔꠥꠝꠣꠞ ꠀꠔꠦ ꠘꠤꠌ꠆ꠌꠄ ꠖꠥꠡꠝꠘꠞꠦ ꠌꠥꠞꠝꠣꠞ ꠇꠞꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","ꠔꠥꠝꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠎꠦꠔꠣꠄ ꠟꠣꠉꠍꠤꠟꠣ, ꠇꠥꠖꠞꠔꠤ ꠛꠟꠦ ꠔꠣꠞꠣꠞꠦ ꠉꠁꠘ ꠉꠣꠔꠅ ꠚꠣꠟꠣꠁꠟꠣꠄ। ꠔꠥꠝꠣꠞ ꠙꠣꠑꠣꠁꠟ ꠉꠎꠛꠤ ꠀꠉꠥꠁꠘꠦ, ꠢꠥꠇꠘꠣ ꠈꠦꠞ-ꠘꠦꠞꠣꠞ ꠟꠣꠈꠣꠘ ꠔꠣꠞꠣꠞꠦ ꠎꠣꠟꠣꠁꠟꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","ꠔꠥꠝꠣꠞ ꠘꠣꠇꠞ ꠖꠝꠦ ꠢꠇꠟ ꠙꠣꠘꠤ ꠖꠟꠣ ꠅꠁꠉꠦꠟ, ꠙꠣꠘꠤꠞ ꠚꠥꠔ ꠅꠇꠟ ꠎꠣꠉꠣꠔ ꠃꠛꠣꠁ ꠞꠁꠟ, ꠖꠞꠤꠀꠞ ꠉꠁꠘ ꠙꠣꠘꠤ ꠌꠣꠇ꠆ꠇꠣ ꠛꠘꠤꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","ꠖꠥꠡꠝꠘꠦ ꠇꠁꠍꠤꠟ, ‘ꠀꠝꠤ ꠁꠔꠣꠞꠦ ꠈꠦꠖꠣꠁꠀ ꠘꠤꠝꠥ, ꠖꠃꠠꠣꠁꠀ ꠘꠤꠀ ꠗꠞꠝꠥ, ꠔꠣꠞꠣꠞ ꠢꠇꠟꠔꠣ ꠇꠣꠠꠤꠀ ꠀꠘꠤꠀ ꠛꠣꠐꠤꠝꠥ। ꠔꠣꠞꠣꠞ ꠝꠣꠟꠖꠤ ꠀꠝꠤ ꠝꠣꠟꠖꠣꠞ ꠅꠁꠝꠥ, ꠁꠔꠣꠖꠤ ꠀꠝꠣꠞ ꠝꠘꠞ ꠈꠣꠁꠡ ꠙꠥꠞꠣꠁꠝꠥ। ꠀꠝꠣꠞ ꠔꠟꠥꠀꠞꠖꠤ ꠝꠣꠞꠤꠀ ꠔꠣꠞꠣꠞ ꠘꠣꠝ ꠝꠤꠐꠣꠁꠟꠤꠝꠥ।’ ");
INSERT INTO syls_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","ꠅꠁꠟꠦ ꠔꠥꠝꠤ ꠚꠥ ꠖꠤꠀ ꠛꠣꠔꠣꠡ ꠖꠤꠟꠣꠄ, ꠀꠞ ꠖꠞꠤꠀꠄ ꠔꠣꠞꠣꠞꠦ ꠉꠥꠞꠤꠟꠤꠟ, ꠔꠣꠞꠣ ꠡꠤꠡꠣꠞ ꠟꠣꠈꠣꠘ ꠉꠁꠘ ꠙꠣꠘꠤꠔ ꠔꠟꠣꠁꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","ꠅ ꠝꠣꠛꠥꠖ, ꠇꠥꠘ ꠖꠦꠛ-ꠖꠦꠛꠤ ꠔꠥꠝꠣꠞ ꠢꠝꠣꠘ? ꠇꠦ ꠔꠥꠝꠣꠞ ꠟꠣꠈꠣꠘ ꠅꠔ ꠙꠛꠤꠔ꠆ꠞ ꠝꠢꠣꠘ, ꠀꠞ ꠔꠥꠝꠣꠞ ꠝꠔ ꠜꠄꠅꠋꠇꠞ ꠇꠥꠖꠞꠔꠤ ꠝꠢꠤꠝꠣ ꠇꠣꠞ ꠀꠍꠦ? ");
INSERT INTO syls_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","ꠔꠥꠝꠣꠞ ꠛꠟꠀꠟꠣ ꠒꠣꠁꠘ ꠀꠔꠈꠣꠘ ꠛꠣꠠꠣꠁꠟꠣꠄ, ꠀꠞ ꠖꠥꠘꠤꠀꠄ ꠔꠣꠞꠣꠞꠦ ꠉꠤꠟꠤꠟꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","ꠔꠥꠝꠣꠞ ꠈꠣꠍ ꠝꠣꠄꠀꠄ ꠎꠦꠞꠣꠞꠦ ꠛꠣꠌꠣꠁꠍ, ꠔꠣꠞꠣꠞꠦ ꠔ ꠔꠥꠝꠤꠃ ꠌꠣꠟꠣꠁꠞꠣꠄ, ꠔꠥꠝꠣꠞ ꠀꠙꠘ ꠇꠥꠖꠞꠔꠤ ꠛꠟꠦ ꠔꠥꠝꠣꠞ ꠙꠛꠤꠔ꠆ꠞ ꠛꠡꠔ ꠈꠣꠘꠣꠔ ꠘꠤꠞꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","ꠁꠔꠣ ꠢꠥꠘꠤꠀ ꠢꠇ꠆ꠇꠟ ꠎꠣꠔꠤꠄ ꠇꠣꠙꠤꠞꠣ, ꠚꠤꠟꠤꠡ꠆ꠔꠤꠘꠤ ꠛꠦ-ꠖꠤꠘ ꠅꠇꠟꠞ ꠝꠘ ꠍꠐꠚꠐ ꠇꠞꠦꠞ। ");
INSERT INTO syls_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ꠁꠖꠥꠝꠞ ꠡꠞ꠆ꠖꠣꠞ ꠅꠇꠟ ꠒꠞꠣꠁꠀ ꠛꠦꠖꠤꠡꠣ ꠟꠣꠉꠤꠉꠦꠟꠣ, ꠝꠥꠀꠛꠞ ꠘꠦꠔꠣ ꠅꠇꠟꠦ ꠕꠞ-ꠕꠞꠣꠁꠀ ꠇꠣꠙꠤꠟꠣ, ꠇꠦꠘꠣꠘꠤ ꠅꠇꠟ ꠒꠞꠣꠁꠀ ꠢꠞꠤꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ꠔꠣꠞꠣꠞ ꠜꠤꠔꠞꠦ ꠒꠞ-ꠈꠚ ꠀꠁꠀ ꠢꠣꠝꠣꠁꠍꠦ, ꠔꠥꠝꠣꠞ ꠀꠔꠞ ꠑꠦꠟꠣꠄ ꠙꠣꠔ꠆ꠔꠞꠞ ꠟꠣꠈꠣꠘ ꠘꠤꠞꠣꠁ ꠅꠁꠉꠦꠍꠦ। ꠅ ꠝꠣꠛꠥꠖ, ꠔꠥꠝꠣꠞ ꠙ꠆ꠞꠎꠣ ꠅꠇꠟ, ꠔꠥꠝꠣꠞ ꠈꠞꠤꠖꠣ ꠉꠥꠟꠣꠝ ꠅꠇꠟ, ꠙꠥꠞꠣꠙꠥꠞ ꠙꠣꠞ ꠘꠣ ꠅꠀ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠔꠥꠝꠤ ꠅꠃꠟꠣ ꠞꠣꠈꠍ। ");
INSERT INTO syls_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","ꠔꠥꠝꠤ ꠄꠞꠣꠞꠦ ꠘꠤꠀ ꠉꠣꠍꠞ ꠌꠦꠞꠣꠞ ꠟꠣꠈꠣꠘ, ꠔꠥꠝꠣꠞ ꠘꠤꠎꠞ ꠙꠣꠠꠅ ꠞꠥꠁꠛꠣꠄ। ꠅ ꠝꠣꠛꠥꠖ, ꠢꠈꠣꠘꠃ ꠔꠥꠝꠣꠞ ꠛꠡꠔ ꠈꠣꠘꠣ, ꠔꠥꠝꠣꠞ ꠀꠙꠘ ꠀꠔꠞ ꠉꠠꠣ ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚ। ");
INSERT INTO syls_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","ꠅ ꠝꠣꠛꠥꠖ, ꠎꠥꠉ ꠎꠥꠉ ꠗꠞꠤ ꠔꠥꠝꠤꠃ ꠈꠣꠟꠤ ꠛꠣꠖꠡꠣꠁ ꠇꠞꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","ꠚꠦꠞꠣꠃꠘꠞ ꠊꠥꠠꠣꠁꠘ, ꠔꠣꠞ ꠊꠥꠠꠣꠞ ꠉꠣꠠꠤꠘ ꠀꠞ ꠊꠥꠠ-ꠍꠅꠀꠞ ꠅꠇꠟ ꠎꠦꠛꠟꠣ ꠖꠞꠤꠀꠞ ꠝꠣꠎꠦ ꠢꠣꠝꠣꠁꠉꠦꠟ, ꠝꠣꠛꠥꠖꠦ ꠔꠣꠞꠣꠞ ꠃꠙꠞꠦ ꠖꠞꠤꠀꠞ ꠙꠣꠘꠤ ꠚꠤꠞꠣꠁ ꠀꠘꠟꠣ, ꠅꠁꠟꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠢꠇꠟ ꠔ ꠢꠥꠇꠘꠣ ꠙꠕꠦ ꠖꠞꠤꠀꠞ ꠝꠣꠎꠦꠖꠤ ꠀꠉꠦ ꠀꠐꠤꠀ ꠉꠦꠍꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","ꠢꠣꠞꠥꠘꠞ ꠛꠁꠘ ꠢꠎꠞꠔ ꠝꠞꠤꠅꠝꠅ ꠘꠛꠤ ꠀꠍꠟꠣ, ꠔꠣꠁꠘ ꠒꠥꠉꠤ ꠀꠔꠅ ꠟꠁꠀ ꠛꠣꠎꠣꠁꠟꠣ, ꠀꠞ ꠛꠣꠇꠤ ꠢꠇꠟ ꠛꠦꠐꠤꠘ꠆ꠔꠦꠅ ꠔꠣꠘ ꠈꠞꠦꠖꠤ ꠒꠥꠉꠤ ꠟꠁꠀ ꠘꠣꠌꠤ ꠘꠣꠌꠤ ꠛꠣꠞ ꠅꠁ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","ꠀꠞ ꠝꠞꠤꠅꠝꠦꠅ ꠝꠣꠘꠡꠞ ꠍꠣꠝꠘꠦ ꠅꠃꠟꠣ ꠉꠣꠁꠟꠣ: “ꠔꠥꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠉꠎꠟ ꠉꠣꠅ, ꠢꠇꠟꠞ ꠍꠣꠝꠘꠦ ꠔꠣꠘ ꠇꠥꠖꠞꠔꠤ ꠝꠢꠤꠝꠣ ꠛꠣꠠꠤꠍꠦ, ꠊꠥꠠ-ꠍꠅꠀꠞ ꠡꠥꠖ꠆ꠖꠣ ꠊꠥꠠꠣꠁꠘꠞꠦ ꠔꠣꠁꠘꠃ ꠖꠞꠤꠀꠞ ꠙꠣꠘꠤꠔ ꠚꠣꠟꠣꠁꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","ꠝꠥꠍꠣꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠘꠤꠟ ꠖꠞꠤꠀ ꠕꠣꠇꠤ ꠍꠣꠝꠘꠦꠖꠤ ꠟꠁꠀ ꠞꠅꠀꠘꠣ ꠅꠁꠟꠣ, ꠀꠞ ꠡꠥꠞ ꠘꠣꠝꠞ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠉꠦꠟꠣ। ꠔꠣꠞꠣꠞ ꠎꠣꠅꠀꠞ ꠙꠕꠅ ꠔꠤꠘ ꠖꠤꠘ ꠗꠞꠤ ꠇꠥꠘꠥ ꠙꠣꠘꠤ ꠙꠣꠁꠟꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","ꠛꠣꠖꠦ ꠔꠣꠞꠣ ꠝꠣꠞꠥꠀ ꠘꠣꠝꠞ ꠄꠇ ꠎꠣꠉꠣꠔ ꠀꠁꠟꠣ, ꠅꠁꠟꠦ ꠢꠤꠘꠞ ꠙꠣꠘꠤꠅ ꠈꠣꠁꠔꠣ ꠙꠣꠞꠟꠣ ꠘꠣ, ꠢꠤꠘꠞ ꠙꠣꠘꠤ ꠈꠥꠛ ꠔꠤꠔ꠆ꠔꠣ। ꠄꠞꠟꠣꠉꠤ ꠅꠃ ꠎꠣꠉꠣꠞ ꠘꠣꠝ ꠟꠣꠉꠟ ꠝꠣꠞꠥꠀ ꠝꠣꠘꠤ, ꠔꠤꠔ꠆ꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","ꠀꠞ ꠝꠣꠘꠡꠦ ꠝꠥꠍꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠇꠣꠘꠣ-ꠇꠣꠘꠤ ꠇꠞꠤ ꠇꠁꠟꠣ, “ꠀꠝꠞꠣ ꠅꠈꠘ ꠙꠣꠘꠤ ꠈꠣꠁꠔꠣꠝ ꠇꠤꠟꠣ?” ");
INSERT INTO syls_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","ꠝꠥꠍꠣꠄ ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍꠦ ꠚꠞꠤꠀꠖ ꠇꠞꠟꠣ, ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘꠞꠦ ꠄꠉꠥ ꠉꠣꠍ ꠖꠦꠈꠣꠁ ꠖꠤꠟꠣ, ꠔꠣꠁꠘ ꠢꠃ ꠉꠣꠍꠞꠦ ꠘꠤꠀ ꠙꠣꠘꠤꠔ ꠚꠣꠟꠣꠁꠟꠣ, ꠀꠞ ꠙꠣꠘꠤ ꠝꠤꠑꠣ ꠅꠁꠉꠦꠟ। ꠝꠣꠛꠥꠖꠦ ꠢꠃ ꠎꠣꠉꠣꠔ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠙꠞꠤꠇ꠆ꠇꠣ ꠟꠁꠟꠣ, ꠀꠞ ꠔꠣꠞꠣꠞ ꠟꠣꠉꠤ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠛꠣꠔꠣꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠎꠥꠖꠤ ꠈꠤꠀꠟ ꠇꠞꠤꠀ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠇꠣꠟꠣꠝ ꠢꠥꠘꠅ ꠀꠞ ꠅꠃ ꠟꠣꠈꠣꠘ ꠀꠝꠟ ꠇꠞꠅ, ꠀꠝꠤ ꠎꠦꠔꠣ ꠙꠍꠘ꠆ꠖ ꠇꠞꠤ ꠅꠔꠣ ꠇꠞꠅ, ꠀꠝꠣꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠘꠅ, ꠔꠦ ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞꠦ ꠎꠦꠔꠣ ꠛꠦꠝꠣꠞ-ꠀꠎꠣꠞ ꠖꠤꠍꠤ, ꠁꠔꠣ ꠇꠥꠘꠥ ꠛꠦꠝꠣꠞ ꠔꠥꠝꠞꠣꠞ ꠃꠙꠞꠦ ꠖꠤꠔꠣꠝ ꠘꠣꠄ; ꠎꠣꠘ ꠔ, ꠀꠝꠤ ꠝꠣꠛꠥꠖ ꠔꠥꠝꠞꠣꠞ ꠡꠤꠚꠣ ꠇꠞꠘꠦꠀꠟꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","ꠢꠦꠡꠦ ꠔꠣꠞꠣ ꠄꠟꠤꠝꠅ ꠉꠤꠀ ꠙꠃꠍꠟꠣ, ꠢꠤꠘꠅ ꠛꠣꠞꠅꠉꠥ ꠙꠣꠘꠤꠞ ꠁꠘ꠆ꠖꠣꠞꠣ ꠀꠞ ꠡꠔ꠆ꠔꠁꠞꠉꠥ ꠈꠦꠎꠥꠞ ꠉꠣꠍ ꠀꠍꠤꠟ। ꠔꠣꠞꠣ ꠅꠃ ꠙꠣꠘꠤꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ꠛꠣꠖꠦ ꠔꠣꠝꠣꠝ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠄꠟꠤꠝ ꠕꠣꠇꠤ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣꠁꠟꠣ। ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠣꠞꠘꠤꠞ ꠛꠣꠖꠞ ꠌꠣꠘ꠆ꠖꠞ ꠙꠘꠞ ꠔꠣꠞꠤꠈꠅ ꠔꠣꠞꠣ ꠍꠤꠘ ꠘꠣꠝꠞ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠀꠁꠀ ꠀꠎꠤꠟꠣ। ꠍꠤꠘ ꠅꠁꠟ ꠔꠥꠞ ꠙꠣꠠ ꠀꠞ ꠄꠟꠤꠝꠞ ꠝꠣꠎꠈꠣꠘꠅ। ");
INSERT INTO syls_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","ꠅꠃ ꠡꠝꠄ ꠔꠣꠝꠣꠝ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠇꠣꠘꠣ-ꠇꠣꠘꠤ ꠟꠣꠉꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ꠄꠞꠣ ꠖꠥꠁꠅꠎꠘꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠇꠁꠟꠣ, “ꠢꠣꠄꠞꠦ ꠢꠣꠄ, ꠁꠔꠣꠞ ꠇꠕꠣꠄ ꠀꠝꠞꠣ ꠇꠦꠘꠦ ꠀꠁꠟꠣꠝ, ꠝꠣꠛꠥꠖꠦ ꠇꠦꠘꠦ ꠘꠤꠎꠞ ꠀꠔꠦ ꠀꠝꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠝꠣꠞꠟꠣ ꠘꠣ? ꠢꠤ ꠡꠝꠄ ꠀꠝꠞꠣ ꠉꠥꠡ꠆ꠔꠞ ꠒꠦꠉꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠛꠁꠔꠣꠝ, ꠙꠦꠐ ꠜꠞꠤꠀ ꠉꠥꠡ꠆ꠔ-ꠞꠥꠐꠤ ꠈꠣꠁꠔꠣꠝ, ꠅꠁꠟꠦ ꠁꠔꠣꠄ ꠀꠝꠞꠣꠞꠦ ꠃꠙꠣꠡꠦ ꠀꠞ ꠙꠦꠐꠞ ꠜꠥꠇꠦ ꠝꠣꠞꠔꠣ ꠇꠞꠤ ꠅꠘꠅ ꠀꠘꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠙꠞꠤꠇ꠆ꠇꠣ ꠇꠞꠤꠀ ꠖꠦꠈꠝꠥ, ꠔꠣꠞꠣ ꠀꠝꠣꠞ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠝꠣꠘꠂꠘ ꠇꠤ ꠘꠣ। ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠈꠣꠘꠤ ꠝꠦꠊꠞ ꠎꠠꠤꠞ ꠟꠣꠈꠣꠘ ꠀꠍꠝꠣꠘ ꠕꠣꠇꠤ ꠎꠝꠤꠘꠅ ꠍꠣꠠꠤꠝꠥ। ꠝꠣꠘꠡꠦ ꠛꠣꠁꠞꠦ ꠀꠁꠀ ꠢꠣꠙ꠆ꠔꠣꠞ ꠙꠞꠔꠦꠇ ꠖꠤꠘꠞ ꠈꠣꠘꠤ ꠙꠞꠔꠤ ꠖꠤꠘ ꠔꠥꠟꠤꠀ ꠘꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ꠈꠣꠟꠤ ꠢꠣꠙ꠆ꠔꠣꠞ ꠍꠄ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘꠅ ꠔꠣꠞꠣ ꠎꠦꠔꠣ ꠔꠥꠟꠤꠀ ꠀꠘꠛꠣ, ꠁꠔꠣ ꠔꠂꠀꠞ ꠇꠞꠣꠞ ꠛꠣꠖꠦ ꠅꠁꠘ꠆ꠘ ꠖꠤꠘꠞ ꠈꠣꠘꠤ ꠕꠣꠇꠤ ꠒꠣꠛꠥꠟ ꠅꠁꠎꠤꠛ।” ");
INSERT INTO syls_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","ꠛꠣꠖꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠦ ꠢꠇ꠆ꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠔꠥꠝꠞꠣ ꠎꠦꠛꠟꠣ ꠇꠣꠘꠣ-ꠇꠣꠘꠤ ꠟꠣꠉꠣꠁꠍ, ꠔꠦ ꠀꠁꠎ ꠢꠣꠁꠘ꠆ꠎꠣ ꠛꠣꠟꠣꠃ ꠛꠥꠎꠛꠣꠄ, ꠅꠃ ꠝꠣꠛꠥꠖꠦꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ꠛꠤꠀꠘ ꠅꠁꠟꠦꠃ ꠔꠥꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠇꠥꠖꠞꠔꠤ ꠘꠥꠞ ꠖꠦꠈꠛꠣꠄ, ꠔꠣꠁꠘ ꠔ ꠢꠥꠘꠍꠂꠘ, ꠔꠥꠝꠞꠣ ꠇꠤꠔꠣ ꠇꠣꠘꠣ-ꠇꠣꠘꠤ ꠇꠞꠍ। ꠔꠦ ꠀꠝꠞꠣ ꠀꠞ ꠇꠤꠔꠣ ꠎꠦꠘ, ꠔꠥꠝꠞꠣ ꠀꠝꠞꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠅꠔꠔꠣ ꠝꠣꠔꠤꠞꠣꠄ?” ");
INSERT INTO syls_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","ꠝꠥꠍꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠦ ꠢꠣꠁꠘ꠆ꠎꠣ ꠛꠣꠟꠣ ꠔꠥꠝꠞꠣꠞꠦ ꠉꠥꠡ꠆ꠔ ꠖꠤꠛꠣ, ꠀꠞ ꠛꠤꠀꠘꠦ ꠙꠦꠐ ꠜꠞꠣ ꠞꠥꠐꠤꠅ ꠖꠤꠛꠣ। ꠝꠣꠛꠥꠖꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠔꠥꠝꠞꠣ ꠎꠦꠔꠣ ꠇꠣꠘꠣ-ꠇꠣꠘꠤ ꠇꠞꠍ, ꠁꠔꠣ ꠔꠣꠁꠘ ꠢꠥꠘꠍꠂꠘ। ꠀꠍꠟꠦ ꠀꠝꠞꠣ ꠖꠥꠁꠎꠘ ꠇꠤꠔꠣ ꠎꠦꠘ, ꠔꠥꠝꠞꠣ ꠀꠝꠞꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠅꠔꠔꠣ ꠝꠣꠔꠤꠞꠣꠄ? ꠁ ꠝꠣꠔ ꠔ ꠀꠝꠞꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠘꠣꠄ, ꠔꠥꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦꠃ ꠝꠣꠔꠤꠞꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","ꠄꠞꠛꠣꠖꠦ ꠝꠥꠍꠣꠄ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠢꠇ꠆ꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠔꠥꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠎꠦꠔꠣ ꠝꠣꠔꠤꠍ, ꠁꠔꠣ ꠔꠣꠁꠘ ꠢꠥꠘꠍꠂꠘ। ꠅꠈꠘ ꠔꠥꠝꠞꠣ ꠀꠁꠀ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠀꠎꠤꠞ ꠅꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","ꠔꠦꠃ ꠢꠣꠞꠥꠘꠦ ꠔꠣꠞꠣꠞꠦ ꠅꠃ ꠡꠋꠛꠣꠖ ꠎꠣꠘꠣꠁꠞꠣ, ꠅꠃ ꠡꠝꠄ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠛꠣꠄ ꠔꠣꠞꠣꠞ ꠌꠃꠈ ꠙꠠꠔꠦꠃ ꠖꠦꠈꠂꠘ, ꠝꠦꠊꠞ ꠇꠣꠟꠘꠤꠞ ꠝꠣꠎꠦ ꠝꠣꠛꠥꠖꠞ ꠇꠥꠖꠞꠔꠤ ꠘꠥꠞ ꠎꠣꠁꠞ ꠅꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","ꠄꠞꠝꠣꠎꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“ꠀꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠢꠇ꠆ꠇꠟ ꠝꠣꠔ-ꠇꠕꠣ ꠢꠥꠘꠍꠤ। ꠅꠈꠘ ꠔꠥꠝꠤ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠔꠣꠞꠣ ꠙꠞꠔꠦꠇ ꠖꠤꠘ ꠢꠣꠁꠘ꠆ꠎꠣ ꠛꠣꠟꠣ ꠈꠣꠁꠛꠣ ꠉꠥꠡ꠆ꠔ ꠀꠞ ꠛꠤꠀꠘꠦ ꠈꠣꠁꠛꠣ ꠙꠦꠐ ꠜꠞꠣ ꠞꠥꠐꠤ। ꠔꠦꠃ ꠔꠣꠞꠣ ꠛꠥꠎꠛꠣ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠣꠞꠣꠞ ꠝꠣꠛꠥꠖ।” ");
INSERT INTO syls_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","ꠢꠣꠍꠣꠃ ꠢꠣꠁꠘ꠆ꠎꠣ ꠛꠣꠟꠣ ꠇꠥꠄꠟ ꠙꠣꠈꠤꠞ ꠙꠣꠟ ꠀꠁꠀ ꠔꠣꠞꠣꠞ ꠀꠡ꠆ꠔꠣ ꠇꠦꠝ꠆ꠙꠅ ꠎꠣꠝ ꠅꠁꠉꠦꠟ, ꠛꠣꠖꠞ ꠖꠤꠘ ꠛꠤꠀꠘꠦ ꠈꠥꠀ ꠙꠠꠤꠀ ꠇꠦꠝ꠆ꠙꠞ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠜꠤꠎꠤꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","ꠛꠦꠁꠟ ꠅꠀꠞ ꠛꠣꠖꠦ ꠅꠃ ꠈꠥꠀ ꠢꠥꠇꠣꠁꠟꠦ ꠖꠦꠈꠣ ꠉꠦꠟ, ꠡꠣꠉꠥꠞ ꠖꠣꠘꠣꠞ ꠟꠣꠈꠣꠘ ꠄꠇꠎꠣꠔꠞ ꠙꠣꠔꠟꠣ ꠎꠤꠘꠤꠡ ꠝꠣꠐꠤꠞ ꠃꠙꠞꠦ ꠙꠠꠤ ꠞꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ꠁꠔꠣ ꠖꠦꠈꠤꠀ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠄꠇꠦ-ꠅꠁꠘ꠆ꠘꠦ ꠎꠤꠇꠣꠁꠟꠣ, “ꠅꠛꠣ, ꠁꠔꠣ ꠇꠤꠔꠣ? ꠁꠔꠣ ꠇꠤꠔꠣ ꠙꠠꠍꠦ, ꠀꠝꠞꠣ ꠇꠦꠃ ꠔ ꠌꠤꠘꠞꠣꠝ ꠘꠣ।” ꠔꠦꠃ ꠝꠥꠍꠣꠄ ꠇꠁꠟꠣ, “ꠁꠔꠣ ꠔ ꠛꠦꠢꠦꠡ꠆ꠔꠤ ꠈꠣꠘꠤ, ꠔꠥꠝꠞꠣ ꠈꠣꠁꠔꠣꠄ ꠇꠞꠤ ꠝꠣꠛꠥꠖꠦ ꠖꠣꠘ ꠇꠞꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","ꠅꠃ ꠈꠣꠘꠤꠞ ꠇꠕꠣꠃ ꠝꠣꠛꠥꠖꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠂꠘ, ꠙꠞꠔꠦꠇ ꠎꠘꠦ ꠎꠣꠞꠎꠤꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠟꠣꠉꠤ ꠈꠣꠘꠤ ꠔꠥꠇꠣꠁꠀ ꠘꠦꠅ। ꠊꠞꠞ ꠢꠇꠟꠞ ꠟꠣꠉꠤ ꠎꠘ-ꠙꠤꠍꠦ ꠄꠇ ꠙꠦꠐꠥ ꠇꠞꠤ ꠔꠥꠇꠣꠁꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","ꠔꠦꠃ ꠔꠣꠞꠣ ꠅꠃꠟꠣ ꠇꠞꠟꠣ, ꠝꠣꠘꠥꠡ ꠅꠘꠥꠝꠣꠘꠦ ꠇꠦꠃ ꠛꠦꠡ ꠇꠞꠤ ꠘꠤꠟꠣ, ꠇꠦꠃ ꠇꠝ ꠘꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","ꠛꠣꠖꠦ ꠙꠦꠐꠥꠖꠤ ꠝꠣꠙꠤꠀ ꠖꠦꠈꠟꠣ, ꠎꠦꠁꠘ ꠛꠦꠡꠤ ꠔꠥꠇꠣꠁꠍꠟꠣ, ꠔꠣꠘꠅ ꠛꠦꠡꠤ ꠅꠁꠍꠦ ꠘꠣ, ꠀꠞ ꠎꠦꠁꠘ ꠕꠥꠠꠣ ꠔꠥꠇꠣꠁꠍꠟꠣ, ꠔꠣꠘꠅ ꠇꠝ ꠅꠁꠍꠦ ꠘꠣ; ꠢꠇꠟꠦꠃ ꠎꠣꠞꠎꠤꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠈꠣꠘꠤꠞ ꠅꠘꠥꠝꠣꠘꠦ ꠔꠥꠇꠣꠁꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","ꠝꠥꠍꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠇꠣꠁꠟ ꠛꠤꠀꠘꠇꠥꠞ ꠈꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠁꠔꠣ ꠝꠥꠐꠦꠃ ꠎꠝꠣꠁ ꠕꠁꠅ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","ꠔꠣ-ꠅ ꠇꠦꠃ ꠇꠦꠃ ꠝꠥꠍꠣꠞ ꠇꠕꠣ ꠘꠣ ꠝꠣꠘꠤꠀ ꠛꠣꠖꠞ ꠖꠤꠘꠞ ꠟꠣꠉꠤꠅ ꠕꠥꠠꠣ ꠕꠁꠟ। ꠄꠞꠟꠣꠉꠤ ꠁꠔꠣ ꠙꠌꠤꠀ ꠇꠤꠠꠣ-ꠙꠥꠇ ꠎꠘꠝꠤꠀ ꠉꠘ꠆ꠖ ꠛꠣꠞ ꠅꠁꠟ; ꠁꠔꠣ ꠖꠦꠈꠤꠀ ꠝꠥꠍꠣ ꠔꠣꠞꠣꠞ ꠃꠙꠞꠦ ꠈꠥꠛ ꠉꠥꠍꠣ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","ꠅꠟꠣ ꠙꠞꠔꠦꠇ ꠖꠤꠘ ꠚꠎꠞꠦ ꠔꠣꠞꠣ ꠎꠣꠞꠎꠤꠞ ꠈꠣꠘꠤꠞ ꠅꠘꠥꠝꠣꠘꠦ ꠔꠥꠇꠣꠁꠔ, ꠅꠁꠟꠦ ꠞꠂꠖ ꠉꠞꠝ ꠅꠁꠟꠦꠃ ꠁꠔꠣ ꠉꠟꠤꠎꠤꠔ। ");
INSERT INTO syls_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ꠛꠣꠖꠦ ꠍꠄ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘꠅ ꠔꠣꠞꠣꠞ ꠈꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠒꠣꠛꠥꠟ ꠈꠣꠘꠤ, ꠝꠣꠘꠤ ꠖꠥꠁ ꠙꠦꠐꠥ ꠇꠞꠤ ꠔꠥꠇꠣꠁꠟ, ꠀꠞ ꠉꠥꠡ꠆ꠐꠤꠞ ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟꠦ ꠀꠁꠀ ꠝꠥꠍꠣꠞꠦ ꠎꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","ꠝꠥꠍꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠁꠔꠣ ꠑꠤꠇ ꠀꠍꠦ, ꠝꠣꠛꠥꠖꠦꠃ ꠅꠃꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠂꠘ; ꠇꠣꠁꠟ ꠔ ꠢꠣꠙ꠆ꠔꠣꠞ ꠡꠦꠡ ꠖꠤꠘ, ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞ; ꠝꠣꠛꠥꠖꠞ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠖꠤꠘ। ꠔꠦ ꠔꠥꠝꠞꠣꠞ ꠎꠦꠔꠣ ꠞꠣꠘ꠆ꠖꠣꠞ ꠖꠞꠇꠣꠞ ꠀꠍꠦ ꠁꠔꠣ ꠀꠁꠎ ꠞꠣꠘ꠆ꠖꠤꠟꠣꠅ, ꠀꠞ ꠛꠤꠞꠣꠘ ꠇꠞꠣꠞ ꠎꠞꠥꠞ ꠅꠁꠟꠦ ꠛꠤꠞꠣꠘ ꠇꠞꠅ, ꠛꠣꠇꠤ ꠢꠇꠟꠔꠣ ꠛꠣꠖꠞ ꠖꠤꠘ ꠛꠤꠀꠘꠇꠥꠞ ꠟꠣꠉꠤ ꠕꠁ ꠖꠦꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","ꠅꠃ ꠝꠥꠍꠣꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠔꠣꠞꠣ ꠛꠣꠖꠞ ꠖꠤꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠁꠔꠣ ꠊꠞꠅ ꠕꠁꠟ, ꠁꠔꠣꠞ ꠝꠣꠎꠦ ꠇꠥꠘꠥ ꠉꠘ꠆ꠖꠅ ꠛꠣꠞ ꠅꠁꠟ ꠘꠣ, ꠇꠤꠠꠣꠄꠅ ꠗꠞꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","ꠛꠣꠖꠦ ꠝꠥꠍꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠀꠁꠎ ꠔꠥꠝꠞꠣ ꠁꠔꠣ ꠈꠣꠅ, ꠇꠣꠞꠘ ꠀꠁꠎ ꠝꠣꠛꠥꠖꠞ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠖꠤꠘ, ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞ। ꠀꠁꠎ ꠔꠥꠝꠞꠣ ꠛꠘ꠆ꠖꠞ ꠝꠣꠎꠦ ꠁ ꠈꠣꠘꠤ ꠙꠣꠁꠔꠣꠄ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ꠔꠥꠝꠞꠣ ꠢꠣꠙ꠆ꠔꠣꠔ ꠍꠄ ꠖꠤꠘ ꠁ ꠈꠣꠘꠤ ꠔꠥꠇꠣꠁꠅ, ꠅꠁꠟꠦ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠔ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞ, ꠁ ꠖꠤꠘ ꠁꠔꠣ ꠙꠣꠁꠔꠣꠄ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ꠔꠣ-ꠅ ꠇꠥꠘꠥ ꠇꠥꠘꠥ ꠎꠘꠦ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘꠅ ꠅꠃ ꠈꠣꠘꠤ ꠔꠥꠇꠣꠁꠛꠣꠞ ꠟꠣꠉꠤ ꠛꠣꠞꠦ ꠉꠦꠟ, ꠉꠤꠀ ꠇꠥꠘ꠆ꠔꠣ ꠙꠣꠁꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","ꠔꠦꠃ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠀꠞ ꠇꠔꠖꠤꠘ ꠀꠝꠣꠞ ꠢꠥꠇꠥꠝ ꠀꠞ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠜꠣꠋꠉꠤꠔꠣꠄ? ");
INSERT INTO syls_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","ꠢꠥꠘꠅ, ꠔꠥꠝꠞꠣꠞ ꠎꠤꠞꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠁ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞ ꠔ ꠝꠣꠛꠥꠖꠦꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠤꠍꠂꠘ, ꠄꠞꠟꠣꠉꠤ ꠔꠣꠁꠘ ꠢꠣꠙ꠆ꠔꠣꠞ ꠍꠄ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘꠅ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠥꠁ ꠖꠤꠘꠞ ꠈꠣꠘꠤ ꠖꠦꠁꠘ; ꠅꠈꠘ ꠕꠣꠇꠤ ꠅꠃ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ, ꠝꠣꠘꠤ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞꠦ ꠔꠥꠝꠞꠣ ꠢꠇꠟꠦ ꠎꠣꠞꠎꠤꠞ ꠊꠞꠅ ꠞꠁꠀ ꠎꠤꠞꠣꠁꠅ, ꠇꠦꠃ ꠊꠞꠞ ꠛꠣꠞꠦ ꠎꠣꠁꠅ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","ꠄꠞꠛꠣꠖ ꠕꠣꠇꠤ ꠢꠣꠙ꠆ꠔꠣꠞ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘꠅ ꠝꠣꠘꠡꠦ ꠎꠤꠞꠣꠁꠔ। ");
INSERT INTO syls_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠁ ꠈꠣꠘꠤꠞ ꠘꠣꠝ ꠕꠁꠟ, ꠝꠣꠘ꠆ꠘꠣ; ꠁꠔꠣ ꠖꠦꠈꠔꠦ ꠗꠟꠣ ꠒꠥꠟꠣ ꠛꠤꠌꠤꠞ ꠟꠣꠈꠣꠘ, ꠀꠞ ꠈꠣꠁꠔꠦ ꠝꠃ ꠝꠣꠈꠣꠁꠟ ꠙꠤꠑꠣꠞ ꠟꠣꠈꠣꠘ ꠝꠎꠣ। ");
INSERT INTO syls_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","ꠛꠣꠖꠦ ꠝꠥꠍꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠦ ꠅꠃ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠂꠘ, ꠔꠥꠝꠞꠣ ꠄꠇ ꠙꠦꠐꠥ ꠙꠞꠤꠝꠣꠘ ꠝꠣꠘ꠆ꠘꠣ ꠔꠥꠟꠤꠀ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠖꠞ ꠛꠋꠡꠗꠞ ꠅꠇꠟꠞ ꠟꠣꠉꠤ ꠎꠝꠣ ꠇꠞꠤ ꠕꠅ, ꠔꠦꠃ ꠔꠣꠞꠣꠅ ꠖꠦꠈꠛꠣ, ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠛꠣꠞ ꠇꠞꠤ ꠘꠦꠅꠀꠞ ꠇꠣꠟꠅ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠝꠣꠎꠦ ꠔꠣꠁꠘ ꠇꠤꠔꠣ ꠈꠣꠅꠀꠁꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","ꠝꠥꠍꠣꠄ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠄꠉꠥ ꠛꠂꠀꠝꠞ ꠝꠣꠎꠦ ꠄꠇ ꠙꠦꠐꠥ ꠙꠞꠤꠝꠣꠘ ꠝꠣꠘ꠆ꠘꠣ ꠔꠥꠟꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠕꠅ, ꠁꠔꠣ ꠔꠥꠝꠞꠣꠞ ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠎꠝꠣ ꠞꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠇꠞꠍꠟꠣ, ꠅꠃ ꠟꠣꠈꠣꠘ ꠢꠣꠞꠥꠘꠦ ꠅꠃ ꠝꠣꠘ꠆ꠘꠣ ꠛꠂꠀꠝꠅ ꠜꠞꠟꠣ। ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠙꠛꠤꠔ꠆ꠞ ꠡꠘ꠆ꠖꠥꠇꠞ ꠜꠤꠔꠞꠦ ꠡꠣꠢꠣꠖꠔ ꠙꠣꠔ꠆ꠔꠞꠞ ꠍꠣꠝꠘꠦ ꠕꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠌꠣꠟ꠆ꠟꠤꠡ ꠛꠞꠍ ꠗꠞꠤ ꠁ ꠝꠣꠘ꠆ꠘꠣ ꠈꠣꠁꠟ, ꠔꠣꠞꠣ ꠎꠔꠖꠤꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠝꠣꠘꠥꠡ ꠛꠡꠔ ꠇꠞꠣꠞ ꠎꠣꠉꠣ, ꠝꠣꠘꠤ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠞ ꠡꠤꠝꠣꠘꠣꠔ ꠀꠁꠀ ꠘꠣ ꠙꠃꠍꠤꠟ, ꠅꠔꠖꠤꠘ ꠅꠃ ꠈꠣꠘꠤꠃ ꠈꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","ꠄꠇ ꠙꠦꠐꠥ ꠅꠁꠟꠉꠤ, ꠄꠇ ꠚꠥꠞꠣꠞꠞ ꠖꠡ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ। ");
INSERT INTO syls_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝꠦ ꠔꠣꠝꠣꠝ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠍꠤꠘ ꠝꠞꠥꠜꠥꠝꠤ ꠕꠣꠇꠤ ꠞꠅꠀꠘꠣ ꠖꠤꠀ, ꠄꠇ ꠎꠣꠉꠣ ꠕꠣꠇꠤ ꠀꠞꠇ ꠎꠣꠉꠣꠔ ꠉꠤꠀ ꠉꠤꠀ ꠢꠦꠡꠦ ꠞꠚꠤꠖꠤꠝꠅ ꠀꠁꠀ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠟꠣ, ꠅꠁꠟꠦ ꠢꠤꠘꠅ ꠝꠣꠘꠡꠞ ꠈꠣꠅꠀꠞ ꠙꠣꠘꠤ ꠀꠍꠤꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","ꠄꠞꠟꠣꠉꠤ ꠝꠣꠘꠡꠦ ꠝꠥꠍꠣꠞ ꠟꠉꠦ ꠇꠣꠁꠎ꠆ꠎꠣ ꠇꠞꠤ ꠇꠁꠟꠣ, “ꠀꠝꠞꠣꠞꠦ ꠈꠣꠅꠀꠞ ꠙꠣꠘꠤ ꠖꠦꠃꠇ꠆ꠇꠣ।” ꠝꠥꠍꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠇꠦꠘꠦ ꠀꠝꠣꠞ ꠟꠉꠦ ꠇꠣꠁꠎ꠆ꠎꠣ ꠇꠞꠞꠣꠄ? ꠇꠦꠘꠦ ꠝꠣꠛꠥꠖꠞꠦ ꠙꠞꠤꠇ꠆ꠇꠣ ꠇꠞꠞꠣꠄ?” ");
INSERT INTO syls_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","ꠝꠣꠘꠡꠦ ꠙꠣꠘꠤꠞ ꠙꠤꠀꠍꠦ ꠇꠣꠢꠤꠟ ꠅꠁꠀ ꠝꠥꠍꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠉꠣꠟꠤ-ꠉꠣꠟꠣꠎ ꠇꠞꠤ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠀꠝꠞꠣꠞꠦ ꠝꠣꠞꠔꠣꠄ ꠇꠞꠤ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠀꠘꠍ ꠘꠤ? ꠀꠝꠞꠣꠞꠦ, ꠀꠝꠞꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ꠆ꠔꠞꠦ, ꠀꠝꠞꠣꠞ ꠙꠡꠥꠞ ꠙꠣꠟꠞꠦ ꠀꠘꠣ-ꠙꠣꠘꠤꠄ ꠝꠣꠞꠔꠣꠄ ꠇꠞꠤ ꠅꠘꠅ ꠀꠘꠍ ꠘꠤ?” ");
INSERT INTO syls_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","ꠔꠦꠃ ꠝꠥꠍꠣꠄ ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍꠦ ꠚꠞꠤꠀꠖ ꠇꠞꠤ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠁ ꠝꠣꠘꠡꠞꠦ ꠇꠤꠔꠣ ꠇꠞꠔꠣꠝ? ꠀꠞ ꠕꠥꠠꠣ ꠖꠦꠞꠤ ꠅꠁꠟꠦꠃ ꠔ ꠔꠣꠞꠣ ꠙꠣꠔ꠆ꠔꠞꠖꠤ ꠁꠐꠣꠁꠀ ꠀꠝꠣꠞꠦ ꠝꠣꠞꠤꠟꠤꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","ꠝꠣꠛꠥꠖꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠔꠥꠝꠤ ꠎꠦ ꠟꠣꠑꠤꠖꠤ ꠘꠤꠟ ꠘꠖꠅ ꠛꠣꠠꠤ ꠝꠣꠞꠍꠟꠣꠄ, ꠢꠃ ꠟꠣꠑꠤ ꠀꠔꠅ ꠟꠅ, ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠇꠄꠎꠘ ꠝꠥꠞꠛ꠆ꠛꠤꠞꠦ ꠟꠉꠦ ꠟꠁꠀ ꠝꠣꠘꠡꠞ ꠀꠉꠦ ꠀꠉꠦ ꠎꠣꠅ। ");
INSERT INTO syls_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","ꠉꠤꠀ ꠢꠣꠞꠟꠦ ꠀꠝꠤ ꠔꠥꠞ ꠙꠣꠠꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠄꠇ ꠙꠣꠔ꠆ꠔꠞꠞ ꠃꠙꠞꠦ ꠀꠎꠤꠞ ꠅꠁꠝꠥ, ꠔꠥꠝꠤ ꠅꠃ ꠙꠣꠔ꠆ꠔꠞꠅ ꠛꠣꠠꠤ ꠝꠣꠞꠟꠦ ꠅꠉꠥ ꠕꠣꠇꠤ ꠙꠣꠘꠤ ꠛꠣꠞ ꠅꠁꠛ, ꠔꠦꠃ ꠝꠣꠘꠡꠦ ꠈꠣꠁꠔꠣ ꠙꠣꠞꠛꠣ।” ꠢꠣꠍꠣꠃ ꠝꠥꠍꠣꠄ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟꠞ ꠍꠣꠝꠘꠦ ꠅꠃꠟꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","ꠅꠃ ꠞꠚꠤꠖꠤꠝꠅ ꠀꠁꠀ ꠝꠣꠘꠡꠦ ꠇꠣꠁꠎ꠆ꠎꠣ ꠇꠞꠤ ꠇꠁꠍꠟꠣ, “ꠝꠣꠛꠥꠖ ꠇꠤꠔꠣ ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠀꠍꠂꠘ ꠘꠤ, ꠘꠣ ꠢꠞꠤ ꠉꠦꠍꠂꠘ?” ꠅꠃꠟꠣ ꠇꠁꠀ ꠔꠣꠞꠣ ꠝꠣꠛꠥꠖꠞꠦ ꠙꠞꠤꠇ꠆ꠇꠣ ꠇꠞꠍꠟꠣ ꠇꠞꠤ, ꠁ ꠎꠣꠉꠣꠞ ꠘꠣꠝ ꠅꠁꠟ ꠝꠣꠍꠣ ꠝꠣꠘꠤ, ꠙꠞꠤꠇ꠆ꠇꠣ ꠀꠞ ꠝꠦꠞꠤꠛꠣ ꠝꠣꠘꠤ, ꠇꠣꠁꠎ꠆ꠎꠣ। ");
INSERT INTO syls_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","ꠅꠃ ꠡꠝꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠉꠦ ꠎꠥꠖ꠆ꠖ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠀꠝꠣꠟꠦꠇꠤ ꠍꠤꠙꠣꠁ ꠅꠇꠟ ꠞꠚꠤꠖꠤꠝꠅ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","ꠔꠦꠃ ꠝꠥꠍꠣꠄ ꠔꠣꠘ ꠈꠣꠖꠤꠝ ꠢꠎꠞꠔ ꠁꠃꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠀꠝꠞꠣꠞ ꠝꠣꠘꠥꠡ ꠕꠣꠇꠤ ꠟꠣꠠꠣꠁ ꠇꠞꠞꠣ ꠎꠘ ꠛꠣꠍꠤꠀ ꠘꠤꠀ, ꠀꠝꠣꠟꠦꠇꠤ ꠅꠇꠟꠞ ꠟꠉꠦ ꠎꠥꠖ꠆ꠖ ꠇꠞꠣꠔ ꠎꠣꠅ। ꠀꠝꠤꠅ ꠇꠣꠁꠟ ꠀꠟ꠆ꠟꠣꠁ ꠇꠥꠖꠞꠔꠤ ꠟꠣꠑꠤ ꠀꠔꠅ ꠟꠁꠀ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠃꠛꠣꠁꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","ꠁꠃꠍꠣꠄꠅ ꠝꠥꠍꠣꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠇꠣꠝ ꠇꠞꠟꠣ। ꠀꠝꠣꠟꠦꠇꠤ ꠅꠇꠟꠞ ꠟꠉꠦ ꠎꠥꠖ꠆ꠖ ꠇꠞꠟꠣ, ꠝꠥꠍꠣ, ꠢꠣꠞꠥꠘ, ꠀꠞ ꠢꠥꠞ, ꠅꠃ ꠔꠤꠘꠅ ꠎꠘ ꠉꠤꠀ ꠙꠣꠠꠞ ꠐꠤꠟ꠆ꠟꠣꠞ ꠃꠙꠞꠦ ꠃꠑꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","ꠛꠣꠖꠦ ꠖꠦꠈꠣ ꠉꠦꠟ, ꠝꠥꠍꠣꠄ ꠎꠔ ꠡꠝꠄ ꠀꠔ ꠃꠌꠣ ꠇꠞꠤ ꠞꠣꠈꠂꠘ, ꠅꠔ ꠡꠝꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠖꠟ ꠎꠤꠔꠂꠘ, ꠅꠁꠟꠦ ꠝꠥꠍꠣꠄ ꠀꠔ ꠟꠣꠝꠣꠁꠟꠦꠃ ꠀꠝꠣꠟꠦꠇꠤ ꠖꠟ ꠎꠤꠔꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","ꠀꠡ꠆ꠔꠦ ꠀꠡ꠆ꠔꠦ ꠝꠥꠍꠣꠞ ꠀꠔ ꠜꠣꠞ ꠅꠀ ꠗꠞꠟ। ꠅꠃ ꠔꠣꠞꠣ ꠄꠇꠈꠣꠘ ꠙꠣꠔ꠆ꠔꠞ ꠀꠘꠤꠀ ꠝꠥꠍꠣꠞꠦ ꠛꠁꠛꠣꠞ ꠛꠦꠛꠡ꠆ꠔꠣ ꠖꠤꠟꠣ। ꠅꠃ ꠙꠣꠔ꠆ꠔꠞꠞ ꠃꠙꠞꠦ ꠝꠥꠍꠣ ꠛꠁꠟꠣ, ꠢꠣꠞꠥꠘ ꠀꠞ ꠢꠥꠞ ꠖꠥꠁꠅꠎꠘꠦ ꠝꠥꠍꠣꠞ ꠖꠥꠁ ꠉꠣꠟꠣꠔ ꠃꠛꠣꠁꠀ ꠔꠣꠘ ꠀꠔ ꠃꠌꠣ ꠇꠞꠤ ꠗꠞꠟꠣ। ꠔꠦꠃ ꠡꠥꠞꠥꠎ ꠒꠥꠛꠣꠞ ꠀꠉ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠔꠣꠘ ꠀꠔ ꠃꠌꠣ ꠞꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","ꠄꠞꠟꠣꠉꠤ ꠀꠝꠣꠟꠦꠇꠤ ꠍꠤꠙꠣꠁꠞ ꠟꠉꠦ ꠎꠥꠖ꠆ꠖ ꠇꠞꠤꠀ ꠁꠃꠍꠣ ꠎꠤꠔꠤꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠁꠔꠣ ꠁꠀꠖ ꠞꠣꠈꠣꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠤ ꠄꠇꠈꠣꠘ ꠇꠤꠔꠣꠛꠞ ꠝꠣꠎꠦ ꠟꠦꠈꠤꠀ ꠕꠅ ꠀꠞ ꠁꠃꠍꠣꠞꠦꠅ ꠎꠣꠘꠣꠅ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠀꠝꠤ ꠖꠥꠘꠤꠀꠞ ꠛꠥꠇ ꠕꠣꠇꠤ ꠀꠝꠣꠟꠦꠇꠤ ꠅꠇꠟꠞ ꠘꠣꠝ ꠝꠤꠐꠣꠁꠟꠤꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","ꠝꠥꠍꠣꠄ ꠄꠇꠈꠣꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠁꠀ ꠄꠞ ꠘꠣꠝ ꠕꠁꠟꠣ, ꠝꠣꠛꠥꠖꠃ ꠀꠝꠣꠞ ꠎꠥꠖ꠆ꠖꠞ ꠏꠣꠘ꠆ꠒꠣ। ");
INSERT INTO syls_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠞ ꠎꠥꠖ꠆ꠖꠞ ꠏꠣꠘ꠆ꠒꠣ ꠀꠝꠞꠣ ꠀꠔꠅ ꠟꠁ, ꠔꠦꠃ ꠝꠣꠛꠥꠖꠦꠅ ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠀꠝꠣꠟꠦꠇꠤ ꠅꠇꠟꠞ ꠟꠉꠦ ꠎꠥꠖ꠆ꠖ ꠇꠞꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","ꠀꠟ꠆ꠟꠣꠄ ꠢꠎꠞꠔ ꠝꠥꠍꠣꠞꠦ ꠀꠞ ꠔꠣꠘ ꠛꠘ꠆ꠖꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠔ ꠟꠣꠈꠣꠘ ꠞꠢꠝ ꠇꠞꠍꠂꠘ, ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠝꠥꠍꠣꠞ ꠢꠃꠞ ꠝꠣꠖꠤꠀꠘ ꠖꠦꠡꠞ ꠁꠝꠣꠝ ꠡꠥꠀꠁꠛꠞ ꠇꠣꠘꠅ ꠉꠦꠟ। ꠝꠣꠛꠥꠖꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠇꠤꠟꠣ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠍꠂꠘ, ꠄꠅꠔꠣ ꠔꠣꠁꠘ ꠢꠥꠘꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","ꠝꠥꠍꠣꠄ ꠀꠉꠦ ꠔꠣꠘ ꠛꠤꠛꠤ ꠍꠚꠥꠞꠣꠞꠦ ꠢꠃꠞ ꠛꠣꠠꠤꠔ ꠙꠣꠑꠣꠁ ꠖꠤꠍꠟꠣ, ꠄꠞꠟꠣꠉꠤ ꠔꠣꠘ ꠢꠃꠞꠦ ꠝꠥꠍꠣꠞ ꠛꠤꠛꠤꠞꠦ ꠀꠞ ꠖꠥꠁꠅ ꠙꠥꠀꠞꠦ ꠘꠤꠎꠞ ꠉꠦꠍꠦ ꠞꠣꠈꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ꠁ ꠖꠥꠁꠅ ꠙꠥꠀꠞ ꠝꠣꠎꠞ ꠄꠇꠎꠘꠞ ꠘꠣꠝ ꠀꠍꠤꠟ ꠎꠣꠞꠍꠥꠝ ꠝꠣꠘꠤ, ꠛꠂꠔꠟ। ꠝꠥꠍꠣꠄ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠜꠤꠘ ꠖꠦꠡꠅ ꠛꠂꠔꠟꠞ ꠟꠣꠈꠣꠘ ꠞꠁꠞꠣꠝ।” ");
INSERT INTO syls_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","ꠀꠞ ꠖꠥꠍꠞꠣ ꠎꠘꠞ ꠘꠣꠝ ꠀꠍꠤꠟ ꠄꠟꠤꠄꠎꠦꠞ ꠝꠣꠘꠤ, ꠀꠟ꠆ꠟꠣ ꠡꠢꠣꠄ। ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠛꠣꠚꠞ ꠀꠟ꠆ꠟꠣ ꠀꠝꠣꠞ ꠡꠢꠣꠄ ꠅꠁꠀ ꠀꠝꠣꠞꠦ ꠚꠦꠞꠣꠃꠘꠞ ꠔꠟꠥꠀꠞ ꠕꠣꠇꠤ ꠢꠦꠚꠣꠎꠔ ꠇꠞꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","ꠝꠥꠍꠣꠞ ꠢꠃꠞ ꠡꠥꠀꠁꠛꠦ ꠝꠥꠍꠣꠞ ꠛꠤꠛꠤ ꠀꠞ ꠔꠣꠘ ꠖꠥꠁꠅ ꠙꠥꠀꠞꠦ ꠟꠁꠀ ꠝꠥꠍꠣꠞ ꠉꠦꠍꠦ ꠀꠁꠟꠣ। ꠅꠃ ꠡꠝꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠀꠞ ꠝꠥꠍꠣꠞ ꠔꠣꠝ꠆ꠛꠥ ꠀꠍꠤꠟ ꠀꠟ꠆ꠟꠣꠞ ꠙꠣꠠ ꠔꠥꠞꠞ ꠇꠣꠘ꠆ꠖꠣꠔ। ");
INSERT INTO syls_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","ꠔꠣꠘ ꠢꠃꠞ ꠅꠘꠅ ꠀꠁꠀ ꠝꠥꠍꠣꠞꠦ ꠈꠛꠞ ꠖꠤꠟꠣ, “ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠢꠃꠞ ꠡꠥꠀꠁꠛ। ꠔꠦ ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠛꠤꠛꠤ ꠀꠞ ꠖꠥꠁꠅ ꠙꠥꠀꠞꠦ ꠟꠁꠀ ꠅꠘꠅ ꠀꠁꠍꠤ।” ");
INSERT INTO syls_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","ꠈꠛꠞ ꠙꠣꠁꠀ ꠝꠥꠍꠣꠄ ꠔꠣꠘ ꠢꠃꠞꠞ ꠟꠉꠦ ꠖꠦꠈꠣ ꠇꠞꠣꠔ ꠛꠣꠞ ꠅꠁꠟꠣ। ꠔꠣꠁꠘ ꠝꠣꠐꠤꠔ ꠍꠁꠎꠖꠣ ꠇꠞꠤꠀ ꠔꠣꠘ ꠢꠃꠞꠞꠦ ꠍꠣꠟꠣꠝ ꠇꠞꠟꠣ ꠀꠞ ꠝꠣꠄꠀꠞ ꠢꠥꠋꠉꠣ ꠖꠤꠟꠣ। ꠛꠣꠖꠦ ꠖꠥꠁꠅꠎꠘꠦ ꠜꠣꠟꠣ-ꠛꠥꠞꠣ ꠎꠤꠇꠣꠁꠀ ꠢꠣꠞꠤ ꠔꠣꠝ꠆ꠛꠥꠞ ꠜꠤꠔꠞꠦ ꠢꠣꠝꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","ꠝꠣꠛꠥꠖꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠙꠇ꠆ꠇ ꠟꠁꠀ ꠚꠦꠞꠣꠃꠘ ꠀꠞ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠟꠉꠦ ꠎꠦꠔꠣ ꠎꠦꠔꠣ ꠇꠞꠍꠂꠘ, ꠁꠔꠣ ꠢꠇ꠆ꠇꠟꠔꠣ ꠔꠣꠘ ꠢꠃꠞꠞꠦ ꠢꠥꠘꠣꠁꠟꠣ। ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠎꠣꠅꠀꠞ ꠛꠣꠟꠣ ꠔꠣꠞꠣꠞ ꠇꠔ ꠇꠡ꠆ꠐ ꠅꠁꠍꠤꠟ ꠀꠞ ꠀꠟ꠆ꠟꠣꠄ ꠇꠤꠟꠣ ꠔꠣꠞꠣꠞꠦ ꠛꠣꠌꠣꠁꠍꠂꠘ ꠄꠅꠔꠣꠅ ꠔꠣꠘꠞꠦ ꠎꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠀꠔ ꠕꠣꠇꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠀꠎꠣꠖ ꠇꠞꠤꠀ ꠔꠣꠞꠣꠞꠦ ꠎꠔ ꠟꠣꠈꠣꠘ ꠀꠍꠣꠘ ꠇꠞꠍꠂꠘ, ꠁꠔꠣ ꠢꠥꠘꠤꠀ ꠔꠣꠘ ꠢꠃꠞ ꠈꠥꠛ ꠈꠥꠡꠤ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠢꠇꠟ ꠔꠣꠞꠤꠚ ꠝꠣꠛꠥꠖꠞ, ꠎꠦꠁꠘ ꠚꠦꠞꠣꠃꠘ ꠀꠞ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠀꠔ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠀꠎꠣꠖ ꠇꠞꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","ꠅꠈꠘ ꠀꠝꠤ ꠘꠤꠎꠦꠅ ꠛꠥꠎꠤꠀꠞ, ꠢꠇꠟ ꠖꠦꠛꠔꠣꠞ ꠌꠣꠁꠔꠦ ꠀꠟ꠆ꠟꠣꠃ ꠝꠢꠣꠘ। ꠇꠣꠞꠘ ꠝꠤꠡꠞꠤꠘ꠆ꠔꠦ ꠎꠦꠔꠣ ꠛꠦꠙꠣꠞ ꠟꠁꠀ ꠔꠥꠝꠞꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠛꠣꠢꠣꠖꠥꠞꠤ ꠇꠞꠔꠣ, ꠁꠔꠣꠞ ꠇꠛꠎꠣ ꠕꠣꠇꠤ ꠔꠣꠁꠘꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠛꠣꠌꠣꠁꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","ꠛꠣꠖꠦ ꠝꠥꠍꠣꠞ ꠢꠃꠞ ꠡꠥꠀꠁꠛꠦ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠦ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠞ ꠢꠇꠟ ꠎꠣꠔꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠎꠥꠁꠔ ꠇꠞꠤ ꠟꠁꠀ ꠀꠁꠟꠣ। ꠢꠦꠡꠦ ꠢꠣꠞꠥꠘ ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟ ꠀꠁꠀ, ꠝꠥꠍꠣꠞ ꠢꠃꠞꠞ ꠟꠉꠦ ꠛꠁꠀ ꠀꠟ꠆ꠟꠣꠞ ꠍꠣꠝꠘꠦ ꠈꠣꠘꠣ-ꠙꠤꠘꠣ ꠈꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","ꠛꠣꠖꠞ ꠖꠤꠘ ꠝꠥꠍꠣꠄ ꠝꠣꠘꠡꠞ ꠛꠤꠌꠣꠞ-ꠡꠣꠟꠤꠡ ꠇꠞꠣꠔ ꠛꠁꠟꠣ। ꠛꠤꠌꠣꠞꠞ ꠟꠣꠉꠤ ꠝꠣꠘꠥꠡ ꠀꠁꠀ ꠛꠤꠀꠘ ꠕꠣꠇꠤ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠣꠞꠣꠖꠤꠘ ꠔꠣꠘ ꠍꠣꠝꠘꠦ ꠃꠛꠣꠁ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","ꠝꠥꠍꠣꠄ ꠅꠟꠣ ꠇꠞꠞꠣ ꠖꠦꠈꠤꠀ ꠔꠣꠘ ꠢꠃꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠝꠣꠘꠡꠞꠦ ꠟꠁꠀ ꠁꠔꠣ ꠇꠤꠔꠣ ꠇꠞꠞꠣꠄ? ꠇꠤꠔꠣꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠤ ꠄꠇꠟꠣ ꠅꠘꠅ ꠛꠤꠌꠣꠞꠅ ꠛꠁꠍ, ꠀꠞ ꠛꠤꠀꠘ ꠕꠣꠇꠤ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠇꠟ ꠝꠣꠘꠥꠡ ꠔꠥꠝꠣꠞ ꠉꠦꠍꠦ ꠃꠛꠣꠁ ꠞꠁꠍꠦ?” ");
INSERT INTO syls_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","ꠝꠥꠍꠣꠄ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠛꠤꠌꠣꠞꠞ ꠛꠦꠙꠣꠞꠦ ꠀꠟ꠆ꠟꠣꠞ ꠚꠄꠍꠣꠟꠣ ꠢꠥꠘꠣꠞ ꠟꠣꠉꠤ ꠝꠣꠘꠥꠡ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠀꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","ꠔꠣꠞꠣ ꠇꠥꠘꠥ ꠇꠣꠁꠎ꠆ꠎꠣ-ꠚꠍꠣꠖ ꠇꠞꠟꠦ ꠀꠝꠣꠞ ꠇꠣꠍꠣꠔ ꠀꠁꠘ, ꠀꠁꠟꠦ ꠀꠝꠤ ꠖꠥꠁꠅ ꠖꠟꠞ ꠛꠤꠌꠣꠞ ꠇꠞꠤ, ꠀꠞ ꠀꠟ꠆ꠟꠣꠞ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠔꠣꠞꠣꠞꠦ ꠛꠣꠔꠣꠁ।” ");
INSERT INTO syls_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","ꠔꠦꠃ ꠝꠥꠍꠣꠞ ꠢꠃꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠎꠦꠟꠣꠈꠣꠘ ꠁꠔꠣ ꠇꠞꠞꠣꠄ, ꠁꠔꠣ ꠔ ꠜꠣꠟꠣ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","ꠁꠟꠣ ꠇꠞꠟꠦ ꠔꠥꠝꠤ ꠀꠞ ꠔꠥꠝꠣꠞ ꠢꠇꠟ ꠝꠣꠘꠥꠡꠅ ꠇꠣꠢꠤꠟ ꠅꠁꠎꠤꠛꠣꠄ। ꠁ ꠇꠣꠝ ꠔꠥꠝꠣꠞ ꠔꠣꠇ꠆ꠇꠔ ꠕꠣꠇꠤ ꠛꠦꠡꠤ, ꠔꠥꠝꠤ ꠄꠇꠟꠣ ꠁꠔꠣ ꠇꠥꠟꠣꠁꠔꠣꠄ ꠙꠣꠞꠔꠣꠄ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","ꠔꠦ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠇꠁꠀꠞ, ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠙꠞꠣꠝꠤꠡ ꠢꠥꠘꠅ, ꠄꠔꠦ ꠀꠟ꠆ꠟꠣꠅ ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠞꠁꠛꠣ। ꠔꠥꠝꠤ ꠝꠣꠘꠡꠞ ꠛꠤꠌꠣꠞ-ꠀꠌꠣꠞ ꠚꠄꠍꠣꠟꠣ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ, ꠔꠣꠞꠣꠞ ꠁꠝꠣꠝ ꠢꠤꠡꠣꠛꠦ ꠢꠇꠟ ꠛꠦꠙꠣꠞ ꠀꠟ꠆ꠟꠣꠞ ꠍꠣꠝꠘꠦ ꠀꠎꠤꠞ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","ꠀꠞ ꠝꠣꠘꠡꠞꠦꠅ ꠀꠟ꠆ꠟꠣꠞ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠔꠣꠟꠤꠝ ꠖꠤꠅ। ꠔꠣꠞꠣ ꠇꠤꠟꠣ ꠌꠟꠔꠣ, ꠇꠤꠔꠣ ꠇꠞꠔꠣ ꠘꠣ ꠇꠞꠔꠣ, ꠅꠔꠣ ꠔꠣꠞꠣꠞꠦ ꠛꠥꠎꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","ꠀꠞ ꠔꠥꠝꠤ ꠄꠞꠣꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠛꠣꠍꠤꠀ ꠅꠃꠟꠣ ꠎꠁꠉ꠆ꠉ ꠝꠣꠘꠥꠡ ꠛꠣꠞ ꠇꠞꠅ, ꠎꠦꠞꠣ ꠀꠟ꠆ꠟꠣꠞꠦ ꠒꠞꠣꠁꠘ, ꠢꠇ ꠙꠕꠦ ꠌꠟꠂꠘ, ꠀꠞ ꠊꠥꠡ ꠈꠣꠅꠀꠞꠦ ꠊꠤꠘ ꠇꠞꠂꠘ। ꠄꠞꠣꠞꠦ ꠔꠥꠝꠤ ꠝꠣꠘꠡꠞ ꠛꠤꠌꠣꠞ-ꠀꠌꠣꠞꠞ ꠖꠣꠄꠁꠔ꠆ꠔ ꠖꠦꠅ। ꠄꠞꠣ ꠇꠥꠘꠥ ꠎꠘꠞꠦ ꠀꠎꠣꠞ ꠎꠘꠞ ꠃꠙꠞꠦ, ꠇꠦꠃꠞꠞꠦ ꠡ ꠎꠘ, ꠇꠦꠃꠞꠞꠦ ꠙꠁꠘ꠆ꠌꠣꠡ ꠎꠘ, ꠀꠞ ꠇꠦꠃꠞꠞꠦ ꠖꠡ ꠎꠘꠞ ꠃꠙꠞꠦ ꠛꠤꠌꠣꠞ-ꠀꠌꠣꠞꠞ ꠜꠣꠞ ꠖꠦꠅ। ");
INSERT INTO syls_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","ꠄꠞꠣꠃ ꠢꠣꠝꠦꠡꠣ ꠝꠣꠘꠡꠞ ꠛꠤꠌꠣꠞ-ꠁꠘꠍꠣꠚ ꠇꠞꠛꠣ। ꠢꠥꠞꠥ-ꠝꠥꠞꠥ ꠢꠇꠟ ꠛꠤꠌꠣꠞ ꠔꠣꠞꠣ ꠇꠞꠛꠣ, ꠈꠣꠟꠤ ꠛꠠ ꠛꠠ ꠛꠤꠌꠣꠞ ꠔꠥꠝꠣꠞ ꠉꠦꠍꠦ ꠀꠘꠛꠣ। ꠔꠦꠃ ꠔꠥꠝꠣꠞ ꠜꠣꠞ ꠇꠤꠍꠥ ꠇꠝꠛ, ꠔꠣꠞꠣꠅ ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠇꠤꠍꠥ ꠜꠣꠞ ꠛꠃꠇ꠆ꠇꠣ। ");
INSERT INTO syls_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","ꠀꠟ꠆ꠟꠣꠞ ꠢꠥꠇꠥꠝ ꠙꠣꠁꠀ ꠔꠥꠝꠤ ꠎꠥꠖꠤ ꠅꠃꠟꠣ ꠇꠞ, ꠔꠦ ꠔꠥꠝꠤ ꠇꠥꠟꠣꠁꠔꠣꠄ ꠙꠣꠞꠛꠣꠄ, ꠀꠞ ꠝꠣꠘꠡꠦꠅ ꠀꠞꠣꠝꠦ ꠎꠣꠞꠎꠤꠞ ꠎꠣꠉꠣꠔ ꠎꠣꠁꠔꠣ ꠙꠣꠞꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","ꠝꠥꠍꠣꠄ ꠔꠣꠘ ꠢꠃꠞꠞ ꠙꠞꠣꠝꠤꠡ ꠝꠣꠘꠟꠣ, ꠔꠣꠁꠘ ꠎꠦꠟꠣ ꠇꠁꠟꠣ ꠝꠥꠍꠣꠄ ꠅꠃꠟꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","ꠝꠥꠍꠣꠄ ꠔꠣꠝꠣꠝ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠕꠣꠇꠤ ꠛꠣꠍꠤꠀ ꠃꠙꠎꠥꠇ꠆ꠔ ꠝꠣꠘꠥꠡ ꠔꠥꠇꠣꠁꠀ, ꠔꠣꠞꠣ ꠇꠦꠃꠞꠞꠦ ꠀꠎꠣꠞ ꠎꠘ, ꠇꠦꠃꠞꠞꠦ ꠡ ꠎꠘ, ꠇꠦꠃꠞꠞꠦ ꠙꠁꠘ꠆ꠌꠣꠡ ꠀꠞ ꠇꠦꠃꠞꠞꠦ ꠖꠡ ꠎꠘꠞ ꠃꠙꠞꠦ ꠘꠦꠔꠣ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","ꠄꠞꠣ ꠢꠣꠝꠦꠡꠣ ꠝꠣꠘꠡꠞ ꠛꠤꠌꠣꠞ-ꠀꠌꠣꠞ ꠇꠞꠔꠣ। ꠈꠣꠟꠤ ꠛꠠ ꠛꠠ ꠊꠐꠘꠣ ꠅꠇꠟ ꠝꠥꠍꠣꠞ ꠇꠣꠍꠣꠔ ꠀꠘꠔꠣ, ꠀꠞ ꠢꠥꠞꠥ ꠢꠥꠞꠥ ꠢꠇꠟꠔꠣ ꠔꠣꠞꠣ ꠝꠤꠐꠣꠁꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","ꠢꠦꠡꠦ ꠝꠥꠍꠣꠄ ꠔꠣꠘ ꠢꠃꠞꠞꠦ ꠛꠤꠖꠣꠄ ꠖꠤꠟꠦ, ꠔꠣꠁꠘ ꠘꠤꠎꠞ ꠖꠦꠡꠅ ꠔꠡꠞꠤꠚ ꠘꠤꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠅꠇꠟ ꠛꠣꠞꠘꠤꠞ ꠛꠣꠖꠦ, ꠔꠤꠘ ꠘꠝ꠆ꠛꠞ ꠌꠣꠘ꠆ꠖꠞ ꠙꠄꠟꠣ ꠖꠤꠘꠃ ꠔꠣꠞꠣ ꠞꠚꠤꠖꠤꠝ ꠅꠁꠀ ꠍꠤꠘꠣꠁ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠙꠃꠍꠤꠟꠣ। ꠅꠘꠅ ꠀꠁꠀ ꠔꠣꠞꠣ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠔꠥꠞ ꠙꠣꠠꠞ ꠍꠣꠝꠘꠦ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","ꠄꠞꠝꠣꠎꠦ ꠢꠎꠞꠔ ꠝꠥꠍꠣ ꠔꠥꠞ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠀꠟ꠆ꠟꠣꠞ ꠖꠞꠛꠣꠞꠅ ꠉꠦꠟꠣ। ꠝꠣꠛꠥꠖꠦ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠕꠣꠇꠤ ꠔꠣꠘꠞꠦ ꠒꠣꠇꠤꠀ ꠇꠁꠟꠣ, “ꠅ ꠝꠥꠍꠣ, ꠔꠥꠝꠤ ꠁꠀꠇꠥꠛꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠞꠦ ꠇꠅ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ");
INSERT INTO syls_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠖꠡꠣ ꠇꠤꠔꠣ ꠊꠐꠣꠁꠍꠤ, ꠁꠔꠣ ꠔ ꠔꠥꠝꠞꠣꠞ ꠘꠤꠎꠞ ꠌꠃꠈꠦ ꠖꠦꠈꠍ। ꠌꠤꠟꠦ ꠎꠦꠟꠣ ꠔꠣꠞ ꠛꠣꠁꠌ꠆ꠌꠣꠞꠦ ꠒꠣꠈꠘꠣꠖꠤ ꠛꠁꠀ ꠘꠦꠄ, ꠀꠝꠤꠅ ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠔꠥꠝꠞꠣꠞꠦ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠛꠁꠀ ꠀꠘꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","ꠅꠈꠘ ꠔꠥꠝꠞꠣ ꠎꠥꠖꠤ ꠀꠝꠣꠞ ꠔꠣꠝꠣꠝ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠝꠣꠘꠅ, ꠀꠞ ꠀꠝꠣꠞ ꠟꠉꠞ ꠅꠀꠖꠣ ꠀꠖꠣꠄ ꠇꠞꠅ, ꠔꠦ ꠖꠥꠘꠤꠀꠞ ꠢꠇ꠆ꠇꠟ ꠎꠣꠔꠤꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣꠃ ꠅꠁꠛꠣꠄ ꠀꠝꠣꠞ ꠈꠣꠍ ꠡꠝ꠆ꠙꠖ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠢꠣꠞꠣ ꠖꠥꠘꠤꠀꠞ ꠢꠇꠟꠔꠣꠃ ꠀꠝꠣꠞ ꠄꠈꠔꠤꠀꠞꠅ। ");
INSERT INTO syls_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ꠔꠥꠝꠞꠣꠞꠦ ꠖꠤꠀꠃ ꠇꠣꠁꠝ ꠅꠁꠛ ꠀꠝꠣꠞ ꠁꠝꠣꠝ ꠅꠇꠟꠞ ꠛꠣꠖꠡꠣꠁ, ꠔꠥꠝꠞꠣꠃ ꠅꠁꠛꠣꠄ ꠀꠝꠣꠞ ꠙꠛꠤꠔ꠆ꠞ ꠎꠣꠔꠤ। ꠔꠦ ꠀꠝꠣꠞ ꠅꠃ ꠛꠥꠟꠤ ꠈꠣꠘꠣꠁꠘ ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","ꠅꠃ ꠝꠥꠍꠣꠄ ꠀꠁꠀ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟꠞꠦ ꠖꠟꠣ ꠇꠞꠣꠁꠟꠣ। ꠖꠟꠣ ꠇꠞꠣꠁꠀ ꠇꠁꠟꠣ, ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘꠞꠦ ꠇꠤꠔꠣ ꠇꠤꠔꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","ꠔꠦꠃ ꠢꠇꠟ ꠝꠣꠘꠡꠦ ꠄꠇꠟꠉꠦ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠦ ꠎꠦꠟꠣ ꠛꠣꠔꠣꠁꠍꠂꠘ, ꠀꠝꠞꠣ ꠅꠟꠣ ꠢꠇ꠆ꠇꠟꠔꠣ ꠇꠞꠝꠥ।” ꠝꠣꠘꠡꠦ ꠎꠦꠝꠘꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, ꠝꠥꠍꠣꠄ ꠉꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠅꠟꠣ ꠎꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠎꠦꠛꠟꠣ ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠝꠥ, ꠅꠃ ꠛꠣꠔꠌꠤꠔ ꠎꠣꠔꠦ ꠝꠣꠘꠡꠦ ꠘꠤꠎꠞ ꠇꠣꠘꠦ ꠢꠥꠘꠔ ꠙꠣꠞꠦ, ꠄꠞꠟꠣꠉꠤ ꠀꠝꠤ ꠊꠘ ꠄꠇ ꠝꠦꠊꠞ ꠇꠣꠟꠘꠤꠞ ꠝꠣꠎꠦ ꠞꠁꠀ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠝꠥ। ꠔꠦꠃ ꠝꠣꠘꠡꠦ ꠁꠔꠣ ꠢꠥꠘꠛꠣ, ꠀꠞ ꠔꠥꠝꠣꠞ ꠃꠙꠞꠦ ꠢꠞ-ꠢꠣꠝꠦꠡꠣ ꠙꠥꠞꠣꠙꠥꠞ ꠄꠇꠤꠘ ꠞꠣꠈꠛꠣ।” ꠛꠣꠖꠦ ꠝꠥꠍꠣ ꠉꠤꠀ ꠔꠣꠞꠣꠞꠅ ꠢꠇꠟ ꠇꠕꠣ ꠝꠣꠛꠥꠖꠞꠦ ꠎꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠀꠁꠎ ꠀꠞ ꠇꠣꠁꠟ ꠖꠥꠁꠅ ꠖꠤꠘ ꠝꠣꠘꠡꠞ ꠇꠣꠍꠣꠔ ꠉꠤꠀ ꠔꠣꠞꠣꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠞꠅ। ꠔꠣꠞꠣ ꠎꠣꠞꠎꠤꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠖꠦꠃꠇ। ");
INSERT INTO syls_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ꠔꠣꠞꠣ ꠙꠞꠡꠥ ꠖꠤꠘꠞ ꠟꠣꠉꠤ ꠔꠂꠀꠞ ꠅꠃꠇ, ꠅꠃ ꠖꠤꠘ ꠀꠝꠤ ꠝꠣꠛꠥꠖ ꠔꠥꠞ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠟꠣꠝꠤꠀ ꠀꠁꠀ ꠔꠣꠞꠣ ꠢꠇꠟꠞꠦ ꠖꠤꠖꠣꠞ ꠖꠤꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","ꠔꠦ ꠔꠥꠝꠤ ꠙꠣꠠꠞ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠄꠇꠐꠣ ꠡꠤꠝꠣꠘꠣ ꠑꠤꠇ ꠇꠞꠤꠀ ꠖꠤꠟꠣꠅ। ꠖꠤꠀ ꠔꠣꠞꠣꠞꠦ ꠢꠥꠡꠤꠀꠞ ꠇꠞꠤ ꠇꠅ, ꠔꠣꠞꠣ ꠎꠣꠘꠥ ꠁ ꠙꠣꠠꠅ ꠘꠣ ꠃꠑꠦ ꠀꠞ ꠙꠣꠠꠞ ꠡꠤꠝꠣꠘꠣꠔ ꠘꠣ ꠍꠄ। ꠇꠦꠃ ꠎꠥꠖꠤ ꠁ ꠙꠣꠠꠅ ꠍꠄ, ꠔꠦ ꠔꠣꠞ ꠡꠣꠎꠣ ꠅꠁꠟ ꠝꠃꠔ। ");
INSERT INTO syls_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","ꠝꠣꠞꠣꠞ ꠛꠣꠟꠣ ꠔꠣꠞ ꠉꠔꠞꠅ ꠀꠔ ꠘꠣ ꠖꠤꠀ, ꠔꠣꠞꠦ ꠙꠣꠔ꠆ꠔꠞ ꠛꠣ ꠔꠤꠞ ꠝꠣꠞꠤꠀ ꠝꠣꠞꠛꠣꠄ। ꠢꠦ ꠝꠣꠘꠥꠡ ꠅꠃꠇ ꠛꠣ ꠎꠣꠘꠥꠀꠞ ꠅꠃꠇ ꠔꠣꠞꠦ ꠝꠣꠞꠤꠟꠤꠛꠣꠄ। ꠈꠣꠟꠤ ꠄꠇꠟꠉꠦ ꠛꠃꠔ ꠡꠝꠄ ꠡꠤꠋꠉꠣ ꠛꠣꠎꠣꠘꠤꠞ ꠀꠅꠀꠎ ꠢꠥꠘꠟꠦ, ꠔꠣꠞꠣ ꠅꠃ ꠙꠣꠠꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠀꠁꠔꠣ ꠙꠣꠞꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","ꠔꠦꠃ ꠝꠥꠍꠣꠄ ꠙꠣꠠꠅ ꠕꠣꠇꠤ ꠟꠣꠝꠤꠀ ꠀꠁꠀ ꠝꠣꠘꠡꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠞꠟꠣ, ꠝꠣꠘꠡꠦ ꠔꠣꠞꠣꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠖꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","ꠝꠥꠍꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠙꠞꠡꠥ ꠖꠤꠘꠞ ꠟꠣꠉꠤ ꠎꠥꠁꠔ ꠅꠅ, ꠄꠞꠝꠣꠎꠦ ꠇꠦꠃ ꠛꠤꠛꠤꠞ ꠟꠉꠦ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠤꠅ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","ꠢꠣꠍꠣꠃ ꠢꠃ ꠙꠞꠡꠥ ꠖꠤꠘ ꠀꠁꠟꠦ ꠛꠤꠀꠘꠇꠥ ꠛꠣꠟꠣ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠊꠘ ꠝꠦꠊꠞ ꠇꠣꠟꠘꠤ ꠖꠦꠈꠣ ꠉꠦꠟ, ꠈꠥꠛ ꠛꠦꠡꠤ ꠝꠦꠊꠞ ꠒꠣꠇ-ꠎꠤꠟꠇꠣꠘꠤ ꠡꠥꠞꠥ ꠅꠁꠟ। ꠎꠥꠞꠦ ꠎꠥꠞꠦ ꠡꠤꠋꠉꠣꠞ ꠀꠅꠀꠎ ꠢꠥꠘꠣ ꠉꠦꠟ, ꠔꠦꠃ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠇꠦꠝ꠆ꠙꠞ ꠜꠤꠔꠞꠞ ꠢꠇꠟ ꠝꠣꠘꠥꠡ ꠒꠞꠣꠁꠀ ꠇꠣꠙꠣ ꠗꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","ꠅꠃ ꠡꠝꠄ ꠝꠥꠍꠣꠄ ꠝꠣꠘꠡꠞꠦ ꠀꠟ꠆ꠟꠣꠞ ꠍꠣꠝꠘꠦ ꠘꠦꠅꠀꠞ ꠟꠣꠉꠤ ꠇꠦꠝ꠆ꠙ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠟꠣ। ꠔꠣꠞꠣ ꠢꠇꠟ ꠉꠤꠀ ꠙꠣꠠꠞ ꠟꠣꠝꠣꠔ ꠃꠛꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","ꠀꠞ ꠀꠡ꠆ꠔꠣ ꠔꠥꠞ ꠙꠣꠠ ꠗꠥꠝꠣꠄ ꠜꠞꠤꠉꠦꠟ, ꠝꠣꠛꠥꠖ ꠝꠃꠟꠣꠄ ꠀꠉꠥꠘꠤꠞ ꠟꠣꠈꠣꠘ ꠘꠥꠞꠞ ꠍꠥꠞꠔꠦ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠔꠡꠞꠤꠚ ꠀꠘꠟꠣ। ꠁꠐ-ꠜꠣꠐ꠆ꠐꠣꠞ ꠗꠥꠝꠣꠞ ꠟꠣꠈꠣꠘ ꠗꠥꠝꠣ ꠃꠠꠣ ꠡꠥꠞꠥ ꠅꠁꠟ ꠀꠞ ꠀꠡ꠆ꠔꠣ ꠙꠣꠠ ꠎꠥꠠꠤ ꠛꠦꠎꠥꠁꠔꠣ ꠇꠣꠙ ꠡꠥꠞꠥ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","ꠡꠤꠋꠉꠣꠞ ꠀꠅꠀꠎ ꠀꠞꠅ ꠎꠥꠞꠦ ꠎꠥꠞꠦ ꠛꠣꠎꠤꠟ। ꠅꠃ ꠡꠝꠄ ꠝꠥꠍꠣꠄ ꠀꠟ꠆ꠟꠣꠞ ꠟꠉꠦ ꠝꠣꠔꠤꠟꠣ, ꠀꠞ ꠀꠟ꠆ꠟꠣꠄꠅ ꠘꠤꠎꠞ ꠀꠅꠀꠎꠖꠤ ꠝꠥꠍꠣꠞ ꠝꠣꠔꠞ ꠎꠥꠀꠙ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","ꠝꠣꠛꠥꠖ ꠘꠤꠎꠦ ꠔꠥꠞ ꠙꠣꠠꠞ ꠝꠣꠕꠣꠔ ꠟꠣꠝꠤꠀ ꠀꠁꠀ ꠝꠥꠍꠣꠞꠦ ꠒꠣꠇꠤꠟꠣ, ꠔꠦꠃ ꠝꠥꠍꠣ ꠃꠑꠤꠀ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","ꠉꠤꠀ ꠢꠣꠞꠟꠦ ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠟꠣꠝꠣꠔ ꠎꠣꠅ, ꠉꠤꠀ ꠝꠣꠘꠡꠞꠦ ꠇꠠꠣ ꠇꠞꠤ ꠇꠁꠀ ꠀꠅ, ꠀꠞꠘꠣꠄ ꠀꠝꠣꠞꠦ ꠖꠦꠈꠣꠞ ꠟꠣꠉꠤ ꠔꠣꠞꠣ ꠡꠤꠝꠣꠘꠣ ꠙꠣꠞ ꠅꠁꠀ ꠃꠙꠞꠦ ꠀꠁꠛ꠆ꠛꠣ। ꠀꠁꠟꠦ ꠛꠃꠔ ꠝꠣꠘꠥꠡ ꠝꠣꠞꠣ ꠎꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","ꠀꠞ ꠎꠦ ꠁꠝꠣꠝ ꠅꠇꠟ ꠢꠣꠝꠦꠡꠣ ꠀꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠀꠎꠤꠞ ꠅꠁꠘ, ꠀꠍꠟꠦ ꠔꠣꠞꠣꠞ ꠇꠣꠝꠃ ꠀꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠀꠎꠤꠞ ꠅꠀ, ꠔꠣꠞꠣꠅ ꠘꠤꠎꠦ ꠘꠤꠎꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠞꠛꠣ। ꠀꠞꠘꠣꠄ ꠀꠝꠤ ꠔꠣꠞꠣꠞ ꠃꠙꠞꠦꠅ ꠉꠎꠛ ꠓꠣꠟꠤꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","ꠝꠥꠍꠣꠄ ꠝꠣꠛꠥꠖꠞꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠔꠣꠞꠣ ꠔ ꠄꠝꠘꠦꠃ ꠔꠥꠞ ꠙꠣꠠꠅ ꠀꠁꠔꠣ ꠘꠣꠄ, ꠀꠙꠘꠦ ꠀꠉꠦꠃ ꠀꠝꠞꠣꠞꠦ ꠇꠠꠣ ꠢꠥꠡꠤꠀꠞꠤ ꠖꠤꠍꠂꠘ। ꠀꠝꠞꠣꠅ ꠙꠣꠠꠞ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠖꠣꠉ ꠖꠤꠀ ꠀꠙꠘꠣꠞ ꠟꠣꠉꠤ ꠙꠣꠇ ꠡꠤꠝꠣꠘꠣ ꠀꠟꠉꠣꠁꠍꠤ।” ");
INSERT INTO syls_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","ꠅꠁꠟꠦ ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘꠞꠦ ꠇꠁꠟꠣ, “ꠘꠣ, ꠔꠥꠝꠤ ꠟꠣꠝꠣꠔ ꠎꠣꠅ। ꠛꠣꠖꠦ ꠔꠥꠝꠤ ꠀꠞ ꠢꠣꠞꠥꠘ ꠖꠥꠁꠅꠎꠘꠦ ꠝꠤꠟꠤꠀ ꠃꠙꠞꠦ ꠀꠁꠅ। ꠈꠤꠀꠟ ꠞꠣꠈꠤꠅ, ꠇꠥꠘꠥ ꠁꠝꠣꠝ ꠛꠣ ꠖꠥꠍꠞꠣ ꠇꠥꠘꠥ ꠝꠣꠘꠥꠡ ꠎꠣꠔꠦ ꠡꠤꠝꠣꠘꠣ ꠍꠣꠠꠤꠀ ꠀꠝꠣꠞ ꠇꠣꠍꠣꠔ ꠘꠣ ꠀꠁꠘ, ꠀꠁꠟꠦ ꠀꠝꠤ ꠔꠣꠞꠣꠞ ꠃꠙꠞꠦ ꠟꠣꠘ꠆ꠘꠔꠤ ꠉꠎꠛ ꠓꠣꠟꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠝꠥꠍꠣ ꠟꠣꠝꠣꠔ ꠉꠦꠟꠣ, ꠉꠤꠀ ꠝꠣꠘꠡꠞꠦ ꠢꠇꠟꠔꠣ ꠎꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠚꠞꠝꠣꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“ꠅ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠅꠇꠟ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ। ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠉꠥꠟꠣꠝꠤ ꠕꠣꠇꠤ ꠀꠝꠤꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠈꠣꠟꠣꠍ ꠇꠞꠤ ꠀꠘꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“ꠀꠝꠣꠞ ꠛꠖꠟꠣ ꠔꠥꠝꠞꠣ ꠖꠥꠍꠞꠣ ꠇꠥꠘꠥ ꠖꠦꠛꠔꠣ ꠝꠣꠘꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“ꠙꠥꠎꠣ ꠇꠞꠣꠞ ꠈꠤꠀꠟꠦ ꠔꠥꠝꠞꠣ ꠇꠥꠘꠥ ꠝꠥꠞ꠆ꠔꠤ ꠛꠣꠘꠣꠁꠅ ꠘꠣ, ꠀꠍꠝꠣꠘ, ꠎꠝꠤꠘ ꠛꠣ ꠙꠣꠘꠤꠞ ꠔꠟꠦ ꠎꠔꠔꠣ ꠀꠍꠦ, ꠁꠔꠣ ꠇꠥꠘꠥꠔꠣꠞ ꠍꠥꠞꠔꠦ ꠝꠥꠞ꠆ꠔꠤ ꠛꠣꠘꠣꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","ꠔꠥꠝꠞꠣ ꠁꠔꠣꠞ ꠙꠥꠎꠣ ꠇꠞꠤꠅ ꠘꠣ, ꠁꠔꠣꠞ ꠡꠦꠛꠣ-ꠎꠔꠘ ꠇꠞꠤꠅ ꠘꠣ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣ ꠔ ꠟꠣ-ꠡꠞꠤꠇ ꠝꠣꠛꠥꠖ, ꠇꠥꠘꠥ ꠡꠞꠤꠇ ꠡꠁꠎ꠆ꠎ ꠇꠞꠤ ꠘꠣ। ꠢꠥꠘꠅ, ꠀꠝꠣꠞꠦ ꠎꠦꠞꠣ ꠝꠣꠘꠦ ꠘꠣ, ꠀꠝꠤ ꠔꠣꠞꠣꠞ ꠉꠥꠘꠣꠞ ꠡꠣꠎꠣ ꠖꠦꠁ, ꠔꠣꠞꠣꠞ ꠔꠤꠘ-ꠌꠣꠁꠞ ꠍꠤꠠꠤ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠡꠣꠎꠣ ꠖꠦꠁ। ");
INSERT INTO syls_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ꠅꠁꠟꠦ ꠎꠦꠞꠣ ꠀꠝꠣꠞ ꠀꠡꠤꠇ ꠛꠘꠤꠀ ꠀꠝꠣꠞ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠀꠝꠟ ꠇꠞꠦ, ꠀꠝꠤ ꠔꠣꠞꠣꠞ ꠀꠎꠣꠞ ꠀꠎꠣꠞ ꠅꠀꠞꠤꠡ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠀꠝꠣꠞ ꠅꠛꠤꠞꠣꠝ ꠝꠣꠄꠀ-ꠝꠢꠛ꠆ꠛꠔ ꠖꠦꠈꠣꠁꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“ꠛꠦꠇꠣꠝꠣ ꠇꠥꠘꠥ ꠇꠣꠞꠘꠦ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝ ꠝꠥꠈꠅ ꠟꠁꠅ ꠘꠣ। ꠇꠦꠃ ꠎꠥꠖꠤ ꠈꠣꠝꠈꠣ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝ ꠟꠄ, ꠔꠦ ꠇꠥꠘꠥꠝꠘ꠆ꠔꠦꠃ ꠀꠝꠣꠞ ꠡꠣꠎꠣ ꠕꠣꠇꠤ ꠞꠦꠢꠣꠁ ꠙꠣꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“ꠁꠀꠖ ꠇꠞꠤꠀ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞꠞꠦ ꠙꠛꠤꠔ꠆ꠞ ꠖꠤꠘ ꠝꠣꠘꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ꠢꠣꠙ꠆ꠔꠣꠞ ꠍꠄꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠤꠅ, ꠔꠥꠝꠞꠣꠞ ꠖꠞꠇꠣꠞꠤ ꠢꠇꠟ ꠇꠣꠝ ꠡꠣꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ꠅꠁꠟꠦ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠅꠁꠟ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞ, ꠔꠥꠝꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠦ ꠎꠤꠞꠣꠁꠛꠣꠞ ꠖꠤꠘ। ꠁ ꠖꠤꠘ ꠔꠥꠝꠤ, ꠔꠥꠝꠣꠞ ꠙꠥꠀ-ꠙꠥꠠꠤꠘ, ꠔꠥꠝꠣꠞ ꠉꠥꠟꠣꠝ-ꠛꠣꠘ꠆ꠖꠤꠘ, ꠔꠥꠝꠣꠞ ꠙꠡꠥꠞ ꠙꠣꠟ, ꠔꠥꠝꠣꠞ ꠉꠣꠃꠔ ꠛꠣ ꠐꠣꠃꠘꠅ ꠞꠅꠞꠣ ꠝꠥꠍꠣꠚꠤꠞ ꠛꠣ ꠜꠤꠘ-ꠖꠦꠡꠤ, ꠇꠦꠃ ꠇꠥꠘꠥꠎꠣꠔꠞ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","ꠎꠣꠘ ꠔ, ꠝꠣꠛꠥꠖꠦ ꠍꠄꠖꠤꠘꠦ ꠀꠍꠝꠣꠘ-ꠎꠝꠤꠘ, ꠖꠞꠤꠀ ꠀꠞ ꠄꠞꠣꠞ ꠝꠣꠎꠞ ꠢꠇꠟꠔꠣ ꠙꠄꠖꠣ ꠇꠞꠍꠂꠘ, ꠛꠣꠖꠦ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠎꠤꠞꠣꠁꠍꠂꠘ, ꠇꠥꠘꠥ ꠇꠣꠝ ꠇꠞꠍꠂꠘ ꠘꠣ। ꠅꠃ ꠖꠤꠘꠞꠦ ꠝꠣꠛꠥꠖꠦ ꠞꠢꠝꠔ ꠖꠤꠀ ꠙꠣꠇ ꠖꠤꠘ ꠇꠞꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“ꠔꠥꠝꠞꠣꠞ ꠝꠣ-ꠛꠣꠚꠞꠦ ꠁꠎ꠆ꠎꠔ ꠇꠞꠤꠅ। ꠔꠦꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠎꠦ ꠖꠦꠡ ꠖꠤꠛꠣ, ꠢꠃ ꠖꠦꠡꠅ ꠔꠥꠝꠞꠣꠞ ꠢꠣꠄꠀꠔꠤ ꠛꠣꠠꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“ꠈꠥꠘ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“ꠎꠤꠘꠣ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“ꠌꠥꠞꠤ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“ꠇꠦꠃꠞꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠝꠤꠍꠣ ꠡꠣꠇ꠆ꠇꠤ ꠖꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“ꠙꠞꠞ ꠊꠞ-ꠖꠥꠀꠞꠞ ꠛꠣꠄ ꠟꠣꠟꠌ ꠇꠞꠤꠅ ꠘꠣ, ꠔꠣꠞ ꠛꠃ, ꠉꠥꠟꠣꠝ-ꠛꠣꠘ꠆ꠖꠤ, ꠉꠞꠥ-ꠉꠣꠗꠣ, ꠛꠣ ꠇꠥꠘꠥ ꠇꠤꠌ꠆ꠍꠥꠞ ꠛꠣꠄ ꠟꠣꠟꠌ ꠇꠞꠤꠅ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠎꠦꠛꠟꠣ ꠙꠣꠠ ꠕꠣꠇꠤ ꠝꠦꠊꠞ ꠒꠣꠇ, ꠎꠤꠟꠇꠣꠘꠤ, ꠡꠤꠋꠉꠣꠞ ꠀꠅꠀꠎ, ꠀꠞ ꠗꠥꠝꠣ ꠛꠣꠞꠘꠤꠔ ꠖꠦꠈꠟꠣ, ꠖꠦꠈꠤꠀ ꠔꠣꠞꠣ ꠖꠥꠞꠁ ꠕꠣꠇꠤꠃ ꠒꠞꠣꠁꠀ ꠇꠣꠙꠣ ꠗꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","ꠔꠣꠞꠣ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠀꠙꠘꠦꠃ ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠝꠣꠔꠃꠇ꠆ꠇꠣ, ꠀꠝꠞꠣ ꠢꠥꠘꠝꠥ; ꠅꠁꠟꠦ ꠀꠟ꠆ꠟꠣꠄ ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠟꠦ ꠔ ꠀꠝꠞꠣ ꠝꠞꠤꠎꠤꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","ꠝꠥꠍꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠒꠞꠣꠁꠅ ꠘꠣ। ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞꠦ ꠙꠞꠤꠇ꠆ꠇꠣꠔ ꠚꠣꠟꠣꠁꠍꠂꠘ, ꠎꠣꠔꠦ ꠔꠥꠝꠞꠣꠞ ꠎꠣꠘꠅ ꠀꠟ꠆ꠟꠣꠞ ꠒꠞ ꠢꠣꠝꠣꠄ, ꠒꠞꠣꠁꠀ ꠔꠥꠝꠞꠣ ꠉꠥꠘꠣ ꠕꠣꠇꠤ ꠛꠣꠌꠤꠀ ꠞꠅ। ꠄꠞꠟꠣꠉꠤꠃ ꠔꠣꠁꠘ ꠘꠤꠎꠦ ꠖꠤꠖꠣꠞ ꠖꠤꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","ꠢꠇꠟ ꠝꠣꠘꠥꠡ ꠖꠥꠞꠁ ꠃꠛꠣꠁ ꠞꠁꠟꠣ, ꠀꠞ ꠝꠥꠍꠣ ꠀꠟ꠆ꠟꠣꠞ ꠢꠣꠎꠤꠞꠣꠞ ꠢꠃ ꠝꠦꠊꠞ ꠇꠣꠟꠘꠤꠞ ꠀꠘ꠆ꠖꠣꠞꠤꠞ ꠉꠦꠍꠦ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠅ, ꠔꠥꠝꠞꠣ ꠘꠤꠎꠦꠃ ꠔ ꠖꠦꠈꠟꠣꠄ, ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠀꠍꠝꠣꠘ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","ꠄꠞꠟꠣꠉꠤ ꠄꠛꠣꠖꠔ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ, ꠀꠝꠣꠞ ꠛꠖꠟꠣ ꠖꠥꠍꠞꠣ ꠇꠥꠘꠥꠎꠣꠔ ꠖꠦꠛꠔꠣ ꠛꠣꠘꠣꠁꠅ ꠘꠣ। ꠔꠥꠝꠞꠣ ꠡꠥꠘꠣ ꠛꠣ ꠞꠥꠙꠣꠖꠤꠅ ꠘꠤꠎꠞ ꠇꠥꠘꠥ ꠖꠦꠛ-ꠖꠦꠛꠤ ꠛꠣꠘꠣꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ꠀꠝꠣꠞ ꠟꠣꠉꠤ ꠈꠣꠟꠤ ꠝꠣꠐꠤ ꠖꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠁꠅ। ꠄꠞ ꠃꠙꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠞ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠉꠞꠥ-ꠍꠣꠉꠟ ꠀꠘꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠅ। ꠎꠦꠔꠣ ꠎꠣꠉꠣꠁꠘ꠆ꠔꠅ ꠀꠝꠤ ꠀꠝꠣꠞ ꠘꠣꠝ ꠁꠀꠖ ꠇꠞꠣꠁ ꠖꠤꠝꠥ, ꠢꠃ ꠎꠣꠉꠣꠁꠘ꠆ꠔꠅ ꠀꠝꠤ ꠘꠤꠎꠦ ꠀꠎꠤꠞ ꠅꠁꠀ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠥꠀ ꠖꠤꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠟꠣꠉꠤ ꠙꠣꠔ꠆ꠔꠞꠖꠤ ꠇꠥꠘꠥ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠘꠤꠔ ꠟꠣꠉꠟꠦ, ꠢꠤ ꠙꠣꠔ꠆ꠔꠞꠉꠥꠁꠘ ꠇꠣꠐꠤꠅ ꠘꠣ। ꠄꠞ ꠃꠙꠞꠦ ꠀꠔꠤꠀꠞ ꠌꠣꠟꠣꠁꠟꠦ ꠔꠥꠝꠞꠣ ꠁꠔꠣꠞꠦ ꠘꠣꠙꠣꠇ ꠛꠣꠘꠣꠁꠟꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","ꠀꠝꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠅꠃꠟꠣ ꠇꠞꠤ ꠛꠣꠘꠣꠁꠅ, ꠎꠣꠔꠦ ꠄꠞ ꠃꠙꠞꠦ ꠃꠑꠔꠦ ꠇꠥꠘꠥ ꠝꠁ ꠛꠣ ꠍꠤꠠꠤ ꠘꠣ ꠟꠣꠉꠦ, ꠝꠁ ꠛꠣ ꠍꠤꠠꠤ ꠛꠣꠄ ꠃꠑꠣꠔ ꠉꠦꠟꠦ ꠇꠤꠛꠣ ꠔꠥꠝꠞꠣꠞ ꠡꠞꠝ ꠖꠦꠈꠣ ꠎꠣꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠀꠞꠅ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠀꠝꠣꠞ ꠅꠃ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠅꠇꠟ ꠎꠣꠘꠣꠅ। ");
INSERT INTO syls_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“ꠔꠥꠝꠞꠣ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠁꠛꠞꠣꠘꠤ ꠛꠦꠐꠣꠞꠦ ꠈꠞꠤꠖ ꠇꠞꠤꠀ ꠉꠥꠟꠣꠝ ꠛꠣꠘꠣꠅ, ꠔꠦ ꠅꠃ ꠉꠥꠟꠣꠝꠦ ꠍꠄ ꠛꠍꠞ ꠔꠥꠝꠞꠣꠞ ꠉꠥꠟꠣꠝꠤ ꠇꠞꠛ, ꠛꠣꠖꠦ ꠡꠣꠔ ꠛꠍꠞꠞ ꠛꠣꠟꠣ ꠔꠣꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠇꠥꠘ꠆ꠔꠣ ꠘꠣ ꠘꠤꠀ, ꠔꠣꠞꠦ ꠄꠝꠘꠦꠃ ꠀꠎꠣꠖ ꠇꠞꠤ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","ꠢꠦ ꠎꠥꠖꠤ ꠄꠇꠟꠣ ꠔꠥꠝꠞꠣꠞ ꠉꠦꠍꠦ ꠀꠄ ꠔꠦ ꠄꠇꠟꠣꠃ ꠎꠣꠁꠛ; ꠀꠞ ꠎꠥꠖꠤ ꠛꠃꠞꠦ ꠟꠉꠦ ꠟꠁꠀ ꠀꠄ, ꠔꠦ ꠛꠃ ꠟꠁꠀ ꠎꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","ꠅꠁꠟꠦ ꠔꠣꠞ ꠝꠥꠘꠤꠛꠦ ꠎꠥꠖꠤ ꠔꠣꠞꠦ ꠛꠤꠀ ꠇꠞꠣꠁ ꠕꠣꠇꠦ, ꠀꠞ ꠔꠣꠞ ꠇꠥꠘꠥ ꠢꠥꠞꠥꠔ꠆ꠔꠣ-ꠝꠥꠞꠥꠔ꠆ꠔꠣ ꠅꠁꠘ, ꠔꠣꠁꠟꠦ ꠁ ꠛꠦꠐꠤ ꠀꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ ꠝꠥꠘꠤꠛꠞ ꠉꠦꠍꠦꠃ ꠞꠁꠛꠣ; ꠢꠦ ꠈꠣꠟꠤ ꠄꠇꠟꠣ ꠀꠎꠣꠖ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","ꠀꠞ ꠢꠤ ꠉꠥꠟꠣꠝꠦ ꠎꠥꠖꠤ ꠍꠣꠚ ꠇꠞꠤ ꠇꠄ ꠎꠦꠘ, ꠢꠦ ꠔꠣꠞ ꠝꠥꠘꠤꠛ ꠀꠞ ꠔꠣꠞ ꠛꠃ-ꠛꠣꠁꠌ꠆ꠌꠣꠞ ꠝꠣꠄꠀꠄ, ꠄꠞꠣꠞꠦ ꠍꠣꠠꠤꠀ ꠎꠣꠁꠔ ꠘꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ꠔꠦ ꠁ ꠝꠣꠟꠤꠇꠦ ꠔꠣꠞꠦ ꠟꠁꠀ ꠀꠟ꠆ꠟꠣꠞ ꠖꠞꠛꠣꠞꠅ ꠀꠎꠤꠞ ꠅꠁꠛ। ꠔꠣꠞꠦ ꠖꠥꠀꠞꠞ ꠇꠙꠣꠐ ꠛꠣ ꠌꠃꠇꠣꠑꠞ ꠟꠉꠦ ꠃꠛꠣ ꠇꠞꠤꠀ ꠝꠥꠘꠤꠛꠦ ꠡꠤꠇ ꠖꠤꠀ ꠔꠣꠞ ꠇꠣꠘꠅ ꠚꠥꠠ ꠇꠞꠛ। ꠔꠦꠃ ꠢꠦ ꠢꠣꠞꠣ ꠎꠤꠘ꠆ꠖꠦꠉꠤꠜꠞ ꠝꠥꠘꠤꠛꠞ ꠉꠥꠟꠣꠝꠤꠔ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠛꠣꠘ꠆ꠖꠤꠉꠤꠞꠤꠔ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠔꠣꠞ ꠘꠤꠎꠞ ꠙꠥꠠꠤꠞꠦ ꠛꠦꠌꠤꠟꠣꠄ, ꠔꠦ ꠉꠥꠟꠣꠝ ꠅꠇꠟ ꠎꠦꠟꠣ ꠍꠄ ꠛꠍꠞ ꠛꠣꠖꠦ ꠝꠥꠘꠤꠛꠞ ꠛꠣꠠꠤ ꠕꠣꠇꠤ ꠄꠝꠘꠦꠃ ꠀꠎꠣꠖ ꠅꠁꠎꠣꠁꠘ, ꠅꠃ ꠙꠥꠠꠤ ꠔ ꠁꠟꠣ ꠀꠎꠣꠖ ꠅꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","ꠔꠣꠁꠞ ꠝꠥꠘꠤꠛ ꠎꠥꠖꠤ ꠔꠣꠁꠞ ꠃꠙꠞꠦ ꠈꠥꠡꠤ ꠘꠣ ꠅꠁꠘ, ꠔꠦ ꠐꠦꠇꠣ-ꠙꠄꠡꠣꠞ ꠛꠖꠟꠣ ꠔꠣꠁꠞꠦ ꠀꠎꠣꠖ ꠇꠞꠤ ꠖꠤꠔꠦ ꠅꠁꠛ। ꠔꠣꠁꠞꠦ ꠖꠥꠍꠞꠣ ꠇꠥꠘꠥ ꠎꠣꠔꠤꠞ ꠝꠣꠘꠡꠞ ꠉꠦꠍꠦ ꠛꠦꠌꠤꠛꠣꠞ ꠄꠈꠔꠤꠀꠞ ꠘꠣꠁ, ꠇꠣꠞꠘ ꠝꠥꠘꠤꠛꠦ ꠔ ꠔꠣꠘ ꠘꠤꠎꠞ ꠖꠣꠄꠁꠔ꠆ꠔ ꠀꠖꠣꠄ ꠇꠞꠍꠂꠘ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","ꠅꠁꠟꠦ ꠝꠥꠘꠤꠛꠦ ꠎꠥꠖꠤ ꠔꠣꠘ ꠘꠤꠎꠞ ꠙꠥꠀꠞ ꠟꠣꠉꠤ ꠔꠣꠁꠞꠦ ꠙꠍꠘ꠆ꠖ ꠇꠞꠤꠀ ꠘꠦꠁꠘ, ꠔꠦ ꠔꠣꠁꠞꠦ ꠀꠙꠘ ꠙꠥꠠꠤꠞ ꠟꠣꠈꠣꠘ ꠢꠇꠟ ꠈꠦꠝꠔꠣ ꠖꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","ꠝꠥꠘꠤꠛꠦ ꠎꠥꠖꠤ ꠅꠃ ꠛꠣꠘ꠆ꠖꠤꠞꠦ ꠛꠤꠀ ꠇꠞꠣꠞ ꠛꠣꠖꠦ, ꠖꠥꠍꠞꠣ ꠇꠥꠘꠥ ꠇꠁꠘꠣꠞꠦ ꠛꠤꠀ ꠇꠞꠦ, ꠔꠣ-ꠅ ꠁ ꠛꠣꠘ꠆ꠖꠤꠞ ꠈꠥꠞꠣꠇꠤ, ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠀꠞ ꠡꠞꠤꠟꠞ ꠙꠣꠅꠘꠣ ꠢꠇ ꠔꠣꠁꠞꠦ ꠖꠦꠅꠀ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","ꠢꠦ ꠎꠥꠖꠤ ꠅꠃ ꠔꠤꠘꠅ ꠢꠇ ꠙꠥꠞꠣꠙꠥꠞ ꠀꠖꠣꠄ ꠘꠣ ꠇꠞꠦ, ꠔꠦ ꠁ ꠙꠥꠠꠤꠞꠦ ꠄꠇꠖꠝ ꠛꠤꠘꠣ ꠙꠄꠡꠣꠄ ꠀꠎꠣꠖ ꠇꠞꠤ ꠖꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“ꠝꠣꠁꠞ ꠈꠣꠁꠀ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠝꠣꠘꠥꠡ ꠝꠞꠤꠎꠣꠄ, ꠔꠦ ꠎꠦꠉꠤꠄ ꠔꠣꠞꠦ ꠝꠣꠞꠍꠦ, ꠔꠣꠞꠦꠅ ꠎꠣꠘꠦ ꠝꠣꠞꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","ꠅꠁꠟꠦ ꠢꠦ ꠘꠤꠎꠦ ꠎꠥꠖꠤ ꠈꠥꠘ ꠘꠣ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠝꠣꠞꠦ, ꠀꠈꠔꠣ ꠇꠥꠘꠥ ꠇꠣꠞꠘꠦ ꠊꠐꠤꠎꠣꠄ ꠛꠣ ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠞ ꠝꠞ꠆ꠎꠤꠄ ꠁꠔꠣ ꠅꠄ, ꠔꠦ ꠅꠃ ꠈꠥꠘꠤ ꠎꠘ ꠉꠤꠀ ꠅꠟꠣ ꠇꠥꠘꠥ ꠎꠣꠉꠣꠔ ꠜꠣꠉꠤꠔ ꠙꠣꠞꠛ, ꠎꠦ ꠎꠣꠉꠣꠞ ꠇꠕꠣ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠇꠁꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","ꠀꠞ ꠇꠦꠃ ꠎꠥꠖꠤ ꠎꠣꠘꠤꠀ-ꠢꠥꠘꠤꠀ ꠁꠌ꠆ꠍꠣ ꠇꠞꠤ ꠇꠦꠃꠞꠞꠦ ꠈꠥꠘ ꠇꠞꠤꠀ, ꠛꠣꠖꠦ ꠀꠁꠀ ꠀꠝꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠉꠦꠍꠦꠅ ꠀꠡꠞꠄ ꠟꠄ, ꠔꠣ-ꠅ ꠢꠘ ꠕꠣꠇꠤ ꠗꠞꠤꠀ ꠘꠤꠀ ꠔꠣꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“ꠎꠦ ꠝꠣꠘꠡꠦ ꠔꠣꠞ ꠀꠙꠘ ꠝꠣ ꠛꠣ ꠛꠣꠚꠞ ꠃꠙꠞꠦ ꠀꠔ ꠔꠥꠟꠦ, ꠔꠣꠞꠦ ꠘꠤꠌꠄ ꠎꠣꠘꠦ ꠝꠣꠞꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“ꠇꠦꠃ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠞꠦ ꠌꠥꠞꠤ ꠇꠞꠤꠀ ꠀꠘꠤꠀ ꠛꠦꠌꠤꠟꠣꠄ, ꠛꠣ ꠅꠃ ꠝꠣꠘꠡꠞꠦ ꠔꠣꠞ ꠉꠦꠍꠦ ꠙꠣꠅꠀ ꠎꠣꠄ, ꠔꠦ ꠔꠣꠞꠦ ꠘꠤꠌ꠆ꠌꠄ ꠎꠣꠘꠦ ꠝꠣꠞꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“ꠎꠦ ꠝꠣꠘꠡꠦ ꠀꠙꠘ ꠝꠣ ꠛꠣ ꠛꠣꠚꠞꠦ ꠉꠣꠟꠤ-ꠉꠣꠟꠣꠎ ꠇꠞꠦ, ꠔꠣꠞꠦꠅ ꠘꠤꠌ꠆ꠌꠄ ꠎꠣꠘꠦ ꠝꠣꠞꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠇꠣꠁꠎ꠆ꠎꠣꠔ ꠟꠣꠉꠤꠀ ꠎꠥꠖꠤ ꠟꠉꠞ ꠎꠘꠞꠦ ꠑꠥꠡꠤ ꠛꠣ ꠙꠣꠔ꠆ꠔꠞꠖꠤ ꠝꠣꠞꠦ, ꠁ ꠝꠣꠁꠞ ꠈꠣꠁꠀ ꠅꠃ ꠎꠘ ꠘꠣ ꠝꠞꠟꠦꠅ ꠛꠤꠍꠘꠣꠔ ꠢꠥꠔꠤꠀ ꠙꠠꠘꠅ ꠕꠣꠇꠦ, ");
INSERT INTO syls_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ꠢꠦꠡꠦ ꠃꠑꠤꠀ ꠟꠣꠑꠤ ꠜꠞ ꠖꠤꠀ ꠌꠟꠣ-ꠚꠤꠞꠣ ꠇꠞꠣꠞ ꠎꠞꠥꠞ ꠅꠄ, ꠔꠦ ꠎꠦꠉꠤꠄ ꠔꠣꠞꠦ ꠝꠣꠞꠍꠦ ꠔꠣꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠅ ꠘꠣ। ꠈꠣꠟꠤ ꠢꠃ ꠎꠘꠞ ꠇꠣꠝ-ꠇꠣꠎꠞ ꠈꠦꠔꠤ ꠀꠞ ꠔꠣꠞ ꠡꠥꠟ꠆ꠟꠀꠘꠣ ꠖꠣꠅꠀꠁ ꠈꠞꠌ ꠖꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“ꠇꠦꠃ ꠎꠥꠖꠤ ꠔꠣꠞ ꠈꠞꠤꠖꠣ ꠉꠥꠟꠣꠝ-ꠛꠣꠘ꠆ꠖꠤꠞꠦ ꠟꠣꠑꠤ ꠖꠤꠀ ꠝꠣꠞꠦ ꠀꠞ ꠝꠣꠁꠞ ꠈꠣꠁꠀ ꠅꠉꠥ ꠝꠞꠤꠎꠣꠄ, ꠔꠦ ꠄꠞꠦ ꠡꠣꠎꠣ ꠖꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","ꠅꠁꠟꠦ ꠝꠣꠁꠞ ꠈꠣꠅꠀꠞ ꠖꠥꠁ-ꠄꠇꠖꠤꠘ ꠛꠣꠖꠦ ꠎꠥꠖꠤ ꠛꠣꠌꠤꠀ ꠞꠄ, ꠔꠦ ꠇꠥꠘꠥ ꠡꠣꠎꠣ ꠖꠦꠅꠀ ꠟꠣꠉꠔ ꠘꠣꠄ, ꠇꠣꠞꠘ ꠅꠃ ꠉꠥꠟꠣꠝ ꠔ ꠔꠣꠞ ꠘꠤꠎꠞ ꠍꠣꠝꠣꠘꠣ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“ꠝꠣꠞꠣ-ꠝꠣꠞꠤ ꠇꠞꠣꠔ ꠟꠣꠉꠤꠀ ꠎꠥꠖꠤ ꠀꠈꠔꠣ ꠇꠦꠃ ꠇꠥꠘꠥ ꠛꠦꠐꠤꠞꠦ ꠝꠣꠞꠦ ꠀꠞ ꠔꠣꠁꠞ ꠙꠦꠐꠞ ꠛꠣꠁꠌ꠆ꠌꠣ ꠘꠡ꠆ꠐ ꠅꠁꠎꠣꠄ, ꠅꠁꠟꠦ ꠀꠞ ꠇꠥꠘꠥ ꠈꠦꠔꠤ ꠘꠣ ꠅꠄ, ꠔꠦ ꠅꠃ ꠛꠦꠐꠤꠞ ꠎꠣꠝꠣꠁꠞ ꠖꠣꠛꠤ ꠀꠞ ꠛꠤꠌꠣꠞꠤ-ꠡꠣꠟꠤꠡꠞ ꠛꠤꠛꠦꠌꠘꠣ ꠝꠣꠚꠤꠇ ꠄꠞꠦ ꠈꠦꠔꠤ-ꠙꠥꠞꠘ ꠖꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","ꠅꠁꠟꠦ ꠎꠥꠖꠤ ꠔꠣꠁꠞ ꠀꠞꠅ ꠇꠥꠘꠥ ꠈꠦꠔꠤ ꠅꠄ, ꠔꠣꠁꠟꠦ ꠄꠞꠦ ꠅꠃ ꠟꠣꠈꠣꠘ ꠡꠣꠎꠣ ꠖꠤꠛꠣꠄ: ");
INSERT INTO syls_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ꠎꠣꠘꠞ ꠛꠖꠟꠣ ꠎꠣꠘ, ꠌꠃꠈꠞ ꠛꠖꠟꠣ ꠌꠃꠈ, ꠖꠣꠔꠞ ꠛꠖꠟꠣ ꠖꠣꠔ, ꠀꠔꠞ ꠛꠖꠟꠣ ꠀꠔ, ꠙꠣꠅꠞ ꠛꠖꠟꠣ ꠙꠣꠅ, ");
INSERT INTO syls_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ꠎꠣꠟꠣꠘꠤꠞ ꠛꠖꠟꠣ ꠎꠣꠟꠣꠘꠤ, ꠎꠈꠝꠞ ꠛꠖꠟꠣ ꠎꠈꠝ, ꠖꠣꠉꠞ ꠛꠖꠟꠣ ꠖꠣꠉ ꠖꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“ꠇꠦꠃ ꠎꠥꠖꠤ ꠔꠣꠞ ꠈꠞꠤꠖꠣ ꠉꠥꠟꠣꠝ ꠛꠣ ꠛꠣꠘ꠆ꠖꠤꠞ ꠇꠥꠘꠥ ꠌꠈꠥꠔ ꠝꠣꠞꠣꠄ ꠌꠃꠈ ꠘꠡ꠆ꠐ ꠅꠁꠎꠣꠄ, ꠔꠦ ꠅꠃ ꠌꠃꠈꠞ ꠛꠖꠟꠣ ꠢꠦ ꠁ ꠉꠥꠟꠣꠝꠞꠦ ꠀꠎꠣꠖ ꠇꠞꠤ ꠖꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","ꠎꠥꠖꠤ ꠝꠣꠞꠤꠀ ꠄꠞ ꠖꠣꠔ ꠚꠣꠟꠣꠁ ꠖꠦꠄ, ꠔꠣ-ꠅ ꠄꠞꠦ ꠀꠎꠣꠖ ꠇꠞꠤ ꠖꠦꠅꠀ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“ꠇꠥꠘꠥ ꠉꠞꠥꠄ ꠉꠥꠔꠣꠁꠀ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠛꠦꠐꠣ ꠛꠣ ꠛꠦꠐꠤꠞꠦ ꠝꠣꠞꠤꠟꠣꠄ, ꠔꠦ ꠉꠞꠥꠞ ꠝꠣꠟꠤꠇꠞꠦ ꠇꠥꠘꠥ ꠡꠣꠎꠣ ꠖꠦꠅꠀ ꠟꠣꠉꠔ ꠘꠣꠄ। ꠈꠣꠟꠤ ꠢꠤ ꠉꠞꠥꠞꠦ ꠙꠣꠔ꠆ꠔꠞꠖꠤ ꠁꠐꠣꠁꠀ ꠝꠣꠞꠤꠟꠤꠔꠦ ꠅꠁꠛ, ꠁ ꠉꠞꠥꠞ ꠉꠥꠡ꠆ꠔ ꠇꠦꠃ ꠈꠣꠁꠔ ꠙꠣꠞꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","ꠅꠁꠟꠦ ꠁ ꠉꠞꠥꠞ ꠎꠥꠖꠤ ꠢꠣꠝꠦꠡꠣ ꠅꠃꠟꠣ ꠉꠥꠔꠣꠘꠤꠞ ꠈꠣꠁꠌ꠆ꠍꠔ ꠕꠣꠇꠦ, ꠀꠞ ꠢꠤ ꠝꠣꠟꠤꠇꠞꠦ ꠢꠥꠡꠤꠀꠞ ꠇꠞꠣꠞ ꠛꠣꠖꠦꠅ ꠢꠦ ꠁꠐꠣꠞꠦ ꠀꠐꠇꠣꠄ ꠘꠣ, ꠄꠞꠝꠣꠎꠦ ꠁ ꠉꠞꠥꠄ ꠇꠥꠘꠥ ꠛꠦꠐꠣ ꠛꠣ ꠛꠦꠐꠤꠞꠦ ꠝꠣꠞꠤꠟꠣꠄ, ꠔꠦ ꠁ ꠉꠞꠥꠞꠦ ꠙꠣꠔ꠆ꠔꠞ ꠝꠣꠞꠤꠀ ꠝꠣꠞꠤꠟꠤꠔꠦ ꠅꠁꠛ, ꠀꠞ ꠔꠣꠞ ꠝꠣꠟꠤꠇꠞꠦꠅ ꠝꠣꠞꠤꠟꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","ꠎꠥꠖꠤ ꠁ ꠝꠣꠟꠤꠇꠞ ꠉꠦꠍꠦ ꠇꠥꠘꠥ ꠈꠦꠔꠤ-ꠙꠥꠞꠘ ꠌꠣꠅꠀ ꠅꠄ, ꠔꠣꠁꠟꠦ ꠢꠦ ꠅꠃ ꠎꠞꠤꠝꠣꠘꠣ ꠖꠤꠀ ꠘꠤꠎꠞ ꠎꠣꠘ ꠛꠣꠌꠣꠁꠔ ꠙꠣꠞꠛ। ");
INSERT INTO syls_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","ꠁ ꠉꠞꠥꠄ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠞꠦ ꠉꠥꠔꠣꠁꠀ ꠝꠣꠞꠤꠟꠣꠄ, ꠔꠣꠁꠟꠦ ꠄꠞꠟꠣꠉꠤꠅ ꠅꠃ ꠢꠝꠣꠘ ꠘꠤꠅꠝ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","ꠇꠥꠘꠥ ꠉꠞꠥꠄ ꠎꠥꠖꠤ ꠇꠦꠃꠞꠞ ꠉꠥꠟꠣꠝ ꠛꠣ ꠛꠣꠘ꠆ꠖꠤꠞꠦ ꠉꠥꠔꠣꠁꠀ ꠝꠣꠞꠤꠟꠣꠄ, ꠔꠣꠁꠟꠦ ꠉꠞꠥꠞ ꠝꠣꠟꠤꠇꠦ ꠢꠤ ꠉꠥꠟꠣꠝꠞ ꠝꠣꠟꠤꠇꠞꠦ ꠔꠤꠡ ꠔꠟꠣ ꠙꠞꠤꠝꠣꠘ ꠞꠥꠙꠣ ꠖꠤꠔꠦ ꠅꠁꠛ ꠀꠞ ꠢꠤ ꠉꠞꠥꠞꠦꠅ ꠙꠣꠔ꠆ꠔꠞ ꠝꠣꠞꠤ ꠝꠣꠞꠤꠟꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“ꠇꠦꠃ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠉꠣꠔꠞ ꠝꠥꠈ ꠈꠥꠟꠤꠀ ꠕꠄ ꠛꠣ ꠉꠣꠔ ꠈꠥꠖꠤꠀ ꠁꠉꠥꠞ ꠝꠥꠈ ꠉꠥꠞꠤꠀ ꠘꠣ ꠕꠄ, ꠀꠞ ꠁ ꠉꠣꠔꠞ ꠜꠤꠔꠞꠦ ꠇꠥꠘꠥ ꠉꠞꠥ ꠛꠣ ꠉꠣꠗꠣ ꠙꠠꠤꠎꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ꠔꠣꠁꠟꠦ ꠉꠣꠔꠞ ꠝꠣꠟꠤꠇꠦ ꠙꠡꠥꠞ ꠝꠣꠟꠤꠇꠞꠦ ꠈꠦꠔꠤ-ꠙꠥꠞꠘ ꠖꠤꠔꠦ ꠅꠁꠛ। ꠅꠁꠟꠦ ꠁ ꠝꠞꠣ ꠙꠡꠥ ꠙꠣꠁꠛ ꠉꠣꠔꠞ ꠝꠣꠟꠤꠇꠦ। ");
INSERT INTO syls_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“ꠇꠦꠃꠞꠞ ꠉꠞꠥꠄ ꠎꠥꠖꠤ ꠀꠞꠇ ꠎꠘꠞ ꠉꠞꠥꠞꠦ ꠉꠥꠔꠣꠁꠀ ꠝꠣꠞꠤꠟꠣꠄ, ꠔꠦ ꠢꠃ ꠎꠤꠔꠣ ꠉꠞꠥꠞꠦ ꠛꠦꠌꠤꠀ, ꠄꠞ ꠖꠣꠝ ꠀꠞ ꠝꠞꠣ ꠉꠞꠥꠞ ꠖꠣꠝꠅ ꠄꠞꠣ ꠖꠥꠁꠅꠎꠘꠦ ꠢꠝꠣꠘ ꠢꠝꠣꠘ ꠇꠞꠤ ꠛꠣꠐꠤꠀ ꠘꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","ꠅꠁꠟꠦ ꠀꠉ ꠕꠣꠇꠤ ꠎꠥꠖꠤ ꠎꠣꠘꠣ-ꠢꠥꠘꠣ ꠕꠣꠇꠦ ꠎꠦꠘ, ꠁ ꠉꠞꠥꠄ ꠅꠟꠣ ꠉꠥꠔꠣꠄ, ꠀꠞ ꠔꠣꠞ ꠝꠣꠟꠤꠇꠦ ꠔꠣꠞꠦ ꠘꠣ ꠀꠐꠇꠣꠄ, ꠔꠦ ꠉꠞꠥꠞ ꠛꠖꠟꠣ ꠉꠞꠥ ꠖꠤꠔꠦ ꠅꠁꠛ, ꠛꠖꠟꠣ ꠖꠦꠅꠞꠣ ꠎꠘꠦ ꠅꠃ ꠝꠞꠣ ꠉꠞꠥꠐꠣ ꠙꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“ꠇꠦꠃ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠞ ꠉꠞꠥ ꠛꠣ ꠝꠦꠠꠣ-ꠍꠣꠉꠟ ꠌꠥꠞꠤ ꠇꠞꠤꠀ ꠀꠘꠤꠀ ꠎꠥꠖꠤ ꠛꠦꠌꠤꠟꠣꠄ ꠛꠣ ꠎꠛ ꠇꠞꠤꠟꠣꠄ, ꠔꠦ ꠄꠇ ꠉꠞꠥꠞ ꠛꠖꠟꠣ ꠙꠣꠌꠉꠥ, ꠄꠇ ꠝꠦꠠꠣ ꠛꠣ ꠍꠣꠉꠟꠞ ꠛꠖꠟꠣ ꠌꠣꠁꠞꠉꠥ ꠚꠤꠞꠔ ꠖꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","ꠌꠥꠞꠦ ꠔꠣꠞ ꠌꠥꠞꠤꠞ ꠝꠣꠟꠞ ꠈꠦꠔꠤ-ꠙꠥꠞꠘ ꠖꠤꠔꠦ ꠅꠁꠛ, ꠅꠁꠟꠦ ꠔꠣꠞ ꠎꠥꠖꠤ ꠈꠦꠔꠤ-ꠙꠥꠞꠘ ꠖꠤꠛꠣꠞ ꠇꠥꠘꠥ ꠔꠣꠇ꠆ꠇꠔ ꠘꠣ ꠕꠣꠇꠦ, ꠔꠦ ꠔꠣꠞꠦ ꠛꠦꠌꠤꠀ ꠄꠞ ꠈꠦꠔꠤ-ꠙꠥꠞꠘ ꠀꠖꠣꠄ ꠇꠞꠔꠦ ꠅꠁꠛ। ꠌꠥꠞꠤ ꠇꠞꠣ ꠉꠞꠥ-ꠉꠣꠗꠣ ꠛꠣ ꠝꠦꠠꠣ-ꠍꠣꠉꠟ ꠎꠥꠖꠤ ꠌꠥꠞꠞ ꠉꠦꠍꠦ ꠎꠤꠔꠣ ꠙꠣꠅꠀ ꠎꠣꠄ, ꠔꠣꠁꠟꠦ ꠢꠦ ꠁꠔꠣ ꠄꠉꠥꠞ ꠛꠖꠟꠣ ꠖꠥꠉꠥ ꠚꠤꠞꠔ ꠖꠤꠔꠦ ꠅꠁꠛ। “ꠇꠥꠘꠥ ꠌꠥꠞꠦ ꠎꠥꠖꠤ ꠌꠥꠞꠤꠔ ꠉꠤꠀ ꠊꠞꠅ ꠢꠣꠝꠣꠁꠛꠣꠞ ꠛꠣꠟꠣ ꠗꠞꠣ ꠈꠣꠁꠟꠣꠄ ꠀꠞ ꠎꠈꠝ ꠅꠁꠀ ꠝꠞꠤꠎꠣꠄ, ꠔꠣꠁꠟꠦ ꠔꠣꠞꠦ ꠝꠣꠞꠣꠞ ꠟꠣꠉꠤ ꠝꠣꠞꠞꠣ ꠎꠘ ꠖꠣꠄꠁ ꠅꠁꠔ ꠘꠣꠄ। ꠅꠁꠟꠦ ꠡꠥꠞꠥꠎ ꠃꠑꠣꠞ ꠛꠣꠖꠦ ꠎꠥꠖꠤ ꠖꠤꠘꠞ ꠛꠣꠟꠣ ꠁꠟꠣ ꠅꠄ, ꠔꠦ ꠁ ꠈꠥꠘꠞ ꠟꠣꠉꠤ ꠢꠦ ꠖꠣꠄꠁ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“ꠇꠦꠃ ꠎꠥꠖꠤ ꠔꠣꠞ ꠉꠞꠥ-ꠍꠣꠉꠟ ꠘꠤꠎꠞ ꠛꠣꠉꠣꠘꠅ ꠛꠣ ꠈꠦꠔꠞ ꠝꠣꠎꠦ ꠞꠣꠈꠣꠔ ꠉꠤꠀ ꠍꠣꠠꠤ ꠖꠦꠄ, ꠀꠞ ꠁꠔꠣꠄ ꠉꠤꠀ ꠝꠣꠘꠡꠞ ꠈꠦꠔꠞ ꠚꠡꠟ ꠈꠣꠁꠟꠣꠄ, ꠔꠦ ꠔꠣꠞ ꠘꠤꠎꠞ ꠈꠦꠔꠞ ꠢꠇꠟ ꠕꠣꠇꠤ ꠜꠣꠟꠣ ꠅꠋꠡ ꠛꠖꠟꠣ ꠖꠤꠀ ꠈꠦꠔꠤ-ꠙꠥꠞꠘ ꠖꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“ꠇꠥꠘꠥ ꠎꠣꠉꠣ ꠕꠣꠇꠤ ꠀꠉꠥꠁꠘ ꠟꠣꠉꠤꠀ ꠎꠥꠖꠤ ꠎꠥꠙ-ꠎꠋꠉꠟ ꠎꠟꠦ, ꠀꠞ ꠛꠣꠖꠦ ꠅꠃ ꠀꠉꠥꠁꠘ ꠉꠤꠀ ꠇꠦꠃꠞꠞ ꠈꠦꠔꠞ ꠝꠣꠎꠦ ꠛꠣꠘ꠆ꠖꠣ ꠝꠥꠁꠐ, ꠐꠦꠇꠤ ꠛꠣ ꠀꠡ꠆ꠔꠣ ꠈꠦꠔ ꠎꠟꠤ ꠎꠣꠄ, ꠔꠦ ꠀꠉꠥꠁꠘ ꠎꠦꠉꠤꠄ ꠎꠣꠟꠣꠁꠍꠤꠟ, ꠢꠦ ꠁꠔꠣꠞ ꠈꠦꠔꠤ-ꠙꠥꠞꠘ ꠖꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“ꠇꠦꠃ ꠎꠥꠖꠤ ꠀꠞꠇ ꠎꠘꠞ ꠉꠦꠍꠦ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠛꠣ ꠐꠦꠇꠣ-ꠙꠄꠡꠣ ꠀꠝꠣꠘꠔ ꠕꠄ, ꠀꠞ ꠀꠝꠣꠘꠔ-ꠖꠣꠞꠞ ꠊꠞ ꠕꠣꠇꠤ ꠁꠔꠣ ꠌꠥꠞꠤ ꠅꠁꠎꠣꠄ, ꠔꠦ ꠅꠃ ꠌꠥꠞ ꠗꠞꠣ ꠙꠠꠟꠦ, ꠌꠥꠞꠦ ꠄꠞ ꠒꠣꠛꠥꠟ ꠚꠤꠞꠔ ꠖꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","ꠅꠁꠟꠦ ꠌꠥꠞ ꠗꠞꠣ ꠘꠣ ꠙꠠꠟꠦ, ꠢꠤ ꠊꠞꠞ ꠝꠣꠟꠤꠇꠦ ꠘꠤꠎꠦꠃ ꠁꠔꠣ ꠟꠥꠇꠣꠁꠍꠦ ꠘꠤ, ꠅꠈꠣꠘ ꠎꠣꠘꠣꠞ ꠟꠣꠉꠤ ꠔꠣꠞꠦ ꠀꠟ꠆ꠟꠣꠞ ꠖꠞꠛꠣꠞꠅ ꠀꠎꠤꠞ ꠇꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“ꠀꠞꠇ ꠎꠘꠞ ꠖꠈꠟꠅ ꠀꠍꠦ, ꠅꠃꠟꠣ ꠇꠥꠘꠥ ꠉꠞꠥ-ꠉꠣꠗꠣ, ꠝꠦꠠꠣ-ꠍꠣꠉꠟ, ꠚꠤꠘ꠆ꠘꠞ ꠇꠣꠙꠠ ꠛꠣ ꠎꠦꠇꠥꠘꠥ ꠀꠞꠣꠁꠟ ꠍꠣꠝꠣꠘꠣ ꠖꠦꠈꠤꠀ ꠇꠦꠃ ꠎꠥꠖꠤ ꠝꠘꠅ ꠇꠞꠦ ꠁꠐꠣ ꠔꠣꠞ ꠝꠣꠟ, ꠔꠣꠁꠟꠦ ꠁꠐꠣꠞ ꠡꠣꠟꠤꠡꠤꠞ ꠟꠣꠉꠤ ꠔꠣꠞꠣ ꠖꠥꠁꠅꠎꠘ ꠉꠤꠀ ꠀꠟ꠆ꠟꠣꠞ ꠖꠞꠛꠣꠞꠅ ꠀꠎꠤꠞ ꠅꠁꠛ। ꠀꠟ꠆ꠟꠣꠄ ꠎꠣꠞꠦ ꠖꠥꠡꠤ ꠡꠣꠁꠛꠡ꠆ꠔ ꠇꠞꠛꠣ, ꠢꠦ ꠔꠣꠞ ꠛꠤꠞꠥꠗꠤ ꠎꠘꠞꠦ ꠄꠞ ꠒꠣꠛꠥꠟ ꠚꠤꠞꠔ ꠖꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“ꠇꠦꠃ ꠎꠥꠖꠤ ꠔꠣꠞ ꠉꠞꠥ-ꠉꠣꠗꠣ, ꠍꠣꠉꠟ-ꠝꠦꠠꠣ ꠛꠣ ꠅꠁꠘ꠆ꠘ ꠇꠥꠘꠥ ꠙꠡꠥꠞꠦ ꠇꠥꠘꠥ ꠉꠤꠞꠡ꠆ꠔꠞ ꠉꠦꠍꠦ ꠞꠣꠈꠣꠔ ꠖꠦꠄ, ꠀꠞ ꠅꠉꠥ ꠝꠞꠤꠎꠣꠄ, ꠎꠈꠝ ꠅꠁꠎꠣꠄ ꠛꠣ ꠀꠞꠣꠁꠎꠣꠄ, ꠅꠁꠟꠦ ꠄꠞ ꠇꠥꠘꠥ ꠡꠣꠇ꠆ꠇꠤ ꠘꠣ ꠝꠤꠟꠦ, ");
INSERT INTO syls_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ꠔꠦ ꠅꠃ ꠉꠤꠞꠡ꠆ꠔꠦ ꠘꠤꠎꠦꠃ ꠎꠦꠘ ꠁꠔꠣ ꠇꠞꠍꠦ ꠘꠣ, ꠁꠐꠣ ꠢꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠉꠤꠀ ꠇꠍꠝ ꠇꠞꠤꠀ ꠝꠤꠐ-ꠝꠣꠐ ꠇꠞꠛ। ꠁ ꠙꠡꠥꠞ ꠝꠣꠟꠤꠇꠦꠅ ꠁꠈꠣꠘ ꠝꠣꠘꠔꠦ ꠅꠁꠛ, ꠔꠣꠁꠘ ꠇꠥꠘꠥ ꠈꠦꠔꠤ-ꠙꠥꠞꠘ ꠙꠣꠁꠔꠣ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","ꠅꠁꠟꠦ ꠁ ꠉꠤꠞꠡ꠆ꠔꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠎꠥꠖꠤ ꠁꠐꠣ ꠌꠥꠞꠤ ꠅꠁꠎꠣꠄ, ꠔꠦ ꠝꠣꠟꠤꠇꠦ ꠈꠦꠔꠤ-ꠙꠥꠞꠘ ꠙꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠎꠋꠟꠤ ꠎꠣꠘꠥꠀꠞꠦ ꠗꠞꠤꠀ ꠁꠉꠥꠞꠦ ꠝꠣꠞꠤꠟꠣꠄ, ꠔꠣꠁꠟꠦ ꠄꠞ ꠙꠞꠝꠣꠘꠞ ꠟꠣꠉꠤ ꠅꠉꠥꠞ ꠚꠣꠞꠣ-ꠍꠤꠠꠣ ꠐꠥꠇꠞꠣꠁꠘ ꠀꠘꠤꠀ ꠖꠦꠈꠣꠘꠤ ꠟꠣꠉꠛ। ꠔꠦꠃ ꠄꠞ ꠇꠥꠘꠥ ꠈꠦꠔꠤ-ꠙꠥꠞꠘ ꠟꠣꠉꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“ꠇꠦꠃꠞꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠈꠥꠎꠤꠀ ꠀꠘꠣ ꠇꠥꠘꠥ ꠙꠡꠥ ꠎꠥꠖꠤ ꠝꠣꠟꠤꠇꠞ ꠀꠚꠞꠈꠦ ꠎꠈꠝ ꠅꠄ ꠛꠣ ꠝꠞꠤꠎꠣꠄ, ꠔꠦ ꠎꠦꠁꠘ ꠈꠥꠎꠤꠀ ꠀꠘꠍꠂꠘ, ꠄꠁꠘ ꠄꠞ ꠈꠦꠔꠤ-ꠙꠥꠞꠘ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","ꠅꠁꠟꠦ ꠝꠣꠟꠤꠇꠞ ꠍꠣꠝꠘꠦꠃ ꠎꠥꠖꠤ ꠅꠃꠟꠣ ꠅꠄ, ꠔꠦ ꠈꠦꠔꠤ-ꠙꠥꠞꠘ ꠟꠣꠉꠔ ꠘꠣꠄ। ꠁ ꠙꠡꠥ ꠎꠥꠖꠤ ꠐꠦꠇꠣ ꠖꠤꠀ ꠜꠣꠠꠣ ꠇꠞꠤ ꠀꠘꠣ ꠅꠄ, ꠔꠦ ꠅꠃ ꠜꠣꠠꠣꠞ ꠐꠦꠇꠣꠃ ꠅꠁꠛ ꠄꠞ ꠈꠦꠔꠤ-ꠙꠥꠞꠘ। ");
INSERT INTO syls_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“ꠛꠤꠀꠞ ꠀꠈꠔ ꠅꠁꠍꠦ ꠘꠣ, ꠅꠃꠟꠣ ꠇꠥꠘꠥ ꠡꠔꠤ ꠙꠥꠠꠤꠞꠦ ꠇꠦꠃ ꠎꠥꠖꠤ ꠝꠤꠍꠣ ꠝꠣꠔꠤꠀ ꠀꠘꠤꠀ ꠔꠣꠁꠞ ꠟꠉꠦ ꠎꠤꠘꠣ ꠇꠞꠤꠟꠣꠄ, ꠔꠣꠁꠟꠦ ꠢꠃ ꠛꠦꠐꠣꠄ ꠙꠥꠠꠤꠞ ꠛꠣꠚꠞꠦ ꠎꠞꠤꠝꠣꠘꠣ ꠖꠤꠀ ꠅꠃ ꠙꠥꠠꠤꠞꠦ ꠛꠤꠀ ꠇꠞꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","ꠅꠁꠟꠦ ꠙꠥꠠꠤꠞ ꠛꠣꠚꠦ ꠎꠥꠖꠤ ꠔꠣꠞ ꠙꠥꠠꠤꠞꠦ ꠁ ꠙꠥꠀꠞ ꠉꠦꠍꠦ ꠛꠤꠀ ꠖꠤꠔꠦ ꠇꠥꠘꠥꠝꠘ꠆ꠔꠦꠃ ꠞꠣꠎꠤ ꠘꠣ ꠅꠄ, ꠔꠣ-ꠅ ꠁ ꠎꠞꠤꠝꠣꠘꠣ ꠖꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“ꠇꠥꠘꠥ ꠎꠣꠖꠥꠉꠤꠞ ꠛꠦꠐꠤꠞꠦ ꠔꠥꠝꠤ ꠎꠤꠔꠣ ꠞꠣꠈꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“ꠇꠥꠘꠥ ꠙꠡꠥꠞ ꠟꠉꠦ ꠇꠦꠃ ꠎꠤꠘꠣ ꠇꠞꠟꠦ, ꠔꠣꠞꠦ ꠘꠤꠌꠄ ꠎꠣꠘꠦ ꠝꠣꠞꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“ꠈꠣꠟꠤ ꠝꠣꠛꠥꠖ ꠍꠣꠠꠣ ꠖꠥꠍꠞꠣ ꠇꠥꠘ꠆ꠔꠣꠞ ꠘꠣꠝꠦ ꠎꠥꠖꠤ ꠇꠦꠃ ꠇꠥꠘꠥ ꠛꠟꠤ-ꠙꠡꠣꠖ ꠖꠦꠄ, ꠔꠦ ꠔꠣꠞꠦꠅ ꠡꠦꠡ ꠇꠞꠤꠟꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“ꠇꠥꠘꠥ ꠜꠤꠘ-ꠖꠦꠡꠤ ꠝꠣꠘꠡꠞ ꠟꠉꠦ ꠛꠣꠖ ꠛꠦꠛꠢꠣꠞ ꠇꠞꠤꠅ ꠘꠣ, ꠔꠣꠞꠦ ꠎꠥꠟꠥꠝ ꠇꠞꠤꠅ ꠘꠣ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠔꠥꠝꠞꠣꠅ ꠄꠇ ꠡꠝꠄ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠝꠥꠍꠣꠚꠤꠞ ꠀꠍꠟꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“ꠇꠥꠘꠥ ꠠꠣꠠꠤ ꠛꠦꠐꠤꠞꠦ ꠛꠣ ꠇꠥꠘꠥ ꠄꠔꠤꠝ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠞꠦ ꠖꠥꠈ ꠖꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","ꠔꠣꠞꠣꠞꠦ ꠖꠥꠈ ꠖꠤꠟꠦ ꠔꠣꠞꠣ ꠎꠥꠖꠤ ꠇꠣꠘ꠆ꠖꠦ, ꠔꠦ ꠁ ꠇꠣꠘ꠆ꠖꠘ ꠘꠤꠌꠄ ꠀꠝꠤ ꠇꠛꠥꠟ ꠇꠞꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ꠄꠔꠦ ꠀꠝꠣꠞ ꠉꠥꠍꠣ ꠅꠁꠛ ꠀꠉꠥꠁꠘ ꠛꠞꠣꠛꠞ। ꠔꠥꠝꠞꠣ ꠎꠥꠖ꠆ꠖꠔ ꠙꠠꠤꠀ ꠝꠞꠛꠣꠄ, ꠔꠥꠝꠞꠣꠞ ꠛꠃꠅ ꠠꠣꠠꠤ ꠅꠁꠛ, ꠔꠥꠝꠞꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘꠅ ꠅꠃꠟꠣ ꠄꠔꠤꠝ ꠅꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“ꠔꠥꠝꠞꠣ ꠎꠥꠖꠤ ꠀꠝꠣꠞ ꠇꠥꠘꠥ ꠅꠜꠣꠛꠤ ꠛꠘ꠆ꠖꠣꠞꠦ ꠇꠞꠎ ꠖꠦꠅ, ꠔꠣꠁꠟꠦ ꠡꠥꠖꠈꠥꠞꠞ ꠟꠣꠈꠣꠘ ꠔꠣꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠡꠥꠖ ꠘꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","ꠇꠦꠃꠞꠞ ꠉꠔꠞꠞ ꠌꠣꠖ꠆ꠖꠞ ꠛꠘ꠆ꠖꠇ ꠞꠣꠈꠟꠦ, ꠡꠥꠞꠥꠎ ꠒꠥꠛꠣꠞ ꠀꠉꠦꠃ ꠔꠣꠞ ꠌꠣꠖ꠆ꠖꠞ ꠚꠤꠞꠔ ꠖꠤꠟꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ꠇꠣꠞꠘ ꠃꠠꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠅꠐꠣꠃ ꠔꠣꠞ ꠄꠇꠝꠣꠔ꠆ꠞ ꠡꠝ꠆ꠛꠟ। ꠁꠈꠣꠘ ꠘꠤꠟꠦꠉꠤ ꠢꠦ ꠇꠤꠔꠣ ꠃꠠꠤꠀ ꠢꠥꠔꠤꠛ? ꠢꠥꠘꠅ, ꠢꠦ ꠎꠥꠖꠤ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠇꠣꠘ꠆ꠖꠦ, ꠔꠦ ꠀꠝꠤ ꠔ ꠞꠢꠝꠣꠘꠥꠞ ꠞꠢꠤꠝ, ꠀꠝꠤ ꠔꠣꠞ ꠇꠣꠘ꠆ꠖꠘ ꠢꠥꠘꠝꠥꠃ। ");
INSERT INTO syls_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“ꠔꠥꠝꠤ ꠀꠟ꠆ꠟꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠝꠣꠔꠤꠅ ꠘꠣ, ꠔꠥꠝꠣꠞ ꠇꠥꠘꠥ ꠛꠤꠌꠣꠞꠇ-ꠡꠣꠟꠤꠡꠞꠦꠅ ꠛꠖ꠆ꠖꠥꠀ ꠖꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“ꠔꠥꠝꠞꠣꠞ ꠈꠦꠔꠞ ꠚꠡꠟ ꠛꠣ ꠀꠋꠉꠥꠞꠞ ꠡꠞꠛꠔꠞ ꠎꠦ ꠛꠣꠐ ꠀꠝꠣꠞꠦ ꠖꠤꠛꠣꠞ ꠇꠕꠣ, ꠀꠝꠣꠞ ꠁ ꠛꠣꠐ ꠖꠤꠔꠦ ꠖꠦꠞꠤ ꠇꠞꠤꠅ ꠘꠣ। ꠔꠥꠝꠞꠣ ꠢꠇꠟꠞ ꠛꠠ ꠙꠥꠀꠂꠘ ꠀꠝꠣꠞꠦ ꠖꠤꠟꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","ꠔꠥꠝꠞꠣꠞ ꠉꠞꠥ-ꠛꠣꠍꠥꠞ ꠀꠞ ꠍꠣꠉꠟ-ꠝꠦꠠꠣꠞ ꠟꠣꠉꠤꠅ ꠅꠃ ꠄꠇ ꠡꠝꠣꠘ ꠢꠥꠇꠥꠝ। ꠁꠔꠣꠞ ꠢꠇꠟ ꠛꠠ ꠝꠦꠖꠣ ꠛꠣꠁꠌ꠆ꠌꠣꠁꠘ ꠡꠣꠔꠖꠤꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠔꠣꠞꠣꠞ ꠝꠣʼꠞ ꠉꠦꠍꠦ ꠞꠁꠛꠣ, ꠀꠐ ꠖꠤꠘꠞ ꠖꠤꠘ ꠀꠝꠣꠞꠦ ꠖꠤꠟꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“ꠔꠥꠝꠞꠣꠃ ꠅꠁꠛꠣꠄ ꠀꠝꠣꠞ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠛꠘ꠆ꠖꠣ। ꠎꠋꠟꠤ ꠎꠣꠘꠥꠀꠞꠦ ꠝꠣꠞꠤꠀ ꠚꠣꠟꠣꠁꠍꠦ, ꠁꠟꠣ ꠇꠥꠘꠥ ꠎꠣꠘꠖꠣꠞꠞ ꠉꠥꠡ꠆ꠔ ꠔꠥꠝꠞꠣ ꠈꠣꠁꠅ ꠘꠣ; ꠁꠔꠣ ꠇꠥꠇꠥꠞꠞꠦ ꠈꠣꠅꠀꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“ꠔꠥꠝꠞꠣ ꠝꠤꠍꠣ ꠇꠥꠘꠥ ꠛꠖꠘꠣꠝ ꠛꠣꠞ ꠇꠞꠤꠅ ꠘꠣ। ꠙꠇ꠆ꠇꠙꠣꠔꠤ ꠇꠞꠤ ꠝꠤꠍꠣ ꠡꠣꠇ꠆ꠇꠤ ꠖꠤꠀ ꠇꠥꠘꠥ ꠈꠛꠤꠍ ꠝꠣꠘꠡꠞꠦ ꠡꠣꠁꠎ꠆ꠎ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","ꠡꠝꠣꠎꠞ ꠖꠡꠎꠘꠦ ꠅꠁꠘ꠆ꠘꠣꠄ ꠇꠞꠦꠞ ꠖꠦꠈꠤꠀ ꠔꠥꠝꠤꠅ ꠅꠃꠟꠣ ꠇꠞꠤꠅ ꠘꠣ। ꠇꠥꠘꠥ ꠝꠣꠝꠟꠣ-ꠝꠇꠖ꠆ꠖꠝꠣꠞ ꠡꠣꠇ꠆ꠇꠤ ꠖꠦꠅꠀꠔ ꠉꠤꠀ, ꠡꠇ꠆ꠔꠤꠀꠟꠣ ꠖꠟꠞ ꠙꠇ꠆ꠇ ꠟꠁꠀ ꠅꠁꠘ꠆ꠘꠣꠄ ꠇꠣꠝ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","ꠀꠞ ꠇꠥꠘꠥ ꠉꠞꠤꠛꠞ ꠛꠤꠌꠣꠞꠅ ꠉꠤꠀ, ꠢꠦ ꠉꠞꠤꠛ ꠉꠔꠤꠇꠦꠃ ꠔꠣꠞ ꠙꠇ꠆ꠇ ꠟꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“ꠔꠥꠝꠣꠞ ꠖꠥꠡꠝꠘꠞ ꠇꠥꠘꠥ ꠉꠞꠥ-ꠉꠣꠗꠣꠞꠦ ꠛꠦ-ꠙꠕꠦ ꠎꠣꠅꠀꠔ ꠖꠦꠈꠟꠦ, ꠁꠐꠣ ꠚꠤꠞꠣꠁꠀ ꠀꠘꠤꠀ ꠔꠣꠞ ꠉꠦꠍꠦ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","ꠔꠥꠝꠣꠞꠦ ꠁꠋꠡꠣ ꠇꠞꠦ ꠁꠟꠣ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠞ ꠉꠣꠗꠣꠞꠦ ꠜꠣꠞꠞ ꠔꠟꠦ ꠙꠠꠤꠉꠦꠍꠦ ꠖꠦꠈꠟꠦ, ꠔꠣꠞꠦ ꠁꠟꠣ ꠚꠣꠟꠣꠁꠀ ꠎꠣꠁꠅ ꠘꠣ। ꠅꠃ ꠉꠣꠗꠣꠞꠦ ꠔꠥꠟꠣꠔ ꠔꠥꠝꠤ ꠅꠛꠡ꠆ꠡꠁ ꠡꠣꠁꠎ꠆ꠎ ꠇꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“ꠇꠥꠘꠥ ꠉꠞꠤꠛꠞ ꠝꠣꠝꠟꠣ-ꠝꠇꠖ꠆ꠖꠝꠣꠔ ꠅꠁꠘ꠆ꠘꠣꠄ ꠡꠣꠟꠤꠡꠤ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","ꠢꠣꠎꠣꠁꠟ ꠝꠤꠍꠣ ꠝꠣꠝꠟꠣ ꠕꠣꠇꠤ ꠢꠞꠤꠀ ꠞꠁꠅ। ꠇꠥꠘꠥ ꠛꠦ-ꠇꠍꠥꠞ ꠛꠣ ꠘꠤ-ꠅꠙꠞꠣꠗꠤ ꠝꠣꠘꠡꠞꠦ ꠝꠃꠔꠞ ꠡꠣꠎꠣ ꠖꠤꠅ ꠘꠣ। ꠎꠦꠉꠤꠄ ꠁꠟꠣ ꠅꠁꠘ꠆ꠘꠣꠄ ꠇꠞꠛ, ꠔꠣꠞꠦ ꠀꠝꠤ ꠍꠣꠠꠔꠣꠝ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","ꠊꠥꠡ ꠈꠣꠁꠅ ꠘꠣ, ꠇꠣꠞꠘ ꠊꠥꠡꠦ ꠌꠃꠈ ꠀꠟꠣ ꠝꠣꠘꠡꠞꠦꠅ ꠀꠘ꠆ꠖꠣ ꠇꠞꠤꠟꠣꠄ। ꠊꠥꠡꠦ ꠜꠣꠟꠣ ꠝꠣꠘꠡꠞ ꠝꠣꠔꠞ ꠝꠣꠎꠦꠅ ꠙꠦꠌ ꠟꠣꠉꠣꠁ ꠖꠦꠄ। ");
INSERT INTO syls_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“ꠇꠥꠘꠥ ꠜꠤꠘ-ꠖꠦꠡꠤ ꠝꠣꠘꠡꠞ ꠃꠙꠞꠦ ꠎꠥꠟꠥꠝ ꠇꠞꠤꠅ ꠘꠣ। ꠝꠥꠍꠣꠚꠤꠞꠞ ꠢꠣꠟ-ꠢꠇꠤꠇꠔ ꠔ ꠔꠥꠝꠞꠣ ꠎꠣꠘ, ꠇꠣꠞꠘ ꠔꠥꠝꠞꠣꠅ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠝꠥꠍꠣꠚꠤꠞ ꠀꠍꠟꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“ꠔꠥꠝꠞꠣ ꠄꠇꠟꠣꠉꠣꠞꠦ ꠍꠄ ꠛꠞꠍ ꠎꠝꠤꠘꠅ ꠈꠦꠔ ꠇꠞꠤꠅ ꠀꠞ ꠚꠡꠟ ꠇꠣꠐꠤꠅ, ");
INSERT INTO syls_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ꠛꠣꠖꠦ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠛꠞꠍꠅ ꠎꠝꠤꠘꠅ ꠇꠥꠘꠥ ꠈꠦꠔ ꠘꠣ ꠇꠞꠤꠀ ꠙꠔꠤꠔ ꠞꠣꠈꠤꠅ, ꠎꠝꠤꠘꠞꠦ ꠀꠞꠣꠝ ꠖꠤꠅ। ꠄꠔꠦ ꠎꠝꠤꠘꠅ ꠄꠝꠘꠦꠃ ꠎꠦꠔꠣ ꠚꠟꠤꠛ, ꠅꠔꠣ ꠔꠥꠝꠞꠣꠞ ꠉꠞꠤꠛ ꠅꠇꠟꠦ ꠈꠣꠁꠀ ꠛꠣꠌꠤꠛꠣ। ꠔꠣꠞꠣ ꠘꠦꠅꠀꠞ ꠛꠣꠖꠦ ꠎꠦꠔꠣ ꠙꠠꠤ ꠞꠁꠛ, ꠁꠔꠣ ꠎꠋꠟꠤ ꠙꠡꠥ-ꠙꠣꠈꠤꠘ꠆ꠔꠦ ꠈꠣꠁꠛꠣ। ꠔꠥꠝꠞꠣꠞ ꠀꠋꠉꠥꠞꠞ ꠛꠣꠉꠣꠘ ꠛꠣ ꠎꠄꠔꠥꠘ ꠛꠣꠉꠣꠘꠞ ꠟꠣꠉꠤꠅ ꠅꠃ ꠢꠥꠇꠥꠝ ꠝꠣꠘꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“ꠔꠥꠝꠞꠣ ꠢꠣꠙ꠆ꠔꠣꠔ ꠍꠄ ꠖꠤꠘ ꠇꠣꠝ ꠇꠞꠤꠅ, ꠅꠁꠟꠦ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠔ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞ, ꠁꠖꠤꠘ ꠇꠥꠘ꠆ꠔꠣ ꠇꠞꠤꠅ ꠘꠣ। ꠔꠦꠃ ꠔꠥꠝꠞꠣꠞ ꠉꠞꠥ-ꠉꠣꠗꠣꠄ ꠎꠤꠞꠣꠁꠛꠣ, ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠠꠤꠔ ꠎꠘꠝꠤꠍꠦ ꠁ ꠉꠥꠟꠣꠝ ꠀꠞ ꠝꠥꠍꠣꠚꠤꠞ ꠅꠇꠟꠞ ꠎꠣꠘꠦꠅ ꠀꠞꠣꠝ ꠙꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦꠔꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠟꠣꠝ, ꠁꠔꠣ ꠈꠥꠛ ꠢꠥꠡꠤꠀꠞ ꠅꠁꠀ ꠀꠝꠟ ꠇꠞꠤꠅ। ꠇꠥꠘꠥ ꠖꠦꠛꠔꠣꠞ ꠘꠣꠝ ꠝꠥꠈꠅ ꠟꠁꠅ ꠘꠣ, ꠁꠔꠣꠞ ꠘꠣꠝ ꠎꠣꠘꠥ ꠔꠥꠝꠞꠣꠞ ꠝꠥꠈꠅ ꠘꠣ ꠢꠥꠘꠣ ꠎꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“ꠔꠥꠝꠞꠣ ꠙꠞꠔꠦꠇ ꠛꠞꠍ ꠔꠤꠘꠛꠣꠞ ꠀꠝꠣꠞ ꠘꠣꠝꠦ ꠁꠖ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","ꠙꠄꠟꠣ, ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠞꠥꠐꠤꠞ ꠁꠖ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ꠀꠝꠤ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠇꠞꠍꠤ, ꠄꠇ꠆ꠇꠦꠞꠦ ꠅꠃ ꠟꠣꠈꠣꠘ ꠀꠛꠤꠛ ꠌꠣꠘ꠆ꠖꠞ ꠡꠣꠔꠖꠤꠘ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠞꠥꠐꠤ ꠈꠣꠁꠅ, ꠇꠣꠞꠘ ꠅꠃ ꠌꠣꠘ꠆ꠖꠅ ꠔꠥꠝꠞꠣ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁꠀ ꠀꠁꠍꠟꠣꠄ। ꠁꠖꠞ ꠡꠝꠄ ꠟꠤꠟ꠆ꠟꠣ-ꠍꠖꠉꠣ ꠍꠣꠠꠣ ꠔꠥꠝꠞꠣꠞ ꠇꠦꠃ ꠎꠣꠘꠥ ꠈꠣꠟꠤ ꠀꠔꠦ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠘꠣ ꠀꠄ। ");
INSERT INTO syls_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","ꠖꠥꠍꠞꠣ, ꠔꠥꠝꠞꠣ ꠚꠡꠟ ꠖꠣꠅꠀꠞ ꠁꠖ ꠝꠣꠘꠤꠅ। ꠈꠦꠔꠞ ꠝꠣꠎꠦ ꠔꠥꠝꠞꠣ ꠎꠦꠔꠣ ꠞꠥꠁꠍ, ꠁꠔꠣ ꠖꠣꠅꠀꠞ ꠛꠣꠖꠦ ꠙꠄꠟꠣ ꠚꠡꠟ ꠖꠤꠀꠃ ꠁꠖ ꠇꠞꠤꠅ। ꠔꠤꠍꠞꠣ ꠁꠖ, ꠛꠍꠞꠞ ꠢꠦꠡ ꠌꠣꠘ꠆ꠖꠅ ꠛꠣꠉꠣꠘꠞ ꠙꠣꠇꠘꠣ ꠚꠟ ꠛꠣꠠꠤꠔ ꠀꠘꠣꠞ ꠛꠣꠖꠦ ꠒꠦꠞꠣ-ꠊꠞꠞ ꠁꠖ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","ꠅꠃ ꠔꠤꠘꠅ ꠁꠖꠞ ꠡꠝꠄ, ꠛꠍꠞꠅ ꠔꠤꠘꠛꠣꠞ ꠔꠥꠝꠞꠣꠞ ꠢꠇꠟ ꠛꠦꠐꠣꠁꠘ ꠀꠁꠀ ꠢꠎ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠀꠝꠤ ꠀꠟ꠆ꠟꠣ ꠝꠣꠟꠤꠇꠞ ꠍꠣꠝꠘꠦ ꠀꠎꠤꠞ ꠅꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“ꠔꠥꠝꠞꠣ ꠎꠦꠛꠟꠣ ꠀꠝꠣꠞ ꠘꠣꠝꠦ ꠙꠡꠥ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅ, ꠅꠃ ꠡꠝꠄ ꠈꠣꠝꠤꠞ ꠀꠟꠣ ꠇꠥꠘꠥꠎꠣꠔ ꠞꠥꠐꠤ ꠁꠔꠣꠞ ꠟꠉꠦ ꠙꠥꠞꠣꠁꠀ ꠟꠤꠟ꠆ꠟꠣ ꠖꠤꠅ ꠘꠣ। ꠁꠖꠞ ꠡꠝꠄ ꠀꠝꠣꠞ ꠘꠣꠝꠦ ꠎꠦꠔꠣ ꠙꠡꠥ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠄ, ꠁꠔꠣꠞ ꠌꠞ꠆ꠛꠤꠀꠟꠣ ꠐꠥꠇꠞꠣꠁꠘ ꠛꠤꠀꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠞꠣꠈꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","ꠔꠥꠝꠞꠣꠞ ꠈꠦꠔꠞ ꠢꠇꠟ ꠕꠣꠇꠤ ꠜꠣꠟꠣ ꠚꠡꠟ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠅ ꠀꠘꠤꠅ। “ꠀꠞ ꠢꠥꠘꠅ, ꠇꠥꠘꠥ ꠍꠣꠉꠟꠞ ꠛꠣꠁꠌ꠆ꠌꠣꠞ ꠉꠥꠡ꠆ꠔ ꠔꠣꠞ ꠝꠣʼꠞ ꠖꠥꠗ ꠖꠤꠀ ꠞꠣꠘ꠆ꠖꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠎꠦ ꠎꠣꠉꠣ ꠎꠥꠁꠔ ꠇꠞꠤ ꠞꠣꠈꠍꠤ, ꠢꠘꠅ ꠔꠥꠝꠞꠣꠞꠦ ꠢꠦꠚꠣꠎꠔꠦ ꠙꠃꠍꠣꠘꠤꠞ ꠟꠣꠉꠤ, ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠀꠉꠦ ꠀꠉꠦ ꠄꠇꠎꠘ ꠚꠤꠞꠤꠡ꠆ꠔꠣ ꠙꠣꠑꠣꠁꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","ꠔꠥꠝꠞꠣ ꠄꠘ ꠇꠕꠣ ꠝꠘ ꠖꠤꠀ ꠢꠥꠘꠤꠅ ꠀꠞ ꠝꠣꠘꠤꠅ, ꠄꠘ ꠟꠉꠦ ꠔ ꠀꠝꠤꠅ ꠀꠍꠤ। ꠢꠥꠡꠤꠀꠞ ꠞꠁꠅ, ꠄꠘ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠎꠣꠁꠅ ꠘꠣ। ꠀꠞꠘꠣꠄ ꠄꠁꠘ ꠔꠥꠝꠞꠣꠞ ꠅꠙꠞꠣꠗ ꠝꠣꠚ ꠇꠞꠔꠣ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣ ꠎꠥꠖꠤ ꠄꠘ ꠢꠥꠇꠥꠝ ꠝꠣꠘꠅ, ꠀꠞ ꠀꠝꠤ ꠎꠦꠟꠣ ꠇꠁꠍꠤ ꠅꠃꠟꠣ ꠌꠟꠅ, ꠔꠣꠁꠟꠦ ꠔꠥꠝꠞꠣꠞ ꠖꠥꠡꠝꠘꠞ ꠟꠉꠦ ꠀꠝꠤ ꠖꠥꠡꠝꠘꠤ ꠇꠞꠝꠥ, ꠎꠦꠞꠣ ꠔꠥꠝꠞꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠟꠣꠉꠛ, ꠀꠝꠤ ꠔꠣꠞꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠟꠣꠉꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","ꠀꠝꠥꠞꠤ, ꠢꠤꠐ꠆ꠐꠤ, ꠚꠣꠞꠤꠎꠤ, ꠇꠦꠘꠣꠘꠤ, ꠢꠤꠛ꠆ꠛꠤ ꠀꠞ ꠎꠤꠛꠥꠎꠤ ꠅꠇꠟꠞ ꠖꠦꠡꠅ ꠀꠝꠣꠞ ꠚꠤꠞꠤꠡ꠆ꠔꠣꠄ ꠔꠥꠝꠞꠣꠞꠦ ꠘꠤꠀ ꠢꠣꠞꠣꠁꠛꠣ। ꠀꠝꠤ ꠔꠣꠞꠣ ꠢꠇꠟꠐꠤꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠤꠟꠤꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","ꠔꠥꠝꠞꠣ ꠔꠣꠞꠣꠞ ꠖꠦꠛꠔꠣꠞꠦ ꠙꠥꠎꠣ ꠇꠞꠤꠅ ꠘꠣ, ꠈꠦꠎꠝꠔꠅ ꠇꠞꠤꠅ ꠘꠣ, ꠀꠞ ꠢꠤꠘꠞ ꠝꠣꠘꠡꠦ ꠎꠦꠔꠣ ꠇꠞꠂꠘ ꠔꠥꠝꠞꠣ ꠁꠔꠣ ꠇꠞꠤꠅ ꠘꠣ। ꠔꠥꠝꠞꠣ ꠔꠣꠞꠣꠞ ꠖꠦꠛ-ꠖꠦꠛꠤꠞ ꠝꠥꠞ꠆ꠔꠤꠘ ꠀꠞ ꠔꠣꠞꠣꠞ ꠙꠥꠎꠣꠞ ꠝꠘ꠆ꠒꠙ ꠅꠇꠟ ꠜꠣꠋꠉꠤꠀ ꠌꠥꠞꠝꠣꠞ ꠇꠞꠤꠟꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","ꠔꠥꠝꠞꠣ ꠈꠣꠟꠤ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣ, ꠝꠣꠘꠤ ꠀꠝꠣꠞ ꠄꠛꠣꠖꠔ ꠇꠞꠤꠅ। ꠔꠦꠃ ꠔꠥꠝꠞꠣꠞ ꠞꠤꠎꠦꠇꠞ ꠝꠣꠎꠦ ꠞꠢꠝꠔ ꠖꠤꠝꠥ, ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠢꠇ꠆ꠇꠟ ꠛꠦꠝꠣꠞ-ꠀꠎꠣꠞ ꠖꠥꠞ ꠇꠞꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","ꠔꠥꠝꠞꠣꠞ ꠖꠦꠡꠞ ꠇꠥꠘꠥ ꠛꠦꠐꠤꠞ ꠙꠦꠐꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠘꠡ꠆ꠐ ꠅꠁꠔ ꠘꠣꠄ, ꠇꠦꠃ ꠀꠐꠈꠥꠞꠣ ꠞꠁꠔ ꠘꠣꠄ। ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠙꠥꠞꠣꠙꠥꠞ ꠢꠣꠄꠀꠔꠤ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠛꠣꠌꠣꠁꠀ ꠞꠣꠈꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","ꠔꠥꠝꠞꠣ ꠎꠔ ꠎꠣꠔꠤꠞ ꠇꠣꠍꠣꠔ ꠎꠣꠁꠛꠣꠄ, ꠔꠣꠞꠣꠞ ꠖꠤꠟꠞ ꠝꠣꠎꠦ ꠀꠉ ꠕꠣꠇꠤ ꠀꠝꠣꠞ ꠒꠞ-ꠈꠚ ꠙꠄꠖꠣ ꠇꠞꠝꠥ, ꠔꠣꠞꠣꠞꠦ ꠛꠦꠖꠤꠡꠣ ꠛꠣꠘꠣꠁꠟꠤꠝꠥ। ꠔꠥꠝꠞꠣꠞ ꠢꠇ꠆ꠇꠟ ꠖꠥꠡꠝꠘ ꠈꠞꠦꠖꠤ ꠜꠣꠉꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","ꠢꠤꠛ꠆ꠛꠤ, ꠇꠦꠘꠣꠘꠤ ꠀꠞ ꠢꠤꠐ꠆ꠐꠤ ꠅꠇꠟꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠍꠣꠝꠘꠣ ꠕꠣꠇꠤ ꠈꠦꠖꠣꠁꠛꠣꠞ ꠟꠣꠉꠤ, ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠀꠉꠦ ꠇꠞꠤ ꠜꠤꠋꠉꠥꠟꠞ ꠙꠣꠟ ꠙꠣꠑꠣꠁꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","ꠅꠁꠟꠦ ꠀꠝꠤ ꠔꠣꠞꠣ ꠢꠇ꠆ꠇꠟꠞꠦ ꠄꠇꠁ ꠛꠍꠞꠞ ꠜꠤꠔꠞꠦ ꠈꠦꠖꠣꠁꠔꠣꠝ ꠘꠣꠄ, ꠀꠞꠘꠣꠄ ꠀꠡ꠆ꠔꠣ ꠖꠦꠡ ꠙꠔꠤꠔ ꠞꠁꠀ ꠎꠋꠟꠤ ꠎꠣꠘꠥꠀꠞꠦ ꠜꠞꠤꠎꠤꠛꠣ, ꠛꠣꠖꠦ ꠁꠔꠣꠄ ꠔꠥꠝꠞꠣꠞꠦ ꠍꠣꠔꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","ꠀꠝꠤ ꠀꠡ꠆ꠔꠦ ꠀꠡ꠆ꠔꠦ ꠔꠣꠞꠣꠞꠦ ꠈꠦꠖꠣꠁꠝꠥ, ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠘꠥꠡ ꠛꠣꠠꠤꠀ ꠀꠡ꠆ꠔꠣ ꠖꠦꠡ ꠀꠛꠣꠖ ꠇꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","ꠀꠝꠤ ꠘꠤꠟ ꠖꠞꠤꠀ ꠕꠣꠇꠤ ꠚꠤꠟꠤꠡ꠆ꠔꠤꠘꠤ ꠖꠦꠡꠞ ꠡꠣꠉꠞ, ꠝꠣꠘꠤ ꠜꠥꠝꠗꠤꠅ ꠡꠣꠉꠞ ꠙꠞ꠆ꠎꠘ꠆ꠔ, ꠀꠞ ꠖꠃꠇꠘꠞ ꠝꠞꠥꠜꠥꠝꠤ ꠕꠣꠇꠤ ꠚꠥꠞꠣꠔ ꠉꠣꠋ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠔꠥꠝꠞꠣꠞ ꠖꠦꠡꠞ ꠡꠤꠝꠣꠘꠣ ꠉꠣꠠꠝꠥ। ꠁ ꠖꠦꠡꠅ ꠎꠦꠞꠣ ꠛꠡꠔ ꠇꠞꠦꠞ ꠔꠣꠞꠣꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠀꠔꠅ ꠡꠙꠤꠝꠥ, ꠀꠞ ꠔꠥꠝꠞꠣ ꠔꠣꠞꠣꠞꠦ ꠁ ꠖꠦꠡ ꠕꠣꠇꠤ ꠈꠦꠖꠣꠁ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠛꠣ ꠔꠣꠞꠣꠞ ꠖꠦꠛꠔꠣ ꠅꠇꠟꠞ ꠟꠉꠦ ꠔꠥꠝꠞꠣ ꠇꠥꠘꠥ ꠌꠥꠇ꠆ꠔꠤ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","ꠔꠥꠝꠞꠣꠞ ꠖꠦꠡꠞ ꠜꠤꠔꠞꠦ ꠔꠣꠞꠣꠞꠦ ꠞꠁꠛꠣꠞ ꠖꠤꠅ ꠘꠣ। ꠀꠞꠘꠣꠄ ꠔꠣꠞꠣ ꠔꠥꠝꠞꠣꠞꠦ ꠀꠝꠣꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠢꠞꠣꠁꠀ ꠉꠥꠘꠣꠞ ꠙꠕꠦ ꠐꠣꠘꠤꠀ ꠘꠤꠛꠉꠤ। ꠔꠥꠝꠞꠣ ꠎꠥꠖꠤ ꠔꠣꠞꠣꠞ ꠖꠦꠛ-ꠖꠦꠛꠤꠞ ꠙꠥꠎꠣ ꠇꠞꠅ, ꠔꠣꠁꠟꠦ ꠘꠤꠌ꠆ꠌꠤꠔ ꠔꠥꠝꠞꠣꠅ ꠔꠣꠞꠣꠞ ꠚꠣꠘ꠆ꠖꠅ ꠢꠣꠝꠣꠁꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠀꠞ ꠢꠣꠞꠥꠘ, ꠢꠣꠞꠥꠘꠞ ꠙꠥꠀꠂꠘ ꠘꠣꠖꠣꠛ ꠀꠞ ꠀꠛꠤꠢꠥ, ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠡꠔ꠆ꠔꠁꠞ ꠎꠘ ꠝꠥꠞꠛ꠆ꠛꠤ ꠘꠦꠔꠣ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠃꠑꠤꠀ ꠀꠅ। ꠀꠁꠛꠣꠞ ꠛꠣꠟꠣ ꠔꠥꠝꠞꠣ ꠖꠥꠞꠁ ꠕꠣꠇꠤ ꠀꠝꠣꠞꠦ ꠍꠁꠎꠖꠣ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","ꠅꠁꠟꠦ ꠈꠣꠟꠤ ꠔꠥꠝꠤ ꠄꠇꠟꠣ ꠀꠝꠣꠞ ꠇꠣꠍꠣꠔ ꠃꠙꠞꠦ ꠀꠁꠛꠣꠄ, ꠀꠞ ꠇꠦꠃ ꠘꠣꠄ। ꠄꠞꠣꠞ ꠟꠉꠦ ꠀꠞ ꠇꠥꠘꠥ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠎꠣꠘꠥ ꠘꠣ ꠃꠑꠦ।” ");
INSERT INTO syls_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","ꠝꠥꠍꠣꠄ ꠝꠣꠘꠡꠞ ꠉꠦꠍꠦ ꠀꠁꠀ ꠝꠣꠛꠥꠖꠞ ꠢꠇ꠆ꠇꠟ ꠇꠣꠟꠣꠝ ꠀꠞ ꠀꠁꠘ-ꠇꠣꠘꠥꠘ ꠢꠥꠘꠣꠁꠟꠣ, ꠁꠔꠣ ꠢꠥꠘꠤꠀ ꠢꠇꠟ ꠝꠣꠘꠡꠦ ꠄꠇꠟꠉꠦ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠦ ꠎꠔꠔꠣ ꠛꠣꠔꠣꠁꠍꠂꠘ ꠁꠔꠣ ꠢꠇ꠆ꠇꠟꠔꠣ ꠀꠝꠞꠣ ꠝꠣꠘꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","ꠝꠣꠛꠥꠖꠞ ꠛꠣꠔꠣꠁꠟ ꠢꠇꠟ ꠇꠣꠟꠣꠝ ꠝꠥꠍꠣꠄ ꠟꠦꠈꠤꠀ ꠕꠁꠟꠣ। ꠛꠣꠖꠞ ꠖꠤꠘ ꠚꠎꠞꠦ ꠃꠑꠤꠀ ꠙꠣꠠꠞ ꠟꠣꠝꠣꠔ ꠄꠇꠈꠣꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠁꠟꠣ, ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠛꠣꠞꠅ ꠉꠥꠡ꠆ꠐꠤꠞꠦ ꠁꠀꠖ ꠞꠣꠈꠣꠞ ꠟꠣꠉꠤ ꠛꠣꠞꠅꠉꠥ ꠈꠥꠐꠣ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠎꠥꠀꠘ ꠅꠇꠟꠞꠦ ꠙꠣꠑꠣꠁꠟꠣ ꠀꠞ ꠔꠣꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠛꠃꠔ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠟꠣ, ꠀꠞ ꠛꠃꠔ ꠛꠤꠍꠣꠟ ꠎꠛ ꠇꠞꠤꠀ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠅ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","ꠝꠥꠍꠣꠄ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠃꠞ ꠅꠞ꠆ꠗꠦꠇ ꠘꠤꠀ ꠇꠄꠐꠣ ꠛꠣꠐꠤꠔ ꠕꠁꠟꠣ, ꠀꠞ ꠛꠣꠇꠤ ꠅꠞ꠆ꠗꠦꠇ ꠘꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠍꠤꠐꠣꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠀꠟ꠆ꠟꠣꠞ ꠟꠉꠦ ꠝꠤꠟꠘꠞ ꠃꠍꠤꠟ꠆ꠟꠣꠞ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠟꠦꠈꠣ ꠇꠤꠔꠣꠛꠈꠣꠘ ꠔꠤꠟꠣꠅꠔ ꠇꠞꠤ ꠝꠣꠘꠡꠞꠦ ꠢꠥꠘꠣꠁꠟꠣ। ꠁꠔꠣ ꠢꠥꠘꠤꠀ ꠝꠣꠘꠡꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠀꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠢꠇꠟ ꠢꠥꠇꠥꠝ ꠢꠥꠘꠝꠥ, ꠔꠣꠁꠘ ꠎꠔꠔꠣ ꠇꠁꠍꠂꠘ ꠢꠇꠟꠔꠣ ꠝꠣꠘꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","ꠅꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠝꠥꠍꠣꠄ ꠟꠃ ꠟꠁꠀ ꠝꠣꠘꠡꠞ ꠃꠙꠞꠦ ꠍꠤꠐꠣꠁꠀ ꠇꠁꠟꠣ, “ꠁ ꠟꠃ ꠅꠁꠟ ꠀꠟ꠆ꠟꠣꠁ ꠝꠤꠟꠘꠞ ꠢꠃ ꠃꠍꠤꠟ꠆ꠟꠣꠞ ꠟꠃ, ꠎꠦ ꠃꠍꠤꠟ꠆ꠟꠣ ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘ ꠢꠇꠟ ꠡꠞ꠆ꠔ ꠝꠣꠚꠤꠇ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠛꠅꠀꠁꠟ ꠇꠞꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","ꠔꠦꠃ ꠝꠥꠍꠣ, ꠢꠣꠞꠥꠘ, ꠘꠣꠖꠣꠛ, ꠀꠛꠤꠢꠥ ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠡꠔ꠆ꠔꠁꠞ ꠎꠘ ꠝꠥꠞꠛ꠆ꠛꠤ ꠘꠦꠔꠣ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠃꠑꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ꠔꠣꠞꠣ ꠘꠤꠎꠞ ꠌꠃꠈꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠀꠟ꠆ꠟꠣ ꠙꠣꠇꠞ ꠖꠤꠖꠣꠞ ꠖꠦꠈꠟꠣ। ꠔꠣꠞꠣ ꠖꠦꠈꠟꠣ, ꠀꠟ꠆ꠟꠣꠞ ꠙꠣꠅ ꠝꠥꠛꠣꠞꠇꠞ ꠔꠟꠦ ꠀꠍꠦ, ꠌꠇꠌꠇꠣ ꠟꠤꠟ ꠝꠘꠤ ꠙꠣꠔ꠆ꠔꠞꠞ ꠔꠂꠀꠞꠤ ꠍꠣꠔꠞ ꠟꠣꠈꠣꠘ, ꠀꠍꠝꠣꠘꠞ ꠘꠝꠥꠘꠣꠄ ꠍꠣꠚ। ");
INSERT INTO syls_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟꠦ ꠀꠟ꠆ꠟꠣꠞꠦ ꠖꠦꠈꠟꠦꠅ ꠔꠣꠁꠘ ꠄꠞꠣꠞꠦ ꠝꠣꠞꠣꠞ ꠟꠣꠉꠤ ꠀꠔ ꠔꠥꠟꠟꠣ ꠘꠣ। ꠔꠣꠞꠣ ꠔꠣꠘ ꠖꠤꠖꠣꠞ ꠙꠣꠁꠟꠣ ꠀꠞ ꠈꠣꠅꠀ-ꠖꠣꠅꠀ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠅꠃ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠀꠝꠣꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠀꠅ, ꠀꠁꠀ ꠇꠄꠖꠤꠘ ꠞꠅ। ꠝꠣꠘꠡꠞꠦ ꠔꠣꠟꠤꠝ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠀꠝꠣꠞ ꠎꠦ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠙꠣꠔ꠆ꠔꠞꠞ ꠃꠙꠞꠦ ꠟꠦꠈꠍꠤ, ꠅꠔꠣ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠖꠤꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","ꠔꠦꠃ ꠝꠥꠍꠣꠄ ꠔꠣꠘ ꠈꠣꠖꠤꠝ ꠁꠃꠍꠣꠞꠦ ꠟꠉꠦ ꠟꠁꠀ ꠙꠣꠠꠅ ꠃꠑꠟꠣ, ꠀꠞ ꠝꠥꠍꠣ ꠀꠟ꠆ꠟꠣꠞ ꠙꠣꠠꠅ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","ꠔꠣꠁꠘ ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟꠞꠦ ꠇꠁꠀ ꠉꠦꠟꠣ, “ꠀꠝꠞꠣ ꠚꠤꠞꠔ ꠀꠁꠛꠣꠞ ꠀꠉ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠀꠙꠘꠣꠞꠣ ꠀꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠅꠘꠅ ꠛꠣꠞ ꠌꠣꠁꠛꠣ। ꠢꠣꠞꠥꠘ ꠀꠞ ꠢꠥꠞ ꠀꠙꠘꠣꠞꠣꠞ ꠇꠣꠍꠣꠔ ꠀꠍꠂꠘ, ꠇꠥꠘꠥ ꠇꠣꠁꠎ꠆ꠎꠣ-ꠚꠍꠣꠖ ꠟꠣꠉꠟꠦ ꠄꠞꠣꠞ ꠉꠦꠍꠦ ꠎꠣꠁꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","ꠝꠥꠍꠣ ꠙꠣꠠꠅ ꠃꠑꠔꠦꠃ ꠀꠡ꠆ꠔꠣ ꠙꠣꠠ ꠝꠦꠊꠞ ꠇꠣꠟꠘꠤꠄ ꠉꠥꠞꠤꠉꠦꠟ, ");
INSERT INTO syls_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","ꠀꠞ ꠔꠥꠞ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠥꠞꠞ ꠔꠎꠟ꠆ꠟꠤ ꠎꠣꠁꠞ ꠅꠁꠟ। ꠍꠄ ꠖꠤꠘ ꠀꠡ꠆ꠔꠣ ꠙꠣꠠ ꠇꠣꠟꠘꠤꠄ ꠉꠥꠞꠣ ꠞꠁꠟ। ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠅꠃ ꠇꠣꠟꠘꠤ ꠕꠣꠇꠤ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠒꠣꠇꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠥꠞꠞ ꠔꠎꠟ꠆ꠟꠤ ꠖꠦꠈꠟꠣ, ꠔꠣꠞꠣ ꠖꠦꠈꠟꠣ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠀꠉꠥꠘꠤꠞ ꠟꠣꠈꠣꠘ ꠎꠟꠦꠞ। ");
INSERT INTO syls_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","ꠙꠣꠠ ꠛꠣꠁꠀ ꠃꠑꠤ ꠃꠑꠤ ꠝꠥꠍꠣ ꠢꠃ ꠇꠣꠟꠘꠤꠞ ꠜꠤꠔꠞꠦ ꠢꠣꠝꠣꠁ ꠉꠦꠟꠣ। ꠔꠣꠁꠘ ꠌꠣꠟ꠆ꠟꠤꠡ ꠖꠤꠘ ꠌꠣꠟ꠆ꠟꠤꠡ ꠞꠣꠁꠔ ꠢꠃ ꠙꠣꠠꠅ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠅ, ꠔꠣꠞꠣ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠖꠣꠘ-ꠈꠄꠞꠣꠔ ꠟꠁꠀ ꠀꠎꠤꠞ ꠅꠃꠇ। ꠔꠣꠞꠣꠞ ꠘꠤꠎꠞ ꠈꠥꠡꠤꠄ ꠎꠦꠔꠣ ꠖꠣꠘ ꠇꠞꠛꠣ, ꠅꠔꠣ ꠔꠥꠝꠤ ꠡꠝꠎꠤꠀ ꠞꠣꠈꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","ꠔꠣꠞꠣꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠅꠃ ꠟꠣꠈꠣꠘ ꠝꠣꠟ ꠡꠝꠎꠤꠅ: ꠡꠥꠘꠣ, ꠞꠥꠙꠣ, ꠙꠤꠔꠟ; ");
INSERT INTO syls_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ꠟꠤꠟꠥꠀ, ꠛꠣꠁꠋꠉꠘꠤ, ꠟꠣꠟ ꠞꠋꠉꠞ ꠡꠥꠔꠣ; ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠ ꠀꠞ ꠍꠣꠉꠟꠞ ꠞꠥꠝꠣ; ");
INSERT INTO syls_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ꠟꠣꠟ ꠞꠋ ꠟꠣꠉꠣꠁꠟ ꠝꠦꠠꠣꠞ ꠌꠣꠝꠠꠣ, ꠖꠞꠤꠀ ꠚꠥʼ ꠝꠣꠍꠞ ꠌꠣꠝꠠꠣ; ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤ; ");
INSERT INTO syls_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ꠌꠦꠞꠣꠉ ꠅꠇꠟ ꠎꠣꠟꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠎꠄꠔꠥꠘꠞ ꠔꠦꠟ; ꠈꠦꠟꠣꠚꠔꠤ ꠡꠝꠎꠤꠛꠣꠞ ꠔꠦꠟꠞ ꠝꠡꠟꠣ ꠀꠞ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠛꠣꠘꠣꠘꠤꠞ ꠝꠡꠟꠣ; ");
INSERT INTO syls_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ꠁꠝꠣꠝꠞ ꠟꠦꠛꠣꠍꠞ ꠄꠚꠞꠘ ꠀꠞ ꠛꠥꠇꠥꠞ ꠃꠙꠞꠞ ꠕꠟꠤꠔ ꠟꠣꠉꠣꠘꠤꠞ ꠀꠇꠤꠇ ꠝꠘꠤ ꠀꠞ ꠛꠣꠇꠤ ꠢꠇꠟ ꠎꠣꠔꠞ ꠖꠣꠝꠤ ꠙꠣꠔ꠆ꠔꠞ। ");
INSERT INTO syls_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“ꠀꠝꠣꠞ ꠞꠅꠀꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠅꠇꠟꠞꠦꠖꠤ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠄꠇꠈꠣꠘ ꠎꠣꠉꠣ ꠔꠂꠀꠞ ꠇꠞꠣꠁꠛꠣꠄ। ꠔꠦꠃ ꠀꠝꠤ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠛꠡꠔ ꠇꠞꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","ꠀꠝꠣꠞ ꠞꠅꠀꠞ ꠊꠞ ꠀꠞ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣꠞ ꠛꠦꠙꠣꠞꠦ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠎꠦꠟꠣ ꠘꠝꠥꠘꠣ ꠖꠦꠈꠣꠁꠝꠥ, ꠄꠇ꠆ꠇꠦꠞꠦ ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠞꠤ ꠢꠇꠟꠔꠣ ꠔꠤꠀꠞ ꠇꠞꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“ꠔꠣꠞꠣ ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤ ꠖꠤꠀ ꠄꠉꠥ ꠡꠘ꠆ꠖꠥꠇ ꠛꠣꠘꠣꠁꠛꠣ। ꠁꠐꠣ ꠟꠣꠝ꠆ꠛꠣꠄ ꠀꠠꠣꠁ ꠀꠔ, ꠖꠦꠠ ꠀꠔ ꠙꠣꠡ ꠀꠞ ꠖꠦꠠ ꠀꠔ ꠃꠌꠣ। ");
INSERT INTO syls_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","ꠄꠞ ꠛꠣꠞꠦ-ꠜꠤꠔꠞꠦ ꠈꠣꠐꠤ ꠡꠥꠘꠣꠖꠤ ꠟꠦꠙꠤꠀ ꠖꠤꠅ, ꠀꠞ ꠌꠣꠁꠞꠅ ꠇꠤꠘꠣꠞꠅ ꠡꠥꠘꠣꠞ ꠘꠇꠡꠣ ꠟꠣꠉꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","ꠀꠉꠥꠁꠘꠖꠤ ꠡꠥꠘꠣ ꠉꠟꠣꠁꠀ ꠌꠣꠁꠞꠐꠣ ꠇꠠꠣ ꠄꠞ ꠌꠣꠁꠞꠅ ꠇꠥꠘꠣꠔ ꠟꠣꠉꠣꠁꠅ, ꠅꠉꠣꠟꠣꠔ ꠖꠥꠁꠐꠣ ꠀꠞ ꠢꠉꠣꠟꠣꠔ ꠖꠥꠁꠐꠣ ꠟꠣꠉꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤꠖꠤ ꠖꠥꠉꠥ ꠛꠦꠘ꠆ꠖꠣ ꠛꠣꠘꠣꠁꠀ ꠡꠥꠘꠣꠖꠤ ꠟꠦꠙꠤꠀ ꠖꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ꠡꠘ꠆ꠖꠥꠇꠞꠦ ꠛꠁꠀ ꠘꠦꠅꠀꠞ ꠟꠣꠉꠤ ꠖꠥꠁꠅ ꠉꠣꠟꠣꠞ ꠇꠠꠣꠞ ꠝꠣꠎꠦꠖꠤ, ꠅꠃ ꠖꠥꠁꠅ ꠛꠦꠘ꠆ꠖꠣ ꠢꠣꠞꠣꠘꠤ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","ꠛꠦꠘ꠆ꠖꠣ ꠖꠥꠁꠅꠐꠣ ꠡꠘ꠆ꠖꠥꠇꠞ ꠇꠠꠣꠞ ꠜꠤꠔꠞꠦ ꠢꠣꠞꠣꠁꠟ ꠞꠁꠛ, ꠁꠉꠥꠁꠘ ꠈꠥꠟꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","ꠀꠝꠤ ꠀꠝꠣꠞ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠟꠦꠈꠣ ꠎꠦ ꠙꠛꠤꠔ꠆ꠞ ꠡꠣꠢꠣꠖꠔ ꠙꠣꠔ꠆ꠔꠞ ꠔꠥꠝꠣꠞꠦ ꠖꠤꠝꠥ, ꠔꠥꠝꠤ ꠁꠐꠣ ꠅꠃ ꠡꠘ꠆ꠖꠥꠇꠞ ꠜꠤꠔꠞꠦ ꠕꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“ꠈꠣꠐꠤ ꠡꠥꠘꠣꠖꠤ ꠡꠘ꠆ꠖꠥꠇꠞ ꠄꠇꠈꠣꠘ ꠓꠣꠇꠘꠣ ꠛꠣꠘꠣꠁꠅ, ꠅꠈꠣꠘꠞ ꠃꠙꠞꠦ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠣ ꠅꠁꠛ। ꠁ ꠓꠣꠇꠘꠣ ꠟꠣꠝ꠆ꠛꠣꠄ ꠀꠠꠣꠁ ꠀꠔ ꠀꠞ ꠙꠣꠡꠦ ꠖꠦꠠ ꠀꠔ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","19","ꠔꠥꠝꠤ ꠢꠃ ꠓꠣꠇꠘꠣꠞ ꠇꠤꠘꠣꠞꠅ ꠡꠥꠘꠣ ꠙꠤꠐꠣꠁꠀ ꠖꠥꠉꠥ ꠇꠣꠞꠥꠛꠤ ꠛꠣꠘꠣꠁꠅ। ꠅꠃ ꠇꠣꠞꠥꠛꠤ ꠖꠦꠈꠔꠦ ꠖꠥꠟꠖꠥꠟ ꠊꠥꠠꠣꠞ ꠟꠣꠈꠣꠘ ꠒꠣꠈꠘꠣ ꠀꠟꠣ। ꠛꠣꠘꠣꠁꠀ ꠡꠘ꠆ꠖꠥꠇꠞ ꠖꠥꠁ ꠉꠣꠟꠣꠔ ꠟꠣꠉꠣꠁꠅ, ꠅꠉꠣꠟꠣꠔ ꠄꠇꠐꠣ, ꠀꠞ ꠢꠉꠣꠟꠣꠔ ꠄꠇꠐꠣ। ꠖꠥꠁꠅ ꠇꠣꠞꠥꠛꠤ ꠓꠣꠇꠘꠣꠞ ꠟꠉꠦ ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠞꠤ ꠡꠥꠘꠣꠖꠤ ꠛꠣꠘꠣꠘꠤ ꠟꠣꠉꠛ, ꠎꠦꠐꠣ ꠀꠡ꠆ꠔꠣꠐꠣꠄ ꠈꠣꠟꠤ ꠄꠇ ꠌꠤꠎ ꠅꠄ। ");
INSERT INTO syls_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","ꠄꠞ ꠒꠣꠈꠘꠣ ꠖꠥꠁꠅꠈꠣꠘ ꠃꠙꠞꠦꠖꠤ ꠝꠦꠟꠣꠁꠟ ꠞꠁꠛ, ꠀꠞ ꠄꠞ ꠍꠣꠄꠀꠞ ꠔꠟꠦ ꠕꠣꠇꠛ ꠡꠘ꠆ꠖꠥꠇꠞ ꠓꠣꠇꠘꠣ। ꠖꠥꠁꠅ ꠇꠣꠞꠥꠛꠤ ꠝꠥꠈꠣꠝꠥꠈꠤ ꠃꠛꠣ ꠕꠣꠇꠛ, ꠀꠞ ꠔꠣꠞꠣꠞ ꠌꠃꠈ ꠞꠁꠛ ꠓꠣꠇꠘꠣꠞ ꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","ꠁ ꠓꠣꠇꠘꠣꠞꠦ ꠡꠘ꠆ꠖꠥꠇꠞ ꠃꠙꠞꠦ ꠟꠣꠉꠣꠁꠅ, ꠀꠞ ꠀꠝꠣꠞ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠟꠦꠈꠣ ꠎꠦ ꠡꠣꠢꠣꠖꠔ ꠙꠣꠔ꠆ꠔꠞ ꠔꠥꠝꠣꠞꠦ ꠖꠤꠝꠥ, ꠅꠃ ꠙꠣꠔ꠆ꠔꠞ ꠔꠥꠝꠤ ꠡꠘ꠆ꠖꠥꠇꠞ ꠜꠤꠔꠞꠦ ꠕꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","ꠁ ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇꠞ ꠓꠣꠇꠘꠣꠞ ꠃꠙꠞꠦ ꠖꠥꠁꠅ ꠇꠣꠞꠥꠛꠤꠞ ꠝꠣꠎꠈꠣꠘꠅ, ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠖꠤꠖꠣꠞ ꠖꠤꠝꠥ। ꠅꠃ ꠖꠤꠖꠣꠞꠞ ꠡꠝꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠣꠉꠤ ꠀꠝꠣꠞ ꠢꠇꠟ ꠀꠁꠘ-ꠇꠣꠘꠥꠘ ꠎꠣꠘꠣꠁꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤ ꠖꠤꠀ ꠖꠥꠁ ꠀꠔ ꠟꠣꠝ꠆ꠛꠣ, ꠄꠇ ꠀꠔ ꠙꠣꠡ ꠀꠞ ꠖꠦꠠ ꠀꠔ ꠃꠌꠣ ꠇꠞꠤ ꠄꠇꠈꠣꠘ ꠐꠦꠛꠥꠟ ꠛꠣꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","ꠅꠈꠣꠘꠞꠦ ꠈꠣꠐꠤ ꠡꠥꠘꠣꠖꠤ ꠟꠦꠙꠤꠀ ꠌꠣꠁꠞꠅ ꠇꠤꠘꠣꠞꠅ ꠘꠇꠡꠣ ꠟꠣꠉꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","ꠐꠦꠛꠥꠟꠞ ꠌꠣꠁꠞꠅ ꠇꠤꠘꠣꠞꠅ ꠌꠣꠁꠞ ꠀꠋꠉꠥꠟ ꠃꠌꠣ ꠇꠞꠤ ꠄꠇ ꠢꠣꠎ ꠖꠤꠛꠣꠄ, ꠢꠣꠎꠞ ꠝꠣꠎꠦ ꠡꠥꠘꠣꠖꠤ ꠘꠇꠡꠣ ꠇꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","ꠐꠦꠛꠥꠟꠞ ꠌꠣꠁꠞꠅ ꠇꠥꠘꠣꠔ ꠌꠣꠁꠞꠅ ꠙꠣꠄꠀꠞ ꠃꠙꠞꠦ ꠡꠥꠘꠣꠞ ꠌꠣꠁꠞꠐꠣ ꠇꠠꠣ ꠟꠣꠉꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","ꠁ ꠌꠣꠁꠞꠅ ꠇꠠꠣꠁꠘ ꠐꠦꠛꠥꠟꠞ ꠇꠥꠘꠣꠞ ꠢꠃ ꠃꠌꠣ ꠢꠣꠎꠞ ꠔꠟꠦ ꠟꠣꠉꠣꠁꠅ, ꠎꠣꠔꠦ ꠐꠦꠛꠥꠟ ꠛꠁꠀ ꠘꠦꠅꠀꠞ ꠛꠣꠟꠣ ꠇꠠꠣꠞ ꠜꠤꠔꠞꠦ ꠛꠦꠘ꠆ꠖꠣ ꠢꠣꠞꠣꠁꠟ ꠎꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","ꠛꠦꠘ꠆ꠖꠣ ꠖꠥꠁꠅꠐꠣ ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤꠖꠤ ꠛꠣꠘꠣꠁꠀ ꠡꠥꠘꠣꠖꠤ ꠟꠦꠙꠤꠛꠣꠄ, ꠅꠃ ꠛꠦꠘ꠆ꠖꠣꠖꠤ ꠐꠦꠛꠥꠟ ꠛꠁꠀ ꠘꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","ꠐꠦꠛꠥꠟꠞ ꠃꠙꠞꠞ ꠕꠣꠟ-ꠛꠣꠡꠘ, ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠦ ꠓꠣꠟꠤꠀ ꠖꠤꠛꠣꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣꠞ ꠎꠉ ꠀꠞ ꠝꠉ, ꠢꠇꠟꠔꠣ ꠈꠣꠐꠤ ꠡꠥꠘꠣꠖꠤ ꠛꠣꠘꠣꠘꠤ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","ꠅꠃ ꠐꠦꠛꠥꠟꠞ ꠃꠙꠞꠦ ꠀꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠢꠣꠝꠦꠡꠣ ꠙꠛꠤꠔ꠆ꠞ ꠞꠥꠐꠤ ꠞꠣꠈꠛꠣꠄ, ꠁ ꠞꠥꠐꠤ ꠎꠣꠘꠥ ꠡꠛ ꠡꠝꠄ ꠕꠅꠀ ꠅꠄ।” ");
INSERT INTO syls_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠈꠣꠐꠤ ꠡꠥꠘꠣꠖꠤ ꠄꠇꠈꠣꠘ ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤ ꠛꠣꠘꠣꠁꠛꠣꠄ, ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤꠞ ꠔꠟꠣ ꠀꠞ ꠒꠣꠘ꠆ꠒꠤ ꠈꠣꠐꠤ ꠡꠥꠘꠣ ꠙꠤꠐꠣꠁꠀ ꠉꠠꠣꠁꠛꠣꠄ। ꠅꠃ ꠒꠣꠘ꠆ꠒꠤ, ꠚꠥꠟꠞ ꠟꠣꠈꠣꠘ ꠙꠤꠀꠟꠣ, ꠇꠥꠠꠤ ꠀꠞ ꠙꠣꠙꠠꠤ ꠅꠇꠟ, ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤꠞ ꠢꠇꠟꠔꠣꠄ ꠄꠇꠟꠉꠦ ꠄꠇ ꠙꠤꠍ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤꠞ ꠒꠣꠘ꠆ꠒꠤꠞ ꠖꠥꠁ ꠉꠣꠟꠣꠔ ꠔꠤꠘꠐꠣ ꠇꠞꠤ ꠝꠥꠐ ꠍꠄꠐꠣ ꠒꠣꠟ ꠕꠣꠇꠛ। ");
INSERT INTO syls_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ꠙꠞꠔꠦꠇ ꠒꠣꠟꠞ ꠝꠣꠎꠦ ꠎꠛꠣ ꠚꠥꠟꠞ ꠟꠣꠈꠣꠘ ꠔꠤꠘꠉꠥ ꠇꠞꠤ ꠙꠤꠀꠟꠣ ꠕꠣꠇꠛ। ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤꠞ ꠍꠄꠅ ꠒꠣꠟꠅ ꠄꠇꠟꠣꠈꠣꠘ ꠇꠣꠝ ꠇꠞꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤꠞ ꠝꠥꠟ ꠒꠣꠘ꠆ꠒꠤꠞ ꠝꠣꠎꠦꠅ ꠎꠛꠣ ꠚꠥꠟꠞ ꠟꠣꠈꠣꠘ ꠌꠣꠁꠞꠐꠣ ꠙꠤꠀꠟꠣ ꠕꠣꠇꠛ। ");
INSERT INTO syls_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","ꠅꠃ ꠝꠥꠟ ꠒꠣꠘ꠆ꠒꠤ ꠕꠣꠇꠤ ꠛꠣꠞꠅꠁꠟ ꠍꠄꠐꠣ ꠒꠣꠟꠞ ꠝꠣꠎꠦ, ꠙꠄꠟꠣ ꠖꠥꠁꠅ ꠒꠣꠟꠞ ꠎꠥꠠꠣꠔ ꠄꠉꠥ ꠇꠥꠠꠤ, ꠖꠥꠍꠞꠣ ꠖꠥꠁꠅ ꠒꠣꠟꠞ ꠎꠥꠠꠣꠔ ꠀꠞꠇ ꠇꠥꠠꠤ, ꠀꠞ ꠢꠦꠡꠞ ꠖꠥꠁꠅ ꠒꠣꠟꠞ ꠎꠥꠠꠣꠔꠅ ꠇꠥꠠꠤ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","ꠇꠥꠠꠤ ꠀꠞ ꠒꠣꠟ ꠢꠇꠟꠔꠣ ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁꠛ, ꠢꠇꠟꠔꠣ ꠝꠤꠟꠤꠀ ꠄꠇ ꠌꠤꠎ ꠅꠁꠛ। ꠀꠡ꠆ꠔꠣꠐꠣꠃ ꠈꠣꠐꠤ ꠡꠥꠘꠣ ꠙꠤꠐꠣꠁꠀ ꠛꠣꠘꠣꠘꠤ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","ꠄꠞꠛꠣꠖꠦ ꠡꠣꠔꠐꠣ ꠌꠦꠞꠣꠉ ꠛꠣꠘꠣꠁꠀ ꠅꠃ ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤꠞ ꠃꠙꠞꠦ ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠞꠤ ꠟꠣꠉꠣꠘꠤ ꠟꠣꠉꠛ, ꠎꠣꠔꠦ ꠌꠦꠞꠣꠉ ꠅꠇꠟ ꠎꠣꠟꠣꠘꠤꠞ ꠛꠣꠖꠦ ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤꠞ ꠍꠣꠝꠘꠣ ꠚꠞ ꠅꠄ। ");
INSERT INTO syls_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","ꠌꠦꠞꠣꠉꠞ ꠚꠤꠔꠣ ꠍꠣꠚ ꠇꠞꠣꠞ ꠌꠤꠝꠐꠣ ꠀꠞ ꠎꠣꠟꠣꠁꠟ ꠚꠤꠔꠣꠞ ꠍꠣꠟꠤ ꠕꠅꠀꠞ ꠟꠣꠉꠤ ꠇꠄꠉꠥ ꠛꠣꠐꠤ, ꠈꠣꠐꠤ ꠡꠥꠘꠣꠖꠤ ꠛꠣꠘꠣꠘꠤ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤꠞ ꠢꠇꠟꠔꠣ ꠛꠣꠘꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠇ ꠝꠘ ꠈꠣꠐꠤ ꠡꠥꠘꠣ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","“ꠢꠥꠘꠅ, ꠅꠃ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠔꠥꠝꠣꠞꠦ ꠎꠦꠟꠣ ꠘꠇꠡꠣ ꠖꠦꠈꠣꠁꠟ ꠅꠁꠟ, ꠄꠇ꠆ꠇꠦꠞꠦ ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠞꠤ ꠢꠇꠟꠔꠣ ꠛꠣꠘꠣꠁꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠖꠡ ꠐꠥꠇꠞꠣ ꠙꠦꠌꠣꠁꠟ ꠡꠥꠔꠣꠞ ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠꠖꠤ ꠀꠝꠣꠞ ꠊꠞꠞ ꠙꠞ꠆ꠖꠣꠁꠘ ꠛꠣꠘꠣꠁꠅ। ꠀꠞ ꠟꠤꠟꠥꠀ, ꠛꠣꠁꠋꠉꠘꠤ, ꠟꠣꠟ ꠡꠥꠔꠣꠖꠤ ꠜꠣꠟꠣ ꠃꠡ꠆ꠔꠣꠖꠞꠦꠖꠤ ꠄꠞ ꠝꠣꠎꠦ ꠇꠣꠞꠥꠛꠤ ꠅꠇꠟꠞ ꠍꠛꠤ ꠛꠣꠁꠘ ꠇꠞꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ꠢꠇꠟ ꠐꠥꠇꠞꠣꠁꠘ ꠄꠇ ꠝꠣꠙꠞ ꠅꠁꠛ, ꠟꠣꠝ꠆ꠛꠣꠄ ꠀꠐꠣꠁꠡ ꠀꠔ ꠀꠞ ꠚꠣꠠꠦ ꠌꠣꠁꠞ ꠀꠔ। ");
INSERT INTO syls_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","ꠁ ꠐꠥꠇꠞꠣꠁꠘ꠆ꠔꠞ ꠙꠣꠌꠈꠣꠘ ꠙꠣꠌꠈꠣꠘ ꠇꠞꠤ ꠄꠇꠈꠣꠘꠅ ꠎꠥꠠꠣ ꠖꠤꠀ, ꠖꠥꠈꠣꠘ ꠛꠠ ꠉꠤꠟꠣꠚ ꠛꠣꠘꠣꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","ꠛꠠ ꠉꠤꠟꠣꠚꠞ ꠙꠄꠟꠣ ꠐꠥꠇꠞꠣꠞ ꠙꠣꠡꠞ ꠄꠇ ꠇꠤꠘꠣꠞꠅ ꠟꠤꠟꠥꠀ ꠡꠥꠔꠣꠖꠤ ꠢꠥꠇꠞ ꠚꠥꠠ ꠛꠣꠘꠣꠁꠔꠦ ꠅꠁꠛ। ꠖꠥꠍꠞꠣ ꠐꠥꠇꠞꠣꠔꠅ ꠅꠃꠟꠣ ꠇꠞꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","ꠙꠄꠟꠣ ꠉꠤꠟꠣꠚꠞ ꠇꠤꠘꠣꠞꠅ ꠙꠁꠘ꠆ꠌꠣꠡꠉꠥ ꠢꠥꠇꠞ ꠚꠥꠠ ꠀꠞ ꠖꠥꠍꠞꠣ ꠉꠤꠟꠣꠚꠅ ꠅꠃꠟꠣ ꠙꠁꠘ꠆ꠌꠣꠡꠉꠥ ꠚꠥꠠ ꠖꠤꠔꠦ ꠅꠁꠛ। ꠖꠥꠁꠅ ꠛꠠ ꠉꠤꠟꠣꠚꠞ ꠢꠥꠇꠞ ꠚꠥꠠ ꠄꠉꠥ ꠀꠞꠦꠉꠥꠞ ꠃꠟꠐꠣꠝꠥꠈꠣ ꠕꠣꠇꠛ। ");
INSERT INTO syls_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","ꠛꠣꠖꠦ ꠡꠥꠘꠣꠖꠤ ꠙꠁꠘ꠆ꠌꠣꠡꠉꠥ ꠢꠥꠇ ꠛꠣꠘꠣꠁꠀ ꠢꠃ ꠚꠥꠠꠞ ꠝꠣꠎꠦꠖꠤ ꠢꠣꠞꠣꠁꠀ, ꠛꠠ ꠖꠥꠁꠅ ꠉꠤꠟꠣꠚꠞꠦ ꠀꠐꠇꠣꠁ ꠖꠤꠅ। ꠔꠦꠃ ꠁ ꠖꠥꠁꠅ ꠐꠥꠇꠞꠣꠖꠤ ꠄꠇꠈꠣꠘ ꠊꠞ ꠔꠤꠀꠞ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“ꠀꠝꠣꠞ ꠊꠞꠞ ꠃꠙꠞ ꠉꠥꠞꠣꠞ ꠟꠣꠉꠤ ꠍꠣꠉꠟꠞ ꠞꠥꠝꠣ ꠖꠤꠀ ꠉꠤꠟꠣꠚꠞ ꠟꠣꠈꠣꠘ ꠄꠉꠣꠞꠅꠈꠣꠘ ꠐꠥꠇꠞꠣ ꠛꠣꠘꠣꠘꠤ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ꠢꠇꠟ ꠐꠥꠇꠞꠣꠁꠘ ꠄꠇ ꠝꠣꠙꠞ ꠅꠁꠛ, ꠔꠤꠡ ꠀꠔ ꠟꠣꠝ꠆ꠛꠣ ꠀꠞ ꠌꠣꠁꠞ ꠀꠔ ꠚꠣꠠ। ");
INSERT INTO syls_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","ꠅꠘ ꠕꠣꠇꠤ ꠙꠣꠌ ꠐꠥꠇꠞꠣ ꠄꠇꠟꠉꠦ ꠎꠥꠠꠣ ꠖꠤꠀ ꠛꠠ ꠄꠇ ꠉꠤꠟꠣꠚ ꠛꠣꠘꠣꠁꠔꠦ ꠅꠁꠛ। ꠀꠞ ꠛꠣꠇꠤ ꠍꠄ ꠐꠥꠇꠞꠣ ꠎꠥꠠꠣ ꠖꠤꠀ, ꠛꠠ ꠀꠞꠇ ꠉꠤꠟꠣꠚ ꠛꠣꠘꠣꠁꠀ ꠢꠣꠞꠟꠦ, ꠅꠃ ꠖꠥꠍꠞꠣ ꠉꠤꠟꠣꠚꠞ ꠎꠦ ꠐꠥꠇꠞꠣ ꠛꠣꠠꠔꠤ ꠞꠁꠛ, ꠅꠈꠣꠘꠞꠦ ꠔꠣꠝ꠆ꠛꠥꠞ ꠍꠣꠝꠘꠞ ꠛꠣꠄ ꠖꠥꠁ ꠜꠣꠁꠘ꠆ꠎ ꠇꠞꠤ ꠖꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","ꠙꠄꠟꠣ ꠛꠠ ꠉꠤꠟꠣꠚꠞ ꠙꠣꠡꠞ ꠄꠇ ꠇꠤꠘꠣꠞꠅ ꠙꠁꠘ꠆ꠌꠣꠡꠉꠥ ꠢꠥꠇꠞ ꠚꠥꠠ ꠛꠣꠘꠣꠁꠔꠦ ꠅꠁꠛ, ꠀꠞ ꠖꠥꠍꠞꠣ ꠉꠤꠟꠣꠚꠅ-ꠅ ꠅꠃꠟꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","ꠛꠣꠖꠦ ꠙꠤꠔꠟ ꠖꠤꠀ ꠙꠁꠘ꠆ꠌꠣꠡꠉꠥ ꠢꠥꠇ ꠛꠣꠘꠣꠁꠀ ꠢꠃ ꠢꠥꠇꠞ ꠚꠥꠠꠞ ꠝꠣꠎꠦ ꠢꠣꠞꠣꠁꠀ, ꠅꠃ ꠛꠠ ꠖꠥꠁꠅ ꠉꠤꠟꠣꠚ ꠄꠇꠈꠣꠘꠅ ꠎꠥꠠꠣ ꠖꠤꠔꠦ ꠅꠁꠛ। ꠔꠦꠃ ꠁ ꠖꠥꠁꠅ ꠉꠤꠟꠣꠚ ꠝꠤꠟꠤꠀ ꠄꠇꠈꠣꠘ ꠍꠣꠘꠤ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","ꠍꠣꠉꠟꠞ ꠞꠥꠝꠣꠞ ꠛꠠ ꠉꠤꠟꠣꠚꠞ ꠎꠦ ꠀꠗꠣ ꠐꠥꠇꠞꠣ ꠛꠣꠠꠔꠤ ꠅꠁꠛ, ꠁꠈꠣꠘ ꠈꠞꠦꠖꠤ ꠟꠐꠇꠣꠁꠟ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","ꠁ ꠉꠤꠟꠣꠚ ꠈꠣꠘ ꠔꠟꠞ ꠇꠣꠙꠠ ꠕꠣꠇꠤ ꠄꠇ ꠀꠔ ꠛꠠ ꠅꠀꠄ ꠁꠈꠣꠘ ꠖꠥꠁꠅ ꠉꠣꠟꠣꠛꠣꠄ ꠟꠐꠇꠣꠁꠟ ꠞꠁꠀ ꠢꠣꠞꠣ ꠊꠞꠞꠦ ꠉꠥꠞꠤꠟꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","ꠄꠞ ꠃꠙꠞ ꠉꠥꠞꠣꠞ ꠟꠣꠉꠤ ꠟꠣꠟ ꠞꠋ ꠇꠞꠣ ꠝꠦꠠꠣꠞ ꠌꠣꠝꠠꠣꠖꠤ ꠀꠞꠅꠈꠣꠘ ꠉꠤꠟꠣꠚ ꠛꠣꠘꠣꠁꠀ ꠉꠥꠞꠤ ꠖꠤꠔꠦ ꠅꠁꠛ। ꠛꠣꠖꠦ ꠄꠞ ꠃꠙꠞꠦ ꠖꠞꠤꠀꠞ ꠚꠥʼ ꠝꠣꠍꠞ ꠌꠣꠝꠠꠣꠖꠤ ꠍꠣꠘꠤ ꠔꠂꠀꠞ ꠇꠞꠤ ꠉꠥꠞꠤ ꠖꠤꠔꠦ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠊꠞꠞ ꠟꠣꠉꠤ ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤꠖꠤ ꠇʼꠈꠣꠘ ꠚ꠆ꠞꠦꠁꠝ ꠛꠣꠘꠣꠘꠤ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","ꠙꠞꠔꠦꠇ ꠚ꠆ꠞꠦꠁꠝ ꠛꠣꠘꠣꠁꠛꠣꠄ ꠖꠡ ꠀꠔ ꠟꠣꠝ꠆ꠛꠣ ꠀꠞ ꠖꠦꠠ ꠀꠔ ꠚꠣꠠ। ");
INSERT INTO syls_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","ꠅꠃ ꠚ꠆ꠞꠦꠁꠝꠅ ꠖꠥꠉꠥ ꠇꠞꠤ ꠙꠣꠄꠀ ꠕꠣꠇꠛ। ꠢꠇꠟ ꠚ꠆ꠞꠦꠁꠝ ꠄꠇꠟꠣꠈꠣꠘ ꠛꠣꠘꠣꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","ꠖꠇ꠆ꠇꠤꠘ ꠉꠣꠟꠣꠞ ꠟꠣꠉꠤ ꠛꠤꠡꠈꠣꠘ ꠚ꠆ꠞꠦꠁꠝ ꠛꠣꠘꠣꠘꠤ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ꠁ ꠚ꠆ꠞꠦꠁꠝꠞ ꠙꠣꠄꠀꠞ ꠔꠟꠦ ꠖꠦꠅꠀꠞ ꠟꠣꠉꠤ ꠌꠣꠟ꠆ꠟꠤꠡꠉꠥ ꠞꠥꠙꠣꠞ ꠌꠥꠘ꠆ꠉꠤ ꠛꠣꠘꠣꠘꠤ ꠟꠣꠉꠛ, ꠙꠞꠔꠦꠇ ꠚ꠆ꠞꠦꠁꠝꠞ ꠖꠥꠁ ꠙꠣꠄꠀꠞ ꠟꠣꠉꠤ ꠖꠥꠉꠥ ꠌꠥꠘ꠆ꠉꠤ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","ꠀꠝꠣꠞ ꠊꠞꠞ ꠃꠔ꠆ꠔꠞ ꠉꠣꠟꠣꠞ ꠟꠣꠉꠤꠀꠅ ꠛꠤꠡꠈꠣꠘ ꠚ꠆ꠞꠦꠁꠝ ꠟꠣꠉꠛ, ");
INSERT INTO syls_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ꠀꠞ ꠙꠞꠔꠦꠇ ꠚ꠆ꠞꠦꠁꠝꠞ ꠙꠣꠄꠀꠞ ꠔꠟꠞ ꠟꠣꠉꠤ ꠖꠥꠉꠥ ꠇꠞꠤ ꠌꠣꠟ꠆ꠟꠤꠡꠉꠥ ꠞꠥꠙꠣꠞ ꠌꠥꠘ꠆ꠉꠤ ꠛꠣꠘꠣꠘꠤ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","ꠙꠁꠌꠝꠞ ꠉꠣꠟꠣꠞ ꠟꠣꠉꠤ, ꠝꠣꠘꠤ ꠈꠞ ꠉꠣꠟꠣꠞ ꠟꠣꠉꠤ ꠍꠄꠈꠣꠘ ꠚ꠆ꠞꠦꠁꠝ, ");
INSERT INTO syls_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ꠀꠞ ꠈꠞꠞ ꠖꠥꠁꠅ ꠇꠥꠘꠣꠞ ꠟꠣꠉꠤ ꠀꠞꠅ ꠖꠥꠈꠣꠘ ꠚ꠆ꠞꠦꠁꠝ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","ꠁ ꠖꠥꠁ ꠚ꠆ꠞꠦꠁꠝꠞꠦ ꠖꠥꠁ ꠇꠥꠘꠣꠞ ꠖꠥꠁꠅ ꠚ꠆ꠞꠦꠁꠝꠞ ꠟꠉꠦ ꠔꠟꠦ-ꠃꠙꠞꠦ ꠄꠇꠈꠣꠘꠅ ꠎꠥꠠꠣ ꠖꠤꠔꠦ ꠅꠁꠛ। ꠙꠞꠔꠦꠇ ꠇꠥꠘꠣꠞ ꠖꠥꠁ ꠚ꠆ꠞꠦꠁꠝ ꠗꠣꠞꠞ ꠚ꠆ꠞꠦꠁꠝꠞ ꠟꠉꠦ ꠛꠣꠔ꠆ꠔꠤ ꠝꠣꠞꠤꠀ ꠄꠇꠟꠉꠦ ꠎꠥꠠꠣ ꠖꠤꠔꠦ ꠅꠁꠛ। ꠖꠥꠁꠅ ꠇꠥꠘꠣ ꠄꠇꠟꠣꠈꠣꠘ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","ꠔꠦꠃ ꠈꠞꠦꠖꠤ ꠀꠐꠈꠣꠘ ꠚ꠆ꠞꠦꠁꠝ ꠅꠁꠛ, ꠀꠞ ꠙꠞꠔꠦꠇ ꠚ꠆ꠞꠦꠁꠝꠞ ꠔꠟꠦ ꠖꠦꠅꠀꠞ ꠟꠣꠉꠤ ꠖꠥꠉꠥ ꠇꠞꠤ ꠡꠥꠟꠉꠥ ꠞꠥꠙꠣꠞ ꠌꠥꠘ꠆ꠉꠤ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“ꠔꠥꠝꠤ ꠚ꠆ꠞꠦꠁꠝꠞꠦ ꠎꠥꠠꠣ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤꠖꠤ ꠇꠄꠉꠥ ꠟꠣꠝ꠆ꠛꠣ ꠛꠣꠔ꠆ꠔꠤ ꠛꠣꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ꠄꠞ ꠝꠣꠎꠦ ꠙꠣꠌꠉꠥ ꠛꠣꠔ꠆ꠔꠤ ꠊꠞꠞ ꠄꠇ ꠉꠣꠟꠣꠞ ꠟꠣꠉꠤ, ꠀꠞ ꠛꠣꠇꠤ ꠙꠣꠌꠉꠥ ꠀꠞꠇ ꠉꠣꠟꠣꠞ ꠟꠣꠉꠤ, ꠀꠞ ꠙꠣꠌꠉꠥ ꠟꠣꠉꠛ ꠈꠞ ꠉꠣꠟꠣ, ꠝꠣꠘꠤ ꠙꠌꠤꠝ ꠉꠣꠟꠣꠞ ꠚ꠆ꠞꠦꠁꠝꠞ ꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","ꠚ꠆ꠞꠦꠁꠝꠞ ꠝꠣꠎꠈꠣꠘꠅ ꠟꠣꠉꠣꠁꠟ ꠅꠃ ꠛꠣꠔ꠆ꠔꠤꠖꠤ ꠢꠇꠟ ꠚ꠆ꠞꠦꠁꠝꠞ ꠄꠇ ꠝꠣꠕꠣ ꠕꠣꠇꠤ ꠀꠞꠇ ꠝꠣꠕꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠀꠐꠇꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","ꠚ꠆ꠞꠦꠁꠝ ꠈꠣꠘꠣꠁꠘ ꠡꠥꠘꠣꠖꠤ ꠟꠦꠙꠔꠦ ꠅꠁꠛ, ꠀꠞ ꠛꠣꠔ꠆ꠔꠤ ꠢꠣꠞꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠡꠥꠘꠣꠞ ꠇꠠꠣ ꠛꠣꠘꠣꠁꠀ ꠚ꠆ꠞꠦꠁꠝꠅ ꠟꠣꠉꠣꠁꠔꠦ ꠅꠁꠛ। ꠁ ꠛꠣꠔ꠆ꠔꠤ ꠅꠇꠟꠅ ꠡꠥꠘꠣꠖꠤ ꠟꠦꠙꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","ꠀꠝꠣꠞ ꠊꠞꠞ ꠎꠦ ꠘꠇꠡꠣ ꠔꠥꠝꠣꠞꠦ ꠅꠃ ꠔꠥꠞ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠖꠦꠈꠣꠁꠟꠣꠝ, ꠔꠥꠝꠤ ꠄꠇ꠆ꠇꠦꠞꠦ ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠞꠤ ꠁꠐꠣ ꠔꠂꠀꠞ ꠇꠞꠣꠁꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠟꠤꠟꠥꠀ, ꠟꠣꠟ, ꠛꠣꠁꠋꠉꠘꠤ ꠡꠥꠔꠣ ꠀꠞ ꠙꠦꠌꠣꠁꠟ ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠꠖꠤ ꠄꠇꠈꠣꠘ ꠙꠞ꠆ꠖꠣ ꠛꠣꠘꠣꠁꠅ। ꠜꠣꠟꠣ ꠇꠥꠘꠥ ꠃꠡ꠆ꠔꠣꠖꠞꠦꠖꠤ ꠄꠞ ꠃꠙꠞꠦ ꠇꠣꠞꠥꠛꠤ ꠅꠇꠟꠞ ꠍꠛꠤ ꠛꠣꠁꠘ ꠇꠞꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","ꠁ ꠙꠞ꠆ꠖꠣꠈꠣꠘ ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤꠖꠤ ꠌꠣꠁꠞꠐꠣ ꠈꠥꠐꠤꠞ ꠟꠉꠦ ꠟꠣꠉꠣꠁꠀ ꠡꠥꠘꠣꠞ ꠇꠠꠣꠖꠤ ꠟꠐꠇꠣꠁ ꠖꠤꠛꠣꠄ, ꠈꠥꠐꠤꠞ ꠝꠣꠕꠣꠔ ꠡꠥꠘꠣꠞ ꠇꠠꠣ ꠟꠣꠉꠣꠁꠛꠣꠄ। ꠀꠞ ꠈꠥꠐꠤꠉꠥꠁꠘ ꠡꠥꠘꠣꠖꠤ ꠟꠦꠙꠣꠁꠛꠣꠄ, ꠈꠥꠐꠤꠞ ꠔꠟꠣꠔ ꠞꠥꠙꠣꠞ ꠌꠥꠘ꠆ꠉꠤ ꠟꠣꠉꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","ꠙꠞ꠆ꠖꠣꠞ ꠃꠙꠞꠞ ꠡꠥꠔꠤ ꠇꠣꠙꠠꠅ ꠟꠣꠉꠣꠁꠟ ꠢꠥꠇꠞ ꠟꠉꠦ ꠙꠞ꠆ꠖꠣꠈꠣꠘ ꠟꠐꠇꠣꠁꠟ ꠞꠁꠛ। ꠁ ꠙꠞ꠆ꠖꠣꠞ ꠈꠞꠦ ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇ ꠕꠁꠛꠣꠄ। ꠙꠞ꠆ꠖꠣꠖꠤ ꠀꠝꠣꠞ ꠊꠞꠞ ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚ, ꠝꠣꠘꠤ ꠈꠣꠍ ꠙꠣꠇ ꠎꠣꠉꠣ ꠀꠞ ꠙꠣꠇ ꠎꠣꠉꠣꠞ ꠝꠣꠎꠈꠣꠘꠅ ꠛꠦꠠꠣ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","ꠅꠃ ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚꠞ ꠜꠤꠔꠞꠦ ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇꠞ ꠃꠙꠞꠦ ꠄꠞ ꠓꠣꠇꠘꠣ ꠟꠣꠉꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","ꠁ ꠙꠞ꠆ꠖꠣꠞ ꠛꠣꠞꠦ ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚꠞ ꠃꠔ꠆ꠔꠞ ꠉꠣꠟꠣꠔ ꠙꠛꠤꠔ꠆ꠞ ꠞꠥꠐꠤ ꠞꠣꠈꠣꠞ ꠐꠦꠛꠥꠟꠈꠣꠘ ꠕꠁꠅ, ꠀꠞ ꠄꠞ ꠃꠟꠐꠣꠝꠥꠈꠣ ꠖꠇ꠆ꠇꠤꠘ ꠉꠣꠟꠣꠔ ꠕꠁꠅ ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤ। ");
INSERT INTO syls_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“ꠀꠝꠣꠞ ꠊꠞꠞ ꠖꠥꠀꠞꠞ ꠟꠣꠉꠤ ꠄꠇꠈꠣꠘ ꠙꠞ꠆ꠖꠣ ꠛꠣꠘꠣꠁꠅ, ꠁꠈꠣꠘ ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠꠖꠤ ꠛꠣꠘꠣꠁꠀ ꠢꠣꠞꠤ, ꠟꠤꠟꠥꠀ, ꠛꠣꠁꠋꠉꠘꠤ, ꠟꠣꠟ ꠞꠋꠉꠞ ꠡꠥꠔꠣꠖꠤ ꠘꠇꠡꠣ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","ꠁ ꠙꠞ꠆ꠖꠣꠞ ꠟꠣꠉꠤ ꠡꠥꠘꠣꠞ ꠇꠠꠣ ꠀꠞ ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤꠞ ꠙꠣꠌꠐꠣ ꠈꠥꠐꠤ ꠛꠣꠘꠣꠁꠅ। ꠈꠥꠐꠤꠉꠥꠁꠘ ꠡꠥꠘꠣꠖꠤ ꠟꠦꠙꠣꠁꠅ, ꠈꠥꠐꠤꠞ ꠔꠟꠣꠔ ꠙꠤꠔꠟꠞ ꠙꠣꠌꠉꠥ ꠌꠥꠘ꠆ꠉꠤ ꠟꠣꠉꠣꠁꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤꠖꠤ ꠙꠣꠌ ꠀꠔ ꠟꠣꠝ꠆ꠛꠣ, ꠙꠣꠌ ꠀꠔ ꠙꠣꠡ ꠀꠞ ꠔꠤꠘ ꠀꠔ ꠃꠛꠤ ꠖꠤꠀ ꠌꠣꠁꠞꠇꠥꠘꠤ ꠇꠞꠤ ꠄꠇꠈꠣꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠔꠂꠀꠞ ꠇꠞꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","ꠄꠞ ꠌꠣꠁꠞꠅ ꠇꠥꠘꠣꠞ ꠃꠙꠞꠦ ꠟꠣꠇꠠꠤꠖꠤ ꠌꠣꠁꠞꠐꠣ ꠢꠤꠋ ꠖꠤꠅ। ꠅꠃ ꠢꠤꠋ ꠇꠥꠘꠣꠞ ꠟꠣꠇꠠꠤ ꠈꠥꠖꠤꠀ ꠛꠣꠘꠣꠘꠤ ꠟꠣꠉꠛ, ꠁ ꠀꠡ꠆ꠔꠣꠈꠣꠘ ꠄꠇ ꠌꠤꠎ ꠅꠁꠛ। ꠛꠣꠖꠦ ꠙꠥꠞꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠙꠤꠔꠟꠖꠤ ꠟꠦꠙꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠍꠣꠟꠤ ꠔꠥꠟꠣꠞ ꠛꠠ ꠌꠣꠝꠌ ꠀꠞ ꠉꠣꠝꠟꠣ, ꠟꠃ ꠕꠅꠀꠞ ꠛꠣꠐꠤ, ꠉꠥꠡ꠆ꠔ ꠔꠥꠟꠣꠞ ꠛꠠ ꠇꠣꠐꠣ-ꠍꠤꠚ, ꠀꠋꠞꠣ ꠕꠅꠀꠞ ꠙꠣꠔꠤꠟ, ꠢꠇꠟꠔꠣ ꠙꠤꠔꠟꠖꠤ ꠛꠣꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","ꠙꠤꠔꠟꠖꠤ ꠄꠇꠈꠣꠘ ꠎꠣꠟꠤ ꠛꠣꠘꠣꠁꠛꠣꠄ। ꠄꠞ ꠌꠣꠁꠞ ꠇꠥꠘꠣꠔ ꠌꠣꠁꠞꠐꠣ ꠙꠤꠔꠟꠞ ꠇꠠꠣ ꠟꠣꠉꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠔꠟꠣ ꠕꠣꠇꠤ ꠃꠙꠞꠞ ꠝꠣꠎꠣꠝꠣꠎꠤ ꠎꠣꠉꠣꠞ ꠔꠣꠠꠤꠀꠞ ꠔꠟꠦ ꠅꠃ ꠎꠣꠟꠤ ꠛꠅꠀꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠁꠀ ꠘꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤꠖꠤ ꠖꠥꠉꠥ ꠛꠦꠘ꠆ꠖꠣ ꠛꠣꠘꠣꠁꠅ, ꠛꠣꠘꠣꠁꠀ ꠖꠥꠁꠅꠉꠥ ꠙꠤꠔꠟꠖꠤ ꠟꠦꠙꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","ꠁ ꠛꠦꠘ꠆ꠖꠣꠁꠘ ꠇꠠꠣꠞ ꠜꠤꠔꠞꠦꠖꠤ ꠢꠣꠞꠣꠘꠤ ꠟꠣꠉꠛ। ꠔꠦꠃ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠁꠀ ꠘꠦꠅꠀꠞ ꠛꠣꠟꠣ ꠖꠥꠁꠅ ꠛꠦꠘ꠆ꠖꠣꠁꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠖꠥꠁ ꠉꠣꠟꠣꠛꠣꠄ ꠕꠣꠇꠛ। ");
INSERT INTO syls_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠔꠇ꠆ꠔꠣꠖꠤ ꠛꠣꠘꠣꠁꠀ ꠄꠞ ꠜꠤꠔꠞꠦ ꠚꠣꠇ ꠞꠣꠈꠤꠅ। ꠀꠝꠤ ꠅꠃ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠔꠥꠝꠣꠞꠦ ꠎꠦꠟꠣ ꠘꠇꠡꠣ ꠖꠦꠈꠣꠁꠟꠣꠝ, ꠄꠇ꠆ꠇꠦꠞꠦ ꠅꠟꠣꠈꠣꠘ ꠇꠞꠤ ꠛꠣꠘꠣꠘꠤ ꠟꠅꠀꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“ꠀꠝꠣꠞ ꠊꠞꠞ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠃꠑꠣꠘ ꠕꠣꠇꠛ। ꠄꠞ ꠖꠇ꠆ꠇꠤꠘ ꠉꠣꠟꠣꠛꠣꠄ ꠄꠇ-ꠡ ꠀꠔ ꠞꠣꠈꠤꠅ, ꠁ ꠝꠥꠈꠣ ꠖꠤꠛꠣꠄ ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠꠞ ꠙꠞ꠆ꠖꠣ। ");
INSERT INTO syls_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","ꠁ ꠙꠞ꠆ꠖꠣ ꠐꠣꠘꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠛꠤꠡꠉꠥ ꠈꠥꠐꠤ ꠖꠤꠛꠣꠄ। ꠈꠥꠐꠤꠞ ꠔꠟꠣꠔ ꠖꠤꠛꠣꠄ ꠄꠇꠐꠣ ꠇꠞꠤ ꠙꠤꠔꠟꠞ ꠌꠥꠘ꠆ꠉꠤ, ꠙꠞ꠆ꠖꠣ ꠐꠣꠘꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠞꠥꠙꠣꠞ ꠇꠠꠣ ꠀꠞ ꠛꠣꠘ꠆ꠖꠤꠛꠣꠞ ꠔꠣꠞ ꠟꠣꠉꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","ꠃꠔ꠆ꠔꠞ ꠉꠣꠟꠣꠛꠣꠄ ꠄꠇ-ꠡ ꠀꠔ ꠃꠑꠣꠘ ꠞꠣꠈꠛꠣꠄ। ꠢꠘꠅ-ꠅ ꠙꠞ꠆ꠖꠣ ꠖꠤꠅ, ꠛꠤꠡꠉꠥ ꠈꠥꠐꠤ, ꠛꠤꠡꠉꠥ ꠙꠤꠔꠟꠞ ꠌꠥꠘ꠆ꠉꠤ, ꠈꠥꠐꠤꠞ ꠟꠉꠦ ꠟꠣꠉꠣꠁꠅ ꠞꠥꠙꠣꠞ ꠇꠠꠣ ꠀꠞ ꠔꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","ꠙꠁꠌꠝꠦ ꠙꠁꠘ꠆ꠌꠣꠡ ꠀꠔ ꠃꠑꠣꠘ ꠞꠣꠈꠤꠅ, ꠢꠘꠅ-ꠅ ꠇꠄꠈꠣꠘ ꠙꠞ꠆ꠖꠣ, ꠖꠡꠉꠥ ꠈꠥꠐꠤ, ꠙꠞꠔꠦꠇ ꠈꠥꠐꠤꠞ ꠔꠟꠣꠔ ꠄꠇꠐꠣ ꠇꠞꠤ ꠌꠥꠘ꠆ꠉꠤ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","ꠙꠥꠛꠦꠖꠤꠅ ꠙꠁꠘ꠆ꠌꠣꠡ ꠀꠔ ꠃꠑꠣꠘ ꠞꠣꠈꠤꠅ; ");
INSERT INTO syls_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","ꠉꠦꠁꠐꠞ ꠄꠇ ꠉꠣꠟꠣꠔ ꠙꠘꠞ ꠀꠔ ꠟꠣꠝ꠆ꠛꠣ ꠙꠞ꠆ꠖꠣ, ꠔꠤꠘꠐꠣ ꠈꠥꠐꠤ ꠀꠞ ꠔꠤꠘꠐꠣ ꠌꠥꠘ꠆ꠉꠤ ꠟꠣꠉꠣꠁꠛꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","ꠅꠟꠣ ꠖꠥꠍꠞꠣ ꠉꠣꠟꠣꠔꠅ ꠙꠘꠞ ꠀꠔ ꠙꠞ꠆ꠖꠣ, ꠔꠤꠘꠐꠣ ꠈꠥꠐꠤ ꠀꠞ ꠔꠤꠘꠐꠣ ꠌꠥꠘ꠆ꠉꠤ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","ꠃꠑꠣꠘꠞ ꠉꠦꠁꠐꠞ ꠟꠣꠉꠤ ꠌꠣꠁꠞꠐꠣ ꠈꠥꠐꠤ, ꠌꠣꠁꠞꠐꠣ ꠌꠥꠘ꠆ꠉꠤ ꠀꠞ ꠛꠤꠡ ꠀꠔ ꠟꠣꠝ꠆ꠛꠣ ꠄꠇꠈꠣꠘ ꠙꠞ꠆ꠖꠣ। ꠙꠞ꠆ꠖꠣꠈꠣꠘ ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠꠖꠤ ꠛꠣꠘꠣꠁꠀ ꠟꠤꠟꠥꠀ, ꠛꠣꠁꠋꠉꠘꠤ, ꠟꠣꠟ ꠡꠥꠔꠣꠖꠤ ꠘꠇꠡꠣ ꠇꠞꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","ꠃꠑꠣꠘꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠞ ꠢꠇ꠆ꠇꠟ ꠈꠥꠐꠤꠞꠦ ꠛꠣꠘ꠆ꠖꠤꠛꠣꠞ ꠔꠣꠞ ꠀꠞ ꠇꠠꠣ ꠅꠁꠛ ꠞꠥꠙꠣꠞ, ꠄꠞ ꠔꠟꠦ ꠙꠤꠔꠟꠞ ꠌꠥꠘ꠆ꠉꠤ ꠕꠣꠇꠛ। ");
INSERT INTO syls_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","ꠃꠑꠣꠘꠈꠣꠘ ꠟꠣꠝ꠆ꠛꠣꠄ ꠄꠇ-ꠡ ꠀꠔ ꠀꠞ ꠙꠣꠡꠦ ꠙꠁꠘ꠆ꠌꠣꠡ ꠀꠔ ꠅꠁꠛ। ꠄꠞ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠙꠣꠌ ꠀꠔ ꠃꠛꠤ ꠙꠞ꠆ꠖꠣ ꠖꠤꠅ, ꠙꠞ꠆ꠖꠣ ꠅꠁꠛ ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠꠞ, ꠀꠞ ꠈꠥꠐꠤꠘ꠆ꠔꠞ ꠔꠟꠦ ꠖꠤꠅ ꠙꠤꠔꠟꠞ ꠌꠥꠘ꠆ꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","ꠀꠝꠣꠞ ꠊꠞꠞ ꠇꠣꠝꠞ ꠢꠇꠟ ꠌꠤꠎ ꠙꠤꠔꠟꠖꠤ ꠛꠣꠘꠣꠁꠛꠣꠄ, ꠝꠥꠟ ꠔꠣꠝ꠆ꠛꠥ ꠀꠞ ꠃꠑꠣꠘꠞ ꠛꠦꠠꠣꠞ ꠐꠣꠘꠣꠞ ꠞꠡꠤꠞ ꠔꠟꠞ ꠙꠦꠞꠦꠉ ꠅꠇꠟ ꠙꠤꠔꠟꠞ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠅꠇꠟꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠅ, ꠔꠣꠞꠣ ꠎꠄꠔꠥꠘ ꠍꠦꠌꠤꠀ ꠔꠦꠟ ꠛꠣꠘꠣꠁꠀ ꠔꠥꠝꠣꠞ ꠉꠦꠍꠦ ꠀꠘꠔ, ꠎꠣꠔꠦ ꠌꠦꠞꠣꠉ ꠅꠇꠟ ꠢꠣꠝꠦꠡꠣ ꠎꠣꠟꠣꠁꠟ ꠞꠄ। ");
INSERT INTO syls_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇꠞ ꠍꠣꠝꠘꠦ ꠎꠦ ꠙꠞ꠆ꠖꠣꠈꠣꠘ ꠕꠣꠇꠛ, ꠅꠃ ꠙꠞ꠆ꠖꠣꠞ ꠛꠣꠞꠦ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠢꠣꠁꠘ꠆ꠎꠣ ꠕꠣꠇꠤ ꠚꠎꠞ ꠙꠞ꠆ꠎꠘ꠆ꠔ, ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠌꠦꠞꠣꠉ ꠉꠥꠁꠘ ꠖꠦꠈꠣ-ꠢꠥꠘꠣ ꠇꠞꠛꠣ। ꠀꠝꠣꠞ ꠅꠃ ꠢꠥꠇꠥꠝ ꠎꠣꠘꠥ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠢꠞ-ꠢꠣꠝꠦꠡꠣ ꠀꠝꠟ ꠇꠞꠦ।” ");
INSERT INTO syls_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠅ ꠝꠥꠍꠣ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠎꠦ ꠁꠝꠣꠝꠔꠤ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠣꠞ ꠜꠣꠁ ꠢꠣꠞꠥꠘ, ꠔꠣꠞ ꠙꠥꠀ ꠘꠣꠖꠣꠛ, ꠀꠛꠤꠢꠥ, ꠀꠟꠤ-ꠀꠎꠞ ꠀꠞ ꠁꠍꠣꠝꠣꠞꠞꠦ ꠔꠥꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠀꠘꠣꠅ। ");
INSERT INTO syls_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","“ꠔꠥꠝꠣꠞ ꠜꠣꠁ ꠢꠣꠞꠥꠘꠞ ꠁꠎ꠆ꠎꠔ ꠀꠞ ꠡꠥꠘ꠆ꠖꠞ ꠛꠣꠠꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠙꠛꠤꠔ꠆ꠞ ꠟꠦꠛꠣꠍ ꠔꠂꠀꠞ ꠇꠞꠣꠅ। ");
INSERT INTO syls_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","ꠀꠝꠤ ꠙꠣꠇ ꠞꠥꠢꠥ ꠖꠤꠀ ꠎꠦꠔꠣ ꠃꠡ꠆ꠔꠣꠖ ꠅꠇꠟꠞꠦ ꠇꠣꠞꠤꠉꠞꠤ ꠇꠣꠝꠞ ꠀꠈꠟ-ꠢꠦꠇꠝꠔ ꠖꠤꠍꠤ, ꠔꠥꠝꠤ ꠢꠃ ꠇꠣꠞꠤꠉꠞ ꠅꠇꠟꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠦꠅ, ꠔꠣꠞꠣ ꠢꠣꠞꠥꠘꠞ ꠟꠣꠉꠤ ꠅꠃꠟꠣ ꠙꠛꠤꠔ꠆ꠞ ꠟꠦꠛꠣꠍ ꠛꠣꠘꠣꠃꠇ꠆ꠇꠣ, ꠎꠦ ꠟꠦꠛꠣꠍ ꠈꠣꠟꠤ ꠀꠝꠣꠞ ꠁꠝꠣꠝꠔꠤꠞ ꠇꠣꠝꠅ ꠟꠣꠉꠦ। ");
INSERT INTO syls_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","ꠁ ꠟꠦꠛꠣꠍꠞ ꠝꠣꠎꠦ ꠛꠥꠇꠥꠞ ꠃꠙꠞꠞ ꠕꠟꠤ, ꠄꠚꠞꠘ, ꠀꠟꠈꠦꠟ꠆ꠟꠣ, ꠌꠦꠉꠞ ꠇꠣꠙꠠꠞ ꠙꠣꠁꠘ꠆ꠎꠣꠛꠤ, ꠙꠣꠃꠉꠠꠤ ꠀꠞ ꠇꠝꠞꠞ ꠛꠘ꠆ꠖꠘꠤ ꠛꠣꠘꠣꠁꠅ। ꠔꠥꠝꠣꠞ ꠜꠣꠁ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠎꠣꠔꠦ ꠀꠝꠣꠞ ꠁꠝꠣꠝꠔꠤ ꠇꠣꠝ ꠇꠞꠔꠣ ꠙꠣꠞꠂꠘ, ꠄꠞꠟꠣꠉꠤ ꠔꠣꠞꠣꠞ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠟꠦꠛꠣꠍ ꠛꠣꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","ꠟꠦꠛꠣꠍ ꠛꠣꠘꠣꠁꠔꠦ ꠔꠣꠞꠣ ꠟꠤꠟꠥꠀ, ꠛꠣꠁꠋꠉꠘꠤ, ꠟꠣꠟ ꠡꠥꠔꠣ, ꠀꠞ ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠ, ꠄꠞ ꠟꠉꠦ ꠡꠥꠘꠣꠅ ꠟꠣꠉꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“ꠙꠞꠗꠣꠘ ꠁꠝꠣꠝꠞ ꠄꠚꠞꠘ ꠛꠣꠘꠣꠁꠛꠣꠄ ꠟꠤꠟꠥꠀ, ꠛꠣꠁꠋꠉꠘꠤ, ꠟꠣꠟ ꠡꠥꠔꠣ, ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠ, ꠀꠞ ꠡꠥꠘꠣꠖꠤ। ꠁꠔꠣ ꠜꠣꠟꠣ ꠇꠥꠘꠥ ꠃꠡ꠆ꠔꠣꠖꠞꠦꠖꠤ ꠛꠣꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","ꠄꠚꠞꠘꠞ ꠇꠣꠘ꠆ꠖꠞ ꠖꠥꠁ ꠉꠣꠟꠣ ꠎꠥꠠꠣ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠖꠥꠈꠣꠘ ꠙꠐ꠆ꠐꠤ ꠛꠣꠘꠣꠁꠀ, ꠄꠚꠞꠘꠞ ꠃꠙꠞꠞ ꠇꠥꠘꠣꠔ ꠟꠣꠉꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","ꠄꠚꠞꠘꠞ ꠟꠉꠦ ꠎꠥꠠꠣ ꠟꠣꠉꠣꠁꠟ ꠙꠦꠐꠞ ꠃꠙꠞꠞ ꠛꠦꠟꠐ ꠈꠣꠘꠅ ꠄꠚꠞꠘꠞ ꠟꠣꠈꠣꠘ ꠟꠤꠟꠥꠀ, ꠛꠣꠁꠋꠉꠘꠤ, ꠟꠣꠟ ꠡꠥꠔꠣ, ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠ, ꠀꠞ ꠡꠥꠘꠣꠖꠤ ꠛꠣꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“ꠔꠥꠝꠤ ꠖꠥꠁꠐꠣ ꠀꠇꠤꠇ ꠙꠣꠔ꠆ꠔꠞ ꠀꠘꠤꠀ ꠄꠞ ꠃꠙꠞꠦ ꠁꠍꠞꠣꠁꠟ, ꠝꠣꠘꠤ ꠁꠀꠇꠥꠛꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠘꠣꠝ ꠈꠥꠖꠣꠁꠀ ꠟꠦꠈꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ꠙꠄꠟꠣ ꠙꠣꠔ꠆ꠔꠞꠞ ꠃꠙꠞꠦ, ꠔꠣꠞꠣꠞ ꠎꠘꠝꠞ ꠢꠤꠡꠣꠛꠦ ꠛꠠ ꠕꠣꠇꠤ ꠢꠥꠞꠥ ꠝꠥꠈꠣ ꠍꠄ ꠎꠘꠞ ꠘꠣꠝ, ꠀꠞ ꠖꠥꠍꠞꠣ ꠙꠣꠔ꠆ꠔꠞꠞ ꠃꠙꠞꠦꠅ ꠛꠣꠇꠤ ꠍꠄ ꠎꠘꠞ ꠘꠣꠝ ꠈꠥꠖꠣꠁꠀ ꠟꠦꠈꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","ꠢꠥꠘꠣꠞ ꠅꠇꠟꠦ ꠖꠣꠝꠤ ꠙꠣꠔ꠆ꠔꠞꠞ ꠃꠙꠞꠦ ꠈꠥꠖꠤꠀ ꠎꠦꠟꠣ ꠡꠤꠟ ꠛꠣꠘꠣꠁꠘ, ꠄꠇ꠆ꠇꠦꠞꠦ ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠞꠤ ꠖꠥꠉꠥ ꠙꠣꠔ꠆ꠔꠞꠞ ꠃꠙꠞꠦ ꠁꠍꠞꠣꠁꠟꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠘꠣꠝ ꠈꠥꠖꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","ꠙꠣꠔ꠆ꠔꠞ ꠖꠥꠁꠅꠉꠥ ꠡꠥꠘꠣꠞ ꠎꠣꠎꠁꠞꠞ ꠝꠣꠎꠦ ꠟꠣꠉꠣꠁꠀ ꠄꠚꠞꠘꠞ ꠇꠣꠘ꠆ꠖꠞ ꠙꠐ꠆ꠐꠤꠞ ꠟꠉꠦ ꠟꠣꠉꠣꠁꠅ। ꠁꠍꠞꠣꠁꠟꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠛꠣꠄ ꠝꠣꠛꠥꠖꠞ ꠘꠎꠞ ꠞꠣꠈꠣꠞ ꠟꠣꠉꠤ, ꠁ ꠙꠣꠔ꠆ꠔꠞ ꠢꠣꠞꠥꠘꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠔꠣꠞ ꠇꠣꠘ꠆ꠖꠞ ꠝꠣꠎꠦ ꠟꠣꠉꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","14","ꠖꠥꠁꠅ ꠎꠣꠎꠁꠞꠞ ꠟꠉꠦ ꠡꠥꠘꠣꠖꠤ ꠛꠣꠘꠣꠁꠟ ꠖꠥꠇꠍꠣ ꠌꠦꠁꠘ ꠟꠣꠉꠣꠁꠅ। ꠅꠃ ꠖꠥꠁꠅ ꠌꠦꠁꠘ ꠈꠣꠐꠤ ꠡꠥꠘꠣꠖꠤ ꠞꠡꠤꠞ ꠘꠝꠥꠘꠣꠄ ꠙꠦꠌꠣꠁꠀ ꠛꠣꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“ꠀꠝꠣꠞ ꠞꠣꠄ-ꠚꠄꠍꠣꠟꠣ ꠎꠣꠘꠣꠞ ꠟꠣꠉꠤ ꠛꠥꠇꠥꠞ ꠃꠙꠞꠞ ꠕꠟꠤ ꠛꠣꠘꠣꠁꠅ। ꠜꠣꠟꠣ ꠃꠡ꠆ꠔꠣꠖ ꠇꠥꠘꠥ ꠖꠞ꠆ꠎꠤꠞꠦꠖꠤ ꠛꠣꠘꠣꠁꠅ। ꠄꠚꠞꠘꠞ ꠇꠣꠝꠞ ꠟꠣꠈꠣꠘ ꠁꠐꠣꠅ ꠟꠤꠟꠥꠀ, ꠛꠣꠁꠋꠉꠘꠤ, ꠟꠣꠟ ꠡꠥꠔꠣ, ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠ, ꠀꠞ ꠡꠥꠘꠣꠖꠤ ꠛꠣꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","ꠁꠐꠣ ꠅꠁꠛ ꠟꠣꠝ꠆ꠛꠣꠄ ꠀꠗꠣ ꠀꠔ, ꠙꠣꠡꠦ ꠀꠗꠣ ꠀꠔ, ꠌꠣꠁꠞ ꠇꠥꠘꠣ ꠀꠟꠣ ꠖꠥꠁ ꠜꠣꠁꠘ꠆ꠎ ꠇꠞꠣ ꠄꠇꠈꠣꠘ ꠇꠣꠙꠠ। ");
INSERT INTO syls_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","ꠄꠞ ꠃꠙꠞꠦ ꠢꠣꠁꠞ ꠗꠞꠣꠁꠀ ꠌꠣꠁꠞ ꠢꠣꠁꠞ ꠙꠣꠔ꠆ꠔꠞ ꠟꠣꠉꠣꠁꠛꠣꠄ। ꠙꠄꠟꠣ ꠢꠣꠞꠤꠔ ꠁꠀꠇꠥꠔ, ꠙꠤꠔ, ꠀꠞ ꠙꠣꠘ꠆ꠘꠣ ꠝꠘꠤ। ");
INSERT INTO syls_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ꠖꠥꠍꠞꠣ ꠢꠣꠞꠤꠔ ꠟꠣꠟꠝꠘꠤ, ꠟꠤꠟ ꠝꠘꠤ ꠀꠞ ꠢꠤꠞꠣ; ");
INSERT INTO syls_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ꠔꠤꠘ ꠘꠝ꠆ꠛꠞ ꠢꠣꠞꠤꠔ ꠚꠤꠞꠥꠎ, ꠉꠥꠝꠦꠖ ꠀꠞ ꠙꠖ꠆ꠖꠞꠣꠉ ꠝꠘꠤ। ");
INSERT INTO syls_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ꠌꠣꠁꠞ ꠘꠝ꠆ꠛꠞ ꠢꠣꠁꠞꠅ ꠙꠥꠈꠞꠣꠎ, ꠛꠂꠖꠥꠞ꠆ꠎ ꠀꠞ ꠡꠥꠞꠥꠎ ꠝꠘꠤ। ꠁ ꠙꠣꠔ꠆ꠔꠞ ꠅꠇꠟ ꠡꠥꠘꠣꠞ ꠎꠣꠎꠁꠞꠖꠤ ꠟꠣꠉꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","ꠁꠍꠞꠣꠁꠟꠞ ꠛꠣꠞꠅ ꠙꠥꠀꠞ ꠟꠣꠉꠤ ꠛꠣꠞꠅꠐꠣ ꠙꠣꠔ꠆ꠔꠞ ꠟꠣꠉꠛ। ꠁꠔꠣ ꠄꠇꠅ ꠙꠣꠔ꠆ꠔꠞꠅ ꠄꠇ ꠄꠇ ꠙꠥꠀꠞ ꠘꠣꠝ ꠈꠥꠖꠤꠀ ꠟꠦꠈꠣꠁꠅ, ꠎꠦꠟꠣ ꠈꠥꠖꠤꠀ ꠡꠤꠟ ꠛꠣꠘꠣꠁꠟ ꠅꠄ। ");
INSERT INTO syls_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“ꠛꠥꠇꠥꠞ ꠃꠙꠞꠞ ꠕꠟꠤꠞ ꠟꠣꠉꠤ ꠈꠣꠐꠤ ꠡꠥꠘꠣꠖꠤ ꠞꠡꠤꠞ ꠟꠣꠈꠣꠘ ꠙꠦꠌꠣꠁꠀ ꠖꠥꠇꠍꠣ ꠌꠦꠁꠘ ꠛꠣꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","ꠡꠥꠘꠣꠞ ꠖꠥꠁꠐꠣ ꠇꠠꠣ ꠛꠣꠘꠣꠁꠀ ꠛꠥꠇꠥꠞ ꠅꠃ ꠕꠟꠤꠞ ꠃꠙꠞꠞ ꠇꠥꠘꠣꠔ ꠟꠣꠉꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","ꠀꠞ ꠌꠦꠁꠘ ꠖꠥꠁꠅꠉꠦꠍꠣ ꠖꠥꠁꠅ ꠇꠠꠣꠞ ꠟꠉꠦ ꠀꠐꠇꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","ꠖꠥꠁꠅ ꠇꠣꠘ꠆ꠖꠞ ꠄꠚꠞꠘꠞ ꠍꠣꠝꠘꠞ ꠚꠤꠔꠣꠔ ꠡꠥꠘꠣꠞ ꠎꠣꠎꠁꠞꠞ ꠟꠉꠦ ꠌꠦꠁꠘꠞ ꠄꠇ ꠝꠣꠕꠣ ꠛꠣꠘ꠆ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","ꠀꠞꠅ ꠖꠥꠁꠐꠣ ꠡꠥꠘꠣꠞ ꠇꠠꠣ ꠛꠣꠘꠣꠁꠀ ꠛꠥꠇꠥꠞ ꠃꠙꠞꠞ ꠕꠟꠤꠞ ꠖꠥꠁ ꠇꠥꠘꠣꠔ ꠟꠣꠉꠣꠁꠅ। ꠁ ꠖꠥꠁꠅꠐꠣ ꠄꠚꠞꠘꠞ ꠟꠉꠦ ꠛꠥꠇꠥꠞ ꠕꠟꠤꠞ ꠔꠟꠦ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","ꠛꠣꠖꠦ ꠀꠞꠅ ꠖꠥꠁꠐꠣ ꠡꠥꠘꠣꠞ ꠇꠠꠣ ꠛꠣꠘꠣꠁꠀ, ꠄꠚꠞꠘꠞ ꠇꠣꠘ꠆ꠖꠞ ꠙꠐ꠆ꠐꠤꠞ ꠡꠁ ꠔꠟꠦꠖꠤ, ꠙꠦꠐꠞ ꠃꠙꠞꠞ ꠛꠦꠟꠐꠞ ꠃꠙꠞꠞ ꠡꠤꠟꠣꠁꠞ ꠇꠣꠍꠣꠔ ꠟꠣꠉꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","ꠛꠣꠖꠦ ꠛꠥꠇꠥꠞ ꠃꠙꠞꠞ ꠕꠟꠤꠞ ꠔꠟꠞ ꠇꠠꠣꠞ ꠟꠉꠦ ꠙꠦꠐꠞ ꠃꠙꠞꠞ ꠘꠇꠡꠣ ꠇꠞꠣ ꠛꠦꠟꠐꠞ ꠇꠠꠣ ꠟꠤꠟꠥꠀ ꠡꠥꠔꠣꠖꠤ ꠛꠣꠘ꠆ꠖꠤꠅ। ꠔꠦꠃ ꠅꠃ ꠕꠟꠤ ꠄꠚꠞꠘꠞ ꠃꠙꠞꠦ ꠕꠣꠇꠤ ꠢꠞꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“ꠙꠣꠇ ꠎꠣꠉꠣꠔ ꠢꠣꠝꠣꠁꠛꠣꠞ ꠛꠣꠟꠣ ꠢꠣꠞꠥꠘꠦ ꠀꠝꠣꠞ ꠞꠣꠄ-ꠚꠄꠍꠣꠟꠣ ꠢꠥꠘꠣꠞ ꠟꠣꠉꠤ, ꠛꠥꠇꠥꠞ ꠃꠙꠞꠞ ꠕꠟꠤꠞ ꠃꠙꠞꠦ ꠟꠦꠈꠣ ꠁꠍꠞꠣꠁꠟꠞ ꠛꠣꠞꠅ ꠙꠥꠀꠞ ꠘꠣꠝ ꠟꠣꠉꠣꠁꠔꠦ ꠅꠁꠛ, ꠁ ꠕꠟꠤꠐꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠢꠞ-ꠢꠣꠝꠦꠡꠣ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠞꠣꠈꠛ। ");
INSERT INTO syls_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","ꠀꠝꠣꠞ ꠞꠣꠄ-ꠚꠄꠍꠣꠟꠣꠞ ꠅꠃ ꠕꠟꠤꠞ ꠜꠤꠔꠞꠦ ꠃꠞꠤꠝ ꠀꠞ ꠔꠥꠝ꠆ꠝꠤꠝ ꠘꠣꠝꠞ ꠙꠛꠤꠔ꠆ꠞ ꠙꠣꠔ꠆ꠔꠞꠉꠥꠁꠘ ꠞꠣꠈꠤꠅ। ꠢꠣꠞꠥꠘ ꠎꠦꠛꠟꠣ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠀꠎꠤꠞ ꠅꠁꠛ, ꠅꠃ ꠡꠝꠄ ꠁꠔꠣ ꠔꠣꠞ ꠛꠥꠇꠥꠞ ꠃꠙꠞꠦ ꠞꠁꠛ। ꠢꠣꠞꠥꠘꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠣꠉꠤ ꠀꠝꠣꠞ ꠞꠣꠄ-ꠚꠄꠍꠣꠟꠣ ꠎꠣꠘꠣꠞ ꠃꠙꠣꠄ ꠢꠤꠡꠣꠛꠦ ꠢꠞ-ꠢꠣꠝꠦꠡꠣ ꠔꠣꠞ ꠛꠥꠇꠥꠞ ꠃꠙꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠖꠦꠅꠀ ꠅꠃ ꠌꠤꠎ ꠞꠣꠈꠛ।” ");
INSERT INTO syls_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠄꠚꠞꠘꠞ ꠔꠟꠦ ꠟꠣꠝ꠆ꠛꠣ ꠎꠦ ꠀꠟꠈꠦꠟ꠆ꠟꠣ ꠞꠁꠛ, ꠁꠇꠐꠣ ꠙꠥꠞꠣꠐꠣꠃ ꠟꠤꠟꠥꠀ ꠞꠋꠉꠞ ꠡꠥꠔꠣꠖꠤ ꠛꠣꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","ꠝꠣꠕꠣ ꠢꠣꠞꠣꠁꠛꠣꠞ ꠟꠣꠉꠤ ꠄꠞ ꠝꠣꠎꠈꠣꠘꠅ ꠚꠣꠇ ꠞꠣꠈꠤꠅ। ꠁ ꠚꠣꠇ ꠎꠣꠉꠣ ꠎꠣꠔꠦ ꠘꠣ ꠍꠤꠠꠦ, ꠄꠞꠟꠣꠉꠤ ꠄꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣ ꠝꠎꠛꠥꠔ ꠇꠞꠤ ꠛꠣꠁꠘ ꠇꠞꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","ꠟꠤꠟꠥꠀ, ꠛꠣꠁꠋꠉꠘꠤ, ꠟꠣꠟ ꠞꠋꠉꠞ ꠡꠥꠔꠣꠖꠤ ꠀꠘꠥꠀꠞ ꠚꠟꠞ ꠟꠣꠈꠣꠘ ꠛꠣꠘꠣꠁꠀ, ꠅꠃ ꠀꠟꠈꠦꠟ꠆ꠟꠣꠞ ꠔꠟꠞ ꠝꠥꠠꠤꠞ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠟꠣꠉꠣꠁꠅ। ꠀꠞ ꠁꠔꠣꠞ ꠝꠣꠎꠦ ꠝꠣꠎꠦ ꠖꠤꠅ ꠡꠥꠘꠣꠞ ꠊꠥꠋꠉꠥꠞ। ");
INSERT INTO syls_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","ꠁ ꠝꠥꠠꠤꠔ ꠖꠤꠛꠣꠄ ꠄꠉꠥ ꠇꠞꠤ ꠀꠘꠥꠀꠞ ꠀꠞ ꠄꠉꠥ ꠊꠥꠋꠉꠥꠞ। ");
INSERT INTO syls_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","ꠁꠝꠣꠝꠔꠤ ꠇꠞꠣꠞ ꠛꠣꠟꠣ ꠢꠣꠞꠥꠘꠦ ꠁ ꠟꠦꠛꠣꠍ ꠚꠤꠘ꠆ꠖꠤꠛ। ꠢꠦ ꠎꠦꠛꠟꠣ ꠙꠣꠇ ꠎꠣꠉꠣꠔ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠀꠎꠤꠞ ꠅꠁꠛ, ꠀꠞ ꠢꠘ ꠕꠣꠇꠤ ꠛꠣꠞꠦ ꠛꠣꠞ ꠅꠁꠛ, ꠅꠃ ꠡꠝꠄ ꠅꠃ ꠊꠥꠋꠉꠥꠞ ꠅꠇꠟꠞ ꠀꠅꠀꠎ ꠢꠥꠘꠣ ꠎꠣꠁꠛ, ꠔꠦꠃ ꠢꠦ ꠝꠞꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“ꠈꠣꠐꠤ ꠡꠥꠘꠣꠖꠤ ꠄꠇꠈꠣꠘ ꠙꠣꠔ ꠛꠣꠘꠣꠁꠀ ꠄꠞ ꠃꠙꠞꠦ ꠡꠤꠟꠞ ꠟꠣꠈꠣꠘ ꠈꠥꠖꠤꠀ ꠅꠃ ꠀꠄꠀꠔ ꠟꠦꠈꠣꠁꠅ, ‘ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ।’ ");
INSERT INTO syls_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","ꠁ ꠙꠣꠔꠈꠣꠘ ꠙꠣꠃꠉꠠꠤꠞ ꠍꠣꠝꠘꠞ ꠉꠣꠟꠣꠔ ꠟꠣꠉꠣꠁꠀ ꠟꠤꠟꠥꠀ ꠡꠥꠔꠣꠖꠤ ꠛꠣꠘ꠆ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","ꠁꠐꠣ ꠢꠣꠞꠥꠘꠞ ꠇꠙꠣꠟꠞ ꠃꠙꠞꠦ ꠞꠁꠛ। ꠎꠔ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠝꠣꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠖꠣꠘ-ꠈꠄꠞꠣꠔ ꠟꠁꠀ ꠀꠁꠛꠣ, ꠁꠔꠣꠞ ꠢꠇꠟ ꠘꠝꠥꠘꠣꠞ ꠖꠥꠡ-ꠔꠤꠞꠥꠐꠤꠞ ꠜꠣꠞ ꠢꠣꠞꠥꠘꠦ ꠛꠁꠛ। ꠝꠣꠛꠥꠖꠦ ꠎꠣꠔꠦ ꠔꠣꠞꠣꠞꠦ ꠇꠛꠥꠟ ꠇꠞꠂꠘ, ꠄꠞꠟꠣꠉꠤ ꠢꠣꠞꠥꠘꠦ ꠇꠙꠣꠟꠞ ꠃꠙꠞꠦ ꠁ ꠡꠥꠘꠣꠞ ꠙꠣꠔꠈꠣꠘ ꠢꠣꠝꠦꠡꠣ ꠟꠣꠉꠣꠁꠀ ꠞꠣꠈꠛ। ");
INSERT INTO syls_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","ꠁꠝꠣꠝꠞ ꠙꠣꠁꠘ꠆ꠎꠣꠛꠤ ꠀꠞ ꠙꠣꠃꠉꠠꠤ ꠔꠂꠀꠞ ꠇꠞꠣꠁꠅ ꠌꠦꠉꠞ ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠꠖꠤ। ꠇꠝꠞꠞ ꠛꠘ꠆ꠖꠘꠤ ꠈꠣꠘ ꠡꠥꠁ-ꠡꠥꠔꠣꠖꠤ ꠘꠇꠡꠣ ꠇꠞꠤ ꠛꠣꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“ꠢꠣꠞꠥꠘꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠁꠎ꠆ꠎꠔ ꠀꠞ ꠡꠥꠘ꠆ꠖꠞꠞ ꠟꠣꠉꠤ ꠙꠣꠁꠘ꠆ꠎꠣꠛꠤ, ꠔꠇꠤ ꠀꠞ ꠇꠝꠞꠞ ꠛꠘ꠆ꠖꠘꠤ ꠔꠂꠀꠞ ꠇꠞꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","ꠔꠥꠝꠤ ꠔꠥꠝꠣꠞ ꠜꠣꠁ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠁ ꠇꠣꠙꠠ ꠚꠤꠘ꠆ꠖꠣꠁꠅ। ꠔꠣꠞꠣꠞ ꠝꠣꠕꠣꠔ ꠙꠛꠤꠔ꠆ꠞ ꠔꠦꠟ ꠓꠣꠟꠤꠀ ꠈꠦꠟꠣꠚꠔꠤ ꠡꠝꠎꠣꠁꠀ ꠁꠝꠣꠝꠔꠤ ꠇꠣꠝꠅ ꠟꠣꠉꠣꠁꠅ। ꠔꠥꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠤꠅ, ꠎꠣꠔꠦ ꠔꠣꠞꠣ ꠀꠝꠣꠞ ꠁꠝꠣꠝ ꠅꠁꠔꠣ ꠙꠣꠞꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","ꠇꠝꠞ ꠕꠣꠇꠤ ꠃꠞꠣꠔ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠡꠞꠝꠞ ꠎꠣꠉꠣ ꠉꠥꠞꠣꠞ ꠟꠣꠉꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠꠖꠤ ꠢꠣꠚ-ꠙꠦꠘ꠆ꠐꠞ ꠟꠣꠈꠣꠘ ꠎꠣꠋꠉꠤꠀ ꠛꠣꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ ꠎꠦꠛꠟꠣ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠔ ꠢꠣꠝꠣꠁꠛꠣ, ꠛꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠉꠦꠍꠦ ꠙꠣꠇ ꠎꠣꠉꠣꠔ ꠢꠣꠝꠣꠁꠀ ꠁꠝꠣꠝꠔꠤꠞ ꠇꠣꠝꠅ ꠟꠣꠉꠛꠣ, ꠅꠃ ꠡꠝꠄ ꠔꠣꠞꠣ ꠅꠃ ꠎꠣꠋꠉꠤꠀ ꠚꠤꠘꠛꠣ। ꠔꠦꠃ ꠔꠣꠞꠣ ꠘꠤ-ꠅꠙꠞꠣꠗꠤ ꠞꠁꠛꠣ, ꠝꠞꠔꠣ ꠘꠣꠄ। ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠅꠀꠞꠤꠡꠞ ꠍꠤꠟꠍꠤꠟꠣꠞ ꠟꠣꠉꠤ ꠁ ꠀꠁꠘ ꠢꠞ-ꠢꠣꠝꠦꠡꠣ ꠌꠣꠟꠥ ꠞꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠁꠝꠣꠝ ꠅꠇꠟꠞꠦ ꠅꠃ ꠟꠣꠈꠣꠘ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠞꠤꠅ, ꠎꠣꠔꠦ ꠁꠝꠣꠝ ꠛꠘꠤꠀ ꠔꠣꠞꠣ ꠀꠝꠣꠞ ꠄꠛꠣꠖꠔ ꠇꠣꠝ ꠌꠣꠟꠣꠁꠔꠣ ꠙꠣꠞꠂꠘ। ꠔꠥꠝꠤ ꠘꠤꠈꠥꠔ ꠄꠉꠥ ꠛꠤꠍꠣꠟ ꠀꠞ ꠖꠥꠉꠥ ꠝꠦꠠꠣꠞ ꠙꠣꠑꠣ ꠀꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ꠄꠞꠟꠉꠦ ꠝꠄꠖꠣꠖꠤ ꠞꠥꠐꠤ, ꠔꠦꠟꠖꠤ ꠜꠣꠎꠣ ꠙꠤꠑꠣ, ꠀꠞ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠌꠣꠙꠣꠐꠤ ꠛꠣꠘꠣꠁꠅ। ꠁꠔꠣ ꠇꠥꠘ꠆ꠔꠣꠔꠃ ꠈꠣꠝꠤꠞ ꠝꠤꠡꠣꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","ꠅꠔꠣ ꠛꠣꠘꠣꠁꠀ ꠄꠇ ꠐꠥꠇꠞꠤꠔ ꠟꠁꠅ, ꠄꠞꠟꠉꠦ ꠢꠃ ꠛꠤꠍꠣꠟ ꠀꠞ ꠖꠥꠁꠅ ꠝꠦꠠꠣꠞ ꠙꠣꠑꠣ ꠟꠁꠀ ꠀꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠀꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","ꠛꠣꠖꠦ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠇꠣꠍꠣꠔ ꠀꠘꠤꠀ, ꠙꠣꠘꠤꠖꠤ ꠘꠣꠅꠀꠁ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","ꠀꠞ ꠢꠃ ꠙꠛꠤꠔ꠆ꠞ ꠟꠦꠛꠣꠍ ꠅꠇꠟ ꠀꠘꠤꠀ ꠢꠣꠞꠥꠘꠞꠦ ꠚꠤꠘ꠆ꠖꠣꠁꠅ। ꠙꠣꠁꠘ꠆ꠎꠣꠛꠤ, ꠀꠟꠈꠦꠟ꠆ꠟꠣ, ꠄꠚꠞꠘ ꠀꠞ ꠛꠥꠇꠥꠞ ꠃꠙꠞꠞ ꠕꠟꠤ ꠢꠇꠟꠔꠣ ꠚꠤꠘ꠆ꠖꠣꠁꠅ। ꠄꠚꠞꠘꠞ ꠟꠉꠦ ꠃꠡ꠆ꠔꠣꠖꠤ ꠀꠔꠞ ꠛꠣꠘꠣꠁꠟ ꠢꠃ ꠙꠦꠐꠞ ꠃꠙꠞꠞ ꠛꠦꠟꠐ ꠈꠣꠘꠅ ꠛꠣꠘ꠆ꠖꠤꠀ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","ꠔꠣꠞ ꠝꠣꠕꠣꠔ ꠙꠣꠃꠉꠠꠤ ꠚꠤꠘ꠆ꠖꠣꠁꠅ ꠀꠞ ꠡꠥꠘꠣꠞ ꠙꠣꠔꠖꠤ ꠛꠣꠘꠣꠁꠟ ꠙꠛꠤꠔ꠆ꠞ ꠔꠣꠎ ꠈꠣꠘꠅ ꠟꠣꠉꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","ꠛꠣꠖꠦ ꠈꠦꠟꠣꠚꠔꠤꠞ ꠔꠦꠟ ꠔꠣꠞ ꠝꠣꠕꠣꠔ ꠓꠣꠟꠤꠀ ꠔꠣꠞꠦ ꠈꠦꠟꠣꠚꠔꠤ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦꠅ ꠀꠘꠤꠀ ꠙꠣꠁꠘ꠆ꠎꠣꠛꠤ ꠚꠤꠘ꠆ꠖꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠇꠝꠞꠞ ꠛꠘ꠆ꠖꠘꠤ ꠛꠣꠘ꠆ꠖꠤꠀ ꠖꠤꠅ। ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠝꠣꠕꠣꠔ ꠖꠤꠅ ꠔꠇꠤ। ꠅꠃ ꠟꠣꠈꠣꠘ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠁꠝꠣꠝꠞ ꠙꠖꠅ ꠛꠅꠀꠁꠟ ꠇꠞꠤꠅ, ꠎꠣꠔꠦ ꠌꠤꠞꠇꠣꠟꠤꠘ ꠘꠤꠅꠝ ꠢꠤꠡꠣꠛꠦ ꠁꠝꠣꠝꠔꠤꠞ ꠙꠖ ꠈꠣꠟꠤ ꠔꠣꠞꠣꠞ ꠛꠋꠡꠔ ꠕꠣꠇꠦ। ");
INSERT INTO syls_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“ꠛꠣꠖꠦ ꠢꠃ ꠛꠤꠍꠣꠟꠞꠦ ꠔꠥꠝꠤ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠍꠣꠝꠘꠦ ꠀꠘꠤꠅ, ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠅꠉꠥꠞ ꠇꠟ꠆ꠟꠣ ꠀꠔꠣꠁꠀ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","ꠀꠔꠣꠘꠤꠞ ꠛꠣꠖꠦ ꠅꠃ ꠛꠤꠍꠣꠟꠞꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠇꠣꠍꠣꠔ ꠘꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠎꠛ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","ꠎꠛ ꠇꠞꠤꠀ ꠢꠣꠞꠟꠦ ꠕꠥꠠꠣ ꠟꠃ ꠔꠥꠝꠣꠞ ꠀꠋꠉꠥꠟꠤꠔ ꠟꠣꠉꠣꠁꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠢꠤꠋꠉꠞ ꠝꠣꠎꠦ ꠟꠣꠉꠣꠁꠅ, ꠀꠞ ꠛꠣꠇꠤ ꠟꠃ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠔꠟꠦ ꠓꠣꠟꠤ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","ꠛꠤꠍꠣꠟꠞ ꠙꠦꠐꠞ ꠜꠤꠔꠞꠞ ꠀꠔ-ꠜꠠꠞ ꠌꠞ꠆ꠛꠤ, ꠇꠁꠟꠎꠣꠞ ꠟꠉꠞ ꠝꠣꠐꠤꠀ, ꠖꠥꠁꠅ ꠇꠤꠒꠘꠤ ꠀꠞ ꠄꠞ ꠌꠞ꠆ꠛꠤ, ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠘꠤꠀ ꠎꠣꠟꠣꠁꠟꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","ꠄꠞ ꠉꠥꠡ꠆ꠔ, ꠈꠣꠟ, ꠀꠔ-ꠜꠠ ꠉꠥꠚꠞ ꠡꠥꠖ꠆ꠖꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠇꠦꠝ꠆ꠙꠞ ꠛꠣꠞꠦ ꠘꠤꠀ ꠎꠣꠟꠣꠁꠟꠤꠅ, ꠁꠔꠣ ꠔ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ। ");
INSERT INTO syls_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“ꠛꠣꠖꠦ ꠢꠃ ꠖꠥꠁꠅ ꠝꠦꠠꠣ ꠕꠣꠇꠤ ꠄꠉꠥ ꠝꠦꠠꠣ ꠀꠘꠤꠅ, ꠀꠘꠟꠦ ꠢꠣꠞꠥꠘꠦ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠅꠉꠥꠞ ꠇꠟ꠆ꠟꠣ ꠀꠔꠣꠁꠀ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ꠀꠞ ꠅꠃ ꠝꠦꠠꠣꠞꠦ ꠎꠛ ꠇꠞꠤꠀ ꠄꠞ ꠟꠃ ꠘꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠔ ꠍꠤꠐꠣꠁ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","ꠝꠦꠠꠣꠞꠦ ꠇꠣꠐꠤꠀ ꠐꠥꠇꠞꠣꠁꠀ ꠔꠣꠞ ꠑꠦꠋ ꠀꠞ ꠙꠦꠐꠞ ꠜꠤꠔꠞꠞ ꠢꠇꠟꠔꠣ ꠗꠁꠀ, ꠇꠟ꠆ꠟꠣ ꠀꠞ ꠛꠣꠇꠤ ꠐꠥꠇꠞꠣꠁꠘ꠆ꠔꠞ ꠟꠉꠦ ꠕꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","ꠢꠦꠡꠦ ꠁ ꠀꠡ꠆ꠔꠣꠉꠥ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠘꠤꠀ ꠎꠣꠟꠣꠁꠟꠤꠅ। ꠁꠔꠣ ꠅꠁꠟ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠝꠣꠛꠥꠖꠞ ꠘꠤꠅꠔꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠊꠦꠞꠣꠘ ꠀꠟꠣ ꠍꠖꠉꠣ। ");
INSERT INTO syls_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“ꠛꠣꠖꠦ ꠖꠥꠍꠞꠣ ꠝꠦꠠꠣꠞꠦꠅ ꠀꠘꠤꠀ ꠢꠣꠞꠥꠘꠦ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠇꠟ꠆ꠟꠣ ꠀꠔꠣꠁ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ꠀꠔꠣꠘꠤꠞ ꠛꠣꠖꠦ ꠅꠉꠥꠞꠦ ꠎꠛ ꠇꠞꠤꠀ ꠄꠞ ꠕꠥꠠꠣ ꠟꠃ ꠘꠤꠀ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠒꠣꠁꠘ ꠇꠣꠘꠞ ꠟꠔꠤꠔ, ꠒꠣꠁꠘ ꠀꠔꠞ ꠀꠞ ꠒꠣꠁꠘ ꠙꠣꠅꠞ ꠛꠥꠠꠤ ꠀꠋꠉꠥꠟꠞ ꠝꠣꠎꠦ ꠟꠣꠉꠣꠁꠅ। ꠀꠞ ꠛꠣꠇꠤ ꠟꠃ ꠘꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠛꠣꠄ ꠍꠤꠐꠣꠁ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","ꠛꠣꠖꠦ ꠈꠦꠟꠣꠚꠔꠤꠞ ꠔꠦꠟ ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠕꠣꠇꠤ ꠕꠥꠠꠣ ꠟꠃ ꠟꠁꠀ, ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠉꠔꠞꠅ ꠀꠞ ꠟꠦꠛꠣꠍꠞ ꠃꠙꠞꠦ ꠍꠤꠐꠣꠁ ꠖꠤꠅ। ꠔꠦꠃ ꠟꠦꠛꠣꠍ ꠡꠥꠖ꠆ꠖꠣ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ ꠙꠣꠇ-ꠍꠣꠚ ꠅꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","ꠔꠥꠝꠤ ꠅꠃ ꠝꠦꠠꠣꠞ ꠌꠞ꠆ꠛꠤ, ꠌꠞ꠆ꠛꠤ ꠀꠟꠣ ꠟꠦꠋꠉꠥꠠ, ꠙꠦꠐꠞ ꠜꠤꠔꠞꠞ ꠢꠇꠟꠔꠣꠞ ꠃꠙꠞꠞ ꠌꠞ꠆ꠛꠤ, ꠇꠁꠟꠎꠣꠞ ꠟꠉꠞ ꠝꠣꠐꠤꠀ, ꠖꠥꠁꠅ ꠇꠤꠒꠘꠤ, ꠄꠞ ꠌꠞ꠆ꠛꠤ, ꠀꠞ ꠒꠣꠁꠘꠞ ꠞꠣꠘ ꠘꠤꠅ, ꠁꠐꠣ ꠅꠁꠟ ꠁꠝꠣꠝꠔꠤ ꠇꠣꠝꠅ ꠛꠅꠀꠁꠟꠞ ꠟꠣꠉꠤ ꠛꠈꠡꠤꠀ ꠖꠤꠛꠣꠞ ꠝꠦꠠꠣ। ");
INSERT INTO syls_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠎꠞꠅ ꠕꠅꠀ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠞꠥꠐꠤꠞ ꠐꠥꠇꠞꠤ ꠕꠣꠇꠤ ꠄꠇꠈꠣꠘ ꠞꠥꠐꠤ, ꠔꠦꠟꠖꠤ ꠜꠣꠎꠣ ꠄꠇꠈꠣꠘ ꠙꠤꠑꠣ ꠀꠞ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠌꠣꠙꠣꠐꠤ ꠄꠇꠈꠣꠘ ꠟꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","ꠟꠁꠀ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠀꠔꠅ ꠖꠤꠀ, ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠞꠣꠈꠣꠞ ꠘꠤꠅꠔꠦ ꠖꠥꠟꠘꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠖꠥꠟꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","ꠀꠞ ꠅꠔꠣ ꠔꠣꠞꠣꠞ ꠀꠔ ꠕꠣꠇꠤ ꠘꠤꠀ, ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ, ꠢꠃ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠃꠙꠞꠦ ꠎꠣꠟꠣꠁꠟꠤꠛꠣꠄ। ꠁꠐꠣ ꠅꠁꠟ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠍꠖꠉꠣ। ꠁꠔꠣꠞ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠝꠣꠛꠥꠖ ꠈꠥꠡꠤ ꠅꠁꠘ।” ");
INSERT INTO syls_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠢꠣꠞꠥꠘꠞꠦ ꠁꠝꠣꠝꠔꠤꠞ ꠇꠣꠝꠅ ꠛꠅꠀꠁꠟ ꠇꠞꠣꠞ ꠟꠣꠉꠤ, ꠈꠦꠟꠣꠚꠔꠤ ꠡꠝꠎꠤꠛꠣꠞ ꠝꠦꠠꠣꠞ ꠍꠤꠘꠣꠞ ꠐꠥꠇꠞꠣ ꠟꠁꠀ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠖꠥꠟꠘꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠖꠥꠟꠣꠁꠛꠣꠄ। ꠁꠐꠣ ꠅꠁꠟ ꠔꠥꠝꠣꠞ ꠛꠣꠐ। ");
INSERT INTO syls_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠁꠝꠣꠝꠔꠤꠞ ꠇꠣꠝꠅ ꠛꠅꠀꠁꠟꠞ ꠟꠣꠉꠤ ꠖꠥꠟꠣꠁꠟ ꠅꠃ ꠍꠤꠘꠣ ꠀꠞ ꠞꠣꠘ ꠔꠥꠝꠤ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","ꠅꠃ ꠟꠣꠈꠣꠘ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠖꠦꠅꠀ ꠅꠃ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠐꠥꠇꠞꠣꠁꠘ ꠢꠞ-ꠢꠣꠝꠦꠡꠣ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠙꠣꠁꠛꠣ। ꠁꠔꠣ ꠅꠁꠛ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠖꠦꠅꠀ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠄꠇꠐꠣ ꠅꠋꠡ। ");
INSERT INTO syls_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“ꠢꠣꠞꠥꠘꠞ ꠛꠦꠛꠢꠣꠞ ꠇꠞꠣ ꠙꠛꠤꠔ꠆ꠞ ꠟꠦꠛꠣꠍ ꠅꠇꠟ ꠔꠣꠞ ꠅꠀꠞꠤꠡ ꠅꠇꠟꠦ ꠙꠣꠁꠛꠣ। ꠅꠃ ꠟꠦꠛꠣꠍ ꠚꠤꠘ꠆ꠖꠤꠀ ꠔꠣꠞꠣ ꠈꠦꠟꠣꠚꠔꠤ ꠙꠣꠁꠛꠣ ꠀꠞ ꠁꠝꠣꠝꠔꠤꠞ ꠇꠣꠝꠅ ꠛꠅꠀꠁꠟ ꠅꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","ꠢꠣꠞꠥꠘꠞ ꠛꠣꠖꠦ ꠔꠣꠞ ꠎꠦ ꠙꠥꠀ ꠁꠝꠣꠝ ꠅꠁꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠙꠣꠇ ꠎꠣꠉꠣꠔ ꠇꠣꠝ ꠇꠞꠛ, ꠢꠦ ꠡꠣꠔꠖꠤꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠁ ꠟꠦꠛꠣꠍ ꠔꠣꠞ ꠉꠔꠞꠅ ꠞꠣꠈꠛ। ");
INSERT INTO syls_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“ꠈꠦꠟꠣꠚꠔꠤ ꠡꠝꠎꠤꠛꠣꠞ ꠝꠦꠠꠣꠞ ꠅꠃ ꠉꠥꠡ꠆ꠔ ꠈꠣꠘꠣꠁꠘ ꠘꠤꠀ ꠇꠥꠘꠥ ꠙꠛꠤꠔ꠆ꠞ ꠎꠣꠉꠣꠔ ꠞꠣꠘ꠆ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠇꠣꠍꠣꠔ ꠛꠁꠀ, ꠐꠥꠇꠞꠤꠔ ꠕꠅꠀ ꠢꠃ ꠞꠥꠐꠤꠞ ꠟꠉꠦ ꠅꠃ ꠉꠥꠡ꠆ꠔ ꠈꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","ꠁꠝꠣꠝꠞ ꠇꠣꠝꠅ ꠛꠅꠀꠁꠟ ꠇꠞꠣꠞ ꠟꠣꠉꠤ, ꠔꠣꠞꠣꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠞꠣꠞ ꠟꠣꠉꠤ, ꠈꠣꠘꠤꠞ ꠎꠦꠔꠣ ꠌꠤꠎ ꠅꠇꠟ ꠉꠥꠘꠣꠞ ꠝꠣꠚꠤꠞ ꠟꠣꠉꠤ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅꠀ ꠅꠁꠛ, ꠁꠔꠣ ꠈꠣꠟꠤ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠈꠣꠁꠛꠣ। ꠀꠞ ꠇꠦꠃ ꠁꠔꠣ ꠈꠣꠁꠔ ꠙꠣꠞꠔ ꠘꠣꠄ, ꠇꠣꠞꠘ ꠁꠔꠣ ꠅꠁꠟ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠈꠣꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","ꠅꠃ ꠛꠅꠀꠁꠟ ꠇꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠝꠦꠠꠣꠞ ꠇꠥꠘꠥ ꠉꠥꠡ꠆ꠔ ꠛꠣ ꠞꠥꠐꠤ ꠎꠥꠖꠤ ꠛꠤꠀꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠞꠁꠎꠣꠄ, ꠔꠦ ꠁꠔꠣ ꠎꠣꠟꠣꠁꠟꠤꠔꠦ ꠅꠁꠛ, ꠇꠦꠃ ꠈꠣꠁꠔ ꠙꠣꠞꠔ ꠘꠣꠄ, ꠁꠔꠣ ꠔ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ। ");
INSERT INTO syls_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠟꠣꠉꠤ, ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠎꠔꠔꠣ ꠇꠞꠣꠞ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠤ, ꠔꠥꠝꠤ ꠅꠃꠟꠣ ꠇꠞꠤꠅ। ꠛꠅꠀꠁꠟ ꠇꠞꠣꠞ ꠅꠃ ꠇꠣꠝ ꠔꠥꠝꠤ ꠡꠣꠔꠖꠤꠘ ꠜꠞꠣ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣ ꠢꠤꠡꠣꠛꠦ ꠔꠥꠝꠤ ꠙꠞꠔꠦꠇ ꠖꠤꠘ ꠄꠉꠥ ꠇꠞꠤ ꠛꠤꠍꠣꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠄ। ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠣꠞ ꠟꠣꠉꠤꠅ ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠅ, ꠀꠞ ꠙꠣꠇ-ꠍꠣꠚ ꠅꠀꠞ ꠟꠣꠉꠤ ꠙꠛꠤꠔ꠆ꠞ ꠔꠦꠟ ꠓꠣꠟꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠡꠣꠔꠖꠤꠘ ꠜꠞꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠀ, ꠉꠥꠘꠣ ꠝꠣꠚꠤꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠤꠀ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠤꠅ। ꠔꠦꠃ ꠁ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠄꠇ ꠝꠢꠣ-ꠙꠛꠤꠔ꠆ꠞ ꠎꠣꠉꠣ ꠅꠁꠛ। ꠎꠦꠇꠥꠘꠥ ꠎꠤꠘꠤꠡ ꠁ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠔ ꠍꠥꠀꠁꠟꠦ, ꠁꠔꠣ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠅꠁꠎꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“ꠄꠞ ꠛꠣꠖ ꠕꠣꠇꠤ ꠙꠞꠔꠦꠇ ꠖꠤꠘ ꠁ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ, ꠄꠇ ꠛꠞꠍ ꠛꠄꠅꠡꠞ ꠖꠥꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ꠄꠉꠥ ꠛꠤꠀꠘꠦ ꠀꠞ ꠄꠉꠥ ꠢꠣꠁꠘ꠆ꠎꠣ ꠛꠣꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","ꠙꠄꠟꠣ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣꠞ ꠟꠉꠦ ꠖꠥꠁ ꠡꠦꠞ ꠝꠄꠖꠣ ꠀꠞ ꠄꠇ ꠡꠦꠞ ꠎꠄꠔꠥꠘꠞ ꠙꠤꠡꠣ ꠔꠦꠟ ꠝꠤꠡꠣꠁꠔꠦ ꠅꠁꠛ। ꠀꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣꠞ ꠟꠣꠉꠤ ꠀꠋꠉꠥꠞꠞ ꠄꠇ ꠡꠦꠞ ꠡꠞꠛꠔꠅ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠦ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","ꠢꠣꠁꠘ꠆ꠎꠣ ꠛꠣꠟꠣ ꠎꠦ ꠝꠦꠠꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠄ, ꠄꠞꠟꠉꠦꠅ ꠛꠤꠀꠘꠇꠥꠞ ꠟꠣꠈꠣꠘ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠀꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣꠞ ꠢꠇꠟꠔꠣ ꠖꠤꠔꠦ ꠅꠁꠛ। ꠁꠔꠣ ꠅꠁꠟ ꠝꠣꠛꠥꠖꠞ ꠘꠤꠅꠔꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠊꠦꠞꠣꠘ ꠀꠟꠣ ꠇꠥꠞꠛꠣꠘꠤ। ");
INSERT INTO syls_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠉꠦꠍꠦ, ꠝꠣꠘꠤ ꠀꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠙꠞꠔꠦꠇ ꠖꠤꠘ ꠁ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠔꠦ ꠅꠁꠛ। ꠢꠘꠅ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠤꠖꠣꠞ ꠖꠤꠝꠥ, ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠉꠦꠍꠦ ꠀꠝꠤ ꠢꠘꠅ ꠖꠤꠖꠣꠞ ꠖꠤꠝꠥ, ꠀꠞ ꠀꠝꠣꠞ ꠇꠥꠖꠞꠔꠦ ꠅꠃ ꠎꠣꠉꠣ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","ꠀꠝꠤ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥ ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠝꠥ। ꠀꠝꠣꠞ ꠁꠝꠣꠝꠔꠤꠞ ꠟꠣꠉꠤ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦꠅ ꠀꠝꠤ ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","ꠀꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠛꠥꠖ ꠅꠁꠀ ꠔꠣꠞꠣꠞ ꠝꠣꠎꠦ ꠛꠡꠔ ꠇꠞꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","ꠔꠦꠃ ꠔꠣꠞꠣ ꠎꠣꠘꠛꠣ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠣꠞꠣꠞ ꠝꠣꠛꠥꠖ। ꠀꠝꠤ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠛꠡꠔ ꠇꠞꠣꠞ ꠟꠣꠉꠤꠃ ꠔ ꠔꠣꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤꠀ ꠀꠘꠍꠤ। ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠣꠞꠣꠞ ꠝꠣꠛꠥꠖ।” ");
INSERT INTO syls_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠁꠛꠣꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠤ ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤꠖꠤ ꠄꠇꠈꠣꠘ ꠐꠦꠛꠥꠟ ꠛꠣꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","ꠁꠉꠥ ꠅꠁꠛ ꠌꠣꠁꠞꠇꠥꠘꠣ ꠀꠟꠣ, ꠄꠇ ꠀꠔ ꠟꠣꠝ꠆ꠛꠣ, ꠄꠇ ꠀꠔ ꠙꠣꠡ, ꠖꠥꠁ ꠀꠔ ꠃꠛꠤ। ꠀꠡ꠆ꠔꠣ ꠈꠣꠘꠃ ꠢꠤꠋ ꠡꠥꠖ꠆ꠖꠣ ꠄꠇꠈꠣꠘꠅ ꠟꠣꠉꠣꠁꠟ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","ꠄꠞ ꠃꠙꠞꠞ ꠍꠣꠘꠤ, ꠍꠣꠘꠤꠞ ꠌꠣꠁꠞꠅ ꠇꠤꠘꠣꠞꠣ ꠀꠞ ꠢꠤꠋ, ꠢꠇꠟꠔꠣ ꠈꠣꠐꠤ ꠡꠥꠘꠣꠖꠤ ꠟꠦꠙꠤꠛꠣꠄ। ꠌꠣꠁꠞꠅ ꠇꠤꠘꠣꠞꠅ ꠡꠥꠘꠣꠞ ꠘꠇꠡꠣ ꠇꠞꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","ꠄꠞ ꠖꠥꠁ ꠇꠤꠘꠣꠞꠞ ꠘꠇꠡꠣꠞ ꠔꠟꠦ ꠖꠥꠉꠥ ꠇꠞꠤ ꠡꠥꠘꠣꠞ ꠇꠠꠣ ꠟꠣꠉꠣꠁꠅ। ꠁ ꠇꠠꠣꠞ ꠜꠤꠔꠞꠦ ꠛꠦꠘ꠆ꠖꠣ ꠢꠣꠞꠣꠁꠀ ꠅꠉꠥ ꠛꠁꠀ ꠘꠦꠅꠀ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","ꠁ ꠛꠦꠘ꠆ꠖꠣ ꠉꠥꠁꠘ ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤꠖꠤ ꠛꠣꠘꠣꠁꠀ ꠡꠥꠘꠣꠖꠤ ꠟꠦꠙꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇꠞ ꠓꠣꠇꠘꠣꠞ ꠇꠣꠍꠣꠔ ꠎꠦ ꠙꠞ꠆ꠖꠣꠈꠣꠘ ꠀꠍꠦ, ꠅꠃ ꠐꠦꠛꠥꠟ ꠄꠞ ꠍꠣꠝꠘꠦ ꠞꠣꠈꠤꠅ। ꠅꠃ ꠎꠣꠉꠣꠔ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠖꠤꠖꠣꠞ ꠖꠤꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“ꠙꠞꠔꠦꠇ ꠖꠤꠘ ꠛꠤꠀꠘꠦ ꠌꠦꠞꠣꠉ ꠉꠥꠁꠘ ꠎꠥꠁꠔ-ꠎꠣꠁꠔ ꠇꠞꠣꠞ ꠛꠣꠟꠣ, ꠢꠣꠞꠥꠘꠦ ꠅꠃ ꠐꠦꠛꠥꠟꠞ ꠃꠙꠞꠦ ꠈꠥꠡꠛꠄ ꠀꠟꠣ ꠀꠉꠞ ꠎꠣꠟꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","ꠢꠣꠁꠘ꠆ꠎꠣ ꠛꠣꠟꠣ ꠌꠦꠞꠣꠉ ꠎꠣꠟꠣꠘꠤꠞ ꠡꠝꠄ, ꠢꠦ ꠢꠤꠞꠛꠣꠞ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠁꠛ। ꠔꠥꠝꠞꠣꠞ ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠢꠞ-ꠢꠣꠝꠦꠡꠣ ꠅꠃ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠟꠛ। ");
INSERT INTO syls_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","ꠁ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠘꠤꠞ ꠐꠦꠛꠥꠟꠞ ꠃꠙꠞꠦ ꠖꠥꠍꠞꠣ ꠇꠥꠘꠥꠎꠣꠔꠞ ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠁꠅ ꠘꠣ। ꠇꠥꠘꠥ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ, ꠛꠣ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣ ꠖꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","ꠉꠥꠘꠣꠞ ꠝꠣꠚꠤꠞ ꠇꠚꠞꠣ ꠢꠤꠡꠣꠛꠦ, ꠢꠣꠞꠥꠘꠦ ꠛꠍꠞꠅ ꠄꠇꠛꠣꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠃ, ꠐꠦꠛꠥꠟꠞ ꠢꠤꠋ ꠅꠇꠟꠞ ꠃꠙꠞꠦ ꠟꠣꠉꠣꠁꠔꠦ ꠅꠁꠛ। ꠔꠦꠃ ꠁꠈꠣꠘ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠝꠢꠣ-ꠙꠛꠤꠔ꠆ꠞ ꠅꠁꠛ। ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠙꠞꠗꠣꠘ ꠁꠝꠣꠝꠦ ꠛꠍꠞꠅ ꠄꠇꠛꠣꠞ ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠞꠔꠦ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“ꠔꠥꠝꠤ ꠎꠦꠛꠟꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠘꠡꠞ ꠙꠞꠤꠝꠣꠘ ꠉꠘꠛꠣꠄ, ꠅꠃ ꠡꠝꠄ ꠔꠣꠞꠣ ꠢꠇꠟꠦꠃ ꠎꠣꠞꠎꠤꠞ ꠎꠣꠘꠞ ꠛꠖꠟꠣ ꠞꠥꠙꠣ ꠖꠤꠔꠦ ꠅꠁꠛ, ꠎꠣꠔꠦ ꠁ ꠉꠘꠣꠞ ꠟꠣꠉꠤ ꠔꠣꠞꠣꠞ ꠃꠙꠞꠦ ꠇꠥꠘꠥ ꠉꠎꠛ ꠘꠣ ꠀꠄ। ");
INSERT INTO syls_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","ꠔꠣꠞꠣꠞꠦ ꠉꠘꠣꠞ ꠛꠣꠟꠣ ꠅꠃꠟꠣ ꠛꠖꠟꠣ ꠟꠁꠅ, ꠉꠘꠣ ꠅꠁꠍꠦ ꠖꠟꠅ ꠎꠦꠞꠣ ꠢꠣꠝꠣꠁꠛꠣ, ꠄꠞꠣ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠝꠣꠙꠦ ꠀꠗꠣ ꠔꠟꠣ ꠞꠥꠙꠣ ꠖꠤꠛꠣ। ꠙꠞꠔꠦꠇ ꠛꠤꠡ ꠞꠔꠤꠄ ꠄꠇ ꠔꠟꠣ ꠉꠘꠤꠅ। ꠁ ꠞꠥꠙꠣ ꠅꠁꠛ ꠝꠣꠛꠥꠖꠞ। ");
INSERT INTO syls_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","ꠛꠤꠡ ꠛꠞꠍ ꠛꠣ ꠄꠞ ꠛꠦꠡꠤ ꠛꠄꠅꠡꠞ ꠎꠦꠇꠥꠘꠥ ꠎꠘ ꠉꠘꠣ ꠡꠦꠡ ꠅꠀ ꠖꠟꠅ ꠢꠣꠝꠣꠁꠟꠦ, ꠄꠘ ꠎꠣꠘꠞ ꠛꠖꠟꠣ ꠝꠣꠛꠥꠖꠞꠦ ꠅꠃ ꠞꠥꠙꠣ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","ꠎꠣꠘꠞ ꠛꠖꠟꠣ ꠖꠦꠅꠀꠞ ꠡꠝꠄ ꠗꠘꠤ ꠅꠇꠟꠦ ꠅꠃ ꠀꠗꠣ ꠔꠟꠣꠞ ꠛꠦꠡꠤ ꠖꠤꠔꠣ ꠙꠣꠞꠔꠣ ꠘꠣꠄ, ꠀꠞ ꠉꠞꠤꠛꠦꠅ ꠇꠝ ꠖꠤꠟꠦ ꠅꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠎꠣꠘꠞ ꠛꠖꠟꠣ ꠅꠃ ꠞꠥꠙꠣ ꠘꠤꠀ, ꠀꠝꠣꠞ ꠊꠞꠞ ꠇꠣꠝꠅ ꠟꠣꠉꠣꠁꠅ। ꠔꠥꠝꠞꠣꠞ ꠎꠣꠘꠞ ꠛꠖꠟꠣ ꠁ ꠞꠥꠙꠣꠄ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠅꠇꠟꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠁꠀꠖ ꠇꠞꠣꠁ ꠖꠤꠛ।” ");
INSERT INTO syls_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“ꠅꠎꠥ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠤ ꠙꠤꠔꠟꠞ ꠄꠇꠐꠣ ꠉꠣꠝꠟꠣ, ꠀꠞ ꠉꠣꠝꠟꠣ ꠕꠅꠀꠞ ꠟꠣꠉꠤ ꠙꠤꠔꠟꠞ ꠄꠇꠈꠣꠘ ꠌꠇꠤ-ꠈꠣꠐ ꠛꠣꠘꠣꠁꠅ। ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥ ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠝꠣꠎꠈꠣꠘꠅ ꠙꠣꠘꠤ ꠜꠞꠤꠀ ꠅꠉꠥ ꠕꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","ꠁ ꠙꠣꠘꠤꠖꠤ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠅꠎꠥ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","ꠔꠣꠞꠣ ꠎꠣꠔꠦ ꠘꠣ ꠝꠞꠂꠘ, ꠄꠞꠟꠣꠉꠤ ꠙꠞꠔꠦꠇꠛꠣꠞ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠔ ꠢꠣꠝꠣꠁꠛꠣꠞ ꠛꠣꠟꠣ ꠅꠃ ꠙꠣꠘꠤꠖꠤ ꠅꠎꠥ ꠇꠞꠔꠦ ꠅꠁꠛ। ꠁꠝꠣꠝ ꠢꠤꠡꠣꠛꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠎꠦꠇꠥꠘꠥ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠡꠝꠄꠅ ꠅꠎꠥ ꠇꠞꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","ꠔꠣꠞꠣ ꠎꠣꠘꠦ ꠛꠣꠌꠤꠀ ꠞꠅꠀꠞ ꠟꠣꠉꠤ ꠅꠃ ꠅꠎꠥ ꠇꠞꠛꠣ। ꠁ ꠢꠥꠇꠥꠝ ꠔꠣꠞꠣꠞ ꠟꠣꠉꠤ ꠢꠞ-ꠢꠣꠝꠦꠡꠣ ꠌꠣꠟꠥ ꠞꠁꠛ, ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠛꠅꠀꠁꠟ ꠞꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“ꠔꠥꠝꠣꠞ ꠘꠤꠎꠞ ꠉꠦꠍꠦ ꠈꠥꠡꠛꠄꠖꠣꠞ ꠜꠣꠟꠣ ꠜꠣꠟꠣ ꠝꠡꠟꠣ ꠅꠇꠟ ꠖꠟꠣ ꠇꠞꠅ। ꠔꠥꠝꠤ ꠙꠣꠌ-ꠡ ꠔꠟꠣ ꠝꠥꠞꠣ ꠘꠣꠝꠞ ꠀꠔꠞ, ꠀꠠꠣꠁ-ꠡ ꠔꠟꠣ ꠈꠥꠡꠛꠄ ꠀꠟꠣ ꠒꠣꠁꠟꠌꠤꠘꠤ, ꠀꠞ ꠀꠠꠣꠁ-ꠡ ꠔꠟꠣ ꠛꠍ, ");
INSERT INTO syls_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ꠡꠣꠗꠣꠞꠘ ꠒꠣꠁꠟꠌꠤꠘꠤ ꠙꠣꠌ-ꠡ ꠔꠟꠣ, ꠀꠞ ꠎꠄꠔꠥꠘꠞ ꠔꠦꠟ ꠌꠣꠁꠞ ꠡꠦꠞ ꠖꠟꠣ ꠇꠞꠤꠅ। ꠁ ꠝꠣꠙ ꠅꠁꠟ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠝꠣꠙꠦ। ");
INSERT INTO syls_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","ꠅꠃ ꠝꠡꠟꠣ ꠅꠇꠟ ꠖꠤꠀ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠝꠡꠟꠣ ꠛꠣꠘꠣꠘꠤꠞ ꠇꠣꠞꠤꠉꠞꠞ ꠘꠤꠅꠝꠦ ꠔꠥꠝꠤ ꠈꠦꠟꠣꠚꠔꠤ ꠡꠝꠎꠤꠛꠣꠞ ꠔꠦꠟ ꠛꠣꠘꠣꠁꠅ, ꠁ ꠔꠦꠟ ꠔ ꠙꠛꠤꠔ꠆ꠞ। ");
INSERT INTO syls_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","ꠅꠃ ꠔꠦꠟ ꠖꠤꠀ ꠔꠥꠝꠤ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥ, ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇ, ");
INSERT INTO syls_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ꠐꠦꠛꠥꠟ, ꠐꠦꠛꠥꠟꠞ ꠃꠙꠞꠞ ꠢꠇꠟ ꠍꠣꠝꠣꠘꠣ, ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤꠞ ꠢꠇꠟꠔꠣ, ꠀꠞ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠘꠤꠞ ꠐꠦꠛꠥꠟ, ");
INSERT INTO syls_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠀꠞ ꠄꠞ ꠝꠣꠎꠞ ꠢꠇꠟ ꠍꠣꠝꠣꠘꠣ, ꠅꠎꠥꠞ ꠉꠣꠝꠟꠣ ꠀꠞ ꠄꠞ ꠔꠟꠞ ꠌꠇꠤ-ꠈꠣꠐ ꠢꠇꠟꠔꠣꠞꠦ ꠚꠥꠍꠤꠀ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","ꠔꠦꠃ ꠁ ꠢꠇꠟꠔꠣ ꠝꠢꠣ-ꠙꠛꠤꠔ꠆ꠞ ꠍꠣꠝꠣꠘꠣ ꠅꠁꠛ। ꠁꠔꠣ ꠍꠣꠝꠣꠘꠣ ꠇꠦꠃ ꠍꠁꠟꠦ, ꠢꠦ-ꠅ ꠝꠢꠣ-ꠙꠛꠤꠔ꠆ꠞ ꠅꠁꠎꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“ꠔꠥꠝꠤ ꠢꠣꠞꠥꠘꠞꠦ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘꠞꠦ ꠀꠝꠣꠞ ꠁꠝꠣꠝꠔꠤꠞ ꠇꠣꠝꠞ ꠟꠣꠉꠤ ꠈꠦꠟꠣꠚꠔꠤꠞ ꠔꠦꠟ ꠖꠤꠀ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠤꠅ, ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠁꠐꠣꠃ ꠅꠁꠛ ꠀꠝꠣꠞ ꠈꠦꠟꠣꠚꠔꠤ ꠡꠝꠎꠤꠛꠣꠞ ꠙꠛꠤꠔ꠆ꠞ ꠔꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","ꠁ ꠔꠦꠟ ꠝꠣꠘꠡꠞ ꠉꠔꠞꠅ ꠖꠦꠅꠀ ꠎꠣꠁꠔ ꠘꠣꠄ। ꠁ ꠘꠤꠅꠝꠦ ꠔꠣꠞꠣ ꠎꠣꠔꠦ ꠀꠞ ꠇꠥꠘꠥ ꠔꠦꠟ ꠘꠣ ꠛꠣꠘꠣꠄ। ꠁ ꠔꠦꠟ ꠔ ꠙꠛꠤꠔ꠆ꠞ। ꠔꠥꠝꠞꠣ ꠁꠐꠣꠞꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠝꠘꠅ ꠇꠞꠤꠀ ꠁꠎ꠆ꠎꠔ ꠇꠞꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","ꠇꠦꠃ ꠎꠥꠖꠤ ꠁ ꠟꠣꠈꠣꠘ ꠔꠦꠟ ꠔꠂꠀꠞ ꠇꠞꠦ, ꠛꠣ ꠁꠝꠣꠝ ꠍꠣꠛ ꠍꠣꠠꠣ ꠀꠞ ꠇꠦꠃ ꠁ ꠔꠦꠟ ꠉꠔꠞꠅ ꠝꠣꠈꠦ, ꠔꠦ ꠔꠣꠞꠦ ꠘꠤꠎꠞ ꠎꠣꠔꠤ ꠕꠣꠇꠤ ꠚꠥꠍꠤꠟꠤꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠘꠤꠎꠞ ꠉꠦꠍꠦ ꠇꠤꠍꠥ ꠈꠥꠡꠛꠄ ꠀꠟꠣ ꠝꠡꠟꠣ: ꠉꠥꠉꠉꠥꠟꠥ, ꠘꠈꠤ, ꠇꠥꠘ꠆ꠖꠥꠞꠥ ꠀꠞ ꠈꠣꠐꠤ ꠟꠥꠛꠣꠘ ꠖꠟꠣ ꠇꠞꠤꠅ। ꠖꠟꠣ ꠇꠞꠤꠀ ꠅꠔꠣ ꠢꠝꠣꠘ ꠢꠝꠣꠘ ꠇꠞꠤ ꠝꠤꠡꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","ꠀꠞ ꠎꠦꠞꠣ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠛꠣꠘꠣꠁꠘ, ꠔꠣꠞꠣꠞꠦꠖꠤ ꠅꠃ ꠇꠣꠝ ꠇꠞꠣꠁꠅ। ꠁꠔꠣꠞ ꠟꠉꠦ ꠘꠥꠘ ꠝꠤꠡꠣꠁꠅ, ꠁꠔꠣ ꠅꠁꠛ ꠘꠤꠞꠜꠦꠎꠣꠟ ꠈꠣꠐꠤ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠀꠉꠞ। ");
INSERT INTO syls_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","ꠅꠃ ꠀꠉꠞꠞ ꠕꠥꠠꠣ ꠉꠥꠠꠣ ꠘꠤꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇꠞ ꠍꠣꠝꠘꠦ ꠕꠁꠅ। ꠢꠘꠅ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠖꠤꠖꠣꠞ ꠖꠤꠝꠥ। ꠔꠥꠝꠞꠣ ꠁ ꠀꠉꠞꠞꠦ ꠝꠢꠣ-ꠙꠛꠤꠔ꠆ꠞ ꠍꠣꠝꠣꠘꠣ ꠝꠘꠅ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","ꠅꠃ ꠝꠡꠟꠣ ꠖꠤꠀ ꠁ ꠘꠤꠅꠝꠦ ꠇꠦꠃ ꠎꠣꠔꠦ ꠔꠣꠞ ꠘꠤꠎꠞ ꠟꠣꠉꠤ ꠇꠥꠘꠥ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠘꠣ ꠛꠣꠘꠣꠄ। ꠁꠔꠣ ꠔ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠌꠤꠎ, ꠁꠈꠣꠘ ꠈꠤꠀꠟ ꠞꠣꠈꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","ꠈꠥꠡꠛꠄꠖꠣꠞ ꠌꠤꠎ ꠝꠘꠅ ꠇꠞꠤꠀ ꠇꠦꠃ ꠎꠥꠖꠤ ꠁꠔꠣ ꠔꠂꠀꠞ ꠇꠞꠤꠟꠣꠄ, ꠔꠦ ꠔꠣꠞꠦ ꠁ ꠎꠣꠔꠤ ꠕꠣꠇꠤ ꠚꠥꠍꠤꠟꠤꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“ꠢꠥꠘꠅ, ꠀꠝꠤ ꠄꠢꠥꠖꠣ ꠉꠥꠡ꠆ꠐꠤꠞ ꠢꠥꠞꠞ ꠘꠣꠔꠤ, ꠃꠞꠤꠞ ꠙꠥꠀ ꠛꠣꠔꠍꠦꠟꠟꠞꠦ ꠙꠍꠘ꠆ꠖ ꠇꠞꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ꠀꠝꠤ ꠔꠣꠞꠦ ꠀꠟ꠆ꠟꠣꠁ ꠞꠥꠢꠥ ꠖꠤꠀ ꠇꠣꠝꠤꠟ ꠇꠞꠍꠤ। ꠢꠇꠟ ꠟꠣꠈꠣꠘ ꠇꠣꠞꠤꠉꠞꠤ ꠇꠣꠝꠞ ꠀꠈꠟ-ꠛꠥꠖ꠆ꠖꠤ, ꠛꠤꠖ꠆ꠖꠣꠄ ꠃꠡ꠆ꠔꠣꠖꠤ ꠇꠣꠝꠞ ꠈꠦꠝꠔꠣ ꠖꠤꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ꠄꠞꠟꠣꠉꠤ ꠢꠦ ꠡꠥꠘꠣ, ꠞꠥꠙꠣ, ꠙꠤꠔꠟꠞ ꠃꠙꠞꠦ ꠡꠥꠘ꠆ꠖꠞ ꠡꠥꠘ꠆ꠖꠞ ꠘꠇꠡꠣ ꠛꠣꠘꠣꠁꠔ ꠙꠣꠞꠛ। ");
INSERT INTO syls_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ꠖꠣꠝꠤ ꠖꠣꠝꠤ ꠙꠣꠔ꠆ꠔꠞ ꠇꠣꠐꠤꠀ ꠝꠘꠤ-ꠝꠥꠇ꠆ꠔꠣ ꠟꠣꠉꠣꠘꠤ, ꠟꠣꠇꠠꠤꠞ ꠃꠙꠞꠦ ꠘꠇꠡꠣꠞ ꠇꠣꠝ ꠀꠞ ꠢꠇꠟ ꠎꠣꠔꠞ ꠀꠔꠞ ꠇꠣꠝ ꠇꠞꠔ ꠙꠣꠞꠛ। ");
INSERT INTO syls_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","ꠔꠣꠞ ꠎꠥꠉꠣꠟꠤ ꠢꠤꠡꠣꠛꠦ ꠀꠝꠤ ꠖꠣꠘ ꠉꠥꠡ꠆ꠐꠤꠞ ꠅꠢꠤꠍꠣꠝꠣꠇꠞ ꠙꠥꠀ ꠀꠢꠟꠤꠀꠛꠞꠦ ꠙꠍꠘ꠆ꠖ ꠇꠞꠍꠤ। ꠎꠦ ꠃꠡ꠆ꠔꠣꠖ ꠅꠇꠟꠦ ꠁ ꠇꠣꠝ ꠇꠞꠔꠣ ꠙꠣꠞꠛꠣ, ꠀꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠇꠣꠝꠞ ꠀꠈꠟ ꠖꠤꠍꠤ, ꠎꠣꠔꠦ ꠔꠥꠝꠣꠞꠦ ꠛꠣꠔꠣꠁꠟ ꠀꠝꠣꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ, ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠔꠣꠞꠣ ꠛꠣꠘꠣꠁꠔꠣ ꠙꠣꠞꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","ꠔꠣꠞꠣ ꠛꠣꠘꠣꠁꠛꠣ, ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥ, ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇ, ꠄꠞ ꠃꠙꠞꠞ ꠓꠣꠇꠘꠣ, ꠔꠣꠝ꠆ꠛꠥꠞ ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ, ");
INSERT INTO syls_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ꠐꠦꠛꠥꠟ, ꠐꠦꠛꠥꠟꠞ ꠟꠉꠞ ꠌꠤꠎ ꠅꠇꠟ, ꠈꠣꠐꠤ ꠡꠥꠘꠣꠞ ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤ, ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤꠞ ꠟꠉꠞ ꠢꠇꠟꠔꠣ ꠀꠞ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠘꠤꠞ ꠐꠦꠛꠥꠟ, ");
INSERT INTO syls_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠀꠞ ꠄꠞ ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ, ꠢꠣꠘ꠆ꠒꠤ-ꠛꠣꠡꠘ, ꠅꠎꠥꠞ ꠙꠣꠘꠤꠞ ꠉꠣꠝꠟꠣ ꠀꠞ ꠄꠞ ꠌꠇꠤ-ꠈꠣꠐ, ");
INSERT INTO syls_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ꠁꠝꠣꠝꠔꠤ ꠇꠣꠝꠞ ꠟꠣꠉꠤ ꠢꠣꠞꠥꠘꠞ ꠁꠝꠣꠝꠔꠤꠞ ꠟꠦꠛꠣꠍ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠟꠦꠛꠣꠍ, ");
INSERT INTO syls_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ꠈꠦꠟꠣꠚꠔꠤꠞ ꠔꠦꠟ, ꠙꠣꠇ ꠎꠣꠉꠣꠞ ꠟꠣꠉꠤ ꠈꠥꠡꠛꠄ ꠀꠟꠣ ꠀꠉꠞ। ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠤ, ꠄꠇ꠆ꠇꠦꠞꠦ ꠅꠃ ꠟꠣꠈꠣꠘ ꠔꠣꠞꠣ ꠛꠣꠘꠣꠁꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“ꠔꠥꠝꠤ ꠘꠤꠎꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠅ, ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠖꠦꠅꠀ ꠙꠞꠔꠦꠇ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞ ꠝꠣꠘꠤꠅ। ꠁ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞ ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠔꠥꠝꠞꠣ ꠀꠞ ꠀꠝꠣꠞ ꠝꠣꠎꠦ ꠄꠇ ꠘꠤꠡꠣꠘꠣ ꠅꠁꠛ, ꠎꠣꠔꠦ ꠔꠥꠝꠞꠣ ꠛꠥꠎꠛꠣꠄ, ꠀꠝꠤꠃ ꠝꠣꠛꠥꠖ, ꠀꠞ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠀꠝꠣꠞ ꠙꠛꠤꠔ꠆ꠞ ꠛꠘ꠆ꠖꠣ ꠅꠀꠞ ꠟꠣꠉꠤ ꠀꠟꠣꠖꠣ ꠇꠞꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ꠔꠥꠝꠞꠣ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞ ꠝꠣꠘꠤꠅ, ꠅꠃ ꠖꠤꠘꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠙꠣꠇ ꠖꠤꠘ ꠇꠞꠣ ꠅꠁꠍꠦ। ꠇꠦꠃ ꠎꠥꠖꠤ ꠁ ꠖꠤꠘ ꠘꠣ ꠝꠣꠘꠦ, ꠔꠦ ꠔꠣꠞꠦ ꠝꠣꠞꠤꠟꠤꠔꠦ ꠅꠁꠛ। ꠎꠦ ꠝꠣꠘꠡꠦ ꠁꠖꠤꠘ ꠇꠥꠘꠥꠎꠣꠔ ꠇꠣꠝ ꠇꠞꠛ, ꠔꠣꠞꠦ ꠔꠣꠞ ꠎꠣꠔꠤꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠚꠥꠍꠤꠟꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ꠔꠥꠝꠞꠣ ꠢꠣꠙ꠆ꠔꠣꠞ ꠍꠄꠖꠤꠘ ꠇꠣꠝ ꠇꠞꠤꠅ, ꠅꠁꠟꠦ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠞꠣꠝꠞ ꠖꠤꠘ, ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞ। ꠡꠥꠇ꠆ꠞꠛꠣꠞ ꠡꠥꠞꠥꠎ ꠒꠥꠛꠣ ꠕꠣꠇꠤ ꠡꠘꠤꠛꠣꠞ ꠡꠥꠞꠥꠎ ꠒꠥꠛꠣꠞ ꠀꠉ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞ। ꠁ ꠖꠤꠘ ꠎꠦ ꠝꠣꠘꠡꠦ ꠇꠣꠝ ꠇꠞꠛ, ꠔꠣꠞꠦ ꠝꠣꠞꠤꠟꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠅꠇꠟꠦ ꠀꠝꠣꠞ ꠖꠦꠅꠀ ꠌꠤꠞꠇꠣꠟꠤꠘ ꠘꠤꠅꠝ ꠢꠤꠡꠣꠛꠦ, ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠢꠞ-ꠢꠣꠝꠦꠡꠣ ꠁ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞ ꠝꠣꠘꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","ꠁ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞ ꠔ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠀꠞ ꠀꠝꠣꠞ ꠝꠣꠎꠦ ꠢꠣꠝꠦꠡꠣꠇꠥꠞ ꠟꠣꠉꠤ ꠌꠤꠞꠇꠣꠟꠤꠘ ꠄꠇ ꠘꠤꠡꠣꠘꠣ। ꠇꠣꠞꠘ ꠍꠄꠖꠤꠘꠦ ꠝꠣꠛꠥꠖꠦ ꠀꠍꠝꠣꠘ-ꠎꠝꠤꠘ ꠢꠇꠟꠔꠣ ꠙꠄꠖꠣ ꠇꠞꠟꠣ, ꠅꠁꠟꠦ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠇꠥꠘꠥ ꠇꠣꠝ ꠘꠣ ꠇꠞꠤꠀ ꠎꠤꠞꠣꠁꠟꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","ꠝꠣꠛꠥꠖꠦ ꠔꠥꠞ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠢꠎꠞꠔ ꠝꠥꠍꠣꠞ ꠟꠉꠦ ꠅꠃ ꠛꠣꠔꠌꠤꠔ ꠡꠦꠡ ꠇꠞꠤꠀ ꠢꠣꠞꠟꠦ, ꠝꠥꠍꠣꠞ ꠀꠔꠅ ꠖꠥꠁ ꠐꠥꠇꠞꠣ ꠡꠣꠢꠣꠖꠔ ꠙꠣꠔ꠆ꠔꠞ ꠖꠤꠟꠣ। ꠅꠃ ꠙꠣꠔ꠆ꠔꠞꠞ ꠝꠣꠎꠦ ꠀꠟ꠆ꠟꠣ ꠙꠣꠇꠦ ꠔꠣꠘ ꠘꠤꠎꠞ ꠀꠔꠦ ꠔꠣꠘ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠟꠦꠈꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","ꠝꠥꠍꠣ ꠘꠛꠤ ꠙꠣꠠ ꠕꠣꠇꠤ ꠟꠣꠝꠤꠀ ꠀꠁꠔꠦ ꠖꠦꠞꠤ ꠅꠞ ꠖꠦꠈꠤꠀ, ꠝꠣꠘꠡꠦ ꠀꠁꠀ ꠢꠣꠞꠥꠘꠞ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠖꠟꠣ ꠅꠁꠀ ꠇꠁꠟꠣ, “ꠀꠝꠞꠣꠞꠦ ꠙꠕ ꠌꠤꠘꠣꠁꠀ ꠘꠦꠅꠀꠞ ꠟꠣꠉꠤ, ꠀꠙꠘꠦ ꠀꠝꠞꠣꠞꠦ ꠖꠦꠛꠔꠣ ꠛꠣꠘꠣꠁ ꠖꠦꠃꠇ꠆ꠇꠣ। ꠇꠣꠞꠘ, ꠎꠦ ꠝꠥꠍꠣꠄ ꠀꠝꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠍꠦ, ꠔꠣꠞ ꠇꠤꠔꠣ ꠊꠐꠍꠦ ꠀꠝꠞꠣ ꠔ ꠎꠣꠘꠤ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠢꠣꠞꠥꠘꠦ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠎꠣꠞꠎꠤꠞ ꠛꠃ ꠀꠞ ꠙꠥꠀ-ꠙꠥꠠꠤꠘ꠆ꠔꠞ ꠇꠣꠘꠅ ꠕꠣꠇꠤ ꠡꠥꠘꠣꠞ ꠉꠄꠘꠣ ꠈꠥꠟꠤꠀ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠀꠘꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","ꠔꠦꠃ ꠢꠇꠟꠦ ꠔꠣꠞꠣꠞ ꠇꠣꠘꠞ ꠉꠄꠘꠣ ꠈꠥꠟꠤꠀ ꠢꠣꠞꠥꠘꠞ ꠉꠦꠍꠦ ꠀꠘꠤꠀ ꠖꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","ꠝꠣꠘꠡꠦ ꠎꠦꠔꠣ ꠡꠥꠘꠣ ꠀꠘꠤꠀ ꠖꠤꠟꠣ, ꠢꠣꠞꠥꠘꠦ ꠅꠔꠣ ꠘꠤꠀ ꠀꠉꠥꠁꠘꠖꠤ ꠉꠟꠣꠁꠀ, ꠢꠥꠘꠣꠞꠞ ꠀꠔꠤꠀꠞꠖꠤ ꠄꠇ ꠛꠣꠍꠥꠞꠞ ꠝꠥꠞ꠆ꠔꠤ ꠛꠣꠘꠣꠁꠟꠣ। ꠅꠉꠥ ꠖꠦꠈꠤꠀ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠇꠁꠟꠣ, “ꠜꠣꠁ ꠅꠇꠟ, ꠅꠃ ꠄꠁꠘꠃ ꠔꠥꠝꠞꠣꠞ ꠖꠦꠛꠔꠣ, ꠎꠦꠁꠘ ꠔꠥꠝꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","ꠁ ꠢꠣꠟꠔ ꠖꠦꠈꠤꠀ ꠢꠣꠞꠥꠘꠦ ꠢꠃ ꠛꠣꠍꠥꠞꠞ ꠍꠣꠝꠘꠦ ꠄꠇ ꠛꠟꠤ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠁꠀ ꠎꠣꠘꠣꠁ ꠖꠤꠟꠣ, “ꠍꠣꠝꠘꠞ ꠇꠣꠁꠟ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠈꠥꠡꠤ-ꠛꠣꠡꠤ ꠇꠞꠣ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","ꠔꠦꠃ ꠛꠣꠖꠞ ꠖꠤꠘ ꠈꠥꠛ ꠍꠛꠞꠦ ꠃꠑꠤꠀ ꠝꠣꠘꠡꠦ ꠖꠦꠛꠔꠣꠞ ꠍꠣꠝꠘꠦ ꠀꠁꠀ ꠝꠋꠉꠟ ꠛꠟꠤ ꠀꠞ ꠙꠡꠥ ꠎꠣꠟꠣꠁꠀ ꠛꠟꠤ ꠖꠤꠟꠣ। ꠛꠣꠖꠦ ꠔꠣꠞꠣ ꠈꠣꠅꠀ-ꠖꠣꠅꠀ ꠇꠞꠤꠀ ꠢꠣꠞꠤ, ꠢꠂ-ꠢꠥꠟ꠆ꠟꠣ ꠇꠞꠤ ꠘꠣꠌ-ꠉꠣꠘ, ꠚꠥꠞ꠆ꠔꠤ-ꠀꠝꠥꠖ ꠇꠞꠣꠔ ꠟꠣꠉꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","ꠅꠃ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠙꠣꠠꠞ ꠟꠣꠝꠣꠔ ꠎꠣꠅ। ꠔꠥꠝꠣꠞ ꠅꠃ ꠎꠦꠔꠣ ꠝꠣꠘꠡꠞꠦ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠍ, ꠁꠔꠣ ꠔ ꠘꠣꠚꠞꠝꠣꠘ ꠛꠘꠤꠉꠦꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","ꠀꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠎꠦꠟꠣ ꠌꠟꠣꠞ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣꠝ, ꠔꠣꠞꠣ ꠁꠔꠣ ꠛꠣꠖ ꠖꠤꠀ ꠘꠤꠎꠞ ꠟꠣꠉꠤ ꠄꠇ ꠛꠣꠍꠥꠞꠞ ꠝꠥꠞ꠆ꠔꠤ ꠛꠣꠘꠣꠁꠀ, ꠝꠣꠐꠤꠔ ꠙꠠꠤꠀ ꠅꠉꠥꠞꠦ ꠙꠞꠘꠣꠝ ꠇꠞꠦꠞ। ꠅꠉꠥꠞ ꠘꠣꠝꠦ ꠔꠣꠞꠣ ꠙꠡꠥ ꠛꠟꠤ ꠖꠦꠞ ꠀꠞ ꠇꠞ, ꠜꠣꠁ ꠅꠇꠟ, ꠅꠃ ꠄꠁꠘꠃ ꠔꠥꠝꠞꠣꠞ ꠖꠦꠛꠔꠣ, ꠎꠦꠁꠘ ꠔꠥꠝꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠁꠔꠣ ꠝꠣꠘꠡꠞꠦ ꠌꠤꠘꠤ, ꠁꠔꠣ ꠔ ꠉꠣꠠꠔꠦꠠꠣ-ꠄꠇꠉꠥꠁꠀ ꠎꠣꠔ। ");
INSERT INTO syls_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","ꠅꠈꠘ ꠔꠥꠝꠤ ꠀꠝꠣꠞꠦ ꠛꠣꠗꠣ ꠖꠤꠅ ꠘꠣ, ꠁꠔꠣꠞ ꠃꠙꠞꠦ ꠀꠝꠣꠞ ꠉꠥꠍꠣ ꠀꠉꠥꠁꠘꠞ ꠟꠣꠈꠣꠘ ꠖꠣꠃ ꠖꠣꠃ ꠇꠞꠤ ꠎꠟꠦꠞ, ꠀꠝꠤ ꠁꠔꠣꠞꠦ ꠍꠣꠞꠈꠣꠞ ꠇꠞꠤꠟꠤꠝꠥ। ꠛꠣꠖꠦ ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠄꠇ ꠝꠢꠣ ꠎꠣꠔꠤ ꠙꠄꠖꠣ ꠇꠞꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","ꠔꠦꠃ ꠝꠥꠍꠣꠄ ꠔꠣꠘ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞꠦ ꠝꠤꠘꠔ-ꠇꠣꠎ꠆ꠎꠤ ꠇꠞꠤꠀ ꠇꠁꠟꠣ, “ꠅ ꠝꠣꠛꠥꠖ, ꠔꠥꠝꠤ ꠔꠥꠝꠣꠞ ꠇꠥꠖꠞꠔꠤ ꠀꠔ ꠖꠤꠀ ꠔꠥꠝꠣꠞ ꠝꠢꠣ ꠇꠥꠖꠞꠔꠤ ꠛꠟꠦ ꠎꠦꠔꠣꠞꠦ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠍ, ꠔꠣꠞꠣꠞ ꠃꠙꠞꠦ ꠔꠥꠝꠤ ꠇꠦꠘꠦ ꠅꠔ ꠉꠥꠍꠣ ꠅꠁꠟꠣꠄ? ");
INSERT INTO syls_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","ꠝꠤꠡꠞꠤ ꠅꠇꠟꠦ ꠇꠦꠘꠦ ꠁꠈꠣꠘ ꠝꠣꠔꠣꠞ ꠡꠥꠎꠥꠉ ꠙꠣꠁꠔꠣ, ꠙꠣꠠꠤꠀ ꠄꠟꠣꠇꠣꠔ ꠀꠘꠤꠀ ꠔꠣꠞꠣꠞꠦ ꠈꠔꠝ ꠇꠞꠤꠀ, ꠖꠥꠘꠤꠀ ꠕꠣꠇꠤ ꠔꠣꠞꠣꠞ ꠘꠣꠝ ꠝꠤꠐꠣꠁꠟꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤꠀ ꠀꠘꠍ? ꠝꠣꠛꠥꠖ ꠉ, ꠔꠥꠝꠣꠞ ꠁ ꠛꠦꠕꠣꠄꠀ ꠉꠥꠍꠣꠈꠣꠘ ꠔꠥꠝꠤ ꠕꠣꠝꠣꠁꠟꠣꠅ। ꠝꠦꠢꠦꠞꠛꠣꠘꠤ ꠇꠞꠤ, ꠔꠥꠝꠣꠞ ꠛꠘ꠆ꠖꠣ ꠅꠇꠟꠞ ꠃꠙꠞꠦ ꠁ ꠉꠎꠛꠈꠣꠘ ꠀꠘꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","ꠔꠥꠝꠣꠞ ꠀꠙꠘ ꠉꠥꠟꠣꠝ ꠁꠛ꠆ꠞꠣꠢꠤꠝ, ꠁꠍꠢꠣꠇ ꠀꠞ ꠁꠀꠇꠥꠛꠞ ꠇꠕꠣ ꠁꠀꠖ ꠇꠞꠅ। ꠔꠥꠝꠤ ꠘꠤꠎꠞ ꠘꠣꠝꠦ ꠇꠍꠝ ꠈꠣꠁꠀ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠍꠟꠣꠄ, ꠔꠣꠞꠣꠞ ꠅꠀꠞꠤꠡ ꠅꠇꠟꠞꠦ ꠔꠥꠝꠤ ꠀꠍꠝꠣꠘꠞ ꠔꠦꠞꠣꠞ ꠟꠣꠈꠣꠘ ꠛꠣꠠꠣꠁꠛꠣꠄ, ꠀꠞ ꠔꠥꠝꠣꠞ ꠅꠀꠖꠣ ꠇꠞꠣ ꠅꠃ ꠀꠡ꠆ꠔꠣ ꠖꠦꠡꠞ ꠝꠣꠟꠤꠇꠣꠘꠣꠅ ꠔꠣꠞꠣꠞꠦ ꠖꠤꠛꠣꠄ, ꠀꠞ ꠔꠣꠞꠣ ꠢꠞ-ꠢꠣꠝꠦꠡꠣꠇꠥꠞ ꠟꠣꠉꠤ ꠄꠞ ꠖꠈꠟ ꠙꠣꠁꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠝꠦꠢꠦꠞꠛꠣꠘꠤ ꠅꠁꠟ। ꠔꠣꠁꠘ ꠔꠣꠘ ꠛꠘ꠆ꠖꠣ ꠅꠇꠟꠞ ꠃꠙꠞꠦ ꠎꠦ ꠉꠎꠛ ꠓꠣꠟꠤꠔꠣ ꠌꠣꠁꠍꠟꠣ, ꠁꠔꠣ ꠛꠣꠖ ꠖꠤꠟꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","ꠄꠞꠛꠣꠖꠦ ꠝꠥꠍꠣꠄ ꠀꠟ꠆ꠟꠣꠞ ꠖꠦꠅꠀ ꠖꠥꠁꠅꠈꠣꠘ ꠡꠣꠢꠣꠖꠔ ꠙꠣꠔ꠆ꠔꠞ ꠟꠁꠀ ꠟꠣꠝꠣꠔ ꠀꠁꠟꠣ। ꠁ ꠙꠣꠔ꠆ꠔꠞꠞ ꠃꠟꠐꠣ-ꠜꠣꠐꠤꠅꠟ ꠖꠥꠁꠅ ꠉꠣꠟꠣꠔ ꠟꠦꠈꠣ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","ꠁ ꠖꠥꠁꠅ ꠙꠣꠔ꠆ꠔꠞ ꠅꠁꠟ ꠀꠟ꠆ꠟꠣ ꠙꠣꠇꠞ ꠘꠤꠎꠞ ꠀꠔꠞ ꠇꠣꠝ, ꠀꠞ ꠁ ꠙꠣꠔ꠆ꠔꠞꠞ ꠃꠙꠞꠦ ꠈꠥꠖꠤꠀ ꠟꠦꠈꠣ ꠈꠣꠘꠅ ꠔꠣꠘ ꠘꠤꠎꠞ ꠀꠔꠞ ꠟꠦꠈꠣ। ");
INSERT INTO syls_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","ꠝꠥꠍꠣꠞ ꠈꠣꠖꠤꠝ ꠁꠃꠍꠣꠄ ꠝꠣꠘꠡꠞ ꠁꠔꠣ ꠢꠂ-ꠢꠥꠟ꠆ꠟꠣ ꠢꠥꠘꠤꠀ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠍꠣꠛ, ꠀꠝꠞꠣꠞ ꠇꠦꠝ꠆ꠙꠞ ꠝꠣꠎꠦ ꠎꠥꠖ꠆ꠖꠞ ꠀꠅꠀꠎ ꠢꠥꠘꠣ ꠎꠣꠞ।” ");
INSERT INTO syls_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","ꠝꠥꠍꠣꠄ ꠇꠁꠟꠣ, “ꠁꠔꠣ ꠔ ꠇꠥꠘꠥ ꠎꠥꠖ꠆ꠖꠞ ꠀꠞꠣ-ꠎꠤꠔꠣꠞ ꠀꠅꠀꠎ ꠘꠣꠄ। ꠀꠝꠤ ꠎꠦꠔꠣ ꠢꠥꠘꠤꠀꠞ, ꠁꠔꠣ ꠔ ꠉꠣꠘꠞ ꠀꠅꠀꠎꠞ ꠟꠣꠈꠣꠘ ꠟꠣꠉꠦꠞ।” ");
INSERT INTO syls_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","ꠛꠣꠖꠦ ꠝꠥꠍꠣꠄ ꠇꠦꠝ꠆ꠙꠞ ꠇꠣꠍꠣꠔ ꠀꠁꠀ ꠝꠣꠘꠡꠞ ꠘꠣꠌꠣ-ꠘꠣꠌꠤ ꠀꠞ ꠛꠣꠍꠥꠞꠞ ꠝꠥꠞ꠆ꠔꠤ ꠖꠦꠈꠟꠣ। ꠖꠦꠈꠤꠀꠃ ꠔꠣꠁꠘ ꠉꠥꠍꠣꠄ ꠀꠉꠥꠁꠘ ꠅꠁꠀ, ꠀꠔꠞ ꠙꠣꠔ꠆ꠔꠞ ꠖꠥꠁꠅꠈꠣꠘ ꠁꠐꠣ ꠝꠣꠞꠤ ꠚꠣꠟꠣꠁ ꠖꠤꠟꠣ। ꠔꠦꠃ ꠙꠣꠔ꠆ꠔꠞ ꠖꠥꠁꠅꠈꠣꠘ ꠙꠣꠠꠞ ꠔꠟꠦ ꠙꠠꠤꠀ ꠌꠥꠞꠝꠣꠞ ꠅꠁꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","ꠀꠞ ꠝꠥꠍꠣꠄ ꠔꠣꠞꠣꠞ ꠛꠣꠘꠣꠁꠟ ꠛꠣꠍꠥꠞꠞ ꠝꠥꠞ꠆ꠔꠤ ꠘꠤꠀ ꠀꠉꠥꠘꠤꠔ ꠚꠣꠟꠣꠁꠀ ꠎꠣꠟꠣꠁꠟꠤꠟꠣ। ꠛꠣꠖꠦ ꠅꠉꠥꠞꠦ ꠙꠤꠡꠤꠀ ꠉꠥꠠꠣ ꠛꠣꠘꠣꠁꠀ ꠙꠣꠘꠤꠔ ꠝꠤꠡꠣꠁꠀ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠅꠇꠟꠞꠦ ꠈꠣꠅꠀꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","ꠔꠣꠁꠘ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, “ꠁꠔꠣ ꠝꠣꠘꠡꠦ ꠔꠥꠝꠣꠞꠦ ꠇꠤꠔꠣ ꠇꠞꠍꠤꠟ, ꠔꠥꠝꠤ ꠇꠦꠘꠦ ꠔꠣꠞꠣꠞꠦꠖꠤ ꠡꠤꠞꠤꠇꠤ ꠇꠣꠝ ꠇꠞꠣꠁꠟꠣꠄ?” ");
INSERT INTO syls_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","ꠢꠣꠞꠥꠘꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠝꠣꠟꠤꠇ, ꠀꠙꠘꠦ ꠉꠥꠍꠣ ꠇꠞꠂꠘ ꠘꠣ ꠎꠣꠘꠥ, ꠀꠙꠘꠦ ꠔ ꠎꠣꠘꠂꠘꠃ, ꠁꠔꠣ ꠝꠣꠘꠥꠡ ꠈꠣꠟꠤ ꠈꠣꠞꠣꠙ ꠇꠣꠝꠞ ꠀꠡꠤꠇ। ");
INSERT INTO syls_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","ꠔꠣꠞꠣ ꠀꠁꠀ ꠀꠝꠣꠞꠦ ꠇꠁꠟꠣ, ꠀꠝꠞꠣꠞꠦ ꠙꠕ ꠌꠤꠘꠣꠁꠀ ꠟꠁꠀ ꠎꠣꠅꠀꠞ ꠟꠣꠉꠤ ꠖꠦꠛꠔꠣ ꠛꠣꠘꠣꠁ ꠖꠦꠃꠇ꠆ꠇꠣ, ꠇꠣꠞꠘ ꠎꠦ ꠝꠥꠍꠣꠄ ꠀꠝꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠍꠂꠘ, ꠄꠘ ꠇꠤꠔꠣ ꠅꠁꠍꠦ, ꠀꠝꠞꠣ ꠔ ꠎꠣꠘꠤꠀꠞ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠀꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣꠝ, ꠔꠥꠝꠞꠣꠞ ꠉꠦꠍꠦ ꠎꠦꠔꠣ ꠡꠥꠘꠣ-ꠖꠣꠘꠣ ꠀꠍꠦ, ꠅꠔꠣ ꠈꠥꠟꠤꠀ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠀꠘꠅ। ꠔꠣꠞꠣ ꠀꠘꠤꠀ ꠀꠝꠣꠞ ꠀꠔꠅ ꠖꠤꠟꠣ, ꠀꠞ ꠀꠝꠤ ꠅꠈꠘꠣꠁꠘ ꠁꠐꠣ ꠝꠣꠞꠤ ꠀꠉꠥꠘꠤꠔ ꠚꠣꠟꠣꠁꠟꠣꠝ, ꠔꠦꠃ ꠅꠃ ꠛꠣꠍꠥꠞ ꠅꠉꠥ ꠛꠣꠞ ꠅꠁꠀ ꠀꠁꠟ।” ");
INSERT INTO syls_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","ꠝꠥꠍꠣꠄ ꠖꠦꠈꠟꠣ, ꠁ ꠝꠣꠘꠥꠡ ꠉꠥꠁꠘ ꠛꠦꠙꠞꠥꠀ ꠅꠁꠉꠦꠍꠂꠘ। ꠔꠣꠁꠘ ꠛꠥꠎꠟꠣ, ꠢꠣꠞꠥꠘꠦ ꠔꠣꠞꠣꠞꠦ ꠛꠦꠙꠞꠥꠀ ꠅꠀꠞ ꠡꠥꠎꠥꠉ ꠖꠤꠍꠂꠘ। ꠄꠞꠟꠣꠉꠤ ꠖꠥꠡꠝꠘ ꠅꠇꠟꠦ ꠀꠡꠤꠛꠣꠞ ꠡꠥꠎꠥꠉ ꠙꠣꠁꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ꠅꠃ ꠝꠥꠍꠣꠄ ꠇꠦꠝ꠆ꠙꠞ ꠉꠦꠁꠐꠞ ꠉꠦꠍꠦ ꠃꠛꠣꠁꠀ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠎꠔ ꠎꠘ ꠝꠣꠛꠥꠖꠞ ꠙꠇ꠆ꠇꠦ ꠀꠍ, ꠢꠇꠟ ꠀꠝꠣꠞ ꠇꠣꠍꠣꠔ ꠀꠅ।” ꠔꠦꠃ ꠟꠦꠛꠤ ꠉꠥꠡ꠆ꠐꠤꠞ ꠢꠇꠟ ꠝꠣꠘꠥꠡ ꠔꠣꠘ ꠉꠦꠍꠦ ꠀꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","ꠀꠁꠀ ꠢꠣꠞꠟꠦ ꠝꠥꠍꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖ, ꠎꠦꠁꠘ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠀꠟ꠆ꠟꠣ, ꠔꠣꠁꠘ ꠘꠤꠎꠦ ꠢꠥꠇꠥꠝ ꠇꠞꠍꠂꠘ, ꠔꠥꠝꠞꠣ ꠢꠇꠟꠦ ꠎꠣꠞꠎꠤꠞ ꠇꠝꠞꠅ ꠔꠟꠥꠀꠞ ꠛꠣꠘ꠆ꠖꠅ, ꠀꠞ ꠇꠦꠝ꠆ꠙꠞ ꠜꠤꠔꠞꠦ ꠎꠣꠞꠦ ꠍꠣꠝꠘꠦ ꠙꠣꠅ ꠎꠣꠘꠦ ꠝꠣꠞꠅ। ꠀꠡ꠆ꠔꠣ ꠇꠦꠝ꠆ꠙꠞ ꠜꠤꠔꠞꠦ ꠜꠣꠁ-ꠛꠘ꠆ꠖꠥ, ꠀꠞꠤ-ꠚꠞꠤ ꠎꠣꠞꠦ ꠙꠣꠅ ꠝꠣꠞꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","ꠔꠦꠃ ꠟꠦꠛꠤ ꠉꠥꠡ꠆ꠐꠤꠞ ꠝꠣꠘꠡꠦ ꠝꠥꠍꠣꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠇꠣꠝ ꠇꠞꠟꠣ। ꠢꠤ ꠖꠤꠘ ꠅꠘꠥꠝꠣꠘ ꠔꠤꠘ ꠀꠎꠣꠞ ꠝꠣꠘꠥꠡ ꠝꠣꠞꠣ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","ꠛꠣꠖꠦ ꠝꠥꠍꠣꠄ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠀꠁꠎ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠎꠣꠞꠎꠤꠞ ꠙꠥꠀ ꠀꠞ ꠜꠣꠁ-ꠛꠤꠞꠣꠖꠞꠞ ꠃꠙꠞꠦ ꠀꠔ ꠔꠥꠟꠔꠦ ꠈꠞꠦꠖꠤ ꠉꠦꠍ ꠘꠣ, ꠝꠣꠛꠥꠖꠞ ꠇꠣꠝꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠞꠣ ꠀꠟꠣꠖꠣ ꠅꠁꠍ, ꠄꠞꠟꠣꠉꠤ ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠞꠢꠝꠔ ꠖꠤꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","ꠛꠣꠖꠞ ꠖꠤꠘ ꠝꠥꠍꠣꠄ ꠝꠣꠘꠡꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠔ ꠛꠦꠎꠥꠁꠔꠣ ꠉꠥꠘꠣ ꠇꠞꠍ। ꠔꠦ ꠀꠝꠤ ꠅꠈꠘ ꠢꠤꠞꠛꠣꠞ ꠔꠥꠞ ꠙꠣꠠꠅ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠎꠣꠁꠞꠣꠝ, ꠙꠣꠞꠟꠦ ꠔꠥꠝꠞꠣꠞ ꠉꠥꠘꠣ ꠝꠣꠚꠤꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠘꠥ ꠙꠕ ꠛꠣꠞ ꠇꠞꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","ꠝꠥꠍꠣꠄ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠉꠤꠀ ꠀꠞꠎ ꠇꠞꠟꠣ, “ꠅ ꠝꠣꠛꠥꠖ, ꠁ ꠝꠣꠘꠥꠡ ꠉꠥꠁꠘ꠆ꠔꠦ ꠛꠦꠎꠥꠁꠔꠣ ꠉꠥꠘꠣ ꠇꠞꠤꠟꠤꠍꠦ। ꠔꠣꠞꠣ ꠘꠤꠎꠞ ꠟꠣꠉꠤ ꠡꠥꠘꠣꠞ ꠝꠥꠞ꠆ꠔꠤ ꠛꠣꠘꠣꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ꠔꠦ ꠔꠥꠝꠤ ꠝꠦꠢꠦꠞꠛꠣꠘꠤ ꠇꠞꠤꠀ ꠔꠣꠞꠣꠞ ꠉꠥꠘꠣꠞꠦ ꠅꠈꠘ ꠝꠣꠚ ꠇꠞꠤ ꠖꠤꠟꠣꠅ, ꠀꠞ ꠎꠥꠖꠤ ꠝꠣꠚ ꠘꠣ ꠇꠞꠅ, ꠔꠣꠁꠟꠦ ꠔꠥꠝꠣꠞ ꠟꠦꠈꠣ ꠈꠣꠔꠣ ꠕꠣꠇꠤ ꠀꠝꠣꠞ ꠘꠣꠝꠈꠣꠘꠅ ꠇꠣꠐꠤꠟꠣꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","ꠝꠣꠛꠥꠖꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠢꠥꠘꠅ, ꠀꠝꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠎꠦꠞꠣ ꠉꠥꠘꠣ ꠇꠞꠍꠦ, ꠀꠝꠤ ꠈꠣꠟꠤ ꠔꠣꠞꠣꠞ ꠘꠣꠝꠞꠦꠃ ꠀꠝꠣꠞ ꠈꠣꠔꠣ ꠕꠣꠇꠤ ꠚꠥꠍꠤꠟꠤꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","ꠔꠦ ꠔꠥꠝꠤ ꠅꠈꠘ ꠎꠣꠅꠉꠤ, ꠀꠞ ꠀꠝꠤ ꠎꠦ ꠖꠦꠡꠞ ꠇꠕꠣ ꠇꠁꠍꠤ, ꠔꠥꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠟꠁꠀ ꠢꠃ ꠖꠦꠡꠅ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣꠅ। ꠀꠝꠣꠞ ꠚꠤꠞꠤꠡ꠆ꠔꠣꠄ ꠔꠥꠝꠞꠣꠞꠦ ꠙꠕ ꠖꠦꠈꠣꠁꠀ ꠘꠤꠛꠣ। ꠛꠣꠖꠦ ꠎꠦꠛꠟꠣ ꠡꠣꠎꠣ ꠖꠦꠅꠀꠞ ꠡꠝꠄ ꠀꠁꠛ, ꠅꠃ ꠡꠝꠄ ꠀꠝꠤ ꠔꠣꠞꠣꠞ ꠉꠥꠘꠣꠞ ꠡꠣꠎꠣ ꠖꠤꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","ꠢꠣꠞꠥꠘꠞ ꠀꠔꠦ ꠛꠣꠘꠣꠁꠟ ꠢꠃ ꠛꠣꠍꠥꠞꠞ ꠝꠥꠞ꠆ꠔꠤꠞ ꠟꠣꠉꠤ ꠝꠣꠘꠡꠦ ꠎꠦꠔꠣ ꠇꠞꠍꠤꠟꠣ, ꠅꠔꠣꠞ ꠟꠣꠉꠤ ꠝꠣꠛꠥꠖꠦ ꠔꠣꠞꠣꠞ ꠃꠙꠞꠦ ꠉꠎꠛ ꠘꠣꠎꠤꠟ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠎꠣꠅ, ꠔꠥꠝꠤ ꠅꠃ ꠎꠦꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠀꠘꠍ, ꠄꠞꠣꠞꠦ ꠟꠁꠀ ꠅꠈꠘꠃ ꠁ ꠎꠣꠉꠣ ꠍꠣꠠꠤꠀ ꠎꠣꠅꠉꠤ। ꠀꠝꠣꠞ ꠅꠀꠖꠣ ꠇꠞꠣ ꠢꠃ ꠖꠦꠡꠅ ꠎꠣꠅ। ꠀꠝꠤ ꠁꠛ꠆ꠞꠣꠢꠤꠝ, ꠁꠍꠢꠣꠇ ꠀꠞ ꠁꠀꠇꠥꠛꠞ ꠉꠦꠍꠦ ꠅꠀꠖꠣ ꠇꠞꠍꠟꠣꠝ, ꠔꠣꠞꠣꠞ ꠅꠀꠞꠤꠡ ꠅꠇꠟꠞꠦ ꠅꠃ ꠖꠦꠡ ꠅꠇꠟ ꠖꠤꠝꠥ, ꠔꠦ ꠔꠥꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠟꠁꠀ ꠢꠘꠅ ꠎꠣꠅꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠀꠉꠦ ꠇꠞꠤ ꠄꠇꠎꠘ ꠚꠤꠞꠤꠡ꠆ꠔꠣ ꠙꠣꠑꠣꠁꠝꠥ। ꠄꠁꠘ ꠉꠤꠀ ꠢꠘꠞ ꠇꠦꠘꠣꠘꠤ, ꠀꠝꠥꠞꠤ, ꠢꠤꠐ꠆ꠐꠤ, ꠚꠣꠞꠤꠎꠤ, ꠢꠤꠛ꠆ꠛꠤ ꠀꠞ ꠎꠤꠛꠥꠎꠤ ꠅꠇꠟꠞꠦ ꠈꠦꠖꠣꠁ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","ꠁꠔꠣ ꠔ ꠖꠥꠗ ꠀꠞ ꠝꠃꠞ ꠜꠣꠘ꠆ꠒꠣꠞ ꠀꠟꠣ ꠖꠦꠡ। ꠅꠁꠟꠦ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠅꠁꠀ ꠎꠣꠁꠔꠣꠝ ꠘꠣꠄ, ꠇꠣꠞꠘ ꠔꠥꠝꠞꠣ ꠈꠥꠛ ꠉꠣꠠꠔꠦꠠꠣ-ꠄꠇꠉꠥꠁꠀ ꠎꠣꠔ, ꠇꠤꠎꠣꠘꠥ ꠀꠝꠤ ꠙꠕꠞ ꠝꠣꠎꠦꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠘꠤꠙꠣꠔ ꠇꠞꠤꠟꠣꠁ।” ");
INSERT INTO syls_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","ꠁ ꠛꠤꠙꠖꠞ ꠇꠕꠣ ꠢꠥꠘꠤꠀ ꠝꠣꠘꠡꠦ ꠇꠣꠘ꠆ꠖꠣ-ꠇꠣꠐꠤ ꠟꠣꠉꠣꠁꠟꠣ। ꠔꠣꠞꠣ ꠇꠦꠃ ꠇꠥꠘꠥꠎꠣꠔ ꠉꠄꠘꠣ-ꠉꠣꠐꠤ ꠚꠤꠘꠟꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","ꠇꠣꠞꠘ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠍꠟꠣ, “ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠅꠇꠟꠞꠦ ꠇꠅ, ꠔꠥꠝꠞꠣ ꠅꠁꠟꠣꠄ ꠉꠣꠠꠔꠦꠠꠣ-ꠄꠇꠉꠥꠁꠀ ꠎꠣꠔ। ꠀꠝꠤ ꠄꠇ ꠙꠟꠇꠞ ꠟꠣꠉꠤ ꠉꠦꠟꠦꠅ ꠔꠥꠝꠞꠣꠞꠦ ꠘꠤꠙꠣꠔ ꠇꠞꠤꠟꠤꠝꠥ। ꠔꠥꠝꠞꠣꠞ ꠉꠔꠞꠅ ꠕꠣꠇꠤ ꠢꠇꠟ ꠉꠄꠘꠣ-ꠉꠣꠐꠤ ꠈꠥꠟꠤꠟꠣꠅ, ꠔꠦꠃ ꠀꠝꠤ ꠛꠥꠎꠝꠥ, ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠇꠤꠔꠣ ꠇꠞꠔꠣꠝ।” ");
INSERT INTO syls_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","ꠔꠦꠃ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠔꠥꠞ ꠙꠣꠠꠅꠃ ꠔꠣꠞꠣꠞ ꠉꠄꠘꠣ-ꠉꠣꠐꠤ ꠢꠇꠟꠔꠣ ꠈꠥꠟꠤꠟꠤꠟꠣ, ꠁꠔꠣ ꠀꠞ ꠚꠤꠘꠟꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","ꠢꠎꠞꠔ ꠝꠥꠍꠣꠞ ꠄꠇ ꠔꠣꠝ꠆ꠛꠥ ꠀꠍꠤꠟ, ꠔꠣꠁꠘ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠇꠦꠝ꠆ꠙꠞ ꠛꠣꠞꠦ ꠖꠥꠞꠁ ꠘꠤꠀ ꠅꠃ ꠔꠣꠝ꠆ꠛꠥ ꠙꠣꠔꠤꠔꠣ, ꠁ ꠔꠣꠝ꠆ꠛꠥꠞꠦ ꠔꠣꠁꠘ ꠈꠣꠘꠦꠇꠣ-ꠔꠣꠝ꠆ꠛꠥ ꠇꠁꠀ ꠒꠣꠇꠤꠔꠣ। ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠇꠦꠃ ꠇꠥꠘ꠆ꠔꠣ ꠎꠣꠘꠔꠦ ꠌꠣꠁꠟꠦ ꠔꠣꠞꠣ ꠅꠃ ꠈꠣꠘꠦꠇꠣꠞ ꠉꠦꠍꠦ ꠎꠣꠁꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","ꠝꠥꠍꠣ ꠎꠦꠛꠟꠣ ꠢꠤ ꠈꠣꠘꠦꠇꠣ ꠡꠞꠤꠚꠅ ꠞꠅꠀꠘꠣ ꠖꠤꠔꠣ, ꠅꠃ ꠡꠝꠄ ꠢꠇ꠆ꠇꠟ ꠝꠣꠘꠥꠡ ꠎꠣꠞꠎꠤꠞ ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠅ ꠃꠛꠣꠁꠔꠣ ꠀꠞ ꠝꠥꠍꠣ ꠈꠣꠘꠦꠇꠣꠔ ꠘꠣ ꠢꠣꠝꠣꠘꠤ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠇꠟꠦ ꠔꠣꠘ ꠛꠣꠄ ꠌꠣꠁ ꠞꠁꠔ। ");
INSERT INTO syls_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","ꠔꠣꠁꠘ ꠢꠤ ꠈꠣꠘꠦꠇꠣ ꠡꠞꠤꠚꠅ ꠢꠣꠝꠣꠘꠤꠞ ꠛꠣꠖꠦꠃ ꠀꠟ꠆ꠟꠣꠁ ꠝꠦꠊꠞ ꠈꠥꠐꠤ ꠈꠣꠘꠦꠇꠣꠞ ꠖꠥꠀꠞꠞ ꠝꠥꠈꠅ ꠟꠣꠝꠤꠀ ꠀꠁꠔ, ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠎꠔꠛꠁꠟ ꠝꠥꠍꠣꠞ ꠟꠉꠦ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠔꠣ, ꠅꠔꠛꠁꠟ ꠁ ꠈꠥꠐꠤ ꠅꠘꠅ ꠞꠁꠔ। ");
INSERT INTO syls_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","ꠝꠣꠘꠡꠦ ꠎꠦꠛꠟꠣꠃ ꠁ ꠝꠦꠊꠞ ꠈꠥꠐꠤꠞꠦ ꠈꠣꠘꠦꠇꠣꠞ ꠖꠥꠀꠞꠞ ꠉꠦꠍꠦ ꠖꠦꠈꠔ, ꠅꠃ ꠡꠝꠄ ꠔꠣꠞꠣ ꠎꠣꠞꠎꠤꠞ ꠖꠥꠀꠞꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠝꠣꠛꠥꠖꠞꠦ ꠍꠁꠎꠖꠣ ꠇꠞꠔ। ");
INSERT INTO syls_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠔꠣꠞ ꠖꠥꠡ꠆ꠔꠞ ꠟꠉꠦ ꠝꠥꠈꠣꠝꠥꠈꠤ ꠛꠁꠀ ꠎꠦꠟꠣ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠦ, ꠝꠣꠛꠥꠖꠦꠅ ꠝꠥꠍꠣꠞ ꠟꠉꠦ ꠅꠃꠟꠣ ꠝꠥꠈꠣꠝꠥꠈꠤ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠔꠣ। ꠛꠣꠖꠦ ꠝꠥꠍꠣ ꠇꠦꠝ꠆ꠙꠅ ꠚꠤꠞꠤꠀ ꠀꠁꠔꠣ, ꠅꠁꠟꠦ ꠔꠣꠘ ꠈꠣꠖꠤꠝ ꠘꠥꠘꠞ ꠙꠥꠀ ꠁꠃꠍꠣ ꠘꠣꠝꠞ ꠁ ꠎꠥꠀꠘ, ꠈꠣꠘꠦꠇꠣ ꠡꠞꠤꠚ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁꠔꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","ꠝꠥꠍꠣꠄ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠀꠞꠎ ꠇꠞꠟꠣ, “ꠝꠣꠛꠥꠖ, ꠔꠥꠝꠤ ꠔ ꠇꠁꠞꠣꠄ ꠀꠝꠤ ꠅꠔꠣ ꠝꠣꠘꠡꠞꠦ ꠟꠁꠀ ꠎꠣꠁꠔꠣꠝꠉꠤ, ꠅꠁꠟꠦ ꠀꠝꠣꠞ ꠟꠉꠦ ꠀꠞ ꠇꠣꠞꠦ ꠖꠤꠞꠣꠄ, ꠁꠈꠣꠘ ꠔ ꠀꠝꠣꠞꠦ ꠎꠣꠘꠣꠁꠟꠣꠄ ꠘꠣ। ꠔꠥꠝꠤ ꠈꠣꠟꠤ ꠇꠁꠟꠣꠄ, ꠔꠥꠝꠤ ꠀꠝꠣꠞꠦ ꠔꠥꠝꠣꠞ ꠘꠤꠎꠞ ꠎꠘ ꠝꠘꠅ ꠇꠞꠅ ꠀꠞ ꠀꠝꠣꠞꠦ ꠔꠥꠝꠣꠞ ꠈꠣꠍ ꠝꠣꠄꠀꠞ ꠘꠎꠞꠅ ꠞꠣꠈꠍ। ");
INSERT INTO syls_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","ꠔꠦ ꠢꠣꠍꠣꠃ ꠎꠥꠖꠤ ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠝꠣꠄꠀꠞ ꠘꠎꠞꠅ ꠕꠣꠇꠤ, ꠔꠣꠁꠟꠦ ꠔꠥꠝꠤ ꠇꠥꠘ ꠈꠤꠀꠟꠦ ꠇꠤꠔꠣ ꠇꠞꠅ, ꠅꠔꠣ ꠀꠝꠣꠞꠦ ꠎꠣꠘꠣꠅ, ꠎꠣꠔꠦ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠙꠥꠞꠣꠙꠥꠞ ꠌꠤꠘꠤ ꠀꠞ ꠔꠥꠝꠣꠞ ꠞꠢꠝꠔꠞ ꠝꠣꠎꠦ ꠞꠁ। ꠔꠥꠝꠤ ꠔ ꠎꠣꠘꠃ, ꠁ ꠁꠍꠞꠣꠁꠟ ꠎꠣꠔꠤ ꠔꠥꠝꠣꠞꠃ ꠙ꠆ꠞꠎꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","ꠝꠣꠛꠥꠖꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠢꠥꠘꠅ, ꠀꠝꠤ ꠘꠤꠎꠦꠃ ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠅꠁꠀ ꠎꠣꠁꠝꠥ ꠀꠞ ꠔꠥꠝꠣꠞꠦ ꠀꠞꠣꠝ ꠖꠤꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","ꠅꠃ ꠔꠣꠁꠘ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠎꠥꠖꠤ ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠘꠣ ꠎꠣꠅ, ꠔꠦ ꠀꠝꠞꠣꠞꠦ ꠁꠘ ꠕꠣꠇꠤ ꠛꠤꠖꠣꠄ ꠖꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","ꠔꠥꠝꠤ ꠘꠣ ꠉꠦꠟꠦ ꠝꠣꠘꠡꠦ ꠇꠤꠟꠣ ꠛꠥꠎꠛꠣ, ꠀꠝꠣꠞ ꠃꠙꠞꠦ ꠀꠞ ꠔꠥꠝꠣꠞ ꠁ ꠛꠘ꠆ꠖꠣ ꠅꠇꠟꠞ ꠃꠙꠞꠦ ꠔꠥꠝꠣꠞ ꠞꠢꠝꠔ ꠀꠍꠦ? ꠀꠝꠞꠣꠃ ꠎꠦꠘ ꠖꠥꠘꠤꠀꠞ ꠢꠇꠟ ꠎꠣꠔꠤ ꠕꠣꠇꠤ ꠀꠟꠣꠖꠣ, ꠁꠈꠣꠘ ꠇꠤꠟꠣ ꠛꠥꠎꠛꠣ?” ");
INSERT INTO syls_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠑꠤꠇ ꠀꠍꠦ, ꠔꠥꠝꠤ ꠎꠦꠟꠣ ꠇꠁꠟꠣꠄ, ꠀꠝꠤ ꠅꠟꠣ ꠇꠞꠝꠥ। ꠔꠥꠝꠤ ꠔ ꠀꠝꠣꠞ ꠝꠣꠄꠀꠞ ꠘꠎꠞꠅ ꠀꠍ, ꠔꠥꠝꠣꠞꠦ ꠀꠝꠣꠞ ꠘꠤꠎꠞ ꠀꠙꠘ ꠝꠘꠅ ꠇꠞꠤ।” ");
INSERT INTO syls_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","ꠔꠦꠃ ꠝꠥꠍꠣꠄ ꠀꠞꠎ ꠇꠞꠟꠣ, “ꠔꠦ ꠔꠥꠝꠣꠞ ꠡꠣꠘ-ꠔꠎꠟ꠆ꠟꠤ ꠀꠝꠣꠞꠦ ꠖꠦꠈꠣꠅꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","ꠝꠣꠛꠥꠖꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠎꠣꠞꠦ ꠈꠥꠡꠤ ꠖꠄꠀ ꠇꠞꠝꠥ, ꠀꠞ ꠎꠣꠞꠦ ꠈꠥꠡꠤ ꠞꠢꠝ ꠇꠞꠝꠥ। ꠢꠥꠘꠅ, ꠔꠥꠝꠣꠞ ꠍꠣꠝꠘꠦꠖꠤ ꠀꠝꠤ ꠀꠝꠣꠞ ꠢꠇ꠆ꠇꠟ ꠘꠦꠇ ꠍꠥꠞꠔ ꠎꠣꠁꠞ ꠇꠞꠝꠥ। ‘ꠝꠣꠛꠥꠖ, ꠎꠦꠁꠘ ꠀꠍꠂꠘ’ ꠔꠥꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠀꠝꠤ ꠀꠝꠣꠞ ꠅꠃ ꠘꠣꠝ ꠄꠟꠣꠘ ꠇꠞꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","ꠅꠁꠟꠦ ꠀꠝꠣꠞ ꠝꠥꠈ ꠖꠦꠈꠣꠞ ꠔꠣꠇ꠆ꠇꠔ ꠔꠥꠝꠣꠞ ꠅꠁꠔ ꠘꠣꠄ। ꠇꠣꠞꠘ ꠀꠝꠣꠞꠦ ꠖꠦꠈꠤꠟ꠆ꠟꠦ ꠇꠥꠘꠥ ꠀꠖꠝ ꠎꠣꠔ ꠛꠣꠌꠦ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","ꠔꠦ ꠢꠥꠘꠅ, ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠇꠣꠍꠣꠞ ꠅꠃ ꠎꠣꠉꠣ ꠛꠣꠄ ꠌꠣꠅ, ꠖꠦꠈꠞꠣꠄ ꠘꠤ, ꠙꠣꠔ꠆ꠔꠞꠞ ꠄꠇ ꠕꠣꠇ ꠀꠍꠦ, ꠅꠃ ꠕꠣꠇꠞ ꠃꠙꠞꠦ ꠔꠥꠝꠤ ꠃꠛꠣꠅ। ");
INSERT INTO syls_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","ꠔꠦꠃ ꠔꠥꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠖꠤꠀ ꠀꠝꠣꠞ ꠡꠣꠘ-ꠔꠎꠟ꠆ꠟꠤ ꠎꠣꠅꠀꠞ ꠛꠣꠟꠣ, ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠅꠃ ꠙꠣꠔ꠆ꠔꠞꠞ ꠚꠣꠐꠣꠞ ꠜꠤꠔꠞꠦ ꠢꠣꠞꠣꠁꠝꠥ। ꠀꠝꠤ ꠘꠣ ꠎꠣꠅꠀ ꠙꠞ꠆ꠎꠘ꠆ꠔ, ꠀꠝꠣꠞ ꠀꠔ ꠖꠤꠀ ꠔꠥꠝꠣꠞꠦ ꠉꠥꠞꠤꠀ ꠞꠣꠈꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","ꠛꠣꠖꠦ ꠀꠝꠣꠞ ꠀꠔ ꠢꠞꠣꠁꠟꠦ, ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠈꠞ ꠉꠣꠟꠣ ꠖꠦꠈꠔꠣꠄ ꠙꠣꠞꠛꠣꠄ, ꠅꠁꠟꠦ ꠇꠦꠃ ꠀꠝꠣꠞ ꠝꠥꠈꠞ ꠖꠤꠖꠣꠞ ꠙꠣꠁꠔ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠀꠉꠞ ꠙꠣꠔ꠆ꠔꠞꠞ ꠟꠣꠈꠣꠘ ꠔꠥꠝꠤ ꠘꠄꠀ ꠖꠥꠈꠣꠘ ꠙꠣꠔ꠆ꠔꠞ ꠔꠤꠀꠞ ꠇꠞꠅ। ꠔꠥꠝꠤ ꠎꠦ ꠖꠥꠈꠣꠘ ꠜꠣꠋꠉꠤꠍꠟꠣꠄ, ꠢꠤ ꠙꠣꠔ꠆ꠔꠞꠞ ꠝꠣꠎꠦ ꠎꠦ ꠢꠥꠇꠥꠝ ꠟꠦꠈꠣ ꠀꠍꠤꠟ, ꠅꠃ ꠢꠥꠇꠥꠝ ꠅꠇꠟ ꠀꠝꠤ ꠢꠤꠞꠛꠣꠞ ꠁ ꠖꠥꠁꠅ ꠙꠣꠔ꠆ꠔꠞꠅ ꠟꠦꠈꠤꠀ ꠖꠤꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","ꠚꠎꠞ ꠛꠣꠖꠦꠃ ꠔꠥꠝꠤ ꠔꠤꠀꠞ ꠅꠁꠀ ꠔꠥꠞ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠃꠑꠤꠅ। ꠃꠑꠤꠀ ꠙꠣꠠꠞ ꠝꠣꠕꠣꠔ ꠀꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠀꠎꠤꠞ ꠅꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠞꠦ ꠀꠘꠤꠅ ꠘꠣ, ꠁ ꠙꠣꠠꠞ ꠇꠥꠘꠥꠈꠣꠘꠅ ꠎꠣꠔꠦ ꠇꠥꠘꠥ ꠝꠣꠘꠥꠡ ꠘꠣ ꠀꠄ। ꠙꠣꠠꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠇꠥꠘꠥ ꠉꠞꠥ-ꠍꠣꠉꠟ ꠛꠣ ꠝꠦꠠꠣ-ꠝꠦꠠꠤꠞꠦ ꠞꠣꠈꠔꠦ ꠖꠤꠅ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","ꠔꠦꠃ ꠝꠥꠍꠣꠄ ꠀꠉꠞ ꠙꠣꠔ꠆ꠔꠞꠞ ꠟꠣꠈꠣꠘ ꠖꠥꠈꠣꠘ ꠙꠣꠔ꠆ꠔꠞ ꠛꠣꠘꠣꠁꠟꠣ, ꠀꠞ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠚꠎꠞꠦ ꠃꠑꠤꠀ ꠙꠣꠔ꠆ꠔꠞ ꠖꠥꠁꠅꠈꠣꠘ ꠀꠔꠅ ꠟꠁꠀ ꠔꠥꠞ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠃꠑꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","ꠀꠞ ꠝꠣꠛꠥꠖꠅ ꠝꠦꠊꠞ ꠇꠣꠟꠘꠤꠞ ꠝꠣꠎꠦ ꠟꠣꠝꠤꠀ ꠀꠁꠟꠣ। ꠔꠣꠁꠘ ꠢꠎꠞꠔ ꠝꠥꠍꠣꠞ ꠗꠣꠞꠅ ꠃꠛꠣꠁꠀ ꠔꠣꠘ “ꠝꠣꠛꠥꠖ, ꠎꠦꠁꠘ ꠀꠍꠂꠘ” ꠘꠣꠝ ꠄꠟꠣꠘ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","ꠔꠣꠁꠘ ꠝꠥꠍꠣꠞ ꠍꠣꠝꠘꠣ ꠖꠤꠀ ꠔꠡꠞꠤꠚ ꠘꠤꠟꠣ, ꠀꠞ ꠅꠃ ꠇꠣꠟꠣꠝ ꠄꠟꠣꠘ ꠇꠞꠤ ꠇꠞꠤ ꠉꠦꠟꠣ, “ꠝꠣꠛꠥꠖ, ꠎꠦꠁꠘ ꠀꠍꠂꠘ, ꠞꠢꠝꠣꠘ ꠀꠞ ꠞꠢꠤꠝ ꠀꠟ꠆ꠟꠣ, ꠔꠣꠁꠘ ꠉꠥꠍꠣ ꠇꠞꠂꠘ ꠗꠤꠞ ꠉꠔꠤꠄ, ꠔꠣꠘ ꠅꠛꠤꠞꠣꠝ ꠝꠣꠄꠀ-ꠝꠢꠛ꠆ꠛꠔ ꠀꠞ ꠢꠇ-ꠢꠣꠟꠣꠟꠤꠞ ꠇꠥꠘꠥ ꠡꠤꠝꠣ ꠘꠣꠁ। ");
INSERT INTO syls_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ꠔꠣꠁꠘ ꠀꠎꠣꠞ ꠀꠎꠣꠞ ꠅꠀꠞꠤꠡ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠅꠛꠤꠞꠣꠝ ꠝꠣꠄꠀ-ꠝꠢꠛ꠆ꠛꠔ ꠇꠞꠂꠘ, ꠝꠣꠘꠡꠞ ꠅꠁꠘ꠆ꠘꠣꠄ-ꠅꠙꠞꠣꠗ, ꠘꠣꠚꠞꠝꠣꠘꠤ ꠀꠞ ꠉꠥꠘꠣꠞ ꠝꠣꠚꠤ ꠖꠦꠁꠘ, ꠅꠁꠟꠦ ꠖꠥꠡꠤ ꠎꠘꠞꠦ ꠡꠣꠎꠣꠅ ꠖꠦꠁꠘ। ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠘꠣꠚꠞꠝꠣꠘꠤꠞ ꠡꠣꠎꠣ, ꠔꠣꠞꠣꠞ ꠘꠣꠔꠤ-ꠙꠥꠔꠤ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠛꠞ꠆ꠔꠣꠁꠘ।” ");
INSERT INTO syls_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀꠃ ꠝꠥꠍꠣ ꠘꠛꠤ ꠟꠉꠦ ꠟꠉꠦ ꠍꠁꠎꠖꠣꠔ ꠙꠠꠤꠀ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“ꠅ ꠝꠣꠟꠤꠇ, ꠀꠝꠤ ꠎꠥꠖꠤ ꠔꠥꠝꠣꠞ ꠖꠞꠛꠣꠞꠅ ꠞꠢꠝꠔ ꠙꠣꠁ, ꠔꠦ ꠝꠦꠢꠦꠞꠛꠣꠘꠤ ꠇꠞꠤ ꠔꠥꠝꠤꠅ ꠀꠝꠞꠣꠞ ꠟꠉ ꠈꠣꠘꠅ ꠌꠟꠅ। ꠅꠃ ꠎꠣꠔꠤ ꠎꠥꠖꠤꠅ ꠈꠥꠛ ꠉꠣꠠꠔꠦꠠꠣ-ꠄꠇꠉꠥꠁꠀ ꠎꠣꠔ, ꠔꠣ-ꠅ ꠔꠥꠝꠤ ꠀꠝꠞꠣꠞ ꠉꠥꠘꠣ ꠀꠞ ꠇꠍꠥꠞꠤꠞꠦ ꠝꠣꠚ ꠇꠞꠤꠀ ꠖꠤꠟꠣꠅ। ꠀꠝꠞꠣꠞꠦ ꠔꠥꠝꠣꠞ ꠀꠙꠘ ꠙ꠆ꠞꠎꠣ ꠢꠤꠡꠣꠛꠦ ꠇꠛꠥꠟ ꠇꠞꠤꠟꠣꠅ।” ");
INSERT INTO syls_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","ꠝꠣꠛꠥꠖꠦ ꠇꠁꠟꠣ, “ꠢꠥꠘꠅ, ꠀꠝꠤ ꠄꠇ ꠃꠍꠤꠟ꠆ꠟꠣ ꠛꠅꠀꠁꠟ ꠇꠞꠤꠀꠞ, ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠢꠇꠟ ꠝꠣꠘꠡꠞ ꠍꠣꠝꠘꠦ ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠦꠞꠣꠝꠔꠤ ꠇꠣꠝ ꠖꠦꠈꠣꠁꠝꠥ, ꠎꠦꠔꠣ ꠀꠡ꠆ꠔꠣ ꠖꠥꠘꠤꠀꠞ ꠇꠥꠘꠥ ꠎꠣꠔꠤꠞ ꠍꠣꠝꠘꠦ ꠇꠥꠘꠥꠖꠤꠘꠅ ꠇꠞꠣ ꠅꠁꠍꠦ ꠘꠣ। ꠔꠥꠝꠤ ꠅꠃ ꠎꠦꠔꠣ ꠝꠣꠘꠡꠞ ꠟꠉꠦ ꠛꠡꠔ ꠇꠞꠞꠣꠄ, ꠔꠣꠞꠣ ꠖꠦꠈꠛꠣ, ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠇꠤꠔꠣ ꠇꠞꠤꠀꠞ, ꠁꠔꠣ ꠖꠦꠈꠤꠀ ꠔꠣꠞꠣꠞ ꠎꠣꠘꠅ ꠒꠞ ꠢꠣꠝꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","ꠀꠝꠤ ꠀꠁꠎ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦꠔꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠝꠥ, ꠁꠔꠣ ꠈꠤꠀꠟ ꠇꠞꠤ ꠀꠝꠟ ꠇꠞꠅ। ꠀꠝꠤ ꠀꠝꠥꠞꠤ, ꠇꠦꠘꠣꠘꠤ, ꠢꠤꠐ꠆ꠐꠤ, ꠚꠣꠞꠤꠎꠤ, ꠢꠤꠛ꠆ꠛꠤ ꠀꠞ ꠎꠤꠛꠥꠎꠤ ꠅꠇꠟꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠍꠣꠝꠘꠣ ꠕꠣꠇꠤ ꠈꠦꠖꠣꠁ ꠖꠤꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","ꠅꠁꠟꠦ ꠈꠛꠞꠖꠣꠞ! ꠔꠥꠝꠞꠣ ꠎꠦ ꠖꠦꠡꠅ ꠎꠣꠁꠞꠣꠄ, ꠁ ꠖꠦꠡꠞ ꠝꠣꠘꠡꠞ ꠟꠉꠦ ꠇꠥꠘꠥꠎꠣꠔ ꠌꠥꠇ꠆ꠔꠤ ꠇꠞꠤꠅ ꠘꠣ, ꠀꠞꠘꠣꠄ ꠚꠣꠘ꠆ꠖꠅ ꠢꠣꠝꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","ꠔꠥꠝꠞꠣ ꠔꠣꠞꠣꠞ ꠙꠥꠎꠣ-ꠝꠘ꠆ꠒꠙ ꠜꠣꠋꠉꠤꠀ ꠐꠥꠇꠞꠣ ꠐꠥꠇꠞꠣ ꠇꠞꠛꠣꠄ, ꠔꠣꠞꠣꠞ ꠛꠟꠤ ꠈꠣꠘꠣꠁꠘ ꠜꠣꠋꠉꠤꠟꠤꠛꠣꠄ, ꠀꠞ ꠔꠣꠞꠣꠞ ꠀꠡꠦꠞꠣ-ꠖꠦꠛꠤꠞ ꠘꠤꠡꠣꠘꠣ ꠈꠥꠐꠤ ꠅꠇꠟ ꠇꠣꠐꠤꠀ ꠚꠣꠟꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","ꠔꠥꠝꠞꠣ ꠇꠥꠘꠥ ꠖꠦꠛ-ꠖꠦꠛꠤꠞ ꠙꠥꠎꠣ ꠇꠞꠤꠅ ꠘꠣ। ꠀꠝꠤ ꠀꠟ꠆ꠟꠣ ꠔ ꠟꠣ-ꠡꠞꠤꠇ ꠝꠣꠛꠥꠖ, ꠇꠥꠘꠥ ꠡꠞꠤꠇ ꠡꠁꠎ꠆ꠎ ꠇꠞꠤ ꠘꠣ, ꠀꠝꠣꠞ ꠙꠣꠅꠘꠣ ꠄꠛꠣꠖꠔ ꠀꠝꠤ ꠌꠣꠁꠃ ꠌꠣꠁ। ");
INSERT INTO syls_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“ꠢꠃ ꠖꠦꠡꠞ ꠝꠣꠘꠡꠞ ꠟꠉꠦ ꠇꠥꠘꠥꠎꠣꠔ ꠌꠥꠇ꠆ꠔꠤ ꠇꠞꠤꠅ ꠘꠣ, ꠀꠞꠘꠣꠄ ꠔꠣꠞꠣ ꠎꠦꠛꠟꠣ ꠡꠤꠞꠤꠇꠤ ꠇꠣꠝꠞ ꠘꠤꠅꠔꠦ, ꠔꠣꠞꠣꠞ ꠖꠦꠛ-ꠖꠦꠛꠤꠞ ꠍꠣꠝꠘꠦ ꠘꠤꠎꠞꠦ ꠡꠙꠤꠀ ꠖꠤꠛꠣ, ꠖꠦꠛꠔꠣꠞ ꠘꠣꠝꠦ ꠛꠟꠤ ꠖꠤꠛꠣ, ꠅꠃ ꠡꠝꠄ ꠔꠣꠞꠣ ꠔꠥꠝꠞꠣꠞꠦꠅ ꠖꠣꠅꠔ ꠖꠤꠛꠣ ꠀꠞ ꠔꠥꠝꠞꠣ ꠉꠤꠀ ꠔꠣꠞꠣꠞ ꠅꠃ ꠛꠟꠤꠞ ꠉꠥꠡ꠆ꠔ ꠈꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","ꠔꠥꠝꠞꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠟꠉꠦ ꠔꠣꠞꠣꠞ ꠙꠥꠠꠤꠘ꠆ꠔꠞ ꠛꠤꠀ-ꠡꠣꠖꠤ ꠖꠤꠛꠣꠄ, ꠀꠞ ꠅꠃ ꠙꠥꠠꠤꠘ꠆ꠔꠦ ꠔꠣꠞꠣꠞ ꠖꠦꠛꠔꠣꠞ ꠉꠦꠍꠦ ꠉꠤꠀ ꠡꠤꠞꠤꠇꠤ ꠇꠣꠝ ꠇꠞꠛꠣ, ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠔꠥꠝꠞꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦꠅ ꠐꠣꠘꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠟꠣꠉꠤ ꠇꠥꠘꠥꠎꠣꠔꠞ ꠝꠥꠞ꠆ꠔꠤ ꠛꠣꠘꠣꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“ꠔꠥꠝꠞꠣ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠞꠥꠐꠤꠞ ꠁꠖ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ꠡꠣꠔ ꠖꠤꠘ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠞꠥꠐꠤ ꠈꠣꠁꠅ। ꠀꠛꠤꠛ ꠌꠣꠘ꠆ꠖꠞ ꠑꠤꠇ ꠇꠞꠣ ꠔꠣꠞꠤꠈꠅ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠦꠅꠀ ꠅꠁꠍꠦ, ꠅꠃ ꠟꠣꠈꠣꠘ ꠁꠖ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠅꠃ ꠌꠣꠘ꠆ꠖꠅ ꠔꠥꠝꠞꠣ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁꠀ ꠀꠁꠍꠟꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“ꠔꠥꠝꠞꠣꠞ ꠙꠦꠐꠞ ꠙꠄꠖꠣ ꠢꠇꠟ ꠙꠄꠟꠣ ꠙꠥꠀ ꠀꠝꠣꠞ ꠅꠁꠛ। ꠄꠞꠟꠉꠦ ꠔꠥꠝꠞꠣꠞ ꠉꠞꠥ-ꠍꠣꠉꠟ ꠛꠣ ꠙꠡꠥꠞ ꠙꠄꠟꠣ ꠝꠦꠖꠣ ꠛꠣꠁꠌ꠆ꠌꠣꠅ ꠀꠝꠣꠞ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","ꠈꠣꠟꠤ ꠉꠣꠗꠤꠘ꠆ꠔꠞ ꠙꠄꠟꠣ ꠝꠦꠖꠣ ꠛꠣꠁꠌ꠆ꠌꠣꠞ ꠛꠖꠟꠣ, ꠀꠝꠣꠞꠦ ꠄꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠛꠖꠟꠣ ꠖꠤꠀ ꠅꠉꠥꠞꠦ ꠈꠣꠟꠣꠍ ꠇꠞꠤꠀ ꠘꠤꠅ। ꠈꠣꠟꠣꠍ ꠘꠣ ꠇꠞꠣꠁꠟꠦ ꠅꠉꠥꠞ ꠉꠞ꠆ꠖꠘꠣ ꠜꠣꠋꠉꠤꠟꠤꠅ। ꠔꠥꠝꠞꠣꠞ ꠢꠇ꠆ꠇꠟ ꠛꠠ ꠙꠥꠀꠂꠘꠞꠦ ꠅꠟꠣ ꠈꠣꠟꠣꠍ ꠇꠞꠣꠁ ꠘꠤꠅ। “ꠢꠥꠘꠅ, ꠁꠖꠞ ꠡꠝꠄ ꠇꠦꠃ ꠈꠣꠟꠤ ꠀꠔꠦ ꠀꠝꠣꠞ ꠇꠣꠍꠣꠔ ꠀꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“ꠢꠣꠙ꠆ꠔꠣꠞ ꠍꠄꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠇꠣꠝ ꠇꠞꠤꠅ, ꠅꠁꠟꠦ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠎꠤꠞꠣꠁꠅ। ꠈꠦꠔ ꠇꠞꠣ ꠀꠞ ꠚꠡꠟ ꠖꠣꠅꠀꠞ ꠛꠣꠟꠣꠅ ꠎꠤꠞꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“ꠅꠃ ꠔꠤꠘꠅ ꠁꠖ ꠔꠥꠝꠞꠣ ꠝꠣꠘꠤꠅ, ꠙꠘ꠆ꠌꠣꠁꠡꠣ ꠁꠖ, ꠈꠦꠔꠞ ꠙꠄꠟꠣ ꠖꠣꠅꠀ ꠉꠝ ꠖꠤꠀ ꠘꠄꠀ ꠚꠡꠟꠞ ꠁꠖ, ꠀꠞ ꠛꠍꠞꠞ ꠢꠦꠡ ꠝꠣꠡꠅ ꠛꠣꠉꠣꠘꠞ ꠙꠣꠇꠘꠣ ꠚꠟ ꠛꠣꠠꠤꠔ ꠀꠘꠤꠀ ꠒꠦꠞꠣ-ꠊꠞꠞ ꠁꠖ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","ꠛꠍꠞꠅ ꠔꠤꠘꠛꠣꠞ ꠔꠥꠝꠞꠣꠞ ꠢꠇꠟ ꠛꠦꠐꠣꠁꠘ ꠀꠁꠀ ꠢꠎ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠀꠎꠤꠞ ꠅꠁꠅ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠀꠝꠤꠃ ꠝꠣꠛꠥꠖ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠀꠟ꠆ꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","ꠀꠝꠤ ꠢꠃ ꠖꠦꠡꠞ ꠢꠇꠟ ꠎꠣꠔꠤꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠍꠣꠝꠘ ꠕꠣꠇꠤ ꠈꠦꠖꠣꠁ ꠖꠤꠝꠥ। ꠔꠥꠝꠞꠣꠞ ꠖꠦꠡꠞ ꠡꠤꠝꠣꠘꠣ ꠛꠣꠠꠣꠁꠀ ꠛꠠ ꠇꠞꠝꠥ। ꠔꠥꠝꠞꠣ ꠛꠍꠞꠅ ꠔꠤꠘꠛꠣꠞ ꠘꠤꠎꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠍꠣꠝꠘꠦ ꠀꠎꠤꠞ ꠅꠁꠅ, ꠔꠦꠃ ꠔꠥꠝꠞꠣꠞ ꠎꠣꠉꠣ-ꠎꠝꠤꠘꠞ ꠛꠣꠄ ꠇꠦꠃ ꠟꠣꠟꠌ ꠇꠞꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“ꠀꠝꠣꠞ ꠘꠣꠝꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠞ ꠟꠉꠦ ꠔꠥꠝꠞꠣ ꠈꠣꠝꠤꠞ ꠀꠟꠣ ꠇꠥꠘ꠆ꠔꠣ ꠟꠤꠟ꠆ꠟꠣ-ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠅ ꠘꠣ। ꠀꠎꠣꠖꠤ ꠁꠖꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠇꠥꠘꠥꠎꠣꠔ ꠈꠣꠘꠤ ꠛꠤꠀꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠞꠣꠈꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“ꠔꠥꠝꠞꠣꠞ ꠈꠦꠔꠞ ꠖꠣꠅꠀ ꠙꠄꠟꠣ ꠚꠡꠟꠞ ꠢꠇꠟ ꠕꠣꠇꠤ ꠜꠣꠟꠣ ꠅꠋꠡ ꠀꠟ꠆ꠟꠣ ꠝꠣꠛꠥꠖꠞ ꠊꠞꠅ ꠟꠁꠀ ꠀꠁꠅ। “ꠀꠞ ꠢꠥꠘꠅ, ꠍꠣꠉꠟꠞ ꠛꠣꠁꠌ꠆ꠌꠣꠞ ꠉꠥꠡ꠆ꠔ ꠔꠣꠞ ꠝꠣʼꠞ ꠖꠥꠗꠖꠤ ꠞꠣꠘ꠆ꠖꠤꠅ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠁ ꠇꠣꠟꠣꠝ ꠅꠇꠟ ꠟꠦꠈꠤꠀ ꠕꠅ। ꠀꠝꠤ ꠅꠃ ꠇꠣꠟꠣꠝ ꠝꠣꠚꠤꠇ ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠉꠦ ꠀꠝꠣꠞ ꠝꠤꠟꠘꠞ ꠃꠍꠤꠟ꠆ꠟꠣ ꠛꠅꠀꠁꠟ ꠇꠞꠟꠣꠝ।” ");
INSERT INTO syls_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","ꠅꠃ ꠡꠝꠄ ꠝꠥꠍꠣ ꠘꠛꠤ ꠌꠣꠟ꠆ꠟꠤꠡ ꠖꠤꠘ ꠌꠣꠟ꠆ꠟꠤꠡ ꠞꠣꠁꠔ ꠝꠣꠛꠥꠖꠞ ꠗꠣꠞꠅ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠞꠁꠟꠣ। ꠔꠣꠁꠘ ꠇꠥꠘꠥꠎꠣꠔ ꠖꠣꠘꠣ-ꠙꠣꠘꠤ ꠈꠣꠁꠟꠣ ꠘꠣ। ꠝꠣꠛꠥꠖꠦ ꠢꠃ ꠖꠥꠁꠅ ꠙꠣꠔ꠆ꠔꠞꠞ ꠃꠙꠞꠦ ꠔꠣꠘ ꠟꠉꠦ ꠝꠤꠟꠘꠞ ꠃꠍꠤꠟ꠆ꠟꠣꠞ ꠅꠃ ꠀꠄꠀꠔ ꠅꠇꠟ, ꠝꠣꠘꠤ ꠡꠞꠤꠅꠔꠞ ꠖꠡꠐꠣ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠟꠦꠈꠤꠀ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","ꠔꠦꠃ ꠝꠥꠍꠣꠄ ꠡꠣꠢꠣꠖꠔ ꠙꠣꠔ꠆ꠔꠞ ꠖꠥꠁꠅꠈꠣꠘ ꠀꠔꠅ ꠟꠁꠀ ꠔꠥꠞ ꠙꠣꠠ ꠕꠣꠇꠤ ꠟꠣꠝꠤꠀ ꠀꠁꠟꠣ। ꠝꠣꠛꠥꠖꠞ ꠟꠉꠦ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠣꠄ ꠝꠥꠍꠣꠞ ꠝꠥꠈꠞ ꠍꠥꠞꠔ ꠘꠥꠞꠣꠘꠤ ꠅꠁꠉꠦꠟ, ꠅꠁꠟꠦ ꠝꠥꠍꠣꠄ ꠁꠈꠣꠘ ꠐꠦꠞ ꠙꠣꠁꠟꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","ꠅꠃ ꠡꠝꠄ ꠢꠣꠞꠥꠘ ꠀꠞ ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠝꠥꠍꠣꠞ ꠘꠥꠞꠣꠘꠤ ꠍꠥꠞꠔ ꠖꠦꠈꠟꠣ, ꠖꠦꠈꠤꠀ ꠔꠣꠞꠣ ꠇꠣꠍꠣꠔ ꠀꠁꠔꠦ ꠒꠞꠣꠁꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","ꠅꠁꠟꠦ ꠝꠥꠍꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠒꠣꠇ ꠖꠤꠟꠣ, ꠔꠦꠃ ꠢꠣꠞꠥꠘ ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟ ꠔꠣꠘ ꠉꠦꠍꠦ ꠀꠁꠟꠣ, ꠀꠞ ꠝꠥꠍꠣꠄ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠝꠣꠔ-ꠇꠕꠣ ꠝꠣꠔꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","ꠛꠣꠖꠦ ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠔꠣꠘ ꠇꠣꠍꠣꠔ ꠀꠁꠟꠣ। ꠀꠁꠀ ꠢꠣꠞꠟꠦ ꠔꠣꠁꠘ ꠔꠥꠞ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠖꠦꠅꠀ ꠢꠇꠟ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠔꠣꠞꠣꠞꠦ ꠎꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠝꠣꠔ-ꠇꠕꠣ ꠡꠦꠡ ꠅꠁꠉꠦꠟꠦ ꠝꠥꠍꠣꠄ ꠔꠣꠘ ꠘꠥꠞꠣꠘꠤ ꠌꠦꠢꠣꠞꠣ ꠟꠥꠇꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠝꠥꠈꠅ ꠙꠞ꠆ꠖꠣ ꠟꠣꠉꠣꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","ꠅꠁꠟꠦ ꠝꠥꠍꠣꠄ ꠎꠦꠛꠟꠣ ꠝꠣꠛꠥꠖꠞ ꠟꠉꠦ ꠛꠣꠔꠌꠤꠔꠞ ꠟꠣꠉꠤ ꠈꠣꠘꠦꠇꠣꠞ ꠜꠤꠔꠞꠦ ꠔꠣꠘ ꠍꠣꠝꠘꠦ ꠎꠣꠁꠔꠣ, ꠅꠃ ꠡꠝꠄ ꠁ ꠙꠞ꠆ꠖꠣ ꠈꠥꠟꠤꠟꠤꠔꠣ। ꠛꠣꠖꠦ ꠛꠣꠞꠦ ꠀꠁꠀ ꠙꠞ꠆ꠖꠣ ꠟꠣꠉꠣꠁꠔꠣ, ꠀꠞ ꠀꠟ꠆ꠟꠣꠞ ꠖꠦꠅꠀ ꠢꠥꠇꠥꠝ ꠅꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ꠢꠇꠟ ꠝꠣꠘꠡꠦ ꠖꠦꠈꠔꠣ ꠝꠥꠍꠣꠞ ꠝꠥꠈ ꠘꠥꠞꠣꠘꠤ ꠅꠁꠉꠦꠍꠦ। ꠝꠥꠍꠣꠄ ꠔꠣꠘ ꠝꠥꠈ ꠉꠥꠞꠤꠟꠤꠔꠣ ꠀꠞ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠎꠣꠅꠀꠞ ꠀꠉ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠔꠣꠘ ꠝꠥꠈ ꠉꠥꠞꠣ ꠞꠁꠔ। ");
INSERT INTO syls_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠢꠇꠟ ꠉꠥꠡ꠆ꠐꠤꠞꠦ ꠖꠟꠣ ꠇꠞꠤꠀ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠂꠘ, ꠔꠣꠘ ꠅꠃ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠀꠝꠟ ꠇꠞꠣꠞ ꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ꠔꠥꠝꠞꠣ ꠢꠣꠙ꠆ꠔꠣꠞ ꠍꠄꠖꠤꠘ ꠇꠣꠝ ꠇꠞꠤꠅ, ꠅꠁꠟꠦ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠖꠤꠘ, ꠀꠞꠣꠝꠞ ꠖꠤꠘ, ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞ। ꠁ ꠖꠤꠘ ꠎꠦ ꠝꠣꠘꠡꠦ ꠇꠣꠝ ꠇꠞꠛ, ꠔꠣꠞꠦ ꠝꠣꠞꠤꠟꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠇꠦꠃꠞꠞ ꠊꠞꠅ ꠀꠉꠥꠁꠘ ꠎꠣꠟꠣꠁꠅ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","ꠢꠎꠞꠔ ꠝꠥꠍꠣꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠂꠘ, ");
INSERT INTO syls_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","ꠔꠥꠝꠞꠣ ꠎꠣꠞꠎꠤꠞ ꠖꠤꠟꠞ ꠈꠥꠡꠤ ꠝꠣꠚꠤꠇ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠟꠤꠟ꠆ꠟꠣ ꠟꠁꠀ ꠀꠅ। ꠀꠘꠣꠞ ꠡꠝꠄ ꠅꠃꠟꠣ ꠌꠤꠎ ꠅꠇꠟ ꠟꠤꠟ꠆ꠟꠣ ꠀꠘꠤꠅ: ꠡꠥꠘꠣ, ꠞꠥꠙꠣ, ꠙꠤꠔꠟ; ");
INSERT INTO syls_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ꠟꠤꠟꠥꠀ, ꠛꠣꠁꠋꠉꠘꠤ, ꠟꠣꠟ ꠞꠋꠉꠞ ꠡꠥꠔꠣ; ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠ ꠀꠞ ꠍꠣꠉꠟꠞ ꠞꠥꠝꠣ; ");
INSERT INTO syls_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ꠟꠣꠟ ꠞꠋ ꠟꠣꠉꠣꠁꠟ ꠝꠦꠠꠣꠞ ꠌꠣꠝꠠꠣ, ꠚꠥʼꠞ ꠌꠣꠝꠠꠣ; ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤ; ");
INSERT INTO syls_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ꠌꠦꠞꠣꠉ ꠎꠣꠟꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠎꠄꠔꠥꠘꠞ ꠔꠦꠟ; ꠈꠦꠟꠣꠚꠔꠤ ꠡꠝꠎꠤꠛꠣꠞ ꠔꠦꠟꠞ ꠝꠡꠟꠣ ꠀꠞ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠛꠣꠘꠣꠘꠤꠞ ꠝꠡꠟꠣ; ");
INSERT INTO syls_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ꠁꠝꠣꠝꠞ ꠄꠚꠞꠘ ꠀꠞ ꠛꠥꠇꠥꠞ ꠃꠙꠞꠞ ꠕꠟꠤꠔ ꠟꠣꠉꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠀꠇꠤꠇ ꠝꠘꠤ ꠀꠞ ꠢꠇꠟ ꠘꠝꠥꠘꠣꠞ ꠖꠣꠝꠤ ꠙꠣꠔ꠆ꠔꠞ। ");
INSERT INTO syls_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“ꠔꠥꠝꠞꠣꠞ ꠝꠣꠎꠦ ꠎꠣꠞꠣ ꠜꠣꠟꠣ ꠃꠡ꠆ꠔꠣꠖ ꠇꠣꠞꠤꠉꠞ, ꠔꠣꠞꠣ ꠀꠁꠀ ꠅꠃ ꠢꠇꠟꠔꠣ ꠛꠣꠘꠣꠁꠛꠣ, ꠎꠦꠟꠣ ꠝꠣꠛꠥꠖꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠂꠘ: ");
INSERT INTO syls_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ꠀꠟ꠆ꠟꠣꠞ ꠊꠞ, ꠊꠞꠞ ꠌꠣꠟ, ꠢꠥꠇ, ꠚ꠆ꠞꠦꠁꠝ, ꠛꠣꠔ꠆ꠔꠤ, ꠈꠥꠐꠤ, ꠈꠥꠐꠤꠞ ꠔꠟꠞ ꠌꠥꠘ꠆ꠉꠤ; ");
INSERT INTO syls_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇ, ꠡꠘ꠆ꠖꠥꠇꠞ ꠓꠣꠇꠘꠣ, ꠡꠘ꠆ꠖꠥꠇ ꠛꠁꠀ ꠘꠦꠅꠀꠞ ꠛꠦꠘ꠆ꠖꠣ; ꠡꠘ꠆ꠖꠥꠇꠞꠦ ꠀꠉꠟꠣ ꠖꠤꠛꠣꠞ ꠙꠞ꠆ꠖꠣ; ");
INSERT INTO syls_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ꠛꠦꠘ꠆ꠖꠣ ꠡꠥꠖ꠆ꠖꠣ ꠐꠦꠛꠥꠟ, ꠐꠦꠛꠥꠟꠞ ꠃꠙꠞꠞ ꠢꠇꠟ ꠌꠤꠎ, ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠞ ꠙꠛꠤꠔ꠆ꠞ ꠞꠥꠐꠤ; ");
INSERT INTO syls_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ꠚꠞ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤ, ꠄꠞ ꠟꠉꠞ ꠢꠇꠟ ꠌꠤꠎ ꠀꠞ ꠌꠦꠞꠣꠉ ꠅꠇꠟ, ꠌꠦꠞꠣꠉ ꠎꠣꠟꠣꠘꠤꠞ ꠔꠦꠟ; ");
INSERT INTO syls_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠘꠤꠞ ꠐꠦꠛꠥꠟ, ꠁꠈꠣꠘ ꠛꠁꠀ ꠘꠦꠅꠀꠞ ꠛꠦꠘ꠆ꠖꠣ; ꠈꠦꠟꠣꠚꠔꠤꠞ ꠔꠦꠟ, ꠈꠥꠡꠛꠄ ꠀꠟꠣ ꠀꠉꠞ, ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠖꠥꠀꠞꠞ ꠙꠞ꠆ꠖꠣ; ");
INSERT INTO syls_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ; ꠄꠞ ꠙꠤꠔꠟꠞ ꠎꠣꠟꠤ ꠀꠞ ꠛꠁꠀ ꠘꠦꠅꠀꠞ ꠛꠦꠘ꠆ꠖꠣ; ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠢꠇ꠆ꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ; ꠅꠎꠥꠞ ꠉꠣꠝꠟꠣ ꠀꠞ ꠉꠣꠝꠟꠣ ꠕꠅꠀꠞ ꠌꠇꠤ-ꠈꠣꠐ; ");
INSERT INTO syls_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ꠃꠑꠣꠘꠞ ꠙꠞ꠆ꠖꠣꠁꠘ, ꠈꠥꠐꠤꠘ ꠀꠞ ꠈꠥꠐꠤꠞ ꠔꠟꠞ ꠌꠥꠘ꠆ꠉꠤ; ꠃꠑꠣꠘꠅ ꠢꠣꠝꠣꠘꠤꠞ ꠉꠦꠁꠐꠞ ꠙꠞ꠆ꠖꠣ; ");
INSERT INTO syls_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ꠊꠞꠞ ꠙꠦꠞꠦꠉ ꠀꠞ ꠖꠠꠤ, ꠃꠑꠣꠘꠞ ꠙꠦꠞꠦꠉ ꠀꠞ ꠖꠠꠤ; ");
INSERT INTO syls_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ꠙꠣꠇ ꠎꠣꠉꠣꠔ ꠁꠝꠣꠝꠔꠤ ꠇꠣꠝꠞ ꠟꠣꠉꠤ, ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠙꠛꠤꠔ꠆ꠞ ꠟꠦꠛꠣꠍ, ꠀꠞ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠅ ꠁꠝꠣꠝꠔꠤꠞ ꠟꠦꠛꠣꠍ।” ");
INSERT INTO syls_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","ꠝꠥꠍꠣ ꠘꠛꠤꠞ ꠛꠄꠀꠘ ꠛꠣꠖꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠢꠇꠟ ꠉꠥꠡ꠆ꠐꠤ ꠛꠤꠖꠣꠄ ꠅꠁꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ꠉꠤꠀ ꠔꠣꠞꠣꠞ ꠖꠤꠟꠞ ꠄꠡꠇꠤ ꠝꠣꠚꠤꠇ ꠎꠣꠞꠎꠤꠞ ꠁꠌ꠆ꠍꠣꠄ ꠀꠟ꠆ꠟꠣꠞ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥ ꠛꠣꠘꠣꠘꠤꠞ ꠟꠣꠉꠤ, ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠟꠦꠛꠣꠍꠞ ꠟꠣꠉꠤ ꠀꠞ ꠄꠛꠣꠖꠔ ꠇꠣꠝꠞ ꠟꠣꠉꠤ ꠢꠇꠟ ꠘꠝꠥꠘꠣꠞ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠟꠁꠀ ꠀꠁꠟꠣ। ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠦ ꠟꠤꠟ꠆ꠟꠣ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠅꠔꠣ ꠟꠁꠀ ꠔꠣꠞꠣ ꠀꠎꠤꠞ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","ꠛꠦꠐꠣꠁꠘ ꠛꠣ ꠛꠦꠐꠤꠘ꠆ꠔꠞ ꠝꠣꠎꠦ ꠎꠣꠞꠣꠞ ꠝꠘꠦ ꠌꠣꠁꠟ, ꠔꠣꠞꠣ ꠁꠔꠣ ꠖꠤꠟꠣ। ꠔꠣꠞꠣ ꠎꠣꠞꠎꠤꠞ ꠇꠣꠙꠠꠞ ꠙꠤꠋ, ꠇꠣꠘꠞ ꠁꠀꠞꠤꠋ, ꠀꠋꠐꠤ, ꠉꠟꠣꠞ ꠢꠣꠞ, ꠀꠞ ꠢꠇꠟ ꠎꠣꠔꠞ ꠡꠥꠘꠣꠞ ꠉꠄꠘꠣ ꠀꠘꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠖꠥꠟꠘꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","ꠀꠞ ꠎꠦꠞꠣꠞ ꠉꠦꠍꠦ ꠟꠤꠟꠥꠀ ꠡꠥꠔꠣ, ꠛꠣꠁꠋꠉꠘꠤ, ꠟꠣꠟ ꠡꠥꠔꠣ, ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠ, ꠍꠣꠉꠟꠞ ꠞꠥꠝꠣ, ꠟꠣꠟ ꠞꠋ ꠇꠞꠣ ꠝꠦꠠꠣꠞ ꠌꠣꠝꠠꠣ, ꠚꠥʼꠞ ꠌꠣꠝꠠꠣ ꠀꠍꠤꠟ, ꠔꠣꠞꠣ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠟꠁꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","ꠎꠦꠞꠣꠞ ꠉꠦꠍꠦ ꠞꠥꠙꠣ ꠀꠞ ꠙꠤꠔꠟ ꠀꠍꠤꠟ, ꠔꠣꠞꠣꠅ ꠁꠔꠣ ꠀꠘꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠟꠤꠟ꠆ꠟꠣ ꠖꠤꠟꠣ। ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠇꠣꠝꠅ ꠟꠣꠉꠣꠘꠤꠞ ꠎꠥꠇꠣ ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤ ꠎꠦꠞꠣꠞ ꠉꠦꠍꠦ ꠀꠍꠤꠟ, ꠔꠣꠞꠣꠅ ꠁꠔꠣ ꠟꠁꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","ꠎꠦꠔꠣ ꠛꠦꠐꠤꠘ꠆ꠔꠦ ꠡꠥꠔꠣ ꠛꠣꠘꠣꠘꠤꠔ ꠃꠡ꠆ꠔꠣꠖ, ꠔꠣꠞꠣ ꠘꠤꠎꠞ ꠀꠔꠦ ꠟꠤꠟꠥꠀ, ꠛꠣꠁꠋꠉꠘꠤ, ꠟꠣꠟ ꠞꠋꠉꠞ ꠡꠥꠔꠣ, ꠀꠞ ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠ ꠛꠣꠘꠣꠁꠀ ꠀꠘꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","ꠀꠞ ꠡꠥꠔꠣ ꠛꠣꠘꠣꠅꠞꠣ ꠎꠦꠔꠣ ꠛꠦꠐꠤꠘ꠆ꠔꠞ ꠖꠤꠟꠞ ꠝꠣꠎꠦ ꠄꠡꠇꠤ ꠙꠄꠖꠣ ꠅꠁꠟ, ꠔꠣꠞꠣ ꠍꠣꠉꠟꠞ ꠞꠥꠝꠣ ꠖꠤꠀ ꠡꠥꠔꠣ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟꠦ ꠄꠚꠞꠘ ꠀꠞ ꠛꠥꠇꠥꠞ ꠃꠙꠞꠞ ꠕꠟꠤꠔ ꠟꠣꠉꠣꠘꠤꠞ ꠟꠣꠉꠤ, ꠀꠇꠤꠇ ꠝꠘꠤ ꠀꠞ ꠖꠣꠝꠤ ꠖꠣꠝꠤ ꠙꠣꠔ꠆ꠔꠞ ꠟꠁꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ꠌꠦꠞꠣꠉ ꠎꠣꠟꠣꠘꠤꠞ ꠔꠦꠟ, ꠈꠦꠟꠣꠚꠔꠤ ꠡꠝꠎꠤꠛꠣꠞ ꠔꠦꠟ, ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠛꠣꠘꠣꠘꠤꠞ ꠝꠡꠟꠣ ꠀꠞ ꠎꠄꠔꠥꠘꠞ ꠔꠦꠟꠅ ꠀꠘꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞ ꠝꠣꠎꠖꠤ ꠎꠦꠔꠣ ꠎꠦꠔꠣ ꠇꠞꠣꠞ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠁꠔꠣ ꠙꠥꠞꠣ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠢꠇꠟ ꠛꠦꠐꠣꠁꠘ-ꠛꠦꠐꠤꠘ꠆ꠔꠦ, ꠎꠣꠞꠎꠤꠞ ꠈꠥꠡꠤ ꠝꠣꠚꠤꠇ ꠟꠤꠟ꠆ꠟꠣ ꠟꠁꠀ ꠀꠎꠤꠞ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","ꠛꠣꠖꠦ ꠝꠥꠍꠣꠄ ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠦ ꠄꠢꠥꠖꠣ ꠉꠥꠡ꠆ꠐꠤꠞ ꠢꠥꠞꠞ ꠘꠣꠔꠤ, ꠃꠞꠤꠞ ꠙꠥꠀ ꠛꠣꠔꠍꠦꠟꠟꠞꠦ ꠙꠍꠘ꠆ꠖ ꠇꠞꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","ꠔꠣꠁꠘ ꠄꠞꠦ ꠘꠤꠎꠞ ꠞꠥꠢꠥ ꠝꠥꠛꠣꠞꠇ ꠖꠤꠀ ꠇꠣꠝꠤꠟ ꠛꠣꠘꠣꠁꠀ, ꠢꠇꠟ ꠟꠣꠈꠣꠘ ꠇꠣꠞꠤꠉꠞꠤ ꠇꠣꠝꠞ ꠀꠈꠟ-ꠛꠥꠖ꠆ꠖꠤ, ꠛꠤꠖ꠆ꠖꠣꠄ ꠃꠡ꠆ꠔꠣꠖꠤ ꠇꠣꠝꠞ ꠈꠦꠝꠔꠣ ꠖꠤꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ꠄꠞꠟꠣꠉꠤ ꠄꠁꠘ ꠇꠣꠞꠤꠉꠞꠤ ꠇꠣꠝ ꠇꠞꠣꠞ ꠛꠣꠟꠣ ꠘꠤꠎꠞ ꠀꠈꠟ ꠈꠣꠐꠣꠁꠀ ꠡꠥꠘꠣ, ꠞꠥꠙꠣ, ꠙꠤꠔꠟꠞ ꠃꠙꠞꠦ ꠡꠥꠘ꠆ꠖꠞ ꠡꠥꠘ꠆ꠖꠞ ꠘꠇꠡꠣ ꠛꠣꠘꠣꠁꠔꠣ ꠙꠣꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ꠖꠣꠝꠤ ꠖꠣꠝꠤ ꠙꠣꠔ꠆ꠔꠞ ꠇꠣꠐꠣ, ꠟꠣꠇꠠꠤꠞ ꠃꠙꠞꠦ ꠘꠇꠡꠣ, ꠀꠞ ꠢꠇꠟ ꠘꠝꠥꠘꠣꠞ ꠀꠔꠞ ꠇꠣꠝ ꠇꠞꠔꠣ ꠙꠣꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","ꠀꠞ ꠅꠁꠘ꠆ꠘ ꠝꠣꠘꠡꠞꠦꠅ ꠁꠔꠣ ꠇꠣꠝ ꠢꠤꠇꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠛꠣꠔꠍꠦꠟꠟ ꠀꠞ ꠖꠣꠘ ꠉꠥꠡ꠆ꠐꠤꠞ ꠅꠢꠤꠍꠣꠝꠣꠇꠞ ꠙꠥꠀ ꠀꠢꠟꠤꠀꠛꠞ ꠖꠤꠟꠅ ꠝꠣꠛꠥꠖꠦ ꠀꠈꠟ ꠖꠤꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","ꠔꠣꠁꠘ ꠄꠞꠣꠞꠦ ꠘꠣꠘꠣꠘ ꠎꠣꠔꠞ ꠘꠇꠡꠣꠞ ꠇꠣꠝ, ꠟꠤꠟꠥꠀ, ꠛꠣꠁꠋꠉꠘꠤ, ꠟꠣꠟ ꠡꠥꠔꠣꠖꠤ ꠇꠣꠙꠠ ꠛꠣꠁꠘ ꠇꠞꠣ, ꠘꠇꠡꠣ ꠇꠞꠣ, ꠡꠤꠟꠣꠁ ꠇꠞꠣ, ꠀꠞ ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠ ꠡꠤꠟꠣꠁ ꠇꠞꠣꠞꠅ ꠀꠈꠟ ꠖꠤꠍꠂꠘ। ꠔꠣꠞꠣ ꠢꠇꠟ ꠘꠝꠥꠘꠣꠞ ꠀꠔꠞ ꠇꠣꠝ ꠇꠞꠔꠣ ꠙꠣꠞꠛꠣ, ꠀꠞ ꠘꠤꠎꠞ ꠝꠘ ꠕꠣꠇꠤ ꠘꠣꠘꠣꠘ ꠘꠝꠥꠘꠣꠞ ꠘꠇꠡꠣ ꠛꠣꠘꠣꠁꠔꠣ ꠙꠣꠞꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠄꠅꠈꠣꠘ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠦ ꠛꠣꠔꠍꠦꠟꠟ, ꠀꠢꠟꠤꠀꠛ ꠀꠞ ꠅꠁꠘ꠆ꠘ ꠇꠣꠞꠤꠉꠞ ꠅꠇꠟꠞꠦ ꠀꠈꠟ-ꠛꠥꠖ꠆ꠖꠤ ꠖꠣꠘ ꠇꠞꠟꠣ, ꠎꠣꠔꠦ ꠔꠣꠞꠣ ꠙꠛꠤꠔ꠆ꠞ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠢꠇꠟ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠔꠣ ꠙꠣꠞꠂꠘ। ꠝꠣꠛꠥꠖꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠇꠞꠍꠂꠘ, ꠅꠃ ꠟꠣꠈꠣꠘ ꠔꠣꠞꠣ ꠎꠣꠘꠥ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠢꠇꠟꠔꠣ ꠛꠣꠘꠣꠁꠘ ꠀꠞ ꠢꠣꠎꠣꠁꠘ।” ");
INSERT INTO syls_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","ꠅꠃ ꠇꠣꠝ ꠇꠞꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠝꠥꠍꠣꠄ ꠛꠣꠔꠍꠦꠟꠟ ꠀꠞ ꠀꠢꠟꠤꠀꠛꠞꠦ ꠀꠘꠣꠁꠟꠣ। ꠝꠣꠛꠥꠖꠦ ꠎꠦꠔꠣ ꠃꠡ꠆ꠔꠣꠖ ꠇꠣꠞꠤꠉꠞ ꠅꠇꠟꠞꠦ ꠀꠈꠟ-ꠢꠦꠇꠝꠔ ꠖꠤꠍꠂꠘ, ꠀꠞ ꠁ ꠇꠣꠝ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠎꠦꠞꠣꠞ ꠖꠤꠟꠅ ꠈꠣꠁꠡ ꠙꠄꠖꠣ ꠅꠁꠍꠦ, ꠝꠥꠍꠣꠄ ꠔꠣꠞꠣꠞꠦꠅ ꠀꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","ꠔꠣꠞꠣ ꠀꠁꠀ ꠙꠛꠤꠔ꠆ꠞ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠘꠤꠞ ꠟꠣꠉꠤ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠖꠦꠅꠀ ꠟꠤꠟ꠆ꠟꠣꠞ ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠝꠥꠍꠣꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠡꠝꠎꠤꠀ ꠘꠤꠟꠣ। ꠝꠣꠘꠡꠦ ꠈꠥꠡꠤ ꠅꠁꠀ ꠘꠤꠎꠞ ꠁꠌ꠆ꠍꠣꠄ ꠙꠞꠔꠦꠇ ꠖꠤꠘ ꠛꠤꠀꠘꠦ ꠀꠞꠅ ꠌꠤꠎ ꠅꠇꠟ ꠀꠘꠤꠀ ꠅꠘꠅ ꠟꠤꠟ꠆ꠟꠣ ꠖꠤꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","ꠎꠦ ꠃꠡ꠆ꠔꠣꠖ ꠇꠣꠞꠤꠉꠞ ꠅꠇꠟ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠇꠣꠝꠅ ꠀꠍꠟꠣ, ꠔꠣꠞꠣ ꠁꠔꠣ ꠖꠦꠈꠤꠀ, ꠘꠤꠎꠞ ꠇꠣꠝ ꠕꠁꠀ ꠀꠁꠀ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","“ꠝꠣꠛꠥꠖꠦ ꠎꠦꠔꠣ ꠎꠦꠔꠣ ꠛꠣꠘꠣꠘꠤꠞ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠂꠘ, ꠁꠔꠣ ꠛꠣꠘꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠝꠣꠘꠡꠦ ꠖꠞꠇꠣꠞ ꠕꠣꠇꠤ ꠀꠞꠅ ꠛꠦꠡꠤ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠟꠁꠀ ꠀꠁꠞꠣ।” ");
INSERT INTO syls_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","ꠔꠦꠃ ꠝꠥꠍꠣꠞ ꠢꠥꠇꠥꠝꠦ ꠝꠣꠘꠡꠦ ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠤꠟꠣ, ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠘꠤꠞ ꠟꠣꠉꠤ, ꠇꠦꠃ ꠎꠣꠘꠥ ꠀꠞ ꠇꠥꠘꠥ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠟꠤꠟ꠆ꠟꠣ ꠘꠣ ꠖꠦꠁꠘ। ꠅꠃꠉꠤ ꠝꠣꠘꠡꠦ ꠟꠤꠟ꠆ꠟꠣ ꠖꠦꠅꠀ ꠛꠘ꠆ꠖ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","ꠇꠣꠞꠘ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠇꠣꠝꠞ ꠟꠣꠉꠤ ꠖꠞꠇꠣꠞ ꠕꠣꠇꠤ ꠀꠞꠅ ꠛꠦꠡꠤ ꠌꠤꠎ ꠎꠥꠉꠣꠠ ꠅꠁꠉꠦꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","ꠛꠣꠖꠦ ꠇꠣꠝ ꠇꠞꠞꠣ ꠃꠡ꠆ꠔꠣꠖ ꠅꠇꠟꠦ ꠙꠦꠌꠣꠁꠟ ꠡꠥꠔꠣꠞ ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠ, ꠟꠤꠟꠥꠀ, ꠛꠣꠁꠋꠉꠘꠤ, ꠀꠞ ꠟꠣꠟ ꠡꠥꠔꠣꠖꠤ ꠛꠣꠘꠣꠁꠟ ꠖꠡ ꠐꠥꠇꠞꠣ ꠇꠣꠙꠠ ꠖꠤꠀ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠙꠞ꠆ꠖꠣ ꠛꠣꠘꠣꠁꠟꠣ। ꠀꠞ ꠃꠡ꠆ꠔꠣꠖ ꠅꠇꠟꠦ ꠄꠞ ꠃꠙꠞꠦ ꠇꠣꠞꠥꠛꠤ ꠅꠇꠟꠞ ꠘꠇꠡꠣ ꠛꠣꠁꠘ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ꠙꠞꠔꠦꠇ ꠐꠥꠇꠞꠣꠁꠘ ꠄꠇ ꠝꠣꠙꠞ ꠀꠍꠤꠟ, ꠟꠣꠝ꠆ꠛꠣꠄ ꠀꠐꠣꠁꠡ ꠀꠔ ꠀꠞ ꠙꠣꠡꠦ ꠌꠣꠁꠞ ꠀꠔ। ");
INSERT INTO syls_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","ꠛꠣꠖꠦ ꠙꠣꠌꠈꠣꠘ ꠙꠣꠌꠈꠣꠘ ꠇꠞꠤ ꠄꠇꠈꠣꠘꠅ ꠎꠥꠠꠣ ꠖꠤꠀ ꠛꠠ ꠇꠞꠤ ꠖꠥꠈꠣꠘ ꠉꠤꠟꠣꠚ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","ꠀꠞ ꠖꠥꠁꠅ ꠉꠤꠟꠣꠚꠞ ꠙꠣꠡꠞ ꠄꠇ ꠇꠤꠘꠣꠞꠅ, ꠟꠤꠟꠥꠀ ꠡꠥꠔꠣꠖꠤ ꠢꠥꠇꠞ ꠚꠥꠠ ꠖꠦꠅꠀ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ꠅꠃꠟꠣ ꠙꠄꠟꠣ ꠉꠤꠟꠣꠚꠞ ꠇꠤꠘꠣꠞꠅ ꠙꠁꠘ꠆ꠌꠣꠡꠉꠥ ꠢꠥꠇꠞ ꠚꠥꠠ ꠀꠞ ꠖꠥꠍꠞꠣ ꠉꠤꠟꠣꠚꠞ ꠇꠤꠘꠣꠞꠅ ꠙꠁꠘ꠆ꠌꠣꠡꠉꠥ ꠢꠥꠇꠞ ꠚꠥꠠ ꠟꠣꠉꠣꠁꠟ ꠅꠁꠟ। ꠁ ꠖꠥꠁꠅ ꠢꠥꠇꠞ ꠚꠥꠠ ꠄꠉꠥ ꠀꠞꠦꠉꠥꠞ ꠃꠟꠐꠣꠝꠥꠈꠣ ꠇꠞꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","ꠛꠣꠖꠦ ꠡꠥꠘꠣꠖꠤ ꠙꠁꠘ꠆ꠌꠣꠡꠉꠥ ꠢꠥꠇ ꠛꠣꠘꠣꠁꠀ ꠢꠃ ꠢꠥꠇꠞ ꠚꠥꠠꠞ ꠝꠣꠎꠦꠖꠤ ꠢꠣꠞꠣꠁꠀ, ꠛꠠ ꠖꠥꠁꠅ ꠉꠤꠟꠣꠚꠞꠦ ꠎꠥꠠꠣ ꠖꠦꠅꠀ ꠅꠁꠟ। ꠔꠦꠃ ꠄꠇꠈꠣꠘ ꠊꠞ ꠔꠤꠀꠞ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠌꠣꠟꠞ ꠟꠣꠉꠤ ꠍꠣꠉꠟꠞ ꠞꠥꠝꠣ ꠖꠤꠀ ꠉꠤꠟꠣꠚꠞ ꠟꠣꠈꠣꠘ ꠄꠉꠣꠞꠅꠈꠣꠘ ꠐꠥꠇꠞꠣ ꠛꠣꠘꠣꠁꠟ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","ꠁꠔꠣ ꠙꠞꠔꠦꠇ ꠈꠣꠘ ꠄꠇꠁ ꠝꠣꠙꠞ ꠀꠍꠤꠟ, ꠔꠤꠡ ꠀꠔ ꠟꠣꠝ꠆ꠛꠣ ꠀꠞ ꠌꠣꠁꠞ ꠀꠔ ꠙꠣꠡ। ");
INSERT INTO syls_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","ꠅꠘ ꠕꠣꠇꠤ ꠙꠣꠌ ꠐꠥꠇꠞꠣ ꠄꠇꠟꠉꠦ ꠎꠥꠠꠣ ꠖꠤꠀ ꠛꠠ ꠄꠇ ꠉꠤꠟꠣꠚ ꠛꠣꠘꠣꠁꠟꠣ। ꠀꠞ ꠛꠣꠇꠤ ꠍꠄ ꠐꠥꠇꠞꠣ ꠎꠥꠠꠣ ꠖꠤꠀ, ꠀꠞꠅꠈꠣꠘ ꠛꠠ ꠉꠤꠟꠣꠚ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","ꠙꠄꠟꠣ ꠛꠠ ꠉꠤꠟꠣꠚꠞ ꠙꠣꠡꠞ ꠄꠇ ꠇꠤꠘꠣꠞꠅ ꠙꠁꠘ꠆ꠌꠣꠡꠉꠥ ꠢꠥꠇꠞ ꠚꠥꠠ ꠟꠣꠉꠣꠁꠟꠣ, ꠀꠞ ꠖꠥꠍꠞꠣ ꠉꠤꠟꠣꠚꠅ-ꠅ ꠅꠃꠟꠣ ꠟꠣꠉꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ꠛꠣꠖꠦ ꠙꠤꠔꠟ ꠖꠤꠀ ꠙꠁꠘ꠆ꠌꠣꠡꠉꠥ ꠢꠥꠇ ꠛꠣꠘꠣꠁꠀ ꠢꠃ ꠢꠥꠇꠞ ꠚꠥꠠꠞ ꠝꠣꠎꠦꠖꠤ ꠢꠣꠞꠣꠁꠀ, ꠅꠃ ꠛꠠ ꠖꠥꠁꠅ ꠉꠤꠟꠣꠚ ꠄꠇꠈꠣꠘꠅ ꠎꠥꠠꠣ ꠖꠤꠟꠣ। ꠔꠦꠃ ꠁ ꠖꠥꠁꠅ ꠉꠤꠟꠣꠚ ꠝꠤꠟꠤꠀ ꠄꠇꠈꠣꠘ ꠍꠣꠘꠤ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","ꠟꠣꠟ ꠞꠋ ꠇꠞꠣ ꠝꠦꠠꠣꠞ ꠌꠣꠝꠠꠣꠖꠤ ꠄꠞ ꠃꠙꠞꠞ ꠍꠣꠘꠤ ꠛꠣꠘꠣꠁꠟ ꠅꠁꠟ, ꠛꠣꠖꠦ ꠚꠥʼꠞ ꠌꠣꠝꠠꠣꠖꠤ ꠀꠞꠅꠈꠣꠘ ꠍꠣꠘꠤ ꠔꠂꠀꠞ ꠇꠞꠤꠀ ꠄꠞ ꠃꠙꠞꠦ ꠉꠥꠞꠤ ꠖꠦꠅꠀ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","ꠛꠣꠖꠦ ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤꠖꠤ ꠇꠄꠈꠣꠘ ꠚ꠆ꠞꠦꠁꠝ ꠛꠣꠘꠣꠁꠟ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ꠙꠞꠔꠦꠇ ꠚ꠆ꠞꠦꠁꠝ ꠀꠍꠤꠟ ꠟꠣꠝ꠆ꠛꠣꠄ ꠖꠡ ꠀꠔ ꠀꠞ ꠚꠣꠠꠦ ꠖꠦꠠ ꠀꠔ। ");
INSERT INTO syls_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","ꠙꠞꠔꠦꠇ ꠚ꠆ꠞꠦꠁꠝꠅ ꠖꠥꠉꠥ ꠇꠞꠤ ꠙꠣꠄꠀ ꠟꠣꠉꠣꠁꠀ ꠊꠞꠞ ꠢꠇꠟ ꠚ꠆ꠞꠦꠁꠝ ꠄꠇꠟꠣꠈꠣꠘ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","ꠅꠃ ꠊꠞꠞ ꠖꠇ꠆ꠇꠤꠘ ꠉꠣꠟꠣꠞ ꠟꠣꠉꠤ ꠛꠤꠡꠈꠣꠘ ꠚ꠆ꠞꠦꠁꠝ ꠎꠥꠁꠔ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ꠁ ꠛꠤꠡꠅ ꠚ꠆ꠞꠦꠁꠝꠞ ꠙꠣꠄꠀꠞ ꠔꠟꠦ ꠌꠣꠟ꠆ꠟꠤꠡꠉꠥ ꠞꠥꠙꠣꠞ ꠌꠥꠘ꠆ꠉꠤ ꠟꠣꠉꠣꠁꠟꠣ। ꠙꠞꠔꠦꠇ ꠚ꠆ꠞꠦꠁꠝꠞ ꠖꠥꠁ ꠙꠣꠄꠀꠞ ꠔꠟꠦ ꠖꠥꠉꠥ ꠌꠥꠘ꠆ꠉꠤ ꠟꠣꠉꠣꠁꠟ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠃꠔ꠆ꠔꠞ ꠉꠣꠟꠣꠞ ꠟꠣꠉꠤꠀꠅ ꠛꠤꠡꠈꠣꠘ ꠚ꠆ꠞꠦꠁꠝ ꠎꠥꠁꠔ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ꠁ ꠙꠞꠔꠦꠇ ꠚ꠆ꠞꠦꠁꠝꠞ ꠙꠣꠄꠀꠞ ꠔꠟꠦ ꠌꠣꠟ꠆ꠟꠤꠡꠉꠥ ꠞꠥꠙꠣꠞ ꠌꠥꠘ꠆ꠉꠤ ꠟꠣꠉꠣꠁꠟꠣ। ꠄꠇꠅ ꠚ꠆ꠞꠦꠁꠝꠞ ꠔꠟꠦ ꠖꠥꠉꠥ ꠇꠞꠤ ꠌꠥꠘ꠆ꠉꠤ ꠟꠣꠉꠣꠁꠟ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","ꠀꠞ ꠙꠌꠤꠝ ꠉꠣꠟꠣꠞ ꠟꠣꠉꠤ, ꠝꠣꠘꠤ ꠈꠞ ꠉꠣꠟꠣꠞ ꠟꠣꠉꠤ ꠍꠄꠈꠣꠘ ꠚ꠆ꠞꠦꠁꠝ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ꠀꠞ ꠈꠞꠞ ꠖꠥꠁꠅ ꠇꠥꠘꠣꠔ ꠖꠥꠈꠣꠘ ꠚ꠆ꠞꠦꠁꠝ ꠟꠣꠉꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ꠁ ꠖꠥꠁꠅ ꠇꠥꠘꠣꠞ ꠚ꠆ꠞꠦꠁꠝꠞꠦ ꠇꠣꠍꠣꠞ ꠚ꠆ꠞꠦꠁꠝꠞ ꠟꠉꠦ ꠔꠟꠦ-ꠃꠙꠞꠦ ꠎꠥꠠꠣ ꠖꠦꠅꠀ ꠅꠁꠟ। ꠙꠞꠔꠦꠇ ꠇꠥꠘꠣꠞ ꠖꠥꠁꠅ ꠚ꠆ꠞꠦꠁꠝꠞꠦ ꠗꠣꠞꠞ ꠚ꠆ꠞꠦꠁꠝꠞ ꠟꠉꠦ ꠛꠣꠔ꠆ꠔꠤ ꠝꠣꠞꠤꠀ ꠎꠥꠠꠣ ꠖꠦꠅꠀ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","ꠔꠦꠃ ꠀꠐꠈꠣꠘ ꠚ꠆ꠞꠦꠁꠝ ꠀꠞ ꠡꠥꠟꠉꠥ ꠞꠥꠙꠣꠞ ꠌꠥꠘ꠆ꠉꠤ ꠟꠣꠉꠟ, ꠄꠇꠅ ꠚ꠆ꠞꠦꠁꠝꠞ ꠔꠟꠦ ꠖꠥꠁꠐꠣ ꠇꠞꠤ ꠌꠥꠘ꠆ꠉꠤ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","ꠛꠣꠖꠦ ꠚ꠆ꠞꠦꠁꠝꠞꠦ ꠎꠥꠠꠣ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤꠖꠤ ꠇꠄꠉꠥ ꠟꠣꠝ꠆ꠛꠣ ꠛꠣꠔ꠆ꠔꠤ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ꠊꠞꠞ ꠄꠇ ꠉꠣꠟꠣꠞ ꠟꠣꠉꠤ ꠙꠣꠌꠉꠥ ꠛꠣꠔ꠆ꠔꠤ, ꠀꠞꠇ ꠉꠣꠟꠣꠞ ꠟꠣꠉꠤ ꠀꠞꠅ ꠙꠣꠌꠉꠥ, ꠀꠞ ꠙꠣꠌꠉꠥ ꠛꠣꠔ꠆ꠔꠤ ꠈꠞ ꠉꠣꠟꠣ, ꠝꠣꠘꠤ ꠙꠌꠤꠝ ꠉꠣꠟꠣꠞ ꠟꠣꠉꠤ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","ꠚ꠆ꠞꠦꠁꠝꠞ ꠝꠣꠎꠈꠣꠘꠅ ꠟꠣꠉꠣꠁꠟ ꠅꠃ ꠛꠣꠔ꠆ꠔꠤꠖꠤ ꠢꠇꠟ ꠚ꠆ꠞꠦꠁꠝꠞ ꠄꠇ ꠝꠣꠕꠣ ꠕꠣꠇꠤ ꠀꠞꠇ ꠝꠣꠕꠣ ꠀꠐꠇꠣꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","ꠛꠣꠖꠦ ꠁ ꠚ꠆ꠞꠦꠁꠝ ꠈꠣꠘꠣꠁꠘ ꠡꠥꠘꠣꠖꠤ ꠟꠦꠙꠤꠟꠣ। ꠀꠞ ꠛꠣꠔ꠆ꠔꠤ ꠟꠣꠉꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠡꠥꠘꠣꠞ ꠇꠠꠣ ꠟꠣꠉꠣꠁꠀ, ꠛꠣꠔ꠆ꠔꠤꠞꠦꠅ ꠡꠥꠘꠣꠖꠤ ꠟꠦꠙꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","ꠅꠃ ꠃꠡ꠆ꠔꠣꠖ ꠇꠣꠞꠤꠉꠞ ꠅꠇꠟꠦ ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠꠖꠤ ꠄꠇꠈꠣꠘ ꠙꠞ꠆ꠖꠣ ꠛꠣꠘꠣꠁꠟꠣ। ꠙꠞ꠆ꠖꠣꠞ ꠃꠙꠞꠦ ꠟꠤꠟꠥꠀ, ꠛꠣꠁꠋꠉꠘꠤ, ꠟꠣꠟ ꠡꠥꠔꠣ ꠖꠤꠀ ꠇꠣꠞꠥꠛꠤ ꠅꠇꠟꠞ ꠍꠛꠤ ꠛꠣꠁꠘ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","ꠁ ꠙꠞ꠆ꠖꠣ ꠐꠣꠘꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤꠖꠤ ꠌꠣꠁꠞꠐꠣ ꠈꠥꠐꠤ ꠛꠣꠘꠣꠁꠟꠣ, ꠛꠣꠘꠣꠁꠀ ꠅꠃ ꠈꠥꠐꠤꠘ꠆ꠔꠞꠦꠅ ꠡꠥꠘꠣꠖꠤ ꠟꠦꠙꠤꠟꠣ, ꠈꠥꠐꠤꠘ꠆ꠔꠞ ꠝꠣꠕꠣꠔ ꠡꠥꠘꠣꠞ ꠇꠠꠣ ꠟꠣꠉꠣꠁꠟꠣ। ꠈꠥꠐꠤꠞ ꠔꠟꠞ ꠟꠣꠉꠤ ꠞꠥꠙꠣꠞ ꠌꠣꠁꠞꠐꠣ ꠌꠥꠘ꠆ꠉꠤ ꠛꠣꠘꠣꠁꠟ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠟꠣꠉꠤ ꠟꠤꠟꠥꠀ, ꠛꠣꠁꠋꠉꠘꠤ, ꠟꠣꠟ ꠡꠥꠔꠣ ꠀꠞ ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠꠖꠤ ꠘꠇꠡꠣ ꠇꠞꠤ ꠄꠇꠈꠣꠘ ꠙꠞ꠆ꠖꠣ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","ꠁ ꠙꠞ꠆ꠖꠣꠞ ꠟꠣꠉꠤ ꠙꠣꠌꠐꠣ ꠇꠠꠣ ꠀꠞ ꠙꠣꠌꠐꠣ ꠈꠥꠐꠤ ꠛꠣꠘꠣꠁꠟ ꠅꠁꠟ। ꠈꠥꠐꠤꠞ ꠝꠣꠕꠣ ꠀꠞ ꠔꠟ ꠡꠥꠘꠣꠖꠤ ꠟꠦꠙꠣ ꠅꠁꠟ, ꠈꠥꠐꠤꠞ ꠔꠟꠞ ꠟꠣꠉꠤ ꠙꠤꠔꠟꠞ ꠙꠣꠌꠉꠥ ꠌꠥꠘ꠆ꠉꠤ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","ꠛꠣꠔꠍꠦꠟꠟꠦ ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤꠖꠤ ꠙꠛꠤꠔ꠆ꠞ ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇ ꠛꠣꠘꠣꠁꠟꠣ। ꠁꠐꠣ ꠀꠠꠣꠁ ꠀꠔ ꠟꠣꠝ꠆ꠛꠣ, ꠖꠦꠠ ꠀꠔ ꠙꠣꠡ ꠀꠞ ꠖꠦꠠ ꠀꠔ ꠃꠌꠣ। ");
INSERT INTO syls_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","ꠄꠞ ꠛꠣꠞꠦ-ꠜꠤꠔꠞꠦ ꠈꠣꠐꠤ ꠡꠥꠘꠣꠖꠤ ꠟꠦꠙꠤꠟꠣ, ꠄꠞ ꠌꠣꠁꠞꠅ ꠇꠤꠘꠣꠞꠅ ꠡꠥꠘꠣꠞ ꠘꠇꠡꠣ ꠟꠣꠉꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","ꠀꠉꠥꠁꠘꠖꠤ ꠡꠥꠘꠣ ꠉꠟꠣꠁꠀ ꠌꠣꠁꠞꠐꠣ ꠡꠥꠘꠣꠞ ꠇꠠꠣ ꠄꠞ ꠌꠣꠁꠞꠅ ꠇꠥꠘꠣꠔ ꠟꠣꠉꠣꠁꠟꠣ, ꠅꠉꠣꠟꠣꠔ ꠖꠥꠁꠐꠣ ꠀꠞ ꠢꠉꠣꠟꠣꠔ ꠖꠥꠁꠐꠣ ꠟꠣꠉꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤꠖꠤ ꠖꠥꠉꠥ ꠛꠦꠘ꠆ꠖꠣ ꠛꠣꠘꠣꠁꠀ ꠡꠥꠘꠣꠖꠤ ꠟꠦꠙꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","ꠡꠘ꠆ꠖꠥꠇ ꠛꠁꠀ ꠘꠦꠅꠀꠞ ꠟꠣꠉꠤ ꠁ ꠖꠥꠁꠅ ꠛꠦꠘ꠆ꠖꠣ, ꠡꠘ꠆ꠖꠥꠇꠞ ꠖꠥꠁ ꠉꠣꠟꠣꠞ ꠇꠠꠣꠞ ꠜꠤꠔꠞꠦꠖꠤ ꠢꠣꠞꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","ꠛꠣꠖꠦ ꠈꠣꠐꠤ ꠡꠥꠘꠣꠖꠤ ꠡꠘ꠆ꠖꠥꠇꠞ ꠄꠇꠈꠣꠘ ꠓꠣꠇꠘꠣ ꠛꠣꠘꠣꠁꠟꠣ, ꠅꠈꠣꠘꠞ ꠃꠙꠞꠦ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠟꠣꠉꠤ। ꠁ ꠓꠣꠇꠘꠣ ꠟꠣꠝ꠆ꠛꠣꠄ ꠀꠠꠣꠁ ꠀꠔ, ꠀꠞ ꠙꠣꠡꠦ ꠖꠦꠠ ꠀꠔ। ");
INSERT INTO syls_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","ꠡꠥꠘꠣ ꠙꠤꠐꠣꠁꠀ ꠓꠣꠇꠘꠣꠞ ꠖꠥꠁꠅ ꠉꠣꠟꠣꠔ ꠖꠥꠁꠐꠣ ꠇꠣꠞꠥꠛꠤ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","ꠖꠥꠁꠅ ꠇꠣꠞꠥꠛꠤ ꠡꠘ꠆ꠖꠥꠇꠞ ꠓꠣꠇꠘꠣꠞ ꠖꠥꠁ ꠇꠤꠘꠣꠞꠅ ꠞꠁꠟ। ꠁ ꠖꠥꠁꠅ ꠇꠣꠞꠥꠛꠤ ꠓꠣꠇꠘꠣꠞ ꠟꠉꠦ ꠄꠇꠈꠣꠘꠅ ꠇꠞꠤ ꠛꠣꠘꠣꠁꠟ ꠅꠁꠟ, ꠁ ꠀꠡ꠆ꠔꠣꠐꠣ ꠈꠣꠟꠤ ꠄꠇ ꠌꠤꠎ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","ꠇꠣꠞꠥꠛꠤ ꠖꠦꠈꠔꠦ ꠖꠥꠟꠖꠥꠟ ꠊꠥꠠꠣꠞ ꠟꠣꠈꠣꠘ ꠒꠣꠈꠘꠣ ꠀꠟꠣ, ꠄꠞ ꠖꠥꠁꠅ ꠒꠣꠈꠘꠣ ꠃꠙꠞꠦꠖꠤ ꠝꠦꠟꠤꠀ ꠖꠦꠅꠀꠄ, ꠅꠃ ꠒꠣꠈꠘꠣꠞ ꠍꠣꠄꠀꠞ ꠔꠟꠦ ꠡꠘ꠆ꠖꠥꠇꠞ ꠓꠣꠇꠘꠣ ꠢꠣꠝꠣꠁꠉꠦꠟ। ꠁꠐꠣ ꠝꠥꠈꠣꠝꠥꠈꠤ ꠃꠛꠣ ꠞꠁꠟ। ꠀꠞ ꠔꠣꠞꠣꠞ ꠌꠃꠈ ꠞꠁꠟ ꠡꠘ꠆ꠖꠥꠇꠞ ꠓꠣꠇꠘꠣꠞ ꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","ꠛꠣꠔꠍꠦꠟꠟꠦ ꠛꠣꠖꠦ ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤꠖꠤ ꠖꠥꠁ ꠀꠔ ꠟꠣꠝ꠆ꠛꠣ, ꠄꠇ ꠀꠔ ꠙꠣꠡ ꠀꠞ ꠖꠦꠠ ꠀꠔ ꠃꠌꠣ ꠇꠞꠤ ꠄꠇꠈꠣꠘ ꠐꠦꠛꠥꠟ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","ꠛꠣꠘꠣꠁꠀ ꠢꠣꠞꠟꠦ ꠈꠣꠐꠤ ꠡꠥꠘꠣꠖꠤ ꠟꠦꠙꠤꠀ ꠄꠞ ꠌꠣꠁꠞꠅ ꠇꠤꠘꠣꠞꠅ ꠘꠇꠡꠣ ꠟꠣꠉꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","ꠀꠞ ꠄꠞ ꠍꠣꠘꠤꠞ ꠌꠣꠁꠞꠅ ꠇꠤꠘꠣꠞꠅ ꠌꠣꠁꠞ ꠀꠋꠉꠥꠟ ꠃꠌꠣ ꠇꠞꠤ ꠄꠇ ꠢꠣꠎ ꠖꠤꠟꠣ, ꠢꠣꠎꠞ ꠝꠣꠎꠦ ꠡꠥꠘꠣꠖꠤ ꠘꠇꠡꠣ ꠟꠣꠉꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","ꠐꠦꠛꠥꠟꠞ ꠌꠣꠁꠞꠅ ꠇꠥꠘꠣꠞ ꠙꠣꠄꠀꠞ ꠃꠙꠞꠦ ꠡꠥꠘꠣꠞ ꠌꠣꠁꠞꠐꠣ ꠇꠠꠣ ꠟꠣꠉꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","ꠁ ꠌꠣꠁꠞꠅ ꠇꠠꠣꠁꠘ ꠐꠦꠛꠥꠟꠞ ꠇꠥꠘꠣꠞ ꠢꠃ ꠃꠌꠣ ꠢꠣꠎꠞ ꠔꠟꠦ ꠟꠣꠉꠣꠘꠤ ꠅꠁꠟ, ꠎꠣꠔꠦ ꠐꠦꠛꠥꠟ ꠛꠁꠀ ꠘꠦꠅꠀꠞ ꠛꠣꠟꠣ ꠇꠠꠣꠞ ꠜꠤꠔꠞꠦ ꠛꠦꠘ꠆ꠖꠣ ꠢꠣꠞꠣꠁꠟ ꠎꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","ꠐꠦꠛꠥꠟꠞꠦ ꠛꠁꠀ ꠘꠦꠅꠀꠞ ꠟꠣꠉꠤ ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤꠖꠤ ꠖꠥꠉꠥ ꠛꠦꠘ꠆ꠖꠣ ꠛꠣꠘꠣꠁꠀ ꠡꠥꠘꠣꠖꠤ ꠟꠦꠙꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","ꠐꠦꠛꠥꠟꠞ ꠃꠙꠞꠞ ꠕꠣꠟ-ꠛꠣꠡꠘ, ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠦ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣꠞ ꠎꠉ ꠀꠞ ꠝꠉ, ꠢꠇꠟꠔꠣ ꠈꠣꠐꠤ ꠡꠥꠘꠣꠖꠤ ꠉꠠꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","ꠛꠣꠖꠦ ꠈꠣꠐꠤ ꠡꠥꠘꠣꠖꠤ ꠄꠇꠈꠣꠘ ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤ ꠔꠤꠀꠞ ꠇꠞꠟꠣ। ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤꠞ ꠔꠟꠣ ꠀꠞ ꠃꠙꠞꠞ ꠒꠣꠘ꠆ꠒꠤ ꠈꠣꠐꠤ ꠡꠥꠘꠣ ꠙꠤꠐꠣꠁꠀ ꠉꠠꠣꠁꠟꠣ। ꠄꠞ ꠒꠣꠘ꠆ꠒꠤ, ꠚꠥꠟꠞ ꠟꠣꠈꠣꠘ ꠙꠤꠀꠟꠣ, ꠇꠥꠠꠤ ꠀꠞ ꠙꠣꠙꠠꠤ ꠅꠇꠟ ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤꠞ ꠟꠉꠦ ꠄꠇꠈꠣꠘꠅ ꠇꠞꠤ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤꠞ ꠒꠣꠘ꠆ꠒꠤꠞ ꠖꠥꠁ ꠉꠣꠟꠣꠔ ꠔꠤꠘꠐꠣ ꠇꠞꠤ ꠝꠥꠐ ꠍꠄꠐꠣ ꠒꠣꠟ ꠖꠦꠅꠀ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","ꠙꠞꠔꠦꠇ ꠒꠣꠟꠞ ꠝꠣꠎꠦ ꠎꠛꠣ ꠚꠥꠟꠞ ꠟꠣꠈꠣꠘ ꠔꠤꠘꠉꠥ ꠇꠞꠤ ꠙꠤꠀꠟꠣ ꠔꠤꠀꠞ ꠇꠞꠣ ꠅꠁꠟ। ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤꠞ ꠍꠄꠅ ꠒꠣꠟꠅ ꠄꠇꠟꠣꠈꠣꠘ ꠇꠣꠝ ꠇꠞꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤꠞ ꠝꠥꠟ ꠒꠣꠘ꠆ꠒꠤꠞ ꠝꠣꠎꠦꠅ ꠎꠛꠣ ꠚꠥꠟꠞ ꠟꠣꠈꠣꠘ ꠌꠣꠁꠞꠐꠣ ꠙꠤꠀꠟꠣ ꠖꠦꠅꠀ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","ꠅꠃ ꠝꠥꠟ ꠒꠣꠘ꠆ꠒꠤ ꠕꠣꠇꠤ ꠛꠣꠞꠅꠁꠟ ꠍꠄꠐꠣ ꠒꠣꠟꠞ ꠝꠣꠎꠦ, ꠙꠄꠟꠣ ꠖꠥꠁꠅ ꠒꠣꠟꠞ ꠎꠥꠠꠣꠔ ꠄꠉꠥ ꠇꠞꠤ ꠇꠥꠠꠤ, ꠖꠥꠍꠞꠣ ꠖꠥꠁꠅ ꠒꠣꠟꠞ ꠎꠥꠠꠣꠔ ꠀꠞꠇ ꠇꠥꠠꠤ, ꠀꠞ ꠢꠦꠡꠞ ꠖꠥꠁꠅ ꠒꠣꠟꠞ ꠎꠥꠠꠣꠔꠅ ꠇꠥꠠꠤ ꠟꠣꠉꠣꠁꠟ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","ꠇꠥꠠꠤ ꠀꠞ ꠒꠣꠟ ꠢꠇꠟꠔꠣ ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁꠟ, ꠢꠇꠟꠔꠣ ꠝꠤꠟꠤꠀ ꠄꠇ ꠌꠤꠎ ꠅꠁꠟ। ꠀꠡ꠆ꠔꠣꠐꠣꠃ ꠈꠣꠐꠤ ꠡꠥꠘꠣ ꠙꠤꠐꠣꠁꠀ ꠛꠣꠘꠣꠘꠤ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","ꠈꠣꠐꠤ ꠡꠥꠘꠣꠖꠤ ꠡꠣꠔꠐꠣ ꠌꠦꠞꠣꠉ, ꠌꠦꠞꠣꠉꠞ ꠚꠤꠔꠣ ꠍꠣꠚ ꠇꠞꠣꠞ ꠌꠤꠝꠐꠣ, ꠎꠣꠟꠣꠁꠟ ꠚꠤꠔꠣꠞ ꠍꠣꠟꠤ ꠕꠅꠀꠞ ꠟꠣꠉꠤ ꠇꠄꠉꠥ ꠛꠣꠐꠤ ꠛꠣꠘꠣꠁꠟ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","ꠄꠇ ꠝꠘ ꠈꠣꠐꠤ ꠡꠥꠘꠣꠖꠤ ꠁ ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤ, ꠀꠞ ꠟꠉꠞ ꠢꠇꠟꠔꠣ ꠔꠤꠀꠞ ꠇꠞꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","ꠛꠣꠖꠦ ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤꠖꠤ ꠌꠣꠁꠞ ꠇꠥꠘꠣ ꠀꠟꠣ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠘꠤꠞ ꠐꠦꠛꠥꠟ ꠛꠣꠘꠣꠁꠟ ꠅꠁꠟ। ꠄꠇ ꠀꠔ ꠟꠣꠝ꠆ꠛꠣ, ꠄꠇ ꠀꠔ ꠙꠣꠡ, ꠀꠞ ꠖꠥꠁ ꠀꠔ ꠃꠛꠤ ꠖꠤꠀ ꠁ ꠐꠦꠛꠥꠟ ꠛꠣꠘꠣꠁꠟꠣ। ꠄꠞ ꠌꠣꠁꠞꠅ ꠇꠥꠘꠣꠞ ꠌꠣꠁꠞꠅ ꠢꠤꠋꠅ ꠄꠇꠈꠣꠘꠅ ꠇꠞꠤ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","ꠍꠣꠘꠤ, ꠍꠣꠘꠤꠞ ꠌꠣꠁꠞꠅ ꠇꠤꠘꠣꠞ ꠀꠞ ꠢꠤꠋ, ꠢꠇꠟꠔꠣ ꠈꠣꠐꠤ ꠡꠥꠘꠣꠖꠤ ꠟꠦꠙꠤꠀ ꠌꠣꠁꠞꠅ ꠇꠤꠘꠣꠞꠅ ꠡꠥꠘꠣꠞ ꠘꠇꠡꠣ ꠟꠣꠉꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","ꠄꠞ ꠖꠥꠁ ꠇꠤꠘꠣꠞꠞ ꠘꠇꠡꠣꠞ ꠔꠟꠦ ꠖꠥꠉꠥ ꠇꠞꠤ ꠡꠥꠘꠣꠞ ꠇꠠꠣ ꠟꠣꠉꠣꠁꠟ ꠅꠁꠟ, ꠎꠣꠔꠦ ꠄꠞ ꠜꠤꠔꠞꠦ ꠛꠦꠘ꠆ꠖꠣ ꠢꠣꠞꠣꠁꠀ ꠛꠁꠀ ꠘꠦꠅꠀ ꠎꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤꠖꠤ ꠛꠁꠀ ꠘꠦꠅꠀꠞ ꠛꠦꠘ꠆ꠖꠣ ꠛꠣꠘꠣꠁꠟꠣ, ꠁꠐꠣꠞꠦꠅ ꠡꠥꠘꠣꠖꠤ ꠟꠦꠙꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","ꠛꠣꠖꠦ ꠈꠥꠡꠛꠄ ꠀꠟꠣ ꠝꠡꠟꠣ ꠛꠣꠘꠣꠘꠤꠞ ꠇꠣꠞꠤꠉꠞꠞ ꠘꠤꠅꠝꠦ ꠈꠦꠟꠣꠚꠔꠤ ꠡꠝꠎꠤꠛꠣꠞ ꠙꠛꠤꠔ꠆ꠞ ꠔꠦꠟ ꠀꠞ ꠈꠥꠡꠛꠄ ꠀꠟꠣ ꠈꠣꠐꠤ ꠀꠉꠞ ꠔꠤꠀꠞ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤꠖꠤ ꠙꠣꠌ ꠀꠔ ꠟꠣꠝ꠆ꠛꠣ, ꠙꠣꠌ ꠀꠔ ꠙꠣꠡ ꠀꠞ ꠔꠤꠘ ꠀꠔ ꠃꠛꠤ ꠖꠤꠀ ꠌꠣꠁꠞꠇꠥꠘꠤ ꠇꠞꠤ ꠄꠇꠈꠣꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","ꠄꠞ ꠌꠣꠁꠞꠅ ꠇꠥꠘꠣꠞ ꠃꠙꠞꠦ ꠟꠣꠇꠠꠤꠖꠤ ꠌꠣꠁꠞꠐꠣ ꠢꠤꠋ ꠖꠤꠟꠣ। ꠅꠃ ꠢꠤꠋ ꠛꠣꠘꠣꠁꠟꠣ ꠍꠣꠘꠤꠞ ꠃꠙꠞꠞ ꠇꠥꠘꠣꠞ ꠟꠣꠇꠠꠤ ꠈꠥꠖꠤꠀ, ꠄꠞꠟꠣꠉꠤ ꠁ ꠀꠡ꠆ꠔꠣꠈꠣꠘ ꠄꠇ ꠌꠤꠎ ꠅꠁꠟ। ꠛꠣꠖꠦ ꠙꠥꠞꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠙꠤꠔꠟꠖꠤ ꠟꠦꠙꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠍꠣꠟꠤ ꠔꠥꠟꠣꠞ ꠛꠠ ꠌꠣꠝꠌ ꠀꠞ ꠍꠣꠟꠤ ꠕꠅꠀꠞ ꠉꠣꠝꠟꠣ, ꠟꠃ ꠕꠅꠀꠞ ꠛꠣꠐꠤ, ꠉꠥꠡ꠆ꠔ ꠔꠥꠟꠣꠞ ꠛꠠ ꠇꠣꠐꠣ-ꠍꠤꠚ, ꠀꠋꠞꠣ ꠕꠅꠀꠞ ꠙꠣꠔꠤꠟ, ꠢꠇꠟꠔꠣ ꠙꠤꠔꠟꠖꠤ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠟꠣꠉꠤ ꠙꠤꠔꠟꠖꠤ ꠄꠇꠈꠣꠘ ꠎꠣꠟꠤ ꠛꠣꠘꠣꠁꠟꠣ, ꠛꠣꠘꠣꠁꠀ ꠁ ꠎꠣꠟꠤꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠜꠤꠔꠞꠞ ꠝꠣꠎꠈꠣꠘꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠞ ꠔꠣꠠꠤꠀꠞ ꠔꠟꠦ ꠟꠣꠉꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","ꠀꠞ ꠛꠦꠘ꠆ꠖꠣ ꠢꠣꠞꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠎꠣꠟꠤꠞ ꠌꠣꠁꠞꠅ ꠇꠥꠘꠣꠔ ꠌꠣꠁꠞꠐꠣ ꠇꠠꠣ ꠟꠣꠉꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","ꠛꠁꠀ ꠘꠦꠅꠀꠞ ꠛꠦꠘ꠆ꠖꠣ ꠛꠣꠘꠣꠁꠟꠣ ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤꠖꠤ, ꠛꠣꠘꠣꠁꠀ ꠖꠥꠁꠅꠉꠥ ꠙꠤꠔꠟꠖꠤ ꠟꠦꠙꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞꠦ ꠛꠁꠛꠣꠞ ꠟꠣꠉꠤ ꠄꠞ ꠇꠥꠘꠣꠞ ꠇꠠꠣꠞ ꠜꠤꠔꠞꠦ ꠅꠃ ꠛꠦꠘ꠆ꠖꠣ ꠢꠣꠞꠣꠁꠟꠣ। ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠁꠟꠣ ꠔꠇ꠆ꠔꠣꠖꠤ, ꠀꠞ ꠄꠞ ꠜꠤꠔꠞꠦ ꠚꠣꠇ ꠞꠣꠈꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","ꠅꠎꠥꠞ ꠙꠣꠘꠤ ꠕꠅꠀꠞ ꠟꠣꠉꠤ ꠙꠤꠔꠟꠞ ꠄꠇ ꠉꠣꠝꠟꠣ ꠛꠣꠘꠣꠁꠟꠣ। ꠄꠛꠣꠖꠔꠤ ꠇꠣꠝꠞ ꠟꠣꠉꠤ ꠎꠦꠔꠣ ꠛꠦꠐꠤꠘ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠇꠣꠍꠣꠔ ꠀꠁꠔꠣ, ꠔꠣꠞꠣꠞ ꠙꠤꠔꠟꠞ ꠀꠄꠘꠣꠖꠤ ꠁ ꠉꠣꠝꠟꠣ ꠀꠞ ꠄꠞ ꠌꠇꠤ-ꠈꠣꠐ ꠔꠂꠀꠞ ꠇꠞꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","ꠛꠣꠔꠍꠦꠟꠟꠦ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠛꠣꠄ ꠃꠑꠣꠘꠞ ꠎꠣꠉꠣ ꠞꠣꠈꠟꠣ। ꠃꠑꠣꠘꠞ ꠖꠇ꠆ꠇꠤꠘ ꠉꠣꠟꠣꠞ ꠄꠇ-ꠡ ꠀꠔ ꠎꠣꠉꠣꠞ ꠟꠣꠉꠤ ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠꠖꠤ ꠙꠞ꠆ꠖꠣ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","ꠁ ꠙꠞ꠆ꠖꠣ ꠐꠣꠘꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠛꠤꠡꠉꠥ ꠈꠥꠐꠤ ꠛꠣꠘꠣꠁꠟꠣ। ꠈꠥꠐꠤꠞ ꠔꠟꠣꠔ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠙꠤꠔꠟꠞ ꠛꠤꠡꠉꠥ ꠌꠥꠘ꠆ꠉꠤ ꠛꠣꠘꠣꠁꠟꠣ, ꠀꠞ ꠙꠞ꠆ꠖꠣ ꠐꠣꠘꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠞꠥꠙꠣꠞ ꠇꠠꠣ ꠀꠞ ꠛꠣꠘ꠆ꠖꠤꠛꠣꠞ ꠔꠣꠞ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","ꠃꠑꠣꠘꠞ ꠃꠔ꠆ꠔꠞ ꠉꠣꠟꠣꠞ ꠄꠇ-ꠡ ꠀꠔ ꠎꠣꠉꠣꠞ ꠟꠣꠉꠤ ꠛꠤꠡꠉꠥ ꠈꠥꠐꠤ, ꠈꠥꠐꠤꠞ ꠔꠟꠦ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠙꠤꠔꠟꠞ ꠛꠤꠡꠉꠥ ꠌꠥꠘ꠆ꠉꠤ, ꠀꠞ ꠙꠞ꠆ꠖꠣ ꠐꠣꠘꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠞꠥꠙꠣꠞ ꠇꠠꠣ ꠀꠞ ꠛꠣꠘ꠆ꠖꠤꠛꠣꠞ ꠔꠣꠞ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","ꠙꠌꠤꠝ ꠉꠣꠟꠣꠞ ꠙꠁꠘ꠆ꠌꠣꠡ ꠀꠔ ꠃꠑꠣꠘꠞ ꠟꠣꠉꠤ ꠙꠞ꠆ꠖꠣ, ꠖꠡꠉꠥ ꠈꠥꠐꠤ, ꠖꠡꠉꠥ ꠌꠥꠘ꠆ꠉꠤ, ꠙꠞ꠆ꠖꠣ ꠐꠣꠘꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠞꠥꠙꠣꠞ ꠇꠠꠣ ꠀꠞ ꠛꠣꠘ꠆ꠖꠤꠛꠣꠞ ꠔꠣꠞ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","ꠙꠥꠛ ꠉꠣꠟꠣꠞ ꠃꠑꠣꠘꠅ ꠙꠁꠘ꠆ꠌꠣꠡ ꠀꠔ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","ꠃꠑꠣꠘꠞ ꠉꠦꠁꠐꠞ ꠄꠇ ꠉꠣꠟꠣꠞ ꠟꠣꠉꠤ ꠙꠘꠞ ꠀꠔ ꠟꠣꠝ꠆ꠛꠣ ꠙꠞ꠆ꠖꠣ, ꠔꠤꠘꠐꠣ ꠈꠥꠐꠤ, ꠈꠥꠐꠤꠞ ꠔꠟꠞ ꠔꠤꠘꠉꠥ ꠌꠥꠘ꠆ꠉꠤ, ");
INSERT INTO syls_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","ꠀꠞ ꠖꠥꠍꠞꠣ ꠉꠣꠟꠣꠔꠅ ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠞꠤ ꠔꠤꠘꠐꠣ ꠈꠥꠐꠤ, ꠔꠤꠘꠐꠣ ꠌꠥꠘ꠆ꠉꠤ ꠀꠞ ꠙꠘꠞ ꠀꠔ ꠙꠞ꠆ꠖꠣ ꠛꠣꠘꠣꠁꠟ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","ꠃꠑꠣꠘꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠞ ꠢꠇ꠆ꠇꠟ ꠙꠞ꠆ꠖꠣꠁꠘ ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠꠖꠤ ꠛꠣꠘꠣꠁꠟ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","ꠈꠥꠐꠤꠞ ꠔꠟꠞ ꠢꠇ꠆ꠇꠟ ꠌꠥꠘ꠆ꠉꠤ ꠙꠤꠔꠟꠞ, ꠙꠞ꠆ꠖꠣ ꠐꠣꠘꠣꠘꠤꠞ ꠇꠠꠣ ꠀꠞ ꠛꠣꠘ꠆ꠖꠤꠛꠣꠞ ꠔꠣꠞ ꠅꠁꠟ ꠞꠥꠙꠣꠞ, ꠈꠥꠐꠤꠞ ꠝꠣꠕꠣꠅ ꠞꠥꠙꠣꠖꠤ ꠙꠦꠌꠣꠁꠟ ꠅꠁꠟ। ꠃꠑꠣꠘꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠞ ꠢꠇ꠆ꠇꠟ ꠈꠥꠐꠤꠔ ꠞꠥꠙꠣꠞ ꠔꠣꠞꠖꠤ ꠛꠣꠘ꠆ꠖꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","ꠃꠑꠣꠘꠞ ꠉꠦꠁꠐꠞ ꠟꠣꠉꠤ ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠꠖꠤ ꠄꠇꠈꠣꠘ ꠙꠞ꠆ꠖꠣ ꠛꠣꠘꠣꠁꠟ ꠅꠁꠟ। ꠛꠣꠖꠦ ꠟꠤꠟꠥꠀ, ꠛꠣꠁꠋꠉꠘꠤ, ꠟꠣꠟ ꠡꠥꠔꠣꠖꠤ ꠘꠇꠡꠣ ꠇꠞꠣ ꠅꠁꠟ। ꠙꠞ꠆ꠖꠣ ꠈꠣꠘ ꠛꠤꠡ ꠀꠔ ꠟꠣꠝ꠆ꠛꠣ, ꠀꠞ ꠃꠑꠣꠘꠞ ꠛꠣꠇꠤ ꠙꠞ꠆ꠖꠣꠞ ꠟꠣꠈꠣꠘ ꠁꠐꠣꠅ ꠙꠣꠌ ꠀꠔ ꠃꠌꠣ ꠖꠦꠅꠀ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","ꠄꠞ ꠌꠣꠁꠞꠅ ꠈꠥꠐꠤ ꠀꠞ ꠌꠥꠘ꠆ꠉꠤ ꠙꠤꠔꠟꠞ, ꠈꠥꠐꠤꠞ ꠇꠠꠣ ꠀꠞ ꠛꠣꠘ꠆ꠖꠣꠞ ꠔꠣꠞ ꠞꠥꠙꠣꠞ, ꠈꠥꠐꠤꠞ ꠝꠣꠕꠣꠅ ꠞꠥꠙꠣꠖꠤ ꠙꠦꠌꠣꠁ ꠖꠦꠅꠀ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","ꠀꠟ꠆ꠟꠣꠞ ꠊꠞ ꠀꠞ ꠃꠑꠣꠘꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠞ ꠈꠥꠐꠤꠞ ꠙꠦꠞꠦꠉ ꠅꠇꠟ ꠙꠤꠔꠟꠖꠤ ꠛꠣꠘꠣꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","ꠀꠟ꠆ꠟꠣꠞ ꠊꠞ ꠝꠣꠘꠤ ꠅꠃ ꠡꠣꠢꠣꠖꠔ ꠔꠣꠝ꠆ꠛꠥ ꠛꠣꠘꠣꠁꠔꠦ ꠎꠦꠔꠣ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠟꠣꠉꠍꠤꠟ, ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠙꠥꠀ ꠁꠍꠣꠝꠣꠞꠞ ꠎꠤꠝ꠆ꠝꠣꠄ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠡꠦ ꠁꠔꠣꠞ ꠢꠤꠡꠣꠛ ꠞꠣꠈꠟꠣ। ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠅꠃ ꠢꠤꠡꠣꠛ ꠞꠣꠈꠣꠞ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠎꠦꠟꠣꠈꠣꠘ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠁ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠄꠢꠥꠖꠣ ꠉꠥꠡ꠆ꠐꠤꠞ ꠃꠞꠤꠞ ꠙꠥꠀ ꠛꠣꠔꠍꠦꠟꠟꠦ ꠁꠔꠣ ꠢꠇ꠆ꠇꠟꠔꠣ ꠛꠣꠘꠣꠁꠟꠣ, ꠔꠣꠁꠘ ꠀꠍꠟꠣ ꠢꠥꠞꠞ ꠘꠣꠔꠤ। ");
INSERT INTO syls_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","ꠖꠣꠘ ꠉꠥꠡ꠆ꠐꠤꠞ ꠅꠢꠤꠍꠣꠝꠣꠇꠞ ꠙꠥꠀ ꠀꠢꠟꠤꠀꠛꠦ ꠛꠣꠔꠍꠦꠟꠟꠞꠦ ꠡꠣꠁꠎ꠆ꠎ ꠇꠞꠟꠣ। ꠢꠇꠟ ꠎꠣꠔꠞ ꠀꠔꠞ ꠇꠣꠝ ꠀꠞ ꠘꠇꠡꠣ ꠛꠣꠘꠣꠘꠤꠞ ꠇꠣꠝꠅ ꠔꠣꠁꠘ ꠃꠡ꠆ꠔꠣꠖ ꠀꠍꠟꠣ। ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠꠞ ꠝꠣꠎꠦ ꠟꠤꠟꠥꠀ, ꠛꠣꠁꠋꠉꠘꠤ, ꠟꠣꠟ ꠡꠥꠔꠣꠖꠤ ꠘꠇꠡꠣ ꠇꠞꠣꠞ ꠇꠣꠝꠅ-ꠅ ꠔꠣꠁꠘ ꠃꠡ꠆ꠔꠣꠖ ꠀꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","ꠖꠥꠟꠘꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠕꠣꠇꠤ ꠙꠣꠅꠀ ꠃꠘꠔꠤꠡ ꠝꠘ ꠡꠣꠔ-ꠡ ꠔꠤꠡ ꠔꠟꠣ ꠡꠥꠘꠣ ꠅꠃ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠁꠔꠦ ꠟꠣꠉꠍꠦ। ꠁ ꠝꠣꠙ ꠅꠁꠟ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠔꠟꠣꠞ ꠝꠣꠙꠦ। ");
INSERT INTO syls_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠘꠥꠡ ꠉꠘꠤꠛꠣꠞ ꠛꠣꠟꠣ ꠎꠦꠞꠣꠞꠦ ꠉꠘꠣ ꠅꠁꠍꠤꠟ, ꠔꠣꠞꠣꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠄꠇ-ꠡ ꠝꠘ ꠄꠇ ꠀꠎꠣꠞ ꠡꠣꠔ-ꠡ ꠙꠌꠔ꠆ꠔꠁꠞ ꠔꠟꠣ ꠞꠥꠙꠣ ꠙꠣꠅꠀ ꠉꠦꠍꠤꠟ, ꠁ ꠝꠣꠙ ꠅꠁꠟ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠝꠣꠙꠦ। ");
INSERT INTO syls_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","ꠉꠘꠣ ꠅꠁꠍꠦ ꠅꠃꠟꠣ ꠝꠣꠘꠥꠡ, ꠝꠣꠘꠤ ꠛꠤꠡ ꠛꠞꠍ ꠛꠣ ꠄꠞ ꠌꠣꠁꠔꠦ ꠛꠦꠡꠤ ꠛꠄꠅꠡ ꠀꠟꠣ, ꠢꠃ ꠍꠄ ꠟꠣꠈ ꠔꠤꠘ ꠀꠎꠣꠞ ꠡꠣꠠꠦ ꠙꠣꠌ-ꠡ ꠝꠣꠘꠡꠦ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠝꠣꠙꠦ ꠝꠣꠕꠣ ꠙꠤꠍꠥ ꠀꠗꠣ ꠔꠟꠣ ꠇꠞꠤ ꠞꠥꠙꠣ ꠖꠤꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","ꠁ ꠞꠥꠙꠣ ꠕꠣꠇꠤ ꠄꠇ-ꠡ ꠝꠘ ꠞꠥꠙꠣ ꠖꠤꠀ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣ ꠀꠞ ꠙꠞ꠆ꠖꠣꠞ ꠈꠥꠐꠤꠞ ꠔꠟꠞ ꠌꠥꠘ꠆ꠉꠤ ꠛꠣꠘꠣꠁꠟ ꠅꠁꠍꠤꠟ। ꠄꠇ ꠄꠇ ꠌꠥꠘ꠆ꠉꠤꠔ ꠄꠇ ꠝꠘ ꠞꠥꠙꠣ ꠖꠤꠀ ꠝꠥꠐ ꠄꠇ-ꠡꠉꠥ ꠌꠥꠘ꠆ꠉꠤ ꠛꠣꠘꠣꠁꠟ ꠅꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","ꠀꠞ ꠛꠣꠇꠤ ꠄꠇ ꠀꠎꠣꠞ ꠡꠣꠔ-ꠡ ꠙꠌꠔ꠆ꠔꠁꠞ ꠔꠟꠣ ꠞꠥꠙꠣ ꠈꠥꠐꠤꠞ ꠇꠠꠣ, ꠈꠥꠐꠤꠞ ꠝꠣꠕꠣ ꠙꠦꠌꠣꠘꠤ, ꠀꠞ ꠛꠣꠘ꠆ꠖꠤꠛꠣꠞ ꠔꠣꠞ ꠛꠣꠘꠣꠘꠤꠔ ꠟꠣꠉꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","ꠖꠥꠟꠘꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠕꠣꠇꠤ ꠟꠤꠟ꠆ꠟꠣꠞ ꠙꠤꠔꠟ ꠖꠟꠣ ꠅꠁꠍꠤꠟ ꠡꠔ꠆ꠔꠁꠞ ꠝꠘ ꠖꠥꠁ ꠀꠎꠣꠞ ꠌꠣꠁꠞ-ꠡ ꠔꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ꠁꠔꠣ ꠖꠤꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠌꠥꠘ꠆ꠉꠤ, ꠙꠤꠔꠟꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ, ꠄꠞ ꠙꠤꠔꠟꠞ ꠎꠣꠟꠤ ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠢꠇ꠆ꠇꠟ ꠌꠤꠎ ꠛꠣꠘꠣꠁꠟ ꠅꠁꠍꠦ, ");
INSERT INTO syls_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ꠃꠑꠣꠘꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠞ ꠌꠥꠘ꠆ꠉꠤ, ꠉꠦꠁꠐꠞ ꠌꠥꠘ꠆ꠉꠤ, ꠔꠣꠝ꠆ꠛꠥ ꠀꠞ ꠃꠑꠣꠘꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠞ ꠈꠥꠐꠤꠞ ꠙꠦꠞꠦꠉ ꠛꠣꠘꠣꠁꠟ ꠅꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠙꠣꠇ ꠎꠣꠉꠣꠔ ꠁꠝꠣꠝꠔꠤ ꠇꠣꠝꠞ ꠡꠝꠄ ꠚꠤꠘ꠆ꠖꠣꠞ ꠟꠣꠉꠤ, ꠔꠣꠞꠣ ꠟꠣꠟ, ꠛꠣꠁꠋꠉꠘꠤ ꠀꠞ ꠟꠤꠟꠥꠀ ꠡꠥꠔꠣꠖꠤ ꠡꠥꠘ꠆ꠖꠞ ꠇꠞꠤ ꠟꠦꠛꠣꠍ ꠛꠣꠘꠣꠁꠟꠣ। ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠄꠇ꠆ꠇꠦꠞꠦ ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠞꠤ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠟꠣꠉꠤ ꠙꠛꠤꠔ꠆ꠞ ꠟꠦꠛꠣꠍ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","ꠅꠃ ꠃꠡ꠆ꠔꠣꠖ ꠇꠣꠞꠤꠉꠞ ꠅꠇꠟꠦ ꠟꠤꠟꠥꠀ, ꠛꠣꠁꠋꠉꠘꠤ, ꠟꠣꠟ ꠡꠥꠔꠣ, ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠ ꠀꠞ ꠡꠥꠘꠣꠖꠤ ꠙꠞꠗꠣꠘ ꠁꠝꠣꠝꠞ ꠄꠚꠞꠘ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","ꠡꠥꠘꠣ ꠙꠤꠐꠣꠁꠀ ꠙꠣꠔ ꠛꠣꠘꠣꠁꠀ, ꠡꠥꠔꠣꠞ ꠟꠣꠈꠣꠘ ꠡꠥꠘꠣꠞ ꠔꠣꠞ ꠔꠤꠀꠞ ꠇꠞꠟꠣ। ꠛꠣꠖꠦ ꠟꠤꠟꠥꠀ, ꠛꠣꠁꠋꠉꠘꠤ, ꠟꠣꠟ ꠡꠥꠔꠣ, ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠ ꠀꠞ ꠡꠥꠘꠣꠞ ꠔꠣꠞ ꠄꠇꠟꠉꠦ ꠝꠤꠟꠣꠁꠀ ꠇꠣꠙꠠ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","ꠄꠚꠞꠘꠞ ꠇꠣꠘ꠆ꠖꠞ ꠉꠣꠟꠣ ꠎꠥꠠꠣ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠖꠥꠈꠣꠘ ꠙꠐ꠆ꠐꠤ ꠛꠣꠘꠣꠁꠀ, ꠄꠚꠞꠘꠞ ꠃꠙꠞꠞ ꠇꠥꠘꠣꠔ ꠟꠣꠉꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","ꠄꠚꠞꠘꠞ ꠟꠉꠦ ꠎꠥꠠꠣ ꠟꠣꠉꠣꠁꠟ ꠙꠦꠐꠞ ꠃꠙꠞꠞ ꠛꠦꠟꠐ ꠈꠣꠘꠅ ꠄꠚꠞꠘꠞ ꠡꠥꠔꠣꠖꠤ ꠛꠣꠘꠣꠁꠟꠣ। ꠔꠣꠞꠣ ꠟꠤꠟꠥꠀ, ꠛꠣꠁꠋꠉꠘꠤ, ꠟꠣꠟ ꠡꠥꠔꠣ, ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠ ꠀꠞ ꠡꠥꠘꠣꠞ ꠔꠣꠞ ꠖꠤꠀ ꠑꠤꠇ ꠄꠚꠞꠘꠞ ꠘꠝꠥꠘꠣꠄ ꠛꠣꠘꠣꠁꠟꠣ। ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠄꠇ꠆ꠇꠦꠞꠦ ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠞꠤ ꠢꠇ꠆ꠇꠟꠔꠣ ꠛꠣꠘꠣꠁꠟ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","ꠛꠣꠖꠦ ꠔꠣꠞꠣ ꠖꠥꠁꠐꠣ ꠀꠇꠤꠇ ꠙꠣꠔ꠆ꠔꠞ ꠇꠣꠐꠤꠀ, ꠄꠞ ꠃꠙꠞꠦ ꠡꠥꠘꠣꠞ ꠎꠣꠎꠁꠞ ꠛꠅꠀꠁꠟꠣ। ꠢꠥꠘꠣꠞ ꠅꠇꠟꠦ ꠖꠣꠝꠤ ꠙꠣꠔ꠆ꠔꠞ ꠈꠥꠖꠤꠀ ꠎꠦꠟꠣ ꠡꠤꠟ ꠛꠣꠘꠣꠁꠘ, ꠅꠃꠟꠣ ꠙꠣꠔ꠆ꠔꠞ ꠈꠥꠖꠤꠀ ꠁꠍꠞꠣꠁꠟꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠘꠣꠝ ꠟꠦꠈꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","ꠀꠞ ꠅꠃ ꠖꠥꠁꠅ ꠙꠣꠔ꠆ꠔꠞ ꠡꠥꠘꠣꠞ ꠎꠣꠎꠁꠞꠞ ꠝꠣꠎꠦ ꠟꠣꠉꠣꠁꠀ, ꠄꠚꠞꠘꠞ ꠇꠣꠘ꠆ꠖꠞ ꠚꠤꠔꠣꠞ ꠟꠉꠦ ꠛꠣꠘ꠆ꠖꠤꠟꠣ। ꠁꠍꠞꠣꠁꠟꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠛꠣꠄ ꠝꠣꠛꠥꠖꠞ ꠘꠎꠞ ꠞꠣꠈꠣꠞ ꠟꠣꠉꠤ ꠁꠟꠣ ꠇꠞꠟꠣ। ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠅꠃꠟꠣ ꠢꠇꠟꠔꠣ ꠇꠞꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","ꠛꠣꠖꠦ ꠄꠚꠞꠘꠞ ꠟꠣꠈꠣꠘ ꠜꠣꠟꠣ ꠃꠡ꠆ꠔꠣꠖ ꠖꠞ꠆ꠎꠤꠞꠦꠖꠤ ꠟꠤꠟꠥꠀ, ꠛꠣꠁꠋꠉꠘꠤ, ꠟꠣꠟ ꠡꠥꠔꠣ, ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠ ꠀꠞ ꠡꠥꠘꠣꠖꠤ ꠛꠥꠇꠥꠞ ꠃꠙꠞꠞ ꠕꠟꠤ ꠛꠣꠘꠣꠁꠟ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","ꠁꠐꠣ ꠅꠁꠟ ꠟꠣꠝ꠆ꠛꠣꠄ ꠀꠗꠣ ꠀꠔ, ꠙꠣꠡꠦ ꠀꠗꠣ ꠀꠔ, ꠌꠣꠁꠞꠇꠥꠘꠤ ꠖꠥꠁ ꠜꠣꠁꠘ꠆ꠎ ꠇꠞꠣ ꠇꠣꠙꠠ। ");
INSERT INTO syls_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","ꠄꠞ ꠃꠙꠞꠦ ꠔꠣꠞꠣ ꠌꠣꠁꠞ ꠢꠣꠁꠞ ꠇꠞꠤ ꠖꠣꠝꠤ ꠙꠣꠔ꠆ꠔꠞ ꠟꠣꠉꠣꠁꠟꠣ। ꠙꠄꠟꠣ ꠢꠣꠞꠤꠔ ꠁꠀꠇꠥꠔ, ꠙꠤꠔ ꠀꠞ ꠙꠣꠘ꠆ꠘꠣ ꠝꠘꠤ; ");
INSERT INTO syls_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ꠖꠥꠍꠞꠣ ꠢꠣꠞꠤꠔ ꠟꠣꠟꠝꠘꠤ, ꠟꠤꠟ ꠝꠘꠤ ꠀꠞ ꠢꠤꠞꠣ; ");
INSERT INTO syls_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ꠔꠤꠘ ꠘꠝ꠆ꠛꠞ ꠢꠣꠞꠤꠔ ꠚꠤꠞꠥꠎ, ꠉꠥꠝꠦꠖ ꠀꠞ ꠙꠖ꠆ꠖꠞꠣꠉ ꠝꠘꠤ; ");
INSERT INTO syls_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ꠌꠣꠁꠞ ꠘꠝ꠆ꠛꠞ ꠢꠣꠞꠤꠔ ꠙꠥꠈꠞꠣꠎ, ꠛꠂꠖꠥꠞ꠆ꠎ ꠀꠞ ꠡꠥꠞꠥꠎ ꠝꠘꠤ। ꠁ ꠙꠣꠔ꠆ꠔꠞ ꠅꠇꠟ ꠡꠥꠘꠣꠞ ꠎꠣꠎꠁꠞꠞ ꠃꠙꠞꠦ ꠟꠣꠉꠣꠁꠟ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","ꠁꠍꠞꠣꠁꠟꠞ ꠛꠣꠞꠅ ꠙꠥꠀꠞ ꠟꠣꠉꠤ ꠛꠣꠞꠅꠐꠣ ꠙꠣꠔ꠆ꠔꠞ ꠟꠣꠉꠣꠁꠟꠣ। ꠁꠔꠣ ꠄꠇꠅ ꠙꠣꠔ꠆ꠔꠞꠅ ꠄꠇ ꠄꠇ ꠙꠥꠀꠞ ꠘꠣꠝ ꠈꠥꠖꠤꠀ ꠟꠦꠈꠣ ꠅꠁꠟ, ꠎꠦꠟꠣ ꠈꠥꠖꠤꠀ ꠡꠤꠟ ꠛꠣꠘꠣꠁꠟ ꠅꠄ। ");
INSERT INTO syls_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","ꠛꠥꠇꠥꠞ ꠃꠙꠞꠞ ꠕꠟꠤꠞ ꠟꠣꠉꠤ ꠈꠣꠐꠤ ꠡꠥꠘꠣꠖꠤ ꠞꠡꠤꠞ ꠟꠣꠈꠣꠘ ꠙꠦꠌꠣꠁꠀ ꠖꠥꠇꠍꠣ ꠌꠦꠁꠘ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ꠀꠞ ꠡꠥꠘꠣꠞ ꠖꠥꠈꠣꠘ ꠎꠣꠎꠁꠞ ꠀꠞ ꠖꠥꠁꠐꠣ ꠇꠠꠣ ꠛꠣꠘꠣꠁꠀ, ꠛꠥꠇꠥꠞ ꠅꠃ ꠕꠟꠤꠞ ꠃꠙꠞꠞ ꠖꠥꠁ ꠇꠥꠘꠣꠔ ꠟꠣꠉꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","ꠀꠞ ꠌꠦꠁꠘ ꠖꠥꠁꠅꠉꠦꠍꠣ ꠖꠥꠁꠅ ꠇꠠꠣꠞ ꠟꠉꠦ ꠀꠐꠇꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ꠖꠥꠁꠅ ꠇꠣꠘ꠆ꠖꠞ ꠄꠚꠞꠘꠞ ꠍꠣꠝꠘꠞ ꠚꠤꠔꠣꠔ ꠡꠥꠘꠣꠞ ꠎꠣꠎꠁꠞꠞ ꠟꠉꠦ ꠌꠦꠁꠘꠞ ꠄꠇ ꠝꠣꠕꠣ ꠛꠣꠘ꠆ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","ꠀꠞꠅ ꠖꠥꠁꠐꠣ ꠡꠥꠘꠣꠞ ꠇꠠꠣ ꠛꠣꠘꠣꠁꠀ ꠛꠥꠇꠥꠞ ꠃꠙꠞꠞ ꠕꠟꠤꠞ ꠖꠥꠁ ꠇꠥꠘꠣꠔ ꠟꠣꠉꠣꠁꠟꠣ। ꠁ ꠖꠥꠁꠅꠐꠣ ꠄꠚꠞꠘꠞ ꠟꠉꠦ ꠛꠥꠇꠥꠞ ꠕꠟꠤꠞ ꠔꠟꠦ ꠞꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","ꠛꠣꠖꠦ ꠀꠞꠅ ꠖꠥꠁꠐꠣ ꠡꠥꠘꠣꠞ ꠇꠠꠣ ꠛꠣꠘꠣꠁꠀ, ꠄꠚꠞꠘꠞ ꠇꠣꠘ꠆ꠖꠞ ꠙꠐ꠆ꠐꠤꠞ ꠡꠁ ꠔꠟꠦꠖꠤ, ꠙꠦꠐꠞ ꠃꠙꠞꠞ ꠛꠦꠟꠐꠞ ꠃꠙꠞꠞ ꠡꠤꠟꠣꠁꠞ ꠇꠣꠍꠣꠔ ꠟꠣꠉꠣꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","ꠀꠞ ꠛꠥꠇꠥꠞ ꠃꠙꠞꠞ ꠕꠟꠤꠞ ꠔꠟꠞ ꠇꠠꠣꠞ ꠟꠉꠦ ꠙꠦꠐꠞ ꠃꠙꠞꠞ ꠘꠇꠡꠣ ꠇꠞꠣ ꠛꠦꠟꠐꠞ ꠇꠠꠣ ꠛꠣꠘ꠆ꠖꠤꠟꠣ, ꠀꠞ ꠅꠃ ꠕꠟꠤꠄ ꠟꠠꠣ-ꠌꠠꠣ ꠘꠣ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠔꠟꠞ ꠇꠠꠣꠞ ꠟꠉꠦ ꠟꠤꠟꠥꠀ ꠡꠥꠔꠣꠖꠤ ꠛꠣꠘ꠆ꠖꠤ ꠖꠤꠟꠣ, ꠎꠦꠟꠣ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠢꠥꠇꠥꠝ ꠇꠞꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","ꠛꠣꠖꠦ ꠔꠣꠞꠣ ꠄꠚꠞꠘꠞ ꠔꠟꠞ ꠀꠟꠈꠦꠟ꠆ꠟꠣ ꠟꠤꠟꠥꠀ ꠞꠋꠉꠞ ꠡꠥꠔꠣꠖꠤ ꠛꠣꠁꠘ ꠇꠞꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","ꠀꠞ ꠝꠣꠕꠣ ꠢꠣꠞꠣꠁꠛꠣꠞ ꠛꠣꠟꠣ ꠉꠟꠣꠞ ꠚꠣꠇ ꠍꠤꠠꠔ ꠘꠣ ꠇꠞꠤ ꠄꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣ ꠙꠐ꠆ꠐꠤ ꠖꠤꠀ ꠖꠠ ꠇꠞꠤ ꠛꠣꠁꠘ ꠇꠞꠟꠣ, ꠉꠟꠣꠞ ꠅꠃ ꠚꠣꠇ ꠞꠣꠈꠟꠣ ꠝꠣꠎ ꠛꠞꠣꠛꠞ। ");
INSERT INTO syls_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","ꠟꠤꠟꠥꠀ, ꠛꠣꠁꠋꠉꠘꠤ, ꠟꠣꠟ ꠞꠋꠉꠞ ꠙꠦꠌꠣꠁꠟ ꠡꠥꠔꠣꠖꠤ ꠀꠘꠥꠀꠞ ꠚꠟꠞ ꠟꠣꠈꠣꠘ ꠛꠣꠘꠣꠁꠟꠣ। ꠛꠣꠘꠣꠁꠀ ꠅꠉꠥꠁꠘꠞꠦ ꠀꠟꠈꠦꠟ꠆ꠟꠣꠞ ꠔꠟꠞ ꠝꠥꠠꠤꠞ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠟꠣꠉꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","ꠛꠣꠖꠦ ꠈꠣꠐꠤ ꠡꠥꠘꠣꠞ ꠊꠥꠋꠉꠥꠞ ꠛꠣꠘꠣꠁꠀ ꠅꠃ ꠀꠘꠥꠀꠞꠞ ꠚꠣꠇꠦ ꠚꠣꠇꠦ ꠟꠣꠉꠣꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","ꠀꠡ꠆ꠔꠣ ꠔꠟꠞ ꠝꠥꠠꠤꠔ ꠄꠉꠥ ꠇꠞꠤ ꠀꠘꠥꠀꠞ ꠀꠞ ꠄꠉꠥ ꠇꠞꠤ ꠊꠥꠋꠉꠥꠞ ꠟꠣꠉꠣꠁꠟ ꠅꠁꠟ। ꠄꠛꠣꠖꠔꠤ ꠇꠣꠝꠞ ꠛꠣꠟꠣ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠅꠃ ꠀꠟꠈꠦꠟ꠆ꠟꠣ ꠚꠤꠘ꠆ꠖꠤꠔꠣ। ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠄꠇ꠆ꠇꠦꠞꠦ ꠅꠃꠟꠣ ꠇꠞꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","ꠛꠣꠖꠦ ꠔꠣꠞꠣ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠟꠣꠉꠤ ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠡꠥꠔꠣꠖꠤ ꠙꠣꠁꠘ꠆ꠎꠣꠛꠤ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ꠝꠣꠕꠣꠞ ꠙꠣꠃꠉꠠꠤ ꠀꠞ ꠔꠇꠤꠉꠥꠁꠘꠅ ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠꠖꠤ ꠛꠣꠘꠣꠁꠟꠣ, ꠀꠞ ꠢꠣꠚ-ꠙꠦꠘ꠆ꠐꠞ ꠟꠣꠈꠣꠘ ꠎꠣꠋꠉꠤꠀꠅ ꠛꠣꠘꠣꠁꠟꠣ ꠅꠃ ꠇꠣꠙꠠꠖꠤ। ");
INSERT INTO syls_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ꠇꠝꠞꠞ ꠄꠇꠈꠣꠘ ꠛꠘ꠆ꠖꠘꠤ ꠛꠣꠘꠣꠁꠟꠣ, ꠖꠣꠝꠤ ꠡꠥꠔꠤ ꠇꠣꠙꠠ, ꠟꠤꠟꠥꠀ, ꠛꠣꠁꠋꠉꠘꠤ ꠀꠞ ꠟꠣꠟ ꠡꠥꠔꠣꠖꠤ ꠘꠇꠡꠣ ꠇꠞꠤ ꠛꠣꠘꠣꠁꠟꠣ। ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠄꠇ꠆ꠇꠦꠞꠦ ꠅꠃꠟꠣ ꠇꠞꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","ꠀꠞ ꠙꠣꠃꠉꠠꠤꠞ ꠍꠣꠝꠘꠦ ꠟꠣꠉꠣꠘꠤꠞ ꠟꠣꠉꠤ, ꠈꠣꠐꠤ ꠡꠥꠘꠣꠞ ꠙꠣꠔꠖꠤ ꠄꠇꠈꠣꠘ ꠙꠛꠤꠔ꠆ꠞ ꠔꠣꠎ ꠔꠤꠀꠞ ꠇꠞꠟꠣ। ꠡꠤꠟꠞ ꠃꠙꠞꠦ ꠎꠦꠟꠣ ꠈꠥꠖꠤꠀ ꠟꠦꠈꠣ ꠅꠄ, ꠅꠃ ꠙꠣꠔꠞ ꠃꠙꠞꠦ ꠅꠟꠣ ꠈꠥꠖꠤꠀ ꠟꠦꠈꠟꠣ, “ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠙꠛꠤꠔ꠆ꠞ।” ");
INSERT INTO syls_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠅꠃ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇꠃ ꠁ ꠙꠣꠔꠞꠦ ꠟꠤꠟꠥꠀ ꠡꠥꠔꠣꠖꠤ ꠙꠣꠃꠉꠠꠤꠞ ꠍꠣꠝꠘꠦ ꠛꠣꠘ꠆ꠖꠤ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","ꠅꠃ ꠟꠣꠈꠣꠘ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥ ꠡꠢ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠢꠇ꠆ꠇꠟ ꠇꠣꠝ-ꠇꠣꠎ ꠡꠦꠡ ꠅꠁꠟ। ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠄꠇ꠆ꠇꠦꠞꠦ ꠅꠃ ꠟꠣꠈꠣꠘ ꠢꠇꠟꠔꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","ꠛꠣꠖꠦ ꠔꠣꠞꠣ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠟꠣꠉꠤ ꠛꠣꠘꠣꠁꠟ ꠢꠇ꠆ꠇꠟꠔꠣ ꠝꠥꠍꠣꠞ ꠇꠣꠍꠣꠔ ꠟꠁꠀ ꠀꠁꠟꠣ। ꠔꠣꠞꠣ ꠀꠘꠟꠣ: ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥ, ꠔꠣꠝ꠆ꠛꠥꠞ ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ, ꠢꠥꠇ, ꠚ꠆ꠞꠦꠁꠝ, ꠛꠣꠔ꠆ꠔꠤ, ꠈꠥꠐꠤ, ꠈꠥꠐꠤꠞ ꠔꠟꠞ ꠌꠥꠘ꠆ꠉꠤ; ");
INSERT INTO syls_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ꠟꠣꠟ ꠞꠋ ꠇꠞꠣ ꠝꠦꠠꠣꠞ ꠌꠣꠝꠠꠣꠞ ꠍꠣꠘꠤ, ꠚꠥʼꠞ ꠌꠣꠝꠠꠣꠞ ꠍꠣꠘꠤ, ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚꠞ ꠛꠦꠠꠣꠞ ꠙꠞ꠆ꠖꠣ; ");
INSERT INTO syls_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇ, ꠡꠘ꠆ꠖꠥꠇ ꠛꠁꠀ ꠘꠦꠅꠀꠞ ꠛꠦꠘ꠆ꠖꠣ, ꠡꠘ꠆ꠖꠥꠇꠞ ꠓꠣꠇꠘꠣ; ");
INSERT INTO syls_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ꠐꠦꠛꠥꠟ, ꠐꠦꠛꠥꠟꠞ ꠢꠇꠟ ꠌꠤꠎ, ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠞ ꠙꠛꠤꠔ꠆ꠞ ꠞꠥꠐꠤ; ");
INSERT INTO syls_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ꠈꠣꠐꠤ ꠡꠥꠘꠣꠞ ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤ, ꠄꠞ ꠟꠉꠞ ꠢꠇꠟ ꠌꠤꠎ, ꠎꠣꠟꠣꠘꠤꠞ ꠔꠦꠟ; ");
INSERT INTO syls_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ꠡꠥꠘꠣꠞ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠘꠤꠞ ꠐꠦꠛꠥꠟ, ꠈꠦꠟꠣꠚꠔꠤꠞ ꠔꠦꠟ, ꠈꠥꠡꠛꠄ ꠀꠟꠣ ꠀꠉꠞ, ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠖꠥꠀꠞꠞ ꠙꠞ꠆ꠖꠣ; ");
INSERT INTO syls_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ꠙꠤꠔꠟꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ, ꠙꠤꠔꠟꠞ ꠎꠣꠟꠤ, ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠁꠀ ꠘꠦꠅꠀꠞ ꠛꠦꠘ꠆ꠖꠣ, ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠢꠇ꠆ꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ, ꠅꠎꠥꠞ ꠉꠣꠝꠟꠣ ꠀꠞ ꠄꠞ ꠔꠟꠞ ꠌꠇꠤ-ꠈꠣꠐ; ");
INSERT INTO syls_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ꠃꠑꠣꠘꠞ ꠙꠞ꠆ꠖꠣꠁꠘ, ꠈꠥꠐꠤꠘ, ꠈꠥꠐꠤꠞ ꠔꠟꠞ ꠌꠥꠘ꠆ꠉꠤ, ꠃꠑꠣꠘꠅ ꠢꠣꠝꠣꠘꠤꠞ ꠉꠦꠁꠐꠞ ꠙꠞ꠆ꠖꠣ, ꠃꠑꠣꠘꠞ ꠙꠦꠞꠦꠉ ꠀꠞ ꠖꠠꠤ; ꠄꠇ ꠇꠕꠣꠄ, ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥ ꠡꠢ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠢꠇ꠆ꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ; ");
INSERT INTO syls_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ꠀꠞ ꠙꠣꠇ ꠎꠣꠉꠣꠔ ꠁꠝꠣꠝꠔꠤ ꠇꠣꠝꠞ ꠟꠣꠉꠤ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠙꠛꠤꠔ꠆ꠞ ꠟꠦꠛꠣꠍ, ꠀꠞ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠅ ꠁꠝꠣꠝꠔꠤꠞ ꠟꠦꠛꠣꠍ। ");
INSERT INTO syls_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠅꠃ ꠟꠣꠈꠣꠘ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠅꠇꠟꠦ ꠢꠇꠟ ꠇꠣꠝ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","ꠢꠦꠡꠦ ꠝꠥꠍꠣꠄ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠖꠦꠈꠤꠀ ꠛꠥꠎꠟꠣ, ꠝꠣꠛꠥꠖꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠅꠃ ꠟꠣꠈꠣꠘꠃ ꠇꠞꠣ ꠅꠁꠍꠦ। ꠄꠞꠟꠣꠉꠤ ꠔꠣꠁꠘ ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠖꠥꠀ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“ꠔꠥꠝꠤ ꠛꠍꠞꠞ ꠙꠄꠟꠣ ꠌꠣꠘ꠆ꠖꠞ ꠙꠄꠟꠣ ꠔꠣꠞꠤꠈꠅ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥ ꠡꠢ ꠀꠝꠣꠞ ꠊꠞꠞꠦ ꠈꠣꠠꠣ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","ꠊꠞꠞ ꠜꠤꠔꠞꠦ ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇꠞꠦ ꠢꠣꠞꠣꠁꠀ, ꠝꠣꠎꠦ ꠙꠞ꠆ꠖꠣ ꠐꠣꠘꠣꠁꠀ ꠡꠘ꠆ꠖꠥꠇꠞꠦ ꠀꠅꠠꠦ ꠕꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","ꠐꠦꠛꠥꠟꠞꠦꠅ ꠜꠤꠔꠞꠦ ꠢꠣꠞꠣꠁꠀ, ꠄꠞ ꠃꠙꠞꠞ ꠌꠤꠎ ꠅꠇꠟ ꠢꠣꠎꠣꠁꠅ। ꠛꠣꠖꠦ ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤ ꠜꠤꠔꠞꠦ ꠀꠘꠤꠀ ꠔꠣꠞ ꠌꠦꠞꠣꠉ ꠅꠇꠟ ꠎꠣꠟꠣꠁ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","ꠡꠥꠘꠣꠖꠤ ꠛꠣꠘꠣꠁꠟ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠘꠤꠞ ꠐꠦꠛꠥꠟ ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇꠞ ꠍꠣꠝꠘꠦ ꠕꠁꠅ, ꠕꠁꠀ ꠀꠝꠣꠞ ꠊꠞꠞ ꠖꠥꠀꠞꠞ ꠙꠞ꠆ꠖꠣ ꠟꠣꠉꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","ꠀꠝꠣꠞ ꠊꠞꠞ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠍꠣꠝꠘꠦ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠕꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠀꠞ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠝꠣꠎꠈꠣꠘꠅ ꠅꠎꠥꠞ ꠉꠣꠝꠟꠣ ꠙꠣꠘꠤꠖꠤ ꠜꠞꠤꠀ ꠕꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","ꠛꠣꠖꠦ ꠃꠑꠣꠘꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠛꠣꠄ ꠙꠞ꠆ꠖꠣ ꠐꠣꠘꠣꠁꠅ, ꠀꠞ ꠃꠑꠣꠘꠞ ꠉꠦꠁꠐꠅ-ꠅ ꠙꠞ꠆ꠖꠣ ꠟꠣꠉꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“ꠛꠣꠖꠦ ꠔꠥꠝꠤ ꠈꠦꠟꠣꠚꠔꠤꠞ ꠔꠦꠟ ꠖꠤꠀ ꠀꠝꠣꠞ ꠊꠞ ꠀꠞ ꠀꠝꠣꠞ ꠊꠞꠞ ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣꠞꠦ ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠤꠅ। ꠔꠦꠃ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠝꠢꠣ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","ꠀꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦꠅ ꠈꠦꠟꠣꠚꠔꠤꠞ ꠔꠦꠟ ꠖꠤꠀ ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠤꠅ। ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣꠞꠦꠅ ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠤꠅ। ꠔꠦꠃ ꠁ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠝꠢꠣ-ꠙꠛꠤꠔ꠆ꠞ ꠌꠤꠎ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","ꠅꠎꠥꠞ ꠙꠣꠘꠤꠞ ꠉꠣꠝꠟꠣ ꠀꠞ ꠄꠞ ꠔꠟꠞ ꠌꠇꠤ-ꠈꠣꠐꠞꠦꠅ ꠈꠦꠟꠣꠚꠔꠤꠞ ꠔꠦꠟ ꠖꠤꠀ ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“ꠛꠣꠖꠦ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘꠞꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠍꠣꠝꠘꠦ ꠀꠘꠤꠀ ꠙꠣꠘꠤꠖꠤ ꠘꠣꠅꠀꠁ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","ꠘꠣꠅꠀꠘꠤꠞ ꠛꠣꠖꠦ ꠢꠣꠞꠥꠘꠞꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠟꠦꠛꠣꠍ ꠅꠇꠟ ꠚꠤꠘ꠆ꠖꠣꠁꠅ, ꠀꠞ ꠀꠝꠣꠞ ꠁꠝꠣꠝ ꠅꠀꠞ ꠟꠣꠉꠤ ꠔꠣꠞꠦ ꠙꠛꠤꠔ꠆ꠞ ꠔꠦꠟ ꠟꠣꠉꠣꠁꠀ ꠈꠦꠟꠣꠚꠔꠤ ꠖꠤꠀ ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠀꠘꠤꠀ ꠁꠝꠣꠝꠔꠤꠞ ꠙꠣꠁꠘ꠆ꠎꠣꠛꠤ ꠚꠤꠘ꠆ꠖꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ꠔꠣꠞꠣꠞ ꠛꠣꠚꠞꠦ ꠎꠦꠟꠣ ꠙꠛꠤꠔ꠆ꠞ ꠔꠦꠟꠖꠤ ꠁꠝꠣꠝꠔꠤ ꠇꠣꠝꠞ ꠈꠦꠟꠣꠚꠔꠤ ꠖꠤꠍ, ꠔꠣꠞꠣꠞꠦꠅ ꠅꠃꠟꠣ ꠈꠦꠟꠣꠚꠔꠤ ꠖꠤꠅ, ꠎꠣꠔꠦ ꠔꠣꠞꠣꠅ ꠀꠝꠣꠞ ꠁꠝꠣꠝꠔꠤ ꠇꠣꠝ ꠇꠞꠔꠣ ꠙꠣꠞꠂꠘ। ꠁ ꠈꠦꠟꠣꠚꠔꠤꠞ ꠝꠣꠎꠖꠤ ꠁꠝꠣꠝꠔꠤꠞ ꠎꠦ ꠘꠤꠅꠝ ꠌꠣꠟꠥ ꠅꠁꠛ, ꠁꠔꠣ ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠌꠣꠟꠥ ꠞꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠝꠥꠍꠣꠄ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","ꠖꠥꠍꠞꠣ ꠛꠍꠞꠞ ꠙꠄꠟꠣ ꠌꠣꠘ꠆ꠖꠞ ꠙꠄꠟꠣ ꠔꠣꠞꠤꠈꠅ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞ ꠈꠣꠠꠣ ꠇꠞꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","ꠝꠥꠍꠣꠄ ꠁ ꠊꠞ ꠈꠣꠠꠣ ꠇꠞꠟꠣ, ꠙꠄꠟꠣ ꠄꠞ ꠈꠥꠐꠤꠞ ꠔꠟꠞ ꠌꠥꠘ꠆ꠉꠤ ꠛꠅꠀꠁꠟꠣ, ꠈꠥꠐꠤꠘ ꠃꠛꠣ ꠇꠞꠟꠣ, ꠛꠦꠠꠣꠞ ꠚ꠆ꠞꠦꠁꠝ ꠟꠣꠉꠣꠁꠟꠣ, ꠚ꠆ꠞꠦꠁꠝꠞ ꠜꠤꠔꠞꠦꠖꠤ ꠛꠣꠔ꠆ꠔꠤ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠔꠣꠁꠘ ꠍꠣꠉꠟꠞ ꠞꠥꠝꠣ ꠖꠤꠀ ꠊꠞꠞ ꠙꠄꠟꠣ ꠍꠣꠘꠤ ꠖꠤꠟꠣ, ꠄꠞ ꠃꠙꠞꠦ ꠖꠤꠟꠣ ꠀꠞꠅ ꠖꠥꠁꠐꠣ ꠍꠣꠘꠤ। ");
INSERT INTO syls_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","ꠛꠣꠖꠦ ꠢꠃ ꠖꠥꠁꠅꠈꠣꠘ ꠙꠛꠤꠔ꠆ꠞ ꠡꠣꠢꠣꠖꠔ ꠙꠣꠔ꠆ꠔꠞ ꠀꠘꠤꠀ ꠡꠘ꠆ꠖꠥꠇꠞ ꠜꠤꠔꠞꠦ ꠢꠣꠞꠣꠁꠟꠣ। ꠡꠘ꠆ꠖꠥꠇ ꠛꠁꠀ ꠘꠦꠅꠀꠞ ꠛꠦꠘ꠆ꠖꠣ ꠟꠣꠉꠣꠁꠟꠣ, ꠡꠘ꠆ꠖꠥꠇꠞ ꠃꠙꠞꠞ ꠓꠣꠇꠘꠣꠅ ꠟꠣꠉꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","ꠀꠞ ꠡꠘ꠆ꠖꠥꠇꠞꠦ ꠘꠤꠀ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠜꠤꠔꠞꠦ ꠢꠣꠞꠣꠁꠟꠣ। ꠢꠣꠞꠣꠁꠀ ꠙꠞ꠆ꠖꠣ ꠐꠣꠘꠣꠁꠀ ꠡꠘ꠆ꠖꠥꠇꠞꠦ ꠀꠅꠠꠦ ꠞꠣꠈꠟꠣ, ꠎꠦꠟꠣ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","ꠡꠘ꠆ꠖꠥꠇꠞ ꠅꠃ ꠙꠞ꠆ꠖꠣꠞ ꠛꠣꠞꠦ ꠃꠔ꠆ꠔꠞ ꠉꠣꠟꠣꠛꠣꠄ, ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠝꠣꠎꠦ ꠙꠛꠤꠔ꠆ꠞ ꠞꠥꠐꠤꠞ ꠐꠦꠛꠥꠟ ꠞꠣꠈꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","ꠐꠦꠛꠥꠟꠞ ꠃꠙꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠞ ꠙꠛꠤꠔ꠆ꠞ ꠞꠥꠐꠤ ꠢꠣꠎꠣꠁꠀ ꠕꠁꠟꠣ, ꠎꠦꠟꠣ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","ꠐꠦꠛꠥꠟꠞ ꠍꠣꠝꠘꠦ ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠇ꠆ꠇꠤꠘ ꠉꠣꠟꠣꠔ ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤ ꠕꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠌꠦꠞꠣꠉ ꠉꠥꠁꠘ ꠎꠣꠟꠣꠁꠟꠣ, ꠎꠦꠟꠣ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠝꠣꠎꠈꠣꠘꠞ ꠙꠞ꠆ꠖꠣꠞ ꠍꠣꠝꠘꠦ ꠡꠥꠘꠣꠖꠤ ꠛꠣꠘꠣꠁꠟ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠘꠤꠞ ꠐꠦꠛꠥꠟ ꠕꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ꠅꠈꠣꠘꠞ ꠃꠙꠞꠦ ꠈꠥꠡꠛꠄ ꠀꠟꠣ ꠀꠉꠞ ꠎꠣꠟꠣꠁꠟꠣ, ꠎꠦꠟꠣ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","ꠛꠣꠖꠦ ꠝꠥꠍꠣꠄ ꠖꠥꠀꠞꠞ ꠙꠞ꠆ꠖꠣ ꠐꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","ꠔꠣꠁꠘ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠕꠁꠟꠣ। ꠕꠁꠀ ꠄꠞ ꠃꠙꠞꠦ ꠎꠣꠟꠣꠁꠟ ꠙꠡꠥ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠖꠤꠟꠣ, ꠎꠦꠟꠣ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","ꠛꠣꠖꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥ ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠝꠣꠎꠈꠣꠘꠅ ꠅꠎꠥꠞ ꠉꠣꠝꠟꠣ ꠕꠁꠟꠣ, ꠕꠁꠀ ꠅꠎꠥꠞ ꠙꠣꠘꠤ ꠜꠞꠤꠀ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","ꠅꠃ ꠙꠣꠘꠤ ꠖꠤꠀ ꠝꠥꠍꠣ, ꠢꠣꠞꠥꠘ ꠀꠞ ꠢꠣꠞꠥꠘꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠅꠎꠥ ꠇꠞꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠔꠣꠞꠣ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠔ ꠢꠣꠝꠣꠘꠤꠞ ꠀꠉꠦ, ꠛꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠎꠣꠅꠀꠞ ꠀꠉꠦ ꠅꠎꠥ ꠇꠞꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","ꠛꠣꠖꠦ ꠝꠥꠍꠣꠄ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞ ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠙꠞ꠆ꠖꠣ ꠐꠣꠘꠣꠁꠀ ꠃꠑꠣꠘ ꠛꠣꠘꠣꠁꠟꠣ। ꠃꠑꠣꠘꠞ ꠉꠦꠁꠐꠞ ꠙꠞ꠆ꠖꠣ ꠟꠣꠉꠣꠁꠟꠣ। ꠅꠃ ꠟꠣꠈꠣꠘ ꠝꠥꠍꠣꠄ ꠔꠣꠘ ꠢꠇꠟ ꠇꠣꠝ ꠡꠦꠡ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","ꠇꠣꠝ ꠡꠦꠡ ꠇꠞꠤꠀ ꠢꠣꠞꠟꠦ, ꠉꠣꠁꠛꠤ ꠝꠦꠊꠞ ꠈꠥꠐꠤ ꠀꠁꠀ ꠅꠃ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞꠦ ꠉꠥꠞꠤꠟꠤꠟ, ꠝꠣꠛꠥꠖꠞ ꠝꠢꠤꠝꠣ ꠀꠞ ꠇꠥꠖꠞꠔꠦ ꠀꠡ꠆ꠔꠣ ꠊꠞ ꠜꠞꠤꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","ꠄꠞꠟꠣꠉꠤ ꠝꠥꠍꠣ ꠀꠞ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠔ ꠢꠣꠝꠣꠁꠔꠣ ꠙꠣꠞꠟꠣ ꠘꠣ, ꠇꠣꠞꠘ ꠄꠞ ꠃꠙꠞꠦ ꠢꠃ ꠝꠦꠊꠞ ꠈꠥꠐꠤ ꠀꠍꠤꠟ, ꠀꠞ ꠝꠣꠛꠥꠖꠞ ꠇꠥꠖꠞꠔꠤ ꠝꠢꠤꠝꠣꠄ ꠀꠡ꠆ꠔꠣ ꠊꠞ ꠜꠞꠤ ꠉꠦꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠅꠃ ꠀꠡ꠆ꠔꠣ ꠍꠚꠞꠞ ꠝꠣꠎꠦ, ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠃꠙꠞꠦ ꠕꠣꠇꠤ ꠝꠦꠊꠞ ꠈꠥꠐꠤ ꠢꠞꠤꠀ ꠢꠣꠞꠟꠦ ꠔꠣꠞꠣ ꠀꠐꠤꠀ ꠞꠅꠀꠘꠣ ꠖꠤꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ꠅꠁꠟꠦ ꠝꠦꠊꠞ ꠈꠥꠐꠤ ꠃꠙꠞꠦ ꠕꠣꠇꠤ ꠘꠣ ꠢꠞꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠔꠣꠞꠣ ꠛꠣꠞ ꠅꠁꠔꠣ ꠘꠣ, ꠅꠃ ꠈꠥꠐꠤ ꠢꠞꠣꠞ ꠟꠣꠉꠤ ꠛꠣꠞ ꠌꠣꠁꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","ꠇꠣꠞꠘ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠅꠃ ꠀꠡ꠆ꠔꠣ ꠍꠚꠞꠞ ꠝꠣꠎꠦꠃ, ꠖꠤꠘꠞ ꠛꠣꠟꠣ ꠔꠣꠞꠣꠞ ꠌꠈꠥꠞ ꠍꠣꠝꠘꠦ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠃꠙꠞꠦ ꠝꠦꠊꠞ ꠈꠥꠐꠤ ꠞꠁꠔ, ꠀꠞ ꠞꠣꠁꠔꠞ ꠛꠣꠟꠣ ꠞꠁꠔ ꠀꠉꠥꠁꠘꠞ ꠈꠥꠐꠤ॥");
INSERT INTO syls_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","ꠅꠃ ꠙꠛꠤꠔ꠆ꠞ ꠇꠣꠛꠣ ꠊꠞ ꠝꠣꠘꠤ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥ ꠛꠣꠘꠣꠘꠤꠞ ꠛꠣꠖꠦ, ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠅꠘꠅ ꠀꠘꠣꠁꠀ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“ꠔꠥꠝꠤ ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠇꠦꠃ ꠎꠥꠖꠤ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠇꠥꠘꠥ ꠙꠡꠥ ꠖꠤꠔ ꠌꠣꠄ, ꠔꠦ ꠉꠞꠥ ꠛꠣ ꠍꠣꠉꠟ-ꠝꠦꠠꠣꠞ ꠙꠣꠟ ꠕꠣꠇꠤ ꠙꠡꠥ ꠀꠘꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠟꠣꠃꠇ। ");
INSERT INTO syls_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅꠞꠣꠄ ꠎꠥꠖꠤ ꠉꠞꠥꠞ ꠙꠣꠟ ꠕꠣꠇꠤ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠔ ꠌꠣꠄ, ꠔꠦ ꠙꠥꠞꠣꠙꠥꠞ ꠘꠤꠈꠥꠔ ꠄꠉꠥ ꠛꠤꠍꠣꠟ ꠀꠘꠔꠦ ꠅꠁꠛ। ꠀꠘꠤꠀ ꠝꠣꠛꠥꠖꠞꠦ ꠈꠥꠡꠤ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠅꠃ ꠛꠤꠍꠣꠟꠞꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠉꠦꠍꠦ ꠟꠁꠀ ꠀꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","ꠀꠁꠀ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠘꠤꠅꠔꠦ ꠀꠘꠣ ꠅꠃ ꠛꠤꠍꠣꠟꠞ ꠇꠟ꠆ꠟꠣꠞ ꠃꠙꠞꠦ ꠀꠔ ꠕꠁꠛ, ꠔꠦꠃ ꠔꠣꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣ ꠢꠤꠡꠣꠛꠦ ꠁꠐꠣꠞꠦ ꠇꠛꠥꠟ ꠇꠞꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠅꠃ ꠛꠤꠍꠣꠟꠞꠦ ꠢꠦ ꠎꠛ ꠇꠞꠛ। ꠀꠞ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠎꠦ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠁꠝꠣꠝꠔꠤ ꠇꠞꠂꠘ, ꠔꠣꠞꠣ ꠅꠃ ꠛꠤꠍꠣꠟꠞ ꠟꠃ ꠘꠤꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠍꠣꠝꠘꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠔ ꠍꠤꠐꠣꠁ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","ꠛꠣꠖꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅꠞꠣꠄ ꠅꠃ ꠛꠤꠍꠣꠟꠞ ꠈꠣꠟ ꠈꠣꠟꠤꠀ ꠢꠣꠞꠤ, ꠅꠉꠥꠞ ꠉꠥꠡ꠆ꠔ ꠐꠥꠇꠞꠣ ꠐꠥꠇꠞꠣ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","ꠀꠞ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠎꠣꠟꠣꠁꠟ ꠀꠋꠞꠣ ꠕꠁꠛꠣ, ꠄꠞ ꠃꠙꠞꠦ ꠖꠣꠞꠥ ꠢꠣꠎꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","ꠢꠣꠎꠣꠁꠀ ꠅꠃ ꠖꠣꠞꠥꠞ ꠃꠙꠞꠦ ꠛꠤꠍꠣꠟꠞ ꠇꠟ꠆ꠟꠣ, ꠌꠞ꠆ꠛꠤ, ꠉꠥꠡ꠆ꠔꠞ ꠐꠥꠇꠞꠣꠁꠘ ꠕꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅꠞꠣꠄ ꠉꠞꠥꠞ ꠑꠦꠋ ꠀꠞ ꠙꠦꠐꠞ ꠜꠤꠔꠞꠞ ꠢꠇ꠆ꠇꠟꠔꠣ ꠙꠣꠘꠤ ꠖꠤꠀ ꠗꠁꠀ ꠍꠣꠚ ꠇꠞꠤꠀ ꠖꠤꠛꠣ, ꠀꠞ ꠁꠝꠣꠝꠦ ꠅꠔꠣ ꠘꠤꠀ ꠀꠡ꠆ꠔꠣ ꠛꠤꠍꠣꠟꠞ ꠢꠇ꠆ꠇꠟꠔꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠎꠣꠟꠣꠁꠟꠤꠛꠣ। ꠁꠐꠣꠞ ꠘꠣꠝ ꠅꠁꠟ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ, ꠅꠃ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠔꠣꠁꠘ ꠈꠥꠡꠤ ꠅꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ꠀꠞ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠍꠣꠉꠟ-ꠝꠦꠠꠣꠞ ꠙꠣꠟ ꠕꠣꠇꠤ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠈꠤꠀꠟꠤ ꠅꠄ, ꠔꠦ ꠁꠇꠐꠣ ꠙꠥꠞꠣꠙꠥꠞ ꠘꠤꠈꠥꠔ ꠄꠉꠥ ꠙꠣꠑꠣ ꠅꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅꠞꠣꠄ ꠁꠇꠐꠣꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠔ꠆ꠔꠞ ꠉꠣꠟꠣꠔ ꠘꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠎꠛ ꠇꠞꠤꠀ ꠢꠣꠞꠟꠦ, ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠎꠦ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠁꠝꠣꠝꠔꠤ ꠇꠞꠂꠘ, ꠔꠣꠞꠣ ꠅꠉꠥꠞ ꠟꠃ ꠘꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠔ ꠍꠤꠐꠣꠁ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","ꠛꠣꠖꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅꠞꠣꠄ ꠁꠐꠣꠞ ꠉꠥꠡ꠆ꠔ ꠐꠥꠇꠞꠣ ꠐꠥꠇꠞꠣ ꠇꠞꠤ ꠇꠣꠐꠤꠀ ꠖꠤꠟꠦ, ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠅꠉꠥꠞ ꠌꠞ꠆ꠛꠤ, ꠇꠟ꠆ꠟꠣ ꠀꠞ ꠉꠥꠡ꠆ꠔꠞ ꠐꠥꠇꠞꠣꠁꠘ ꠘꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠎꠣꠟꠣꠁꠟ ꠀꠋꠞꠣꠞ ꠃꠙꠞꠞ ꠖꠣꠞꠥꠞ ꠃꠙꠞꠦ ꠢꠣꠎꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅꠞꠣꠄ ꠁꠐꠣꠞ ꠑꠦꠋ, ꠙꠦꠐꠞ ꠜꠤꠔꠞꠞ ꠢꠇ꠆ꠇꠟꠔꠣ ꠙꠣꠘꠤ ꠖꠤꠀ ꠗꠁꠀ ꠍꠣꠚ ꠇꠞꠤꠀ ꠖꠤꠛꠣ, ꠀꠞ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠁꠔꠣ ꠢꠇ꠆ꠇꠟꠔꠣ ꠡꠝꠦꠔ ꠀꠡ꠆ꠔꠣ ꠙꠡꠥꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠎꠣꠟꠣꠁꠟꠤꠛꠣ। ꠁꠐꠣ ꠅꠁꠟ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠊꠦꠞꠣꠘ ꠀꠟꠣ ꠇꠥꠞꠛꠣꠘꠤ, ꠅꠃ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠔꠣꠁꠘ ꠈꠥꠡꠤ ꠅꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ꠀꠞ ꠇꠥꠘꠥ ꠙꠣꠈꠤ ꠖꠤꠀ ꠎꠥꠖꠤ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠞ ꠅꠃ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠈꠤꠀꠟ ꠅꠄ, ꠔꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅꠞꠣꠄ ꠒꠥꠙꠤ ꠙꠣꠈꠤ ꠛꠣ ꠙꠣꠞꠅ ꠟꠁꠀ ꠀꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","ꠀꠁꠟꠦ, ꠁꠝꠣꠝꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠗꠣꠞꠅ ꠉꠤꠀ ꠅꠃ ꠙꠣꠈꠤꠞ ꠇꠟ꠆ꠟꠣ ꠝꠥꠞꠣ ꠝꠣꠞꠤꠀ ꠍꠤꠠꠤꠀ ꠀꠟꠉꠣꠁꠀ ꠢꠣꠞꠤ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠅꠃ ꠇꠟ꠆ꠟꠣꠞꠦ ꠎꠣꠟꠣꠁꠟꠤꠛꠣ, ꠀꠞ ꠅꠉꠥꠞ ꠟꠃ ꠘꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠄꠇ ꠉꠣꠟꠣꠔ ꠍꠤꠐꠣꠁ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","ꠁꠝꠣꠝꠦ ꠙꠣꠈꠤꠞ ꠜꠤꠔꠞꠞ ꠉꠤꠟꠣ-ꠕꠟꠤ ꠀꠞ ꠚꠁꠞ ꠘꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠙꠥꠛ ꠉꠣꠟꠣꠞ ꠍꠣꠟꠤꠞ ꠐꠦꠇꠤꠞ ꠝꠣꠎꠦ ꠚꠣꠟꠣꠁ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","ꠀꠞ ꠅꠉꠥꠞ ꠒꠣꠈꠘꠣꠔ ꠗꠞꠤꠀ ꠅꠟꠣ ꠛꠣꠐꠦ ꠍꠤꠠꠤꠛꠣ, ꠎꠣꠔꠦ ꠁꠐꠣꠞ ꠖꠥꠁ ꠐꠥꠇꠞꠣ ꠙꠥꠞꠣꠙꠥꠞ ꠀꠟꠉ ꠘꠣ ꠅꠄ। ꠛꠣꠖꠦ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠁꠐꠣ ꠘꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠎꠣꠟꠣꠁꠟ ꠀꠋꠞꠣꠞ ꠃꠙꠞꠞ ꠖꠣꠞꠥꠞ ꠃꠙꠞꠦ ꠕꠁꠀ ꠎꠣꠟꠣꠁꠟꠤꠛꠣ। ꠁꠐꠣꠅ ꠅꠁꠟ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠊꠦꠞꠣꠘ ꠀꠟꠣ ꠇꠥꠞꠛꠣꠘꠤ, ꠅꠃ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠔꠣꠁꠘ ꠈꠥꠡꠤ ꠅꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠗꠣꠘ-ꠉꠝ ꠖꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠟꠤꠟ꠆ꠟꠣ-ꠍꠖꠉꠣ ꠖꠤꠔ ꠌꠣꠄ, ꠔꠦ ꠘꠤꠞꠦꠇ ꠝꠄꠖꠣ ꠖꠤꠀ ꠀꠖꠣꠄ ꠇꠞꠛ। ꠅꠃ ꠝꠄꠖꠣꠞ ꠃꠙꠞꠦ ꠢꠦ ꠎꠄꠔꠥꠘꠞ ꠔꠦꠟ ꠀꠞ ꠟꠥꠛꠣꠘ-ꠀꠉꠞꠞ ꠗꠥꠘꠣ ꠖꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ꠖꠤꠀ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠎꠦ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠁꠝꠣꠝꠔꠤ ꠇꠞꠂꠘ ꠔꠣꠞꠣꠞ ꠉꠦꠍꠦ ꠅꠔꠣ ꠟꠁꠀ ꠀꠁꠛ। ꠁꠝꠣꠝꠦ ꠅꠔꠣ ꠕꠣꠇꠤ ꠔꠦꠟ ꠝꠤꠡꠣꠁꠟ ꠄꠇ ꠝꠥꠁꠐ ꠝꠄꠖꠣ ꠀꠞ ꠢꠇꠟ ꠀꠉꠞ ꠟꠁꠀ, ꠔꠣꠞ ꠀꠘꠣ ꠢꠇ꠆ꠇꠟꠔꠣꠞ ꠛꠖꠟꠣ ꠘꠤꠡꠣꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠅꠃ ꠅꠋꠡꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠎꠣꠟꠣꠁꠟꠤꠛꠣ। ꠁꠔꠣ ꠅꠁꠟ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ, ꠁꠔꠣꠞ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠔꠣꠁꠘ ꠈꠥꠡꠤ ꠅꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","ꠎꠣꠟꠣꠘꠤꠞ ꠛꠣꠖꠦ ꠎꠔꠈꠣꠘ ꠛꠣꠇꠤ ꠞꠁꠛ, ꠁꠔꠣ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠙꠣꠁꠛꠣ। ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠞ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠅꠋꠡ ꠅꠀꠄ, ꠛꠣꠌꠤ ꠎꠣꠅꠀ ꠅꠃ ꠝꠄꠖꠣ ꠔ ꠈꠣꠍ ꠙꠛꠤꠔ꠆ꠞ ꠎꠤꠘꠤꠡ। ");
INSERT INTO syls_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ꠀꠞ ꠇꠦꠃ ꠎꠥꠖꠤ ꠔꠥꠘ꠆ꠖꠥꠞꠤ ꠃꠘ꠆ꠖꠣꠟꠅ ꠢꠦꠖꠤꠀ ꠀꠘꠣ ꠇꠥꠘꠥ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠀꠖꠣꠄ ꠇꠞꠔ ꠌꠣꠄ, ꠔꠦ ꠔꠦꠟ ꠝꠤꠡꠣꠁꠟ ꠘꠤꠞꠦꠇ ꠝꠄꠖꠣ ꠖꠤꠀ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠞꠥꠐꠤ ꠛꠣ ꠛꠣꠘꠣꠁꠟ ꠞꠥꠐꠤꠔ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠀ ꠟꠁꠀ ꠀꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","ꠀꠞ ꠅꠃ ꠍꠖꠉꠣꠞ ꠞꠥꠐꠤ ꠎꠥꠖꠤ ꠔꠣꠅꠀꠔ ꠢꠦꠖꠤꠀ ꠀꠘꠣ ꠅꠄ, ꠔꠦ ꠁꠔꠣ ꠔꠦꠟ ꠝꠤꠡꠣꠁꠟ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠘꠤꠞꠦꠇ ꠝꠄꠖꠣ ꠖꠤꠀ ꠛꠣꠘꠣꠁꠀ ꠀꠘꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","ꠀꠘꠤꠀ ꠁꠔꠣ ꠐꠥꠇꠞꠣ ꠐꠥꠇꠞꠣ ꠇꠞꠤꠀ ꠄꠞ ꠃꠙꠞꠦ ꠔꠦꠟ ꠓꠣꠟꠤꠀ ꠖꠤꠔꠦ ꠅꠁꠛ, ꠁꠔꠣꠅ ꠗꠣꠘ-ꠉꠝꠞ ꠄꠇ ꠘꠝꠥꠘꠣꠞ ꠍꠖꠉꠣ। ");
INSERT INTO syls_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","ꠀꠞ ꠅꠃ ꠍꠖꠉꠣꠞ ꠞꠥꠐꠤ ꠎꠥꠖꠤ ꠟꠥꠀꠠꠤꠞ ꠝꠣꠎꠦ ꠜꠣꠎꠤꠀ ꠀꠘꠣ ꠅꠄ, ꠔꠦ ꠁꠔꠣꠅ ꠔꠦꠟ ꠀꠞ ꠘꠤꠞꠦꠇ ꠝꠄꠖꠣ ꠖꠤꠀ ꠛꠣꠘꠣꠁꠀ ꠀꠘꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","ꠅꠟꠣ ꠎꠦꠇꠥꠘꠥ ꠘꠝꠥꠘꠣꠄ ꠛꠣꠘꠣꠁꠟ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠘꠤꠀ ꠁꠝꠣꠝꠞ ꠀꠔꠅ ꠡꠝꠎꠣꠁ ꠖꠤꠛꠣꠄ, ꠁꠝꠣꠝꠦ ꠁꠔꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠉꠦꠍꠦ ꠘꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","ꠘꠤꠀ ꠔꠣꠞ ꠀꠘꠣ ꠅꠃ ꠢꠇ꠆ꠇꠟꠔꠣꠞ ꠛꠖꠟꠣ ꠘꠤꠡꠣꠘꠣ ꠢꠤꠡꠣꠛꠦ, ꠁꠝꠣꠝꠦ ꠅꠈꠣꠘ ꠕꠣꠇꠤ ꠇꠤꠍꠥ ꠅꠋꠡ ꠀꠟꠉꠣꠁꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠎꠣꠟꠣꠁꠟꠤꠛꠣ। ꠁꠔꠣ ꠅꠁꠟ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ, ꠄꠞ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠝꠣꠛꠥꠖ ꠈꠥꠡꠤ ꠅꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","ꠅꠃ ꠅꠋꠡ ꠎꠣꠟꠣꠁꠀ ꠢꠣꠞꠟꠦ ꠛꠣꠖ-ꠛꠣꠇꠤ ꠎꠦꠔꠣ ꠞꠁꠛ, ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠙꠣꠁꠛꠣ। ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠅꠋꠡ ꠅꠀꠄ, ꠛꠣꠌꠤ ꠎꠣꠅꠀ ꠅꠃ ꠍꠖꠉꠣꠞ ꠞꠥꠐꠤ ꠔ ꠈꠣꠍ ꠙꠛꠤꠔ꠆ꠞ ꠎꠤꠘꠤꠡ। ");
INSERT INTO syls_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ꠀꠞ ꠢꠥꠘꠅ, ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠘꠤꠅꠔꠦ ꠎꠔꠔꠣ ꠀꠘꠣ ꠅꠁꠛ, ꠁꠔꠣ ꠢꠇꠟꠔꠣꠃ ꠎꠣꠘꠥ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠔꠤꠀꠞ ꠇꠞꠣ ꠅꠄ। ꠢꠥꠡꠤꠀꠞ ꠞꠁꠅ, ꠔꠥꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠞ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠟꠤꠟ꠆ꠟꠣ-ꠍꠖꠉꠣꠞ ꠝꠣꠟꠞ ꠟꠉꠦ ꠇꠥꠘꠥ ꠈꠣꠝꠤꠞ ꠛꠣ ꠝꠃ ꠎꠣꠟꠣꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","ꠔꠣ-ꠅ ꠈꠦꠔꠞ ꠙꠄꠟꠣ ꠚꠄ-ꠚꠡꠟꠞ ꠍꠖꠉꠣꠞ ꠟꠉꠦ ꠔꠥꠝꠞꠣ ꠝꠃ ꠛꠣ ꠈꠣꠝꠤꠞ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠖꠤꠔꠣꠄ ꠙꠣꠞꠛꠣꠄ, ꠅꠁꠟꠦ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘ ꠀꠟꠣ ꠍꠖꠉꠣꠞ ꠘꠤꠅꠔꠦ ꠈꠣꠝꠤꠞ ꠛꠣ ꠝꠃ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠔ ꠎꠣꠟꠣꠁꠟ ꠎꠣꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","ꠈꠤꠀꠟ ꠞꠣꠈꠤꠅ, ꠔꠥꠝꠞꠣ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠘꠤꠅꠔꠦ ꠎꠔꠔꠣ ꠛꠣꠘꠣꠁꠀ ꠀꠘꠛꠣꠄ, ꠁꠔꠣ ꠢꠇ꠆ꠇꠟꠔꠣꠞ ꠝꠣꠎꠦ ꠘꠥꠘ ꠝꠤꠡꠣꠁꠛꠣꠄ। ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠀꠟ꠆ꠟꠣꠞ ꠅꠀꠖꠣ-ꠌꠥꠇ꠆ꠔꠤꠞꠦ ꠝꠘꠅ ꠞꠣꠈꠤꠀ, ꠔꠥꠝꠞꠣ ꠢꠇꠟ ꠘꠝꠥꠘꠣꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠔ ꠘꠥꠘ ꠖꠤꠔꠦ ꠚꠣꠃꠞꠤꠅ ꠘꠣ। ꠔꠥꠝꠞꠣꠞ ꠢꠇ꠆ꠇꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠝꠣꠎꠦ ꠘꠥꠘ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ꠔꠥꠝꠞꠣꠞ ꠈꠦꠔꠞ ꠙꠄꠟꠣ ꠖꠣꠅꠀ ꠗꠣꠘ-ꠉꠝꠞ ꠇꠥꠘꠥ ꠚꠡꠟ ꠎꠥꠖꠤ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠟꠤꠟ꠆ꠟꠣ-ꠍꠖꠉꠣ ꠢꠤꠡꠣꠛꠦ ꠟꠁꠀ ꠀꠅ, ꠔꠦ ꠁꠔꠣ ꠝꠣꠠꠣ ꠖꠦꠅꠀ ꠇꠣꠌꠣ ꠘꠄꠀ ꠗꠣꠘ-ꠉꠝ ꠛꠣ ꠀꠡ꠆ꠔꠣ ꠍꠠꠣꠞꠦ ꠀꠉꠥꠁꠘꠖꠤ ꠢꠦꠖꠤꠀ ꠀꠘꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","ꠁꠔꠣꠞ ꠃꠙꠞꠦ ꠔꠦꠟ ꠀꠞ ꠟꠥꠛꠣꠘ-ꠀꠉꠞ ꠖꠤꠛꠣꠄ, ꠁꠔꠣ ꠅꠁꠟ ꠄꠇ ꠘꠝꠥꠘꠣꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ। ");
INSERT INTO syls_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","ꠅꠃ ꠍꠖꠉꠣ ꠟꠁꠀ ꠀꠁꠟꠦ, ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠘꠤꠡꠣꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠅꠃ ꠎꠘꠞ ꠀꠘꠣ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠇꠤꠍꠥ ꠅꠋꠡ, ꠇꠤꠍꠥ ꠔꠦꠟ ꠀꠞ ꠢꠇꠟ ꠀꠉꠞ ꠘꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠔ ꠎꠣꠟꠣꠁꠟꠤꠛꠣ, ꠁꠔꠣ ꠅꠁꠟ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ। ");
INSERT INTO syls_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠘꠤꠎꠞ ꠈꠥꠡꠤꠄ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠇꠥꠘꠥ ꠉꠣꠁ ꠛꠣ ꠛꠤꠍꠣꠟꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠔ ꠌꠣꠄ, ꠔꠦ ꠁ ꠉꠞꠥ ꠙꠥꠞꠣꠙꠥꠞ ꠘꠤꠈꠥꠔ ꠅꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅꠞꠣꠄ ꠅꠃ ꠙꠡꠥꠞ ꠇꠟ꠆ꠟꠣ ꠀꠔꠣꠁꠀ ꠖꠤꠀ, ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠍꠣꠝꠘꠦ ꠁꠐꠣꠞꠦ ꠎꠛ ꠇꠞꠛ। ꠛꠣꠖꠦ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠝꠣꠎꠞ ꠁꠝꠣꠝ ꠅꠇꠟꠦ ꠅꠉꠥꠞ ꠟꠃ ꠘꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠔ ꠍꠤꠐꠣꠁ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅꠞꠣꠄ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠘꠣ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠞ ꠅꠃ ꠅꠋꠡ ꠅꠇꠟ ꠖꠤꠛꠣ। ꠅꠉꠥꠞ ꠙꠦꠐꠞ ꠜꠤꠔꠞꠞ ꠢꠇ꠆ꠇꠟꠔꠣꠞ ꠃꠙꠞꠞ ꠌꠞ꠆ꠛꠤ, ");
INSERT INTO syls_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ꠖꠥꠁꠅ ꠇꠤꠒꠘꠤ ꠀꠞ ꠅꠔꠣꠞ ꠌꠞ꠆ꠛꠤ, ꠇꠁꠟꠎꠣꠞ ꠟꠉꠞ ꠝꠣꠐꠤꠀ, ꠅꠃ ꠢꠇꠟꠔꠣ ꠀꠘꠤꠀ ꠁꠝꠣꠝꠞ ꠉꠦꠍꠦ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","ꠛꠣꠖꠦ ꠢꠣꠞꠥꠘꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠢꠣꠎꠣꠁꠟ ꠖꠣꠞꠥ ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠞ ꠃꠙꠞꠦ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠞꠣꠈꠤꠀ ꠄꠇꠟꠉꠦ ꠎꠣꠟꠣꠁꠟꠤꠛꠣ। ꠁꠔꠣ ꠔ ꠄꠇ ꠘꠝꠥꠘꠣꠞ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ, ꠁꠔꠣꠞ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠝꠣꠛꠥꠖ ꠈꠥꠡꠤ ꠅꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠍꠣꠉꠟ-ꠝꠦꠠꠣꠞ ꠙꠣꠟ ꠕꠣꠇꠤ ꠇꠥꠘꠥ ꠙꠡꠥꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠞ ꠘꠤꠅꠔ ꠇꠞꠦ, ꠔꠦ ꠁ ꠙꠡꠥ ꠝꠦꠖꠣ ꠛꠣ ꠝꠦꠖꠤ ꠅꠁꠟꠦꠅ ꠌꠟꠛ, ꠅꠁꠟꠦ ꠁꠐꠣ ꠙꠥꠞꠣꠙꠥꠞ ꠘꠤꠈꠥꠔ ꠅꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠞ ꠘꠤꠅꠔꠦ ꠎꠥꠖꠤ ꠝꠦꠠꠣ ꠀꠘꠦ, ꠔꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠁꠐꠣ ꠀꠎꠤꠞ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅꠞꠣꠄ ꠅꠃ ꠝꠦꠠꠣꠞ ꠇꠟ꠆ꠟꠣ ꠀꠔꠣꠁ ꠖꠤꠀ, ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠍꠣꠝꠘꠦ ꠁꠐꠣꠞꠦ ꠎꠛ ꠇꠞꠛ। ꠛꠣꠖꠦ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠝꠣꠎꠞ ꠁꠝꠣꠝ ꠅꠇꠟꠦ ꠅꠉꠥꠞ ꠟꠃ ꠘꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠔ ꠍꠤꠐꠣꠁ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅꠞꠣꠄ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠀꠘꠣ, ꠅꠃ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠝꠦꠠꠣꠞ ꠢꠇꠟ ꠌꠞ꠆ꠛꠤ ꠁꠝꠣꠝꠞ ꠉꠦꠍꠦ ꠖꠤꠛꠣ। ꠔꠣꠁꠘ ꠌꠞ꠆ꠛꠤ ꠀꠟꠣ ꠟꠦꠋꠉꠥꠠ, ꠙꠦꠐꠞ ꠜꠤꠔꠞꠞ ꠢꠇꠟꠔꠣꠞ ꠃꠙꠞꠞ ꠌꠞ꠆ꠛꠤ, ꠁꠔꠣꠞ ꠟꠉꠦ ꠟꠣꠉꠣꠁꠟ ꠌꠞ꠆ꠛꠤ, ");
INSERT INTO syls_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ꠖꠥꠁꠅ ꠇꠤꠒꠘꠤ ꠀꠞ ꠅꠔꠣꠞ ꠢꠇꠟ ꠌꠞ꠆ꠛꠤ, ꠇꠁꠟꠎꠣꠞ ꠟꠉꠞ ꠝꠣꠐꠤꠀ, ꠅꠔꠣ ꠢꠇꠟꠔꠣ ꠀꠘꠤꠀ ꠁꠝꠣꠝ ꠍꠣꠛꠞ ꠉꠦꠍꠦ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","ꠁꠝꠣꠝꠦ ꠁꠔꠣ ꠘꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠀꠉꠥꠘꠤꠞ ꠃꠙꠞꠦ ꠎꠣꠟꠣꠁꠟꠤꠛꠣ, ꠁꠔꠣ ꠅꠁꠟ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠈꠣꠘꠤ। ");
INSERT INTO syls_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠞ ꠘꠤꠅꠔꠦ ꠢꠦ ꠎꠥꠖꠤ ꠍꠣꠉꠟ ꠀꠘꠦ, ꠔꠦ ꠢꠦ ꠁꠐꠣꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠀꠎꠤꠞ ꠇꠞꠛ। ");
INSERT INTO syls_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ꠢꠦ ꠅꠉꠥꠞ ꠇꠟ꠆ꠟꠣ ꠀꠔꠣꠁ ꠖꠤꠀ, ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠍꠣꠝꠘꠦ ꠁꠐꠣꠞꠦ ꠎꠛ ꠇꠞꠛ, ꠛꠣꠖꠦ ꠢꠣꠞꠥꠘꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠅꠉꠥꠞ ꠟꠃ ꠘꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠔ ꠍꠤꠐꠣꠁ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅꠞꠣꠄ ꠙꠡꠥꠞ ꠅꠃ ꠅꠋꠡ ꠅꠇꠟ ꠘꠤꠀ, ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠁꠝꠣꠝꠞ ꠉꠦꠍꠦ ꠖꠤꠛ। ꠢꠦ ꠙꠡꠥꠞ ꠙꠦꠐꠞ ꠜꠤꠔꠞꠞ ꠢꠇꠟꠔꠣꠞ ꠃꠙꠞꠞ ꠌꠞ꠆ꠛꠤ, ꠁꠔꠣꠞ ꠟꠉꠦ ꠟꠣꠉꠣꠁꠟ ꠌꠞ꠆ꠛꠤ, ");
INSERT INTO syls_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ꠖꠥꠁꠅ ꠇꠤꠒꠘꠤ ꠀꠞ ꠅꠔꠣꠞ ꠃꠙꠞꠞ ꠌꠞ꠆ꠛꠤ, ꠇꠁꠟꠎꠣꠞ ꠟꠉꠞ ꠝꠣꠐꠤꠀ, ꠅꠔꠣ ꠢꠇꠟꠔꠣ ꠀꠘꠤꠀ ꠁꠝꠣꠝꠞ ꠉꠦꠍꠦ ꠖꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","ꠁꠝꠣꠝꠦ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠘꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠎꠣꠟꠣꠁꠟꠤꠛꠣ, ꠁꠔꠣ ꠔ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠈꠣꠘꠤ, ꠁꠔꠣꠞ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠝꠣꠛꠥꠖ ꠈꠥꠡꠤ ꠅꠁꠘ। “ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠞ ꠢꠇ꠆ꠇꠟ ꠌꠞ꠆ꠛꠤ ꠅꠁꠟ ꠝꠣꠛꠥꠖꠞ। ");
INSERT INTO syls_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","ꠔꠥꠝꠞꠣ ꠛꠋꠡꠞ ꠙꠞ ꠛꠋꠡ ꠗꠞꠤꠀ ꠅꠃ ꠘꠤꠅꠝ ꠝꠣꠘꠤꠅ, ꠎꠦꠇꠥꠘꠥ ꠎꠣꠉꠣꠔ ꠛꠡꠔ ꠇꠞꠅ ꠘꠣ ꠇꠦꠘꠦ ꠇꠥꠘꠥꠖꠤꠘ ꠌꠞ꠆ꠛꠤ ꠛꠣ ꠟꠃ ꠈꠣꠁꠅ ꠘꠣ, ꠁꠔꠣ ꠢꠣꠞꠣꠝ।” ");
INSERT INTO syls_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠅ, ꠘꠣ ꠎꠣꠘꠣꠞ ꠇꠣꠞꠘꠦ ꠇꠦꠃ ꠎꠥꠖꠤ ꠜꠥꠟ ꠇꠞꠤꠀ ꠀꠟ꠆ꠟꠣꠞ ꠘꠤꠡꠦꠗ ꠇꠞꠣ ꠇꠥꠘꠥ ꠉꠥꠘꠣꠞ ꠇꠣꠝ ꠇꠞꠤꠟꠣꠄ, ꠔꠦ ꠔꠣꠁꠘ ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ꠄꠁꠘ ꠈꠦꠟꠣꠚꠔꠤ ꠙꠣꠅꠀ ꠙꠞꠗꠣꠘ ꠁꠝꠣꠝ ꠍꠣꠛ ꠅꠁꠟꠦ, ꠔꠣꠘ ꠉꠥꠘꠣꠞ ꠖꠣꠄ-ꠜꠣꠞ ꠢꠇꠟ ꠝꠣꠘꠡꠞ ꠃꠙꠞꠦ ꠛꠞ꠆ꠔꠦ, ꠄꠞꠟꠣꠉꠤ ꠔꠣꠁꠘ ꠘꠤꠈꠥꠔ ꠄꠉꠥ ꠛꠤꠍꠣꠟ ꠀꠘꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠔꠣꠘ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","ꠅꠃ ꠛꠤꠍꠣꠟ ꠟꠁꠀ ꠔꠣꠁꠘ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠉꠦꠍꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠀꠁꠛꠣ, ꠀꠁꠀ ꠅꠉꠥꠞ ꠇꠟ꠆ꠟꠣ ꠀꠔꠣꠁ ꠖꠤꠀ, ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠎꠛ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","ꠇꠞꠤꠀ ꠅꠃ ꠛꠤꠍꠣꠟꠞ ꠕꠥꠠꠣ ꠟꠃ ꠘꠤꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠜꠤꠔꠞꠦ ꠎꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","ꠉꠤꠀ ꠟꠃꠞ ꠝꠣꠎꠦ ꠘꠤꠎꠞ ꠀꠋꠉꠥꠟ ꠍꠥꠛꠣꠁꠀ ꠟꠃ ꠟꠣꠉꠣꠁꠀ ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚꠞ ꠙꠞ꠆ꠖꠣꠞ ꠛꠣꠄ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠡꠣꠔ ꠛꠣꠞ ꠍꠤꠐꠣꠁ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","ꠛꠣꠖꠦ ꠀꠞꠅ ꠕꠥꠠꠣ ꠟꠃ ꠟꠁꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠝꠣꠎꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠘꠤꠞ ꠐꠦꠛꠥꠟꠞ ꠌꠣꠁꠞꠅ ꠇꠥꠘꠣꠞ ꠢꠤꠋ ꠅꠇꠟꠞ ꠝꠣꠎꠦ ꠟꠣꠉꠣꠁꠛꠣ। ꠀꠞ ꠛꠣꠖ-ꠛꠣꠇꠤ ꠟꠃ ꠘꠤꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠍꠣꠝꠘꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠔꠟꠦ ꠓꠣꠟꠤ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","ꠛꠣꠖꠦ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠟꠣꠉꠤ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠅꠃ ꠛꠤꠍꠣꠟꠞ ꠢꠇꠟ ꠌꠞ꠆ꠛꠤ ꠛꠣꠞ ꠇꠞꠛꠣ, ꠙꠦꠐꠞ ꠜꠤꠔꠞꠞ ꠢꠇ꠆ꠇꠟꠔꠣꠞ ꠃꠙꠞꠞ ꠌꠞ꠆ꠛꠤ, ꠁꠔꠣꠞ ꠟꠉꠦ ꠟꠣꠉꠣꠁꠟ ꠢꠇꠟ ꠌꠞ꠆ꠛꠤ, ");
INSERT INTO syls_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ꠖꠥꠁꠅ ꠇꠤꠒꠘꠤ ꠀꠞ ꠅꠔꠣꠞ ꠃꠙꠞꠞ ꠌꠞ꠆ꠛꠤ, ꠀꠞ ꠇꠁꠟꠎꠣꠞ ꠟꠉꠞ ꠝꠣꠐꠤꠀ। ");
INSERT INTO syls_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠉꠞꠥꠞ ꠌꠞ꠆ꠛꠤꠞ ꠟꠣꠈꠣꠘ, ꠅꠃ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠛꠤꠍꠣꠟꠞ ꠢꠇꠟ ꠌꠞ꠆ꠛꠤꠞꠦꠅ ꠅꠟꠣ ꠛꠣꠞ ꠇꠞꠛꠣ। ꠛꠣꠖꠦ ꠁꠝꠣꠝꠦ ꠅꠃ ꠌꠞ꠆ꠛꠤ ꠘꠤꠀ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠔ ꠎꠣꠟꠣꠁꠟꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","ꠅꠁꠟꠦ ꠅꠃ ꠛꠤꠍꠣꠟꠞ ꠇꠟ꠆ꠟꠣ, ꠈꠣꠟ, ꠉꠥꠡ꠆ꠔ, ꠑꠦꠋ, ꠀꠔ-ꠜꠠ, ꠉꠥꠚꠞ, ");
INSERT INTO syls_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ꠢꠇꠟꠔꠣ ꠘꠤꠀ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠇꠦꠝ꠆ꠙꠞ ꠛꠣꠞꠦ ꠎꠦꠈꠣꠘꠅ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠍꠣꠟꠤꠞ ꠐꠦꠇꠤ ꠕꠂꠘ, ꠢꠃ ꠙꠣꠇ-ꠍꠣꠚ ꠎꠣꠉꠣꠞ ꠍꠣꠟꠤꠞ ꠐꠦꠇꠤꠞ ꠃꠙꠞꠦ ꠅꠔꠣ ꠕꠁꠀ ꠢꠣꠞꠤ, ꠟꠣꠇꠠꠤꠞ ꠀꠉꠥꠁꠘꠖꠤ ꠎꠣꠟꠣꠁꠟꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ꠀꠞ ꠀꠡ꠆ꠔꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠡꠝꠣꠎ ꠘꠣ ꠎꠣꠘꠣꠞ ꠇꠣꠞꠘꠦ ꠎꠥꠖꠤ ꠜꠥꠟ ꠇꠞꠤꠀ ꠇꠥꠘꠥ ꠉꠥꠘꠣꠞ ꠇꠣꠝ ꠇꠞꠤꠟꠣꠄ, ꠀꠟ꠆ꠟꠣꠞ ꠘꠤꠡꠦꠗ ꠇꠞꠣ ꠇꠥꠘꠥ ꠇꠣꠝ ꠇꠞꠤꠀ ꠖꠥꠡꠤ ꠛꠘꠤꠎꠣꠄ, ꠔꠦ ꠘꠣ ꠎꠣꠘꠤꠀ ꠇꠞꠟꠦꠅ ꠔꠣꠞꠣ ꠢꠇꠟꠃ ꠉꠥꠘꠣꠉꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ꠛꠣꠖꠦ ꠎꠦꠛꠟꠣ ꠔꠣꠞꠣ ꠎꠣꠘꠛꠣ, ꠎꠣꠘꠤꠀ ꠢꠣꠞꠤ ꠅꠃ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠟꠣꠉꠤ ꠢꠇꠟꠞ ꠔꠞꠚ ꠕꠣꠇꠤ ꠄꠉꠥ ꠛꠤꠍꠣꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣ, ꠅꠃ ꠛꠤꠍꠣꠟ ꠟꠁꠀ ꠔꠣꠞꠣ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠍꠣꠝꠘꠦ ꠀꠎꠤꠞ ꠅꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","ꠅꠁꠀ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟꠦ ꠅꠃ ꠛꠤꠍꠣꠟꠞ ꠇꠟ꠆ꠟꠣ ꠀꠔꠣꠁ ꠖꠤꠛꠣ, ꠀꠞ ꠁꠝꠣꠝꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠅꠇꠐꠣ ꠎꠛ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","ꠎꠛꠞ ꠛꠣꠖꠦ ꠈꠦꠟꠣꠚꠔꠤ ꠙꠣꠅꠀ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠛꠤꠍꠣꠟꠞ ꠕꠥꠠꠣ ꠟꠃ ꠟꠁꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠜꠤꠔꠞꠦ ꠢꠣꠝꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","ꠢꠣꠝꠣꠁꠀ ꠅꠃ ꠟꠃꠞ ꠝꠣꠎꠦ ꠔꠣꠘ ꠀꠔꠞ ꠀꠋꠉꠥꠁꠟ ꠍꠥꠛꠣꠁꠀ, ꠕꠥꠠꠣ ꠟꠃ ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚꠞ ꠙꠞ꠆ꠖꠣꠞ ꠛꠣꠄ ꠡꠣꠔ ꠛꠣꠞ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠍꠤꠐꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","ꠛꠣꠖꠦ ꠀꠞꠅ ꠕꠥꠠꠣ ꠟꠃ ꠟꠁꠀ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠕꠅꠀ, ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠜꠤꠔꠞꠞ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠘꠤꠞ ꠐꠦꠛꠥꠟꠞ ꠢꠤꠋ ꠅꠇꠟꠅ ꠟꠣꠉꠣꠁꠛꠣ। ꠛꠣꠖ-ꠛꠣꠇꠤ ꠟꠃ ꠚꠥꠐꠣꠁꠘ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠍꠣꠝꠘꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠔꠟꠦ ꠓꠣꠟꠤ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","ꠀꠞ ꠛꠤꠍꠣꠟꠞ ꠢꠇꠟ ꠌꠞ꠆ꠛꠤ ꠛꠣꠞ ꠇꠞꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠔ ꠎꠣꠟꠣꠁꠟꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","ꠙꠞꠗꠣꠘ ꠁꠝꠣꠝꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠟꠣꠉꠤ ꠛꠤꠍꠣꠟꠞꠦ ꠎꠦꠟꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅꠀ ꠅꠄ, ꠁꠝꠣꠝꠦ ꠅꠃ ꠛꠤꠍꠣꠟꠞꠦꠅ ꠅꠟꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠞꠛꠣ। ꠔꠣꠁꠘ ꠅꠃ ꠡꠝꠣꠎꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠟꠦ, ꠔꠣꠞꠣꠞ ꠉꠥꠘꠣꠞ ꠝꠣꠚꠤ ꠝꠤꠟꠛ। ");
INSERT INTO syls_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠛꠤꠍꠣꠟꠞ ꠛꠣꠖ-ꠛꠣꠇꠤ ꠢꠇꠟꠔꠣ ꠟꠁꠀ ꠇꠦꠝ꠆ꠙꠞ ꠛꠣꠞꠦ ꠎꠣꠁꠛꠣ। ꠉꠤꠀ ꠔꠣꠘ ꠘꠤꠎꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠢꠃ ꠛꠤꠍꠣꠟꠞ ꠟꠣꠈꠣꠘ ꠅꠃ ꠛꠤꠍꠣꠟꠞ ꠢꠇꠟꠔꠣꠅ ꠇꠦꠝ꠆ꠙꠞ ꠛꠣꠞꠦ ꠅꠟꠣ ꠎꠣꠟꠣꠁꠟꠤꠛꠣ। ꠁꠔꠣ ꠅꠁꠟ ꠀꠡ꠆ꠔꠣ ꠡꠝꠣꠎꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ। ");
INSERT INTO syls_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠇꠥꠘꠥ ꠡꠞ꠆ꠖꠣꠞꠦ ꠘꠣ ꠎꠣꠘꠣꠞ ꠇꠣꠞꠘꠦ ꠎꠥꠖꠤ ꠜꠥꠟ ꠇꠞꠤꠀ ꠅꠟꠣ ꠉꠥꠘꠣ ꠇꠞꠤꠟꠣꠁꠘ, ꠔꠦ ꠀꠟ꠆ꠟꠣꠞ ꠘꠤꠡꠦꠗ ꠇꠞꠣ ꠇꠣꠝ ꠇꠞꠣꠄ ꠔꠣꠁꠘ ꠔ ꠖꠥꠡꠤ। ");
INSERT INTO syls_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ꠔꠣꠁꠘ ꠎꠦꠛꠟꠣ ꠅꠃ ꠉꠥꠘꠣꠞ ꠛꠦꠙꠣꠞꠦ ꠎꠣꠘꠤꠟꠤꠛꠣ, ꠎꠣꠘꠣꠞ ꠛꠣꠖꠦ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠘꠤꠈꠥꠔ ꠄꠉꠥ ꠙꠣꠑꠣ ꠍꠣꠉꠟ ꠟꠁꠀ ꠀꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","ꠀꠁꠀ ꠅꠃ ꠙꠣꠑꠣꠞ ꠇꠟ꠆ꠟꠣꠞ ꠃꠙꠞꠦ ꠀꠔꠣꠁ ꠖꠤꠀ, ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥ ꠎꠛ ꠇꠞꠣꠞ ꠎꠣꠉꠣꠔ ꠘꠤꠀ ꠅꠉꠥꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠎꠛ ꠇꠞꠛꠣ। ꠁꠔꠣ ꠔ ꠔꠣꠘ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ। ");
INSERT INTO syls_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","ꠛꠣꠖꠦ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠅꠃ ꠙꠡꠥꠞ ꠕꠥꠠꠣ ꠟꠃ ꠔꠣꠘ ꠀꠔꠞ ꠀꠋꠉꠥꠟꠤꠔ ꠇꠞꠤ ꠟꠁꠀ, ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠢꠤꠋ ꠅꠇꠟꠞ ꠃꠙꠞꠦ ꠟꠣꠉꠣꠁꠛꠣ। ꠛꠣꠖ-ꠛꠣꠇꠤ ꠟꠃ ꠘꠤꠀ ꠔꠣꠁꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠔꠟꠦ ꠓꠣꠟꠤ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","ꠀꠞ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠞ ꠌꠞ꠆ꠛꠤꠞ ꠟꠣꠈꠣꠘ ꠅꠉꠥꠞ ꠢꠇꠟ ꠌꠞ꠆ꠛꠤꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠎꠣꠟꠣꠁꠟꠤꠛꠣ। ꠅꠃ ꠟꠣꠈꠣꠘ ꠁꠝꠣꠝꠦ ꠢꠃ ꠡꠞ꠆ꠖꠣꠞꠞ ꠉꠥꠘꠣꠞ ꠝꠣꠚꠤꠞ ꠟꠣꠉꠤ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠟꠦ, ꠔꠣꠁꠘ ꠝꠣꠚꠤ ꠙꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠇꠥꠘꠥ ꠡꠣꠗꠣꠞꠘ ꠎꠘꠦ ꠘꠣ ꠎꠣꠘꠣꠞ ꠇꠣꠞꠘꠦ ꠎꠥꠖꠤ ꠜꠥꠟ ꠇꠞꠤꠀ ꠇꠥꠘꠥ ꠉꠥꠘꠣꠞ ꠇꠣꠝ ꠇꠞꠤꠟꠣꠄ, ꠝꠣꠛꠥꠖꠞ ꠘꠤꠡꠦꠗ ꠇꠞꠣ ꠇꠥꠘꠥ ꠇꠣꠝ ꠇꠞꠤꠀ ꠖꠥꠡꠤ ꠛꠘꠤꠎꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ꠔꠦ ꠢꠦ ꠎꠦꠛꠟꠣ ꠔꠣꠞ ꠉꠥꠘꠣꠞ ꠛꠦꠙꠣꠞꠦ ꠎꠣꠘꠤꠟꠤꠛ, ꠎꠣꠘꠤꠀ ꠅꠃ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠟꠣꠉꠤ ꠢꠦ ꠘꠤꠈꠥꠔ ꠄꠉꠥ ꠍꠣꠉꠤ ꠟꠁꠀ ꠀꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","ꠀꠁꠀ ꠅꠃ ꠍꠣꠉꠤꠞ ꠇꠟ꠆ꠟꠣꠞ ꠃꠙꠞꠦ ꠀꠔꠣꠁ ꠖꠤꠀ, ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠎꠛꠞ ꠎꠣꠉꠣꠔ ꠘꠤꠀ ꠅꠉꠥꠞꠦ ꠎꠛ ꠇꠞꠛ। ");
INSERT INTO syls_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","ꠛꠣꠖꠦ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠔꠣꠘ ꠀꠔꠞ ꠀꠋꠉꠥꠟꠤꠔ ꠇꠞꠤ ꠅꠉꠥꠞ ꠕꠥꠠꠣ ꠟꠃ ꠟꠣꠉꠣꠁꠀ, ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠢꠤꠋ ꠅꠇꠟꠞ ꠃꠙꠞꠦ ꠟꠣꠉꠣꠁꠛꠣ। ꠛꠣꠖ-ꠛꠣꠇꠤ ꠟꠃ ꠔꠣꠁꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠔꠟꠦ ꠓꠣꠟꠤ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","ꠀꠞ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠝꠦꠠꠣꠞ ꠌꠞ꠆ꠛꠤꠞ ꠟꠣꠈꠣꠘ ꠅꠉꠥꠞ ꠢꠇꠟ ꠌꠞ꠆ꠛꠤ ꠛꠣꠞ ꠇꠞꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠎꠣꠟꠣꠁꠟꠤꠛꠣ। ꠁꠔꠣꠞ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠝꠣꠛꠥꠖ ꠈꠥꠡꠤ ꠅꠁꠘ। ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠁꠝꠣꠝꠦ ꠢꠃ ꠎꠘꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠟꠦ, ꠔꠣꠞ ꠝꠣꠚꠤ ꠝꠤꠟꠛ। ");
INSERT INTO syls_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠘꠤꠅꠔꠦ ꠇꠦꠃ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠝꠦꠠꠣ ꠀꠘꠦ, ꠔꠦ ꠁꠐꠣ ꠘꠤꠈꠥꠔ ꠝꠦꠠꠤ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠅꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","ꠢꠦ ꠅꠉꠥꠞ ꠇꠟ꠆ꠟꠣꠞ ꠃꠙꠞꠦ ꠀꠔꠣꠁ ꠖꠤꠀ, ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠞ ꠎꠛꠞ ꠎꠣꠉꠣꠔ ꠘꠤꠀ, ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠘꠤꠅꠔꠦ ꠅꠉꠥꠞꠦ ꠎꠛ ꠇꠞꠛ। ");
INSERT INTO syls_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","ꠛꠣꠖꠦ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠔꠣꠘ ꠀꠔꠞ ꠀꠋꠉꠥꠟꠤꠔ ꠇꠞꠤ ꠅꠃ ꠝꠦꠠꠤꠞ ꠕꠥꠠꠣ ꠟꠃ ꠟꠁꠀ, ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠢꠤꠋ ꠅꠇꠟꠞ ꠃꠙꠞꠦ ꠟꠣꠉꠣꠁꠛꠣ। ꠛꠣꠖ-ꠛꠣꠇꠤ ꠟꠃ ꠔꠣꠁꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠔꠟꠦ ꠓꠣꠟꠤ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","ꠀꠞ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠝꠦꠠꠣꠞ ꠌꠞ꠆ꠛꠤ ꠎꠦꠟꠣ ꠛꠣꠞ ꠇꠞꠂꠘ, ꠅꠉꠥꠞ ꠢꠇꠟ ꠌꠞ꠆ꠛꠤꠞꠦꠅ ꠅꠟꠣ ꠛꠣꠞ ꠇꠞꠛꠣ। ꠛꠣꠞ ꠇꠞꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠔ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅꠀ ꠢꠇꠟꠔꠣꠞ ꠃꠙꠞꠦ ꠕꠁꠀ ꠅꠃ ꠌꠞ꠆ꠛꠤꠞꠦꠅ ꠎꠣꠟꠣꠁꠟꠤꠛꠣ, ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠁꠝꠣꠝꠦ ꠢꠃ ꠎꠘꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠤꠀ ꠢꠣꠞꠟꠦ, ꠢꠦ ꠝꠣꠚꠤ ꠙꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠘꠤꠎꠞ ꠌꠃꠈꠦ ꠖꠦꠈꠣ ꠛꠣ ꠇꠣꠘꠦ ꠢꠥꠘꠣ ꠇꠥꠘꠥ ꠊꠐꠘꠣ ꠎꠣꠘꠦ, ꠀꠞ ꠛꠤꠌꠣꠞꠞ ꠇꠣꠟꠅ ꠀꠖꠣꠟꠔꠅ ꠡꠣꠇ꠆ꠇꠤꠞ ꠡꠥꠎꠥꠉ ꠙꠣꠁꠀꠅ ꠡꠣꠇ꠆ꠇꠤ ꠘꠣ ꠖꠦꠄ, ꠔꠦ ꠁꠔꠣꠞ ꠟꠣꠉꠤ ꠢꠦ ꠉꠥꠘꠣ ꠇꠞꠦ, ꠔꠣꠞ ꠁ ꠅꠙꠞꠣꠗꠞ ꠡꠣꠎꠣ ꠢꠦ ꠛꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ꠇꠦꠃ ꠎꠥꠖꠤ ꠘꠣ ꠎꠣꠘꠤꠀ ꠇꠥꠘꠥ ꠘꠣꠙꠣꠇ ꠎꠤꠘꠤꠡ ꠍꠁꠟꠣꠄ, ꠔꠦ ꠢꠦ ꠘꠣꠙꠣꠇ ꠀꠞ ꠖꠥꠡꠤ ꠛꠘꠛ। ꠁꠔꠣ ꠇꠥꠘꠥꠎꠣꠔꠞ ꠎꠋꠟꠤ ꠢꠣꠞꠣꠝ ꠝꠞꠣ ꠙꠡꠥ, ꠊꠞꠅ ꠙꠣꠟꠣ ꠇꠥꠘꠥ ꠝꠞꠣ ꠎꠣꠘꠖꠣꠞ ꠛꠣ ꠝꠣꠐꠤꠞ ꠝꠣꠎꠦ ꠛꠥꠇꠦ ꠌꠟꠞꠣ ꠎꠦꠇꠥꠘꠥ ꠝꠞꠣ ꠎꠣꠘꠖꠣꠞꠞꠦ ꠘꠣ ꠎꠣꠘꠤꠀ ꠍꠁꠟꠦꠅ ꠖꠥꠡꠤ-ꠘꠣꠙꠣꠇ ꠛꠘꠛ। ");
INSERT INTO syls_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“ꠝꠣꠘꠡꠞ ꠡꠞꠤꠟꠞꠦ ꠎꠦꠔꠣꠄ ꠘꠣꠙꠣꠇ ꠇꠞꠤꠟꠣꠄ, ꠡꠞꠤꠟ ꠕꠣꠇꠤ ꠛꠣꠞꠅꠁꠟ ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠥꠘꠥꠔꠣ ꠇꠦꠃ ꠎꠥꠖꠤ ꠘꠣ ꠎꠣꠘꠤꠀ ꠍꠁꠟꠣꠄ, ꠔꠦ ꠁꠔꠣ ꠎꠣꠘꠣꠞ ꠛꠣꠖꠦ ꠢꠦ ꠖꠥꠡꠤ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“ꠀꠈꠟ-ꠛꠤꠛꠦꠇ ꠘꠣ ꠈꠣꠐꠣꠁꠀ ꠀꠈꠔꠣ ꠎꠥꠖꠤ ꠇꠦꠃ ꠇꠥꠘꠥ ꠇꠍꠝ ꠇꠞꠤꠟꠣꠄ, ꠜꠣꠟꠣ ꠛꠣ ꠛꠥꠞꠣ ꠇꠥꠘ꠆ꠔꠣ ꠇꠞꠝꠥ ꠇꠁꠀ ꠝꠘꠞ ꠛꠦ-ꠈꠤꠀꠟꠦ ꠇꠦꠃ ꠇꠥꠘꠥ ꠇꠍꠝ ꠈꠣꠁꠟꠦꠅ, ꠢꠦ ꠎꠦꠛꠟꠣ ꠁꠈꠣꠘ ꠛꠥꠎꠤꠟꠤꠛ ꠅꠃ ꠡꠝꠄ ꠢꠦ ꠖꠥꠡꠤ ꠛꠘꠛ। ");
INSERT INTO syls_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“ꠅꠃ ꠟꠣꠈꠣꠘ ꠎꠦꠇꠥꠘꠥ ꠅꠙꠞꠣꠗ ꠇꠞꠤꠀ ꠇꠦꠃ ꠖꠥꠡꠤ ꠛꠘꠤꠉꠦꠟꠦ, ꠢꠦ ꠘꠤꠎꠞ ꠉꠥꠘꠣꠞꠦ ꠡ꠆ꠛꠤꠇꠣꠞ ꠇꠞꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","ꠀꠞ ꠅꠃ ꠉꠥꠘꠣꠞ ꠎꠞꠤꠝꠣꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠢꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ, ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠘꠤꠅꠔꠦ ꠄꠇꠐꠣ ꠝꠦꠠꠤ ꠛꠣ ꠍꠣꠉꠤ ꠀꠘꠛ, ꠀꠞ ꠁꠝꠣꠝꠦ ꠔꠣꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ꠀꠞ ꠢꠦ ꠎꠥꠖꠤ ꠝꠦꠠꠤ ꠛꠣ ꠍꠣꠉꠤ ꠀꠘꠔꠦ ꠅꠙꠣꠞꠉ ꠅꠄ, ꠔꠦ ꠅꠃ ꠉꠥꠘꠣꠞ ꠎꠞꠤꠝꠣꠘꠣ ꠛꠣꠛꠔ ꠖꠥꠁꠐꠣ ꠒꠥꠙꠤ ꠙꠣꠈꠤ ꠛꠣ ꠙꠣꠞꠅ ꠀꠘꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠖꠤꠔꠦ ꠅꠁꠛ। ꠁꠔꠣꠞ ꠝꠣꠎꠞ ꠄꠉꠥ ꠅꠁꠛ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ, ꠀꠞ ꠖꠥꠍꠞꠣꠐꠣ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ। ");
INSERT INTO syls_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","ꠀꠞ ꠢꠦ ꠁꠔꠣ ꠀꠘꠤꠀ ꠁꠝꠣꠝꠞ ꠀꠔꠅ ꠖꠤꠛ, ꠁꠝꠣꠝꠦ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠙꠄꠟꠣ ꠄꠉꠥ ꠙꠣꠈꠤꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣ। ꠔꠣꠁꠘ ꠅꠉꠥꠞ ꠇꠟ꠆ꠟꠣ ꠝꠥꠞꠣꠁꠀ ꠝꠣꠞꠛꠣ, ꠅꠁꠟꠦ ꠇꠟ꠆ꠟꠣ ꠀꠟꠉꠣꠁꠔꠣ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","ꠛꠣꠖꠦ ꠅꠉꠥꠞ ꠕꠥꠠꠣ ꠟꠃ ꠘꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠔ ꠍꠤꠐꠣꠁ ꠖꠤꠛꠣ, ꠀꠞ ꠛꠣꠖ-ꠛꠣꠇꠤ ꠟꠃ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠔꠟꠦ ꠓꠣꠟꠤ ꠖꠤꠛꠣ। ꠁꠔꠣ ꠅꠁꠟ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠟꠣꠉꠤ ꠇꠥꠞꠛꠣꠘꠤ। ");
INSERT INTO syls_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","ꠀꠞ ꠖꠥꠍꠞꠣ ꠙꠣꠈꠤꠐꠣꠞꠦ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠘꠤꠅꠝ ꠝꠣꠚꠤꠇ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣ। ꠖꠤꠀ, ꠔꠣꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠛꠣ, ꠔꠦꠃ ꠢꠦ ꠝꠣꠚꠤ ꠙꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ꠀꠞ ꠎꠥꠖꠤ ꠅꠃ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠟꠣꠉꠤ ꠖꠥꠁꠐꠣ ꠒꠥꠙꠤ ꠙꠣꠈꠤ ꠛꠣ ꠙꠣꠞꠅ ꠀꠘꠔ ꠘꠣ ꠙꠣꠞꠦ, ꠔꠦ ꠢꠦ ꠖꠥꠁ ꠡꠦꠞ ꠝꠄꠖꠣ ꠀꠘꠔꠦ ꠅꠁꠛ। ꠁꠔꠣ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠅꠀꠄ ꠁꠔꠣꠞ ꠃꠙꠞꠦ ꠇꠥꠘꠥ ꠔꠦꠟ ꠛꠣ ꠟꠥꠛꠣꠘ-ꠀꠉꠞ ꠖꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","ꠅꠃ ꠝꠄꠖꠣ ꠟꠁꠀ ꠢꠦ ꠁꠝꠣꠝꠞ ꠉꠦꠍꠦ ꠎꠣꠁꠛ, ꠉꠦꠟꠦ ꠅꠃ ꠀꠡ꠆ꠔꠣ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠛꠖꠟꠣ ꠘꠤꠡꠣꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠄꠇ ꠝꠥꠁꠐ ꠝꠄꠖꠣ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠎꠣꠟꠣꠁꠟꠤꠛꠣ। ꠁꠔꠣ ꠅꠁꠟ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ। ");
INSERT INTO syls_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","ꠢꠦ ꠎꠦ ꠅꠙꠞꠣꠗ ꠇꠞꠍꠦ, ꠅꠔꠣꠞ ꠝꠣꠚꠤꠞ ꠟꠣꠉꠤ ꠁꠝꠣꠝꠦ ꠅꠟꠣ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠛꠣ, ꠔꠦꠃ ꠔꠣꠞ ꠉꠥꠘꠣꠞ ꠝꠣꠚꠤ ꠙꠣꠁꠛ। ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅꠀꠞ ꠛꠣꠖꠦ ꠁ ꠝꠄꠖꠣꠞ ꠎꠔꠈꠣꠘ ꠞꠁꠛ, ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠟꠣꠈꠣꠘ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠁꠝꠣꠝꠦ ꠙꠣꠁꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“ꠇꠦꠃ ꠎꠥꠖꠤ ꠘꠣ ꠎꠣꠘꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠇꠥꠘꠥ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣꠞ ꠛꠦꠙꠣꠞꠦ ꠄꠝꠘꠦꠃ ꠇꠥꠘꠥ ꠖꠥꠡ-ꠇꠍꠥꠞꠤ ꠇꠞꠤꠟꠣꠄ, ꠔꠦ ꠅꠃ ꠉꠥꠘꠣꠞ ꠎꠞꠤꠝꠣꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠝꠣꠙꠦ ꠎꠔ ꠔꠟꠣ ꠞꠥꠙꠣꠖꠤ ꠝꠦꠠꠣꠞ ꠖꠣꠝ ꠑꠤꠇ ꠇꠞꠣ ꠅꠄ, ꠔꠦ ꠢꠦ ꠔꠣꠞ ꠘꠤꠎꠞ ꠙꠣꠟ ꠕꠣꠇꠤ ꠅꠃ ꠙꠞꠤꠝꠣꠘ ꠖꠣꠝꠞ ꠛꠣ ꠢꠝꠣꠘ ꠖꠣꠝꠖꠤ ꠇꠤꠘꠤꠀ ꠘꠤꠈꠥꠔ ꠄꠉꠥ ꠝꠦꠠꠣꠞ ꠙꠣꠑꠣ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠔꠦ ꠅꠁꠛ। ꠁꠔꠣ ꠔ ꠖꠥꠡ-ꠇꠍꠥꠞꠤꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ। ");
INSERT INTO syls_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","ꠀꠞ ꠢꠦ ꠅꠃ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣꠞ ꠛꠦꠙꠣꠞꠦ ꠎꠦ ꠖꠥꠡ-ꠇꠍꠥꠞꠤ ꠇꠞꠍꠦ, ꠁꠔꠣꠞ ꠈꠦꠔꠤ-ꠙꠥꠞꠘꠅ ꠖꠤꠔꠦ ꠅꠁꠛ। ꠢꠦ ꠅꠃ ꠝꠦꠠꠣꠞ ꠖꠣꠝꠞ ꠟꠉꠦ ꠀꠞꠅ ꠙꠣꠌ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ ꠙꠞꠤꠝꠣꠘ ꠘꠉꠖ ꠐꠦꠇꠣ ꠁꠝꠣꠝ ꠍꠣꠛꠞ ꠀꠔꠅ ꠖꠤꠛ। ꠛꠣꠖꠦ ꠁꠝꠣꠝꠦ ꠔꠣꠞ ꠇꠍꠥꠞꠤ ꠝꠣꠚꠤꠞ ꠘꠤꠅꠔꠦ ꠅꠃ ꠝꠦꠠꠣꠞꠦ ꠘꠤꠀ ꠖꠥꠡ-ꠇꠍꠥꠞꠤꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠤꠀ ꠢꠣꠞꠟꠦ, ꠢꠦ ꠝꠣꠚꠤ ꠙꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“ꠀꠞ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠜꠥꠟ ꠇꠞꠤꠀ ꠘꠣ ꠎꠣꠘꠤꠀ ꠀꠟ꠆ꠟꠣꠞ ꠘꠤꠡꠦꠗ ꠇꠞꠣ ꠇꠥꠘꠥ ꠖꠥꠡ-ꠇꠍꠥꠞꠤꠞ ꠇꠣꠝ ꠇꠞꠤꠟꠣꠄ, ꠔꠦ ꠁꠔꠣꠞ ꠟꠣꠉꠤ ꠢꠦ ꠖꠥꠡꠤ। ꠁ ꠉꠥꠘꠣꠞ ꠟꠣꠉꠤ ꠔꠣꠞꠦ ꠖꠣꠄꠁ ꠇꠞꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","ꠢꠦ ꠔꠣꠞ ꠅꠃ ꠖꠥꠡ-ꠇꠍꠥꠞꠤꠞ ꠇꠚꠞꠣ ꠢꠤꠡꠣꠛꠦ, ꠄꠉꠥ ꠘꠤꠈꠥꠔ ꠝꠦꠠꠣꠞ ꠙꠣꠑꠣ ꠛꠣ ꠄꠞ ꠖꠣꠝ ꠀꠘꠤꠀ ꠁꠝꠣꠝ ꠍꠣꠛꠞ ꠉꠦꠍꠦ ꠖꠤꠛ। ꠢꠦ ꠘꠣ ꠎꠣꠘꠤꠀ ꠎꠦ ꠖꠥꠡ-ꠇꠍꠥꠞꠤ ꠇꠞꠤꠟꠤꠍꠦ, ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠅꠔꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠛꠣ, ꠔꠦꠃ ꠔꠣꠞ ꠝꠣꠚꠤ ꠝꠤꠟꠛ। ");
INSERT INTO syls_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","ꠁꠔꠣ ꠔ ꠖꠥꠡ-ꠇꠍꠥꠞꠤꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ, ꠢꠦ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠖꠥꠡ ꠇꠞꠍꠦ।” ");
INSERT INTO syls_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠀꠞꠅ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“ꠢꠥꠘꠅ, ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠦꠛꠟꠣ ꠔꠣꠞ ꠀꠞꠤ-ꠚꠞꠤꠞ ꠟꠉꠦ ꠢꠣꠞꠣꠝꠤ ꠇꠞꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠉꠥꠘꠣ ꠇꠞꠦ, ꠔꠣꠞ ꠉꠦꠍꠦ ꠕꠅꠀ ꠀꠝꠣꠘꠔ ꠛꠣ ꠛꠘ꠆ꠗꠇꠤ ꠎꠤꠘꠤꠡꠞ ꠈꠤꠀꠘꠔ ꠇꠞꠦ, ꠛꠣ ꠌꠥꠞꠤ ꠇꠞꠤ ꠇꠥꠘꠥ ꠝꠣꠟ ꠘꠦꠄ ꠛꠣ ꠐꠉꠣ-ꠐꠉꠤ ꠇꠞꠦ, ꠍꠟ-ꠌꠔꠥꠞꠤ ꠇꠞꠤꠀ ꠛꠦꠁꠝꠣꠘꠤ ꠝꠣꠔꠦ, ");
INSERT INTO syls_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ꠔꠥꠛꠣꠁꠀ ꠙꠣꠅꠀ ꠝꠣꠟꠞ ꠛꠦꠙꠣꠞꠦ ꠛꠦꠁꠝꠣꠘꠤ ꠝꠣꠔꠦ ꠛꠣ ꠅꠔꠣ ꠢꠇ꠆ꠇꠟꠔꠣꠞ ꠛꠦꠙꠣꠞꠦ ꠇꠥꠘꠥ ꠝꠤꠍꠣ ꠇꠍꠝ ꠈꠣꠄ, ꠛꠣ ꠅꠃ ꠟꠣꠈꠣꠘ ꠀꠞꠅ ꠇꠥꠘꠥ ꠉꠥꠘꠣ ꠇꠞꠦ, ");
INSERT INTO syls_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ꠔꠦ ꠅꠃ ꠘꠝꠥꠘꠣꠞ ꠉꠥꠘꠣ ꠇꠞꠤꠀ ꠅꠙꠞꠣꠗꠤ ꠛꠘꠣꠄ, ꠢꠦ ꠎꠦꠔꠣ ꠝꠣꠟ ꠀꠔ꠆ꠔꠡꠣꠔ ꠇꠞꠍꠦ, ꠛꠣ ꠍꠟ-ꠌꠔꠥꠞꠤ ꠇꠞꠤꠀ ꠘꠤꠍꠦ, ꠛꠣ ꠀꠝꠣꠘꠔꠞ ꠈꠤꠀꠘꠔ ꠇꠞꠍꠦ, ꠔꠥꠛꠣꠁ ꠙꠣꠅꠀ ꠝꠣꠟ ꠟꠥꠇꠣꠁꠍꠦ, ");
INSERT INTO syls_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ꠛꠣ ꠎꠦꠇꠥꠘꠥ ꠝꠣꠟꠞ ꠛꠦꠙꠣꠞꠦ ꠝꠤꠍꠣ ꠇꠍꠝ ꠈꠣꠁꠍꠦ, ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠢꠦ ꠚꠤꠞꠔ ꠖꠤꠛ, ꠄꠞꠟꠉꠦ ꠎꠞꠤꠝꠣꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠀꠞꠅ ꠙꠣꠌ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ ꠛꠦꠡꠤ ꠖꠤꠛ। ꠢꠦ ꠎꠦꠖꠤꠘ ꠔꠣꠞ ꠖꠥꠡ ꠡ꠆ꠛꠤꠇꠣꠞ ꠇꠞꠛ, ꠅꠃ ꠖꠤꠘ ꠝꠣꠟꠞ ꠝꠣꠟꠤꠇꠞꠦ ꠁꠔꠣ ꠚꠤꠞꠣꠁ ꠖꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","ꠀꠞ ꠘꠤꠎꠞ ꠖꠥꠡ-ꠇꠍꠥꠞꠤ ꠝꠣꠚꠤꠞ ꠘꠤꠅꠔꠦ ꠢꠦ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠇꠥꠞꠛꠣꠘꠤ ꠟꠁꠀ ꠀꠎꠤꠞ ꠅꠁꠛ, ꠁꠝꠣꠝ ꠍꠣꠛꠞ ꠑꠤꠇ ꠇꠞꠣ ꠖꠣꠝꠞ ꠄꠉꠥ ꠘꠤꠈꠥꠔ ꠝꠦꠠꠣꠞ ꠙꠣꠑꠣ ꠟꠁꠀ ꠀꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","ꠁꠝꠣꠝꠦ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠔꠣꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠛꠣ। ꠢꠦ ꠅꠔꠣꠞ ꠝꠣꠎꠞ ꠎꠦꠇꠥꠘꠥ ꠉꠥꠘꠣ ꠇꠞꠟꠦ, ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠔꠣꠞ ꠉꠥꠘꠣꠞ ꠝꠣꠚꠤ ꠙꠣꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“ꠔꠥꠝꠤ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠢꠤꠇꠣꠁ ꠖꠦꠅ, ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠝꠥꠍꠟꠣ ꠅꠁꠟ, ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥ ꠚꠎꠞ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠣꠞꠣ ꠞꠣꠁꠔ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠀꠉꠥꠘꠤꠞ ꠃꠙꠞꠦ ꠞꠁꠛ, ꠀꠞ ꠀꠉꠥꠁꠘꠅ ꠎꠣꠟꠣꠁꠟ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","ꠛꠤꠀꠘꠤ ꠛꠣꠟꠣ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠡꠥꠔꠤ ꠇꠣꠙꠠꠖꠤ ꠛꠣꠘꠣꠁꠟ ꠢꠣꠚ-ꠙꠦꠘ꠆ꠐꠞ ꠟꠣꠈꠣꠘ ꠘꠤꠎꠞ ꠎꠣꠋꠉꠤꠀꠈꠣꠘ ꠀꠞ ꠔꠣꠘ ꠁꠝꠣꠝꠔꠤꠞ ꠛꠣꠇꠤ ꠢꠇꠟ ꠡꠥꠔꠤꠞ ꠟꠦꠛꠣꠍ ꠚꠤꠘ꠆ꠖꠤꠛꠣ। ꠚꠤꠘ꠆ꠖꠤꠀ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥ ꠎꠣꠟꠣꠘꠤꠞ ꠍꠣꠟꠤ ꠔꠥꠟꠤꠀ ꠘꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠕꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠅꠃ ꠟꠦꠛꠣꠍ ꠛꠖꠟꠣꠁꠀ, ꠖꠥꠍꠞꠣ ꠟꠦꠛꠣꠍ ꠚꠤꠘ꠆ꠖꠤꠀ, ꠅꠃ ꠍꠣꠟꠤꠞꠦ ꠇꠦꠝ꠆ꠙꠞ ꠛꠣꠞꠦ ꠇꠥꠘꠥ ꠙꠣꠇ-ꠍꠣꠚ ꠎꠣꠉꠣꠔ ꠘꠤꠀ ꠚꠣꠟꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","ꠅꠁꠟꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠔ ꠀꠉꠥꠁꠘ ꠎꠣꠟꠣꠁꠟ ꠞꠁꠛ, ꠁꠔꠣ ꠘꠤꠜꠔ ꠘꠣ। ꠙꠞꠔꠦꠇ ꠖꠤꠘ ꠛꠤꠀꠘꠦ ꠁꠝꠣꠝꠦ ꠅꠃ ꠀꠉꠥꠘꠤꠞ ꠃꠙꠞꠦ ꠎꠣꠟꠣꠘꠤꠞ ꠖꠣꠞꠥ ꠖꠤꠛꠣ, ꠖꠤꠀ ꠖꠣꠞꠥꠞ ꠃꠙꠞꠦ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠞꠦ ꠢꠣꠎꠣꠁꠛꠣ, ꠢꠣꠎꠣꠁꠀ ꠄꠞ ꠃꠙꠞꠦ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠌꠞ꠆ꠛꠤꠞꠦ ꠎꠣꠟꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","ꠢꠥꠡꠤꠀꠞ ꠞꠁꠅ, ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠀꠉꠥꠁꠘ ꠢꠣꠝꠦꠡꠣ ꠎꠟꠣꠔ ꠞꠁꠛ, ꠁꠔꠣ ꠇꠥꠘꠥ ꠡꠝꠄꠃ ꠘꠤꠜꠔ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ꠗꠣꠘ-ꠉꠝ ꠍꠖꠉꠣꠞ ꠘꠤꠅꠝ ꠅꠁꠟ, ꠢꠣꠞꠥꠘꠞ ꠙꠥꠀꠂꠘ ꠕꠣꠇꠤ ꠄꠇꠎꠘ ꠁꠝꠣꠝꠦ ꠅꠃ ꠍꠖꠉꠣꠞ ꠝꠄꠖꠣ ꠀꠞ ꠖꠞꠇꠣꠞꠤ ꠢꠇ꠆ꠇꠟꠔꠣ ꠟꠁꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠉꠦꠍꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠀꠎꠤꠞ ꠅꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","ꠀꠞ ꠁꠝꠣꠝꠦ ꠅꠈꠣꠘ ꠕꠣꠇꠤ ꠄꠇ ꠝꠥꠁꠐ ꠝꠄꠖꠣ, ꠇꠤꠍꠥ ꠔꠦꠟ ꠀꠞ ꠍꠖꠉꠣꠞ ꠢꠇꠟ ꠟꠥꠛꠣꠘ-ꠀꠉꠞ ꠘꠤꠀ ꠀꠡ꠆ꠔꠣ ꠍꠖꠉꠣꠞ ꠘꠤꠡꠣꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠅꠃ ꠅꠋꠡꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠎꠣꠟꠣꠁꠛꠣ। ꠁꠔꠣꠞ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠔ ꠝꠣꠛꠥꠖ ꠈꠥꠡꠤ ꠅꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","ꠍꠖꠉꠣꠞ ꠝꠣꠟꠞ ꠛꠣꠖ-ꠛꠣꠇꠤ ꠅꠋꠡ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠈꠣꠁꠛꠣ। ꠔꠣꠞꠣ ꠁꠔꠣꠞ ꠝꠣꠎꠦ ꠇꠥꠘꠥ ꠈꠣꠝꠤꠞ ꠘꠣ ꠝꠤꠡꠣꠁꠀ ꠞꠥꠐꠤ ꠛꠣꠘꠣꠁꠛꠣ, ꠛꠣꠘꠣꠁꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠃꠑꠣꠘꠅ ꠇꠥꠘꠥ ꠙꠣꠇ ꠎꠣꠉꠣꠔ ꠛꠁꠀ ꠈꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠇꠥꠘꠥ ꠈꠣꠝꠤꠞ ꠙꠥꠞꠣꠁꠀ ꠁꠔꠣꠞꠦ ꠍꠦꠇꠤꠅ ꠘꠣ। ꠀꠝꠣꠞ ꠘꠣꠝꠦ ꠖꠦꠅꠀ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠅꠃ ꠅꠋꠡ ꠀꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠖꠤꠟꠣꠝ। ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ, ꠀꠞ ꠖꠥꠡ-ꠇꠍꠥꠞꠤꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠈꠣꠘ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠅꠃ ꠅꠋꠡꠅ ꠅꠁꠟ ꠈꠣꠍ ꠙꠛꠤꠔ꠆ꠞ। ");
INSERT INTO syls_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","ꠈꠣꠟꠤ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠛꠋꠡꠞ ꠢꠇꠟ ꠛꠦꠐꠣ ꠝꠣꠘꠡꠦ ꠁꠔꠣ ꠈꠣꠁꠔꠣ ꠙꠣꠞꠛꠣ, ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠅꠃ ꠅꠋꠡ ꠔ ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠔꠣꠞꠣꠃ ꠙꠣꠁꠛꠣ। ꠈꠥꠛ ꠈꠤꠀꠟ ꠞꠣꠈꠤꠅ, ꠎꠦꠍꠣꠔꠣꠄ ꠁꠔꠣꠞ ꠟꠉꠦ ꠟꠣꠉꠛ, ꠅꠔꠣꠅ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠛꠘꠤꠎꠤꠛ, ꠝꠣꠘꠤ ꠁꠝꠣꠝ ꠅꠇꠟꠞ ꠛꠣꠁꠞꠣ ꠝꠣꠘꠡꠞ ꠟꠣꠉꠤ ꠢꠣꠞꠣꠝ।” ");
INSERT INTO syls_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠀꠞꠅ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“ꠢꠣꠞꠥꠘꠦ ꠎꠦꠖꠤꠘ ꠁꠝꠣꠝꠔꠤꠞ ꠈꠦꠟꠣꠚꠔꠤ ꠡꠝꠎꠤꠀ ꠇꠣꠝꠅ ꠛꠅꠀꠁꠟ ꠅꠁꠛꠣ, ꠅꠃ ꠖꠤꠘ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠘꠤꠅꠝ ꠝꠣꠚꠤꠇ ꠖꠥꠁ ꠡꠦꠞ ꠝꠄꠖꠣ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠀꠘꠛꠣ। ꠁꠔꠣꠞ ꠅꠞ꠆ꠗꠦꠇ ꠛꠤꠀꠘꠦ ꠀꠞ ꠅꠞ꠆ꠗꠦꠇ ꠢꠣꠁꠘ꠆ꠎꠣ ꠛꠣꠟꠣ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","ꠔꠣꠞꠣ ꠔꠦꠟ ꠖꠤꠀ ꠈꠣꠁ ꠛꠣꠘꠣꠁꠀ ꠔꠣꠅꠀꠔ ꠍꠦꠇꠤꠀ ꠢꠣꠞꠟꠦ ꠁꠔꠣ ꠐꠥꠇꠞꠣ ꠐꠥꠇꠞꠣ ꠇꠞꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠢꠤꠡꠣꠛꠦ ꠀꠎꠤꠞ ꠇꠞꠛꠣ, ꠁꠔꠣꠞ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠝꠣꠛꠥꠖ ꠈꠥꠡꠤ ꠅꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","ꠢꠣꠞꠥꠘꠞ ꠛꠣꠖꠦ ꠔꠣꠞ ꠎꠦ ꠙꠥꠀꠞꠦ ꠙꠞꠗꠣꠘ ꠁꠝꠣꠝ ꠢꠤꠡꠣꠛꠦ ꠈꠦꠟꠣꠚꠔꠤ ꠖꠦꠅꠀ ꠅꠁꠛ, ꠢꠦ-ꠅ ꠅꠃꠟꠣ ꠍꠖꠉꠣ ꠀꠖꠣꠄ ꠇꠞꠛ। ꠁꠔꠣ ꠔ ꠝꠣꠛꠥꠖꠞ ꠢꠞ-ꠢꠣꠝꠦꠡꠣꠇꠥꠞ ꠙꠣꠅꠘꠣ, ꠅꠃ ꠍꠖꠉꠣꠞ ꠙꠥꠞꠣ ꠅꠋꠡ ꠎꠣꠟꠣꠁꠟꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","ꠁꠝꠣꠝ ꠅꠇꠟꠞ ꠘꠤꠎꠞ ꠖꠦꠅꠀ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠢꠇ꠆ꠇꠟꠔꠣ ꠎꠣꠟꠣꠁꠟꠤꠔꠦ ꠅꠁꠛ, ꠁꠔꠣ ꠈꠣꠅꠀꠞ ꠇꠥꠘꠥ ꠢꠥꠇꠥꠝ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“ꠔꠥꠝꠤ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠘꠤꠅꠝ ꠢꠤꠇꠣꠅ। ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠞꠦ ꠎꠦ ꠎꠣꠉꠣꠔ ꠎꠛ ꠇꠞꠂꠘ, ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠞꠦꠅ ꠅꠘꠅ ꠎꠛ ꠇꠞꠛꠣ। ꠁ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠉꠥꠡ꠆ꠔ ꠔ ꠈꠣꠍ ꠙꠛꠤꠔ꠆ꠞ। ");
INSERT INTO syls_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","ꠎꠦ ꠁꠝꠣꠝꠦ ꠅꠃ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠛꠣ, ꠄꠁꠘ ꠅꠃ ꠉꠥꠡ꠆ꠔ ꠈꠣꠁꠛꠣ। ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠃꠑꠣꠘꠅ ꠙꠛꠤꠔ꠆ꠞ ꠎꠣꠉꠣꠔ ꠅꠃ ꠉꠥꠡ꠆ꠔ ꠈꠣꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","ꠎꠦꠔꠣ ꠎꠤꠘꠤꠡꠦ ꠅꠃ ꠉꠥꠡ꠆ꠔꠞꠦ ꠍꠁꠛ, ꠁꠔꠣ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠅꠁꠎꠤꠛ। ꠇꠥꠘꠥ ꠇꠣꠙꠠꠞ ꠝꠣꠎꠦ ꠎꠥꠖꠤ ꠄꠞ ꠟꠃꠞ ꠍꠤꠐꠣ ꠟꠣꠉꠦ, ꠔꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠇꠥꠘꠥ ꠎꠣꠉꠣꠔ ꠁꠔꠣ ꠗꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","ꠀꠞ ꠝꠣꠐꠤꠞ ꠎꠦ ꠙꠣꠔꠤꠟꠅ ꠅꠃ ꠉꠥꠡ꠆ꠔ ꠞꠣꠘ꠆ꠖꠣ ꠅꠁꠛ, ꠁꠔꠣ ꠛꠣꠖꠦ ꠜꠣꠋꠉꠤꠟꠤꠛꠣꠄ। ꠅꠁꠟꠦ ꠙꠤꠔꠟꠞ ꠙꠣꠔꠤꠟꠅ ꠞꠣꠘ꠆ꠖꠤꠟꠦ ꠁꠐꠣ ꠝꠣꠘ꠆ꠎꠤꠀ ꠙꠣꠘꠤꠖꠤ ꠗꠁꠀ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","ꠁꠝꠣꠝ ꠛꠋꠡꠞ ꠎꠦꠇꠥꠘꠥ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠦ ꠅꠃ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠉꠥꠡ꠆ꠔ ꠈꠣꠁꠔꠣ ꠙꠣꠞꠛꠣ, ꠁꠔꠣ ꠔ ꠈꠣꠍ ꠙꠛꠤꠔ꠆ꠞ ꠉꠥꠡ꠆ꠔ। ");
INSERT INTO syls_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","ꠅꠁꠟꠦ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠞ ꠟꠃ ꠎꠥꠖꠤ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠜꠤꠔꠞꠦ ꠘꠦꠅꠀ ꠅꠁꠎꠣꠄ, ꠔꠦ ꠁ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠉꠥꠡ꠆ꠔ ꠈꠣꠅꠀ ꠘꠤꠡꠦꠗ, ꠁꠔꠣ ꠎꠣꠟꠣꠁꠟꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ꠖꠥꠡ-ꠇꠍꠥꠞꠤꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠝꠥꠍꠟꠣ ꠅꠁꠟ, ꠁ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠉꠥꠡ꠆ꠔ ꠔ ꠈꠣꠍ ꠙꠛꠤꠔ꠆ꠞ। ");
INSERT INTO syls_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠞꠦ ꠎꠦ ꠎꠣꠉꠣꠔ ꠎꠛ ꠇꠞꠣ ꠅꠄ, ꠅꠃ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠞꠦꠅ ꠅꠘꠅ ꠎꠛ ꠇꠞꠔꠦ ꠅꠁꠛ। ꠁꠔꠣꠞ ꠟꠃ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠛꠣꠄ ꠍꠤꠐꠣꠁ ꠖꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","ꠀꠞ ꠁꠔꠣꠞ ꠢꠇꠟ ꠌꠞ꠆ꠛꠤꠞꠦ ꠟꠁꠛ, ꠝꠣꠘꠤ ꠌꠞ꠆ꠛꠤ ꠀꠟꠣ ꠟꠦꠋꠉꠥꠠ, ꠙꠦꠐꠞ ꠜꠤꠔꠞꠞ ꠢꠇꠟꠔꠣꠞ ꠃꠙꠞꠞ ꠌꠞ꠆ꠛꠤ, ");
INSERT INTO syls_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ꠄꠞ ꠟꠉꠦ ꠖꠥꠁꠅ ꠇꠤꠒꠘꠤ ꠀꠞ ꠅꠔꠣꠞ ꠃꠙꠞꠞ ꠌꠞ꠆ꠛꠤ, ꠀꠞ ꠇꠁꠟꠎꠣꠞ ꠟꠉꠞ ꠝꠣꠐꠤꠀ, ꠁ ꠢꠇꠟꠔꠣ ꠀꠟꠉꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","ꠀꠟꠉꠣꠁꠀ ꠁꠝꠣꠝꠦ ꠅꠃ ꠢꠇꠟꠔꠣ ꠘꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠎꠣꠟꠣꠁꠟꠤꠛꠣ, ꠁꠔꠣ ꠅꠁꠟ ꠖꠥꠡ-ꠇꠍꠥꠞꠤꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ। ");
INSERT INTO syls_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","ꠇꠥꠞꠛꠣꠘꠤꠞ ꠉꠥꠡ꠆ꠔ ꠁꠝꠣꠝ ꠙꠞꠤꠛꠣꠞꠞ ꠎꠦꠇꠥꠘꠥ ꠛꠦꠐꠣ ꠝꠣꠘꠡꠦ ꠈꠣꠁꠔꠣ ꠙꠣꠞꠛꠣ। ꠁꠔꠣ ꠔ ꠈꠣꠍ ꠙꠛꠤꠔ꠆ꠞ ꠎꠤꠘꠤꠡ, ꠄꠞꠟꠣꠉꠤ ꠔꠣꠞꠣ ꠎꠦꠇꠥꠘꠥ ꠙꠣꠇ ꠎꠣꠉꠣꠔ ꠛꠁꠀ ꠈꠣꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠞ ꠖꠥꠡ-ꠇꠍꠥꠞꠤꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠔ ꠄꠇꠁ ꠘꠝꠥꠘꠣꠞ। ꠎꠦ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠅꠃ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞꠦ ꠀꠖꠣꠄ ꠇꠞꠛꠣ, ꠄꠁꠘ ꠅꠃ ꠉꠥꠡ꠆ꠔ ꠙꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","ꠀꠞ ꠎꠦ ꠁꠝꠣꠝꠦ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠛꠣ, ꠄꠁꠘ ꠅꠃ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠞ ꠌꠣꠝꠠꠣꠅ ꠘꠤꠔꠣ ꠙꠣꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","ꠟꠥꠀꠠꠤꠔ, ꠔꠣꠅꠀꠔ ꠛꠣ ꠔꠥꠘ꠆ꠖꠥꠞꠤ ꠃꠘ꠆ꠖꠣꠟꠅ ꠢꠦꠖꠤꠀ ꠀꠘꠣ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠞꠥꠐꠤ ꠈꠣꠟꠤ ꠢꠃ ꠁꠝꠣꠝꠦ ꠙꠣꠁꠛꠣ, ꠎꠦꠁꠘ ꠁ ꠍꠖꠉꠣ ꠀꠖꠣꠄ ꠇꠞꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","ꠅꠁꠟꠦ ꠗꠣꠘ-ꠉꠝꠞ ꠛꠣꠖ-ꠛꠣꠇꠤ ꠢꠇꠟ ꠍꠖꠉꠣ, ꠁꠔꠣ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠛꠣ ꠢꠥꠇꠘꠣ ꠎꠦꠇꠥꠘꠥ ꠟꠣꠈꠣꠘ ꠅꠃꠇ, ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠢꠇꠟ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠁꠔꠣꠞ ꠢꠝꠣꠘ ꠛꠣꠐ ꠙꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠖꠦꠅꠀ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠘꠤꠅꠝ ꠅꠁꠟ, ");
INSERT INTO syls_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠝꠣꠛꠥꠖꠞ ꠡꠥꠇꠞꠤꠀ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠈꠤꠀꠟꠦ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠄ, ꠔꠦ ꠅꠃ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠞ ꠟꠉꠦ ꠔꠦꠟ ꠝꠤꠡꠣꠁꠟ ꠘꠤꠞꠦꠇ ꠝꠄꠖꠣ ꠖꠤꠀ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠞꠥꠐꠤ ꠛꠣ ꠛꠣꠘꠣꠁꠟ ꠞꠥꠐꠤꠔ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠀ ꠟꠁꠀ ꠀꠁꠛ, ꠛꠣ ꠔꠦꠟ ꠝꠤꠡꠣꠁꠟ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠘꠤꠞꠦꠇ ꠝꠄꠖꠣꠞ ꠙꠤꠑꠣ ꠛꠣꠘꠣꠁꠀ ꠀꠘꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","ꠡꠥꠇꠞꠤꠀ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠈꠤꠀꠟꠦ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠎꠤꠘꠤꠡꠞ ꠟꠉꠦ ꠈꠣꠝꠤꠞ ꠀꠟꠣ ꠕꠥꠠꠣ ꠞꠥꠐꠤꠅ ꠀꠘꠛ। ");
INSERT INTO syls_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠖꠦꠅꠀꠞ ꠟꠣꠉꠤ ꠢꠦ ꠅꠃ ꠙꠞꠔꠦꠇ ꠎꠤꠘꠤꠡ ꠕꠣꠇꠤ ꠄꠇꠐꠣ ꠄꠇꠐꠣ ꠇꠞꠤ ꠀꠘꠛ। ꠎꠦ ꠁꠝꠣꠝꠦ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠞ ꠟꠃ ꠍꠤꠐꠣꠁꠛꠣ, ꠄꠁꠘ ꠁꠔꠣ ꠙꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","ꠡꠥꠇꠥꠞꠣꠘꠣ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠖꠦꠅꠀ ꠅꠃ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠉꠥꠡ꠆ꠔ ꠅꠃ ꠖꠤꠘꠃ ꠈꠣꠁꠟꠤꠔꠦ ꠅꠁꠛ। ꠁꠔꠣ ꠛꠣꠖꠞ ꠖꠤꠘ ꠛꠤꠀꠘꠇꠥꠞ ꠟꠣꠉꠤ ꠕꠅꠀ ꠎꠣꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ꠅꠃ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠝꠣꠘ꠆ꠘꠔ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠖꠦꠅ, ꠛꠣ ꠄꠝꠘꠦ ꠈꠥꠡꠤ ꠅꠁꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅ, ꠔꠦ ꠁꠔꠣꠞ ꠉꠥꠡ꠆ꠔ ꠅꠃ ꠖꠤꠘꠃ ꠈꠣꠁꠅ, ꠀꠞ ꠇꠤꠍꠥ ꠛꠣꠇꠤ ꠞꠁꠟꠦ ꠛꠣꠖꠞ ꠖꠤꠘꠅ ꠈꠣꠁꠔꠣꠄ ꠙꠣꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","ꠅꠁꠟꠦ ꠖꠥꠁ ꠖꠤꠘ ꠛꠣꠖꠦ ꠁ ꠉꠥꠡ꠆ꠔ ꠞꠁꠟꠦ, ꠁꠔꠣ ꠎꠣꠟꠣꠁꠟꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","ꠔꠤꠘ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠁ ꠉꠥꠡ꠆ꠔ ꠈꠣꠁꠟꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠛꠥꠟ ꠅꠁꠔ ꠘꠣꠄ। ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅꠞꠣꠞ ꠀꠝꠟ-ꠘꠣꠝꠣꠔ ꠁꠔꠣ ꠃꠐꠔ ꠘꠣꠄ, ꠅꠃ ꠉꠥꠡ꠆ꠔ ꠔ ꠘꠣꠙꠣꠇ ꠅꠁꠉꠦꠍꠦ, ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠁꠔꠣ ꠈꠣꠁꠟꠦ ꠔꠣꠞꠦ ꠘꠣꠚꠞꠝꠣꠘ ꠢꠤꠡꠣꠛꠦ ꠉꠘꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠉꠥꠡ꠆ꠔꠞ ꠝꠣꠎꠦ ꠘꠣꠙꠣꠇ ꠇꠥꠘꠥ ꠎꠤꠘꠤꠡ ꠟꠣꠉꠤꠉꠦꠟꠦ, ꠁ ꠉꠥꠡ꠆ꠔꠞ ꠁ ꠅꠋꠡ ꠀꠞ ꠈꠣꠅꠀ ꠎꠣꠁꠔ ꠘꠣꠄ, ꠁꠔꠣ ꠎꠣꠟꠣꠁꠟꠤꠛꠣ। ꠅꠁꠟꠦ ꠛꠣꠇꠤ ꠉꠥꠡ꠆ꠔ ꠈꠣꠅꠀ ꠎꠣꠁꠛ, ꠙꠣꠇ-ꠍꠣꠚ ꠢꠣꠟꠔꠦ ꠎꠦ ꠇꠥꠘꠥ ꠎꠘꠦ ꠁꠔꠣ ꠈꠣꠁꠔꠣ ꠙꠣꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ꠀꠞ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠖꠦꠅꠀ ꠅꠃ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠉꠥꠡ꠆ꠔ ꠈꠣꠁꠟꠣꠄ, ꠔꠦ ꠡꠝꠣꠎ ꠕꠣꠇꠤ ꠔꠣꠞ ꠘꠣꠝ ꠝꠤꠐꠣꠁꠟꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠙꠡꠥꠞ ꠛꠣ ꠝꠣꠘꠡꠞ ꠇꠥꠘꠥ ꠘꠣꠙꠣꠇ ꠎꠤꠘꠤꠡ ꠍꠁꠀ ꠢꠣꠞꠤ ꠛꠣ ꠖꠥꠍꠞꠣ ꠘꠣꠙꠣꠇ ꠇꠥꠘ꠆ꠔꠣ ꠍꠁꠀ ꠢꠣꠞꠤ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠖꠦꠅꠀ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠉꠥꠡ꠆ꠔ ꠈꠣꠁꠟꠣꠄ, ꠔꠦ ꠔꠣꠞ ꠘꠣꠝꠅ ꠡꠝꠣꠎ ꠕꠣꠇꠤ ꠝꠤꠐꠣꠁꠟꠤꠔꠦ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠔꠥꠝꠞꠣ ꠉꠞꠥ-ꠍꠣꠉꠟ ꠛꠣ ꠝꠦꠠꠣꠞ ꠇꠥꠘꠥꠎꠣꠔ ꠌꠞ꠆ꠛꠤ ꠈꠣꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","ꠇꠥꠘꠥ ꠝꠞꠣ ꠙꠡꠥꠞ ꠛꠣ ꠎꠋꠟꠤ ꠎꠣꠘꠥꠀꠞꠦ ꠝꠣꠞꠣ ꠙꠡꠥꠞ ꠌꠞ꠆ꠛꠤꠞꠦ ꠔꠥꠝꠞꠣ ꠅꠁꠘ꠆ꠘ ꠇꠥꠘꠥ ꠇꠣꠝꠅ ꠟꠣꠉꠣꠁꠔꠣꠄ ꠙꠣꠞꠛꠣꠄ, ꠅꠁꠟꠦ ꠈꠣꠁꠔꠣꠄ ꠙꠣꠞꠔꠣꠄ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","ꠎꠔ ꠘꠝꠥꠘꠣꠞ ꠙꠡꠥ ꠖꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠣ ꠅꠄ, ꠁꠔꠣ ꠎꠣꠔꠞ ꠙꠡꠥꠞ ꠌꠞ꠆ꠛꠤ ꠎꠦꠉꠥꠄ ꠈꠣꠁꠛ, ꠔꠣꠞ ꠘꠣꠝꠞꠦ ꠡꠝꠣꠎ ꠕꠣꠇꠤ ꠝꠤꠐꠣꠁꠟꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","ꠔꠥꠝꠞꠣ ꠎꠦꠇꠥꠘꠥ ꠎꠣꠉꠣꠔ ꠛꠡꠔ ꠇꠞꠅ ꠘꠣ ꠇꠦꠘꠦ, ꠇꠥꠘꠥꠎꠣꠔ ꠙꠡꠥ ꠛꠣ ꠙꠣꠈꠤꠞ ꠟꠃ ꠈꠣꠅꠀ ꠎꠣꠁꠎ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠟꠃ ꠈꠣꠄ, ꠔꠦ ꠡꠝꠣꠎ ꠕꠣꠇꠤ ꠔꠣꠞ ꠘꠣꠝ ꠝꠤꠐꠣꠁꠟꠤꠔꠦ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠎꠦꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠇꠥꠘꠥ ꠙꠡꠥ ꠖꠤꠀ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠟꠦ, ꠇꠥꠞꠛꠣꠘꠤꠞ ꠉꠥꠡ꠆ꠔꠞ ꠄꠇꠐꠣ ꠅꠋꠡ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠖꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠅꠃ ꠅꠋꠡ, ꠝꠣꠘꠤ ꠍꠤꠘꠣ ꠀꠞ ꠍꠤꠘꠣꠞ ꠃꠙꠞꠞ ꠌꠞ꠆ꠛꠤ ꠢꠦ ꠘꠤꠎꠞ ꠀꠔꠦ ꠀꠘꠤꠀ ꠁꠝꠣꠝ ꠍꠣꠛꠞꠦ ꠖꠤꠛ। ꠁꠝꠣꠝꠦ ꠁꠔꠣꠞꠦ ꠃꠌꠣ ꠇꠞꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠖꠥꠟꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠌꠞ꠆ꠛꠤꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠎꠣꠟꠣꠁꠟꠤꠛꠣ, ꠅꠁꠟꠦ ꠅꠃ ꠍꠤꠘꠣꠞ ꠉꠥꠡ꠆ꠔ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠙꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠞ ꠒꠣꠁꠘꠞ ꠞꠣꠘꠞ ꠉꠥꠡ꠆ꠔ ꠁꠝꠣꠝ ꠍꠣꠛꠞꠦ ꠖꠤꠟꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠛꠋꠡꠞ ꠎꠦ ꠇꠦꠃ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠞ ꠟꠃ ꠀꠞ ꠌꠞ꠆ꠛꠤꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣ, ꠔꠣꠘ ꠙꠣꠅꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠅꠃ ꠞꠣꠘꠞ ꠉꠥꠡ꠆ꠔ ꠘꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠖꠦꠅꠀ ꠢꠇꠟ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠉꠥꠡ꠆ꠔ ꠕꠣꠇꠤ ꠖꠥꠟꠘꠣ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠍꠤꠘꠣ ꠀꠞ ꠒꠣꠁꠘꠞ ꠞꠣꠘꠞ ꠉꠥꠡ꠆ꠔ ꠀꠝꠤ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠖꠤꠟꠣꠝ। ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠁ ꠅꠋꠡ ꠅꠁꠟ ꠔꠣꠞꠣꠞ ꠢꠣꠝꠦꠡꠣꠇꠥꠞ ꠙꠣꠅꠘꠣ ꠢꠇ।” ");
INSERT INTO syls_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠎꠦꠖꠤꠘ ꠕꠣꠇꠤ ꠁꠝꠣꠝꠔꠤꠞ ꠇꠣꠝꠅ ꠛꠅꠀꠁꠟ ꠇꠞꠣ ꠅꠁꠍꠤꠟ, ꠢꠃ ꠖꠤꠘ ꠕꠣꠇꠤ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠢꠇꠟ ꠘꠝꠥꠘꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠅꠃ ꠅꠋꠡꠞꠦ ꠔꠣꠞꠣꠞ ꠙꠣꠅꠘꠣ ꠢꠇ ꠢꠤꠡꠣꠛꠦ ꠗꠞꠣ ꠅꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","ꠔꠣꠞꠣꠞꠦ ꠎꠦꠖꠤꠘ ꠈꠦꠟꠣꠚꠔꠤ ꠡꠝꠎꠣꠁꠀ ꠛꠅꠀꠁꠟ ꠇꠞꠣ ꠅꠁꠍꠦ, ꠢꠃ ꠖꠤꠘ ꠝꠣꠛꠥꠖꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠇꠥꠞꠛꠣꠘꠤꠞ ꠉꠥꠡ꠆ꠔꠞ ꠅꠃ ꠅꠋꠡ ꠢꠞ-ꠢꠣꠝꠦꠡꠣ ꠄꠞꠣꠞꠦ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","ꠁꠔꠣ ꠅꠁꠟ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ, ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ, ꠖꠥꠡ-ꠇꠍꠥꠞꠤꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ, ꠁꠝꠣꠝꠔꠤ ꠡꠝꠎꠤꠛꠣꠞ ꠍꠖꠉꠣ, ꠀꠞ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠘꠤꠅꠝ। ");
INSERT INTO syls_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","ꠍꠤꠘꠣꠁ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠝꠣꠛꠥꠖꠦ ꠎꠦꠖꠤꠘ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ ꠔꠣꠘ ꠘꠣꠝꠦ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠎꠤꠘꠤꠡ ꠀꠘꠣꠞ ꠟꠣꠉꠤ, ꠢꠃ ꠖꠤꠘ ꠔꠣꠁꠘ ꠔꠥꠞ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠅꠃ ꠢꠇ꠆ꠇꠟ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠎꠣꠘꠣꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“ꠔꠥꠝꠤ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠟꠁꠀ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠀꠎꠤꠞ ꠅꠅ। ꠄꠞ ꠟꠉꠦ ꠔꠣꠞꠣꠞ ꠁꠝꠣꠝꠔꠤꠞ ꠟꠦꠛꠣꠍ, ꠈꠦꠟꠣꠚꠔꠤ ꠡꠝꠎꠤꠛꠣꠞ ꠔꠦꠟ, ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠛꠤꠍꠣꠟ, ꠖꠥꠉꠥ ꠝꠦꠠꠣꠞ ꠙꠣꠑꠣ ꠀꠞ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠞꠥꠐꠤꠞ ꠐꠥꠇꠞꠤꠅ ꠀꠘꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ꠀꠞ ꠔꠥꠝꠤ ꠔꠣꠝꠣꠝ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠖꠟꠣ ꠇꠞꠅ।” ");
INSERT INTO syls_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","ꠔꠦꠃ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠢꠇꠟꠔꠣ ꠇꠞꠟꠣ, ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠖꠟꠣ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","ꠅꠃ ꠡꠝꠄ ꠝꠥꠍꠣꠄ ꠄꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠂꠘ ꠁꠔꠣ ꠇꠞꠣꠞ ꠟꠣꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","ꠅꠈꠣꠘ ꠇꠁꠀ ꠔꠣꠁꠘ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠍꠣꠝꠘꠦ ꠀꠘꠤꠀ ꠙꠣꠘꠤ ꠖꠤꠀ ꠘꠣꠅꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠢꠣꠞꠥꠘꠞꠦ ꠁꠝꠣꠝꠔꠤ ꠟꠦꠛꠣꠍꠞ ꠙꠣꠁꠘ꠆ꠎꠣꠛꠤ ꠚꠤꠘ꠆ꠖꠣꠁꠀ ꠢꠣꠞꠤ ꠇꠝꠞꠞ ꠛꠘ꠆ꠖꠘꠤ ꠛꠣꠘ꠆ꠖꠤꠀ ꠖꠤꠟꠣ। ꠔꠣꠁꠘ ꠀꠟꠈꠦꠟ꠆ꠟꠣ ꠀꠞ ꠄꠚꠞꠘ ꠚꠤꠘ꠆ꠖꠣꠁꠀ ꠙꠦꠐꠞ ꠃꠙꠞꠞ ꠘꠇꠡꠣ ꠇꠞꠣ ꠇꠣꠙꠠꠞꠦ ꠚꠤꠔꠣꠖꠤ ꠛꠣꠘ꠆ꠖꠤ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","ꠛꠣꠖꠦ ꠛꠥꠇꠥꠞ ꠃꠙꠞꠞ ꠕꠟꠤ ꠚꠤꠘ꠆ꠖꠣꠁꠀ ꠄꠞ ꠜꠤꠔꠞꠦ ꠙꠛꠤꠔ꠆ꠞ ꠃꠞꠤꠝ ꠀꠞ ꠔꠥꠝ꠆ꠝꠤꠝ ꠢꠣꠞꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","ꠄꠞꠛꠣꠖꠦ ꠢꠣꠞꠥꠘꠞ ꠝꠣꠕꠣꠔ ꠙꠣꠃꠉꠠꠤ ꠚꠤꠘ꠆ꠖꠣꠁꠀ ꠢꠃ ꠙꠛꠤꠔ꠆ꠞ ꠔꠣꠎ, ꠝꠣꠘꠤ ꠡꠥꠘꠣꠞ ꠙꠣꠔꠈꠣꠘ ꠙꠣꠃꠉꠠꠤꠞ ꠍꠣꠝꠘꠣꠛꠣꠄ ꠟꠣꠉꠣꠁꠟꠣ। ꠝꠥꠍꠣꠄ ꠁ ꠢꠇꠟꠔꠣ ꠇꠞꠟꠣ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ। ");
INSERT INTO syls_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥ ꠀꠞ ꠄꠞ ꠜꠤꠔꠞꠞ ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣꠞꠦ ꠈꠦꠟꠣꠚꠔꠤꠞ ꠔꠦꠟ ꠖꠤꠀ ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","ꠅꠃ ꠔꠦꠟ ꠕꠣꠇꠤ ꠕꠥꠠꠣ ꠔꠦꠟ ꠘꠤꠀ ꠔꠣꠁꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠡꠣꠔ ꠛꠣꠞ ꠍꠤꠐꠣꠁꠟꠣ। ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠀꠞ ꠄꠞ ꠟꠉꠞ ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ, ꠢꠣꠘ꠆ꠒꠤ-ꠛꠣꠡꠘ, ꠀꠞ ꠅꠎꠥꠞ ꠙꠣꠘꠤꠞ ꠉꠣꠝꠟꠣ ꠀꠞ ꠄꠞ ꠔꠟꠞ ꠌꠇꠤ-ꠈꠣꠐꠞꠦ, ꠔꠦꠟ ꠖꠤꠀ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","ꠀꠞꠅ ꠕꠥꠠꠣ ꠔꠦꠟ ꠘꠤꠀ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠝꠣꠕꠣꠞ ꠝꠣꠎꠦ ꠓꠣꠟꠤꠀ ꠔꠣꠘꠞꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠛꠘꠣꠞ ꠟꠣꠉꠤ ꠈꠦꠟꠣꠚꠔꠤ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","ꠀꠞ ꠢꠣꠞꠥꠘꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠍꠣꠝꠘꠦ ꠀꠘꠤꠀ ꠔꠣꠞꠣꠞ ꠉꠔꠞꠅ ꠙꠣꠁꠘ꠆ꠎꠣꠛꠤ ꠚꠤꠘ꠆ꠖꠣꠁꠟꠣ, ꠇꠝꠞꠞ ꠛꠘ꠆ꠖꠘꠤ ꠛꠣꠘ꠆ꠖꠤꠀ ꠢꠣꠞꠤ ꠝꠣꠕꠣꠞ ꠔꠇꠤ ꠚꠤꠘ꠆ꠖꠣꠁꠟꠣ। ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠇꠞꠟꠣ ꠔꠣꠁꠘ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ। ");
INSERT INTO syls_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","ꠄꠞꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠛꠤꠍꠣꠟ ꠀꠘꠟꠣ, ꠀꠘꠟꠦ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠛꠤꠍꠣꠟꠞ ꠇꠟ꠆ꠟꠣ ꠀꠔꠣꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","ꠔꠦꠃ ꠝꠥꠍꠣꠄ ꠅꠃ ꠛꠤꠍꠣꠟꠞꠦ ꠎꠛ ꠇꠞꠤꠀ ꠅꠉꠥꠞ ꠇꠤꠍꠥ ꠟꠃ ꠘꠤꠀ, ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠞꠣꠞ ꠈꠤꠀꠟꠦ ꠅꠈꠣꠘꠞ ꠢꠤꠋ ꠅꠇꠟꠞ ꠝꠣꠎꠦ ꠀꠔꠞ ꠀꠋꠉꠥꠁꠟꠖꠤ ꠟꠃ ꠝꠣꠈꠣꠁꠟꠣ। ꠛꠣꠇꠤ ꠟꠃ ꠔꠣꠁꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠔꠟꠦ ꠓꠣꠟꠤ ꠖꠤꠟꠣ। ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠔꠣꠁꠘ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠃ ꠖꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠛꠤꠍꠣꠟꠞ ꠙꠦꠐꠞ ꠜꠤꠔꠞꠞ ꠢꠇꠟ ꠌꠞ꠆ꠛꠤ, ꠇꠁꠟꠎꠣꠞ ꠟꠉꠞ ꠝꠣꠐꠤꠀ, ꠌꠞ꠆ꠛꠤ ꠡꠝꠦꠔ ꠖꠥꠁꠅ ꠇꠤꠒꠘꠤ ꠘꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠎꠣꠟꠣꠁꠟꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","ꠅꠁꠟꠦ ꠛꠤꠍꠣꠟꠞ ꠈꠣꠟ, ꠉꠥꠡ꠆ꠔ, ꠉꠥꠚꠞ ꠘꠤꠀ ꠔꠣꠁꠘ ꠇꠦꠝ꠆ꠙꠞ ꠛꠣꠞꠦ ꠎꠣꠟꠣꠁꠟꠣ। ꠝꠥꠍꠣꠄ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠇꠞꠟꠣ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ। ");
INSERT INTO syls_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠝꠦꠠꠣꠞ ꠙꠣꠑꠣꠞꠦ ꠀꠘꠟꠣ। ꠀꠘꠟꠦ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠅꠉꠥꠞ ꠇꠟ꠆ꠟꠣ ꠀꠔꠣꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","ꠀꠞ ꠝꠥꠍꠣꠄ ꠅꠃ ꠝꠦꠠꠣꠞꠦ ꠎꠛ ꠇꠞꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠔ ꠟꠃ ꠍꠤꠐꠣꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","ꠔꠣꠁꠘ ꠝꠦꠠꠣꠞꠦ ꠐꠥꠇꠞꠣꠁꠀ ꠅꠉꠥꠞ ꠇꠟ꠆ꠟꠣ, ꠉꠥꠡ꠆ꠔꠞ ꠐꠥꠇꠞꠣ ꠀꠞ ꠌꠞ꠆ꠛꠤꠞꠦ ꠎꠣꠟꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","ꠀꠞ ꠅꠃ ꠝꠦꠠꠣꠞ ꠙꠦꠐꠞ ꠜꠤꠔꠞꠞ ꠢꠇꠟꠔꠣ, ꠔꠣꠞ ꠌꠣꠁꠞꠅ ꠑꠦꠋ ꠙꠣꠘꠤ ꠖꠤꠀ ꠗꠁꠀ ꠢꠣꠞꠤ, ꠀꠡ꠆ꠔꠣ ꠝꠦꠠꠣꠞꠦ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠎꠣꠟꠣꠁꠟꠤꠟꠣ। ꠁꠔꠣ ꠔ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠁꠔꠣꠞ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠔꠣꠁꠘ ꠈꠥꠡꠤ ꠅꠁꠘ। ꠝꠥꠍꠣꠄ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠇꠞꠟꠣ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ। ");
INSERT INTO syls_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠁꠝꠣꠝꠔꠤ ꠇꠣꠝꠅ ꠛꠅꠀꠁꠟꠞ ꠘꠤꠅꠔꠦ, ꠖꠥꠍꠞꠣ ꠝꠦꠠꠣꠞꠦ ꠀꠘꠤꠀ ꠢꠣꠞꠟꠦ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠝꠦꠠꠣꠞ ꠇꠟ꠆ꠟꠣ ꠀꠔꠣꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","ꠝꠥꠍꠣꠄ ꠅꠃ ꠝꠦꠠꠣꠞꠦ ꠎꠛ ꠇꠞꠤꠀ, ꠅꠉꠥꠞ ꠕꠥꠠꠣ ꠟꠃ ꠘꠤꠀ ꠢꠣꠞꠥꠘꠞ ꠒꠣꠁꠘ ꠇꠣꠘꠞ ꠟꠔꠤꠔ, ꠒꠣꠁꠘ ꠀꠔꠞ ꠀꠞ ꠒꠣꠁꠘ ꠙꠣꠅꠞ ꠛꠥꠠꠤ ꠀꠋꠉꠥꠟꠤꠔ ꠟꠣꠉꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","ꠀꠞ ꠢꠣꠞꠥꠘꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦꠅ ꠍꠣꠝꠘꠦ ꠀꠘꠤꠀ, ꠔꠣꠞꠣꠞ ꠒꠣꠁꠘ ꠇꠣꠘꠞ ꠟꠔꠤꠔ, ꠀꠞ ꠒꠣꠁꠘ ꠀꠔ, ꠒꠣꠁꠘ ꠙꠣꠅꠞ ꠛꠥꠠꠤ ꠀꠋꠉꠥꠟꠤꠔ ꠕꠥꠠꠣ ꠟꠃ ꠟꠣꠉꠣꠁ ꠖꠤꠟꠣ। ꠀꠞꠅ ꠕꠥꠠꠣ ꠟꠃ ꠘꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠔ ꠍꠤꠐꠣꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","ꠔꠣꠁꠘ ꠝꠦꠠꠣꠞ ꠌꠞ꠆ꠛꠤ, ꠌꠞ꠆ꠛꠤ ꠀꠟꠣ ꠟꠦꠋꠉꠥꠠ, ꠇꠁꠟꠎꠣꠞ ꠟꠉꠞ ꠝꠣꠐꠤꠀ, ꠌꠞ꠆ꠛꠤ ꠡꠝꠦꠔ ꠖꠥꠁꠅ ꠇꠤꠒꠘꠤ, ꠀꠞ ꠒꠣꠁꠘꠞ ꠞꠣꠘ ꠘꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","ꠀꠞ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠕꠅꠀ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠞꠥꠐꠤꠞ ꠐꠥꠇꠞꠤ ꠕꠣꠇꠤ ꠄꠇꠈꠣꠘ ꠞꠥꠐꠤ, ꠀꠞ ꠔꠦꠟꠖꠤ ꠜꠣꠎꠣ ꠄꠇꠈꠣꠘ ꠙꠤꠑꠣ, ꠀꠞ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠄꠇꠈꠣꠘ ꠞꠥꠐꠤ ꠘꠤꠀ ꠢꠃ ꠌꠞ꠆ꠛꠤ ꠀꠞ ꠞꠣꠘꠞ ꠃꠙꠞꠦ ꠕꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","ꠕꠁꠀ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠀꠔꠅ ꠖꠤꠀ ꠖꠥꠟꠘꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠖꠥꠟꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠁꠔꠣ ꠔꠣꠞꠣꠞ ꠀꠔ ꠕꠣꠇꠤ ꠘꠤꠀ ꠢꠣꠞꠤ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠙꠡꠥꠞ ꠃꠙꠞꠦ ꠕꠁꠀ ꠎꠣꠟꠣꠁꠟꠤꠟꠣ। ꠁꠔꠣ ꠔ ꠈꠦꠟꠣꠚꠔꠤ ꠡꠝꠎꠤꠛꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ, ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ, ꠁꠔꠣꠞ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠔꠣꠁꠘ ꠈꠥꠡꠤ ꠅꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠘꠤꠎꠞ ꠙꠣꠅꠘꠣ ꠅꠋꠡ, ꠝꠣꠘꠤ ꠈꠦꠟꠣꠚꠔꠤ ꠡꠝꠎꠤꠛꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠝꠦꠠꠣꠞ ꠍꠤꠘꠣ ꠘꠤꠀ ꠖꠥꠟꠘꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠖꠥꠟꠣꠁꠟꠣ। ꠔꠣꠁꠘ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠇꠞꠟꠣ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ। ");
INSERT INTO syls_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","ꠛꠣꠖꠦ ꠝꠥꠍꠣꠄ ꠈꠦꠟꠣꠚꠔꠤ ꠡꠝꠎꠤꠛꠣꠞ ꠕꠥꠠꠣ ꠙꠛꠤꠔ꠆ꠞ ꠔꠦꠟ ꠘꠤꠟꠣ, ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠕꠣꠇꠤ ꠕꠥꠠꠣ ꠟꠃ ꠀꠘꠤꠀ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠃꠙꠞꠦ ꠀꠞ ꠔꠣꠞꠣꠞ ꠟꠦꠛꠣꠍꠞ ꠃꠙꠞꠦ ꠍꠤꠐꠣꠁ ꠖꠤꠟꠣ। ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ, ꠀꠞ ꠔꠣꠞꠣꠞ ꠟꠦꠛꠣꠍꠞꠦꠅ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","ꠛꠣꠖꠦ ꠝꠥꠍꠣꠄ ꠢꠣꠞꠥꠘ ꠀꠞ ꠄꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠍꠣꠝꠘꠦ ꠅꠃ ꠉꠥꠡ꠆ꠔ ꠞꠣꠘ꠆ꠖꠅ, ꠞꠣꠘ꠆ꠖꠤꠀ ꠢꠘꠅ ꠛꠁꠀ ꠈꠦꠟꠣꠚꠔꠤ ꠡꠝꠎꠤꠛꠣꠞ ꠐꠥꠇꠞꠤꠞ ꠞꠥꠐꠤ ꠖꠤꠀ ꠅꠔꠣ ꠈꠣꠅ। ꠀꠝꠣꠞꠦ ꠔ ꠀꠉꠦ ꠅꠃ ꠇꠕꠣ ꠎꠣꠘꠣꠁꠟ ꠅꠁꠍꠦ, ꠁꠔꠣ ꠈꠣꠟꠤ ꠔꠥꠝꠤ ꠀꠞ ꠔꠥꠝꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠈꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","ꠈꠣꠘꠤꠞ ꠛꠣꠖꠦ ꠎꠦꠔꠣ ꠉꠥꠡ꠆ꠔ ꠀꠞ ꠞꠥꠐꠤ ꠛꠣꠇꠤ ꠞꠁꠛ, ꠁꠔꠣꠞꠦ ꠀꠉꠥꠁꠘꠖꠤ ꠎꠣꠟꠣꠁꠟꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","ꠔꠥꠝꠞꠣꠞꠦ ꠈꠦꠟꠣꠚꠔꠤ ꠡꠝꠎꠤꠛꠣꠞ ꠅꠃ ꠝꠣꠢꠚꠤꠟ ꠡꠣꠔ ꠖꠤꠘ ꠗꠞꠤ ꠌꠟꠛ। ꠁ ꠡꠣꠔ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠇꠣꠘ꠆ꠖꠣ ꠕꠣꠇꠤ ꠢꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","ꠀꠁꠎ ꠎꠦꠔꠣ ꠇꠞꠟꠣꠝ, ꠁꠔꠣ ꠔ ꠔꠥꠝꠞꠣꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣ ꠢꠤꠡꠣꠛꠦ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠇꠞꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","ꠔꠦ ꠔꠥꠝꠞꠣ ꠎꠣꠘꠦ ꠛꠣꠌꠤꠀ ꠞꠅꠀꠞ ꠟꠣꠉꠤ ꠀꠁꠎ ꠕꠣꠇꠤ ꠡꠣꠔ ꠖꠤꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠅꠃ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠞꠁꠅ। ꠖꠤꠘ-ꠞꠣꠁꠔ ꠅꠘꠅ ꠞꠁꠀ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠇꠣꠝ ꠇꠞꠤꠅ। ꠔꠥꠝꠞꠣ ꠅꠟꠣ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠔ ꠀꠝꠤ ꠢꠥꠇꠥꠝ ꠙꠣꠁꠍꠤ।” ");
INSERT INTO syls_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","ꠝꠥꠍꠣ ꠘꠛꠤꠞ ꠝꠣꠎꠖꠤ ꠝꠣꠛꠥꠖꠦ ꠎꠔꠔꠣ ꠇꠞꠣꠞ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","ꠈꠦꠟꠣꠚꠔꠤ ꠡꠝꠎꠤꠛꠣꠞ ꠝꠣꠢꠚꠤꠟꠞ ꠀꠐ ꠖꠤꠘꠞ ꠖꠤꠘ ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞꠦ, ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟꠞꠦꠅ ꠀꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","ꠀꠘꠣꠁꠀ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠤ ꠄꠉꠥ ꠛꠤꠍꠣꠟ ꠀꠘꠅ, ꠀꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠝꠦꠠꠣꠞ ꠙꠣꠑꠣ ꠟꠁꠀ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠀꠎꠤꠞ ꠅꠅ। ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥ ꠉꠥꠁꠘ ꠙꠥꠞꠣꠙꠥꠞ ꠘꠤꠈꠥꠔ ꠅꠁꠔ। ");
INSERT INTO syls_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","ꠀꠞ ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠅ, ꠔꠣꠞꠣ ꠎꠣꠘꠥ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠟꠁꠀ ꠀꠎꠤꠞ ꠅꠄ। ꠔꠣꠞꠣ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠍꠣꠉꠟ, ꠀꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠘꠤꠈꠥꠔ ꠄꠉꠥ ꠉꠞꠥ-ꠛꠣꠍꠥꠞ, ꠀꠞ ꠄꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠀꠘꠦ, ");
INSERT INTO syls_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ꠀꠞ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠛꠤꠍꠣꠟ ꠀꠞ ꠄꠉꠥ ꠝꠦꠠꠣꠞ ꠙꠣꠑꠣ ꠟꠁꠀ ꠀꠎꠤꠞ ꠅꠄ। ꠁꠔꠣꠞ ꠟꠉꠦ ꠔꠣꠞꠣ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠅ ꠀꠘꠛꠣ। ꠝꠣꠛꠥꠖꠦ ꠔꠣꠞꠣꠞꠦ ꠀꠁꠎ ꠖꠤꠖꠣꠞ ꠖꠤꠛꠣ, ꠄꠞꠟꠣꠉꠤ ꠔꠣꠞꠣ ꠅꠔꠣ ꠟꠁꠀ ꠀꠎꠤꠞ ꠅꠃꠇ꠆ꠇꠣ।” ");
INSERT INTO syls_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","ꠝꠥꠍꠣ ꠘꠛꠤꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠔꠣꠞꠣ ꠢꠇ꠆ꠇꠟꠔꠣ ꠟꠁꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠍꠣꠝꠘꠦ ꠀꠁꠟꠣ। ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠀꠁꠀ ꠃꠛꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","ꠅꠃ ꠡꠝꠄ ꠝꠥꠍꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠁꠔꠣ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠂꠘ, ꠁꠔꠣ ꠀꠖꠣꠄ ꠇꠞꠟꠦ ꠔꠥꠝꠞꠣꠞ ꠍꠣꠝꠘꠦ ꠔꠣꠘ ꠇꠥꠖꠞꠔꠤ ꠘꠥꠞ ꠎꠣꠁꠞ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠉꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠎꠣꠅ, ꠉꠤꠀ ꠔꠥꠝꠣꠞ ꠘꠤꠎꠞ ꠀꠞ ꠝꠣꠘꠡꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠟꠣꠉꠤ, ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠅ। ꠀꠞ ꠝꠣꠘꠡꠞ ꠀꠘꠣ ꠇꠥꠞꠛꠣꠘꠤꠅ ꠀꠖꠣꠄ ꠇꠞꠅ, ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞꠦ ꠅꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","ꠔꠦꠃ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠉꠤꠀ, ꠔꠣꠘ ꠘꠤꠎꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠛꠣꠍꠥꠞ ꠎꠛ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","ꠎꠛꠞ ꠛꠣꠖꠦ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠅꠉꠥꠞ ꠟꠃ ꠟꠁꠀ ꠔꠣꠘ ꠗꠣꠞꠅ ꠉꠦꠟꠣ। ꠔꠣꠁꠘ ꠅꠃ ꠟꠃꠞ ꠝꠣꠎꠦ ꠀꠋꠉꠥꠟ ꠒꠥꠛꠣꠁꠀ ꠕꠥꠠꠣ ꠟꠃ ꠘꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠢꠤꠋ ꠅꠇꠟꠅ ꠝꠣꠈꠣꠁꠟꠣ, ꠀꠞ ꠛꠣꠇꠤ ꠟꠃ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠔꠟꠦ ꠓꠣꠟꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠦ ꠑꠤꠇ ꠅꠃ ꠟꠣꠈꠣꠘ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠛꠣꠍꠥꠞꠞ ꠌꠞ꠆ꠛꠤ, ꠖꠥꠁꠅ ꠇꠤꠒꠘꠤ ꠀꠞ ꠇꠁꠟꠎꠣꠞ ꠟꠉꠞ ꠝꠣꠐꠤꠀꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠘꠤꠀ ꠎꠣꠟꠣꠁꠟꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","ꠇꠥꠞꠛꠣꠘꠤꠞ ꠉꠥꠡ꠆ꠔ ꠀꠞ ꠌꠣꠝꠠꠣ ꠘꠤꠀ ꠔꠣꠁꠘ ꠇꠦꠝ꠆ꠙꠞ ꠛꠣꠞꠦ ꠎꠣꠟꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","ꠛꠣꠖꠦ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠦ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠝꠦꠠꠣꠞꠦ ꠎꠛ ꠇꠞꠟꠣ। ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠅꠉꠥꠞ ꠟꠃ ꠘꠤꠀ ꠔꠣꠘ ꠀꠔꠅ ꠖꠤꠟꠣ, ꠔꠣꠁꠘ ꠅꠃ ꠟꠃꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠔ ꠍꠤꠐꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","ꠔꠣꠞꠣ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠝꠦꠠꠣꠞ ꠇꠟ꠆ꠟꠣ ꠀꠞ ꠉꠥꠡ꠆ꠔꠞ ꠐꠥꠇꠞꠣꠁꠘ ꠄꠇ ꠄꠇ ꠇꠞꠤ ꠢꠣꠞꠥꠘꠞ ꠀꠔꠅ ꠖꠤꠟꠣ, ꠔꠣꠁꠘ ꠁꠔꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠎꠣꠟꠣꠁꠟꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","ꠝꠦꠠꠣꠞ ꠑꠦꠋ ꠀꠞ ꠙꠦꠐꠞ ꠜꠤꠔꠞꠞ ꠢꠇꠟꠔꠣ ꠙꠣꠘꠤ ꠖꠤꠀ ꠗꠁꠀ ꠍꠣꠚ ꠇꠞꠤꠀ, ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠙꠡꠥꠞ ꠟꠉꠦ ꠁꠔꠣ ꠢꠇ꠆ꠇꠟꠔꠣꠅ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠎꠣꠟꠣꠁꠟꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠡꠝꠣꠎꠞ ꠝꠣꠘꠡꠞ ꠟꠣꠉꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥ ꠅꠇꠟ ꠀꠘꠣꠁꠟꠣ। ꠔꠣꠁꠘ ꠝꠣꠘꠡꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠍꠣꠉꠟ ꠎꠛ ꠇꠞꠟꠣ, ꠀꠞ ꠀꠉꠞ ꠟꠣꠈꠣꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","ꠄꠞꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠔꠣꠞꠣꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠞꠦꠅ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","ꠀꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠟꠣꠉꠤ ꠀꠘꠣ ꠍꠣꠝꠣꠘꠣ ꠕꠣꠇꠤ ꠄꠇ ꠝꠥꠁꠐ ꠘꠤꠀ ꠢꠣꠞꠤ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠎꠣꠟꠣꠁꠟꠣ। ꠁꠔꠣ ꠍꠣꠠꠣꠅ ꠔꠣꠁꠘ ꠛꠤꠀꠘꠤ ꠛꠣꠟꠣꠞ ꠢꠣꠝꠦꠡꠣꠇꠥꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","ꠔꠣꠁꠘ ꠝꠣꠘꠡꠞ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠅꠃ ꠉꠞꠥ ꠀꠞ ꠝꠦꠠꠣꠞꠦ ꠎꠛ ꠇꠞꠟꠣ। ꠎꠛꠞ ꠛꠣꠖꠦ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠅꠉꠥꠞ ꠟꠃ ꠀꠘꠤꠀ ꠔꠣꠘ ꠀꠔꠅ ꠖꠤꠟꠣ, ꠟꠃ ꠘꠤꠀ ꠔꠣꠁꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠔ ꠍꠤꠐꠣꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","ꠀꠞ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞꠦ ꠢꠃ ꠉꠞꠥ ꠀꠞ ꠝꠦꠠꠣꠞ ꠟꠉꠦ ꠟꠣꠉꠣꠁꠟ ꠢꠇꠟ ꠌꠞ꠆ꠛꠤ, ꠝꠣꠘꠤ ꠌꠞ꠆ꠛꠤ ꠀꠟꠣ ꠟꠦꠋꠉꠥꠠ, ꠙꠦꠐꠞ ꠜꠤꠔꠞꠞ ꠢꠇꠟꠔꠣꠞ ꠃꠙꠞꠞ ꠌꠞ꠆ꠛꠤ, ꠖꠥꠁꠅ ꠇꠤꠒꠘꠤ ꠀꠞ ꠅꠔꠣꠞ ꠃꠙꠞꠞ ꠌꠞ꠆ꠛꠤ, ꠇꠁꠟꠎꠣꠞ ꠟꠉꠞ ꠝꠣꠐꠤꠀꠅ ꠀꠘꠤꠀ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ꠔꠣꠞꠣ ꠅꠃ ꠢꠇꠟ ꠌꠞ꠆ꠛꠤꠞꠦ ꠢꠃ ꠙꠡꠥꠞ ꠍꠤꠘꠣꠞ ꠃꠙꠞꠦ ꠕꠁꠟꠣ। ꠀꠞ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠦ ꠅꠃ ꠌꠞ꠆ꠛꠤ ꠘꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠎꠣꠟꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","ꠝꠥꠍꠣ ꠘꠛꠤꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠢꠣꠞꠥꠘꠦ ꠛꠣꠖꠦ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠞ ꠍꠤꠘꠣ ꠀꠞ ꠒꠣꠁꠘꠞ ꠞꠣꠘ ꠘꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠖꠥꠟꠘꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠖꠥꠟꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","ꠛꠣꠖꠦ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠦ ꠝꠣꠘꠡꠞ ꠛꠣꠄꠖꠤ ꠔꠣꠘ ꠀꠔ ꠛꠣꠠꠣꠁꠀ ꠔꠣꠞꠣꠞꠦ ꠖꠥꠀ ꠖꠤꠟꠣ। ꠔꠣꠁꠘ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ, ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠞ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠤꠀ ꠢꠣꠞꠟꠦ, ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠕꠣꠇꠤ ꠟꠣꠝꠤꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","ꠄꠞꠛꠣꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤ ꠀꠞ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘ ꠉꠤꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠜꠤꠔꠞꠦ ꠢꠣꠝꠣꠁꠟꠣ, ꠛꠣꠖꠦ ꠢꠘ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁꠀ ꠀꠁꠀ ꠢꠇꠟ ꠝꠣꠘꠡꠞꠦ ꠖꠥꠀ ꠖꠤꠟꠣ। ꠅꠃ ꠡꠝꠄ ꠢꠇꠟ ꠝꠣꠘꠡꠞ ꠍꠣꠝꠘꠦ ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘ ꠇꠥꠖꠞꠔꠤ ꠘꠥꠞ ꠎꠣꠁꠞ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠇꠥꠖꠞꠔꠤ ꠀꠉꠥꠁꠘ ꠀꠁꠀ, ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥ ꠀꠞ ꠢꠇ꠆ꠇꠟ ꠌꠞ꠆ꠛꠤꠞꠦ ꠎꠣꠟꠣꠁꠀ ꠍꠣꠟꠤ ꠇꠞꠤꠟꠤꠟ। ꠁꠔꠣ ꠖꠦꠈꠤꠀ ꠢꠇꠟ ꠝꠣꠘꠥꠡ ꠈꠥꠡꠤꠄ ꠍꠥꠛꠢꠣꠘ ꠀꠟ꠆ꠟꠣ ꠇꠁꠀ ꠌꠤꠇ ꠖꠤꠀ ꠍꠁꠎꠖꠣꠔ ꠙꠠꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","ꠛꠣꠖꠦ ꠅꠟꠣ ꠅꠁꠟ, ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠙꠥꠀ ꠘꠣꠖꠣꠛ ꠀꠞ ꠀꠛꠤꠢꠥꠄ ꠔꠣꠞꠣꠞ ꠎꠣꠞꠎꠤꠞ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠖꠣꠘꠤꠔ ꠀꠉꠥꠁꠘ ꠎꠣꠟꠣꠁꠟꠣ, ꠀꠞ ꠅꠃ ꠀꠉꠥꠘꠤꠞ ꠃꠙꠞꠦ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠖꠤꠟꠣ। ꠔꠣꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝꠞ ꠃꠟꠐꠣ ꠉꠤꠀ ꠖꠥꠍꠞꠣ ꠀꠉꠥꠁꠘ ꠖꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","ꠅꠔꠣꠞ ꠟꠣꠉꠤ ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠀꠉꠥꠁꠘ ꠟꠣꠝꠤꠀ ꠀꠁꠀ ꠔꠣꠞꠣꠞꠦ ꠎꠣꠟꠣꠁꠟꠤꠟ, ꠔꠣꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠝꠞꠤꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","ꠔꠦꠃ ꠝꠥꠍꠣꠄ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠦ ꠔ ꠀꠉꠦꠃ ꠎꠣꠘꠣꠁ ꠖꠤꠍꠟꠣ, ꠀꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠎꠦꠞꠣ ꠀꠎꠤꠞ ꠅꠄ, ꠔꠣꠞꠣ ꠀꠝꠣꠞꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠇꠁꠀ ꠝꠣꠘꠛ, ꠢꠇꠟ ꠝꠣꠘꠡꠞ ꠍꠣꠝꠘꠦ ꠀꠝꠣꠞ ꠉꠃꠞꠛ-ꠝꠢꠤꠝꠣ ꠎꠣꠁꠞ ꠇꠞꠛ।” ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠢꠣꠞꠥꠘ ꠌꠥꠙꠌꠣꠙ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","ꠛꠣꠖꠦ ꠝꠥꠍꠣꠄ ꠢꠣꠞꠥꠘꠞ ꠌꠣꠌꠣ ꠃꠎ꠆ꠎꠟꠞ ꠙꠥꠀꠂꠘ ꠝꠤꠡꠣꠄꠄꠟ ꠀꠞ ꠄꠟꠎꠣꠚꠘꠞꠦ ꠈꠛꠞ ꠖꠤꠀ ꠀꠘꠣꠁꠟꠣ, ꠀꠘꠣꠁꠀ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚꠞ ꠍꠣꠝꠘ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣꠞ ꠖꠥꠁꠅ ꠜꠣꠔꠤꠎꠣꠞ ꠟꠣꠡꠞꠦ ꠛꠣꠞ ꠇꠞꠤꠀ ꠇꠦꠝ꠆ꠙꠞ ꠛꠣꠞꠦ ꠘꠦꠅ।” ");
INSERT INTO syls_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","ꠔꠣꠘ ꠢꠥꠇꠥꠝ ꠙꠣꠁꠀ ꠔꠣꠞꠣ ꠉꠤꠀ ꠘꠣꠖꠣꠛ ꠀꠞ ꠀꠛꠤꠢꠥꠞ ꠟꠣꠡꠞꠦ ꠁꠝꠣꠝꠔꠤ ꠙꠣꠁꠘ꠆ꠎꠣꠛꠤꠞ ꠇꠣꠙꠠꠅ ꠗꠞꠤ ꠐꠣꠘꠤꠀ ꠇꠦꠝ꠆ꠙꠞ ꠛꠣꠞꠦ ꠘꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","ꠛꠣꠖꠦ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠘ ꠙꠥꠀꠂꠘ ꠀꠟꠤ-ꠀꠎꠞ ꠀꠞ ꠁꠍꠣꠝꠣꠞꠞꠦ ꠝꠥꠍꠣꠄ ꠇꠁꠟꠣ, “ꠔꠣꠞꠣꠞ ꠝꠃꠔꠞ ꠖꠥꠈꠦ ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠌꠥꠟꠞꠦ ꠀꠃꠟꠣ-ꠎꠣꠃꠟꠣ ꠇꠞꠤꠅ ꠘꠣ, ꠀꠞ ꠚꠤꠘ꠆ꠘꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠚꠣꠞꠤꠅ ꠘꠣ। ꠁꠔꠣ ꠇꠞꠟꠦ ꠔꠥꠝꠞꠣꠅ ꠝꠞꠛꠣꠄ, ꠀꠞ ꠀꠡ꠆ꠔꠣ ꠡꠝꠣꠎꠞ ꠃꠙꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠉꠎꠛꠤ ꠉꠥꠍꠣ ꠟꠣꠝꠛ। ꠅꠁꠟꠦ ꠝꠣꠛꠥꠖꠦ ꠎꠦꠞꠣꠞꠦ ꠀꠉꠥꠁꠘꠖꠤ ꠎꠣꠟꠣꠁ ꠝꠣꠞꠍꠂꠘ, ꠔꠣꠞꠣꠞ ꠖꠥꠈꠦ ꠔꠥꠝꠞꠣꠞ ꠇꠥꠐꠥꠝ-ꠈꠦꠡ ꠝꠣꠘꠤ ꠛꠣꠖ-ꠛꠣꠇꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠝꠣꠔ꠆ꠔꠝ-ꠀꠢꠣꠎꠣꠞꠤ ꠇꠞꠔꠣ ꠙꠣꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","ꠔꠥꠝꠞꠣꠞ ꠉꠔꠞꠅ ꠔ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠞ ꠈꠦꠟꠣꠚꠔꠤ ꠡꠝꠎꠤꠛꠣꠞ ꠙꠛꠤꠔ꠆ꠞ ꠔꠦꠟ ꠖꠦꠅꠀ ꠅꠁꠍꠦ, ꠄꠞꠟꠣꠉꠤ ꠔꠥꠝꠞꠣ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠛꠣꠞꠦ ꠎꠣꠁꠅ ꠘꠣ, ꠉꠦꠟꠦꠃ ꠝꠞꠛꠣꠄ।” ꠔꠣꠞꠣꠅ ꠝꠥꠍꠣꠞ ꠇꠕꠣ ꠝꠣꠘꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“ꠔꠥꠝꠤ ꠀꠞ ꠔꠥꠝꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠀꠋꠉꠥꠞꠞ ꠡꠞꠛꠔ ꠛꠣ ꠡꠞꠣꠛ ꠈꠣꠁꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠜꠤꠔꠞꠦ ꠢꠣꠝꠣꠁꠅ ꠘꠣ, ꠢꠣꠝꠣꠁꠟꠦꠃ ꠝꠞꠛꠣꠄ। ꠁ ꠢꠥꠇꠥꠝ ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠢꠞ-ꠢꠣꠝꠦꠡꠣ ꠝꠣꠘꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","ꠇꠥꠘꠐꠣ ꠢꠣꠞꠣꠝ ꠀꠞ ꠇꠥꠘꠐꠣ ꠢꠣꠟꠣꠟ, ꠇꠥꠘꠐꠣ ꠙꠣꠇ ꠀꠞ ꠇꠥꠘꠐꠣ ꠘꠣꠙꠣꠇ, ꠁꠔꠣ ꠛꠥꠎꠤꠀ-ꠢꠥꠘꠤꠀ ꠌꠟꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","ꠀꠞ ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞ ꠝꠣꠞꠚꠔꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠔ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠛꠣꠔꠣꠁꠍꠤ, ꠁꠔꠣ ꠔꠣꠞꠣꠞꠦ ꠔꠣꠟꠤꠝ ꠖꠤꠅ।” ");
INSERT INTO syls_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","ꠛꠣꠖꠦ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠘ ꠛꠣꠇꠤ ꠖꠥꠁꠅ ꠙꠥꠀ ꠀꠟꠤ-ꠀꠎꠞ ꠀꠞ ꠁꠍꠣꠝꠣꠞꠞꠦ ꠝꠥꠍꠣꠄ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠉꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠎꠦ ꠅꠋꠡ ꠛꠣꠇꠤ ꠞꠁꠍꠦ, ꠅꠔꠣ ꠖꠤꠀ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠞꠥꠐꠤ ꠛꠣꠘꠣꠁꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠘꠤꠀ ꠔꠥꠝꠞꠣ ꠈꠣꠁꠅ। ꠁꠔꠣ ꠔ ꠈꠣꠍ ꠙꠛꠤꠔ꠆ꠞ ꠎꠤꠘꠤꠡ। ");
INSERT INTO syls_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","ꠔꠥꠝꠞꠣ ꠙꠛꠤꠔ꠆ꠞ ꠇꠣꠛꠣ ꠊꠞꠞ ꠡꠤꠝꠣꠘꠣꠞ ꠜꠤꠔꠞꠦ ꠅꠔꠣ ꠈꠣꠁꠅ। ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠅꠃ ꠅꠋꠡ ꠔ ꠔꠥꠝꠣꠞ ꠀꠞ ꠔꠥꠝꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠙꠣꠅꠘꠣ। ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞꠦ ꠅꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","ꠅꠁꠟꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠖꠥꠟꠘꠣ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠍꠤꠘꠣ ꠀꠞ ꠞꠣꠘꠞ ꠉꠥꠡ꠆ꠔ ꠔꠥꠝꠞꠣ ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠙꠥꠀ-ꠙꠥꠠꠤꠘ꠆ꠔꠦꠅ ꠈꠣꠁꠔꠣꠄ ꠙꠣꠞꠛꠣꠄ। ꠎꠦꠇꠥꠘꠥ ꠙꠣꠇ-ꠍꠣꠚ ꠎꠣꠉꠣꠔ ꠛꠁꠀ ꠔꠥꠝꠞꠣ ꠁꠔꠣ ꠈꠣꠁꠅ। ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠢꠇꠟ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠉꠥꠡ꠆ꠔꠞ ꠅꠃ ꠅꠋꠡ ꠔꠥꠝꠞꠣꠞꠦ ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠙꠥꠀ-ꠙꠥꠠꠤꠘ꠆ꠔꠞꠦ ꠖꠦꠅꠀ ꠅꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","ꠅꠃ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠞ ꠌꠞ꠆ꠛꠤ ꠎꠦꠛꠟꠣ ꠀꠘꠣ ꠅꠁꠛ, ꠅꠃ ꠡꠝꠄ ꠖꠥꠟꠘꠣ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠍꠤꠘꠣ ꠀꠞ ꠞꠣꠘꠞ ꠉꠥꠡ꠆ꠔꠅ ꠀꠘꠣ ꠟꠣꠉꠛ। ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠅꠃ ꠞꠣꠘ ꠀꠞ ꠍꠤꠘꠣꠞ ꠉꠥꠡ꠆ꠔ ꠔꠥꠝꠤ ꠀꠞ ꠔꠥꠝꠣꠞ ꠙꠥꠀ-ꠙꠥꠠꠤꠘ꠆ꠔꠞ ꠌꠤꠞꠇꠣꠟꠤꠘ ꠙꠣꠅꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","ꠛꠣꠖꠦ ꠝꠥꠍꠣꠄ ꠈꠥꠛ ꠈꠤꠀꠟꠤ ꠅꠁꠀ ꠔꠣꠟ꠆ꠟꠣꠡꠤ ꠇꠞꠤꠀ ꠎꠣꠘꠟꠣ, ꠎꠦ ꠍꠣꠉꠟ ꠖꠤꠀ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠣ ꠅꠁꠍꠤꠟ, ꠅꠉꠥꠞ ꠢꠇꠟ ꠉꠥꠡ꠆ꠔ ꠔꠣꠞꠣ ꠎꠣꠟꠣꠁꠟꠤꠍꠦ। ꠄꠞꠟꠣꠉꠤ ꠝꠥꠍꠣꠄ ꠢꠣꠞꠥꠘꠞ ꠛꠣꠇꠤ ꠖꠥꠁꠅ ꠙꠥꠀ ꠀꠟꠤ-ꠀꠎꠞ ꠀꠞ ꠁꠍꠣꠝꠣꠞꠞ ꠃꠙꠞꠦ ꠉꠥꠍꠣ ꠇꠞꠤꠀ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠉꠥꠡ꠆ꠔ ꠔꠥꠝꠞꠣ ꠇꠣꠛꠣ ꠊꠞꠞ ꠡꠤꠝꠣꠘꠣꠔ ꠈꠣꠁꠟꠣꠄ ꠘꠣ ꠇꠦꠘꠦ? ꠁꠔꠣ ꠔ ꠈꠣꠍ ꠙꠛꠤꠔ꠆ꠞ ꠎꠤꠘꠤꠡ। ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠤꠀ, ꠔꠣꠞꠣꠞ ꠖꠥꠡ-ꠇꠍꠥꠞꠤ ꠝꠣꠚꠤꠞ ꠟꠣꠉꠤ ꠁꠔꠣ ꠔ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠦꠅꠀ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","ꠇꠥꠞꠛꠣꠘꠤꠞ ꠍꠣꠉꠟꠞ ꠟꠃ ꠎꠦꠛꠟꠣ ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚꠞ ꠜꠤꠔꠞꠦ ꠘꠦꠅꠀ ꠅꠁꠍꠦ ꠘꠣ, ꠔꠦ ꠀꠝꠣꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠁꠔꠣꠞ ꠉꠥꠡ꠆ꠔ ꠔ ꠔꠥꠝꠞꠣ ꠇꠣꠛꠣ ꠊꠞꠞ ꠡꠤꠝꠣꠘꠣꠞ ꠜꠤꠔꠞꠦ ꠈꠣꠅꠀ ꠎꠞꠥꠞ ꠀꠍꠤꠟ।” ");
INSERT INTO syls_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","ꠢꠣꠞꠥꠘꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠀꠁꠎ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠔꠣꠞꠣꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠛꠣꠖꠦ ꠀꠝꠣꠞ ꠃꠙꠞꠦꠖꠤ ꠅꠔꠔꠣ ꠊꠐꠤꠟ। ꠔꠦ ꠀꠁꠎꠇꠥꠞ ꠖꠤꠘꠅ ꠀꠝꠤ ꠅꠃ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠉꠥꠡ꠆ꠔ ꠈꠣꠁꠟꠦ ꠝꠣꠛꠥꠖ ꠇꠥꠘꠥ ꠈꠥꠡꠤ ꠅꠁꠛꠣ ꠘꠤ?” ");
INSERT INTO syls_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","ꠁ ꠎꠥꠀꠙ ꠢꠥꠘꠤꠀ ꠝꠥꠍꠣ ꠘꠛꠤ ꠈꠥꠡꠤ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“ꠔꠥꠝꠞꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠝꠣꠐꠤꠞ ꠃꠙꠞꠞ ꠙꠡꠥꠞ ꠝꠣꠎꠦ ꠎꠦꠔꠣ ꠙꠡꠥ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠢꠣꠟꠣꠟ, ꠅꠔꠣ ꠅꠁꠟ: ");
INSERT INTO syls_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","“ꠎꠦꠔꠣ ꠙꠡꠥꠞ ꠙꠣꠅꠞ ꠈꠥꠞꠣ ꠙꠥꠞꠣꠙꠥꠞ ꠌꠤꠞꠣ, ꠀꠞ ꠈꠣꠘꠤꠞꠦ ꠙꠣꠎꠣꠄ, ꠁꠔꠣꠞ ꠉꠥꠡ꠆ꠔ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠢꠣꠟꠣꠟ। ");
INSERT INTO syls_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","ꠔꠣ-ꠅ ꠄꠞ ꠝꠣꠎꠞ ꠇꠥꠘꠥ ꠇꠥꠘꠥ ꠙꠡꠥꠄ ꠈꠣꠟꠤ ꠈꠣꠘꠤꠞꠦ ꠙꠣꠎꠣꠄ, ꠀꠞ ꠇꠥꠘꠥ ꠇꠥꠘꠥ ꠙꠡꠥꠞ ꠈꠣꠟꠤ ꠈꠥꠞꠣ ꠌꠤꠞꠣ, ꠁꠔꠣ ꠔ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠢꠣꠞꠣꠝ। ꠃꠐꠦ ꠈꠣꠘꠤꠞꠦ ꠙꠣꠎꠣꠁꠟꠦꠅ ꠔꠣꠞ ꠈꠥꠞꠣ ꠌꠤꠞꠣ ꠘꠣꠄ, ꠄꠞꠟꠣꠉꠤ ꠃꠐ ꠢꠣꠞꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","ꠡꠣꠚꠘ-ꠃꠘ꠆ꠖꠥꠞꠦ ꠈꠣꠘꠤꠞꠦ ꠙꠣꠎꠣꠁꠟꠦꠅ, ꠁꠔꠣꠞ ꠈꠥꠞꠣ ꠌꠤꠞꠣ ꠘꠣꠄ, ꠅꠔꠣꠞ ꠟꠣꠉꠤ ꠁꠔꠣꠅ ꠢꠣꠞꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","ꠈꠞꠉꠥꠡꠦꠅ ꠈꠣꠘꠤꠞꠦ ꠙꠣꠎꠣꠄ, ꠅꠁꠟꠦ ꠁꠔꠣꠞ ꠈꠥꠞꠣ ꠌꠤꠞꠣ ꠘꠣꠄ, ꠅꠔꠣꠞ ꠟꠣꠉꠤ ꠢꠣꠞꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","ꠡꠥꠅꠞꠞ ꠈꠥꠞꠣ ꠙꠥꠞꠣꠙꠥꠞ ꠌꠤꠞꠣ, ꠅꠁꠟꠦ ꠁꠔꠣꠄ ꠈꠣꠘꠤꠞꠦ ꠙꠣꠎꠣꠄ ꠘꠣ, ꠄꠞꠟꠣꠉꠤ ꠁꠔꠣ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠢꠣꠞꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","ꠁꠔꠣꠞ ꠉꠥꠡ꠆ꠔ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠢꠣꠞꠣꠝ, ꠁꠔꠣꠞ ꠝꠞꠣ ꠟꠣꠡꠞꠦꠅ ꠍꠁꠅ ꠘꠣ। ꠁꠔꠣ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠘꠣꠙꠣꠇ। ");
INSERT INTO syls_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ꠙꠣꠘꠤꠞ ꠝꠣꠎꠦ ꠎꠦꠔꠣ ꠎꠣꠘꠖꠣꠞꠦ ꠛꠡꠔ ꠇꠞꠂꠘ, ꠁꠔꠣꠞ ꠝꠣꠎꠦ ꠎꠦꠔꠣꠞ ꠚꠁꠞ ꠀꠞ ꠒꠣꠈꠘꠣ ꠀꠍꠦ, ꠁꠔꠣ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠢꠣꠟꠣꠟ। ");
INSERT INTO syls_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","ꠅꠁꠟꠦ ꠎꠦꠔꠣꠞ ꠚꠁꠞ ꠀꠞ ꠒꠣꠈꠘꠣ ꠘꠣꠁ, ꠁꠔꠣ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠘꠣꠎꠣꠁꠎ। ꠁꠔꠣ ꠙꠣꠘꠤꠞ ꠝꠣꠎꠦ ꠙꠣꠟ ꠛꠣꠘ꠆ꠖꠤꠀ ꠊꠥꠞꠞꠣ ꠎꠣꠘꠖꠣꠞ ꠅꠃꠇ ꠛꠣ ꠀꠞꠅ ꠇꠥꠘꠥ ꠎꠣꠘꠖꠣꠞ ꠅꠃꠇ, ꠁꠔꠣꠞꠦ ꠔꠥꠝꠞꠣ ꠊꠤꠘ꠆ꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","ꠘꠣꠎꠣꠁꠎ ꠅꠀꠄ ꠁꠔꠣꠞꠦ ꠢꠣꠞꠣꠝ ꠝꠘꠅ ꠇꠞꠤꠅ, ꠁꠔꠣ ꠔꠥꠝꠞꠣ ꠈꠣꠁꠅ ꠘꠣ। ꠁꠔꠣꠞ ꠝꠞꠣ ꠟꠣꠡꠞꠦꠅ ꠔꠥꠝꠞꠣ ꠊꠤꠘ꠆ꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","ꠙꠣꠘꠤꠞ ꠝꠣꠎꠦ ꠛꠡꠔ ꠇꠞꠦ, ꠅꠁꠟꠦ ꠇꠥꠘꠥ ꠚꠁꠞ ꠛꠣ ꠒꠣꠈꠘꠣ ꠘꠣꠁ, ꠁꠟꠣꠈꠣꠘ ꠢꠇꠟ ꠎꠣꠘꠖꠣꠞꠞꠦ ꠔꠥꠝꠞꠣ ꠊꠤꠘ꠆ꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ꠀꠞ ꠙꠣꠈꠤ ꠅꠇꠟꠞ ꠝꠣꠎꠞ ꠅꠃ ꠟꠣꠈꠣꠘ ꠙꠣꠈꠤꠞꠦ ꠔꠥꠝꠞꠣ ꠊꠤꠘ꠆ꠘꠣꠁꠅ, ꠁꠔꠣ ꠔꠥꠝꠞꠣ ꠈꠣꠁꠅ ꠘꠣ। ꠅꠔꠣ ꠅꠁꠟꠣ, ꠛꠠ ꠌꠤꠟ, ꠢꠇꠥꠘ, ꠢꠣꠚ-ꠈꠣꠃꠞꠤ, ");
INSERT INTO syls_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ꠢꠇꠟ ꠎꠣꠔꠞ ꠌꠤꠟ, ꠢꠇꠟ ꠎꠣꠔ ꠇꠣꠃꠀ, ");
INSERT INTO syls_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ꠃꠐ ꠙꠣꠈꠤ, ");
INSERT INTO syls_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ꠘꠤꠝ ꠙꠣꠈꠤ, ꠉꠣꠋꠌꠤꠟ, ꠢꠇꠟ ꠘꠝꠥꠘꠣꠞ ꠛꠣꠎ ꠙꠣꠈꠤ, ");
INSERT INTO syls_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ꠢꠇꠟ ꠎꠣꠔ ꠙꠦꠌꠣ, ꠢꠇꠟ ꠎꠣꠔꠞ ꠇꠥꠠꠣ, ꠍꠟꠣ-ꠇꠣꠇ, ꠛꠟꠥꠀ ꠙꠣꠈꠤ, ");
INSERT INTO syls_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ꠙꠣꠘꠤ-ꠈꠣꠃꠞꠤ, ");
INSERT INTO syls_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ꠢꠇꠟ ꠎꠣꠔꠞ ꠎꠣꠐꠤꠀ, ꠢꠇꠟ ꠎꠣꠔꠞ ꠛꠉꠟꠣ, ꠝꠘ-ꠌꠥꠞꠣ ꠙꠣꠈꠤ ꠀꠞ ꠛꠣꠖꠥꠞ, ꠁꠔꠣ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠢꠣꠞꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ꠙꠥꠇ-ꠚꠞꠤꠋ ꠅꠇꠟꠞ ꠝꠣꠎꠦ ꠅꠃ ꠟꠣꠈꠣꠘ ꠙꠥꠇ-ꠚꠞꠤꠋ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠘꠣꠎꠣꠁꠎ, ꠎꠦꠔꠣꠄ ꠙꠣꠅꠖꠤ ꠀꠐꠦ ꠀꠞ ꠃꠠꠣꠟ ꠖꠦꠄ, ꠁꠔꠣꠞꠦ ꠔꠥꠝꠞꠣ ꠊꠤꠘ꠆ꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","ꠅꠁꠟꠦ ꠁꠔꠣꠞ ꠝꠣꠎꠞ ꠎꠦꠔꠣꠞ ꠀꠐꠥ ꠀꠍꠦ, ꠀꠞ ꠝꠣꠐꠤꠞ ꠃꠙꠞꠦ ꠚꠣꠟꠣꠁ ꠚꠣꠟꠣꠁ ꠌꠟꠦ, ꠁꠔꠣꠞ ꠝꠣꠎꠞ ꠇꠥꠘꠥ ꠇꠥꠘꠥꠐꠣ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠢꠣꠟꠣꠟ। ");
INSERT INTO syls_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","ꠁꠔꠣ ꠅꠁꠟ, ꠢꠇꠟ ꠎꠣꠔꠞ ꠙꠋꠉꠙꠣꠟ, ꠛꠣꠊꠣ-ꠚꠞꠤꠋ, ꠊꠣꠡ-ꠚꠞꠤꠋ। ");
INSERT INTO syls_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","ꠅꠁꠟꠦ ꠁꠔꠣ ꠍꠣꠠꠣ ꠛꠣꠖ-ꠛꠣꠇꠤ ꠎꠔ ꠙꠥꠇ-ꠚꠞꠤꠋꠄ ꠌꠣꠁꠞ ꠙꠣꠅꠄ ꠀꠐꠦ ꠀꠞ ꠃꠠꠤꠔ ꠙꠣꠞꠦ, ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠔꠥꠝꠞꠣ ꠊꠤꠘ꠆ꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ꠔꠥꠝꠞꠣ ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠣꠝ ꠇꠞꠟꠦ ꠘꠣꠙꠣꠇ ꠅꠁꠎꠤꠛꠣꠄ; ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠅꠃ ꠢꠣꠞꠣꠝ ꠙꠡꠥ, ꠙꠣꠈꠤ, ꠝꠣꠍ, ꠙꠥꠇ-ꠚꠞꠤꠋ ꠅꠔꠣꠞ ꠝꠞꠣ ꠟꠣꠡ ꠍꠁꠟꠣꠄ, ꠔꠦ ꠢꠦ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠘꠣꠙꠣꠇ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","ꠀꠞ ꠇꠦꠃ ꠎꠥꠖꠤ ꠅꠔꠣ ꠢꠣꠞꠣꠝ ꠎꠤꠘꠤꠡꠞ ꠟꠣꠡꠞ ꠇꠥꠘꠥ ꠅꠋꠡꠞꠦ ꠀꠔꠖꠤ ꠗꠞꠤꠀ ꠛꠁꠀ ꠘꠦꠄ, ꠔꠦ ꠢꠦ ꠔꠣꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠖꠤꠔꠦ ꠅꠁꠛ, ꠀꠞ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠘꠣꠙꠣꠇ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ꠀꠞ ꠎꠦꠔꠣ ꠙꠡꠥꠞ ꠙꠣꠅꠞ ꠈꠥꠞꠣ ꠙꠥꠞꠣꠙꠥꠞ ꠌꠤꠞꠣ ꠘꠣꠄ, ꠛꠣ ꠎꠦ ꠙꠡꠥꠄ ꠈꠣꠘꠤꠞꠦ ꠙꠣꠎꠣꠄ ꠘꠣ, ꠁꠔꠣ ꠔ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠢꠣꠞꠣꠝ। ꠅꠃ ꠢꠣꠞꠣꠝ ꠙꠡꠥꠞꠦ ꠎꠦ ꠎꠘꠦ ꠍꠁꠛ, ꠢꠦ ꠘꠣꠙꠣꠇ ꠛꠘꠤꠎꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","ꠌꠣꠁꠞ ꠙꠣꠅꠄ ꠀꠐꠞꠣ ꠎꠣꠘꠥꠀꠞ ꠅꠇꠟꠞ ꠝꠣꠎꠦ, ꠎꠦ ꠙꠡꠥꠄ ꠙꠣꠅꠞ ꠔꠣꠟꠥꠔ ꠜꠞ ꠖꠤꠀ ꠀꠐꠦ, ꠁꠔꠣꠅ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠢꠣꠞꠣꠝ। ꠇꠦꠃ ꠎꠥꠖꠤ ꠁꠔꠣꠞ ꠝꠞꠣ ꠟꠣꠡ ꠍꠁꠟꠣꠄ, ꠔꠦ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠘꠣꠙꠣꠇ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","ꠀꠞ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠁꠔꠣꠞ ꠟꠣꠡ ꠀꠔꠖꠤ ꠗꠞꠤꠀ ꠛꠁꠀ ꠘꠦꠄ, ꠔꠦ ꠔꠣꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠖꠤꠔꠦ ꠅꠁꠛ, ꠀꠞ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠦ ꠘꠣꠙꠣꠇ ꠞꠁꠛ। ꠁꠔꠣ ꠎꠣꠘꠥꠀꠞ ꠅꠇꠟ ꠔ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠢꠣꠞꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ꠀꠞ ꠝꠣꠐꠤꠔ ꠌꠟꠞꠣ ꠢꠥꠞꠥ-ꠝꠥꠞꠥ ꠎꠣꠘꠖꠣꠞꠞ ꠝꠣꠎꠦ ꠘꠦꠃꠟ, ꠃꠘ꠆ꠖꠥꠞ, ꠢꠇꠟ ꠎꠣꠔꠞ ꠉꠤꠞꠉꠤꠐꠤ, ");
INSERT INTO syls_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ꠐꠤꠇꠐꠤꠇꠤ, ꠉꠥꠁꠟ-ꠢꠣꠚ, ꠝꠁ-ꠢꠣꠚ, ꠀꠁꠘ꠆ꠎꠣꠁꠟ ꠀꠞ ꠇꠣꠇꠟꠣꠡ, ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠢꠣꠞꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","ꠝꠣꠐꠤꠔ ꠌꠟꠞꠣ ꠢꠥꠞꠥ-ꠝꠥꠞꠥ ꠎꠣꠘꠖꠣꠞꠞ ꠝꠣꠎꠞ ꠅꠃ ꠎꠣꠔꠞ ꠎꠣꠘꠖꠣꠞ ꠔ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠘꠣꠎꠣꠁꠎ। ꠁꠔꠣꠞ ꠝꠞꠣ ꠟꠣꠡ ꠇꠦꠃ ꠍꠁꠟꠦ, ꠢꠦ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠘꠣꠙꠣꠇ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","ꠅꠔꠣꠞ ꠝꠣꠎꠞ ꠎꠦꠇꠥꠘꠥ ꠄꠉꠥꠞ ꠝꠞꠣ ꠟꠣꠡ ꠎꠥꠖꠤ ꠅꠁꠘ꠆ꠘ ꠎꠤꠘꠤꠡꠞ ꠃꠙꠞꠦ ꠙꠠꠦ, ꠎꠦꠟꠣꠘ ꠟꠣꠇꠠꠤ, ꠇꠣꠙꠠ-ꠌꠥꠙꠠ, ꠌꠣꠝꠠꠣ ꠛꠣ ꠍꠟꠣꠞ ꠌꠐ ꠖꠤꠀ ꠛꠣꠘꠣꠁꠟ ꠎꠦꠇꠥꠘꠥ ꠝꠣꠟꠞ ꠃꠙꠞꠦ ꠙꠠꠟꠦꠃ ꠁꠔꠣ ꠘꠣꠙꠣꠇ ꠅꠁꠎꠤꠛ। ꠘꠣꠙꠣꠇ ꠝꠣꠟꠞꠦ ꠙꠣꠘꠤꠔ ꠜꠤꠎꠣꠁꠀ ꠕꠁꠛꠣꠄ। ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠁꠔꠣ ꠘꠣꠙꠣꠇ ꠞꠁꠛ, ꠛꠣꠖꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","ꠀꠞ ꠅꠃ ꠘꠣꠙꠣꠇ ꠎꠣꠘꠖꠣꠞꠞ ꠇꠥꠘꠥꠐꠣꠞ ꠝꠞꠣ ꠟꠣꠡ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠝꠣꠐꠤꠞ ꠛꠣꠡꠘꠞ ꠝꠣꠎꠦ ꠙꠠꠦ, ꠔꠦ ꠁꠉꠥꠞ ꠜꠤꠔꠞꠞ ꠢꠇꠟꠔꠣ ꠘꠣꠙꠣꠇ ꠅꠁꠎꠤꠛ, ꠁ ꠛꠣꠡꠘꠞꠦꠅ ꠜꠣꠋꠉꠤꠟꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","ꠅꠃ ꠛꠣꠡꠘꠞ ꠙꠣꠘꠤ ꠛꠣ ꠞꠡ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠈꠣꠘꠤꠞ ꠎꠤꠘꠤꠡꠞ ꠃꠙꠞꠦ ꠙꠠꠦ, ꠔꠦ ꠁ ꠈꠣꠘꠤ ꠘꠣꠙꠣꠇ ꠅꠁꠎꠤꠛ। ꠁꠇꠐꠣꠞ ꠝꠣꠎꠦ ꠎꠥꠖꠤ ꠙꠣꠘꠤ ꠎꠣꠔꠤꠅ ꠇꠥꠘꠥꠔꠣ ꠕꠅꠀ ꠕꠣꠇꠦ, ꠔꠦ ꠁꠔꠣꠅ ꠘꠣꠙꠣꠇ ꠅꠁꠎꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","ꠀꠞ ꠅꠔꠣꠞ ꠝꠞꠣ ꠟꠣꠡ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠎꠤꠘꠤꠡꠞ ꠃꠙꠞꠦ ꠙꠠꠦ, ꠔꠦ ꠁꠔꠣ ꠘꠣꠙꠣꠇ ꠅꠁꠎꠤꠛ। ꠁꠔꠣ ꠇꠥꠘꠥ ꠃꠘ꠆ꠖꠣꠟꠅ ꠙꠠꠟꠦ, ꠁ ꠃꠘ꠆ꠖꠣꠟ ꠜꠣꠋꠉꠤꠟꠤꠛꠣꠄ। ꠁ ꠃꠘ꠆ꠖꠣꠟ ꠔ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠘꠣꠙꠣꠇ, ꠁꠔꠣꠞꠦ ꠘꠣꠙꠣꠇ ꠉꠁꠘ꠆ꠘ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","ꠅꠁꠟꠦ ꠁꠔꠣ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠇꠥꠀꠞ ꠜꠤꠔꠞꠦ ꠛꠣ ꠁꠘ꠆ꠖꠣꠞꠣꠞ ꠝꠣꠎꠦ ꠙꠠꠦ, ꠔꠦ ꠁ ꠇꠥꠀ ꠛꠣ ꠁꠘ꠆ꠖꠣꠞꠣ ꠘꠣꠙꠣꠇ ꠅꠁꠔ ꠘꠣꠄ। ꠈꠣꠟꠤ ꠁꠔꠣꠞ ꠝꠞꠣ ꠟꠣꠡ ꠎꠦ ꠎꠘꠦ ꠍꠁꠛ, ꠢꠦ ꠘꠣꠙꠣꠇ ꠅꠁꠎꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","ꠎꠝꠤꠘꠅ ꠛꠣꠁꠘ ꠖꠤꠛꠣꠞ ꠘꠤꠅꠔꠦ ꠕꠅꠀ ꠇꠥꠘꠥꠎꠣꠔꠞ ꠛꠤꠌꠞ ꠃꠙꠞꠦ ꠎꠥꠖꠤ ꠅꠔꠣꠞ ꠟꠣꠡ ꠙꠠꠦ, ꠔꠦ ꠁꠔꠣ ꠘꠣꠙꠣꠇ ꠅꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","ꠅꠁꠟꠦ ꠇꠥꠘꠥ ꠛꠤꠌꠞ ꠃꠙꠞꠦ ꠙꠣꠘꠤ ꠖꠤꠀ ꠜꠤꠎꠣꠘꠤꠞ ꠛꠣꠖꠦ ꠎꠥꠖꠤ ꠁꠔꠣ ꠙꠠꠦ, ꠔꠦ ꠁ ꠛꠤꠌ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠘꠣꠙꠣꠇ। ");
INSERT INTO syls_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ꠔꠥꠝꠞꠣꠞ ꠢꠣꠟꠣꠟ ꠇꠥꠘꠥ ꠙꠡꠥ ꠝꠞꠤꠉꠦꠟꠦ, ꠁꠉꠥꠞ ꠟꠣꠡ ꠎꠦ ꠎꠘꠦ ꠍꠁꠛ, ꠢꠦ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠘꠣꠙꠣꠇ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","ꠇꠦꠃ ꠎꠥꠖꠤ ꠅꠃ ꠝꠞꠣ ꠙꠡꠥꠞ ꠉꠥꠡ꠆ꠔ ꠈꠣꠄ, ꠔꠦ ꠢꠦ ꠔꠣꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠖꠤꠔꠦ ꠅꠁꠛ, ꠀꠞ ꠢꠦ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠘꠣꠙꠣꠇ ꠞꠁꠛ। ꠀꠞ ꠇꠦꠃ ꠎꠥꠖꠤ ꠅꠃ ꠙꠡꠥꠞ ꠟꠣꠡꠞꠦ ꠀꠔ ꠖꠤꠀ ꠔꠥꠟꠦ, ꠔꠦ ꠢꠦ ꠔꠣꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠖꠤꠔꠦ ꠅꠁꠛ, ꠢꠦ-ꠅ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠘꠣꠙꠣꠇ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ꠢꠥꠘꠅ, ꠝꠣꠐꠤꠞ ꠝꠣꠎꠦ ꠌꠟꠞꠣ ꠢꠇꠟ ꠎꠣꠔꠞ ꠢꠥꠞꠥ-ꠝꠥꠞꠥ ꠎꠣꠘꠖꠣꠞ ꠈꠣꠅꠀ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠢꠣꠞꠣꠝ, ꠁꠔꠣꠞꠦ ꠔꠥꠝꠞꠣ ꠊꠤꠘ꠆ꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","ꠁꠔꠣ ꠛꠥꠇꠦ ꠌꠟꠞꠣ ꠎꠣꠘꠖꠣꠞ ꠅꠃꠇ, ꠛꠣ ꠌꠣꠁꠞ ꠙꠣꠅꠄ ꠀꠐꠞꠣ ꠎꠣꠘꠖꠣꠞ ꠛꠣ ꠛꠃꠔ ꠙꠣꠅꠄ ꠌꠟꠞꠣ ꠅꠃꠇ, ꠢꠇꠟ ꠘꠝꠥꠘꠣꠞ ꠝꠣꠐꠤꠔ ꠌꠟꠞꠣ ꠢꠥꠞꠥ-ꠝꠥꠞꠥ ꠎꠣꠘꠖꠣꠞ ꠔꠥꠝꠞꠣ ꠈꠣꠁꠅ ꠘꠣ, ꠁꠔꠣꠞꠦ ꠊꠤꠘ꠆ꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","ꠔꠥꠝꠞꠣ ꠁꠔꠣ ꠇꠥꠘꠥꠔꠣꠞ ꠟꠣꠉꠤ ꠘꠤꠎꠞꠦ ꠊꠤꠘ꠆ꠘꠣꠞ ꠎꠘ ꠛꠣꠘꠣꠁꠅ ꠘꠣ, ꠛꠣ ꠅꠔꠣꠄꠅ ꠎꠣꠘꠥ ꠔꠥꠝꠞꠣꠞꠦ ꠘꠣꠙꠣꠇ ꠘꠣ ꠛꠣꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ। ꠀꠝꠣꠞ ꠘꠤꠅꠔꠦ ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠞꠣꠈꠤꠅ। ꠎꠣꠘ ꠔ, ꠀꠝꠤ ꠘꠤꠎꠦꠅ ꠙꠛꠤꠔ꠆ꠞ। ꠄꠞꠟꠣꠉꠤ ꠝꠣꠐꠤꠔ ꠌꠟꠞꠣ ꠇꠥꠘꠥ ꠢꠥꠞꠥ-ꠝꠥꠞꠥ ꠎꠣꠘꠖꠣꠞꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞꠦ ꠘꠣꠙꠣꠇ ꠛꠣꠘꠣꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","ꠀꠝꠤ ꠔ ꠀꠟ꠆ꠟꠣ, ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠅꠀꠞ ꠈꠤꠀꠟꠦ, ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠍꠤ। ꠀꠝꠤ ꠘꠤꠎꠦ ꠙꠛꠤꠔ꠆ꠞ, ꠄꠞꠟꠣꠉꠤ ꠔꠥꠝꠞꠣꠅ ꠙꠛꠤꠔ꠆ꠞ ꠞꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ꠔꠦ ꠙꠡꠥ, ꠙꠣꠈꠤ, ꠙꠣꠘꠤꠔ ꠛꠡꠔ ꠇꠞꠞꠣ ꠎꠣꠘꠖꠣꠞ, ꠀꠞ ꠝꠣꠐꠤꠞ ꠝꠣꠎꠦ ꠌꠟꠞꠣ ꠢꠇꠟ ꠘꠝꠥꠘꠣꠞ ꠢꠥꠞꠥ-ꠝꠥꠞꠥ ꠎꠣꠘꠖꠣꠞꠞ ꠛꠦꠙꠣꠞꠦ ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠝꠣꠘꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","ꠇꠥꠘꠐꠣ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠎꠣꠁꠎ ꠀꠞ ꠇꠥꠘꠐꠣ ꠘꠣꠎꠣꠁꠎ, ꠇꠥꠘ ꠙꠡꠥꠞ ꠉꠥꠡ꠆ꠔ ꠢꠣꠟꠣꠟ ꠀꠞ ꠇꠥꠘꠐꠣ ꠢꠣꠞꠣꠝ, ꠁꠔꠣ ꠔꠥꠝꠞꠣ ꠛꠥꠎꠤꠀ-ꠢꠥꠘꠤꠀ ꠌꠟꠤꠅ।” ");
INSERT INTO syls_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠇꠥꠘꠥ ꠛꠦꠐꠤꠞ ꠊꠞꠅ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠙꠥꠀꠞ ꠎꠘꠝ ꠅꠄ, ꠔꠦ ꠛꠦꠐꠤꠀꠞꠣ ꠛꠦꠝꠣꠞꠞ ꠡꠝꠄꠇꠥꠞ ꠟꠣꠈꠣꠘ ꠁ ꠛꠦꠐꠤ ꠘꠣꠙꠣꠇ ꠞꠁꠛ। ꠔꠣꠁꠞ ꠅꠃ ꠘꠣꠙꠣꠇꠤ ꠢꠣꠟꠔ ꠡꠣꠔ ꠖꠤꠘ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","ꠛꠣꠖꠦ ꠀꠐ ꠖꠤꠘꠞ ꠖꠤꠘ ꠙꠥꠀꠞꠦ ꠝꠍꠟꠝꠣꠘꠤ ꠇꠣꠝ ꠇꠞꠣꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","ꠀꠞ ꠅꠃ ꠛꠦꠐꠤꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠎꠘꠝꠞ ꠟꠃ ꠎꠣꠅꠀꠞ ꠇꠣꠞꠘꠦ ꠔꠦꠔ꠆ꠞꠤꠡ ꠖꠤꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠘꠣꠙꠣꠇ ꠞꠁꠛ। ꠅꠃ ꠝꠤꠀꠖ ꠘꠣ ꠙꠥꠞꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠔꠣꠁ ꠇꠥꠘꠥ ꠙꠛꠤꠔ꠆ꠞ ꠎꠤꠘꠤꠡꠅ ꠗꠞꠣ-ꠍꠀ ꠎꠣꠁꠎ ꠘꠣꠄ। ꠀꠞ ꠙꠛꠤꠔ꠆ꠞ ꠇꠣꠛꠣ ꠊꠞꠞ ꠡꠤꠝꠣꠘꠣꠔ ꠎꠣꠁꠛꠣꠞ ꠢꠥꠇꠥꠝ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","ꠅꠁꠟꠦ ꠁ ꠛꠦꠐꠤꠞ ꠊꠞꠅ ꠎꠥꠖꠤ ꠙꠥꠠꠤꠞ ꠎꠘꠝ ꠅꠄ, ꠔꠦ ꠛꠦꠐꠤꠀꠞꠣ ꠝꠣꠡꠤꠇ ꠛꠦꠝꠣꠞꠞ ꠟꠣꠈꠣꠘ ꠔꠣꠁ ꠘꠣꠙꠣꠇ ꠞꠁꠛ, ꠔꠣ-ꠅ ꠁ ꠘꠣꠙꠣꠇꠤ ꠢꠣꠟꠔ ꠙꠥꠞꠣ ꠖꠥꠁ ꠢꠣꠙ꠆ꠔꠣ ꠌꠟꠛ। ꠛꠣꠖꠦ ꠅꠃ ꠛꠦꠝꠣꠞ ꠕꠣꠇꠤ ꠙꠣꠇ-ꠙꠣꠇꠤꠎꠣ ꠅꠀꠞ ꠟꠣꠉꠤ ꠀꠞꠅ ꠍꠄꠡꠐ꠆ꠐꠤ ꠖꠤꠘ ꠛꠣꠞ ꠌꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ꠙꠥꠀ ꠛꠣ ꠙꠥꠠꠤꠞ ꠎꠘꠝꠞ ꠛꠣꠖꠦ ꠙꠣꠇ-ꠙꠣꠇꠤꠎꠣ ꠅꠀꠞ ꠡꠝꠄ ꠀꠁꠟꠦ, ꠛꠦꠐꠤꠄ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠁꠝꠣꠝ ꠍꠣꠛꠞ ꠉꠦꠍꠦ ꠎꠣꠁꠛ। ꠎꠣꠁꠔꠦ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠄꠉꠥ ꠝꠦꠠꠣ, ꠀꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠙꠣꠞꠅ ꠛꠣ ꠒꠥꠙꠤ ꠙꠣꠈꠤ ꠟꠉꠦ ꠘꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","ꠔꠦꠃ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠅꠃ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠤꠀ ꠟꠃ ꠎꠣꠅꠀ ꠛꠦꠝꠣꠞ ꠕꠣꠇꠤ ꠛꠦꠐꠤꠞꠦ ꠙꠣꠇ-ꠙꠣꠇꠤꠎꠣ ꠇꠞꠛꠣ। ꠛꠦꠐꠤꠘ꠆ꠔꠞ ꠊꠞꠅ ꠙꠥꠀ ꠛꠣ ꠙꠥꠠꠤꠞ ꠎꠘꠝꠞ ꠛꠣꠖꠦ ꠙꠣꠇ-ꠙꠣꠇꠤꠎꠣ ꠅꠀꠞ ꠟꠣꠉꠤ ꠅꠃ ꠘꠤꠅꠝ ꠎꠣꠞꠤ ꠞꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠝꠦꠠꠣ ꠀꠘꠣꠞ ꠔꠚꠤꠇ ꠎꠥꠖꠤ ꠘꠣ ꠕꠣꠇꠦ, ꠔꠦ ꠖꠥꠉꠥ ꠙꠣꠞꠅ ꠛꠣ ꠒꠥꠙꠤ ꠙꠣꠈꠤ ꠀꠘꠛ। ꠄꠞ ꠝꠣꠎꠞ ꠄꠉꠥ ꠅꠁꠛ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠀꠞ ꠖꠥꠍꠞꠣꠐꠣ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ। ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠤꠀ ꠔꠣꠁꠞꠦ ꠘꠣꠙꠣꠇꠤ ꠕꠣꠇꠤ ꠛꠣꠌꠣꠁꠛꠣ, ꠔꠦꠃ ꠁ ꠛꠦꠐꠤ ꠙꠣꠇ-ꠙꠣꠇꠤꠎꠣ ꠛꠘꠛ। ");
INSERT INTO syls_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“ꠇꠥꠘꠥ ꠝꠣꠘꠡꠞ ꠉꠔꠞꠞ ꠌꠣꠝꠠꠣꠞ ꠇꠥꠘꠥ ꠎꠣꠉꠣ ꠎꠥꠖꠤ ꠀꠈꠔꠣ ꠚꠥꠟꠤ ꠎꠣꠄ, ꠛꠣ ꠇꠥꠘꠥ ꠇꠥꠟꠡ ꠃꠑꠦ ꠛꠣ ꠇꠥꠘꠥꠎꠣꠔ ꠖꠣꠉ ꠖꠦꠈꠣ ꠎꠣꠄ, ꠀꠞ ꠝꠘꠅ ꠡꠘ꠆ꠖꠄ ꠅꠄ ꠎꠦꠘ, ꠁꠔꠣ ꠛꠣꠖꠦ ꠙꠌꠣ-ꠇꠥꠡ꠆ꠑ ꠛꠦꠝꠣꠞ ꠅꠁꠔ ꠙꠣꠞꠦ, ꠔꠦ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘ ꠛꠣ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠝꠣꠎꠞ ꠇꠥꠘꠥ ꠁꠝꠣꠝꠞ ꠉꠦꠍꠦ ꠔꠣꠞꠦ ꠟꠁꠀ ꠎꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠔꠣꠞ ꠌꠣꠝꠠꠣꠞ ꠅꠃ ꠎꠣꠉꠣ ꠖꠦꠈꠛꠣ, ꠢꠤ ꠎꠣꠉꠣꠞ ꠞꠥꠝꠣ ꠎꠥꠖꠤ ꠗꠟꠣ ꠅꠁꠎꠣꠄ, ꠀꠞ ꠛꠥꠎꠣ ꠎꠣꠄ ꠁ ꠛꠦꠝꠣꠞ ꠌꠣꠝꠠꠣꠞ ꠔꠟꠞ ꠉꠥꠡ꠆ꠔꠞ ꠝꠣꠎꠦ ꠟꠣꠉꠤꠉꠦꠍꠦ, ꠔꠦ ꠛꠥꠎꠛꠣꠄ, ꠁꠔꠣ ꠘꠣꠙꠣꠇ ꠙꠌꠣ-ꠇꠥꠡ꠆ꠑ ꠛꠦꠝꠣꠞ। ꠁꠟꠣ ꠛꠦꠝꠣꠞꠤ ꠖꠦꠈꠟꠦ ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠘꠣꠙꠣꠇ ꠇꠁꠀ ꠄꠟꠣꠘ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","ꠅꠁꠟꠦ ꠔꠣꠞ ꠌꠣꠝꠠꠣꠞ ꠝꠣꠎꠦ ꠅꠃ ꠖꠣꠉ ꠎꠥꠖꠤ ꠈꠣꠟꠤ ꠗꠟꠣ ꠅꠄ, ꠀꠞ ꠁꠔꠣ ꠌꠣꠝꠠꠣꠞ ꠔꠟꠞ ꠉꠥꠡ꠆ꠔꠞ ꠝꠣꠎꠦ ꠘꠣ ꠟꠣꠉꠦ, ꠅꠘꠞ ꠞꠥꠝꠣ ꠗꠟꠣ ꠘꠣ ꠅꠄ, ꠔꠦ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠅꠃ ꠎꠘꠞꠦ ꠡꠣꠔ ꠖꠤꠘ ꠗꠞꠤ ꠢꠇꠟ ꠝꠣꠘꠡꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠢꠞꠣꠁ ꠞꠣꠈꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ꠛꠣꠖꠦ ꠡꠣꠔ ꠖꠤꠘꠞ ꠖꠤꠘ ꠔꠣꠞꠦ ꠢꠤꠞꠛꠣꠞ ꠖꠦꠈꠛꠣ। ꠎꠥꠖꠤ ꠖꠦꠈꠣ ꠎꠣꠄ, ꠅꠃ ꠛꠦꠝꠣꠞ ꠌꠣꠝꠠꠣꠞ ꠔꠟꠦꠖꠤ ꠘꠣ ꠉꠤꠀ ꠎꠦꠟꠣ ꠀꠍꠤꠟ ꠅꠟꠣ ꠞꠁꠍꠦ, ꠔꠦ ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠀꠞꠅ ꠡꠣꠔ ꠖꠤꠘ ꠀꠟꠉꠣ ꠞꠣꠈꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","ꠀꠞ ꠢꠤꠞꠛꠣꠞ ꠡꠣꠔ ꠖꠤꠘꠞ ꠖꠤꠘ ꠔꠣꠞꠦ ꠖꠦꠈꠛꠣ, ꠄꠞꠝꠣꠎꠦ ꠎꠥꠖꠤ ꠔꠣꠞ ꠛꠦꠝꠣꠞ ꠘꠣ ꠛꠣꠠꠤꠀ ꠢꠥꠇꠣꠁꠀ ꠇꠝꠤ ꠎꠣꠄ, ꠔꠦ ꠛꠥꠎꠛꠣ, ꠁꠔꠣ ꠈꠣꠟꠤ ꠇꠥꠟꠡ ꠃꠑꠍꠦ। ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠁꠀ ꠄꠟꠣꠘ ꠇꠞꠛꠣ। ꠢꠦ ꠔꠣꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠢꠣꠞꠤ ꠙꠣꠇ-ꠍꠣꠚ ꠛꠘꠛ। ");
INSERT INTO syls_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","ꠅꠁꠟꠦ ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠁꠀ ꠄꠟꠣꠘ ꠇꠞꠣꠞ ꠛꠣꠖꠦ ꠎꠥꠖꠤ ꠔꠣꠞ ꠉꠔꠞꠞ ꠇꠥꠟꠡ ꠀꠞꠅ ꠛꠣꠠꠤ ꠎꠣꠄ, ꠔꠦ ꠔꠣꠞꠦ ꠢꠤꠞꠛꠣꠞ ꠁꠝꠣꠝꠞ ꠉꠦꠍꠦ ꠖꠦꠈꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","ꠁꠝꠣꠝꠦ ꠢꠤꠞꠛꠣꠞ ꠖꠦꠈꠛꠣ, ꠎꠥꠖꠤ ꠅꠃ ꠛꠦꠝꠣꠞ ꠌꠣꠝꠠꠣꠞ ꠃꠙꠞꠦ ꠀꠞꠅ ꠛꠣꠠꠤ ꠎꠣꠄ, ꠔꠦ ꠛꠥꠎꠣ ꠎꠣꠁꠛ, ꠁꠔꠣ ꠘꠣꠙꠣꠇ ꠙꠌꠣ-ꠇꠥꠡ꠆ꠑ ꠛꠦꠝꠣꠞ, ꠔꠣꠁꠘ ꠄꠞꠦ ꠘꠣꠙꠣꠇ ꠇꠁꠀ ꠄꠟꠣꠘ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“ꠇꠥꠘꠥ ꠝꠣꠘꠡꠞ ꠌꠣꠝꠠꠣꠔ ꠙꠌꠣ-ꠇꠥꠡ꠆ꠑ ꠛꠦꠝꠣꠞꠞ ꠟꠣꠈꠣꠘ ꠖꠦꠈꠣ ꠉꠦꠟꠦ ꠔꠣꠞꠦ ꠘꠤꠀ ꠁꠝꠣꠝ ꠍꠣꠛꠞ ꠉꠦꠍꠦ ꠖꠦꠈꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","ꠁꠝꠣꠝꠦ ꠖꠦꠈꠛꠣ, ꠔꠣꠞ ꠉꠔꠞꠅ ꠇꠥꠘꠥ ꠎꠣꠉꠣꠞ ꠌꠣꠝꠠꠣꠞ ꠃꠙꠞꠦ ꠎꠥꠖꠤ ꠗꠟꠣ ꠅꠁꠀ ꠚꠥꠟꠤ ꠎꠣꠄ, ꠀꠞ ꠢꠘꠞ ꠞꠥꠝꠣ ꠗꠟꠣ ꠅꠁꠎꠣꠄ, ꠅꠃ ꠚꠥꠟꠣ ꠎꠣꠉꠣꠔ ꠇꠣꠌꠣ ꠊꠣ ꠕꠣꠇꠦ, ");
INSERT INTO syls_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ꠔꠦ ꠔ ꠁꠐꠣ ꠄꠇꠐꠣ ꠙꠥꠞꠣꠘꠣ ꠙꠌꠣ-ꠇꠥꠡ꠆ꠑ ꠛꠦꠝꠣꠞ। ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠘꠣꠙꠣꠇ ꠇꠁꠀ ꠄꠟꠣꠘ ꠇꠞꠛꠣ। ꠔꠣꠞꠦ ꠙꠞꠤꠇ꠆ꠇꠣꠞ ꠟꠣꠉꠤ ꠡꠝꠣꠎꠞ ꠝꠣꠘꠡꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠇꠥꠘꠥ ꠝꠤꠀꠖꠦ ꠖꠥꠞꠁ ꠞꠣꠈꠣꠞ ꠎꠞꠥꠞ ꠘꠣꠄ, ꠢꠦ ꠔ ꠄꠝꠘꠦꠃ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠀꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“ꠅꠁꠟꠦ ꠁ ꠛꠦꠝꠣꠞ ꠎꠥꠖꠤ ꠀꠡ꠆ꠔꠣ ꠡꠞꠤꠟꠅ ꠅꠁꠎꠣꠄ, ꠀꠞ ꠁꠝꠣꠝꠦ ꠡꠞꠤꠟꠞ ꠎꠔ ꠎꠣꠉꠣ ꠖꠦꠈꠔꠣ ꠙꠣꠞꠂꠘ, ꠅꠔꠣ ꠖꠦꠈꠤꠀ ꠎꠥꠖꠤ ꠔꠣꠘ ꠝꠘꠅ ꠅꠄ, ꠁ ꠛꠦꠝꠣꠞ ꠝꠣꠕꠣ ꠕꠣꠇꠤ ꠙꠣꠅ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠀꠍꠦ, ");
INSERT INTO syls_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ꠔꠦ ꠔꠣꠞꠦ ꠀꠞꠅ ꠜꠣꠟꠣꠝꠘ꠆ꠔꠦ ꠖꠦꠈꠛꠣ, ꠀꠞ ꠖꠦꠈꠤꠀ ꠎꠥꠖꠤ ꠛꠥꠎꠣ ꠎꠣꠄ, ꠁ ꠛꠦꠝꠣꠞꠦ ꠔꠣꠞ ꠀꠡ꠆ꠔꠣ ꠉꠔꠞ ꠗꠟꠣ ꠅꠁꠉꠦꠍꠦ, ꠔꠦ ꠔꠣꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠁꠀ ꠄꠟꠣꠘ ꠇꠞꠛꠣ। ꠔꠣꠞ ꠀꠡ꠆ꠔꠣ ꠉꠔꠞ ꠗꠟꠣ ꠅꠀꠄ ꠢꠦ ꠘꠣꠙꠣꠇ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","ꠅꠁꠟꠦ ꠄꠞꠛꠣꠖꠦ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠇꠣꠌꠣ ꠊꠣ ꠖꠦꠈꠣ ꠖꠦꠄ, ꠔꠦ ꠢꠦ ꠘꠣꠙꠣꠇ। ");
INSERT INTO syls_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","ꠁꠝꠣꠝꠦ ꠅꠃ ꠊꠣ ꠖꠦꠈꠤꠀ ꠔꠣꠞꠦ ꠘꠣꠙꠣꠇ ꠇꠁꠀ ꠄꠟꠣꠘ ꠇꠞꠛꠣ। ꠅꠃ ꠊꠣ ꠔ ꠘꠣꠙꠣꠇ, ꠔꠣꠞ ꠘꠣꠙꠣꠇ ꠙꠌꠣ-ꠇꠥꠡ꠆ꠑ ꠛꠦꠝꠣꠞ ꠅꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","ꠛꠣꠖꠦ ꠅꠃ ꠇꠣꠌꠣ ꠊꠣ ꠢꠥꠇꠣꠁꠀ ꠎꠥꠖꠤ ꠗꠟꠣ ꠅꠁꠎꠣꠄ, ꠔꠦ ꠔꠣꠞꠦ ꠢꠤꠞꠛꠣꠞ ꠁꠝꠣꠝꠞ ꠉꠦꠍꠦ ꠘꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠢꠤꠞꠛꠣꠞ ꠖꠦꠈꠛꠣ, ꠔꠣꠞ ꠀꠡ꠆ꠔꠣ ꠉꠔꠞꠞ ꠛꠦꠝꠣꠞ ꠎꠥꠖꠤ ꠙꠥꠞꠣꠙꠥꠞ ꠗꠟꠣ ꠅꠁꠎꠣꠄ, ꠔꠦ ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠁꠀ ꠄꠟꠣꠘ ꠇꠞꠛꠣ, ꠢꠦ ꠀꠍꠟꠦꠃ ꠙꠣꠇ-ꠍꠣꠚ। ");
INSERT INTO syls_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“ꠇꠥꠘꠥ ꠝꠣꠘꠡꠞ ꠉꠔꠞꠅ ꠎꠥꠖꠤ ꠛꠞꠘ ꠅꠁꠀ ꠁꠐꠣ ꠜꠣꠟꠣ ꠅꠁꠎꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ꠀꠞ ꠅꠃ ꠎꠣꠉꠣ ꠛꠣꠖꠦ ꠗꠟꠣ ꠅꠁꠀ ꠚꠥꠟꠤ ꠎꠣꠄ, ꠛꠣ ꠟꠣꠟꠐꠤ-ꠗꠟꠣ ꠖꠣꠉ ꠅꠄ, ꠔꠦ ꠔꠣꠞꠦ ꠁꠝꠣꠝꠞ ꠉꠦꠍꠦ ꠘꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠖꠦꠈꠛꠣ, ꠢꠤ ꠛꠦꠝꠣꠞ ꠎꠥꠖꠤ ꠌꠣꠝꠠꠣꠞ ꠔꠟꠦ ꠉꠤꠀ ꠉꠥꠡ꠆ꠔꠞ ꠝꠣꠎꠦ ꠟꠣꠉꠤꠎꠣꠄ, ꠞꠥꠝꠣ ꠗꠟꠣ ꠅꠁꠎꠣꠄ, ꠔꠦ ꠁꠐꠣ ꠔ ꠛꠞꠘꠞ ꠎꠣꠉꠣꠔ ꠎꠘꠝ ꠟꠅꠀ ꠙꠌꠣ-ꠇꠥꠡ꠆ꠑ ꠛꠦꠝꠣꠞ, ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠘꠣꠙꠣꠇ ꠇꠁꠀ ꠄꠟꠣꠘ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","ꠅꠁꠟꠦ ꠁꠝꠣꠝꠦ ꠇꠥꠘꠥ ꠗꠟꠣ ꠞꠥꠝꠣ ꠘꠣ ꠖꠦꠈꠟꠦ, ꠀꠞ ꠅꠃ ꠊꠣ ꠎꠥꠖꠤ ꠌꠣꠝꠠꠣꠞ ꠔꠟꠦ ꠘꠣ ꠉꠤꠀ ꠢꠥꠇꠣꠁꠎꠤꠛꠣꠞ ꠟꠣꠈꠣꠘ ꠅꠄ, ꠔꠦ ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠡꠣꠔ ꠖꠤꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠡꠝꠣꠎ ꠕꠣꠇꠤ ꠀꠟꠉ ꠞꠣꠈꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","ꠛꠣꠖꠦ ꠎꠥꠖꠤ ꠖꠦꠈꠣ ꠎꠣꠄ, ꠁꠔꠣ ꠌꠣꠝꠠꠣꠞ ꠃꠙꠞꠦ ꠍꠤꠔ꠆ꠞꠤ ꠎꠣꠞ, ꠔꠦ ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠘꠣꠙꠣꠇ ꠇꠁꠀ ꠄꠟꠣꠘ ꠇꠞꠛꠣ, ꠁꠔꠣ ꠄꠇꠟꠣꠈꠣꠘ ꠙꠌꠣ-ꠇꠥꠡ꠆ꠑ ꠛꠦꠝꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","ꠅꠁꠟꠦ ꠇꠥꠘꠥ ꠟꠣꠈꠣꠘ ꠇꠝ-ꠛꠦꠡꠤ ꠘꠣ ꠅꠁꠟꠦ, ꠘꠣ ꠍꠤꠔ꠆ꠞꠤꠟꠦ ꠛꠥꠎꠣ ꠎꠣꠁꠛ ꠁꠔꠣ ꠈꠣꠟꠤ ꠛꠞꠘꠞ ꠖꠣꠉ, ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠁꠀ ꠄꠟꠣꠘ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“ꠇꠥꠘꠥ ꠝꠣꠘꠡꠞ ꠉꠔꠞꠞ ꠇꠥꠘꠥ ꠅꠋꠡ ꠎꠥꠖꠤ ꠀꠉꠥꠁꠘꠦ ꠎꠟꠤ ꠎꠣꠄ, ꠀꠞ ꠅꠃ ꠎꠟꠣꠞ ꠎꠣꠉꠣꠔ ꠇꠣꠌꠣ ꠊꠣꠞ ꠝꠣꠎꠦ ꠟꠣꠟꠐꠤ ꠛꠣ ꠗꠟꠣ ꠖꠣꠉ ꠖꠦꠈꠣ ꠖꠦꠄ, ");
INSERT INTO syls_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ꠔꠦ ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠙꠞꠤꠇ꠆ꠇꠣ ꠇꠞꠤ ꠖꠦꠈꠛꠣ। ꠀꠞ ꠎꠥꠖꠤ ꠖꠦꠈꠣ ꠎꠣꠄ, ꠞꠥꠝꠣ ꠗꠟꠣ ꠅꠁꠉꠦꠍꠦ, ꠅꠃ ꠊꠣ ꠌꠣꠝꠠꠣꠞ ꠔꠟꠦ ꠉꠤꠀ ꠉꠥꠡ꠆ꠔꠞ ꠝꠣꠎꠦ ꠟꠣꠉꠤꠉꠦꠍꠦ, ꠔꠦ ꠁꠐꠣ ꠔ ꠎꠣꠟꠣꠁꠟ ꠎꠣꠉꠣꠔ ꠎꠘꠝ ꠟꠅꠀ ꠙꠌꠣ-ꠇꠥꠡ꠆ꠑ ꠛꠦꠝꠣꠞ ꠅꠁꠀ ꠛꠣꠞ ꠅꠁꠍꠦ। ꠁꠔꠣ ꠔ ꠘꠣꠙꠣꠇ ꠙꠌꠣ-ꠇꠥꠡ꠆ꠑ ꠛꠦꠝꠣꠞ, ꠄꠞꠟꠣꠉꠤ ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠘꠣꠙꠣꠇ ꠇꠁꠀ ꠄꠟꠣꠘ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","ꠅꠁꠟꠦ ꠁꠝꠣꠝꠦ ꠙꠞꠤꠇ꠆ꠇꠣ ꠇꠞꠤꠀ ꠎꠥꠖꠤ ꠖꠦꠈꠂꠘ, ꠁ ꠎꠣꠉꠣꠞ ꠞꠥꠝꠣ ꠗꠟꠣ ꠅꠁꠍꠦ ꠘꠣ, ꠀꠞ ꠊꠣ ꠍꠤꠔ꠆ꠞꠤꠀ ꠉꠤꠀ ꠉꠥꠡ꠆ꠔꠞ ꠝꠣꠎꠦ ꠘꠣ ꠟꠣꠉꠤꠀ ꠝꠤꠟꠤ ꠎꠣꠞ, ꠔꠦ ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠡꠣꠔ ꠖꠤꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠡꠝꠣꠎ ꠕꠣꠇꠤ ꠀꠟꠉ ꠞꠣꠈꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ꠛꠣꠖꠦ ꠁꠝꠣꠝꠦ ꠡꠣꠔ ꠖꠤꠘꠞ ꠖꠤꠘ ꠔꠣꠞꠦ ꠢꠤꠞꠛꠣꠞ ꠖꠦꠈꠛꠣ, ꠎꠥꠖꠤ ꠖꠦꠈꠂꠘ, ꠅꠃ ꠛꠦꠝꠣꠞ ꠛꠣꠠꠤ ꠎꠣꠞ, ꠔꠦ ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠘꠣꠙꠣꠇ ꠇꠁꠀ ꠄꠟꠣꠘ ꠇꠞꠛꠣ। ꠁꠔꠣ ꠄꠇꠟꠣꠈꠣꠘ ꠘꠣꠙꠣꠇ ꠙꠌꠣ-ꠇꠥꠡ꠆ꠑ ꠛꠦꠝꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","ꠅꠁꠟꠦ ꠁ ꠎꠣꠉꠣ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠇꠝ-ꠛꠦꠡ ꠘꠣ ꠅꠁꠀ ꠎꠦꠟꠣ ꠀꠍꠤꠟ ꠅꠟꠣ ꠕꠣꠇꠦ, ꠀꠞ ꠌꠣꠝꠠꠣꠞ ꠝꠣꠎꠦ ꠘꠣ ꠍꠤꠔ꠆ꠞꠤꠀ ꠝꠤꠟꠤ ꠎꠣꠅꠀꠔ ꠞꠄ, ꠔꠦ ꠁꠔꠣ ꠀꠉꠥꠁꠘꠦ ꠎꠟꠣꠞ ꠚꠥꠟꠣ ꠇꠁꠀ ꠗꠞꠣ ꠅꠁꠛ। ꠁꠔꠣ ꠔ ꠄꠇꠟꠣꠈꠣꠘ ꠎꠟꠣꠞ ꠖꠣꠉ, ꠀꠞ ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠁꠀ ꠄꠟꠣꠘ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“ꠀꠞ ꠇꠥꠘꠥ ꠛꠦꠐꠣ ꠛꠣ ꠛꠦꠐꠤꠞ ꠝꠣꠕꠣ ꠛꠣ ꠖꠣꠠꠤ-ꠝꠥꠍꠞ ꠝꠣꠎꠦ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠊꠣꠞ ꠀꠟꠣꠝꠔ ꠖꠦꠈꠣ ꠖꠦꠄ, ");
INSERT INTO syls_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ꠔꠦ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠔꠣꠞꠦ ꠙꠞꠤꠇ꠆ꠇꠣ ꠇꠞꠤ ꠖꠦꠈꠛꠣ। ꠔꠣꠁꠘ ꠎꠥꠖꠤ ꠖꠦꠈꠂꠘ, ꠛꠦꠝꠣꠞꠤ ꠎꠣꠉꠣꠞ ꠌꠥꠟ ꠛꠣ ꠞꠥꠝ ꠅꠟꠖꠤꠀ ꠅꠁꠀ ꠌꠤꠇꠘ ꠅꠁꠉꠦꠍꠦ, ꠀꠞ ꠊꠣ ꠌꠣꠝꠠꠣꠞ ꠔꠟꠦ ꠉꠤꠀ ꠉꠥꠡ꠆ꠔꠞ ꠝꠣꠎꠦ ꠟꠣꠉꠤꠉꠦꠍꠦ, ꠔꠦ ꠁꠐꠣ ꠔ ꠄꠇꠟꠣꠈꠣꠘ ꠖꠣꠃꠖ-ꠈꠣꠃꠎꠟꠤꠞ ꠝꠥꠈ, ꠁꠔꠣ ꠖꠣꠠꠤ-ꠝꠥꠍ ꠛꠣ ꠝꠣꠕꠣꠞ ꠌꠣꠝꠠꠣꠔ ꠙꠌꠣ-ꠇꠥꠡ꠆ꠑ ꠛꠦꠝꠣꠞ ꠛꠣꠞ ꠅꠁꠍꠦ। ꠄꠞꠟꠣꠉꠤ ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠘꠣꠙꠣꠇ ꠇꠁꠀ ꠄꠟꠣꠘ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","ꠅꠁꠟꠦ ꠁꠝꠣꠝꠦ ꠎꠥꠖꠤ ꠛꠦꠝꠣꠞ ꠙꠞꠤꠇ꠆ꠇꠣ ꠇꠞꠤꠀ ꠖꠦꠈꠂꠘ, ꠁ ꠊꠣ ꠌꠣꠝꠠꠣꠞ ꠔꠟꠦ ꠉꠦꠍꠦ ꠘꠣ, ꠀꠞ ꠅꠘꠞ ꠌꠥꠟ ꠛꠣ ꠞꠥꠝ ꠔ ꠇꠣꠟꠣ ꠘꠣꠄ, ꠔꠦ ꠅꠃ ꠛꠦꠝꠣꠞꠤꠞꠦ ꠡꠣꠔ ꠖꠤꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠡꠝꠣꠎ ꠕꠣꠇꠤ ꠀꠟꠉ ꠞꠣꠈꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ꠛꠣꠖꠦ ꠡꠣꠔ ꠖꠤꠘꠞ ꠖꠤꠘ ꠁꠝꠣꠝꠦ ꠢꠤꠞꠛꠣꠞ ꠙꠞꠤꠇ꠆ꠇꠣ ꠇꠞꠤ ꠎꠥꠖꠤ ꠖꠦꠈꠂꠘ, ꠁ ꠖꠣꠃꠖ-ꠈꠣꠃꠎꠟꠤ ꠛꠦꠝꠣꠞ ꠛꠣꠠꠍꠦ ꠘꠣ, ꠛꠣ ꠌꠥꠟ-ꠞꠥꠝꠅ ꠅꠟꠖꠤꠀ ꠅꠁꠍꠦ ꠘꠣ, ꠀꠞ ꠅꠘꠞ ꠊꠣ ꠌꠣꠝꠠꠣꠞ ꠔꠟꠞ ꠉꠥꠡ꠆ꠔꠞ ꠝꠣꠎꠦ ꠟꠣꠉꠍꠦ ꠘꠣ, ");
INSERT INTO syls_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ꠔꠦ ꠅꠃ ꠖꠣꠃꠖ-ꠈꠣꠃꠎꠟꠤꠞ ꠎꠣꠉꠣ ꠛꠣꠖ ꠖꠤꠀ, ꠔꠣꠞ ꠡꠞꠤꠟꠞ ꠛꠣꠖ-ꠛꠣꠇꠤ ꠌꠥꠟ ꠛꠣ ꠖꠣꠠꠤ-ꠝꠥꠍ ꠇꠣꠝꠣꠁꠟꠤꠔꠦ ꠅꠁꠛ। ꠛꠣꠖꠦ ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠀꠞꠅ ꠡꠣꠔ ꠖꠤꠘ ꠡꠝꠣꠎ ꠕꠣꠇꠤ ꠀꠟꠉ ꠞꠣꠈꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ꠀꠞ ꠡꠣꠔ ꠖꠤꠘꠞ ꠖꠤꠘ ꠁꠝꠣꠝꠦ ꠢꠤꠞꠛꠣꠞ ꠙꠞꠤꠇ꠆ꠇꠣ ꠇꠞꠤꠀ ꠎꠥꠖꠤ ꠖꠦꠈꠂꠘ, ꠁ ꠖꠣꠃꠖ-ꠈꠣꠃꠎꠟꠤ ꠌꠣꠝꠠꠣꠞ ꠃꠙꠞꠦ ꠍꠤꠔ꠆ꠞꠤꠍꠦ ꠘꠣ, ꠛꠣ ꠌꠣꠝꠠꠣꠞ ꠔꠟꠦꠖꠤ ꠉꠥꠡ꠆ꠔꠞ ꠝꠣꠎꠦꠅ ꠟꠣꠉꠍꠦ ꠘꠣ, ꠔꠦ ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠁꠀ ꠄꠟꠣꠘ ꠇꠞꠛꠣ। ꠀꠞ ꠢꠦ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠢꠣꠞꠤ ꠙꠣꠇ-ꠙꠣꠇꠤꠎꠣ ꠛꠘꠛ। ");
INSERT INTO syls_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","ꠔꠣ-ꠅ ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠁꠀ ꠄꠟꠣꠘ ꠇꠞꠣꠞ ꠛꠣꠖꠦꠅ ꠎꠥꠖꠤ ꠁ ꠖꠣꠃꠖ-ꠈꠣꠃꠎꠟꠤ ꠌꠣꠝꠠꠣꠞ ꠃꠙꠞꠦ ꠍꠤꠔ꠆ꠞꠤ ꠎꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ꠔꠦ ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠢꠤꠞꠛꠣꠞ ꠖꠦꠈꠛꠣ। ꠔꠣꠁꠘ ꠎꠥꠖꠤ ꠖꠦꠈꠂꠘ, ꠁ ꠖꠣꠃꠖ-ꠈꠣꠃꠎꠟꠤ ꠍꠤꠔ꠆ꠞꠤ ꠉꠦꠍꠦ, ꠔꠦ ꠌꠥꠟ ꠛꠣ ꠞꠥꠝ ꠅꠟꠖꠤꠀ ꠅꠁꠍꠦ ꠇꠤ ꠘꠣ ꠁꠔꠣ ꠀꠞ ꠙꠞꠤꠇ꠆ꠇꠣ ꠇꠞꠣꠞ ꠎꠞꠥꠞ ꠘꠣꠄ, ꠢꠦ ꠔ ꠄꠝꠘꠦꠃ ꠘꠣꠙꠣꠇ। ");
INSERT INTO syls_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","ꠅꠁꠟꠦ ꠁꠝꠣꠝꠦ ꠎꠥꠖꠤ ꠝꠘꠅ ꠇꠞꠂꠘ, ꠁꠔꠣ ꠎꠦꠟꠣ ꠀꠍꠤꠟ ꠅꠟꠣꠃ ꠞꠁꠍꠦ, ꠀꠞ ꠁ ꠎꠣꠉꠣꠔ ꠇꠣꠟꠣ ꠞꠥꠝꠣ ꠃꠑꠦꠞ, ꠔꠦ ꠛꠥꠎꠛꠣ, ꠁꠔꠣ ꠜꠣꠟꠣ ꠅꠁꠉꠦꠍꠦ। ꠢꠦ ꠔ ꠙꠣꠇ-ꠙꠣꠇꠤꠎꠣ ꠀꠍꠦ। ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠁꠀ ꠄꠟꠣꠘ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“ꠇꠥꠘꠥ ꠛꠦꠐꠣ ꠛꠣ ꠛꠦꠐꠤꠞ ꠌꠣꠝꠠꠣꠞ ꠝꠣꠎꠦ ꠎꠥꠖꠤ ꠗꠟꠣ ꠌꠇꠌꠇꠣ ꠖꠣꠉ ꠖꠦꠈꠣ ꠎꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ꠔꠦ ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠙꠞꠤꠇ꠆ꠇꠣ ꠇꠞꠤ ꠖꠦꠈꠛꠣ। ꠔꠣꠁꠘ ꠎꠥꠖꠤ ꠖꠦꠈꠂꠘ, ꠔꠣꠞ ꠖꠣꠉ ꠗꠟꠣ ꠚꠣꠁꠘꠡꠣ ꠅꠁꠉꠦꠍꠦ, ꠔꠦ ꠁꠐꠣ ꠔ ꠈꠣꠟꠤ ꠗꠟ-ꠚꠤꠡ꠆ꠔꠤ ꠅꠁꠍꠦ। ꠁꠔꠣꠄ ꠇꠥꠘꠥ ꠈꠦꠔꠤ ꠅꠁꠔ ꠘꠣꠄ, ꠢꠦ ꠔ ꠙꠣꠇ-ꠍꠣꠚ ꠀꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“ꠀꠞ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠞ ꠎꠥꠖꠤ ꠝꠣꠕꠣꠞ ꠌꠥꠟ ꠙꠠꠤꠀ ꠐꠣꠇ ꠅꠁꠎꠣꠄ, ꠔꠦ ꠢꠦ ꠘꠣꠙꠣꠇ ꠅꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","ꠔꠣꠞ ꠝꠣꠕꠣꠞ ꠍꠣꠝꠘꠞ ꠉꠣꠟꠣꠞ ꠌꠥꠟ ꠙꠠꠤꠀ ꠎꠥꠖꠤ ꠇꠙꠣꠟꠞ ꠛꠣꠄ ꠐꠣꠇ ꠙꠠꠤ ꠎꠣꠄ, ꠔꠦ ꠢꠦ-ꠅ ꠘꠣꠙꠣꠇ ꠅꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","ꠅꠁꠟꠦ ꠁ ꠐꠣꠇ ꠙꠠꠣ ꠝꠣꠕꠣ ꠛꠣ ꠇꠙꠣꠟꠞ ꠝꠣꠎꠦ ꠎꠥꠖꠤ ꠟꠣꠟꠐꠤ ꠖꠣꠉ ꠖꠦꠈꠣ ꠖꠦꠄ, ꠔꠦ ꠛꠥꠎꠛꠣꠄ, ꠔꠣꠞ ꠝꠣꠕꠣ ꠛꠣ ꠇꠙꠣꠟꠅ ꠙꠌꠣ-ꠇꠥꠡ꠆ꠑ ꠛꠦꠝꠣꠞ ꠛꠣꠞ ꠅꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","ꠀꠞ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠔꠣꠞꠦ ꠙꠞꠤꠇ꠆ꠇꠣ ꠇꠞꠤꠀ ꠎꠥꠖꠤ ꠖꠦꠈꠂꠘ, ꠔꠣꠞ ꠇꠙꠣꠟꠅ ꠛꠣ ꠝꠣꠕꠣꠔ ꠘꠣꠙꠣꠇ ꠙꠌꠣ-ꠇꠥꠡ꠆ꠑ ꠛꠦꠝꠣꠞꠤꠞ ꠟꠣꠈꠣꠘ ꠢꠃ ꠖꠣꠉ ꠔ ꠚꠥꠟꠤ ꠉꠦꠍꠦ, ");
INSERT INTO syls_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ꠔꠦ ꠛꠥꠎꠣ ꠎꠣꠁꠛ, ꠔꠣꠞ ꠘꠣꠙꠣꠇ ꠙꠌꠣ-ꠇꠥꠡ꠆ꠑ ꠛꠦꠝꠣꠞ ꠅꠁꠍꠦ, ꠢꠦ ꠔ ꠘꠣꠙꠣꠇ। ꠔꠣꠞ ꠝꠣꠕꠣꠞ ꠅꠃ ꠛꠦꠝꠣꠞꠞ ꠟꠣꠉꠤ ꠁꠝꠣꠝꠦ ꠔꠣꠞꠦ ꠘꠣꠙꠣꠇ ꠇꠁꠀ ꠄꠟꠣꠘ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“ꠀꠞ ꠅꠃ ꠟꠣꠈꠣꠘ ꠙꠌꠣ-ꠇꠥꠡ꠆ꠑ ꠛꠦꠝꠣꠞ ꠎꠦ ꠝꠣꠘꠡꠞ ꠅꠁꠛ, ꠢꠦ ꠚꠣꠞꠣ-ꠌꠤꠞꠣ ꠇꠣꠙꠠ ꠚꠤꠘ꠆ꠖꠤꠔꠦ ꠅꠁꠛ। ꠔꠣꠞ ꠝꠣꠕꠣꠞ ꠌꠥꠟ ꠀꠃꠟꠣ-ꠎꠣꠃꠟꠣ ꠞꠁꠛ। ꠔꠣꠞ ꠝꠥꠈꠞꠦ ꠢꠤꠎꠣꠛꠞ ꠟꠣꠈꠣꠘ ꠇꠣꠙꠠꠖꠤ ꠉꠥꠞꠤꠀ ꠌꠤꠟ꠆ꠟꠣꠁ ꠌꠤꠟ꠆ꠟꠣꠁ ꠇꠁꠛ, ꠘꠣꠙꠣꠇ, ꠘꠣꠙꠣꠇ। ");
INSERT INTO syls_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","ꠁ ꠛꠦꠝꠣꠞ ꠔꠣꠞ ꠉꠔꠞꠅ ꠎꠔꠖꠤꠘ ꠞꠁꠛ, ꠅꠔꠖꠤꠘ ꠢꠦ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠞꠁꠛ। ꠢꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠇꠦꠝ꠆ꠙꠞ ꠛꠣꠞꠦ ꠄꠇꠟꠣ ꠄꠇꠟꠣ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“ꠇꠥꠘꠥ ꠇꠣꠙꠠꠞ ꠝꠣꠎꠦ ꠎꠥꠖꠤ ꠍꠣꠛꠣ ꠍꠣꠛꠣ ꠖꠣꠉ ꠟꠣꠉꠦ, ꠃꠟꠞ ꠇꠣꠙꠠ ꠛꠣ ꠡꠥꠔꠤ ꠇꠣꠙꠠꠞ ꠝꠣꠎꠦ ꠎꠥꠖꠤ ꠚꠦꠃꠇꠘꠤ ꠙꠠꠣꠞ ꠀꠟꠣꠝꠔ ꠝꠤꠟꠦ, ");
INSERT INTO syls_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ꠁꠔꠣ ꠃꠟꠞ ꠇꠣꠙꠠ ꠛꠣ ꠡꠥꠔꠤ ꠇꠣꠙꠠ ꠛꠣꠘꠣꠘꠤꠞ ꠐꠣꠘꠣ ꠛꠣ ꠔꠣꠔꠞ ꠝꠣꠎꠦ ꠅꠃꠇ, ꠛꠣ ꠌꠣꠝꠠꠣ ꠀꠞ ꠌꠣꠝꠠꠣꠖꠤ ꠛꠣꠘꠣꠁꠟ ꠎꠦꠇꠥꠘꠥ ꠎꠤꠘꠤꠡꠞ ꠝꠣꠎꠦ ꠎꠥꠖꠤ ꠚꠦꠃꠇꠘꠤꠞ ꠖꠣꠉ ꠝꠤꠟꠦ, ");
INSERT INTO syls_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ꠀꠞ ꠚꠤꠘ꠆ꠘꠞ ꠇꠣꠙꠠꠞ ꠐꠣꠘꠣ ꠛꠣ ꠔꠣꠔꠞ ꠝꠣꠎꠦ, ꠌꠣꠝꠠꠣꠞ ꠇꠥꠘꠥ ꠎꠤꠘꠤꠡꠅ ꠎꠥꠖꠤ ꠟꠣꠟꠐꠤ ꠛꠣ ꠇꠌꠥꠀ ꠇꠥꠘꠥꠎꠣꠔ ꠖꠣꠉ ꠝꠤꠟꠦ, ꠔꠦ ꠁꠔꠣ ꠅꠁꠟ ꠚꠦꠃꠇꠘꠤꠞ ꠀꠟꠣꠝꠔ। ꠁꠟꠣ ꠅꠁꠟꠦ ꠁꠝꠣꠝ ꠍꠣꠛꠞ ꠉꠦꠍꠦ ꠖꠦꠈꠣꠘꠤ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠁꠔꠣ ꠜꠣꠟꠣꠝꠘ꠆ꠔꠦ ꠙꠞꠤꠇ꠆ꠇꠣ ꠇꠞꠤ ꠖꠦꠈꠤꠀ, ꠅꠃ ꠎꠤꠘꠤꠡꠞꠦ ꠡꠣꠔ ꠖꠤꠘ ꠢꠇꠟꠔꠣ ꠕꠣꠇꠤ ꠢꠞꠣꠁꠀ ꠞꠣꠈꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","ꠛꠣꠖꠦ ꠡꠣꠔ ꠖꠤꠘꠞ ꠖꠤꠘ ꠁꠝꠣꠝꠦ ꠢꠤꠞꠛꠣꠞ ꠖꠦꠈꠛꠣ। ꠔꠣꠁꠘ ꠎꠥꠖꠤ ꠖꠦꠈꠂꠘ, ꠅꠃ ꠇꠣꠙꠠꠞ ꠐꠣꠘꠣꠔ ꠛꠣ ꠔꠣꠔꠅ, ꠛꠣ ꠌꠣꠝꠠꠣꠞ ꠎꠤꠘꠤꠡꠅ ꠟꠣꠟꠐꠤ ꠛꠣ ꠇꠌꠥꠀ ꠖꠣꠉ ꠛꠣꠠꠤꠍꠦ, ꠔꠦ ꠢꠃ ꠚꠦꠃꠇꠘꠤ ꠛꠦꠝꠣꠞ ꠛꠠ ꠝꠣꠞꠣꠔ꠆ꠔꠇ, ꠅꠃ ꠎꠤꠘꠤꠡ ꠔ ꠘꠣꠙꠣꠇ। ");
INSERT INTO syls_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","ꠄꠞꠟꠣꠉꠤ ꠁ ꠇꠣꠙꠠ, ꠛꠣ ꠌꠣꠝꠠꠣꠞ ꠅꠃ ꠎꠤꠘꠤꠡ, ꠉꠣꠝꠍꠣ ꠛꠣ ꠃꠠꠘꠣ ꠎꠦꠔꠣꠞ ꠝꠣꠎꠦ ꠁꠟꠣ ꠚꠦꠃꠇꠘꠤꠞ ꠖꠣꠉ ꠝꠤꠟꠛ, ꠁꠔꠣ ꠢꠣꠍꠞꠤꠛ ꠇꠞꠤ ꠢꠇꠟꠔꠣ ꠎꠣꠟꠣꠁꠟꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“ꠅꠁꠟꠦ ꠁꠝꠣꠝꠦ ꠎꠥꠖꠤ ꠖꠦꠈꠂꠘ, ꠁ ꠇꠣꠙꠠ ꠛꠣ ꠌꠣꠝꠠꠣꠞ ꠎꠤꠘꠤꠡꠞ ꠖꠣꠉ ꠘꠣ ꠍꠤꠔ꠆ꠞꠤꠀ ꠄꠇꠁ ꠎꠣꠉꠣꠔ ꠞꠁꠍꠦ, ");
INSERT INTO syls_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ꠔꠦ ꠔꠣꠁꠘ ꠁꠔꠣꠞꠦ ꠙꠣꠘꠤꠖꠤ ꠗꠁꠀ ꠖꠤꠛꠣꠞ ꠢꠥꠇꠥꠝ ꠖꠤꠛꠣ। ꠗꠁꠀ ꠢꠣꠞꠤ ꠅꠃ ꠎꠤꠘꠤꠡꠞꠦ ꠡꠣꠔ ꠖꠤꠘ ꠖꠥꠍꠞꠣ ꠢꠇꠟꠔꠣ ꠕꠣꠇꠤ ꠢꠞꠣꠁ ꠞꠣꠈꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","ꠛꠣꠖꠦ ꠁꠝꠣꠝꠦ ꠢꠤꠞꠛꠣꠞ ꠖꠦꠈꠛꠣ। ꠔꠣꠁꠘ ꠎꠥꠖꠤ ꠖꠦꠈꠂꠘ, ꠁ ꠚꠦꠃꠇꠘꠤꠞ ꠖꠣꠉ ꠇꠥꠘꠥꠛꠣꠄ ꠘꠣ ꠍꠤꠔ꠆ꠞꠤꠟꠦꠅ ꠀꠉꠞ ꠟꠣꠈꠣꠘ ꠞꠋ ꠞꠁꠍꠦ, ꠔꠦ ꠁꠔꠣ ꠘꠣꠙꠣꠇ। ꠁꠉꠥꠞ ꠃꠟꠐꠣ-ꠜꠣꠐꠤꠅꠟ ꠎꠦꠇꠥꠘꠥ ꠉꠣꠟꠣꠛꠣꠄ ꠁ ꠖꠣꠉ ꠞꠃꠇ, ꠁꠉꠥꠞꠦ ꠀꠉꠥꠁꠘꠖꠤ ꠎꠣꠟꠣꠁꠟꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","ꠅꠁꠟꠦ ꠁꠔꠣ ꠗꠁꠀ ꠖꠦꠅꠀꠞ ꠛꠣꠖꠦ ꠎꠥꠖꠤ ꠁꠝꠣꠝꠦ ꠖꠦꠈꠂꠘ, ꠁ ꠎꠣꠉꠣꠞ ꠞꠋ ꠚꠣꠁꠘꠡꠣ ꠅꠁꠉꠦꠍꠦ, ꠔꠦ ꠅꠃ ꠎꠣꠉꠣ ꠍꠤꠠꠤꠀ ꠚꠣꠟꠣꠁ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","ꠀꠞ ꠗꠅꠀꠞ ꠛꠣꠖꠦꠅ ꠎꠥꠖꠤ ꠅꠃ ꠎꠤꠘꠤꠡꠅ ꠢꠤꠞꠛꠣꠞ ꠚꠦꠃꠇꠘꠤꠞ ꠖꠣꠉ ꠖꠦꠈꠣ ꠎꠣꠄ, ꠔꠦ ꠛꠥꠎꠛꠣꠄ, ꠁꠔꠣ ꠍꠤꠔ꠆ꠞꠤ ꠎꠣꠅꠀ ꠛꠦꠝꠣꠞ, ꠄꠞꠟꠣꠉꠤ ꠁ ꠎꠤꠘꠤꠡꠞꠦ ꠀꠉꠥꠁꠘꠖꠤ ꠎꠣꠟꠣꠁꠟꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","ꠀꠞ ꠅꠃ ꠎꠤꠘꠤꠡ ꠗꠅꠀꠞ ꠛꠣꠖꠦ ꠎꠥꠖꠤ ꠖꠦꠈꠂꠘ, ꠅꠃ ꠖꠣꠉ ꠝꠤꠟꠣꠁꠉꠦꠍꠦ, ꠔꠦ ꠁꠔꠣ ꠢꠤꠞꠛꠣꠞ ꠗꠁꠀ ꠢꠣꠞꠟꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠛꠥꠎꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","“ꠅꠃ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠝꠣꠘꠤꠀ ꠃꠟꠞ ꠇꠣꠙꠠ, ꠡꠥꠔꠤ ꠇꠣꠙꠠ ꠛꠣ ꠌꠣꠝꠠꠣꠞ ꠇꠥꠘꠥ ꠎꠤꠘꠤꠡꠅ ꠚꠦꠃꠇꠘꠤꠞ ꠖꠣꠉ ꠟꠣꠉꠟꠦ, ꠙꠣꠇ ꠛꠣ ꠘꠣꠙꠣꠇ ꠇꠁꠀ ꠄꠟꠣꠘ ꠇꠞꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“ꠙꠌꠣ-ꠇꠥꠡ꠆ꠑ ꠛꠦꠝꠣꠞꠤꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠞꠣꠞ ꠖꠤꠘ ꠅꠃ ꠘꠤꠅꠝ ꠝꠣꠘꠤꠅ। ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠔꠣꠞꠦ ꠖꠦꠈꠣꠞ ꠟꠣꠉꠤ, ");
INSERT INTO syls_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ꠇꠦꠝ꠆ꠙꠞ ꠛꠣꠞꠦ ꠉꠤꠀ ꠙꠞꠤꠇ꠆ꠇꠣ ꠇꠞꠤꠀ ꠖꠦꠈꠛꠣ। ꠔꠣꠁꠘ ꠎꠥꠖꠤ ꠖꠦꠈꠂꠘ ꠢꠦ ꠢꠣꠍꠣꠃ ꠜꠣꠟꠣ ꠅꠁꠉꠦꠍꠦ, ");
INSERT INTO syls_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ꠔꠦ ꠁꠝꠣꠝꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠛꠣ, ꠙꠣꠇ-ꠍꠣꠚ ꠅꠀ ꠎꠘꠞ ꠘꠤꠅꠔꠦ ꠎꠤꠔꠣ ꠖꠥꠁꠐꠣ ꠢꠣꠟꠣꠟ ꠙꠣꠈꠤ, ꠖꠦꠛꠖꠣꠞꠥ ꠉꠣꠍꠞ ꠇꠤꠍꠥ ꠟꠣꠇꠠꠤ, ꠄꠍꠥꠛ ꠉꠣꠍꠞ ꠒꠦꠐꠣ ꠀꠞ ꠟꠣꠟ ꠡꠥꠔꠣ ꠟꠁꠀ ꠀꠁꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","ꠛꠣꠖꠦ ꠁꠝꠣꠝꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠛꠣ, ꠚꠥꠔꠞ ꠙꠣꠘꠤ ꠕꠣꠇꠤ ꠙꠣꠘꠤ ꠀꠘꠤꠀ ꠝꠣꠐꠤꠞ ꠉꠣꠝꠟꠣꠔ ꠕꠅꠀ ꠙꠣꠘꠤꠞ ꠃꠙꠞꠦ, ꠢꠃ ꠖꠥꠁꠅ ꠙꠣꠈꠤꠞ ꠝꠣꠎꠞ ꠄꠇꠐꠣꠞꠦ ꠎꠛ ꠇꠞꠣꠞ ꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","ꠎꠛꠞ ꠛꠣꠖꠦ ꠁꠝꠣꠝꠦ ꠛꠣꠇꠤ ꠢꠃ ꠎꠤꠔꠣ ꠙꠣꠈꠤꠞꠦ, ꠖꠦꠛꠖꠣꠞꠥ ꠉꠣꠍꠞ ꠟꠣꠇꠠꠤꠞꠦ, ꠟꠣꠟ ꠡꠥꠔꠣꠞꠦ ꠀꠞ ꠄꠍꠥꠛ ꠉꠣꠍꠞ ꠒꠦꠐꠣꠞꠦ, ꠚꠥꠔꠞ ꠙꠣꠘꠤꠞ ꠉꠣꠝꠟꠣꠞ ꠃꠙꠞꠦ ꠎꠛ ꠇꠞꠣ ꠢꠃ ꠙꠣꠈꠤꠞ ꠟꠃꠞ ꠝꠣꠎꠦ ꠍꠥꠛꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","ꠀꠞ ꠅꠃ ꠎꠦ ꠛꠦꠝꠣꠞꠤꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠞꠣ ꠅꠁꠔ, ꠁꠝꠣꠝꠦ ꠔꠣꠞ ꠃꠙꠞꠦ ꠢꠃ ꠟꠃ ꠡꠣꠔ ꠛꠣꠞ ꠍꠤꠐꠣꠁꠀ ꠢꠣꠞꠤ, ꠔꠣꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠁꠀ ꠄꠟꠣꠘ ꠇꠞꠛꠣ। ꠛꠣꠖꠦ ꠁꠝꠣꠝꠦ ꠢꠃ ꠎꠤꠔꠣ ꠙꠣꠈꠤꠞꠦ ꠈꠥꠟꠣ ꠎꠣꠉꠣꠔ ꠍꠣꠠꠤ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","ꠀꠞ ꠙꠣꠇ-ꠍꠣꠚ ꠛꠘꠞꠣ ꠅꠃ ꠛꠦꠝꠣꠞꠤꠄ ꠔꠣꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠛ, ꠔꠣꠞ ꠉꠔꠞꠞ ꠀꠞ ꠝꠣꠕꠣꠞ ꠢꠇꠟ ꠌꠥꠟ-ꠞꠥꠝ ꠇꠣꠝꠣꠁꠀ ꠢꠣꠞꠤ ꠙꠣꠘꠤ ꠖꠤꠀ ꠘꠣꠁꠔꠦ ꠅꠁꠛ, ꠔꠦꠃ ꠢꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠛꠘꠛ। ꠄꠞꠛꠣꠖꠦ ꠢꠦ ꠀꠁꠀ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠇꠦꠝ꠆ꠙꠞ ꠜꠤꠔꠞꠦ ꠢꠣꠝꠣꠁꠔ ꠙꠣꠞꠛ, ꠅꠁꠟꠦ ꠔꠣꠞ ꠘꠤꠎꠞ ꠔꠣꠝ꠆ꠛꠥꠞ ꠛꠣꠞꠦ ꠡꠣꠔ ꠖꠤꠘ ꠞꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","ꠛꠣꠖꠦ ꠡꠣꠔ ꠖꠤꠘꠞ ꠖꠤꠘ ꠢꠤꠞꠛꠣꠞ ꠔꠣꠞ ꠡꠞꠤꠟꠞ ꠢꠇꠟ ꠌꠥꠟ, ꠝꠣꠘꠤ ꠝꠣꠕꠣꠞ ꠌꠥꠟ, ꠖꠣꠠꠤ-ꠝꠥꠍ, ꠌꠈꠥꠞ ꠜꠥꠞꠤ ꠀꠞ ꠉꠔꠞꠞ ꠢꠇꠟ ꠞꠥꠝꠣ ꠇꠣꠝꠣꠁꠔꠦ ꠅꠁꠛ। ꠛꠣꠖꠦ ꠔꠣꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠘꠣꠁꠀ ꠢꠣꠞꠟꠦ ꠢꠦ ꠙꠥꠞꠣꠙꠥꠞ ꠙꠣꠇ-ꠍꠣꠚ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“ꠛꠣꠖꠞ ꠖꠤꠘ ꠢꠦ ꠙꠥꠞꠣꠙꠥꠞ ꠘꠤꠈꠥꠔ ꠖꠥꠁꠐꠣ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠀꠞ ꠄꠇ ꠛꠍꠞꠞ ꠄꠉꠥ ꠝꠦꠠꠤ ꠟꠁꠀ ꠀꠁꠛ। ꠀꠞ ꠄꠞ ꠟꠉꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠘꠤꠅꠔꠦ ꠢꠦ ꠍꠄ ꠡꠦꠞ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠝꠄꠖꠣ ꠀꠞ ꠄꠇ ꠙꠣꠅꠀ ꠔꠦꠟ ꠀꠘꠛ। ");
INSERT INTO syls_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","ꠀꠘꠤꠀ ꠢꠣꠞꠟꠦ ꠔꠣꠞ ꠙꠣꠇ-ꠍꠣꠚꠞ ꠟꠣꠉꠤ ꠎꠦ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠇꠣꠝ ꠇꠞꠞꠣ, ꠄꠁꠘ ꠅꠃ ꠎꠘꠞꠦ ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣꠞꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠉꠦꠍꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠀꠎꠤꠞ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠢꠃ ꠖꠥꠁꠅ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠕꠣꠇꠤ ꠄꠉꠥ ꠝꠦꠠꠣ ꠀꠞ ꠢꠃ ꠔꠦꠟ ꠘꠤꠀ ꠖꠥꠡ-ꠇꠍꠥꠞꠤꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠛꠣ, ꠇꠞꠤꠀ ꠖꠥꠟꠘꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠁꠔꠣ ꠖꠥꠟꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","ꠛꠣꠖꠦ ꠙꠛꠤꠔ꠆ꠞ ꠇꠣꠛꠣ ꠊꠞꠞ ꠡꠤꠝꠣꠘꠣꠞ ꠎꠦ ꠎꠣꠉꠣꠔ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥ ꠎꠛ ꠇꠞꠣ ꠅꠄ, ꠢꠃ ꠎꠣꠉꠣꠔ ꠅꠃ ꠙꠡꠥꠞꠦꠅ ꠎꠛ ꠇꠞꠛꠣ। ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠈꠣꠘ ꠖꠥꠡ-ꠇꠍꠥꠞꠤꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠉꠥꠡ꠆ꠔꠅ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠙꠣꠁꠛꠣ, ꠁꠔꠣ ꠔ ꠈꠣꠍ ꠙꠛꠤꠔ꠆ꠞ ꠉꠥꠡ꠆ꠔ। ");
INSERT INTO syls_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","ꠎꠦ ꠎꠘꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠞꠣ ꠅꠁꠛ, ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠖꠥꠡ-ꠇꠍꠥꠞꠤꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠇꠤꠍꠥ ꠟꠃ ꠘꠤꠀ ꠔꠣꠞ ꠒꠣꠁꠘ ꠇꠣꠘꠞ ꠟꠔꠤꠔ, ꠒꠣꠁꠘ ꠀꠔꠞ ꠀꠞ ꠒꠣꠁꠘ ꠙꠣꠅꠞ ꠛꠥꠠꠤ ꠀꠋꠉꠥꠟꠤꠔ ꠟꠣꠉꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","ꠛꠣꠖꠦ ꠁꠝꠣꠝꠦ ꠢꠃ ꠔꠦꠟ ꠕꠣꠇꠤ ꠇꠤꠍꠥ ꠔꠦꠟ ꠔꠣꠘ ꠛꠣꠃ ꠀꠔꠞ ꠔꠣꠟꠥꠞ ꠝꠣꠎꠦ ꠓꠣꠟꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ꠀꠞ ꠒꠣꠁꠘ ꠀꠔꠞ ꠀꠋꠉꠥꠁꠟ ꠖꠤꠀ, ꠛꠣꠃ ꠀꠔ ꠕꠣꠇꠤ ꠔꠦꠟ ꠔꠥꠟꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠡꠣꠔ ꠛꠣꠞ ꠍꠤꠐꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","ꠛꠣꠖꠦ ꠀꠔꠞ ꠔꠣꠟꠥꠞ ꠛꠣꠖ-ꠛꠣꠇꠤ ꠔꠦꠟ ꠕꠣꠇꠤ ꠇꠤꠍꠥ ꠔꠦꠟ ꠘꠤꠀ ꠁꠝꠣꠝꠦ ꠢꠃ ꠎꠘꠞ ꠒꠣꠁꠘ ꠇꠣꠘꠞ ꠟꠔꠤꠔ, ꠒꠣꠁꠘ ꠀꠔꠞ ꠀꠞ ꠒꠣꠁꠘ ꠙꠣꠅꠞ ꠛꠥꠠꠤ ꠀꠋꠉꠥꠟꠤꠔ ꠖꠥꠡ-ꠇꠍꠥꠞꠤꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠃꠞ ꠃꠙꠞꠦ ꠟꠣꠉꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","ꠀꠞ ꠀꠔꠞ ꠔꠣꠟꠥꠞ ꠛꠣꠇꠤ ꠔꠦꠟ ꠔꠣꠁꠘ ꠢꠃ ꠙꠣꠇ-ꠍꠣꠚ ꠅꠀ ꠎꠘꠞ ꠝꠣꠕꠣꠔ ꠟꠣꠉꠣꠁꠛꠣ। “ꠀꠞ ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠔꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠛꠣ, ");
INSERT INTO syls_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","ꠎꠦ ꠎꠘꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠞꠣ ꠅꠁꠛ, ꠔꠣꠞ ꠀꠘꠣ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠞꠦ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠎꠛ ꠇꠞꠛꠣ। ꠛꠣꠖꠦ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠅ ꠎꠛ ꠇꠞꠤꠀ, ");
INSERT INTO syls_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠎꠤꠘꠤꠡꠞ ꠟꠉꠦ ꠝꠤꠟꠣꠁꠀ, ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠁꠔꠣ ꠖꠤꠛꠣ। ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠔꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠤꠀ ꠔꠣꠞ ꠘꠣꠙꠣꠇꠤ ꠢꠞꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“ꠅꠁꠟꠦ ꠅꠃ ꠎꠘ ꠎꠥꠖꠤ ꠉꠞꠤꠛ ꠅꠄ, ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠀꠘꠣꠞ ꠔꠚꠤꠇ ꠔꠣꠞ ꠘꠣ ꠕꠣꠇꠦ, ꠔꠦ ꠖꠥꠡ-ꠇꠍꠥꠞꠤꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠈꠣꠟꠤ ꠄꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠀꠘꠔꠦ ꠅꠁꠛ, ꠀꠘꠟꠦ ꠁꠝꠣꠝꠦ ꠔꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠅꠇꠐꠣꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠀ ꠖꠥꠟꠣꠁꠛꠣ। ꠀꠞ ꠄꠞ ꠟꠉꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠢꠤꠡꠣꠛꠦ ꠔꠣꠞ ꠀꠘꠣ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠖꠥꠁ ꠡꠦꠞ ꠝꠄꠖꠣ, ꠄꠇ ꠙꠣꠅꠀ ꠔꠦꠟ ");
INSERT INTO syls_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ꠀꠞ ꠔꠣꠞ ꠖꠥꠁꠐꠣ ꠒꠥꠙꠤ ꠙꠣꠈꠤ ꠛꠣ ꠙꠣꠞꠅ ꠀꠘꠔꠦ ꠅꠁꠛ, ꠎꠦꠟꠣ ꠔꠣꠞ ꠔꠣꠇ꠆ꠇꠔꠦ ꠇꠥꠟꠣꠄ। ꠖꠥꠁꠅ ꠙꠣꠈꠤꠞ ꠝꠣꠎꠞ ꠄꠇꠐꠣ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ, ꠀꠞ ꠄꠇꠐꠣ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","ꠛꠣꠖꠦ ꠀꠐ ꠖꠤꠘꠞ ꠖꠤꠘ ꠙꠣꠇ-ꠍꠣꠚ ꠅꠀꠞ ꠘꠤꠅꠔꠦ ꠢꠦ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠀꠘꠤꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠗꠣꠞꠅ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠁꠝꠣꠝꠞ ꠉꠦꠍꠦ ꠡꠝꠎꠣꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","ꠁꠝꠣꠝꠦ ꠖꠥꠡ-ꠇꠍꠥꠞꠤꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠝꠦꠠꠣ ꠀꠞ ꠅꠃ ꠔꠦꠟ ꠘꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠖꠥꠟꠘꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠖꠥꠟꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ꠛꠣꠖꠦ ꠁꠝꠣꠝꠦ ꠝꠦꠠꠣꠞꠦ ꠎꠛ ꠇꠞꠤꠀ ꠅꠉꠥꠞ ꠇꠤꠍꠥ ꠟꠃ ꠘꠤꠀ ꠢꠃ ꠎꠘꠞ ꠒꠣꠁꠘ ꠇꠣꠘꠞ ꠟꠔꠤꠔ, ꠒꠣꠁꠘ ꠀꠔꠞ ꠀꠞ ꠒꠣꠁꠘ ꠙꠣꠅꠞ ꠛꠥꠠꠤ ꠀꠋꠉꠥꠟꠤꠔ ꠟꠣꠉꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","ꠛꠣꠖꠦ ꠢꠃ ꠔꠦꠟ ꠕꠣꠇꠤ ꠇꠤꠍꠥ ꠔꠦꠟ ꠔꠣꠘ ꠛꠣꠃ ꠀꠔꠞ ꠔꠣꠟꠥꠞ ꠝꠣꠎꠦ ꠓꠣꠟꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ꠀꠞ ꠒꠣꠁꠘ ꠀꠔꠞ ꠀꠋꠉꠥꠁꠟ ꠖꠤꠀ ꠁꠝꠣꠝꠦ ꠛꠣꠃ ꠀꠔꠞ ꠇꠤꠍꠥ ꠔꠦꠟ ꠔꠥꠟꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠡꠣꠔ ꠛꠣꠞ ꠍꠤꠐꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","ꠄꠞꠟꠉꠦ ꠔꠣꠞ ꠒꠣꠁꠘ ꠇꠣꠘꠞ ꠟꠔꠤꠔ, ꠒꠣꠁꠘ ꠀꠔꠞ ꠀꠞ ꠒꠣꠁꠘ ꠙꠣꠅꠞ ꠛꠥꠠꠤ ꠀꠋꠉꠥꠟꠤꠞ ꠎꠦ ꠎꠣꠉꠣꠔ ꠖꠥꠡ-ꠇꠍꠥꠞꠤꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠃ ꠟꠣꠉꠣꠁꠟ ꠅꠁꠍꠦ, ꠢꠃ ꠎꠣꠉꠣꠞ ꠃꠙꠞꠦ ꠅꠃ ꠔꠦꠟꠅ ꠟꠣꠉꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠢꠃ ꠙꠣꠇ-ꠍꠣꠚ ꠅꠀ ꠎꠘꠞ ꠇꠚꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠁꠝꠣꠝꠞ ꠀꠔꠞ ꠛꠣꠇꠤ ꠔꠦꠟ ꠔꠣꠞ ꠝꠣꠕꠣꠔ ꠓꠣꠟꠤ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","ꠛꠣꠖꠦ ꠢꠃ ꠎꠘꠞ ꠔꠣꠇ꠆ꠇꠔ ꠝꠣꠚꠤꠇ ꠀꠘꠣ ꠒꠥꠙꠤ ꠛꠣ ꠙꠣꠞꠅ ꠎꠥꠠꠣ ꠘꠤꠀ, ");
INSERT INTO syls_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ꠁꠝꠣꠝꠦ ꠄꠉꠥꠞꠦ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ, ꠀꠞ ꠖꠥꠍꠞꠣꠐꠣꠞꠦ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣ। ꠟꠉꠦ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞꠦꠅ ꠖꠤꠛꠣ। ꠁꠝꠣꠝꠦ ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠔꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","ꠙꠌꠣ-ꠇꠥꠡ꠆ꠑ ꠛꠦꠝꠣꠞꠤ ꠙꠣꠇ-ꠍꠣꠚ ꠅꠀꠞ ꠟꠣꠉꠤ ꠎꠦꠟꠣꠈꠣꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠇꠕꠣ, ꠁꠔꠣ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠔꠣꠇ꠆ꠇꠔ ꠎꠦꠞꠣꠞ ꠘꠣꠁ, ꠔꠣꠞꠣꠞ ꠟꠣꠉꠤ ꠅꠃ ꠘꠤꠅꠝ ꠖꠦꠅꠀ ꠅꠁꠍꠦ।” ");
INSERT INTO syls_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“ꠀꠝꠤ ꠎꠦ ꠖꠦꠡꠈꠣꠘꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠟꠤꠇꠣꠘꠣꠄ ꠖꠤꠝꠥ, ꠅꠃ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠢꠣꠝꠣꠘꠤꠞ ꠛꠣꠖꠦ, ꠀꠝꠤ ꠎꠥꠖꠤ ꠢꠘꠞ ꠇꠥꠘꠥ ꠊꠞꠞ ꠝꠣꠎꠦ ꠘꠣꠙꠣꠇ-ꠚꠦꠃꠇꠘꠤ ꠛꠦꠝꠣꠞ ꠙꠣꠑꠣꠁ, ");
INSERT INTO syls_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ꠔꠦ ꠊꠞꠞ ꠝꠣꠟꠤꠇꠦ ꠉꠤꠀ ꠁꠝꠣꠝ ꠍꠣꠛꠞꠦ ꠇꠁꠛꠣ, ꠀꠝꠣꠞ ꠊꠞꠅ ꠘꠣꠙꠣꠇ-ꠚꠦꠃꠇꠘꠤꠞ ꠟꠣꠈꠣꠘ ꠇꠤꠔꠣ ꠎꠣꠘꠥ ꠖꠦꠈꠤꠀꠞ। ");
INSERT INTO syls_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","ꠔꠦꠃ ꠁꠝꠣꠝꠦ ꠁ ꠚꠦꠃꠇꠘꠤ ꠙꠞꠤꠇ꠆ꠇꠣ ꠇꠞꠤꠀ ꠖꠦꠈꠣꠔ ꠀꠁꠀ, ꠊꠞꠞ ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣꠞꠦ ꠎꠣꠔꠦ ꠘꠣꠙꠣꠇ ꠇꠁꠀ ꠄꠟꠣꠘ ꠇꠞꠣ ꠘꠣ ꠟꠣꠉꠦ, ꠅꠃ ꠘꠤꠅꠔꠦ ꠔꠣꠁꠘ ꠝꠣꠟꠤꠇꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠛꠣ, ꠀꠝꠤ ꠊꠞꠅ ꠢꠣꠝꠣꠘꠤꠞ ꠀꠉꠦ ꠔꠥꠝꠣꠞ ꠊꠞꠞ ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠛꠣꠞꠦ ꠛꠣꠞ ꠇꠞꠤꠟꠣꠅ। ꠢꠇꠟꠔꠣ ꠛꠣꠞ ꠇꠞꠤꠀ ꠢꠣꠞꠟꠦ ꠔꠣꠁꠘ ꠊꠞꠅ ꠢꠣꠝꠣꠁꠀ ꠙꠞꠤꠇ꠆ꠇꠣ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","ꠔꠣꠁꠘ ꠎꠥꠖꠤ ꠖꠦꠈꠂꠘ, ꠊꠞꠞ ꠅꠀꠟꠞ ꠇꠥꠘꠥ ꠚꠦꠃꠇꠘꠤꠞ ꠖꠣꠉ ꠉꠤꠀ ꠜꠤꠔꠞꠦꠖꠤ ꠢꠣꠝꠣꠁꠍꠦ, ꠀꠞ ꠅꠃ ꠖꠣꠉꠞ ꠞꠋ ꠇꠌꠥꠀ ꠛꠣ ꠟꠣꠟꠐꠤ, ");
INSERT INTO syls_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ꠔꠦ ꠔꠣꠁꠘ ꠁ ꠊꠞ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁ ꠀꠁꠀ, ꠊꠞꠞ ꠖꠥꠀꠞ ꠡꠣꠔ ꠖꠤꠘ ꠛꠘ꠆ꠖ ꠇꠞꠤ ꠕꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","ꠅꠃ ꠡꠣꠔ ꠖꠤꠘ ꠛꠣꠖꠦ ꠢꠤꠞꠛꠣꠞ ꠙꠞꠤꠇ꠆ꠇꠣ ꠇꠞꠤ ꠖꠦꠈꠛꠣ, ꠎꠥꠖꠤ ꠖꠦꠈꠣ ꠎꠣꠄ, ꠁ ꠖꠣꠉ ꠅꠀꠟꠞ ꠝꠣꠎꠦ ꠀꠞꠅ ꠍꠤꠔ꠆ꠞꠤꠍꠦ, ");
INSERT INTO syls_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ꠔꠦ ꠔꠣꠁꠘ ꠢꠥꠇꠥꠝ ꠖꠤꠛꠣ, ꠅꠃ ꠅꠀꠟꠞ ꠖꠣꠉ ꠀꠟꠣ ꠙꠣꠔ꠆ꠔꠞ ꠛꠣ ꠁꠐ ꠈꠥꠟꠤꠀ ꠢꠣꠞꠤ, ꠉꠣꠃ ꠛꠣ ꠐꠣꠃꠘꠞ ꠛꠣꠞꠦ ꠘꠤꠀ ꠘꠣꠙꠣꠇ ꠇꠥꠘꠥ ꠎꠣꠉꠣꠔ ꠚꠣꠟꠣꠁ ꠖꠤꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","ꠛꠣꠖꠦ ꠀꠡ꠆ꠔꠣ ꠊꠞꠞ ꠜꠤꠔꠞꠞ ꠢꠇꠟ ꠅꠀꠟ ꠌꠣꠍꠤꠀ ꠀꠡ꠆ꠔꠞ ꠔꠥꠟꠤꠀ ꠢꠣꠞꠤ, ꠅꠔꠣ ꠘꠤꠀ ꠐꠣꠃꠘꠞ ꠛꠣꠞꠦ ꠘꠣꠙꠣꠇ ꠇꠥꠘꠥ ꠎꠣꠉꠣꠔ ꠚꠣꠟꠣꠁꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","ꠀꠞ ꠅꠀꠟꠞ ꠎꠦ ꠎꠣꠉꠣ ꠕꠣꠇꠤ ꠙꠣꠔ꠆ꠔꠞ ꠛꠣ ꠁꠐ ꠈꠥꠟꠣ ꠅꠁꠍꠦ, ꠢꠘꠅ ꠘꠄꠀ ꠙꠣꠔ꠆ꠔꠞ ꠟꠣꠉꠣꠁꠛꠣ, ꠟꠣꠉꠣꠁꠀ ꠀꠡ꠆ꠔꠣ ꠊꠞ ꠢꠤꠞꠛꠣꠞ ꠘꠄꠀ ꠀꠡ꠆ꠔꠞ ꠇꠞꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“ꠅꠀꠟꠞ ꠙꠣꠔ꠆ꠔꠞ ꠈꠥꠟꠤꠀ ꠚꠣꠟꠣꠁꠀ ꠌꠣꠍꠤꠀ ꠀꠡ꠆ꠔꠞ ꠔꠥꠟꠣꠞ ꠛꠣꠖꠦ, ꠘꠄꠀ ꠀꠡ꠆ꠔꠞ ꠟꠣꠉꠣꠁꠀ ꠢꠣꠞꠟꠦꠅ ꠎꠥꠖꠤ ꠅꠀꠟꠅ ꠢꠤꠞꠛꠣꠞ ꠅꠟꠣ ꠖꠣꠉ ꠖꠦꠈꠣ ꠎꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ꠔꠦ ꠁꠝꠣꠝꠦ ꠢꠤꠞꠛꠣꠞ ꠉꠤꠀ ꠁꠔꠣ ꠙꠞꠤꠇ꠆ꠇꠣ ꠇꠞꠤ ꠖꠦꠈꠛꠣ। ꠔꠣꠁꠘ ꠎꠥꠖꠤ ꠖꠦꠈꠂꠘ, ꠅꠀꠟꠞ ꠝꠣꠎꠞ ꠖꠣꠉ ꠍꠤꠔ꠆ꠞꠤꠀ ꠀꠞꠅ ꠛꠣꠠꠍꠦ, ꠔꠦ ꠛꠥꠎꠛꠣ, ꠅꠃ ꠊꠞꠅ ꠘꠣꠙꠣꠇ-ꠚꠦꠃꠇꠘꠤ ꠛꠦꠝꠣꠞ ꠀꠍꠦ, ꠄꠞꠟꠣꠉꠤ ꠁ ꠊꠞ ꠈꠣꠘ ꠘꠣꠙꠣꠇ। ");
INSERT INTO syls_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","ꠘꠣꠙꠣꠇ ꠅꠃ ꠊꠞꠞ ꠢꠇꠟ ꠙꠣꠔ꠆ꠔꠞ ꠛꠣ ꠁꠐ, ꠢꠇꠟ ꠀꠡ꠆ꠔꠞ, ꠊꠞꠞ ꠟꠣꠇꠠꠤ, ꠢꠇ꠆ꠇꠟꠔꠣ ꠜꠣꠋꠉꠤꠀ ꠐꠣꠃꠘꠞ ꠛꠣꠞꠦ ꠇꠥꠘꠥ ꠘꠣꠙꠣꠇ ꠎꠣꠉꠣꠔ ꠘꠤꠀ ꠚꠣꠟꠣꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“ꠀꠞ ꠢꠃ ꠡꠣꠔ ꠖꠤꠘ ꠛꠘ꠆ꠖ ꠞꠣꠈꠣꠞ ꠇꠣꠟꠅ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠝꠣꠘꠥꠡ ꠉꠤꠀ ꠁ ꠊꠞꠅ ꠢꠣꠝꠣꠄ, ꠔꠦ ꠢꠦ ꠅꠃ ꠖꠤꠘ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","ꠀꠞ ꠇꠦꠃ ꠎꠥꠖꠤ ꠅꠃ ꠊꠞꠅ ꠈꠣꠘꠣ-ꠙꠤꠘꠣ ꠈꠣꠄ ꠛꠣ ꠊꠥꠝꠣꠄ, ꠔꠦ ꠔꠣꠞ ꠚꠤꠘ꠆ꠘꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠖꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“ꠅꠁꠟꠦ ꠁ ꠊꠞ ꠀꠡ꠆ꠔꠞ ꠇꠞꠣꠞ ꠛꠣꠖꠦ ꠁꠝꠣꠝꠦ ꠙꠞꠤꠇ꠆ꠇꠣ ꠇꠞꠤꠀ ꠎꠥꠖꠤ ꠖꠦꠈꠂꠘ, ꠅꠀꠟꠞ ꠖꠣꠉ ꠀꠞ ꠖꠦꠈꠣ ꠎꠣꠞ ꠘꠣ, ꠔꠦ ꠁꠝꠣꠝꠦ ꠁ ꠊꠞꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠁꠀ ꠄꠟꠣꠘ ꠇꠞꠛꠣ। ꠁ ꠊꠞꠅ ꠔ ꠘꠣꠙꠣꠇ-ꠚꠦꠃꠇꠘꠤ ꠛꠦꠝꠣꠞꠞ ꠇꠥꠘꠥ ꠀꠟꠣꠝꠔ ꠅꠈꠘ ꠘꠣꠁ। ");
INSERT INTO syls_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","ꠀꠞ ꠊꠞꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠖꠥꠁꠐꠣ ꠙꠣꠈꠤ, ꠖꠦꠛꠖꠣꠞꠥ ꠉꠣꠍꠞ ꠇꠤꠍꠥ ꠟꠣꠇꠠꠤ, ꠄꠍꠥꠛ ꠉꠣꠍꠞ ꠒꠦꠐꠣ, ꠀꠞ ꠟꠣꠟ ꠞꠋꠉꠞ ꠡꠥꠔꠣ ꠟꠁꠀ ꠅꠘꠅ ꠀꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","ꠀꠁꠀ ꠚꠥꠔꠞ ꠙꠣꠘꠤ ꠕꠣꠇꠤ ꠀꠘꠣ ꠝꠣꠐꠤꠞ ꠉꠣꠝꠟꠣꠔ ꠕꠅꠀ ꠅꠃ ꠙꠣꠘꠤꠞ ꠃꠙꠞꠦ ꠄꠇꠐꠣ ꠙꠣꠈꠤꠞꠦ ꠎꠛ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","ꠀꠞ ꠖꠥꠍꠞꠣ ꠎꠤꠔꠣ ꠙꠣꠈꠤꠞꠦ, ꠖꠦꠛꠖꠣꠞꠥ ꠉꠣꠍꠞ ꠟꠣꠇꠠꠤꠞꠦ, ꠟꠣꠟ ꠡꠥꠔꠣ ꠀꠞ ꠄꠍꠥꠛ ꠉꠣꠍꠞ ꠒꠦꠐꠣꠞꠦ, ꠚꠥꠔꠞ ꠙꠣꠘꠤꠞ ꠉꠣꠝꠟꠣꠞ ꠃꠙꠞꠦ ꠎꠛ ꠇꠞꠣ ꠢꠃ ꠙꠣꠈꠤꠞ ꠟꠃꠞ ꠝꠣꠎꠦ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠍꠥꠛꠣꠁꠛꠣ, ꠍꠥꠛꠣꠁꠀ ꠢꠣꠞꠤ ꠅꠃ ꠊꠞꠞ ꠝꠣꠎꠦ ꠡꠣꠔ ꠛꠣꠞ ꠍꠤꠐꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","ꠙꠣꠈꠤꠞ ꠟꠃ, ꠚꠥꠔꠞ ꠙꠣꠘꠤ, ꠎꠤꠔꠣ ꠙꠣꠈꠤ, ꠖꠦꠛꠖꠣꠞꠥ ꠉꠣꠍꠞ ꠟꠣꠇꠠꠤ, ꠄꠍꠥꠛ ꠉꠣꠍꠞ ꠒꠦꠐꠣ ꠀꠞ ꠟꠣꠟ ꠡꠥꠔꠣ ꠖꠤꠀ ꠅꠃ ꠊꠞꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠞꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ꠄꠞꠛꠣꠖꠦ ꠅꠃ ꠎꠤꠔꠣ ꠙꠣꠈꠤꠞꠦ ꠘꠤꠀ ꠉꠣꠃ ꠛꠣ ꠐꠣꠃꠘꠞ ꠛꠣꠞꠦ ꠈꠥꠟꠣ ꠎꠣꠉꠣꠔ ꠍꠣꠠꠤ ꠖꠤꠛꠣ। ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠢꠃ ꠊꠞꠞ ꠘꠣꠙꠣꠇꠤ ꠢꠞꠣꠁꠀ ꠢꠣꠞꠟꠦ, ꠁꠈꠣꠘ ꠙꠣꠇ-ꠍꠣꠚ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","ꠔꠦ ꠢꠇꠟ ꠟꠣꠈꠣꠘ ꠙꠌꠣ-ꠇꠥꠡ꠆ꠑ ꠛꠦꠝꠣꠞ, ꠖꠣꠃꠖ-ꠈꠣꠃꠎꠟꠤ, ");
INSERT INTO syls_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ꠇꠣꠙꠠ ꠛꠣ ꠊꠞꠞ ꠅꠀꠟꠞ ꠚꠦꠃꠇꠘꠤꠞ ꠖꠣꠉ, ");
INSERT INTO syls_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ꠉꠔꠞꠞ ꠌꠣꠝꠠꠣꠔ ꠇꠥꠟꠡ ꠃꠑꠣ, ꠛꠞꠘ ꠛꠣ ꠇꠥꠘꠥ ꠎꠣꠔꠞ ꠖꠣꠉꠞ ꠛꠦꠙꠣꠞꠦ ꠅꠃ ꠟꠣꠈꠣꠘ ꠢꠥꠇꠥꠝ ꠎꠣꠘꠣꠁꠟ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ꠁꠔꠣ ꠛꠦꠝꠣꠞꠦ ꠇꠥꠘ ꠡꠝꠄ ꠙꠣꠇ, ꠀꠞ ꠇꠥꠘ ꠡꠝꠄ ꠘꠣꠙꠣꠇ, ꠅꠈꠣꠘ ꠎꠣꠘꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠅꠃ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠖꠦꠅꠀ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“ꠔꠥꠝꠞꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠅ, ꠇꠥꠘꠥ ꠛꠦꠐꠣ ꠝꠣꠘꠡꠞ ꠙꠦꠡꠣꠛꠞ ꠞꠣꠡ꠆ꠔꠣꠄ ꠎꠥꠖꠤ ꠢꠣꠝꠦꠡꠣ ꠗꠣꠔꠥ ꠛꠣꠞ ꠅꠄ, ꠔꠦ ꠔꠣꠞ ꠡꠞꠤꠟ ꠘꠣꠙꠣꠇ। ");
INSERT INTO syls_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","ꠔꠣꠞ ꠡꠞꠤꠟ ꠕꠣꠇꠤ ꠗꠣꠔꠥ ꠛꠣꠞꠘꠤꠔ ꠞꠁꠟꠦ ꠛꠣ ꠡꠞꠤꠟꠅ ꠀꠐꠇꠤ ꠞꠁꠟꠦꠅ ꠢꠦ ꠘꠣꠙꠣꠇ। ");
INSERT INTO syls_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","ꠅꠟꠣ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠢꠦ ꠎꠦ ꠛꠤꠍꠘꠣꠔ ꠢꠥꠔꠤꠛ, ꠛꠣ ꠎꠦ ꠎꠣꠉꠣꠔ ꠛꠁꠛ, ꠢꠃ ꠛꠤꠍꠘꠣ ꠀꠞ ꠢꠃ ꠎꠣꠉꠣꠅ ꠘꠣꠙꠣꠇ ꠅꠁꠎꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","ꠅꠃ ꠗꠣꠔꠥ ꠎꠣꠅꠞꠣ ꠘꠣꠙꠣꠇ ꠛꠦꠐꠣꠞ ꠛꠤꠍꠘꠣ ꠎꠦ ꠎꠘꠦ ꠍꠁꠛ, ꠢꠦ ꠘꠤꠎꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠖꠤꠀ ꠙꠣꠘꠤꠖꠤ ꠘꠣꠁꠛ, ꠔꠣ-ꠅ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠦ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","ꠅꠟꠣꠈꠣꠘ ꠢꠃ ꠛꠦꠐꠣꠞ ꠛꠅꠀꠞ ꠎꠣꠉꠣꠔ ꠎꠦ ꠎꠘ ꠛꠁꠛ, ꠢꠦ-ꠅ ꠔꠣꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠖꠤꠀ ꠙꠣꠘꠤꠖꠤ ꠘꠣꠁꠛ, ꠔꠣ-ꠅ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠦ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","ꠀꠞ ꠁ ꠗꠣꠔꠥ ꠎꠣꠅꠞꠣ ꠛꠦꠐꠣꠞꠦ ꠎꠦ ꠎꠘꠦ ꠍꠁꠛ ꠢꠦ-ꠅ ꠔꠣꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠖꠤꠀ ꠙꠣꠘꠤꠖꠤ ꠘꠣꠁꠛ, ꠔꠣ-ꠅ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠦ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","ꠢꠃ ꠗꠣꠔꠥ ꠎꠣꠅꠞꠣ ꠛꠦꠐꠣꠄ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠙꠣꠇ-ꠍꠣꠚ ꠝꠣꠘꠡꠞ ꠉꠔꠞꠅ ꠍꠦꠚ ꠚꠣꠟꠣꠄ, ꠔꠦ ꠅꠃ ꠎꠘꠦꠅ ꠔꠣꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠖꠤꠀ ꠙꠣꠘꠤꠖꠤ ꠘꠣꠁꠛ, ꠔꠣ-ꠅ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠦ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","ꠅꠃ ꠗꠣꠔꠥ ꠎꠣꠅꠞꠣ ꠛꠦꠐꠣꠄ ꠇꠥꠘꠥ ꠎꠣꠉꠣꠔ ꠎꠣꠁꠛꠣꠞ ꠇꠣꠟꠅ ꠉꠣꠠꠤ-ꠊꠥꠠꠣ ꠇꠥꠘꠥꠔꠣꠞ ꠍꠤꠐꠅ ꠛꠁꠀ ꠉꠦꠟꠦ, ꠁ ꠍꠤꠐ ꠘꠣꠙꠣꠇ ꠅꠁꠎꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","ꠅꠃ ꠍꠤꠐ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠍꠁꠟꠦ ꠢꠦ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠞꠁꠛ। ꠅꠃ ꠍꠤꠐ ꠎꠦ ꠎꠘꠦ ꠔꠥꠟꠛ, ꠢꠦ ꠔꠣꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠖꠤꠀ ꠙꠣꠘꠤꠖꠤ ꠘꠣꠁꠛ, ꠔꠣ-ꠅ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠦ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","ꠅꠃ ꠗꠣꠔꠥ ꠎꠣꠅꠞꠣ ꠛꠦꠐꠣꠄ ꠙꠣꠘꠤꠖꠤ ꠀꠔ ꠘꠣ ꠗꠁꠀ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠞꠦ ꠍꠁꠟꠣꠄ, ꠔꠦ ꠎꠣꠞꠦ ꠍꠁꠛ, ꠢꠦ ꠔꠣꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠖꠤꠀ ꠙꠣꠘꠤꠖꠤ ꠘꠣꠁꠛ, ꠔꠣ-ꠅ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠦ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","ꠀꠞ ꠗꠣꠔꠥ ꠎꠣꠅꠞꠣ ꠛꠦꠐꠣꠄ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠝꠣꠐꠤꠞ ꠛꠣꠡꠘ ꠍꠁꠟꠣꠄ, ꠔꠦ ꠁꠔꠣ ꠜꠣꠋꠉꠤꠟꠤꠔꠦ ꠅꠁꠛ, ꠀꠞ ꠟꠣꠇꠠꠤꠖꠤ ꠛꠣꠘꠣꠁꠟ ꠇꠥꠘꠥ ꠎꠤꠘꠤꠡ ꠍꠁꠟꠦ, ꠁꠔꠣ ꠙꠣꠘꠤꠖꠤ ꠗꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ꠢꠃ ꠗꠣꠔꠥ ꠎꠣꠅꠞꠣ ꠛꠦꠝꠣꠞꠤ ꠛꠦꠐꠣꠞ ꠛꠦꠝꠣꠞ ꠎꠦ ꠖꠤꠘ ꠇꠝꠤꠎꠤꠛ, ꠅꠃ ꠖꠤꠘ ꠕꠣꠇꠤ ꠉꠘꠤꠀ ꠡꠣꠔ ꠖꠤꠘꠞ ꠖꠤꠘ ꠢꠦ ꠔꠣꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠖꠤꠀ ꠚꠥꠔꠞ ꠙꠣꠘꠤꠔ ꠘꠣꠁꠀ ꠢꠣꠞꠤ ꠙꠣꠇ-ꠍꠣꠚ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","ꠛꠣꠖꠦ ꠀꠐ ꠖꠤꠘꠞ ꠖꠤꠘ ꠢꠦ ꠖꠥꠁꠐꠣ ꠒꠥꠙꠤ ꠙꠣꠈꠤ ꠛꠣ ꠖꠥꠉꠥ ꠙꠣꠞꠅ ꠟꠁꠀ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠉꠦꠍꠦ ꠀꠎꠤꠞ ꠅꠁꠀ, ꠁꠝꠣꠝ ꠍꠣꠛꠞ ꠀꠔꠅ ꠖꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","ꠁꠝꠣꠝꠦ ꠢꠃ ꠖꠥꠁꠐꠣꠞ ꠄꠉꠥꠞꠦ ꠖꠤꠀ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ, ꠀꠞ ꠖꠥꠍꠞꠣꠐꠣ ꠖꠤꠀ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠛꠣ। ꠗꠣꠔꠥ ꠎꠣꠅꠞꠣ ꠛꠦꠐꠣꠞ ꠘꠣꠙꠣꠇꠤ ꠢꠞꠣꠘꠤꠞ ꠘꠤꠅꠔꠦ, ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠔꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ꠇꠥꠘꠥ ꠛꠦꠐꠣ ꠝꠣꠘꠡꠞ ꠎꠃꠛꠘꠞ ꠙꠣꠘꠤ ꠛꠣꠞ ꠅꠁꠉꠦꠟꠦ ꠢꠦ ꠔꠣꠞ ꠀꠡ꠆ꠔꠣ ꠡꠞꠤꠟꠞꠦ ꠙꠣꠘꠤꠖꠤ ꠗꠁꠔꠦ ꠅꠁꠛ, ꠀꠞ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠦ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","ꠅꠃ ꠎꠃꠛꠘꠞ ꠙꠣꠘꠤ ꠇꠥꠘꠥ ꠇꠣꠙꠠ ꠛꠣ ꠌꠣꠝꠠꠣꠞ ꠎꠤꠘꠤꠡꠅ ꠟꠣꠉꠤꠉꠦꠟꠦ, ꠁꠔꠣ ꠙꠣꠘꠤꠖꠤ ꠗꠁꠔꠦ ꠅꠁꠛ, ꠀꠞ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠁꠔꠣ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","ꠇꠥꠘꠥ ꠛꠦꠐꠣꠄ ꠔꠣꠞ ꠛꠃꠞ ꠟꠉꠦ ꠝꠤꠟꠣ-ꠝꠤꠡꠣꠞ ꠇꠣꠟꠅ ꠎꠃꠛꠘꠞ ꠙꠣꠘꠤ ꠛꠣꠞ ꠅꠁꠟꠦ, ꠔꠣꠞꠣ ꠖꠥꠁꠅꠎꠘꠦ ꠙꠣꠘꠤꠖꠤ ꠘꠣꠁꠔꠦ ꠅꠁꠛ, ꠖꠥꠁꠅꠎꠘ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ꠇꠥꠘꠥ ꠛꠦꠐꠤꠞ ꠝꠣꠡꠤꠇ ꠛꠦꠝꠣꠞꠞ ꠟꠃ ꠎꠣꠅꠀꠞ ꠡꠝꠄ ꠔꠣꠁ ꠡꠣꠔ ꠖꠤꠘ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠞꠁꠛ। ꠅꠃ ꠡꠝꠄ ꠁ ꠛꠦꠐꠤꠞꠦ ꠎꠦ ꠎꠘꠦ ꠍꠁꠛ, ꠢꠦ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","ꠅꠃ ꠛꠦꠐꠤꠀꠞꠣ ꠛꠦꠝꠣꠞꠞ ꠡꠝꠄ ꠔꠣꠁ ꠎꠦꠔꠣꠞ ꠃꠙꠞꠦ ꠛꠁꠛ ꠛꠣ ꠢꠥꠔꠤꠛ, ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠘꠣꠙꠣꠇ ꠅꠁꠎꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","ꠔꠣꠁꠞ ꠛꠤꠍꠘꠣ ꠎꠦ ꠎꠘꠦ ꠍꠁꠛ, ꠢꠦ-ꠅ ꠔꠣꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠖꠤꠀ ꠙꠣꠘꠤꠖꠤ ꠘꠣꠁꠛ, ꠔꠣ-ꠅ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠦ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","ꠅꠃ ꠛꠦꠝꠣꠞꠤ ꠛꠦꠐꠤ ꠎꠦꠔꠣꠞ ꠃꠙꠞꠦ ꠛꠁꠍꠦ, ꠁꠔꠣ ꠎꠥꠖꠤ ꠇꠦꠃ ꠍꠁꠟꠣꠄ, ꠔꠦ ꠢꠦ-ꠅ ꠔꠣꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠖꠤꠀ ꠙꠣꠘꠤꠖꠤ ꠘꠣꠁꠛ, ꠔꠣ-ꠅ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠦ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","ꠔꠣꠁꠞ ꠛꠤꠍꠘꠣ ꠛꠣ ꠌꠦꠀꠞꠅ ꠇꠦꠃ ꠍꠁꠟꠦ, ꠛꠣ ꠁꠔꠣꠞ ꠃꠙꠞꠦ ꠕꠅꠀ ꠇꠥꠘ꠆ꠔꠣ ꠍꠁꠟꠦꠅ, ꠢꠦ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","ꠛꠦꠐꠤꠀꠞꠣ ꠛꠦꠝꠣꠞꠤ ꠛꠦꠐꠤꠞ ꠟꠉꠦ ꠇꠥꠘꠥ ꠛꠦꠐꠣ ꠝꠣꠘꠥꠡ ꠎꠥꠖꠤ ꠢꠥꠔꠦ, ꠀꠞ ꠔꠣꠁꠞ ꠝꠣꠡꠤꠇꠞ ꠟꠃ ꠔꠣꠞ ꠡꠞꠤꠟꠅ ꠟꠣꠉꠦ, ꠔꠦ ꠅꠃ ꠛꠦꠐꠣꠅ ꠡꠣꠔ ꠖꠤꠘ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠞꠁꠛ। ꠅꠃ ꠡꠣꠔ ꠖꠤꠘꠞ ꠝꠣꠎꠦ ꠢꠦ ꠎꠦ ꠛꠤꠍꠘꠣꠔ ꠢꠥꠔꠤꠛ, ꠁꠔꠣꠅ ꠘꠣꠙꠣꠇ ꠅꠁꠎꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ꠇꠥꠘꠥ ꠛꠦꠐꠤ ꠝꠣꠘꠡꠞ ꠎꠥꠖꠤ ꠛꠃꠔ ꠖꠤꠘ ꠗꠞꠤ ꠟꠃ ꠎꠣꠅꠀꠔ ꠞꠄ, ꠝꠣꠡꠤꠇ ꠛꠦꠝꠣꠞꠞ ꠡꠣꠔ ꠖꠤꠘ ꠙꠣꠞꠘꠤꠞ ꠛꠣꠖꠦꠅ ꠎꠥꠖꠤ ꠟꠃ ꠎꠣꠅꠀꠔ ꠞꠄ, ꠔꠦ ꠎꠔꠖꠤꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠁꠟꠣ ꠟꠃ ꠎꠣꠁꠛ, ꠅꠔꠖꠤꠘ ꠔꠣꠁ ꠘꠣꠙꠣꠇ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","ꠛꠦꠐꠤꠀꠞꠣ ꠝꠣꠡꠤꠇ ꠛꠦꠝꠣꠞꠞ ꠟꠣꠈꠣꠘ ꠅꠃ ꠟꠃ ꠎꠣꠁꠛꠣꠞ ꠡꠝꠄ ꠔꠣꠁ ꠎꠦꠔꠣꠔ ꠢꠥꠔꠤꠛ ꠛꠣ ꠛꠁꠛ, ꠁꠔꠣ ꠘꠣꠙꠣꠇ ꠅꠁꠎꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","ꠁ ꠛꠤꠍꠘꠣ ꠛꠣ ꠌꠦꠀꠞ ꠎꠦ ꠎꠘꠦ ꠍꠁꠛ, ꠢꠦ-ꠅ ꠘꠣꠙꠣꠇ ꠅꠁꠎꠤꠛ। ꠢꠦ ꠔꠣꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠖꠤꠀ ꠙꠣꠘꠤꠖꠤ ꠘꠣꠁꠛ, ꠔꠣ-ꠅ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠦ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","ꠅꠃ ꠛꠦꠐꠤꠞ ꠟꠃ ꠎꠣꠅꠀ ꠛꠘ꠆ꠖ ꠅꠀꠞ ꠛꠣꠖꠦꠅ, ꠔꠣꠁ ꠉꠘꠤꠀ ꠀꠞꠅ ꠡꠣꠔ ꠖꠤꠘ ꠛꠣꠞ ꠌꠣꠁꠔꠦ ꠅꠁꠛ, ꠄꠞꠛꠣꠖꠦ ꠔꠣꠁ ꠙꠣꠇ-ꠍꠣꠚ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","ꠀꠞ ꠀꠐ ꠖꠤꠘꠞ ꠖꠤꠘ ꠔꠣꠁ ꠖꠥꠁꠐꠣ ꠒꠥꠙꠤ ꠙꠣꠈꠤ ꠛꠣ ꠙꠣꠞꠅ ꠟꠁꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠉꠦꠍꠦ ꠁꠝꠣꠝ ꠍꠣꠛꠞ ꠗꠣꠞꠅ ꠎꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","ꠁꠝꠣꠝꠦ ꠢꠃ ꠖꠥꠁꠅ ꠙꠣꠈꠤꠞ ꠝꠣꠎꠞ ꠄꠉꠥꠖꠤ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ, ꠀꠞ ꠖꠥꠍꠞꠣꠐꠣ ꠖꠤꠀ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠛꠣ। ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠁꠝꠣꠝꠦ ꠔꠣꠁꠞ ꠟꠃ ꠎꠣꠁꠛꠣꠞ ꠘꠣꠙꠣꠇꠤ ꠢꠞꠣꠘꠤꠞ ꠇꠚꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠀꠖꠣꠄ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ꠅ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘ, ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠔꠥꠝꠞꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠡꠝꠣꠎꠞꠦ ꠢꠇꠟ ꠘꠝꠥꠘꠣꠞ ꠘꠣꠙꠣꠇꠤ ꠕꠣꠇꠤ ꠛꠣꠌꠣꠁꠅ, ꠀꠞꠘꠣꠄ ꠔꠣꠞꠣꠞ ꠝꠣꠎꠦ ꠞꠅꠀ ꠀꠝꠣꠞ ꠙꠛꠤꠔ꠆ꠞ ꠛꠡꠔ ꠈꠣꠘꠣꠞꠦ ꠎꠥꠖꠤ ꠔꠣꠞꠣ ꠘꠣꠙꠣꠇ ꠛꠣꠘꠣꠁꠘ, ꠔꠦ ꠅꠃ ꠘꠣꠙꠣꠇꠤꠞ ꠖꠣꠄ ꠔ ꠔꠣꠞꠣꠞ ꠝꠞꠘ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","33","ꠔꠦ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠞ ꠗꠣꠔꠥ ꠎꠣꠅꠀ ꠛꠦꠝꠣꠞ, ꠎꠃꠛꠘꠞ ꠙꠣꠘꠤ ꠛꠣꠞꠘꠤ, ꠛꠦꠐꠤꠘ꠆ꠔꠞ ꠝꠣꠡꠤꠇ ꠛꠦꠝꠣꠞ, ꠛꠦꠐꠣ ꠛꠣ ꠛꠦꠐꠤꠘ꠆ꠔꠞ ꠎꠦꠇꠥꠘꠥ ꠟꠣꠈꠣꠘ ꠗꠣꠔꠥ ꠎꠣꠅꠀ, ꠘꠣꠙꠣꠇ ꠛꠃꠞ ꠟꠉꠦ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠣ, ꠁꠔꠣ ꠎꠦꠇꠥꠘꠥ ꠎꠘꠞ ꠟꠣꠉꠤ ꠅꠃ ꠘꠤꠅꠝ ꠎꠣꠞꠤ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠛꠠ ꠖꠥꠁ ꠙꠥꠀꠄ ꠘꠣꠚꠞꠝꠣꠘꠤ ꠇꠞꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠙꠠꠤꠀ ꠝꠣꠞꠣ ꠉꠦꠟ ꠇꠞꠤ, ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞ ꠟꠉꠦ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","ꠝꠣꠛꠥꠖꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠜꠣꠁ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠅ, ꠢꠦ ꠎꠣꠘꠥ ꠎꠦꠛꠟꠣ ꠝꠘꠦ ꠌꠣꠄ ꠄꠛꠟꠣ ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇꠞ ꠓꠣꠇꠘꠣꠞ ꠉꠦꠍꠦ ꠎꠣꠅꠀꠞ ꠟꠣꠉꠤ ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚꠞ ꠙꠞ꠆ꠖꠣꠞ ꠜꠤꠔꠞꠦ ꠘꠣ ꠢꠣꠝꠣꠄ, ꠀꠞꠘꠣꠄ ꠢꠦ ꠝꠞꠛꠃ। ꠎꠣꠘ ꠔ, ꠅꠃ ꠓꠣꠇꠘꠣꠞ ꠃꠙꠞꠞ ꠗꠥꠝꠣꠞ ꠀꠘ꠆ꠖꠣꠁꠞꠞ ꠝꠣꠎꠦ ꠀꠝꠤ ꠘꠤꠎꠦ ꠀꠎꠤꠞ ꠅꠁ। ");
INSERT INTO syls_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“ꠁꠘꠅ ꠢꠣꠝꠣꠘꠤꠞ ꠀꠉꠦ ꠢꠦ ꠎꠣꠘꠥ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠛꠤꠍꠣꠟ ꠀꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠝꠦꠠꠣꠞ ꠙꠣꠑꠣ ꠟꠁꠀ ꠁꠘꠅ ꠀꠁꠀ ꠢꠣꠝꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","ꠡꠣꠖꠣ ꠡꠥꠔꠤ ꠇꠣꠙꠠꠖꠤ ꠛꠣꠘꠣꠁꠟ ꠙꠛꠤꠔ꠆ꠞ ꠀꠟꠈꠦꠟ꠆ꠟꠣ ꠀꠞ ꠢꠣꠚ-ꠙꠦꠘ꠆ꠐꠞ ꠟꠣꠈꠣꠘ ꠎꠣꠋꠉꠤꠀ ꠚꠤꠘ꠆ꠖꠤꠀ ꠜꠤꠔꠞꠦ ꠢꠣꠝꠣꠁꠛ। ꠔꠣꠞ ꠇꠝꠞꠅ ꠛꠣꠘ꠆ꠖꠣꠞ ꠡꠥꠔꠤ ꠇꠣꠙꠠꠞ ꠛꠘ꠆ꠖꠘꠤ ꠛꠣꠘ꠆ꠖꠤꠛ ꠀꠞ ꠝꠣꠕꠣꠔ ꠡꠥꠔꠤ ꠇꠣꠙꠠꠞ ꠙꠣꠃꠉꠠꠤ ꠟꠣꠉꠣꠁꠛ। ꠁꠔꠣ ꠔ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠟꠦꠛꠣꠍ, ꠁꠔꠣ ꠟꠦꠛꠣꠍ ꠚꠤꠘ꠆ꠖꠤꠛꠣꠞ ꠀꠉꠦ ꠙꠣꠘꠤꠖꠤ ꠘꠣꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠢꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠖꠥꠁꠐꠣ ꠙꠣꠑꠣ ꠍꠣꠉꠟ ꠀꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠝꠦꠠꠣꠞ ꠙꠣꠑꠣ ꠘꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠦ ꠔꠣꠞ ꠘꠤꠎꠞ ꠀꠞ ꠔꠣꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠞ ꠉꠥꠘꠣꠞ ꠝꠣꠚꠤꠞ ꠟꠣꠉꠤ, ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠛꠤꠍꠣꠟꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","ꠛꠣꠖꠦ ꠢꠃ ꠍꠣꠉꠟ ꠖꠥꠁꠅꠐꠣ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠉꠦꠍꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠀꠘꠛ। ");
INSERT INTO syls_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","ꠀꠘꠤꠀ ꠢꠦ ꠟꠐꠣꠞꠤ ꠝꠣꠞꠤꠀ ꠖꠦꠈꠛ, ꠇꠥꠘ ꠍꠣꠉꠟ ꠝꠣꠛꠥꠖꠞ ꠟꠣꠉꠤ ꠀꠞ ꠇꠥꠘꠐꠣ ꠀꠎꠣꠎꠤꠟꠞ ꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","ꠟꠐꠣꠞꠤꠔ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠎꠦ ꠍꠣꠉꠟ ꠃꠑꠛ, ꠢꠣꠞꠥꠘꠦ ꠅꠉꠥꠖꠤ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠛ। ");
INSERT INTO syls_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","ꠀꠞ ꠀꠎꠣꠎꠤꠟꠞ ꠘꠣꠝꠦ ꠎꠦ ꠍꠣꠉꠟ ꠃꠑꠛ, ꠅꠉꠥꠞꠦ ꠎꠤꠔꠣ ꠢꠣꠟꠔꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠕꠁꠛ, ꠎꠣꠔꠦ ꠛꠣꠖꠦ ꠅꠉꠥꠞꠦ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠘꠤꠀ ꠀꠎꠣꠎꠤꠟꠞ ꠘꠣꠝꠦ ꠀꠃꠞꠤ ꠍꠣꠠꠤ ꠖꠦꠅꠀ ꠅꠄ। ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠦ ꠔꠣꠞ ꠘꠤꠎꠞ ꠀꠞ ꠔꠣꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠟꠣꠉꠤ, ꠔꠣꠞ ꠘꠤꠎꠞ ꠀꠘꠣ ꠢꠃ ꠛꠤꠍꠣꠟꠞꠦ ꠎꠛ ꠇꠞꠛ। ");
INSERT INTO syls_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠘꠤꠞ ꠎꠦ ꠐꠦꠛꠥꠟ ꠀꠍꠦ ꠅꠃ ꠐꠦꠛꠥꠟ ꠕꠣꠇꠤ ꠇꠤꠍꠥ ꠎꠣꠟꠣꠁꠟ ꠀꠋꠞꠣ ꠟꠁꠀ ꠢꠦ ꠀꠉꠞ ꠖꠣꠘꠤꠞ ꠝꠣꠎꠦ ꠜꠞꠛ, ꠀꠞ ꠖꠥꠁ ꠝꠥꠁꠐ ꠀꠉꠞ-ꠈꠥꠡꠛꠄꠞ ꠉꠥꠠꠣꠅ ꠟꠁꠛ, ꠛꠣꠖꠦ ꠙꠞ꠆ꠖꠣꠞ ꠜꠤꠔꠞꠦ ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚꠅ ꠢꠣꠝꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","ꠢꠣꠝꠣꠁꠀ ꠅꠃ ꠀꠋꠞꠣꠞ ꠃꠙꠞꠦ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠖꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠎꠣꠟꠣꠁꠛ, ꠔꠦꠃ ꠅꠔꠣꠞ ꠗꠥꠝꠣꠄ ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇꠞ ꠓꠣꠇꠘꠣꠞ ꠃꠙꠞꠞ ꠉꠣꠟꠣ ꠀꠘ꠆ꠖꠣꠁꠞꠦ ꠉꠥꠞꠤꠎꠤꠛ, ꠎꠣꠔꠦ ꠢꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠘꠣ ꠝꠞꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ꠛꠣꠖꠦ ꠢꠦ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠢꠃ ꠛꠤꠍꠣꠟꠞ ꠕꠥꠠꠣ ꠟꠃ ꠘꠤꠀ ꠀꠔꠞ ꠀꠋꠉꠥꠁꠟ ꠖꠤꠀ ꠅꠃ ꠓꠣꠇꠘꠣꠞ ꠍꠣꠝꠘꠞ ꠉꠣꠟꠣꠛꠣꠄ ꠍꠤꠐꠣꠁ ꠖꠤꠛ। ꠄꠞꠛꠣꠖꠦ ꠀꠋꠉꠥꠟꠤꠞ ꠝꠣꠎꠦ ꠀꠞꠅ ꠕꠥꠠꠣ ꠟꠃ ꠟꠣꠉꠣꠁꠀ ꠓꠣꠇꠘꠣꠞ ꠍꠣꠝꠘꠞ ꠛꠣꠄ ꠡꠣꠔ ꠛꠣꠞ ꠍꠤꠐꠣꠁꠀ ꠖꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“ꠀꠞ ꠢꠦ ꠝꠣꠘꠡꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠀꠘꠣ ꠍꠣꠉꠟꠐꠣꠞꠦ ꠎꠛ ꠇꠞꠛ, ꠇꠞꠤꠀ ꠅꠉꠥꠞ ꠟꠃ ꠘꠤꠀ ꠙꠞ꠆ꠖꠣꠞ ꠜꠤꠔꠞꠦ ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚꠅ ꠉꠤꠀ, ꠛꠤꠍꠣꠟꠞ ꠟꠃꠖꠤ ꠎꠦꠟꠣ ꠇꠞꠣ ꠅꠁꠍꠤꠟ, ꠅꠉꠥꠞ ꠟꠃꠖꠤꠅ ꠅꠟꠣ ꠇꠞꠔꠦ ꠅꠁꠛ। ꠡꠘ꠆ꠖꠥꠇꠞ ꠓꠣꠇꠘꠣꠞ ꠃꠙꠞꠦ ꠀꠞ ꠍꠣꠝꠘꠦ ꠅꠃ ꠟꠃ ꠍꠤꠐꠣꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠉꠥꠘꠣ, ꠘꠣꠙꠣꠇꠤ, ꠀꠞ ꠘꠣꠚꠞꠝꠣꠘꠤꠄ ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚꠞꠦꠅ ꠘꠣꠙꠣꠇ ꠇꠞꠤꠟꠣꠄ, ꠄꠞꠟꠣꠉꠤ ꠔꠣꠞꠣꠞ ꠝꠣꠎꠦ ꠎꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥ ꠀꠍꠦ, ꠅꠈꠣꠘꠞ ꠘꠣꠙꠣꠇꠤ ꠢꠞꠣꠘꠤꠞ ꠘꠤꠅꠔꠦ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠦ ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚꠞ ꠜꠤꠔꠞꠦ ꠢꠣꠝꠣꠁꠀ ꠢꠣꠞꠤ ꠢꠣꠞꠥꠘꠦ ꠔꠣꠘ ꠘꠤꠎꠞ, ꠔꠣꠘ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠞ ꠀꠞ ꠀꠡ꠆ꠔꠣ ꠡꠝꠣꠎꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠢꠇꠟ ꠇꠣꠝ ꠡꠦꠡ ꠇꠞꠤꠀ ꠎꠔꠛꠤꠟ ꠘꠣ ꠛꠣꠞ ꠅꠁꠀ ꠀꠁꠘ, ꠅꠔꠛꠤꠟ ꠖꠥꠍꠞꠣ ꠇꠥꠘꠥ ꠝꠣꠘꠥꠡ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠜꠤꠔꠞꠦ ꠢꠣꠝꠣꠘꠤ ꠘꠤꠡꠦꠗ। ");
INSERT INTO syls_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁꠀ ꠢꠣꠞꠥꠘꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠎꠦ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠘꠤꠞ ꠐꠦꠛꠥꠟ ꠀꠍꠦ ꠅꠃ ꠐꠦꠛꠥꠟꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠎꠣꠁꠛꠣ, ꠎꠣꠁꠀ ꠐꠦꠛꠥꠟꠞ ꠟꠣꠉꠤꠅ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠛꠣ। ꠢꠃ ꠛꠤꠍꠣꠟ ꠀꠞ ꠍꠣꠉꠟꠞ ꠕꠥꠠꠣ ꠟꠃ ꠘꠤꠀ ꠔꠣꠁꠘ ꠅꠃ ꠐꠦꠛꠥꠟꠞ ꠢꠤꠋꠉꠞ ꠝꠣꠎꠦ ꠟꠣꠉꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠉꠥꠘꠣꠞ ꠇꠣꠞꠘꠦ ꠐꠦꠛꠥꠟꠞ ꠝꠣꠎꠦ ꠎꠦ ꠘꠣꠙꠣꠇꠤ ꠟꠣꠉꠣꠁꠟ ꠅꠁꠍꠦ, ꠢꠃ ꠘꠣꠙꠣꠇꠤ ꠢꠞꠣꠁꠀ ꠅꠃ ꠐꠦꠛꠥꠟꠞꠦ ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠢꠣꠞꠥꠘꠦ ꠔꠣꠞ ꠀꠔꠞ ꠀꠋꠉꠥꠁꠟ ꠖꠤꠀ ꠅꠃ ꠐꠦꠛꠥꠟꠞ ꠃꠙꠞꠦ ꠡꠣꠔ ꠛꠣꠞ ꠟꠃ ꠍꠤꠐꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚ, ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥ, ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠘꠣꠙꠣꠇꠤ ꠢꠞꠣꠘꠤꠞ ꠇꠚꠞꠣꠞ ꠇꠣꠝ ꠡꠦꠡ ꠇꠞꠤꠀ ꠢꠣꠞꠟꠦ ꠢꠣꠞꠥꠘꠦ ꠀꠎꠣꠎꠤꠟꠞ ꠘꠣꠝꠦ ꠖꠦꠅꠀꠞ ꠟꠣꠉꠤ ꠢꠃ ꠎꠤꠔꠣ ꠍꠣꠉꠟꠞꠦ ꠟꠁꠀ ꠀꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","ꠀꠁꠀ ꠅꠃ ꠍꠣꠉꠟꠞ ꠇꠟ꠆ꠟꠣꠞ ꠃꠙꠞꠦ ꠔꠣꠞ ꠖꠥꠁꠅ ꠀꠔ ꠕꠁꠀ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠢꠇꠟ ꠉꠥꠘꠣ-ꠘꠣꠚꠞꠝꠣꠘꠤ ꠀꠞ ꠛꠖ ꠇꠣꠝꠞ ꠇꠕꠣ ꠡ꠆ꠛꠤꠇꠣꠞ ꠇꠞꠤꠀ ꠍꠣꠉꠟꠞ ꠇꠟ꠆ꠟꠣꠞ ꠃꠙꠞꠦ ꠅꠔꠣ ꠛꠞ꠆ꠔꠣꠁ ꠖꠤꠛ। ꠛꠣꠖꠦ ꠀꠉ ꠕꠣꠇꠤ ꠎꠥꠁꠔ ꠅꠀ ꠄꠇ ꠛꠦꠐꠣꠞꠦ ꠖꠤꠀ ꠅꠃ ꠍꠣꠉꠟꠞꠦ ꠢꠦ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠙꠣꠑꠣꠁ ꠖꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","ꠢꠃ ꠛꠦꠐꠣꠄ ꠘꠤꠀ ꠅꠉꠥꠞꠦ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠍꠣꠠꠤꠀ ꠀꠁꠛ। ꠔꠣꠞꠣꠞ ꠢꠇꠟ ꠘꠣꠚꠞꠝꠣꠘꠤꠞꠦ ꠅꠃ ꠍꠣꠉꠟꠦ ꠟꠁꠀ ꠘꠤꠞꠣꠁ ꠘꠤꠞ꠆ꠎꠘ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠀꠎꠤꠛꠘ ꠊꠥꠞꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“ꠀꠞ ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚꠅ ꠢꠣꠝꠣꠁꠛꠣꠞ ꠇꠣꠟꠅ ꠢꠣꠞꠥꠘꠦ ꠡꠣꠖꠣ ꠡꠥꠔꠤ ꠇꠣꠙꠠꠞ ꠎꠔ ꠟꠦꠛꠣꠍ ꠚꠤꠘ꠆ꠖꠤꠍꠟꠣ, ꠔꠣꠁꠘ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠔ ꠚꠤꠞꠤꠀ ꠀꠁꠀ ꠁꠔꠣ ꠈꠥꠟꠤꠀ ꠕꠁ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","ꠈꠥꠟꠤꠀ ꠔꠣꠁꠘ ꠇꠣꠛꠣ ꠊꠞꠞ ꠡꠤꠝꠣꠘꠣꠞ ꠜꠤꠔꠞꠦ ꠙꠣꠘꠤꠖꠤ ꠘꠣꠁꠀ ꠔꠣꠘ ꠘꠤꠎꠞ ꠟꠦꠛꠣꠍ ꠚꠤꠘ꠆ꠖꠤꠛꠣ। ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠛꠣꠞꠦ ꠀꠁꠀ ꠔꠣꠘ ꠘꠤꠎꠞ ꠀꠞ ꠝꠣꠘꠡꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠇꠞꠤ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠤꠀ, ꠔꠣꠘ ꠘꠤꠎꠞ ꠀꠞ ꠝꠣꠘꠡꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠅ ꠀꠖꠣꠄ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠌꠞ꠆ꠛꠤꠞꠦ ꠔꠣꠁꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠎꠣꠟꠣꠁꠟꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","ꠎꠦ ꠛꠦꠐꠣꠄ ꠀꠎꠣꠎꠤꠟꠞ ꠘꠣꠝꠞ ꠍꠣꠉꠟꠞꠦ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠍꠣꠠꠤꠀ ꠀꠁꠛ, ꠢꠦ-ꠅ ꠔꠣꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠢꠣꠞꠤ ꠙꠣꠘꠤ ꠖꠤꠀ ꠘꠣꠁꠀ ꠛꠣꠖꠦ ꠇꠦꠝ꠆ꠙꠞ ꠜꠤꠔꠞꠦ ꠢꠣꠝꠣꠁꠔ ꠙꠣꠞꠛ। ");
INSERT INTO syls_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","ꠉꠥꠘꠣ ꠝꠣꠚꠤꠞ ꠟꠣꠉꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠎꠦ ꠛꠤꠍꠣꠟ ꠀꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠎꠦ ꠍꠣꠉꠟꠞ ꠟꠃꠞꠦ ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚꠅ ꠘꠤꠛꠣꠞ ꠢꠥꠇꠥꠝ ꠖꠦꠅꠀ ꠅꠁꠍꠦ, ꠅꠔꠣꠞ ꠢꠇꠟ ꠉꠥꠡ꠆ꠔ, ꠈꠣꠟ, ꠉꠥꠚꠞ ꠀꠞ ꠢꠇꠟꠔꠣꠞꠦ ꠇꠦꠝ꠆ꠙꠞ ꠛꠣꠞꠦ ꠘꠤꠀ ꠄꠇꠎꠘꠦ ꠎꠣꠟꠣꠁꠟꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","ꠎꠦ ꠎꠘꠦ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠛꠣꠞꠦ ꠘꠤꠀ ꠎꠣꠟꠣꠁꠛ, ꠢꠦ-ꠅ ꠔꠣꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ, ꠙꠣꠘꠤꠖꠤ ꠘꠣꠁꠀ ꠢꠣꠞꠤ ꠛꠣꠖꠦ ꠀꠁꠀ ꠇꠦꠝ꠆ꠙꠞ ꠜꠤꠔꠞꠦ ꠢꠣꠝꠣꠁꠔ ꠙꠣꠞꠛ। ");
INSERT INTO syls_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“ꠄꠞꠛꠣꠖꠦ ꠀꠝꠤ ꠎꠦꠔꠣ ꠇꠁꠞꠣꠝ, ꠁꠔꠣ ꠅꠁꠟ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠢꠞ-ꠢꠣꠝꠦꠡꠣꠇꠥꠞ ꠘꠤꠅꠝ। ꠙꠞꠔꠦꠇ ꠛꠍꠞꠞ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠌꠣꠘ꠆ꠖꠞ ꠖꠡ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ, ꠔꠥꠝꠞꠣꠞ ꠙꠞꠔꠦꠇ ꠎꠘꠦ ꠢꠇꠟ ꠎꠣꠔꠞ ꠇꠣꠝ-ꠇꠣꠎ ꠀꠞ ꠞꠥꠎꠤ-ꠞꠥꠎꠉꠣꠞ ꠛꠣꠖ ꠖꠤꠀ, ꠘꠔ ꠅꠁꠀ ꠖꠤꠟ ꠡꠙꠤꠀ ꠖꠤꠛꠣꠄ। ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠛꠣ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠛꠡꠔ ꠇꠞꠞꠣ ꠜꠤꠘ-ꠖꠦꠡꠤ ꠢꠇꠟ ꠎꠘꠦ ꠁꠔꠣ ꠝꠣꠘꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","ꠇꠣꠞꠘ ꠅꠃꠖꠤꠘ ꠔꠥꠝꠞꠣꠞ ꠉꠥꠘꠣ ꠝꠣꠚꠤꠞ ꠟꠣꠉꠤ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠣ ꠅꠁꠛ, ꠔꠦꠃ ꠔꠥꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠢꠇꠟ ꠘꠝꠥꠘꠣꠞ ꠉꠥꠘꠣ ꠕꠣꠇꠤ ꠙꠣꠇ-ꠍꠣꠚ ꠅꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","ꠅꠃꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠢꠇꠟ ꠘꠝꠥꠘꠣꠞ ꠇꠣꠝ-ꠇꠣꠎ ꠛꠣꠖ ꠖꠤꠀ ꠀꠞꠣꠝ ꠇꠞꠛꠣꠄ, ꠙꠞꠔꠦꠇꠦ ꠘꠔ ꠅꠁꠀ ꠎꠣꠞꠎꠤꠞ ꠖꠤꠟ ꠡꠙꠤꠀ ꠖꠤꠛꠣꠄ। ꠁꠐꠣ ꠅꠁꠟ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠌꠤꠞꠇꠣꠟꠤꠘ ꠘꠤꠅꠝ। ");
INSERT INTO syls_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","ꠎꠦꠇꠥꠘꠥ ꠁꠝꠣꠝꠞꠦ ꠎꠦꠛꠟꠣ ꠙꠞꠗꠣꠘ ꠁꠝꠣꠝ ꠢꠤꠡꠣꠛꠦ ꠔꠣꠞ ꠛꠣꠚꠞ ꠎꠣꠉꠣꠔ ꠈꠦꠟꠣꠚꠔꠤ ꠡꠝꠎꠣꠁꠀ ꠛꠅꠀꠁꠟ ꠇꠞꠣ ꠅꠁꠛ, ꠢꠦ-ꠅ ꠅꠟꠣ ꠡꠣꠖꠣ ꠡꠥꠔꠤ ꠇꠣꠙꠠꠞ ꠙꠛꠤꠔ꠆ꠞ ꠟꠦꠛꠣꠍ ꠚꠤꠘ꠆ꠖꠤꠀ ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠛ। ");
INSERT INTO syls_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚ, ꠙꠛꠤꠔ꠆ꠞ ꠇꠣꠛꠣ ꠊꠞ, ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ, ꠛꠣꠇꠤ ꠁꠝꠣꠝ ꠅꠇꠟ, ꠀꠞ ꠀꠡ꠆ꠔꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠡꠝꠣꠎꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠛ। ");
INSERT INTO syls_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","ꠁꠐꠣ ꠅꠁꠟ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠢꠞ-ꠢꠣꠝꠦꠡꠣꠇꠥꠞ ꠘꠤꠅꠝ। ꠙꠞꠔꠦꠇ ꠛꠍꠞ ꠄꠇꠛꠣꠞ ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣ ꠅꠟꠣ ꠀꠖꠣꠄ ꠇꠞꠔꠦ ꠅꠁꠛ।” ꠔꠦꠃ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠑꠤꠇ ꠅꠃ ꠟꠣꠈꠣꠘ ꠢꠇꠟꠔꠣ ꠇꠞꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“ꠀꠝꠣꠞ ꠅꠃ ꠢꠥꠇꠥꠝ ꠈꠣꠘ ꠔꠥꠝꠤ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞꠦ, ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠀꠞ ꠔꠣꠝꠣꠝ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ। ꠔꠣꠞꠣꠞꠦ ꠇꠅ, ");
INSERT INTO syls_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠇꠦꠃ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠉꠞꠥ, ꠍꠣꠉꠟ ꠛꠣ ꠝꠦꠠꠣꠞꠦ ꠔꠣꠞꠣꠞ ꠛꠡꠔ ꠔꠣꠝ꠆ꠛꠥ ꠄꠟꠣꠇꠣꠔ ꠛꠣ ꠇꠦꠝ꠆ꠙꠞ ꠛꠣꠞꠦ ꠎꠦ ꠇꠥꠘꠥ ꠎꠣꠉꠣꠔ ꠇꠥꠞꠛꠣꠘꠤ ꠘꠤꠅꠔꠦ ꠎꠛ ꠇꠞꠤꠟꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ꠅꠃ ꠙꠡꠥꠞꠦ ꠢꠦ ꠝꠣꠛꠥꠖꠞ ꠇꠣꠛꠣ ꠊꠞꠞ ꠍꠣꠝꠘꠦ, ꠝꠣꠘꠤ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠉꠦꠍꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠘꠤꠅꠔꠦ ꠎꠛ ꠘꠣ ꠇꠞꠦ, ꠔꠦ ꠢꠦ ꠅꠃ ꠙꠡꠥꠞ ꠈꠥꠘꠞ ꠖꠣꠄꠁ ꠅꠁꠛ, ꠄꠞꠟꠣꠉꠤ ꠡꠝꠣꠎ ꠕꠣꠇꠤ ꠔꠣꠞ ꠘꠣꠝ ꠝꠤꠐꠣꠁꠟꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠅꠈꠘ ꠉꠣꠃ-ꠉꠦꠞꠣꠝꠞ ꠈꠥꠟꠣ ꠎꠣꠉꠣꠔ ꠎꠦꠔꠣ ꠙꠡꠥ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠁꠘ, ꠅꠃ ꠙꠡꠥ ꠎꠣꠘꠥ ꠔꠣꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠉꠦꠍꠦ ꠀꠘꠦ। ꠀꠘꠤꠀ ꠁꠝꠣꠝ ꠍꠣꠛꠞ ꠀꠔꠅ ꠡꠝꠎꠣꠁꠀ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠁꠔꠣ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠖꠤꠟꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠙꠡꠥ ꠎꠛ ꠇꠞꠤꠀ, ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠉꠦꠍꠦ ꠝꠣꠛꠥꠖꠞ ꠎꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠀꠍꠦ, ꠢꠘꠅ ꠅꠉꠥꠞ ꠟꠃ ꠍꠤꠐꠣꠁ ꠖꠤꠛꠣ, ꠀꠞ ꠙꠡꠥꠞ ꠌꠞ꠆ꠛꠤꠞꠦ ꠔꠣꠁꠘ ꠊꠦꠞꠣꠘ ꠀꠟꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠎꠣꠟꠣꠁꠟꠤꠛꠣ, ꠅꠃ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠝꠣꠛꠥꠖ ꠈꠥꠡꠤ ꠅꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","ꠈꠛꠞꠖꠣꠞ! ꠔꠣꠞꠣ ꠎꠣꠘꠥ ꠝꠣꠛꠥꠖꠞ ꠟꠉꠦ ꠛꠦꠁꠝꠣꠘꠤ ꠇꠞꠤꠀ ꠍꠣꠉꠟꠞꠥꠙꠤ ꠖꠦꠅ-ꠜꠥꠔꠞ ꠘꠣꠝꠦ ꠀꠁꠎ ꠕꠣꠇꠤ ꠀꠞ ꠇꠥꠘꠥ ꠙꠡꠥ ꠛꠟꠤ ꠘꠣ ꠖꠦꠄ। ꠅꠃ ꠢꠥꠇꠥꠝ ꠀꠝꠤ ꠔꠣꠞꠣꠞ ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠌꠤꠞꠇꠣꠟꠞ ꠟꠣꠉꠤ ꠎꠣꠞꠤ ꠇꠞꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“ꠀꠞ ꠔꠥꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠇꠥꠘꠥ ꠎꠘ ꠛꠣ ꠔꠣꠞꠣꠞ ꠝꠣꠎꠦ ꠛꠡꠔ ꠇꠞꠞꠣ ꠇꠥꠘꠥ ꠜꠤꠘ-ꠖꠦꠡꠤꠄ ꠎꠥꠖꠤ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠛꠣ ꠎꠦꠇꠥꠘꠥ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠦ, ");
INSERT INTO syls_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠅꠃ ꠙꠡꠥꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠡꠙꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠀꠝꠣꠞ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠉꠦꠍꠦ ꠘꠣ ꠀꠘꠦ, ꠔꠦ ꠁ ꠎꠣꠔꠤꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠔꠣꠞ ꠘꠣꠝ ꠝꠤꠐꠣꠁꠟꠤꠔ। ");
INSERT INTO syls_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ꠔꠥꠝꠤ ꠀꠞꠅ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠇꠥꠘꠥ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠛꠣ ꠔꠣꠞꠣꠞ ꠝꠣꠎꠦ ꠛꠡꠔ ꠇꠞꠞꠣ ꠇꠥꠘꠥ ꠜꠤꠘ-ꠖꠦꠡꠤꠄ ꠎꠥꠖꠤ ꠇꠥꠘꠥꠎꠣꠔ ꠟꠃ ꠈꠣꠄ, ꠔꠦ ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠔꠣꠞ ꠈꠦꠔꠤ ꠇꠞꠣꠔ ꠟꠣꠉꠤꠎꠤꠝꠥ, ꠡꠝꠣꠎ ꠕꠣꠇꠤ ꠔꠣꠞ ꠘꠣꠝ ꠝꠤꠐꠣꠁꠟꠤꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","ꠟꠃꠞ ꠝꠣꠎꠦꠃ ꠔ ꠢꠇꠟ ꠎꠣꠘꠖꠣꠞꠞ ꠎꠣꠘ ꠕꠣꠇꠦ। ꠄꠞꠟꠣꠉꠤ ꠔꠥꠝꠞꠣꠞ ꠎꠣꠘꠞ ꠛꠖꠟꠣ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠃꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠔ ꠍꠤꠐꠣꠁꠀ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠡꠥꠎꠥꠉ ꠖꠤꠍꠤ। ꠟꠃꠞ ꠝꠣꠎꠦ ꠎꠣꠘ ꠀꠍꠦ ꠇꠞꠤꠃ ꠟꠃꠞ ꠛꠖꠟꠣ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠅꠄ। ");
INSERT INTO syls_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","ꠄꠞꠟꠣꠉꠤ ꠀꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠁꠀꠞ, ꠔꠥꠝꠞꠣ ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠛꠡꠔ ꠇꠞꠞꠣ ꠇꠥꠘꠥ ꠜꠤꠘ-ꠖꠦꠡꠤꠄꠅ ꠎꠣꠘꠥ ꠟꠃ ꠘꠣ ꠈꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠎꠦꠇꠥꠘꠥ ꠎꠘꠦ ꠛꠣ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠛꠡꠔ ꠇꠞꠞꠣ ꠇꠥꠘꠥ ꠜꠤꠘ-ꠖꠦꠡꠤ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ, ꠡꠤꠇꠣꠞꠅ ꠉꠤꠀ ꠢꠣꠟꠣꠟ ꠇꠥꠘꠥ ꠙꠡꠥ ꠛꠣ ꠙꠣꠈꠤ ꠡꠤꠇꠣꠞ ꠇꠞꠤꠀ ꠀꠘꠦ, ꠔꠦ ꠅꠉꠥꠞ ꠟꠃ ꠛꠣꠞ ꠇꠞꠤꠀ ꠝꠣꠐꠤꠔ ꠉꠣꠠꠤꠟꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","ꠎꠣꠘ ꠔ, ꠎꠤꠘ꠆ꠖꠣ ꠢꠇꠟ ꠎꠣꠘꠖꠣꠞꠞ ꠟꠃꠞ ꠝꠣꠎꠦꠃ ꠔꠣꠞ ꠎꠣꠘ ꠕꠣꠇꠦ। ꠄꠞꠟꠣꠉꠤ ꠀꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠁꠀꠞ, ꠔꠣꠞꠣ ꠎꠣꠘꠥ ꠇꠥꠘꠥ ꠎꠣꠘꠖꠣꠞꠞ ꠟꠃ ꠘꠣ ꠈꠣꠄ, ꠟꠃ ꠅꠁꠟ ꠢꠇꠟ ꠎꠣꠘꠖꠣꠞꠞ ꠎꠣꠘ। ꠎꠦ ꠎꠘꠦ ꠅꠃ ꠟꠃ ꠈꠣꠁꠛ, ꠔꠣꠞ ꠘꠣꠝ ꠝꠤꠐꠣꠁꠟꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ꠀꠞ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠝꠞꠣ ꠙꠡꠥꠞ ꠛꠣ ꠎꠋꠟꠤ ꠎꠣꠘꠥꠀꠞꠦ ꠝꠣꠞꠣ ꠇꠥꠘꠥ ꠙꠡꠥꠞ ꠉꠥꠡ꠆ꠔ ꠈꠣꠁꠟꠣꠄ, ꠔꠦ ꠢꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠅꠃꠇ, ꠛꠣ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠛꠡꠔ ꠇꠞꠞꠣ ꠜꠤꠘ-ꠖꠦꠡꠤ ꠅꠃꠇ, ꠢꠦ ꠔꠣꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠖꠤꠀ ꠙꠣꠘꠤꠖꠤ ꠘꠣꠁꠔꠦ ꠅꠁꠛ। ꠔꠣ-ꠅ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠦ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠞꠁꠛ, ꠄꠞꠛꠣꠖꠦ ꠢꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠛꠘꠛ। ");
INSERT INTO syls_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","ꠅꠁꠟꠦ ꠢꠦ ꠎꠥꠖꠤ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠘꠣ ꠖꠦꠄ ꠀꠞ ꠙꠣꠘꠤꠖꠤ ꠘꠣ ꠘꠣꠄ, ꠔꠦ ꠁ ꠇꠍꠥꠞꠤꠞ ꠟꠣꠉꠤ ꠢꠦ ꠖꠣꠄꠁ ꠞꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠅ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","ꠄꠞꠟꠣꠉꠤ ꠔꠥꠝꠞꠣ ꠀꠉꠦ ꠎꠦ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠛꠡꠔ ꠇꠞꠔꠣꠄ, ꠢꠤꠘꠞ ꠝꠣꠘꠡꠦ ꠎꠦꠔꠣ ꠇꠞꠦ ꠔꠥꠝꠞꠣ ꠁꠔꠣ ꠇꠞꠤꠅ ꠘꠣ। ꠀꠞ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠘꠤꠞꠣꠝ, ꠢꠃ ꠖꠦꠡꠅ ꠉꠤꠀ ꠢꠣꠞꠟꠦ, ꠢꠘꠞ ꠝꠣꠘꠡꠦ ꠎꠦꠔꠣ ꠇꠞꠦ ꠁꠔꠣꠅ ꠔꠥꠝꠞꠣ ꠇꠞꠤꠅ ꠘꠣ। ꠔꠣꠞꠣ ꠎꠦꠟꠣ ꠌꠟꠦ, ꠔꠥꠝꠞꠣ ꠁꠟꠣ ꠌꠟꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","ꠛꠞꠋ ꠀꠝꠣꠞ ꠖꠦꠅꠀ ꠡꠞꠤꠅꠔ ꠝꠣꠚꠤꠇ ꠔꠥꠝꠞꠣꠞ ꠎꠤꠘ꠆ꠖꠦꠉꠤ ꠇꠣꠐꠣꠁꠛꠣꠄ। ꠈꠥꠛ ꠈꠤꠀꠟ ꠇꠞꠤꠀ ꠀꠝꠣꠞ ꠖꠦꠅꠀ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠀꠝꠟ ꠇꠞꠛꠣꠄ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","ꠀꠝꠣꠞ ꠛꠣꠔꠣꠁꠟ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠀꠞ ꠡꠞꠤꠅꠔꠞ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠔꠥꠝꠞꠣ ꠀꠝꠟ ꠇꠞꠛꠣꠄ, ꠎꠦ ꠎꠘꠦ ꠁꠔꠣ ꠀꠝꠟ ꠇꠞꠦ ꠢꠦ ꠄꠞ ꠃꠍꠤꠟ꠆ꠟꠣꠄ ꠔꠣꠞ ꠎꠣꠘ ꠛꠣꠌꠣꠁꠛ। ꠀꠝꠤꠃ ꠔ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ꠀꠙꠘ ꠟꠃꠞ ꠈꠦꠡ-ꠇꠥꠐꠥꠝꠞ ꠟꠉꠦ ꠡꠞꠤꠟꠤ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠛꠣ ꠛꠦꠁꠎ꠆ꠎꠔꠤ ꠇꠣꠝ ꠇꠞꠤꠅ ꠘꠣ। ꠀꠝꠤꠃ ꠔ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","ꠔꠥꠝꠞꠣꠞ ꠝꠣꠎꠞ ꠇꠦꠃ ꠎꠣꠘꠥ ꠘꠤꠎꠞ ꠝꠣʼꠞ ꠟꠉꠦ ꠡꠞꠤꠟꠤ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠤꠀ ꠔꠣꠞ ꠛꠣꠚꠞ ꠝꠣꠘ-ꠁꠎ꠆ꠎꠔ ꠘꠣ ꠟꠥꠐꠦ। ꠄꠁꠘ ꠔ ꠔꠣꠞ ꠝꠣ, ꠄꠘ ꠟꠉꠦ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠣ ꠢꠣꠞꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","ꠢꠣꠔꠘ ꠝꠣʼꠞ ꠟꠉꠦꠅ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠣ ꠢꠣꠞꠣꠝ, ꠀꠞꠘꠣꠄ ꠛꠣꠚꠞ ꠛꠦꠁꠎ꠆ꠎꠔꠤ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","ꠘꠤꠎꠞ ꠛꠁꠘ ꠛꠣ ꠢꠣꠔꠘ ꠛꠁꠘꠞ ꠟꠉꠦ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠣꠅ ꠢꠣꠞꠣꠝ, ꠀꠙꠘ ꠛꠣꠚꠞ ꠔꠞꠚꠣ ꠛꠁꠘ ꠛꠣ ꠝꠣʼꠞ ꠔꠞꠚꠣ ꠛꠁꠘ ꠅꠁꠟꠦꠅ ꠢꠣꠞꠣꠝ। ꠔꠣꠞꠣ ꠄꠇ ꠛꠣꠠꠤꠔ ꠎꠘꠝ ꠅꠃꠇ ꠛꠣ ꠀꠟꠣꠖꠣ ꠛꠣꠠꠤꠔ ꠎꠘꠝ ꠅꠁꠟꠦꠅ ꠢꠣꠞꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","ꠙꠥꠀ ꠛꠣ ꠙꠥꠠꠤꠞ ꠊꠞꠞ ꠘꠣꠔꠤꠘꠞ ꠟꠉꠦ ꠡꠞꠤꠟꠤ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠣ ꠢꠣꠞꠣꠝ, ꠁꠔꠣꠄ ꠔ ꠘꠤꠎꠞ ꠛꠦꠁꠎ꠆ꠎꠔꠤ ꠅꠄ। ");
INSERT INTO syls_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","ꠢꠣꠔꠘ ꠝꠣʼꠞ ꠊꠞꠞ ꠛꠁꠘꠞ ꠟꠉꠦ ꠡꠞꠤꠟꠤ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠣ ꠢꠣꠞꠣꠝ, ꠔꠣꠁ ꠔ ꠛꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","ꠀꠙꠘ ꠚꠥꠚꠥꠞ ꠟꠉꠦ ꠡꠞꠤꠟꠤ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠣ ꠢꠣꠞꠣꠝ, ꠄꠁꠘ ꠔ ꠛꠣꠚꠞ ꠟꠃꠞ ꠇꠥꠐꠥꠝ। ");
INSERT INTO syls_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","ꠀꠙꠘ ꠝꠁꠞ ꠟꠉꠦ ꠡꠞꠤꠟꠤ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠣ ꠢꠣꠞꠣꠝ, ꠄꠁꠘ ꠔ ꠝꠣʼꠞ ꠟꠃꠞ ꠇꠥꠐꠥꠝ। ");
INSERT INTO syls_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","ꠀꠙꠘ ꠌꠣꠌꠣꠞ ꠝꠣꠘ-ꠁꠎ꠆ꠎꠔ ꠟꠥꠐꠤꠀ ꠔꠣꠘ ꠛꠃꠞ ꠟꠉꠦ ꠡꠞꠤꠟꠤ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠣ ꠢꠣꠞꠣꠝ, ꠄꠁꠘ ꠔ ꠌꠣꠌꠤ। ");
INSERT INTO syls_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","ꠀꠙꠘ ꠙꠥꠀꠞ ꠛꠃꠞ ꠟꠉꠦ ꠡꠞꠤꠟꠤ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠣ ꠢꠣꠞꠣꠝ, ꠔꠣꠁ ꠔ ꠘꠤꠎꠞ ꠛꠃꠝꠣ। ");
INSERT INTO syls_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","ꠜꠣꠁꠞ ꠛꠃꠞ ꠟꠉꠦ ꠡꠞꠤꠟꠤ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠣ ꠢꠣꠞꠣꠝ, ꠀꠞꠘꠣꠄ ꠜꠣꠁꠞ ꠛꠦꠁꠎ꠆ꠎꠔꠤ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","ꠇꠥꠘꠥ ꠛꠦꠐꠤ ꠝꠣꠘꠡꠞ ꠟꠉꠦ ꠡꠞꠤꠟꠤ ꠝꠤꠟꠣ-ꠝꠤꠡꠣꠞ ꠛꠣꠖꠦ ꠔꠣꠁꠞ ꠙꠥꠠꠤꠞ ꠟꠉꠦ, ꠔꠣꠁꠞ ꠙꠥꠀ ꠛꠣ ꠙꠥꠠꠤꠞ ꠊꠞꠞ ꠘꠣꠔꠤꠘꠞ ꠟꠉꠦ ꠡꠞꠤꠟꠤ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠣ ꠢꠣꠞꠣꠝ, ꠄꠞꠣ ꠔ ꠔꠣꠁꠞ ꠟꠃꠞ ꠇꠥꠐꠥꠝ, ꠁꠔꠣ ꠛꠠ ꠈꠛꠤꠍꠤ ꠇꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","ꠀꠞ ꠛꠃ ꠎꠤꠔꠣ ꠕꠣꠇꠣ ꠢꠣꠟꠔꠦ ꠢꠣꠟꠤ ꠛꠣ ꠎꠦꠑꠣꠟꠤꠞꠦ ꠛꠤꠀ ꠇꠞꠤꠀ ꠢꠔꠤꠀꠟꠣ ꠇꠞꠣꠅ ꠢꠣꠞꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ꠢꠣꠄꠄꠎ ꠛꠣ ꠛꠦꠐꠤꠀꠞꠣ ꠝꠣꠡꠤꠇ ꠛꠦꠝꠣꠞ ꠕꠣꠇꠣ ꠢꠣꠟꠔꠦ ꠇꠥꠘꠥ ꠛꠦꠐꠤꠘ꠆ꠔꠞ ꠟꠉꠦ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠣ ꠢꠣꠞꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","ꠖꠥꠍꠞꠣ ꠇꠥꠘꠥ ꠛꠦꠐꠣꠞ ꠛꠃꠞ ꠟꠉꠦ ꠡꠞꠤꠟꠤ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠤꠀ, ꠘꠤꠎꠞꠦ ꠘꠣꠙꠣꠇ ꠛꠣꠘꠣꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ꠔꠥꠝꠞꠣꠞ ꠝꠣꠎꠞ ꠇꠦꠃ ꠘꠤꠎꠞ ꠙꠥꠀ ꠛꠣ ꠙꠥꠠꠤꠞꠦ ꠀꠉꠥꠁꠘꠖꠤ ꠎꠣꠟꠣꠁꠀ, ꠝꠥꠟꠇ ꠖꠦꠛꠔꠣꠞ ꠘꠣꠝꠦ ꠛꠟꠤ ꠖꠤꠀ, ꠀꠙꠘ ꠀꠟ꠆ꠟꠣꠞ ꠙꠛꠤꠔ꠆ꠞ ꠘꠣꠝꠞꠦ ꠅꠡꠝ꠆ꠝꠣꠘ ꠇꠞꠤꠅ ꠘꠣ। ꠀꠝꠤꠃ ꠔ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ꠛꠦꠐꠤꠘ꠆ꠔꠞ ꠟꠉꠦ ꠎꠦꠟꠣ ꠡꠞꠤꠟꠤ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠂꠘ, ꠛꠦꠐꠣꠁꠘ꠆ꠔꠦ-ꠛꠦꠐꠣꠁꠘ꠆ꠔꠦ ꠅꠟꠣ ꠈꠛꠤꠍꠤ ꠙꠥꠋꠉꠣꠝꠤ ꠇꠞꠣ ꠢꠣꠞꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","ꠇꠥꠘꠥ ꠙꠡꠥꠞ ꠟꠉꠦ ꠈꠛꠤꠍꠤ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠤꠀ, ꠇꠥꠘꠥ ꠛꠦꠐꠣꠁꠘ ꠘꠣꠙꠣꠇ ꠛꠘꠤꠅ ꠘꠣ। ꠇꠥꠘꠥ ꠙꠡꠥꠞ ꠟꠉꠦ ꠇꠥꠘꠥ ꠛꠦꠐꠤꠘ꠆ꠔꠦꠅ ꠈꠛꠤꠍꠤ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠤꠅ ꠘꠣ। ꠁꠟꠣꠈꠣꠘ ꠈꠛꠤꠍꠤ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠔ ꠎꠉꠔꠞ ꠘꠤꠅꠝꠞ ꠃꠟꠐꠣ। ");
INSERT INTO syls_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠥꠘꠥ ꠈꠛꠤꠍꠤ ꠛꠦꠁꠎ꠆ꠎꠔꠤ ꠇꠣꠝ ꠇꠞꠤꠀ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠎꠞ ꠇꠦꠃ ꠎꠣꠘꠥ ꠘꠤꠎꠞꠦ ꠘꠣꠙꠣꠇ ꠘꠣ ꠛꠣꠘꠣꠄ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠔꠥꠝꠞꠣꠞ ꠍꠣꠝꠘꠦ ꠕꠣꠇꠤ ꠎꠔ ꠎꠣꠔꠤ ꠅꠇꠟꠞꠦ ꠀꠝꠤ ꠈꠦꠖꠣꠁ ꠖꠤꠞꠣꠝ, ꠔꠣꠞꠣ ꠔ ꠅꠔꠣ ꠈꠛꠤꠍꠤ ꠇꠞꠤꠀ ꠘꠤꠎꠞꠦ ꠘꠣꠙꠣꠇ ꠇꠞꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","ꠅꠔꠣꠞ ꠟꠣꠉꠤ ꠔꠣꠞꠣꠞ ꠖꠦꠡꠞ ꠝꠣꠐꠤ ꠘꠣꠙꠣꠇ ꠛꠘꠤꠉꠦꠍꠦ, ꠔꠣꠞꠣꠞ ꠘꠣꠚꠞꠝꠣꠘꠤꠞ ꠇꠣꠞꠘꠦ ꠀꠝꠤ ꠅꠃ ꠖꠦꠡꠞꠦ ꠡꠣꠎꠣ ꠖꠤꠞꠣꠝ, ꠅꠃ ꠖꠦꠡꠞ ꠝꠣꠐꠤꠄ ꠔꠣꠞ ꠙ꠆ꠞꠎꠣ ꠅꠇꠟꠞꠦ ꠛꠝꠤ ꠇꠞꠤ ꠚꠣꠟꠣꠁ ꠖꠦꠞ। ");
INSERT INTO syls_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣ ꠈꠣꠟꠤ ꠀꠝꠣꠞ ꠖꠦꠅꠀ ꠡꠞꠤꠅꠔ ꠀꠞ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠝꠣꠘꠤꠀ ꠌꠟꠤꠅ। ꠔꠥꠝꠞꠣꠞ ꠘꠤꠎꠞ ꠎꠣꠔꠤꠞ ꠛꠣ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠎꠦ ꠛꠡꠔ ꠇꠞꠞꠣ ꠜꠤꠘ-ꠖꠦꠡꠤ ꠇꠦꠃ ꠎꠣꠘꠥ ꠅꠟꠣ ꠈꠛꠤꠍꠤ ꠛꠦꠁꠎ꠆ꠎꠔꠤꠞ ꠇꠥꠘꠥꠎꠣꠔ ꠇꠣꠝ ꠘꠣ ꠇꠞꠦ। ");
INSERT INTO syls_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","ꠀꠉꠦ ꠕꠣꠇꠤ ꠎꠦꠔꠣ ꠎꠣꠔꠤ ꠅꠇꠟ ꠢꠃ ꠖꠦꠡꠅ ꠛꠡꠔ ꠇꠞꠦꠞ, ꠔꠣꠞꠣ ꠅꠃ ꠘꠝꠥꠘꠣꠞ ꠈꠛꠤꠍꠤ ꠛꠦꠁꠎ꠆ꠎꠔꠤ ꠇꠣꠝ ꠅꠇꠟ ꠇꠞꠣꠄ ꠢꠘꠞ ꠝꠣꠐꠤꠞꠦ ꠘꠣꠙꠣꠇ ꠛꠣꠘꠣꠁꠟꠤꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","ꠅꠈꠘ ꠔꠥꠝꠞꠣꠅ ꠢꠘꠅ ꠉꠤꠀ ꠎꠥꠖꠤ ꠢꠔꠣꠞ ꠟꠣꠈꠣꠘ ꠘꠣꠙꠣꠇꠤ ꠇꠣꠝ ꠇꠞꠅ, ꠔꠦ ꠔꠣꠞꠣꠞ ꠟꠣꠈꠣꠘ ꠔꠥꠝꠞꠣꠞꠦꠅ ꠢꠃ ꠖꠦꠡꠞ ꠝꠣꠐꠤꠄ ꠛꠝꠤ ꠇꠞꠤ ꠚꠣꠟꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ꠁꠟꠣ ꠈꠛꠤꠍꠤ ꠇꠥꠘꠥ ꠇꠣꠝ ꠇꠦꠃ ꠇꠞꠟꠦ, ꠔꠥꠝꠞꠣꠞ ꠡꠝꠣꠎ ꠕꠣꠇꠤ ꠔꠣꠞ ꠘꠣꠝ ꠝꠤꠐꠣꠁꠟꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","ꠀꠝꠣꠞ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠔꠥꠝꠞꠣ ꠝꠣꠘꠤꠅ, ꠔꠥꠝꠞꠣ ꠢꠃ ꠖꠦꠡꠅ ꠉꠤꠀ ꠢꠣꠞꠤ ꠢꠘꠞ ꠙꠥꠞꠣꠘꠣ ꠛꠣꠡꠤꠘ꠆ꠖꠣ ꠅꠇꠟꠞ ꠌꠣꠟ-ꠌꠟꠘꠦ ꠌꠟꠤꠅ ꠘꠣ। ꠔꠣꠞꠣꠞ ꠈꠛꠤꠍꠤ ꠞꠤꠔꠤ-ꠞꠦꠅꠀꠎ ꠝꠣꠘꠤꠀ ꠔꠥꠝꠞꠣ ꠘꠣꠙꠣꠇ ꠅꠁꠅ ꠘꠣ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ।” ");
INSERT INTO syls_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠀꠞꠅ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“ꠔꠥꠝꠤ ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠅ, ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣ ꠔ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ, ꠄꠞꠟꠣꠉꠤ ꠔꠥꠝꠞꠣꠅ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠅꠅ। ");
INSERT INTO syls_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","ꠔꠥꠝꠞꠣ ꠙꠞꠔꠦꠇꠦ ꠎꠣꠞꠎꠤꠞ ꠝꠣ-ꠛꠣꠚꠞꠦ ꠔꠣꠎꠤꠝ ꠇꠞꠤꠅ, ꠀꠞ ꠀꠝꠣꠞ ꠖꠦꠅꠀ ꠢꠇꠟ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞ ꠝꠣꠘꠤꠅ। ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","ꠔꠥꠝꠞꠣ ꠇꠥꠘꠥꠎꠣꠔꠞ ꠖꠦꠛ-ꠖꠦꠛꠤꠞ ꠙꠥꠎꠣ ꠇꠞꠤꠅ ꠘꠣ, ꠙꠥꠎꠣ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠚꠞ꠆ꠝꠣꠔ ꠓꠣꠟꠤꠀ ꠡꠥꠘꠣ-ꠞꠥꠙꠣ, ꠙꠤꠔꠟ-ꠔꠣꠝꠣꠖꠤ ꠇꠥꠘꠥ ꠖꠦꠛ-ꠖꠦꠛꠤꠞ ꠝꠥꠞ꠆ꠔꠤꠅ ꠛꠣꠘꠣꠁꠅ ꠘꠣ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ꠔꠥꠝꠞꠣ ꠎꠦꠛꠟꠣ ꠘꠤꠎꠞ ꠈꠥꠡꠤꠄ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠇꠥꠘꠥ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅ, ꠅꠃ ꠡꠝꠄ ꠅꠟꠣ ꠜꠣꠛ ꠟꠁꠀ ꠖꠤꠅ, ꠎꠣꠔꠦ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠁꠔꠣ ꠇꠛꠥꠟ ꠅꠄ। ");
INSERT INTO syls_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","ꠀꠞ ꠁꠔꠣꠞ ꠢꠇꠟ ꠉꠥꠡ꠆ꠔ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠖꠤꠘ ꠛꠣ ꠛꠣꠖꠞ ꠖꠤꠘ ꠈꠣꠁꠟꠤꠔꠦ ꠅꠁꠛ। ꠔꠤꠘ ꠖꠤꠘꠞ ꠖꠤꠘ ꠇꠥꠘꠥ ꠉꠥꠡ꠆ꠔ ꠛꠣꠇꠤ ꠞꠁꠟꠦ, ꠁꠔꠣ ꠀꠉꠥꠁꠘꠖꠤ ꠎꠣꠟꠣꠁꠟꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","ꠔꠤꠘ ꠖꠤꠘꠞ ꠖꠤꠘ ꠔ ꠁ ꠉꠥꠡ꠆ꠔ ꠘꠣꠙꠣꠇ ꠛꠘꠤꠎꠣꠄ, ꠁꠔꠣ ꠈꠣꠁꠟꠦ ꠔꠥꠝꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠛꠥꠟ ꠅꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ꠁ ꠉꠥꠡ꠆ꠔ ꠇꠦꠃ ꠈꠣꠁꠟꠦ ꠢꠦ ꠘꠣꠚꠞꠝꠣꠘꠤꠞ ꠖꠣꠠꠅ ꠙꠠꠛ, ꠢꠦ ꠔ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠞ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠎꠤꠘꠤꠡꠞꠦ ꠘꠣꠙꠣꠇ ꠛꠣꠘꠣꠁꠍꠦ। ꠔꠦ ꠔꠥꠝꠞꠣꠞ ꠡꠝꠣꠎ ꠕꠣꠇꠤ ꠔꠣꠞ ꠘꠣꠝ ꠝꠤꠐꠣꠁꠟꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ꠈꠦꠔꠞ ꠚꠡꠟ ꠇꠣꠐꠣꠞ ꠡꠝꠄ ꠔꠥꠝꠞꠣ ꠎꠝꠤꠘꠞ ꠀꠁꠟꠞ ꠇꠣꠘ꠆ꠖꠣꠞ ꠚꠡꠟ ꠍꠣꠚ ꠇꠞꠤꠀ ꠇꠣꠐꠤꠅ ꠘꠣ, ꠀꠞ ꠇꠣꠐꠣꠞ ꠛꠣꠖꠦ ꠎꠝꠤꠘꠅ ꠚꠣꠟꠣꠁꠟ ꠚꠡꠟ ꠟꠥꠞꠤꠀ ꠘꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","ꠀꠋꠉꠥꠞ ꠈꠦꠔꠞ ꠀꠋꠉꠥꠞ ꠙꠣꠠꠤꠛꠣꠞ ꠇꠣꠟꠅ, ꠔꠟꠦ ꠚꠣꠟꠣꠁꠟ ꠀꠋꠉꠥꠞ ꠔꠥꠛꠣꠁꠀ ꠔꠥꠟꠤꠅ ꠘꠣ, ꠀꠞ ꠢꠇꠟ ꠀꠋꠉꠥꠞ ꠍꠣꠚ ꠇꠞꠤ ꠙꠣꠠꠤꠀ ꠘꠤꠅ ꠘꠣ। ꠡꠝꠣꠎꠞ ꠉꠞꠤꠛ-ꠖꠥꠈꠤ ꠀꠞ ꠛꠤꠖꠦꠡꠤ ꠝꠥꠍꠣꠚꠤꠞꠞ ꠟꠣꠉꠤ ꠁꠔꠣ ꠇꠤꠍꠥ ꠕꠁꠀ ꠎꠣꠁꠅ। ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ꠌꠥꠞꠤ ꠇꠞꠤꠅ ꠘꠣ, ꠝꠤꠍꠣ ꠝꠣꠔꠤꠅ ꠘꠣ, ꠀꠞ ꠄꠇꠦ-ꠅꠁꠘ꠆ꠘꠦ ꠐꠉꠣ-ꠐꠉꠤ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠘꠣꠝ ꠟꠁꠀ ꠝꠤꠍꠣ ꠇꠍꠝ ꠈꠣꠁꠅ ꠘꠣ, ꠁꠟꠣ ꠇꠞꠟꠦ ꠔꠥꠝꠞꠣꠞ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠞꠦ ꠅꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠣ ꠅꠄ। ꠀꠝꠤꠃ ꠔ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ꠇꠥꠘꠥ ꠀꠞꠤ-ꠚꠞꠤꠞ ꠃꠙꠞꠦ ꠎꠥꠞ-ꠎꠥꠟꠥꠝ ꠇꠞꠤꠅ ꠘꠣ, ꠔꠣꠞꠣꠞ ꠇꠥꠘꠥ ꠎꠤꠘꠤꠡ ꠇꠣꠠꠤꠀ ꠘꠤꠅ ꠘꠣ। ꠞꠥꠎꠤ ꠇꠣꠝꠟꠣꠞ ꠛꠦꠔꠘ ꠅꠃ ꠖꠤꠘꠞ ꠝꠣꠎꠦꠃ ꠀꠖꠣꠄ ꠇꠞꠤꠅ, ꠛꠣꠖꠞ ꠖꠤꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠔꠣꠞ ꠛꠦꠔꠘ ꠀꠐꠇꠣꠁ ꠕꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","ꠇꠥꠘꠥ ꠈꠣꠟꠥꠀꠞꠦ ꠛꠖ꠆ꠖꠥꠀ ꠖꠤꠅ ꠘꠣ, ꠇꠣꠘꠣ ꠛꠣ ꠀꠘ꠆ꠖꠣꠄ ꠃꠡ꠆ꠐꠣ ꠈꠣꠁꠛꠣꠞ ꠟꠣꠉꠤ ꠔꠣꠞ ꠙꠕꠞ ꠝꠣꠎꠦ ꠇꠥꠘ꠆ꠔꠣ ꠕꠁꠅ ꠘꠣ। ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞꠦ ꠁꠎ꠆ꠎꠔ-ꠔꠣꠎꠤꠝ ꠇꠞꠤꠅ, ꠀꠝꠤꠃ ꠔ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ꠘꠣ-ꠢꠇ ꠛꠤꠌꠣꠞ ꠇꠞꠤꠅ ꠘꠣ, ꠛꠤꠌꠣꠞꠞ ꠝꠣꠎꠦ ꠉꠞꠤꠛ-ꠗꠘꠤ, ꠛꠣ ꠢꠥꠞꠥ-ꠛꠠꠞ ꠙꠇ꠆ꠇꠙꠣꠔꠤ ꠅꠁꠅ ꠘꠣ, ꠢꠇꠟꠞ ꠟꠣꠉꠤ ꠢꠇ ꠛꠤꠌꠣꠞ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","ꠝꠣꠘꠡꠞ ꠛꠖꠘꠣꠝ ꠉꠣꠁꠀ ꠉꠣꠁꠀ ꠊꠥꠞꠤꠅ ꠘꠣ, ꠇꠥꠘꠥ ꠝꠣꠘꠡꠞ ꠎꠣꠘꠞ ꠈꠦꠔꠤ ꠅꠄ, ꠁꠟꠣ ꠇꠥꠘꠥ ꠇꠣꠝ ꠇꠞꠤꠅ ꠘꠣ। ꠀꠝꠤꠃ ꠔ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ꠀꠙꠘ ꠀꠞꠤ-ꠚꠞꠤꠞ ꠛꠣꠄ ꠁꠋꠡꠣ-ꠖꠥꠡꠝꠘꠤꠞ ꠜꠣꠛ ꠝꠘꠞ ꠝꠣꠎꠦ ꠉꠣꠕꠤꠀ ꠞꠣꠈꠤꠅ ꠘꠣ। ꠔꠣꠞ ꠅꠙꠞꠣꠗ ꠔꠣꠞꠦ ꠛꠥꠎꠣꠁ ꠖꠤꠅ, ꠔꠦꠃ ꠔꠣꠞ ꠉꠥꠘꠣꠞ ꠜꠣꠞ ꠔꠥꠝꠣꠞ ꠃꠙꠞꠦ ꠀꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","ꠘꠤꠎꠞ ꠎꠣꠔꠤꠞ ꠝꠣꠘꠡꠞ ꠛꠖꠟꠣ ꠟꠁꠅ ꠘꠣ, ꠔꠣꠞꠣꠞ ꠛꠣꠄ ꠎꠤꠖ-ꠁꠋꠡꠣꠞ ꠜꠣꠛ ꠝꠘꠞ ꠝꠣꠎꠦ ꠉꠣꠕꠤꠀ ꠞꠣꠈꠤꠅ ꠘꠣ। ꠀꠞꠤ-ꠚꠞꠤꠞꠦ ꠔꠥꠝꠣꠞ ꠘꠤꠎꠞ ꠟꠣꠈꠣꠘ ꠝꠣꠄꠀ ꠇꠞꠤꠅ। ꠀꠝꠤꠃ ꠔ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠝꠣꠘꠤꠀ ꠌꠟꠤꠅ। ꠄꠇ ꠎꠣꠔꠞ ꠙꠡꠥꠞ ꠟꠉꠦ ꠀꠞꠇ ꠎꠣꠔꠞ ꠙꠡꠥꠞꠦ ꠚꠣꠟ ꠈꠣꠛꠣꠁꠅ ꠘꠣ। ꠄꠇ ꠎꠝꠤꠘꠅ ꠖꠥꠁ ꠎꠣꠔꠞ ꠛꠤꠌ ꠈꠦꠔ ꠇꠞꠤꠅ ꠘꠣ, ꠀꠞ ꠖꠥꠁ ꠎꠣꠔꠞ ꠡꠥꠔꠣꠖꠤ ꠛꠣꠘꠣꠁꠟ ꠇꠣꠙꠠ ꠚꠤꠘ꠆ꠖꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ꠇꠥꠘꠥ ꠛꠣꠘ꠆ꠖꠤ ꠛꠦꠐꠤꠞ ꠛꠤꠀ ꠑꠤꠇ ꠇꠞꠣ ꠅꠁꠍꠦ, ꠅꠁꠟꠦ ꠔꠣꠁꠞ ꠝꠢꠞꠣꠘꠣꠞ ꠐꠦꠇꠣ ꠖꠦꠅꠀ ꠅꠁꠍꠦ ꠘꠣ, ꠛꠣ ꠝꠣꠟꠤꠇꠦ ꠎꠦꠉꠥꠞꠦ ꠀꠎꠣꠖ ꠇꠞꠤꠀ ꠖꠤꠍꠂꠘ ꠘꠣ, ꠁꠟꠣ ꠇꠥꠘꠥ ꠛꠣꠘ꠆ꠖꠤꠞ ꠟꠉꠦ ꠇꠦꠃ ꠡꠞꠤꠟꠤ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠟꠦ, ꠔꠦ ꠢꠦ ꠈꠦꠔꠤ-ꠙꠥꠞꠘ ꠖꠤꠔꠦ ꠅꠁꠛ। ꠁ ꠖꠥꠁꠅ ꠎꠘꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠅ ꠘꠣ, ꠇꠣꠞꠘ ꠅꠃ ꠛꠣꠘ꠆ꠖꠤ ꠙꠥꠠꠤ ꠔ ꠀꠎꠣꠖ ꠅꠁꠍꠦ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","ꠅꠁꠟꠦ ꠅꠃ ꠛꠦꠐꠣꠄ ꠔꠣꠞ ꠖꠥꠡ-ꠇꠍꠥꠞꠤꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ, ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠘꠤꠈꠥꠔ ꠄꠉꠥ ꠝꠦꠠꠣ ꠟꠁꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠍꠣꠝꠘꠦ ꠀꠎꠤꠞ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","ꠖꠥꠡ-ꠇꠍꠥꠞꠤꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠀꠘꠣ ꠢꠃ ꠙꠡꠥꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠀ, ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠔꠣꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠛꠣꠖꠦ, ꠢꠦ ꠅꠃ ꠉꠥꠘꠣꠞ ꠝꠣꠚꠤ ꠙꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠖꠦꠡꠅ ꠉꠤꠀ ꠢꠣꠞꠤ ꠇꠥꠘꠥ ꠚꠟꠞ ꠉꠣꠍ ꠟꠣꠉꠣꠁꠟꠦ, ꠔꠤꠘ ꠛꠍꠞ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠁ ꠉꠣꠍꠞ ꠚꠟ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠢꠣꠞꠣꠝ। ꠅꠃ ꠔꠤꠘ ꠛꠍꠞꠞ ꠝꠣꠎꠦ ꠁ ꠉꠣꠍꠞ ꠚꠟ ꠈꠣꠅꠀ ꠘꠣꠎꠣꠁꠎ। ");
INSERT INTO syls_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","ꠌꠣꠁꠞ ꠘꠝ꠆ꠛꠞ ꠛꠍꠞꠅ ꠁ ꠉꠣꠍꠞ ꠢꠇꠟ ꠚꠟ ꠝꠣꠛꠥꠖꠞ ꠡꠥꠇꠥꠞ-ꠉꠥꠎꠣꠞꠤꠞ ꠘꠤꠅꠔꠦ ꠔꠣꠘ ꠘꠣꠝꠦ ꠖꠤꠟꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","ꠙꠣꠌ ꠘꠝ꠆ꠛꠞ ꠛꠍꠞ ꠕꠣꠇꠤ ꠅꠃ ꠉꠣꠍꠞ ꠚꠟ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠢꠣꠟꠣꠟ। ꠁꠔꠣ ꠝꠣꠘꠟꠦ ꠔꠥꠝꠞꠣꠞ ꠉꠣꠍꠅ ꠛꠃꠔ ꠚꠟ ꠀꠁꠛ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ꠔꠥꠝꠞꠣ ꠟꠃ ꠡꠝꠦꠔ ꠇꠥꠘꠥ ꠉꠥꠡ꠆ꠔ ꠈꠣꠁꠅ ꠘꠣ। ꠇꠥꠘꠥ ꠎꠣꠔꠞ ꠎꠣꠖꠥ-ꠝꠘꠔ꠆ꠞ ꠛꠣ ꠉꠘꠣ-ꠛꠣꠍꠣ ꠢꠤꠇꠤꠅ ꠘꠣ, ꠀꠞ ꠛꠦꠛꠢꠣꠞꠅ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","ꠝꠣꠕꠣꠞ ꠖꠥꠁꠅ ꠉꠣꠟꠣꠞ ꠌꠥꠟ ꠍꠣꠐꠣ, ꠛꠣ ꠖꠣꠠꠤꠞ ꠀꠉꠣ ꠇꠣꠐꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","ꠝꠥꠞ꠆ꠖꠣꠞ ꠟꠣꠉꠤ ꠀꠢꠣꠎꠣꠞꠤ ꠇꠞꠣꠔ ꠉꠤꠀ ꠘꠤꠎꠞ ꠡꠞꠤꠟꠅ ꠎꠈꠝ ꠇꠞꠤꠅ ꠘꠣ। ꠉꠔꠞꠞ ꠝꠣꠎꠦ ꠇꠥꠘꠥꠎꠣꠔ ꠌꠣꠙ-ꠍꠛꠤ ꠀꠇꠤꠅ ꠘꠣ। ꠀꠝꠤꠃ ꠔ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ꠐꠦꠇꠣ ꠞꠥꠎꠤꠞ ꠘꠤꠅꠔꠦ ꠘꠤꠎꠞ ꠙꠥꠠꠤꠞꠦ ꠍꠤꠟꠣꠘꠤ-ꠛꠖꠝꠣꠁꠡꠤꠔ ꠟꠣꠉꠣꠁꠅ ꠘꠣ। ꠀꠞꠘꠣꠄ ꠀꠡ꠆ꠔꠣ ꠖꠦꠡ ꠎꠤꠘꠣꠄ ꠜꠞꠤꠎꠤꠛ, ꠙꠥꠞꠣ ꠖꠦꠡꠅ ꠈꠛꠤꠍꠤ ꠛꠣꠠꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","ꠀꠝꠣꠞ ꠖꠦꠅꠀ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞꠦ ꠎꠤꠞꠣꠁꠅ, ꠀꠞ ꠀꠝꠣꠞ ꠇꠣꠛꠣ ꠊꠞꠞꠦ ꠁꠎ꠆ꠎꠔ ꠇꠞꠤꠅ। ꠀꠝꠤꠃ ꠔ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ꠎꠤꠘ꠆ꠘꠣꠔ ꠛꠣ ꠙꠦꠞꠔ ꠡꠣꠗꠇ, ꠉꠘꠇ ꠛꠣ ꠎꠣꠖꠥ-ꠐꠥꠘꠣ ꠇꠞꠞꠣꠞ ꠉꠦꠍꠦ ꠎꠣꠁꠅ ꠘꠣ, ꠁꠔꠣꠞ ꠟꠉꠦ ꠝꠤꠡꠤꠅ ꠘꠣ। ꠀꠞꠘꠣꠄ ꠁꠔꠣꠄ ꠔꠥꠝꠞꠣꠞꠦ ꠘꠣꠙꠣꠇ ꠛꠣꠘꠣꠁꠟꠤꠛꠣ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ꠝꠥꠞꠛ꠆ꠛꠤ ꠝꠣꠘꠥꠡ ꠗꠣꠞꠅ ꠀꠁꠟꠦ ꠔꠥꠝꠞꠣ ꠃꠛꠣꠁꠀ ꠁꠎ꠆ꠎꠔ ꠖꠤꠅ। ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠀꠟ꠆ꠟꠣꠞ ꠒꠞ-ꠈꠚꠦ ꠞꠁꠅ। ꠀꠝꠤꠃ ꠔ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ꠔꠥꠝꠞꠣꠞ ꠖꠦꠡꠅ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠛꠡꠔ ꠇꠞꠞꠣ ꠜꠤꠘ-ꠖꠦꠡꠤ ꠝꠣꠘꠡꠞ ꠃꠙꠞꠦ ꠎꠥꠟꠥꠝ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","ꠘꠤꠎꠞ ꠎꠣꠔꠤꠞ ꠟꠉꠦ ꠎꠦꠟꠣ ꠛꠦꠛꠢꠣꠞ ꠇꠞꠅ, ꠔꠣꠞꠣꠞ ꠟꠉꠦꠅ ꠅꠟꠣ ꠛꠦꠛꠢꠣꠞ ꠇꠞꠤꠅ, ꠔꠣꠞꠣꠞꠦ ꠘꠤꠎꠞ ꠟꠣꠈꠣꠘ ꠝꠣꠄꠀ ꠇꠞꠤꠅ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠔꠥꠝꠞꠣꠅ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠜꠤꠘ-ꠖꠦꠡꠤ ꠢꠣꠟꠔꠦ ꠀꠍꠟꠣꠄ, ꠀꠞ ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ꠔꠥꠝꠞꠣ ꠇꠥꠘꠥꠎꠣꠔ ꠝꠣꠙ-ꠎꠥꠇꠅ ꠀꠞ ꠙꠣꠟ꠆ꠟꠣꠞ ꠃꠎꠘꠅ ꠛꠦ-ꠁꠘꠍꠣꠚꠤ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","ꠔꠥꠝꠞꠣꠞ ꠙꠣꠟ꠆ꠟꠣ-ꠙꠣꠔ꠆ꠔꠞ, ꠢꠦꠞ-ꠚꠥꠞꠣ, ꠘꠟ-ꠖꠠꠤ, ꠝꠣꠙꠞ ꠢꠇꠟꠔꠣ ꠎꠣꠘꠥ ꠑꠤꠇ-ꠑꠣꠇ ꠕꠣꠇꠦ। ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ, ꠀꠞ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠀꠝꠤꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","ꠀꠝꠣꠞ ꠛꠣꠔꠣꠁꠟ ꠢꠇꠟ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠀꠞ ꠙꠥꠞꠣꠙꠥꠞ ꠡꠞꠤꠅꠔ ꠔꠥꠝꠞꠣ ꠝꠣꠘꠤꠀ ꠌꠟꠤꠅ। ꠀꠝꠤꠃ ꠔ ꠝꠣꠛꠥꠖ।” ");
INSERT INTO syls_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠎꠞ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠛꠣ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠛꠡꠔ ꠇꠞꠞꠣ ꠜꠤꠘ-ꠖꠦꠡꠤ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠔꠣꠞ ꠙꠥꠀ ꠛꠣ ꠙꠥꠠꠤꠞꠦ ꠝꠥꠟꠇ ꠖꠦꠛꠔꠣꠞ ꠘꠣꠝꠦ ꠛꠟꠤ ꠖꠦꠄ, ꠔꠦ ꠅꠉꠥꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠤꠛꠣꠄ, ꠖꠦꠡꠞ ꠝꠣꠘꠡꠦ ꠝꠤꠟꠤꠀ ꠙꠣꠔ꠆ꠔꠞꠖꠤ ꠁꠐꠣꠁꠀ ꠔꠣꠞꠦ ꠝꠣꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","ꠢꠦ ꠘꠤꠎꠞ ꠙꠥꠀ ꠛꠣ ꠙꠥꠠꠤꠞꠦ ꠀꠉꠥꠁꠘꠖꠤ ꠎꠣꠟꠣꠁꠀ ꠝꠥꠟꠇ ꠖꠦꠛꠔꠣꠞ ꠘꠣꠝꠦ ꠛꠟꠤ ꠖꠤꠀ, ꠀꠝꠣꠞ ꠇꠣꠛꠣ ꠊꠞꠞꠦ ꠘꠣꠙꠣꠇ ꠛꠣꠘꠣꠁꠍꠦ ꠀꠞ ꠀꠝꠣꠞ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠘꠣꠝꠞꠦ ꠅꠡꠝ꠆ꠝꠣꠘ ꠇꠞꠍꠦ। ꠄꠞꠟꠣꠉꠤ ꠀꠝꠤ ꠔꠣꠞ ꠈꠦꠔꠤ ꠇꠞꠣꠔ ꠟꠣꠉꠝꠥ, ꠁ ꠎꠣꠔꠤꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠔꠣꠞ ꠘꠣꠝ ꠝꠤꠐꠣꠁꠟꠤꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","ꠅꠃ ꠖꠦꠛꠔꠣꠞ ꠘꠣꠝꠦ ꠔꠣꠞ ꠙꠥꠀ ꠛꠣ ꠙꠥꠠꠤꠞꠦ ꠛꠟꠤ ꠖꠦꠅꠀꠞ ꠡꠝꠄ, ꠁ ꠖꠦꠡꠞ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠖꠦꠈꠤꠀꠅ ꠘꠣ-ꠖꠦꠈꠣꠞ ꠜꠣꠘ ꠇꠞꠂꠘ, ꠀꠞ ꠁ ꠛꠟꠤ ꠖꠦꠅꠞꠣꠞꠦ ꠎꠣꠘꠦ ꠘꠣ ꠝꠣꠞꠂꠘ, ");
INSERT INTO syls_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ꠔꠦ ꠀꠝꠤ ꠘꠤꠎꠦ ꠅꠃ ꠘꠣꠚꠞꠝꠣꠘ ꠀꠞ ꠔꠣꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠈꠦꠔꠤ ꠇꠞꠣꠔ ꠟꠣꠉꠤꠎꠤꠝꠥ। ꠀꠝꠤ ꠅꠉꠥꠞ ꠘꠣꠝ ꠀꠞ ꠅꠉꠥꠞ ꠟꠣꠈꠣꠘ ꠀꠞꠅ ꠎꠦꠉꠥꠁꠘ꠆ꠔꠦ ꠁꠟꠣ ꠘꠣꠚꠞꠝꠣꠘꠤ ꠇꠞꠛ, ꠅꠔꠣ ꠢꠇ꠆ꠇꠟꠐꠤꠞ ꠘꠣꠝ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠡꠝꠣꠎ ꠕꠣꠇꠤ ꠝꠤꠐꠣꠁꠟꠤꠝꠥ। ꠄꠞꠣ ꠔ ꠀꠝꠣꠞ ꠟꠉꠦ ꠛꠦꠁꠝꠣꠘꠤ ꠇꠞꠤꠀ ꠢꠃ ꠝꠥꠟꠇ ꠖꠦꠛꠔꠣꠞ ꠀꠔꠅ ꠘꠤꠎꠞꠦ ꠡꠙꠤ ꠖꠤꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠀꠝꠣꠞ ꠟꠉꠦ ꠛꠦꠁꠝꠣꠘꠤ ꠇꠞꠤꠀ, ꠎꠤꠘ-ꠜꠥꠔ ꠡꠣꠗꠇ ꠛꠣ ꠉꠘꠇꠞ ꠟꠉꠦ ꠝꠤꠡꠤꠀ ꠘꠤꠎꠞꠦ ꠡꠙꠤ ꠖꠤꠟꠣꠄ, ꠔꠦ ꠔꠣꠞꠅ ꠈꠦꠔꠤ ꠇꠞꠣꠔ ꠟꠣꠉꠤꠎꠤꠝꠥ ꠀꠞ ꠁ ꠎꠣꠔꠤꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠔꠣꠞ ꠘꠣꠝ ꠝꠤꠐꠣꠁꠟꠤꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠟꠣꠉꠤ ꠘꠤꠎꠞꠦ ꠀꠟꠣꠖꠣ ꠇꠞꠅ ꠀꠞ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠅꠅ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","ꠀꠝꠣꠞ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠙꠥꠞꠣꠙꠥꠞ ꠀꠝꠟ ꠇꠞꠤꠅ। ꠀꠝꠤꠃ ꠔ ꠝꠣꠛꠥꠖ, ꠀꠝꠤꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠤ। ");
INSERT INTO syls_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ꠎꠦ ꠝꠣꠘꠡꠦ ꠀꠙꠘ ꠝꠣ-ꠛꠣꠚꠞꠦ ꠉꠣꠟꠤ-ꠉꠣꠟꠣꠎ ꠇꠞꠤꠀ ꠛꠦꠁꠎ꠆ꠎꠔ ꠇꠞꠦ, ꠔꠣꠞꠦꠅ ꠎꠣꠘꠦ ꠝꠣꠞꠛꠣꠄ। ꠅꠃ ꠘꠣꠚꠞꠝꠣꠘꠤꠞ ꠖꠣꠄ ꠔꠣꠞ ꠝꠃꠔꠞ ꠟꠣꠉꠤ ꠢꠦ ꠘꠤꠎꠦꠃ ꠖꠣꠄꠁ। ");
INSERT INTO syls_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠀꠞꠤ-ꠚꠞꠤꠞ ꠇꠥꠘꠥ ꠎꠘꠞ ꠛꠃꠞ ꠟꠉꠦ ꠎꠤꠘꠣ ꠇꠞꠦ, ꠔꠦ ꠅꠃ ꠛꠦꠐꠣ-ꠛꠦꠐꠤ ꠖꠥꠁꠅ ꠎꠘꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","ꠎꠦ ꠝꠣꠘꠡꠦ ꠔꠣꠞ ꠢꠣꠔꠘ ꠝꠣʼꠞ ꠟꠉꠦ ꠎꠤꠘꠣ ꠇꠞꠦ, ꠢꠦ ꠔꠣꠞ ꠛꠣꠚꠞꠦ ꠛꠦꠁꠎ꠆ꠎꠔ ꠇꠞꠦ। ꠄꠞꠟꠣꠉꠤ ꠔꠣꠞꠦ ꠀꠞ ꠢꠣꠔꠘ ꠝꠣʼꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠛꠣꠄ। ꠔꠣꠞꠣꠞ ꠝꠃꠔꠞ ꠟꠣꠉꠤ ꠔ ꠔꠣꠞꠣꠃ ꠖꠣꠄꠁ। ");
INSERT INTO syls_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠀꠙꠘ ꠙꠥꠀꠞ ꠛꠃꠞ ꠟꠉꠦ ꠎꠤꠘꠣ ꠇꠞꠦ, ꠔꠦ ꠔꠣꠞꠣ ꠖꠥꠁꠅ ꠎꠘꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠛꠣꠄ। ꠔꠣꠞꠣ ꠝꠣꠘꠛ ꠡꠝꠣꠎꠞ ꠃꠟꠐꠣ ꠌꠟꠣꠄ, ꠔꠣꠞꠣꠞ ꠝꠃꠔꠞ ꠟꠣꠉꠤ ꠘꠤꠎꠦꠃ ꠖꠣꠄꠁ। ");
INSERT INTO syls_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","ꠇꠥꠘꠥ ꠛꠦꠐꠣꠄ ꠎꠥꠖꠤ ꠀꠞꠇ ꠛꠦꠐꠣꠞ ꠟꠉꠦ ꠎꠤꠘꠣ-ꠙꠥꠋꠉꠣꠝꠤ ꠇꠞꠦ, ꠔꠦ ꠔꠣꠞꠣ ꠖꠥꠁꠅ ꠎꠘꠦꠃ ꠛꠠ ꠈꠛꠤꠍꠤ ꠇꠞꠍꠦ, ꠄꠞꠟꠣꠉꠤ ꠖꠥꠁꠅ ꠎꠘꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠤꠛꠣꠄ, ꠔꠣꠞꠣꠞ ꠝꠃꠔꠞ ꠟꠣꠉꠤ ꠔꠣꠞꠣꠃ ꠖꠣꠄꠁ। ");
INSERT INTO syls_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ꠇꠥꠘꠥ ꠛꠦꠐꠣꠄ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠙꠥꠠꠤꠞꠦ ꠀꠞ ꠔꠣꠁꠞ ꠝꠣʼꠞꠦꠅ ꠢꠣꠋꠉꠣ ꠇꠞꠦ, ꠔꠦ ꠅꠃ ꠛꠦꠐꠣ ꠀꠞ ꠝꠣ-ꠙꠥꠠꠤ ꠔꠤꠘꠅ ꠎꠘꠞꠦ ꠀꠉꠥꠁꠘꠖꠤ ꠎꠣꠟꠣꠁꠀ ꠝꠣꠞꠤꠟꠤꠛꠣꠄ, ꠎꠣꠔꠦ ꠁꠟꠣ ꠘꠣꠚꠞꠝꠣꠘꠤ ꠇꠣꠝ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠎꠦ ꠘꠣ ꠊꠐꠦ। ");
INSERT INTO syls_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","ꠇꠥꠘꠥ ꠙꠡꠥꠞ ꠟꠉꠦ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠤꠘꠣ ꠇꠞꠟꠦ, ꠢꠃ ꠝꠣꠘꠥꠡ ꠀꠞ ꠙꠡꠥ ꠖꠥꠁꠅꠉꠥꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","ꠇꠥꠘꠥ ꠛꠦꠐꠤꠄ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠙꠡꠥꠞ ꠟꠉꠦ ꠎꠤꠘꠣ ꠇꠞꠣꠔ ꠎꠣꠄ, ꠔꠦ ꠢꠃ ꠛꠦꠐꠤ ꠀꠞ ꠙꠡꠥꠞꠦꠅ ꠎꠣꠘꠦ ꠝꠣꠞꠛꠣꠄ। ꠔꠣꠞꠣꠞ ꠝꠃꠔꠞ ꠟꠣꠉꠤ ꠔꠣꠞꠣꠃ ꠖꠣꠄꠁ। ");
INSERT INTO syls_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ꠇꠥꠘꠥ ꠛꠦꠐꠣꠄ ꠎꠥꠖꠤ ꠔꠣꠞ ꠀꠙꠘ ꠛꠁꠘ, ꠢꠣꠔꠘ ꠝꠣ ꠛꠣ ꠢꠣꠔꠘ ꠛꠣꠚꠞ ꠊꠞꠞ ꠛꠁꠘꠞ ꠟꠉꠦ ꠡꠞꠤꠟꠤ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠦ, ꠁꠔꠣ ꠔ ꠡꠞꠝꠞ ꠇꠣꠝ। ꠔꠣꠞꠣꠞꠦ ꠡꠝꠣꠎ ꠕꠣꠇꠤ ꠢꠞꠣꠁꠟꠤꠛꠣꠄ, ꠀꠞ ꠢꠦ ꠡꠣꠎꠣ ꠙꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","ꠇꠥꠘꠥ ꠛꠦꠐꠤ ꠝꠣꠘꠡꠞ ꠝꠣꠡꠤꠇ ꠛꠦꠝꠣꠞꠞ ꠡꠝꠄ ꠔꠣꠁꠞ ꠟꠉꠦ ꠎꠦ ꠛꠦꠐꠣꠄ ꠡꠞꠤꠟꠤ ꠝꠤꠟꠣ-ꠝꠤꠡꠣ ꠇꠞꠦ, ꠁ ꠛꠦꠐꠤꠄ ꠔ ꠔꠣꠁꠞ ꠝꠣꠡꠤꠇ ꠇꠣꠟꠞ ꠁꠎ꠆ꠎꠔ ꠖꠦꠄ ꠘꠣ, ꠀꠞ ꠁ ꠛꠦꠐꠣꠄꠅ ꠔꠣꠁꠞ ꠝꠣꠡꠤꠇꠞꠦ ꠖꠣꠝ ꠖꠦꠄ ꠘꠣ। ꠄꠞꠟꠣꠉꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠡꠝꠣꠎ ꠕꠣꠇꠤ ꠁ ꠖꠥꠁꠅꠉꠥꠞ ꠘꠣꠝ ꠝꠤꠐꠣꠁꠟꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","ꠇꠥꠘꠥ ꠛꠦꠐꠣꠄ ꠎꠣꠘꠥ ꠔꠣꠞ ꠈꠣꠟꠣ ꠛꠣ ꠚꠥꠚꠥꠞ ꠟꠉꠦ ꠎꠤꠘꠣ ꠘꠣ ꠇꠞꠦ, ꠀꠞꠘꠣꠄ ꠀꠙꠘ ꠟꠃꠞ ꠇꠥꠐꠥꠝꠞꠦ ꠛꠦꠁꠎ꠆ꠎꠔꠤ ꠇꠞꠣꠄ ꠔꠣꠞꠣ ꠖꠥꠁꠅ ꠎꠘꠦ ꠡꠣꠎꠣ ꠙꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","ꠇꠦꠃ ꠎꠥꠖꠤ ꠔꠣꠞ ꠌꠣꠌꠤ ꠛꠣ ꠝꠣꠝꠤꠞ ꠟꠉꠦ ꠎꠤꠘꠣ ꠇꠞꠦ, ꠔꠦ ꠔꠣꠞꠣ ꠖꠥꠁꠅ ꠎꠘꠦ ꠡꠣꠎꠣ ꠙꠣꠁꠛ, ꠘꠤꠀꠅꠟꠣꠖꠤ ꠢꠣꠟꠔꠦ ꠔꠣꠞꠣꠞ ꠝꠞꠘ ꠅꠁꠛ, ꠢꠦ ꠔ ꠔꠣꠞ ꠌꠣꠌꠣ ꠛꠣ ꠝꠣꠝꠣꠞꠦ ꠛꠦꠁꠎ꠆ꠎꠔ ꠇꠞꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","ꠜꠣꠁ ꠎꠤꠘ꠆ꠖꠣ ꠕꠣꠇꠔꠦ ꠎꠥꠖꠤ ꠀꠞꠇ ꠜꠣꠁꠄ ꠔꠣꠞ ꠜꠣꠛꠤꠞꠦ ꠢꠣꠋꠉꠣ ꠇꠞꠦ, ꠔꠦ ꠔꠣꠞ ꠜꠣꠁꠞꠦ ꠛꠦꠁꠎ꠆ꠎꠔ ꠇꠞꠣꠄ, ꠁꠐꠣ ꠛꠠ ꠘꠣꠚꠞꠝꠣꠘꠤ। ꠔꠣꠞꠣ ꠇꠥꠘꠥ ꠀꠅꠟꠣꠖ ꠙꠣꠁꠔꠣ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ꠔꠥꠝꠞꠣ ꠛꠡꠔ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦ ꠖꠦꠡꠅ ꠘꠤꠀꠞ, ꠢꠃ ꠖꠦꠡꠞ ꠝꠣꠐꠤꠄ ꠎꠣꠘꠥ ꠔꠥꠝꠞꠣꠞꠦ ꠛꠝꠤ ꠇꠞꠤꠀ ꠘꠣ ꠚꠣꠟꠣꠄ। ꠄꠞꠟꠣꠉꠤ ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠛꠣꠔꠣꠁꠟ ꠢꠇꠟ ꠡꠞꠤꠅꠔ ꠀꠞ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠅꠇꠟ ꠀꠝꠟ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","ꠔꠥꠝꠞꠣꠞ ꠍꠣꠝꠘꠦ ꠕꠣꠇꠤ ꠀꠝꠤ ꠎꠦꠔꠣ ꠎꠣꠔꠤ ꠅꠇꠟꠞꠦ ꠈꠦꠖꠣꠁ ꠖꠤꠞꠣꠝ, ꠁꠔꠣꠞ ꠌꠣꠟ-ꠌꠟꠘꠦ ꠔꠥꠝꠞꠣ ꠌꠟꠤꠅ ꠘꠣ। ꠔꠣꠞꠣꠞ ꠢꠃ ꠌꠣꠟ-ꠌꠟꠘꠞ ꠟꠣꠉꠤꠃ ꠀꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠟꠣꠘ꠆ꠘꠔ ꠖꠤꠍꠤ, ");
INSERT INTO syls_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","ꠄꠞꠟꠣꠉꠤꠃ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠅꠀꠖꠣ ꠖꠤꠍꠟꠣꠝ ꠔꠣꠞꠣꠞ ꠖꠦꠡꠞꠦ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠖꠈꠟꠦ ꠖꠤꠝꠥ, ꠔꠣꠞꠣꠞ ꠢꠃ ꠖꠥꠗ ꠀꠞ ꠝꠃꠞ ꠜꠣꠘ꠆ꠒꠣꠞ ꠀꠟꠣ ꠖꠦꠡ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠣꠘ ꠇꠞꠝꠥ। ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ, ꠎꠉꠔꠞ ꠢꠇꠟ ꠎꠣꠔꠤ ꠕꠣꠇꠤ ꠀꠝꠤꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠀꠟꠣꠖꠣ ꠇꠞꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","ꠄꠞꠟꠣꠉꠤ ꠔꠥꠝꠞꠣ ꠢꠣꠟꠣꠟ ꠀꠞ ꠢꠣꠞꠣꠝ ꠙꠡꠥꠁꠘ꠆ꠔꠞ ꠝꠣꠎꠦ ꠔꠚꠣꠔ ꠞꠣꠈꠤꠅ, ꠢꠣꠟꠣꠟ ꠀꠞ ꠢꠣꠞꠣꠝ ꠙꠣꠈꠤꠘ꠆ꠔꠞ ꠝꠣꠎꠦ ꠔꠚꠣꠔ ꠞꠣꠈꠤꠅ। ꠙꠡꠥ-ꠙꠣꠈꠤ ꠀꠞ ꠝꠣꠐꠤꠞ ꠃꠙꠞꠦ ꠌꠟꠞꠣ ꠢꠥꠞꠥ ꠢꠥꠞꠥ ꠎꠣꠘꠖꠣꠞꠞ ꠝꠣꠎꠦ ꠎꠦꠔꠣꠞꠦ ꠀꠝꠤ ꠢꠣꠞꠣꠝ ꠇꠁꠍꠤ, ꠅꠔꠣ ꠖꠤꠀ ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠡꠞꠤꠟꠞꠦ ꠘꠣꠙꠣꠇ ꠛꠣꠘꠣꠁꠀ ꠟꠣꠘ꠆ꠘꠔꠤ ꠛꠘꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","ꠀꠝꠤ ꠝꠣꠛꠥꠖ ꠔ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ, ꠄꠞꠟꠣꠉꠤ ꠔꠥꠝꠞꠣꠅ ꠙꠛꠤꠔ꠆ꠞ ꠅꠁꠔꠦ ꠅꠁꠛ। ꠀꠝꠣꠞ ꠀꠙꠘ ꠙ꠆ꠞꠎꠣ ꠅꠀꠞ ꠟꠣꠉꠤ ꠀꠝꠤꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠉꠔꠞ ꠢꠇꠟ ꠎꠣꠔꠤ ꠕꠣꠇꠤ ꠛꠣꠍꠤꠀ ꠀꠟꠉ ꠇꠞꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ꠎꠦꠔꠣ ꠛꠦꠐꠣ ꠛꠣ ꠛꠦꠐꠤꠘ꠆ꠔꠦ ꠎꠤꠘ-ꠜꠥꠔ ꠡꠣꠗꠘ, ꠉꠘꠇ ꠛꠣ ꠎꠣꠖꠥ-ꠐꠥꠘꠣꠞ ꠇꠣꠝ ꠇꠞꠦ, ꠁꠔꠣꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠤꠛꠣꠄ। ꠙꠣꠔ꠆ꠔꠞꠖꠤ ꠁꠐꠣꠁꠀ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠤꠛꠣꠄ, ꠔꠣꠞꠣꠞ ꠝꠃꠔꠞ ꠟꠣꠉꠤ ꠔꠣꠞꠣꠃ ꠖꠣꠄꠁ।” ");
INSERT INTO syls_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠢꠣꠞꠥꠘꠞ ꠛꠋꠡꠞ ꠁꠝꠣꠝ ꠅꠇꠟꠞꠦ ꠇꠁꠅ, ꠔꠣꠞꠣꠞ ꠇꠥꠘꠥ ꠇꠥꠐꠥꠝ-ꠈꠦꠡꠞ ꠝꠃꠔꠞ ꠇꠣꠞꠘꠦ ꠝꠣꠔ꠆ꠔꠝ ꠇꠞꠤꠀ ꠔꠣꠞꠣ ꠎꠣꠘꠥ ꠘꠤꠎꠞꠦ ꠘꠣꠙꠣꠇ ꠘꠣ ꠛꠣꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","ꠈꠣꠟꠤ ꠔꠣꠞꠣꠞ ꠘꠤꠎꠞ ꠝꠣ-ꠛꠣꠚ, ꠙꠥꠀ-ꠙꠥꠠꠤ ꠛꠣ ꠀꠙꠘ ꠜꠣꠁ ꠝꠣꠞꠣ ꠉꠦꠟꠦ ꠔꠣꠞꠣ ꠘꠤꠎꠞꠦ ꠘꠣꠙꠣꠇ ꠛꠣꠘꠣꠘꠤ ꠎꠣꠁꠎ ꠀꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ꠀꠞ ꠜꠣꠁꠞ ꠊꠞꠅ ꠞꠅꠞꠣ ꠀꠛꠤꠀꠔꠤ ꠇꠥꠘꠥ ꠛꠁꠘ ꠝꠣꠞꠣ ꠉꠦꠟꠦ ꠔꠣꠁꠞꠦ ꠖꠣꠚꠘ-ꠇꠣꠚꠘꠞ ꠟꠣꠉꠤ ꠔꠣꠁꠞ ꠜꠣꠁ ꠘꠣꠙꠣꠇ ꠛꠘꠣ ꠎꠣꠁꠎ। ");
INSERT INTO syls_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","ꠅꠁꠟꠦ ꠢꠃꠞ ꠛꠣꠠꠤꠞ ꠇꠥꠘꠥ ꠇꠥꠐꠥꠝ-ꠈꠦꠡꠞ ꠝꠃꠔꠞ ꠖꠣꠄ ꠇꠥꠘꠥ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠘꠤꠎꠞ ꠙꠛꠤꠔ꠆ꠞ ꠢꠣꠟꠔ ꠕꠣꠇꠤ ꠘꠣꠙꠣꠇ ꠛꠘꠣ ꠎꠣꠁꠎ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ꠁꠝꠣꠝ ꠍꠣꠛ ꠅꠇꠟꠞ ꠝꠣꠕꠣꠞ ꠌꠥꠟ ꠇꠣꠝꠣꠘꠤ, ꠖꠣꠠꠤꠞ ꠀꠉꠣ ꠍꠣꠐꠣ, ꠛꠣ ꠘꠤꠎꠞ ꠡꠞꠤꠟꠅ ꠇꠥꠘꠥꠎꠣꠔ ꠇꠣꠐꠣ-ꠌꠤꠞꠣ ꠇꠞꠣ ꠎꠣꠁꠎ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","ꠔꠣꠞꠣ ꠎꠣꠘꠥ ꠀꠙꠘ ꠀꠟ꠆ꠟꠣꠞ ꠙꠛꠤꠔ꠆ꠞ ꠘꠣꠝꠞꠦ ꠅꠡꠝ꠆ꠝꠣꠘ ꠘꠣ ꠇꠞꠂꠘ, ꠀꠞ ꠙꠣꠇ-ꠙꠣꠇꠤꠎꠣ ꠞꠁꠀ ꠎꠤꠘ꠆ꠖꠦꠉꠤ ꠇꠣꠐꠣꠁꠘ। ꠅꠈꠣꠘ ꠝꠘꠅ ꠞꠣꠈꠂꠘ ꠎꠦꠘ, ꠅꠃ ꠁꠝꠣꠝ ꠅꠇꠟꠦꠃ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠍꠖꠉꠣ ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠅꠇꠟ ꠀꠖꠣꠄ ꠇꠞꠂꠘ, ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠝꠣꠟ ꠔ ꠘꠤꠎꠞ ꠀꠟ꠆ꠟꠣꠞ ꠖꠞꠛꠣꠞꠞ ꠞꠤꠎꠦꠇ। ");
INSERT INTO syls_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","ꠁꠝꠣꠝ ꠅꠇꠟꠦ ꠇꠥꠘꠥ ꠛꠖꠝꠣꠁꠡ, ꠍꠤꠟꠣꠘ ꠛꠣ ꠔꠣꠟꠣꠇ ꠙꠣꠅꠀ ꠇꠥꠘꠥ ꠛꠦꠐꠤꠞꠦ ꠛꠤꠀ ꠇꠞꠣ ꠎꠣꠁꠎ ꠘꠣꠄ। ꠇꠣꠞꠘ ꠔꠣꠞꠣꠞ ꠀꠙꠘ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠦ ꠔꠣꠞꠣ ꠙꠛꠤꠔ꠆ꠞ। ");
INSERT INTO syls_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","ꠅ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ, ꠔꠥꠝꠞꠣ ꠁꠝꠣꠝ ꠍꠣꠛ ꠅꠇꠟꠞꠦ ꠢꠣꠝꠦꠡꠣ ꠙꠛꠤꠔ꠆ꠞ ꠢꠤꠡꠣꠛꠦ ꠝꠣꠘꠤꠅ, ꠔꠣꠞꠣꠃ ꠔ ꠔꠥꠝꠞꠣꠞ ꠀꠟ꠆ꠟꠣꠞ ꠖꠞꠛꠣꠞꠅ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠈꠣꠘꠤ ꠡꠙꠤꠀ ꠖꠦꠁꠘ। ꠄꠞꠟꠣꠉꠤꠃ ꠔꠣꠞꠣꠞꠦ ꠙꠛꠤꠔ꠆ꠞ ꠇꠁꠀ ꠝꠣꠘꠤꠅ, ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠀꠝꠤꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠙꠛꠤꠔ꠆ꠞ ꠛꠣꠘꠣꠁꠍꠤ, ꠀꠞ ꠀꠝꠤ ꠘꠤꠎꠦ ꠔ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ। ");
INSERT INTO syls_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","ꠇꠥꠘꠥ ꠁꠝꠣꠝꠞ ꠙꠥꠠꠤ ꠎꠥꠖꠤ ꠍꠤꠟꠣꠘꠤ-ꠛꠖꠝꠣꠁꠡꠤꠞ ꠙꠕꠦ ꠉꠤꠀ ꠘꠣꠙꠣꠇ ꠛꠘꠤꠎꠣꠄ, ꠔꠦ ꠔꠣꠁꠞ ꠛꠣꠚꠞꠦꠅ ꠔꠣꠁ ꠛꠦꠁꠎ꠆ꠎꠔ ꠇꠞꠤꠟꠣꠄ। ꠄꠞꠟꠣꠉꠤ ꠔꠣꠁꠞꠦ ꠀꠉꠥꠁꠘꠖꠤ ꠎꠣꠟꠣꠁꠀ ꠝꠣꠞꠤꠟꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ꠀꠞ ꠁꠝꠣꠝ ꠙꠞꠤꠛꠣꠞꠞ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞ ꠝꠣꠎꠦ ꠢꠇꠟ ꠛꠠ ꠎꠦꠁꠘ, ꠄꠁꠘꠃ ꠔ ꠙꠞꠗꠣꠘ ꠁꠝꠣꠝ, ꠄꠘ ꠝꠣꠕꠣꠔ ꠈꠦꠟꠣꠚꠔꠤ ꠡꠝꠎꠤꠛꠣꠞ ꠔꠦꠟ ꠓꠣꠟꠣ ꠅꠁꠍꠦ, ꠈꠦꠟꠣꠚꠔꠤ ꠡꠝꠎꠤꠀ ꠔꠣꠁꠘ ꠙꠞꠗꠣꠘ ꠁꠝꠣꠝꠞ ꠙꠛꠤꠔ꠆ꠞ ꠟꠦꠛꠣꠍ ꠚꠤꠘ꠆ꠖꠤꠛꠣꠞ ꠖꠣꠄꠁꠔ꠆ꠔ ꠙꠣꠁꠍꠂꠘ। ꠄꠞꠟꠣꠉꠤ ꠇꠥꠘꠥ ꠝꠥꠞ꠆ꠖꠣꠞ ꠟꠣꠉꠤꠀ ꠇꠣꠘ꠆ꠖꠘ-ꠀꠢꠣꠎꠣꠞꠤꠞ ꠘꠤꠅꠔꠦ ꠔꠣꠘ ꠝꠣꠕꠣꠞ ꠙꠣꠃꠉꠠꠤ ꠈꠥꠟꠤꠀ ꠌꠥꠟ ꠀꠃꠟꠣ-ꠎꠣꠃꠟꠣ ꠇꠞꠣ, ꠛꠣ ꠔꠣꠘ ꠚꠤꠘ꠆ꠘꠞ ꠟꠦꠛꠣꠍ ꠍꠤꠠꠣꠅ ꠎꠣꠁꠎ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","ꠄꠁꠘ ꠇꠥꠘꠥ ꠝꠞꠣ ꠟꠣꠡꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠎꠣꠅꠀ ꠎꠣꠁꠎ ꠘꠣꠄ। ꠘꠤꠎꠞ ꠝꠣ-ꠛꠣꠚ ꠝꠣꠞꠣ ꠉꠦꠟꠦꠅ ꠄꠁꠘ ꠘꠤꠎꠞꠦ ꠘꠣꠙꠣꠇ ꠛꠣꠘꠣꠘꠤ ꠎꠣꠁꠎ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","ꠎꠦꠇꠥꠘꠥ ꠝꠥꠞ꠆ꠖꠣꠞ ꠟꠣꠉꠤ ꠔꠣꠁꠘ ꠀꠟ꠆ꠟꠣꠞ ꠙꠛꠤꠔ꠆ꠞ ꠇꠣꠛꠣ ꠊꠞ ꠍꠣꠠꠤꠀ ꠇꠥꠘꠥꠈꠣꠘꠅ ꠉꠤꠀ ꠀꠟ꠆ꠟꠣꠞ ꠅꠃ ꠊꠞꠞꠦ ꠘꠣꠙꠣꠇ ꠛꠣꠘꠣꠘꠤ ꠔꠣꠘ ꠟꠣꠉꠤ ꠢꠣꠞꠣꠝ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠔꠣꠘ ꠀꠙꠘ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠞ ꠈꠦꠟꠣꠚꠔꠤ ꠡꠝꠎꠤꠛꠣꠞ ꠔꠦꠟ ꠓꠣꠟꠤꠀ ꠔꠣꠘꠞꠦ ꠙꠛꠤꠔ꠆ꠞ ꠛꠣꠘꠣꠁꠟ ꠅꠁꠍꠦ। ꠀꠝꠤꠃ ꠔ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ꠇꠥꠘꠥ ꠀꠛꠤꠀꠔꠤ ꠡꠔꠤ ꠇꠁꠘꠣꠞꠦ ꠡꠣꠖꠤ ꠇꠞꠣ ꠔꠣꠘ ꠟꠣꠉꠤ ꠎꠣꠁꠎ ꠀꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","ꠅꠁꠟꠦ ꠇꠥꠘꠥ ꠠꠣꠠꠤ ꠛꠦꠐꠤ, ꠛꠖꠝꠣꠁꠡ-ꠍꠤꠟꠣꠘ ꠛꠦꠐꠤ ꠛꠣ ꠔꠣꠟꠣꠇ ꠙꠣꠅꠀ ꠇꠥꠘꠥ ꠛꠦꠐꠤꠞꠦ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠡꠣꠖꠤ ꠇꠞꠣ ꠎꠣꠁꠎ ꠘꠣꠄ। ꠈꠣꠟꠤ ꠘꠤꠎꠞ ꠉꠥꠡ꠆ꠐꠤꠞ ꠇꠥꠘꠥ ꠀꠛꠤꠀꠔꠤ ꠡꠔꠤ ꠇꠁꠘꠣꠞꠦ ꠡꠣꠖꠤ ꠇꠞꠣ ꠔꠣꠘ ꠟꠣꠉꠤ ꠎꠣꠁꠎ। ");
INSERT INTO syls_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ꠀꠞꠘꠣꠄ ꠔꠣꠘ ꠇꠣꠞꠘꠦ ꠔꠣꠘ ꠘꠤꠎꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠎꠦ ꠔꠣꠘ ꠀꠅꠟꠣꠖ ꠅꠇꠟ ꠙꠛꠤꠔ꠆ꠞ ꠢꠣꠟꠔ ꠕꠣꠇꠤ ꠘꠣꠙꠣꠇ ꠛꠘꠛ। ꠀꠝꠤꠃ ꠔ ꠝꠣꠛꠥꠖ, ꠀꠝꠤꠃ ꠔꠣꠘꠞꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠛꠣꠘꠣꠁꠍꠤ।” ");
INSERT INTO syls_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠀꠞꠅ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“ꠔꠥꠝꠤ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠔꠣꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠎꠞ ꠡꠞꠤꠟꠞ ꠈꠥꠔ ꠀꠟꠣ ꠇꠥꠘꠥ ꠎꠘꠦꠃ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ, ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠎꠣꠅꠀ ꠘꠤꠡꠦꠗ। ");
INSERT INTO syls_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","ꠎꠦ ꠎꠘꠞ ꠡꠞꠤꠟꠅ ꠈꠥꠔ ꠀꠍꠦ, ꠝꠣꠘꠤ ꠀꠘ꠆ꠖꠣ, ꠟꠦꠋꠠꠣ, ꠘꠣꠇ-ꠇꠣꠐꠣ, ꠀꠔ-ꠙꠣꠅ ꠘꠤꠅꠝꠞ ꠛꠦꠡꠤ ꠟꠣꠝ꠆ꠛꠣ-ꠛꠣꠐ꠆ꠐꠤ ꠛꠣ ꠀꠋꠉꠥꠁꠟ ꠇꠝ-ꠛꠦꠡꠤ, ");
INSERT INTO syls_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ꠀꠔ ꠛꠣ ꠙꠣꠅ ꠜꠣꠋꠉꠣ, ");
INSERT INTO syls_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ꠙꠤꠑ ꠉꠥꠎꠣ, ꠛꠣꠐ꠆ꠐꠤ ꠜꠦꠋꠉꠣꠁ ꠝꠣꠘꠥꠡ, ꠌꠃꠈꠞ ꠛꠦꠝꠣꠞꠤ, ꠖꠣꠃꠖ-ꠈꠣꠃꠎꠟꠤ, ꠙꠌꠣ-ꠊꠣ ꠛꠦꠝꠣꠞꠤ ꠛꠣ ꠅꠘ꠆ꠒꠇꠥꠡ ꠘꠡ꠆ꠐ, ꠁꠟꠣ ꠈꠥꠔ ꠀꠟꠣ ꠇꠥꠘꠥ ꠝꠣꠘꠥꠡ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠎꠣꠅꠀ ꠎꠣꠁꠎ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠛꠋꠡꠞ ꠡꠞꠤꠟꠞ ꠈꠥꠔ ꠀꠟꠣ ꠇꠥꠘꠥ ꠎꠘꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠣ ꠘꠤꠡꠦꠗ। ꠔꠣꠞ ꠉꠔꠞꠅ ꠈꠥꠔ ꠕꠣꠇꠣꠄ ꠢꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠉꠤꠀ ꠀꠝꠣꠞ ꠘꠣꠝꠞ ꠈꠣꠘꠤꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅꠀ ꠎꠣꠁꠎ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","ꠅꠁꠟꠦ ꠅꠃ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠈꠣꠘꠤ ꠈꠣꠅꠀ ꠔꠣꠞ ꠟꠣꠉꠤ ꠎꠣꠁꠎ, ꠁꠔꠣ ꠙꠛꠤꠔ꠆ꠞ ꠛꠣ ꠈꠣꠍ-ꠙꠛꠤꠔ꠆ꠞ ꠅꠁꠟꠦꠅ ꠎꠣꠁꠎ ꠀꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","ꠔꠣꠞ ꠡꠞꠤꠟꠅ ꠈꠥꠔ ꠕꠣꠇꠣꠄ ꠢꠦ ꠇꠣꠛꠣ ꠊꠞꠞ ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚꠞ ꠙꠞ꠆ꠖꠣꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠛꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠎꠣꠅꠀ ꠘꠤꠡꠦꠗ, ꠢꠦ ꠎꠣꠘꠥ ꠀꠝꠣꠞ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠎꠣꠉꠣ ꠅꠇꠟꠞꠦ ꠘꠣꠙꠣꠇ ꠘꠣ ꠛꠣꠘꠣꠄ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠀꠝꠤꠃ ꠝꠣꠛꠥꠖ, ꠀꠞ ꠀꠝꠤꠃ ꠅꠃ ꠎꠣꠉꠣꠁꠘ꠆ꠔꠞꠦ ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠤ।” ");
INSERT INTO syls_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","ꠛꠣꠖꠦ ꠝꠥꠍꠣꠄ ꠉꠤꠀ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘ, ꠔꠣꠘ ꠙꠥꠀꠂꠘ ꠀꠞ ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“ꠔꠥꠝꠤ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠇꠅ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠀꠝꠣꠞ ꠘꠣꠝꠦ ꠟꠤꠟ꠆ꠟꠣ ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠞ ꠘꠤꠅꠔꠦ ꠎꠔꠔꠣ ꠀꠘꠂꠘ, ꠁꠔꠣ ꠔ ꠙꠛꠤꠔ꠆ꠞ। ꠄꠞꠟꠣꠉꠤ ꠅꠔꠣ ꠢꠇ꠆ꠇꠟꠔꠣꠞꠦ ꠁꠝꠣꠝ ꠅꠇꠟꠦ ꠁꠎ꠆ꠎꠔ-ꠔꠣꠎꠤꠝ ꠇꠞꠣ ꠎꠞꠥꠞ। ꠁ ꠛꠦꠙꠣꠞꠦ ꠔꠣꠞꠣ ꠎꠣꠘꠥ ꠀꠝꠣꠞ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠘꠣꠝꠞꠦ ꠅꠡꠝ꠆ꠝꠣꠘ ꠘꠣ ꠇꠞꠦ। ꠀꠝꠤꠃ ꠔ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“ꠔꠥꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠔꠣꠞꠣꠞ ꠀꠅꠟꠣꠖꠞ ꠝꠣꠎꠞ ꠇꠦꠃ ꠎꠥꠖꠤ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠇꠥꠘꠥ ꠎꠤꠘꠤꠡꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠎꠣꠄ, ꠔꠦ ꠔꠣꠞꠦ ꠀꠝꠣꠞ ꠍꠣꠝꠘ ꠕꠣꠇꠤ ꠢꠞꠣꠁꠟꠤꠛꠣꠄ। ꠀꠝꠤꠃ ꠔ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","ꠢꠣꠞꠥꠘꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠞ ꠝꠣꠎꠦ ꠇꠦꠃ ꠎꠥꠖꠤ ꠙꠌꠣ-ꠇꠥꠡ꠆ꠑ ꠛꠦꠝꠣꠞꠤ ꠛꠣ ꠗꠣꠔꠥ ꠎꠣꠅꠀ ꠛꠦꠝꠣꠞꠤ ꠅꠄ, ꠔꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠘꠣ ꠅꠀ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠦ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠇꠥꠘꠥꠔꠣ ꠈꠣꠅꠀ ꠘꠣꠎꠣꠁꠎ। ꠀꠞ ꠝꠞꠣ ꠟꠣꠡꠞꠦ ꠛꠣ ꠅꠃ ꠟꠣꠡꠞ ꠟꠣꠉꠤ ꠎꠦꠔꠣ ꠇꠣꠝꠅ ꠟꠣꠉꠣꠁꠟ ꠅꠁꠍꠦ ꠁꠔꠣ ꠇꠥꠘꠥꠔꠣ ꠍꠁꠀ ꠎꠥꠖꠤ ꠇꠦꠃ ꠘꠣꠙꠣꠇ ꠛꠘꠦ, ꠛꠣ ꠇꠦꠃꠞꠞ ꠎꠃꠛꠘꠞ ꠙꠣꠘꠤ ꠛꠣꠞ ꠅꠄ, ");
INSERT INTO syls_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ꠀꠞ ꠎꠦ ꠎꠘ ꠇꠥꠘꠥꠎꠣꠔ ꠝꠣꠐꠤꠔ ꠌꠟꠞꠣ ꠢꠥꠞꠥ-ꠝꠥꠞꠥ ꠘꠣꠙꠣꠇ ꠎꠣꠘꠖꠣꠞ ꠛꠣ ꠎꠦꠇꠥꠘꠥ ꠇꠣꠞꠘꠦ ꠘꠣꠙꠣꠇ ꠅꠀ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠞꠦ ꠍꠁꠀ ꠢꠦ ꠘꠤꠎꠞꠦ ꠘꠣꠙꠣꠇ ꠛꠣꠘꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ꠔꠦ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠦ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦꠃ ꠞꠁꠛ, ꠀꠞ ꠙꠣꠘꠤꠖꠤ ꠘꠣꠁꠀ ꠢꠣꠞꠤ ꠙꠣꠇ-ꠍꠣꠚ ꠘꠣ ꠅꠀ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠇꠥꠘꠥ ꠙꠛꠤꠔ꠆ꠞ ꠎꠤꠘꠤꠡ ꠈꠣꠅꠀ ꠔꠣꠞ ꠟꠣꠉꠤ ꠢꠣꠞꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","ꠛꠣꠖꠦ ꠡꠥꠞꠥꠎ ꠒꠥꠛꠤꠀ ꠢꠣꠞꠟꠦ ꠢꠦ ꠎꠦꠛꠟꠣ ꠙꠣꠇ-ꠍꠣꠚ ꠅꠁꠛ, ꠅꠃ ꠡꠝꠄ ꠢꠦ ꠁꠔꠣ ꠈꠣꠁꠔ ꠙꠣꠞꠛ। ꠁꠔꠣ ꠔ ꠔꠣꠞꠃ ꠈꠣꠘꠤ। ");
INSERT INTO syls_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","ꠁꠝꠣꠝꠦ ꠇꠥꠘꠥ ꠝꠞꠣ ꠙꠡꠥ ꠛꠣ ꠎꠋꠟꠤ ꠎꠣꠘꠥꠀꠞꠞ ꠕꠣꠛꠣꠄ ꠝꠣꠞꠣ ꠇꠥꠘꠥ ꠙꠡꠥꠞ ꠉꠥꠡ꠆ꠔ ꠈꠣꠁꠀ ꠘꠤꠎꠞꠦ ꠘꠣꠙꠣꠇ ꠛꠣꠘꠣꠁꠅ ꠘꠣ। ꠀꠝꠤꠃ ꠔ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ꠁꠝꠣꠝ ꠅꠇꠟꠞ ꠛꠦꠙꠣꠞꠦ ꠀꠝꠤ ꠎꠦꠔꠣ ꠀꠁꠘ-ꠇꠣꠘꠥꠘ ꠖꠤꠍꠤ, ꠁꠔꠣ ꠔꠣꠞꠣ ꠝꠣꠘꠤꠀ ꠌꠟꠃꠇ। ꠀꠞꠘꠣꠄ ꠖꠥꠡꠤ ꠛꠘꠛꠣꠄ ꠀꠞ ꠘꠣꠙꠣꠇꠤꠞ ꠖꠞꠥꠘ ꠔꠣꠞꠣꠞ ꠝꠞꠘ ꠅꠁꠛ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦꠃ ꠔꠣꠞꠣꠞꠦ ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠤ। ");
INSERT INTO syls_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ꠁꠝꠣꠝ ꠙꠞꠤꠛꠣꠞꠞ ꠝꠣꠘꠥꠡ ꠍꠣꠠꠣ ꠖꠥꠍꠞꠣ ꠇꠥꠘꠥ ꠎꠘꠦ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠛꠤꠔ꠆ꠞ ꠎꠤꠘꠤꠡ ꠈꠣꠅꠀ ꠘꠤꠡꠦꠗ। ꠁꠝꠣꠝꠞ ꠇꠥꠘꠥ ꠝꠦꠝꠣꠘ ꠛꠣ ꠇꠣꠝꠟꠣꠄꠅ ꠁꠔꠣ ꠈꠣꠅꠀ ꠢꠣꠞꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","ꠅꠁꠟꠦ ꠁꠝꠣꠝꠞ ꠈꠞꠤꠖꠣ ꠉꠥꠟꠣꠝꠦ ꠛꠣ ꠔꠣꠘ ꠛꠣꠠꠤꠔ ꠎꠘꠝꠤꠍꠦ ꠁꠟꠣꠈꠣꠘ ꠉꠥꠟꠣꠝꠦ ꠁꠔꠣ ꠈꠣꠅꠀ ꠎꠣꠁꠎ। ");
INSERT INTO syls_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","ꠁꠝꠣꠝꠞ ꠙꠥꠠꠤ ꠎꠥꠖꠤ ꠀꠞꠇ ꠁꠝꠣꠝ ꠍꠣꠠꠣ ꠛꠣꠁꠞꠣ ꠇꠥꠘꠥ ꠖꠣꠝꠣꠘ꠆ꠖꠞ ꠟꠉꠦ ꠛꠤꠀ-ꠡꠣꠖꠤ ꠅꠄ, ꠔꠦ ꠔꠣꠁꠅ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠅꠃ ꠙꠛꠤꠔ꠆ꠞ ꠎꠤꠘꠤꠡ ꠈꠣꠅꠀ ꠢꠣꠞꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","ꠅꠁꠟꠦ ꠁꠝꠣꠝꠞ ꠇꠥꠘꠥ ꠠꠣꠠꠤ ꠙꠥꠠꠤ ꠛꠣ ꠔꠣꠟꠣꠇ ꠙꠣꠅꠀ ꠘꠤꠀꠅꠟꠣꠖꠤ ꠇꠥꠘꠥ ꠙꠥꠠꠤ ꠎꠥꠖꠤ ꠛꠣꠚꠞ ꠛꠣꠠꠤꠔ ꠞꠁꠛꠣꠞ ꠟꠣꠉꠤ ꠢꠤꠞꠛꠣꠞ ꠀꠁꠅꠄ, ꠔꠦ ꠔꠣꠁ ꠔ ꠛꠣꠚꠞ ꠈꠣꠘꠤꠞ ꠅꠋꠡ ꠙꠣꠁꠛ। “ꠁꠝꠣꠝ ꠙꠞꠤꠛꠣꠞꠞ ꠛꠣꠁꠞꠣ ꠇꠥꠘꠥ ꠎꠘꠦ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠛꠤꠔ꠆ꠞ ꠇꠥꠘꠥ ꠈꠣꠘꠤ ꠈꠣꠅꠀ ꠎꠣꠁꠎ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","ꠇꠦꠃ ꠎꠥꠖꠤ ꠜꠥꠟ ꠇꠞꠤꠀ ꠁꠔꠣ ꠈꠣꠁꠟꠣꠄ, ꠔꠦ ꠁ ꠎꠘꠦ ꠁꠝꠣꠝꠞ ꠉꠦꠍꠦ ꠈꠦꠔꠤ-ꠙꠥꠞꠘ ꠖꠤꠔꠦ ꠅꠁꠛ। ꠅꠃ ꠈꠣꠘꠤꠞ ꠖꠣꠝꠞ ꠟꠉꠦ ꠀꠞꠅ ꠙꠣꠌ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ ꠖꠣꠝ ꠛꠦꠡꠤ ꠖꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠔꠣꠞꠣꠞ ꠎꠦ ꠎꠤꠘꠤꠡ ꠙꠛꠤꠔ꠆ꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠖꠣꠘ ꠇꠞꠂꠘ, ꠁꠝꠣꠝ ꠅꠇꠟꠦ ꠎꠣꠘꠥ ꠁꠔꠣꠞꠦ ꠅꠙꠛꠤꠔ꠆ꠞ ꠘꠣ ꠛꠣꠘꠣꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ꠔꠣꠞꠣ ꠛꠣꠁꠞꠣ ꠝꠣꠘꠡꠞꠦ ꠁꠔꠣ ꠈꠣꠁꠔꠦ ꠖꠤꠀ ꠝꠣꠘꠡꠞꠦ ꠖꠥꠡꠤ ꠛꠣꠘꠣꠁꠀ ꠈꠦꠔꠤ-ꠙꠥꠞꠘꠞ ꠖꠣꠠꠅ ꠎꠣꠘꠥ ꠘꠣ ꠚꠣꠟꠣꠁꠘ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦꠁ ꠔꠣꠞꠣꠞꠦ ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠤ।” ");
INSERT INTO syls_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“ꠔꠥꠝꠤ ꠉꠤꠀ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘ, ꠔꠣꠞ ꠙꠥꠀꠂꠘ ꠀꠞ ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠅ, ꠔꠥꠝꠞꠣꠞ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠛꠣ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠛꠡꠔ ꠇꠞꠞꠣ ꠜꠤꠘ-ꠖꠦꠡꠤ ꠇꠥꠘꠥ ꠎꠘꠦ ꠎꠥꠖꠤ ꠝꠣꠘ꠆ꠘꠔ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠛꠣ ꠘꠤꠎꠞ ꠈꠥꠡꠤꠄ ꠘꠚꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠞ ꠘꠤꠅꠔꠦ ꠇꠥꠘꠥꠔꠣ ꠟꠁꠀ ꠀꠄ, ");
INSERT INTO syls_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ꠔꠦ ꠁꠇꠐꠣ ꠅꠁꠔꠦ ꠅꠁꠛ ꠄꠉꠥ ꠘꠤꠈꠥꠔ ꠛꠤꠍꠣꠟ, ꠝꠦꠠꠣ ꠛꠣ ꠍꠣꠉꠟꠞ ꠙꠣꠑꠣ। ꠁꠟꠣ ꠘꠣ ꠅꠁꠟꠦ ꠔ ꠝꠣꠛꠥꠖꠦ ꠇꠛꠥꠟ ꠇꠞꠔꠣ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","ꠈꠥꠔ ꠀꠟꠣ ꠇꠥꠘꠥ ꠙꠡꠥꠖꠤ ꠎꠣꠘꠥ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠘꠣ ꠇꠞꠦ, ꠇꠞꠟꠦꠅ ꠔꠣꠞ ꠇꠥꠘꠥ ꠚꠣꠄꠖꠣ ꠅꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","ꠇꠥꠘꠥ ꠝꠣꠘ꠆ꠘꠔ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠛꠣ ꠘꠤꠎꠞ ꠈꠥꠡꠤꠄ ꠘꠚꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠇꠦꠃ ꠎꠥꠖꠤ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠔ ꠌꠣꠄ, ꠔꠦ ꠁꠔꠣꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠘꠤꠈꠥꠔ ꠉꠞꠥ, ꠝꠦꠠꠣ ꠛꠣ ꠍꠣꠉꠟ ꠀꠘꠔꠦ ꠅꠁꠛ। ꠉꠔꠞꠅ ꠈꠥꠔ ꠀꠟꠣ ꠇꠥꠘꠥ ꠙꠡꠥꠖꠤ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠟꠦ ꠁꠔꠣ ꠇꠛꠥꠟ ꠅꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠣꠘꠥ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠘꠤꠅꠔꠦ ꠀꠘ꠆ꠖꠣ, ꠟꠦꠋꠠꠣ, ꠇꠣꠐꠣ-ꠌꠤꠞꠣ, ꠇꠥꠘꠥ ꠅꠋꠉ ꠇꠣꠐꠣ, ꠙꠥꠎꠀꠟꠣ ꠊꠣ, ꠛꠣ ꠖꠣꠃꠖ-ꠈꠣꠃꠎꠟꠤ ꠇꠥꠘꠥ ꠙꠡꠥꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠘꠣ ꠀꠘꠦ, ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠅꠟꠣ ꠈꠥꠔ ꠀꠟꠣ ꠇꠥꠘꠥ ꠙꠡꠥꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠔꠥꠟꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","ꠔꠣ-ꠅ ꠙꠡꠥꠞ ꠇꠥꠘꠥ ꠅꠋꠉ ꠘꠤꠅꠝꠞ ꠛꠦꠡꠤ ꠟꠣꠝ꠆ꠛꠣ ꠛꠣ ꠛꠣꠐ꠆ꠐꠤ ꠕꠣꠇꠟꠦ, ꠅꠟꠣꠈꠣꠘ ꠙꠡꠥꠞꠦ ꠘꠤꠎꠞ ꠈꠥꠡꠤꠄ ꠘꠚꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠖꠤꠔꠣ ꠙꠣꠞꠛꠣ, ꠅꠁꠟꠦ ꠇꠥꠘꠥ ꠝꠣꠘ꠆ꠘꠔ ꠙꠥꠞꠘꠞ ꠟꠣꠉꠤ ꠁꠟꠣꠈꠣꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠛꠥꠟ ꠅꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","ꠇꠥꠘꠥ ꠙꠡꠥꠞ ꠅꠘ꠆ꠒꠇꠥꠡ ꠎꠥꠖꠤ ꠕꠦꠔꠟꠣ, ꠍꠦꠌꠣ, ꠇꠣꠐꠣ-ꠌꠤꠞꠣ ꠕꠣꠇꠦ, ꠔꠦ ꠁꠔꠣꠞꠦ ꠔꠥꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠅ ꠘꠣ, ꠘꠤꠎꠞ ꠖꠦꠡꠅ ꠉꠤꠀ ꠁꠟꠣ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","ꠜꠤꠘ ꠎꠣꠔꠤꠞ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠅꠟꠣꠈꠣꠘ ꠙꠡꠥ ꠀꠘꠤꠀ ꠔꠥꠝꠞꠣꠞ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠅ ꠘꠣ। ꠁꠔꠣꠞ ꠉꠔꠞꠅ ꠈꠥꠔ ꠕꠣꠇꠣꠄ ꠁꠔꠣꠖꠤ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠟꠦ ꠔꠥꠝꠞꠣꠞ ꠇꠥꠘꠥ ꠚꠣꠄꠖꠣ ꠅꠁꠔ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“ꠎꠘꠝꠞ ꠛꠣꠖ ꠕꠣꠇꠤ ꠡꠣꠔ ꠖꠤꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠉꠞꠥ ꠛꠣ ꠍꠣꠉꠟ ꠛꠣ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣꠞꠦ ꠔꠣꠞ ꠝꠣʼꠞ ꠟꠉꠦ ꠞꠁꠔꠦ ꠖꠤꠛꠣꠄ। ꠀꠐ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠕꠣꠇꠤ ꠁꠔꠣꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠖꠦꠅꠀ ꠎꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","ꠔꠣ-ꠅ ꠉꠣꠁ ꠀꠞ ꠔꠣꠁꠞ ꠛꠣꠍꠥꠞꠞꠦ, ꠝꠦꠠꠤ ꠛꠣ ꠍꠣꠉꠤ ꠀꠞ ꠔꠣꠁꠞ ꠛꠣꠁꠌ꠆ꠌꠣꠞꠦ, ꠄꠇꠁ ꠖꠤꠘꠦ ꠎꠛ ꠇꠞꠣ ꠢꠣꠞꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","ꠔꠥꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠇꠥꠘꠥ ꠡꠥꠇꠥꠞꠣꠘꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠔꠦ ꠌꠣꠁꠟꠦ, ꠁꠔꠣ ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠀꠖꠣꠄ ꠇꠞꠤꠅ ꠎꠦꠟꠣ ꠔꠣꠁꠘ ꠈꠥꠡꠤ ꠅꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","ꠇꠥꠞꠛꠣꠘꠤꠞ ꠉꠥꠡ꠆ꠔ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠖꠤꠘꠞ ꠝꠣꠎꠦ ꠈꠣꠁꠟꠤꠔꠦ ꠅꠁꠛ, ꠁꠔꠣ ꠛꠣꠖꠞ ꠖꠤꠘ ꠛꠤꠀꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠕꠅꠀ ꠢꠣꠞꠣꠝ। ꠀꠝꠤꠃ ꠔ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠘꠤꠅ ꠀꠞ ꠅꠃ ꠟꠣꠈꠣꠘ ꠌꠟꠤꠅ। ꠀꠝꠤꠃ ꠔ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠘꠣꠝꠞꠦ ꠅꠡꠝ꠆ꠝꠣꠘ ꠇꠞꠤꠅ ꠘꠣ, ꠎꠣꠔꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠎꠦ ꠀꠝꠤ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠢꠤꠡꠣꠛꠦ ꠉꠁꠘ꠆ꠘ ꠅꠁ। ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠛꠣꠘꠣꠁ। ");
INSERT INTO syls_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠅꠀꠞ ꠘꠤꠅꠔꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠍꠤ। ꠀꠝꠤꠃ ꠔ ꠝꠣꠛꠥꠖ।” ");
INSERT INTO syls_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠅꠃ ꠁꠖ ꠅꠇꠟ ꠑꠤꠇ ꠇꠞꠟꠣꠝ, ꠔꠥꠝꠞꠣ ꠁꠔꠣꠞꠦ ꠙꠛꠤꠔ꠆ꠞ ꠝꠤꠟꠘ-ꠝꠣꠢꠚꠤꠟꠞ ꠖꠤꠘ ꠢꠤꠡꠣꠛꠦ ꠝꠣꠘꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ꠢꠣꠙ꠆ꠔꠣꠔ ꠍꠄ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠤꠅ, ꠀꠞ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠅꠁꠟ ꠎꠤꠞꠣꠁꠛꠣꠞ ꠖꠤꠘ, ꠙꠛꠤꠔ꠆ꠞ ꠝꠤꠟꠘ-ꠝꠣꠢꠚꠤꠟꠞ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞ। ꠁ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠇꠥꠘꠥ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠤꠅ ꠘꠣ, ꠔꠥꠝꠞꠣ ꠎꠦꠇꠥꠘꠥ ꠎꠣꠉꠣꠔ ꠛꠡꠔ ꠇꠞꠅ, ꠁ ꠖꠤꠘ ꠈꠣꠘ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠙꠛꠤꠔ꠆ꠞ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞ ꠢꠤꠡꠣꠛꠦ ꠝꠣꠘꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠀꠝꠣꠞ ꠑꠤꠇ ꠇꠞꠣ ꠎꠔ ꠁꠖ ꠀꠍꠦ, ꠝꠣꠘꠤ ꠙꠛꠤꠔ꠆ꠞ ꠝꠤꠟꠘ-ꠝꠣꠢꠚꠤꠟꠞ ꠖꠤꠘ ꠢꠤꠡꠣꠛꠦ ꠎꠦꠔꠣ ꠝꠣꠘꠔꠣꠄ, ꠁꠔꠣ ꠀꠝꠤ ꠇꠁꠞꠣꠝ। ꠁꠔꠣ ꠅꠁꠟ: ");
INSERT INTO syls_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“ꠛꠍꠞꠞ ꠙꠄꠟꠣ ꠌꠣꠘ꠆ꠖꠞ ꠌꠃꠖ꠆ꠖ ꠔꠣꠞꠤꠈꠞ ꠢꠣꠁꠘ꠆ꠎꠣ ꠕꠣꠇꠤ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠎꠣꠖꠤ ꠁꠖ ꠀꠞꠝ꠆ꠛ ꠅꠁꠛ, ");
INSERT INTO syls_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","ꠀꠞ ꠅꠃ ꠌꠣꠘ꠆ꠖꠞ ꠙꠘꠞ ꠔꠣꠞꠤꠈꠅ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠞꠥꠐꠤꠞ ꠁꠖ ꠀꠞꠝ꠆ꠛ ꠅꠁꠛ। ꠙꠥꠞꠣ ꠡꠣꠔ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠞꠥꠐꠤ ꠈꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ꠅꠃ ꠡꠣꠔ ꠖꠤꠘꠞ ꠙꠄꠟꠣ ꠖꠤꠘ ꠔꠥꠝꠞꠣꠞ ꠙꠛꠤꠔ꠆ꠞ ꠝꠤꠟꠘ-ꠝꠣꠢꠚꠤꠟ ꠅꠁꠛ, ꠅꠃ ꠖꠤꠘ ꠖꠥꠘꠤꠀꠛꠤ ꠘꠤꠅꠔꠦ ꠇꠥꠘꠥꠎꠣꠔ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠣ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠢꠣꠞꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","ꠅꠃ ꠡꠣꠔ ꠖꠤꠘꠞ ꠙꠞꠔꠦꠇ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠄ। ꠛꠣꠖꠦ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠔꠥꠝꠞꠣꠞ ꠙꠛꠤꠔ꠆ꠞ ꠝꠤꠟꠘ-ꠝꠣꠢꠚꠤꠟ ꠅꠁꠛ, ꠅꠃ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠖꠥꠘꠤꠀꠛꠤ ꠘꠤꠅꠔꠦ ꠇꠥꠘꠥ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠣ ꠢꠣꠞꠣꠝ।” ");
INSERT INTO syls_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠀꠞꠅ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦ ꠖꠦꠡ ꠅꠇꠟꠞ ꠝꠣꠟꠤꠇꠣꠘꠣ ꠖꠤꠞꠣꠝ, ꠢꠘꠅ ꠉꠤꠀ ꠢꠣꠞꠟꠦ ꠔꠥꠝꠞꠣ ꠎꠔꠛꠣꠞ ꠎꠝꠤꠘꠞ ꠚꠡꠟ ꠖꠣꠁꠛꠣꠄ, ꠅꠔꠛꠣꠞ ꠈꠦꠔꠞ ꠙꠄꠟꠣ ꠇꠣꠐꠣ ꠄꠇꠈꠣꠘ ꠝꠥꠁꠐ ꠟꠁꠀ ꠁꠝꠣꠝ ꠍꠣꠛꠞ ꠉꠦꠍꠦ ꠎꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","ꠉꠦꠟꠦ ꠁꠝꠣꠝꠦ ꠅꠃ ꠝꠥꠁꠐ ꠘꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠖꠥꠟꠣꠁꠛꠣ। ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞꠞ ꠛꠣꠖꠞ ꠖꠤꠘ ꠔꠣꠁꠘ ꠁꠈꠣꠘ ꠖꠥꠟꠣꠁꠛꠣ, ꠔꠦꠃ ꠝꠣꠛꠥꠖ ꠔꠥꠝꠞꠣꠞ ꠃꠙꠞꠦ ꠈꠥꠡꠤ ꠅꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠎꠦꠖꠤꠘ ꠅꠃ ꠝꠥꠁꠐ ꠖꠥꠟꠣꠁꠛꠣ, ꠅꠃ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠄꠉꠥ ꠘꠤꠈꠥꠔ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣꠞꠦ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","ꠄꠞꠟꠉꠦ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠟꠣꠉꠤ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠌꠣꠁꠞ ꠡꠦꠞ ꠝꠄꠖꠣ ꠖꠤꠛꠣꠄ। ꠁꠔꠣ ꠔ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠞ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠍꠖꠉꠣ, ꠁꠔꠣꠞ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠔꠣꠁꠘ ꠈꠥꠡꠤ ꠅꠁꠘ। ꠀꠞ ꠄꠞ ꠟꠉꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣꠞ ꠘꠤꠅꠔꠦ ꠀꠋꠉꠥꠞꠞ ꠄꠇ ꠡꠦꠞ ꠡꠞꠛꠔꠅ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","ꠔꠥꠝꠞꠣꠞ ꠈꠦꠔꠞ ꠚꠡꠟ ꠖꠣꠁꠀ ꠢꠣꠞꠤ, ꠔꠥꠝꠞꠣꠞ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠞ ꠅꠃ ꠍꠖꠉꠣ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠀꠉ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠘꠄꠀ ꠚꠡꠟ ꠔꠥꠝꠞꠣ ꠈꠣꠁꠅ ꠘꠣ। ꠁꠔꠣꠖꠤ ꠞꠥꠐꠤ ꠛꠣꠘꠣꠁꠀ ꠛꠣ ꠀꠉꠥꠘꠤꠔ ꠜꠣꠎꠤꠀ ꠈꠣꠅꠀꠅ ꠘꠤꠡꠦꠗ। ꠔꠥꠝꠞꠣ ꠎꠦꠘꠅꠃ ꠞꠅ ꠘꠣ ꠇꠦꠘꠦ, ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠌꠤꠞꠇꠣꠟ ꠅꠃ ꠘꠤꠅꠝ ꠝꠣꠘꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ꠀꠞ ꠅꠃ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞꠞ ꠛꠣꠖꠞ ꠖꠤꠘ, ꠝꠣꠘꠤ ꠎꠦꠖꠤꠘ ꠖꠥꠟꠘꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠟꠣꠉꠤ ꠚꠡꠟꠞ ꠝꠥꠁꠐ ꠟꠁꠀ ꠀꠁꠛꠣꠄ, ꠅꠃ ꠖꠤꠘ ꠕꠣꠇꠤ ꠡꠣꠔ ꠢꠣꠙ꠆ꠔꠣꠄ ꠡꠣꠔ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞ ꠉꠘꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ꠅꠃ ꠡꠣꠔ ꠎꠥꠝ꠆ꠝꠣꠞ ꠛꠣꠖꠞ ꠖꠤꠘ, ꠝꠣꠘꠤ ꠙꠁꠘ꠆ꠌꠣꠡ ꠖꠤꠘꠞ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠘꠄꠀ ꠚꠡꠟꠞ ꠍꠖꠉꠣ ꠀꠖꠣꠄ ꠇꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠛꠣꠠꠤ ꠕꠣꠇꠤ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠖꠥꠟꠘꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠞ ꠘꠤꠅꠔꠦ ꠈꠦꠔꠞ ꠙꠄꠟꠣ ꠚꠡꠟ ꠕꠣꠇꠤ ꠇꠤꠍꠥ ꠚꠡꠟ ꠀꠘꠤꠅ। ꠔꠥꠝꠞꠣ ꠌꠣꠁꠞ ꠡꠦꠞ ꠝꠄꠖꠣꠖꠤ ꠛꠣꠘꠣꠁꠟ ꠈꠣꠝꠤꠞ ꠙꠥꠞꠣꠁꠟ ꠖꠥꠈꠣꠘ ꠘꠣꠘ ꠞꠥꠐꠤ ꠀꠘꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","ꠅꠃ ꠞꠥꠐꠤꠞ ꠟꠉꠦ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠡꠣꠔꠐꠣ ꠘꠤꠈꠥꠔ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ, ꠄꠇꠐꠣ ꠛꠤꠍꠣꠟ, ꠝꠦꠠꠣꠞ ꠖꠥꠁꠐꠣ ꠙꠣꠑꠣ ꠀꠘꠤꠅ। ꠅꠃ ꠙꠡꠥ ꠅꠇꠟ ꠖꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠄꠇꠈꠣꠘ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠛꠣꠄ, ꠅꠔꠣꠞ ꠟꠉꠦ ꠘꠤꠅꠝ ꠝꠣꠚꠤꠇ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠀꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣꠅ ꠖꠤꠛꠣꠄ। ꠁꠔꠣ ꠔ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠄꠇ ꠘꠝꠥꠘꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ, ꠁꠔꠣꠞ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠝꠣꠛꠥꠖ ꠈꠥꠡꠤ ꠅꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","ꠛꠣꠖꠦ ꠔꠥꠝꠞꠣ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠄꠉꠥ ꠙꠣꠑꠣ ꠍꠣꠉꠟ, ꠀꠞ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠖꠥꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠖꠥꠟꠘꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠅꠃ ꠖꠥꠁꠅ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠀꠞ ꠈꠦꠔꠞ ꠙꠄꠟꠣ ꠚꠡꠟꠖꠤ ꠛꠣꠘꠣꠁꠟ ꠞꠥꠐꠤ ꠘꠤꠀ ꠖꠥꠟꠣꠁꠛꠣ। ꠁꠔꠣ ꠔ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠍꠣꠝꠣꠘꠣ, ꠁꠔꠣ ꠁꠝꠣꠝ ꠍꠣꠛꠞ ꠙꠣꠅꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","ꠈꠦꠔꠞ ꠚꠡꠟ ꠖꠣꠅꠀꠞ ꠅꠃ ꠁꠖꠞ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠄꠇꠐꠣ ꠙꠛꠤꠔ꠆ꠞ ꠝꠤꠟꠘ-ꠝꠣꠢꠚꠤꠟ ꠇꠞꠤꠅ। ꠅꠃ ꠖꠤꠘ ꠖꠥꠘꠤꠀꠛꠤ ꠘꠤꠅꠔꠦ ꠇꠥꠘꠥ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠤꠅ ꠘꠣ। ꠔꠥꠝꠞꠣ ꠎꠦꠘꠅꠃ ꠞꠅ ꠘꠣ ꠇꠦꠘꠦ, ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠢꠞ-ꠢꠣꠝꠦꠡꠣ ꠁꠔꠣ ꠀꠝꠟ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ꠔꠥꠝꠞꠣ ꠎꠦꠛꠟꠣ ꠈꠦꠔꠞ ꠚꠡꠟ ꠖꠣꠁꠛꠣꠄ, ꠅꠃ ꠡꠝꠄ ꠔꠥꠝꠞꠣ ꠎꠝꠤꠘꠞ ꠀꠁꠟꠞ ꠇꠣꠘ꠆ꠖꠣꠞ ꠚꠡꠟ ꠍꠣꠚ ꠇꠞꠤꠀ ꠇꠣꠐꠤꠅ ꠘꠣ, ꠀꠞ ꠖꠣꠅꠀꠞ ꠛꠣꠖꠦ ꠅꠃ ꠎꠝꠤꠘꠅ ꠚꠣꠟꠣꠁꠟ ꠚꠡꠟ ꠟꠥꠞꠤꠅ ꠘꠣ। ꠉꠞꠤꠛ-ꠖꠥꠈꠤ ꠀꠞ ꠛꠤꠖꠦꠡꠤ ꠝꠥꠍꠣꠚꠤꠞꠞ ꠟꠣꠉꠤ ꠁꠔꠣ ꠕꠁꠅ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ।” ");
INSERT INTO syls_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠛꠍꠞꠞ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠌꠣꠘ꠆ꠖꠞ ꠙꠄꠟꠣ ꠖꠤꠘꠞꠦ ꠔꠥꠝꠞꠣ ꠙꠥꠞꠣꠙꠥꠞ ꠎꠤꠞꠣꠘꠤꠞ ꠖꠤꠘ ꠢꠤꠡꠣꠛꠦ ꠝꠣꠘꠤꠅ। ꠅꠃ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠡꠤꠋꠉꠣ ꠛꠣꠎꠣꠁꠅ ꠀꠞ ꠢꠇꠟꠦ ꠝꠤꠟꠤꠀ ꠁꠖꠞ ꠙꠛꠤꠔ꠆ꠞ ꠝꠤꠟꠘ-ꠝꠣꠢꠚꠤꠟ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","ꠅꠃ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠖꠥꠘꠤꠀꠛꠤ ꠘꠤꠅꠔꠦ ꠇꠥꠘꠥ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠤꠅ ꠘꠣ, ꠈꠣꠟꠤ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠍꠖꠉꠣ ꠀꠖꠣꠄ ꠇꠞꠤꠅ।” ");
INSERT INTO syls_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“ꠅꠃ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠌꠣꠘ꠆ꠖꠞ ꠖꠡ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠅꠁꠟ ꠇꠚꠞꠣꠞ ꠁꠖꠞ ꠖꠤꠘ। ꠁ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠄꠇꠐꠣ ꠙꠛꠤꠔ꠆ꠞ ꠝꠤꠟꠘ-ꠝꠣꠢꠚꠤꠟ ꠇꠞꠤꠅ। ꠙꠞꠔꠦꠇ ꠎꠘꠦ ꠘꠔ ꠅꠁꠀ ꠎꠣꠞꠎꠤꠞ ꠖꠤꠟ ꠡꠙꠤꠀ ꠖꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠍꠖꠉꠣ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ꠁꠔꠣ ꠅꠁꠟ ꠇꠚꠞꠣꠞ ꠁꠖ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠍꠣꠝꠘꠦ ꠔꠥꠝꠞꠣꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠣ ꠅꠁꠛ, ꠀꠡ꠆ꠔꠣ ꠁ ꠖꠤꠘꠅ ꠇꠥꠘꠥꠎꠣꠔ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠣ ꠢꠣꠞꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","ꠎꠦ ꠝꠣꠘꠡꠦ ꠢꠃ ꠖꠤꠘ ꠘꠔ ꠅꠁꠀ ꠘꠤꠎꠞ ꠖꠤꠟ ꠡꠙꠤꠀ ꠘꠣ ꠖꠦꠄ, ꠔꠣꠞ ꠘꠣꠝ ꠁ ꠎꠣꠔꠤꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠝꠤꠐꠣꠁꠟꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","ꠀꠞ ꠢꠃ ꠖꠤꠘ ꠎꠥꠖꠤ ꠇꠦꠃ ꠇꠥꠘꠥ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠦ, ꠔꠦ ꠔꠣꠞ ꠘꠣꠝ ꠀꠝꠤ ꠁ ꠎꠣꠔꠤꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠡꠦꠡ ꠇꠞꠤꠟꠤꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","ꠅꠃ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠇꠥꠘꠥꠎꠣꠔ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠤꠅ ꠘꠣ। ꠔꠥꠝꠞꠣ ꠎꠦꠘꠅꠃ ꠞꠅ ꠘꠣ ꠇꠦꠘꠦ, ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠢꠞ-ꠢꠣꠝꠦꠡꠣ ꠅꠃ ꠘꠤꠅꠝ ꠝꠣꠘꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","ꠅꠃ ꠖꠤꠘ ꠅꠁꠛ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠙꠛꠤꠔ꠆ꠞ ꠎꠥꠝ꠆ꠝꠣꠞ ꠖꠤꠘ, ꠄꠞꠟꠣꠉꠤ ꠘꠔ ꠅꠁꠀ ꠖꠤꠟ ꠡꠙꠤꠀ ꠖꠤꠅ। ꠅꠃ ꠌꠣꠘ꠆ꠖꠞ ꠘꠄ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘꠞ ꠢꠣꠁꠘ꠆ꠎꠣ ꠕꠣꠇꠤ ꠛꠣꠖꠞ ꠖꠤꠘ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠙꠛꠤꠔ꠆ꠞ ꠅꠃ ꠎꠥꠝ꠆ꠝꠣꠞ ꠖꠤꠘ ꠝꠣꠘꠤꠅ।” ");
INSERT INTO syls_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠅ, ꠅꠃ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠌꠣꠘ꠆ꠖꠞ ꠙꠘꠞ ꠔꠣꠞꠤꠈ ꠕꠣꠇꠤ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠒꠦꠞꠣ-ꠊꠞꠞ ꠁꠖ ꠀꠞꠝ꠆ꠛ ꠅꠁꠀ, ꠡꠣꠔ ꠖꠤꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠁꠖ ꠌꠟꠛ। ");
INSERT INTO syls_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","ꠅꠃ ꠡꠣꠔ ꠖꠤꠘꠞ ꠙꠄꠟꠣ ꠖꠤꠘ ꠔꠥꠝꠞꠣꠞ ꠙꠛꠤꠔ꠆ꠞ ꠝꠤꠟꠘ-ꠝꠣꠢꠚꠤꠟ ꠅꠁꠛ। ꠁ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠖꠥꠘꠤꠀꠛꠤ ꠘꠤꠅꠔꠦ ꠇꠥꠘꠥ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ꠅꠃ ꠁꠖꠞ ꠡꠣꠔꠅ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠛꠣꠄ। ꠛꠣꠖꠦ ꠀꠐ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘꠅ ꠔꠥꠝꠞꠣ ꠢꠤꠞꠛꠣꠞ ꠙꠛꠤꠔ꠆ꠞ ꠝꠤꠟꠘ-ꠝꠣꠢꠚꠤꠟ ꠇꠞꠛꠣꠄ ꠀꠞ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠄ। ꠁꠐꠣ ꠅꠁꠟ ꠡꠦꠡ ꠖꠤꠘꠞ ꠀꠈꠦꠞꠤ ꠝꠣꠢꠚꠤꠟ, ꠅꠃ ꠖꠤꠘꠅ ꠔꠥꠝꠞꠣ ꠖꠥꠘꠤꠀꠛꠤ ꠘꠤꠅꠔꠦ ꠇꠥꠘꠥ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“ꠀꠡ꠆ꠔꠣ ꠛꠍꠞꠞ ꠝꠣꠎꠦ ꠎꠔ ꠟꠣꠈꠣꠘ ꠁꠖ ꠀꠍꠦ, ꠅꠔꠣ ꠢꠇ꠆ꠇꠟ ꠎꠣꠔꠞ ꠁꠖ ꠅꠇꠟ ꠔ ꠝꠣꠛꠥꠖꠦꠃ ꠗꠣꠁꠞ꠆ꠎ ꠇꠞꠤ ꠖꠤꠍꠂꠘ। ꠄꠞꠟꠣꠉꠤ ꠁꠖꠞ ꠅꠃ ꠖꠤꠘ ꠅꠇꠟꠞꠦ ꠔꠥꠝꠞꠣ ꠙꠛꠤꠔ꠆ꠞ ꠝꠤꠟꠘ-ꠝꠣꠢꠚꠤꠟꠞ ꠖꠤꠘ ꠢꠤꠡꠣꠛꠦ ꠝꠣꠘꠤꠅ, ꠄꠞ ꠙꠞꠔꠦꠇ ꠖꠤꠘ ꠎꠦꠔꠣ ꠎꠦꠔꠣ ꠇꠞꠣ ꠎꠞꠥꠞ, ꠁꠔꠣ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ꠝꠣꠘꠤ, ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ, ꠘꠤꠎꠞ ꠈꠥꠡꠤꠄ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤ, ꠀꠞ ꠄꠞ ꠟꠉꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣ। ꠅꠃ ꠇꠥꠞꠛꠣꠘꠤ ꠅꠇꠟ ꠀꠟ꠆ꠟꠣꠞ ꠗꠣꠁꠞ꠆ꠎ ꠇꠞꠣ ꠖꠤꠘꠅ ꠔꠥꠝꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","ꠅꠁꠟꠦ ꠈꠤꠀꠟ ꠞꠣꠈꠤꠅ, ꠔꠥꠝꠞꠣꠞꠦ ꠛꠣꠔꠣꠁꠟ ꠅꠔꠣ ꠢꠇ꠆ꠇꠟ ꠟꠣꠈꠣꠘ ꠁꠖ ꠅꠇꠟꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠞ ꠟꠤꠟ꠆ꠟꠣ-ꠍꠖꠉꠣꠞꠦ ꠀꠖꠣꠄ ꠇꠞꠤꠀ, ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞꠞ ꠇꠥꠞꠛꠣꠘꠤ, ꠢꠇꠟ ꠘꠝꠥꠘꠣꠞ ꠟꠤꠟ꠆ꠟꠣ-ꠍꠖꠉꠣ, ꠝꠣꠘ꠆ꠘꠔ ꠀꠞ ꠘꠤꠎꠞ ꠈꠥꠡꠤꠄ ꠖꠦꠅꠀ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞꠦꠅ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ꠢꠔꠣ ꠁꠖ ꠅꠇꠟꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠉꠦ ꠁꠔꠣꠞꠦ ꠝꠤꠟꠣꠁꠅ ꠘꠣ, ꠀꠟꠣꠖꠣ ꠞꠣꠈꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ꠀꠞ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠌꠣꠘ꠆ꠖꠞ ꠙꠘꠞ ꠔꠣꠞꠤꠈꠅ, ꠈꠦꠔꠞ ꠢꠇꠟ ꠚꠟ-ꠚꠡꠟ ꠔꠥꠟꠣꠞ ꠛꠣꠖꠦ, ꠔꠥꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠡꠣꠔ ꠖꠤꠘ ꠗꠞꠤꠀ ꠒꠦꠞꠣ-ꠊꠞꠞ ꠅꠃ ꠁꠖ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ꠅꠃ ꠡꠣꠔ ꠖꠤꠘꠞ ꠙꠄꠟꠣ ꠖꠤꠘ ꠀꠞ ꠡꠦꠡꠞ ꠀꠐ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠅꠁꠟ ꠔꠥꠝꠞꠣꠞ ꠙꠥꠞꠣꠙꠥꠞ ꠎꠤꠞꠣꠁꠛꠣꠞ ꠖꠤꠘ। ");
INSERT INTO syls_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","ꠄꠞ ꠙꠄꠟꠣ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠔꠞꠔꠣꠎꠣ ꠉꠣꠍꠞ ꠒꠣꠟ ꠙꠣꠟꠣ, ꠝꠣꠘꠤ ꠈꠦꠎꠥꠞ ꠙꠣꠔꠣ, ꠢꠇꠟ ꠘꠝꠥꠘꠣꠞ ꠙꠣꠔꠣ-ꠛꠣꠢꠣꠞ ꠉꠣꠍꠞ ꠒꠣꠟ ꠙꠣꠟꠣ, ꠀꠞ ꠉꠣꠋꠉꠞ ꠙꠣꠞꠞ ꠁꠎꠟ ꠉꠣꠍꠞ ꠒꠣꠟ ꠟꠁꠀ ꠀꠎꠤꠞ ꠅꠁꠅ। ꠅꠁꠀ ꠅꠃ ꠡꠣꠔꠅ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠍꠣꠝꠘꠦ ꠈꠥꠡꠤ-ꠛꠣꠡꠤ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","ꠙꠞꠔꠦꠇ ꠛꠍꠞꠞ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠌꠣꠘ꠆ꠖꠞ ꠡꠣꠔ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠁ ꠁꠖ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠢꠞ-ꠢꠣꠝꠦꠡꠣ ꠁꠔꠣ ꠝꠣꠘꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","ꠙꠥꠞꠣ ꠡꠣꠔ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠢꠇꠟ ꠉꠤꠀ ꠒꠦꠞꠣ-ꠊꠞꠅ ꠞꠁꠅ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠢꠇꠟ ꠝꠣꠘꠥꠡ ꠅꠃ ꠡꠝꠄ ꠒꠦꠞꠣ-ꠊꠞꠅ ꠕꠣꠇꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ꠔꠦꠃ ꠅꠔꠣ ꠖꠦꠈꠤꠀ ꠢꠣꠞꠤ ꠔꠥꠝꠞꠣꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠦꠅ ꠛꠥꠎꠛꠣ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠤꠀ ꠢꠣꠞꠟꠦ ꠀꠝꠤ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠝꠣꠎꠦ ꠔꠣꠞꠣꠞꠦ ꠅꠟꠣ ꠒꠦꠞꠣ-ꠊꠞꠅ ꠛꠡꠔ ꠇꠞꠣꠁꠍꠟꠣꠝ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ।” ");
INSERT INTO syls_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","ꠄꠞꠛꠣꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤ ꠉꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠛꠣꠔꠣꠁꠟ ꠅꠃ ꠢꠇꠟ ꠁꠖꠞ ꠇꠕꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠦꠅ, ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤꠞ ꠌꠦꠞꠣꠉ ꠅꠇꠟ ꠢꠣꠝꠦꠡꠣ ꠎꠣꠟꠣꠁꠀ ꠞꠣꠈꠣꠞ ꠘꠤꠅꠔꠦ, ꠔꠣꠞꠣ ꠎꠄꠔꠥꠘ ꠍꠦꠌꠤꠀ ꠈꠣꠐꠤ ꠔꠦꠟ ꠛꠣꠘꠣꠁꠀ ꠔꠥꠝꠣꠞ ꠉꠦꠍꠦ ꠟꠁꠀ ꠀꠁꠔ। ");
INSERT INTO syls_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","ꠀꠞ ꠇꠣꠛꠣ ꠊꠞꠞ ꠜꠤꠔꠞꠦ ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇꠞ ꠙꠞ꠆ꠖꠣꠞ ꠛꠣꠞꠦ, ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠦ ꠢꠣꠁꠘ꠆ꠎꠣ ꠕꠣꠇꠤ ꠚꠎꠞ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤꠞ ꠌꠦꠞꠣꠉ ꠅꠇꠟ ꠎꠣꠟꠣꠁ ꠞꠣꠈꠛꠣ। ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠢꠞ-ꠢꠣꠝꠦꠡꠣ ꠁꠔꠣ ꠎꠣꠞꠤ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠕꠅꠀ ꠅꠃ ꠈꠣꠐꠤ ꠡꠥꠘꠣꠞ ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤꠞ ꠌꠦꠞꠣꠉ ꠅꠇꠟꠞꠦ ꠔꠣꠁꠘ ꠢꠣꠝꠦꠡꠣ ꠎꠣꠄ-ꠎꠔꠘ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“ꠀꠞ ꠢꠥꠘꠅ, ꠝꠄꠖꠣ ꠖꠤꠀ ꠛꠣꠞꠅ ꠈꠣꠘ ꠞꠥꠐꠤ ꠛꠣꠘꠣꠁꠅ, ꠙꠞꠔꠦꠇ ꠞꠥꠐꠤ ꠅꠁꠛ ꠖꠥꠁ ꠡꠦꠞ ꠝꠄꠖꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","ꠛꠣꠘꠣꠁꠀ ꠅꠃ ꠞꠥꠐꠤꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠞ ꠈꠣꠐꠤ ꠡꠥꠘꠣꠞ ꠐꠦꠛꠥꠟꠞ ꠃꠙꠞꠦ ꠍꠄꠈꠣꠘ ꠍꠄꠈꠣꠘ ꠇꠞꠤ ꠖꠥꠁ ꠟꠣꠁꠘꠦ ꠢꠣꠎꠣꠁ ꠕꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","ꠙꠞꠔꠦꠇ ꠟꠣꠁꠘꠞ ꠞꠥꠐꠤꠞ ꠗꠣꠞꠅ ꠈꠣꠐꠤ ꠟꠥꠛꠣꠘ-ꠀꠉꠞ ꠕꠁꠅ। ꠕꠁꠀ ꠘꠤꠡꠣꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠞꠥꠐꠤꠞ ꠛꠖꠟꠣ ꠅꠃ ꠀꠉꠞꠖꠤ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","ꠙꠞꠔꠦꠇ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠙꠇ꠆ꠇ ꠕꠣꠇꠤ ꠙꠛꠤꠔ꠆ꠞ ꠅꠃ ꠞꠥꠐꠤꠞꠦ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠎꠞꠞ ꠍꠣꠝꠘꠦ ꠢꠣꠎꠣꠁꠀ ꠕꠁꠛꠣ। ꠔꠣꠞꠣꠞ ꠅꠃ ꠞꠥꠐꠤ ꠖꠦꠅꠀ ꠔ ꠢꠞ-ꠢꠣꠝꠦꠡꠣ ꠌꠤꠞꠇꠣꠟ ꠎꠣꠞꠤ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","ꠛꠣꠖꠦ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠘ ꠛꠋꠡꠗꠞꠦ ꠙꠛꠤꠔ꠆ꠞ ꠇꠣꠛꠣ ꠊꠞꠞ ꠡꠤꠝꠣꠘꠣꠞ ꠜꠤꠔꠞꠦ ꠅꠃ ꠞꠥꠐꠤ ꠈꠣꠁꠛꠣ, ꠁꠔꠣ ꠅꠁꠟ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠎꠤꠘꠤꠡꠞ ꠝꠣꠎꠦ ꠄꠇ ꠈꠣꠍ ꠙꠛꠤꠔ꠆ꠞ ꠎꠤꠘꠤꠡ। ꠁꠔꠣ ꠔ ꠁꠝꠣꠝ ꠅꠇꠟꠞ ꠙꠣꠅꠘꠣ, ꠅꠃ ꠘꠤꠅꠝ ꠢꠞ-ꠢꠣꠝꠦꠡꠣ ꠎꠣꠞꠤ ꠞꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠎꠦ ꠅꠟꠣ ꠄꠇ ꠛꠦꠐꠣ ꠀꠍꠤꠟ, ꠎꠦꠉꠥꠞ ꠛꠣꠚ ꠅꠁꠟ ꠝꠤꠡꠞꠤ ꠀꠞ ꠝꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠎꠣꠔꠤꠞ। ꠁ ꠛꠦꠐꠣꠄ ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠀꠞꠇ ꠛꠦꠐꠣꠄ ꠇꠦꠝ꠆ꠙꠞ ꠜꠤꠔꠞꠦ ꠝꠣꠞꠣ-ꠝꠣꠞꠤ ꠟꠣꠉꠟ। ");
INSERT INTO syls_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","ꠅꠃ ꠡꠝꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠤ ꠛꠦꠐꠤꠞ ꠙꠥꠀꠄ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠇꠥꠚꠥꠞꠤ ꠝꠣꠔ ꠝꠣꠔꠤꠀ ꠟꠣꠘ꠆ꠘꠔ ꠖꠤꠟ। ꠁꠔꠣ ꠢꠥꠘꠤꠀ ꠝꠣꠘꠡꠦ ꠔꠣꠞꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞ ꠉꠦꠍꠦ ꠟꠁꠀ ꠉꠦꠟꠣ। ꠅꠃ ꠛꠦꠐꠣꠞ ꠝꠣʼꠞ ꠘꠣꠝ ꠡꠣꠟꠥꠝꠤ, ꠔꠣꠁ ꠀꠍꠤꠟ ꠖꠣꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠖꠤꠛꠞꠤꠞ ꠙꠥꠠꠤ। ");
INSERT INTO syls_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","ꠀꠞ ꠝꠣꠘꠡꠦ ꠅꠃ ꠛꠦꠙꠣꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠝꠞ꠆ꠎꠤ ꠢꠥꠘꠣꠞ ꠟꠣꠉꠤ ꠅꠃ ꠛꠦꠐꠣꠞꠦ ꠀꠐꠇꠣꠁꠀ ꠕꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“ꠀꠝꠣꠞ ꠘꠣꠝꠦ ꠟꠣꠘ꠆ꠘꠔ ꠖꠦꠅꠞꠣ ꠅꠃ ꠛꠦꠐꠣꠞꠦ ꠟꠁꠀ ꠇꠦꠝ꠆ꠙꠞ ꠛꠣꠞꠦ ꠎꠣꠅ। ꠉꠦꠟꠦ ꠎꠦꠔꠣ ꠝꠣꠘꠡꠦ ꠅꠃ ꠇꠥꠚꠥꠞꠤ ꠝꠣꠔ ꠢꠥꠘꠍꠦ, ꠔꠣꠞꠣ ꠢꠇꠟꠦ ꠅꠉꠥꠞ ꠝꠣꠕꠣ ꠀꠔꠣꠁ ꠖꠦꠃꠇ, ꠛꠣꠖꠦ ꠡꠝꠣꠎꠞ ꠢꠇꠟ ꠝꠣꠘꠡꠦ ꠙꠣꠔ꠆ꠔꠞ ꠝꠣꠞꠤꠀ ꠔꠣꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠃꠇ। ");
INSERT INTO syls_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","ꠀꠞ ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠎꠦ ꠝꠣꠘꠡꠦ ꠀꠟ꠆ꠟꠣꠞꠦ ꠟꠣꠘ꠆ꠘꠔ ꠖꠦꠄ, ꠔꠣꠞ ꠘꠣꠚꠞꠝꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠢꠦ ꠘꠤꠎꠦꠃ ꠖꠣꠄꠁ। ");
INSERT INTO syls_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","ꠀꠞ ꠎꠦ ꠝꠣꠘꠡꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠇꠥꠚꠥꠞꠤ ꠝꠣꠔ ꠝꠣꠔꠤꠛ, ꠔꠣꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠤꠛꠣꠄ। ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠡꠝꠣꠎꠦ ꠔꠣꠞꠦ ꠙꠣꠔ꠆ꠔꠞ ꠝꠣꠞꠤꠀ ꠎꠣꠘꠦ ꠝꠣꠞꠛꠣ। ꠢꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠤ ꠅꠃꠇ ꠛꠣ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠛꠡꠔ ꠇꠞꠞꠣ ꠜꠤꠘ ꠎꠣꠔꠤꠞ ꠝꠣꠘꠥꠡ ꠅꠃꠇ, ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠦ ꠎꠦꠉꠤꠄ ꠇꠥꠚꠥꠞꠤ ꠝꠣꠔ ꠝꠣꠔꠤꠛ, ꠔꠣꠞꠦ ꠘꠤꠌ꠆ꠌꠤꠔ ꠎꠣꠘꠦ ꠝꠣꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠖꠥꠍꠞꠣ ꠝꠣꠘꠡꠞꠦ ꠈꠥꠘ ꠇꠞꠤꠟꠣꠄ, ꠔꠦ ꠔꠥꠝꠞꠣ ꠔꠣꠞꠦꠅ ꠈꠥꠘ ꠇꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠖꠥꠍꠞꠣ ꠝꠣꠘꠡꠞ ꠇꠥꠘꠥ ꠙꠡꠥꠞꠦ ꠝꠣꠞꠤꠟꠣꠄ, ꠔꠦ ꠅꠉꠥꠞ ꠛꠖꠟꠣ ꠢꠦ ꠀꠞꠇ ꠙꠡꠥꠞ ꠖꠣꠝ ꠖꠤꠀ ꠈꠦꠔꠤ-ꠙꠥꠞꠘ ꠖꠤꠛ। ꠎꠣꠘꠞ ꠛꠖꠟꠣ ꠎꠣꠘ। ");
INSERT INTO syls_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","ꠇꠦꠃ ꠎꠥꠖꠤ ꠀꠞꠇ ꠎꠘꠞꠦ ꠝꠣꠞꠦ, ꠀꠞ ꠅꠃ ꠝꠣꠁꠞꠞ ꠟꠣꠉꠤ ꠡꠞꠤꠟꠞ ꠇꠥꠘꠥ ꠅꠋꠉꠞ ꠈꠦꠔꠤ ꠅꠄ, ꠔꠦ ꠢꠦ ꠎꠦꠟꠣ ꠈꠦꠔꠤ ꠇꠞꠍꠦ, ꠔꠣꠞ ꠅꠋꠉꠞꠦꠅ ꠅꠟꠣ ꠈꠦꠔꠤ ꠇꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","ꠀꠒ꠆ꠒꠤ ꠜꠣꠋꠉꠣꠞ ꠛꠖꠟꠣ ꠀꠒ꠆ꠒꠤ ꠜꠣꠋꠉꠤꠛꠣꠄ, ꠌꠃꠈꠞ ꠛꠖꠟꠣ ꠌꠃꠈ, ꠖꠣꠔꠞ ꠛꠖꠟꠣ ꠖꠣꠔ। ꠢꠃ ꠎꠘꠞ ꠎꠦ ꠅꠋꠉꠞꠦ ꠢꠦ ꠈꠦꠔꠤ ꠇꠞꠍꠦ, ꠔꠣꠞꠅ ꠅꠟꠣ ꠈꠦꠔꠤ ꠇꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","ꠇꠥꠘꠥ ꠙꠡꠥꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠟꠦ ꠄꠞ ꠈꠦꠔꠤ-ꠙꠥꠞꠘ ꠖꠤꠔꠦ ꠅꠁꠛ, ꠅꠁꠟꠦ ꠇꠥꠘꠥ ꠝꠣꠘꠥꠡꠞꠦ ꠈꠥꠘ ꠇꠞꠟꠦ ꠔꠣꠞꠦꠃ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠛꠣ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠛꠡꠔ ꠇꠞꠞꠣ ꠜꠤꠘ ꠎꠣꠔꠤꠞ ꠝꠣꠘꠡꠞ ꠟꠣꠉꠤ ꠅꠃ ꠄꠇꠁ ꠀꠁꠘ ꠎꠣꠞꠤ ꠞꠁꠛ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ।” ");
INSERT INTO syls_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","ꠛꠣꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠎꠣꠘꠣꠁꠟꠣ। ꠔꠦꠃ ꠎꠦ ꠛꠦꠐꠣꠄ ꠢꠃ ꠇꠥꠚꠥꠞꠤ ꠝꠣꠔꠤꠍꠤꠟ, ꠝꠣꠘꠡꠦ ꠅꠉꠥꠞꠦ ꠇꠦꠝ꠆ꠙꠞ ꠛꠣꠞꠦ ꠘꠤꠀ ꠙꠣꠔ꠆ꠔꠞ ꠝꠣꠞꠤꠀ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠤꠟꠣ। ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠑꠤꠇ ꠅꠟꠣꠃ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠔꠥꠞ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠀꠝꠤ ꠎꠦ ꠖꠦꠡꠈꠣꠘ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠤꠀꠞ, ꠢꠃ ꠖꠦꠡꠅ ꠉꠤꠀ ꠢꠣꠞꠟꠦ ꠔꠥꠝꠞꠣ ꠈꠤꠀꠟ ꠞꠣꠈꠤꠅ, ꠢꠘꠞ ꠎꠝꠤ-ꠝꠣꠐꠤꠄ ꠎꠣꠘꠥ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠞꠣꠝ ꠇꠞꠣꠞ ꠡꠝꠄ ꠙꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ꠔꠥꠝꠞꠣ ꠍꠄ ꠛꠍꠞ ꠎꠝꠤꠘꠅ ꠈꠦꠔ-ꠈꠣꠝꠣꠞ ꠇꠞꠤꠅ, ꠀꠋꠉꠥꠞ ꠉꠣꠍꠞ ꠒꠣꠟ ꠙꠣꠟꠣ ꠍꠣꠐꠤꠀ ꠚꠄ-ꠚꠡꠟ ꠛꠣꠠꠤꠔ ꠀꠘꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ꠅꠁꠟꠦ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠛꠍꠞ ꠎꠝꠤ-ꠎꠝꠣꠞꠦ ꠎꠤꠞꠣꠘꠤꠞ ꠡꠥꠎꠥꠉ ꠖꠤꠅ। ꠁꠐꠣ ꠅꠁꠟ ꠝꠣꠛꠥꠖꠞ ꠘꠤꠅꠔꠦ ꠀꠞꠣꠝꠞ ꠛꠍꠞ। ꠅꠃ ꠛꠍꠞ ꠔꠥꠝꠞꠣ ꠎꠝꠤꠘꠅ ꠈꠦꠔ ꠇꠞꠤꠅ ꠘꠣ, ꠀꠋꠉꠥꠞ ꠉꠣꠍꠞ ꠒꠣꠟ ꠙꠣꠟꠣ ꠍꠣꠐꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","ꠀꠞ ꠎꠝꠤꠘꠞ ꠝꠣꠎꠦ ꠄꠝꠘꠦꠃ ꠎꠦꠔꠣ ꠚꠟꠤꠛ, ꠁꠔꠣ ꠘꠤꠀ ꠔꠥꠝꠞꠣꠞ ꠃꠉꠣꠞꠅ ꠕꠁꠅ ꠘꠣ। ꠛꠤꠘꠣ ꠎꠔꠘꠦ ꠀꠋꠉꠥꠞ ꠉꠣꠍꠅ ꠎꠦꠔꠣ ꠚꠟ ꠗꠞꠛ, ꠁꠔꠣ ꠙꠣꠠꠤꠀ ꠘꠤꠀ ꠎꠝꠣꠁꠅ ꠘꠣ। ꠢꠇꠟ ꠎꠝꠤ-ꠎꠝꠣꠞꠦ ꠙꠥꠞꠣ ꠄꠇ ꠛꠍꠞ ꠎꠤꠞꠣꠘꠤꠞ ꠡꠝꠄ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","ꠎꠤꠞꠣꠘꠤꠞ ꠛꠍꠞ ꠎꠝꠤꠘꠅ ꠄꠝꠘꠦ ꠎꠦꠔꠣ ꠚꠟꠤꠛ, ꠁꠔꠣ ꠔ ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ, ꠔꠥꠝꠞꠣꠞ ꠉꠥꠟꠣꠝ-ꠛꠣꠘ꠆ꠖꠤꠞ, ꠔꠥꠝꠞꠣꠞ ꠖꠦꠡꠞ ꠜꠤꠘ-ꠖꠦꠡꠤ ꠝꠥꠍꠣꠚꠤꠞ, ꠔꠥꠝꠞꠣꠞ ꠡꠝꠣꠎꠞ ꠝꠦꠘꠔꠤ ꠇꠣꠝꠟꠣ, ꠢꠇꠟ ꠎꠣꠔꠞ ꠝꠣꠘꠡꠞ, ");
INSERT INTO syls_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","ꠔꠥꠝꠞꠣꠞ ꠙꠣꠟꠣ ꠢꠦꠝꠣꠘ, ꠀꠞ ꠖꠦꠡꠞ ꠎꠋꠟꠤ ꠎꠣꠘꠥꠀꠞꠞ ꠈꠣꠘꠤ-ꠈꠥꠞꠣꠇ ꠅꠁꠛ। ꠅꠃ ꠛꠍꠞ ꠎꠝꠤꠘꠅ ꠄꠝꠘꠦ ꠎꠦꠔꠣ ꠚꠟꠤꠛ, ꠁꠔꠣ ꠔꠥꠝꠞꠣ ꠢꠇꠟꠦ ꠈꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ꠀꠞ ꠢꠥꠘꠅ, ꠡꠣꠔ ꠛꠍꠞ ꠇꠞꠤ ꠇꠞꠤ ꠡꠣꠔꠈꠣꠘ ꠎꠤꠞꠣꠘꠤꠞ ꠛꠍꠞꠞꠦ ꠔꠥꠝꠞꠣ ꠉꠘꠤꠅ, ꠉꠘꠤꠟꠦ ꠡꠣꠔꠛꠣꠞ ꠡꠣꠔ ꠛꠍꠞꠦ ꠃꠘꠥꠙꠁꠘ꠆ꠌꠣꠡ ꠛꠍꠞ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","ꠄꠞ ꠛꠣꠖꠞ ꠛꠍꠞ, ꠝꠣꠘꠤ ꠙꠁꠘ꠆ꠌꠣꠡ ꠘꠝ꠆ꠛꠞ ꠛꠍꠞ, ꠅꠃ ꠛꠍꠞꠞ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠌꠣꠘ꠆ꠖꠞ ꠖꠡ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ, ꠁꠔꠣ ꠔ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠖꠤꠘ, ꠢꠃ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠀꠡ꠆ꠔꠣ ꠖꠦꠡꠞ ꠢꠇꠟ ꠎꠣꠉꠣꠔ ꠡꠤꠋꠉꠣ ꠛꠣꠎꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","ꠅꠃ ꠙꠁꠘ꠆ꠌꠣꠡ ꠘꠝ꠆ꠛꠞ ꠛꠍꠞꠞꠦ ꠔꠥꠝꠞꠣ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠝꠣꠘꠤꠅ, ꠖꠦꠡꠞ ꠢꠇꠟ ꠝꠣꠘꠡꠞꠦ ꠀꠎꠣꠖꠤꠞ ꠇꠕꠣ ꠎꠣꠘꠣꠁꠅ। ꠁ ꠛꠍꠞ ꠅꠁꠟ ꠔꠥꠝꠞꠣꠞ ꠎꠝꠤ-ꠝꠤꠞꠣꠡ ꠚꠤꠞꠔ ꠙꠣꠅꠀꠞ ꠛꠍꠞ। ꠅꠃ ꠛꠍꠞ ꠔꠥꠝꠞꠣ ꠎꠣꠞꠎꠤꠞ ꠙꠞꠤꠛꠣꠞ ꠀꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠎꠝꠤ-ꠎꠝꠣꠞ ꠖꠈꠟꠖꠣꠞꠤ ꠚꠤꠞꠔ ꠙꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","ꠙꠞꠔꠦꠇ ꠙꠁꠘ꠆ꠌꠣꠡ ꠘꠝ꠆ꠛꠞ ꠛꠍꠞ ꠅꠁꠛ, ꠔꠥꠝꠞꠣꠞ ꠖꠈꠟꠖꠣꠞꠤ ꠚꠤꠞꠔ ꠙꠣꠅꠀꠞ ꠛꠍꠞ। ꠅꠃ ꠛꠍꠞ ꠔꠥꠝꠞꠣ ꠎꠝꠤꠘꠅ ꠇꠥꠘꠥ ꠛꠤꠌꠤ ꠛꠣꠁꠘ ꠇꠞꠤꠅ ꠘꠣ, ꠎꠝꠤꠘꠅ ꠄꠝꠘꠦꠃ ꠎꠦꠔꠣ ꠎꠘꠝꠤꠛ ꠁꠔꠣ ꠔꠥꠝꠞꠣ ꠘꠤꠅ ꠘꠣ। ꠀꠞ ꠛꠤꠘꠣ ꠎꠔꠘꠦ ꠀꠋꠉꠥꠞ ꠉꠣꠍꠅ ꠎꠦꠔꠣ ꠚꠟ ꠗꠞꠛ, ꠁꠔꠣꠅ ꠔꠥꠝꠞꠣ ꠊꠞꠅ ꠀꠘꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","ꠅꠃ ꠛꠍꠞ ꠅꠁꠟ ꠚꠤꠞꠔ ꠙꠣꠁꠛꠣꠞ ꠛꠍꠞ। ꠔꠥꠝꠞꠣ ꠅꠃ ꠛꠍꠞꠞꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠢꠤꠡꠣꠛꠦ ꠝꠣꠘꠤꠅ। ꠎꠝꠤꠘꠅ ꠎꠦꠔꠣ ꠚꠡꠟ ꠙꠣꠁꠛꠣꠄ, ꠅꠔꠣꠃ ꠔꠥꠝꠞꠣ ꠈꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ꠚꠤꠞꠔ ꠙꠣꠅꠀꠞ ꠛꠍꠞꠅ ꠔꠥꠝꠞꠣ ꠙꠞꠔꠦꠇꠦ ꠎꠣꠞꠎꠤꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠎꠝꠤ-ꠝꠤꠞꠣꠡꠅ ꠚꠤꠞꠤꠀ ꠎꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","ꠘꠤꠎꠞ ꠎꠝꠤ-ꠎꠝꠣ ꠈꠞꠤꠖ-ꠛꠤꠇꠤꠞ ꠡꠝꠄ ꠔꠥꠝꠞꠣ ꠀꠙꠘ ꠛꠣ ꠙꠞ ꠇꠦꠃꠞꠞ ꠃꠙꠞꠦ ꠎꠥꠞ-ꠎꠛꠞꠖꠡ꠆ꠔꠤ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","ꠎꠝꠤ ꠈꠞꠤꠖ ꠇꠞꠣꠞ ꠡꠝꠄ ꠈꠞꠤꠖ-ꠛꠤꠇꠤ ꠇꠞꠞꠣ ꠖꠥꠁꠅ ꠎꠘꠦ ꠈꠤꠀꠟ ꠞꠣꠈꠛꠣꠄ, ꠚꠤꠞꠔ ꠀꠅꠀꠞ ꠢꠃ ꠙꠁꠘ꠆ꠌꠣꠡ ꠛꠍꠞ ꠛꠣꠖꠦ ꠇꠔꠖꠤꠘ ꠉꠦꠍꠦꠉꠤ, ꠀꠞ ꠍꠣꠝꠘꠞ ꠙꠁꠘ꠆ꠌꠣꠡ ꠛꠍꠞ ꠙꠥꠞꠔꠦ ꠇꠔꠖꠤꠘ ꠛꠣꠇꠤ ꠀꠍꠦ, ꠅꠈꠣꠘ ꠢꠤꠡꠣꠛ ꠇꠞꠤꠀ ꠎꠝꠤꠘꠞ ꠖꠞꠖꠣꠝ ꠑꠤꠇ ꠇꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","ꠎꠥꠖꠤ ꠛꠦꠡꠤ ꠛꠍꠞ ꠚꠡꠟ ꠙꠣꠅꠀꠞ ꠡꠝꠄ ꠕꠣꠇꠦ ꠔꠦ ꠖꠣꠝꠅ ꠛꠦꠡꠤ ꠅꠁꠛ, ꠀꠞ ꠇꠝ ꠅꠁꠟꠦ ꠖꠣꠝꠅ ꠇꠝꠛ। ꠀꠍꠟꠦ ꠚꠡꠟ ꠙꠣꠅꠀꠞ ꠛꠍꠞꠞ ꠃꠙꠞꠦꠃ ꠈꠞꠤꠖ-ꠛꠤꠇꠤꠞ ꠖꠣꠝ ꠑꠤꠇ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠡꠝꠣꠎꠞ ꠇꠦꠃꠞꠞ ꠃꠙꠞꠦ ꠎꠥꠞ-ꠎꠥꠟꠥꠝ ꠇꠞꠤꠅ ꠘꠣ। ꠙꠞꠔꠦꠇ ꠎꠘꠃ ꠀꠟ꠆ꠟꠣꠞ ꠒꠞ-ꠈꠚꠦ ꠌꠟꠤꠅ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠛꠣꠔꠣꠁꠟ ꠡꠞꠤꠅꠔ ꠀꠞ ꠢꠇꠟ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠢꠣꠝꠦꠡꠣ ꠝꠣꠘꠤꠅ। ꠔꠦꠃ ꠔꠥꠝꠞꠣꠞ ꠖꠦꠡ ꠅꠁꠛ ꠘꠤꠞꠣꠙꠖ ꠛꠡꠔ ꠈꠣꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠈꠦꠔꠞ ꠎꠝꠤꠘ ꠕꠣꠇꠤ ꠡꠥꠟ꠆ꠟꠀꠘꠣ ꠚꠡꠟ ꠙꠣꠁꠛꠣꠄ, ꠙꠣꠁꠀ ꠙꠦꠐ ꠜꠞꠤ ꠈꠣꠁꠀ ꠖꠣꠁꠀ ꠢꠘꠅ ꠘꠤꠞꠣꠙꠖꠦ ꠛꠡꠔ ꠇꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","ꠔꠥꠝꠞꠣ ꠝꠘꠦ ꠝꠘꠦ ꠇꠁꠔꠣꠄ ꠙꠣꠞ, ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠛꠍꠞꠅ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠈꠦꠔ ꠘꠣ ꠇꠞꠤ ꠀꠞ ꠚꠡꠟ ꠘꠣ ꠇꠣꠐꠤ, ꠔꠦ ꠀꠝꠞꠣ ꠈꠣꠁꠝꠥ ꠇꠤꠔꠣ? ");
INSERT INTO syls_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","ꠄꠞ ꠎꠥꠀꠙ ꠅꠁꠟ, ꠍꠄ ꠘꠝ꠆ꠛꠞ ꠛꠍꠞꠅ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠎꠝꠤꠘꠅ ꠅꠟꠣ ꠞꠢꠝ-ꠛꠞꠇꠔ ꠖꠤꠝꠥ, ꠎꠝꠤꠘꠅ ꠔꠤꠘ ꠛꠍꠞꠞ ꠢꠝꠣꠘ ꠚꠡꠟ ꠙꠣꠁꠀ ꠈꠣꠁꠀ-ꠚꠤꠘ꠆ꠖꠤꠀ ꠛꠣꠌꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","ꠄꠞꠟꠣꠉꠤ ꠀꠐ ꠘꠝ꠆ꠛꠞ ꠛꠍꠞꠅ ꠈꠦꠔ ꠇꠞꠣꠞ ꠛꠤꠌ ꠛꠣꠁꠘ ꠖꠦꠅꠀꠞ ꠡꠝꠄꠅ ꠅꠃ ꠙꠥꠞꠣꠘꠣ ꠚꠡꠟ ꠈꠣꠁꠛꠣꠄ, ꠀꠞ ꠘꠄ ꠘꠝ꠆ꠛꠞ ꠛꠍꠞꠞ ꠚꠡꠟ ꠖꠣꠁꠛꠣꠞ ꠀꠉ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠅꠃ ꠚꠡꠟꠦꠃ ꠔꠥꠝꠞꠣꠞ ꠈꠣꠘꠤ-ꠈꠥꠞꠣꠇꠤ ꠌꠟꠛ। ");
INSERT INTO syls_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠌꠤꠞꠇꠣꠟꠞ ꠟꠣꠉꠤ ꠇꠦꠃꠞꠞ ꠎꠝꠤ-ꠎꠝꠣ ꠈꠞꠤꠖ-ꠛꠤꠇꠤ ꠌꠟꠔ ꠘꠣꠄ। ꠀꠍꠟꠦ ꠢꠇꠟ ꠎꠝꠤꠘꠞ ꠝꠣꠟꠤꠇ ꠔ ꠀꠝꠤ ꠀꠟ꠆ꠟꠣ, ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠢꠘꠅ ꠈꠣꠟꠤ ꠜꠤꠘ-ꠖꠦꠡꠤ ꠝꠥꠍꠣꠚꠤꠞ। ");
INSERT INTO syls_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","ꠔꠥꠝꠞꠣ ꠙꠞꠔꠦꠇ ꠎꠘꠞ ꠈꠞꠤꠖꠣ ꠎꠝꠤ-ꠝꠤꠞꠣꠡ ꠛꠤꠇꠤꠖꠣꠞꠞꠦ ꠢꠤꠞꠛꠣꠞ ꠚꠤꠞꠔ ꠘꠤꠛꠣꠞ ꠡꠥꠎꠥꠉ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","ꠔꠥꠝꠞꠣꠞ ꠎꠣꠔꠤꠞ ꠇꠥꠘꠥ ꠜꠣꠁ ꠅꠜꠣꠛꠅ ꠙꠠꠤꠀ ꠎꠥꠖꠤ ꠔꠣꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠎꠝꠤꠘꠞ ꠇꠤꠍꠥ ꠅꠋꠡ ꠛꠦꠌꠤꠟꠣꠄ, ꠔꠦ ꠔꠣꠞ ꠢꠇꠟ ꠕꠣꠇꠤ ꠀꠙꠘ ꠎꠘꠦ ꠀꠁꠀ ꠅꠃ ꠛꠦꠌꠣ ꠎꠝꠤ ꠍꠣꠠꠣꠁꠀ ꠘꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","ꠇꠦꠃꠞꠞ ꠎꠥꠖꠤ ꠍꠣꠠꠣꠁꠀ ꠘꠤꠛꠣꠞ ꠝꠣꠘꠥꠡ ꠘꠣ ꠕꠣꠇꠦ, ꠔꠦ ꠢꠦ ꠘꠤꠎꠦ ꠗꠘ-ꠍꠣꠝꠣꠘꠣ ꠎꠝꠣꠁꠀ ꠢꠣꠞꠤ ꠘꠤꠎꠦꠃ ꠎꠥꠖꠤ ꠍꠣꠠꠣꠁꠀ ꠘꠤꠔ ꠌꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","ꠔꠦ ꠔꠣꠞ ꠛꠤꠇꠤꠞ ꠛꠍꠞ ꠕꠣꠇꠤ ꠍꠣꠠꠣꠘꠤ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠡꠝꠄ ꠢꠤꠡꠣꠛ ꠇꠞꠤꠀ, ꠝꠣꠟꠤꠇꠞ ꠙꠣꠅꠘꠣ ꠐꠦꠇꠣ ꠖꠤꠀ ꠔꠣꠞ ꠎꠝꠤ ꠚꠤꠞꠔ ꠘꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","ꠅꠁꠟꠦ ꠎꠝꠤ ꠚꠤꠞꠔ ꠘꠤꠛꠣꠞ ꠍꠣꠝꠣꠘꠣ ꠢꠦ ꠎꠝꠣꠁꠔꠦ ꠘꠣ ꠙꠣꠞꠟꠦ, ꠔꠣꠞ ꠛꠦꠌꠣ ꠎꠝꠤꠘ ꠚꠤꠞꠔ ꠙꠣꠅꠀꠞ ꠢꠃ ꠙꠁꠘ꠆ꠌꠣꠡ ꠛꠍꠞ ꠙꠥꠞꠣꠞ ꠀꠉ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠈꠞꠤꠖꠖꠣꠞꠦ ꠈꠣꠁꠛꠣ, ꠀꠞ ꠙꠁꠘ꠆ꠌꠣꠡ ꠛꠍꠞꠞ ꠇꠣꠟꠅ ꠔꠣꠞꠦ ꠚꠤꠞꠔ ꠖꠤꠛꠣ, ꠢꠦ ꠔꠣꠞ ꠎꠝꠤꠘ ꠄꠝꠘꠦꠃ ꠛꠤꠘꠣ ꠙꠄꠡꠣꠄ ꠚꠤꠞꠔ ꠙꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ꠀꠞ ꠛꠣꠃꠘ꠆ꠒꠞꠤ ꠇꠞꠣ ꠘꠤꠞꠣꠙꠖ ꠐꠣꠃꠘꠞ ꠇꠥꠘꠥ ꠛꠣꠡꠣ-ꠛꠣꠠꠤ ꠎꠥꠖꠤ ꠇꠦꠃ ꠛꠦꠌꠤꠟꠣꠄ, ꠔꠦ ꠛꠦꠌꠣꠞ ꠛꠣꠖꠦ ꠙꠥꠞꠣ ꠄꠇ ꠛꠍꠞꠞ ꠝꠣꠎꠦ ꠢꠦ ꠅꠃ ꠛꠣꠠꠤ ꠚꠤꠞꠔ ꠘꠤꠔ ꠙꠣꠞꠛ। ꠙꠥꠞꠣ ꠄꠇ ꠛꠍꠞꠞ ꠝꠣꠎꠦ ꠢꠦ ꠚꠤꠞꠔ ꠘꠤꠛꠣꠞ ꠡꠥꠎꠥꠉ ꠙꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","ꠄꠇ ꠛꠍꠞꠞ ꠝꠣꠎꠦ ꠁꠐꠣ ꠚꠤꠞꠔ ꠘꠣ ꠘꠤꠟꠦ, ꠌꠤꠞꠇꠣꠟꠞ ꠟꠣꠉꠤ ꠅꠃ ꠛꠣꠠꠤ ꠈꠞꠤꠖꠖꠣꠞ ꠀꠞ ꠔꠣꠞ ꠅꠀꠞꠤꠡꠞ ꠅꠁꠛ। ꠚꠤꠞꠔ ꠙꠣꠅꠀꠞ ꠛꠍꠞꠅ ꠁꠐꠣ ꠚꠤꠞꠔ ꠙꠣꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","ꠅꠁꠟꠦ ꠎꠦꠔꠣ ꠉꠣꠃ-ꠉꠦꠞꠣꠝꠅ ꠇꠥꠘꠥ ꠛꠣꠃꠘ꠆ꠒꠞꠤ ꠘꠣꠄ, ꠅꠃ ꠎꠣꠉꠣꠞ ꠛꠣꠠꠤ-ꠊꠞꠞꠦ ꠈꠦꠔꠞ ꠎꠝꠤꠘꠞ ꠟꠣꠈꠣꠘ ꠝꠘꠅ ꠇꠞꠛꠣꠄ। ꠁꠔꠣ ꠍꠣꠠꠣꠁꠀ ꠀꠘꠣ ꠎꠣꠁꠛ, ꠀꠞ ꠚꠤꠞꠔ ꠙꠣꠅꠀꠞ ꠛꠍꠞꠅ ꠚꠤꠞꠔ ꠖꠤꠔꠦ ꠅꠁꠛꠃ। ");
INSERT INTO syls_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ꠈꠣꠟꠤ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠐꠣꠃꠘꠞ ꠛꠣꠠꠤ-ꠊꠞ ꠅꠇꠟ ꠢꠣꠝꠦꠡꠣ ꠚꠤꠞꠔ ꠀꠘꠣ ꠎꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","ꠔꠣꠞꠣꠞ ꠐꠣꠃꠘꠞ ꠇꠥꠘꠥ ꠛꠣꠠꠤ-ꠊꠞ ꠛꠦꠌꠤꠟꠦ, ꠚꠤꠞꠔ ꠙꠣꠅꠀꠞ ꠛꠍꠞꠅ ꠁꠐꠣ ꠚꠤꠞꠔ ꠙꠣꠁꠛꠣ। ꠔꠥꠝꠞꠣꠞ ꠔ ꠎꠣꠘꠣ ꠀꠍꠦ, ꠈꠣꠟꠤ ꠐꠣꠃꠘꠞ ꠛꠣꠠꠤ-ꠊꠞꠃ ꠅꠁꠟ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠝ꠆ꠙꠔ꠆ꠔꠤ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠎꠦ ꠔꠣꠞꠣ ꠅꠃ ꠡꠝ꠆ꠙꠔ꠆ꠔꠤꠃ ꠙꠣꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","ꠅꠁꠟꠦ ꠔꠣꠞꠣꠞ ꠐꠣꠃꠘꠞ ꠗꠣꠞꠅ ꠙꠡꠥ ꠞꠣꠈꠣꠞ ꠛꠘ꠆ꠖꠞ ꠎꠣꠉꠣ ꠔꠣꠞꠣ ꠈꠞꠤꠖ-ꠛꠤꠇꠤ ꠇꠞꠔꠣ ꠙꠣꠞꠔꠣ ꠘꠣꠄ, ꠁꠔꠣ ꠔ ꠔꠣꠞꠣꠞ ꠌꠤꠞꠇꠣꠟꠤꠘ ꠡꠝ꠆ꠙꠔ꠆ꠔꠤ। ");
INSERT INTO syls_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ꠔꠥꠝꠞꠣꠞ ꠘꠤꠎꠞ ꠡꠝꠣꠎꠞ ꠇꠥꠘꠥ ꠜꠣꠁ ꠎꠥꠖꠤ ꠉꠞꠤꠛꠤ ꠢꠣꠟꠔꠞ ꠟꠣꠉꠤ ꠔꠣꠞ ꠘꠤꠎꠞ ꠈꠣꠅꠀ-ꠚꠤꠘ꠆ꠖꠣ ꠎꠥꠉꠣꠁꠔ ꠘꠣ ꠙꠣꠞꠦ, ꠔꠦ ꠜꠤꠘ-ꠖꠦꠡꠤ ꠝꠥꠍꠣꠚꠤꠞꠞ ꠟꠣꠈꠣꠘ ꠔꠣꠞꠦꠅ ꠡꠣꠁꠎ꠆ꠎ ꠇꠞꠤꠅ, ꠎꠣꠔꠦ ꠢꠦ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠛꠡꠔ ꠇꠞꠔ ꠙꠣꠞꠦ। ");
INSERT INTO syls_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","ꠔꠥꠝꠞꠣ ꠔꠣꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠇꠥꠘꠥ ꠘꠝꠥꠘꠣꠞ ꠡꠥꠖ ꠈꠣꠁꠅ ꠘꠣ। ꠛꠞꠋ ꠢꠦ ꠎꠣꠔꠦ ꠢꠣꠝꠦꠡꠣ ꠔꠥꠝꠞꠣꠞ ꠉꠦꠍꠦ ꠞꠁꠛꠣꠞ ꠡꠥꠎꠥꠉ ꠙꠣꠄ, ꠅꠃ ꠘꠤꠅꠔꠦ ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠒꠞ-ꠈꠚ ꠜꠤꠔꠞꠦ ꠞꠣꠈꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","ꠔꠥꠝꠞꠣ ꠡꠥꠖ ꠈꠣꠁꠛꠣꠞ ꠘꠤꠅꠔꠦ ꠔꠣꠞꠦ ꠐꠦꠇꠣ-ꠙꠄꠡꠣ ꠇꠞ꠆ꠎ ꠖꠤꠅ ꠘꠣ। ꠔꠣꠞ ꠉꠦꠍꠦ ꠈꠣꠘꠤ-ꠈꠥꠞꠣꠇꠤꠞ ꠝꠣꠟ ꠛꠦꠌꠟꠦ ꠁꠔꠣꠞ ꠟꠣꠜ ꠟꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ। ꠀꠡ꠆ꠔꠣ ꠇꠦꠘꠣꠘ ꠖꠦꠡ ꠖꠣꠘ ꠇꠞꠣꠞ ꠈꠤꠀꠟꠦ, ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠀꠙꠘ ꠝꠣꠛꠥꠖ ꠅꠀꠞ ꠈꠤꠀꠟꠦ, ꠀꠝꠤꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠤ ꠡꠝꠣꠎꠞ ꠇꠥꠘꠥ ꠜꠣꠁ ꠎꠥꠖꠤ ꠉꠞꠤꠛꠤ ꠢꠣꠟꠔꠅ ꠙꠠꠤꠀ ꠘꠤꠎꠦ ꠘꠤꠎꠦ ꠔꠥꠝꠞꠣꠞ ꠇꠦꠃꠞꠞ ꠉꠦꠍꠦ ꠛꠤꠇꠤ ꠈꠣꠁꠟꠣꠄ, ꠔꠦ ꠔꠣꠞꠦ ꠈꠞꠤꠖꠣ ꠉꠥꠟꠣꠝꠞ ꠟꠣꠈꠣꠘ ꠈꠣꠐꠣꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","ꠔꠥꠝꠞꠣꠞ ꠝꠥꠍꠣꠚꠤꠞ ꠀꠞ ꠞꠥꠎꠤ ꠇꠣꠝꠟꠣꠞ ꠟꠉꠦ ꠎꠦꠟꠣ ꠛꠦꠛꠢꠣꠞ ꠇꠞꠅ, ꠔꠣꠞ ꠟꠉꠦꠅ ꠅꠟꠣ ꠇꠞꠤꠅ। ꠢꠦ ꠢꠃ ꠚꠤꠞꠔ ꠙꠣꠅꠀꠞ ꠛꠍꠞ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠔꠥꠝꠣꠞ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠛ। ");
INSERT INTO syls_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","ꠛꠣꠖꠦ ꠔꠣꠞꠦ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀ-ꠙꠥꠠꠤꠞꠦ ꠀꠎꠣꠖ ꠇꠞꠤ ꠖꠤꠅ। ꠔꠦꠃ ꠢꠦ ꠔꠣꠞ ꠘꠤꠎꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤꠞ ꠎꠝꠤꠘꠅ ꠚꠤꠞꠔ ꠎꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","ꠢꠥꠘꠅ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠔ ꠈꠣꠟꠤ ꠀꠝꠣꠞ ꠉꠥꠟꠣꠝ। ꠀꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠀꠎꠣꠖ ꠇꠞꠤ ꠀꠘꠍꠤ, ꠄꠞꠟꠣꠉꠤ ꠖꠥꠍꠞꠣ ꠇꠦꠃꠞꠞ ꠉꠥꠟꠣꠝꠤꠞ ꠟꠣꠉꠤ ꠔꠣꠞꠣꠞꠦ ꠛꠦꠌꠣꠞ ꠄꠈꠔꠤꠀꠞ ꠘꠣꠁ। ");
INSERT INTO syls_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠝꠣꠛꠥꠖꠞ ꠒꠞ-ꠈꠚꠦ ꠌꠟꠤꠅ, ꠄꠇꠦ-ꠅꠁꠘ꠆ꠘꠦ ꠙꠣꠡꠣꠘ-ꠘꠤꠡ꠆ꠐꠥꠞ ꠛꠦꠛꠢꠣꠞ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ꠔꠥꠝꠞꠣꠞ ꠀꠞꠤ-ꠚꠞꠤ ꠎꠔ ꠎꠣꠔꠤ ꠀꠍꠂꠘ, ꠅꠔꠣꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣꠞ ꠉꠥꠟꠣꠝ-ꠛꠣꠘ꠆ꠖꠤ ꠘꠤꠔꠣꠄ ꠙꠣꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","ꠔꠥꠝꠞꠣꠞ ꠝꠣꠎꠦ ꠛꠡꠔ ꠇꠞꠞꠣ ꠜꠤꠘ ꠎꠣꠔꠤꠞ ꠝꠣꠘꠥꠡ ꠕꠣꠇꠤ, ꠀꠞ ꠔꠣꠞꠣꠞ ꠎꠦꠔꠣ ꠀꠅꠟꠣꠖ ꠔꠥꠝꠞꠣꠞ ꠖꠦꠡꠅ ꠎꠘꠝꠤꠍꠂꠘ, ꠅꠔꠣꠞ ꠝꠣꠎ ꠕꠣꠇꠤꠅ ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠟꠣꠉꠤ ꠉꠥꠟꠣꠝ-ꠛꠣꠘ꠆ꠖꠤ ꠘꠤꠔꠣꠄ ꠙꠣꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","ꠅꠃ ꠟꠣꠈꠣꠘ ꠉꠥꠟꠣꠝ-ꠛꠣꠘ꠆ꠖꠤꠞꠦ ꠘꠤꠎꠞ ꠍꠣꠝꠣꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠔꠥꠝꠞꠣꠞ ꠙꠥꠀ-ꠙꠥꠠꠤꠘꠞꠦꠅ ꠖꠤꠀ ꠎꠣꠁꠔꠣꠄ ꠙꠣꠞꠛꠣꠄ। ꠁꠔꠣꠞꠦ ꠢꠣꠞꠣ ꠎꠤꠘ꠆ꠖꠦꠉꠤ ꠔꠥꠝꠞꠣꠞ ꠉꠥꠟꠣꠝꠤ ꠇꠞꠣꠁꠔꠣꠄ ꠙꠣꠞꠛꠣꠄ, ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣꠞ ꠘꠤꠎꠞ ꠎꠣꠔꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠃꠙꠞꠦ ꠙꠣꠡꠣꠘ ꠝꠣꠟꠤꠇꠣꠘꠣ ꠈꠣꠐꠣꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ꠔꠥꠝꠞꠣꠞ ꠝꠣꠎꠦ ꠛꠡꠔ ꠇꠞꠞꠣ ꠜꠤꠘ-ꠖꠦꠡꠤ ꠇꠥꠘꠥ ꠝꠣꠘꠥꠡ ꠎꠥꠖꠤ ꠗꠘꠤ ꠛꠘꠤꠎꠣꠄ, ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠇꠥꠘꠥ ꠜꠣꠁ ꠎꠥꠖꠤ ꠅꠜꠣꠛꠅ ꠙꠠꠤꠀ ꠔꠣꠞ ꠉꠦꠍꠦ ꠛꠣ ꠔꠣꠞ ꠇꠥꠘꠥ ꠀꠅꠟꠣꠖꠞ ꠉꠦꠍꠦ ꠘꠤꠎꠞꠦ ꠛꠦꠌꠤꠟꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ꠔꠦ ꠢꠦ ꠘꠤꠎꠞꠦ ꠀꠎꠣꠖ ꠇꠞꠣꠞ ꠡꠥꠎꠥꠉ ꠙꠣꠁꠛ। ꠔꠣꠞ ꠘꠤꠎꠞ ꠇꠥꠘꠥ ꠜꠣꠁꠄ ꠔꠣꠞꠦ ꠀꠎꠣꠖ ꠇꠞꠔ ꠙꠣꠞꠛ। ");
INSERT INTO syls_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ꠔꠣꠞ ꠌꠣꠌꠣ ꠛꠣ ꠌꠣꠌꠣꠞ ꠊꠞꠞ ꠜꠣꠁꠄ, ꠛꠣ ꠔꠣꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠀꠙꠘ ꠎꠦꠇꠥꠘꠥ ꠎꠘꠦ ꠔꠣꠞꠦ ꠀꠎꠣꠖ ꠇꠞꠣꠁꠔꠣ ꠙꠣꠞꠛꠣ। ꠘꠤꠎꠞ ꠢꠣꠟꠔ ꠛꠖꠟꠣꠁꠟꠤꠔꠦ ꠙꠣꠞꠟꠦ, ꠢꠦ ꠘꠤꠎꠞꠦ ꠘꠤꠎꠦ ꠀꠎꠣꠖ ꠇꠞꠔ ꠙꠣꠞꠛ। ");
INSERT INTO syls_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","ꠎꠦ ꠛꠍꠞ ꠘꠤꠎꠞꠦ ꠛꠦꠌꠤꠍꠤꠟ ꠅꠃ ꠛꠍꠞ ꠕꠣꠇꠤ ꠢꠤꠡꠣꠛ ꠇꠞꠤꠀ ꠚꠤꠞꠔ ꠀꠅꠀꠞ ꠛꠍꠞ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠎꠔ ꠛꠍꠞ ꠛꠣꠇꠤ ꠕꠣꠇꠦ ꠅꠃ ꠡꠝꠄꠇꠥꠞ ꠇꠣꠝꠞ ꠛꠦꠔꠘꠞ ꠢꠤꠡꠣꠛ-ꠘꠤꠇꠣꠡ ꠝꠣꠚꠤꠇ ꠔꠣꠞ ꠀꠎꠣꠖꠤꠞ ꠖꠣꠝ ꠑꠤꠇ ꠇꠞꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","ꠚꠤꠞꠔ ꠙꠣꠅꠀꠞ ꠛꠍꠞ ꠎꠥꠖꠤ ꠛꠦꠡꠤ ꠖꠥꠞꠁ ꠅꠄ, ꠔꠦ ꠎꠦ ꠖꠣꠝꠦ ꠢꠦ ꠘꠤꠎꠞꠦ ꠛꠦꠌꠤꠍꠤꠟ, ꠅꠃ ꠖꠣꠝꠞ ꠛꠠ ꠄꠇ ꠅꠋꠡ ꠔꠣꠞ ꠀꠎꠣꠖꠤꠞ ꠛꠖꠟꠣ ꠢꠤꠡꠣꠛꠦ ꠖꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","ꠀꠞ ꠚꠤꠞꠔ ꠙꠣꠅꠀꠞ ꠛꠍꠞ ꠀꠁꠔꠦ ꠎꠥꠖꠤ ꠇꠝ ꠡꠝꠄ ꠛꠣꠇꠤ ꠞꠄ, ꠔꠦ ꠅꠃ ꠡꠝꠄ ꠢꠤꠡꠣꠛꠦ ꠐꠦꠇꠣ ꠖꠤꠀ ꠢꠦ ꠘꠤꠎꠞꠦ ꠀꠎꠣꠖ ꠇꠞꠔ ꠙꠣꠞꠛ। ");
INSERT INTO syls_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","ꠔꠣꠞꠦ ꠛꠍꠞ ꠌꠥꠇ꠆ꠔꠤ ꠇꠣꠝꠟꠣꠞ ꠟꠣꠈꠣꠘ ꠖꠦꠈꠤꠅ, ꠀꠞ ꠈꠤꠀꠟ ꠞꠣꠈꠤꠅ, ꠝꠣꠟꠤꠇꠦ ꠎꠣꠘꠥ ꠔꠣꠞ ꠟꠉꠦ ꠙꠣꠡꠣꠘ ꠛꠦꠛꠢꠣꠞ ꠘꠣ ꠇꠞꠦ। ");
INSERT INTO syls_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","ꠅꠟꠣ ꠇꠥꠘꠥ ꠟꠣꠈꠣꠘ ꠃꠙꠣꠄꠄ ꠎꠥꠖꠤ ꠢꠦ ꠀꠎꠣꠖ ꠅꠁꠔ ꠘꠣ ꠙꠣꠞꠦ, ꠔꠦ ꠔꠣꠞꠦ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀ-ꠙꠥꠠꠤꠞꠦ ꠚꠤꠞꠔ ꠙꠣꠅꠀ ꠛꠍꠞꠞ ꠡꠝꠄ ꠄꠝꠘꠦꠃ ꠀꠎꠣꠖ ꠇꠞꠤ ꠖꠤꠟꠣꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠔ ꠈꠣꠟꠤ ꠀꠝꠣꠞ ꠉꠥꠟꠣꠝ। ꠀꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠀꠎꠣꠖ ꠇꠞꠤ ꠀꠘꠍꠤ, ꠔꠣꠞꠣ ꠈꠣꠟꠤ ꠀꠝꠣꠞ। ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ꠔꠥꠝꠞꠣ ꠇꠥꠘꠥ ꠘꠝꠥꠘꠣꠞ ꠖꠦꠛ-ꠖꠦꠛꠤꠞ ꠝꠥꠞ꠆ꠔꠤ ꠛꠣꠘꠣꠁꠅ ꠘꠣ। ꠟꠣꠇꠠꠤꠖꠤ ꠛꠣꠘꠣꠁꠟ ꠝꠥꠞ꠆ꠔꠤ, ꠛꠣ ꠇꠥꠘꠥꠎꠣꠔ ꠙꠣꠔ꠆ꠔꠞꠞꠦ ꠖꠦꠛꠔꠣ ꠢꠤꠡꠣꠛꠦ ꠛꠅꠀꠁꠟ ꠇꠞꠤꠅ ꠘꠣ। ꠙꠥꠎꠣꠞ ꠘꠤꠅꠔꠦ ꠙꠣꠔ꠆ꠔꠞ ꠈꠥꠖꠤꠀ ꠛꠣꠘꠣꠁꠟ ꠇꠥꠘꠥꠎꠣꠔ ꠝꠥꠞ꠆ꠔꠤ ꠔꠥꠝꠞꠣꠞ ꠖꠦꠡꠞ ꠝꠣꠎꠦ ꠞꠣꠈꠤꠅ ꠘꠣ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","ꠀꠝꠣꠞ ꠖꠦꠅꠀ ꠙꠞꠔꠦꠇ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞ ꠔꠥꠝꠞꠣ ꠝꠣꠘꠤꠅ, ꠀꠝꠣꠞ ꠙꠛꠤꠔ꠆ꠞ ꠇꠣꠛꠣ ꠊꠞꠞꠦ ꠔꠥꠝꠞꠣ ꠁꠎ꠆ꠎꠔ ꠇꠞꠤꠅ। ꠀꠝꠤꠃ ꠔ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ꠔꠥꠝꠞꠣ ꠎꠥꠖꠤ ꠀꠝꠣꠞ ꠢꠇꠟ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠀꠞ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠝꠣꠘꠤꠀ ꠀꠝꠟ ꠇꠞꠅ, ");
INSERT INTO syls_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ꠔꠦ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠑꠤꠇꠝꠔ ꠝꠦꠊ-ꠙꠣꠘꠤ ꠖꠤꠝꠥ। ꠔꠦꠃ ꠔꠥꠝꠞꠣꠞ ꠎꠝꠤꠘꠅ ꠚꠄ-ꠚꠡꠟ ꠚꠟꠤꠛ ꠀꠞ ꠉꠣꠍ-ꠉꠣꠍꠣꠟꠤꠄꠅ ꠚꠟ-ꠝꠥꠟ ꠖꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","ꠔꠥꠝꠞꠣꠞ ꠈꠦꠔꠞ ꠚꠄ-ꠚꠡꠟ ꠅꠔ ꠛꠦꠡꠤ ꠅꠁꠛ ꠎꠦꠘ, ꠀꠋꠉꠥꠞ ꠔꠥꠟꠣꠞ ꠡꠝꠄ ꠀꠎꠤꠟꠦꠅ, ꠔꠥꠝꠞꠣꠞ ꠚꠡꠟ ꠝꠣꠠꠣ ꠖꠦꠅꠀꠔ ꠞꠁꠛꠣꠄ। ꠀꠞ ꠎꠝꠤꠘꠞ ꠝꠣꠎꠦ ꠘꠄꠀ ꠛꠤꠌ ꠛꠣꠁꠘ ꠖꠦꠅꠀꠞ ꠡꠝꠄ ꠀꠎꠤꠟꠦꠅ, ꠅꠃ ꠡꠝꠄ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠀꠋꠉꠥꠞ ꠔꠥꠟꠣꠔ ꠞꠁꠛꠣꠄ। ꠔꠥꠝꠞꠣ ꠙꠦꠐ ꠜꠞꠤꠀ ꠈꠣꠘꠣ-ꠙꠤꠘꠣ ꠈꠣꠁꠛꠣꠄ, ꠀꠞ ꠘꠤꠞꠣꠙꠖꠦ ꠘꠤꠎꠞ ꠛꠣꠠꠤꠔ ꠛꠡꠔ ꠇꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠖꠦꠡꠅ ꠡꠣꠘ꠆ꠔꠤ ꠖꠤꠝꠥ, ꠔꠥꠝꠞꠣ ꠡꠣꠘ꠆ꠔꠤꠄ ꠊꠥꠝꠣꠁꠛꠣꠄ, ꠇꠦꠃ ꠀꠁꠀ ꠔꠥꠝꠞꠣꠞꠦ ꠇꠥꠘꠥ ꠒꠞ-ꠈꠚ ꠖꠦꠈꠣꠁꠔ ꠘꠣꠄ। ꠔꠥꠝꠞꠣꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠢꠇꠟ ꠎꠣꠔꠞ ꠢꠤꠋꠡ꠆ꠞ ꠎꠣꠘꠥꠀꠞꠞꠦ ꠀꠝꠤ ꠈꠦꠖꠣꠁ ꠖꠤꠝꠥ, ꠀꠞ ꠇꠥꠘꠥ ꠍꠤꠙꠣꠁ ꠖꠟꠦꠅ ꠔꠥꠝꠞꠣꠞ ꠖꠦꠡꠅ ꠢꠣꠝꠟꠣ ꠇꠞꠣꠔ ꠀꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","ꠔꠥꠝꠞꠣꠞ ꠖꠥꠡꠝꠘ ꠅꠇꠟꠞꠦ ꠈꠦꠖꠣꠁꠀ ꠘꠤꠛꠣꠄ, ꠔꠥꠝꠞꠣꠞ ꠌꠈꠥꠞ ꠍꠣꠝꠘꠦ ꠔꠣꠞꠣꠞ ꠝꠞꠘ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","ꠔꠥꠝꠞꠣꠞ ꠈꠣꠟꠤ ꠙꠣꠌ ꠎꠘ ꠍꠤꠙꠣꠁꠄ ꠄꠇ-ꠡ ꠖꠥꠡꠝꠘꠞꠦ, ꠀꠞ ꠄꠇ-ꠡ ꠍꠤꠙꠣꠁꠄ ꠖꠡ ꠀꠎꠣꠞ ꠎꠘꠞꠦ ꠈꠦꠖꠣꠁꠀ ꠘꠤꠛꠣꠄ, ꠔꠥꠝꠞꠣꠞ ꠖꠥꠡꠝꠘ ꠔꠥꠝꠞꠣꠞ ꠌꠈꠥꠞ ꠍꠣꠝꠘꠦ ꠔꠟꠥꠀꠞꠞ ꠔꠟꠦ ꠝꠞꠛ। ");
INSERT INTO syls_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠄ ꠖꠄꠀꠞ ꠘꠎꠞꠦ ꠌꠣꠁꠝꠥ, ꠔꠥꠝꠞꠣꠞ ꠀꠅꠟꠣꠖ ꠛꠣꠠꠣꠁꠀ ꠔꠥꠝꠞꠣꠞ ꠈꠣꠘ꠆ꠖꠣꠘ ꠛꠠ ꠇꠞꠝꠥ, ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠀꠝꠣꠞ ꠅꠀꠖꠣ-ꠌꠥꠇ꠆ꠔꠤ ꠛꠅꠀꠁꠟ ꠞꠣꠈꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","ꠘꠄꠀ ꠛꠍꠞꠞ ꠚꠡꠟ ꠔꠥꠟꠣꠞ ꠟꠣꠉꠤ ꠃꠉꠣꠞ ꠈꠣꠟꠤ ꠇꠞꠣꠞ ꠀꠉ ꠙꠞ꠆ꠎꠘ꠆ꠔ, ꠀꠉꠞ ꠛꠍꠞꠞ ꠚꠡꠟꠖꠤ ꠔꠥꠝꠞꠣꠞ ꠈꠣꠘꠣ-ꠙꠤꠘꠣ ꠌꠟꠛ। ");
INSERT INTO syls_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","ꠔꠥꠝꠞꠣꠞ ꠛꠣꠄ ꠕꠣꠇꠤ ꠀꠝꠣꠞ ꠝꠥꠈ ꠚꠤꠞꠣꠁꠔꠣꠝ ꠘꠣꠄ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠎꠦꠃ ꠞꠁꠛ ꠀꠝꠣꠞ ꠛꠡꠔ ꠊꠞ। ");
INSERT INTO syls_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠌꠟꠣ-ꠚꠤꠞꠣ ꠇꠞꠝꠥ, ꠀꠝꠤ ꠅꠁꠝꠥ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ, ꠔꠥꠝꠞꠣ ꠅꠁꠛꠣꠄ ꠀꠝꠣꠞ ꠈꠣꠍ ꠙ꠆ꠞꠎꠣ। ");
INSERT INTO syls_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","ꠈꠤꠀꠟ ꠞꠣꠈꠤꠅ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ। ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠀꠝꠤꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠀꠎꠣꠖ ꠇꠞꠤ ꠀꠘꠍꠤ, ꠎꠣꠔꠦ ꠔꠥꠝꠞꠣ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠉꠥꠟꠣꠝꠤ ꠇꠞꠣ ꠘꠣ ꠟꠣꠉꠦ। ꠔꠥꠝꠞꠣꠞ ꠉꠞ꠆ꠖꠘꠣ ꠕꠣꠇꠤ ꠎꠥꠀꠟ ꠜꠣꠋꠉꠤꠀ ꠚꠣꠟꠣꠁꠀ, ꠝꠣꠕꠣ ꠃꠌꠣ ꠇꠞꠤ ꠀꠐꠤꠛꠣꠞ ꠢꠣꠟꠔꠅ ꠀꠝꠤꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠀꠘꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣ ꠎꠥꠖꠤ ꠀꠝꠣꠞ ꠇꠕꠣ ꠘꠣ ꠢꠥꠘꠅ, ꠀꠝꠣꠞ ꠅꠃ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠘꠣ ꠝꠣꠘꠅ, ");
INSERT INTO syls_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ꠀꠝꠣꠞ ꠛꠣꠔꠣꠁꠟ ꠀꠁꠘ-ꠇꠣꠘꠥꠘꠞꠦ ꠘꠣꠙꠍꠘ꠆ꠖ ꠇꠞꠅ, ꠀꠝꠣꠞ ꠖꠦꠅꠀ ꠡꠞꠤꠅꠔꠞꠦ ꠄꠟꠣꠝꠤ ꠇꠞꠅ, ꠀꠞ ꠀꠝꠣꠞ ꠢꠥꠇꠥꠝ ꠘꠣ ꠝꠣꠘꠤꠀ, ꠀꠝꠣꠞ ꠅꠀꠖꠣ-ꠌꠥꠇ꠆ꠔꠤꠞ ꠃꠟꠐꠣ ꠌꠟꠅ, ");
INSERT INTO syls_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ꠔꠦ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠃꠙꠞꠦ ꠅꠟꠣ ꠈꠣꠠꠣ ꠝꠍꠤꠛꠔ ꠖꠤꠝꠥ, ꠔꠥꠝꠞꠣꠞ ꠡꠞꠤꠟ ꠇ꠆ꠇꠄ ꠅꠀꠞ ꠛꠦꠝꠣꠞ ꠖꠤꠝꠥ, ꠉꠎꠛꠤ ꠎꠇ꠆ꠇꠣ ꠛꠦꠝꠣꠞ ꠀꠞ ꠛꠦꠎꠥꠁꠔꠣ ꠔꠣꠙ ꠅꠁꠛ, ꠅꠔꠣ ꠛꠦꠝꠣꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠌꠈꠥꠞ ꠙꠣꠅꠀꠞ ꠇ꠆ꠇꠄ ꠅꠁꠛ, ꠡꠞꠤꠟꠞ ꠇꠝꠎꠥꠞꠤ ꠀꠁꠛ। ꠔꠥꠝꠞꠣ ꠎꠝꠤꠘꠅ ꠈꠦꠔ ꠇꠞꠟꠦꠅ ꠚꠣꠄꠖꠣ ꠅꠁꠔ ꠘꠣꠄ, ꠔꠥꠝꠞꠣꠞ ꠚꠡꠟ ꠖꠥꠡꠝꠘꠦ ꠈꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠈꠦꠔꠤ ꠇꠞꠣꠔ ꠟꠣꠉꠤꠎꠤꠝꠥ, ꠀꠞ ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠖꠥꠡꠝꠘꠞ ꠉꠦꠍꠦ ꠀꠞꠤꠛꠣꠄ। ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦꠔꠣꠄ ꠁꠋꠡꠣ ꠇꠞꠂꠘ, ꠅꠔꠣꠄ ꠔꠥꠝꠞꠣꠞꠦ ꠡꠣꠡꠘ ꠇꠞꠛꠣ, ꠀꠞ ꠇꠦꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠘꠣ ꠈꠦꠖꠣꠁꠟꠦꠅ, ꠔꠥꠝꠞꠣ ꠎꠣꠘꠞ ꠒꠞꠦ ꠄꠝꠘꠦꠃ ꠜꠣꠉꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ꠄꠞꠛꠣꠖꠦꠅ ꠎꠥꠖꠤ ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠇꠕꠣ ꠘꠣ ꠢꠥꠘꠅ, ꠔꠦ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠉꠥꠘꠣꠞ ꠡꠣꠔ ꠉꠥꠘ ꠛꠦꠡꠤ ꠡꠣꠎꠣ ꠖꠤꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠛꠟ-ꠡꠇ꠆ꠔꠤꠞ ꠛꠦꠐꠣꠉꠤꠞꠤ ꠜꠣꠋꠉꠤꠀ ꠌꠥꠞꠝꠣꠞ ꠇꠞꠤꠟꠤꠝꠥ। ꠔꠥꠝꠞꠣꠞ ꠝꠣꠕꠣꠞ ꠃꠙꠞꠞ ꠀꠍꠝꠣꠘꠞꠦ ꠟꠥꠀꠞ ꠟꠣꠈꠣꠘ, ꠀꠞ ꠙꠣꠅꠞ ꠔꠟꠞ ꠝꠣꠐꠤꠞꠦ ꠔꠣꠝꠣꠞ ꠟꠣꠈꠣꠘ ꠡꠇ꠆ꠔ ꠇꠞꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","ꠔꠦꠃ ꠔꠥꠝꠞꠣ ꠅꠔ ꠝꠦꠘꠔ ꠇꠞꠤꠀꠅ ꠇꠥꠘꠥ ꠚꠟ ꠙꠣꠁꠔꠣꠄ ꠘꠣꠄ। ꠈꠦꠔꠞ ꠎꠝꠤꠘꠅ ꠚꠡꠟ ꠗꠞꠔ ꠘꠣꠄ, ꠉꠣꠍ-ꠉꠣꠍꠣꠟꠤꠔ ꠚꠟ ꠝꠤꠟꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ꠔꠥꠝꠞꠣꠞ ꠖꠤꠟꠞ ꠝꠣꠎꠦ ꠎꠥꠖꠤ ꠀꠝꠣꠞ ꠟꠣꠉꠤ ꠇꠥꠘꠥꠎꠣꠔꠞ ꠖꠥꠡꠝꠘꠤ ꠕꠣꠇꠦ, ꠀꠝꠣꠞ ꠛꠣꠔꠣꠁꠟ ꠢꠥꠇꠥꠝ ꠎꠥꠖꠤ ꠔꠥꠝꠞꠣꠞ ꠇꠣꠘꠅ ꠘꠣ ꠢꠣꠝꠣꠄ, ꠔꠦ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠘꠣꠚꠞꠝꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠡꠣꠔ ꠉꠥꠘ ꠛꠦꠡꠤ ꠡꠣꠎꠣ ꠖꠤꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","ꠔꠥꠝꠞꠣꠞ ꠝꠣꠎꠦ ꠀꠝꠤ ꠢꠤꠋꠡ꠆ꠞ ꠎꠣꠘꠥꠀꠞ ꠙꠣꠑꠣꠁꠝꠥ, ꠁꠔꠣꠄ ꠔꠥꠝꠞꠣꠞ ꠙꠥꠀ-ꠙꠥꠠꠤꠘ꠆ꠔꠞꠦ ꠈꠣꠁꠛꠣ, ꠔꠥꠝꠞꠣꠞ ꠙꠡꠥꠞ ꠙꠣꠟꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠛꠣ, ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠘꠡꠞ ꠙꠞꠤꠝꠣꠘꠅ ꠇꠝꠣꠁꠟꠤꠛꠣ, ꠖꠦꠡꠞ ꠙꠕ-ꠊꠣꠐ ꠈꠣꠟꠤ ꠙꠠꠤ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ꠅꠃ ꠢꠇꠟ ꠊꠐꠘꠣ ꠊꠐꠣꠞ ꠛꠣꠖꠦꠅ ꠔꠥꠝꠞꠣ ꠎꠥꠖꠤ ꠀꠝꠣꠞ ꠀꠁꠘ-ꠇꠣꠘꠥꠘꠞ ꠃꠟꠐꠣ ꠌꠟꠅ, ");
INSERT INTO syls_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ꠔꠦ ꠀꠝꠤ ꠘꠤꠎꠦ ꠔꠥꠝꠞꠣꠞ ꠖꠥꠡꠝꠘ ꠛꠘꠤꠀ, ꠔꠥꠝꠞꠣꠞ ꠉꠥꠘꠣꠞ ꠡꠣꠔ ꠉꠥꠘ ꠛꠦꠡꠤ ꠡꠣꠎꠣ ꠖꠤꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","ꠀꠝꠣꠞ ꠅꠀꠖꠣ-ꠌꠥꠇ꠆ꠔꠤꠞꠦ ꠘꠣ ꠝꠣꠘꠣꠄ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠃꠙꠞꠦ ꠟꠣꠠꠣꠁ-ꠎꠥꠖ꠆ꠖ ꠀꠘꠣꠁꠝꠥ। ꠖꠥꠡꠝꠘꠞꠦ ꠖꠦꠈꠤꠀ ꠔꠥꠝꠞꠣ ꠎꠦꠛꠟꠣ ꠐꠣꠃꠘꠅ ꠉꠤꠀ ꠢꠣꠝꠣꠁꠛꠣꠄ, ꠢꠘꠅ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠃꠙꠞꠦ ꠉꠎꠛꠤ ꠝꠞꠇꠤ ꠍꠣꠠꠤꠝꠥ, ꠔꠦꠃ ꠔꠥꠝꠞꠣ ꠖꠥꠡꠝꠘꠞ ꠀꠔꠅ ꠗꠞꠣ ꠙꠠꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠈꠣꠘꠤ-ꠈꠥꠞꠣꠇꠤꠞ ꠝꠣꠎꠦ ꠅꠜꠣꠛ ꠊꠐꠣꠁꠝꠥ, ꠔꠦꠃ ꠖꠡ ꠎꠘ ꠛꠦꠐꠤꠄ ꠞꠣꠘ꠆ꠖꠤꠔꠦ ꠄꠇ ꠌꠥꠟꠣꠞ ꠛꠦꠡꠤ ꠟꠣꠉꠔ ꠘꠣꠄ। ꠈꠣꠘꠤꠔ ꠛꠁꠀ ꠔꠥꠝꠞꠣ ꠞꠥꠐꠤ ꠝꠣꠙꠤ ꠝꠣꠙꠤ ꠈꠣꠁꠛꠣꠄ, ꠙꠦꠐ ꠜꠞꠣ ꠈꠣꠘꠤ ꠎꠥꠐꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ꠁꠔꠣ ꠢꠇꠟꠔꠣꠞ ꠛꠣꠖꠦꠅ ꠎꠥꠖꠤ ꠀꠝꠣꠞ ꠇꠕꠣ ꠘꠣ ꠢꠥꠘꠤꠀ ꠀꠝꠣꠞ ꠃꠟꠐꠣ ꠌꠟꠅ, ");
INSERT INTO syls_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ꠔꠦ ꠀꠝꠤ ꠉꠥꠍꠣꠄ ꠀꠉꠥꠁꠘ ꠅꠁꠀ ꠀꠝꠤꠅ ꠔꠥꠝꠞꠣꠞ ꠃꠟꠐꠣ ꠌꠟꠝꠥ, ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠉꠥꠘꠣꠞ ꠡꠣꠔ ꠉꠥꠘ ꠡꠣꠎꠣ ꠖꠤꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","ꠙꠦꠐꠞ ꠜꠥꠇꠦ ꠅꠃ ꠡꠝꠄ ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠙꠥꠀ-ꠙꠥꠠꠤꠘ꠆ꠔꠞꠦ ꠌꠤꠛꠣꠁꠀ ꠈꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠙꠥꠎꠣꠞ ꠢꠇꠟ ꠝꠣꠘ꠆ꠒꠛ ꠀꠞ ꠗꠥꠙ-ꠗꠥꠘꠣ ꠎꠣꠟꠣꠘꠤꠞ ꠎꠣꠉꠣꠞꠦꠅ ꠛꠤꠘꠣꠡ ꠇꠞꠝꠥ, ꠔꠥꠝꠞꠣꠞ ꠖꠦꠛ-ꠖꠦꠛꠤꠞ ꠝꠥꠞ꠆ꠔꠤꠞ ꠃꠙꠞꠦ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠡꠞ ꠐꠦꠇꠤ ꠕꠁꠝꠥ, ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠄ ꠈꠥꠛ ꠊꠤꠘ꠆ꠘꠣꠞ ꠘꠎꠞꠦ ꠌꠣꠁꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠉꠣꠃ ꠀꠞ ꠐꠣꠃꠘ ꠅꠇꠟ, ꠀꠞ ꠢꠇꠟ ꠝꠍꠤꠖ-ꠝꠘ꠆ꠖꠤꠞ ꠛꠤꠘꠣꠡ ꠇꠞꠤꠟꠤꠝꠥ। ꠔꠥꠝꠞꠣꠞ ꠍꠖꠉꠣ-ꠇꠥꠞꠛꠣꠘꠤꠞ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘ ꠀꠝꠤ ꠀꠞ ꠇꠛꠥꠟ ꠇꠞꠔꠣꠝ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠖꠦꠡꠞ ꠃꠙꠞꠦ ꠅꠟꠣ ꠉꠎꠛ ꠖꠤꠝꠥ, ꠎꠦꠔꠣ ꠖꠦꠈꠤꠀ ꠔꠥꠝꠞꠣꠞ ꠖꠥꠡꠝꠘ ꠅꠇꠟꠦꠅ ꠒꠞꠣꠁꠀ ꠇꠣꠙꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","ꠘꠣꠘꠣꠘ ꠎꠣꠔꠤꠞ ꠝꠣꠎꠦ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠍꠤꠔ꠆ꠞꠣꠁ ꠖꠤꠝꠥ, ꠔꠟꠥꠀꠞ ꠀꠔꠅ ꠟꠁꠀ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠈꠦꠖꠣꠁꠝꠥ। ꠔꠥꠝꠞꠣꠞ ꠖꠦꠡ ꠛꠤꠘꠣꠡ ꠅꠁꠛ, ꠔꠥꠝꠞꠣꠞ ꠐꠣꠃꠘ ꠀꠞ ꠉꠣꠃ-ꠉꠦꠞꠣꠝ ꠈꠣꠟꠤ ꠙꠠꠤ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","“ꠔꠥꠝꠞꠣ ꠖꠥꠡꠝꠘꠞ ꠖꠦꠡꠅ ꠕꠣꠇꠣꠞ ꠡꠝꠄ, ꠔꠥꠝꠞꠣꠞ ꠘꠤꠎꠞ ꠖꠦꠡꠞ ꠎꠝꠤꠘꠦ ꠔꠣꠞ ꠙꠣꠅꠘꠣ ꠎꠤꠞꠣꠘꠤꠞ ꠛꠍꠞ ꠎꠤꠞꠣꠁꠛ। ꠅꠃ ꠡꠝꠄ ꠖꠦꠡꠞ ꠝꠣꠐꠤꠄ ꠔꠣꠞ ꠙꠣꠅꠘꠣ ꠀꠞꠣꠝ ꠙꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","ꠔꠥꠝꠞꠣ ꠘꠤꠎꠦ ꠕꠣꠇꠣꠞ ꠡꠝꠄ ꠎꠦꠛꠟꠣ ꠅꠃ ꠎꠝꠤꠘ ꠅꠇꠟꠦ ꠎꠤꠞꠣꠘꠤꠞ ꠛꠍꠞ ꠙꠣꠁꠍꠤꠟ ꠘꠣ, ꠅꠈꠘ ꠖꠦꠡ ꠛꠤꠘꠣꠡꠞ ꠡꠝꠄ ꠁꠔꠣꠄ ꠢꠃ ꠙꠣꠅꠘꠣ ꠎꠤꠞꠣꠘꠤ ꠎꠤꠞꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","ꠔꠥꠝꠞꠣꠞ ꠝꠣꠎꠞ ꠎꠦꠞꠣ ꠉꠤꠀ ꠖꠥꠡꠝꠘꠞ ꠖꠦꠡꠅ ꠛꠣꠌꠤꠀ ꠞꠁꠛꠣ, ꠔꠣꠞꠣꠞ ꠜꠤꠔꠞꠦ ꠀꠝꠤ ꠅꠃ ꠟꠣꠈꠣꠘ ꠒꠞ-ꠈꠚ ꠢꠣꠞꠣꠁ ꠖꠤꠝꠥ, ꠟꠣꠠꠣꠁꠞ ꠇꠣꠟꠅ ꠝꠣꠘꠡꠦ ꠎꠦꠟꠣ ꠖꠥꠡꠝꠘꠞ ꠀꠔ ꠕꠣꠇꠤ ꠛꠣꠌꠣꠞ ꠟꠣꠉꠤ ꠖꠃꠠꠤꠀ ꠜꠣꠉꠦ, ꠅꠃꠟꠣ ꠄꠉꠥ ꠙꠣꠔꠣ ꠙꠠꠣꠞ ꠀꠅꠀꠎ ꠢꠥꠘꠟꠦꠃ ꠔꠣꠞꠣ ꠖꠃꠠꠤꠀ ꠜꠣꠉꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","ꠔꠟꠥꠀꠞꠞ ꠔꠟ ꠕꠣꠇꠤ ꠛꠣꠌꠣꠞ ꠟꠣꠉꠤ ꠝꠣꠘꠡꠦ ꠎꠦꠟꠣ ꠎꠣꠘ ꠟꠁꠀ ꠖꠃꠠꠣꠄ, ꠇꠦꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠘꠣ ꠖꠃꠠꠣꠁꠟꠦꠅ ꠔꠥꠝꠞꠣ ꠘꠤꠎꠦ ꠘꠤꠎꠦ ꠖꠃꠠꠣꠁꠀ ꠅꠟꠣ ꠄꠇꠦ-ꠅꠁꠘ꠆ꠘꠞ ꠃꠙꠞꠦ ꠙꠠꠛꠣꠄ। ꠖꠥꠡꠝꠘꠞ ꠍꠣꠝꠘꠦ ꠔꠥꠝꠞꠣ ꠃꠛꠣꠁꠔꠣꠄ ꠙꠣꠞꠔꠣꠄ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","ꠔꠥꠝꠞꠣ ꠘꠣꠘꠣꠘ ꠎꠣꠔꠤꠞ ꠝꠣꠘꠡꠞ ꠝꠣꠎꠦ ꠍꠤꠔ꠆ꠞꠤꠀ ꠝꠞꠛꠣꠄ, ꠀꠞ ꠖꠥꠡꠝꠘꠞ ꠖꠦꠡꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠉꠤꠟꠤꠀ ꠈꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","ꠄꠞꠛꠣꠖꠦꠅ ꠎꠥꠖꠤ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠎꠞ ꠇꠦꠃ ꠢꠘꠅ ꠛꠣꠌꠤꠀ ꠞꠄ, ꠔꠦ ꠔꠣꠞꠣꠅ ꠘꠤꠎꠞ ꠀꠞ ꠔꠣꠞꠣꠞ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤꠞ ꠘꠣꠚꠞꠝꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠇ꠆ꠇꠄ ꠅꠀꠔ ꠞꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ꠔꠣꠞꠣ ꠅꠈꠣꠘ ꠡ꠆ꠛꠤꠇꠣꠞ ꠇꠞꠣ ꠟꠣꠉꠛ ꠎꠦꠘ, ꠔꠣꠞꠣ ꠀꠞ ꠔꠣꠞꠣꠞ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤꠄ ꠀꠝꠣꠞ ꠟꠉꠦ ꠛꠦꠁꠝꠣꠘꠤ ꠇꠞꠍꠦ, ꠀꠝꠣꠞ ꠢꠥꠇꠥꠝꠞ ꠛꠤꠞꠥꠗꠤꠔꠣ ꠇꠞꠤꠀ ꠉꠥꠘꠣ ꠇꠞꠍꠦ, ");
INSERT INTO syls_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ꠄꠞꠟꠣꠉꠤ ꠀꠝꠤꠅ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠖꠥꠡꠝꠘꠞ ꠟꠣꠈꠣꠘ ꠛꠦꠛꠢꠣꠞ ꠇꠞꠍꠤ, ꠔꠣꠞꠣꠞꠦ ꠜꠤꠐꠣ-ꠝꠣꠐꠤ ꠍꠣꠠꠣꠁꠀ ꠖꠥꠡꠝꠘꠞ ꠖꠦꠡꠅ ꠀꠘꠣꠁꠍꠤ। ꠅꠔꠣ ꠡ꠆ꠛꠤꠇꠣꠞ ꠇꠞꠤꠀ ꠔꠣꠞꠣ ꠎꠥꠖꠤ ꠇꠣꠔꠞ ꠅꠁꠀ ꠘꠞꠝ ꠖꠤꠟꠦ ꠔꠃꠛꠣ ꠇꠞꠤꠀ ꠉꠥꠘꠣꠞ ꠡꠣꠎꠣ ꠛꠁꠔꠦ ꠞꠣꠎꠤ ꠅꠄ, ");
INSERT INTO syls_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ꠔꠦ ꠀꠝꠤ ꠁꠀꠇꠥꠛꠞ ꠟꠉꠦ ꠇꠣꠁꠝ ꠇꠞꠣ ꠀꠝꠣꠞ ꠅꠀꠖꠣ-ꠌꠥꠇ꠆ꠔꠤꠞ ꠇꠕꠣ ꠁꠀꠖ ꠇꠞꠝꠥ, ꠁꠍꠢꠣꠇꠞ ꠟꠉꠦ ꠇꠞꠣ ꠅꠀꠖꠣ-ꠌꠥꠇ꠆ꠔꠤꠞ ꠇꠕꠣꠞꠦꠅ ꠝꠘꠅ ꠇꠞꠝꠥ, ꠀꠞ ꠁꠛ꠆ꠞꠣꠢꠤꠝꠞ ꠟꠉꠦ ꠇꠞꠣ ꠀꠝꠣꠞ ꠅꠀꠖꠣ-ꠌꠥꠇ꠆ꠔꠤꠞꠦ ꠁꠀꠖ ꠇꠞꠝꠥ, ꠔꠣꠞꠣꠞꠦ ꠖꠦꠅꠀ ꠖꠦꠡꠞ ꠇꠕꠣꠅ ꠈꠤꠀꠟ ꠇꠞꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","“ꠔꠣꠞꠣ ꠖꠦꠡ ꠍꠣꠠꠤꠀ ꠎꠣꠅꠀꠞ ꠛꠣꠖꠦ ꠔꠣꠞꠣꠞ ꠛꠤꠘꠣꠡ ꠅꠀ ꠖꠦꠡ ꠈꠣꠟꠤ ꠙꠠꠤ ꠞꠁꠛ, ꠎꠝꠤꠘꠞ ꠙꠣꠅꠘꠣ ꠎꠤꠞꠣꠘꠤꠞ ꠛꠍꠞ ꠅꠇꠟꠅ ꠎꠤꠞꠣꠁꠛꠃ ꠎꠤꠞꠣꠁꠛ। ꠀꠝꠣꠞ ꠢꠥꠇꠥꠝꠞ ꠛꠤꠞꠥꠗꠤꠔꠣ ꠇꠞꠤꠀ ꠘꠣꠚꠞꠝꠣꠘꠤ ꠇꠞꠣꠄ, ꠀꠝꠣꠞ ꠀꠁꠘꠞ ꠃꠟꠐꠣ ꠌꠟꠣꠄ ꠔꠣꠞꠣ ꠅꠟꠣ ꠡꠣꠎꠣ ꠙꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","ꠅꠁꠟꠦ ꠖꠥꠡꠝꠘꠞ ꠖꠦꠡꠅ ꠕꠣꠇꠣꠞ ꠇꠣꠟꠅ ꠀꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠅꠟꠣ ꠇꠥꠘꠥ ꠊꠤꠘ꠆ꠘꠣ ꠛꠣ ꠄꠟꠣꠝꠤꠞ ꠌꠃꠈꠦ ꠖꠦꠈꠔꠣꠝ ꠘꠣꠄ, ꠔꠣꠞꠣꠞꠦ ꠄꠇ꠆ꠇꠦꠞꠦ ꠛꠤꠘꠣꠡ ꠅꠁꠔꠦ ꠖꠤꠔꠣꠝ ꠘꠣꠄ, ꠎꠣꠔꠦ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠇꠞꠣ ꠀꠝꠣꠞ ꠅꠀꠖꠣ-ꠌꠥꠇ꠆ꠔꠤ ꠜꠋꠉ ꠘꠣ ꠅꠄ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠣꠞꠣꠞ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","ꠔꠣꠞꠣꠞ ꠟꠣꠉꠤ ꠀꠝꠤ ꠔꠣꠞꠣꠞ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤꠞ ꠟꠉꠞ ꠅꠀꠖꠣ-ꠌꠥꠇ꠆ꠔꠤꠞꠦ ꠁꠀꠖ ꠇꠞꠝꠥ। ꠅꠃ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟꠞ ꠝꠣꠛꠥꠖ ꠅꠀꠞ ꠘꠤꠅꠔꠦ ꠢꠇꠟ ꠎꠣꠔꠤꠞ ꠍꠣꠝꠘ ꠖꠤꠀ ꠀꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤꠀ ꠀꠘꠍꠤ। ꠀꠝꠤꠃ ꠔ ꠝꠣꠛꠥꠖ।” ");
INSERT INTO syls_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","ꠁꠔꠣ ꠅꠁꠟ ꠢꠃ ꠡꠞꠤꠅꠔ, ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ, ꠀꠞ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ, ꠎꠦꠔꠣ ꠔꠥꠞ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞ ꠝꠣꠞꠚꠔꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠣꠉꠤ ꠛꠅꠀꠁꠟ ꠇꠞꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“ꠔꠥꠝꠤ ꠔꠣꠝꠣꠝ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠇꠦꠃ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠞꠦ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠦ ꠖꠦꠅꠀꠞ ꠝꠣꠘ꠆ꠘꠔ ꠇꠞꠦ, ꠔꠦ ꠅꠃ ꠎꠘꠞ ꠛꠖꠟꠣ ꠅꠟꠣꠈꠣꠘ ꠢꠣꠖꠤꠀ ꠖꠤꠔꠦ ꠅꠁꠛ: ");
INSERT INTO syls_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","ꠛꠤꠡ ꠕꠣꠇꠤ ꠡꠣꠁꠐ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠞ ꠟꠣꠉꠤ, ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠝꠣꠙꠦ ꠙꠁꠘ꠆ꠌꠣꠡ ꠔꠟꠣ ꠞꠥꠙꠣ ꠢꠣꠖꠤꠀ ꠖꠤꠔꠦ ꠅꠁꠛ, ");
INSERT INTO syls_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ꠅꠃ ꠛꠄꠅꠡꠤ ꠛꠦꠐꠤꠘ꠆ꠔꠞ ꠟꠣꠉꠤ ꠔꠤꠡ ꠔꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","ꠙꠣꠌ ꠛꠍꠞ ꠕꠣꠇꠤ ꠛꠤꠡ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠟꠣꠉꠤ ꠛꠤꠡ ꠔꠟꠣ ꠞꠥꠙꠣ, ꠅꠃ ꠛꠄꠅꠡꠤ ꠙꠥꠠꠤꠘ꠆ꠔꠞ ꠟꠣꠉꠤ ꠖꠡ ꠔꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ꠄꠇꠝꠣꠡ ꠕꠣꠇꠤ ꠙꠣꠌ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠟꠣꠉꠤ ꠙꠣꠌ ꠔꠟꠣ ꠞꠥꠙꠣ, ꠅꠃ ꠛꠄꠅꠡꠤ ꠙꠥꠠꠤꠘ꠆ꠔꠞ ꠟꠣꠉꠤ ꠔꠤꠘ ꠔꠟꠣ ꠞꠥꠙꠣ। ");
INSERT INTO syls_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","ꠡꠣꠁꠐ ꠛꠍꠞ ꠛꠣ ꠄꠞ ꠛꠦꠡꠤ ꠛꠄꠅꠡꠤ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠞ ꠟꠣꠉꠤ ꠙꠘꠞ ꠔꠟꠣ, ꠅꠃ ꠛꠄꠅꠡꠤ ꠛꠦꠐꠤꠘ꠆ꠔꠞ ꠟꠣꠉꠤ ꠖꠡ ꠔꠟꠣ ꠞꠥꠙꠣ ꠖꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“ꠅꠁꠟꠦ ꠅꠃ ꠝꠣꠘ꠆ꠘꠔ ꠇꠞꠞꠣ ꠎꠘ ꠎꠥꠖꠤ ꠉꠞꠤꠛ ꠝꠣꠘꠥꠡ ꠅꠄ, ꠔꠣꠞ ꠝꠣꠘ꠆ꠘꠔꠞ ꠢꠣꠖꠤꠀ ꠖꠤꠛꠣꠞ ꠔꠣꠇ꠆ꠇꠔ ꠘꠣ ꠕꠣꠇꠦ, ꠔꠦ ꠔꠣꠞꠦ ꠟꠁꠀ ꠁꠝꠣꠝ ꠍꠣꠛꠞ ꠉꠦꠍꠦ ꠎꠣꠁꠛꠣꠄ, ꠉꠦꠟꠦ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠔꠣꠞ ꠢꠣꠟꠔ ꠛꠥꠎꠤꠀ ꠢꠣꠖꠤꠀ ꠑꠤꠇ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ꠎꠥꠖꠤ ꠇꠛꠥꠟ ꠅꠀꠞ ꠎꠥꠇꠣ ꠇꠥꠘꠥ ꠙꠡꠥꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠝꠣꠘ꠆ꠘꠔ ꠇꠞꠣ ꠅꠄ, ꠔꠦ ꠅꠃ ꠙꠡꠥꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠣꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠙꠛꠤꠔ꠆ꠞ ꠇꠁꠀ ꠉꠁꠘ꠆ꠘ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","ꠅꠃ ꠙꠡꠥꠞ ꠛꠖꠟꠣ ꠖꠥꠍꠞꠣ ꠇꠥꠘꠥ ꠙꠡꠥ ꠖꠤꠟꠦ ꠇꠛꠥꠟ ꠅꠁꠔ ꠘꠣꠄ। ꠁꠐꠣ ꠜꠣꠟꠣ ꠅꠁꠟꠦ ꠄꠞ ꠛꠖꠟꠣ ꠛꠣꠖ ꠙꠡꠥ, ꠛꠣ ꠛꠣꠖ ꠅꠁꠟꠦ ꠄꠞ ꠛꠖꠟꠣ ꠜꠣꠟꠣ ꠇꠥꠘꠥ ꠙꠡꠥ ꠖꠤꠟꠦꠅ ꠇꠛꠥꠟ ꠅꠁꠔ ꠘꠣꠄ। ꠢꠦ ꠎꠥꠖꠤ ꠄꠇꠐꠣꠞ ꠛꠖꠟꠣ ꠀꠞꠇꠐꠣ ꠙꠡꠥꠞꠦ ꠖꠤꠟꠣꠄ, ꠔꠦ ꠅꠃ ꠖꠥꠁꠅꠐꠣꠞꠦ ꠙꠛꠤꠔ꠆ꠞ ꠢꠤꠡꠣꠛꠦ ꠉꠁꠘ꠆ꠘ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","ꠅꠁꠟꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠇꠛꠥꠟ ꠅꠀꠞ ꠎꠥꠇꠣ ꠘꠣꠄ, ꠁꠟꠣ ꠇꠥꠘꠥ ꠘꠣꠙꠣꠇ ꠎꠣꠔꠞ ꠙꠡꠥꠞꠦ ꠇꠦꠃ ꠎꠥꠖꠤ ꠝꠣꠘ꠆ꠘꠔ ꠢꠤꠡꠣꠛꠦ ꠝꠣꠘꠤꠟꠣꠄ, ꠔꠦ ꠅꠇꠐꠣꠞꠦ ꠟꠁꠀ ꠁꠝꠣꠝ ꠍꠣꠛꠞ ꠉꠦꠍꠦ ꠎꠣꠁꠅ, ");
INSERT INTO syls_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ꠉꠦꠟꠦ ꠔꠣꠁꠘ ꠅꠇꠐꠣꠞ ꠢꠣꠟ-ꠢꠇꠤꠇꠔ ꠛꠥꠎꠤꠀ ꠢꠣꠞꠤ ꠎꠦ ꠖꠣꠝ ꠑꠤꠇ ꠇꠞꠛꠣ, ꠅꠃ ꠖꠣꠝꠃ ꠅꠁꠛ ꠁꠐꠣꠞ ꠡꠑꠤꠇ ꠖꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","ꠝꠣꠘ꠆ꠘꠔ ꠇꠞꠞꠣꠄ ꠁꠐꠣꠞꠦ ꠈꠣꠟꠣꠍ ꠇꠞꠣꠞ ꠈꠤꠀꠟ ꠅꠁꠟꠦ, ꠅꠃ ꠖꠣꠝꠞ ꠟꠉꠦ ꠀꠞꠅ ꠙꠣꠌ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ ꠖꠣꠝ ꠛꠦꠡꠤ ꠖꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ꠇꠦꠃ ꠎꠥꠖꠤ ꠔꠣꠞ ꠇꠥꠘꠥ ꠛꠣꠠꠤ-ꠊꠞꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠍꠣꠝꠣꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠝꠣꠘ꠆ꠘꠔ ꠇꠞꠤꠟꠣꠄ, ꠔꠦ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠅꠃ ꠛꠣꠠꠤꠞ ꠢꠣꠟ-ꠢꠇꠤꠇꠔ ꠛꠥꠎꠤꠀ ꠎꠦ ꠖꠣꠝ ꠑꠤꠇ ꠇꠞꠛꠣ, ꠁꠐꠣꠃ ꠅꠁꠛ ꠄꠞ ꠡꠑꠤꠇ ꠖꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","ꠅꠈꠘ ꠅꠃ ꠛꠣꠠꠤꠞꠦ ꠢꠦ ꠈꠣꠟꠣꠍ ꠇꠞꠤꠀ ꠘꠤꠔ ꠌꠣꠁꠟꠦ, ꠅꠃ ꠖꠣꠝꠞ ꠟꠉꠦ ꠀꠞꠅ ꠙꠣꠌ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ ꠛꠦꠡꠤ ꠖꠤꠔꠦ ꠅꠁꠛ। ꠔꠦꠃ ꠛꠣꠠꠤ ꠈꠣꠘ ꠔꠣꠞ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠔꠣꠞ ꠘꠤꠎꠞ ꠎꠝꠤ-ꠝꠤꠞꠣꠡꠞ ꠇꠥꠘꠥ ꠄꠇ ꠅꠋꠡꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠝꠣꠘ꠆ꠘꠔ ꠇꠞꠤꠀ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠇꠁꠀ ꠀꠟꠉ ꠇꠞꠤꠟꠣꠄ, ꠔꠦ ꠅꠃ ꠎꠝꠤꠘꠅ ꠎꠦ ꠙꠞꠤꠝꠣꠘꠦ ꠈꠦꠔ ꠅꠄ, ꠅꠃ ꠚꠡꠟꠞ ꠙꠞꠤꠝꠣꠘ ꠛꠥꠎꠤꠀ ꠄꠞ ꠖꠣꠝ ꠑꠤꠇ ꠇꠞꠔꠦ ꠅꠁꠛ। ꠙꠞꠔꠦꠇ ꠙꠣꠌ ꠝꠘ ꠛꠣꠞ꠆ꠟꠤ ꠛꠤꠌꠞ ꠖꠣꠝ ꠢꠤꠡꠣꠛꠦ ꠀꠗꠣ ꠡꠦꠞ ꠞꠥꠙꠣ ꠗꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","ꠀꠞ ꠎꠝꠤ-ꠝꠤꠞꠣꠡ ꠚꠤꠞꠔ ꠙꠣꠅꠀꠞ ꠛꠍꠞ ꠎꠥꠖꠤ ꠢꠦ ꠔꠣꠞ ꠎꠝꠤꠘꠞꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠇꠁꠀ ꠝꠣꠘ꠆ꠘꠔ ꠇꠞꠦ, ꠔꠦ ꠅꠃ ꠘꠤꠅꠝ ꠝꠣꠚꠤꠇ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠎꠦ ꠖꠣꠝ ꠑꠤꠇ ꠇꠞꠛꠣ, ꠁꠐꠣꠃ ꠅꠁꠛ ꠄꠞ ꠡꠑꠤꠇ ꠖꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","ꠅꠁꠟꠦ ꠚꠤꠞꠔ ꠙꠣꠅꠀꠞ ꠛꠍꠞꠞ ꠛꠣꠖꠦ ꠎꠥꠖꠤ ꠢꠦ ꠔꠣꠞ ꠝꠣꠘ꠆ꠘꠔ ꠇꠞꠦ, ꠔꠦ ꠛꠣꠖꠞ ꠚꠤꠞꠔ ꠙꠣꠅꠀꠞ ꠛꠍꠞ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠤꠡꠣꠛ ꠇꠞꠤꠀ ꠎꠔ ꠛꠍꠞ ꠅꠄ, ꠅꠔ ꠛꠍꠞꠞ ꠚꠡꠟꠞ ꠢꠤꠡꠣꠛꠦ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠄꠞ ꠖꠣꠝ ꠑꠤꠇ ꠇꠞꠛꠣ, ꠛꠍꠞ ꠢꠤꠡꠣꠛꠦ ꠎꠝꠤꠘꠞ ꠖꠣꠝ ꠇꠝꠛ। ");
INSERT INTO syls_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","ꠀꠞ ꠝꠣꠘ꠆ꠘꠔ ꠇꠞꠞꠣ ꠎꠘꠦ ꠎꠥꠖꠤ ꠔꠣꠞ ꠎꠝꠤꠘꠞꠦ ꠈꠣꠟꠣꠍ ꠇꠞꠤꠀ ꠘꠤꠔ ꠌꠣꠄ, ꠔꠦ ꠑꠤꠇ ꠇꠞꠣ ꠅꠃ ꠖꠣꠝꠞ ꠟꠉꠦ ꠀꠞꠅ ꠙꠣꠌ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ ꠛꠦꠡꠤ ꠖꠤꠔꠦ ꠅꠁꠛ, ꠔꠦꠃ ꠎꠝꠤ ꠈꠣꠘ ꠔꠣꠞ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","ꠅꠁꠟꠦ ꠢꠦ ꠎꠥꠖꠤ ꠈꠣꠟꠣꠍ ꠇꠞꠤ ꠘꠣ ꠘꠦꠄ, ꠛꠣ ꠖꠥꠍꠞꠣ ꠎꠘꠞ ꠉꠦꠍꠦ ꠛꠦꠌꠤꠟꠣꠄ, ꠔꠦ ꠅꠃ ꠎꠝꠤꠘ ꠈꠣꠘ ꠀꠞ ꠈꠣꠟꠣꠍ ꠇꠞꠤꠀ ꠘꠤꠛꠣꠞ ꠙꠕ ꠘꠣꠁ। ");
INSERT INTO syls_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","ꠎꠝꠤ-ꠝꠤꠞꠣꠡ ꠚꠤꠞꠔ ꠙꠣꠁꠛꠣꠞ ꠛꠍꠞ ꠎꠦꠛꠟꠣ ꠎꠝꠤ ꠈꠣꠘ ꠄꠝꠘꠦꠃ ꠈꠣꠟꠣꠍ ꠅꠁꠎꠤꠛ, ꠅꠃ ꠡꠝꠄ ꠁ ꠎꠝꠤ ꠈꠣꠘ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠌꠤꠞꠇꠣꠟꠤꠘ ꠍꠣꠚ-ꠇꠛꠣꠟꠣ ꠎꠝꠤꠘꠞ ꠟꠣꠈꠣꠘ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠍꠣꠝꠣꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠉꠁꠘ꠆ꠘ ꠅꠁꠛ। ꠁꠈꠣꠘ ꠅꠁꠎꠤꠛ ꠁꠝꠣꠝ ꠍꠣꠛꠞ ꠎꠝꠤ। ");
INSERT INTO syls_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","ꠘꠤꠎꠞ ꠛꠣꠚꠣꠁꠔꠤ ꠎꠝꠤ ꠘꠣꠄ ꠁꠟꠣ ꠇꠥꠘꠥ ꠈꠞꠤꠖꠣ ꠎꠝꠤꠘꠞꠦ ꠇꠦꠃ ꠎꠥꠖꠤ ꠝꠣꠘ꠆ꠘꠔ ꠝꠣꠘꠤꠀ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠢꠤꠡꠣꠛꠦ ꠉꠁꠘ꠆ꠘ ꠇꠞꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ꠔꠦ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠚꠤꠞꠔ ꠙꠣꠅꠀꠞ ꠛꠍꠞ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠤꠡꠣꠛ ꠇꠞꠤꠀ ꠁꠈꠣꠘꠞ ꠖꠣꠝ ꠑꠤꠇ ꠇꠞꠛꠣ, ꠀꠞ ꠢꠃ ꠖꠤꠘꠃ ꠅꠃ ꠎꠝꠤꠘꠞ ꠖꠣꠝꠞꠦ ꠢꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠍꠣꠝꠣꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠖꠤꠟꠣꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","ꠀꠞ ꠎꠝꠤ ꠈꠣꠘ ꠢꠦ ꠎꠣꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠟꠁꠍꠤꠟ, ꠎꠝꠤ-ꠝꠤꠞꠣꠡ ꠚꠤꠞꠔ ꠙꠣꠁꠛꠣꠞ ꠛꠍꠞ ꠁꠈꠣꠘ ꠢꠤꠞꠛꠣꠞ ꠢꠃ ꠝꠥꠟ ꠝꠣꠟꠤꠇꠞ ꠀꠔꠅ ꠎꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","ꠢꠇꠟ ꠎꠤꠘꠤꠡꠞ ꠖꠣꠝ ꠑꠤꠇ ꠇꠞꠤꠅ, ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠝꠣꠙꠦ। ꠙꠞꠔꠦꠇ ꠛꠤꠡ ꠞꠔꠤꠄ ꠄꠇ ꠔꠟꠣ ꠉꠘꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ꠇꠥꠘꠥ ꠙꠡꠥꠞ ꠙꠄꠟꠣ ꠝꠦꠖꠣ ꠛꠣꠁꠌ꠆ꠌꠣꠞꠦ ꠇꠦꠃ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠟꠤꠟ꠆ꠟꠣ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠝꠣꠘ꠆ꠘꠔ ꠇꠞꠔ ꠙꠣꠞꠔ ꠘꠣꠄ, ꠁꠐꠣ ꠔ ꠄꠝꠘꠦꠃ ꠝꠣꠛꠥꠖꠞ। ꠁꠔꠣ ꠉꠞꠥ-ꠍꠣꠉꠟ, ꠝꠦꠠꠣ ꠎꠦꠔꠣꠞ ꠛꠣꠁꠌ꠆ꠌꠣꠃ ꠅꠃꠇ, ꠁꠐꠣ ꠝꠣꠛꠥꠖꠞ। ");
INSERT INTO syls_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","ꠎꠥꠖꠤ ꠁꠐꠣ ꠇꠥꠘꠥ ꠢꠣꠞꠣꠝ ꠙꠡꠥꠞ ꠙꠄꠟꠣ ꠝꠦꠖꠣ ꠛꠣꠁꠌ꠆ꠌꠣ ꠅꠄ, ꠔꠦ ꠁꠝꠣꠝ ꠍꠣꠛꠞ ꠑꠤꠇ ꠇꠞꠣ ꠖꠣꠝꠞ ꠟꠉꠦ ꠀꠞꠅ ꠙꠣꠌ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ ꠛꠦꠡꠤ ꠖꠤꠀ ꠁꠐꠣꠞꠦ ꠈꠣꠟꠣꠍ ꠇꠞꠤ ꠘꠤꠔ ꠙꠣꠞꠛ। ꠀꠞ ꠢꠦ ꠎꠥꠖꠤ ꠈꠣꠟꠣꠍ ꠇꠞꠤ ꠘꠣ ꠘꠦꠄ, ꠔꠦ ꠅꠃ ꠖꠣꠝꠦ ꠁꠐꠣꠞꠦ ꠛꠦꠌꠤꠟꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ꠅꠁꠟꠦ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠔꠣꠞ ꠘꠤꠎꠞ ꠇꠥꠘꠥ ꠍꠣꠝꠣꠘꠣ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠌꠤꠞꠇꠣꠟꠤꠘ ꠍꠣꠚ-ꠇꠛꠣꠟꠣ ꠖꠟꠤꠟꠞ ꠟꠣꠈꠣꠘ ꠝꠣꠘ꠆ꠘꠔ ꠇꠞꠤꠟꠣꠄ, ꠔꠦ ꠅꠃ ꠝꠣꠘ꠆ꠘꠔ ꠇꠞꠣ ꠍꠣꠝꠣꠘꠣ ꠀꠞ ꠈꠣꠟꠣꠍ ꠇꠞꠤꠀ ꠚꠤꠞꠔ ꠘꠤꠔ ꠙꠣꠞꠔ ꠘꠣꠄ, ꠛꠣ ꠛꠦꠌꠔ-ꠅ ꠙꠣꠞꠔ ꠘꠣꠄ। ꠁꠔꠣ ꠎꠝꠤ-ꠎꠝꠣ ꠅꠃꠇ, ꠛꠣ ꠇꠥꠘꠥ ꠝꠣꠘꠥꠡ, ꠛꠣ ꠙꠡꠥ ꠅꠁꠟꠦꠅ, ꠁꠔꠣ ꠌꠤꠞꠇꠣꠟꠞ ꠟꠣꠉꠤ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠈꠣꠍ ꠙꠛꠤꠔ꠆ꠞ ꠍꠣꠝꠣꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠉꠁꠘ꠆ꠘ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","ꠇꠥꠘꠥ ꠝꠣꠘꠡꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠌꠤꠞꠇꠣꠟꠞ ꠟꠣꠉꠤ ꠅꠟꠣ ꠝꠣꠘ꠆ꠘꠔ ꠇꠞꠤꠀ ꠖꠤꠟꠣꠁꠟꠦ, ꠔꠣꠞꠦ ꠀꠞ ꠈꠣꠟꠣꠍ ꠇꠞꠤ ꠘꠦꠅꠀ ꠎꠣꠁꠔ ꠘꠣꠄ, ꠔꠣꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ꠎꠝꠤꠘꠅ ꠕꠣꠇꠤ ꠎꠦꠔꠣ ꠚꠟ-ꠚꠡꠟ ꠝꠤꠟꠦ, ꠁꠔꠣꠞ ꠖꠡ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ ꠔ ꠝꠣꠛꠥꠖꠞ। ꠁꠔꠣ ꠈꠦꠔꠞ ꠚꠡꠟ ꠅꠃꠇ ꠛꠣ ꠉꠣꠍꠞ ꠚꠟ ꠅꠃꠇ, ꠢꠇꠟꠔꠣꠃ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ। ");
INSERT INTO syls_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","ꠇꠦꠃ ꠎꠥꠖꠤ ꠔꠣꠞ ꠅꠃ ꠖꠡ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ ꠈꠣꠟꠣꠍ ꠇꠞꠤꠀ ꠘꠤꠔ ꠌꠣꠄ, ꠔꠦ ꠄꠞ ꠟꠉꠦ ꠀꠞꠅ ꠙꠣꠌ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ ꠛꠦꠡꠤ ꠖꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","ꠙꠞꠔꠦꠇ ꠙꠡꠥꠞ ꠙꠣꠟꠞ ꠖꠡ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ ꠝꠣꠛꠥꠖꠞ, ꠝꠣꠘꠤ ꠙꠣꠟꠦ ꠙꠡꠥ ꠉꠘꠣꠞ ꠡꠝꠄ ꠙꠞꠔꠦꠇ ꠖꠡ ꠘꠝ꠆ꠛꠞ ꠙꠡꠥ ꠅꠉꠥ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ। ");
INSERT INTO syls_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","ꠅꠃ ꠖꠡ ꠘꠝ꠆ꠛꠞ ꠙꠡꠥ ꠅꠉꠥꠁꠘ ꠛꠣꠖ ꠛꠣ ꠜꠣꠟꠣ ꠁꠔꠣ ꠖꠦꠈꠣꠞ ꠇꠥꠘꠥ ꠎꠞꠥꠞ ꠘꠣꠄ, ꠛꠣ ꠁꠐꠣ ꠛꠖꠟꠣꠁꠀ ꠖꠤꠛꠣꠞ ꠡꠥꠎꠥꠉ ꠘꠣꠁ। ꠇꠦꠃ ꠎꠥꠖꠤ ꠁꠐꠣꠞ ꠛꠖꠟꠣ ꠖꠦꠄ, ꠔꠦ ꠅꠃ ꠖꠡ ꠘꠝ꠆ꠛꠞ ꠙꠡꠥ ꠀꠞ ꠛꠖꠟꠣ ꠙꠡꠥ ꠖꠥꠁꠅꠐꠣꠃ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠅꠁꠎꠤꠛ, ꠁꠔꠣ ꠀꠞ ꠈꠣꠟꠣꠍ ꠇꠞꠤ ꠘꠦꠅꠀ ꠎꠣꠁꠔ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","ꠝꠣꠛꠥꠖꠦ ꠔꠥꠞ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞ ꠉꠦꠍꠦ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠣꠉꠤ ꠅꠃ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠅꠇꠟ ꠖꠣꠘ ꠇꠞꠍꠤꠟꠣ॥");
INSERT INTO syls_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠎꠣꠔꠤ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁꠀ ꠀꠅꠀꠞ ꠖꠥꠁ ꠘꠝ꠆ꠛꠞ ꠛꠍꠞꠞ ꠡꠝꠄ, ꠖꠥꠁ ꠘꠝ꠆ꠛꠞ ꠌꠣꠘ꠆ꠖꠞ ꠙꠄꠟꠣ ꠖꠤꠘ, ꠝꠣꠛꠥꠖꠦ ꠍꠤꠘꠣꠁ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠜꠤꠔꠞꠦ ꠢꠎꠞꠔ ꠝꠥꠍꠣꠞ ꠟꠉꠦ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠟꠣ। ꠔꠣꠁꠘ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“ꠅꠈꠘ ꠔꠣꠝꠣꠝ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠙꠞꠤꠛꠣꠞ ꠝꠣꠚꠤꠇ ꠄꠇ ꠄꠇ ꠇꠞꠤ ꠢꠇꠟ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠞ ꠘꠣꠝ ꠟꠦꠈꠅ। ");
INSERT INTO syls_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","ꠔꠥꠝꠤ ꠀꠞ ꠔꠥꠝꠣꠞ ꠜꠣꠁ ꠢꠣꠞꠥꠘꠦ ꠛꠤꠡ ꠛꠍꠞ ꠛꠣ ꠄꠞ ꠛꠦꠡꠤ ꠛꠄꠅꠡꠤ, ꠝꠣꠘꠤ ꠎꠥꠖ꠆ꠖꠔ ꠎꠣꠅꠀꠞ ꠎꠥꠇꠣ ꠚꠃꠎꠤ ꠖꠟ ꠝꠣꠚꠤꠇ ꠔꠣꠞꠣꠞꠦ ꠉꠘꠅ। ");
INSERT INTO syls_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","ꠙꠞꠔꠦꠇ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠄꠇꠎꠘꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠡꠣꠁꠎ꠆ꠎ ꠇꠞꠛꠣ, ꠄꠞꠣ ꠅꠁꠛꠣ ꠘꠤꠎꠞ ꠉꠥꠡ꠆ꠐꠤꠞ ꠙꠞꠗꠣꠘ ꠝꠥꠞꠛ꠆ꠛꠤ। ");
INSERT INTO syls_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","ꠎꠣꠞꠣ ꠡꠣꠁꠎ꠆ꠎ ꠇꠞꠛꠣ, ꠄꠞꠣꠞ ꠘꠣꠝ ꠅꠁꠟ, ꠞꠥꠛꠦꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠣꠖꠤꠃꠞꠞ ꠙꠥꠀ ꠀꠟꠤꠍꠥꠞ, ");
INSERT INTO syls_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","ꠡꠤꠝꠤꠅꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠥꠞꠡꠣꠖꠣꠄꠅꠞ ꠙꠥꠀ ꠡꠣꠟꠥꠝꠤꠟ, ");
INSERT INTO syls_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","ꠄꠢꠥꠖꠣ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠀꠝꠤꠘꠣꠖꠣꠛꠞ ꠙꠥꠀ ꠘꠣꠢꠤꠡ, ");
INSERT INTO syls_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ꠁꠍꠣꠈꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠍꠥꠉꠣꠞꠞ ꠙꠥꠀ ꠘꠕꠘꠦꠟ, ");
INSERT INTO syls_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","ꠍꠛꠥꠟꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠢꠦꠟꠘꠞ ꠙꠥꠀ ꠁꠟꠤꠀꠛ, ");
INSERT INTO syls_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","ꠁꠃꠍꠥꠚꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠝꠣꠎ ꠕꠣꠇꠤ: ꠀꠚꠞꠣꠁꠝ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠀꠝꠤꠢꠥꠖꠞ ꠙꠥꠀ ꠀꠟꠤꠡꠣꠝꠣ, ꠝꠣꠘꠡꠣ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠚꠣꠔꠡꠥꠞꠞ ꠙꠥꠀ ꠉꠝꠟꠤꠄꠟ, ");
INSERT INTO syls_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","ꠛꠤꠘ-ꠁꠀꠝꠤꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠎꠤꠖꠣꠃꠘꠤꠞ ꠙꠥꠀ ꠀꠛꠤꠖꠣꠘ, ");
INSERT INTO syls_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","ꠖꠣꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠀꠝꠤꠡꠣꠖꠣꠞ ꠙꠥꠀ ꠀꠈꠤꠀꠎꠣꠞ, ");
INSERT INTO syls_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","ꠀꠡꠤꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠃꠇꠞꠣꠘꠞ ꠙꠥꠀ ꠚꠎꠤꠄꠟ, ");
INSERT INTO syls_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","ꠍꠣꠖꠥ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠖꠥꠄꠟꠞ ꠙꠥꠀ ꠁꠟꠤꠀꠍꠚ, ");
INSERT INTO syls_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","ꠘꠙ꠆ꠔꠣꠟꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠁꠘꠣꠘꠞ ꠙꠥꠀ ꠀꠢꠤꠞ।” ");
INSERT INTO syls_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠅꠃ ꠛꠣꠞꠅ ꠎꠘꠞꠦ ꠙꠍꠘ꠆ꠖ ꠇꠞꠤ ꠘꠦꠅꠀ ꠅꠁꠟ। ꠄꠞꠣ ꠅꠁꠟꠣ ꠔꠣꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠁꠘ꠆ꠔꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠙꠞꠗꠣꠘ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠚꠃꠎꠤ ꠖꠟꠞ ꠡꠞ꠆ꠖꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","ꠝꠣꠛꠥꠖꠦ ꠎꠦꠞꠣꠞ ꠘꠣꠝ ꠇꠁꠍꠟꠣ, ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠦ ꠅꠃ ꠡꠞ꠆ꠖꠣꠞ ꠅꠇꠟꠞꠦ ꠈꠛꠞꠖꠤ ꠀꠘꠣꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ꠀꠞ ꠅꠃ ꠛꠍꠞꠞ ꠖꠥꠍꠞꠣ ꠌꠣꠘ꠆ꠖꠞ ꠙꠄꠟꠣ ꠖꠤꠘ ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠄꠇꠈꠣꠘꠅ ꠖꠟꠣ ꠇꠞꠟꠣ। ꠔꠣꠞꠣ ꠎꠣꠞꠎꠤꠞ ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠙꠞꠤꠛꠣꠞ ꠝꠣꠚꠤꠇ ꠔꠣꠞꠣꠞ ꠘꠣꠝ ꠟꠦꠈꠣꠁꠟ। ꠛꠤꠡ ꠛꠍꠞ ꠛꠣ ꠄꠞ ꠛꠦꠡꠤ ꠛꠄꠅꠡꠞ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠞ ꠘꠣꠝ ꠄꠇ ꠄꠇ ꠇꠞꠤ ꠟꠦꠈꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠍꠤꠘꠣꠁ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠝꠥꠍꠣꠄ ꠄꠞꠣꠞꠦ ꠉꠘꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","ꠁꠀꠇꠥꠛ ꠃꠞꠚꠦ ꠁꠍꠞꠣꠁꠟꠞ ꠛꠠ ꠙꠥꠀꠞ ꠘꠣꠝ ꠞꠥꠛꠦꠘ, ꠅꠃ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠣꠇꠤ ꠎꠦꠞꠣꠞ ꠛꠄꠅꠡ ꠛꠤꠡ ꠛꠍꠞ ꠛꠣ ꠄꠞ ꠛꠦꠡꠤ, ꠝꠣꠘꠤ ꠎꠣꠞꠣ ꠎꠥꠖ꠆ꠖꠔ ꠎꠣꠅꠀꠞ ꠎꠥꠇꠣ ꠀꠍꠤꠟ, ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠙꠞꠤꠌꠄ ꠝꠣꠚꠤꠇ ꠄꠞꠣꠞ ꠘꠣꠝ ꠄꠇ ꠄꠇ ꠇꠞꠤ ꠟꠦꠈꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","ꠞꠥꠛꠦꠘ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠣꠇꠤ ꠙꠣꠅꠀ ꠉꠦꠟ ꠍꠄꠌꠣꠟ꠆ꠟꠤꠡ ꠀꠎꠣꠞ ꠙꠣꠌ-ꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","ꠡꠤꠝꠤꠅꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠎꠦ ꠎꠦꠞꠣꠞ ꠛꠄꠅꠡ ꠛꠤꠡ ꠛꠍꠞ ꠛꠣ ꠄꠞ ꠛꠦꠡꠤ, ꠝꠣꠘꠤ ꠎꠣꠞꠣ ꠎꠥꠖ꠆ꠖꠔ ꠎꠣꠅꠀꠞ ꠎꠥꠇꠣ ꠀꠍꠤꠟ, ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠙꠞꠤꠌꠄ ꠝꠣꠚꠤꠇ ꠄꠞꠣꠞ ꠘꠣꠝ ꠄꠇ ꠄꠇ ꠇꠞꠤ ꠟꠦꠈꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","ꠡꠤꠝꠤꠅꠘ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠣꠇꠤ ꠙꠣꠅꠀ ꠉꠦꠟ ꠃꠘꠥꠡꠣꠁꠐ ꠀꠎꠣꠞ ꠔꠤꠘ-ꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","ꠍꠣꠖꠥ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠎꠦ ꠎꠦꠞꠣꠞ ꠛꠄꠅꠡ ꠛꠤꠡ ꠛꠍꠞ ꠛꠣ ꠄꠞ ꠛꠦꠡꠤ, ꠝꠣꠘꠤ ꠎꠣꠞꠣ ꠎꠥꠖ꠆ꠖꠔ ꠎꠣꠅꠀꠞ ꠎꠥꠇꠣ ꠀꠍꠤꠟ, ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠙꠞꠤꠌꠄ ꠝꠣꠚꠤꠇ ꠄꠞꠣꠞ ꠘꠣꠝ ꠄꠇ ꠄꠇ ꠇꠞꠤ ꠟꠦꠈꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","ꠍꠣꠖꠥ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠣꠇꠤ ꠙꠣꠅꠀ ꠉꠦꠟ ꠙꠄꠔꠣꠟ꠆ꠟꠤꠡ ꠀꠎꠣꠞ ꠍꠄ-ꠡ ꠙꠁꠘ꠆ꠌꠣꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","ꠄꠢꠥꠖꠣ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠎꠦ ꠎꠦꠞꠣꠞ ꠛꠄꠅꠡ ꠛꠤꠡ ꠛꠍꠞ ꠛꠣ ꠄꠞ ꠛꠦꠡꠤ, ꠝꠣꠘꠤ ꠎꠣꠞꠣ ꠎꠥꠖ꠆ꠖꠔ ꠎꠣꠅꠀꠞ ꠎꠥꠇꠣ ꠀꠍꠤꠟ, ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠙꠞꠤꠌꠄ ꠝꠣꠚꠤꠇ ꠄꠞꠣꠞ ꠘꠣꠝ ꠄꠇ ꠄꠇ ꠇꠞꠤ ꠟꠦꠈꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","ꠄꠢꠥꠖꠣ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠣꠇꠤ ꠙꠣꠅꠀ ꠉꠦꠟ ꠌꠃꠀꠔ꠆ꠔꠁꠞ ꠀꠎꠣꠞ ꠍꠄ-ꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","ꠁꠍꠣꠈꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠎꠦ ꠎꠦꠞꠣꠞ ꠛꠄꠅꠡ ꠛꠤꠡ ꠛꠍꠞ ꠛꠣ ꠄꠞ ꠛꠦꠡꠤ, ꠝꠣꠘꠤ ꠎꠣꠞꠣ ꠎꠥꠖ꠆ꠖꠔ ꠎꠣꠅꠀꠞ ꠎꠥꠇꠣ ꠀꠍꠤꠟ, ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠙꠞꠤꠌꠄ ꠝꠣꠚꠤꠇ ꠄꠞꠣꠞ ꠘꠣꠝ ꠄꠇ ꠄꠇ ꠇꠞꠤ ꠟꠦꠈꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","ꠁꠍꠣꠈꠞ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠣꠇꠤ ꠙꠣꠅꠀ ꠉꠦꠟ ꠌꠃꠀꠘ꠆ꠘ ꠀꠎꠣꠞ ꠌꠣꠁꠞ-ꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","ꠍꠛꠥꠟꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠎꠦ ꠎꠦꠞꠣꠞ ꠛꠄꠅꠡ ꠛꠤꠡ ꠛꠍꠞ ꠛꠣ ꠄꠞ ꠛꠦꠡꠤ, ꠝꠣꠘꠤ ꠎꠣꠞꠣ ꠎꠥꠖ꠆ꠖꠔ ꠎꠣꠅꠀꠞ ꠎꠥꠇꠣ ꠀꠍꠤꠟ, ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠙꠞꠤꠌꠄ ꠝꠣꠚꠤꠇ ꠄꠞꠣꠞ ꠘꠣꠝ ꠄꠇ ꠄꠇ ꠇꠞꠤ ꠟꠦꠈꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","ꠍꠛꠥꠟꠘ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠣꠇꠤ ꠙꠣꠅꠀ ꠉꠦꠟ ꠡꠣꠔꠣꠘ꠆ꠘ ꠀꠎꠣꠞ ꠌꠣꠁꠞ-ꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","ꠁꠃꠍꠥꠚꠞ ꠙꠥꠀ ꠀꠚꠞꠣꠁꠝ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠎꠦ ꠎꠦꠞꠣꠞ ꠛꠄꠅꠡ ꠛꠤꠡ ꠛꠍꠞ ꠛꠣ ꠄꠞ ꠛꠦꠡꠤ, ꠝꠣꠘꠤ ꠎꠣꠞꠣ ꠎꠥꠖ꠆ꠖꠔ ꠎꠣꠅꠀꠞ ꠎꠥꠇꠣ ꠀꠍꠤꠟ, ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠙꠞꠤꠌꠄ ꠝꠣꠚꠤꠇ ꠄꠞꠣꠞ ꠘꠣꠝ ꠄꠇ ꠄꠇ ꠇꠞꠤ ꠟꠦꠈꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","ꠀꠚꠞꠣꠁꠝ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠣꠇꠤ ꠙꠣꠅꠀ ꠉꠦꠟ ꠌꠣꠟ꠆ꠟꠤꠡ ꠀꠎꠣꠞ ꠙꠣꠌ-ꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","ꠀꠞ ꠔꠣꠘ ꠜꠣꠁ ꠝꠣꠘꠡꠣ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠎꠦ ꠎꠦꠞꠣꠞ ꠛꠄꠅꠡ ꠛꠤꠡ ꠛꠍꠞ ꠛꠣ ꠄꠞ ꠛꠦꠡꠤ, ꠝꠣꠘꠤ ꠎꠣꠞꠣ ꠎꠥꠖ꠆ꠖꠔ ꠎꠣꠅꠀꠞ ꠎꠥꠇꠣ ꠀꠍꠤꠟ, ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠙꠞꠤꠌꠄ ꠝꠣꠚꠤꠇ ꠄꠞꠣꠞ ꠘꠣꠝ ꠄꠇ ꠄꠇ ꠇꠞꠤ ꠟꠦꠈꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","ꠝꠣꠘꠡꠣ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠣꠇꠤ ꠙꠣꠅꠀ ꠉꠦꠟ ꠛꠔ꠆ꠔꠤꠡ ꠀꠎꠣꠞ ꠖꠥꠁ-ꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","ꠛꠤꠘ-ꠁꠀꠝꠤꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠎꠦ ꠎꠦꠞꠣꠞ ꠛꠄꠅꠡ ꠛꠤꠡ ꠛꠍꠞ ꠛꠣ ꠄꠞ ꠛꠦꠡꠤ, ꠝꠣꠘꠤ ꠎꠣꠞꠣ ꠎꠥꠖ꠆ꠖꠔ ꠎꠣꠅꠀꠞ ꠎꠥꠇꠣ ꠀꠍꠤꠟ, ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠙꠞꠤꠌꠄ ꠝꠣꠚꠤꠇ ꠄꠞꠣꠞ ꠘꠣꠝ ꠄꠇ ꠄꠇ ꠇꠞꠤ ꠟꠦꠈꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","ꠛꠤꠘ-ꠁꠀꠝꠤꠘ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠣꠇꠤ ꠙꠣꠅꠀ ꠉꠦꠟ ꠙꠣꠄꠔꠤꠡ ꠀꠎꠣꠞ ꠌꠣꠁꠞ-ꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","ꠖꠣꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠎꠦ ꠎꠦꠞꠣꠞ ꠛꠄꠅꠡ ꠛꠤꠡ ꠛꠍꠞ ꠛꠣ ꠄꠞ ꠛꠦꠡꠤ, ꠝꠣꠘꠤ ꠎꠣꠞꠣ ꠎꠥꠖ꠆ꠖꠔ ꠎꠣꠅꠀꠞ ꠎꠥꠇꠣ ꠀꠍꠤꠟ, ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠙꠞꠤꠌꠄ ꠝꠣꠚꠤꠇ ꠄꠞꠣꠞ ꠘꠣꠝ ꠄꠇ ꠄꠇ ꠇꠞꠤ ꠟꠦꠈꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","ꠖꠣꠘ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠣꠇꠤ ꠙꠣꠅꠀ ꠉꠦꠟ ꠛꠣꠡꠐ꠆ꠐꠤ ꠀꠎꠣꠞ ꠡꠣꠔ-ꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","ꠀꠡꠤꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠎꠦ ꠎꠦꠞꠣꠞ ꠛꠄꠅꠡ ꠛꠤꠡ ꠛꠍꠞ ꠛꠣ ꠄꠞ ꠛꠦꠡꠤ, ꠝꠣꠘꠤ ꠎꠣꠞꠣ ꠎꠥꠖ꠆ꠖꠔ ꠎꠣꠅꠀꠞ ꠎꠥꠇꠣ ꠀꠍꠤꠟ, ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠙꠞꠤꠌꠄ ꠝꠣꠚꠤꠇ ꠄꠞꠣꠞ ꠘꠣꠝ ꠄꠇ ꠄꠇ ꠇꠞꠤ ꠟꠦꠈꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","ꠀꠡꠤꠞ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠣꠇꠤ ꠙꠣꠅꠀ ꠉꠦꠟ ꠄꠇꠌꠣꠟ꠆ꠟꠤꠡ ꠀꠎꠣꠞ ꠙꠣꠌ-ꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","ꠘꠙ꠆ꠔꠣꠟꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠎꠦ ꠎꠦꠞꠣꠞ ꠛꠄꠅꠡ ꠛꠤꠡ ꠛꠍꠞ ꠛꠣ ꠄꠞ ꠛꠦꠡꠤ, ꠝꠣꠘꠤ ꠎꠣꠞꠣ ꠎꠥꠖ꠆ꠖꠔ ꠎꠣꠅꠀꠞ ꠎꠥꠇꠣ ꠀꠍꠤꠟ, ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠙꠞꠤꠌꠄ ꠝꠣꠚꠤꠇ ꠄꠞꠣꠞ ꠘꠣꠝ ꠄꠇ ꠄꠇ ꠇꠞꠤ ꠟꠦꠈꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","ꠘꠙ꠆ꠔꠣꠟꠤ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠣꠇꠤ ꠙꠣꠅꠀ ꠉꠦꠟ ꠔꠦꠙ꠆ꠙꠣꠘ꠆ꠘ ꠀꠎꠣꠞ ꠌꠣꠁꠞ-ꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","ꠢꠎꠞꠔ ꠝꠥꠍꠣ, ꠢꠣꠞꠥꠘ ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠛꠣꠞꠅ ꠎꠘ ꠝꠥꠞꠛ꠆ꠛꠤ ꠘꠦꠔꠣꠄ ꠅꠃ ꠝꠣꠘꠡꠞꠦ ꠉꠘꠤꠟꠣ। ꠅꠃ ꠛꠣꠞꠅ ꠎꠘ ꠘꠦꠔꠣ ꠀꠍꠟꠣ ꠛꠣꠞꠅ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","ꠀꠡ꠆ꠔꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠎꠦ ꠎꠦꠞꠣꠞ ꠛꠄꠅꠡ ꠛꠤꠡ ꠛꠍꠞ ꠛꠣ ꠔꠣꠞ ꠛꠦꠡꠤ, ꠝꠣꠘꠤ ꠎꠥꠖ꠆ꠖꠔ ꠎꠣꠅꠀꠞ ꠎꠥꠇꠣ ꠛꠄꠅꠡ, ꠎꠣꠞꠎꠤꠞ ꠉꠥꠡ꠆ꠐꠤ ꠝꠣꠚꠤꠇ ꠔꠣꠞꠣꠞꠦ ꠉꠘꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","ꠉꠘꠤꠀ ꠢꠇ꠆ꠇꠟꠔꠣꠄ ꠍꠄ ꠟꠣꠈ ꠔꠤꠘ ꠀꠎꠣꠞ ꠙꠣꠌ-ꠡ ꠙꠁꠘ꠆ꠌꠣꠡ ꠎꠘ ꠙꠣꠅꠀ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","ꠅꠁꠟꠦ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞꠦ, ꠝꠣꠘꠤ ꠁꠝꠣꠝ ꠛꠋꠡꠞꠦ ꠄꠞꠣꠞ ꠟꠉꠦ ꠉꠘꠣ ꠅꠁꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","ꠝꠣꠛꠥꠖꠦ ꠀꠉꠦꠃ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠍꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“ꠔꠥꠝꠤ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞꠦ ꠉꠘꠛꠣꠄ ꠘꠣ, ꠉꠘꠣꠞ ꠡꠝꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠅꠁꠘ꠆ꠘ ꠝꠣꠘꠡꠞ ꠟꠉꠦ ꠄꠞꠣꠞꠦ ꠢꠤꠡꠣꠛ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","ꠔꠥꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠡꠣꠢꠣꠖꠔ ꠔꠣꠝ꠆ꠛꠥ, ꠝꠣꠘꠤ ꠀꠝꠣꠞ ꠊꠞꠞ ꠡꠣꠎ-ꠡꠞꠘ꠆ꠎꠣꠝ ꠀꠞ ꠢꠇꠟꠔꠣꠞ ꠖꠦꠈꠣ-ꠢꠥꠘꠣꠞ ꠜꠣꠞ ꠖꠤꠛꠣꠄ। ꠔꠣꠞꠣꠞ ꠇꠣꠝ ꠅꠁꠛ, ꠀꠝꠣꠞ ꠊꠞ ꠀꠞ ꠄꠞ ꠢꠇꠟ ꠡꠣꠎ-ꠡꠞꠘ꠆ꠎꠣꠝ ꠛꠁꠀ ꠘꠦꠅꠀ। ꠔꠣꠞꠣ ꠄꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠛꠣꠄ ꠎꠣꠞꠎꠤꠞ ꠔꠣꠝ꠆ꠛꠥ ꠐꠣꠋꠉꠣꠁꠀ ꠞꠁꠛꠣ ꠀꠞ ꠀꠝꠣꠞ ꠊꠞꠞ ꠖꠦꠈꠣ-ꠢꠥꠘꠣ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","ꠀꠝꠣꠞ ꠊꠞꠞꠦ ꠄꠇ ꠎꠣꠉꠣ ꠕꠣꠇꠤ ꠀꠞꠇ ꠎꠣꠉꠣꠔ ꠘꠤꠔꠦ ꠅꠁꠟꠦ, ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠡꠦ ꠁꠈꠣꠘ ꠈꠥꠟꠛꠣ, ꠛꠣꠖꠦ ꠀꠞꠇ ꠎꠣꠉꠣꠔ ꠉꠤꠀ ꠄꠇ ꠄꠇ ꠇꠞꠤ ꠎꠥꠠꠣ ꠟꠣꠉꠣꠁꠀ ꠢꠤꠞꠛꠣꠞ ꠛꠣꠘꠣꠁꠛꠣ। ꠈꠣꠟꠤ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘ ꠍꠣꠠꠣ ꠅꠁꠘ꠆ꠘ ꠇꠦꠃ ꠁꠔꠣꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠉꠦꠟꠦ ꠔꠣꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","ꠛꠣꠖ-ꠛꠣꠇꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠔꠣꠞꠣꠞ ꠚꠃꠎꠤ ꠖꠟ ꠝꠣꠚꠤꠇ ꠎꠣꠞꠎꠤꠞ ꠔꠣꠝ꠆ꠛꠥ ꠐꠣꠋꠉꠣꠁꠛꠣ। ꠙꠞꠔꠦꠇꠦ ꠎꠣꠞꠎꠤꠞ ꠖꠟꠞ ꠡꠤꠝꠣꠘꠣꠞ ꠝꠣꠎꠦ, ꠖꠟꠞ ꠘꠤꠡꠣꠘꠣ ꠟꠣꠉꠣꠁꠟ ꠙꠔꠣꠇꠣꠞ ꠔꠟꠦ ꠞꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠃꠙꠞꠦ ꠎꠣꠔꠦ ꠝꠣꠛꠥꠖꠞ ꠉꠎꠛ ꠘꠣ ꠟꠣꠝꠦ, ꠄꠞꠟꠣꠉꠤ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠡꠦ ꠀꠝꠣꠞ ꠡꠣꠢꠣꠖꠔ ꠔꠣꠝ꠆ꠛꠥꠞ ꠙꠣꠞꠣꠖꠣꠞꠤ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠀꠝꠣꠞ ꠊꠞꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠛꠣꠄ ꠔꠣꠞꠣꠞ ꠔꠣꠝ꠆ꠛꠥ ꠐꠣꠋꠉꠣꠁꠀ ꠞꠁꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠑꠤꠇ ꠅꠟꠣꠃ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠛꠣꠄ ꠕꠥꠠꠣ ꠈꠣꠟꠤ ꠎꠣꠉꠣ ꠕꠁꠀ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠔꠣꠞꠣꠞ ꠔꠣꠝ꠆ꠛꠥ ꠐꠣꠘꠣꠁꠛꠣ। ꠙꠞꠔꠦꠇꠦ ꠎꠣꠞꠎꠤꠞ ꠚꠃꠎꠤ ꠖꠟꠞ ꠡꠤꠝꠣꠘꠣꠔ ꠎꠣꠞꠎꠤꠞ ꠉꠥꠡ꠆ꠐꠤꠞ ꠙꠔꠣꠇꠣꠞ ꠗꠣꠞꠅ ꠞꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","“ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠙꠥꠛꠦꠖꠤ, ꠡꠥꠞꠥꠎ ꠃꠑꠣꠞ ꠝꠥꠈꠣ, ꠄꠢꠥꠖꠣꠞ ꠙꠔꠣꠇꠣꠞ ꠔꠤꠘꠅ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠚꠃꠎꠤ ꠖꠟꠦ ꠔꠣꠞꠣꠞ ꠔꠣꠝ꠆ꠛꠥ ꠐꠣꠘꠣꠁꠛꠣ। ꠄꠢꠥꠖꠣ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠅꠁꠟꠣ ꠀꠝꠤꠘꠣꠖꠣꠛꠞ ꠙꠥꠀ ꠘꠣꠢꠤꠡ, ");
INSERT INTO syls_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","ꠅꠃ ꠈꠣꠘ꠆ꠖꠣꠘꠅ ꠍꠤꠙꠣꠁꠞ ꠎꠥꠇꠣ ꠝꠣꠘꠥꠡ ꠅꠁꠟꠣ, ꠌꠃꠀꠔ꠆ꠔꠁꠞ ꠀꠎꠣꠞ ꠍꠄ-ꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","ꠄꠞꠣꠞ ꠄꠇ ꠉꠣꠟꠣꠔ ꠁꠍꠣꠈꠞ ꠈꠣꠘ꠆ꠖꠣꠘ ꠞꠁꠛꠣ, ꠅꠃ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠅꠁꠟꠣ ꠍꠥꠉꠣꠞꠞ ꠙꠥꠀ ꠘꠕꠘꠦꠟ, ");
INSERT INTO syls_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","ꠔꠣꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠅ ꠍꠤꠙꠣꠁꠞ ꠎꠥꠇꠣ ꠝꠣꠘꠥꠡ ꠅꠁꠟꠣ, ꠌꠃꠀꠘ꠆ꠘ ꠀꠎꠣꠞ ꠌꠣꠁꠞ-ꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","ꠖꠥꠍꠞꠣ ꠉꠣꠟꠣꠔ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠛꠣ ꠍꠛꠥꠟꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠦ, ꠅꠃ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠅꠁꠟꠣ ꠢꠦꠟꠘꠞ ꠙꠥꠀ ꠁꠟꠤꠀꠛ, ");
INSERT INTO syls_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","ꠔꠣꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠅ ꠍꠤꠙꠣꠁꠞ ꠎꠥꠇꠣ ꠝꠣꠘꠥꠡ ꠅꠁꠟꠣ, ꠡꠣꠔꠣꠘ꠆ꠘ ꠀꠎꠣꠞ ꠌꠣꠁꠞ-ꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","ꠄꠢꠥꠖꠣꠞ ꠙꠔꠣꠇꠣꠞ ꠅꠃ ꠔꠤꠘꠅ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠉꠘꠣ ꠍꠤꠙꠣꠁꠞ ꠎꠥꠇꠣ ꠝꠥꠐ ꠝꠣꠘꠥꠡ ꠅꠁꠟꠣ, ꠄꠇ ꠟꠣꠈ ꠍꠤꠀꠡꠤ ꠀꠎꠣꠞ ꠌꠣꠁꠞ-ꠡ। ꠍꠚꠞꠞ ꠡꠝꠄ ꠔꠣꠞꠣꠞ ꠇꠣꠚꠦꠟꠣ ꠢꠇꠟꠞ ꠀꠉꠦ ꠞꠅꠀꠘꠣ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠇ꠆ꠇꠤꠘ ꠉꠣꠟꠣꠔ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠛꠣ, ꠞꠥꠛꠦꠘꠞ ꠙꠔꠣꠇꠣꠞ ꠔꠤꠘꠅ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠚꠃꠎꠤ ꠖꠟꠦ। ꠞꠥꠛꠦꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠅꠁꠟꠣ ꠡꠣꠖꠤꠃꠞꠞ ꠙꠥꠀ ꠀꠟꠤꠍꠥꠞ, ");
INSERT INTO syls_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","ꠔꠣꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠅ ꠍꠤꠙꠣꠁꠞ ꠎꠥꠇꠣ ꠝꠣꠘꠥꠡ ꠅꠁꠟꠣ, ꠍꠄꠌꠣꠟ꠆ꠟꠤꠡ ꠀꠎꠣꠞ ꠙꠣꠌ-ꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","ꠄꠞꠣꠞ ꠄꠇ ꠉꠣꠟꠣꠔ ꠡꠤꠝꠤꠅꠘ ꠈꠣꠘ꠆ꠖꠣꠘ ꠞꠁꠛꠣ, ꠅꠃ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠥꠞꠡꠣꠖꠣꠄꠅꠞ ꠙꠥꠀ ꠡꠣꠟꠥꠝꠤꠟ ꠅꠁꠟꠣ ꠔꠣꠞꠣꠞ ꠡꠞ꠆ꠖꠣꠞ, ");
INSERT INTO syls_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","ꠔꠣꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠅ ꠍꠤꠙꠣꠁꠞ ꠎꠥꠇꠣ ꠝꠣꠘꠥꠡ ꠅꠁꠟꠣ, ꠃꠘꠥꠡꠣꠁꠐ ꠀꠎꠣꠞ ꠔꠤꠘ-ꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","ꠖꠥꠍꠞꠣ ꠉꠣꠟꠣꠔ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠛꠣ ꠍꠣꠖꠥ ꠈꠣꠘ꠆ꠖꠣꠘꠦ, ꠅꠃ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠅꠁꠟꠣ ꠖꠥꠄꠟꠞ ꠙꠥꠀ ꠁꠟꠤꠀꠍꠚ, ");
INSERT INTO syls_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","ꠔꠣꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠅ ꠍꠤꠙꠣꠁꠞ ꠎꠥꠇꠣ ꠝꠣꠘꠥꠡ ꠅꠁꠟꠣ, ꠙꠣꠌ꠆ꠌꠣꠟ꠆ꠟꠤꠡ ꠀꠎꠣꠞ ꠍꠄ-ꠡ ꠙꠁꠘ꠆ꠌꠣꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","ꠞꠥꠛꠦꠘꠞ ꠙꠔꠣꠇꠣꠞ ꠅꠃ ꠔꠤꠘꠅ ꠈꠣꠘ꠆ꠖꠣꠘꠅ ꠉꠘꠣ ꠍꠤꠙꠣꠁꠞ ꠎꠥꠇꠣ ꠝꠥꠐ ꠝꠣꠘꠥꠡ ꠅꠁꠟꠣ, ꠄꠇ ꠟꠣꠈ ꠄꠇꠣꠘ꠆ꠘ ꠀꠎꠣꠞ ꠌꠣꠁꠞ-ꠡ ꠙꠁꠘ꠆ꠌꠣꠡ ꠎꠘ। ꠍꠚꠞꠞ ꠡꠝꠄ ꠔꠣꠞꠣ ꠖꠥꠍꠞꠣ ꠇꠣꠚꠦꠟꠣꠔ ꠞꠅꠀꠘꠣ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“ꠛꠣꠖꠦ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠡꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞꠦ ꠟꠁꠀ ꠞꠅꠀꠘꠣ ꠖꠤꠛꠣ, ꠢꠇꠟꠞ ꠝꠣꠎꠈꠣꠘꠅ ꠄꠞꠣ ꠞꠁꠛꠣ। ꠎꠣꠞꠎꠤꠞ ꠔꠣꠝ꠆ꠛꠥ ꠐꠣꠘꠣꠘꠤꠞ ꠍꠤꠞꠤꠀꠟ ꠝꠣꠚꠤꠇ ꠟꠣꠁꠘ ꠗꠞꠤꠀ ꠞꠅꠀꠘꠣ ꠅꠁꠛꠣ। ꠚꠃꠎꠤ ꠖꠟꠞ ꠎꠣꠞꠎꠤꠞ ꠙꠔꠣꠇꠣꠞ ꠝꠣꠘꠥꠡ ꠘꠤꠎꠞ ꠖꠟꠞ ꠟꠉꠦ ꠞꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠙꠁꠌꠝꠞ ꠉꠣꠟꠣꠔ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠛꠣ, ꠀꠚꠞꠣꠁꠝ ꠙꠔꠣꠇꠣꠞ ꠔꠤꠘꠅ ꠚꠃꠎꠤ ꠖꠟꠞ ꠝꠣꠘꠡꠦ। ꠀꠚꠞꠣꠁꠝ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠅꠁꠟꠣ ꠀꠝꠤꠢꠥꠖꠞ ꠙꠥꠀ ꠀꠟꠤꠡꠣꠝꠣ, ");
INSERT INTO syls_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ꠅꠃ ꠈꠣꠘ꠆ꠖꠣꠘꠅ ꠍꠤꠙꠣꠁꠞ ꠎꠥꠇꠣ ꠝꠣꠘꠥꠡ ꠅꠁꠟꠣ, ꠌꠣꠟ꠆ꠟꠤꠡ ꠀꠎꠣꠞ ꠙꠣꠌ-ꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","ꠄꠞꠣꠞ ꠄꠇ ꠉꠣꠟꠣꠔ ꠝꠣꠘꠡꠣ ꠈꠣꠘ꠆ꠖꠣꠘꠦ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠛꠣ, ꠚꠣꠔꠡꠥꠞꠞ ꠙꠥꠀ ꠉꠝꠟꠤꠄꠟ ꠅꠁꠟꠣ ꠔꠣꠞꠣꠞ ꠡꠞ꠆ꠖꠣꠞ, ");
INSERT INTO syls_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","ꠅꠃ ꠈꠣꠘ꠆ꠖꠣꠘꠅ ꠍꠤꠙꠣꠁꠞ ꠎꠥꠇꠣ ꠝꠣꠘꠥꠡ ꠅꠁꠟꠣ, ꠛꠔ꠆ꠔꠤꠡ ꠀꠎꠣꠞ ꠖꠥꠁ-ꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","ꠀꠞ ꠖꠥꠍꠞꠣ ꠉꠣꠟꠣꠔ ꠞꠁꠛꠣ ꠛꠤꠘ-ꠁꠀꠝꠤꠘ ꠈꠣꠘ꠆ꠖꠣꠘ, ꠄꠞꠣꠞ ꠡꠞ꠆ꠖꠣꠞ ꠅꠁꠟꠣ ꠎꠤꠖꠣꠃꠘꠤꠞ ꠙꠥꠀ ꠀꠛꠤꠖꠣꠘ, ");
INSERT INTO syls_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","ꠔꠣꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠅ ꠍꠤꠙꠣꠁꠞ ꠎꠥꠇꠣ ꠝꠣꠘꠥꠡ ꠅꠁꠟꠣ, ꠙꠣꠄꠔꠤꠡ ꠀꠎꠣꠞ ꠌꠣꠁꠞ-ꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","ꠀꠚꠞꠣꠁꠝꠞ ꠙꠔꠣꠇꠣꠞ ꠅꠃ ꠔꠤꠘꠅ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠉꠘꠣ ꠍꠤꠙꠣꠁꠞ ꠎꠥꠇꠣ ꠝꠥꠐ ꠝꠣꠘꠥꠡ ꠅꠁꠟꠣ, ꠄꠇ ꠟꠣꠈ ꠀꠐ ꠀꠎꠣꠞ ꠄꠇ-ꠡ ꠎꠘ। ꠔꠣꠞꠣ ꠔꠤꠘ ꠘꠝ꠆ꠛꠞ ꠇꠣꠚꠦꠟꠣꠔ ꠞꠅꠀꠘꠣ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠃꠔ꠆ꠔꠞ ꠉꠣꠟꠣꠔ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠛꠣ ꠖꠣꠘ ꠙꠔꠣꠇꠣꠞ ꠔꠤꠘꠅ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠚꠃꠎꠤ ꠖꠟꠞ ꠝꠣꠘꠡꠦ, ꠔꠣꠞꠣꠞ ꠡꠞ꠆ꠖꠣꠞ ꠅꠁꠟꠣ ꠀꠝꠤꠡꠣꠖꠣꠞ ꠙꠥꠀ ꠀꠈꠤꠀꠎꠣꠞ, ");
INSERT INTO syls_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","ꠅꠃ ꠈꠣꠘ꠆ꠖꠣꠘꠅ ꠍꠤꠙꠣꠁꠞ ꠎꠥꠇꠣ ꠝꠣꠘꠥꠡ ꠅꠁꠟꠣ, ꠛꠣꠡꠐ꠆ꠐꠤ ꠀꠎꠣꠞ ꠡꠣꠔ-ꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","ꠄꠞꠣꠞ ꠄꠇ ꠉꠣꠟꠣꠔ ꠀꠡꠤꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠦ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠛꠣ, ꠅꠃ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠅꠁꠟꠣ, ꠃꠇꠞꠣꠘꠞ ꠙꠥꠀ ꠚꠎꠤꠄꠟ। ");
INSERT INTO syls_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","ꠔꠣꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠅ ꠍꠤꠙꠣꠁꠞ ꠎꠥꠇꠣ ꠝꠣꠘꠥꠡ ꠅꠁꠟꠣ, ꠄꠇꠌꠣꠟ꠆ꠟꠤꠡ ꠀꠎꠣꠞ ꠙꠣꠌ-ꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","ꠀꠞ ꠖꠥꠍꠞꠣ ꠉꠣꠟꠣꠔ ꠞꠁꠛꠣ ꠘꠙ꠆ꠔꠣꠟꠤ ꠈꠣꠘ꠆ꠖꠣꠘ, ꠅꠃ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠅꠁꠟꠣ, ꠁꠘꠣꠘꠞ ꠙꠥꠀ ꠀꠢꠤꠞ। ");
INSERT INTO syls_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","ꠔꠣꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠅ ꠍꠤꠙꠣꠁꠞ ꠎꠥꠇꠣ ꠝꠣꠘꠥꠡ ꠅꠁꠟꠣ, ꠔꠦꠙ꠆ꠙꠣꠘ꠆ꠘ ꠀꠎꠣꠞ ꠌꠣꠁꠞ-ꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","ꠖꠣꠘꠞ ꠙꠔꠣꠇꠣꠞ ꠅꠃ ꠔꠤꠘꠅ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠉꠘꠣ ꠍꠤꠙꠣꠁꠞ ꠎꠥꠇꠣ ꠝꠥꠐ ꠝꠣꠘꠥꠡ ꠅꠁꠟꠣ, ꠄꠇ ꠟꠣꠈ ꠡꠣꠔꠣꠘ꠆ꠘ ꠀꠎꠣꠞ ꠍꠄ-ꠡ ꠎꠘ। ꠄꠞꠣ ꠢꠇꠟ ꠢꠦꠡꠞ ꠇꠣꠚꠦꠟꠣꠔ ꠞꠅꠀꠘꠣ ꠖꠤꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠞꠎꠤꠞ ꠉꠥꠡ꠆ꠐꠤ ꠝꠣꠚꠤꠇ ꠉꠘꠣ ꠅꠁꠟ। ꠉꠘꠤꠀ ꠢꠣꠞꠟꠦ ꠢꠇꠟ ꠚꠃꠎꠤ ꠖꠟꠦ ꠍꠤꠙꠣꠁꠞ ꠎꠥꠇꠣ ꠝꠥꠐ ꠝꠣꠘꠥꠡ ꠅꠁꠟꠣ, ꠍꠄ ꠟꠣꠈ ꠔꠤꠘ ꠀꠎꠣꠞ ꠙꠣꠌ-ꠡ ꠙꠁꠘ꠆ꠌꠣꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","ꠔꠣ-ꠅ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠉꠘꠣꠞ ꠡꠝꠄ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞꠦ ꠉꠘꠣꠔ ꠗꠞꠣ ꠅꠁꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠢꠇꠟ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠔꠣ ꠅꠃ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ। ꠔꠣꠞꠣ ꠎꠣꠞꠎꠤꠞ ꠖꠟꠞ ꠎꠣꠉꠣꠔ ꠔꠣꠝ꠆ꠛꠥ ꠐꠣꠘꠣꠁꠔꠣ, ꠀꠞ ꠍꠚꠞꠅ ꠞꠅꠀꠘꠣ ꠅꠁꠔꠣ ꠘꠤꠎꠞ ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠙꠞꠤꠛꠣꠞ ꠝꠣꠚꠤꠇ ꠀꠙꠘ ꠚꠃꠎꠤ ꠖꠟꠞ ꠙꠔꠣꠇꠣꠞ ꠗꠣꠞꠅ ꠞꠁꠀ। ");
INSERT INTO syls_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","ꠔꠥꠞ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠝꠣꠛꠥꠖꠦ ꠎꠦꠛꠟꠣ ꠝꠥꠍꠣ ꠘꠛꠤꠞ ꠟꠉꠦ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠍꠟꠣ, ꠢꠃ ꠡꠝꠄ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠘ ꠜꠣꠁ ꠝꠥꠍꠣꠞ ꠛꠋꠡ-ꠛꠥꠘꠤꠀꠖ ꠀꠍꠟꠣ ꠅꠃ ꠄꠁꠘꠔꠣꠁꠘ: ");
INSERT INTO syls_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","ꠢꠣꠞꠥꠘꠞ ꠙꠥꠀꠂꠘ ꠅꠁꠟꠣ ꠘꠣꠖꠣꠛ, ꠀꠛꠤꠢꠥ, ꠀꠟꠤ-ꠀꠎꠞ ꠀꠞ ꠁꠍꠣꠝꠣꠞ। ꠄꠞꠣꠞ ꠝꠣꠎꠦ ꠘꠣꠖꠣꠛ ꠀꠍꠟꠣ ꠛꠠ। ");
INSERT INTO syls_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","ꠁꠝꠣꠝꠔꠤ ꠇꠣꠝꠞ ꠟꠣꠉꠤ ꠢꠣꠞꠥꠘꠞ ꠅꠃ ꠌꠣꠁꠞꠅ ꠙꠥꠀꠂꠘꠞꠦ ꠈꠦꠟꠣꠚꠔꠤ ꠖꠤꠀ ꠄꠛꠣꠖꠔꠤ ꠇꠣꠝꠅ ꠛꠅꠀꠁꠟ ꠇꠞꠣ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","ꠅꠁꠟꠦ ꠍꠤꠘꠣꠁ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠞꠅꠀꠞ ꠇꠣꠟꠅ, ꠘꠣꠖꠣꠛ ꠀꠞ ꠀꠛꠤꠢꠥꠄ ꠝꠣꠛꠥꠖꠞ ꠛꠣꠔꠣꠁꠟ ꠘꠤꠅꠝ ꠜꠣꠋꠉꠤꠀ, ꠖꠥꠍꠞꠣ ꠀꠉꠥꠁꠘꠖꠤ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠘꠤꠞ ꠡꠝꠄ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦꠃ ꠔꠣꠞꠣꠞ ꠝꠞꠘ ꠅꠁꠉꠦꠟ। ꠔꠣꠞꠣꠞ ꠇꠥꠘꠥ ꠀꠅꠟꠣꠖ ꠘꠣ ꠕꠣꠇꠣꠄ, ꠔꠣꠞꠣꠞ ꠛꠣꠚ ꠢꠣꠞꠥꠘ ꠘꠛꠤꠞ ꠟꠉꠦ ꠞꠁꠀ ꠀꠟꠤ-ꠀꠎꠞ ꠀꠞ ꠁꠍꠣꠝꠣꠞꠦ ꠁꠝꠣꠝꠔꠤ ꠇꠣꠝ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“ꠔꠥꠝꠤ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠡꠞꠦ ꠀꠘꠤꠀ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠀꠔꠅ ꠡꠝꠎꠣꠅ, ꠔꠣꠞꠣ ꠁꠝꠣꠝꠔꠤ ꠇꠣꠝꠅ ꠔꠣꠘꠞꠦ ꠡꠣꠁꠎ꠆ꠎ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","ꠔꠣꠞꠣ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠎꠤꠝ꠆ꠝꠣꠄ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠍꠣꠝꠘꠦ ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠔꠞꠚ ꠕꠣꠇꠤ ꠀꠝꠣꠞ ꠊꠞꠞ ꠈꠣꠖꠤꠝꠖꠣꠞꠤ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","ꠔꠣꠞꠣꠃ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠖꠦꠈꠣ-ꠢꠥꠘꠣ ꠀꠞ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠈꠦꠎꠝꠔ ꠇꠞꠤꠀ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠙꠇ꠆ꠇꠦ ꠄꠛꠣꠖꠔ-ꠛꠘ꠆ꠖꠦꠉꠤꠞ ꠖꠣꠄ-ꠖꠣꠄꠁꠔ꠆ꠔ ꠀꠖꠣꠄ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠈꠣꠖꠤꠝ ꠅꠇꠟꠞꠦ ꠔꠥꠝꠤ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠀꠔꠅ ꠡꠝꠎꠣꠁ ꠖꠦꠅ। ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠄꠞꠣꠞꠦ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠀꠔꠅ ꠡꠙꠤ ꠖꠦꠅꠀ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","ꠁꠝꠣꠝꠔꠤ ꠇꠣꠝꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠤ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠛꠋꠡꠞꠦ ꠛꠣꠍꠤꠀ ꠘꠦꠅ। ꠔꠣꠞꠣ ꠍꠣꠠꠣ ꠖꠥꠍꠞꠣ ꠇꠦꠃ ꠁꠝꠣꠝꠔꠤ ꠇꠞꠣꠔ ꠉꠦꠟꠦ ꠅꠉꠥꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠣ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠄꠅꠈꠣꠘ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“ꠢꠥꠘꠅ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠤ ꠛꠦꠐꠤꠘ꠆ꠔꠞ ꠊꠞꠅ ꠎꠘꠝ ꠟꠅꠀ ꠙꠄꠟꠣ ꠙꠥꠀꠞ ꠛꠖꠟꠣ ꠛꠣꠛꠔ, ꠀꠝꠤ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞꠦ ꠙꠍꠘ꠆ꠖ ꠇꠞꠍꠤ। ꠄꠞꠟꠣꠉꠤ ꠟꠦꠛꠤ ꠅꠇꠟ ꠀꠝꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","ꠀꠍꠟꠦ ꠢꠇ꠆ꠇꠟ ꠙꠄꠟꠣ ꠙꠥꠀꠂꠘꠃ ꠀꠝꠣꠞ। ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠢꠇꠟ ꠙꠄꠟꠣ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠝꠣꠞꠤꠟꠤꠛꠣꠞ ꠖꠤꠘ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠙꠞꠔꠦꠇ ꠙꠄꠟꠣ ꠙꠥꠀꠞꠦ ꠀꠝꠣꠞ ꠟꠣꠉꠤ ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠤꠀ ꠞꠣꠈꠍꠤ, ꠁꠔꠣ ꠝꠣꠘꠡꠞ ꠙꠥꠔ ꠅꠃꠇ ꠛꠣ ꠙꠡꠥꠞ ꠛꠣꠁꠌ꠆ꠌꠣ ꠅꠃꠇ। ꠔꠣꠞꠣ ꠔ ꠀꠝꠣꠞ, ꠀꠝꠤꠃ ꠝꠣꠛꠥꠖ।” ");
INSERT INTO syls_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","ꠍꠤꠘꠣꠁ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠝꠣꠎꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“ꠔꠥꠝꠤ ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠙꠞꠤꠛꠣꠞ ꠝꠣꠚꠤꠇ ꠟꠦꠛꠤ ꠅꠇꠟꠞꠦ ꠉꠘꠅ। ꠄꠇ ꠝꠣꠡ ꠛꠣ ꠄꠞ ꠛꠦꠡꠤ ꠛꠄꠅꠡꠞ ꠢꠇꠟ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠞꠦ ꠉꠘꠅ।” ");
INSERT INTO syls_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠔꠣꠁꠘ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞꠦ ꠉꠘꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","ꠉꠘꠣꠞ ꠇꠣꠟꠅ ꠙꠣꠁꠟꠣ, ꠟꠦꠛꠤꠞ ꠙꠥꠀꠂꠘ ꠎꠣꠞꠍꠥꠘ, ꠇꠣꠢꠣꠔ ꠀꠞ ꠝꠣꠞꠣꠞꠤ। ");
INSERT INTO syls_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","ꠎꠣꠞꠍꠥꠘꠞ ꠙꠥꠀꠂꠘ ꠟꠤꠛꠘꠤ ꠀꠞ ꠡꠤꠝꠦꠁ ꠀꠍꠟꠣ ꠖꠥꠁ ꠉꠥꠡ꠆ꠐꠤꠞ ꠝꠥꠞꠛ꠆ꠛꠤ ꠘꠦꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","ꠇꠣꠢꠣꠔꠞ ꠙꠥꠀꠂꠘ ꠁꠝꠞꠣꠘ, ꠁꠎꠢꠣꠞ, ꠢꠦꠛꠞꠘ ꠀꠞ ꠃꠎ꠆ꠎꠟ ꠅꠁꠟꠣ ꠌꠣꠁꠞ ꠜꠣꠁ। ");
INSERT INTO syls_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","ꠝꠣꠞꠣꠞꠤꠞ ꠙꠥꠀꠂꠘ ꠝꠢꠟꠤ ꠀꠞ ꠝꠥꠡꠤ ꠅꠁꠟꠣ ꠖꠥꠁ ꠜꠣꠁ। ꠄꠞꠣ ꠅꠁꠟꠣ ꠛꠋꠡ ꠀꠞ ꠙꠞꠤꠛꠣꠞ ꠢꠤꠡꠣꠛꠦ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠘꠣꠘꠣꠘ ꠉꠥꠡ꠆ꠐꠤ। ");
INSERT INTO syls_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","ꠎꠣꠞꠍꠥꠘ ꠀꠍꠟꠣ ꠟꠤꠛꠘꠤꠀ ꠀꠞ ꠡꠤꠝꠦꠁꠀ ꠉꠥꠡ꠆ꠐꠤꠞ ꠝꠥꠟ ꠝꠥꠞꠛ꠆ꠛꠤ। ");
INSERT INTO syls_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","ꠄꠞꠣꠞ ꠝꠣꠎꠦ ꠄꠇ ꠝꠣꠡ ꠀꠞ ꠄꠇ ꠝꠣꠡꠞ ꠛꠦꠡꠤ ꠛꠄꠅꠡꠞ ꠢꠇꠟ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠉꠘꠤꠀ ꠡꠣꠠꠦ ꠡꠣꠔ ꠀꠎꠣꠞ ꠙꠣꠅꠀ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","ꠙꠌ꠆ꠌꠤꠝ ꠉꠣꠟꠣꠛꠣꠄ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠈꠞꠦꠖꠤ ꠎꠣꠞꠍꠥꠘꠤ ꠅꠇꠟꠞ ꠔꠣꠝ꠆ꠛꠥ ꠐꠣꠋꠉꠣꠘꠤ ꠅꠁꠔ। ");
INSERT INTO syls_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","ꠎꠣꠞꠍꠥꠘ ꠉꠥꠡ꠆ꠐꠤꠞ ꠙꠞꠗꠣꠘ ꠀꠍꠟꠣ ꠟꠣꠄꠄꠟꠞ ꠙꠥꠀ ꠁꠟꠤꠀꠍꠚ। ");
INSERT INTO syls_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠛꠦꠙꠣꠞꠦ ꠎꠣꠞꠍꠥꠘꠤ ꠅꠇꠟꠞ ꠃꠙꠞꠦ, ꠎꠦꠔꠣ ꠇꠣꠙꠠꠣꠁꠘ ꠖꠤꠀ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞ ꠛꠣꠘꠣꠘꠤ ꠅꠁꠍꠦ ꠈꠣꠟꠤ ꠅꠔꠣ ꠇꠣꠙꠠ ꠅꠇꠟ, ꠛꠣꠞꠣ ꠛꠣꠎꠥꠞ ꠉꠤꠟꠣꠚ ꠀꠞ ꠍꠣꠘꠤ ꠅꠇꠟ ꠀꠞ ꠅꠃ ꠊꠞꠞ ꠜꠤꠔꠞꠦ ꠢꠣꠝꠣꠁꠛꠣꠞ ꠙꠞ꠆ꠖꠣ ꠖꠦꠈꠣ-ꠢꠥꠘꠣ ꠇꠞꠣꠞ ꠖꠣꠄꠁꠔ꠆ꠔ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ꠀꠞ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞ ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠎꠦ ꠃꠑꠣꠘ ꠀꠍꠦ ꠅꠉꠥꠞ ꠙꠞ꠆ꠖꠣꠁꠘ, ꠀꠞ ꠃꠑꠣꠘꠅ ꠢꠣꠝꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠎꠦ ꠉꠦꠁꠐ ꠀꠍꠦ ꠅꠃ ꠉꠦꠁꠐꠞ ꠙꠞ꠆ꠖꠣ, ꠀꠞ ꠡꠛ ꠞꠡꠤ ꠅꠇꠟꠞꠃ ꠖꠦꠈꠣ-ꠢꠥꠘꠣ ꠇꠞꠣ, ꠀꠞ ꠅꠔꠣ ꠢꠇꠟ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠣ, ꠅꠃ ꠢꠇ꠆ꠇꠟꠔꠣꠃ ꠔꠣꠘꠔꠣꠘꠞ ꠖꠣꠄꠁꠔ꠆ꠔ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","ꠇꠣꠢꠣꠔ ꠀꠍꠟꠣ ꠁꠝꠞꠣꠘ, ꠁꠎꠢꠣꠞ, ꠢꠦꠛꠞꠘ ꠀꠞ ꠃꠎ꠆ꠎꠟ, ꠅꠃ ꠌꠣꠁꠞ ꠉꠥꠡ꠆ꠐꠤꠞ ꠝꠥꠟ ꠝꠥꠞꠛ꠆ꠛꠤ। ");
INSERT INTO syls_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","ꠅꠃ ꠉꠥꠡ꠆ꠐꠤꠘ꠆ꠔꠞ ꠝꠣꠎꠦ ꠄꠇ ꠝꠣꠡ ꠛꠣ ꠔꠣꠞ ꠛꠦꠡꠤ ꠛꠄꠅꠡꠞ ꠢꠇꠟ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠉꠘꠤꠀ ꠀꠐ ꠀꠎꠣꠞ ꠍꠄ-ꠡ ꠎꠘ ꠙꠣꠅꠀ ꠉꠦꠟ। ꠄꠞꠣꠞ ꠖꠣꠄꠁꠔ꠆ꠔ ꠀꠍꠤꠟ ꠙꠛꠤꠔ꠆ꠞ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠖꠦꠈꠣ-ꠢꠥꠘꠣ ꠇꠞꠣ। ");
INSERT INTO syls_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠖꠇ꠆ꠇꠤꠘ ꠉꠣꠟꠣꠛꠣꠄ ꠇꠣꠢꠣꠔꠤ ꠅꠇꠟꠞ ꠔꠣꠝ꠆ꠛꠥ ꠐꠣꠋꠉꠣꠘꠤ ꠅꠁꠔ। ");
INSERT INTO syls_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","ꠇꠣꠢꠣꠔꠤ ꠉꠥꠡ꠆ꠐꠤꠞ ꠙꠞꠗꠣꠘ ꠀꠍꠟꠣ ꠃꠎ꠆ꠎꠟꠞ ꠙꠥꠀ ꠁꠟꠤꠎꠣꠚꠘ। ");
INSERT INTO syls_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","ꠅꠃ ꠇꠣꠢꠣꠔꠤ ꠉꠥꠡ꠆ꠐꠤꠞ ꠖꠣꠄꠁꠔ꠆ꠔ ꠀꠍꠤꠟ ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇ, ꠐꠦꠛꠥꠟ, ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤ, ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ, ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠘꠤꠞ ꠐꠦꠛꠥꠟ, ꠙꠛꠤꠔ꠆ꠞ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠄꠛꠣꠖꠔꠤꠞ ꠢꠇꠟ ꠎꠤꠘꠤꠡ ꠀꠞ ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚꠞ ꠙꠞ꠆ꠖꠣꠞ ꠖꠦꠈꠣ-ꠢꠥꠘꠣ ꠇꠞꠣ, ꠟꠉꠦ ꠛꠣꠖ-ꠛꠣꠇꠤ ꠇꠣꠝ ꠇꠞꠣ। ");
INSERT INTO syls_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠘꠣꠘꠣꠘ ꠉꠥꠡ꠆ꠐꠤꠞ ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟꠞ ꠙꠞꠗꠣꠘ ꠀꠍꠟꠣ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠙꠥꠀ ꠀꠟꠤ-ꠀꠎꠞ। ꠄꠞꠟꠉꠦ ꠙꠛꠤꠔ꠆ꠞ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠖꠦꠈꠣ-ꠢꠥꠘꠣꠞ ꠖꠣꠄꠁꠔ꠆ꠔ ꠎꠦꠞꠣꠞꠦ ꠖꠦꠅꠀ ꠅꠁꠍꠤꠟ, ꠄꠞꠣꠞꠦ ꠘꠎꠞꠖꠣꠞꠤ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠔꠣꠘꠞꠦ ꠛꠅꠀꠁꠟ ꠇꠞꠣ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","ꠝꠣꠞꠣꠞꠤ ꠀꠍꠟꠣ ꠝꠢꠟꠤ ꠀꠞ ꠝꠥꠡꠤꠞ ꠅꠃ ꠖꠥꠁ ꠉꠥꠡ꠆ꠐꠤꠞ ꠝꠥꠟ ꠝꠥꠞꠛ꠆ꠛꠤ। ");
INSERT INTO syls_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","ꠅꠃ ꠉꠥꠡ꠆ꠐꠤꠘ꠆ꠔꠞ ꠝꠣꠎꠦ ꠄꠇ ꠝꠣꠡ ꠛꠣ ꠔꠣꠞ ꠛꠦꠡꠤ ꠛꠄꠅꠡꠞ ꠢꠇꠟ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠉꠘꠤꠀ ꠍꠄ ꠀꠎꠣꠞ ꠖꠥꠁ-ꠡ ꠙꠣꠅꠀ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","ꠝꠣꠞꠣꠞꠤꠀ ꠉꠥꠡ꠆ꠐꠤꠞ ꠙꠞꠗꠣꠘ ꠀꠍꠟꠣ ꠀꠛꠤꠄꠟꠞ ꠙꠥꠀ ꠍꠥꠞꠤꠄꠟ। ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠃꠔꠞꠦꠖꠤ ꠔꠣꠞꠣꠞ ꠔꠣꠝ꠆ꠛꠥ ꠐꠣꠋꠉꠣꠘꠤ ꠅꠁꠔ। ");
INSERT INTO syls_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","ꠄꠞꠣꠞ ꠖꠣꠄꠁꠔ꠆ꠔ ꠀꠍꠤꠟ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠚ꠆ꠞꠦꠁꠝ, ꠚ꠆ꠞꠦꠁꠝꠞ ꠛꠣꠔ꠆ꠔꠤ, ꠈꠥꠐꠤ, ꠌꠥꠘ꠆ꠉꠤ ꠀꠞ ꠄꠞ ꠢꠇꠟ ꠌꠤꠎ, ");
INSERT INTO syls_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ꠃꠑꠣꠘꠞ ꠛꠦꠠꠣꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠞ ꠈꠥꠐꠤ, ꠌꠥꠘ꠆ꠉꠤ, ꠛꠦꠠꠣ ꠐꠣꠘꠣꠘꠤꠞ ꠞꠡꠤ ꠀꠞ ꠙꠦꠞꠦꠉꠞ ꠖꠦꠈꠣ-ꠢꠥꠘꠣ ꠀꠞ ꠄꠞ ꠟꠉꠞ ꠢꠇꠟ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠣ। ");
INSERT INTO syls_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠍꠣꠝꠘꠦꠖꠤ ꠝꠣꠘꠤ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠙꠥꠛꠦꠖꠤ ꠢꠎꠞꠔ ꠝꠥꠍꠣ, ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠔꠣꠝ꠆ꠛꠥ ꠅꠇꠟ ꠐꠣꠋꠉꠣꠘꠤ ꠅꠁꠔ। ꠄꠞꠣꠞ ꠖꠣꠄꠁꠔ꠆ꠔ ꠀꠍꠤꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠔꠞꠚ ꠕꠣꠇꠤ ꠙꠛꠤꠔ꠆ꠞ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠔ ꠢꠇꠟ ꠄꠛꠣꠖꠔꠤ ꠇꠣꠝ ꠀꠖꠣꠄ ꠇꠞꠣ। ꠄꠞꠣ ꠍꠣꠠꠣ ꠀꠞ ꠇꠦꠃ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠉꠦꠟꠦ ꠔꠣꠞꠦ ꠝꠣꠞꠤꠟꠣꠅꠀ ꠅꠁꠔ। ");
INSERT INTO syls_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠦ, ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠄꠇ ꠝꠣꠡ ꠛꠣ ꠔꠣꠞ ꠛꠦꠡꠤ ꠛꠄꠅꠡꠞ ꠢꠇꠟ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠉꠥꠡ꠆ꠐꠤ ꠝꠣꠚꠤꠇ ꠉꠘꠤꠟꠣ, ꠉꠘꠤꠀ ꠛꠣꠁꠡ ꠀꠎꠣꠞ ꠎꠘ ꠙꠣꠅꠀ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠢꠇꠟ ꠙꠞꠤꠛꠣꠞꠞ ꠙꠄꠟꠣ ꠙꠥꠀꠂꠘꠞꠦ ꠉꠘꠅ, ꠎꠦꠞꠣꠞ ꠛꠄꠅꠡ ꠄꠇ ꠝꠣꠡ ꠛꠣ ꠄꠞ ꠛꠦꠡꠤ, ꠄꠞꠣꠞꠦ ꠉꠘꠤꠀ ꠄꠞꠣꠞ ꠘꠣꠝ ꠄꠇ ꠈꠣꠔꠣꠔ ꠟꠦꠈꠅ। ");
INSERT INTO syls_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠢꠇꠟ ꠙꠄꠟꠣ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠎꠣꠘꠞ ꠛꠖꠟꠣ ꠟꠦꠛꠤ ꠅꠇꠟꠞꠦ ꠀꠝꠣꠞ ꠇꠁꠀ ꠉꠘꠣ ꠅꠁꠛ। ꠀꠞ ꠔꠣꠞꠣꠞ ꠙꠡꠥꠞ ꠙꠄꠟꠣ ꠛꠣꠁꠌ꠆ꠌꠣꠞ ꠛꠖꠟꠣ ꠟꠦꠛꠤ ꠅꠇꠟꠞ ꠙꠡꠥꠞ ꠙꠄꠟꠣ ꠛꠣꠁꠌ꠆ꠌꠣꠞꠦ ꠀꠝꠣꠞ ꠇꠁꠀ ꠉꠘꠣ ꠅꠁꠛ। ꠀꠝꠤꠃ ꠝꠣꠛꠥꠖ।” ");
INSERT INTO syls_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠝꠥꠍꠣꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠢꠇꠟ ꠙꠞꠤꠛꠣꠞꠞ ꠙꠄꠟꠣ ꠙꠥꠀꠂꠘꠞꠦ ꠉꠘꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","ꠔꠦꠃ ꠄꠇ ꠝꠣꠡ ꠛꠣ ꠔꠣꠞ ꠛꠦꠡꠤ ꠛꠄꠅꠡꠤ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠉꠘꠤꠀ ꠝꠥꠐ ꠛꠣꠁꠡ ꠀꠎꠣꠞ ꠖꠥꠁ-ꠡ ꠔꠦꠀꠔ꠆ꠔꠁꠞ ꠎꠘ ꠙꠣꠅꠀ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠀꠞꠅ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠢꠇꠟ ꠙꠄꠟꠣ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠛꠖꠟꠣ ꠟꠦꠛꠤ ꠅꠇꠟꠞꠦ, ꠀꠞ ꠔꠣꠞꠣꠞ ꠙꠄꠟꠣ ꠙꠡꠥꠞ ꠛꠣꠁꠌ꠆ꠌꠣꠞ ꠛꠖꠟꠣ ꠟꠦꠛꠤ ꠅꠇꠟꠞ ꠙꠄꠟꠣ ꠙꠡꠥꠞ ꠛꠣꠁꠌ꠆ꠌꠣꠞꠦ ꠀꠝꠣꠞ ꠇꠁꠀ ꠗꠞꠣ ꠅꠁꠛ। ꠟꠦꠛꠤ ꠅꠇꠟ ꠔ ꠀꠝꠣꠞ ꠅꠁꠛꠣ। ꠀꠝꠤꠃ ꠝꠣꠛꠥꠖ। ");
INSERT INTO syls_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠥꠐ ꠙꠞꠤꠝꠣꠘ ꠕꠣꠇꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠙꠄꠟꠣ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠙꠞꠤꠝꠣꠘ ꠖꠥꠁ-ꠡ ꠔꠦꠀꠔ꠆ꠔꠁꠞ ꠎꠘ ꠛꠦꠡꠤ। ");
INSERT INTO syls_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ꠅꠃ ꠖꠥꠁ-ꠡ ꠔꠦꠀꠔ꠆ꠔꠁꠞ ꠎꠘꠞꠦ ꠈꠣꠟꠣꠍ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠎꠣꠘꠞ ꠛꠖꠟꠣ ꠢꠤꠡꠣꠛꠦ, ꠙꠞꠔꠦꠇ ꠎꠘꠞ ꠟꠣꠉꠤ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠝꠣꠙꠦ ꠙꠣꠌ ꠔꠟꠣ ꠞꠥꠙꠣ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","ꠀꠖꠣꠄ ꠇꠞꠣ ꠅꠃ ꠞꠥꠙꠣ ꠘꠤꠀ ꠔꠥꠝꠤ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠖꠤꠟꠣꠁꠅ।” ");
INSERT INTO syls_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","ꠔꠦꠃ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠛꠖꠟꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠈꠣꠟꠣꠍ ꠇꠞꠤꠀ ꠘꠤꠛꠣꠞ ꠛꠣꠖꠦ, ꠔꠣꠞꠣꠞ ꠎꠔ ꠎꠘ ꠛꠣꠇꠤ ꠞꠁꠟꠣ, ꠄꠞꠣꠞ ꠎꠣꠘꠞ ꠛꠖꠟꠣ ꠢꠤꠡꠣꠛꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠞꠥꠙꠣ ꠀꠖꠣꠄ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ꠔꠣꠁꠘ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠙꠄꠟꠣ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠝꠣꠙꠦ ꠄꠇ ꠀꠎꠣꠞ ꠔꠤꠘ-ꠡ ꠙꠄꠡꠐ꠆ꠐꠤ ꠔꠟꠣ ꠞꠥꠙꠣ ꠀꠖꠣꠄ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠝꠥꠍꠣꠄ ꠅꠃ ꠞꠥꠙꠣ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠖꠤꠟꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘ ꠘꠛꠤꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“ꠔꠥꠝꠞꠣ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠎꠞ ꠇꠣꠢꠣꠔꠤ ꠅꠇꠟ ꠀꠟꠣꠖꠣ ꠇꠞꠤ ꠉꠘꠅ, ꠔꠣꠞꠣꠞ ꠢꠇꠟ ꠙꠞꠤꠛꠣꠞ ꠀꠞ ꠉꠥꠡ꠆ꠐꠤ ꠝꠣꠚꠤꠇ ꠉꠘꠅ। ");
INSERT INTO syls_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","ꠔꠤꠡ ꠕꠣꠇꠤ ꠙꠁꠘ꠆ꠌꠣꠡ ꠛꠍꠞ ꠛꠄꠅꠡꠞ ꠎꠦꠔꠣ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠣꠔ ꠀꠁꠛꠣ, ꠈꠣꠟꠤ ꠔꠣꠞꠣꠞꠦ ꠉꠘꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“ꠇꠣꠢꠣꠔꠤ ꠅꠇꠟꠞ ꠇꠣꠝ ꠅꠁꠛ, ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠈꠣꠍ ꠙꠛꠤꠔ꠆ꠞ ꠌꠤꠎ ꠅꠇꠟꠞ ꠖꠦꠈꠣ-ꠢꠥꠘꠣ ꠇꠞꠣ। ");
INSERT INTO syls_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠍꠚꠞꠅ ꠛꠣꠞꠘꠤꠞ ꠡꠝꠄ, ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠀꠝꠣꠞ ꠊꠞꠞ ꠜꠤꠔꠞꠦ ꠢꠣꠝꠣꠁꠀ, ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚꠞ ꠙꠞ꠆ꠖꠣ ꠈꠥꠟꠤꠀ ꠢꠣꠞꠤ, ꠅꠈꠣꠘꠖꠤ ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇꠞꠦ ꠉꠥꠞꠤꠀ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ꠄꠞ ꠃꠙꠞꠦ ꠖꠞꠤꠀꠞ ꠚꠥʼ ꠝꠣꠍꠞ ꠌꠣꠝꠠꠣꠞ ꠉꠤꠟꠣꠚꠖꠤ ꠉꠥꠞꠤꠛꠣ, ꠛꠣꠖꠦ ꠙꠥꠞꠣꠙꠥꠞ ꠟꠤꠟꠥꠀ ꠞꠋꠉꠞ ꠄꠇꠈꠣꠘ ꠇꠣꠙꠠꠖꠤ ꠉꠥꠞꠤꠀ ꠖꠤꠀ, ꠡꠘ꠆ꠖꠥꠇ ꠛꠁꠀ ꠘꠤꠛꠣꠞ ꠛꠦꠘ꠆ꠖꠣ ꠉꠥꠁꠘ ꠎꠣꠉꠣ ꠝꠔ ꠢꠣꠞꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","ꠙꠛꠤꠔ꠆ꠞ ꠞꠥꠐꠤ ꠞꠣꠈꠣꠞ ꠐꠦꠛꠥꠟꠞ ꠃꠙꠞꠦ ꠔꠣꠞꠣ ꠟꠤꠟꠥꠀ ꠞꠋꠉꠞ ꠄꠇꠈꠣꠘ ꠇꠣꠙꠠ ꠛꠤꠍꠣꠁꠀ, ꠅꠈꠣꠘꠞ ꠃꠙꠞꠦ ꠢꠥꠞꠥ-ꠛꠠ ꠢꠇꠟ ꠕꠣꠟ-ꠛꠣꠡꠘ, ꠀꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣ ꠓꠣꠟꠤꠛꠣꠞ ꠎꠉ-ꠝꠉ ꠕꠁꠛꠣ। ꠙꠛꠤꠔ꠆ꠞ ꠎꠦꠔꠣ ꠞꠥꠐꠤ ꠢꠣꠝꠦꠡꠣ ꠐꠦꠛꠥꠟꠞ ꠃꠙꠞꠦ ꠕꠅꠀ ꠕꠣꠇꠦ, ꠁꠔꠣ ꠐꠦꠛꠥꠟꠞ ꠃꠙꠞꠦꠃ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ꠅꠔꠣꠞ ꠃꠙꠞꠦ ꠟꠣꠟ ꠄꠇꠈꠣꠘ ꠇꠣꠙꠠ ꠛꠤꠍꠣꠁꠀ, ꠚꠥʼꠞ ꠌꠣꠝꠠꠣꠖꠤ ꠅꠈꠣꠘꠞꠦ ꠉꠥꠞꠤꠛꠣ, ꠀꠞ ꠐꠦꠛꠥꠟ ꠛꠁꠀ ꠘꠤꠛꠣꠞ ꠛꠦꠘ꠆ꠖꠣ ꠉꠥꠁꠘ ꠎꠣꠉꠣ ꠝꠔ ꠢꠣꠞꠣꠁ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","ꠛꠣꠖꠦ ꠟꠤꠟꠥꠀ ꠄꠇꠈꠣꠘ ꠇꠣꠙꠠꠖꠤ ꠀꠡ꠆ꠔꠣ ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤ, ꠄꠞ ꠌꠦꠞꠣꠉ ꠅꠇꠟ, ꠌꠦꠞꠣꠉꠞ ꠚꠤꠔꠣ ꠍꠣꠚ ꠇꠞꠣꠞ ꠌꠤꠝꠐꠣ, ꠎꠣꠟꠣꠁꠟ ꠚꠤꠔꠣꠞ ꠍꠣꠟꠤ ꠕꠅꠀꠞ ꠛꠣꠐꠤ ꠀꠞ ꠔꠦꠟꠞ ꠚꠤꠚꠣꠞꠦ ꠉꠥꠞꠤꠀ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠡꠝꠦꠔ ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤꠞꠦ ꠚꠥʼꠞ ꠌꠣꠝꠠꠣꠖꠤ ꠛꠦꠞꠣꠁꠀ, ꠛꠁꠀ ꠘꠤꠛꠣꠞ ꠈꠣꠐꠤꠀꠞ ꠃꠙꠞꠦ ꠕꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","ꠀꠞ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠘꠤꠞ ꠡꠥꠘꠣꠞ ꠐꠦꠛꠥꠟꠞ ꠃꠙꠞꠦ ꠟꠤꠟꠥꠀ ꠄꠇꠈꠣꠘ ꠇꠣꠙꠠ ꠛꠤꠍꠣꠁꠀ, ꠚꠥʼꠞ ꠌꠣꠝꠠꠣꠖꠤ ꠉꠥꠞꠤꠀ ꠖꠤꠛꠣ, ꠛꠣꠖꠦ ꠅꠃ ꠐꠦꠛꠥꠟ ꠛꠁꠀ ꠘꠦꠅꠀꠞ ꠛꠦꠘ꠆ꠖꠣ ꠉꠥꠁꠘ ꠎꠣꠉꠣ ꠝꠔ ꠢꠣꠞꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠈꠦꠎꠝꠔꠞ ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠔꠣꠞꠣ ꠟꠤꠟꠥꠀ ꠇꠣꠙꠠꠖꠤ ꠙꠦꠌꠣꠁꠀ, ꠚꠥʼꠞ ꠌꠣꠝꠠꠣꠖꠤ ꠉꠥꠞꠤꠀ ꠢꠣꠞꠤ, ꠅꠔꠣ ꠛꠁꠀ ꠘꠤꠛꠣꠞ ꠈꠣꠐꠤꠀꠞ ꠃꠙꠞꠦ ꠕꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠜꠤꠔꠞꠞ ꠢꠇꠟ ꠍꠣꠟꠤ ꠚꠣꠟꠣꠁꠀ, ꠛꠣꠁꠋꠉꠘꠤ ꠞꠋꠉꠞ ꠄꠇꠈꠣꠘ ꠉꠤꠟꠣꠚꠖꠤ ꠉꠥꠞꠤꠀ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","ꠛꠣꠖꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠅꠇꠟ, ꠅꠞ꠆ꠕꠣꠔ ꠀꠋꠞꠣ ꠕꠅꠀꠞ ꠙꠣꠔꠤꠟ, ꠉꠥꠡ꠆ꠔ ꠔꠥꠟꠣꠞ ꠛꠠ ꠇꠣꠐꠣ-ꠍꠤꠚ, ꠍꠣꠟꠤ ꠔꠥꠟꠣꠞ ꠛꠠ ꠌꠣꠝꠌ, ꠟꠃ ꠕꠅꠀꠞ ꠛꠣꠐꠤ, ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠕꠁꠛꠣ। ꠕꠁꠀ ꠚꠥʼꠞ ꠌꠣꠝꠠꠣꠖꠤ ꠉꠥꠞꠤꠀ ꠖꠤꠀ, ꠄꠞ ꠛꠦꠘ꠆ꠖꠣ ꠉꠥꠁꠘ ꠑꠤꠇ ꠎꠣꠉꠣꠔ ꠢꠣꠞꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠎꠦꠛꠟꠣ ꠅꠃ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠎꠤꠘꠤꠡ ꠅꠇꠟ ꠀꠞ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠢꠇꠟꠔꠣ ꠉꠥꠞꠤꠟꠤꠛꠣ, ꠔꠣꠞꠣ ꠔꠣꠝ꠆ꠛꠥ ꠔꠥꠟꠤꠀ ꠍꠚꠞꠅ ꠛꠣꠞꠘꠤꠞ ꠟꠣꠉꠤ ꠎꠦꠛꠟꠣ ꠔꠤꠀꠞ ꠅꠁꠎꠤꠛꠣ, ꠅꠃ ꠡꠝꠄ ꠅꠔꠣ ꠛꠁꠀ ꠘꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠇꠣꠢꠣꠔꠤ ꠅꠇꠟ ꠀꠁꠛꠣ। ꠅꠁꠟꠦ ꠔꠣꠞꠣ ꠇꠥꠘꠥ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠌꠤꠎꠞꠦ ꠀꠔꠖꠤ ꠍꠁꠔꠣ ꠙꠣꠞꠔꠣ ꠘꠣꠄ, ꠍꠁꠟꠦꠃ ꠝꠞꠛꠣ। ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠅꠃ ꠢꠇ꠆ꠇꠟ ꠎꠤꠘꠤꠡ ꠔꠣꠞꠣ ꠛꠁꠀ ꠘꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“ꠀꠞ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠙꠥꠀ ꠀꠟꠤ-ꠀꠎꠞꠞ ꠃꠙꠞꠦ ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤꠞ ꠔꠦꠟ, ꠎꠣꠟꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ, ꠙꠞ꠆ꠔꠤꠖꠤꠘꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠀꠞ ꠈꠦꠟꠣꠚꠔꠤ ꠡꠝꠎꠤꠛꠣꠞ ꠔꠦꠟꠞ ꠖꠣꠄꠁꠔ꠆ꠔ ꠞꠁꠛ। ꠀꠟ꠆ꠟꠣꠞ ꠊꠞ, ꠊꠞꠞ ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ, ꠝꠣꠘꠤ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣ ꠀꠞ ꠔꠣꠞ ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣꠞ ꠔꠖꠣꠞꠇꠤ ꠞꠁꠛ ꠀꠟꠤ-ꠀꠎꠞꠞ ꠃꠙꠞꠦ।” ");
INSERT INTO syls_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠢꠎꠞꠔ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“ꠔꠥꠝꠞꠣ ꠈꠤꠀꠟ ꠞꠣꠈꠤꠅ, ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠎꠦ ꠇꠣꠢꠣꠔꠤ ꠛꠋꠡ ꠕꠣꠇꠤ ꠇꠦꠃ ꠇꠦꠃ ꠎꠣꠔꠦ ꠢꠞ-ꠢꠣꠝꠦꠡꠣ ꠕꠣꠇꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","ꠔꠣꠞꠣ ꠎꠣꠘꠥ ꠈꠣꠍ ꠙꠛꠤꠔ꠆ꠞ ꠌꠤꠎ ꠅꠇꠟꠞ ꠇꠣꠍꠣꠔ ꠉꠤꠀ ꠘꠣ ꠝꠞꠦ ꠛꠞꠋ ꠛꠣꠌꠤꠀ ꠞꠄ, ꠅꠔꠣꠞ ꠟꠣꠉꠤ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠀꠝꠣꠞ ꠊꠞꠞ ꠜꠤꠔꠞꠦ ꠉꠤꠀ ꠎꠣꠞꠎꠤꠞ ꠇꠣꠝ-ꠇꠣꠎ ꠛꠥꠎꠣꠁ ꠖꠤꠛꠣ। ꠀꠞ ꠇꠦ ꠇꠤꠔꠣ ꠛꠁꠀ ꠘꠤꠔꠣ, ꠅꠔꠣꠅ ꠑꠤꠇ ꠇꠞꠤ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","ꠅꠁꠟꠦ ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚꠞ ꠜꠤꠔꠞꠞ ꠅꠃ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠎꠤꠘꠤꠡ ꠄꠇ ꠙꠟꠇꠞ ꠟꠣꠉꠤꠅ ꠖꠦꠈꠣꠞ ꠘꠤꠅꠔꠦ ꠇꠣꠢꠣꠔꠤ ꠅꠇꠟ ꠜꠤꠔꠞꠦ ꠇꠥꠘꠥ ꠟꠣꠈꠣꠘꠃ ꠢꠣꠝꠣꠁꠔꠣ ꠙꠣꠞꠔꠣ ꠘꠣꠄ, ꠅꠃ ꠘꠤꠅꠔꠦ ꠢꠣꠝꠣꠁꠟꠦꠃ ꠝꠞꠤ ꠎꠣꠁꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“ꠔꠥꠝꠤ ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠙꠞꠤꠛꠣꠞ ꠝꠣꠚꠤꠇ ꠎꠣꠞꠍꠥꠘꠤ ꠅꠇꠟꠞꠦ ꠉꠘꠅ। ");
INSERT INTO syls_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","ꠔꠤꠡ ꠕꠣꠇꠤ ꠙꠁꠘ꠆ꠌꠣꠡ ꠛꠍꠞ ꠛꠄꠅꠡꠞ ꠎꠦꠔꠣ ꠎꠣꠞꠍꠥꠘꠤ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠇꠣꠝ ꠇꠞꠔꠣ ꠙꠣꠞꠛꠣ, ꠈꠣꠟꠤ ꠔꠣꠞꠣꠞꠦ ꠉꠘꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠈꠦꠎꠝꠔ ꠇꠞꠣ ꠀꠞ ꠜꠣꠞ ꠛꠅꠀꠞ ꠡꠝꠄ ꠎꠣꠞꠍꠥꠘꠤ ꠅꠇꠟꠞ ꠇꠣꠝ ꠅꠁꠟ, ");
INSERT INTO syls_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ꠀꠝꠣꠞ ꠊꠞꠞ ꠢꠇꠟ ꠙꠞ꠆ꠖꠣꠁꠘ, ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥ ꠀꠞ ꠄꠞ ꠉꠤꠟꠣꠚ, ꠔꠣꠞ ꠃꠙꠞꠞ ꠚꠥʼꠞ ꠌꠣꠝꠠꠣꠞ ꠍꠣꠘꠤ, ꠀꠞ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠙꠞ꠆ꠖꠣ ꠛꠁꠀ ꠘꠦꠅꠀ। ");
INSERT INTO syls_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ꠄꠞꠟꠉꠦ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞ ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠑꠣꠘꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠞ ꠙꠞ꠆ꠖꠣ ꠀꠞ ꠄꠞ ꠖꠠꠤ ꠅꠇꠟ, ꠃꠑꠣꠘꠅ ꠢꠣꠝꠣꠘꠤꠞ ꠉꠦꠁꠐꠞ ꠙꠞ꠆ꠖꠣ, ꠅꠔꠣꠞ ꠟꠉꠞ ꠖꠞꠇꠣꠞꠤ ꠢꠇꠟ ꠝꠣꠟ ꠔꠣꠞꠣ ꠛꠁꠀ ꠘꠤꠛꠣ, ꠀꠞ ꠅꠃ ꠛꠦꠙꠣꠞꠦ ꠎꠔ ꠇꠣꠝ-ꠇꠣꠎ ꠀꠍꠦ, ꠁꠔꠣ ꠔꠣꠞꠣ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","ꠜꠣꠞ ꠛꠁꠛꠣꠞ ꠇꠣꠝ ꠅꠃꠇ ꠛꠣ ꠅꠁꠘ꠆ꠘ ꠇꠥꠘꠥ ꠇꠣꠝ ꠅꠃꠇ, ꠢꠇꠟꠔꠣ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠎꠣꠞꠍꠥꠘꠤ ꠅꠇꠟꠦ ꠇꠞꠛꠣ। ꠔꠣꠞꠣ ꠇꠤꠔꠣ ꠇꠤꠔꠣ ꠛꠁꠀ ꠘꠤꠔ, ꠁꠔꠣ ꠔꠥꠝꠞꠣꠃ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠀ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","ꠅꠔꠣꠃ ꠅꠁꠟ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠇꠣꠝꠅ ꠎꠣꠞꠍꠥꠘꠤ ꠅꠇꠟꠞ ꠖꠣꠄ-ꠖꠣꠄꠁꠔ꠆ꠔ। ꠔꠣꠞꠣꠞ ꠇꠣꠝ-ꠇꠣꠎꠞ ꠔꠖꠣꠞꠇꠤ ꠇꠞꠛꠣ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠙꠥꠀ ꠁꠍꠣꠝꠣꠞꠦ। ");
INSERT INTO syls_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“ꠔꠥꠝꠞꠣ ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠙꠞꠤꠛꠣꠞ ꠝꠣꠚꠤꠇ ꠝꠣꠞꠣꠞꠤꠀ ꠅꠇꠟꠞ ꠙꠞꠤꠝꠣꠘ ꠉꠘꠅ। ");
INSERT INTO syls_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ꠔꠤꠡ ꠕꠣꠇꠤ ꠙꠁꠘ꠆ꠌꠣꠡ ꠛꠍꠞ ꠛꠄꠅꠡꠞ ꠎꠦꠔꠣ ꠝꠣꠞꠣꠞꠤꠀ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠇꠣꠝ ꠇꠞꠔꠣ ꠙꠣꠞꠛꠣ, ꠔꠥꠝꠞꠣ ꠈꠣꠟꠤ ꠔꠣꠞꠣꠞꠦ ꠉꠘꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠝꠣꠎꠦ ꠝꠣꠞꠣꠞꠤꠀ ꠅꠇꠟꠞ ꠖꠣꠄꠁꠔ꠆ꠔ ꠅꠁꠟ, ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠢꠇꠟ ꠚ꠆ꠞꠦꠁꠝ, ꠚ꠆ꠞꠦꠁꠝꠞ ꠛꠣꠔ꠆ꠔꠤ, ꠈꠥꠐꠤ ꠀꠞ ꠈꠥꠐꠤꠞ ꠔꠟꠞ ꠌꠥꠘ꠆ꠉꠤ ꠛꠁꠀ ꠘꠦꠅꠀ। ");
INSERT INTO syls_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ꠄꠞꠟꠉꠦ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠞ ꠃꠑꠣꠘꠞ ꠢꠇꠟ ꠈꠥꠐꠤ ꠀꠞ ꠌꠥꠘ꠆ꠉꠤ, ꠃꠑꠣꠘꠞ ꠙꠞ꠆ꠖꠣ ꠐꠣꠘꠣꠘꠤꠞ ꠙꠦꠞꠦꠉ ꠀꠞ ꠖꠠꠤ ꠀꠞ ꠅꠔꠣꠞ ꠟꠉꠞ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠎꠦꠔꠣ ꠖꠞꠇꠣꠞꠤ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠔꠣꠞꠣ ꠛꠁꠀ ꠘꠤꠛꠣ। ꠔꠣꠞꠣ ꠇꠦ ꠇꠤꠔꠣ ꠛꠁꠀ ꠘꠤꠔ, ꠁꠔꠣ ꠔꠥꠝꠞꠣ ꠇꠁꠀ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","ꠅꠔꠣꠃ ꠅꠁꠟ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠝꠣꠎꠦ ꠝꠣꠞꠣꠞꠤꠀ ꠉꠥꠡ꠆ꠐꠤꠞ ꠖꠣꠄ-ꠖꠣꠄꠁꠔ꠆ꠔ। ꠔꠣꠞꠣꠞ ꠇꠣꠝ-ꠇꠣꠎꠞ ꠔꠖꠣꠞꠇꠤ ꠇꠞꠛꠣ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠙꠥꠀ ꠁꠍꠣꠝꠣꠞꠦ।” ");
INSERT INTO syls_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","ꠔꠦꠃ ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠙꠞꠤꠛꠣꠞ ꠝꠣꠚꠤꠇ ꠢꠎꠞꠔ ꠝꠥꠍꠣ, ꠢꠣꠞꠥꠘ ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠡꠞ꠆ꠖꠣꠞ ꠅꠇꠟꠦ ꠇꠣꠢꠣꠔꠤ ꠅꠇꠟꠞꠦ ꠉꠘꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","ꠔꠤꠡ ꠕꠣꠇꠤ ꠙꠁꠘ꠆ꠌꠣꠡ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠎꠦꠔꠣ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠣꠞ ꠇꠕꠣ, ꠈꠣꠟꠤ ꠔꠣꠞꠣꠞꠦ ꠉꠘꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","ꠉꠘꠤꠀ ꠔꠣꠞꠣꠞ ꠉꠥꠡ꠆ꠐꠤ ꠝꠣꠚꠤꠇ ꠖꠥꠁ ꠀꠎꠣꠞ ꠡꠣꠔ-ꠡ ꠙꠁꠘ꠆ꠌꠣꠡ ꠎꠘ ꠙꠣꠅꠀ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","ꠄꠞꠣꠃ ꠀꠍꠟꠣ ꠇꠣꠢꠣꠔꠤ ꠉꠥꠡ꠆ꠐꠤꠞ ꠝꠥꠐ ꠝꠣꠘꠥꠡ, ꠎꠦꠞꠣ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠔꠣ। ꠝꠥꠍꠣ ꠘꠛꠤꠞ ꠝꠣꠞꠚꠔꠦ ꠝꠣꠛꠥꠖꠞ ꠛꠣꠔꠣꠁꠟ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠦ ꠔꠣꠞꠣꠞꠦ ꠉꠘꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠙꠞꠤꠛꠣꠞ ꠝꠣꠚꠤꠇ ꠎꠣꠞꠍꠥꠘꠤ ꠅꠇꠟꠞꠦ ꠉꠘꠣ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","ꠔꠤꠡ ꠕꠣꠇꠤ ꠙꠁꠘ꠆ꠌꠣꠡ ꠛꠍꠞ ꠛꠄꠅꠡꠞ ꠎꠦꠔꠣ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠣꠞ ꠇꠕꠣ, ");
INSERT INTO syls_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠙꠞꠤꠛꠣꠞ ꠝꠣꠚꠤꠇ ꠔꠣꠞꠣꠞꠦ ꠉꠘꠤꠀ ꠢꠣꠞꠤ ꠖꠥꠁ ꠀꠎꠣꠞ ꠍꠄ-ꠡ ꠔꠤꠡ ꠎꠘ ꠙꠣꠅꠀ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","ꠄꠞꠣꠃ ꠀꠍꠟꠣ ꠎꠣꠞꠍꠥꠘꠤ ꠉꠥꠡ꠆ꠐꠤꠞ ꠝꠥꠐ ꠝꠣꠘꠥꠡ, ꠎꠦꠞꠣ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠔꠣ। ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠦ ꠔꠣꠞꠣꠞꠦ ꠉꠘꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠙꠞꠤꠛꠣꠞ ꠝꠣꠚꠤꠇ ꠝꠣꠞꠣꠞꠤꠀ ꠅꠇꠟꠞꠦ ꠉꠘꠣ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","ꠔꠤꠡ ꠕꠣꠇꠤ ꠙꠁꠘ꠆ꠌꠣꠡ ꠛꠍꠞ ꠛꠄꠅꠡꠞ ꠎꠦꠔꠣ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠣꠞ ꠇꠕꠣ, ");
INSERT INTO syls_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ꠉꠥꠡ꠆ꠐꠤ ꠝꠣꠚꠤꠇ ꠔꠣꠞꠣꠞꠦ ꠉꠘꠤꠀ ꠔꠤꠘ ꠀꠎꠣꠞ ꠖꠥꠁ-ꠡ ꠎꠘ ꠙꠣꠅꠀ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","ꠄꠞꠣꠃ ꠀꠍꠟꠣ ꠝꠣꠞꠣꠞꠤꠀ ꠉꠥꠡ꠆ꠐꠤꠞ ꠝꠥꠐ ꠝꠣꠘꠥꠡ, ꠎꠦꠞꠣ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠔꠣ। ꠢꠎꠞꠔ ꠝꠥꠍꠣꠞ ꠝꠣꠞꠚꠔꠦ ꠙꠣꠅꠀ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠦ ꠔꠣꠞꠣꠞꠦ ꠉꠘꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠙꠞꠤꠛꠣꠞ ꠝꠣꠚꠤꠇ ꠢꠎꠞꠔ ꠝꠥꠍꠣ, ꠢꠣꠞꠥꠘ ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟꠦ ꠀꠡ꠆ꠔꠣ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞꠦ ꠉꠘꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","ꠔꠤꠡ ꠕꠣꠇꠤ ꠙꠁꠘ꠆ꠌꠣꠡ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠎꠦꠔꠣ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠈꠦꠎꠝꠔ ꠀꠞ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠛꠁꠀ ꠘꠤꠛꠣꠞ ꠇꠕꠣ, ");
INSERT INTO syls_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ꠉꠥꠡ꠆ꠐꠤ ꠝꠣꠚꠤꠇ ꠔꠣꠞꠣꠞꠦ ꠉꠘꠤꠀ ꠀꠐ ꠀꠎꠣꠞ ꠙꠣꠌ-ꠡ ꠀꠡꠤ ꠎꠘ ꠙꠣꠅꠀ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","ꠢꠎꠞꠔ ꠝꠥꠍꠣꠞ ꠝꠣꠞꠚꠔꠦ ꠝꠣꠛꠥꠖꠞ ꠛꠣꠔꠣꠁꠟ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠄꠞꠣ ꠙꠞꠔꠦꠇ ꠎꠘꠞ ꠇꠣꠝ-ꠇꠣꠎ ꠀꠞ ꠇꠦ ꠇꠤꠔꠣ ꠛꠁꠀ ꠘꠤꠔꠣ, ꠢꠇꠟꠔꠣ ꠛꠥꠎꠣꠁ ꠖꠦꠅꠀ ꠅꠁꠍꠤꠟ। ꠝꠣꠛꠥꠖꠞ ꠖꠦꠅꠀ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞꠦ ꠉꠘꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠅꠃ ꠢꠥꠇꠥꠝ ꠖꠦꠅ, ꠔꠣꠞꠣ ꠎꠣꠘꠥ ꠇꠦꠝ꠆ꠙ ꠕꠣꠇꠤ ꠢꠇꠟ ꠙꠌꠣ-ꠇꠥꠡ꠆ꠑ ꠛꠦꠝꠣꠞꠤꠞꠦ ꠛꠣꠞ ꠇꠞꠤ ꠖꠦꠄ, ꠀꠞ ꠢꠇꠟ ꠘꠝꠥꠘꠣꠞ ꠗꠣꠔꠥ ꠛꠦꠝꠣꠞꠤ, ꠝꠞꠣ ꠟꠣꠡ ꠍꠁꠀ ꠎꠦꠞꠣ ꠘꠣꠙꠣꠇ ꠅꠁꠍꠦ ꠔꠣꠞꠣꠞꠦꠅ ꠇꠦꠝ꠆ꠙ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤ ꠖꠦꠃꠇ। ");
INSERT INTO syls_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","ꠛꠦꠐꠣ ꠛꠣ ꠛꠦꠐꠤ ꠅꠃꠇ, ꠅꠉꠥꠞꠦ ꠇꠦꠝ꠆ꠙ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤ ꠖꠤꠛꠣꠄ। ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠇꠦꠝ꠆ꠙ ꠎꠣꠔꠦ ꠄꠞꠣ ꠘꠣꠙꠣꠇ ꠘꠣ ꠛꠣꠘꠣꠄ, ꠅꠃ ꠘꠤꠅꠔꠦ ꠅꠔꠣꠞꠦ ꠛꠣꠞ ꠇꠞꠤ ꠖꠤꠛꠣꠄ, ꠎꠣꠘ ꠔ, ꠡ꠆ꠛꠄꠅꠋ ꠀꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠎꠦ ꠛꠡꠔ ꠇꠞꠤ।” ");
INSERT INTO syls_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","ꠔꠦꠃ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠅꠟꠣ ꠇꠞꠟꠣ। ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠔꠣꠞꠣ ꠑꠤꠇ ꠅꠃꠟꠣꠃ ꠇꠞꠟꠣ। ꠔꠣꠞꠣ ꠘꠣꠙꠣꠇ ꠢꠇꠟ ꠝꠣꠘꠡꠞꠦ ꠇꠦꠝ꠆ꠙ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠚꠞꠝꠣꠘꠤ ꠇꠞꠤꠀ ꠖꠥꠍꠞꠣ ꠝꠣꠘꠡꠞ ꠈꠦꠔꠤ ꠇꠞꠦ, ꠔꠦ ꠢꠦ ꠛꠦꠐꠣ ꠛꠣ ꠛꠦꠐꠤ ꠅꠁꠟꠦꠅ ꠘꠤꠌ꠆ꠌꠄ ꠖꠥꠡꠤ। ");
INSERT INTO syls_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","ꠢꠦ ꠔꠣꠞ ꠉꠥꠘꠣꠞ ꠡ꠆ꠛꠤꠇꠣꠞꠥꠇ꠆ꠔꠤ ꠖꠤꠔꠦ ꠅꠁꠛ। ꠀꠞ ꠢꠦ ꠎꠦ ꠝꠣꠘꠡꠞ ꠈꠦꠔꠤ ꠇꠞꠍꠦ, ꠔꠣꠞꠦ ꠡꠥꠟ꠆ꠟꠀꠘꠣ ꠈꠦꠔꠤ-ꠙꠥꠞꠘ ꠖꠤꠔꠦ ꠅꠁꠛ। ꠎꠦ ꠎꠤꠘꠤꠡꠞ ꠈꠦꠔꠤ ꠇꠞꠍꠦ, ꠈꠦꠔꠤ-ꠙꠥꠞꠘ ꠢꠤꠡꠣꠛꠦ ꠅꠃ ꠎꠤꠘꠤꠡꠞ ꠝꠥꠟ ꠖꠣꠝꠞ ꠟꠉꠦ ꠀꠞꠅ ꠙꠣꠌ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ ꠛꠦꠡꠤ ꠖꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","ꠈꠦꠔꠤ-ꠙꠥꠞꠘ ꠘꠦꠅꠀꠞ ꠎꠥꠇꠣ ꠝꠣꠘꠥꠡ ꠎꠥꠖꠤ ꠘꠣ ꠞꠂꠘ ꠀꠞ ꠔꠣꠞ ꠇꠥꠘꠥ ꠀꠙꠘ ꠎꠘ ꠘꠣ ꠕꠣꠇꠂꠘ, ꠔꠦ ꠁꠔꠣ ꠝꠣꠛꠥꠖꠞ ꠙꠣꠅꠘꠣ ꠅꠁꠛ। ꠅꠃ ꠈꠦꠔꠤ-ꠙꠥꠞꠘ ꠀꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠝꠦꠠꠣꠐꠣ ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠙꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠎꠔ ꠎꠤꠘꠤꠡ ꠁꠝꠣꠝꠞ ꠉꠦꠍꠦ ꠟꠁꠀ ꠀꠁꠛꠣ, ꠁꠔꠣ ꠢꠇ꠆ꠇꠟꠔꠣꠃ ꠁꠝꠣꠝꠦ ꠙꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","ꠙꠞꠔꠦꠇ ꠎꠘꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅꠀ ꠎꠤꠘꠤꠡ ꠁꠝꠣꠝꠦ ꠙꠣꠁꠛꠣ। ꠁꠝꠣꠝꠞ ꠀꠔꠅ ꠎꠦ ꠎꠤꠘꠤꠡ ꠖꠦꠅꠀ ꠅꠁꠛ, ꠁꠔꠣ ꠁꠝꠣꠝꠞꠃ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠇꠦꠃꠞꠞ ꠛꠃ ꠎꠥꠖꠤ ꠇꠥ-ꠙꠕꠦ ꠎꠣꠄꠉꠤ, ");
INSERT INTO syls_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ꠀꠞ ꠎꠣꠝꠣꠁꠞꠦ ꠟꠥꠇꠣꠁꠀ ꠀꠞꠇ ꠛꠦꠐꠣꠞ ꠟꠉꠦ ꠎꠤꠘꠣ ꠇꠞꠤꠀ ꠅꠡꠔꠤ ꠛꠘꠦ, ꠔꠣꠁꠞ ꠎꠣꠝꠣꠁꠄ ꠁꠈꠣꠘ ꠘꠣ ꠎꠣꠘꠦ ꠛꠣ ꠁꠔꠣꠞ ꠇꠥꠘꠥ ꠡꠣꠇ꠆ꠇꠤꠅ ꠘꠣ ꠕꠣꠇꠦ, ꠔꠣꠁ ꠇꠥꠘꠥ ꠗꠞꠣ ꠘꠣ-ꠅ ꠈꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ꠄꠞꠛꠣꠖꠦꠅ ꠎꠣꠝꠣꠁꠄ ꠛꠃꠞꠦ ꠡꠘ꠆ꠖꠄ ꠇꠞꠤꠟꠣꠄ, ꠔꠣꠞ ꠜꠤꠔꠞꠦ ꠅꠡꠣꠘ꠆ꠔꠤ ꠇꠞꠦꠞ, ꠇꠤꠛꠣ ꠛꠃꠄ ꠇꠥꠘꠥ ꠅꠡꠔꠤ ꠇꠣꠝ ꠘꠣ ꠇꠞꠟꠦꠅ ꠎꠣꠝꠣꠁꠄ ꠈꠣꠟꠤ ꠔꠣꠁꠞꠦ ꠡꠘ꠆ꠖꠄ ꠇꠞꠦ, ꠄꠞꠟꠣꠉꠤ ꠔꠣꠞ ꠝꠘꠞ ꠝꠣꠎꠦ ꠅꠡꠣꠘ꠆ꠔꠤ ꠢꠣꠝꠣꠁꠎꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ꠔꠦ ꠎꠣꠝꠣꠁꠄ ꠔꠣꠞ ꠛꠃꠞꠦ ꠟꠁꠀ ꠁꠝꠣꠝ ꠍꠣꠛꠞ ꠉꠦꠍꠦ ꠎꠣꠁꠔꠦ ꠅꠁꠛ। ꠎꠣꠅꠀꠞ ꠡꠝꠄ ꠔꠣꠞ ꠛꠃꠞ ꠔꠞꠚ ꠕꠣꠇꠤ ꠍꠖꠉꠣ ꠢꠤꠡꠣꠛꠦ ꠖꠥꠁ ꠡꠦꠞ ꠛꠣꠞ꠆ꠟꠤꠞ ꠝꠄꠖꠣ ꠘꠤꠔꠦ ꠅꠁꠛ। ꠅꠃ ꠝꠄꠖꠣ ꠅꠁꠟ ꠡꠘ꠆ꠖꠄꠞ ꠟꠣꠉꠤ ꠍꠖꠉꠣ, ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠅꠙꠞꠣꠗ ꠎꠣꠁꠞ ꠇꠞꠣꠞ ꠍꠖꠉꠣ, ꠄꠞꠟꠣꠉꠤ ꠁꠔꠣꠞ ꠝꠣꠎꠦ ꠇꠥꠘꠥ ꠔꠦꠟ ꠛꠣ ꠈꠥꠡꠛꠄꠖꠣꠞ ꠟꠥꠛꠣꠘ ꠝꠤꠡꠣꠘꠤ ꠘꠤꠡꠦꠗ। ");
INSERT INTO syls_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ꠁꠝꠣꠝꠦ ꠅꠃ ꠛꠦꠐꠣꠞ ꠛꠃꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠈꠣꠠꠣ ꠇꠞꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","ꠀꠞ ꠝꠣꠐꠤꠞ ꠄꠇ ꠉꠣꠝꠟꠣꠞ ꠝꠣꠎꠦ ꠇꠤꠍꠥ ꠙꠛꠤꠔ꠆ꠞ ꠙꠣꠘꠤ ꠜꠞꠛꠣ, ꠜꠞꠤꠀ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠜꠤꠔꠞꠞ ꠝꠣꠐꠤꠞ ꠃꠙꠞ ꠕꠣꠇꠤ ꠇꠤꠍꠥ ꠗꠥꠁꠟ ꠔꠥꠟꠤꠀ ꠅꠃ ꠙꠣꠘꠤꠔ ꠍꠣꠠꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","ꠛꠦꠐꠤꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠃꠛꠣ ꠇꠞꠤꠀ ꠢꠣꠞꠟꠦ ꠔꠣꠁꠘ ꠛꠦꠐꠤꠞ ꠝꠣꠕꠣꠞ ꠌꠥꠟ ꠈꠥꠟꠤꠀ ꠖꠤꠛꠣ, ꠀꠞ ꠛꠦꠐꠤꠞ ꠅꠙꠞꠣꠗꠞ ꠢꠣꠍꠣ-ꠝꠤꠍꠣ ꠎꠣꠁꠞ ꠅꠀꠞ ꠟꠣꠉꠤ ꠀꠘꠣ ꠍꠖꠉꠣꠞ ꠛꠣꠞ꠆ꠟꠤꠞ ꠝꠄꠖꠣꠞꠦ ꠔꠣꠁꠞ ꠀꠔꠅ ꠖꠤꠛꠣ। ꠖꠤꠀ ꠔꠣꠘ ꠘꠤꠎꠞ ꠀꠔꠅ ꠟꠁꠛꠣ ꠢꠃ ꠟꠣꠘ꠆ꠘꠔ ꠒꠣꠇꠤꠀ ꠀꠘꠣꠞ ꠔꠤꠔ꠆ꠔꠣ ꠙꠣꠘꠤ। ");
INSERT INTO syls_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","ꠙꠣꠘꠤ ꠟꠁꠀ ꠁꠝꠣꠝꠦ ꠅꠃ ꠛꠦꠐꠤꠞꠦ ꠇꠍꠝ ꠇꠞꠣꠁꠀ ꠇꠁꠛꠣ, ‘ꠔꠥꠝꠣꠞ ꠛꠤꠀꠞ ꠛꠣꠖꠦ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠛꠦꠐꠣꠄ ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠎꠤꠘꠣ ꠘꠣ ꠇꠞꠦ, ꠛꠣ ꠇꠥ-ꠙꠕꠦ ꠉꠤꠀ ꠔꠥꠝꠤ ꠅꠡꠔꠤ ꠘꠣ ꠅꠅ, ꠔꠦ ꠅꠃ ꠟꠣꠘ꠆ꠘꠔ ꠀꠘꠣꠞ ꠔꠤꠔ꠆ꠔꠣ ꠙꠣꠘꠤꠄ ꠎꠣꠘꠥ ꠔꠥꠝꠣꠞ ꠇꠥꠘꠥ ꠈꠦꠔꠤ ꠘꠣ ꠅꠄ। ");
INSERT INTO syls_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","ꠅꠁꠟꠦ ꠛꠤꠀꠞ ꠛꠣꠖꠦ ꠇꠥ-ꠙꠕꠦ ꠉꠤꠀ ꠖꠥꠍꠞꠣ ꠇꠥꠘꠥ ꠛꠦꠐꠣꠞ ꠟꠉꠦ ꠎꠤꠘꠣ ꠇꠞꠤꠀ ꠎꠥꠖꠤ ꠅꠡꠔꠤ ꠅꠅ,’ ");
INSERT INTO syls_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","—ꠅꠈꠣꠘ ꠇꠁꠀ ꠁꠝꠣꠝꠦ ꠅꠃ ꠛꠦꠐꠤꠞꠦ ꠘꠤꠎꠞ ꠃꠙꠞꠦ ꠟꠣꠘ꠆ꠘꠔ ꠒꠣꠇꠤꠀ ꠀꠘꠣꠞ ꠇꠍꠝ ꠇꠞꠣꠁꠀ ꠢꠣꠞꠤ ꠢꠤꠞꠛꠣꠞ ꠇꠁꠛꠣ— ‘ꠔꠦ ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠣꠞꠦ ꠅꠃ ꠉꠎꠛ ꠖꠦꠃꠇ꠆ꠇꠣ, ꠔꠥꠝꠣꠞ ꠘꠣꠞꠤ-ꠅꠋꠉ ꠘꠤꠡ꠆ꠔꠦꠎ ꠅꠁꠎꠣꠃꠇ, ꠀꠞ ꠔꠥꠝꠣꠞ ꠙꠦꠐ ꠚꠥꠟꠤꠀ ꠝꠥꠐꠣ ꠅꠁꠎꠣꠃꠇ। ꠔꠦꠃ ꠁꠔꠣ ꠖꠦꠈꠤꠀ ꠔꠥꠝꠣꠞ ꠡꠝꠣꠎꠞ ꠝꠣꠘꠡꠦ ꠎꠦꠇꠥꠘꠥ ꠛꠖ꠆ꠖꠥꠀ ꠀꠞ ꠟꠣꠘ꠆ꠘꠔꠤ ꠇꠍꠝ ꠈꠣꠅꠀꠞ ꠡꠝꠄ ꠔꠥꠝꠣꠞ ꠘꠣꠝ ꠔꠣꠞꠣ ꠁꠀꠖ ꠇꠞꠛ। ");
INSERT INTO syls_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","ꠀꠞ ꠅꠃ ꠟꠣꠘ꠆ꠘꠔ ꠀꠘꠣꠞ ꠙꠣꠘꠤ ꠔꠥꠝꠣꠞ ꠡꠞꠤꠟꠅ ꠢꠣꠝꠣꠁꠀ ꠎꠣꠘꠥ ꠅꠟꠣ ꠇꠣꠝ ꠇꠞꠦ, ꠎꠣꠔꠦ ꠔꠥꠝꠣꠞ ꠙꠦꠐ ꠚꠥꠟꠤꠎꠣꠄ ꠀꠞ ꠔꠥꠝꠣꠞ ꠘꠣꠞꠤ-ꠅꠋꠉ ꠘꠤꠡ꠆ꠔꠦꠎ ꠅꠁꠎꠣꠄ।’ ꠔꠦꠃ ꠛꠦꠐꠤꠄ ꠇꠁꠛ, ‘ꠀꠝꠤꠘ, ꠅꠟꠣꠃ ꠅꠃꠇ।’ ");
INSERT INTO syls_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ꠁꠝꠣꠝꠦ ꠅꠃ ꠟꠣꠘ꠆ꠘꠔ ꠀꠘꠣ ꠇꠍꠝꠞ ꠇꠕꠣ ꠄꠇ ꠌꠣꠝꠠꠣꠞ ꠃꠙꠞꠦ ꠟꠦꠈꠤꠀ ꠢꠣꠞꠤ, ꠙꠣꠘꠤ ꠓꠣꠟꠤꠀ ꠅꠃ ꠟꠦꠈꠣꠞ ꠇꠣꠟꠤ ꠔꠤꠔ꠆ꠔꠣ ꠙꠣꠘꠤꠔ ꠚꠣꠟꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","ꠟꠣꠘ꠆ꠘꠔ ꠀꠘꠣꠞ ꠅꠃ ꠔꠤꠔ꠆ꠔꠣ ꠙꠣꠘꠤ ꠛꠦꠐꠤꠞꠦ ꠈꠣꠅꠀꠘꠤꠞ ꠛꠣꠖꠦ ꠛꠦꠐꠤꠞ ꠙꠦꠐꠅ ꠈꠥꠛ ꠎꠣꠟꠣ-ꠎꠘꠔ꠆ꠞꠘꠣ ꠙꠄꠖꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","ꠁꠝꠣꠝꠦ ꠙꠄꠟꠣ ꠅꠃ ꠛꠦꠐꠤꠞ ꠀꠔ ꠕꠣꠇꠤ ꠡꠘ꠆ꠖꠄꠞ ꠍꠖꠉꠣꠞ ꠝꠄꠖꠣ ꠘꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠖꠥꠟꠣꠁꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠔ ꠟꠁꠀ ꠎꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠙꠥꠞꠣ ꠍꠖꠉꠣꠞ ꠛꠖꠟꠣ ꠅꠃ ꠝꠄꠖꠣ ꠕꠣꠇꠤ ꠘꠤꠡꠣꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠄꠇ ꠝꠥꠁꠐ ꠙꠞꠤꠝꠣꠘ ꠘꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠔ ꠎꠣꠟꠣꠁꠛꠣ, ꠀꠞ ꠢꠃ ꠔꠤꠔ꠆ꠔꠣ ꠙꠣꠘꠤ ꠛꠦꠐꠤꠞꠦ ꠈꠣꠅꠀꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","ꠛꠦꠐꠤꠄ ꠎꠥꠖꠤ ꠎꠣꠝꠣꠁꠞ ꠟꠉꠦ ꠛꠦꠁꠝꠣꠘꠤ ꠇꠞꠤꠀ ꠅꠡꠔꠤ ꠅꠁꠀ ꠕꠣꠇꠦ, ꠔꠦ ꠁ ꠙꠣꠘꠤ ꠈꠣꠅꠀꠞ ꠛꠣꠖꠦꠃ ꠔꠣꠁꠞ ꠙꠦꠐꠅ ꠈꠥꠛ ꠎꠣꠟꠣ-ꠎꠘꠔ꠆ꠞꠘꠣ ꠅꠁꠛ। ꠔꠣꠁꠞ ꠙꠦꠐ ꠚꠥꠟꠤꠀ ꠝꠥꠐꠣ ꠅꠁꠛ, ꠀꠞ ꠘꠣꠞꠤ-ꠅꠋꠉ ꠘꠤꠡ꠆ꠔꠦꠎ ꠅꠁꠀ ꠀꠐꠈꠥꠞꠣ ꠛꠘꠤꠎꠤꠛ, ꠝꠣꠘꠡꠦ ꠟꠣꠘ꠆ꠘꠔ ꠖꠤꠛꠣꠞ ꠘꠤꠅꠔꠦ ꠔꠣꠁꠞ ꠘꠣꠝ ꠟꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","ꠅꠁꠟꠦ ꠔꠣꠁ ꠎꠥꠖꠤ ꠅꠡꠔꠤ ꠘꠣ ꠅꠁꠀ ꠘꠤ-ꠅꠙꠞꠣꠗꠤ ꠞꠄ, ꠔꠦ ꠔꠣꠁ ꠁ ꠟꠣꠘ꠆ꠘꠔ ꠕꠣꠇꠤ ꠈꠣꠟꠣꠍ ꠙꠣꠁꠛ, ꠀꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣ ꠎꠘꠝ ꠖꠦꠅꠀꠞ ꠈꠦꠝꠔꠣꠅ ꠎꠣꠞꠤ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","ꠎꠣꠝꠣꠁ-ꠛꠃꠞ ꠡꠘ꠆ꠖꠄꠞ ꠛꠤꠡꠄꠄ ꠀꠟ꠆ꠟꠣꠞ ꠀꠁꠘ ꠔ ꠅꠟꠣ। ꠇꠥꠘꠥ ꠛꠃ ꠎꠥꠖꠤ ꠎꠣꠝꠣꠁꠞ ꠡꠋꠡꠣꠞꠅ ꠞꠁꠀ ꠇꠥ-ꠙꠕꠦ ꠉꠤꠀ ꠅꠡꠔꠤ ꠛꠘꠦ, ");
INSERT INTO syls_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ꠛꠣ ꠎꠣꠝꠣꠁꠄ ꠔꠣꠞ ꠛꠃꠞꠦ ꠛꠖꠝꠣꠁꠡꠤꠞ ꠡꠘ꠆ꠖꠄ ꠇꠞꠦ, ꠔꠦ ꠔꠣꠞꠣꠞ ꠟꠣꠉꠤ ꠅꠃ ꠀꠁꠘ। ꠛꠦꠐꠣꠄ ꠔꠣꠞ ꠛꠃꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠘꠤꠛ ꠀꠞ ꠁꠝꠣꠝꠦ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠛꠦꠐꠤꠞ ꠃꠙꠞꠦ ꠛꠞ꠆ꠔꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","ꠔꠦꠃ ꠎꠣꠝꠣꠁꠄ ꠔꠣꠞ ꠘꠣꠟꠤꠡ ꠕꠣꠇꠤ ꠈꠣꠟꠣꠍ ꠙꠣꠁꠛ, ꠀꠞ ꠛꠃ ꠢꠣꠍꠣꠞꠞ ꠅꠙꠞꠣꠗꠤ ꠅꠁꠟꠦ ꠔꠣꠁꠞ ꠡꠣꠎꠣ ꠛꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠇꠥꠘꠥ ꠛꠦꠐꠣ ꠛꠣ ꠛꠦꠐꠤꠄ ꠎꠥꠖꠤ ꠘꠣꠎꠤꠞꠤꠀ ꠄꠔꠦꠇꠣꠚ ꠇꠞꠔꠣ ꠌꠣꠁꠘ, ꠝꠣꠘꠤ ꠈꠣꠟꠤ ꠝꠣꠛꠥꠖꠞ ꠄꠛꠣꠖꠔ-ꠛꠘ꠆ꠖꠦꠉꠤꠞ ꠟꠣꠉꠤ ꠀꠟꠣꠖꠣ ꠞꠅꠀꠞ ꠝꠣꠘ꠆ꠘꠔ ꠇꠞꠤꠟꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ꠔꠦ ꠀꠋꠉꠥꠞꠞ ꠡꠞꠛꠔ ꠛꠣ ꠎꠦꠇꠥꠘꠥ ꠘꠝꠥꠘꠣꠞ ꠡꠞꠣꠛ ꠈꠣꠅꠀ ꠕꠣꠇꠤ ꠔꠣꠞꠣ ꠘꠤꠌ꠆ꠌꠄ ꠢꠞꠤꠀ ꠕꠣꠇꠔꠦ ꠅꠁꠛ। ꠀꠋꠉꠥꠞꠞ ꠡꠤꠞ꠆ꠇꠣ ꠛꠣ ꠎꠦꠇꠥꠘꠥ ꠘꠝꠥꠘꠣꠞ ꠡꠤꠞ꠆ꠇꠣ ꠈꠣꠅꠀ ꠕꠣꠇꠤꠅ ꠔꠣꠞꠣ ꠛꠣꠌꠤꠀ ꠞꠁꠛ। ꠀꠞ ꠔꠣꠞꠣ ꠔꠣꠎꠣ ꠀꠋꠉꠥꠞ, ꠇꠤꠍꠝꠤꠍ, ꠛꠣ ꠀꠋꠉꠥꠞꠞ ꠞꠡꠅ ꠈꠣꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","ꠝꠥꠟ ꠇꠕꠣ ꠅꠁꠟ, ꠄꠞꠣ ꠎꠔꠖꠤꠘ ꠘꠣꠎꠤꠞꠤꠀ ꠄꠔꠦꠇꠣꠚꠅ ꠞꠁꠛ, ꠅꠔꠖꠤꠘ ꠀꠋꠉꠥꠞ ꠔ ꠖꠥꠞꠞ ꠇꠕꠣ, ꠀꠋꠉꠥꠞꠞ ꠄꠇꠐꠣ ꠛꠤꠌꠤ ꠛꠣ ꠛꠣꠇꠟꠅ ꠔꠣꠞꠣ ꠇꠥꠘꠥ ꠟꠣꠈꠣꠘꠃ ꠈꠣꠁꠔ ꠙꠣꠞꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ꠀꠞ ꠎꠔꠖꠤꠘꠞ ꠟꠣꠉꠤ ꠘꠣꠎꠤꠞꠤꠀ ꠄꠔꠦꠇꠣꠚꠞ ꠘꠤꠅꠔꠦ ꠘꠤꠎꠞꠦ ꠀꠟꠣꠖꠣ ꠞꠣꠈꠣꠞ ꠝꠣꠘ꠆ꠘꠔ ꠇꠞꠍꠂꠘ, ꠅꠔꠖꠤꠘ ꠔꠣꠞꠣꠞ ꠝꠣꠕꠣꠔ ꠈꠥꠞ-ꠛꠦꠟꠦꠁꠐ ꠟꠣꠉꠣꠘꠤ ꠘꠤꠡꠦꠗ। ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠟꠣꠖꠣ ꠞꠅꠀꠞ ꠡꠝꠄ ꠄꠞꠣ ꠙꠣꠇ-ꠙꠣꠇꠤꠎꠣ ꠞꠁꠔꠦ ꠅꠁꠛ। ꠝꠣꠕꠣꠞ ꠌꠥꠟ ꠟꠣꠝ꠆ꠛꠣ ꠇꠞꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","ꠁ ꠡꠝꠄ ꠇꠥꠘꠥ ꠝꠞꠣ ꠟꠣꠡꠞ ꠉꠦꠍꠦ ꠎꠣꠁꠔ ꠙꠣꠞꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","ꠔꠣꠞꠣꠞ ꠝꠣ-ꠛꠣꠛꠣ, ꠜꠣꠁ-ꠛꠁꠘ ꠇꠦꠃ ꠝꠣꠞꠣ ꠉꠦꠟꠦꠅ ꠘꠤꠎꠞꠦ ꠘꠣꠙꠣꠇ ꠇꠞꠔ ꠙꠣꠞꠔ ꠘꠣꠄ, ꠇꠣꠞꠘ ꠄꠞꠣꠞ ꠝꠣꠕꠣꠞ ꠝꠣꠎꠦ ꠔ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠦ ꠀꠟꠣꠖꠣ ꠞꠅꠀꠞ ꠘꠤꠡꠣꠘꠣ ꠌꠥꠟ ꠟꠣꠉꠣꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","ꠔꠣꠞꠣꠞ ꠁ ꠀꠟꠣꠖꠣ ꠞꠅꠀꠞ ꠝꠤꠀꠖ ꠘꠣ ꠙꠥꠞꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ, ꠙꠣꠇ-ꠙꠣꠇꠤꠎꠣ ꠞꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ꠀꠞ ꠀꠈꠔꠣ ꠇꠥꠘꠥ ꠝꠣꠘꠥꠡ ꠎꠥꠖꠤ ꠔꠣꠞ ꠍꠣꠝꠘꠦ ꠝꠞꠤꠎꠣꠄ, ꠔꠦ ꠅꠃ ꠝꠞꠣꠞ ꠖꠣꠄ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠞꠣꠈꠣ ꠔꠣꠞ ꠝꠣꠕꠣꠞ ꠌꠥꠟ ꠘꠣꠙꠣꠇ ꠅꠁꠎꠣꠁꠛ, ꠀꠞ ꠢꠤꠞꠛꠣꠞ ꠙꠣꠇ ꠅꠀꠞ ꠟꠣꠉꠤ ꠡꠣꠔ ꠖꠤꠘꠞ ꠖꠤꠘ ꠔꠣꠞ ꠝꠣꠕꠣ ꠇꠣꠝꠣꠁꠟꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","ꠀꠞ ꠀꠐ ꠖꠤꠘꠞ ꠖꠤꠘ ꠢꠦ ꠖꠥꠁꠐꠣ ꠒꠥꠙꠤ ꠙꠣꠈꠤ ꠛꠣ ꠖꠥꠁꠐꠣ ꠙꠣꠞꠅ ꠟꠁꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠅ ꠁꠝꠣꠝꠞ ꠉꠦꠍꠦ ꠎꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","ꠝꠞꠣ ꠟꠣꠡꠞ ꠉꠦꠍꠦ ꠉꠤꠀ ꠢꠦ ꠘꠣꠙꠣꠇ ꠅꠀꠄ, ꠅꠈꠘ ꠔꠣꠞ ꠘꠣꠙꠣꠇꠤꠞ ꠉꠥꠘꠣ ꠝꠣꠚꠤꠞ ꠟꠣꠉꠤ ꠁꠝꠣꠝꠦ ꠄꠇꠐꠣ ꠙꠣꠈꠤ ꠖꠤꠀ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ, ꠀꠞ ꠖꠥꠍꠞꠣ ꠙꠣꠈꠤ ꠖꠤꠀ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠛꠣ। ꠅꠃ ꠖꠤꠘꠃ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠔꠣꠞ ꠝꠣꠕꠣꠞꠦ ꠘꠄꠀ ꠇꠞꠤ ꠙꠣꠇ-ꠙꠣꠇꠤꠎꠣ ꠞꠣꠈꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","ꠀꠞ ꠀꠉꠞ ꠟꠣꠈꠣꠘ ꠢꠤꠞꠛꠣꠞ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠟꠣꠖꠣ ꠞꠅꠀꠞ ꠝꠣꠘ꠆ꠘꠔ ꠇꠞꠣ ꠟꠣꠉꠛ। ꠄꠞꠟꠉꠦ ꠖꠥꠡ-ꠇꠍꠥꠞꠤꠞ ꠇꠚꠞꠣꠞ ꠟꠣꠉꠤ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠄꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛ। ꠔꠣ-ꠅ ꠀꠉꠦ ꠎꠔꠖꠤꠘ ꠢꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠟꠣꠖꠣ ꠞꠁꠍꠤꠟ, ꠁꠔꠣ ꠛꠣꠔꠤꠟ ꠅꠁꠎꠤꠛ, ꠇꠣꠞꠘ ꠢꠤ ꠡꠝꠄ ꠢꠦ ꠘꠣꠙꠣꠇ ꠅꠁꠉꠦꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ꠎꠦꠇꠥꠘꠥ ꠎꠘꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠘꠣꠎꠤꠞꠤꠀ ꠄꠔꠦꠇꠣꠚꠞ ꠝꠤꠀꠖ ꠙꠥꠞꠣ ꠇꠞꠤꠀ ꠢꠣꠞꠟꠦ, ꠙꠛꠤꠔ꠆ꠞ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠎꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","ꠉꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠄꠉꠥ ꠘꠤꠈꠥꠔ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ, ꠀꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠄꠉꠥ ꠘꠤꠈꠥꠔ ꠝꠦꠠꠤ-ꠛꠣꠁꠌ꠆ꠌꠣ, ꠄꠞꠟꠉꠦ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠘꠤꠈꠥꠔ ꠝꠦꠠꠣ ꠀꠘꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ꠅꠔꠣꠞ ꠟꠉꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠀꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣ ꠀꠘꠛ, ꠄꠞꠟꠉꠦ ꠘꠤꠞꠦꠇ ꠉꠥꠠꠤꠖꠤ ꠛꠣꠘꠣꠁꠟ ꠔꠦꠟꠖꠤ ꠜꠣꠎꠣ ꠄꠇ ꠐꠥꠇꠞꠤ ꠙꠤꠑꠣ ꠀꠞ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠌꠣꠙꠣꠐꠤ ꠛꠣꠘꠣꠁꠅ। ꠁꠔꠣ ꠇꠥꠘ꠆ꠔꠣꠔꠃ ꠈꠣꠝꠤꠞ ꠝꠤꠡꠣꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","ꠁꠝꠣꠝꠦ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠘꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠕꠁꠀ ꠢꠣꠞꠤ, ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠉꠦ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","ꠀꠞ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠝꠦꠠꠣꠞ ꠟꠉꠦꠅ ꠅꠟꠣ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠞꠥꠐꠤ ꠖꠤꠛꠣ। ꠄꠞꠟꠉꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠀꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣ ꠀꠖꠣꠄ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","ꠛꠣꠖꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠉꠦꠍꠦ ꠘꠣꠎꠤꠞꠤꠀ ꠄꠔꠦꠇꠣꠚ ꠇꠞꠞꠣ ꠎꠘꠞ ꠝꠣꠕꠣꠞ ꠌꠥꠟ ꠇꠣꠝꠣꠁꠀ, ꠅꠃ ꠌꠥꠟ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠔꠟꠞ ꠀꠉꠥꠁꠘꠅ ꠚꠣꠟꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","ꠀꠞ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠞꠣꠈꠣ ꠅꠃ ꠌꠥꠟ ꠇꠣꠝꠣꠘꠤꠞ ꠛꠣꠖꠦ ꠁꠝꠣꠝꠦ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠝꠦꠠꠣꠞ ꠡꠤꠖ꠆ꠖ ꠇꠞꠣ ꠄꠇꠈꠣꠘ ꠉꠞ꠆ꠖꠘꠣ ꠀꠞ ꠐꠥꠇꠞꠤ ꠕꠣꠇꠤ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠄꠇꠈꠣꠘ ꠙꠤꠑꠣ ꠀꠞ ꠄꠇꠈꠣꠘ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠌꠣꠙꠣꠐꠤ ꠘꠤꠀ ꠘꠣꠎꠤꠞꠤꠀ ꠄꠔꠦꠇꠣꠚ ꠇꠞꠞꠣ ꠎꠘꠞ ꠀꠔꠅ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","ꠛꠣꠖꠦ ꠁꠝꠣꠝꠦ ꠅꠔꠣ ꠘꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠃꠌꠣ ꠇꠞꠤ ꠖꠥꠟꠣꠁꠛꠣ। ꠁꠔꠣ ꠔ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠎꠤꠘꠤꠡ, ꠁꠔꠣ ꠢꠇ꠆ꠇꠟꠔꠣ ꠁꠝꠣꠝꠞ ꠙꠣꠅꠘꠣ। ꠖꠥꠟꠣꠁꠀ ꠕꠅꠀ ꠍꠤꠘꠣꠞ ꠅꠃ ꠉꠥꠡ꠆ꠔ ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠞ ꠞꠣꠘꠅ ꠁꠝꠣꠝꠞ ꠙꠣꠅꠘꠣ। ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠇꠞꠣꠞ ꠛꠣꠖꠦ ꠘꠣꠎꠤꠞꠤꠀ ꠄꠔꠦꠇꠣꠚ ꠇꠞꠞꠣ ꠅꠃ ꠎꠘꠦ ꠀꠋꠉꠥꠞꠞ ꠡꠞꠛꠔ ꠈꠣꠁꠔꠣ ꠙꠣꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ꠁꠔꠣ ꠔ ꠘꠣꠎꠤꠞꠤꠀ ꠄꠔꠦꠇꠣꠚ ꠇꠞꠞꠣ ꠎꠘꠞ ꠟꠣꠉꠤ ꠀꠁꠘ। ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠟꠣꠖꠣ ꠞꠁꠀ ꠘꠣꠎꠤꠞꠤꠀ ꠄꠔꠦꠇꠣꠚꠞ ꠘꠤꠅꠝ ꠝꠣꠚꠤꠇ, ꠅꠔꠣ ꠢꠇꠟꠔꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠔꠦ ꠅꠁꠛ। ꠀꠞ ꠎꠥꠖꠤ ꠔꠣꠞꠣꠞ ꠡꠣꠁꠖ꠆ꠖ ꠝꠣꠚꠤꠇ ꠀꠞꠅ ꠇꠥꠘ꠆ꠔꠣ ꠇꠞꠣꠞ ꠘꠤꠅꠔ ꠇꠞꠦ, ꠔꠦ ꠅꠔꠣꠅ ꠇꠞꠔꠦ ꠅꠁꠛ। ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠟꠣꠖꠣ ꠞꠅꠀꠞ ꠝꠣꠘ꠆ꠘꠔ ꠝꠣꠚꠤꠇ ꠄꠔꠦꠇꠣꠚꠞ ꠎꠞꠥꠞꠤ ꠢꠇ꠆ꠇꠟꠔꠣ ꠄꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠛ।” ");
INSERT INTO syls_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“ꠔꠥꠝꠤ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠣꠉꠤ ꠖꠥꠀ ꠇꠞꠣꠞ ꠡꠝꠄ ꠔꠣꠞꠣ ꠎꠣꠘꠥ ꠅꠟꠣ ꠇꠂꠘ, ");
INSERT INTO syls_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","ꠝꠣꠛꠥꠖꠦ ꠖꠦꠃꠇ꠆ꠇꠣ ꠞꠢꠝ-ꠛꠞꠇꠔ, ꠀꠞ ꠇꠞꠃꠇ꠆ꠇꠣ ꠔꠥꠝꠞꠣꠞꠦ ꠢꠦꠚꠣꠎꠔ। ");
INSERT INTO syls_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","ꠔꠣꠘ ꠘꠥꠞꠞ ꠞꠥꠡꠘꠤ ꠔꠥꠝꠞꠣꠞ ꠃꠙꠞꠦ ꠙꠠꠃꠇ, ꠔꠣꠘ ꠝꠦꠢꠦꠞꠛꠣꠘꠤ ꠢꠣꠝꠦꠡꠣ ꠎꠣꠞꠤ ꠞꠃꠇ। ");
INSERT INTO syls_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘ ꠝꠥꠈ ꠈꠣꠘ ꠎꠣꠘꠥ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠄ ꠚꠤꠞꠣꠁꠘ, ꠀꠞ ꠔꠥꠝꠞꠣꠞꠦ ꠡꠣꠄ-ꠡꠣꠘ꠆ꠔꠤ ꠖꠣꠘ ꠇꠞꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","ꠅꠃ ꠟꠣꠈꠣꠘ ꠔꠣꠞꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠃꠙꠞꠦ ꠀꠝꠣꠞ ꠘꠣꠝ ꠟꠁꠛꠣ, ꠔꠦꠃ ꠀꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠞꠢꠝ-ꠛꠞꠇꠔ ꠖꠤꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","ꠢꠎꠞꠔ ꠝꠥꠍꠣꠄ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞ ꠛꠣꠘꠣꠘꠤꠞ ꠇꠣꠝ ꠡꠦꠡ ꠇꠞꠤꠀ ꠢꠣꠞꠤ, ꠙꠛꠤꠔ꠆ꠞ ꠔꠦꠟ ꠍꠤꠐꠣꠁꠀ ꠊꠞꠞꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠟꠣ। ꠀꠞ ꠊꠞꠞ ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ, ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠀꠞ ꠄꠞ ꠟꠉꠞ ꠕꠣꠟ-ꠛꠣꠡꠘ ꠢꠇ꠆ꠇꠟꠔꠣ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","ꠅꠃ ꠖꠤꠘ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠛꠣꠞꠅ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠅꠇꠟ ꠘꠣꠘꠣꠘ ꠎꠣꠔꠞ ꠃꠙꠢꠣꠞ ꠟꠁꠀ ꠀꠁꠟꠣ। ꠄꠞꠣ ꠅꠁꠟꠣ ꠎꠣꠞꠎꠤꠞ ꠉꠥꠡ꠆ꠐꠤꠞ ꠙꠞꠗꠣꠘ ꠝꠣꠘꠥꠡ, ꠔꠣꠞꠣꠞ ꠖꠣꠄꠁꠔ꠆ꠔ ꠀꠍꠤꠟ ꠉꠘꠤꠀ ꠀꠟꠉ ꠇꠞꠣ ꠢꠇꠟ ꠝꠣꠘꠡꠞ ꠖꠦꠈꠣ-ꠢꠥꠘꠣ ꠇꠞꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠔꠣꠞꠣ ꠍꠣꠘꠤ ꠀꠟꠣ ꠍꠄꠈꠣꠘ ꠉꠞꠥꠞ ꠉꠣꠠꠤ, ꠛꠣꠞꠅꠉꠥ ꠉꠞꠥ ꠟꠁꠀ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠍꠣꠝꠘꠦ ꠀꠁꠟꠣ। ꠙꠞꠔꠦꠇ ꠡꠞ꠆ꠖꠣꠞꠞ ꠔꠞꠚ ꠕꠣꠇꠤ ꠄꠇꠐꠣ ꠇꠞꠤ ꠉꠞꠥ ꠀꠞ ꠖꠥꠁ ꠎꠘꠞ ꠔꠞꠚ ꠕꠣꠇꠤ ꠄꠇꠈꠣꠘ ꠇꠞꠤ ꠉꠞꠥꠞ ꠉꠣꠠꠤ ꠖꠦꠅꠀ ꠅꠁꠟ। ꠔꠣꠞꠣ ꠁꠔꠣ ꠀꠘꠤꠀ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠍꠣꠝꠘꠦ ꠕꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","ꠔꠦꠃ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“ꠔꠥꠝꠤ ꠔꠣꠞꠣꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠅꠔꠣ ꠡꠝꠎꠤꠀ ꠞꠣꠈꠅ, ꠎꠣꠔꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠇꠣꠝꠅ ꠟꠣꠉꠣꠘꠤ ꠎꠣꠄ। ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠈꠣꠖꠤꠝ ꠅꠇꠟꠞ ꠇꠣꠝ ꠛꠥꠎꠤꠀ ꠔꠣꠞꠣꠞ ꠝꠣꠎꠦ ꠅꠔꠣ ꠛꠣꠐꠤꠀ ꠖꠦꠅ।” ");
INSERT INTO syls_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","ꠄꠞꠟꠣꠉꠤ ꠝꠥꠍꠣꠄ ꠅꠃ ꠉꠣꠠꠤ ꠀꠞ ꠉꠞꠥ ꠅꠉꠥꠁꠘ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠈꠣꠖꠤꠝ ꠅꠇꠟꠞꠦ ꠛꠣꠐꠤꠀ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","ꠄꠞꠣꠞ ꠝꠣꠎꠦ ꠟꠦꠛꠤꠞ ꠙꠄꠟꠣ ꠙꠥꠀ ꠎꠣꠞꠍꠥꠘꠞ ꠉꠥꠡ꠆ꠐꠤꠞ ꠇꠣꠝ ꠝꠣꠚꠤꠇ ꠖꠥꠈꠣꠘ ꠉꠞꠥꠞ ꠉꠣꠠꠤ ꠀꠞ ꠌꠣꠁꠞꠉꠥ ꠉꠞꠥ ꠔꠣꠞꠣꠞꠦ ꠖꠤꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ꠀꠞ ꠀꠞꠇ ꠙꠥꠀ ꠝꠣꠞꠣꠞꠤꠞ ꠉꠥꠡ꠆ꠐꠤꠞ ꠇꠣꠝ ꠛꠥꠎꠤꠀ ꠔꠣꠞꠣꠞꠦ ꠖꠤꠟꠣ ꠌꠣꠁꠞ ꠈꠣꠘ ꠉꠣꠠꠤ ꠀꠞ ꠀꠐꠉꠥ ꠉꠞꠥ। ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠙꠥꠀ ꠁꠍꠣꠝꠣꠞꠦ ꠅꠃ ꠇꠣꠝꠞ ꠔꠖꠣꠞꠇꠤ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","ꠅꠁꠟꠦ ꠟꠦꠛꠤꠞ ꠙꠥꠀ ꠇꠣꠢꠣꠔꠞ ꠉꠥꠡ꠆ꠐꠤꠞꠦ ꠁꠔꠣ ꠇꠥꠘ꠆ꠔꠣ ꠖꠤꠟꠣ ꠘꠣ, ꠇꠣꠞꠘ ꠘꠤꠅꠝ ꠀꠍꠤꠟ ꠔꠣꠞꠣ ꠈꠣꠟꠤ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠌꠤꠎ ꠅꠇꠟ ꠖꠦꠈꠣ-ꠢꠥꠘꠣ ꠇꠞꠣ, ꠀꠞ ꠅꠔꠣꠞꠦ ꠇꠣꠘ꠆ꠖꠅ ꠇꠞꠤ ꠛꠁꠀ ꠘꠦꠅꠀ। ");
INSERT INTO syls_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠔ ꠙꠛꠤꠔ꠆ꠞ ꠔꠦꠟ ꠍꠤꠐꠣꠘꠤꠞ ꠡꠝꠄ, ꠁꠈꠣꠘꠞꠦ ꠛꠅꠀꠁꠟ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠡꠞ꠆ꠖꠣꠞ ꠅꠇꠟꠦ ꠎꠣꠞꠎꠤꠞ ꠛꠈꠡꠤꠡ ꠟꠁꠀ ꠀꠁꠟꠣ। ꠀꠘꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠍꠣꠝꠘꠦ ꠕꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠙꠞꠔꠦꠇ ꠖꠤꠘ ꠄꠇ ꠄꠇ ꠡꠞ꠆ꠖꠣꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞꠦ ꠛꠅꠀꠁꠟ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠔꠣꠘ ꠛꠈꠡꠤꠡ ꠀꠘꠤꠀ ꠡꠝꠎꠣꠁꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","ꠙꠄꠟꠣ ꠖꠤꠘ ꠄꠢꠥꠖꠣ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠀꠝꠤꠘꠣꠖꠣꠛꠞ ꠙꠥꠀ ꠘꠣꠢꠤꠡꠦ ꠔꠣꠘ ꠛꠈꠡꠤꠡ ꠟꠁꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","ꠔꠣꠁꠘ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠟꠣꠉꠤ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠝꠣꠙꠦ ꠄꠇ-ꠡ ꠔꠤꠡ ꠔꠟꠣ ꠃꠎꠘꠞ ꠞꠥꠙꠣꠞ ꠄꠇꠈꠣꠘ ꠕꠣꠟ, ꠀꠞ ꠡꠔ꠆ꠔꠁꠞ ꠔꠟꠣ ꠃꠎꠘꠞ ꠞꠥꠙꠣꠞ ꠄꠇ ꠉꠣꠝꠟꠣ ꠀꠘꠤꠀ ꠖꠤꠟꠣ, ꠅꠃ ꠕꠣꠟ ꠀꠞ ꠉꠣꠝꠟꠣꠔ ꠜꠞꠣ ꠀꠍꠤꠟ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠘꠤꠅꠔꠦ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠝꠄꠖꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","ꠀꠉꠞ-ꠈꠥꠡꠛꠄꠄ ꠜꠞꠣ ꠖꠡ ꠔꠟꠣ ꠃꠎꠘꠞ ꠡꠥꠘꠣꠞ ꠄꠇꠐꠣ ꠛꠣꠐꠤ, ");
INSERT INTO syls_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠇꠐꠣ ꠛꠤꠍꠣꠟ, ꠄꠇꠐꠣ ꠝꠦꠠꠣ, ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠄꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ, ");
INSERT INTO syls_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠍꠣꠉꠟ, ");
INSERT INTO syls_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠖꠥꠉꠥ ꠉꠞꠥ, ꠙꠣꠌꠉꠥ ꠝꠦꠠꠣ, ꠙꠣꠌꠉꠥ ꠍꠣꠉꠟ ꠀꠞ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠙꠣꠌꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠀꠘꠟꠣ। ꠁꠔꠣ ꠅꠁꠟ ꠀꠝꠤꠘꠣꠖꠣꠛꠞ ꠙꠥꠀ ꠘꠣꠢꠤꠡꠞ ꠃꠙꠢꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","ꠖꠥꠁ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠁꠍꠣꠈꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠍꠥꠉꠣꠞꠞ ꠙꠥꠀ ꠘꠕꠘꠦꠟꠦ ꠛꠈꠡꠤꠡ ꠟꠁꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","ꠔꠣꠁꠘ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠟꠣꠉꠤ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠝꠣꠙꠦ ꠄꠇ-ꠡ ꠔꠤꠡ ꠔꠟꠣ ꠃꠎꠘꠞ ꠞꠥꠙꠣꠞ ꠄꠇꠈꠣꠘ ꠕꠣꠟ, ꠀꠞ ꠡꠔ꠆ꠔꠁꠞ ꠔꠟꠣ ꠃꠎꠘꠞ ꠞꠥꠙꠣꠞ ꠄꠇ ꠉꠣꠝꠟꠣ ꠀꠘꠤꠀ ꠖꠤꠟꠣ, ꠅꠃ ꠕꠣꠟ ꠀꠞ ꠉꠣꠝꠟꠣꠔ ꠜꠞꠣ ꠀꠍꠤꠟ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠘꠤꠅꠔꠦ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠝꠄꠖꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","ꠀꠉꠞ-ꠈꠥꠡꠛꠄꠄ ꠜꠞꠣ ꠖꠡ ꠔꠟꠣ ꠃꠎꠘꠞ ꠡꠥꠘꠣꠞ ꠄꠇꠐꠣ ꠛꠣꠐꠤ, ");
INSERT INTO syls_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠇꠐꠣ ꠛꠤꠍꠣꠟ, ꠄꠇꠐꠣ ꠝꠦꠠꠣ, ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠄꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ, ");
INSERT INTO syls_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠍꠣꠉꠟ, ");
INSERT INTO syls_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠖꠥꠉꠥ ꠉꠞꠥ, ꠙꠣꠌꠉꠥ ꠝꠦꠠꠣ, ꠙꠣꠌꠉꠥ ꠍꠣꠉꠟ ꠀꠞ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠙꠣꠌꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠀꠘꠟꠣ। ꠅꠔꠣ ꠀꠍꠤꠟ ꠍꠥꠉꠣꠞꠞ ꠙꠥꠀ ꠘꠕꠘꠦꠟꠞ ꠃꠙꠢꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","ꠔꠤꠘ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠍꠛꠥꠟꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠢꠦꠟꠘꠞ ꠙꠥꠀ ꠁꠟꠤꠀꠛꠦ ꠛꠈꠡꠤꠡ ꠟꠁꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","ꠔꠣꠁꠘ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠟꠣꠉꠤ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠝꠣꠙꠦ ꠄꠇ-ꠡ ꠔꠤꠡ ꠔꠟꠣ ꠃꠎꠘꠞ ꠞꠥꠙꠣꠞ ꠄꠇꠈꠣꠘ ꠕꠣꠟ, ꠀꠞ ꠡꠔ꠆ꠔꠁꠞ ꠔꠟꠣ ꠃꠎꠘꠞ ꠞꠥꠙꠣꠞ ꠄꠇ ꠉꠣꠝꠟꠣ ꠀꠘꠤꠀ ꠖꠤꠟꠣ, ꠅꠃ ꠕꠣꠟ ꠀꠞ ꠉꠣꠝꠟꠣꠔ ꠜꠞꠣ ꠀꠍꠤꠟ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠘꠤꠅꠔꠦ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠝꠄꠖꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","ꠀꠉꠞ-ꠈꠥꠡꠛꠄꠄ ꠜꠞꠣ ꠖꠡ ꠔꠟꠣ ꠃꠎꠘꠞ ꠡꠥꠘꠣꠞ ꠄꠇꠐꠣ ꠛꠣꠐꠤ, ");
INSERT INTO syls_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠇꠐꠣ ꠛꠤꠍꠣꠟ, ꠄꠇꠐꠣ ꠝꠦꠠꠣ, ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠄꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ, ");
INSERT INTO syls_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠍꠣꠉꠟ, ");
INSERT INTO syls_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠖꠥꠉꠥ ꠉꠞꠥ, ꠙꠣꠌꠉꠥ ꠝꠦꠠꠣ, ꠙꠣꠌꠉꠥ ꠍꠣꠉꠟ ꠀꠞ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠙꠣꠌꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠀꠘꠟꠣ। ꠅꠔꠣ ꠀꠍꠤꠟ ꠢꠦꠟꠘꠞ ꠙꠥꠀ ꠁꠟꠤꠀꠛꠞ ꠃꠙꠢꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","ꠌꠣꠁꠞ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠞꠥꠛꠦꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠡꠣꠖꠤꠃꠞꠞ ꠙꠥꠀ ꠀꠟꠤꠍꠥꠞꠦ ꠛꠈꠡꠤꠡ ꠟꠁꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","ꠔꠣꠁꠘ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠟꠣꠉꠤ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠝꠣꠙꠦ ꠄꠇ-ꠡ ꠔꠤꠡ ꠔꠟꠣ ꠃꠎꠘꠞ ꠞꠥꠙꠣꠞ ꠄꠇꠈꠣꠘ ꠕꠣꠟ, ꠀꠞ ꠡꠔ꠆ꠔꠁꠞ ꠔꠟꠣ ꠃꠎꠘꠞ ꠞꠥꠙꠣꠞ ꠄꠇ ꠉꠣꠝꠟꠣ ꠀꠘꠤꠀ ꠖꠤꠟꠣ, ꠅꠃ ꠕꠣꠟ ꠀꠞ ꠉꠣꠝꠟꠣꠔ ꠜꠞꠣ ꠀꠍꠤꠟ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠘꠤꠅꠔꠦ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠝꠄꠖꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","ꠀꠉꠞ-ꠈꠥꠡꠛꠄꠄ ꠜꠞꠣ ꠖꠡ ꠔꠟꠣ ꠃꠎꠘꠞ ꠡꠥꠘꠣꠞ ꠄꠇꠐꠣ ꠛꠣꠐꠤ, ");
INSERT INTO syls_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠇꠐꠣ ꠛꠤꠍꠣꠟ, ꠄꠇꠐꠣ ꠝꠦꠠꠣ, ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠄꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ, ");
INSERT INTO syls_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠍꠣꠉꠟ, ");
INSERT INTO syls_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠖꠥꠉꠥ ꠉꠞꠥ, ꠙꠣꠌꠉꠥ ꠝꠦꠠꠣ, ꠙꠣꠌꠉꠥ ꠍꠣꠉꠟ ꠀꠞ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠙꠣꠌꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠀꠘꠟꠣ। ꠅꠔꠣ ꠀꠍꠤꠟ ꠡꠣꠖꠤꠃꠞꠞ ꠙꠥꠀ ꠀꠟꠤꠍꠥꠞꠞ ꠃꠙꠢꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","ꠙꠣꠌ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠡꠤꠝꠤꠅꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠡꠥꠞꠡꠣꠖꠣꠄꠅꠞ ꠙꠥꠀ ꠡꠣꠟꠥꠝꠤꠟꠦ ꠛꠈꠡꠤꠡ ꠟꠁꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","ꠔꠣꠁꠘ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠟꠣꠉꠤ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠝꠣꠙꠦ ꠄꠇ-ꠡ ꠔꠤꠡ ꠔꠟꠣ ꠃꠎꠘꠞ ꠞꠥꠙꠣꠞ ꠄꠇꠈꠣꠘ ꠕꠣꠟ, ꠀꠞ ꠡꠔ꠆ꠔꠁꠞ ꠔꠟꠣ ꠃꠎꠘꠞ ꠞꠥꠙꠣꠞ ꠄꠇ ꠉꠣꠝꠟꠣ ꠀꠘꠤꠀ ꠖꠤꠟꠣ, ꠅꠃ ꠕꠣꠟ ꠀꠞ ꠉꠣꠝꠟꠣꠔ ꠜꠞꠣ ꠀꠍꠤꠟ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠘꠤꠅꠔꠦ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠝꠄꠖꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","ꠀꠉꠞ-ꠈꠥꠡꠛꠄꠄ ꠜꠞꠣ ꠖꠡ ꠔꠟꠣ ꠃꠎꠘꠞ ꠡꠥꠘꠣꠞ ꠄꠇꠐꠣ ꠛꠣꠐꠤ, ");
INSERT INTO syls_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠇꠐꠣ ꠛꠤꠍꠣꠟ, ꠄꠇꠐꠣ ꠝꠦꠠꠣ, ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠄꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ, ");
INSERT INTO syls_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠍꠣꠉꠟ, ");
INSERT INTO syls_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠖꠥꠉꠥ ꠉꠞꠥ, ꠙꠣꠌꠉꠥ ꠝꠦꠠꠣ, ꠙꠣꠌꠉꠥ ꠍꠣꠉꠟ ꠀꠞ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠙꠣꠌꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠀꠘꠟꠣ। ꠅꠔꠣ ꠀꠍꠤꠟ ꠡꠥꠞꠡꠣꠖꠣꠄꠅꠞ ꠙꠥꠀ ꠡꠣꠟꠥꠝꠤꠟꠞ ꠃꠙꠢꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ꠍꠄ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠍꠣꠖꠥ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠖꠥꠄꠟꠞ ꠙꠥꠀ ꠁꠟꠤꠀꠍꠚꠦ ꠛꠈꠡꠤꠡ ꠟꠁꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","ꠔꠣꠁꠘ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠟꠣꠉꠤ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠝꠣꠙꠦ ꠄꠇ-ꠡ ꠔꠤꠡ ꠔꠟꠣ ꠃꠎꠘꠞ ꠞꠥꠙꠣꠞ ꠄꠇꠈꠣꠘ ꠕꠣꠟ, ꠀꠞ ꠡꠔ꠆ꠔꠁꠞ ꠔꠟꠣ ꠃꠎꠘꠞ ꠞꠥꠙꠣꠞ ꠄꠇ ꠉꠣꠝꠟꠣ ꠀꠘꠤꠀ ꠖꠤꠟꠣ, ꠅꠃ ꠕꠣꠟ ꠀꠞ ꠉꠣꠝꠟꠣꠔ ꠜꠞꠣ ꠀꠍꠤꠟ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠘꠤꠅꠔꠦ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠝꠄꠖꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","ꠀꠉꠞ-ꠈꠥꠡꠛꠄꠄ ꠜꠞꠣ ꠖꠡ ꠔꠟꠣ ꠃꠎꠘꠞ ꠡꠥꠘꠣꠞ ꠄꠇꠐꠣ ꠛꠣꠐꠤ, ");
INSERT INTO syls_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠇꠐꠣ ꠛꠤꠍꠣꠟ, ꠄꠇꠐꠣ ꠝꠦꠠꠣ, ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠄꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ, ");
INSERT INTO syls_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠍꠣꠉꠟ, ");
INSERT INTO syls_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠖꠥꠉꠥ ꠉꠞꠥ, ꠙꠣꠌꠉꠥ ꠝꠦꠠꠣ, ꠙꠣꠌꠉꠥ ꠍꠣꠉꠟ ꠀꠞ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠙꠣꠌꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠀꠘꠟꠣ। ꠅꠔꠣ ꠀꠍꠤꠟ ꠖꠥꠄꠟꠞ ꠙꠥꠀ ꠁꠟꠤꠀꠍꠚꠞ ꠃꠙꠢꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠀꠚꠞꠣꠁꠝ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠀꠝꠤꠢꠥꠖꠞ ꠙꠥꠀ ꠀꠟꠤꠡꠣꠝꠣꠄ ꠛꠈꠡꠤꠡ ꠟꠁꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","ꠔꠣꠁꠘ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠟꠣꠉꠤ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠝꠣꠙꠦ ꠄꠇ-ꠡ ꠔꠤꠡ ꠔꠟꠣ ꠃꠎꠘꠞ ꠞꠥꠙꠣꠞ ꠄꠇꠈꠣꠘ ꠕꠣꠟ, ꠀꠞ ꠡꠔ꠆ꠔꠁꠞ ꠔꠟꠣ ꠃꠎꠘꠞ ꠞꠥꠙꠣꠞ ꠄꠇ ꠉꠣꠝꠟꠣ ꠀꠘꠤꠀ ꠖꠤꠟꠣ, ꠅꠃ ꠕꠣꠟ ꠀꠞ ꠉꠣꠝꠟꠣꠔ ꠜꠞꠣ ꠀꠍꠤꠟ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠘꠤꠅꠔꠦ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠝꠄꠖꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","ꠀꠉꠞ-ꠈꠥꠡꠛꠄꠄ ꠜꠞꠣ ꠖꠡ ꠔꠟꠣ ꠃꠎꠘꠞ ꠡꠥꠘꠣꠞ ꠄꠇꠐꠣ ꠛꠣꠐꠤ, ");
INSERT INTO syls_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠇꠐꠣ ꠛꠤꠍꠣꠟ, ꠄꠇꠐꠣ ꠝꠦꠠꠣ, ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠄꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ, ");
INSERT INTO syls_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠍꠣꠉꠟ, ");
INSERT INTO syls_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠖꠥꠉꠥ ꠉꠞꠥ, ꠙꠣꠌꠉꠥ ꠝꠦꠠꠣ, ꠙꠣꠌꠉꠥ ꠍꠣꠉꠟ ꠀꠞ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠙꠣꠌꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠀꠘꠟꠣ। ꠅꠔꠣ ꠀꠍꠤꠟ ꠀꠝꠤꠢꠥꠖꠞ ꠙꠥꠀ ꠀꠟꠤꠡꠣꠝꠣꠞ ꠃꠙꠢꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","ꠀꠐ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠝꠣꠘꠡꠣ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠚꠣꠔꠡꠥꠞꠞ ꠙꠥꠀ ꠉꠝꠟꠤꠄꠟꠦ ꠛꠈꠡꠤꠡ ꠟꠁꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","ꠔꠣꠁꠘ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠟꠣꠉꠤ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠝꠣꠙꠦ ꠄꠇ-ꠡ ꠔꠤꠡ ꠔꠟꠣ ꠃꠎꠘꠞ ꠞꠥꠙꠣꠞ ꠄꠇꠈꠣꠘ ꠕꠣꠟ, ꠀꠞ ꠡꠔ꠆ꠔꠁꠞ ꠔꠟꠣ ꠃꠎꠘꠞ ꠞꠥꠙꠣꠞ ꠄꠇ ꠉꠣꠝꠟꠣ ꠀꠘꠤꠀ ꠖꠤꠟꠣ, ꠅꠃ ꠕꠣꠟ ꠀꠞ ꠉꠣꠝꠟꠣꠔ ꠜꠞꠣ ꠀꠍꠤꠟ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠘꠤꠅꠔꠦ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠝꠄꠖꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","ꠀꠉꠞ-ꠈꠥꠡꠛꠄꠄ ꠜꠞꠣ ꠖꠡ ꠔꠟꠣ ꠃꠎꠘꠞ ꠡꠥꠘꠣꠞ ꠄꠇꠐꠣ ꠛꠣꠐꠤ, ");
INSERT INTO syls_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠇꠐꠣ ꠛꠤꠍꠣꠟ, ꠄꠇꠐꠣ ꠝꠦꠠꠣ, ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠄꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ, ");
INSERT INTO syls_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠍꠣꠉꠟ, ");
INSERT INTO syls_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠖꠥꠉꠥ ꠉꠞꠥ, ꠙꠣꠌꠉꠥ ꠝꠦꠠꠣ, ꠙꠣꠌꠉꠥ ꠍꠣꠉꠟ ꠀꠞ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠙꠣꠌꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠀꠘꠟꠣ। ꠅꠔꠣ ꠀꠍꠤꠟ ꠚꠣꠔꠡꠥꠞꠞ ꠙꠥꠀ ꠉꠝꠟꠤꠄꠟꠞ ꠃꠙꠢꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","ꠘꠄ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠛꠤꠘ-ꠁꠀꠝꠤꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠎꠤꠖꠣꠃꠘꠤꠞ ꠙꠥꠀ ꠀꠛꠤꠖꠣꠘꠦ ꠛꠈꠡꠤꠡ ꠟꠁꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","ꠔꠣꠁꠘ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠟꠣꠉꠤ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠝꠣꠙꠦ ꠄꠇ-ꠡ ꠔꠤꠡ ꠔꠟꠣ ꠃꠎꠘꠞ ꠞꠥꠙꠣꠞ ꠄꠇꠈꠣꠘ ꠕꠣꠟ, ꠀꠞ ꠡꠔ꠆ꠔꠁꠞ ꠔꠟꠣ ꠃꠎꠘꠞ ꠞꠥꠙꠣꠞ ꠄꠇ ꠉꠣꠝꠟꠣ ꠀꠘꠤꠀ ꠖꠤꠟꠣ, ꠅꠃ ꠕꠣꠟ ꠀꠞ ꠉꠣꠝꠟꠣꠔ ꠜꠞꠣ ꠀꠍꠤꠟ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠘꠤꠅꠔꠦ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠝꠄꠖꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","ꠀꠉꠞ-ꠈꠥꠡꠛꠄꠄ ꠜꠞꠣ ꠖꠡ ꠔꠟꠣ ꠃꠎꠘꠞ ꠡꠥꠘꠣꠞ ꠄꠇꠐꠣ ꠛꠣꠐꠤ, ");
INSERT INTO syls_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠇꠐꠣ ꠛꠤꠍꠣꠟ, ꠄꠇꠐꠣ ꠝꠦꠠꠣ, ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠄꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ, ");
INSERT INTO syls_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠍꠣꠉꠟ, ");
INSERT INTO syls_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠖꠥꠉꠥ ꠉꠞꠥ, ꠙꠣꠌꠉꠥ ꠝꠦꠠꠣ, ꠙꠣꠌꠉꠥ ꠍꠣꠉꠟ ꠀꠞ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠙꠣꠌꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠀꠘꠟꠣ। ꠅꠔꠣ ꠀꠍꠤꠟ ꠎꠤꠖꠣꠃꠘꠤꠞ ꠙꠥꠀ ꠀꠛꠤꠖꠣꠘꠞ ꠃꠙꠢꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","ꠖꠡ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠖꠣꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠀꠝꠤꠡꠣꠖꠣꠞ ꠙꠥꠀ ꠀꠈꠤꠀꠎꠣꠞꠦ ꠛꠈꠡꠤꠡ ꠟꠁꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","ꠔꠣꠁꠘ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠟꠣꠉꠤ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠝꠣꠙꠦ ꠄꠇ-ꠡ ꠔꠤꠡ ꠔꠟꠣ ꠃꠎꠘꠞ ꠞꠥꠙꠣꠞ ꠄꠇꠈꠣꠘ ꠕꠣꠟ, ꠀꠞ ꠡꠔ꠆ꠔꠁꠞ ꠔꠟꠣ ꠃꠎꠘꠞ ꠞꠥꠙꠣꠞ ꠄꠇ ꠉꠣꠝꠟꠣ ꠀꠘꠤꠀ ꠖꠤꠟꠣ, ꠅꠃ ꠕꠣꠟ ꠀꠞ ꠉꠣꠝꠟꠣꠔ ꠜꠞꠣ ꠀꠍꠤꠟ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠘꠤꠅꠔꠦ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠝꠄꠖꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","ꠀꠉꠞ-ꠈꠥꠡꠛꠄꠄ ꠜꠞꠣ ꠖꠡ ꠔꠟꠣ ꠃꠎꠘꠞ ꠡꠥꠘꠣꠞ ꠄꠇꠐꠣ ꠛꠣꠐꠤ, ");
INSERT INTO syls_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠇꠐꠣ ꠛꠤꠍꠣꠟ, ꠄꠇꠐꠣ ꠝꠦꠠꠣ, ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠄꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ, ");
INSERT INTO syls_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠍꠣꠉꠟ, ");
INSERT INTO syls_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠖꠥꠉꠥ ꠉꠞꠥ, ꠙꠣꠌꠉꠥ ꠝꠦꠠꠣ, ꠙꠣꠌꠉꠥ ꠍꠣꠉꠟ ꠀꠞ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠙꠣꠌꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠀꠘꠟꠣ। ꠅꠔꠣ ꠀꠍꠤꠟ ꠀꠝꠤꠡꠣꠖꠣꠞ ꠙꠥꠀ ꠀꠈꠤꠀꠎꠣꠞꠞ ꠃꠙꠢꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","ꠄꠉꠣꠞꠅ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠀꠡꠤꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠃꠇꠞꠣꠘꠞ ꠙꠥꠀ ꠚꠎꠤꠄꠟꠦ ꠛꠈꠡꠤꠡ ꠟꠁꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","ꠔꠣꠁꠘ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠟꠣꠉꠤ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠝꠣꠙꠦ ꠄꠇ-ꠡ ꠔꠤꠡ ꠔꠟꠣ ꠃꠎꠘꠞ ꠞꠥꠙꠣꠞ ꠄꠇꠈꠣꠘ ꠕꠣꠟ, ꠀꠞ ꠡꠔ꠆ꠔꠁꠞ ꠔꠟꠣ ꠃꠎꠘꠞ ꠞꠥꠙꠣꠞ ꠄꠇ ꠉꠣꠝꠟꠣ ꠀꠘꠤꠀ ꠖꠤꠟꠣ, ꠅꠃ ꠕꠣꠟ ꠀꠞ ꠉꠣꠝꠟꠣꠔ ꠜꠞꠣ ꠀꠍꠤꠟ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠘꠤꠅꠔꠦ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠝꠄꠖꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","ꠀꠉꠞ-ꠈꠥꠡꠛꠄꠄ ꠜꠞꠣ ꠖꠡ ꠔꠟꠣ ꠃꠎꠘꠞ ꠡꠥꠘꠣꠞ ꠄꠇꠐꠣ ꠛꠣꠐꠤ, ");
INSERT INTO syls_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠇꠐꠣ ꠛꠤꠍꠣꠟ, ꠄꠇꠐꠣ ꠝꠦꠠꠣ, ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠄꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ, ");
INSERT INTO syls_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠍꠣꠉꠟ, ");
INSERT INTO syls_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠖꠥꠉꠥ ꠉꠞꠥ, ꠙꠣꠌꠉꠥ ꠝꠦꠠꠣ, ꠙꠣꠌꠉꠥ ꠍꠣꠉꠟ ꠀꠞ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠙꠣꠌꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠀꠘꠟꠣ। ꠅꠔꠣ ꠀꠍꠤꠟ ꠃꠇꠞꠣꠘꠞ ꠙꠥꠀ ꠚꠎꠤꠄꠟꠞ ꠃꠙꠢꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","ꠛꠣꠞꠅ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠘꠙ꠆ꠔꠣꠟꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠁꠘꠣꠘꠞ ꠙꠥꠀ ꠀꠢꠤꠞꠦ ꠛꠈꠡꠤꠡ ꠟꠁꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","ꠔꠣꠁꠘ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠟꠣꠉꠤ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠝꠣꠙꠦ ꠄꠇ-ꠡ ꠔꠤꠡ ꠔꠟꠣ ꠃꠎꠘꠞ ꠞꠥꠙꠣꠞ ꠄꠇꠈꠣꠘ ꠕꠣꠟ, ꠀꠞ ꠡꠔ꠆ꠔꠁꠞ ꠔꠟꠣ ꠃꠎꠘꠞ ꠞꠥꠙꠣꠞ ꠄꠇ ꠉꠣꠝꠟꠣ ꠀꠘꠤꠀ ꠖꠤꠟꠣ, ꠅꠃ ꠕꠣꠟ ꠀꠞ ꠉꠣꠝꠟꠣꠔ ꠜꠞꠣ ꠀꠍꠤꠟ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠘꠤꠅꠔꠦ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠝꠄꠖꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","ꠀꠉꠞ-ꠈꠥꠡꠛꠄꠄ ꠜꠞꠣ ꠖꠡ ꠔꠟꠣ ꠃꠎꠘꠞ ꠡꠥꠘꠣꠞ ꠄꠇꠐꠣ ꠛꠣꠐꠤ, ");
INSERT INTO syls_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠇꠐꠣ ꠛꠤꠍꠣꠟ, ꠄꠇꠐꠣ ꠝꠦꠠꠣ, ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠄꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ, ");
INSERT INTO syls_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠍꠣꠉꠟ, ");
INSERT INTO syls_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠖꠥꠉꠥ ꠉꠞꠥ, ꠙꠣꠌꠉꠥ ꠝꠦꠠꠣ, ꠙꠣꠌꠉꠥ ꠍꠣꠉꠟ ꠀꠞ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠙꠣꠌꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠀꠘꠟꠣ। ꠅꠔꠣ ꠀꠍꠤꠟ ꠁꠘꠣꠘꠞ ꠙꠥꠀ ꠀꠢꠤꠞꠞ ꠃꠙꠢꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","ꠔꠦ ꠙꠛꠤꠔ꠆ꠞ ꠔꠦꠟ ꠖꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞꠦ ꠛꠅꠀꠁꠟ ꠇꠞꠣꠞ ꠡꠝꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠡꠞ꠆ꠖꠣꠞ ꠅꠇꠟꠦ ꠎꠦꠔꠣ ꠖꠣꠘ ꠇꠞꠍꠟꠣ ꠁꠔꠣ ꠅꠁꠟ, ꠛꠣꠞꠅ ꠈꠣꠘ ꠞꠥꠙꠣꠞ ꠕꠣꠟ, ꠛꠣꠞꠅꠐꠣ ꠞꠥꠙꠣꠞ ꠉꠣꠝꠟꠣ ꠀꠞ ꠛꠣꠞꠅꠐꠣ ꠡꠥꠘꠣꠞ ꠛꠣꠐꠤ। ");
INSERT INTO syls_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠝꠣꠙꠦ ꠙꠞꠔꠦꠇ ꠞꠥꠙꠣꠞ ꠕꠣꠟꠞ ꠃꠎꠘ ꠀꠍꠤꠟ ꠄꠇ-ꠡ ꠔꠤꠡ ꠔꠟꠣ ꠀꠞ ꠉꠣꠝꠟꠣꠞ ꠃꠎꠘ ꠀꠍꠤꠟ ꠡꠔ꠆ꠔꠁꠞ ꠔꠟꠣ। ꠞꠥꠙꠣꠞ ꠢꠇꠟ ꠕꠣꠟ-ꠛꠣꠡꠘꠞ ꠝꠥꠐ ꠃꠎꠘ ꠀꠍꠤꠟ ꠖꠥꠁ ꠀꠎꠣꠞ ꠌꠣꠁꠞ-ꠡ ꠔꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","ꠀꠉꠞ-ꠈꠥꠡꠛꠄꠄ ꠜꠞꠣ ꠙꠞꠔꠦꠇ ꠡꠥꠘꠣꠞ ꠛꠣꠐꠤꠞ ꠃꠎꠘ ꠀꠍꠤꠟ ꠖꠡ ꠔꠟꠣ, ꠡꠥꠘꠣꠞ ꠛꠣꠞꠅꠐꠣ ꠛꠣꠐꠤꠞ ꠝꠥꠐ ꠃꠎꠘ ꠀꠍꠤꠟ ꠄꠇ-ꠡ ꠛꠤꠡ ꠔꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠝꠥꠐ ꠛꠣꠞꠅꠉꠥ ꠛꠤꠍꠣꠟ, ꠛꠣꠞꠅꠉꠥ ꠝꠦꠠꠣ ꠀꠞ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠛꠣꠞꠅꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣꠅ ꠄꠞꠣ ꠖꠣꠘ ꠇꠞꠍꠟꠣ। ꠀꠞ ꠄꠞꠟꠉꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠢꠇꠟ ꠎꠤꠘꠤꠡ। ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠝꠥꠐ ꠛꠣꠞꠅꠉꠥ ꠍꠣꠉꠟ ꠖꠦꠅꠀ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠝꠥꠐ ꠌꠛ꠆ꠛꠤꠡꠉꠥ ꠉꠞꠥ, ꠡꠣꠁꠐꠉꠥ ꠝꠦꠠꠣ, ꠡꠣꠁꠐꠉꠥ ꠍꠣꠉꠟ, ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠡꠣꠁꠐꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ। ꠙꠛꠤꠔ꠆ꠞ ꠔꠦꠟ ꠍꠤꠐꠣꠁꠀ ꠢꠣꠞꠤ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞꠦ ꠛꠅꠀꠁꠟ ꠇꠞꠣꠞ ꠡꠝꠄ ꠃꠙꠢꠣꠞ ꠢꠤꠡꠣꠛꠦ ꠁ ꠢꠇꠟꠔꠣ ꠖꠦꠅꠀ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","ꠄꠞꠛꠣꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠎꠦꠛꠟꠣꠃ ꠝꠣꠛꠥꠖꠞ ꠟꠉꠦ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠔ ꠢꠣꠝꠣꠁꠔꠣ, ꠅꠃ ꠡꠝꠄ ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇꠞ ꠓꠣꠇꠘꠣꠞ ꠃꠙꠞꠦ ꠎꠦ ꠖꠥꠁꠅ ꠇꠣꠞꠥꠛꠤ ꠞꠂꠘ, ꠄꠞꠣꠞ ꠝꠣꠎꠈꠣꠘ ꠕꠣꠇꠤ ꠔꠣꠘ ꠛꠥꠟꠤ ꠢꠥꠘꠔꠣ। ꠝꠣꠛꠥꠖꠦ ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠝꠥꠍꠣ ꠘꠛꠤꠞ ꠟꠉꠦ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“ꠔꠥꠝꠤ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠅ, ꠀꠝꠣꠞ ꠊꠞꠞ ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤꠞ ꠝꠣꠎꠞ ꠡꠣꠔꠅꠐꠣ ꠌꠦꠞꠣꠉ ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠟꠣꠉꠣꠁꠔꠣ, ꠎꠣꠔꠦ ꠌꠦꠞꠣꠉꠞ ꠚꠞ ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤꠞ ꠍꠣꠝꠘꠣ ꠛꠣꠄ ꠙꠠꠦ।” ");
INSERT INTO syls_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","ꠢꠣꠞꠥꠘꠦ ꠅꠟꠣꠃ ꠇꠞꠟꠣ। ꠝꠥꠍꠣꠞꠦ ꠛꠣꠔꠣꠁꠟ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠔꠣꠁꠘ ꠢꠇꠟ ꠌꠦꠞꠣꠉ ꠅꠟꠣꠈꠣꠘ ꠛꠅꠀꠁꠟꠣ, ꠎꠣꠔꠦ ꠌꠦꠞꠣꠉꠞ ꠚꠞ ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤꠞ ꠍꠣꠝꠘꠦꠖꠤ ꠙꠠꠦ। ");
INSERT INTO syls_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤꠞ ꠔꠟ ꠕꠣꠇꠤ ꠀꠉꠣꠞ ꠚꠥꠟ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠀꠡ꠆ꠔꠣꠐꠣ ꠈꠣꠐꠤ ꠡꠥꠘꠣ ꠙꠤꠐꠣꠁꠀ ꠛꠣꠘꠣꠁꠟ ꠅꠁꠟ। ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠎꠦꠟꠣ ꠘꠇꠡꠣ ꠖꠦꠈꠣꠁꠍꠟꠣ, ꠑꠤꠇ ꠅꠃ ꠟꠣꠈꠣꠘ ꠌꠦꠞꠣꠉ ꠖꠣꠘꠤ ꠛꠣꠘꠣꠁꠟ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠎ ꠕꠣꠇꠤ, ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞꠦ ꠀꠟꠉ ꠇꠞꠤꠀ ꠙꠣꠇ-ꠙꠣꠇꠤꠎꠣ ꠇꠞꠅ। ");
INSERT INTO syls_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","ꠁ ꠙꠣꠇ-ꠙꠣꠇꠤꠎꠣ ꠇꠞꠣꠞ ꠘꠤꠅꠝ ꠅꠁꠟ, ꠙꠄꠟꠣ ꠔꠣꠞꠣꠞ ꠃꠙꠞꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠅꠀꠞ ꠙꠣꠘꠤ ꠍꠤꠐꠣꠁꠀ ꠖꠤꠛꠣꠄ, ꠍꠤꠐꠣꠁꠀ ꠔꠣꠞꠣ ꠘꠤꠎꠦ ꠀꠡ꠆ꠔꠣ ꠡꠞꠤꠟꠞ ꠌꠥꠟ ꠇꠣꠝꠣꠁꠀ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠙꠣꠇ-ꠍꠣꠚ ꠛꠘꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","ꠀꠞ ꠔꠣꠞꠣ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠛꠤꠍꠣꠟ ꠀꠘꠛꠣ, ꠛꠤꠍꠣꠟꠞ ꠟꠉꠦ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠟꠣꠉꠤ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠝꠄꠖꠣ, ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤꠅ ꠀꠞꠇꠐꠣ ꠛꠤꠍꠣꠟ ꠀꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","ꠛꠣꠖꠦ ꠔꠥꠝꠤ ꠟꠦꠛꠤ ꠅꠇꠟꠞꠦ ꠟꠁꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠍꠣꠝꠘꠦ ꠀꠁꠛꠣꠄ, ꠀꠁꠀ ꠢꠇ꠆ꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠢꠘꠅ ꠖꠟꠣ ꠇꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","ꠟꠦꠛꠤ ꠅꠇꠟꠞꠦ ꠔꠥꠝꠤ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠀꠎꠤꠞ ꠇꠞꠛꠣꠄ ꠀꠞ ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠔꠣꠞꠣꠞꠦ ꠀꠔꠣꠁꠀ ꠡꠙꠤꠀ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠦ ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠙꠇ꠆ꠇ ꠕꠣꠇꠤ, ꠖꠥꠟꠘꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠟꠦꠛꠤ ꠅꠇꠟꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠛꠈꠡꠤꠀ ꠖꠤꠛꠣ, ꠔꠦꠃ ꠔꠣꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠈꠦꠎꠝꠔꠅ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠔꠣ ꠙꠣꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","ꠛꠣꠖꠦ ꠟꠦꠛꠤ ꠅꠇꠟꠦ ꠢꠃ ꠖꠥꠁꠅ ꠛꠤꠍꠣꠟꠞ ꠇꠟ꠆ꠟꠣꠞ ꠃꠙꠞꠦ ꠀꠔꠣꠁ ꠖꠤꠛꠣ, ꠖꠤꠟꠦ ꠔꠥꠝꠤ ꠄꠞ ꠄꠇꠐꠣ ꠖꠤꠀ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠞ ꠖꠥꠍꠞꠣꠐꠣ ꠖꠤꠀ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ꠅꠟꠣꠈꠣꠘ ꠟꠦꠛꠤ ꠅꠇꠟꠞ ꠘꠣꠙꠣꠇꠤꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","ꠔꠥꠝꠤ ꠟꠦꠛꠤ ꠅꠇꠟꠞꠦ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠍꠣꠝꠘꠦ ꠃꠛꠣ ꠇꠞꠣꠁꠀ, ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠔꠣꠞꠣꠞꠦ ꠖꠥꠟꠘꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠡꠙꠤꠀ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","ꠅꠃ ꠟꠣꠈꠣꠘ ꠔꠥꠝꠤ ꠅꠁꠘ꠆ꠘ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠕꠣꠇꠤ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞꠦ ꠀꠟꠉ ꠇꠞꠛꠣꠄ, ꠔꠦꠃ ꠔꠣꠞꠣ ꠈꠣꠟꠤ ꠀꠝꠣꠞ ꠅꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“ꠟꠦꠛꠤ ꠅꠇꠟꠞꠦ ꠙꠣꠇ-ꠙꠣꠇꠤꠎꠣ ꠇꠞꠤꠀ ꠖꠥꠟꠘꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠡꠙꠤꠀ ꠖꠤꠀ ꠢꠣꠞꠟꠦ, ꠔꠣꠞꠣ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠈꠦꠎꠝꠔꠅ ꠀꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠕꠣꠇꠤ ꠛꠣꠍꠤꠀ ꠀꠟꠉ ꠇꠞꠣ ꠁ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘ ꠈꠣꠟꠤ ꠀꠝꠣꠞ, ꠀꠞ ꠇꠦꠃꠞꠞ ꠘꠣꠄ। ꠙꠞꠔꠦꠇ ꠁꠍꠞꠣꠁꠟꠤ ꠛꠦꠐꠤꠘ꠆ꠔꠞ ꠙꠄꠟꠣ ꠙꠥꠀꠞ ꠛꠖꠟꠣ ꠀꠝꠤ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞꠦ ꠀꠝꠣꠞ ꠘꠤꠎꠞ ꠛꠣꠘꠣꠁꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠊꠞꠅ ꠎꠘꠝ ꠟꠅꠀ ꠢꠇꠟ ꠙꠄꠟꠣ ꠙꠥꠀꠂꠘ ꠀꠝꠣꠞ। ꠀꠝꠤ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠞ ꠙꠄꠟꠣ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠝꠣꠞꠤꠟꠤꠛꠣꠞ ꠇꠣꠟꠅ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠙꠞꠔꠦꠇ ꠙꠄꠟꠣ ꠙꠥꠀꠞꠦ ꠀꠝꠣꠞ ꠟꠣꠉꠤ ꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠤꠀ ꠞꠣꠈꠍꠤ, ꠁꠔꠣ ꠝꠣꠘꠡꠞ ꠙꠥꠔ ꠅꠃꠇ ꠛꠣ ꠙꠡꠥꠞ ꠛꠣꠁꠌ꠆ꠌꠣ ꠅꠃꠇ, ꠁꠔꠣ ꠔ ꠀꠝꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","ꠀꠞ ꠅꠈꠘ ꠀꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠙꠄꠟꠣ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠎꠣꠉꠣꠔ ꠈꠣꠟꠤ ꠟꠦꠛꠤ ꠅꠇꠟꠞꠦ ꠀꠝꠣꠞ ꠘꠤꠎꠞ ꠇꠁꠀ ꠇꠛꠥꠟ ꠇꠞꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","ꠅꠃ ꠟꠦꠛꠤ ꠅꠇꠟꠞꠦ ꠀꠝꠤ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠡꠝꠎꠣꠁꠍꠤ, ꠎꠣꠔꠦ ꠔꠣꠞꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠅꠁꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠈꠦꠎꠝꠔ ꠇꠞꠂꠘ, ꠔꠣꠞꠣꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠃꠍꠤꠟ꠆ꠟꠣ ꠇꠞꠂꠘ। ꠄꠞꠟꠣꠉꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠇꠦꠃ ꠀꠝꠣꠞ ꠊꠞꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠀꠁꠟꠦꠅ ꠔꠣꠞ ꠃꠙꠞꠦ ꠇꠥꠘꠥ ꠉꠎꠛ ꠟꠣꠝꠔ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","ꠝꠣꠛꠥꠖꠦ ꠟꠦꠛꠤ ꠅꠇꠟꠞ ꠛꠦꠙꠣꠞꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠅꠃ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠝꠥꠍꠣ, ꠢꠣꠞꠥꠘ ꠀꠞ ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠅꠟꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","ꠟꠦꠛꠤ ꠅꠇꠟꠦ ꠘꠤꠎꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠞꠤꠀ ꠢꠣꠞꠤ ꠔꠣꠞꠣꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠꠅ ꠕꠁꠟꠣ। ꠛꠣꠖꠦ ꠢꠣꠞꠥꠘꠦ ꠔꠣꠞꠣꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠖꠥꠟꠘꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠡꠙꠤꠀ ꠖꠤꠟꠣ, ꠀꠞ ꠔꠣꠞꠣꠞꠦ ꠙꠣꠇ-ꠙꠣꠇꠤꠎꠣ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠔꠣꠞꠣꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠛꠦꠛꠡ꠆ꠔꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","ꠄꠞꠛꠣꠖꠦ ꠟꠦꠛꠤ ꠅꠇꠟꠅ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠘ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠎꠤꠝ꠆ꠝꠣꠄ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠈꠣꠖꠤꠝꠖꠣꠞꠤꠔ ꠉꠦꠟꠣ। ꠉꠦꠟꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠟꠦꠛꠤ ꠅꠇꠟꠞ ꠛꠦꠙꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠑꠤꠇ ꠅꠃꠟꠣ ꠇꠞꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“ꠟꠦꠛꠤ ꠅꠇꠟꠞ ꠛꠦꠙꠣꠞꠦ ꠅꠃ ꠘꠤꠅꠝ ꠌꠣꠟꠥ ꠅꠁꠛ, ꠔꠣꠞꠣꠞ ꠝꠣꠎꠦ ꠙꠌꠤꠡ ꠛꠍꠞ ꠛꠣ ꠔꠣꠞ ꠛꠦꠡꠤ ꠛꠄꠅꠡꠤ ꠝꠣꠘꠡꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠛꠣ, ");
INSERT INTO syls_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ꠅꠁꠟꠦ ꠙꠁꠘ꠆ꠌꠣꠡ ꠛꠍꠞ ꠅꠁꠀ ꠢꠣꠞꠟꠦ ꠔꠣꠞꠣ ꠅꠛꠡꠞ ꠙꠣꠁꠟꠤꠛꠣ, ꠈꠦꠎꠝꠔ ꠇꠣꠝ ꠛꠣꠖ ꠖꠤꠟꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","ꠅꠃ ꠡꠝꠄ ꠔꠣꠞꠣ ꠘꠤꠎꠞ ꠀꠔꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠇꠥꠘꠥ ꠇꠣꠝ ꠇꠞꠣ ꠘꠤꠡꠦꠗ, ꠅꠁꠟꠦ ꠔꠣꠞꠣꠞ ꠝꠘꠦ ꠌꠣꠁꠟꠦ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠇꠣꠝꠅ ꠡꠣꠄ-ꠡꠣꠁꠎ꠆ꠎ ꠇꠞꠛꠣ। ꠅꠃ ꠘꠤꠅꠝꠦ ꠔꠥꠝꠤ ꠟꠦꠛꠤ ꠅꠇꠟꠞ ꠇꠣꠝ-ꠇꠣꠎ ꠑꠤꠇ ꠇꠞꠤ ꠖꠤꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠎꠣꠔꠤ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠣꠞꠘꠤꠞ ꠖꠥꠍꠞꠣ ꠛꠍꠞꠞ ꠙꠄꠟꠣ ꠌꠣꠘ꠆ꠖꠅ, ꠍꠤꠘꠣꠁ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠛꠣꠔꠣꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠎꠣꠘꠥ ꠑꠤꠇ ꠡꠝꠄꠄ ꠀꠎꠣꠖꠤ ꠁꠖ ꠀꠖꠣꠄ ꠇꠞꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","ꠔꠣꠞꠣ ꠅꠃ ꠌꠣꠘ꠆ꠖꠞ ꠌꠃꠖ꠆ꠖ ꠔꠣꠞꠤꠈ ꠢꠣꠁꠘ꠆ꠎꠣ ꠛꠣꠟꠣ ꠀꠝꠣꠞ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠝꠣꠘꠤꠀ ꠁꠖ ꠀꠖꠣꠄ ꠇꠞꠔꠦ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠙꠣꠁꠀ ꠝꠥꠍꠣꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁꠟꠣ ꠀꠎꠣꠖꠤ ꠁꠖ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","ꠄꠞꠖꠣꠄ ꠔꠣꠞꠣ ꠙꠄꠟꠣ ꠌꠣꠘ꠆ꠖꠞ ꠌꠃꠖ꠆ꠖ ꠔꠣꠞꠤꠈ ꠢꠣꠁꠘ꠆ꠎꠣ ꠛꠣꠟꠣ ꠍꠤꠘꠣꠁ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠅꠃ ꠁꠖ ꠀꠖꠣꠄ ꠇꠞꠟꠣ। ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠎꠦꠟꠣꠈꠣꠘ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠔꠣꠞꠣ ꠑꠤꠇ ꠅꠟꠣꠈꠣꠘ ꠢꠇꠟꠔꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","ꠅꠁꠟꠦ ꠔꠣꠞꠣꠞ ꠝꠣꠎꠦ ꠇꠄꠎꠘꠦ ꠝꠞꠣ ꠟꠣꠡꠞꠦ ꠍꠁꠀ ꠘꠣꠙꠣꠇ ꠅꠀꠄ, ꠅꠃ ꠖꠤꠘ ꠀꠎꠣꠖꠤ ꠁꠖ ꠇꠞꠔ ꠙꠣꠞꠟ ꠘꠣ। ꠄꠞꠟꠣꠉꠤ ꠅꠃ ꠖꠤꠘꠃ ꠔꠣꠞꠣ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘ ꠘꠛꠤꠞ ꠉꠦꠍꠦ ꠉꠤꠀ ꠀꠎꠤꠞ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ꠔꠣꠞꠣ ꠝꠥꠍꠣꠞꠦ ꠎꠤꠇꠣꠁꠟꠣ, “ꠝꠞꠣ ꠟꠣꠡ ꠍꠅꠀꠄ ꠀꠝꠞꠣ ꠘꠣꠙꠣꠇ ꠅꠁꠍꠤ, ꠄꠞꠟꠣꠉꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠉꠦ ꠑꠤꠇ ꠡꠝꠄ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠔꠣꠝ ꠙꠣꠞꠔꠣꠝ ꠘꠣ ꠇꠦꠘꠦ?” ");
INSERT INTO syls_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","ꠝꠥꠍꠣꠄ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠔꠥꠝꠞꠣꠞ ꠛꠦꠙꠣꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠘꠣ ꠎꠣꠘꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠔꠥꠝꠞꠣ ꠛꠣꠞ ꠌꠣꠅ।” ");
INSERT INTO syls_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","ꠅꠃ ꠡꠝꠄ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠅ, ꠔꠣꠞꠣ ꠛꠣ ꠔꠣꠞꠣꠞ ꠛꠋꠡꠞ ꠇꠦꠃ ꠎꠥꠖꠤ ꠝꠞꠣ ꠟꠣꠡꠞꠦ ꠗꠞꠣ-ꠍꠥꠀꠞ ꠇꠣꠞꠘꠦ ꠘꠣꠙꠣꠇ ꠛꠘꠤꠎꠣꠄ, ꠛꠣ ꠝꠥꠍꠣꠚꠤꠞ ꠢꠣꠟꠔꠦ ꠟꠣꠝ꠆ꠛꠣ ꠍꠚꠞꠅ ꠕꠣꠇꠦ, ꠔꠦ ꠔꠣꠞꠣꠅ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠎꠣꠖꠤ ꠁꠖ ꠀꠖꠣꠄ ꠇꠞꠔꠣ ꠙꠣꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ꠖꠥꠍꠞꠣ ꠌꠣꠘ꠆ꠖꠞ ꠌꠃꠖ꠆ꠖ ꠔꠣꠞꠤꠈ ꠢꠣꠁꠘ꠆ꠎꠣ ꠛꠣꠟꠣ ꠔꠣꠞꠣ ꠅꠃ ꠁꠖ ꠇꠞꠛꠣ। ꠀꠎꠣꠖꠤ ꠁꠖꠞ ꠉꠥꠡ꠆ꠔꠞ ꠟꠉꠦ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠞꠥꠐꠤ ꠀꠞ ꠔꠤꠔ꠆ꠔꠣ ꠢꠣꠉ ꠙꠥꠞꠣꠁꠀ ꠈꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","ꠛꠤꠀꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠇꠥꠘꠥꠎꠣꠔ ꠈꠣꠘꠤ ꠎꠝꠣ ꠞꠣꠈꠣ ꠘꠤꠡꠦꠗ, ꠇꠥꠞꠛꠣꠘꠤꠞ ꠉꠥꠡ꠆ꠔꠞ ꠎꠦꠇꠥꠘꠥ ꠀꠒ꠆ꠒꠤ ꠜꠣꠋꠉꠣ ꠘꠤꠡꠦꠗ। ꠀꠎꠣꠖꠤ ꠁꠖꠞ ꠅꠃ ꠢꠇꠟ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠔꠣꠞꠣ ꠝꠣꠘꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","ꠅꠁꠟꠦ ꠎꠦꠞꠣ ꠙꠣꠇ-ꠙꠣꠇꠤꠎꠣ ꠢꠣꠟꠔꠦ ꠀꠍꠦ, ꠀꠞ ꠎꠦꠞꠣ ꠍꠚꠞꠞ ꠝꠣꠎꠦ ꠘꠣꠄ, ꠁꠟꠣ ꠇꠥꠘꠥ ꠎꠘꠦ ꠎꠥꠖꠤ ꠀꠎꠣꠖꠤ ꠁꠖꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠘꠣ ꠖꠦꠄ, ꠔꠦ ꠝꠣꠛꠥꠖꠞ ꠑꠤꠇ ꠇꠞꠣ ꠡꠝꠄꠄ ꠇꠥꠞꠛꠣꠘꠤ ꠘꠣ ꠖꠦꠅꠀꠄ, ꠔꠣꠞ ꠎꠣꠔꠤ ꠕꠣꠇꠤ ꠔꠣꠞ ꠘꠣꠝ ꠝꠤꠐꠣꠁꠟꠤꠛꠣꠄ। ꠔꠣꠞ ꠉꠥꠘꠣꠞ ꠡꠣꠎꠣ ꠢꠦ ꠙꠣꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠎꠦ ꠛꠡꠔ ꠇꠞꠞꠣ ꠛꠤꠖꠦꠡꠤ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠎꠣꠖꠤ ꠁꠖ ꠀꠖꠣꠄ ꠇꠞꠔ ꠌꠣꠄ, ꠔꠦ ꠇꠞꠔ ꠙꠣꠞꠛ। ꠅꠁꠟꠦ ꠅꠃ ꠁꠖꠞ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠝꠣꠘꠤꠀ ꠀꠖꠣꠄ ꠇꠞꠔꠦ ꠅꠁꠛ। ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠛꠣ ꠜꠤꠘ-ꠖꠦꠡꠤ ꠢꠇꠟꠦꠃ ꠄꠇꠁ ꠘꠤꠅꠝ ꠝꠣꠘꠔꠦ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","ꠀꠟ꠆ꠟꠣꠞ ꠊꠞ ꠡꠣꠢꠣꠖꠔ ꠔꠣꠝ꠆ꠛꠥ ꠎꠦꠖꠤꠘ ꠈꠣꠠꠣ ꠇꠞꠣ ꠅꠁꠟ, ꠅꠃ ꠖꠤꠘ ꠇꠥꠖꠞꠔꠤ ꠝꠦꠊꠞ ꠈꠥꠐꠤ ꠀꠁꠀ ꠀꠡ꠆ꠔꠣ ꠊꠞꠞꠦ ꠉꠥꠞꠤꠟꠤꠟ। ꠢꠣꠁꠘ꠆ꠎꠣ ꠕꠣꠇꠤ ꠛꠤꠀꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠣꠞꠣ ꠞꠣꠁꠔ ꠁ ꠝꠦꠊꠞ ꠈꠥꠐꠤꠞꠦ ꠘꠥꠞꠞ ꠀꠉꠥꠘꠤꠞ ꠟꠣꠈꠣꠘ ꠖꠦꠈꠣ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","ꠄꠞꠛꠣꠖ ꠕꠣꠇꠤ ꠅꠟꠣ ꠅꠁꠟ, ꠀꠟ꠆ꠟꠣꠞ ꠊꠞ ꠖꠤꠘꠞ ꠛꠣꠟꠣ ꠢꠣꠝꠦꠡꠣ ꠝꠦꠊꠞ ꠈꠥꠐꠤꠄ ꠉꠥꠞꠣ ꠞꠁꠔ, ꠀꠞ ꠞꠣꠁꠔꠞ ꠛꠣꠟꠣ ꠝꠘꠅ ꠅꠁꠔ ꠁꠔꠣ ꠘꠥꠞꠞ ꠀꠉꠥꠘꠤꠞ ꠈꠥꠐꠤ। ");
INSERT INTO syls_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","ꠀꠞ ꠙꠛꠤꠔ꠆ꠞ ꠔꠣꠝ꠆ꠛꠥꠞ ꠃꠙꠞꠦ ꠕꠣꠇꠤ ꠝꠦꠊꠞ ꠈꠥꠐꠤ ꠎꠦꠛꠟꠣ ꠢꠞꠔ, ꠅꠃ ꠡꠝꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠅꠇꠟ ꠍꠚꠞꠅ ꠛꠣꠞ ꠅꠁꠔꠣ, ꠛꠣꠖꠦ ꠎꠦꠘꠅ ꠉꠤꠀ ꠅꠃ ꠈꠥꠐꠤ ꠕꠤꠞ ꠅꠁꠔ, ꠔꠣꠞꠣ ꠅꠈꠣꠘꠅꠃ ꠔꠣꠝ꠆ꠛꠥ ꠅꠇꠟ ꠉꠣꠠꠤꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝꠦ ꠔꠣꠞꠣ ꠍꠚꠞꠅ ꠛꠣꠞ ꠅꠁꠔꠣ ꠀꠞ ꠔꠣꠘ ꠢꠥꠇꠥꠝꠦꠃ ꠍꠚꠞ ꠛꠘ꠆ꠖ ꠇꠞꠤꠀ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠔꠣ। ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠃꠙꠞꠦ ꠎꠔꠛꠁꠟ ꠝꠦꠊꠞ ꠈꠥꠐꠤ ꠞꠁꠔ, ꠔꠣꠞꠣ ꠅꠔꠛꠁꠟ ꠇꠦꠝ꠆ꠙꠞ ꠜꠤꠔꠞꠦ ꠞꠁꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠃꠙꠞꠦ ꠝꠦꠊꠞ ꠈꠥꠐꠤ ꠛꠦꠡꠤ ꠖꠤꠘ ꠞꠁꠟꠦ, ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠘꠤꠀ ꠔꠣꠞꠣ ꠇꠥꠘꠥ ꠍꠚꠞꠅ ꠛꠣꠞ ꠅꠁꠔꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","ꠝꠣꠎꠦ ꠝꠣꠎꠦ ꠝꠦꠊꠞ ꠈꠥꠐꠤ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠃꠙꠞꠦ ꠕꠥꠠꠣ ꠖꠤꠘ ꠞꠁꠔ। ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠔ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝꠦ ꠇꠦꠝ꠆ꠙꠅ ꠞꠁꠔꠣ ꠀꠞ ꠔꠣꠘ ꠢꠥꠇꠥꠝꠦꠃ ꠢꠤꠞꠛꠣꠞ ꠍꠚꠞꠅ ꠛꠣꠞ ꠅꠁꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","ꠀꠞ ꠝꠣꠎꠦ ꠝꠣꠎꠦ ꠈꠣꠟꠤ ꠢꠣꠁꠘ꠆ꠎꠣ ꠕꠣꠇꠤ ꠛꠤꠀꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠝꠦꠊꠞ ꠈꠥꠐꠤ ꠞꠁꠔ। ꠛꠤꠀꠘꠦ ꠝꠦꠊꠞ ꠈꠥꠐꠤ ꠢꠞꠤꠉꠦꠟꠦ ꠔꠣꠞꠣ ꠍꠚꠞꠅ ꠛꠣꠞ ꠅꠁꠔꠣ। ꠖꠤꠘꠅ ꠛꠣ ꠞꠣꠁꠔ ꠎꠦꠇꠥꠘꠥ ꠡꠝꠄ ꠝꠦꠊꠞ ꠈꠥꠐꠤ ꠢꠞꠣꠞ ꠟꠉꠦ ꠟꠉꠦꠃ ꠔꠣꠞꠣ ꠍꠚꠞꠅ ꠛꠣꠞ ꠅꠁꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","ꠎꠔꠖꠤꠘ ꠝꠦꠊꠞ ꠈꠥꠐꠤ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠃꠙꠞꠦ ꠞꠁꠔ, ꠅꠔꠖꠤꠘ ꠔꠣꠞꠣ ꠇꠦꠝ꠆ꠙꠅ ꠞꠁꠔꠣ, ꠍꠚꠞꠅ ꠛꠣꠞ ꠅꠁꠔꠣ ꠘꠣ। ꠁꠔꠣ ꠖꠥꠁ ꠖꠤꠘ ꠅꠃꠇ, ꠄꠇ ꠝꠣꠡ ꠛꠣ ꠄꠞ ꠛꠦꠡꠤ ꠅꠁꠟꠦꠅ ꠛꠣꠞ ꠅꠁꠔꠣ ꠘꠣ, ꠈꠣꠟꠤ ꠝꠦꠊꠞ ꠈꠥꠐꠤ ꠢꠞꠣꠞ ꠛꠣꠖꠦ ꠔꠣꠞꠣ ꠍꠚꠞꠅ ꠛꠣꠞ ꠅꠁꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝꠦ ꠔꠣꠞꠣ ꠇꠦꠝ꠆ꠙ ꠉꠣꠠꠤꠔꠣ ꠀꠞ ꠔꠣꠘ ꠢꠥꠇꠥꠝꠦꠃ ꠍꠚꠞꠅ ꠞꠅꠀꠘꠣ ꠅꠁꠔꠣ। ꠝꠥꠍꠣ ꠘꠛꠤꠞ ꠝꠣꠞꠚꠔꠦ ꠙꠣꠅꠀ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ, ꠔꠣꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠅꠃ ꠘꠤꠅꠝ ꠝꠣꠘꠤꠀ ꠌꠟꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“ꠔꠥꠝꠤ ꠞꠥꠙꠣꠞ ꠙꠣꠔ ꠙꠤꠐꠣꠁꠀ ꠖꠥꠁꠐꠣ ꠌꠥꠋꠉꠣ ꠛꠣꠘꠣꠅ। ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠄꠇꠈꠣꠘꠅ ꠖꠟꠣ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠒꠣꠇꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠅꠃ ꠌꠥꠋꠉꠣ ꠛꠣꠎꠣꠁꠅ, ꠔꠣꠞꠣꠞ ꠘꠣꠘꠣꠘ ꠖꠟ ꠍꠚꠞꠅ ꠞꠅꠀꠘꠣ ꠅꠀꠞ ꠛꠣꠟꠣꠅ ꠔꠥꠝꠤ ꠅꠉꠥꠁꠘ ꠛꠣꠎꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","ꠅꠃ ꠖꠥꠁꠅ ꠌꠥꠋꠉꠣ ꠎꠦꠛꠟꠣ ꠄꠇꠟꠉꠦ ꠛꠣꠎꠣꠘꠤ ꠅꠁꠛ, ꠅꠃ ꠡꠝꠄ ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠔꠥꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠉꠦꠍꠦ ꠀꠁꠀ ꠖꠟꠣ ꠅꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","ꠅꠁꠟꠦ ꠄꠇꠐꠣ ꠌꠥꠋꠉꠣ ꠛꠣꠎꠣꠘꠤ ꠅꠁꠟꠦ ꠈꠣꠟꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠘꠣꠘꠣꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠅꠇꠟ ꠔꠥꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠀꠁꠀ ꠖꠟꠣ ꠅꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","ꠙꠄꠟꠣ ꠛꠣꠞ ꠌꠥꠋꠉꠣ ꠛꠣꠎꠣꠁꠟꠦ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠙꠥꠛꠦꠖꠤ ꠎꠦꠞꠣ ꠔꠣꠝ꠆ꠛꠥ ꠐꠣꠋꠉꠣꠁꠍꠦ, ꠔꠣꠞꠣ ꠞꠅꠀꠘꠣ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","ꠖꠥꠍꠞꠣꠛꠣꠞ ꠛꠣꠎꠣꠁꠟꠦ ꠖꠃꠇꠘꠞ ꠉꠣꠟꠣꠞ ꠖꠟ ꠅꠇꠟ ꠞꠅꠀꠘꠣ ꠖꠤꠛꠣ। ꠁꠇꠐꠣ ꠔ ꠍꠚꠞꠅ ꠞꠅꠀꠘꠣ ꠖꠤꠛꠣꠞ ꠡꠋꠇꠦꠔ। ");
INSERT INTO syls_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","ꠔꠦ ꠢꠇꠟ ꠝꠣꠘꠡꠞꠦ ꠖꠟꠣ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠤ ꠖꠥꠁꠅ ꠌꠥꠋꠉꠣ ꠛꠣꠎꠣꠁꠅ, ꠅꠁꠟꠦ ꠄꠞ ꠡꠥꠞ ꠅꠁꠛ ꠀꠟꠣꠖꠣ ꠞꠇꠝꠞ। ");
INSERT INTO syls_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","ꠅꠃ ꠌꠥꠋꠉꠣ ꠛꠣꠎꠣꠁꠛꠣ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠛꠋꠡꠞ ꠁꠝꠣꠝ ꠅꠇꠟꠦ। ꠁꠐꠣ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠛꠋꠡꠗꠞꠞ ꠟꠣꠉꠤꠅ ꠌꠤꠞꠇꠣꠟꠤꠘ ꠘꠤꠅꠝ। ");
INSERT INTO syls_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“ꠘꠤꠎꠞ ꠖꠦꠡꠅ ꠉꠤꠀ ꠢꠣꠞꠟꠦ ꠔꠥꠝꠞꠣ ꠎꠦꠛꠟꠣ ꠇꠥꠘꠥ ꠎꠥꠟꠥꠝꠛꠣꠎ ꠖꠥꠡꠝꠘꠞ ꠟꠉꠦ ꠟꠣꠠꠣꠁꠔ ꠛꠣꠞ ꠅꠁꠛꠣꠄ, ꠅꠃ ꠡꠝꠄ ꠖꠥꠁꠅ ꠌꠥꠋꠉꠣ ꠛꠣꠎꠣꠁꠀ ꠡꠋꠇꠦꠔ ꠖꠤꠛꠣꠄ। ꠔꠦꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠄ ꠈꠤꠀꠟ ꠇꠞꠤꠀ ꠖꠥꠡꠝꠘꠞ ꠀꠔ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠛꠣꠌꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","ꠔꠥꠝꠞꠣꠞ ꠈꠥꠡꠤ-ꠛꠣꠡꠤꠞ ꠅꠘꠥꠡ꠆ꠐꠣꠘꠅ, ꠔꠥꠝꠞꠣꠞ ꠢꠇꠟ ꠁꠖꠅ, ꠌꠣꠘ꠆ꠖꠞ ꠙꠄꠟꠣ ꠖꠤꠘ ꠎꠦꠛꠟꠣ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠛꠣ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠄ, ꠅꠃ ꠡꠝꠄꠅ ꠌꠥꠋꠉꠣ ꠛꠣꠎꠣꠁꠅ। ꠅꠃ ꠀꠅꠀꠎ ꠢꠥꠘꠟꠦ ꠔꠥꠝꠞꠣꠞ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠄ ꠌꠃꠈ ꠚꠤꠞꠣꠁꠛꠣ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ।” ");
INSERT INTO syls_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠎꠣꠔꠤ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠛꠣꠞꠘꠤꠞ ꠖꠥꠍꠞꠣ ꠛꠍꠞꠞ ꠖꠥꠍꠞꠣ ꠌꠣꠘ꠆ꠖꠞ ꠛꠤꠡ ꠔꠣꠞꠤꠈ ꠡꠣꠢꠣꠖꠔ ꠔꠣꠝ꠆ꠛꠥ ꠝꠣꠘꠤ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠃꠙꠞꠦ ꠕꠣꠇꠤ ꠇꠥꠖꠞꠔꠤ ꠝꠦꠊꠞ ꠈꠥꠐꠤ ꠢꠞꠤꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","ꠅꠃ ꠡꠝꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠍꠤꠘꠣꠁ ꠝꠞꠥꠜꠥꠝꠤ ꠕꠣꠇꠤ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣ। ꠢꠃ ꠝꠦꠊꠞ ꠈꠥꠐꠤ ꠚꠣꠞꠣꠘ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠀꠁꠀ ꠕꠤꠞ ꠘꠣ ꠅꠀ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠔꠣꠞꠣ ꠌꠟꠣꠔꠃ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","ꠝꠥꠍꠣ ꠘꠛꠤꠞ ꠝꠣꠎꠖꠤ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠙꠣꠁꠀ, ꠔꠣꠞꠣ ꠙꠄꠟꠣ ꠛꠣꠞ ꠅꠃ ꠍꠚꠞꠅ ꠞꠅꠀꠘꠣ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","ꠙꠄꠟꠣꠃ ꠄꠢꠥꠖꠣꠞ ꠙꠔꠣꠇꠣꠞ ꠔꠤꠘꠅ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠘꠣꠘꠣꠘ ꠚꠃꠎꠤ ꠖꠟꠦ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣ, ꠄꠞꠣꠞ ꠘꠦꠔꠣ ꠀꠍꠟꠣ ꠀꠝꠤꠘꠣꠖꠣꠛꠞ ꠙꠥꠀ ꠘꠣꠢꠤꠡ। ");
INSERT INTO syls_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","ꠄꠞꠣꠞ ꠝꠣꠎꠦ ꠁꠍꠣꠈꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠡꠞ ꠖꠣꠄꠁꠔ꠆ꠔ ꠀꠍꠤꠟ ꠍꠥꠉꠣꠞꠞ ꠙꠥꠀ ꠘꠕꠘꠦꠟꠞ ꠃꠙꠞꠦ, ");
INSERT INTO syls_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ꠀꠞ ꠍꠛꠥꠟꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠡꠞ ꠖꠣꠄꠁꠔ꠆ꠔ ꠀꠍꠤꠟ ꠢꠦꠟꠘꠞ ꠙꠥꠀ ꠁꠟꠤꠀꠛꠞ ꠃꠙꠞꠦ। ");
INSERT INTO syls_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","ꠛꠣꠖꠦ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠢꠇꠟꠔꠣ ꠈꠥꠟꠣ ꠅꠁꠟ, ꠔꠦꠃ ꠎꠣꠞꠍꠥꠘꠤ ꠀꠞ ꠝꠣꠞꠣꠞꠤꠀ ꠅꠇꠟꠦ ꠅꠈꠣꠘꠞ ꠢꠇꠟꠔꠣ ꠛꠁꠀ ꠟꠁꠀ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","ꠄꠞꠣꠞ ꠛꠣꠖꠦ ꠞꠥꠛꠦꠘꠞ ꠙꠔꠣꠇꠣꠞ ꠔꠤꠘꠅ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠚꠃꠎꠤ ꠖꠟꠦ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣ, ꠄꠞꠣꠞ ꠡꠞ꠆ꠖꠣꠞ ꠅꠁꠟꠣ ꠡꠣꠖꠤꠃꠞꠞ ꠙꠥꠀ ꠀꠟꠤꠍꠥꠞ। ");
INSERT INTO syls_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","ꠄꠞꠣꠞ ꠝꠣꠎꠦ ꠡꠤꠝꠤꠅꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠖꠣꠄꠁꠔ꠆ꠔ ꠀꠍꠤꠟ ꠡꠥꠞꠡꠣꠖꠣꠄꠅꠞ ꠙꠥꠀ ꠡꠣꠟꠥꠝꠤꠟꠞ ꠃꠙꠞꠦ, ");
INSERT INTO syls_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ꠀꠞ ꠍꠣꠖꠥ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠖꠣꠄꠁꠔ꠆ꠔ ꠀꠍꠤꠟ, ꠖꠥꠄꠟꠞ ꠙꠥꠀ ꠁꠟꠤꠀꠍꠚꠞ ꠃꠙꠞꠦ। ");
INSERT INTO syls_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","ꠄꠞꠣꠞ ꠛꠣꠖꠦ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠟꠁꠀ ꠇꠣꠢꠣꠔꠤ ꠅꠇꠟꠦ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣ। ꠇꠣꠢꠣꠔꠤ ꠅꠇꠟ ꠎꠣꠉꠣꠔ ꠉꠤꠀ ꠙꠃꠍꠣꠞ ꠀꠉꠦꠃ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞ ꠈꠣꠠꠣ ꠇꠞꠣꠞ ꠇꠕꠣ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","ꠄꠞꠛꠣꠖꠦ ꠀꠚꠞꠣꠁꠝ ꠙꠔꠣꠇꠣꠞ ꠔꠤꠘꠅ ꠚꠃꠎꠤ ꠖꠟꠞ ꠝꠣꠘꠡꠦ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣ, ꠄꠞꠣꠞ ꠡꠞ꠆ꠖꠣꠞ ꠅꠁꠟꠣ ꠀꠝꠤꠢꠥꠖꠞ ꠙꠥꠀ ꠀꠟꠤꠡꠣꠝꠣ। ");
INSERT INTO syls_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","ꠄꠞ ꠝꠣꠎꠦ ꠝꠣꠘꠡꠣ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠖꠣꠄꠁꠔ꠆ꠔ ꠀꠍꠤꠟ ꠚꠣꠔꠡꠥꠞꠞ ꠙꠥꠀ ꠉꠝꠟꠤꠄꠟꠞ ꠃꠙꠞꠦ। ");
INSERT INTO syls_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","ꠀꠞ ꠛꠤꠘ-ꠁꠀꠝꠤꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠖꠣꠄꠁꠔ꠆ꠔ ꠀꠍꠤꠟ ꠎꠤꠖꠣꠃꠘꠤꠞ ꠙꠥꠀ ꠀꠛꠤꠖꠣꠘꠞ ꠃꠙꠞꠦ। ");
INSERT INTO syls_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","ꠢꠇꠟ ꠢꠦꠡꠦ ꠞꠅꠀꠘꠣ ꠅꠁꠟꠣ ꠖꠣꠘ ꠙꠔꠣꠇꠣꠞ ꠔꠤꠘꠅ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠚꠃꠎꠤ ꠖꠟꠞ ꠝꠣꠘꠡꠦ, ꠔꠣꠞꠣꠞ ꠡꠞ꠆ꠖꠣꠞ ꠅꠁꠟꠣ ꠀꠝꠤꠡꠣꠖꠣꠞ ꠙꠥꠀ ꠀꠈꠤꠀꠎꠣꠞ। ꠄꠞꠣꠞ ꠍꠣꠝꠘꠞ ꠢꠇꠟ ꠚꠃꠎꠤ ꠖꠟꠞꠦ ꠙꠣꠞꠣ ꠖꠤꠀ ꠔꠣꠞꠣꠞ ꠈꠞꠦ ꠈꠞꠦ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","ꠄꠞ ꠝꠣꠎꠦ ꠀꠡꠤꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠖꠣꠄꠁꠔ꠆ꠔ ꠀꠍꠤꠟ ꠃꠇꠞꠣꠘꠞ ꠙꠥꠀ ꠚꠎꠤꠄꠟꠞ ꠃꠙꠞꠦ, ");
INSERT INTO syls_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ꠀꠞ ꠘꠙ꠆ꠔꠣꠟꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠖꠣꠄꠁꠔ꠆ꠔ ꠀꠍꠤꠟ ꠁꠘꠣꠘꠞ ꠙꠥꠀ ꠀꠢꠤꠞꠞ ꠃꠙꠞꠦ। ");
INSERT INTO syls_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","ꠅꠃ ꠟꠣꠈꠣꠘ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠘꠣꠘꠣꠘ ꠚꠃꠎꠤ ꠖꠟ ꠄꠇꠦ ꠄꠇꠦ ꠞꠅꠀꠘꠣ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","ꠄꠞꠛꠣꠖꠦ ꠝꠥꠍꠣꠄ ꠝꠣꠖꠤꠀꠘ ꠖꠦꠡꠞ ꠔꠣꠘ ꠢꠃꠞ ꠡꠥꠀꠁꠛ ꠘꠛꠤꠞ ꠙꠥꠀ ꠢꠛꠛꠞꠦ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠦ ꠀꠝꠞꠣꠞꠦ ꠎꠦ ꠖꠦꠡ ꠖꠤꠛꠣꠞ ꠅꠀꠖꠣ ꠇꠞꠍꠂꠘ, ꠀꠝꠞꠣ ꠢꠃ ꠖꠦꠡꠅ ꠎꠣꠁꠞꠣꠝꠉꠤ। ꠔꠦ ꠔꠥꠝꠤꠅ ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠀꠅ। ꠝꠣꠛꠥꠖꠦ ꠔ ꠅꠀꠖꠣ ꠇꠞꠍꠂꠘ, ꠔꠣꠁꠘ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠛꠃꠔ ꠝꠦꠢꠦꠞꠛꠣꠘꠤ ꠇꠞꠛꠣ। ꠅꠈꠘ ꠔꠥꠝꠤ ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠀꠁꠟꠦ ꠀꠝꠞꠣ ꠔꠥꠝꠣꠞꠦ ꠈꠥꠛ ꠝꠣꠄꠀ-ꠖꠄꠀ ꠇꠞꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","ꠢꠛꠛꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠘꠣ, ꠀꠝꠤ ꠎꠣꠁꠔꠣꠝ ꠘꠣꠄ। ꠀꠝꠤ ꠀꠝꠣꠞ ꠖꠦꠡꠅ ꠘꠤꠎꠞ ꠝꠣꠘꠡꠞ ꠉꠦꠍꠦ ꠚꠤꠞꠤꠀ ꠎꠣꠁꠝꠥꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","ꠅꠁꠟꠦ ꠝꠥꠍꠣꠄ ꠇꠁꠟꠣ, “ꠘꠣ, ꠘꠣ, ꠔꠥꠝꠤ ꠀꠝꠞꠣꠞꠦ ꠚꠣꠟꠣꠁꠀ ꠎꠣꠁꠅ ꠘꠣ। ꠔꠥꠝꠤꠃ ꠀꠝꠞꠣꠞ ꠙꠕ ꠖꠦꠈꠣꠅꠞꠣ ꠎꠘ। ꠝꠞꠥꠜꠥꠝꠤꠞ ꠝꠣꠎꠦ ꠇꠥꠘ ꠎꠣꠉꠣꠔ ꠀꠝꠞꠣꠞ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠣ ꠃꠌꠤꠔ, ꠁꠔꠣ ꠔ ꠔꠥꠝꠣꠞ ꠎꠣꠘꠣ ꠀꠍꠦ, ꠄꠞꠟꠣꠉꠤ ꠔꠥꠝꠤꠃ ꠅꠁꠟꠣꠄ ꠀꠝꠞꠣꠞ ꠌꠃꠈ। ");
INSERT INTO syls_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","ꠢꠥꠘꠅ, ꠔꠥꠝꠤ ꠎꠥꠖꠤ ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠀꠅ, ꠔꠦ ꠝꠣꠛꠥꠖꠦ ꠀꠝꠞꠣꠞꠦ ꠎꠔ ꠝꠦꠢꠦꠞꠛꠣꠘꠤ ꠇꠞꠣꠞ ꠅꠀꠖꠣ ꠇꠞꠍꠂꠘ, ꠔꠥꠝꠣꠞꠦꠅ ꠅꠔꠣꠞ ꠛꠣꠐ ꠖꠤꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","ꠅꠃ ꠟꠣꠈꠣꠘ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠝꠣꠛꠥꠖꠞ ꠙꠣꠠ ꠕꠣꠇꠤ ꠞꠅꠀꠘꠣ ꠅꠁꠀ ꠔꠤꠘ ꠖꠤꠘꠞ ꠙꠕ ꠀꠉꠥꠀꠁ ꠉꠦꠟꠣ। ꠀꠞ ꠎꠤꠞꠣꠁꠛꠣꠞ ꠟꠣꠉꠤ ꠄꠇꠈꠣꠘ ꠎꠣꠉꠣ ꠔꠥꠇꠣꠁꠀ ꠛꠣꠞ ꠇꠞꠣꠞ ꠈꠤꠀꠟꠦ, ꠝꠣꠛꠥꠖꠞ ꠢꠃ ꠙꠛꠤꠔ꠆ꠞ ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇ ꠔꠤꠘ ꠖꠤꠘ ꠗꠞꠤ ꠔꠣꠞꠣꠞ ꠀꠉꠦ ꠀꠉꠦ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","ꠇꠦꠝ꠆ꠙ ꠕꠣꠇꠤ ꠞꠅꠀꠘꠣ ꠅꠀꠞ ꠛꠣꠖꠦ, ꠖꠤꠘꠞ ꠛꠦꠟꠣ ꠝꠣꠛꠥꠖꠞ ꠉꠣꠁꠛꠤ ꠝꠦꠊꠞ ꠈꠥꠐꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠃꠙꠞꠦ ꠞꠁꠔ। ");
INSERT INTO syls_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","ꠅꠃ ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇ ꠞꠅꠀꠘꠣ ꠅꠁꠟꠦꠃ ꠝꠥꠍꠣꠄ ꠇꠁꠔꠣ, “ꠅ ꠝꠣꠛꠥꠖ, ꠌꠟꠃꠇ꠆ꠇꠣ। ꠔꠥꠝꠣꠞ ꠖꠥꠡꠝꠘ ꠅꠇꠟ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠍꠤꠔ꠆ꠞꠤ ꠎꠣꠃꠇ, ꠔꠥꠝꠣꠞꠦ ꠎꠦꠔꠣꠄ ꠁꠋꠡꠣꠁꠘ, ꠁꠔꠣ ꠔꠥꠝꠣꠞ ꠍꠣꠝꠘ ꠕꠣꠇꠤ ꠜꠣꠉꠃꠇ।” ");
INSERT INTO syls_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","ꠀꠞ ꠎꠦꠛꠟꠣ ꠅꠃ ꠡꠘ꠆ꠖꠥꠇ ꠕꠣꠝꠤꠎꠤꠔ, ꠔꠣꠁꠘ ꠇꠁꠔꠣ, “ꠅ ꠝꠣꠛꠥꠖ, ꠟꠣꠈ ꠟꠣꠈ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠉꠦꠍꠦ ꠔꠥꠝꠤ ꠚꠤꠞꠤꠀ ꠀꠅ।” ");
INSERT INTO syls_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠘꠤꠎꠞ ꠖꠥꠈ-ꠇꠡ꠆ꠐꠞ ꠟꠣꠉꠤ ꠛꠦꠎꠣꠞ ꠅꠁꠀ ꠛꠇꠣ-ꠎꠇꠣ ꠇꠞꠟꠣ। ꠄꠞꠟꠣꠉꠤ ꠝꠣꠛꠥꠖꠦ ꠔꠣꠞꠣꠞ ꠁꠔꠣ ꠢꠥꠘꠤꠀ ꠉꠥꠍꠣ ꠅꠁꠉꠦꠟꠣ। ꠔꠣꠁꠘ ꠉꠎꠛꠤ ꠀꠉꠥꠁꠘ ꠙꠣꠑꠣꠁꠟꠣ ꠀꠞ ꠅꠃ ꠀꠉꠥꠁꠘ ꠔꠣꠞꠣꠞ ꠝꠣꠎꠦ ꠎꠟꠤꠟ, ꠄꠔꠦ ꠇꠦꠝ꠆ꠙꠞ ꠇꠤꠘꠣꠞꠣꠞ ꠇꠤꠍꠥ ꠅꠋꠡ ꠀꠉꠥꠁꠘꠦ ꠎꠟꠤꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","ꠄꠞꠖꠣꠄ ꠔꠣꠞꠣ ꠝꠥꠍꠣ ꠘꠛꠤꠞ ꠉꠦꠍꠦ ꠉꠤꠀ ꠇꠣꠘ꠆ꠖꠣ-ꠇꠣꠐꠤ ꠟꠣꠉꠣꠁꠟꠣ, ꠔꠦꠃ ꠝꠥꠍꠣꠄ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠖꠥꠀ ꠇꠞꠣꠄ ꠀꠉꠥꠁꠘ ꠘꠤꠜꠤ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","ꠝꠣꠛꠥꠖꠞ ꠀꠉꠥꠁꠘ ꠔꠣꠞꠣꠞ ꠝꠣꠎꠦ ꠎꠟꠍꠤꠟ ꠇꠞꠤ, ꠅꠃ ꠎꠣꠉꠣꠞ ꠘꠣꠝ ꠅꠁꠉꠦꠟ ꠔꠣꠛꠦꠞꠣ। ");
INSERT INTO syls_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠉꠦ ꠅꠁꠘ꠆ꠘꠣꠁꠘ꠆ꠘ ꠎꠣꠔꠤꠞ ꠎꠦꠔꠣ ꠝꠣꠘꠥꠡ ꠀꠍꠟꠣ, ꠔꠣꠞꠣ ꠖꠥꠍꠞꠣ ꠎꠣꠔꠞ ꠝꠎꠣꠞ ꠇꠥꠘꠥ ꠈꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠙꠣꠉꠟ ꠛꠘꠤꠉꠦꠟꠣ, ꠀꠞ ꠄꠞꠣꠞ ꠖꠦꠈꠣ-ꠖꠦꠈꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦꠅ ꠢꠤꠞꠛꠣꠞ ꠇꠣꠘ꠆ꠖꠣ-ꠇꠣꠐꠤ ꠇꠞꠤ ꠇꠁꠟꠣ, “ꠁꠡ, ꠀꠝꠞꠣ ꠎꠥꠖꠤ ꠉꠥꠡ꠆ꠔ ꠈꠣꠁꠔꠣꠝ ꠙꠣꠞꠔꠣꠝ! ");
INSERT INTO syls_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","ꠝꠤꠡꠞꠅ ꠕꠣꠇꠔꠦ ꠔ ꠛꠤꠘꠣ ꠙꠄꠡꠣꠄ ꠝꠣꠉꠘꠣ ꠝꠣꠍ ꠈꠣꠁꠔꠣꠝ, ꠢꠘꠅ ꠔꠞꠝꠥꠎ, ꠙꠤꠀꠎ-ꠞꠡꠥꠘ, ꠇꠤꠞꠣ, ꠢꠣꠉ-ꠔꠞꠇꠣꠞꠤ ꠢꠇ꠆ꠇꠟꠔꠣ ꠈꠣꠁꠔꠣꠝ, ꠁꠔꠣ ꠅꠈꠘꠅ ꠝꠘꠅ ꠙꠠꠦꠞ। ");
INSERT INTO syls_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","ꠅꠁꠟꠦ ꠅꠈꠘ ꠀꠝꠞꠣꠞ ꠇꠁꠟꠎꠣ ꠢꠥꠇꠣꠁ ꠉꠦꠍꠦ। ꠁꠘꠅ ꠔ ꠈꠣꠟꠤ ꠝꠣꠘ꠆ꠘꠣ ꠍꠣꠠꠣ ꠈꠣꠅꠀꠞ ꠀꠞ ꠇꠥꠘ꠆ꠔꠣꠃ ꠘꠣꠁ।” ");
INSERT INTO syls_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","ꠅꠃ ꠝꠣꠘ꠆ꠘꠣ ꠖꠦꠈꠔꠦ ꠓꠥꠟꠣ ꠛꠣꠈꠞꠞ ꠟꠣꠈꠣꠘ, ꠄꠞ ꠞꠋ ꠅꠁꠟ ꠇꠤꠍꠝꠤꠍꠞ ꠟꠣꠈꠣꠘ। ");
INSERT INTO syls_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","ꠝꠣꠘꠡꠦ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠕꠣꠇꠤ ꠝꠣꠘ꠆ꠘꠣ ꠔꠥꠇꠣꠁꠀ ꠀꠘꠤꠀ ꠊꠣꠁꠟ-ꠍꠤꠀꠖꠤ ꠇꠥꠐꠤꠀ ꠛꠣ ꠢꠤꠟ-ꠙꠣꠐꠣꠖꠤ ꠍꠦꠌꠤꠀ ꠉꠥꠠꠣ ꠇꠞꠔꠣ। ꠛꠣꠖꠦ ꠁꠔꠣ ꠙꠣꠔꠤꠟꠅ ꠃꠘꠣ ꠖꠤꠀ ꠛꠣ ꠙꠤꠑꠣ ꠛꠣꠘꠣꠁꠀ ꠈꠣꠁꠔꠣ। ꠁꠔꠣ ꠈꠣꠁꠔꠦ ꠔꠦꠟꠖꠤ ꠛꠣꠘꠣꠁꠟ ꠙꠤꠑꠣꠞ ꠟꠣꠈꠣꠘ ꠝꠎꠣ। ");
INSERT INTO syls_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","ꠞꠣꠁꠔꠞ ꠛꠣꠟꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠇꠦꠝ꠆ꠙꠞ ꠀꠡꠦ-ꠙꠣꠡꠦ ꠈꠥꠀ ꠙꠠꠔ, ꠅꠃ ꠈꠥꠀꠞ ꠟꠉꠦ ꠅꠁꠀ ꠛꠦꠢꠦꠡ꠆ꠔꠤ ꠈꠣꠘꠤ ꠝꠣꠘ꠆ꠘꠣꠅ ꠙꠠꠔ। ");
INSERT INTO syls_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","ꠝꠥꠍꠣ ꠘꠛꠤꠞ ꠇꠣꠘꠅ ꠀꠁꠟ, ꠙꠞꠔꠦꠇ ꠊꠞꠞ ꠝꠣꠘꠡꠦ ꠎꠣꠞꠎꠤꠞ ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠉꠦꠍꠦ ꠃꠛꠣꠁꠀ ꠇꠣꠘ꠆ꠖꠤꠞꠣ। ꠄꠞꠖꠣꠄ ꠔꠣꠁꠘ ꠈꠥꠛ ꠛꠦꠎꠣꠞ ꠅꠁꠟꠣ, ꠀꠞ ꠝꠣꠛꠥꠖꠅ ꠉꠥꠍꠣꠄ ꠀꠉꠥꠁꠘ ꠅꠁꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","ꠔꠦꠃ ꠝꠥꠍꠣꠄ ꠝꠣꠛꠥꠖꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠇꠦꠘꠦ ꠔꠥꠝꠣꠞ ꠁ ꠉꠥꠟꠣꠝꠞꠦ ꠁꠟꠣ ꠛꠤꠙꠖꠅ ꠚꠣꠟꠣꠁꠟꠣꠄ? ꠀꠝꠤ ꠇꠤꠔꠣ ꠖꠥꠡ ꠇꠞꠟꠣꠝ, ꠎꠦ ꠇꠣꠞꠘꠦ ꠅꠔꠣ ꠝꠣꠘꠡꠞ ꠜꠣꠞ ꠀꠝꠣꠞ ꠇꠣꠘ꠆ꠖꠅ ꠖꠤꠟꠣꠄ? ");
INSERT INTO syls_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","ꠀꠝꠤ ꠇꠥꠘꠥ ꠔꠣꠞꠣꠞꠦ ꠙꠦꠐꠅ ꠟꠁꠍꠤ ꠘꠤ, ꠛꠣ ꠔꠣꠞꠣ ꠀꠝꠣꠞ ꠙꠦꠐ ꠕꠣꠇꠤ ꠎꠘꠝꠤꠍꠦ ꠘꠤ? ꠔꠥꠝꠤ ꠔꠣꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠁꠘ꠆ꠔꠞ ꠉꠦꠍꠦ ꠎꠦ ꠖꠦꠡ ꠖꠤꠛꠣꠞ ꠅꠀꠖꠣ ꠇꠞꠍꠤꠟꠣꠄ, ꠔꠣꠞꠣꠞꠦ ꠢꠘꠅ ꠘꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠀꠝꠣꠞꠦ ꠇꠦꠘꠦ ꠔꠣꠞꠣꠞ ꠙꠣꠟꠇ-ꠛꠣꠚꠞ ꠟꠣꠈꠣꠘ ꠛꠣꠘꠣꠁꠍ, ꠀꠞ ꠔꠣꠞꠣꠞꠦ ꠇꠥꠟꠅ ꠇꠞꠤ ꠘꠤꠛꠣꠞ ꠇꠕꠣ ꠇꠦꠘꠦ ꠇꠁꠞꠣꠄ? ");
INSERT INTO syls_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","ꠁꠔꠣ ꠝꠣꠘꠡꠞ ꠈꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠀꠝꠤ ꠅꠈꠘ ꠉꠥꠡ꠆ꠔ ꠇꠥꠀꠁ ꠙꠣꠁꠔꠣꠝ? ꠔꠣꠞꠣ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠈꠣꠟꠤ ꠉꠥꠡ꠆ꠔ ꠉꠥꠡ꠆ꠔ ꠇꠁꠀ ꠌꠤꠟ꠆ꠟꠣꠁꠞꠣ। ");
INSERT INTO syls_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","ꠔꠣꠞꠣꠞ ꠎꠤꠝ꠆ꠝꠣ ꠘꠦꠅꠀ ꠛꠠ ꠝꠡꠇꠤꠟ, ꠀꠝꠣꠞ ꠄꠇꠣꠞ ꠙꠇ꠆ꠇꠦ ꠁ ꠎꠤꠝ꠆ꠝꠣ ꠘꠦꠅꠀ ꠡꠝ꠆ꠛꠛ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","ꠔꠥꠝꠤ ꠎꠥꠖꠤ ꠀꠝꠣꠞꠦ ꠁ ꠝꠥꠡꠇꠤꠟꠅ ꠚꠣꠟꠣꠅ, ꠔꠦ ꠔꠥꠝꠣꠞ ꠖꠥꠀꠁ ꠖꠤꠀ ꠇꠁꠀꠞ, ꠅꠈꠘꠃ ꠀꠝꠣꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠣꠅ। ꠀꠞ ꠇꠁꠞꠣꠝ, ꠀꠝꠤ ꠎꠥꠖꠤ ꠔꠥꠝꠣꠞ ꠞꠢꠝꠔꠞ ꠔꠟꠦ ꠕꠣꠇꠤ, ꠔꠦ ꠘꠤꠎꠞ ꠌꠃꠈꠦ ꠘꠤꠎꠞ ꠛꠦꠢꠣꠟ꠆ꠟꠔꠤ ꠖꠡꠣ ꠀꠝꠣꠞꠦ ꠖꠦꠈꠣꠁꠅ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","ꠔꠦꠃ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠎꠦ ꠔꠥꠝꠤ ꠎꠣꠞꠣꠞꠦ ꠝꠥꠞꠛ꠆ꠛꠤ ꠘꠦꠔꠣ ꠀꠞ ꠁꠎ꠆ꠎꠔꠤ ꠢꠤꠡꠣꠛꠦ ꠌꠤꠘꠅ, ꠄꠞꠣꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠡꠔ꠆ꠔꠁꠞ ꠎꠘ ꠝꠥꠞꠛ꠆ꠛꠤ ꠘꠦꠔꠣꠞꠦ ꠟꠁꠀ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠀꠅ। ꠔꠥꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠇꠅ, ꠔꠣꠞꠣ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠉꠦꠍꠦ ꠀꠁꠀ ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠃꠛꠣꠁꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","ꠀꠝꠤ ꠢꠘꠅ ꠟꠣꠝꠤꠀ ꠀꠁꠀ ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠝꠥ। ꠔꠥꠝꠣꠞ ꠝꠣꠎꠦ ꠀꠟ꠆ꠟꠣꠞ ꠎꠦ ꠞꠥꠢꠥ ꠀꠍꠂꠘ, ꠅꠃ ꠞꠥꠢꠥ ꠀꠝꠤ ꠔꠣꠞꠣꠞ ꠃꠙꠞꠦꠅ ꠖꠣꠘ ꠇꠞꠝꠥ। ꠝꠣꠘꠡꠞ ꠎꠤꠝ꠆ꠝꠣꠖꠣꠞꠤ ꠛꠁꠀ ꠘꠤꠔꠦ ꠔꠣꠞꠣꠅ ꠔꠥꠝꠣꠞꠦ ꠡꠣꠁꠎ꠆ꠎ ꠇꠞꠛꠣ। ꠔꠦꠃ ꠔꠥꠝꠣꠞ ꠄꠇꠟꠣ ꠛꠅꠀ ꠟꠣꠉꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","ꠀꠞ ꠔꠥꠝꠤ ꠅꠔꠣ ꠝꠣꠘꠡꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠔꠣꠞꠣ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠅꠁꠀ ꠇꠣꠁꠟꠇꠥꠞ ꠟꠣꠉꠤ ꠎꠥꠁꠔ ꠞꠁꠔꠣ, ꠇꠣꠁꠟꠃ ꠔꠣꠞꠣ ꠈꠣꠘꠤꠞ ꠉꠥꠡ꠆ꠔ ꠙꠣꠁꠛꠣ। ꠔꠣꠞꠣ ꠔ ꠉꠥꠡ꠆ꠔꠞ ꠟꠣꠉꠤ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠇꠣꠘ꠆ꠖꠣ-ꠇꠣꠐꠤ ꠇꠞꠤꠀ ꠇꠁꠍꠤꠟ, ꠝꠤꠡꠞꠅ ꠕꠣꠇꠔꠦꠃ ꠔꠣꠞꠣ ꠀꠞꠣꠝꠦ ꠀꠍꠤꠟ। ꠔꠦ ꠇꠣꠁꠟ ꠝꠣꠛꠥꠖꠦ ꠔꠣꠞꠣꠞꠦ ꠉꠥꠡ꠆ꠔ ꠖꠤꠛꠣ ꠀꠞ ꠔꠣꠞꠣ ꠈꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","ꠁ ꠉꠥꠡ꠆ꠔ ꠈꠣꠟꠤ ꠄꠇꠖꠤꠘ-ꠖꠥꠁꠖꠤꠘ, ꠙꠣꠌꠖꠤꠘ-ꠖꠡꠖꠤꠘ, ꠛꠣ ꠛꠤꠡꠖꠤꠘ ꠘꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ꠙꠥꠞꠣ ꠄꠇ ꠝꠣꠡ ꠜꠞꠤ ꠈꠣꠁꠛꠣ। ꠈꠣꠁꠔꠦ ꠈꠣꠁꠔꠦ ꠔꠣꠞꠣꠞ ꠘꠣꠇꠦꠖꠤ ꠛꠣꠞ ꠅꠁꠛ, ꠛꠣꠖꠦ ꠀꠞ ꠎꠣꠘꠦ ꠇꠥꠟꠣꠁꠔ ꠘꠣꠄ। ꠀꠝꠤ ꠁꠟꠣ ꠊꠐꠣꠁꠝꠥ, ꠇꠣꠞꠘ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠎꠦ ꠝꠣꠛꠥꠖ ꠛꠡꠔ ꠇꠞꠂꠘ, ꠅꠃ ꠝꠣꠛꠥꠖꠞꠦ ꠔꠥꠝꠞꠣ ꠝꠣꠘꠍ ꠘꠣ। ꠔꠣꠘ ꠍꠣꠝꠘꠦ ꠇꠣꠘ꠆ꠖꠣ-ꠇꠣꠐꠤ ꠇꠞꠤꠀ ꠇꠁꠍ, ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠢꠞꠤꠀ ꠀꠅꠀ ꠛꠥꠟꠦ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠑꠤꠇ ꠅꠁꠍꠦ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠝꠥꠍꠣꠄ ꠇꠁꠟꠣ, “ꠈꠣꠟꠤ ꠎꠥꠖ꠆ꠖ ꠇꠞꠣꠞ ꠎꠥꠇꠣꠃ ꠔ ꠍꠄ ꠟꠣꠈ ꠝꠣꠘꠥꠡ ꠀꠝꠣꠞ ꠟꠉꠦ ꠀꠍꠂꠘ, ꠀꠞ ꠔꠥꠝꠤ ꠇꠁꠞꠣꠄ ꠙꠥꠞꠣ ꠄꠇ ꠝꠣꠡ ꠜꠞꠤ ꠔꠣꠞꠣꠞꠦ ꠉꠥꠡ꠆ꠔ ꠈꠣꠛꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","ꠔꠦ ꠢꠇ꠆ꠇꠟ ꠉꠞꠥ-ꠝꠦꠠꠣ ꠎꠛ ꠇꠞꠟꠦꠅ ꠔ ꠅꠔ ꠝꠣꠘꠡꠞ ꠚꠥꠁꠔ ꠘꠣꠄ, ꠀꠞ ꠖꠞꠤꠀꠞ ꠢꠇꠟ ꠝꠣꠍ ꠝꠣꠞꠤꠀ ꠀꠘꠤꠟ꠆ꠟꠦꠅ ꠇꠥꠟꠣꠁꠔ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","ꠝꠣꠛꠥꠖꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠅ ꠝꠥꠍꠣ, ꠝꠣꠛꠥꠖꠞ ꠇꠥꠖꠞꠔꠤ ꠛꠟ ꠅꠔ ꠇꠝꠎꠥꠞ ꠘꠤ? ꠔꠦ ꠔꠥꠝꠤ ꠖꠦꠈꠛꠣꠄ, ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠎꠦꠔꠣ ꠇꠁꠍꠤ, ꠁꠔꠣ ꠢꠣꠍꠣ, ꠘꠣ ꠝꠤꠍꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","ꠔꠦꠃ ꠝꠥꠍꠣ ꠛꠣꠞꠦ ꠉꠦꠟꠣ, ꠉꠤꠀ ꠅꠔꠣ ꠝꠣꠘꠡꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠎꠣꠘꠣꠁꠟꠣ। ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠡꠔ꠆ꠔꠁꠞ ꠎꠘ ꠝꠥꠞꠛ꠆ꠛꠤ ꠘꠦꠔꠣꠞꠦ ꠀꠘꠤꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠈꠣꠠꠣ ꠇꠞꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","ꠅꠃ ꠡꠝꠄ ꠉꠣꠁꠛꠤ ꠝꠦꠊꠞ ꠌꠣꠈꠣꠔ ꠅꠁꠀ ꠝꠣꠛꠥꠖ ꠟꠣꠝꠤꠀ ꠀꠁꠟꠣ, ꠀꠁꠀ ꠝꠥꠍꠣ ꠘꠛꠤꠞ ꠟꠉꠦ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠟꠣ। ꠝꠥꠍꠣꠞ ꠃꠙꠞꠦ ꠀꠟ꠆ꠟꠣꠁ ꠎꠦ ꠞꠥꠢꠥ ꠀꠍꠟꠣ, ꠝꠣꠛꠥꠖꠦ ꠅꠃ ꠡꠔ꠆ꠔꠁꠞ ꠎꠘ ꠘꠦꠔꠣꠞ ꠃꠙꠞꠦꠅ ꠅꠃ ꠞꠥꠢꠥꠞ ꠇꠤꠍꠥ ꠅꠋꠡ ꠖꠤꠟꠣ। ꠅꠃ ꠞꠥꠢꠥ ꠔꠣꠞꠣꠞꠦ ꠖꠣꠘ ꠇꠞꠣꠞ ꠛꠣꠖꠦ, ꠔꠣꠞꠣ ꠇꠤꠍꠥ ꠡꠝꠄ ꠍꠥꠚꠤ-ꠖꠞꠛꠦꠡꠞ ꠄꠡꠇꠤ ꠜꠣꠛ ꠖꠦꠈꠣꠁꠟꠣ, ꠅꠁꠟꠦ ꠛꠣꠖꠦ ꠀꠞ ꠁꠟꠣ ꠅꠁꠍꠦ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","ꠀꠞ ꠅꠃ ꠡꠔ꠆ꠔꠁꠞ ꠎꠘ ꠝꠥꠞꠛ꠆ꠛꠤ ꠘꠦꠔꠣꠞ ꠝꠣꠎꠞ ꠖꠥꠁꠎꠘ ꠝꠥꠞꠛ꠆ꠛꠤ ꠇꠦꠝ꠆ꠙꠞ ꠜꠤꠔꠞꠦ ꠞꠁꠉꠦꠟꠣ, ꠄꠞꠣꠞ ꠘꠣꠝ ꠁꠟꠖꠣꠖ ꠀꠞ ꠝꠤꠖꠣꠖ, ꠔꠣꠞꠣ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠉꠦꠍꠦ ꠉꠦꠍꠟꠣ ꠘꠣ। ꠔꠦꠛꠃ ꠀꠟ꠆ꠟꠣꠁ ꠅꠃ ꠞꠥꠢꠥ ꠔꠣꠞꠣꠅ ꠙꠣꠁꠟꠣ, ꠙꠣꠁꠀ ꠔꠣꠞꠣ ꠇꠦꠝ꠆ꠙꠞ ꠜꠤꠔꠞꠦ ꠞꠁꠀ ꠍꠥꠚꠤ-ꠖꠞꠛꠦꠡꠞ ꠄꠡꠇꠤ ꠜꠣꠛ ꠖꠦꠈꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","ꠁꠔꠣ ꠖꠦꠈꠤꠀ ꠄꠇ ꠎꠥꠀꠘ ꠛꠦꠐꠣꠄ ꠖꠃꠠꠣꠁꠀ ꠉꠤꠀ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠢꠥꠎꠥꠞ, ꠢꠥꠘꠍꠂꠘ ꠘꠤ? ꠁꠟꠖꠣꠖ ꠀꠞ ꠝꠤꠖꠣꠖ ꠘꠣꠝꠞ ꠖꠥꠁꠅ ꠝꠥꠞꠛ꠆ꠛꠤꠄ ꠇꠦꠝ꠆ꠙꠞ ꠜꠤꠔꠞꠦ ꠍꠥꠚꠤ-ꠖꠞꠛꠦꠡꠞ ꠄꠡꠇꠤ ꠜꠣꠛ ꠖꠦꠈꠣꠁꠞꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","ꠅꠃ ꠡꠝꠄ ꠘꠥꠘꠞ ꠙꠥꠀ ꠁꠃꠍꠣꠄ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠅ ꠀꠝꠣꠞ ꠝꠣꠟꠤꠇ, ꠀꠙꠘꠦ ꠄꠞꠣꠞꠦ ꠘꠤꠡꠦꠗ ꠖꠦꠃꠇ꠆ꠇꠣ।” ꠅꠃ ꠁꠃꠍꠣ ꠎꠥꠀꠘꠇꠤꠞ ꠡꠥꠞꠥ ꠕꠣꠇꠤꠃ ꠝꠥꠍꠣ ꠘꠛꠤꠞ ꠈꠣꠍ ꠈꠣꠖꠤꠝ ꠀꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","ꠝꠥꠍꠣꠄ ꠄꠘꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠝꠣꠘ-ꠡꠝ꠆ꠝꠣꠘꠃ ꠔꠥꠝꠣꠞ ꠉꠦꠍꠦ ꠛꠠ ꠅꠁꠉꠦꠟ ꠘꠤ? ꠀꠝꠤ ꠌꠣꠁꠞꠣꠝ, ꠝꠣꠛꠥꠖꠞ ꠢꠇꠟ ꠛꠘ꠆ꠖꠣꠄꠃ ꠍꠥꠚꠤ-ꠖꠞꠛꠦꠡꠤ ꠙꠣꠃꠇ꠆ꠇꠣ, ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠀꠙꠘ ꠞꠥꠢꠥ ꠔꠣꠞꠣꠞꠦ ꠖꠣꠘ ꠇꠞꠃꠇ꠆ꠇꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","ꠄꠞꠛꠣꠖꠦ ꠝꠥꠍꠣ ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠥꠞꠛ꠆ꠛꠤ ꠘꠦꠔꠣ ꠅꠇꠟ ꠇꠦꠝ꠆ꠙꠅ ꠚꠤꠞꠤꠀ ꠉꠦꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝꠦ ꠛꠠ ꠄꠇ ꠔꠥꠚꠣꠘ ꠀꠁꠟ। ꠅꠃ ꠔꠥꠚꠣꠘꠦ ꠖꠞꠤꠀꠞ ꠙꠣꠞ ꠕꠣꠇꠤ ꠇꠥꠄꠟ ꠙꠣꠈꠤ ꠑꠦꠟꠤꠀ ꠀꠘꠤꠀ ꠇꠦꠝ꠆ꠙꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣ ꠜꠞꠣꠁ ꠖꠤꠟ। ꠄꠇꠖꠤꠘꠞ ꠙꠕ ꠙꠞꠤꠝꠣꠘ ꠎꠣꠉꠣ ꠙꠣꠈꠤꠄ ꠜꠞꠤꠉꠦꠟ। ꠙꠣꠈꠤꠞ ꠙꠣꠟ ꠝꠣꠐꠤ ꠕꠣꠇꠤ ꠖꠥꠁ ꠀꠔ ꠃꠌꠣ ꠔꠥꠛ ꠅꠁꠀ, ꠉꠤꠍ ꠟꠣꠉꠤꠀ ꠙꠠꠤ ꠞꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","ꠔꠦꠃ ꠢꠃ ꠖꠤꠘ, ꠢꠃ ꠞꠣꠁꠔ, ꠀꠞ ꠛꠣꠖꠞ ꠀꠡ꠆ꠔꠣ ꠖꠤꠘ ꠝꠣꠘꠡꠦ ꠛꠣꠞꠦ ꠉꠤꠀ ꠇꠥꠄꠟ ꠙꠣꠈꠤꠘ ꠔꠥꠛꠣꠁꠀ ꠀꠘꠟꠣ। ꠔꠣꠞꠣ ꠙꠞꠔꠦꠇꠦ ꠇꠝꠙꠇ꠆ꠇꠦ ꠙꠁꠘ꠆ꠌꠣꠡ ꠝꠘ ꠇꠞꠤ ꠙꠣꠈꠤ ꠖꠟꠣ ꠇꠞꠟ। ꠙꠣꠈꠤꠘ ꠖꠟꠣ ꠇꠞꠤꠀ ꠇꠦꠝ꠆ꠙꠞ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠔꠣꠞꠣ ꠛꠅꠀꠁꠀ ꠕꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","ꠅꠁꠟꠦ ꠙꠣꠈꠤꠞ ꠉꠥꠡ꠆ꠔ ꠔꠣꠞꠣꠞ ꠝꠥꠈꠅ ꠢꠣꠞꠣꠘꠤꠞ ꠟꠉꠦ ꠟꠉꠦꠃ ꠝꠣꠛꠥꠖ ꠉꠥꠍꠣꠄ ꠀꠉꠥꠁꠘ ꠅꠁꠉꠦꠟꠣ। ꠉꠥꠍꠣ ꠇꠞꠤꠀ ꠔꠣꠁꠘ ꠛꠦꠎꠥꠁꠔꠣ ꠉꠎꠛꠤ ꠛꠦꠝꠣꠞ ꠓꠣꠟꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","ꠄꠞꠟꠣꠉꠤ ꠁ ꠎꠣꠉꠣꠞ ꠘꠣꠝ ꠖꠦꠅꠀ ꠅꠁꠟ ꠇꠤꠛꠞꠥꠔ-ꠢꠥꠔꠣꠛꠣ, ꠝꠣꠘꠤ ꠟꠣꠟꠌꠤ ꠅꠇꠟꠞ ꠇꠄꠛꠞ, ꠇꠣꠞꠘ ꠅꠃ ꠟꠣꠟꠌꠤ ꠅꠇꠟꠞꠦ ꠝꠣꠘꠡꠦ ꠅꠘꠅ ꠇꠄꠛꠞ ꠖꠤꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","ꠄꠞꠛꠣꠖꠦ ꠔꠣꠞꠣ ꠇꠤꠛꠞꠥꠔ-ꠢꠥꠔꠣꠛꠣ ꠍꠣꠠꠤꠀ ꠉꠦꠟꠣꠉꠤ, ꠉꠤꠀ ꠢꠣꠎꠤꠞꠥꠔ ꠘꠣꠝꠞ ꠎꠣꠉꠣꠔ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","ꠢꠎꠞꠔ ꠝꠥꠍꠣꠄ ꠁꠕꠤꠅꠙꠤꠀ ꠖꠦꠡꠞ ꠄꠇꠎꠘ ꠛꠦꠐꠤꠞꠦ ꠛꠤꠀ ꠇꠞꠍꠟꠣ। ꠄꠘꠞꠦ ꠛꠤꠀ ꠇꠞꠣꠄ ꠝꠥꠍꠣꠞ ꠛꠁꠘ ꠝꠞꠤꠅꠝ ꠀꠞ ꠜꠣꠁ ꠢꠣꠞꠥꠘꠦ ꠝꠥꠍꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠝꠣꠔ-ꠇꠕꠣ ꠝꠣꠔꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","ꠔꠣꠞꠣ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠦ ꠈꠣꠟꠤ ꠝꠥꠍꠣꠞ ꠝꠣꠞꠚꠔꠦ ꠝꠣꠔꠂꠘ ꠘꠤ? ꠀꠝꠞꠣꠞ ꠃꠍꠤꠟ꠆ꠟꠣꠄꠅ ꠝꠣꠔꠂꠘ ꠘꠣ ꠘꠤ?” ꠁꠈꠣꠘ ꠝꠣꠛꠥꠖꠦ ꠢꠥꠘꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","ꠀꠍꠟꠦ ꠝꠥꠍꠣ ꠘꠛꠤ ꠔ ꠀꠍꠟꠣ ꠄꠇꠎꠘ ꠉꠞꠤꠝꠣ ꠍꠣꠠꠣ ꠝꠣꠘꠥꠡ। ꠎꠉꠔꠞ ꠝꠣꠎꠦ ꠁꠟꠣ ꠉꠞꠤꠝꠣ ꠍꠣꠠꠣ ꠀꠞ ꠇꠥꠘꠥ ꠝꠣꠘꠥꠡ ꠀꠍꠤꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","ꠝꠥꠍꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠢꠣꠞꠥꠘ ꠀꠞ ꠝꠞꠤꠅꠝꠞ ꠝꠣꠔ-ꠇꠕꠣ ꠢꠥꠘꠤꠀꠃ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ, ꠢꠣꠞꠥꠘ ꠀꠞ ꠝꠞꠤꠅꠝꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠔꠤꠘꠅꠎꠘ ꠛꠣꠞ ꠅꠁꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠉꠦꠍꠦ ꠀꠅ।” ꠔꠦꠃ ꠄꠞꠣ ꠔꠤꠘꠅꠎꠘ ꠅꠘꠅ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","ꠅꠃ ꠡꠝꠄ ꠝꠣꠛꠥꠖꠦꠅ ꠇꠥꠖꠞꠔꠤ ꠝꠦꠊꠞ ꠌꠣꠈꠣꠔ ꠅꠁꠀ ꠟꠣꠝꠤꠀ ꠀꠁꠟꠣ, ꠀꠁꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠢꠣꠞꠥꠘ ꠀꠞ ꠝꠞꠤꠅꠝꠞꠦ ꠒꠣꠇꠤꠟꠣ। ꠔꠣꠞꠣ ꠀꠉꠥꠀꠁꠀ ꠀꠁꠟꠦ ");
INSERT INTO syls_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ꠝꠣꠛꠥꠖꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠇꠕꠣ ꠢꠥꠘꠅ। ꠔꠥꠝꠞꠣꠞ ꠝꠣꠎꠦ ꠇꠥꠘꠥ ꠙꠤꠞ-ꠖꠞꠛꠦꠡ ꠕꠣꠇꠟꠦ, ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠖꠞꠡꠘꠞ ꠝꠣꠎꠖꠤ ꠀꠝꠣꠞ ꠘꠤꠎꠞꠦ ꠔꠣꠞ ꠉꠦꠍꠦ ꠎꠣꠁꠞ ꠇꠞꠤ ꠀꠞ ꠈꠥꠀꠛꠦ ꠔꠣꠞ ꠟꠉꠦ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠤ। ");
INSERT INTO syls_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","ꠅꠁꠟꠦ ꠀꠝꠣꠞ ꠉꠥꠟꠣꠝ ꠝꠥꠍꠣꠞ ꠟꠉꠦ ꠁꠟꠣ ꠇꠞꠤ ꠘꠣ। ꠢꠦ ꠀꠝꠣꠞ ꠀꠡ꠆ꠔꠣ ꠡꠋꠡꠣꠞꠞ ꠢꠇꠟ ꠕꠣꠇꠤ ꠛꠤꠡ꠆ꠛꠣꠡꠤ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","ꠀꠝꠤ ꠔꠣꠞ ꠟꠉꠦ ꠍꠣꠝꠘꠣ-ꠍꠣꠝꠘꠤ ꠅꠁꠀ ꠈꠥꠟꠣ-ꠈꠥꠟꠤ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠤ, ꠇꠥꠘꠥꠔꠣ ꠛꠣꠔꠥꠘꠤ ꠞꠣꠈꠤ ꠘꠣ। ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠎꠦ ꠍꠥꠞꠔꠦ ꠔꠣꠞꠦ ꠖꠤꠖꠣꠞ ꠖꠦꠁ, ꠢꠦ ꠀꠝꠣꠞꠦ ꠅꠟꠣ ꠖꠦꠈꠦ। ꠄꠞꠛꠣꠖꠦꠅ ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠉꠥꠟꠣꠝ ꠝꠥꠍꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠝꠣꠔꠤꠔꠦ ꠃꠛꠣꠁꠟꠣꠄ ꠘꠣ ꠘꠤ?” ");
INSERT INTO syls_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","ꠄꠞꠟꠣꠉꠤ ꠢꠣꠞꠥꠘ ꠀꠞ ꠝꠞꠤꠅꠝꠞ ꠃꠙꠞꠦ ꠝꠣꠛꠥꠖ ꠉꠥꠍꠣꠄ ꠀꠉꠥꠁꠘ ꠅꠁꠉꠦꠟꠣ, ꠅꠁꠀ ꠔꠣꠁꠘ ꠢꠞꠤꠀ ꠉꠦꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","ꠝꠦꠊꠞ ꠌꠣꠈꠣ ꠎꠦꠛꠟꠣ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥ ꠕꠣꠇꠤ ꠃꠙꠞꠦ ꠃꠑꠤꠉꠦꠟ, ꠅꠃ ꠡꠝꠄ ꠖꠦꠈꠣ ꠉꠦꠟ, ꠝꠞꠤꠅꠝꠞ ꠀꠡ꠆ꠔꠣ ꠉꠔꠞꠅ ꠙꠌꠣ-ꠇꠥꠡ꠆ꠑ ꠛꠦꠝꠣꠞꠦ ꠖꠥꠗꠞ ꠟꠣꠈꠣꠘ ꠗꠟꠣ ꠅꠁꠉꠦꠍꠦ। ꠢꠣꠞꠥꠘꠦ ꠝꠞꠤꠅꠝꠞ ꠛꠣꠄ ꠌꠣꠁꠀ ꠅꠃ ꠢꠣꠟꠔ ꠖꠦꠈꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ꠖꠦꠈꠤꠀ ꠔꠣꠁꠘ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠅ ꠀꠝꠣꠞ ꠝꠣꠟꠤꠇ, ꠀꠝꠞꠣ ꠘꠣ ꠛꠥꠎꠤꠀ ꠎꠦ ꠉꠥꠘꠣ ꠇꠞꠤꠟꠤꠍꠤ, ꠁ ꠇꠍꠥꠞꠤ ꠈꠣꠘ ꠔꠥꠝꠤ ꠝꠘꠅ ꠞꠣꠈꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","ꠝꠣʼꠞ ꠙꠦꠐꠅ ꠕꠣꠇꠤ ꠎꠘꠝ ꠅꠀꠞ ꠛꠣꠟꠣ ꠎꠦ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠞ ꠅꠞ꠆ꠗꠦꠇ ꠡꠞꠤꠟ ꠇ꠆ꠇꠄ ꠅꠁꠉꠦꠍꠦ, ꠔꠥꠝꠤ ꠝꠞꠤꠅꠝꠞꠦ ꠁꠟꠣ ꠛꠣꠘꠣꠁꠅ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","ꠔꠦꠃ ꠝꠥꠍꠣꠄ ꠇꠣꠘ꠆ꠖꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠀꠞꠎ ꠇꠞꠟꠣ, “ꠅ ꠀꠟ꠆ꠟꠣ, ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠛꠁꠘꠞ ꠛꠦꠝꠣꠞ ꠡꠤꠚꠣ ꠇꠞꠤ ꠖꠦꠅ।” ");
INSERT INTO syls_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠣꠁꠞ ꠛꠣꠚꠦ ꠎꠥꠖꠤ ꠔꠣꠁꠞ ꠝꠥꠈꠅ ꠈꠣꠟꠤ ꠍꠦꠚ ꠚꠣꠟꠣꠁꠔꠣ, ꠔꠦ ꠡꠞꠝꠣꠁꠀ ꠔꠣꠁ ꠡꠣꠔ ꠖꠤꠘ ꠊꠞꠞ ꠛꠣꠞꠦ ꠞꠁꠟ ꠅꠘꠦ ꠘꠣ ꠘꠤ? ꠅꠟꠣ ꠡꠣꠔꠖꠤꠘ ꠔꠣꠁꠞꠦ ꠇꠦꠝ꠆ꠙꠞ ꠛꠣꠞꠦ ꠀꠟꠉ ꠞꠣꠈꠅ, ꠛꠣꠖꠦ ꠜꠤꠔꠞꠦ ꠀꠘꠛꠣꠄ ꠘꠦ।” ");
INSERT INTO syls_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","ꠄꠞꠟꠣꠉꠤ ꠝꠞꠤꠅꠝꠞꠦ ꠡꠣꠔ ꠖꠤꠘ ꠇꠦꠝ꠆ꠙꠞ ꠛꠣꠞꠦ ꠢꠞꠣꠁ ꠕꠁꠟꠣ। ꠄꠘꠞꠦ ꠜꠤꠔꠞꠦ ꠀꠘꠣꠞ ꠀꠉ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠝꠣꠘꠡꠞ ꠍꠚꠞꠅ ꠛꠣꠞꠘꠤ ꠛꠘ꠆ꠖ ꠞꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","ꠛꠣꠖꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠅꠇꠟ ꠢꠣꠎꠤꠞꠥꠔ ꠍꠣꠠꠤꠀ ꠚꠣꠞꠣꠘ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠉꠤꠀ ꠇꠦꠝ꠆ꠙ ꠉꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠀꠝꠤ ꠎꠦ ꠇꠦꠘꠣꠘ ꠖꠦꠡ ꠖꠤꠔꠣꠝ ꠌꠣꠁꠞꠣꠝ, ꠅꠃ ꠖꠦꠡꠞ ꠢꠣꠟ-ꠢꠇꠤꠇꠔ ꠖꠦꠈꠤꠀ ꠀꠅꠀꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠤ ꠛꠣꠞꠅ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠣꠇꠤ ꠛꠣꠞꠅ ꠎꠘ ꠡꠞ꠆ꠖꠣꠞ ꠙꠣꠑꠣꠅ।” ");
INSERT INTO syls_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠙꠣꠁꠀ ꠝꠥꠍꠣꠄ ꠅꠟꠣꠃ ꠇꠞꠟꠣ। ꠔꠣꠁꠘ ꠚꠣꠞꠣꠘ ꠝꠞꠥꠜꠥꠝꠤ ꠕꠣꠇꠤ ꠎꠦꠞꠣꠞꠦ ꠙꠣꠑꠣꠁꠟꠣ, ꠄꠞꠣ ꠢꠇꠟꠃ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠡꠞ꠆ꠖꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","ꠄꠞꠣ ꠅꠁꠟꠣ: ꠞꠥꠛꠦꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠎꠣꠇꠥꠞꠞ ꠙꠥꠀ ꠡꠣꠝ꠆ꠝꠥꠀ, ");
INSERT INTO syls_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","ꠡꠤꠝꠤꠅꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠈꠥꠞꠤꠞ ꠙꠥꠀ ꠡꠚꠣꠔ, ");
INSERT INTO syls_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","ꠄꠢꠥꠖꠣ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠎꠤꠚꠥꠘ꠆ꠘꠤꠞ ꠙꠥꠀ ꠇꠣꠟꠥꠔ, ");
INSERT INTO syls_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ꠁꠍꠣꠈꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠁꠃꠍꠥꠚꠞ ꠙꠥꠀ ꠎꠤꠉꠣꠟ, ");
INSERT INTO syls_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ꠀꠚꠞꠣꠁꠝ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠘꠥꠘꠞ ꠙꠥꠀ ꠢꠥꠍꠤꠀ, ");
INSERT INTO syls_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","ꠛꠤꠘ-ꠁꠀꠝꠤꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠞꠚꠥꠞ ꠙꠥꠀ ꠚꠟꠔꠤ, ");
INSERT INTO syls_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","ꠍꠛꠥꠟꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠍꠁꠖꠞ ꠙꠥꠀ ꠉꠖ꠆ꠖꠤꠄꠟ, ");
INSERT INTO syls_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","ꠁꠃꠍꠥꠚꠞ ꠙꠥꠀ ꠝꠣꠘꠡꠣ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠍꠥꠡꠤꠞ ꠙꠥꠀ ꠉꠣꠖ꠆ꠖꠤ, ");
INSERT INTO syls_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","ꠖꠣꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠉꠝꠟ꠆ꠟꠤꠞ ꠙꠥꠀ ꠀꠝ꠆ꠝꠤꠄꠟ, ");
INSERT INTO syls_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","ꠀꠡꠤꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠤꠇꠣꠁꠟꠞ ꠙꠥꠀ ꠍꠔꠥꠞ, ");
INSERT INTO syls_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","ꠘꠙ꠆ꠔꠣꠟꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠛꠡꠤꠞꠞ ꠙꠥꠀ ꠘꠁꠛ, ");
INSERT INTO syls_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","ꠀꠞ ꠍꠣꠖꠥ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠈꠤꠞ ꠙꠥꠀ ꠉꠥꠎꠄꠄꠟ। ");
INSERT INTO syls_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","ꠇꠦꠘꠣꠘ ꠖꠦꠡꠞ ꠢꠣꠟ-ꠢꠇꠤꠇꠔ ꠎꠣꠘꠤꠀ ꠀꠁꠛꠣꠞ ꠟꠣꠉꠤ ꠉꠥꠁꠀ ꠢꠤꠡꠣꠛꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠄꠞꠣꠞꠦ ꠙꠣꠑꠣꠁꠟꠣ। ꠔꠣꠁꠘ ꠘꠥꠘꠞ ꠙꠥꠀ ꠢꠥꠍꠤꠀꠞꠦ ꠁꠃꠍꠣ ꠇꠁꠀ ꠒꠣꠇꠤꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠙꠣꠑꠣꠘꠤꠞ ꠛꠣꠟꠣ ꠝꠥꠍꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠘꠦꠉꠦꠜ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠝꠣꠎꠦꠖꠤ ꠉꠤꠀ ꠙꠣꠠꠤꠀ ꠄꠟꠣꠇꠣꠔ ꠢꠣꠝꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ꠢꠣꠝꠣꠁꠀ ꠖꠦꠈꠛꠣꠄ, ꠅꠃ ꠖꠦꠡꠈꠣꠘ ꠇꠤꠟꠣ। ꠁ ꠖꠦꠡꠞ ꠛꠣꠡꠤꠘ꠆ꠖꠣ ꠝꠣꠘꠥꠡ ꠇꠝ ꠘꠣ ꠛꠦꠡꠤ, ꠔꠣꠞꠣ ꠇꠝꠎꠥꠞ ꠘꠣ ꠛꠟꠛꠣꠘ। ");
INSERT INTO syls_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ꠔꠣꠞꠣꠞ ꠖꠦꠡꠈꠣꠘ ꠜꠣꠟꠣ ꠘꠣ ꠝꠘ꠆ꠖ? ꠖꠦꠡꠞ ꠐꠣꠃꠘ ꠅꠇꠟ ꠃꠌꠣ ꠛꠣꠃꠘ꠆ꠒꠞꠤ ꠅꠀꠟ ꠇꠞꠣ, ꠘꠣ ꠛꠣꠃꠘ꠆ꠒꠞꠤ ꠍꠣꠠꠣ? ");
INSERT INTO syls_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ꠢꠤꠘꠞ ꠝꠣꠐꠤꠔ ꠞꠡ ꠀꠍꠦ ꠇꠤ ꠘꠣ, ꠉꠣꠍ-ꠙꠣꠟꠣ ꠀꠍꠦ ꠇꠤ ꠘꠣ? ꠀꠞ ꠀꠅꠀꠞ ꠡꠝꠄ ꠖꠦꠈꠤꠅ, ꠙꠣꠞꠟꠦ ꠢꠃ ꠖꠦꠡꠞ ꠇꠥꠘꠥ ꠚꠟ-ꠝꠥꠟ ꠟꠁꠀ ꠀꠁꠅ।” ꠅꠃ ꠡꠝꠄ ꠔ ꠀꠋꠉꠥꠞ ꠙꠣꠇꠣꠞ ꠡꠝꠄ ꠀꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","ꠔꠦꠃ ꠔꠣꠞꠣ ꠎꠤꠘ ꠝꠞꠥꠜꠥꠝꠤ ꠕꠣꠇꠤ ꠡꠥꠞꠥ ꠇꠞꠤꠀ ꠢꠣꠝꠣꠔꠞ ꠛꠣꠄ ꠞꠣꠢꠛ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠉꠤꠀ ꠀꠡ꠆ꠔꠣ ꠖꠦꠡꠞ ꠢꠣꠟ-ꠢꠇꠤꠇꠔ ꠖꠦꠈꠤꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","ꠎꠣꠅꠀꠞ ꠇꠣꠟꠅ ꠔꠣꠞꠣ ꠘꠦꠉꠦꠜ ꠝꠞꠥꠜꠥꠝꠤ ꠅꠁꠀ ꠢꠦꠛꠞꠘ ꠐꠣꠃꠘꠅ ꠉꠤꠀ ꠀꠎꠤꠟꠣ। ꠁ ꠢꠦꠛꠞꠘ ꠐꠣꠃꠘ ꠛꠣꠘꠣꠁꠟ ꠅꠁꠍꠤꠟ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠍꠥꠀꠘ ꠐꠣꠃꠘ ꠛꠣꠘꠣꠘꠤꠞ ꠡꠣꠔ ꠛꠍꠞ ꠀꠉꠦ। ꠢꠤꠘꠅ ꠙꠄꠟꠥꠀꠘ ꠀꠘꠣꠇꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠔꠤꠘꠎꠘ ꠝꠣꠘꠥꠡ ꠀꠍꠤꠟ, ꠄꠞꠣꠞ ꠘꠣꠝ ꠅꠁꠟ ꠀꠢꠤꠝꠣꠘ, ꠡꠤꠍꠣꠁ, ꠀꠞ ꠔꠣꠟꠝꠣꠁ। ");
INSERT INTO syls_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","ꠛꠣꠖꠦ ꠅꠃ ꠉꠥꠁꠀ ꠅꠇꠟ ꠀꠡꠇꠥꠟ ꠘꠣꠝꠞ ꠙꠣꠠꠤꠀ ꠈꠣꠟꠞ ꠙꠣꠞꠅ ꠕꠣꠇꠤ ꠄꠇ ꠍꠠꠤ ꠀꠋꠉꠥꠞ ꠡꠥꠖ꠆ꠖꠣ ꠀꠡ꠆ꠔꠣ ꠄꠇ ꠟꠔ ꠇꠣꠐꠤꠀ ꠟꠁꠀ ꠀꠁꠟꠣ। ꠁ ꠀꠋꠉꠥꠞꠞ ꠍꠠꠤ ꠔꠣꠞꠣꠞ ꠖꠥꠁꠎꠘꠦ ꠜꠣꠋ ꠖꠤꠀ ꠛꠁꠀ ꠀꠘꠟꠣ। ꠟꠉꠦ ꠇꠤꠍꠥ ꠀꠘꠥꠀꠞ ꠀꠞ ꠒꠥꠝꠥꠞ ꠚꠟꠅ ꠀꠘꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠡꠞ꠆ꠖꠣꠞ ꠅꠇꠟꠦ ꠢꠘ ꠕꠣꠇꠤ ꠅꠃ ꠀꠋꠉꠥꠞꠞ ꠍꠠꠤ ꠇꠣꠐꠣꠄ ꠅꠃ ꠎꠣꠉꠣꠞ ꠘꠣꠝ ꠅꠁꠉꠦꠟ, ꠀꠡꠇꠥꠟꠞ ꠈꠣꠟ, ꠝꠣꠘꠤ ꠍꠠꠤꠞ ꠈꠣꠟ। ");
INSERT INTO syls_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","ꠀꠡ꠆ꠔꠣ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠞ ꠢꠣꠟ-ꠢꠇꠤꠇꠔ ꠖꠦꠈꠤꠀ ꠢꠣꠞꠤ, ꠌꠣꠟ꠆ꠟꠤꠡ ꠖꠤꠘ ꠛꠣꠖꠦ ꠔꠣꠞꠣ ꠢꠇꠟ ꠚꠤꠞꠤꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","ꠅꠃ ꠉꠥꠁꠀ ꠅꠇꠟ ꠚꠣꠞꠣꠘ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠇꠣꠖꠦꠡ ꠘꠣꠝꠞ ꠎꠣꠉꠣꠔ ꠚꠤꠞꠤꠀ ꠀꠁꠟꠣ, ꠅꠘꠅ ꠝꠥꠍꠣ ꠘꠛꠤ, ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘ ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠅꠇꠟ ꠀꠍꠟꠣ। ꠄꠞꠣ ꠀꠁꠀ ꠢꠇꠟꠞꠦ ꠢꠘꠞ ꠈꠛꠞ-ꠀꠘ꠆ꠔꠞ ꠎꠣꠘꠣꠁꠟꠣ ꠀꠞ ꠢꠃ ꠖꠦꠡꠞ ꠚꠟ-ꠝꠥꠟ ꠖꠦꠈꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","ꠔꠣꠞꠣ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠀꠙꠘꠦ ꠀꠝꠞꠣꠞꠦ ꠎꠦ ꠖꠦꠡꠅ ꠙꠣꠑꠣꠁꠍꠟꠣ, ꠀꠝꠞꠣ ꠢꠘꠅ ꠉꠤꠀ ꠖꠦꠈꠟꠣꠝ, ꠢꠤ ꠖꠦꠡꠈꠣꠘ ꠢꠣꠍꠣꠃ ꠖꠥꠗ ꠀꠞ ꠝꠃꠞ ꠜꠣꠘ꠆ꠒꠣꠞ ꠀꠟꠣ ꠖꠦꠡ। ꠅꠃ ꠖꠦꠈꠃꠇ꠆ꠇꠣ, ꠢꠃ ꠖꠦꠡꠞ ꠚꠟ। ");
INSERT INTO syls_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","ꠅꠁꠟꠦ ꠢꠤꠘꠞ ꠝꠣꠘꠥꠡ ꠈꠥꠛ ꠙꠄꠟꠥꠀꠘ ꠀꠞ ꠔꠣꠞꠣꠞ ꠐꠣꠃꠘꠅ ꠛꠠ ꠛꠠ ꠀꠞ ꠃꠌꠣ ꠛꠣꠃꠘ꠆ꠒꠞꠤ ꠇꠞꠣ। ꠀꠝꠞꠣ ꠀꠘꠣꠇꠤ ꠙꠄꠟꠥꠀꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠡꠞꠦꠅ ꠢꠘꠅ ꠖꠦꠈꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","ꠀꠝꠣꠟꠦꠇꠤ ꠅꠇꠟ ꠛꠡꠔ ꠇꠞꠂꠘ ꠘꠦꠉꠦꠜ ꠝꠞꠥꠜꠥꠝꠤꠔ। ꠢꠤꠐ꠆ꠐꠤ, ꠎꠤꠛꠥꠎꠤ ꠀꠞ ꠀꠝꠥꠞꠤ ꠅꠇꠟ ꠙꠣꠠꠤ ꠄꠟꠣꠇꠣꠔ ꠞꠂꠘ। ꠀꠞ ꠇꠦꠘꠣꠘꠤ ꠅꠇꠟꠞ ꠇꠦꠃ ꠇꠦꠃ ꠖꠞꠤꠀꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠀꠞ ꠇꠦꠃ ꠇꠦꠃ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠙꠣꠞꠅ ꠞꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","ꠅꠃ ꠡꠝꠄ ꠝꠥꠍꠣꠞ ꠍꠣꠝꠘꠦ ꠎꠦꠔꠣ ꠝꠣꠘꠥꠡ ꠖꠟꠣ ꠀꠍꠟꠣ, ꠇꠣꠟꠥꠔꠦ ꠄꠞꠣꠞ ꠡꠥꠞꠉꠥꠟ ꠕꠣꠝꠣꠁꠀ ꠇꠁꠟꠣ, “ꠀꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠎꠞꠥꠞ ꠅꠁꠟ ꠢꠘꠅ ꠉꠤꠀ ꠅꠃ ꠖꠦꠡ ꠖꠈꠟ ꠇꠞꠣ, ꠀꠞ ꠁꠔꠣ ꠀꠝꠞꠣ ꠙꠣꠞꠝꠥꠅ।” ");
INSERT INTO syls_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠔꠣꠘ ꠟꠉꠞ ꠉꠥꠁꠀ ꠅꠇꠟꠦ ꠇꠁꠟꠣ, “ꠘꠣ, ꠘꠣ, ꠁꠔꠣ ꠝꠣꠘꠡꠞ ꠟꠉꠦ ꠟꠣꠠꠣꠁ ꠇꠞꠣ ꠀꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠅꠡꠝ꠆ꠛꠛ, ꠁꠔꠣ ꠀꠝꠞꠣ ꠕꠣꠇꠤ ꠛꠃꠔ ꠛꠟꠀꠟꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","ꠄꠞꠣ ꠢꠃ ꠖꠦꠡꠞ ꠛꠦꠙꠣꠞꠦ ꠝꠘꠉꠠꠣ ꠝꠤꠍꠣ ꠝꠣꠔꠤꠀ ꠇꠁꠟꠣ, “ꠀꠝꠞꠣ ꠎꠦ ꠖꠦꠡ ꠖꠦꠈꠣꠔ ꠉꠦꠍꠟꠣꠝ, ꠁ ꠖꠦꠡꠦ ꠔꠣꠞ ꠙ꠆ꠞꠎꠣ ꠅꠇꠟꠞꠦ ꠉꠤꠟꠤꠀ ꠈꠣꠁꠟꠣꠄ। ꠢꠤꠘꠞ ꠝꠣꠘꠥꠡ ꠈꠥꠛ ꠃꠌꠣ-ꠝꠥꠐꠣ ꠙꠄꠟꠥꠀꠘ। ");
INSERT INTO syls_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","ꠀꠝꠞꠣ ꠢꠤꠘꠅ ꠘꠦꠚꠤꠟꠤ ꠎꠣꠔꠞ ꠝꠣꠘꠡꠞꠦꠅ ꠖꠦꠈꠍꠤ, ꠁꠔꠣ ꠖꠦꠈꠔꠦ ꠖꠂꠔ꠆ꠔ-ꠖꠣꠘꠛꠞ ꠟꠣꠈꠣꠘ। ꠀꠝꠞꠣ ꠔ ꠔꠣꠞꠣꠞ ꠉꠦꠍꠦ ꠔꠥꠌ꠆ꠍ ꠙꠤꠙꠠꠣꠞ ꠟꠣꠈꠣꠘ, ꠔꠣꠞꠣꠅ ꠀꠝꠞꠣꠞꠦ ꠅꠟꠣ ꠙꠤꠙꠠꠣ ꠝꠘꠅ ꠇꠞꠍꠦ।” ꠎꠣꠘ ꠔ, ꠅꠈꠘꠇꠥꠞ ꠀꠘꠣꠇꠤ ꠎꠣꠔꠤ ꠅꠃ ꠘꠦꠚꠤꠟꠤ ꠅꠇꠟꠞ ꠛꠋꠡꠗꠞ। ");
INSERT INTO syls_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠌꠤꠟ꠆ꠟꠣ-ꠌꠤꠟ꠆ꠟꠤ ꠟꠣꠉꠣꠁꠟ। ꠔꠣꠞꠣ ꠢꠣꠞꠣ ꠞꠣꠁꠔ ꠇꠣꠘ꠆ꠖꠣ-ꠇꠣꠐꠤ ꠇꠞꠟ। ");
INSERT INTO syls_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","ꠢꠎꠞꠔ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠛꠃꠔ ꠇꠕꠣꠛꠣꠞ꠆ꠔꠣ ꠝꠣꠔꠤꠟ। ꠔꠣꠞꠣ ꠢꠇꠟꠦ ꠝꠤꠟꠤꠀ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟ, “ꠢꠣꠄꠞꠦ ꠢꠣꠄ! ꠀꠝꠞꠣ ꠇꠦꠘꠦ ꠢꠃ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠛꠣ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠝꠞꠟꠣꠝ ꠘꠣ? ꠢꠘꠅ ꠝꠞꠣꠃ ꠔ ꠜꠣꠟꠣ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","ꠝꠣꠛꠥꠖꠦ ꠇꠦꠘꠦ ꠀꠝꠞꠣꠞꠦ ꠎꠥꠖ꠆ꠖꠞ ꠝꠄꠖꠣꠘꠅ ꠝꠣꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠅꠃ ꠖꠦꠡꠅ ꠘꠤꠞꠣ? ꠢꠘꠞ ꠖꠥꠡꠝꠘ ꠅꠇꠟꠦ ꠀꠝꠞꠣꠞ ꠛꠃ-ꠛꠣꠁꠌ꠆ꠌꠣꠁꠘꠞꠦ ꠇꠣꠠꠤꠀ ꠘꠤꠛꠣ। ꠄꠞ ꠕꠣꠇꠤ ꠝꠤꠡꠞꠅ ꠚꠤꠞꠤꠀ ꠎꠣꠅꠀꠃ ꠀꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠜꠣꠟꠣ ꠘꠣꠄ ꠘꠤ?” ");
INSERT INTO syls_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","ꠔꠣꠞꠣ ꠄꠇꠦ-ꠅꠁꠘ꠆ꠘꠦ ꠇꠁꠟ, “ꠀꠅ, ꠀꠝꠞꠣ ꠄꠇꠎꠘ ꠘꠦꠔꠣ ꠛꠣꠘꠣꠁꠀ ꠢꠤꠞꠛꠣꠞ ꠝꠤꠡꠞꠅ ꠚꠤꠞꠤꠀ ꠎꠣꠁꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","ꠁ ꠢꠣꠟꠔ ꠖꠦꠈꠤꠀ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘ ꠀꠡ꠆ꠔꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠡꠝꠣꠎꠞ ꠍꠣꠝꠘꠦ ꠝꠣꠐꠤꠔ ꠍꠁꠎꠖꠣꠔ ꠙꠠꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","ꠀꠞ ꠎꠦ ꠉꠥꠁꠀ ꠖꠟꠦ ꠅꠃ ꠖꠦꠡꠞ ꠢꠣꠟ-ꠢꠇꠤꠇꠔ ꠖꠦꠈꠤꠀ ꠀꠁꠍꠟꠣ, ꠔꠣꠞꠣꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠘꠥꠘꠞ ꠙꠥꠀ ꠁꠃꠍꠣ ꠀꠞ ꠎꠤꠚꠥꠘ꠆ꠘꠤꠞ ꠙꠥꠀ ꠇꠣꠟꠥꠔꠦ ꠝꠘꠞ ꠖꠥꠈꠦ ꠘꠤꠎꠞ ꠉꠔꠞꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠍꠤꠠꠤꠟ꠆ꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ꠍꠤꠠꠤꠀ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠡꠝꠣꠎꠞ ꠢꠇ꠆ꠇꠟꠞꠦ ꠇꠁꠟꠣ, “ꠢꠥꠘꠅ, ꠀꠝꠞꠣ ꠎꠦ ꠖꠦꠡ ꠖꠦꠈꠣꠔ ꠉꠦꠍꠟꠣꠝ, ꠁ ꠖꠦꠡꠈꠣꠘ ꠈꠥꠛ ꠡꠥꠘ꠆ꠖꠞ। ");
INSERT INTO syls_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","ꠝꠣꠛꠥꠖ ꠎꠥꠖꠤ ꠀꠝꠞꠣꠞ ꠃꠙꠞꠦ ꠈꠥꠡ ꠀꠞ ꠞꠣꠎꠤ ꠕꠣꠇꠂꠘ, ꠔꠦ ꠀꠝꠞꠣꠞꠦ ꠢꠃ ꠖꠦꠡꠅ ꠘꠤꠀ ꠙꠣꠞ ꠇꠞꠛꠣ, ꠔꠣꠁꠘ ꠖꠥꠗ ꠀꠞ ꠝꠃꠞ ꠜꠣꠘ꠆ꠒꠣꠞ ꠀꠟꠣ ꠅꠃ ꠖꠦꠡꠈꠣꠘ ꠀꠝꠞꠣꠞꠦ ꠖꠣꠘ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","ꠢꠥꠘꠅ, ꠔꠥꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠝꠞ꠆ꠎꠤꠞ ꠃꠟꠐꠣ ꠇꠣꠝ ꠇꠞꠤꠅ ꠘꠣ। ꠔꠥꠝꠞꠣ ꠢꠤ ꠖꠦꠡꠞ ꠝꠣꠘꠡꠞꠦ ꠒꠞꠣꠁꠅ ꠘꠣ, ꠔꠣꠞꠣꠞꠦ ꠉꠤꠟꠤꠀ ꠈꠣꠁꠔꠦꠅ ꠀꠝꠞꠣꠞ ꠖꠦꠞꠤ ꠅꠁꠔ ꠘꠣꠄ। ꠔꠥꠝꠞꠣ ꠁꠔꠣꠞꠦ ꠒꠞꠣꠁꠅ ꠘꠣ, ꠔꠣꠞꠣꠞ ꠝꠣꠕꠣꠞ ꠃꠙꠞꠞ ꠍꠣꠄꠀ ꠘꠣꠁ, ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠔ ꠝꠣꠛꠥꠖ ꠀꠍꠂꠘ।” ");
INSERT INTO syls_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","ꠅꠁꠟꠦ ꠔꠣꠞꠣ ꠢꠇꠟꠦꠃ ꠇꠁꠟꠣ ꠁꠃꠍꠣ ꠀꠞ ꠇꠣꠟꠥꠔꠞꠦ ꠙꠣꠔ꠆ꠔꠞ ꠝꠣꠞꠤꠀ ꠝꠣꠞꠤꠟꠔꠣ। ꠅꠃ ꠡꠝꠄ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥ ꠕꠣꠇꠤ ꠀꠡ꠆ꠔꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠡꠝꠣꠎꠞ ꠍꠣꠝꠘꠦ ꠝꠣꠛꠥꠖꠞ ꠇꠥꠖꠞꠔꠤ ꠘꠥꠞ ꠎꠣꠁꠞ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","ꠝꠣꠛꠥꠖꠦ ꠇꠁꠟꠣ, “ꠅ ꠝꠥꠍꠣ, ꠁꠔꠣꠄ ꠀꠝꠣꠞꠦ ꠀꠞ ꠇꠔꠖꠤꠘ ꠄꠟꠣꠝꠤ ꠇꠞꠛ? ꠔꠣꠞꠣꠞ ꠍꠣꠝꠘꠦ ꠅꠔ ꠇꠦꠞꠣꠝꠔꠤ ꠘꠤꠡꠣꠘꠣ ꠖꠦꠈꠣꠘꠤꠞ ꠛꠣꠖꠦꠅ, ꠔꠣꠞꠣ ꠀꠞ ꠇꠔꠖꠤꠘ ꠀꠝꠣꠞꠦ ꠄꠇꠤꠘ ꠇꠞꠔ ꠘꠣꠄ? ");
INSERT INTO syls_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","ꠔꠦ ꠢꠥꠘꠅ, ꠀꠝꠤ ꠔꠣꠞꠣꠞ ꠃꠙꠞꠦ ꠛꠠ ꠄꠇ ꠉꠎꠛ ꠓꠣꠟꠤꠝꠥ, ꠀꠝꠣꠞ ꠅꠀꠖꠣ ꠇꠞꠣ ꠢꠃ ꠖꠦꠡꠞ ꠝꠣꠟꠤꠇꠣꠘꠣ ꠇꠣꠠꠤꠀ ꠘꠤꠝꠥꠉꠤ। ꠛꠣꠖꠦ ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠁꠔꠣ ꠕꠘꠦ ꠀꠞꠅ ꠛꠟꠛꠣꠘ, ꠀꠞꠅ ꠛꠠ ꠘꠄꠀ ꠄꠇ ꠎꠣꠔꠤ ꠙꠄꠖꠣ ꠇꠞꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠝꠥꠍꠣꠄ ꠇꠁꠟꠣ, “ꠅ ꠝꠣꠛꠥꠖ, ꠔꠥꠝꠤ ꠎꠥꠖꠤ ꠁꠟꠣ ꠇꠞꠅ, ꠔꠦ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠦ ꠁꠔꠣ ꠢꠥꠘꠛꠣ। ꠀꠞ ꠔꠥꠝꠤ ꠔ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠁꠔꠣ ꠝꠣꠘꠡꠞꠦ ꠔꠥꠝꠣꠞ ꠘꠤꠎꠞ ꠇꠥꠖꠞꠔꠤꠄ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠍ। ");
INSERT INTO syls_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","ꠅꠈꠘ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠦ ꠁ ꠖꠦꠡꠞ ꠝꠣꠘꠡꠞꠦꠅ ꠁꠔꠣ ꠎꠣꠘꠣꠁ ꠖꠤꠛꠣ। ꠔꠦ ꠅ ꠝꠣꠛꠥꠖ, ꠁꠘꠞ ꠝꠣꠘꠡꠦ ꠔ ꠄꠝꠘꠦꠃ ꠎꠣꠘꠤꠟꠤꠍꠂꠘ ꠎꠦꠘ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠉꠦ ꠟꠉꠦ ꠔꠥꠝꠤ ꠀꠍ, ꠔꠥꠝꠣꠞꠦ ꠈꠥꠛ ꠗꠣꠞꠅ ꠕꠣꠇꠤ ꠖꠦꠈꠣ ꠎꠣꠄ। ꠔꠣꠞꠣ ꠢꠥꠘꠍꠂꠘ, ꠔꠥꠝꠣꠞ ꠘꠥꠞꠞ ꠝꠦꠊꠞ ꠍꠣꠄꠀ ꠄꠞꠣꠞ ꠃꠙꠞꠦ ꠀꠍꠦ, ꠔꠥꠝꠤ ꠖꠤꠘꠞ ꠛꠣꠟꠣ ꠝꠦꠊꠞ ꠈꠥꠐꠤ ꠀꠞ ꠞꠣꠁꠔ ꠅꠁꠟꠦ ꠀꠉꠥꠁꠘꠞ ꠈꠥꠐꠤꠞ ꠍꠥꠞꠔꠦ ꠄꠞꠣꠞ ꠀꠉꠦ ꠀꠉꠦ ꠞꠅ। ");
INSERT INTO syls_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","ꠅꠈꠘ ꠔꠥꠝꠤ ꠎꠥꠖꠤ ꠄꠞꠣ ꠢꠇꠟꠞꠦ ꠄꠇꠟꠉꠦ ꠝꠣꠞꠤꠟꠣꠅ, ꠔꠦ ꠎꠔ ꠎꠣꠔꠤꠞ ꠝꠣꠘꠡꠦ ꠔꠥꠝꠣꠞ ꠁꠔꠣ ꠇꠥꠖꠞꠔꠤ ꠇꠣꠝꠞ ꠈꠛꠞ ꠢꠥꠘꠍꠦ, ꠔꠣꠞꠣ ꠇꠁꠛꠣ, ");
INSERT INTO syls_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","ꠝꠣꠛꠥꠖꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠦ ꠖꠦꠡ ꠖꠤꠛꠣꠞ ꠅꠀꠖꠣ ꠇꠞꠍꠟꠣ, ꠢꠤ ꠖꠦꠡꠅ ꠟꠁꠀ ꠎꠣꠅꠀꠞ ꠈꠦꠝꠔꠣ ꠔꠣꠘ ꠘꠣꠁ, ꠄꠞꠟꠣꠉꠤ ꠔꠣꠁꠘ ꠄꠞꠣꠞꠦ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠘꠤꠀ ꠝꠣꠞꠤꠟꠤꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“ꠔꠦ, ꠅ ꠖꠤꠘ-ꠖꠥꠘꠤꠀꠞ ꠝꠣꠟꠤꠇ, ꠔꠥꠝꠤ ꠀꠉꠦ ꠎꠦꠟꠣ ꠇꠁꠍꠟꠣꠄ ꠅꠟꠣ ꠇꠥꠖꠞꠔꠤ ꠇꠣꠝ ꠎꠣꠁꠞ ꠇꠞꠅ। ꠔꠥꠝꠤ ꠘꠥ ꠇꠁꠍꠟꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","ꠝꠣꠛꠥꠖꠦ ꠉꠥꠍꠣ ꠇꠞꠂꠘ ꠗꠤꠞ ꠉꠔꠤꠄ, ꠔꠣꠘ ꠝꠣꠄꠀ-ꠝꠢꠛ꠆ꠛꠔꠞ ꠇꠥꠘꠥ ꠡꠤꠝꠣ ꠘꠣꠁ, ꠔꠣꠁꠘ ꠝꠣꠘꠡꠞ ꠅꠁꠘ꠆ꠘꠣꠄ ꠀꠞ ꠘꠣꠚꠞꠝꠣꠘꠤꠞ ꠝꠣꠚꠤ ꠖꠦꠁꠘ। ꠅꠁꠟꠦ ꠖꠥꠡꠤ ꠎꠘꠞꠦ ꠡꠣꠎꠣꠅ ꠖꠦꠁꠘ, ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠘꠣꠚꠞꠝꠣꠘꠤꠞ ꠡꠣꠎꠣ ꠔꠣꠞ ꠘꠣꠔꠤ-ꠙꠥꠔꠤ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠛꠞ꠆ꠔꠣꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","ꠔꠦ ꠔꠥꠝꠣꠞ ꠖꠥꠀꠁ ꠖꠤꠀ ꠇꠁꠞꠣꠝ, ꠝꠤꠡꠞ ꠖꠦꠡ ꠍꠣꠠꠤꠀ ꠀꠅꠀ ꠕꠣꠇꠤ ꠅꠈꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠔꠥꠝꠤ ꠄꠞꠣꠞꠦ ꠎꠦꠟꠣ ꠝꠣꠚꠤ ꠖꠤꠞꠣꠄ, ꠔꠥꠝꠣꠞ ꠢꠃ ꠝꠣꠄꠀꠞ ꠈꠣꠔꠤꠞꠦ ꠔꠣꠞꠣꠞ ꠅꠈꠘꠇꠥꠞ ꠉꠥꠘꠣꠞꠦꠅ ꠅꠟꠣ ꠝꠣꠚ ꠇꠞꠤ ꠖꠤꠟꠣꠅ।” ");
INSERT INTO syls_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","ꠔꠦꠃ ꠝꠣꠛꠥꠖꠦ ꠇꠁꠟꠣ, “ꠀꠁꠌ꠆ꠍꠣ, ꠔꠥꠝꠣꠞ ꠇꠕꠣꠄ ꠀꠝꠤ ꠁꠔꠣꠞꠦ ꠝꠣꠚ ꠇꠞꠤ ꠖꠤꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ꠅꠁꠟꠦ ꠀꠝꠤ ꠎꠤꠘ꠆ꠖꠣ ꠀꠍꠤ ꠁꠈꠣꠘ ꠎꠦꠟꠣ ꠢꠣꠍꠣ, ꠀꠡ꠆ꠔꠣ ꠎꠉꠔꠅ ꠀꠝꠣꠞ ꠟꠤꠟꠣ-ꠈꠦꠟꠣꠄ ꠜꠞꠣ ꠁꠐꠣꠅ ꠎꠦꠟꠣ ꠢꠣꠍꠣ, ꠅꠃ ꠟꠣꠈꠣꠘ ꠀꠞꠇ ꠢꠣꠍꠣ ꠅꠁꠟ, ");
INSERT INTO syls_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","23","ꠁꠔꠣ ꠄꠇꠎꠘꠦꠅ ꠀꠝꠣꠞ ꠅꠀꠖꠣ ꠇꠞꠣ ꠢꠤ ꠖꠦꠡ ꠖꠦꠈꠣꠞ ꠡꠥꠎꠥꠉ ꠅꠁꠔ ꠘꠣꠄ, ꠎꠦ ꠖꠦꠡ ꠖꠤꠔꠣꠝ ꠇꠞꠤ ꠀꠝꠤ ꠔꠣꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠉꠦꠍꠦ ꠅꠀꠖꠣ ꠇꠞꠍꠟꠣꠝ। ꠇꠣꠞꠘ ꠁꠔꠣꠄ ꠀꠝꠣꠞ ꠘꠥꠞꠞ ꠔꠎꠟ꠆ꠟꠤ ꠖꠦꠈꠍꠂꠘ, ꠔꠣꠞꠣ ꠝꠤꠡꠞꠅ ꠕꠣꠇꠔꠦ ꠀꠞ ꠅꠃ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠀꠁꠀꠅ ꠀꠝꠣꠞ ꠇꠥꠖꠞꠔꠤ ꠟꠤꠟꠣ-ꠈꠦꠟꠣ ꠖꠦꠈꠣꠞ ꠛꠣꠖꠦꠅ ꠁꠔꠣꠄ ꠀꠝꠣꠞꠦ ꠝꠣꠘꠍꠂꠘ ꠘꠣ, ꠛꠞꠋ ꠖꠡ-ꠖꠡꠛꠣꠞ ꠔꠣꠞꠣ ꠀꠝꠣꠞꠦ ꠙꠞꠤꠇ꠆ꠇꠣ ꠇꠞꠍꠂꠘ। ꠔꠦ ꠔꠣꠞꠣ ꠎꠔꠎꠘꠦ ꠀꠝꠣꠞꠦ ꠄꠟꠣꠝꠤ ꠇꠞꠍꠦ, ꠁꠔꠣ ꠄꠇꠎꠘꠦꠅ ꠢꠤ ꠖꠦꠡ ꠖꠦꠈꠣꠞ ꠇꠙꠣꠟ ꠅꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","ꠅꠁꠟꠦ ꠀꠝꠣꠞ ꠛꠘ꠆ꠖꠣ ꠇꠣꠟꠥꠔꠞ ꠖꠤꠟꠞ ꠜꠣꠛ ꠁꠟꠣ ꠘꠣꠄ, ꠢꠦ ꠀꠝꠣꠞ ꠢꠥꠇꠥꠝ ꠙꠥꠞꠣꠙꠥꠞ ꠝꠣꠘꠦ। ꠄꠞꠟꠣꠉꠤ ꠎꠦ ꠖꠦꠡ ꠖꠦꠈꠣꠔ ꠢꠦ ꠉꠦꠍꠤꠟ, ꠀꠝꠤ ꠔꠣꠞꠦ ꠢꠃ ꠖꠦꠡꠅ ꠘꠤꠝꠥ, ꠔꠣꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟ ꠢꠤ ꠖꠦꠡꠞ ꠝꠣꠟꠤꠇ ꠅꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","ꠢꠥꠘꠅ, ꠢꠃ ꠖꠦꠡꠞ ꠙꠣꠠꠤꠀ ꠔꠟ ꠎꠣꠉꠣꠁꠘ꠆ꠔꠅ ꠅꠈꠘ ꠀꠝꠣꠟꠦꠇꠤ ꠀꠞ ꠇꠦꠘꠣꠘꠤ ꠅꠇꠟꠦ ꠛꠡꠔ ꠇꠞꠞꠣ। ꠔꠦ ꠍꠣꠝꠘꠞ ꠇꠣꠁꠟ ꠔꠥꠝꠞꠣ ꠙꠤꠍꠦꠖꠤ ꠉꠤꠀ ꠀꠇꠣꠛꠣ ꠡꠣꠉꠞꠞ ꠙꠣꠞꠦꠖꠤ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠛꠣꠄ ꠞꠅꠀꠘꠣ ꠅꠁꠅ।” ");
INSERT INTO syls_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“ꠅꠃ ꠘꠣꠚꠞꠝꠣꠘ ꠎꠣꠔꠤꠄ ꠀꠝꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠀꠞ ꠇꠔꠖꠤꠘ ꠛꠦꠞ-ꠛꠦꠞꠤ ꠇꠞꠔ? ꠔꠣꠞꠣ ꠀꠝꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠎꠦꠔꠣ ꠝꠣꠔ ꠝꠣꠔꠦꠞ, ꠁꠔꠣ ꠔ ꠀꠝꠤ ꠢꠥꠘꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","ꠅꠈꠘ ꠔꠥꠝꠞꠣ ꠉꠤꠀ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠅ, ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠘꠤꠎꠞ ꠎꠤꠘ꠆ꠖꠦꠉꠤꠞ ꠇꠍꠝ ꠈꠣꠁꠀ ꠇꠁꠞꠣꠝ, ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠝꠥꠈꠞ ꠎꠦꠔꠣ ꠝꠣꠔ-ꠇꠕꠣ ꠢꠥꠘꠍꠤ, ꠀꠝꠤꠅ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠑꠤꠇ ꠅꠟꠣꠃ ꠇꠞꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","ꠝꠣꠘꠥꠡ ꠉꠘꠤꠛꠣꠞ ꠡꠝꠄ ꠔꠥꠝꠞꠣꠞ ꠛꠤꠡ ꠛꠍꠞ ꠛꠣ ꠔꠣꠞ ꠛꠦꠡꠤ ꠛꠄꠅꠡꠞ ꠎꠦꠔꠣꠞꠦ ꠉꠘꠣ ꠅꠁꠍꠤꠟ, ꠝꠣꠘꠤ ꠎꠦꠔꠣꠄ ꠀꠝꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠛꠦꠞ-ꠛꠦꠞꠤ ꠇꠞꠍꠦ, ꠁꠔꠣꠞ ꠟꠣꠡ ꠅꠃ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠝꠣꠎꠦ ꠙꠠꠤ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦ ꠖꠦꠡ ꠖꠤꠔꠣꠝ ꠇꠞꠤ ꠅꠀꠖꠣ ꠇꠞꠍꠟꠣꠝ, ꠈꠣꠟꠤ ꠎꠤꠚꠥꠘ꠆ꠘꠤꠞ ꠙꠥꠀ ꠇꠣꠟꠥꠔ ꠀꠞ ꠘꠥꠘꠞ ꠙꠥꠀ ꠁꠃꠍꠣ ꠍꠣꠠꠣ ꠀꠞ ꠇꠦꠃ ꠉꠤꠀ ꠢꠤ ꠖꠦꠡꠅ ꠢꠣꠝꠣꠘꠤꠞ ꠇꠙꠣꠟ ꠅꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠎꠦꠔꠣ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠞꠦ ꠇꠣꠠꠤꠀ ꠘꠦꠅꠀ ꠅꠁꠛ ꠇꠁꠍꠟꠣꠄ, ꠀꠝꠤ ꠅꠃ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘꠞꠦꠃ ꠢꠃ ꠖꠦꠡꠅ ꠙꠣꠞ ꠇꠞꠝꠥ, ꠔꠣꠞꠣꠃ ꠅꠁꠛꠣ ꠢꠤ ꠖꠦꠡꠞ ꠝꠣꠟꠤꠇ, ꠎꠦ ꠖꠦꠡꠞꠦ ꠔꠥꠝꠞꠣ ꠄꠟꠣꠝꠤ ꠇꠞꠍ। ");
INSERT INTO syls_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠡ ꠅꠃ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠙꠠꠤ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","ꠅꠃ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠙꠦꠐꠅ ꠔꠥꠝꠞꠣꠞ ꠄꠇ꠆ꠇꠦꠞꠦ ꠀꠈꠦꠞꠤ ꠎꠘ ꠘꠣ ꠝꠞꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ, ꠔꠥꠝꠞꠣꠞ ꠛꠦꠁꠝꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠞꠣꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠦ ꠌꠣꠟ꠆ꠟꠤꠡ ꠛꠍꠞ ꠅꠘꠅ ꠉꠞꠥ-ꠍꠣꠉꠟꠞ ꠞꠣꠈꠣꠟꠤ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","ꠇꠦꠘꠣꠘ ꠖꠦꠡꠞ ꠢꠣꠟ-ꠢꠇꠤꠇꠔ ꠖꠦꠈꠤꠀ ꠀꠁꠔꠦ ꠎꠦ ꠌꠣꠟ꠆ꠟꠤꠡ ꠖꠤꠘ ꠟꠣꠉꠍꠤꠟ, ꠄꠞ ꠄꠇ ꠖꠤꠘꠞ ꠛꠖꠟꠣ ꠄꠇ ꠛꠍꠞ, ꠅꠃꠟꠣ ꠝꠥꠐ ꠌꠣꠟ꠆ꠟꠤꠡ ꠛꠍꠞ ꠔꠥꠝꠞꠣꠞ ꠘꠣꠚꠞꠝꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠇꠡ꠆ꠐ ꠇꠞꠛꠣꠄ। ꠔꠦꠃ ꠛꠥꠎꠛꠣꠄ, ꠀꠝꠤ ꠎꠦꠛꠟꠣ ꠇꠦꠃꠞꠞ ꠛꠤꠞꠥꠗꠤꠔꠣ ꠇꠞꠤ ꠄꠞ ꠖꠡꠣ ꠇꠤꠟꠣ ꠅꠄ। ");
INSERT INTO syls_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","ꠔꠦ ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠇꠁꠞꠣꠝ, ꠅꠃ ꠘꠣꠚꠞꠝꠣꠘ ꠎꠣꠔꠤꠞ ꠎꠦꠔꠣ ꠝꠣꠘꠡꠦ ꠀꠝꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠖꠟ ꠛꠣꠘ꠆ꠖꠤꠍꠦ, ꠁꠔꠣ ꠢꠇ꠆ꠇꠟꠐꠤ ꠅꠃ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠝꠞꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","ꠇꠦꠘꠣꠘ ꠖꠦꠡꠞ ꠢꠣꠟ-ꠢꠇꠤꠇꠔ ꠎꠣꠘꠣꠞ ꠟꠣꠉꠤ ꠝꠥꠍꠣꠄ ꠎꠦ ꠉꠥꠁꠀ ꠖꠟꠞꠦ ꠙꠣꠑꠣꠁꠍꠟꠣ, ꠄꠞꠣꠞ ꠝꠣꠎꠞ ꠎꠦꠉꠥꠁꠘ ꠚꠤꠞꠤꠀ ꠀꠁꠀ ꠛꠦꠁꠝꠣꠘꠤ ꠈꠛꠞ ꠞꠐꠣꠁꠀ, ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠖꠤꠀ ꠝꠥꠍꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠛꠇꠣ-ꠎꠇꠣ ꠇꠞꠣꠁꠍꠤꠟ, ");
INSERT INTO syls_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ꠝꠣꠘꠤ ꠎꠦꠞꠣ ꠢꠃ ꠖꠦꠡꠞ ꠛꠦꠙꠣꠞꠦ ꠀꠎꠦ-ꠛꠣꠎꠦ ꠝꠣꠔ ꠞꠐꠣꠁꠍꠤꠟ, ꠔꠣꠞꠣ ꠢꠇ꠆ꠇꠟꠃ ꠝꠢꠣ ꠉꠎꠛꠤ ꠛꠦꠝꠣꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠝꠞꠤꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","ꠅꠃ ꠉꠥꠁꠀ ꠖꠟꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠈꠣꠟꠤ ꠘꠥꠘꠞ ꠙꠥꠀ ꠁꠃꠍꠣ ꠀꠞ ꠎꠤꠚꠥꠘ꠆ꠘꠤꠞ ꠙꠥꠀ ꠇꠣꠟꠥꠔ ꠛꠣꠌꠤꠀ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","ꠢꠎꠞꠔ ꠝꠥꠍꠣꠄ ꠝꠣꠛꠥꠖꠞ ꠇꠕꠣ ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁꠟꠣ। ꠁꠔꠣ ꠢꠥꠘꠤꠀ ꠔꠣꠞꠣ ꠝꠘꠞ ꠖꠥꠈꠦ ꠇꠣꠔꠞ ꠅꠁꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","ꠛꠣꠖꠞ ꠖꠤꠘ ꠛꠤꠀꠘꠦ ꠔꠣꠞꠣ ꠢꠃ ꠙꠣꠠꠤ ꠄꠟꠣꠇꠣꠔ ꠎꠣꠅꠀꠞ ꠟꠣꠉꠤ ꠔꠤꠀꠞ ꠅꠁꠀ ꠇꠁꠟ, “ꠅꠃ ꠖꠦꠈꠅ, ꠀꠝꠞꠣ ꠎꠣꠁꠞꠣꠝꠉꠤ। ꠀꠝꠞꠣ ꠔ ꠉꠥꠘꠣ ꠇꠞꠤꠀ ꠢꠣꠞꠍꠤ, ꠔꠦ ꠅꠈꠘ ꠀꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠅꠀꠖꠣ ꠇꠞꠣ ꠖꠦꠡꠅꠃ ꠎꠣꠁꠔꠣꠝꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","ꠅꠁꠟꠦ ꠝꠥꠍꠣꠄ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝꠞ ꠃꠟꠐꠣ ꠎꠣꠁꠞꠣꠄ ꠇꠦꠘꠦ? ꠔꠥꠝꠞꠣꠞ ꠘꠤꠅꠔ ꠙꠥꠞꠣ ꠅꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","ꠢꠥꠘꠅ, ꠔꠥꠝꠞꠣ ꠎꠣꠁꠅ ꠘꠣ, ꠇꠣꠞꠘ ꠝꠣꠛꠥꠖ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠘꠣꠄ। ꠖꠥꠡꠝꠘ ꠅꠇꠟꠞ ꠉꠦꠍꠦ ꠔꠥꠝꠞꠣ ꠀꠞꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","ꠢꠤꠘꠅ ꠉꠤꠀ ꠔꠥꠝꠞꠣ ꠀꠝꠣꠟꠦꠇꠤ ꠀꠞ ꠇꠦꠘꠣꠘꠤ ꠅꠇꠟꠞ ꠝꠥꠈꠣꠝꠥꠈꠤ ꠅꠁꠛꠣꠄ। ꠀꠞ ꠝꠣꠛꠥꠖꠞ ꠟꠉ ꠍꠣꠠꠤꠀ ꠉꠦꠍꠉꠤ ꠇꠞꠤ, ꠔꠣꠁꠘ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠞꠁꠔꠣ ꠘꠣꠄ। ꠄꠞꠟꠣꠉꠤ ꠔꠥꠝꠞꠣ ꠎꠥꠖ꠆ꠖꠞ ꠝꠥꠈꠅ ꠝꠞꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","ꠔꠦꠛꠃ ꠔꠣꠞꠣ ꠔꠣꠘ ꠇꠕꠣ ꠃꠟꠐꠣꠁꠀ ꠢꠃ ꠙꠣꠠꠤ ꠄꠟꠣꠇꠣ ꠛꠣꠄ ꠞꠅꠀꠘꠣ ꠖꠤꠟ। ꠅꠁꠟꠦ ꠝꠥꠍꠣ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠉꠦꠟꠣ ꠘꠣ ꠀꠞ ꠝꠣꠛꠥꠖꠞ ꠙꠛꠤꠔ꠆ꠞ ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇꠅ ꠇꠦꠝ꠆ꠙꠞ ꠜꠤꠔꠞꠦ ꠞꠁꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","ꠔꠣꠞꠣꠞꠦ ꠖꠦꠈꠤꠀꠃ ꠢꠃ ꠙꠣꠠꠤꠀ ꠄꠟꠣꠇꠣꠞ ꠀꠝꠣꠟꠦꠇꠤ ꠀꠞ ꠇꠦꠘꠣꠘꠤ ꠅꠇꠟ ꠟꠣꠝꠤꠀ ꠀꠁꠀ ꠢꠣꠝꠟꠣ ꠌꠣꠟꠣꠁꠟ, ꠀꠞ ꠢꠘꠞ ꠢꠞ꠆ꠝꠣ ꠐꠣꠃꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠈꠦꠖꠣꠁꠀ ꠘꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠀꠝꠤ ꠎꠦ ꠖꠦꠡꠈꠣꠘꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠘꠤꠎꠞ ꠖꠦꠡ ꠢꠤꠡꠣꠛꠦ ꠖꠣꠘ ꠇꠞꠞꠣꠝ, ꠔꠥꠝꠞꠣ ꠎꠦꠛꠟꠣ ꠢꠃ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠎꠣꠁꠛꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ꠉꠤꠀ ꠀꠝꠣꠞꠦ ꠈꠥꠡ ꠞꠣꠈꠣꠞ ꠘꠤꠅꠔꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠊꠦꠞꠣꠘ ꠀꠟꠣ ꠎꠦꠇꠥꠘꠥ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠔꠥꠝꠞꠣꠞ ꠙꠣꠟ ꠕꠣꠇꠤ ꠎꠦꠛꠟꠣ ꠉꠣꠁ-ꠉꠞꠥ ꠛꠣ ꠝꠦꠠꠣ-ꠍꠣꠉꠟ ꠀꠘꠤꠀ ꠀꠝꠣꠞ ꠘꠣꠝꠦ ꠖꠤꠛꠣꠞ ꠘꠤꠅꠔ ꠇꠞꠛꠣꠄ, ꠀꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠇꠥꠘꠥ ꠝꠣꠘ꠆ꠘꠔ ꠙꠥꠞꠘꠞ ꠇꠥꠞꠛꠣꠘꠤ, ꠢꠇꠟ ꠘꠝꠥꠘꠣꠞ ꠘꠚꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠛꠣ ꠎꠦꠇꠥꠘꠥ ꠁꠖꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠟꠦ, ");
INSERT INTO syls_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠞꠔꠦꠇ ꠙꠡꠥꠞ ꠟꠉꠦ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠅ ꠖꠤꠛꠣꠄ। ꠅꠃ ꠍꠖꠉꠣꠞ ꠟꠣꠉꠤ ꠖꠥꠁ ꠡꠦꠞ ꠝꠄꠖꠣꠞꠦ ꠄꠇ ꠡꠦꠞ ꠔꠦꠟꠖꠤ ꠝꠣꠈꠣꠁꠀ ꠈꠣꠁ ꠛꠣꠘꠣꠁꠀ ꠀꠘꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","ꠅꠁꠟꠦ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥꠐꠣ ꠎꠥꠖꠤ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠅꠄ, ꠔꠦ ꠁꠐꠣꠞ ꠟꠉꠦ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣ ꠢꠤꠡꠣꠛꠦ ꠀꠋꠉꠥꠞꠞ ꠄꠇ ꠡꠦꠞ ꠡꠞꠛꠔꠅ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","ꠀꠞ ꠅꠃ ꠙꠡꠥ ꠎꠥꠖꠤ ꠝꠦꠠꠣ ꠅꠄ, ꠔꠦ ꠔꠣꠞ ꠟꠉꠦ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠢꠤꠡꠣꠛꠦ ꠡꠥꠀ ꠡꠦꠞ ꠔꠦꠟꠖꠤ ꠝꠣꠈꠣꠁꠀ ꠌꠣꠁꠞ ꠡꠦꠞ ꠝꠄꠖꠣ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣꠞ ꠟꠣꠉꠤ ꠟꠣꠉꠛ ꠀꠋꠉꠥꠞꠞ ꠡꠥꠀ ꠡꠦꠞ ꠡꠞꠛꠔ। ꠁꠔꠣ ꠀꠘꠤꠀ ꠀꠝꠣꠞꠦ ꠈꠥꠡ ꠇꠞꠣꠞ ꠊꠦꠞꠣꠘ ꠀꠟꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠖꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","ꠔꠥꠝꠞꠣ ꠎꠥꠖꠤ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠝꠣꠘ꠆ꠘꠔ ꠙꠥꠞꠘꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠛꠣ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠇꠥꠘꠥ ꠉꠞꠥ ꠟꠁꠀ ꠀꠅ, ");
INSERT INTO syls_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ꠔꠦ ꠄꠞꠟꠉꠦ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠢꠤꠡꠣꠛꠦ ꠍꠄ ꠡꠦꠞ ꠝꠄꠖꠣꠞꠦ ꠖꠥꠁ ꠡꠦꠞ ꠔꠦꠟꠖꠤ ꠝꠣꠈꠣꠁꠀ ꠈꠣꠁ ꠀꠘꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ꠀꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣꠞ ꠟꠣꠉꠤ ꠀꠋꠉꠥꠞꠞ ꠖꠥꠁ ꠡꠦꠞ ꠡꠞꠛꠔꠅ ꠀꠘꠔꠦ ꠅꠁꠛ। “ꠁꠔꠣ ꠅꠁꠟ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ, ꠁ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠀꠝꠤ ꠈꠥꠡꠤ ꠅꠁ। ");
INSERT INTO syls_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠞꠔꠦꠇ ꠉꠞꠥ, ꠝꠦꠠꠣ, ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠛꠣ ꠍꠣꠉꠟꠞꠦ ꠅꠃ ꠘꠤꠅꠝꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","ꠔꠥꠝꠞꠣ ꠎꠔ ꠙꠞꠤꠝꠣꠘ ꠙꠡꠥꠃ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅ ꠘꠣ ꠇꠦꠘꠦ, ꠙꠞꠔꠦꠇ ꠙꠡꠥꠞ ꠟꠉꠦ ꠅꠃ ꠘꠤꠅꠝꠦ ꠍꠖꠉꠣꠅ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ꠢꠥꠘꠅ, ꠀꠝꠤ ꠝꠣꠛꠥꠖꠞꠦ ꠈꠥꠡ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ, ꠎꠦꠇꠥꠘꠥ ꠊꠦꠞꠣꠘ ꠀꠟꠣ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠡꠝꠄ, ꠙꠞꠔꠦꠇ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠅꠃ ꠘꠤꠅꠝꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","ꠅꠁꠘ꠆ꠘ ꠎꠣꠔꠤꠞ ꠇꠥꠘꠥ ꠝꠥꠍꠣꠚꠤꠞ ꠛꠣ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠛꠡꠔ ꠇꠞꠞꠣ ꠇꠥꠘꠥ ꠜꠤꠘ-ꠖꠦꠡꠤꠄ ꠎꠥꠖꠤ, ꠀꠝꠣꠞꠦ ꠈꠥꠡ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠊꠦꠞꠣꠘ ꠀꠟꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠔ ꠌꠣꠄ, ꠔꠦ ꠢꠦ-ꠅ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠈꠣꠘ ꠄꠇꠁ ꠘꠤꠅꠝ ꠝꠣꠘꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠅꠃ ꠘꠤꠅꠝ ꠎꠣꠞꠤ ꠞꠁꠛ। ꠔꠥꠝꠞꠣꠞ ꠡꠝꠣꠎꠞ ꠢꠇꠟꠞ ꠟꠣꠉꠤ ꠅꠃ ꠘꠤꠅꠝ ꠌꠣꠟꠥ ꠞꠁꠛ, ꠁꠔꠣ ꠔꠥꠝꠞꠣ ꠅꠅ ꠛꠣ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠛꠡꠔ ꠇꠞꠞꠣ ꠜꠤꠘ-ꠖꠦꠡꠤ ꠅꠁꠟꠦꠅ, ꠢꠇꠟꠞ ꠟꠣꠉꠤꠃ ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠅꠃ ꠄꠇꠁ ꠘꠤꠅꠝ ꠎꠣꠞꠤ ꠞꠁꠛ। ꠁ ꠛꠦꠙꠣꠞꠦ ꠀꠝꠤ ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍꠦ ꠔꠥꠝꠞꠣ ꠎꠦꠟꠣ, ꠜꠤꠘ-ꠖꠦꠡꠤ ꠅꠇꠟꠅ ꠅꠃꠟꠣ, ꠢꠇꠟ ꠢꠝꠣꠘ। ");
INSERT INTO syls_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠎꠦ ꠛꠡꠔ ꠇꠞꠞꠣ ꠜꠤꠘ-ꠖꠦꠡꠤ ꠅꠇꠟꠞ ꠟꠣꠉꠤ ꠄꠇꠟꠣꠈꠣꠘ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠀꠞ ꠄꠇꠁ ꠡꠞꠤꠅꠔ ꠌꠣꠟꠥ ꠞꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠅ, ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦ ꠖꠦꠡꠅ ꠘꠤꠀꠞ, ꠢꠘꠅ ꠉꠤꠀ ꠢꠣꠞꠟꠦ, ");
INSERT INTO syls_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ꠔꠥꠝꠞꠣ ꠎꠦꠛꠟꠣ ꠢꠃ ꠖꠦꠡꠞ ꠚꠄ-ꠚꠡꠟ ꠈꠣꠁꠛꠣꠄ, ꠅꠃ ꠡꠝꠄ ꠔꠥꠝꠞꠣ ꠁꠔꠣꠞ ꠇꠤꠍꠥ ꠅꠋꠡ ꠀꠝꠣꠞ ꠖꠞꠛꠣꠞꠅ ꠍꠖꠉꠣ ꠢꠤꠡꠣꠛꠦ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","ꠔꠥꠝꠞꠣꠞ ꠈꠦꠔꠞ ꠙꠄꠟꠣ ꠖꠣꠅꠀ ꠚꠡꠟꠞ ꠝꠄꠖꠣ ꠖꠤꠀ ꠄꠇꠈꠣꠘ ꠞꠥꠐꠤ ꠛꠣꠘꠣꠁꠀ ꠀꠝꠣꠞ ꠘꠣꠝꠦ ꠍꠖꠉꠣ ꠖꠤꠛꠣꠄ। ꠉꠤꠞꠡ꠆ꠔ-ꠛꠣꠠꠤꠞ ꠍꠖꠉꠣꠞ ꠟꠣꠈꠣꠘ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","ꠙꠄꠟꠣ ꠖꠣꠅꠀ ꠚꠡꠟꠞ ꠅꠃ ꠍꠖꠉꠣ, ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠟꠤꠟ꠆ꠟꠣ-ꠍꠖꠉꠣ ꠢꠤꠡꠣꠛꠦ ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠘꠣꠝꠦ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ꠅ ꠝꠥꠍꠣ, ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠅ, ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠣꠞ ꠝꠣꠎꠖꠤ ꠎꠔ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠖꠤꠍꠤ, ꠔꠣꠞꠣ ꠎꠥꠖꠤ ꠘꠣ ꠎꠣꠘꠤꠀ ꠅꠔꠣ ꠇꠥꠘꠥ ꠄꠇꠐꠣ ꠢꠥꠇꠥꠝ ꠜꠣꠋꠉꠤꠟꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ꠁꠔꠣ ꠢꠇꠟ ꠢꠥꠇꠥꠝ ꠔ ꠖꠦꠅꠀꠞ ꠡꠝꠄ ꠕꠣꠇꠤ ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠎꠣꠞꠤ ꠞꠄ, ");
INSERT INTO syls_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ꠔꠦ ꠁ ꠅꠎꠣꠘꠣ ꠛꠦꠙꠣꠞꠐꠣ ꠎꠣꠘꠣꠞ ꠛꠣꠖꠦꠃ ꠀꠡ꠆ꠔꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠡꠝꠣꠎꠦ ꠝꠤꠟꠤꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠔꠦ ꠅꠁꠛ। ꠔꠣꠞꠣ ꠄꠇꠐꠣ ꠛꠤꠍꠣꠟ ꠖꠤꠀ ꠀꠝꠤ ꠝꠣꠛꠥꠖꠞꠦ ꠈꠥꠡ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠊꠦꠞꠣꠘ ꠀꠟꠣ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛ, ꠄꠞꠟꠉꠦ ꠘꠤꠅꠝ ꠝꠣꠚꠤꠇ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠀꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣ ꠖꠤꠛ। ꠀꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠍꠣꠉꠟꠅ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠀꠡ꠆ꠔꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠡꠝꠣꠎꠞ ꠅꠃ ꠅꠎꠣꠘꠣ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠛꠣ, ꠔꠦꠃ ꠔꠣꠞꠣ ꠝꠣꠚꠤ ꠙꠣꠁꠛꠣ। ꠔꠣꠞꠣ ꠔ ꠁꠌ꠆ꠍꠣ ꠇꠞꠤꠀ ꠁ ꠘꠣꠚꠞꠝꠣꠘꠤ ꠇꠞꠍꠦ ꠘꠣ, ꠔꠣꠞꠣꠞ ꠜꠥꠟꠞ ꠟꠣꠉꠤ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠅ ꠀꠖꠣꠄ ꠇꠞꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","ꠔꠦꠃ ꠀꠡ꠆ꠔꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠡꠝꠣꠎ ꠀꠞ ꠔꠣꠞꠣꠞ ꠝꠣꠎꠦ ꠛꠡꠔ ꠇꠞꠞꠣ ꠜꠤꠘ-ꠖꠦꠡꠤ ꠝꠣꠘꠡꠞꠦꠅ ꠝꠣꠚ ꠇꠞꠣ ꠅꠁꠛ, ꠎꠥꠖꠤꠅ ꠔꠣꠞꠣ ꠢꠇꠟꠦꠃ ꠁ ꠜꠥꠟ-ꠇꠍꠥꠞꠤ ꠇꠞꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ꠅꠁꠟꠦ ꠇꠦꠃ ꠎꠥꠖꠤ ꠈꠣꠟꠤ ꠄꠇꠟꠣ ꠜꠥꠟ ꠇꠞꠤꠀ ꠝꠘꠞ ꠅꠎꠣꠘ꠆ꠔꠦ ꠇꠥꠘꠥ ꠘꠣꠚꠞꠝꠣꠘꠤ ꠇꠞꠤꠟꠣꠄ, ꠔꠦ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠢꠦ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠄꠇꠐꠣ ꠍꠣꠉꠤ ꠟꠁꠀ ꠀꠎꠤꠞ ꠅꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","ꠀꠞ ꠎꠦ ꠎꠘꠦ ꠝꠘꠞ ꠅꠎꠣꠘ꠆ꠔꠦ ꠅꠃ ꠉꠥꠘꠣ ꠇꠞꠍꠦ, ꠁꠝꠣꠝ ꠍꠣꠛꠦ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠔꠣꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠛꠦꠛꠡ꠆ꠔꠣ ꠇꠞꠛꠣ। ꠅꠃ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠛꠥꠟ ꠅꠁꠟꠦ ꠢꠦ ꠝꠣꠚꠤ ꠙꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","ꠜꠥꠟ ꠇꠞꠤꠀ ꠝꠘꠞ ꠅꠎꠣꠘ꠆ꠔꠦ ꠎꠦ ꠝꠣꠘꠡꠦ ꠘꠣꠚꠞꠝꠣꠘꠤ ꠇꠞꠤꠟꠣꠄ, ꠅꠃ ꠟꠣꠈꠣꠘ ꠙꠞꠔꠦꠇ ꠝꠣꠘꠡꠞ ꠟꠣꠉꠤ ꠁ ꠘꠤꠅꠝ ꠌꠣꠟꠥ ꠞꠁꠛ, ꠢꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠅꠃꠇ, ꠛꠣ ꠜꠤꠘ-ꠖꠦꠡꠤ ꠅꠃꠇ, ꠄꠇꠁ ꠘꠤꠅꠝꠦ ꠌꠟꠛ। ");
INSERT INTO syls_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ꠅꠁꠟꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠛꠣ ꠔꠣꠞꠣꠞ ꠝꠣꠎꠦ ꠛꠡꠔ ꠇꠞꠞꠣ ꠅꠁꠘ꠆ꠘ ꠇꠥꠘꠥ ꠎꠣꠔꠤꠞ ꠇꠦꠃ ꠎꠥꠖꠤ ꠁꠌ꠆ꠍꠣ ꠇꠞꠤꠀ ꠇꠥꠘꠥ ꠘꠣꠚꠞꠝꠣꠘꠤ ꠇꠞꠦ, ꠔꠦ ꠢꠦ ꠡ꠆ꠛꠄꠅꠋ ꠝꠣꠛꠥꠖꠞꠦ ꠛꠦꠁꠎ꠆ꠎꠔ ꠇꠞꠦ। ꠁꠟꠣ ꠘꠣꠚꠞꠝꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠡꠝꠣꠎ ꠕꠣꠇꠤ ꠅꠉꠥꠞ ꠘꠣꠝ ꠝꠤꠐꠣꠁꠟꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝꠞꠦ ꠄꠟꠣꠝꠤ ꠇꠞꠣꠄ ꠀꠞ ꠘꠣꠚꠞꠝꠣꠘꠤ ꠇꠞꠣꠄ ꠅꠉꠥꠞ ꠘꠣꠝ ꠝꠤꠐꠣꠁꠟꠤꠔꠦ ꠅꠁꠛ, ꠔꠣꠞ ꠁ ꠉꠥꠘꠣꠞ ꠖꠣꠄ-ꠜꠣꠞ ꠔꠣꠞ ꠃꠙꠞꠦꠃ ꠛꠞ꠆ꠔꠣꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠍꠚꠞꠞ ꠇꠣꠟꠅ ꠄꠇ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞꠦ ꠄꠇꠎꠘ ꠝꠣꠘꠡꠞꠦ ꠖꠣꠞꠥ ꠔꠥꠛꠣꠘꠤꠔ ꠖꠦꠈꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞꠦ ꠖꠣꠞꠥ ꠔꠥꠛꠣꠘꠤꠔ ꠖꠦꠈꠣꠄ ꠅꠃ ꠝꠣꠘꠡꠦ ꠔꠣꠞꠦ ꠗꠞꠤꠀ ꠝꠥꠍꠣ ꠘꠛꠤ, ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘ ꠀꠞ ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠍꠣꠝꠘꠦ ꠟꠁꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ꠅꠃ ꠟꠣꠈꠣꠘ ꠝꠣꠘꠡꠞꠦ ꠇꠤꠔꠣ ꠇꠞꠔꠦ ꠅꠁꠛ, ꠁ ꠢꠥꠇꠥꠝ ꠔ ꠀꠟ꠆ꠟꠣꠄ ꠅꠈꠘꠅ ꠎꠣꠘꠣꠁꠍꠂꠘ ꠘꠣ, ꠄꠞꠟꠣꠉꠤ ꠄꠞꠦ ꠔꠣꠞꠣ ꠛꠘ꠆ꠖꠤ ꠇꠞꠤ ꠕꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","ꠅꠃ ꠡꠝꠄ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠎꠣꠘꠣꠁꠟꠣ, “ꠅꠃ ꠝꠣꠘꠡꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠤꠔꠦ ꠅꠁꠛ। ꠔꠣꠞꠦ ꠇꠦꠝ꠆ꠙꠞ ꠛꠣꠞꠦ ꠘꠤꠀ ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠙꠣꠔ꠆ꠔꠞꠖꠤ ꠁꠐꠣꠁꠀ ꠝꠣꠞꠤꠟꠤꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","ꠔꠦꠃ ꠝꠥꠍꠣꠞ ꠝꠣꠞꠚꠔꠦ ꠙꠣꠅꠀ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠔꠣꠞꠦ ꠇꠦꠝ꠆ꠙꠞ ꠛꠣꠞꠦ ꠘꠤꠀ ꠙꠣꠔ꠆ꠔꠞ ꠝꠣꠞꠤꠀ ꠝꠣꠞꠤꠟ꠆ꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠅ, ꠔꠥꠝꠞꠣ ꠎꠣꠞꠎꠤꠞ ꠟꠦꠛꠣꠍꠞ ꠙꠣꠁꠠꠅ ꠎꠣꠎꠁꠞ ꠟꠣꠉꠣꠅ, ꠀꠞ ꠎꠣꠎꠁꠞꠞ ꠙꠞꠔꠦꠇ ꠉꠤꠐꠞꠦ ꠟꠤꠟꠥꠀ ꠡꠥꠔꠣꠖꠤ ꠙꠦꠌꠣꠁꠀ ꠝꠥꠟ ꠇꠣꠙꠠꠞ ꠟꠉꠦ ꠎꠥꠠꠣ ꠖꠤꠅ। ꠁ ꠢꠥꠇꠥꠝ ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠝꠣꠘꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","ꠁ ꠎꠣꠎꠁꠞ ꠟꠣꠉꠣꠘꠤꠞ ꠇꠣꠞꠘ ꠅꠁꠟ, ꠅꠔꠣꠞ ꠛꠣꠄ ꠌꠣꠁꠟꠦ ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠢꠇ꠆ꠇꠟ ꠢꠥꠇꠥꠝꠞ ꠇꠕꠣ ꠁꠀꠖ ꠇꠞꠤꠀ ꠅꠔꠣ ꠀꠝꠟ ꠇꠞꠛꠣꠄ। ꠔꠦꠃ ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠟꠉꠦ ꠇꠥꠘꠥ ꠛꠦꠁꠝꠣꠘꠤ ꠇꠞꠔꠣꠄ ꠘꠣꠄ, ꠔꠥꠝꠞꠣꠞ ꠌꠃꠈꠞ ꠀꠞ ꠖꠤꠟꠞ ꠛꠖ ꠈꠣꠁꠡꠞ ꠀꠔꠅ ꠘꠤꠎꠞꠦ ꠡꠙꠤꠔꠣꠄ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","ꠀꠝꠣꠞ ꠢꠇꠟ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠀꠝꠟ ꠇꠞꠣꠞ ꠇꠕꠣ ꠔꠥꠝꠞꠣꠞ ꠁꠀꠖ ꠞꠁꠛ, ꠔꠥꠝꠞꠣꠞ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠦ ꠔꠥꠝꠞꠣ ꠙꠣꠇ-ꠙꠞꠦꠎꠉꠣꠞ ꠛꠘ꠆ꠖꠣꠞ ꠢꠣꠟꠔꠦ ꠞꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣ। ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠅꠀꠞ ꠈꠤꠀꠟꠦ, ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠍꠤ। ꠀꠝꠤꠃ ꠀꠟ꠆ꠟꠣ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ।” ");
INSERT INTO syls_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","2","ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠇꠥꠞꠣꠢꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠖꠥꠡꠝꠘꠤ ꠟꠣꠉꠣꠁꠟ। ꠅꠃ ꠇꠥꠞꠣꠢ ꠅꠁꠟ ꠇꠣꠢꠣꠔꠤ ꠉꠥꠡ꠆ꠐꠤꠞ ꠁꠎꠢꠣꠞꠞ ꠙꠥꠀ। ꠔꠣꠞ ꠟꠉꠦ ꠞꠥꠛꠦꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠁꠟꠤꠀꠛꠞ ꠙꠥꠀ ꠖꠣꠕꠘ ꠀꠞ ꠀꠛꠤꠞꠣꠝ, ꠀꠞ ꠚꠟꠦꠔꠞ ꠙꠥꠀ ꠅꠃꠘꠦꠅ ꠝꠥꠍꠣ ꠘꠛꠤꠞ ꠛꠤꠞꠥꠗꠤꠔꠣ ꠇꠞꠟ। ꠄꠞꠣꠞ ꠖꠟꠅ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠀꠞꠅ ꠀꠠꠣꠁ-ꠡ ꠎꠘ ꠘꠣꠝꠇꠞꠣ ꠝꠥꠞꠛ꠆ꠛꠤ ꠘꠦꠔꠣꠅ ꠡꠞꠤꠇ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","ꠅꠁꠀ ꠔꠣꠞꠣ ꠖꠟ ꠛꠣꠘ꠆ꠖꠤꠀ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠔ ꠈꠥꠛ ꠛꠦꠡꠤ ꠛꠣꠠꠣꠛꠣꠠꠤ ꠇꠞꠞꠣꠄ। ꠀꠡ꠆ꠔꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠙꠞꠔꠦꠇ ꠝꠣꠘꠥꠡꠃ ꠎꠦꠛꠟꠣ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ, ꠝꠣꠛꠥꠖꠅ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠀꠍꠂꠘ। ꠔꠦ ꠔꠥꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠛꠘ꠆ꠖꠣ ꠅꠇꠟꠞ ꠃꠙꠞꠦ ꠃꠡ꠆ꠔꠣꠖꠤ ꠇꠞꠞꠣꠄ ꠇꠦꠘꠦ?” ");
INSERT INTO syls_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠝꠥꠍꠣ ꠘꠛꠤ ꠃꠚꠁꠔ ꠅꠁꠀ ꠝꠣꠐꠤꠔ ꠙꠠꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠇꠥꠞꠣꠢ ꠀꠞ ꠔꠣꠞ ꠖꠟꠞ ꠝꠣꠘꠡꠞꠦ ꠇꠁꠟꠣ, “ꠇꠣꠁꠟ ꠛꠤꠀꠘꠦꠃ ꠝꠣꠛꠥꠖꠦ ꠖꠦꠈꠣꠁꠛꠣ, ꠇꠦ ꠔꠣꠘ ꠛꠘ꠆ꠖꠣ, ꠀꠞ ꠇꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ। ꠔꠣꠁꠘ ꠎꠣꠞꠦ ꠙꠍꠘ꠆ꠖ ꠇꠞꠂꠘ, ꠈꠣꠟꠤ ꠔꠣꠞꠣꠞꠦꠃ ꠔꠣꠘ ꠇꠣꠍꠣꠔ ꠀꠁꠔꠦ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","7","ꠅ ꠇꠥꠞꠣꠢ, ꠢꠥꠘꠅ, ꠔꠥꠝꠤ ꠀꠞ ꠔꠥꠝꠣꠞ ꠟꠉꠞ ꠢꠇꠟꠦ ꠄꠇ ꠇꠣꠝ ꠇꠞꠅ, ꠍꠣꠝꠘꠞ ꠇꠣꠁꠟ ꠔꠥꠝꠞꠣ ꠢꠇꠟꠦ ꠄꠇꠐꠣ ꠇꠞꠤ ꠀꠉꠞ ꠖꠣꠘꠤ ꠟꠁꠀ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠅ। ꠔꠣꠁꠘ ꠎꠣꠞꠦ ꠙꠍꠘ꠆ꠖ ꠇꠞꠛꠣ, ꠛꠥꠎꠤꠟꠤꠅ ꠢꠦ-ꠃ ꠔꠣꠘ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠛꠘ꠆ꠖꠣ। ꠔꠥꠝꠞꠣ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠥꠡ ꠔ ꠛꠦꠡꠤ ꠛꠣꠠꠤꠉꠦꠍꠦ।” ");
INSERT INTO syls_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","ꠝꠥꠍꠣꠄ ꠔꠣꠞꠦ ꠄꠅꠈꠣꠘ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠟꠦꠛꠤ ꠅꠇꠟꠦ ꠀꠝꠣꠞ ꠄꠇꠈꠣꠘ ꠇꠕꠣ ꠢꠥꠘꠅ। ");
INSERT INTO syls_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","ꠔꠥꠝꠞꠣ ꠝꠘꠅ ꠇꠞꠞꠣꠄ ꠘꠤ ꠝꠣꠛꠥꠖꠞ ꠇꠣꠛꠣ ꠊꠞꠅ ꠄꠛꠣꠖꠔꠤ ꠇꠞꠣ ꠀꠞ ꠡꠝꠣꠎꠞ ꠝꠣꠘꠡꠞ ꠈꠦꠎꠝꠔ ꠇꠞꠣ ꠁꠔꠣ ꠄꠇ꠆ꠇꠦꠞꠦ ꠢꠥꠞꠥ-ꠝꠥꠞꠥ ꠛꠦꠙꠣꠞ? ꠢꠥꠘꠅ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠀꠟ꠆ꠟꠣꠄ ꠡꠝꠣꠎꠞ ꠅꠁꠘ꠆ꠘꠣꠁꠘ꠆ꠘ ꠝꠣꠘꠥꠡ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠛꠣꠍꠤꠀ ꠘꠤꠀ, ꠔꠣꠘ ꠘꠤꠎꠞ ꠖꠤꠖꠣꠞꠅ ꠀꠘꠍꠂꠘ, ꠎꠣꠔꠦ ꠔꠥꠝꠞꠣ ꠅꠃ ꠇꠣꠝ ꠇꠞꠅ। ");
INSERT INTO syls_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","ꠔꠣꠁꠘ ꠔ ꠔꠥꠝꠣꠞꠦ ꠀꠞ ꠅꠁꠘ꠆ꠘꠣꠁꠘ꠆ꠘ ꠟꠦꠛꠤ ꠅꠇꠟꠞꠦ ꠘꠤꠎꠞ ꠗꠣꠞꠅ ꠀꠁꠛꠣꠞ ꠡꠥꠎꠥꠉ ꠖꠤꠍꠂꠘ, ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣ ꠖꠦꠈꠤꠀꠞ ꠁꠝꠣꠝꠔꠤꠞ ꠙꠖꠞꠦꠅ ꠖꠈꠟ ꠇꠞꠔꠣꠄ ꠌꠣꠁꠞꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","ꠢꠣꠞꠥꠘ ꠀꠞ ꠇꠥꠘ ꠝꠣꠘꠥꠡ ꠎꠦꠘ, ꠔꠥꠝꠞꠣ ꠔꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠛꠇꠣ-ꠎꠇꠣ ꠇꠞꠞꠣꠄ? ꠔꠥꠝꠤ ꠀꠞ ꠔꠥꠝꠣꠞ ꠖꠟꠞ ꠝꠣꠘꠡꠦ ꠔ ꠝꠣꠛꠥꠖꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦꠃ ꠖꠟ ꠛꠣꠘ꠆ꠖꠤꠍ।” ");
INSERT INTO syls_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","ꠄꠞꠣꠞ ꠛꠣꠖꠦ ꠝꠥꠍꠣꠄ ꠈꠛꠞ ꠖꠤꠟꠣ, ꠁꠟꠤꠀꠛꠞ ꠖꠥꠁ ꠙꠥꠀ ꠖꠣꠕꠘ ꠀꠞ ꠀꠛꠤꠞꠣꠝ ꠀꠁꠔꠣ ꠇꠞꠤ, ꠅꠁꠟꠦ ꠔꠣꠞꠣ ꠎꠣꠘꠣꠁꠟ, “ꠀꠝꠞꠣ ꠅꠔ ꠑꠦꠇꠣꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","ꠔꠥꠝꠤ ꠅꠃ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠀꠘꠤꠀ ꠝꠣꠞꠔꠣꠄ ꠇꠞꠤ, ꠖꠥꠗ ꠀꠞ ꠝꠃꠞ ꠜꠣꠘ꠆ꠒꠣꠞ ꠀꠟꠣ ꠢꠃ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠀꠝꠞꠣꠞꠦ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠍ, ꠢꠤ ꠖꠦꠡꠅ ꠔ ꠇꠥꠘ꠆ꠔꠣꠞꠃ ꠅꠜꠣꠛ ꠀꠍꠤꠟ ꠘꠣ। ꠄꠞ ꠛꠣꠖꠦꠅ ꠀꠝꠞꠣꠞ ꠃꠙꠞꠦ ꠛꠦꠐꠣꠉꠤꠞꠤ ꠖꠦꠈꠣꠘꠤꠔ ꠟꠣꠉꠍ। ");
INSERT INTO syls_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","ꠀꠞ ꠔꠥꠝꠤ ꠔ ꠀꠝꠞꠣꠞꠦ ꠢꠃ ꠟꠣꠈꠣꠘ ꠇꠥꠘꠥ ꠖꠥꠗ ꠀꠞ ꠝꠃꠞ ꠜꠣꠘ꠆ꠒꠣꠞ ꠀꠟꠣ ꠖꠦꠡꠅ-ꠅ ꠘꠤꠍ ꠘꠣ, ꠇꠥꠘꠥ ꠎꠝꠤ-ꠎꠝꠣ ꠛꠣ ꠀꠋꠉꠥꠞ ꠛꠣꠉꠣꠘꠞ ꠝꠣꠟꠤꠇꠣꠘꠣꠅ ꠖꠤꠍ ꠘꠣ। ꠔꠥꠝꠤ ꠁꠔꠣ ꠝꠣꠘꠡꠞꠦ ꠀꠘ꠆ꠖꠣ ꠛꠣꠘꠣꠁꠀ ꠞꠣꠈꠔꠣꠄ ꠌꠣꠅ ꠘꠤ? ꠘꠣ, ꠀꠝꠞꠣ ꠎꠣꠁꠔꠣꠝ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","ꠁꠔꠣ ꠢꠥꠘꠤꠀ ꠝꠥꠍꠣ ꠈꠥꠛ ꠉꠞꠝ ꠅꠁꠀ ꠝꠣꠛꠥꠖꠞꠦ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖ, ꠔꠥꠝꠤ ꠄꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠛꠥꠟ ꠇꠞꠤꠅ ꠘꠣ। ꠀꠝꠤ ꠔ ꠔꠣꠞꠣꠞ ꠇꠥꠘꠥ ꠈꠦꠔꠤ ꠇꠞꠍꠤ ꠘꠣ, ꠔꠣꠞꠣꠞ ꠄꠉꠥ ꠉꠣꠗꠣꠅ ꠀꠝꠤ ꠘꠤꠍꠤ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","ꠛꠣꠖꠦ ꠝꠥꠍꠣꠄ ꠇꠥꠞꠣꠢꠞꠦ ꠇꠁꠟꠣ, “ꠇꠣꠁꠟ ꠔꠥꠝꠤ ꠀꠞ ꠔꠥꠝꠣꠞ ꠖꠟꠞ ꠢꠇꠟ ꠀꠁꠀ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠀꠎꠤꠞ ꠅꠁꠛꠣꠄ। ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠢꠣꠞꠥꠘꠅ ꠀꠎꠤꠞ ꠅꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","ꠙꠞꠔꠦꠇꠦ ꠀꠁꠀ ꠎꠣꠞꠎꠤꠞ ꠀꠉꠞ ꠖꠣꠘꠤꠔ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠜꠞꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠎꠣꠟꠣꠁꠛꠣꠄ। ꠔꠥꠝꠞꠣꠞ ꠀꠠꠣꠁ-ꠡ ꠎꠘꠞ ꠢꠇ꠆ꠇꠟꠦ ꠅꠟꠣ ꠎꠣꠞꠎꠤꠞ ꠀꠉꠞ ꠖꠣꠘꠤ ꠎꠣꠟꠣꠁꠅ। ꠄꠞꠟꠉꠦ ꠔꠥꠝꠤ ꠀꠞ ꠢꠣꠞꠥꠘꠦꠅ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠁꠅ।” ");
INSERT INTO syls_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","ꠝꠥꠍꠣꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠙꠞꠔꠦꠇꠦ ꠎꠣꠞꠎꠤꠞ ꠀꠉꠞ ꠖꠣꠘꠤꠔ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠀꠞ ꠀꠉꠥꠁꠘ ꠟꠁꠀ, ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠍꠣꠝꠘꠦ, ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞ ꠟꠉꠦ ꠉꠤꠀ ꠃꠛꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","ꠇꠥꠞꠣꠢꠦ ꠎꠦꠛꠟꠣ ꠡꠝꠣꠎꠞ ꠢꠇꠟ ꠝꠣꠘꠡꠞꠦ ꠃꠡ꠆ꠇꠣꠁꠀ ꠖꠟꠣ ꠇꠞꠟ, ꠇꠞꠤꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠉꠦꠍꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠃꠛꠣꠁꠟ, ꠅꠃ ꠡꠝꠄ ꠔꠣꠞꠣ ꠢꠇ꠆ꠇꠟꠞ ꠍꠣꠝꠘꠦ ꠝꠣꠛꠥꠖꠞ ꠇꠥꠖꠞꠔꠤ ꠘꠥꠞ ꠎꠣꠁꠞ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“ꠁꠔꠣ ꠝꠣꠘꠡꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣ ꠢꠞꠤ ꠎꠣꠅ, ꠀꠝꠤ ꠁꠔꠣꠞꠦ ꠌꠈꠥꠞ ꠙꠟꠇꠞ ꠟꠉꠦ ꠡꠦꠡ ꠇꠞꠤꠟꠤꠀꠞ।” ");
INSERT INTO syls_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","ꠅꠁꠟꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘ ꠍꠁꠎꠖꠣꠔ ꠙꠠꠤꠀ ꠇꠁꠟꠣ, “ꠅ ꠀꠟ꠆ꠟꠣ, ꠔꠥꠝꠤ ꠔ ꠢꠇꠟ ꠝꠣꠘꠡꠞ ꠜꠤꠔꠞꠦ ꠎꠣꠘ ꠖꠦꠅ। ꠅꠈꠘ ꠈꠣꠟꠤ ꠄꠇꠎꠘꠞ ꠘꠣꠚꠞꠝꠣꠘꠤꠞ ꠖꠣꠄ ꠀꠡ꠆ꠔꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠃꠙꠞꠦ ꠔꠥꠝꠤ ꠉꠎꠛ ꠓꠣꠟꠤꠔꠣꠄ ꠘꠤ?” ");
INSERT INTO syls_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","ꠔꠦꠃ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠔꠣꠞꠣ ꠎꠣꠘꠥ ꠇꠥꠞꠣꠢ, ꠖꠣꠕꠘ ꠀꠞ ꠀꠛꠤꠞꠣꠝꠞ ꠔꠣꠝ꠆ꠛꠥꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠢꠞꠤ ꠎꠣꠁꠘ।” ");
INSERT INTO syls_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠝꠥꠍꠣ ꠍꠁꠎꠖꠣ ꠕꠣꠇꠤ ꠃꠑꠤꠀ ꠖꠣꠕꠘ ꠀꠞ ꠀꠛꠤꠞꠣꠝꠞ ꠉꠦꠍꠦ ꠉꠦꠟꠣ, ꠔꠣꠘ ꠈꠞꠦ ꠅꠁꠀ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠥꠞꠛ꠆ꠛꠤ ꠘꠦꠔꠣ ꠅꠇꠟꠅ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","ꠔꠣꠁꠘ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠅꠃ ꠘꠣꠚꠞꠝꠣꠘ ꠅꠇꠟꠞ ꠔꠣꠝ꠆ꠛꠥ ꠕꠣꠇꠤ ꠢꠞꠤ ꠎꠣꠅ, ꠁꠔꠣꠞ ꠇꠥꠘꠥ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣꠔ ꠍꠁꠅ ꠘꠣ। ꠀꠞꠘꠣꠄ ꠔꠣꠞꠣꠞ ꠉꠥꠘꠣꠞ ꠡꠣꠎꠣꠞ ꠟꠉꠦ ꠔꠥꠝꠞꠣꠞꠦꠅ ꠛꠤꠘꠣꠡ ꠇꠞꠣ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠇꠥꠞꠣꠢ, ꠖꠣꠕꠘ ꠀꠞ ꠀꠛꠤꠞꠣꠝꠞ ꠔꠣꠝ꠆ꠛꠥꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠢꠇꠟ ꠝꠣꠘꠥꠡ ꠢꠞꠤ ꠉꠦꠟꠣ। ꠄꠞꠝꠣꠎꠦ ꠖꠣꠕꠘ ꠀꠞ ꠀꠛꠤꠞꠣꠝꠦ ꠔꠣꠞꠣꠞ ꠛꠃ-ꠛꠣꠁꠌ꠆ꠌꠣꠁꠘ ꠀꠞ ꠢꠥꠞꠥ-ꠛꠠ ꠢꠇꠟ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ ꠟꠁꠀ ꠀꠁꠀ ꠎꠣꠞꠎꠤꠞ ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠉꠦꠍꠦ ꠃꠛꠣꠔ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","ꠅꠃ ꠡꠝꠄ ꠝꠥꠍꠣꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠅꠃ ꠀꠟꠣꠝꠔ ꠖꠦꠈꠤꠀ ꠛꠥꠎꠤꠟꠤꠛꠣꠄ, ꠀꠝꠤ ꠎꠦꠔꠣ ꠇꠞꠤꠀꠞ ꠁꠔꠣ ꠀꠝꠣꠞ ꠝꠘꠉꠠꠣ ꠇꠥꠘ꠆ꠔꠣ ꠘꠣꠄ। ꠅꠃ ꠇꠣꠝꠞ ꠟꠣꠉꠤ ꠝꠣꠛꠥꠖꠦꠃ ꠀꠝꠣꠞꠦ ꠙꠣꠑꠣꠁꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","ꠄꠞꠣꠞ ꠝꠞꠘ ꠎꠥꠖꠤ ꠅꠁꠘ꠆ꠘꠣꠁꠘ꠆ꠘ ꠝꠣꠘꠡꠞ ꠟꠣꠈꠣꠘ ꠡ꠆ꠛꠣꠜꠣꠛꠤꠇ ꠢꠣꠟꠔꠦ ꠅꠄ, ꠔꠦ ꠝꠘꠅ ꠇꠞꠤꠅ, ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞꠦ ꠙꠣꠑꠣꠁꠍꠂꠘ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","ꠅꠁꠟꠦ ꠝꠣꠛꠥꠖꠦ ꠎꠥꠖꠤ ꠀꠌꠣꠘꠇ ꠘꠄꠀ ꠇꠥꠘꠥ ꠇꠣꠝ ꠇꠞꠂꠘ, ꠅꠃ ꠎꠝꠤꠘꠦ ꠝꠥꠈ ꠈꠥꠟꠤꠀ ꠔꠣꠞꠣꠞꠦ ꠀꠞ ꠔꠣꠞꠣꠞ ꠢꠇꠟꠔꠣꠞꠦ ꠎꠤꠘ꠆ꠖꠣ ꠉꠤꠟꠤꠟꠣꠄ, ꠔꠣꠞꠣ ꠎꠤꠘ꠆ꠖꠣ ꠢꠣꠟꠔꠦꠃ ꠝꠣꠐꠤꠞ ꠔꠟꠞ ꠙꠣꠔꠣꠟꠅ ꠎꠣꠄꠉꠤ, ꠔꠦ ꠛꠥꠎꠤꠟꠤꠅ, ꠄꠞꠣ ꠝꠣꠛꠥꠖꠞꠦ ꠄꠟꠣꠝꠤ ꠇꠞꠍꠦ।” ");
INSERT INTO syls_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","ꠝꠥꠍꠣꠄ ꠅꠈꠣꠘ ꠇꠅꠀꠞ ꠟꠉꠦ ꠟꠉꠦꠃ ꠄꠞꠣꠞ ꠙꠣꠅꠞ ꠔꠟꠞ ꠝꠣꠐꠤ ꠚꠣꠐꠤꠀ ꠖꠥꠁ ꠛꠣꠐ ꠅꠁꠉꠦꠟ, ");
INSERT INTO syls_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ꠀꠞ ꠝꠣꠐꠤꠄ ꠀ ꠇꠞꠤꠀ ꠇꠥꠞꠣꠢꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠢꠇꠟꠞꠦ ꠔꠣꠞꠣꠞ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠡꠢ ꠉꠤꠟꠤꠟꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠡꠥꠖ꠆ꠖꠣ ꠎꠤꠘ꠆ꠖꠣ ꠢꠣꠟꠔꠦ ꠔꠣꠞꠣ ꠝꠣꠐꠤꠞ ꠔꠟꠦ ꠉꠦꠟꠉꠤ, ꠛꠣꠖꠦ ꠝꠣꠐꠤꠞ ꠚꠣꠐꠣ ꠛꠘ꠆ꠖ ꠅꠁꠉꠦꠟ। ꠅꠃꠟꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠕꠣꠇꠤ ꠔꠣꠞꠣ ꠄꠇꠖꠝ ꠘꠤꠙꠣꠔ ꠅꠁꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","ꠔꠣꠞꠣꠞ ꠌꠤꠇ-ꠌꠤꠟ꠆ꠟꠣꠘꠤ ꠢꠥꠘꠤꠀ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠕꠣꠇꠤ ꠢꠇꠟ ꠝꠣꠘꠥꠡ ꠖꠃꠠꠣꠁꠀ ꠜꠣꠉꠤꠟꠣ, ꠁꠔꠣꠄ ꠌꠤꠟ꠆ꠟꠣꠁ ꠌꠤꠟ꠆ꠟꠣꠁ ꠖꠃꠠꠣꠁꠀ ꠇꠁꠟꠣ, “ꠝꠣꠐꠤꠄ ꠢꠄꠔ ꠀꠝꠞꠣꠞꠦꠅ ꠉꠤꠟꠤꠟꠤꠛ।” ");
INSERT INTO syls_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","ꠀꠞ ꠢꠃ ꠎꠦ ꠀꠠꠣꠁ-ꠡ ꠎꠘꠦ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠁꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠞꠍꠤꠟ, ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠉꠣꠁꠛꠤ ꠀꠉꠥꠁꠘ ꠀꠁꠀ ꠁꠔꠣꠞꠦ ꠎꠣꠟꠣꠁꠀ ꠍꠣꠟꠤ ꠇꠞꠤꠟ꠆ꠟ। ");
INSERT INTO syls_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“ꠔꠥꠝꠤ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠙꠥꠀ ꠀꠟꠤ-ꠀꠎꠞꠞꠦ ꠇꠅ, ꠅꠃ ꠎꠣꠟꠣꠁꠟ ꠎꠣꠉꠣ ꠕꠣꠇꠤ ꠀꠉꠞ ꠖꠣꠘꠤ ꠉꠥꠁꠘ ꠛꠣꠞ ꠇꠞꠤꠀ, ꠄꠞ ꠀꠋꠞꠣ-ꠍꠣꠟꠤ ꠘꠤꠀ ꠕꠥꠠꠣ ꠖꠥꠞꠁ ꠚꠣꠟꠣꠘꠤꠞ ꠟꠣꠉꠤ, ꠁ ꠀꠉꠞ ꠖꠣꠘꠤ ꠉꠥꠁꠘ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠛꠘꠤꠉꠦꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","ꠘꠣꠚꠞꠝꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠎꠦꠉꠥꠁꠘ ꠝꠞꠤꠉꠦꠍꠂꠘ, ꠅꠃ ꠀꠉꠞ ꠖꠣꠘꠤ ꠔ ꠔꠣꠞꠣꠞ ꠀꠍꠤꠟ। ꠅꠁꠟꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠁꠔꠣ ꠀꠎꠤꠞ ꠇꠞꠣ ꠅꠁꠍꠤꠟ, ꠄꠞꠟꠣꠉꠤ ꠁ ꠢꠇꠟꠐꠤ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠅꠁꠉꠦꠍꠦ। ꠔꠦ ꠔꠥꠝꠤ ꠁꠔꠣ ꠜꠣꠋꠉꠣꠁꠀ ꠙꠣꠔ ꠛꠣꠘꠣꠁꠀ ꠙꠛꠤꠔ꠆ꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞꠦ ꠉꠥꠞꠤꠀ ꠕꠁꠅ। ꠁꠔꠣ ꠘꠤꠡꠣꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠉꠦꠍꠦ ꠞꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","ꠔꠦꠃ ꠀꠉꠥꠁꠘꠦ ꠎꠟꠤꠀ ꠎꠦꠉꠥꠁꠘ ꠝꠞꠍꠤꠟꠣ, ꠅꠔꠣꠞ ꠀꠘꠣ ꠙꠤꠔꠟꠞ ꠀꠉꠞ ꠖꠣꠘꠤ ꠉꠥꠁꠘ ꠁꠝꠣꠝ ꠀꠟꠤ-ꠀꠎꠞꠦ ꠄꠇꠈꠣꠘꠅ ꠖꠟꠣ ꠇꠞꠟꠣ। ꠛꠣꠖꠦ ꠅꠔꠣ ꠜꠣꠋꠉꠣꠁꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠉꠥꠞꠤꠀ ꠕꠅꠀꠞ ꠙꠣꠔ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞ ꠝꠣꠎꠖꠤ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠄꠁꠘ ꠅꠃ ꠟꠣꠈꠣꠘ ꠇꠞꠟꠣ। ꠁꠇꠐꠣ ꠇꠞꠣ ꠅꠁꠟ ꠎꠣꠔꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠘꠅ ꠕꠣꠇꠦ ꠎꠦꠘ, ꠈꠣꠟꠤ ꠢꠣꠞꠥꠘꠞ ꠛꠋꠡ ꠍꠣꠠꠣ ꠖꠥꠍꠞꠣ ꠇꠥꠘꠥ ꠎꠘ, ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠎꠣꠁꠔ ꠙꠣꠞꠔ ꠘꠣꠄ। ꠎꠥꠖꠤ ꠎꠣꠄ, ꠔꠦ ꠔꠣꠞ ꠖꠡꠣ ꠅꠃ ꠇꠥꠞꠣꠢ ꠀꠞ ꠔꠣꠞ ꠖꠟꠞ ꠟꠣꠈꠣꠘ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","ꠅꠁꠟꠦ ꠛꠣꠖꠞ ꠖꠤꠘꠃ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠘꠡꠦ ꠢꠎꠞꠔ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠛꠦꠞ-ꠛꠦꠞꠤ ꠟꠣꠉꠣꠁꠟ, ꠔꠣꠞꠣ ꠇꠁꠟ, “ꠝꠣꠛꠥꠖꠞ ꠛꠘ꠆ꠖꠣ ꠅꠇꠟꠞꠦ ꠔꠥꠝꠞꠣꠃ ꠝꠣꠞꠍ।” ");
INSERT INTO syls_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","ꠀꠞ ꠡꠝꠣꠎꠞ ꠢꠇꠟ ꠝꠣꠘꠡꠦ ꠎꠦꠛꠟꠣ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞ ꠛꠤꠞꠥꠗꠤꠔꠣ ꠇꠞꠤꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠝꠥꠈꠣ ꠊꠥꠞꠤꠀ ꠃꠛꠣꠁꠟ, ꠅꠃ ꠡꠝꠄ ꠢꠃ ꠉꠣꠁꠛꠤ ꠝꠦꠊꠞ ꠈꠥꠐꠤꠄ ꠀꠈꠔꠣꠃ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥ ꠉꠥꠞꠤ ꠉꠦꠟ, ꠝꠣꠛꠥꠖꠞ ꠇꠥꠖꠞꠔꠤ ꠘꠥꠞ ꠎꠣꠁꠞ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","ꠔꠦꠃ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠍꠣꠝꠘꠦ ꠉꠦꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“ꠁꠔꠣ ꠝꠣꠘꠡꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣ ꠢꠞꠤ ꠎꠣꠅ, ꠀꠝꠤ ꠁꠔꠣꠞꠦ ꠌꠈꠥꠞ ꠙꠟꠇꠞ ꠟꠉꠦ ꠡꠦꠡ ꠇꠞꠤꠟꠤꠀꠞ।” ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀꠃ ꠔꠣꠞꠣ ꠖꠥꠁꠅ ꠎꠘ ꠍꠁꠎꠖꠣꠔ ꠙꠠꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","ꠛꠣꠖꠦ ꠝꠥꠍꠣꠄ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠀꠉꠞ ꠖꠣꠘꠤ ꠀꠔꠅ ꠟꠅ, ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠕꠣꠇꠤ ꠀꠉꠥꠁꠘ ꠘꠦꠅ, ꠘꠤꠀ ꠄꠞ ꠃꠙꠞꠦ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠁꠀ, ꠎꠟꠖꠤ ꠇꠞꠤ ꠅꠔꠣ ꠝꠣꠘꠡꠞ ꠉꠥꠘꠣ ꠝꠣꠚꠤꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠅ। ꠝꠣꠛꠥꠖ ꠔ ꠉꠥꠍꠣꠄ ꠀꠉꠥꠁꠘ ꠅꠁꠉꠦꠍꠂꠘ, ꠔꠣꠘ ꠟꠣꠘ꠆ꠘꠔꠤ ꠝꠢꠣꠝꠣꠞꠤ ꠡꠥꠞꠥ ꠅꠁꠉꠦꠍꠦ।” ");
INSERT INTO syls_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","ꠔꠦꠃ ꠝꠥꠍꠣꠞ ꠇꠕꠣꠝꠔ ꠢꠣꠞꠥꠘꠦ ꠀꠉꠞ ꠖꠣꠘꠤꠔ ꠀꠉꠥꠁꠘ ꠀꠞ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠟꠁꠀ ꠔꠣꠞꠣꠞ ꠉꠦꠍꠦ ꠖꠃꠠꠣꠁꠀ ꠉꠦꠟꠣ। ꠄꠞ ꠝꠣꠎꠦꠃ ꠁꠔꠣꠞ ꠃꠙꠞꠦ ꠉꠎꠛ ꠡꠥꠞꠥ ꠅꠁꠉꠦꠍꠤꠟ, ꠅꠁꠟꠦ ꠢꠣꠞꠥꠘꠦ ꠀꠉꠞ-ꠈꠥꠡꠛꠄ ꠎꠣꠟꠣꠁꠀ ꠔꠣꠞꠣꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","ꠔꠣꠁꠘ ꠎꠤꠘ꠆ꠖꠣ ꠀꠞ ꠝꠥꠞ꠆ꠖꠣ ꠎꠘꠞ ꠝꠣꠎꠈꠣꠘꠅ ꠃꠛꠣꠁꠟꠣ, ꠄꠞꠟꠣꠉꠤ ꠉꠎꠛ ꠛꠘ꠆ꠖ ꠅꠁꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","ꠇꠥꠞꠣꠢꠞ ꠘꠣꠚꠞꠝꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠎꠦꠔꠣ ꠝꠣꠞꠣ ꠉꠦꠍꠟꠣ, ꠁꠉꠥꠁꠘ ꠛꠣꠖꠦꠅ ꠀꠞꠅ ꠌꠃꠖ꠆ꠖ ꠀꠎꠣꠞ ꠡꠣꠔ-ꠡ ꠝꠣꠘꠥꠡ ꠉꠎꠛꠤ ꠝꠢꠣꠝꠣꠞꠤꠄ ꠝꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","ꠝꠢꠣꠝꠣꠞꠤ ꠛꠘ꠆ꠖ ꠅꠁꠀ ꠢꠣꠞꠟꠦ ꠢꠣꠞꠥꠘ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠉꠦꠍꠦ ꠝꠥꠍꠣꠞ ꠗꠣꠞꠅ ꠚꠤꠞꠤꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠅ, ꠔꠣꠞꠣ ꠎꠣꠘꠥ ꠔꠣꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠈꠣꠘ꠆ꠖꠣꠘ ꠢꠤꠡꠣꠛꠦ ꠙꠞꠔꠦꠇ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠄꠇꠐꠣ ꠇꠞꠤ ꠝꠥꠐ ꠛꠣꠞꠅꠐꠣ ꠟꠣꠑꠤ ꠀꠘꠤꠀ ꠔꠥꠝꠣꠞ ꠉꠦꠍꠦ ꠖꠦꠄ। ꠖꠤꠟꠦ ꠔꠥꠝꠤ ꠎꠣꠞꠎꠤꠞ ꠟꠣꠑꠤꠞ ꠃꠙꠞꠦ ꠅꠃ ꠎꠘꠞ ꠘꠣꠝ ꠟꠦꠈꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠟꠣꠑꠤꠔ ꠟꠦꠈꠤꠅ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠘꠣꠝ, ꠅꠟꠣ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠈꠣꠘ꠆ꠖꠣꠘ ꠝꠣꠚꠤꠇ ꠙꠞꠔꠦꠇ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞꠞ ꠟꠣꠉꠤ ꠄꠇꠅꠐꠣ ꠟꠣꠑꠤ ꠕꠣꠇꠛ। ");
INSERT INTO syls_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠜꠤꠔꠞꠦ ꠙꠛꠤꠔ꠆ꠞ ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇꠞ ꠍꠣꠝꠘꠦ ꠎꠦ ꠎꠣꠉꠣꠔ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠀꠝꠣꠞ ꠖꠦꠈꠣ ꠅꠄ, ꠅꠃ ꠟꠣꠑꠤꠉꠥꠁꠘ ꠢꠘꠅ ꠕꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","ꠔꠦꠃ ꠀꠝꠣꠞ ꠙꠍꠘ꠆ꠖ ꠇꠞꠣ ꠛꠘ꠆ꠖꠣꠞ ꠟꠣꠑꠤꠞ ꠝꠣꠎꠦ ꠉꠣꠍꠞ ꠈꠦꠋ ꠚꠥꠐꠤꠛ। ꠅꠃ ꠟꠣꠈꠣꠘ ꠔꠥꠝꠞꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠛꠦꠞ-ꠛꠦꠞꠤ ꠇꠞꠣ ꠀꠝꠤ ꠛꠘ꠆ꠖ ꠇꠞꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","ꠔꠦꠃ ꠝꠥꠍꠣꠄ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁꠟꠣ। ꠀꠞ ꠔꠣꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠈꠣꠘ꠆ꠖꠣꠘ ꠝꠣꠚꠤꠇ ꠙꠞꠔꠦꠇ ꠡꠞ꠆ꠖꠣꠞꠦ ꠎꠣꠞꠎꠤꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠔꠞꠚ ꠕꠣꠇꠤ ꠄꠉꠥ ꠇꠞꠤ, ꠝꠥꠐ ꠛꠣꠞꠅ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠛꠣꠞꠅꠐꠣ ꠟꠣꠑꠤ ꠀꠘꠤꠀ ꠖꠤꠟꠣ। ꠅꠃ ꠟꠣꠑꠤꠘ꠆ꠔꠞ ꠄꠉꠥ ꠟꠣꠑꠤ ꠀꠍꠤꠟ ꠢꠣꠞꠥꠘ ꠘꠛꠤꠞ। ");
INSERT INTO syls_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","ꠝꠥꠍꠣꠄ ꠅꠃ ꠟꠣꠑꠤꠉꠥꠁꠘ ꠘꠤꠀ ꠡꠣꠢꠣꠖꠔ ꠔꠣꠝ꠆ꠛꠥꠞ ꠜꠤꠔꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠕꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","ꠛꠣꠖꠞ ꠖꠤꠘ ꠝꠥꠍꠣ ꠉꠤꠀ ꠡꠣꠢꠣꠖꠔ ꠔꠣꠝ꠆ꠛꠥꠞ ꠜꠤꠔꠞꠦ ꠢꠣꠝꠣꠁꠀ ꠖꠦꠈꠂꠘ, ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠣꠇꠤ ꠢꠣꠞꠥꠘꠞ ꠘꠣꠝꠦ ꠎꠦ ꠟꠣꠑꠤ ꠞꠣꠈꠣ ꠅꠁꠍꠦ, ꠁ ꠟꠣꠑꠤꠔ ꠈꠣꠟꠤ ꠈꠦꠋ ꠘꠣꠄ, ꠇꠥꠠꠤ ꠖꠤꠀ ꠚꠥꠟ ꠚꠥꠐꠤꠀ ꠛꠣꠖꠣꠝꠅ ꠗꠞꠤꠟꠤꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","ꠔꠦꠃ ꠝꠥꠍꠣꠄ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠕꠣꠇꠤ ꠟꠣꠑꠤ ꠉꠥꠁꠘ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠤꠀ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠍꠣꠝꠘꠦ ꠕꠁꠟꠣ। ꠡꠞ꠆ꠖꠣꠞ ꠅꠇꠟꠦ ꠟꠣꠑꠤ ꠉꠥꠁꠘ ꠖꠦꠈꠟꠣ, ꠖꠦꠈꠤꠀ ꠎꠣꠞꠎꠤꠞ ꠟꠣꠑꠤ ꠌꠤꠘꠤꠀ ꠘꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠛꠤꠞꠥꠗꠤ ꠘꠣꠚꠞꠝꠣꠘ ꠅꠇꠟꠞ ꠝꠘꠅ ꠞꠅꠀꠞ ꠟꠣꠉꠤ ꠘꠤꠡꠣꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠔꠥꠝꠤ ꠢꠣꠞꠥꠘꠞ ꠟꠣꠑꠤꠐꠣ ꠢꠤꠞꠛꠣꠞ ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇꠞ ꠍꠣꠝꠘꠦ ꠕꠅ। ꠔꠦꠃ ꠀꠝꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠔꠣꠞꠣꠞ ꠛꠇꠛꠇ ꠇꠞꠣ ꠈꠣꠘ ꠔꠥꠝꠤ ꠛꠘ꠆ꠖ ꠇꠞꠔꠣꠄ ꠙꠣꠞꠛꠣꠄ, ꠔꠣꠞꠣꠅ ꠀꠞ ꠝꠞꠔꠣ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠟꠣ, ꠝꠥꠍꠣꠄ ꠑꠤꠇ ꠅꠟꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","ꠁꠔꠣ ꠖꠦꠈꠤꠀ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠞꠣ ꠔ ꠝꠞꠤꠎꠣꠁꠀꠞ, ꠛꠤꠘꠣꠡ ꠅꠁꠎꠤꠀꠞ, ꠀꠝꠞꠣꠞ ꠡꠞ꠆ꠛꠘꠣꠡ ꠅꠁꠎꠣꠞ! ");
INSERT INTO syls_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","ꠎꠦꠇꠥꠘꠥ ꠝꠣꠘꠥꠡ ꠝꠣꠛꠥꠖꠞ ꠊꠞꠞ ꠗꠣꠞꠅ ꠉꠦꠟꠦꠃ ꠝꠞꠤꠎꠣꠞ, ꠔꠦ ꠀꠝꠞꠣ ꠢꠇꠟꠃ ꠝꠞꠤꠎꠤꠝꠥ ꠘꠤ?” ");
INSERT INTO syls_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","ꠝꠣꠛꠥꠖꠦ ꠢꠣꠞꠥꠘ ꠘꠛꠤꠞꠦ ꠇꠁꠟꠣ, “ꠙꠛꠤꠔ꠆ꠞ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠛꠦꠙꠣꠞꠦ ꠎꠔ ꠘꠣꠚꠞꠝꠣꠘꠤ ꠇꠞꠣ ꠅꠁꠛ, ꠄꠞ ꠖꠣꠄ-ꠖꠣꠄꠁꠔ꠆ꠔ ꠛꠞ꠆ꠔꠤꠛ ꠔꠥꠝꠣꠞ ꠃꠙꠞꠦ, ꠔꠥꠝꠣꠞ ꠙꠥꠀꠂꠘ ꠀꠞ ꠔꠥꠝꠣꠞ ꠉꠥꠡ꠆ꠐꠤꠞ ꠢꠇꠟꠞ ꠃꠙꠞꠦꠅ। ꠀꠞ ꠁꠝꠣꠝꠔꠤ ꠇꠣꠝꠞ ꠛꠣꠟꠣ ꠎꠔ ꠟꠣꠈꠣꠘ ꠘꠣꠚꠞꠝꠣꠘꠤ ꠇꠞꠣ ꠅꠁꠛ, ꠁꠔꠣꠞ ꠖꠣꠄꠁ ꠅꠁꠛꠣꠄ ꠈꠣꠟꠤ ꠔꠥꠝꠤ ꠀꠞ ꠔꠥꠝꠣꠞ ꠙꠥꠀꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","ꠔꠦ ꠔꠥꠝꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠣꠇꠤ ꠀꠞꠅ ꠟꠦꠛꠤ ꠅꠇꠟꠞꠦ ꠔꠥꠝꠤ ꠀꠘꠅ। ꠔꠣꠞꠣ ꠀꠁꠀ ꠔꠥꠝꠣꠞꠦ ꠀꠞ ꠔꠥꠝꠣꠞ ꠙꠥꠀꠂꠘꠞꠦ ꠡꠣꠢꠣꠖꠔ ꠔꠣꠝ꠆ꠛꠥꠞ ꠍꠣꠝꠘꠞ ꠄꠛꠣꠖꠔꠤ ꠇꠣꠝꠅ ꠡꠣꠁꠎ꠆ꠎ ꠇꠞꠛꠣ। ꠔꠣꠞꠣ ꠔꠥꠝꠣꠞ ꠎꠤꠝ꠆ꠝꠣꠄ ꠞꠁꠀ ꠡꠣꠢꠣꠖꠔ ꠔꠣꠝ꠆ꠛꠥꠞ ꠢꠇꠟ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","ꠅꠁꠟꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠣ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠇꠥꠘꠥ ꠙꠛꠤꠔ꠆ꠞ ꠎꠤꠘꠤꠡꠞ ꠗꠣꠞꠅ ꠎꠣꠅꠀ ꠔꠣꠞꠣꠞ ꠟꠣꠉꠤ ꠘꠤꠡꠦꠗ। ꠘꠤꠡꠦꠗ ꠘꠣ ꠝꠣꠘꠟꠦ ꠔꠣꠞꠣ ꠀꠞ ꠔꠥꠝꠞꠣ ꠢꠇꠟꠃ ꠝꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","ꠔꠣꠞꠣ ꠔꠥꠝꠣꠞ ꠇꠣꠝꠅ ꠡꠞꠤꠇ ꠅꠁꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠈꠣꠖꠤꠝꠖꠣꠞꠤ ꠇꠞꠛꠣ, ꠢꠇꠟ ꠎꠣꠔ ꠇꠣꠝꠞ ꠖꠣꠄ-ꠖꠣꠄꠁꠔ꠆ꠔ ꠘꠤꠛꠣ। ꠔꠣ-ꠅ ꠈꠣꠟꠤ ꠟꠦꠛꠤ ꠅꠇꠟ ꠍꠣꠠꠣ ꠖꠥꠍꠞꠣ ꠇꠦꠃ ꠔꠥꠝꠞꠣꠞ ꠉꠦꠍꠦ ꠎꠣꠅꠀ ꠘꠤꠡꠦꠗ। ");
INSERT INTO syls_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠃꠙꠞꠦ ꠀꠝꠤ ꠎꠣꠘꠥ ꠢꠤꠞꠛꠣꠞ ꠘꠣꠞꠣꠎ ꠘꠣ ꠅꠁ, ꠄꠞꠟꠣꠉꠤ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣ ꠀꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠖꠦꠈꠣ-ꠢꠥꠘꠣꠞ ꠜꠣꠞ ꠔꠥꠝꠞꠣꠞ ꠃꠙꠞꠦ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","ꠀꠝꠤ ꠘꠤꠎꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠃꠙꠢꠣꠞ ꠢꠤꠡꠣꠛꠦ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠎꠞ ꠟꠦꠛꠤ ꠅꠇꠟꠞꠦ ꠙꠍꠘ꠆ꠖ ꠇꠞꠍꠤ। ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠇꠣꠝ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠄꠞꠣꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠡꠙꠤ ꠖꠦꠅꠀ ꠅꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","ꠅꠁꠟꠦ ꠁꠝꠣꠝ ꠢꠤꠡꠣꠛꠦ ꠈꠣꠟꠤ ꠔꠥꠝꠤ ꠀꠞ ꠔꠥꠝꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠀꠞ ꠙꠞ꠆ꠖꠣꠞ ꠜꠤꠔꠞꠞ ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚꠅ ꠈꠦꠎꠝꠔ ꠇꠣꠝ ꠇꠞꠛꠣꠄ। ꠁꠝꠣꠝꠔꠤꠞ ꠙꠖ ꠈꠣꠘ ꠀꠝꠤ ꠃꠙꠢꠣꠞ ꠢꠤꠡꠣꠛꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠤꠟꠣꠝ। ꠈꠣꠟꠤ ꠟꠦꠛꠤ ꠅꠇꠟ ꠍꠣꠠꠣ ꠖꠥꠍꠞꠣ ꠇꠦꠃ ꠎꠥꠖꠤ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠡꠤꠝꠣꠘꠣꠔ ꠀꠄ, ꠔꠦ ꠔꠣꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠤꠔꠦ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠣꠞ ꠘꠣꠝꠦ ꠎꠔ ꠟꠣꠈꠣꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅꠀ ꠅꠄ, ꠁꠔꠣꠞ ꠢꠇꠟ ꠎꠤꠝ꠆ꠝꠣꠖꠣꠞꠤ ꠀꠝꠤ ꠘꠤꠎꠦꠃ ꠔꠥꠝꠣꠞ ꠀꠔꠅ ꠡꠝꠎꠣꠁꠍꠤ। ꠔꠦ ꠀꠝꠣꠞ ꠘꠣꠝꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠞꠣ ꠢꠇꠟ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠎꠤꠘꠤꠡ, ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠀꠞ ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡꠞ ꠙꠣꠅꠘꠣ ꠛꠦꠔꠘ ꠢꠤꠡꠣꠛꠦ ꠌꠤꠞꠇꠣꠟꠞ ꠟꠣꠉꠤ ꠖꠤꠟꠣꠁꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","ꠈꠣꠍ ꠙꠛꠤꠔ꠆ꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠎꠦ ꠅꠋꠡ ꠀꠉꠥꠁꠘꠅ ꠎꠣꠟꠣꠘꠤ ꠟꠣꠉꠔ ꠘꠣꠄ, ꠅꠃ ꠛꠣꠐꠅ ꠔꠥꠝꠞꠣ ꠘꠤꠅꠉꠤ। ꠔꠦ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ, ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ, ꠀꠞ ꠖꠥꠡ-ꠇꠍꠥꠞꠤꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠎꠔꠔꠣ ꠟꠁꠀ ꠀꠁꠛꠣ, ꠁꠔꠣ ꠔꠥꠝꠤ ꠀꠞ ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡ ꠅꠇꠟꠞ ꠙꠣꠅꠘꠣ ꠢꠇ। ");
INSERT INTO syls_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","ꠁꠔꠣ ꠘꠤꠀ ꠢꠣꠞꠤ ꠈꠣꠍ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠎꠤꠘꠤꠡ ꠛꠥꠎꠤꠀ ꠁꠎ꠆ꠎꠔ ꠇꠞꠤꠀ ꠔꠥꠝꠞꠣ ꠈꠣꠁꠅ। ꠔꠥꠝꠞꠣꠞ ꠢꠇꠟ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠦ ꠁꠔꠣ ꠈꠣꠁꠔꠣꠄ ꠙꠣꠞꠛꠣꠄ। ꠁ ꠈꠣꠘꠤ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠙꠛꠤꠔ꠆ꠞ। ");
INSERT INTO syls_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠖꠦꠅꠀ ꠢꠇꠟ ꠖꠥꠟꠘꠣ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠎꠤꠘꠤꠡꠅ ꠔꠥꠝꠞꠣꠞ ꠅꠁꠛ। ꠁꠔꠣ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠀꠞ ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡ ꠅꠇꠟꠞꠦ ꠌꠤꠞꠇꠣꠟꠤꠘ ꠙꠣꠅꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠖꠤꠞꠣꠝ। ꠔꠥꠝꠣꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠎꠦꠞꠣ ꠙꠣꠇ-ꠙꠣꠇꠤꠎꠣ ꠢꠣꠟꠔꠦ ꠞꠁꠛꠣ, ꠔꠣꠞꠣ ꠁꠔꠣ ꠈꠣꠁꠔꠣ ꠙꠣꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠔꠣꠞꠣꠞ ꠈꠦꠔꠞ ꠢꠇꠟ ꠕꠣꠇꠤ ꠜꠣꠟꠣ ꠎꠦ ꠔꠦꠟ, ꠘꠄꠀ ꠀꠋꠉꠥꠞꠞ ꠡꠞꠛꠔ ꠀꠞ ꠚꠡꠟꠞ ꠎꠦ ꠅꠋꠡ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠍꠖꠉꠣ ꠖꠤꠛꠣ, ꠁꠔꠣ ꠢꠇ꠆ꠇꠟꠔꠣ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠖꠤꠟꠣꠁꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍꠦ ꠀꠘꠣ ꠔꠣꠞꠣꠞ ꠚꠟꠣꠁꠟ ꠚꠄ-ꠚꠡꠟꠞ ꠙꠄꠟꠣ ꠅꠋꠡ ꠔꠥꠝꠣꠞ ꠅꠁꠛ। ꠔꠥꠝꠣꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠝꠣꠎꠞ ꠎꠦꠞꠣ ꠙꠣꠇ-ꠙꠣꠇꠤꠎꠣ ꠢꠣꠟꠔꠦ ꠕꠣꠇꠛꠣ, ꠔꠣꠞꠣ ꠁꠔꠣ ꠈꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠙꠥꠞꠣꠙꠥꠞ ꠖꠣꠛꠤ-ꠖꠣꠅꠀ ꠍꠣꠠꠤꠀ ꠝꠣꠘ꠆ꠘꠔ ꠢꠤꠡꠣꠛꠦ ꠎꠔ ꠎꠤꠘꠤꠡ ꠖꠤꠛꠣ, ꠁꠔꠣꠅ ꠔꠥꠝꠤ ꠙꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠡꠙꠤ ꠖꠦꠅꠀ ꠙꠞꠔꠦꠇ ꠙꠄꠟꠣ ꠛꠣꠁꠌ꠆ꠌꠣ ꠔꠥꠝꠣꠞ ꠅꠁꠛ, ꠁꠔꠣ ꠝꠣꠘꠡꠞ ꠀꠅꠟꠣꠖ ꠅꠃꠇ ꠛꠣ ꠙꠡꠥꠞ ꠛꠣꠁꠌ꠆ꠌꠣ ꠅꠃꠇ। ꠝꠣꠘꠡꠞ ꠙꠄꠟꠣ ꠙꠥꠀꠞꠦ ꠔꠥꠝꠤ ꠘꠤꠌ꠆ꠌꠄ ꠈꠣꠟꠣꠍ ꠇꠞꠤꠀ ꠘꠤꠔꠦ ꠖꠤꠅ, ꠀꠞ ꠘꠣꠙꠣꠇ ꠙꠡꠥꠞ ꠙꠄꠟꠣ ꠝꠦꠖꠣ ꠛꠣꠁꠌ꠆ꠌꠣꠞꠦꠅ ꠅꠟꠣ ꠈꠣꠟꠣꠍ ꠇꠞꠤ ꠘꠤꠔꠦ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","ꠝꠣꠘꠡꠞ ꠙꠄꠟꠣ ꠙꠥꠀꠞ ꠛꠄꠅꠡ ꠄꠇ ꠝꠣꠡ ꠅꠁꠟꠦ ꠈꠣꠟꠣꠍ ꠇꠞꠣꠘꠤꠞ ꠎꠣꠘꠞ ꠛꠖꠟꠣ ꠛꠣꠛꠔ, ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠝꠣꠙꠦ ꠙꠣꠌ ꠔꠟꠣ ꠞꠥꠙꠣ ꠘꠤꠀ ꠀꠎꠣꠖ ꠇꠞꠤ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","ꠅꠁꠟꠦ ꠉꠣꠁ-ꠉꠞꠥ ꠛꠣ ꠝꠦꠠꠣ-ꠍꠣꠉꠟꠞ ꠙꠄꠟꠣ ꠛꠣꠁꠌ꠆ꠌꠣꠞꠦ ꠈꠣꠟꠣꠍ ꠇꠞꠣꠁ ꠘꠤꠔꠦ ꠖꠤꠅ ꠘꠣ, ꠁꠉꠥꠁꠘ ꠔ ꠢꠣꠟꠣꠟ। ꠁꠔꠣꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠀ ꠔꠥꠝꠤ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠟꠃ ꠍꠤꠐꠣꠁꠀ ꠖꠤꠅ, ꠀꠞ ꠌꠞ꠆ꠛꠤꠞꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠎꠣꠟꠣꠁꠅ। ꠁ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠀꠝꠤ ꠝꠣꠛꠥꠖ ꠈꠥꠡꠤ ꠅꠁ। ");
INSERT INTO syls_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","ꠖꠥꠟꠘꠣ ꠇꠞꠣꠁꠟ ꠍꠤꠘꠣ ꠀꠞ ꠒꠣꠁꠘꠞ ꠞꠣꠘꠞ ꠉꠥꠡ꠆ꠔꠞ ꠟꠣꠈꠣꠘ, ꠅꠉꠥꠁꠘ꠆ꠔꠞ ꠉꠥꠡ꠆ꠔꠅ ꠔꠥꠝꠤ ꠙꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠞꠣ ꠢꠇꠟ ꠙꠛꠤꠔ꠆ꠞ ꠎꠤꠘꠤꠡ ꠔꠥꠝꠣꠞ ꠙꠣꠅꠘꠣ ꠛꠣꠛꠔ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠀꠞ ꠔꠥꠝꠣꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠞꠦ ꠌꠤꠞꠇꠣꠟꠞ ꠟꠣꠉꠤ ꠖꠤꠟꠣꠁꠟꠣꠝ। ꠁꠔꠣ ꠅꠁꠟ ꠝꠣꠛꠥꠖꠞ ꠟꠉꠦ ꠔꠥꠝꠤ ꠀꠞ ꠔꠥꠝꠣꠞ ꠅꠀꠞꠤꠡꠞ ꠟꠣꠉꠤ ꠌꠤꠞꠇꠣꠟꠤꠘ ꠌꠥꠇ꠆ꠔꠤ, ꠄꠞ ꠇꠥꠘꠥ ꠞꠖ-ꠛꠖꠟ ꠅꠁꠔ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, “ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠖꠦꠡꠅ ꠔꠥꠝꠤ ꠇꠥꠘꠥ ꠗꠘ-ꠖꠃꠟꠔꠞ ꠝꠣꠟꠤꠇꠣꠘꠣ ꠛꠣ ꠎꠝꠤ-ꠎꠝꠣꠞ ꠇꠥꠘꠥ ꠛꠣꠐꠅ ꠙꠣꠁꠔꠣꠄ ꠘꠣꠄ। ꠄꠞꠣꠞ ꠝꠣꠎꠦ ꠔꠥꠝꠣꠞ ꠙꠣꠅꠘꠣ ꠛꠣꠐ ꠅꠁꠟꠣꠝ ꠡ꠆ꠛꠄꠅꠋ ꠀꠝꠤ, ꠀꠝꠤꠃ ꠔꠥꠝꠣꠞ ꠗꠘ-ꠖꠃꠟꠔ।” ");
INSERT INTO syls_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","ꠝꠣꠛꠥꠖꠦ ꠇꠁꠟꠣ, “ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠔꠣꠞꠣꠞ ꠞꠥꠎꠤ-ꠞꠥꠎꠉꠣꠞꠞ ꠖꠡ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ ꠔ ꠀꠝꠣꠞꠦ ꠖꠤꠛꠣ, ꠀꠝꠤꠅ ꠁꠔꠣ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠙꠣꠅꠘꠣ ꠛꠦꠔꠘ ꠛꠣꠛꠔ ꠖꠤꠟꠣꠁꠟꠣꠝ। ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠔ ꠄꠛꠣꠖꠔꠤ ꠇꠣꠝꠞ ꠝꠎꠥꠞꠤ ꠢꠤꠡꠣꠛꠦ ꠔꠣꠞꠣ ꠁꠔꠣ ꠙꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","ꠀꠞ ꠀꠁꠎ ꠕꠣꠇꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠖꠥꠍꠞꠣ ꠇꠥꠘꠥ ꠉꠥꠡ꠆ꠐꠤꠞ ꠝꠣꠘꠥꠡ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠗꠣꠞꠅ ꠎꠣꠅꠀ ꠘꠤꠡꠦꠗ। ꠉꠦꠟꠦ ꠔꠣꠞꠣꠞ ꠘꠣꠚꠞꠝꠣꠘꠤꠞ ꠖꠣꠄ ꠔꠣꠞꠣ ꠝꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠇꠣꠝ-ꠇꠣꠎ ꠈꠣꠟꠤ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠦ ꠇꠞꠛꠣ, ꠅꠃ ꠇꠣꠝꠅ ꠎꠦꠇꠥꠘꠥ ꠘꠣꠚꠞꠝꠣꠘꠤ ꠇꠞꠟꠦ ꠔꠣꠞꠣ ꠘꠤꠎꠦꠃ ꠖꠣꠄꠁ ꠅꠁꠛꠣ। ꠁꠔꠣ ꠅꠁꠛ ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠄꠇꠐꠣ ꠌꠤꠞꠇꠣꠟꠤꠘ ꠘꠤꠅꠝ। ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠅꠁꠘ꠆ꠘꠣꠁꠘ꠆ꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠟꠉꠦ ꠇꠥꠘꠥ ꠗꠘ-ꠖꠃꠟꠔꠞ ꠝꠣꠟꠤꠇꠣꠘꠣ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠦ ꠙꠣꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","ꠄꠞ ꠛꠖꠟꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠔꠣꠞꠣꠞ ꠞꠥꠎꠤ-ꠞꠥꠎꠉꠣꠞꠞ ꠎꠦ ꠖꠡ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠀꠎꠤꠞ ꠇꠞꠛꠣ, ꠁꠔꠣ ꠀꠝꠤ ꠄꠞꠣꠞ ꠙꠣꠅꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠖꠤꠟꠣꠁꠟꠣꠝ। ꠄꠞꠟꠣꠉꠤ ꠄꠞꠣꠞ ꠛꠦꠙꠣꠞꠦ ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠇꠁꠍꠤ, ꠟꠦꠛꠤ ꠅꠇꠟꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠎꠦ ꠇꠥꠘꠥ ꠎꠝꠤ-ꠎꠝꠣꠞ ꠝꠣꠟꠤꠇꠣꠘꠣ ꠙꠣꠁꠔꠣ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“ꠔꠥꠝꠤ ꠟꠦꠛꠤ ꠅꠇꠟꠞꠦ ꠇꠅ, ꠅꠁꠘ꠆ꠘꠣꠁꠘ꠆ꠘ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠞꠥꠎꠤ-ꠞꠥꠎꠉꠣꠞꠞ ꠎꠦ ꠖꠡ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ ꠙꠣꠅꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠤꠟꠣꠝ, ꠁꠔꠣ ꠙꠣꠁꠀ ꠢꠣꠞꠟꠦ ꠔꠥꠝꠞꠣꠅ ꠅꠔꠣꠞ ꠖꠡ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐꠞꠦ, ꠎꠇꠣꠔꠞ ꠎꠇꠣꠔ ꠛꠣꠛꠔ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠖꠤꠟꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","ꠅꠃ ꠎꠇꠣꠔꠞꠦꠃ ꠔꠥꠝꠞꠣꠞ ꠈꠦꠔꠞ ꠚꠡꠟꠞ ꠀꠞ ꠘꠤꠎꠞ ꠛꠣꠘꠣꠁꠟ ꠀꠋꠉꠥꠞꠞ ꠡꠞꠛꠔꠞ ꠎꠇꠣꠔ ꠢꠤꠡꠣꠛꠦ ꠉꠘꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠛꠣꠇꠤ ꠄꠉꠣꠞꠅ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠎꠇꠣꠔ ꠛꠣꠛꠔ ꠎꠦ ꠖꠡ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ ꠔꠥꠝꠞꠣ ꠙꠣꠁꠛꠣꠄ, ꠅꠈꠣꠘ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣꠅ ꠅꠟꠣ ꠖꠡ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠎꠇꠣꠔ ꠖꠤꠛꠣꠄ। ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠞ ꠅꠃ ꠅꠋꠡ ꠔꠥꠝꠞꠣ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠀꠔꠅ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","ꠔꠥꠝꠞꠣꠞꠦ ꠎꠔꠔꠣ ꠖꠦꠅꠀ ꠅꠁꠛ, ꠔꠥꠝꠞꠣꠅ ꠅꠔꠣꠞ ꠢꠇꠟ ꠕꠣꠇꠤ ꠜꠣꠟꠣ ꠀꠞ ꠙꠛꠤꠔ꠆ꠞ ꠅꠋꠡ, ꠝꠣꠛꠥꠖꠞ ꠙꠣꠅꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠔꠣꠘꠞꠦ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“ꠢꠇꠟ ꠕꠣꠇꠤ ꠜꠣꠟꠣ ꠅꠋꠡ ꠝꠣꠛꠥꠖꠞꠦ ꠖꠦꠅꠀꠞ ꠛꠣꠖꠦ ꠎꠦꠔꠣ ꠛꠣꠇꠤ ꠞꠁꠛ, ꠅꠔꠣꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠘꠤꠎꠞ ꠈꠦꠔꠞ ꠚꠡꠟ, ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠘꠤꠎꠞ ꠛꠣꠘꠣꠁꠟ ꠀꠋꠉꠥꠞꠞ ꠡꠞꠛꠔ ꠢꠤꠡꠣꠛꠦ ꠉꠘꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","ꠅꠃ ꠅꠋꠡ ꠔꠥꠝꠞꠣ ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠝꠣꠘꠡꠦ ꠎꠦꠇꠥꠘꠥ ꠎꠣꠉꠣꠔ ꠈꠣꠁꠔꠣꠄ ꠙꠣꠞ, ꠁꠔꠣ ꠔ ꠔꠥꠝꠞꠣꠞ ꠇꠣꠝꠞ ꠛꠦꠔꠘ, ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠈꠦꠎꠝꠔꠞ ꠛꠦꠔꠘ। ");
INSERT INTO syls_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","ꠢꠇꠟ ꠕꠣꠇꠤ ꠜꠣꠟꠣ ꠅꠋꠡ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠖꠤꠟꠣꠁꠟꠦ, ꠛꠣꠇꠤꠔꠣ ꠈꠣꠁꠔꠦ ꠔꠥꠝꠞꠣꠞ ꠇꠥꠘꠥ ꠖꠥꠡ ꠘꠣꠁ। ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠖꠦꠅꠀ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠝꠣꠟꠞꠦ ꠔꠥꠝꠞꠣ ꠅꠙꠛꠤꠔ꠆ꠞ ꠇꠞꠤꠅ ꠘꠣ, ꠔꠦꠃ ꠔꠥꠝꠞꠣ ꠝꠞꠔꠣꠄ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“ꠔꠥꠝꠞꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠅ, ꠝꠣꠛꠥꠖꠦ ꠡꠞꠤꠅꠔꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠛꠣꠔꠣꠁꠍꠂꠘ, ꠔꠥꠝꠞꠣ ꠙꠥꠞꠣꠙꠥꠞ ꠟꠣꠟ ꠞꠋꠉꠞ ꠄꠉꠥ ꠒꠦꠇꠤ ꠉꠞꠥ ꠟꠁꠀ ꠀꠝꠞꠣꠞ ꠉꠦꠍꠦ ꠀꠅ, ꠅꠃ ꠒꠦꠇꠤ ꠡꠥꠟ꠆ꠟꠀꠘꠣ ꠘꠤꠈꠥꠔ ꠅꠁꠔ, ꠀꠞ ꠔꠣꠁꠞ ꠇꠣꠘ꠆ꠖꠅ ꠇꠥꠘꠥꠖꠤꠘ ꠎꠥꠀꠟ ꠟꠣꠉꠣꠘꠤ ꠅꠁꠍꠦ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","ꠅꠉꠥ ꠀꠘꠤꠀ ꠔꠥꠝꠞꠣ ꠁꠝꠣꠝ ꠀꠟꠤ-ꠀꠎꠞꠞ ꠉꠦꠍꠦ ꠖꠤꠛꠣꠄ। ꠁꠝꠣꠝꠦ ꠁꠐꠣꠞꠦ ꠇꠦꠝ꠆ꠙꠞ ꠛꠣꠞꠦ ꠘꠤꠀ ꠔꠣꠘ ꠍꠣꠝꠘꠦ ꠎꠛ ꠇꠞꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","ꠎꠛꠞ ꠛꠣꠖꠦ ꠔꠣꠘ ꠀꠋꠉꠥꠟꠅ ꠇꠤꠍꠥ ꠟꠃ ꠟꠁꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠍꠣꠝꠘꠣ ꠛꠣꠄ ꠡꠣꠔ ꠛꠣꠞ ꠍꠤꠐꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","ꠔꠣꠘ ꠍꠣꠝꠘꠦꠃ ꠅꠃ ꠉꠣꠁꠞ ꠈꠣꠟ, ꠉꠥꠡ꠆ꠔ, ꠟꠃ ꠀꠞ ꠉꠥꠚꠞ ꠡꠥꠖ꠆ꠖꠣ ꠀꠔ-ꠜꠠ ꠀꠉꠥꠁꠘꠖꠤ ꠎꠣꠟꠣꠁꠟꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","ꠅꠃ ꠒꠦꠇꠤꠞꠦ ꠎꠣꠟꠣꠘꠤꠞ ꠡꠝꠄ ꠁꠝꠣꠝꠦ ꠖꠦꠛꠖꠣꠞꠥ ꠉꠣꠍꠞ ꠇꠤꠍꠥ ꠖꠣꠞꠥ, ꠄꠍꠥꠛ ꠉꠣꠍꠞ ꠒꠦꠐꠣ, ꠀꠞ ꠟꠣꠟ ꠞꠋꠉꠞ ꠇꠤꠍꠥ ꠡꠥꠔꠣꠞꠦ ꠅꠃ ꠀꠉꠥꠘꠤꠞ ꠝꠣꠎꠦ ꠚꠣꠟꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠘꠣꠁꠛꠣ, ꠀꠞ ꠚꠤꠘ꠆ꠘꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠꠅ ꠗꠁꠛꠣ। ꠘꠣꠁꠀ-ꠗꠁꠀ ꠢꠣꠞꠟꠦ ꠔꠣꠁꠘ ꠇꠦꠝ꠆ꠙꠞ ꠜꠤꠔꠞꠦ ꠎꠣꠁꠔꠣ ꠙꠣꠞꠛꠣ, ꠅꠁꠟꠦ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠔꠣꠁꠘ ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠞꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","ꠎꠦ ꠎꠘꠦ ꠅꠃ ꠒꠦꠇꠤꠞ ꠢꠇꠟꠔꠣ ꠎꠣꠟꠣꠁꠛ, ꠢꠦ-ꠅ ꠘꠣꠁꠀ ꠢꠣꠞꠤ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠛ ꠀꠞ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠘꠣꠙꠣꠇ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","ꠅꠃ ꠒꠦꠇꠤꠞ ꠎꠣꠟꠣꠁꠟ ꠍꠣꠟꠤ ꠈꠣꠘꠣꠁꠘ ꠇꠥꠘꠥ ꠙꠣꠇ-ꠍꠣꠚ ꠝꠣꠘꠡꠦ ꠔꠥꠟꠤꠀ ꠘꠤꠀ, ꠇꠦꠝ꠆ꠙꠞ ꠛꠣꠞꠦ ꠇꠥꠘꠥ ꠙꠣꠇ ꠎꠣꠉꠣꠔ ꠕꠁꠛ। ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠅꠀꠞ ꠙꠣꠘꠤ ꠔꠤꠀꠞ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠅꠃ ꠍꠣꠟꠤꠞꠦ ꠎꠔꠘꠦ ꠕꠁꠛꠣ। ꠛꠣꠖꠦ ꠘꠣꠙꠣꠇ ꠕꠣꠇꠤ ꠙꠣꠇ-ꠍꠣꠚ ꠅꠀꠞ ꠇꠣꠟꠅ ꠅꠃ ꠙꠣꠘꠤ ꠇꠣꠝꠅ ꠟꠣꠉꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","ꠎꠦ ꠎꠘꠦ ꠅꠃ ꠍꠣꠟꠤ ꠔꠥꠟꠛ, ꠢꠦ-ꠅ ꠔꠣꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠔꠦ ꠅꠁꠛ ꠀꠞ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠘꠣꠙꠣꠇ ꠞꠁꠛ। ꠁꠐꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠀꠞ ꠔꠣꠞꠣꠞ ꠝꠣꠎꠦ ꠛꠡꠔ ꠇꠞꠞꠣ ꠢꠇꠟ ꠎꠣꠔꠤꠞ ꠟꠣꠉꠤ ꠌꠤꠞꠇꠣꠟꠤꠘ ꠘꠤꠅꠝ। ");
INSERT INTO syls_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“ꠇꠦꠃ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠝꠥꠞ꠆ꠖꠣꠞ ꠟꠣꠡ ꠍꠁꠟꠣꠄ, ꠔꠦ ꠡꠣꠔ ꠖꠤꠘ ꠜꠞꠣ ꠢꠦ ꠘꠣꠙꠣꠇ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","ꠟꠣꠡ ꠍꠅꠀꠞ ꠔꠤꠘ ꠘꠝ꠆ꠛꠞ ꠀꠞ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ, ꠙꠣꠇ-ꠍꠣꠚ ꠅꠀꠞ ꠙꠛꠤꠔ꠆ꠞ ꠙꠣꠘꠤ ꠖꠤꠀ ꠘꠤꠎꠞꠦ ꠗꠁꠀ ꠢꠣꠞꠟꠦ ꠢꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠅꠁꠛ। ꠀꠞ ꠁ ꠘꠤꠅꠝ ꠘꠣ ꠝꠣꠘꠟꠦ ꠢꠦ ꠘꠣꠙꠣꠇꠃ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","ꠟꠣꠡ ꠍꠅꠀꠞ ꠛꠣꠖꠦ ꠇꠦꠃ ꠎꠥꠖꠤ ꠙꠣꠇ-ꠍꠣꠚ ꠘꠣ ꠅꠄ, ꠔꠦ ꠢꠦ ꠝꠣꠛꠥꠖꠞ ꠊꠞꠞꠦ ꠘꠣꠙꠣꠇ ꠛꠣꠘꠣꠄ। ꠅꠃ ꠎꠘꠞꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠡꠝꠣꠎ ꠕꠣꠇꠤ ꠚꠥꠍꠤꠟꠤꠛꠣꠄ। ꠙꠣꠇ-ꠍꠣꠚ ꠅꠀꠞ ꠙꠣꠘꠤ ꠔꠣꠞ ꠡꠞꠤꠟꠅ ꠘꠣ ꠍꠤꠐꠣꠘꠤꠄ, ꠔꠣꠞ ꠘꠣꠙꠣꠇꠤ ꠔꠣꠞ ꠟꠉꠦ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“ꠀꠞ ꠔꠣꠝ꠆ꠛꠥꠞ ꠜꠤꠔꠞꠦ ꠇꠥꠘꠥ ꠝꠣꠘꠥꠡ ꠝꠞꠤꠉꠦꠟꠦ, ꠎꠦꠞꠣ ꠅꠃ ꠔꠣꠝ꠆ꠛꠥꠔ ꠢꠣꠝꠣꠁꠛꠣ ꠀꠞ ꠎꠦꠞꠣ ꠔꠣꠝ꠆ꠛꠥꠔ ꠀꠍꠟꠣ, ꠔꠣꠞꠣ ꠢꠇꠟꠃ ꠡꠣꠔ ꠖꠤꠘ ꠜꠞꠣ ꠘꠣꠙꠣꠇ ꠞꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","ꠅꠃ ꠛꠡꠔ ꠔꠣꠝ꠆ꠛꠥꠞ ꠜꠤꠔꠞꠞ ꠎꠦꠔꠣ ꠕꠣꠟ-ꠛꠣꠡꠘ ꠢꠞꠣ ꠖꠤꠀ ꠉꠥꠞꠣ ꠀꠍꠤꠟ ꠘꠣ, ꠅꠔꠣꠅ ꠘꠣꠙꠣꠇ ꠅꠁꠎꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“ꠛꠘ꠆ꠖꠞ ꠝꠣꠎꠦ ꠈꠥꠟꠣ ꠎꠣꠉꠣꠔ ꠚꠣꠟꠣꠁꠟ ꠇꠥꠘꠥ ꠟꠣꠡꠞꠦ ꠎꠥꠖꠤ ꠇꠦꠃ ꠍꠁꠟꠣꠄ, ꠔꠦ ꠢꠦ ꠡꠣꠔ ꠖꠤꠘ ꠜꠞꠣ ꠘꠣꠙꠣꠇ ꠞꠁꠛ। ꠁ ꠟꠣꠡ ꠇꠥꠘꠥ ꠟꠣꠠꠣꠁꠞ ꠇꠣꠞꠘꠦ ꠅꠃꠇ, ꠛꠣ ꠄꠝꠘꠦ ꠝꠞꠣ ꠅꠃꠇ, ꠎꠦꠞꠣ ꠍꠁꠛ ꠄꠞꠣ ꠘꠣꠙꠣꠇ। ꠇꠥꠘꠥ ꠝꠞꠣ ꠝꠣꠘꠡꠞ ꠀꠒ꠆ꠒꠤ ꠛꠣ ꠇꠄꠛꠞꠞꠦ ꠍꠁꠟꠦ, ꠢꠦ-ꠅ ꠡꠣꠔ ꠖꠤꠘ ꠜꠞꠣ ꠘꠣꠙꠣꠇ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“ꠅꠟꠣ ꠘꠣꠙꠣꠇ ꠝꠣꠘꠡꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠎꠦ ꠟꠣꠟ ꠒꠦꠇꠤꠞ ꠉꠥꠡ꠆ꠔ ꠎꠣꠟꠣꠘꠤ ꠅꠁꠍꠦ, ꠅꠉꠥꠞ ꠇꠤꠍꠥ ꠍꠣꠟꠤ ꠄꠇꠐꠣ ꠉꠣꠝꠟꠣꠔ ꠟꠁꠀ, ꠅꠃ ꠉꠣꠝꠟꠣꠔ ꠚꠥꠔꠞ ꠙꠣꠘꠤ ꠜꠞꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","ꠛꠣꠖꠦ ꠇꠥꠘꠥ ꠙꠣꠇ-ꠍꠣꠚ ꠝꠣꠘꠡꠦ ꠄꠍꠥꠛ ꠉꠣꠍꠞ ꠇꠄꠐꠣ ꠒꠦꠐꠣ ꠀꠘꠤꠀ ꠙꠣꠘꠤꠔ ꠛꠥꠠꠣꠁꠀ ꠢꠃ ꠝꠥꠞ꠆ꠖꠣꠞ ꠔꠣꠝ꠆ꠛꠥ, ꠄꠞ ꠜꠤꠔꠞꠞ ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠀꠞ ꠝꠣꠘꠡꠞ ꠃꠙꠞꠦ ꠍꠤꠐꠣꠁ ꠖꠤꠛꠣ। ꠎꠔ ꠎꠘꠦ ꠄꠝꠘꠦ ꠝꠞꠣ, ꠛꠣ ꠈꠥꠘ ꠅꠁꠀ ꠝꠞꠣ ꠇꠥꠘꠥ ꠝꠥꠞ꠆ꠖꠣꠞ ꠟꠣꠡ, ꠝꠞꠣꠞ ꠀꠒ꠆ꠒꠤ-ꠉꠥꠒ꠆ꠒꠤ ꠛꠣ ꠇꠄꠛꠞ ꠍꠁꠍꠦ, ꠔꠣꠞꠣꠞ ꠃꠙꠞꠦꠅ ꠅꠃ ꠙꠣꠘꠤ ꠍꠤꠐꠣꠁ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","ꠙꠣꠇ-ꠍꠣꠚ ꠅꠃ ꠎꠘꠦ ꠘꠣꠙꠣꠇ ꠝꠣꠘꠡꠞ ꠃꠙꠞꠦ ꠢꠣꠙ꠆ꠔꠣꠞ ꠔꠤꠘ ꠘꠝ꠆ꠛꠞ ꠀꠞ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠙꠣꠘꠤ ꠍꠤꠐꠣꠁ ꠖꠤꠛꠣ, ꠀꠞ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠔꠣꠞꠣ ꠙꠣꠇ-ꠍꠣꠚ ꠅꠁꠛꠣ। ꠔꠣꠞꠣ ꠉꠥꠍꠟ ꠇꠞꠤꠀ ꠚꠤꠘ꠆ꠘꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠛꠣ, ꠀꠞ ꠅꠃ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘꠞ ꠢꠣꠁꠘ꠆ꠎꠣ ꠕꠣꠇꠤ ꠙꠣꠇ-ꠍꠣꠚ ꠛꠘꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","ꠅꠁꠟꠦ ꠘꠣꠙꠣꠇ ꠅꠀꠞ ꠛꠣꠖꠦ ꠇꠦꠃ ꠎꠥꠖꠤ ꠘꠤꠎꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠘꠣ ꠇꠞꠦ, ꠔꠦ ꠔꠣꠞꠦ ꠡꠝꠣꠎ ꠕꠣꠇꠤ ꠚꠥꠍꠤꠀ ꠚꠣꠟꠣꠁꠛꠣꠄ। ꠢꠦ ꠘꠤꠎꠞꠦ ꠘꠣꠙꠣꠇ ꠞꠣꠈꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠢꠦꠞꠦꠝ ꠡꠞꠤꠚꠞꠦꠅ ꠘꠣꠙꠣꠇ ꠛꠣꠘꠣꠁꠍꠦ। ꠙꠣꠇ-ꠍꠣꠚ ꠅꠀꠞ ꠙꠣꠘꠤ ꠔꠣꠞ ꠃꠙꠞꠦ ꠘꠣ ꠍꠤꠐꠣꠘꠤꠄ, ꠢꠦ ꠘꠣꠙꠣꠇ ꠞꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","ꠁꠔꠣ ꠅꠁꠛ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠣꠉꠤ ꠄꠇꠐꠣ ꠌꠤꠞꠇꠣꠟꠤꠘ ꠘꠤꠅꠝ। “ꠎꠦ ꠎꠘꠦ ꠅꠃ ꠙꠣꠇ-ꠍꠣꠚ ꠅꠀꠞ ꠙꠣꠘꠤ ꠍꠤꠐꠣꠁꠛꠣ, ꠄꠁꠘ ꠘꠤꠎꠦꠅ ꠔꠣꠘ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠔꠦ ꠅꠁꠛ। ꠁ ꠙꠣꠇ-ꠍꠣꠚ ꠅꠀꠞ ꠙꠣꠘꠤ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠍꠁꠟꠦ, ꠢꠦ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠘꠣꠙꠣꠇ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠁ ꠎꠘꠦ ꠎꠔꠔꠣ ꠍꠁꠛ, ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠘꠣꠙꠣꠇ ꠅꠁꠎꠤꠛ, ꠔꠣꠞ ꠍꠅꠀ ꠇꠥꠘꠥ ꠎꠤꠘꠤꠡ ꠎꠦꠉꠤꠄ ꠍꠁꠛ, ꠢꠦ-ꠅ ꠢꠣꠁꠘ꠆ꠎꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠘꠣꠙꠣꠇ ꠞꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","ꠛꠍꠞꠞ ꠙꠄꠟꠣ ꠌꠣꠘ꠆ꠖꠅ ꠢꠇ꠆ꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠎꠤꠘ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠉꠤꠀ ꠇꠣꠖꠦꠡ ꠄꠟꠣꠇꠣꠔ ꠀꠁꠀ ꠞꠁꠟꠣ। ꠢꠘꠅ ꠝꠥꠍꠣ ꠘꠛꠤꠞ ꠛꠁꠘ ꠛꠤꠛꠤ ꠝꠞꠤꠅꠝꠞ ꠁꠘ꠆ꠔꠦꠇꠣꠟ ꠅꠁꠟ ꠀꠞ ꠔꠣꠘꠞꠦ ꠖꠣꠚꠘ ꠇꠞꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","ꠢꠤꠘꠅ ꠈꠣꠁꠛꠣꠞ ꠇꠥꠘꠥ ꠙꠣꠘꠤ ꠘꠣ ꠙꠣꠅꠀꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠖꠟ ꠛꠣꠘ꠆ꠖꠤꠀ ꠄꠞꠣꠞ ꠙꠤꠍꠦ ꠟꠣꠉꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","ꠔꠣꠞꠣ ꠝꠥꠍꠣꠞ ꠟꠉꠦ ꠇꠣꠁꠎ꠆ꠎꠣ ꠇꠞꠤꠀ ꠇꠁꠟꠣ, “ꠀꠝꠞꠣꠞ ꠟꠉꠞ ꠜꠣꠁꠀꠁꠘ ꠎꠦꠛꠟꠣ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠝꠞꠍꠟꠣ, ꠢꠃ ꠡꠝꠄ ꠀꠝꠞꠣꠅ ꠝꠞꠤꠉꠦꠟꠦ ꠜꠣꠟꠣ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","ꠝꠣꠛꠥꠖꠞ ꠛꠘ꠆ꠖꠣ ꠅꠇꠟꠞꠦ ꠔꠥꠝꠤ ꠇꠦꠘꠦ ꠅꠃ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠀꠘꠟꠣꠄ, ꠅꠈꠘ ꠙꠡꠥꠞ ꠙꠣꠟ ꠡꠥꠖ꠆ꠖꠣ ꠀꠝꠞꠣ ꠢꠇ꠆ꠇꠟꠦ ꠅꠘꠅ ꠎꠣꠘ ꠈꠥꠀꠁꠔꠣꠝ ꠘꠤ? ");
INSERT INTO syls_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠔꠥꠝꠤ ꠇꠦꠘꠦ ꠀꠝꠞꠣꠞꠦ ꠅꠟꠣ ꠎꠝꠞ ꠉꠣꠔꠅ ꠟꠁꠀ ꠀꠁꠟꠣꠄ? ꠁ ꠎꠣꠉꠣꠔ ꠘꠣ ꠀꠍꠦ ꠇꠥꠘꠥ ꠗꠣꠘ-ꠌꠣꠃꠟ ꠛꠣ ꠒꠥꠝꠥꠞ ꠚꠟ, ꠘꠣ ꠀꠍꠦ ꠀꠋꠉꠥꠞ ꠛꠣ ꠀꠘꠥꠀꠞ ꠚꠟ? ꠀꠞ ꠈꠣꠁꠛꠣꠞ ꠙꠣꠘꠤꠅ ꠘꠣꠁ।” ");
INSERT INTO syls_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","ꠁꠔꠣ ꠢꠥꠘꠤꠀ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘ ꠝꠣꠘꠡꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠢꠞꠤꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠉꠦꠍꠦ ꠉꠤꠀ ꠍꠁꠎꠖꠣꠔ ꠙꠠꠟꠣ। ꠔꠦꠃ ꠝꠣꠛꠥꠖꠞ ꠘꠥꠞꠞ ꠔꠎꠟ꠆ꠟꠤ ꠔꠣꠞꠣꠞ ꠍꠣꠝꠘꠦ ꠎꠣꠁꠞ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“ꠔꠥꠝꠤ ꠢꠃ ꠟꠣꠑꠤꠐꠣ ꠟꠅ, ꠟꠁꠀ ꠔꠥꠝꠤ ꠀꠞ ꠔꠥꠝꠣꠞ ꠜꠣꠁ ꠢꠣꠞꠥꠘꠦ ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠄꠇꠈꠣꠘꠅ ꠖꠟꠣ ꠇꠞꠅ। ꠀꠞ ꠅꠃ ꠛꠠ ꠎꠦ ꠙꠣꠔ꠆ꠔꠞꠉꠥ ꠖꠦꠈꠞꠣꠄ, ꠔꠣꠞꠣꠞ ꠍꠣꠝꠘꠦ ꠅꠃ ꠙꠣꠔ꠆ꠔꠞꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠦꠅ, ꠖꠤꠟꠦ ꠅꠃ ꠙꠣꠔ꠆ꠔꠞꠦ ꠙꠣꠘꠤ ꠖꠤꠛ। ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠀꠞ ꠔꠣꠞꠣꠞ ꠙꠡꠥꠙꠣꠟ ꠢꠇꠟꠦ ꠎꠣꠔꠦ ꠙꠣꠘꠤ ꠈꠣꠁꠔ ꠙꠣꠞꠦ, ꠄꠞꠟꠣꠉꠤ ꠔꠥꠝꠤ ꠅꠃ ꠙꠣꠔ꠆ꠔꠞ ꠕꠣꠇꠤ ꠙꠣꠘꠤ ꠛꠣꠞ ꠇꠞꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠔ ꠔꠣꠘ ꠍꠣꠝꠘꠦ ꠕꠣꠇꠤ ꠝꠥꠍꠣꠄ ꠟꠣꠑꠤꠐꠣ ꠟꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","ꠟꠁꠀ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠦ ꠝꠣꠘꠡꠞꠦ ꠅꠃ ꠙꠣꠔ꠆ꠔꠞꠞ ꠉꠦꠍꠦ ꠖꠟꠣ ꠇꠞꠟꠣ। ꠀꠞ ꠝꠥꠍꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠅ ꠛꠦꠁꠝꠣꠘꠞ ꠎꠣꠔ, ꠢꠥꠘꠅ, ꠀꠝꠞꠣ ꠅꠃ ꠙꠣꠔ꠆ꠔꠞ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠙꠣꠘꠤ ꠛꠣꠞ ꠇꠞꠔꠣꠝ ꠘꠤ?” ");
INSERT INTO syls_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","ꠅꠈꠣꠘ ꠇꠁꠀ ꠝꠥꠍꠣꠄ ꠟꠣꠑꠤ ꠖꠤꠀ ꠅꠃ ꠙꠣꠔ꠆ꠔꠞꠅ ꠖꠥꠁ ꠛꠣꠠꠤ ꠝꠣꠞꠟꠣ, ꠛꠣꠠꠤ ꠝꠣꠞꠣꠞ ꠟꠉꠦ ꠟꠉꠦ ꠙꠣꠔ꠆ꠔꠞ ꠕꠣꠇꠤ ꠎꠥꠞꠦ ꠎꠥꠞꠦ ꠙꠣꠘꠤ ꠛꠣꠞ ꠅꠁꠟ, ꠔꠦꠃ ꠔꠣꠞꠣ ꠀꠞ ꠔꠣꠞꠣꠞ ꠙꠡꠥꠞ ꠙꠣꠟꠦ ꠙꠣꠘꠤ ꠈꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","ꠅꠁꠟꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠔ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠍꠣꠝꠘꠦ ꠀꠝꠣꠞꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠇꠁꠀ ꠝꠣꠘꠟꠣꠄ ꠘꠣ, ꠀꠝꠣꠞ ꠎꠛꠣꠘꠞ ꠃꠙꠞꠦ ꠜꠞꠡꠣ ꠇꠞꠟꠣꠄ ꠘꠣ। ꠄꠞꠟꠣꠉꠤ ꠀꠝꠤ ꠎꠦ ꠖꠦꠡꠈꠣꠘ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠖꠣꠘ ꠇꠞꠝꠥ, ꠔꠥꠝꠞꠣ ꠔꠣꠞꠣꠞꠦ ꠟꠁꠀ ꠢꠤꠘꠅ ꠎꠣꠁꠔꠣꠄ ꠙꠣꠞꠔꠣꠄ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","ꠙꠣꠔ꠆ꠔꠞ ꠕꠣꠇꠤ ꠎꠦ ꠎꠣꠉꠣꠔ ꠙꠣꠘꠤ ꠛꠣꠞ ꠅꠁꠟ, ꠅꠃ ꠎꠣꠉꠣꠞ ꠘꠣꠝ ꠖꠦꠅꠀ ꠅꠁꠟ ꠝꠦꠞꠤꠛꠣ, ꠝꠣꠘꠤ ꠇꠣꠁꠎ꠆ꠎꠣ। ꠁꠘꠅ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠝꠣꠛꠥꠖꠞ ꠟꠉꠦ ꠇꠣꠁꠎ꠆ꠎꠣ ꠇꠞꠍꠤꠟ, ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠅꠘꠅꠃ ꠔꠣꠘ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞꠔꠣ ꠔꠣꠞꠣꠞ ꠍꠣꠝꠘꠦ ꠎꠣꠁꠞ ꠇꠞꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","ꠛꠣꠖꠦ ꠝꠥꠍꠣꠄ ꠇꠣꠖꠦꠡ ꠕꠣꠇꠤ ꠝꠣꠘꠥꠡ ꠙꠣꠑꠣꠁꠀ ꠁꠖꠥꠝ ꠖꠦꠡꠞ ꠛꠣꠖꠡꠣꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠞꠣ ꠔ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ, ꠀꠙꠘꠣꠞ ꠍꠤꠟꠍꠤꠟꠣꠞ ꠜꠣꠁꠀꠁꠘ। ꠀꠙꠘꠣꠞ ꠖꠞꠛꠣꠞꠅ ꠀꠝꠞꠣꠞ ꠄꠇꠈꠣꠘ ꠀꠞꠎꠤ ꠀꠍꠦ, ꠀꠙꠘꠦ ꠔ ꠀꠝꠞꠣꠞ ꠖꠥꠈ-ꠝꠍꠤꠛꠔꠞ ꠇꠕꠣ ꠎꠣꠘꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ꠔꠦ ꠀꠝꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠁꠘ ꠔ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠉꠦꠍꠟꠣ, ꠀꠞ ꠀꠝꠞꠣ ꠛꠃꠔ ꠛꠍꠞ ꠢꠘꠅ ꠀꠍꠟꠣꠝ। ꠝꠤꠡꠞꠤ ꠅꠇꠟꠦ ꠀꠝꠞꠣ ꠀꠞ ꠀꠝꠞꠣꠞ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤꠞ ꠃꠙꠞꠦ ꠎꠥꠟꠥꠝ-ꠝꠍꠤꠛꠔ ꠇꠞꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","ꠀꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠇꠣꠘ꠆ꠖꠣ-ꠇꠣꠐꠤ ꠇꠞꠟꠣꠝ। ꠔꠦꠃ ꠝꠣꠛꠥꠖꠦ ꠀꠝꠞꠣꠞ ꠚꠞꠤꠀꠖ ꠇꠛꠥꠟ ꠇꠞꠤꠀ, ꠔꠣꠘ ꠚꠤꠞꠤꠡ꠆ꠔꠣ ꠙꠣꠑꠣꠁꠀ ꠀꠝꠞꠣꠞꠦ ꠢꠃ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠍꠂꠘ। “ꠄꠞꠟꠣꠉꠤ ꠀꠝꠞꠣ ꠅꠈꠘ ꠀꠙꠘꠣꠞ ꠖꠦꠡꠞ ꠡꠤꠝꠣꠘꠣꠞ ꠇꠣꠖꠦꠡ ꠐꠣꠃꠘꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠀꠁꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","ꠀꠙꠘꠦ ꠀꠝꠞꠣꠞꠦ ꠀꠙꠘꠣꠞ ꠖꠦꠡꠞ ꠝꠣꠎꠖꠤ ꠎꠣꠁꠛꠣꠞ ꠡꠥꠎꠥꠉ ꠈꠣꠘ ꠖꠦꠃꠇ꠆ꠇꠣ। ꠀꠝꠞꠣ ꠀꠙꠘꠣꠞ ꠇꠥꠘꠥ ꠈꠦꠔ-ꠇꠤꠡꠤ ꠛꠣ ꠀꠋꠉꠥꠞ ꠛꠣꠉꠣꠘꠞ ꠝꠣꠎꠦꠖꠤ ꠎꠣꠁꠔꠣꠝ ꠘꠣꠄ, ꠇꠥꠘꠥ ꠇꠥꠀ ꠕꠣꠇꠤ ꠙꠣꠘꠤꠅ ꠔꠥꠟꠤꠀ ꠈꠣꠁꠔꠣꠝ ꠘꠣꠄ। ꠀꠝꠞꠣ ꠈꠣꠟꠤ ꠞꠣꠎ ꠙꠕꠦꠖꠤ ꠀꠐꠤꠀ ꠎꠣꠁꠝꠥ, ꠀꠙꠘꠣꠞ ꠖꠦꠡꠞ ꠡꠤꠝꠣꠘꠣ ꠙꠣꠞꠘꠤꠞ ꠀꠉ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠒꠣꠁꠘꠦ-ꠛꠣꠃꠄ ꠇꠥꠘꠥꠛꠣꠄ ꠙꠣꠅ ꠛꠣꠠꠣꠁꠔꠣꠝ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","ꠅꠁꠟꠦ ꠁꠖꠥꠝꠞ ꠛꠣꠖꠡꠣꠄ ꠇꠁꠟꠣ, “ꠘꠣ, ꠘꠣ, ꠔꠥꠝꠞꠣ ꠁꠛꠣꠄ ꠎꠣꠁꠔꠣꠄ ꠙꠣꠞꠔꠣꠄ ꠘꠣꠄ। ꠎꠣꠁꠛꠣꠞ ꠌꠦꠡ꠆ꠐꠣ ꠇꠞꠟꠦ ꠀꠝꠞꠣ ꠎꠥꠖ꠆ꠖꠔ ꠛꠣꠞ ꠅꠁꠀ ꠔꠥꠝꠞꠣꠞ ꠃꠙꠞꠦ ꠢꠣꠝꠟꠣ ꠇꠞꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","ꠔꠦꠃ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠀꠝꠞꠣ ꠔ ꠈꠣꠟꠤ ꠞꠣꠎ ꠙꠕꠦꠖꠤ ꠎꠣꠁꠝꠥ। ꠀꠝꠞꠣ ꠛꠣ ꠀꠝꠞꠣꠞ ꠙꠡꠥꠞ ꠙꠣꠟꠦ ꠎꠥꠖꠤ ꠀꠙꠘꠣꠞ ꠖꠦꠡꠞ ꠇꠥꠘꠥ ꠙꠣꠘꠤ ꠈꠣꠁ, ꠔꠦ ꠁꠔꠣꠞ ꠖꠣꠝ ꠖꠤꠟꠣꠁꠝꠥ। ꠀꠝꠞꠣ ꠙꠣꠅꠄ ꠀꠐꠤꠀ ꠈꠣꠟꠤ ꠖꠦꠡ ꠙꠣꠠꠤ ꠖꠤꠀ ꠎꠣꠁꠔꠣꠝ ꠌꠣꠁꠞꠣꠝ।” ");
INSERT INTO syls_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","ꠅꠁꠟꠦ ꠁꠖꠥꠝ ꠖꠦꠡꠞ ꠛꠣꠖꠡꠣꠄ ꠢꠤꠞꠛꠣꠞ ꠇꠁꠟ, “ꠘꠣ, ꠘꠣ, ꠁꠛꠣꠄꠖꠤ ꠔꠥꠝꠞꠣꠞ ꠎꠣꠅꠀ ꠘꠤꠡꠦꠗ।” ꠛꠣꠖꠦ ꠁꠖꠥꠝ ꠖꠦꠡꠞ ꠛꠃꠔ ꠍꠤꠙꠣꠁꠄ ꠛꠦꠐꠣꠉꠤꠞꠤ ꠖꠦꠈꠣꠁꠀ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠉꠦ ꠟꠣꠠꠣꠁ ꠇꠞꠣꠔ ꠛꠣꠞ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","ꠔꠣꠞꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠖꠦꠡꠞ ꠜꠤꠔꠞꠦꠖꠤ ꠎꠣꠁꠔꠦ ꠖꠤꠟ ꠘꠣ, ꠄꠞꠟꠣꠉꠤ ꠄꠞꠣ ꠢꠇꠟ ꠚꠤꠞꠤꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","ꠄꠞꠛꠣꠖꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠇꠣꠖꠦꠡ ꠕꠣꠇꠤ ꠞꠅꠀꠘꠣ ꠅꠁꠀ ꠢꠥꠞ ꠙꠣꠠꠞ ꠉꠦꠍꠦ ꠉꠤꠀ ꠀꠎꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","ꠢꠤꠘꠅ ꠁꠖꠥꠝ ꠖꠦꠡꠞ ꠡꠤꠝꠣꠘꠣꠞ ꠗꠣꠞꠅ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“ꠢꠣꠞꠥꠘ ꠔ ꠔꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠉꠦꠍꠦ ꠇꠄꠛꠞꠅ ꠎꠣꠁꠔꠦꠉꠤ ꠅꠁꠛ। ꠀꠞ ꠀꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠦ ꠖꠦꠡ ꠖꠤꠝꠥ, ꠢꠦ ꠔ ꠢꠤ ꠖꠦꠡꠅ ꠎꠣꠁꠔ ꠙꠣꠞꠔ ꠘꠣꠄ। ꠝꠘꠅ ꠀꠍꠦ ꠘꠤ, ꠝꠦꠞꠤꠛꠣ ꠘꠣꠝꠞ ꠎꠣꠉꠣꠔ ꠙꠣꠘꠤꠞ ꠛꠦꠙꠣꠞꠦ ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠢꠥꠇꠥꠝꠞ ꠃꠟꠐꠣ ꠇꠣꠝ ꠇꠞꠍ। ");
INSERT INTO syls_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","ꠔꠦ ꠢꠣꠞꠥꠘ ꠀꠞ ꠔꠣꠞ ꠙꠥꠀ ꠀꠟꠤ-ꠀꠎꠞꠞꠦ ꠟꠁꠀ ꠔꠥꠝꠤ ꠢꠥꠞ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠃꠑꠅ। ");
INSERT INTO syls_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","ꠃꠑꠤꠀ ꠢꠣꠞꠥꠘꠞ ꠉꠔꠞ ꠕꠣꠇꠤ ꠁꠝꠣꠝꠔꠤ ꠟꠦꠛꠣꠍ ꠈꠥꠟꠤꠀ ꠔꠣꠞ ꠙꠥꠀꠞꠦ ꠚꠤꠘ꠆ꠖꠣꠅ, ꠇꠣꠞꠘ ꠢꠣꠞꠥꠘ ꠔꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠉꠦꠍꠦ ꠎꠣꠁꠛꠉꠤ, ꠢꠘꠅꠃ ꠔꠣꠞ ꠁꠘ꠆ꠔꠦꠇꠣꠟ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","ꠝꠥꠍꠣꠄ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠅꠟꠣ ꠇꠞꠟꠣ। ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠍꠣꠝꠘꠦ ꠔꠣꠞꠣ ꠢꠥꠞ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠃꠑꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","ꠃꠑꠣꠞ ꠛꠣꠖꠦ ꠝꠥꠍꠣꠄ ꠢꠣꠞꠥꠘꠞ ꠁꠝꠣꠝꠔꠤ ꠟꠦꠛꠣꠍ ꠈꠥꠟꠤꠀ ꠢꠣꠞꠤ ꠄꠘ ꠙꠥꠀ ꠀꠟꠤ-ꠀꠎꠞꠞꠦ ꠚꠤꠘ꠆ꠖꠣꠁꠟꠣ। ꠢꠃ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠢꠣꠞꠥꠘꠦ ꠁꠘ꠆ꠔꠦꠇꠣꠟ ꠇꠞꠟꠣ। ꠛꠣꠖꠦ ꠝꠥꠍꠣ ꠀꠞ ꠀꠟꠤ-ꠀꠎꠞ ꠙꠣꠠ ꠕꠣꠇꠤ ꠟꠣꠝꠤꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠢꠣꠞꠥꠘꠞ ꠝꠃꠔꠞ ꠈꠛꠞ ꠢꠥꠘꠤꠀ ꠙꠥꠞꠣ ꠔꠤꠡ ꠖꠤꠘ ꠔꠣꠘ ꠟꠣꠉꠤ ꠝꠣꠔ꠆ꠔꠝ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","ꠀꠞ ꠇꠦꠘꠣꠘꠤ ꠎꠣꠔꠤꠞ ꠅꠞꠣꠖ ꠖꠦꠡꠞ ꠛꠣꠖꠡꠣ ꠘꠦꠉꠦꠜ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠛꠡꠔ ꠇꠞꠂꠘ, ꠄꠁꠘ ꠈꠛꠞ ꠙꠣꠁꠟꠣ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠎꠣꠔꠤ ꠅꠕꠣꠞꠤꠝꠞ ꠙꠕꠦꠖꠤ ꠀꠐꠤꠀ ꠀꠁꠞꠣ, ꠅꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠛꠣꠖꠡꠣꠄ ꠔꠣꠞꠣꠞ ꠃꠙꠞꠦ ꠢꠣꠝꠟꠣ ꠇꠞꠤꠀ ꠇꠄꠎꠘꠞꠦ ꠗꠞꠤꠀ ꠘꠤꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","ꠔꠦꠃ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠝꠣꠘ꠆ꠘꠔ ꠝꠣꠘꠤꠀ ꠇꠁꠟ, “ꠅ ꠝꠣꠛꠥꠖ, ꠔꠥꠝꠤ ꠎꠥꠖꠤ ꠅꠞꠣꠖꠞ ꠅꠃ ꠛꠣꠡꠤꠘ꠆ꠖꠣ ꠅꠇꠟꠞꠦ ꠀꠝꠞꠣꠞ ꠀꠔꠅ ꠡꠙꠤꠀ ꠖꠦꠅ, ꠔꠦ ꠀꠝꠞꠣ ꠔꠣꠞꠣꠞ ꠉꠣꠃ-ꠉꠦꠞꠣꠝ ꠀꠞ ꠐꠣꠃꠘ ꠅꠇꠟ ꠄꠇ꠆ꠇꠦꠛꠣꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠤꠟꠤꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","ꠝꠣꠛꠥꠖꠦ ꠔꠣꠞꠣꠞ ꠝꠤꠘꠔꠤ ꠇꠛꠥꠟ ꠇꠞꠟꠣ, ꠀꠞ ꠅꠘꠞ ꠇꠦꠘꠣꠘꠤ ꠅꠇꠟꠞꠦ ꠔꠣꠞꠣꠞ ꠀꠔꠅ ꠡꠙꠤ ꠖꠤꠟꠣ। ꠔꠣꠞꠣ ꠄꠞꠣ ꠢꠇ꠆ꠇꠟꠞꠦ ꠀꠞ ꠄꠞꠣꠞ ꠐꠣꠃꠘ ꠅꠇꠟꠞꠦ ꠄꠇ꠆ꠇꠦꠛꠣꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠤꠟ꠆ꠟ। ꠄꠞꠟꠣꠉꠤ ꠅꠃ ꠎꠣꠉꠣꠞ ꠘꠣꠝ ꠅꠁꠟ ꠢꠞ꠆ꠝꠣ, ꠝꠣꠘꠤ ꠛꠤꠘꠣꠡ। ");
INSERT INTO syls_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","ꠄꠞꠛꠣꠖꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠁꠖꠥꠝ ꠖꠦꠡꠞ ꠉꠣꠟꠣꠛꠣꠄ ꠊꠥꠞꠤꠀ ꠎꠣꠅꠀꠞ ꠟꠣꠉꠤ ꠢꠥꠞ ꠙꠣꠠꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠘꠤꠟ ꠖꠞꠤꠀꠞ ꠙꠣꠞꠦꠖꠤ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣ। ꠅꠁꠟꠦ ꠙꠕꠞ ꠝꠣꠎꠦ ꠔꠣꠞꠣ ꠅꠗꠂꠞ꠆ꠎ ꠅꠁꠀ, ");
INSERT INTO syls_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","ꠝꠥꠍꠣ ꠘꠛꠤ ꠀꠞ ꠀꠟ꠆ꠟꠣ ꠙꠣꠇꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠝꠣꠔꠣ-ꠝꠣꠔꠤ ꠟꠣꠉꠣꠁꠟꠣ, ꠔꠣꠞꠣ ꠇꠁꠟꠣ, “ꠀꠝꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠇꠦꠘꠦ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠟꠣꠄ, ꠅꠃ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠀꠘꠤꠀ ꠝꠣꠞꠣꠞ ꠟꠣꠉꠤ ꠘꠤ? ꠁꠘꠅ ꠔ ꠈꠣꠘꠤꠅ ꠘꠣꠁ, ꠙꠣꠘꠤꠅ ꠘꠣꠁ। ꠀꠞ ꠅꠟꠣ ꠛꠣꠎꠦ ꠈꠣꠘꠤ ꠀꠝꠞꠣ ꠖꠥꠁ ꠌꠃꠈꠦ ꠖꠦꠈꠔꠣꠝ ꠙꠣꠞꠤ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","ꠅꠃ ꠡꠝꠄ ꠝꠣꠛꠥꠖꠦ ꠔꠣꠞꠣꠞ ꠝꠣꠎꠦ ꠛꠃꠔ ꠛꠤꠡꠣꠇ꠆ꠔ ꠢꠣꠚ ꠙꠣꠑꠣꠁꠟꠣ। ꠢꠣꠚꠞ ꠇꠣꠝꠠꠦ ꠔꠣꠞꠣꠞ ꠛꠃꠔ ꠎꠘ ꠝꠣꠞꠣ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","ꠔꠦꠃ ꠝꠣꠘꠡꠦ ꠉꠤꠀ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠞꠣ ꠔ ꠀꠙꠘꠣꠞ ꠀꠞ ꠝꠣꠛꠥꠖꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠝꠣꠔꠤꠀ ꠉꠥꠘꠣ ꠇꠞꠤꠟꠤꠍꠤ। ꠔꠦ ꠀꠙꠘꠦ ꠅꠈꠘ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠝꠤꠘꠔꠤ ꠇꠞꠃꠇ꠆ꠇꠣ, ꠎꠣꠔꠦ ꠅꠃ ꠢꠣꠚ ꠉꠥꠁꠘ ꠀꠝꠞꠣꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠢꠞꠣꠁꠀ ꠘꠦꠁꠘꠉꠤ।” ꠔꠦꠃ ꠝꠥꠍꠣꠄ ꠔꠣꠞꠣꠞ ꠟꠣꠉꠤ ꠝꠤꠘꠔꠤ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠄꠇꠐꠣ ꠢꠣꠚ ꠛꠣꠘꠣꠁꠀ ꠃꠌꠣ ꠄꠇ ꠈꠥꠐꠤꠞ ꠃꠙꠞꠦ ꠕꠅ। ꠎꠦ ꠝꠣꠘꠡꠞꠦ ꠢꠣꠚꠦ ꠇꠣꠝꠠꠣꠁꠛ, ꠢꠦ ꠔꠥꠝꠣꠞ ꠅꠃ ꠢꠣꠚꠞ ꠛꠣꠄ ꠌꠣꠁꠟꠦ ꠜꠣꠟꠣ ꠅꠁꠎꠤꠛ।” ");
INSERT INTO syls_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","ꠔꠦꠃ ꠝꠥꠍꠣꠄ ꠈꠣꠐꠤ ꠔꠣꠝꠣꠖꠤ ꠄꠇ ꠢꠣꠚ ꠛꠣꠘꠣꠁꠀ ꠈꠥꠐꠤꠞ ꠃꠙꠞꠦ ꠕꠁꠟꠣ। ꠇꠥꠘꠥ ꠎꠘꠞꠦ ꠢꠣꠚꠦ ꠇꠣꠝꠠꠣꠁꠟꠦ ꠢꠦ ꠅꠃ ꠔꠣꠝꠣꠞ ꠢꠣꠚꠞ ꠛꠣꠄ ꠌꠣꠁꠔ, ꠀꠞ ꠛꠣꠌꠤꠎꠤꠔ। ");
INSERT INTO syls_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","ꠛꠣꠖꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣ, ꠀꠞ ꠅꠛꠥꠔ ꠘꠣꠝꠞ ꠎꠣꠉꠣꠔ ꠉꠤꠀ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","ꠀꠞ ꠅꠛꠥꠔ ꠕꠣꠇꠤ ꠞꠅꠀꠘꠣ ꠅꠁꠀ ꠝꠥꠀꠛ ꠖꠦꠡꠞ ꠙꠥꠛꠞ ꠡꠤꠝꠣꠘꠣꠔ, ꠝꠞꠥꠜꠥꠝꠤꠞ ꠁꠀ-ꠀꠛꠣꠞꠤꠝꠅ ꠀꠁꠀ ꠔꠣꠝ꠆ꠛꠥ ꠐꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","ꠅꠈꠣꠘ ꠕꠣꠇꠤ ꠞꠅꠀꠘꠣ ꠅꠁꠀ ꠎꠦꠞꠦꠖ ꠘꠣꠝꠞ ꠢꠥꠇꠘꠣ ꠈꠣꠟꠞ ꠙꠣꠞꠅ ꠉꠤꠀ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","ꠎꠦꠞꠦꠖ ꠕꠣꠇꠤ ꠞꠅꠀꠘꠣ ꠖꠤꠀ ꠅꠞꠘꠘ ꠢꠥꠇꠘꠣ ꠈꠣꠟꠞ ꠢꠙꠣꠞꠅ ꠉꠤꠀ ꠔꠣꠝ꠆ꠛꠥ ꠐꠣꠘꠣꠁꠟꠣ। ꠀꠝꠥꠞꠤ ꠅꠇꠟꠞ ꠖꠦꠡꠅ ꠕꠣꠇꠤ ꠎꠦ ꠝꠞꠥꠜꠥꠝꠤ ꠡꠥꠞꠥ ꠅꠁꠍꠦ, ꠁ ꠈꠣꠟ ꠀꠍꠤꠟ ꠅꠃ ꠝꠞꠥꠜꠥꠝꠤꠔ। ꠈꠣꠟꠞ ꠄꠇ ꠙꠣꠞꠅ ꠝꠥꠀꠛ ꠖꠦꠡ, ꠅꠁꠘ꠆ꠘ ꠙꠣꠞꠅ ꠀꠝꠥꠞꠤ ꠅꠇꠟꠞ ꠖꠦꠡ। ");
INSERT INTO syls_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","ꠝꠣꠛꠥꠖꠞ ꠎꠤꠢꠣꠖ ꠘꠣꠝꠞ ꠇꠤꠔꠣꠛꠅ ꠔ ꠀꠍꠦ, “ꠡꠥꠚꠣ ꠄꠟꠣꠇꠣꠞ ꠛꠣꠢꠦꠛ ꠀꠞ ꠅꠞꠘꠘ ꠢꠥꠇꠘꠣ ꠈꠣꠟ, ");
INSERT INTO syls_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ꠀꠃꠞ ꠐꠣꠃꠘꠞ ꠝꠥꠈꠣ ꠎꠣꠅꠞꠣ ꠃꠌꠣ-ꠘꠤꠌꠣ ꠘꠣꠟ, ꠁꠔꠣ ꠔ ꠝꠥꠀꠛ ꠖꠦꠡꠞ ꠄꠇ ꠡꠤꠝꠣꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","ꠅꠈꠣꠘ ꠕꠘꠦ ꠞꠅꠀꠘꠣ ꠅꠁꠀ ꠔꠣꠞꠣ ꠛꠦꠞ ꠘꠣꠝꠞ ꠄꠇ ꠇꠥꠀꠞ ꠉꠦꠍꠦ ꠀꠁꠟꠣ। ꠅꠘꠅ ꠀꠁꠀ ꠢꠣꠞꠟꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠢꠇꠟ ꠝꠣꠘꠡꠞꠦ ꠄꠇꠈꠣꠘꠅ ꠖꠟꠣ ꠇꠞꠅ, ꠀꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠙꠣꠘꠤ ꠖꠤꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠅꠃ ꠉꠎꠟ ꠉꠣꠁꠟ, “ꠅ ꠇꠥꠀ, ꠔꠥꠝꠣꠞ ꠙꠣꠘꠤ ꠃꠕꠟꠤꠀ ꠙꠠꠃꠇ। ꠔꠥꠝꠞꠣ ꠇꠥꠀꠞ ꠈꠣꠔꠤꠞꠦ ꠉꠎꠟ ꠉꠣꠅ। ");
INSERT INTO syls_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","ꠁꠇꠐꠣ ꠔ ꠢꠃ ꠡꠞ꠆ꠖꠣꠞ ꠅꠇꠟꠞ ꠇꠥꠀ, ꠞꠣꠎꠣ ꠅꠇꠟꠦ ꠔꠣꠞꠣꠞ ꠟꠣꠑꠤꠞ ꠛꠟꠦ ꠈꠥꠖꠤꠍꠂꠘ, ꠈꠣꠘ꠆ꠖꠣꠘꠤ ꠉꠟ꠆ꠟꠣꠞ ꠎꠥꠞꠦ ꠇꠞꠍꠂꠘ।” ꠛꠣꠖꠦ ꠔꠣꠞꠣ ꠝꠞꠥꠜꠥꠝꠤ ꠕꠣꠇꠤ ꠝꠔ꠆ꠔꠣꠘꠣ ꠘꠣꠝꠞ ꠎꠣꠉꠣꠔ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","ꠝꠔ꠆ꠔꠣꠘꠣ ꠕꠣꠇꠤ ꠘꠢꠟꠤꠄꠟ, ꠘꠢꠟꠤꠄꠟ ꠕꠣꠇꠤ ꠛꠣꠝꠥꠔ, ");
INSERT INTO syls_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","ꠛꠣꠝꠥꠔ ꠕꠣꠇꠤ ꠝꠥꠀꠛꠞ ꠙꠣꠠꠤꠀ ꠄꠇ ꠈꠣꠟꠞ ꠙꠣꠞꠅ ꠉꠦꠟꠣ। ꠅꠃ ꠈꠣꠟꠞ ꠇꠣꠘ꠆ꠖꠣꠞ ꠙꠤꠍꠉꠣ ꠙꠣꠠꠞ ꠃꠌꠣ ꠐꠤꠟ꠆ꠟꠣ ꠕꠣꠇꠤ ꠝꠞꠥꠜꠥꠝꠤ ꠖꠦꠈꠣ ꠎꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠀꠝꠥꠞꠤ ꠅꠇꠟꠞ ꠛꠣꠖꠡꠣ ꠍꠤꠢꠥꠘꠞ ꠉꠦꠍꠦ ꠝꠣꠘꠥꠡ ꠙꠣꠑꠣꠁꠀ ꠝꠤꠘꠔ ꠇꠞꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“ꠀꠝꠞꠣ ꠀꠙꠘꠣꠞ ꠖꠦꠡꠞ ꠜꠤꠔꠞꠦꠖꠤ ꠙꠣꠞ ꠅꠁ ꠎꠣꠁꠔꠣꠝ ꠌꠣꠁꠞꠣꠝ, ꠀꠝꠞꠣꠞꠦ ꠎꠣꠁꠛꠣꠞ ꠖꠤꠛꠣ ꠘꠤ? ꠀꠝꠞꠣ ꠔ ꠞꠣꠎ ꠙꠕ ꠍꠣꠠꠤꠀ ꠈꠦꠔ-ꠇꠤꠡꠤ ꠛꠣꠄ ꠛꠣ ꠀꠋꠉꠥꠞ ꠛꠣꠉꠣꠘꠦꠖꠤ ꠎꠣꠁꠔꠣꠝ ꠘꠣꠄ, ꠇꠥꠘꠥ ꠇꠥꠀꠞ ꠙꠣꠘꠤꠅ ꠈꠣꠁꠔꠣꠝ ꠘꠣꠄ। ꠀꠙꠘꠣꠞ ꠖꠦꠡꠞ ꠡꠤꠝꠣꠘꠣ ꠙꠣꠞꠘꠤꠞ ꠀꠉ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠣꠝꠦꠡꠣ ꠞꠣꠎ ꠙꠕꠦꠖꠤ ꠀꠐꠣꠔ ꠞꠁꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","ꠅꠁꠟꠦ ꠛꠣꠖꠡꠣ ꠍꠤꠢꠥꠘꠦ ꠔꠣꠘ ꠖꠦꠡꠞ ꠜꠤꠔꠞꠦꠖꠤ ꠔꠣꠞꠣꠞꠦ ꠎꠣꠁꠔꠦ ꠖꠤꠟꠣ ꠘꠣ। ꠔꠣꠁꠘ ꠔꠣꠘ ꠍꠤꠙꠣꠁ ꠖꠟ ꠟꠁꠀ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠝꠣꠎꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠉꠦ ꠎꠥꠖ꠆ꠖꠔ ꠛꠣꠞ ꠅꠁꠟꠣ। ꠔꠣꠁꠘ ꠁꠀꠢꠣꠎ ꠐꠣꠃꠘꠅ ꠀꠁꠀ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠎꠥꠖ꠆ꠖ ꠟꠣꠉꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","ꠎꠥꠖ꠆ꠖꠔ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠢꠃ ꠛꠣꠖꠡꠣꠞꠦ ꠔꠟꠥꠀꠞꠖꠤ ꠇꠣꠐꠤꠀ ꠅꠞꠘꠘ ꠈꠣꠟ ꠕꠣꠇꠤ ꠎꠣꠛ꠆ꠛꠥꠇ ꠈꠣꠟ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠔꠣꠞ ꠀꠡ꠆ꠔꠣ ꠖꠦꠡ ꠖꠈꠟ ꠇꠞꠤꠟꠤꠟꠣ। ꠔꠣꠞꠣ ꠛꠘꠤ-ꠀꠝ꠆ꠝꠣꠘꠞ ꠡꠤꠝꠣꠘꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠇꠟ ꠎꠣꠉꠣ ꠖꠈꠟ ꠇꠞꠟꠣ, ꠅꠁꠟꠦ ꠛꠘꠤ-ꠀꠝ꠆ꠝꠣꠘꠞ ꠡꠤꠝꠣꠘꠣ ꠀꠍꠤꠟ ꠈꠥꠛ ꠝꠎꠛꠥꠔ, ꠁꠈꠣꠘꠞꠦ ꠒꠤꠋꠉꠣꠁꠀ ꠎꠣꠅꠀ ꠇꠑꠤꠘ। ");
INSERT INTO syls_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠢꠤꠡꠛꠘ ꠀꠞ ꠄꠞ ꠀꠡ-ꠙꠣꠡꠞ ꠉꠣꠃ-ꠉꠦꠞꠣꠝ ꠡꠥꠖ꠆ꠖꠣ ꠀꠝꠥꠞꠤ ꠅꠇꠟꠞ ꠢꠇꠟ ꠐꠣꠃꠘ ꠖꠈꠟ ꠇꠞꠤꠀ ꠢꠘꠅ ꠛꠡꠔꠤ ꠉꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","ꠢꠤꠡꠛꠘ ꠀꠍꠤꠟ ꠔ ꠀꠝꠥꠞꠤ ꠛꠣꠖꠡꠣ ꠍꠤꠢꠥꠘꠞ ꠞꠣꠎꠗꠣꠘꠤ। ꠔꠣꠁꠘ ꠝꠥꠀꠛ ꠖꠦꠡꠞ ꠀꠉꠞ ꠛꠣꠖꠡꠣꠞ ꠟꠉꠦ ꠎꠥꠖ꠆ꠖ ꠇꠞꠤꠀ ꠅꠞꠘꠘ ꠈꠣꠟ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠀꠡ꠆ꠔꠣ ꠖꠦꠡ ꠖꠈꠟ ꠇꠞꠍꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","ꠄꠞꠟꠣꠉꠤ ꠇꠛꠤ ꠅꠇꠟꠦ ꠇꠂꠘ, “ꠀꠅ ꠔꠥꠝꠞꠣ ꠢꠇꠟ, ꠢꠤꠡꠛꠘ ꠐꠣꠃꠘꠅ ꠀꠅ, ꠞꠣꠎꠣ ꠍꠤꠢꠥꠘꠞ ꠐꠣꠃꠘꠞꠦ ꠘꠄꠀ ꠇꠞꠤ ꠛꠣꠘꠣꠅ। ");
INSERT INTO syls_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","ꠍꠤꠢꠥꠘꠞ ꠅꠃ ꠐꠣꠃꠘ ꠕꠣꠇꠤ ꠀꠉꠥꠁꠘ ꠛꠣꠞ ꠅꠁꠀ, ꠝꠥꠀꠛꠞ ꠀꠃꠞ ꠐꠣꠃꠘꠞꠦ ꠍꠣꠞꠈꠣꠞ ꠇꠞꠟ ꠎꠣꠟꠣꠁꠀ, ꠅꠞꠘꠘ ꠈꠣꠟꠞ ꠃꠌꠣ ꠎꠣꠉꠣ ꠛꠤꠘꠣꠡ ꠅꠁꠉꠦꠟ, ꠢꠘꠞ ꠢꠇꠟ ꠑꠣꠇꠥꠞꠞꠦ ꠎꠣꠟꠣꠁꠀ ꠝꠣꠔꠤꠟ꠆ꠟ। ");
INSERT INTO syls_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","ꠢꠣꠄꠞꠦ ꠝꠥꠀꠛ, ꠡꠞ꠆ꠛꠘꠣꠡ! ꠅ ꠇꠝꠥꠡ-ꠖꠦꠛꠔꠣꠞ ꠜꠇ꠆ꠔ ꠅꠇꠟ ꠔꠥꠝꠞꠣ ꠔ ꠛꠤꠘꠣꠡ ꠅꠁꠉꠦꠟꠣꠄ। ꠇꠝꠥꠡꠞ ꠙꠥꠀꠂꠘ ꠜꠣꠉꠤꠀ ꠢꠞꠤꠉꠦꠍꠦ, ꠔꠣꠞ ꠙꠥꠠꠤꠘ ꠅꠇꠟ ꠛꠘ꠆ꠖꠤ ꠅꠁꠍꠦ, ꠀꠝꠥꠞꠤ ꠛꠣꠖꠡꠣ ꠍꠤꠢꠥꠘꠞ ꠀꠔꠅ ꠛꠘ꠆ꠖꠤ ꠔꠣꠞꠣ। ");
INSERT INTO syls_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","ꠀꠝꠞꠣꠃ ꠔ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠎꠥꠖ꠆ꠖ ꠇꠞꠍꠤ, ꠖꠤꠛꠣꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠀꠡ꠆ꠔꠣ ꠢꠤꠡꠛꠘ ꠛꠤꠘꠣꠡ ꠇꠞꠍꠤ, ꠔꠣꠞꠣꠞ ꠛꠣꠔ꠆ꠔꠤ ꠀꠝꠞꠣ ꠘꠤꠜꠣꠁꠟꠤꠍꠤ, ꠘꠥꠚꠣ ꠀꠞ ꠝꠤꠖꠦꠛꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠗꠋꠡ-ꠟꠤꠟꠣ ꠌꠣꠟꠣꠁꠍꠤ।” ");
INSERT INTO syls_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","ꠄꠞꠛꠣꠖ ꠕꠣꠇꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠀꠝꠥꠞꠤ ꠅꠇꠟꠞ ꠖꠦꠡꠅ ꠛꠡꠔ ꠇꠞꠣꠔ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","ꠢꠎꠞꠔ ꠝꠥꠍꠣꠄ ꠎꠣꠎꠤꠞꠣ ꠐꠣꠃꠘꠅ ꠉꠥꠁꠀ ꠙꠣꠑꠣꠘꠤꠞ ꠛꠣꠖꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠅꠃ ꠐꠣꠃꠘꠞ ꠀꠡ-ꠙꠣꠡꠞ ꠉꠣꠃ-ꠉꠦꠞꠣꠝ ꠢꠇꠟꠔꠣ ꠖꠈꠟ ꠇꠞꠟꠣ, ꠀꠞ ꠢꠘꠞ ꠛꠣꠡꠤꠘ꠆ꠖꠣ ꠀꠝꠥꠞꠤ ꠅꠇꠟꠞꠦ ꠈꠦꠖꠣꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","ꠛꠣꠖꠦ ꠔꠣꠞꠣ ꠚꠤꠞꠤꠀ ꠛꠣꠡꠘ ꠖꠦꠡꠞ ꠛꠣꠄ ꠞꠅꠀꠘꠣ ꠅꠁꠟꠣ। ꠔꠦꠃ ꠛꠣꠡꠘꠞ ꠛꠣꠖꠡꠣ ꠃꠎꠦ ꠔꠣꠞ ꠢꠇꠟ ꠍꠤꠙꠣꠁ ꠟꠁꠀ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠎꠥꠖ꠆ꠖ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠁꠖꠞꠤ ꠐꠣꠃꠘꠅ ꠀꠁꠀ ꠀꠎꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","ꠅꠃ ꠡꠝꠄ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠛꠣꠖꠡꠣ ꠃꠎꠞꠦ ꠒꠞꠣꠁꠅ ꠘꠣ, ꠀꠝꠤ ꠔꠣꠞꠦ, ꠔꠣꠞ ꠀꠡ꠆ꠔꠣ ꠖꠦꠡꠞꠦ ꠀꠞ ꠢꠇꠟ ꠍꠤꠙꠣꠁꠞꠦ ꠔꠥꠝꠣꠞ ꠀꠔꠅ ꠔꠥꠟꠤ ꠖꠤꠍꠤ। ꠄꠞꠟꠣꠉꠤ ꠢꠤꠡꠛꠘꠞ ꠀꠝꠥꠞꠤ ꠅꠇꠟꠞ ꠛꠣꠖꠡꠣ ꠍꠤꠢꠥꠘꠞꠦ ꠔꠥꠝꠤ ꠎꠦ ꠖꠡꠣ ꠊꠐꠣꠁꠍꠟꠣꠄ, ꠅꠉꠥꠞꠦꠅ ꠅꠟꠣ ꠇꠞꠤꠅ।” ");
INSERT INTO syls_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","ꠔꠦꠃ ꠔꠣꠞꠣ ꠛꠣꠖꠡꠣ ꠃꠎ, ꠔꠣꠞ ꠙꠥꠀꠂꠘ ꠀꠞ ꠢꠇꠟ ꠝꠣꠘꠡꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠟꠣ। ꠢꠦꠡ-ꠝꠦꠡ ꠔꠣꠞꠣ ꠇꠦꠃ ꠀꠞ ꠎꠤꠘ꠆ꠖꠣ ꠞꠁꠟ ꠘꠣ। ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠅꠃ ꠙꠥꠞꠣ ꠖꠦꠡ ꠖꠈꠟ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","ꠄꠞꠛꠣꠖꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠉꠤꠀ ꠎꠤꠞꠤꠢꠅ ꠐꠣꠃꠘꠞ ꠃꠟꠐꠣꠛꠣꠄ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠗꠣꠞꠅ ꠝꠥꠀꠛ ꠖꠦꠡꠞ ꠔꠟ ꠎꠣꠉꠣꠔ ꠔꠣꠝ꠆ꠛꠥ ꠐꠣꠋꠉꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠀꠝꠥꠞꠤ ꠅꠇꠟꠞ ꠎꠦ ꠢꠣꠟꠔ ꠇꠞꠍꠤꠟ, ꠝꠥꠀꠛ ꠖꠦꠡꠞ ꠛꠣꠖꠡꠣ ꠛꠣꠟꠣꠇ ꠛꠤꠘ ꠡꠤꠙꠣꠞꠦ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠖꠦꠈꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠅꠔ ꠝꠣꠘꠥꠡ ꠖꠦꠈꠤꠀ ꠝꠥꠀꠛꠤ ꠅꠇꠟ ꠒꠞꠣꠁꠉꠦꠟꠣ। ꠀꠍꠟꠦꠃ ꠔꠣꠞꠣ ꠈꠥꠛ ꠛꠦꠡꠤ ꠊꠣꠛꠠꠤ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","ꠔꠣꠞꠣ ꠝꠣꠖꠤꠀꠘ ꠖꠦꠡꠞ ꠝꠥꠞꠛ꠆ꠛꠤ ꠘꠦꠔꠣ ꠅꠇꠟꠞꠦ ꠇꠁꠟꠣ, “ꠉꠞꠥꠄ ꠎꠦꠟꠣ ꠛꠘ꠆ꠖꠞ ꠈꠦꠍꠝꠣ ꠊꠣꠡꠞꠦ ꠟꠦꠁꠀ-ꠚꠥꠍꠤ ꠈꠣꠁꠟꠣꠄ, ꠅꠃ ꠖꠟꠦꠅ ꠅꠃꠟꠣ ꠀꠝꠞꠣꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠞ ꠢꠇꠟꠔꠣ ꠟꠦꠁꠀ-ꠚꠥꠍꠤ ꠈꠣꠁꠟꠤꠛ।” ꠅꠃ ꠡꠝꠄ ꠝꠥꠀꠛ ꠖꠦꠡꠞ ꠛꠣꠖꠡꠣ ꠀꠍꠟꠣ ꠛꠣꠟꠣꠇ ꠛꠤꠘ ꠡꠤꠙꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","ꠛꠣꠖꠡꠣꠄ ꠒꠞꠣꠁꠀ ꠛꠣꠟꠣꠝ ꠛꠤꠘ ꠛꠣꠃꠞ ꠘꠣꠝꠞ ꠙꠤꠞ ꠍꠣꠛꠞꠦ ꠀꠘꠣꠞ ꠟꠣꠉꠤ ꠈꠛꠞꠤꠀ ꠙꠣꠑꠣꠁꠟꠣ। ꠛꠣꠟꠣꠝ ꠔ ꠅꠃ ꠡꠝꠄ ꠔꠣꠘ ꠘꠤꠎꠞ ꠖꠦꠡꠞ ꠚꠥꠞꠣꠔ ꠉꠣꠋꠉꠞ ꠙꠣꠞꠅ ꠚꠔꠥꠞ ꠐꠣꠃꠘꠅ ꠀꠍꠟꠣ। ꠛꠣꠟꠣꠇꠦ ꠈꠛꠞꠤꠀꠞꠦ ꠇꠁꠀ ꠖꠤꠟꠣ, “ꠔꠥꠝꠞꠣ ꠉꠤꠀ ꠔꠣꠘꠞꠦ ꠇꠁꠅ, ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠄꠇꠖꠟ ꠝꠣꠘꠥꠡ ꠛꠣꠞ ꠅꠁꠀ ꠀꠁꠍꠦ। ꠀꠁꠀ ꠀꠡ꠆ꠔꠣ ꠎꠝꠤꠘ ꠜꠞꠤꠀ ꠈꠣꠟꠤ ꠉꠤꠍꠉꠤꠍ ꠇꠞꠞꠣ, ꠔꠣꠞꠣ ꠅꠈꠘ ꠀꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠛꠡꠔ ꠇꠞꠞꠣ। ");
INSERT INTO syls_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","ꠁꠔꠣ ꠔ ꠀꠝꠞꠣ ꠕꠣꠇꠤ ꠛꠦꠡꠤ ꠛꠟꠛꠣꠘ। ꠄꠞꠟꠣꠉꠤ ꠀꠙꠘꠦ ꠀꠃꠇ꠆ꠇꠣ, ꠀꠁꠀ ꠅꠔꠣꠞꠦ ꠟꠣꠘ꠆ꠘꠔ ꠖꠦꠃꠇ꠆ꠇꠣ। ꠔꠦꠃ ꠀꠝꠤ ꠢꠄꠔ ꠔꠣꠞꠣꠞꠦ ꠝꠣꠞꠤꠀ ꠖꠦꠡ ꠕꠣꠇꠤ ꠈꠦꠖꠣꠁꠔꠣꠝ ꠙꠣꠞꠝꠥ। ꠀꠞ ꠀꠝꠤ ꠔ ꠎꠣꠘꠤ, ꠀꠙꠘꠦ ꠎꠣꠞꠦ ꠖꠥꠀ ꠖꠦꠁꠘ ꠢꠦ ꠑꠤꠇꠃ ꠖꠥꠀ ꠙꠣꠄ, ꠀꠞ ꠎꠣꠞꠦ ꠟꠣꠘ꠆ꠘꠔ ꠖꠦꠁꠘ ꠔꠣꠞ ꠃꠙꠞꠦ ꠢꠣꠍꠣꠃ ꠟꠣꠘ꠆ꠘꠔ ꠙꠠꠦ।” ");
INSERT INTO syls_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","ꠔꠦꠃ ꠝꠥꠀꠛ ꠀꠞ ꠝꠣꠖꠤꠀꠘꠞ ꠝꠥꠞꠛ꠆ꠛꠤ ꠘꠦꠔꠣ ꠅꠇꠟꠦ ꠁꠡ꠆ꠔꠦꠈꠣꠞꠣ-ꠀꠎꠤꠞꠣꠔ ꠇꠞꠣꠘꠤꠞ ꠐꠦꠇꠣ ꠟꠁꠀ ꠞꠅꠀꠘꠣ ꠅꠁꠉꠦꠟꠣ। ꠛꠣꠖꠡꠣ ꠛꠣꠟꠣꠇꠦ ꠎꠦꠟꠣ ꠢꠤꠇꠣꠁ ꠖꠤꠍꠟꠣ, ꠔꠣꠞꠣ ꠉꠤꠀ ꠛꠣꠟꠣꠝꠞ ꠉꠦꠍꠦ ꠅꠟꠣ ꠇꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","ꠔꠦꠃ ꠛꠣꠟꠣꠝꠦ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠦ ꠀꠙꠘꠣꠞꠣ ꠀꠁꠎ ꠞꠣꠁꠔ ꠀꠝꠣꠞ ꠅꠘꠅ ꠞꠃꠇ꠆ꠇꠣ। ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞꠦ ꠎꠦꠔꠣ ꠎꠣꠘꠣꠁꠛꠣ, ꠀꠝꠤ ꠅꠔꠣ ꠀꠙꠘꠣꠞꠣꠞꠦ ꠎꠣꠘꠣꠁꠝꠥ।” ꠉꠔꠤꠇꠦꠃ ꠔꠣꠞꠣ ꠔꠣꠘ ꠅꠘꠅ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ꠝꠣꠛꠥꠖꠦ ꠛꠣꠟꠣꠝꠞ ꠉꠦꠍꠦ ꠎꠣꠁꠞ ꠅꠁꠀ ꠎꠤꠇꠣꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠟꠉꠦ ꠄꠞꠣ ꠇꠣꠞꠣ?” ");
INSERT INTO syls_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","ꠛꠣꠟꠣꠝꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠝꠥꠀꠛꠞ ꠛꠣꠖꠡꠣ ꠛꠣꠟꠣꠇ ꠛꠤꠘ ꠡꠤꠙꠣꠞꠦ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠈꠛꠞꠤꠀ ꠙꠣꠑꠣꠁꠍꠂꠘ, ");
INSERT INTO syls_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","ꠇꠁꠍꠂꠘ, ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠄꠇꠖꠟ ꠝꠣꠘꠥꠡ ꠀꠁꠀ ꠀꠡ꠆ꠔꠣ ꠖꠦꠡꠅ ꠉꠤꠍꠉꠤꠍ ꠇꠞꠞꠣ। ꠅꠈꠘ ꠀꠙꠘꠦ ꠀꠁꠀ ꠔꠣꠞꠣꠞꠦ ꠟꠣꠘ꠆ꠘꠔ ꠖꠦꠃꠇ꠆ꠇꠣ। ꠔꠦꠃ ꠀꠝꠤ ꠎꠥꠖ꠆ꠖ ꠇꠞꠤꠀ ꠔꠣꠞꠣꠞꠦ ꠛꠥꠟꠦ ꠈꠦꠖꠣꠁꠔꠣꠝ ꠙꠣꠞꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","ꠅꠁꠟꠦ ꠝꠣꠛꠥꠖꠦ ꠛꠣꠟꠣꠝꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠄꠞꠣꠞ ꠟꠉꠦ ꠎꠣꠁꠅ ꠘꠣ, ꠀꠞ ꠢꠤꠔꠣ ꠝꠣꠘꠡꠞꠦ ꠇꠥꠘꠥ ꠟꠣꠘ꠆ꠘꠔꠅ ꠖꠤꠅ ꠘꠣ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠔꠣꠞꠣ ꠀꠝꠣꠞ ꠞꠢꠝ-ꠛꠞꠇꠔ ꠙꠣꠅꠀ ꠛꠘ꠆ꠖꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","ꠛꠣꠖꠞ ꠖꠤꠘ ꠛꠤꠀꠘꠦ ꠛꠣꠟꠣꠝ ꠊꠥꠝ ꠕꠣꠇꠤ ꠃꠑꠤꠀ ꠛꠣꠟꠣꠇꠞ ꠈꠛꠞꠤꠀ ꠅꠇꠟꠞꠦ ꠇꠁꠟꠣ, “ꠀꠙꠘꠣꠞꠣ ꠎꠣꠞꠎꠤꠞ ꠖꠦꠡꠅ ꠚꠤꠞꠔ ꠎꠣꠃꠇ꠆ꠇꠣꠉꠤ। ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞꠦ ꠝꠣꠘꠣ ꠇꠞꠍꠂꠘ, ꠀꠙꠘꠣꠞꠣꠞ ꠟꠉꠦ ꠘꠣ ꠎꠣꠅꠀꠞ ꠟꠣꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","ꠔꠦꠃ ꠝꠥꠀꠛꠤ ꠘꠦꠔꠣ ꠅꠇꠟꠦ ꠚꠤꠞꠤꠀ ꠉꠤꠀ ꠛꠣꠖꠡꠣ ꠛꠣꠟꠣꠇꠞꠦ ꠇꠁꠟꠣ, “ꠛꠣꠟꠣꠝ ꠔ ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠀꠁꠔꠦ ꠞꠣꠎꠤ ꠅꠁꠍꠂꠘ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","ꠅꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠛꠣꠟꠣꠇꠦ ꠄꠞꠣꠞ ꠌꠣꠁꠔꠦ ꠀꠞꠅ ꠛꠦꠡꠤ, ꠀꠞꠅ ꠁꠎ꠆ꠎꠔꠤ ꠘꠦꠔꠣ ꠅꠇꠟꠞꠦ ꠙꠣꠑꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","ꠔꠣꠞꠣ ꠉꠤꠀ ꠛꠣꠟꠣꠝꠞꠦ ꠇꠁꠟꠣ, “ꠛꠣꠖꠡꠣ ꠛꠣꠟꠣꠇ ꠛꠤꠘ ꠡꠤꠙꠣꠞꠦ ꠇꠁꠍꠂꠘ, ꠀꠙꠘꠦ ꠔꠣꠘ ꠉꠦꠍꠦ ꠎꠣꠁꠔꠦ ꠇꠥꠘꠥꠎꠣꠔꠞ ꠇꠥꠘꠥ ꠛꠣꠗꠣ ꠝꠣꠘꠔꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","ꠔꠣꠁꠘ ꠀꠙꠘꠣꠞꠦ ꠛꠃꠔ ꠁꠎ꠆ꠎꠔ-ꠛꠈꠡꠤꠡ ꠖꠤꠛꠣ, ꠀꠞ ꠀꠙꠘꠦ ꠎꠦꠟꠣ ꠇꠁꠛꠣ, ꠔꠣꠁꠘ ꠅꠟꠣꠃ ꠇꠞꠛꠣ। ꠈꠣꠟꠤ ꠀꠙꠘꠦ ꠎꠣꠘꠥ ꠔꠣꠘ ꠙꠇ꠆ꠇ ꠟꠁꠀ ꠅꠔꠣ ꠝꠣꠘꠡꠞꠦ ꠟꠣꠘ꠆ꠘꠔ ꠖꠦꠁꠘ, ꠔꠣꠁꠘ ꠅꠈꠣꠘꠃ ꠌꠣꠁꠞꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","ꠛꠣꠟꠣꠝꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠛꠣꠖꠡꠣ ꠛꠣꠟꠣꠇꠦ ꠎꠥꠖꠤ ꠔꠣꠘ ꠡꠥꠘꠣ-ꠞꠥꠙꠣꠄ ꠜꠞꠣ ꠞꠣꠎꠛꠣꠠꠤ ꠈꠣꠘꠅ ꠀꠝꠣꠞꠦ ꠖꠤꠟꠣꠁꠘ, ꠔꠣ-ꠅ ꠀꠝꠣꠞ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝꠞ ꠃꠟꠐꠣ ꠉꠤꠀ ꠀꠝꠤ ꠄꠇꠈꠣꠘ ꠇꠣꠝꠅ ꠇꠞꠔꠣꠝ ꠘꠣꠄ, ꠁꠔꠣ ꠢꠥꠞꠥ ꠇꠣꠝ ꠅꠃꠇ ꠛꠣ ꠛꠠ ꠇꠣꠝ ꠅꠃꠇ। ");
INSERT INTO syls_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","ꠅꠁꠟꠦ ꠀꠙꠘꠣꠞꠣꠅ ꠀꠉꠞ ꠄꠞꠣꠞ ꠟꠣꠈꠣꠘ ꠀꠁꠎꠇꠥꠞ ꠞꠣꠁꠔ ꠈꠣꠘ ꠅꠘꠅ ꠇꠣꠐꠣꠁ ꠟꠣꠃꠇ꠆ꠇꠣ। ꠀꠝꠤ ꠖꠦꠈꠤ, ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞꠦ ꠘꠄꠀ ꠇꠥꠘ꠆ꠔꠣ ꠇꠂꠘ ꠘꠤ।” ");
INSERT INTO syls_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","ꠢꠃ ꠞꠣꠁꠔ ꠀꠟ꠆ꠟꠣꠄ ꠎꠣꠁꠞ ꠅꠁꠀ ꠛꠣꠟꠣꠝꠞꠦ ꠇꠁꠟꠣ, “ꠄꠞꠣ ꠎꠦꠛꠟꠣ ꠔꠥꠝꠣꠞꠦ ꠘꠦꠅꠀꠔ ꠀꠁꠍꠦ, ꠔꠦ ꠔꠥꠝꠤ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠎꠣꠅ। ꠉꠦꠟꠦ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠎꠦꠟꠣ ꠇꠁꠝꠥ, ꠔꠥꠝꠤ ꠈꠣꠟꠤ ꠅꠟꠣꠃ ꠇꠞꠤꠅ।” ");
INSERT INTO syls_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","ꠛꠣꠖꠞ ꠖꠤꠘ ꠛꠤꠀꠘꠦ ꠛꠣꠟꠣꠝ ꠙꠤꠞ ꠊꠥꠝ ꠕꠣꠇꠤ ꠃꠑꠤꠀ ꠔꠣꠘ ꠉꠣꠗꠤꠞ ꠃꠙꠞꠦ ꠉꠖꠤ ꠛꠤꠍꠣꠁꠀ ꠝꠥꠀꠛꠤ ꠘꠦꠔꠣ ꠅꠇꠟꠞ ꠟꠉꠦ ꠞꠅꠀꠘꠣ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","ꠔꠣꠘ ꠎꠣꠅꠀ ꠖꠦꠈꠤꠀ ꠀꠟ꠆ꠟꠣ ꠙꠣꠇ ꠔꠣꠘ ꠃꠙꠞꠦ ꠉꠥꠍꠣꠄ ꠀꠉꠥꠁꠘ ꠅꠁꠉꠦꠟꠣ। ꠔꠣꠘꠞꠦ ꠛꠣꠗꠣ ꠖꠤꠛꠣꠞ ꠈꠤꠀꠟꠦ ꠀꠟ꠆ꠟꠣꠞ ꠚꠤꠞꠤꠡ꠆ꠔꠣꠄ ꠙꠕ ꠀꠃꠉꠟꠤꠀ ꠃꠛꠣꠁ ꠞꠁꠟꠣ। ꠛꠣꠟꠣꠝ ꠔ ꠉꠣꠗꠤꠞ ꠃꠙꠞꠦ ꠌꠠꠤꠀ ꠎꠣꠁꠞꠣ, ꠔꠣꠘ ꠖꠥꠁꠎꠘ ꠌꠣꠇꠞ ꠔꠣꠘ ꠟꠉꠦ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","ꠝꠣꠛꠥꠖꠞ ꠚꠤꠞꠤꠡ꠆ꠔꠣꠄ ꠔꠟꠥꠀꠞ ꠀꠔꠅ ꠟꠁꠀ, ꠙꠕꠞ ꠝꠣꠎꠦ ꠃꠛꠣꠁ ꠞꠁꠍꠂꠘ ꠖꠦꠈꠤꠀ, ꠉꠣꠗꠤꠐꠣ ꠙꠕ ꠍꠣꠠꠤꠀ ꠎꠝꠤꠘꠦꠖꠤ ꠟꠣꠝꠤ ꠉꠦꠟ। ꠉꠣꠗꠤꠞꠦ ꠢꠤꠞꠛꠣꠞ ꠙꠕꠅ ꠔꠥꠟꠣꠞ ꠟꠣꠉꠤ ꠛꠣꠟꠣꠝꠦ ꠔꠣꠁꠞꠦ ꠝꠣꠁꠞ-ꠗꠁꠞ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠞ ꠚꠤꠞꠤꠡ꠆ꠔꠣ ꠎꠝꠤꠘꠞ ꠀꠋꠉꠥꠞ ꠛꠣꠉꠣꠘꠞ ꠖꠥꠁ ꠈꠦꠔꠞ ꠝꠣꠎꠞ ꠀꠁꠟꠞ ꠃꠙꠞꠦ ꠃꠛꠣꠁ ꠞꠁꠟꠣ। ꠀꠁꠟꠞ ꠖꠥꠁꠅ ꠉꠣꠟꠣꠛꠣꠄ ꠙꠣꠇꠣ ꠅꠀꠟ ꠖꠦꠅꠀ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","ꠝꠣꠛꠥꠖꠞ ꠚꠤꠞꠤꠡ꠆ꠔꠣꠞꠦ ꠖꠦꠈꠤꠀ ꠉꠣꠗꠤꠄ ꠅꠀꠟꠞ ꠉꠣꠟꠣꠛꠣꠄ ꠊꠦꠡꠤꠀ ꠉꠦꠟ। ꠄꠞꠖꠣꠄ ꠛꠣꠟꠣꠝꠞ ꠄꠇ ꠙꠣꠅ-ꠅ ꠈꠥꠛ ꠊꠡꠣ ꠟꠣꠉꠟ। ꠔꠦꠃ ꠔꠣꠁꠘ ꠢꠤꠞꠛꠣꠞ ꠉꠣꠗꠤꠞꠦ ꠝꠣꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠞ ꠚꠤꠞꠤꠡ꠆ꠔꠣ ꠀꠉꠥꠀꠁꠀ ꠉꠤꠀ ꠙꠕꠞ ꠝꠣꠎꠞ ꠅꠟꠣ ꠄꠇ ꠌꠤꠙꠣ ꠎꠣꠉꠣꠔ ꠃꠛꠣꠁꠟꠣ, ꠎꠦꠘꠅ ꠒꠣꠁꠘꠦ-ꠛꠣꠃꠄ ꠇꠥꠘꠥꠛꠣꠄ ꠢꠞꠣꠞ ꠃꠙꠣꠄ ꠘꠣꠁ। ");
INSERT INTO syls_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","ꠝꠣꠛꠥꠖꠞ ꠚꠤꠞꠤꠡ꠆ꠔꠣꠞꠦ ꠖꠦꠈꠤꠀ ꠉꠣꠗꠤꠄ ꠛꠣꠟꠣꠝꠞꠦ ꠟꠁꠀ ꠝꠣꠐꠤꠔ ꠢꠥꠔꠤ ꠉꠦꠟ। ꠔꠦꠃ ꠛꠣꠟꠣꠝ ꠀꠞꠅ ꠉꠞꠝ ꠅꠁꠀ ꠟꠣꠑꠤ ꠖꠤꠀ ꠉꠣꠗꠤꠞꠦ ꠝꠣꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","ꠅꠃ ꠡꠝꠄ ꠝꠣꠛꠥꠖꠦ ꠉꠣꠗꠤꠞ ꠝꠥꠈꠞ ꠎꠛꠣꠘ ꠈꠥꠟꠤ ꠖꠤꠟꠣ। ꠔꠣꠁ ꠛꠣꠟꠣꠝꠞꠦ ꠇꠁꠟ, “ꠀꠝꠤ ꠀꠙꠘꠣꠞꠦ ꠇꠤꠔꠣ ꠇꠞꠍꠤ, ꠀꠙꠘꠦ ꠔꠤꠘ-ꠔꠤꠘꠛꠣꠞ ꠀꠝꠣꠞꠦ ꠝꠣꠞꠟꠣ?” ");
INSERT INTO syls_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","ꠛꠣꠟꠣꠝꠦ ꠉꠣꠗꠤꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠁ ꠀꠝꠣꠞꠦ ꠀꠃꠀ ꠛꠣꠘꠣꠁꠀ ꠈꠦꠁꠠ ꠈꠦꠟꠣꠁꠞꠦ ꠘꠤ? ꠢꠥꠘ, ꠀꠝꠣꠞ ꠀꠔꠅ ꠎꠥꠖꠤ ꠄꠇꠈꠣꠘ ꠔꠟꠥꠀꠞ ꠕꠣꠇꠔ, ꠔꠦ ꠔꠞꠦ ꠍꠦꠖ ꠝꠣꠞꠤ ꠅꠈꠘꠃ ꠇꠣꠐꠤꠟ꠆ꠟꠣꠝ ꠅꠘꠦ।” ");
INSERT INTO syls_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","ꠉꠣꠗꠤꠄ ꠛꠣꠟꠣꠝꠞꠦ ꠇꠁꠟ, “ꠀꠝꠤ ꠀꠙꠘꠣꠞ ꠢꠃ ꠉꠣꠗꠤ ꠘꠣꠄ ꠘꠤ, ꠎꠦꠉꠥꠞ ꠃꠙꠞꠦ ꠀꠙꠘꠦ ꠢꠣꠞꠣ ꠎꠘꠝ ꠗꠞꠤ ꠌꠠꠤꠀ ꠀꠁꠞꠣ, ꠀꠞ ꠀꠙꠘꠣꠞ ꠟꠉꠦ ꠀꠝꠤ ꠇꠥꠘꠥꠖꠤꠘ ꠁꠟꠣ ꠇꠞꠍꠤ ꠘꠤ?” ꠛꠣꠟꠣꠝꠦ ꠇꠁꠟꠣ, “ꠘꠣ, ꠁꠟꠣ ꠇꠞꠍꠔ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠛꠣꠟꠣꠝꠞ ꠌꠃꠈ ꠈꠥꠟꠤꠀ ꠖꠤꠟꠣ, ꠔꠣꠁꠘ ꠖꠦꠈꠟꠣ, ꠝꠣꠛꠥꠖꠞ ꠚꠤꠞꠤꠡ꠆ꠔꠣꠄ ꠔꠟꠥꠀꠞ ꠟꠁꠀ ꠙꠕ ꠛꠘ꠆ꠖ ꠇꠞꠤ ꠃꠛꠣꠁ ꠞꠁꠍꠂꠘ। ꠖꠦꠈꠤꠀ ꠔꠣꠁꠘ ꠝꠣꠕꠣ ꠘꠥꠀꠁꠀ ꠘꠣꠇ-ꠇꠙꠣꠟ ꠝꠣꠐꠤꠔ ꠟꠣꠉꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","ꠔꠦꠃ ꠝꠣꠛꠥꠖꠞ ꠚꠤꠞꠤꠡ꠆ꠔꠣꠄ ꠔꠣꠘꠞꠦ ꠎꠤꠇꠣꠁꠟꠣ, “ꠔꠥꠝꠣꠞ ꠉꠣꠗꠤꠞꠦ ꠇꠦꠘꠦ ꠔꠤꠘ-ꠔꠤꠘꠛꠣꠞ ꠝꠣꠞꠟꠣꠄ? ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠀꠝꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠇꠣꠝ ꠇꠞꠣꠔ ꠎꠣꠁꠞꠣꠄꠉꠤ ꠖꠦꠈꠤꠀ, ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠀꠐꠇꠣꠁꠛꠣꠞ ꠟꠣꠉꠤ ꠅꠘꠅ ꠀꠁꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","ꠔꠥꠝꠣꠞ ꠉꠣꠗꠤꠄ ꠀꠝꠣꠞꠦ ꠖꠦꠈꠤꠀ ꠔꠤꠘ-ꠔꠤꠘꠛꠣꠞ ꠢꠞꠤꠀ ꠉꠦꠍꠦꠉꠤ। ꠔꠣꠁ ꠎꠥꠖꠤ ꠘꠣ ꠢꠞꠔ, ꠔꠦ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠝꠣꠞꠤꠟ꠆ꠟꠣꠝ ꠅꠘꠦ, ꠀꠞ ꠔꠣꠁꠞꠦ ꠛꠣꠌꠣꠁ ꠞꠣꠈꠟꠣꠝ ꠅꠘꠦ।” ");
INSERT INTO syls_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","ꠅꠃ ꠡꠝꠄ ꠛꠣꠟꠣꠝꠦ ꠝꠣꠛꠥꠖꠞ ꠚꠤꠞꠤꠡ꠆ꠔꠣꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠔ ꠉꠥꠘꠣ ꠇꠞꠍꠤ। ꠀꠍꠟꠦ ꠀꠝꠤ ꠛꠥꠎꠍꠤ ꠘꠣ, ꠀꠙꠘꠦ ꠀꠝꠣꠞꠦ ꠀꠐꠇꠣꠁꠛꠣꠞ ꠟꠣꠉꠤ ꠙꠕꠅ ꠃꠛꠣꠔ ꠀꠍꠂꠘ। ꠔꠦ ꠀꠙꠘꠦ ꠘꠣꠞꠣꠎ ꠅꠁꠟꠦ ꠀꠝꠤ ꠚꠤꠞꠤꠀ ꠎꠣꠁꠝꠥꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","ꠝꠣꠛꠥꠖꠞ ꠚꠤꠞꠤꠡ꠆ꠔꠣꠄ ꠛꠣꠟꠣꠝꠞꠦ ꠇꠁꠟꠣ, “ꠑꠤꠇ ꠀꠍꠦ, ꠔꠥꠝꠤ ꠅꠔꠣ ꠝꠣꠘꠡꠞ ꠟꠉꠦ ꠎꠣꠅ। ꠅꠁꠟꠦ ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠤꠇꠣꠁ ꠖꠤꠝꠥ, ꠔꠥꠝꠤ ꠈꠣꠟꠤ ꠅꠟꠣꠃ ꠇꠁꠛꠣꠄ।” ꠔꠦꠃ ꠛꠣꠖꠡꠣ ꠛꠣꠟꠣꠇꠞ ꠙꠣꠑꠣꠁꠟ ꠘꠦꠔꠣ ꠅꠇꠟꠞ ꠟꠉꠦ ꠛꠣꠟꠣꠝ ꠙꠤꠞ ꠌꠟꠣꠔ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","ꠛꠣꠟꠣꠝ ꠙꠤꠞꠞ ꠀꠅꠀꠞ ꠈꠛꠞ ꠢꠥꠘꠤꠀ, ꠔꠣꠘꠞꠦ ꠀꠉꠥꠀꠁꠀ ꠀꠘꠣꠞ ꠟꠣꠉꠤ ꠛꠣꠖꠡꠣ ꠛꠣꠟꠣꠇ ꠅꠞꠘꠘ ꠈꠣꠟꠞ ꠙꠣꠞꠅ ꠝꠥꠀꠛ ꠖꠦꠡꠞ ꠄꠇ ꠐꠣꠃꠘꠅ ꠉꠦꠟꠣ। ꠁ ꠐꠣꠃꠘ ꠀꠍꠤꠟ ꠔꠣꠘ ꠖꠦꠡꠞ ꠢꠦꠡ ꠡꠤꠝꠣꠘꠣꠔ। ");
INSERT INTO syls_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","ꠛꠣꠖꠡꠣ ꠛꠣꠟꠣꠇꠦ ꠛꠣꠟꠣꠝ ꠙꠤꠞꠞꠦ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠔ ꠀꠙꠘꠣꠞꠦ ꠎꠞꠥꠞꠤ ꠔꠟꠛ ꠇꠞꠟꠣꠝ। ꠔꠦ ꠀꠙꠘꠦ ꠇꠦꠘꠦ ꠙꠄꠟꠣ ꠛꠣꠞ ꠀꠁꠟꠣ ꠘꠣ? ꠀꠙꠘꠣꠞꠦ ꠎꠁꠉ꠆ꠉ ꠛꠈꠡꠤꠡ ꠖꠤꠛꠣꠞ ꠈꠦꠝꠔꠣ ꠇꠥꠘꠥ ꠀꠝꠣꠞ ꠘꠣꠁ ꠘꠤ?” ");
INSERT INTO syls_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","ꠛꠣꠟꠣꠝꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠀꠝꠤ ꠅꠈꠘ ꠀꠙꠘꠣꠞ ꠉꠦꠍꠦ ꠀꠁꠍꠤ। ꠅꠁꠟꠦ ꠀꠝꠣꠞ ꠘꠤꠎꠞ ꠇꠥꠘꠥ ꠝꠣꠔ ꠝꠣꠔꠣꠞ ꠡꠣꠁꠖ꠆ꠖ ꠘꠣꠁ। ꠈꠣꠟꠤ ꠀꠟ꠆ꠟꠣꠄ ꠀꠝꠣꠞꠦꠖꠤ ꠎꠦꠔꠣ ꠇꠅꠀꠁꠛꠣ, ꠀꠝꠤ ꠈꠣꠟꠤ ꠅꠈꠣꠘꠃ ꠇꠁꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","ꠄꠞꠛꠣꠖꠦ ꠛꠣꠟꠣꠇ ꠛꠣꠖꠡꠣꠞ ꠟꠉꠦ ꠅꠁꠀ ꠛꠣꠟꠣꠝ ꠙꠤꠞ ꠇꠤꠞꠤꠅꠔ-ꠢꠥꠍꠥꠔ ꠉꠣꠃꠔ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","ꠉꠤꠀ ꠛꠣꠖꠡꠣ ꠛꠣꠟꠣꠇꠦ ꠉꠞꠥ ꠀꠞ ꠝꠦꠠꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠀ ꠇꠤꠍꠥ ꠉꠥꠡ꠆ꠔ ꠛꠣꠟꠣꠝ ꠙꠤꠞꠞꠦ ꠀꠞ ꠔꠣꠘ ꠟꠉꠞ ꠢꠃ ꠘꠦꠔꠣ ꠅꠇꠟꠞꠦ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","ꠛꠣꠖꠞ ꠖꠤꠘ ꠛꠤꠀꠘꠦ ꠛꠣꠖꠡꠣ ꠛꠣꠟꠣꠇꠦ ꠅꠃ ꠛꠣꠟꠣꠝꠞꠦ ꠟꠁꠀ ꠛꠣꠝꠥꠔ-ꠛꠣꠀꠟ ꠙꠣꠠꠅ ꠉꠦꠟꠣ। ꠢꠘꠅ ꠃꠛꠣꠁꠀ ꠛꠣꠟꠣꠝꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠄꠇ ꠅꠋꠡꠞꠦ ꠖꠦꠈꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","ꠀꠞ ꠅꠃ ꠛꠤꠀꠘꠇꠥ ꠛꠣꠟꠣ ꠛꠣꠟꠣꠝ ꠙꠤꠞꠦ ꠛꠣꠟꠣꠇ ꠛꠣꠖꠡꠣꠞꠦ ꠇꠁꠟꠣ, “ꠀꠙꠘꠦ ꠀꠝꠣꠞ ꠟꠣꠉꠤ ꠡꠣꠔꠈꠣꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠃꠇ꠆ꠇꠣ, ꠛꠣꠘꠣꠁꠀ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠡꠣꠔꠉꠥ ꠛꠤꠍꠣꠟ ꠀꠞ ꠡꠣꠔꠉꠥ ꠝꠦꠠꠣ ꠎꠥꠉꠣꠁ ꠖꠦꠃꠇ꠆ꠇꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","ꠛꠣꠟꠣꠝꠞ ꠇꠕꠣꠝꠔꠃ ꠛꠣꠟꠣꠇꠦ ꠅꠟꠣ ꠇꠞꠟꠣ, ꠇꠞꠤꠀ ꠖꠥꠁꠅꠎꠘꠦ ꠝꠤꠟꠤꠀ ꠙꠞꠔꠦꠇ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠄꠉꠥ ꠇꠞꠤ ꠛꠤꠍꠣꠟ ꠀꠞ ꠄꠉꠥ ꠇꠞꠤ ꠝꠦꠠꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","ꠄꠞꠛꠣꠖꠦ ꠛꠣꠟꠣꠝ ꠙꠤꠞꠦ ꠛꠣꠟꠣꠇꠞꠦ ꠇꠁꠟꠣ, “ꠀꠙꠘꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅꠀ ꠅꠃ ꠙꠡꠥꠞ ꠇꠣꠍꠣꠔ ꠀꠙꠘꠦ ꠞꠃꠇ꠆ꠇꠣ। ꠀꠝꠤ ꠕꠥꠠꠣ ꠢꠞꠤꠀ ꠎꠣꠁꠞꠣꠝ, ꠅꠁꠔ ꠙꠣꠞꠦ ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞꠦ ꠖꠞꠡꠘ ꠖꠤꠛꠣ। ꠔꠣꠁꠘ ꠀꠝꠣꠞꠦ ꠎꠦꠔꠣ ꠎꠣꠘꠣꠁꠛꠣ, ꠀꠝꠤ ꠀꠁꠀ ꠀꠙꠘꠣꠞꠦ ꠇꠁꠝꠥꠘꠦ।” ꠅꠈꠣꠘ ꠇꠁꠀ ꠛꠣꠟꠣꠝ ꠙꠤꠞ ꠉꠤꠀ ꠙꠣꠠꠞ ꠢꠇꠟ ꠕꠣꠇꠤ ꠃꠌꠣ ꠐꠤꠟ꠆ꠟꠣꠞ ꠃꠙꠞꠦ ꠃꠑꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ꠅꠃ ꠡꠝꠄ ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘꠞꠦ ꠖꠞꠡꠘ ꠖꠤꠟꠣ। ꠛꠣꠟꠣꠝ ꠙꠤꠞꠦ ꠝꠣꠛꠥꠖꠞꠦ ꠇꠁꠟꠣ, “ꠅ ꠝꠣꠛꠥꠖ, ꠔꠥꠝꠤ ꠔ ꠖꠦꠈꠞꠣꠄ, ꠀꠝꠤ ꠡꠣꠔꠈꠣꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠁꠍꠤ ꠀꠞ ꠙꠞꠔꠦꠇ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠄꠉꠥ ꠇꠞꠤ ꠛꠤꠍꠣꠟ ꠀꠞ ꠄꠉꠥ ꠇꠞꠤ ꠝꠦꠠꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠍꠤ।” ");
INSERT INTO syls_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","ꠔꠦꠃ ꠝꠣꠛꠥꠖꠦ ꠛꠣꠟꠣꠝ ꠙꠤꠞꠞꠦ ꠄꠇ ꠛꠥꠟꠤ ꠢꠤꠇꠣꠁ ꠖꠤꠟꠣ, ꠖꠤꠀ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠉꠤꠀ ꠛꠣꠟꠣꠇ ꠛꠣꠖꠡꠣꠞꠦ ꠅꠔꠣ ꠇꠁꠅ।” ");
INSERT INTO syls_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","ꠔꠦꠃ ꠛꠣꠟꠣꠝ ꠙꠤꠞꠦ ꠝꠥꠀꠛ ꠖꠦꠡꠞ ꠛꠣꠖꠡꠣ ꠛꠣꠟꠣꠇꠞ ꠉꠦꠍꠦ ꠚꠤꠞꠤꠀ ꠀꠁꠀ ꠖꠦꠈꠟꠣ, ꠛꠣꠖꠡꠣ ꠛꠣꠟꠣꠇꠦ ꠝꠥꠀꠛ ꠖꠦꠡꠞ ꠢꠇꠟ ꠝꠥꠞꠛ꠆ꠛꠤ ꠘꠦꠔꠣꠞꠦ ꠟꠁꠀ ꠔꠣꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠞꠣ ꠙꠡꠥꠞ ꠅꠘꠅ ꠃꠛꠣꠁ ꠞꠁꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","ꠅꠃ ꠡꠝꠄ ꠛꠣꠟꠣꠝ ꠙꠤꠞꠦ ꠀꠟ꠆ꠟꠣꠞ ꠢꠤꠇꠣꠁꠀ ꠖꠦꠅꠀ ꠅꠃ ꠛꠥꠟꠤ ꠢꠇꠟ ꠢꠥꠘꠣꠁꠟꠣ, ꠇꠁꠟꠣ, “ꠡꠤꠞꠤꠀ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠣꠟꠣꠇꠦ ꠀꠝꠣꠞꠦ ꠀꠘꠣꠁꠍꠂꠘ, ꠙꠥꠛꠞ ꠙꠣꠠ ꠅꠇꠟꠞ ꠗꠣꠞꠅ ꠕꠣꠇꠤ ꠝꠥꠀꠛꠞ ꠛꠣꠖꠡꠣ ꠛꠣꠟꠣꠇꠦꠃ ꠝꠞꠦ ꠎꠥꠉꠣꠁꠍꠂꠘ। ꠎꠥꠉꠣꠁꠀ ꠇꠁꠟꠣ, ꠀꠝꠣꠞ ꠙꠇ꠆ꠇ ꠟꠁꠀ ꠁꠀꠇꠥꠛꠞ ꠀꠅꠟꠣꠖ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠟꠣꠘ꠆ꠘꠔ ꠖꠦꠃꠇ꠆ꠇꠣ, ꠅꠔꠣꠞꠦ ꠛꠖ꠆ꠖꠥꠀ ꠖꠦꠃꠇ꠆ꠇꠣ। ");
INSERT INTO syls_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","ꠅꠁꠟꠦ ꠀꠟ꠆ꠟꠣꠄ ꠟꠣꠘ꠆ꠘꠔ ꠖꠤꠍꠂꠘ ꠘꠣ ꠎꠣꠞꠦ, ꠀꠝꠤ ꠇꠤꠟꠣꠘ ꠖꠤꠝꠥ ꠟꠣꠘ꠆ꠘꠔ ꠔꠣꠞꠦ? ꠝꠣꠛꠥꠖꠦ ꠈꠦꠔꠤ ꠇꠞꠣꠞ ꠇꠕꠣ ꠘꠣ ꠇꠞꠍꠂꠘ ꠎꠣꠞ, ꠀꠝꠤ ꠇꠤꠟꠣꠘ ꠈꠦꠔꠤꠞ ꠇꠕꠣ ꠇꠁꠔꠣꠝ ꠔꠣꠞ? ");
INSERT INTO syls_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","ꠖꠦꠈꠍꠤ ꠀꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠃꠌꠣ ꠐꠤꠟ꠆ꠟꠣ ꠕꠣꠇꠤ, ꠔꠣꠞꠣꠞ ꠛꠣꠄꠖꠤ ꠌꠣꠁꠍꠤ ꠔ ꠙꠣꠠꠞ ꠌꠥꠠꠣ ꠕꠣꠇꠤ, ꠖꠦꠈꠟꠣꠝ ꠀꠝꠤ ꠄꠞꠣ ꠅꠁꠟꠣ ꠅꠟꠣ ꠄꠇ ꠎꠣꠔꠤ, ꠔꠣꠞꠣ ꠞꠂꠘ ꠀꠟꠉ ꠅꠁꠀ ꠛꠣꠇꠤ ꠢꠇꠟ ꠕꠣꠇꠤ। ");
INSERT INTO syls_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","ꠁꠀꠇꠥꠛꠞ ꠀꠅꠟꠣꠖ ꠖꠦꠈꠤ ꠛꠣꠟꠥꠞ ꠖꠣꠘꠣꠞ ꠝꠔ, ꠉꠘꠤꠀ ꠚꠥꠠꠣꠁꠔ ꠔꠣꠞꠦ ꠇꠣꠞ ꠀꠍꠦ ꠡꠣꠁꠖ꠆ꠖ? ꠝꠞꠘ ꠎꠣꠘꠥ ꠅꠄ ꠀꠝꠣꠞ ꠘꠦꠇꠇꠣꠞ ꠅꠃ ꠖꠟꠞ ꠟꠣꠈꠣꠘ ꠀꠈꠦꠞꠣꠔꠅ ꠅꠃꠇ ꠝꠞ ꠔꠣꠞꠣꠞꠃ ꠟꠣꠈꠣꠘ।” ");
INSERT INTO syls_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠛꠣꠖꠡꠣ ꠛꠣꠟꠣꠇꠦ ꠛꠣꠟꠣꠝꠞꠦ ꠇꠁꠟꠣ, “ꠀꠙꠘꠦ ꠁꠔꠣ ꠇꠤꠔꠣ ꠇꠞꠟꠣ? ꠀꠙꠘꠣꠞꠦ ꠀꠘꠣꠁꠟꠣꠝ ꠀꠝꠣꠞ ꠖꠥꠡꠝꠘꠞꠦ ꠟꠣꠘ꠆ꠘꠔ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ, ꠀꠞ ꠀꠙꠘꠦ ꠈꠣꠟꠤ ꠔꠣꠞꠣꠞꠦ ꠖꠥꠀ ꠖꠤꠟꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","ꠛꠣꠟꠣꠝ ꠙꠤꠞꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞ ꠝꠥꠈꠅ ꠎꠦꠔꠣ ꠎꠥꠉꠣꠁ ꠖꠤꠍꠂꠘ, ꠁꠔꠣ ꠀꠝꠤ ꠇꠁꠝꠥ ꠘꠣ ꠇꠤꠟꠣ?” ");
INSERT INTO syls_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","ꠛꠣꠖꠦ ꠛꠣꠖꠡꠣ ꠛꠣꠟꠣꠇꠦ ꠛꠣꠟꠣꠝ ꠙꠤꠞꠞꠦ ꠇꠁꠟꠣ, “ꠀꠙꠘꠦ ꠀꠝꠣꠞ ꠟꠉꠦ ꠀꠞꠇ ꠎꠣꠉꠣꠔ ꠀꠃꠇ꠆ꠇꠣ। ꠢꠘ ꠕꠘꠦ ꠀꠙꠘꠣꠞ ꠌꠃꠈꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠖꠦꠈꠣ ꠙꠣꠁꠛꠣ। ꠔꠣꠞꠣ ꠢꠇꠟꠞꠦ ꠖꠦꠈꠣ ꠎꠣꠁꠔ ꠘꠣꠄ, ꠈꠣꠟꠤ ꠄꠇ ꠅꠋꠡꠞꠦ ꠀꠙꠘꠦ ꠖꠦꠈꠛꠣ, ꠖꠦꠈꠤꠀ ꠀꠙꠘꠦ ꠀꠝꠣꠞ ꠙꠇ꠆ꠇ ꠟꠁꠀ ꠔꠣꠞꠣꠞꠦ ꠟꠣꠘ꠆ꠘꠔ ꠖꠤꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","ꠅꠈꠣꠘ ꠇꠁꠀ ꠛꠣꠖꠡꠣ ꠛꠣꠟꠣꠇꠦ ꠔꠣꠘꠞꠦ ꠟꠁꠀ ꠙꠤꠍꠉꠣ ꠙꠣꠠꠞ ꠃꠙꠞꠞ ꠎꠚꠤꠝ ꠘꠣꠝꠞ ꠛꠘ꠆ꠖꠞ ꠝꠣꠎꠦ ꠟꠁꠀ ꠉꠦꠟꠣ। ꠉꠤꠀ ꠢꠘꠅ ꠡꠣꠔꠈꠣꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠁꠀ ꠙꠞꠔꠦꠇ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠔ ꠄꠉꠥ ꠇꠞꠤ ꠛꠤꠍꠣꠟ ꠀꠞ ꠄꠉꠥ ꠇꠞꠤ ꠝꠦꠠꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","ꠛꠣꠖꠦ ꠛꠣꠟꠣꠝ ꠙꠤꠞꠦ ꠛꠣꠖꠡꠣ ꠛꠣꠟꠣꠇꠞꠦ ꠇꠁꠟꠣ, “ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠘꠤꠅꠔꠦ ꠎꠦꠔꠣ ꠙꠡꠥ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠦꠅꠀ ꠅꠁꠍꠦ, ꠀꠙꠘꠦ ꠅꠔꠣꠞ ꠗꠣꠞꠅ ꠞꠃꠇ꠆ꠇꠣ। ꠀꠝꠤ ꠅꠤꠘ꠆ꠘꠛꠣꠄ ꠎꠣꠁꠞꠣꠝ, ꠝꠣꠛꠥꠖꠞ ꠖꠤꠖꠣꠞ ꠙꠣꠅꠀꠞ ꠀꠡꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","ꠝꠣꠛꠥꠖꠦ ꠛꠣꠟꠣꠝ ꠙꠤꠞꠞꠦ ꠖꠤꠖꠣꠞ ꠖꠤꠟꠣ, ꠀꠞ ꠔꠣꠞ ꠎꠛꠣꠘꠞ ꠝꠣꠎꠦ ꠇꠤꠍꠥ ꠛꠥꠟꠤ ꠎꠥꠉꠣꠁ ꠖꠤꠀ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠛꠣꠖꠡꠣ ꠛꠣꠟꠣꠇꠞ ꠉꠦꠍꠦ ꠀꠝꠣꠞ ꠢꠤꠇꠣꠁꠟ ꠅꠃ ꠝꠣꠔ ꠝꠣꠔꠤꠅ।” ");
INSERT INTO syls_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","ꠔꠦꠃ ꠔꠣꠁꠘ ꠛꠣꠖꠡꠣꠞ ꠉꠦꠍꠦ ꠉꠦꠟꠣ। ꠉꠤꠀ ꠖꠦꠈꠟꠣ ꠛꠣꠖꠡꠣꠄ ꠝꠥꠀꠛ ꠖꠦꠡꠞ ꠘꠦꠔꠣ ꠅꠇꠟꠞꠦ ꠟꠁꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠇꠞꠣ ꠙꠡꠥꠞ ꠉꠦꠍꠦ ꠃꠛꠣꠁ ꠞꠁꠍꠂꠘ। ꠛꠣꠖꠡꠣꠄ ꠔꠣꠘꠞꠦ ꠎꠤꠇꠣꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠦ ꠀꠙꠘꠣꠞꠦ ꠇꠤꠔꠣ ꠇꠁꠍꠂꠘ?” ");
INSERT INTO syls_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","ꠛꠣꠟꠣꠝ ꠙꠤꠞꠦ ꠅꠃ ꠡꠝꠄ ꠀꠟ꠆ꠟꠣꠞ ꠢꠤꠇꠣꠁꠟ ꠅꠃ ꠛꠥꠟꠤ ꠇꠁꠟꠣ, “ꠛꠣꠖꠡꠣ ꠛꠣꠟꠣꠇ ꠈꠤꠀꠟ ꠇꠞꠅ, ꠅꠈꠘ ꠢꠥꠘꠅ ꠖꠤꠀ ꠝꠘ, ꠄꠞꠦ ꠡꠤꠙꠣꠞꠞ ꠙꠥꠔ ꠛꠣꠟꠣꠇ, ꠝꠞ ꠇꠕꠣꠔ ꠖꠦꠅ ꠇꠣꠘ। ");
INSERT INTO syls_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","ꠀꠟ꠆ꠟꠣ ꠙꠣꠇ ꠔ ꠝꠣꠘꠥꠡ ꠘꠣꠄ ꠎꠦꠘ ꠝꠤꠍꠣ ꠝꠣꠔꠤꠛꠣ, ꠔꠣꠁꠘ ꠇꠥꠘꠥ ꠀꠖꠝ ꠡꠘ꠆ꠔꠣꠘ ꠘꠣꠄ ꠎꠦꠘ ꠖꠤꠟ ꠛꠖꠟꠣꠁꠛꠣ। ꠔꠣꠁꠘ ꠎꠦꠟꠣ ꠇꠕꠣ ꠇꠂꠘ ꠑꠤꠇ ꠅꠟꠣꠃ ꠇꠞꠂꠘ, ꠔꠣꠘ ꠅꠀꠖꠣ ꠅꠇꠟꠃ ꠘꠤꠌ꠆ꠌꠤꠔ ꠙꠥꠞꠣ ꠇꠞꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","ꠘꠦꠇ ꠖꠥꠀ ꠖꠤꠔꠣꠝ ꠇꠞꠤ ꠢꠥꠇꠥꠝ ꠎꠦꠟꠣ ꠙꠣꠁꠍꠤ, ꠇꠤꠟꠣ ꠛꠖꠟꠣꠁꠝꠥ ꠀꠝꠤ ꠝꠥꠘꠤꠛꠞ ꠅꠃ ꠝꠞ꠆ꠎꠤ? ");
INSERT INTO syls_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","ꠁꠀꠇꠥꠛꠞ ꠀꠅꠟꠣꠖꠞ ꠝꠣꠎꠦ ꠀꠟ꠆ꠟꠣꠄ ꠇꠥꠘꠥ ꠛꠖ-ꠘꠍꠤꠛ ꠖꠦꠈꠍꠂꠘ ꠘꠣ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠇꠙꠣꠟꠅ ꠇꠥꠘꠥ ꠖꠥꠈ-ꠝꠍꠤꠛꠔ ꠟꠦꠈꠍꠂꠘ ꠘꠣ। ꠔꠣꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠀꠍꠂꠘ ꠔꠣꠞꠣꠞ ꠝꠣꠟꠤꠇꠞ ꠎꠄ ꠉꠣꠘ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠟꠉꠦ ꠀꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠔꠣꠁꠘꠃ ꠔꠣꠞꠣꠞꠦ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠍꠂꠘ ꠔꠣꠞꠣꠞ ꠙꠇ꠆ꠇꠦ ꠔꠣꠁꠘ ꠅꠁꠟꠣ ꠎꠋꠟꠤ ꠛꠄꠞꠣꠞ ꠛꠟ। ");
INSERT INTO syls_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","ꠁꠀꠇꠥꠛꠞ ꠀꠅꠟꠣꠖꠞ ꠃꠙꠞꠦ ꠇꠥꠘꠥ ꠎꠣꠖꠥ-ꠝꠘꠔ꠆ꠞ ꠌꠟꠔ ꠘꠣꠄ, ꠁꠍꠞꠣꠁꠟ ꠎꠣꠔꠤꠞ ꠃꠙꠞꠦ ꠇꠥꠘꠥ ꠔꠣꠛꠤꠎ-ꠇꠛꠎꠦ ꠇꠣꠝ ꠀꠁꠔ ꠘꠣꠄ। ꠔꠣꠞꠣꠞ ꠛꠦꠙꠣꠞꠦ ꠅꠈꠘ ꠅꠃ ꠛꠥꠟꠤ ꠇꠅꠀ ꠎꠣꠄ, ꠀꠟ꠆ꠟꠣꠄ ꠎꠦꠔꠣ ꠇꠞꠍꠂꠘ ꠅꠔꠣ ꠌꠣꠁꠀ ꠖꠦꠈꠅ। ");
INSERT INTO syls_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","ꠅꠃ ꠎꠣꠔꠤ ꠔ ꠡꠤꠋꠢꠤꠞ ꠟꠣꠈꠣꠘ ꠉꠥꠘ꠆ꠎꠞꠤꠀ ꠃꠑꠤꠛ, ꠀꠞ ꠡꠤꠋꠢꠞ ꠟꠣꠈꠣꠘ ꠃꠑꠤꠀ ꠀꠉ ꠛꠣꠠꠤꠛ। ꠡꠤꠇꠣꠞꠞ ꠟꠃ ꠀꠞ ꠉꠥꠡ꠆ꠔ ꠘꠣ ꠈꠣꠅꠀ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠔꠣꠞꠣ ꠖꠝ ꠟꠁꠔꠣ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠛꠣꠖꠡꠣ ꠛꠣꠟꠣꠇꠦ ꠇꠁꠟꠣ, “ꠛꠘ꠆ꠖ ꠇꠞꠃꠇ꠆ꠇꠣ, ꠀꠙꠘꠦ ꠔꠣꠞꠣꠞꠦ ꠖꠥꠀꠅ ꠖꠤꠛꠣ ꠘꠣ, ꠟꠣꠘ꠆ꠘꠔꠅ ꠖꠤꠛꠣ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","ꠛꠣꠟꠣꠝ ꠙꠤꠞꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠀꠝꠤ ꠔ ꠀꠙꠘꠣꠞꠦ ꠀꠉꠦꠃ ꠇꠁꠍꠤ, ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞꠦ ꠎꠦꠟꠣ ꠇꠁꠛꠣ, ꠀꠝꠣꠞ ꠅꠟꠣꠃ ꠇꠞꠣ ꠟꠣꠉꠛ।” ");
INSERT INTO syls_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","ꠛꠣꠖꠦ ꠛꠣꠟꠣꠇ ꠛꠣꠖꠡꠣꠄ ꠛꠣꠟꠣꠝ ꠙꠤꠞꠞꠦ ꠇꠁꠟꠣ, “ꠀꠃꠇ꠆ꠇꠣ, ꠀꠝꠤ ꠀꠙꠘꠣꠞꠦ ꠀꠞꠇ ꠎꠣꠉꠣꠔ ꠟꠁꠀ ꠎꠣꠁꠝꠥ। ꠢꠘꠅ ꠉꠦꠟꠦ ꠅꠁꠔ ꠙꠣꠞꠦ ꠀꠟ꠆ꠟꠣꠄ ꠈꠥꠡꠤ ꠅꠁꠀ ꠀꠝꠣꠞ ꠙꠇ꠆ꠇ ꠟꠁꠛꠣ, ꠀꠞ ꠀꠙꠘꠣꠞꠦꠖꠤ ꠢꠔꠣꠞ ꠃꠙꠞꠦ ꠟꠣꠘ꠆ꠘꠔ ꠖꠤꠔꠦ ꠖꠤꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","ꠅꠈꠣꠘ ꠇꠁꠀ ꠛꠣꠖꠡꠣꠄ ꠔꠣꠘꠞꠦ ꠟꠁꠀ ꠙꠤꠃꠞ ꠘꠣꠝꠞ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠉꠦꠟꠣ, ꠅꠃ ꠎꠣꠉꠣ ꠕꠣꠇꠤ ꠝꠞꠥꠜꠥꠝꠤ ꠖꠦꠈꠣ ꠎꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","ꠅꠃ ꠡꠝꠄ ꠛꠣꠟꠣꠝ ꠙꠤꠞꠦ ꠇꠁꠟꠣ, “ꠅꠘꠅ ꠀꠝꠣꠞ ꠟꠣꠉꠤ ꠡꠣꠔꠈꠣꠘ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣ ꠛꠣꠘꠣꠁꠀ, ꠡꠣꠔꠉꠥ ꠛꠤꠍꠣꠟ ꠀꠞ ꠡꠣꠔꠉꠥ ꠝꠦꠠꠣ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠛꠦꠛꠡ꠆ꠔꠣ ꠇꠞꠃꠇ꠆ꠇꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","ꠙꠤꠞ ꠍꠣꠛꠞ ꠇꠕꠣꠝꠔ ꠛꠣꠖꠡꠣꠄ ꠅꠟꠣꠃ ꠇꠞꠟꠣ। ꠔꠣꠁꠘ ꠙꠞꠔꠦꠇ ꠇꠥꠞꠛꠣꠘꠤ ꠈꠣꠘꠣꠞ ꠃꠙꠞꠦ ꠄꠉꠥ ꠇꠞꠤ ꠛꠤꠍꠣꠟ ꠀꠞ ꠄꠉꠥ ꠇꠞꠤ ꠝꠦꠠꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","ꠛꠣꠟꠣꠝ ꠙꠤꠞꠦ ꠎꠦꠛꠟꠣ ꠛꠥꠎꠟꠣ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠖꠥꠀ ꠖꠦꠅꠀꠃ ꠅꠁꠟ ꠝꠣꠛꠥꠖꠞ ꠁꠌ꠆ꠍꠣ, ꠛꠥꠎꠤꠀ ꠔꠣꠁꠘ ꠀꠉꠞ ꠟꠣꠈꠣꠘ ꠀꠞ ꠁꠡ꠆ꠔꠦꠈꠣꠞꠣ-ꠀꠎꠤꠞꠣꠔꠞ ꠌꠦꠡ꠆ꠐꠣ ꠇꠞꠟꠣ ꠘꠣ। ꠛꠞꠋ ꠔꠣꠘ ꠘꠤꠎꠞ ꠝꠥꠈ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠛꠣꠄ ꠚꠤꠞꠣꠁꠟ꠆ꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","ꠚꠤꠞꠣꠁꠀ ꠖꠦꠈꠟꠣ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠘꠣꠘꠣꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠔꠣꠝ꠆ꠛꠥ ꠄꠇ ꠄꠇ ꠇꠞꠤ ꠐꠣꠋꠉꠣꠘꠤ ꠅꠁꠍꠦ। ꠅꠃ ꠡꠝꠄ ꠔꠣꠘ ꠃꠙꠞꠦ ꠀꠟ꠆ꠟꠣꠞ ꠞꠥꠢꠥ ꠟꠣꠝꠤꠀ ꠀꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","ꠔꠣꠁꠘ ꠀꠟ꠆ꠟꠣꠞ ꠖꠦꠅꠀ ꠅꠃ ꠅꠢꠤ ꠇꠁꠟꠣ, “ꠛꠣꠃꠞꠞ ꠙꠥꠔ ꠛꠣꠟꠣꠝꠦ ꠇꠁꠞꠣ, ꠌꠃꠈ ꠎꠣꠞ ꠈꠥꠟꠣ ꠀꠍꠦ ꠄꠁꠘ ꠅꠃ ꠛꠥꠟꠤ ꠇꠁꠞꠣ। ");
INSERT INTO syls_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ꠎꠦ ꠎꠘꠦ ꠀꠟ꠆ꠟꠣꠞ ꠇꠣꠟꠣꠝ ꠢꠥꠘꠞꠣ, ꠡꠞ꠆ꠛ-ꠡꠇ꠆ꠔꠤꠝꠣꠘꠞ ꠖꠤꠖꠣꠞ ꠙꠣꠁꠞꠣ, ꠎꠦꠁꠘ ꠍꠁꠎꠖꠣꠔ ꠙꠠꠤꠀ ꠛꠣꠔꠥꠘꠤ ꠈꠛꠞ ꠖꠦꠈꠂꠘ, ꠄꠁꠘ ꠅꠈꠣꠘ ꠇꠁꠞꠣ। ");
INSERT INTO syls_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","ꠅ ꠁꠀꠇꠥꠛ ꠛꠋꠡ, ꠔꠥꠝꠣꠞ ꠔꠣꠝ꠆ꠛꠥ ꠅꠇꠟ ꠈꠥꠛ ꠌꠇꠌꠇꠣ! ꠅ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ, ꠔꠥꠝꠣꠞ ꠞꠅꠀꠞ ꠎꠣꠉꠣ ꠇꠔ ꠜꠣꠟꠣ! ");
INSERT INTO syls_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","ꠁꠔꠣ ꠔ ꠖꠦꠈꠣꠞ ꠝꠔ ꠛꠠ ꠈꠦꠎꠥꠞ ꠛꠣꠉꠣꠘꠞ ꠟꠣꠈꠣꠘ, ꠉꠣꠋꠉꠞ ꠙꠣꠞꠞ ꠢꠣꠎꠣꠁꠟ-ꠙꠣꠠꠣꠁꠟ ꠛꠘꠞ ꠟꠣꠈꠣꠘ, ꠝꠣꠛꠥꠖꠞ ꠟꠣꠉꠣꠁꠟ ꠀꠉꠞꠞ ꠉꠣꠍꠞ ꠟꠣꠈꠣꠘ ꠔꠞꠔꠣꠎꠣ, ꠙꠣꠘꠤꠞ ꠗꠣꠞꠞ ꠖꠦꠛꠖꠣꠞꠥ ꠉꠣꠍꠞ ꠟꠣꠈꠣꠘ ꠡꠥꠘ꠆ꠖꠞ। ");
INSERT INTO syls_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","ꠔꠣꠞꠣꠞ ꠜꠞꠣ ꠇꠟꠡꠤ ꠕꠣꠇꠤ ꠙꠣꠘꠤ ꠃꠕꠟꠤꠀ ꠙꠠꠛ, ꠛꠤꠌꠤ ꠀꠞ ꠌꠦꠞꠣꠄ ꠛꠃꠔ ꠙꠣꠘꠤ ꠙꠣꠁꠛ। ꠔꠣꠞꠣꠞ ꠛꠣꠖꠡꠣ ꠅꠁꠛꠣ ꠅꠉꠣꠉ ꠛꠣꠖꠡꠣ ꠕꠣꠇꠤꠅ ꠢꠤꠝ꠆ꠝꠔꠤ, ꠔꠣꠞꠣꠞ ꠖꠦꠡ ꠅꠁꠛ ꠘꠣꠝꠇꠞꠣ ꠁꠎ꠆ꠎꠔꠤ। ");
INSERT INTO syls_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","ꠀꠟ꠆ꠟꠣꠄ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠔꠣꠞꠣꠞꠦ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠍꠂꠘ, ꠔꠣꠁꠘ ꠅꠁꠟꠣ ꠔꠣꠞꠣꠞ ꠙꠇ꠆ꠇꠦ ꠛꠟꠀꠟꠣ ꠎꠋꠟꠤ ꠛꠄꠞꠣ, ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠎꠔ ꠎꠣꠔꠤꠄ ꠟꠣꠉꠛꠣ, ꠁꠔꠣꠞꠦ ꠔꠣꠞꠣ ꠉꠤꠟꠤꠀ ꠈꠣꠁꠟꠤꠛꠣ, ꠔꠣꠞꠣꠞ ꠀꠒ꠆ꠒꠤ-ꠉꠥꠒ꠆ꠒꠤꠞꠦ ꠉꠥꠠꠣ ꠉꠥꠠꠣ ꠇꠞꠛꠣ, ꠔꠤꠞ-ꠗꠘꠥꠇꠖꠤ ꠔꠣꠞꠣꠞꠦ ꠉꠣꠕꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","ꠡꠤꠋꠢꠞ ꠟꠣꠈꠣꠘ ꠔꠣꠞꠣ ꠈꠣꠙ ꠗꠞꠤ ꠢꠥꠔꠤꠛ, ꠔꠣꠞꠣꠞꠦ ꠟꠣꠠꠣꠘꠤꠞ ꠡꠣꠅꠡ ꠅꠁꠛ ꠇꠥꠘ ꠛꠦꠐꠣꠞ? ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦꠞꠣ ꠖꠥꠀ ꠖꠤꠛꠣ, ꠄꠞꠣꠞ ꠃꠙꠞꠦ ꠖꠥꠀ ꠟꠣꠝꠃꠇ; ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦꠔꠣꠄ ꠟꠣꠘ꠆ꠘꠔ ꠖꠤꠛꠣ, ꠁꠔꠣꠞ ꠃꠙꠞꠦ ꠟꠣꠘ꠆ꠘꠔ ꠙꠠꠃꠇ।” ");
INSERT INTO syls_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","ꠁꠔꠣ ꠢꠥꠘꠤꠀ ꠛꠣꠖꠡꠣ ꠛꠣꠟꠣꠇꠦ ꠛꠣꠟꠣꠝ ꠙꠤꠞꠞ ꠃꠙꠞꠦ ꠉꠥꠍꠣꠄ ꠀꠉꠥꠁꠘ ꠅꠁꠉꠦꠟꠣ। ꠔꠣꠘ ꠘꠤꠎꠞ ꠀꠔꠞ ꠙꠤꠑꠤꠔ ꠔꠣꠛꠠꠣꠁ ꠔꠣꠛꠠꠣꠁ ꠇꠤꠠꠤꠝꠤꠠꠤ ꠈꠣꠁꠀ ꠇꠁꠟꠣ, “ꠀꠝꠤ ꠀꠙꠘꠣꠞꠦ ꠀꠘꠣꠁꠟꠣꠝ ꠀꠝꠣꠞ ꠖꠥꠡꠝꠘꠞꠦ ꠟꠣꠘ꠆ꠘꠔ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ, ꠀꠞ ꠀꠙꠘꠦ ꠔꠣꠞꠣꠞꠦ ꠅꠃ ꠟꠣꠉꠣꠁꠀ ꠔꠤꠘ-ꠔꠤꠘꠛꠣꠞ ꠖꠥꠀ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","ꠀꠙꠘꠦ ꠀꠝꠣꠞ ꠍꠣꠝꠘ ꠕꠣꠇꠤ ꠢꠞꠃꠇ꠆ꠇꠣ, ꠘꠤꠎꠞ ꠎꠣꠉꠣꠔ ꠎꠣꠃꠇ꠆ꠇꠣ। ꠀꠝꠤ ꠀꠙꠘꠣꠞꠦ ꠛꠃꠔ ꠙꠥꠞꠥꠡ꠆ꠇꠣꠞ ꠖꠤꠝꠥ ꠇꠁꠍꠟꠣꠝ, ꠅꠁꠟꠦ ꠝꠣꠛꠥꠖꠦ ꠖꠤꠟꠣ ꠘꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","ꠔꠦꠃ ꠛꠣꠟꠣꠝ ꠙꠤꠞꠦ ꠛꠣꠖꠡꠣ ꠛꠣꠟꠣꠇꠞꠦ ꠇꠁꠟꠣ, “ꠀꠙꠘꠣꠞ ꠙꠣꠑꠣꠁꠟ ꠝꠣꠘꠡꠞꠦ ꠀꠝꠤ ꠀꠉꠦꠃ ꠇꠁꠍꠤ ꠘꠣ ꠘꠤ, ");
INSERT INTO syls_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","ꠛꠣꠖꠡꠣꠄ ꠎꠥꠖꠤ ꠡꠥꠘꠣ-ꠞꠥꠙꠣꠄ ꠜꠞꠣ ꠔꠣꠘ ꠀꠡ꠆ꠔꠣ ꠞꠣꠎꠛꠣꠠꠤ ꠈꠣꠘꠃ ꠀꠝꠣꠞꠦ ꠖꠤꠟꠣꠁꠘ, ꠔꠦꠛꠃ ꠀꠝꠤ ꠀꠝꠣꠞ ꠘꠤꠎꠞ ꠁꠌ꠆ꠍꠣꠄ ꠜꠣꠟꠣ-ꠛꠥꠞꠣ ꠇꠥꠘ꠆ꠔꠣ ꠇꠞꠔꠣꠝ ꠙꠣꠞꠔꠣꠝ ꠘꠣꠄ, ꠀꠝꠤ ꠝꠣꠛꠥꠖꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠎꠣꠁꠔꠣꠝ ꠘꠣꠄ। ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠛꠣ, ꠀꠝꠤ ꠈꠣꠟꠤ ꠅꠟꠣꠃ ꠇꠁꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","ꠔꠦ ꠀꠝꠤ ꠅꠈꠘ ꠀꠝꠣꠞ ꠝꠣꠘꠡꠞ ꠉꠦꠍꠦ ꠚꠤꠞꠔ ꠎꠣꠁꠞꠣꠝꠉꠤ, ꠅꠁꠟꠦ ꠅꠃ ꠎꠣꠔꠤꠄ ꠜꠛꠤꠡꠔꠦ ꠀꠙꠘꠣꠞ ꠎꠣꠔꠤꠞ ꠟꠉꠦ ꠇꠤꠔꠣ ꠇꠤꠔꠣ ꠇꠞꠛꠣ, ꠀꠙꠘꠣꠞ ꠢꠥꠡꠤꠀꠞꠤꠞ ꠟꠣꠉꠤ ꠁꠔꠣ ꠀꠉꠣꠝ ꠎꠣꠘꠣꠁ ꠖꠤꠀꠞ।” ");
INSERT INTO syls_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","ꠛꠣꠟꠣꠝ ꠙꠤꠞꠦ ꠀꠟ꠆ꠟꠣꠞ ꠖꠦꠅꠀ ꠅꠃ ꠀꠞꠇ ꠅꠢꠤ ꠇꠁꠟꠣ, “ꠛꠣꠃꠞꠞ ꠙꠥꠔ ꠛꠣꠟꠣꠝꠦ ꠇꠁꠞꠣ, ꠌꠃꠈ ꠎꠣꠞ ꠈꠥꠟꠣ ꠀꠍꠦ ꠄꠁꠘ ꠅꠃ ꠛꠥꠟꠤ ꠇꠁꠞꠣ, ");
INSERT INTO syls_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ꠎꠦ ꠎꠘꠦ ꠀꠟ꠆ꠟꠣꠞ ꠇꠣꠟꠣꠝ ꠢꠥꠘꠞꠣ, ꠎꠦꠁꠘ ꠉꠦꠍꠦ ꠀꠟ꠆ꠟꠣꠔꠣꠟꠣꠞ ꠀꠈꠟ-ꠢꠦꠇꠝꠔ ꠀꠍꠦ, ꠎꠦꠁꠘ ꠡꠞ꠆ꠛ-ꠡꠇ꠆ꠔꠤꠝꠣꠘꠞ ꠖꠤꠖꠣꠞ ꠙꠣꠁꠞꠣ, ꠎꠦꠁꠘ ꠍꠁꠎꠖꠣꠔ ꠙꠠꠤꠀ ꠛꠣꠔꠥꠘꠤ ꠈꠛꠞ ꠖꠦꠈꠂꠘ, ꠄꠁꠘ ꠅꠈꠣꠘ ꠇꠁꠞꠣ। ");
INSERT INTO syls_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","ꠀꠝꠤ ꠔ ꠢꠃ ꠎꠘꠞꠦ ꠖꠦꠈꠤꠀꠞ, ꠅꠈꠘ ꠍꠣꠝꠘꠦ ꠘꠣ ꠕꠣꠇꠟꠦꠅ ꠖꠦꠈꠤꠀꠞ। ꠔꠣꠁꠘ ꠀꠝꠣꠞ ꠇꠣꠍꠣꠔ ꠘꠣ ꠅꠁꠟꠦꠅ, ꠀꠝꠣꠞ ꠌꠃꠈ ꠉꠤꠀ ꠔꠣꠘ ꠃꠙꠞꠦ ꠙꠠꠍꠦ। ꠁꠀꠇꠥꠛꠞ ꠛꠋꠡꠔ ꠀꠁꠛꠣ ꠀꠍꠝꠣꠘꠞ ꠄꠇ ꠔꠦꠞꠣ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠎꠦꠃ ꠄꠇ ꠞꠣꠎ-ꠟꠣꠑꠤ ꠎꠘꠝꠤꠛꠣ। ꠄꠁꠘ ꠝꠥꠀꠛ ꠎꠣꠔꠤꠞ ꠝꠣꠕꠣ ꠚꠣꠐꠣꠁꠀ ꠖꠥꠁ ꠐꠥꠇꠞꠣ ꠇꠞꠛꠣ, ꠡꠤꠡ ꠘꠛꠤꠞ ꠀꠅꠟꠣꠖꠞ ꠇꠟ꠆ꠟꠣ ꠌꠥꠞꠝꠣꠞ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ꠁꠖꠥꠝ ꠖꠦꠡꠞꠦ ꠄꠘꠞ ꠖꠈꠟꠅ ꠀꠘꠛꠣ, ꠔꠣꠘ ꠖꠥꠡꠝꠘꠞ ꠅꠃ ꠍꠦꠁꠞ ꠙꠣꠠꠞꠦ ꠇꠛꠎꠣ ꠇꠞꠛꠣ, ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠎꠣꠔꠤꠄ ꠙꠄꠟꠥꠀꠘꠤ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","ꠁꠀꠇꠥꠛꠞ ꠛꠋꠡꠞ ꠄꠇꠎꠘꠦ ꠞꠣꠎ-ꠉꠖꠤ ꠌꠣꠟꠣꠁꠛꠣ, ꠁꠞ ꠐꠣꠃꠘꠅ ꠎꠣꠞꠣ ꠎꠤꠘ꠆ꠖꠣ ꠞꠁꠛꠣ ꠄꠁꠘ ꠔꠣꠞꠣꠞꠦꠅ ꠛꠤꠘꠣꠡ ꠇꠞꠤꠟꠤꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","ꠅꠈꠘꠣꠁꠘ ꠇꠅꠀꠞ ꠛꠣꠖꠦ ꠛꠣꠟꠣꠝ ꠙꠤꠞꠦ ꠌꠃꠈ ꠝꠦꠟꠤꠀ ꠀꠝꠣꠟꠦꠇꠤ ꠅꠇꠟꠞꠦ ꠖꠦꠈꠟꠣ। ꠖꠦꠈꠤꠀ ꠀꠟ꠆ꠟꠣꠞ ꠅꠃ ꠅꠢꠤ ꠇꠁꠟꠣ, “ꠀꠝꠣꠟꠦꠇ ꠔ ꠢꠇꠟ ꠎꠣꠔꠤꠞ ꠝꠣꠎꠦ ꠀꠍꠤꠟ ꠙꠞꠗꠣꠘ, ꠅꠁꠟꠦ ꠔꠣꠞꠣꠞ ꠡꠦꠡ ꠖꠡꠣ ꠅꠁꠛ ꠡꠞ꠆ꠛꠘꠣꠡ।” ");
INSERT INTO syls_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","ꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠇꠦꠘꠤ ꠅꠇꠟꠞꠦ ꠖꠦꠈꠟꠣ, ꠖꠦꠈꠤꠀ ꠀꠟ꠆ꠟꠣꠞ ꠅꠃ ꠅꠢꠤ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣꠞ ꠛꠡꠔ ꠈꠣꠘꠣ ꠈꠥꠛ ꠝꠎꠛꠥꠔ, ꠔꠥꠝꠞꠣ ꠔ ꠙꠣꠔ꠆ꠔꠞꠞ ꠙꠣꠠꠅ ꠛꠣꠡꠣ ꠛꠣꠘꠣꠁꠍ, ");
INSERT INTO syls_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","ꠅꠁꠟꠦ ꠀꠉꠦꠖꠤ ꠔꠥꠝꠞꠣꠞ ꠛꠤꠘꠣꠡ ꠊꠐꠤꠛ, ꠔꠥꠝꠞꠣꠞꠦ ꠛꠣꠘ꠆ꠖꠤꠀ ꠀꠡꠤꠞꠤꠀ ꠖꠦꠡꠅ ꠘꠦꠅꠀ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","ꠛꠣꠖꠦ ꠛꠣꠟꠣꠝ ꠙꠤꠞꠦ ꠀꠟ꠆ꠟꠣꠞ ꠖꠦꠅꠀ ꠅꠃ ꠡꠦꠡ ꠅꠢꠤ ꠇꠁꠟꠣ, “ꠢꠣꠄꠞꠦ ꠢꠣꠄ! ꠀꠟ꠆ꠟꠣꠄ ꠎꠦꠛꠟꠣ ꠅꠔꠣ ꠊꠐꠣꠁꠛꠣ, ꠅꠃ ꠡꠝꠄ ꠇꠦꠃ ꠀꠞ ꠎꠤꠘ꠆ꠖꠣ ꠞꠁꠛ ꠘꠤ? ");
INSERT INTO syls_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","ꠍꠣꠁꠙ꠆ꠞꠣꠍ ꠖꠤꠙꠞ ꠎꠣꠎ ꠅꠇꠟ ꠀꠁꠛ, ꠀꠁꠀ ꠀꠡꠤꠞꠤꠀꠞꠦ ꠖꠥꠞ꠆ꠖꠡꠣ ꠖꠤꠛ, ꠀꠛꠦꠞꠞ ꠝꠣꠘꠡꠞꠦꠅ ꠖꠝꠣꠁꠛ, ꠅꠁꠟꠦ ꠅꠃ ꠖꠤꠙ ꠘꠤꠎꠦꠅ ꠛꠣꠖꠦ ꠛꠤꠘꠣꠡ ꠅꠁꠎꠤꠛ।” ");
INSERT INTO syls_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","ꠅꠈꠣꠘ ꠇꠁꠀ ꠢꠣꠞꠤ ꠛꠣꠟꠣꠝ ꠙꠤꠞ ꠃꠑꠤꠀ ꠘꠤꠎꠞ ꠊꠞꠅ ꠉꠦꠟꠣꠉꠤ, ꠛꠣꠟꠣꠇ ꠛꠣꠖꠡꠣꠅ ꠔꠣꠘ ꠙꠕꠦ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠝꠥꠀꠛ ꠖꠦꠡꠞ ꠡꠤꠐꠤꠝ ꠄꠟꠣꠇꠣꠔ ꠛꠡꠔ ꠇꠞꠟꠣ, ꠔꠣꠞꠣ ꠅꠘꠅ ꠞꠁꠀ ꠞꠁꠀ ꠝꠥꠀꠛꠤ ꠛꠦꠐꠤꠘ꠆ꠔꠞ ꠟꠉꠦ ꠎꠤꠘꠣ ꠇꠞꠣꠔ ꠟꠣꠉꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","ꠢꠘꠞ ꠛꠦꠐꠤꠘ꠆ꠔꠦ ꠔꠣꠞꠣꠞ ꠖꠦꠛ-ꠖꠦꠛꠤꠞ ꠘꠣꠝꠦ ꠛꠟꠤ ꠖꠤꠛꠣꠞ ꠅꠘꠥꠡ꠆ꠐꠣꠘꠅ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠖꠣꠅꠔ ꠖꠤꠟꠣ, ꠀꠞ ꠄꠞꠣ ꠉꠤꠀ ꠅꠔꠣ ꠛꠦꠐꠤꠘ꠆ꠔꠞ ꠟꠉꠦ ꠈꠣꠘꠣ-ꠖꠣꠘꠣ ꠈꠣꠁꠀ ꠢꠃ ꠖꠦꠛ-ꠖꠦꠛꠤꠞ ꠙꠥꠎꠣ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠔꠣꠞꠣ ꠢꠘꠞ ꠙꠤꠃꠞ ꠙꠣꠠꠞ ꠛꠣꠀꠟ ꠖꠦꠛꠔꠣꠞ ꠙꠥꠎꠣ-ꠜꠇ꠆ꠔꠤ ꠖꠦꠅꠀꠔ ꠟꠣꠉꠤ ꠉꠦꠟꠣ। ꠄꠞꠖꠣꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠃꠙꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠉꠎꠛꠞ ꠀꠉꠥꠁꠘ ꠎꠟꠤꠀ ꠃꠑꠟ। ");
INSERT INTO syls_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠡꠝꠣꠎꠞ ꠖꠥꠡꠤ ꠘꠦꠔꠣ ꠅꠇꠟꠞꠦ ꠗꠞꠤꠀ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠣꠅ, ꠀꠞ ꠅꠔꠣꠞ ꠟꠣꠡ ꠞꠂꠖꠞ ꠝꠣꠎꠦ ꠀꠘꠤꠀ ꠟꠐꠇꠣꠁ ꠕꠅ। ꠔꠦꠃ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠃꠙꠞꠦ ꠕꠣꠇꠤ ꠀꠝꠣꠞ ꠢꠃ ꠟꠣꠘ꠆ꠘꠔꠤ ꠉꠎꠛ ꠢꠞꠛ।” ");
INSERT INTO syls_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","ꠅꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠝꠥꠍꠣꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠢꠣꠇꠤꠝ-ꠡꠣꠟꠤꠡ ꠅꠇꠟꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣꠞ ꠎꠤꠝ꠆ꠝꠣꠄ ꠕꠣꠇꠣ ꠎꠔ ꠝꠣꠘꠡꠦ ꠙꠤꠃꠞ ꠙꠣꠠꠞ ꠛꠣꠀꠟ ꠖꠦꠛꠔꠣꠞ ꠙꠥꠎꠣꠔ ꠡꠞꠤꠇ ꠅꠁꠍꠦ, ꠅꠔꠣ ꠢꠇ꠆ꠇꠟꠐꠤꠞꠦ ꠔꠥꠝꠞꠣ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠣꠅ।” ");
INSERT INTO syls_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","ꠄꠞꠝꠣꠎꠦ ꠅꠟꠣ ꠅꠁꠟ, ꠝꠥꠍꠣ ꠘꠛꠤ ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠝꠤꠟꠤꠀ ꠎꠦꠛꠟꠣ ꠀꠟ꠆ꠟꠣꠞ ꠊꠞꠞ ꠖꠥꠀꠞꠞ ꠉꠦꠍꠦ ꠇꠣꠘ꠆ꠖꠣ-ꠇꠣꠐꠤ ꠇꠞꠞꠣ, ꠅꠃ ꠡꠝꠄ ꠔꠣꠞꠣꠞ ꠍꠣꠝꠘꠦꠖꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠄꠇ ꠛꠦꠐꠣꠄ ꠝꠣꠖꠤꠀꠘꠤ ꠄꠇ ꠛꠦꠐꠤꠞꠦ ꠟꠉꠦ ꠟꠁꠀ ꠇꠦꠝ꠆ꠙꠞ ꠜꠤꠔꠞꠦ ꠢꠣꠝꠣꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","ꠁꠔꠣ ꠖꠦꠈꠤꠀ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠘꠣꠔꠤ ꠙꠤꠘꠢꠡ ꠛꠤꠘ ꠀꠟꠤ-ꠀꠎꠞ ꠝꠎꠟꠤꠍ ꠕꠣꠇꠤ ꠃꠑꠤꠀ ꠄꠇꠈꠣꠘ ꠍꠥꠟꠚꠤ ꠀꠔꠅ ꠟꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ꠟꠁꠀ ꠔꠣꠞꠣꠞ ꠈꠞꠦ ꠈꠞꠦ ꠉꠤꠀ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠢꠃ ꠛꠦꠐꠣꠞ ꠔꠣꠝ꠆ꠛꠥꠔ ꠢꠣꠝꠣꠁꠀ ꠔꠣꠞ ꠀꠞ ꠢꠃ ꠛꠦꠐꠤꠞ ꠙꠦꠐꠦꠖꠤ ꠉꠣꠕꠤꠟ꠆ꠟꠣ। ꠔꠦꠃ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠃꠙꠞ ꠕꠣꠇꠤ ꠀꠟ꠆ꠟꠣꠞ ꠉꠎꠛ ꠢꠞꠤꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","ꠅꠁꠟꠦ ꠅꠃ ꠉꠎꠛꠞ ꠝꠣꠎꠦ ꠌꠛ꠆ꠛꠤꠡ ꠀꠎꠣꠞ ꠝꠣꠘꠥꠡ ꠝꠞꠤꠉꠦꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","ꠅꠃ ꠡꠝꠄ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠘꠣꠔꠤ ꠙꠤꠘꠢꠡ ꠛꠤꠘ ꠀꠟꠤ-ꠀꠎꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠃꠙꠞꠦ ꠕꠣꠇꠤ ꠀꠝꠣꠞ ꠉꠎꠛ ꠢꠞꠣꠁꠍꠦ। ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠎꠦ ꠀꠝꠣꠞ ꠙꠣꠅꠘꠣ ꠁꠎ꠆ꠎꠔ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠛꠦꠙꠣꠞꠦ ꠢꠦ ꠔ ꠀꠝꠣꠞ ꠎꠣꠟꠣꠄꠃ ꠎꠟꠦꠞ। ꠄꠞꠟꠣꠉꠤ ꠀꠝꠣꠞ ꠙꠣꠅꠘꠣ ꠁꠎ꠆ꠎꠔ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠝꠘꠞ ꠎꠣꠟꠣ ꠕꠣꠇꠟꠦꠅ ꠀꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠀꠞ ꠝꠣꠞꠟꠣꠝ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","ꠔꠦ ꠅꠈꠘ ꠔꠥꠝꠤ ꠔꠣꠞꠦ ꠇꠅ, ꠀꠝꠤ ꠔꠣꠞ ꠟꠣꠉꠤ ꠄꠇꠐꠣ ꠈꠣꠍ ꠡꠣꠘ꠆ꠔꠤ-ꠌꠥꠇ꠆ꠔꠤ ꠛꠅꠀꠁꠟ ꠇꠞꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","ꠢꠦ ꠔꠣꠞ ꠀꠟ꠆ꠟꠣꠞ ꠙꠣꠅꠘꠣ ꠁꠎ꠆ꠎꠔꠞ ꠛꠦꠙꠣꠞꠦ ꠈꠤꠀꠟꠤ ꠅꠁꠀ ꠘꠤꠎꠞ ꠁꠌ꠆ꠍꠣꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣ ꠀꠖꠣꠄ ꠇꠞꠣꠄ, ꠀꠝꠤꠅ ꠔꠣꠞ ꠟꠣꠉꠤ ꠅꠃ ꠡꠣꠘ꠆ꠔꠤ-ꠌꠥꠇ꠆ꠔꠤ ꠛꠅꠀꠁꠟ ꠇꠞꠍꠤ। ꠄꠞꠟꠣꠉꠤ ꠁꠝꠣꠝꠔꠤꠞ ꠙꠖ ꠢꠦ ꠀꠞ ꠔꠣꠞ ꠀꠅꠟꠣꠖꠞ ꠝꠣꠎꠦ ꠌꠤꠞꠇꠣꠟ ꠎꠣꠞꠤ ꠞꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","ꠝꠣꠖꠤꠀꠘꠤ ꠢꠃ ꠛꠦꠐꠤꠞ ꠟꠉꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠎꠦ ꠛꠦꠐꠣꠞꠦ ꠝꠣꠞꠣ ꠅꠁꠍꠤꠟ, ꠢꠦ ꠅꠁꠟ ꠍꠣꠟꠥꠞ ꠙꠥꠀ ꠎꠤꠝꠞꠤ, ꠢꠦ ꠔ ꠡꠤꠝꠤꠅꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠄꠇ ꠉꠥꠡ꠆ꠐꠤꠞ ꠘꠦꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","ꠀꠞ ꠎꠦ ꠝꠣꠖꠤꠀꠘꠤ ꠛꠦꠐꠤꠞꠦ ꠝꠣꠞꠣ ꠅꠁꠍꠤꠟ, ꠔꠣꠁꠞ ꠘꠣꠝ ꠇꠍꠛꠤ, ꠔꠣꠁ ꠀꠍꠤꠟ ꠝꠣꠖꠤꠀꠘ ꠖꠦꠡꠞ ꠡꠥꠞ ꠘꠣꠝꠞ ꠄꠇ ꠘꠦꠔꠣꠞ ꠙꠥꠠꠤ, ꠅꠃ ꠡꠥꠞꠅ ꠅꠁꠟꠣ ꠄꠇ ꠉꠥꠡ꠆ꠐꠤꠞ ꠘꠦꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“ꠝꠣꠖꠤꠀꠘꠤ ꠅꠇꠟꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠖꠥꠡꠝꠘ ꠝꠘꠅ ꠇꠞꠤꠅ, ꠁꠔꠣꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","ꠇꠣꠞꠘ ꠙꠤꠃꠞꠞ ꠖꠦꠛꠔꠣꠞ ꠙꠥꠎꠣ ꠀꠞ ꠇꠍꠛꠤꠞ ꠛꠦꠙꠣꠞꠦ ꠚꠣꠘ꠆ꠖ ꠙꠣꠔꠣꠁꠀ ꠔꠥꠝꠞꠣꠞꠦ ꠜꠥꠟ ꠙꠕꠦ ꠘꠦꠅꠀꠄ ꠔꠣꠞꠣ ꠔꠥꠝꠞꠣꠞ ꠖꠥꠡꠝꠘ ꠛꠘꠍꠦ। ꠀꠞ ꠔꠥꠝꠤ ꠔ ꠎꠣꠘ, ꠅꠃ ꠇꠍꠛꠤ ꠀꠍꠤꠟ ꠔꠣꠞꠣꠞ ꠇꠥꠐꠥꠝ, ꠔꠣꠁ ꠔ ꠝꠣꠖꠤꠀꠘꠤ ꠄꠇ ꠡꠞ꠆ꠖꠣꠞꠞ ꠙꠥꠠꠤ। ꠙꠤꠃꠞꠞ ꠛꠣꠀꠟ ꠖꠦꠛꠔꠣꠞꠦ ꠙꠥꠎꠣ ꠇꠞꠣꠄ ꠔꠥꠝꠞꠣꠞ ꠃꠙꠞꠦ ꠎꠦꠛꠟꠣ ꠟꠣꠘ꠆ꠘꠔꠤ ꠉꠎꠛ ꠟꠣꠝꠍꠤꠟ, ꠅꠃ ꠡꠝꠄ ꠔꠣꠁꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠣ ꠅꠁꠍꠤꠟ।” ");
INSERT INTO syls_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","ꠟꠣꠘ꠆ꠘꠔꠤ ꠅꠃ ꠉꠎꠛ ꠕꠣꠝꠤ ꠎꠣꠅꠀꠞ ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠀꠞ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠞ ꠙꠥꠀ ꠀꠟꠤ-ꠀꠎꠞꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠎꠦ ꠎꠦꠞꠣꠞ ꠛꠄꠅꠡ ꠛꠤꠡ ꠛꠍꠞ ꠛꠣ ꠄꠞ ꠛꠦꠡꠤ, ꠝꠣꠘꠤ ꠎꠥꠖ꠆ꠖ ꠇꠞꠣꠞ ꠎꠁꠉ꠆ꠉ ꠎꠦꠞꠣ ꠅꠁꠉꠦꠍꠦ, ꠄꠞꠣꠞꠦ ꠎꠣꠞꠎꠤꠞ ꠉꠥꠡ꠆ꠐꠤ ꠝꠣꠚꠤꠇ ꠉꠘꠅ।” ");
INSERT INTO syls_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","ꠄꠞꠟꠣꠉꠤ ꠎꠤꠞꠤꠢꠅ ꠐꠣꠃꠘꠞ ꠃꠟꠐꠣꠛꠣꠄ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠙꠣꠞꠅ ꠝꠥꠀꠛ ꠖꠦꠡꠞ ꠎꠦ ꠔꠟ ꠎꠣꠉꠣ ꠀꠍꠦ, ꠢꠘꠅ ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠀꠞ ꠁꠝꠣꠝ ꠀꠟꠤ-ꠀꠎꠞꠦ ꠘꠦꠔꠣ ꠅꠇꠟꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠇꠞꠍꠂꠘ, ꠅꠃꠟꠣ ꠔꠥꠝꠞꠣ ꠛꠤꠡ ꠛꠍꠞ ꠛꠣ ꠄꠞ ꠛꠦꠡꠤ ꠛꠄꠅꠡꠤ ꠢꠇꠟ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠞꠦ ꠉꠘꠅ।” ꠔꠦꠃ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠎꠔ ꠛꠦꠐꠣꠁꠘ ꠛꠣꠞ ꠅꠁꠀ ꠀꠁꠍꠟꠣ, ꠉꠘꠣꠞ ꠡꠝꠄ ꠄꠞꠣꠞ ꠛꠋꠡꠗꠞꠞ ꠘꠣꠝ ꠟꠦꠈꠣ ꠅꠁꠟ। ꠄꠞꠣ ꠅꠁꠟꠣ: ");
INSERT INTO syls_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","ꠁꠀꠇꠥꠛ ꠃꠞꠚꠦ ꠁꠍꠞꠣꠁꠟꠞ ꠛꠠ ꠙꠥꠀ ꠞꠥꠛꠦꠘꠞ ꠌꠣꠁꠞꠅ ꠙꠥꠀꠞ ꠛꠋꠡꠗꠞ: ꠞꠥꠛꠦꠘꠞ ꠛꠠ ꠙꠥꠀ ꠢꠘꠥꠇ ꠕꠣꠇꠤ ꠢꠘꠥꠇꠤ ꠛꠋꠡ, ꠚꠣꠟꠥ ꠕꠣꠇꠤ ꠚꠣꠟꠥꠁ ꠛꠋꠡ, ");
INSERT INTO syls_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","ꠢꠣꠍꠤꠞ ꠕꠣꠇꠤ ꠢꠣꠍꠤꠞꠤ ꠛꠋꠡ, ꠀꠞ ꠇꠞ꠆ꠝꠤ ꠕꠣꠇꠤ ꠇꠞ꠆ꠝꠤꠀ ꠛꠋꠡ। ");
INSERT INTO syls_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","ꠄꠞꠣ ꠢꠇꠟꠃ ꠞꠥꠛꠦꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠘꠣꠘꠣꠘ ꠛꠋꠡ। ꠄꠞꠣꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠉꠘꠤꠀ ꠔꠦꠔꠣꠟ꠆ꠟꠤꠡ ꠀꠎꠣꠞ ꠡꠣꠔ-ꠡ ꠔꠤꠡ ꠎꠘꠞꠦ ꠙꠣꠅꠀ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","ꠚꠣꠟꠥꠞ ꠙꠥꠀꠞ ꠘꠣꠝ ꠁꠟꠤꠀꠛ, ");
INSERT INTO syls_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ꠁꠟꠤꠀꠛꠞ ꠙꠥꠀꠂꠘ ꠅꠁꠟꠣ ꠘꠝꠥꠄꠟ, ꠖꠣꠕꠘ ꠀꠞ ꠀꠛꠤꠞꠣꠝ। ꠖꠣꠕꠘ ꠀꠞ ꠀꠛꠤꠞꠣꠝ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠖꠥꠁꠎꠘ ꠘꠦꠔꠣ ꠀꠍꠟꠣ, ꠔꠣꠞꠣ ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘꠞ ꠛꠤꠙꠇ꠆ꠇꠦ ꠟꠣꠉꠟꠣ। ꠀꠞ ꠇꠥꠞꠣꠢꠞ ꠖꠟ ꠎꠦꠛꠟꠣ ꠝꠣꠛꠥꠖꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠀꠍꠤꠟ, ꠅꠃ ꠡꠝꠄ ꠄꠞꠣꠅ ꠇꠥꠞꠣꠢꠞ ꠖꠟꠅ ꠀꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ꠇꠥꠞꠣꠢꠞ ꠟꠉꠦ ꠅꠃ ꠖꠥꠁꠎꠘꠞꠦꠅ ꠝꠣꠐꠤꠄ ꠀ ꠇꠞꠤ ꠉꠤꠟꠤꠟꠤꠍꠤꠟ ꠀꠞ ꠔꠣꠞ ꠖꠟꠞ ꠀꠠꠣꠁ-ꠡ ꠎꠘ ꠀꠉꠥꠁꠘꠦ ꠎꠟꠤꠀ ꠝꠞꠍꠤꠟ। ꠁꠔꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠣꠉꠤ ꠢꠥꠡꠤꠀꠞꠤꠞ ꠘꠤꠡꠣꠘꠣ ꠅꠁꠀ ꠞꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","ꠅꠁꠟꠦ ꠇꠥꠞꠣꠢꠞ ꠙꠥꠀꠂꠘ ꠢꠤ ꠡꠝꠄ ꠝꠞꠍꠂꠘ ꠘꠣ, ꠔꠣꠞꠣꠞ ꠛꠋꠡ ꠎꠣꠞꠤ ꠞꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","ꠁꠀꠇꠥꠛꠞ ꠙꠥꠀ ꠡꠤꠝꠤꠅꠘꠞ ꠛꠋꠡꠗꠞ ꠅꠁꠟꠣ, ꠘꠝꠥꠄꠟ ꠕꠣꠇꠤ ꠘꠝꠥꠄꠟꠤ ꠛꠋꠡ, ꠎꠣꠝꠤꠘ ꠕꠣꠇꠤ ꠎꠣꠝꠤꠘꠤ ꠛꠋꠡ, ꠎꠣꠈꠤꠘ ꠕꠣꠇꠤ ꠎꠣꠈꠤꠘꠤ ꠛꠋꠡ, ");
INSERT INTO syls_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","ꠎꠣꠞꠣꠢ ꠕꠣꠇꠤ ꠎꠣꠞꠣꠢꠤ ꠛꠋꠡ ꠀꠞ ꠡꠃꠟ ꠕꠣꠇꠤ ꠡꠃꠟꠤ ꠛꠋꠡ। ");
INSERT INTO syls_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","ꠁꠔꠣ ꠡꠤꠝꠤꠅꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠘꠣꠘꠣꠘ ꠛꠋꠡ। ꠄꠞꠣꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠉꠘꠤꠀ ꠛꠣꠁꠡ ꠀꠎꠣꠞ ꠖꠥꠁ-ꠡ ꠎꠘ ꠙꠣꠅꠀ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","ꠁꠀꠇꠥꠛꠞ ꠙꠥꠀ ꠍꠣꠖꠥꠞ ꠛꠋꠡꠗꠞ ꠅꠁꠟꠣ, ꠍꠤꠚꠘ ꠕꠣꠇꠤ ꠍꠤꠚꠘꠤ ꠛꠋꠡ, ꠢꠉꠤ ꠕꠣꠇꠤ ꠢꠉꠤꠀ ꠛꠋꠡ, ꠡꠥꠘꠤ ꠕꠣꠇꠤ ꠡꠥꠘꠤꠀ ꠛꠋꠡ, ");
INSERT INTO syls_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ꠅꠎꠘꠤ ꠕꠣꠇꠤ ꠅꠎꠘꠤꠀ ꠛꠋꠡ, ꠄꠁꠞꠤ ꠕꠣꠇꠤ ꠄꠁꠞꠤꠀ ꠛꠋꠡ, ");
INSERT INTO syls_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","ꠅꠞꠥꠖ ꠕꠣꠇꠤ ꠅꠞꠥꠖꠤ ꠛꠋꠡ, ꠀꠞ ꠅꠞꠦꠟꠤ ꠕꠣꠇꠤ ꠅꠞꠦꠟꠤꠀ ꠛꠋꠡ। ");
INSERT INTO syls_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","ꠄꠞꠣ ꠅꠁꠟꠣ ꠍꠣꠖꠥ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠘꠣꠘꠣꠘ ꠛꠋꠡ। ꠄꠞꠣꠞ ꠝꠣꠎꠦ ꠉꠘꠣ ꠝꠣꠘꠥꠡ ꠅꠁꠟꠣ ꠌꠣꠟ꠆ꠟꠤꠡ ꠀꠎꠣꠞ ꠙꠣꠌ-ꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","ꠁꠀꠇꠥꠛꠞ ꠙꠥꠀ ꠄꠢꠥꠖꠣꠞ ꠖꠥꠁ ꠙꠥꠀꠞ ꠘꠣꠝ ꠀꠍꠤꠟ ꠄꠁꠞ ꠀꠞ ꠅꠘꠘ, ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠕꠣꠇꠣꠞ ꠇꠣꠟꠅ ꠄꠞꠣ ꠝꠣꠞꠣ ꠉꠦꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","ꠅꠁꠟꠦ ꠄꠢꠥꠖꠣꠞ ꠀꠞꠅ ꠙꠥꠀꠂꠘ ꠀꠍꠟꠣ, ꠄꠞꠣꠞ ꠛꠋꠡꠗꠞ ꠅꠁꠟꠣ, ꠡꠦꠟꠣ ꠕꠣꠇꠤ ꠡꠦꠟꠣꠄꠁ ꠛꠋꠡ, ꠚꠤꠞꠥꠎ ꠕꠣꠇꠤ ꠚꠤꠞꠥꠎꠤ, ꠎꠣꠞꠣꠢ ꠕꠣꠇꠤ ꠎꠣꠞꠣꠢꠤ ꠛꠋꠡ। ");
INSERT INTO syls_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","ꠚꠤꠞꠥꠎꠞ ꠛꠋꠡꠗꠞ ꠅꠁꠟꠣ ꠢꠣꠍꠤꠞ ꠕꠣꠇꠤ ꠢꠣꠍꠤꠞꠤ ꠛꠋꠡ ꠀꠞ ꠢꠣꠝꠥꠟ ꠕꠣꠇꠤ ꠢꠣꠝꠥꠟꠤ ꠛꠋꠡ। ");
INSERT INTO syls_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","ꠄꠞꠣ ꠢꠇꠟꠃ ꠄꠢꠥꠖꠣ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠘꠣꠘꠣꠘ ꠛꠋꠡ। ꠄꠞꠣꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠉꠘꠤꠀ ꠍꠤꠅꠔ꠆ꠔꠁꠞ ꠀꠎꠣꠞ ꠙꠣꠌ-ꠡ ꠎꠘꠞꠦ ꠙꠣꠅꠀ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","ꠁꠀꠇꠥꠛꠞ ꠙꠥꠀ ꠁꠍꠣꠈꠞꠞ ꠛꠋꠡꠗꠞ ꠅꠁꠟꠣ, ꠔꠟꠣ ꠕꠣꠇꠤ ꠔꠟꠣꠄꠁ ꠛꠋꠡ, ꠚꠅꠀ ꠕꠣꠇꠤ ꠚꠅꠀꠁ ꠛꠋꠡ, ");
INSERT INTO syls_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","ꠎꠣꠡꠥꠛ ꠕꠣꠇꠤ ꠎꠣꠡꠥꠛꠤ ꠛꠋꠡ ꠀꠞ ꠡꠤꠝꠞꠘ ꠕꠣꠇꠤ ꠡꠝꠞꠘꠤ ꠛꠋꠡ। ");
INSERT INTO syls_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","ꠄꠞꠣ ꠢꠇꠟ ꠁꠍꠣꠈꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠘꠣꠘꠣꠘ ꠛꠋꠡ। ꠄꠞꠣꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠉꠘꠤꠀ ꠌꠃꠡꠐ꠆ꠐꠤ ꠀꠎꠣꠞ ꠔꠤꠘ-ꠡ ꠎꠘꠞꠦ ꠙꠣꠅꠀ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","ꠁꠀꠇꠥꠛꠞ ꠙꠥꠀ ꠍꠛꠥꠟꠘꠞ ꠛꠋꠡꠗꠞ ꠅꠁꠟꠣ ꠍꠦꠞꠦꠖ ꠕꠣꠇꠤ ꠍꠦꠞꠦꠖꠤ ꠛꠋꠡ, ꠄꠟꠘ ꠕꠣꠇꠤ ꠄꠟꠘꠤ ꠛꠋꠡ ꠀꠞ ꠎꠢꠟꠦꠟ ꠕꠣꠇꠤ ꠎꠢꠟꠦꠟꠤ ꠛꠋꠡ। ");
INSERT INTO syls_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","ꠄꠞꠣ ꠢꠇꠟ ꠍꠛꠥꠟꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠘꠣꠘꠣꠘ ꠛꠋꠡ। ꠄꠞꠣꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠡꠣꠁꠐ ꠀꠎꠣꠞ ꠙꠣꠌ-ꠡ ꠎꠘꠞꠦ ꠙꠣꠅꠀ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","ꠁꠀꠇꠥꠛꠞ ꠙꠥꠀ ꠁꠃꠍꠥꠚꠞ ꠙꠥꠀꠂꠘ ꠅꠁꠟꠣ ꠝꠣꠘꠡꠣ ꠀꠞ ꠀꠚꠞꠣꠁꠝ। ");
INSERT INTO syls_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","ꠄꠞꠣꠞ ꠝꠣꠎꠦ, ꠝꠣꠘꠡꠣꠞ ꠛꠋꠡꠗꠞ ꠅꠁꠟꠣ, ꠝꠣꠈꠤꠞ ꠕꠣꠇꠤ ꠝꠣꠈꠤꠞꠤ ꠛꠋꠡ, ꠀꠞ ꠝꠣꠈꠤꠞꠞ ꠙꠥꠀ ꠉꠤꠟꠤꠅꠖ ꠕꠣꠇꠤ ꠉꠤꠟꠤꠅꠖꠤ ꠛꠋꠡ। ");
INSERT INTO syls_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","ꠉꠤꠟꠤꠅꠖꠞ ꠛꠋꠡꠗꠞ ꠅꠁꠟꠣ ꠁꠀꠎꠤꠞ ꠕꠣꠇꠤ ꠁꠀꠎꠤꠞꠤ ꠛꠋꠡ, ꠢꠦꠟꠇ ꠕꠣꠇꠤ ꠢꠦꠟꠇꠤ ꠛꠋꠡ, ");
INSERT INTO syls_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","ꠅꠍꠞꠤꠄꠟ ꠕꠣꠇꠤ ꠅꠍꠞꠤꠄꠟꠤ ꠛꠋꠡ, ꠡꠦꠈꠝ ꠕꠣꠇꠤ ꠡꠦꠈꠝꠤ ꠛꠋꠡ, ");
INSERT INTO syls_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","ꠡꠤꠝꠤꠖꠣ ꠕꠣꠇꠤ ꠡꠤꠝꠤꠖꠣꠁ ꠛꠋꠡ ꠀꠞ ꠢꠦꠚꠞ ꠕꠣꠇꠤ ꠢꠦꠚꠞꠤ ꠛꠋꠡ। ");
INSERT INTO syls_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","ꠢꠦꠚꠞꠞ ꠙꠥꠀ ꠎꠟꠣꠙꠈꠣꠖ, ꠔꠣꠞ ꠇꠥꠘꠥ ꠙꠥꠀꠂꠘ ꠀꠍꠟꠣ ꠘꠣ, ꠈꠣꠟꠤ ꠙꠥꠠꠤꠘ ꠀꠍꠟꠣ। ꠙꠥꠠꠤꠘ꠆ꠔꠞ ꠘꠣꠝ ꠅꠁꠟ, ꠝꠢꠟꠣ, ꠘꠥꠀ, ꠢꠉꠟꠣ, ꠝꠤꠟꠇꠣ ꠀꠞ ꠔꠤꠞꠎꠣ। ");
INSERT INTO syls_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","ꠄꠞꠣ ꠢꠇꠟꠃ ꠝꠣꠘꠡꠣ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠘꠣꠘꠣꠘ ꠛꠋꠡ। ꠄꠞꠣꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠉꠘꠤꠀ ꠛꠣꠄꠀꠘ꠆ꠘ ꠀꠎꠣꠞ ꠡꠣꠔ-ꠡ ꠎꠘꠞꠦ ꠙꠣꠅꠀ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","ꠁꠀꠇꠥꠛꠞ ꠙꠥꠀ ꠀꠚꠞꠣꠁꠝꠞ ꠛꠋꠡꠗꠞ ꠅꠁꠟꠣ, ꠡꠥꠔꠟꠢ ꠕꠣꠇꠤ ꠡꠥꠔꠟꠢꠤ, ꠛꠦꠈꠞ ꠕꠣꠇꠤ ꠛꠦꠈꠞꠤ ꠀꠞ ꠔꠢꠘ ꠕꠣꠇꠤ ꠔꠢꠘꠤ ꠛꠋꠡ। ");
INSERT INTO syls_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","ꠡꠥꠔꠟꠢꠞ ꠛꠋꠡ, ꠄꠞꠘ ꠕꠣꠇꠤ ꠄꠞꠘꠤ ꠛꠋꠡ। ");
INSERT INTO syls_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","ꠄꠞꠣ ꠢꠇꠟ ꠀꠚꠞꠣꠁꠝ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠘꠣꠘꠣꠘ ꠛꠋꠡ। ꠄꠞꠣꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠉꠘꠤꠀ ꠛꠔ꠆ꠔꠤꠡ ꠀꠎꠣꠞ ꠙꠣꠌ-ꠡ ꠎꠘꠞꠦ ꠙꠣꠅꠀ ꠉꠦꠟ। ꠈꠣꠘ꠆ꠖꠣꠘ ꠢꠤꠡꠣꠛꠦ ꠄꠞꠣ ꠢꠇꠟꠃ ꠁꠃꠍꠥꠚꠞ ꠛꠋꠡꠗꠞ। ");
INSERT INTO syls_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","ꠁꠀꠇꠥꠛꠞ ꠙꠥꠀ ꠛꠤꠘ-ꠁꠀꠝꠤꠘꠞ ꠛꠋꠡꠗꠞ ꠅꠁꠟꠣ, ꠛꠦꠟꠣ ꠕꠣꠇꠤ ꠛꠦꠟꠣꠄꠁ ꠛꠋꠡ, ꠅꠡꠛꠦꠟ ꠕꠣꠇꠤ ꠅꠡꠛꠦꠟꠤ ꠛꠋꠡ, ꠀꠢꠤꠞꠣꠝ ꠕꠣꠇꠤ ꠀꠢꠤꠞꠣꠝꠤ ꠛꠋꠡ, ");
INSERT INTO syls_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","ꠡꠥꠚꠝ ꠕꠣꠇꠤ ꠡꠥꠚꠝꠤ ꠛꠋꠡ, ꠀꠞ ꠢꠥꠚꠝ ꠕꠣꠇꠤ ꠢꠥꠚꠝꠤ ꠛꠋꠡ। ");
INSERT INTO syls_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","ꠛꠦꠟꠣꠞ ꠙꠥꠀꠂꠘ ꠅꠞ꠆ꠖ ꠀꠞ ꠘꠣꠝꠣꠘꠞ ꠝꠣꠎꠖꠤ ꠛꠦꠟꠣꠞ ꠛꠋꠡꠗꠞ ꠅꠁꠟꠣ, ꠅꠞ꠆ꠖ ꠕꠣꠇꠤ ꠅꠞ꠆ꠖꠤ ꠛꠋꠡ ꠀꠞ ꠘꠣꠝꠣꠘ ꠕꠣꠇꠤ ꠘꠣꠝꠣꠘꠤ ꠛꠋꠡ। ");
INSERT INTO syls_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","ꠄꠞꠣ ꠛꠤꠘ-ꠁꠀꠝꠤꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠘꠣꠘꠣꠘ ꠛꠋꠡ। ꠄꠞꠣꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠙꠄꠔꠣꠟ꠆ꠟꠤꠡ ꠀꠎꠣꠞ ꠍꠄ-ꠡ ꠎꠘꠞꠦ ꠙꠣꠅꠀ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","ꠁꠀꠇꠥꠛꠞ ꠙꠥꠀ ꠖꠣꠘꠞ ꠛꠋꠡꠗꠞ ꠅꠁꠟꠣ, ꠡꠥꠢꠝ ꠕꠣꠇꠤ ꠡꠥꠢꠝꠤ ꠛꠋꠡ। ꠄꠞꠣꠃ ꠀꠍꠟꠣ ꠖꠣꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠥꠡ। ");
INSERT INTO syls_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","ꠄꠞꠣꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠉꠘꠤꠀ ꠌꠃꠡꠐ꠆ꠐꠤ ꠀꠎꠣꠞ ꠌꠣꠁꠞ-ꠡ ꠎꠘꠞꠦ ꠙꠣꠅꠀ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","ꠁꠀꠇꠥꠛꠞ ꠙꠥꠀ ꠀꠡꠤꠞꠞ ꠛꠋꠡꠗꠞ ꠅꠁꠟꠣ, ꠁꠝꠘꠣ ꠕꠣꠇꠤ ꠁꠝꠘꠣꠄꠁ ꠛꠋꠡ, ꠎꠤꠍꠛꠤ ꠕꠣꠇꠤ ꠎꠤꠍꠛꠤꠀ ꠛꠋꠡ ꠀꠞ ꠛꠞꠤꠀ ꠕꠣꠇꠤ ꠛꠞꠤꠀꠄꠁ ꠛꠋꠡ। ");
INSERT INTO syls_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","ꠛꠞꠤꠀꠞ ꠛꠋꠡꠗꠞ ꠅꠁꠟꠣ ꠢꠦꠛꠞ ꠕꠣꠇꠤ ꠢꠦꠛꠞꠤ ꠛꠋꠡ, ꠀꠞ ꠝꠟꠇꠤꠄꠟ ꠕꠣꠇꠤ ꠝꠟꠇꠤꠄꠟꠤ ꠛꠋꠡ। ");
INSERT INTO syls_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","ꠀꠡꠤꠞꠞ ꠙꠥꠠꠤꠞ ꠘꠣꠝ ꠀꠍꠤꠟ ꠍꠦꠞꠣ। ");
INSERT INTO syls_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","ꠄꠞꠣ ꠢꠇꠟꠃ ꠀꠡꠤꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠘꠣꠘꠣꠘ ꠛꠋꠡ। ꠄꠞꠣꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠉꠘꠤꠀ ꠔꠦꠙ꠆ꠙꠣꠘ꠆ꠘ ꠀꠎꠣꠞ ꠌꠣꠁꠞ-ꠡ ꠎꠘꠞꠦ ꠙꠣꠅꠀ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","ꠁꠀꠇꠥꠛꠞ ꠙꠥꠀ ꠘꠙ꠆ꠔꠣꠟꠤꠞ ꠛꠋꠡꠗꠞ ꠅꠁꠟꠣ, ꠎꠢꠡꠤꠄꠟ ꠕꠣꠇꠤ ꠎꠢꠡꠤꠄꠟꠤ ꠛꠋꠡ, ꠉꠥꠘꠤ ꠕꠣꠇꠤ ꠉꠥꠘꠤꠀ ꠛꠋꠡ, ");
INSERT INTO syls_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","ꠁꠎꠦꠞ ꠕꠣꠇꠤ ꠁꠎꠦꠞꠤ ꠛꠋꠡ, ꠀꠞ ꠡꠤꠟ꠆ꠟꠦꠝ ꠕꠣꠇꠤ ꠡꠤꠟ꠆ꠟꠦꠝꠤ ꠛꠋꠡ। ");
INSERT INTO syls_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","ꠄꠞꠣ ꠢꠇꠟꠃ ꠘꠙ꠆ꠔꠣꠟꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠘꠣꠘꠣꠘ ꠛꠋꠡ। ꠄꠞꠣꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠉꠘꠤꠀ ꠙꠄꠔꠣꠟ꠆ꠟꠤꠡ ꠀꠎꠣꠞ ꠌꠣꠁꠞ-ꠡ ꠎꠘꠞꠦ ꠙꠣꠅꠀ ꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","ꠔꠦ ꠉꠘꠣꠞ ꠛꠣꠖꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠎꠦ ꠎꠥꠖ꠆ꠖꠔ ꠎꠣꠅꠀꠞ ꠎꠥꠇꠣ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠞ ꠙꠞꠤꠝꠣꠘ ꠅꠁꠟ, ꠝꠥꠐ ꠍꠄ ꠟꠣꠈ ꠄꠇ ꠀꠎꠣꠞ ꠡꠣꠔ-ꠡ ꠔꠤꠡ ꠎꠘ। ");
INSERT INTO syls_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“ꠉꠘꠣ ꠅꠃ ꠝꠣꠘꠥꠡ ꠝꠣꠚꠤꠇ ꠀꠡ꠆ꠔꠣ ꠖꠦꠡꠞ ꠎꠝꠤꠘ ꠛꠣꠐꠤꠀ ꠖꠤꠔꠦ ꠅꠁꠛ, ꠎꠣꠔꠦ ꠢꠇꠟꠦ ꠎꠣꠞꠎꠤꠞ ꠛꠣꠐ ꠙꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","ꠎꠦ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠥꠡ ꠛꠦꠡꠤ ꠅꠃ ꠈꠣꠘ꠆ꠖꠣꠘꠞꠦ ꠛꠦꠡꠤ ꠀꠞ ꠎꠦ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠥꠡ ꠇꠝ, ꠅꠃ ꠈꠣꠘ꠆ꠖꠣꠘꠞꠦ ꠇꠝ ꠎꠣꠉꠣ ꠖꠤꠛꠣꠄ। ꠙꠞꠔꠦꠇ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠡꠦ ꠔꠣꠞ ꠝꠣꠘꠥꠡ ꠢꠤꠡꠣꠛꠦ ꠎꠣꠉꠣ-ꠎꠝꠤꠘ ꠙꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","ꠀꠞ ꠇꠥꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠦ ꠇꠥꠘ ꠎꠣꠉꠣꠔ ꠎꠝꠤꠘ ꠙꠣꠁꠛ, ꠁꠔꠣ ꠟꠐꠣꠞꠤ ꠝꠣꠞꠤꠀ ꠑꠤꠇ ꠇꠞꠣ ꠅꠁꠛ। ꠙꠞꠔꠦꠇ ꠛꠋꠡꠞ ꠙꠣꠅꠘꠣ ꠅꠋꠡ ꠔꠣꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠘꠣꠝꠦ ꠖꠦꠅꠀ ꠄꠟꠣꠇꠣꠞ ꠝꠣꠎꠦꠃ ꠕꠣꠇꠛ। ");
INSERT INTO syls_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠥꠡ ꠇꠝ ꠛꠣ ꠛꠦꠡꠤ ꠎꠦꠐꠣꠃ ꠅꠃꠇ, ꠟꠐꠣꠞꠤ ꠝꠣꠞꠤꠀ ꠎꠣꠉꠣ ꠑꠤꠇ ꠇꠞꠣ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","ꠢꠇꠟ ꠢꠦꠡꠦ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠛꠋꠡꠗꠞ ꠉꠘꠣ ꠅꠁꠟ। ꠄꠞꠣ ꠅꠁꠟꠣ, ꠎꠣꠞꠍꠥꠘ ꠕꠣꠇꠤ ꠎꠣꠞꠍꠥꠘꠤ ꠉꠥꠡ꠆ꠐꠤ, ꠇꠣꠢꠣꠔ ꠕꠣꠇꠤ ꠇꠣꠢꠣꠔꠤ ꠉꠥꠡ꠆ꠐꠤ ꠀꠞ ꠝꠣꠞꠣꠞꠤ ꠕꠣꠇꠤ ꠝꠣꠞꠣꠞꠤꠀ ꠉꠥꠡ꠆ꠐꠤ। ");
INSERT INTO syls_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠇꠤꠍꠥ ꠘꠣꠝꠇꠞꠣ ꠙꠞꠤꠛꠣꠞ ꠀꠍꠤꠟ, ꠄꠞꠣꠞ ꠝꠥꠟ ꠛꠣꠚꠞ ꠘꠣꠝ ꠅꠁꠟ ꠟꠤꠛꠘꠤ, ꠢꠦꠛꠞꠘ, ꠝꠢꠟꠤ, ꠝꠥꠡꠤ ꠀꠞ ꠇꠥꠞꠣꠢ। ꠇꠣꠢꠣꠔꠞ ꠄꠇ ꠙꠥꠀꠞ ꠘꠣꠝ ꠀꠍꠤꠟ ꠁꠝꠞꠣꠘ। ");
INSERT INTO syls_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","ꠁꠝꠞꠣꠘꠞ ꠛꠃꠞ ꠘꠣꠝ ꠁꠃꠈꠣꠛꠦꠎ, ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠕꠣꠇꠔꠦ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠎꠦ ꠄꠘ ꠎꠘꠝ ꠅꠁꠍꠤꠟ। ꠄꠘ ꠙꠦꠐ ꠕꠣꠇꠤ ꠁꠝꠞꠣꠘꠞ ꠙꠥꠀꠂꠘ ꠢꠣꠞꠥꠘ ꠀꠞ ꠝꠥꠍꠣ ꠀꠞ ꠔꠣꠞꠣꠞ ꠛꠁꠘ ꠝꠞꠤꠅꠝꠞ ꠎꠘꠝ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","ꠢꠣꠞꠥꠘꠞ ꠙꠥꠀꠂꠘ ꠅꠁꠟꠣ ꠘꠣꠖꠣꠛ, ꠀꠛꠤꠢꠥ, ꠀꠟꠤ-ꠀꠎꠞ ꠀꠞ ꠁꠍꠣꠝꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","ꠅꠁꠟꠦ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠜꠣꠋꠉꠤꠀ ꠖꠥꠍꠞꠣ ꠀꠉꠥꠁꠘ ꠖꠤꠀ ꠄꠛꠣꠖꠔ ꠇꠞꠣꠔ ꠉꠤꠀ ꠘꠣꠖꠣꠛ ꠀꠞ ꠀꠛꠤꠢꠥ ꠅꠃ ꠖꠥꠁ ꠎꠘꠞ ꠝꠞꠘ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","ꠄꠇ ꠝꠣꠡ ꠛꠣ ꠄꠞ ꠛꠦꠡꠤ ꠛꠄꠅꠡꠞ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠞ ꠙꠞꠤꠝꠣꠘ ꠀꠍꠤꠟ ꠔꠦꠁꠡ ꠀꠎꠣꠞ। ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠜꠤꠔꠞꠦ ꠄꠞꠣꠞꠦ ꠇꠥꠘꠥ ꠎꠣꠉꠣꠞ ꠝꠣꠟꠤꠇꠣꠘꠣ ꠖꠦꠅꠀ ꠅꠁꠍꠦ ꠘꠣ ꠉꠔꠤꠇꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠅꠁꠘ꠆ꠘꠣꠁꠘ꠆ꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠟꠉꠦ ꠄꠞꠣꠞꠦ ꠄꠇꠟꠉꠦ ꠉꠘꠣꠅ ꠅꠁꠍꠦ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","ꠎꠤꠞꠤꠢꠅ ꠐꠣꠃꠘꠞ ꠃꠟꠐꠣꠛꠣꠄ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠗꠣꠞꠅ ꠝꠥꠀꠛꠞ ꠔꠟ ꠎꠣꠉꠣꠔ ꠖꠥꠍꠞꠣꠛꠣꠞ ꠝꠣꠘꠥꠡ ꠉꠘꠣꠞ ꠡꠝꠄ ꠝꠥꠍꠣ ꠘꠛꠤ ꠀꠞ ꠁꠝꠣꠝ ꠀꠟꠤ-ꠀꠎꠞꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠉꠘꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","ꠅꠁꠟꠦ ꠙꠄꠟꠣ ꠛꠣꠞ ꠍꠤꠘꠣꠁ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠝꠥꠍꠣ ꠀꠞ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠎꠣꠞꠣꠞꠦ ꠉꠘꠤꠍꠟꠣ, ꠅꠃ ꠖꠥꠍꠞꠣꠛꠣꠞ ꠉꠘꠣꠞ ꠡꠝꠄ ꠄꠞꠣꠞ ꠝꠣꠎꠞ ꠄꠇꠎꠘꠅ ꠎꠤꠘ꠆ꠖꠣ ꠞꠁꠍꠂꠘ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","ꠀꠍꠟꠦ ꠅꠔꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠛꠦꠙꠣꠞꠦ ꠝꠣꠛꠥꠖꠦ ꠀꠉꠦꠃ ꠇꠁꠍꠟꠣ, ꠔꠣꠞꠣ ꠘꠤꠌ꠆ꠌꠄ ꠅꠃ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠝꠣꠞꠣ ꠎꠣꠁꠛꠣ। ꠀꠞ ꠢꠣꠍꠣꠃ ꠈꠣꠟꠤ ꠎꠤꠚꠥꠘ꠆ꠘꠤꠞ ꠙꠥꠀ ꠇꠣꠟꠥꠔ ꠀꠞ ꠘꠥꠘꠞ ꠙꠥꠀ ꠁꠃꠍꠣ ꠍꠣꠠꠣ ꠔꠣꠞꠣꠞ ꠝꠣꠎꠞ ꠖꠥꠍꠞꠣ ꠇꠦꠃ ꠎꠤꠘ꠆ꠖꠣ ꠞꠁꠍꠤꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","ꠁꠃꠍꠥꠚꠞ ꠙꠥꠀ ꠝꠣꠘꠡꠣꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠎꠟꠣꠙꠈꠣꠖꠞ ꠙꠥꠠꠤꠘ꠆ꠔꠞ ꠍꠤꠟꠍꠤꠟꠣ ꠅꠁꠟ, ꠝꠣꠘꠡꠣꠞ ꠙꠥꠀ ꠝꠣꠈꠤꠞ, ꠝꠣꠈꠤꠞꠞ ꠙꠥꠀ ꠉꠤꠟꠤꠅꠖ, ꠉꠤꠟꠤꠅꠖꠞ ꠙꠥꠀ ꠢꠦꠚꠞ ꠀꠞ ꠢꠦꠚꠞꠞ ꠙꠥꠀꠞ ꠘꠣꠝ ꠎꠟꠣꠙꠈꠣꠖ। ꠎꠟꠣꠙꠈꠣꠖꠞ ꠙꠥꠠꠤꠘ ꠅꠁꠟꠣ ꠝꠢꠟꠣ, ꠘꠥꠀ, ꠢꠉꠟꠣ, ꠝꠤꠟꠇꠣ ꠀꠞ ꠔꠤꠞꠎꠣ। ");
INSERT INTO syls_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","ꠅꠃ ꠙꠥꠠꠤꠘ ꠀꠁꠀ ꠝꠤꠟꠘ-ꠔꠣꠝ꠆ꠛꠥꠞ ꠖꠥꠀꠞꠞ ꠍꠣꠝꠘꠦ ꠃꠛꠣꠁꠀ ꠝꠥꠍꠣ ꠘꠛꠤ, ꠁꠝꠣꠝ ꠀꠟꠤ-ꠀꠎꠞ, ꠝꠥꠞꠛ꠆ꠛꠤ ꠘꠦꠔꠣ ꠀꠞ ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“ꠀꠝꠞꠣꠞ ꠛꠣꠛꠣ ꠔ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠝꠣꠞꠣ ꠉꠦꠍꠂꠘ। ꠀꠞ ꠇꠥꠞꠣꠢꠞ ꠖꠟꠞ ꠎꠦꠔꠣ ꠝꠣꠘꠡꠦ ꠝꠣꠛꠥꠖꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠘꠣꠚꠞꠝꠣꠘꠤ ꠇꠞꠍꠟꠣ, ꠔꠣꠁꠘ ꠔ ꠁꠔꠣꠞ ꠟꠉꠦ ꠀꠍꠟꠣ ꠘꠣ। ꠔꠣꠁꠘ ꠈꠣꠟꠤ ꠔꠣꠘ ꠘꠤꠎꠞ ꠉꠥꠘꠣꠞ ꠖꠣꠄ ꠝꠣꠞꠣ ꠉꠦꠍꠂꠘ। ꠀꠞ ꠀꠝꠞꠣꠞ ꠇꠥꠘꠥ ꠜꠣꠁ ꠎꠘꠝꠤꠍꠂꠘ ꠘꠣ, ");
INSERT INTO syls_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","ꠔꠦ ꠜꠣꠁ ꠘꠣ ꠕꠣꠇꠣꠄ ꠅꠈꠘ ꠀꠝꠞꠣꠞ ꠛꠣꠚꠞ ꠘꠣꠝ ꠇꠤꠔꠣ ꠁ ꠛꠋꠡ ꠕꠣꠇꠤ ꠝꠤꠐꠤꠎꠤꠔ ꠘꠤ? ꠔꠣꠘ ꠡꠞꠤꠇꠣꠘꠞ ꠟꠉꠦ ꠀꠝꠞꠣꠞꠦꠅ ꠎꠣꠉꠣ-ꠎꠝꠤꠘꠞ ꠛꠣꠐ ꠖꠦꠃꠇ꠆ꠇꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","ꠔꠦꠃ ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠔꠣꠞꠣꠞ ꠛꠦꠙꠣꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠀꠞꠎ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘꠞꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“ꠎꠟꠣꠙꠈꠣꠖꠞ ꠙꠥꠠꠤꠘ꠆ꠔꠦ ꠑꠤꠇ ꠇꠕꠣꠃ ꠇꠁꠍꠦ। ꠔꠣꠞꠣꠞ ꠛꠣꠚꠞ ꠡꠞꠤꠇꠣꠘꠞ ꠟꠉꠦ ꠔꠣꠞꠣꠞꠦꠅ ꠎꠝꠤ-ꠎꠝꠣꠞ ꠛꠣꠐ ꠖꠤꠔꠦ ꠅꠁꠛ। ꠔꠣꠞꠣ ꠎꠣꠔꠦ ꠔꠣꠞꠣꠞ ꠛꠣꠚꠣꠁꠔꠤ ꠎꠝꠤꠘ ꠙꠣꠁꠘ, ꠁꠈꠣꠘ ꠔꠥꠝꠤ ꠈꠤꠀꠟ ꠞꠣꠈꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","ꠀꠞ ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠅ, ꠝꠞꠣꠞ ꠇꠣꠟꠅ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠙꠥꠀꠂꠘ ꠘꠣ ꠕꠁꠀ ꠝꠞꠤꠎꠣꠄ, ꠔꠦ ꠔꠣꠞ ꠎꠝꠤ-ꠎꠝꠣꠞ ꠛꠣꠐ ꠔꠣꠞ ꠙꠥꠠꠤꠘ꠆ꠔꠦ ꠙꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","ꠔꠣꠞ ꠇꠥꠘꠥ ꠙꠥꠠꠤꠘ ꠘꠣ ꠕꠣꠇꠟꠦ ꠔꠣꠞ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠦ ꠁ ꠡꠝ꠆ꠙꠔ꠆ꠔꠤ ꠙꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","ꠔꠣꠞ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠜꠣꠁ ꠘꠣ ꠕꠣꠇꠦ, ꠔꠦ ꠁꠔꠣ ꠔꠣꠞ ꠌꠣꠌꠣꠁꠘ꠆ꠔꠦ ꠙꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","ꠀꠞ ꠔꠣꠞ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠌꠣꠌꠣꠅ ꠘꠣ ꠕꠣꠇꠂꠘ, ꠔꠦ ꠔꠣꠞ ꠛꠋꠡꠞ ꠢꠇꠟ ꠕꠣꠇꠤ ꠀꠙꠘ ꠎꠘꠦ ꠁ ꠡꠝ꠆ꠙꠔ꠆ꠔꠤ ꠙꠣꠁꠛꠣ, ꠄꠁꠘ ꠁꠔꠣꠞ ꠝꠣꠟꠤꠇ ꠅꠁꠛꠣ। ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠛꠣꠔꠣꠁꠟ ꠝꠣꠛꠥꠖꠞ ꠅꠃ ꠢꠥꠇꠥꠝ ꠅꠁꠟ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠣꠉꠤ ꠎꠝꠤ-ꠎꠝꠣꠞ ꠀꠁꠘꠞ ꠄꠇ ꠗꠣꠞꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, “ꠔꠥꠝꠤ ꠀꠛꠣꠞꠤꠝ ꠙꠣꠠꠞ ꠅꠃ ꠃꠌꠣ ꠐꠤꠟ꠆ꠟꠣꠞ ꠃꠙꠞꠦ ꠃꠑꠅ, ꠃꠑꠤꠀ ꠀꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠦ ꠖꠦꠡ ꠖꠤꠍꠤ, ꠅꠈꠣꠘ ꠖꠦꠈꠤꠟꠣꠅ। ");
INSERT INTO syls_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","ꠀꠞ ꠢꠥꠘꠅ, ꠔꠥꠝꠣꠞ ꠜꠣꠁ ꠢꠣꠞꠥꠘ ꠎꠦꠟꠣ ꠔꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠟꠣꠈꠣꠘ ꠇꠄꠛꠞꠅ ꠢꠥꠔꠤ ꠞꠁꠍꠦ, ꠅꠃ ꠖꠦꠡ ꠖꠦꠈꠣꠞ ꠛꠣꠖꠦ ꠔꠥꠝꠤꠅ ꠅꠟꠣ ꠔꠥꠝꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠉꠦꠍꠦ ꠎꠣꠁꠛꠣꠄꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","ꠝꠘꠅ ꠀꠍꠦ ꠘꠤ, ꠎꠤꠘ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠇꠣꠖꠦꠡ ꠄꠟꠣꠇꠣꠞ ꠝꠦꠞꠤꠛꠣ ꠘꠣꠝꠞ ꠎꠣꠉꠣꠞ ꠢꠃ ꠙꠣꠘꠤꠞ ꠇꠕꠣ? ꠝꠞꠥꠜꠥꠝꠤꠔ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠎꠦꠛꠟꠣ ꠙꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠀꠝꠣꠞ ꠛꠤꠞꠥꠗꠤꠔꠣ ꠇꠞꠍꠤꠟ, ꠔꠣꠞꠣꠞ ꠍꠣꠝꠘꠦ ꠔꠥꠝꠞꠣꠅ ꠀꠝꠣꠞꠦ ꠙꠣꠇ-ꠙꠛꠤꠔ꠆ꠞ ꠇꠁꠀ ꠘꠣ ꠝꠣꠘꠤꠀ ꠀꠝꠣꠞ ꠢꠥꠇꠥꠝꠞ ꠃꠟꠐꠣ ꠉꠦꠍꠟꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","ꠅꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠝꠥꠍꠣꠄ ꠀꠞꠎ ꠇꠞꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“ꠅ ꠝꠣꠛꠥꠖ, ꠎꠦꠁꠘ ꠢꠇꠟ ꠝꠣꠘꠡꠞ ꠎꠤꠘ꠆ꠖꠦꠉꠤ ꠖꠣꠘ ꠇꠞꠂꠘ, ꠢꠃ ꠀꠟ꠆ꠟꠣ ꠝꠣꠛꠥꠖꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠃꠙꠞꠦ ꠅꠟꠣ ꠄꠇꠎꠘ ꠝꠣꠘꠡꠞꠦ ꠛꠅꠀꠁꠟ ꠇꠞꠃꠇ꠆ꠇꠣ, ");
INSERT INTO syls_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ꠎꠦ ꠘꠦꠔꠣꠄ ꠢꠇꠟ ꠝꠣꠘꠡꠞꠦ ꠊꠞꠦ-ꠛꠣꠞꠦ, ꠝꠣꠑꠅ-ꠝꠄꠖꠣꠘꠅ ꠢꠇꠟ ꠛꠦꠙꠣꠞꠦ ꠌꠣꠟꠣꠁꠛꠣ। ꠔꠦꠃ ꠝꠣꠛꠥꠖꠞ ꠛꠘ꠆ꠖꠣ ꠅꠇꠟ ꠀ-ꠞꠣꠈꠣꠟꠤ ꠉꠞꠥ-ꠍꠣꠉꠟꠞ ꠟꠣꠈꠣꠘ ꠅꠁꠔꠣ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","ꠔꠦꠃ ꠝꠣꠛꠥꠖꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠘꠥꠘꠞ ꠙꠥꠔ ꠁꠃꠍꠣꠞ ꠜꠤꠔꠞꠦ ꠔ ꠀꠟ꠆ꠟꠣꠁ ꠞꠥꠢꠥ ꠀꠍꠂꠘ। ꠔꠥꠝꠤ ꠔꠣꠞꠦ ꠀꠘꠤꠀ ꠔꠣꠞ ꠃꠙꠞꠦ ꠔꠥꠝꠣꠞ ꠀꠔ ꠕꠁꠀ ꠈꠦꠟꠣꠚꠔꠤ ꠛꠈꠡꠤꠀ ꠖꠦꠅ। ");
INSERT INTO syls_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","ꠔꠥꠝꠤ ꠁꠝꠣꠝ ꠀꠟꠤ-ꠀꠎꠞ ꠀꠞ ꠢꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠍꠣꠝꠘꠦ ꠔꠣꠞꠦ ꠀꠎꠤꠞ ꠇꠞꠤꠀ, ꠔꠣꠞꠣꠞ ꠍꠣꠝꠘꠦꠃ ꠔꠣꠞꠦ ꠖꠣꠄꠁꠔ꠆ꠔ ꠡꠝꠎꠣꠁ ꠖꠦꠅ। ");
INSERT INTO syls_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","ꠔꠥꠝꠣꠞꠦ ꠎꠦ ꠈꠦꠝꠔꠣ ꠖꠦꠅꠀ ꠅꠁꠍꠦ, ꠅꠃ ꠈꠦꠝꠔꠣꠞ ꠇꠤꠍꠥ ꠛꠣꠐ ꠔꠣꠞꠦ ꠖꠦꠅ, ꠔꠦꠃ ꠢꠇ꠆ꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠔꠣꠞ ꠇꠕꠣꠄ ꠌꠟꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","ꠛꠣꠖꠦ ꠢꠦ ꠁꠝꠣꠝ ꠀꠟꠤ-ꠀꠎꠞꠞ ꠉꠦꠍꠦ ꠎꠣꠁꠛ, ꠉꠦꠟꠦ ꠀꠟꠤ-ꠀꠎꠞꠦ ꠀꠟ꠆ꠟꠣꠞ ꠙꠛꠤꠔ꠆ꠞ ꠃꠞꠤꠝ ꠀꠞ ꠔꠥꠝ꠆ꠝꠤꠝ ꠙꠣꠔ꠆ꠔꠞꠖꠤ ꠟꠐꠣꠞꠤ ꠝꠣꠞꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠝꠞ꠆ꠎꠤ ꠎꠣꠘꠔꠣ ꠙꠣꠞꠛꠣ। ꠅꠟꠣ ꠁꠃꠍꠣ ꠀꠞ ꠔꠣꠝꠣꠝ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠌꠟꠣ-ꠚꠤꠞꠣ ꠇꠞꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠇꠣꠝ ꠇꠞꠟꠣ। ꠔꠣꠁꠘ ꠁꠝꠣꠝ ꠀꠟꠤ-ꠀꠎꠞ ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠍꠣꠝꠘꠦ ꠁꠃꠍꠣꠞꠦ ꠘꠤꠀ ꠀꠎꠤꠞ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","ꠀꠞ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠔꠣꠘ ꠃꠙꠞꠦ ꠀꠔ ꠕꠁꠀ ꠔꠣꠘꠞꠦ ꠖꠣꠄꠁꠔ꠆ꠔ ꠡꠝꠎꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠀꠝꠣꠞ ꠅꠃ ꠢꠥꠇꠥꠝ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠀꠝꠣꠞꠦ ꠈꠥꠡꠤ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠊꠦꠞꠣꠘ ꠀꠟꠣ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠝꠣꠞ ꠈꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠡꠑꠤꠇ ꠡꠝꠄꠄ ꠀꠎꠤꠞ ꠇꠞꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","ꠔꠣꠞꠣꠞꠦ ꠄꠅꠈꠣꠘ ꠇꠅ, ꠔꠥꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠙꠞꠔꠤꠖꠤꠘꠞ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠅꠃ ꠙꠡꠥ ꠅꠇꠟ ꠀꠘꠤꠅ, ꠙꠞꠔꠤꠖꠤꠘ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠖꠥꠉꠥ ꠘꠤꠈꠥꠔ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠀꠘꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","ꠀꠘꠤꠀ ꠄꠉꠥ ꠛꠤꠀꠘꠦ ꠀꠞ ꠄꠉꠥ ꠢꠣꠁꠘ꠆ꠎꠣ ꠛꠣꠟꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","ꠄꠞꠟꠉꠞ ꠙꠞꠔꠤꠖꠤꠘꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠟꠣꠉꠤ ꠖꠥꠁ ꠡꠦꠞ ꠝꠄꠖꠣ ꠀꠞ ꠄꠇ ꠡꠦꠞ ꠎꠄꠔꠥꠘꠞ ꠙꠤꠡꠣ ꠔꠦꠟ ꠀꠘꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","ꠁꠐꠣ ꠅꠁꠟ ꠢꠃ ꠙꠞꠔꠤꠖꠤꠘꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠎꠦꠔꠣ ꠔꠥꠞ ꠙꠣꠠꠅ ꠡꠣꠁꠛꠡ꠆ꠔ ꠇꠞꠣ ꠅꠁꠍꠤꠟ। ꠀꠞ ꠁꠔꠣ ꠔ ꠀꠝꠣꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ, ꠄꠞ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠀꠝꠤ ꠈꠥꠡꠤ ꠅꠁ। ");
INSERT INTO syls_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","ꠙꠞꠔꠦꠇ ꠝꠦꠠꠣꠞ ꠟꠉꠦ ꠄꠇ ꠡꠦꠞ ꠀꠋꠉꠥꠞꠞ ꠡꠞꠛꠔ ꠖꠤꠀ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠅꠃ ꠡꠞꠛꠔ ꠄꠛꠣꠖꠔ ꠈꠣꠘꠣꠞ ꠃꠑꠣꠘꠅ ꠓꠣꠟꠤ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","ꠝꠦꠠꠣꠞ ꠀꠞꠇ ꠛꠣꠁꠌ꠆ꠌꠣꠞꠦ ꠢꠣꠁꠘ꠆ꠎꠣ ꠛꠣꠟꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠄ। ꠄꠞꠟꠉꠦ ꠛꠤꠀꠘꠇꠥꠞ ꠟꠣꠈꠣꠘ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠀꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣ ꠀꠖꠣꠄ ꠇꠞꠛꠣꠄ। ꠁꠔꠣ ꠅꠁꠟ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ, ꠄꠞ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠀꠝꠤ ꠝꠣꠛꠥꠖ ꠈꠥꠡꠤ ꠅꠁ। ");
INSERT INTO syls_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ꠙꠞꠔꠦꠇ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞꠦ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠖꠥꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠄ। ꠄꠞꠟꠉꠦ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣꠞ ꠍꠣꠝꠣꠘꠣ ꠀꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣꠞ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠌꠣꠁꠞ ꠡꠦꠞ ꠝꠄꠖꠣꠅ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","ꠙꠞꠔꠤꠖꠤꠘꠞ ꠎꠣꠟꠣꠁꠟ ꠙꠡꠥ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠞ ꠄꠞ ꠟꠉꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣ ꠍꠣꠠꠣꠅ ꠙꠞꠔꠦꠇ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞꠦ ꠅꠃ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ꠙꠞꠔꠦꠇ ꠌꠣꠘ꠆ꠖꠞ ꠙꠄꠟꠣ ꠖꠤꠘ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠖꠥꠉꠥ ꠛꠤꠍꠣꠟ, ꠄꠉꠥ ꠝꠦꠠꠣ ꠀꠞ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠡꠣꠔꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠄ, ꠁ ꠢꠇꠟ ꠙꠡꠥ ꠙꠥꠞꠣ ꠘꠤꠈꠥꠔ ꠅꠁꠔ। ");
INSERT INTO syls_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","ꠅꠃ ꠙꠞꠔꠦꠇ ꠛꠤꠍꠣꠟꠞ ꠟꠉꠦ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠢꠤꠡꠣꠛꠦ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠍꠄ ꠡꠦꠞ ꠝꠄꠖꠣ ꠖꠤꠛꠣꠄ, ꠀꠞ ꠝꠦꠠꠣꠞ ꠟꠉꠦ ꠌꠣꠁꠞ ꠡꠦꠞ ꠝꠄꠖꠣ ꠖꠤꠅ, ");
INSERT INTO syls_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ꠀꠞ ꠙꠞꠔꠦꠇ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣꠞ ꠟꠉꠦ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠖꠥꠁ ꠡꠦꠞ ꠝꠄꠖꠣ ꠖꠤꠅ। ꠁꠔꠣ ꠅꠁꠟ ꠀꠝꠣꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ, ꠁꠔꠣꠞ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠀꠝꠤ ꠝꠣꠛꠥꠖ ꠈꠥꠡꠤ ꠅꠁ। ");
INSERT INTO syls_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣꠞ ꠟꠣꠉꠤ ꠙꠞꠔꠦꠇ ꠛꠤꠍꠣꠟꠞ ꠟꠉꠦ ꠖꠥꠁ ꠡꠦꠞ ꠀꠋꠉꠥꠞꠞ ꠡꠞꠛꠔ ꠖꠤꠛꠣꠄ। ꠙꠞꠔꠦꠇ ꠝꠦꠠꠣꠞ ꠟꠉꠦ ꠡꠥꠀ ꠡꠦꠞ ꠀꠞ ꠙꠞꠔꠦꠇ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣꠞ ꠟꠉꠦ ꠄꠇ ꠡꠦꠞ ꠡꠞꠛꠔ ꠖꠤꠅ। ꠁꠔꠣ ꠅꠁꠟ ꠝꠣꠡꠤꠇ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠛꠍꠞꠞ ꠙꠞꠔꠦꠇ ꠌꠣꠘ꠆ꠖꠅ ꠁꠔꠣ ꠀꠖꠣꠄ ꠇꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","ꠁꠔꠣꠞ ꠟꠉꠦ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠀꠝꠣꠞ ꠘꠣꠝꠦ ꠄꠉꠥ ꠍꠣꠉꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠅ। ꠔꠣ-ꠅ ꠙꠞꠔꠦꠇ ꠖꠤꠘꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠀꠞ ꠄꠞ ꠟꠉꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣꠅ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ꠙꠞꠔꠦꠇ ꠛꠍꠞꠞ ꠙꠄꠟꠣ ꠌꠣꠘ꠆ꠖꠞ ꠌꠃꠖ꠆ꠖ ꠔꠣꠞꠤꠈ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠀꠎꠣꠖꠤ ꠁꠖ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","ꠅꠃ ꠌꠣꠘ꠆ꠖꠞ ꠙꠘꠞ ꠔꠣꠞꠤꠈ ꠕꠣꠇꠤ ꠡꠣꠔ ꠖꠤꠘ ꠜꠞꠣ ꠀꠞꠇ ꠁꠖ ꠀꠖꠣꠄ ꠇꠞꠤꠅ, ꠁꠇꠐꠣꠞ ꠘꠣꠝ ꠈꠣꠝꠤꠞ ꠍꠣꠠꠣ ꠞꠥꠐꠤꠞ ꠁꠖ। ");
INSERT INTO syls_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","ꠄꠞ ꠙꠄꠟꠣ ꠖꠤꠘ ꠙꠛꠤꠔ꠆ꠞ ꠝꠤꠟꠘ-ꠝꠣꠢꠚꠤꠟ ꠇꠞꠤꠅ, ꠁ ꠖꠤꠘ ꠖꠥꠘꠤꠀꠛꠤ ꠘꠤꠅꠔꠦ ꠇꠥꠘꠥ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠣ ꠘꠣꠎꠣꠁꠎ। ");
INSERT INTO syls_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","ꠅꠃ ꠖꠤꠘ ꠀꠝꠣꠞ ꠘꠣꠝꠦ ꠖꠥꠉꠥ ꠛꠤꠍꠣꠟ, ꠄꠉꠥ ꠝꠦꠠꠣ ꠀꠞ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠡꠣꠔꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣꠖꠤ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠞꠔꠦꠇ ꠙꠡꠥ ꠘꠤꠈꠥꠔ ꠅꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","ꠅꠃ ꠙꠡꠥꠞ ꠟꠉꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠢꠤꠡꠣꠛꠦ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠝꠄꠖꠣ ꠖꠤꠛꠣꠄ, ꠄꠇꠅꠐꠣ ꠛꠤꠍꠣꠟꠞ ꠟꠉꠦ ꠍꠄ ꠡꠦꠞ, ꠝꠦꠠꠣ ꠙꠣꠑꠣꠞ ꠟꠉꠦ ꠌꠣꠁꠞ ꠡꠦꠞ, ");
INSERT INTO syls_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ꠀꠞ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣꠞ ꠟꠉꠦ ꠖꠥꠁ ꠡꠦꠞ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","ꠁꠔꠣꠞ ꠟꠉꠦ ꠔꠥꠝꠞꠣꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠙꠣꠑꠣ ꠍꠣꠉꠟꠅ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","ꠙꠞꠔꠦꠇ ꠖꠤꠘꠞ ꠛꠤꠀꠘꠇꠥꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠔ ꠖꠤꠛꠣꠄꠃ, ꠄꠞꠟꠉꠦ ꠅꠃ ꠇꠥꠞꠛꠣꠘꠤꠅ ꠀꠖꠣꠄ ꠇꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","ꠅꠃ ꠟꠣꠈꠣꠘ ꠙꠥꠞꠣ ꠢꠣꠙ꠆ꠔꠣꠞ ꠡꠣꠔꠅꠖꠤꠘ ꠀꠝꠣꠞꠦ ꠈꠥꠡꠤ ꠇꠞꠣꠞ ꠊꠦꠞꠣꠘ ꠀꠟꠣ ꠈꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠙꠞꠔꠦꠇ ꠖꠤꠘ ꠅꠃ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠛꠣꠄ। ꠙꠞꠔꠤꠖꠤꠘꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠞ ꠄꠞ ꠟꠉꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣꠞ ꠟꠉꠦ ꠅꠃ ꠇꠥꠞꠛꠣꠘꠤꠅ ꠀꠖꠣꠄ ꠇꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","ꠢꠦꠡꠦ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘꠅ ꠔꠥꠝꠞꠣ ꠙꠛꠤꠔ꠆ꠞ ꠝꠤꠟꠘ-ꠝꠣꠢꠚꠤꠟ ꠇꠞꠤꠅ, ꠅꠃ ꠖꠤꠘ ꠖꠥꠘꠤꠀꠛꠤ ꠘꠤꠅꠔꠦ ꠇꠥꠘꠥ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠣ ꠘꠣꠎꠣꠁꠎ। ");
INSERT INTO syls_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ꠙꠘ꠆ꠌꠣꠁꠡꠣ ꠁꠖꠞ ꠖꠤꠘ, ꠝꠣꠘꠤ ꠈꠦꠔꠞ ꠙꠄꠟꠣ ꠖꠣꠅꠀ ꠚꠡꠟ ꠖꠤꠀ ꠎꠦꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠘꠣꠝꠦ ꠙꠛꠤꠔ꠆ꠞ ꠝꠤꠟꠘ-ꠝꠣꠢꠚꠤꠟ ꠇꠞꠛꠣꠄ, ꠢꠤ ꠖꠤꠘ ꠇꠥꠘꠥ ꠖꠥꠘꠤꠀꠛꠤ ꠘꠤꠅꠔꠦ ꠇꠣꠝ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","ꠅꠃ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠖꠥꠉꠥ ꠛꠤꠍꠣꠟ, ꠄꠉꠥ ꠝꠦꠠꠣ ꠀꠞ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠡꠣꠔꠉꠥ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠖꠤꠀ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠤꠅ, ꠅꠃ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠀꠝꠤ ꠝꠣꠛꠥꠖ ꠈꠥꠡꠤ ꠅꠁ। ");
INSERT INTO syls_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","ꠀꠞ ꠅꠔꠣꠞ ꠟꠉꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠢꠤꠡꠣꠛꠦ ꠄꠇꠅꠐꠣ ꠛꠤꠍꠣꠟꠞ ꠟꠉꠦ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠍꠄ ꠡꠦꠞ ꠝꠄꠖꠣ, ꠝꠦꠠꠣꠞ ꠟꠉꠦ ꠌꠣꠁꠞ ꠡꠦꠞ, ");
INSERT INTO syls_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ꠀꠞ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣꠞ ꠟꠉꠦ ꠖꠥꠁ ꠡꠦꠞ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","ꠅꠔꠣꠞ ꠟꠉꠦ ꠄꠉꠥ ꠙꠣꠑꠣ ꠍꠣꠉꠟꠅ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠅ ꠔꠥꠝꠞꠣꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","ꠅꠃ ꠢꠇꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠞ ꠁꠔꠣꠞ ꠟꠉꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣꠞ ꠟꠉꠦ ꠙꠞꠔꠤꠖꠤꠘꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠞ ꠄꠞ ꠟꠉꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠀꠖꠣꠄ ꠇꠞꠛꠣꠄ। ꠈꠤꠀꠟ ꠞꠣꠈꠤꠅ, ꠇꠥꠞꠛꠣꠘꠤꠞ ꠢꠇꠟ ꠙꠡꠥ ꠎꠣꠘꠥ ꠙꠥꠞꠣꠙꠥꠞ ꠘꠤꠈꠥꠔ ꠅꠄ। ");
INSERT INTO syls_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","ꠝꠣꠛꠥꠖꠦ ꠀꠞꠅ ꠇꠁꠞꠣ, “ꠙꠞꠔꠦꠇ ꠛꠍꠞꠞ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠌꠣꠘ꠆ꠖꠞ ꠙꠄꠟꠣ ꠖꠤꠘ ꠅꠁꠟ, ꠔꠥꠝꠞꠣꠞ ꠡꠤꠋꠉꠣ ꠛꠣꠎꠣꠘꠤꠞ ꠁꠖꠞ ꠖꠤꠘ। ꠅꠃ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠙꠛꠤꠔ꠆ꠞ ꠝꠤꠟꠘ-ꠝꠣꠢꠚꠤꠟ ꠇꠞꠤꠅ। ꠁ ꠖꠤꠘ ꠖꠥꠘꠤꠀꠛꠤ ꠘꠤꠅꠔꠦ ꠇꠥꠘꠥ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠣ ꠘꠣꠎꠣꠁꠎ। ");
INSERT INTO syls_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","ꠅꠃ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞꠦ ꠈꠥꠡꠤ ꠇꠞꠣꠞ ꠊꠦꠞꠣꠘ ꠀꠟꠣ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ, ꠄꠉꠥ ꠛꠤꠍꠣꠟ, ꠄꠉꠥ ꠝꠦꠠꠣ ꠀꠞ ꠡꠣꠔꠉꠥ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠅ, ꠢꠇꠟ ꠙꠡꠥ ꠎꠣꠘꠥ ꠙꠥꠞꠣꠙꠥꠞ ꠘꠤꠈꠥꠔ ꠅꠄ। ");
INSERT INTO syls_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","ꠀꠞ ꠅꠔꠣꠞ ꠟꠉꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠢꠤꠡꠣꠛꠦ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠝꠄꠖꠣ ꠖꠤꠅ। ꠛꠤꠍꠣꠟꠞ ꠟꠉꠦ ꠍꠄ ꠡꠦꠞ, ꠝꠦꠠꠣꠞ ꠟꠉꠦ ꠌꠣꠁꠞ ꠡꠦꠞ, ");
INSERT INTO syls_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ꠀꠞ ꠙꠞꠔꠦꠇ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣꠞ ꠟꠉꠦ ꠖꠥꠁ ꠡꠦꠞ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","ꠁꠔꠣꠞ ꠟꠉꠦ ꠔꠥꠝꠞꠣꠞ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠙꠣꠑꠣ ꠍꠣꠉꠟꠅ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","ꠙꠞꠔꠦꠇ ꠌꠣꠘ꠆ꠖꠞ ꠀꠞ ꠙꠞꠔꠤ ꠖꠤꠘꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠁꠔꠣꠞ ꠟꠉꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠀꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣ ꠍꠣꠠꠣꠅ ꠅꠃ ꠇꠥꠞꠛꠣꠘꠤ ꠅꠇꠟ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ꠁꠔꠣ ꠔ ꠀꠝꠣꠞ ꠘꠣꠝꠦ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ, ꠁꠔꠣꠞ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠀꠝꠤ ꠝꠣꠛꠥꠖ ꠈꠥꠡꠤ ꠅꠁ। ");
INSERT INTO syls_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ꠀꠞ ꠅꠃ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠌꠣꠘ꠆ꠖꠞ ꠖꠡ ꠔꠣꠞꠤꠈꠅ ꠄꠇꠐꠣ ꠙꠛꠤꠔ꠆ꠞ ꠝꠤꠟꠘ-ꠝꠣꠢꠚꠤꠟ ꠇꠞꠛꠣꠄ। ꠅꠃ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠙꠞꠔꠦꠇꠦ ꠘꠔ ꠅꠁꠀ ꠎꠣꠞꠎꠤꠞ ꠖꠤꠟ ꠡꠙꠤꠀ ꠖꠤꠛꠣꠄ, ꠁ ꠖꠤꠘ ꠇꠦꠃ ꠇꠥꠘꠥꠎꠣꠔ ꠇꠣꠝ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","ꠀꠝꠤ ꠝꠣꠛꠥꠖꠞꠦ ꠈꠥꠡꠤ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠊꠦꠞꠣꠘ ꠀꠟꠣ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠘꠤꠈꠥꠔ ꠄꠉꠥ ꠛꠤꠍꠣꠟ, ꠄꠉꠥ ꠝꠦꠠꠣ, ꠀꠞ ꠡꠣꠔꠉꠥ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣꠞꠦ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","ꠀꠞ ꠅꠔꠣꠞ ꠟꠉꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠢꠤꠡꠣꠛꠦ ꠛꠤꠍꠣꠟꠞ ꠟꠉꠦ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠍꠄ ꠡꠦꠞ ꠝꠄꠖꠣ ꠖꠤꠅ, ꠝꠦꠠꠣꠞ ꠟꠉꠦ ꠌꠣꠁꠞ ꠡꠦꠞ, ");
INSERT INTO syls_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ꠀꠞ ꠙꠞꠔꠦꠇ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣꠞ ꠟꠉꠦ ꠖꠥꠁ ꠡꠦꠞ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","ꠢꠦꠡꠦ ꠉꠥꠘꠣ ꠝꠣꠚꠤꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠙꠣꠑꠣ ꠍꠣꠉꠟꠅ ꠖꠤꠛꠣꠄ। ꠁꠖꠞ ꠅꠃ ꠇꠥꠞꠛꠣꠘꠤ ꠅꠇꠟ ꠍꠣꠠꠣꠅ ꠉꠥꠘꠣꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠞ ꠙꠞꠔꠤ ꠖꠤꠘꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠄꠞ ꠟꠉꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠀꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣꠅ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ꠔꠥꠝꠞꠣ ꠒꠦꠞꠣ-ꠊꠞꠞ ꠁꠖꠞ ꠢꠣꠙ꠆ꠔꠣꠞ ꠙꠄꠟꠣ ꠖꠤꠘ ꠝꠣꠘꠤ, ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠌꠣꠘ꠆ꠖꠞ ꠙꠘꠞ ꠔꠣꠞꠤꠈꠅ, ꠄꠇꠐꠣ ꠙꠛꠤꠔ꠆ꠞ ꠝꠤꠟꠘ-ꠝꠣꠢꠚꠤꠟ ꠇꠞꠛꠣꠄ, ꠅꠃ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠖꠥꠘꠤꠀꠛꠤ ꠘꠤꠅꠔꠦ ꠇꠥꠘꠥ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠤꠅ ꠘꠣ। ꠅꠃ ꠡꠣꠔ ꠖꠤꠘ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠁꠖꠞ ꠈꠥꠡꠤ-ꠛꠣꠡꠤ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","“ꠁꠖꠞ ꠙꠄꠟꠣ ꠖꠤꠘ ꠙꠥꠞꠣꠙꠥꠞ ꠘꠤꠈꠥꠔ ꠔꠦꠞꠅꠉꠥ ꠛꠤꠍꠣꠟ, ꠖꠥꠉꠥ ꠝꠦꠠꠣ ꠀꠞ ꠌꠃꠖ꠆ꠖꠉꠥ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠖꠤꠀ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ꠄꠞ ꠗꠥꠝꠣꠞ ꠊꠦꠞꠣꠘꠦ ꠀꠝꠤ ꠝꠣꠛꠥꠖ ꠈꠥꠡꠤ ꠅꠁ। ");
INSERT INTO syls_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","ꠅꠔꠣꠞ ꠙꠞꠔꠦꠇ ꠛꠤꠍꠣꠟꠞ ꠟꠉꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠢꠤꠡꠣꠛꠦ ꠔꠦꠟ ꠝꠣꠈꠣꠁꠟ ꠍꠄ ꠡꠦꠞ ꠝꠄꠖꠣ, ꠙꠞꠔꠦꠇ ꠝꠦꠠꠣꠞ ꠟꠉꠦ ꠌꠣꠁꠞ ꠡꠦꠞ, ");
INSERT INTO syls_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ꠀꠞ ꠙꠞꠔꠦꠇ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣꠞ ꠟꠉꠦ ꠖꠥꠁ ꠡꠦꠞ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","ꠢꠦꠡꠦ ꠉꠥꠘꠣ ꠝꠣꠚꠤꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠙꠣꠑꠣ ꠍꠣꠉꠟꠅ ꠖꠤꠛꠣꠄ। ꠖꠤꠀ ꠙꠞꠔꠤ ꠖꠤꠘꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠄꠞ ꠟꠉꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠀꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣꠅ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ꠁꠖꠞ ꠖꠥꠁ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠙꠥꠞꠣꠙꠥꠞ ꠘꠤꠈꠥꠔ ꠛꠣꠞꠅꠉꠥ ꠛꠤꠍꠣꠟ, ꠖꠥꠉꠥ ꠝꠦꠠꠣ ꠀꠞ ꠌꠃꠖ꠆ꠖꠉꠥ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","ꠅꠃ ꠛꠤꠍꠣꠟ, ꠝꠦꠠꠣ ꠀꠞ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠢꠇ꠆ꠇꠟꠐꠤꠞ ꠟꠉꠦ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ, ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣ, ꠙꠡꠥꠞ ꠙꠞꠤꠝꠣꠘ ꠝꠣꠚꠤꠇ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","ꠢꠦꠡꠦ ꠉꠥꠘꠣ ꠝꠣꠚꠤꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠙꠣꠑꠣ ꠍꠣꠉꠟꠅ ꠖꠤꠛꠣꠄ। ꠖꠤꠀ ꠙꠞꠔꠤ ꠖꠤꠘꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠄꠞ ꠟꠉꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠀꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣꠅ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ꠁꠖꠞ ꠔꠤꠘ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘꠅ ꠙꠥꠞꠣꠙꠥꠞ ꠘꠤꠈꠥꠔ ꠄꠉꠣꠞꠅꠉꠥ ꠛꠤꠍꠣꠟ, ꠖꠥꠉꠥ ꠝꠦꠠꠣ ꠀꠞ ꠌꠃꠖ꠆ꠖꠉꠥ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","ꠅꠃ ꠛꠤꠍꠣꠟ, ꠝꠦꠠꠣ ꠀꠞ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠢꠇ꠆ꠇꠟꠐꠤꠞ ꠟꠉꠦ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ, ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣ, ꠙꠡꠥꠞ ꠙꠞꠤꠝꠣꠘ ꠝꠣꠚꠤꠇ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","ꠢꠦꠡꠦ ꠉꠥꠘꠣ ꠝꠣꠚꠤꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠙꠣꠑꠣ ꠍꠣꠉꠟꠅ ꠖꠤꠛꠣꠄ। ꠖꠤꠀ ꠙꠞꠔꠤ ꠖꠤꠘꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠄꠞ ꠟꠉꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠀꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣꠅ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ꠁꠖꠞ ꠌꠣꠁꠞ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠙꠥꠞꠣꠙꠥꠞ ꠘꠤꠈꠥꠔ ꠖꠡꠉꠥ ꠛꠤꠍꠣꠟ, ꠖꠥꠉꠥ ꠝꠦꠠꠣ ꠀꠞ ꠌꠃꠖ꠆ꠖꠉꠥ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","ꠅꠃ ꠛꠤꠍꠣꠟ, ꠝꠦꠠꠣ ꠀꠞ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠢꠇ꠆ꠇꠟꠐꠤꠞ ꠟꠉꠦ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ, ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣ, ꠙꠡꠥꠞ ꠙꠞꠤꠝꠣꠘ ꠝꠣꠚꠤꠇ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","ꠢꠦꠡꠦ ꠉꠥꠘꠣ ꠝꠣꠚꠤꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠙꠣꠑꠣ ꠍꠣꠉꠟꠅ ꠖꠤꠛꠣꠄ। ꠖꠤꠀ ꠙꠞꠔꠤ ꠖꠤꠘꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠄꠞ ꠟꠉꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠀꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣꠅ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ꠁꠖꠞ ꠙꠣꠌ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠘꠤꠈꠥꠔ ꠘꠄꠉꠥ ꠛꠤꠍꠣꠟ, ꠖꠥꠉꠥ ꠝꠦꠠꠣ ꠀꠞ ꠌꠃꠖ꠆ꠖꠉꠥ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","ꠅꠃ ꠛꠤꠍꠣꠟ, ꠝꠦꠠꠣ ꠀꠞ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠢꠇ꠆ꠇꠟꠐꠤꠞ ꠟꠉꠦ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ, ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣ, ꠙꠡꠥꠞ ꠙꠞꠤꠝꠣꠘ ꠝꠣꠚꠤꠇ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","ꠢꠦꠡꠦ ꠉꠥꠘꠣ ꠝꠣꠚꠤꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠙꠣꠑꠣ ꠍꠣꠉꠟꠅ ꠖꠤꠛꠣꠄ। ꠖꠤꠀ ꠙꠞꠔꠤ ꠖꠤꠘꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠄꠞ ꠟꠉꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠀꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣꠅ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ꠁꠖꠞ ꠍꠄ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠘꠤꠈꠥꠔ ꠀꠐꠉꠥ ꠛꠤꠍꠣꠟ, ꠖꠥꠉꠥ ꠝꠦꠠꠣ ꠀꠞ ꠌꠃꠖ꠆ꠖꠉꠥ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","ꠅꠃ ꠛꠤꠍꠣꠟ, ꠝꠦꠠꠣ ꠀꠞ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠢꠇ꠆ꠇꠟꠐꠤꠞ ꠟꠉꠦ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ, ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣ, ꠙꠡꠥꠞ ꠙꠞꠤꠝꠣꠘ ꠝꠣꠚꠤꠇ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","ꠢꠦꠡꠦ ꠉꠥꠘꠣ ꠝꠣꠚꠤꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠙꠣꠑꠣ ꠍꠣꠉꠟꠅ ꠖꠤꠛꠣꠄ। ꠖꠤꠀ ꠙꠞꠔꠤ ꠖꠤꠘꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠄꠞ ꠟꠉꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠀꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣꠅ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ꠁꠖꠞ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠙꠥꠞꠣꠙꠥꠞ ꠘꠤꠈꠥꠔ ꠡꠣꠔꠉꠥ ꠛꠤꠍꠣꠟ, ꠖꠥꠉꠥ ꠝꠦꠠꠣ ꠀꠞ ꠌꠃꠖ꠆ꠖꠉꠥ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","ꠅꠃ ꠛꠤꠍꠣꠟ, ꠝꠦꠠꠣ ꠀꠞ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠢꠇ꠆ꠇꠟꠐꠤꠞ ꠟꠉꠦ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ, ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣ, ꠙꠡꠥꠞ ꠙꠞꠤꠝꠣꠘ ꠝꠣꠚꠤꠇ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","ꠢꠦꠡꠦ ꠉꠥꠘꠣ ꠝꠣꠚꠤꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠙꠣꠑꠣ ꠍꠣꠉꠟꠅ ꠖꠤꠛꠣꠄ। ꠖꠤꠀ ꠙꠞꠔꠤ ꠖꠤꠘꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠄꠞ ꠟꠉꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠀꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣꠅ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ꠁꠖꠞ ꠀꠐ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠝꠣꠘꠤ, ꠀꠈꠦꠞꠤ ꠖꠤꠘ ꠛꠤꠖꠣꠄꠁ ꠝꠣꠢꠚꠤꠟ ꠇꠞꠤꠅ, ꠁ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠖꠥꠘꠤꠀꠛꠤ ꠘꠤꠅꠔꠦ ꠇꠥꠘꠥ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","ꠀꠞ ꠝꠣꠛꠥꠖꠞꠦ ꠈꠥꠡꠤ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠊꠦꠞꠣꠘ ꠀꠟꠣ ꠀꠉꠥꠘꠤꠔ ꠖꠦꠅꠀ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠄꠇꠈꠣꠘ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠛꠣꠄ। ꠄꠞꠟꠣꠉꠤ ꠘꠤꠈꠥꠔ ꠄꠉꠥ ꠛꠤꠍꠣꠟ, ꠄꠉꠥ ꠝꠦꠠꠣ ꠀꠞ ꠡꠣꠔꠉꠥ ꠄꠇ ꠛꠍꠞ ꠛꠄꠅꠡꠤ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","ꠅꠃ ꠛꠤꠍꠣꠟ, ꠝꠦꠠꠣ ꠀꠞ ꠝꠦꠠꠣ-ꠛꠣꠁꠌ꠆ꠌꠣ ꠢꠇ꠆ꠇꠟꠐꠤꠞ ꠟꠉꠦ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ, ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣ, ꠙꠡꠥꠞ ꠙꠞꠤꠝꠣꠘ ꠝꠣꠚꠤꠇ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","ꠢꠦꠡꠦ ꠉꠥꠘꠣ ꠝꠣꠚꠤꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠄꠉꠥ ꠙꠣꠑꠣ ꠍꠣꠉꠟꠅ ꠖꠤꠛꠣꠄ। ꠖꠤꠀ ꠙꠞꠔꠤ ꠖꠤꠘꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠄꠞ ꠟꠉꠞ ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ ꠀꠞ ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣꠅ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ꠔꠦ ꠙꠞꠔꠦꠇ ꠁꠖꠞ ꠇꠣꠟꠅ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠔꠥꠝꠞꠣꠞ ꠁꠖ ꠅꠇꠟꠞ ꠘꠤꠅꠝ ꠝꠣꠚꠤꠇ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ꠁꠔꠣ ꠍꠣꠠꠣ, ꠝꠣꠘ꠆ꠘꠔ ꠙꠥꠞꠘꠞ ꠇꠥꠞꠛꠣꠘꠤ, ꠎꠦꠇꠥꠘꠥ ꠘꠚꠟ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠘꠤꠅꠔꠦ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠗꠣꠘ-ꠉꠝꠞ ꠍꠖꠉꠣ, ꠡꠞꠛꠔ-ꠙꠣꠘꠤꠞ ꠍꠖꠉꠣ, ꠀꠞ ꠍꠣꠟꠣꠝꠔꠤ ꠇꠥꠞꠛꠣꠘꠤꠅ ꠀꠖꠣꠄ ꠇꠞꠤꠅ।” ");
INSERT INTO syls_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠎꠦꠔꠣ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠎꠣꠘꠣꠁꠍꠟꠣ, ꠔꠣꠁꠘ ꠁꠔꠣ ꠢꠇ꠆ꠇꠟꠔꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","ꠛꠣꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠢꠇꠟ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠥꠞꠛ꠆ꠛꠤꠞꠦ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠂꠘ, ");
INSERT INTO syls_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","ꠇꠥꠘꠥ ꠛꠦꠐꠣꠄ ꠎꠥꠖꠤ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠇꠥꠘ꠆ꠔꠣ ꠝꠣꠘ꠆ꠘꠔ ꠇꠞꠦ ꠛꠣ ꠇꠍꠝ ꠈꠣꠁꠀ ꠇꠥꠘꠥꠔꠣ ꠇꠞꠣꠞ ꠅꠀꠖꠣꠄ ꠛꠘ꠆ꠖꠤ ꠅꠄ, ꠔꠦ ꠢꠦ ꠎꠣꠘꠥ ꠔꠣꠞ ꠅꠀꠖꠣ ꠜꠋꠉ ꠘꠣ ꠇꠞꠦ। ꠢꠦ ꠎꠦꠔꠣ ꠇꠁꠍꠦ, ꠁꠔꠣ ꠙꠥꠞꠘ ꠇꠞꠣ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“ꠇꠥꠘꠥ ꠀꠛꠤꠀꠔꠤ ꠙꠥꠠꠤꠄ ꠎꠥꠖꠤ ꠛꠣꠚꠞ ꠛꠣꠠꠤꠔ ꠕꠣꠇꠣꠞ ꠇꠣꠟꠅ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠇꠥꠘ꠆ꠔꠣ ꠝꠣꠘ꠆ꠘꠔ ꠇꠞꠦ ꠛꠣ ꠇꠥꠘꠥꠔꠣ ꠇꠞꠣꠞ ꠅꠀꠖꠣꠄ ꠛꠘ꠆ꠖꠤ ꠅꠄ, ");
INSERT INTO syls_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","ꠀꠞ ꠛꠣꠚꠦ ꠁꠔꠣ ꠢꠥꠘꠤꠀꠅ ꠙꠥꠠꠤꠞꠦ ꠇꠥꠘ꠆ꠔꠣ ꠘꠣ ꠇꠂꠘ, ꠔꠦ ꠁ ꠝꠣꠘ꠆ꠘꠔ ꠛꠣ ꠅꠀꠖꠣ ꠔꠣꠁ ꠙꠥꠞꠘ ꠇꠞꠣ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","ꠅꠁꠟꠦ ꠁꠈꠣꠘ ꠢꠥꠘꠣꠞ ꠟꠉꠦ ꠟꠉꠦ ꠛꠣꠚꠦ ꠎꠥꠖꠤ ꠙꠥꠠꠤꠞꠦ ꠁꠔꠣ ꠇꠞꠔꠦ ꠘꠤꠡꠦꠗ ꠇꠞꠂꠘ, ꠔꠦ ꠁ ꠝꠣꠘ꠆ꠘꠔ ꠛꠣ ꠅꠀꠖꠣ ꠛꠣꠔꠤꠟ ꠅꠁꠎꠤꠛ। ꠛꠣꠚꠦ ꠘꠤꠡꠦꠗ ꠇꠞꠣꠄ ꠝꠣꠛꠥꠖꠦꠅ ꠁ ꠝꠣꠘ꠆ꠘꠔ ꠛꠣ ꠅꠀꠖꠣ ꠜꠣꠋꠉꠣꠞꠦ ꠝꠣꠚ ꠇꠞꠤ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“ꠀꠞ ꠇꠥꠘꠥ ꠙꠥꠠꠤꠄ ꠎꠥꠖꠤ ꠌꠤꠘ꠆ꠔꠣ-ꠜꠣꠛꠘꠣ ꠘꠣ ꠇꠞꠤꠀ ꠀꠈꠔꠣ ꠇꠥꠘꠥ ꠝꠣꠘ꠆ꠘꠔ ꠛꠣ ꠅꠀꠖꠣ ꠇꠞꠤꠟꠣꠄ ꠀꠞ ꠛꠣꠖꠦ ꠔꠣꠁꠞ ꠛꠤꠀ ꠅꠁꠎꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","ꠛꠤꠀꠞ ꠛꠣꠖꠦ ꠎꠣꠝꠣꠁꠄ ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠟꠉꠦ ꠟꠉꠦ ꠇꠥꠘ꠆ꠔꠣ ꠘꠣ ꠇꠂꠘ, ꠔꠦ ꠁ ꠝꠣꠘ꠆ꠘꠔ ꠛꠣ ꠅꠀꠖꠣꠞꠦ ꠔꠣꠁ ꠙꠥꠞꠘ ꠇꠞꠣ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","ꠅꠁꠟꠦ ꠁꠔꠣ ꠢꠥꠘꠣꠞ ꠟꠉꠦ ꠟꠉꠦ ꠎꠣꠝꠣꠁꠄ ꠎꠥꠖꠤ ꠘꠤꠡꠦꠗ ꠇꠞꠂꠘ, ꠔꠦ ꠁ ꠝꠣꠘ꠆ꠘꠔ ꠛꠣ ꠅꠀꠖꠣꠞ ꠛꠣꠘ꠆ꠖꠘ ꠕꠣꠇꠤ ꠔꠣꠁ ꠈꠣꠟꠣꠍ ꠙꠣꠁꠛ, ꠝꠣꠛꠥꠖꠦꠅ ꠁꠔꠣ ꠝꠣꠚ ꠇꠞꠤ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“ꠀꠞ ꠇꠥꠘꠥ ꠠꠣꠠꠤ ꠛꠦꠐꠤ ꠛꠣ ꠔꠣꠟꠣꠇ ꠙꠣꠅꠀ ꠇꠥꠘꠥ ꠛꠦꠐꠤꠄ ꠎꠥꠖꠤ ꠝꠣꠘ꠆ꠘꠔ ꠇꠞꠤꠀ ꠅꠀꠖꠣꠄ ꠛꠘ꠆ꠖꠤ ꠅꠄ, ꠔꠦ ꠁꠔꠣ ꠙꠥꠞꠘ ꠇꠞꠣ ꠟꠣꠉꠛꠃ। ");
INSERT INTO syls_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“ꠎꠣꠝꠣꠁꠞ ꠊꠞꠞ ꠇꠥꠘꠥ ꠛꠃꠄ ꠎꠥꠖꠤ ꠅꠟꠣ ꠝꠣꠘ꠆ꠘꠔ ꠝꠣꠘꠦ ꠛꠣ ꠇꠍꠝ ꠈꠣꠁꠀ ꠅꠀꠖꠣꠄ ꠛꠘ꠆ꠖꠤ ꠅꠄ, ");
INSERT INTO syls_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","ꠛꠣꠖꠦ ꠔꠣꠁꠞ ꠎꠣꠝꠣꠁꠄ ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠇꠥꠘ꠆ꠔꠣ ꠘꠣ ꠝꠣꠔꠂꠘ, ꠔꠣꠁꠞꠦ ꠘꠤꠡꠦꠗ ꠘꠣ ꠖꠦꠁꠘ, ꠔꠦ ꠔꠣꠁ ꠁꠔꠣ ꠙꠥꠞꠘ ꠇꠞꠣ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","ꠅꠁꠟꠦ ꠎꠣꠝꠣꠁꠄ ꠢꠥꠘꠤꠀ ꠎꠥꠖꠤ ꠟꠉꠦ ꠟꠉꠦ ꠘꠤꠡꠦꠗ ꠖꠦꠁꠘ, ꠔꠦ ꠁ ꠝꠣꠘ꠆ꠘꠔ ꠛꠣ ꠅꠀꠖꠣ ꠛꠣꠔꠤꠟ ꠅꠁꠎꠤꠛ। ꠔꠣꠁꠞ ꠎꠣꠝꠣꠁꠄ ꠘꠤꠡꠦꠗ ꠇꠞꠣꠄ, ꠝꠣꠛꠥꠖꠦꠅ ꠁꠈꠣꠘ ꠝꠣꠚ ꠇꠞꠤ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","ꠛꠃꠄ ꠇꠍꠝ ꠈꠣꠁꠀ ꠅꠀꠖꠣ ꠇꠞꠟꠦ ꠛꠣ ꠇꠥꠘꠥ ꠝꠣꠘ꠆ꠘꠔ ꠝꠣꠘꠟꠦ ꠎꠣꠝꠣꠁꠞ ꠄꠈꠔꠤꠀꠞ ꠀꠍꠦ ꠁꠔꠣ ꠝꠣꠘꠣ ꠛꠣ ꠛꠣꠔꠤꠟ ꠇꠞꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","ꠅꠁꠟꠦ ꠎꠣꠝꠣꠁꠄ ꠎꠥꠖꠤ ꠛꠦꠡꠤ ꠖꠤꠘ ꠁ ꠛꠦꠙꠣꠞꠦ ꠇꠥꠘ꠆ꠔꠣ ꠘꠣ ꠝꠣꠔꠤꠀ ꠘꠤꠞꠣꠁ ꠞꠂꠘ, ꠔꠦ ꠔꠣꠞ ꠛꠃꠞ ꠝꠣꠘ꠆ꠘꠔ ꠛꠣ ꠅꠀꠖꠣꠞ ꠛꠣꠘ꠆ꠖꠘ ꠙꠣꠇ꠆ꠇꠣ ꠅꠁꠎꠣꠄ। ꠢꠇꠟꠔꠣ ꠢꠥꠘꠣꠞ ꠛꠣꠖꠦꠅ ꠎꠣꠝꠣꠁ ꠅꠃ ꠡꠝꠄ ꠘꠤꠞꠣꠁ ꠞꠅꠀꠄ ꠛꠃꠞ ꠝꠣꠘ꠆ꠘꠔ ꠛꠣ ꠅꠀꠖꠣꠞꠦ ꠙꠣꠇ꠆ꠇꠣ ꠛꠣꠘꠣꠁꠟꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","ꠅꠁꠟꠦ ꠢꠇꠟꠔꠣ ꠢꠥꠘꠣꠞ ꠛꠣꠖꠦ ꠎꠣꠝꠣꠁꠄ ꠎꠥꠖꠤ ꠢꠃ ꠖꠤꠘꠞ ꠝꠣꠎꠦ ꠇꠥꠘ꠆ꠔꠣ ꠘꠣ ꠝꠣꠔꠤꠀ ꠡꠝꠄ ꠙꠣꠞꠘꠤꠞ ꠛꠣꠖꠦ ꠘꠤꠡꠦꠗ ꠇꠞꠦ, ꠔꠦ ꠛꠃꠄ ꠅꠃ ꠝꠣꠘ꠆ꠘꠔ ꠙꠥꠞꠣ ꠘꠣ ꠇꠞꠣꠄ ꠄꠞ ꠖꠣꠄ-ꠜꠣꠞ ꠔꠣꠁꠞ ꠎꠣꠝꠣꠁꠞ ꠃꠙꠞꠦ ꠙꠠꠛ।” ");
INSERT INTO syls_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","ꠎꠣꠝꠣꠁ-ꠛꠃꠞ ꠛꠦꠙꠣꠞꠦ, ꠛꠣꠚ ꠀꠞ ꠛꠣꠚꠞ ꠛꠣꠠꠤꠔ ꠞꠅꠞꠣ ꠙꠥꠠꠤꠞ ꠛꠦꠙꠣꠞꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠅꠟꠣ ꠀꠁꠘ ꠢꠤꠇꠣꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“ꠝꠣꠖꠤꠀꠘꠤ ꠅꠇꠟꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠉꠦ ꠎꠦꠔꠣ ꠇꠞꠍꠦ, ꠔꠥꠝꠤ ꠅꠔꠣꠞ ꠅꠙꠞꠣꠗꠞ ꠛꠖꠟꠣ ꠖꠦꠅ। ꠄꠞꠛꠣꠖꠦ ꠔꠥꠝꠤ ꠔꠥꠝꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠉꠦꠍꠦ ꠌꠤꠞꠇꠣꠟꠞ ꠟꠣꠉꠤ ꠢꠥꠔꠤ ꠞꠁꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","ꠔꠦꠃ ꠝꠥꠍꠣꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠁꠟꠣ, “ꠝꠣꠖꠤꠀꠘꠤ ꠅꠇꠟꠞ ꠟꠉꠦ ꠎꠥꠖ꠆ꠖ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠞꠣꠞ ꠇꠤꠍꠥ ꠍꠤꠙꠣꠁꠞꠦ ꠎꠥꠁꠔ ꠇꠞꠅ, ꠔꠣꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠔꠞꠚ ꠕꠣꠇꠤ ꠝꠣꠖꠤꠀꠘꠤ ꠅꠇꠟꠞ ꠙꠣꠅꠘꠣ ꠡꠣꠎꠣ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","ꠅꠈꠘ ꠔꠥꠝꠞꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠙꠞꠔꠦꠇ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠣꠇꠤ ꠄꠇ ꠀꠎꠣꠞ ꠇꠞꠤ ꠍꠤꠙꠣꠁꠞꠦ ꠎꠥꠖ꠆ꠖꠔ ꠙꠣꠑꠣꠅ।” ");
INSERT INTO syls_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","ꠔꠦꠃ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠛꠣꠞꠅ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠣꠇꠤ ꠄꠇꠅ ꠀꠎꠣꠞ ꠇꠞꠤ ꠝꠥꠐ ꠛꠣꠞꠅ ꠀꠎꠣꠞ ꠍꠤꠙꠣꠁꠞꠦ ꠎꠥꠖ꠆ꠖꠞ ꠟꠣꠉꠤ ꠎꠥꠁꠔ ꠇꠞꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","ꠝꠥꠍꠣꠄ ꠙꠞꠔꠦꠇ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠣꠇꠤ ꠄꠇ ꠀꠎꠣꠞ ꠎꠘ ꠍꠤꠙꠣꠁꠞꠦ ꠎꠥꠖ꠆ꠖꠔ ꠙꠣꠑꠣꠁꠟꠣ। ꠄꠞꠣꠞ ꠟꠉꠦ ꠁꠝꠣꠝ ꠀꠟꠤ-ꠀꠎꠞꠞ ꠙꠥꠀ ꠙꠤꠘꠢꠡꠅ ꠉꠦꠟꠣ, ꠎꠣꠁꠔꠦ ꠙꠛꠤꠔ꠆ꠞ ꠇꠣꠛꠣ ꠊꠞꠞ ꠇꠤꠍꠥ ꠍꠣꠝꠣꠘꠣ ꠟꠉꠦ ꠇꠞꠤ ꠘꠤꠟꠣ ꠀꠞ ꠔꠣꠘ ꠀꠔꠅ ꠇꠞꠤ ꠎꠥꠖ꠆ꠖꠞ ꠀꠅꠀꠎꠞ ꠌꠥꠋꠉꠣ ꠅꠇꠟꠅ ꠘꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠖꠦꠅꠀ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠔꠣꠞꠣ ꠝꠣꠖꠤꠀꠘꠤ ꠅꠇꠟꠞ ꠟꠉꠦ ꠎꠥꠖ꠆ꠖ ꠇꠞꠤꠀ ꠅꠔꠣꠞ ꠢꠇꠟ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠞꠦ ꠝꠣꠞꠤꠟꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","ꠡꠣꠗꠣꠞꠘ ꠝꠣꠘꠡꠞ ꠟꠉꠦ ꠝꠣꠖꠤꠀꠘꠤ ꠅꠇꠟꠞ ꠙꠣꠌ ꠎꠘ ꠛꠣꠖꠡꠣꠞꠦꠅ ꠔꠣꠞꠣ ꠝꠣꠞꠤꠟꠤꠟꠣ। ꠅꠃ ꠛꠣꠖꠡꠣꠁꠘ ꠅꠁꠟꠣ, ꠁꠛꠤ, ꠞꠦꠇꠝ, ꠡꠥꠞ, ꠢꠥꠞ ꠀꠞ ꠞꠦꠛꠣ। ꠀꠞ ꠄꠞꠣꠞ ꠟꠉꠦ ꠛꠣꠟꠣꠝ ꠛꠤꠘ ꠛꠣꠃꠞ ꠘꠣꠝꠞ ꠢꠃ ꠙꠤꠞꠞꠦꠅ ꠔꠣꠞꠣ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","ꠔꠣꠞꠣ ꠝꠣꠖꠤꠀꠘ ꠖꠦꠡꠞ ꠢꠇꠟ ꠛꠦꠐꠤꠘ ꠀꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘꠞꠦ ꠛꠘ꠆ꠖꠤ ꠇꠞꠟꠣ, ꠔꠣꠞꠣꠞ ꠉꠞꠥ-ꠍꠣꠉꠟ ꠀꠞ ꠢꠇ꠆ꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠟꠥꠐꠤꠀ ꠀꠘꠤꠟ꠆ꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","ꠝꠣꠖꠤꠀꠘꠤ ꠅꠇꠟ ꠎꠔ ꠐꠣꠃꠘꠅ ꠛꠡꠔ ꠇꠞꠔꠣ, ꠅꠃ ꠐꠣꠃꠘ ꠅꠇꠟ ꠀꠞ ꠐꠣꠃꠘꠞ ꠛꠣꠞꠞ ꠢꠇꠟ ꠔꠣꠝ꠆ꠛꠥ ꠔꠣꠞꠣ ꠀꠉꠥꠁꠘꠖꠤ ꠎꠣꠟꠣꠁꠟꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","ꠎꠥꠖ꠆ꠖꠞ ꠛꠣꠖꠦ ꠔꠣꠞꠣꠞ ꠛꠘ꠆ꠖꠤ ꠇꠞꠣ ꠢꠇꠟ ꠝꠣꠘꠥꠡ, ꠉꠘꠤꠝꠔꠞ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ, ꠀꠞ ꠙꠡꠥꠞ ꠙꠣꠟ ꠟꠁꠀ ꠞꠅꠀꠘꠣ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","ꠔꠣꠞꠣ ꠝꠥꠍꠣ ꠘꠛꠤ, ꠁꠝꠣꠝ ꠀꠟꠤ-ꠀꠎꠞ ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠇꠦꠝ꠆ꠙꠅ ꠚꠤꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣ। ꠅꠃ ꠡꠝꠄ ꠔꠣꠞꠣꠞ ꠔꠣꠝ꠆ꠛꠥ ꠀꠍꠤꠟ ꠎꠤꠞꠤꠢꠅ ꠄꠟꠣꠇꠣꠞ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠗꠣꠞꠅ ꠝꠥꠀꠛ ꠖꠦꠡꠞ ꠔꠟ ꠎꠣꠉꠣꠔ। ");
INSERT INTO syls_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","ꠔꠣꠞꠣꠞ ꠈꠛꠞ ꠙꠣꠁꠀ ꠝꠥꠍꠣ ꠘꠛꠤ, ꠁꠝꠣꠝ ꠀꠟꠤ-ꠀꠎꠞ ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠢꠇꠟ ꠝꠥꠞꠛ꠆ꠛꠤ ꠇꠦꠝ꠆ꠙ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁꠀ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠖꠦꠈꠣ ꠇꠞꠣꠔ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","ꠉꠤꠀ ꠎꠥꠖ꠆ꠖ ꠕꠣꠇꠤ ꠚꠤꠞꠔ ꠀꠅꠀ ꠢꠇꠟ ꠇꠣꠝꠣꠘ꠆ꠒꠣꠞꠞ ꠃꠙꠞꠦ ꠝꠣꠘꠤ ꠀꠎꠣꠞ ꠍꠤꠙꠣꠁꠞ ꠀꠞ ꠡ-ꠍꠤꠙꠣꠁꠞ ꠇꠣꠝꠣꠘ꠆ꠒꠣꠞ ꠅꠇꠟꠞ ꠃꠙꠞꠦ ꠝꠥꠍꠣꠄ ꠈꠥꠛ ꠉꠞꠝ ꠅꠁꠀ ");
INSERT INTO syls_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","ꠇꠁꠟꠣ, “ꠔꠥꠝꠞꠣ ꠖꠥꠡꠝꠘꠞ ꠢꠇꠟ ꠛꠦꠐꠤꠘ꠆ꠔꠞꠦ ꠎꠤꠘ꠆ꠖꠣ ꠞꠣꠈꠟꠣꠄ ꠇꠦꠘꠦ? ");
INSERT INTO syls_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","ꠝꠘꠅ ꠘꠣꠁ ꠘꠤ, ꠅꠉꠥꠁꠘ꠆ꠔꠦ ꠙꠤꠃꠞ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠛꠣꠟꠣꠝ ꠙꠤꠞꠞ ꠙꠞꠣꠝꠤꠡꠦ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠖꠥꠞꠁ ꠢꠞꠣꠁꠍꠤꠟ, ꠄꠞꠟꠣꠉꠤ ꠔ ꠝꠣꠛꠥꠖꠞ ꠛꠘ꠆ꠖꠣ ꠅꠇꠟꠞ ꠃꠙꠞꠦ ꠉꠎꠛꠤ ꠛꠦꠝꠣꠞ ꠘꠣꠎꠤꠟ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","ꠔꠦ ꠅꠈꠘ ꠔꠥꠝꠞꠣ ꠅꠔꠣꠞ ꠢꠇꠟ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠣꠅ, ꠛꠤꠀꠔꠤ ꠛꠣ ꠅꠡꠔꠤ ꠢꠇꠟ ꠛꠦꠐꠤꠘ꠆ꠔꠞꠦꠅ ꠝꠣꠞꠤꠟꠣꠅ। ");
INSERT INTO syls_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","ꠈꠣꠟꠤ ꠀꠛꠤꠀꠔꠤ ꠡꠔꠤ ꠙꠥꠠꠤꠘ꠆ꠔꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠎꠤꠔꠣ ꠞꠣꠈꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“ꠀꠞ ꠔꠥꠝꠞꠣ ꠎꠦꠞꠣ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠍ ꠛꠣ ꠝꠥꠞ꠆ꠖꠣꠞ ꠟꠣꠡ ꠍꠁꠍ, ꠔꠥꠝꠞꠣ ꠡꠣꠔꠖꠤꠘ ꠜꠞꠣ ꠇꠦꠝ꠆ꠙꠞ ꠛꠣꠞꠦ ꠞꠁꠅ। ꠄꠞꠝꠣꠎꠦ ꠔꠤꠘ ꠘꠝ꠆ꠛꠞ ꠀꠞ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠘꠤꠎꠦ ꠀꠞ ꠛꠘ꠆ꠖꠤ ꠇꠞꠤ ꠀꠘꠣ ꠝꠣꠘꠡꠞꠦꠅ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","ꠔꠥꠝꠞꠣꠞ ꠢꠇꠟ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ, ꠌꠣꠝꠠꠣꠞ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ, ꠟꠣꠇꠠꠤ ꠀꠞ ꠍꠣꠉꠟꠞ ꠞꠥꠝꠣꠖꠤ ꠛꠣꠘꠣꠁꠟ ꠢꠇ꠆ꠇꠟ ꠍꠣꠝꠣꠘꠞꠦꠅ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠞꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","ꠎꠦꠔꠣ ꠍꠤꠙꠣꠁ ꠅꠇꠟ ꠎꠥꠖ꠆ꠖꠔ ꠉꠦꠍꠟꠣ, ꠁꠝꠣꠝ ꠀꠟꠤ-ꠀꠎꠞꠦ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠁꠔꠣ ꠅꠁꠟ ꠝꠥꠍꠣ ꠘꠛꠤꠞ ꠀꠔꠦ ꠖꠦꠅꠀ ꠝꠣꠛꠥꠖꠞ ꠡꠞꠤꠅꠔꠞ ꠄꠇꠈꠣꠘ ꠀꠁꠘ: ");
INSERT INTO syls_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","ꠔꠥꠝꠞꠣ ꠡꠥꠘꠣ, ꠞꠥꠙꠣ, ꠙꠤꠔꠟ, ꠟꠥꠀ, ꠐꠤꠘ, ꠡꠤꠡꠣꠖꠤ ꠛꠣꠘꠣꠁꠟ ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ, ");
INSERT INTO syls_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","ꠝꠣꠘꠤ ꠎꠦꠔꠣ ꠝꠣꠟ ꠀꠉꠥꠘꠤꠔ ꠖꠤꠟꠦ ꠎꠟꠦ ꠘꠣ, ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠀꠉꠥꠘꠤꠞ ꠝꠣꠎꠦ ꠖꠤꠛꠣꠄ, ꠔꠦꠃ ꠁꠔꠣ ꠙꠣꠇ-ꠍꠣꠚ ꠅꠁꠛ। ꠅꠁꠟꠦ ꠎꠣꠟꠣꠘꠤꠞ ꠛꠣꠖꠦ ꠁꠔꠣꠞꠦ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠞꠣꠞ ꠙꠣꠘꠤꠖꠤ ꠗꠁꠀ ꠙꠣꠇ-ꠙꠣꠇꠤꠎꠣ ꠇꠞꠣ ꠟꠣꠉꠛ। ꠀꠞ ꠎꠦꠔꠣ ꠀꠉꠥꠁꠘꠦ ꠘꠡ꠆ꠐ ꠅꠁꠎꠣꠄ, ꠁꠔꠣꠞꠦ ꠈꠣꠟꠤ ꠙꠣꠇ-ꠍꠣꠚ ꠇꠞꠣꠞ ꠙꠣꠘꠤꠖꠤ ꠗꠁꠟꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","ꠛꠣꠖꠦ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠔꠥꠝꠞꠣꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠗꠁꠀ ꠢꠣꠞꠟꠦ, ꠙꠣꠇ-ꠙꠣꠇꠤꠎꠣ ꠛꠘꠤꠀ ꠇꠦꠝ꠆ꠙꠞ ꠜꠤꠔꠞꠦ ꠢꠣꠝꠣꠁꠛꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“ꠔꠥꠝꠤ ꠀꠞ ꠁꠝꠣꠝ ꠀꠟꠤ-ꠀꠎꠞ ꠀꠞ ꠡꠝꠣꠎꠞ ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟꠦ ꠝꠤꠟꠤꠀ, ꠛꠘ꠆ꠖꠤ ꠇꠞꠤ ꠀꠘꠣ ꠢꠇꠟ ꠝꠣꠘꠥꠡ ꠀꠞ ꠙꠡꠥꠁꠘ꠆ꠔꠞꠦ ꠉꠘꠅ। ");
INSERT INTO syls_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","ꠉꠘꠤꠀ ꠢꠇꠟ ꠝꠣꠟ ꠖꠥꠁ ꠛꠣꠐ ꠇꠞꠅ। ꠁꠔꠣꠞ ꠄꠇ ꠛꠣꠐ ꠖꠤꠛꠣꠄ ꠎꠥꠖ꠆ꠖꠔ ꠎꠦꠔꠣ ꠍꠤꠙꠣꠁ ꠅꠇꠟ ꠉꠦꠍꠤꠟ ꠔꠣꠞꠣꠞꠦ, ꠀꠞ ꠖꠥꠍꠞꠣ ꠛꠣꠐ ꠛꠣꠖ-ꠛꠣꠇꠤ ꠝꠣꠘꠡꠞꠦ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","ꠅꠃ ꠍꠤꠙꠣꠁ ꠅꠇꠟꠞ ꠛꠣꠐꠅ ꠎꠔ ꠝꠣꠘꠥꠡ, ꠉꠞꠥ-ꠍꠣꠉꠟ ꠙꠠꠛ, ꠁꠔꠣꠞ ꠙꠞꠔꠦꠇ ꠙꠣꠌ-ꠡꠐꠣ ꠕꠣꠇꠤ ꠄꠇꠐꠣꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠟꠣꠉꠤ ꠀꠟꠉꠣꠁ ꠕꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","ꠀꠟꠉꠣꠁꠀ ꠝꠣꠛꠥꠖꠞ ꠙꠣꠅꠘꠣ ꠅꠃ ꠛꠣꠐꠞꠦ ꠔꠥꠝꠤ ꠁꠝꠣꠝ ꠀꠟꠤ-ꠀꠎꠞꠞ ꠀꠔꠅ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠛꠣꠐꠅ ꠎꠦꠔꠣ ꠝꠣꠘꠥꠡ, ꠉꠞꠥ-ꠍꠣꠉꠟ ꠙꠣꠁꠛꠣ, ꠁꠔꠣꠞ ꠙꠞꠔꠦꠇ ꠙꠁꠘ꠆ꠌꠣꠡꠐꠣ ꠕꠣꠇꠤ ꠄꠇꠐꠣꠞꠦ ꠀꠟꠉ ꠇꠞꠤ ꠕꠁꠅ। ꠕꠁꠀ ꠀꠟ꠆ꠟꠣꠞ ꠛꠡꠔ ꠈꠣꠘꠣ, ꠛꠣꠄꠔꠥꠟ꠆ꠟꠣ ꠔꠣꠝ꠆ꠛꠥꠞ ꠈꠣꠖꠤꠝ ꠟꠦꠛꠤ ꠅꠇꠟꠞ ꠀꠔꠅ ꠁꠔꠣ ꠡꠝꠎꠣꠁꠅ।” ");
INSERT INTO syls_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠔꠣꠁꠘ ꠀꠞ ꠁꠝꠣꠝ ꠀꠟꠤ-ꠀꠎꠞꠦ ꠅꠟꠣꠃ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","ꠍꠤꠙꠣꠁ ꠅꠇꠟꠦ ꠎꠤꠔꠤꠀ ꠀꠘꠣ ꠉꠘꠤꠝꠔꠞ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠍꠣꠠꠣꠅ ꠀꠞꠅ ꠀꠍꠤꠟ, ꠍꠄ ꠟꠣꠈ ꠙꠌꠔ꠆ꠔꠁꠞ ꠀꠎꠣꠞ ꠝꠦꠠꠣ ꠀꠞ ꠍꠣꠉꠟ, ");
INSERT INTO syls_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","ꠛꠣꠅꠔ꠆ꠔꠁꠞ ꠀꠎꠣꠞ ꠉꠞꠥ, ");
INSERT INTO syls_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","ꠄꠇꠡꠐ꠆ꠐꠤ ꠀꠎꠣꠞ ꠉꠣꠗꠣ ");
INSERT INTO syls_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","ꠀꠞ ꠛꠔ꠆ꠔꠤꠡ ꠀꠎꠣꠞ ꠀꠛꠤꠀꠔꠤ ꠡꠔꠤ ꠙꠥꠠꠤꠘ। ");
INSERT INTO syls_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","ꠔꠦꠃ ꠎꠥꠖ꠆ꠖ ꠇꠞꠞꠣ ꠍꠤꠙꠣꠁ ꠅꠇꠟꠞ ꠛꠣꠐꠅ ꠙꠠꠟ, ꠔꠤꠘ ꠟꠣꠈ ꠡꠣꠠꠔꠤꠡ ꠀꠎꠣꠞ ꠙꠣꠌ-ꠡꠐꠣ ꠝꠦꠠꠣ ꠀꠞ ꠍꠣꠉꠟ, ");
INSERT INTO syls_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ꠁꠔꠣ ꠕꠣꠇꠤ ꠝꠣꠛꠥꠖꠞ ꠙꠣꠅꠘꠣ ꠛꠣꠐꠅ ꠙꠠꠟ, ꠍꠄ-ꠡ ꠙꠌꠔ꠆ꠔꠁꠞꠉꠥ ꠍꠣꠉꠟ-ꠝꠦꠠꠣ। ");
INSERT INTO syls_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","ꠀꠞ ꠉꠞꠥ ꠀꠍꠤꠟ ꠍꠄꠔꠤꠡ ꠀꠎꠣꠞ, ꠁꠔꠣ ꠕꠣꠇꠤ ꠝꠣꠛꠥꠖꠞ ꠛꠣꠐꠅ ꠙꠠꠟ ꠛꠣꠅꠔ꠆ꠔꠁꠞꠐꠣ। ");
INSERT INTO syls_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","ꠄꠞꠝꠣꠎꠦ ꠉꠣꠗꠣ ꠀꠍꠤꠟ ꠔꠤꠡ ꠀꠎꠣꠞ ꠙꠣꠌ-ꠡꠐꠣ, ꠁꠔꠣ ꠕꠣꠇꠤ ꠝꠣꠛꠥꠖꠞ ꠛꠣꠐꠅ ꠙꠠꠟ ꠄꠇꠡꠐ꠆ꠐꠤꠉꠥ। ");
INSERT INTO syls_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","ꠀꠞ ꠀꠛꠤꠀꠔꠤ ꠡꠔꠤ ꠙꠥꠠꠤꠘ ꠀꠍꠟꠣ ꠡꠥꠟ꠆ꠟ ꠀꠎꠣꠞ, ꠁꠔꠣ ꠕꠣꠇꠤ ꠝꠣꠛꠥꠖꠞ ꠛꠣꠐꠅ ꠙꠠꠟ ꠛꠔ꠆ꠔꠤꠡꠐꠣ। ");
INSERT INTO syls_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠔꠣꠁꠘ ꠝꠣꠛꠥꠖꠞ ꠙꠣꠅꠘꠣ ꠛꠣꠐ ꠘꠤꠀ ꠁꠝꠣꠝ ꠀꠟꠤ-ꠀꠎꠞꠞ ꠀꠔꠅ ꠅꠟꠣ ꠡꠝꠎꠣꠁ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","ꠀꠞ ꠝꠥꠍꠣꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠛꠣꠖ-ꠛꠣꠇꠤ ꠝꠣꠘꠡꠞ ꠟꠣꠉꠤ ꠎꠦ ꠛꠣꠐ ꠍꠤꠙꠣꠁ ꠅꠇꠟꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠘꠤꠍꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","ꠁ ꠛꠣꠐꠅ ꠔꠤꠘ ꠟꠣꠈ ꠡꠣꠠꠔꠤꠡ ꠀꠎꠣꠞ ꠙꠣꠌ-ꠡꠉꠥ ꠝꠦꠠꠣ ꠀꠞ ꠍꠣꠉꠟ, ");
INSERT INTO syls_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","ꠍꠄꠔꠤꠡ ꠀꠎꠣꠞ ꠉꠞꠥ, ");
INSERT INTO syls_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","ꠔꠤꠡ ꠀꠎꠣꠞ ꠙꠣꠌ-ꠡꠐꠣ ꠉꠣꠗꠣ, ");
INSERT INTO syls_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","ꠀꠞ ꠡꠥꠟ꠆ꠟ ꠀꠎꠣꠞ ꠀꠛꠤꠀꠔꠤ ꠡꠔꠤ ꠙꠥꠠꠤꠘ ꠀꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠙꠣꠅꠀ ꠛꠣꠐꠞ, ꠙꠞꠔꠦꠇ ꠙꠁꠘ꠆ꠌꠣꠡ ꠎꠘ ꠀꠛꠤꠀꠔꠤ ꠙꠥꠠꠤꠘ ꠀꠞ ꠙꠡꠥꠁꠘ ꠕꠣꠇꠤꠅ, ꠄꠉꠥ ꠇꠞꠤ ꠙꠥꠠꠤ ꠀꠞ ꠙꠡꠥ ꠘꠤꠀ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠡꠞꠦ ꠖꠤꠟꠣ, ꠎꠦꠞꠣꠞ ꠃꠙꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠇꠣꠛꠣ ꠊꠞꠞ ꠖꠦꠈꠣ-ꠢꠥꠘꠣꠞ ꠎꠤꠝ꠆ꠝꠣꠖꠣꠞꠤ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","ꠄꠞꠛꠣꠖꠦ ꠍꠤꠙꠣꠁ ꠖꠟꠞ ꠀꠎꠣꠞ ꠍꠤꠙꠣꠁꠞ ꠀꠞ ꠡ-ꠍꠤꠙꠣꠁꠞ ꠇꠣꠝꠣꠘ꠆ꠒꠣꠞ ꠅꠇꠟ ꠝꠥꠍꠣꠞ ꠉꠦꠍꠦ ꠀꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","ꠀꠁꠀ ꠇꠁꠟꠣ, “ꠀꠙꠘꠣꠞ ꠁ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠦ ꠀꠝꠞꠣꠞ ꠎꠤꠝ꠆ꠝꠣꠄ ꠕꠣꠇꠣ ꠍꠤꠙꠣꠁ ꠅꠇꠟꠞꠦ ꠉꠘꠤꠟꠣꠝ। ꠉꠘꠤꠀ ꠖꠦꠈꠟꠣꠝ, ꠔꠣꠞꠣ ꠢꠇꠟ ꠙꠥꠞꠣ ꠀꠍꠂꠘ, ꠎꠥꠖ꠆ꠖꠔ ꠇꠦꠃ ꠝꠞꠍꠦ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","ꠄꠞꠟꠣꠉꠤ ꠀꠝꠞꠣ ꠙꠞꠔꠦꠇꠞ ꠛꠣꠐꠅ ꠎꠦꠔꠣ ꠡꠥꠘꠣꠞ ꠛꠣꠎꠥ, ꠛꠣꠟꠣ, ꠀꠔꠞ ꠀꠋꠐꠤ, ꠇꠣꠘꠞ ꠖꠥꠟ ꠀꠞ ꠉꠟꠣꠞ ꠢꠣꠞ ꠙꠣꠁꠍꠤ, ꠀꠝꠞꠣ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠟꠁꠀ ꠀꠁꠍꠤ। ꠀꠝꠞꠣꠞ ꠎꠣꠘꠞ ꠇꠚꠞꠣꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠢꠤꠡꠣꠛꠦ ꠅꠔꠣ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠖꠤꠟꠣꠁꠔꠣꠝ।” ");
INSERT INTO syls_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","ꠔꠦꠃ ꠝꠥꠍꠣ ꠀꠞ ꠁꠝꠣꠝ ꠀꠟꠤ-ꠀꠎꠞꠦ ꠔꠣꠞꠣꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠡꠥꠘꠣꠞ ꠢꠇꠟ ꠉꠄꠘꠣ ꠡꠝꠎꠤꠀ ꠙꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","ꠔꠣꠞꠣ ꠀꠎꠣꠞ ꠍꠤꠙꠣꠁꠞ ꠀꠞ ꠡ-ꠍꠤꠙꠣꠁꠞ ꠇꠣꠝꠣꠘ꠆ꠒꠣꠞ ꠅꠇꠟꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠖꠦꠅꠀ ꠎꠦ ꠡꠥꠘꠣꠞ ꠉꠄꠘꠣ ꠡꠝꠎꠤꠀ ꠙꠣꠁꠟꠣ, ꠁꠔꠣꠞ ꠃꠎꠘ ꠀꠍꠤꠟ ꠡꠥꠟ꠆ꠟ ꠀꠎꠣꠞ ꠡꠣꠔ-ꠡ ꠙꠁꠘ꠆ꠌꠣꠡ ꠔꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","54","ꠝꠥꠍꠣ ꠘꠛꠤ ꠀꠞ ꠁꠝꠣꠝ ꠀꠟꠤ-ꠀꠎꠞꠦ ꠀꠎꠣꠞ ꠍꠤꠙꠣꠁ ꠀꠞ ꠡ-ꠍꠤꠙꠣꠁꠞ ꠇꠣꠝꠣꠘ꠆ꠒꠣꠞ ꠅꠇꠟꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠅꠃ ꠡꠥꠘꠣ ꠅꠇꠟ ꠡꠝꠎꠤꠀ ꠞꠣꠈꠟꠣ। ꠞꠣꠈꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠍꠣꠝꠘꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠁꠀꠖꠉꠣꠞꠤꠞ ꠘꠤꠡꠣꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠅꠔꠣ ꠡꠥꠘꠣ ꠅꠇꠟ ꠇꠣꠛꠣ ꠊꠞꠞ ꠜꠤꠔꠞꠦ ꠕꠁꠟꠣ। ꠁꠔꠣ ꠍꠣꠠꠣꠅ ꠍꠤꠙꠣꠁ ꠅꠇꠟꠦ ꠉꠘꠤꠝꠔꠞ ꠀꠞꠅ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠎꠣꠞꠎꠤꠞ ꠉꠦꠍꠦ ꠞꠣꠈꠍꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","ꠞꠥꠛꠦꠘ ꠀꠞ ꠍꠣꠖꠥ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠡꠞ ꠉꠞꠥ-ꠍꠣꠉꠟꠞ ꠛꠠ ꠛꠠ ꠙꠣꠟ ꠀꠍꠤꠟ। ꠔꠣꠞꠣ ꠖꠦꠈꠟꠣ, ꠎꠣꠎꠤꠞꠣ ꠀꠞ ꠉꠤꠟꠤꠅꠖ ꠄꠟꠣꠇꠣ ꠙꠡꠥ ꠙꠣꠟꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠈꠥꠛ ꠜꠣꠟꠣ ꠎꠣꠉꠣ। ");
INSERT INTO syls_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","ꠔꠦꠃ ꠔꠣꠞꠣ ꠝꠥꠍꠣ ꠘꠛꠤ, ꠁꠝꠣꠝ ꠀꠟꠤ-ꠀꠎꠞ ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠙꠞꠗꠣꠘ ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","“ꠀꠙꠘꠣꠁꠘ꠆ꠔꠞ ꠁ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠦ ꠔ ꠉꠞꠥ-ꠍꠣꠉꠟ ꠙꠣꠟꠤ। ꠀꠞ ꠀꠝꠞꠣꠞ ꠝꠣꠛꠥꠖꠦ ꠅꠐꠣꠞꠥꠔ, ꠖꠤꠛꠣꠘ, ꠎꠣꠎꠤꠞꠣ, ꠘꠤꠝ꠆ꠞꠣ, ꠢꠤꠡꠛꠘ, ꠁꠟꠤꠀꠟꠤ, ꠍꠦꠛꠣꠝ, ꠘꠛꠅ ꠀꠞ ꠛꠤꠃꠘ ꠘꠣꠝꠞ ꠎꠦꠔꠣ ꠎꠣꠉꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠖꠈꠟꠅ ꠀꠘꠍꠂꠘ, ꠁꠔꠣ ꠔ ꠙꠡꠥ ꠙꠣꠟꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠈꠥꠛ ꠜꠣꠟꠣ ꠎꠣꠉꠣ। ");
INSERT INTO syls_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","ꠅꠈꠘ ꠀꠙꠘꠦ ꠎꠥꠖꠤ ꠀꠝꠞꠣꠞꠦ ꠖꠄꠀ ꠇꠞꠂꠘ, ꠔꠦ ꠅꠃ ꠎꠣꠉꠣ ꠈꠣꠘꠣꠁꠘ ꠀꠙꠘꠣꠞ ꠁ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠞꠦ ꠖꠤꠟꠣꠃꠇ꠆ꠇꠣ। ꠀꠝꠞꠣꠞꠦ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠢꠤꠙꠣꠞꠅ ꠘꠦꠁꠘ ꠘꠣ ꠎꠣꠘꠥ।” ");
INSERT INTO syls_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠔꠣꠞꠣꠞꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, “ꠔꠥꠝꠞꠣꠞ ꠜꠣꠁꠀꠁꠘ ꠎꠥꠖ꠆ꠖ ꠇꠞꠣꠔ ꠎꠣꠁꠛꠣ, ꠀꠞ ꠔꠥꠝꠞꠣ ꠅꠘꠅ ꠛꠁ ꠞꠁꠛꠣꠄ ꠘꠤ? ");
INSERT INTO syls_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","ꠝꠣꠛꠥꠖꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠦ ꠎꠣꠉꠣ ꠈꠣꠘꠣꠁꠘ ꠖꠤꠍꠂꠘ, ꠢꠤꠘꠅ ꠎꠣꠁꠔꠦ ꠔꠥꠝꠞꠣ ꠇꠦꠘꠦ ꠔꠣꠞꠣꠞ ꠝꠘꠅꠛꠟ ꠜꠣꠋꠉꠤ ꠖꠤꠞꠣꠄ? ");
INSERT INTO syls_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","ꠢꠥꠘꠅ, ꠀꠉꠦ ꠎꠦꠛꠟꠣ ꠅꠃ ꠖꠦꠡ ꠖꠦꠈꠣꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠁꠘꠞꠦ ꠀꠝꠤ ꠇꠣꠖꠦꠡ-ꠛꠞꠘꠦꠀ ꠕꠣꠇꠤ ꠙꠣꠑꠣꠁꠍꠟꠣꠝ, ꠢꠃ ꠡꠝꠄ ꠔꠣꠞꠣꠅ ꠅꠟꠣ ꠇꠞꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","ꠔꠣꠞꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠣꠉꠤ ꠝꠣꠛꠥꠖꠞ ꠖꠣꠘ ꠇꠞꠣ ꠖꠦꠡ ꠖꠦꠈꠣꠔ ꠉꠦꠍꠤꠟ, ꠉꠤꠀ ꠀꠡꠇꠥꠟꠞ ꠙꠣꠠꠤꠀ ꠈꠣꠟ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠖꠦꠈꠍꠤꠟ, ꠖꠦꠈꠤꠀ ꠀꠁꠀ ꠢꠃ ꠖꠦꠡꠅ ꠎꠣꠁꠔꠦ ꠄꠞꠣꠞ ꠝꠘꠅꠛꠟ ꠜꠣꠋꠉꠤ ꠖꠤꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","ꠄꠞꠟꠣꠉꠤ ꠢꠃ ꠖꠤꠘ ꠉꠥꠍꠣꠄ ꠀꠉꠥꠁꠘ ꠅꠁꠀ ꠝꠣꠛꠥꠖꠦ ꠇꠍꠝ ꠈꠣꠁꠀ ꠇꠁꠍꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠎꠦ ꠖꠦꠡ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠁꠛ꠆ꠞꠣꠢꠤꠝ, ꠁꠍꠢꠣꠇ ꠀꠞ ꠁꠀꠇꠥꠛꠞ ꠉꠦꠍꠦ ꠇꠍꠝ ꠈꠣꠁꠍꠟꠣꠝ, ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁꠀ ꠀꠅꠀ ꠝꠣꠘꠡꠞ ꠝꠣꠎꠦ ꠛꠤꠡ ꠛꠍꠞ ꠛꠣ ꠄꠞ ꠛꠦꠡꠤ ꠛꠄꠅꠡꠤ ꠇꠥꠘꠥ ꠎꠘꠦ ꠁ ꠖꠦꠡ ꠖꠦꠈꠣꠞ ꠡꠥꠎꠥꠉ ꠙꠣꠁꠔꠣ ꠘꠣꠄ, ꠇꠦꠘꠦꠘꠣ ꠔꠣꠞꠣ ꠀꠝꠣꠞ ꠇꠕꠣ ꠙꠥꠞꠣꠙꠥꠞ ꠡꠥꠟ꠆ꠟꠀꠘꠣ ꠝꠣꠘꠍꠦ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","ꠈꠣꠟꠤ ꠇꠘꠤꠎꠤ ꠎꠤꠚꠥꠘ꠆ꠘꠤꠞ ꠙꠥꠀ ꠇꠣꠟꠥꠔ ꠀꠞ ꠘꠥꠘꠞ ꠙꠥꠔ ꠁꠃꠍꠣꠄ ꠅꠃ ꠖꠦꠡ ꠖꠦꠈꠣꠞ ꠡꠥꠎꠥꠉ ꠙꠣꠁꠛꠣ। ꠔꠣꠞꠣ ꠔ ꠀꠝꠣꠞ ꠇꠕꠣꠞꠦ ꠡꠥꠟ꠆ꠟꠀꠘꠣ ꠝꠣꠘꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","ꠢꠃ ꠡꠝꠄ ꠝꠣꠛꠥꠖꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠃꠙꠞꠦ ꠉꠥꠍꠣꠄ ꠀꠉꠥꠁꠘ ꠅꠁꠉꠦꠍꠟꠣ, ꠄꠞꠟꠣꠉꠤ ꠔꠣꠘ ꠘꠎꠞꠅ ꠘꠣꠚꠞꠝꠣꠘꠤ ꠇꠞꠞꠣ ꠅꠔꠣ ꠝꠣꠘꠡꠞ ꠛꠤꠘꠣꠡ ꠘꠣ ꠅꠀ ꠙꠞ꠆ꠎꠘ꠆ꠔ, ꠌꠣꠟ꠆ꠟꠤꠡ ꠛꠍꠞ ꠗꠞꠤ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠘꠣꠘꠣꠘ ꠎꠣꠉꠣꠔ ꠁꠔꠣꠞꠦ ꠌꠇ꠆ꠇꠞ ꠖꠦꠅꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“ꠀꠞ ꠢꠃ ꠉꠥꠘꠣꠉꠣꠞ ꠅꠇꠟꠞ ꠀꠅꠟꠣꠖ ꠅꠀꠄ, ꠅꠈꠘ ꠔꠥꠝꠞꠣꠅ ꠎꠣꠞꠎꠤꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠈꠣꠁꠍꠟꠔ ꠙꠣꠁꠍ, ꠄꠞꠟꠣꠉꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠃꠙꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠉꠥꠍꠣꠞ ꠀꠉꠥꠁꠘꠞꠦ ꠀꠞꠅ ꠛꠣꠠꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","ꠅꠈꠘ ꠔꠥꠝꠞꠣ ꠎꠥꠖꠤ ꠔꠣꠘ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠘꠣ ꠌꠟꠅ, ꠔꠦ ꠔꠣꠁꠘ ꠢꠤꠞꠛꠣꠞ ꠅꠔꠣ ꠝꠣꠘꠡꠞꠦ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠚꠣꠟꠣꠁ ꠕꠁꠛꠣ, ꠔꠣꠘ ꠁ ꠟꠣꠘ꠆ꠘꠔꠞ ꠇꠣꠞꠘ ꠅꠁꠛꠣꠄ ꠔꠥꠝꠞꠣꠃ।” ");
INSERT INTO syls_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","ꠁꠔꠣ ꠢꠥꠘꠤꠀ ꠔꠣꠞꠣ ꠝꠥꠍꠣꠞ ꠗꠣꠞꠅ ꠜꠤꠠꠤꠀ ꠇꠁꠟꠣ, “ꠍꠣꠛ, ꠀꠝꠞꠣ ꠔ ꠈꠣꠟꠤ ꠙꠡꠥꠞ ꠙꠣꠟ ꠞꠣꠈꠣꠞ ꠎꠣꠉꠣ ꠛꠣꠘꠣꠘꠤ ꠀꠞ ꠀꠝꠞꠣꠞ ꠛꠃ-ꠛꠣꠁꠌ꠆ꠌꠣꠞꠦ ꠕꠅꠀꠞ ꠟꠣꠉꠤ ꠅꠘꠅ ꠐꠣꠃꠘ ꠅꠇꠟ ꠛꠣꠘꠣꠘꠤꠞ ꠁꠎꠣꠎꠔ ꠌꠣꠁꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","ꠅꠁꠟꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠘꠤꠎꠞ ꠎꠣꠉꠣꠔ ꠘꠣ ꠙꠃꠍꠣꠘꠤ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠀꠝꠞꠣ ꠎꠥꠖ꠆ꠖꠞ ꠍꠤꠙꠣꠁꠞ ꠟꠣꠈꠣꠘ ꠔꠣꠞꠣꠞ ꠀꠉꠦ ꠀꠉꠦ ꠎꠣꠁꠝꠥ। ꠄꠞꠝꠣꠎꠦ ꠀꠝꠞꠣꠞ ꠛꠃ-ꠛꠣꠁꠌ꠆ꠌꠣꠁꠘ ꠛꠣꠃꠘ꠆ꠒꠞꠤ ꠇꠞꠣ ꠅꠃ ꠐꠣꠃꠘꠅ ꠞꠁꠟꠦ, ꠅꠔꠣ ꠖꠦꠡꠞ ꠝꠣꠘꠡꠞ ꠀꠔ ꠕꠣꠇꠤ ꠔꠣꠞꠣ ꠘꠤꠞꠣꠙꠖꠦ ꠞꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","ꠢꠇ꠆ꠇꠟ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠞꠎꠤꠞ ꠎꠝꠤ-ꠝꠤꠞꠣꠡ ꠘꠣ ꠡꠝꠎꠣꠘꠤ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠀꠝꠞꠣ ꠘꠤꠎꠞ ꠊꠞꠅ ꠚꠤꠞꠤꠀ ꠀꠁꠔꠣꠝ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","ꠀꠞ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠢꠙꠣꠞꠅ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠉꠦ ꠀꠝꠞꠣ ꠇꠥꠘꠥ ꠎꠝꠤ-ꠎꠝꠣꠞ ꠛꠣꠐꠅ ꠘꠤꠔꠣꠝ ꠘꠣꠄ, ꠇꠦꠘꠦꠘꠣ ꠀꠝꠞꠣꠞ ꠛꠣꠐ ꠔ ꠉꠣꠋꠉꠞ ꠅꠃ ꠙꠥꠛꠞ ꠙꠣꠞꠅꠃ ꠝꠤꠟꠤꠉꠦꠍꠦ।” ");
INSERT INTO syls_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠝꠥꠍꠣꠄ ꠇꠁꠟꠣ, “ꠀꠁꠌ꠆ꠍꠣ, ꠔꠥꠝꠞꠣ ꠎꠥꠖꠤ ꠢꠣꠍꠣꠃ ꠁꠟꠣ ꠇꠞꠅ, ꠀꠟ꠆ꠟꠣꠞꠦ ꠀꠎꠤꠞ-ꠘꠣꠎꠤꠞ ꠎꠣꠘꠤꠀ ꠎꠥꠖ꠆ꠖꠞ ꠢꠣꠎꠦ ꠀꠔꠤꠀꠞ ꠟꠁꠀ ꠎꠥꠖꠤ ꠢꠘꠅ ꠟꠣꠠꠣꠁꠔ ꠎꠣꠅ, ");
INSERT INTO syls_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","ꠀꠞ ꠀꠟ꠆ꠟꠣꠄ ꠎꠔꠛꠁꠟ ꠔꠣꠘ ꠖꠥꠡꠝꠘ ꠅꠇꠟꠞꠦ ꠔꠣꠘ ꠍꠣꠝꠘꠦ ꠕꠣꠇꠤ ꠈꠦꠖꠣꠁꠀ ꠘꠣ ꠖꠦꠁꠘ ꠅꠔꠛꠁꠟ ꠔꠥꠝꠞꠣ ꠎꠥꠖ꠆ꠖꠞ ꠢꠣꠎꠦ ꠔꠣꠘ ꠟꠣꠉꠤ ꠉꠣꠋ ꠙꠣꠞ ꠅꠁꠀ ꠢꠙꠣꠞꠅ ꠎꠥꠖꠤ ꠎꠣꠅ, ");
INSERT INTO syls_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ꠔꠦ ꠢꠃ ꠖꠦꠡꠅ ꠝꠣꠛꠥꠖꠞ ꠖꠈꠟꠖꠣꠞꠤ ꠇꠣꠁꠝ ꠅꠁꠀ ꠢꠣꠞꠟꠦ ꠔꠥꠝꠞꠣ ꠅꠘꠅ ꠚꠤꠞꠔ ꠀꠁꠔꠣꠄ ꠙꠣꠞꠛꠣꠄ। ꠔꠦꠃ ꠝꠣꠛꠥꠖ ꠀꠞ ꠛꠣꠖ-ꠛꠣꠇꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠞꠣꠞ ꠎꠦ ꠖꠣꠄ-ꠖꠣꠄꠁꠔ꠆ꠔ ꠀꠍꠤꠟ, ꠁꠔꠣ ꠕꠣꠇꠤ ꠈꠣꠟꠣꠍ ꠅꠁꠛꠣꠄ; ꠀꠞ ꠝꠣꠛꠥꠖꠞ ꠈꠥꠡꠤ ꠝꠣꠚꠤꠇ ꠅꠃ ꠎꠝꠤꠘꠅ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠟꠤꠇꠣꠘꠣ ꠇꠣꠁꠝ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣ ꠎꠥꠖꠤ ꠁꠟꠣ ꠘꠣ ꠇꠞꠅ, ꠔꠦ ꠔꠥꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍꠦ ꠉꠥꠘꠣꠉꠣꠞ ꠛꠘꠛꠣꠄ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠔꠥꠝꠞꠣꠞ ꠙꠣꠙꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠍꠣꠠꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","ꠅꠈꠘ ꠔꠥꠝꠞꠣꠞ ꠛꠃ-ꠛꠣꠁꠌ꠆ꠌꠣꠞ ꠟꠣꠉꠤ ꠐꠣꠃꠘ ꠅꠇꠟ ꠀꠞ ꠉꠞꠥ-ꠍꠣꠉꠟ ꠕꠅꠀꠞ ꠟꠣꠉꠤ ꠎꠣꠉꠣꠅ ꠛꠣꠘꠣꠁꠔꠣꠄ ꠙꠣꠞꠅ, ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣ ꠎꠦꠈꠣꠘ ꠅꠀꠖꠣ ꠇꠞꠍ, ꠁꠔꠣ ꠙꠥꠞꠘ ꠇꠞꠣ ꠟꠣꠉꠛ।” ");
INSERT INTO syls_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","ꠔꠦꠃ ꠍꠣꠖꠥ ꠀꠞ ꠞꠥꠛꠦꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠡꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠇꠁꠟꠣ, “ꠀꠙꠘꠦ ꠔ ꠀꠝꠞꠣꠞ ꠝꠣꠟꠤꠇ, ꠀꠙꠘꠣꠞ ꠁ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠞꠦ ꠀꠙꠘꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠂꠘ, ꠀꠝꠞꠣ ꠅꠟꠣꠃ ꠌꠟꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","ꠀꠝꠞꠣꠞ ꠛꠃ-ꠛꠣꠁꠌ꠆ꠌꠣꠁꠘ ꠀꠞ ꠉꠞꠥ-ꠍꠣꠉꠟꠞ ꠙꠣꠟ ꠅꠘꠞ ꠉꠤꠟꠤꠅꠖ ꠄꠟꠣꠇꠣꠞ ꠐꠣꠃꠘ ꠅꠇꠟꠅ ꠞꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","ꠅꠁꠟꠦ ꠀꠝꠞꠣ ꠀꠝꠞꠣꠞ ꠝꠣꠟꠤꠇꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠎꠥꠖ꠆ꠖꠞ ꠡꠣꠎ-ꠡꠞꠘ꠆ꠎꠣꠝ ꠟꠁꠀ ꠉꠣꠋ ꠙꠣꠞ ꠅꠁꠀ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠟꠣꠠꠣꠁ ꠇꠞꠣꠔ ꠎꠣꠁꠝꠥ।” ");
INSERT INTO syls_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","ꠔꠦꠃ ꠝꠥꠍꠣꠄ ꠅꠔꠣ ꠝꠣꠘꠡꠞ ꠛꠦꠙꠣꠞꠦ ꠁꠝꠣꠝ ꠀꠟꠤ-ꠀꠎꠞ, ꠘꠥꠘꠞ ꠙꠥꠀ ꠁꠃꠍꠣ, ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠛꠣꠞꠅ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠘꠣꠘꠣꠘ ꠉꠥꠡ꠆ꠐꠤꠞ ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","ꠔꠣꠁꠘ ꠄꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠍꠣꠖꠥ ꠀꠞ ꠞꠥꠛꠦꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠢꠇꠟ ꠛꠦꠐꠣꠁꠘ ꠎꠥꠖꠤ ꠢꠣꠍꠣꠃ ꠎꠥꠖ꠆ꠖꠞ ꠡꠣꠎ-ꠡꠞꠘ꠆ꠎꠣꠝ ꠟꠁꠀ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠟꠣꠠꠣꠁ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋ ꠙꠣꠞ ꠅꠁꠀ ꠎꠣꠁꠘ, ꠔꠦ ꠢꠃ ꠖꠦꠡ ꠎꠦꠛꠟꠣ ꠔꠥꠝꠞꠣꠞ ꠖꠈꠟꠅ ꠀꠁꠛ, ꠅꠃ ꠡꠝꠄ ꠔꠥꠝꠞꠣ ꠉꠤꠟꠤꠅꠖ ꠄꠟꠣꠇꠣꠞꠦ ꠔꠣꠞꠣꠞ ꠝꠣꠟꠤꠇꠣꠘꠣꠄ ꠡꠝꠎꠣꠁ ꠖꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","ꠅꠁꠟꠦ ꠔꠣꠞꠣ ꠎꠥꠖꠤ ꠁꠟꠣ ꠘꠣ ꠇꠞꠂꠘ, ꠔꠦ ꠢꠃ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅꠃ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠔꠣꠞꠣꠞ ꠛꠣꠐ ꠘꠤꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠍꠣꠖꠥ ꠀꠞ ꠞꠥꠛꠦꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠡꠦ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘ ꠁ ꠉꠥꠟꠣꠝ ꠅꠇꠟꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠂꠘ, ꠀꠝꠞꠣ ꠅꠟꠣꠃ ꠇꠞꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","ꠀꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝꠦ ꠎꠥꠖ꠆ꠖꠞ ꠡꠣꠎ-ꠡꠞꠘ꠆ꠎꠣꠝ ꠟꠁꠀ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋ ꠙꠣꠞ ꠅꠁꠀ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠎꠣꠁꠝꠥ, ꠅꠁꠟꠦ ꠀꠝꠞꠣꠞ ꠎꠝꠤ-ꠎꠝꠣꠞ ꠛꠣꠐ ꠉꠣꠋꠉꠞ ꠅꠙꠣꠞꠅ ꠞꠁꠟ।” ");
INSERT INTO syls_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠝꠥꠍꠣ ꠘꠛꠤ ꠞꠣꠎꠤ ꠅꠁꠟꠣ। ꠔꠣꠁꠘ ꠍꠣꠖꠥ ꠀꠞ ꠞꠥꠛꠦꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞꠦ, ꠄꠞꠟꠉꠦ ꠁꠃꠍꠥꠚꠞ ꠙꠥꠀ ꠝꠣꠘꠡꠣ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠅꠞ꠆ꠗꠦꠇ ꠝꠣꠘꠡꠞꠦ, ꠅꠃ ꠎꠣꠉꠣꠁꠘ ꠖꠤꠟꠣ। ꠝꠥꠍꠣꠄ ꠀꠝꠥꠞꠤ ꠅꠇꠟꠞ ꠛꠣꠖꠡꠣ ꠍꠤꠢꠥꠘ ꠀꠞ ꠛꠣꠡꠘꠞ ꠛꠣꠖꠡꠣ ꠃꠎꠞ ꠀꠡ꠆ꠔꠣ ꠞꠣꠎꠔ꠆ꠔꠞ ꠢꠇꠟ ꠐꠣꠃꠘ ꠀꠞ ꠉꠣꠃ-ꠉꠦꠞꠣꠝ ꠡꠢ ꠡꠛ ꠎꠝꠤ-ꠝꠤꠞꠣꠡ ꠔꠣꠞꠣꠞ ꠟꠣꠉꠤ ꠕꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","ꠔꠦꠃ ꠍꠣꠖꠥ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠡꠦ ꠖꠤꠛꠣꠘ, ꠅꠐꠣꠞꠥꠔ, ꠀꠞꠥꠀꠞ, ");
INSERT INTO syls_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","ꠀꠐꠞꠥꠔ-ꠡꠥꠚꠣꠘ, ꠎꠣꠎꠤꠞꠣ, ꠎꠉꠛꠤꠀ, ");
INSERT INTO syls_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","ꠛꠣꠄꠔ-ꠘꠤꠝꠞꠣ, ꠛꠣꠄꠔ-ꠢꠣꠞꠣꠘ ꠘꠣꠝꠞ ꠉꠣꠃꠀꠁꠘ ꠀꠞ ꠐꠣꠃꠘ ꠅꠇꠟꠞꠦ ꠃꠌꠣ ꠃꠌꠣ ꠛꠣꠃꠘ꠆ꠒꠞꠤ ꠅꠀꠟ ꠉꠣꠕꠤꠀ ꠝꠎꠛꠥꠔ ꠇꠞꠟꠣ। ꠄꠞꠟꠉꠦ ꠔꠣꠞꠣꠞ ꠉꠞꠥ-ꠍꠣꠉꠟ ꠕꠁꠛꠣꠞ ꠎꠣꠉꠣꠅ ꠛꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","ꠞꠥꠛꠦꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠡꠦ ꠢꠤꠡꠛꠘ, ꠁꠟꠤꠀꠟꠤ, ꠇꠤꠞꠤꠀꠔꠣꠁꠝ ꠐꠣꠃꠘ, ");
INSERT INTO syls_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","ꠀꠞ ꠘꠛꠅ, ꠛꠣꠀꠟ-ꠝꠤꠃꠘ, ꠍꠤꠛꠝꠣ ꠘꠣꠝꠞ ꠉꠣꠃꠀꠁꠘ ꠑꠤꠇ-ꠑꠣꠇ ꠇꠞꠟꠣ। ꠇꠞꠤꠀ ꠔꠣꠞꠣ ꠁꠔꠣꠞ ꠘꠄꠀ ꠘꠣꠝ ꠕꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","ꠝꠣꠘꠡꠣꠞ ꠙꠥꠀ ꠝꠣꠈꠤꠞꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠦ ꠉꠤꠟꠤꠅꠖꠅ ꠉꠤꠀ ꠀꠉꠦꠃ ꠁꠔꠣ ꠖꠈꠟ ꠇꠞꠤꠟꠤꠍꠤꠟ, ꠀꠞ ꠢꠘꠞ ꠛꠣꠡꠤꠘ꠆ꠖꠣ ꠀꠝꠥꠞꠤ ꠅꠇꠟꠞꠦ ꠈꠦꠖꠣꠁ ꠖꠤꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","ꠄꠞꠟꠣꠉꠤ ꠝꠥꠍꠣꠄ ꠝꠣꠘꠡꠣꠞ ꠅꠃ ꠀꠅꠟꠣꠖ ꠝꠣꠈꠤꠞꠤ ꠅꠇꠟꠞ ꠛꠣꠐꠅ ꠉꠤꠟꠤꠅꠖ ꠄꠟꠣꠇꠣꠞꠦ ꠖꠤꠟꠣꠁꠟꠣ, ꠔꠣꠞꠣ ꠅꠘꠅ ꠛꠡꠔ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","ꠄꠞꠝꠣꠎꠦ ꠝꠣꠘꠡꠣ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠎꠣꠄꠁꠞ ꠘꠣꠝꠞ ꠄꠇꠎꠘꠦ ꠉꠤꠀ ꠀꠝꠥꠞꠤ ꠅꠇꠟꠞ ꠢꠇꠟ ꠉꠣꠃ-ꠉꠦꠞꠣꠝ ꠖꠈꠟ ꠇꠞꠤꠟꠤꠍꠤꠟ, ꠀꠞ ꠁꠔꠣꠞ ꠘꠣꠝ ꠖꠤꠍꠤꠟ ꠢꠣꠛ꠆ꠛꠥꠔ-ꠎꠣꠄꠁꠞ। ");
INSERT INTO syls_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","ꠀꠞ ꠘꠥꠛꠣ ꠘꠣꠝꠞ ꠄꠇꠎꠘꠦ ꠉꠤꠀ ꠇꠘꠣꠔ ꠀꠞ ꠄꠞ ꠇꠣꠘ꠆ꠖꠣ-ꠇꠣꠍꠣꠞ ꠉꠣꠃ-ꠉꠦꠞꠣꠝ ꠅꠇꠟ ꠖꠈꠟ ꠇꠞꠤꠀ, ꠔꠣꠞ ꠘꠤꠎꠞ ꠘꠣꠝꠦ ꠁ ꠎꠣꠉꠣꠞ ꠘꠣꠝ ꠖꠤꠟ ꠘꠥꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","ꠝꠥꠍꠣ ꠀꠞ ꠢꠣꠞꠥꠘ ꠘꠛꠤꠞ ꠘꠦꠔꠣꠉꠤꠞꠤꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠎꠣꠔꠤ ꠚꠃꠎꠤ ꠖꠟ ꠢꠣꠎꠤꠀ, ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁꠀ ꠀꠅꠀꠞ ꠛꠣꠖꠦ ꠘꠣꠘꠣꠘ ꠎꠣꠉꠣꠔ ꠖꠝ ꠟꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","ꠀꠞ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠔꠣꠞꠣꠞ ꠖꠝ ꠟꠅꠀꠞ ꠎꠣꠉꠣꠁꠘ꠆ꠔꠞ ꠘꠣꠝ ꠟꠦꠈꠤꠀ ꠕꠁꠟꠣ। ꠅꠃ ꠎꠣꠉꠣꠁꠘ ꠅꠁꠟ, ");
INSERT INTO syls_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","ꠛꠍꠞꠞ ꠙꠄꠟꠣ ꠌꠣꠘ꠆ꠖꠞ ꠙꠘꠞ ꠔꠣꠞꠤꠈ, ꠝꠣꠘꠤ ꠀꠎꠣꠖꠤ ꠁꠖꠞ ꠛꠣꠖꠞ ꠖꠤꠘ, ꠔꠣꠞꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠞꠣꠝꠣꠡꠦꠡ ꠄꠟꠣꠇꠣ ꠕꠣꠇꠤ ꠞꠅꠀꠘꠣ ꠅꠁꠟꠣ। ꠝꠤꠡꠞꠞ ꠢꠇꠟ ꠝꠣꠘꠡꠞ ꠌꠈꠥꠞ ꠍꠣꠝꠘꠦꠖꠤ ꠔꠣꠞꠣ ꠛꠥꠇ ꠚꠥꠟꠣꠁꠀ ꠛꠣꠞ ꠅꠁꠀ ꠀꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","ꠅꠃ ꠡꠝꠄ ꠝꠤꠡꠞꠤ ꠅꠇꠟꠦ ꠔꠣꠞꠣꠞ ꠛꠠ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠟꠣꠡ ꠖꠣꠚꠘ ꠇꠞꠣꠔ ꠀꠍꠤꠟ। ꠝꠣꠛꠥꠖꠦ ꠀꠉꠞ ꠞꠣꠁꠔ ꠔꠣꠞꠣꠞ ꠢꠇꠟ ꠊꠞꠞ ꠛꠠ ꠙꠥꠀꠂꠘꠞꠦ ꠝꠣꠞꠤꠟꠤꠍꠟꠣ। ꠔꠣꠁꠘ ꠅꠔꠣꠞ ꠖꠦꠛ-ꠖꠦꠛꠤꠞ ꠃꠙꠞꠦꠅ ꠉꠎꠛ ꠓꠣꠟꠤꠀ ꠔꠣꠞꠣꠞ ꠙꠣꠅꠘꠣ ꠡꠣꠎꠣ ꠖꠤꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠞꠣꠝꠣꠡꠦꠡ ꠄꠟꠣꠇꠣ ꠍꠣꠠꠤꠀ ꠡꠥꠇ꠆ꠇꠔꠅ ꠀꠁꠀ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","ꠛꠣꠖꠦ ꠡꠥꠇ꠆ꠇꠔ ꠕꠣꠇꠤ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠄꠕꠝ ꠘꠣꠝꠞ ꠎꠣꠉꠣꠔ ꠀꠁꠀ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","ꠀꠞ ꠄꠕꠝ ꠕꠣꠇꠤ ꠛꠣꠀꠟ-ꠎꠣꠚꠘꠞ ꠍꠣꠝꠘꠦ ꠝꠤꠉꠖꠥꠟꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠚꠣꠝꠣ-ꠢꠤꠞꠥꠔ ꠘꠣꠝꠞ ꠎꠣꠉꠣꠔ ꠀꠁꠀ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","ꠛꠣꠖꠦ ꠚꠣꠝꠣ-ꠢꠤꠞꠥꠔ ꠕꠣꠇꠤ ꠖꠞꠤꠀ ꠙꠣꠞ ꠅꠁꠀ ꠄꠕꠝ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠉꠦꠟꠣ, ꠅꠃ ꠝꠞꠥꠜꠥꠝꠤ ꠛꠣꠄ ꠔꠤꠘ ꠖꠤꠘꠞ ꠙꠕ ꠙꠣꠠꠤ ꠖꠤꠀ ꠝꠣꠞꠥꠀꠔ ꠉꠤꠀ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","ꠛꠣꠖꠦ ꠝꠣꠞꠥꠀ ꠕꠣꠇꠤ ꠄꠟꠤꠝꠅ ꠉꠦꠟꠣ, ꠁꠘꠅ ꠙꠣꠘꠤꠞ ꠛꠣꠞꠅꠉꠥ ꠁꠘ꠆ꠖꠣꠞꠣ ꠀꠞ ꠡꠔ꠆ꠔꠁꠞꠉꠥ ꠈꠦꠎꠥꠞ ꠉꠣꠍ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","ꠄꠞꠛꠣꠖꠦ ꠄꠟꠤꠝ ꠍꠣꠠꠤꠀ ꠘꠤꠟ ꠖꠞꠤꠀꠞ ꠙꠣꠞꠅ ꠉꠤꠀ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","ꠢꠘꠅ ꠕꠣꠇꠤ ꠍꠤꠘ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠀꠁꠀ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","ꠀꠞ ꠍꠤꠘ ꠝꠞꠥꠜꠥꠝꠤ ꠕꠣꠇꠤ ꠖꠙꠇꠣ ꠘꠣꠝꠞ ꠎꠣꠉꠣꠔ ꠉꠤꠀ ꠇꠦꠝ꠆ꠙ ꠉꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","ꠛꠣꠖꠦ ꠖꠙꠇꠣ ꠍꠣꠠꠤꠀ ꠀꠟꠥꠡꠅ ꠉꠤꠀ ꠇꠦꠝ꠆ꠙ ꠉꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","ꠀꠟꠥꠡ ꠕꠣꠇꠤ ꠞꠚꠤꠖꠤꠝꠅ ꠉꠦꠟꠣ, ꠁꠘꠅ ꠈꠣꠁꠛꠣꠞ ꠇꠥꠘꠥ ꠙꠣꠘꠤ ꠀꠍꠤꠟ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","ꠔꠦꠃ ꠞꠚꠤꠖꠤꠝ ꠍꠣꠠꠤꠀ ꠔꠣꠞꠣ ꠍꠤꠘꠣꠁ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠉꠤꠀ ꠇꠦꠝ꠆ꠙ ꠉꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","ꠄꠞꠛꠣꠖꠦ ꠍꠤꠘꠣꠁ ꠝꠞꠥꠜꠥꠝꠤ ꠕꠣꠇꠤ ꠇꠤꠛꠞꠥꠔ-ꠢꠥꠔꠣꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","ꠇꠤꠛꠞꠥꠔ-ꠢꠥꠔꠣꠛꠣ ꠕꠣꠇꠤ ꠢꠣꠎꠤꠞꠥꠔ। ");
INSERT INTO syls_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","ꠢꠣꠎꠤꠞꠥꠔ ꠕꠣꠇꠤ ꠞꠤꠔꠝꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","ꠞꠤꠔꠝꠣ ꠕꠣꠇꠤ ꠞꠤꠝ꠆ꠝꠘ-ꠙꠦꠞꠡ। ");
INSERT INTO syls_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","ꠅꠈꠣꠘ ꠕꠣꠇꠤ ꠟꠤꠛꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","ꠟꠤꠛꠘꠣ ꠕꠣꠇꠤ ꠞꠤꠍꠍꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","ꠞꠤꠍꠍꠣ ꠕꠣꠇꠤ ꠇꠢꠦꠟꠣꠔꠣ ꠘꠣꠝꠞ ꠎꠣꠉꠣꠔ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","ꠛꠣꠖꠦ ꠉꠦꠟꠣ ꠡꠦꠚꠞ ꠙꠣꠠꠅ। ");
INSERT INTO syls_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","ꠅꠈꠣꠘ ꠕꠣꠇꠤ ꠢꠞꠣꠖꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","ꠢꠞꠣꠖꠣ ꠕꠣꠇꠤ ꠝꠈꠦꠟꠥꠔ। ");
INSERT INTO syls_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","ꠅꠘ ꠕꠣꠇꠤ ꠔꠢꠔ। ");
INSERT INTO syls_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","ꠛꠣꠖꠦ ꠔꠣꠞꠦꠈ। ");
INSERT INTO syls_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","ꠔꠣꠞꠦꠈ ꠕꠣꠇꠤ ꠝꠤꠔꠇꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","ꠝꠤꠔꠇꠣ ꠕꠣꠇꠤ ꠢꠡꠝꠥꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","ꠛꠣꠖꠦ ꠝꠍꠦꠞꠥꠔ। ");
INSERT INTO syls_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","ꠅꠘ ꠕꠣꠇꠤ ꠛꠘꠤ-ꠁꠀꠇꠣꠘ। ");
INSERT INTO syls_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","ꠛꠣꠖꠦ ꠢꠥꠞ-ꠢꠉ꠆ꠉꠤꠖꠉꠖ। ");
INSERT INTO syls_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","ꠅꠘ ꠕꠣꠇꠤ ꠎꠔꠛꠣꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","ꠎꠔꠛꠣꠔꠣ ꠕꠣꠇꠤ ꠅꠛꠞꠥꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","ꠛꠣꠖꠦ ꠁꠎꠤꠅꠘ-ꠉꠦꠛꠦꠞ। ");
INSERT INTO syls_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","ꠀꠞ ꠅꠈꠣꠘ ꠕꠣꠇꠤ ꠎꠤꠘ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠇꠣꠖꠦꠡ ꠄꠟꠣꠇꠣꠔ ꠉꠤꠀ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","ꠛꠣꠖꠦ ꠇꠣꠖꠦꠡ ꠍꠣꠠꠤꠀ ꠁꠖꠥꠝ ꠖꠦꠡꠞ ꠡꠤꠝꠣꠘꠣꠞ ꠉꠦꠍꠦ ꠢꠥꠞ ꠙꠣꠠꠅ ꠞꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁ ꠀꠅꠀꠞ ꠛꠣꠖꠦ, ꠌꠣꠟ꠆ꠟꠤꠡ ꠛꠍꠞꠞ ꠙꠣꠌ ꠘꠝ꠆ꠛꠞ ꠌꠣꠘ꠆ꠖꠞ ꠙꠄꠟꠣ ꠖꠤꠘ ꠁꠝꠣꠝ ꠢꠣꠞꠥꠘ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝꠦ ꠢꠥꠞ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠃꠑꠤꠍꠟꠣ, ꠀꠞ ꠢꠘꠅ ꠔꠣꠘ ꠃꠚꠣꠔ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","ꠔꠣꠁꠘ ꠄꠇ-ꠡ ꠔꠦꠁꠡ ꠛꠍꠞ ꠛꠄꠅꠡꠅ ꠢꠥꠞ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠁꠘ꠆ꠔꠦꠇꠣꠟ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","ꠄꠞꠝꠣꠎꠦ ꠅꠞꠣꠖ ꠄꠟꠣꠇꠣꠞ ꠇꠦꠘꠣꠘꠤ ꠛꠣꠖꠡꠣꠄ ꠈꠛꠞ ꠙꠣꠁꠟꠣ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠅꠘꠅ ꠀꠁꠍꠂꠘ। ꠔꠣꠁꠘ ꠔ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠞ ꠘꠦꠉꠦꠜ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠞꠁꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","ꠛꠣꠖꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠢꠥꠞ ꠙꠣꠠ ꠍꠣꠠꠤꠀ ꠍꠟꠝꠥꠘꠣ ꠘꠣꠝꠞ ꠎꠣꠉꠣꠔ ꠉꠤꠀ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","ꠍꠟꠝꠥꠘꠣ ꠕꠣꠇꠤ ꠙꠥꠘꠘ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","ꠙꠥꠘꠘ ꠕꠣꠇꠤ ꠅꠛꠥꠔ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","ꠅꠛꠥꠔ ꠕꠣꠇꠤ ꠝꠥꠀꠛ ꠖꠦꠡꠞ ꠡꠤꠝꠣꠘꠣꠔ ꠁꠀ-ꠀꠛꠣꠞꠤꠝꠅ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","ꠅꠈꠣꠘ ꠕꠣꠇꠤ ꠖꠤꠛꠣꠘ-ꠍꠣꠖꠥ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","ꠅꠘ ꠕꠣꠇꠤ ꠀꠟꠝꠥꠘ-ꠖꠤꠛ꠆ꠟꠣꠔꠤꠝꠅ ꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","ꠛꠣꠖꠦ ꠔꠣꠞꠣ ꠀꠛꠣꠞꠤꠝ ꠙꠣꠠꠅ ꠃꠑꠤꠀ ꠘꠛꠅ ꠘꠣꠝꠞ ꠐꠤꠟ꠆ꠟꠣꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠇꠦꠝ꠆ꠙ ꠉꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","ꠄꠞꠛꠣꠖꠦ ꠀꠛꠣꠞꠤꠝ ꠙꠣꠠ ꠍꠣꠠꠤꠀ ꠎꠤꠞꠤꠢꠅ ꠐꠣꠃꠘꠞ ꠃꠟꠐꠣꠛꠣꠄ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠝꠥꠀꠛ ꠖꠦꠡꠞ ꠔꠟ ꠎꠣꠉꠣꠔ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","ꠁ ꠇꠦꠝ꠆ꠙꠞ ꠡꠤꠝꠣꠘꠣ ꠀꠍꠤꠟ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠙꠣꠞꠅ ꠝꠥꠀꠛ ꠄꠟꠣꠇꠣꠞ ꠔꠟ ꠎꠣꠉꠣ ꠛꠣꠄꠔ-ꠎꠤꠡꠤꠝꠥꠔ ꠕꠣꠇꠤ ꠀꠛꠦꠟ-ꠡꠤꠐꠤꠝ ꠐꠣꠃꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ। ");
INSERT INTO syls_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","ꠀꠞ ꠅꠃ ꠡꠝꠄ ꠎꠤꠞꠤꠢꠅ ꠄꠟꠣꠇꠣꠞ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠗꠣꠞꠅ ꠝꠥꠀꠛ ꠖꠦꠡꠞ ꠔꠟ ꠎꠣꠉꠣꠔ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠔꠥꠝꠞꠣ ꠎꠦꠛꠟꠣ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋ ꠙꠣꠞ ꠅꠁꠀ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠉꠤꠀ ꠀꠎꠤꠛꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ꠅꠃ ꠡꠝꠄ ꠔꠥꠝꠞꠣꠞ ꠍꠣꠝꠘ ꠕꠣꠇꠤ ꠢꠘꠞ ꠢꠇꠟ ꠝꠣꠘꠡꠞꠦ ꠈꠦꠖꠣꠁ ꠖꠤꠛꠣꠄ। ꠈꠦꠖꠣꠁꠀ ꠔꠣꠞꠣꠞ ꠙꠣꠔ꠆ꠔꠞ ꠈꠥꠖꠤꠀ ꠛꠣꠘꠣꠁꠟ ꠢꠇꠟ ꠝꠥꠞ꠆ꠔꠤ ꠜꠣꠋꠉꠤꠀ ꠌꠥꠞꠝꠣꠞ ꠇꠞꠛꠣꠄ। ꠢꠥꠘꠣꠞꠞ ꠀꠔꠤꠀꠞꠖꠤ ꠛꠣꠘꠣꠁꠟ ꠢꠇꠟ ꠖꠦꠛ-ꠖꠦꠛꠤꠞ ꠝꠥꠞ꠆ꠔꠤ ꠛꠤꠘꠣꠡ ꠇꠞꠛꠣꠄ। ꠀꠞ ꠐꠤꠟ꠆ꠟꠣꠞ ꠃꠙꠞꠞ ꠖꠦꠛꠔꠣꠞ ꠘꠣꠝꠞ ꠙꠡꠥꠞ-ꠛꠟꠤ ꠈꠣꠘꠣꠁꠘ ꠔꠥꠟꠤꠀ ꠚꠣꠟꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","ꠅꠟꠣꠈꠣꠘ ꠔꠥꠝꠞꠣ ꠀꠡ꠆ꠔꠣ ꠖꠦꠡ ꠖꠈꠟ ꠇꠞꠤꠀ ꠢꠘꠅ ꠛꠡꠔ ꠇꠞꠛꠣꠄ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠔꠥꠝꠞꠣꠞ ꠖꠈꠟꠖꠣꠞꠤꠞ ꠟꠣꠉꠤ ꠁ ꠖꠦꠡꠈꠣꠘ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠣꠘ ꠇꠞꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","ꠢꠘꠅ ꠟꠐꠣꠞꠤ ꠝꠣꠞꠤꠀ ꠔꠥꠝꠞꠣꠞ ꠘꠣꠘꠣꠘ ꠉꠥꠡ꠆ꠐꠤꠞ ꠎꠣꠉꠣ ꠛꠣꠐꠤꠀ ꠘꠤꠅ। ꠎꠦ ꠉꠥꠡ꠆ꠐꠤꠔ ꠛꠦꠡꠤ ꠝꠣꠘꠥꠡ ꠔꠣꠞꠣꠞꠦ ꠛꠦꠡꠤ ꠎꠣꠉꠣ, ꠀꠞ ꠇꠝ ꠅꠁꠟꠦ ꠇꠝ ꠎꠣꠉꠣ ꠖꠤꠅ। ꠟꠐꠣꠞꠤꠔ ꠎꠦ ꠉꠥꠡ꠆ꠐꠤꠄ ꠎꠦ ꠎꠣꠉꠣ ꠙꠣꠁꠛꠣ, ꠔꠣꠞꠣ ꠅꠘꠅꠃ ꠛꠡꠔ ꠇꠞꠛꠣ। ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠎꠞ ꠘꠣꠘꠣꠘ ꠉꠥꠡ꠆ꠐꠤꠄ ꠎꠣꠞꠎꠤꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠄꠟꠣꠇꠣꠞ ꠝꠣꠎꠦ ꠎꠣꠉꠣ ꠙꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣ ꠎꠥꠖꠤ ꠢꠘꠞ ꠛꠣꠡꠤꠘ꠆ꠖꠣ ꠅꠇꠟꠞꠦ ꠘꠣ ꠖꠦꠈꠣꠅ, ꠔꠦ ꠔꠣꠞꠣꠞ ꠎꠦꠉꠥꠁꠘ ꠞꠁꠛꠣ, ꠁꠉꠥꠁꠘ ꠔꠥꠝꠞꠣꠞ ꠌꠈꠥꠞ ꠇꠣꠐꠣ ꠀꠞ ꠛꠥꠇꠥꠞ ꠍꠦꠟ ꠛꠘꠤꠀ ꠞꠁꠛꠣ। ꠁꠔꠣꠄ ꠔꠥꠝꠞꠣꠞ ꠛꠡꠔꠤ ꠎꠝꠤꠘꠅ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠥꠟꠥꠝ-ꠝꠍꠤꠛꠔꠅ ꠚꠣꠟꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","ꠢꠃ ꠡꠝꠄ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠅꠟꠣ ꠡꠣꠎꠣ ꠖꠤꠝꠥ, ꠎꠦ ꠡꠣꠎꠣ ꠈꠣꠟꠤ ꠔꠣꠞꠣꠞ ꠟꠣꠉꠤꠃ ꠑꠤꠇ ꠇꠞꠤꠀ ꠕꠁꠍꠟꠣꠝ।” ");
INSERT INTO syls_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠀꠝꠣꠞ ꠅꠃ ꠢꠥꠇꠥꠝ ꠎꠣꠘꠣꠁ ꠖꠦꠅ, ꠔꠥꠝꠞꠣ ꠉꠤꠀ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠢꠣꠝꠣꠘꠤꠞ ꠛꠣꠖꠦ ꠢꠘꠅ ꠎꠦ ꠎꠣꠉꠣꠞ ꠝꠣꠟꠤꠇꠣꠘꠣ ꠙꠣꠁꠛꠣꠄ, ꠁ ꠎꠣꠉꠣꠞ ꠡꠤꠝꠣꠘꠣ ꠅꠁꠟ, ");
INSERT INTO syls_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","ꠁꠖꠥꠝ ꠖꠦꠡꠞ ꠛꠒꠣꠞꠞ ꠎꠤꠘ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠇꠤꠍꠥ ꠄꠟꠣꠇꠣ ꠔꠥꠝꠞꠣꠞ ꠖꠦꠡꠞ ꠖꠃꠇꠘꠞ ꠡꠤꠝꠣꠘꠣ। ꠛꠣꠖꠦ ꠅꠃ ꠖꠃꠇꠘꠞ ꠡꠤꠝꠣꠘꠣ ꠕꠣꠇꠤ ꠙꠥꠛꠦꠖꠤ ꠉꠤꠀ ꠟꠥꠘꠣ ꠡꠣꠉꠞꠞ ꠢꠦꠡ ꠝꠣꠕꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ। ");
INSERT INTO syls_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","ꠄꠞꠟꠉꠦ ꠀꠇꠞꠣꠛ꠆ꠛꠤꠝ ꠙꠣꠠꠞ ꠙꠕ ꠙꠣꠞ ꠅꠁꠀ ꠢꠣꠞꠤ ꠎꠤꠘ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠢꠣꠝꠣꠁꠀ ꠇꠣꠖꠦꠡ-ꠛꠞꠘꠦꠀꠞ ꠖꠃꠇꠘꠦꠖꠤ ꠡꠤꠝꠣꠘꠣ ꠎꠣꠁꠛ। ꠉꠤꠀ ꠅꠈꠣꠘ ꠕꠣꠇꠤ ꠢꠣꠎꠞ-ꠀꠖꠞ ꠅꠁꠀ ꠅꠎꠝꠥꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠔꠥꠝꠞꠣꠞ ꠡꠤꠝꠣꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","ꠀꠞ ꠅꠎꠝꠥꠘ ꠕꠣꠇꠤ ꠊꠥꠞꠤꠀ ꠝꠤꠡꠞꠞ ꠡꠤꠝꠣꠘꠣꠞ ꠢꠥꠇꠘꠣ ꠈꠣꠟꠞ ꠙꠣꠞꠦꠖꠤ ꠜꠥꠝꠗꠤꠅ ꠡꠣꠉꠞꠅ ꠉꠤꠀ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“ꠔꠥꠝꠞꠣꠞ ꠖꠦꠡꠞ ꠙꠁꠌꠝꠞ ꠡꠤꠝꠣꠘꠣ ꠅꠁꠛ ꠜꠥꠝꠗꠤꠅ ꠡꠣꠉꠞ। ꠁꠐꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠙꠁꠌꠝꠞ ꠀꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“ꠔꠥꠝꠞꠣꠞ ꠃꠔꠞꠞ ꠡꠤꠝꠣꠘꠣ ꠅꠁꠛ, ꠜꠥꠝꠗꠤꠅ ꠡꠣꠉꠞ ꠕꠣꠇꠤ ꠢꠥꠞ ꠘꠣꠝꠞ ꠙꠣꠠ, ");
INSERT INTO syls_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","ꠅꠃ ꠙꠣꠠ ꠕꠣꠇꠤ ꠢꠣꠝꠣꠔꠅ ꠎꠣꠁꠛꠣꠞ ꠙꠕ ꠙꠞ꠆ꠎꠘ꠆ꠔ, ꠢꠣꠝꠣꠔꠞ ꠙꠕ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣꠞ ꠡꠤꠝꠣꠘꠣ ꠎꠤꠖꠣꠖ ꠉꠣꠃ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠎꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","ꠀꠞ ꠎꠤꠖꠣꠖ ꠕꠣꠇꠤ ꠎꠤꠚꠞꠥꠘ ꠅꠁꠀ ꠢꠣꠎꠞ-ꠅꠘꠘꠅ ꠉꠤꠀ ꠡꠦꠡ ꠅꠁꠛ। ꠁꠐꠣꠃ ꠅꠁꠛ ꠔꠥꠝꠞꠣꠞ ꠃꠔꠞꠞ ꠡꠤꠝꠣꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“ꠖꠦꠡꠞ ꠙꠥꠛꠞ ꠡꠤꠝꠣꠘꠣ ꠅꠁꠟ, ꠢꠣꠎꠞ-ꠅꠘꠘ ꠕꠣꠇꠤ ꠡꠚꠣꠝ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠄꠇꠐꠣ ꠡꠤꠝꠣꠘꠣ ꠀꠁꠟ ꠑꠤꠇ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","ꠅꠃ ꠡꠚꠣꠝꠞ ꠡꠤꠝꠣꠘꠣ ꠕꠣꠇꠤ ꠅꠂꠘ ꠉꠣꠃꠞ ꠙꠥꠛꠦꠖꠤ ꠉꠤꠀ ꠞꠤꠛꠟꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠀꠁꠀ ꠟꠣꠝꠛ, ꠟꠣꠝꠤꠀ ꠉꠣꠟꠤꠟ ꠀꠅꠞꠞ ꠌꠞꠦꠖꠤ ꠎꠣꠁꠛ, ");
INSERT INTO syls_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","ꠉꠤꠀ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠙꠣꠞꠦꠖꠤ ꠟꠥꠘꠣ ꠡꠣꠉꠞꠅ ꠀꠁꠀ ꠡꠦꠡ ꠅꠁꠛ। ꠅꠃ ꠡꠛ ꠅꠁꠟ ꠔꠥꠝꠞꠣꠞ ꠖꠦꠡꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠞ ꠡꠤꠝꠣꠘꠣ ꠀꠁꠟ।” ");
INSERT INTO syls_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","ꠀꠞ ꠝꠥꠍꠣꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠟꠣ, “ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠔꠥꠝꠞꠣ ꠟꠐꠣꠞꠤ ꠝꠣꠞꠅ, ꠝꠣꠞꠤꠀ ꠔꠥꠝꠞꠣꠞ ꠘꠄ ꠈꠣꠘ꠆ꠖꠣꠘ ꠀꠞ ꠝꠣꠘꠡꠣ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠅꠞ꠆ꠗꠦꠇ ꠝꠣꠘꠡꠞꠦ ꠅꠃ ꠖꠦꠡꠞ ꠎꠝꠤ-ꠝꠣꠐꠤ ꠛꠣꠐꠤꠀ ꠖꠤꠀ, ꠔꠥꠝꠞꠣꠞ ꠖꠈꠟꠖꠣꠞꠤ ꠇꠣꠁꠝ ꠇꠞꠅ। ");
INSERT INTO syls_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","ꠎꠣꠘ ꠔ, ꠞꠥꠛꠦꠘ ꠈꠣꠘ꠆ꠖꠣꠘ, ꠍꠣꠖꠥ ꠈꠣꠘ꠆ꠖꠣꠘ ꠀꠞ ꠝꠣꠘꠡꠣ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠅꠞ꠆ꠗꠦꠇ ꠝꠣꠘꠡꠦ ꠔꠣꠞꠣꠞ ꠎꠣꠞꠎꠤꠞ ꠉꠥꠡ꠆ꠐꠤ ꠝꠣꠚꠤꠇ ꠎꠝꠤ-ꠎꠝꠣꠞ ꠛꠣꠐ ꠀꠉꠦꠃ ꠙꠣꠁꠟꠤꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","ꠔꠣꠞꠣ ꠎꠤꠞꠤꠢꠅ ꠄꠟꠣꠇꠣꠞ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠙꠥꠛꠞ ꠙꠣꠞꠅ ꠔꠣꠞꠣꠞ ꠛꠣꠐ ꠀꠉꠦꠃ ꠛꠣꠍꠤꠀ ꠘꠤꠍꠂꠘꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“ꠅꠃ ꠖꠦꠡꠞ ꠎꠝꠤ-ꠝꠣꠐꠤꠞꠦ ꠛꠣꠐꠤꠀ ꠖꠤꠔꠦ ꠎꠦꠞꠣ ꠝꠣꠔꠛ꠆ꠛꠞꠤ ꠇꠞꠛꠣ, ꠄꠞꠣꠞ ꠘꠣꠝ ꠅꠁꠟ, ꠁꠝꠣꠝ ꠀꠟꠤ-ꠀꠎꠞ ꠀꠞ ꠘꠥꠘꠞ ꠙꠥꠀ ꠁꠃꠍꠣ। ");
INSERT INTO syls_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","ꠎꠝꠤ-ꠎꠝꠣ ꠛꠣꠐꠤꠛꠣꠞ ꠇꠣꠟꠅ ꠡꠣꠁꠎ꠆ꠎ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠙꠞꠔꠦꠇ ꠈꠣꠘ꠆ꠖꠣꠘꠅ ꠕꠣꠇꠤ ꠄꠇꠎꠘ ꠇꠞꠤ ꠡꠞ꠆ꠖꠣꠞ ꠘꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","ꠅꠃ ꠡꠞ꠆ꠖꠣꠞ ꠅꠁꠟꠣ, ꠄꠢꠥꠖꠣ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠎꠤꠚꠥꠘ꠆ꠘꠤꠞ ꠙꠥꠀ ꠇꠣꠟꠥꠔ, ");
INSERT INTO syls_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","ꠡꠤꠝꠤꠅꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠀꠝꠤꠢꠥꠖꠞ ꠙꠥꠀ ꠡꠣꠝꠥꠄꠟ, ");
INSERT INTO syls_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","ꠛꠤꠘ-ꠁꠀꠝꠤꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠇꠤꠍꠟꠥꠘꠞ ꠙꠥꠀ ꠁꠟꠤꠖꠖ, ");
INSERT INTO syls_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","ꠖꠣꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠃꠎꠟꠤꠞ ꠙꠥꠀ ꠛꠥꠇ꠆ꠇꠤ, ");
INSERT INTO syls_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","ꠁꠃꠍꠥꠚꠞ ꠙꠥꠀ ꠝꠣꠘꠡꠣ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠁꠚꠣꠖꠞ ꠙꠥꠀ ꠢꠣꠘ꠆ꠘꠤꠄꠟ, ");
INSERT INTO syls_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","ꠁꠃꠍꠥꠚꠞ ꠙꠥꠀ ꠀꠚꠞꠣꠁꠝ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠡꠤꠙ꠆ꠔꠘꠞ ꠙꠥꠀ ꠇꠝꠥꠄꠟ, ");
INSERT INTO syls_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","ꠍꠛꠥꠟꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠚꠞ꠆ꠘꠣꠈꠞ ꠙꠥꠀ ꠁꠟꠤꠎꠣꠚꠘ, ");
INSERT INTO syls_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","ꠁꠍꠣꠈꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠀꠎꠣꠘꠞ ꠙꠥꠀ ꠚꠟꠔꠤꠄꠟ, ");
INSERT INTO syls_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","ꠀꠡꠤꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠡꠟꠝꠤꠞ ꠙꠥꠀ ꠅꠢꠤꠢꠥꠖ, ");
INSERT INTO syls_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","ꠘꠙ꠆ꠔꠣꠟꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠡꠞ꠆ꠖꠣꠞ ꠀꠝꠤꠢꠥꠖꠞ ꠙꠥꠀ ꠙꠖꠢꠦꠟ।” ");
INSERT INTO syls_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","ꠝꠣꠛꠥꠖꠦ ꠅꠃ ꠡꠞ꠆ꠖꠣꠞ ꠅꠇꠟꠞꠦ ꠎꠤꠝ꠆ꠝꠣꠖꠣꠞꠤ ꠡꠝꠎꠣꠁꠟꠣ, ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠎꠝꠤ-ꠎꠝꠣ ꠛꠣꠐꠤꠀ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","ꠛꠣꠖꠦ ꠎꠤꠞꠤꠢꠅ ꠐꠣꠃꠘꠞ ꠇꠣꠍꠣꠔ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠗꠣꠞꠅ ꠝꠥꠀꠛ ꠖꠦꠡꠞ ꠔꠟ ꠎꠣꠉꠣꠔ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠅꠃ ꠢꠥꠇꠥꠝ ꠖꠦꠅ, ꠔꠣꠞꠣ ꠎꠣꠞꠎꠤꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠎꠝꠤ-ꠎꠝꠣꠞ ꠛꠣꠐ ꠙꠣꠁꠀ ꠢꠣꠞꠟꠦ, ꠅꠔꠣ ꠕꠣꠇꠤ ꠇꠤꠍꠥ ꠐꠣꠃꠘ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠡꠞꠦ ꠖꠤꠟꠣꠁꠔꠣ, ꠄꠞꠣ ꠅꠘꠅ ꠞꠁꠛꠣ, ꠄꠞꠟꠉꠦ ꠛꠘ꠆ꠖꠞ ꠇꠤꠍꠥ ꠎꠝꠤꠅ ꠄꠞꠣꠞꠦ ꠖꠤꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","ꠅꠃ ꠐꠣꠃꠘꠅ ꠔꠣꠞꠣ ꠛꠡꠔ ꠇꠞꠛꠣ, ꠀꠞ ꠛꠘ꠆ꠖꠞ ꠎꠝꠤꠘꠅ ꠔꠣꠞꠣꠞ ꠙꠡꠥꠞ ꠙꠣꠟ ꠞꠣꠈꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","ꠔꠥꠝꠞꠣ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞꠦ ꠎꠦ ꠐꠣꠃꠘ ꠅꠇꠟ ꠖꠤꠛꠣꠄ, ꠁꠔꠣꠞ ꠛꠣꠃꠘ꠆ꠒꠞꠤ ꠅꠀꠟꠞ ꠛꠣꠞꠦ ꠔꠣꠞꠣꠞꠦ ꠀꠞꠅ ꠄꠇ ꠀꠎꠣꠞ ꠀꠔ ꠎꠣꠉꠣ ꠖꠤꠛꠣꠄ, ꠔꠣꠞꠣꠞ ꠙꠡꠥꠞ ꠙꠣꠟ ꠞꠣꠈꠣꠞ ꠟꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","ꠔꠥꠝꠞꠣ ꠎꠔ ꠐꠣꠃꠘ ꠔꠣꠞꠣꠞꠦ ꠖꠤꠛꠣꠄ, ꠁꠔꠣꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠞ ꠛꠣꠃꠘ꠆ꠒꠞꠤ ꠅꠀꠟꠞ ꠛꠣꠞꠦ, ꠝꠣꠘꠤ ꠃꠔꠞꠦ-ꠖꠃꠇꠘꠦ, ꠙꠥꠛꠦ-ꠙꠁꠌꠝꠦ, ꠢꠇ꠆ꠇꠟꠛꠣꠄ ꠀꠞꠅ ꠖꠥꠁ ꠀꠎꠣꠞ ꠀꠔ ꠛꠘ꠆ꠖꠞ ꠎꠣꠉꠣ ꠝꠣꠙꠤꠀ ꠖꠤꠅ। ꠅꠘꠅ ꠔꠣꠞꠣꠞ ꠙꠡꠥꠞ ꠙꠣꠟ ꠞꠣꠈꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“ꠔꠥꠝꠞꠣ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞꠦ ꠎꠦꠔꠣ ꠐꠣꠃꠘ ꠅꠇꠟ ꠖꠤꠛꠣꠄ, ꠄꠞꠝꠣꠎꠞ ꠍꠄꠈꠣꠘ ꠐꠣꠃꠘ ꠅꠁꠛ ꠈꠥꠘꠤ ꠝꠣꠘꠡꠞ ꠀꠡꠞꠄ ꠐꠣꠃꠘ। ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠀꠈꠔꠣ ꠇꠦꠃꠞꠞꠦ ꠝꠣꠞꠤꠟꠤꠟꠦ, ꠢꠦ ꠅꠃ ꠐꠣꠃꠘꠅ ꠉꠤꠀ ꠀꠡꠞꠄ ꠟꠁꠛ। ꠅꠃ ꠍꠄ ꠐꠣꠃꠘ ꠛꠣꠖꠦꠅ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞꠦ ꠀꠞꠅ ꠛꠦꠀꠟ꠆ꠟꠤꠡ ꠈꠣꠘ ꠐꠣꠃꠘ ꠖꠤꠟꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","ꠝꠥꠐ ꠀꠐꠌꠣꠟ꠆ꠟꠤꠡ ꠈꠣꠘ ꠐꠣꠃꠘ ꠟꠦꠛꠤ ꠅꠇꠟꠞꠦ ꠖꠤꠛꠣꠄ, ꠀꠞ ꠄꠞꠟꠉꠦ ꠙꠡꠥꠞ ꠙꠣꠟ ꠞꠣꠈꠣꠞ ꠛꠘ꠆ꠖꠞ ꠎꠣꠉꠣꠅ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠎꠝꠤ-ꠎꠝꠣ ꠕꠣꠇꠤ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞꠦ ꠎꠦꠛꠟꠣ ꠐꠣꠃꠘ ꠅꠇꠟ ꠖꠤꠛꠣꠄ, ꠅꠃ ꠡꠝꠄ ꠢꠇꠟ ꠈꠣꠘ꠆ꠖꠣꠘꠦ ꠙꠣꠅꠀ ꠎꠝꠤꠘꠞ ꠛꠣꠐ ꠕꠣꠇꠤ ꠔꠣꠞꠣꠞꠦ ꠖꠤꠛꠣꠄ। ꠎꠦ ꠈꠣꠘ꠆ꠖꠣꠘꠦ ꠛꠦꠡꠤ ꠙꠣꠁꠍꠦ ꠄꠞꠣ ꠛꠦꠡꠤ ꠖꠤꠛꠣ, ꠀꠞ ꠎꠦꠞꠣ ꠇꠝ ꠙꠣꠁꠍꠦ ꠄꠞꠣ ꠇꠝ ꠖꠤꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“ꠔꠥꠝꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠅ, ꠔꠥꠝꠞꠣ ꠎꠦꠛꠟꠣ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋ ꠙꠣꠞ ꠅꠁꠀ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠅ ꠉꠤꠀ ꠢꠣꠝꠣꠁꠛꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","ꠅꠃ ꠡꠝꠄ ꠔꠥꠝꠞꠣꠞ ꠘꠤꠎꠞ ꠟꠣꠉꠤ ꠇꠄꠈꠣꠘ ꠀꠡꠞꠄ ꠐꠣꠃꠘ ꠑꠤꠇ ꠇꠞꠤꠅ। ꠔꠦꠃ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠀꠈꠔꠣ ꠇꠎꠣ ꠇꠞꠤꠀ ꠇꠦꠃꠞꠞꠦ ꠈꠥꠘ ꠇꠞꠤꠟꠣꠄ, ꠔꠦ ꠜꠣꠉꠤꠀ ꠢꠘꠅ ꠉꠤꠀ ꠀꠡꠞꠄ ꠟꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","ꠈꠥꠘꠞ ꠛꠖꠟꠣ ꠟꠅꠞꠣ ꠝꠣꠘꠡꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠜꠣꠉꠤꠀ ꠎꠣꠘ ꠛꠣꠌꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠁ ꠀꠡꠞꠄ ꠐꠣꠃꠘ। ꠄꠔꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠀꠖꠣꠟꠔꠅ ꠛꠤꠌꠣꠞꠞ ꠀꠉ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠈꠥꠘꠞ ꠀꠡꠣꠝꠤꠞꠦ ꠇꠦꠃ ꠎꠣꠘꠦ ꠝꠣꠞꠣꠞ ꠡꠥꠎꠥꠉ ꠙꠣꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","ꠄꠞꠟꠣꠉꠤ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞꠦ ꠔꠥꠝꠞꠣ ꠎꠦ ꠐꠣꠃꠘ ꠅꠇꠟ ꠖꠤꠛꠣꠄ, ꠁꠔꠣꠞ ꠝꠣꠎꠞ ꠍꠄꠈꠣꠘ ꠐꠣꠃꠘ ꠅꠁꠛ ꠔꠥꠝꠞꠣꠞ ꠀꠡꠞꠄ ꠐꠣꠃꠘ। ");
INSERT INTO syls_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","ꠄꠞꠝꠣꠎꠞ ꠔꠤꠘꠈꠣꠘ ꠐꠣꠃꠘ ꠅꠁꠛ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠙꠥꠛꠞ ꠙꠣꠞꠅ, ꠀꠞ ꠔꠤꠘꠈꠣꠘ ꠅꠁꠛ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠞ ꠜꠤꠔꠞꠦ। ");
INSERT INTO syls_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","ꠅꠃ ꠍꠄꠅꠈꠣꠘ ꠐꠣꠃꠘ ꠅꠁꠛ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠟꠣꠉꠤ, ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠞꠅꠞꠣ ꠜꠤꠘ-ꠖꠦꠡꠤ ꠅꠇꠟꠞ ꠟꠣꠉꠤ ꠀꠞ ꠝꠥꠍꠣꠚꠤꠞ ꠅꠇꠟꠞ ꠟꠣꠉꠤ ꠀꠡꠞꠄ ꠐꠣꠃꠘ। ꠄꠞꠣꠞ ꠝꠣꠎꠞ ꠇꠦꠃ ꠎꠥꠖꠤ ꠀꠈꠔꠣ ꠛꠦ-ꠈꠤꠀꠟꠦ ꠇꠦꠃꠞꠞꠦ ꠈꠥꠘ ꠇꠞꠤꠟꠣꠄ, ꠔꠦ ꠅꠈꠣꠘꠅ ꠉꠤꠀ ꠎꠣꠘ ꠛꠣꠌꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“ꠅꠁꠟꠦ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠦ ꠎꠥꠖꠤ ꠟꠥꠀꠞ ꠇꠥꠘꠥ ꠀꠔꠤꠀꠞ ꠖꠤꠀ ꠇꠦꠃꠞꠞꠦ ꠝꠣꠞꠦ ꠀꠞ ꠢꠃ ꠎꠘ ꠝꠞꠤꠎꠣꠄ, ꠔꠦ ꠅꠉꠥ ꠈꠥꠘꠤ। ꠅꠃ ꠈꠥꠘꠤꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","ꠎꠦ ꠙꠣꠔ꠆ꠔꠞ ꠖꠤꠀ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠞꠦ ꠈꠥꠘ ꠇꠞꠣ ꠎꠣꠁꠛ, ꠁꠟꠣ ꠇꠥꠘꠥ ꠙꠣꠔ꠆ꠔꠞ ꠎꠥꠖꠤ ꠇꠦꠃꠞꠞ ꠀꠔꠅ ꠕꠣꠇꠦ, ꠀꠞ ꠅꠉꠥꠖꠤ ꠇꠦꠃꠞꠞꠦ ꠝꠣꠞꠣꠄ ꠢꠃ ꠝꠣꠘꠥꠡ ꠝꠞꠤꠎꠣꠄ, ꠔꠦ ꠅꠉꠥꠅ ꠈꠥꠘꠤ। ꠁ ꠈꠥꠘꠤꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","ꠝꠣꠘꠥꠡ ꠈꠥꠘ ꠅꠀꠞ ꠝꠔ ꠇꠥꠘꠥ ꠟꠣꠇꠠꠤꠞ ꠎꠤꠘꠤꠡ ꠎꠥꠖꠤ ꠇꠦꠃꠞꠞ ꠀꠔꠅ ꠕꠣꠇꠦ, ꠀꠞ ꠅꠉꠥ ꠖꠤꠀ ꠇꠦꠃꠞꠞꠦ ꠝꠣꠞꠣꠄ ꠢꠃ ꠝꠣꠘꠥꠡ ꠝꠞꠤꠎꠣꠄ, ꠔꠦ ꠅꠉꠥꠅ ꠈꠥꠘꠤ। ꠁ ꠈꠥꠘꠤꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","ꠈꠥꠘ ꠅꠀ ꠎꠘꠞ ꠀꠙꠘ ꠎꠦ ꠝꠣꠘꠡꠦ ꠁ ꠈꠥꠘꠞ ꠛꠖꠟꠣ ꠟꠅꠀꠞ ꠇꠕꠣ, ꠈꠣꠟꠤ ꠢꠦ-ꠃ ꠅꠃ ꠈꠥꠘꠤꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠤꠛ। ꠈꠥꠘꠤꠞ ꠖꠦꠈꠣ ꠙꠣꠁꠟꠦꠃ ꠔꠣꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","“ꠀꠞ ꠁꠋꠡꠣ ꠇꠞꠤꠀ ꠎꠥꠖꠤ ꠄꠇ ꠎꠘꠦ ꠀꠞꠇ ꠎꠘꠞꠦ ꠒꠦꠇ꠆ꠇꠣ ꠝꠣꠞꠦ, ꠛꠣ ꠇꠥꠘꠥꠎꠣꠔ ꠅꠡꠔ꠆ꠞꠖꠤ ꠁꠌ꠆ꠍꠣ ꠇꠞꠤꠀ ꠁꠐꠣ ꠝꠣꠞꠦ ꠀꠞ ꠢꠃ ꠝꠣꠘꠥꠡ ꠝꠞꠤꠎꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","ꠛꠣ ꠖꠥꠡꠝꠘꠤꠞ ꠜꠣꠛꠦ ꠇꠦꠃꠞꠞꠦ ꠊꠥꠡꠤ ꠝꠣꠞꠦ ꠀꠞ ꠢꠦ ꠝꠞꠤꠎꠣꠄ, ꠔꠦ ꠎꠦ ꠝꠣꠞꠍꠦ ꠢꠦ ꠈꠥꠘꠤ। ꠁ ꠈꠥꠘꠤꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠤꠛꠣꠄ। ꠈꠥꠘ ꠅꠀ ꠎꠘꠞ ꠀꠙꠘ ꠎꠦ ꠝꠣꠘꠡꠦ ꠁ ꠈꠥꠘꠞ ꠛꠖꠟꠣ ꠟꠅꠀꠞ ꠇꠕꠣ, ꠢꠦ ꠅꠃ ꠈꠥꠘꠤꠞ ꠟꠣꠉꠣꠟ ꠙꠣꠁꠟꠦꠃ ꠔꠣꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“ꠅꠁꠟꠦ ꠝꠘꠅ ꠇꠥꠘꠥ ꠖꠥꠡꠝꠘꠤ ꠘꠣ ꠞꠣꠈꠤꠀ ꠜꠥꠟꠦ ꠀꠈꠔꠣ ꠇꠦꠃꠞꠞꠦ ꠒꠦꠇ꠆ꠇꠣ ꠝꠣꠞꠟꠦ, ꠛꠣ ꠝꠘꠅ ꠇꠥꠘꠥ ꠈꠣꠞꠣꠙꠤ ꠘꠣ ꠕꠣꠇꠟꠦꠅ ꠜꠥꠟꠦ ꠔꠣꠞ ꠃꠙꠞꠦ ꠁꠐꠣ ꠝꠣꠞꠤ ꠖꠤꠟꠦ, ");
INSERT INTO syls_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","ꠛꠣ ꠘꠣ ꠖꠦꠈꠤꠀ, ꠝꠣꠘꠥꠡ ꠝꠞꠤꠎꠤꠛꠣꠞ ꠎꠥꠇꠣ ꠇꠥꠘꠥ ꠙꠣꠔ꠆ꠔꠞ ꠇꠦꠃꠞꠞ ꠃꠙꠞꠦ ꠚꠣꠟꠣꠁ ꠖꠤꠟꠦ ꠢꠦ ꠎꠥꠖꠤ ꠝꠞꠤꠎꠣꠄ, ꠔꠦ ꠇꠥꠘꠥꠎꠣꠔ ꠖꠥꠡꠝꠘꠤꠞ ꠜꠣꠛ ꠘꠣ ꠕꠣꠇꠣꠄ, ꠀꠞ ꠈꠦꠔꠤ ꠇꠞꠣꠞ ꠇꠥꠘꠥ ꠁꠌ꠆ꠍꠣ ꠘꠣ ꠕꠣꠇꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠀꠖꠣꠟꠔꠞ ꠝꠣꠘꠡꠦ, ꠅꠃ ꠈꠥꠘꠤꠞ ꠀꠞ ꠈꠥꠘꠞ ꠛꠖꠟꠣ ꠟꠅꠞꠣ ꠎꠘꠞ ꠛꠦꠙꠣꠞꠦ ꠅꠃ ꠘꠤꠅꠝ ꠝꠣꠘꠤꠀ ꠛꠤꠌꠣꠞ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","ꠅꠃ ꠡꠝꠄ ꠀꠖꠣꠟꠔꠞ ꠝꠣꠘꠡꠦ ꠈꠥꠘꠞ ꠛꠖꠟꠣ ꠟꠅꠞꠣꠞ ꠀꠔ ꠕꠣꠇꠤ ꠈꠥꠘꠤ ꠎꠘꠞꠦ ꠛꠣꠌꠣꠁꠛꠣ, ꠛꠣꠌꠣꠁꠀ ꠢꠦ ꠀꠉꠦ ꠎꠦꠈꠣꠘꠅ ꠜꠣꠉꠤꠀ ꠉꠦꠍꠤꠟ, ꠢꠃ ꠀꠡꠞꠄ ꠐꠣꠃꠘꠅ ꠔꠣꠞꠦ ꠢꠤꠞꠛꠣꠞ ꠙꠃꠍꠣꠁ ꠖꠤꠛꠣ। ꠀꠞ ꠙꠛꠤꠔ꠆ꠞ ꠔꠦꠟ ꠖꠤꠀ ꠈꠦꠟꠣꠚꠔꠤ ꠙꠣꠅꠀ ꠙꠞꠗꠣꠘ ꠁꠝꠣꠝ ꠍꠣꠛꠞ ꠝꠃꠔꠞ ꠀꠉ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠦ ꠢꠘꠅ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","ꠅꠁꠟꠦ ꠢꠦ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠡꠝꠄ ꠢꠃ ꠀꠡꠞꠄ ꠐꠣꠃꠘꠞ ꠛꠣꠞꠦ ꠛꠣꠞ ꠅꠁꠀ ꠎꠣꠄꠉꠤ, ");
INSERT INTO syls_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","ꠀꠞ ꠛꠖꠟꠣ ꠟꠅꠞꠣꠄ ꠔꠣꠞꠦ ꠙꠣꠁꠀ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠣꠄ, ꠔꠦ ꠢꠦ ꠈꠥꠘꠞ ꠖꠣꠄꠁ ꠅꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","ꠇꠣꠞꠘ ꠙꠞꠗꠣꠘ ꠁꠝꠣꠝꠞ ꠝꠃꠔ ꠘꠣ ꠅꠀ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠦ ꠀꠡꠞꠄ ꠐꠣꠃꠘꠅ ꠞꠅꠀꠞ ꠇꠕꠣ। ꠈꠣꠟꠤ ꠙꠞꠗꠣꠘ ꠁꠝꠣꠝꠞ ꠝꠃꠔꠞ ꠛꠣꠖꠦ ꠢꠦ ꠘꠤꠎꠞ ꠛꠣꠠꠤꠔ ꠚꠤꠞꠤꠀ ꠀꠁꠔ ꠙꠣꠞꠛ। ");
INSERT INTO syls_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","ꠔꠥꠝꠞꠣ ꠖꠦꠡꠞ ꠎꠦꠘꠅꠃ ꠛꠡꠔ ꠇꠞꠅ ꠘꠣ ꠇꠦꠘꠦ, ꠅꠀꠞꠤꠡꠞ ꠙꠞ ꠅꠀꠞꠤꠡ ꠗꠞꠤ ꠁꠔꠣ ꠝꠣꠘꠔꠦ ꠅꠁꠛ, ꠁꠔꠣ ꠔ ꠅꠁꠟ ꠔꠥꠝꠞꠣꠞ ꠡꠞꠤꠅꠔꠞ ꠄꠇꠐꠣ ꠀꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“ꠡꠣꠇ꠆ꠇꠤꠞ ꠎꠛꠣꠘꠛꠘ꠆ꠖꠤꠞ ꠃꠙꠞꠦ ꠘꠤꠞꠜꠞ ꠇꠞꠤꠀ ꠈꠥꠘꠤꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠣꠅꠀ ꠅꠁꠛ। ꠅꠁꠟꠦ ꠈꠣꠟꠤ ꠄꠇꠎꠘ ꠡꠣꠇ꠆ꠇꠤꠞ ꠇꠕꠣꠄ ꠇꠦꠃꠞꠞꠦ ꠝꠣꠞꠤꠟꠣꠅꠀ ꠎꠣꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","ꠝꠃꠔꠃ ꠎꠣꠞ ꠙꠣꠅꠘꠣ ꠡꠣꠎꠣ, ꠁꠟꠣ ꠇꠥꠘꠥ ꠈꠥꠘꠤꠞꠦ ꠇꠥꠘꠥꠝꠘ꠆ꠔꠦꠃ ꠐꠦꠇꠣꠞ ꠛꠖꠟꠣ ꠈꠣꠟꠣꠍ ꠖꠦꠅꠀ ꠎꠣꠁꠔ ꠘꠣꠄ। ꠔꠣꠞꠦ ꠎꠣꠘꠦ ꠝꠣꠞꠤꠟꠤꠔꠦꠃ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","ꠀꠡꠞꠄ ꠐꠣꠃꠘꠅ ꠞꠅꠞꠣ ꠇꠥꠘꠥ ꠀꠡꠣꠝꠤꠞꠦ ꠐꠦꠇꠣꠞ ꠛꠖꠟꠣ, ꠙꠞꠗꠣꠘ ꠁꠝꠣꠝꠞ ꠝꠃꠔꠞ ꠀꠉꠦ ꠔꠣꠞ ꠘꠤꠎꠞ ꠛꠣꠠꠤꠔ ꠚꠤꠞꠣꠁ ꠀꠘꠣ ꠎꠣꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠁꠔꠣ ꠇꠞꠤꠀ ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠖꠦꠡꠞ ꠝꠣꠐꠤꠞꠦ ꠘꠣꠙꠣꠇ ꠇꠞꠤꠅ ꠘꠣ। ꠎꠣꠘ ꠔ, ꠈꠥꠘꠞ ꠟꠃꠄ ꠖꠦꠡ ꠘꠣꠙꠣꠇ ꠅꠁꠎꠣꠄ। ꠀꠞ ꠎꠦ ꠖꠦꠡꠅ ꠈꠥꠘꠞ ꠟꠃ ꠏꠞꠍꠦ, ꠢꠃ ꠈꠥꠘꠤꠞ ꠟꠃ ꠍꠣꠠꠣ ꠀꠞ ꠇꠥꠘꠥꠝꠘ꠆ꠔꠦꠃ ꠢꠤ ꠖꠦꠡꠞ ꠘꠣꠙꠣꠇꠤꠞ ꠇꠚꠞꠣ ꠅꠄ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","ꠀꠞ ꠔꠥꠝꠞꠣ ꠎꠦ ꠖꠦꠡꠅ ꠞꠁꠛꠣꠄ ꠀꠝꠤꠅ ꠔ ꠢꠘꠅ ꠞꠁꠝꠥ, ꠄꠞꠟꠣꠉꠤ ꠁ ꠖꠦꠡꠞꠦ ꠘꠣꠙꠣꠇ ꠛꠣꠘꠣꠁꠅ ꠘꠣ। ꠇꠣꠞꠘ ꠀꠝꠤ ꠝꠣꠛꠥꠖ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠎꠦ ꠛꠡꠔ ꠇꠞꠤ।” ");
INSERT INTO syls_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","ꠁꠃꠍꠥꠚ ꠘꠛꠤꠞ ꠀꠅꠟꠣꠖꠞ ꠈꠣꠘ꠆ꠖꠣꠘ ꠅꠇꠟ ꠕꠣꠇꠤ, ꠝꠣꠘꠡꠣꠞ ꠘꠣꠔꠤ ꠝꠣꠈꠤꠞꠞ ꠙꠥꠀ ꠉꠤꠟꠤꠅꠖ ꠉꠥꠡ꠆ꠐꠤꠞ ꠘꠣꠘꠣꠘ ꠙꠞꠤꠛꠣꠞ ꠕꠣꠇꠤ ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟ ꠀꠁꠟꠣ, ꠀꠁꠀ ꠔꠣꠞꠣ ꠝꠥꠍꠣ ꠘꠛꠤ ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠘꠣꠘꠣꠘ ꠉꠥꠡ꠆ꠐꠤꠞ ꠡꠞ꠆ꠖꠣꠞ ꠅꠇꠟꠞ ꠟꠉꠦ ꠝꠣꠔꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠦ ꠀꠝꠞꠣꠞ ꠁ ꠝꠣꠟꠤꠇꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠟꠐꠣꠞꠤ ꠝꠣꠞꠤꠀ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠎꠦ ꠖꠦꠡꠞ ꠎꠣꠉꠣ-ꠎꠝꠤꠘ ꠛꠣꠐꠤꠀ ꠖꠤꠔꠣ। ꠖꠤꠛꠣꠞ ꠡꠝꠄ ꠀꠝꠞꠣꠞ ꠜꠣꠁ ꠎꠟꠣꠙꠈꠣꠖꠞ ꠎꠝꠤ-ꠎꠝꠣ ꠈꠣꠘꠣꠁꠘ ꠔꠣꠞ ꠙꠥꠠꠤꠘ꠆ꠔꠞꠦ ꠖꠤꠛꠣꠞ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","ꠅꠁꠟꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠖꠥꠍꠞꠣ ꠇꠥꠘꠥ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠡꠞ ꠟꠉꠦ ꠎꠥꠖꠤ ꠅꠃ ꠙꠥꠠꠤꠘ꠆ꠔꠞ ꠛꠤꠀ ꠅꠄ, ꠔꠦ ꠀꠝꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠍꠣꠝꠣꠘꠣ ꠕꠣꠇꠤ ꠔꠣꠞꠣꠞ ꠍꠣꠝꠣꠘꠣ ꠛꠣꠞ ꠅꠁꠀ ꠉꠤꠀ, ꠔꠣꠞꠣꠞ ꠎꠣꠝꠣꠁꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠎꠝꠤ-ꠎꠝꠣꠔ ꠢꠣꠝꠣꠁꠎꠤꠛ, ꠄꠔꠦ ꠀꠝꠞꠣꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠎꠝꠤ-ꠝꠤꠞꠣꠡꠞ ꠇꠤꠍꠥ ꠅꠋꠡ ꠇꠝꠤꠎꠤꠛ। ");
INSERT INTO syls_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠎꠝꠤ-ꠝꠤꠞꠣꠡ ꠚꠤꠞꠔ ꠙꠣꠅꠀꠞ ꠢꠃ ꠙꠛꠤꠔ꠆ꠞ ꠙꠁꠘ꠆ꠌꠣꠡ ꠛꠍꠞꠞ ꠇꠣꠟꠅ, ꠔꠣꠞꠣꠞ ꠎꠝꠤ-ꠎꠝꠣ ꠉꠤꠀ ꠔ ꠔꠣꠞꠣꠞ ꠎꠣꠝꠣꠁꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠍꠣꠝꠣꠘꠣ ꠅꠁꠎꠤꠛ। ꠅꠃ ꠟꠣꠈꠣꠘ ꠀꠝꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠎꠝꠤ-ꠝꠤꠞꠣꠡ ꠕꠣꠇꠤ ꠔꠣꠞꠣꠞ ꠅꠋꠡ ꠛꠣꠞ ꠅꠁꠀ ꠎꠣꠁꠛꠉꠤ।” ");
INSERT INTO syls_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠝꠥꠍꠣꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠇꠁꠟꠣ, “ꠁꠃꠍꠥꠚꠞ ꠀꠅꠟꠣꠖꠞ ꠅꠃ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠡꠦ ꠎꠦꠔꠣ ꠇꠁꠞꠣ, ꠁꠔꠣ ꠔ ꠢꠣꠍꠣ। ");
INSERT INTO syls_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","ꠄꠞꠟꠣꠉꠤ ꠎꠟꠣꠙꠈꠣꠖꠞ ꠙꠥꠠꠤꠘ꠆ꠔꠞ ꠛꠦꠙꠣꠞꠦ ꠝꠣꠛꠥꠖꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠞꠣ, ꠔꠣꠞꠣ ꠎꠣꠞꠦ ꠙꠍꠘ꠆ꠖ ꠇꠞꠂꠘ ꠔꠣꠞ ꠉꠦꠍꠦꠃ ꠛꠤꠀ ꠛꠁꠔꠣ ꠙꠣꠞꠛꠣ। ꠅꠁꠟꠦ ꠡꠞ꠆ꠔ ꠅꠁꠟ, ꠔꠣꠞꠣꠞ ꠛꠣꠚꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠜꠤꠔꠞꠦ ꠛꠤꠀ ꠛꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠎꠝꠤ-ꠝꠤꠞꠣꠡ ꠄꠇ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠣꠇꠤ ꠀꠞꠇ ꠈꠣꠘ꠆ꠖꠣꠘꠅ ꠎꠣꠁꠔ ꠙꠣꠞꠔ ꠘꠣꠄ। ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠙꠞꠔꠦꠇ ꠎꠘꠦ ꠔꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠎꠝꠤ-ꠝꠤꠞꠣꠡ ꠛꠣꠌꠣꠘꠤ ꠟꠣꠉꠛ। ");
INSERT INTO syls_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠙꠞꠔꠦꠇꠦ ꠎꠣꠔꠦ ꠔꠣꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠙꠣꠅꠀ ꠎꠝꠤ-ꠎꠝꠣꠞ ꠝꠣꠟꠤꠇꠣꠘꠣ ꠐꠤꠇꠣꠁ ꠞꠣꠈꠔ ꠙꠣꠞꠦ, ꠅꠔꠣꠞ ꠟꠣꠉꠤ ꠙꠞꠔꠦꠇ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠎꠝꠤ-ꠎꠝꠣꠞ ꠝꠣꠟꠤꠇꠣꠘꠣ ꠙꠣꠅꠀ ꠙꠥꠠꠤꠘ꠆ꠔꠦ ꠔꠣꠞꠣꠞ ꠛꠣꠚꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠘꠡꠣꠞ ꠉꠦꠍꠦ ꠛꠤꠀ ꠛꠁꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","ꠄꠇ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠣꠇꠤ ꠀꠞꠇ ꠈꠣꠘ꠆ꠖꠣꠘꠅ ꠇꠥꠘꠥ ꠎꠝꠤ-ꠎꠝꠣ ꠎꠣꠁꠔ ꠘꠣꠄ। ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠙꠞꠔꠦꠇ ꠈꠣꠘ꠆ꠖꠣꠘꠦ ꠔꠣꠞꠣꠞ ꠎꠝꠤ-ꠎꠝꠣꠞ ꠝꠣꠟꠤꠇꠣꠘꠣ ꠗꠞꠤꠀ ꠞꠣꠈꠔꠦ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠎꠟꠣꠙꠈꠣꠖꠞ ꠙꠥꠠꠤꠘ꠆ꠔꠦ ꠅꠟꠣ ꠝꠣꠘꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","ꠔꠣꠞꠣꠞ ꠛꠣꠚꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠞ ꠉꠦꠍꠦ ꠛꠤꠀ ꠛꠁꠟꠣ। ꠎꠟꠣꠙꠈꠣꠖꠞ ꠙꠥꠠꠤꠘ꠆ꠔꠞ ꠘꠣꠝ ꠅꠁꠟ, ꠝꠢꠟꠣ, ꠔꠤꠞꠎꠣ, ꠢꠉꠟꠣ, ꠝꠤꠟꠇꠣ, ꠀꠞ ꠘꠥꠀ। ");
INSERT INTO syls_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","ꠁꠃꠍꠥꠚꠞ ꠙꠥꠀ ꠝꠣꠘꠡꠣꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠉꠥꠡ꠆ꠐꠤ ꠅꠇꠟꠞ ꠝꠣꠎꠦꠃ ꠔꠣꠞꠣ ꠛꠤꠀ ꠛꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","ꠀꠞ ꠢꠥꠘꠅ, ꠎꠤꠞꠤꠢꠅ ꠄꠟꠣꠇꠣꠞ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠗꠣꠞꠅ ꠝꠥꠀꠛ ꠖꠦꠡꠞ ꠔꠟ ꠎꠣꠉꠣꠔ, ꠝꠣꠛꠥꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠞ ꠝꠣꠎꠖꠤ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠅꠃ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠀꠞ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠅꠇꠟ ꠖꠤꠍꠟꠣ॥");
INSERT INTO syls_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠙꠥꠛ ꠙꠣꠞꠞ ꠀꠞꠣꠛꠣ ꠘꠣꠝꠞ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠎꠣꠔꠤꠞꠦ ꠅꠃ ꠛꠄꠀꠘ ꠇꠞꠍꠟꠣ, ꠔꠣꠁꠘ ꠡꠥꠚ ꠉꠣꠃꠞ ꠍꠣꠝꠘꠦ ꠃꠛꠣꠁꠀ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠝꠣꠔꠤꠟꠣ। ꠄꠞ ꠄꠇꠛꠣꠄ ꠀꠍꠤꠟ ꠚꠣꠞꠣꠘ, ꠀꠞ ꠅꠁꠘ꠆ꠘꠛꠣꠄ ꠀꠍꠤꠟ ꠔꠥꠚꠟ, ꠟꠣꠛꠘ, ꠢꠣꠎꠤꠞꠥꠔ ꠀꠞ ꠖꠤꠎꠣꠢꠣꠛ, ꠅꠃ ꠌꠣꠁꠞ ꠉꠣꠃ। ");
INSERT INTO syls_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","ꠍꠦꠁꠞꠞ ꠙꠣꠠꠤꠀ ꠙꠕꠦꠖꠤ ꠔꠥꠞ ꠙꠣꠠ ꠕꠣꠇꠤ ꠇꠣꠖꠦꠡ-ꠛꠞꠘꠦꠀ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠀꠐꠤꠀ ꠎꠣꠁꠔꠦ ꠈꠣꠟꠤ ꠄꠉꠣꠞꠅ ꠖꠤꠘ ꠟꠣꠉꠦ। ");
INSERT INTO syls_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","ꠅꠁꠟꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁꠀ ꠃꠘꠌꠣꠟ꠆ꠟꠤꠡ ꠛꠍꠞ ꠄꠉꠣꠞꠅ ꠝꠣꠡ ꠙꠞ꠆ꠎꠘ꠆ꠔ, ꠅꠞ꠆ꠕꠣꠔ ꠍꠚꠞꠞ ꠌꠣꠟ꠆ꠟꠤꠡ ꠛꠞꠍ ꠌꠟꠣꠞ ꠇꠣꠟꠅ, ꠅꠘꠅ ꠊꠥꠞꠤꠟꠣ। ꠛꠣꠖꠦ ꠅꠃ ꠝꠣꠡꠞ ꠙꠄꠟꠣ ꠔꠣꠞꠤꠈꠅ ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠔꠣꠞꠣꠞꠦ ꠎꠣꠘꠣꠁꠟꠣ ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘꠞꠦ ꠎꠦꠔꠣ ꠇꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","ꠔꠣꠁꠘ ꠟꠣꠠꠣꠁ ꠇꠞꠤ ꠀꠝꠥꠞꠤ ꠅꠇꠟꠞ ꠛꠣꠖꠡꠣ ꠍꠤꠢꠥꠘꠞꠦ ꠀꠞ ꠛꠣꠡꠘ ꠖꠦꠡꠞ ꠛꠣꠖꠡꠣ ꠃꠎꠞꠦ ꠀꠞꠣꠁꠀ ꠢꠣꠞꠟꠦ ꠁꠔꠣ ꠇꠁꠟꠣ। ꠅꠃ ꠍꠤꠢꠥꠘꠦ ꠛꠣꠖꠡꠣꠁ ꠇꠞꠔꠣ ꠢꠤꠡꠛꠘ ꠐꠣꠃꠘꠅ, ꠀꠞ ꠃꠎꠦ ꠛꠣꠖꠡꠣꠁ ꠇꠞꠔꠣ ꠅꠡ꠆ꠐꠣꠞꠥꠔ ꠀꠞ ꠁꠖꠞꠤ ꠐꠣꠃꠘꠅ। ");
INSERT INTO syls_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠙꠥꠛ ꠙꠣꠞꠞ ꠝꠥꠀꠛ ꠖꠦꠡꠅ, ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠀꠟ꠆ꠟꠣꠞ ꠖꠦꠅꠀ ꠔꠃꠞꠣꠔꠞ ꠔꠣꠟꠤꠝ ꠛꠄꠀꠘ ꠇꠞꠤꠀ ꠛꠥꠎꠣꠁꠟꠣ। ꠔꠣꠁꠘ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“ꠅ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ, ꠢꠥꠘꠅ, ꠀꠝꠞꠣ ꠔꠥꠞ ꠙꠣꠠꠞ ꠉꠣꠟꠣꠔ ꠕꠣꠇꠣꠞ ꠇꠣꠟꠅ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠀꠝꠞꠣꠞꠦ ꠇꠁꠍꠟꠣ, ꠅꠃ ꠙꠣꠠꠞ ꠉꠣꠟꠣꠔ ꠔꠥꠝꠞꠣꠞ ꠛꠃꠔ ꠖꠤꠘ ꠉꠥꠎꠞꠤ ꠉꠦꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","ꠔꠦ ꠅꠈꠘ ꠔꠥꠝꠞꠣ ꠢꠇꠟꠦ ꠔꠣꠝ꠆ꠛꠥ ꠔꠥꠟꠤꠀ ꠀꠝꠥꠞꠤ ꠅꠇꠟꠞ ꠙꠣꠠꠤꠀ ꠄꠟꠣꠇꠣ ꠀꠞ ꠅꠃ ꠄꠟꠣꠇꠣꠞ ꠇꠣꠘ꠆ꠖꠣ-ꠇꠣꠍꠣꠞ ꠢꠇꠟ ꠎꠣꠉꠣꠔ ꠎꠣꠅꠀꠞ ꠟꠣꠉꠤ ꠞꠅꠀꠘꠣ ꠅꠅ। ꠁ ꠎꠣꠉꠣ ꠢꠇꠟꠔꠣ ꠅꠁꠟ ꠉꠤꠀ: ꠀꠞꠣꠛꠣ ꠝꠞꠥꠜꠥꠝꠤ ꠀꠞ ꠅꠃ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠇꠣꠘ꠆ꠖꠣ-ꠇꠣꠍꠣꠞ ꠃꠌꠣ ꠙꠣꠠꠤꠀ ꠎꠣꠉꠣ ꠀꠞ ꠘꠤꠌꠣ ꠙꠣꠠꠤꠀ ꠎꠣꠉꠣ, ꠘꠦꠉꠦꠜ ꠝꠞꠥꠜꠥꠝꠤ ꠀꠞ ꠖꠞꠤꠀꠞ ꠇꠤꠘꠣꠞꠣ, ꠝꠣꠘꠤ ꠇꠦꠘꠣꠘ ꠖꠦꠡ ꠕꠣꠇꠤ ꠀꠞꠝ꠆ꠛ ꠇꠞꠤꠀ ꠟꠦꠛꠣꠘꠘ ꠖꠦꠡ ꠅꠁꠀ ꠚꠥꠞꠣꠔ ꠉꠣꠋ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠁꠔꠣ ꠢꠇꠟ ꠎꠣꠉꠣ। ");
INSERT INTO syls_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠁꠔꠣ ꠢꠇꠟ ꠎꠣꠉꠣ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠤꠟꠣꠁꠍꠤ। ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠁꠘ ꠁꠛ꠆ꠞꠣꠢꠤꠝ, ꠁꠍꠢꠣꠇ, ꠁꠀꠇꠥꠛ ꠀꠞ ꠔꠣꠞꠣꠞ ꠈꠣꠘ꠆ꠖꠣꠘꠞꠦ ꠎꠦ ꠖꠦꠡ ꠖꠦꠅꠀꠞ ꠅꠀꠖꠣ ꠇꠞꠍꠟꠣꠝ, ꠔꠥꠝꠞꠣ ꠅꠈꠘ ꠉꠤꠀ ꠁꠔꠣ ꠢꠇꠟ ꠎꠣꠉꠣ ꠖꠈꠟ ꠇꠞꠤꠟꠣꠅ। ");
INSERT INTO syls_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","“ꠔꠦ ꠜꠣꠁꠀꠁꠘꠞꠦ, ꠢꠃ ꠡꠝꠄ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠇꠁꠍꠟꠣꠝ, ꠔꠥꠝꠞꠣ ꠢꠇꠟꠞ ꠜꠣꠞ ꠔ ꠀꠝꠤ ꠄꠇꠟꠣ ꠛꠁꠛꠣꠞ ꠡꠣꠁꠖ꠆ꠖ ꠘꠣꠁ। ");
INSERT INTO syls_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞꠦ ꠅꠔ ꠀꠅꠟꠣꠖ ꠛꠣꠠꠣꠁ ꠖꠤꠍꠂꠘ, ꠄꠞꠟꠣꠉꠤ ꠔꠥꠝꠞꠣ ꠀꠁꠎ ꠀꠍꠝꠣꠘꠞ ꠔꠦꠞꠣꠞ ꠟꠣꠈꠣꠘ ꠅꠁꠍ, ꠉꠘꠤꠀ ꠚꠥꠠꠣꠁꠟ ꠎꠣꠄ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","ꠔꠥꠝꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞꠦ ꠀꠞꠅ ꠀꠎꠣꠞ ꠀꠎꠣꠞ ꠉꠥꠘ ꠛꠣꠠꠣꠃꠇ꠆ꠇꠣ, ꠀꠞ ꠔꠣꠘ ꠅꠀꠖꠣ ꠝꠣꠚꠤꠇ ꠔꠥꠝꠞꠣꠞꠦ ꠞꠢꠝ-ꠛꠞꠇꠔ ꠖꠦꠃꠇ꠆ꠇꠣ। ");
INSERT INTO syls_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","ꠅꠁꠟꠦ ꠀꠝꠤ ꠄꠇꠟꠣ ꠇꠦꠝꠘꠦ ꠔꠥꠝꠞꠣꠞ ꠇꠣꠁꠎ꠆ꠎꠣ-ꠚꠍꠣꠖ ꠝꠤꠐꠣꠁꠔꠣꠝ, ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠎꠤꠝ꠆ꠝꠣꠖꠣꠞꠤꠞ ꠜꠣꠞ ꠛꠁꠔꠣꠝ? ");
INSERT INTO syls_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","ꠄꠞꠟꠣꠉꠤ ꠔꠥꠝꠞꠣꠞ ꠙꠞꠔꠦꠇ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠣꠇꠤ ꠇꠄꠎꠘ ꠀꠈꠟꠖꠣꠞ, ꠎꠣꠘꠞꠣ-ꠢꠥꠘꠞꠣ ꠀꠞ ꠢꠇꠟ ꠝꠣꠘꠡꠞ ꠉꠦꠍꠦ ꠁꠎ꠆ꠎꠔꠤ ꠎꠘꠞꠦ ꠙꠍꠘ꠆ꠖ ꠇꠞꠅ, ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠎꠤꠝ꠆ꠝꠣꠖꠣꠞꠤ ꠄꠞꠣꠞ ꠀꠔꠅ ꠡꠝꠎꠣꠁꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","“ꠔꠥꠝꠞꠣ ꠎꠥꠀꠙ ꠖꠤꠍꠟꠣꠄ, ꠀꠁꠌ꠆ꠍꠣ, ꠀꠙꠘꠦ ꠎꠦꠟꠣ ꠇꠁꠞꠣ, ꠅꠟꠣꠃ ꠜꠣꠟꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","ꠔꠦꠃ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠙꠞꠔꠦꠇ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠣꠇꠤ ꠀꠈꠟꠖꠣꠞ, ꠛꠥꠖ꠆ꠖꠤꠝꠣꠘ ꠀꠞ ꠎꠣꠘꠞꠣ-ꠢꠥꠘꠞꠣ ꠎꠘꠞꠦ ꠘꠤꠀ ꠔꠥꠝꠞꠣꠞ ꠀꠎꠣꠞ ꠎꠘꠞ ꠃꠙꠞꠦ, ꠡ ꠎꠘꠞ ꠃꠙꠞꠦ, ꠙꠁꠘ꠆ꠌꠣꠡ ꠎꠘꠞ ꠃꠙꠞꠦ, ꠖꠡ ꠎꠘꠞ ꠃꠙꠞꠦ ꠡꠞ꠆ꠖꠣꠞ ꠛꠣꠘꠣꠁ ꠖꠤꠍꠟꠣꠝ, ꠀꠞ ꠅꠚꠤꠡꠣꠞ ꠛꠅꠀꠁꠟ ꠇꠞꠍꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","“ꠢꠃ ꠡꠝꠄ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠢꠣꠇꠤꠝ ꠅꠇꠟꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣꠝ, ꠇꠁꠍꠟꠣꠝ, ꠇꠣꠁꠎ꠆ꠎꠣ-ꠚꠍꠣꠖꠞ ꠛꠤꠌꠣꠞꠅ ꠛꠣꠖꠤ-ꠛꠤꠛꠣꠖꠤ ꠖꠥꠁꠅ ꠙꠇ꠆ꠇꠞ ꠝꠣꠔ ꠢꠥꠘꠤꠀ ꠢꠇ ꠁꠘꠍꠣꠚ ꠇꠞꠤꠅ, ꠁꠔꠣ ꠘꠤꠎꠞ ꠎꠣꠔꠤꠞ ꠅꠃꠇ ꠛꠣ ꠜꠤꠘ ꠎꠣꠔꠤꠞ ꠅꠃꠇ। ");
INSERT INTO syls_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","ꠛꠤꠌꠣꠞꠞ ꠡꠝꠄ ꠔꠥꠝꠞꠣ ꠇꠦꠃꠞꠞ ꠙꠇ꠆ꠇ ꠟꠁꠅ ꠘꠣ, ꠗꠘꠤ-ꠉꠞꠤꠛ ꠢꠇꠟꠞ ꠇꠕꠣ ꠢꠥꠘꠤꠅ। ꠀꠍꠟꠦ ꠛꠤꠌꠣꠞꠞ ꠝꠣꠟꠤꠇ ꠔ ꠀꠟ꠆ꠟꠣ, ꠄꠞꠟꠣꠉꠤ ꠔꠥꠝꠞꠣ ꠇꠥꠘꠥ ꠝꠣꠘꠡꠞꠦ ꠒꠞꠣꠁꠅ ꠘꠣ। ꠎꠦ ꠛꠤꠌꠣꠞꠞ ꠝꠤꠝꠣꠋꠡꠣ ꠇꠞꠣ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠇꠑꠤꠘ ꠅꠄ, ꠁꠈꠣꠘ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠀꠘꠤꠅ, ꠀꠝꠤ ꠖꠦꠈꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","ꠀꠞ ꠔꠥꠝꠞꠣ ꠇꠤꠟꠣ ꠇꠤꠔꠣ ꠇꠞꠔꠣꠄ, ꠁꠔꠣ ꠔ ꠀꠝꠤ ꠢꠃ ꠡꠝꠄ ꠇꠁꠀ ꠖꠤꠍꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","“ꠛꠣꠖꠦ ꠀꠝꠞꠣ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠢꠥꠇꠥꠝ ꠙꠣꠁꠀ, ꠔꠥꠞ ꠙꠣꠠ ꠍꠣꠠꠤꠀ ꠀꠝꠥꠞꠤ ꠅꠇꠟꠞ ꠙꠣꠠꠤꠀ ꠄꠟꠣꠇꠣ ꠝꠥꠈꠣ ꠞꠅꠀꠘꠣ ꠅꠁꠟꠣꠝ। ꠔꠥꠝꠞꠣ ꠔ ꠖꠦꠈꠍ, ꠇꠔ ꠛꠠ ꠀꠞ ꠇꠔ ꠝꠣꠞꠣꠔ꠆ꠔꠇ ꠝꠞꠥꠜꠥꠝꠤ ꠙꠣꠞ ꠅꠁꠀ ꠀꠝꠞꠣ ꠇꠣꠖꠦꠡ-ꠛꠞꠘꠦꠀ ꠀꠁꠀ ꠀꠎꠤꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","ꠀꠎꠤꠀ ꠢꠣꠞꠤ ꠀꠝꠤ ꠇꠁꠍꠟꠣꠝ, ꠅꠈꠘ ꠔ ꠔꠥꠝꠞꠣ ꠀꠝꠥꠞꠤ ꠅꠇꠟꠞ ꠢꠃ ꠙꠣꠠꠤꠀ ꠄꠟꠣꠇꠣꠔ ꠀꠁꠀ ꠙꠃꠍꠤ ꠉꠦꠍ, ꠁ ꠖꠦꠡꠈꠣꠘ ꠀꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠀꠝꠞꠣꠞꠦ ꠖꠤꠟꠣꠁꠞꠣ। ");
INSERT INTO syls_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","ꠢꠥꠘꠅ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠖꠣꠘ ꠇꠞꠣ ꠅꠃ ꠀꠡ꠆ꠔꠣ ꠖꠦꠡꠃ ꠔꠥꠝꠞꠣꠞ ꠍꠣꠝꠘꠦ ꠙꠠꠤ ꠞꠁꠍꠦ। ꠅꠈꠘ ꠎꠣꠅ, ꠉꠤꠀ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠅꠀꠖꠣ ꠇꠞꠣ ꠅꠃ ꠖꠦꠡꠞꠦ ꠖꠈꠟ ꠇꠞꠅ। ꠇꠦꠃ ꠒꠞꠣꠁꠅ ꠘꠣ, ꠘꠤꠞꠣꠡ ꠅꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","“ꠅꠃ ꠡꠝꠄ ꠔꠥꠝꠞꠣ ꠢꠇꠟ ꠀꠁꠀ ꠀꠝꠣꠞꠦ ꠇꠁꠟꠣꠄ, ꠔꠦ ꠙꠄꠟꠣ ꠇꠄꠎꠘ ꠉꠥꠁꠀꠞꠦ ꠅꠃ ꠖꠦꠡꠅ ꠙꠣꠑꠣꠁꠟ ꠅꠃꠇ, ꠔꠣꠞꠣ ꠉꠤꠀ ꠖꠦꠡꠈꠣꠘ ꠖꠦꠈꠤꠀ ꠀꠁꠀ ꠀꠝꠞꠣꠞꠦ ꠇꠁꠛꠣ, ꠇꠥꠘ ꠙꠕꠦ ꠎꠣꠅꠀ ꠀꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠜꠣꠟꠣ ꠀꠞ ꠎꠣꠅꠀꠞ ꠙꠕꠅ ꠇꠥꠘ ꠇꠥꠘ ꠐꠣꠃꠘ ꠙꠠꠛ। ");
INSERT INTO syls_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","“ꠔꠥꠝꠞꠣꠞ ꠙꠞꠣꠝꠤꠡ ꠀꠝꠣꠞ ꠙꠍꠘ꠆ꠖ ꠅꠁꠟ, ꠄꠞꠟꠣꠉꠤ ꠙꠞꠔꠦꠇ ꠈꠣꠘ꠆ꠖꠣꠘ ꠕꠣꠇꠤ ꠄꠇꠎꠘ ꠇꠞꠤ ꠝꠥꠐ ꠛꠣꠞꠅ ꠎꠘꠞꠦ ꠀꠟꠉ ꠇꠞꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","ꠔꠣꠞꠣ ꠔꠥꠝꠞꠣꠞꠦ ꠅꠘꠅ ꠕꠁꠀ ꠅꠃ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠃꠑꠟ, ꠀꠞ ꠀꠡꠇꠥꠟ ꠘꠣꠝꠞ ꠙꠣꠠꠤꠀ ꠈꠣꠟꠅ ꠉꠤꠀ ꠜꠣꠟꠣ ꠇꠞꠤ ꠢꠇꠟꠔꠣ ꠖꠦꠈꠤꠀ ꠀꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","ꠔꠣꠞꠣ ꠢꠃ ꠖꠦꠡ ꠕꠣꠇꠤ ꠇꠤꠍꠥ ꠚꠟ-ꠝꠥꠟ ꠀꠘꠤꠀ ꠀꠝꠞꠣꠞꠦ ꠖꠦꠈꠣꠁꠀ ꠇꠁꠟ, ꠀꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠀꠝꠞꠣꠞꠦ ꠎꠦ ꠖꠦꠡꠈꠣꠘ ꠖꠣꠘ ꠇꠞꠞꠣ, ꠁꠈꠣꠘ ꠔ ꠛꠠ ꠜꠣꠟꠣ ꠎꠣꠉꠣ। ");
INSERT INTO syls_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","“ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣ ꠅꠃ ꠖꠦꠡꠅ ꠎꠣꠁꠔꠦ ꠞꠣꠎꠤ ꠅꠁꠟꠣꠄ ꠘꠣ। ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠢꠥꠇꠥꠝꠞ ꠛꠤꠞꠥꠗꠤꠔꠣ ꠇꠞꠟꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","ꠔꠥꠝꠞꠣ ꠎꠣꠞꠎꠤꠞ ꠔꠣꠝ꠆ꠛꠥꠔ ꠢꠣꠝꠣꠁꠀ ꠛꠇꠣ-ꠎꠇꠣ ꠡꠥꠞꠥ ꠇꠞꠟꠣꠄ, ꠀꠞ ꠇꠁꠟꠣꠄ, ꠝꠣꠛꠥꠖꠦ ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠖꠥꠡꠝꠘꠤ ꠇꠞꠂꠘ, ꠄꠞꠟꠣꠉꠤꠃ ꠀꠝꠞꠣꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ, ꠀꠝꠥꠞꠤ ꠅꠇꠟꠞ ꠀꠔꠅ ꠚꠣꠟꠣꠁꠀ ꠝꠣꠞꠣꠞ ꠈꠤꠀꠟꠦ, ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠔꠣꠁꠘ ꠀꠝꠞꠣꠞꠦ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","ꠀꠝꠞꠣ ꠇꠤꠟꠣ ꠢꠤꠘꠅ ꠎꠣꠁꠝꠥ? ꠀꠝꠞꠣꠞ ꠉꠥꠁꠀ ꠜꠣꠁꠀꠁꠘ꠆ꠔꠦ ꠀꠁꠀ ꠎꠣꠘꠅ ꠒꠞ ꠢꠣꠞꠣꠁ ꠖꠤꠍꠂꠘ। ꠔꠣꠞꠣ ꠇꠁꠍꠂꠘ, ꠢꠤꠘꠞ ꠝꠣꠘꠥꠡ ꠛꠥꠟꠦ ꠀꠝꠞꠣ ꠕꠣꠇꠤ ꠛꠃꠔ ꠃꠌꠣ-ꠝꠥꠐꠣ ꠙꠄꠟꠥꠀꠘ। ꠔꠣꠞꠣꠞ ꠐꠣꠃꠘ ꠅꠇꠟꠅ ꠛꠠ ꠛꠠ, ꠁꠔꠣꠞ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠃꠌꠣ ꠃꠌꠣ ꠅꠀꠟ ꠖꠤꠀ ꠛꠣꠃꠘ꠆ꠒꠞꠤ ꠇꠞꠣ, ꠀꠍꠝꠣꠘꠅ ꠍꠁꠟꠣꠞ ꠟꠣꠉꠦꠞ। ꠀꠞ ꠙꠄꠟꠥꠀꠘ ꠀꠘꠣꠇꠤ ꠅꠇꠟꠞꠦꠅ ꠛꠥꠟꠦ ꠢꠘꠅ ꠖꠦꠈꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","“ꠁꠔꠣ ꠢꠥꠘꠤꠀ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠇꠁꠍꠟꠣꠝ, ꠔꠥꠝꠞꠣ ꠝꠘ ꠊꠣꠛꠠꠣꠁꠅ ꠘꠣ, ꠁꠔꠣꠞꠦ ꠒꠞꠣꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣ ꠔ ꠔꠥꠝꠞꠣꠞ ꠀꠉꠦ ꠀꠉꠦ ꠎꠣꠁꠞꠣ। ꠔꠣꠁꠘ ꠔꠥꠝꠞꠣꠞ ꠙꠇ꠆ꠇ ꠟꠁꠀ ꠔꠥꠝꠞꠣꠞ ꠌꠈꠥꠞ ꠍꠣꠝꠘꠦ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠎꠦꠟꠣ ꠎꠥꠖ꠆ꠖ ꠇꠞꠍꠟꠣ, ꠅꠈꠘꠅ ꠅꠃꠟꠣ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","ꠀꠞ ꠅꠃ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠝꠣꠎꠦꠅ ꠔ ꠔꠥꠝꠞꠣ ꠖꠦꠈꠍ, ꠅꠘꠅ ꠀꠁꠀ ꠙꠃꠍꠣꠞ ꠀꠉ ꠙꠞ꠆ꠎꠘ꠆ꠔ, ꠛꠣꠚꠦ ꠎꠦꠟꠣꠈꠣꠘ ꠀꠙꠘ ꠙꠥꠔꠞꠦ ꠇꠥꠟꠅ ꠇꠞꠤ ꠛꠁꠀ ꠘꠦꠁꠘ, ꠅꠃꠟꠣꠈꠣꠘ ꠀꠟ꠆ꠟꠣ ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞꠦꠅ ꠀꠡ꠆ꠔꠣ ꠙꠕ ꠛꠁꠀ ꠀꠘꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","ꠅꠔꠔꠣ ꠢꠥꠘꠣꠞ ꠛꠣꠖꠦꠅ ꠔꠥꠝꠞꠣ ꠔꠣꠘ ꠃꠙꠞꠦ ꠜꠞꠡꠣ ꠇꠞꠟꠣꠄ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","ꠔꠣꠁꠘꠦꠃ ꠔ ꠔꠣꠝ꠆ꠛꠥ ꠉꠣꠠꠤꠛꠣꠞ ꠎꠣꠉꠣ ꠌꠤꠘꠣꠘꠤꠞ ꠟꠣꠉꠤ ꠀꠞ ꠙꠕ ꠌꠤꠘꠣꠁꠀ ꠘꠤꠛꠣꠞ ꠟꠣꠉꠤ, ꠞꠣꠁꠔꠇꠥꠞ ꠡꠝꠄ ꠀꠉꠥꠘꠤꠞ ꠈꠥꠐꠤ ꠀꠞ ꠖꠤꠘꠇꠥꠞ ꠡꠝꠄ ꠝꠦꠊꠞ ꠈꠥꠐꠤꠞ ꠘꠝꠥꠘꠣ ꠅꠁꠀ ꠔꠥꠝꠞꠣꠞ ꠀꠉꠦ ꠀꠉꠦ ꠉꠦꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","“ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣꠞ ꠁꠔꠣ ꠎꠥꠀꠙ ꠢꠥꠘꠤꠀ ꠝꠣꠛꠥꠖꠦ ꠈꠥꠛ ꠉꠥꠍꠣ ꠇꠞꠟꠣ, ꠔꠣꠁꠘ ꠇꠍꠝ ꠈꠣꠁꠀ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠉꠦꠍꠦ ꠇꠍꠝ ꠈꠣꠁꠍꠟꠣꠝ ꠅꠃ ꠖꠦꠡꠈꠣꠘ ꠖꠤꠔꠣꠝ ꠇꠞꠤ, ꠔꠣ-ꠅ ꠅꠈꠘꠇꠥꠞ ꠁꠔꠣ ꠘꠣꠚꠞꠝꠣꠘ ꠅꠇꠟꠦ ꠁ ꠜꠣꠟꠣ ꠎꠣꠉꠣ ꠈꠣꠘ ꠖꠦꠈꠣꠞ ꠘꠍꠤꠛ ꠅꠁꠔ ꠘꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","ꠈꠣꠟꠤ ꠎꠤꠚꠥꠘ꠆ꠘꠤꠞ ꠙꠥꠀ ꠇꠣꠟꠥꠔ ꠍꠣꠠꠣ। ꠁꠈꠣꠘ ꠖꠦꠈꠣꠞ ꠡꠃꠜꠣꠁꠉ꠆ꠉ ꠅꠃ ꠇꠣꠟꠥꠔꠦ ꠙꠣꠁꠛ, ꠢꠦ ꠀꠝꠣꠞ ꠇꠕꠣꠞꠦ ꠙꠥꠞꠣꠙꠥꠞ ꠝꠣꠘꠍꠦ, ꠢꠦ ꠎꠦꠔꠣ ꠎꠣꠉꠣ ꠙꠣꠅꠖꠤ ꠙꠣꠠꠣꠁꠀ ꠀꠁꠍꠦ, ꠁꠔꠣ ꠎꠣꠉꠣ ꠀꠝꠤ ꠔꠣꠞꠦ ꠀꠞ ꠔꠣꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠞꠦ ꠖꠤꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","“ꠜꠣꠁꠀꠁꠘꠞꠦ, ꠔꠥꠝꠞꠣꠞ ꠇꠣꠞꠘꠦ ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞ ꠃꠙꠞꠦꠅ ꠉꠥꠍꠣ ꠇꠞꠟꠣ, ꠉꠥꠍꠣ ꠇꠞꠤ ꠀꠝꠣꠞꠦ ꠇꠁꠟꠣ, ꠔꠥꠝꠤ ꠝꠥꠍꠣꠅ ꠢꠃ ꠖꠦꠡꠅ ꠢꠣꠝꠣꠁꠔꠣꠄ ꠙꠣꠞꠔꠣꠄ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","ꠈꠣꠟꠤ ꠔꠥꠝꠣꠞ ꠈꠣꠖꠤꠝ ꠘꠥꠘꠞ ꠙꠥꠀ ꠁꠃꠍꠣ ꠉꠤꠀ ꠢꠘꠅ ꠢꠣꠝꠣꠁꠛ। ꠔꠥꠝꠤ ꠔꠣꠞꠦ ꠡꠣꠅꠡ ꠖꠤꠅ, ꠢꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠁ ꠖꠦꠡꠞ ꠖꠈꠟꠖꠣꠞꠤ ꠖꠤꠀ ꠝꠣꠟꠤꠇ ꠛꠣꠘꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","ꠔꠥꠝꠞꠣ ꠇꠁꠍꠟꠣꠄ, ꠀꠝꠞꠣꠞ ꠛꠦꠛꠥꠎ ꠘꠣꠛꠣꠟꠤꠇ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ꠆ꠔꠞꠦ ꠢꠃ ꠖꠦꠡꠞ ꠝꠣꠘꠡꠦ ꠗꠞꠤꠀ ꠘꠤꠛꠉꠤ। ꠅꠁꠟꠦ ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠄꠞꠣꠞꠦꠃ ꠅꠃ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠞ ꠝꠣꠟꠤꠇ ꠛꠣꠘꠣꠁꠝꠥ, ꠄꠞꠣ ꠁꠈꠣꠘ ꠖꠈꠟ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","ꠔꠦ ꠅꠈꠘ ꠔꠥꠝꠞꠣ ꠢꠤꠞꠛꠣꠞ ꠙꠤꠍꠣꠁꠀ ꠉꠤꠀ ꠘꠤꠟ ꠖꠞꠤꠀꠞ ꠙꠣꠞꠦꠖꠤ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠛꠣꠄ ꠞꠅꠀꠘꠣ ꠖꠦꠅ। ");
INSERT INTO syls_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","“ꠁꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠔꠥꠝꠞꠣ ꠇꠁꠍꠟꠣꠄ, ꠀꠝꠞꠣ ꠔ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠉꠥꠘꠣꠉꠣꠞ ꠅꠁꠉꠦꠍꠤ। ꠔꠣ-ꠅ ꠀꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠅꠈꠘ ꠉꠤꠀ ꠎꠥꠖ꠆ꠖ ꠇꠞꠝꠥ। ꠅꠈꠣꠘ ꠇꠁꠀ ꠔꠥꠝꠞꠣ ꠅꠡꠔ꠆ꠞ-ꠡꠡꠔ꠆ꠞ ꠟꠁꠟꠣꠄ, ꠀꠞ ꠝꠘꠅ ꠇꠞꠍꠟꠣꠄ, ꠙꠣꠠꠤ ꠄꠟꠣꠇꠣꠔ ꠃꠑꠤꠀ ꠎꠥꠖ꠆ꠖ ꠇꠞꠣꠅ ꠈꠥꠛ ꠡꠥꠎꠣ। ");
INSERT INTO syls_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","“ꠅꠁꠟꠦ ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞꠦ ꠇꠁꠟꠣ, ꠔꠥꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠇꠅ, ꠔꠣꠞꠣ ꠎꠣꠘꠥ ꠎꠥꠖ꠆ꠖꠞ ꠟꠣꠉꠤ ꠙꠣꠠꠅ ꠘꠣ ꠃꠑꠦ, ꠇꠣꠞꠘ ꠀꠝꠤ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠞꠁꠔꠣꠝ ꠘꠣꠄ, ꠀꠞ ꠀꠝꠣꠞꠦ ꠍꠣꠠꠤꠀ ꠎꠥꠖꠤ ꠔꠥꠝꠞꠣꠞ ꠘꠤꠎꠞ ꠁꠌ꠆ꠍꠣꠄ ꠎꠣꠅ, ꠔꠦ ꠖꠥꠡꠝꠘꠞ ꠉꠦꠍꠦ ꠀꠞꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠢꠥꠡꠤꠀꠞꠤ ꠖꠦꠅꠀꠞ ꠛꠣꠖꠦꠅ ꠔꠥꠝꠞꠣ ꠁꠔꠣ ꠝꠣꠘꠟꠣꠄ ꠘꠣ। ꠔꠥꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝꠞ ꠃꠟꠐꠣ ꠉꠤꠀ ꠛꠥꠇ ꠚꠥꠟꠣꠁꠀ ꠅꠃ ꠙꠣꠠꠅ ꠃꠑꠣꠔ ꠟꠣꠉꠟꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","ꠔꠦꠃ ꠙꠣꠠꠞ ꠛꠣꠡꠤꠘ꠆ꠖꠣ ꠀꠝꠥꠞꠤ ꠎꠣꠔꠤꠄ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠦꠈꠤꠀ ꠙꠣꠟ ꠛꠣꠘ꠆ꠖꠤ ꠛꠣꠞ ꠅꠁꠟ, ꠝꠃꠌꠣꠇꠞ ꠝꠃ-ꠙꠥꠇꠞ ꠟꠣꠈꠣꠘ ꠙꠣꠟ ꠛꠣꠘ꠆ꠖꠤꠀ ꠔꠥꠝꠞꠣꠞ ꠈꠞꠦ ꠈꠞꠦ ꠀꠁꠟ, ꠀꠞ ꠝꠣꠞꠔꠦ ꠝꠣꠞꠔꠦ ꠍꠦꠁꠞꠞ ꠢꠞ꠆ꠝꠣ ꠐꠣꠃꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠈꠦꠖꠣꠁꠀ ꠘꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","ꠛꠣꠖꠦ ꠔꠥꠝꠞꠣ ꠀꠁꠀ ꠝꠣꠛꠥꠖꠞ ꠉꠦꠍꠦ ꠇꠣꠘ꠆ꠖꠘ ꠟꠣꠉꠣꠁꠟꠣꠄ, ꠅꠁꠟꠦ ꠝꠣꠛꠥꠖꠦ ꠇꠣꠘ ꠛꠘ꠆ꠖ ꠇꠞꠤꠟ꠆ꠟꠣ, ꠁ ꠇꠣꠘ꠆ꠖꠘ ꠢꠥꠘꠟꠣ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠔꠥꠝꠞꠣ ꠛꠃꠔ ꠖꠤꠘ ꠇꠣꠖꠦꠡ ꠄꠟꠣꠇꠣꠔ ꠞꠁꠟꠣꠄ, ꠟꠣꠝ꠆ꠛꠣ ꠡꠝꠄ ꠅꠘꠅ ꠉꠥꠎꠞꠤꠟ।” ");
INSERT INTO syls_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","ꠢꠎꠞꠔ ꠝꠥꠍꠣꠄ ꠀꠞꠅ ꠇꠁꠟꠣ, “ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ, ꠅꠃꠟꠣ ꠀꠝꠞꠣ ꠙꠤꠍꠣꠁꠀ ꠉꠤꠀ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠝꠣꠎꠦꠖꠤ ꠘꠤꠟ ꠖꠞꠤꠀꠞ ꠝꠥꠈꠣ ꠞꠅꠀꠘꠣ ꠖꠤꠟꠣꠝ। ꠍꠦꠁꠞꠞ ꠙꠣꠠꠤꠀ ꠄꠟꠣꠇꠣ ꠌꠇ꠆ꠇꠞ ꠖꠤꠀ ꠎꠣꠁꠔꠦ ꠀꠝꠞꠣꠞ ꠛꠃꠔ ꠖꠤꠘ ꠉꠦꠟꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","ꠔꠥꠝꠞꠣ ꠛꠣꠇ꠆ꠇꠣ ꠖꠤꠘ ꠕꠣꠇꠤ ꠅꠃ ꠙꠣꠠꠤꠀ ꠄꠟꠣꠇꠣꠔ ꠌꠇ꠆ꠇꠞ ꠖꠤꠞꠣꠄ, ꠅꠈꠘ ꠃꠔ꠆ꠔꠞ ꠝꠥꠈꠣ ꠞꠅꠀꠘꠣ ꠖꠦꠅ। ");
INSERT INTO syls_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","ꠄꠞꠛꠣꠖꠦ ꠔꠣꠁꠘ ꠀꠝꠣꠞꠦ ꠇꠁꠟꠣ, ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠣꠘꠣꠁꠔꠣꠝ ꠔꠥꠝꠞꠣ ꠅꠈꠘ ꠡꠦꠈ ꠁꠡʼꠞ ꠀꠅꠟꠣꠖꠞ ꠖꠈꠟꠦ ꠕꠣꠇꠣ ꠍꠦꠁꠞ ꠖꠦꠡꠞ ꠜꠤꠔꠞꠦꠖꠤ ꠎꠣꠁꠔꠦ ꠅꠁꠛ। ꠉꠦꠟꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠦꠈꠤꠀ ꠔꠣꠞꠣ ꠒꠞꠣꠁꠛꠣ, ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣ ꠈꠥꠛ ꠢꠥꠡꠤꠀꠞ ꠞꠁꠅ, ꠄꠞꠣ ꠔ ꠔꠥꠝꠞꠣꠞ ꠜꠣꠁꠀꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠇꠣꠁꠎ꠆ꠎꠣ-ꠚꠍꠣꠖ ꠇꠞꠤꠅ ꠘꠣ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠔꠣꠞꠣꠞ ꠖꠦꠡꠞ ꠄꠇ ꠁꠘ꠆ꠌꠤ ꠎꠝꠤꠅ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠤꠔꠣꠝ ꠘꠣꠄ। ꠇꠣꠞꠘ ꠀꠡ꠆ꠔꠣ ꠍꠦꠁꠞ ꠙꠣꠠꠞ ꠝꠣꠟꠤꠇꠣꠘꠣ ꠀꠝꠤ ꠡꠦꠈ ꠁꠡʼꠞꠦ ꠖꠤꠟꠣꠁꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","ꠔꠣꠞꠣꠞ ꠅꠃ ꠖꠦꠡ ꠙꠣꠞ ꠅꠁꠀ ꠎꠣꠁꠛꠣꠞ ꠇꠣꠟꠅ ꠔꠥꠝꠞꠣꠞ ꠈꠣꠘꠤ-ꠈꠥꠞꠣꠇꠤ ꠟꠣꠉꠟꠦ ꠐꠦꠇꠣꠖꠤ ꠟꠁꠀ ꠈꠣꠁꠛꠣꠄ, ꠅꠃꠟꠣ ꠙꠣꠘꠤꠅ ꠟꠁꠀ ꠈꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","“ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠢꠇꠟ ꠇꠣꠝꠞ ꠝꠣꠎꠦꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠞꠢꠝ-ꠛꠞꠇꠔ ꠖꠤꠍꠂꠘ। ꠅꠃ ꠅꠔ ꠛꠠ ꠝꠞꠥꠜꠥꠝꠤ ꠙꠣꠞꠘꠤꠞ ꠛꠣꠟꠣ ꠔꠣꠁꠘ ꠔꠥꠝꠞꠣꠞꠦ ꠢꠦꠚꠣꠎꠔ ꠇꠞꠍꠂꠘ। ꠅꠃ ꠌꠣꠟ꠆ꠟꠤꠡ ꠛꠍꠞ ꠗꠞꠤ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠟꠉꠦ ꠀꠍꠂꠘ, ꠄꠞꠟꠣꠉꠤ ꠇꠥꠘꠥ ꠟꠣꠈꠣꠘ ꠅꠜꠣꠛ ꠅꠁꠍꠦ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","“ꠔꠦꠃ ꠀꠝꠞꠣ ꠚꠣꠔꠣꠞꠤ ꠙꠕꠦ ꠀꠐꠤꠟꠣꠝ, ꠀꠐꠤꠀ ꠀꠝꠞꠣꠞ ꠜꠣꠁ ꠍꠦꠁꠞꠞ ꠛꠣꠡꠤꠘ꠆ꠖꠣ ꠁꠡʼꠞ ꠀꠅꠟꠣꠖꠞ ꠖꠦꠡ ꠚꠣꠟꠣꠁꠀ ꠉꠦꠟꠣꠝ। ꠀꠝꠞꠣ ꠀꠞꠣꠛꠣ ꠔꠟꠜꠥꠝꠤꠞ ꠎꠦ ꠞꠣꠡ꠆ꠔꠣ ꠄꠟꠣꠔ ꠀꠞ ꠁꠎꠤꠅꠘ-ꠉꠦꠛꠦꠞ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁꠀ ꠀꠁꠍꠦ, ꠅꠃ ꠙꠕꠦꠖꠤ ꠘꠣ ꠉꠤꠀ ꠝꠥꠀꠛꠞ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠝꠥꠈꠣ ꠀꠐꠣ ꠗꠞꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞꠦ ꠇꠁꠟꠣ, ꠔꠥꠝꠞꠣ ꠝꠥꠀꠛꠤ ꠅꠇꠟꠞꠦ ꠍꠣꠔꠣꠁꠅ ꠘꠣ, ꠇꠥꠘꠥ ꠎꠥꠖ꠆ꠖꠞ ꠜꠣꠛ-ꠡꠣꠛ ꠖꠦꠈꠣꠁꠅ ꠘꠣ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠔꠣꠞꠣꠞ ꠖꠦꠡꠞ ꠇꠥꠘꠥ ꠎꠝꠤꠃ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠤꠔꠣꠝ ꠘꠣꠄ। ꠔꠣꠞꠣꠞ ꠞꠣꠎꠗꠣꠘꠤ ꠀꠃꠞ ꠐꠣꠃꠘꠞ ꠝꠣꠟꠤꠇꠣꠘꠣ ꠀꠝꠤ ꠟꠥꠔ ꠘꠛꠤꠞ ꠀꠅꠟꠣꠖ ꠝꠥꠀꠛꠤ ꠅꠇꠟꠞꠦ ꠖꠤꠟꠣꠁꠍꠤ।” ");
INSERT INTO syls_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(ꠀꠉꠦ ꠄꠁꠝꠤ ꠎꠣꠔꠤꠞ ꠝꠣꠘꠥꠡ ꠅꠃ ꠄꠟꠣꠇꠣꠔ ꠞꠁꠔꠣ, ꠁꠔꠣ ꠀꠍꠟꠣ ꠙꠄꠟꠥꠀꠘ ꠎꠣꠔꠤ, ꠔꠣꠞꠣ ꠙꠞꠤꠝꠣꠘꠦ ꠀꠍꠟꠣ ꠛꠃꠔ ꠎꠘ, ꠀꠞ ꠖꠦꠈꠔꠦ ꠀꠘꠣꠇꠤ ꠎꠣꠔꠤꠞ ꠟꠣꠈꠣꠘ ꠃꠌꠣ-ꠝꠥꠐꠣ ꠟꠣꠝ꠆ꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","ꠀꠘꠣꠇꠤ ꠅꠇꠟꠞ ꠟꠣꠈꠣꠘ ꠄꠁꠝꠤ ꠅꠇꠟꠞꠦꠅ ꠞꠚꠣꠄꠁ ꠘꠣꠝꠦ ꠒꠣꠇꠣ ꠅꠁꠔ, ꠅꠁꠟꠦ ꠝꠥꠀꠛꠤ ꠅꠇꠟꠦ ꠁꠔꠣꠞꠦ ꠄꠁꠝꠤ ꠇꠁꠀ ꠒꠣꠇꠤꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","ꠍꠦꠁꠞ ꠙꠣꠠꠅ ꠢꠥꠞꠤꠅ ꠅꠇꠟꠦ ꠛꠡꠔ ꠇꠞꠔꠣ, ꠛꠣꠖꠦ ꠁꠡʼꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠦ ꠔꠣꠞꠣꠞꠦ ꠈꠦꠖꠣꠁꠀ ꠖꠤꠀ ꠁꠈꠣꠘ ꠖꠈꠟ ꠇꠞꠟꠣ। ꠝꠣꠛꠥꠖꠞ ꠀꠔꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠎꠦꠟꠣ ꠇꠦꠘꠣꠘ ꠖꠦꠡꠞ ꠝꠣꠟꠤꠇꠣꠘꠣ ꠙꠣꠁꠀ ꠇꠦꠘꠣꠘꠤ ꠅꠇꠟꠞꠦ ꠈꠦꠖꠣꠁꠛꠣ, ꠑꠤꠇ ꠅꠟꠣ ꠁꠡʼꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠦꠅ ꠇꠞꠍꠟꠣ। ꠔꠣꠞꠣ ꠢꠥꠞꠤꠅ ꠅꠇꠟꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠤꠀ ꠢꠇꠟ ꠎꠝꠤ-ꠝꠣꠐꠤ ꠖꠈꠟ ꠇꠞꠤꠀ ꠘꠤꠎꠦ ꠢꠘꠅ ꠛꠡꠔ ꠇꠞꠟꠣ।) ");
INSERT INTO syls_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠀꠞꠅ ꠇꠁꠟꠣ, “ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠟꠣ, ꠔꠥꠝꠞꠣ ꠎꠟꠖꠤ ꠇꠞꠤ ꠞꠅꠀꠘꠣ ꠅꠅ, ꠀꠞ ꠎꠦꠞꠦꠖ ꠙꠣꠠꠤꠀ ꠈꠣꠟ ꠙꠣꠞ ꠅꠁꠀ ꠢꠙꠣꠞꠅ ꠎꠣꠅ। ꠔꠦꠃ ꠀꠝꠞꠣ ꠙꠣꠞ ꠅꠁꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","ꠀꠞ ꠇꠣꠖꠦꠡ-ꠛꠞꠘꠦꠀ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁꠀ ꠢꠣꠞꠤ ꠎꠦꠞꠦꠖ ꠉꠥꠟ꠆ꠟꠣ ꠙꠣꠞ ꠅꠁꠀ ꠀꠁꠔꠦ ꠀꠝꠞꠣꠞ ꠀꠐꠔꠤꠡ ꠛꠍꠞ ꠟꠣꠉꠍꠤꠟ। ꠄꠞꠝꠣꠎꠦ ꠅꠃꠟꠣ ꠅꠁꠟ, ꠝꠣꠛꠥꠖꠦ ꠀꠉꠦ ꠇꠍꠝ ꠈꠣꠁꠀ ꠎꠦꠟꠣ ꠇꠁꠍꠟꠣ, ꠅꠃꠟꠣ ꠇꠣꠖꠦꠡ-ꠛꠞꠘꠦꠀ ꠕꠣꠇꠤ ꠛꠣꠞꠘꠤꠞ ꠇꠣꠟꠅ ꠀꠝꠞꠣꠞ ꠎꠔ ꠍꠤꠙꠣꠁ ꠀꠍꠟꠣ, ꠄꠞꠣ ꠢꠇꠟꠃ ꠅꠃ ꠀꠐꠔꠤꠡ ꠛꠍꠞꠦ ꠝꠞꠤꠉꠦꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠡꠝꠣꠎ ꠕꠣꠇꠤ ꠔꠣꠞꠣꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠣꠞ ꠀꠉ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠝꠣꠛꠥꠖ ꠔꠣꠞꠣꠞ ꠛꠤꠙꠇ꠆ꠇꠦ ꠀꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","“ꠅꠃ ꠢꠇꠟ ꠍꠤꠙꠣꠁ ꠝꠞꠤꠀ ꠡꠦꠡ ꠅꠁꠀ ꠢꠣꠞꠟꠦ, ");
INSERT INTO syls_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞꠦ ꠇꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","ꠀꠁꠎ ꠔꠥꠝꠞꠣ ꠝꠥꠀꠛꠤ ꠅꠇꠟꠞ ꠖꠦꠡꠞ ꠡꠤꠝꠣꠘꠣ ꠙꠣꠞ ꠅꠁꠛꠣꠄ, ꠔꠣꠞꠣꠞ ꠞꠣꠎꠗꠣꠘꠤ ꠀꠃꠞ ꠐꠣꠃꠘꠞ ꠇꠣꠘ꠆ꠖꠣꠛꠣꠄ ꠎꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣ ꠎꠦꠛꠟꠣ ꠛꠘꠤ-ꠀꠝ꠆ꠝꠣꠘ ꠖꠦꠡꠞ ꠇꠣꠍꠣꠔ ꠎꠣꠁꠛꠣꠄꠉꠤ, ꠉꠤꠀ ꠔꠣꠞꠣꠞꠦ ꠍꠣꠔꠣꠁꠅ ꠘꠣ, ꠔꠣꠞꠣꠞꠦ ꠎꠥꠖ꠆ꠖꠞ ꠜꠣꠛ-ꠡꠣꠛ ꠖꠦꠈꠣꠁꠅ ꠘꠣ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠔꠣꠞꠣꠞ ꠖꠦꠡꠞ ꠇꠥꠘꠥ ꠎꠣꠉꠣꠃ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠤꠔꠣꠝ ꠘꠣꠄ, ꠁꠈꠣꠘꠞ ꠝꠣꠟꠤꠇꠣꠘꠣ ꠔ ꠀꠝꠤ ꠟꠥꠔ ꠘꠛꠤꠞ ꠀꠅꠟꠣꠖ ꠛꠘꠤ-ꠀꠝ꠆ꠝꠣꠘꠞꠦ ꠖꠤꠟꠣꠁꠍꠤ।” ");
INSERT INTO syls_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(ꠀꠉꠦ ꠞꠚꠣꠄꠁ ꠅꠇꠟ ꠅꠘꠅ ꠞꠁꠔꠣ, ꠄꠞꠟꠣꠉꠤ ꠁꠈꠣꠘꠞꠦ ꠞꠚꠣꠄꠁ ꠅꠇꠟꠞ ꠖꠦꠡ ꠇꠁꠀ ꠒꠣꠇꠣ ꠅꠁꠔ। ꠀꠞ ꠛꠘꠤ-ꠀꠝ꠆ꠝꠣꠘꠦ ꠁꠔꠣꠞꠦ ꠎꠣꠝ-ꠎꠣꠝꠤꠝꠤ ꠇꠁꠀ ꠒꠣꠇꠤꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","ꠞꠚꠣꠄꠁ ꠎꠣꠔꠤ ꠙꠄꠟꠥꠀꠘ ꠀꠍꠟꠣ, ꠖꠦꠈꠔꠦ ꠀꠘꠣꠇꠤ ꠎꠣꠔꠤꠞ ꠟꠣꠈꠣꠘ ꠃꠌꠣ-ꠝꠥꠐꠣ ꠟꠣꠝ꠆ꠛꠣ ꠀꠞ ꠙꠞꠤꠝꠣꠘꠦꠅ ꠛꠃꠔ ꠛꠦꠡꠤ ꠀꠍꠟꠣ। ꠝꠣꠛꠥꠖꠦ ꠛꠘꠤ-ꠀꠝ꠆ꠝꠣꠘ ꠎꠣꠔꠤꠞ ꠀꠔꠅ ꠁꠔꠣꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠣꠁꠟꠣ, ꠛꠘꠤ-ꠀꠝ꠆ꠝꠣꠘꠦ ꠞꠚꠣꠄꠁ ꠎꠣꠔꠤꠞꠦ ꠈꠦꠖꠣꠁ ꠖꠤꠀ ꠅꠃ ꠖꠦꠡ ꠖꠈꠟ ꠇꠞꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","ꠝꠣꠛꠥꠖꠦ ꠁꠡʼꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠞꠦꠖꠤ ꠅꠃ ꠄꠇꠁ ꠇꠣꠝ ꠇꠞꠣꠁꠟꠣ, ꠔꠣꠁꠘ ꠄꠞꠣꠞ ꠀꠔꠅ ꠢꠥꠞꠤꠅ ꠎꠣꠔꠤꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠟꠣ। ꠄꠞꠣ ꠢꠥꠞꠤꠅ ꠅꠇꠟꠞꠦ ꠈꠦꠖꠣꠁꠀ ꠖꠤꠀ, ꠔꠣꠞꠣꠞ ꠍꠦꠁꠞ ꠖꠦꠡ ꠖꠈꠟ ꠇꠞꠤꠀ ꠛꠡꠔ ꠇꠞꠞꠣ। ");
INSERT INTO syls_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","ꠄꠞꠝꠣꠎꠦ ꠇꠙ꠆ꠔꠥꠞ ꠖꠤꠙ ꠕꠣꠇꠤ ꠇꠙ꠆ꠔꠥꠞꠤ ꠎꠣꠔꠤꠄ ꠀꠁꠀ ꠅꠛ꠆ꠛꠤ ꠎꠣꠔꠤꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠟꠣ, ꠔꠣꠞꠣꠞ ꠝꠣꠐꠤꠞꠦ ꠖꠈꠟ ꠇꠞꠤꠀ ꠛꠡꠔ ꠇꠞꠟꠣ। ꠅꠃ ꠅꠛ꠆ꠛꠤ ꠅꠇꠟ ꠉꠣꠎꠣ ꠐꠣꠃꠘꠞ ꠗꠣꠞꠅ ꠛꠡꠔ ꠇꠞꠔꠣ, ꠢꠘꠞ ꠢꠇꠟ ꠉꠣꠃ-ꠉꠦꠞꠣꠝꠅ ꠔꠣꠞꠣ ꠞꠁꠔꠣ।) ");
INSERT INTO syls_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“ꠄꠞꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠇꠁꠍꠟꠣ, ꠅ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ, ꠔꠥꠝꠞꠣ ꠛꠣꠞ ꠅꠅ, ꠛꠣꠞ ꠅꠁꠀ ꠅꠞꠘꠘ ꠈꠣꠟꠞ ꠢꠙꠣꠞꠅ ꠎꠣꠅ। ꠢꠥꠘꠅ, ꠀꠝꠥꠞꠤ ꠎꠣꠔꠤꠞ ꠛꠣꠖꠡꠣ ꠍꠤꠢꠥꠘ ꠀꠞ ꠔꠣꠞ ꠢꠤꠡꠛꠘ ꠖꠦꠡꠞꠦ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠀꠔꠅ ꠡꠙꠤ ꠖꠤꠍꠤ। ꠁꠈꠣꠘ ꠖꠈꠟ ꠇꠞꠣꠔ ꠉꠤꠀ ꠛꠣꠖꠡꠣꠞꠦ ꠎꠥꠖ꠆ꠖꠞ ꠚꠤꠟꠒꠅ ꠟꠣꠝꠣꠅ, ");
INSERT INTO syls_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","ꠔꠦꠃ ꠖꠦꠈꠛꠣꠄ, ꠀꠝꠤ ꠝꠣꠛꠥꠖꠦ ꠀꠁꠎ ꠕꠣꠇꠤ ꠎꠉꠔꠞ ꠢꠇꠟ ꠎꠣꠔꠤꠞ ꠖꠤꠟꠅ ꠒꠞ ꠢꠣꠞꠣꠁ ꠖꠤꠝꠥ, ꠔꠥꠝꠞꠣꠞ ꠒꠞꠦ ꠔꠣꠞꠣ ꠇꠣꠙꠤꠛꠣ। ꠔꠥꠝꠞꠣꠞ ꠀꠅꠀꠎ ꠢꠥꠘꠟꠦꠃ ꠔꠣꠞꠣꠞ ꠎꠣꠘꠅ ꠗꠠꠚꠠ ꠡꠥꠞꠥ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠀꠞꠅ ꠇꠁꠟꠣ, “ꠛꠣꠖꠦ ꠀꠝꠤ ꠡꠣꠘ꠆ꠔꠤ-ꠌꠥꠇ꠆ꠔꠤ ꠇꠞꠣꠞ ꠈꠤꠀꠟꠦ ꠈꠣꠖꠤꠝꠥꠔ ꠝꠞꠥꠜꠥꠝꠤ ꠕꠣꠇꠤ ꠢꠤꠡꠛꠘꠞ ꠛꠣꠖꠡꠣ ꠍꠤꠢꠥꠘꠞ ꠉꠦꠍꠦ ꠈꠛꠞꠤꠀ ꠙꠣꠑꠣꠁꠟꠣꠝ, ꠇꠁꠟꠣꠝ, ");
INSERT INTO syls_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","ꠀꠝꠞꠣ ꠀꠙꠘꠣꠞ ꠖꠦꠡꠞ ꠜꠤꠔꠞꠦꠖꠤ ꠙꠣꠞ ꠅꠁꠀ ꠎꠣꠁꠔꠣꠝ ꠌꠣꠁ, ꠅꠘꠥꠝꠔꠤ ꠖꠤꠛꠣ ꠘꠤ? ꠀꠝꠞꠣ ꠀꠔꠣꠞꠦ-ꠚꠣꠔꠣꠞꠦ ꠇꠥꠘꠥꠛꠣꠄ ꠎꠣꠁꠔꠣꠝ ꠘꠣꠄ, ꠈꠣꠟꠤ ꠝꠥꠟ ꠡꠠꠇꠦꠖꠤ ꠀꠐꠤꠀ ꠎꠣꠁꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","29","ꠀꠝꠞꠣ ꠘꠉꠖ ꠐꠦꠇꠣꠖꠤ ꠀꠙꠘꠣꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠈꠣꠘꠤ-ꠈꠥꠞꠣꠇꠤ ꠛꠣ ꠙꠣꠘꠤꠅ ꠈꠞꠤꠖ ꠇꠞꠤꠀ ꠈꠣꠁꠝꠥ। ꠀꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠀꠝꠞꠣꠞꠦ ꠎꠦ ꠖꠦꠡꠈꠣꠘ ꠖꠤꠔꠣ ꠌꠣꠁꠞꠣ, ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋ ꠙꠣꠞ ꠅꠁꠀ ꠢꠃ ꠖꠦꠡꠅ ꠎꠣꠁꠛꠣꠞ ꠀꠉ ꠙꠞ꠆ꠎꠘ꠆ꠔ, ꠀꠙꠘꠣꠞ ꠖꠦꠡꠞ ꠃꠙꠞꠦꠖꠤ ꠀꠝꠞꠣꠞꠦ ꠀꠐꠤꠀ ꠎꠣꠁꠔꠦ ꠖꠦꠃꠇ꠆ꠇꠣ। ꠍꠦꠁꠞꠞ ꠙꠣꠠꠤꠀ ꠄꠟꠣꠇꠣꠞ ꠛꠣꠡꠤꠘ꠆ꠖꠣ ꠁꠡʼꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠦ, ꠀꠞ ꠀꠃꠞ ꠐꠣꠃꠘꠞ ꠛꠣꠡꠤꠘ꠆ꠖꠣ ꠝꠥꠀꠛꠤ ꠅꠇꠟꠦꠅ ꠀꠝꠞꠣꠞꠦ ꠅꠟꠣ ꠙꠣꠞ ꠅꠁꠔꠦ ꠖꠤꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","“ꠅꠁꠟꠦ ꠢꠤꠡꠛꠘꠞ ꠛꠣꠖꠡꠣ ꠍꠤꠢꠥꠘ ꠞꠣꠎꠤ ꠅꠁꠟ ꠘꠣ, ꠀꠝꠞꠣꠞꠦ ꠎꠣꠁꠔꠦ ꠖꠤꠟ ꠘꠣ। ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄꠃ ꠔꠣꠞ ꠖꠤꠟꠞꠦ ꠙꠣꠡꠣꠘ ꠛꠣꠘꠣꠁꠟ꠆ꠟꠣ, ꠔꠣꠞ ꠝꠘꠞ ꠜꠣꠛ ꠟꠥꠀꠞ ꠟꠣꠈꠣꠘ ꠅꠁꠉꠦꠟ, ꠎꠣꠔꠦ ꠔꠥꠝꠞꠣꠞ ꠀꠔꠅ ꠔꠣꠞ ꠛꠤꠘꠣꠡ ꠅꠄ, ꠀꠞ ꠑꠤꠇꠃ ꠅꠟꠣ ꠅꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","ꠔꠦꠃ ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞꠦ ꠇꠁꠟꠣ, ꠅ ꠝꠥꠍꠣ, ꠍꠤꠢꠥꠘ ꠀꠞ ꠔꠣꠞ ꠛꠣꠖꠡꠣꠁꠞꠦ ꠀꠝꠤ ꠔꠥꠝꠣꠞ ꠀꠔꠅ ꠡꠙꠤ ꠖꠤꠟꠣꠝ। ꠅꠈꠘ ꠔꠥꠝꠤ ꠢꠘꠅ ꠎꠣꠅ, ꠉꠤꠀ ꠅꠃ ꠖꠦꠡ ꠖꠈꠟꠦ ꠀꠘꠣꠔ ꠟꠣꠉꠅ, ꠀꠞ ꠢꠘꠅ ꠛꠡꠔ ꠇꠞꠅ। ");
INSERT INTO syls_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","“ꠔꠦꠃ ꠁꠀꠢꠣꠎ ꠄꠟꠣꠇꠣꠔ ꠍꠤꠢꠥꠘꠦ ꠔꠣꠞ ꠢꠇꠟ ꠍꠤꠙꠣꠁ ꠖꠟ ꠟꠁꠀ ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠟꠣꠠꠣꠁ ꠇꠞꠣꠔ ꠀꠁꠟ, ");
INSERT INTO syls_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","ꠅꠃ ꠡꠝꠄ ꠀꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠞꠦ ꠀꠝꠞꠣꠞ ꠀꠔꠅ ꠚꠣꠟꠣꠁꠟꠣ। ꠀꠝꠞꠣ ꠛꠣꠖꠡꠣꠞꠦ, ꠔꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞꠦ, ꠔꠣꠞ ꠍꠤꠙꠣꠁ ꠖꠟꠞꠦ ꠘꠤꠙꠣꠔ ꠇꠞꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","ꠀꠞ ꠀꠝꠞꠣ ꠔꠣꠞ ꠢꠇꠟ ꠐꠣꠃꠘ, ꠉꠣꠃ-ꠉꠦꠞꠣꠝ ꠢꠇꠟꠔꠣ ꠖꠈꠟ ꠇꠞꠟꠣꠝ, ꠔꠣꠞꠣꠞ ꠢꠇꠟ ꠛꠦꠐꠣꠁꠘ-ꠛꠦꠐꠤꠘ ꠀꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠟꠣꠝ। ꠄꠇꠎꠘꠅ ꠎꠤꠘ꠆ꠖꠣ ꠞꠁꠍꠦ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","ꠈꠣꠟꠤ ꠔꠣꠞꠣꠞ ꠙꠡꠥꠞ ꠙꠣꠟ ꠀꠞ ꠉꠘꠤꠝꠔꠞ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠀꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠀꠘꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","ꠅꠞꠘꠘ ꠈꠣꠟꠞ ꠡꠤꠝꠣꠘꠣꠞ ꠀꠞꠥꠀꠞ ꠐꠣꠃꠘ, ꠀꠞ ꠅꠃ ꠄꠟꠣꠇꠣꠞ ꠄꠇ ꠉꠣꠃ ꠕꠣꠇꠤ ꠀꠞꠇ ꠉꠣꠃ ꠖꠈꠟ ꠇꠞꠤ ꠇꠞꠤ, ꠉꠤꠟꠤꠅꠖ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠇꠥꠘꠥ ꠎꠣꠉꠣ ꠀꠝꠞꠣꠞ ꠖꠈꠟꠞ ꠛꠣꠁꠞꠦ ꠞꠁꠟ ꠘꠣ। ꠀꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠀꠝꠞꠣꠞ ꠀꠔꠅ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","ꠈꠣꠟꠤ ꠛꠘꠤ-ꠀꠝ꠆ꠝꠣꠘ ꠎꠣꠔꠤꠞ ꠖꠦꠡ, ꠎꠣꠛ꠆ꠛꠥꠇ ꠙꠣꠠꠤꠀ ꠈꠣꠟꠞ ꠇꠣꠘ꠆ꠖꠣ-ꠇꠣꠍꠣꠞ ꠢꠇꠟ ꠎꠤꠟꠣ, ꠙꠣꠠꠞ ꠃꠙꠞꠞ ꠉꠣꠃ-ꠉꠦꠞꠣꠝ, ꠀꠞ ꠀꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠎꠦꠔꠣ ꠎꠣꠉꠣ ꠖꠈꠟ ꠇꠞꠔꠦ ꠘꠤꠡꠦꠗ ꠇꠞꠍꠂꠘ, ꠅꠃ ꠎꠣꠉꠣ ꠈꠣꠘꠣꠁꠘ ꠔꠥꠝꠞꠣꠞ ꠖꠈꠟꠞ ꠛꠣꠁꠞꠦ ꠞꠁꠟ।” ");
INSERT INTO syls_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","ꠢꠎꠞꠔ ꠝꠥꠍꠣꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠀꠞꠅ ꠇꠁꠟꠣ, “ꠢꠤꠡꠛꠘ ꠖꠦꠡ ꠕꠣꠇꠤ ꠀꠝꠞꠣ ꠛꠣꠡꠘ ꠖꠦꠡꠅ ꠎꠣꠅꠀꠞ ꠙꠕꠦ ꠞꠅꠀꠘꠣ ꠅꠁꠟꠣꠝ। ꠛꠣꠡꠘꠞ ꠛꠣꠖꠡꠣ ꠃꠎꠦ ꠈꠛꠞ ꠙꠣꠁꠀ ꠎꠥꠖ꠆ꠖ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠔꠣꠞ ꠢꠇꠟ ꠍꠤꠙꠣꠁ ꠖꠟ ꠟꠁꠀ ꠁꠖꠞꠤ ꠐꠣꠃꠘꠅ ꠀꠁꠟ। ");
INSERT INTO syls_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞꠦ ꠇꠁꠟꠣ, ꠅ ꠝꠥꠍꠣ, ꠁ ꠛꠣꠖꠡꠣꠞꠦ ꠔꠥꠝꠤ ꠒꠞꠣꠁꠅ ꠘꠣ। ꠢꠥꠘꠅ, ꠀꠝꠤ ꠔꠣꠞꠦ, ꠔꠣꠞ ꠀꠡ꠆ꠔꠣ ꠖꠦꠡꠞꠦ, ꠔꠣꠞ ꠍꠤꠙꠣꠁ ꠖꠟꠞꠦ ꠔꠥꠝꠣꠞ ꠀꠔꠅ ꠔꠥꠟꠤꠀ ꠖꠤꠟꠣꠁꠍꠤ। ꠔꠥꠝꠤ ꠢꠤꠡꠛꠘ ꠖꠦꠡꠅ ꠀꠝꠥꠞꠤ ꠎꠣꠔꠤꠞ ꠛꠣꠖꠡꠣ ꠍꠤꠢꠥꠘꠞ ꠎꠦ ꠖꠡꠣ ꠊꠐꠣꠁꠍ, ꠅꠉꠥꠞꠦꠅ ꠅꠃꠟꠣ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","“ꠅꠃ ꠘꠝꠥꠘꠣꠄ ꠀꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠛꠣꠡꠘ ꠖꠦꠡꠞ ꠛꠣꠖꠡꠣ ꠃꠎꠞꠦ, ꠔꠣꠞ ꠢꠇꠟ ꠝꠣꠘꠡꠞꠦ ꠀꠝꠞꠣꠞ ꠀꠔꠅ ꠡꠝꠎꠣꠁ ꠖꠤꠟꠣ। ꠀꠝꠞꠣꠅ ꠁꠔꠣ ꠢꠇ꠆ꠇꠟꠐꠤꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠟꠣꠝ, ꠇꠥꠘꠥꠉꠥꠞꠦ ꠎꠤꠘ꠆ꠖꠣ ꠞꠣꠈꠍꠤ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","ꠀꠝꠞꠣ ꠔꠣꠞ ꠖꠦꠡꠞ ꠢꠇꠟ ꠉꠣꠃ-ꠉꠦꠞꠣꠝ, ꠐꠣꠃꠘ-ꠛꠘ꠆ꠖꠞ ꠖꠈꠟ ꠇꠞꠟꠣꠝ। ꠔꠣꠞꠣꠞ ꠡꠣꠁꠐ ꠈꠣꠘ ꠐꠣꠃꠘꠃ ꠖꠈꠟ ꠇꠞꠤꠟ꠆ꠟꠣꠝ, ꠇꠥꠘ꠆ꠔꠣ ꠛꠣꠖ ꠞꠁꠟ ꠘꠣ। ꠀꠡ꠆ꠔꠣ ꠅꠞꠉꠥꠛ ꠄꠟꠣꠇꠣ, ꠝꠣꠘꠤ ꠛꠣꠡꠘꠞ ꠛꠣꠖꠡꠣ ꠃꠎꠞ ꠙꠥꠞꠣ ꠛꠣꠖꠡꠣꠁ ꠀꠝꠞꠣꠞ ꠖꠈꠟꠅ ꠘꠤꠟꠣꠝꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","ꠅꠃ ꠐꠣꠃꠘ ꠅꠇꠟꠅ ꠃꠌꠣ ꠃꠌꠣ ꠅꠀꠟ ꠖꠤꠀ ꠛꠣꠃꠘ꠆ꠒꠞꠤ ꠇꠞꠣ ꠀꠍꠤꠟ, ꠁꠔꠣꠞ ꠉꠦꠁꠐꠅ ꠀꠍꠤꠟ ꠛꠠ ꠛꠠ ꠈꠤꠟ। ꠀꠞ ꠛꠣꠃꠘ꠆ꠒꠞꠤ ꠍꠣꠠꠣꠅ ꠛꠃꠔ ꠉꠣꠃ-ꠉꠦꠞꠣꠝ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","ꠀꠝꠞꠣ ꠢꠇꠟ ꠐꠣꠃꠘ ꠀꠞ ꠉꠣꠃ-ꠉꠦꠞꠣꠝꠞꠦ ꠄꠇ꠆ꠇꠦꠛꠣꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠍꠤ। ꠀꠉꠦ ꠢꠤꠡꠛꠘꠞ ꠛꠣꠖꠡꠣ ꠍꠤꠢꠥꠘꠞ ꠎꠦ ꠖꠡꠣ ꠊꠐꠣꠁꠍꠤ, ꠅꠈꠘ ꠛꠣꠡꠘ ꠖꠦꠡꠞ ꠛꠦꠐꠣꠁꠘ-ꠛꠦꠐꠤꠘ, ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ, ꠢꠇꠟ ꠉꠣꠃ-ꠉꠦꠞꠣꠝ ꠀꠞ ꠐꠣꠃꠘꠞꠦꠅ ꠄꠇꠁ ꠟꠣꠈꠣꠘ ꠛꠤꠘꠣꠡ ꠇꠞꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","ꠅꠁꠟꠦ ꠔꠣꠞꠣꠞ ꠢꠇꠟ ꠙꠡꠥꠞ ꠙꠣꠟ ꠀꠞ ꠉꠘꠤꠝꠔꠞ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠀꠝꠞꠣ ꠟꠁꠀ ꠀꠁꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","“ꠀꠝꠞꠣ ꠅꠃ ꠡꠝꠄ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠙꠥꠛ ꠙꠣꠞꠞ ꠀꠝꠥꠞꠤ ꠎꠣꠔꠤꠞ ꠖꠥꠁꠅ ꠛꠣꠖꠡꠣꠞ ꠖꠈꠟꠞ, ꠅꠞꠘꠘ ꠈꠣꠟ ꠕꠣꠇꠤ ꠢꠞ꠆ꠝꠥꠘ ꠙꠣꠠ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠇꠛꠎꠣ ꠇꠞꠍꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(ꠍꠤꠖꠘꠞ ꠝꠣꠘꠡꠦ ꠅꠃ ꠢꠞ꠆ꠝꠥꠘ ꠄꠟꠣꠇꠣꠞꠦ ꠍꠤꠞꠤꠅꠘ ꠇꠁꠀ ꠒꠣꠇꠂꠘ, ꠀꠞ ꠀꠝꠥꠞꠤ ꠎꠣꠔꠤꠄ ꠇꠂꠘ ꠍꠘꠤꠞ।) ");
INSERT INTO syls_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","ꠙꠣꠠꠤꠀ ꠄꠟꠣꠇꠣꠞ ꠅꠃ ꠕꠟ ꠎꠣꠉꠣꠞ ꠢꠇꠟ ꠐꠣꠃꠘ ꠀꠞ ꠉꠣꠃ-ꠉꠦꠞꠣꠝ, ꠀꠡ꠆ꠔꠣ ꠉꠤꠟꠤꠅꠖ ꠄꠟꠣꠇꠣ, ꠛꠣꠖꠡꠣ ꠃꠎꠞ ꠍꠥꠟꠈꠣ ꠀꠞ ꠁꠖꠞꠤ ꠐꠣꠃꠘ ꠡꠢ ꠀꠡ꠆ꠔꠣ ꠛꠣꠡꠘ ꠖꠦꠡꠞꠦ ꠀꠝꠞꠣ ꠖꠈꠟ ꠇꠞꠟꠣꠝ।” ");
INSERT INTO syls_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(ꠙꠥꠞꠣ ꠞꠚꠣꠄꠁ ꠎꠣꠔꠤꠞ ꠝꠣꠎꠦ ꠈꠣꠟꠤ ꠛꠣꠡꠘ ꠖꠦꠡꠞ ꠛꠣꠖꠡꠣ ꠃꠎ ꠎꠤꠔꠣ ꠞꠁꠍꠟꠣ। ꠅꠃ ꠛꠣꠖꠡꠣ ꠟꠥꠀꠞ ꠙꠣꠟꠋꠉꠅ ꠢꠥꠔꠤꠔꠣ, ꠁꠈꠣꠘ ꠟꠣꠝ꠆ꠛꠣꠄ ꠘꠄ ꠀꠔ ꠀꠞ ꠚꠣꠠꠦ ꠌꠣꠁꠞ ꠀꠔ। ꠛꠘꠤ-ꠀꠝ꠆ꠝꠣꠘ ꠎꠣꠔꠤꠞ ꠞꠣꠛ꠆ꠛꠣ ꠐꠣꠃꠘꠅ ꠁꠈꠣꠘ ꠅꠈꠘꠅ ꠕꠅꠀ ꠀꠍꠦ।) ");
INSERT INTO syls_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","ꠢꠎꠞꠔ ꠝꠥꠍꠣꠄ ꠀꠞꠅ ꠇꠁꠞꠣ, “ꠀꠝꠞꠣꠞ ꠖꠈꠟ ꠇꠞꠣ ꠅꠞꠘꠘ ꠈꠣꠟꠞ ꠙꠣꠞꠅ ꠀꠞꠥꠀꠞ ꠐꠣꠃꠘꠞ ꠛꠣꠁꠞꠞ ꠃꠔꠞꠞ ꠄꠟꠣꠇꠣ, ꠀꠞ ꠙꠣꠠꠤꠀ ꠉꠤꠟꠤꠅꠖ ꠄꠟꠣꠇꠣꠞ ꠅꠞ꠆ꠗꠦꠇ ꠎꠣꠉꠣ, ꠢꠘꠞ ꠢꠇꠟ ꠐꠣꠃꠘ ꠀꠞ ꠉꠣꠃ-ꠉꠦꠞꠣꠝ ꠅꠇꠟ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠞꠥꠛꠦꠘ ꠀꠞ ꠍꠣꠖꠥ ꠈꠣꠘ꠆ꠖꠣꠘꠞꠦ ꠖꠤꠟꠣꠁꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","ꠉꠤꠟꠤꠅꠖ ꠖꠦꠡꠞ ꠛꠣꠇꠤ ꠅꠋꠡ ꠀꠞ ꠛꠣꠖꠡꠣ ꠃꠎꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠀꠘꠣ ꠀꠡ꠆ꠔꠣ ꠛꠣꠡꠘ ꠖꠦꠡꠞꠦ ꠀꠝꠤ ꠝꠣꠘꠡꠣ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠅꠞ꠆ꠗꠦꠇ ꠝꠣꠘꠡꠞꠦ ꠖꠤꠟꠣꠝ।” (ꠛꠣꠡꠘ ꠖꠦꠡꠞ ꠀꠡ꠆ꠔꠣ ꠅꠞꠉꠥꠛ ꠄꠟꠣꠇꠣꠞꠦ ꠞꠚꠣꠄꠁ ꠎꠣꠔꠤꠞ ꠖꠦꠡ ꠇꠁꠀ ꠒꠣꠇꠣ ꠅꠁꠔ। ");
INSERT INTO syls_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","ꠝꠣꠘꠡꠣ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠄꠇ ꠎꠘꠞ ꠘꠣꠝ ꠀꠍꠤꠟ ꠎꠣꠄꠁꠞ, ꠢꠦ ꠀꠡ꠆ꠔꠣ ꠅꠞꠉꠥꠛ ꠄꠟꠣꠇꠣ ꠝꠣꠘꠤ, ꠉꠡꠥꠞꠤ ꠀꠞ ꠝꠣꠈꠣꠔꠤ ꠎꠣꠔꠤꠞ ꠡꠤꠝꠣꠘꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠖꠈꠟ ꠇꠞꠤꠀ ꠔꠣꠞ ꠘꠤꠎꠞ ꠘꠣꠝꠞ ꠝꠤꠟꠦ ꠅꠃ ꠛꠣꠡꠘ ꠖꠦꠡꠞ ꠘꠣꠝ ꠖꠤꠟ ꠢꠣꠛ꠆ꠛꠥꠔ-ꠎꠣꠄꠁꠞ। ꠄꠞꠟꠣꠉꠤ ꠅꠈꠘꠅ ꠁꠈꠣꠘꠞꠦ ꠅꠃ ꠘꠣꠝꠦ ꠒꠣꠇꠣ ꠅꠄ।) ");
INSERT INTO syls_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","“ꠀꠞ ꠉꠤꠟꠤꠅꠖꠞ ꠙꠣꠠꠤꠀ ꠄꠟꠣꠇꠣ ꠀꠝꠤ ꠝꠣꠈꠤꠞꠞꠦ ꠖꠤꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","ꠅꠁꠟꠦ ꠉꠤꠟꠤꠅꠖ ꠕꠣꠇꠤ ꠅꠞꠘꠘꠞ ꠙꠣꠠꠤꠀ ꠈꠣꠟꠞ ꠝꠣꠎꠣꠝꠣꠎꠤ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠢꠇꠟ ꠎꠣꠉꠣ, ꠀꠞ ꠢꠘ ꠕꠣꠇꠤ ꠛꠘꠤ-ꠀꠝ꠆ꠝꠣꠘ ꠎꠣꠔꠤꠞ ꠡꠤꠝꠣꠘꠣ ꠎꠣꠛ꠆ꠛꠥꠇ ꠈꠣꠟ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠀꠝꠤ ꠞꠥꠛꠦꠘ ꠀꠞ ꠍꠣꠖꠥ ꠈꠣꠘ꠆ꠖꠣꠘꠞꠦ ꠖꠤꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","ꠔꠣꠞꠣꠞ ꠖꠦꠡꠞ ꠙꠁꠌꠝꠞ ꠡꠤꠝꠣꠘꠣ ꠀꠍꠤꠟ, ꠀꠞꠣꠛꠣ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠎꠦ ꠅꠋꠡ ꠉꠣꠟꠤꠟ ꠀꠅꠞꠞ ꠗꠣꠞꠦꠖꠤ, ꠙꠤꠍꠉꠣ ꠘꠣꠝꠞ ꠙꠣꠠꠤꠀ ꠄꠟꠣꠇꠣꠞ ꠀꠞꠣꠛꠣ ꠡꠣꠉꠞ ꠛꠣ ꠟꠥꠘꠣ ꠡꠣꠉꠞ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠉꠦꠍꠦ, ꠅꠃ ꠎꠣꠉꠣ। ");
INSERT INTO syls_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","“ꠅꠃ ꠎꠣꠉꠣ ꠅꠈꠘꠣꠁꠘ ꠡꠝꠎꠣꠁ ꠖꠤꠀ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣꠝ, ꠁꠈꠘꠣꠁꠘ ꠜꠥꠉ-ꠖꠈꠟ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠤꠍꠂꠘ। ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣꠞ ꠎꠦꠔꠣ ꠛꠦꠐꠣꠁꠘ꠆ꠔꠞ ꠡꠞꠤꠟꠅ ꠛꠟ ꠀꠍꠦ, ꠎꠦꠞꠣ ꠎꠥꠖ꠆ꠖ ꠇꠞꠣꠞ ꠟꠣꠈ, ꠄꠞꠣ ꠎꠥꠁꠔ-ꠎꠣꠁꠔ ꠅꠁꠀ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠀꠉꠦ ꠉꠤꠀ ꠉꠣꠋ ꠙꠣꠞ ꠅꠅ। ");
INSERT INTO syls_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠦꠅꠀ ꠐꠣꠃꠘ ꠀꠞ ꠉꠣꠃ-ꠉꠦꠞꠣꠝꠅ ꠔꠥꠝꠞꠣꠞ ꠛꠃ, ꠙꠥꠀ-ꠙꠥꠠꠤꠘ ꠀꠞ ꠉꠞꠥ-ꠍꠣꠉꠟ ꠢꠇꠟꠔꠣ ꠞꠁꠛꠣ। ꠀꠝꠤ ꠎꠣꠘꠤ ꠔꠥꠝꠞꠣꠞ ꠛꠃꠔ ꠙꠡꠥ ꠀꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠎꠦꠛꠟꠣ ꠔꠥꠝꠞꠣꠞ ꠎꠣꠔꠤꠞ ꠜꠣꠁꠀꠁꠘꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠈꠣꠘ ꠀꠞꠣꠝꠞ ꠎꠣꠉꠣ ꠖꠤꠟꠣꠁꠛꠣ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠢꠙꠣꠞꠅ ꠔꠣꠞꠣꠞꠦ ꠎꠦ ꠖꠦꠡ ꠖꠣꠘ ꠇꠞꠞꠣ, ꠅꠈꠣꠘꠞ ꠖꠈꠟ ꠙꠣꠁꠀ ꠢꠣꠞꠟꠦ, ꠔꠥꠝꠞꠣ ꠢꠤꠞꠛꠣꠞ ꠀꠝꠣꠞ ꠖꠦꠅꠀ ꠅꠃ ꠎꠣꠉꠣꠔ ꠚꠤꠞꠤꠀ ꠀꠁꠅ।” ");
INSERT INTO syls_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","ꠢꠎꠞꠔ ꠝꠥꠍꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠞꠣ, “ꠅꠃ ꠡꠝꠄ ꠀꠝꠤ ꠁꠃꠍꠣꠞꠦ ꠇꠁꠟꠣꠝ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠅꠃ ꠖꠥꠁꠅ ꠛꠣꠖꠡꠣꠞ ꠇꠥꠘ ꠖꠡꠣ ꠊꠐꠣꠁꠍꠂꠘ, ꠁꠔꠣ ꠔ ꠘꠤꠎꠞ ꠌꠃꠈꠦ ꠖꠦꠈꠍ। ꠔꠦ ꠅꠈꠘ ꠎꠞ꠆ꠖꠣꠘ ꠙꠣꠞ ꠅꠁꠀ ꠔꠥꠝꠞꠣ ꠎꠔ ꠖꠦꠡꠣꠁꠘ꠆ꠔꠅ ꠎꠣꠁꠞꠣꠄ, ꠝꠣꠛꠥꠖꠦ ꠁꠔꠣ ꠢꠇ꠆ꠇꠟ ꠖꠦꠡꠣꠁꠘ꠆ꠔꠞ ꠖꠡꠣꠅ ꠅꠃ ꠟꠣꠈꠣꠘ ꠊꠐꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","ꠄꠞꠟꠣꠉꠤ ꠔꠥꠝꠞꠣ ꠁꠔꠣꠞꠦ ꠒꠞꠣꠁꠅ ꠘꠣ, ꠡ꠆ꠛꠄꠅꠋ ꠀꠟ꠆ꠟꠣ ꠝꠣꠛꠥꠖ ꠔꠥꠝꠞꠣꠞ ꠙꠇ꠆ꠇ ꠅꠁꠀ ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠎꠥꠖ꠆ꠖ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","“ꠀꠞ ꠅꠃ ꠡꠝꠄ ꠀꠝꠤ ꠝꠣꠛꠥꠖꠞ ꠖꠞꠛꠣꠞꠅ ꠀꠞꠎ ꠇꠞꠟꠣꠝ, ");
INSERT INTO syls_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","ꠅ ꠝꠣꠛꠥꠖ ꠝꠃꠟꠣ, ꠔꠥꠝꠣꠞ ꠉꠥꠟꠣꠝꠞꠦ ꠔ ꠅꠈꠘꠃ ꠖꠦꠈꠣꠘꠤ ꠗꠞꠍ, ꠔꠥꠝꠤ ꠇꠔ ꠝꠢꠣꠘ ꠀꠞ ꠇꠔ ꠛꠟꠛꠣꠘ। ꠔꠥꠝꠤ ꠅꠃ ꠎꠔꠔꠣ ꠇꠞꠍ, ꠁꠔꠣ ꠇꠞꠣꠞ ꠡꠣꠁꠖ꠆ꠖ ꠇꠣꠞ ꠀꠍꠦ, ꠀꠍꠝꠣꠘꠅ ꠛꠣ ꠎꠝꠤꠘꠞ ꠇꠥꠘꠥ ꠖꠦꠛꠔꠣꠞ ꠔꠣꠇ꠆ꠇꠔ ꠀꠍꠦ ꠘꠤ, ꠔꠥꠝꠣꠞ ꠟꠣꠈꠣꠘ ꠖꠣꠙꠐ ꠖꠦꠈꠣꠁꠔ? ");
INSERT INTO syls_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","ꠝꠃꠟꠣ ꠉ, ꠀꠝꠣꠞ ꠛꠠ ꠡꠈ ꠅꠁꠟ, ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠢꠙꠣꠞꠅ ꠉꠤꠀ ꠔꠥꠝꠣꠞ ꠅꠀꠖꠣ ꠇꠞꠣ ꠅꠃ ꠡꠥꠘ꠆ꠖꠞ ꠙꠣꠠꠤꠀ ꠄꠟꠣꠇꠣ ꠀꠞ ꠟꠦꠛꠣꠘꠘ ꠖꠦꠡ ꠖꠦꠈꠔꠣꠝ, ꠝꠦꠢꠦꠞꠛꠣꠘꠤ ꠇꠞꠤ ꠎꠣꠁꠔꠦ ꠖꠤꠛꠣ ꠘꠤ? ");
INSERT INTO syls_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","ꠅꠁꠟꠦ ꠝꠣꠛꠥꠖꠦ ꠘꠣ ꠇꠞꠟꠣ, ꠔꠣꠁꠘ ꠀꠝꠣꠞ ꠀꠞꠎꠤ ꠢꠥꠘꠟꠣ ꠘꠣ, ꠔꠥꠝꠞꠣꠞ ꠇꠣꠞꠘꠦꠃ ꠔꠣꠁꠘ ꠀꠝꠣꠞ ꠃꠙꠞꠦ ꠘꠣꠞꠣꠎ ꠀꠍꠟꠣ। ꠝꠣꠛꠥꠖꠦ ꠎꠥꠀꠙ ꠖꠤꠟꠣ, ꠔꠥꠝꠤ ꠛꠃꠔ ꠇꠁꠍ, ꠁ ꠛꠦꠙꠣꠞꠦ ꠀꠞ ꠝꠣꠋꠉꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","ꠀꠁꠌ꠆ꠍꠣ, ꠔꠥꠝꠤ ꠅꠃ ꠙꠤꠍꠉꠣ ꠐꠤꠟ꠆ꠟꠣꠞ ꠃꠙꠞꠦ ꠃꠑꠅ, ꠃꠑꠤꠀ ꠃꠔꠞꠦ-ꠖꠃꠇꠘꠦ ꠀꠞ ꠙꠥꠛꠦ-ꠙꠁꠌꠝꠦ ꠌꠃꠈ ꠚꠣꠟꠣꠅ। ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋ ꠙꠣꠞꠘꠤ ꠘꠤꠡꠦꠗ ꠅꠁꠟꠦꠅ, ꠅꠘ ꠕꠣꠇꠤ ꠃꠛꠣꠁꠀ ꠢꠃ ꠖꠦꠡꠞꠦ ꠖꠦꠈꠤꠟꠣꠅ। ");
INSERT INTO syls_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","ꠀꠞ ꠔꠥꠝꠣꠞ ꠈꠣꠖꠤꠝ ꠁꠃꠍꠣꠞꠦ ꠢꠤꠇꠣꠁ ꠖꠦꠅ, ꠇꠤꠔꠣ ꠇꠤꠔꠣ ꠇꠞꠣ ꠟꠣꠉꠛ। ꠔꠣꠞ ꠢꠤꠝ꠆ꠝꠔ ꠛꠣꠠꠣꠅ, ꠜꠤꠔꠞꠦ ꠡꠣꠅꠡ ꠖꠦꠅ, ꠇꠣꠞꠘ ꠢꠇꠟ ꠝꠣꠘꠡꠞ ꠀꠉꠦ ꠞꠁꠀ ꠢꠦ ꠉꠣꠋ ꠙꠣꠞ ꠇꠞꠣꠁꠛ, ꠀꠞ ꠔꠥꠝꠤ ꠅꠘ ꠕꠣꠇꠤ ꠎꠦ ꠖꠦꠡ ꠖꠦꠈꠞꠣꠄ, ꠢꠦ ꠄꠞꠣꠞꠦꠖꠤ ꠅꠃ ꠖꠦꠡ ꠖꠈꠟ ꠇꠞꠣꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","ꠅꠈꠣꠘ ꠢꠥꠘꠤꠀ ꠀꠝꠞꠣ ꠛꠣꠄꠔ-ꠙꠤꠃꠞꠞ ꠍꠣꠝꠘꠞ ꠘꠤꠌꠣ ꠎꠣꠉꠣꠔ ꠞꠁꠉꠦꠟꠣꠝ।” ");
INSERT INTO syls_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","ꠢꠎꠞꠔ ꠝꠥꠍꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠅ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ, ꠀꠝꠤ ꠅꠈꠘ ꠎꠦ ꠡꠞꠤꠅꠔ ꠀꠞ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠇꠁꠝꠥ, ꠁꠔꠣ ꠔꠥꠝꠞꠣ ꠈꠤꠀꠟ ꠇꠞꠤ ꠢꠥꠘꠅ। ꠔꠦꠃ ꠔꠥꠝꠞꠣ ꠎꠣꠘꠦ ꠛꠣꠌꠛꠣꠄ ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦ ꠖꠦꠡ ꠖꠣꠘ ꠇꠞꠞꠣ, ꠢꠃ ꠖꠦꠡꠅ ꠉꠤꠀ ꠖꠈꠟ ꠇꠞꠔꠣꠄ ꠙꠣꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠀꠞ, ꠁ ꠢꠥꠇꠥꠝꠞ ꠟꠉꠦ ꠖꠥꠍꠞꠣ ꠇꠥꠘ꠆ꠔꠣ ꠛꠣꠠꠣꠁꠅ ꠘꠣ ꠛꠣ ꠇꠝꠣꠁꠅ ꠘꠣ। ꠀꠝꠤ ꠎꠦꠟꠣꠈꠣꠘ ꠇꠁꠞꠣꠝ, ꠔꠥꠝꠞꠣ ꠑꠤꠇ ꠅꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠢꠇꠟ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠝꠣꠘꠤꠀ ꠌꠟꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","“ꠔꠥꠝꠞꠣ ꠔ ꠘꠤꠎꠞ ꠌꠃꠈꠦ ꠖꠦꠈꠍ, ꠀꠉꠦ ꠝꠣꠛꠥꠖꠦ ꠛꠣꠀꠟ-ꠙꠤꠃꠞꠞ ꠛꠦꠙꠣꠞꠦ ꠇꠤꠔꠣ ꠇꠞꠍꠂꠘ। ꠔꠥꠝꠞꠣꠞ ꠝꠣꠎꠞ ꠎꠔ ꠎꠘꠦ ꠙꠤꠃꠞ ꠄꠟꠣꠇꠣꠞ ꠛꠣꠀꠟ ꠖꠦꠛꠔꠣꠞ ꠙꠥꠎꠣ ꠇꠞꠍꠤꠟ, ꠀꠟ꠆ꠟꠣ ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞ ꠍꠣꠝꠘꠦ ꠁꠔꠣ ꠢꠇ꠆ꠇꠟꠐꠤꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣ ꠎꠦꠞꠣ ꠖꠤꠟꠦ-ꠎꠣꠘꠦ ꠀꠟ꠆ꠟꠣ ꠝꠣꠛꠥꠖꠞ ꠀꠡꠤꠇ ꠀꠍꠟꠣꠄ, ꠔꠥꠝꠞꠣ ꠢꠇꠟꠃ ꠅꠈꠘꠅ ꠎꠤꠘ꠆ꠖꠣ ꠞꠁꠍ। ");
INSERT INTO syls_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","“ꠅꠈꠘ ꠢꠥꠘꠅ, ꠀꠝꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠀꠝꠣꠞꠦ ꠎꠦꠟꠣꠈꠣꠘ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠖꠤꠍꠟꠣ, ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠑꠤꠇ ꠅꠃ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠀꠞ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠢꠤꠇꠣꠁꠍꠤ। ꠎꠣꠔꠦ ꠔꠥꠝꠞꠣ ꠅꠈꠘ ꠎꠦ ꠖꠦꠡ ꠖꠈꠟ ꠇꠞꠣꠔ ꠎꠣꠁꠞꠣꠄ, ꠢꠃ ꠖꠦꠡꠅ ꠁꠔꠣ ꠇꠣꠝꠅ ꠟꠣꠉꠣꠅ। ");
INSERT INTO syls_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","ꠄꠞꠟꠣꠉꠤ ꠔꠥꠝꠞꠣ ꠈꠥꠛ ꠢꠥꠡꠤꠀꠞ ꠅꠁꠀ ꠁꠔꠣ ꠝꠣꠘꠤꠅ, ꠀꠞ ꠇꠣꠝꠅ ꠟꠣꠉꠣꠁꠅ। ꠔꠦꠃ ꠛꠣꠖ-ꠛꠣꠇꠤ ꠔꠣꠝꠣꠝ ꠎꠣꠔꠤꠞ ꠉꠦꠍꠦꠃ ꠁꠔꠣ ꠔꠥꠝꠞꠣꠞ ꠀꠈꠟ-ꠛꠥꠖ꠆ꠖꠤ ꠢꠤꠡꠣꠛꠦ ꠎꠣꠁꠞ ꠅꠁꠛ। ꠅꠃ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝꠞ ꠇꠕꠣ ꠢꠥꠘꠟꠦ ꠔꠣꠞꠣ ꠇꠁꠛꠣ, ꠢꠣꠍꠣꠃ ꠄꠞꠣ ꠈꠥꠛ ꠛꠠ ꠎꠣꠔꠤ ꠀꠞ ꠀꠈꠟ-ꠛꠥꠖ꠆ꠖꠤ ꠀꠟꠣ ꠎꠣꠔꠤ। ");
INSERT INTO syls_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","ꠀꠞ ꠀꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣ ꠎꠦꠟꠣ ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠟꠉꠦ ꠞꠂꠘ, ꠔꠣꠘꠞꠦ ꠒꠣꠇꠤꠟꠦ ꠎꠦꠟꠣ ꠗꠣꠞꠅ ꠙꠣꠁ, ꠅꠃ ꠖꠥꠘꠤꠀꠞ ꠛꠥꠇꠥꠔ ꠖꠥꠍꠞꠣ ꠇꠥꠘꠥ ꠛꠠ ꠎꠣꠔꠤ ꠀꠍꠂꠘ ꠘꠤ, ꠎꠦꠔꠣꠞ ꠖꠦꠛꠔꠣ ꠅꠟꠣ ꠟꠉꠦ ꠟꠉꠦ ꠞꠂꠘ? ");
INSERT INTO syls_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","ꠛꠣ ꠀꠝꠤ ꠅꠈꠘ ꠎꠦ ꠡꠞꠤꠅꠔꠞ ꠇꠕꠣ ꠇꠁꠞꠣꠝ, ꠁꠔꠣ ꠖꠥꠍꠞꠣ ꠇꠥꠘꠥ ꠛꠠ ꠎꠣꠔꠤꠞ ꠀꠍꠦ ꠘꠤ? ꠁꠟꠣ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠀꠞ ꠘꠤꠈꠥꠔ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠔꠣꠞꠣꠞ ꠀꠍꠦ ꠘꠤ? ");
INSERT INTO syls_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","“ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣ ꠎꠔꠖꠤꠘ ꠛꠣꠌꠤꠀ ꠞꠁꠛꠣꠄ, ꠅꠔꠖꠤꠘ ꠘꠤꠎꠞ ꠛꠦꠙꠣꠞꠦ ꠈꠥꠛ ꠢꠥꠡꠤꠀꠞ ꠞꠁꠅ, ꠘꠤꠎꠞ ꠖꠤꠟꠞꠦ ꠡꠣꠛꠗꠣꠘꠦ ꠞꠣꠈꠤꠅ, ꠀꠞꠘꠣꠄ ꠘꠤꠎꠞ ꠌꠈꠥꠞ ꠖꠦꠈꠣ ꠊꠐꠘꠣ ꠅꠇꠟ ꠚꠣꠃꠞꠤꠟꠤꠛꠣꠄ, ꠁꠔꠣ ꠔꠥꠝꠞꠣꠞ ꠖꠤꠟ ꠕꠣꠇꠤ ꠈꠥꠀꠁꠟꠤꠛꠣꠄ। ꠀꠞ ꠅꠃ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠔꠥꠝꠞꠣꠞ ꠙꠥꠀ-ꠙꠥꠠꠤꠘꠞꠦ ꠢꠤꠇꠣꠅ, ꠔꠣꠞꠣꠅ ꠅꠟꠣ ꠔꠣꠞꠣꠞ ꠀꠅꠟꠣꠖꠞꠦ ꠢꠤꠇꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","ꠀꠞ ꠔꠥꠝꠞꠣ ꠢꠃ ꠖꠤꠘꠞ ꠊꠐꠘꠣ ꠝꠘꠅ ꠇꠞꠅ, ꠎꠦ ꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠔꠥꠞ ꠙꠣꠠꠅ ꠀꠙꠘ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠍꠣꠝꠘꠦ ꠀꠎꠤꠞ ꠅꠁꠍꠟꠣꠄ। ꠎꠦꠛꠟꠣ ꠔꠣꠁꠘ ꠀꠝꠣꠞꠦ ꠇꠁꠍꠟꠣ, ꠀꠝꠣꠞ ꠇꠣꠟꠣꠝ ꠢꠥꠘꠣꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠤ ꠢꠇ꠆ꠇꠟ ꠝꠣꠘꠡꠞꠦ ꠖꠟꠣ ꠇꠞꠤꠀ ꠀꠝꠣꠞ ꠍꠣꠝꠘꠦ ꠀꠘꠅ, ꠔꠦꠃ ꠔꠣꠞꠣ ꠢꠤꠇꠛꠣ, ꠁ ꠎꠉꠔꠅ ꠔꠣꠞꠣ ꠎꠔꠖꠤꠘ ꠎꠤꠘ꠆ꠖꠣ ꠞꠁꠛꠣ, ꠅꠔꠖꠤꠘ ꠀꠝꠣꠞꠦ ꠒꠞꠣꠁꠀ ꠞꠁꠔꠣ, ꠀꠞ ꠔꠣꠞꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘꠞꠦꠅ ꠅꠟꠣ ꠌꠟꠣꠞ ꠔꠣꠟꠤꠝ ꠖꠤꠔꠣ। ");
INSERT INTO syls_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","ꠅꠃ ꠡꠝꠄ ꠔꠥꠝꠞꠣ ꠇꠣꠘ꠆ꠖꠣꠔ ꠉꠤꠀ ꠅꠃ ꠙꠣꠠꠞ ꠟꠣꠝꠣꠔ ꠃꠛꠣꠁꠍꠟꠣꠄ, ꠃꠛꠣꠁꠀ ꠖꠦꠈꠟꠣꠄ, ꠀꠡ꠆ꠔꠣ ꠙꠣꠠꠅ ꠖꠣꠃ ꠖꠣꠃ ꠇꠞꠤ ꠘꠥꠞꠞ ꠀꠉꠥꠁꠘ ꠎꠟꠦꠞ, ꠀꠉꠥꠁꠘꠦ ꠉꠤꠀ ꠀꠍꠝꠣꠘ ꠍꠁꠟꠤꠍꠦ, ꠀꠞ ꠉꠁꠘ ꠊꠘ ꠝꠦꠊꠞ ꠇꠣꠟꠘꠤꠄ ꠀꠘ꠆ꠖꠣꠁꠞ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","ꠢꠃ ꠘꠥꠞꠞ ꠀꠉꠥꠘꠤꠞ ꠜꠤꠔꠞꠦ ꠕꠣꠇꠤ, ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠔꠣꠘ ꠇꠣꠟꠣꠝ ꠢꠥꠘꠣꠁꠟꠣ। ꠔꠥꠝꠞꠣ ꠔꠣꠘ ꠝꠥꠈꠞ ꠀꠅꠀꠎ ꠢꠥꠘꠟꠣꠄ, ꠅꠁꠟꠦ ꠔꠣꠘ ꠇꠥꠘꠥ ꠍꠥꠞꠔ-ꠀꠇꠣꠞ ꠖꠦꠈꠣꠁꠍꠂꠘ ꠘꠣ, ꠈꠣꠟꠤ ꠔꠣꠘ ꠉꠟꠣꠞ ꠀꠅꠀꠎ ꠢꠥꠘꠍ। ");
INSERT INTO syls_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","ꠔꠣꠁꠘ ꠘꠤꠎꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠔꠣꠘ ꠟꠉꠦ ꠝꠤꠟꠘꠞ ꠃꠍꠤꠟ꠆ꠟꠣꠞ ꠀꠟ꠆ꠟꠣꠁ ꠅꠀꠖꠣ-ꠌꠥꠇ꠆ꠔꠤꠞ ꠈꠣꠍ ꠖꠡꠐꠣ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠖꠤꠟꠣ, ꠀꠞ ꠇꠁꠟꠣ ꠅꠉꠥꠁꠘ ꠝꠣꠘꠤꠀ ꠌꠟꠣꠞ ꠟꠣꠉꠤ। ꠔꠣꠘ ꠇꠥꠖꠞꠔꠤ ꠀꠔꠦ ꠖꠥꠁ ꠐꠥꠇꠞꠣ ꠙꠣꠔ꠆ꠔꠞꠞ ꠃꠙꠞꠦ ꠁꠔꠣ ꠟꠦꠈꠤꠀꠅ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","ꠢꠃ ꠡꠝꠄ ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠟꠣ, ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠔꠣꠘ ꠡꠞꠤꠅꠔꠞ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠢꠤꠇꠣꠁꠔꠣꠝ, ꠎꠣꠔꠦ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠢꠙꠣꠞꠅ ꠔꠥꠝꠞꠣ ꠎꠦ ꠖꠦꠡ ꠖꠈꠟꠅ ꠎꠣꠁꠞꠣꠄ, ꠢꠘꠅ ꠉꠤꠀ ꠢꠣꠞꠟꠦ ꠅꠔꠣ ꠝꠣꠘꠤꠀ ꠌꠟꠅ। ");
INSERT INTO syls_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","“ꠝꠣꠛꠥꠖꠦ ꠎꠦꠛꠟꠣ ꠘꠥꠞꠞ ꠀꠉꠥꠘꠤꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠔꠥꠞ ꠙꠣꠠꠅ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠍꠟꠣ, ꠢꠃ ꠖꠤꠘ ꠔ ꠔꠥꠝꠞꠣ ꠔꠣꠘ ꠇꠥꠘꠥ ꠍꠥꠞꠔ-ꠀꠇꠣꠞ ꠖꠦꠈꠍ ꠘꠣ। ꠄꠞꠟꠣꠉꠤ ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠛꠦꠙꠣꠞꠦ ꠈꠥꠛ ꠢꠥꠡꠤꠀꠞ ꠞꠁꠅ ");
INSERT INTO syls_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","ꠎꠣꠔꠦ ꠇꠥꠘꠥ ꠝꠥꠞ꠆ꠔꠤ ꠘꠣ ꠛꠣꠘꠣꠅ, ꠛꠦ-ꠙꠕꠤ ꠛꠘꠤꠀ ꠙꠥꠎꠣ ꠇꠞꠣꠞ ꠈꠤꠀꠟꠦ ꠇꠥꠘꠥ ꠛꠦꠐꠣ ꠛꠣ ꠛꠦꠐꠤꠞ ꠍꠥꠞꠔꠦ ꠝꠥꠞ꠆ꠔꠤ ꠛꠣꠘꠣꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","ꠝꠣꠐꠤꠞ ꠃꠙꠞꠦ ꠌꠟꠞꠣ ꠇꠥꠘꠥ ꠎꠤꠛ-ꠎꠣꠘꠥꠀꠞꠞ ꠍꠥꠞꠔꠦ, ꠀꠍꠝꠣꠘꠅ ꠃꠠꠞꠣ ꠇꠥꠘꠥ ꠙꠣꠈꠤꠞ ꠍꠥꠞꠔꠦ, ");
INSERT INTO syls_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","ꠛꠥꠇ ꠍꠦꠌꠠꠣꠁꠀ ꠌꠟꠞꠣ ꠇꠥꠘꠥ ꠎꠣꠘꠖꠣꠞꠞ ꠍꠥꠞꠔꠦ, ꠛꠣ ꠙꠣꠘꠤꠔ ꠞꠅꠞꠣ ꠇꠥꠘꠥ ꠎꠣꠘꠖꠣꠞꠞ ꠍꠥꠞꠔꠦ ꠝꠥꠞ꠆ꠔꠤ ꠛꠣꠘꠣꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","ꠀꠍꠝꠣꠘꠦꠖꠤ ꠌꠣꠁꠀ ꠢꠣꠞꠤ ꠌꠣꠘ꠆ꠖ, ꠡꠥꠞꠥꠎ, ꠔꠦꠞꠣ ꠅꠇꠟ ꠖꠦꠈꠤꠀ ꠅꠃ ꠘꠣꠝꠞ ꠖꠦꠛ-ꠖꠦꠛꠤ ꠛꠣ ꠚꠤꠞꠤꠡ꠆ꠔꠣꠞ ꠙꠥꠎꠣ ꠇꠞꠤꠅ ꠘꠣ, ꠄꠞꠣꠞ ꠈꠦꠎꠝꠔꠅ ꠟꠣꠉꠤꠅ ꠘꠣ। ꠁꠔꠣꠞꠦ ꠔ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠀꠍꠝꠣꠘꠞ ꠔꠟꠞ ꠢꠇꠟ ꠎꠣꠔꠤꠞ ꠟꠣꠉꠤ ꠖꠣꠘ ꠇꠞꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠙꠍꠘ꠆ꠖ ꠇꠞꠍꠂꠘ ꠟꠥꠀ ꠉꠟꠣꠘꠤꠞ ꠉꠞꠝ ꠀꠉꠥꠘꠤꠞ ꠉꠣꠔꠅ ꠕꠣꠇꠤ, ꠔꠣꠁꠘ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠍꠂꠘ, ꠎꠣꠔꠦ ꠔꠥꠝꠞꠣ ꠔꠣꠘ ꠀꠙꠘ ꠙ꠆ꠞꠎꠣ ꠅꠅ, ꠀꠞ ꠅꠈꠘ ꠔ ꠢꠣꠍꠣꠃ ꠔꠣꠘ ꠙ꠆ꠞꠎꠣ ꠅꠁꠍ। ");
INSERT INTO syls_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","“ꠅ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ, ꠔꠥꠝꠞꠣꠞ ꠇꠣꠞꠘꠦ ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞ ꠃꠙꠞꠦꠅ ꠉꠥꠍꠣ ꠇꠞꠍꠂꠘ। ꠔꠣꠁꠘ ꠇꠍꠝ ꠈꠣꠁꠀ ꠇꠁꠍꠂꠘ, ꠀꠝꠣꠞꠦ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠢꠙꠣꠞꠅ ꠎꠣꠁꠔꠦ ꠖꠤꠔꠣ ꠘꠣꠄ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦ ꠖꠦꠡꠞ ꠝꠣꠟꠤꠇꠣꠘꠣ ꠖꠤꠞꠣ, ꠅꠃ ꠀꠞꠣꠝꠞ ꠖꠦꠡꠅ ꠀꠝꠣꠞ ꠎꠣꠅꠀ ꠘꠤꠡꠦꠗ। ");
INSERT INTO syls_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","ꠀꠝꠣꠞ ꠝꠃꠔ ꠅꠘꠅꠃ ꠅꠁꠛ। ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋ ꠙꠣꠞꠘꠤꠞ ꠢꠥꠇꠥꠝ ꠘꠣꠄ। ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣ ꠉꠣꠋ ꠙꠣꠞ ꠅꠁꠀ ꠢꠃ ꠀꠞꠣꠝꠞ ꠖꠦꠡ ꠖꠈꠟ ꠇꠞꠣꠔ ꠎꠣꠁꠞꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","ꠔꠦ ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠛꠦꠙꠣꠞꠦ ꠢꠥꠡꠤꠀꠞ ꠞꠁꠅ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠎꠦ ꠅꠀꠖꠣ-ꠌꠥꠇ꠆ꠔꠤ ꠇꠣꠁꠝ ꠇꠞꠍꠂꠘ, ꠁꠔꠣ ꠚꠣꠃꠞꠤꠅ ꠘꠣ। ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠘꠤꠡꠦꠗ ꠅꠝꠣꠁꠘ꠆ꠘ ꠇꠞꠤꠀ ꠇꠥꠘꠥ ꠎꠤꠘꠤꠡꠞ ꠝꠥꠞ꠆ꠔꠤ ꠛꠣꠘꠣꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣ ꠔ ꠝꠢꠣ ꠗꠋꠡꠞ ꠀꠉꠥꠘꠤꠞ ꠟꠣꠈꠣꠘ, ꠔꠣꠁꠘ ꠔ ꠟꠣ-ꠡꠞꠤꠇ, ꠇꠥꠘꠥ ꠡꠞꠤꠇ ꠡꠁꠎ꠆ꠎ ꠇꠞꠂꠘ ꠘꠣ, ꠔꠣꠘ ꠘꠤꠎꠞ ꠙꠣꠅꠘꠣ ꠄꠛꠣꠖꠔ ꠌꠣꠁꠘꠃ ꠌꠣꠁꠘ।” ");
INSERT INTO syls_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","ꠢꠎꠞꠔ ꠝꠥꠍꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠄꠅꠈꠣꠘ ꠇꠁꠟꠣ, “ꠢꠃ ꠀꠞꠣꠝꠞ ꠖꠦꠡꠅ ꠉꠤꠀ ꠢꠣꠞꠤ, ꠔꠥꠝꠞꠣ ꠙꠥꠀ-ꠙꠥꠠꠤꠘ, ꠘꠣꠔꠤ-ꠙꠥꠔꠤꠞ ꠎꠘꠝ ꠖꠤꠀ ꠛꠃꠔ ꠖꠤꠘ ꠛꠡꠔ ꠇꠞꠣꠞ ꠛꠣꠖꠦꠅ ꠎꠥꠖꠤ ꠇꠥ-ꠙꠕꠦ ꠎꠣꠅꠉꠤ, ꠀꠞ ꠇꠥꠘꠥ ꠎꠤꠘꠤꠡꠞ ꠍꠥꠞꠔꠦ ꠝꠥꠞ꠆ꠔꠤ ꠛꠣꠘꠣꠅ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠎꠦꠔꠣꠞꠦ ꠊꠤꠘ꠆ꠘꠣ ꠇꠞꠂꠘ, ꠔꠥꠝꠞꠣ ꠅꠔꠣ ꠇꠞꠅ, ");
INSERT INTO syls_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","ꠔꠦ ꠀꠝꠤ ꠅꠈꠘ ꠀꠍꠝꠣꠘ-ꠎꠝꠤꠘ ꠡꠣꠇ꠆ꠇꠤ ꠞꠣꠈꠤꠀ ꠔꠥꠝꠞꠣꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠇꠁꠀꠞ, ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋ ꠙꠣꠞ ꠅꠁꠀ ꠎꠦ ꠖꠦꠡ ꠖꠈꠟ ꠇꠞꠣꠔ ꠎꠣꠁꠞꠣꠄ, ꠢꠤꠘꠅ ꠈꠥꠛ ꠎꠟꠖꠤ ꠔꠥꠝꠞꠣꠞ ꠘꠣꠝ ꠝꠤꠐꠤꠎꠤꠛ। ꠛꠦꠡꠤ ꠖꠤꠘ ꠐꠤꠇꠔꠣꠄ ꠙꠣꠞꠔꠣꠄ ꠘꠣꠄ, ꠘꠤꠌ꠆ꠌꠤꠔ ꠛꠤꠘꠣꠡ ꠅꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠘꠣꠘꠣꠘ ꠎꠣꠔꠤꠞ ꠝꠣꠎꠦ ꠍꠤꠔ꠆ꠞꠣꠁ ꠖꠤꠛꠣ, ꠔꠣꠁꠘ ꠈꠦꠖꠣꠁ ꠖꠤꠀ ꠎꠦꠈꠣꠘꠅ ꠙꠣꠑꠣꠁꠛꠣ, ꠢꠘꠅ ꠔꠥꠝꠞꠣꠞ ꠈꠥꠛ ꠇꠝ ꠝꠣꠘꠥꠡ ꠎꠤꠘ꠆ꠖꠣ ꠞꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","ꠅꠃ ꠢꠣꠟꠔꠦ ꠔꠥꠝꠞꠣ ꠝꠣꠘꠥꠡ-ꠀꠔꠦ ꠛꠣꠘꠣꠁꠟ ꠝꠥꠞ꠆ꠔꠤꠞ ꠙꠥꠎꠣ ꠇꠞꠛꠣꠄ, ꠎꠦꠔꠣꠄ ꠌꠃꠈꠦ ꠖꠦꠈꠦ ꠘꠣ, ꠇꠣꠘꠦ ꠢꠥꠘꠦ ꠘꠣ, ꠈꠣꠁꠔ ꠙꠣꠞꠦ ꠘꠣ, ꠇꠥꠘꠥꠎꠣꠔ ꠊꠦꠞꠣꠘꠅ ꠢꠥꠋꠉꠤꠔ ꠙꠣꠞꠦ ꠘꠣ, ꠟꠣꠇꠠꠤꠞ ꠀꠞ ꠙꠣꠔ꠆ꠔꠞꠞ ꠅꠔꠣ ꠝꠥꠞ꠆ꠔꠤꠞ ꠙꠥꠎꠣ ꠇꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","ꠔꠣ-ꠅ ꠢꠘꠅ ꠞꠁꠀ ꠎꠥꠖꠤ ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠔꠣꠟ꠆ꠟꠣꠡ ꠇꠞꠅ, ꠔꠦ ꠔꠣꠁꠘ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠤꠖꠣꠞ ꠖꠤꠛꠣ। ꠇꠕꠣ ꠅꠁꠟ, ꠖꠤꠟꠦ-ꠎꠣꠘꠦ ꠇꠣꠔꠞ ꠅꠁꠀ ꠔꠣꠘꠦ ꠒꠣꠇꠤꠔꠦ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","ꠢꠦꠡ-ꠝꠦꠡ ꠔꠥꠝꠞꠣ ꠝꠍꠤꠛꠔꠅ ꠙꠠꠤꠀ ꠢꠤꠞꠛꠣꠞ ꠔꠃꠛꠣ ꠇꠞꠤꠀ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝ ꠟꠁꠛꠣꠄ, ꠀꠞ ꠔꠣꠘ ꠈꠥꠡꠤ ꠝꠣꠚꠤꠇ ꠌꠟꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣ ꠞꠢꠝꠣꠘꠥꠞ ꠞꠢꠤꠝ, ꠔꠣꠁꠘ ꠔꠥꠝꠞꠣꠞꠦ ꠚꠣꠟꠣꠁꠔꠣ ꠘꠣꠄ ꠛꠣ ꠛꠤꠘꠣꠡ ꠇꠞꠔꠣ ꠘꠣꠄ। ꠀꠞ ꠔꠣꠁꠘ ꠇꠍꠝ ꠈꠣꠁꠀ ꠔꠥꠝꠞꠣꠞ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤꠞ ꠟꠉꠦ ꠎꠦ ꠅꠀꠖꠣ-ꠌꠥꠇ꠆ꠔꠤ ꠇꠞꠍꠂꠘ, ꠁꠔꠣꠅ ꠚꠣꠃꠞꠤꠔꠣ ꠘꠣꠄ।” ");
INSERT INTO syls_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","ꠢꠎꠞꠔ ꠝꠥꠍꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠄꠅꠈꠣꠘ ꠇꠁꠞꠣ, “ꠀꠟ꠆ꠟꠣ ꠙꠣꠇꠦ ꠎꠝꠤꠘꠅ ꠝꠣꠘꠥꠡ ꠙꠄꠖꠣ ꠇꠞꠣꠞ ꠛꠣꠖ ꠕꠣꠇꠤ ꠅꠈꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ, ꠔꠥꠝꠞꠣꠞ ꠀꠉꠞ ꠢꠇ꠆ꠇꠟ ꠎꠝꠣꠘꠣꠞ ꠁꠔꠤꠢꠣꠡ ꠔꠥꠇꠣꠅ, ꠀꠡ꠆ꠔꠣ ꠀꠍꠝꠣꠘ-ꠎꠝꠤꠘꠞ ꠄꠇ ꠝꠣꠕꠣ ꠕꠣꠇꠤ ꠀꠞꠇ ꠝꠣꠕꠣ ꠔꠥꠇꠣꠁꠀ ꠖꠦꠈꠅ, ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠃꠙꠞꠦ ꠎꠔ ꠀꠎꠛ ꠊꠐꠘꠣ ꠊꠐꠤꠍꠦ, ꠁꠔꠣ ꠟꠣꠈꠣꠘ ꠖꠥꠍꠞꠣ ꠇꠥꠘꠥ ꠊꠐꠘꠣ ꠊꠐꠍꠦ ꠘꠤ? ꠛꠣ ꠁꠟꠣ ꠇꠥꠘ꠆ꠔꠣ ꠇꠥꠘꠥꠖꠤꠘ ꠢꠥꠘꠣ ꠉꠦꠍꠦ ꠘꠤ? ");
INSERT INTO syls_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","ꠀꠞ ꠘꠥꠞꠞ ꠀꠉꠥꠁꠘ ꠕꠣꠇꠤ ꠀꠟ꠆ꠟꠣ ꠙꠣꠇꠞ ꠛꠥꠟꠤ ꠢꠥꠘꠣꠞ ꠛꠣꠖꠦ, ꠈꠣꠟꠤ ꠔꠥꠝꠞꠣ ꠍꠣꠠꠣ ꠖꠥꠍꠞꠣ ꠇꠥꠘꠥ ꠎꠣꠔꠤ ꠎꠤꠘ꠆ꠖꠣ ꠞꠁꠍꠦ ꠘꠤ? ");
INSERT INTO syls_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","ꠔꠥꠝꠞꠣ ꠔꠣꠟ꠆ꠟꠣꠡ ꠇꠞꠤ ꠖꠦꠈꠅ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞ ꠌꠈꠥꠞ ꠍꠣꠝꠘꠦ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠎꠔꠔꠣ ꠇꠞꠍꠂꠘ, ꠀꠡ꠆ꠔꠣ ꠎꠉꠔꠞ ꠇꠥꠘꠥ ꠖꠦꠛ-ꠖꠦꠛꠤꠄ ꠁꠟꠣ ꠇꠞꠔ ꠙꠣꠞꠍꠦ ꠘꠤ? ꠁꠟꠣ ꠙꠞꠤꠇ꠆ꠇꠣ ꠟꠅꠀ, ꠇꠥꠖꠞꠔꠤ ꠘꠤꠡꠣꠘꠣ ꠖꠦꠈꠣꠘꠤ, ꠟꠣꠠꠣꠁ-ꠎꠥꠖ꠆ꠖ ꠇꠞꠣ, ꠝꠎꠛꠥꠔ ꠀꠔꠞ ꠛꠟ ꠖꠦꠈꠣꠘꠤ, ꠛꠠ ꠛꠠ ꠔꠣꠁꠎ꠆ꠎꠥꠛꠤ ꠟꠤꠟꠣ-ꠈꠦꠟꠣ ꠀꠞ ꠒꠞ-ꠈꠚ ꠖꠦꠈꠣꠁꠀ, ꠎꠦꠇꠥꠘꠥ ꠎꠣꠔꠤꠞꠦ ꠅꠁꠘ꠆ꠘ ꠎꠣꠔꠤꠞ ꠜꠤꠔꠞꠦ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠤꠀ ꠘꠤꠎꠞ ꠙ꠆ꠞꠎꠣ ꠛꠣꠘꠣꠁꠔ ꠙꠣꠞꠍꠦ ꠘꠤ? ");
INSERT INTO syls_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","“ꠔꠦ ꠔꠥꠝꠞꠣ ꠎꠣꠔꠦ ꠙꠥꠞꠣꠙꠥꠞ ꠛꠥꠎꠅ, ꠅꠃ ꠀꠟ꠆ꠟꠣꠃ ꠅꠁꠟꠣ ꠝꠣꠛꠥꠖ, ꠔꠣꠁꠘ ꠍꠣꠠꠣ ꠀꠞ ꠇꠥꠘꠥ ꠝꠣꠛꠥꠖ ꠘꠣꠁ, ꠅꠈꠣꠘ ꠛꠥꠎꠣꠘꠤꠞ ꠟꠣꠉꠤꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠅꠔꠔꠣ ꠖꠦꠈꠣꠘꠤ ꠅꠁꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","ꠔꠥꠝꠞꠣꠞꠦ ꠢꠦꠖꠣꠄꠅꠔ ꠇꠞꠣꠞ ꠈꠤꠀꠟꠦ ꠔꠣꠁꠘ ꠛꠦꠢꠦꠡ꠆ꠔꠞ ꠀꠞꠡ ꠕꠣꠇꠤ ꠔꠣꠘ ꠘꠤꠎꠞ ꠛꠥꠟꠤ ꠢꠥꠘꠣꠁꠟꠣ, ꠀꠞ ꠎꠝꠤꠘꠞ ꠃꠙꠞꠦ ꠖꠦꠈꠣꠁꠟꠣ ꠘꠥꠞꠞ ꠀꠉꠥꠘꠤꠞ ꠇꠥꠘ꠆ꠒꠟꠤ। ꠅꠃ ꠀꠉꠥꠘꠤꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠛꠣꠞꠅꠁꠟ ꠀꠟ꠆ꠟꠣꠁ ꠛꠥꠟꠤ ꠔꠥꠝꠞꠣ ꠢꠥꠘꠍ। ");
INSERT INTO syls_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","ꠔꠣꠁꠘ ꠔꠥꠝꠞꠣꠞ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟꠞꠦ ꠝꠢꠛ꠆ꠛꠔ ꠇꠞꠔꠣ, ꠄꠞꠟꠣꠉꠤ ꠄꠞꠣꠞ ꠝꠃꠔꠞ ꠛꠣꠖꠦ ꠔꠣꠞꠣꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠞꠦꠅ ꠙꠍꠘ꠆ꠖ ꠇꠞꠍꠂꠘ। ꠀꠞ ꠔꠣꠁꠘ ꠡ꠆ꠛꠄꠅꠋ ꠀꠎꠤꠞ ꠅꠁꠀ ꠔꠣꠘ ꠝꠢꠣ ꠇꠥꠖꠞꠔꠤ ꠈꠦꠝꠔꠣ ꠈꠣꠐꠣꠁꠀ ꠔꠥꠝꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","ꠔꠣꠘ ꠈꠤꠀꠟ ꠀꠍꠤꠟ, ꠔꠥꠝꠣꠔꠣꠘ ꠕꠣꠇꠤ ꠛꠠ ꠀꠞ ꠛꠟꠛꠣꠘ ꠎꠣꠔꠤ ꠅꠇꠟꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠍꠣꠝꠘ ꠕꠣꠇꠤ ꠈꠦꠖꠣꠁꠀ ꠢꠣꠞꠤ, ꠔꠣꠞꠣꠞ ꠖꠦꠡꠅ ꠘꠤꠀ ꠢꠃ ꠢꠇꠟ ꠖꠦꠡꠞ ꠝꠣꠟꠤꠇꠣꠘꠣ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠤꠔꠣ। ꠅꠈꠘ ꠖꠦꠈꠞꠣꠄ ꠘꠤ, ꠔꠣꠁꠘ ꠔ ꠁꠔꠣ ꠇꠞꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","“ꠔꠦ ꠅꠈꠘꠇꠥꠞ ꠅꠃ ꠔꠣꠟꠤꠝ ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠖꠤꠟꠞ ꠝꠣꠎꠦ ꠉꠣꠕꠤꠀ ꠕꠁꠅ, ꠢꠥꠘꠅ, ꠈꠣꠟꠤ ꠅꠃ ꠀꠟ꠆ꠟꠣꠃ ꠃꠙꠞꠦ ꠀꠍꠝꠣꠘ ꠀꠞ ꠔꠟꠦ ꠎꠝꠤꠘꠞ ꠝꠣꠟꠤꠇ, ꠔꠣꠁꠘ ꠍꠣꠠꠣ ꠖꠥꠍꠞꠣ ꠇꠥꠘꠥ ꠝꠣꠛꠥꠖ ꠘꠣꠁ। ");
INSERT INTO syls_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","ꠄꠞꠟꠣꠉꠤ ꠀꠝꠤ ꠅꠈꠘ ꠎꠦ ꠡꠞꠤꠅꠔ ꠀꠞ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠎꠣꠘꠣꠁꠞꠣꠝ, ꠔꠥꠝꠞꠣ ꠁꠔꠣ ꠝꠣꠘꠤꠀ ꠌꠟꠤꠅ, ꠔꠦꠃ ꠔꠥꠝꠞꠣ ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠞ ꠜꠣꠟꠣꠁ ꠅꠁꠛ। ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠌꠤꠞꠇꠣꠟꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦ ꠖꠦꠡ ꠖꠣꠘ ꠇꠞꠞꠣ, ꠅꠃ ꠖꠦꠡꠅ ꠔꠥꠝꠞꠣꠞ ꠢꠣꠄꠀꠔꠤ ꠟꠣꠝ꠆ꠛꠣ ꠅꠁꠛ।” ");
INSERT INTO syls_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","ꠛꠣꠖꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠙꠥꠛ-ꠙꠣꠞꠞ ꠔꠤꠘꠈꠣꠘ ꠐꠣꠃꠘ ꠀꠟꠉꠣꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","ꠎꠣꠔꠦ ꠇꠥꠘꠥ ꠈꠥꠘꠤ ꠝꠣꠘꠥꠡ ꠜꠣꠉꠤꠀ ꠉꠤꠀ ꠅꠃ ꠐꠣꠃꠘꠅ ꠎꠣꠘ ꠛꠣꠌꠣꠁꠔ ꠙꠣꠞꠦ। ꠎꠦ ꠝꠣꠘꠡꠦ ꠈꠥꠘ ꠇꠞꠣꠞ ꠇꠥꠘꠥ ꠌꠤꠘ꠆ꠔꠣ ꠛꠣ ꠖꠥꠡꠝꠘꠤ ꠜꠣꠛ ꠀꠍꠤꠟ ꠘꠣ, ꠈꠣꠟꠤ ꠀꠈꠔꠣ ꠅꠘꠤꠌ꠆ꠍꠣꠄ ꠇꠦꠃꠞꠞꠦ ꠝꠣꠞꠤꠟꠣꠄ, ꠢꠦ ꠜꠣꠉꠤꠀ ꠛꠘꠛꠣꠡꠤ ꠛꠘꠤꠀ ꠅꠘꠅ ꠞꠁꠔ ꠙꠣꠞꠛ। ");
INSERT INTO syls_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","ꠔꠤꠘꠅ ꠐꠣꠃꠘ ꠅꠁꠟ, ꠞꠥꠛꠦꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠟꠣꠉꠤ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠇꠤꠘꠣꠞꠣꠞ ꠙꠣꠠꠤꠀ ꠕꠟ ꠎꠣꠉꠣꠞ ꠛꠣꠍꠤꠞ ꠘꠣꠝꠞ ꠐꠣꠃꠘ। ꠍꠣꠖꠥ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠟꠣꠉꠤ ꠉꠤꠟꠤꠅꠖ ꠄꠟꠣꠇꠣꠞ ꠞꠣꠝꠥꠔ ꠐꠣꠃꠘ। ꠝꠣꠘꠡꠣ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠟꠣꠉꠤ ꠛꠣꠡꠘ ꠖꠦꠡꠞ ꠉꠥꠟꠣꠘ ꠐꠣꠃꠘ। ");
INSERT INTO syls_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠍꠣꠝꠘꠦ ꠡꠞꠤꠅꠔꠞ ꠅꠃ ꠢꠥꠇꠥꠝ ꠛꠄꠀꠘ ꠇꠞꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁꠀ ꠀꠅꠀꠞ ꠛꠣꠖꠦ, ꠢꠇꠟ ꠢꠥꠡꠤꠀꠞꠤꠞ ꠇꠕꠣ, ꠡꠞꠤꠅꠔꠞ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠀꠞ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠎꠣꠘꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","ꠔꠣꠁꠘ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠙꠥꠛꠞ ꠙꠣꠞꠅ, ꠢꠤꠡꠛꠘ ꠄꠟꠣꠇꠣꠞ ꠀꠝꠥꠞꠤ ꠎꠣꠔꠤꠞ ꠞꠣꠎꠣ ꠍꠤꠢꠥꠘꠞ ꠖꠦꠡꠞ ꠛꠣꠄꠔ-ꠙꠤꠃꠞꠞ ꠍꠣꠝꠘꠞ ꠔꠟ ꠎꠣꠉꠣꠔ ꠁꠔꠣ ꠇꠁꠟꠣ। ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠛꠣꠞ ꠅꠁꠀ ꠀꠁꠀ ꠢꠣꠞꠟꠦ ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠀꠞ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠎꠥꠖ꠆ꠖ ꠇꠞꠤ ꠅꠃ ꠛꠣꠖꠡꠣ ꠍꠤꠢꠥꠘꠞꠦ ꠀꠞꠣꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","ꠔꠣꠞꠣ ꠛꠣꠖꠡꠣ ꠍꠤꠢꠥꠘꠞ ꠖꠦꠡ ꠀꠞ ꠛꠣꠡꠘꠞ ꠛꠣꠖꠡꠣ ꠃꠎꠞ ꠖꠦꠡ ꠖꠈꠟ ꠇꠞꠍꠟꠣ। ꠀꠝꠥꠞꠤ ꠎꠣꠔꠤꠞ ꠅꠃ ꠖꠥꠁꠅ ꠛꠣꠖꠡꠣꠞ ꠛꠣꠖꠡꠣꠁ ꠀꠍꠤꠟ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠙꠥꠛꠞ ꠙꠣꠞꠅ। ");
INSERT INTO syls_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","ꠅꠞꠘꠘ ꠈꠣꠟꠞ ꠙꠣꠞꠞ ꠀꠞꠥꠀꠞ ꠐꠣꠃꠘ ꠕꠣꠇꠤ ꠍꠤꠞꠤꠅꠘ ꠙꠣꠠ, ꠝꠣꠘꠤ ꠢꠞ꠆ꠝꠥꠘ ꠙꠣꠠ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠅꠃ ꠖꠥꠁꠅ ꠞꠣꠎꠣꠞ ꠡꠤꠝꠣꠘꠣ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","ꠄꠞ ꠜꠤꠔꠞꠦ ꠀꠍꠦ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋꠉꠞ ꠙꠥꠛꠞ ꠙꠣꠞꠞ ꠀꠡ꠆ꠔꠣ ꠄꠟꠣꠇꠣ। ꠁꠇꠐꠣ ꠙꠤꠍꠉꠣ ꠙꠣꠠꠞ ꠐꠤꠟ꠆ꠟꠣꠞ ꠔꠟꠦꠖꠤ ꠀꠞꠣꠛꠣ ꠡꠣꠉꠞꠞ ꠇꠤꠘꠣꠞꠣ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠉꠦꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","ꠝꠥꠍꠣ ꠘꠛꠤꠄ ꠔꠣꠝꠣꠝ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞꠦ ꠖꠟꠣ ꠇꠞꠣꠁꠟꠣ, ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠅ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ, ꠀꠝꠤ ꠅꠈꠘ ꠎꠦꠔꠣ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠀꠞ ꠀꠁꠘ-ꠇꠣꠘꠥꠘ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠣꠘꠣꠁꠝꠥ, ꠁꠔꠣ ꠔꠥꠝꠞꠣ ꠈꠤꠀꠟ ꠇꠞꠤ ꠢꠥꠘꠤꠅ, ꠢꠥꠘꠤꠀ ꠖꠤꠟꠅ ꠉꠣꠕꠤꠀ ꠞꠣꠈꠤꠅ ꠀꠞ ꠀꠝꠟ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","ꠀꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠞ ꠙꠣꠠꠅ ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠄꠇ ꠅꠀꠖꠣ-ꠌꠥꠇ꠆ꠔꠤ ꠛꠅꠀꠁꠟ ꠇꠞꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","ꠅꠃ ꠌꠥꠇ꠆ꠔꠤ ꠔꠣꠁꠘ ꠀꠝꠞꠣꠞ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤꠞ ꠟꠉꠦ ꠘꠣ ꠇꠞꠤꠀ, ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠇꠞꠍꠂꠘ, ꠀꠝꠞꠣ ꠎꠔ ꠎꠘ ꠅꠘꠅ ꠎꠤꠘ꠆ꠖꠣ ꠀꠍꠤ, ꠀꠝꠞꠣꠞ ꠟꠉꠦ ꠇꠞꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","ꠝꠣꠛꠥꠖꠦ ꠅꠃ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠘꠥꠞꠞ ꠀꠉꠥꠘꠤꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠍꠣꠝꠘꠣ-ꠍꠣꠝꠘꠤ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","ꠔꠥꠝꠞꠣ ꠀꠉꠥꠘꠤꠞ ꠒꠞꠦ ꠢꠃ ꠡꠝꠄ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠃꠑꠟꠣꠄ ꠘꠣ, ꠄꠞꠟꠣꠉꠤ ꠀꠝꠤ ꠔꠥꠝꠞꠣ ꠀꠞ ꠝꠣꠛꠥꠖꠞ ꠝꠣꠎꠈꠣꠘꠅ ꠃꠛꠣꠁꠀ, ꠔꠣꠘ ꠝꠥꠈꠞ ꠛꠥꠟꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠢꠥꠘꠣꠁꠍꠤ। ꠔꠣꠁꠘ ꠇꠁꠍꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ। ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠉꠥꠟꠣꠝꠤ ꠕꠣꠇꠤ ꠀꠝꠤꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠈꠣꠟꠣꠍ ꠇꠞꠤ ꠀꠘꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“ꠀꠝꠣꠞ ꠛꠖꠟꠣ ꠔꠥꠝꠞꠣ ꠖꠥꠍꠞꠣ ꠇꠥꠘꠥ ꠖꠦꠛꠔꠣ ꠝꠣꠘꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","“ꠙꠥꠎꠣ ꠇꠞꠣꠞ ꠈꠤꠀꠟꠦ ꠔꠥꠝꠞꠣ ꠇꠥꠘꠥ ꠝꠥꠞ꠆ꠔꠤ ꠛꠣꠘꠣꠁꠅ ꠘꠣ, ꠀꠍꠝꠣꠘ, ꠎꠝꠤꠘ ꠛꠣ ꠙꠣꠘꠤꠞ ꠔꠟꠦ ꠎꠔꠔꠣ ꠀꠍꠦ, ꠁꠔꠣ ꠇꠥꠘꠥꠔꠣꠞ ꠍꠥꠞꠔꠦ ꠝꠥꠞ꠆ꠔꠤ ꠛꠣꠘꠣꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","ꠔꠥꠝꠞꠣ ꠁꠔꠣꠞ ꠙꠥꠎꠣ ꠇꠞꠤꠅ ꠘꠣ, ꠁꠔꠣꠞ ꠡꠦꠛꠣ-ꠎꠔꠘ ꠇꠞꠤꠅ ꠘꠣ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠀꠝꠤ ꠀꠟ꠆ꠟꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ, ꠇꠥꠘꠥ ꠡꠞꠤꠇ ꠡꠁꠎ꠆ꠎ ꠇꠞꠤ ꠘꠣ। ꠀꠝꠣꠞꠦ ꠎꠦꠞꠣ ꠝꠣꠘꠦ ꠘꠣ, ꠀꠝꠤ ꠔꠣꠞꠣꠞ ꠉꠥꠘꠣꠞ ꠡꠣꠎꠣ ꠖꠦꠁ, ꠔꠣꠞꠣꠞ ꠙꠄꠟꠣ ꠍꠤꠠꠤ ꠕꠣꠇꠤ ꠌꠣꠁꠞ ꠍꠤꠠꠤ ꠀꠅꠟꠣꠖ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠡꠣꠎꠣ ꠖꠦꠁ। ");
INSERT INTO syls_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","ꠅꠁꠟꠦ ꠎꠦꠞꠣ ꠀꠝꠣꠞ ꠀꠡꠤꠇ ꠛꠘꠤꠀ ꠀꠝꠣꠞ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠀꠝꠟ ꠇꠞꠦ, ꠀꠝꠤ ꠔꠣꠞꠣꠞ ꠀꠎꠣꠞ ꠀꠎꠣꠞ ꠅꠀꠞꠤꠡ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠀꠝꠣꠞ ꠅꠛꠤꠞꠣꠝ ꠝꠣꠄꠀ-ꠝꠢꠛ꠆ꠛꠔ ꠖꠦꠈꠣꠁꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","“ꠛꠦꠇꠣꠝꠣ ꠇꠥꠘꠥ ꠇꠣꠞꠘꠦ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝ ꠝꠥꠈꠅ ꠟꠁꠅ ꠘꠣ। ꠇꠦꠃ ꠎꠥꠖꠤ ꠈꠣꠝꠈꠣ ꠝꠣꠛꠥꠖꠞ ꠘꠣꠝ ꠟꠄ, ꠔꠦ ꠇꠥꠘꠥꠝꠘ꠆ꠔꠦꠃ ꠀꠝꠣꠞ ꠡꠣꠎꠣ ꠕꠣꠇꠤ ꠞꠦꠢꠣꠁ ꠙꠣꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","“ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ, ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞꠞꠦ ꠙꠛꠤꠔ꠆ꠞ ꠖꠤꠘ ꠝꠣꠘꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","ꠢꠣꠙ꠆ꠔꠣꠞ ꠍꠄꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠤꠅ, ꠔꠥꠝꠞꠣꠞ ꠖꠞꠇꠣꠞꠤ ꠢꠇꠟ ꠇꠣꠝ ꠡꠣꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","ꠅꠁꠟꠦ ꠡꠣꠔ ꠘꠝ꠆ꠛꠞ ꠖꠤꠘ ꠅꠁꠟ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠘꠣꠝꠦ ꠎꠤꠞꠣꠁꠛꠣꠞ ꠖꠤꠘ। ꠁ ꠖꠤꠘ ꠔꠥꠝꠞꠣ, ꠔꠥꠝꠞꠣꠞ ꠙꠥꠀ-ꠙꠥꠠꠤꠘ, ꠉꠥꠟꠣꠝ-ꠛꠣꠘ꠆ꠖꠤꠘ, ꠉꠞꠥ-ꠉꠣꠗꠣꠁꠘ, ꠔꠥꠝꠞꠣꠞ ꠉꠣꠃꠔ ꠛꠣ ꠐꠣꠃꠘꠅ ꠞꠅꠞꠣ ꠝꠥꠍꠣꠚꠤꠞ ꠛꠣ ꠜꠤꠘ-ꠖꠦꠡꠤ, ꠇꠦꠃ ꠇꠥꠘꠥꠎꠣꠔꠞ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠤꠅ ꠘꠣ। ꠔꠥꠝꠣꠞ ꠉꠥꠟꠣꠝ-ꠛꠣꠘ꠆ꠖꠤꠄꠅ ꠔꠥꠝꠣꠞ ꠟꠣꠈꠣꠘ ꠎꠤꠞꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠕꠣꠇꠔꠦ ꠔꠥꠝꠞꠣꠅ ꠅꠟꠣ ꠉꠥꠟꠣꠝ ꠀꠍꠟꠣꠄ, ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠘ ꠛꠟꠀꠟꠣ-ꠝꠎꠛꠥꠔ ꠇꠥꠖꠞꠔꠤ ꠀꠔꠖꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠀꠎꠣꠖ ꠇꠞꠤ ꠀꠘꠍꠂꠘ। ꠄꠞꠟꠣꠉꠤ ꠔꠣꠁꠘ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠂꠘ, ꠔꠥꠝꠞꠣ ꠎꠥꠝ꠆ꠝꠣꠛꠣꠞꠞꠦ ꠙꠛꠤꠔ꠆ꠞ ꠖꠤꠘ ꠝꠣꠘꠔꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","“ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠔꠥꠝꠞꠣꠞ ꠝꠣ-ꠛꠣꠚꠞꠦ ꠁꠎ꠆ꠎꠔ ꠇꠞꠤꠅ। ꠔꠦꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠎꠦ ꠖꠦꠡ ꠖꠤꠞꠣ, ꠢꠃ ꠖꠦꠡꠅ ꠔꠥꠝꠞꠣꠞ ꠢꠣꠄꠀꠔꠤ ꠛꠣꠠꠤꠛ ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠜꠣꠟꠣꠁ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","“ꠈꠥꠘ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","“ꠎꠤꠘꠣ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","“ꠌꠥꠞꠤ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","“ꠇꠦꠃꠞꠞ ꠛꠤꠞꠥꠖ꠆ꠖꠦ ꠝꠤꠍꠣ ꠡꠣꠇ꠆ꠇꠤ ꠖꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","“ꠙꠞꠞ ꠛꠃꠞ ꠛꠣꠄ ꠟꠣꠟꠌ ꠇꠞꠤꠅ ꠘꠣ। ꠙꠞꠞ ꠊꠞ-ꠛꠣꠠꠤ, ꠎꠝꠤ-ꠝꠤꠞꠣꠡ, ꠉꠥꠟꠣꠝ-ꠛꠣꠘ꠆ꠖꠤ, ꠉꠞꠥ-ꠉꠣꠗꠣ, ꠛꠣ ꠇꠥꠘꠥ ꠎꠤꠘꠤꠡꠞ ꠛꠣꠄ ꠟꠣꠟꠌ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","“ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠡ꠆ꠛꠄꠅꠋ ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠔꠥꠞ ꠙꠣꠠꠞ ꠃꠙꠞꠞ ꠢꠃ ꠘꠥꠞꠞ ꠀꠉꠥꠁꠘ ꠕꠣꠇꠤ, ꠝꠦꠊꠞ ꠇꠣꠟꠘꠤ ꠀꠞ ꠉꠁꠘ ꠀꠘ꠆ꠖꠣꠞꠤꠞ ꠜꠤꠔꠞꠦ ꠕꠣꠇꠤ, ꠈꠥꠛ ꠎꠥꠞꠦ ꠎꠥꠞꠦ ꠅꠃ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠂꠘ। ꠈꠣꠟꠤ ꠅꠃ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠍꠣꠠꠣ ꠔꠥꠝꠞꠣꠞꠦ ꠀꠞ ꠇꠥꠘꠥꠔꠣ ꠇꠁꠍꠂꠘ ꠘꠣ। ꠛꠣꠖꠦ ꠅꠃ ꠇꠣꠟꠣꠝ ꠅꠇꠟꠞꠦ ꠖꠥꠁ ꠐꠥꠇꠞꠣ ꠙꠣꠔ꠆ꠔꠞꠞ ꠃꠙꠞꠦ ꠔꠣꠘ ꠇꠥꠖꠞꠔꠤ ꠀꠔꠦ ꠟꠦꠈꠤꠀ ꠀꠝꠣꠞ ꠀꠔꠅ ꠖꠤꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","ꠅꠁꠟꠦ ꠔꠣꠘ ꠘꠥꠞꠞ ꠔꠎꠟ꠆ꠟꠤꠄ ꠎꠦꠛꠟꠣ ꠙꠣꠠ ꠎꠟꠦꠞ, ꠄꠞꠝꠣꠎꠦ ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠇꠣꠘꠦ ꠢꠥꠘꠟꠣꠄ, ꠢꠃ ꠀꠘ꠆ꠖꠣꠞꠤꠞ ꠜꠤꠔꠞꠦ ꠕꠣꠇꠤ ꠝꠣꠛꠥꠖꠞ ꠉꠟꠣꠞ ꠀꠅꠀꠎ, ꠢꠥꠘꠤꠀ ꠔꠥꠝꠞꠣꠞ ꠢꠇꠟ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠀꠝꠤꠞ ꠅꠇꠟ, ꠔꠥꠝꠞꠣꠞ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟ ꠀꠝꠣꠞ ꠉꠦꠍꠦ ꠃꠑꠤꠀ ꠀꠁꠟꠣ, ");
INSERT INTO syls_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","ꠀꠁꠀ ꠇꠁꠟꠣ, ꠀꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠖꠤꠖꠣꠞ ꠖꠤꠀ ꠔꠣꠘ ꠎꠣꠟꠣꠟ ꠀꠞ ꠝꠢꠤꠝꠣ ꠀꠝꠞꠣꠞꠦ ꠖꠦꠈꠣꠁꠍꠂꠘ, ꠘꠥꠞꠞ ꠀꠉꠥꠁꠘ ꠕꠣꠇꠤ ꠛꠣꠞꠅꠁꠟ ꠔꠣꠘ ꠉꠟꠣꠞ ꠀꠅꠀꠎ ꠀꠝꠞꠣ ꠢꠥꠘꠍꠤ। ꠀꠞ ꠅꠈꠘ ꠀꠝꠞꠣ ꠛꠥꠎꠟꠣꠝ, ꠇꠥꠘꠥ ꠀꠖꠝ ꠎꠣꠔꠦ ꠀꠟ꠆ꠟꠣ ꠙꠣꠇꠞ ꠟꠉꠦ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠣꠞ ꠛꠣꠖꠦꠅ, ꠁ ꠀꠖꠝ ꠛꠣꠌꠤꠀ ꠞꠄ। ");
INSERT INTO syls_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","ꠅꠁꠟꠦ ꠅꠈꠘ ꠇꠦꠘꠦ ꠀꠝꠞꠣ ꠁꠘꠅ ꠝꠞꠔꠣꠝ? ꠇꠥꠖꠞꠔꠤ ꠁ ꠀꠉꠥꠁꠘꠦ ꠔ ꠀꠝꠞꠣꠞꠦ ꠎꠣꠟꠣꠁꠟꠤꠛ, ꠀꠝꠞꠣ ꠎꠥꠖꠤ ꠀꠞꠅ ꠛꠦꠡ ꠇꠞꠤ ꠀꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠉꠟꠣꠞ ꠀꠅꠀꠎ ꠢꠥꠘꠣꠔ ꠞꠁ, ꠔꠦ ꠔ ꠘꠤꠞ꠆ꠉꠣꠔ ꠝꠞꠘ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","ꠀꠝꠞꠣꠞ ꠟꠣꠈꠣꠘ ꠁꠟꠣ ꠀꠞ ꠇꠥꠘꠥ ꠀꠖꠝ ꠎꠣꠔ ꠀꠍꠂꠘ ꠘꠤ, ꠎꠦꠞꠣ ꠘꠥꠞꠞ ꠀꠉꠥꠁꠘ ꠕꠣꠇꠤ ꠎꠤꠘ꠆ꠖꠣ ꠀꠟ꠆ꠟꠣ ꠙꠣꠇꠞ ꠉꠟꠣꠞ ꠀꠅꠀꠎ ꠢꠥꠘꠣꠞ ꠛꠣꠖꠦꠅ ꠎꠤꠔꠣ ꠀꠍꠦ? ");
INSERT INTO syls_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","ꠔꠦ ꠀꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠎꠔꠔꠣ ꠛꠣꠔꠣꠁꠍꠂꠘ, ꠔꠣꠘ ꠇꠣꠘ꠆ꠖꠣꠔ ꠉꠤꠀ ꠀꠙꠘꠦꠃ ꠅꠔꠣ ꠢꠥꠘꠤꠀ ꠀꠁꠃꠇ꠆ꠇꠣ। ꠔꠣꠁꠘ ꠀꠙꠘꠣꠞ ꠉꠦꠍꠦ ꠎꠦꠔꠣ ꠎꠣꠘꠣꠁꠛꠣ, ꠀꠙꠘꠦ ꠀꠁꠀ ꠅꠔꠣ ꠀꠝꠞꠣꠞꠦ ꠢꠥꠘꠣꠁꠛꠣ। ꠔꠦꠃ ꠀꠝꠞꠣ ꠅꠔꠣ ꠀꠝꠟ ꠇꠞꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","“ꠀꠞ ꠢꠃ ꠡꠝꠄ ꠔꠥꠝꠞꠣ ꠎꠦꠛꠟꠣ ꠀꠝꠣꠞ ꠟꠉꠦ ꠝꠣꠔꠤꠞꠣꠄ, ꠡ꠆ꠛꠄꠅꠋ ꠝꠣꠛꠥꠖꠦ ꠁꠔꠣ ꠢꠥꠘꠟꠣ, ꠢꠥꠘꠤꠀ ꠀꠝꠣꠞꠦ ꠇꠁꠟꠣ, ꠅꠃ ꠝꠣꠘꠥꠡ ꠅꠇꠟꠞ ꠝꠣꠔ-ꠇꠕꠣ ꠔ ꠀꠝꠤ ꠢꠥꠘꠍꠤ, ꠔꠣꠞꠣ ꠔꠥꠝꠣꠞꠦ ꠎꠦꠔꠣ ꠇꠁꠍꠂꠘ ꠁꠔꠣ ꠢꠇꠟꠔꠣꠃ ꠜꠣꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","ꠢꠣꠍꠣꠃ ꠎꠥꠖꠤ ꠔꠣꠞꠣ ꠀꠝꠣꠞꠦ ꠅꠟꠣ ꠒꠞꠣꠁꠘ, ꠢꠣꠝꠦꠡꠣ ꠀꠝꠣꠞ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠝꠣꠘꠤꠀ ꠌꠟꠣꠞ ꠈꠤꠀꠟꠤ ꠅꠁꠘ, ꠔꠦ ꠔꠣꠞꠣ ꠀꠞ ꠔꠣꠞꠣꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠞ ꠌꠤꠞꠇꠣꠟꠤꠘ ꠜꠣꠟꠣꠁ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","“ꠅꠈꠘ ꠔꠥꠝꠤ ꠟꠣꠝꠣꠔ ꠎꠣꠅ ꠀꠞ ꠔꠣꠞꠣꠞꠦ ꠇꠅ, ꠔꠣꠞꠣꠞ ꠔꠣꠝ꠆ꠛꠥꠔ ꠚꠤꠞꠤꠀ ꠎꠣꠁꠔꠣꠉꠤ। ");
INSERT INTO syls_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","ꠅꠁꠟꠦ ꠔꠥꠝꠤ ꠅꠘꠅ ꠀꠝꠣꠞ ꠇꠣꠘ꠆ꠖꠣꠔ ꠞꠁꠅ। ꠀꠝꠤ ꠔꠥꠝꠣꠞꠦ ꠀꠝꠣꠞ ꠢꠇꠟ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ, ꠀꠁꠘ-ꠇꠣꠘꠥꠘ ꠀꠞ ꠡꠞꠤꠅꠔ ꠛꠣꠔꠣꠁꠝꠥ, ꠔꠥꠝꠤ ꠉꠤꠀ ꠔꠣꠞꠣꠞꠦ ꠅꠔꠣ ꠢꠤꠇꠣꠁꠛꠣꠄ। ꠔꠦꠃ ꠀꠝꠤ ꠔꠣꠞꠣꠞꠦ ꠎꠦ ꠖꠦꠡꠞ ꠖꠈꠟꠖꠣꠞꠤ ꠖꠤꠀꠞ, ꠢꠃ ꠖꠦꠡꠅ ꠉꠤꠀ ꠢꠣꠞꠤ ꠔꠣꠞꠣ ꠅꠔꠣ ꠀꠝꠟ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","“ꠄꠞꠟꠣꠉꠤꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦꠔꠣ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠖꠤꠍꠂꠘ, ꠁꠔꠣ ꠎꠔꠘ ꠇꠞꠤꠀ ꠀꠖꠣꠄ ꠇꠞꠤꠅ, ꠁꠔꠣꠞ ꠔꠤꠟ ꠙꠞꠤꠝꠣꠘ ꠢꠦꠞ-ꠚꠦꠞ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","ꠔꠣꠁꠘ ꠎꠦ ꠙꠕꠦ ꠌꠟꠣꠞ ꠟꠣꠉꠤ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠂꠘ, ꠑꠤꠇ ꠅꠃ ꠙꠕꠦ ꠌꠟꠤꠅ, ꠔꠦꠃ ꠔꠥꠝꠞꠣ ꠎꠣꠘꠦ ꠛꠣꠌꠛꠣꠄ, ꠔꠥꠝꠞꠣꠞ ꠜꠣꠟꠣꠁ ꠅꠁꠛ, ꠀꠞ ꠔꠥꠝꠞꠣ ꠎꠦ ꠖꠦꠡꠞ ꠖꠈꠟꠖꠣꠞꠤ ꠙꠣꠁꠛꠣꠄ, ꠢꠃ ꠖꠦꠡꠅ ꠔꠥꠝꠞꠣꠞ ꠢꠣꠄꠀꠔꠤ ꠛꠃꠔ ꠟꠣꠝ꠆ꠛꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","“ꠔꠥꠝꠞꠣꠞꠦ ꠢꠤꠇꠣꠘꠤꠞ ꠘꠤꠅꠔꠦ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠀꠝꠣꠞꠦ ꠅꠃ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ, ꠡꠞꠤꠅꠔ ꠀꠞ ꠀꠁꠘ-ꠇꠣꠘꠥꠘ ꠖꠤꠍꠂꠘ, ꠎꠣꠔꠦ ꠢꠃ ꠎꠦ ꠖꠦꠡ ꠖꠈꠟ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠔꠥꠝꠞꠣ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋ ꠙꠣꠞ ꠅꠁꠀ ꠎꠣꠁꠞꠣꠄ, ꠢꠘꠅ ꠉꠤꠀ ꠢꠣꠞꠤ ꠔꠥꠝꠞꠣ ꠁꠔꠣ ꠀꠝꠟ ꠇꠞꠅ। ");
INSERT INTO syls_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","ꠔꠦꠃ ꠔꠥꠝꠞꠣ, ꠔꠥꠝꠞꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ ꠀꠞ ꠔꠣꠞꠣꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠦ ꠢꠣꠞꠣ ꠎꠤꠘ꠆ꠖꠦꠉꠤ ꠀꠟ꠆ꠟꠣ ꠝꠣꠛꠥꠖꠞꠦ ꠒꠞꠣꠁꠀ ꠔꠣꠘ ꠖꠦꠅꠀ ꠘꠤꠅꠝ ꠀꠞ ꠢꠥꠇꠥꠝ ꠅꠇꠟ ꠀꠝꠟ ꠇꠞꠤꠅ। ꠅꠟꠣ ꠇꠞꠟꠦ ꠔꠥꠝꠞꠣ ꠛꠃꠔ ꠖꠤꠘ ꠛꠣꠌꠤꠀ ꠞꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","ꠅ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ, ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠇꠕꠣ ꠢꠥꠘꠅ ꠀꠞ ꠢꠥꠡꠤꠀꠞ ꠅꠁꠀ ꠁꠔꠣ ꠀꠝꠟ ꠇꠞꠅ, ꠔꠦꠃ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣ ꠅꠇꠟꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠅꠀꠖꠣ ꠝꠣꠚꠤꠇ, ꠢꠃ ꠖꠥꠗ ꠀꠞ ꠝꠃꠞ ꠜꠣꠘ꠆ꠒꠣꠞ ꠀꠟꠣ ꠖꠦꠡꠅ ꠔꠥꠝꠞꠣꠞ ꠜꠣꠟꠣꠁ ꠅꠁꠛ ꠀꠞ ꠔꠥꠝꠞꠣ ꠛꠃꠔ ꠛꠣꠠꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","“ꠅ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ, ꠢꠥꠘꠅ, ꠀꠟ꠆ꠟꠣ ꠀꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ, ꠔꠣꠁꠘꠃ ꠄꠇ। ");
INSERT INTO syls_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","ꠔꠥꠝꠞꠣ ꠙꠞꠔꠦꠇꠦ ꠔꠥꠝꠞꠣꠞ ꠀꠡ꠆ꠔꠣ ꠖꠤꠟ, ꠀꠡ꠆ꠔꠣ ꠎꠣꠘ ꠀꠞ ꠢꠇꠟ ꠛꠟ-ꠡꠇ꠆ꠔꠤ ꠖꠤꠀ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞꠦ ꠝꠢꠛ꠆ꠛꠔ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","ꠀꠁꠎ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠀꠞ, ꠁꠔꠣ ꠔꠥꠝꠞꠣꠞ ꠖꠤꠟꠅ ꠉꠣꠕꠤꠀ ꠞꠣꠈꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","ꠔꠥꠝꠞꠣ ꠢꠇꠟꠦ ꠔꠥꠝꠞꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘꠞꠦ ꠁꠔꠣ ꠈꠤꠀꠟ ꠇꠞꠤ ꠢꠤꠇꠣꠁꠅ। ꠀꠞ ꠊꠞꠅ ꠛꠁꠀ, ꠙꠕꠦ-ꠊꠣꠐꠦ ꠌꠟꠣꠞ ꠡꠝꠄ, ꠊꠥꠝꠣꠘꠤꠞ ꠡꠝꠄ, ꠊꠥꠝ ꠕꠣꠇꠤ ꠃꠑꠣꠞ ꠛꠣꠖꠦꠅ ꠅꠔꠣ ꠛꠦꠙꠣꠞꠦ ꠝꠣꠔꠣ-ꠝꠣꠔꠤ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","ꠝꠘꠅ ꠞꠣꠈꠣꠞ ꠘꠤꠡꠣꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠁꠔꠣ ꠀꠔꠅ ꠛꠣꠘ꠆ꠖꠤꠀ ꠞꠣꠈꠤꠅ ꠀꠞ ꠇꠙꠣꠟꠞ ꠝꠣꠎꠦ ꠟꠣꠉꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","ꠔꠥꠝꠞꠣꠞ ꠖꠥꠀꠞꠞ ꠌꠃꠇꠣꠑꠅ ꠀꠞ ꠝꠥꠟ ꠉꠦꠁꠐꠅ ꠟꠦꠈꠤꠀ ꠞꠣꠈꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","“ꠔꠥꠝꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣ ꠁꠛ꠆ꠞꠣꠢꠤꠝ, ꠁꠍꠢꠣꠇ ꠀꠞ ꠁꠀꠇꠥꠛꠞ ꠉꠦꠍꠦ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠇꠍꠝ ꠈꠣꠁꠀ ꠎꠦ ꠖꠦꠡ ꠖꠦꠅꠀꠞ ꠅꠀꠖꠣ ꠇꠞꠍꠂꠘ, ꠢꠃ ꠖꠦꠡ ꠔꠣꠁꠘ ꠔꠥꠝꠞꠣꠞꠦ ꠘꠤꠛꠣ। ꠢꠤꠘꠅ ꠡꠥꠘ꠆ꠖꠞ ꠡꠥꠘ꠆ꠖꠞ ꠀꠞ ꠛꠠ ꠛꠠ ꠐꠣꠃꠘ ꠅꠇꠟ ꠀꠍꠦ, ꠎꠦꠔꠣ ꠔꠥꠝꠞꠣ ꠛꠣꠘꠣꠁꠍ ꠘꠣ, ꠈꠣꠟꠤ ꠄꠝꠘꠦꠃ ꠙꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","ꠀꠞ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣꠄ ꠜꠞꠣ ꠢꠣꠎꠣꠁꠟ-ꠙꠣꠠꠣꠁꠟ ꠊꠞ-ꠖꠥꠀꠞ ꠙꠣꠁꠛꠣꠄ, ꠎꠦꠔꠣ ꠔꠥꠝꠞꠣ ꠎꠥꠉꠣꠁꠍ ꠘꠣ, ꠙꠣꠘꠤꠞ ꠇꠥꠀ ꠙꠣꠁꠛꠣꠄ ꠎꠦꠔꠣ ꠔꠥꠝꠞꠣ ꠈꠥꠖꠤꠍ ꠘꠣ, ꠀꠋꠉꠥꠞꠞ ꠛꠣꠉꠣꠘ ꠀꠞ ꠎꠄꠔꠥꠘꠞ ꠛꠣꠉꠣꠘ ꠙꠣꠁꠛꠣꠄ ꠎꠦꠔꠣ ꠔꠥꠝꠞꠣ ꠟꠣꠉꠣꠁꠍ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣ ꠢꠥꠡꠤꠀꠞ ꠞꠁꠅ, ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠙꠣꠁꠀ ꠢꠣꠞꠤ ꠝꠣꠟꠖꠣꠞ ꠛꠘꠤꠀ ꠔꠥꠝꠞꠣꠞ ꠢꠃ ꠀꠟ꠆ꠟꠣ ꠝꠣꠛꠥꠖꠞꠦ ꠚꠣꠃꠞꠤꠅ ꠘꠣ, ꠎꠦꠁꠘ ꠔꠥꠝꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠉꠥꠟꠣꠝꠤ ꠕꠣꠇꠤ ꠈꠣꠟꠣꠍ ꠇꠞꠤꠀ ꠀꠘꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","“ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞꠦ ꠒꠞꠣꠁꠀ ꠌꠟꠤꠅ, ꠈꠣꠟꠤ ꠔꠣꠘ ꠄꠛꠣꠖꠔ ꠇꠞꠤꠅ, ꠀꠞ ꠔꠣꠘ ꠘꠣꠝꠦ ꠇꠍꠝ ꠈꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","ꠔꠥꠝꠞꠣ ꠀꠞꠤ-ꠚꠞꠤ ꠎꠣꠔꠤꠞ ꠖꠦꠛ-ꠖꠦꠛꠤꠞ ꠙꠥꠎꠣ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","ꠎꠣꠘ ꠔ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣ ꠎꠦꠁꠘ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠀꠍꠂꠘ, ꠔꠣꠁꠘ ꠔ ꠟꠣ-ꠡꠞꠤꠇ ꠝꠣꠛꠥꠖ, ꠇꠥꠘꠥ ꠡꠞꠤꠇ ꠡꠁꠎ꠆ꠎ ꠇꠞꠂꠘ ꠘꠣ। ꠄꠞꠟꠣꠉꠤ ꠢꠥꠡꠤꠀꠞ ꠞꠁꠅ, ꠁꠔꠣꠞ ꠙꠥꠎꠣ ꠇꠞꠟꠦ ꠔꠣꠁꠘ ꠉꠥꠍꠣꠄ ꠀꠉꠥꠁꠘ ꠅꠁꠀ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠥꠘꠤꠀ ꠕꠣꠇꠤ ꠚꠥꠍꠤꠟꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞꠦ ꠙꠞꠤꠇ꠆ꠇꠣ ꠇꠞꠣꠔ ꠟꠣꠉꠤꠅ ꠘꠣ, ꠎꠦꠟꠣ ꠀꠉꠦ ꠢꠃ ꠝꠣꠍꠣ ꠘꠣꠝꠞ ꠎꠣꠉꠣꠔ ꠇꠞꠍꠟꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠔ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ, ꠢꠥꠡꠤꠀꠞꠤ ꠀꠞ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠖꠤꠍꠂꠘ, ꠁꠔꠣ ꠔꠥꠝꠞꠣ ꠈꠤꠀꠟ ꠇꠞꠤ ꠝꠣꠘꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","19","ꠀꠞ ꠝꠣꠛꠥꠖꠞ ꠘꠎꠞꠅ ꠎꠦꠔꠣ ꠡꠑꠤꠇ, ꠔꠣꠁꠘ ꠎꠦꠔꠣ ꠜꠣꠟꠣ ꠙꠣꠁꠘ, ꠔꠥꠝꠞꠣ ꠅꠔꠣꠃ ꠇꠞꠤꠅ, ꠔꠦꠃ ꠔꠥꠝꠞꠣꠞ ꠜꠣꠟꠣꠁ ꠅꠁꠛ। ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠞ ꠉꠦꠍꠦ ꠎꠦ ꠖꠦꠡ ꠖꠤꠛꠣꠞ ꠇꠍꠝ ꠇꠞꠍꠂꠘ, ꠢꠃ ꠖꠦꠡ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣꠞ ꠖꠥꠡꠝꠘꠞꠦ ꠔꠣꠁꠘ ꠈꠦꠖꠣꠁꠀ ꠖꠤꠛꠣ। ꠀꠞ ꠝꠣꠛꠥꠖꠞ ꠅꠀꠖꠣ ꠝꠣꠚꠤꠇ ꠢꠃ ꠀꠞꠣꠝꠞ ꠖꠦꠡꠞ ꠖꠈꠟꠖꠣꠞꠤꠅ ꠔꠥꠝꠞꠣ ꠙꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","“ꠜꠛꠤꠡꠔꠦ ꠎꠦꠛꠟꠣ ꠔꠥꠝꠞꠣꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠤꠇꠣꠁꠛꠣ, ꠀꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠅꠃ ꠎꠦꠔꠣ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ, ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ, ꠀꠞ ꠢꠥꠡꠤꠀꠞꠤ ꠖꠤꠍꠂꠘ ꠁꠔꠣꠞ ꠝꠣꠘꠤ ꠇꠤꠔꠣ? ");
INSERT INTO syls_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","ꠅꠃ ꠡꠝꠄ ꠎꠥꠀꠙ ꠖꠤꠅ, ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠀꠝꠞꠣ ꠚꠦꠞꠣꠃꠘꠞ ꠉꠥꠟꠣꠝ ꠀꠍꠟꠣꠝ, ꠅꠁꠟꠦ ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠘ ꠛꠟꠀꠟꠣ ꠇꠥꠖꠞꠔꠤ ꠀꠔ ꠖꠤꠀ ꠀꠝꠞꠣꠞꠦ ꠛꠣꠞ ꠇꠞꠤꠀ ꠀꠘꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","ꠝꠣꠛꠥꠖꠦ ꠀꠝꠞꠣꠞ ꠌꠈꠥꠞ ꠍꠣꠝꠘꠦ ꠚꠦꠞꠣꠃꠘ ꠀꠞ ꠔꠣꠞ ꠛꠣꠠꠤꠞ ꠢꠇꠟꠞ ꠃꠙꠞꠦ, ꠀꠡ꠆ꠔꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠃꠙꠞꠦ ꠛꠠ ꠛꠠ ꠉꠎꠛꠤ ꠘꠤꠡꠣꠘꠣ, ꠛꠦꠎꠥꠁꠔꠣ ꠛꠣꠟꠣ-ꠝꠍꠤꠛꠔ ꠀꠞ ꠇꠥꠖꠞꠔꠤ ꠇꠣꠝ ꠖꠦꠈꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","ꠅꠁꠟꠦ ꠀꠝꠞꠣꠞꠦ ꠔꠣꠁꠘ ꠢꠃ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤꠀ ꠀꠘꠟꠣ, ꠎꠣꠔꠦ ꠎꠦ ꠖꠦꠡ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠀꠝꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣ ꠅꠇꠟꠞ ꠉꠦꠍꠦ ꠇꠍꠝ ꠈꠣꠁꠍꠟꠣ, ꠢꠃ ꠖꠦꠡꠅ ꠀꠝꠞꠣꠞꠦ ꠙꠣꠞ ꠇꠞꠤꠀ ꠖꠈꠟꠖꠣꠞꠤ ꠖꠦꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","ꠀꠞ ꠔꠣꠁꠘ ꠢꠥꠇꠥꠝ ꠖꠤꠟꠣ, ꠀꠝꠞꠣ ꠎꠣꠘꠥ ꠔꠣꠘ ꠢꠇꠟ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠝꠣꠘꠤ, ꠔꠣꠘꠞꠦ ꠒꠞꠣꠁꠀ ꠌꠟꠤ, ꠔꠦꠃ ꠀꠝꠞꠣꠞ ꠜꠣꠟꠣꠁ ꠅꠁꠛ ꠀꠞ ꠀꠝꠞꠣ ꠅꠈꠘꠇꠥꠞ ꠟꠣꠈꠣꠘ ꠢꠣꠝꠦꠡꠣ ꠛꠣꠌꠤꠀ ꠞꠁꠝꠥ। ");
INSERT INTO syls_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","ꠅꠈꠘ ꠀꠝꠞꠣ ꠎꠥꠖꠤ ꠀꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠔꠣꠘ ꠖꠦꠅꠀ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠈꠤꠀꠟ ꠇꠞꠤꠀ ꠝꠣꠘꠤ, ꠔꠦ ꠁꠐꠣꠃ ꠅꠁꠟ ꠀꠝꠞꠣꠞ ꠙꠞꠦꠎꠉꠣꠞꠤ।” ");
INSERT INTO syls_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","ꠢꠎꠞꠔ ꠝꠥꠍꠣꠄ ꠀꠞꠅ ꠇꠁꠟꠣ, “ꠢꠥꠘꠅ, ꠔꠥꠝꠞꠣ ꠎꠦ ꠖꠦꠡ ꠖꠈꠟ ꠇꠞꠣꠔ ꠎꠣꠁꠞꠣꠄ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠢꠘꠅ ꠘꠤꠛꠣ ꠀꠞ ꠛꠃꠔ ꠎꠣꠔꠤꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠍꠣꠝꠘꠦ ꠕꠣꠇꠤ ꠈꠦꠖꠣꠁꠀ ꠢꠣꠞꠤ ꠁꠔꠣ ꠖꠈꠟ ꠇꠞꠣꠁꠛꠣ। ꠔꠣꠁꠘ ꠢꠤꠐ꠆ꠐꠤ, ꠉꠤꠞ꠆ꠉꠣꠡꠤ, ꠀꠝꠥꠞꠤ, ꠇꠦꠘꠣꠘꠤ, ꠚꠣꠞꠤꠎꠤ, ꠢꠤꠛ꠆ꠛꠤ ꠀꠞ ꠎꠤꠛꠥꠎꠤ ꠎꠣꠔꠤꠞꠦ ꠈꠦꠖꠣꠁ ꠖꠤꠛꠣ, ꠁ ꠡꠣꠔꠅ ꠎꠣꠔꠤꠃ ꠙꠞꠤꠝꠣꠘꠦ ꠔꠥꠝꠞꠣ ꠕꠣꠇꠤ ꠛꠠ ꠀꠞ ꠛꠟꠀꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠎꠦꠛꠟꠣ ꠁꠔꠣꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠀꠔꠅ ꠡꠙꠤꠀ ꠖꠤꠛꠣ, ꠅꠃ ꠡꠝꠄ ꠔꠥꠝꠞꠣ ꠔꠣꠞꠣꠞꠦ ꠄꠇ꠆ꠇꠦꠛꠣꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠤꠟꠤꠅ, ꠔꠣꠞꠣꠞ ꠟꠉꠦ ꠇꠥꠘꠥ ꠌꠥꠇ꠆ꠔꠤ ꠇꠞꠤꠅ ꠘꠣ, ꠀꠞ ꠇꠥꠘꠥ ꠖꠄꠀ-ꠝꠣꠄꠀ ꠖꠦꠈꠣꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","ꠁꠔꠣꠞ ꠟꠉꠦ ꠛꠤꠀ-ꠡꠣꠖꠤꠞ ꠛꠦꠙꠣꠞꠦ ꠇꠥꠘꠥ ꠌꠥꠇ꠆ꠔꠤ ꠇꠞꠤꠅ ꠘꠣ। ꠔꠥꠝꠞꠣꠞ ꠙꠥꠠꠤꠘ꠆ꠔꠞꠦ ꠔꠣꠞꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠉꠦꠍꠦ ꠛꠤꠀ ꠖꠤꠅ ꠘꠣ, ꠀꠞ ꠔꠣꠞꠣꠞ ꠙꠥꠠꠤꠘꠞꠦꠅ ꠔꠥꠝꠞꠣꠞ ꠙꠥꠀꠂꠘ꠆ꠔꠞ ꠟꠣꠉꠤ ꠀꠘꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","ꠇꠣꠞꠘ ꠁꠔꠣꠄ ꠔꠥꠝꠞꠣꠞ ꠙꠥꠀ-ꠙꠥꠠꠤꠘꠞꠦ ꠀꠝꠣꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠢꠞꠣꠁꠀ ꠖꠦꠛ-ꠖꠦꠛꠤꠞ ꠙꠥꠎꠣ ꠇꠞꠣꠁꠛ। ꠔꠦꠃ ꠀꠟ꠆ꠟꠣ ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞ ꠃꠙꠞꠦ ꠉꠥꠍꠣ ꠅꠁꠀ, ꠟꠉꠦ ꠟꠉꠦꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","ꠄꠞꠟꠣꠉꠤ ꠔꠥꠝꠞꠣ ꠔꠣꠞꠣꠞ ꠢꠇꠟ ꠙꠥꠎꠣ-ꠝꠘ꠆ꠒꠙ ꠜꠣꠋꠉꠤꠟꠤꠅ, ꠙꠥꠎꠣꠞ ꠎꠣꠉꠣ ꠅꠇꠟ ꠛꠤꠘꠣꠡ ꠇꠞꠤꠅ, ꠀꠡꠦꠞꠣ-ꠖꠦꠛꠤꠞ ꠘꠤꠡꠣꠘꠣ ꠈꠥꠐꠤ ꠇꠣꠐꠤꠀ ꠚꠣꠟꠣꠁꠅ, ꠀꠞ ꠢꠇꠟ ꠎꠣꠔꠞ ꠝꠥꠞ꠆ꠔꠤꠞꠦ ꠀꠉꠥꠁꠘꠖꠤ ꠎꠣꠟꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠔꠥꠝꠞꠣꠃ ꠅꠁꠟꠣꠄ ꠀꠟ꠆ꠟꠣ ꠝꠣꠛꠥꠖꠞ ꠙꠛꠤꠔ꠆ꠞ ꠙ꠆ꠞꠎꠣ। ꠖꠥꠘꠤꠀꠞ ꠢꠇꠟ ꠎꠣꠔꠤꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠔꠣꠁꠘꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠘꠤꠎꠞ ꠙ꠆ꠞꠎꠣ ꠀꠞ ꠈꠣꠍ ꠡꠝ꠆ꠙꠖ ꠢꠤꠡꠣꠛꠦ ꠀꠟꠉ ꠇꠞꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","“ꠇꠦꠘꠦ ꠀꠟꠉ ꠇꠞꠍꠂꠘ? ꠅꠁꠘ꠆ꠘ ꠎꠣꠔꠤ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠘꠥꠡ ꠛꠦꠡꠤ, ꠅꠔꠣꠞ ꠟꠣꠉꠤ ꠘꠤ? ꠘꠣ, ꠝꠥꠐꠦꠃ ꠘꠣ। ꠔꠥꠝꠞꠣ ꠔ ꠢꠇꠟ ꠎꠣꠔꠤ ꠕꠣꠇꠤ ꠇꠝ ꠀꠍꠟꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","ꠔꠣ-ꠅ ꠔꠣꠁꠘ ꠔꠥꠝꠞꠣꠞꠦ ꠈꠥꠛ ꠝꠣꠄꠀ-ꠝꠢꠛ꠆ꠛꠔ ꠇꠞꠂꠘ, ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣ ꠅꠇꠟꠞ ꠉꠦꠍꠦ ꠎꠦ ꠇꠍꠝ ꠇꠞꠍꠟꠣ, ꠅꠔꠣꠞ ꠟꠣꠉꠤꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠀꠟꠉ ꠇꠞꠍꠂꠘ। ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘ ꠇꠥꠖꠞꠔꠤ ꠀꠔ ꠟꠣꠉꠣꠁꠀ ꠔꠥꠝꠞꠣꠞꠦ ꠛꠣꠞ ꠇꠞꠤꠀ ꠀꠘꠍꠂꠘ, ꠝꠤꠡꠞꠞ ꠛꠣꠖꠡꠣ ꠚꠦꠞꠣꠃꠘꠞ ꠀꠔ ꠕꠣꠇꠤ ꠀꠞ ꠉꠥꠟꠣꠝꠤꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠀꠎꠣꠖ ꠇꠞꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","ꠅꠈꠘ ꠔꠥꠝꠞꠣ ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠃ ꠅꠁꠟꠣ ꠀꠍꠟ ꠝꠣꠛꠥꠖ। ꠔꠣꠁꠘꠃ ꠌꠤꠞꠇꠣꠟꠤꠘ ꠢꠇ-ꠢꠣꠟꠣꠟ। ꠎꠦꠞꠣ ꠀꠡꠤꠇ ꠅꠁꠀ ꠔꠣꠘꠦ ꠝꠢꠛ꠆ꠛꠔ ꠇꠞꠦ ꠀꠞ ꠔꠣꠘ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠝꠣꠘꠦ, ꠔꠣꠁꠘ ꠔꠣꠞꠣꠞ ꠀꠎꠣꠞ ꠀꠎꠣꠞ ꠍꠤꠠꠤ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠘꠤꠎꠞ ꠅꠀꠖꠣ ꠇꠞꠣ ꠎꠛꠣꠘ ꠀꠞ ꠖꠄꠀ ꠛꠅꠀꠁꠟ ꠞꠣꠈꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","ꠅꠁꠟꠦ ꠎꠦꠔꠣꠄ ꠛꠖ ꠡꠣꠅꠡ ꠇꠞꠤꠀ ꠔꠣꠘ ꠛꠣꠄ ꠙꠤꠍ ꠖꠤꠟꠣꠄ, ꠔꠣꠁꠘ ꠁꠔꠣꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠤꠀ ꠎꠟꠖꠤ ꠇꠞꠤ ꠛꠖꠟꠣ ꠖꠦꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","ꠄꠞꠟꠣꠉꠤ ꠀꠁꠎ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ, ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠀꠞ ꠡꠞꠤꠅꠔ ꠖꠤꠞꠣꠝ, ꠁꠔꠣ ꠈꠥꠛ ꠈꠤꠀꠟ ꠇꠞꠤꠀ ꠀꠝꠟ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","“ꠅ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ, ꠔꠥꠝꠞꠣ ꠅꠃ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝꠞ ꠇꠕꠣ ꠇꠣꠘ ꠙꠣꠔꠤꠀ ꠢꠥꠘꠅ, ꠀꠞ ꠁꠔꠣ ꠈꠤꠀꠟ ꠇꠞꠤ ꠀꠝꠟ ꠇꠞꠅ। ꠔꠦꠃ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠚ-ꠖꠣꠖꠣꠁꠘ꠆ꠔꠞ ꠟꠉꠦ, ꠔꠣꠘ ꠖꠄꠀ-ꠝꠣꠄꠀꠞ ꠛꠦꠙꠣꠞꠦ ꠇꠍꠝ ꠈꠣꠁꠀ ꠎꠦ ꠅꠀꠖꠣ-ꠌꠥꠇ꠆ꠔꠤ ꠇꠞꠍꠟꠣ, ꠁꠔꠣ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠛꠅꠀꠁꠟ ꠞꠣꠈꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","ꠔꠣꠁꠘ ꠔꠥꠝꠞꠣꠞꠦ ꠝꠣꠄꠀ-ꠝꠢꠛ꠆ꠛꠔ ꠇꠞꠛꠣ, ꠞꠢꠝ-ꠛꠞꠇꠔ ꠖꠤꠛꠣ ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠘꠡꠞ ꠙꠞꠤꠝꠣꠘ ꠛꠣꠠꠣꠁꠛꠣ। ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦ ꠖꠦꠡ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠞꠣꠞ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤꠞ ꠉꠦꠍꠦ ꠇꠍꠝ ꠈꠣꠁꠍꠟꠣ, ꠅꠃ ꠖꠦꠡꠅ ꠔꠥꠝꠞꠣꠞꠦ ꠞꠢꠝ-ꠛꠞꠇꠔ ꠖꠤꠛꠣ। ꠔꠥꠝꠞꠣꠞꠦ ꠀꠅꠟꠣꠖ ꠛꠣꠠꠣꠁ ꠖꠤꠛꠣ, ꠔꠥꠝꠞꠣꠞ ꠛꠣꠉꠣꠘꠞ ꠚꠟ-ꠝꠥꠟ, ꠈꠦꠔꠞ ꠚꠡꠟ, ꠀꠋꠉꠥꠞꠞ ꠞꠡ, ꠎꠄꠔꠥꠘꠞ ꠔꠦꠟ, ꠉꠞꠥ-ꠛꠣꠍꠥꠞ, ꠝꠦꠠꠣ-ꠍꠣꠉꠟ ꠢꠇꠟꠔꠣꠞꠦ ꠛꠣꠠꠣꠁ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","ꠢꠇꠟ ꠎꠣꠔꠤ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣ ꠛꠦꠡꠤ ꠞꠢꠝ-ꠛꠞꠇꠔ ꠙꠣꠁꠛꠣꠄ, ꠔꠥꠝꠞꠣꠞ ꠛꠦꠐꠣꠁꠘ-ꠛꠦꠐꠤꠘ ꠛꠣ ꠔꠥꠝꠞꠣꠞ ꠙꠡꠥꠞ ꠙꠣꠟꠞ ꠇꠦꠃ ꠀꠐꠈꠥꠞꠣ ꠞꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","ꠀꠟ꠆ꠟꠣ ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠢꠇꠟ ꠟꠣꠈꠣꠘ ꠛꠦꠝꠣꠞ ꠕꠣꠇꠤ ꠛꠣꠌꠣꠁꠛꠣ। ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠔꠥꠝꠞꠣ ꠎꠦꠔꠣ ꠇꠑꠤꠘ ꠛꠦꠝꠣꠞ-ꠀꠎꠣꠞ ꠖꠦꠈꠍ, ꠁꠔꠣ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠤꠔꠣ ꠘꠣꠄ, ꠈꠣꠟꠤ ꠔꠥꠝꠞꠣꠞ ꠖꠥꠡꠝꠘ ꠅꠇꠟꠞꠦ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠎꠔ ꠎꠣꠔꠤꠞ ꠝꠣꠘꠡꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠀꠔꠅ ꠡꠙꠤꠛꠣ, ꠁꠔꠣꠞꠦ ꠔꠥꠝꠞꠣ ꠄꠇ꠆ꠇꠦꠛꠣꠞꠦ ꠡꠦꠡ ꠇꠞꠤꠟꠣꠁꠅ, ꠇꠥꠘꠥ ꠖꠄꠀ ꠇꠞꠤꠅ ꠘꠣ, ꠀꠞ ꠔꠥꠝꠞꠣ ꠁꠔꠣꠞ ꠖꠦꠛꠔꠣꠞꠦ ꠙꠥꠎꠣ ꠇꠞꠤꠅ ꠘꠣ, ꠀꠞꠘꠣꠄ ꠁꠔꠣ ꠔꠥꠝꠞꠣꠞ ꠙꠕꠞ ꠇꠣꠐꠣ ꠅꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","“ꠔꠥꠝꠞꠣ ꠢꠄꠔ ꠝꠘꠦ ꠝꠘꠦ ꠇꠁꠛꠣꠄ, ꠀꠝꠞꠣ ꠇꠤꠟꠣꠈꠣꠘ ꠔꠣꠞꠣꠞꠦ ꠈꠦꠖꠣꠁꠀ ꠖꠤꠝꠥ? ꠁꠔꠣ ꠎꠣꠔꠤꠞ ꠝꠣꠘꠥꠡ ꠔ ꠙꠞꠤꠝꠣꠘꠦ ꠀꠝꠞꠣ ꠕꠣꠇꠤ ꠛꠣꠇ꠆ꠇꠣ ꠛꠦꠡꠤ। ");
INSERT INTO syls_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣ ꠁꠔꠣꠞꠦ ꠒꠞꠣꠁꠅ ꠘꠣ। ꠚꠦꠞꠣꠃꠘ ꠀꠞ ꠀꠡ꠆ꠔꠣ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠃꠙꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠇꠤꠔꠣ ꠇꠞꠍꠂꠘ, ꠁꠔꠣ ꠔꠥꠝꠞꠣ ꠚꠣꠃꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","ꠝꠣꠛꠥꠖꠦ ꠇꠔ ꠛꠠ ꠛꠠ ꠉꠎꠛ-ꠝꠍꠤꠛꠔ ꠓꠣꠟꠤꠀ ꠔꠣꠞꠣꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠍꠂꠘ, ꠁꠔꠣ ꠔ ꠘꠤꠎꠞ ꠌꠃꠈꠦꠅ ꠖꠦꠈꠍ। ꠔꠣꠘ ꠛꠃꠔ ꠇꠥꠖꠞꠔꠤ ꠇꠣꠝ, ꠛꠃꠔ ꠟꠣꠈꠣꠘ ꠘꠤꠡꠣꠘꠣ ꠖꠦꠈꠍ, ꠔꠣꠘ ꠛꠟꠀꠟꠣ ꠝꠎꠛꠥꠔ ꠀꠔ ꠖꠤꠀ ꠔꠥꠝꠞꠣꠞꠦ ꠛꠣꠞ ꠇꠞꠤꠀ ꠀꠘꠍꠂꠘ, ꠁꠔꠣ ꠢꠇꠟꠔꠣ ꠝꠘꠅ ꠞꠣꠈꠤꠅ। ꠀꠞ ꠔꠥꠝꠞꠣ ꠅꠈꠘ ꠎꠦꠔꠣ ꠎꠣꠔꠤ ꠅꠇꠟꠞꠦ ꠖꠦꠈꠤꠀ ꠒꠞꠣꠁꠞꠣꠄ, ꠁꠔꠣꠞ ꠃꠙꠞꠦꠅ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠑꠤꠇ ꠅꠃꠟꠣ ꠊꠐꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","ꠄꠞꠛꠣꠖꠦꠅ ꠔꠥꠝꠞꠣꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠟꠥꠇꠣꠁꠀ ꠎꠦꠉꠥꠁꠘ ꠎꠤꠔꠣ ꠞꠁꠎꠤꠛꠣ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠜꠤꠋꠉꠥꠟꠞ ꠙꠣꠟ ꠙꠣꠑꠣꠁꠀ ꠁꠔꠣ ꠢꠇꠟꠐꠤꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","ꠔꠦ ꠔꠥꠝꠞꠣ ꠁꠔꠣꠞꠦ ꠒꠞꠣꠁꠅ ꠘꠣ, ꠎꠣꠘ ꠔ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣ ꠎꠦꠁꠘ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠛꠡꠔ ꠇꠞꠂꠘ, ꠄꠁꠘ ꠛꠠ ꠜꠄꠅꠋꠇꠞ ꠀꠞ ꠝꠢꠣꠘ। ");
INSERT INTO syls_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞ ꠍꠣꠝꠘꠦ ꠕꠣꠇꠤ ꠀꠡ꠆ꠔꠦ ꠀꠡ꠆ꠔꠦ ꠅꠔꠣ ꠎꠣꠔꠤꠞꠦ ꠈꠦꠖꠣꠁ ꠖꠤꠛꠣ। ꠅꠁꠟꠦ ꠢꠇꠟꠐꠤꠞꠦ ꠔ ꠔꠥꠝꠞꠣ ꠄꠇꠟꠉꠦ ꠈꠦꠖꠣꠁꠔꠣꠄ ꠙꠣꠞꠔꠣꠄ ꠘꠣꠄ, ꠈꠦꠖꠣꠁꠟꠦ ꠎꠋꠟꠤ ꠎꠣꠘꠥꠀꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠌꠣꠁꠞꠅꠛꠣꠄ ꠜꠞꠤꠎꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","ꠔꠣ-ꠅ ꠔꠣꠞꠣ ꠄꠇ꠆ꠇꠦꠞꠦ ꠛꠤꠘꠣꠡ ꠅꠀꠞ ꠀꠉ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠛꠦꠎꠥꠁꠔꠣ ꠅꠡꠣꠘ꠆ꠔꠤꠔ ꠚꠣꠟꠣꠁꠀ ꠔꠥꠝꠞꠣꠞ ꠀꠔꠅ ꠡꠙꠤꠀ ꠛꠤꠘꠣꠡ ꠇꠞꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","ꠔꠣꠞꠣꠞ ꠞꠣꠎꠣ-ꠛꠣꠖꠡꠣ ꠅꠇꠟꠞꠦꠅ ꠔꠥꠝꠞꠣꠞ ꠀꠔꠅ ꠡꠙꠤꠛꠣ, ꠔꠥꠝꠞꠣ ꠖꠥꠘꠤꠀ ꠕꠣꠇꠤ ꠁꠔꠣꠞ ꠘꠣꠝ ꠝꠤꠐꠣꠁꠟꠤꠛꠣꠄ, ꠁꠔꠣꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠣꠞ ꠀꠉ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠇꠦꠃ ꠀꠁꠀ ꠔꠥꠝꠞꠣꠞ ꠍꠣꠝꠘꠦ ꠃꠛꠣꠘꠤꠞ ꠔꠣꠇ꠆ꠇꠔ ꠅꠁꠔ ꠘꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","“ꠔꠥꠝꠞꠣ ꠁꠔꠣꠞ ꠝꠥꠞ꠆ꠔꠤ ꠅꠇꠟꠞꠦ ꠀꠉꠥꠘꠤꠔ ꠚꠣꠟꠣꠁꠀ ꠎꠣꠟꠣꠁꠟꠤꠅ। ꠔꠣꠞꠣꠞ ꠉꠔꠞꠞ ꠡꠥꠘꠣ-ꠞꠥꠙꠣꠞ ꠛꠣꠄ ꠟꠣꠟꠌ ꠇꠞꠤꠅ ꠘꠣ, ꠀꠞꠘꠣꠄ ꠚꠣꠘ꠆ꠖꠅ ꠙꠠꠛꠣꠄ। ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠁꠔꠣꠞꠦ ꠊꠤꠘ꠆ꠘꠣꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","ꠊꠤꠘ꠆ꠘꠣꠞ ꠇꠥꠘꠥ ꠎꠤꠘꠤꠡ ꠔꠥꠝꠞꠣꠞ ꠊꠞꠅ ꠢꠣꠞꠣꠁꠟꠦ ꠔꠥꠝꠞꠣꠅ ꠅꠔꠣꠞ ꠟꠣꠈꠣꠘ ꠛꠘꠤꠎꠤꠛꠣꠄ। ꠛꠞꠋ ꠔꠥꠝꠞꠣꠅ ꠁꠔꠣꠞꠦ ꠈꠥꠛ ꠊꠤꠘ꠆ꠘꠣꠁꠅ ꠀꠞ ꠔꠥꠌ꠆ꠍ ꠇꠞꠤꠅ, ꠁꠔꠣ ꠔ ꠟꠣꠘ꠆ꠘꠔꠤ। ");
INSERT INTO syls_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","“ꠅꠈꠘ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠞꠣꠝ, ꠔꠥꠝꠞꠣ ꠈꠥꠛ ꠈꠤꠀꠟꠤ ꠅꠁꠀ ꠁꠔꠣ ꠀꠝꠟ ꠇꠞꠤꠅ, ꠔꠦꠃ ꠔꠥꠝꠞꠣ ꠛꠣꠌꠤꠀ ꠞꠁꠛꠣꠄ, ꠔꠥꠝꠞꠣꠞ ꠀꠅꠟꠣꠖ ꠛꠣꠠꠤꠛ, ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤꠞ ꠉꠦꠍꠦ ꠝꠣꠛꠥꠖꠦ ꠇꠍꠝ ꠈꠣꠁꠀ ꠎꠦ ꠖꠦꠡ ꠖꠤꠛꠣꠞ ꠅꠀꠖꠣ ꠇꠞꠍꠂꠘ, ꠢꠃ ꠖꠦꠡꠅ ꠢꠣꠝꠣꠁꠀ ꠖꠈꠟ ꠇꠞꠔꠣꠄ ꠙꠣꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","ꠀꠞ ꠔꠥꠝꠞꠣ ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠅꠃ ꠌꠣꠟ꠆ꠟꠤꠡ ꠛꠍꠞꠦ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠝꠣꠎꠖꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠇꠤꠟꠣ ꠟꠁꠀ ꠀꠁꠍꠟꠣ, ꠔꠥꠝꠞꠣꠞ ꠛꠠꠣꠁ-ꠛꠦꠐꠣꠉꠤꠞꠤ ꠜꠣꠋꠉꠤꠛꠣꠞ ꠟꠣꠉꠤ, ꠀꠞ ꠔꠥꠝꠞꠣ ꠔꠣꠘ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠝꠣꠘꠛꠣꠄ ꠇꠤ ꠘꠣ ꠅꠈꠣꠘ ꠙꠞꠤꠇ꠆ꠇꠣ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ, ꠔꠥꠝꠞꠣꠞ ꠖꠤꠟꠞ ꠈꠛꠞ ꠎꠣꠘꠣꠞ ꠟꠣꠉꠤ ꠔꠣꠁꠘ ꠔꠥꠝꠞꠣꠞꠦ ꠘꠔ ꠇꠞꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","ꠔꠥꠝꠞꠣꠞ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤꠞꠦ ꠈꠣꠘꠤ-ꠈꠥꠞꠣꠇꠤ ꠘꠣ ꠖꠤꠀ ꠃꠙꠣꠡ ꠞꠣꠈꠟꠣ, ꠛꠣꠖꠦ ꠎꠦ ꠈꠣꠘꠤ ꠔꠣꠞꠣ ꠌꠤꠘꠔꠣ ꠘꠣ, ꠝꠣꠘ꠆ꠘꠣ ꠘꠣꠝꠞ ꠅꠃ ꠈꠣꠘꠤ ꠈꠣꠅꠀꠁꠀ ꠔꠣꠁꠘ ꠔꠥꠝꠞꠣꠞ ꠛꠠꠣꠁ-ꠛꠦꠐꠣꠉꠤꠞꠤ ꠜꠣꠋꠉꠤꠍꠂꠘ। ꠔꠣꠁꠘ ꠔꠥꠝꠞꠣꠞꠦ ꠢꠤꠇꠣꠁꠔꠣ ꠌꠣꠁꠟꠣ, ꠈꠣꠟꠤ ꠞꠥꠐꠤ ꠈꠣꠁꠟꠦꠃ ꠝꠣꠘꠥꠡ ꠛꠣꠌꠦ ꠘꠣ, ꠛꠞꠋ ꠀꠟ꠆ꠟꠣꠞ ꠙꠞꠔꠦꠇ ꠇꠣꠟꠣꠝꠦꠃ ꠝꠣꠘꠡꠞ ꠎꠣꠘ ꠛꠣꠌꠦ। ");
INSERT INTO syls_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","ꠅꠃ ꠌꠣꠟ꠆ꠟꠤꠡ ꠛꠍꠞꠞ ꠝꠣꠎꠦ ꠔꠥꠝꠞꠣꠞ ꠉꠔꠞꠞ ꠇꠣꠙꠠ-ꠌꠥꠙꠠ ꠘꠡ꠆ꠐ ꠅꠁꠍꠦ ꠘꠣ, ꠖꠤꠘ-ꠞꠣꠁꠔ ꠀꠐꠤꠟꠦꠅ ꠔꠥꠝꠞꠣꠞ ꠙꠣꠅ ꠚꠥꠟꠍꠦ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","ꠅꠈꠘ ꠔꠥꠝꠞꠣꠞ ꠖꠤꠟꠅ ꠉꠣꠕꠤꠀ ꠞꠣꠈꠤꠅ, ꠛꠣꠚꠦ ꠎꠦꠟꠣ ꠘꠤꠎꠞ ꠙꠥꠀꠞꠦ ꠡꠣꠡꠘ ꠇꠞꠦ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞꠦꠅ ꠅꠟꠣ ꠡꠣꠡꠘ ꠇꠞꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","“ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠀꠝꠟ ꠇꠞꠤꠅ, ꠔꠣꠘ ꠙꠕꠦ ꠌꠟꠤꠅ, ꠀꠞ ꠔꠣꠘꠞꠦ ꠒꠞꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦ ꠀꠞꠣꠝꠞ ꠖꠦꠡꠅ ꠘꠤꠞꠣ, ꠁ ꠎꠣꠉꠣꠔ ꠙꠣꠠ-ꠙꠞꠛꠔ, ꠙꠣꠠꠤꠀ ꠈꠣꠟ, ꠙꠣꠘꠤꠞ ꠁꠘ꠆ꠖꠣꠞꠣ ꠀꠍꠦ, ꠀꠞ ꠝꠣꠐꠤꠞ ꠔꠟꠦꠅ ꠙꠣꠘꠤ ꠀꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","ꠢꠤꠘꠅ ꠉꠝ, ꠛꠣꠞ꠆ꠟꠤ, ꠀꠋꠉꠥꠞ, ꠒꠥꠝꠥꠞ ꠉꠣꠍ, ꠀꠘꠥꠀꠞ ꠚꠟ, ꠎꠄꠔꠥꠘꠞ ꠔꠦꠟ ꠀꠞ ꠝꠃ ꠀꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","ꠢꠤ ꠖꠦꠡꠅ ꠛꠃꠔ ꠈꠣꠘꠤ-ꠙꠣꠘꠤ ꠙꠣꠁꠛꠣꠄ, ꠇꠥꠘ꠆ꠔꠣꠞ ꠅꠜꠣꠛ ꠔꠥꠝꠞꠣꠞ ꠅꠁꠔ ꠘꠣꠄ। ꠢꠤꠘꠞ ꠙꠣꠔ꠆ꠔꠞꠞ ꠝꠣꠎꠦ ꠟꠥꠀ ꠀꠍꠦ, ꠢꠘꠞ ꠙꠣꠠ ꠈꠥꠖꠤꠟꠦ ꠔꠥꠝꠞꠣ ꠔꠣꠝꠣ-ꠙꠤꠔꠟ ꠙꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","ꠢꠃ ꠖꠦꠡꠅ ꠙꠦꠐ ꠜꠞꠤꠀ ꠈꠣꠘꠣ-ꠙꠤꠘꠣ ꠈꠣꠁꠀ ꠢꠣꠞꠟꠦ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠖꠦꠅꠀ ꠅꠃ ꠀꠞꠣꠝꠞ ꠖꠦꠡꠞ ꠟꠣꠉꠤ ꠔꠣꠘ ꠡꠥꠇꠞꠤꠀ ꠀꠖꠣꠄ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","“ꠔꠣ-ꠅ ꠔꠥꠝꠞꠣ ꠢꠥꠡꠤꠀꠞ ꠞꠁꠅ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞꠦ ꠇꠥꠘꠥ ꠡꠝꠄ ꠚꠣꠃꠞꠤꠅ ꠘꠣ, ꠀꠞ ꠀꠝꠤ ꠅꠈꠘ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦꠔꠣ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ, ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ, ꠀꠞ ꠡꠞꠤꠅꠔ ꠎꠣꠘꠣꠁꠞꠣꠝ, ꠁꠔꠣ ꠀꠝꠟ ꠇꠞꠔꠦ ꠇꠥꠘꠥ ꠉꠣꠚꠟꠔꠤ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","ꠢꠘꠅ ꠉꠤꠀ ꠙꠦꠐ ꠜꠞꠤ ꠈꠣꠘꠣ-ꠙꠤꠘꠣ ꠈꠣꠁꠀ, ꠡꠥꠘ꠆ꠖꠞ ꠇꠞꠤ ꠊꠞ-ꠛꠣꠠꠤ ꠛꠣꠘꠣꠁꠀ, ");
INSERT INTO syls_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","ꠔꠥꠝꠞꠣꠞ ꠉꠞꠥ-ꠍꠣꠉꠟꠞ ꠙꠣꠟ ꠛꠣꠠꠤꠟꠦ, ꠡꠥꠘꠣ-ꠞꠥꠙꠣ ꠎꠝꠣꠁꠀ, ꠢꠇꠟ ꠝꠘ꠆ꠔꠦ ꠗꠘ-ꠍꠣꠝꠣꠘꠣ ꠛꠣꠠꠤꠀ ꠢꠣꠞꠟꠦ ꠢꠥꠡꠤꠀꠞ ꠞꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","ꠔꠥꠝꠞꠣꠞ ꠖꠤꠟꠞꠦ ꠛꠠꠣꠁ-ꠛꠦꠐꠣꠉꠤꠞꠤ ꠇꠞꠔꠦ ꠖꠤꠅ ꠘꠣ। ꠀꠞ ꠢꠃ ꠀꠟ꠆ꠟꠣ ꠝꠣꠛꠥꠖꠞꠦ ꠚꠣꠃꠞꠤꠅ ꠘꠣ, ꠎꠦꠁꠘ ꠔꠥꠝꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ, ꠢꠃ ꠉꠥꠟꠣꠝꠤ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤꠀ ꠀꠘꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","ꠔꠣꠁꠘ ꠔ ꠔꠥꠝꠞꠣꠞꠦ ꠛꠦꠎꠥꠁꠔꠣ ꠛꠤꠙꠖ-ꠀꠙꠖꠦ ꠜꠞꠣ ꠛꠤꠞꠣꠐ ꠝꠞꠥꠜꠥꠝꠤ ꠕꠣꠇꠤ, ꠇꠑꠤꠘ ꠛꠤꠡꠣꠇ꠆ꠔ ꠢꠣꠚ, ꠛꠤꠡꠣꠇ꠆ꠔ ꠇꠣꠇꠠꠣ-ꠛꠤꠍꠣꠄ ꠜꠞꠣ ꠙꠕꠦꠖꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠙꠣꠞ ꠇꠞꠤ ꠀꠘꠍꠂꠘ। ꠡꠇ꠆ꠔ ꠙꠣꠔ꠆ꠔꠞꠞ ꠜꠤꠔꠞ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠙꠣꠘꠤ ꠛꠣꠞ ꠇꠞꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","ꠔꠣꠁꠘ ꠢꠃ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠝꠣꠎꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠝꠣꠘ꠆ꠘꠣ ꠈꠣꠛꠣꠁꠍꠂꠘ, ꠎꠦꠔꠣꠞ ꠘꠣꠝ ꠔꠥꠝꠞꠣꠞ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟꠦ ꠢꠥꠘꠍꠂꠘꠅ ꠘꠣ। ꠔꠥꠝꠞꠣꠞ ꠜꠤꠔꠞꠞ ꠛꠠꠣꠁ-ꠛꠦꠐꠣꠉꠤꠞꠤ ꠜꠣꠋꠉꠤꠛꠣꠞ ꠟꠣꠉꠤ, ꠀꠞ ꠔꠥꠝꠞꠣꠞꠦ ꠙꠞꠤꠇ꠆ꠇꠣ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦꠃ ꠁꠔꠣ ꠇꠞꠍꠂꠘ, ꠎꠣꠔꠦ ꠢꠦꠡꠦ ꠔꠥꠝꠞꠣꠞ ꠜꠣꠟꠣꠁ ꠅꠄ। ");
INSERT INTO syls_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","ꠔꠥꠝꠞꠣ ꠝꠘꠦ ꠝꠘꠦ ꠇꠁꠅ ꠘꠣ, ꠀꠝꠣꠞ ꠘꠤꠎꠞ ꠛꠟ-ꠡꠇ꠆ꠔꠤꠄ ꠘꠤꠎꠞ ꠇꠣꠝꠣꠁ ꠖꠤꠀ ꠗꠘꠤ ꠅꠁꠍꠤ। ");
INSERT INTO syls_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣꠞ ꠘꠤꠎꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤꠞ ꠉꠦꠍꠦ ꠇꠍꠝ ꠈꠣꠁꠀ ꠎꠦꠔꠣ ꠅꠀꠖꠣ-ꠌꠥꠇ꠆ꠔꠤ ꠇꠞꠍꠟꠣ, ꠅꠔꠣ ꠅꠈꠘ ꠙꠥꠞꠣꠙꠥꠞ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠁ ꠗꠘ-ꠍꠣꠝꠣꠘꠣ ꠖꠤꠍꠂꠘ, ꠄꠞꠟꠣꠉꠤ ꠔꠣꠘꠞꠦ ꠝꠘꠅ ꠞꠣꠈꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","“ꠔꠥꠝꠞꠣ ꠎꠥꠖꠤ ꠇꠥꠘꠥ ꠖꠤꠘ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞꠦ ꠚꠣꠃꠞꠤꠟꠣꠅ, ꠀꠞ ꠖꠦꠛ-ꠖꠦꠛꠤꠞ ꠙꠥꠎꠣ ꠇꠞꠣꠔ ꠟꠣꠉꠅ, ꠅꠔꠣꠞ ꠈꠦꠎꠝꠔ ꠛꠣ ꠜꠎꠘꠣ ꠇꠞꠅ, ꠔꠦ ꠀꠝꠤ ꠅꠈꠘ ꠔꠥꠝꠞꠣꠞꠦ ꠢꠥꠡꠤꠀꠞꠤ ꠖꠤꠀꠞ, ꠔꠥꠝꠞꠣ ꠘꠤꠌ꠆ꠌꠤꠔ ꠛꠤꠘꠣꠡ ꠅꠁꠎꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠘꠣ ꠝꠣꠘꠟꠦ, ꠔꠥꠝꠞꠣꠞ ꠍꠣꠝꠘꠦ ꠢꠃ ꠎꠦꠔꠣ ꠎꠣꠔꠤ ꠅꠇꠟꠞꠦ ꠔꠣꠁꠘ ꠛꠤꠘꠣꠡ ꠇꠞꠍꠂꠘ, ꠔꠥꠝꠞꠣꠞꠦꠅ ꠅꠟꠣ ꠛꠤꠘꠣꠡ ꠇꠞꠛꠣ।” ");
INSERT INTO syls_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","ꠢꠎꠞꠔ ꠝꠥꠍꠣꠄ ꠀꠞꠅ ꠇꠁꠟꠣ, “ꠅ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ ꠢꠥꠘꠅ, ꠔꠥꠝꠞꠣ ꠕꠣꠇꠤ ꠛꠟꠀꠟꠣ ꠀꠞ ꠙꠞꠤꠝꠣꠘꠦꠅ ꠛꠃꠔ ꠛꠦꠡꠤ, ꠛꠠ ꠛꠠ ꠎꠣꠔꠤꠞ ꠖꠦꠡꠞꠦ ꠖꠈꠟ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠅꠈꠘ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋ ꠙꠣꠞ ꠅꠁꠀ ꠎꠣꠁꠛꠣꠄ, ꠔꠣꠞꠣꠞ ꠐꠣꠃꠘ ꠅꠇꠟꠅ ꠛꠠ ꠛꠠ, ꠅꠃ ꠐꠣꠃꠘꠞ ꠛꠣꠃꠘ꠆ꠒꠞꠤꠞ ꠅꠀꠟ ꠀꠍꠝꠣꠘꠅ ꠍꠁꠟꠤꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","ꠔꠣꠞꠣ ꠅꠁꠟꠣ ꠃꠌꠣ-ꠝꠥꠐꠣ ꠙꠄꠟꠥꠀꠘ, ꠄꠞꠣ ꠢꠇꠟꠃ ꠀꠘꠣꠇꠤ ꠛꠋꠡꠞ ꠝꠣꠘꠥꠡ। ꠔꠥꠝꠞꠣ ꠔ ꠀꠉꠦꠃ ꠔꠣꠞꠣꠞ ꠛꠦꠙꠣꠞꠦ ꠢꠥꠘꠍ, ꠀꠘꠣꠇꠤ ꠅꠇꠟꠞ ꠟꠉꠦ ꠟꠣꠉꠣꠞ ꠔꠣꠇ꠆ꠇꠔ ꠇꠣꠞ ꠀꠍꠦ? ");
INSERT INTO syls_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣ ꠅꠈꠣꠘ ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣ ꠔ ꠔꠥꠝꠞꠣꠞ ꠀꠉꠦ ꠀꠉꠦ ꠎꠣꠁꠞꠣ, ꠔꠣꠁꠘ ꠎꠣꠟꠣꠁꠀ ꠍꠣꠞꠈꠣꠞ ꠇꠞꠞꠣ ꠀꠉꠥꠘꠤꠞ ꠟꠣꠈꠣꠘ। ꠔꠣꠁꠘꠃ ꠁꠔꠣꠞꠦ ꠖꠝꠣꠁꠀ ꠔꠥꠝꠞꠣꠞ ꠔꠟꠥꠀ ꠛꠣꠘꠣꠁꠛꠣ। ꠔꠦꠃ ꠝꠣꠛꠥꠖꠦ ꠀꠉꠦ ꠎꠦꠟꠣꠈꠣꠘ ꠇꠁꠍꠟꠣ, ꠔꠥꠝꠞꠣ ꠅꠟꠣꠃ ꠔꠣꠞꠣꠞꠦ ꠈꠦꠖꠣꠁ ꠖꠤꠀ ꠎꠟꠖꠤ ꠇꠞꠤ ꠛꠤꠘꠣꠡ ꠇꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","“ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠎꠦꠛꠟꠣ ꠔꠥꠝꠞꠣꠞ ꠍꠣꠝꠘꠦ ꠕꠣꠇꠤ ꠔꠣꠞꠣꠞꠦ ꠈꠦꠖꠣꠁꠀ ꠖꠤꠛꠣ, ꠢꠃ ꠡꠝꠄ ꠔꠥꠝꠞꠣ ꠝꠘꠦ ꠝꠘꠦ ꠇꠁꠅ ꠘꠣ, ꠀꠝꠞꠣꠞ ꠙꠞꠦꠎꠉꠣꠞꠤꠞ ꠚꠟ ꠢꠤꠡꠣꠛꠦ ꠝꠣꠛꠥꠖꠦ ꠀꠝꠞꠣꠞꠦ ꠅꠃ ꠖꠦꠡ ꠖꠈꠟ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠀꠘꠍꠂꠘ। ꠀꠍꠟꠦ ꠢꠃ ꠎꠣꠔꠤ ꠅꠇꠟꠞ ꠘꠣꠚꠞꠝꠣꠘꠤꠞ ꠟꠣꠉꠤꠃ ꠝꠣꠛꠥꠖꠦ ꠔꠣꠞꠣꠞꠦ ꠔꠥꠝꠞꠣꠞ ꠍꠣꠝꠘꠦ ꠕꠣꠇꠤ ꠈꠦꠖꠣꠁ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","ꠔꠥꠝꠞꠣꠞ ꠙꠞꠦꠎꠉꠣꠞꠤ ꠛꠣ ꠡꠔꠔꠣꠞ ꠟꠣꠉꠤ ꠔ ꠢꠤ ꠖꠦꠡꠞ ꠖꠈꠟꠖꠣꠞꠤ ꠙꠣꠁꠞꠣꠄ ꠘꠣ, ꠛꠞꠋ ꠢꠃ ꠎꠣꠔꠤꠞ ꠘꠣꠚꠞꠝꠣꠘꠤꠞ ꠟꠣꠉꠤ, ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤ ꠁꠛ꠆ꠞꠣꠢꠤꠝ, ꠁꠍꠢꠣꠇ ꠀꠞ ꠁꠀꠇꠥꠛꠞ ꠉꠦꠍꠦ ꠎꠦ ꠅꠀꠖꠣ ꠇꠞꠍꠟꠣ, ꠅꠈꠣꠘ ꠙꠥꠞꠘ ꠇꠞꠣꠞ ꠟꠣꠉꠤ, ꠔꠣꠁꠘꠃ ꠔꠥꠝꠞꠣꠞ ꠍꠣꠝꠘꠦ ꠕꠣꠇꠤ ꠁꠔꠣꠞꠦ ꠈꠦꠖꠣꠁꠀ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","ꠄꠞꠟꠣꠉꠤ ꠔꠥꠝꠞꠣ ꠎꠣꠘꠤꠀ ꠞꠣꠈꠤꠅ, ꠔꠥꠝꠞꠣꠞ ꠙꠞꠦꠎꠉꠣꠞꠤ ꠖꠦꠈꠤꠀ ꠔ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠅꠃ ꠀꠞꠣꠝꠞ ꠖꠦꠡꠞ ꠖꠈꠟꠖꠣꠞꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠤꠞꠣ ꠘꠣ, ꠔꠥꠝꠞꠣ ꠅꠁꠟꠣꠄ ꠉꠣꠠꠔꠦꠠꠣ-ꠄꠇꠉꠥꠁꠀ ꠎꠣꠔꠤ। ");
INSERT INTO syls_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","“ꠀꠞ ꠢꠃ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠝꠣꠎꠦ ꠔꠥꠝꠞꠣ ꠇꠤꠟꠣ ꠘꠤꠎꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠉꠥꠍꠣ ꠔꠥꠟꠣꠁꠍꠟꠣꠄ, ꠁꠈꠣꠘ ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠇꠥꠘꠥꠖꠤꠘ ꠚꠣꠃꠞꠤꠅ ꠘꠣ। ꠝꠤꠡꠞ ꠖꠦꠡ ꠍꠣꠠꠤꠀ ꠀꠅꠀꠞ ꠖꠤꠘ ꠕꠣꠇꠤ ꠅꠈꠣꠘꠅ ꠀꠅꠀ ꠙꠞ꠆ꠎꠘ꠆ꠔ, ꠢꠣꠝꠦꠡꠣ ꠔꠥꠝꠞꠣꠞ ꠝꠘꠞ ꠜꠤꠔꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠛꠤꠞꠥꠗꠤꠔꠣ ꠀꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","ꠔꠥꠞ ꠙꠣꠠꠞ ꠝꠣꠎꠦꠅ ꠔꠥꠝꠞꠣ ꠝꠣꠛꠥꠖꠞ ꠉꠥꠍꠣ ꠔꠥꠟꠣꠁꠍꠟꠣꠄ, ꠄꠞꠟꠣꠉꠤ ꠔꠣꠁꠘ ꠔꠥꠝꠞꠣꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠤꠟꠔꠣ ꠌꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠎꠦ ꠅꠀꠖꠣ-ꠌꠥꠇ꠆ꠔꠤ ꠛꠅꠀꠁꠟ ꠇꠞꠍꠂꠘ, ꠅꠃ ꠌꠥꠇ꠆ꠔꠤ ꠘꠣꠝꠣ ꠟꠦꠈꠣ ꠖꠥꠁꠅ ꠈꠣꠘ ꠙꠣꠔ꠆ꠔꠞ ꠀꠘꠣꠞ ꠟꠣꠉꠤ ꠀꠝꠤ ꠙꠣꠠꠅ ꠃꠑꠤꠍꠟꠣꠝ, ꠌꠣꠟ꠆ꠟꠤꠡ ꠖꠤꠘ ꠌꠣꠟ꠆ꠟꠤꠡ ꠞꠣꠁꠔ ꠇꠥꠘꠥ ꠖꠣꠘꠣ-ꠙꠣꠘꠤ ꠘꠣ ꠈꠣꠁꠀ ꠀꠝꠤ ꠞꠥꠎꠣ ꠀꠍꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘ ꠙꠛꠤꠔ꠆ꠞ ꠀꠔꠞ ꠀꠋꠉꠥꠁꠟꠖꠤ ꠟꠦꠈꠣ ꠢꠃ ꠖꠥꠁꠅ ꠈꠣꠘ ꠙꠣꠔ꠆ꠔꠞ ꠀꠝꠣꠞꠦ ꠖꠤꠟꠣ। ꠔꠥꠝꠞꠣ ꠢꠇꠟ ꠎꠦꠖꠤꠘ ꠔꠥꠞ ꠙꠣꠠꠅ ꠀꠁꠀ ꠖꠟꠣ ꠅꠁꠟꠣꠄ, ꠅꠃ ꠖꠤꠘ ꠝꠣꠛꠥꠖꠦ ꠎꠣꠟꠣꠁꠟ ꠀꠉꠥꠘꠤꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦꠔꠣ ꠛꠣꠔꠣꠁꠍꠟꠣ, ꠅꠃ ꠖꠥꠁꠅ ꠙꠣꠔ꠆ꠔꠞꠞ ꠝꠣꠎꠦ ꠔ ꠅꠔꠣ ꠟꠦꠈꠣ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","“ꠢꠃ ꠌꠣꠟ꠆ꠟꠤꠡ ꠖꠤꠘ ꠀꠞ ꠌꠣꠟ꠆ꠟꠤꠡ ꠞꠣꠁꠔꠞ ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠅꠃ ꠌꠥꠇ꠆ꠔꠤ ꠘꠣꠝꠣ ꠟꠦꠈꠣ ꠙꠣꠔ꠆ꠔꠞ ꠖꠥꠁꠅ ꠈꠣꠘ ꠀꠝꠣꠞ ꠀꠔꠅ ꠖꠤꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","ꠖꠤꠀ ꠇꠁꠟꠣ, ꠎꠣꠅ, ꠔꠥꠝꠤ ꠎꠟꠖꠤ ꠇꠞꠤ ꠟꠣꠝꠣꠔ ꠎꠣꠅ, ꠇꠣꠞꠘ ꠔꠥꠝꠤ ꠎꠦꠔꠣ ꠝꠣꠘꠡꠞꠦ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤꠀ ꠀꠘꠍ, ꠁꠔꠣ ꠇꠥ-ꠙꠕꠦ ꠉꠦꠍꠂꠘꠉꠤ। ꠀꠝꠣꠞ ꠛꠣꠔꠣꠁꠟ ꠙꠕ ꠕꠣꠇꠤ ꠔꠣꠞꠣ ꠅꠔ ꠎꠟꠖꠤ ꠛꠦ-ꠙꠕꠤ ꠅꠁꠉꠦꠍꠦ, ꠔꠣꠞꠣ ꠙꠥꠎꠣ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠡꠥꠘꠣ ꠉꠟꠣꠁꠀ ꠄꠇ ꠝꠥꠞ꠆ꠔꠤ ꠛꠣꠘꠣꠁꠍꠦ। ");
INSERT INTO syls_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞꠦ ꠀꠞꠅ ꠇꠁꠟꠣ, ꠀꠝꠤ ꠔ ꠁꠔꠣ ꠝꠣꠘꠡꠞꠦ ꠖꠦꠈꠟꠣꠝ, ꠁꠔꠣ ꠛꠠ ꠉꠣꠠꠔꠦꠠꠣ-ꠄꠇꠉꠥꠁꠀ ꠎꠣꠔꠤ। ");
INSERT INTO syls_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","ꠅꠈꠘ ꠔꠥꠝꠤ ꠀꠝꠣꠞ ꠉꠦꠍ ꠕꠣꠇꠤ ꠢꠞꠤ ꠎꠣꠅ, ꠇꠥꠘꠥ ꠛꠣꠗꠣ ꠖꠤꠅ ꠘꠣ, ꠀꠝꠤ ꠁꠔꠣꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠤꠟꠤꠝꠥ, ꠖꠥꠘꠤꠀ ꠕꠣꠇꠤ ꠁꠔꠣꠞ ꠘꠣꠝ ꠝꠤꠐꠣꠁꠟꠤꠝꠥ। ꠀꠞ ꠔꠥꠝꠣꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠄꠇ ꠘꠄꠀ ꠎꠣꠔꠤ ꠙꠄꠖꠣ ꠇꠞꠝꠥ, ꠁꠔꠣ ꠀꠞꠅ ꠛꠠ ꠀꠞꠅ ꠛꠟꠀꠟꠣ ꠎꠣꠔꠤ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","“ꠔꠦꠃ ꠀꠝꠤ ꠙꠣꠠ ꠕꠣꠇꠤ ꠟꠣꠝꠤꠀ ꠀꠁꠟꠣꠝ, ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠀꠉꠥꠁꠘ ꠎꠟꠦꠞ, ꠀꠞ ꠀꠝꠣꠞ ꠀꠔꠅ ꠀꠍꠤꠟ ꠌꠥꠇ꠆ꠔꠤ ꠘꠣꠝꠣ ꠟꠦꠈꠣ ꠢꠃ ꠖꠥꠁꠅ ꠈꠣꠘ ꠙꠣꠔ꠆ꠔꠞ। ");
INSERT INTO syls_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","ꠛꠣꠖꠦ ꠀꠝꠤ ꠌꠣꠁꠟꠣꠝ, ꠌꠣꠁꠀ ꠖꠦꠈꠤ ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠖꠞꠛꠣꠞꠅ ꠉꠥꠘꠣ ꠇꠞꠞꠣꠄ। ꠔꠥꠝꠞꠣ ꠙꠥꠎꠣ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠡꠥꠘꠣ ꠉꠟꠣꠁꠀ ꠚꠞ꠆ꠝꠣꠔ ꠓꠣꠟꠤꠀ ꠄꠇ ꠉꠞꠥꠞ ꠛꠣꠍꠥꠞ ꠛꠣꠘꠣꠁꠟꠣꠄ। ꠝꠣꠛꠥꠖꠞ ꠛꠣꠔꠣꠁꠟ ꠙꠕ ꠍꠣꠠꠤꠀ ꠔꠥꠝꠞꠣ ꠅꠔ ꠎꠟꠖꠤ ꠛꠦ-ꠙꠕꠦ ꠉꠦꠟꠣꠄꠉꠤ! ");
INSERT INTO syls_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","ꠄꠞꠟꠣꠉꠤ ꠀꠝꠤ ꠅꠃ ꠖꠥꠁꠅ ꠈꠣꠘ ꠙꠣꠔ꠆ꠔꠞ ꠀꠝꠣꠞ ꠀꠔ ꠕꠣꠇꠤ ꠚꠣꠟꠣꠁ ꠖꠤꠟꠣꠝ, ꠔꠦꠃ ꠁꠔꠣ ꠜꠣꠋꠉꠤꠀ ꠔꠥꠝꠞꠣꠞ ꠌꠈꠥꠞ ꠍꠣꠝꠘꠦ ꠐꠥꠇꠞꠣ ꠐꠥꠇꠞꠣ ꠅꠁꠉꠦꠟ। ");
INSERT INTO syls_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","“ꠝꠣꠛꠥꠖꠦ ꠎꠦꠔꠣꠞꠦ ꠘꠣꠙꠍꠘ꠆ꠖ ꠇꠞꠂꠘ, ꠅꠟꠣꠈꠣꠘ ꠉꠥꠘꠣ ꠇꠞꠤꠀ ꠔꠥꠝꠞꠣ ꠔꠣꠘ ꠉꠥꠍꠣ ꠔꠥꠟꠣꠁꠟꠣꠄ, ꠄꠞꠟꠣꠉꠤ ꠀꠝꠤ ꠀꠉꠞ ꠟꠣꠈꠣꠘ ꠢꠤꠞꠛꠣꠞ ꠌꠣꠟ꠆ꠟꠤꠡ ꠖꠤꠘ ꠌꠣꠟ꠆ꠟꠤꠡ ꠞꠣꠁꠔ ꠇꠥꠘꠥ ꠖꠣꠘꠣ-ꠙꠣꠘꠤ ꠘꠣ ꠈꠣꠁꠀ, ꠔꠣꠘ ꠍꠣꠝꠘꠦ ꠍꠁꠎꠖꠣꠔ ꠙꠠꠤ ꠞꠁꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","ꠝꠣꠛꠥꠖꠞ ꠛꠦꠎꠥꠁꠔꠣ ꠉꠥꠍꠣꠞꠦ ꠀꠝꠤ ꠈꠥꠛ ꠒꠞꠣꠁꠟꠣꠝ, ꠔꠣꠁꠘ ꠉꠥꠍꠣꠄ ꠀꠉꠥꠁꠘ ꠅꠁꠀ ꠔꠥꠝꠞꠣꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠤꠟꠔꠣ ꠌꠣꠁꠟꠣ, ꠅꠁꠟꠦ ꠅꠃꠛꠣꠞꠅ ꠔꠣꠁꠘ ꠀꠝꠣꠞ ꠚꠞꠤꠀꠖ ꠢꠥꠘꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","ꠝꠣꠛꠥꠖꠦ ꠢꠣꠞꠥꠘꠞ ꠃꠙꠞꠦꠅ ꠈꠥꠛ ꠉꠥꠍꠣ ꠅꠁꠀ ꠔꠣꠘꠞꠦ ꠡꠦꠡ ꠇꠞꠤꠟꠔꠣ ꠌꠣꠁꠟꠣ, ꠔꠦꠃ ꠀꠝꠤ ꠢꠣꠞꠥꠘꠞ ꠟꠣꠉꠤꠅ ꠔꠣꠘ ꠖꠞꠛꠣꠞꠅ ꠝꠤꠘꠔꠤ ꠇꠞꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠉꠥꠘꠣꠞ ꠀꠔꠤꠀꠞ ꠝꠣꠘꠤ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠘꠣꠁꠟ ꠢꠃ ꠛꠣꠍꠥꠞꠞ ꠝꠥꠞ꠆ꠔꠤꠞꠦ ꠀꠉꠥꠘꠤꠔ ꠚꠣꠟꠣꠁꠀ ꠎꠣꠟꠣꠁꠀ ꠍꠣꠞꠈꠣꠞ ꠇꠞꠟꠣꠝ। ꠅꠉꠥꠞ ꠎꠣꠟꠣꠁꠟ ꠐꠥꠇꠞꠣꠞꠦ ꠙꠤꠡꠤꠀ ꠍꠣꠟꠤ ꠛꠣꠘꠣꠁꠀ ꠙꠣꠠꠤꠀ ꠉꠣꠋꠉꠞ ꠙꠣꠘꠤꠞ ꠚꠥꠔꠞ ꠝꠣꠎꠦ ꠚꠣꠟꠣꠁꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","“ꠔꠥꠝꠞꠣ ꠔ ꠔꠣꠛꠦꠞꠣꠔ, ꠝꠣꠍꠣꠔ ꠀꠞ ꠇꠤꠛꠞꠥꠔ-ꠢꠥꠔꠣꠛꠣ ꠘꠣꠝꠞ ꠎꠣꠉꠣꠔ ꠝꠣꠛꠥꠖꠞ ꠉꠥꠍꠣ ꠔꠥꠟꠣꠁꠍꠟꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","ꠄꠞꠛꠣꠖꠦ ꠇꠣꠖꠦꠡ-ꠛꠞꠘꠦꠀ ꠕꠣꠇꠤ ꠞꠅꠀꠘꠣ ꠅꠀꠞ ꠇꠣꠟꠅ ꠝꠣꠛꠥꠖꠦ ꠎꠦꠛꠟꠣ ꠇꠁꠟꠣ, ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠀꠞꠣꠝꠞ ꠎꠦ ꠖꠦꠡ ꠖꠣꠘ ꠇꠞꠍꠤ, ꠔꠥꠝꠞꠣ ꠉꠤꠀ ꠅꠈꠣꠘ ꠖꠈꠟ ꠇꠞꠅ, ꠢꠃ ꠡꠝꠄꠅ ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠢꠥꠇꠥꠝꠞ ꠛꠤꠞꠥꠗꠤꠔꠣ ꠇꠞꠟꠣꠄ, ꠔꠣꠘꠞꠦ ꠝꠣꠘꠟꠣꠄ ꠘꠣ, ꠔꠣꠘ ꠇꠕꠣꠞꠦꠅ ꠄꠇꠤꠘ ꠇꠞꠟꠣꠄ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","ꠀꠍꠟꠦ ꠀꠝꠤ ꠎꠦꠖꠤꠘ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠌꠤꠘꠤ, ꠢꠃ ꠖꠤꠘ ꠕꠣꠇꠤꠃ ꠖꠦꠈꠤꠀꠞ, ꠔꠥꠝꠞꠣ ꠢꠣꠝꠦꠡꠣ ꠝꠣꠛꠥꠖꠞ ꠢꠥꠇꠥꠝꠞ ꠃꠟꠐꠣ ꠌꠟꠞꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","“ꠎꠣꠁ ꠅꠃꠇ, ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠣꠞ ꠇꠕꠣ ꠇꠅꠀꠄ ꠀꠝꠤ ꠌꠣꠟ꠆ꠟꠤꠡ ꠖꠤꠘ ꠌꠣꠟ꠆ꠟꠤꠡ ꠞꠣꠁꠔ, ꠔꠣꠘ ꠍꠣꠝꠘꠦ ꠍꠁꠎꠖꠣꠔ ꠙꠠꠤ ꠞꠁꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","ꠀꠝꠤ ꠔꠣꠘ ꠖꠞꠛꠣꠞꠅ ꠝꠤꠘꠔ ꠇꠞꠤ ꠇꠁꠟꠣꠝ, ꠅ ꠝꠣꠛꠥꠖ ꠝꠃꠟꠣ, ꠔꠥꠝꠤ ꠄꠞꠣꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠤꠅ ꠘꠣ, ꠄꠞꠣ ꠔ ꠔꠥꠝꠣꠞꠃ ꠛꠘ꠆ꠖꠣ, ꠔꠥꠝꠣꠞꠃ ꠈꠣꠍ ꠡꠝ꠆ꠙꠖ। ꠔꠥꠝꠣꠞ ꠇꠥꠖꠞꠔꠤ ꠇꠣꠝ ꠖꠤꠀ, ꠔꠥꠝꠣꠞ ꠘꠤꠎꠞ ꠛꠟꠀꠟꠣ ꠀꠔꠖꠤ ꠎꠦꠔꠣꠞꠦ ꠝꠤꠡꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤ ꠀꠘꠍ, ꠁꠔꠣꠞꠦ ꠝꠣꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","ꠁꠔꠣꠞ ꠉꠣꠠꠔꠦꠠꠣꠝꠤ, ꠘꠣꠚꠞꠝꠣꠘꠤ ꠀꠞ ꠉꠥꠘꠣꠞ ꠛꠣꠄ ꠘꠣ ꠌꠣꠁꠀ, ꠔꠥꠝꠤ ꠈꠣꠟꠤ ꠔꠥꠝꠣꠞ ꠉꠥꠟꠣꠝ ꠁꠛ꠆ꠞꠣꠢꠤꠝ, ꠁꠍꠢꠣꠇ ꠀꠞ ꠁꠀꠇꠥꠛꠞ ꠇꠕꠣ ꠝꠘꠅ ꠇꠞꠅ। ");
INSERT INTO syls_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","ꠅꠈꠘ ꠔꠥꠝꠤ ꠎꠥꠖꠤ ꠁꠔꠣꠞꠦ ꠝꠣꠞꠤꠟꠣꠅ, ꠔꠦ ꠔꠥꠝꠤ ꠎꠦ ꠖꠦꠡ ꠕꠣꠇꠤ ꠀꠝꠞꠣꠞꠦ ꠛꠣꠞ ꠇꠞꠤꠀ ꠀꠘꠍ, ꠢꠃ ꠖꠦꠡꠞ ꠝꠣꠘꠡꠦ ꠇꠁꠛ, ꠝꠣꠛꠥꠖꠦ ꠔꠣꠘ ꠅꠀꠖꠣ ꠇꠞꠣ ꠖꠦꠡꠅ ꠁꠔꠣꠞꠦ ꠘꠤꠔꠣ ꠙꠣꠞꠍꠂꠘ ꠘꠣ, ꠛꠣ ꠔꠣꠞꠣꠞꠦ ꠁꠋꠡꠣ ꠇꠞꠤꠀ ꠎꠣꠘꠦ ꠝꠣꠞꠣꠞ ꠟꠣꠉꠤ ꠅꠃ ꠝꠞꠥꠜꠥꠝꠤꠔ ꠘꠤꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","ꠀꠍꠟꠦ ꠄꠞꠣ ꠔ ꠔꠥꠝꠣꠞꠃ ꠛꠘ꠆ꠖꠣ, ꠔꠥꠝꠣꠞ ꠘꠤꠎꠞ ꠡꠝ꠆ꠙꠖ। ꠔꠥꠝꠣꠞ ꠀꠙꠘ ꠇꠥꠖꠞꠔꠤ ꠀꠔ ꠟꠣꠉꠣꠁꠀ, ꠔꠥꠝꠣꠞ ꠛꠟ-ꠔꠣꠇ꠆ꠇꠔ ꠈꠣꠐꠣꠁꠀ ꠄꠞꠣꠞꠦ ꠝꠤꠡꠞ ꠕꠣꠇꠤ ꠛꠣꠞ ꠇꠞꠤꠀ ꠀꠘꠍ।” ");
INSERT INTO syls_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","ꠢꠎꠞꠔ ꠝꠥꠍꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠞꠣ, “ꠢꠃ ꠡꠝꠄ ꠝꠣꠛꠥꠖꠦ ꠇꠁꠟꠣ, ꠔꠥꠝꠤ ꠙꠣꠔ꠆ꠔꠞ ꠇꠣꠐꠤꠀ ꠀꠉꠞ ꠟꠣꠈꠣꠘ ꠖꠥꠈꠣꠘ ꠐꠥꠇꠞꠣ ꠛꠣꠘꠣꠅ, ꠀꠞ ꠅꠈꠘꠣꠁꠘ ꠟꠁꠀ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠃꠑꠤꠀ ꠀꠝꠣꠞ ꠗꠣꠞꠅ ꠀꠅ। ꠄꠞꠟꠉꠦ ꠟꠣꠇꠠꠤꠖꠤ ꠄꠇꠐꠣ ꠡꠘ꠆ꠖꠥꠇꠅ ꠛꠣꠘꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","ꠔꠥꠝꠤ ꠀꠉꠦ ꠎꠦ ꠖꠥꠁ ꠐꠥꠇꠞꠣ ꠙꠣꠔ꠆ꠔꠞ ꠜꠣꠋꠉꠤꠟꠤꠍ, ꠢꠃ ꠙꠣꠔ꠆ꠔꠞꠞ ꠃꠙꠞꠦ ꠎꠦꠔꠣ ꠟꠦꠈꠣ ꠀꠍꠤꠟ, ꠅꠔꠣ ꠀꠝꠤ ꠅꠃ ꠖꠥꠁꠅ ꠙꠣꠔ꠆ꠔꠞ ꠐꠥꠇꠞꠣꠞ ꠃꠙꠞꠦ ꠢꠤꠞꠛꠣꠞ ꠟꠦꠈꠤꠀ ꠖꠤꠝꠥ, ꠛꠣꠖꠦ ꠔꠥꠝꠤ ꠅꠈꠘꠣꠁꠘ ꠘꠤꠀ ꠢꠃ ꠡꠘ꠆ꠖꠥꠇꠞ ꠜꠤꠔꠞꠦ ꠕꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","“ꠢꠥꠇꠥꠝ ꠙꠣꠁꠀ ꠀꠝꠤ ꠛꠣꠛꠟꠣ ꠟꠣꠇꠠꠤꠖꠤ ꠄꠇ ꠡꠘ꠆ꠖꠥꠇ ꠛꠣꠘꠣꠁꠟꠣꠝ, ꠀꠞ ꠖꠥꠉꠥ ꠙꠣꠔ꠆ꠔꠞ ꠇꠣꠐꠤꠀ ꠀꠉꠞ ꠟꠣꠈꠣꠘ ꠖꠥꠁ ꠐꠥꠇꠞꠣ ꠇꠞꠟꠣꠝ, ꠛꠣꠖꠦ ꠅꠃ ꠖꠥꠁꠅ ꠐꠥꠇꠞꠣ ꠀꠔꠅ ꠟꠁꠀ ꠀꠝꠤ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠃꠑꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","ꠃꠑꠤꠀ ꠢꠣꠞꠟꠦ ꠝꠣꠛꠥꠖꠦ ꠢꠃ ꠙꠄꠟꠣ ꠖꠥꠁꠅ ꠙꠣꠔ꠆ꠔꠞ ꠐꠥꠇꠞꠣꠞ ꠃꠙꠞꠦ ꠎꠦꠔꠣ ꠟꠦꠈꠤꠍꠟꠣ, ꠅꠔꠣ ꠢꠤꠞꠛꠣꠞ ꠅꠃ ꠖꠥꠁꠅ ꠐꠥꠇꠞꠣꠞ ꠃꠙꠞꠦ ꠟꠦꠈꠤꠀ ꠀꠝꠣꠞꠦ ꠖꠤꠟꠣ, ꠅꠃ ꠟꠦꠈꠣ ꠀꠄꠀꠔ ꠅꠁꠟ, ꠡꠞꠤꠅꠔꠞ ꠈꠣꠍ ꠖꠡ ꠢꠥꠇꠥꠝ। ꠀꠉꠦ ꠎꠦꠖꠤꠘ ꠔꠥꠝꠞꠣ ꠢꠇꠟ ꠔꠥꠞ ꠙꠣꠠꠅ ꠀꠁꠍꠟꠣꠄ, ꠢꠃ ꠖꠤꠘ ꠝꠣꠛꠥꠖꠦ ꠎꠣꠟꠣꠁꠟ ꠀꠉꠥꠘꠤꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠅꠃ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠛꠣꠔꠣꠁꠍꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","ꠛꠣꠖꠦ ꠀꠝꠤ ꠙꠣꠠ ꠕꠣꠇꠤ ꠟꠣꠝꠣꠔ ꠟꠣꠝꠤꠀ ꠀꠁꠀ ꠀꠝꠣꠞ ꠛꠣꠘꠣꠁꠟ ꠢꠃ ꠡꠘ꠆ꠖꠥꠇꠞ ꠜꠤꠔꠞꠦ ꠖꠥꠁꠅ ꠈꠣꠘ ꠙꠣꠔ꠆ꠔꠞ ꠕꠁꠟꠣꠝ, ꠎꠦꠟꠣ ꠝꠣꠛꠥꠖꠦ ꠢꠥꠇꠥꠝ ꠖꠤꠍꠟꠣ। ꠁꠔꠣ ꠅꠈꠘꠅ ꠢꠘꠅ ꠀꠍꠦ।” ");
INSERT INTO syls_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠦ ꠛꠤꠞꠥꠔ-ꠛꠘꠤ-ꠁꠀꠇꠣꠘ ꠕꠣꠇꠤ ꠞꠅꠀꠘꠣ ꠅꠁꠀ ꠝꠥꠍꠦꠞꠣꠔ ꠉꠦꠟꠣꠉꠤ। ꠅꠃ ꠎꠣꠉꠣꠔ ꠢꠣꠞꠥꠘ ꠘꠛꠤꠞ ꠃꠚꠣꠔ ꠅꠀꠄ, ꠔꠣꠘꠞꠦ ꠅꠘꠅ ꠖꠣꠚꠘ ꠇꠞꠣ ꠅꠁꠟ। ꠛꠣꠖꠦ ꠔꠣꠘ ꠛꠖꠟꠣ ꠔꠣꠘ ꠙꠥꠀ ꠀꠟꠤ-ꠀꠎꠞ ꠙꠞꠗꠣꠘ ꠁꠝꠣꠝ ꠅꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","ꠛꠣꠖꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠇꠣꠚꠦꠟꠣ ꠉꠥꠖꠉꠥꠖꠣꠔ ꠉꠦꠟꠣꠉꠤ, ꠢꠘ ꠕꠣꠇꠤ ꠎꠔꠛꠣꠔꠣꠔ ꠉꠦꠟꠣ, ꠁ ꠎꠣꠉꠣꠔ ꠙꠣꠘꠤꠞ ꠚꠥꠔ ꠀꠟꠣ ꠛꠃꠔ ꠈꠣꠟ-ꠘꠣꠟꠣ ꠀꠍꠤꠟ। ");
INSERT INTO syls_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","ꠅꠃ ꠡꠝꠄ ꠕꠣꠇꠤ ꠝꠣꠛꠥꠖꠦ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞꠦ ꠙꠍꠘ꠆ꠖ ꠇꠞꠟꠣ ꠡꠣꠢꠣꠖꠔ ꠡꠘ꠆ꠖꠥꠇ ꠛꠁꠀ ꠘꠤꠛꠣꠞ ꠟꠣꠉꠤ, ꠝꠣꠛꠥꠖꠞ ꠄꠛꠣꠖꠔ-ꠛꠘ꠆ꠖꠦꠉꠤ ꠇꠞꠣꠞ ꠘꠤꠅꠔꠦ ꠔꠣꠘ ꠍꠣꠝꠘꠦ ꠀꠎꠤꠞꠣ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ, ꠀꠞ ꠔꠣꠘ ꠘꠣꠝꠦ ꠝꠣꠘꠡꠞꠦ ꠖꠥꠀ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ। ꠅꠃ ꠁꠝꠣꠝꠔꠤ ꠇꠣꠝ ꠔꠣꠞꠣ ꠅꠈꠘꠅ ꠇꠞꠞꠣ। ");
INSERT INTO syls_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","ꠅꠔꠣꠞ ꠟꠣꠉꠤ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠡꠦ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠖꠥꠍꠞꠣ ꠈꠣꠘ꠆ꠖꠣꠘ ꠅꠇꠟꠞ ꠟꠣꠈꠣꠘ ꠎꠝꠤ-ꠎꠝꠣꠞ ꠇꠥꠘꠥ ꠛꠣꠐ ꠛꠣ ꠇꠥꠘꠥ ꠝꠤꠞꠣꠡꠖꠣꠞꠤ ꠙꠣꠁꠟꠣ ꠘꠣ। ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠎꠛꠣꠘ ꠝꠣꠚꠤꠇ ꠡ꠆ꠛꠄꠅꠋ ꠝꠣꠛꠥꠖꠃ ꠅꠁꠟꠣ ꠔꠣꠞꠣꠞ ꠝꠤꠞꠣꠡ। ");
INSERT INTO syls_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","ꠢꠎꠞꠔ ꠝꠥꠍꠣꠄ ꠔꠣꠞꠣꠞꠦ ꠇꠁꠟꠣ, “ꠀꠉꠞ ꠛꠣꠞꠞ ꠟꠣꠈꠣꠘ ꠁꠛꠣꠞꠅ ꠀꠝꠤ ꠌꠣꠟ꠆ꠟꠤꠡ ꠖꠤꠘ ꠌꠣꠟ꠆ꠟꠤꠡ ꠞꠣꠁꠔ ꠔꠥꠞ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠀꠍꠟꠣꠝ, ꠁꠛꠣꠞꠅ ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞ ꠚꠞꠤꠀꠖ ꠇꠛꠥꠟ ꠇꠞꠟꠣ, ꠔꠣꠁꠘ ꠔꠥꠝꠞꠣꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠣ ꠛꠣꠖ ꠖꠤꠟꠣꠁꠟꠣ। ");
INSERT INTO syls_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","ꠛꠣꠖꠦ ꠝꠣꠛꠥꠖꠦ ꠀꠝꠣꠞꠦ ꠇꠁꠟꠣ, ‘ꠔꠥꠝꠤ ꠃꠑꠅ, ꠃꠑꠤꠀ ꠀꠉꠦꠖꠤ ꠀꠉꠥꠀꠘꠤꠞ ꠟꠣꠉꠤ ꠅꠔꠣ ꠝꠣꠘꠡꠞꠦ ꠎꠥꠁꠔ ꠇꠞꠤꠀ ꠔꠣꠞꠣꠞ ꠀꠉ ꠅꠁꠀ ꠞꠅꠀꠘꠣ ꠖꠦꠅ, ꠀꠝꠤ ꠔꠣꠞꠣꠞ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟꠞ ꠉꠦꠍꠦ ꠎꠦ ꠖꠦꠡ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠇꠍꠝ ꠈꠣꠁꠀ ꠅꠀꠖꠣ ꠇꠞꠍꠤ, ꠔꠣꠞꠣ ꠢꠃ ꠖꠦꠡꠅ ꠉꠤꠀ ꠁꠔꠣ ꠖꠈꠟ ꠇꠞꠃꠇ।’ ");
INSERT INTO syls_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","“ꠅ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ, ꠢꠥꠘꠅ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞ ꠉꠦꠍꠦ ꠇꠤꠔꠣ ꠌꠣꠁꠘ। ꠔꠣꠁꠘ ꠌꠣꠁꠞꠣ, ꠔꠥꠝꠞꠣ ꠈꠣꠟꠤ ꠔꠣꠘ ꠒꠞ-ꠈꠚ ꠜꠤꠔꠞꠦ ꠞꠣꠈꠅ, ꠔꠣꠘ ꠙꠕꠦ ꠌꠟꠅ, ꠔꠣꠘꠞꠦ ꠝꠢꠛ꠆ꠛꠔ ꠇꠞꠅ, ꠔꠥꠝꠞꠣꠞ ꠀꠡ꠆ꠔꠣ ꠖꠤꠟ-ꠝꠘ ꠖꠤꠀ ꠔꠣꠘ ꠄꠛꠣꠖꠔ-ꠛꠘ꠆ꠖꠦꠉꠤ ꠇꠞꠅ। ");
INSERT INTO syls_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠜꠣꠟꠣꠁꠞ ꠟꠣꠉꠤ ꠀꠁꠎ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠖꠦꠅꠀ ꠎꠦ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠀꠞ ꠡꠞꠤꠅꠔ ꠎꠣꠘꠣꠁꠞꠣꠝ, ꠁꠔꠣ ꠙꠥꠞꠣꠙꠥꠞ ꠀꠝꠟ ꠇꠞꠅ। ");
INSERT INTO syls_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","“ꠎꠣꠘ ꠔ, ꠀꠍꠝꠣꠘ ꠀꠞ ꠀꠍꠝꠣꠘꠤ ꠢꠇ꠆ꠇꠟꠔꠣ, ꠎꠝꠤꠘ ꠀꠞ ꠎꠝꠤꠘꠞ ꠔꠣꠝꠣꠝ ꠍꠣꠝꠣꠘꠣ ꠔ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ। ");
INSERT INTO syls_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","ꠔꠣ-ꠅ ꠔꠥꠝꠞꠣꠞ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤꠞ ꠛꠣꠄ ꠔꠣꠘ ꠐꠣꠘ ꠕꠣꠇꠣꠄ, ꠔꠣꠁꠘ ꠄꠞꠣꠞꠦ ꠝꠢꠛ꠆ꠛꠔ ꠇꠞꠔꠣ। ꠔꠣꠞꠣꠞ ꠛꠣꠖꠦ ꠔꠣꠞꠣꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠞꠦ ꠝꠣꠘꠤ, ꠅꠈꠘꠇꠥꠞ ꠎꠝꠣꠘꠣꠞ ꠖꠥꠘꠤꠀꠞ ꠢꠇꠟ ꠎꠣꠔꠤꠞ ꠝꠣꠎ ꠕꠣꠇꠤ ꠈꠣꠟꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠙꠍꠘ꠆ꠖ ꠇꠞꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","ꠄꠞꠟꠣꠉꠤ ꠔꠥꠝꠞꠣꠞ ꠎꠣꠞꠎꠤꠞ ꠖꠤꠟꠞ ꠝꠍꠟꠝꠣꠘꠤ ꠇꠞꠣꠅ, ꠉꠣꠠꠔꠦꠠꠣ ꠘꠣꠚꠞꠝꠣꠘ ꠛꠘꠤꠀ ꠞꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣ ꠔ ꠢꠇꠟ ꠖꠦꠛ-ꠖꠦꠛꠤꠞ ꠃꠙꠞꠦ, ꠝꠥꠘꠤꠛ ꠅꠇꠟꠞ ꠝꠥꠘꠤꠛ, ꠔꠣꠁꠘꠃ ꠝꠢꠣꠘ, ꠛꠟꠛꠣꠘ ꠀꠞ ꠒꠞ-ꠈꠚ ꠙꠄꠖꠣ ꠇꠞꠞꠣ ꠀꠟ꠆ꠟꠣ। ꠔꠣꠁꠘ ꠇꠥꠘꠥ ꠙꠇ꠆ꠇꠙꠣꠔꠤ ꠇꠞꠂꠘ ꠘꠣ, ꠊꠥꠡ ꠈꠣꠁꠘ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","ꠄꠔꠤꠝ ꠅꠇꠟ ꠀꠞ ꠠꠣꠠꠤ ꠛꠦꠐꠤꠘ꠆ꠔꠞ ꠛꠣꠄ ꠢꠇ ꠁꠘꠍꠣꠚ ꠇꠞꠂꠘ, ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠟꠉꠦ ꠛꠡꠔ ꠇꠞꠞꠣ ꠜꠤꠘ-ꠖꠦꠡꠤ ꠅꠇꠟꠞꠦ ꠈꠣꠅꠀ-ꠚꠤꠘ꠆ꠖꠣꠞ ꠢꠇꠟꠔꠣ ꠖꠤꠀ ꠔꠣꠘ ꠝꠢꠛ꠆ꠛꠔꠞ ꠙꠞꠝꠣꠘ ꠖꠦꠈꠣꠁꠘ। ");
INSERT INTO syls_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","ꠀꠉꠦ ꠔ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠔꠥꠝꠞꠣꠅ ꠅꠟꠣ ꠜꠤꠘ-ꠖꠦꠡꠤ ꠀꠍꠟꠣꠄ, ꠄꠞꠟꠣꠉꠤ ꠜꠤꠘ-ꠖꠦꠡꠤ ꠝꠣꠘꠡꠞꠦ ꠔꠥꠝꠞꠣ ꠝꠣꠄꠀ-ꠝꠢꠛ꠆ꠛꠔ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞꠦ ꠒꠞꠣꠁꠀ ꠌꠟꠤꠅ, ꠔꠣꠘ ꠄꠛꠣꠖꠔ-ꠛꠘ꠆ꠖꠦꠉꠤ ꠇꠞꠤꠅ, ꠔꠣꠘ ꠀꠡꠤꠇ ꠛꠘꠤꠀ ꠞꠁꠅ, ꠀꠞ ꠈꠣꠟꠤ ꠔꠣꠘ ꠘꠣꠝꠦ ꠇꠍꠝ ꠈꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","ꠔꠣꠁꠘꠃ ꠔꠥꠝꠞꠣꠞ ꠔꠣꠞꠤꠚꠞ ꠈꠥꠐꠤ, ꠔꠣꠁꠘꠃ ꠔꠥꠝꠞꠣꠞ ꠀꠟ꠆ꠟꠣ। ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠌꠃꠈꠦ ꠎꠔ ꠀꠌꠣꠘꠇ ꠔꠣꠁꠎ꠆ꠎꠥꠛꠤ ꠀꠞ ꠛꠦꠎꠥꠁꠔꠣ ꠇꠥꠖꠞꠔꠤ ꠇꠣꠝ ꠖꠦꠈꠍ, ꠁꠔꠣ ꠢꠇ꠆ꠇꠟꠔꠣ ꠔ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠉꠤ ꠔꠣꠁꠘꠃ ꠇꠞꠍꠂꠘ। ");
INSERT INTO syls_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","ꠔꠥꠝꠞꠣꠞ ꠎꠦꠔꠣ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤ ꠝꠤꠡꠞ ꠖꠦꠡꠅ ꠉꠦꠍꠟꠣ, ꠄꠞꠣ ꠀꠍꠟꠣ ꠝꠥꠐ ꠡꠔ꠆ꠔꠁꠞ ꠎꠘ, ꠀꠞ ꠅꠈꠘ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞꠦ ꠀꠍꠝꠣꠘꠞ ꠔꠦꠞꠣꠞ ꠟꠣꠈꠣꠘ ꠇꠞꠍꠂꠘ, ꠎꠦꠔꠣ ꠉꠘꠤꠀ ꠚꠥꠠꠣꠁꠟ ꠎꠣꠄ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","“ꠄꠞꠟꠣꠉꠤ, ꠅ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ, ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞꠦ ꠝꠢꠛ꠆ꠛꠔ ꠇꠞꠤꠅ, ꠀꠞ ꠔꠣꠘ ꠝꠞ꠆ꠎꠤ ꠎꠥꠉꠣꠁꠀ ꠌꠟꠤꠅ, ꠔꠣꠘ ꠖꠦꠅꠀ ꠡꠞꠤꠅꠔ, ꠢꠇꠟ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ, ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠢꠞ-ꠢꠣꠝꠦꠡꠣ ꠝꠣꠘꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","ꠔꠥꠝꠞꠣ ꠅꠈꠘ ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠁꠔꠣ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ꠆ꠔꠞꠦ ꠘꠣ ꠇꠁꠀ ꠈꠣꠟꠤ ꠔꠥꠝꠞꠣꠞ ꠉꠦꠍꠦ ꠇꠁꠀꠞ, ꠔꠣꠞꠣ ꠔ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠢꠦꠖꠣꠄꠅꠔ ꠖꠦꠈꠍꠦ ꠘꠣ, ꠁꠔꠣ ꠌꠤꠘꠦꠅ ꠘꠣ। ꠔꠥꠝꠞꠣꠞ ꠉꠦꠍꠦ ꠔꠣꠘ ꠀꠙꠘ ꠝꠢꠤꠝꠣ, ꠔꠣꠘ ꠇꠥꠖꠞꠔꠤ ꠀꠔꠞ ꠛꠣꠢꠣꠖꠥꠞꠤ, ");
INSERT INTO syls_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","ꠀꠞ ꠝꠤꠡꠞꠞ ꠛꠣꠖꠡꠣ ꠚꠦꠞꠣꠃꠘꠞ ꠃꠙꠞꠦ, ꠔꠣꠞ ꠀꠡ꠆ꠔꠣ ꠖꠦꠡꠞ ꠃꠙꠞꠦ ꠔꠣꠁꠘ ꠎꠔ ꠘꠝꠥꠘꠣꠞ ꠇꠥꠖꠞꠔꠤ ꠟꠤꠟꠣ-ꠈꠦꠟꠣ ꠖꠦꠈꠣꠁꠍꠂꠘ ꠁꠔꠣ ꠔ ꠔꠣꠞꠣ ꠖꠦꠈꠍꠦ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","ꠔꠣꠞꠣ ꠝꠤꠡꠞꠞ ꠍꠤꠙꠣꠁ ꠖꠟ, ꠁꠔꠣꠞ ꠊꠥꠠꠣ, ꠊꠥꠠꠣꠞ ꠉꠣꠠꠤꠘ ꠀꠞ ꠁꠔꠣꠞꠦ ꠔꠣꠁꠘ ꠇꠤꠟꠣ ꠘꠤꠟ ꠖꠞꠤꠀꠔ ꠛꠥꠠꠣꠁꠀ ꠝꠣꠞꠤꠀ ꠄꠇ꠆ꠇꠦꠞꠦ ꠛꠤꠘꠣꠡ ꠇꠞꠍꠂꠘ, ꠁꠔꠣꠅ ꠔ ꠖꠦꠈꠍꠦ ꠘꠣ, ");
INSERT INTO syls_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","ꠅꠃ ꠎꠣꠉꠣꠔ ꠀꠁꠀ ꠔꠥꠝꠞꠣ ꠙꠃꠍꠤꠛꠣꠞ ꠀꠉꠦ ꠝꠞꠥꠜꠥꠝꠤꠞ ꠝꠣꠎꠦ ꠔꠣꠁꠘ ꠔꠥꠝꠞꠣꠞ ꠃꠙꠞꠦ ꠎꠔꠔꠣ ꠊꠐꠣꠁꠍꠂꠘ, ꠔꠥꠝꠞꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ꠆ꠔꠦ ꠁꠔꠣꠅ ꠖꠦꠈꠍꠦ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","ꠔꠣꠁꠘ ꠞꠥꠛꠦꠘ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠁꠟꠤꠀꠛꠞ ꠙꠥꠀ ꠖꠣꠕꠘ ꠀꠞ ꠀꠛꠤꠞꠣꠝꠞꠦ ꠎꠦ ꠡꠣꠎꠣ ꠖꠤꠍꠂꠘ ꠝꠣꠘꠤ, ꠖꠥꠘꠤꠀꠞ ꠝꠣꠐꠤ ꠚꠣꠐꠤꠀ ꠀ ꠇꠞꠤꠀ ꠀꠡ꠆ꠔꠣ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟꠞ ꠝꠣꠎꠈꠣꠘ ꠕꠣꠇꠤ ꠔꠣꠞꠣꠞꠦ ꠉꠤꠟꠤꠟꠤꠟ, ꠔꠣꠞꠣꠞ ꠛꠃ-ꠛꠣꠁꠌ꠆ꠌꠣꠁꠘ ꠡꠥꠖ꠆ꠖꠣ ꠀꠡ꠆ꠔꠣ ꠙꠞꠤꠛꠣꠞ, ꠔꠣꠞꠣꠞ ꠊꠞ-ꠖꠥꠀꠞ, ꠀꠞ ꠢꠦꠝꠣꠘ-ꠎꠣꠘꠥꠀꠞ ꠡꠢ ꠢꠇꠟ ꠝꠣꠟ-ꠍꠣꠝꠣꠘꠣ ꠝꠣꠐꠤꠞ ꠔꠟꠦ ꠢꠣꠝꠣꠁꠉꠦꠟ, ꠁꠔꠣꠅ ꠄꠞꠣ ꠖꠦꠈꠍꠦ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠌꠃꠈꠦ ꠝꠣꠛꠥꠖꠞ ꠢꠇꠟ ꠇꠥꠖꠞꠔꠤ ꠟꠤꠟꠣ-ꠈꠦꠟꠣ ꠖꠦꠈꠍ। ");
INSERT INTO syls_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","“ꠔꠦ ꠅꠈꠘ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠞꠣꠝ, ꠔꠥꠝꠞꠣ ꠁꠔꠣ ꠢꠇ꠆ꠇꠟꠔꠣ ꠝꠣꠘꠤꠅ, ꠔꠦꠃ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋ ꠙꠣꠞ ꠅꠁꠀ ꠎꠦ ꠖꠦꠡ ꠖꠈꠟꠞ ꠟꠣꠉꠤ ꠎꠣꠁꠞꠣꠄ, ꠔꠥꠝꠞꠣ ꠛꠟꠀꠟꠣ ꠛꠘꠤꠀ ꠢꠘꠞ ꠖꠈꠟꠖꠣꠞꠤ ꠙꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤ ꠅꠇꠟꠞꠦ ꠀꠞ ꠔꠣꠞꠣꠞ ꠀꠅꠟꠣꠖ ꠅꠇꠟꠞꠦ ꠎꠦ ꠖꠦꠡ ꠖꠤꠛꠣꠞ ꠟꠣꠉꠤ ꠇꠍꠝ ꠈꠣꠁꠍꠟꠣ, ꠖꠥꠗ ꠀꠞ ꠝꠃꠞ ꠜꠣꠘ꠆ꠒꠣꠞ ꠀꠟꠣ ꠢꠃ ꠀꠞꠣꠝꠞ ꠖꠦꠡꠅ ꠔꠥꠝꠞꠣꠞ ꠢꠣꠄꠀꠔꠤ ꠟꠣꠝ꠆ꠛꠣ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","ꠁ ꠖꠦꠡꠈꠣꠘ ꠔ ꠢꠃ ꠝꠤꠡꠞ ꠖꠦꠡꠞ ꠟꠣꠈꠣꠘ ꠘꠣꠄ ꠎꠦꠈꠣꠘ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣ ꠛꠣꠞ ꠅꠁꠀ ꠀꠁꠍ, ꠝꠘꠅ ꠅꠞ ꠘꠤ, ꠢꠣꠉ-ꠔꠞꠇꠣꠞꠤꠞ ꠈꠦꠔꠅ ꠎꠦꠟꠣ ꠙꠣꠘꠤ ꠖꠦꠁꠘ, ꠢꠃ ꠖꠦꠡꠅ ꠛꠤꠌꠤ ꠛꠣꠁꠘ ꠖꠤꠀ ꠢꠣꠞꠟꠦ ꠔꠥꠝꠞꠣ ꠙꠣꠅꠞ ꠘꠣꠃꠠꠣ ꠖꠤꠀ ꠅꠟꠣ ꠙꠣꠘꠤ ꠢꠤꠌꠤꠔꠣꠄ? ");
INSERT INTO syls_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","ꠅꠁꠟꠦ ꠉꠣꠋ ꠙꠣꠞ ꠅꠁꠀ ꠎꠦ ꠖꠦꠡ ꠔꠥꠝꠞꠣ ꠖꠈꠟ ꠇꠞꠣꠔ ꠎꠣꠁꠞꠣꠄ, ꠁ ꠖꠦꠡꠅ ꠙꠣꠠꠤꠀ ꠔꠟ ꠎꠣꠉꠣ ꠀꠞ ꠙꠣꠠ-ꠙꠞꠛꠔꠦ ꠜꠞꠣ, ꠁ ꠎꠝꠤꠘꠦ ꠀꠟ꠆ꠟꠣꠞ ꠖꠦꠅꠀ ꠝꠦꠊꠞ ꠙꠣꠘꠤ ꠈꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠁ ꠖꠦꠡꠞ ꠈꠤꠀꠟ ꠞꠣꠈꠂꠘ। ꠛꠍꠞꠞ ꠙꠄꠟꠣ ꠕꠣꠇꠤ ꠢꠦꠡ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠔꠣꠘ ꠖꠄꠀꠞ ꠘꠎꠞ ꠕꠣꠇꠦ ꠁ ꠎꠝꠤꠘꠞ ꠃꠙꠞꠦ। ");
INSERT INTO syls_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","“ꠔꠦ ꠀꠝꠤ ꠀꠁꠎ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠀꠞ, ꠁꠔꠣ ꠔꠥꠝꠞꠣ ꠈꠥꠛ ꠈꠤꠀꠟꠤ ꠅꠁꠀ ꠝꠣꠘꠤꠅ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞꠦ ꠝꠢꠛ꠆ꠛꠔ ꠇꠞꠤꠅ, ꠀꠞ ꠙꠥꠞꠣꠙꠥꠞ ꠖꠤꠟꠦ-ꠎꠣꠘꠦ ꠔꠣꠘ ꠄꠛꠣꠖꠔ-ꠛꠘ꠆ꠖꠦꠉꠤ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","ꠔꠦꠃ ꠝꠣꠛꠥꠖꠦ ꠎꠞꠥꠞ ꠝꠣꠚꠤꠇ ꠛꠍꠞꠞ ꠙꠄꠟꠣ ꠀꠞ ꠡꠦꠡꠦꠅ ꠞꠢꠝꠔꠤ ꠝꠦꠊ ꠖꠤꠀ, ꠔꠥꠝꠞꠣꠞ ꠈꠦꠔꠞ ꠚꠡꠟ, ꠀꠋꠉꠥꠞꠞ ꠞꠡ, ꠎꠄꠔꠥꠘꠞ ꠔꠦꠟ ꠢꠇ꠆ꠇꠟꠔꠣ ꠎꠥꠉꠣꠘ ꠖꠤꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","ꠔꠥꠝꠞꠣꠞ ꠙꠡꠥꠞ ꠙꠣꠟꠞ ꠟꠣꠉꠤ ꠎꠝꠤꠘꠅ ꠊꠣꠡ ꠖꠤꠛꠣ, ꠔꠥꠝꠞꠣ ꠔꠥꠡ꠆ꠐ ꠅꠁꠀ ꠈꠣꠘꠤ-ꠙꠣꠘꠤ ꠈꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","“ꠔꠣ-ꠅ ꠔꠥꠝꠞꠣ ꠢꠥꠡꠤꠀꠞ ꠞꠁꠅ, ꠀꠞꠘꠣꠄ ꠔꠥꠝꠞꠣꠞ ꠝꠘ ꠇꠥ-ꠙꠕꠦ ꠎꠣꠁꠛꠉꠤ, ꠀꠞ ꠔꠥꠝꠞꠣ ꠛꠦ-ꠙꠕꠤ ꠛꠘꠤꠀ ꠖꠦꠛ-ꠖꠦꠛꠤꠞ ꠙꠥꠎꠣ ꠇꠞꠛꠣꠄ, ꠁꠔꠣꠞꠦ ꠜꠇ꠆ꠔꠤ ꠇꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","ꠁꠟꠣ ꠇꠞꠟꠦ ꠔꠥꠝꠞꠣꠞ ꠃꠙꠞꠦ ꠝꠣꠛꠥꠖꠞ ꠉꠥꠍꠣꠞ ꠀꠉꠥꠁꠘ ꠉꠞꠝ ꠅꠁꠛ, ꠔꠣꠁꠘ ꠀꠍꠝꠣꠘꠞ ꠞꠢꠝꠔꠤ ꠖꠥꠀꠞ ꠛꠘ꠆ꠖ ꠇꠞꠤꠟꠤꠛꠣ, ꠔꠦꠃ ꠝꠦꠊ-ꠙꠣꠘꠤ ꠛꠘ꠆ꠖ ꠅꠁꠀ ꠎꠝꠤꠘꠅ ꠀꠞ ꠚꠡꠟ ꠚꠟꠤꠔ ꠘꠣꠄ, ꠀꠞ ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦ ꠖꠦꠡ ꠖꠣꠘ ꠇꠞꠞꠣ, ꠢꠃ ꠀꠞꠣꠝꠞ ꠖꠦꠡ ꠕꠣꠇꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠟꠖꠤ ꠇꠞꠤ ꠚꠥꠍꠤꠀ ꠚꠣꠟꠣꠁꠟ ꠅꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","ꠄꠞꠟꠣꠉꠤ ꠔꠥꠝꠞꠣꠞ ꠝꠘꠞ ꠝꠣꠎꠦ, ꠔꠥꠝꠞꠣꠞ ꠖꠤꠟꠞ ꠜꠤꠔꠞꠦ ꠀꠝꠣꠞ ꠅꠃ ꠢꠥꠇꠥꠝ ꠈꠣꠘ ꠉꠣꠕꠤꠀ ꠞꠣꠈꠤꠅ, ꠔꠥꠝꠞꠣꠞ ꠖꠥꠁꠅ ꠀꠔꠅ ꠁꠔꠣ ꠘꠤꠡꠣꠘꠣ ꠢꠤꠡꠣꠛꠦ ꠛꠣꠘ꠆ꠖꠤꠀ ꠕꠁꠅ, ꠀꠞ ꠇꠙꠣꠟꠞ ꠝꠣꠎꠦꠅ ꠟꠣꠉꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","ꠔꠥꠝꠞꠣꠞ ꠢꠥꠞꠥꠔ꠆ꠔꠣꠁꠘ꠆ꠔꠞꠦꠅ ꠁꠔꠣ ꠢꠇ꠆ꠇꠟꠔꠣ ꠔꠣꠟꠤꠝ ꠖꠤꠅ। ꠔꠥꠝꠞꠣ ꠊꠞꠅ ꠞꠅꠀꠞ ꠡꠝꠄ, ꠙꠕꠦ-ꠊꠣꠐꠦ ꠀꠐꠤꠛꠣꠞ ꠡꠝꠄ, ꠢꠥꠔꠤꠛꠣꠞ ꠡꠝꠄ ꠀꠞ ꠢꠥꠔꠘꠅ ꠕꠣꠇꠤ ꠃꠑꠤꠀ ꠢꠣꠞꠟꠦ ꠢꠣꠝꠦꠡꠣ ꠅꠔꠣ ꠛꠦꠙꠣꠞꠦ ꠛꠣꠔꠌꠤꠔ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","ꠁꠔꠣ ꠟꠦꠈꠤꠀ ꠔꠥꠝꠞꠣꠞ ꠛꠣꠠꠤꠞ ꠉꠦꠁꠐꠅ ꠀꠞ ꠖꠥꠀꠞꠞ ꠌꠃꠇꠣꠑꠅ ꠟꠣꠉꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","ꠁꠔꠣ ꠝꠣꠘꠟꠦ ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤꠞ ꠉꠦꠍꠦ ꠎꠦ ꠖꠦꠡ ꠖꠤꠛꠣꠞ ꠇꠍꠝ ꠈꠣꠁꠍꠟꠣ, ꠢꠃ ꠖꠦꠡꠅ ꠔꠥꠝꠞꠣ ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠀꠅꠟꠣꠖꠞ ꠢꠣꠄꠀꠔꠤ ꠅꠔꠖꠤꠘ ꠞꠁꠛ, ꠎꠔꠖꠤꠘ ꠁ ꠖꠥꠘꠤꠀꠞ ꠃꠙꠞꠦ ꠀꠍꠝꠣꠘ ꠞꠁꠛ। ");
INSERT INTO syls_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","“ꠀꠁꠎ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦꠔꠣ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠖꠤꠀꠞ, ꠔꠥꠝꠞꠣ ꠎꠥꠖꠤ ꠈꠥꠛ ꠈꠤꠀꠟꠤ ꠅꠁꠀ ꠁꠔꠣ ꠝꠣꠘꠅ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞꠦ ꠝꠢꠛ꠆ꠛꠔ ꠇꠞꠅ, ꠔꠣꠘ ꠛꠣꠔꠣꠁꠟ ꠙꠕꠦ ꠌꠟꠅ ꠀꠞ ꠔꠣꠘ ꠀꠡꠤꠇ ꠛꠘꠤꠀ ꠞꠅ, ");
INSERT INTO syls_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","ꠔꠦ ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞ ꠍꠣꠝꠘꠦ ꠕꠣꠇꠤ ꠢꠃ ꠖꠦꠡꠞ ꠢꠇꠟ ꠎꠣꠔꠤꠞꠦ ꠛꠣꠞ ꠇꠞꠤ ꠖꠤꠛꠣ, ꠔꠦꠃ ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠕꠣꠇꠤ ꠀꠞꠅ ꠛꠠ ꠛꠠ ꠀꠞ ꠛꠟꠀꠟꠣ ꠎꠣꠔꠤꠞꠦ ꠈꠦꠖꠣꠁꠀ ꠢꠘꠞ ꠖꠈꠟꠖꠣꠞꠤ ꠙꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","ꠔꠥꠝꠞꠣꠞ ꠙꠣꠅꠖꠤ ꠎꠦꠔꠣ ꠎꠣꠉꠣꠞ ꠃꠙꠞꠦ ꠀꠐꠤꠛꠣꠄ, ꠁꠔꠣ ꠢꠇꠟ ꠎꠣꠉꠣ ꠔꠥꠝꠞꠣꠞ ꠖꠈꠟꠅ ꠀꠁꠛ। ꠖꠃꠇꠘꠞ ꠝꠞꠥꠜꠥꠝꠤ ꠕꠣꠇꠤ ꠟꠦꠛꠣꠘꠘ ꠙꠞ꠆ꠎꠘ꠆ꠔ, ꠚꠥꠞꠣꠔ ꠉꠣꠋ ꠕꠣꠇꠤ ꠙꠁꠌꠝꠞ ꠖꠞꠤꠀ ꠙꠞ꠆ꠎꠘ꠆ꠔ ꠖꠈꠟꠖꠣꠞꠤ ꠙꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","ꠇꠥꠘꠥ ꠛꠦꠐꠣ ꠔꠥꠝꠞꠣꠞ ꠍꠣꠝꠘꠦ ꠃꠛꠣꠘꠤꠞ ꠔꠣꠇ꠆ꠇꠔ ꠅꠁꠔ ꠘꠣꠄ, ꠔꠥꠝꠞꠣ ꠢꠃ ꠖꠦꠡꠞ ꠎꠦꠈꠣꠘꠅ ꠎꠣꠁꠛꠣꠄ, ꠅꠈꠣꠘꠞ ꠝꠣꠘꠡꠦꠃ ꠔꠥꠝꠞꠣꠞꠦ ꠒꠞꠣꠁꠛꠣ, ꠔꠣꠞꠣꠞ ꠜꠤꠔꠞꠦ ꠇꠣꠙꠤꠛ, ꠁꠔꠣ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠘ ꠘꠤꠎꠞ ꠅꠀꠖꠣ ꠝꠣꠚꠤꠇꠃ ꠇꠞꠣꠁꠛꠣ। ");
INSERT INTO syls_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","“ꠢꠥꠘꠅ, ꠀꠁꠎ ꠀꠝꠤ ꠔꠥꠝꠞꠣꠞ ꠍꠣꠝꠘꠦ ꠞꠢꠝꠔ ꠀꠞ ꠟꠣꠘ꠆ꠘꠔ ꠖꠥꠁꠅꠔꠣ ꠖꠦꠈꠣꠁꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","ꠀꠝꠤ ꠅꠈꠘ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦꠟꠣ ꠢꠥꠇꠥꠝ ꠖꠤꠟꠣꠝ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠅꠃ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠎꠥꠖꠤ ꠔꠥꠝꠞꠣ ꠝꠣꠘꠅ, ꠔꠦ ꠔꠥꠝꠞꠣ ꠅꠃ ꠞꠢꠝꠔ ꠙꠣꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","ꠀꠞ ꠁꠔꠣ ꠘꠣ ꠝꠣꠘꠤꠀ ꠔꠥꠝꠞꠣ ꠎꠥꠖꠤ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠢꠥꠇꠥꠝꠞ ꠃꠟꠐꠣ ꠌꠟꠅ, ꠁ ꠙꠕ ꠕꠣꠇꠤ ꠢꠞꠤꠀ ꠇꠥꠘꠥ ꠖꠦꠛ-ꠖꠦꠛꠤꠞ ꠈꠞꠦ ꠈꠞꠦ ꠎꠣꠅ, ꠔꠦ ꠔꠥꠝꠞꠣ ꠟꠣꠘ꠆ꠘꠔꠤ ꠅꠁꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","“ꠔꠥꠝꠞꠣ ꠎꠦ ꠖꠦꠡ ꠖꠈꠟ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠎꠣꠁꠞꠣꠄ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠎꠦꠛꠟꠣ ꠔꠥꠝꠞꠣꠞꠦ ꠢꠃ ꠖꠦꠡꠅ ꠘꠤꠀ ꠢꠣꠞꠣꠁꠛꠣ, ꠢꠣꠞꠣꠁꠀ ꠢꠣꠞꠟꠦ ꠔꠥꠝꠞꠣ ꠅꠃ ꠞꠢꠝꠔꠞ ꠇꠕꠣ ꠉꠞꠤꠍꠤꠝ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠃꠑꠤꠀ ꠄꠟꠣꠘ ꠇꠞꠛꠣꠄ, ꠀꠞ ꠅꠃ ꠟꠣꠘ꠆ꠘꠔꠞ ꠇꠕꠣ ꠄꠟꠣꠘ ꠇꠞꠛꠣꠄ ꠁꠛꠣꠟ ꠙꠣꠠꠞ ꠃꠙꠞꠦ ꠃꠑꠤꠀ। ");
INSERT INTO syls_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","ꠔꠥꠝꠞꠣ ꠔ ꠌꠤꠘꠅ, ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋ ꠙꠣꠞ ꠅꠁꠀ ꠙꠕꠞ ꠙꠁꠌꠝꠦꠖꠤ ꠉꠤꠟꠉꠟꠞ ꠗꠣꠞꠅ ꠅꠃ ꠖꠥꠁꠅ ꠙꠣꠠ ꠀꠍꠦ, ꠀꠞꠣꠛꠣ ꠘꠣꠝꠞ ꠔꠟ ꠎꠣꠉꠣꠞ ꠛꠣꠡꠤꠘ꠆ꠖꠣ ꠇꠦꠘꠣꠘꠤ ꠅꠇꠟꠞ ꠖꠦꠡꠞ ꠝꠥꠞꠤꠞ ꠄꠟꠘ ꠛꠘꠞ ꠇꠣꠘ꠆ꠖꠣꠞ ꠅꠃ ꠖꠥꠁꠅ ꠙꠣꠠ ꠌꠤꠘꠅ ꠘꠣ ꠘꠤ? ");
INSERT INTO syls_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","ꠝꠘꠅ ꠞꠣꠈꠤꠅ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦ ꠖꠦꠡꠞ ꠖꠈꠟꠖꠣꠞꠤ ꠖꠤꠞꠣ, ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋ ꠙꠣꠞ ꠅꠁꠀ ꠢꠃ ꠖꠦꠡꠅ ꠢꠣꠝꠣꠁꠀ ꠢꠣꠞꠤ ꠔꠥꠝꠞꠣ ꠎꠦꠛꠟꠣ ꠢꠘꠅ ꠛꠡꠔ ꠇꠞꠛꠣꠄ, ");
INSERT INTO syls_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","ꠢꠃ ꠡꠝꠄ ꠔꠥꠝꠞꠣ ꠅꠃ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠀꠞ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠈꠥꠛ ꠈꠤꠀꠟ ꠇꠞꠤꠀ ꠀꠝꠟ ꠇꠞꠤꠅ, ꠎꠦꠔꠣ ꠅꠈꠘ ꠔꠥꠝꠞꠣꠞꠦ ꠇꠁꠟꠣꠝ। ");
INSERT INTO syls_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","“ꠅ ꠛꠘꠤ ꠁꠍꠞꠣꠁꠟ, ꠔꠥꠝꠞꠣꠞ ꠝꠄ-ꠝꠥꠞꠛ꠆ꠛꠤꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞꠦ ꠎꠦ ꠖꠦꠡꠞ ꠖꠈꠟꠖꠣꠞꠤ ꠖꠤꠍꠂꠘ, ꠢꠃ ꠖꠦꠡꠅ ꠉꠤꠀ ꠀꠝꠣꠞ ꠛꠣꠔꠣꠁꠟ ꠅꠃ ꠢꠥꠇꠥꠝ-ꠀꠢꠇꠣꠝ ꠀꠞ ꠘꠤꠅꠝ-ꠇꠣꠘꠥꠘ ꠢꠞ-ꠢꠣꠝꠦꠡꠣ ꠝꠣꠘꠤꠀ ꠌꠟꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","ꠢꠘꠞ ꠎꠔ ꠎꠣꠔꠤꠞꠦ ꠈꠦꠖꠣꠁꠀ ꠢꠣꠞꠤ ꠔꠥꠝꠞꠣ ꠖꠈꠟꠖꠣꠞꠤ ꠙꠣꠁꠞꠣꠄ, ꠔꠣꠞꠣꠞ ꠢꠥꠞꠥ-ꠛꠠ ꠢꠇꠟ ꠙꠣꠠ-ꠙꠞꠛꠔꠞ ꠃꠙꠞꠦ, ꠒꠣꠟ-ꠙꠣꠟꠣ ꠝꠦꠟꠣꠁꠟ ꠔꠞꠔꠣꠎꠣ ꠢꠇꠟ ꠉꠣꠍꠞ ꠔꠟꠦ ꠔꠣꠞꠣ ꠎꠦꠔꠣ ꠖꠦꠛ-ꠖꠦꠛꠤꠞ ꠙꠥꠎꠣ ꠇꠞꠂꠘ, ꠔꠥꠝꠞꠣ ꠁꠔꠣ ꠖꠦꠛ-ꠖꠦꠛꠤꠞ ꠀꠡ꠆ꠔꠣꠘꠣ ꠜꠣꠋꠉꠤꠀ ꠄꠇ꠆ꠇꠦꠛꠣꠞꠦ ꠌꠥꠞꠝꠣꠞ ꠇꠞꠤꠟꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","ꠔꠣꠞꠣꠞ ꠢꠇꠟ ꠛꠟꠤ ꠈꠣꠘꠣ ꠜꠣꠋꠉꠤꠟꠤꠅ, ꠙꠥꠎꠣꠞ ꠙꠣꠔ꠆ꠔꠞ ꠅꠇꠟ ꠌꠥꠞꠝꠣꠞ ꠇꠞꠤꠅ, ꠀꠡꠦꠞꠣ-ꠖꠦꠛꠤꠞ ꠘꠤꠡꠣꠘꠣ ꠈꠥꠐꠤ ꠅꠇꠟ ꠀꠉꠥꠁꠘꠖꠤ ꠎꠣꠟꠣꠁꠟꠤꠅ, ꠔꠣꠞꠣꠞ ꠛꠣꠘꠣꠁꠟ ꠝꠥꠞ꠆ꠔꠤ ꠅꠇꠟ ꠜꠣꠋꠉꠤꠟꠤꠅ, ꠁꠔꠣꠞ ꠘꠣꠝ ꠢꠤ ꠎꠝꠤꠘ ꠕꠣꠇꠤ ꠙꠥꠞꠣꠙꠥꠞ ꠚꠥꠍꠤꠀ ꠚꠣꠟꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","“ꠀꠞ ꠔꠣꠞꠣꠞ ꠖꠦꠛ-ꠖꠦꠛꠤꠞ ꠙꠥꠎꠣꠞ ꠘꠝꠥꠘꠣꠄ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠄꠛꠣꠖꠔ-ꠛꠘ꠆ꠖꠦꠉꠤ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","ꠅꠁꠟꠦ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠥꠝꠞꠣꠞꠦ ꠖꠤꠖꠣꠞ-ꠖꠞꠡꠘ ꠖꠤꠛꠣꠞ ꠈꠤꠀꠟꠦ, ꠔꠣꠘ ꠘꠤꠎꠞ ꠛꠣꠄꠔꠥꠟ꠆ꠟꠣ ꠡꠞꠤꠚ ꠢꠤꠡꠣꠛꠦ, ꠔꠥꠝꠞꠣꠞ ꠢꠇꠟ ꠈꠣꠘ꠆ꠖꠣꠘꠞꠦ ꠖꠦꠅꠀ ꠎꠣꠉꠣ ꠕꠣꠇꠤ ꠔꠣꠁꠘ ꠎꠦ ꠎꠣꠉꠣꠞꠦ ꠙꠍꠘ꠆ꠖ ꠇꠞꠛꠣ, ꠔꠥꠝꠞꠣ ꠔꠣꠘ ꠄꠛꠣꠖꠔꠤꠞ ꠟꠣꠉꠤ ꠢꠃ ꠎꠣꠉꠣꠔ ꠀꠎꠤꠞ ꠅꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","ꠔꠥꠝꠞꠣ ꠎꠣꠞꠎꠤꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠢꠇꠟ ꠎꠣꠔꠞ ꠙꠡꠥ ꠇꠥꠞꠛꠣꠘꠤ, ꠢꠇꠟ ꠞꠥꠎꠤ-ꠞꠥꠎꠉꠣꠞꠞ ꠖꠡ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ, ꠟꠤꠟ꠆ꠟꠣ-ꠍꠖꠉꠣ, ꠝꠣꠘ꠆ꠘꠔꠞ ꠇꠥꠞꠛꠣꠘꠤ, ꠖꠣꠘ-ꠈꠄꠞꠣꠔ ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠙꠡꠥꠞ ꠙꠄꠟꠣ ꠛꠣꠁꠌ꠆ꠌꠣꠞꠦ ꠅꠃ ꠎꠣꠉꠣꠔ ꠀꠘꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","ꠅꠈꠣꠘꠅ ꠔꠥꠝꠞꠣꠞ ꠙꠞꠤꠛꠣꠞꠞ ꠢꠇꠟꠞꠦ ꠟꠁꠀ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠍꠣꠝꠘꠦ ꠈꠣꠘꠣ-ꠙꠤꠘꠣ ꠇꠞꠤꠅ, ꠀꠞ ꠔꠣꠘ ꠞꠢꠝ-ꠛꠞꠇꠔ ꠙꠣꠅꠀ ꠢꠇꠟ ꠟꠣꠈꠣꠘ ꠇꠣꠝꠣꠁ-ꠞꠥꠎꠉꠣꠞꠞ ꠟꠣꠉꠤ ꠈꠥꠡꠤ-ꠛꠣꠡꠤ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","“ꠀꠞ ꠅꠈꠘ ꠀꠝꠞꠣ ꠎꠦꠟꠣ ꠎꠦꠝꠘꠦ ꠈꠥꠡꠤ ꠅꠝꠘꠦꠃ ꠌꠟꠞꠣꠝ, ꠢꠘꠅ ꠉꠤꠀ ꠢꠣꠞꠟꠦ ꠔꠥꠝꠞꠣ ꠁꠟꠣ ꠇꠞꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","ꠔꠥꠝꠞꠣ ꠡꠥꠈ-ꠡꠣꠘ꠆ꠔꠤꠄ ꠛꠡꠔ ꠇꠞꠣꠞ ꠟꠣꠉꠤ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠎꠦ ꠎꠣꠉꠣꠞ ꠖꠈꠟꠖꠣꠞꠤ ꠖꠤꠞꠣ, ꠔꠥꠝꠞꠣ ꠔ ꠅꠈꠘꠅ ꠢꠤꠘꠅ ꠉꠦꠍ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","ꠔꠣ-ꠅ ꠔꠥꠝꠞꠣ ꠎꠦꠛꠟꠣ ꠎꠞ꠆ꠖꠣꠘ ꠉꠣꠋ ꠙꠣꠞ ꠅꠁꠀ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠖꠦꠅꠀ ꠖꠦꠡꠅ ꠉꠤꠀ ꠛꠡꠔꠤ ꠇꠞꠛꠣꠄ, ꠢꠃ ꠡꠝꠄ ꠝꠣꠛꠥꠖꠦ ꠔꠥꠝꠞꠣꠞ ꠌꠣꠁꠞꠅ ꠉꠣꠟꠣꠞ ꠖꠥꠡꠝꠘꠞ ꠀꠔ ꠕꠣꠇꠤ ꠡꠣꠘ꠆ꠔꠤ ꠖꠤꠀ ꠢꠣꠞꠟꠦ, ");
INSERT INTO syls_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","ꠔꠣꠁꠘ ꠘꠤꠎꠞ ꠛꠣꠄꠔꠥꠟ꠆ꠟꠣ ꠡꠞꠤꠚ ꠢꠤꠡꠣꠛꠦ ꠎꠦ ꠎꠣꠉꠣꠞꠦ ꠙꠍꠘ꠆ꠖ ꠇꠞꠛꠣ, ꠢꠃ ꠎꠣꠉꠣꠔ ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠛꠣꠔꠣꠁꠟ ꠢꠇꠟꠔꠣ ꠟꠁꠀ ꠀꠎꠤꠞ ꠅꠁꠅ। ꠔꠥꠝꠞꠣꠞ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ, ꠢꠇꠟ ꠎꠣꠔꠞ ꠇꠥꠞꠛꠣꠘꠤꠞ ꠙꠡꠥ, ꠢꠇꠟ ꠞꠥꠎꠤ-ꠞꠥꠎꠉꠣꠞꠞ ꠖꠡ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ, ꠟꠤꠟ꠆ꠟꠣ-ꠍꠖꠉꠣ, ꠖꠣꠘ-ꠈꠄꠞꠣꠔ ꠀꠞ ꠢꠇꠟ ꠘꠝꠥꠘꠣꠞ ꠝꠣꠘ꠆ꠘꠔꠞ ꠇꠥꠞꠛꠣꠘꠤ ꠟꠁꠀ ꠅꠘꠅ ꠀꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","ꠀꠁꠀ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠍꠣꠝꠘꠦ ꠔꠥꠝꠞꠣ ꠘꠤꠎꠦ, ꠔꠥꠝꠞꠣꠞ ꠙꠥꠀ-ꠙꠥꠠꠤꠘ, ꠔꠥꠝꠞꠣꠞ ꠛꠣꠘ꠆ꠖꠤ-ꠉꠥꠟꠣꠝ, ꠔꠥꠝꠞꠣꠞ ꠉꠣꠃ ꠀꠞ ꠐꠣꠃꠘꠞ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠥꠡ ꠅꠇꠟ, ꠎꠦꠞꠣ ꠔꠥꠝꠞꠣꠞ ꠟꠣꠈꠣꠘ ꠇꠥꠘꠥ ꠎꠣꠉꠣ-ꠎꠝꠤ ꠙꠣꠁꠍꠦ ꠘꠣ, ꠔꠥꠝꠞꠣ ꠢꠇꠟꠦ ꠝꠤꠟꠤꠀ ꠈꠥꠡꠤ-ꠛꠣꠡꠤ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","ꠀꠞ ꠈꠥꠛ ꠢꠥꠡꠤꠀꠞ ꠞꠁꠅ, ꠔꠥꠝꠞꠣ ꠘꠤꠎꠞ ꠙꠍꠘ꠆ꠖ ꠝꠔ ꠎꠦꠍꠣ ꠎꠣꠉꠣꠔ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠖꠤꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","ꠛꠞꠋ ꠔꠥꠝꠞꠣꠞ ꠈꠣꠘ꠆ꠖꠣꠘ ꠅꠇꠟꠞꠦ ꠖꠦꠅꠀ ꠎꠝꠤꠘ ꠕꠣꠇꠤ ꠔꠣꠁꠘ ꠎꠦ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠎꠣꠉꠣ ꠙꠍꠘ꠆ꠖ ꠇꠞꠛꠣ, ꠈꠣꠟꠤ ꠢꠃ ꠎꠣꠉꠣꠔ ꠎꠣꠟꠣꠁꠟ ꠇꠥꠞꠛꠣꠘꠤ ꠀꠖꠣꠄ ꠇꠞꠤꠅ, ꠀꠞ ꠢꠃ ꠎꠣꠉꠣꠞ ꠟꠣꠉꠤ ꠀꠝꠣꠞ ꠛꠣꠔꠣꠁꠟ ꠢꠇꠟ ꠇꠣꠝ-ꠇꠣꠎ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","“ꠔꠣ-ꠅ ꠔꠥꠝꠞꠣꠞ ꠝꠘꠞ ꠡꠈ ꠅꠁꠟꠦ ꠙꠣꠇ-ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦꠅ ꠢꠇꠟꠦꠃ ꠎꠦꠇꠥꠘꠥ ꠎꠣꠔꠞ ꠎꠋꠟꠤ ꠅꠞꠤꠘꠞ ꠉꠥꠡ꠆ꠔ ꠈꠣꠅꠀ ꠎꠦꠟꠣ ꠎꠣꠁꠎ ꠀꠍꠦ, ꠅꠟꠣ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠞꠢꠝ-ꠛꠞꠇꠔꠦ ꠙꠣꠅꠀ ꠙꠡꠥꠞꠦ ꠎꠛ ꠇꠞꠤꠀ, ꠔꠥꠝꠞꠣꠞ ꠄꠟꠣꠇꠣꠞ ꠉꠣꠃ ꠛꠣ ꠐꠣꠃꠘꠅ ꠈꠣꠁꠔꠣꠄ ꠙꠣꠞꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","ꠈꠣꠟꠤ ꠔꠥꠝꠞꠣ ꠇꠥꠘꠥ ꠟꠃ ꠈꠣꠁꠅ ꠘꠣ, ꠟꠃꠞꠦ ꠙꠣꠘꠤꠞ ꠘꠝꠥꠘꠣꠄ ꠝꠣꠐꠤꠔ ꠓꠣꠟꠤ ꠖꠤꠛꠣꠄ। ");
INSERT INTO syls_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","“ꠔꠥꠝꠞꠣꠞ ꠢꠇꠟ ꠎꠣꠔꠞ ꠚꠄ-ꠚꠡꠟꠞ, ꠀꠋꠉꠥꠞꠞ ꠡꠞꠛꠔꠞ ꠀꠞ ꠔꠦꠟꠞ ꠖꠡ ꠛꠣꠐꠞ ꠄꠇ ꠛꠣꠐ, ꠔꠥꠝꠞꠣꠞ ꠉꠞꠥ-ꠍꠣꠉꠟꠞ ꠙꠄꠟꠣ ꠛꠣꠁꠌ꠆ꠌꠣ, ꠔꠥꠝꠞꠣꠞ ꠝꠣꠘ꠆ꠘꠔꠞ ꠢꠇꠟꠔꠣ, ꠔꠥꠝꠞꠣꠞ ꠟꠤꠟ꠆ꠟꠣ-ꠍꠖꠉꠣ, ꠖꠣꠘ-ꠈꠄꠞꠣꠔ, ꠁꠔꠣ ꠇꠥꠘ꠆ꠔꠣꠃ ꠔꠥꠝꠞꠣꠞ ꠛꠡꠔꠤ ꠄꠟꠣꠇꠣꠞ ꠇꠥꠘꠥ ꠉꠣꠃꠔ ꠛꠣ ꠐꠣꠃꠘꠅ ꠈꠣꠁꠅ ꠘꠣ। ");
INSERT INTO syls_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","ꠁꠔꠣ ꠈꠣꠟꠤ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠙꠍꠘ꠆ꠖ ꠇꠞꠣ ꠎꠣꠉꠣꠔ ꠘꠤꠀ ꠔꠣꠘ ꠍꠣꠝꠘꠦ ꠈꠣꠁꠅ। ꠔꠥꠝꠞꠣ ꠘꠤꠎꠦ, ꠔꠥꠝꠞꠣꠞ ꠙꠥꠀ-ꠙꠥꠠꠤꠘ, ꠔꠥꠝꠞꠣꠞ ꠉꠥꠟꠣꠝ-ꠛꠣꠘ꠆ꠖꠤ, ꠀꠞ ꠔꠥꠝꠞꠣꠞ ꠉꠣꠃ ꠛꠣ ꠐꠣꠃꠘꠞ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠡꠦ ꠈꠣꠁꠛꠣ। ꠔꠥꠝꠞꠣꠞ ꠢꠇꠟ ꠘꠝꠥꠘꠣꠞ ꠇꠣꠝ-ꠇꠣꠎꠞ ꠝꠣꠎꠦ ꠘꠤꠎꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠞ ꠍꠣꠝꠘꠦ ꠈꠥꠡꠤ-ꠛꠣꠡꠤ ꠇꠞꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","ꠔꠣ-ꠅ ꠔꠥꠝꠞꠣꠞ ꠖꠦꠡꠅ ꠎꠔꠖꠤꠘ ꠛꠡꠔ ꠇꠞꠛꠣꠄ, ꠅꠔꠖꠤꠘ ꠟꠦꠛꠤ ꠈꠣꠘ꠆ꠖꠣꠘꠞ ꠝꠣꠘꠡꠞ ꠃꠙꠞꠦ ꠈꠤꠀꠟ-ꠘꠎꠞ ꠞꠣꠈꠤꠅ। ");
INSERT INTO syls_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","“ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠔꠣꠘ ꠅꠀꠖꠣ ꠝꠣꠚꠤꠇ ꠔꠥꠝꠞꠣꠞ ꠖꠦꠡꠞ ꠡꠤꠝꠣꠘꠣ ꠛꠣꠠꠣꠁꠀ ꠢꠣꠞꠟꠦ, ꠔꠥꠝꠞꠣ ꠎꠦꠛꠟꠣ ꠉꠥꠡ꠆ꠔ ꠈꠣꠁꠛꠣꠞ ꠘꠤꠅꠔꠦ ꠇꠁꠛꠣꠄ, ꠉꠥꠡ꠆ꠔ ꠈꠣꠁꠔꠣꠝ ꠝꠘꠦ ꠌꠣꠞ, ꠢꠃ ꠡꠝꠄ ꠔꠥꠝꠞꠣꠞ ꠝꠘꠞ ꠡꠈ ꠝꠤꠐꠣꠁꠀ ꠉꠥꠡ꠆ꠔ ꠈꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖ ꠀꠟ꠆ꠟꠣꠄ ꠛꠣꠄꠔꠥꠟ꠆ꠟꠣ ꠡꠞꠤꠚ ꠢꠤꠡꠣꠛꠦ ꠎꠦ ꠎꠣꠉꠣ ꠙꠍꠘ꠆ꠖ ꠇꠞꠛꠣ, ꠢꠤ ꠎꠣꠉꠣ ꠎꠥꠖꠤ ꠔꠥꠝꠞꠣꠞ ꠛꠡꠔ ꠈꠣꠘꠣ ꠕꠣꠇꠤ ꠛꠣꠇ꠆ꠇꠣ ꠖꠥꠞꠁ ꠅꠄ, ꠔꠦ ꠔꠥꠝꠞꠣ ꠀꠝꠣꠞ ꠛꠣꠔꠣꠁꠟ ꠢꠥꠇꠥꠝ ꠝꠣꠚꠤꠇ ꠔꠥꠝꠞꠣꠞ ꠝꠣꠛꠥꠖꠞ ꠖꠦꠅꠀ ꠉꠞꠥ-ꠍꠣꠉꠟꠞ ꠙꠣꠟ ꠕꠣꠇꠤ ꠙꠡꠥ ꠘꠤꠀ ꠎꠛ ꠇꠞꠤꠅ, ꠀꠞ ꠎꠣꠞꠎꠤꠞ ꠉꠣꠃ ꠛꠣ ꠐꠣꠃꠘꠅ ꠘꠤꠎꠞ ꠈꠥꠡꠤꠄ ꠉꠥꠡ꠆ꠔ ꠈꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","ꠡꠤꠇꠣꠞꠞ ꠎꠋꠟꠤ ꠅꠞꠤꠘꠞ ꠉꠥꠡ꠆ꠔꠞ ꠟꠣꠈꠣꠘ ꠔꠥꠝꠞꠣ ꠁꠔꠣ ꠈꠣꠁꠅ, ꠙꠣꠇ-ꠘꠣꠙꠣꠇ ꠢꠣꠟꠔꠦ ꠢꠇꠟꠦꠃ ꠈꠣꠁꠅ। ");
INSERT INTO syls_vpl VALUES ("DT12_23","006_12_23","DEU","12","23