﻿USE sofia;
DROP TABLE IF EXISTS sofia.syll_vpl;
CREATE TABLE syll_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES syll_vpl WRITE;
INSERT INTO syll_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Foyla-u Allae asman ar dunia foyda ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Duniai niraḳar ar ḳali asil, goin fanir ufre fura andair asil. Allar ruhu er ufre solasol ḳorta. ");
INSERT INTO syll_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Bade Allae formaila for ouk, ar for oilo. ");
INSERT INTO syll_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Allae deḳla for bala. Tain andair taki forre alga ḳoria ");
INSERT INTO syll_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","er nam raḳla din, ar andairor nam raḳla rait. Hainja gelo, bian-o gelo, ikṭa oilo foyla din. ");
INSERT INTO syll_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Bade Allae formaila, fanir maze gumbuzor laḳan faḳ zaga ouk, ar fani dui bag oizauk. ");
INSERT INTO syll_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ar Allae faḳ zaga foyda ḳoria, tolor ar ufror fani alga ḳorla. Ar oula oilo. ");
INSERT INTO syll_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Allae gumbuzor laḳan ze zaga banaila, tar nam raḳla asman. Hainja gelo, bian-o gelo, ikṭa oilo dui nombor din. ");
INSERT INTO syll_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Erbade Allae formaila, asmanor tolor fani eḳ zagat dola ouk, ar hukna zaga deḳa zauk. Ar oula oilo. ");
INSERT INTO syll_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Allae hukna zagar nam raḳla zomin ar zomail fanir nam doria. Tain deḳla ita bala. ");
INSERT INTO syll_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Bade Allae formaila, zomino gash folouk; ar hoḳol zator bisala lota-fata gas-gasalir zonom ouk. Ar zominor ufre hoḳol zator folor gas-o ouk, era nizor zatmoto fol dorbo ar folor maze zarzir bis-o taḳbo. Ar oula oilo. ");
INSERT INTO syll_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Zomino gash folilo, hoḳol zator bisala lota-fata gas-birik zonmilo. Zominor ufre hoḳol zator folor gas oilo zetae zarzir zatmoto fol dore, hi folor maze zarzir bis-o ase. Allae deḳla ita bala. ");
INSERT INTO syll_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Hainja gelo, bian-o gelo, ikṭa oilo tin nombor din. ");
INSERT INTO syll_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Bade Allae formaila, asmanor maze oula serag oḳol ouk, zara rait taki dinre alga ḳore. Ita alga alga din, bosor ar id-utshobor nishana oibo. ");
INSERT INTO syll_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Asman taki tara duniair ufre for dibo. Oula-u oilo. ");
INSERT INTO syll_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Allae duiṭa boṛo serag banaila, ermaze boṛoṭare dinor ufre bashshai korar lagi ar huruṭare raitor ufre. Ita saṛa tain tera oḳol-o foyda ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Tain erare asmanor maze boaila zate tara duniait for dey. ");
INSERT INTO syll_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Era din ar raitor ufre bashshai kore, andair taki forre alga ḳore. Allae deḳla ita bala. ");
INSERT INTO syll_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Hainja gelo, bian-o gelo, ikṭa oilo sair nombor din. ");
INSERT INTO syll_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Bade Allae formaila, fanir maze zandar oḳol fale fale bori zauk, ar duniair ufre asmanor maze fakin uṛouk. ");
INSERT INTO syll_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ar Allae doriar biraṭ zandar oḳol, ar fanir maze fal bandia gurra hoḳol zator zandar foyda ḳorla, ar hoḳol zator faki-o foyda ḳorla. Tain deḳla ita bala. ");
INSERT INTO syll_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Tain tara hoḳolre ou laḳan borkot nazil ḳorla, tumra folala oia baṛo ar doriar fani bori zao, duniair maze faki oḳol-o baṛouk. ");
INSERT INTO syll_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Hainja gelo, bian-o gelo, ikṭa oilo fas nombor din. ");
INSERT INTO syll_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Erbade Allae formaila, maṭi taki oula zandar ouk zarar nizor zat oḳolre baṛaibo, erar maze fala heman, maṭit solra huru-muru zandar ar zongli zanuar oḳol-o. Oula-u oilo. ");
INSERT INTO syll_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Allae duniair maze hoḳol zator zongli zanuar, fala heman ar maṭir maze buke solra zandar banaila. Tain deḳla ita bala. ");
INSERT INTO syll_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Erbade Allae formaila, ao amrar surote amrar loge mil rakia manush banai. Tara doriar mas, asmanor faki, zanuar, maṭir maze buke solra zandar, ar asta duniair ufre bashshai korouk. ");
INSERT INTO syll_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Tain tan nizor surote manush foyda ḳorla, ekkere nizor moto ḳori foyda ḳorla, foyda ḳorla beṭa ar beṭi. ");
INSERT INTO syll_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ar tarare borkot nazil ḳoria ḳoila, tumitain folala oia baṛia duniai borizao. Duniaire shashon ḳoro, ar doriar mas, asmanor faki, maṭir ufre solra hoḳol zandaror ufre bashshai koro. ");
INSERT INTO syll_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Erbade Allae formaila, huno, duniar ufror hoḳol zator bisala gas-birik, ar hoḳol zator folor gas zarar nizor zatmoto fol dore zar folor maze tarar nizor bis ase, ita hoḳolta ami tumrar ḳanir lagi dilam. ");
INSERT INTO syll_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Duniar forteḳ zanuar, asmanor fakin, maṭir maze buke solra zandar, ita hokkol zandaror ḳanir lagi ami hoḳol lota-fata ar gash dilam. Oula-u oilo. ");
INSERT INTO syll_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Allae tan foyda ḳora hoḳolta deḳla, ita hoḳolta-u kub bala oise. Hainja gelo, bian-o gelo. Ikṭa oilo soy nombor din. ");
INSERT INTO syll_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ou laḳan asman-zomin ar er mazor hoḳolta foyda ḳora shesh oilo. ");
INSERT INTO syll_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Allae i hoḳol ḳam shesh ḳoria harle shat nombor din aram ḳorla, tain idin ar kunta foyda ḳorla na. ");
INSERT INTO syll_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ou shat nombor dinre borkot nazil ḳoria pak din ḳorla, tan hoḳolta foyda ḳora shesh ḳori tain ou din ziraila. ");
INSERT INTO syll_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ou oilo asman ar zomin foydar boyan. Mabud Allae zebla asman ar zomin foyda ḳorsila, ");
INSERT INTO syll_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","i shomoy zominor ufre kunuzator gas-fala asil na ar kunu lota-fata-o folise na, ḳaron tain zominor ufre meg disoin na, ar zomin abad ḳorar manush-o asil na. ");
INSERT INTO syll_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ou shomoy maṭir mur taki fani uṭto ar zomin bizto. ");
INSERT INTO syll_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Bade Mabud Allae feḳ maṭi dia manush banaia tar naḳor maze fu dia zan haraila. Ar ou manush zandar oilo. ");
INSERT INTO syll_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Mabud Allae fubedi Adan namor zagat eḳ bagan ḳorsila, hono tanor banail ou manushre raḳla. ");
INSERT INTO syll_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Hikanor maṭit tain ou laḳan gas oḳol folaisla, zeta deḳte kub shundor ar fol-o ḳaite kub moza. Ar baganor mazḳano tain “zindegi-gas” ar “neki-bodir aḳol deora gas” namor duiṭa gas-o raḳsila. ");
INSERT INTO syll_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Hou bagano fani zugaia dito ek gang asil, zeḳṭa Adanor mazedi bar oia sair bag oigesil. ");
INSERT INTO syll_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Foyla gangor nam asil Pishun, ikṭa asta Hobila deshor bitre dia gese. Ino shuna faoa zae, ");
INSERT INTO syll_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ar ou deshor shuna kub ḳaṭi, ita saṛa-o hino meshke-ambor ar akik moni faoa zae. ");
INSERT INTO syll_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Dui nombor gangor nam Zihun, ikṭa asta Kush deshor bitre dia gese. ");
INSERT INTO syll_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Tin nombor gangor nam Dojla, ikṭa Ashiria deshor fubedia gese. Ar sair nombor gangor nam oilo Furat. ");
INSERT INTO syll_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Bade Mabud Allae ou manushre Adan bagano raḳla, hino ḳet-ḳamar ar hefazot ḳorar lagi. ");
INSERT INTO syll_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Tain Adomre hukum dila, “Tumi tumar kushimoto i bagisar zekunu gasor fol ḳaitae farbae, ");
INSERT INTO syll_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ḳali neki-bodir aḳolor gasor fol ḳaio na, zedin tumi ou gasor fol ḳaibae idin tumi morbae-u morbae.” ");
INSERT INTO syll_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Erbade Mabud Allae ḳoila, “Manshor lagi eḳla taḳa bala nae. Ami tar laḳ eḳzon zuṛi banaimu.” ");
INSERT INTO syll_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ar Mabud Allae duniair hoḳol zandar ar asmanor hoḳol faki maṭidi banaia ou manshor samne anla, deḳla ein itare kita ḳoia ḍaḳoin, ar tain zare ze name ḍaḳla, tar ou nam oilo. ");
INSERT INTO syll_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Adome hoḳol fala heman, asmanor faki ar zongli zanuaror nam raḳla, itar maze tan lak kunu zuṛi millo na. ");
INSERT INTO syll_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Erbade tain Adomor maze behushi gum anla. Ou gumor maze tan fainjoror eḳṭa aḍḍi kulia nia zagaṭa bond ḳori dila, ");
INSERT INTO syll_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","ar ou aḍḍi dia Mabud Allae eḳ beṭimanush banaia Adomor gese anla. ");
INSERT INTO syll_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Tane dekia Adome ḳoila, “Oḳon oise, tai amar aḍḍir aḍḍi, gustor gust. Tair nam oibo nari, taire nor taki neoa.” ");
INSERT INTO syll_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Erlagi beṭainte ma-bafre saṛia bour loge roiba, tara duiozon eḳ shoril oiba. ");
INSERT INTO syll_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Adom ar tan bibir shoril udam taḳto, ita kunu shorom asil na. ");
INSERT INTO syll_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Mabud Allar foyda ḳora zominor hoḳol zandaror maze haf oilo hoḳol taki fondibaz. Ou hafe eḳdin hi beṭi manshore ḳoilo, “Allae hasau tumatanre ḳoisoin ni, baganor hoḳol gasor fol tumra ḳaitae fartae nae?” ");
INSERT INTO syll_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Beṭie ḳoila, “Baganor zekunu gasor fol amra ḳaitam fari, ");
INSERT INTO syll_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ḳali baganor mazḳano ze gasṭa ase, Allae ḳoisoin, tumra er fol ḳaio na, soio-o na, soile-u morbae.” ");
INSERT INTO syll_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ou hafe tanre ḳoilo, “Na, kunumonte-u mortae nae. ");
INSERT INTO syll_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Allae to zanoin, zedin tumra i gasor fol ḳailibae idin tumrar souk kulizibo, ar neki-bodir aḳol faia tumra Allar laḳan oizibae.” ");
INSERT INTO syll_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Beṭie zebla buzla, ou gasor fol ḳaite moza oibo, deḳte-o shundor, ar aḳoldar-o oizimu, ou tain fol faṛia ḳaila, ar tan zamaire-o dila ar zamaie-o ḳailila. ");
INSERT INTO syll_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Loge loge tara duio zonor souk kuli gelo, ar buzla tain-tain lemṭa. Ou tara ḍumur gasor ḳoyṭa fata siṛia silai kori lemṭi banaila. ");
INSERT INTO syll_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Hainja bala tara Mabud Allar aoaz hunla, tain baganor maze faḳanit aira. Teu Adom ar tan bou Mabud Allar samne na foṛar lagi baganor gasor aoṛe luḳaila. ");
INSERT INTO syll_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Mabud Allae Adomre ḍaḳ dia zikaila, “Tumi kuai?” ");
INSERT INTO syll_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Tain ḳoila, “Baganor maze ami tumar aoaz hunchi. Ami to lemṭa, erlagi ḍoraia lukai roisi.” ");
INSERT INTO syll_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Teu Mabud Allae zikaila, “Tumi ze lemṭa ḳe ḳoilo? Ze gasor fol ḳaite tumare na ḳorsilam, ḳailiso na kita?” ");
INSERT INTO syll_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Adome ḳoila, “Ze beṭimanush tumi amar loge diso, tai ou gasor fol amare ḳaoaise.” ");
INSERT INTO syll_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ou Mabud Allae beṭire zikaila, “Tumi ita kita ḳorlae?” Tain ḳoila, “Hafe amare salla dia ḳaoaise.” ");
INSERT INTO syll_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Teu Mabud Allae hafre ḳoila, “Tumar i kamor lagi hoḳol fala heman ar hoḳol zongli zanuaror maze tumi-u lannoti oilae. Tumi zindegibor feṭo bordi solbae ar dula-balu ḳaibae. ");
INSERT INTO syll_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ami tumar ar beṭir maze, tumar bongsho ar beṭi manshor bongshor maze dushmoni foyda ḳormu. Hi bongshe tumar ḳolla guṛa ḳorbo, ar tumi tar faor murat ḳamṛaibae.” ");
INSERT INTO syll_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ar tain beṭire ḳoila, “Tumar hurutta oibar shomoy tumar mosibot kub baṛai dimu, tumi kub ḳoshṭo ḳoria hurutta foyda ḳorbae. Zamair bae tumar kub ḳaish taḳbo, ar he tumar ufre beṭagiri korbo.” ");
INSERT INTO syll_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Tain Adomre ḳoila, “Ze gasor fol ami haram ḳoria dislam, tumi tumar bour ḳota hunia ita ḳaiso, ou ḳarone zominre lannoti kora oilo. Zindegibor zobor toklif ḳoria tumi zominor foshol ḳaibae. ");
INSERT INTO syll_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Tumar lagi maṭir maze ḳaṭa-gosa ar bishala zongol zonmaibo, ar tumar ḳani oibo ou maṭir foy-foshol. ");
INSERT INTO syll_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ze maṭi taki tumare foyda ḳorslam, hou maṭit firia na zaoa forzonto tumar matar gam faot falaia ḳani kaibae. Tumar maṭir shoril, maṭit-u mishizibo.” ");
INSERT INTO syll_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adome tan bibir nam raḳla Haoa mani, zindegi-deora, ḳaron tain hoḳol zinda manshor ma oiba. ");
INSERT INTO syll_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Adom ar tan bibir lagi Mabud Allae zanuaror samṛadi lebas banaia findaila. ");
INSERT INTO syll_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Erbade Mabud Allae ḳoila, “Deḳo, neki-bodir aḳol faia manush amrar laḳan oigese, oḳon he zate at baṛaia zindegi-gasor fol ḳaia hamesha zinda na roy.” ");
INSERT INTO syll_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ou ḳota ḳoia Mabud Allae ze maṭi dia manshore foyda ḳorsla, hou maṭit ḳet-ḳamar ḳorar lagi tare Adan bagan taki kedai dila. ");
INSERT INTO syll_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ḳedai dia tain zindegi-gasor gese zaoar fot fara deoar lagi Adan baganor fubedi Karubi firista oḳol raḳla ar aguinor toluaro guranit raḳla. ");
INSERT INTO syll_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adome tan bibi Haoar loge milar bade tan feṭo hurutta ailo, ar Kabil name tan eḳ fuar zonom oilo. Teu Bibi Haoae ḳoila, “Mabudor ges tone ami eḳ manush kobul ḳorsi.” ");
INSERT INTO syll_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Hirbar tan goro Kabilor bai Habilor zonom oilo. Habile sagol-meṛa raḳto, ar Kabile ḳet ḳorto. ");
INSERT INTO syll_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Bade eḳdin Kabile Mabudor gese tar ḳetor foy-foshol ania lilla dilo ");
INSERT INTO syll_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ar Habile-o tar falor maze foyla zonmise oula ḳoyṭa sagol-meṛa zobo ḳoria sorbiala ongsho lilla dilo. Mabude Habil ar tar lilla kobul ḳorla, ");
INSERT INTO syll_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Kabil ar tar lilla kobul ḳorla na, gotike he kub gusa ḳoria muk kala ḳorlo. ");
INSERT INTO syll_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Mabude Kabilre ḳoila, “Tumi gusa ḳorrae ḳene, ar kitar lagi tumi muk kala ḳorso? ");
INSERT INTO syll_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Tumi bala ḳam ḳorle tumar muk for oilo one? Ar na ḳorle to gunae tumare dorar lagi tumar duaro ubai roise. Igur ufre tumi zitte oibo.” ");
INSERT INTO syll_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Bade Kabile tar bai Habilre ḍakia ḳoilo, “Ao amra bondo zai.” Ar bondo gia tar bai Habilor ufre aḳta hamla ḳoria kun ḳorlo. ");
INSERT INTO syll_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Heshe Mabude Kabilre zikaila, “Tumar bai kuai?” Kabile ḳoilo, “Ami zani na, amar baire ami deḳa-huna ḳori ni?” ");
INSERT INTO syll_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Teu Mabude ḳoila, “Tumi ita kita ḳorlae? Deḳo, zomin taki tumar bair loue amar gese foriad ḳorer. ");
INSERT INTO syll_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Zomine zebla tumar ḳarone tumar bair lou ḳailo, ou shomoy tumi lannoti oia zomin taki kedail oilae. ");
INSERT INTO syll_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Tumi zebla zomino ḳet ḳorbae, zomine ar tumare foshol dito nae. Tumi boitol oia duniai zuṛi gurbae.” ");
INSERT INTO syll_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Teu Kabile Mabudre ḳoilo, “I shasti amar angaz oito nae. ");
INSERT INTO syll_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Aiz tumi amare zomin taki kedai dirae, ami tumar samne tone hori zaimugi. Ar boitol oia zebla ami duniait gurmu, ou shomoy zar samne-u ami foṛmu, he-u amare kun ḳorbo.” ");
INSERT INTO syll_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Mabude tare ḳoila, “Te tumare ze kun ḳorbo, tar ufre ami shatgun bodla loimu.” Ou ḳota ḳoia Mabude Kabilre eḳṭa sinnot dila, zate ḳeu tare ato faia-o na mare. ");
INSERT INTO syll_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Erbade Kabil Mabudor samon taki horia Adanor fubedi Nud mani, gura-fira desho gelogi. ");
INSERT INTO syll_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ar Kabil tar bour loge milae tair feṭo hurutta ailo, ar Honukor zonom oilo. Kabile eḳṭa ṭaun banaia tar fuar name ṭaunor nam raḳlo Honuk. ");
INSERT INTO syll_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Honukor fua Irod, Irodor fua Mohuayel, Mohuayelor fua Motushayel, Motushayelor fua Lemoḳ. ");
INSERT INTO syll_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemoḳe dui bia ḳorsla, eḳ bour nam Ada, aroḳ bour nam Shilla. ");
INSERT INTO syll_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adar goro Zabolor zonom oilo, zara tambut taḳe ar foshu fale, ou Zabol tarar mul baf. ");
INSERT INTO syll_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Zabolor bair nam Zubol. Zara bashi ar bin bazae, ou Zubol tarar mul baf. ");
INSERT INTO syll_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Shillar feṭo Tubol-Kabilor zonom oilo. Fitol ar luar atiar banani asil tar ḳam. Tar boinor nam Nayema. ");
INSERT INTO syll_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Eḳdin Lemoḳe tar dui boure ḳoilo, “O Ada ar Shilla, amar ḳota hun, Lemoḳor bibin, amar ḳotae deo ḳan. Ze beṭae amare ḳorilo zoḳom, ze beṭae amar gat tullo at, here ami korilam nifat. ");
INSERT INTO syll_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kabilor kunor bodla zudi shat gun oy, Lemoḳor bodla shatottoir gun nichchoy.” ");
INSERT INTO syll_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ermaze Adome hirbar tan bour loge milae, tan feṭo aroḳ fua oilo, Haoae tar nam raḳla Shish. Tain ḳoila, “Kabile Habilre kun ḳorse ḳori Allae Habilor bodla amare eḳ serag zugai disoin.” ");
INSERT INTO syll_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Bade Shishor-o eḳ fua oilo, he tar nam raḳlo Anush, ou shomoy tone manshe Mabudor nam loa shuru ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ita oilo Adomor ḳandanor ḳolombondi boyan. Manush foyda ḳorar shomoy Allae tan nizor surote foyda ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Foyda ḳorla beṭa ar beṭi, ar tarare Mabude borkot dila, foyda ḳoria nam raḳla Adom. ");
INSERT INTO syll_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adomor eḳ-sho tish boros boyosho tan loge mil rakia tan surote eḳ fua oilo. Tain er nam raḳla Shish. ");
INSERT INTO syll_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Shishor zonmor bade Adom aro aṭ-sho boros basla, er maze tan aro fua-fuṛin oisil. ");
INSERT INTO syll_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Muṭ noy-sho tish boros zinda taḳar bade Adom mara gela. ");
INSERT INTO syll_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Shishor eḳ-sho fas boros boyosho tan fua Anushor zonom oilo. ");
INSERT INTO syll_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Anushor zonmor bade Shish aro aṭ-sho shat boros basla. Er maze tan aro fua-fuṛi oisil. ");
INSERT INTO syll_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Muṭ noy-sho baro boros basar bade Shish mara gela. ");
INSERT INTO syll_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Anushor nobboi boros boyosho tan fua Kinanor zonom oilo. ");
INSERT INTO syll_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kinanor zonmor bade Anush aro aṭ-sho fonro boros basla. Er maze tan aro fua-fuṛi oisil. ");
INSERT INTO syll_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Muṭ noy-sho fas boros basar bade Anush mara gela. ");
INSERT INTO syll_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kinanor shottoir boros boyosho tan fua Maholailor zonom oilo. ");
INSERT INTO syll_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Maholailor zonmor bade Kinan aro aṭ-sho sallish boros basla. Er maze tan aro fua-fuṛi oisil. ");
INSERT INTO syll_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Muṭ noy-sho dosh boros basar bade Kinan mara gela. ");
INSERT INTO syll_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Maholailor foyshoṭṭi boros boyosho tan fua Iaredor zonom oilo. ");
INSERT INTO syll_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Iaredor zonmor bade Maholail aro aṭ-sho tish boros basla. Er maze tan aro fua-fuṛi oisil. ");
INSERT INTO syll_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Muṭ aṭ-sho fosanobboi boros basar bade Maholail mara gela. ");
INSERT INTO syll_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Iaredor eḳ-sho bashoṭṭi boros boyosho tan fua Idrisor zonom oilo. ");
INSERT INTO syll_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Idrisor zonmor bade Iared aro aṭ-sho boros basla, er maze tan aro fua-fuṛi oisil. ");
INSERT INTO syll_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Muṭ noy-sho bashoṭṭi boros basar bade Iared mara gela. ");
INSERT INTO syll_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Idrisor foyshoṭṭi boros boyosho tan fua Matushalaḳor zonom oilo. ");
INSERT INTO syll_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Matushalaḳor zonmor bade tin-sho boros forzonto, Allar loge Idrisor ḳas didar asil. Er maze tan aro fua-fuṛi oisil. ");
INSERT INTO syll_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Idris muṭ tin-sho foyshoṭṭi boros duniait asla. ");
INSERT INTO syll_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Erbade tane ar deḳa gelo na. Allar loge tan ḳas didar asil gotike Allae tanre zinda halote nizor gese nilagi. ");
INSERT INTO syll_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matushalaḳor eḳ-sho shatashi boros boyosho tan fua Lamaḳor zonom oilo. ");
INSERT INTO syll_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lamaḳor zonmor bade Matushalaḳ aro shat-sho birashi boros basla. Er maze tan aro fua-fuṛi oisil. ");
INSERT INTO syll_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Muṭ noy-sho unushottoir boros basar bade Matushalaḳ mara gela. ");
INSERT INTO syll_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamaḳor eḳ-sho birashi boros boyosho tan eḳ fua oilo. ");
INSERT INTO syll_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Tain er nam raḳla Nuh ar ḳoila, “He amrar ator i duḳ-mosibotor ḳam taki, Mabudor lannoti zomin taki oḳon aram dibo.” ");
INSERT INTO syll_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nuhor zonmor bade Lamaḳ aro fas-sho fosanobboi boros basla, er maze tan aro fua-fuṛi oisil. ");
INSERT INTO syll_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Muṭ shat-sho shatottoir boros basar bade Lamaḳ mara gela. ");
INSERT INTO syll_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuhor fas-sho boros boyoshor bade tan fuain Sham, Ham ar Iafetor zonom oilo. ");
INSERT INTO syll_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Duniar ufre zebla manush baṛa arombo oilo, ar bout fuṛintor-o zonom oilo, ");
INSERT INTO syll_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","teu gaibi shoktiala oḳole ou fuṛintore ḳubsurot dekia, ze zare kushi taire fosond ḳori nila. ");
INSERT INTO syll_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ita dekia Mabude ḳoila, “Amar ruhu hamesha manshor loge taḳto nae. Manush to ḳali gustor ḳaya, oḳon taki ami tarare eḳ-sho bish boros hayat diar.” ");
INSERT INTO syll_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ou fuṛintor loge hou gaibi shoktiala oḳlor mila-mishar ḳarone ze aolador zonom oilo, tara asla furana zomanar foyluan oḳol. Hi shomoy ba tar bade-o duniait Nefili zator manush asil. ");
INSERT INTO syll_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Mabude deḳla, duniait manshor naformani kub baṛi gese, ar tarar dilor ḳaish, kial-kushi kali karafir bae. ");
INSERT INTO syll_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ita dekia Mabude kub toklif faila, tain duniait manush foyda ḳorsila ḳori kub bezar oila. ");
INSERT INTO syll_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ar ḳoila, “Amar foyda ḳora manshore, ar tarar loge hoḳol zator zanuar, maṭit solra huru-muru zandar ar asmanor faki-o ḳotom ḳori dimu. Itare foyda ḳoria amar dilo duk lager.” ");
INSERT INTO syll_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Oile Nuhor ufre Mabud kushi asla. ");
INSERT INTO syll_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ita oilo Nuhor zindegir boyan. Nuh eḳzon kamil manush, tan amolor manshor maze tain-u asla fak-forezgar. Allar loge tanor ḳas didar asil. ");
INSERT INTO syll_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Sham, Ham ar Iafet namor tan tin fua asil. ");
INSERT INTO syll_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","I shomoy Allar sokut hara duniai gunae fosi gese ar zur-zulume bori gese. ");
INSERT INTO syll_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Allae duniar bae saia deḳla, ita gunae fosi gese. Ḳaron duniar manshor ḳaislot be-fote gesegi. ");
INSERT INTO syll_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ita dekia Allae Nuhre ḳoila, “Tamam manush zatre ami kotom ḳorilaitam ṭik korsi. Manshor lagi duniai zur-zulume bori gese. Manshor loge loge duniar hoḳolta ami shesh ḳorilitam. ");
INSERT INTO syll_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Tumi goforor toḳta dia tumar lagi ekkan zaz banao. Er bitre alga alga kuṭa taḳbo. Ar zazor bare-bitore alḳatra lagaio. ");
INSERT INTO syll_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Zazḳan lambae tin-sho at, fashe foinchash at ar ḳaṛa-ubi tish at banaio. ");
INSERT INTO syll_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ar salo taki eḳ at tole sairobae kiṛki raḳbae, ar duar dibae zazor ek kandat. Zazḳan titala banaio. ");
INSERT INTO syll_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Dekio, ami duniait ola boinna dimu, asmanor tole zoto zandare dom falae hoḳolta-u binash oizibo. Duniair hoḳol zandar-u morizibo. ");
INSERT INTO syll_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ḳali tumar loge amar oada zari raḳmu. Tumi gia zazo uṭbae, ar tumar loge tumar fuain, tumar bibi ar tumar fuaintor bou-o. ");
INSERT INTO syll_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ar zan basanir lagi tumi hoḳol zator zandaror beṭa-beṭir zuṛa milaia tumar loge zazo tulbae. ");
INSERT INTO syll_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Forteḳ zator faki, heman-zanuar ar maṭir maze buke solra zandarre basanir lagi zuṛa zuṛa ḳori tumar gese anbae. ");
INSERT INTO syll_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ar tumi hoḳol zator lagi kanir zinish zugaṛ ḳori raḳbae. Ita tumar ar tarar ḳani oibo.” ");
INSERT INTO syll_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuhe Allar hukum mafik hoḳolta-u ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ar Mabude Nuhre ḳoila, “Tumi ar tumar foribaror hoḳol aia zazo uṭbae. Ami dekiar i zomanar manshor maze tumi-u ḳali dindar. ");
INSERT INTO syll_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Tumi halal zanuar oḳol taki nor-medi milaia shat zuṛa ḳori ar haram zanuar taki eḳ zuṛa ḳori tumar loge loio. ");
INSERT INTO syll_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Asmano uṛra fakir maz taki nor-medi milaia shat zuṛa ḳori loio. Duniar maze erar bongsho basanir lagi ikan ḳorio. ");
INSERT INTO syll_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ami shat din bade duniair ufre sallish din sallish rait eḳlagare meg dimu, ar hoḳol zandarre dunia taki kotom ḳormu.” ");
INSERT INTO syll_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Mabudor hukum mafik Nuhe hoḳol ḳam ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Boinna shurur shomoy Nuhor boyosh asil soy-sho boros. ");
INSERT INTO syll_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Boinna taki basar lagi Nuh, tan bibi, tan fuain ar fuaintor boure loia zazo gia uṭla. ");
INSERT INTO syll_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Allar hukum mafik halal-haram zanuar, faki, buke solra zandaror nor-medi milia zuṛa zuṛa oia Nuhor gese aia zazo hamaila. ");
INSERT INTO syll_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ou shat din bade duniait boinna oilo. ");
INSERT INTO syll_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nuhor soy-sho bosoror shomoy dusra mashor shotro tarik fatalor hoḳol fani bar oito laglo, ar asman zenu faṭi gelo. ");
INSERT INTO syll_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Sallish din sallish rait duniair ufre meg oilo. ");
INSERT INTO syll_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Zedin meg shuru oilo, idin Nuh, tan bibi, tan fuain Sham, Ham, Iafet ar tarar bou oḳol-o zazo aia uṭla. ");
INSERT INTO syll_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Tarar loge zuṛa zuṛa ḳori hoḳol zator zongli zanuar, fala heman, maṭir maze buke solra zandar, faki ar ḍaḳna-ala hoḳolta-o uṭla. ");
INSERT INTO syll_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Dom falaia base ila hoḳol zator zandar Nuhor gese aia zazo uṭsil. ");
INSERT INTO syll_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Allar hukum mafik-u nor-medir zuṛa milia tara uṭsil. Erbade Mabude zazor duar bond ḳori dila. ");
INSERT INTO syll_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Sallish din dori duniait fani baṛte-u taḳlo. Fani baṛi zaoae zazḳan maṭi taki ufre baia uṭlo. ");
INSERT INTO syll_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Bade fani kub baṛlo ar zazḳan fanir ufre solasol ḳorlo. ");
INSERT INTO syll_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ar fani baṛte-u taḳlo. Erlagi zeno zoto boṛo boṛo faṛ asil, hokkolta buṛi gelo. ");
INSERT INTO syll_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Hoḳol faṛ-forbot buṛia fani aro fonro at ufre uṭlo. ");
INSERT INTO syll_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ar duniait solra hoḳol zandar, mani faki, fala heman, zongli zanuar ar fal bandia gurra hoḳolta, manshor loge binash oigelo. ");
INSERT INTO syll_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Maṭir ufre zoto roḳomor zoto zandar dom falaia base ita hoḳolta-u morigelo. ");
INSERT INTO syll_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Allae ou nomunae zominor hoḳol zandar duniair ufor taki fusilaila. Ete manush, zanuar, buke solra zandar ar asmanor faki duniai taki saf oigelo. Ḳali Nuh ar tan loge zara asil, tara-u basia roila. ");
INSERT INTO syll_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Dunia deṛ-sho din fanit buṛail roilo. ");
INSERT INTO syll_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Zazo Nuh ar tan loge zoto zandar ar fala heman asil, Allae tarar ḳota-o faurila na. Tain duniait batash salaile fani koma shuru oilo. ");
INSERT INTO syll_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Maṭir tol taki fani baroni ar asman tone meg foṛar faṭa bond oigelo, ar meg-o dom loilo. ");
INSERT INTO syll_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Maṭir ufror fani hori gelo, ar deṛ-sho din bade deḳa gelo fani bout ḳomse. ");
INSERT INTO syll_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Shat nombor mashor shotro tarik zazḳan Ararator faṛi elaḳat gia aṭkilo. ");
INSERT INTO syll_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Erbade-o fani komat taḳlo, ar dosh nombor mashor foyla din faṛ oḳlor mata deḳa gelo. ");
INSERT INTO syll_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Er sallish din bade Nuhe zazor kiṛki kulla. ");
INSERT INTO syll_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ar kiṛkibae ek kaua saṛla. Maṭi taki fani na hukani forzonto ḳauaṭa aoa-zaoat roilo. ");
INSERT INTO syll_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Maṭir ufor tone fani komse ki na deḳar lagi Nuhe bade eḳṭa faro saṛla. ");
INSERT INTO syll_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","I shomoy-o asta duniait fani asil ḳori fao toibar zaga na faia faroṭa hirbar firia ailo. Tain at baṛaia tare bitre anla. ");
INSERT INTO syll_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Heshe tain aro shat din bar saia hirbar tare saṛla. ");
INSERT INTO syll_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Hainja bala he tan gese firia ailo, ar tar ṭuṭo asil zoytun gasor hazma fata, tain buzla maṭir ufor taki fani komi gese. ");
INSERT INTO syll_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Aro shat din bade tain hirbar faroṭa saṛla, ikṭa ar firia ailo na. ");
INSERT INTO syll_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nuhor boyosh soy-sho eḳ bosoror shomoy foyla mashor foyla din maṭir ufor taki fani hori gelo, ar Nuhe zazor sal kulia saia deḳla, maṭi hukani dorse. ");
INSERT INTO syll_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Dusra mashor shataish dinor din maṭi eḳoibare hukai gelo. ");
INSERT INTO syll_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Allae tanre ḳoila, ");
INSERT INTO syll_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Tumi tumar bibi, tumar fuain ar tumar fuaintor boure loia zaz taki bar oia ao. ");
INSERT INTO syll_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ar tumar loge zoto zator zandar ase - faki, zanuar ar maṭir maze buke solra zandar - tarare-o bar ḳori loia ao, zenu hara duniai zuṛi tara sitria gia folala oia baṛe.” ");
INSERT INTO syll_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Teu Nuhe, tan bibi, tan fuain ar tarar boure loia zaz taki bar oila. ");
INSERT INTO syll_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Tarar loge duniair hoḳol zanuar, maṭit solra huru-muru zandar, ar faki, ek kotae duniait solra hoḳol zandar, zarzir zatmoto bar oilo. ");
INSERT INTO syll_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Bade Nuhe Mabudor name ekkan kurbani kana banaila, ar forteḳ zator halal foshu-faki taki eḳ eḳṭa loia zobo ḳoria, zalaia kurbani dila. ");
INSERT INTO syll_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Mabud i kurbanir dumar gerane kushi oila, ar tain ḳoila, “Manshor lagi ami ar kunu shomoy-o maṭire lannot ditam nae, zudio hurubala taki-u manshor monor kial ḳarafir bae taḳe. Ifira zela hoḳol zandarre marsi, ilaḳan ar kunu din-u martam nae. ");
INSERT INTO syll_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Zotodin i duniai taḳbo, otodin niommoto bis falani ar foshol ḳaṭa, ṭanḍa ar gorom, barisha ar eot, din ar rait solte-u taḳbo.” ");
INSERT INTO syll_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Allae Nuh ar tan fuaintore borkot dia ḳoila, “Tumitain folala oia baṛia duniai bori zao. ");
INSERT INTO syll_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Duniair zanuar, asmanor faki, maṭir maze buke solra zandar ar doriar mas, hoḳole-u tumrare ḍor-boy ḳori solbo. Itare tumrar ato deoa oilo. ");
INSERT INTO syll_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Zela tumrare ḳetor fol-foshol ar tori-torḳari dislam, oula oḳon zita zandar hoḳolre-o tumrar ḳanir lagi dilam. ");
INSERT INTO syll_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ḳali lou shoho gust tumra ḳaio na, lou oilogi zan. ");
INSERT INTO syll_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ḳeu zudi manshore kun ḳore te ami oboshsho-u tar kunor bodla loimu. He zanuar ouk ba manush ouk, manshor zan ze ney, tar zan-o deon lagbo. ");
INSERT INTO syll_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Manshor lou ze bar ḳore, manshe-o tar lou bar ḳorbo, ḳaron Allae manshore nizor surote banaisoin. ");
INSERT INTO syll_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Tumitain besh ḳori folala oia baṛo ar duniait sitria zao.” ");
INSERT INTO syll_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Bade Allae Nuh ar tan fuaintore ḳoila, ");
INSERT INTO syll_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Huno, ami zoban diar, tumra ar tumrar bador hoḳol manshore, ");
INSERT INTO syll_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ar faki, fala heman ar duniair zoto zanuar tumrar loge zaz taki bar oise, tarare-o. ");
INSERT INTO syll_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Zobanṭa oilo, banor fani dia ar kunu shomoy-u hokkol zandarre mara oito nae, ar tamam duniai saf ḳorar lagi ila kunu ban-o oito nae.” ");
INSERT INTO syll_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Allae aro ḳoila, “Ze zoban ami tumrare ar tumrar logor zandar oḳolre dilam, ikṭa kiamot forzonto boail roibo. ");
INSERT INTO syll_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ar megor ḳalnir maze amar rongdenu dilam, ikṭa oilo duniait amar zobanor nishana. ");
INSERT INTO syll_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Zebla ami duniair ufre ḳalni dimu, i shomoy ou rongdenu deḳbae. ");
INSERT INTO syll_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Ar ou shomoy-u ami tumrar ar hoḳol zandaror loge amar zobanor ḳota iad ḳormu. Ar kunu shomoy-u boinna oia hoḳol zandarre fani dia doia nito nae. ");
INSERT INTO syll_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ḳalnir maze zebla hi rongdenu deḳa zaibo ou shomoy ami duniair hoḳol zandaror loge amar i hameshakur zobanor ḳota iad ḳormu.” ");
INSERT INTO syll_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Heshe Allae Nuhre ḳoila, “Duniair hoḳol zandaror loge ami ze zoban disi, ikṭa oilo tar nishana.” ");
INSERT INTO syll_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Zaz tone Nuhor ze fuain bar oisla, tarar nam oilo Sham, Ham ar Iafet. Ou Ham oilo Kenanor baf. ");
INSERT INTO syll_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nuhor ou tino fuar ḳandan oḳol hara duniait sitri gela. ");
INSERT INTO syll_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuhe ḳet-ḳamar shuru ḳoria eḳ angur ḳet ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ar anguror shorab ḳaia ṭal oia tambur bitre udam oia foṛi roila. ");
INSERT INTO syll_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kenanor baf Hame aia tar bafor ou hal dekia bare gia tar duio bair gese ḳoilo. ");
INSERT INTO syll_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Oile Sham ar Iafete ḳando ḳori ekkan ḳafoṛ loia fise aṭia bafre ou ḳafoṛdi guria dila, tarar souk ulṭabae taḳae bafre be-abru halote deḳla na. ");
INSERT INTO syll_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nisha ḳomi zaoar bade Nuhe tan fuar ḳanḍo hunia ");
INSERT INTO syll_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ḳoila, “Kenanor ufre lannot foṛouk, he tar baiaintor gese gulamor gulam oibo.” ");
INSERT INTO syll_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Tain aro ḳoila, “Hoḳol tarif Shamor Mabud Allar, Kenan Shamor gulam ouk. ");
INSERT INTO syll_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Allae Iafetre boutta deukka, he Shamor tambut taḳouk, ar Kenan tar gulam ouk.” ");
INSERT INTO syll_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Banor bade Nuh aro shaṛe tin-sho boros basla. ");
INSERT INTO syll_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Muṭ shaṛe noy-sho boros boyosho tain mara gela. ");
INSERT INTO syll_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nuhor fuain Sham, Ham, ar Iafetor ḳandanor boyan. Banor bade tarar fua-fuṛi oisla. ");
INSERT INTO syll_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Iafetor fuaintor nam: Gumor, Mazuz, Madoy, Iaban, Tubol, Meshok ar Tirosh. ");
INSERT INTO syll_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gumoror fuain: Oskinosh, Rifot ar Tugormo. ");
INSERT INTO syll_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Iabanor fuain oila: Ilishah, Torshish, Kittim ar Rudanim. ");
INSERT INTO syll_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Erar bongshor manshe nanan zator mat-ḳota, foribar ar zat hishabe doriar faror nanan desho sitri gela. ");
INSERT INTO syll_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hamor fuaintor nam: Kush, Mishor, Puṭ ar Kenan. ");
INSERT INTO syll_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kushor fuain: Soba, Hobila, Softa, Royma ar Softoḳa. Roymar fuain oila: Shaba ar Dodan. ");
INSERT INTO syll_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kushor eḳ fuar nam asil Nomrud. Ou Nomrud duniait foyluan oia uṭsil. ");
INSERT INTO syll_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Mabudor gese he asil foyluan shikari. Erlagi ḍaḳor ḳota ase, manushṭa zen Mabudor samne Nomrudor laḳan foyluan shikari. ");
INSERT INTO syll_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Shinar deshor Babil, Eroḳ, Okkod ar Kolni namor ṭaun oḳol loia he bashshai shuru ḳorlo. ");
INSERT INTO syll_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","On taki tar raijjo baṛia Ashiria desh forzonto gelo. Hoḳanor Ninob, Rohobotpur, Keloh ");
INSERT INTO syll_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ar Reshon namor ṭaun oḳol-o tar banail. Reshon asil Ninob ar Kelohor mazḳano, i tinṭae milia eḳ biraṭ shohor oilo. ");
INSERT INTO syll_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mishoror bongsho oila ou zat oḳol: Ludi, Onami, Lohabi, Noftuhi, ");
INSERT INTO syll_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Fotrushi, Kosluhi, ar Kofturi, ou Koftur dif taki Filistini oḳol bar oia aila. ");
INSERT INTO syll_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kenanor boṛo fua Sidon, bador fua Hiṭ, Hiṭṭi zatir mul baf. ");
INSERT INTO syll_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kenan asla Zibuzi, Amuri, Girgashi, ");
INSERT INTO syll_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hibbi, Arki, Sini, ");
INSERT INTO syll_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arbadi, Zomari ar Hamati, ou zati oḳlor mul baf. Heshe ou Kenani oḳol sairobae sitri gesla. ");
INSERT INTO syll_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Sidon ṭaun taki Geraror muka Gaza forzonto, ar Gaza taki Sadum, Amura, Odma ar Soboyim zaoar fote Lasha forzonto Kenani oḳlor razotto asil. ");
INSERT INTO syll_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Foribar, mat-ḳota, desh ar zat hishabe era asil Hamor ḳandan. ");
INSERT INTO syll_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Iafetor boṛo bai Shamor-o fua-fuṛin oisla. Sham oila Aber ar tar ḳandanor baf. ");
INSERT INTO syll_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Shamor fuaintor nam: Ilam, Ashur, Arfaksad, Lud ar Oram. ");
INSERT INTO syll_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Oramor fuain: Uz, Hul, Getor ar Mosh. ");
INSERT INTO syll_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaksador fua Shaleḳ, ar Shaleḳor fuar nam Aber. ");
INSERT INTO syll_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Aberor dui fua oisla, eḳzonor nam Falez mani, alga, tan shomoy dunia alog oisil ḳori tan ou nam oilo. Falezor bair nam Iaktan. ");
INSERT INTO syll_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Iaktanor fuain oila: Olmudod, Shelof, Hazramaot, Zeroh, ");
INSERT INTO syll_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hoduram, Uzal, Dikla, ");
INSERT INTO syll_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obol, Obimayel, Shaba, ");
INSERT INTO syll_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hobila ar Zubob. Era hoḳol oila Iaktanor fuain. ");
INSERT INTO syll_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Mesha taki fubedi Sefaro zaoar foto ze faṛi zaga ase, ono tara taḳta. ");
INSERT INTO syll_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Foribar, mat-ḳota, desh, ar zat hishabe era oila Shamor ḳandan. ");
INSERT INTO syll_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Zat ar bongsho hishabe era oilo Nuhor fuaintor foribar. Banor bade erar bongsho oḳole nanan zat oia asta duniait sitri gesla. ");
INSERT INTO syll_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Hi zomanat asta duniait ḳali eḳ bashae matta, ar tarar buli oḳol-o eḳlaḳan-u asil. ");
INSERT INTO syll_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Tara fubedi aguaia zaite zaite Shinar deshor eḳ homan zaga faia hoḳano-u boshot ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Tara eḳe-oinnore ḳoilo, “Ao, amra iṭ banaia aguindi zalai.” Ḳoia-u tara fattoror bodla iṭ ar sun-shurkir bodla tartel lagailo. ");
INSERT INTO syll_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Tara aro ḳoilo, “Ao, amrar nizor lagi eḳṭa shohor banai, ar oula eḳṭa gor-o banai, zeḳṭar minar gia asman lagal faibo. Teu amrar nam-o oibo ar amra duniait sitritam-o nae.” ");
INSERT INTO syll_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Manshe ze usa gor ar shohor banaira ikṭa deḳat Mabud lami aila. ");
INSERT INTO syll_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ar ḳoila, “Era eḳ zator manush, erar mat-ḳota-o eḳ; erlagi tara ou ḳamor maze at dise. Nizor motlob hasilor lagi era ar kunu bada-u manto nae. ");
INSERT INTO syll_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Te ao, amra lamia gia tarar bulir maze gulmal lagai dei, zate tara eḳzone aroḳzonor mat buzto na fare.” ");
INSERT INTO syll_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Erbade Mabude hou zaga taki tarare asta duniait sitrai dila. Ar tarar hou shohor bananir ḳam-o bond oigelo. ");
INSERT INTO syll_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ou ḳarone hou zagar nam oilo Babil mani, gulmal, hoḳano-u Mabude hara duniair bulir maze gulmal lagai disla. Hoḳan taki-u tain tarare asta duniait sitrailila. ");
INSERT INTO syll_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ou oilo Shamor ḳandanor boyan. Banor dui boros bade Shamor boyosh zebla eḳ-sho boros, ou shomoy tan fua Arfaksador zonom oilo. ");
INSERT INTO syll_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arfaksador zonmor bade Sham aro fas-sho boros basia asla. Er maze tan aro fua-fuṛin oisla. ");
INSERT INTO syll_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaksador faytish bosoror shomoy tan fua Shaleḳor zonom oilo. ");
INSERT INTO syll_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Shaleḳor zonmor bade tain aro sair-sho tin boros basia asla. Er maze tan aro fua-fuṛi oisla. ");
INSERT INTO syll_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shaleḳor tish boros boyoshor shomoy tan fua Aberor zonom oilo. ");
INSERT INTO syll_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Aberor zonmor bade Shaleḳ aro sair-sho tin boros basia asla. Er maze tan aro fua-fuṛi oisla. ");
INSERT INTO syll_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Aberor soutish bosoror shomoy tan fua Falezor zonom oilo. ");
INSERT INTO syll_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Falezor zonmor bade Aber aro sair-sho tish boros basia asla. Er maze tan aro fua-fuṛi oisla. ");
INSERT INTO syll_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Falezor tish boros boyoshor shomoy tan fua Raur zonom oilo. ");
INSERT INTO syll_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Raur zonmor bade Falez aro dui-sho noy boros basia asla. Er maze tan aro fua-fuṛi oisla. ");
INSERT INTO syll_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Raur bottish bosoror shomoy tan fua Saruzor zonom oilo. ");
INSERT INTO syll_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Saruzor zonmor bade Rau aro dui-sho shat boros basia asla. Er maze tan aro fua-fuṛi oisla. ");
INSERT INTO syll_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Saruzor tish bosoror shomoy tan fua Nahuror zonom oilo. ");
INSERT INTO syll_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nahuror zonmor bade Saruz aro dui-sho boros basia asla. Er maze tan aro fua-fuṛi oisla. ");
INSERT INTO syll_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahuror untish bosoror shomoy tan fua Tareḳor zonom oilo. ");
INSERT INTO syll_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Tareḳor zonmor bade Nahur aro eḳ-sho unnish boros basia asla. Er maze tan aro fua-fuṛi oisla. ");
INSERT INTO syll_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tareḳor shottoir bosoror shomoy tan fuain Abram (tan bador nam Ibrahim), Nahur ar Haronor zonom oisil. ");
INSERT INTO syll_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ou oilo Tareḳor ḳandanor boyan. Tareḳor fuar nam asil Abram, Nahur ar Haron. Ar Haronor fuar nam Lut. ");
INSERT INTO syll_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haron tan baba zinda taḳte-u, tan zonom-maṭi Babil deshor Ur ṭauno mara gesla. ");
INSERT INTO syll_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram ar Nahur duizone bia ḳorsla. Abramor bour nam asil Sara. Ar Nahuror bour nam Milka. Milka ar Iska asla Haronor fuṛin. ");
INSERT INTO syll_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Oile Sarar kunu fua-fuṛi asil na, tain niaoladi asla. ");
INSERT INTO syll_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tareḳe Abram, Lut ar Sarare loia Kenan desho zaoar lagi Babil deshor Ur ṭaun taki roana oila. Abram oila Tareḳor fua, Haronor fua Lut oila Tareḳor nati, ar Sara oila Tareḳor fua Abramor bou. Foyla tara Haran name eḳ ṭauno gela ar hoḳano boshot ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tareḳ dui-sho fas boros boyosho Haran ṭauno mara gela. ");
INSERT INTO syll_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Bade Mabude Abramre formaila, “Tumi tumar nizor desh, ḳesh-kuṭum, ar babaiti biṭa-maṭi saṛia ami ze desh deḳaimu hou desho zao. ");
INSERT INTO syll_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Tumar maz taki ami bout boṛo eḳ zati foyda ḳormu. Tumare rohom-borkot dimu. Ami tumare boṛo ijjoti banaimu, ar tumar usillae asta duniar manshe rohom-borkot faiba. ");
INSERT INTO syll_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ar huno, tumare zara dua diba, ami Allae tarare rohom-borkot dimu, oile zara tumare boddua diba, ami tarare lannot dimu. Duniar hoḳol zatie tumar usillae rohom-borkot faiba.” ");
INSERT INTO syll_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Mabudor hukum moto-u Abram bar oigela, tan batiza Lut-o tan loge gela. Haran ṭaun falaia zaoar shomoy Abramor boyosh asil fosottoir boros. ");
INSERT INTO syll_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Tan bibi Sara ar batiza Lutre loia tain bar oila. Hoḳol mal-samana loia ar ze gulam oḳolre tain-tain Haran elaḳat faisla tarare loia Kenan desho zaita ḳori roana dila. Heshe hono gia fosla. ");
INSERT INTO syll_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Kenanor mazedi zaite zaite Abram Shikimo aia Murir elon gasor gese ziraila. I shomoy Kenani oḳol hou desho boshot ḳorta. ");
INSERT INTO syll_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Mabude Abramre doroshon dia ḳoila, i deshḳan ami tumar oarishre dilaimu. Abramre zein deḳa dila, hou Mabudor name tain hono ek kurbani kana banaila. ");
INSERT INTO syll_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Hon taki tain Betel ṭaunor fubedi faṛi elaḳat aguai gela, gia foisme Betel fube Oy ṭaunor mazḳano tain tambu gaṛila. Mabudor name tain ino ek kurbani kana banaila ar Mabudor nam loila. ");
INSERT INTO syll_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Bade tain hin taki horte horte Negeb namor douknor morubumir baedi gelagi. ");
INSERT INTO syll_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","I shomoy Kenan desho nidan deḳa dilo. I nidan kub ḳoṭin oae, Abrame musafir oia Mishor desho gelagi. ");
INSERT INTO syll_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Mishoror ḳandat aia Abrame tan bibi Sarare ḳoila, “Huno, ami zani tumi kub shundori. ");
INSERT INTO syll_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Tumi zebla Mishori oḳlor souko foṛbae, teu tara buzbo tumi amar bou, ar tumare rakia amare kun ḳorilibo. ");
INSERT INTO syll_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Erlagi koio, tumi amar boin. Ete tumar lagi amar bala oibo, ar amare basaia raḳbo.” ");
INSERT INTO syll_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abram Mishoro aia harle Mishoror manshe deḳla Sara kub shundori. ");
INSERT INTO syll_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Mishoror bashsha Feraunor guia oḳole tane dekia Feraunor gese gia tan tarif ḳoria boutta ḳoila. Ar Sarare razbaṛir bitre neoa oilo. ");
INSERT INTO syll_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Sarar lagi Feraune Abramre maya ḳorta lagla. Tain Abramre bout goru-sagol, gada-gadi, uṭ, ar bandi-gulam ufohar dila. ");
INSERT INTO syll_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Oile Bibi Sarar lagi Mabude Feraun ar tar baṛir hoḳol manshor maze besheba bemar foyda ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Teu Feraune Abramre nia zikaila, “Afne amar loge ita kita ḳorla? Tanre ḳene afnar bou na ḳoia ");
INSERT INTO syll_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","boin ḳoila? Ar ami to tanre bia ḳorar lagi neoaislam. Ein to afnar bibi, ene loia afne in taki hori zaukkagi.” ");
INSERT INTO syll_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ou ḳota ḳoia Feraune tan manshore hukum ḳorla, ar tara Abramor hoḳol mal-samana shoho tane ar tan bibire bidae ḳori dila. ");
INSERT INTO syll_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Teu Abram ar tan bibie hoḳolta loia Mishor desh falaia Negeb morubumit gelagi, Lut-o tan loge asla. ");
INSERT INTO syll_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram kub doni asla, tan bout heman-zanuar ar shuna-rufa asil. ");
INSERT INTO syll_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Bade tain Negeb taki horte horte Betel forzonto gela. Gia tain Betel ar Oy ṭaunor mazḳano fosla, ze zagat tain age tambu gaṛisla ");
INSERT INTO syll_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ar foyla kurbani kana banaisla. Ono gia tain hirbar Mabudor nam loila. ");
INSERT INTO syll_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Abramor loge musafir asla tan batiza Lut, en-o bout goru-sagol ar tambu asil. ");
INSERT INTO syll_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Oile zagaṭa ila asil na zen, duiozonor foshur fale eḳloge ḳaita farba. Goru-sagol ar tambu oto beshi asil zen, ita loia tarar taḳar ufae asil na. ");
INSERT INTO syll_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Erlagi Abram ar Lutor raḳal oḳole hamesha dorbar-ḳaijja ḳorta. Ar hi shomoy Kenani ar Farizi oḳol-o hi desho boshot ḳorto. ");
INSERT INTO syll_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Teu Abrame Lutre ḳoila, “Huno, amra to duiozon-u afon. Te tumar-amar maze ar tumar-amar raḳalor maze-o dorbar-ḳaijja ḳora ṭik nae. ");
INSERT INTO syll_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Hara deshṭa-u tumar samne foṛi roise. Te ao, amra alga oizai. Tumi baue fosond ḳorle, ami ḍaine, ar tumi ḍaine gele, ami baue zaimu.” ");
INSERT INTO syll_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lute saia deḳla, Zordan gangor tʼol zagar hoḳol bae Suar gau forzonto bout fani ase, Mabudor bagisa ba Mishor deshor laḳan i zaga-o gash-fani ala. Ou shomoy-o Mabude Sadum ar Amura ṭaun binash ḳorsoin na. ");
INSERT INTO syll_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Erlagi Lute Zordan gangor hoḳol tʼol zaga nizor lagi basia fubedi horia gelagi. Oula tara alga oigela. ");
INSERT INTO syll_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram Kenan desho roila, ar Lut hou tʼol zominor ṭaun oḳlor ḳasat gia boshot ḳorla. Tain Sadum ṭaunor kinaro tambu gaṛilla. ");
INSERT INTO syll_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sadumor manush oḳol kub ḳobis asil, Mabudor nozoro tara betaya gunagar. ");
INSERT INTO syll_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lut alga oar bade Mabude Abramre ḳoila, “Tumi ze zagat ubaiso, ikan taki utore-douḳne, fube-foisme eḳbar saia deḳo. ");
INSERT INTO syll_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ze zaga oḳol tumi deḳrae, ita ami tumare ar tumar oarish oḳolre hameshakur lagi dilaimu. ");
INSERT INTO syll_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ami tumar oarishre duniair duil-balur laḳan behishab ḳormu. Duniar duil-balu zudi keu gonia fuṛaito fare, te tumar oarishre-o gonto farbo. ");
INSERT INTO syll_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Uṭo, asta deshṭa tumi eḳbar guria ao, ou desh-u ami tumare dimu.” ");
INSERT INTO syll_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Teu Abrame tan tambu tulia, Hebron elaḳat Momrir elon bonor ḳandat nia gaṛila. Hoḳano tain Mabudor lagi kurbani kana banaila. ");
INSERT INTO syll_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Babil deshor bashsha Omrafel, Illashoror bashsha Ariak, Ilamor bashsha Ḳodor-laumor ar Guimor bashsha Tidiol, era sairozone eḳ oia ");
INSERT INTO syll_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Sadumor bashsha Bira, Amurar bashsha Birsha, Odmar bashsha Shinab, Soboyimor bashsha Shimebor ar Bilar ba Suaror bashshar birudde zuddo ḳorat gela. ");
INSERT INTO syll_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ou faszon bashshae tarar sifai oḳolre ekḳano ḳoria Siddimor tol zagat loia gela. I zagare Luna shagor ḳoin. ");
INSERT INTO syll_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Hi bashsha oḳole baro boros bashsha Ḳodor-laumoror gulami koria tero bosoror shomoy bidruho ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Er bador boros bashsha Ḳodor-laumor ar tan logor bashsha oḳole gia Ostorut-Kornoyimo Rofayi oḳolre, Homo gia Zuzi oḳolre, ar Shabi-Kiriataimo gia Eimi oḳolre araila. ");
INSERT INTO syll_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Bade morubumir ḳasar El-Faron forzonto Seir faṛor Hurio oḳolre-o araila. ");
INSERT INTO syll_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Heshe ou bashsha oḳole guria gia Oin-Mishpoṭo ba Kadesh gela. Tara Amaleki oḳlor asta desh doḳol ḳorla ar Hazazon-Tamar ṭauno ze Amuri oḳol asil tarare-o doḳol ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Bade Sadum, Amura, Odma, Soboyim ar Bila ba Suaror bashsha oḳole ");
INSERT INTO syll_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Ilamor bashsha Ḳodor-laumor, Guimor bashsha Tidiol, Babilor bashsha Omrafel ar Illashoror bashsha Ariakor loge zuddo ḳorar lagi Siddim namor tol zagat tarar sifai oḳol hazaila. Sair bashshar birudde fas bashshae lagla. ");
INSERT INTO syll_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Siddimor tol zagat tartelor bout gat-gaṛa asil. Sadum ar Amurar bashshain zebla bagia zaira, i shomoy tarar logor ḳeu ḳeu ou tartelor gato foṛi gela, ar baki oḳole bagia faṛo gela. ");
INSERT INTO syll_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Teu tarar dushmon oḳole Sadum-Amurar hoḳol don-samana ar ḳani-danir hoḳolta luṭia loia gelogi. ");
INSERT INTO syll_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ar tara Abramor batiza Lutor hoḳol mal-samana shudda hou Lutre-u doria loia gelagi, ḳaron eine-u Sadum ṭauno roita. ");
INSERT INTO syll_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Teu eḳzone bagia aia Ibrani Abramre ou ḳobor dilo. Abram i shomoy Amuri Momrir elon bonor ḳasat taḳta. I Momri asla Ashkul ar Aneror bai, Abramor loge erar zuddor shaijjor chukti asil. ");
INSERT INTO syll_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Tan batizare doria loia gesoingi hunia Abrame laṛai zanra nizor tin-sho aṭaro zon gulamre loia Dan ṭaun forzonto dushmonor ḳore ḳore gela. Ou gulam oḳol tan baṛit-u zonmisil. ");
INSERT INTO syll_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Raitkur bala dushmon dolor lagal faia era hamla ḳoria herare arailla, ar ḳedaite ḳedaite Damesk ṭaunor utore Huba forzonto gela. ");
INSERT INTO syll_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Luṭ ḳora hokkol zinish tain firaia anla, mal-samana shudda tan batiza Lutre-o uddar ḳorla. Er loge hoḳol beṭintore ar hoḳol manshore-o uddar ḳori anla. ");
INSERT INTO syll_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ḳodor-laumor ar tar logor bashsha oḳolre araia Abram firia aoar shomoy Sadumor bashshae tan loge deḳa ḳorar lagi Shabi ba Bashsha namor tol zagat bar oia aila. ");
INSERT INTO syll_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ar Shalemor bashsha Malki-Siddike Abramor lagi ruṭi ar anguror shorbot loia aila, tain oila Allatalar fosondor imam. ");
INSERT INTO syll_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Tain Abramre dua ḳoria ḳoila, “Zein asman ar zomin foyda ḳorsoin, hou Allatala Abramre borkot dan ḳoroukka. ");
INSERT INTO syll_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Afnar dushmon oḳolre zein afnar ato shofisoin, tan nam doinno ouk.” Ou Abrame tan hokkoltar doshbaṭor eḳbaṭ Malki-Siddikre dilaila. ");
INSERT INTO syll_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ar Sadumor bashshae Abramre ḳoila, “Afne mal-samana hoḳolta raki deukka, ḳali manush guin amare firot dilain.” ");
INSERT INTO syll_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abrame Sadumor bashshare ḳoila, “Zein asman-zomin foyda ḳorsoin hou Mabud Allatalar name ami at tulia ḳosom ḳorsi, ");
INSERT INTO syll_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","afnar kunu zinish-u, eḳsa suta-u ba faor zutar eḳsa fita-o ami nitam nae. Arnae bade afne ḳoiba, amar done-u Abram doni oise. ");
INSERT INTO syll_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Amar manshe zeta ḳailisoin ita saṛa ami ar kichchu nitam nae. Ḳali Aner, Ashkul ar Momri zera amar loge gesla, tarar faona baṭ tara neukkagi.” ");
INSERT INTO syll_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ota goṭona oḳlor bade ohir maze Mabudor kalam Abramor gese nazil oilo. Tain ḳoila, “O Abram, ḍoraio na, ami-u tumar hefazotkari, tumar bout boṛo furuskar.” ");
INSERT INTO syll_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abrame ḳoila, “O Mabud Moula, amare kita ditae? Ami to niaoladi. Ami morar bade Dameskor Eliezer amar shompottir malik oibo. ");
INSERT INTO syll_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Tumi to amare kunu aolad dilae na, erlagi amar baṛir gulam amar oarish oibo.” ");
INSERT INTO syll_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ou Mabude Abramre ḳoila, “Na, he nae, tumar nizor bour aolad-u tumar oarish oibo.” ");
INSERT INTO syll_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Mabude Abramre bare ania ḳoila, “Asmanor bae sao, ar farle ou tera oḳol gonia fuṛao, tumar bongshor oarish oula behishab oibo.” ");
INSERT INTO syll_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abrame Mabudor ou oadare ekin ḳorla, ar Mabude hou ekinre dindari kam hishabe kobul ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ar tain Abramre ḳoila, “Ami-u Mabud. I Kenan deshor odikari oibar lagi ami tumare Babil deshor Ur ṭaun taki bar ḳoria anchi.” ");
INSERT INTO syll_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ou Abrame ḳoila, “O Mabud Moula, ami itar malik oimu ḳori kila buzmu?” ");
INSERT INTO syll_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Tain ḳoila, “Tumi tin bosoror eḳṭa ḳori ḍeki, sagi, ar meṛar faṭa amar samne loia ao, er loge eḳṭa ḍufi faki ar eḳṭa faror baichcha-o anio.” ");
INSERT INTO syll_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abrame oula ḳorla. Tain ita hoḳolṭi ania dui ṭukra ḳoria ulṭa-ulṭi kori hazaia raḳla, ḳali faki oḳolre ṭukraila na. ");
INSERT INTO syll_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Teu hokun aia ou ṭukra oḳlor ufre foṛle, Abrame ḳedaila. ");
INSERT INTO syll_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Shuruz ḍubar shomoy Abramor eḳ beushi gum ailo. Gumor maze betaya ḍor ar andaire tane asor ḳorlo. ");
INSERT INTO syll_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ou Mabude tanre ḳoila, “Tumi nichchoy oia zanio, tumar oarish oḳole oula desho gia roiba zeḳṭa tarar nizor nae. Hono tara kub zulum-mosibotor maze roia sair-sho boros forzonto gulami korba. ");
INSERT INTO syll_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ar ze zatie tarare gulam banaiba, ami hi zatir bisar ḳormu. Bade tara bout don-doulot loia hon tone bar oia aiba. ");
INSERT INTO syll_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ar tumi shantie tumar baf-dadar gese zaibae. Tumi fura murobbi boyosho ḳoyboro hamaibae. ");
INSERT INTO syll_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Tumar sair siṛi bade era ono firia aiba, ḳaron Amuri oḳlor guna oḳono fura oise na.” ");
INSERT INTO syll_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Shuruz ḍubia zebla andair oigelo ou shomoy dumae bora eḳ undal ar agunir mushal hou hazaia raḳa kurbanir ṭukraintor mazedi gelo. ");
INSERT INTO syll_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Mabude hou din-u Abramor loge oula oada ḳorla, “Mishoror gang tone boṛo gang Furat forzonto asta desh ami tumar oarishre dilam. ");
INSERT INTO syll_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Ikṭa oilo Keni, Konizi, Kodmuni, ");
INSERT INTO syll_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hiṭṭi, Farizi, Rofayi, ");
INSERT INTO syll_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amuri, Kenani, Girgashi ar Zibuzi oḳlor desh.” ");
INSERT INTO syll_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Bibi Sarar feṭo Abramor kunu hurutta oisoin na, oile Hazera name Sarar eḳ Mishori bandi beṭi asla. ");
INSERT INTO syll_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Eḳdin Sarae Abramre ḳoila, “Huno, Mabude amare niaoladi korsoin. Te tumi amar bandir ḳasat zao, kiba taire dia ami aolad failitam fari.” Ou Abram-o Sarar mate razi oila. ");
INSERT INTO syll_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Kenan desho Abram dosh boros roar bade Sarae tan Mishori bandi Hazerare nizor zamai Abramor loge bia dila. ");
INSERT INTO syll_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Bade Abram ar Hazera ekḳano roile tair feṭo hurutta ailo. Hazerae zebla buzlo tair hurutta oita teu tair malik bibir bae boṛai deḳanit laglo. ");
INSERT INTO syll_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ou Sarae Abramre ḳoila, “Amar bae tair be-adobir lagi tumi-u dayi. Amar i bandire ami-u tumar bisnat tulia dislam, ar oḳon tair hurutta oita ḳori amare boṛai deḳar. Mabude tumar-amar bisar ḳoroukka.” ");
INSERT INTO syll_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abrame Sarare ḳoila, “Deḳo, tumar bandi to tumar ato-u ase. Tumar zela bala mone ḳoy ola-u ḳoro.” Ou Sarae Hazerare oula duk dila, duke tai tan ges taki bagia gelogi. ");
INSERT INTO syll_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Foto morubumir maze eḳṭa fanir indarar ḳasat Mabudor firistae Hazerare faila. I indara asil Shur namor zagat zaoar foto. ");
INSERT INTO syll_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Firistae ḳoila, “O Sarar bandi Hazera, tumi koi taki airae ar ḳoi zaitae?” Hazerae ḳoilo, “Ami amar malik Bibi Sarar ges taki bagia zairamgi.” ");
INSERT INTO syll_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Teu Mabudor firistae ḳoila, “Tumar malik bibir gese firia gia ḳolla nuaia hirbar tan kezmoto lago.” ");
INSERT INTO syll_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Tain aro ḳoila, “Ami tumar oarish oula baṛai dimu, tarare gonia fuṛaito nae. ");
INSERT INTO syll_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Huno, tumar feṭo hurutta ase. Tumar eḳ fua oibo, tar nam rakio Ismail mani, Allae hunoin, ḳaron Mabude tumar duk hunchoin. ");
INSERT INTO syll_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ar boṛo oile he lagam saṛa guṛar laḳan oibo. He hokkolor bae at tulbo, ar hokkole tar bae at tulba. Baiaintor loge hamesha tar lag taḳbo.” ");
INSERT INTO syll_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ar Hazerar loge Mabude matila ḳori, tai tan nam dilo “Tumi deḳa deneala Alla”; tai koilo, “Zein amare deḳoin, ami ono-u tanre deḳlam nae ni?” ");
INSERT INTO syll_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Erlagi Kadesh ar Beredor mazor hi kuar nam oilo, Ber-Lohoy-Rui mani, zein zinda ar amare deḳra, tan kua. ");
INSERT INTO syll_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Bade shomoy aile Hazerar goro eḳ fua oilo, Abrame ou fuar nam raḳla Ismail. ");
INSERT INTO syll_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abramor boyosh zebla siashi bosor oigese, ou shomoy Hazerar goro Ismailor zonom oilo. ");
INSERT INTO syll_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abramor nirannobboi borosor shomoy Mabude hirbar tanre didar dia ḳoila, “Ami Shorbo-shoktiman Alla. Tumi amar deoa foto takia kamil o. ");
INSERT INTO syll_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ami tumar-amar maze chukti kaim ḳormu ar tumar oarish kub beshi baṛai dimu.” ");
INSERT INTO syll_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Teu Abram soizdat foṛla, ar Allae tan loge batchit ḳori koila, ");
INSERT INTO syll_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Tumar loge ami oada ḳaim ḳoriar, tumi bout zatir mul baf oibae. ");
INSERT INTO syll_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Tumare ar Abram mani, boṛo baf ḳoia ḍaḳa oito nae, oḳon taki tumar nam oilo Ibrahim mani, bout zatir baf, ami tumare bout zatir mul baf banailam. ");
INSERT INTO syll_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ami tumare bout folala ḳormu, ar tumar maz tone bout zati ar bashsha oḳol foyda ḳormu. ");
INSERT INTO syll_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ami tumar ar tumar oarishor for oarish oḳlor loge ze chukti kaim ḳormu, ikṭa hor-hamesha boail taḳbo, ou usillae ami tumar ar tumar oarishor for oarish oḳlor Alla oimu. ");
INSERT INTO syll_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ar ze Kenan desho tumi oḳon musafir oia taḳrae, i furaṭa-u ami tumare ar tumar oarish oḳolre hor-hameshakur doḳolor lagi dimu. Ami tarar Alla oimu.” ");
INSERT INTO syll_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Allae Ibrahimre ḳoila, “Tumi amar ḳaim ḳora chukti manio, tumi ar tumar oarishor for oarish oḳole-o mania solio. ");
INSERT INTO syll_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Tumrar loge ar tumrar oarishor loge amar oula chukti kaim oilo, tumrar hoḳol beṭaintor mosolmani kam ḳoraite oibo. ");
INSERT INTO syll_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Tumra hoḳole nizor purush ongor mukar samṛa ḳaṭbae. Oḳṭa-u tumrar ar amar maze boail ḳora chuktir nishana. ");
INSERT INTO syll_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Oarishor for oarish doria tumrar hoḳol fuaintore zonmor aṭ dinor din mosolmani koraibae. Zara tumar oarish nae, ḳali tumrar baṛit zonmise ba tumrar ḳorida gulam, tarar-o mosolmani korani lagbo. ");
INSERT INTO syll_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Tumrar goro zonmise ba ḳorida gulam oḳolre nisoy mosolmani koraibae. Tumrar shorilo zari kora amar i chukti hor-hameshakur chukti oibo. ");
INSERT INTO syll_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ze beṭae purush ongor mukar samṛa ḳaṭto nae, tare tar zatir maz taki fusia falail oibo. He to amar chuktir borkelaf ḳorse.” ");
INSERT INTO syll_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Allae Ibrahimre ḳoila, “Tumar bibire ar Sara ḳoia ḍakio na. En nam oibo Sayra mani, rani. ");
INSERT INTO syll_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ami taire borkot nazil ḳormu, tair goro tumar eḳ fua dimu. Ar borkot nazil ḳoria bout zatir mul ma banaimu, ar bout mullukor bashsha oḳol-o foyda oiba.” ");
INSERT INTO syll_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ou Ibrahime maṭit soizdat foṛi ashia mone mone ḳoila, “Hasau eḳ-sho bosoror buṛar hurutta oito ni! Ta-o nobboi bosoror buṛi Sayrar feṭo?” ");
INSERT INTO syll_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Tain Allare ḳoila, “Ah! Ismailgu zanu tumar rohomote basia taḳe.” ");
INSERT INTO syll_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ou Allae formaila, “Ṭik ase. Oile tumar bibi Sayrar feṭo hasau tumar fua oibo, tumi tar nam raḳbae Isʼhak mani, he ashe. Tar loge amar chukti kaim ḳormu, tar oarishor loge ikṭa amar hor-hameshakur chukti oibo. ");
INSERT INTO syll_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ar Ismailor lagi-o tumar dua hunchi. Huno, ami tare-o borkot nazil ḳormu ar tare folala ḳoria bout baṛai dimu. He barozon razar baf oibo ar tar mazedi ami biraṭ zati foyda ḳormu. ");
INSERT INTO syll_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Samnor boros i sando Sayrar goro tumar ze hurutta oibo, hou Isʼhakor loge ami amar chukti kaim ḳormu.” ");
INSERT INTO syll_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ibrahimor loge batchit shesh ḳoria Allae tan ges taki uṭia toshrif nilagi. ");
INSERT INTO syll_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Allar hukum moto Ibrahime hou din-u Ismailre mosolmani koraila. Er loge ḳorida gulam oḳol ar tan baṛit zonmise ila hoḳol gulamre, baṛir hokkol beṭaintore mosolmani koraila. ");
INSERT INTO syll_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ibrahimor nizor mosolmani kam ḳoranir shomoy tan boyosh asil nirannobboi boros, ");
INSERT INTO syll_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ar tan fua Ismailor boyosh tero. ");
INSERT INTO syll_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Eḳ dine-u Ibrahim ar tan fua Ismailor mosolmani korail oilo. ");
INSERT INTO syll_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Hi din baṛir hoḳol beṭaintor, zara tan baṛit zonmisil ar zerare bidesh taki loia anchoin, ita hoḳlor-u mosolmani kam eḳloge ḳorail oilo. ");
INSERT INTO syll_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Bade Momrir elon bonor ḳasat Mabude Ibrahimre deḳa dila. Tain dinor gormor shomoy tambur dorzat boat asla. ");
INSERT INTO syll_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Oula shomoy souk tulia deḳla, tan samne tinzon manush ubai roisoin. Dekia-u tain dorzar ges taki douṛaia gia, maṭit soizda ḳoria tarare ḳoila, ");
INSERT INTO syll_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","“O munib, ami zudi afnarar mayar kunu manush oi, taile afnarar i gulamre falaia zain na zen. ");
INSERT INTO syll_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ami tuṛa fani ania diar afnara at-fao doia, ou gas tolat ziraukka. ");
INSERT INTO syll_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ar i gulamor ḳasat zebla aisoin, te tuṛa ḳani ania dei, ota ḳaia zano aram oile afnara hirbar roana dibane.” Tara ḳoila, “Bala, afne zebla ḳoira, te ḳoroukka.” ");
INSERT INTO syll_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ibrahime loge loge bitre gia Sayrare ḳoila, “Zoldi koria tin feṭu bala moyda makia fiṭa banao.” ");
INSERT INTO syll_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Tain douṛaia gia gorur fal tone kub bala eḳṭa ḳosma basur ania tan gulamre dila. He-o zoldi kori oḳṭa randilo. ");
INSERT INTO syll_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ou Ibrahime dud, doi ar gust ania tarare ḳaibar dila, tara ḳaoa-daoa ḳorla. Tain tarar ḳandat gas tolat ubaila. ");
INSERT INTO syll_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Tara Ibrahimre zikaila, “Afnar bibi Sayra ḳoi?” Tain ḳoila, “Ounu, tambur bitre asoin.” ");
INSERT INTO syll_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ou erar maze eḳzone ḳoila, “Samnor boros i sando ami oboshsho-u afnar gese aimu. Deḳba, ou shomoy afnar bibi Sayrar kulo eḳ fua taḳbo.” Sayrae Ibrahimor ḳore tambur dorzat ubaia ita hunla. ");
INSERT INTO syll_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","I shomoy Ibrahim ar Sayra buṛa-zoif oigesoin, hurutta oar laḳan boyosh-o Sayrar roisil na. ");
INSERT INTO syll_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Erlagi Sayrae mone mone ashia ḳoila, “Amar oula heshḳali boyosho ita kushi ar aibo ni? Amar malik-o murobbi oigesoin.” ");
INSERT INTO syll_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Teu Mabude Ibrahimre ḳoila, “Sayrae kitar lagi ita ḳoia ashlo zen, hasau amar hurutta oibo ni, ami to buṛi? ");
INSERT INTO syll_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Mabude faroin na ila kunta ase ni? Dekio, ṭik shomoye ami hirbar tumar gese aimu, ar i shomoy Sayrar kulo fua taḳbo.” ");
INSERT INTO syll_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sayrae ḍoraia ḳoila, “Ji na, ami to ashchi na.” Ou tain ḳoila, “Na rego, tumi nu ashilae.” ");
INSERT INTO syll_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Erbade hou tinzone in tone uṭia Sadumor bae saila. Ibrahime tarar loge oia bidae deoat gela. ");
INSERT INTO syll_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Teu Mabude ḳoila, “Ami zeta ḳortam saiar, ita kunu Ibrahimre lukaitam ni? ");
INSERT INTO syll_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ibrahim takia-u to ami eḳ mohan himmot-ala zati foyda ḳormu, duniair hoḳol zatie on tone borkot ḳamaiba. ");
INSERT INTO syll_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Erlagi-u ami tare ḳatir ḳorsi, he tar oarish ar tar nizor hoḳolre amar morzi mania hok ar insafor ḳam ḳorar hukum dey. Tara-o zudi ou laḳan sole, taile ami Mabude Ibrahimor befare zotota ḳoisi, hoḳolta-u fura ḳormu.” ");
INSERT INTO syll_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Bade Mabude ḳoila, “Sadum ar Amurar birudde kub nalish ar foriad huniar, tarar guna-o kub bezuita. ");
INSERT INTO syll_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Erlagi ami tole lamia gia deki, ami zela nalish huniar, ita hasau oula ḳaraf ki na. Ar na oile-o to deḳmu.” ");
INSERT INTO syll_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ou hi duiozone firia Sadumor bae roana dila ar Ibrahim Mabudor gese ubai roila. ");
INSERT INTO syll_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Bade Ibrahime Mabudor bae aguaia gia ḳoila, “Afne gunagaror loge hok manush oḳolre-o marilaita ni? ");
INSERT INTO syll_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ṭaunor maze zudi foinchash zon hok manush taḳe taile hou foinchash zonor ḳatire ṭaunre meherbani na ḳoria binash ḳorilaiba ni? ");
INSERT INTO syll_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Te afnar ḳam to oula nae, hok ar gunagarre eḳloge marilaoa, eḳ homan shaza deoa, afnar lagi to ṭik nae. Zein hara duniar bisar ḳoroin, tain kunu hok insaf ḳorta nae ni?” ");
INSERT INTO syll_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Mabude ḳoila, “Zudi Sadum ṭauno foinchash zon-o hok manush taḳoin, taile tarar ḳatire ami asta ṭaunre rehai dilaimu.” ");
INSERT INTO syll_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ibrahime ḳoila, “Deḳoukka, ami to duil ar sali saṛa kunta nae, ta-o ami shaosh ḳoria amar malikor loge matiar. ");
INSERT INTO syll_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Doroukka, zudi foinchash zon hok manush na oia fas zon ḳom oy, taile kita ou fas zon ḳomor lagi afne asta ṭaun binash ḳorilaiba ni?” Tain ḳoila, “Ami zudi hino foytallish zonre fai, taile ikṭa binash ḳortam nae.” ");
INSERT INTO syll_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ibrahime tanre hirbar ḳoila, “Doroukka, zudi hino sallish zon faoa zae?” Mabude ḳoila, “Hou sallish zonor ḳatire ami binash ḳortam nae.” ");
INSERT INTO syll_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ibrahime ḳoila, “Amar malik zanu amar mate naraz na oin. Aichcha, zudi hino tish zonre faoa zae?” Tain ḳoila, “Zudi ami tish zonre-o fai, taile-o ami binash ḳortam nae.” ");
INSERT INTO syll_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ibrahime ḳoila, “Ami zebla himmot ḳoria malikor loge batchit ḳoriar te hirbar ḳoiar, zudi hino bish zonre faoa zae?” Mabude zuaf dila, “Hou bish zonor ḳatire-u ami ikṭa binash ḳortam nae.” ");
INSERT INTO syll_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Heshe Ibrahime ḳoila, “Amar malik zanu naraz na oin, ami kali aro eḳbarta ḳoiar, zudi hino dosh zon taḳoin?” Mabude ḳoila, “Hou dosh zonor ḳatire-u ami ikṭa binash ḳortam nae.” ");
INSERT INTO syll_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ibrahimor loge Mabudor bat-soal shesh oia harle roana dilaila, ar Ibrahim-o tan baṛit firia aila. ");
INSERT INTO syll_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Bade hainja bala hou duizon firista Sadum ṭauno gela. I shomoy Lut ṭaunor mul geiṭor gese boat asla, erare dekia tain ubaila ar maṭit soizda ḳoria ḳoila, ");
INSERT INTO syll_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“O amar malik oḳol, ami minoti kori koiar, doya ḳori afnarar ou gulamor goro toshrif anilaukka ar at-fao doia raitḳan ḳaṭaukka. Biane hirbar roana oibane.” Era ḳoila, “Na, amra ou ṭaunor moydano rait ḳaṭaimu.” ");
INSERT INTO syll_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Tain zebla kub minot-ḳajji korra ou shomoy era tan baṛit hamaila. Bade Lute ruṭi banaia erar lagi kana-dana zuit ḳorla, ar tara ḳaila. ");
INSERT INTO syll_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Erar hutibar age-u Sadum ṭaunor hokkol zuan-buṛa beṭainte aia hi baṛire berilaila, ");
INSERT INTO syll_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ar Lutre ḍakia ḳoila, “Aiz rait ze duizon manush tor ino aise, tara ḳoi? Otare bar ḳoria amrar gese an. Amra otar loge mouz ḳortam.” ");
INSERT INTO syll_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ou shomoy Lute dorzar bare gia tan ḳoror doroza bond ḳoria tarare ḳoila, ");
INSERT INTO syll_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“Baiainre, ami minot ḳoriar, tumra ila bod ḳam ḳorio na. ");
INSERT INTO syll_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Deḳo, amar duiṭa shoti fuṛi ase. Ami bar ḳoria tumrar gese loia aiar, tara kunu beṭaintor gese roisoin na, tumrar zeta mone sae ḳoro; ta-o, i manshor loge tumra kunta ḳorio na, era amar goro asroy loisoin.” ");
INSERT INTO syll_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Oile tara ḳoilo, “Za, za, fot taki hor!” Tara aro ḳoilo, “Oi beṭa, tui eḳla boitol oia aisos ar ḳali amrar ufre netagiri korre. Oḳon erar saite tor loge aro beshi kobisi kormu.” Ḳoia-u tara Lutre ṭelia horaia dorza bangto sailo. ");
INSERT INTO syll_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ou shomoy hou duizone at baṛaia, Lutre goror bitre ṭania nia doroza bond ḳori dila. ");
INSERT INTO syll_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ar dorzar bare ubail huru-boṛo hoḳol aḳta-u anda oigelo, ar dorza tuḳaite tuḳaite heran oigelo. ");
INSERT INTO syll_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Bade hou duiozone Lutre zikaila, “Ino tumar ar ḳe ḳe ase? Tumar fua-fuṛi ar damandre loia in tone horia zaogi. ");
INSERT INTO syll_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ḳaron amra i zagare sarḳar ḳorilaiar. Inor manshor birudde Mabudor gese oula bezuita nalish oise zen, ikṭa binash ḳorar lagi tain amrare faṭaisoin.” ");
INSERT INTO syll_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ou Lute bare gia tan daman oḳolre ḳoila, “Ao, tumra i zaga saṛia baro ḳaron Mabude i ṭaunre binash ḳorar lagi tiar oiroisoin.” Oile tara mone ḳorlo, tain ita tamsha ḳorra. ");
INSERT INTO syll_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Fotabala hou firistae Lutre tagda dia ḳoila, “Uṭo, zoldi kori tumar bou ar i duio fuṛire loia on tone zaogi. Naile ou gozobor maze foṛia binash oizibae.” ");
INSERT INTO syll_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lute zai-zairam oula ḳorra. Oile Mabudor maya tan ufre asil ḳori hou duiozone, tain ar tan bou ar tan duio fuṛintor ato dori ṭania ṭaunor bare loia aila. ");
INSERT INTO syll_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Hoḳolre bar ḳoria anar bade tara ḳoila, “Baste saile bago, ḳoredi saio na, bagia faṛo zao, i tʼol zagar kunuḳano ubaio na arnae tumra-o morbae.” ");
INSERT INTO syll_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ou Lute ḳoila, “O amar malik oḳol, ila ḳoroin na zen; ");
INSERT INTO syll_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","deḳoukka, afnar i gulamre afne meherbani korsoin, ar amar zan basaibar lagi afne amare moha doya deḳaisoin. Oile ami bagia faṛo zaitam fartam nae. Hoyto i bifod aia amare zata mari dorle, ami-o mormu. ");
INSERT INTO syll_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Deḳoukka, bagia zaite to ou huru gauṭa ḳasat ase. Zan basaibar lagi amare ono faṭai deukka. Gauṭa huru-muru ase.” ");
INSERT INTO syll_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Tain ḳoila, “Ṭik ase, ami tumar i arzi manlam. Tumi ze gaur ḳota ḳoilae, iṭa ami dongsho ḳortam nae. ");
INSERT INTO syll_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Zoldi kori hino zao. Tumi hono na fosani forzonto ami kunta ḳortam fariar na.” Lutor ḳotar lagi hou gaur nam oilo Suar mani, huru. ");
INSERT INTO syll_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lute zebla Suaro gia fosla i shomoy shuruz uṭigese. ");
INSERT INTO syll_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Erbade-u Mabude asman taki Sadum ar Amurar ufre aguin ar gondoḳor gozob saṛila. ");
INSERT INTO syll_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Tain hi ṭaun oḳol, hoḳol tʼol zaga, hokkol manush ar hi maṭir ufror hokkolta dongsho ḳorilaila. ");
INSERT INTO syll_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ermaze Lutor boue ḳoredi firia saoae, tain eḳṭa nunor sakka oigela. ");
INSERT INTO syll_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Bador din Ibrahime biane uṭia hou zagat gela zeno agor din tain Mabudor gese ubaisla. ");
INSERT INTO syll_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Tain tole Sadum, Amura ar hoḳol tʼol zagar bae saia deḳla, iṭ-baṭṭa taki zela duma baroy, ou laḳan hou elaḳa taki duma uṛer. ");
INSERT INTO syll_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ar Lute zeḳano boshot ḳorta, hou tʼol zagar ṭaun oḳol dongsho ḳorar shomoy, Allae Ibrahimor ḳota mono ḳoria Lutre hinor gozobor maz taki horaia anla. ");
INSERT INTO syll_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Suar gaut roite ḍoraila ḳori, Lute tan duio fuṛire loia hin taki bar oia faṛo aia, ek gator bitre roila. ");
INSERT INTO syll_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Eḳdin tan boṛo fuṛie huru boinre ḳoilo, “Baba to murobbi oigesoin. Ar zogotor shomazor niom moto amrare bia ḳorar lagi ino kunu beṭain-o nae. ");
INSERT INTO syll_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Te ae, amra babare shorab ḳaoaia tan ḳasat roi. Teu babaredi amrar bongsho basaitam farmu.” ");
INSERT INTO syll_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ou tara duiozone raitor bala tanre shorab ḳaoaia ṭal banailo. Bade boṛo boin bafor gese hutito gelo, oile kun shomoy hutilo ar kun shomoy uṭilo, bafe kunta-u ṭer faila na. ");
INSERT INTO syll_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Bador din boṛogue hurugure ḳoilo, “Dek, kail rait ami babar gese hutislam. Ae, aiz rait-o tane oula shorab ḳaoaia ṭal banai, bade tui-o gia tan gese hutis. Te babaredi amrar bongsho basaitam farmu.” ");
INSERT INTO syll_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ou laḳan tara hou rait-o tarar bafre shorab ḳaoaia ṭal banailo, ar huru fuṛi tair bafor gese hutilo. Tai kun shomoy hutilo ar kun shomoy uṭilo, ita tain kunta-u ṭer faila na. ");
INSERT INTO syll_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Ou nomunae Lutor duio fuṛir feṭo bafredi hurutta ailo. ");
INSERT INTO syll_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Bade boṛo fuṛir goro fua oile, er nam raḳlo Muab mani, babar ges tone. Ou Muab-u oḳonkur Muabi oḳlor mul baf. ");
INSERT INTO syll_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ar huru fuṛir-o eḳ fua oilo, er nam raḳlo Bin-Ommi mani, amar mullukor fua. He oḳonkur Boni-Ammanor mul baf. ");
INSERT INTO syll_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ar Ibrahime hin tone Negebor morubumir bae gia Kadesh ar Shuror mazḳano Gerar desho roila. ");
INSERT INTO syll_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Hono hirbar tan bou Sayrare nizor boin ḳoia forisoy dila. Erlagi hinor bashsha Abimalike manushdi Sayrare tan gese nilagi. ");
INSERT INTO syll_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ar rait Allae Abimalikre kuabe ḳoila, “Huno, ou ze beṭire tumi loia aiso, tair to zamai ase, erlagi tumi oḳon moutor muko.” ");
INSERT INTO syll_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimalik oḳono Sayrar gese gesoin na. Erlagi tain ḳoila, “O Malik, ni-oforadi zati oile-o kita afne marilaita ni? ");
INSERT INTO syll_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ou manushṭae to nize-u ḳoise, ein tar boin. Ar ou beṭie-o ḳoisoin na ni, ein tan bai? Ami to shorol mone ni-oforadi ate i kam ḳorsi.” ");
INSERT INTO syll_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Allae kuabe tanre ḳoila, “Ami-o zani, tumi shorol mone i kam ḳorso. Erlagi tumare gunar ḳam taki ami dom loailam. Taire soite dilam na. ");
INSERT INTO syll_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Oḳon tumi tan bibire tan gese firot dilao. Tain eḳzon nobi. Tain tumar lagi dua ḳorba, teu tumar zan basbo. Ar zudi taire firot na deo, te zanilio, tumi ar tumar hoḳol-u nisoy morbae.” ");
INSERT INTO syll_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ou Abimalike fozore uṭia tan nizor uzir-nazir oḳolre ita hoḳolta ḳoila, ita hunia tara kub beshi ḍoraila. ");
INSERT INTO syll_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Bade Abimalike Ibrahimre anaia ḳoila, “Afne amrar loge ita kun zator bebohar ḳorla? Ami afnar gese kita dush ḳorsi zen, afne amare ar amar bashshaire oto boṛo gunar daye falaila? Afne to amar loge ita oinnae ḳam ḳorla.” ");
INSERT INTO syll_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimalike aro ḳoila, “Afne kita dekia ila ḳam ḳorla?” ");
INSERT INTO syll_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ibrahime zuaf dila, “Ami mone ḳorslam, i zagar manshor Allar bae kunu ḍor-boy nae, erlagi amar bour lalose hoyto tara amare kun ḳorba. ");
INSERT INTO syll_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ar tai hasau amar boin lage, ḳaron tai amar haton goror boin, ar oḳon amar bou. ");
INSERT INTO syll_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Allae zebla amare amar bafor baṛi tone bar ḳori anla, ou shomoy ami taire ḳoislam, ‘Tumi amare ou mayaḳan ḳorio, amra zeno-u zai na ḳene, tumi amare tumar bai koia forisoy dio.’ ” ");
INSERT INTO syll_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Bade Abimalike ḳotoṭa meṛa-goru, bandi-gulam Ibrahimre dila ar tan bibi Sayrare-o firot dilaila. ");
INSERT INTO syll_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimalike ḳoila, “Deḳoukka, amar asta deshṭa-u afnar samne foṛi roise, te afnar zeno fosond ono-u roukka.” ");
INSERT INTO syll_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Tain Sayrare ḳoila, “Deḳoukka, ami afnar baire eḳ azar rufar ṭeḳa dilam. Ar afnar ijjotor hoḳol bisaror foysala oilo.” ");
INSERT INTO syll_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Bade Ibrahime Allar gese dua ḳorla, ar Allae Abimalik, tan bou ar tan bandi oḳolre shifa ḳorla ar tarar hurutta-o oila. ");
INSERT INTO syll_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Ḳaron Ibrahimor bibi Sayrar lagi Mabude Abimalikor baṛir hoḳol beṭintor hurutta oa bond ḳori disla. ");
INSERT INTO syll_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Mabude tan kalam mutabek Bibi Sayrare hefazot ḳorla, tain zela oada ḳorsla, ola-u ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Ar Bibi Sayrar feṭo hurutta ailo. Allae ze shomoykur ḳota ḳoisla, hou shomoye-u Ibrahimor murobbi boyosho tan fuar zonom oilo. ");
INSERT INTO syll_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ibrahime Sayrar goror tan ou fuar nam raḳla Isʼhak mani, asha. ");
INSERT INTO syll_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Allar hukum moto tain aṭ dinor din tan fua Isʼhakor mosolmani kam ḳoraila. ");
INSERT INTO syll_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ibrahimor eḳ-sho bosoror shomoy tan fua Isʼhakor zonom oilo. ");
INSERT INTO syll_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Bibi Sayrae ḳoila, “Allae amar muko ashi bar ḳorla, ar ita ze hunbo, he-o amar loge ashibo.” ");
INSERT INTO syll_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Tain aro ḳoila, “Sayrae fuaintore bukur dud ḳaoaibo, ita Ibrahimre ḳe ḳoilo one? Ar oḳon to ou buṛa boyosho, amar feṭo tan fua foyda oilo.” ");
INSERT INTO syll_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Isʼhak boṛo oar bade zedin tane maʼr dud saṛail oilo, houdin Ibrahime eḳ boṛo mezbani korla. ");
INSERT INTO syll_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ar Mishori Hazerar feṭo Ibrahimor ze fua oisil, Sayrae deḳla he tamsha ḳorer. ");
INSERT INTO syll_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Ou tain Ibrahimre ḳoila, “Fua shoho i bandire bar ḳori deo, bandir fua amar Isʼhakor loge ongshidar oito farto nae.” ");
INSERT INTO syll_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Fuar ita hunia Ibrahime mono kub toklif faila. ");
INSERT INTO syll_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ou Allae tanre ḳoila, “Tumar bandi ar tair fuar lagi tumi bezar oio na. Sayrae zela tumare ḳoise oula ḳoro, ḳaron tumar fua Isʼhakor ḳandanre-u tumar ḳandan ḳoia gona oibo. ");
INSERT INTO syll_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ar i bandir torofa fua taki-o ami eḳṭa zati toiar ḳormu, ḳaron he-o to tumar aolad.” ");
INSERT INTO syll_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ou Ibrahime aguan uṭia kisu ruṭi ar fani bora eḳṭa samṛar toli hazaia Hazerar ḳando tulia dia, fuagure tair ato shofia bidae ḳorla. Hin tone bar oia Hazerae Ber-Shebar morubumir maze sokkor dita lagla. ");
INSERT INTO syll_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Tolir fani shesh oigele tain fuare eḳṭa zonglar tole hutaia toila. ");
INSERT INTO syll_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ar eḳ ḍaḳor foriman duroi gia tain boiroila. “Fuar mout zate amar souke na deki,” mone mone ḳoia, tain hono boia-u sillaia ḳandila. ");
INSERT INTO syll_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Fuagur ḳandon Allae hunla, ar Allar firistae asman tone ḍakia Hazerare ḳoila, “Hazera, O Hazera, tumar kita oise? Ḍoraio na, fuagu zeno ase, hon taki-u tar ḳandon Allae hunchoin. ");
INSERT INTO syll_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Tumi uṭia fuagur ato doro, ami taredi eḳ biraṭ zati foyda ḳormu.” ");
INSERT INTO syll_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ou Allae Hazerar souk kulia dila, ar tain ek kua deḳla. Hi kua tone samṛar tolit fani bori ania fuare ḳaoaila. ");
INSERT INTO syll_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Allae hou fuare hefazot ḳorla. He boṛo oilo, ar morubumit takia tir-donuk salanir ustad oilo. ");
INSERT INTO syll_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","He Faran morubumit taḳto. Tar maʼe Mishoror eḳ fuṛire ania tare bia ḳoraila. ");
INSERT INTO syll_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Hou shomoy Abimalik ar tan shenapoti Fikule Ibrahimre ḳoila, “Afne zeta-u ḳoroin, otat-u Allae afnar loge taḳoin. ");
INSERT INTO syll_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Erlagi Allar name afne oḳon ono amar gese ḳosom ḳoroukka, amar ba amar aolad oḳlor loge, afne kunu beimani korta nae. Ar ami zela afnare doya deḳaisi, afne-o amar loge ar afnar musafirir zaga, i deshor loge oula doyar nozor raḳba.” ");
INSERT INTO syll_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ibrahime ḳoila, “Ji oy, ḳosom ḳorlam.” ");
INSERT INTO syll_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ar Abimalikor gulam oḳole eḳṭa fanir kua zure nisilgi kori, tain nalish dila. ");
INSERT INTO syll_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimalike zuaf dila, “Ita ḳam ḳe ḳorse ami to zani na. Afne-o amare ita ḳoisoin na, aiz-u ami ikṭa hunlam.” ");
INSERT INTO syll_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Bade Ibrahime kisu meṛa ar goru ania Abimalikre dila ar duiozone chukti korla. ");
INSERT INTO syll_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ar Ibrahime fal tone shatgu meṛi-baichcha algaila. ");
INSERT INTO syll_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimalike tane zikaila, “I meṛi-baichcha shatgu alga ḳorar mani kita?” ");
INSERT INTO syll_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ibrahime ḳoila, “Afne oguintore neukka. I kuaṭa ze ami kudsi ikṭa oilo tar forman.” ");
INSERT INTO syll_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Erlagi ou zagar nam oilo Ber-Sheba mani, ḳosmor kua, ono-u tara duio zone ḳosom ḳorsla. ");
INSERT INTO syll_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Tara Ber-Shebat ou chukti korar bade, Abimalik ar tan shenapoti Fikul uṭia Filistini oḳlor desho firia gelagi. ");
INSERT INTO syll_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Bade Ibrahime Ber-Shebat eḳṭa zau gas ruila, ar ze Mabudor shuru-o nae shesh-o nae, tan ebadot ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ar Ibrahime Filistini oḳlor desho bout din ḳaṭaila. ");
INSERT INTO syll_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","I goṭonar bade Allae Ibrahimor eḳ forikka loila. Allae tanre ḍaḳ dila, “Ibrahim!” Tain zuaf dila, “Ounu ami.” ");
INSERT INTO syll_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Mabude formaila, “Tumar fuare, zare tumi oto mohobbot ḳoro, hou ḳas mayar fut Isʼhakre loia tumi Muria elaḳat zao. Hoḳano ze faṛor ḳota ami tumare ḳoimu, er ufre tare nia zalail kurbani deo.” ");
INSERT INTO syll_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Teu Ibrahime fozore uṭia gadar fiṭit goddi lagaia tan fua Isʼhak, duizon gulam ar zalail kurbanir lagi laḳṛi kaṭia loia, ze zagar ḳota Allae tanre ḳoisla, hobaedi roana oila. ");
INSERT INTO syll_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Tin dinor din Ibrahime souk tulia saite-u duroi taki hou zagaḳan deḳla. ");
INSERT INTO syll_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ou tan gulam oḳolre ḳoila, “Tumra gadaṭa loia ono ubao, ami ar amar fua hono gia ebadoti shesh ḳoria harle tumrar gese aimu.” ");
INSERT INTO syll_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ibrahime zalail kurbanir laḳṛir aṭa tan fua Isʼhakor ḳando tulia dia nize aguinor fatil ar suri loia, duio zone samnor bae aguaila. ");
INSERT INTO syll_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ou Isʼhake tan bafre ḳoila, “Baba.” Tain ḳoila, “Kitare baf ḳo?” Isʼhake ḳoila, “Ino to laḳṛi ar aguin ase, te kurbanir meṛa-baichcha kuai?” ");
INSERT INTO syll_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Tain zuaf dila, “Babare, kurbanir lagi Allae nize-u meṛa-baichcha zugaiba.” Ota matte matte tara aguai gela. ");
INSERT INTO syll_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Allar fosondor zagat fosia Ibrahime kurbani kana banaia, laḳṛi hazaila. Bade nizor fua Isʼhakre bandia ou darur ufre hutaila. ");
INSERT INTO syll_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ar tain nizor fuare kurbanir lagi suri ato loila. ");
INSERT INTO syll_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ou Mabudor firistae asman tone tane ḍaḳ dila, “Ibrahim! O Ibrahim!” Tain ḳoila, “Ounu ami.” ");
INSERT INTO syll_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Firistae ḳoila, “Fuagur bae tumar at tulio na, tare ar kunta-u ḳorio na. Tumi zen Allare ḍorao ita buza gese, ḳaron amare tumar fua, tumar ḳas mayar fua dan ḳorte-o na-kush oiso na.” ");
INSERT INTO syll_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ibrahime souk tuli saia deḳoin, tan ḳore eḳṭa dumba ar tar hing zongolor maze aṭki roise. Ou tain gia dumbaṭa ania, nizor fuar bodla zalail kurbani dila. ");
INSERT INTO syll_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Tain hi zagar nam raḳla Iaoweh-Zirih mani, Mabude zugain. Erlagi oḳono manshe ḳoin, “Mabudor faṛo zugail oibo.” ");
INSERT INTO syll_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Mabudor firistae asman tone hirbar Ibrahimre ḍakia ḳoila, ");
INSERT INTO syll_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Huno, Mabude ḳoira, tumi oula ḳorlae, tumar fuare, tumar ḳas mayar fuare dan ḳorte-o naraz oilae na. Erlagi ami Mabude ḳosom ḳoria ḳoiar, ");
INSERT INTO syll_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ami nisoy tumare borkot nazil ḳormu, tumar bongshore asmanor tera ar doriar soror balur laḳan behishab ḳormu. Tumar bongshoe tarar dushmonor ṭaun oḳol doḳol ḳorba. ");
INSERT INTO syll_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ar tumar bongshor usillae duniar hoḳol zatie borkot hasil ḳorba. Ḳaron tumi amar hukum mancho.” ");
INSERT INTO syll_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Bade Ibrahime tan gulam oḳlor gese firia aila, ar tara eḳloge Ber-Sheba namor zagat gela. Ou zagat-u tain boshoti korla. ");
INSERT INTO syll_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","I goṭonar bade Ibrahime ḳobor faila, tan bai Nahuror bibi Milkar ḳoygu fuain oisoin. ");
INSERT INTO syll_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Er boṛo fuar nam Auz, tar baiaintor nam Buz, ar Oramor baf Komuel, ");
INSERT INTO syll_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","erbade Kesod, Hosho, Fildosh, Zidlof ar Botuel. Botuelor fuṛir nam Rebeka. ");
INSERT INTO syll_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Ibrahimor bai Nahuror bibi Milkar feṭo taki i aṭzon fuar zonom oisil. ");
INSERT INTO syll_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahuror eḳ hangar bou asil, tair nam Rouma. Tair feṭo Ṭeboh, Gohom, Tohosh ar Maḳar zonom oisil. ");
INSERT INTO syll_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Bibi Sayra eḳ-sho shataish boros basila; Allae tane otodinor hayati disla. ");
INSERT INTO syll_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Bade Kenan deshor Kiriot-Orbo mani Hebrono inteḳal ḳorla. Ar Ibrahime tan lagi bout ḳanda-ḳaṭi ar ahazari korla. ");
INSERT INTO syll_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Heshe tan murda bibir ges tone horia gia hou deshor Hiṭṭi oḳolre ḳoila, ");
INSERT INTO syll_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ami to bideshi musafir oia afnarar ono roiar. Meherbani kori kobrostan banaibar lagi amare tuṛa zomi deukka, ami amar samne tone amar murdare dafon ḳori.” ");
INSERT INTO syll_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hiṭṭi oḳole tane ḳoila, ");
INSERT INTO syll_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Huzur, amrar ḳota hunoukka. Afne to amrar maze Allar mohobbotor buzurg. Amrar gurustanor maze zeno fosond oy, ono-u afnar murdare dafon ḳoroukka. Tanre dafon ḳorar lagi amrar ḳeu-u nizor banail ḳoybor saṛte omot ḳorto nae.” ");
INSERT INTO syll_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ou Ibrahime ubaia hinor Hiṭṭi oḳlor samne mata nuaia ijjot ḳori koila, ");
INSERT INTO syll_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","“Amar bibire ino dafon ḳorat zudi afnarar kunu omot na taḳe, te doya ḳori amar arziḳan hunoukka. Afnara amar oia Shuhoror fua Ifrunre ḳoukka, ");
INSERT INTO syll_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","tan zominor hesh matat Moḳfela ze guha ase, oḳanta zenu ḳobrostan bananir lagi tain fura dam loia amar gese besilain.” ");
INSERT INTO syll_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Aro Hiṭṭi oḳlor loge i shomoy Ifrun-o hono boat asla. Ibrahimor mator zuafe hou Hiṭṭi oḳlor samne Ifrune ḳoila, ");
INSERT INTO syll_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Na, na, afne doya ḳori amar matḳan hunoukka. Ami hoḳlor samne-u i zomi ar guha afnare dilailam, afnar murdare dafon ḳorilain.” ");
INSERT INTO syll_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Teu Ibrahime hirbar hinor hoḳlor samne mata nuaia, ");
INSERT INTO syll_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","hi deshor hokkolre hunaia Ifrunre ḳoila, “Hunoukka, zomiḳanor dam ami dilai. Afne-o zomiḳanor dam neukkagi, bade amar murdare ono dafon ḳormu.” ");
INSERT INTO syll_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ifrune tanre zuaf dila, ");
INSERT INTO syll_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Huzur, amar ḳota hunoukka, ou zomiḳanor dam oilogi sair-sho tola rufa, te afnar-amar lagi ita kunta-u nae. Afnar murdare ḳoybor dilaukka.” ");
INSERT INTO syll_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ou Ibrahime Ifrunor ḳota mania Hiṭṭi oḳlor samne tain, Ifrunor saoa dam mafik, faikari mafe sair-sho tola rufa tanre mafia dila. ");
INSERT INTO syll_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Ou laḳan Momri ṭaunor gese Moḳfelat Ifrunor ze zomin asil hou zomin ar honor guha ar zominor sairobae zoto gas-gasali asil, ");
INSERT INTO syll_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ita hoḳolta-u hinor Hiṭṭi oḳol ar ṭaunor mukor hoḳlor samne, Ibrahimor malikanae ailo. ");
INSERT INTO syll_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Bade Ibrahime Kenan deshor Momri ṭaun ba Hebronor Moḳfelar guhat tan bibi Sayrare dafon ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ou laḳan Moḳfelar ou guha shoho asta zominḳan gurustanor lagi, Hiṭṭi oḳlor at tone Ibrahimor ato ailo. ");
INSERT INTO syll_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ibrahim i shomoy kub murobbi ar zaoagir foti oigesoin. Mabude tanre hoḳolbae tone borkot nazil ḳorsla. ");
INSERT INTO syll_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ar tan ḳas gulam, baṛir furan ze gulamor ufre tan hoḳoltar bar deoa asil tare ḳoila, “Tumar atḳan amar urator tole harao. ");
INSERT INTO syll_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Ami tumare asman-zominor malik Alla Mabudor name ḳosom ḳoraiar, ami ze Kenani oḳlor maze takiar, tarar kunu fuṛire amar fuar bou banaia tumi anio na. ");
INSERT INTO syll_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Tumi amar desho gia, amar fua Isʼhakor lagi amar ḳesh-kuṭumor maz taki egu ḳoina saia anbae.” ");
INSERT INTO syll_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ou hi gulame tanre ḳoila, “Zudi kunu fuṛie amar loge i desho aite razi na oin, taile ze desh saṛia afne aisoin, afnar fuare ami hono loia zaitam ni?” ");
INSERT INTO syll_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Tain ḳoila, “Ḳobordar! Tumi amar fuare kunumonte-u hino loia zaio na. ");
INSERT INTO syll_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Ze asmani Alla Mabude amare, amar bafor baṛi ar zonom maṭi tone bar ḳoria anchoin, tain amar loge bat-soal ḳori kosom ḳoria ḳoisoin, i deshḳan tain amar oarish oḳolre diba. Tain tumar age-u tan firistare hono faṭaiba, zate amar fuar lagi tumi hon tone egu ḳoina antae faro. ");
INSERT INTO syll_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Zudi kunu fuṛie tumar loge aite razi na oy, te amar i kosom taki tumi kalas; ta-o amar fuare tumi kunu laḳan-u hino loia zaio na.” ");
INSERT INTO syll_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ou hi gulame tan munib Ibrahimor urator tole at haraia oula ḳosom ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Bade hou gulame tan munibor uṭor fal taki doshṭa uṭ loila. Ar munibor bala bala zinish oḳol loia, Oram-Nohoroyim deshor zeno Nahur taḳta hobaedi roana oila. ");
INSERT INTO syll_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ar hainja bala zebla beṭinte fani anat bar oin, ou shomoy hi gulame ṭaunor bare ek kuar ḳasat tan uṭ oḳolre toila. ");
INSERT INTO syll_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Toia ou dua ḳorla, “O Mabud, amar munib Ibrahimor Alla, aroz ḳori, aiz amar samne kamiabi zair ḳoro, ar amar munib Ibrahimre meherbani koro. ");
INSERT INTO syll_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Deḳo, i ṭaunor fuṛinte fani neoat aira ar ami ino kuar ḳasat ubai roisi. ");
INSERT INTO syll_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Te ou fuṛintor maze ami zare ḳoimu, ‘Afnar ḳoyla lamaia amare tuṛa fani kaoaukka’, er zuafe zudi hou fuṛie ḳoin, ‘Afne fani kaukka ar afnar uṭ oḳolre-o ami fani kaoaimu’ taile ou fuṛi-u zanu tumar gulam Isʼhakor lagi tumar fosondor fuṛi oin. Teu ami buzmu, tumi amar munibre meherbani korlae.” ");
INSERT INTO syll_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Tan dua shesh na oite-u Botuelor fuṛi Rebekae ḳaḳo ḳoyla loia ṭaun taki bar oia aila. Ou Botuel oila Ibrahimor bai Nahuror bibi Milkar fua. ");
INSERT INTO syll_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebeka asla kub shundori, abiati, shoti nari. Tain kua taki koyla boria zebla uṭia aira, ");
INSERT INTO syll_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ou shomoy-u Ibrahimor gulame douṛaia tan gese gia ḳoila, “Doya ḳori afnar ḳoyla taki amare tuṛa fani kaoaukka.” ");
INSERT INTO syll_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Rebekae ḳoila, “Huzur, fani kaukka.” Ou ḳota ḳoia-u tain zoldi kori koylaṭa ḳaḳo tone ato ania fani kaite dila. ");
INSERT INTO syll_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Fani kaoaibar bade Rebekae tanre ḳoila, “Ami afnar uṭ oḳolre-o tarar fias miṭaia fani kaoaimu, tara feṭ boria fani kaiba.” ");
INSERT INTO syll_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ḳoia-u tain zoldi kori fanir gamlat ḳoylar fani ḍalia hirbar douṛaia kuar gese gela. Ar hoḳol uṭre fani tuli dila. ");
INSERT INTO syll_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Mabude tan i sofor kamiab ḳorsoin ki na iṭa zanar lagi hi gulame nirobe Rebekar bae sai roila. ");
INSERT INTO syll_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Uṭ oḳole fani kaia harle, tain ada tolar eḳṭa shunar naḳor not ar dui ato dosh tolar duiṭa shunar bala Rebekare dia zikaila, ");
INSERT INTO syll_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","“Afnar babar nam kita? Afne ḳoukka sain, afnar bafor baṛit amrar rait taḳar zaga oibo ni?” ");
INSERT INTO syll_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Rebekae ḳoila, “Amar babar nam Botuel. Dadar nam Nahur ar dadir nam Milka. ");
INSERT INTO syll_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Te afnar uṭor ḳanir lagi amrar baṛit bout ḳer-busi ase ar roibar zaga-o ase.” ");
INSERT INTO syll_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ou hi gulame Mabudor soizda ḳoria ḳoila, ");
INSERT INTO syll_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“Hokkol proshongsha Mabudor, zein amar munib Ibrahimor Alla. Tain amar malikre tan deoa oada raḳte ar imandari deḳaite faurisoin na. Tain amare-o fot sinaia amar munibor kuṭmor baṛit loia aisoin.” ");
INSERT INTO syll_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Rebekae douṛaia gia tan maʼr baṛir hoḳolre ita zanaila. ");
INSERT INTO syll_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebekar eḳ bair nam asil Labon. Ou Labone douṛaia kuar ḳasat aila enre deḳta ḳori. ");
INSERT INTO syll_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Bonir ator bala ar naḳor not dekia, ar hi manshe zeta ḳoise ita hunia, tain aia deḳla, manushṭa kuar ḳandat tar uṭor gese ubai roise. ");
INSERT INTO syll_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Labone tanre ḳoila, “O Mabudor rohomotor manush, aukka. Bare ubai roisoin ḳene? Ami afnarar lagi gor, ar uṭor lagi zaga zuit ḳoria aisi.” ");
INSERT INTO syll_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ou hi gulame tarar baṛit gia uṭ oḳlor gaiṭ lamaite-u, Labone ḳer ar busi ania dila. Tane ar tan logor hoḳolre at-fao doar fani-o dila. ");
INSERT INTO syll_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Bade tan samne ḳani deoa oilo, teu tain ḳoila, “Ami kitar lagi ino aisi, ita na hunaia ḳani kaitam nae.” Labone ḳoila, “Te ḳoilaukka.” ");
INSERT INTO syll_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ou tain ḳoila, “Ami Ibrahimor gulam. ");
INSERT INTO syll_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Amar malikre Mabude bout borkot nazil ḳorsoin, aiz tain bout doni-mani. Mabude tanre bout goru-meṛa, uṭ-gada, shuna-rufa, ar bandi-gulam disoin. ");
INSERT INTO syll_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Tan bibi Sayrar murobbi boyosho munibor eḳzon fua oisoin, ar ou fuare-u tain, tan hoḳolta dilaisoin. ");
INSERT INTO syll_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Tain amare ḳosom ḳoraia ḳoisoin zen, tain ze desho boshot ḳorra, hi Kenan deshor kunu fuṛire zate tan fuar bou na banai. ");
INSERT INTO syll_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Er bodla tan bafor ar tan ḳandanor baṛit gia tan fuar lagi eḳzon ḳoina saia nei. ");
INSERT INTO syll_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ou ami amar munibre ḳoilam, ‘Zudi kunu fuṛi amar loge aite razi na oin?’ ");
INSERT INTO syll_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Tain ḳoila, ‘Mabud, zanre ami kezmot ḳori, tain-u tan firistare faṭai diba, zate tumar sofor kamiab oy. Ar tumi amar nizor bongsho ar amar bafor ḳandan tone, egu fuṛire amar fuar lagi saia anbae. ");
INSERT INTO syll_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Tarar hino gele zudi tara kunu fuṛire na dein, taile tumi amar i kosom taki kalas faibae.’ ");
INSERT INTO syll_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Ou aiz ami kuar gese aia dua ḳorlam, ‘O Mabud, amar munib Ibrahimor Alla, tumi zudi amar i sofor kamiab ḳoro taile, ");
INSERT INTO syll_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","deḳo, ami ou bora kuar gese ubai roisi, ar kunu fuṛie ono fani neoat aile ami koimu, ḳoyla taki amare tuṛa fani kaoao. ");
INSERT INTO syll_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ar zudi tai koy, ‘Tumi-o fani kao ar tumar uṭ oḳolre-o ami fani tulia dimu’, taile ou fuṛi-u zanu amar munibor fuar lagi tumar fosond ḳora fuṛi oy.’ ");
INSERT INTO syll_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Amar dua shesh na oite-u deki, Rebekae ḳoyla ḳaḳo loia kuat aira fani tulta. Fani tular bade ami koilam, ‘Doya ḳoria amare tuṛa fani kaoaukka.’ ");
INSERT INTO syll_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Tain zoldi kori kaḳo tone ḳoyla lamaia amare ḳoila, ‘Ou nein, fani kain. Ami afnar uṭ oḳolre-o fani kaoaimu.’ Teu ami fani kailam, ar tain amar uṭ oḳolre-o fani kaoaila. ");
INSERT INTO syll_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Bade ami tane zikailam, ‘Afne ḳar fuṛi?’ Tain ḳoila, ‘Ami Botuelor fuṛi, amar dadar nam Nahur ar dadir nam Milka.’ Ou ami tan naḳo not ar ato bala findaia dilam. ");
INSERT INTO syll_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Bade ami Mabudor soizda ḳorlam. Ar zein amar munib Ibrahimor Alla, hou Mabudor shukur adae ḳorlam, tain-u amare ṭik fote salaia anchoin zate ami amar munibor batizire, tan fuar lagi tukaia fai. ");
INSERT INTO syll_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Teu oḳon afnara amar munibor bae dorod ar insaf ḳorba ni, ḳoukka. Zudi na ḳoroin ta-o ḳoukka, zate ami ḍaine-baue zaitam fari.” ");
INSERT INTO syll_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ou Labon ar Botuele ḳoila, “Goṭona to Mabud taki-u oise. Oḳon amrar bala-bura matar kunta-u nae. ");
INSERT INTO syll_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ou deḳoukka, Rebeka to ono ase, te Mabudor hukum moto afnar munibor fuar bou banaibar lagi ere loia zaita farba.” ");
INSERT INTO syll_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","I mat hunia Ibrahimor gulame Mabudor soizda ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Erbade tain shuna-rufar goyna-gaṭi ar ḳafoṛ-sufoṛ bar ḳoria Rebekare dila, er loge Rebekar ma-baire-o bout dami dami ufohar dila. ");
INSERT INTO syll_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Bade tain ar tan logor hoḳole ḳaoa-daoa shesh ḳoria hoḳano-u rait ḳaṭaila. Biane gum taki uṭia tain ḳoila, “Amar munibor gese zaoar lagi amare bidae dilaukka.” ");
INSERT INTO syll_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Teu Rebekar ma ar baie ḳoila, “Fuṛigu aro doshḳan din amrar gese taḳouk, bade zaibone.” ");
INSERT INTO syll_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ou hi gulame tarare ḳoila, “Mabude zebla amar i sofor kamiab ḳorsoin, taile amare deri na ḳoraia bidae dilaukka, amar munibor gese zaigi.” ");
INSERT INTO syll_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Era ḳoila, “Amra taile fuṛire samne ania zikailai.” ");
INSERT INTO syll_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ar Rebekare ḍakia ania zikaila, “Tumi kita tan loge zaibae ni go?” Tain ḳoila, “Aichcha, zaimune.” ");
INSERT INTO syll_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ou tara Ibrahimor gulam ar tan logor manshor loge tarar boin ar tan bandi beṭire bidae dila. ");
INSERT INTO syll_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ar Rebekare dua ḳoria ḳoila, “Boin go, tumi laḳ laḳ aolador ma o. Tumar aolade dushmon oḳolre gail ḳorouk.” ");
INSERT INTO syll_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebeka ar tan bandi oḳole toiar oia uṭor ufre soṛia, Ibrahimor gulamor ḳore oia roana dila. Ou laḳan hou gulame Rebekare loia bar oila. ");
INSERT INTO syll_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isʼhak i shomoy Negebo taḳta. Tain Ber-Lohoy-Rui namor zaga tone firot aila. ");
INSERT INTO syll_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Eḳdin biali bala tain bondedi aṭat bar oila. Aḳta-u souk tulia saia deḳla, ḳoyṭa uṭ aira. ");
INSERT INTO syll_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebekae-o duroi tone Isʼhakre dekia-u uṭor ufor taki lami gela. ");
INSERT INTO syll_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Ar hou gulamre zikaila, “Ou zein bondor mazedi amrar bae aira, ein ḳe?” Gulame ḳoila, “Ein to amar munib.” Ou Rebekae burkar forda lamai dila. ");
INSERT INTO syll_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ar hi gulame zeta zeta ḳoria aisoin, hoḳolta Isʼhakre zanaila. ");
INSERT INTO syll_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isʼhake tan ma Bibi Sayrar tambut Rebekare loia gia tane bia ḳorla. Ar tanre maya ḳorla. Tan maʼr moutor bade, Rebekar mayae-u tan zano shanti faisla. ");
INSERT INTO syll_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ibrahime Katura namor aro eḳzon beṭire bia ḳorsla. ");
INSERT INTO syll_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Tan feṭo Zimron, Zokshon, Modan, Madian, Zishboḳ ar Shuhar zonom oisil. ");
INSERT INTO syll_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Shaba ar Dodan oila Zokshonor aolad. Ashuri, Loṭushi, Liummi oḳol oila Dodanor aolad. ");
INSERT INTO syll_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Madianor aolad oila Oifa, Efor, Honuk, Obid ar Ildaya. Era hoḳol-u Katurar aolad. ");
INSERT INTO syll_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ibrahime tan hoḳolta Isʼhakre dilaila. ");
INSERT INTO syll_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Oile tain zinda taḳte-u, tan heshor biar aolad oḳolre-o alga alga dan ḳoria, erare Isʼhakor loge na rakia fubedi, fubor desho faṭai dila. ");
INSERT INTO syll_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ibrahim eḳ-sho fosottoir boros basila, Allae tane otodinor hayati disla. ");
INSERT INTO syll_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Tain murobbi oia furafur buṛa boyosho inteḳal ḳorla, ar tan baf-dadar gese gia azila. ");
INSERT INTO syll_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Heshe tan fua Ismail ar Isʼhake Momri ṭaunor fubedi, Hiṭṭi Shuhoror fua Ifrunor zomir Moḳfela-guhat, tanre dafon ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","I zomiḳan tain Hiṭṭi oḳlor ges tone loisla. Ono-u tan bibi Sayrare ar tane dafon ḳora oise. ");
INSERT INTO syll_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ibrahimor moutor bade Allae tan fua Isʼhakre borkot nazil ḳorla. Tain Ber-Lohoy-Ruir gese roita. ");
INSERT INTO syll_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ou oilo Ismailor ḳandanor boyan. Bibi Sayrar bandi Mishori Hazerar feṭo Ibrahimor fua Ismailor zonom oisil. ");
INSERT INTO syll_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ou oilo Ismailor aolador nam ar gusṭir boyan. Tan boṛo fuar nam Nabaut, bade Ḳaedar, Odbel, Mibsom, ");
INSERT INTO syll_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Duma, Masa, ");
INSERT INTO syll_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hodod, Tema, Ziṭur, Nafish ar Ḳedoma. ");
INSERT INTO syll_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ismailor ou barozon fua asla baro gusṭir shordar. Tarar namor laḳan hi gau ar tambu bisail zagar-o ou nam oisil. ");
INSERT INTO syll_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismailor hayat eḳ-sho shaṛtish boros asil, heshe tain mara gela ar tan baf-dadar gese gelagi. ");
INSERT INTO syll_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Hobila tone Ashiriar bae Mishoror samnor Shur forzonto tan aolad oḳol roita. Ismaile tan hoḳol baiaintor galabae roar zaga faila. ");
INSERT INTO syll_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ou oilo Ibrahimor fua Isʼhakor ḳandan-nama. Ibrahimor goro Isʼhakor zonom oilo. ");
INSERT INTO syll_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isʼhake sallish boros boyosho tan mamur goror boin Rebekare anaia bia ḳorla. Rebeka oila Foddon-Iram deshor Orami Botuelor fuṛi, Orami Labonor boin. ");
INSERT INTO syll_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Tan bou niaoladi asla gotike, Isʼhake Mabudor gese dua ḳorla. Mabude tan dua kobul ḳorla, ar Rebekar feṭo hurutta ailo. ");
INSERT INTO syll_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Bade feṭor bitre huruttae loṛa-soṛa ḳorat lagla. Ou tain ḳoila, “Amar feṭo ila lager ḳene?” Ḳaron zanar lagi tain Mabudor gese dua ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Mabude tanre ḳoila, “Tumar feṭo duiṭa zati ase, feṭo tone-u tara dui bongsho oia foyda oiba. Eḳ bongsho tone aroḳ bongsho shoktiala oibo, ar boṛogue hurugur kezmot ḳorbo.” ");
INSERT INTO syll_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Hurutta foydar bala deḳoin, hasau tan feṭo zuṛor fua. ");
INSERT INTO syll_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Foyla zar zonom oilo he lal rongor ar tar shorilo foshomi kafṛor laḳan rumae bora. Tar nam raḳla Ish mani, ruma-ala. ");
INSERT INTO syll_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Bade Ishʼor faor murat dori tar bair zonom oilo, er nam raḳla Iakub mani, faot dorra. Isʼhakor shaiṭ boros boyosho era zuṛe foyda oila. ");
INSERT INTO syll_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ou fuain boṛo oar bade Ish kub bala shikari ar morubumit faḳaora oila, oile Iakub asla nirai-zirai, tain tambut taḳta. ");
INSERT INTO syll_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Shikaror gust moza lagto ḳori Isʼhake Ishʼre maya ḳorta, ar Rebekae Iakubre maya ḳorta. ");
INSERT INTO syll_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Eḳdin Iakube ḍail randisoin, ou shomoy tan boṛo bai Ish morubumi taki feṭor buke kub ḳator oia aila, aia huru bai Iakubre ḳoila, ");
INSERT INTO syll_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","“Baire, amar kub buk lagse. Te ou rongil, rongil ota amare feṭ bori kaite de.” Ou ḳotar lagi tan siṛ laglo Idum mani, rongil. ");
INSERT INTO syll_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Iakube ḳoila, “Taile boṛo bai oar malikana, tumi aiz amar gese besilao.” ");
INSERT INTO syll_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ishe ḳoila, “Deḳo, amar zan bar oizar, ar boṛo bair malikanadi ar kita ḳortam?” ");
INSERT INTO syll_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Iakube ḳoila, “Age tumi amar gese ḳosom ḳoro.” Ou Ishe ḳosom ḳoria boṛo bai oar malikana Iakubor gese besilaila. ");
INSERT INTO syll_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Bade Iakube Ishʼre ḍail ar ruṭi kaite dila. Ḳaoa-daoa ḳoria tain uṭia gelagi. Ou laḳan Ishe boṛo fua oar kunu dam-u raḳla na. ");
INSERT INTO syll_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ibrahimor zomanar laḳan ifira-o desho hirbar eḳ nidan deḳa dilo. Teu Isʼhak Gerar ṭauno Filistini oḳlor bashsha Abimalikor gese gelagi. ");
INSERT INTO syll_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ar Mabude Isʼhakre didar dia ḳoila, “Tumi Mishoro lamia zaio na. Ami tumare ze deshor ḳota ḳoimu, ono-u takio. ");
INSERT INTO syll_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ou desho tumi musafir oia ro. Ami tumar loge roia, tumare borkot nazil ḳormu. I desh oḳol ami tumare ar tumar oarish oḳolre dimu. Ar tumar baf Ibrahimor gese ami ze ḳosom ḳorslam, oḳṭa fura ḳormu. ");
INSERT INTO syll_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ami tumar oarish oḳolre asmanor terar laḳan behishab ḳormu, ou desh oḳol-o tarare dimu. Tumar oarishredi, duniair hoḳol zatie borkot faiba. ");
INSERT INTO syll_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ibrahime amar mat hunia, amar hukum, amar ain ar amar shoriot oḳol amol ḳorse.” ");
INSERT INTO syll_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Teu Isʼhak Gerar ṭauno roila. ");
INSERT INTO syll_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ar hinor manshe tan bour ḳota zikaile, tain ḳoila ein amar boin. Enre bou ḳoite tain ḍoraila, mone ḳorla, Rebeka shundori koria hinor manshe Rebekare neoar lagi tanre kun ḳoriliba. ");
INSERT INTO syll_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isʼhak bout din hono roar bade eḳdin Filistini oḳlor bashsha Abimalike tan kiṛki baedi saia deḳla, Isʼhake tan bibi Rebekare maya ḳorra. ");
INSERT INTO syll_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Dekia tain Isʼhakre neoaia ḳoila, “Deḳoukka, Rebeka to ashole afnar bibi, te afne ḳene tanre afnar boin ḳoila?” Isʼhake zuaf dila, “Ami mone ḳorslam tair lagi amar zan araimu.” ");
INSERT INTO syll_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Teu Abimalike ḳoila, “Amrar loge afne ita kita bebohar ḳorla? Zekunu manshe to afnar bibir loge mila-misha ḳorto sailo one ar afne amrare dushi banaila one.” ");
INSERT INTO syll_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Bade Abimalike hoḳol manshore ou hukum zari korla, ḳeu zudi Isʼhak ba tan bibir shorilo at dey, tare nisoy zane mara oibo. ");
INSERT INTO syll_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ar Isʼhake hi boros ḳet ḳoria tan zomino rua bis taki eḳ-sho gun beshi foshol faila, Mabude tanre oula borkot nazil ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Tan ḳali baṛte-u laglo, aste aste tain kub maldar oigela. ");
INSERT INTO syll_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Tan goru-sagol ar gulam-bandi oula baṛlo zen, ita dekia Filistini oḳole ingshaita lagla. ");
INSERT INTO syll_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ar tan baf Ibrahimor amolo, tan gulam oḳole ze kua oḳol kudisla, Filistini oḳole iguin maṭidi boria bond ḳorilaisla. ");
INSERT INTO syll_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Bade Abimalike Isʼhakre ḳoila, “Afne amrar ges tone zaukkagi, afne to amra tone beshi shoktiala oigesoin.” ");
INSERT INTO syll_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ou Isʼhake hon tone horia gia Gerar mora gangor soro tambu gaṛia roila. ");
INSERT INTO syll_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ar tan baf Ibrahimor amolor kuda kuain, tain hirbar kudila, ḳaron Ibrahimor moutor bade Filistini oḳole ita borilaisla. Ar tan bafe ou kuaintor ze nam raḳsla, tain-o ou nam raḳla. ");
INSERT INTO syll_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isʼhakor gulam oḳole ou gangor soro kudia fanir futala ek kua faila. ");
INSERT INTO syll_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ar Geraror raḳal oḳole tan raḳal oḳlor loge dorbar ḳoria ḳoilo, i fani amrar. Ou tain i kuar nam raḳla Eshok mani, dorbar. ");
INSERT INTO syll_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Bade Isʼhakor raḳal oḳole aro ek kua kudila, ar iṭa loia-o tara dorbar ḳorla. Ou tain iṭar nam raḳla Siṭna mani, dushmoni. ");
INSERT INTO syll_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Heshe tain hon tone horia gia aro ek kua kudaila, ifira tara ar kunu dorbar ḳorla na. Teu Isʼhake ou kuar nam raḳla Rohobot mani, bout zaga. Tain ḳoila, “Oḳon Mabude-u amrare bout zaga dila, amra i desho aro baṛtam farmu.” ");
INSERT INTO syll_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Bade Isʼhake hon tone horia Ber-Shebat gelagi. ");
INSERT INTO syll_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Hou rait-u Mabude tanre didar dia ḳoila, “Ami tumar baf Ibrahimor Alla. Tumi ḍoraio na, amar gulam Ibrahimor ḳatire ami tumar loge asi. Ami tumare borkot nazil ḳormu ar tumar bongsho baṛaimu.” ");
INSERT INTO syll_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ou Isʼhake hono ekkan kurbani kana banaia Mabudor nam loila. Hono tain tan tambu gaṛila ar tan gulam oḳole ek kua kudila. ");
INSERT INTO syll_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Bade Abimalike tan uzir Ohuzot ar shenapoti Fikulre loia Gerar taki Isʼhakor gese aila. ");
INSERT INTO syll_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isʼhake erare ḳoila, “Afnara amar gese kitar lagi aila? Afnara to ingsha ḳoria amare afnarar ges tone ḳedai dilaisoin.” ");
INSERT INTO syll_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Tara ḳoila, “Amra oḳon saf buziar zen, Mabud afnar loge asoin. Erlagi afnar loge amrar egu oada oizauk. Aukka, amra eḳ chukti korilai. ");
INSERT INTO syll_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Amra zela afnare soisi na ar afnar balai saṛa kunu ḳeti korsi na, zela afnare shantie bidae disi, oula afne-o amrare ḳeti korta na. Afne-u to Mabudor borkotor manush.” ");
INSERT INTO syll_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Bade Isʼhake tarar lagi kana-dana zuit ḳorle, tara ḳana-dana ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Bador din biane uṭia tara duiozone ḳosom ḳorla. Ar Isʼhake tarare bidae dile, tara dilor maze shanti faia roana oila. ");
INSERT INTO syll_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Hou din-u tan gulam oḳole aia tarar kuda ek kuar ḳobor zanaila, tara fanir lagal faisoin. ");
INSERT INTO syll_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ou tain er nam dila Sheba mani, ḳosom. Erlagi aiz-o hinor nam Ber-Sheba roise. ");
INSERT INTO syll_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ishe sallish boros boyosho Hiṭṭi Berir fuṛi Zihudit ar Hiṭṭi Elonor fuṛi Bashomotre shadi korla. ");
INSERT INTO syll_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","I duio beṭie Isʼhak ar Rebekar zanor maze kub duk dila. ");
INSERT INTO syll_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Murobbi boyosho Isʼhakor souḳor zuti komi zaoae tain ar souke deḳta na. Tain tan boṛo fua Ishʼre anaia ḳoila, “Babare.” Ishe zuaf dila, “Ounu ami.” ");
INSERT INTO syll_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Tain ḳoila, “Deḳo, ami to buṛa oigesi, kundin morizimu ḳoitam fariar na. ");
INSERT INTO syll_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Tumi egu ḳam ḳoro; tumar atiar, tir-donuk loia zongolo shikaro zao, ar amar lagi kunta shikar ḳoria, ");
INSERT INTO syll_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","amar fosondor bala ḳani toiar ḳori ano, teu morar age ita ḳaia amar zane tumare dua dibo.” ");
INSERT INTO syll_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Isʼhake zebla tan fua Ishʼor loge ita matira, i shomoy Rebekae ita hunchila. Teu Ish zebla shikaro gelagi, ");
INSERT INTO syll_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","tain aia tan fua Iakubre ḳoila, “Huno, ami hunlam tumar bafe tumar bai Ishʼre ḳoira, ");
INSERT INTO syll_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Tumi amar lagi kunta shikar ḳori bala ḳani toiar ḳoro, teu ami morar age ota ḳaia, Mabudor samne tumare dua dimu.’ ");
INSERT INTO syll_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Te re fut, ami tumare oḳon zeta ḳortae ḳoimu, tumi oula hunio. ");
INSERT INTO syll_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Tumi gia fal taki duiṭa taza ḳoshi ano. Ami itadi tumar bafor shoḳor ḳani, asanoḳ moza ḳori randia dei. ");
INSERT INTO syll_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Teu tumi ota loia tumar bafor gese zaio, tain ita ḳaia morar age tumare dua ḳorba.” ");
INSERT INTO syll_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Iakube tan maʼre ḳoila, “Huno, amar bai Ishʼor shoril to ruma-ala, amar shorilo to ruma nae. ");
INSERT INTO syll_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Zudi babae amar shorilo atain, te mono ḳorba ami tane duka diar, taile ami duar bodla aro lannot ḍakia anmu.” ");
INSERT INTO syll_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Teu tan maʼe ḳoila, “Futre, tumar i lannot amar ufre-u foṛouk. Tumi kali amar matḳan huno ar ḳoshiguin ania deo.” ");
INSERT INTO syll_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ou Iakube gia ḳoshi ania tan maʼre dila. Ar tan bafe zela shok koroin, tain oula moza ḳori randila. ");
INSERT INTO syll_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Bade tain goror maze toa boṛo fua Ishʼor bala bala ḳafoṛ-sufoṛ ania tan huru fua Iakubre findaila. ");
INSERT INTO syll_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Iakubor ato ar golat ze zagat ruma nae, hou zagat ou ḳoshir samṛa lagai dila. ");
INSERT INTO syll_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ar nizor randa hou mozar ḳani ar ruṭi tan fua Iakubor ato dila. ");
INSERT INTO syll_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Iakube tan bafor gese gia ḍaḳ dila, “Baba.” Isʼhake zuaf dila, “Ounu ami, tumi ke re fut?” ");
INSERT INTO syll_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Iakube tan bafre ḳoila, “Ami afnar boṛo fua Ish. Afne amare zela ḳoisla, ami oula ḳorsi. Doya ḳori uṭia boukka, amar shikaror gust ḳaukka, ḳaia harle afne amare dua diba.” ");
INSERT INTO syll_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isʼhake tan fuare ḳoila, “Babare, tumi oto zoldi shikar failae kila?” Tain ḳoila, “Afnar Mabud Allae milai disoin.” ");
INSERT INTO syll_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ou Isʼhake Iakubre ḳoila, “Baba, amar ḳasat ao teu tumar gotro at dia buzmu, tumi hasau amar fua Ish ni.” ");
INSERT INTO syll_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Iakub tan baf Isʼhakor aro ḳasat gela. Tain shorilo ataia ḳoila, “Golar aoazṭa Iakubor, oile at duioḳan to Ishʼor.” ");
INSERT INTO syll_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Iakubor at tan bai Ishʼor moto rume bora asil ḳori Isʼhake tanre sinla na. Ou tain Iakubre dua dila. ");
INSERT INTO syll_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Tain zikaila, “Tumi kita hasau amar fua Ish ni?” Iakube ḳoila, “Ji oy baba.” ");
INSERT INTO syll_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ou Isʼhake ḳoila, “Fuar shikaror gust amar gese ano, ita ḳaia harle amar zane tumare dua dibo.” Iakube gust loia aile tain ḳaila. Bade tanre anguror shorbot dile tain eota ḳaila. ");
INSERT INTO syll_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Heshe tan bafe ḳoila, “O fut ao, ḳasat aia amare hunga deo.” ");
INSERT INTO syll_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ou Iakube ḳasat gia hunga dila, ar Isʼhake tan shorilor ḳafoṛor geran hungia tanre dua dila, “Deḳo, amar fuar geran to Mabudor borkoti ketor geranor laḳan. ");
INSERT INTO syll_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Allae asmanor kua tone ar roshail zomin tone tumare deukka; bout foshol ar anguror shorbot tumare deukka. ");
INSERT INTO syll_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Hoḳol manush tumar gulam ouk, hoḳol zatie tumar gese mata nuauk. Nizor zator maze tumi boṛo murobbi o, tumar maʼr feṭor baiainte tumar gese mata nuauk. Ze tumare lannot dibo, tar ufre lannot foṛouk. Ze tumare dua ḳorbo, he rohomoti ouk.” ");
INSERT INTO syll_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isʼhake Iakubre dua ḳora shesh oile, Iakub tan baf Isʼhakor samne tone horte-u, tan bai Ishe shikar loia goro aila. ");
INSERT INTO syll_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Tain-o bala ḳani toiar ḳoria bafor gese loia aia ḳoila, “Baba, uṭia boia afnar fuar shikaror gust ḳaukka, ḳaia harle afnar zane amare dua diba.” ");
INSERT INTO syll_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ou tan bafe ḳoila, “Tumi ke?” Tain ḳoila, “Baba, ami to afnar boṛo fua Ish.” ");
INSERT INTO syll_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ar Isʼhakor shorilo bezuita ḳafa shuru oilo. Ḳafi kafi tain ḳoila, “Taile amar gese shikaror gust loia ze aisil, igu ḳe? Tumi aibar age-u ami ota ḳaia tare dua disi, ar duar fol he-u faibo.” ");
INSERT INTO syll_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Bafor mat hunia-u Ishe ekebare buk bangia sillaia tan bafre ḳoila, “Bazan, amare, amare-o dua ḳoro!” ");
INSERT INTO syll_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isʼhake ḳoila, “Tumar baie aia soturi koria tumar faona dua nisegi.” ");
INSERT INTO syll_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ishe ḳoila, “Tar nam Iakub mani, dukabaz nae ni? Hasau he duibar amare duka dise. Boṛo fua hishabe amar malikana he age suri kori nisil, ar deḳoukka, ifira amar dua-o loia gelogi.” Tain firia ḳoila, “Afne amar lagi kunu dua-u raḳsoin na ni?” ");
INSERT INTO syll_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isʼhake zuaf dila, “Huno, ami tare tumar neta banaisi, ar tar gusṭire tar gulam banaisi, tare foshol ar anguror shorbot dia samani korsi; oḳon tumar lagi ar kita ḳortamre fut?” ");
INSERT INTO syll_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ishe firia tan bafre ḳoila, “O bazan, afnar gese kita ou eḳ dua-u asil ni? Bazan reba, afne amare, amare-o dua ḳoroukka!” Ota ḳoia tain zure zure sillaia ḳandat lagla. ");
INSERT INTO syll_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ou tan baf Isʼhake ḳoila, “Tumar boshotḳanar maṭi nirosh oibo, hino asmanor kua-o foṛto nae. ");
INSERT INTO syll_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Toluar-u tumar zindegi oibo, ar nizor bair gulam oibae; oile zebla tumi na-manra oizibae, ou shomoy nizor gordona taki tar zual horaibae.” ");
INSERT INTO syll_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Iakube tan bafor ges tone dua faisla ḳori Ishe tanre ingshaita lagla. Ishe mone mone ḳoila, “Amar bafor lagi moutor ḳandonor din aichche. Erbade-u tare kun ḳormu.” ");
INSERT INTO syll_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Rebekae tan boṛo fua Ishʼor ita mata-mati hunla, teu huru fua Iakubre anaia ḳoila, “Huno, tumar bai Ishe tumare kun ḳorar niote dilre bandilaise. ");
INSERT INTO syll_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Amar fut, tumi amar matḳan huno, tumi Haran ṭauno amar bai Labonor gese horia zaogi, ");
INSERT INTO syll_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ar tumar bair gusa na ḳoma forzonto tan gese taḳo. ");
INSERT INTO syll_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Tar gusa ḳomigele, tumi tar loge zeta ḳorso ita he faurilile, ami kobriadi tumare anaimu. Kitallagi ami eḳdine tumra duiozonre araitam?” ");
INSERT INTO syll_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Bade Rebekae Isʼhakre ḳoila, “Ou Hiṭṭi fuṛintor lagi amar ar basar shad nai. Iakube-o zudi ou laḳan, i deshor kunu Hiṭṭi fuṛire shadi korilae, taile amar ar basia-u lab kita?” ");
INSERT INTO syll_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Rebekar mat hunia Isʼhake, Iakubre anaia dua ḳorla ar ou hukum dila, “Tumi Kenan deshor kunu fuṛire bia ḳorio na. ");
INSERT INTO syll_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Tumi Foddon-Iram desho tumar nana Botuelor baṛit zaogi, hono tumar mamu Labonor kunu fuṛire bia ḳorio. ");
INSERT INTO syll_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Shorbo-shoktiman Allae tumare borkot nazil ḳoroukka ar foldar ḳoria bout baṛaukka, zate ḳori tumi bout gusṭiala zati o. ");
INSERT INTO syll_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ze borkot tain Ibrahimre nazil ḳorsla, hou borkot tain tumare ar tumar bongshore dan ḳoroukka. Ar ze desh Allae Ibrahimre disoin, zeḳano tumi oḳon musafir aso, i deshḳan zanu tumar oy.” ");
INSERT INTO syll_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Bade Isʼhake Iakubre bidae dila, ar tain Foddon-Iramo Orami Botuelor fua Labonor gese roana oila. Labon oila Rebekar bai, Iakub ar Ishʼor mamu. ");
INSERT INTO syll_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ishe zebla hunla, Isʼhake Iakubre dua ḳoria bia ḳoranir niote Foddon-Iramo faṭaisoin ar Kenani fuṛintore bia ḳorte nished ḳorsoin, ");
INSERT INTO syll_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ar Iakube tan ma-bafor hukume Foddon-Iramo gesoingi, ");
INSERT INTO syll_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ou Ishe buzla zen, tan baf Isʼhak Kenani beṭintor ufre kushi nae. ");
INSERT INTO syll_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Erlagi dui bou taḳle-o tain Ibrahimor fua Ismailor gese gia tan fuṛi Moholotre bia ḳorla. Moholot oila Nabautor boin. ");
INSERT INTO syll_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Ar Iakube Ber-Sheba saṛia tan mamur baṛi Haran ṭaunor bae roana dila. ");
INSERT INTO syll_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Foto eḳ zagat shuruz ḍubi gele tain hono-u rait ḳaṭaila. Honor fattordi hitan dia Iakube gumaita ḳori hutila. ");
INSERT INTO syll_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Hutia harle kuabe deḳla, duniair ufre ekkan moi ubai roise, i moir mata asmano lagail. Tain deḳla Allar firista oḳole ogubae uṭa-nama ḳorra, ");
INSERT INTO syll_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","ar Mabude er ufre ubaia ḳoira, “Ami Mabud, tumar baf-dadain Ibrahimor Alla ar Isʼhakor Alla. Tumi ou ze zomino hutiso, iṭa ami tumare ar tumar oarish oḳolre dimu. ");
INSERT INTO syll_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Tumar oarish oḳol duniair duil-balur laḳan behishab oiba. Ar fube-foisme, utore-douḳne sairobae meliziba. Tumi ar tumar bongshor mazedi duniair hokkol zatie borkot hasil ḳorba. ");
INSERT INTO syll_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ami tumar loge loge asi, tumi zeno-u zao na ḳene ami tumare hefazot ḳormu ar ou desho hirbar tumare firaia anmu. Ami tumare zeta zeta ḳoisi ita hasil oar age, tumare saṛtam nae.” ");
INSERT INTO syll_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Bade Iakube gum taki uṭia ḳoila, “Taile hasau Mabud ino asoin, ami to zantam na.” ");
INSERT INTO syll_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ou tain ḍoraia ḳoila, “Kizat gorom i zaga! Ikan nichchoy Allar gor, oḳano-u behestor duar.” ");
INSERT INTO syll_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Tain fozoror shomoy uṭia, ze fattorṭa tan matar tole hitan disla, ikṭa kuṭir moto ḳori gaṛia er ufre tel ḍalila. ");
INSERT INTO syll_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ar hi zagar nam raḳla Betel mani, Baytulla, inor agor nam asil Luz. ");
INSERT INTO syll_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Bade Iakube ḳosom ḳaia ḳoila, “Allae zudi amar i soforo hefazot ḳoroin, tain amar ḳani-kuraḳ, findar lebas zugai dein, ");
INSERT INTO syll_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ami hirbar sohi-salamote bafor baṛit firia ai, te ou Mabudre-u amar Alla manmu. ");
INSERT INTO syll_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ar ou ze fattor ami kuṭi gaṛia toilam, ono Baytulla Shorif oibo. Ar tumi amare zotota dibae, er dosh baṭor eḳ baṭ ami nichchoy tumare dilaimu.” ");
INSERT INTO syll_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Bade Iakube aṭi aṭi fubor deshor manshor elaḳat gelagi. ");
INSERT INTO syll_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Gia honor bondor maze ek kua deḳla. Hou kuar gese tin fal meṛa huti roise; raḳal oḳole on tone tarare fani kaoain. Ar kuar muko boṛo eḳ fattor toa oise. ");
INSERT INTO syll_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Hoḳol meṛar fal zebla ekḳano oito, teu raḳal oḳole kuar muk tone fattorgu horai dia meṛaintore fani kaoaito. Bade fattorre hirbar kuar muko toito. ");
INSERT INTO syll_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Iakube tarare zikaila, “Bai oḳol, afnara kun zagar manush?” Tara ḳoila, “Haran ṭaunor.” ");
INSERT INTO syll_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ou tain ḳoila, “Afnara Nahuror nati Labonre sinoin ni?” Tara ḳoila, “Ji oy, sini.” ");
INSERT INTO syll_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Iakube zikaila, “Tain bala asoin ni?” Tara ḳoila, “Ji oy, bala asoin. Ounu tan fuṛi Rahelae meṛar fal loia aira.” ");
INSERT INTO syll_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Tain ḳoila, “Deḳoukka, oḳono bout beil ase. Te foshu oḳol ekḳano oibar shomoy to oise na. Afnara meṛaintore fani kaoaia hirbar raḳat loia zaingi.” ");
INSERT INTO syll_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Tara ḳoila, “Na, amra ila ḳortam fari na, hokkol fal ekḳano dola oile bade kuar muk tone fattor horaia amra meṛaintore fani kaoai.” ");
INSERT INTO syll_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Tain oḳono tarar loge mato roisoin, ou shomoy Rahelae tan bafor meṛar fal loia ono aila, tain i falor raḳalit asla. ");
INSERT INTO syll_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Iakube tan mamu Labonor fuṛi Rahelare ar tan meṛar fal dekia-u kuar gese gia kuar muk tone fattorṭa horaia meṛaintore fani kaoaila. ");
INSERT INTO syll_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Bade tain Rahelare maya dia zure zure ḳandita lagla. ");
INSERT INTO syll_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ar tain Rahelare ḳoila zen, tain Labonor baigna, Rebekar fua. Ou Rahelae douṛaia gia tan bafre i kobor dila. ");
INSERT INTO syll_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labone tan baigna Iakubor ḳobor hunia douṛaia tan loge deḳa ḳorat aila. Tanre ainja ḳori doria hunga dia baṛit loia gela. Gia harle Iakube Labonre tan aibar hokkolta zanaila. ");
INSERT INTO syll_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Labone ḳoila, “Tumi to amar-u zan ar amar-u gust.” Ar Iakub Labonor baṛit eḳ mash roila. ");
INSERT INTO syll_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Eḳ mash bade Labone Iakubre ḳoila, “Tumi amar kuṭum oilae ḳori bina betone amar saḳri kortae ni ba? Tumare kita ditam, ḳoilao.” ");
INSERT INTO syll_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labonor duiṭa fuṛi asil. Boṛogur nam Lea ar hurugur nam Rahela. ");
INSERT INTO syll_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lear ḳali souk-u shundor asil, oile Rahelar goṭon ar sehara-surot, hokkolta shundor asil. ");
INSERT INTO syll_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Iakube Rahelare fosond ḳorta ḳori tain ḳoila, “Afnar huru fuṛi Rahelar lagi ami shat boros afnar gulami kormu.” ");
INSERT INTO syll_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labone ḳoila, “Rahelare manshor ato deoar saite tumar gese deoa-u bala. Tumi amar gese ro.” ");
INSERT INTO syll_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Teu Iakube Rahelar lagi shat boros gulami korla. Rahelare mohobbot ḳorta ḳori, ita eḳo boros tan gese eḳ dinor homan mono oilo. ");
INSERT INTO syll_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Heshe tain Labonre ḳoila, “Amar gulamir miad furi gese. Oḳon amar boure amar ato shomzaia deukka, ami tair gese roitam sai.” ");
INSERT INTO syll_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Teu Labone hou elaḳar hoḳol manshore biar daot ḳoria ḳana-dana ḳaoaila. ");
INSERT INTO syll_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Heshe rait oile tain tan fuṛi Leare Iakubor gese dila, ar Iakube en loge roila. ");
INSERT INTO syll_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labone nizor bandi Zilpare, tan fuṛi Lear bandi girit dila. ");
INSERT INTO syll_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Oile biane uṭia deḳoin, ein to Lea. Teu Iakube Labonre ḳoila, “Afne amar loge ita kun zator ḳam ḳorla? Oto din ami Rahelar lagi afnar gulami korsi nae ni? Te amare duka dila ḳene?” ");
INSERT INTO syll_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labone ḳoila, “Boṛo fuṛir age huru fuṛir bia deoa amrar deshor sol nae. ");
INSERT INTO syll_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Tumi biar kushi-bashir haftaṭa faroite deo. Teu hi fuṛire-o tumar gese bia dimu, oile tumi aro shat boros amar gulami korte oibo.” ");
INSERT INTO syll_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Iakube tan ḳota mania ou kushi-bashir hafta far ḳorla. Bade Labone tan fuṛi Rahelare-o Iakubor gese shadi dila. ");
INSERT INTO syll_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ar tan bandi Bilhare Rahelar bandigirit dila. ");
INSERT INTO syll_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Iakube Rahelar loge-o roila, tain Lear saite Rahelare beshi maya ḳorta. Bade tain aro shat boros tan mamu Labonor gulami korla. ");
INSERT INTO syll_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Oile Leare maya na ḳorae, Mabude Leare hurutta foydar ḳemota dila, ar Rahela niaoladi roila. ");
INSERT INTO syll_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Ar Lear goro eḳ fua oilo. Tain fuar nam raḳla Ruben mani, fuare deḳo. Tain ḳoila, “Mabude amar duk deḳsoin, oḳon nichchoy amar zamaie amare maya ḳorba.” ");
INSERT INTO syll_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Bade hirbar tan goro eḳ fua oilo. Tain fuar nam raḳla Shimion mani, hunoin, tain ḳoila, “Amare elami korar ḳota Mabude hunchoin, erlagi tain amare ou fua disoin.” ");
INSERT INTO syll_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Bade hirbar tan goro eḳ fua oilo. Tain ḳoila, “Oḳon amar zamaie amar loge ashik oiba, tan tinṭa fua amar feṭ tone foyda oilo.” Ou er nam raḳla Lebi mani, ashik. ");
INSERT INTO syll_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Bade hirbar tan aro eḳ fua oile tain ḳoila, “Ifira ami Mabudor tarif ḳormu.” Ar tain ou fuar nam raḳla Ehuda mani, tarif. Erbade tan hurutta oa bond oigelo. ");
INSERT INTO syll_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rahelae zebla deḳla, tan goro Iakubor kunu aolad oira na, ou shomoy tan bonir bae ingsha foyda oilo. Tain Iakubre ḳoila, “Amare aolad deo, naile ami morizimu!” ");
INSERT INTO syll_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Teu Rahelar loge Iakube kub gusa ḳoria ḳoila, “Ami kunu Alla ni? Tain-u to tumar feṭ bond ḳori disoin.” ");
INSERT INTO syll_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rahelae ḳoila, “Hunoukka, amar bandi Bilha ono ase, afne tair gese zaukka, tairedi hurutta faia ami-o hurutta-ala oizitam fari.” ");
INSERT INTO syll_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Oḳan ḳoia hari Rahelae tan bandi Bilhare Iakubor gese hanga dila, ar Iakub tair gese roila. ");
INSERT INTO syll_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Teu Bilhar goro Iakubor eḳ fua oilo. ");
INSERT INTO syll_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ar Rahelae ḳoila, “Allae amare insaf ḳorsoin, ar amar ahazari hunia egu fua disoin.” Tain i fuar nam raḳla Dan mani, insaf. ");
INSERT INTO syll_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bade Rahelar bandi Bilhar goro hirbar Iakubor dusra fua foyda oilo. ");
INSERT INTO syll_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ar Rahelae ḳoila, “Boinor loge moha laṛait ami zitsi.” Ou tain i fuar nam raḳla Noftali mani, laṛai. ");
INSERT INTO syll_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leae zebla deḳla tan goro ar hurutta oira na, teu tain-o tan bandi Zilpare Iakubor gese hanga dila. ");
INSERT INTO syll_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Teu Lear bandi Zilpar feṭo Iakubor eḳ fua oilo. ");
INSERT INTO syll_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ar Leae ḳoila, “Amar ḳofal kulche!” Tain er nam raḳla Sadu mani, ḳofal. ");
INSERT INTO syll_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Bade Lear bandi Zilpar goro Iakubor aroḳ fua oilo. ");
INSERT INTO syll_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ar Leae ḳoila, “Amar ḳoto shuk! Hoḳol beṭinte amare shuki koiba.” Teu tain i fuar nam raḳla Ashir mani, shuki. ");
INSERT INTO syll_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Gom daoar shomoy Rubene bondo gia kisu dutra-guṭa faia, tan ma Lear gese ania dila. Ar Rahelae Leare ḳoila, “Tumar fuar ḳoygu dutra-guṭa amare deo sain.” ");
INSERT INTO syll_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leae ḳoila, “Tumi amar zamaire doḳol ḳorso, itae oise na ni? Oḳon amar fuar dutra-guṭa-o sairae ni?” Rahelae ḳoila, “Taile tumar fuar dutora-guṭar bodla aiz rait tain tumar loge roiba ne.” ");
INSERT INTO syll_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Hainja bala Iakube bondo tone aite-u Leae bar oia tane ḳoila, “Aiz amar loge roibae, ḳaron amar fuar dutora-guṭar bodla ami tumare aolat nisi.” Ou hi rait tain Lear goro hutila. ");
INSERT INTO syll_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Allae Lear dua kobul ḳorae, tan goro Iakubor fas nombor fuar zonom oilo. ");
INSERT INTO syll_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ou Leae ḳoila, “Amar zamair gese amar bandire dislam ḳori, Allae amare er bodla dila.” Erlagi tain i fuar nam raḳla Isaḳor mani, bodla. ");
INSERT INTO syll_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Bade hirbar Lear goro Iakubor soy nombor fuar zonom oilo. ");
INSERT INTO syll_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Leae ḳoila, “Allae amare bout boṛo eḳ niamot dila. Oḳon amar zamaie amare dam diba, ḳaron ami tan soygu fuar zonom disi.” Tain i fuar nam raḳla Sobulon mani, dam. ");
INSERT INTO syll_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Heshe Lear eḳ fuṛi oilo, tair nam raḳla Dina. ");
INSERT INTO syll_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Allae Rahelar bae-o kial ḳorla. Tain Rahelar dua kobul ḳoria, tanre hurutta foydar takkot dila. ");
INSERT INTO syll_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ar Rahelar goro eḳ fua oile tain ḳoila, “Allae amar shorom horaisoin.” ");
INSERT INTO syll_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Tain i fuar nam raḳla Iusuf mani, baṛani. Tain ḳoila, “Mabude amare arogu fua baṛai deukka.” ");
INSERT INTO syll_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rahelar goro Iusuf oar bade, Iakube Labonre ḳoila, “Oḳon amare bidae dilaukka, ami nizor deshor baṛit zaigi. ");
INSERT INTO syll_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Afne to zanoin, ami kila afnar gulami korsi, ami amar bouain ar fua-fuṛir lagi afnar gulami korsi. Oḳon tarare loia amare zaite deukka.” ");
INSERT INTO syll_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Labone tanre ḳoila, “Amar lagi zudi tumar maya taḳe, te zaio na. Ami alamote buziar zen, tumar ḳatire Mabude amare-o borkot nazil ḳorsoin. ");
INSERT INTO syll_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Tumar beton tumi nize-u ḳoilao. Ami tumare ola-u dimu.” ");
INSERT INTO syll_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ou Iakube tanre ḳoila, “Ami kila afnar gulami korsi, ar amar ato afnar foshur fal kilaḳan oise, ita afne-u zanoin. ");
INSERT INTO syll_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ami aoar age afne gorib asla. Ar oḳon to baṛia boutta oise. Amar ḳarone Mabude afnare bout borkot disoin. Oile amar nizor foribaror lagi kundin ḳamai kortam?” ");
INSERT INTO syll_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Teu Labone ḳoila, “Ami tumare kita ditam?” Iakube ḳoila, “Afne amare kunta-u na dia zudi amar egu mat raḳoin, te ami hirbar afnar foshur falor kezmot ḳormu. ");
INSERT INTO syll_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ami aiz afnar foshur falor maze gia, fuṭa fuṭa dagala ar ḳala ar sitra meṛain ar sagolor maze sitra ar fuṭa fuṭa rongor hokkolṭi amar beton babot nimugi. ");
INSERT INTO syll_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Teu afne zebla-u betonor ḳarone aiba, i shomoy deḳba, amar imandarie amar lagi zuaf dibo. Ar fuṭa fuṭa dagala ar ḳala ar sitra meṛain ar sagolor maze sitra ar fuṭa fuṭa rongorta saṛa ar kunta faile mono ḳorba, ami suri korsi.” ");
INSERT INTO syll_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Ou Labone ḳoila, “Aichcha, tumar ḳota-u ṭik taḳouk.” ");
INSERT INTO syll_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Labone hou din-u fal taki lamba dagala ar sitra sagol, fuṭa fuṭa dag ar sitra tuṛa tuṛa dola sagin ar ḳala meṛa oḳol algaia nizor fuaintor gese dilaila. ");
INSERT INTO syll_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Dia tain Iakubor ges taki tin dinor fot duroi horia gelagi ar Iakube Labonor baki fal oḳolre raḳat roila. ");
INSERT INTO syll_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Iakube libni, lauz ar armun gasor ḳasa ḍal ḳaṭia ufre taki baḳol falaia ḍalor maze lamba lamba dola dag dila. ");
INSERT INTO syll_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Sagolor fale aia zeḳano fani kain, tain ou baḳol falail dagala ḍal oḳol, hono fanir gamlar samne toila. Ar fani kaoar shomoy era fal ḳaito. ");
INSERT INTO syll_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Teu ou ḍalor gese aia fal ḳaoae tarar baichchain-o sitra, lamba dagala ar fuṭa fuṭa rongor oita. ");
INSERT INTO syll_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Bade tain ou baichchain algaita, ar Labonor ḍura-ala ar ḳala meṛaintor bae meṛintor souk raḳaita. Ou laḳan tain, tan nizor falre Labonor falor loge milaita na. ");
INSERT INTO syll_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ar zurala meṛi-saginte fal ḳaoar shomoy, tain gamlat tarar souḳor samne ou ḍal oḳol toita, ");
INSERT INTO syll_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","oile ḳomzur foshur samne i ḍalain toita na. Teu Labonor foshuin oita ḳomzur, ar Iakubor foshuin oita zurala. ");
INSERT INTO syll_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ou laḳan ḳam ḳoria tain bout doni oila. Tan gulam-bandi, uṭ-gada ar foshur fal bout baṛigelo. ");
INSERT INTO syll_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Bade Iakubor ḳano ailo Labonor fuainte matira zen, “Iakube amrar bafor hokkolta nisegi, ar amrar bafor mal dia-u he maldar oigese.” ");
INSERT INTO syll_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ar Iakube-o kial ḳorla, tanbaedi Labonor agor hi monor bab ar nae. ");
INSERT INTO syll_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Mabude Iakubre ḳoila, tumi tumar baf-dadar desho nizor manshor gese firia zaogi. Ami tumar loge taḳmu. ");
INSERT INTO syll_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ou Iakube ḳobria faṭaia Lea ar Rahelare bondo tan foshur falor gese anaia ḳoila, ");
INSERT INTO syll_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","“Ami tumartanor bafor muk dekia buziar, tan agor hi monor bab amar bae nae, oile amar bafor Mabud Alla amar loge loge roisoin. ");
INSERT INTO syll_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Tumitain to zano zen, ami amar hoḳol shokti dia-u tan ḳoto gulami korsi, ");
INSERT INTO syll_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ta-o tain amare ṭogisoin ar dosh-doshbar ḳoria amar beton bodlaisoin, oile Allae amar kunu ḳeti oite disoin na. ");
INSERT INTO syll_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Tain zebla ḳoila, tumar beton oibo, fuṭa fuṭa rongor foshu, teu falor hoḳol foshue ou laḳan baichcha dilo. Hirbar tain zebla ḳoila, tumar beton oibo ḍura-ala foshu, teu falor hoḳol foshue ḍura-ala baichcha dilo. ");
INSERT INTO syll_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Allae ou laḳan ḳori tan falor foshu ania amare disoin. ");
INSERT INTO syll_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Eḳbar foshuinte fal ḳaoar shomoy ami kuabe deḳlam, meṛi-sagintor ufre ze faṭa oḳol uṭira, iguin ḍura-ala, sitra ar fuṭa fuṭa rongor. ");
INSERT INTO syll_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Kuabor maze Allar firistae amare ḍakila, ‘Iakub!’ Ami koilam, ‘Ounu ami.’ ");
INSERT INTO syll_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Tain ḳoila, ‘Tumi souk tulia deḳo, meṛi-sagintor ufre zeta faṭain uṭira, hokkolṭi ḍura-ala, sitra ar fuṭa fuṭa rongor. Labone tumar loge zeta zeta ḳorse, ita hoḳolta-u ami deḳsi. ");
INSERT INTO syll_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ami hou Betelor Alla, zeno tumi kuṭir ufre tel ḍalia amar name ḳosom ḳorslae. Oḳon solo, i desh saṛia tumar zonom maṭit firot zao.’ ” ");
INSERT INTO syll_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ou Lea ar Rahelae ḳoila, “Babar shompottir kunu dabi ar amrar roilo ni? ");
INSERT INTO syll_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Tain to amrare begana manush mono ḳoria, amrare besilaisoin ar amrar hokkolta-u ḳailisoin. ");
INSERT INTO syll_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Erlagi Allae amrar babar samana tone zotota nisoin, i hokkolṭi-u oḳon amrar ar amrar aolador oise. Te Allae tumare zela hukum ḳorsoin, tumi-o oula ḳoro.” ");
INSERT INTO syll_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Bade Iakube tan huruttain ar bibintore uṭor ufre tulia, ");
INSERT INTO syll_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Foddon-Iramo tan ḳamail foshu oḳol ar mal-samana hokkolta loia, Kenan desho tan baf Isʼhakor gese roana dilaila. ");
INSERT INTO syll_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Hou shomoy Labone tan meṛaintor ruma ḳaṭar lagi gesla, ar ou faḳe Rahelae tan bafor murti oḳol suri korilila. ");
INSERT INTO syll_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Iakube tan zaoar ḳota Orami Labonre na zanaia tanre ṭogila. ");
INSERT INTO syll_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ar tain hokkolta loia bagia, Furat gang faroia Giliodor faṛor samnedi zaoat roila. ");
INSERT INTO syll_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Zaoar tin din bade Labone hunla zen, Iakub bagia gesoingi. ");
INSERT INTO syll_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ou tain ḳesh-kuṭumre loia, Iakubor ḳore oia shat dinor fot gia, Giliodor faṛo tarar lagal faila. ");
INSERT INTO syll_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Oile raitor bala Allae kuabe Orami Labonor gese aia ḳoila, “Ḳobordar! Iakubre bala-bura kunta-u ḳoio na.” ");
INSERT INTO syll_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Iakube faṛor maze tambu gaṛisla, ar Labone gia tanre ono-u lagal failila, teu Labon ar tan ḳesh-kuṭum oḳole-o Giliodor hou faṛor maze tambu gaṛila. ");
INSERT INTO syll_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Bade Labone Iakubre ḳoila, “Tumi kene ita ḳorlae? Amare ṭogia amar fuṛintore ḳene zuddor bondir laḳan loia ailae? ");
INSERT INTO syll_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Ḳene tumi duka dia amare na zanaia, lukaia bagia ailae? Amare zanaile to ami kushi-bashi koria, dutara ar mondira bazaia gan gaia, tumare bidae dilam one. ");
INSERT INTO syll_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Tumi amar fuṛintore ar natinoshare-o hunga dite-o dilae na, be-aḳolor moto ḳam ḳorlae. ");
INSERT INTO syll_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Oḳon ami to tumrar ḳeti kortam farmu, oile tumrar baf-dadar Allae goto rait amare ḳoisoin, ‘Ḳobordar! Iakubre bala-bura kunta-u ḳoio na.’ ");
INSERT INTO syll_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Tumar bafor baṛit zaoar lagi mone ḳandisil ḳori, tumi bagia aiso manlam, te amar devta oḳol ḳene suri korlae?” ");
INSERT INTO syll_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Iakube zuaf dila, “Ami ḍoraislam, mono ḳorslam, afne zur ḳoria afnar fuṛintore, amar ges tone ḳaṛia raki diba. ");
INSERT INTO syll_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Te oḳon zar gese afnar devtain faiba, tare zita raḳtam nae. Amrar ḳesh-kuṭmor samne hokkolta tallash ḳoria zudi afnar kunta fain, taile neukkagi.” Hou murti oḳol zen Rahelae suri korsoin, ita to Iakube zanoin na. ");
INSERT INTO syll_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ou Labone Iakub, Lea ar duio bandir tambut hamaia hoḳolta tukaia kunta na faia, heshe Lear tambu tone Rahelar tambut gia hamaila. ");
INSERT INTO syll_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rahelae i murti oḳol nia uṭor goddir bitre toia, tain ou goddir ufre boila. Labone tan tambur hoḳolta tukaia hono-o ita faila na. ");
INSERT INTO syll_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ar Rahelae tan bafre ḳoila, “Bazan ami uṭia ubaitam fariar na ḳori afne bezar oin na zen, beṭiara bemaror lagi amar shoril ḳaraf.” Ou Labone hi murti oḳol ar tukaia faila na. ");
INSERT INTO syll_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Heshe Iakube gusa oia Labonre siṛaia ḳoila, “Amar oforad kiano? Ami kita dush ḳorsi, afne amar ḳore oia oula ḳedanit aila? ");
INSERT INTO syll_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Amar hoḳol mal-samana aulaia afnar goror kun zinishḳan faila? Faile ita afnar-amar ḳesh-kuṭmor samne raḳoukka, tara amrar bisar ḳorba. ");
INSERT INTO syll_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ami i bish boros afnar loge aslam. Er maze afnar kunu meṛi ba sagir feṭor baichcha nosṭo oise na ba afnar falor kunu meṛa-o ami kaisi na. ");
INSERT INTO syll_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ar zongli zanuare mara kunu foshu-o afnar gese anchi na, ita ami nize-u furia disi. Dino ba rait kunu foshu suri oile, afne amar ges taki boria loisoin. ");
INSERT INTO syll_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ami oula din ḳaṭaisi, dino zolchi gorome ar raite ḳafsi shite. Amar sokut gum aito na. ");
INSERT INTO syll_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ze bish boros afnar baṛit roisi, er souddo boros ami afnar dui fuṛir lagi gulami korsi, ar soy boros gese afnar foshur lagi. Er maze afne dosh-doshbar amar beton-o bodlaisoin. ");
INSERT INTO syll_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Alla Pak, zanre amar baf Isʼhake Mabud hishabe ḍoraita, zein amar dada Ibrahimor-o Mabud, tain zudi amar loge na taḳta, te hasau oḳon afne amare ḳali ate bidae dila one. Allae amar menot ar duk deḳsoin. Erlagi-u tain ḳail rait afnare domḳaisoin.” ");
INSERT INTO syll_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labone Iakubre zuaf dila, “I fuṛin amar-u fuṛin, ar ou huruttain amar-u natinosha, ar i foshur fal oḳol-o amar. Tumi ono zotota deḳrae, hoḳolta-u amar, ta-o amar fuṛintore ba tarar huruttaintore ami ar kita ḳormu? ");
INSERT INTO syll_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ao, amra duiozone eḳ chukti korilai. Ou chuktir nishanaṭa tumar-amar maze shakki roibo.” ");
INSERT INTO syll_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ou Iakube eḳ fattor loia kuṭi gaṛila. ");
INSERT INTO syll_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ar tan ḳesh-kuṭum oḳolre ḳoila, “Afnara-o fattor anoukka.” Teu tara-o fattor ania eḳ biṭa banaila, heshe ou biṭar gese ḳani kaila. ");
INSERT INTO syll_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labone hou biṭar nam raḳla Zigor-Sahoduta mani, shakki-biṭa oile Iakube er nam raḳla Gol-ed. ");
INSERT INTO syll_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labone ḳoila, “Ou biṭa oḳon tone tumar-amar shakki oilo.” Erlagi ou biṭar nam oilo Gol-ed, ");
INSERT INTO syll_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ar ou kuṭir nam oilo Mispa mani, faharar zaga. Labone ḳoila, “Amra zebla horia zaimugi ou shomoy Mabude-u tumar-amar fahara diba. ");
INSERT INTO syll_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Tumi zudi amar fuṛintore duk deo ba amar fuṛin saṛa ar ḳeurore bia ḳoro, taile kunu manush amrar loge na roile-o Alla amrar shakki roila.” ");
INSERT INTO syll_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Labone Iakubre aro ḳoila, “Ou biṭa bae ar ou kuṭir bae sao, iṭa tumar-amar mazḳano ami gaṛlam. ");
INSERT INTO syll_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","I duioṭa tumar-amar shakki roilo. Tumi-o ingsha ḳori ou biṭa ar kuṭi ḍingaia aibae na ar ami-o burair niote ita ḍingaia zaitam nae. ");
INSERT INTO syll_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ibrahimor Alla, Nahuror uforala ar tarar bafor uforalae tumar-amar bisar ḳorba.” Ar Iakube, tan baf Isʼhake zanre ḍoraita tan name ḳosom ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Iakube hou faṛor ufre kurbani koria tan ḳesh-kuṭum oḳolre ḳaoar daoat dila. Ḳaoa-daoa shesh ḳoria hari tara hou faṛor maze rait roila. ");
INSERT INTO syll_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Bador din fozore Labone tan fuṛintore ar natinoshare hunga dia dua ḳorla, heshe tan baṛi muka fot dila. ");
INSERT INTO syll_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Iakub-o tan fote roana oile, Allar firista oḳole tanre deḳa dila. ");
INSERT INTO syll_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Erare dekia tain ḳoila, “Ita Allar fouz.” Ar i zagar nam raḳla Mohonoyim mani, dui fouz. ");
INSERT INTO syll_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Iakube tan age ḳori Seir ba Idum desho, tan boṛo bai Ishʼor gese ḳoyzon ḳobria faṭaila. ");
INSERT INTO syll_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Tain erare hikai dila, “Tumra amar munib Ishʼre ḳoio, tan gulam Iakube ḳoise, ami otodin tone amrar mamu Labonor gese musafirit aslam. ");
INSERT INTO syll_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Amar goru-gada, sagol-meṛa ar gulam-bandi hoḳolta-u ase. Amar munibor gese doya faoar ashae tumrare faṭailam.” ");
INSERT INTO syll_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ḳobria oḳole firia aia Iakubre ḳoila, “Amra afnar bai Ishʼor gese geslam. Tain sair-sho manshore loia afnar loge mulaḳat ḳorat aira.” ");
INSERT INTO syll_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ou Iakube ḍoraia kub ostir oigela. Tain logor hoḳol manshore, goru-sagol, meṛa-meṛi ar uṭ-gada oḳolre dui dole algaila. ");
INSERT INTO syll_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Tain ḳoila, baie aia eḳ dolre hamla ḳorle-o aroḳ dol nirafode roibo. ");
INSERT INTO syll_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ar Iakube dua ḳorla, “O Alla, amar dada Ibrahimor Mabud ar amar baf Isʼhakor Mabud, tumi-u amare hukum ḳorso zen, ‘Tumar desho tumar nizor manshor gese firia zao, teu ami tumare rohom ḳormu.’ ");
INSERT INTO syll_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Tumar i gulamor bae ze rohom ar imandari deḳaiso, ami ita kuntar-u laḳ nae. Ami to egu laṭi loia i Zordan gang faroislam, ar oḳon dui dol oigesi. ");
INSERT INTO syll_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Mabud, ami aroz ḳoriar, amar bai Ishʼor at tone amare basao. Amar ḍor ḳorer, he aia bou fua-fuṛir loge amare-o kun ḳorbo. ");
INSERT INTO syll_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Tumi-u to oada ḳorso, ‘Ami oboshsho-u tumar balai kormu, tumar oarish oḳolre doriar faror balur laḳan behishab ḳormu, zela gonia fuṛae na.’ ” ");
INSERT INTO syll_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Iakube i rait hono roila ar tan zotota asil er maz taki kotoḳan loia tan bai Ishʼor lagi eḳ ufohar toiar ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ita oilo dui-sho sagi, kuṛiṭa sagol, dui-sho meṛi, kuṛiṭa meṛa, ");
INSERT INTO syll_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","tishgu baichcha-ala dudor uṭ, dui kuṛi gai, doshgu bisal, ek kuṛi gadi ar doshgu gada, ");
INSERT INTO syll_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","bade tain eḳ ek gulamor ato eḳ eḳ fal shomzai dia ḳoila, “Tumra amar age oia zao ar eḳ fal taki aroḳ falor maze faḳ rakio.” ");
INSERT INTO syll_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Foyla dolor gulamre tain hikai dila, “Amar bai Ishʼor loge deḳa oar bade zebla zikaiba, ‘Ḳoi zaitae ba? Tumi kar manush? Tumar homḳor foshuin ḳar?’ ");
INSERT INTO syll_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Tumi zuaf dio, ‘Ita afnar gulam Iakubor. Tain amar munib Ishʼor lagi, ita ufohar faṭaisoin. Ar tain amrar ḳore oia aira.’ ” ");
INSERT INTO syll_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ou laḳan tain dui nombor, tin nombor dolor gulam oḳolre-o hikai dila zen, “Ishʼor loge deḳa oile tumra-o oula ḳoio. ");
INSERT INTO syll_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ar heshe ḳoio, afnar gulam Iakub-o amrar ḳore oia aira.” Iakube mono ḳorla, “Age ufohar oḳol faṭaia tane ṭanḍa ḳormu, bade tan loge deḳa-shaikkat ḳormu, te tain amare maya ḳorilita faroin.” ");
INSERT INTO syll_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Tan age oia ufohar oḳol gelogi, oile tain rait tan ḍerat roila. ");
INSERT INTO syll_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Heshe rait uṭia tan duio bibin, duio bandi ar egarogu fuare loia faoe aṭia, Zabbuk kalor hofaro toia aila. ");
INSERT INTO syll_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Tain erare ḳal far ḳoraia tan hoḳol mal-samana-o hono faṭai dila. ");
INSERT INTO syll_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ar tain eḳla ono roila, teu gaibi eḳzon manush aia tan loge raitbor kusta-kusti korla. ");
INSERT INTO syll_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Oile tain Iakubre ḳabu ḳorta na farae en urator zuṛat marla ar Iakubor urator aṛ zaga tone ḍuli gelo. ");
INSERT INTO syll_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Heshe hi manshe ḳoila, “Fozor oizar, oḳon tumi amare saṛi deo.” Iakube ḳoila, “Afne amare dua na ḳorle saṛtam nae.” ");
INSERT INTO syll_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Hi manshe zikaila, “Tumar nam kita?” Tain ḳoila, “Iakub.” ");
INSERT INTO syll_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ou hein ḳoila, “Tumi Alla ar manshor loge laṛai koria zitso ḳori, tumar nam ar Iakub roito nae, tumar nam oilo Israil mani, Allar loge kusti korra.” ");
INSERT INTO syll_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Iakube tanre ḳoila, “Afnar namḳan kita ḳoukka.” Tain ḳoila, “Tumi kitar lagi amar nam zikairae?” Heshe tain Iakubre dua ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ou Iakube i zagar nam raḳla Ponuel mani, Allar surot. Tain ḳoila, “Ami Alla Pakre mukamuki dekia-o zinda roisi.” ");
INSERT INTO syll_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ar Iakube Ponuel faronir bade shuruz uṭigelo. Tan urator mairor lagi lengṛaita lagla. ");
INSERT INTO syll_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Erlagi Boni Israile oḳono ranor zuṛar gust ḳain na, ḳaron tain urator zuṛar rogor maze Iakubre marsla. ");
INSERT INTO syll_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Iakube saia deḳla, tan boṛo bai Ishe sair-sho manush loia aguaia aira. Ou tain huruttaintore tan bibin Lea ar Rahela ar duio bandir gese baṭia dilaila. ");
INSERT INTO syll_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Tain tan bandin ar tarar huruttaintore samnor ḳataro raḳla. Bade Lea ar tan huruttaintore, hoḳol heshe raḳla Rahela ar Iusufre. ");
INSERT INTO syll_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ar nize erar age gia shatbar maṭit soizda ḳoria tan bair gese azir oila. ");
INSERT INTO syll_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Teu Ishe tan gese douṛaia aia ainja ḳori golat doria hunga dila, ar duiozone ḳandita lagla. ");
INSERT INTO syll_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Bade Ishe muk tulia ou beṭin ar huruttaintore dekia zikaila, “Tumar loge era ḳegu?” Tain ḳoila, “Allae tan rohomote afnar gulamre i huruttain disoin.” ");
INSERT INTO syll_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Teu foyla bandi oḳole Ishʼor ḳasat aia tarar hurutta loia mata nuaila, ");
INSERT INTO syll_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","bade Leae-o huruttaintore loia aguaia mata nuaila, heshe Iusuf ar Rahelae gia mata nuaila. ");
INSERT INTO syll_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Teu Ishe ḳoila, “Foto zeta dolbol deḳlam, ita kior lagi?” Tain ḳoila, “Amar munibor gese doya faoar lagi.” ");
INSERT INTO syll_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ishe ḳoila, “Baire, amar boutta ase, tumar ita tumar-u taḳouk.” ");
INSERT INTO syll_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Tain ḳoila, “Ji na, ami minot ḳoria ḳoiar, zudi amar bae afnar doya oy, taile amar deoa i dan-dokkina afne neukka. Afne zebla amare kushi mone kobul ḳorsoin, te afnar muk deḳa ar Allar didar faoa amar lagi homan. ");
INSERT INTO syll_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Allae amare rohomot dan ḳorsoin, amar boutta ase ar ou zeta ufohar afnar lagi anchi, ita afne neukka.” Tain oula minot-ḳajji korae, Ishe ita kobul ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ishe ḳoila, “Solo, amra roana oi, ami tumar loge roimu.” ");
INSERT INTO syll_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Iakube tanre ḳoila, “Amar munibe to zanra, i hurutta oḳol-o huru ar dudal gaiain-meṛin-o loge ase, bezan oia itare eḳdin-u aṭaile, hokkolṭi moriziba. ");
INSERT INTO syll_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Te munib, afne amar age zaukkagi, foshur fal ar hurutta oḳlor solar ḳemota buzia ami aste aste Seir elaḳat afnar gese airam.” ");
INSERT INTO syll_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ishe ḳoila, “Taile amar logor ota ḳoyzonre tumar gese toia zaigi.” Tain ḳoila, “Itar dorḳar kita? Amar munibor gese ami ze rohom faisi, oṭa-u to boutta.” ");
INSERT INTO syll_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ar Ish hou din-u Seiror bae roana dilaila. ");
INSERT INTO syll_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Oile Iakube Sukkoto fosia nizor lagi ḍera banaia, foshur falor lagi-o ḳoyḳan batan banaila, teu i zagar nam oilo Sukkot mani, ḍera oḳol. ");
INSERT INTO syll_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Foddon-Iram tone bar oia Iakube, sohi-salamote Kenan deshor Shikim ṭauno aia, ṭaunor bare tambuin gaṛila. ");
INSERT INTO syll_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Heshe ou tambuala zominḳan tain, Shikimor baf Homuror fuaintor ges tone, rufar eḳ-sho ṭeḳa dia ḳorid ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ar hono ekkan kurbani kana banaia er nam dila El-Iluhe-Israil mani, Alla, Israilor uforala. ");
INSERT INTO syll_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Lear goro Dina name Iakubor ze fuṛi oisil, ein eḳdin honor fuṛintor loge deḳa ḳorat gela. ");
INSERT INTO syll_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ar Shikim namor eḳzon manshor souko foṛla. I Shikim asil Hibbi zatir shordar Homuror fua. Shikime ere zur ḳori doria nia ḳobisi kam ḳorillo. ");
INSERT INTO syll_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Dinar bae tar dil ashik oigelo. He ere mohobbot ḳori er loge miṭa miṭa mat matilo. ");
INSERT INTO syll_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Bade Shikime tar baf Homurre ḳoilo, “Tumi ou ḳoinare amar loge biar bondobost ḳoro.” ");
INSERT INTO syll_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Iakube ḳobor faila, Shikime tan fuṛire beijjoti korse, oile tan fuain foshur fal loia bondo taḳae, tain na-matia nirai roila. ");
INSERT INTO syll_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Shikimor baf Homure Iakubor gese biar mat loia ailo, ");
INSERT INTO syll_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ar i kobor hunia Iakubor fuain-o bondo tone aila. Tara betaya gusa ar gorom oila, ḳaron Iakubor fuṛire beijjoti korae Shikime asta Israilor loge beijjoti ar nazaiz ḳam ḳorse. ");
INSERT INTO syll_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Teu Homure erare ḳoilo, “Afnarar ḳoinar lagi amar fua ashik oigese. Doya ḳori, amar fuar loge er shadi dilaukka. ");
INSERT INTO syll_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Amrar loge kuṭumita ḳoroukka, amrar ḳoinaintore afnara neukka ar afnararta amrare deukka. ");
INSERT INTO syll_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ar amrar loge taḳoukka, i asta desh-u to samne roise, afnara ono-u taḳoin, ḳay-ḳarbar ḳoria, nizor malikana ḳaim ḳoroin.” ");
INSERT INTO syll_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Shikime Dinar baf-baire ḳoila, “Amar bae afnara doya ḳoroin, afnara amar gese zeta saiba, ami ota-u dimu. ");
INSERT INTO syll_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Mohorana ar mal-samana afnara zeta dabi korba ami dimu, zekunu laḳan-u Dinare amar loge bia deukka.” ");
INSERT INTO syll_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Shikime tarar boinre beijjoti korsil ḳori Iakubor fuainte tare ar tar baf Homurre bana deḳaia ḳoila, ");
INSERT INTO syll_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“Mosolmani kam na ḳorail kunu damandor loge amrar boinre bia dile amrar beijjoti oibo. ");
INSERT INTO syll_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Oile ou ḳam ḳorle amra razi oimu, afnara hoḳol beṭainte mosolmani koraia, amrar laḳan oiba. ");
INSERT INTO syll_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Taile amrar fuṛintore afnarar gese dimu ar afnarar fuṛintore-o amra anmu, amra-o afnarar loge eḳ zati oia boshot ḳormu. ");
INSERT INTO syll_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Oile afnara i mosolmanir ḳota na manle, amrar ḳoinare loia zaimugi.” ");
INSERT INTO syll_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Teu tarar i mate Homur ar tar fua Shikim kushi oila. ");
INSERT INTO syll_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ou Shikim oilo gusṭir maze hoḳol tone dami manush. He deri na ḳoria ḳota manilailo, ḳaron Iakubor fuṛir bae he ashik asil. ");
INSERT INTO syll_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Bade ṭaunor duaror gese aia, Homur ar tan fuae hokkol manshor loge matia ḳoila, ");
INSERT INTO syll_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“I manushguinte amrare kunu zamela ḳorer na. Amrar desho erar taḳar lagi bout zaga-o ase, te era ono-u taḳouk ar ḳay-ḳarbar ḳorouk, amra erar fuṛintore bia ḳoria ani ar amrar fuṛintore-o tarar gese dei. ");
INSERT INTO syll_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Oile amra ekkan ḳam ḳorle, tara amrar loge eḳ zati oite razi asoin. Ḳamṭa oilo, tarar laḳan amrar-o hokkol beṭaintor mosolmani korani lagbo. ");
INSERT INTO syll_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ar tarar goru-meṛa, mal-samana hokkolta-u to amrar oibo, tarar ḳotae razi oile-u tara amrar loge taḳba.” ");
INSERT INTO syll_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ou ṭaunor hoḳol beṭain Homur ar tan fua Shikimor mate razi oilo, ar tara hoḳlor mosolmani kam ḳorailo. ");
INSERT INTO syll_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Heshe tin dinor din zebla hoḳol beṭainte mosolmanir bedonae ḳoshṭo faira, ou shomoy Dinar afon bai Iakubor dui fua Shimion ar Lebi, tarar toluar loia ṭauno hamaia, erare bekialo faia hoḳol beṭaintore marililo. ");
INSERT INTO syll_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Tara Homur ar tan fua Shikimre-o toluardi zane maria Shikimor gor tone Dinare loia ailo. ");
INSERT INTO syll_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Era tarar boinre beijjoti korsil ḳori, Iakubor hoḳol fuainte mora lashor gese aia ṭauno luṭ-toraz ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ar ṭaunor bitor-bairor goru-gada, sagol-meṛa, ar ḳetor hoḳolta luṭia loia aila. ");
INSERT INTO syll_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Hoḳol mal-samana, fua-fuṛin, beṭin, ar goror hoḳolta-o luṭ-faṭ ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Heshe Iakube Shimion ar Lebire ḳoila, “Tumra i deshor Kenani ar Farizi oḳlor gese amare fosa-ginnar manush banaia mosiboto falaiso. Amar manush ḳom, oḳon tara ekḳano oia amare hamla ḳorle, ami foribaror hokkolre loia mormu.” ");
INSERT INTO syll_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Tara zuaf dila, “He amrar boinre nia ḳanki banailito ni?” ");
INSERT INTO syll_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Erbade Alla Pake Iakubre ḳoila, “Tumi hirbar Betelo zaogi. Tumar bai Ishʼor ges tone bagibar bala, zein tumare doroshon disla, hou Alla Pakor name tumi hono ekkan kurbani kana banao.” ");
INSERT INTO syll_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Teu Iakube tan afon manshore ar logor hoḳolre ḳoila, “Tumrar gese devtar zeta murtin ase, ita hokkolṭi falao; ar hoḳole fak-saf oia, saf-sutra lebas findo. ");
INSERT INTO syll_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ar solo, amra Betelo zaitamgi. Hono ami Allar name ekkan kurbani kana banaimu, zein mosibotor dino amar dua kobul ḳorsla, ar amar soforor logi oisla.” ");
INSERT INTO syll_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Teu tarar zoto laḳan devtar murtin ar ḳanor zeorat asil, hoḳolta Iakubor ato dilaila. Tain ita nia Shikim ṭaunor ḳandat elon gasor tole gaṛilaila. ");
INSERT INTO syll_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Bade tara hon tone roana oila ar Allae sairobae hoḳol gau-geramo eḳ ḍor foyda ḳorla, teu hinor kunu manshe Iakubor fuaintore ḳedanit gelo na. ");
INSERT INTO syll_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Heshe Iakub ar tan logor hoḳole Kenan deshor Luz namor zaga, mani Betelo aia fosla. ");
INSERT INTO syll_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ono tain ek kurbani kana banaia, ou zagar nam dila El-Betel mani, Betelor Alla, ḳaron bair ges taki bagibar bala Allae ono-u tanre didar-doroshon disla. ");
INSERT INTO syll_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ar Rebekar daima Dobura mara gela. Tane Betelor lamat eḳ elon gasor tole maṭi dila, teu i zagar nam oilo Elon-Bakut mani, ḳandonor gas. ");
INSERT INTO syll_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Iakube Foddon-Iram taki aoar bade, Allae hirbar tanre didar dia borkot nazil ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Allae ḳoila, “Tumar nam to Iakub; oile manshe tumare ar Iakub ḳoia ḍakta nae, tumare Israil ḳoiba.” Teu tan nam oilo Israil. ");
INSERT INTO syll_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Allae tanre ḳoila, “Ami-u Shorbo-shoktiman Alla. Tumi folala oia baṛo. Tuma tone eḳ zati foyda oibo, iṭa oibo bout gusṭiala zati, ar tumar ḳandano bashsha oḳol foyda oiba. ");
INSERT INTO syll_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ami Ibrahim ar Isʼhakre ze desh dan ḳorsi, hou desh oḳon tumare ar tumar bador oarishre dimu.” ");
INSERT INTO syll_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Allae hono Iakubor loge batchit ḳoria harle asmano toshrif nilagi. ");
INSERT INTO syll_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Iakube hou batchitor zagat fattoror ek kuṭi gaṛia, er ufre tain Allar name shorbot-fanir sodga ḍalila, heshe tel-o ḍalila. ");
INSERT INTO syll_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Allae zeḳano tanre didar disla, Iakube i zagar nam raḳsla Betel. ");
INSERT INTO syll_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Bade Iakub ar tan logor hoḳole Betel taki roana ḳoria Ifrato fosar bakka age, Rahelar hurutta oar bishe dorlo, tan kub toklif oilo. ");
INSERT INTO syll_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Hurutta oar bish aro baṛlo, teu dai beṭie ḳoilo, “Ḍoraio na go, ibar-o tumar goro fua oibo.” ");
INSERT INTO syll_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Oile Rahela mara gela. Morar shomoy tain fuar nam raḳla Bin-Oni mani, amar toklifor fua oile bafe tar nam raḳla Bin-Iamin mani, amar bolor fua. ");
INSERT INTO syll_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rahelar moutor bade Ifrat, mani Betelham, zaoar fotor ḳandat tanre maṭi deoa oilo. ");
INSERT INTO syll_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Maṭi dia harle Iakube tan ḳoyboror ufre eḳ fattoror kuṭi gaṛla, i kuṭi aiz-o ono ase. ");
INSERT INTO syll_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","On tone Israile hirbar roana dila, ar Edor minar falaia aia tan tambu gaṛila. ");
INSERT INTO syll_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Israil zebla hono roira, ou faḳo Rubene gia tar bafor bador biar bou Bilhar loge zina ḳorlo ar ita Israilor ḳano gelo. ");
INSERT INTO syll_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Iakubor barozon fua asla, Lear torofa tan boṛo fua Ruben, bade Shimion, Lebi, Ehuda, Isaḳor ar Sobulon. ");
INSERT INTO syll_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rahelar torofa Iusuf ar Bin-Iamin. ");
INSERT INTO syll_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rahelar bandi Bilhar torofa, Dan ar Noftali. ");
INSERT INTO syll_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Lear bandi Zilpar torofa, Sadu ar Ashir. Tan ou hurutta oḳol Foddon-Iramo oisla. ");
INSERT INTO syll_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Heshe Iakub Kiriot-Orbor, mani Hebronor ḳasat Momri namor zagat, tan baf Isʼhakor gese aila. Ou zagat Ibrahim ar Isʼhake-o boshot ḳorta. ");
INSERT INTO syll_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isʼhakor boyosh eḳ-sho ashi boros oisil. ");
INSERT INTO syll_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Ar Isʼhak furafur buṛa oia, murobbi boyosho mara gia tan baf-dadar gese gia azila. Tan fua Ish ar Iakube tanre dafon ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ou oilo Ish ba Idumor ḳandanor boyan. ");
INSERT INTO syll_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ishe Kenani dui fuṛire bia ḳorsla. Era oila Hiṭṭi Elonor fuṛi Ada, ar Hibbi Zibionor natin, Onar fuṛi Oholibama. ");
INSERT INTO syll_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Erar bade-o tain Ismailor fuṛi Nabautor boin Bashomotre bia ḳorsla. ");
INSERT INTO syll_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adar feṭo Ilifoz ar Bashomotor feṭo Ruelor zonom oisil, ");
INSERT INTO syll_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ar Oholibamar feṭo Ziush, Zalom ar Kurohor zonom oisil. Ishʼor i fuaintor zonmo oisil Kenan desho. ");
INSERT INTO syll_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Bade Ishe tan bouain, fua-fuṛin, goror hoḳol manush ar foshur falain, Kenan desho ḳamai kora hoḳol don-doulot loia, tan bai Iakubor ges tone horia aroḳ desho gelagi. ");
INSERT INTO syll_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ish ar Iakubor foshur fal, mal-samana oto beshi asil zen, era ekḳano roite hi deshor i zagae ar kulailo na. ");
INSERT INTO syll_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Teu Ish Seiror faṛi elaḳat gia boshot ḳorla. Ein-u Idum. ");
INSERT INTO syll_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ou oilo Seiror faṛor Idumi oḳlor mul baf Ishʼor ḳandanor boyan. ");
INSERT INTO syll_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ishʼor fuaintor nam oilo, Ilifoz ar Ruel. Ilifoz Adar fua, Ruel Bashomotor fua. ");
INSERT INTO syll_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ilifozor fuain oila, Toimon, Omar, Zofo, Gatam ar Kenaz. ");
INSERT INTO syll_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Ishʼor fua Ilifozor Timna namor eḳ hangar bou asil, er goro Amalekor zonom oisil. Era hoḳole-u Ishʼor bou Adar aolad. ");
INSERT INTO syll_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ruelor fuain oila Nohot, Zarah, Shommo ar Mijja. Era Ishʼor bou Bashomotor aolad. ");
INSERT INTO syll_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Zibionor natin, Onar fuṛi Oholibamar torofa Ishʼor fuain oila Ziush, Zalom ar Kuroh. ");
INSERT INTO syll_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ishʼor aolador maze era asla gusṭir neta. Ishʼor boṛo fua Ilifozor fuain oila Toimon, Omar, Zofo, Kenaz, ");
INSERT INTO syll_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kuroh, Gatam, ar Amalek. Era oila Idum desho, Adar fua Ilifozor aolad. ");
INSERT INTO syll_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ishʼor fua Ruelor fuain zera gusṭir neta oisla, tara oila Nohot, Zarah, Shommo ar Mijja. Era oila Idum desho Ishʼor bou Bashomotor fua Ruelor aolad. ");
INSERT INTO syll_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ishʼor bou Oholibamar ze fuain gusṭir neta oisla, tara oila Ziush, Zalom ar Kuroh. Era asla Onar fuṛi Oholibamar aolad. ");
INSERT INTO syll_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Era oila Ish ba Idumor ḳandan ar gusṭir neta. ");
INSERT INTO syll_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Honor Hurio Seiror fuaintor nam oilo Luṭon, Shubol, Zibion, Ona, ");
INSERT INTO syll_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishun, Etoshor ar Dishan. Era hoḳole Idum desho Seiror fuain, Hurio ḳandanor neta asla. ");
INSERT INTO syll_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Luṭonor fuar nam oilo Huri ar Hemam, ar bonir nam Timna. ");
INSERT INTO syll_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Shubolor fuaintor nam oilo Olbon, Manohot, Ibal, Shofo ar Onom. ");
INSERT INTO syll_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibionor fuaintor nam oilo Oya ar Ona. Ou Ona-u tan baba Zibionor gada raḳat gia, morubumir maze gorom fanir indara oḳol tukaia faila. ");
INSERT INTO syll_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Onar fuar nam Dishun ar fuṛir nam Oholibama. ");
INSERT INTO syll_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dishunor fuaintor nam oilo Himdon, Ishbon, Zitron ar Keran. ");
INSERT INTO syll_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Etoshoror fuaintor nam oilo Bilhon, Zaoan ar Aḳon. ");
INSERT INTO syll_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dishanor fuaintor nam oilo Auz ar Oran. ");
INSERT INTO syll_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Hurio oḳlor neta oila Luṭon, Shubol, Zibion, Ona, ");
INSERT INTO syll_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishun, Etoshor ar Dishan. Era oila Seir deshor Hurio gusṭir neta. ");
INSERT INTO syll_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Boni Israilor maze bashshai hukumot aibar age, Idum desho era-u raza asla. ");
INSERT INTO syll_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bauror fua Bela Idumor raza oila. Tan razdanir nam asil Dinhaba. ");
INSERT INTO syll_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela morar bade, tan zagat Bosra ṭaunor Zarahor fua Zubob raza oila. ");
INSERT INTO syll_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Zubob morar bade Toimon deshor Hushom honor raza oila. ");
INSERT INTO syll_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Hushom morar bade tan zagat Bododor fua Hodod raza oila. Tain zuddo ḳori Muab deshor Madiani oḳolre araila. Tan razdanir nam oilo Obit. ");
INSERT INTO syll_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hodod morar bade Mosreka ṭaunor Samla honor raza oila. ");
INSERT INTO syll_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla morar bade honor Furat gangor faror Rohobot ṭaunor Shoul raza oila. ");
INSERT INTO syll_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Shoul morar bade tan zagat Akbaror fua Baal-Hanon raza oila. ");
INSERT INTO syll_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akbaror fua Baal-Hanon morar bade tan zagat Hodor raza oila. Tan razdanir nam asil Pau, ar tan bour nam asil Moheṭabel. Ein Moṭredor fuṛi ar Mezahabor natin. ");
INSERT INTO syll_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Ishʼor zeta aolad oḳol gusṭi ar elaḳar neta asla, tarar nam oilo, Timna, Olba ar Zitet, ");
INSERT INTO syll_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinun, ");
INSERT INTO syll_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Toimon, Mibzar, ");
INSERT INTO syll_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Mogdiel ar Oram. Era asla zarzir deshor, zarzir elaḳar Idumi neta. Idumi oḳlor mul baf Ishʼor boyan ono-u shesh. ");
INSERT INTO syll_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Iakub Kenan desho-u roila, tan baf-o hono musafir oia asla. ");
INSERT INTO syll_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ou oilo Iakubor ḳandanor boyan. Iusufe shotro boros boyosh tone tan baiaintor loge meṛa-sagol raḳta. Tain huruman tone-u tan haton ma Bilha ar Zilpar fuaintor loge roita. Ar erar hoḳol bad sal-cholonor ḳobor bafre zanaita. ");
INSERT INTO syll_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Iusuf, Israilor buṛa boyoshor fua gotike, tain ere hoḳol tone beshi maya ḳorta. Tain ere ek kandani zubba banai dila. ");
INSERT INTO syll_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Bafe Iusufre hoḳol tone beshi maya ḳoroin dekia, baiainte tanre ginnaita. Tara en loge bala mone mat-ḳota-o matta na. ");
INSERT INTO syll_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Iusufe ek kuab dekia tan baiaintore hunaila, teu tara aro beshi ginnaila. ");
INSERT INTO syll_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Tain ḳoila, “Ami kuabe kita deḳsi huno: ");
INSERT INTO syll_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","ami deḳlam, amra ḳetor maze danor muiṭ bandiar ar amar banda muiṭḳan ubaigelo, teu tumrar muiṭ oḳole amar muiṭre sairobae beria soizda ḳorer.” ");
INSERT INTO syll_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ou tan baiainte ḳoila, “Tui hasau amrar raza oite saire ni? Tui raza oia amrar ufre beṭagiri korte ni?” Teu tan kuab ar tan mator lagi tara aro beshi ginnaila. ");
INSERT INTO syll_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Iusufe hirbar ek kuab dekia tan baiaintore hunaila. Tain ḳoila, “Huno, ami hirbar kuabe deḳsi, san-shuruz ar egaroṭa terae amare soizda ḳorer.” ");
INSERT INTO syll_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Tain i kuabor ḳota tan baf ar baiaintor gese ḳoia harle, bafe tanre domḳaia ḳoila, “Tuin ita kun zator kuab deḳle, re fut? Tor ma-baiain ar ami-o kita hasau tore soizda ḳortam ni?” ");
INSERT INTO syll_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ar Iusufre tan baiainte kub ingshaita. Oile bafe i kuabor ḳota mono raḳla. ");
INSERT INTO syll_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ar tan baiainte bafor foshur fal loia Shikimo raḳat gela. ");
INSERT INTO syll_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Teu Israile Iusufre ḳoila, “Tor baiainte foshur fal raḳat Shikimo gesoin, te ae, ami tore-o hono faṭai.” Tain ḳoila, “Aichcha, ami zaimu.” ");
INSERT INTO syll_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Israile tane ḳoila, “Tui gia tor baiain ar foshur falor ḳobor-antor hunia aia amare ḳois.” Teu tain Iusufre Hebron tone Shikimo faṭaila. Ar Iusuf-o gia Shikimo azir oila. ");
INSERT INTO syll_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Aia harle tanre ḳetor maze gura-firat dekia eḳ beṭae zikaila, “Tumi kita tukairae ba?” ");
INSERT INTO syll_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Iusufe ḳoila, “Ami amar baiaintore tukaiar. Afne zanoin ni, era foshur fal kun zagat raḳra?” ");
INSERT INTO syll_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Hi beṭae ḳoila, “Tara in tone gesoingi. Ami hunchi tara matira, ao, amra Dutono zaigi.” Ou Iusufe tukai tukai Dutono gia tarare faila. ");
INSERT INTO syll_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Baiainte duroi tone tanre deḳlo, ar tarar gese fosar age-u tara ene kun ḳorar motlob ḳorlo. ");
INSERT INTO syll_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Tara eḳzone aroḳzonre ḳoilo, “Ou deḳo, kuab deḳra sab aira. ");
INSERT INTO syll_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ao, oḳon-u amra ene ḳotom ḳoria ou gato falai dei; bade ḳoimu, kunu zongli zanuare ḳailaise, heshe deḳmune, tar kuabor dosha kita oy?” ");
INSERT INTO syll_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Oile Rubene ita hunia tarar at taki enre basaibar lagi koila, “Tare zane mario na.” ");
INSERT INTO syll_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Tain erare foramish dila, “Kun-ḳarafi korat zaio na, nizor ate na maria ogure emne-u gator maze falai deo.” Oula tain Iusufre tarar at tone basaia, bafor ato faṭanir sesṭa ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Iusuf tan baiaintor gese aite-u tara, tan gotor tone zubba kulilaila, hou ḳandani zubbaṭa ṭania kulilila. ");
INSERT INTO syll_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ar tane doria gator maze falai dila. I gat hukna asil, kunu fani asil na. ");
INSERT INTO syll_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Heshe tara ḳaoat boia saia deḳla, Giliod taki Ismaili eḳ befarir dol ibae ar. Era uṭor fiṭit ḳori kushboy moshla, agor, ar meshke-ambor loia Mishor desho zaita. ");
INSERT INTO syll_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ou Ehudae tar baiainre ḳoilo, “Doro, baire kun ḳoria amra lukaililam, teu amrar kita lab oibo? ");
INSERT INTO syll_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","He to amrar-u bai, amrar afon lou ar gust. Te tar shorilo at na dia ao, Ismaili oḳlor gese tare besilai.” Ou baiain-o razi oigela. ");
INSERT INTO syll_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Hou Madiani befari oḳol ḳasat aite-u, baiainte Iusufre gato tone ṭania tulla ar ek kuṛi rufar ṭeḳar bodla, Ismaili oḳlor gese tane besilaila. Era Iusufre loia Mishoro gelagi. ");
INSERT INTO syll_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Bade Rubene hou gator gese aia Iusufre na dekia, tan gotror kurta farilla. ");
INSERT INTO syll_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Baiaintor gese gia ḳoila, “Fuagu to ino nae. Oḳon ami kita ḳortam?” ");
INSERT INTO syll_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ou tara eḳ bokri maria, er lou Iusufor hou zubbat lagaila. ");
INSERT INTO syll_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Bade manushdi ou zubba tarar bafor gese faṭaia ḳoila, “Iṭa amra foto faisi, te afne bala ḳoria deḳoukka, iṭa afnar fuar zubba ni?” ");
INSERT INTO syll_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Iakube i zubba sinia ḳoila, “Iṭa to amar fuar-u. Tare kunu zongli zanuare ḳailise, tare nisoy siṛi-biṛilaise.” ");
INSERT INTO syll_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Tain finnor ḳafoṛ siṛia, ḳomro solar soṭ bandia, fuar lagi bout din mattom ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Tan hoḳol fua-fuṛie tane buzaita saila, oile kunu buze-u tan buk ṭanḍa oilo na. Tain ḳoila, “Ami mattom ḳori kori amar fuar gese ḳoyboro hamaimu.” Fuar lagi tain ou laḳan ḳanda-ḳaṭit roila. ");
INSERT INTO syll_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Er maze Madiani oḳole Iusufre Mishoro nia, Feraunor ḳormosari Azizor gese besilaila, i kormosari asla tan fordan gaḍ. ");
INSERT INTO syll_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ehudae tar baiaintore toia Odullom gaur Hira namor eḳ manshor loge roat gelo. ");
INSERT INTO syll_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Hono roia Shua namor ek Kenani manshor fuṛir loge deḳa oilo, dekia he ou fuṛire bia ḳorlo. ");
INSERT INTO syll_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Biar bade hou beṭir goro eḳ fua oilo, Ehudae tar nam raḳlo Eir. ");
INSERT INTO syll_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Hirbar beṭir goro aroḳ fua oile, maʼe tar nam raḳlo Onon. ");
INSERT INTO syll_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Heshe ou beṭir aroḳ fua oile, tar nam raḳlo Shela. I shomoy tara Koshib gaut roita. ");
INSERT INTO syll_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Ar Ehudae tar boṛo fua Eiror loge Tamar namor eḳ fuṛire bia dilo. ");
INSERT INTO syll_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Oile tar i fua Mabudor nozoro kub ḳobis asil gotike, Mabude tare marilaila. ");
INSERT INTO syll_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ou Ehudae Ononre ḳoilo, “Tumar babire bia ḳorilao. Tair deor oae tumar zeta ḳora zorur ase, ita adae ḳoro ar nizor bair oarish foyda ḳoro.” ");
INSERT INTO syll_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onone zanto, i oarish tar nizor oito nae, ar tar bair oarish raḳte tar kial asil na gotike, tair loge mila-mishar shomoy tar biz baire maṭit falai dito. ");
INSERT INTO syll_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Mabude tar i kame naraz oila, tain Eirre-o marilaila. ");
INSERT INTO syll_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ou Ehudae tar fuar bou Tamarre ḳoilo, “Amar fua Shela zotodin boṛo na oy, otodin tumar bafor baṛit gia ṛaṛi oia-u ro.” Ehudae ḍorailo, Shela-o tar baiaintor laḳan morizibo. Ar Tamar bafor baṛit gelogi. ");
INSERT INTO syll_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Bakka ḳoydin bade Ehudar bou, Shuar fuṛi morigelo, teu ḳanda-ḳaṭi korar bade Ehudae shanti oia Odullom gaur tar dust Hirar loge Timna gaut, tar meṛar falor ruma ḳaṭra manshor gese roana dilo. ");
INSERT INTO syll_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ar Tamarre gia ḳeu ḳobor dilo “Tumar houre tan meṛar ruma ḳaṭar lagi Timnat zaira.” ");
INSERT INTO syll_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tamare deḳlo, Shela boṛo oile-o houre Shelar loge tair bia dira na, ou tai ṛaṛir ḳafoṛ bodlaia hazi-faṛi muko gumṭa dia, Aynaimor fotor muko gia boilo. Aynaim asil Timnat zaoar foto. ");
INSERT INTO syll_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ar tai muk lukaia raḳae, Ehudae mono ḳorlo igu silan beṭi. ");
INSERT INTO syll_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Teu Ehudae fuar boure na sinae, fotor daro Tamaror gese gia ḳoilo, “Ao, tumar loge mila-misha ḳori.” Tamare ḳoilo, “Te amare kita dibae?” ");
INSERT INTO syll_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","He ḳoilo, “Amar fal tone bokri baichcha egu faṭai dimu.” Tamare ḳoilo, “Iṭa faṭanir age amar gese kunta zimma toia zaukka.” ");
INSERT INTO syll_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ehudae ḳoilo, “Kita toitam?” Tai koilo, “Afnar ou fita-ala sil ar afnar ator laṭi toia zaukka.” Teu Ehudae oguin zimma toia tair loge mila-misha ḳorlo ar Tamaror feṭo hurutta ailo. ");
INSERT INTO syll_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Bade Tamar uṭia gelogi ar hi kafoṛ bodlaia hirbar ṛaṛir ḳafoṛ findilo. ");
INSERT INTO syll_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Heshe ou beṭir ges taki zimmar mal firot nibar lagi, tar Odullomor dustre dia sagolor baichcha egu faṭailo. He aia taire tukaia failo na. ");
INSERT INTO syll_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ou he honor manshore zikailo, “Aynaimor fotor daro eḳ shebok beṭi asil, ogu ḳoi?” Tara ḳoila, “Ino to ila kunu beṭi nae.” ");
INSERT INTO syll_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Teu he Ehudar gese gia ḳoilo, “Ami gia taire tukaia failam na. Honor manshe-o ḳoila, ino to ila kunu beṭi aise na.” ");
INSERT INTO syll_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ehudae ḳoilo, “Te ita ar tair gese-u taḳouk. Naile amra shorminda oimu. Sagolor baichcha to faṭailam, ta-o tumi ere tukaia failae na.” ");
INSERT INTO syll_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Onuman tin mash bade Ehudae hunlo, tar fuar bou Tamare zina ḳorse, erlagi tair hurutta oita. Ou Ehudae ḳoilo, “Ogure bare nia aguindi zalailao.” ");
INSERT INTO syll_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Tamarre zebla bare nira, ou shomoy tair hourre ḳobor dilo zen, “Zar hurutta amar feṭo ase, ou mal-samana oḳol tar. Te deḳoukka, ou fita-ala sil ar laṭigu ḳar sinoin ni?” ");
INSERT INTO syll_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Ehudae ita dekia ḳoilo, “Tai to ama taki bout boṛo forezgar. Amar fua Shelar loge taire bia ḳoraisi na.” Erbade Ehudae ar kunudin-o Tamaror gese hutise na. ");
INSERT INTO syll_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Hurutta oibar bala deḳoin, Tamaror feṭo zuṛor hurutta. ");
INSERT INTO syll_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Foyla egue tar at bar ḳorlo ar dai beṭie lal suta eḳsa tar ato bandia ḳoilo, “Igu foyla foyda oilo.” ");
INSERT INTO syll_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Oile he at ṭan dia bitre nilogi, teu tar bai foyla bar oilo ar dai beṭie ḳoilo, “Tumi kila fak koria bar oilae?” Erlagi er nam oilo Firuz mani, fak kora. ");
INSERT INTO syll_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Bade tar bai lal suta ato banda loia bar oilo, tar nam raḳla Zarah. ");
INSERT INTO syll_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Iusufre Mishor desho loia zaoar bade, Ismaili oḳlor ges tone, Aziz namor Feraunor eḳzon Mishori kormosarie, Iusufre ḳorid ḳorla. Aziz oila Feraunor fordan gaḍ. ");
INSERT INTO syll_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Mabude Iusufor logi oila, erlagi Iusuf hoḳol ḳamo kamiab oila. Tain hou Mishori munibor baṛit ḳam ḳorta. ");
INSERT INTO syll_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Mabud tan loge loge asoin ar hoḳol ḳamo tane kamiab ḳorra, tan munibe-o ita buzilaila. ");
INSERT INTO syll_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Teu munibe Iusufre maya ḳorta lagla, tane munibor ḳas kezmotgar banaila ar tan baṛir hoḳolta deḳa-hunar bar-o Iusufor gese shomzai dila. ");
INSERT INTO syll_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Iusufre tan baṛir ar hoḳoltar bar shofi deoar bade tone, Mabude Iusufor lagi-u, tan munibor hoḳoltar maze borkot nazil ḳorla. Azizor baṛit ar ḳet-ḳamar, hoḳol zagat Mabude borkot nazil ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ita dekia Azize tan hoḳoltar bar Iusufor ufre shofi dila, tan nizor ḳana-dana saṛa ar kuntar-u ḳobor loita na. Iusufor shorilor goṭon ar sehara-o shundor asil. ");
INSERT INTO syll_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ita dekia tan munibor boue tan bae lalos ḳorlo. Tai Iusufre ḳoilo, “Amar bisnat ao.” ");
INSERT INTO syll_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Oile Iusuf razi na oia munibor boure ḳoila, “Deḳoukka, i baṛit kita kita ase, amar munibe kunta-u ḳobor loin na, hoḳoltar bar amar ufre shomzai disoin. ");
INSERT INTO syll_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","I baṛit ama tone boṛo ar ḳeu nae. Afne to tan bibi, erlagi afnare saṛa ar hoḳolre tain amar zimmae raḳsoin, te ami kila oto boṛo eḳ zogoinno ḳam ḳoria Allar birudde guna ḳortam?” ");
INSERT INTO syll_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Tai hamesha Iusufre oula minot ḳorle-o Iusufe tair gese hutte ba ḳasat roite-o razi oila na. ");
INSERT INTO syll_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Heshe eḳdin kunu ek kamor lagi Iusuf goror bitre hamaila, ou shomoy ar ḳeu hino asil na. ");
INSERT INTO syll_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Teu Azizor boue Iusufor ḳafoṛo dori koilo, “Amar bisnat ae.” Oile Iusufe tan ḳafoṛ falaia douṛia gelagi. ");
INSERT INTO syll_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Iusufe tair ato ḳafoṛ toia douṛaia gelagi kori, ");
INSERT INTO syll_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Azizor boue goror manshore ḍakia ḳoilo, “Huno, tain amrar loge tamsha ḳorar lagi i Ibrani beṭare anchoin. He amare beijjoti korar motlobe amar bisnat aisil, ou ami sillaia uṭsi. ");
INSERT INTO syll_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Amar sillani hunia he tar finnor ḳafoṛ amar gese toia bagise.” ");
INSERT INTO syll_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Iusufor munib baṛit na aoa forzonto, i kafoṛ tai nizor gese raḳlo. ");
INSERT INTO syll_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Tain aia harle tai nalish dilo, “Tumi ze Ibrani gulamre amrar gese ancho, he amare beijjoti korar motlobe amar goro hamaisil. ");
INSERT INTO syll_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Oile amar hauka-hauki ar sillanie he amar gese tar ḳafoṛ falai toia bagise.” ");
INSERT INTO syll_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Bour mat hunia Iusufor munibe gusae aguin oigela. Tan boue ḳoilo, “Tumar gulame amar loge ou laḳan ḳam ḳorse.” ");
INSERT INTO syll_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Teu Azize Iusufre nia zel ḳanat haraila. Mishoror bashshar bondi oḳolre zeno raḳoin, tane-o hou zel ḳanat toila. ");
INSERT INTO syll_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Oile Iusufor ufre Mabudor saya asil, tain Iusufre boṛo zelar sabor gese mayar manush banaila. ");
INSERT INTO syll_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Boṛo zelar sabe zel ḳanar hoḳol bondi oḳlor shordari Iusufor ufre saṛi dila, teu honor hoḳol ḳam-ḳaz Iusufor hukume solto. ");
INSERT INTO syll_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ar boṛo zelar sabe kunta-u deḳa-huna ḳora lagto na, ḳaron Mabud Iusufor loge asla, erlagi Iusufe zetat at dita, Mabude ita kamiab ḳorta. ");
INSERT INTO syll_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Itar bade Mishoror bashshar dorbaror shorab bilai deora ar ruṭi banaora i duiozone bashshar gese ḳosur ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Teu Feraun tara duiozonor ufre gusa oila, ");
INSERT INTO syll_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","tain erare bondi koria tan boṛo zollador baṛir zelo haraila. Ou zelo Iusuf-o asla. ");
INSERT INTO syll_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Boṛo zollade i duio ḳoydir bar-o Iusufor ato dila, ar Iusufe tarar kezmot ḳorta lagla. Oula era kisudin zelo roila. ");
INSERT INTO syll_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Bade Mishoror bashshar hou ruṭi banaora ar shorab bilaora duiozone eḳ raite dukan kuab deḳla, tarar kuabor mani-o asil dui laḳan. ");
INSERT INTO syll_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Biane Iusufe tarar gese gia deḳla, tara kub mon-mora oiroisoin. ");
INSERT INTO syll_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Iusufe tarare zikaila, “Kita oise, aiz oto bezar ḳene?” ");
INSERT INTO syll_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Tara zuaf dila, “Amra to kuab deḳsi, oile er tabir buzai deora ḳeu nae.” Iusufe tarare ḳoila, “Mani buzanir ḳemota kita Allae dein na ni? Deki sain, amare hunaukka.” ");
INSERT INTO syll_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ou hi shorab bilaorae, tan shofon Iusufre hunaila. He ḳoilo, “Ami deḳlam, amar samne eḳ anguror gas. ");
INSERT INTO syll_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Gasor tingu ḍal ase; hou ḍalo kuṛi baronir loge loge ful dorlo, ar soṛa soṛa angur dori faki gelo. ");
INSERT INTO syll_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ou shomoy Feraunor shorbotor fiala amar ato asil. Ami hou angur oḳol sifia rosh bar ḳori Feraunor ato dilam.” ");
INSERT INTO syll_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Iusufe tare ḳoila, “Afnar shofnor mani oilo, tin ḍal mani tin din. ");
INSERT INTO syll_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ou tin dinor maze Feraune afnare bar ḳoria hirbar agor ḳamo lagaiba. Afne hirbar agor laḳan Feraunor ato fiala tuli diba. ");
INSERT INTO syll_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Oile afnare minoti kori koiar, afnar balai oar bade amare mono ḳorba ar doya ḳori Feraunor gese amar ḳota ḳoia, i zelḳana tone amare ḳalas ḳoraiba. ");
INSERT INTO syll_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ibrani oḳlor desh tone amare zur ḳori doria ana oise. Ar ono aia-o ami zel ḳaṭar moto emon kunta ḳorsi na.” ");
INSERT INTO syll_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Bade hi ruṭi banaorae zebla deḳlo zen, shorab bilaorar kuabor mani bala ase, teu he Iusufre ḳoilo, “Ami-o kuabe deḳsi, deḳlam zen amar matat tin ṭukri moydar ruṭi loisi. ");
INSERT INTO syll_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ar ufror ṭukrit asil, Feraunor lagi bout zator fiṭa; teu faki oḳole aia, amar matar ufror ṭukri taki ita ḳailira.” ");
INSERT INTO syll_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Iusufe zuaf dila, “I shofnor tabir oilo, tin ṭukri mani tin din. ");
INSERT INTO syll_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ou tin dinor maze, Feraune afnar doṛ tone ḳolla algaia, gasor maze loṭḳaiba, heshe fakinte aia afnar doṛor gust ḳaiba.” ");
INSERT INTO syll_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Er tin dinor din Feraunor zonom din asil. Feraune tan dorbaror hoḳol manshor lagi, ḳani tiar ḳoraila. Ar hou ruṭi banaora ar shorab bilaora duiozonre anaia tan dorbaror samne azir ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Tain shorab bilaorare hirbar tan ḳamo lagaila, he Feraunor ato hirbar fiala tulia dilo. ");
INSERT INTO syll_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Oile ruṭi banaorare gaso loṭḳaila. Iusufe zela ḳoisla, ekkere oula oilo. ");
INSERT INTO syll_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ta-o Iusufor ḳota hi shorab bilaorar iad roilo na, he faurililo. ");
INSERT INTO syll_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Er fura dui boros bade Feraune kuabe deḳla. Tain deḳla, Nil nodor gese tain ubai roisoin, ");
INSERT INTO syll_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ar Nil nod tone shatgu shundor tortaza goru uṭia aia nol bonor maze aṭia ḳaira. ");
INSERT INTO syll_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Erbade deḳoin, aro shatgu halaḳ ar ḳobisor laḳan goru uṭia aia, Nil nodor faror hou goruintor ḳasat ubailo. ");
INSERT INTO syll_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Heshe ou halaḳ ar ḳobisor laḳan goruinte hou shundor ar tortaza shato gorure ḳaililo, teu Feraunor gum bangi gelo. ");
INSERT INTO syll_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Bade tain hirbar gumaila ar duara kuabe deḳla, ek gomor ḍeṭat shatgu fusṭo ar taza soṛa bar oise. ");
INSERT INTO syll_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Heshe bar oilo, fubali batashor gorome hukna shatgu ḳom fusṭo susa-ala soṛa, ");
INSERT INTO syll_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","ar ou ḳom fusṭo soṛae hou shato fusṭo-taza soṛare gililailo. Bade Feraunor gum bangi gelo, tain buzla zen ita to kuab. ");
INSERT INTO syll_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Biane tan mon ostir oigelo, teu Mishor deshor hoḳol zadugir ar fonḍitre ḳobriadi anaia, tan kuab tarare hunaila, oile erar ḳeu er tabir ḳoito farlo na. ");
INSERT INTO syll_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Heshe Feraunor hou shorab bilaorae ḳoilo, “Huzur, aiz amar eḳ dush mono oise. ");
INSERT INTO syll_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Bout din age huzure nizor dui gulamor ufre gusa ḳorsla, tain amare ar ruṭi banaorare boṛo zelar sabor baṛir zelo toisla. ");
INSERT INTO syll_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ar eḳ raite amra duiozone alog alog kuab deḳlam, duio kuabor dui laḳan tabir asil. ");
INSERT INTO syll_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","I shomoy zelar sabor, eḳ Ibrani zuan gulam-o ono asil. Tare amrar kuabor ḳota hunailam, ar he amrar kuabor tabir ḳoia dilo. ");
INSERT INTO syll_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","He amrar kuabor tabir zela ḳoisil, ekkere ou laḳan-u folilo. Huzure amare hirbar tan ḳamo lagaila, oile ruṭi banaorare gaso loṭḳaila.” ");
INSERT INTO syll_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ou Feraune Iusufre anar lagi manush faṭaila, tara gia zoldi kori zelḳana tone tanre bar ḳori anla. Iusufe daṛi-mus ḳamaia, ḳafoṛ bodlaia Feraunor dorbaro azir oila. ");
INSERT INTO syll_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Feraune tanre ḳoila, “Ami ekkan kuab deḳsi, oile er tabir ḳeu ḳoito farer na. Te ami hunlam zen tumar gese kuab hunaile, tumi er tabir ḳoitae faro.” ");
INSERT INTO syll_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Iusufe zuaf dila, “Hi kemota to amar nae, Alla Pake moharazor dilor shantir zuaf bataia diba ne.” ");
INSERT INTO syll_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Feraune Iusufre ḳoila, “Kuabe deḳlam, ami Nil nodor faro ubai roisi. ");
INSERT INTO syll_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ar deki, gango tone shatgu shundor, tortaza goru uṭia aia nol bonor maze aṭia ḳaira. ");
INSERT INTO syll_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Erbade aro shatgu goru uṭia ailo. Ita halaḳ ar ḳobisor laḳan, Mishor deshor kunu ḳano ilaḳan be-surot goru kunu dino deḳsi na. ");
INSERT INTO syll_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Bade ou halaḳ ar be-surot goruinte, agor hi shato tortaza gorure ḳaililo. ");
INSERT INTO syll_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Oile tara itare gilar bade, ḳaise ḳori buza-o gelo na, ḳaron tara agor laḳan-u halaḳ ar be-surot roilo. Heshe amar gum bangi gelo. ");
INSERT INTO syll_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Bade ami hirbar deḳlam, gomor eḳ ḍeṭar maze shatgu boṛo ar fusṭo soṛa bar oilo. ");
INSERT INTO syll_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Fubali haoar gorome hukna shatgu ḳom fusṭo susa-ala soṛa-o bar oilo. ");
INSERT INTO syll_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ar ou shato soṛae, hou taza shato soṛare gilililo. I kuab ami zadugir oḳolre hunaislam, oile ḳeu er mani koito farse na.” ");
INSERT INTO syll_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Iusufe Feraunre ḳoila, “Huzur, i duio kuab-u adote eḳ. Allae zeta ḳorta saira, ita afnare deḳaisoin. ");
INSERT INTO syll_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ou tortaza shato gorur mani shat boros, ar fusṭo shato gomor soṛar mani-o shat boros. Duio kuab-u eḳ. ");
INSERT INTO syll_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ar heshe uṭia aoa shato halaḳ ar be-surot goru, ar fubali haoar gorome hukna shato gomor soṛa, erar mani oilo, aḳalor shat boros. ");
INSERT INTO syll_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Te Allae zeta ḳorta saira, ita moharazre deḳaisoin. Ou ḳota-u ami afnare age ḳoisi. ");
INSERT INTO syll_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Hunoukka, hara Mishor desho shat boros kub beshi foshol folibo. ");
INSERT INTO syll_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Erbade-u aibo aḳalor shat boros. Teu agor hi beshi fosholor ḳota manshe fauriliba, ar aḳale deshre shesh ḳori dibo. ");
INSERT INTO syll_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ou aḳalor dorun, agor hi fosholor ḳota manshor mono roito nae. I aḳal oibo kub bezuita mosibotor. ");
INSERT INTO syll_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","I kuab afnare duibar deḳanir mani oilo, Allae i dosha goṭaiba, ekkere ṭik korilaisoin, ita kub zoldi kori-u goṭibo. ");
INSERT INTO syll_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Oḳon huzure eḳzon sotur-buzdar fonḍit manshore tukaia, en gese Mishorre shofi deukka. ");
INSERT INTO syll_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ar afne oula ḳoroukka, desho afnar ḳormosari lagain, ou shat bosore zebla kub beshi foshol folbo, i shomoy tara er fas baṭor eḳbaṭ dola ḳorba. ");
INSERT INTO syll_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Tara ou shudinor bosoror dan dola ḳoria huzuror doḳole, bazare bazare gudamo boria touk ar hefazot ḳorouk. ");
INSERT INTO syll_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Shat boros dori Mishoro ze aḳal oibo, hou aḳalor lagi dan zomaia raḳba, teu aḳale deshor manush morta nae.” ");
INSERT INTO syll_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Iusufor i mat, Feraun ar tan dorbaror hoḳlor gese kub bala mono oilo. ");
INSERT INTO syll_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Feraune tan uzir-nazir oḳolre ḳoila, “I besaṛar laḳan Allar ruh-ala manush ami kuai tukaia faimu?” ");
INSERT INTO syll_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ou Feraune Iusufre ḳoila, “Allae zebla tumar gese ita hokkolta zair ḳorsoin, te tumar laḳan buzdar ar bibekman to ar ḳeu nae. ");
INSERT INTO syll_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Oḳon razbaṛir hokkolta tumi-u salaibae. Amar hoḳol proza tumar hukme solba. Ḳali bashshar toḳto, ami tumar ufre taḳmu.” ");
INSERT INTO syll_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Tain Iusufre ḳoila, “Huno, ami asta Mishor desh tumar ato shofi dilam.” ");
INSERT INTO syll_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ar Feraune nizor anguil taki bashshai silor angṭi kulia Iusufor ato findaila, tan golat shunar har dila ar dami kafoṛor shada lebas-o findaila. ");
INSERT INTO syll_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Bade tain Iusufre tan raijjor dui nombor rotor maze tulla ar Iusufor age age elan ḳora oilo, “Fornam ḳoro! Fornam ḳoro!” Ou laḳan tain Iusufor ufre asta Mishor deshor bar shomzai dila. ");
INSERT INTO syll_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Feraune Iusufre ḳoila, “Ami-u Feraun, Mishoror bashsha! Oile tumar hukum saṛa, asta Mishor desho ḳeu ruma-o laṛaito farto nae.” ");
INSERT INTO syll_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Feraune Iusufor noya nam raḳla, Safonot-Paneh. Tain Oun mondiror babon-ṭakur Puṭiferar fuṛi Asonotre Iusufor loge bia dila ar Iusufe asta Mishor desho guraguri korat lagla. ");
INSERT INTO syll_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Iusufe tish boros boyosho, Mishoror bashsha Feraunor ḳamo lagla, tain Feraunor dorbar tone bar oia deshor hoḳol zaga sofor ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ar beshi fosholor ou shat bosore desho bout foshol folilo. ");
INSERT INTO syll_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Teu Iusufe i shudinor shat bosore Mishoror hoḳol dan, bazaror gudam gorainto zoma ḳoraia toila. Tain hokkol bazaror sairo galar dan oḳol, hou bazaror gudamo zomaila. ");
INSERT INTO syll_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Tain doriar balur laḳan oula behishab dan dola ḳorla zen, ita ar mafia fuṛaita farla na, teu mafa-mafi kora bad dilaila. ");
INSERT INTO syll_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ar aḳalor age Oun mondiror babon-ṭakur, Puṭiferar fuṛi Asonotor feṭo Iusufor dui fua oila. ");
INSERT INTO syll_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Iusufe tan boṛo fuar nam raḳla Manosha mani, faurilaoa. Tain ḳoila, “Allae amar hoḳol toklif ar bafor baṛir hokkolta, amar dil tone fauraila.” ");
INSERT INTO syll_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Bade tan dusra fuar nam raḳla Afraim mani, foldar. Tain ḳoila, “Ami ze desho toklif faisi, hou desho-u Allae amare foldar banaila.” ");
INSERT INTO syll_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ar Mishor deshor kub beshi fosholor hi shat boros furigelo. ");
INSERT INTO syll_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Teu Iusufe zela ḳoisla, oula aḳalor hou shat boros aia azilo. Er loge ḳanda-ḳasar hoḳol desho-o nidan deḳa dilo oile Mishoror kunu zagat ḳani-kurakir obab oilo na. ");
INSERT INTO syll_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Heshe asta Mishor desho aḳal deḳa dile, proza oḳole aia Feraunor gese ḳani magila, teu Feraune ḳoila, “Tumra Iusufor gese zao. Ein zela ḳoin, ṭik-u oula ḳoro.” ");
INSERT INTO syll_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","I aḳal asta desh zuṛi deḳa dilo. Bade aro bezuita oae Iusufe hoḳol zagar gudam gorain kulia, Mishori oḳlor gese dan besat lagla. ");
INSERT INTO syll_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Asta duniait nidan deḳa dilo ar hoḳol deshor manshe dan ḳorid ḳorar lagi Mishor desho Iusufor gese aila. ");
INSERT INTO syll_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Iakube-o hunla Mishor desho dan ase, ou tan fuaintore ḳoila, “Tumra egue arogur mukor bae sai roiso ḳene? ");
INSERT INTO syll_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Huno, ami hunchi, Mishor desho dan ase, tumra hono gia amrar lagi kisu dan loia ano, teu amra i moron takia zane basmu.” ");
INSERT INTO syll_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ou Iusufor dosho baie dan loia anar lagi Mishoro gela. ");
INSERT INTO syll_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Oile Iakube Iusufor afon maʼr feṭor bai Bin-Iaminre tarar loge zaite dila na, tain ḳoila, er kunu bifod oizito fare. ");
INSERT INTO syll_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Dan ḳoridor lagi Kenan desh taki zera Mishoro gelo, Israilor fuain-o tarar dolor logo oia gela, ḳaron Kenan desho-o aḳal asil. ");
INSERT INTO syll_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","I shomoy Iusuf-u asla Mishor deshor hokkoltar malik. Deshor hoḳol manshor gese tain-u dan besta. Teu Iusufor baiain-o tan gese gia, tara matare maṭit lagaia tanre ijjot ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Iusufe tan baiaintore dekia-u sinilila, oile na sinar ban ḳoria, tain kub ḳoṛa golae tarare zikaila, “Tumra kuai taki aiso?” Tara ḳoila, “Amra Kenan desh tone aisi, dan nibar lagi.” ");
INSERT INTO syll_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Iusufe tan baiainre hasaror sinle-o, baiainte tanre sinla na. ");
INSERT INTO syll_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Tain erare loia kuabe zeta deḳsla, hou ḳota tan mono oilo. Ou tain erare ḳoila, “Tumra to guia! Amrar deshor fak-fuḳor ota deḳat aiso.” ");
INSERT INTO syll_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Tara ḳoila, “Ji na huzur, afnar i gulam oḳole ḳali dan loat aisi. ");
INSERT INTO syll_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Amra to hoḳol eḳ bafor aolad ar saichcha manush; afnar i gulam oḳol kunu guia nae.” ");
INSERT INTO syll_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Iusufe hirbar tarare ḳoila, “Na, na, tumra amar deshor fak-fuḳor deḳat aiso.” ");
INSERT INTO syll_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Tara ḳoila, “Afnar gulam oḳol, hoḳole milia baro bai. Amra Kenan deshor eḳ bafor aolad. Amrar huru bai oḳon babar gese roise, ar aroḳ bai nae.” ");
INSERT INTO syll_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Iusufe tarare ḳoila, “Na, na, ami ṭik-u ḳoisi, tumra guia-u! ");
INSERT INTO syll_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Te tumrar forikka ola-u oizauk: ami Feraunor zanor ḳosom ḳori koiar, tumrar huru bai ono na aile, tumra-o in tone saṛa faitae nae. ");
INSERT INTO syll_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Tumrar eḳzonre faṭaia, tumrar hou baire anao ar baki hoḳole bondi ro. Ou forikkae tumrar mator hasa-misa buzmu. Tare na anle, ami Feraunor zanor ḳosom ḳori koiar, tumra nisoy guia!” ");
INSERT INTO syll_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ar Iusufe tin din tarare azot ḳanat bondi kori toila. ");
INSERT INTO syll_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Heshe tin dinor din, Iusufe tarare ḳoila, “Huno, ami to Allare ḍorai, tumra baste saile, ami zela ḳoi, oula ḳoro. ");
INSERT INTO syll_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Tumra hasaror saichcha manush oile, tumrar eḳ bai azoto taḳouk ar baki hoḳole tumrar aḳali foribaror lagi dan loia zaogi. ");
INSERT INTO syll_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Tumrar mat hasa ki na iṭa buzar lagi, tumrar huru baire amar gese loia aio. Teu tumra mortae nae.” Ou tara-o razi oila. ");
INSERT INTO syll_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Bade tara mata-mati korla, “Hasau to, amrar hi bair loge zeta ḳorsi ita oinnae. He amrar gese ḳaz-minoti korle-o, amra tar mato ḳan disi na. Erlagi amrar ufre i mosibot aise.” ");
INSERT INTO syll_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Teu Rubene tarare ḳoila, “Ami to tumrare ḳoislam, tar ufre kunu zulum ḳorio na, tumra hunlae na. Deḳo, oḳon tar lour hishab-nikash dite or.” ");
INSERT INTO syll_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Oile Iusufe zen tarar mat buzra, ita tara zanlo na. Ḳaron tain mat buzaora eḳzonre maze rakia, tarar loge matta. ");
INSERT INTO syll_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Teu Iusufe tarar ges tone horia gia ḳandita lagla. Bade hirbar aia tarar loge matila ar tain Shimionre doria tarar samne-u bandailla. ");
INSERT INTO syll_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Bade Iusufe tarar bostar maze dan boraia, zarzir ṭeḳa tar bostat firai dia, erar fotor ḳanir mosa deoar lagi hukum dila. Ar oula ḳora oilo. ");
INSERT INTO syll_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Heshe tara zarzir gadar fiṭit danor gaiṭ bandia roana oila. ");
INSERT INTO syll_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Foto ziranir zagat gia zebla eḳzone gadare ḳaoanir lagi bosta kullo, ar deḳlo, bostar muko tar ṭeḳar kuti. ");
INSERT INTO syll_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ou he tar baiainre ḳoilo, “Deḳo, deḳo, amar ṭeḳa amar bostat firot deoa oise.” Dekia-u tarar zan uṛi gelo ar ḍoraia ḳafte ḳafte ḳoilo, “Allae amrare ita kita ḳorla?” ");
INSERT INTO syll_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Bade Kenan desho gia tarar baf Iakubor gese azir oia, ita hoḳolta hunaia ḳoila, ");
INSERT INTO syll_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Hi deshor malike, amrare kub ḳoṛa golae ḳoisoin, amra guia oia hi desho gesi. ");
INSERT INTO syll_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Amra ḳoisi, amra hok manush, kunu guia nae. ");
INSERT INTO syll_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Amra barozon bai, eḳ bafor baro fua, oile amrar eḳzon nae ar hoḳol tone huru bai oḳon Kenan desho babar gese roise. ");
INSERT INTO syll_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ou hi manshe, zein hi deshor malik, tain amrare ḳoila, ‘Ami oula buzmu zen, tumra hok manush. Tumrar eḳ baire amar gese toia, tumrar aḳali foribaror lagi dan loia zao. ");
INSERT INTO syll_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ar tumrar huru baire amar gese loia aio. Teu ami buzmu, tumra hok manush, kunu guia nae. Bade ami tumrar baire firai dimu ar tumra i desho ḳay-ḳarbar ḳortae farbae.’ ” ");
INSERT INTO syll_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Bade tara bosta tone dan ḍalte-u deḳoin, tarar hoḳlor ṭeḳar kuti bostar maze roise. Ita dekia tarar bafe ar tara-o ḍoraigela. ");
INSERT INTO syll_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Teu bafe tarare ḳoila, “Tumra amare aolad saṛa banaiso. Iusuf nae, Shimion-o nae ar oḳon tumra hirbar Bin-Iaminre-o nitae sairae. Ita hoḳolta-u amar zulum.” ");
INSERT INTO syll_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rubene tan bafre ḳoila, “Ami Bin-Iaminre tumar gese firaia ante na farle, tumi amar duio fuare kun ḳorilio. Tare tumi amar ato saṛi deo, ami tare tumar gese firaia anmu.” ");
INSERT INTO syll_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Iakube ḳoila, “Na, amar i fua tumrar loge ditam nae. Tar bai morigese, ar oḳon he eḳla zita ase. Tumrar zaoar foto zudi tar kunu bifod oy, te ou faḳna sule bout duk dia tumra amare ḳoyboro haraibae.” ");
INSERT INTO syll_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Kenan deshor aḳalor dosha aro behal oilo. ");
INSERT INTO syll_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ar Mishor desh tone zeta dan nisla, ita fuṛai gele Israile ḳoila, “Tumra hirbar gia amrar lagi aro kisu ḳani-kuraki loia anogi.” ");
INSERT INTO syll_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Teu Ehudae tanre ḳoilo, “Hou manshe amrare kub ḳoṛa bashae ḳoia disoin, ‘Tumrar bai tumrar loge na aile tumra ar amar samne aio na.’ ");
INSERT INTO syll_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Oḳon tumi amrar baire amrar loge ḳori deo, teu amra gia tumar lagi kani loia aimu. ");
INSERT INTO syll_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ar tare loge na dile amra-o zaitam nae. Hi manshe amrare ḳoia disoin, ‘Tumrar baire loge na anle, tumra ar amar samne aio na.’ ” ");
INSERT INTO syll_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israile ḳoila, “Tumra ḳene amar loge oula fatrami korlae? Tumrar aroḳ bai ase, ita tanre ḳene ḳoilae?” ");
INSERT INTO syll_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Tara ḳoila, “Hi manshe amrar ar amrar foribaror aga-guṛi hokkolta zikaisoin, ‘Tumrar baf kita oḳono zinda asoin ni? Tumrar ar kunu bai asoin ni?’ Amra ḳali tan soalor zuaf dislam, amra kunu zantam ni, tain ḳoiba tumrar baire-o loia aio?” ");
INSERT INTO syll_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ehudae tan bafre ḳoila, “Tare amar loge ḳori dilao, amra zoldi zoldi roana oizai, teu tumi, amra ar amrar huruttain hokkol-u zane basmu, ḳeu mortam nae. ");
INSERT INTO syll_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ami nize-u tar lagi zamin roilam, tare amar ges tone shomzia nio. Ami tare tumar gese firaia na anle, tumar gese azir na ḳorle, hara zindegi bora ami tumar gese dayi roimu. ");
INSERT INTO syll_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ar oto deri na ḳorle, amra otodine duibar guria aitam farlam one.” ");
INSERT INTO syll_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ou tarar baf Israile ḳoila, “Oula oile ek kam ḳoro, tumra zarzir begor maze onor bala bala mal, agor, mou, kushboy moshla, meshke-ambor, pesta ar badam boria hou manshor lagi salami loia zao. ");
INSERT INTO syll_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ar tumrar loge ḳori agor ḍabul ṭeḳa neo, bostar muko ze ṭeḳa firot aise, ta-o hirbar loia zao, ki zani kunu bul oigesil. ");
INSERT INTO syll_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Tumrar i baire loge loia, zoldi kori hou manshor gese zao. ");
INSERT INTO syll_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Shorbo-shoktiman Allae tumrar lagi hou manshor dilo meherbani foyda ḳoroukka, zate tain tumrar hou bai ar Bin-Iaminre tumrar ato firot dein. Ar amar fua kuani gele, na oy gelo-u.” ");
INSERT INTO syll_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Teu tara hou salami, ḍabul ṭeḳa ar Bin-Iaminre loia roana oia, Mishor desho fosia Iusufor samne azir oila. ");
INSERT INTO syll_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Tarar loge Bin-Iaminre dekia Iusufe tan baṛir ḳadimre ḳoila, “Ou manush oḳolre baṛir bitre neo ar ḳoshi zobo ḳoria gust rando. Tara madane amar loge ḳaiba.” ");
INSERT INTO syll_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Iusufe zela ḳoila, ḳadime-o ṭik oula ḳorlo, he erare baṛir bitre loia gelo. ");
INSERT INTO syll_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ar he erare Iusufor baṛir bitre neoae, tara ḍoraia mata-mati korla, “Agor fira ze ṭeḳa amrar bostat ḳori firot gesil, otar lagi-u amrare ono nira, oḳon amrar dush deḳaia mair-doir ḳoria amrare gulam banaiba, ar gada oḳol-o ḳaṛia niba.” ");
INSERT INTO syll_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Teu Iusufor baṛir dorzar samne aia tara baṛir ḳadimre ḳoila, ");
INSERT INTO syll_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Huzur, amra er age-o dan loat aislam, ");
INSERT INTO syll_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","heshe firot zaoar bala, dom loibar zagat fosia, bosta kulte-u deki, amrar fura ṭeḳa-foysha zarzir bostar muko roise, oḳon ou ṭeḳa firot anchi. ");
INSERT INTO syll_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ar dan neoar lagi aro ṭeḳa anchi, oile hi ṭeḳa amrar bostar bitre ḳe toisil zani na.” ");
INSERT INTO syll_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ou ḳadime ḳoilo, “Tumrar balai ouk, ḍoraio na. Tumrar ar tumrar bafor Allae, i gaibi don tumrar bostar maze disoin. Tumrar ṭeḳa ami faisi.” Bade he Shimionre bar ḳoria tarar gese loia ailo. ");
INSERT INTO syll_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","He hoḳolre Iusufor baṛir bitre nia fani dilo tara fao duila ar he tarar gada oḳolre-o ḳani dilo. ");
INSERT INTO syll_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Iusuf madane aiba gotike, era tarar salami oḳol zuit ḳorla. Tara hunsla zen, tan loge-u tarar ḳana-dana oibo. ");
INSERT INTO syll_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Bade Iusuf baṛit aile, tarar hou salami oḳol goror bitre nia tanre dila, dia harle tanre soizda ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Tarar bala-bura ḳobor hunia tain zikaila, “Tumrar ze murobbi bafor ḳota ḳoislae, tain bala asoin ni? Tain zinda asoin ni?” ");
INSERT INTO syll_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Tara zuaf dila, “Ji oy, afnar gulam amrar baba oḳono zinda asoin ar bala asoin.” Heshe tara mata nuaia tanre ijjot ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Iusufe souk tulia tan nizor bai Bin-Iaminre dekia ḳoila, “Ouni tumrar hou huru bai, zar ḳota age ḳoislae?” Tain Bin-Iaminre ḳoila, “Allae tumare rohom ḳoroukka.” ");
INSERT INTO syll_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Baire dekia Iusufor dil ḳandito laglo. Tain zoldi kori bar oia, nizor kuṭat gia ḳandila. ");
INSERT INTO syll_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Bade souk-muk doia bar oia aila ar nizore shamlaia ḳani bilaibar hukum dila. ");
INSERT INTO syll_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ou Iusufre, tan baiainre ar tan loge ḳaneala Mishori oḳolre alog alog zagat ḳani dila. Ḳaron Mishorinte Ibrani oḳlor loge boia ḳana-dana ḳorto na, ita tara gin ḳoroin. ");
INSERT INTO syll_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Tara Iusufor samne tan baiainre boṛore boṛor zagat, hurure hurur zagat boaila, teu tara taijjub oia eḳzone aroḳzonor bae sai roila. ");
INSERT INTO syll_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ar Iusufe nizor talor ḳani tone tan baiainre deoaila, oile Bin-Iaminre hoḳol tone fas gun beshi deoa oilo. Ḳaia harle tara kushi oia uṭla. ");
INSERT INTO syll_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Bade Iusufe tan baṛir ḳadimre ou laḳan hukum dila, “I manush oḳlor bostat zoto dan zaga oy, boria dilao ar zarzir ṭeḳa tar bostar muko toio. ");
INSERT INTO syll_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Oile ou huru zonor bostar muko tar ṭeḳar loge amar rufar baṭi-o toio.” Iusufe tare zela ḳoila, he oula ḳorlo. ");
INSERT INTO syll_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Bador din biane-u tara gada loia bidae oila. ");
INSERT INTO syll_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Tara ṭaun taki tuṛa duroi zaite-u Iusufe tan baṛir ḳadimre ḳoila, “Zoldi kori erar ḳore douṛaia gia, erar lagal faia harle ḳoibae, tumra ufoḳaror bodla ḳene ḳeti korlae? Amar munibor rufar baṭi kene suri korlae? ");
INSERT INTO syll_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ou baṭit ḳoria to tain shorbot-fani kain ar todbiror ḳam-o ḳoroin. Tumra ita kub oinnae ḳorso.” ");
INSERT INTO syll_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Hi kadime tarar ḳoredi gia lagal faia ou laḳan ḳoilo. ");
INSERT INTO syll_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Oile tara ḳoila, “Huzur ila mat ḳene matira? Afnar gulam oḳole kunu laḳan-u ita ḳam ḳorto nae. ");
INSERT INTO syll_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Deḳoukka, agorbar amrar bostar muko ze ṭeḳa faislam, ita amra Kenan desh tone hirbar afnar gese firot anchi, te amra kunu afnar munibor baṛi tone shuna-rufa suri kormu ni? ");
INSERT INTO syll_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Afnar i gulam oḳlor maze zar gese ou baṭi faiba, tare marilaiba ar amra-o huzuror gulam oizimu.” ");
INSERT INTO syll_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Teu ḳadime ḳoilo, “Bala ḳota, te tumra zela ḳoilae, oula-u ouk. Zar gese ou baṭi milbo, ḳali tare amar gulam banaimu ar baki hoḳol ḳalas faibae.” ");
INSERT INTO syll_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ou tara zoldi kori hoḳlor bosta maṭit lamaia kullo. ");
INSERT INTO syll_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ar ḳadime boṛo bai tone huru bai tori hoḳlor bosta tukaile-o heshe Bin-Iaminor bostat hi baṭi millo. ");
INSERT INTO syll_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Teu tara zarzir finnor ḳafoṛ faṛilla, bade hirbar gadar fiṭit gaiṭ bandia ṭauno ailo. ");
INSERT INTO syll_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Teu Ehuda ar tar baiain Iusufor baṛit gela, i shomoy tain hono asla. Tara tan samne gia maṭit foṛla. ");
INSERT INTO syll_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Iusufe tarare ḳoila, “Tumra ita kita ḳorlae? Ami zen hoḳolta gontam fari, ita tumra zano na ni?” ");
INSERT INTO syll_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ehudae ḳoilo, “Huzuror gese amra kita ḳoimu? Kita zuaf dimu? Ar kila amrare be-ḳosur ḳoitam? Allae-u tan gulam oḳlor dush deḳai disoin, te zar gese i baṭi milche, he ar amra hoḳole-u huzuror gulam oilam.” ");
INSERT INTO syll_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Oile Iusufe ḳoila, “Na, na, ami i kam kunu laḳan-u ḳortam nae. Zar gese ou baṭi milche, he-u amar gulam oibo, baki shob sohi-salamote tumrar bafor gese zaogi.” ");
INSERT INTO syll_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Teu Ehudae Iusufor ḳasat gia ḳoilo, “Huzur afne to Feraunor homan, te doya ḳori afnar gulamre ekkan mat matar shuzug deukka. Afnar gulamor ufre gusa oin na zen. ");
INSERT INTO syll_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Huzure age i gulam oḳolre zikaisla, tumrar baf ba kunu bai asoin ni. ");
INSERT INTO syll_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Amra zuaf dislam, amrar murobbi baba zinda asoin, ar tan heshḳali boyoshor egu fua ase. Tar bai morigese, ar he eḳ maʼr eḳ fut gotike babae tare kub maya ḳoroin. ");
INSERT INTO syll_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Bade afnar i gulam oḳolre ḳoisla, tare amar gese loia aio, ami tare nizor souke deḳmu. ");
INSERT INTO syll_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Hi shomoy amra huzurre ḳoislam, babare toia he aito farto nae ar toia aile-o baba mara zaiba. ");
INSERT INTO syll_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Oile afne i gulam oḳolre ḳoisla, tumrar huru baire loge na anle, tumra ar amar samne aio na. ");
INSERT INTO syll_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Erlagi amra firia gia afnar gulam, amrar babare huzuror hoḳol ḳota hunaislam. ");
INSERT INTO syll_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Bade babae ḳoila, tumra hirbar gia amrar lagi aro tuṛa dan loia anogi. ");
INSERT INTO syll_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Teu amra ḳoilam, amrar huru baire loge dile amra zaimu, arnae amra gia hi manshor samne muk deḳaitam nae. ");
INSERT INTO syll_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ou afnar gulam, amrar babae ḳoila, tumra to zano, amar i bibir torofa dugu fua asil. ");
INSERT INTO syll_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Erar eḳzon amar sokur samon taki bar oia gelo, ar to kunudin tare deḳlam na, ami buzlam zen, nisoy kunu zanuare tare siṛi-biṛilaise. ");
INSERT INTO syll_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Oḳon tumra ere-o amar ges tone nilegi ar er kunu ḳeti oile, tar duke tumra amare ou faḳna sule ḳoyboro haraibae. ");
INSERT INTO syll_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Erlagi oḳon zudi afnar gulam, amar babar gese ami zai ar tan i fuare loge na deḳoin, te er zanor loge tan zan ekḳano banda gotike, ");
INSERT INTO syll_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","tare na deḳle, tain nisoy mara zaiba. Afnar gulam, amrar murobbi baf bout duke faḳna sul loia ḳoyboro hamaiba. ");
INSERT INTO syll_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ar afnar gulam ami, amar babar gese tar lagi zamin oia ḳoisi zen, tare firaia ante na farle, hara zindegi bora ami tumar gese dabit roimu. ");
INSERT INTO syll_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Te huzur ami minoti koriar, tar bodla ami afnar gulami kormu ar tare afne erar loge zaibar dilaukka. ");
INSERT INTO syll_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ere loge na nia ami kila babar gese zaimu? Naile babar zanor shorbonash amar nizor souke deḳon lagbo.” ");
INSERT INTO syll_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Iusufe tan ḳormosari oḳlor samne nizore ar ṭik raḳta farla na, tain sillaia ḳoila, “Amar ges tone hokkol hori zao!” Teu baiaintor gese nizor forisoy deoar shomoy tan samne ar ḳeu roilo na. ");
INSERT INTO syll_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Tain sillaia ḳandon shuru ḳorla, teu Mishori oḳole ita hunla ar Feraunor baṛir manshe-o i kobor faila. ");
INSERT INTO syll_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Iusufe tan baiaintore ḳoila, “Ami Iusuf; amar baba oḳono zinda asoin ni?” Ou tan baiainte ḍoraia zoban bond oigelo, matta farla na. ");
INSERT INTO syll_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Teu Iusufe tan baiainre ḳoila, “Tumra amar ḳasat ao.” Tara ḳasat aile tain ḳoila, “Ami tumrar hou bai Iusuf, Mishoro zaora befari oḳlor gese, tumra zare besilaislae. ");
INSERT INTO syll_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Oile tumra amare besislae ḳori oḳon bezar oio na, ba nizor ufre naraz oio na. Manshor zanor hefazotor lagi, Allae-u tumrar age amare ono faṭaisoin. ");
INSERT INTO syll_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Aḳal soler ou dui boros dori, te aro fas boros kunu ḳet-ḳamar ba foshol folto nae. ");
INSERT INTO syll_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Duniait tumrar aolad oḳolre basaia raḳar lagi Allae-u tan kudrote tumrar age amare faṭaisoin. ");
INSERT INTO syll_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Teu buza zae zen, tumra amare ino faṭaiso na, Allae-u faṭaisoin. Tain amare Feraunor bafor homani koria tan foribaror saloḳdar banaisoin, ar hara Mishor desh shashonor eḳtiar disoin. ");
INSERT INTO syll_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Oḳon tumra zoldi kori babar gese gia ḳo, tan fua Iusufe ḳoise, Allae amare hara Mishor deshor saloḳdar banaisoin, te tumi ar deri na ḳoria amar gese aio. ");
INSERT INTO syll_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Tumi, tumar fua-fuṛin, nati-futi, goru-meṛar fal ar tumar zotota ase, hokkolta loia amar gese Gushon elaḳat roibae. ");
INSERT INTO syll_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Hono ami tumare deḳa-huna ḳormu, aḳal to aro fas boros roibo, arnae tumitain hoḳole i aḳale behalot oizitae faro. ");
INSERT INTO syll_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Amar afon bai Bin-Iamine ar tumra hoḳole nizor souke deḳrae zen, ami nizor muke tumrar loge matram. ");
INSERT INTO syll_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Mishor desho amar zeta dafoṭ, man-ijjot deḳrae, tumra amar babare ita ḳoibae, ar tanre zoldi kori oḳano loia aibae.” ");
INSERT INTO syll_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Heshe Iusufe tan bai Bin-Iaminor golat ainja ḳori doria ḳandon shuru ḳorla ar Bin-Iamine-o golat dori kanda-ḳaṭi korla. ");
INSERT INTO syll_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Bade Iusufe tan hoḳol baiainre hunga dila ar tarar golat dori-o ḳandila. Teu baiainte-o tan loge mat-ḳota matla. ");
INSERT INTO syll_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Iusufor baiain aoar ḳobor Feraunor baṛit fosile, Feraun ar tan ḳormosari oḳol kushi oila. ");
INSERT INTO syll_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Feraune Iusufre ḳoila, “Tumar baiainre ḳo zen, tumra gadar fiṭit danor bosta bandia Kenan desho gia, ");
INSERT INTO syll_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","babare ar tumrar foribaror hokkolre loia amar gese aio. Ami tumrare Mishoror bala bala siz oḳol dimu ar tumra deshor hoḳol tone bala zaga-o faibae. ");
INSERT INTO syll_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ar tumrare ami hukum diar, tumra zarzir bou, fua-fuṛintor lagi Mishor desh taki gaṛi loia gia, tarare ar babare loia aio. ");
INSERT INTO syll_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ar hono tumrar mal-samanar lagi maya deḳaio na, hara Mishor deshor bala bala siz oḳol to tumrar-u.” ");
INSERT INTO syll_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Israilor fuainte oula-u ḳorla. Feraunor hukume Iusufe tarar lagi gaṛi ar fotor ḳanir mosa dila. ");
INSERT INTO syll_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Tain era hokkolre eḳ seṭ ḳoria ḳafoṛ dila, oile Bin-Iaminre dila fas seṭ ḳafoṛ ar tin-sho rufar ṭeḳa. ");
INSERT INTO syll_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Tain tan bafor lagi doshgu gadar fiṭit ḳori Mishoror bala bala siz oḳol, ar doshgu gadir fiṭit ḳori kanir lagi ruṭi ar dan buzai kori faṭaila. ");
INSERT INTO syll_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ou laḳan tan baiaintore bidae dila, bidae bala tain erare ḳoila, “Tumra foto laga-lagi korio na.” ");
INSERT INTO syll_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Bade tara Mishor tone Kenan desho, tarar baf Iakubor gese gia ḳoila, ");
INSERT INTO syll_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","“Iusuf oḳono zinda ase. He to oḳon asta Mishor deshor ortaḳorta.” Oile ita hunia Iakubor hush uṛi gelo, tan bishash-u oilo na. ");
INSERT INTO syll_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Bade Iusufe tarare zeta ḳoia disla ita hunia, ar tane neoar lagi Iusufor faṭail gaṛin dekia, tarar baf Iakubor hush ṭik oilo. ");
INSERT INTO syll_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Israile ḳoila, “Amar fua Iusuf zen oḳono zita ase, oṭa-u to bout, morar age ami gia tare deḳa-u lagbo.” ");
INSERT INTO syll_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israile tan hokkolta loia bar oigela. Ar Ber-Shebat aia tan baf Isʼhakor Allar name kurbani korla. ");
INSERT INTO syll_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Bade raitor bala Allae Israilre didar dia ḳoila, “O Iakub, Iakub!” Tain zuaf dila, “Ounu ami.” ");
INSERT INTO syll_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Allae formaila, “Ami Alla, tumar bafor Mabud. Tumi Mishoro zaite ḍoraio na, hono ami tumar eḳ biraṭ zati foyda ḳormu. ");
INSERT INTO syll_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ami tumar loge loge Mishoro zaimu, ar ami-u tumare hirbar firaia anmu ar tumar fua Iusufe tumar souk muzaia dibo.” ");
INSERT INTO syll_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Bade Iakube Ber-Sheba taki roana oila. Feraune tarare neoar lagi zeta gaṛin disla, Israilor fuainte otat ḳori tarar bafre ar tarar bou, fua-fuṛinre loia gela. ");
INSERT INTO syll_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Heshe Iakub, tan fuain ar tan fura gusṭi, foshur fal oḳol ar Kenan desho ḳamai kora hokkol don-doulot loia Mishoro fosla. ");
INSERT INTO syll_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Ou laḳan Iakube tan fua-fuṛin, nati-natin, fura gusṭir hokkolre loia Mishoro faroigela. ");
INSERT INTO syll_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Boni Israil, mani Iakub ar tan aolad oḳol zera Mishoro gesla, tarar ḳandan-nama oilo: Iakubor boṛo fua Ruben; ");
INSERT INTO syll_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ar Rubenor fuain: Honuk, Falu, Hasir ar Kormi. ");
INSERT INTO syll_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Shimionor fuain: Zimuel, Zamin, Ohod, Zakin, Shuhor, ar Kenani bour torofa Shoul. ");
INSERT INTO syll_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lebir fuain: Zarsun, Kahat ar Marari. ");
INSERT INTO syll_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ehudar fuain: Eir, Onon, Shela, Firuz ar Zarah. Oile Onon ar Eir Kenan desho-u mori gesla. Firuzor fuain: Hasir ar Hamul. ");
INSERT INTO syll_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaḳoror fuain: Tola, Foa, Zashub ar Shimron. ");
INSERT INTO syll_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sobulonor fuain: Sered, Elon ar Zoholel. ");
INSERT INTO syll_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Tara oila Lear huruttain, Foddon-Iramo Lear torofa Iakubor i huruttain ar tan fuṛi Dinar zonmo oisil, era hokkoltae tetrish zon. ");
INSERT INTO syll_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Sadur fuain oila: Sifon, Hogi, Shuni, Ishbun, Eiri, Orudi ar Oreli. ");
INSERT INTO syll_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ashiror fuain: Imna, Zisba, Zisbi, Boria ar tarar boin Sera. Boriar fuain: Hebor ar Molkiel. ");
INSERT INTO syll_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Tara oila Zilpar huruttain, Labone tan fuṛi Lear loge ou bandi Zilpare disla, era hoḳol-u tair torofa Iakubor huruttain, ou shullo zon. ");
INSERT INTO syll_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Iakubor bibi Rahelar fuain oila: Iusuf ar Bin-Iamin. ");
INSERT INTO syll_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Iusufor fuain Manosha ar Afraim Mishor desho zonmisla. Erar ma oila Oun mondiror babon-ṭakur, Puṭiferar fuṛi Asonot. ");
INSERT INTO syll_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Bin-Iaminor fuain: Bela, Beḳor, Oshbel, Gera, Naman, Ehi, Rush, Muppim, Huppim ar Ord. ");
INSERT INTO syll_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Tara oila Rahelar torofa Iakubor huruttain, ou souddo zon. ");
INSERT INTO syll_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Danor fua: Hushim. ");
INSERT INTO syll_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Noftalir fuain: Johoshiel, Guni, Izer ar Shillem. ");
INSERT INTO syll_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Tara oila Bilhar huruttain, Labone tan fuṛi Rahelar loge ou bandi Bilhare disla. Era hoḳol-u tair torofa Iakubor huruttain, ou shat zon. ");
INSERT INTO syll_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Iakubor nanan torofar zonmor zara Mishoro aila, tan fuaintor bou bad dia era hoḳole milia soyshoṭṭi zon asla. ");
INSERT INTO syll_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Mishor desho Iusufor duizon fua zonmisla. Era shoho Iakubor foribaror zara Mishoro aila, tara muṭ shottoir zon. ");
INSERT INTO syll_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Er age Iakube Ehudare Iusufor gese faṭaila, Gushono zaoar fot sinar lagi, teu tara hokkol ono gia fosla. ");
INSERT INTO syll_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Ar Iusufe-o guṛar gaṛi hazaia tan baf Israilor loge Gushono deḳa ḳorat gela, ar tanre dekia-u ainja ḳori golat doria bout shomoy ḳandila. ");
INSERT INTO syll_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Teu Israile Iusufre ḳoila, “Tumi zen zinda aso re fut, iṭa nizor souke deḳlam. Oḳon shantie-u mortam farmu.” ");
INSERT INTO syll_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ou Iusufe tan baiaintore ar tan bafor logor hoḳolre ḳoila, “Ami gia Feraunre zanaimu, amar baiain ar amar bafor baṛir hoḳol, Kenan desh tone amar gese aichchoin. ");
INSERT INTO syll_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Tarar ḳam oilo foshu fala. Tara to sagol-meṛa faloin, ar tarar foshur fal oḳol ar hokkol mal-samana loia aichchoin. ");
INSERT INTO syll_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Feraune zebla tumrare zikaiba, afnara kita ḳam ḳoroin? ");
INSERT INTO syll_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Ou shomoy tumra ḳoio, afnar i gulam oḳole ar tarar baf-dada oḳole-o huruman tone-u foshu falia basoin. Teu tumra Gushono roitae farbae. Ḳaron foshu falra manshore Mishori oḳole gin ḳoroin.” ");
INSERT INTO syll_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Iusufe Feraunor gese gia ḳoila, “Amar baba ar baiainte, tarar goru-sagol ar tarar hokkolta loia, Kenan desh saṛia aisoin. Tara aia Gushono fosi gesoin.” ");
INSERT INTO syll_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Baiaintor maze fas zonre nia tain Feraunor samne azir ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Feraune tarare zikaila, “Tumra kita ḳam ḳoro?” Tara ḳoila, “Afnar i gulam oḳole baf-dadar amol taki-u foshu fali.” ");
INSERT INTO syll_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Tara hirbar ḳoila, “Amra i desho musafir oia taḳar lagi aisi. Kenan desho oḳon bezuita nidan soler ḳori, hino amrar foshur falor kuraki nae. Erlagi doya ḳori afnar i gulam oḳolre, Gushono roibar shuzug deukka.” ");
INSERT INTO syll_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Feraune Iusufre ḳoila, “Tumar baf-baiain tumar gese aisoin; ");
INSERT INTO syll_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","asta Mishor desh-u to tumar samne foṛi roise. Deshor hoḳol taki bala zagat tarare roite deo, tara Gushono-u taḳouk ar erar maze zoiggo manush faile, tarare amar foshur falor saloḳdar banailao.” ");
INSERT INTO syll_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Bade Iusufe tan baf Iakubre Feraunor samne anaila ar Iakube Feraunre dua dila. ");
INSERT INTO syll_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Feraune Iakubre zikaila, “Afnar boyosh ḳoto oise?” ");
INSERT INTO syll_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Iakube ḳoila, “Duniait amar musafirir ayu eḳ-sho tish boros oise, ita to beshi nae, ar kub toklife-u i din ḳaṭse; amar baf-dadar musafirir ayur homan oḳono oise na.” ");
INSERT INTO syll_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Heshe Iakube Feraunre dua ḳoria bidae loila. ");
INSERT INTO syll_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Teu Iusufe Feraunor hukum moto, tan baf-baiainre Mishor deshor hoḳol taki bala zaga, Ramashesh elaḳat roita dila. ");
INSERT INTO syll_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Iusufe tan baf-baiain ar tarar foribarre zarzir dorḳari, ḳani-kuraki hoḳolta zugai dila. ");
INSERT INTO syll_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Bade aḳal aro betaya oilo, deshor kunu zagat ḳanir kunta asil na. Teu Mishor ar Kenan desh ekkebare ḳahil oigelo. ");
INSERT INTO syll_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Mishor ar Kenan deshor manshor zoto ṭeḳa-foysha shuna-rufa asil, itadi tara dan ḳorid ḳorae, Iusufe ota dola ḳoria Feraunor banḍaro zomaila. ");
INSERT INTO syll_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Mishor ar Kenan deshor hoḳol shuna-rufa zebla fuṛai gelo, teu Mishori oḳole aia Iusufre ḳoila, “Amrare ḳanir kunta deukka. Amrar shuna-rufa fuṛai gese ḳori afnar souḳor samne morizitam ni?” ");
INSERT INTO syll_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Iusufe ḳoila, “Taile tumrar foshu oḳol ania deo, shuna-rufa fuṛai gele-o foshu oḳlor bodla ami tumrare ḳani-kuraki dimu.” ");
INSERT INTO syll_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Teu tara zarzir goru-sagol, guṛa-meṛa, gada-gadi Iusufor gese anla ar Iusufe er bodla tarare dan dila. Ou laḳan tarar hokkol foshur bodla, hi bosoror kuraki salaila. ");
INSERT INTO syll_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ar hi boros gelo, er bador boros manshe aia Iusufre ḳoila, “Huzuror gese amra kunta-u lukaiar na, amrar hoḳol shuna-rufa shesh oigese ar foshu oḳol-o afnare dilaisi. Oḳon amrar ar kunta-u roise na, ḳali ou shoril ar zaga-zomin saṛa. ");
INSERT INTO syll_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Erlagi afnar souḳor samne zomi-zoma shoho amra kila morizitam? Te afne amrare-o ar amrar hoḳol zomi-zoma-o loilaukka, amra Feraunor gulami kormu, ta-o amrare ḳani deukka ar bis deukka, teu amra-o mora tone basmu ar zomin ḳanain-o borbad oito nae.” ");
INSERT INTO syll_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ou Iusufe Mishor deshor hokkol zomin Feraunor name loilila, ḳaron i aḳal oula bezuita oisil zen, Mishoror hoḳole-u tarar zaga-zomin besilaila. Teu deshor hoḳol zomin Feraunor ato aillo. ");
INSERT INTO syll_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ar Iusufe Mishor deshor eḳ mata taki aroḳ matar hoḳol manshore ṭauno far ḳorilila. ");
INSERT INTO syll_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ḳali babon oḳlor zaga-zomin tain loila na, ḳaron erare Feraune beton dita, ar ota dia-u tara solta. ");
INSERT INTO syll_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Heshe Iusufe manshore ḳoila, “Huno, Feraunor name ami tumrare ar tumrar hoḳol zaga-zomin-o loililam. Oḳon tumra ou bis oḳol neo ar zomino bain ḳoro. ");
INSERT INTO syll_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Teu zomino zeta foshol folibo, er fas baṭor eḳ baṭ Feraunre dio ar baki sair baṭ, zominor bis, tumra ar tumrar foribar ar huruttaintor ḳanir lagi niogi.” ");
INSERT INTO syll_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Teu manshe ḳoila, “Afne amrar zan basaila. Huzure amrare doya ḳorle, amra Feraunor gulami kormu.” ");
INSERT INTO syll_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Bade Iusufe Mishor deshor zaga-zominor lagi ou ain zari korla, hoḳol fosholor fas baṭor eḳ baṭ Feraune faiba, ḳali babon oḳlor zomin bade. Ou ain oḳono soler. ");
INSERT INTO syll_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Boni Israile Mishor deshor Gushono boshot ḳorla. Tara honor doḳoldari faia, kub folala oila ar tarar bout aolad oila. ");
INSERT INTO syll_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Mishor desho aia Iakub shotro boros zinda roila. Teu tain hoḳoltae eḳ-sho shatsallish boros basila. ");
INSERT INTO syll_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Israilor moutor din ḳasaia aile tan fua Iusufre ḳobor di anaia ḳoila, “Amar bae tumar meherbani oile ekkan osiot ḳoraitam, tumi amar urator tole tumar atḳan harao, tumi amar bae doya ar halali deḳaio, amare Mishoro dafon ḳorio na. ");
INSERT INTO syll_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ami zebla amar baf-dadar gese zaimugi, ou shomoy tumi amare Mishor desh taki nia, amar baf-dadar ḳobrostano dafon ḳorio.” Iusufe ḳoila, “Afne zela ḳoila, oula-u ḳormu.” ");
INSERT INTO syll_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Teu Iakube ḳoila, “Te tumi amar gese ḳosom ḳoro.” Iusufe ḳosom ḳorla. Ou Israile tan bisnar hitan bae ḳait oila. ");
INSERT INTO syll_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Erbade Iusufe ḳobor faila, tan baf bemar, ou tan duio fua Manosha ar Afraimre loia bafre deḳat aila. ");
INSERT INTO syll_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Iakube zebla hunla, tan fua Iusuf aisoin, ou tain shorilor hoḳol bol ḳaṭaia, uṭia bisnat boila. ");
INSERT INTO syll_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ar tain Iusufre ḳoila, “Shorbo-shoktiman Allae Kenan deshor Luz ṭauno, amare didar dia borkot dan ḳoria ḳoisla, ");
INSERT INTO syll_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","‘Huno, ami tumare foldar ḳormu ar bout aolad dimu, tuma tone bout gusṭiala eḳ zati foyda ḳormu ar tumar oarish oḳolre, hameshakur lagi i deshor malikana dimu.’ ");
INSERT INTO syll_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ami tumar gese Mishoro aibar age, tumar ze duio fua Mishoro zonmisoin, tara amar-u. Ruben ar Shimion zela amar, oula Manosha ar Afraim-o amar oiba. ");
INSERT INTO syll_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Oile erar bade tumar zeta hurutta oisoin, tara tumar-u roiba, ar tarar bair name-u erar malikana ḳaim oibo. ");
INSERT INTO syll_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ar Foddon taki amra aoar shomoy, Kenan deshor Ifrat taki tuṛa duroi taḳte-u, Rahela mara gela. Teu ami honor Ifrato, Betelhamor fotor daro tanre dafon ḳorlam.” ");
INSERT INTO syll_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Bade Iusufor fuaintor bae saia Israile zikaila, “Era ḳe?” ");
INSERT INTO syll_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Iusufe tanre ḳoila, “Era amar fuain, Allae ou desho-u erare disoin.” Tain ḳoila, “Erare amar ḳasat ano. Ami tarare dua ḳortam.” ");
INSERT INTO syll_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Murobbi boyosho souḳor zuti komi zaoae Israile bala ḳori deḳta na. Teu era ḳasat aile, Israile tarare ainja ḳori doria hunga dila. ");
INSERT INTO syll_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Tain Iusufre ḳoila, “Babare, ami mono ḳorslam tumar muk ar kunu din deḳtam nae, oile Allae tumar aolad oḳolre-o deḳailila.” ");
INSERT INTO syll_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Teu Iusufe tan bafor ges tone, fuaintore horaia maṭit soizda ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ar Iusufe tan duio fuare loia, ḍain at dia Afraimre doria Israilor bau galat, ar bau at dia Manoshare doria Israilor ḍain galat ania azir ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Oile Israilor nizor aḳole, tan at aṛa-aṛi koria, ḍainor at huru fua Afraimor matat ar Iusufor boṛo fua Manoshar matat toila tan bau at. ");
INSERT INTO syll_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Bade tain Iusufre dua ḳoria ḳoila, “Hou Alla, zan morzie amar baf-dada, Ibrahim ar Isʼhake solta, hou Alla, zein foyla taki aiz forzonto amare falia aira, ");
INSERT INTO syll_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","hou firista, zein amare hoḳol mosibot taki basaisoin, tain-u ou duio fuare borkot nazil ḳoroukka. Erare dia-u Ibrahim ar Isʼhak ar amar nam zinda taḳouk. Duniair maze tarar bout gusṭi ouk.” ");
INSERT INTO syll_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Bafe tan ḍain at Afraimor matat raḳla ḳori Iusuf bezar oigela. Ar Afraimor mata taki horaia, Manoshar matat deoar lagi, tan bafor at usa ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Tain ato doria ḳoila, “Baba, i laḳan nae. Ounu amar boṛo fua, te afnar ḍain at tar matat raḳoukka.” ");
INSERT INTO syll_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Oile tan bafe na-kush oia ḳoila, “Babare, ami ita zani, ami ita zanire fut. Tar-o eḳ zati oibo ar mohan oibo, oile tar huru bai tar saite-o mohan oibo, ar tar aolador bout gusṭi oibo.” ");
INSERT INTO syll_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Israile erbade ou duio natire dua ḳoria ḳoila, “Boni Israile kunu manshore dua ḳorle oula ḳoiba, Allae tumare Afraim ar Manoshar laḳan ḳoroukka.” Oula tain Manoshar saite Afraimre boṛo banaila. ");
INSERT INTO syll_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Heshe Hozrot Israile Iusufre ḳoila, “Deḳo, amar moronor oḳt aichche. Alla tumrar loge roiba, ar tumrare hirbar tumrar baf-dadar desho nichchoy firaia niba. ");
INSERT INTO syll_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Tumar baiaintor saite tumare eḳ baṭ beshi dilam. Ou baṭ to Shikim elaḳa, ita amar toluar-donuk dia Amuri oḳlor ges taki anslam.” ");
INSERT INTO syll_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Bade Iakube tan fuaintore anaia ḳoila, “Tumra hokkol ekḳano o. Bobishote tumrar zindegi kila zaibo, ita ami tumrare ḳoiram. ");
INSERT INTO syll_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Iakubor fuain, tumra ekḳano ao; tumrar baf Israilor buli huno. ");
INSERT INTO syll_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben tumi amar boṛo fua, tumi amar bol, amar zuankir foyla fol; tumi hoḳol taki tezi ar himmoti. ");
INSERT INTO syll_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Tumi utrail gorom fanir laḳan, tumar boṛai roito nae; tumi afon bafor bisnat geso, haton maʼr loge nafaki kam ḳorso. ");
INSERT INTO syll_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Shimion ar Lebi dui bai; tarar toluar zalimor atiar. ");
INSERT INTO syll_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","O amar zan, tarar mozliso hamaio na; O amar shan, tarar shomazo zaio na. Tara gusa ḳori kun ḳorlo; aṛuami kori bisalor rog kaṭlo. ");
INSERT INTO syll_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Tarar gusa to lannoti, ita boṛo bezuita; lannoti tarar zulum, ita to fashan. Ami tarare Iakubor maze baṭimu; Boni Israilor maze sitrai dimu. ");
INSERT INTO syll_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Ehuda, tumar baiainte tumar tarif ḳorba; tumi dushmonor gordonat dorbae; tumar bafor oarish oḳole, tumar gese mata nuaiba. ");
INSERT INTO syll_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Tumi to shinghor baichcha Ehuda. Tumi shikaror gust ḳaia horia ailae; he shinghor laḳan leṭia hutia goṛiailo; shinghire ḳegue gum bangaito? ");
INSERT INTO syll_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ehudar at tone to raz-laṭi horto nae; tar duio faor maz tone bisaror goda zaito nae; zotodin Shilo na aiba, ar hoḳol zati tan hukume solba. ");
INSERT INTO syll_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","He angur gaso banbo tar gada; anguror shundor ḍalo banbo gadar baichcha; lal anguror roshdi duibo tar zubba, anguror loudi korbo lebas sofa. ");
INSERT INTO syll_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Tar souk anguror roshe lal ṭoḳṭoḳa, ar tar dat dudor laḳan dola. ");
INSERT INTO syll_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sobulon doriar faro boshot ḳoribo, he zaz biṛanir gaṭ oibo, Sidon forzonto tar shimana oibo. ");
INSERT INTO syll_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isaḳor egu bolala gada, he kuoṛor bitre hute. ");
INSERT INTO syll_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","He deḳlo ziranir zagaḳan bala, deshḳan shundor; teu gaiṭ boibar lagi kand lamailo, ar zuror gulam oilo. ");
INSERT INTO syll_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dane tar nizor proza oḳlor bisar ḳorbo, Israilor ek gusṭir laḳan. ");
INSERT INTO syll_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","He oibo shoṛokor daror haf, fotor bishala alod; zegie guṛar faot ḳamoṛ mare, guṛ-soar ḳoredi ulṭia foṛe. ");
INSERT INTO syll_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","O Mabud, ami tumar nazator muka sai roisi. ");
INSERT INTO syll_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Sadure luṭra dole hamla ḳorbo, bade he-o tarar ḳoredi luṭibo. ");
INSERT INTO syll_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ashiror kub bala foshol folibo, he bashshar zuka ḳani zugaibo. ");
INSERT INTO syll_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Noftali oilo saṛa horini, tar muko ase miṭa miṭa mat. ");
INSERT INTO syll_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Iusuf folala gasor ḍal, indarar daror folala gasor ḍal; tar ḍalain beṛ faroizae. ");
INSERT INTO syll_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Tir-donuk alainte tare bezuita toklif disla, tir maria tare beḳaydat falaisla; ");
INSERT INTO syll_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","oile tar donuk mozbut roilo, tar ator honat bol roilo; Iakubor hou mohan shoktialar at dia, zein Israilor asroy ṭilla, tanre dia. ");
INSERT INTO syll_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Tumar bafor hou Allare dia, zein tumare shaijjo ḳorba; hou Shorbo-shoktimanre dia, zein tumare borkot nazil ḳorba; ufre toa asman taki lamra borkote, tole bisail fani taki bar oa zornar borkote, bukur dud ar feṭ taki bar oa borkote. ");
INSERT INTO syll_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Amar baf-dadar dua taki, tumar bafor deoa dua bout bala ouk; ita hameshakur ḳaṛa hazail faṛ-forbot taki lamouk. Hou dua Iusufor matat foṛouk; baiain taki alogor matar talut foṛouk. ");
INSERT INTO syll_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Bin-Iamin oilo boṛo-bagor laḳan, he biane ḳae shikaror gust, ar hainjae bilae luṭor mal.” ");
INSERT INTO syll_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Era oila Israilor baro gusṭi, tarar bafe tarar lagi duar shomoy oula ḳoila. Tain era hokkolre zarzir faona dua dila. ");
INSERT INTO syll_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Bade Iakube tan fuaintore osiot ḳoraila zen, “Amar to baf-dadar gese zaoar shomoy oigese, te Hiṭṭi Ifrunor zominor guhat, amar baf-dadar ḳandat amare dafon ḳorio. ");
INSERT INTO syll_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","I guha Kenan deshor, Momrir daro Moḳfelar zomit. Ibrahime Hiṭṭi Ifrunor ges tone ou zomin loisla ḳobrostan bananir lagi. ");
INSERT INTO syll_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ono-u Ibrahim ar tan bibi Sayrare dafon ḳora oise, Isʼhak ar tan bibi Rebekare-o ono dafon ḳora oise, ar ami Leare-o ono dafon ḳorsi. ");
INSERT INTO syll_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","I zomin ar er mazor guha Hiṭṭi oḳlor ges tone loisla.” ");
INSERT INTO syll_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Iakube tan fuaintore osiot ḳora shesh oile, bisnar ufre tan duio fao ekḳano ḳorla ar aḳeri dom saṛia tan baf-dadar gese gelagi. ");
INSERT INTO syll_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Iusufe tan bafor mukor ufre muk lagaia ḳandita lagla ar tanre hunga dila. ");
INSERT INTO syll_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Bade tain nizor odinor hekim oḳolre hukum dila, tara tan bafor lashre momi banaibar lagi. Teu tara tan gotro momir moshla lagaila. ");
INSERT INTO syll_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Tara i kamo sallish din lagaila, ou ḳamo to sallish din-u lage. Ar Mishori oḳole tan lagi shottoir din boria ahazari korla. ");
INSERT INTO syll_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ou ahazarir dinor bade, Iusufe Feraunor baṛir manshore ḳoila, “Afnara zudi amare doya ḳoroin, te Feraunre amar ou ḳotaḳan zanaukka zen. ");
INSERT INTO syll_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Babae amare ḳosom ḳoraia ḳoisla, ‘Huno, ami to morizimu, te Kenan desho amar lagi zuit ḳora ḳoyboro amare dafon ḳorio.’ Teu oḳon tanre dafonor lagi, doya ḳori amare zaite deukka, babare ḳoybor dia-u ami hirbar aimu.” ");
INSERT INTO syll_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Feraune zuaf dila, “Tain tumare zela ḳosom ḳoraisoin, tumi gia oula-u ḳoro.” ");
INSERT INTO syll_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Teu Iusufe tan bafre dafonor lagi roana dila; ar Feraunor hoḳol gulame, tan dorbaror murobbi oḳole ar Mishoror moy-murobbi oḳole, ");
INSERT INTO syll_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Iusufor nizor foribar, tan baiain ar tan bafor foribaror hoḳole roana dila. Gushono ḳali tarar huruttain ar goru-meṛar falain toia gela. ");
INSERT INTO syll_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Tara bout guṛar gaṛi ar guṛ-soar oḳol loia eḳ biraṭ dol hazia roana dila. ");
INSERT INTO syll_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ar Zordan gangor hofaro Aṭador dan maṛar zagat gia, tara hoḳole shatdin dori Iusufor bafor lagi kub ahazari ar bilaf ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Aṭador dan maṛar zagat tarare ila ahazari korat dekia, hi deshor bashinda Kenani oḳole ḳoila, Mishori oḳlor lagi iṭa kub bezuita ahazari; erlagi Zordan gangor faror ou zagar nam oigelo, Abel-Mishroyim mani, Mishori oḳlor ahazari. ");
INSERT INTO syll_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Israile tan fuaintore zela osiot ḳorsla, tara tanre ola-u ḳorla. ");
INSERT INTO syll_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Tara tan lash Kenan desho loia gela, ar Momrir gese Moḳfelar zominor, guhar maze tanre dafon ḳorla. Iṭa ḳobrostan bananir lagi Ibrahime, Hiṭṭi Ifrunor ges taki loisla. ");
INSERT INTO syll_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Bafre dafon ḳorar bade Iusuf, tan baiain ar zoto manush tan bafre dafon ḳorat loge gesla, tara hoḳole Mishoro firia aila. ");
INSERT INTO syll_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Baf morigesoin dekia Iusufor baiainte mata-mati korla, Iusufe kiba amrare ginnaibo ar amra tar zeta ḳeti korsi, oḳon ita hokkoltar bodla loibo. ");
INSERT INTO syll_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Teu tara Iusufor gese ḳobria faṭaia ḳoila, “Tumar bafe morar age i osiot ḳorsla zen, ");
INSERT INTO syll_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","tumra Iusufre ou ḳotaḳan ḳoio, tumar baiainte tumar zeta ḳeti korsoin, doya ḳori tumi tarar hi oinnae ar guna maf ḳori dio. Erlagi amra minot ḳoriar, tumar bafor Allar ou gulam oḳolre maf ḳori dilao.” Tarar mat hunia Iusufor ḳandon aillo. ");
INSERT INTO syll_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Bade tan baiainte tan samne aia maṭit foṛia ḳoila, “Huno, amra to tumar gulam.” ");
INSERT INTO syll_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Oile Iusufe tarare ḳoila, “Tumra ḍoraio na. Ami kunu Allar ḳolifa ni? ");
INSERT INTO syll_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Tumra to amar ḳeti kortae saislae, oile Allae itare balai banailla, zela aiz deḳrae, te tan kial asil ou laḳan ḳori bout manshor zan basaita. ");
INSERT INTO syll_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Tumra oḳon ḍoraio na. Ami tumrare ar tumrar fua-fuṛintore deḳa-huna ḳormu.” Tain ou laḳan ḳori tarare buz dila ar kush dile mat-ḳota matila. ");
INSERT INTO syll_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Bade Iusuf ar tan bafor aolad oḳole Mishoro boshot ḳorat roila. Iusuf eḳ-sho dosh boros zinda asla. ");
INSERT INTO syll_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Tain Afraimor natinosha forzonto deḳla ar Manoshar fua Makiror huruttain-o Iusufor ato foyda oila. ");
INSERT INTO syll_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Bade Iusufe tan baiaintore ḳoila, “Amar to moutor oḳt aichche, nisoy Allae tumrar bae nozor raḳba. Tain Ibrahim, Isʼhak ar Iakubor gese ze desh dita ḳori kosom ḳorsoin, tumrare on taki hou desho loia zaiba.” ");
INSERT INTO syll_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ar Iusufe Boni Israilre ou osiot ḳoraila, “Nisoy Allae kunudin tumrar bae nozor ḳorba. Te on taki zaoar bala tumra amar aḍḍi oḳol tulia loia zaio.” ");
INSERT INTO syll_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Heshe eḳ-sho dosh boros boyosho Iusuf mara gela. Teu manshe tan lashre kushbu-mosholadi makia momi banaia Mishor desho ek kafonor baksor bitre toila.");
INSERT INTO syll_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Allae Hozrot Iakubor noya nam disla Israil, erlagi tan bongshor nam oilo Boni Israil. Iakube tan bibin-baichchain ar foribaror hoḳolre loia Mishor desho gelagi. Ou shomoy tan loge oia zera gela, erar nam oilo, ");
INSERT INTO syll_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Shimion, Lebi, Ehuda, ");
INSERT INTO syll_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isaḳor, Sobulon, Bin-Iamin, ");
INSERT INTO syll_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Noftali, Sadu ar Ashir. ");
INSERT INTO syll_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Iakubor bongshor hokkoltae milia shottoir zon asla. Ar Iusuf ag taki-u Mishoro taḳta. ");
INSERT INTO syll_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Bade Iusuf, tan baiain, ar hi amolor hoḳol mara gela. ");
INSERT INTO syll_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Oile tarar bador bongshodor baṛia kub bolala oila. Era sairobae sitria asta Mishor desh borigela. ");
INSERT INTO syll_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Ermaze Mishoro eḳzon noya bashsha oila, ein Iusufre sinoin na. ");
INSERT INTO syll_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ein nizor proza oḳolre ḳoila, “Saia deḳo, Boni Israil amra taki beshi-o ar bolala-o. ");
INSERT INTO syll_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Te ao, amra eḳ fondi kori, ita zenu ar na baṛoin. Arnae tara baṛia heshe zuddor ḳalo amrar dushmonor loge milia amrar birudde zuddo ḳorbo, bade amrar desh taki zaibogi.” ");
INSERT INTO syll_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Teu tara shordar lagaila erare maria-doria zur-zulum ḳoria ḳam ḳoranir lagi. Era Feraunor foshol raḳar lagi Pitum ar Ramashesh namor duiṭa ṭaun-o banaila. ");
INSERT INTO syll_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Oile erar ufre zoto beshi zur-zulum ḳora oilo, era-o oto beshi baṛila ar sitrila. Erlagi Mishori oḳole Boni Israilre kub ḍoraigela. ");
INSERT INTO syll_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Ḍoraia eraredi aro ḳoṭin ḳam ḳoraila. ");
INSERT INTO syll_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Maṭi kam, iṭor ḳam ar ḳetor maze ḳoshṭor ḳam ḳoraia erar zanre titta banaililo. Ar tara zur-zulum ḳoria nisṭur-fashanor laḳan ḳam ḳoraito. ");
INSERT INTO syll_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Bade Mishoror bashshae Shifra ar Fuah namor duizon Ibrani dai beṭire hukum dila, ");
INSERT INTO syll_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Tumra Ibrani beṭintor dai girit gia, itar fuain foyda oile-u marilaio, ḳali fuṛintore zita rakio.” ");
INSERT INTO syll_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Oile hi dai beṭinte Allare ḍoraita gotike, Mishori bashshar hukum na mania fuaintore-o zita raḳta. ");
INSERT INTO syll_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Teu bashshae erare nia zikaila, “Ita ḳam ḳene ḳorlae? Fuaintore ḳene zita raḳlae?” ");
INSERT INTO syll_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Tara zuaf dila, “Ibrani beṭin Mishori beṭintor laḳan nae, tara bout bolala. Daibeṭi tarar ḳasat zaibar age-u tarar hurutta foyda oizae.” ");
INSERT INTO syll_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Ou duio beṭie Allare ḍoraita ḳori, Allae rohomot ḳoria tarare-o aolad dila. Ar Boni Israil-o aro beshi kori baṛia kub shoktiman oila. ");
INSERT INTO syll_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ita dekia Feraune nizor proza oḳolre hukum dila, “Ibrani oḳlor kunu fuain oile-u tumra Nil nodo falai dio, ḳali fuṛintore zita rakio.” ");
INSERT INTO syll_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ermaze Lebi kandanor eḳzon manshe, tan nizor ḳandanor ek koinare shadi korla. ");
INSERT INTO syll_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ou ḳoinar goro eḳ fuar zonom oilo. Fuagu deḳte kub shundor oae, tin mash dori lukai raḳla. ");
INSERT INTO syll_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Heshe ar lukaita na faria, tain nol-ḳagṛar eḳ ṭukri loila. Ou ṭukrit maṭia tel ar alḳatra lefia ogur bitre huruttare haraia, gangor soror nol bonor maze toia aila. ");
INSERT INTO syll_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ar er kita dosha oy deḳar lagi, tar boin duroi ubailo. ");
INSERT INTO syll_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Tuṛa bade Feraunor fuṛi gango naoat aila. Gangor faro tan bandi oḳol guragurit asil. Tain soror nol-ḳagṛar maze ou ṭukri dekia, tan bandire ḳoila, “Ou ṭukrigu an.” ");
INSERT INTO syll_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ṭukrir ḍala kulia deḳla, er bitre eḳ fuae ḳander. Dekia tan maya lagigelo. Tain ḳoila, “Ish, igu to kunu Ibranir fua.” ");
INSERT INTO syll_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Ou shomoy fuar boin aia Feraunor fuṛire zikailo, “Rani ma, i huruttare dud ḳaoanir lagi kunu Ibrani beṭire faile afnar gese antam ni?” ");
INSERT INTO syll_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Feraunor fuṛie ḳoila, “Za angi.” Teu fuṛie gia fuar maʼre loia ailo. ");
INSERT INTO syll_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Feraunor fuṛie tanre ḳoila, “Ogo, ami tumar beton dimune, tumi amar oia ou fuagure bukur dud ḳaoao.” Ou hi beṭie nia huruttare dud ḳaoaia falila. ");
INSERT INTO syll_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Fuagu kisu boṛo oar bade tain nia Feraunor fuṛir gese dilaila. Feraunor fuṛie enre nizor fua banaia falila. Tain ḳoila, “Ami tare fani taki ṭania tulchi.” Erlagi tar nam raḳla Musa mani, ṭania tula. ");
INSERT INTO syll_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Heshe Musa boṛo oigele eḳdin tan nizor zatir baiaintor gese gia deḳla, tara kub ḳoshṭor ḳam ḳorra. Ermaze deḳla, tan nizor Ibrani zatir eḳ beṭare, eḳ Mishorie mair-doir ḳorer. ");
INSERT INTO syll_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Dekia sairobae saia ar kunu manush na deḳae, tain hou Mishorire kun ḳoria balur tole gaṛilla. ");
INSERT INTO syll_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Bador dino tain hirbar bare gela. Gia deḳla, duizon Ibranie nize nize maramari korer. Ou tain dushi zonre ḳoila, “Oba, tumar baire ḳene marrae?” ");
INSERT INTO syll_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","He ḳoilo, “Tumare ḳegie amrar hakim banaia bisar ḳorat faṭailo? Ḳail zela hou Mishorire kun ḳorso, oula amare-o kun ḳoriltae sairae ni?” Ou Musae ḍoraigela. Tain buzla ita to zana-zani oigese. ");
INSERT INTO syll_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Ar Feraune-o ita hunia Musare marilta saila. Ou shomoy Musa Feraunor ges taki bagi gela. Bagia Madian desho boshot ḳorar lagi aila. Aia honor ek kuar ḳasat boila. ");
INSERT INTO syll_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Madian desho Shuaib namor eḳ imam sab asla. Tan shatzon fuṛin asoin. Ou fuṛinte kuar faro aia, tarar bafor sagol-meṛare fani kaoanir lagi gamla borat lagla. ");
INSERT INTO syll_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ou shomoy oinno raḳal oḳole tarare ḳedaia dilailo. Oile Musa ubaia tarare shaijjo ḳorla, ar tarar falre fani kaoaila. ");
INSERT INTO syll_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Tara tarar bafor daro gia harle tain zikaila, “Tumra aiz oto zoldi kemne ailae?” ");
INSERT INTO syll_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Tara ḳoila, “Eḳ Mishori beṭae amrare raḳal oḳlor at taki basaisoin. Ein amrar sagol-meṛare fani tulia ḳaoaisoin.” ");
INSERT INTO syll_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Teu tain zikaila, “I manushgu kuai? Tumra tare toia aillae ḳene? Ere ḍakia ania ḳana ḳaoao.” ");
INSERT INTO syll_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Erbade Musae ou imamor baṛit roite razi oila. Imam sabe tan fuṛi Sofurare Musar loge shadi dila. ");
INSERT INTO syll_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Bade Sofurar goro eḳ fua oile Musae ḳoila, “Ami to boitol bonia bidesho roiram.” Erlagi ou fuar nam raḳla Zarsum mani, boitol. ");
INSERT INTO syll_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Bout din bade Mishoror bashsha morigela. Boni Israile gulamir lagi kator oia ḳanda-ḳaṭi korlo. Tarar ḳandon Allar gese kobul oigelo. ");
INSERT INTO syll_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Allae tarar foriad hunla. Tain Ibrahim, Isʼhak ar Iakubor loge tan oadar ḳota iad ḳorla. ");
INSERT INTO syll_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Ar Boni Israilor bae muk firaila, doyar nozore tarar bae saila. ");
INSERT INTO syll_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Ou shomoy Musae tan hour Madian zatir imam sab Hozrot Shuaibor sagol-meṛa raḳta. Eḳdin tan sagolor fal loia morubumir hesh galat Allar hou Tur faṛor ḳasat gela. ");
INSERT INTO syll_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Hono eḳ zonglar maze Mabudor firistae agunir laḳan nuror maz taki tanre deḳa dila. Musae deḳla, zonglar maze aguin zoler oile zongla zoler na. ");
INSERT INTO syll_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ou tain taijjub oia ḳoila, “Zongla ze zoler na, er ḳaron kita? Te aro ḳasat gia deki sain.” ");
INSERT INTO syll_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Allae zebla deḳla ein deḳar lagi kasat zairagi, ou shomoy tain zonglar maz taki ḍakia ḳoila, “Musa, O Musa!” Musae ḳoila, “Ounu ami.” ");
INSERT INTO syll_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Allae ḳoila, “Ar samne aguaio na. Tumar fao taki zuta kulilao. Zano ni, tumi oḳon ze zagat ubaiso ikan pak zaga. ");
INSERT INTO syll_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Huno, ami Alla-u tumar bafor Mabud, Ibrahimor Mabud, Isʼhakor Mabud ar Iakubor-o Mabud.” Ikan hunia-u Musae tan muk lukailla. Allar bae saite tan dilo ḍor hamaigelo. ");
INSERT INTO syll_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Mabude ḳoila, “Ami Mishor desho amar bonda oḳlor duḳ-mosibot dekiar. Mishori shordar oḳlor zulumor lagi tarar ḳandon huniar. Tarar duk-koshṭo hoḳolta ami deḳsi. ");
INSERT INTO syll_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Dekia Mishori oḳlor at taki tarare basaitam ḳori ami nize lamia aisi. Te ami tarare Mishor taki horaia nimugi. Nia roshail zomir bout boṛo shundor eḳ desh dimu. Ikan dud ar mour banḍar-ala desh. Ou desh oilo oḳonkur Kenani, Hiṭṭi, Amuri, Farizi, Hibbi ar Zibuzi oḳlor desh. ");
INSERT INTO syll_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Boni Israilor foriad amar dorbaro aise, Mishori oḳole tarare zela sataira, ita ami dekiar. ");
INSERT INTO syll_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Erlagi ami tumare Feraunor gese faṭaiar. Tumi zao, gia amar bonda Boni Israilre Mishor taki bar ḳoria ano.” ");
INSERT INTO syll_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Musae zuaf dila, “Ami aroḳzon ḳe, zein Feraunor samne gia Mishor desh taki tarare horaitam farmu?” ");
INSERT INTO syll_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Allae ḳoila, “Ami to tumar loge loge roimu. Tumi Mishor taki manshore horaia ania, tarare loia ou faṛo amar ebadot ḳorbae. Teu buzbae ami-u tumare faṭaisi.” ");
INSERT INTO syll_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Musae aroz ḳorla, “Deḳoukka, ami zebla Boni Israilre gia ḳoimu, tumrar baf-dadar Mabude amare faṭaisoin, ou shomoy tara zudi zikain tan nam kita, te tarare kita zuaf ditam?” ");
INSERT INTO syll_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Allae ḳoila, “Ami zein asi, asi-u. Boni Israilre oula ḳoio, zen nam ‘Ami asi’ tain amare tumrar gese faṭaisoin.” ");
INSERT INTO syll_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Tain aro ḳoila, “Tumi gia tarare ḳoio, ‘Hou Alla zein hor-hamesha asoin, ein tumrar baf-dadar Mabud, Ibrahimor Mabud, Isʼhakor Mabud ar Iakubor-o Mabud, ein-u amare tumrar gese faṭaisoin.’ “Amar hor-hameshakur nam ‘Ami zein asi’. Zuge zuge, furushe furushe ou nam ḳaim roibo. ");
INSERT INTO syll_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Tumi zao, gia Boni Israilor murobbi oḳolre ekḳano dola ḳoria ḳo, hou Alla, zein tumrar baf-dadar Mabud, Ibrahim, Isʼhak ar Iakubor Mabud, tain amare didar dia ḳoisoin, tain tumrar bae kial ḳorsoin, tumrar ufror zulum-mosibot deḳsoin, Mishor desho tumrar bae zeta ḳora or eota tain kial ḳorsoin. ");
INSERT INTO syll_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Oḳon tain ḳoira, Mishoror gulami taki tumrare basaia Kenani, Hiṭṭi, Amuri, Farizi, Hibbi ar Zibuzi oḳlor dud ar mour banḍar-ala desho tain tumrare nibagi.” ");
INSERT INTO syll_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Allae aro ḳoila, “Boni Israilor murobbi oḳole tumar ḳota hunba, tumi tarare loge loia Mishoror bashshar gese zaio. Gia ḳoio, ‘Alla zein Ibrani oḳlor Mabud, tain amare doroshon disoin. Erlagi amra tan name ekkan kurbani kortam saiar, amra morubumir bae tin dinor fot gia kurbani dimu, te amrare zaoar onumoti deukka.’ ");
INSERT INTO syll_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Oile ami zani Mishoror bashshae tumrare zaite dito nae, zur-zobordosti korle-o dito nae. ");
INSERT INTO syll_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Teu ami amar kudroti at lagaimu ar oula asanok gozob nazil ḳormu, zate he tumrare zaite dey. ");
INSERT INTO syll_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Ar ami Mishori oḳlor dilor maze Boni Israilor bae emon eḳ doyar bab foyda ḳoraimu, era zanu Mishor taki kali ate na zain. ");
INSERT INTO syll_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Hoḳol Israili beṭinte tarar ari-fori ba zerar baṛit tara roin, oula Mishori beṭintor ges taki tarar shuna-rufar goyna-gaṭi ar bala ḳafoṛ-sufoṛ kuzia nio. Ota dia tumrar fua-fuṛinre-o hazaio, ou nomunae tumra Mishorintor don-samana doḳol ḳorbae.” ");
INSERT INTO syll_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Musae zuaf dila, “O Mabud, tara zudi amare ekin na ḳoroin, amar mat na hunoin ba tara zudi koin, Mabude tumare doroshon disoin na, te ami kita ḳortam?” ");
INSERT INTO syll_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Teu Allae tane zikaila, “Tumar ato igu kita?” Tain ḳoila, “Egu laṭi.” ");
INSERT INTO syll_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Allae ḳoila, “Oḳṭa maṭit falao.” Musae laṭire maṭit falaite-u iṭa haf oigelo. Haf dekia-u tain faldi hori gela. ");
INSERT INTO syll_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Allae tane hukum ḳorla, “At baṛaia ogur lenjo doro.” Ar tain dorar loge loge ogu hirbar laṭi oigelo. ");
INSERT INTO syll_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Bade Allae ḳoila, “Tumi-o oula ḳorio, teu tara hasau ekin ḳorba tarar baf-dadaintor Mabud, Ibrahimor Mabud, Isʼhakor Mabud ar Iakubor Mabude tumare doroshon disoin.” ");
INSERT INTO syll_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Allae aro ḳoila, “Tumar at tumar saddoror tole harao.” Tain at haraila, ar bar ḳorar bade-u tan at kusṭo-dolbeda bemare dudor laḳan dola oigelo. ");
INSERT INTO syll_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Allae ḳoila, “Tumar at hirbar hono harao.” Tain haraila ar saddoror tol taki bar ḳoria deḳoin, agor laḳan bala oigese. ");
INSERT INTO syll_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Allae ḳoila, “Tara zudi tumare ekin na ḳoroin, te tumar laṭire haf oa deḳle ekin ḳorba, ar eoṭae ekin na ḳorle tumar ator bemaror keramoti deḳle tara ekin ḳorba. ");
INSERT INTO syll_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ar zudi i duio keramotie-o ekin na ḳoroin, tumar ḳota na manoin, te tumi Nil nod taki tuṛa fani ania hukna maṭit falaio, deḳbae maṭit foṛia-u i fani lou oizibo.” ");
INSERT INTO syll_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ou Musae Mabudre ḳoila, “O malik, ami to bala ḳori mat-ḳota-u mattam fari na, age-o fartam na ar afne i gulamor loge batchit ḳorar bade-o fari na, amar to zifra baṛua.” ");
INSERT INTO syll_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Allae ḳoila, “Manshor muk ke banaise, ami nae ni? Ḳe manshore buba, ḳalua ba anda banain? Souke deḳar lagi sokur faoar ḳe dein? Ita to ami Allae-u dei na ni? ");
INSERT INTO syll_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Te tumi zao, gia kita matitae ami hikaia dimu. Tumar mukor zobanre ami shaijjo ḳormu.” ");
INSERT INTO syll_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Tain ḳoila, “O malik, ami minot ḳoriar, oinno ḳeurore faṭai deukka.” ");
INSERT INTO syll_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ou Musar ufre Mabudor gusa uṭlo. Tain ḳoila, “Tumar bai Harun bin Lebi ase na ni? Ami zani, he bala boktita dito fare. He oḳon tumar loge deḳa ḳorat ar, tumare dekia he kub kushi oibo. ");
INSERT INTO syll_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Tumi hikaia dio ar ḳoio he kita matito. Ami tumra duiozonor mukor zobanre shaijjo ḳormu. Ar hono gia kita ḳortae ami hikaia dimu. ");
INSERT INTO syll_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Tumar bai Harunor muk oibo tumar muk, he tumar oia manshor loge matibo. Fegambor oḳole zela Allar kalam ḳoin, Harune oula tumar buli koibo. ");
INSERT INTO syll_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ou laṭi tumar ato rakio, iṭa dia hou keramoti-muzeza oḳol zair ḳorbae.” ");
INSERT INTO syll_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","19","Madian desho taḳte-u Mabude Musare hukum ḳorsla, “Tumi Mishoro zaogi, ḳaron Mishoror zeta manshe tumare kun ḳorta saisla, ita oḳon mori gesoin.” Teu Musae tan hour Shuaibor ḳasat gia ḳoila, “Ami amar zonom maṭi Mishor desho zaitam sairam, amar ḳesh-kuṭum oḳol zita asoin ki na, tarar hal-hokikot deḳat zaitam, te amare zaoar onumoti deukka.” Houre ḳoila, “Aichcha, sohi-salamote zao.” ");
INSERT INTO syll_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ou Musae tan bibi ar fuaintore gadar ufre soṛaia Mishoror fote roana oila. Tan ato Allai keramotir hou laṭi raḳla. ");
INSERT INTO syll_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Allae Musare hukum dila, “Tumi Mishoro gia harle amar deoa keramoti oḳol Feraunor samne deḳaio, oile ami tar dilre fashan banailimu, he manshore saṛto nae. ");
INSERT INTO syll_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Tumi Feraunre ḳoio, Mabude nize ḳoisoin, ‘Boni Israil to amar foyla futor laḳan. ");
INSERT INTO syll_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ami nize tumare hukum ḳorslam, amar ebadoto zaita ḳori tumi amar futre saṛi ditae, oile tumi mancho na. Erdae ami-o tumar foyla futre marilimu.’ ” ");
INSERT INTO syll_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Bade Mishoro zaoar foto rait ḳaṭaibar zagat aile Mabude Musare marilita ḳori mukamuki oila. ");
INSERT INTO syll_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Oile tan bibi Sofurae ekkan darail fattor loia tan fuar mosolmani korailla ar oḳṭa tan zamai Musar faor maze soaia ḳoila, “Lour bodla ami tumare zamai hishabe faisi.” ");
INSERT INTO syll_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Teu Musare Mabude saṛidila. Mosolmani kamor befare Sofurae to ou ḳota-u ḳoisla. ");
INSERT INTO syll_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Ermaze Mabude Harunre ḳoila, “Tumi morubumit gia Musar loge deḳa ḳoro.” Ou tain gela ar Allar faṛ Turor gese aia Musare faia suma dila. ");
INSERT INTO syll_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ar Mabude zeta zeta ḳoibar lagi Musare hukum disla, Musae ita hokkolta Harunre zanaila. Mabude zoto laḳan keramoti-muzeza deḳanir hukum disoin, ita hoḳolta-u tain Harunre buzaila. ");
INSERT INTO syll_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Bade Musa ar Harun Mishor desho gia Boni Israilor hoḳol murobbire dola ḳorla. ");
INSERT INTO syll_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Mabude Musare zotota ḳoisla, Harune ita hoḳolta tarare zanaila, ar hou keramoti oḳol-o manshor samne deḳaila. ");
INSERT INTO syll_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Erlagi manshe ita ekin ḳorla. Tara zebla hunla, Mabude tarar bae kial ḳorsoin, tarar ufror zulum-mosibot deḳsoin, ou tara tanre soizda ḳorla. ");
INSERT INTO syll_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Musa ar Harune gia Feraunre ḳoila, “Mabud, zein Boni Israilor Alla, tain nize ḳoisoin, amar bonda oḳolre tumi saṛi deo, amar name hoj ḳorar lagi, tara morubumit hizrot ḳorte oibo, tumi tarare saṛo.” ");
INSERT INTO syll_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Feraune zuaf dilo, “I Mabud aroḳzon ḳe, zen hukum mania ami Boni Israilre saṛi ditam? Ila kunu Mabudre ami sini na, ar Boni Israilre-o ami saṛtam nae.” ");
INSERT INTO syll_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Tara ḳoila, “Ibrani oḳlor Allae amrare doroshon disoin. Erlagi amra minot ḳoriar amrare morubumir bae tin dinor fot gia, amrar Mabud Allar name kurbani korte deukka, arnae tain amrare gozobi bemar dia ba zuddor maze falaia marilaiba.” ");
INSERT INTO syll_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Mishoror bashshae zuaf dila, “O Musa ar Harun, tumra manshore ḳene ḳamo taki firairae? Zao, tumra-o gia ḳamo lago. ");
INSERT INTO syll_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Deḳrae ni, desho tumrar manush bout baṛigesoin, ar tumrar lai faia itae kunu ḳam ḳorra na.” ");
INSERT INTO syll_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ou Feraune hou din-u Mishori zalim shordar ar Ibrani subedar oḳolre hukum ḳorla, ");
INSERT INTO syll_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Iṭ banaibar lagi tumra manshore agor laḳan ḳer-nera ania dio na, tara gia ita zugaṛ ḳorouk. ");
INSERT INTO syll_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Oile age tara zotoḳan iṭ banaito oḳono otoḳan banaite oibo, ekkan-o ḳom oito nae. Ita alshia oigesoin ḳori, ono aia tarar Allar namor kurbani korta ḳoia sillaira. ");
INSERT INTO syll_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Tumra tarare aro ḳoshṭor ḳamo lagao, teu itae kunu laḳan baze mat na hunia ḳamor maze mon diba.” ");
INSERT INTO syll_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ou hi shordar ar subedar oḳol baroi gia manshore ḳoila, “Feraune ḳoisoin, oḳon taki tain ar iṭ bananir ḳer zugai dita nae. ");
INSERT INTO syll_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Tumra zen taki faro ḳer-nera zugaio, oile tumrar ḳam kunta-u ḳomail oito nae.” ");
INSERT INTO syll_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Ou manshe ḳer-nera tukaibar lagi hara Mishor desho sitri gela. ");
INSERT INTO syll_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Ar shordar oḳole bare bare tagda dia ḳoilo, “Age ḳer zugaia deoar bala tumra forteḳ din zotoḳan iṭ banaitae, oḳono otoḳan banao.” ");
INSERT INTO syll_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Feraunor zalim shordar oḳole Boni Israilor ufre ze subedar lagaisil, hou shordar oḳol aia subedar oḳolre mair-doir ḳoria zikailo, “Tumra age zotoḳan iṭ ditae, oḳon otoḳan deo na ḳene?” ");
INSERT INTO syll_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ou Boni Israilor subedar oḳole aia Feraunor gese nalish dila, “Afnar i gulam oḳlor loge ila bebohar ḳene ḳorra? ");
INSERT INTO syll_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Shordar oḳole amrare ḳer-nera zugai dein na, ta-o iṭ banaibar hukum dein ar afnar i gulam oḳolre mair-doir ḳoroin, oile dush to afnar nizor shordaror.” ");
INSERT INTO syll_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Feraune zuaf dilo, “Tumra alshia, kuṛia, erlagi koirae Mabudor name kurbani korat zaitam. ");
INSERT INTO syll_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Zao, ḳam ḳoro gia. Tumrare ḳer deoa zaito nae, ta-o forteḳ din zotoḳan iṭ banaibar ḳota asil, otoḳan-u banaite oibo.” ");
INSERT INTO syll_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Ou Boni Israilor subedar oḳole buzla, tara bifodor maze foṛsoin, ḳaron tarare hukum ḳora oise, age zotoḳan iṭ banani lagto, oḳono otoḳan iṭ banaite oibo, ḳom oito nae. ");
INSERT INTO syll_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Tara Feraunor ges taki zaoar foto Musa ar Harunor loge deḳa oilo, era ubaia bar saoat asla. ");
INSERT INTO syll_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Subedar oḳole ḳoila, “Mabude afnarar faona shaza diba, afnara Feraun ar tar uzir-naziror gese amrare fosa-ganda banaia, amrare kun ḳorar lagi toluar nia tarar ato disoin.” ");
INSERT INTO syll_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Ou Musae hirbar gia Mabudor gese foriad ḳorla, “O din duniar malik, tumi kene tumar bondare mosiboto falailae? Ar amare kitallagi faṭailae? ");
INSERT INTO syll_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Feraunor gese tumar ḳota hunanir bad taki-u tumar bonda oḳlor ufre zulum to aro baṛise. Oile tumi to kunta-u ḳorlae na.” ");
INSERT INTO syll_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Mabude Musare ḳoila, “Feraunor kita dosha oy tumi dekio, amar ator zur deḳle-u he manshore saṛi dibo. Zurala ator kudrot deḳle-u he tar desh taki erare ḳedai dibo.” ");
INSERT INTO syll_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Allae Musar loge batchit ḳori koila, “Amar nam-u ‘Alla zein asoin’. ");
INSERT INTO syll_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ami Ibrahim, Isʼhak ar Iakubor gese Shorbo-shoktiman Alla name didar ditam, ‘Alla zein asoin’ name tarare didar ditam na. ");
INSERT INTO syll_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ami tarar loge ou oada ḳorslam, ami tumrare Kenan desh dimu, ze desho tumra musafir oia ro, ou desh-u ami tumrare dimu. ");
INSERT INTO syll_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ḳas ḳori Mishori oḳole Boni Israilre gulami koranir lagi erar ḳandon hunia, amar hou oada oḳon iad ḳorlam. ");
INSERT INTO syll_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Erlagi tumi gia Boni Israilre ḳo, Mabude ḳoisoin, ami Mabud, ami tumrare Mishori oḳlor tol taki bar ḳoria anmu, tarar gulami taki azad ḳormu. Tarare deḳar moto shaza dia, amar kudroti atdi tumrare ḳalas ḳormu. ");
INSERT INTO syll_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Heshe tumrare amar nizor bonda banaimu, ami nize tumrar Alla oimu. Teu tumra buzbae, ami Alla-u tumrar Mabud, ar Mishori oḳlor baror tol taki ami-u tumrare basaisi. ");
INSERT INTO syll_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ami Ibrahim, Isʼhak, Iakubor loge ze deshor ḳota oada ḳorsi, hou desho tumrare loia zaimu, tumra hou deshor malik oibae. Ami-u Mabud.” ");
INSERT INTO syll_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musae gia ita hoḳolta tarare zanaila, oile hi betaya zulum-toklif ar gulami korte ḳorte mon-mora oizaoae, tara ar Musar mate ḳan dila na. ");
INSERT INTO syll_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ou Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Tumi gia Mishoror bashsha Feraunre ḳo, he zanu tar desh taki erare zaite dey.” ");
INSERT INTO syll_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Musae zuaf dila, “Boni Israile-u zebla amar mat huner na, te Feraune kila hunbo? Ar amar to matte muko lagizae.” ");
INSERT INTO syll_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Teu Mabude Musa ar Harunre ḳoila, “Tumra Boni Israil ar Mishoror raza Feraunre ḳo, Mabude amrare hukum disoin, Boni Israilre Mishor taki bar ḳori neoar lagi.” ");
INSERT INTO syll_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Boni Israil zatir mul murobbi oila Hozrot Iakub, Allae ou Iakubor noya nam disla Israil. Tan fuain oila Ruben, Shimion, Lebi shoho muṭ barozon. Musa ar Harun oila ou Hozrot Lebir bongshodor. Israilor boṛo fua Rubenor fuain oila Honuk, Falu, Hasir ar Kormi, era to Ruben ḳandanor nanan gusṭir mul murobbi. ");
INSERT INTO syll_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Shimionor fuain oila Zimuel, Zamin, Ohod, Zakin, Shuhor ar tar Kenani bour torofa fua Shoul, era Shimion ḳandanor nanan gusṭir mul murobbi. ");
INSERT INTO syll_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Ḳandan talika hishabe Hozrot Lebir fuain oila Zarsun, Kahat ar Marari. Lebi eḳ-sho shaṛtish boros basisla. ");
INSERT INTO syll_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Zarzir gusṭir fordan hishabe Zarsunor fuain oila Libni ar Shimei. ");
INSERT INTO syll_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kahator fuain oila Imran, Izhar, Hebron ar Ujjol. Kahat eḳ-sho tetrish boros basisla. ");
INSERT INTO syll_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Mararir fuain oila, Moholi ar Mushi. Era-u oila Lebi kandanor nanan gusṭir mul murobbi. ");
INSERT INTO syll_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Imranor fuain oila Musa ar Harun. Imrane tan fufu Iukabezre bia ḳorsla, tan feṭo erar zonom oisil. Imran eḳ-sho shaṛtish boros basisla. ");
INSERT INTO syll_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Izharor fuain oila Kurah, Nefog, Zikri. ");
INSERT INTO syll_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ujjolor fuain Mishayel, Elzafon ar Zitri. ");
INSERT INTO syll_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Ar Harune Aminadabor fuṛi Nahishor boin Ilishebare bia ḳorae, tan hurutta oila Nadab, Abihu, Ali-Azor ar Isamar. ");
INSERT INTO syll_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kurahor fuain oila Oshir, Ilkana, Obiashof. Era Kurahi oḳlor nanan gusṭir mul murobbi. ");
INSERT INTO syll_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Ali-Azoror fua oila Finohosh. Harunor fua Ali-Azore Fuṭielor fuṛire bia ḳorae tair feṭo Finohoshor zonom oisil. Era oila Lebi kandanor nanan gusṭir mul murobbi. ");
INSERT INTO syll_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ou Harun ar Musare Mabude hukum ḳorsla, tumra Boni Israilre sifai dolor laḳan hazia Mishor taki bar ḳoro. ");
INSERT INTO syll_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Musa ar Harune-u Boni Israilre Mishor taki bar ḳori anar ḳota Mishoror bashsha Feraunor loge matisla. ");
INSERT INTO syll_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Mabude Musar loge zedin Mishor desho batchit ḳorla, ");
INSERT INTO syll_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","hou din tain ḳoila, “Ami Mabud. Te tumare oḳon zeta zeta ḳoimu, ita hoḳolta tumi Mishoror bashsha Feraunre ḳoio.” ");
INSERT INTO syll_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Musae Mabudor dorbaro aroz ḳorla, “Deḳoukka, amar to matte muko lagizae, Feraune kunu amar mat hunbo ni?” ");
INSERT INTO syll_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ou Mabude Musare ḳoila “Huno, ami Feraunor gese tumare Allar laḳan banaimu. Ar tumar bai Harunre banaimu tumar nobi. ");
INSERT INTO syll_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ami tumare zela hukum ḳormu, tumi oula Harunre ḳoibae, ar Harune ota Feraunre ḳoibo; zate he Boni Israilre tar desh taki saṛi dey. ");
INSERT INTO syll_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Oile ami Feraunor dilre fashan ḳorilimu. Mishor desho ami bout keramoti ar kudroti lila-ḳela deḳaimu. ");
INSERT INTO syll_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Tar bade-o Feraune tumrar mator dam dito nae. Teu ami Mishoror ufre amar at lagaia, deḳar moto shaza dia Mishor desh taki amar nizor bonda Boni Israilre sifair laḳan dole dole bar ḳormu. ");
INSERT INTO syll_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Mishoror maze amar nizor at lagaimu, Mishori oḳlor maz taki Boni Israilre bar ḳoria anmu, oudin tara buzba ami-u Mabud.” ");
INSERT INTO syll_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Bade Musa ar Harune oula ḳorla, Mabudor hukum mafik kam ḳorla. ");
INSERT INTO syll_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Feraunor loge mat-ḳotar shomoy Musar boyosh asil ashi, ar Harunor tirashi boros. ");
INSERT INTO syll_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Ou shomoy Mabude Musa ar Harunre ḳoila, ");
INSERT INTO syll_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Feraune zebla ḳoibo, tumrar nizor kunu keramoti kam deḳao, teu tumi Harunre ḳoio, tar laṭi nia Feraunor samne falaito, falanir loge loge-u iṭa haf oizibo.” ");
INSERT INTO syll_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Bade Musa ar Harun Feraunor gese gela, gia Mabudor hukum mafik kam ḳorla. Harune Feraun ar tar uzir-naziror samne hou laṭi falanir loge loge-u iṭa haf oigelo. ");
INSERT INTO syll_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ou Feraune-o tar gunin ar zadugir oḳolre anailo, tara-o tarar zadu-montro dia oula deḳaila. ");
INSERT INTO syll_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Tara hoḳole-u zarzir laṭi saṛlo, ar eota haf oigelo, oile Harunor laṭie tarar hokkol laṭire gilililo. ");
INSERT INTO syll_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ita dekia-o Feraunor dil fashan roilo, he erar mate ḳan dilo na, zela Mabude age ḳoisla. ");
INSERT INTO syll_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Bade Mabude Musare ḳoila, “Feraunor dil to fashan, he manshore saṛte razi nae. ");
INSERT INTO syll_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Te tumi biani bala Feraunor gese zaio, gele deḳbae he fanir gese zaibo, tumi tar loge deḳa ḳorar lagi Nil nodor faro ubaio. Tumar ze laṭi haf oisil, ou laṭi ato ḳori nio. ");
INSERT INTO syll_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Nia tare ḳoio, ‘Mabud, zein Ibrani oḳlor Alla, tain nize amare faṭaisoin afnare oḳan ḳoitam, tumi amar bonda oḳolre saṛi deo, tara amar bondegi korar lagi morubumit hizrot ḳorouk, ta-o oḳono tumi hunrae na. ");
INSERT INTO syll_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Erlagi oḳon tumi buzbae, ami-u Mabud.’ Oḳan ḳoia hari tumi koio, ‘Deḳoukka, ami nizor ator laṭi dia ou Nil nodor fanit baṛi marmu, ar hokkol fani lou oizibo. ");
INSERT INTO syll_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Hokkol mas morizibo ar fosa gondo bar oibo, teu Mishori oḳole ou Nil nodor fani kaita farta nae.’ ” ");
INSERT INTO syll_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Mabude Musare ḳoila, “Harunre ou ḳota ḳo, tumi nizor laṭi loia Mishori oḳlor hokkol fanir ufre, deshor gang-nala, ḳal-bil, aor-baor sairobae tumar at baṛao, teu itar hokkol fani lou oizibo. Fattor kudia banail ba laḳṛir fatil-ḳoloshor maze toa fani-o lou oizibo.” ");
INSERT INTO syll_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Ou Musa ar Harune Mabudor hukum mafik oula ḳorla, tain laṭi usa ḳori Feraun ar tar uzir-naziror samne Nil nodor fanit baṛi marla, teu hoḳol fani lou oigelo. ");
INSERT INTO syll_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Nil nodor hoḳol mas morigelo, hoḳol fanit fosa gondo bar oilo, Mishori oḳole fani ar ḳaita farla na, Mishor deshor hoḳol fani lou oigelo. ");
INSERT INTO syll_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Mishori zadugir oḳole-o tarar zadu-montro saṛia oula ḳorlo, ete Feraunor dil fashan roilo. He erar mato ḳan dilo na, zela Mabude age ḳoisla. ");
INSERT INTO syll_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Bade Feraune Musa ar Harunre fis dia tar razbaṛit gelogi, ita kuntat-u ḳan dilo na. ");
INSERT INTO syll_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Oile kunu Mishorie gangor fani kaite na farae, fani kaoar lagi gangor faror sairobae tara gat kudila. ");
INSERT INTO syll_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Nil nodor fanit Mabudor gozob nazil oar bade shat din guzori gelo. ");
INSERT INTO syll_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Ou shat din bade Mabude Musare ḳoila, “Tumi Feraunor gese zao, gia tare ḳo, Mabude nize ḳoira, amar kezmot ḳorar lagi amar bonda oḳolre saṛi deo. ");
INSERT INTO syll_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Tarare na saṛia kunu bada dile, ami beng dia tumar asta desho gozob ḍalmu. ");
INSERT INTO syll_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Asta Nil nod benge boriziba, ar ita aia tumar razbaṛit, hutibar goro, tumar bisnat uṭiba. Ar tumar uzir-naziror goro, tumar proza oḳlor goro, tumar undal ar fiṭa banaibar gamlat-o aia hamaiba. ");
INSERT INTO syll_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Tumar, ar tumar uzir-naziror, ar proza oḳlor gotro beng uṭiba.” ");
INSERT INTO syll_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Bade Mabude Musare ḳoila, “Harunre ḳo, tumi Nil nod ar ḳal-bilor ufre hou laṭiala at baṛaia asta Mishoro beng anao.” ");
INSERT INTO syll_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Ou Harune Mishoror hoḳol fanir ufre tan at baṛaila, teu bengainte aia Mishor desh boria jam oigela, kunu zaga ḳali roilo na. ");
INSERT INTO syll_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Oile zadugir oḳole-o tarar zadu-montro dia Mishoro oula beng anlo. ");
INSERT INTO syll_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Bade Feraune Musa ar Harunre anaia ḳoila, “Mabudor gese aroz ḳoro, tain amar ges taki ar amar proza oḳlor ges taki i beng oḳol horaia neukka, taile ami manshore saṛi dimu, zate tara gia Mabudor name kurbani korto fare.” ");
INSERT INTO syll_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Ougi Musae Feraunre ḳoila, “Afne amare ṭik kori koukka, ami kun shomoykur lagi minoti kortam, kun shomoy afnar gor, afnar uzir-nazir ar proza oḳlor gor taki beng oḳol horia zaitagi, gia ḳali gango roita?” ");
INSERT INTO syll_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Tain ḳoila “Ḳailkur lagi.” Ou Musae ḳoila, “Afnar zoban moto-u ouk, zate afne buzta faroin, amrar Mabud Allar homani ar ḳeu nai. ");
INSERT INTO syll_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Bengainte afnar ges taki, afnar gor-baṛi taki, afnar uzir-nazir ar proza oḳlor gor taki horia gia ḳali Nil nodo roiba.” ");
INSERT INTO syll_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Musa ar Harun Feraunor ges taki bare gela, gia Musae Mabudor gese foriad ḳorla, Feraunor ufor taki bengor gozob horanir lagi. ");
INSERT INTO syll_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Mabude Musar arzi kobul ḳorae, tarar baṛi-gor, uṭan ar bondor hoḳol beng morigelo. ");
INSERT INTO syll_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ar manshe itare zagae zagae dola ḳorle, fosia desho gondo bar oilo. ");
INSERT INTO syll_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Oile Feraune zebla deḳlo, gozob to horigese, ou he tar dil fashan ḳorillo. Erar mato ar ḳan dilo na, zela Mabude age ḳoisla. ");
INSERT INTO syll_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Bade Mabude Musare ḳoila, “Tumi Harunre ḳo, tumi tumar laṭi baṛaia maṭir dulit baṛi maro, teu i duil mosha oia asta Mishor desh borizibo.” ");
INSERT INTO syll_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Tara oula ḳorla, Harune tan laṭiala at baṛaia maṭir dulit baṛi marla, teu maṭir hokkol duil mosha oigelo. Ou moshae manush, zanuar ar Mishoror hokkolbae borigelo. ");
INSERT INTO syll_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ar zadugir oḳole-o tarar zadu-montro dia oula mosha banaito sailo, oile farlo na. Manush ar zanuaror maze mosha roilo. ");
INSERT INTO syll_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Teu zadugir oḳole Feraunre ḳoila, “Ita to Allar kudrot.” Ta-o Feraunor dil fashan roilo, he erar mate ḳan dilo na, zela Mabude age ḳoisla. ");
INSERT INTO syll_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Bade Mabude Musare ḳoila, “Tumi fozore uṭia Feraunor gese azir o, gele deḳbae he fanir gese aibo. Tumi tare oula ḳoio, Mabude nize ḳoira, amar kezmot ḳorar lagi tumi amar bonda oḳolre saṛi deo. ");
INSERT INTO syll_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Zudi na saṛo taile ami tumar, tumar uzir-nazir, tumar proza oḳlor ufre, ar tumar goraintor maze ḳamṛaora ḍash-masir fal faṭaimu, ita fale fale aia Mishori oḳlor goro ar tarar boshot-biṭa shoho hoḳol zagat jam oiziba. ");
INSERT INTO syll_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Oile ami amar bonda oḳlor boshot ḳana Gushon elaḳare ita taki basaimu, ino ḍash-masir fal aita nae. Teu tumi buztae farbae, ami Alla i desho asi. ");
INSERT INTO syll_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ami to amar bonda ar tumar prozar maze tofat-partokko ḳormu, ḳail i nomuna deḳbae.” ");
INSERT INTO syll_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Ar Mabude oula ḳorla, Feraun ar tar uzir-naziror goro ḳamṛaora ḍash-masir fal ailo, asta Mishor deshor hokkolbae ḍash-masir lagi shorbonash oigelo. ");
INSERT INTO syll_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Teu Feraune Musa ar Harunre ḍaḳaia ḳoila, “Tumra zao, deshor bitre tumrar Allar name kurbani korogi.” ");
INSERT INTO syll_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Musae ḳoila, “Ila ḳora ṭik nae, ḳaron amrar Mabud Allar name Mishori oḳlor ginna ḳora kurbani korte oibo. Ar deḳoukka, Mishori oḳlor samne tarar ginna ḳora kurbani korle tara to amrare fattordi iṭaia mariliba. ");
INSERT INTO syll_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Te amrar Mabud Allae zela hukum ḳorba, amra morubumir bae tin dinor fot horia gia, tan name oula kurbani kormu.” ");
INSERT INTO syll_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Feraune ḳoila, “Ami tumrare saṛi diar, tumra morubumit gia tumrar Allar kurbani koro. Oile beshi duroi zaio na, tumra amar lagi-o minot ḳorio.” ");
INSERT INTO syll_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Ou Musae ḳoila, “Deḳoukka, ami afnar ges taki horia gia Mabudor gese minoti kormu, teu ḳail afnar ges taki, afnar uzir-nazir ar afnar proza oḳlor ges taki ḍash-masir fal horiziba. Oile manshe Mabudor kurbani korat zaite afne ar kunu baotabazi koroin na zanu.” ");
INSERT INTO syll_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Bade Musae Feraunor ges taki gia Mabudor gese minoti korla. ");
INSERT INTO syll_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Ar Mabude Musar arzi mafik kam ḳorla. Feraun, tar uzir-nazir ar tar proza oḳlor ges taki hokkol ḍash-masi horigela, egu-o roilo na. ");
INSERT INTO syll_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Oile hirbar Feraune tar dil fashan ḳorillo, manshore saṛlo na. ");
INSERT INTO syll_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Bade Mabude Musare ḳoila, “Tumi Feraunor ḳasat gia tare ḳo, Mabud, zein Ibrani oḳlor Alla, tain nize ḳoira, amar ebadot ḳorar lagi amar bonda oḳolre saṛi deo. ");
INSERT INTO syll_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Tarare saṛte razi na oia oḳono bada dile, ");
INSERT INTO syll_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","hunia raḳo, bondor maze tumar foshuintor ufre, guṛaintor, gadaintor, uṭ, ar goru-sagol, meṛaintor ufre-o ami Mabude at dimu, betaya bemaror morki saṛimu. ");
INSERT INTO syll_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Oile ami Mabude Mishoror ar Boni Israilor foshur maze tofat ḳormu; Boni Israilor kunu foshu morta nae.” ");
INSERT INTO syll_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ar Mabude shomoy-o ṭik koria dilaila, samnor ḳail tain desho i kam ḳorba. ");
INSERT INTO syll_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Hasau bador din Mabude oula-u ḳorla, teu Mishoror hokkol foshu morigela, oile Boni Israilor egu foshu-o morla na. ");
INSERT INTO syll_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Feraune manushdi kobor loia deḳlo, Boni Israilor egu foshu-o morsoin na; ta-o tar dil fashan roilo, he manshore saṛlo na. ");
INSERT INTO syll_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ou Mabude Musa ar Harunre ḳoila, “Tumra duiozone muiṭ boria undalor sali ano, ania Musae ou salire Feraunor samne ufredi siṭai deo. ");
INSERT INTO syll_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Deḳbaene, ita hara Mishor deshor maze fatla duil oia hoḳol zagar manush ar foshuintor gotro gozobi bish-furi oibo.” ");
INSERT INTO syll_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Teu tara undalor sali ania Feraunor samne ubaia, Musae ufredi siṭai dila, ete manshor ar foshuintor gotro bish-furi fuṭilo. ");
INSERT INTO syll_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ar ou furir lagi zadugir oḳole Musar samne ubaita farla na, hoḳol Mishori ar zadugir oḳlor gotro-o bish-furi oilo. ");
INSERT INTO syll_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Oile Mabude Feraunor dil fashan ḳorilla. He erar mate ḳan dilo na, zela Mabude age ḳoisla. ");
INSERT INTO syll_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Bade Mabude Musare ḳoila, “Tumi biane uṭia Feraunor samne ubaia oula ḳoio, Mabud, zein Ibrani oḳlor Alla, tain nize ḳoira, amar ebadot ḳorar lagi amar bonda oḳolre saṛi deo. ");
INSERT INTO syll_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Naile ifira ami tumar, tumar uzir-nazir ar tumar proza oḳlor maze amar hokkol zator gozob saṛimu. Teu tumi buzbae, hara duniait amar homani keu nai. ");
INSERT INTO syll_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Er age-u ami amar at baṛaia betaya morki dia tumare ar tumar proza oḳolre martam farlam one, tumi duniai taki binash oigelae one. ");
INSERT INTO syll_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ashole erlagi-u ami tumare duniait otodin basaisi, zate tumare amar lila-ḳela deḳai, ar hara duniait amar nam zair oy. ");
INSERT INTO syll_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Tumi oḳono amar bonda oḳolre saṛrae na, tumar beṭagiri deḳairae, ");
INSERT INTO syll_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","te dekio, ḳail i shomoye ami ou laḳan hil-tufan ar meg dimu, zeta Mishoror zonom taki aiz forzonto kunudin oise na. ");
INSERT INTO syll_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Erlagi bondor maze tumar foshuin ar zotota ase, itare ania goro harao; manush ba foshuin zeta goro hamaita nae, itar ufre hil foṛia hokkolṭi morba.” ");
INSERT INTO syll_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Teu Feraunor uzir-naziror maze zera Mabudor zobane ḍoraila, tara zoldi kori nizor gulam ar foshuintore goror bitre anaila. ");
INSERT INTO syll_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Oile Mabudor zobanre zetae dam dilo na, tarar gulam ar foshuintore bondor maze toilo. ");
INSERT INTO syll_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Bade Mabude Musare ḳoila, “Tumi asmanor bae nizor at baṛao, teu Mishoror hokkol zagat hil-tufan oibo, Mishoror manush, foshu ar ḳetor hoḳol gas-gasalir ufre ita foṛbo.” ");
INSERT INTO syll_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Ou Musae tan ator laṭi ufredi tulla, Mabude Mishor deshor ufre megor ḍak-zilkanir loge hil-tufan deoaila; ar asmani ṭaṭa zomino foṛlo. ");
INSERT INTO syll_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Ou hilor loge megor zilkani ar ṭaṭa-o asil. I laḳan gozobi hil-tufan Mishor deshor zonom taki kunudin-o oise na. ");
INSERT INTO syll_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Hara Mishor deshor bondor mazor hokkol manush ar foshuintor ufre-o kub zure zure hil foṛlo, ar ḳetor hoḳol foshol nosṭo oigelo ar hoḳol gas-gasali-o bangi gelo. ");
INSERT INTO syll_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ḳali Boni Israilor boshot ḳana Gushon elaḳat hil-tufan oilo na. ");
INSERT INTO syll_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Bade Feraune manush faṭaia Musa ar Harunre anaia ḳoilo, “Ifira ami oforad ḳorsi. Mabud to fak-fobitro, oile ami ar amar proza oḳol oforadi. ");
INSERT INTO syll_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Te gozobi megor ḍaḳ ar hil-tufan to bout oise, ar zartam fariar na. Erlagi ami oḳon tumrare saṛi dimu, ar aṭḳaitam nae. Tumra amar lagi Mabudor gese minot ḳoro.” ");
INSERT INTO syll_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musae tare ḳoila, “Ami ṭaunor baire gia-u Mabudor gese at tulmu, teu megor ḍaḳ, hil-tufan bond oizibo, zate afne buzta faroin i duniai to Mabudor. ");
INSERT INTO syll_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Oile ami to zani, afne ba afnar uzir-nazir oḳole oḳono Alla Mabudre ḍoraira na.” ");
INSERT INTO syll_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","I shomoy ḳetor hoḳol nalia gas ar barli foshol nosṭo oigelo, ḳaron nalia gasor ful ar barlir soṛa bar oigesil. ");
INSERT INTO syll_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Oile kunuzator gomor gas boṛo na oae itar ḳeti oilo na. ");
INSERT INTO syll_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Teu Musae Feraunor samne taki ṭaunor bare gia Mabudor gese at tulla, loge loge megor ḍaḳ, hil-tufan bond oilo, megor zoṛi-o bond oigelo. ");
INSERT INTO syll_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Oile Feraun ar tar uzir-nazir oḳole meg, megor ḍaḳ ar hil foṛa bond oigese dekia tarar dil fashan ḳorilla. Feraune hirbar guna ḳorlo. ");
INSERT INTO syll_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Tar dil fashan oizaoae, he Boni Israilre saṛlo na, Mabude age zela Musare ḳoisla. ");
INSERT INTO syll_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Mabude Musare ḳoila, “Tumi Feraunor gese zao; ami to tar ar tar uzir-naziror dilre fashan ḳorilisi, zate tarar samne ami amar kudroti lila-ḳela deḳaitam fari. ");
INSERT INTO syll_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Ami Mishori oḳlor ufre zeta zeta ḳoṭin gozob disi, tarar maze kudroti zeta lila-ḳela zair ḳorsi, tumi ita tumar aolad ar nati-futir gese gof ḳortae faro, ar ami-u zen Mabud iṭa buztae faro.” ");
INSERT INTO syll_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Teu Musa ar Harune Feraunor gese gia ḳoila, “Alla, zein Ibrani oḳlor Mabud, tain nize ḳoira, tumi amar samne mata nuaite ar ḳotodin horail roitae? Huno, tumi amar bonda oḳolre amar ebadot ḳorar lagi saṛi deo. ");
INSERT INTO syll_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Tarare saṛte razi na oile dekio, ami kail tumar shimanat fongofal oḳol saṛimu. ");
INSERT INTO syll_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Itae aia tumar asta zominre oula beriliba, kunu manshe maṭi deḳto farto nae. Hil-tufan taki zotota basigese, ḳetor maze zoto gas-gasali roise, ita hokkolta tara ḳailiba. ");
INSERT INTO syll_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Tumar nizor gor-baṛi, tumar uzir-naziror gorain, ar hokkol Mishori oḳlor gorain boria jam oiziba. Tumar moy-murobbi ar tarar baf-dada oḳole-o duniait tarar zonom taki aiz forzonto kunudin oula deḳsoin na.” Oḳan ḳoia-u tain muk firaia Feraunor ges taki bare gelagi. ");
INSERT INTO syll_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Feraunor uzir-nazire tare ḳoila, “I beṭae ar ḳotodin amrare sataito? Otar Mabud Allar ebadotor lagi otare saṛi deukka. Afne oḳono kunta buzra na ni, asta Mishor deshnu sarḳar oizar?” ");
INSERT INTO syll_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Ou Feraune Musa ar Harunre hirbar anailo, anaia ḳoilo, “Tumra zaogi, gia tumrar Mabud Allar ebadot ḳoro. Oile ḳe ḳe zaitae sairae?” ");
INSERT INTO syll_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musae ḳoila, “Amra to Mabudor name hojo zairam. Te amrar huruttain, murobbi, fua-fuṛin ar goru-sagol loia zaimu.” ");
INSERT INTO syll_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Feraune ḳoilo, “Aichcha, ami zudi hasau tumrare hurutta-murutta dia saṛi dei, te tumrar ou Mabud-o zanu tumrar loge oia zaegi. Ḳobordar! Tumrar motlob to bala nae. ");
INSERT INTO syll_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Na, ila to oito nae, tumrar hokkolta nite ditam nae. Tumra zebla zaitae-u sairae, te ḳali beṭain zaogi.” Oḳan ḳoia hari Feraune tar samne taki Musa ar Harunre ḳedai dilo. ");
INSERT INTO syll_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Teu Mabude Musare ḳoila, “Tumi Mishor deshor ufre fongofalor lagi at tulo, fongofale aia Mishoror zominor hoḳol gas-gasali kailibo. Hil-tufan taki zotota basise, ita hokkolta ḳailibo.” ");
INSERT INTO syll_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Musae Mishoror ufre tan laṭi melia dorla, ar Mabude hara din hara rait deshor maze fubali haoa saṛla, ou fubali haoae biane fongofal loia azilo. ");
INSERT INTO syll_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Hara Mishor deshor ufre fongofale jam oigela. Mishoror hoḳol zagat fongofale gisgis ḳorla, kub beshi fongofal aila, oto fongofal er age-o kunudin oisoin na ar bade-o kunudin oita nae. ");
INSERT INTO syll_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Tara asta zominor ufor gurilila, desh andair oigelo, ar zominor zoto ḳet, gas-gasali hil-tufan taki basi gesil, ita hokkolta ḳailila. Asta Mishoror kunu gas-gasali ba ḳetor foshol kunta-u roilo na. ");
INSERT INTO syll_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Feraune zoldi kori Musa ar Harunre anaia ḳoilo, “Ami to tumra ar tumrar Mabud Allar gese gunagar oigesi. ");
INSERT INTO syll_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Te minot ḳoriar, ḳali ekkan bar amar guna maf ḳori deo. Amar ges taki i moron afodre horai neoar lagi, tumrar Mabud Allare minot ḳoro.” ");
INSERT INTO syll_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Ou Musae Feraunor ges taki horia gia Mabudor gese minot ḳorla; ");
INSERT INTO syll_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","ar Mabude kub zure fochchima haoa saṛla, itae fongofal oḳolre ḳedaia saf ḳoria Nil doriat falailo, Mishoror kunu zagat egu fuk-o roilo na. ");
INSERT INTO syll_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Oile Mabude Feraunor dil fashan ḳorilla, he Boni Israilre saṛlo na. ");
INSERT INTO syll_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Bade Mabude Musare ḳoila, “Tumi asman muka tumar at baṛao; teu hara desho oto gono andair oibo, i andair at dia soa zaibo.” ");
INSERT INTO syll_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Musae asman muka at baṛaile tin din forzonto hara Mishor desh kub gono andair oilo. ");
INSERT INTO syll_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Tin din ḳeu ḳeuror muk-o deḳto farlo na, ḳeu zaga taki loṛto farlo na. Oile Boni Israilor hoḳol goro kunu rushnir obab asil na. ");
INSERT INTO syll_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Feraune Musare anaia ḳoilo, “Zao, tumra gia tumrar Mabudor ebadot ḳoro, tumrar huruttainre-o neogi, ḳali tumrar goru-sagolor fal taḳouk.” ");
INSERT INTO syll_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Musae ḳoila, “Amrar Mabud Allar name dibar lagi, foshu kurbani ar zalail kurbanir foshuin amrar loge nite oibo. ");
INSERT INTO syll_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Amrar loge oia amrar foshuin-o zaiba, foshur ekkan kura-o toia zaitam nae. Amrar Mabud Allar ebadotor lagi on taki kurbani kora lagbo, ar kita kita kurbani kortam, ita amra hono na gele ḳoitam fartam nae.” ");
INSERT INTO syll_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Oile Mabude Feraunor dil fashan ḳorilla, he erare saṛte razi oilo na. ");
INSERT INTO syll_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Feraune ḳoilo, “Amar samne taki bago. Ḳobordar! Amar mukor samne ar kunudin aio na. Amar samne zedin aibae, hidin zan kuaibae.” ");
INSERT INTO syll_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musae ḳoila, “Balare bala! Ami shok koria kunudin-u afnar muk deḳat aitam nae.” ");
INSERT INTO syll_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Mabude Musare ḳoila, “Ami Feraun ar Mishor deshor ufre ar matro eḳṭa gozob saṛmu, erbade he tumrare ontone saṛidibo, saṛar bala he tumrare ekkebare ḳedai dibo. ");
INSERT INTO syll_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Tumi Boni Israilre hikai deo, hokkol beṭain-beṭinte tarar Mishori ari-forir ges taki shuna-rufar goyna-gaṭi kuzia neuk.” ");
INSERT INTO syll_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Ou haloto Mishori oḳlor nozoro maya faite Mabude shaijjo ḳorla. Ermaze Mishor desho Feraunor uzir-nazir ar proza oḳlor gese Hozrot Musa kub ijjoti bonigela. ");
INSERT INTO syll_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Musae Feraunre ḳoila, “Mabude nize ḳoira, ami ada raitkur bala Mishor deshor mazdi zaimu. ");
INSERT INTO syll_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Ete godit boa Feraunor boṛo fua taki bara-banra bandir fua forzonto, Mishor deshor maze roura hokkol foribaror boṛo fuain moriziba. Erloge hoḳol foshuintor foyla meda baichcha-o moriziba. ");
INSERT INTO syll_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","I laḳan dosha Mishor desho kunudin oise-o na ar oito-o nae, asta Mishor desho ou laḳan ḳandon ḳandiba. ");
INSERT INTO syll_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Oile Boni Israilor kunu manush ba foshur bae egu kuttae-o uh ḳorto nae, zate afnara buzta faroin ami Mabude Mishori ar Boni Israilor maze tofat ḳori.” ");
INSERT INTO syll_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Heshe Musae Feraunre ḳoila, “Ou shomoy afnar hokkol uzir-nazire aia amar faot foṛia ḳoiba, afne afnar hoḳol manshore loia bidae neingi, erbade ami bar oimu.” Oḳan ḳoia tain gusae aguin oia Feraunor ges taki horia gela. ");
INSERT INTO syll_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Mabude Musare ḳoisla, “Feraune tumar ḳota manto nae, zate Mishor desho amar keramotir foriman aro baṛe.” ");
INSERT INTO syll_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Erlagi Musa ar Harune Feraunor samne ou keramoti oḳol deḳaila. Oile Mabude Feraunor dilre fashan ḳorilla, he nizor desh taki Boni Israilre saṛlo na. ");
INSERT INTO syll_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Bade ou Mishor deshor bitre Mabude Musa ar Harunre ḳoila, ");
INSERT INTO syll_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“I sandḳan bosoror foyla sand oibo, tumra i sandre bosoror foyla sand gonio. ");
INSERT INTO syll_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Tumitain tamam Boni Israilre dola ḳori zanai deo, ou sandor dosh tariko tumrar hoḳol foribaror murobbie, zarzir foribaror lagi egu ḳori meṛa ba sagolor baichcha nibae. ");
INSERT INTO syll_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Oile kunu foribaro er gust ḳaoar manush ḳom oile, laga goror manshor loge milia, duio foribare zotoḳan ḳaita faroin, hou onumane meṛa ba sagolor baichcha nibae. ");
INSERT INTO syll_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","I baichcha oibo nikut, eḳ boros boyoshor faṭa baichcha oite oibo; tumra meṛa ba sagolor baichcha nitae farbae. ");
INSERT INTO syll_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ar ou sandor souddo tarik forzonto iṭar zoton ḳorbae, bade tamam Boni Israil eḳloge milia, tara hainja bala zarzir foribare ou baichchain zobo ḳorba. ");
INSERT INTO syll_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Zobo ḳorar bade tara er kisu lou nia zoto goro er gust ḳaiba, oto goror duaror soukaṭor duio galat ar ufror soukaṭo ou lou lagaiba. ");
INSERT INTO syll_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Hou rait-u tara i gust aguindi sekia ḳamir saṛa ruṭi ar titta hagor loge milaia ḳaiba. ");
INSERT INTO syll_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","I gust tumra ḳasa, ba fanidi randia ḳaio na. Ḳali aguindi sekia ḳaio, er ṭeng, ḳolla shudda bitoror hokkolta ekḳano sekio, bade ḳaio. ");
INSERT INTO syll_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Rait fuanir age ḳani shesh ḳorio, bian forzonto kunta-u baki toio na. Zudi kunta baki roizae, te aguindi zalailio. ");
INSERT INTO syll_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","I kani kaoar bala tumrar ḳomror ḳafoṛ mozbut ḳori findio, faot zuta lagaio, ator laṭi loio. Zoldi kori kani kaio. Iṭa oilo Mabudor namor Azadi Id. ");
INSERT INTO syll_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Hou rait-u ami Mishor deshor mazdi zaimu, deshor hokkol manshor boṛo fuare ar foshur foyla meda baichchare-o marilimu. Mishoror hoḳol deb-debir bisar ḳoria shaza dimu; ami-u Mabud. ");
INSERT INTO syll_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Oile tumrar duaror soukaṭo lefa lou deḳle ami buzmu i goro tumra ro. Erlagi ami Mishor desho gozob ḍalibar shomoy, lou lefa ou gor bad dia samnedi zaimu. Moutor gozob tone tumra rehai faibae. ");
INSERT INTO syll_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ou dinre tumra iad rakio ar ami Mabudor name idor din manio. I idre tumra amar hukum mono ḳoria hor-hamesha oarishor for oarish dori mania zaio.” ");
INSERT INTO syll_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Mabude ḳoila, “Tumra shat din forzonto ḳamir saṛa ruṭi kaibae. Foyla din-u zarzir gor taki hoḳol ḳamir falai dibae. I shato dinor maze zegue ḳamir ala nan ruṭi kaibo, tare Boni Israil tone fusia falail oibo. ");
INSERT INTO syll_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Foyla din ar shat nombor din tumra fobitro milon-mahfil adae ḳorbae, i dui din ḳali zoruri kaoa-daoa saṛa dusra kunu ḳam-ḳaz ḳorbae na. ");
INSERT INTO syll_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Ou laḳan tumra Ḳamir Saṛa Ruṭir i id adae ḳorio, amar hukum mono ḳoria oarishor for oarish dori hor-hamesha i id adae ḳorio. Ou din-u ami tumrare sifai dolor laḳan ḳori Mishor desh taki bar ḳori anmu. ");
INSERT INTO syll_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Tumra foyla sandor souddo tarikor hainja taki shuru ḳoria, ekuish tarikor hainja forzonto ḳamir saṛa ruṭi kaio. ");
INSERT INTO syll_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Ou shat din zate tumrar goro ḳamiror kunu nam-nishana na taḳe, ou shomoy ḳeu zudi kamir ala ḳani kae, te he tumrar nizor zatir ouk ba bin zatir ouk, tare Boni Israilor shomaz taki fusia falail oibo. ");
INSERT INTO syll_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","I shat din tumra zeno-u ro na ḳene ḳamir ala kunta-u ḳaio na; ḳali kamir saṛa ruṭi kaio.” ");
INSERT INTO syll_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Musae Boni Israilor hoḳol moy-murobbire dola ḳoria ḳoila, “Afnara zaukka, gia zarzir foribaror lagi Azadi Idor meṛa-baichcha ania zobo ḳoroukka. ");
INSERT INTO syll_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Ar ‘esub’ gasor eḳ aṭi ḍeṭa loia, fatilo toa lout buṛaia duaror soukaṭor duio galat ar ufre lagaio. Shabdan! Shuruz uṭar age ḳeu goror bare bar oio na. ");
INSERT INTO syll_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Mishori oḳolre marar lagi Mabude zebla Mishor deshor mazdi toshrif niba, ou shomoy tumrar soukaṭor ufre ar duio galat lou deḳle, tain i gor bad dia samnedi aguaiba. Azrail firistare tumrar goro hamaia marte dita nae. ");
INSERT INTO syll_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Amar batail hukum mono ḳoria tumra ar tumrar aolad oḳole i idre adae ḳorio. ");
INSERT INTO syll_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Ami amar nizor oada mafik tumrare ze desh dimu, hou desho gia harle-o tumra i id adae ḳorio. ");
INSERT INTO syll_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Tumrar huruttainte zebla tumrare zikaiba, i idor ḳaron kita? Iṭa kila aise? ");
INSERT INTO syll_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Te tumra zuaf dio, iṭa Mabudor name Azadi Idor kurbani. Mishori oḳolre marbar bala tain Mishor desho Boni Israilor gor bad dia samnedi aguai gia, amrare azad ḳorsla.” Ikan hunia hoḳol manshe Mabudre soizda ḳorla. ");
INSERT INTO syll_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Musa ar Harunre Mabude zela batai disla, hoḳol Boni Israil tarar goro gia ou laḳan ḳam ḳorla. ");
INSERT INTO syll_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Heshe maz raite ou laḳan goṭlo, Mabude godit boa Feraunor fua tone zel ḳanar bondir fua forzonto hokkolre marilila. Mishor deshor hokkol foribaror boṛo fuain ar foshuintor foyla meda baichchare-o tain marilila. ");
INSERT INTO syll_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Teu Feraun ar tar uzir-nazir oḳol, Mishoror hoḳol manush hozag oia uṭla, asta Mishor desho betaya ḳandonor ruil foṛlo; ḳaron ola kunu gor roisil na, ze goro ḳeu na ḳeu morse na. ");
INSERT INTO syll_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Hou rait-u Feraune Musa ar Harunre anaia ḳoilo, “Tumra zoldi zao, Boni Israilre loia amar prozar ges tone horo. Tumra zela ḳoiso, oula gia Mabudor ebadot ḳoro. ");
INSERT INTO syll_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Tumrar zoban moto-u tumrar goru-meṛar fal oḳolre-o neogi. Tumra amare-o nek dua deo.” ");
INSERT INTO syll_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Mishori oḳole kub ḍoraila, tara mono ḳorla tara-o moriziba. Erlagi tara tagda dita lagla, Boni Israil zoldi kori bidae oita. ");
INSERT INTO syll_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Boni Israile tarar moydar ḳair maze ḳamir furaibar age-u, ḳai shoho gamlain ḳafoṛdi gaiṭ bandia ḳando loila. ");
INSERT INTO syll_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Hoḳol Boni Israile Musar foramish moto, Mishori oḳlor shuna-rufar goyna-gaṭi ar ḳafoṛ-sufoṛ kuzia nila. ");
INSERT INTO syll_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Mabude ag tone-u Mishori oḳlor dilor maze eḳ doya-maya foyda ḳorsla, zate Boni Israile zeta kuziba, ota-u zanu tarare dein. Ou laḳan ḳori tara Mishori oḳlor bout don-doulot-o ḳobza ḳorla. ");
INSERT INTO syll_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Ota nia Boni Israil Ramashesh elaḳa taki Sukkotor muka roana oila. Tarar maze onuman soy laḳ shobol beṭain aṭia gela. Erar loge beṭin ar huruttain-o asla. ");
INSERT INTO syll_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Boni Israil bade-o tarar loge roura aro bout manush, goru-meṛar fal hoḳolta milia bout boṛo dol bandia roana dila. ");
INSERT INTO syll_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Bade tara Mishor taki ana hou moydar ḳai dia ḳamir saṛa ruṭi banaila. Mishor taki tarare zoldi kori bidae deoae i kait ḳamir maḳaibar shomoy-u faisla na, ar fotor lagi kunu mosa-o nita farsla na. ");
INSERT INTO syll_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Boni Israil Mishoro hokkoltae sair-sho tish boros boshot ḳorsla. ");
INSERT INTO syll_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ṭik ou sair-sho tish boros fura oibar dino Mabudor hokkol bonda, sifai dolor laḳan hazia Mishor desh taki bar oila. ");
INSERT INTO syll_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ou rait Mabude afon kudroti sayae fahara dia tarare Mishor desh taki bar ḳoria anae, i raitḳan ebadotir rait. Hokkol Boni Israilor lagi oarishor for oarish dori, Mabudor name uzagori korar ek kas rait. ");
INSERT INTO syll_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Mabude Musa ar Harunre ḳoila, “Azadi Idor kurbanir niom-ḳanun ami tumrare hikai diar. Huno, oinno kunu zatir manshore er gust ḳaite dibae na. ");
INSERT INTO syll_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Oile ḳorida gulame mosolmani koranir bade ita ḳaito farbo. ");
INSERT INTO syll_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Oinno zekunu zatir musafir ba betondari kamlare-o ita ḳaoaio na. ");
INSERT INTO syll_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Tumra zar baṛit foshu zobo ḳorbae hou baṛit-u er gust ḳaite oibo; baṛir bare kunta-u nibae na, foshur kunu aḍḍi bangibae na. ");
INSERT INTO syll_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Tamam Boni Israile ou id adae ḳorbae. ");
INSERT INTO syll_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Tumrar loge roura kunu abadie zudi Mabudor namor i id manto sae, te foyla tar foribaror hoḳol beṭaintor mosolmani korani lagbo. Bade he Boni Israilor laḳan id adae ḳorto farbo. Oile mosolmani korani saṛa ḳeu i gust ḳaito farto nae. ");
INSERT INTO syll_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Boni Israilor lagi ar abadir lagi-o eḳ homan ain zari oilo.” ");
INSERT INTO syll_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Mabude Musa ar Harunre zela hukum disla, Boni Israile hasaror oula-u amol ḳorla. ");
INSERT INTO syll_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Mabude hou din-u sifai dolor laḳan ḳori, Boni Israil oḳolre Mishor desh taki bar ḳori anla. ");
INSERT INTO syll_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Mabude Musare hukum dila, ");
INSERT INTO syll_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Tumi Boni Israilor hokkol foribaror boṛo fuainre amar name alog koria shofia deo. Ita kunu manshor fua ouk ba foshur baichcha ouk. Hoḳoltar boṛo fuain ḳali amar-u.” ");
INSERT INTO syll_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Teu Musae manshore ḳoila, “I din ḳanre tumra iad rakio, ou din-u tumra Mishoror gulami taki azad oiso. Mabude tan kudroti at dia tumrare hon taki bar ḳorsoin. I din kunuzator ḳamir ala ḳana ḳaio na. ");
INSERT INTO syll_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Abib sandor ou tariko tumra bar oilae. ");
INSERT INTO syll_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Mabude tumrar baf-dadar gese oada ḳorsoin, Kenani, Hiṭṭi, Amuri, Hibbi ar Zibuzi oḳlor desho tumrare nibagi. I desh dud ar mour banḍar-ala desh. Te hono gia harle-o tumra forteḳ bosor Abib sandor ou id adae ḳorio. ");
INSERT INTO syll_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","“Tumra shat din forzonto ḳamir saṛa ruṭi kaio, bade shat nombor dino Mabudor name id adae ḳorio. ");
INSERT INTO syll_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","I shato din ḳamir saṛa ruṭi kaoa lagbo, tumrar gese ḳamir ala kunuzator ḳana zate na deki, tumrar asta deshor bitre-o zanu kunu ḳamir na mile. ");
INSERT INTO syll_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","I din tumra hoḳole zarzir fuaintore ḳoio, ‘Amra zebla Mishor taki bar oia aislam, ou shomoy Mabude amrare zela rohom ḳorsla, otare mono raḳar lagi ami-o oḳon ola ḳorram.’ ");
INSERT INTO syll_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ou laḳan tumra zarzir aolad oḳolre Mabudor hukum talim dio, zate tumrar mono roy, Mabude tan kudroti at dia tumrare Mishor desh taki bar ḳori anchoin. Tumrar ator ba ḳofalor tabiz-ḳobzor laḳan, ou talimre-o hamesha sokur samne rakio. ");
INSERT INTO syll_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Erlagi forteḳ boros ou oḳt aile-u tumra i niom adae ḳorio. ");
INSERT INTO syll_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Mabude tumrar gese ar tumrar baf-dadaintor gese zela oada ḳorsoin, ou oada mafik tain tumrare Kenani oḳlor desh dan ḳorsoin. Te Mabude hono nia harle, ");
INSERT INTO syll_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","tumra zarzir boṛo fuare Mabudor name shofia dilaio; erloge tumrar hoḳol foshuintor foyla meda baichchare-o Mabudor name dilaio, ita to Mabudor-u. ");
INSERT INTO syll_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Oile hoḳol gadintor foyla meda baichchar bodla, tumra egu meṛa-baichcha dia ḳalas ḳoraio. Ḳalas na ḳoraile gada baichchar gordona bangi dio. Mono rakio, tumrar hokkol foribaror boṛo fuainre ḳalas ḳorani lagbo. ");
INSERT INTO syll_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Tumrar fuainte zebla zikaiba, ita kitar lagi kora lage? Tumra zuaf dio, ‘Mabude tan kudroti at dia amrare Mishoror gulami taki azad ḳori anchoin. ");
INSERT INTO syll_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Feraune na-humari koria zebla amrare aite dilo na, ou shomoy Mabude Mishor deshor hoḳol foribaror boṛo fuaintore, manshor fuain ar foshuintor foyla meda baichchainre marilla. Ou ḳarone amrar boṛo fuainre Mabudor ges taki kalas ḳorai, ar foshur foyla meda baichchare kurbani dei. ");
INSERT INTO syll_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Iṭa omon eḳ iadgarir id, at ba ḳofalo banda tabiz-ḳobzor laḳan zanu hamesha sokur samne roy, ar Mabude tan kudroti at dia amrare Mishor taki bar ḳori anchoin, oḳan mono roy.’ ” ");
INSERT INTO syll_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Feraune Boni Israilre saṛar bade, Filistini oḳlor deshor mazdi shida fot taḳle-o Allae tarare hi fotedi nila na. Allae ḳoila, heshe zudi kunu zuddor mukabila ḳora lage, te manshe zuddor ḍore hirbar Mishoro firizito fare. ");
INSERT INTO syll_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Erlagi tain manshore Nil doriar faredi morubumi bae neoaila; tamam Boni Israile sifai dolor laḳan hazi-faṛi Mishor desh taki roana oila. ");
INSERT INTO syll_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Zaoar bala Musa nobie Hozrot Iusufor ḳoybor taki tan aḍḍi-guḍḍi loge ḳori nila. Iusufe Boni Israilre mozbut ḳori kosom ḳorai koisla, “Allae nisoy tumrare hefazot ḳorba, te tumra zaoar bala amar aḍḍiguin tulia loge ḳori niogi.” ");
INSERT INTO syll_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Bade tara Sukkot gao taki roana oia morubumir kinaro Etom namor zagat aia tambu gaṛila. ");
INSERT INTO syll_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Ar Mabude tarare fot sinanir lagi dinor bala megor kuṭir surote roita, ar raitor balae for deḳanir lagi agunir kuṭir surote tarar age age zaita, erlagi tara rait-din homane solta farta. ");
INSERT INTO syll_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Manshor samne hamesha dinor bala megor kuṭi ar raitor bala agunir kuṭi roito. ");
INSERT INTO syll_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Tumi Boni Israilre ḳo, tara guria aia Fama-Hirut namor zagar ḳandat Migdul ar doriar mazamazi, Baal-Zafon elaḳar samne doriar soror maze tambu gaṛita. ");
INSERT INTO syll_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Ita deḳle Feraune mono ḳorbo, Boni Israile kunubae fot na faia guraguri korte ḳorte morubumit aṭki gesoin. ");
INSERT INTO syll_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ami Feraunor dilre fashan banaimu, he tumrar ḳore ḳore ḳedanit aibo. Teu Feraun ar tar sifai oḳolredi amar nam uzila oibo; ita dekia Mishori oḳole-o buziliba, ami-u Mabud.” Mabudor hukum mafik Boni Israile oula ḳorla. ");
INSERT INTO syll_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Hasau Mishoror bashsha Feraune zebla ḳobor failo, Boni Israil oḳol bagi gesoin, hunia-u Feraun ar tar uzir-naziror dil firigelo. Tara ḳoila, “Hae, hae! Amra ita kita ḳorsi? Itare amrar gulami taki kene saṛlam?” ");
INSERT INTO syll_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Oḳan ḳoia-u Feraune tar zuddor guṛar gaṛi hazanir hukum dia, tar sifai oḳolre zuit ḳorailo. ");
INSERT INTO syll_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","He tar ḳas shoktiman soy-sho guṛar gaṛi, Mishoror shob guṛar gaṛin ar erar saloḳdar sifaire-o loge loilo. ");
INSERT INTO syll_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Mabude Mishoror bashsha Feraunor dilre fashan ḳorilla, he Boni Israilor ḳore ḳore ḳedanit ailo. Era zebla himmot ḳori aṭia zaira, ou shomoy he erare dorat ailo. ");
INSERT INTO syll_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","He Mishor deshor hoḳol guṛ-soar sifai, guṛar gaṛiala sifai shoho asta armi dol loia erare dorar lagi erar ḳandat aillo. Ou shomoy Boni Israil oḳol doriar faro Baal-Zafonor samne Fama-Hirutor ḳandat asla. ");
INSERT INTO syll_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Tara ḳandat aite-u Boni Israile saia deḳla, tarar ḳore oia Mishori sifai aira; dekia-u zanor ḍore Mabudor dorbaro ḳandon lagaila. ");
INSERT INTO syll_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Tara Musare ḳoila, “Mishoro ḳoybor dibar zaga nai dekia, amrare martae ḳori ou morubumit loia aiso ni? Tumi ita kita ḳorlae? Ḳene amrare Mishor taki bar ḳorlae? ");
INSERT INTO syll_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Mishoror bitre amra tumare ḳoisi na ni, amrare ono roite deo, amra Mishorintor gulami kori? I morubumit morar saite Mishorintor gulami kora-u to amrar lagi bala asil.” ");
INSERT INTO syll_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musae tarare ḳoila, “Tumra ḍoraio na. Hoḳole nirai oia deḳo, Mabude aiz kila basain. Ou zeta Mishorintore oḳon deḳrae, itare ar kunudin-u deḳtae nae. ");
INSERT INTO syll_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Tumra oḳon shanti o, deḳo, Mabude-u tumrar fokko oia zuddo ḳorba.” ");
INSERT INTO syll_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Bade Mabude Musare ḳoila, “Tumi kene amar gese ḳandirae? Boni Israilre ḳo na, samnedi aguaita. ");
INSERT INTO syll_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ar tumar ator laṭire baṛaia doriar ufre usa ḳori doro, doriare dui bag korilao. Teu tamam Boni Israil hukna bae aṭia doria faroiba. ");
INSERT INTO syll_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Kial rakio, ami Mishori oḳlor dil ola fashan banaimu, tara erare dorar niote doriat hamaiba. Erbade Feraun, tar sifai, tar guṛar gaṛin, tar guṛ-soar oḳlor mazdi amar zalal-shan zair oibo. ");
INSERT INTO syll_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Feraunor hal-hokikot dekia baki Mishori oḳole-o buziliba, ami-u Mabud.” ");
INSERT INTO syll_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ermaze Allar ze firista Boni Israilor age oia zaoat asla, ein zaga bodlaia Boni Israilor ḳore gelagi. En loge oia kudroti hou megor kuṭi-o samne taki horia ḳore aillo. ");
INSERT INTO syll_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Ḳore aia Mishori ar Boni Israili duio dolor mazḳano ubailo. Erlagi ou megor kuṭir andaire Mishori oḳol andarit foṛigela, tara raitor bala Boni Israilor ḳanda loita farla na. Oile Boni Israilor samne raitor bala-o megor kuṭir forsha roilo. ");
INSERT INTO syll_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Bade Musae doriar ufre tan at baṛaila, ar Mabude hara rait kub zure fubali haoa dia doriar fani horaia dui baṭ ḳorilla, doria hukaia mazedi hukna fot bar oilo. ");
INSERT INTO syll_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Boni Israil oḳole hukna faoe doriar mazdi roana dila, doriar fani tarar ḍaine-baue oalor laḳan ubai roilo. ");
INSERT INTO syll_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ita dekia Mishori oḳole tarare ḳedaia doriar hou hukna fotedi gela. Feraunor hokkol guṛar gaṛi, guṛa, ar guṛ-soar oḳol ḳedai kedai doriar hou foto gia hamaila. ");
INSERT INTO syll_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ar fotabala Mabude hou kudroti aguin ar megor kuṭi taki Mishori sifair bae lannoti nozore saila, teu tara bedisha lagigela. ");
INSERT INTO syll_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Tain erar guṛar gaṛir sakka nosṭo ḳori dila, erlagi tarar kub ḳoshṭo ḳoria-o gaṛi salanit roilo; ermaze tara eḳe-oinnore ḳoilo, “Oise, ar bad deo, amra Boni Israilor ḳor tone hori zai. Mabude nize tarar fokko oia amrar loge zuddo ḳorra.” ");
INSERT INTO syll_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ou shomoy Mabude Musare ḳoila, “Tumi doriar ufre hirbar at baṛao. Tumar at baṛaile fani hirbar Mishorintor ufre, tarar guṛar gaṛi ar guṛ-soaror ufre aibbo.” ");
INSERT INTO syll_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Musae doriar ufre at baṛaila, ar bian oar age-u doriar fani hirbar homan oigelo; Mishorinte ḍaine-baue douṛa-douṛi lagaila, oile Mabude tarare doriar fanidi baoai dila. ");
INSERT INTO syll_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Fani hirbar zagat aillo, tarar guṛar gaṛin, sifain, ar guṛ-soar oḳol, mani Boni Israilor ḳore oia ḳedanit aora hokkolta fanie buṛigelo, egu-o zita roila na. ");
INSERT INTO syll_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Oile Boni Israil oḳole hukna fote doriar mazdi gela, tarar ḍaine-baue fani oalor laḳan ubai roilo. ");
INSERT INTO syll_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ou nomunae Mabude hi din Mishori oḳlor at taki Boni Israilre basaila, tara nizor souke deḳla, Mishorintor mora lash doriar soro foṛia roise. ");
INSERT INTO syll_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Mishorintor ufre Mabudor kudroti lila-ḳela dekia, Boni Israile-o Mabudre ḍoraigela. Tara Mabudor ufre ar tan gulam Hozrot Musar ufre furafur iman anla. ");
INSERT INTO syll_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Allar kudrote Nil doria faroia aia harle, Hozrot Musa ar tamam Boni Israile Mabudor name ou shukurana gozol gaila: “Ami Mabudor name gozol gai, hoḳlor samne tan kudroti mohima baṛise, guṛ-soar shudda guṛainre tain-u doriar fanit falaisoin. ");
INSERT INTO syll_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Alla-u to amar bol, tain-u amar gozol, amare basanir ḳol-ḳobza tan ato ase. Ou Alla-u amar Mabud, amar baf-dadar Mabud, ami tan hamd gaimu, tan lila-ḳelar boyan ḳormu. ");
INSERT INTO syll_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Mabud oila foyluan sifai, tan nam-u Mabud. ");
INSERT INTO syll_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Feraunor guṛar gaṛire ar sifaire tain fanit falaila, tar namḳora subedar oḳol Nil doriat buṛia morla. ");
INSERT INTO syll_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Goin fanie tarare gilillo, ar bari fattoror laḳan tara doriar tole gelagi. ");
INSERT INTO syll_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","O Mabud, tumar ḍain atḳan kudroti lilae bora, tumar ate nichchoy dushmonre surmar ḳorse. ");
INSERT INTO syll_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Tumar birudde zetae lagsila, kudroti bole tarare goin gato falailae. Tumar faṭail gozobi aguine, hukna ḳer-nerar laḳan tarare zalaililo. ");
INSERT INTO syll_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Tumar naḳor dome hoḳol fani dola oigelo, fanir fut oḳol zagat ubai roilo, doriar goin fani sakka bonigelo. ");
INSERT INTO syll_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Dushmone ḳoisil, ‘Ami itare ḳedaia nimu, douṛaia nia dormu, tarar hoḳolta ḳaṛia ania baṭimu. Tarar maldi ami maldar oimu, itadi amar monor ḳaish furaimu. Amar toluardi maria tarar nam miṭailimu.’ ");
INSERT INTO syll_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Oile tumi fu dia batash dilae, ar doriae tarare gurililo, tara shishar laḳan goin fanit tolaigelo. ");
INSERT INTO syll_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","O Mabud, kun deb-debi tumar homan? Ḳe tumar laḳan oto fobitro mohan, ar tumar moto boyonkor kudroti mohima ḳar ase? ");
INSERT INTO syll_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Tumar bolala ḍain atḳan baṛailae, ar duniae tarare gilililo. ");
INSERT INTO syll_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Tumar ḳas mayae zerare basaiso, tarare to tumi-u salairae, tumar afon kudroti bole tumar fobitro boshot ḳanat nirae. ");
INSERT INTO syll_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Ita hunia hokkol zatie ḳafira, Filistini be-din oḳlor mon soṭfoṭ ḳorer. ");
INSERT INTO syll_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Idumor shordar oḳol ḍoraia bedisha lagigela, Muabor neta oḳole tor-toraia ḳafila, Kenani oḳol ḍoraia horigela. ");
INSERT INTO syll_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Tarar bitre ḍor-ḳof aia hamaise, tumar ator ṭelae fattoror laḳan nirai oigese. O Mabud, tumar proza oḳol, tumar ḳorida gulam oḳol, furafur far na oa forzonto tumi oula raḳso. ");
INSERT INTO syll_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Tumi erare nia gasor serar laḳan, tumar nizor faṛo ruibae. O Mabud, hoḳan-u tumar boshot ḳana, tumar afon ator goṛa Herem Shorif. ");
INSERT INTO syll_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","O Mabud, zug zug dori tumi-u ḳali bashshai korbae.” ");
INSERT INTO syll_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Feraunor guṛain, tar guṛar gaṛin ar guṛ-soar oḳol zebla doriar maze hamaigelo, Mabude tarar ufre doriar fani firai anla, oile Boni Israil hoḳol to hukna fote doriar mazedi age aṭia geslagi. ");
INSERT INTO syll_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Harunor boin Hozrot Moriom-o nobi asla, tain ḍugi ato loia bazaila, ar baki hoḳol beṭinte-o tan ḳoredi ḍugi loia nasi nasi baroi aila. ");
INSERT INTO syll_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Ar Moriome-o manshor samne oula gaila: “Tumra Mabudor name gozol gao, hoḳlor samne tan kudroti mohima baṛise, guṛ-soar shudda guṛainre tain-u doriar fanit falaisoin.” ");
INSERT INTO syll_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Musae Boni Israilre Nil doria taki samnedi loia roana oila, ar Shur namor morubumit gela. Tarar zaoar foto tin din dori kunu fani faila na. ");
INSERT INTO syll_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Bade tara Marua namor eḳ zagat aila, oile hinor fani-o ḳaita farla na, hinor fani kub titta. Erlagi ou zagar nam laglo Marua mani, titta. ");
INSERT INTO syll_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ar manshe Musar birudde ḳana-ḳani kori koila, “Amra oḳon fani kaitam kila?” ");
INSERT INTO syll_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Musae Mabudor gese foriad ḳorla, Mabude tanre egu gas deḳai dila, tain hou gasre nia fanit falaila, ar fani miṭa oigelo. Mabude hou zagat Boni Israilor forikka loila, ar tarar lagi niom-ḳanun batai dila. ");
INSERT INTO syll_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Tain ḳoila, “Tumra zudi kial ḳoria tumrar Mabud Allar kalam huno ar ou laḳan amol ḳoro, ami zeta fosond ḳori ota ḳoro, amar hukum mano, te ami Mabude Mishori oḳolre zeta bemar-azar disi, ita kunu bemar tumrar ufre ditam nae; zano to, ami Mabud tumrar shifa ḳoroneala.” ");
INSERT INTO syll_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Heshe tara Elimo gia fosla, hino barogu fanir indara ar shottoirgu ḳezur gas asil. Tara ou fanir ḳandat tambu gaṛila. ");
INSERT INTO syll_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Bade tamam Boni Israile Elim taki roana dilaila. Mishor desh taki baronir bador sandor fonro tariko tara Sin namor morubumit aia azila. Sin oilo Tur faṛ ar Elimor mazḳano. ");
INSERT INTO syll_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ou shomoy tamam Boni Israile Musa ar Harunor birudde ḳana-ḳani lagaila. ");
INSERT INTO syll_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Era duio zonor birudde Boni Israile ḳoila, “Haere hae, itar ḳotae amra ḳene ailam, Mabude ḳene nizor ate amrare Mishor desho marla na? Hi shomoy amra gustor ḍegor ḳandat boitam, feṭ boria gust-ruṭi kaitam, oile itae amrare ufashe ar feṭor buke marta ḳori ono anchoin.” ");
INSERT INTO syll_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ikan hunia Mabude Musare ḳoila, “Ami tarare forikka ḳoria deḳmu, tara amar niom-ḳanun manoin ki na. Ami tumrar ḳani megor zoṛir laḳan asman taki zomino saṛimu. Manshe baire aia haftar forteḳ dinor ḳani forti din tulia niba. ");
INSERT INTO syll_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ḳali haftar soy nombor dino tara zeta tulia anba, ita toiar ḳorar bade oinno dinor ḳani taki ḍabul oizibo.” ");
INSERT INTO syll_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Bade Musa ar Harune hokkol Boni Israilre ḳoila, “Mabudor birudde tumra zebla ḳana-ḳani lagaiso, te aiz hainja bala-u buzbae, ou Mabude-u tumrare Mishor taki bar ḳori anchoin. ");
INSERT INTO syll_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Bian oile-u tumra Mabudor kudroti nur deḳbae, tain to hunchoin, tumra kita ḳana-ḳani korso. Te amra ar kita zen, tumra amrar birudde otota matirae?” ");
INSERT INTO syll_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Musae tarare ḳoila, “Mabude hainja bala tumrare gust diba, ar biane feṭ bora ruṭi-o diba. Mabudor birudde tumra zeta ḳana-ḳani korso, ita tain hunchoin. Ashole amra duizon kita zen, tumra amrar birudde otota matirae? I mat to amrar birudde nae, tumra Mabudor birudde-u matirae.” ");
INSERT INTO syll_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Erbade Musae Harunre ḳoila, “Tumi hokkol Boni Israilre zanai deo, tumra Mabudor birudde zeta matiso, ita tain hunchoin. Oḳon tumra aia Mabudor samne azir o.” ");
INSERT INTO syll_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Teu Harune tarare ou shongbad zanaira, ou shomoy morubumir bae tarar souk foṛte-u deḳoin, megor ḳalnir maze Mabudor kudroti nur zair oise. ");
INSERT INTO syll_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ermaze Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Ami Boni Israilor hokkol mat-ḳota hunchi. Oḳon tumi zanai deo, tara forteḳ din hainja bala ḳaiba gust ar biane ḳaiba feṭ bora ruṭi. Teu tara buzba, ami Alla-u tarar Mabud.” ");
INSERT INTO syll_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Hasau hainja bala kuel fakir fal aia tarar asta kempo jam oigelo, bador din biane kua foṛia kempor sairobae bizigelo. ");
INSERT INTO syll_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Beil oar bade ou kua hukaile deḳa gelo, shagur danar laḳan eḳzator fatla zinish maṭir ufre foṛi roise. ");
INSERT INTO syll_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ita dekia Boni Israile eḳe-oinne zikaila, “Oba, ita kita? Ita kita foṛse, amra ḳeu to sinram na.” Teu Musae ḳoila, “Ita to behesti kani, tumra ḳaitae ḳori Mabude dan ḳorsoin. ");
INSERT INTO syll_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ou ḳanir ḳota-u Mabude hukum disoin, forteḳ zone zarzir foribaror lagi kani tukaia neo. Goror hoḳlor lagi zon-fisu eḳ feṭu ḳori tukaio.” ");
INSERT INTO syll_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Teu tara oula ḳorla, manush onumane ḳeu besh ḳori nila, ḳeu ḳom nila. ");
INSERT INTO syll_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Bade feṭudi mafia deḳla, zein beshi tukaisla, tan-o beshi oise na, ar zein tuṛa tukaisla, tan-o ḳom oise na; hoḳole-u zarzir foribaror ḳanir onumane tukaisoin. ");
INSERT INTO syll_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Musae tarare ḳoila, “Tumra ḳail biankur ḳanir lagi ita muṭe-u zomai toio na.” ");
INSERT INTO syll_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ta-o ḳeu ḳeu Musar ḳota na mania bador dinor lagi-o tuṛa toilo. Erlagi ita fosia kiṛa-fuk zonmia gondo bar oilo; ita dekia Musa tarar ufre kub gusa oila. ");
INSERT INTO syll_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ola forteḳ din fozore tara zarzir ḳanir onumane tukaito, oile roid gorom oile-u ita golizito. ");
INSERT INTO syll_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Bade soy nombor dino tarar ḳanir lagi ḍabul ḳani, mani dui feṭu ḳori tukailo, ar gusṭir murobbi oḳole aia Musare zanaila. ");
INSERT INTO syll_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Musae tarare ḳoila, “Ita ṭik ase, Mabude-u oula hukum disoin; ḳail to haftar shesh din, Zummabar; Mabudor fak-fobitro din. Te tumrar zeta randar dorḳar ase ita aiz randilao, ar biran ḳorar zorur oile biran ḳoro, baki hoḳolta bador din biankur lagi toi deo.” ");
INSERT INTO syll_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ou Musar hukum mafik tara bador din forzonto ita goro toilo, itar maze kunu gondo-o bar oilo na, kiṛae-o dorlo na. ");
INSERT INTO syll_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Bade Musae tarare ḳoila, “Aiz tumra ita ḳao, ḳaron aiz Mabudor fak-fobitro din, Zummabar. Aiz tumra bondor maze i kani faitae nae. ");
INSERT INTO syll_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Tumra haftat soy din i kani tukaio, oile shat nombor din to Zummabar, i din ita faitae nae.” ");
INSERT INTO syll_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ta-o kunu kunu zone shat nombor din-o ou ḳani tukaibar lagi bare gelo, gia kunta failo na. ");
INSERT INTO syll_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Teu Mabude Musare ḳoila, “Tumra ar ḳotodin amar hukum ar niom-ḳanun bangitae? ");
INSERT INTO syll_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Huno, tumrar ziranir lagi i Zummabar to Mabude-u tumrare disoin, erlagi tain haftar soy nombor dino tumrare dui dinor ḳani dein; oḳon taki ou shat nombor din, mani Zummabare tumra hoḳole zarzir goro roia ziraio, ḳeu goror bare zaio na.” ");
INSERT INTO syll_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Erbad taki haftar shat nombor dino manshe ziraito. ");
INSERT INTO syll_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Boni Israile i kanir nam toilo, manna; ita deḳte dola ḍula bisir laḳan, ar ḳaite mou maḳail fiṭar laḳan moza. ");
INSERT INTO syll_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Bade Musae tarare ḳoila, “Mabude ou hukum disoin, tumra eḳ feṭu foriman manna tulia tumrar bador bongshodor oḳlor lagi zoma ḳori to, teu tara-o deḳba, Mishor desh taki tumrare bar ḳori neoar ḳalo morubumir maze tain kita ḳaoaisoin.” ");
INSERT INTO syll_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Musae Harunre ḳoila, “Tumi egu boyamor maze eḳ feṭu foriman manna tulia Mabudor samne to, ita tumrar oarishor for oarish dori zoma roibo.” ");
INSERT INTO syll_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Mabude Musare zela hukum ḳorsla, ou laḳan Harune ou manna boyamo borla. Bade tain fobitro shondukor bitre shahadot fattoror samne toila. ");
INSERT INTO syll_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Boni Israile sallish boros dori i manna ḳailo, tara zotodin forzonto manush boshot ḳorar zaga, mani Kenan deshor shimanat aia na fousilo, otodin ou ḳani-u ḳaila. ");
INSERT INTO syll_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Eḳ feṭu oilogi, eḳ furaror dosh baṭor eḳ baṭ. ");
INSERT INTO syll_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Bade Mabudor hukume tamam Boni Israil Sin morubumi taki roana dia, eḳ zaga taki aroḳ zagat gia gia heshe Rofidimo aia tambu gaṛila, oile hino manshor ḳaoar fani asil na. ");
INSERT INTO syll_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Erlagi manshe Musar loge ḳaijja ḳori koila, “Amrare ḳaoar fani deukka.” Musae tarare ḳoila, “Tumra ḳene amar loge ḳaijja ḳorrae? Ḳene Mabudre forikka ḳorrae?” ");
INSERT INTO syll_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Manshe fanir fiase ḳahil oia Musar birudde gali-galaz ḳori koila, “Tumi amrare martae ḳori Mishor desh taki ancho ni? Amrare, amrar huruttaintore, amrar foshur falre ana-fanie martae ḳori ono ancho ni?” ");
INSERT INTO syll_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Teu Musae Mabudor gese foriad ḳori koila, “Ami i manshore kita ḳortam? Ar tuṛa deri oile-u to tara fattordi iṭaia amare mariliba.” ");
INSERT INTO syll_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Mabude zuaf dila, “Tumi ze laṭidi Nil nodo baṛi marslae, hou laṭi ato lo, ar Boni Israilor ḳoyzon murobbire loge loia manshor age age zao. ");
INSERT INTO syll_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Gia harle ami Tur faṛor ḳandat eḳ fattoror ufre azir oimu, tumi ou fattoro baṛi marle ogu taki fani bar oibo, teu manshe ḳaita farba.” Hasau Musae Israilor murobbi oḳlor samne oula ḳorla. ");
INSERT INTO syll_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ou Rofidimo aia manshe ḳaijja ḳori koisla, “Mabud kita amrar loge asoin ni, na hori gesoin?” Oula ḳoia tara Mabudre forikka ḳorsla ḳori, i zagar nam oilo Masa mani, forikka ar Meriba mani, ḳaijja. ");
INSERT INTO syll_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Ou shomoy Boni Israilor loge zuddo ḳorar lagi Amaleki sifai oḳol Rofidimo aila. ");
INSERT INTO syll_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Teu Musae tan ḳadim Hozrot Iusare ḳoila, “Tumi amrar manush taki laṛai korra zon basia nia, Amaleki oḳlor loge zuddo ḳorat zao. Ami-o ḳail Allai kudroti laṭi ato loia faṛor ufre ubaimu.” ");
INSERT INTO syll_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Iusae-o Musar hukum mafik kam ḳorla. Amaleki oḳlor loge zuddo ḳorla, Musa, Harun, ar Hur, ou tino zon gia faṛor ṭillar ufre uṭla. ");
INSERT INTO syll_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Bade deḳa gelo, Musae zoto shomoy at usa ḳori raḳoin, oto shomoy Boni Israilor dol zitoin, oile Musae at lamaile-u Amaleki dol zitoin. ");
INSERT INTO syll_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Aste aste Musar at bar oa dorlo. Ou tara ekkan fattor ania Musare boibar bebosta dila. Ou fattoror ufre Musa boila, Harun ar Hur duiozone Musar dui galat ubaia tan at usa ḳori dorla. Teu shuruz ḍubar ag forzonto tan at usa roilo. ");
INSERT INTO syll_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Erlagi Amaleki sifair loge zuddo ḳoria Iusa zitigela. ");
INSERT INTO syll_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Bade Mabude Musare ḳoila, “Ita iad raḳar lagi tumi ekkan kitabor maze lekia to ar Iusare-o zanao. Mono rakio, ami duniar buk taki Amaleki oḳlor nam miṭailimu.” ");
INSERT INTO syll_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Musae ekkan kurbani kana banaia er nam toila, Mabud-u amar zuddor janḍa. ");
INSERT INTO syll_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Tain ḳoila, “Mabudor zuddor janḍa amra ato loi, teu Mabude-o oarishor for oarish dori Amaleki oḳlor loge zuddo ḳorba.” ");
INSERT INTO syll_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Allae Hozrot Musare ar tan bonda Boni Israilre zoto laḳan rohom ḳorsoin, ita hoḳolta Musar hour Madian deshor imam Shuaibor ḳano gelo. Mabude Boni Israilre Mishor desh taki kila bar ḳori anchoin, eota tain hunla. ");
INSERT INTO syll_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Musae age tan bibi Sofurare hour baṛit faṭai disla, erlagi tan houre Musar bibire ar duio fuare nizor gese raḳla. ");
INSERT INTO syll_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","I duio fuar mazor eḳzonor nam asil Zarsum mani, boitol. Musae ḳoila, “Ami bin desho boitolor laḳan roiram.” ");
INSERT INTO syll_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Ar dusra zonor nam asil Eliezer mani, Alla shohae. Tain ḳoila, “Amar bafor Alla amar shohae oia amare Feraunor toluar taki hefazot ḳorsoin.” ");
INSERT INTO syll_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Musar hour Shuaibe Musar bibi ar tan duio fuare loia Musar gese aila. Ou shomoy Boni Israil ar Musar tambu asil Allar faṛ Turor ḳandat. ");
INSERT INTO syll_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Tan hour ono aia Musare ḳobor dila, “Ami tumar hour Shuaib. Te ami tumar bibi ar duio fuare loia ono aisi.” ");
INSERT INTO syll_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Ḳobor faia Musae tan houror loge deḳa ḳorat bar oila. Tain maṭit soizda ḳoria tan hourre salam ḳorla ar mayar hunga dila. Bade duiozone bala-bura zikaia hari tambur bitre hamaila. ");
INSERT INTO syll_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mabude Boni Israilor fokko loia Feraun ar Mishori oḳlor loge zeta zeta ḳorsoin, ita hokkolta tan hourre hunaila. Mishor taki zaoar bala tarar ḳoto ḳoshṭo oisil ar Allae kila tarare basaisoin eota-o tanre zanaila. ");
INSERT INTO syll_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Ar Mabude Mishori oḳlor at taki Boni Israilre azad ḳoria tarare zoto laḳan asan ḳorsoin, ita hunia tan hour kub kushi oila. ");
INSERT INTO syll_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Tain ḳoila, “Hoḳol tarif Mabudor, zein Feraun ar Mishori oḳlor at taki tumrare azad ḳorsoin. ");
INSERT INTO syll_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Oḳon ami nize-o buziar, hoḳol devtar saite Alla-u mohan. Ḳaron Mishorinte zeta befar loia tumrar birudde bahaduri korta, itar ḳobza taki tain-u tumrare basaisoin.” ");
INSERT INTO syll_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Bade Musar hour Shuaibe Allar name zalail kurbani ar hoḳol zator kurbani zuit ḳori loia aila. Heshe Harun ar Boni Israilor murobbi oḳol aia, Musar houror loge boia Allar samne ḳana-fina ḳaila. ");
INSERT INTO syll_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Bador din Musae manshor bisar-salish ḳorat boila. Bisaror lagi manush aia bian taki hainja forzonto haradin tan samne ubai roila. ");
INSERT INTO syll_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Musae ola ḳorra dekia tan houre ḳoila, “Tumi manshore loia ita kita ḳorrae? Kitar lagi tumi eḳla ono bisaro roiso, ar bian taki hainja forzonto hoḳol manush tumar gese ubai roise?” ");
INSERT INTO syll_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musae zuaf dila, “Bisaror befare Allar foysala hunar lagi manush amar gese ain. ");
INSERT INTO syll_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Tara kunu ḳaijja-fosad ḳorle amar ḳasat ain, aile ami duio dolor bisar ḳori, ar Allar hukum-ahkam tarare batai.” ");
INSERT INTO syll_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Teu Musar houre ḳoila, “Tumi zelaḳan ita ḳorrae, ita to bala nae. ");
INSERT INTO syll_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ila ḳorle tumi ar tumar hoḳol manush-o ḳahil oizibae. I kam tumar takkot taki beshi, tumi eḳla ita kulaitae fartae nae. ");
INSERT INTO syll_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Te ami tumare ḳoiar, tumi amar foramish huno, ete Alla-o tumar loge roiba. Tumi manshor bisar-asar foysala ḳorar niote, tarar imam hishabe hoḳol befar Allar samne azir ḳorio. ");
INSERT INTO syll_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ar manshore-o Allar hukum-ahkam talim dio. Tara kila solta, kita ḳorta na ḳorta, ota tarare buzaio. ");
INSERT INTO syll_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ar tumi erar maz taki basia oula zoiggo manush bar ḳoro, zera Allare ḍorain, hok fote soloin, ar gush ḳaoare gin ḳoroin. Erare tumi manshor bisar-asaror dayitto deo. Era kunu zonre azar zonor ufre, ḳeurore sho zon, ḳeurore foinchash zon, ar ḳeurore dosh zonor ufre bisar-asaror bar deo. ");
INSERT INTO syll_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Era-u hamesha manshor bisar-insaf ḳorba. Huru-muru hoḳol bisar tara ḳorba, ḳali boṛo boṛo bisar tumar gese anba. Teu tumar bar kisu ḳombo, tara-o tumar loge kisu bar boukka. ");
INSERT INTO syll_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Allar hukum faia tumi zudi oula ḳoro, te tumi kulaitae farbae, ar manshe-o arame zarzir zagat zaita farba.” ");
INSERT INTO syll_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musae tan houror foramish manla, tain zela ḳoila Musae oula ḳorla. ");
INSERT INTO syll_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Musae tamam Boni Israil taki basia ufozukto manush tukaia, tara ḳeurore azar zon, ḳeurore sho zon, ḳeurore foinchash ar ḳeurore dosh zonor ufre neta banaila. ");
INSERT INTO syll_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Era hamesha manshor bisar-asar ḳorta. Ḳali boṛo boṛo goṭona oḳol Musar ḳasat anta, ar huru huru hoḳolta tara miṭaita. ");
INSERT INTO syll_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Heshe Musae tan hourre bidae dile, tain nizor desho toshrif nilagi. ");
INSERT INTO syll_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Mishor desh taki Boni Israil oḳol baronir bade, tin nombor sandor foyla din-u tara Rofidim oia Sinai morubumit fosila. Ono aia tara morubumir Tur faṛor samne tambu gaṛila. ");
INSERT INTO syll_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ermaze Hozrot Musa Tur faṛor ufre Allar dorbaro gela. Mabude faṛor ufre taki tanre ḍakia ḳoila, “O Musa, tumi Iakubor aolad oḳolre ḳo, Boni Israilre zanai deo, ");
INSERT INTO syll_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","ami Mabude Mishori oḳlor dosha kita goṭaisi, ita to tumrar nizor souke deḳso. Sile zela tar baichchare ḍaḳnadi boia ney, ami-o ou nomunae tumrare amar gese boia anchi. ");
INSERT INTO syll_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Oḳon tumra zudi amar tamam hukum-ahkam mano, ar amar logor oada adae ḳoro, te duniar hokkol zatir maz taki tumra-u oibae amar ḳas shompod. Mono rakio, hara duniar hoḳolta-u amar eḳtiaro. ");
INSERT INTO syll_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Tumrare dia-u ḳaim oibo amar imam oḳlor bashshai, tumra-u oibae amar fobitro zati. Te amar ou buli kanain tumi Boni Israilre zanao.” ");
INSERT INTO syll_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ou Musae aia Boni Israilor murobbi oḳolre dola ḳoraila. Dola ḳoraia ḳoila, Mabude tanre kita kita hukum disoin. ");
INSERT INTO syll_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Teu hoḳol manshe eḳloge ḳoila, “Mabude zela bataisoin, amra ola hokkolta ḳormu.” Manshe zemne zuaf dila, Musae gia Mabudor dorbaro ola zanaila. ");
INSERT INTO syll_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ar Mabude Musare ḳoila, “Ami zebla tumar loge batchit ḳormu, ou batchit zate manshe nizor ḳane hunto fare, erlagi ami gono eḳ megor ḳalnir maze roia batchit ḳormu. Teu manshe ita hunba, ar tumar ufre hor-hamesha furafur ekin raḳba.” Bade Musa gia tarar-o hoḳol ḳota Mabudre zanaila. ");
INSERT INTO syll_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ikan hunia Mabude Musare ḳoila, “Tumi aiz ar ḳail duio din manshor ḳasat gia tarare fak-saf ḳoro. Tara zarzir ḳafoṛ-sufoṛ doia deuk. ");
INSERT INTO syll_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Tara forshu dinor lagi toiar ouk, ou din ami Mabud Tur faṛor ufre lamia aia tara hoḳolre didar dimu. ");
INSERT INTO syll_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Te tumi faṛor sairobae eḳṭa shimana ṭik koria dilao. Dia tarare hushiar ḳori ko, tara zanu i faṛo na uṭe ar faṛor shimanat na soy. Ḳeu zudi i faṛo soy, te tar shaza oilo mout. ");
INSERT INTO syll_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Marar bala tar gotro at na dia, tare fattor ba tir maria marbae. He manush ouk ba zanuar ouk tare marilibae. Ḳali eḳloge bout shomoy shinga bazanir aoaz hunle, tara ou faṛor ḳandat aita farba.” ");
INSERT INTO syll_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Teu Musae faṛo taki lamia aia manshore fak-saf ḳorla, manshe tarar ḳafoṛ-sufoṛ doia dilo. ");
INSERT INTO syll_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Musae tarare ḳoila, “Tumra forshu dinor lagi zuit o, ermaze ḳeu bibir loge mila-misha ḳorio na.” ");
INSERT INTO syll_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Hasau hou forshu din aile bianku bala faṛor ufre gono megor ḳalni deḳa gelo, kub beshi megor ḍak-zilkani shuru oilo. Zure zure shingar aoaz huna gelo, teu Boni Israilor kempor bitoror hoḳol manush ḍoraia ḳafa dorla. ");
INSERT INTO syll_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Ou shomoy Musae manshore Allar samne neoar lagi kemp taki bar ḳorla. Tara hoḳol gia faṛor lamat ubaila. ");
INSERT INTO syll_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ar asta Tur faṛ dumae bori gelo, Mabud moulae agunir laḳan nuror surote faṛor ufre toshrif anla. Iṭ-baṭṭar dumar laḳan duma uṛa shuru oilo ar asta faṛ zuṛi bezuita ḳaf shuru oilo. ");
INSERT INTO syll_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Shingar aoaz aro zure zure bazilo. Ou shomoy Musae Allar loge matila, ar Allae-o nizor aoazdi Musar mator zuaf dila. ");
INSERT INTO syll_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Mabud nize Tur faṛor matat lamia aia Musare ḍakila, teu Musa uṭia faṛor ufre gela. ");
INSERT INTO syll_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Gia harle Mabude tanre ḳoila, “Tumi lamat zao, gia manshore ḳoṛa ḳori koia ao, arnae amare deḳar lagi tara shimana faroia ufre aibba. Aile bout manush mara zaiba. ");
INSERT INTO syll_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ar ze imam oḳol hamesha amar samne azir oin, ashole tarar ḳam-u amar samne azir oa, tara-o nize nizore fak-saf ḳorba. Arnae ami tarar ufre-o gozob ḍalimu.” ");
INSERT INTO syll_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musae Mabudre zuaf dila, “Tara to emne-u Tur faṛo aita nae, afne age-u amrare ḳoṛa hushiari disoin. Amra-o faṛor sairobae dag dia afnar lagi pak shimana algaisi.” ");
INSERT INTO syll_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Oile Mabude tanre ḳoila, “Na, tumi lamat zao. Bade tumi ar Harun duiozone milia ufre aio. Kial rakio, kunu imam ba dusra kunu manush zate shimana saṛia amar ḳasat na ain, aile ami tarar ufre lannoti gozob ḍalmu.” ");
INSERT INTO syll_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ikan hunia Musa lamat gela, gia manshore hoḳolta zanaila. ");
INSERT INTO syll_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Bade Mabude formaila, ");
INSERT INTO syll_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“O Boni Israil oḳol, ami Alla-u tumrar Mabud. Mishor deshor gulami taki ami-u tumrare ḳalas ḳori anchi. ");
INSERT INTO syll_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Amar bodla tumra dusra kunu devta manio na. ");
INSERT INTO syll_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Puja ḳorar kiale tumra kunu murti banaio na, asman, zomin ba fanir tole zotota ase, ita kunutar surote murti banaio na. ");
INSERT INTO syll_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Tumra itar puja ḳorio na, itar sheba-zoton ḳorio na. Mono rakio, ami Alla to la-shorik Mabud, kunu shorik shoijjo ḳori na. Huno, amare zera mane na, ami tarar gunar shaza dei, tarar tin-sair siṛi forzonto shaza dei. ");
INSERT INTO syll_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Oile zera amar ashik bonia amar hukum-ahkam amol ḳore, ami tarar azar azar oarish forzonto amar obiram maya-mohobbot deḳaimu. ");
INSERT INTO syll_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Beḳama kunu ḳarone tumrar Mabud Allar nam muko loio na. Ḳeu zudi kamoḳa Mabudor nam loy, te kunumonte-u amar shaza taki rehai faito nae. ");
INSERT INTO syll_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Iad ḳoria Zummabarre fobitro din manio. ");
INSERT INTO syll_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Haftar soydin tumra ḳam-ḳaz ḳorio, tumrar dorḳari hoḳol ḳam shario. ");
INSERT INTO syll_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Oile shat nombor din oilo Zummabar, tumar Mabud Allar name ziraibar din. I din tumi, tumar fua-fuṛin, tumar gulam-bandin, tumar foshur fal, tumar gaut ba ṭauno roura musafir ba bin-deshi, ḳeu kunuzator ḳam-ḳaz ḳorio na. ");
INSERT INTO syll_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Zano to, Mabude soydine asman-zomin, doria ar erar mazor hoḳolta foyda ḳorsoin, bade shat nombor din ziraisoin, kunu ḳam ḳorsoin na. Ou dinre Mabude rohomot dia pak din ḳorsoin. ");
INSERT INTO syll_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Tumrar ma-bafre ijjot ḳorio. Teu tumrar Mabud Allae ze desh diba, hou desho tumrar hayati baṛibo. ");
INSERT INTO syll_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Kun ḳorio na. ");
INSERT INTO syll_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Zina ḳorio na. ");
INSERT INTO syll_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Suri korio na. ");
INSERT INTO syll_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Ḳeuror birudde misa shakki dio na. ");
INSERT INTO syll_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Foror gor-duaror bae lalos ḳorio na, tar bou, gulam-bandi, goru-gada, ba kunu kichchur bae lalos ḳorio na.” ");
INSERT INTO syll_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Boni Israile zebla faṛ taki megor ḍaḳ, zilkani, shingar aoaz, ar duma baronit deḳla, dekia tara duroi taki-u ḍoraia ḳafa dorla. ");
INSERT INTO syll_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Tara Musare ḳoila, “Afne-u amrar loge matoukka, amra hunmu; oile Allae amrar loge batchit ḳorle to amra morizimu.” ");
INSERT INTO syll_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musae tarare ḳoila, “Tumra ḍoraio na. Allae tumrare forikkat falaisoin, zate tumrar zano Allar ḍor hamae, ḍoraia tumra guna taki basia ro. Erlagi-u tain nize didar disoin.” ");
INSERT INTO syll_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Hoḳol manush duroi ubai roila, ar Musa Allar hazirar hou megor ḳalnir andarir gese gela. ");
INSERT INTO syll_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Mabude Musare ḳoila, “Tumi Boni Israilre ḳo, tumra nize-u to deḳlae, ami Mabude asman taki tumrar loge batchit ḳorlam. ");
INSERT INTO syll_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Erlagi ebadot ḳorar niote, amar bodla dusra kunuzat devta banaio na. Tumra shuna ba rufadi-o nizor kunu deb-debi banaio na. ");
INSERT INTO syll_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“Amar lagi kali maṭi dia kurbani kana banaio. Er ufre tumrar zalail kurbani ar salamoti kurbanir goru-sagol ania kurbani dio. Zeta zagainto ami amar nam iad ḳorai dimu, hou zagainto ami nize azir oia tumrare dua dimu. ");
INSERT INTO syll_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Tumra amar lagi fattordi kunu kurbani kana bananit lagle, hi fattorguin ḳaṭio na. Er ufre atiar salaile tumra itare nafak banailibae. ");
INSERT INTO syll_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Amar kurbani kana oula ḳori banaio, zate er ufre uṭte kunu moi ba siṛi na lage, moi ba siṛi bae uṭat gele kiba tumrar shorom deḳa zaibo.” ");
INSERT INTO syll_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Mabude Musare aro ḳoila, “Tumi Boni Israilre amar ou niom-ḳanun oḳol zanao. ");
INSERT INTO syll_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Tumra zudi kunu Ibrani beṭare ḳorid ḳoria gulam banao, te ou gulame soy bosor tumrar gulami korbo, bade shat bosoror bala tar ges taki kunta na nia, tare emne-u azad ḳori dibae. ");
INSERT INTO syll_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","He zudi eḳla tumrar gese ae te eḳla-u zaibo; ar zudi boure loge loia ae, te bou loia zaibo. ");
INSERT INTO syll_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Oile tar munibe zudi tare bia ḳorai taḳe, ar tar kunu hurutta-murutta oin, taile i beṭi ar huruttain munibor gese-u roiba; he ḳali eḳla azad oibo. ");
INSERT INTO syll_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ar hi gulame zudi saf ḳori koy zen, he tar munib ar tar bou-baichchar mayae, erare saṛia zaito nae, ");
INSERT INTO syll_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","te i malike tare loia Allar dorbaro azir oibo. Tare duaror ḳofaṭ ba soukaṭor loge uba ḳoria munibe shik dia tar ḳano fuṛ ḳorbo. Teu he hara zindegibor munibor gulamit roibo. ");
INSERT INTO syll_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Kunu manshe zudi bandigirit dibar lagi tar nizor fuṛire besilae, te gulam oḳol zela soy bosor bade munibor baṛi taki emne-u azad oizain, ou fuṛi to ila azad oito nae. ");
INSERT INTO syll_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Tair munib zudi tair ufre kushi na oin, te ṭeḳa-foyshar bodla taire azad ḳori dite oibo. Taire dusra kunu zatir manshor gese besibar eḳtiar nai, ḳaron munibe to tan nizor dayitto adae ḳorsoin na. ");
INSERT INTO syll_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Oile munibe zudi tan nizor fuar lagi taire fosond ḳoria nein, te taire afon fuṛir laḳan hoḳol ḳemota dite oibo. ");
INSERT INTO syll_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Munibe zudi ou bandire bia ḳorar bade, dusra kunu ḳoinare bia ḳore, ta-o i bandir kuraki, ḳafoṛ-sufoṛ ar shorilor faona hok taire deoa lagbo. ");
INSERT INTO syll_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","He zudi ou tino hok furafur adae na ḳore, te i fuṛire eḳdom bina foyshae azad ḳori dite oibo. ");
INSERT INTO syll_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Mair ḳaia zudi kunu manush morizae, te zegie tare marse, tare-o zane mara oibo. ");
INSERT INTO syll_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Oile he nize zudi kun na ḳorar niote mare, aḳta kunu ḳarone goṭizae ba ami Allar morzie ita oy, te ou kuni zon gia ola kunu zagat bagito farbo, ze zagar ḳota ami tumrare ḳoimu. ");
INSERT INTO syll_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ar ḳeu zudi zania-hunia ichcha ḳori keurore kun ḳoria, bade aia amar kurbani kanar gese-o asroy loy, ta-o hon taki doria nia tare zane mara oibo. ");
INSERT INTO syll_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Ze manshe tar afon ma ba bafor ufre at tule, tare nisoy zane mara oibo. ");
INSERT INTO syll_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Ḳeu zudi kunu manshore suri koria ania besilae, ba ou manshore tar gese faoa zae, te tare nichchoy zane mara oibo. ");
INSERT INTO syll_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Ze manshe afon ma ba bafre gali-galaz ḳore, tare-o nichchoy zane mara oibo. ");
INSERT INTO syll_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Kunu manshe ḳaijjat lagia zudi logor zonre ṭushi ba fattordi mare, i mair ḳaia ou zon na morle-o bisnat hutia foṛono taḳe, ");
INSERT INTO syll_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","heshe uṭia laṭi bor dia sola-fira ḳorar zorur oy, te zegie tare marse tare zane mario na. Ḳali hou zonor ḳam-ḳazor ḳeti ar tar shullo-ana daoai koros dite oibo. ");
INSERT INTO syll_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Ḳeu zudi tar ḳorida gulam-bandire laṭi dia mare ar mair ḳaia ogu morizae, te ere shaza dite oibo. ");
INSERT INTO syll_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Oile mair ḳaoar dui-eḳdin bade zudi basia roy, te kunu shaza deoa lagto nae, ḳaron ou gulam to tar nizor samana asil. ");
INSERT INTO syll_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Mara-mari korat lagia zudi aḳta ḳeu kunu beṭire mare ar tair feṭor baichcha nosṭo oizae, oile ar kunu ḳeti na oy, te ou beṭir zamair dabi ar bisari-salishor bibechona mafik ere ḳeti-furon dite oibo. ");
INSERT INTO syll_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Oile zudi tair aro kunu ḳeti oy, taile ere ou laḳan shaza dibae: ");
INSERT INTO syll_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","zanor bodla zan, souḳor bodla souk, dator bodla dat, ator bodla at, faor bodla fao, ");
INSERT INTO syll_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","zalanir bodla zalani, zoḳomor bodla zoḳom, dagor bodla dag dite oibo. ");
INSERT INTO syll_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Ḳeu zudi tar ḳorida gulam ba bandir kunu sokut marae souk nosṭo oizae, te ou souḳor bodla he i gulamre azad ḳori dite oibo. ");
INSERT INTO syll_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Zudi maria er dat falai dey, ta-o ere azad ḳori deoa lagbo. ");
INSERT INTO syll_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Kunu gorue gutaia zudi kunu beṭa ba beṭire marilae, te gorur malikre kunu shaza deoa lagto nae. Ḳali hi gorure fattordi iṭaia marilite oibo, i gorur gust ḳeu ḳaito farto nae. ");
INSERT INTO syll_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Oile i gorur zudi hamesha oula gutanir ḳaichchot taḳe, ar hi malikre hushiar ḳorar bade-o he iṭare aṭḳae na, ermaze i gorue kunu beṭa ba beṭire marilae, te i gorure fattor maria marilite oibo, ar tar malikre-o marilite oibo. ");
INSERT INTO syll_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Zudi i malikor gese kunu ḳeti-furon saoa oy, taile he ou zorimana dia nizor zan basaito farbo. ");
INSERT INTO syll_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","I gorue zudi kunu huruttare gutaia marilae, taile erlagi-o ou homan niom oibo. ");
INSERT INTO syll_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Kunu gorue zudi keuror gulam ba bandire gutaia marilae, taile gorur malike hi gulamor malikre tish tola foriman rufa dite oibo ar hi gorure-o fattor mari marilite oibo. ");
INSERT INTO syll_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Ḳeu zudi kunu gator muk kulia toy ba gat kudia igur muk guria na toy, ar i gator bitre kunu goru ba gada foṛizae, ");
INSERT INTO syll_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","taile gator malike foshur malikre ḳeti-furon dite oibo. Oile i mora foshu faibo gator malike. ");
INSERT INTO syll_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Ḳeuror gorue zudi aroḳzonor gorure gutaia marilae, te hou zita gorure besia, er dam ar mora gorur dam-o era duiozone homan homan ḳori baṭia niba. ");
INSERT INTO syll_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Oile ag taki zudi zana-huna taḳe zen, i gorue ola gutae, ar tar malike tare na aṭḳae, te gorur bodla goru dite oibo, bodla deora zone ou mora goruṭa faibo. ");
INSERT INTO syll_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Ḳeu kunu manshor goru ba meṛa-sagol suri koria ania zudi besilae ba zobo ḳorilae, te ek gorur bodla fasgu, eḳ meṛa ba sagolor bodla sairgu firot dite oibo. ");
INSERT INTO syll_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","Sure tar surir malor ḳeti-furon dite oibo, oile tar zudi keti-furon dibar kunu takkot na taḳe, te tare besia er ḳeti-furon adae ḳorte oibo. Suri kora goru-gada ba meṛa-sagol zudi suror gese zita faoa zae, taile he ita egur bodla dugu firot dite oibo. “Kunu sure zudi surit gia goro hamaibar bala dora ḳailae ar zoḳom oia morizae, taile tare marar lagi marra zon dayi oito nae. Oile shuruz uṭar bade zudi dinor bala ila oy, te i kunor lagi he dayi oibo. ");
INSERT INTO syll_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Ḳeu zudi tar goru-sagol nizor bagano ba ḳetor maze raḳat gia saṛi dey, ar itae gia manshor ḳetor foshol ḳailae, te tar nizor ḳetor hoḳol taki bala ongsho bodla dia ḳeti-furon dite oibo. ");
INSERT INTO syll_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Kunu zaga taki aguin lagia zudi zuf-zongol zole, ar bade ou aguin gia ḳeuror ḳetor maze banda muiṭ, ṭeki ba asta ḳet zoli zae, te aguin zegie zalaisil, he itar ḳeti-furon dibo. ");
INSERT INTO syll_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Ḳeu zudi aroḳzonor gese mal-samana ba ṭeḳa-foysha amanot toy, ar amanot-daror gor taki ita suri oizae, te ou sur dora foṛle, sure er ḍabul firot dibo. ");
INSERT INTO syll_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Oile sur dora na foṛle, hi goror malike nize-u ita lukaise ni, oḳan zanar lagi tare Allar dorbaro azir ḳorbae. ");
INSERT INTO syll_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Aroḳ zonor doḳolo ase, oula kunu goru-gada, meṛa-sagol, finnor ḳafoṛ ba zekunu arail samana dekia ḳeu zudi mono ḳore iṭa tar mal, taile iṭar salishir lagi tara duiozon gia Allar dorbaro azir oibo. Allae zare dushi shaibosto ḳorba, he tar birudi zonre er ḍabul firot dibo. ");
INSERT INTO syll_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Ḳeu zudi tar goru-gada, sagol-meṛa ba oinno kunu foshure kunu girostor gese raḳat dey, ar ogu morizae, zoḳom oizae ba araizae, oile er kunu shakki na mile, ");
INSERT INTO syll_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","te ou giroste nize-u zen ita ḳorse na, iṭa he Mabudor samne gia ḳosom ḳoria miṭ-maṭ ḳorbo. I foshur malike-o ikan mante oibo, tain kunu ḳeti-furon faita nae. ");
INSERT INTO syll_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Oile i girostor ges taki zudi iṭa suri oizae, te malike ḳeti-furon faibo. ");
INSERT INTO syll_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Zudi kunu zongli zanuare doria igure marilae, taile er formanor lagi ogur fara-siṛa ṭukrain ania deḳani lagbo. Teu er kunu ḳeti-furon lagto nae. ");
INSERT INTO syll_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Ḳeuror ges taki kuzia ana kunu foshu zudi malikor aforḳe zoḳom oy ba morizae, te zein kuzia anchoin, ein er ḳeti-furon diba. ");
INSERT INTO syll_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Oile malikor samne-u zudi oula oy, te ḳeti-furon lagto nae. I foshu zudi ṭeḳa dia baṛa ḳori ana oy, te ou baṛar ṭeḳa-u oibo er ḳeti-furon. ");
INSERT INTO syll_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Biar aḳt oise na, oula kunu shoti fuṛire ḳeu zudi misa matia ania tair loge zina ḳorilae, taile hou beṭae fuṛir bafre zorimana dia ou fuṛire bia ḳorte oibo. ");
INSERT INTO syll_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Oile fuṛir bafe zudi tar fuṛire i fuar gese bia dite kunumonte-u razi na oy, ta-o i zorimana dite oibo. ");
INSERT INTO syll_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Kunu zadugir beṭire tumi zita rakio na. ");
INSERT INTO syll_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Kunu foshur loge ḳeu zina ḳorle, tare nisoy zane mara oibo. ");
INSERT INTO syll_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Ḳali Mabud saṛa dusra kuntar name zudi keu kunu boli-foshad dey, te tare-o shesh ḳorilte oibo. ");
INSERT INTO syll_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Kunu bin-deshi manshor loge bad bebohar ḳorio na, tare zulum ḳorio na. Mono rakio, tumra-o eḳ shomoy Mishor desho musafir aslae. ");
INSERT INTO syll_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Kunu ṛaṛi beṭire ba kunu etim huruttare duk dio na. ");
INSERT INTO syll_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Tarare duk dile tara zudi kande, te i kandon nisoy ami kobul ḳormu. ");
INSERT INTO syll_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Ete amar gusa oibo aguin borabor. Tumra zuddot foṛia morbae, tumrar bou-o ṛaṛi oibo, tumrar huruttain-o oula etim oiba. ");
INSERT INTO syll_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Tumra zudi amar kunu obabi bondare ḳoroz deo, taile shudkuror laḳan tar ges taki shud nio na. ");
INSERT INTO syll_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ḳeuror gotror saddor bondok raḳle, shuruz ḍubar age-u tar saddor firot dilaio. ");
INSERT INTO syll_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Ḳaron uṛibar lagi oṭa-u tar eḳmatro shombol. Ikan nilegi he kita uṛia hutibo? Huno, he zudi amar gese ḳande, te ami to rohmanur rohim, ami tar ḳandon hunmu-u. ");
INSERT INTO syll_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Tumi Allar birudde matio na, tumar kunu bisarok-salishre-o boddua dio na. ");
INSERT INTO syll_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Tumrar ḳetor foshol ba anguror shorbotor ze baṭ amare dibar ḳota, amar i baṭ dite deri korio na. Tumra hoḳlor boṛo fuain amare dilaibae. ");
INSERT INTO syll_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Tumrar goru-basur ar sagol-meṛar lagi-o ou eḳ shoman hukum. Itar hoḳol boṛo meda baichchain shatdin forzonto tarar maʼr gese roiba, aṭ dinor din amare dilaibae. ");
INSERT INTO syll_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Tumra-u oibae amar fak-fobitro bonda. Zongli zanuare maria falaise, ila kunu zandaror gust tumra ḳaio na; ita kukurre ḳaoaio. ");
INSERT INTO syll_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Tumra misa kunu bodnam bar ḳorio na. Fokkofati kori misa shakki dia kunu ḳobis manshore shaijjo ḳorio na. ");
INSERT INTO syll_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Shomazor doshzone oinnae ḳorer dekia tumi-o oula ḳorio na. Kunu mamla-mokoddomar shakki deoat gia, shoktiala dolor fokko loia oinnae ḳam ḳorio na. ");
INSERT INTO syll_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ar kunu goribor bisaro gia, he gorib gotike-u tar fokko loio na. ");
INSERT INTO syll_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Tumar dushmonor kunu goru-gadare be-fote zaoat deḳle, iṭa firaia ania tar gese dio. ");
INSERT INTO syll_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Tumare ingsha ḳore ila kunu manshor gadare baror tole foṛigese deḳle, tare ila falaia zaio na. Ou gadare tulat tumi oboshshoi shaijjo ḳorbae. ");
INSERT INTO syll_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Kunu goribor mamla-mokoddomat oinnae salishi korio na. ");
INSERT INTO syll_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Hazail misa mamla taki horia roio. Kunu be-ḳosur ba ni-oforadi manshore moutor shaza dio na. Zegie ila oinnae ḳorbo, tare ami saṛtam nae. ");
INSERT INTO syll_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Gush ḳaio na, ḳaron gushe souk ala manshore-o anda ḳorilae. Gushe bala manshor mator maze-o fes lagai dey. ");
INSERT INTO syll_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Kunu bin-deshi manshor ufre zulum ḳorio na. Musafiror hal-hokikot to tumra zano, ḳaron tumra-o Mishor desho musafir aslae. ");
INSERT INTO syll_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Tumra eḳlagare soy boros zomino ḳet ḳorio ar foshol ḳaṭio, ");
INSERT INTO syll_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","bade shat nombor boroso zomino kunu ḳet na ḳoria fotit rakio, zominre aram dio. Ete zomino emne-u zeta folibo, ota tumrar gorib oḳole ḳaia basiba. Tara neoar bade zeta foṛi roibo, ita zongli foshu-fakinte ḳaiba. Tumrar anguror bagan ba zoytun baganor lagi-o ou hukum manio. ");
INSERT INTO syll_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Tumra haftat soy din ḳam ḳorio, oile shat nombor din to Zummabar, idin kunta ḳorio na. Teu tumrar goru-gadae ziraiba, ar tumrar baṛit zonmise i gulam ar musafir oḳlor zane-o aram faibo. ");
INSERT INTO syll_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Ami tumrare zeta hukum dilam, ita kub hushiar oia amol ḳorio. Kunu devtar nam muko loio na, itar nam zanu tumrar muko na huna zae. ");
INSERT INTO syll_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Tumra forteḳ boros tinbar amar name id adae ḳorio. ");
INSERT INTO syll_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Foyla, Ḳamir Saṛa Ruṭir Id adae ḳorio. Ami zela hukum ḳorsi, ekkere ou laḳan Abib sandor shatdin ḳamir saṛa ruṭi kaio, ḳaron ou sando tumra Mishor taki bar oia aislae. Idor shomoy lilla-sodga saṛa tumrar ḳeu zanu ḳali ate amar gese na ae. ");
INSERT INTO syll_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Dusra, tumra Foshol Daoar Id manio. Ḳetor maze tumra zeta ruiso, ita daoar bade foyla foshol dia-u id ḳorio. Tisra id, bosoror hesh sando baganor faḳna fol baṛit anar bade Ḍera-goror Id ḳorio. ");
INSERT INTO syll_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Ou tino idor shomoy, bosoro tinbar tumrar hoḳol beṭain aia hoj ḳorar niote ami Alla malikor samne azir oio. ");
INSERT INTO syll_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Tumra zebla amar name foshu kurbani deo, ou shomoy ḳamir ala kunuzat ruṭi itar loge furaia lilla dio na. Idor shomoy amar name zeta foshu kurbani dibae, itar sorbiala ṭukrain bian forzonto rakio na. ");
INSERT INTO syll_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Tumrar ḳetor hoḳol taki bala foshol, tumrar Mabud Allar goro anio. “Ar huno, kunu sagolor baichchar gust tar maʼr dud dia randio na. ");
INSERT INTO syll_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Ami tumrar lagi ze zaga zuit ḳori raḳsi, hono tumrare hefazote fosanir lagi, ami tumrar age age eḳzon firista faṭaimu. ");
INSERT INTO syll_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Tumra en ḳota mon dia hunio ar manio, en loge to ami-o asi. Hushiar roio, en birudde zaio na. Arnae ein tumrar oforad maf ḳorta nae. ");
INSERT INTO syll_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Oile tumra zudi en hukum mano, ar ami zela ḳoisi oula solo, taile tumrar dushmonor loge ami dushmoni kormu, zera tumrar birudde lagbo, ami tarar birudde lagmu. ");
INSERT INTO syll_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Amuri, Hiṭṭi, Farizi, Kenani, Hibbi ar Zibuzi oḳlor desho amar firistae tumrare nia haraiba. Ami tara hoḳolṭire binash ḳorilimu. ");
INSERT INTO syll_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Tumra tarar devtare puja ḳorio na, kezmot-o ḳorio na, ar hinor manshe zeta ḳoroin tumra ita ḳorio na. Tumra tarar deb-debir murtin ar tarar pujar monḍop oḳol bangia surmar ḳorilio. ");
INSERT INTO syll_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Tumra ḳali tumrar Mabud Alla, mani amar ebadot ḳorio. Teu tumrar rizekor maze rohomot dimu, ar tumrar hokkol bemar-azar dur ḳormu. ");
INSERT INTO syll_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Tumrar deshor kunu beṭir feṭor hurutta nosṭo oito nae, ḳeu aṭkura roito nae. Ami tumrare furafur hayati forzonto basaia raḳmu. ");
INSERT INTO syll_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Tumra zoto zatir ḳasat zaibae, tarar dilor maze ag taki amar ḍor-ḳof foyda ḳormu, tarare bedisha banailimu. Tumrar hokkol dushmon ḳoredi bagiba. ");
INSERT INTO syll_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Hibbi, Kenani ar Hiṭṭi oḳolre tumrar samna taki kedaibar lagi, ami tumrar age ḳori bingulor fal faṭaimu. ");
INSERT INTO syll_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Oile ami tara hokkolre eḳoi bosoror bitre ḳedaitam nae, arnae asta desh fotit roia zongli zanuare boriziba, bade itae tumrare sataiba. ");
INSERT INTO syll_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ami aste aste tarare ḳedaimu, ar tumrar manush baṛia asta desh abad ḳorbae. ");
INSERT INTO syll_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Ami Nil doria taki Filistini deshor shagor, mani Bumodio shagor forzonto, ar douknor morubumi taki Furat gang forzonto tumrar deshor shimana gaṛmu. I desho zera boshot ḳorer tarare tumrar ato shofimu, ar tumra tarare i desh taki kedai dibae. ");
INSERT INTO syll_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Tarar loge ba tarar devta oḳlor loge tumra kunu chukti korio na. ");
INSERT INTO syll_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Tumrar deshor bitre tarare roibar dio na. Arnae tara tumrare amar ges taki horaia gunar fote ṭania nibogi. Tumra zudi tarar deb-debir puja ḳoro, taile nichchit tumra-o tarar fando hamaibae.” ");
INSERT INTO syll_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Mabude Musare ḳoila, “Tumi ar Harun, Harunor fuain Nadab ar Abihu, ar Boni Israilor shottoir zon murobbi neta amar gese uṭia ao. Aibar bala tumra duroi taki amare soizda ḳorio. ");
INSERT INTO syll_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Oile ḳali tumi eḳla amar ḳasat ufre aibae, ar ḳeu nae. Erar loge ar kunu Boni Israil zanu na uṭe.” ");
INSERT INTO syll_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Musae manshor gese aia Mabudor hokkol kalam ar ain-ḳanun hunaila, ita hunia hoḳol manshe eḳloge ḳoila, “Mabude zotota bataisoin ita hokkolta amra manmu.” ");
INSERT INTO syll_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Mabudor batail hoḳol kalam Musae lekia toila. Bador din fozore uṭia faṛor lamat ekkan kurbani kana banaila, ar Boni Israilor baro gusṭire iad raḳar lagi barogu kuṭa banaila. ");
INSERT INTO syll_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Bade tain Boni Israilor zuan oḳolre faṭaila ar tara Mabudor name bout zalail kurbani dila, ar bout bisal zobo ḳoria salamoti kurbani-o dila. ");
INSERT INTO syll_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musae kurbanir lour ordeḳ nia ḳoyṭa baṭit toila, ar baki ordeḳ nia kurbani kanar ufre siṭai dila. ");
INSERT INTO syll_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Bade tain Allar loge milonor usillar niom-ḳanun leḳa kitabḳan tilaot ḳori manshore hunaila. Ita hunia manshe zuaf dila, “Amra Mabudor hoḳol hukum hunmu, tain zotota ḳoisoin hoḳolta manmu.” ");
INSERT INTO syll_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Oḳan hunia Musae lou loia manshor ufre siṭaia ḳoila, “I lou oilo Allai milonor hou usillar lou, ze usilla Mabude tan hoḳol shorto mafik tumrar loge boail ḳorsoin.” ");
INSERT INTO syll_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Teu Musa, Harun, Nadab, Abihu ar Boni Israilor shottoir zon murobbi neta faṛor ufre uṭla. ");
INSERT INTO syll_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Tara nizor souke Boni Israilor Alla Pakor didar deḳla. Tara deḳla, Allar fao mubarokor tole ase, soḳsoḳa lil moni fattoror toiari saṭor laḳan, asmanor nomunae saf. ");
INSERT INTO syll_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Boni Israilor murobbi oḳole Allare deḳle-o tain erare marar lagi at tulla na. Tara tan didar faila ar ḳaoa-daoa ḳorla. ");
INSERT INTO syll_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Bade Mabude Musare ḳoila, “Tumi ou faṛor ufre amar ḳandat ao, aia ḳoydin ro. Manshore talim dibar lagi amar ze hukum-ahkam fattoror ufre leḳsi, ota ami tumare dimu.” ");
INSERT INTO syll_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Teu Musae tan ḳadim Iusare loge loia faṛo uṭla, ar Musa Allar faṛo gela. ");
INSERT INTO syll_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Tain murobbi oḳolre ḳoia gela, “Amra firot aibar ag forzonto afnara amrar lagi ono bar saiba. Harun ar Hur afnarar ḳasat asoin, kunu ḳaijja-fosad lagle erar gese zaiba.” ");
INSERT INTO syll_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Musa faṛo uṭte-u asta faṛ megor ḳalnie gurigelo, ");
INSERT INTO syll_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","ar Tur faṛor ufre Mabudor nuror tozolli zair oilo. Soy din asta faṛ ḳalnie gura roilo. Shat nombor din ou ḳalni taki Mabude Musare ḍakila. ");
INSERT INTO syll_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Boni Israile Mabudor nuror tozolli deḳla, tara deḳla faṛor ufre agunir laḳan zoler. ");
INSERT INTO syll_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Faṛ baia uṭi uṭi Musa hou ḳalnir bitre hamai gela. Tain sallish din sallish rait hou faṛo roila. ");
INSERT INTO syll_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Tumi Boni Israilre ḳo, tara amar gese dan-ḳoyrat loia azir ouk. Tarar nizor kushie zeta dan ḳorba, ota tumi shomzia rakio. ");
INSERT INTO syll_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Tarar ges taki ou laḳan mal shomzio: shuna, rufa, fitol; ");
INSERT INTO syll_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","lilua, baingoni, lal rongor suta; dami suti kafoṛ ar sagolor ruma; ");
INSERT INTO syll_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","lal rong lagail meṛar samṛa, doriar fuʼ masor samṛa; babla laḳṛi; ");
INSERT INTO syll_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","serag oḳol zalanir lagi zoytunor tel; kelafoti shomzibar telor moshla ar agor-kushboy bananir moshla; ");
INSERT INTO syll_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","imamor lebasor efron ar bukur ufror tolit laganir akik moni ar baki hoḳol zator dami fattor. ");
INSERT INTO syll_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Amar roar lagi tumi Boni Israil oḳolredi fak-fobitro ekkan zaga toiar ḳoraibae. Teu ami tarar loge boshot ḳormu. ");
INSERT INTO syll_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Amar roar gor ar mal-samanar befare ami tumare zela nomuna deḳaimu, ekkere ou laḳan ḳori hoḳolta tiar ḳoraio. ");
INSERT INTO syll_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Tara babla laḳṛi dia egu shonduk banaiba. Iṭa lambae aṛai at, deṛ at fash ar deṛ at usa. ");
INSERT INTO syll_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Er bare-bitore ḳaṭi shunadi lefia dio, ar sairo kinaro shunar noksha lagaio. ");
INSERT INTO syll_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Aguindi shuna golaia sairṭa ḳoṛa er sairo kunat lagaio, ogalat duiṭa ar hogalat duiṭa lagaio. ");
INSERT INTO syll_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Babla laḳṛidi dugu benda banaia shunadi lefia dite oibo. ");
INSERT INTO syll_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Shondukre boia neoar lagi duio galar ḳoṛar mazedi, ou duio benda harani lagbo. ");
INSERT INTO syll_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Benda duioṭa shondukor ḳoṛar bitre harail roibo, iguin kulio na. ");
INSERT INTO syll_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ami amar hukum-ahkam leḳa ze fobitro shahadot fattor tumare dimu, tumi iṭa ou shondukor bitre toio. ");
INSERT INTO syll_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Ḳaṭi shunadi shondukor ekkan ḍaḳna banaio, oḳanor ufre gunar kofora adae ḳora oibo. I ḍaḳna lambae aṛai at ar fashe deṛ at oibo. ");
INSERT INTO syll_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","19","Tumi hou ḍaḳnar kinaro shuna fiṭaia dugu Karubi banaio. Ou Karubi deḳte Duldul guṛar laḳan ḍaḳna ala. Banaia shondukor dui galat lagaio, ogalat eḳṭa, ar hogalat eḳṭa. Duio Karubi ḍaḳnar loge ou laḳan ḳori shunadi banani lagbo, zeṭa astaṭae ḳali eḳ siz oy. ");
INSERT INTO syll_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Er ḍaḳna duioḳan ufredi melail roibo, ar er sayar tole taḳbo shondukor ḍaḳna. Duio Karubi mukamuki uba taḳbo, ar tarar souk roibo ḍaḳnar bae. ");
INSERT INTO syll_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","I ḍaḳnare shondukor ufre lagaio, ar amar hukum-ahkam leḳa ze shahadot fattor tumare dimu, ou fattor tumi shondukor bitre toio. ");
INSERT INTO syll_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","I shahadot shondukor ḍaḳnar ufre duio Karubir mazḳano, ami tumare didar dimu. Ou didaror shomoy Boni Israilor lagi amar hoḳol ain-ḳanun zanaimu. ");
INSERT INTO syll_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Babla laḳṛi dia dui at lamba, eḳ at fash ar deṛ at usa ḳori ekkan ṭebul banaio. ");
INSERT INTO syll_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Oḳanre ḳaṭi shunadi lefia sairo kinaro noksha lagaio. ");
INSERT INTO syll_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Ṭebulor sairo kinaro sair angul usa ḳori eḳ haz dibae, hazor maze shunadi noksha ḳorbae. ");
INSERT INTO syll_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Ṭebulor sairo kunat sairo fayar ufre shunar sairṭa ḳoṛa lagaibae. ");
INSERT INTO syll_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","I sairo ḳoṛain ṭebulor kunar hou usa hazor tole lagaio, zate ṭebul boia neoar bala ḳoṛar bitre benda harail zae. ");
INSERT INTO syll_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Benda duioṭa babla laḳṛidi banaia shunadi lefibae, ou bendadi ṭebul boia nibae. ");
INSERT INTO syll_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Ṭebulor ufror tal-bashon, Allar name ḍalia dibar shorbot-fanir sodgar zog ar mog, hoḳolta ḳaṭi shunadi banani lagbo. ");
INSERT INTO syll_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ou ṭebulor ufre amar samne hamesha fobitro ruṭi raḳbae, i ruṭi zanu shob shomoy toa oy.” ");
INSERT INTO syll_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Mabude Musare ḳoila, “Tumi kaṭi shunadi ekkan serag dani banaibae, serag danir tola ar ḍanḍi kaṭi shuna fiṭaia goṛaibae. Ou ḍanḍi, fulor laḳan fiala, kuṛi ar fafṛi oḳol, serag danir hoḳoltae eḳloge eḳ fis oibo. ");
INSERT INTO syll_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Serag danir ḍanḍir dui galat tinṭa ḳori muṭ soyṭa ḍal taḳbo. ");
INSERT INTO syll_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Forteḳ ḍalor maze zoba fulor laḳan tingu ḳori fiala taḳbo. Serag danir soyo ḍalo eḳlaḳan ḳam ḳora oibo. ");
INSERT INTO syll_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Serag danir mul ḍanḍir maze-o zoba fulor laḳan sairṭa fiala taḳbo. ");
INSERT INTO syll_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Ou mul ḍanḍi taki bar oilo soyṭa ḍalor maze, foyla duio ḍalor zuṛat egu kuṛi, dusra duio ḍalor zuṛat arok kuṛi, ar heshor duio ḍalor zuṛat-o kuṛi dio. ");
INSERT INTO syll_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Kuṛi ar ḍal hoḳolta serag dani taki bar oibo, hoḳolta milia eḳ siz oibo. Astaṭa-u ḳaṭi shuna fiṭaia banani lagbo. ");
INSERT INTO syll_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Erbade shatṭa serag banaia ou serag danir ufre ou laḳan ḳori lagani lagbo, zate serag oḳol zalanir bade serag danir samna for oy. ");
INSERT INTO syll_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Seragor fita saf ḳorar simṭa ar zalail fitar sali toar lagi koygu baṭi, ḳaṭi shunadi banani lagbo. ");
INSERT INTO syll_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Serag danir hoḳolta bananir lagi eḳ mon ḳaṭi shuna lagbo. ");
INSERT INTO syll_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","“Huno, ou faṛor ufre tumare zela noksha deḳail oilo, ekkere ou laḳan ḳori hoḳolta banaio.” ");
INSERT INTO syll_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Mabude Musare ḳoila, “Tumi dosh ṭukra fesail sutar dami suti kafoṛdi amar goror fordain banaio. Ar lilua, baingoni, lal sutadi bala ustadredi er maze Karubi oḳlor sobi bain ḳoraio. ");
INSERT INTO syll_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Hoḳol ṭukrain eḳ mafor oibo, lambae aṭaish at ar faṛe sair at. ");
INSERT INTO syll_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","I ṭukraintor fasḳan fasḳan ḳori ekḳano zuṛa dia, dukan boṛo gilaf banaite oibo. ");
INSERT INTO syll_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Boṛo gilafor foyla ṭukrar fashor ek kinaro lilua sutadi hukor fuṛ banaite oibo. Dusra ṭukrat-o oula ḳorte oibo. ");
INSERT INTO syll_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Foyla gilafor kinaro fonchashgu hukor fuṛ ar dusra gilafo oula fonchashgu fuṛ dite oibo. Duio boṛo gilafor hukor fuṛ egu aregur ulṭamuka taḳbo. ");
INSERT INTO syll_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Bade shunadi fonchashgu huk banaia hou fuṛor mazedi haraia, boṛo duio gilafre aṭḳai dio. Teu i duio ṭukradi ekkan gor tiar oibo. ");
INSERT INTO syll_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Amar goror ufor gurar lagi sagolor ruma dia gilafor laḳan egaroḳan ṭukra banani lagbo. ");
INSERT INTO syll_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Hoḳol ṭukrain eḳ mafor oibo, tish at lamba ar sair at faṛ. ");
INSERT INTO syll_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","On taki fas ṭukra eḳloge zuṛa dia boṛo ek gilaf banaite oibo. Ar baki soy ṭukra zuṛa dia, boṛo arok gilaf banaia harle, ou dusra gilafor ze ṭukra baṛti roibo, oḳanre tambur samnor bae dui bainj ḳori dite oibo. ");
INSERT INTO syll_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Foyla boṛo gilafor fashor ek kinaro fonchashgu hukor fuṛ banaite oibo, ar dusra gilafo-o oula oibo. ");
INSERT INTO syll_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Bade fitol dia fonchashgu huk banaia hou hukor fuṛor maze haraia, ou boṛo duio gilaf ekḳano zuṛa dite oibo. Teu i duio gilaf milia ekkan sani oibo. ");
INSERT INTO syll_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Sagolor rumar boṛo gilafor ze ada ṭukra baṛti oibo, ikan ḳoredi loṭḳail roibo. ");
INSERT INTO syll_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","I gilaf ḳan tolor ḳafoṛ taki eḳ at boṛo oae ikan duio galabae loṭḳail roia hara gorre gurilibo. ");
INSERT INTO syll_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Er ufor gurar lagi lal rong kora meṛar samṛadi aroḳan gilaf banaia guri dite oibo. Bade er ufre doriar fuʼ masor samṛadi sani toiar ḳori guri dite oibo.” ");
INSERT INTO syll_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Mabude Musare ḳoila, “Amar goror lagi babla laḳṛidi koʼḳan freim banani lagbo. ");
INSERT INTO syll_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Forteḳ freim banaibae dosh at lamba ar deṛ at faṛ. ");
INSERT INTO syll_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Ou freimo dugu ḳori faya taḳbo. Hoḳol freim eḳlaḳan banaite oibo. ");
INSERT INTO syll_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Dokkin galar lagi bishḳan freim banani lagbo. ");
INSERT INTO syll_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","I freimor fayar tole deoar lagi sallishgu rufar sungi banani lagbo, forteḳ freimor dui fayar lagi dugu sungi lagbo. ");
INSERT INTO syll_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Amar goror uttor galar lagia-o bishḳan freim lagbo, ");
INSERT INTO syll_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ar forteḳ freimor fayar tolor lagi dugu ḳori sallishgu rufar sungi banani lagbo. ");
INSERT INTO syll_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Foismor galar lagi, mani kor galar lagi soyḳan freim, ");
INSERT INTO syll_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ar ḳoror duio kunar lagi aro dukan freim lagbo. ");
INSERT INTO syll_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","I dui freimre dui kunar duio freimor loge tole-ufre ekḳano zuṛa dite oibo. Fortek kunar dui freim daror freimor loge batti maria eḳloge zuṛa dite oibo. Duio kuna eḳlaḳan oibo. ");
INSERT INTO syll_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Teu ḳoredi aṭḳan freim oibo, ar forteḳ freimor tole deoar lagi dugu ḳori shullogu rufar sungi lagbo. ");
INSERT INTO syll_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Tumi freimre zuṛa dibar lagi babla laḳṛidi koygu lamba batti banaio. ");
INSERT INTO syll_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Er maze fasgu batti goror ek galar lagi, ar baki fasgu arok galar lagi, ar fasgu lagbo ḳor gala, mani fosim galar freimor lagi. ");
INSERT INTO syll_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Freimor mazḳano lagail ou battidi hoḳol freimor eḳ mata taki aroḳ mata forzonto aṭḳaibae. ");
INSERT INTO syll_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Freim ḳanain shunadi lefte oibo, ar batti haranir lagi shunar ḳoṛa banaia freimo lagaite oibo. I batti oḳol-o shunadi lefte oibo. ");
INSERT INTO syll_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Amar goror ze noksha tumare ou Tur faṛor ufre deḳailam, tumi ekkere ou laḳan ḳori iṭa toiar ḳoraio.” ");
INSERT INTO syll_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Mabude Musare ḳoila, “Tumi lilua, lal, baingoni suta ar fesail dami suti kafoṛdi ekkan forda banaio. Bala kunu ustadredi er ufre Karubi oḳlor sobi bain ḳoraio. ");
INSERT INTO syll_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","I fordaḳan babla laḳṛidi sairṭa kuṭir loge lagaia shunar ḳoṛadi loṭḳai dibae, kuṭir matat shunar ḳoṛa lagaibae. Ar kuṭiguin shunadi lefaibae, kuṭir tolat rufar sungi lagaibae. ");
INSERT INTO syll_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Fordar ufror suti kafoṛo lagail hukor loge fordaḳan loṭḳail roibo. I fordar ḳore shahadot shonduk toibae. Fordadi amar goror Herem Shorif, mani kas pak zaga ar pak zagar mazḳano beṛa dio. ");
INSERT INTO syll_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Ou Herem Shorifor bitre shahadot shondukor ufre er ḍaḳna lagaio. ");
INSERT INTO syll_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","I fordar bare Herem Shorifor uttor galat fobitro ruṭi raḳar ṭebulḳan toio, ar er ulṭamuka dokkin galat toio serag dani. ");
INSERT INTO syll_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Amar goror duaror lagi ekkan forda banaio, ikan dami suti kafoṛdi banaia hari, lilua, baingoni, lal rongor sutadi noksha ḳorio. ");
INSERT INTO syll_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","I fordar lagi shunar ḳoṛa ar babla laḳṛir fasṭa kuṭi banaio. Kuṭiguin shunadi lefaio, kuṭir tolat fitolor fasgu sungi lagaio.” ");
INSERT INTO syll_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Mabude Musare ḳoila, “Tumi babla laḳṛidi fas at lamba, fas at fash ar tin at ubi dia sairkuni kori ekkan kurbani kana toiar ḳoraio. ");
INSERT INTO syll_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Er sairo kunar ufre laḳṛidi sairṭa hing dio. Ou hing kunar laḳṛi kudia banani lagbo, i astaḳan eḳ siz oibo. Bade fura kurbani kana fitoldi lefaio. ");
INSERT INTO syll_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Kurbani kanar sali tular boṛo samos ar gamla, lou toar baṭi, gust tular boṛo ḳaṭa-sif, angra toar fatil, hoḳolta fitoldi banaio. ");
INSERT INTO syll_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Fitoldi ekkan zali banaibae. Er sair kunat sairṭa fitolor ḳoṛa lagaio. ");
INSERT INTO syll_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Kurbani kanar tola taki ufror mazamazi zagar taṛiar tole ou zali boaio. ");
INSERT INTO syll_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Kurbani kana boia nibar lagi babla laḳṛidi dugu benda banaio, banaia duiogu fitoldi lefio. ");
INSERT INTO syll_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","I bendain ḳoṛar bitredi harani lagbo. Teu kurbani kana boia neoar bala duio bendain kurbani kanar dui galabae taḳbo. ");
INSERT INTO syll_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Kurbani kana toḳtadi banaia er bitre faḳ rakio. Ami ou faṛor ufre tumare zela noksha deḳailam, ekkere olaḳan ḳori banani loaio. ");
INSERT INTO syll_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Amar goror sairobae uṭan taḳbo. Er dokkin galabae eḳ-sho at rakio, i muka dibae dami suti kafoṛor forda. ");
INSERT INTO syll_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","I forda ṭananir lagi bishgu kuṭi dibae. Kuṭir tolat dibae eḳṭa ḳori fitolor sungi, forda ṭananir lagi rufar ḳoṛa ar bandibar tar lagaibae. ");
INSERT INTO syll_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Uttor galabae eḳ-sho at uṭan raḳbae. Hono-o forda dio, bishgu kuṭi, bishgu fitolor sungi, kuṭir loge lagaio rufar ḳoṛa ar tar. ");
INSERT INTO syll_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Foisme foinchash at uṭan rakio, hono-o ḳoyḳan forda, doshgu kuṭi, fortek kuṭir tolat eḳṭa ḳori sungi dio. ");
INSERT INTO syll_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Fubedi-o foinchash at uṭan rakio; ");
INSERT INTO syll_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","geiṭor ek galat fonro at lamba forda, tinṭa kuṭi ar tinṭa sungi lagaibae, ");
INSERT INTO syll_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","ola dusra galat-o fonro at forda, tinṭa kuṭi ar tinṭa sungi dio. ");
INSERT INTO syll_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Uṭanor geiṭor lagi sairṭa kuṭi, sairṭa sungi ar bish at lamba ekkan forda. Fordaḳan dami suti kafoṛdi banaia lilua, baingoni, lal sutadi noksha ḳoraio. ");
INSERT INTO syll_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Uṭanor sairo galar hokkol kuṭire bandibar tar ar ḳoṛa oibo rufar, er tole fitolor sungi taḳbo. ");
INSERT INTO syll_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Uṭanḳan lambae eḳ-sho at ar fashe foinchash at oibo. Er sairobae fas at ubi forda dio, forda oibo dami suti kafoṛor, ar kuṭintor tole dio fitolor sungi. ");
INSERT INTO syll_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Amar goror ḳamor hoḳol siz fitoldi banaibae, mul tambu ar uṭanor beṛar ṭanar rosir tolor fereg oḳol fitolor oibo. ");
INSERT INTO syll_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Tumi Boni Israil oḳolre hukum dio, tara zoytun sesia tel banaia tumar gese anto, zate serag oḳol hamesha zalail roy. ");
INSERT INTO syll_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Milon-tambur shahadot shondukor samne ze fordaḳan taḳbo, ou fordar bare Harun ar tar fuainte hainja taki fozor forzonto, Mabudor samne serag guin deḳa-huna ḳorba. Amar ou hukum zanu Boni Israile oarishor for oarish dori hor-hamesha amol ḳore.” ");
INSERT INTO syll_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Mabude Musare ḳoila, “O Musa, Boni Israilor maze imamoti korar lagi tumar bai Harun, tar fua Nadab, Abihu, Ali-Azor ar Isamarre tumar samne anao. ");
INSERT INTO syll_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","“Tumar bai Harunor ijjot ar shundor baṛanir lagi fobitro lebas toiar ḳorao. ");
INSERT INTO syll_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ami Pak Ruhu dia zeta ustad oḳolre ḳarigori kamor aḳol-hekmot disi, tumi hou ḳarigor oḳolre hukum deo, tara Harunor lagi oula fobitro lebas banaukka, ze lebas ḳali amar imamotir ḳamo lage. ");
INSERT INTO syll_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","I lebasor maze bukur ufror toli, efron, alḳella, chekor ḳafoṛor fainjabi, faugṛi ar ḳomror bondoni banaio. Tumar bai Harun ar tar fuainte zate amar imamoti kam ḳorta faroin, erlagi tarar fak-fobitro lebas banaio. ");
INSERT INTO syll_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Lebas banaite tara lilua, baingoni, lal suta, ar dami suti kafoṛ, er loge shuna-o lagaiba. ");
INSERT INTO syll_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Fordan imamor efron banaibae lilua, baingoni, lal suta, dami suti kafoṛ, ar shunadi. Ita bala kunu ustadredi banaio. ");
INSERT INTO syll_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Efronor ḳandor dui gala zuṛa dibar lagi dukan foṭṭi banaia, efronor ufror kunat lagaio. ");
INSERT INTO syll_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Efronor loge zuṛa lagail feṭor ufror belṭ ḳan-o efronor laḳan lilua, baingoni, lal suta, dami suti kafoṛ, ar shunadi banaio. ");
INSERT INTO syll_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Tumi duiṭa akik fattor ania er ufre Israil, mani Iakubor fuaintor nam kudaia lekaio. ");
INSERT INTO syll_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Foyla fattoror ufre, tarar zonmor hishabe boṛo taki huru muka soy zonor nam, ar dusra fattoror ufre-o baki soy zonor nam kudaia lekaio. ");
INSERT INTO syll_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Hunar oḳole dami fattoror ufre kudia zela sil banain, ekkere ou laḳan ḳori dugu fattoror ufre Israilor fuaintor nam kudaio. ");
INSERT INTO syll_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Fattor duiogu shunar zazoiror maze lagaia efronor ḳandor foṭṭir loge lagaio. Israilor fuaintor bae Mabudor nozor raḳar lagi, i fattor Harune Mabudor samne tar ḳandor maze lagaibo. ");
INSERT INTO syll_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","14","Duio zazoiror loge shunadi banail duksa chein lagaio. Ou duio chein ḳaṭi shunadi rosir nomunae fesaia banaio. ");
INSERT INTO syll_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Amar ray-foysala zanar lagi bukur ufror toli banaio. Bala ustad kunu dorziredi banaio. Efronor ḳamor laḳan iṭa-o lilua, baingoni, lal suta, dami suti kafoṛ, ar shunadi banaio. ");
INSERT INTO syll_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Iṭa oibo lambae ada at, fashe ada at, sair kuna ala dui bainj ḳora ekkan ḳafoṛ. ");
INSERT INTO syll_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Er ufre hair doraia sair hair fattor lagaibae. Foyla harit iakut, fit, ar fanna moni. ");
INSERT INTO syll_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Dusra harit lal moni, lil moni ar hira; ");
INSERT INTO syll_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","tin nombor harit firuz, gumed ar foddorag moni. ");
INSERT INTO syll_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Sair nombor hairo fukraz, boidurjo ar shuruz moni. I fattor oḳol shunar zazoirdi lagaio. ");
INSERT INTO syll_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Israilor baro fuar lagi baroṭa fattor lagbo. Ita eḳo fattoro eḳ eḳ fuar nam kudia lekaio, zela kudia sil banail oy. ");
INSERT INTO syll_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Bukur ufror tolir lagi kaṭi shunadi rosir laḳan fesaia duksa chein banaio. ");
INSERT INTO syll_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Shunar duiṭa ḳoṛa banaia bukur ou tolir ufror kunat lagaio. ");
INSERT INTO syll_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Ar chein duiogesa duio ḳoṛar loge aṭḳaio. ");
INSERT INTO syll_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Duio ḳandor efronor samnor fitat shunar zazoiror loge cheinor eḳ mata bandio. ");
INSERT INTO syll_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Aro duiṭa shunar ḳoṛa banaia bukur ufror tolir dui kunat lagaio. I duioṭa efronor loge bukur tolir tole roibo. ");
INSERT INTO syll_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Bade aro duiṭa shunar ḳoṛa banaia, efronor ḳandor foṭṭir shoi toledi, feṭor ufror belṭor ufror silair ḳasat lagaio. ");
INSERT INTO syll_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Bade bukur ufror tolir tolor ḳoṛar loge feṭor ufror noksha ḳora belṭor ḳoṛa lilua sutadi bandio. Teu ou toli efronor ufre taki horto nae. ");
INSERT INTO syll_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Pak zagat hamaibar bala Harune amar ray-foysala hunar lagi, bukur ufror tolir ufre leḳa Israilor baro fuar nam lagaite oibo, i toliṭae tarare hor-hamesha Mabudor samne raḳbo. ");
INSERT INTO syll_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Amar ray-foysalar ou tolir bitre Urim ar Tummim namor fobitro fattorguin rakio. Harun zebla Mabudor samne azir oibo, ou shomoy ita tar bukur ufre roibo. Harune Boni Israilor lagi amar ray-foysala zanar ufae hishabe hor-hamesha tar bukur ufre Mabudor deoa ou siz raḳbo.” ");
INSERT INTO syll_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Mabude Musare ḳoila, “Efronor tole lamba ze alḳella roibo, ikṭa furaṭa-u lilua rongor sutadi banaio. ");
INSERT INTO syll_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Mata haraibar lagi er mazḳano faḳ rakio. I faḳ zaga zate na siṛe, erlagi er sairo gala mozbut ḳori bain ḳorte oibo. ");
INSERT INTO syll_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Lilua, baingoni, lal rongor sutadi anuar folor laḳan banaia, ou alḳellar tolor muṛir sairobae lagaio. Ar itar maze maze dio shunar gungur. ");
INSERT INTO syll_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","I muṛit dibae egu ḳori anuar ar egu gungur. ");
INSERT INTO syll_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Imamoti korar bala Harune i lebas findibo. He zebla pak zagat Mabudor samne azir oibo, ar hon taki bare bar oibo, ou shomoy ou gungur oḳlor aoaz huna zaibo, teu he morto nae. ");
INSERT INTO syll_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Ḳaṭi shunadi ekkan fat banaia er ufre silor laḳan kudia ou ayat lekaio, ‘Mabudor name fak-fobitro.’ ");
INSERT INTO syll_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","I fatḳan faugṛir samnor galat lagaia lilua sutadi bandio. ");
INSERT INTO syll_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Iṭa Harunor ḳofalor ufre roibo. Zoto fak-fobitro mal Boni Israile dan-ḳoyrat loia aiba, itar hoḳol nomunar dush-tiruṭir bar Harune boibo. Mabude zate tarare kobul ḳoroin, erlagi Harune ḳofalor ufre i shunar fatḳan hamesha lagaia raḳbo. ");
INSERT INTO syll_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Imamor fainjabi ar faugṛi toiar ḳoraio chekor dami suti kafoṛdi. Ḳomror bondoni kan sui-sutadi noksha ḳori banaio. ");
INSERT INTO syll_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Harunor fuaintor ijjot ar shundoror lagi fainjabi, toki ar ḳomror bondoni toiar ḳoraio. ");
INSERT INTO syll_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Tumi tumar bai Harun ar tar fuaintore i kafoṛ findaio. Tarar matat fobitro tel ḍalia ḳelafoti shomzaia imamoti kamo lagaio. Tumi tarare fak-fobitro ḳorio, zate tara amar imam oita faroin. ");
INSERT INTO syll_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Ḳomor taki urat forzonto shoromor zaga gurar lagi suti kafoṛdi haf-penṭor laḳan zangia banaio. ");
INSERT INTO syll_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Harun ar tar fuain zebla Milon-tambut hamaiba, ba kurbani kanar gese pak zagat hamaia imamotir ḳamo lagba, ou shomoy tara ou zangia finba. Teu tara ni-oforadi roiba, morta nae. Harun ar tar oarishor silsilar lagi i ain hor-hamesha salu roibo.” ");
INSERT INTO syll_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Mabude Musare ḳoila, “Tumi imam oḳolre ou laḳan fak-saf ḳorio, zate imam bonia tara amar ebadot ḳam salaita faroin. Tumi nikut egu bisal ar dugu meṛar faṭa anaio. ");
INSERT INTO syll_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Erloge moydadi ruṭi, teldi baza fiṭa, ar tel maḳail safaṭi banaio. Ita kuntat-u ḳamir mishaio na. ");
INSERT INTO syll_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Ota banaia eḳ ṭukrit loio, erloge hou bisal ar duio meṛar faṭa loia amar samne aio. ");
INSERT INTO syll_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Bade Harun ar tar fuaintore Milon-tambur duaror ḳasat ania, fanidi naoai dio. ");
INSERT INTO syll_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Ar hou fobitro lebas oḳol ania Harunre findaio. Fainjabi, alḳella, efron ar bukur ufror toli hoḳolta findaio. Efronor loge ustadi ator banail hou feṭor ufror belṭ ḳan-o bandia dio. ");
INSERT INTO syll_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Tar matat faugṛi findaio ar shunar fatdi banail fobitro taz ḳan-o lagaio. ");
INSERT INTO syll_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Bade ḳelafotir tel tar matat ḍalia tare ḳelafoti dio. ");
INSERT INTO syll_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Tar fuaintore-o ania fainjabi findaio. ");
INSERT INTO syll_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Harun ar tar fuaintore ḳomror bondoni bandia dio. Fuaintor matat dio toki. Ou laḳan Harun ar tar fuaintore imamor fodo boail ḳorio, zate siroḳalin niom hishabe imamotir fod ḳali tarar bongshot taḳe. ");
INSERT INTO syll_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Bade hou bisalre tumi Milon-tambur samne anio, Harun ar tar fuainte ogur ḳolla ataia diba. ");
INSERT INTO syll_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Atanir bade ou bisalre Milon-tambur duaror ḳasat nia Mabudor samne zobo ḳorio. ");
INSERT INTO syll_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Zobo ḳoria harle tuṛa lou tumar angulit lagaia kurbani kanar hingor maze lagaio, ar baki lou kurbani kanar tole ḍali dio. ");
INSERT INTO syll_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Bisalor feṭor bitoror at-boṛor sorbi, ḳoiljar logor maṭia, duio kiḍni ar er sorbi, kurbani kanar ufre nia zalailio. ");
INSERT INTO syll_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Er gust, ḳal, at-boṛ gufor shudda Boni Israilor kempor bare nia zalailio, ita to gunar koforar kurbani. ");
INSERT INTO syll_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Bade hou duio meṛa taki egu meṛa anio, anle Harune ar tar fuainte ogur ḳolla ataia diba. ");
INSERT INTO syll_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Ar ou meṛare zobo ḳoria er lou nia kurbani kanar sairo galat siṭai dio. ");
INSERT INTO syll_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Meṛare ḳaṭia ṭukraia tar ṭeng ar feṭor bitoror hoḳolta doia, ḳolla ar baki ṭukraintor loge toio. ");
INSERT INTO syll_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Heshe i astagu kurbani kanar ufre nia zalailio. Ita oilo Mabudor name zalail kurbani, Mabudor niote agunit deoa geran ala sodga. ");
INSERT INTO syll_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Bade dusra meṛare-o ania Harune ar tar fuainte ḳolla atai diba. ");
INSERT INTO syll_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Atanir bade ogure zobo ḳoria er tuṛa lou nia Harun ar tar fuaintor ḍain ḳanor lotit, ḍain ator ar ḍain faor buṛi angulor maze lagaio. Ar baki lou nia kurbani kanar sairo galabae siṭai dio. ");
INSERT INTO syll_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Bade ḳelafotir tel ar kurbani kana taki tuṛa lou loia, Harun ar tar fuaintor gotro ar lebasor ufre siṭai dio. Teu lebas shudda Harun ar tar fuain fak-saf oiba. ");
INSERT INTO syll_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Tumi ou meṛar sorbi, sorbi ala lenguṛ, feṭor bitoror hoḳoltar ufror sorbi, ḳoiljar logor maṭia, duio kiḍni, er sorbi, ar ḍainor ran nio, iṭa oilo imamoti kamo boailor lagi boḳshia dibar meṛa. ");
INSERT INTO syll_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Bade Mabudor nozoro toa ḳamir saṛa ruṭir ṭukri taki ekkan ruṭi, teldi baza ekkan fiṭa ar tel maḳail safaṭi ekkan loio. ");
INSERT INTO syll_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Loia ita hoḳolta Harun ar tar fuaintor ato dia, Mabudor samne raḳar niote dulona kurbani hishabe dulaibae. ");
INSERT INTO syll_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Ar ota tarar at taki nia, Mabudor samne kurbani kanar ufre, hou zalail kurbanir ufre zalailibae. Iṭa oilo Mabudor name agunit deoa sodga. Itar dumar gerane Mabud kushi oin.” ");
INSERT INTO syll_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Mabude Musare ḳoila, “Tumi Harunre imamotir ḳamo boail ḳorar lagi, ḳelafoti shomzibar meṛar sinar ṭukra loia Mabudor samne dulona kurbani hishabe dulaibae. Iṭa oilo tumar baṭ. ");
INSERT INTO syll_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Harun ar tar fuaintore imamotir ḳamo boailor lagi dulail ou sina ar ran tumi fak-fobitro ḳorio. ");
INSERT INTO syll_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Ou laḳan Boni Israilor deoa ou kurbanir ṭukrain hor-hamesha Harun ar tar fuainte faiba. Ita oibo Mabudor name Boni Israilor deoa salamoti kurbanir eḳṭa ongsho. ");
INSERT INTO syll_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Harunor bebohar ḳora fobitro lebas oḳol tar oarish oḳole faiba. Ou lebas findia tara ḳelafoti faiba ar imamotir ḳamo boail oiba. ");
INSERT INTO syll_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Harunor bade tar ze fua imam oia Milon-tambur pak zagat ḳam ḳorbo, he shatdin forzonto i lebas tar gotro raḳbo. ");
INSERT INTO syll_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Ḳelafoti shomzibar meṛar ou gust ḳanain nia kunu fobitro zagat randibae. ");
INSERT INTO syll_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Harun ar tar fuainte Milon-tambur duaror ḳasat boia, ṭukrit toa hou ruṭir loge ou gust ḳaiba. ");
INSERT INTO syll_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Imamor ḳamo boail ḳorar lagi, tarare fak-saf ḳorar lagi, ḳanir zeta siz oḳol gunar mafir lagi kurbani deoa oibo, ita ḳali Harun ar tar fuainte ḳaiba. Ar ḳeu ita ḳaito farto nae, ḳaron ita oilo fak-fobitro ḳana. ");
INSERT INTO syll_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ou boail ḳorar kurbanir meṛar kunu gust ba ruṭi zudi bian forzonto roizae, te ita zalailite oibo, ḳeu ḳaito farto nae, ita to fak-fobitro. ");
INSERT INTO syll_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Harun ar tar fuaintor lagi, ami tumare zotota ḳorar hukum disi, tumi oula ḳorio. Boail ḳorar ou ḳam tumi shatdin bora ḳorio. ");
INSERT INTO syll_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Gunar kofora hishabe tumi forteḳ din egu ḳori bisal kurbani dibae. Ar kurbani kanare fak-fobitro ḳorar lagi-o ou laḳan kurbani dio, ar fak-saf oar lagi fobitro tel ḍalio. ");
INSERT INTO syll_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Kurbani kanare fak-fobitro ḳorar lagi shatdin bora kurbani dia, guna mafir kofora adae ḳoria fak-fobitro ḳorio. Teu i kurbani kana eḳ moha-fobitro zaga oibo. Zekunu zinish i kurbani kanat soaile, ita fak-fobitro oizibo. ");
INSERT INTO syll_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Er bad taki forteḳ din i kurbani kanar ufre, eḳ boros boyoshor dugu meṛa-baichcha kurbani dibae, ");
INSERT INTO syll_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","egu biane ar egu hainja bala. ");
INSERT INTO syll_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Foyla meṛa-baichchar loge dui sher moyda ar eḳ sher zoytunor fisha tel mishaite oibo. Ar shorbot-fanir sodgar lagi anguror eḳ sher shorbot-o Allar name dibae. ");
INSERT INTO syll_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Hainja bala ze meṛa kurbani dibae, erloge-o biankur laḳan dan-gomor sodga ar shorbot-fanir sodgar hoḳolta dite oibo. Ita oilo Mabudor niote agunit deoa geran ala kurbani. ");
INSERT INTO syll_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Oarishor for oarish dori Milon-tambur duaror gese, mani amar samne forteḳ din i zalail kurbani dite oibo. Hono ami tumrare didar dimu, tumar loge batchit ḳormu. ");
INSERT INTO syll_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Boni Israilor gese ami hono didar dimu, ar amar kudrote ou zaga fak-fobitro oibo. ");
INSERT INTO syll_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Ami Milon-tambu ar kurbani kana fobitro ḳormu. Amar imamotir lagi Harun ar tar fuaintore-o ami fobitro ḳormu. ");
INSERT INTO syll_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ami Boni Israilor Mabud oia tarar maze boshot ḳormu. ");
INSERT INTO syll_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Teu tara zanba, ami Alla-u tarar Mabud. Ami tarar loge boshot ḳorar lagi-u to tarare Mishor desh taki bar ḳoria anchi. Ami Alla-u tarar Mabud.” ");
INSERT INTO syll_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Mabude Musare ḳoila, “Agor-kushboy zalaibar lagi tumi babla laḳṛidi ekkan ṭebul banaio. ");
INSERT INTO syll_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Igu oibo sairkuna ala, eḳ at lamba, eḳ at fash, dui at ubi. Asta ḳan-u hing shudda ekḳano lagail roibo. ");
INSERT INTO syll_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Er ufror sani, sanir sairo kinara ar hing, hoḳolta ḳaṭi shunadi lefibae. Sairo kinaro shunar noksha ḳoraibae. ");
INSERT INTO syll_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Er dui kinaror nokshar tole dugu ḳori shunar ḳoṛa lagaio. I koṛar bitre benda haraia ogu boia neoa oibo. ");
INSERT INTO syll_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","I benda guin babla laḳṛidi banaia shunadi lefaio. ");
INSERT INTO syll_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Shahadot shondukor ḍaḳnar ḳasat ze fordaḳan ase, ou ṭebul er samne rakio. Ou zagat ami tumare didar dimu. ");
INSERT INTO syll_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Forteḳ din biane serag guin zuit-zait ḳorar bala, Harune ou ṭebulor ufre kushboy-ala agor zalaibo. ");
INSERT INTO syll_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Hainja bala serag zalanir shomoy, he hirbar agor-kushboy zalaibo. Tumrar oarishor for oarish dori Mabudor samne hor-hamesha ou agor-kushboy zolbo. ");
INSERT INTO syll_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","I agor-kushboy zalanir ṭebulor ufre dusra kunuzator kushboy zalaio na. Kunu zalail kurbani, dan-gomor sodga, ba shorbot-fanir sodga dio na. ");
INSERT INTO syll_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Gunar mafir kofora hishabe, Harune bosoro eḳbar gunar koforar kurbanir lou, ṭebulor hing oḳlor ufre lagaite oibo. Teu ikan Mabudor name moha-fobitro oibo. Oarishor for oarish dori fordan imame bosoro eḳbar ou laḳan ḳorte oibo.” ");
INSERT INTO syll_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Bade Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Tumi zebla Boni Israilor manshor foriman gonbae, ou shomoy tara hoḳole-u zarzir zanor bodla rufa dite oibo, zate i gonar lagi tarar ufre kunu gozob na ae. ");
INSERT INTO syll_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Tarare gonar bala oula bodla loio, gona oise dolo zera hamaiba, era ebadot ḳanar mafe ada tola rufa diba. Forteḳ bish rotie eḳ tola gonio. I rufa oibo Mabudor. ");
INSERT INTO syll_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Bish boros ba er beshi boyoshor zekunu zon gona shesh oa dolo hamaile, en zanor bodla Mabudre ou rufa diba. ");
INSERT INTO syll_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Zanor bodla deoar shomoy doni oḳole ou ada tolar beshi dita farta nae, ar goribe-o ḳom dile oito nae. ");
INSERT INTO syll_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Tumi Boni Israilor ges taki zanor bodla ou rufa nia, amar goror ḳamo lagaio. Tumrar zanor bodla i rufae, Boni Israil oḳolre Mabudor dorbaro iad ḳorai dibo.” ");
INSERT INTO syll_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Uzu ḳorar lagi tumi fitolor eḳṭa gamla, ar gamla toar lagi fitolor ekkan soki-kaṭ banaio. Milon-tambu ar kurbani kanar mazḳano fani boria ogu toio. ");
INSERT INTO syll_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","I fanidi Harun ar tar fuainte uzu ḳorba. ");
INSERT INTO syll_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Tara zate na moroin, erlagi forteḳbar Milon-tambut hamaibar bala ou fanidi uzu ḳorte oibo. Imam hishabe Mabudor name agunit deoa zekunu kurbani adae ḳorar shomoy-o uzu ḳorte oibo. ");
INSERT INTO syll_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Tara zane basia roar lagi ou uzu ḳorba. I hukum tarar lagi hor-hamesha salu roibo, oarishor for oarish dori boail roibo.” ");
INSERT INTO syll_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Tumar nizor gese kushboydar bala bala moshla oḳol dola ḳoro. Tumi fas-sho tola mura namor ator, aṛai-sho tola kushboy-ala ḍailchini, ar aṛai-sho tola bos, ");
INSERT INTO syll_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","shadaron ḍailchini fas-sho tola, ar zoytunor tel sair sher dola ḳorio. I maf oilo ebadot ḳanar mafe. ");
INSERT INTO syll_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Ou moshla oḳol dia agor-kushboy moshla bananir ḳarigoror niome tumi kelafoti shomzibar tel banaio, i tel to fobitro. ");
INSERT INTO syll_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Ou tel dia tumi Milon-tambu, shahadot shonduk, ");
INSERT INTO syll_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ṭebul, ṭebulor ufror hoḳol samana, serag danir hoḳolta, ar agor-kushboy zalanir ṭebul, ");
INSERT INTO syll_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","kurbani kana ar er mazor hoḳol samana, uzur gamla ar er tolor soki-kaṭ hoḳoltare fusia fak-fobitro ḳorio. ");
INSERT INTO syll_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Teu i hoḳolta moha-fobitro samana oibo. Ita samana ḳeu soile, he-o moha-fobitro oizibo. ");
INSERT INTO syll_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Tumi Harunre ar tar fuainre amar imamotir ḳamor lagi kelafotir tel dia fak-fobitro ḳorio. ");
INSERT INTO syll_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Ar Boni Israilre zanai dio, oarishor for oarish dori iṭa-u oibo amar ḳelafoti shomzibar fobitro tel. ");
INSERT INTO syll_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","I tel manshor gotro deoa zaito nae. I niome tara zate ar kunu tel na banae. I tel to fobitro. Tumra iṭare fak-fobitro mono ḳoria ijjot ḳorte oibo. ");
INSERT INTO syll_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ḳeu zudi i laḳan tel toiar ḳore, ba imam sab saṛa ar ḳeu i tel gotro maḳe, te tare nizor zati taki fusilibae.” ");
INSERT INTO syll_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Mabude Musare ḳoila, “Tumi nizor gese kisu kushboy-ala moshla: guggulu, noki, kunduru ar ḳaṭi loban dola ḳorio. Dola ḳoria ota homan homan ḳori mishaio. ");
INSERT INTO syll_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Ar zera agor-kushboy banain, tararedi ou ḳam ḳoraio. Itar loge nun mishaio, ita oibo nirbezal ḳaṭi fak-fobitro agor. ");
INSERT INTO syll_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Ou agoror tuṛa guṛa nia Milon-tambur shahadot shondukor samne toio. Hono ami tumare didar dimu. Tumra i agorre moha-fobitro samana mono ḳorio. ");
INSERT INTO syll_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Ou moshla dia i niome ḳeu zate tar nizor lagi kunu agor-kushboy na banae. Ita to Mabudor name fak-fobitro siz, ikan kial rakio. ");
INSERT INTO syll_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Kushboydar siz mono ḳoria ḳeu zudi ita toiar ḳorilae, te tare i zati taki fusilibae.” ");
INSERT INTO syll_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Huno, ami Ehuda gusṭir Huror nati, Urir fua Batselolre fosond ḳorsi. ");
INSERT INTO syll_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Ami tare Allai ruhu dia kamil ḳorsi. Hoḳol laḳan ḳarigori kamor aḳol-buddi, biddae ustadi kamor ḳemota disi. ");
INSERT INTO syll_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Erlagi he shuna, rufa, fitolor ufre shundor shundor noksha banaito farbo. ");
INSERT INTO syll_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Dami dami fattor ḳaṭia moni-mukta lagani, laḳṛir ufre nokshar ḳam ar hoḳol zator ator ḳam ḳorto farbo. ");
INSERT INTO syll_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Tar zugali hishabe ami Dan gusṭir Ohisamaḳor fua Aholiabre fosond ḳorsi. Ze ustad oḳole i kam ḳorta farba, ami tarare ḳamor aḳol disi, zate tumare batail amar hukum mafik, ita hoḳolta tara banaita faroin. ");
INSERT INTO syll_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Tara banaiba, Milon-tambu, shahadot shonduk, er ufror ḍaḳna, tambur hoḳol mal-samana, ");
INSERT INTO syll_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ṭebul, ṭebulor logor siz oḳol, ḳaṭi shunar serag dani, serag danir logor hoḳolta ar agor-kushboy zalanir ṭebul, ");
INSERT INTO syll_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","kurbani kana ar er hoḳol mal-samana, hanḍi-bashon, uzur fanir gamla ar er soki-kaṭ, ");
INSERT INTO syll_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","imamoti kamor lagi Harunor imamotir lebas ar tar fuaintor lebas, ");
INSERT INTO syll_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ḳelafotir tel, pak zagar lagi kushboy-ala agor. Ami tumare zela hukum disi, ekkere ou laḳan tara banaiba.” ");
INSERT INTO syll_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Tumi nize Boni Israilre ḳo, tumra amar deoa forteḳ Zummabar manio. I Zummabar oarishor for oarish dori tumra ar amar maze eḳ nishana oibo, zate tumra buzbae, ami-u Mabud, ar ami tumrare amar fobitro bonda oar lagi alada ḳorsi. ");
INSERT INTO syll_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“Tumra Zummabar manio, ou dinre tumrar lagi pak din ḳora oise. Ḳeu zudi i din na mane, te tare marilite oibo. Ze manshe idin kunuzat ḳam ḳorbo, tare tar zatir maz taki fusilibae. ");
INSERT INTO syll_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Tumra haftar soydin ḳam ḳorio, oile shat nombor din Mabudor name aramor din, Zummabar. Shukrobar shuruz ḍuba taki Shonibar shuruz ḍubar ag forzonto Zummabar. I din ze manshe ḳam ḳorbo, tare marilibae. ");
INSERT INTO syll_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Boni Israil oḳole amar deoa siroḳalin niom hishabe, oarishor for oarish dori hor-hamesha i Zummabar mante oibo. ");
INSERT INTO syll_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","I Zummabar to Boni Israil ar amar maze hameshakur lagi siroḳalin eḳ nishana. Ḳaron soydine Mabude asman-zomin hoḳolta foyda ḳorla, oile shat nombor din kunu ḳam na ḳoria ziraila.” ");
INSERT INTO syll_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Mabude Tur faṛor ufre Hozrot Musar loge ou batchit shesh ḳoria harle, Musar ato dui ṭukra shahadot fattor dila. Ou fattoror maze Alla Pake tan nizor ate tan hukum-ahkam leḳsoin. ");
INSERT INTO syll_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Musa nobi faṛ taki lamia aite deri or dekia, manshe aia Harunor sairobae dola oia ḳoila, “Amrare fot sinaia neoar lagi, afne amrare devta banai deukka. Ḳaron, ze Musae amrare Mishor taki bar ḳori anche, tar kita goṭse amra to zani na.” ");
INSERT INTO syll_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ikan hunia Harune tarare ḳoila, “Tumra zarzir bou ar fua-fuṛintor ḳano taki shunar goyna kulia amar gese ano.” ");
INSERT INTO syll_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Teu hoḳole tarar ḳanor goyna kulia Harunor gese ania dilo. ");
INSERT INTO syll_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Manshe zeta shuna ania dila, Harune ota nia aguindi golaia, hunaror atiardi eḳ basuror murti banaila. Ogu dekia Boni Israile ḳoila, “Bai oḳol, ou ein-u tumrar devta, zein tumrare Mishor desh taki bar ḳori anchoin.” ");
INSERT INTO syll_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","I halot dekia Harune hou basuror samne eḳ boli kana banaia zanai dila, “Samnor ḳail Mabudor name kushi-bashi kora oibo.” ");
INSERT INTO syll_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Teu bador din kub sobre uṭia manshe devtar samne aia mongol boli ar foshu zalaia boli dila. Bade tara ḳaoa-daoa ḳoria hari, hoi-hulla ḳori nas-gan, furti-amud ḳorat lagla. ");
INSERT INTO syll_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Ou Mabude Musare ḳoila, “Tumi faṛor lamat zao. Tumar ou zeta manshore Mishor desh taki bar ḳori ancho, ita to naforman bonigese. ");
INSERT INTO syll_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Ami tarare zela solar hukum dislam, tara ita bad dia nizor lagi eḳ basuror murti banaia, maṭit foṛia ogure fornam ḳorer. Ogur name tara foshu boli der ar ḳor, bai oḳol, ou ein-u tumrar devta, zein tumrare Mishor desh taki bar ḳori anchoin.” ");
INSERT INTO syll_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Mabude Musare ḳoila, “Ami ita manshore sini, ita to gaṛteṛa-ekguia zat. ");
INSERT INTO syll_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Oḳon tumi amare bada dio na, itar ufre amar gusa aguinor laḳan dau dau ḳori zoler, ami itare sarḳar ḳorilimu. Bade ami tumar maz taki eḳ moha zati foyda ḳormu.” ");
INSERT INTO syll_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Teu Musae tan Mabud Allare minot-ḳajji koria ḳoila, “O Mabud, tumi tumar kudroti at dia tumar moha kudroti bole zetare Mishor taki bar ḳori ancho, tarar ufre tumi kene oto gusa oilae? ");
INSERT INTO syll_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Mishori oḳole ḳene ikan matar shuzug faita, faṛia elaḳat ania tarare ḳotom ḳoria, dunia taki tarar nam miṭailibar lagi tumi tarare Mishor taki bar ḳoria ancho? Mabud go, tumar i betaya gusaḳan tumi tamailao. Meherbani kori, tumar bonda oḳlor ufre i gozobḳan anio na. ");
INSERT INTO syll_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Tumar afon gulam Ibrahim, Isʼhak ar Iakubor ḳota iad ḳoro. Tumi nizor name ḳosom ḳaia tarare ḳoislae, tarar oarish oḳolre tumi asmanor terar laḳan baṛaibae, ar tumar oada ḳora ou asta deshor malikana-o tarare dibae, ar tara hor-hameshakur lagi er doḳol faiba.” ");
INSERT INTO syll_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ikan hunia Mabudor meherbani oilo. Tain tan bonda oḳlor ufre ze gozob ḍalita saisla, ita bad dilaila. ");
INSERT INTO syll_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Erbade Musae Allar deoa duioḳan shahadot fattor loia lamat aila. I fattoror ulṭa-baṭiol duio galat leḳa asil. ");
INSERT INTO syll_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","I duio fattor oilo Alla Pakor nizor ator ḳam, ar i fattoror ufre kudia leḳa ḳano tan nizor ator leḳa. ");
INSERT INTO syll_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Musar ḳadim Iusae manshor ita hoi-hulla hunia Musare ḳoila, “Sab, amrar kempor maze zuddor aoaz huna zar.” ");
INSERT INTO syll_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Musae ḳoila, “Ita to kunu zuddor ara-zitar aoaz nae. Ami zeta huniar, ita to ganor aoazor laḳan lager.” ");
INSERT INTO syll_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Bade Musae kempor ḳasat aia manshor nasa-nasi ar basuror murti deḳla. Dekia-u tain gusae aguin oia, ator fattor duioḳan iṭa mari falai dila. Teu fattor duioḳan faṛor tole foṛia surmar oigelo. ");
INSERT INTO syll_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ar Musae tarar banail basuror murti nia agunit falaia zalailila. Bade ogure fishia guṛa banaia fanit mishaia, Boni Israil oḳolre ḳaoai dila. ");
INSERT INTO syll_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Tain Harunre ḳoila, “Ita manshe tumare kita ḳorsil, tumi kene tararedi shiriki kam ḳorailae?” ");
INSERT INTO syll_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Harune zuaf dila, “Malik, afne gusa ḳoroin na zanu, afne to zanoin-u, ita manush ḳali karaf ḳamor ashik. ");
INSERT INTO syll_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Tara aia amare ḳoila, amrare fot sinaia loia zaoar lagi devta banai deukka, ḳaron ze Musae amrare Mishor taki bar ḳori anchoin, en kita oise, amra to zaniar na. ");
INSERT INTO syll_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ikan hunia ami tarare ḳoilam, tumrar gese zeta shuna-dana ase, ota kulia amar gese ano. Tara ania amar ato dila, ar ami oḳnain iṭa mari agunit falailam, teu ou basur ogu bar oia ailo.” ");
INSERT INTO syll_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musae deḳla, i manush guin beforua oigesoin. Tain buzla, Harune tarare beforua oar shuzug disoin. Erlagi dushmon oḳole ashibar shuzug faisoin. ");
INSERT INTO syll_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Ou Musae kempor geiṭor gese ubaia ḳoila, “Tumra zoto zon Mabudor fokke aso, hoḳol amar ḳasat ao.” Teu Lebi gusṭir hoḳol manush tan gese ailo. ");
INSERT INTO syll_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Aia harle Musae tarare ḳoila, “Mabud, zein Boni Israilor Alla, tain nize hukum ḳorsoin, tumra hoḳole zarzir ḳomro toluar bando, ar kempor bitre zare samne fao zane maro. Asta kempor bitre bai-bondu, ari-fori zare fao maro.” ");
INSERT INTO syll_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Teu Lebi gusṭir manshe Musar hukum mafik kam ḳorla. Hi din onuman tin azar manush mara gela. ");
INSERT INTO syll_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Bade Musae ḳoila, “Tumra aiz Mabudor name zarzir fua ar bai-biradoror ufre at tulte ḳoredi geso na, Mabudor ḳamor lagi tumra alada oiso, erlagi Mabude tumrare rohomot disoin.” ");
INSERT INTO syll_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Bador din Musae manshore ḳoila, “Tumra to bezuita guna ḳorso. Te ami oḳon hirbar Tur faṛo Mabudor dorbaro zairam, farle tumrar guna mafir koforar kunu fot bar ḳormu.” ");
INSERT INTO syll_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Musae Mabudor dorbaro gia aroz ḳorla, “O Mabud, i manush guinte bezuita guna ḳorilise. Tara nizor lagi shunar murti banaise. ");
INSERT INTO syll_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Te tumi meherbani koria tarar gunare oḳon maf ḳori dilao, ar zudi maf na ḳoro, taile tumar leḳa ḳata taki amar namḳano ḳaṭilao.” ");
INSERT INTO syll_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Mabude zuaf dila, “Huno, amar birudde zera guna ḳorse, ami kali tarar namre-u amar ḳata taki fusilimu. ");
INSERT INTO syll_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Te tumi oḳon zaogi, ar ami ze deshor ḳota ḳoisi, tumi tarare loia hou desho roana dilao. Amar firistae tumrare fot deḳaia niba. Bade zebla shaza deoar shomoy aibo, ou shomoy ami tarar gunar shaza dimu.” ");
INSERT INTO syll_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Harunor ate banail hou basuror murtir lagi manshe zeta ḳorsila, otar lagi Mabude tarar ufre gozob nazil ḳorla. ");
INSERT INTO syll_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Mabude Musare ḳoila, “Zao, tumi ou zerare Mishor taki ancho, erare loia oḳon-u i zaga saṛia zaogi. Amar oada ḳora hou desho zao. Ami Ibrahim, Isʼhak ar Iakubor gese oada ḳorslam, tarar oarish oḳolre ou desh oḳol dimu, te tumi tarare loia hono zaogi. ");
INSERT INTO syll_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ami tumrar age ḳori eḳzon firista faṭaimu. Ein gia honor Kenani, Amuri, Hiṭṭi, Farizi, Hibbi ar Zibuzi oḳolre ḳedai diba. ");
INSERT INTO syll_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Ita to dud ar mour banḍar-ala desh. Oile ami tumrar loge oia zaitam nae, ḳaron tumra kub gaṛteṛa-ekguia zat, kizanu ami fotor maze-u tumrare nifat ḳorilai.” ");
INSERT INTO syll_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","I bifodor ḳota hunia manshe ḳanda-ḳaṭi lagaila. Tara ḳeu kunuzat goyna-gaṭi finla na. ");
INSERT INTO syll_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Ḳaron Mabude Musare ḳoisla, “Tumi Boni Israil oḳolre ḳo, tumra oilae gaṛteṛa-ekguia zat. Ami eḳ foloḳor lagi gele-o tumrare nifat ḳorilimu. Tumrar gotro taki hoḳol goyna-gaṭi kulilao, teu ami buzmu, tumrar lagi kita ḳortam.” ");
INSERT INTO syll_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Teu Boni Israile Tur faṛo-u tarar goyna-gaṭi hoḳolta kulilila, ita ar finla na. ");
INSERT INTO syll_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Hozrot Musar eḳ tambu asil, tain Boni Israilor kempor bare duroi nia ou tambu fatita, i tambure tain ḳaneka-tambu ḳoia ḍakita. Mabudor ges taki keu kunta zante saile tara ou ḳaneḳar gese zaita. ");
INSERT INTO syll_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Musa zebla hi kaneḳa shorifo roana dita, ou shomoy hokkol manush zarzir tambur duaro ubaita ar Musa ḳaneḳat na hamani forzonto hoḳole tan bae sai roito. ");
INSERT INTO syll_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Tain hi kaneḳa shorifo hamanir bade-u Allai megor kuṭi kaneḳar duaror muko lamia aito, ar Mabude zotoboil Musar loge batchit ḳorta, otoboil i kuṭi ono roito. ");
INSERT INTO syll_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Manshe zebla-u i megor kuṭire ḳaneḳar duaror gese deḳto, ou shomoy tara zarzir duaror ges taki Mabudre soizda ḳorto. ");
INSERT INTO syll_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Kunu manshe tar dustor loge mukamuki boia zela batchit ḳore, Mabude-o Musar loge oula mukamuki batchit ḳorta. Bade Musa kempo firia aita, oile tan ḳadim Nunor fua Iusa namor i zuan, ḳaneḳa shorif taki bar oita na. ");
INSERT INTO syll_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musae Mabudor dorbaro aroz ḳorla, “Mabud, tumi to ḳoirae ami ota manshore loia zaitamgi, oile amar loge ar ḳare dirae, ikan to amare zanailae na. Tumi kali koilae, tumi amare tumar nizor zon mono ḳoro ar amare tumar ḳas mayar nozoro raḳso. ");
INSERT INTO syll_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Te hasau zudi ami tumar mayar nozoro taki, taile tumi kun kiale kita ḳoro, ota amare zanao, zate ami tumare furafur sini ar tumar rohomotor maze roi. Tumi to zano-u, i Israil zati tumar-u proza.” ");
INSERT INTO syll_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Mabude zuaf dila, “Huno, ami nize-u tumar loge oia zaimu ar tumare aram dimu.” ");
INSERT INTO syll_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Ou tain ḳoila, “Tumi zudi amrar loge na zao, te amrare in taki bidae dio na. ");
INSERT INTO syll_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Tumi na gele manshe kila buzba, amar ufre ar tumar i bonda oḳlor ufre tumar rohomot ase? Amra-u zen duniar hoḳol zati taki alada, ikan kila buzba?” ");
INSERT INTO syll_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Mabude Musare ḳoila, “Ṭik ase, tumi zela ḳoilae, ami ola ḳormu. Tumi to amar mayar nozoro aso, tumare amar nizor afon mono ḳori.” ");
INSERT INTO syll_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Teu Musae aroz ḳorla, “Te tumar shan-tozolli amare deḳaona.” ");
INSERT INTO syll_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Mabude ḳoila, “Ami zare kushi doya ḳormu, ar zare kushi rohom ḳormu. Huno, tumar samnedi ami amar hokkol nek surot zair ḳormu. ‘Mabud, zein asoin’ tumar samne ami amar ou nam elan ḳormu. ");
INSERT INTO syll_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Oile amar muk deḳar takkot tumar oito nae. Ḳaron amare dekille kunu adom zat base na. ");
INSERT INTO syll_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Te huno, tumi amar ḳasar ou zaga bae sao, deḳrae ni, fattoror eḳ taḳ ase, ou taḳor ufre tumi ubao. ");
INSERT INTO syll_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Teu tumar samne dia amar shan-tozolli zaoar bala, ami tumare ou fattoror faṭar bitre haraimu. Ami na zaoa forzonto, amar at dia tumare guria raḳmu. ");
INSERT INTO syll_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Bade amar at horaile, tumi amar ḳor gala deḳtae farbae, oile ḳeu amar mukor didar faito nae.” ");
INSERT INTO syll_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Mabude Musare ḳoila, “Agor fattoror laḳan tumi noya dukan fattor tiar ḳoro. Tumi ze dukan bangislae, hi fattoror maze ze hukum leḳa asil, ou hukum oḳol ami hirbar i duio fattoro lekia dimu. ");
INSERT INTO syll_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Fozor bade-u tumi tiar oia Tur faṛor ufre uṭio. Uṭia faṛor matat amar samne azir oio. ");
INSERT INTO syll_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Tumar loge kunu manshore anio na, i faṛor kunuḳano zate kunu manush na ae. Faṛor ḳandat kunu goru-sagol ba meṛa-meṛire raḳte dio na.” ");
INSERT INTO syll_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Teu Musae agor fattoror laḳan dukan fattor banaila, ar Mabudor hukum mafik fozore uṭia fattor duioḳan ato loia Tur faṛor ufre uṭila. ");
INSERT INTO syll_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Ar Mabud-o megor ḳalnir maze lamia aila. Tain Hozrot Musar daro ubaia tan “Mabud, zein asoin” nam elan ḳorla. ");
INSERT INTO syll_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Tain Musar samna dia toshrif nila, ar ou kalam elan ḳori kori gela, “Mabud, zein asoin, rohman ar rohim Alla, tain gusa ḳoroin dir gotie, tan obiram maya-mohobbot ar hok-halalir kunu shima nai. ");
INSERT INTO syll_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Tain azar azar oarish forzonto obiram maya-mohobbot ḳoroin, manshor oinnae-oforad, naformani ar gunar mafi dein, oile dushi zonre shaza-o dein. Baf-dadar naformanir shaza, tarar nati-futi forzonto bortain.” ");
INSERT INTO syll_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Ikan hunia-u Musa nobi loge loge soizdat foṛia ḳoila, ");
INSERT INTO syll_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“O malik, ami zudi tumar dorbaro rohomot fai, te meherbani kori tumi-o amrar log kano solo. Ou zati zudio kub gaṛteṛa-ekguia zat, ta-o tumi amrar guna ar ḳosurire maf ḳoria dilao. Amrare tumar afon proza hishabe kobul ḳorilao.” ");
INSERT INTO syll_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Mabude ḳoila, “Huno, ami eḳ usilla boail ḳoriar, ami tumar hoḳol manshor samne ou laḳan keramoti kam deḳaimu, zeta asta duniar kunu zatir samne kunudin-o ḳora oise na. Tumi ou zeta manshor loge boshot ḳorrae, tara deḳba, ami Mabude tumrar lagi kita ḳoriar, ita dekia tarar zano ḍor hamaibo. ");
INSERT INTO syll_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Ami aiz tumrare zeta hukum dimu, ita kial ḳori amol ḳoro. Ami Amuri, Kenani, Hiṭṭi, Farizi, Hibbi ar Zibuzi oḳolre tumrar samna taki kedai dimu. ");
INSERT INTO syll_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Oile ḳobordar! Tumra ze desho zairae, i deshor manshor loge kunuzat chukti korio na, arnae fando hamaibae. ");
INSERT INTO syll_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Tumra tarar puja-monḍop bangia ṭukra ṭukra ḳorbae, tarar boli kanain bangilibae, ar tarar Ashera-debir nishana kuṭi oḳol ḳaṭia falaibae. ");
INSERT INTO syll_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Tumra kunu deb-debir puja ḳorio na. Ami Alla to la-shorik Mabud, kunu shorik shoijjo ḳori na, amar faona ebadot ami sai-u sai. ");
INSERT INTO syll_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Hou deshor manshor loge kunuzat chukti korio na, arnae tara zebla shiriki kamor niote, tarar deb-debir samne nizore shofia diba, devtar name boli diba, ou shomoy tara tumrare-o daot diba ar tumra gia tarar ou bolir gust ḳaibae. ");
INSERT INTO syll_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Tumrar fuaintor loge tarar fuṛintor bia-shadi dibae, ar ou fuṛinte tarar devtar gese gia shiriki kam ḳorba, tarar loge tumrar fuaintore-o ṭanba. ");
INSERT INTO syll_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Tumra nizor lagi kunuzator murti banaio na. ");
INSERT INTO syll_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Tumra Ḳamir Saṛa Ruṭir Id adae ḳorio. Shat din ḳamir saṛa ruṭi kaio. Abib sandor ṭik kora tariko tumrare zela hukum deoa oise, ou laḳan id adae ḳorio. Mono rakio, ou sando tumra Mishor taki bar oia aislae. ");
INSERT INTO syll_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Tumrar feṭor foyda hoḳol foyla fua amar oibo. Erloge tumrar goru-sagol ba foshur foyla meda baichcha-o amar oibo. ");
INSERT INTO syll_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Ḳali gadintor foyla meda baichchar bodla, amare egu meṛa-baichcha bodla dia ogure ḳalas ḳoria nio. Ḳalas na ḳoraile ogur gordona bangilio. Tumrar hokkol boṛo fuainre ola ḳalas ḳorai nio. “Huno, idor shomoy ḳeu ḳali ate amar ḳasat aio na. ");
INSERT INTO syll_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Haftar soydin tumra ḳam ḳorio, oile shat nombor din ziraio. Ḳet ḳora ar foshol daoar bala-o ziraio. ");
INSERT INTO syll_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Ou tino id tumra manio, Fonchaisha Id, ḳetor foyla daoa gom dia Noya Fosholor Id, ar bosoror hesh masho baganor faḳna fol baṛit ania Ḍera-goror Id adae ḳorio. ");
INSERT INTO syll_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Bosoro tinbar tumrar hoḳol beṭain aia hoj ḳorar niote amar gese azir oio. Mono rakio, ami-u Mabud, Boni Israilor Alla. ");
INSERT INTO syll_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Ami hou deshor hoḳol zatire tumrar samon taki kedai dimu. Tumrar deshor shimana baṛaia boṛo ḳormu. Tumra bosoro tinbar nizor Mabud Allar samne azir oio, teu tumrar zaga-zominor bae ḳeu lalos ḳorto nae. ");
INSERT INTO syll_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Amar namor kurbanir foshur loge tumra ḳamir ala kunta lilla-kurbani dio na. Azadi Idor kurbanir kunuzat ḳani bian forzonto rakio na. ");
INSERT INTO syll_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Tumrar ḳetor daoa foyla fosholor hoḳol taki bala ongsho Alla Mabudor goro loia aio. “Ar huno, sagolor baichchar gust tar maʼr duddi randio na.” ");
INSERT INTO syll_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Bade Mabude Musare ḳoila, “Tumi i kalam oḳol lekia to. Ami ou kalam mafik tumar loge ar Boni Israilor loge amar milonor usilla boail ḳorlam.” ");
INSERT INTO syll_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Ou shomoy Musa nobi sallish din sallish rait Mabudor daro faṛor ufre roila. Tain kunuzat dana-fani kaila na. Mabude hou duio fattoror ufre tan loge milonor usillar ou ayat oḳol, mani shoriotor doshṭa hukum-ahkam lekia dila. ");
INSERT INTO syll_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Teu Musae shahadot fattor duioḳan ato loia Tur faṛ taki lamia aila. Mabudor loge batchit ḳorae Musar mukor surot nurani oigelo, oile Musae ikan ṭer faila na. ");
INSERT INTO syll_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Ou shomoy Harun ar hoḳol Boni Israile Musar nurani surot deḳla, dekia tara ḳasat aite ḍoraigela. ");
INSERT INTO syll_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Oile Musae tarare ḍaḳ dila, teu Harun ar Boni Israilor murobbi oḳol tan gese aila, ar Musae tarar loge mat-ḳota matila. ");
INSERT INTO syll_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Bade hoḳol Boni Israil tan ḳasat aila. Aia harle tain Tur faṛor ufre Mabudor deoa hoḳol hukum-ahkam tarare zanaila. ");
INSERT INTO syll_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Tarar loge mat-ḳota shesh oigele Musae tan nurani sehara lukanir lagi muko forda lagai dila. ");
INSERT INTO syll_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Oile Musae zebla Mabudor loge batchitor lagi kaneḳar bitre tan samne zaita, ou shomoy i forda kulilita. Bade bare aia forda lagaita, ar Allar deoa hukum oḳol Boni Israilre zanaita. ");
INSERT INTO syll_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Hoḳol manshe deḳta Musar muk nurani oigese. Musae tan muk gurilita ar Mabudor samne zaoar ag forzonto tan muk gura roito. ");
INSERT INTO syll_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa nobie Boni Israilor hoḳol gusṭire dola ḳoria ḳoila, “Mabude hukum disoin, tan ou hukum-ahkam amol ḳorar lagi. ");
INSERT INTO syll_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Tumra haftar soydin ḳam ḳorio, oile shat nombor din Mabudor name fak-fobitro din, aramor din, Zummabar. I din ze manshe ḳam ḳorbo, tare marilibae. ");
INSERT INTO syll_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Zummabare tumrar ḳeuror goro aguin zalaio na.” ");
INSERT INTO syll_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Hozrot Musae Boni Israilre ḳoila, “Mabude hukum disoin, ");
INSERT INTO syll_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","tumra zarzir dilor kushi mafik Mabudor name lilla loia ao. Anar shomoy oula siz oḳol lilla anio: shuna, rufa, fitol; ");
INSERT INTO syll_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","lilua, baingoni, lal rongor suta; dami suti kafoṛ ar sagolor ruma; ");
INSERT INTO syll_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","lal rong lagail meṛar samṛa, fuʼr samṛa; babla laḳṛi; ");
INSERT INTO syll_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","serag zalanir lagi zoytunor tel; kelafoti shomzibar telor moshla ar agor-kushboy bananir moshla; ");
INSERT INTO syll_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","imamor efron ar bukur ufror tolit laganir lagi akik moni ar hoḳol nomunar dami fattor. ");
INSERT INTO syll_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Tumrar maze zara bala ustad ḳarigor, tara aia ou hoḳolta banaiba, zela Mabude hukum disoin: ");
INSERT INTO syll_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Allar gor, goror sal, huk, freim, batti, kuṭi, kuṭir tolor sungi; ");
INSERT INTO syll_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","shahadot shonduk, shondukor ḍaḳna, shonduk boia neoar benda; shondukre agla dibar forda; ");
INSERT INTO syll_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","benda shudda ṭebul, ṭebulor ufror hoḳol siz, Mabudor namor fobitro ruṭi; ");
INSERT INTO syll_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","for dibar lagi serag dani, er logor hoḳol siz ar serag oḳol, serag zalanir tel; ");
INSERT INTO syll_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","agor-kushboy zalanir ṭebul, ikan boia neoar benda; kelafotir tel, kushboy-ala agor, Allar goror duaror forda; ");
INSERT INTO syll_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","zalail kurbani dibar kurbani kana; er fitolor zali ar boia neoar benda; kurbani kanar hokkol mal-samana; uzur gamla ar gamla toar soki-kaṭ; ");
INSERT INTO syll_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","uṭanor fordain, kuṭin ar kuṭir tolor sungi; uṭano hamanir geiṭor forda; ");
INSERT INTO syll_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","goror fereg ar doṛi, uṭanor fereg ar doṛi; ");
INSERT INTO syll_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","pak zagat imamoti kamor lagi, imam Harunor fobitro lebas, ar tan fuaintor-o imamotir lebas.” ");
INSERT INTO syll_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Musa nobir boyan bade Boni Israilor hoḳol gusṭi bidae oigela. ");
INSERT INTO syll_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Gia tarar dilor eshki mafik zarzir ichchae Allar Milon-tambu bananir lagi, imam Harunor fak-fobitro lebasor lagi ar ebadot ḳamor lagi hoḳol nomunar mal-samana loia aila. Allar name lilla dibar lagi ota loia tara azir oila. ");
INSERT INTO syll_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Beṭain ba beṭintor maze zarar mone sailo, tara ita dila. Tara zarzir ḳafoṛor fing, ḳanor iaring, angṭi, golar har, ar hoḳol zator shunar goyna ania Mabudor name dulona kurbani hishabe dila. ");
INSERT INTO syll_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Ar zerar gese lilua suta, baingoni, lal suta, dami suti kafoṛ, sagolor ruma, lal rong kora meṛar samṛa, fuʼr samṛa asil, tara ita hoḳolta loia aila. ");
INSERT INTO syll_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Zerar gese rufa ar fitol asil, tara-o ita ania Mabudor name lilla dila. Allar goror ḳamo laganir zuka babla laḳṛi zerar gese asil, tara-o ita loia aila. ");
INSERT INTO syll_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Zeta beṭinte suta bananit ustad, tara nizor ate lilua, baingoni, lal rongor suta, ar dami suti kafoṛ banaia anla. ");
INSERT INTO syll_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ar suta banaora zeta beṭintor dilor maze eshki foyda oilo, tara sagolor ruma dia suta banaila. ");
INSERT INTO syll_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Murobbi oḳole efron ar bukur ufror tolit laganir lagi, akik moni ar dami dami fattor loia aila. ");
INSERT INTO syll_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Serag zalanir tel, ḳelafoti shomzibar tel, agor-kushboy bananir moshla ar zoytunor tel-o anla. ");
INSERT INTO syll_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Mabude Musar mazdi zeta zeta ḳorar hukum disla, ita fura ḳorar lagi Boni Israilor hoḳol beṭain-beṭinte, zarzir kushi mafik lilla loia azir oilo. ");
INSERT INTO syll_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Bade Musae hoḳol Boni Israilre ḳoila, “Mabude Ehuda gusṭir Huror nati, Urir fua Batselolre fosond ḳorsoin. ");
INSERT INTO syll_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Tain ere nizor ruhu mubarok dia kamil banaia, hoḳol laḳan ḳarigori kamor aḳol-buddi, biddae ustadi kamor ḳemota disoin. ");
INSERT INTO syll_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Erlagi ein ḳarigori kam ḳorar bala nizor aḳol ḳaṭaia shuna, rufa, fitolor ufre shundor shundor noksha banaita farba. ");
INSERT INTO syll_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Dami dami fattor ḳaṭa, laḳṛir ufre noksha, ar hoḳol nomunar ator ḳam ḳorta farba. ");
INSERT INTO syll_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ar oinno manshore-o ita ḳam hikanir lagi Batselol ar Dan gusṭir Ohisamaḳor fua Aholiabor dilo Mabude aḳol disoin. ");
INSERT INTO syll_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Tain erare nanan zator nokshar ḳam, lilua, baingoni, lal sutadi kafoṛ bain ḳora, noksha ḳora, silai kora, ar dami suti kafoṛ silai korar-o aḳol disoin. Tara hoḳol nomunar ator ḳam ḳorta farba, ar nizor mon taki nanan nomunar noksha banaita farba.” ");
INSERT INTO syll_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Musa nobie eoḳan ḳoila, “Mabude Batselol, Aholiab ar oinno ḳarigor oḳolre aḳol-buddi dan ḳorla, zate tara fobitro ebadot ḳanar hoḳol ḳam-ḳaz ḳorta faroin. Mabude zela hukum ḳorsoin, ou laḳan tara zanu ebadot ḳanar hoḳolta banain ar hazain.” ");
INSERT INTO syll_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Ou ḳam ḳoranir lagi Musae Batselol ar Aholiabre anaila. Mabude zeta ustad ḳarigor oḳolre aḳol-hekmot disoin, ar i kam ḳorar lagi zerar dilo ḳaish foyda oise, Musae tarare-o anaila. ");
INSERT INTO syll_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Tara aia fobitro ebadot ḳana bananir lagi, Boni Israilor deoa lillar hoḳol mal-samana Musar ges taki shomzia nila. Manshe kushi oia nizor ichchae forteḳ din biane aro siz oḳol ania ono lilla dita. ");
INSERT INTO syll_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Ze ustad ḳarigor oḳol ebadot ḳanar ḳamo asla, tara ita dekia, nizor ḳam toia aia Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","“Mabude zeta zeta bananir hukum disoin, ita bananir lagi manshe dorḳar taki aro beshi mal-samana loia aira.” ");
INSERT INTO syll_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Teu Musar hukume manshe hoḳol Boni Israilre zanai dila, ebadot ḳana bananir lagi, ḳeu zanu ar kunu mal-samana lilla na dein. Ougi manshe lilla deoa bond ḳorla. ");
INSERT INTO syll_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Ḳaron ebadot ḳanar ḳamor lagi dorḳar taki aro beshi siz zugaṛ oigesil. ");
INSERT INTO syll_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Bade ḳam ḳorra ustad oḳole fesail sutar dami suti kafoṛ, lilua, baingoni, ar lal sutadi banail dosh ṭukra ḳafoṛ dia Allar goror forda banaila. Ar ustad oḳole er ufre Karubi oḳlor noksha bain ḳorla. ");
INSERT INTO syll_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Forteḳ ṭukrain eḳ mafor asil, lambae aṭaish at ar fashe sair at. ");
INSERT INTO syll_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Bade fasḳan fasḳan ḳori ekḳano zuṛa dia boṛo ḳori dukan gilaf banaila. ");
INSERT INTO syll_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ar duio gilafor fashor ek kinaro, lilua sutadi hukor fuṛ deoa oilo. ");
INSERT INTO syll_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Oula foyla gilafor kinaro fonchashgu hukor fuṛ ar dusra gilafor kinaro fonchashgu hukor fuṛ lagail oilo. I duio hukor fuṛ egu aregur ulṭamuka ḳora oilo. ");
INSERT INTO syll_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Bade shunadi fonchashgu huk banaia hou hukor fuṛor mazedi haraia, boṛo duio gilafre zuṛa deoa oilo. Teu ekkan gor tiar oilo. ");
INSERT INTO syll_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Allar goror salor lagi sagolor ruma dia gilafor laḳan egaroḳan ṭukra banail oilo. ");
INSERT INTO syll_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Ita fortek kan eḳoi mafor asil, tish at lamba ar sair at fash. ");
INSERT INTO syll_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","On taki fas ṭukra eḳloge zuṛa dia boṛo ek gilaf banaila. Ar baki soy ṭukra zuṛa dia, aroḳan boṛo gilaf banaila. ");
INSERT INTO syll_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Foyla boṛo gilafor fashor ek kinaro fonchashgu hukor fuṛ lagaila, ar dusra gilafo-o oula lagaila. ");
INSERT INTO syll_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Bade fitol dia fonchashgu huk banaia hou hukor fuṛor mazedi haraia, ou boṛo duio gilaf ekḳano zuṛa dila. Teu i duio gilaf milia ekkan sani oilo. ");
INSERT INTO syll_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Lal rong kora meṛar samṛadi er ufror sani banail oilo, bade fuʼr samṛadi aroḳan sani toiar ḳoria er ufre guri deoa oilo. ");
INSERT INTO syll_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Bade babla laḳṛidi koyḳan freim banail oilo. ");
INSERT INTO syll_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Forteḳ freim asil lambae dosh at ar faṛe deṛ at. ");
INSERT INTO syll_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Forteḳ freimo dugu ḳori faya lagaia goror hoḳol freim eḳlaḳan banaila. ");
INSERT INTO syll_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Ou goror dokkin galar lagi bishḳan freim zuit ḳorla. ");
INSERT INTO syll_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","I bisho freimor fayar tole sallishgu rufar sungi lagaila. Forteḳ freimor dui fayar tole dugu sungi lagail oilo. ");
INSERT INTO syll_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Allar goror uttor galar lagia-o bishḳan freim zuit ḳorla. ");
INSERT INTO syll_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","I forteḳ freimor fayar tole sallishgu rufar sungi lagaila. Eḳo freimor tole dugu ḳori sungi lagail oilo. ");
INSERT INTO syll_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ar fosim galar lagi, mani kor galar lagi soyḳan freim banaila. ");
INSERT INTO syll_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Ar ḳoror duio kunat dukan freim lagaila. ");
INSERT INTO syll_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","I duio kunar freimre ḳasar freimor loge tole-ufre zuṛa deoa oilo. Fortek kunar duio freimre daror freimor loge batti maria zuṛa deoa oilo. ");
INSERT INTO syll_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Teu aṭḳan freim ar shullogu rufar sungi laglo, eḳo freimor tole duiṭa ḳori sungi dila. ");
INSERT INTO syll_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Bade freimre zuṛa dibar lagi babla laḳṛidi koygu lamba batti banaila. ");
INSERT INTO syll_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Goror ek galar lagi fasgu batti, arok galar lagi aro fasgu, ar fasgu batti kor gala, mani fosim galar lagi banaila. ");
INSERT INTO syll_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Freimor mazḳano lagail ou battidi hoḳol freimor eḳ mata taki aroḳ mata aṭḳai dila. ");
INSERT INTO syll_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Bade i freim ḳanain shunadi lefila. Ar batti laganir lagi shunar ḳoṛa lagaia, battire-o shunadi lefila. ");
INSERT INTO syll_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ou ustad ḳarigor oḳole dami suti kafoṛdi ekkan forda banaila. Fordar ufre lilua, baingoni, lal suta dia Karubi oḳlor sobi bain ḳorla. ");
INSERT INTO syll_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","I forda ṭananir lagi babla laḳṛidi sairṭa kuṭi banaila, banaia ou kuṭintore-o shunadi lefila, kuṭintor matat shunar ḳoṛa lagaila. Kuṭir tolor lagi rufar sairṭa sungi banail oilo. ");
INSERT INTO syll_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Tambur duaror lagi lilua, baingoni, lal suta ar dami suti kafoṛdi noksha ḳori ekkan forda banaila. ");
INSERT INTO syll_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","I fordar lagi fasṭa ḳoṛa ar fasṭa kuṭi banail oilo. Kuṭir mata ar tol shunadi lefa oilo, kuṭir tolor lagi fitolor fasgu sungi banaila. ");
INSERT INTO syll_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Batselole babla laḳṛidi fobitro shahadot shonduk banaila. Iṭa aṛai at lamba, deṛ at fash ar deṛ at usa. ");
INSERT INTO syll_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Er bare-bitore ḳaṭi shunadi lefila, er sairo kinaro shunar noksha lagaila. ");
INSERT INTO syll_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Aguindi shuna golaia sairṭa shunar ḳoṛa er sairo kunat lagaila, ogalat duiṭa ar hogalat duiṭa lagaila. ");
INSERT INTO syll_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Babla laḳṛidi dugu benda banaia shunadi lefila. ");
INSERT INTO syll_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Shonduk boia neoar lagi i duio benda, shondukor dui galar ḳoṛar bitredi haraila. ");
INSERT INTO syll_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Bade ḳaṭi shunadi shondukor ekkan ḍaḳna banaila, oḳanor ufre gunar kofora adae ḳorar lagi. I ḍaḳna lambae aṛai at, ar fashe deṛ at. ");
INSERT INTO syll_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Shuna fiṭaia ḍaḳnar duio galat duiṭa Karubi banaila. ");
INSERT INTO syll_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Duio Karubi shondukor ḍaḳnar dui kinaro roilo. I duio Karubi ḍaḳnar loge ekḳano ḳori banail oilo, i astaṭa ḳali eḳ siz oilo. ");
INSERT INTO syll_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Karubi deḳte Duldul guṛar laḳan ḍaḳna ala, er duio ḍaḳna ufredi melia deoae, ou ḍaḳnar sayar tole shondukor ḍaḳna hamaigelo. Iṭa mukamuki uba roilo. Ar tarar souk roilo shondukor ḍaḳnar bae. ");
INSERT INTO syll_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Batselole bade babla laḳṛidi dui at lamba, eḳ at fash ar deṛ at usa ḳori ekkan ṭebul banaila. ");
INSERT INTO syll_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Banaia harle ḳaṭi shunadi lefia er sairo kinaro noksha lagaila. ");
INSERT INTO syll_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Ar er sanir sairo kinaro sair angul usa ḳori eḳ haz dila, hazor maze shunadi noksha lagaila. ");
INSERT INTO syll_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ṭebulor sairo kunar fayar ufre shunar sairṭa ḳoṛa lagaila. ");
INSERT INTO syll_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","I sairo ḳoṛain ṭebulor kunar hou usa hazor tole lagani oilo, zate ṭebul boia neoar bala ḳoṛar bitre benda harail zae. ");
INSERT INTO syll_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Ṭebulre boia neoar lagi babla laḳṛidi dugu benda banaia shunadi lefila. ");
INSERT INTO syll_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ṭebulor ufror tal-bashon, Allar name shorbot-fanir sodgar zog ar mog, hoḳolta ḳaṭi shunadi goṛaila. ");
INSERT INTO syll_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Bade ḳaṭi shunadi ekkan serag dani tiar ḳorla. Serag danir tola ar ufror ḍanḍi kaṭi shuna fiṭaia goṛaila. Er ḍanḍi, fulor laḳan fiala, kuṛi ar fafṛi oḳol serag danir loge ekḳano ḳori banaila. ");
INSERT INTO syll_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Serag danir ḍanḍir dui galat tinṭa ḳori muṭ soyṭa ḍal deoa oilo. ");
INSERT INTO syll_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Forteḳ ḍalor maze zoba fulor laḳan tingu ḳori fiala tiar ḳora oilo. Serag danir soyo ḍalo eḳlaḳan ḳam ḳora oilo. ");
INSERT INTO syll_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Serag danir mul ḍanḍir maze-o zoba fulor laḳan sairṭa fiala deoa oilo. ");
INSERT INTO syll_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Ou mul ḍanḍi taki bar oilo soyṭa ḍalor maze, foyla duio ḍalor zuṛat egu ḳori kuṛi, dusra duio ḍalor zuṛat arok kuṛi, ar heshor duio ḍalor zuṛat-o kuṛi lagail oilo. ");
INSERT INTO syll_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Kuṛi ar ḍal hoḳolta serag dani taki bar oilo, hoḳolta milia eḳ siz oilo. Astaṭa-u ḳaṭi shuna fiṭaia banani oilo. ");
INSERT INTO syll_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Ḳaṭi shunadi shatṭa serag, seragor fita saf ḳorar simṭa, zalail fitar sali toar lagi koygu baṭi banail oilo. ");
INSERT INTO syll_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Eḳ mon ḳaṭi shunadi i serag dani, ar logor hoḳolta tiar ḳora oilo. ");
INSERT INTO syll_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Bade babla laḳṛidi sair kuna ala agor-kushboy zalanir ṭebul banail oilo. Eḳ at lamba, eḳ at fash, ar dui at ubi dia i ṭebul banaila. Er sairo kunar sairo hing-o ekḳano ḳori banaila. ");
INSERT INTO syll_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Sani, sanir sairo kinar ar hing, hoḳolta ḳaṭi shunadi lefia sairo kinaro shunar noksha lagaila. ");
INSERT INTO syll_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Er dui kinaror nokshar tole dugu ḳori shunar ḳoṛa lagail oilo, zate er bitre benda haraia boia neoa zae. ");
INSERT INTO syll_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Babla laḳṛidi boia neoar benda banaila, iṭare-o shunadi lefila. ");
INSERT INTO syll_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Bade kushboy-ala moshla bananir ḳarigoror niome ḳelafoti shomzibar fobitro tel ar kushboy-ala ḳaṭi agor tiar ḳorla. ");
INSERT INTO syll_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Zalail kurbanir lagi babla laḳṛidi fas at lamba, fas at fash ar tin at ubi dia sairkuni kori ekkan kurbani kana banaila. ");
INSERT INTO syll_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Er sairo kunar ufre laḳṛidi sairṭa hing dila. Ou hing banaila sanir ufror kunar laḳṛi kudia, erlagi i astaḳan eḳ siz oilo. Bade fura kurbani kana fitoldi lefaila. ");
INSERT INTO syll_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Kurbani kanar sali tular boṛo samos ar sali toar gamla, lou toar baṭi, gust tular boṛo ḳaṭa-sif, angra toar fatil, hoḳolta fitoldi banaila. ");
INSERT INTO syll_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Kurbani kanar lagi fitoldi ekkan zali banaila, banaia i zalire kurbani kanar bitoror mazḳanor sairo galar taṛiar tole lagaila. ");
INSERT INTO syll_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Ar benda haranir lagi zalir sairo kunat sairṭa ḳoṛa lagaila. ");
INSERT INTO syll_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Boia neoar benda banaila babla laḳṛidi, banaia duiogu fitoldi lefaila. ");
INSERT INTO syll_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Ar kurbani kanare boibar lagi er kunar ḳoṛar bitre ou benda haraila. Kurbani kana banaila toḳtadi, ar er bitre faḳ raḳla. ");
INSERT INTO syll_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Uzur fani toar lagi fitolor ek gamla banaila. Ebadoti kamor lagi zeta beṭin Milon-tambur duaror ḳasat aita, tarar fitolor aynadi i gamla ar er soki-kaṭ toiar ḳora oilo. ");
INSERT INTO syll_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Batselole Allar goror sairo galabae uṭanor zaga raḳla. Uṭanor dokkin galar eḳ-sho at zagar lagi dami suti kafoṛdi forda banaila. ");
INSERT INTO syll_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","I forda ṭananir lagi bishgu kuṭi banaila. Kuṭir tolat dibar lagi fitolor bishgu sungi banaila, ar forda ṭananir lagi rufar ḳoṛa ar bandibar tar banaila. ");
INSERT INTO syll_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Uṭanor uttor galar eḳ-sho at zagar lagi bishgu kuṭi, kuṭir tole dibar lagi fitolor bishgu sungi, ar forda ṭananir lagi rufar ḳoṛa ar bandibar tar banaila. ");
INSERT INTO syll_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Fosim galar foinchash at uṭanor lagi forda, doshgu kuṭi, doshgu sungi, forda ṭananir lagi rufar ḳoṛa ar bandibar tar banaila. ");
INSERT INTO syll_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Fub galar uṭan-o foinchash at asil. ");
INSERT INTO syll_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Uṭanor geiṭor ek galar lagi fonro at lamba forda, tinṭa kuṭi, kuṭir tolor tingu sungi, ");
INSERT INTO syll_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","ar dusra galat-o ou laḳan ḳori tinṭa kuṭi, tinṭa sungi ar fonro at forda banail oilo. ");
INSERT INTO syll_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Uṭanor sairo galar hokkol fordain dami suti kafoṛdi banail oilo. ");
INSERT INTO syll_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Kuṭir tolor hokkol sungi fitolor, forda ṭananir ḳoṛa ar bandibar tar oilo rufar, kuṭir mata-o rufadi fesail oilo. Uṭanor sairo galar hokkol kuṭit rufar tardi banda oilo. ");
INSERT INTO syll_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Uṭanor geiṭor lagi dami suti kafoṛdi ekkan forda banail oilo. Bade lilua, baingoni, lal sutadi noksha ḳora oilo. Forda ḳan bish at lamba, ar uṭanor baki fordar laḳan iṭa-o fas at usa deoa oilo. ");
INSERT INTO syll_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Er sairo kuṭi ar sungi fitolor, kuṭir ḳoṛa ar bandar tar rufar, kuṭir mata-o rufadi fesai deoa oilo. ");
INSERT INTO syll_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Allar gor ar uṭanor sairo galar kuṭir fereg oḳol fitoldi banail. ");
INSERT INTO syll_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Allar gor mani ou shahadot tambu banaite zeta mal-samana lagsil, imam Harunor fua Isamaror zimmae Lebi kandanor manshe itar hishab raḳla. Musa nobie ou hishab raḳar hukum disla. ");
INSERT INTO syll_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Mabude Musare zelaḳan hukum disla, i hukum mafik Ehuda gusṭir Urir fua Batselole ita hokkolta banaila, tain asla Huror nati. ");
INSERT INTO syll_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Dan gusṭir Ohisamaḳor fua Aholiabe Batselolre shaijjo ḳorla. Hoḳol zator ator ḳam ar noksha bananir ḳamo tain ustad asla. Dami suti kafoṛor maze lilua, baingoni, lal sutadi noksha ḳorar ḳamo-o tain ustad asla. ");
INSERT INTO syll_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Dulona kurbani taki faoa untish mon shat-sho tish tola shuna ou ebadot ḳana banaite lagse. I maf oilo ebadot ḳanar tolar mafe. ");
INSERT INTO syll_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Boni Israilor manush gonibar bala zerare gona oisil, tarar ges taki eḳ-sho mon eḳ azar shat-sho fosottoir tola rufa faoa gesil, i maf oilo ebadot ḳanar mafe. ");
INSERT INTO syll_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Gona oise oula manush, mani bish boros ba er saite beshi boyosh ala, hou soy laḳ tin azar shaṛe fas-sho manshe ebadot ḳanar mafe mata fisu ada tola ḳori rufa disil. ");
INSERT INTO syll_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","I rufa taki eḳ-sho mon rufa dia ebadot ḳana ar fordar kuṭir tolor sungi banail oisil. Eḳ eḳ sungit eḳ mon rufa dia muṭ eḳ-shogu sungi banail oise. ");
INSERT INTO syll_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ar baki eḳ azar shat-sho fosottoir tola rufa kuṭir ḳoṛa, kuṭir mata fesani, ar bandibar tar bananit lagse. ");
INSERT INTO syll_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Dulona kurbani taki lillar fitol dola oisil shottoir mon dui azar sair-sho tola. ");
INSERT INTO syll_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Ita dia Milon-tambur duaror sungi, fitolor kurbani kana, er fitolor zali ar kurbani kanar hokkol siz banail oise, ");
INSERT INTO syll_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","uṭanor sairo galar sungi, geiṭor sungi, tambu ar uṭanor sairo galar kuṭir fereg banail oise. ");
INSERT INTO syll_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Allar goror pak zagat imamoti kamor shomoy findar lagi, tara lal, baingoni ar lilua sutadi shundor ḳori lebas banaila. Mabude Musare zela hukum disla, ekkere ou laḳan ḳori imam Harunor lagi fobitro lebas banaila. ");
INSERT INTO syll_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Ou ustad ḳarigor oḳole lilua, baingoni, lal suta, dami suti kafoṛ ar shunadi fordan imamor efron banaila. ");
INSERT INTO syll_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Shuna fiṭaia fat banaia, sutar laḳan shunar tar tiar ḳorla. Bade lilua, baingoni, lal suta, dami suti kafoṛ ar shunar tar eḳloge milaia ḳafoṛ banaila. ");
INSERT INTO syll_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Efronor ḳandor gala zuṛa dibar lagi dukan foṭṭi banaia, efronor ufror kunat lagaila. ");
INSERT INTO syll_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Efronor loge zuṛa lagail feṭor ufror belṭ ḳano efronor sutadi banaila. Tara lilua, baingoni, lal suta, dami suti kafoṛ ar shunar tar dia ṭik efronor nomunae banaila. Mabude Musare zela hukum disla, ekkere ou laḳan ḳori hokkolta banail oilo. ");
INSERT INTO syll_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Bade tara duiṭa akik fattor ḳaṭia, er ufre shunar zazoir boaila. Hunar oḳole dami fattor kudia zela sil banain, oula fattor kudia Israilor fuaintor nam leḳla. ");
INSERT INTO syll_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Ar ou duio fattor shunar zazoiror maze lagaia, efronor ḳandor fitar loge bandila. Israilor fuaintor bae Mabudor nozor raḳar lagi ila ḳorla. Mabude Musare zela hukum disla, oula hoḳolta ḳora oilo. ");
INSERT INTO syll_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Bade efronor laḳan bala ustad dorziredi lilua, baingoni, lal suta, dami suti kafoṛ ar shunadi bukur ufror toli banail oilo. ");
INSERT INTO syll_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Iṭa oilo lambae ada at, fashe ada at, sairkuni dui bainj ḳora ḳafoṛ. ");
INSERT INTO syll_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Er ufre tara sair hair ḳori dami fattor lagaila. Foyla harit iakut, fit ar fanna moni; ");
INSERT INTO syll_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","dusra harit lal moni, lil moni ar hira; ");
INSERT INTO syll_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","tin nombor harit firuz, gumed ar foddorag moni; ");
INSERT INTO syll_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","sair nombor harit fukraz, boidurjo ar shuruz moni. I fattor oḳol shunar zazoiror ufre lagail oilo. ");
INSERT INTO syll_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Israilor baro fuar lagi baroṭa fattor lagaila. Ita eḳo fattoro eḳ eḳ fuar nam kudia leḳa oilo, zela kudia sil banail oy. ");
INSERT INTO syll_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Bukur ufror tolir lagi kaṭi shunadi rosir laḳan fesaia duksa chein banaila. ");
INSERT INTO syll_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Ar shunar dukan zazoir ar duiṭa ḳoṛa banaia, bukur ou tolir ufror dui kunat lagaila. ");
INSERT INTO syll_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Ar chein duiogesa duio ḳoṛar loge aṭḳaila. ");
INSERT INTO syll_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Duio ḳandor efronor samnor fitat shunar zazoiror loge cheinor eḳ mata bandila. ");
INSERT INTO syll_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Aro duiṭa shunar ḳoṛa banaia bukur ufror tolir dui kunat lagaila. I duioṭa efronor loge bukur tolir tole roilo. ");
INSERT INTO syll_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Bade aro duiṭa shunar ḳoṛa banaia, efronor ḳandor foṭṭir shoi toledi, feṭor ufror belṭor ufror silair ḳasat lagai dila. ");
INSERT INTO syll_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ar bukur ufror tolir tolor ḳoṛar loge feṭor ufror noksha ḳora belṭor ḳoṛa bandila, ar ou tolie loṛa-soṛa na ḳorar lagi tolor ḳoṛar loge lilua sutadi bandi dila, zela Mabude Musare hukum ḳorsla. ");
INSERT INTO syll_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Bade tara efronor tolor alḳella lilua rongor sutadi bain ḳorla, ");
INSERT INTO syll_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","ar mata haraibar bala golar faḳ siṛto na ḳori er sairo gala foṭṭi dia doṛo ḳori bain ḳorla, golar ou faḳ raḳla maz borabor. ");
INSERT INTO syll_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Lilua, baingoni, lal rongor fesail sutadi anuar folor laḳan banaila. Banaia oguinre alḳellar tolor muṛir sairobae lagaila. ");
INSERT INTO syll_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Bade ḳaṭi shunar gungur banaia ou anuaror faḳe faḳe lagaila, ");
INSERT INTO syll_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","asta tolor muṛit egu ḳori anuar ar egu ḳori gungur lagail oilo. Ebadoti kamor bala imam sabe ou alḳella findita. Mabude Musare zela hukum disla, ekkere oula ḳora oilo. ");
INSERT INTO syll_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Bade tara Harun ar tan fuaintor lagi dami suti sutadi fainjabi banaila. ");
INSERT INTO syll_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Matar faugṛi ar tokiguin-o dami suti kafoṛdi banaila, ar haf-penṭor laḳan zangia-o banaila ou ḳafoṛdi. ");
INSERT INTO syll_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Ḳomror ekkan bondoni banaila, dami suti kafoṛ, lilua, baingoni ar lal sutadi noksha ḳori banaila. Mabude Musare zela hukum disla, ekkere oula ḳora oilo. ");
INSERT INTO syll_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ar faugṛir samne laganir lagi, ḳaṭi shunar fatdi ekkan fobitro taz tiar ḳorla. Silor ufre zela kudia leḳa oy, ou fattor ufre ola kudia leḳla, “Mabudor name fobitro.” ");
INSERT INTO syll_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Mabude Musare zela hukum disla, ou hukum mafik-u i fatre lilua sutadi faugṛir samne bandi dila. ");
INSERT INTO syll_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Ou laḳan Milon-tambu shoho Allar goror hokkol ḳam-ḳaz shesh oilo. Mabude Musare zela hukum disla, Boni Israile ekkere ou laḳan hoḳolta ḳorla. ");
INSERT INTO syll_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Bade tara Allar goror lagi banail hokkolta Musar ḳasat loia aila. Tara anla: Milon-tambu, tambur hoḳol mal-samana, huk, freim, batti, kuṭi, kuṭir tolor sungi; ");
INSERT INTO syll_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","lal rong kora meṛar samṛar sani, fuʼr samṛar sani, Herem Shorifor beṛar forda; ");
INSERT INTO syll_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","shahadot shonduk, shonduk boia neoar benda, shondukor ḍaḳna; ");
INSERT INTO syll_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ṭebul, ṭebulor hoḳol siz, Mabudor namor fobitro ruṭi; ");
INSERT INTO syll_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ḳaṭi shunar serag dani, er logor hoḳol siz, zalanir tel; ");
INSERT INTO syll_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","shunar agor-kushboy zalanir ṭebul, ḳelafotir tel, kushboy-ala agor, Allar goror duaror forda; ");
INSERT INTO syll_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","fitolor kurbani kana, fitolor zali, kurbani kana boia neoar benda, kurbani kanar hokkol mal-samana, uzur gamla ar er tolor soki-kaṭ; ");
INSERT INTO syll_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","uṭanor fordain, kuṭin, kuṭir tolor sungi, uṭano hamanir geiṭor forda, uṭanor fereg ar doṛi; ek kotae, Milon-tambu shoho Allar goror hokkol mal-samana; ");
INSERT INTO syll_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ar pak zagat imamoti kamor lagi imam Harunor fobitro lebas, ar tan fuaintor-o imamotir lebas. ");
INSERT INTO syll_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Mabude Musare zela hukum disla, ou laḳan Boni Israil oḳole hoḳol ḳam ḳorla. ");
INSERT INTO syll_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Heshe Musae ita hoḳolta dekia buzla, Mabude zela hukum disla, ou laḳan-u ḳora oise. Erlagi tain hoḳol Boni Israilre dua dila. ");
INSERT INTO syll_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Mabude Musa nobire ḳoila, ");
INSERT INTO syll_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Tumi bosoror foyla sandor foyla tariko Milon-tambu shoho amar gorre ḳaṛa ḳorio. ");
INSERT INTO syll_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Goror bitre shahadot shondukre haraia, maze forda ṭanaia shondukre aoṛe toio. ");
INSERT INTO syll_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ṭebulre-o bitre haraia, er ufror siz oḳol hazaio. Bade serag dani bitre ania tar serag oḳol zalai dio. ");
INSERT INTO syll_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Shunadi banail agor-kushboy zalanir ṭebul shahadot shondukor samne toio, toia amar goror duaror forda lagaio. ");
INSERT INTO syll_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Amar goror Milon-tambur duaror samne zalail kurbani kana toio. ");
INSERT INTO syll_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Kurbani kana ar Milon-tambur mazḳano uzur gamla fanidi boria toio. ");
INSERT INTO syll_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Bade uṭanor sairo galabae forda ṭanaio, ar uṭanor geiṭo-o forda lagaio. ");
INSERT INTO syll_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Bade tumi kelafotir tel dia amar gor ar amar goror hoḳol mal-samanare fobitro ḳorio. Teu ita hoḳolta moha fak-fobitro oibo. ");
INSERT INTO syll_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ar zalail kurbani kanar ufre-o ḳelafotir tel dia fobitro ḳorio. Kurbani kanar hoḳol mal-samanare-o fobitro ḳorio. Teu i kurbani kana moha-fobitro siz oibo. ");
INSERT INTO syll_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Uzur fanir gamla ar er tolor soki-kaṭre-o ḳelafotir tel dia fobitro ḳorio. ");
INSERT INTO syll_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Bade Harun ar tar fuainre Milon-tambur duaror samne ania fanidi naoai dio. ");
INSERT INTO syll_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Naoanir bade Harunre fak-fobitro lebas oḳol findaio, ar amar imam oar lagi tare fobitro tel lagaia ḳelafoti dia fobitro ḳorio. ");
INSERT INTO syll_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Tar fuaintore ania imamotir fainjabi findaio. ");
INSERT INTO syll_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Tarar bafre zela fobitro teldi imamoti kamor ḳelafoti diso, tarare-o oula ḳelafoti dio, zate tara-o amar imamoti kam ḳorta faroin. I kelafotir mazdi imamotir ze niom salu oibo, ita oarishor for oarish dori salu roibo.” ");
INSERT INTO syll_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mabudor hukum mafik Musae ita hoḳolta ḳorla. ");
INSERT INTO syll_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Dusra bosoror foyla sandor foyla tariko Allar gor ḳaṛa ḳora oilo. ");
INSERT INTO syll_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musae i gor ḳaṛa ḳorla, foyla er kuṭir tolor sungi boaila, kuṭin uba ḳorla, beṛar freim lagaila, freimor bitredi batti dila. ");
INSERT INTO syll_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Mabudor hukum mafik tain sagolor ruma dia goror foyla sani dila, er ufre dila aro duiṭa sani. ");
INSERT INTO syll_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Bade hou duioḳan fobitro shahadot fattor ania shondukor bitre haraila. Shonduk boia neoar benda lagaila, shondukor ufror ḍaḳna-o lagaila. ");
INSERT INTO syll_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ar shondukre nia Allar goror bitre haraila. Haraia forda ṭanaia shondukre aoṛe raḳla, zela Mabude Musare hukum disla. ");
INSERT INTO syll_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Shondukor ou fordar bare uttor galabae, Milon-tambur maze fobitro ruṭir ṭebul raḳla. ");
INSERT INTO syll_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Ṭebulor ufre Mabudor namor fobitro ruṭi hazaia toila, zela Mabude Musare hukum disla. ");
INSERT INTO syll_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ṭebulor samne tambur dokkin galat serag dani toila. ");
INSERT INTO syll_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Bade Mabudor samne serag guin zalaila, zela Mabude Musare hukum disla. ");
INSERT INTO syll_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Milon-tambur mazḳanor fordar samne shunadi banail agor-kushboy zalanir ṭebul toila. ");
INSERT INTO syll_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Oḳanor ufre kushboy-ala agor zalaila, zela Mabude Musare hukum disla. ");
INSERT INTO syll_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Bade Musae duaror forda ṭanaila. ");
INSERT INTO syll_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Tain Allar goror Milon-tambur duaror ḳandat zalail kurbani kana toila. Toia er ufre zalail foshu kurbani ar dan-gomor sodga dila, zela Mabude Musare hukum disla. ");
INSERT INTO syll_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Bade Milon-tambu ar kurbani kanar mazḳano uzur gamla toila, toia uzur fani boria dila. ");
INSERT INTO syll_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Ou fani dia Musa, Harun ar Harunor fuainte uzu ḳorta. ");
INSERT INTO syll_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Mabudor hukum mafik tara Milon-tambut hamanir age, ba kurbani kanar ḳandat zaoar age uzu ḳorta. ");
INSERT INTO syll_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Bade Musae Allar gor ar kurbani kanar sairobae forda ṭanaia uṭan banaila. Uṭanor geiṭor forda lagaila. Ou laḳan Musae tan hoḳol ḳam shesh ḳorla. ");
INSERT INTO syll_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ḳam shesh ḳoria harle, gaibi megor kuṭi aia ou Milon-tambure gurililo, Mabudor mohima ar kudrote asta gor borigelo. ");
INSERT INTO syll_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Erlagi Musa ar Milon-tambut hamaita farla na, ḳaron er ufre hou megor kuṭi asil, ar Mabudor kudroti mohimae asta gor bori gesil. ");
INSERT INTO syll_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Boni Israilor ou asta soforor maze, Allar goror ufre taki megor kuṭi horia harle tara aṭia roana dita. ");
INSERT INTO syll_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Oile megor kuṭi ufre taki na hora forzonto tara bar oita na, ou kuṭi horar lagi bar saita. ");
INSERT INTO syll_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ḳaron Boni Israilor ou asta soforor maze-u, dinor bala tarar sokur samne Allar goror ufre megor kuṭi roito, ar raitor bala roito aguinor kuṭi.");
INSERT INTO syll_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Ou fobitro Kaba gor mani Milon-tambu bananir bade, Mabude Musa nobire ono anaia ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Tumi hoḳol Boni Israilre zanai deo, ḳeu zudi kurbani hishabe Mabudor dorbaro kunu foshu dito sae, te goru ba sagol-meṛar fal taki foshu ania kurbani dilauk. ");
INSERT INTO syll_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“Kurbani deorae zudi gorur fal taki zalail kurbani adae ḳorto sae, te furafur nikut egu bisal ante oibo. Ania Mabudre kushi korar niote ou bisalre Milon-tambur duaror gese loia aibo. ");
INSERT INTO syll_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Aia zalail kurbanir niote ana ou bisalor ḳollar ufre at toibo, teu tar gunar kofora hishabe iṭare kobul ḳora oibo. ");
INSERT INTO syll_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Bade Mabudor samne ou bisalre he zobo ḳorbo. Ar imam Harunor ze fuainte imamoti koroin, tara ou bisalor lou nia Milon-tambur duaror samnor kurbani kanar sairo galat siṭai diba. ");
INSERT INTO syll_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Bade kurbani deorae ou bisalor ḳal ḳalia hari, ogur gust ṭukra ṭukra ḳorba. ");
INSERT INTO syll_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Ar imam Harunor fuainte kurbani kanar ufre zalail angra toiba, er ufre daru hazaiba. ");
INSERT INTO syll_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Hazaia ou darur ufre bisalor ḳolla, sorbi, gustor ṭukrain toiba. ");
INSERT INTO syll_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Kurbani deorae gorur ṭeng ar feṭor bitoror hokkolta fani dia doia saf ḳoria diba, ar imame ota nia asta bisalor hokkolta kurbani kanar ufre zalailiba. Iṭar nam oilo zalail kurbani, Mabudor name agunit deoa kurbani, ou dumar gerane tain kushi oin. ");
INSERT INTO syll_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“Ar kunu manshe zudi sagol-meṛar fal taki zalail kurbani adae ḳorar kiali oy, te ikṭa furafur nikut egu faṭa oite oibo. ");
INSERT INTO syll_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Kurbani deorae ikṭare kurbani kanar uttor galat nia Mabudor samne zobo ḳoria harle, imam Harunor ze fuainte imamoti koroin, tara ogur lou nia kurbani kanar sairo galat siṭai diba. ");
INSERT INTO syll_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Bade kurbani deorae iṭar gust ṭukra ṭukra ḳori kaṭia dile, imam sabe ogur sorbi, ḳolla ar gustor ṭukrain nia kurbani kanar zalail angrar ufror darur ufre hazaiba. ");
INSERT INTO syll_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Kurbani deorae iṭar ṭeng, feṭor bitoror hokkolta fani dia doia saf ḳoria diba, ar imam sabe ita hokkolta shomet asta foshure kurbani kanar ufre zalailiba. Iṭa oilo zalail kurbani, Mabudor name agunit deoa geran ala kurbani, ou dumar gerane tain kushi oin. ");
INSERT INTO syll_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“Ar kunu faki dia zudi Mabudor namor ou zalail kurbani adae ḳorar kial oy, te kurbani deorae ḍufi faki ba faro loia aibo. ");
INSERT INTO syll_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Aile, imame kurbani kanar daro gia ou fakir ḳolla mura maria siṛia algaia hari kurbani kanar ufre ou ḳollare zalailiba, ar ogur lou nia kurbani kanar ek galat siṭai diba. ");
INSERT INTO syll_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Imame fakir bitoror gila-toli ar foir nia kurbani kanar fub galar salir ṭekir maze falai diba. ");
INSERT INTO syll_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Ar ogur ḍaḳnat doria ola baṭe siṛiba, zate iṭar dui ṭukra furafur alog na oy. Bade imam sabe iṭa nia kurbani kanar zalail angrar ufror darur ufre toia zalailiba. Iṭa-o oilo zalail kurbani, Mabudor name agunit deoa geran ala kurbani, ou dumar gerane tain kushi oin. ");
INSERT INTO syll_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“Kunu manshe zudi dan-gom dia Mabudor name lilla-sodga dito sae, te nireḳ moyda dia adae ḳorbo. Ou moydar ufre he zoytunor tel ar loban-agoror duna dibo. ");
INSERT INTO syll_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Dia imam Harunor ze fuainte imamoti koroin tarar gese ota loia aibo. Imame ota taki tel mishail eḳ muiṭ moyda ar hoḳol agor loia, tar ana hokkoltar bodla nishana hishabe ou ongshore kurbani kanar ufre zalailiba. Ita oilo Mabudor name agunit deoa kurbani, itar dumar gerane tain kushi oin. ");
INSERT INTO syll_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Zalanir bade zotoḳan baki roibo, ita imam Harun ar tan fuainte faiba. Mabudor namor agunit deoa kurbanir ongsho oae, basi zaoa ou moyda to ḳas fobitro zinish. ");
INSERT INTO syll_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“Ar ḳeu zudi tunduri undalo hedia ana kunu dan-gomor sodga adae ḳorto sae, te tel mishail nireḳ moyda dia ḳamir saṛa ruṭi ba banail ruṭit tel maḳaia loia aibo. ");
INSERT INTO syll_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Ar ou sodgar ruṭi zudi taoat hedia ana oy, te ita tel mishail ḳamir saṛa nireḳ moyda dia banaia ante oibo. ");
INSERT INTO syll_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Ania ita ṭukra ṭukra ḳoria er ufre tel ḍalia dite oibo, ita-o dan-gomor eḳ nomunar sodga. ");
INSERT INTO syll_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Ar ou sodgar ruṭi zudi luaṛir maze bazia ana oy, te ita-o tel ar nireḳ moyda dia banaia anbae. ");
INSERT INTO syll_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Ola zekunu nomunae banail dan-gomor sodgare Mabudor name ania imamor ato shomzai dibae, imame ita kurbani kanar gese niba. ");
INSERT INTO syll_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Nia tar ana ou hokkoltar bodla nishana hishabe, imame oḳan taki kisu ongsho algaia kurbani kanar ufre zalailiba. Ita oilo agunit deoa kurbani, er dumar gerane Mabud kushi oin. ");
INSERT INTO syll_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ou ongsho zalaia harle bad-baki zeta roibo, ita hoḳolta imam Harun ar tan fuainte faiba. Mabudor name agunit deoa kurbanir ongsho oae, basi zaoa ou sodgar ruṭi to ḳas fobitro zinish. ");
INSERT INTO syll_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“Ar huno, Mabudor name dan-gomor sodgar niote zotota ana oibo, ita hoḳolta-u zanu ḳamir saṛa tiar ḳora oy. Hushiar roio, tumra Mabudor namor agunit deoa lilla-sodgar malor loge kunu ḳamir ba mou zalaio na. ");
INSERT INTO syll_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Ta-o ḳetor foyla foy-fosholor sodgar loge tumra mou ba ḳamir Mabudor name ditae farbae, oile dumar geran ala sodgar niote ḳamir ba mou kurbani kanat zalail zaito nae. ");
INSERT INTO syll_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Kial rakio, tumra dan-gomor sodgar niote zotota banaia anbae, ita hokkoltar maze nun mishaibae. Boni Israilor Allar oada-chuktire mono rakia, tumra hoḳol nomunar dan-gomor sodgat nun dite faurio na. Tumrar hokkol kurbanir maze nun dio. ");
INSERT INTO syll_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“Tumrar ḳetor foyla daoa dan-gomor kunu foshol zudi Mabudor name lilla-sodga hishabe loia ao, te ita maṛa deoa ḳasa noya dan-gom ba asta soṛare aguindi hedia anbae. ");
INSERT INTO syll_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Itar ufre tel ar loban-agor dibae, ita oilo eḳ nomunar dan-gomor sodga. ");
INSERT INTO syll_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Ou sodga loia aile, imam sabe nishana hishabe ou zonor ana dan-gomor sodgar kisu ongsho, kisu tel ar hoḳol agor nia kurbani kanat zalailiba, ita oilo Mabudor name agunit deoa kurbani. ");
INSERT INTO syll_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“Kunu manshe zudi Mabudor name nizor kushie salamoti kurbani adae ḳorar niote kunu gai ba bisalre kurbani dito sae, te i goru furafur nikut oite oibo. ");
INSERT INTO syll_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Kurbani deorae ou foshur ḳolla ataia dia, Milon-tambur duaror samne iṭare zobo ḳorbo. Bade imam Harunor fuaintor mazor imam oḳole ogur lou nia kurbani kanar sairo galat siṭai diba. ");
INSERT INTO syll_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Ar kurbani deorae Mabudor name ana salamoti kurbanir foshur ou ongsho oḳol diba. Ogur feṭor bitoror hokkoltar ufror sorbi, ");
INSERT INTO syll_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","duio kiḍni ar otar sorbi, ḳoiljar logor maṭia, ou hoḳolta ania imamor gese diba. ");
INSERT INTO syll_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Bade Harunor fuainte kurbani kanar ufre hazail daru ar kurbanir foshur ufre ita hoḳolta rakia eḳloge zalailiba. Ita to eḳ nomunar agunit deoa kurbani, itar dumar gerane Mabud kushi oin. ");
INSERT INTO syll_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“Kunu manshe zudi Mabudor name salamoti kurbani adae ḳorar lagi sagol-meṛar fal taki kunu foshure kurbani dibar niot ḳore, te i foshu meda ba medi oile-o solbo, oile iṭa furafur nikut oite oibo. ");
INSERT INTO syll_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Kurbani dibar niote zudi meṛa ane, te Mabudor samne iṭa azir ḳorba. ");
INSERT INTO syll_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Kurbani deorae ou meṛar ḳolla atai dia, Milon-tambur duaror samne iṭare zobo ḳorbo. Bade imam Harunor fuaintor mazor imam oḳole ogur lou nia kurbani kanar sairo galat siṭai diba. ");
INSERT INTO syll_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Kurbani deorae Mabudor name agunit deoa kurbani hishabe ana, ou salamoti kurbanir meṛar hoḳol sorbi imamor gese diba. Tain sorbi ala lenguṛ, feṭor bitoror hoḳoltar ufror sorbi, itar loge lagail sorbi, ");
INSERT INTO syll_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","duio kiḍni ar otar hoḳol sorbi, ḳoiljar logor maṭia, ota hoḳolta ania imam sabor gese diba. ");
INSERT INTO syll_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Imame ita nia kurbani kanar agunir ufre zalailiba, ita oilo Mabudor name agunit deoa kurbanir ḳani. ");
INSERT INTO syll_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“Ar kurbani dibar niote he zudi sagol ane, te he iṭare Mabudor samne azir ḳorbo. ");
INSERT INTO syll_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","He ogur ḳolla atai dia, Milon-tambur duaror samne iṭare zobo ḳorbo, bade Harunor fuainte ogur lou nia kurbani kanar sairo galat siṭai diba. ");
INSERT INTO syll_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Kurbani deorae foshur ou ongsho oḳol nia, Mabudor name agunit deoa kurbani hishabe imamor gese dibo. He foshur feṭor bitoror hoḳoltar ufror sorbi, itar loge lagail sorbi, ");
INSERT INTO syll_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","duio kiḍni ar otar ufror sorbi, ḳoiljar logor maṭia, ota hoḳolta ania imamor gese dibo. ");
INSERT INTO syll_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Imame ita hoḳolta nia kurbani kanar ufre zalailiba, ita to agunit deoa kurbanir ḳani, itar dumar gerane Mabud kushi oin. “Mono rakio, kurbanir foshur hokkol sorbi oilo Mabudor. ");
INSERT INTO syll_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Tumra bongshor for bongsho doria ou niom manio, zekunu zagat boshot ḳoro na ḳene kunudin sorbi ba lou ḳaio na, ita haram.” ");
INSERT INTO syll_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Bade Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Tumi Boni Israilre ḳo, na zanar ḳarone ḳeu zudi bul ḳoria Allar nished ḳora kunu gunar ḳam ḳorilae, te tain ou nomunae gunar koforar kurbani adae ḳorba. ");
INSERT INTO syll_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“Ein ḳelafoti faoa fordan imam sab oile, tan gunar dae-bar hoḳol manshor ufre borte, erlagi tain nikut egu bisal ania Mabudor dorbaro tan gunar koforar kurbani diba. ");
INSERT INTO syll_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Ou bisal loia tain Milon-tambur duaror gese Mabudor samne aiba, aia ogur ḳolla atai dia, Mabudor samne zobo ḳorba. ");
INSERT INTO syll_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Ḳoria ou bisalor tuṛa lou nia Milon-tambur bitre zaiba. ");
INSERT INTO syll_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Gia lour maze nizor angul subaia lou lagaia Herem Shorifor fordar bae Mabudor samne shatbar siṭai diba. ");
INSERT INTO syll_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Bade aro tuṛa lou loia Milon-tambur maze Mabudor samne agor-kushboy zalanir ṭebulor sairo kunar hing oḳlor maze lagaiba. Ar bad-baki lou nia Milon-tambur duaror samnor zalail kurbani kanar tole ḍali diba. ");
INSERT INTO syll_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Bade gunar koforar lagi deoa kurbanir ou bisalor hoḳol sorbi bar ḳorba, feṭor bitoror hokkoltar ufror sorbi, itar loge lagail hoḳol sorbi, ");
INSERT INTO syll_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","duio kiḍni ar otar ufror sorbi, ar ḳoiljar logor maṭia. ");
INSERT INTO syll_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Salamoti kurbanir gorur sorbir laḳan, ou kurbanir bisalor hoḳol sorbire-o ola bar ḳorba. Bade imame ou sorbi nia zalail kurbani kanat zalailiba. ");
INSERT INTO syll_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Oile ou bisalor ḳolla, ḳal, gust, ṭeng, at-boṛ, gufor, ");
INSERT INTO syll_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","hoḳolta nia Boni Israilor kempor bare zeḳano kurbanir salir ṭeki toin, hou fak-saf zagar salir ṭekir ufre ota toia hari, laḳṛir aguindi zalailiba. ");
INSERT INTO syll_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“Ar asta Boni Israil shomaz na zanar ḳarone zudi bul ḳoria kunu gunar ḳam ḳorilae, Allar nished ḳora kunu ḳam ḳoria dushi bonizae, te na zania ḳorle-o tara hoḳol-u gunagar. ");
INSERT INTO syll_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Bade zebla tara zanba, zania hari ou gunar koforar lagi hoḳlor torof taki egu bisal kurbani diba, ou bisal loia tara Milon-tambur samne azir oiba. ");
INSERT INTO syll_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Oia Boni Israilor murobbi oḳole ou bisalor ḳolla atai diba, ar imame Mabudor samne oḳṭa zobo ḳorba. ");
INSERT INTO syll_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Zobor bade ḳelafoti faoa imam sabe bisalor tuṛa lou loia Milon-tambur bitre hamaiba. ");
INSERT INTO syll_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Hamaia ou lour maze tan ator anguil subaia, tuṛa lou Herem Shorifor fordar bae shatbar Mabudor samne siṭaiba. ");
INSERT INTO syll_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Bade aro tuṛa lou loia Mabudor samne toa, Milon-tambur bitoror agor-kushboy zalanir ṭebulor hing oḳol-o lagaiba. Bad-baki lou fuṭain Milon-tambur duaror samnor zalail kurbani kanar tole ḍali diba. ");
INSERT INTO syll_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Ar bisalor hoḳol sorbi bar ḳoria kurbani kanat zalailiba. ");
INSERT INTO syll_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Fordan imamor gunar koforar lagi bisalre zela kurbani deoa oy, imame ou bisalre-o ola kurbani korba. Tain ou shomazor gunar koforar kurbani adae ḳorle, tarar gunar mafi milbo. ");
INSERT INTO syll_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Imam sabe bisalor bad-baki hoḳolta loia kempor bare zaiba. Gia tan nizor gunar koforar hou bisalor laḳan ou bisalor hoḳolta-o kempor bare ola zalailiba. Ita oilo asta shomazor gunar koforar kurbani. ");
INSERT INTO syll_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“Ar Boni Israilor kunu shordare na zanar ḳarone zudi bul ḳoria ola guna ḳorilain, te Allar nished ḳora ḳam ḳorae tain to dushi. ");
INSERT INTO syll_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Tain zebla ou gunar befare zaniliba, zanar bade koforar kurbani dibar lagi nikut egu faṭa sagol loia aiba. ");
INSERT INTO syll_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Aia ou faṭar ḳollar ufre atai dia, zalail kurbanir foshu zobo ḳorar zagat nia ogure Mabudor samne zobo ḳorba. Ita to tan gunar koforar kurbani. ");
INSERT INTO syll_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Bade imam sabe ou foshur tuṛa lou tan ator angulit ḳori loia, zalail kurbani kanar hing oḳlor ufre lagaiba. Bad-baki lou nia tain kurbani kanar tole ḍali diba. ");
INSERT INTO syll_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Ar salamoti kurbanir foshur sorbir laḳan ogur hoḳol sorbire kurbani kanar ufre zalailiba. Ou laḳan imame hou shordaror gunar mafir lagi kofora adae ḳorle, tain mafi faiba. ");
INSERT INTO syll_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“Ar Boni Israilor kunu shadaron zone na zanar ḳarone zudi bul ḳoria kunu gunar ḳam ḳorilae, Mabudor nished ḳora kunu ḳam ḳoria dushi bonizae, ");
INSERT INTO syll_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","te he zebla tar gunar befare zanilibo, zania ou gunar koforar lagi he nikut egu sagi loia aibo. ");
INSERT INTO syll_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Aia ou sagir ḳollar ufre atai dia, zalail kurbanir zobor zagat nia ogure zobo ḳorbo. ");
INSERT INTO syll_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Bade imam sabe tan ator angulit ḳori ogur tuṛa lou lagaia, kurbani kanar hing oḳlor ufre lagaiba. Bad-baki lou tain kurbani kanar tole ḍali diba. ");
INSERT INTO syll_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Ar salamoti kurbanir meṛar sorbir laḳan ogur hoḳol sorbi bar ḳoria kurbani kanar ufre zalailiba. Itar dumar gerane Mabud kushi oin. Ou nomunae imame hou zonor gunar kofora adae ḳorle, tar mafi milbo. ");
INSERT INTO syll_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“Gunar koforar kurbanir niote ḳeu zudi kunu meṛa ane, te iṭa nikut meṛi-baichcha oite oibo. ");
INSERT INTO syll_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","He ogur ḳollar ufre atai dia, zalail kurbanir foshur zobor zagat nia, gunar koforar kurbanir niote ogure zobo ḳorbo. ");
INSERT INTO syll_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Bade imam sabe tan ator angulit ḳori ou meṛir tuṛa lou loia, kurbani kanar hing oḳlor ufre lagaiba. Bad-baki lou tain kurbani kanar tole ḍali diba. ");
INSERT INTO syll_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Ar salamoti kurbanir meṛar sorbi zela bar ḳoroin, ogur hoḳol sorbire-o ola bar ḳorba. Bar ḳoria kurbani kanat kurbani deoa hoḳoltar ufre toia ou sorbire-o zalailiba, ou nomunae imame hou zonor gunar kofora adae ḳoria harle, he mafi faibo. ");
INSERT INTO syll_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“Kunu manshe zudi nizor souke deḳa ba ḳane huna kunu goṭona zane, ar bisaror ḳalo adaloto shakkir shuzug faia-o shakki na dey, te itar lagi he guna ḳore, tar i oforador shaza he boibo. ");
INSERT INTO syll_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“Ḳeu zudi na zania kunu nafak zinish soilae, te he nafak ar dushi bonbo. Ita kunuzator zongli haram mora foshu, goro fala kunu mora zandar ba maṭir maze buke solra zekunu mora zandarre na zania soile-o dushi-nafak bonbo. ");
INSERT INTO syll_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“Manshor shorilre zetae nafak korilae, shoril taki bar oil ou laḳan kunuta ḳeu zudi na zania soilae, te ita zanar bade he dushi oibo. ");
INSERT INTO syll_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“Aḳol-bibeḳ na ḳaṭaia aḳta zudi keu kunu ḳosom ḳorilae, bala ba bura kunta ḳormu ḳoia monor bekiale ḳeu kunu ḳosom ḳaile-o, he zebla ikan buzilibo ou shomoy he dushi bonbo. ");
INSERT INTO syll_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“Ou laḳan zekunu oforad ḳoria ḳeu dushi bonigele, he nizor gunare shikar ḳorte oibo. ");
INSERT INTO syll_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Ar ou gunar zorimana hishabe he Mabudor name, gunar koforar kurbanir niote eḳṭa meṛi ba sagi anbo, ar imame tar gunar kofora adae ḳorba. ");
INSERT INTO syll_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“Ar he zudi meṛi ba sagi ante ofarog oy, te ou gunar zorimana babot duiṭa ḍufi faki ba faro ania Mabudor name dite oibo. Itar mazor egu oibo gunar koforar kurbani, ar dusraṭa zalail kurbani. ");
INSERT INTO syll_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Ar he ita ania imamor ato dibo, imame gunar koforar kurbani hishabe foyla egu fakire kurbani diba. Tain ogur ḳolla muraia marba, oile ḳolla algaita nae. ");
INSERT INTO syll_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Bade ogur tuṛa lou nia kurbani kanar sairo galat siṭai diba, ar bad-baki lou kurbani kanar tole ḍali diba. Ita oilo gunar koforar lagi kurbani. ");
INSERT INTO syll_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Ar dusra fakiṭare imam sabe niom mafik zalail kurbani diba. Dia, tar gunar kofora adae ḳorba, teu he mafi faibo. ");
INSERT INTO syll_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“Ar zudi ou gunar koforar lagi duiṭa ḍufi faki ba faro anto na fare, te he dui sher moyda ante oibo. Ita gunar koforar kurbani oae itar ufre kunu tel ba loban-agor dio na. ");
INSERT INTO syll_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Ou moyda loia he imamor gese zaibo, gele ou asta kurbanir bodla nishana hishabe eḳ muiṭ moyda imam sabe kurbani kanar ufre Mabudor name zalailiba. Ita oilo Mabudor name gunar koforar kurbani. ");
INSERT INTO syll_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","He ze oforad ḳorse, otar mafir lagi imame ola kofora adae ḳorba, teu tar gunar mafi faibo. Ar kurbani deoar bade i moydar zotoḳan roibo, dan-gomor sodgar laḳan ita hoḳolta imame faiba.” ");
INSERT INTO syll_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Bade Mabude Musa nobire ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Ḳeu zudi na zania Mabudor fak-fobitro kunu mal-samanar befare emne-u kunu dush-ḳosuri korilae, te ou gunar zorimana hishabe ebadot ḳanar mafe zoto tola rufadi meṛar dam ṭik kora oy, te he tar nizor fal taki ou foriman damor ba homan damdi kinia nikut egu meṛar faṭa Mabudor name kurbani dite oibo. Ita to dush-ḳosurir koforar kurbani. ");
INSERT INTO syll_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Ar he ou fak-fobitro mal-samanar befare ze dush-ḳosuri korse, itar ḳeti-furon-o dite oibo. He ou meṛar damor loge aro fas baṭor eḳ baṭ foriman nogod ṭeḳa imam sabor ato dibo. Bade imame tar ḳosuri mafir niote ou meṛare nia dush-ḳosurir koforar kurbani adae ḳoria harle, he mafi faibo. ");
INSERT INTO syll_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Ar kunu manshe zudi bul ḳoria na zania Allar nished ḳora kunu dush-ḳosurir ḳam ḳorilae, te itar lagi he dushi. I gunar lagi tare dayi kora oibo. ");
INSERT INTO syll_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","He tar ou dush-ḳosurir kofora hishabe, egu nikut meṛar faṭa ba er dam ania imam sabor gese dibo. He na zania ze dush-ḳosuri korilise, imam sabe otar kofora adae ḳorba, teu tar mafi milbo. ");
INSERT INTO syll_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ita to dush-ḳosurir koforar kurbani, he Mabudor dorbaro dush ḳorse.” ");
INSERT INTO syll_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Mabude Musa nobire aro ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Huno, kunu manshe zebla tar ari-forir loge harami koria Mabudor dorbaro guna ḳore, tar gese toa amanot ba bondoki zinishor kianot ḳore, ba suri kori kunu mal ney ba ṭogaṭogi kore, sol-soturi koria beimani mate, ");
INSERT INTO syll_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","tubaia faoa malor befare beimani mate ba ota hokkoltar befare kunu misa ḳosom ḳae, ba ou laḳan aro kunu guna ḳore, ");
INSERT INTO syll_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","te ou nomunar guna ḳoria oforadi bonae, he zeta mal attoshat ḳorse, ba sol-soturi koria nise, ba amanotor kianot ḳorse, tubai faoa mal lukaise, ");
INSERT INTO syll_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ba zekunu malor befare misa ḳosom ḳaise, ita hoḳolta he firot dibo, erloge zorimana hishabe aro fas baṭor eḳ baṭ beshi dibo. He zedin tar dush shikar ḳorbo, ou din malor malikre ita firai dibo. ");
INSERT INTO syll_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Ar nizor dush-ḳosuri mafir niote he Mabudor dorbaro kurbani loia azir oibo, imam sabor ṭik kora damor egu nikut meṛar faṭa loia aibo. ");
INSERT INTO syll_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Imame Mabudor dorbaro tar gunar kofora adae ḳorba. He otar mazor zekunu guna ḳorle, ou nomunae tar gunar mafi faibo.” ");
INSERT INTO syll_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Bade Mabude Musa nobire ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Tumi Harun ar tar fuaintore hikai deo, zalail kurbani adae ḳorar musla oilo, kurbanir foshu fozor forzonto hara rait kurbani kanar agunir ufre roibo, ar aguino zalail roibo. ");
INSERT INTO syll_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Biani bala imam sabe suti kafoṛdi banail haf-penṭor laḳan nizor zangiaḳan ar tan imamotir baki hoḳol sutir lebas findiba. Findia kurbanir foshu zalanir sali tulia nia kurbani kanar ḳandat toiba. ");
INSERT INTO syll_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Bade tain ou lebas bodlaia, dusra lebas findia, ou salire kempor bare kunu fak-saf zagat nia falaiba. ");
INSERT INTO syll_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Oile kurbani kanat aguin zalail roibo, ita nibto na. Forteḳ din biane imame ou agunir ufre zalanir daru diba, dia darur ufre zalail kurbanir foshure hazaiba, hazaia er ufre salamoti kurbanir sorbire zalaiba. ");
INSERT INTO syll_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Hushiar roio, kurbani kanar aguin hamesha zolat roibo, ita kunu shomoy-u nibto na. ");
INSERT INTO syll_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“Dan-gom sodgar niom oilo, Harunor fuain taki eḳzon imame ou sodgar moyda ar dorḳari hokkolta loia kurbani kanar gese Mabudor samne azir oiba. ");
INSERT INTO syll_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Ar imame oḳan taki eḳ muiṭ moyda, kisu tel ar sodgar hoḳol loban-agor nia asta sodgar nishana hishabe ou ongshore kurbani kanar ufre zalaiba. Itar dumar gerane to Mabud kushi oin. ");
INSERT INTO syll_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Sodgar malor bad-baki ongsho imam Harun ar tar fuainte ḳaiba. Tara itar maze kunu ḳamir na mishaia ruṭi banaiba, banaia Milon-tambur uṭano kunu pak zagat boia ḳaiba. ");
INSERT INTO syll_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Mono rakio, kunu ḳamir furaia itare sekio na. Amar name deoa zalail kurbanir ou ongsho ami tarare dilam. Gunar koforar kurbani, ar dush-ḳosurir koforar kurbanir laḳan dan-gomor sodgar ou ongsho-o oilo ḳas fobitro. ");
INSERT INTO syll_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Ḳali imam Harunor bongshor hoḳol beṭa manshe ita ḳaita farba, Mabudor namor zalail kurbanir ou ongsho to oarishor for oarish dori tara-u faiba. Kub kial rakio, zesatae itar loge lagbo, ota-o fak-fobitro bonizibo, mani imam oḳlor baira manshor lagi haram.” ");
INSERT INTO syll_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Mabude Musa nobire aro ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Harune zedin imamotir ḳelafoti shomzia ḳamo boail oiba, ou din Harun ar tar fuainte dan-gomor sodgar niom mafik dui sher moyda Mabudor dorbaro anba. Itar ordeḳ biane ar ordeḳ hainja bala diba. ");
INSERT INTO syll_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Tara tel dia ḳai banaia taoat sekia harle ita ṭukra ṭukra ḳoria Mabudor samne dan-gomor sodga hishabe azir ḳorba, itar dumar gerane Mabud kushi oin. ");
INSERT INTO syll_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Harunor bade tar ze fuare fordan imam hishabe ḳelafoti deoa oibo, he-o oula sodga adae ḳorbo. Ita to Mabudor hor-hameshakur faona, ou sodgar fura ongsho zalailite oibo. ");
INSERT INTO syll_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Imam oḳlor nizor deoa dan-gomor sodgar hokkolta zalailite oibo, ita ḳaoar kunu hukum nae.” ");
INSERT INTO syll_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Bade Mabude Musa nobire ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Tumi Harun ar tar fuaintore gunar koforar kurbanir niom hikao. Zalail kurbanir foshure ze zagat zobo ḳoroin, gunar koforar kurbanir foshure-o ono zobo ḳorba. I kurbanir gust to ḳas fobitro. ");
INSERT INTO syll_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Ze imame ou kurbani adae ḳorba, ein ou gust ḳaiba. Milon-tambur uṭano fobitro zagat ou gust ḳaite oibo. ");
INSERT INTO syll_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Zeta zinishe ou gustre soibo, ita fak-fobitro oizibo. Kunu ḳafoṛor maze zudi er lour siṭa lage, te fak-fobitro kunu zagat ita doite oibo. ");
INSERT INTO syll_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Ar maṭir ze fatilo ou gust randa oibo, ita bade bangilibae. Oile fitolor fatilo randile iṭa manjia fanidi doia fak-saf ḳorbae. ");
INSERT INTO syll_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Imam bongshor zekunu beṭainte ou kurbanir gust ḳaita farba, ita to ḳas fobitro gust. ");
INSERT INTO syll_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Oile gunar koforar kurbanir foshur lou zudi Milon-tambur bitre neoa oizae, te i kurbanir gust ḳaoa nished, ita zalailite oibo. ");
INSERT INTO syll_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“Dush-ḳosurir koforar kurbanir musla oilo, i kurbanir gust to ḳas fobitro. ");
INSERT INTO syll_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Zalail kurbanir foshure ze zagat zobo ḳora oy, ou kurbanir foshure-o ono zobo ḳorte oibo. Itar lou kurbani kanar sairo galabae siṭai dite oibo. ");
INSERT INTO syll_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ar itar hoḳol sorbire loibo, mani sorbi ala lenguṛ, feṭor bitoror hoḳoltar ufror sorbi, ");
INSERT INTO syll_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","er loge duio kiḍni ar otar ufror sorbi, ar ḳoiljar logor maṭia, i hoḳolta algaiba. ");
INSERT INTO syll_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Algaia imame ou hoḳolta nia Mabudor name agunit deoa kurbani hishabe kurbani kanar ufre zalailiba, ita oilo dush-ḳosurir koforar kurbani. ");
INSERT INTO syll_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Kurbanir gust imam foribaror zekunu beṭa manshe ḳaita farba. Ita to ḳas fobitro zinish, erlagi tara zekunu pak zagat boia ḳaite oibo. ");
INSERT INTO syll_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“Gunar koforar kurbani ar dush-ḳosurir koforar kurbanir niom-ḳanun to eḳoi nomunar. Ze imam sabe ou koforar kurbanire adae ḳorba, ein ou gust faiba. ");
INSERT INTO syll_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Ar ze imame zalail kurbani adae ḳorba, ein ou kurbanir foshur samṛa-o nita farba. ");
INSERT INTO syll_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Luaṛit, taoat ba tunduri undalo hedia ana dan-gomor sodgar ruṭi kali hou imame faiba, zein i sodga adae ḳorsoin. ");
INSERT INTO syll_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Oile dan-gomor bad-baki hoḳol sodga, ita tel maḳail ba hukna zekunu laḳan ouk, imam Harunor hoḳol fuainte itar homan baṭ faiba. ");
INSERT INTO syll_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“Mabudor name deoa salamoti kurbanir niom oilo, ");
INSERT INTO syll_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","kunu manshe zudi Mabudor shukria adae ḳorar kiale salamoti kurbani dey, te ou kurbanir foshur loge tel mishail nireḳ moyda dia ḳamir saṛa ruṭi ba banail ruṭit tel maḳaia loia aibo, ba tel mishail ḳamir saṛa nireḳ moydar fiṭa banaia ante oibo. ");
INSERT INTO syll_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Shukria adae ḳorar kiale salamoti kurbanir zinishor loge ḳamir ala tuṛa ruṭi-o anbo. ");
INSERT INTO syll_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Mabudor name deoar lagi he ou forteḳ zinish taki eḳṭa eḳṭa ḳori anbo. Ze imame salamoti kurbanir foshur lou siṭaiba, ein ita faiba. ");
INSERT INTO syll_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Shukurana adae ḳorar niote deoa ou kurbanir gust ou din-u ḳailite oibo. Ita bador din biankur lagi toa zaito nae. ");
INSERT INTO syll_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“Ou salamoti kurbani zudi kunu mannot adae ḳorar niote deo, ba emne kushi oia kurbani deo, te itar gust ou din-u ḳaio, ar kisu baki roile bador dino ḳaitae farbae. ");
INSERT INTO syll_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Oile dui din bade i gust roile, ita zalailite oibo. ");
INSERT INTO syll_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Tin nombor din i gust ḳaile kurbani kobul oito nae. Kurbani deorar amol-namat ita uṭto nae, ou gust to nafak oigese, kunu manshe ita ḳaile tare naforman hishabe gona oibo. ");
INSERT INTO syll_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“Salamoti kurbanir gustor maze nafak kunu zinish lagigele, i gustor i ongsho ar ḳaoa zaito nae, ita zalailiba. Oile baki gust ḳaoa zaibo, fak-saf halote ze kunu zone ita ḳaita farba. ");
INSERT INTO syll_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Ar nafak halote kunu manshe zudi Mabudor name deoa ou salamoti kurbanir gust ḳailae, te shomaz taki tar nam miṭailite oibo. ");
INSERT INTO syll_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Kunu manshe zudi foshur ba manshor kunu nafak zinish soia hari ba dusra nafak kunta soia hari Mabudor name deoa salamoti kurbanir gust ḳailae, te tar nam-o shomaz taki miṭailite oibo.” ");
INSERT INTO syll_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Ar Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Tumi Boni Israilre zanai deo, tumra goru-sagol ba meṛar kunuzat sorbi kaio na. ");
INSERT INTO syll_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Kunu mora foshur ba zongli zanuare mara foshur sorbire tumra oinno kunu ḳamo lagaitae farbae, oile ḳaitae fartae nae. ");
INSERT INTO syll_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Zoto nomunar foshu dia Mabudor name agunit deoa kurbani adae ḳora oy, ita zator foshur sorbi zegue ḳaibo, tar namre shomaz taki miṭailibae. ");
INSERT INTO syll_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Tumra zekunu zagat boshot ḳoro na ḳene, kunuzat foshu ba fakir lou ḳaoa zaiz nae. ");
INSERT INTO syll_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Kunu manshe zudi lou ḳae, te shomaz taki tar nam miṭailite oibo.” ");
INSERT INTO syll_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Bade Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Tumi Boni Israilre zanai deo, zekunu manshe kunu foshu dia salamoti kurbani adae ḳorle, kurbanir gustor eḳṭa ongsho Mabudor dorbaro dite oibo. ");
INSERT INTO syll_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Mabudor name agunit deoa kurbanir ou ongsho, mani sina ar sinar ufror sorbi he nizor ate ania imam sabre dibo. Imame itare usa ḳoria Mabudor samne dulaiba. ");
INSERT INTO syll_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Bade tain sorbire kurbani kanar ufre zalailiba, oile ou sinar gust imam Harun ar tan fuainte faiba. ");
INSERT INTO syll_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Salamoti kurbanir foshur ḍainor ranor gust imam sabre dilaibae. ");
INSERT INTO syll_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Imam Harunor bongshor ze ḳeu salamoti kurbanir foshur lou ar sorbire kurbani diba, tan faona hishabe ou ranor gust niba. ");
INSERT INTO syll_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Boni Israilor deoa hoḳol salamoti kurbanir gust taki dulona kurbanir sina ar ḍainor ranor gust ami imam Harun ar tar fuaintore dilam. Boni Israilor deoa kurbanir i ongsho oilo tarar hameshakur faona hok.” ");
INSERT INTO syll_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Harun ar tar fuaintore zedin taki imamotir ḳamo boail ḳora oisil, hou din taki Mabudor name agunit deoa hoḳol nomunar kurbanir ou ongshore tarar faona hok hishabe dora oise. ");
INSERT INTO syll_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Tarare zedin ḳelafoti shomzaia boail ḳora oise, hou din Mabude Boni Israilre hukum disla, kurbanir gustor ou ongsho hor-hamesha erare dibar lagi. ");
INSERT INTO syll_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Ita oilo zalail kurbani, dan-gomor sodga, gunar koforar kurbani, dush-ḳosurir koforar kurbani, imamoti shomzibar sodga, ar salamoti kurbanir niom. ");
INSERT INTO syll_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Sinai morubumit Mabude zedin Boni Israilre hukum disla tan name kurbanir zinish anar lagi, hou din tain Tur faṛor ufre Musa nobire ou hokkol niom-ḳanun zanaisla. ");
INSERT INTO syll_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Bade Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Tumi Harun ar tar fuaintore loia amar gese azir o. Er loge tarar imamotir lebas, ḳelafoti shomzibar tel, gunar koforar kurbanir bisal, dugu meṛar faṭa ar ḳamir saṛa ruṭir ṭukri-o anio. ");
INSERT INTO syll_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Ar tumi tamam Boni Israilre Milon-tambur duaror ḳandat dola ḳoro.” ");
INSERT INTO syll_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Teu Mabudor hukum mafik Musa nobie hoḳolta ḳorla, hoḳol Boni Israil Milon-tambur duaror ḳandat dola oila. ");
INSERT INTO syll_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Ou shomoy Musae erare ḳoila, “Mabude hukum disoin ita ḳorar lagi.” ");
INSERT INTO syll_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Oḳan ḳoia tain imam Harun ar tan fuaintore samne ania fani dia naoaila. ");
INSERT INTO syll_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Bade tain Harunre imamoti lebasor fainjabi findaia hari komror bondoni bandia dila. Tain alḳella ar efron findaia feṭor ufror noksha ḳora ḳafoṛre fitadi bandi dila. ");
INSERT INTO syll_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Bade bukur ufror toli findaia er bitre fobitro Urim ar Tummim haraila. ");
INSERT INTO syll_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Erbade Harunor matat faugṛi findaia hou fobitro taz, mani shunar fatḳan faugṛir samnabae lagaila. Musae i hoḳolta ḳorla Mabudor hukum mafik. ");
INSERT INTO syll_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Bade tain Milon-tambu ar er bitoror hoḳol mal-samanare ḳelafotir tel dia fobitro ḳorla. ");
INSERT INTO syll_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Ou tel taki tuṛa tel nia tain kurbani kanar ufre shatbar siṭaila. Kurbani kana ar er logor hoḳol mal-samana, hanḍi-bashon, ar uzur fanir gamla ar er tolor soki-kaṭre, tel dia fak-fobitro ḳorla. ");
INSERT INTO syll_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Aro tuṛa tel nia imam Harunor matar maze ḍalia tanre fak-fobitro bonar lagi kelafoti dila. ");
INSERT INTO syll_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Ar Harunor fuaintore samne ania tarar gotro fainjabi findaila, ḳomror bondoni bandia hari matar toki findaila. Ita hoḳolta ḳorla tain Mabudor hukum mafik. ");
INSERT INTO syll_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Erbade tain gunar koforar kurbanir bisal anla, anle Harun ar tan fuainte bisalor ḳolla atai dila. ");
INSERT INTO syll_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Teu Musae ou bisalre zobo ḳoria ogur kisu lou nia, kurbani kanare fak-saf ḳorar kiale oḳanor hing oḳlor maze ator anguildi lou maḳaila. Baki lou tain kurbani kanar tole ḍali dila. Ou nomunae tain gunar koforar kurbanir lou dia kurbani kanare fak-saf ḳorla. ");
INSERT INTO syll_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Bade tain bisalor feṭor bitoror hoḳol sorbi, ḳoiljar logor maṭia, sorbi shomet duio kiḍni nia kurbani kanar ufre zalailila. ");
INSERT INTO syll_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Oile bisalor ḳal, gust, gufor nia tain kempor bare zalaila. Musae ita hoḳolta ḳorla Mabudor hukum mafik. ");
INSERT INTO syll_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Bade tain zalail kurbanir meṛar faṭare anla. Anle Harun ar tan fuainte ogur ḳolla atai dila. ");
INSERT INTO syll_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Ar Musae ou meṛare zobo ḳoria kurbani kanar sairo galat lou siṭai dila. ");
INSERT INTO syll_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Tain meṛare ṭukraia ogur ḳolla, gustor ṭukra ar sorbire zalaila. ");
INSERT INTO syll_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Ar ou meṛar feṭor bitoror hoḳolta, tar sairo ṭeng fani dia doia hari, asta meṛare zalail kurbani hishabe kurbani kanar ufre zalailila. Ita to Mabudor name agunit deoa zalail kurbani, itar dumar gerane tain kushi oin. Musae ita hoḳolta ḳorla Mabudor hukum mafik. ");
INSERT INTO syll_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Bade tain imamoti kamo boailor niote, dusra meṛare ania harle Harun ar tan fuainte meṛar ḳolla atai dila. ");
INSERT INTO syll_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Musae ou meṛare zobo ḳoria, ogur tuṛa lou nia Harunor ḍain ḳanor lotit, ḍain ator ar ḍain faor buṛi angulit lagaila. ");
INSERT INTO syll_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Ar Harunor fuaintore-o samne ania, tarar ḍain ḳanor lotit, ar ḍain at, ḍain faor buṛi angulit tuṛa lou lagai dila. Aro tuṛa lou nia kurbani kanar sairo galat siṭai dila. ");
INSERT INTO syll_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Tain meṛar sorbi, sorbi ala lenguṛ, ḳoiljar logor maṭia, sorbi shomet duio kiḍni, ar ḍainor ran nila. ");
INSERT INTO syll_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Ar Mabudor samne toa ḳamir saṛa ruṭir ṭukri taki ekkan ruṭi, ar teldi baza ekkan fiṭa, ar tel maḳail ekkan ruṭi nia hou sorbi ar ranor ufre toila. ");
INSERT INTO syll_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Toia ita hoḳolta Harun ar tan fuaintor ato dia dulona kurbani hishabe Mabudor samne dulaila. ");
INSERT INTO syll_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Bade tain ita tarar at taki nia hari kurbani kanar foshur ufre toia zalailila. Ita to ḳelafoti shomzibar kurbani, Mabudor name agunit deoa kurbani, itar dumar gerane tain kushi oin. ");
INSERT INTO syll_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Bade tain nizor faona ongsho, mani kelafoti shomzibar kurbanir meṛar sina nia dulona kurbani hishabe Mabudor samne dulaila. Tain ita hoḳolta ḳorla Mabudor hukum mafik. ");
INSERT INTO syll_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Bade Musae ḳelafoti shomzibar tuṛa fobitro tel nila, ar kurbani kana taki tuṛa lou ania Harun ar tan fuaintor ufre ar tarar lebasor ufre siṭai dila. Ou nomunae Harun ar tan fuaintore, ar tarar lebasre-o fak-fobitro ḳora oilo. ");
INSERT INTO syll_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Bade Musae Harun ar en fuaintore ḳoila, “Tumra Milon-tambur duaror samne ou gust rando, randia hono boia ḳelafoti shomzibar ṭukrir ruṭi dia ota ḳao. Amare to age ou ḳota zanail oise, ita ḳali tumi ar tumar fuainte ḳaibae. ");
INSERT INTO syll_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Ḳanir bade zeta gust ar ruṭi baki roibo, itare aguindi zalailio. ");
INSERT INTO syll_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Tumrare ḳelafoti shomzibar ou mahfil shat din dori solbo. I shat din tumra Milon-tambur duaror ḳanda taki horio na. ");
INSERT INTO syll_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Aiz zeta ḳorlam, ita to tumrar gunar kofora hishabe Mabudor hukum mafik korlam. ");
INSERT INTO syll_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Te tumra zane basia roar lagi aiz taki shat din forzonto ou Milon-tambur duaror ḳandat roio. Din-rait ono roia Mabudor hukum mafik kam ḳorio. Tumra ola ḳorar lagi to ami hukum faisi.” ");
INSERT INTO syll_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Musa nobir mazdi Mabude zotota ḳorar hukum disla, Harun ar tan fuainte ita hoḳolta ḳorla. ");
INSERT INTO syll_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Ḳelafoti shomzibar mahfilor aṭ dinor din Musa nobie imam Harunre, tan fuaintore ar Boni Israilor murobbi oḳolre-o anaila. ");
INSERT INTO syll_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Anaia Harunre ḳoila, “Tumar gunar koforar kurbanir lagi tumi egu bisal ano, ar zalail kurbanir lagi egu meṛar faṭa loia Mabudor dorbaro azir o. Kurbanir foshu guin furafur nikut oito. ");
INSERT INTO syll_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Ar tumi Boni Israilre ḳo, tara zanu Mabudor namor kurbani loia azir oy. Tara gunar koforar lagi egu sagol, ar zalail kurbanir lagi eḳ bosor boyoshi nikut egu goru-basur, ar egu meṛa-baichcha ane, ");
INSERT INTO syll_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ar salamoti kurbanir lagi egu bisal ar egu meṛar faṭa loia azir oy. Itar loge tara tel maḳail dan-gomor sodga-o anba. Mabude tarare aiz didar diba, erlagi tara ota loia azir oukka.” ");
INSERT INTO syll_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Musa nobir hukum mafik tara hokkolta loia Milon-tambur samne aila. Hoḳol Boni Israil Mabudor samne aia ubaila. ");
INSERT INTO syll_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Ou shomoy Musae tarare ḳoila, “Mabude tumrare ita ḳorar lagi hukum disoin, ita adae ḳorle tumrar samne tan kudroti nur zair oibo.” ");
INSERT INTO syll_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Bade tain imam Harunre ḳoila, “Tumi gia kurbani kanar ḳandat zao, gia tumar nizor ar manshor gunar koforar lagi, zalail kurbani ar gunar koforar kurbani adae ḳoro. Ar manshor ana kurbani-o adae ḳoro, Mabude amare ola hukum disoin.” ");
INSERT INTO syll_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Teu imam Harun kurbani kanar ḳandat gia, tan nizor gunar koforar kurbanir basur zobo ḳorla. ");
INSERT INTO syll_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Zobor bade tan fuainte ogur lou loia tan daro gela. Tain ou lour maze angul ḍubaia tuṛa lou nia kurbani kanar hing oḳol-o maḳaila, ar baki lou kurbani kanar tole ḍalila. ");
INSERT INTO syll_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Mabude Musare zela hukum disla, imam Harune ṭik ou laḳan gunar koforar kurbanir basuror sorbi, duio kiḍni ar ḳoiljar logor maṭiare kurbani kanar ufre nia zalailila. ");
INSERT INTO syll_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Kurbanir gust ar samṛa nia tain kempor bare zalaila. ");
INSERT INTO syll_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Bade imam Harune zalail kurbanir meṛare zobo ḳorla. Tan fuainte ogur lou nia tan ato dila, tain ou loure kurbani kanar sairo galat siṭaila. ");
INSERT INTO syll_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Tara zalail kurbanir meṛar ḳolla ar gustor ṭukrain eḳ ek kori Harunor ato dila, tain ita kurbani kanar ufre zalailila. ");
INSERT INTO syll_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Meṛar ṭeng ar feṭor bitoror hoḳolta fani dia doia saf ḳoria, zalail kurbani foshur loge ita hokkolta-o kurbani kanar ufre zalailila. ");
INSERT INTO syll_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Bade tain shomazor manshor lagi kurbanir foshu oḳol anaila. Tain manshor gunar koforar kurbanir sagol zobo ḳorla, ar agor laḳan kurbani adae ḳorla. ");
INSERT INTO syll_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Erbade tain tarar zalail kurbanir foshure-o Mabudor hukum mafik kurbani dila. ");
INSERT INTO syll_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Ar dan-gomor sodgar lagi ana samana taki eḳ muiṭ nia hari kurbani kanar ufre zalaila. Ita saṛa-o tain biani balar hameshakur zalail kurbani adae ḳorla. ");
INSERT INTO syll_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Tain manshor salamoti kurbanir ou goru ar meṛare zobo ḳorla. Zobor bade tan fuainte ogur lou ania tan ato dila, lou nia tain kurbani kanar sairo galat siṭai dila. ");
INSERT INTO syll_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Ar imam Harunre hou goru ar meṛar loge lagail hoḳol sorbi, mani sorbi ala lenguṛ, feṭor bitoror hoḳoltar ufror sorbi, duio kiḍni ar otar ufror sorbi, ḳoiljar logor maṭia-o ania dila. ");
INSERT INTO syll_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Tara ou hoḳol sorbire hou foshur sinar ufre toila. Ar imam Harune ou sorbi nia kurbani kanar ufre zalaila. ");
INSERT INTO syll_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Musa nobir hukum mafik Harune bade kurbanir foshur sina ar ḍainor ran nia Mabudor samne dulona kurbani hishabe dulaila. ");
INSERT INTO syll_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Bade imam Harune manshor baedi tan at baṛaia tarare dua dila. Tain gunar koforar kurbani, zalail kurbani ar salamoti kurbani adae ḳoria harle, kurbani kana taki lamia aila. ");
INSERT INTO syll_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Erbade Musa nobi ar imam Harun gia Milon-tambur bitre hamaila, bade hon taki bar oia aia hoḳol manshore dua dila. Ou shomoy hoḳol manshor samne Mabude tan kudroti nur zair ḳorla. ");
INSERT INTO syll_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Mabudor ges taki kudroti aguin aia, kurbani kanar ufror zalail kurbanir foshu ar hokkol sorbire zalaia sali korililo. Ita dekia hoḳol manush kushie Subohan Alla ḳoia sik dia soizdat foṛla. ");
INSERT INTO syll_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Bade ola oilo, imam Harunor fua Nadab ar Abihue tarar zarzir agor-kushboy danit aguin zalaila, ar ou agunir ufre agor-kushboy dila. Tara Mabudor hukumor ulṭa gia dusra aguin dia Mabudor name agor-kushboy zalaila. ");
INSERT INTO syll_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Otar lagi Mabudor ges taki aguin lamia aia tarare zalaililo, tara Mabudor samne morigela. ");
INSERT INTO syll_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Teu Musae Harunre ḳoila, “Mabude to age-u zanai disla, Amar samne zera azir oy, tara amare fak-fobitro ḳoia manbo, hoḳol manshor samne amar gourob-mohima zair ḳorbo.” Ikan hunia Harun sufsaf roila. ");
INSERT INTO syll_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Bade Musae Harunor sasa Ujjolor fuain Mishayel ar Elzafonre ḳobor dia anaila, anaia ḳoila, “Tumra Herem Shorifor samon taki tumrar duio batizar lashre bar ḳoria kempor bare neo.” ");
INSERT INTO syll_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Tan hukum faia tara gia Nadab ar Abihur lashre imamoti fainjabir ḳafoṛo dori ṭania kempor bare nila. ");
INSERT INTO syll_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Bade imam Harun ar tan fuain Ali-Azor ar Isamarre Musae ḳoila, “Tarar moutor duke tumra nizor sulre aula-zaula ḳorio na, ar finnor ḳafoṛ-sufoṛ fario na. Ita ḳorle tumra-o morbae, ar asta shomazor ufre Mabudor gozobi gusa lambo. Oile Mabude zerare aguindi zalai marsoin, tarar duke tumrar kuṭum-ḳesh mani bad-baki Boni Israile mattom-ahazari korta farba. ");
INSERT INTO syll_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Tumrar gotro to Mabudor namor ḳelafoti shomzibar fobitro tel deoa oise, erlagi tumra Milon-tambur duaror bare zaio na, gele-u morbae.” Tara-o Musar ḳota manla. ");
INSERT INTO syll_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Erbade Mabude imam Harunre ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Tumi ar tumar fuainte anguror shorbot ba shorab ḳaia Milon-tambur bitre hamaio na, hamaile-u morbae. I hukum oarishor for oarish dori hor-hamesha manio. ");
INSERT INTO syll_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Kunṭa haram ar kunṭa halal, kunṭa fak ar kunṭa nafak, ita buzia-hunia solio. ");
INSERT INTO syll_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Ar ami Mabude Musar marfote Boni Israilre zoto hukum-ahkam bataisi, ita tarare talim dio.” ");
INSERT INTO syll_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Bade Harun ar tan baki duio fua Ali-Azor ar Isamarre Musae ḳoila, “Mabudor name agunit deoa kurbanir logor dan-gomor sodgar ze ongsho baki roise, ota dia ḳamir saṛa ruṭi banaia kurbani kanar ḳandat nia tumra ḳaio. Ita to ḳas fobitro zinish. ");
INSERT INTO syll_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Tumra fobitro Kaba goror shimanar bitre ota ḳaio. Mabudor name agunit deoa kurbanir ou ongsho to tumar ar tumar fuaintor faona. Mabude amare ola hukum disoin. ");
INSERT INTO syll_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Oile Mabudor name dulona kurbanir sina ar ranor gust tumra ar tumrar fua-fuṛinte-o ḳaitae farbae. Zekunu fak-saf zagat boia tumra ita ḳaio. Boni Israilor hoḳol salamoti kurbanir gustor ou ongsho tumrare ar tumrar fua-fuṛintore deoa oise. ");
INSERT INTO syll_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ou kurbanir foshur sorbi zebla ana oibo, ou shomoy dulona kurbanir lagi sina ar ranor gust-o ana lagbo. Mabudor hukum mafik ou ran ar sinar gust tumi ar tumar fua-fuṛintor siroḳalin faona.” ");
INSERT INTO syll_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Bade Musae kub kiali oia tallashi koria zanla, ze sagol dia gunar koforar kurbani adae ḳora oisil, ogur hoḳol gust tara zalailise. Erlagi Musae Harunor baki duio fua Ali-Azor ar Isamaror ufre gusa ḳoria ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Gunar koforar kurbanir gust tumra Kaba goror shimanat ḳailae na ḳene? Ita to ḳas fobitro zinish. Mabudor samne Boni Israilor gunar kofora adae ḳoria, tarar dush-ḳosuri mafir lagi ita to tumrare deoa oisil. ");
INSERT INTO syll_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Kurbanir sagolor lou zebla Herem Shorifor bitre neoa oise na, te amar hukum mafik itar gust to tumra Kaba goror shimanar bitre ḳaoa zorur asil.” ");
INSERT INTO syll_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Harune zuaf dila, “Aiz Mabudor samne tarar gunar koforar kurbani ar zalail kurbani adae ḳorar bade amar ufredi otota goṭilo. Te aizkur dino ami ou kurbanir gust ḳaile Mabud kunu kushi oiba ni?” ");
INSERT INTO syll_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","I zuaf hunia Musa nobi kushi oila. ");
INSERT INTO syll_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Mabude Musa ar Harunre ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Tumra Boni Israilre zanai deo, maṭir ufror foshur maze zeta foshu tumrar lagi halal, ota oilo: ");
INSERT INTO syll_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","“Zeta foshur faor kura furafur sira, ar ḳanire fazae, itar gust tumrar lagi halal. ");
INSERT INTO syll_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Ta-o er mazor kunu kunu foshue ḳali kanire fazae, ar kunu kunu foshur ḳali kura sira, ita to tumrar lagi haram. Uṭe ḳanire fazaileo tar kura sira nae, erlagi uṭ haram. ");
INSERT INTO syll_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Shafon-undure ḳanire fazaileo, itar kura sira nae, otar lagi ita-o haram. ");
INSERT INTO syll_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Ḳorgushe-o ḳanire fazae, oile itar kura sira nae, otar lagi haram. ");
INSERT INTO syll_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Shuoror kura furafur sira, oile itae ḳanire fazae na, erlagi ita tumrar lagi haram. ");
INSERT INTO syll_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Itar gust tumrar lagi haram, itar mora lashre-o soio na. Ita tumrar lagi nafak. ");
INSERT INTO syll_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“Fanir maze zeta zandare boshot ḳoroin, itar maze zetar foir ar ḍaḳna ase, ita tumrar lagi halal. ");
INSERT INTO syll_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Oile zetar foir ar ḍaḳna nai, ita tumrar lagi nazaiz. Ita fanir maze fal bandia gurra zandar ouk ba aro kunu zandar ouk, itare tumra ginnaio. ");
INSERT INTO syll_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Nazaiz oae itare haram mono ḳorio, ita tumra ḳaio na. Itar mora lashre-o tumra ginnaio. ");
INSERT INTO syll_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Fanir maze boshot ḳore, oile kunu foir ba ḍaḳna nai, ilaḳan hoḳol zandarre tumra ginnaio. ");
INSERT INTO syll_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“Ar faki oḳlor mazor ou laḳan fakire tumra ginnaio, ita tumra ḳaio na. Ota oila, boṛo sil, hokun, haf-ḳauri, ");
INSERT INTO syll_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","hoḳol zator sil, hoḳol zat ḳaua, ");
INSERT INTO syll_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","uṭ faki, ");
INSERT INTO syll_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","nim faki, gangsil, hoḳol nomunar baz faki, ");
INSERT INTO syll_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","hoḳol zat fesa, hoḳol zator kuṛa, sola-kak, bolua faki, ");
INSERT INTO syll_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","fani-ḳauri, ");
INSERT INTO syll_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","hoḳol zator zaṭia, hoḳol zator bogla, mon-sura faki ar badur, ita tumrar lagi haram. ");
INSERT INTO syll_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“Fuk-foring oḳlor maze ou laḳan fuk-foring tumrar lagi nazaiz, zetae faodi aṭe ar uṛal dey, itare tumra ginnaio. ");
INSERT INTO syll_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Oile itar mazor zetar aṭu ase, ar maṭir ufre falai falai sole, itar mazor kunu kunuṭa tumrar lagi halal. ");
INSERT INTO syll_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Ita oilo, hoḳol zator fongofal, baga-foring, gash-foring. ");
INSERT INTO syll_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Oile ita saṛa bad-baki zoto fuk-foringe sair faoe aṭe ar uṛito fare, ita hoḳolta tumra ginnaio. ");
INSERT INTO syll_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“Tumra ou laḳan ḳam ḳorle nafak oizibae; kunu manshe zudi ou haram foshu, faki, mas, fuk-foring otar mora lash soilae, te he hainja forzonto nafak roibo. ");
INSERT INTO syll_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Ar ḳeu zudi ota haram zinishor lashor kunu ongshore atdi doria boia ney, te he tar ḳafoṛ-sufoṛ doia dite oibo, ar hainja forzonto nafak roibo. ");
INSERT INTO syll_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“Ar zeta foshur faor kura furafur sira nae, ba ze foshue ḳanire fazae na, ita to tumrar lagi haram. Ou haram foshure ze zone soibo, he nafak bonizibo. ");
INSERT INTO syll_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Sair faoe aṭra zanuar oḳlor maze, ze foshue faor talut bor dia aṭe, ita-o tumrar lagi haram. Ḳeu zudi itar mora lash soilae, te hainja forzonto nafak roibo. ");
INSERT INTO syll_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Ar kunu manshe zudi itar lash atdi doria boia ney, te tar ḳafoṛ-sufoṛ doia dite oibo, ar hainja forzonto he nafak roibo. Ita zanuar oḳol to tumrar lagi haram. ");
INSERT INTO syll_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“Ar maṭit solra huru-muru zandaror maze neul, undur, hoḳol zator girgiṭi, ");
INSERT INTO syll_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ṭikṭiki, guil-haf, moi-haf, ainjail ar ḳaklash, tumrar lagi haram. ");
INSERT INTO syll_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Maṭit solra huru-muru zandaror mazor ou zator zandar to tumrar lagi nazaiz. Itar mora lash ḳeu soile, he hainja forzonto nafak roibo. ");
INSERT INTO syll_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Otar mazor zekunu egur mora lash zudi oinno zinishor ufre foṛe, zelan laḳṛi, ḳafoṛ-sufoṛ, samṛa ba solar soṭ dia banail zekunu malor ufre foṛle-u ita nafak oizibo. Nafak malre fanit bizaia toibae. Hainja forzonto ita nafak roibo, bade fak-saf oibo. ");
INSERT INTO syll_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Ar ou nafak zandaror kunuṭar mora lash zudi kunu maṭir bashonor maze foṛe, te igur bitoror hoḳolta nafak oizibo, i bashonre-o bangilibae. ");
INSERT INTO syll_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Ou bashonor fani ba rosh zudi kunu ḳanir zinishor ufre foṛe, te i kani nafak oizibo. Ikṭar maze zudi fani zatio kunuta toa taḳe, te ita-o nafak oizibo. ");
INSERT INTO syll_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Ar otar mora lash zudi kunu zinishor ufre foṛe, te ita nafak oizibo. Ita kunu undalo foṛle, i undal bangilibae. I undal to tumrar lagi nafak, itare nafak goinno ḳorio. ");
INSERT INTO syll_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Oile ita zudi kunu kuar bitre ba indarar maze foṛe, te i kua ba indara nafak oito nae. Ḳali itar mora lash ze zone soibo, he nafak oizibo. ");
INSERT INTO syll_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Zomino bain dibar niote toa kunuzator bisor ufre zudi otar lash foṛe, te ita nafak oito nae. ");
INSERT INTO syll_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Oile kunu bisor ufre fani dia bizanir bade zudi ita foṛe, te i bis tumrar lagi nafak. ");
INSERT INTO syll_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“Tumrar halal kunu foshu morigele, igur lash ze zone soibo, he hainja forzonto nafak roibo. ");
INSERT INTO syll_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Ḳeu zudi ou mora foshur gust ḳae, te he tar ḳafoṛ-sufoṛ doia dite oibo, ar he hainja forzonto nafak roibo. Ar ḳeu zudi ou foshur lashre at dia tule, te he tar ḳafoṛ-sufoṛ doia dite oibo, he-o hainja forzonto nafak roibo. ");
INSERT INTO syll_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“Huno, maṭir maze solra hoḳol zator huru-muru zandar ḳaoa tumrar lagi haram, itare tumra ginnaio. ");
INSERT INTO syll_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Ita buke solra zandar ouk, ba sair faoe aṭra zandar ba bout faoe solra ouk, hoḳol nomunar maṭit solra huru-muru zandar tumra ḳaio na, itare ginnaio. ");
INSERT INTO syll_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Tumra ita kunutar lagi nizore ginnar zon banaio na, ba otae-o zanu tumrare nafak na banae. ");
INSERT INTO syll_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Mono rakio, ami Alla-u tumrar Mabud. Amar niote tumra nizore fak-fobitro rakio. Zano to, ami nize-o fobitro. Erlagi maṭit solra kunu huru-muru zandaror lagi tumra nizore nafak banaio na. ");
INSERT INTO syll_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ami to Alla, ami tumrar Mabud oar kiale, Mishor desh taki tumrare bar ḳori anchi. Ami nize fobitro, erlagi tumra-o fobitro roio. ");
INSERT INTO syll_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“Te foshu, faki, fanit boshot ḳorra zandar, ar maṭir maze solra hoḳol nomunar huru-muru zandaror befare tumra amar hukum-ahkam manio. ");
INSERT INTO syll_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Kunṭa tumrar lagi zaiz ar kunṭa nazaiz, kun foshur gust halal ar kunṭa haram, ita tumra buzia-hunia solio.” ");
INSERT INTO syll_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Erbade Mabude Musa nobire ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Tumi Boni Israilre zanai deo, kunu beṭir goro zudi kunu fuar zonom oy, te beṭiara bemaror shomoykur laḳan i beṭi nafak roibo. Tair ou nafaki halot shat din roibo. ");
INSERT INTO syll_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Bade aṭ dinor din fuare mosolmani kam ḳoraite oibo. ");
INSERT INTO syll_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Ar ou beṭir hurutta zonmor lou zaoar ḳarone tetrish din forzonto nafak roibo. Ou miad na fura forzonto tai kunu fobitro zinisho dora-soa zaiz nae. Ar fobitro Kaba goror shimanat zaibar hukum nae. ");
INSERT INTO syll_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Oile i beṭir goro zudi fuṛir zonom oy, te beṭiara mashik bemaror laḳan tai nafak roibo, ta-o i nafaki halot fura dui hafta solbo. Bade ou bemar taki pak-pakiza oar lagi aro soyshoṭṭi din bar saibo. ");
INSERT INTO syll_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“Fua ba fuṛir zonmor bade pak-pakiza oar shomoy aile, beṭie kurbani adae ḳorar niote Milon-tambur duaror ḳandat imam sabor gese zaibo. Zaite zalail kurbanir lagi eḳ bosor boyoshi egu meṛa, ar gunar koforar kurbanir lagi egu faro ba ḍufi faki loge nibo. ");
INSERT INTO syll_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Teu imam sabe Mabudor samne ou kofora adae ḳoria lou zaoa bemar taki beṭire pak-pakiza ḳorba. Beṭintor goro fua ba fuṛir zonmor bade pak-pakiza oar lagi ou niom zari roilo. ");
INSERT INTO syll_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Ar kurbanir lagi meṛa anar tofik zudi na taḳe, te dugu faro ba ḍufi faki anbo. Ermazor egu oibo zalail kurbani, ar dusraṭa gunar koforar kurbani. Ou nomunae imam sabe kurbani adae ḳoria taire nafaki taki basaiba, teu i beṭi pak-pakiza bonbo. ");
INSERT INTO syll_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Bade Mabude Musa ar Harunre ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Kunu manshor gotror samṛar kunu zaga zudi aḳta fuli zae, ba kunu kulosh uṭe ba kunuzat dag deḳa zae, ar mono shondoy oy zen, ita bade fosa-kusṭo bemar oito fare, te imam Harun ba tan fuaintor mazor kunu imamor gese tare loia zaibae. ");
INSERT INTO syll_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Imam sabe tar samṛar ou zaga deḳba, hi zagar ruma zudi dola oizae, ar buza zae i bemar samṛar tolor gustor maze lagigese, te buzbae, ita nafak fosa-kusṭo bemar. Ila bemari deḳle imame tare nafak koia elan ḳorba. ");
INSERT INTO syll_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Oile tar samṛar maze ou dag zudi kali dola oy, ar ita samṛar tolor gustor maze na lage, onor ruma dola na oy, te imam sabe ou zonre shat din dori hoḳol manshor ges taki horai raḳba. ");
INSERT INTO syll_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Bade shat dinor din tare hirbar deḳba. Zudi deḳa zae, ou bemar samṛar toledi na gia zela asil ola roise, te imame tare aro shat din alga raḳba. ");
INSERT INTO syll_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Ar hirbar shat dinor din tare deḳba, ermaze zudi tar bemar na baṛia hukaia ḳomi zae, te buzba, ita ḳali kulosh uṭse. Imame tare fak-saf ḳoia elan ḳorba. He tar ḳafoṛ-sufoṛ doia hari fak-saf bonbo. ");
INSERT INTO syll_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Oile imame tare fak-saf ḳoia elan ḳorar bade zudi tar gotror kulosh aro baṛi zae, te tare hirbar imamor gese deḳaibae. ");
INSERT INTO syll_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Imame hirbar deḳba, zudi ou bemar samṛar ufre aro baṛi zae, te buza zaibo, ita nafak fosa-kusṭo bemar, tain ere nafak koia elan ḳorba. ");
INSERT INTO syll_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Kunu manshor samṛat fosa-kusṭo bemaror laḳan deḳa gele tare nia imam sabor gese deḳaibae. ");
INSERT INTO syll_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Imame deḳba, tar gotro kunu zagar samṛar ufre zudi dola oia fuli zae, ar honor ruma dola oizae, ou fula zagat ḳasa ga taḳe, ");
INSERT INTO syll_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","te to iṭa eḳṭa furana fosa-kusṭo bemar. Imame tare nafak koia elan ḳorba. Tare forikkar lagi shomazor manshor ges taki kunu miade duroi raḳar zorur nae, he to emne-u nafak halote ase. ");
INSERT INTO syll_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Oile i bemar zudi asta shorilo oizae, ar imame shorilor zoto zaga deḳta faroin, ota dekia zudi tan mono oy, i bemar mata taki fao forzonto ase, ");
INSERT INTO syll_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","te tare aro balamonte deḳba, ar dekia zudi buza zae, i bemare tar asta gotor dola oigese, te tare fak-saf ḳoia elan ḳorba. Tar asta gotor dola oae he nafak nae. ");
INSERT INTO syll_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Oile erbade zudi kunu ḳasa ga deḳa dey, te he nafak. ");
INSERT INTO syll_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Imame ou ga dekia tare nafak koia elan ḳorba. Ou ga to nafak, tar nafak fosa-kusṭo bemar oise. ");
INSERT INTO syll_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Bade ou ḳasa ga hukaia zudi dola oizae, te tare hirbar imamor gese niba. ");
INSERT INTO syll_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Imame tare hirbar deḳba, tar asta gotror bemar zudi furafur dola oizae, te imame tare fak-saf ḳoia elan ḳorba, he ashole-u fak-saf. ");
INSERT INTO syll_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Kunu manshor gotro zudi boron oia iṭa bala oizae, ");
INSERT INTO syll_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ar ou zaga bade dola oia fuli zae, ba lalṭi-dola dag oy, te tare imamor gese niba. ");
INSERT INTO syll_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Imame tare deḳba, hi bemar zudi samṛar tole gia gustor maze lagizae, ruma dola oizae, te iṭa to boronor zagat zonom loa fosa-kusṭo bemar, imame tare nafak koia elan ḳorba. ");
INSERT INTO syll_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Oile imame kunu dola ruma na deḳle, ar ou ga zudi samṛar tole na gia hukaizibar laḳan oy, te imame tare shat din forzonto shomaz taki alog raḳba. ");
INSERT INTO syll_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Bade zudi deḳa zae, ita samṛar ufre sitri zar, te imame tare nafak koia elan ḳorba, ita eḳlaḳan fosa-kusṭo bemar. ");
INSERT INTO syll_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Oile kunu laḳan ḳom-beshi na oile, na sitrile buza zaibo ita ḳali boronor dag, imame tare fak-saf ḳoia elan ḳorba. ");
INSERT INTO syll_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Kunu manshor gotror kunu ongsho zudi aguine zoli zae, ar ou zolar zagat ḳasa gar maze lalṭi ba dola dag deḳa dey, ");
INSERT INTO syll_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","te imame tare forikka ḳori deḳba. Ar zudi deḳa zae, ruma dola oigese, ou ga samṛar tole gia gustor maze lagigese, te iṭa to zalail zagat zonom loa fosa-kusṭo bemar oia bar oise. Ita to nafak fosa-kusṭo bemar, erlagi imame tare nafak koia elan ḳorba. ");
INSERT INTO syll_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Oile imame forikka ḳoria zudi deḳoin, i zagar ruma dola oise na, ar ga sitria gia gustor maze na lagia mili zar, te imame tare shat din forzonto shomaz taki alog raḳba. ");
INSERT INTO syll_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Bade imame shat dinor din tare hirbar deḳba, zudi deḳoin, ou bemar baṛi zar, te imame tare nafak koia elan ḳorba. Ita eḳlaḳan nafak fosa-kusṭo bemar. ");
INSERT INTO syll_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Oile i zaga zudi kunu ḳom-besh na oia zela asil ola taḳe, ar samṛar maze na sitria mili zaoat roy, te ita aguine zolar fula ḳoia dora oibo. Ita to eḳlaḳan zolar dag, ar imame tare fak-saf ḳoia elan ḳorba. ");
INSERT INTO syll_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Ar kunu beṭa ba beṭir mata ba daṛi-musor maze zudi kunu gar alamot deḳa dey, ");
INSERT INTO syll_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","te imam sabe tare forikka ḳori deḳba. Tain zudi deḳoin, bemari zagar sul ba rum oldia oia sikon oigese, ar ga samṛar tole gia gustor maze lagigese, te iṭa to eḳlaḳan daud-ḳauzlir muk, ita daṛi-mus ba matar samṛat fosa-kusṭo bemar bar oise. Erlagi imame tare nafak koia elan ḳorba. ");
INSERT INTO syll_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Oile imame zudi bemar forikka ḳoria deḳoin, i ga samṛar tole gese na, ar onor sul ba rum to ḳala nae, te ou bemarire shat din forzonto shomaz taki alog raḳba. ");
INSERT INTO syll_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Bade shat dinor din imame hirbar forikka ḳori zudi deḳoin, i daud-ḳauzli bemar baṛse na, ba sul-rumo oldia oise na, ar onor ga samṛar tolor gustor maze lagse na, ");
INSERT INTO syll_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","te ou daud-ḳauzlir zaga bad dia, tar shorilor bad-baki sul ba daṛi-mus ḳamailite oibo. Bade imame tare aro shat din shomaz taki alog raḳba. ");
INSERT INTO syll_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Ar shat dinor din imame hirbar forikka ḳoria zudi deḳoin, i daud-ḳauzli samṛar ufre sitrise na, ba samṛar toledi gustor maze-o lagse na, te imame tare fak-saf ḳoia elan ḳorba. Ar he ḳafoṛ-sufoṛ doia hari pak-pakiza bonbo. ");
INSERT INTO syll_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Ta-o imame tare fak-saf ḳoia elan ḳorar bade-o zudi i daud-ḳauzli samṛar ufre sitri zae, ");
INSERT INTO syll_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","te imame tare hirbar deḳba. Tain zudi deḳoin, i daud-ḳauzli sitri gese, te sul ba rum oldia oise ki na ita ar forikka ḳorar zorur nae, he to emne-u nafak. ");
INSERT INTO syll_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Oile imame zudi mono ḳoroin, ita zela asil ola-u roise, ar i zagat ḳala ruma uṭer, te buzba, ita bala oigese. He to pak-pakiza ase. Imame tare fak-saf ḳoia elan ḳorba. ");
INSERT INTO syll_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Kunu beṭa ba beṭir samṛar maze zudi dola soḳsoḳa dag deḳa zae, ");
INSERT INTO syll_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","te imame tare forikka ḳori deḳba. Tain zudi deḳoin, tar dag dola fainsha oigese, te iṭa to ḳali dol-fisti oise. Itae kunu ḳeti oito nae, he to fak-saf ase. ");
INSERT INTO syll_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Ar kunu manshor zudi matar sul foṛia ṭaḳ oizae, te he nafak oito nae. ");
INSERT INTO syll_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Tar matar samnor galar sul foṛia zudi kofalor bae ṭaḳ foṛi zae, te he-o nafak oito nae. ");
INSERT INTO syll_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Oile i ṭaḳ foṛa mata ba ḳofalor maze zudi lalṭi dag deḳa dey, te buzbae, tar mata ba ḳofalo fosa-kusṭo bemar bar oise. ");
INSERT INTO syll_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Ar imam sabe tare forikka ḳoria zudi deḳoin, tar ḳofalo ba matat nafak fosa-kusṭo bemarir laḳan hou dag to fuli gese, ");
INSERT INTO syll_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","te buza zaibo, tar nafak fosa-kusṭo bemar oise, he to nafak. Tar matar ou bemaror lagi imame tare nafak koia elan ḳorba. ");
INSERT INTO syll_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Ar ou laḳan fosa-kusṭo bemar ze manshor oibo, he fara-sira ḳafoṛ findite oibo. Tar matar sul aula-zaula roibo. Tar mukre hijabor laḳan ḳafoṛdi guria sillai sillai koibo, nafak, nafak. ");
INSERT INTO syll_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","I bemar tar gotro zotodin roibo, otodin he nafak halote roibo. He Boni Israilor kempor bare eḳla eḳla roibo. ");
INSERT INTO syll_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Kunu ḳafoṛor maze zudi saba saba dag lage, ulor ḳafoṛ ba suti kafoṛor maze zudi feukni foṛar alamot mile, ");
INSERT INTO syll_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ita ulor ḳafoṛ ba suti kafoṛ bananir ṭana ba tator maze ouk, ba samṛa ar samṛadi banail zekunu zinishor maze zudi feuknir dag mile, ");
INSERT INTO syll_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ar finnor ḳafoṛor ṭana ba tator maze, samṛar kunu zinisho zudi lalṭi ba ḳosua kunuzat dag mile, te ita oilo feuknir alamot. Ila oile imam sabor gese deḳani lagbo. ");
INSERT INTO syll_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Imam sabe ita balamonte forikka ḳori dekia, ou zinishre shat din hoḳolta taki horaia raḳba. ");
INSERT INTO syll_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Bade shat dinor din imame hirbar deḳba. Tain zudi deḳoin, ou ḳafoṛor ṭanat ba tato, ba samṛar zinisho lalṭi ba ḳosua dag baṛise, te hou feukni bemar boṛo marattoḳ, ou zinish to nafak. ");
INSERT INTO syll_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Erlagi i kafoṛ, ba samṛar ou zinish, gamsa ba uṛna zetar maze ila feuknir dag milbo, ita hasribo ḳori hoḳolta zalailite oibo. ");
INSERT INTO syll_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Oile imame zudi deḳoin, i kafoṛ ba samṛar zinishor dag na sitria eḳoi zagat roise, ");
INSERT INTO syll_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","te tain itare fanidi doia dibar hukum diba. Doia hari ou zinishre shat din dusra hoḳolta taki horai raḳba. ");
INSERT INTO syll_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Bade imame hirbar deḳba. Tain zudi deḳoin, i feuknir dag kunubae na sitrile-o agor laḳan rong roise, te ita nafak. Igur ulṭa-baṭiol zekunu galabae i dag rouk, igure aguindi zalailite oibo. ");
INSERT INTO syll_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Oile ita doia deoar bade zudi imame deḳoin, i zagar rong fainsha oigese, te ou zaga siṛia falai dibae. ");
INSERT INTO syll_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Ar doar bade-o zudi ou zinisho hirbar feuknir dag deḳa zae, te buzbae, ita sitri zaoa bemar, erlagi i zinishre aguindi zalailibae. ");
INSERT INTO syll_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Ar ou zinish doar bade zudi deḳoin, ou dag milaigese, te ita hirbar doia harle fak-saf buzbae. ");
INSERT INTO syll_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","“Ou niom-ḳanun mania ulor ḳafoṛ, suti kafoṛ ba samṛar kunu zinisho feuknir dag lagle, pak ba nafak koia elan ḳorbae.” ");
INSERT INTO syll_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Bade Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Fosa-kusṭo bemarire fak-saf ḳorar din ou niom manio. Imam sabe tare deḳar lagi, ");
INSERT INTO syll_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","kempor bare gia forikka ḳoria deḳba. Tain zudi deḳoin he hasau bala oigese, ");
INSERT INTO syll_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","te imame hukum diba, fak-saf oa zonor niote zita duiṭa halal faki, debdaru gasor kisu laḳṛi, esub gasor ḍeṭa ar lal suta loia aita. ");
INSERT INTO syll_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Bade imame hukum diba, futor fani taki fani ania maṭir gamlat toa fanir ufre, hou duio fakir mazor eḳṭare zobo ḳorar lagi. ");
INSERT INTO syll_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Zobor bade imame baki hou zita fakire, debdaru gasor laḳṛire, lal sutare ar esub gasor ḍeṭare, futor fanir gamlar ufre zobo ḳora hou fakir lour maze subaiba. ");
INSERT INTO syll_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Ar ou ze bemarire fak-saf ḳora oito, imame tar ufre hou lou shatbar siṭaia hari, tare fak-saf ḳoia elan ḳorba. Bade imame hou zita fakire kula zagat saṛi diba. ");
INSERT INTO syll_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Ar fak-saf bonra ou bemarie tar ḳafoṛ-sufoṛ doibo, tar gotror ar matar hoḳol sul-rum ḳamaia hari fani dia naite oibo, teu he fak-saf bonbo. Erbade he aia Boni Israilor kempor bitre hamaito farbo, oile tar nizor tambur bare shat din roite oibo. ");
INSERT INTO syll_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Bade shat dinor din hirbar tar shorilor hoḳol sul, mani matar sul, daṛi-mus, sokur buri ar gotror hoḳol ruma ḳamaite oibo. Bade tar ḳafoṛ-sufoṛ doia naia harle he furafur fak-saf oibo. ");
INSERT INTO syll_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Bador din he furafur nikut duiṭa meṛa-baichcha ar eḳ bosoror egu meṛi loia aibo. Ar er logor dan-gomor sodgar niote he soy sher tel maḳail moyda ar eḳ faoa tel anbo. ");
INSERT INTO syll_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Ania harle tar fak-safor lagi ze imam sabe ḳam ḳorra, ein ou zonre ar kurbanir mal-samanare Milon-tambur duaror gese Mabudor samne azir ḳorba. ");
INSERT INTO syll_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“Imam sabe hou duio meṛa-baichcha taki egu meṛa ar hou tel nia dush-ḳosurir koforar kurbani adae ḳorba, ḳoria dulona kurbani hishabe Mabudor samne ita dulaiba. ");
INSERT INTO syll_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Bade fobitro Kaba goror shimanar ze zagat gunar koforar kurbani ar zalail kurbanir foshu zobo ḳora oy, hou zagat ou foshure-o zobo ḳorba. Gunar koforar kurbanir laḳan dush-ḳosurir koforar kurbanir gust-o imam sabe faiba, ita to ḳas fobitro gust. ");
INSERT INTO syll_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Ze zonre fak-saf ḳora oibo, imam sabe dush-ḳosurir koforar kurbanir kisu lou nia tar ḍain ḳanor lotit, ḍain ator ar ḍain faor buṛi angulit lagaiba. ");
INSERT INTO syll_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Bade imame hou tel taki kisu tel tan bau ator talur maze ḍaliba. ");
INSERT INTO syll_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Ar ḍain ator anguil dia, bau at taki tel tulia Mabudor name shatbar siṭaiba. ");
INSERT INTO syll_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Bade ator talur bad-baki tel taki kisu tel nia imame hou zonor ḍain ḳanor lotit, ḍain ator ar ḍain faor buṛi angulit dush-ḳosurir koforar kurbanir lour ufre lagaiba. ");
INSERT INTO syll_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Ar ator talur baki tel tain hou fak-saf oa zonor matat lagaiba. “Ar ou nomunae tar kofora adae ḳorba, ");
INSERT INTO syll_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","ze zonre fak-saf ḳora oibo, tar ana gunar koforar kurbanir foshure imam sabe zobo ḳorba. Bade zalail kurbanir foshu-o zobo ḳoria, ");
INSERT INTO syll_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","dan-gomor sodgar zinishor loge milaia, imam sabe kurbani kanar ufre ita diba. Ou nomunae tar kofora adae ḳoria tar nafaki horaiba. ");
INSERT INTO syll_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Oile ou zon zudi gorib oy, ita hoḳolta anar tofik tar na taḳe, te dush-ḳosurir koforar kurbanir lagi kali egu meṛa-baichcha ante oibo, anle imame tar kofora adae ḳorar lagi oḳṭare kurbani dia dulaiba. Ar er logor dan-gomor sodga hishabe tar ana tel maḳail dui sher moyda, eḳ faoa tel ");
INSERT INTO syll_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ar tar duiṭa ḍufi faki ba faro ante oibo, zela tar takkote kulae. Duio fakir mazor eḳṭa gunar koforar kurbanir lagi, ar eḳṭa zalail kurbanir lagi. ");
INSERT INTO syll_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Bade aṭ dinor din fak-saf oar niote he ita hoḳolta ania Milon-tambur duaror daro Mabudor samne imamor gese shomzaite oibo. ");
INSERT INTO syll_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Imame dush-ḳosurir koforar kurbanir meṛa ar ou tel nia Mabudor samne dulona kurbani hishabe dulaiba. ");
INSERT INTO syll_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Bade imame meṛare zobo ḳoria ogur kisu lou nia hou zonor ḍain ḳanor lotit, ḍain ator ar ḍain faor buṛi angulit lagaiba. ");
INSERT INTO syll_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Bade hou tel taki kisu tel tan bau ator talur maze ḍaliba. ");
INSERT INTO syll_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Ar ḍain ator anguil dia imame bau ator kisu tel tulia Mabudor samne shatbar siṭaiba. ");
INSERT INTO syll_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Erloge tar ḍain ḳanor lotit, ḍain ator ar ḍain faor buṛi angulir ze zagat dush-ḳosurir koforar kurbanir lou lagail oise, hou zagar ufre ou tel-o lagaiba. ");
INSERT INTO syll_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Mabudor samne hou fak-saf oa zonor koforar niote imamor ator baki tel tar matat ḍali diba. ");
INSERT INTO syll_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Bade hou zonor takkot mafik ana ḍufi ba faro zuṛa nia, ");
INSERT INTO syll_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","imame egure gunar koforar kurbani hishabe, ar dusraṭare zalail kurbani hishabe kurbani diba. Loge dan-gomor sodgare-o diba. Imame ou nomunae Mabudor samne tar kofora adae ḳorba. ");
INSERT INTO syll_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Fosa-kusṭo bemari fak-saf oar lagi zelaḳan kurbani adae ḳorar ḳota, ita adae ḳorar takkot zerar nai, tarar lagi ou niom deoa oise.” ");
INSERT INTO syll_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Bade Mabude Musa ar Harunre ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Ami ze deshḳanre tumrar malikanae dimu, ou Kenan desho hamanir bade, ami zudi honor kunu goror maze nafak-feukni bemar faṭai, ");
INSERT INTO syll_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","te goror malike gia imam sabre ḳoiba, amar goro nafak-feuknir laḳan kita zanu dekiar. ");
INSERT INTO syll_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Teu imame i feukni forikka ḳoria deḳat aia, goror hoḳol mal-samanare zate nafak koia elan ḳora na lage, ou niote tain malikre hukum diba, ami goro hamanir age tumar goror hoḳol mal-samana bare bar ḳorilao. Hoḳolta bar ḳoria harle tain goro hamaia forikka ḳorba. ");
INSERT INTO syll_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Tain zudi deḳoin, goror oalor kunu feuknir dag gia bitredi hamaise, ar ou dagor rong kosua ba lalṭi, ");
INSERT INTO syll_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","te tain i gor taki baroi aia, goror duar shat din bond ḳori toiba. ");
INSERT INTO syll_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Ou shat din bade hirbar forikka ḳori deḳba, zudi deḳa zae, i dag oalor maze aro sitrise, ");
INSERT INTO syll_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","te tain hukum diba, ou oalor dag ala fattor ba iṭ kulia hari, gau ba ṭaunor bare nia nafak kunu zagat falai dita. ");
INSERT INTO syll_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Bade asta goror bitoror hoḳol oal sasia astor tulia hari, ota nia ṭaunor bare nafak kunu zagat falaita. ");
INSERT INTO syll_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Ar oalor ze zaga taki fattor ba iṭ kula oise, hono noya fattor lagaiba, lagaia asta gor hirbar noya astor ḳorta. ");
INSERT INTO syll_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Oalor fattor kulia falaia sasia astor tular bade, noya astor lagaia harle-o zudi oalo hirbar ola dag deḳa zae, ");
INSERT INTO syll_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","te imame hirbar gia ita forikka ḳori deḳba. Tain zudi deḳoin, oalor mazor dag sitria aro baṛse, te buzba, ou goro nafak-feukni bemar ase, erlagi i gor ḳan nafak. ");
INSERT INTO syll_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Nafak ou goror hoḳol fattor ba iṭ, hoḳol astor, goror laḳṛi, hokkolta bangia ṭaunor bare kunu nafak zagat nia falaite oibo. ");
INSERT INTO syll_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Ar hou shat din bond raḳar ḳalo zudi kunu manush gia i goro hamae, te he ou din hainja forzonto nafak halote roibo. ");
INSERT INTO syll_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Ar ḳeu zudi ou goro ḳana-fina ḳae ba gumae, te tar finnor ḳafoṛ-sufoṛ doia dite oibo. ");
INSERT INTO syll_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Oile i gor astor ḳorar bade imame forikka ḳoria zudi deḳoin, oalor dag ar deḳa zar na, te imame i gorre fak-saf ḳoia elan ḳorba. I goro to nafak-feukni bemaror kunu alamot oḳon nai. ");
INSERT INTO syll_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Ar gorre fak-saf ḳorar lagi imam sabe duiṭa faki, debdaru gasor kisu laḳṛi, esub gasor ḍeṭa, ar lal rongor suta loia ono aiba. ");
INSERT INTO syll_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Aia futor fani taki ana maṭir gamlat toa ou fanir ufre eḳṭa fakire zobo ḳorba. ");
INSERT INTO syll_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Ar dusra zita fakire, debdaru gasor laḳṛire, lal suta ar esub gasor ḍeṭare, futor fanir gamlar ufre zobo ḳora hou fakir lour maze imam sabe subaiba, subaia hari ou goror maze shatbar siṭaiba. ");
INSERT INTO syll_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Fakir lou, futor fani, zita faki, debdaru gasor laḳṛi, esub gasor ḍeṭa ar lal suta dia ou gorre fak-saf ḳora oibo. ");
INSERT INTO syll_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Erbade ou zita fakire nia gau ba ṭaunor bare kula zagat saṛi diba. Ou nomunae hou goror nafaki horaia harle, ikan fak-saf oibo.” ");
INSERT INTO syll_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Te hoḳol laḳan fosa-kusṭo bemar, daud-ḳauzli, ");
INSERT INTO syll_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ḳafoṛ ba goror oalor feuknir dag, ");
INSERT INTO syll_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","gotror samṛat kulosh uṭa, boron ba kunu zator dagor befare ou laḳan hukum zanail oilo. ");
INSERT INTO syll_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Ita bemare kun shomoy pak, ar kun shomoy nafak, oḳan zananir lagi ou niom-ḳanun deoa oilo. ");
INSERT INTO syll_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Mabude Musa ar Harunre ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Tumra Boni Israilre zanao, kunu beṭa manshor feshabor rastae zudi hamesha datu bar oy, te tar shoril nafak. ");
INSERT INTO syll_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Tar shoril taki datu baronit roile ba shorilo aṭki roile-o he nafak. ");
INSERT INTO syll_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Ola nafak halote he ze bisnat hutibo, ba ze zagat boibo, hou bisna ar hou zaga-o nafak oizibo. ");
INSERT INTO syll_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Ou datu zaora nafak beṭar bisna ze zone soibo, he nizor ḳafoṛ-sufoṛ doia dia fanidi naibo, ta-o hainja forzonto he nafak halote roibo. ");
INSERT INTO syll_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Olaḳan hou beṭar boar zagat ze zon boibo, he-o tar ḳafoṛ-sufoṛ doia dia fanidi naibo, ta-o hainja forzonto he nafak halote roibo. ");
INSERT INTO syll_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Ar i datu zaora beṭare ze zone soibo he-o tar ḳafoṛ-sufoṛ doia dia fanidi naibo, ta-o hainja forzonto he nafak halote roibo. ");
INSERT INTO syll_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Hou datu zaora beṭae zudi kunu fak-saf manshor gotro sef falae, te ou zone-o tar ḳafoṛ-sufoṛ doia dia fanidi naibo, ta-o hainja forzonto he nafak halote roibo. ");
INSERT INTO syll_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Ou datu zaora beṭae kunu zagat zaibar ḳalo gaṛi-guṛa kunutar siṭo boia gele, i siṭ nafak oizibo. ");
INSERT INTO syll_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Ou siṭ kunu manshe soile he hainja forzonto nafak halote roibo. Ou siṭ ze zone tulbo, he tar ḳafoṛ-sufoṛ doia dia fanidi naibo, ta-o hainja forzonto he nafak halote roibo. ");
INSERT INTO syll_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Ou datu zaora beṭae fanidi at na doia zudi kunu manshore soilae, te zare soibo, he tar ḳafoṛ-sufoṛ doia dia fanidi naibo, ta-o hainja forzonto he nafak halote roibo. ");
INSERT INTO syll_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Ar datu zaora beṭae zudi kunu maṭir bashon soilae, te ita bangilite oibo, ar laḳṛidi banail kunu zinish soile, ita fanidi doite oibo. ");
INSERT INTO syll_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“Hou datu zaora bemari beṭar bemar zedin ḳomizibo, ou din taki gonia shat dinor din he tar ḳafoṛ-sufoṛ doia dia futor fanit naia hari fak-saf oibo. ");
INSERT INTO syll_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Bade aṭ dinor din he duiṭa ḍufi faki ba dugu faro loia Mabudor samne Milon-tambur duaror gese azir oia, imam sabor ato dite oibo. ");
INSERT INTO syll_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Imame hou duiṭar egure dia gunar koforar kurbani, ar dusraṭa dia zalail kurbani adae ḳorba. Datu zaora beṭar nafaki horanir niote, imam sabe Mabudor samne ou nomunae tar kofora adae ḳorba. ");
INSERT INTO syll_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“Kunu beṭa manshor zoubonor fani bar oigele he tar asta shorilre fanidi doite oibo, ar hainja forzonto he nafak halote roibo. ");
INSERT INTO syll_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Ou zoubonor fani kunu ḳafoṛ ba samṛar zinisho lagigele, ita fanidi doite oibo, ar hainja forzonto ita nafak halote roibo. ");
INSERT INTO syll_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Kunu beṭae tar bour loge mila-mishar ḳalo zoubonor fani bar oile, tara duiozone fanidi naite oibo, duiozon hainja forzonto nafak halote roibo. ");
INSERT INTO syll_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Kunu beṭir mashik bemaror lou zaoar shomoy tai shat din nafak halote roibo. Ou shomoy i beṭire ze zone soibo, he hainja forzonto nafak halote roibo. ");
INSERT INTO syll_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Ou beṭiara bemaror shomoy tai zetar ufre boibo ba hutibo, ita hoḳolta nafak oizibo. ");
INSERT INTO syll_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Tair bisna ze zone soibo, he-o tar ḳafoṛ-sufoṛ doia dia fanidi naibo, ta-o hainja forzonto he nafak halote roibo. ");
INSERT INTO syll_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Ou bemari beṭi zetar ufre boise, ita zudi keu soilae, te he-o tar ḳafoṛ-sufoṛ doia dia fanidi naibo, ta-o hainja forzonto he nafak halote roibo. ");
INSERT INTO syll_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Tair bisna ba searo ḳeu soile, ba itar ufre toa kunta soile-o, he hainja forzonto nafak halote roibo. ");
INSERT INTO syll_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Beṭiara bemari beṭir loge kunu beṭa manush zudi hute, ar tair mashikor lou tar shorilo lage, te ou beṭa-o shat din nafak halote roibo. Ou shat dinor maze he ze bisnat hutibo, ita-o nafak oizibo. ");
INSERT INTO syll_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“Kunu beṭi manshor zudi bout din dori lou zaoat roy, mashik bemaror shat din faronir bade-o zudi lou zaoat roy, te zotodin forzonto ila lou zaibo, otodin tai nafak roibo. ");
INSERT INTO syll_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Beṭiara mashik bemaror laḳan ou lou zaibar shomoy tai zetat hutibo ba boibo, ita nafak oizibo. ");
INSERT INTO syll_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","I bisna ba sear ze zone soibo, he-o nafak oizibo. He tar ḳafoṛ-sufoṛ doia dia fanidi naibo, ta-o hainja forzonto he nafak halote roibo. ");
INSERT INTO syll_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Ou beṭir lou zaoa bond oar bade-o, tai gonia aro shat din bar saite oibo, erbade tai fak-saf oibo. ");
INSERT INTO syll_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Ar aṭ dinor din tai duiṭa ḍufi faki ba faro loia Milon-tambur duaror gese imam sabor daro zaibo. ");
INSERT INTO syll_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Imame hou duio fakir mazor egudi gunar koforar kurbani, ar dusraṭa dia zalail kurbani adae ḳorba. Ou nomunae imame tair lou zaibar nafaki horanir kofora Mabudor samne adae ḳorba. ");
INSERT INTO syll_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“O Musa ar Harun, ou nomunae tumra Boni Israil shomazre hoḳol nomunar nafaki taki basaio, arnae tarar maze roa amar fobitro boshot ḳanare zudi tara nafak banain, te ou nafakir dae to tarar moron oibo.” ");
INSERT INTO syll_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","33","Te beṭaintor datu zaoa bemar, zoubonor fani baroni, beṭintor mashik bemar, beṭa ba beṭintor zekunu laḳan datu zaoa, nafak bour loge mila-misha ḳora, ita zekunu zonor lagi ou niom zari oilo. ");
INSERT INTO syll_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Imam Harunor boṛo dui fuae naformani koria Mabudor samne foṛia mara gelo ḳori, Mabude Musa nobir loge batchit ḳorla. ");
INSERT INTO syll_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Mabude ḳoila, “Tumar bai Harunre ḳo, he zanu zebla mone sae ebla shahadot shondukor ḍaḳnar gese zaoar lagi Herem Shorifor fordar bitre na hamae, arnae he morbo-u. Zano to, ou ḍaḳnar ufror dumar andairor maze ami nize azir oi. ");
INSERT INTO syll_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Ino hamanir age he zanu gunar koforar kurbanir lagi egu bisal ar zalail kurbanir lagi egu meṛar faṭa loia ino aia hamae. ");
INSERT INTO syll_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Shada suti kafoṛdi banail fobitro alḳella ar haf-penṭor laḳan zangia findia bitre hamaibo. Tar ḳomro bandar suti kafoṛor bondoni bandibo ar matat suti kafoṛor faugṛi lagaibo. Ita to fak-fobitro lebas, ita lebas findibar age fanidi naite oibo. ");
INSERT INTO syll_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Gunar koforar kurbanir lagi he Boni Israilor ges taki duiṭa faṭa sagol ar zalail kurbanir lagi egu meṛar faṭa nibo. ");
INSERT INTO syll_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Imam Harune tar nizor ar tar aolad oḳlor gunar mafir lagi, gunar koforar bisalre kurbani dibo. ");
INSERT INTO syll_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Bade hou sagol duioṭa Milon-tambur duaror gese Mabudor samne anbo. ");
INSERT INTO syll_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Ania he loṭari maria deḳbo, kun sagol Mabudor lagi ar kunṭa Azazilor lagi. ");
INSERT INTO syll_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Loṭarit Mabudor name ze sagol uṭbo, Harune ogudi gunar koforar kurbani adae ḳorbo. ");
INSERT INTO syll_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Ar Azazilor name ze sagol uṭbo, ogure zita halote Mabudor samne toibo, zate bade ogure morubumit nia Azazilor name auri saṛi deoa oy. Ou nomunae gunar kofora adae ḳorio. ");
INSERT INTO syll_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Imam Harune tar nizor ar tar aolad oḳlor gunar koforar lagi, tar nizor ana hou bisalre zobo ḳorbo. ");
INSERT INTO syll_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Mabudor samne agor-kushboy zalanir ze ṭebul ase ou ṭebul taki kisu zalail angra loia he agor danir maze borbo, ar dui muiṭ agor-kushboyor guṛa-o loibo, bade fordar bitre Herem Shorifo hamaibo. ");
INSERT INTO syll_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Hamaia ou angrar ufre agor-kushboy dia Mabudor samne zalaibo, teu otar dumae shahadot shondukor ḍaḳnar ufror gala andaire gurizibo, zate he Mabudor samne na moroin. ");
INSERT INTO syll_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Bade he kurbanir hou bisalor tuṛa lou nia ator anguil dia ou ḍaḳnar samnor galabae siṭai dibo. Erbade angulir maze aro tuṛa lou lagaia ḍaḳnar samnor bae shatbar siṭaia dibo. ");
INSERT INTO syll_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Ar he manshor gunar koforar niote ana sagolṭare zobo ḳorbo, ḳoria ogur lou nia fordar bitre Herem Shorifo gia, bisalor loudi zela ḳora oisil, ogur loudi-o ola ḳorte oibo. Shondukor ḍaḳnar ufre ar samne ou lou siṭaite oibo. ");
INSERT INTO syll_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Boni Israilor guna, nafaki, ar naformanie Herem Shorifre-o nafak korilae, erlagi tarar maze ze Milon-tambu ase, oḳanor nafaki horanir niote imam Harune ou nomunae gunar kofora adae ḳorba. ");
INSERT INTO syll_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Herem Shorifor bitre hamaia hari Harune tan nizor, tan aolad oḳlor ar asta shomazor gunar koforar hoḳol ḳam shesh ḳoria zotobil na bar oia ain, otobil dusra kunu manush Milon-tambur bitre hamani nished. ");
INSERT INTO syll_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Herem Shorif taki bar oia Harune Mabudor samne ze agor-kushboy zalanir ṭebul ase ou ṭebulor ḳandat zaiba, zaia ṭebulor lagi-o kofora adae ḳorba. Hou bisal ar sagolor tuṛa lou nia tain ou ṭebulor hingor maze lagaiba. ");
INSERT INTO syll_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Boni Israilor gunar ḳarone ṭebulor maze ze nafaki lagail oise, hou nafaki horaia ou ṭebulre fobitro ḳorar lagi Harune tar ator anguil dia ou ṭebulor ufre shatbar lou siṭaibo. ");
INSERT INTO syll_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Herem Shorif, Milon-tambu, ar kurbani kanar nafaki horanir koforar ḳam shesh ḳoria harle Harune Azazilor name deoar lagi hou zita sagolre loia aiba. ");
INSERT INTO syll_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aia ou sagolor ḳollar ufre tar duio at toia, Boni Israilor hoḳol guna-naformani ar bod ḳamor ḳota shikar ḳoria sagolor ḳollar ufre ota bortai dibo. Bade ag taki zuit oa eḳ beṭare dia ou sagolre he morubumit faṭai dibo. ");
INSERT INTO syll_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Hou beṭae nia ogure morubumit saṛia aibo. Tarar hoḳol naformanire ou sagole loia nirai nirjon morubumit azibon guribo. ");
INSERT INTO syll_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Ar Herem Shorifo hamaibar ḳalo Harune shada suti kafoṛor zoto lebas findisla, tain Milon-tambut firia aia ita kulia toi diba. ");
INSERT INTO syll_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Kulia tain Kaba goror shimanar bitre fanidi naia tan nizor lebas findiba. Bade tain bare aia tan nizor ar manshor lagi egu ḳori zalail kurbani adae ḳoria, tan nizor ar manshor gunar kofora-o adae ḳorba. ");
INSERT INTO syll_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Gunar koforar kurbanir sorbire tain kurbani kanar ufre zalailiba. ");
INSERT INTO syll_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Ze beṭae Azazilor namor sagolre morubumit saṛia aibo, he-o tar ḳafoṛ-sufoṛ doia hari fani dia naia bade kempor bitre hamaito farbo. ");
INSERT INTO syll_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Guna mafir lagi kurbanir ze bisal ar gunar koforar kurbanir ze sagolor loure Herem Shorifo nibar hukum deoa oise, otar hoḳol gust, ḳal, gufor ar hoḳoltare kempor bare nia eḳzone zalailio. ");
INSERT INTO syll_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Ze zone ita hoḳolta bare nia zalaibo, he-o tar ḳafoṛ-sufoṛ doia, fanidi naia hari bade aia kempor bitre hamaito farbo. ");
INSERT INTO syll_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Erbade ami zeta ḳoiram, ita oilo tumrar lagi hor-hameshakur niom. Forteḳ bosoror shat nombor sandor dosh nombor din, tumrar forteḳ zone hoḳol zator ḳam-ḳaz ar ruzi-ruzgar bad dia, noto oia dil shofia dibae. Boni Israil ba tumrar loge boshot ḳorra bin-deshi hoḳol zone ita mante oibo. ");
INSERT INTO syll_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Ḳaron oudin tumrar guna mafir lagi gunar kofora adae ḳora oibo, teu tumra Mabudor samne hoḳol nomunar guna taki fak-saf oibae. ");
INSERT INTO syll_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Oudin tumra hoḳol nomunar ḳam-ḳaz bad dia aram ḳorbae, forteḳe noto oia zarzir dil shofia dibae. Iṭa oilo tumrar lagi siroḳalin niom. ");
INSERT INTO syll_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Zekunu imamre zebla fordan imam hishabe tar bafor zagat ḳelafoti shomzaia boail ḳora oibo, he-o ola shada suti kafoṛor fobitro lebas findia ou nomunae gunar kofora adae ḳorbo. ");
INSERT INTO syll_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Herem Shorif, fobitro Kaba gor, kurbani kana, baki imam oḳol, ar asta Boni Israil shomazre fak-saf ḳorar lagi kofora adae ḳorbo. ");
INSERT INTO syll_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Iṭa oilo tumrar lagi hor-hameshakur niom. Forteḳ bosor eḳbar hoḳol Boni Israilor gunar kofora ola adae ḳorte oibo.” Teu Mabude Musare zela hukum disla, ṭik ou laḳan hoḳolta ḳora oilo. ");
INSERT INTO syll_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Bade Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Amar ou hukum ḳan tumi imam Harunre, tar fuaintore ar tamam Boni Israilre zanai deo. Tarare ḳo, ");
INSERT INTO syll_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Boni Israilor ḳeu zudi kunu goru, sagol ba meṛare tarar boshot tambu elaḳat ba kempor bare ze kunu zagat kurbani niote zobo ḳorilae, ");
INSERT INTO syll_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ou foshure he Mabudor Kaba goror samne, mani Milon-tambur duaror gese Mabudor name kurbanir niote zobo na ḳore, te he ou foshur kunor dayi oibo, erlagi shomaz taki tar nam miṭailibae. ");
INSERT INTO syll_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Boni Israile oḳon gau-geramor kula zagat zeta foshu kurbani dein, ou foshu zanu tara Mabudor samne Milon-tambur duaror gese ane. Ania imam sabor ato shomzaia salamoti kurbani hishabe ita Mabudor name dilae. ");
INSERT INTO syll_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Imam sabe foshu zobo ḳoria, Milon-tambur duaror gese Mabudor ze kurbani kana ase, hono ogur lou siṭai diba, ar foshur sorbire tain geran ala kurbani hishabe zalailiba, ou dumar gerane Mabud kushi oin. ");
INSERT INTO syll_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ḳobordar! Tara zanu Mabudor loge beimani koria sagolrupi deo-butor name aiz taki ar kunu foshu boli na dey. Ou hukum ami tarar oarishor for oarish dori siroḳalor lagi zari korlam. ");
INSERT INTO syll_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Ar tumi tarare zanai deo, Boni Israilor kunu zon ba tarar maze boshot ḳorra kunu bin-deshie zudi zalail kurbani ba zekunu kurbani adae ḳore, ");
INSERT INTO syll_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ar kurbanir ou foshure Mabudor name shofibar lagi amar Milon-tambur duaror gese na ane, te i zatir maz taki tar nam miṭailito. ");
INSERT INTO syll_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“Tumi aro zanai deo, kunu Boni Israil ba tarar maze boshot ḳorra kunu bin-deshie zudi kunuzat lou ḳae, te ami Mabude tar ḳeti korat lagizimu, shomaz taki tar nam miṭailimu. ");
INSERT INTO syll_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Lour maze-u to hoḳol zandaror zan taḳe. Erlagi tumrar zanor bodla kurbanir loure kurbani kanat siṭaia ami tumrar gunar koforar shuzug disi. Lour maze zan ase ḳori-u lour bodla gunar kofora adae oy. ");
INSERT INTO syll_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Erlagi ami Boni Israilre ḳoiar, tumra ar tumrar loge boshot ḳorra kunu bin-deshie-o zanu lou na ḳae. ");
INSERT INTO syll_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Boni Israilor zekunu zone ba tumrar loge boshot ḳorra kunu bin-deshi manshe zudi, shikaro gia halal kunu foshu ba faki shikar ḳoria ane, te ogur lou bar ḳoria maṭit gaṛilibae. ");
INSERT INTO syll_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Zano to, zinda hoḳol zandaror lour maze-u tar zan taḳe. Erlagi ami Boni Israilre ḳoiar, tara zanu kunu zandaror lou na ḳae, lou oilo hoḳol zandaror zan. Ze zone ou lou ḳaibo, tar nam miṭailibae. ");
INSERT INTO syll_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“Ar kunu manshe zudi mora foshur ba zongli zanuare mara kunu foshur gust ḳailae, te he Boni Israil ouk, ba tarar loge boshot ḳorra bin-deshi ouk, he tar ḳafoṛ-sufoṛ doia dia fanidi naite oibo. Ta-o hainja forzonto he nafak halote roibo, erbade he fak-saf bonbo. ");
INSERT INTO syll_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Oile he zudi kafoṛ-sufoṛ doia na dey ar fanidi na nae, te i kosurir lagi he dayi roibo.” ");
INSERT INTO syll_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Ar Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Tumi Boni Israilre ḳo, ami Alla-u tumrar Mabud. ");
INSERT INTO syll_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Erlagi tumra age ze Mishor desho boshot ḳortae, hinor manshe zeta ḳore tumra ita ḳorio na. Ar ami tumrare ze Kenan desho niram, hou desho gia harle, honor manshe zeta ḳore ita-o tumra ḳorio na. Tara zela sole, tumra ila solio na. ");
INSERT INTO syll_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Borong amar deoa shoriot mafik tumrar zindegi kaṭaibae. Kub kial ḳoria amar deoa hukum-ahkam amol ḳorbae. Mono rakio, ami Alla-u tumrar Mabud. ");
INSERT INTO syll_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Amar batail niom-ḳanun ar shoriotor hukum-ahkam tumra amol ḳorbae, ze zone ita amol ḳore he er usillae tar zan basaibo. Ami-u to Mabud. ");
INSERT INTO syll_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“Afon lour ḳesh-kuṭumor loge shorili mila-misha ba beijjoti kam ḳorio na. Ami-u to Mabud. ");
INSERT INTO syll_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Tumrar mazor ḳeu zanu nizor maʼr loge shorili mila-misha ḳoria tar bafor man-ijjot na luṭe. Ein to tar ma, en loge mila-misha ḳora haram. ");
INSERT INTO syll_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Haton maʼr loge-o mila-misha ḳora haram, arnae bafor beijjoti oibo. ");
INSERT INTO syll_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Nizor boin ba haton boinor loge mila-misha ḳora-o haram, afon bafor torofa boin ba maʼr torofa boin oile-o haram. Tara eḳ baṛit zonom ouk ba alada baṛit zonom oile-o haram. ");
INSERT INTO syll_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Fua ba fuṛir goror natinor loge shorili mila-misha ḳora haram, itae to nizor beijjoti oy. ");
INSERT INTO syll_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Haton maʼr goror boinor loge shorili mila-misha ḳora haram, tai to boin. ");
INSERT INTO syll_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Afon fufur loge shorili mila-misha ḳora haram, ein to bafor lour kuṭum. ");
INSERT INTO syll_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Afon moir loge shorili mila-misha ḳora haram, ein to maʼr lour kuṭum. ");
INSERT INTO syll_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Afon sasar man-ijjot luṭia tan bour loge shorili mila-misha ḳora haram, ein to sasi. ");
INSERT INTO syll_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Afon fuar bour loge shorili mila-misha ḳora haram, tai to nizor bouma. ");
INSERT INTO syll_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Bair bour loge shorili mila-misha ḳora haram, arnae bair beijjoti oibo. ");
INSERT INTO syll_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Kunu beṭi manshor loge shorili mila-mishar bade tair fuṛir loge, tair fua ba fuṛir goror natinor loge shorili mila-misha ḳora haram, era to tair lour kuṭum, ita boṛo ḳobisi kam. ");
INSERT INTO syll_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Ar bou zita taḳa halote hali ba zeṭalire bia ḳoria hotiala ḳora-o haram. ");
INSERT INTO syll_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“Hayez ba beṭiara mashik bemar taḳa halote kunu beṭintor loge mila-misha ḳora haram. ");
INSERT INTO syll_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Dusra kunu beṭar bour loge shorili mila-misha ḳoria, nizore nafak banaio na. ");
INSERT INTO syll_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“Tumrar mazor ḳeu nizor fua ba fuṛire aguindi zalaia, Mulok devtar name boli dia, afon Allar fobitro namre oshomman ḳorio na. Ami-u to Mabud. ");
INSERT INTO syll_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“Beṭintor loge zela shorili mila-misha ḳoroin, beṭainte-beṭainte ola ḳobisi fungami kora haram. ");
INSERT INTO syll_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Kunu foshur loge ḳobisi mila-misha ḳoria, kunu beṭain nafak bonio na. Kunu foshur loge kunu beṭinte-o ḳobisi mila-misha ḳorio na. Ilaḳan ḳobisi mila-misha to zogotor niomor ulṭa. ");
INSERT INTO syll_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“Ou laḳan kunu ḳobisi beijjoti kam ḳoria, tumrar mazor ḳeu zanu nizore nafak na banae. Mono rakio, tumrar samne taki zoto zati oḳolre ami kedai diram, tara to ota ḳobisi koria nizore nafak korsil. ");
INSERT INTO syll_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Otar lagi tarar deshor maṭi nafak bonigese, tarar naformanir ḳarone ami ou deshre shaza diram, ou deshor maṭie tar proza oḳolre bomi kori falai der. ");
INSERT INTO syll_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Oile tumra ḳali amar deoa shoriot ar hukum-ahkam mania solio. Tumrar nizor zatir ba tumrar maze boshot ḳorra bin-deshi keu zanu ola ḳobisi beijjotir kunuzat ḳam na ḳore. ");
INSERT INTO syll_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Age taki zeta zati oḳol hou desho boshot ḳorer, tara ou nomunar ḳobisi beijjoti kam oḳol ḳorae honor maṭire nafak banailise. ");
INSERT INTO syll_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Oḳon tumra-o hono gia zudi hotar laḳan nafaki kam ḳoro, te tarar laḳan tumrare-o hou deshor maṭie bomi kori falaibo. ");
INSERT INTO syll_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“Ila ḳobisi kunu ḳam ḳeu ḳorle, tumrar shomaz taki tar nam miṭailibae. ");
INSERT INTO syll_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Amar hukum-ahkam tumra manio, tumra hou desho gia hari honor furana bashinda oḳlor sal-cholone solio na. Tarar ḳobisi riti-reoaz mania tumra nafak oio na. Mono rakio, ami Alla-u tumrar Mabud.” ");
INSERT INTO syll_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Mabude Musa nobire aro ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Tumi hoḳol Boni Israilre ḳo, ami tumrar Mabud Alla to fak-fobitro, erlagi tumra-o fak-fobitro o. ");
INSERT INTO syll_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Tumra forteḳe zarzir ma-bafre tazim ḳorio, ar amar deoa hoḳol Zummabar manio. Ami Alla-u tumrar Mabud. ");
INSERT INTO syll_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Tumra kunuzator deb-debir puja ḳorio na, puja ḳorar niote format ḍalia shuna-rufa, fitol-tamadi kunu deb-debir murti-o banaio na. Mono rakio, ami Alla-u tumrar Mabud. ");
INSERT INTO syll_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Tumra zebla nizor kushie Mabudor name kunu salamoti kurbani deo, ou shomoy ola bab loia dio, zate Mabudor dorbaro ita kobul oy. ");
INSERT INTO syll_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Ar itar hoḳol gust kurbanir din ba bador din ḳailite oibo. Tin dinor din kunu gust baki roile, ita aguindi zalailio. ");
INSERT INTO syll_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Tin dinor din to i gust nafak bonizae, ita ḳaile tumrar kurbani kobul oito nae. ");
INSERT INTO syll_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","I gust ḳeu ḳaile he naformanir daṛo foṛbo, he to Mabudor namor fak-fobitro zinishre nafak banaise. Te tumrar shomaz taki tar nam miṭailibae. ");
INSERT INTO syll_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Ḳetor foshol ḳaṭar shomoy tumra zominor ailor ḳandar foshol saf ḳoria ḳaṭio na, ar ḳaṭar bade zomino falail foshol luria nio na. ");
INSERT INTO syll_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Angur ḳetor angur faṛibar ḳalo, tole falail angur tubaia tulio na, ar hoḳol angur saf ḳori faṛia nio na. Shomazor gorib-duki ar bideshi musafiror lagi ita kisu toia zaio. Ami Alla-u to tumrar Mabud. ");
INSERT INTO syll_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Suri korio na, misa matio na, ar eḳe-oinne ṭogaṭogi korio na. ");
INSERT INTO syll_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Tumra amar nam loia misa ḳosom ḳaio na, ila ḳorle tumrar Allar namre ofobitro ḳora oy. Ami-u to Mabud. ");
INSERT INTO syll_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“Kunu ari-forir ufre zur-zulum ḳorio na, tarar kunu zinish ḳaṛia nio na. Ruzi kamlar beton ou dinor maze-u adae ḳorio, bador din forzonto tar beton aṭḳai toio na. ");
INSERT INTO syll_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Kunu ḳaluare boddua dio na, ḳana ba andae usṭa ḳaibar lagi tar fotor maze kunta toio na. Tumra nizor Mabud Allare ijjot-tazim ḳorio, ami-u to Mabud. ");
INSERT INTO syll_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Na-hok bisar ḳorio na, bisaror maze gorib-doni, ba huru-boṛor fokkofati oio na, hoḳlor lagi hok bisar ḳorio. ");
INSERT INTO syll_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Manshor bodnam gaia gaia gurio na, kunu manshor zanor ḳeti oy, ila kunu ḳam ḳorio na. Ami-u to Mabud. ");
INSERT INTO syll_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Afon ari-forir bae ingsha-dushmonir bab monor maze gatia rakio na. Tar oforad tare buzai dio, teu tar gunar bar tumar ufre aito nae. ");
INSERT INTO syll_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Nizor zatir manshor bodla loio na, tarar bae zid-ingshar bab monor maze gatia rakio na. Ari-forire tumar nizor laḳan maya ḳorio. Ami-u to Mabud. ");
INSERT INTO syll_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Tumra amar niom-ḳanun mania solio. Eḳ zator foshur loge aroḳ zator foshure fal ḳabaio na. Eḳ zomino dui zator bis ḳet ḳorio na, ar dui zator sutadi banail ḳafoṛ findio na. ");
INSERT INTO syll_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Kunu bandi beṭir bia ṭik kora oise, oile tair mohoranar ṭeḳa deoa oise na, ba malike zegure azad ḳoria disoin na, ila kunu bandir loge ḳeu shorili mila-misha ḳorle, te he ḳeti-furon dite oibo. I duio zonre zane mario na, ḳaron ou bandi fuṛi to azad oise na. ");
INSERT INTO syll_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Oile ou beṭae tar dush-ḳosurir koforar kurbanir lagi, Mabudor name nikut egu meṛa loia Milon-tambur duaror samne azir oibo. ");
INSERT INTO syll_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Dush-ḳosurir koforar kurbanir lagi ana hou foshure kurbani dia, imam sabe Mabudor samne tar gunar kofora adae ḳorar bade, he ou gunar mafi faibo. ");
INSERT INTO syll_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Tumra nizor desho gia hari kunu folor gas lagaile, tin bosor forzonto i gasor fol tumrar lagi haram. Ou tin bosoror maze i gasor fol ḳaoa nazaiz. ");
INSERT INTO syll_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Sair nombor bosoro i gasor hoḳol fol Mabudor shukur-guzarir niote tan name dilaibae. ");
INSERT INTO syll_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Fas nombor bosor taki ou gasor fol tumrar lagi halal. Ita manle tumrar gaso bout fol aibo. Mono rakio, ami Alla-u tumrar Mabud. ");
INSERT INTO syll_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Tumra lou shomet kunu gust ḳaio na. Kunu zator zadu-montro ba gona-basa hikio na, ar bebohar-o ḳorio na. ");
INSERT INTO syll_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Matar duio galar sul saṭa, ba daṛir aga ḳaṭio na. ");
INSERT INTO syll_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Murdar lagi ahazari korat gia nizor shorilo zoḳom ḳorio na. Gotror maze kunuzat saf-sobi akio na. Ami-u to Mabud. ");
INSERT INTO syll_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Ṭeḳa ruzir niote nizor fuṛire silani-bodmaishit lagaio na. Arnae asta desh zinae borizibo, fura desho ḳobisi baṛibo. ");
INSERT INTO syll_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Amar deoa Zummabare ziraio, ar amar Kaba gorre ijjot ḳorio. Ami-u to Mabud. ");
INSERT INTO syll_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Zinnat ba ferot shadok, gonoḳ ba zadu-ṭuna ḳorrar gese zaio na, itar loge mishio na. Arnae itae tumrare nafak banailiba. Mono rakio, ami Alla-u tumrar Mabud. ");
INSERT INTO syll_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Murobbi manush daro aile tumra ubaia ijjot dio. Tumra nizor Allar ḍor-ḳofe roio. Ami-u to Mabud. ");
INSERT INTO syll_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Tumrar desho tumrar loge boshot ḳorra bin-deshi manshor ufre zulum ḳorio na. ");
INSERT INTO syll_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Nizor zatir loge zela bebohar ḳoro, tarar loge-o ola bebohar ḳorio, tarare nizor laḳan maya ḳorio. Mono rakio, tumra-o Mishor desho bin-deshi halote aslae, ar ami Alla-u tumrar Mabud. ");
INSERT INTO syll_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Tumra kunuzat maf-zuko ar fallar uzono be-insafi korio na. ");
INSERT INTO syll_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Tumrar falla-fattor, her-fura, nol-doṛi, mafor hoḳolta zanu ṭik-ṭak taḳe. Ami Alla-u tumrar Mabud, ar Mishor desh taki ami-u tumrare bar ḳori anchi. ");
INSERT INTO syll_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Amar batail hoḳol niom-ḳanun ar furafur shoriot tumra mania solio. Ami-u to Mabud.” ");
INSERT INTO syll_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Bade Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Tumi Boni Israilre zanai deo, tumrar mazor kunu manshe ba tumrar loge boshot ḳorra bin-deshi kunu manshe zudi tar fua ba fuṛire Mulok devtar name boli dey, te ogure zane marilibae, deshor manshe milia fattordi iṭaia tare marbae. ");
INSERT INTO syll_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","He nizor fua ba fuṛire aguindi zalaia Mulok devtar name boli dia, amar Kaba gorre nafak banaise ar amar fak-fobitro namre oshomman ḳorse. Erlagi ami tar ḳeti korat lagmu, i zatir maz taki tar nam miṭailimu. ");
INSERT INTO syll_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ou devtar name tar fua ba fuṛire boli deoar shomoy, i deshor manshe zudi dekia-o na-deḳar ban ḳoroin, ar i boli deorare zane na maroin, ");
INSERT INTO syll_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","te ami nize ou naforman ar tar foribaror ḳeti korat lagizimu. Ami ogur nam ar ogur laḳan aro zeguinte ila naformani korbo, ota hokkolṭir nam Boni Israil shomaz taki miṭailimu. Era to amar loge beimani koria hou Mulok devtar ato nizore shofi dise. ");
INSERT INTO syll_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“Kunu manshe zudi amar loge beimani koria, zin-but shadok ba gonoḳor loge mishia nizore shofi dilae, te tar-o ḳeti korat lagizimu ar i zatir maz taki tar nam miṭailimu. ");
INSERT INTO syll_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“Tumra amar lagi nizore alada ḳoro ar fak-fobitro o. Mono rakio, ami Alla-u tumrar Mabud. ");
INSERT INTO syll_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Amar niom-ḳanun furafur amol ḳorio. Ami-u to Mabud, ami-u tumrare fak-fobitro ḳori. ");
INSERT INTO syll_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“Ze manshe afon ma-bafre gali-galaz ḳoria beijjot ḳore, tare-o zane marbae. Ou naformanir dae tar moutor lagi he nize-u dayi. ");
INSERT INTO syll_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“Kunu manshe zudi ari-forir kunu zonor bour loge zina ḳore, te ou beṭa-beṭi duio zonre zane marilibae. ");
INSERT INTO syll_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Ze manshe tar haton maʼr loge zina ḳore, he tar bafre beijjot ḳore. Erlagi tare ar haton maʼre zane marbae. Tarar moutor lagi to tara-u dayi. ");
INSERT INTO syll_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“Kunu manshe zudi afon fuar bour loge zina ḳore, te tara duio zonre zane marbae. Tara manob shomazor ulṭa solae, tarar moutor lagi nize-u dayi. ");
INSERT INTO syll_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Kunu beṭae zudi aroḳ beṭar loge zina-fungami kore, te tara duio zone-u boṛo ḳobisi korse, erlagi duio zonre zane marilibae, tarar moutor lagi tara-u dayi. ");
INSERT INTO syll_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“Kunu beṭae zudi kunu fuṛire ar tair maʼre-o hanga ḳore, te ou beṭa ar ma-fuṛi tino zonre aguindi zalaia marilibae, zate ila naformani kam tumrar maze na goṭe. ");
INSERT INTO syll_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Kunu foshur loge kunu manshe zina ḳorle, hou manush ar foshu duiogure zane marbae. ");
INSERT INTO syll_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Kunu beṭie zudi kunu foshur loge zina ḳorat zae, te hou beṭi ar foshure-o zane marbae. Tarar moutor lagi tara-u dayi. ");
INSERT INTO syll_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“Kunu beṭae zudi tar afon boin, haton ma ba haton bafor goror boinor loge shorili mila-misha ḳore, ita to shoromor ḳam. Tarare shomaz taki horailibae, ar he shaza faibo. ");
INSERT INTO syll_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Kunu beṭi manshor mashik bemaror shomoy tair loge ze beṭae shorili mila-misha ḳore, i beṭie to tair mashik kalor ijjot dey na, ar i beṭae-o tair mashikre dam dey na. Erlagi Boni Israil shomaz taki i duiogur nam miṭailibae. ");
INSERT INTO syll_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Kunu beṭae zanu tar ḳala ba fufur loge zina na ḳore, arnae afon lour kuṭumre beijjoti korae tara duio zone shaza faibo. ");
INSERT INTO syll_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Ḳeu zudi tar sasi ba mamir loge zina ḳore, te tara duio zone shaza faibo, niaoladi halote tarar moron oibo, he to tar sasa ba mamare beijjot ḳorse. ");
INSERT INTO syll_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Bai zinda taḳte zudi aroḳ baie tar babire hanga ḳore, te tar baire beijjot ḳorae, iṭa boṛo naformani. Tara kunu aolad faita nae. ");
INSERT INTO syll_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“Tumra boshot ḳorar lagi ami tumrare ze desho niar, hou deshor maṭie zanu tumrare bomi koria na falae. Erlagi tumra amar batail hoḳol shoriot ar niom-ḳanun oḳol amol ḳorio. ");
INSERT INTO syll_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Tumrar samne taki ami zeta zati oḳolre ḳedai diram, itar sal-cholone tumra solio na. Tarar hou sal-cholonor lagi-u ami tarare lannot disi, ");
INSERT INTO syll_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","erlagi-u ami tumrare oada dislam tarar deshre ami tumrar doḳole dimu, tarar hou dud ar mour banḍar-ala desh ami tumrare dan ḳormu. Ami Alla-u tumrar Mabud, zogotor hoḳol zati taki ami-u tumrare alada ḳorsi. ");
INSERT INTO syll_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Erlagi tumra halal ar haram foshuintor maze tofat rakio, halal ar haram fakintor maze tofat rakio. Foshu-faki ar maṭir ufre solra huru huru zandaror maze zetare ami haram ḳoisi, ota dia tumra nizor shorilre nafak banaia lannoti bonio na. ");
INSERT INTO syll_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Ami Mabud to fak-fobitro, erlagi tumra-o fobitro oite oibo. Amar afon proza oar lagi ami-u tumrare zogotor hoḳol zati taki basia alog korsi. ");
INSERT INTO syll_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“Zeta beṭa ba beṭinte zin-but shadon, gonoḳ ba zadu-ṭunar ḳam ḳore, itare zane marilibae. Fattordi iṭaia zane marilibae, tarar moutor lagi tara-u dayi.” ");
INSERT INTO syll_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Erbade Mabude Musare ḳoila, “Tumi Harunor bongshor imam oḳolre ḳoio, tarar kunu kuṭum-ḳeshor moutor ḳarone mattom ḳoria tara zanu nizore nafak na banae. ");
INSERT INTO syll_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Ḳali tarar nizor ma-baf, fua-fuṛi ba afon bai mara gele tara nizore nafak banani zaiz ase. ");
INSERT INTO syll_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","Ar bair goro roura abiati kunu boin mara gele taire dafon-ḳafonor lagi tair bai nafak bona zaiz. ");
INSERT INTO syll_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Oile hour baṛir kunu kuṭum-ḳeshor moutor dae kunu imam sabe nizor fobitro halot taki nafak bona zaiz nae. ");
INSERT INTO syll_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“Imam sab oḳlor matar sul ḳamani, daṛir aga saṭa, ba nizor shorilo kunuzat ḳaṭa-sira ḳora zaiz nae. ");
INSERT INTO syll_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Tara zanu afon Allar fobitro namre oshomman na ḳoroin, ar pak-pakiza roia zindegi kaṭain. Oḳan mono raḳoin zen, ou imam oḳole-u Mabudor name agunit deoa sodga ar kurbani oḳol adae ḳoroin, ar kurbanir mal to nizor Allar dorbaror rizek. ");
INSERT INTO syll_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Imam oḳole kunu bodmaish, silan ba talaḳ faoa kunu beṭire bia ḳora zaiz nae. Ḳaron tarar afon Allar name tara fobitro. ");
INSERT INTO syll_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","O Boni Israil, tumra imam sab oḳolre hamesha fobitro hishabe manio, tara-u to tumrar Allar dorbaro kurbanir ḳani shofia dein. Erlagi-u tarare fobitro ḳoia manio, mono rakio, ami-u tumrare fobitro banaisi, ar ami nize to fak-fobitro. ");
INSERT INTO syll_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Kunu imamor fuṛi zudi silani-bodmaishir fote gia nafak bonizae, te tair bafre-o tai beijjot ḳorilae. Erlagi taire aguindi zalaia marilibae. ");
INSERT INTO syll_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“Ar imam foribaror baiaintor maze hoḳol boṛo zein, ein-u to fordan imam, en matat ḳelafoti shomzibar tel ḍala oise, ḳelafoti shomzia tain fordan imamor fobitro lebas findibar dayitto faisoin. Erlagi kunu murdar lagia ḳandon-ahazarir niote tan matar faugṛi kulia sul aula-zaula ḳora, ba tan finnor lebas siṛa-o zaiz nae. ");
INSERT INTO syll_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Ein kunu mora lashor ḳandat zaoa zaiz nae. Nizor ma-baf mara gele-o ein nizore nafak banani zaiz nae. ");
INSERT INTO syll_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Zekunu murdar lagi tain Allar fobitro Kaba gor saṛia kunuḳano gia Allar ou gorre nafak banani tan lagi haram. Mono rakio, tan afon Allar namor ḳelafoti shomzibar tel ḍalia tanre fobitro banail oise. Ami-u to Mabud. ");
INSERT INTO syll_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“Kunu abiati shoti koinare shadi kora tan lagi zaiz ase. ");
INSERT INTO syll_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Oile kunu ṛaṛi beṭi, bodmaish-silan beṭi ba talaḳ faoa kunu beṭire imam sabe shadi kora zaiz nae. Ḳali nizor gusṭir kunu abiati shoti koinare shadi kora tan lagi zaiz. ");
INSERT INTO syll_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Arnae tan ḳarone tan nizor ḳandanor maze tan aolad oḳol fobitro halot taki nafak bonbo. Ami-u to Mabud, ami-u tanre fak-fobitro banaisi.” ");
INSERT INTO syll_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Erbade Mabude Musare aro ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Tumi imam Harunre zanai deo, tan ḳandanor mazor shorilor kut ala kunu zone-u Allar name kurbani adae ḳorar niote, kurbani kanar ḳandat zaoa nished. ");
INSERT INTO syll_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Ze zonor shorilo kut ase, mani anda, lengṛa, nak-kaṭa, at-fao niomor beshi lamba-baṭṭi ba anguil ḳom-beshi, ");
INSERT INTO syll_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","at ba fao banga, ");
INSERT INTO syll_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","fiṭ guza, baṭṭi bengai manush, souḳor bemari, daud-ḳauzli, fosa-ga bemari ba onḍokush nosṭo, ila kut ala kunu manush kurbani kanar ḳandat zaoa zaiz nae. ");
INSERT INTO syll_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Imam Harunor bongshor shorilor kut ala kunu zone Mabudor name agunit deoa kurbani adae ḳora nished. Tar gotro kut taḳae he kurbani kanar ḳandat gia amar namor ḳanire kurbani deoa zaiz nae. ");
INSERT INTO syll_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Oile ou kurbanir ḳani kaoa tar lagi zaiz, ita fobitro ba ḳas-fobitro oile-o zaiz ase. ");
INSERT INTO syll_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Tar shorilo kut taḳae he Kaba goror Herem Shorifor fordar ḳandat ba kurbani kanar ḳandat zaoa nished, he zanu amar fak-fobitro zaga oḳolre nafak na banae. Mono rakio, ami-u Mabud, ar ami-u ou zagaintore fobitro ḳori.” ");
INSERT INTO syll_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Bade Musae gia ita hoḳolta imam Harun, tan fuain ar hoḳol Boni Israilre zanaila. ");
INSERT INTO syll_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Erbade Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Tumi imam Harun ar tar fuaintore ḳo, Boni Israile amar name lilla ar kurbani dibar niote zotota anoin, ita to fobitro. Erlagi ota hokkoltare imam oḳole ijjot-tazim ḳora zorur. I befare tara zanu amar fak-fobitro namre oshomman na ḳore. Ami-u to Mabud. ");
INSERT INTO syll_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Tumi tarare zanai deo, tarar aolador mazor ḳeu zudi nafak halote Mabudor name deoa kurbanir kunu zinishor ḳandat zae, te tare amar samon taki horailibae. Ami-u to Mabud. ");
INSERT INTO syll_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Harunor aolad oḳlor maze ḳeu zudi fosa-kusṭo bemari ba datu zaoa bemari oy, te fak-saf na oa forzonto he kurbanir kunuta ḳaoa nazaiz. Ar mora lashre ba ou lashor lagi zeta ḳamo lagail oise ita kunuta soia zudi keu nafak bone, ba ḳeuror zoubonor fani bar oy, ");
INSERT INTO syll_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ar ze zon kunuzat maṭit solra huru-muru nafak zandar ba zekunu ḳarone nafak oa kunu manshore soia he nizore nafak banae, ");
INSERT INTO syll_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","te hainja forzonto he nafak halote-u roibo, ar fanidi naia hari fak-saf na oa forzonto kurbanir kunu fobitro zinish ḳaoa tar lagi haram. ");
INSERT INTO syll_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Bade shuruz ḍubia harle he zebla fak-saf oibo, ou shomoy he ita ḳaito farbo. Ita to tar-u ḳani. ");
INSERT INTO syll_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Imame kunu mora foshu ba zongli zanuaror tabae mara kunu foshur gust ḳaia nizore nafak banaio na. Ami-u to Mabud. ");
INSERT INTO syll_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“Imam oḳlor befare ami zeta ain-ḳanun disi, ita tara mania solouk. Arnae dushi bonbae ar nafakir dorun tarar moron oibo. Mono rakio, ami Mabude-u tarare fobitro ḳori. ");
INSERT INTO syll_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Imam foribaror manush saṛa dusra kunu zone kurbanir fobitro zinish ḳaoa nished. Imamor kunu meman ba ḳamlae-o ita ḳaoa haram. ");
INSERT INTO syll_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Oile imamor ḳorida gulame ba tan baṛit zonmise ilaḳan gulame ita ḳaoa zaiz. ");
INSERT INTO syll_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Imamor fuṛi zudi aroḳ imam saṛa baira kunu damandor loge bia-shadi oy, te tai-o kurbanir ou fobitro zinish ḳaoa haram. ");
INSERT INTO syll_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Oile imamor kunu ṛaṛi fuṛi ba talaḳ faoa niaoladi kunu fuṛi zudi bafor baṛit roibar lagi hirbar aioy, te tai to bafor ḳanir ongsho faibo. “Imam foribaror baira kunu zone kurbanir fobitro kunu ḳani kaoa zaiz nae. ");
INSERT INTO syll_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Ḳeu zudi bul ḳoria ita ḳailae, te i zone imamor gese ḳeti-furon dite oibo. Ou ḳanir damor loge aro fas baṭor eḳ baṭ dam beshi dite oibo. ");
INSERT INTO syll_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Boni Israile Mabudor name tarar ze zinish fobitro kurbani hishabe dan ḳoroin, imam oḳole zanu itare ofobitro na banain. ");
INSERT INTO syll_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Tara baira manshore ita ḳaite dia manshore dushi banaia ḳeti-furonor daṛo zanu na falain. Mono rakio, ami Mabude-i tarare fobitro ḳori.” ");
INSERT INTO syll_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Bade Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Tumi gia imam Harun, tar fuain ar hoḳol Boni Israilre ḳo, tumrar kunu manshe ba tumrar loge boshot ḳorra bin-deshi kunu zone zudi mannot adae ḳorar lagi ba nizor kushie nofol kurbani hishabe Mabudor name zalail kurbani dibar niote kunuta loia ae, ");
INSERT INTO syll_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","te ikṭa oite oibo egu nikut bisal, meṛa ba sagolor faṭa. Ila na oile to Mabude kobul ḳorta nae. ");
INSERT INTO syll_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Kut ala kunu foshudi zanu kurbani adae na ḳore, ḳorle-o tar kunu fayda oito nae. ");
INSERT INTO syll_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Kunu mannot adae ḳorar lagi ba nizor kushie nofol kurbani hishabe ḳeu zudi Mabudor name salamoti kurbani dito sae, te itar lagi egu nikut goru, meṛa ba sagol ante oibo. Gotro kut ala kunu foshudi kurbani dile ita kobul oito nae. ");
INSERT INTO syll_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Kunu manshe zanu kurbanir niote anda, lengṛa, ḳaṭa-sira, kunu ongo ḳaṭa, fuzala ga, ba daud-ḳauzli kunu foshure Mabudor dorbaro na ane, zalail kurbanir lagi ola kut ala kunu foshure kurbani kanar ufre tulio na. ");
INSERT INTO syll_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Ta-o foshur kunu ongo niomor beshi lamba ba baṭṭi taḳle, olaḳan foshure nizor kushie nofol kurbani hishabe dita farba, oile kunu mannot furonor lagi ilaḳan kurbani kobul oito nae. ");
INSERT INTO syll_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Kunu foshur onḍokush zudi tetla, sesa, ḳaṭa-sira taḳe, te itare tumra Mabudor name kurbani dio na, nizor desho gia ila ḳorio na. ");
INSERT INTO syll_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Bin zatir kunu manshor ges taki olaḳan foshu ania tumrar Allar name kurbani dio na. Itar gotro kut taḳae itadi kurbani dile tumrar kunu fayda oito nae.” ");
INSERT INTO syll_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Bade Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Zonmor bad taki shat din forzonto goru ba sagol ba meṛa-baichchare tar maʼr loge roite dibae. Aṭ nombor din taki itare Mabudor name agunit deoa kurbani hishabe deoa zaibo. ");
INSERT INTO syll_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Ta-o gai ar tair basurre, meṛi ba sagi ar tair baichchare, eḳoi dine zobo ḳora haram. ");
INSERT INTO syll_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Tumra Mabudor name kunu shukurana kurbani dite saile, ita ou nomunae adae ḳorio zela tain kushi oin. ");
INSERT INTO syll_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Kurbanir gust kurbanir dinor maze ḳailite oibo, ita bador din bian forzonto toa haram. Ami-u to Mabud. ");
INSERT INTO syll_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Tumra amar hukum manio ar ou laḳan solio. Ami-u to Mabud. ");
INSERT INTO syll_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Tumra amar fak-fobitro namre oshomman ḳorio na, zate Boni Israilor maze ami fak-fobitro hishabe goinno oi. Ami Allae tumrare fak-fobitro banai. ");
INSERT INTO syll_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Ami tumrar Mabud oar niote tumrare Mishor desh taki bar ḳori anchi. Ami-u to Mabud.” ");
INSERT INTO syll_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Bade Mabude Musa nobire ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Tumi Boni Israilre zanai deo, ami Mabude tumrar lagi ou id oḳol ṭik korlam, tumra itare fobitro milon-mahfilor din hishabe manbae. ");
INSERT INTO syll_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“Haftat soy din tumra ḳam-ḳaz ḳorio, ar shat nombor din oilo ziraibar din, fobitro milon-mahfilor Zummabar. I din tumra kunu ḳam-ḳaz ḳorio na, tumra zekunu zagat boshot ḳoro, i din ḳan tumrar Mabudor name fobitro Zummabar hishabe manio. ");
INSERT INTO syll_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“Tumrar lagi amar ṭik kora zoto id ase, mani fobitro milon-mahfilor din hishabe zeta mantae, ita ami koiram. Ita oilo: ");
INSERT INTO syll_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“Bosoror foyla sandor souddo tarikor hainja taki Mabudor name Azadi Id arombo oibo, ");
INSERT INTO syll_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","ar ou sandor fonro tariko Mabudor name Ḳamir Saṛa Ruṭir Id arombo oibo. Fura shat din tumra ḳamir saṛa ruṭi kaibae. ");
INSERT INTO syll_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Ou shat dinor foyla din tumrar fobitro milon-mahfil oibo, ou din duniabi niote kunuzat ḳam-ḳaz ḳora tumrar lagi haram. ");
INSERT INTO syll_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Ou shat dinor forteḳ din tumra Mabudor name agunit deoa kurbani dibae. Bade shat nombor din tumrar fobitro milon-mahfil oibo, ou din tumra duniabi niote kunu ḳam-ḳaz ḳora haram.” ");
INSERT INTO syll_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Mabude Musa nobire aro ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Tumi Boni Israilre zanai deo, ami Mabude tumrare ze desh oḳlor malikana diram, hono gia harle tumra zotobar zominor foshol daibae, otobar ḳetor foyla ḳaṭa ekkan muiṭ loia imam sabor gese zaio. ");
INSERT INTO syll_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Gele imame ou muiṭ nia Mabudor samne dulaiba. Zummabaror bador din tain ikan dulaiba, teu Mabud tumrar ufre kushi oiba. ");
INSERT INTO syll_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Imam sabe zedin ou muiṭ dulaiba, ou din tumra Mabudor name eḳ bosor boyoshi egu nikut meṛa-baichchare zalail kurbani hishabe dibae. ");
INSERT INTO syll_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Erloge dan-gomor sodgar lagi tel maḳail sair sher moyda dibae. Ita to Mabudor namor agunit deoa sodga, itar dumar gerane tain kushi oin. Ar er logor shorbot-fanir sodgar niote anguror eḳ sher shorbot-o dibae. ");
INSERT INTO syll_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Tumrar ḳetor foshol daia hari, tumrar Allar namor ou sodga adae ḳorar ag forzonto noya foshol tumra ḳaio na. Itadi ruṭi banaia ba agunit bazia ḳaoa-o nished. Tumra zeno-u ro na ḳene, oarishor for oarish dori siroḳal ou niom manio. ");
INSERT INTO syll_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“Ar ou Zummabaror bador din, mani zedin dulona kurbani lagi fosholor muiṭ loia aibae, ou din taki shat haftae shat Zummabar gonibae. ");
INSERT INTO syll_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Ou shat Zummar bador din, mani foinchash dinor din tumra Mabudor name noya fosholor sodga adae ḳorbae. ");
INSERT INTO syll_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Tumra nizor baṛi taki Mabudor name dulona kurbani dibar niote ḳetor foyla foshol taki kisu foshol anio. Tumra sair sher moydadi banail ḳamir furail dukan nan ruṭi anio. ");
INSERT INTO syll_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Ou ruṭir loge eḳ bosor boyoshi shatṭa nikut meṛa-baichcha, eḳṭa bisal, meṛar duiṭa faṭa anio. Ou foshu oḳol dia Mabudor name ekkan zalail kurbani adae ḳorbae, otar loge niom mafik dan-gomor sodga ar shorbot-fanir sodga-o dibae. Ita to agunit deoa eḳ nomunar kurbani, itar dumar gerane Mabud kushi oin. ");
INSERT INTO syll_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Bade tumra gunar koforar kurbani hishabe egu faṭa sagol, ar salamoti kurbanir lagi eḳ bosor boyoshi dugu meṛa-baichcha kurbani dibae. ");
INSERT INTO syll_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Imam sabe dulona kurbani hishabe Mabudor samne ou duio meṛa-baichcha ar ḳetor foyla fosholdi banail ruṭi nia dulaiba. Ita to Mabudor namor kurbanir fak-fobitro samana, ita imam sabor faona. ");
INSERT INTO syll_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Ḳetor foshol daoar ou idor din tumra eḳṭa fobitro milon-mahfil ḳorio. Ou din duniabi niote kunu ḳam-ḳaz ḳorio na. Tumra zeno-u ro na ḳene, oarishor for oarish dori hor-hamesha ita amol ḳorio. ");
INSERT INTO syll_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“Tumra zebla ḳetor foshol daibae, ou shomoy tumra zominor ailor ḳandar foshol saf ḳoria ḳaṭio na, ar daoar bade ou zomino falail foshol lurio na. Gorib-duki ar bideshi musafiror lagi ita toio. Mono rakio, ami Alla-u tumrar Mabud.” ");
INSERT INTO syll_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Bade Mabude Musa nobire ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Tumi Boni Israilre zanai deo, bosoror shat nombor sandor foyla dinre tumra furafur ziranir din hishabe manio. Ou din tumra shinga bazaio ar hoḳole milia idor fobitro milon-mahfil ḳorio. ");
INSERT INTO syll_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Ou din tumra duniabi niote kunu ḳam-ḳaz ḳorio na, ḳali Mabudor name agunit deoa sodga adae ḳorio.” ");
INSERT INTO syll_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Ou shat nombor sandor dosh nombor din oilo Koforar Idor din. I din tumra eḳṭa fobitro milon-mahfil ḳorio. Forteḳ zone noto oia zarzir dil shofia dia Mabudor name agunit deoa sodga adae ḳorio. ");
INSERT INTO syll_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Ita oilo Koforar Id, tumrar Mabud Allar samne tumrar gunar kofora adae ḳora oibo, asta i dino kunuzat ḳam-ḳaz ḳora haram. ");
INSERT INTO syll_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Ze manshe hou din noto oia nizor dil shofia na dey, tar nam i zatir maz taki miṭailibae. ");
INSERT INTO syll_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Ar hou din zudi keu kunu ḳam-ḳaz ḳore, te tar nam ami i zatir maz taki shesh ḳorilimu. ");
INSERT INTO syll_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Ou din tumra kunuzat ḳam-ḳaz ḳorio na. Tumra zeno-u ro na ḳene, oarishor for oarish dori hor-hamesha ou niom manio. ");
INSERT INTO syll_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ou din oibo tumrar lagi fobitro Zummar din, erlagi noto oia dil shofia dio. Ou sandor noy nombor dinor hainja taki bador din hainja forzonto fobitro ou Zummar din manio.” ");
INSERT INTO syll_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Erbade Mabude Musa nobire ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Tumi Boni Israilre ḳo, ou shat nombor sandor fonro tarik taki Mabudor name Ḍera-goror Id arombo oia, shat din forzonto id solbo. ");
INSERT INTO syll_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Ou shat dinor foyla din tumrar fobitro milon-mahfil oibo. I din tumra duniabi niote kunu ḳam-ḳaz ḳorio na. ");
INSERT INTO syll_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Ou idor shato din tumra Mabudor name agunit deoa kurbani adae ḳorbae. Bade aṭ nombor dino tumra hirbar fobitro milon-mahfil ḳorbae ar Mabudor name agunit deoa kurbani dibae. Iṭa oilo shesh dinor aḳeri mahfil, ou dino tumra duniabi niote kunu ḳam-ḳaz ḳorio na. ");
INSERT INTO syll_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“Asta bosoror maze zoto laḳan id ase, ota hokkol zator id oḳol to Mabude-u dairjo ḳori disoin. Erlagi idor ou din oḳolre tumra fobitro milon-mahfilor din hishabe manio, er forteḳ din zeta zeta ḳora zorur, ita adae ḳorio. Mani, zalail kurbani, dan-gomor sodga, nizor kushie salamoti kurbani, ar er logor shorbot-fanir sodga. Ou kurbani oḳol Allar dairjo ḳora dino tumra adae ḳorio. ");
INSERT INTO syll_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Oile kial rakio, tumrare batail ota hokkol laḳan id oḳlor kurbani ar lilla-sodgare adae ḳoria, Mabudor name Zummabaror kurbani, hoḳol nomunar lilla-sodga, mannot ar nizor kushie deoa salamoti kurbanire-o adae ḳorio. Hota id oḳlor kurbanir loge itare milaio na, alada rakio. ");
INSERT INTO syll_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“Ar shat nombor sandor fonro tariko, ḳetor hoḳol fol-foshol tular bade, tumra Mabudor name shat din doria Ḍera-goror ou id adae ḳorio. Ou shat dinor foyla din ar sheshor aṭ nombor din oilo tumrar furafur ziraibar din. ");
INSERT INTO syll_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Er foyla din tumra tortaza gasor ḍal fala, mani kezur fata, hoḳol nomunar fata-bahar gasor ḍal fala, ar gangor faror izol gasor ḍal loia azir oio. Oia ou shato din tumra nizor Mabud Allar samne kushi-bashi korio. ");
INSERT INTO syll_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Forteḳ bosoror shat nombor sandor shat din tumra Mabudor name i id adae ḳorio. Oarishor for oarish dori hor-hamesha ita manio. ");
INSERT INTO syll_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Fura shat din tumra hoḳol gia ḍera-goro roio, Boni Israilor hoḳol manush ou shomoy ḍera-goro takio. ");
INSERT INTO syll_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Teu ota dekia hari tumrar aolad oḳole-o buzba, Boni Israilre Mishor desh taki bar ḳori ania harle ami morubumir maze tarare ola ḍera-goro boshot ḳoraislam. Mono rakio, ami Alla-u tumrar Mabud.” ");
INSERT INTO syll_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Erbade Musa nobi gia Mabudor batail ou hoḳol idor ḳota Boni Israilre zanaila. ");
INSERT INTO syll_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Bade Mabude Musa nobire ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Tumi Boni Israilre hukum deo, serag danir serag oḳol hamesha zalaia raḳar niote, tara zoytun sesia ḳaṭi tel banaia tumar gese loia aito. ");
INSERT INTO syll_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Ar Kaba goror bitre shahadot shondukor fordar bare, imam Harune hainja taki fozor forzonto serag danir serag oḳol zalai raḳba. Oarishor for oarish dori hor-hamesha ita zari roibo. ");
INSERT INTO syll_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Mabudor samne toa ou ḳaṭi shunar serag danir serag oḳolre tain hamesha zae-zoton ḳorba. ");
INSERT INTO syll_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Ar huno, moyda dia baro ḳan ruṭi banaio, forteḳ ruṭi oibo dui sher moydar. ");
INSERT INTO syll_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Banaia ou ruṭire Mabudor samnor ḳaṭi shunar ṭebulor ufre soyḳan soyḳan ḳori dui laine hazai toio. ");
INSERT INTO syll_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Forteḳ lainor ruṭir daro ḳaṭi loban-agor toio. Toia nishana hishabe ruṭir bodla ou agordi Mabudor name agunit deoa kurbani adae ḳorio. ");
INSERT INTO syll_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Forteḳ Zummabare Boni Israilor fokko taki fobitro ou ruṭire imam sabe Mabudor nozoror samne hazaia toiba. Tarar ou ruṭi deoa to hor-hamesha siroḳal zari roibo. ");
INSERT INTO syll_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Bade imam Harun ar tan bongshodore fobitro Kaba goror shimanar bitre ou ruṭi kaiba, ita oilo Mabudor name agunit deoa kurbanir zinishor maze ek kas fobitro zinish. Ita to imam oḳlor faona, ou niom hor-hamesha zari roibo.” ");
INSERT INTO syll_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Boni Israilor maze ola eḳ beṭa asil, zegur baf oilo Mishori ar ma Boni Israil zatir. I beṭae ar Boni Israilor aroḳ beṭae kempor bitre maramari laglo. ");
INSERT INTO syll_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Ou shomoy Boni Israili beṭir fuae Mabudor name kufuri mat matia lannot dilo. Ita hunia manshe tare Musa nobir gese loia gela. Ou beṭar maʼr nam Shalumi, tai asil Dan ḳandanor Dibrir fuṛi. ");
INSERT INTO syll_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ar manshe ou befare Mabudor morzi hunar lagi ou beṭare aṭḳaia toila. ");
INSERT INTO syll_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Bade Mabude Musa nobire ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Amar name lannot deora ou beṭare loia kempor bare zao. Gele zeta manshe ou kufuri mat hunche, tara hoḳole ogur mata atai deuk, bade shomazor hoḳol manshe fattor maria tare zane marouk. ");
INSERT INTO syll_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Ar tumi Boni Israilre zanai deo, ze manshe Allare lannot dey, tar naformanir lagi he nize-u dayi. ");
INSERT INTO syll_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Ar ze manshe Mabudor name kufuri mat matibo, tare zane marilibae. Boni Israilor shomaze tare fattor maria zane marba. He Boni Israili ouk ba tarar loge boshot ḳorra bin zatir manush ouk, Allar name zegie kufuri mat matibo, tare nichchit zane marbae. ");
INSERT INTO syll_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“Kunu manshe zudi dusra manshore kun ḳorilae, te tumra tare-o kun ḳorbae. ");
INSERT INTO syll_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Kunu manshe zudi dusra manshor kunu foshure marilae, te ogur bodla he aroḳ foshur dam dia ḳeti-furon dibo. Zanor bodla zan. ");
INSERT INTO syll_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Ḳeu zudi aroḳzonre mare, ar ou mairor lagi shorilor kunu ongor ḳeti oy, te he zela ḳeti korse, tar ongore-o ola ḳeti korbae. ");
INSERT INTO syll_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Aḍḍi bangar bodla aḍḍi bangibae, souḳor bodla souk, dator bodla dat. Hou zonor ze ongore he ḳeti korse, tar-o ola ḳeti korbae. ");
INSERT INTO syll_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Kunu foshure zane marle er ḳeti-furon dite oibo, oile kunu manushre kun ḳorle tare-u zane marilibae. ");
INSERT INTO syll_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Boni Israil ba tumrar loge boshot ḳorra bin zatir manshor lagi ou eḳoi ain zari roibo. Mono rakio, ami Alla-u tumrar Mabud.” ");
INSERT INTO syll_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Bade Musa nobie Boni Israilre ita hoḳolta zanaila. Teu ze beṭae hou kufuri matisil, manshe ogure kempor bare nia fattor maria zane marilila. Mabude Musare zela hukum disla, Boni Israile ṭik ola-u ḳorla. ");
INSERT INTO syll_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Ar Mabude Tur faṛor ufre Musa nobire ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Tumi Boni Israilre zanai deo, ami ze deshḳan tumrare diar, hou desho gia harle tumra kial rakio, honor zomi-maṭie zanu Mabudor name aram ḳorar shomoy fae. ");
INSERT INTO syll_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Tumra soy bosor zomino ḳet-ḳamar ḳorio, angur gasor ḍal fala saṭia foy-foshol baṛit anio. ");
INSERT INTO syll_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Oile shat nombor bosor zomi-zomare ziranir shuzug dio. Iṭa oilo Mabudor niote aramor bosor. Ou bosor tumra zomino ḳet ḳorio na, angur gasor ḍal fala saṭio na. ");
INSERT INTO syll_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Ar zominor maze emne-u zeta folibo, ita nia tumrar ugaro toio na. Bina zotone angur gaso zeta fol dorbo, ita faṛia nia zomaio na. Hoḳol zomi-zomare fura eḳ bosor ziranir shomoy dio. ");
INSERT INTO syll_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Ziranir bosor zomino emne zeta folibo, ita to tumra nizor, tumrar gulam-bandir, tumrar deshor bin-deshi musafir, tumrar shomazor menoti kamla, hoḳol zator manshor, ");
INSERT INTO syll_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","tumrar fala heman, ar deshor zongli zanuaror ḳani-kuraḳ oibo. Ou bosor zomino emne zeta folibo, ita tumra hoḳole ḳaio. ");
INSERT INTO syll_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“Ar huno, shat bosor ḳori kori shatḳan ziranir bosorre tumra gonio, gonile shatbar shat bosore unufoinchash bosor oibo. ");
INSERT INTO syll_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Er bador bosor, mani foinchash nombor bosor, ou bosoror shat nombor sandor dosh nombor din, ita to gunar kofora adae ḳorar din, hou din tumra asta deshor hoḳol zagat shinga bazaio. ");
INSERT INTO syll_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Ou foinchash nombor bosorre tumra fak-fobitro manio, deshor hoḳol manshore azadir ḳota zanaio. I bosor oilo tumrar zomi-mirash Firot Faoar Bosor. Ou bosor tumra zarzir foribar ar ḳandanor zomi-zomar doḳoldari firot faibae. ");
INSERT INTO syll_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Forteḳ foinchash nombor bosor oibo, tumrar doḳoldari Firot Faoar Bosor. Ou bosor tumra zomino kunu bisi bain ḳorio na, zomino emne-u zeta zonmibo ita tumra nio na. Ar bina zotone angur gaso zeta fol dorbo, ita-o tumra goro anio na. ");
INSERT INTO syll_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Ou bosor oilo Firot Faibar Bosor. Tumra ou bosorre fak-fobitro hishabe manio. Zomino zeta foshol faibae, ota-u tumra ḳaio. ");
INSERT INTO syll_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“Firot Faoar Bosoro tumra forteḳe zarzir foribaror zomi-mirasho firia zaio. ");
INSERT INTO syll_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Nizor zomi-zoma ḳorid-bikir shomoy tumra afon ba for ḳeuror ufre zur-zobordosti korio na. ");
INSERT INTO syll_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Zomi korid ḳorar shomoy ḳorid-biki korra duio zone kial raḳbae, firot aoar hou foinchash bosor bade ḳotodin gesegi, ar samnor foinchash bosor furte ḳotodin baki ase, oḳan hishab ḳoria zominor dordam ṭik korbae. ");
INSERT INTO syll_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Zudi beshi bosor foshol faoar shomoy taḳe te dam-o beshi oibo, ar ḳom oile dam-o ḳombo. Ashole foshol faoar bosoror ufre-u ḳorid-bikir dam ṭik oibo. ");
INSERT INTO syll_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Tumra nizor shomazor ḳeuror ufre zur-zulum ḳorio na. Forteḳ zon-u Allar ḍor-ḳofe solio. Mono rakio, ami Alla-u tumrar Mabud. ");
INSERT INTO syll_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“Tumra amar batail shoriot ar hoḳol hukum-ahkam hamesha manio. Teu tumrar desh oibo nirafod boshot ḳana. ");
INSERT INTO syll_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Ar tumrar ḳetor zomin taki shullo-ana foshol faibae, faia feṭ bori kaia daia hono nirafode boshot ḳorbae. ");
INSERT INTO syll_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Tumra mone mone ḳoitae faro, shat nombor bosoro zudi kunu ḳet na ḳori ar foshol na ḳaṭi, te amra ḳaimu kita? ");
INSERT INTO syll_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Er zuaf oilo, soy nombor bosoro ami tumrar zomino ola rohom-borkot dimu, zomino tin bosoror homan foshol faia ḳaia-findia basbae. ");
INSERT INTO syll_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Erlagi aṭ nombor bosoro ḳet ḳorar bis bain deoar shomoy-o ou furana foshol ḳaibae, ar noy nombor bosoror foshol daibar ag forzonto ou foshole-u tumrar ḳani-kuraki solbo. ");
INSERT INTO syll_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“Mono rakio, siroḳalor lagi keuror zomi-zoma ḳorid-biki solto nae. Ashole hoḳol zominor malik to ami Alla, tumra amar samne hono ḳali bin-deshi musafir. ");
INSERT INTO syll_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Tumra forteḳ zonor ḳorida zomi-mirash bikidarre hirbar firot nibar shuzug dio. ");
INSERT INTO syll_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Tumrar zatir kunu bai obabo foṛia zudi tar foribaror zominor kisu ongsho besilae, te tar hoḳol taki afon zone aia ou besa zomi saṛaia nite oibo. ");
INSERT INTO syll_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ḳeuror zudi saṛaia nibar manush na taḳe, te he nize don-samana zomaia hari nize-u zudi saṛaia nito sae, ");
INSERT INTO syll_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","te tar bikir bosor taki saṛani forzonto shomoy hishab ḳoria, malikor faona ṭeḳa dia tar zomi firot nibo. ");
INSERT INTO syll_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Oile zomi firot nibar samana he zomaite na farle, tar besa zomin Firot Faoar hou foinchash bosor furar ag forzonto ḳoriddare ḳaiba, ar foinchash bosoror ḳalo tare firot diba, he tar zomin emne-u bina foyshae firot faibo. ");
INSERT INTO syll_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“Ar baunḍori kora nirafod ṭaunor kunu basha-baṛi zudi keu besilae, te besar bade fura eḳ bosoror maze he ou baṛi firot nito farbo. Fura eḳ bosoror maze he firot nibar shuzug faibo. ");
INSERT INTO syll_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Eḳ bosoror maze iṭa firot na nile, siroḳalor lagi ou baṛi koriddar ar tar oarishor oibo. Firot Faoar Bosoro iṭa firot faito nae. ");
INSERT INTO syll_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Oile zeta gau-geramo kunu baunḍori nae, ou zagar baṛi-gorre ḳetor zominor laḳan mono ḳorbae. Ita saṛaia ana zaibo, ar Firot Faoar Bosoro firot dite oibo. ");
INSERT INTO syll_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“Ḳali Lebi kandanor ṭaunor baṛi-gor oḳol hamesha firot ana zaibo. ");
INSERT INTO syll_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Tarar ṭaunor kunu baṛi-gor besile, Firot Faoar Bosoro iṭa firot faiba. Tumrar to zana ase, ḳali ṭaunor baṛi-gor-u oilo Lebi kandanor shompotti, Boni Israilor maze tara ou shompotti-u faise. ");
INSERT INTO syll_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Oile tarar ṭaunor daro foshu raḳar bondor zaga tara ḳorid-biki korta farta nae, ita to tarar siroḳalin shompotti. ");
INSERT INTO syll_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“Tumrar nizor shomazor kunu bai zudi goribi halotor lagi tar nizor ḳaoa-finda zugaito na fare, te bin-deshi musafiror laḳan tare-o shaijjo ḳorio, zate he tumrar loge boshot ḳorto fare. ");
INSERT INTO syll_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Tumra tar ges taki kunu nomunar shud ḳaio na. Borong he zate hamesha tumrar gese roibar shuzug fae, ou niote tumra nizor Mabud Allar ḍor-ḳof bitre rakio. ");
INSERT INTO syll_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Tumra shud ḳaibar niote tare ṭeḳa-foysha ḳorzo dio na. Tar gese ḳani-kurakir mal besle itar lab loio na. ");
INSERT INTO syll_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Mono rakio, ami Alla-u tumrar Mabud. Asta Kenan desh dan ḳorar kiale, ar tumrar afon Mabud oar kiale, ami-u tumrare Mishor desh taki bar ḳori anchi. ");
INSERT INTO syll_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“Boni Israili shomazor kunu bai zudi goribi haloto foṛia nize nize tumrar ḳeuror gese biki kailae, te tare ḳorida gulamor laḳan ḳaṭaio na. ");
INSERT INTO syll_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Tumrar musafir ar ruzi kamlar loge zela bebohar ḳoro, tar loge-o ola ḳorio. He hou Firot Faoar Bosor forzonto tumar ḳam-ḳaz ḳorbo. ");
INSERT INTO syll_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Bade tare ar tar fua-fuṛire azad ḳori dio. Teu he tar nizor ḳandanor moy-murobbir zomino firot zaibo. ");
INSERT INTO syll_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Huno, Boni Israil to ḳali amar gulam. Ami tarare Mishor desh taki azad ḳori anchi, erlagi dusra ḳeuror gulamir lagi tarare besar eḳtiar nai. ");
INSERT INTO syll_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Tumra nizor Mabudor ḍor-ḳofe solio, eḳe-oinne fashan-nisṭur bebohar ḳorio na. ");
INSERT INTO syll_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“Tumrar ari-fori zoto zati asoin, otar maz taki tumrar gulam-bandi nitae farbae. ");
INSERT INTO syll_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Tumrar maze boshot ḳorra bin zatir manush taki, ar tarar zeta aolad tumrar desho zonmisoin, otar maz taki-o tumra nizor lagi gulam-bandi nitae farbae. ");
INSERT INTO syll_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Ou laḳan gulam-bandire nizor samana hishabe tumrar fua-fuṛinre-o dia zaitae farbae. Itare hara zindegi tumrar gulami koraitae farbae, oile tumrar nizor zati Boni Israilor ufre fashan malikana ḳaṭaio na. ");
INSERT INTO syll_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Tumrar maze boshot ḳorra bin-deshi kunu manush zudi doni bonizae, ar tumrar kunu bai zudi obabo foṛia tar gese ba tar kunu aolador gese nizore besilae, ");
INSERT INTO syll_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","te he nizore azad ḳorar shuzug faibo. Tar nizor kunu baie tare azad ḳorto farbo. ");
INSERT INTO syll_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Tar sasa ba sasar goror baie, ba tar ḳandanor afon zekunu zone tare azad ḳoraita farba. Nizor halot bodlailite farle, he nizore nize azad ḳorto farbo. ");
INSERT INTO syll_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Ze bosor nizore besisil ou bosor taki hishab ḳoria firot aoar bosor forzonto zoto bosor baki taḳe ou shomoykur ḳamor betonor hishab-nikash mafik tar azadir dam ṭik kora oibo. ");
INSERT INTO syll_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Firot Faoar Bosor zudi beshi duroi oy, te ze dame he nizore besisil, ou damor boṛo eḳ ongsho tar azadir bodla hishabe dite oibo. ");
INSERT INTO syll_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Ar Firot Faoar Bosor aite zudi kom shomoy baki roy, te ou shomoy hishabe ṭeḳa dia he nizore azad ḳorto farbo. ");
INSERT INTO syll_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Tare bosor chukti kamlar laḳan dekio, ar kial rakio, malike zanu tar loge fashan bebohar na ḳore. ");
INSERT INTO syll_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Ola kunu laḳan ufaye zudi he azad oito na fare, te tare ar tar fua-fuṛire Firot Faoa Bosoror shomoy emne-u azad ḳori dilaite oibo. ");
INSERT INTO syll_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Mono rakio, Boni Israil to ḳali amar gulam. Ami tarare Mishor desh taki azad ḳori anchi, tara ḳali amar. Ami Alla-u tumrar Mabud. ");
INSERT INTO syll_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“Tumra kunu nomunar deb-debir murti banaio na. Laḳṛidi banail murti, ba kunuzat fattorre devta hishabe boail ḳorio na. Pujar niote fattor kudia banail kunuzat murti tumrar deshor maze rakio na. Mono rakio, ami Alla-u tumrar Mabud. ");
INSERT INTO syll_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Amar deoa forteḳ Zummabar tumra manio, amar fobitro Kaba gorre tumra ijjot ḳorio. Ami-u to Mabud. ");
INSERT INTO syll_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Tumra zudi amar hoḳol hukum-ahkam ar niom-ḳanun mania amol ḳoro, ");
INSERT INTO syll_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","te ami tumrare ṭikmoto meg-fani dimu. Teu tumrar zomino foy-foshol folibo ar gas-gasalie-o fol-mul dibo. ");
INSERT INTO syll_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Tumrar ḳetor foy-foshol oto beshi oibo zen, angur tular shomoy azile-o, tumrar foshol maṛa deoat roibae. Ar zominor maze noya bis bain deoar shomoy azile-o, ou shomoy forzonto angur tulat roibae. Tumra feṭ boria ḳana-fina ḳaibae, ar nirafode nizor baṛit boshot ḳorbae. ");
INSERT INTO syll_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“Ami tumrar desho shanti dimu, tumra shantie gumaibae, ḳeu aia tumrare kunu ḍor-ḳof deḳaito nae. Tumrar desh taki hoḳol zator hingshro zanuarre ami kedai dimu, ar kunu sifai dole-o tumrar desho hamla ḳorat aito nae. ");
INSERT INTO syll_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Tumrar dushmon oḳolre ḳedaia nibae, tumrar sokur samne tarar moron oibo. ");
INSERT INTO syll_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Tumrar ḳali fas zon sifaie eḳ-sho dushmonre, ar eḳ-sho sifaie dosh azar zonre ḳedaia nibae, tumrar dushmon tumrar sokur samne toluaror tole morbo. ");
INSERT INTO syll_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Ami tumrar bae doyar nozore saimu, tumrar aolad baṛaia tumrar ḳandan boṛo ḳormu, ar tumrar loge amar oada-chukti boail raḳmu. ");
INSERT INTO syll_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Noya bosoror foshol tular lagi ugar ḳali korar ag forzonto, agor bosoror fosholdi tumrar ḳana-fina solbo. ");
INSERT INTO syll_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Tumrar bae taki amar muk firaitam nae, tumrar maze-u roibo amar boshot gor. ");
INSERT INTO syll_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ami tumrar loge sola-fira ḳormu, ami oimu tumrar Mabud, tumra oibae amar ḳas proza. ");
INSERT INTO syll_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Kial rakio, ami Alla-u tumrar Mabud. Mishor desh taki ami-u tumrare azad ḳori anchi, zate tumra Mishori oḳlor gulami kora na lage. Tumrar gordona taki zual bangia falaia, mata usa ḳori aṭibar haloto ami-u tumrare anchi. ");
INSERT INTO syll_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“Oile tumra zudi amar ḳota na huno, amar ou hukum-ahkam na mano, ");
INSERT INTO syll_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","amar batail ain-ḳanunre nafosond ḳoro, amar deoa shoriotre elami koro, ar amar hukum na mania, amar oada-chuktir ulṭa solo, ");
INSERT INTO syll_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","te ami tumrar ufre ola ḳaṛa mosibot dimu, tumrar shoril koy oar bemar dimu, gozobi jokka bemar ar bezuita taf oibo, ota bemare tumrar sokur faoar koy oibo, shorilor ḳomzuri aibo. Tumra zomino ḳet ḳorle-o fayda oito nae, tumrar foshol dushmone ḳaibo. ");
INSERT INTO syll_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Ami tumrar ḳeti korat lagizimu, ar tumra nizor dushmonor gese aribae. Tumrare zetae ingsha ḳoroin, otae tumrare shashon ḳorba, ar ḳeu tumrare na ḳedaile-o, tumra zanor ḍore emne-u bagibae. ");
INSERT INTO syll_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Erbade-o zudi tumra amar ḳota na huno, te ami tumrar gunar shat gun beshi shaza dimu. ");
INSERT INTO syll_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Ami tumrar bol-shoktir beṭagiri bangia surmar ḳorilimu. Tumrar matar ufror asmanre luar laḳan, ar faor tolor maṭire tamar laḳan shokto ḳormu. ");
INSERT INTO syll_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Teu tumra oto menot ḳoria-o kunu fol faitae nae. Ḳetor zomino foshol dorto nae, gas-gasalit fol milto nae. ");
INSERT INTO syll_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Tumrar dilor maze zudi amar lagi kunuzator dushmoni taḳe, amar batail hukum zudi tumrar ḳano na hamae, te ami tumrar naformanir lagi shat gun beshi shaza dimu. ");
INSERT INTO syll_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Tumrar maze ami hingshro zanuar faṭaimu, itae tumrar fua-fuṛintore ḳaiba, tumrar foshur falre binash ḳorba, ar tumrar manshor foriman-o ḳomailiba, deshor fot-gaṭ ḳali foṛi roibo. ");
INSERT INTO syll_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Ou hoḳol goṭona goṭar bade-o tumra zudi amar ain-ḳanunor ulṭa solo, ");
INSERT INTO syll_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","te ami nize tumrar dushmon bonia, tumrar gunar shat gun beshi shaza dimu. ");
INSERT INTO syll_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Amar oada-chuktire na manae ami tumrar ufre laṛai-zuddo anaimu. Dushmonre dekia tumra zebla ṭauno gia hamaibae, hono ami tumrar ufre gozobi morki saṛimu, teu tumra dushmonor ato dora foṛbae. ");
INSERT INTO syll_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Ami tumrar ḳani-kurakir maze obab goṭaimu, teu dosh zon beṭie randite eḳ sular beshi lagto nae. Ḳanit boia tumra ruṭi mafi mafi kaibae, feṭ bora ḳani zuṭto nae. ");
INSERT INTO syll_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Ita hoḳoltar bade-o zudi amar ḳota na hunia amar ulṭa solo, ");
INSERT INTO syll_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","te ami gusae aguin oia ami-o tumrar ulṭa solmu, ar tumrar gunar shat gun shaza dimu. ");
INSERT INTO syll_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Feṭor buke ou shomoy tumra nizor fua-fuṛintore sibaia ḳaibae. ");
INSERT INTO syll_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Ami tumrar pujar hoḳol manḍob ar duf-duna zalanir zagare-o binash ḳormu, tumrar deb-debir murtir ufre ami tumrar lashor ṭeki toimu, ami tumrar bae kub ginnar nozore saimu. ");
INSERT INTO syll_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Ami tumrar gau ar ṭaun oḳol, ar hoḳol mosid-mondir binash ḳorilimu. Tumrar sodga-kurbanir dumar geran ami ar kobul ḳortam nae. ");
INSERT INTO syll_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ami tumrar deshor ufre ola gozob dimu, zeta dekia tumrar dushmon oḳole-o ḍoraia ḳafiba. ");
INSERT INTO syll_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Nanan zatir maze ami tumrare sitrai dimu, toluar ato loia ami tumrare ḳedaimu. Tumrar desh binash oibo, tumrar ṭaun ar gau-geram ḳali foṛi roibo. ");
INSERT INTO syll_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","“Tumra dushmonor desho taḳar shomoy, tumrar nizor deshor zomine tar faona ziranir bosor ziraibo. Ou shomoy deshor maṭie tar faona aram faibo. ");
INSERT INTO syll_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Tumra nize taḳar shomoy zebla ou zomin oḳole ziranir bosor faisil na, oḳon desh binashor shomoy itae hou faona zirani ziraibo. ");
INSERT INTO syll_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Tumrar mazor zera gia dushmonor desho basia roiba, tarar bitre ami ou laḳan ḍor-ḳof harai dimu, laṛair ḳalo manshe zela dushmonor at taki basar lagi douṛia bage, oula egu fata foṛar aoaz hunle-u tara douṛia bagiba. ");
INSERT INTO syll_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Toluaror tol taki basar lagi manshe zela zan loia douṛae, ḳeu tumrare na douṛaile-o tumra nize nize douṛaia ola eḳe-oinnor ufre foṛbae. Dushmonor samne tumra ubaitae fartae nae. ");
INSERT INTO syll_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Tumra nanan zatir manshor maze sitria morbae, ar dushmonor deshe tumrare gilia ḳaibo. ");
INSERT INTO syll_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Erbade-o zudi tumrar mazor ḳeu hono basia roy, te tara-o nizor ar tarar moy-murobbir naformanir lagi koy oat roiba. ");
INSERT INTO syll_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“Tara oḳan shikar ḳora lagbo zen, tara ar tarar moy-murobbie amar loge beimani korse, amar hukumor birudita ḳoria guna ḳorse, ");
INSERT INTO syll_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","erlagi ami-o tarar loge dushmonor laḳan bebohar ḳorsi, tarare biṭa-maṭi saṛaia dushmonor desho anaisi. Ota shikar ḳoria tara zudi kator oia norom dile touba ḳoria gunar shaza boite razi oy, ");
INSERT INTO syll_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","te ami Iakubor loge ḳaim ḳora amar oada-chuktir ḳota iad ḳormu, Isʼhakor loge ḳora oada-chuktir ḳotare-o mono ḳormu, ar Ibrahimor loge ḳora amar oada-chuktire iad ḳormu, tarare deoa deshor ḳota-o kial ḳormu. ");
INSERT INTO syll_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","“Tara desh saṛia zaoar bade tarar binash oa desh ḳali foṛi roibo, zominor faona ziranir bosor oḳol-o ziraibo-u ziraibo. Amar hukumor birudita ḳoria naformani korae, amar ainor ulṭa solae tara ola shaza faiba. ");
INSERT INTO syll_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Oile dushmonor desho taḳar ḳalo ami tarare ola kunu ginna ba elamir souke deḳtam nae, tarare ekkere binash oite ditam nae, zate tarar loge ḳora amar oada-chukti bongo na oy. Mono rakio, ami Alla-u tarar Mabud. ");
INSERT INTO syll_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Tarar lagi ami tarar moy-murobbir logor oada-chuktire iad ḳormu. Ou moy-murobbi oḳlor Mabud oar niote hoḳol zatir samon dia ami tarare Mishor desh taki bar ḳoria anchi. Ami-u to Mabud.” ");
INSERT INTO syll_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ita oilo hou shoriot, hukum-ahkam, ar niom-ḳanun, zeta Tur faṛor ufre Mabude Musa nobir marfote Boni Israilor lagi boail ḳorsoin. ");
INSERT INTO syll_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Bade Mabude Musa nobire ḳoila, ");
INSERT INTO syll_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Tumi tamam Boni Israilre zanai deo, ḳeu zudi kunu manshore Allar name deoar mannot ḳore, te ou zonor bodla olaḳan hadia dite oibo: ");
INSERT INTO syll_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Bish taki shaiṭ bosor boyoshi beṭaintor lagi, ebadot ḳanar mafe foinchash tola rufa hadia dite oibo, ");
INSERT INTO syll_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ou boyoshi beṭintor lagi tish tola. ");
INSERT INTO syll_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Fas bosor taki bish bosor boyoshi fuaintor lagi bish tola rufa, ou boyoshi fuṛintor lagi dosh tola. ");
INSERT INTO syll_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Eḳ mash taki fas bosor boyoshi fuaintor lagi fas tola rufa, ou boyoshi fuṛintor lagi tin tola rufa. ");
INSERT INTO syll_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Shaiṭ bosor ba er beshi boyoshi beṭaintor lagi fonro tola, ou boyoshi beṭintor lagi dosh tola rufa dite oibo. ");
INSERT INTO syll_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“Oile ou mannot ḳorra zon zudi gorib manush oy, tar mannotor hadia dibar takkot na taḳe, te tare loia imam sabor gese zaibae, gele imam sabe tar halot buzia hadia ṭik korba. ");
INSERT INTO syll_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“Zudi kobul oar zuka kunu foshure Mabudor name mannot ḳora oy, te ou foshure Mabudor samana hishabe fobitro ḳoia goinno ḳorio. ");
INSERT INTO syll_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Ou foshur bodla dusra kunu foshu dile kobul oito nae. Iṭa bala oile er bodla bad foshu, ba bad oile er bodla bala kunu foshu dile-o kobul oito nae. He zudi eḳṭar bodla aroḳṭa foshure dilae, te ou duioṭare fobitro hishabe goinno ḳorio. ");
INSERT INTO syll_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Oile Mabudor name kobul oar zuka nae, ila kunu nafak zator foshure ḳeu zudi mannot hishabe manilae, te oḳṭare loia imam sabor gese zaio, ");
INSERT INTO syll_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","gele tain oḳṭar hal-hokikot buzia hari ze dam ṭik korba, ou dam-u oibo iṭar shoṭik dam. ");
INSERT INTO syll_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Mannot ḳorrae iṭare ḳalas ḳorar kial oile, ou damor loge aro fas baṭor eḳ baṭ dam beshi dite oibo. ");
INSERT INTO syll_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“Ḳeu zudi tar kunu baṛi-gorre Mabudor name fak-fobitro samana hishabe mannot ḳorilae, te imam sabe ou baṛir hal-hokikot buzia ze dam ṭik korba, iṭa-u oibo er shoṭik dam. ");
INSERT INTO syll_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Oḳon ou baṛire he ḳalas ḳoria nito saile, ou damor loge aro fas baṭor eḳ baṭ beshi dite oibo. Teu baṛi kan tar oibo. ");
INSERT INTO syll_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“Kunu manshe zudi tar nizor zomi-mirashor kunu eḳ ongshore Mabudor name mannot ḳoria fak-fobitro ḳoia alog korilae, te ou zomino ze forimane ḳet oy, ou fosholor foriman buzia er dam ṭik korte oibo. Forteḳ fas mon barli bisor dam hishabe ada sher rufa dorbae. ");
INSERT INTO syll_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Ar zomi-mirash Firot Faoar Bosor zudi he tar zominre fak-fobitro ḳoia mannot ḳore, te ou niom mafik imam sabe ze dam ṭik korba, iṭa-u oibo er shoṭik dam. ");
INSERT INTO syll_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Oile Firot Faoar Bosoror bade zudi he tar mannot ḳore, te bador Firot Faoar Bosor forzonto hishab ḳoria zoto bosor oy, oto bosoror fosholor hishabe imam sabe er dam ṭik korba, bosor hishabe zominor dam ḳombo. ");
INSERT INTO syll_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Ar mannot ḳorra zone zudi tar zominre ḳalas ḳoria nito sae, te ṭik kora ou damor loge aro fas baṭor eḳ baṭ beshi dite oibo, teu zomi kan tar oibo. ");
INSERT INTO syll_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Oile he zudi kalas ḳori na ney, ba dusra zonor gese besilae, te ou zomin ḳan ar ḳalas ḳoria nibar fot nai. ");
INSERT INTO syll_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Zomi-mirash Firot Faibar Bosor zebla zomi kan emne-u ḳalas oizibo, ou shomoy i zomi kan Mabudor name siroḳalin saf-kobala zominor laḳan fak-fobitro samana hishabe goinno oibo. Ikan oizibo imam sabor zomi. ");
INSERT INTO syll_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Nizor bafaiti zomi nae ila kunu ḳorida zominre ḳeu zudi mannot mania fak-fobitro hishabe goinno ḳorae, ");
INSERT INTO syll_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","te imam sabe Firot Faoar Bosor forzonto hishab ḳoria ikanor dam ṭik korba, ar hou din-u ou zominor damre he Mabudor name fak-fobitro samana hishabe dilaite oibo. ");
INSERT INTO syll_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Ar zomi kan he zar ges taki loisil, zomi-mirash Firot Faibar Bosor ikan hirbar hou mul malikor ato zaibo. ");
INSERT INTO syll_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Hoḳol zinishor dam ṭik korio, ebadot ḳanar mafe. Forteḳ bish rotie eḳ tola gonio. ");
INSERT INTO syll_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“Kunu foshur foyla meda baichchare ḳeu Mabudor name lilla dibar lagi mannot ḳorto farto nae, iṭa to emne-u Mabudor. Ita goru-sagol, meṛa zetar baichcha-u ouk, iṭa Mabudor. ");
INSERT INTO syll_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Zudi iṭa kunu haram foshur foyla meda baichcha oy, te imam sabor ṭik kora damor loge aro fas baṭor eḳ baṭ beshi dia iṭare ḳalas ḳori nito farbo. Ar he zudi kalas ḳori na ney, te ou dame iṭare besilite oibo. ");
INSERT INTO syll_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“Oile kunu manshe zudi tar nizor kunu samana Mabudor name siroḳalin saf-kobala dolilor laḳan mannot ḳorilae, te ou mannot ḳora samana ar ḳalas ḳoria firot nito farto nae, ba besto-o farto nae. Ita zomi-zoma ouk, ba kunu manush, ba foshu oile-o, ita siroḳalor lagi Mabudor name ḳas fobitro samana hishabe goinno oibo. ");
INSERT INTO syll_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Kunu manshore Mabudor name siroḳalor lagi ola mannot ḳoria dilaile, tare ar ḳalas ḳori neoa zaito nae, tare zane marilite oibo. ");
INSERT INTO syll_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“Zomino taki zeta fol-foshol mile, itar dosh baṭor eḳ baṭ to Mabudor. Ita ḳetor foshol ouk ba gasor fol ouk, hoḳolta-u Mabudor name fak-fobitro. ");
INSERT INTO syll_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Ḳeu zudi tar ou dosh baṭor eḳ baṭ ḳalas ḳoria nito sae, te er loge aro fas baṭor eḳ baṭ beshi dite oibo. ");
INSERT INTO syll_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Forteḳ foshur falor dosh baṭor eḳ baṭ Mabudor, mani fale foshu gonar shomoy forteḳ dosh nombor foshu ogu Mabudor name fak-fobitro. ");
INSERT INTO syll_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Ou dosh nombor foshu oguin bad ba bala ita deḳar kunu zorur nae, ba iṭa bodlaia dibar shuzug nai. Ḳeu zudi iṭar bodla dey, te ou dosh nombor foshu ar bodla foshu duioṭa-u Mabudor name fak-fobitro oizibo, ita ar ḳalas ḳori neoa zaito nae.” ");
INSERT INTO syll_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Mabude Tur faṛor ufre Musa nobir gese, Boni Israilor lagi ou hukum-ahkam oḳol dan ḳorsila.");
INSERT INTO syll_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Boni Israil zati Mishor desh taki bar oia aoar dui nombor bosoror shomoy, dui nombor sandor foyla din, Mabude Sinai morubumit Milon-tambur bitre Hozrot Musar loge batchit ḳorla. Tain Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Oḳon tamam Boni Israilor gusṭi ar foribar mafik eḳ ek kori hoḳol beṭaintor nam leḳo. ");
INSERT INTO syll_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Tumi ar tumar bai Harune bish bosor ba er beshi boyoshi, mani zuddot zaoar zuka fouzi dol mafik tarare gono. ");
INSERT INTO syll_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Fortek kandanor eḳzone tumrare shaijjo ḳorba, era oiba nizor gusṭir fordan murobbi. ");
INSERT INTO syll_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Zara shaijjo ḳorba, erar nam oilo, Ruben ḳandanor Shadiuror fua Alisur, ");
INSERT INTO syll_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Shimion ḳandanor Shuroshadayor fua Shalumil, ");
INSERT INTO syll_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Ehuda ḳandanor Aminadabor fua Nahish, ");
INSERT INTO syll_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Isaḳor ḳandanor Sugaror fua Notonel, ");
INSERT INTO syll_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Sobulon ḳandanor Helonor fua Iliab, ");
INSERT INTO syll_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Iusufor fuaintor maz taki: Afraim ḳandanor Amihudor fua Alishama, Manosha ḳandanor Fatoshuror fua Gomoliel, ");
INSERT INTO syll_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Bin-Iamin ḳandanor Zidaunir fua Abidan, ");
INSERT INTO syll_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Dan ḳandanor Amishadar fua Akiazar, ");
INSERT INTO syll_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Ashir ḳandanor Ukranor fua Foziel, ");
INSERT INTO syll_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Sadu ḳandanor Duelor fua Iliasof, ");
INSERT INTO syll_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Noftali kandanor Inanor fua Ahir.” ");
INSERT INTO syll_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Boni Israilor maz taki ou baro zonre fosond ḳori neoa oilo. Era oila tarar baf-dadaintor foribaror fordan, Boni Israilor fouzi dolor shordar. ");
INSERT INTO syll_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Mabude zerar nam ḳoisla, Musa ar Harune ou shordar oḳolre ḳobordi anaila, ");
INSERT INTO syll_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ar ou bosoror dusra sandor foyla din hoḳol Boni Israilre ekḳano dola ḳorla. Tara zarzir gusṭi ar foribar mafik tarar nam leḳailo. Bish bosor ba er beshi boyoshor beṭaintor nam eḳ ek kori leḳa oilo. ");
INSERT INTO syll_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Mabudor hukum mafik Sinai morubumit Musae erare gonila. ");
INSERT INTO syll_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Iakub urfe Israilor boṛo fuar nam Ruben, ou ḳandan taki zerar boyosh bish bosor ba er beshi, mani zara zuddot zaoar zuka asil, gusṭi ar foribaror forisoy mafik erar nam eḳ ek kori leḳa oilo. ");
INSERT INTO syll_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Ruben ḳandan taki faoa gelo soysallish azar fas-sho zon. ");
INSERT INTO syll_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Shimion ḳandanor maze zerar boyosh bish bosor ba er beshi, mani zara zuddot zaoar zuka asil, gusṭi ar foribaror forisoy mafik erar nam eḳ ek kori leḳa oilo. ");
INSERT INTO syll_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Shimion ḳandan taki faoa gelo onushaiṭ azar tin-sho zon. ");
INSERT INTO syll_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Sadu ḳandanor maze zerar boyosh bish bosor ba er beshi, mani zara zuddot zaoar zuka asil, gusṭi ar foribaror forisoy mafik erar nam eḳ ek kori leḳa oilo. ");
INSERT INTO syll_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Sadu ḳandan taki faoa gelo foytallish azar soy-sho foinchash zon. ");
INSERT INTO syll_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Ehuda ḳandanor maze zerar boyosh bish bosor ba er beshi, mani zara zuddot zaoar zuka asil, gusṭi ar foribaror forisoy mafik erar nam eḳ ek kori leḳa oilo. ");
INSERT INTO syll_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Ehuda ḳandan taki faoa gelo suattoir azar soy-sho zon. ");
INSERT INTO syll_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Isaḳor ḳandanor maze zerar boyosh bish bosor ba er beshi, mani zara zuddot zaoar zuka asil, gusṭi ar foribaror forisoy mafik erar nam eḳ ek kori leḳa oilo. ");
INSERT INTO syll_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Isaḳor ḳandan taki faoa gelo suanno azar sair-sho zon. ");
INSERT INTO syll_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Sobulon ḳandanor maze zerar boyosh bish bosor ba er beshi, mani zara zuddot zaoar zuka asil, gusṭi ar foribaror forisoy mafik erar nam eḳ ek kori leḳa oilo. ");
INSERT INTO syll_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Sobulon ḳandan taki faoa gelo shatanno azar sair-sho zon. ");
INSERT INTO syll_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Iusufor fua Afraim ḳandanor maze zerar boyosh bish bosor ba er beshi, mani zara zuddot zaoar zuka asil, gusṭi ar foribaror forisoy mafik erar nam eḳ ek kori leḳa oilo. ");
INSERT INTO syll_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Afraim ḳandan taki faoa gelo sallish azar fas-sho zon. ");
INSERT INTO syll_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Ar tan bai Manosha ḳandanor maze zerar boyosh bish bosor ba er beshi, mani zara zuddot zaoar zuka asil, gusṭi ar foribaror forisoy mafik erar nam eḳ ek kori leḳa oilo. ");
INSERT INTO syll_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Manosha ḳandan taki faoa gelo bottish azar dui-sho zon. ");
INSERT INTO syll_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Bin-Iamin ḳandanor maze zerar boyosh bish bosor ba er beshi, mani zara zuddot zaoar zuka asil, gusṭi ar foribaror forisoy mafik erar nam eḳ ek kori leḳa oilo. ");
INSERT INTO syll_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Bin-Iamin ḳandan taki faoa gelo faytish azar sair-sho zon. ");
INSERT INTO syll_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Dan ḳandanor maze zerar boyosh bish bosor ba er beshi, mani zara zuddot zaoar zuka asil, gusṭi ar foribaror forisoy mafik erar nam eḳ ek kori leḳa oilo. ");
INSERT INTO syll_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Dan ḳandan taki faoa gelo bashoṭṭi azar shat-sho zon. ");
INSERT INTO syll_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Ashir ḳandanor maze zerar boyosh bish bosor ba er beshi, mani zara zuddot zaoar zuka asil, gusṭi ar foribaror forisoy mafik erar nam eḳ ek kori leḳa oilo. ");
INSERT INTO syll_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Ashir ḳandan taki faoa gelo ekchallish azar fas-sho zon. ");
INSERT INTO syll_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Noftali kandanor maze zerar boyosh bish bosor ba er beshi, mani zara zuddot zaoar zuka asil, gusṭi ar foribaror forisoy mafik erar nam eḳ ek kori leḳa oilo. ");
INSERT INTO syll_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Noftali kandan taki faoa gelo teppanno azar sair-sho zon. ");
INSERT INTO syll_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Hozrot Musa, Harun ar Boni Israilor baro zon murobbi netae ou manshore gonila. Ou baro zon neta asla baro ḳandanor shordar. ");
INSERT INTO syll_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Asta Boni Israilor maze zerar boyosh bish bosor ba tar beshi, mani zuddot zaoar zuka boyosh, zarzir gusṭi mafik tarare gona oilo. ");
INSERT INTO syll_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Gonia hokkoltae soy laḳ tin azar fas-sho foinchash zon faoa gelo. ");
INSERT INTO syll_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Oile Lebi kandanre, mani imam bongshore erar loge gona oilo na. ");
INSERT INTO syll_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Mabude age-u Musare ḳoisla, ");
INSERT INTO syll_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Tumi Lebi kandanre gonbae na, gonar shomoy Boni Israilor oinno manshor loge erare hishab ḳorio na. ");
INSERT INTO syll_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Tumi tarare shahadot tambu, mani amar goror shaz-shoronjam ar hokkoltar deḳa-hunar bar dibae. Tarar ḳam oibo, amar gor ar er hoḳol shaz-shoronjam boia neoa. Tara er sairo galabae zarzir tambu ṭangaia roiba ar amar goror deḳa-huna ḳorba. ");
INSERT INTO syll_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Amar gorre eḳ zaga taki aroḳ zagat nite oile, Lebi kandanor manshe ikan kulba, bade aroḳ zagat gia eḳ ek kori zuṛa lagaia hirbar banaiba. Ḳali Lebi kandan saṛa oinno ḳeu itar ḳandat gele tare zane mara oibo. ");
INSERT INTO syll_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Bad-baki Boni Israile tarar fouzi dol mafik zarzir tambu ṭangaiba. Forteḳe zarzir dolor shimanar maze, dolor nishana lagail fotaḳar tole roite oibo. ");
INSERT INTO syll_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Boni Israilor ufre zate Mabudor gozob na lame, erlagi Lebi kandanor manshe amar shahadot tambur faradari korar lagi amar goror sairo galabae tarar tambu ṭangaia roiba.” ");
INSERT INTO syll_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Mabude Musa nobire zela hukum disla, Boni Israile ṭik ola-u ḳorla. ");
INSERT INTO syll_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Bade Mabude Musa ar Harunre ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Milon-tambur sairo galabae tuṛa ḳali zaga toia Boni Israile tarar tambu ṭanaiba. Forteḳe zarzir fouzi dolor shimanat zarzir gusṭir fotaḳar daro roiba. ");
INSERT INTO syll_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","“Milon-tambur fubedi, shuruz uṭar muka, Ehudar fotaḳar tino ḳandanor fouzi dole tarar tambu ṭanaiba. Ehuda ḳandanor shordar oila Aminadabor fua Nahish, ");
INSERT INTO syll_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","ou ḳandano sifair zuka manush oila, suattoir azar soy-sho zon. ");
INSERT INTO syll_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Erar ek galat Isaḳor ḳandan roiba, ou ḳandanor shordar oila Sugaror fua Notonel, ");
INSERT INTO syll_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","tar ḳandano sifair zuka manush oila, suanno azar sair-sho zon. ");
INSERT INTO syll_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Dusra galat tambu gaṛiba Sobulon ḳandane, ou ḳandanor shordar oila Helonor fua Iliab, ");
INSERT INTO syll_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","tar ḳandano sifair zuka manush oila, shatanno azar sair-sho zon. ");
INSERT INTO syll_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Ehudar fotaḳar ou tino ḳandanor gona sifair zuka muṭ manush oila, eḳ laḳ siashi azar sair-sho. Soforor shomoy tarar ḳafela hoḳlor age roana diba. ");
INSERT INTO syll_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“Milon-tambur dokkin galat tambu gaṛiba, Rubenor fotaḳar tino ḳandanor fouzi dole. Ruben ḳandanor shordar oila Shadiuror fua Alisur, ");
INSERT INTO syll_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","tar ḳandano sifair zuka manush oila, soysallish azar fas-sho zon. ");
INSERT INTO syll_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Erar ek galat Shimion ḳandan roiba, ou ḳandanor Shuroshadayor fua Shalumil oila tarar shordar, ");
INSERT INTO syll_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","tar ḳandano sifair zuka manush oila, onushaiṭ azar tin-sho zon. ");
INSERT INTO syll_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Dusra galat tambu gaṛiba Sadu ḳandane, ou ḳandanor shordar oila Duelor fua Iliasof, ");
INSERT INTO syll_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","tar ḳandano sifair zuka manush oila, fachchallish azar soy-sho foinchash zon. ");
INSERT INTO syll_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Rubenor fotaḳar ou tino ḳandano gona sifair zuka muṭ manush oila, eḳ laḳ eḳanno azar sair-sho foinchash zon. Soforor shomoy tara dusra ḳafelat roana diba. ");
INSERT INTO syll_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“Bade Lebi kandanor manshe Milon-tambure loia roana diba, hoḳlor mazḳano era roiba. Zarzir tambu ṭananir sirial mafik lain doria roana oiba. Fouzi dolor zarzir fotaḳar manush nizor dolor loge roiba. ");
INSERT INTO syll_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“Milon-tambur foismor galat tambu gaṛiba, Afraim fotaḳar tino fouzi dolor manshe. Afraim ḳandanor shordar oila Amihudor fua Alishama, ");
INSERT INTO syll_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ou ḳandano sifair zuka manush oila, sallish azar fas-sho zon. ");
INSERT INTO syll_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Erar ek galat Manosha ḳandane tambu gaṛiba, Fatoshuror fua Gomoliel oila tarar shordar, ");
INSERT INTO syll_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","ou ḳandano sifair zuka manush oila, bottish azar dui-sho zon. ");
INSERT INTO syll_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Ar dusra galat roiba Bin-Iamin ḳandan, erar shordar oila Zidaunir fua Abidan, ");
INSERT INTO syll_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","tar ḳandano sifair zuka manush oila, faytish azar sair-sho zon. ");
INSERT INTO syll_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Afraimor fotaḳar ou tino ḳandanor gona sifair zuka muṭ manush oila, eḳ laḳ aṭ azar eḳ-sho zon. Tara tin nombor ḳafelat roana diba. ");
INSERT INTO syll_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“Milon-tambur uttor galat tambu gaṛiba Dan fotaḳar tino ḳandanor fouzi dolor manshe, tarar shordar oila Amishadar fua Akiazar, ");
INSERT INTO syll_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","ou ḳandano sifair zuka manush oila, bashoṭṭi azar shat-sho zon. ");
INSERT INTO syll_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Erar ek galat Ashir ḳandane tambu gaṛiba, ou ḳandanor shordar oila, Ukranor fua Foziel. ");
INSERT INTO syll_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Tar ḳandano sifair zuka manush oila, ekchallish azar fas-sho zon. ");
INSERT INTO syll_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Ar dusra galat roiba Noftali kandan, ou ḳandanor shordar oila, Inanor fua Ahir. ");
INSERT INTO syll_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Tar ḳandano sifair zuka manush oila, teppanno azar sair-sho zon. ");
INSERT INTO syll_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Danor fotaḳar ou tino ḳandanor gona sifair zuka muṭ manush oila, eḳ laḳ shatanno azar soy-sho zon. Era hoḳol heshor ḳafelat roana diba.” ");
INSERT INTO syll_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Ou nomunae hoḳol Boni Israilre zarzir gusṭi mafik gona oilo. Gonia harle hoḳol fouzi dole sifair zuka muṭ manush oila, soy laḳ tin azar fas-sho foinchash zon. ");
INSERT INTO syll_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ta-o Mabude Musa nobire zela hukum disla, hukum mafik Boni Israilre gonar shomoy Lebi kandanre gonat dora oilo na. ");
INSERT INTO syll_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Mabude Musare zela hukum disla, Boni Israile hoḳol ḳam-ḳaz ḳorta ou hukum mafik. Tara zarzir dolor zagat tambu ṭanaita, ar soforo roana oita nizor gusṭi ar foribar mafik afon fouzi dolor fotaḳar daro roia. ");
INSERT INTO syll_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Tur faṛor ufre Mabude zebla Musa nobir loge batchit ḳorsla, hou shomoy Harun ar tan bai Musar bongsho-buniad asla ou eintain: ");
INSERT INTO syll_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Harunor fuain oila Nadab, Abihu, Ali-Azor ar Isamar. Erar maze Nadab asla boṛo. ");
INSERT INTO syll_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Imamoti kamor lagi Harunor ou sairo fuainre ḳelafoti dia ebadoti kamo boail ḳora oisil. ");
INSERT INTO syll_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Oile Sinai morubumit roar ḳalo, Nadab ar Abihue Mabudor batail niom bangia, dusra aguindi agor-kushboy zalanir shomoy Mabudor samne-u tarar moron oigelo. Tarar kunu aolad na taḳae, tarar baf Harun nobir loge roia Ali-Azor ar Isamare imamoti kam ḳorla. ");
INSERT INTO syll_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Bade Mabude Musa nobire ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Tumi Lebi kandanor manshore ania imam Harunor ato shomzao, tara imamoti kamo tanre shaijjo ḳorba. ");
INSERT INTO syll_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Tara imam Harunor zimmae Milon-tambur samne hoḳol Boni Israilor torof taki amar goror ḳadimdari korba. ");
INSERT INTO syll_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Tara-u Milon-tambur mal-samana deḳa-huna ar Allar goror kezmot ḳoria Boni Israilor fokke ebadot-bondegir day-dayitto adae ḳorba. ");
INSERT INTO syll_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Lebi kandanor ḳadim oḳolre tumi Harun ar tar fuaintor ato shomzai deo. Boni Israilor maz taki erare imam Harunor ato shofi deoa oilo. ");
INSERT INTO syll_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Imamoti kamor lagi tumi Harun ar tar bongshore basia neo. Tara saṛa dusra ḳeu imamoti korat gele ogure zane mara oibo.” ");
INSERT INTO syll_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Mabude Musare eoḳan ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Huno, Boni Israili beṭintor goro zonom loa foyla fuar bodla babot, ami Lebi kandanre fosond ḳorsi. Erlagi Lebi oḳol amar. ");
INSERT INTO syll_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Ashole hokkol foyla fuain-u amar. Mishori oḳlor hoḳol foyla fuaintore marilibar din, Boni Israilor forteḳ foyla fuare amar lagi fobitro ḳoria raḳsi, ita manshor fut ouk ba foshur baichcha ouk. Tara to amar, ami-u Mabud.” ");
INSERT INTO syll_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Sinai morubumir maze Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Tumi gusṭi ar foribar mafik Lebi oḳolre gono. Eḳ mash ba er beshi boyoshor hoḳol beṭaintore gono.” ");
INSERT INTO syll_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Mabudor hukum mafik tain Lebi kandanre gonila. ");
INSERT INTO syll_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Gonar ḳalo faila, Lebir fuain Zarsun, Kahat ar Marari. ");
INSERT INTO syll_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Zarsunor fuain Libni ar Shimei asla dui gusṭir murobbi neta. ");
INSERT INTO syll_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kahator fuain Imran, Izhar, Hebron ar Ujjol oila sair bai. ");
INSERT INTO syll_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Mararir fuain Moholi ar Mushi oila dui bai. Era oila bongsho ar foribar hishabe Lebi kandanor nanan gusṭi. ");
INSERT INTO syll_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Zarsun asla Libnia ar Shimeia gusṭir mul murobbi. ");
INSERT INTO syll_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Erar maze eḳ mash ar eḳ mashor beshi boyoshor hoḳol fuaintore gonia shaṛe shat azar faoa gelo. ");
INSERT INTO syll_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Fochchim galabae Allar goror ḳoredi Zarsuni oḳlor tambu ṭangani oito. ");
INSERT INTO syll_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Zarsun gusṭir fordan asla Layelor fua Iliasof. ");
INSERT INTO syll_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Milon-tambur befare Zarsuni oḳlor ufre, zeta ḳafoṛain dia Allar gor banani oise ḳali ota ḳafoṛ oḳol, bara bazur gilaf ar sani oḳol ar ou goror bitre hamaibar forda deḳa-huna ḳorar dayitto asil. ");
INSERT INTO syll_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","Ar Allar gor ar kurbani kanar sairobae ze uṭan ase ogur fordain, ar uṭano hamanir lagi ze geiṭ ase ou geiṭor forda, ar shob rosi oḳlor-u deḳa-huna ḳora, ar ota hoḳol ḳam-ḳaz ḳora, ou hokkolta-u tantanor dayitto asil. ");
INSERT INTO syll_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Kahat asla Imran, Izhar, Hebron ar Ujjol, ou sair gusṭir mul murobbi. ");
INSERT INTO syll_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Ou gusṭintor maze eḳ mash ba tar beshi boyoshor hoḳol fuaintore gonia aṭ azar soy-sho zon faoa gelo. Erar dayitto asil fobitro ebadot ḳanar deḳa-huna ḳora. ");
INSERT INTO syll_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Allar goror dokkin galabae Kahati oḳlor tambu ṭangani oito. ");
INSERT INTO syll_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Kahati gusṭir fordan asla Ujjolor fua Ilizafon. ");
INSERT INTO syll_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Ou Kahati gusṭir dayitto asil shahadot shonduk, ṭebul, serag dani, kurbani kana, agor-kushboy zalanir ṭebul, fobitro ebadot ḳanar ebadotir hoḳol zinish ar Herem Shorifor fordar deḳa-huna ḳora, loge bad-baki kam ḳora. ");
INSERT INTO syll_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Lebi kandanor nanan gusṭir murobbi oḳlor fordan asla imam Harunor fua Ali-Azor. Erloge fobitro ebadot ḳanar deḳa-hunar dayitto zerare deoa oisil, erare nozordari korar lagi tanre boail ḳora oisil. ");
INSERT INTO syll_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Marari asla Moholi ar Mushir ou dui gusṭir mul murobbi. ");
INSERT INTO syll_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Ou gusṭintor maze eḳ mash ba tar beshi boyoshor hoḳol fuaintore gonia soy azar dui-sho faoa gelo. ");
INSERT INTO syll_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Mararia gusṭir fordan asla Abielor fua Suriel. Allar goror utoredi tarar tambu ṭangani oito. ");
INSERT INTO syll_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Erar dayitto asil Allar goror freim, freimor batti, kuṭi, sungi ar er hoḳol chiz, ");
INSERT INTO syll_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","uṭanor beṛar sairo galar kuṭi, sungi, beṛa ṭananir rosi ar feregor deḳa-huna ar er logor hoḳol ḳam-ḳaz ḳora. ");
INSERT INTO syll_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Milon-tambur samnedi mani Allar goror fubedi Hozrot Musa, Harun ar tan fuaintor tambu oḳol ṭangani oito. Erar dayitto asil Boni Israilor torof taki fobitro ebadot ḳanat hoḳol ebadoti kam adae ḳora. Era saṛa ar ḳeu ebadot ḳanar ḳandat gele tare marilaoa oito. ");
INSERT INTO syll_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Mabudor hukum mafik Musa ar Harune, Lebi kandanor eḳ mash ba tar beshi boyoshor hoḳol fuaintore gusṭi mafik gonila, gonia baish azar zon faoa gelo. ");
INSERT INTO syll_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Erbade Mabude Musare ḳoila, “Boni Israilor hoḳol foribaror foyla fuainre gono, zerar boyosh eḳ mash ba er beshi, erare gonia erar nam ek katat leḳo. ");
INSERT INTO syll_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Boni Israilor hoḳol foyla fuaintor zanor bodla Lebi oḳolre amar ḳoia gona oibo. Ar tarar foshur foyla baichchar bodla Lebi oḳlor foshur foyla baichchare amar ḳoia gona oibo. Ami-u Mabud.” ");
INSERT INTO syll_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Mabudor hukum mafik Musae Boni Israilor hoḳol foribaror foyla fuainre gonila. ");
INSERT INTO syll_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Teu eḳ mash ba tar beshi boyoshi fuaintore gonia muṭ baish azar dui-sho teyaṭṭoir zon faoa gelo. ");
INSERT INTO syll_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Mabude Musare aro ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Boni Israilor hoḳol foyla fuaintor bodla Lebi oḳolre, ar tarar foyla foshur baichchar bodla Lebi oḳlor foyla foshur baichchare amar ḳoia dora oibo. Lebi oḳol to amar oiba. Ami-u Mabud. ");
INSERT INTO syll_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Lebi kandanor muṭ foriman taki Boni Israilor foyla fuaintor foriman dui-sho teyaṭṭoir zon beshi. ");
INSERT INTO syll_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Ou dui-sho teyaṭṭoir zonre ḳalas ḳorar lagi zanor bodla hishabe, forteḳ zonor lagi ebadot ḳanar mafe fas tola rufa adae ḳorio. ");
INSERT INTO syll_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Adae ḳora ou rufa nia tumi imam Harun ar tar fuaintore dilaio.” ");
INSERT INTO syll_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Teu Lebi kandanor bodla Boni Israilre ḳalas ḳoria nibar bade, tarar zoto zon baki roila, erar zanor bodla hishabe Musa nobie rufa adae ḳorla. ");
INSERT INTO syll_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Tain Boni Israilor foyla fuaintor ges taki ebadot ḳanar mafe eḳ azar tin-sho foyshoṭṭi tola rufa adae ḳorla. ");
INSERT INTO syll_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Mabudor hukum mafik Musae ou rufa Harun ar tan fuaintore dilaila. ");
INSERT INTO syll_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Mabude Musa ar Harun nobire ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Tumra Lebi kandanor mazor Kahati oḳol alada ḳori gono, tarar hoḳol foribar ar gusṭi mafik gono. ");
INSERT INTO syll_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Tish taki foinchash bosor boyoshor zeta beṭainte Milon-tambur ḳam-ḳaz ḳorat aiba, ḳali tarare gonio. ");
INSERT INTO syll_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Kahati oḳlor ḳam oibo, Milon-tambur ḳas fobitro siz oḳlor deḳa-huna ḳora. ");
INSERT INTO syll_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Boni Israil soforo baronir shomoy, Harun ar tar fuainte amar goror bitre hamaia, Herem Shorifor forda kulia hari, oḳandi shahadot shondukre guria diba. ");
INSERT INTO syll_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Er ufre doriar fuʼ masor samṛar gilafdi guriba, bade furafur lilua rongor ekkan ḳafoṛdi guria dia, shonduk boia nibar benda guin zaga moto haraiba. ");
INSERT INTO syll_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Fobitro ruṭi raḳar ṭebulor ufre tara lilua rongor ekkan ḳafoṛ bisaia, oḳanor ufre huru-boṛo hoḳol tal-bashon, ar shorbot-fanir sodga ḍalibar zog-mog toiba. Fobitro zeta ruṭi hamesha ṭebulor ufre toa taḳe, ita ṭebulor ufre-u roibo. ");
INSERT INTO syll_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Otar ufre lal ekkan ḳafoṛ bisaia, fuʼr samṛadi oḳanre guriba, ar ṭebul boia nibar benda guin zaga moto harai diba. ");
INSERT INTO syll_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Bade lilua ekkan ḳafoṛdi asta serag dani, er serag oḳol, seragor fita saf ḳorar simṭa, zalail fitar sali toar baṭi ar telor fifare guria diba. ");
INSERT INTO syll_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Hoḳol mal-samana shomet serag danire fuʼr samṛadi beraia, boia nibar ḳaṭiar ufre toiba. ");
INSERT INTO syll_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Ar agor-kushboy zalanir shunar ṭebulor ufre lilua ekkan ḳafoṛ bisaia, fuʼr samṛadi guria diba, bade ou ṭebul boia neoar benda guin zaga moto haraiba. ");
INSERT INTO syll_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Ebadot ḳanar kezmotor hoḳol mal-samana tara lilua ḳafoṛdi fesaia, fuʼr samṛadi guria hari, ota boia nibar ḳaṭiar ufre toiba. ");
INSERT INTO syll_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Kurbani kanar bitoror hoḳol sali falaia, baingoni rongor ekkan gilafdi guria diba. ");
INSERT INTO syll_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Bade kurbani kanar hoḳol mal-samana oḳol, ortat angra toar fatil, gust tular boṛo ḳaṭa-sif, sali tular boṛo samos, lou toar baṭi, ita hoḳolta kurbani kanar ufre toiba. Toia fuʼr samṛadi guria dia, er benda guin ṭik zagat haraiba. ");
INSERT INTO syll_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Harun ar tar fuainte zebla ou fak-fobitro zinish oḳol ar ebadot ḳanar mal-samana hoḳolta guriliba, tara tambu tulia soforo baronir lagi zebla tiar oiziba, ou shomoy ota boia nibar lagi Kahati oḳol aiba. Oile tara kunu fak-fobitro sizre atdi soita farta nae, soile-u morba. Milon-tambur ou hokkol zinish tara boia niba. ");
INSERT INTO syll_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Ar imam Harunor fua Ali-Azoror ufre serag danir tel, zalanir lagi agor-kushboy, fortidinor dan-gomor sodga ar ḳelafoti shomzibar telor dayitto roibo. Allar gor, goror hoḳol mal-samana, mani ebadot ḳana ar tar hoḳol mal-samanar todarki roibo Ali-Azoror ufre.” ");
INSERT INTO syll_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Erbade Mabude Hozrot Musa ar Harunre ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Tumra kial rakio, Lebi kandanor maze Kahati bongsho taki keu ḳeu zate hor-hamesha taḳoin. ");
INSERT INTO syll_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Tara zanu ḳas fobitro siz oḳlor ḳasat gia na more borong basia roy, otar lagi Harun ar tar fuainte amar goror bitre gia zarzir ḳam-ḳaz buzai diba. Ar ḳe kita boia nita, ota-o ṭik kori diba. ");
INSERT INTO syll_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Oile Herem Shorifor bitoror ou fak-fobitro zinish eḳ foloḳor lagi-o deḳar niote Kahati oḳol bitre kunu laḳan-u hamaita farta nae, ou niote hamaile-u mori zaiba.” ");
INSERT INTO syll_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Tumi gusṭi ar foribar mafik Zarsuni oḳolre gono. ");
INSERT INTO syll_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Tish taki foinchash bosor boyoshor zeta Zarsuni beṭainte Milon-tambur ḳam ḳorta farba, ḳali tarare gonio. ");
INSERT INTO syll_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Milon-tambur kezmot ḳora ar bar boar shomoy Zarsuni oḳlor ḳam oilo, ");
INSERT INTO syll_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","amar goror hoḳol fordain, Milon-tambu ar er gilaf, tar ufror fuʼr samṛar sani, ar Milon-tambur duaror forda boia neoa. ");
INSERT INTO syll_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Erloge Allar gor ar kurbani kanar uṭanor sairo galar forda ar er doṛi oḳol, uṭano hamanir geiṭor forda, otar logor dorḳari hoḳol mal tara boia niba, ar ou befare zoto ḳam-ḳaz ase, ita tara ḳorba. ");
INSERT INTO syll_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Bar boibar ḳam ouk ba oinno kunu ḳam ouk, hoḳolta Harun ar tar fuaintor hukum mafik Zarsuni oḳole ḳorba. Tara kita kita boia nito, ita tumra-u tarare ḳoia dibae. ");
INSERT INTO syll_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Ota-u oilo Milon-tambur ḳamo Zarsuni oḳlor day-dayitto. Tarar ḳam-ḳazor todarki korba imam Harunor fua Isamare. ");
INSERT INTO syll_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Tumra gusṭi ar foribar mafik Mararia oḳlor foriman gono. ");
INSERT INTO syll_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Tish taki foinchash bosor boyoshor zeta Mararia beṭainte Milon-tambur ḳam ḳorta farba, tumra ḳali tarare gonio. ");
INSERT INTO syll_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Milon-tambur maze Mararia oḳlor dayitto oilo, Allar goror hoḳol freim, freimor batti, kuṭi ar kuṭir tolor sungi boia neoa. ");
INSERT INTO syll_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Erloge sairo galar uṭanor hoḳol kuṭi ar sungi, uṭanor forda ṭananir fereg ar doṛi ar otar logor mal-samana zeta dorḳari ita hoḳolta tara boia niba. Tara ḳe kita boia nito, ita tumra ḳoia dio. ");
INSERT INTO syll_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Ota-u oilo Milon-tambur maze Mararia gusṭir day-dayitto. Tarar ḳam-ḳazor todarki korba imam Harunor fua Isamare.” ");
INSERT INTO syll_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Teu gusṭi ar foribar mafik Hozrot Musa, Harun ar Boni Israilor shordar oḳole Kahati oḳolre gonila. ");
INSERT INTO syll_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Tish taki foinchash bosor boyoshi zeta beṭainte Milon-tambur ḳam-ḳaz ḳorar ḳota, ḳali tarare gonila. ");
INSERT INTO syll_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Gonia tarar gusṭi mafik dui azar shat-sho foinchash zon faoa gelo. ");
INSERT INTO syll_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Era-u asla Kahati gusṭir muṭ manush, zera Milon-tambur ḳam-ḳaz ḳorta. Musa nobir marfote Mabudor batail hukum mafik Musa ar Harune tarare gonila. ");
INSERT INTO syll_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Gusṭi ar foribar mafik Zarsuni oḳolre gona oisil. ");
INSERT INTO syll_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Tish taki foinchash bosor boyoshor zeta beṭainte Milon-tambur ḳam-ḳaz ḳorar ḳota, ");
INSERT INTO syll_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","gusṭi ar foribar mafik tarare gonia hari dui azar soy-sho tish zon faoa gelo. ");
INSERT INTO syll_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Era-u asla Zarsuni gusṭir muṭ manush, zera Milon-tambur ḳam-ḳaz ḳorta. Mabudor hukum mafik Musa ar Harune tarare gonila. ");
INSERT INTO syll_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Gusṭi ar foribar mafik Mararia oḳolre gona oisil. ");
INSERT INTO syll_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Tish taki foinchash bosor boyoshor zeta beṭainte Milon-tambur ḳam-ḳaz ḳorar ḳota, ");
INSERT INTO syll_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","gusṭi mafik tarare gonia tin azar dui-sho zon faoa gelo. ");
INSERT INTO syll_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Era-u asla Mararia gusṭir muṭ manush, zera Milon-tambur ḳam-ḳaz ḳorta. Hozrot Musar marfote faoa Mabudor hukum mafik Musa ar Harune tarare gonila. ");
INSERT INTO syll_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Gusṭi ar foribar mafik Hozrot Musa, Harun ar Boni Israilor murobbi oḳole asta Lebi kandanre gonila. ");
INSERT INTO syll_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Tish taki foinchash bosor boyoshi zeta beṭainte Milon-tambur kezmot ar mal-samana boia nibar ḳota, ");
INSERT INTO syll_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","gusṭi mafik tarare gonia aṭ azar fas-sho ashi zon faoa gelo. ");
INSERT INTO syll_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Hozrot Musar marfote Mabudor batail hukum mafik era forteḳ zonor ḳam-ḳaz ar ḳe kita boia nita, hoḳolta buzai deoa oisil. Mabudor deoa hukum mafik Musa nobie Lebi kandanre gonila. ");
INSERT INTO syll_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Tumi Boni Israilre ou hukum deo, tara zanu kemp taki hoḳol fosa-kusṭo bemarire bar ḳori dey, ar hoḳol nomunar datu bemari, mora lash soia zera nafak oise tarare-o kemp taki bar ḳori deuk. ");
INSERT INTO syll_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Beṭa ba beṭi ouk, ogure kemp taki bar ḳori dibae. Boni Israilor kemp zate era nafak na banae, ou niote otare bar ḳori dibae, zano to, shoyong ami Boni Israilor maze boshot ḳori.” ");
INSERT INTO syll_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Teu Boni Israile ola ḳorla. Mabude Musare zela hukum disla, tara ṭik oula-u ḳorla. Tara nafak hoḳol manshore kemp taki bar ḳori dila. ");
INSERT INTO syll_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Bade Mabude Musa nobire ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Tumi Boni Israilre zanai deo, kunu manshe zudi Mabudor naformani koria dusra manshor ḳeti kore, te he beṭa ba beṭi oile-o nichchoy dushi. ");
INSERT INTO syll_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","He tar gunar shikarukti dite oibo. Ar he ze manshor ḳeti korse, tare shullo-ana ḳeti-furon dite oibo. Ze zinishor ḳeti korse, ḳeti-furon hishabe ou zinishor mul damor loge aro fas baṭor eḳ baṭ beshi dite oibo. ");
INSERT INTO syll_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ḳeti-furon neoar zuka manush zudi na roin ar tar kunu afon zon na taḳoin, te ita Mabudor faona oibo. Ou ḳeti-furon ar gunar koforar kurbanir meṛaṭa imam sabe faiba. ");
INSERT INTO syll_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Boni Israile fak-fobitro zoto zinish imamor gese loia aiba, ita hokkolta-u imame faiba. ");
INSERT INTO syll_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Forteḳ zonor kurbani deoa zinish imame faiba. Imamor ato ze zinish deoa oibo, ita imamor-u oibo.” ");
INSERT INTO syll_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Bade Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Tumi Boni Israilre zanai deo, ḳeuror bou zudi ku-fote zaegi, ");
INSERT INTO syll_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ar zamaire lukaia aroḳ beṭar loge zina ḳoria oshoti bone, tair zamaie ikan na zane ba itar kunu shakki-o na taḳe, tai kunu dora na-o ḳae. ");
INSERT INTO syll_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Erbade-o zamaie boure shondoy ḳorilae, tar bitre oshanti korer, kiba boue kunu oshoti kam na ḳorle-o zamaie ḳali taire shondoy ḳore, erlagi tar monor maze oshanti hamaizae, ");
INSERT INTO syll_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","te zamaie tar boure loia imam sabor gese zaite oibo. Zaoar shomoy tar bour torof taki sodga hishabe dui sher barlir moyda nite oibo. Ou moyda oilo shondoyor lagi sodga, Mabudor samne oforad zair ḳorar sodga, erlagi itar maze kunu tel ba kushboydar loban mishani nished. ");
INSERT INTO syll_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“Imame ou beṭar boure Mabudor samne ḳaṛa ḳoraiba. ");
INSERT INTO syll_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Ar maṭir ek gamlar maze kisu fobitro fani borba, boria Allar goror bitoror maṭir ufor taki kisu duil tulia ou fanit saṛiba. ");
INSERT INTO syll_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Beṭire Mabudor samne uba ḳoria harle tain beṭir matar sul kulia diba, ar beṭir oforador hasa-misa zair oar lagi ana sodgar barlir moydare tair ato diba. Dia tan nizor ato loiba hou lannot ḍakia anar titta fani. ");
INSERT INTO syll_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Fani loia imame ou beṭire ḳosom ḳoraia ḳoiba, ‘Tumar biar bade zudi kunu beṭae tumar loge zina na ḳore, ba ku-fote gia tumi oshoti na o, te ou lannot anar titta fanie zanu tumar kunu ḳeti na oy. ");
INSERT INTO syll_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Oile biar bade ku-fote gia dusra kunu beṭar loge zina ḳoria zudi oshoti o,’ ");
INSERT INTO syll_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","—oḳan ḳoia imame ou beṭire nizor ufre lannot ḍakia anar ḳosom ḳoraia hari hirbar ḳoiba— ‘Te Mabude tumare ou gozob deukka, tumar nari-ongo nistez oizauk, ar tumar feṭ fulia muṭa oizauk. Teu ita dekia tumar shomazor manshe zekunu boddua ar lannoti kosom ḳaoar shomoy tumar nam tara iad ḳorbo. ");
INSERT INTO syll_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Ar ou lannot anar fani tumar shorilo hamaia zanu ola ḳam ḳore, zate tumar feṭ fulizae ar tumar nari-ongo nistez oizae.’ Teu beṭie ḳoibo, ‘Amin, ola-u ouk.’ ");
INSERT INTO syll_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“Imame ou lannot ana ḳosmor ḳota eḳ samṛar ufre lekia hari, fani ḍalia ou leḳar ḳali titta fanit falaiba. ");
INSERT INTO syll_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Lannot anar ou titta fani beṭire ḳaoanir bade beṭir feṭo kub zala-zontrona foyda oibo. ");
INSERT INTO syll_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Imame foyla ou beṭir at taki shondoyor sodgar moyda nia Mabudor samne dulaia kurbani kanat loia zaiba. ");
INSERT INTO syll_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Bade tain fura sodgar bodla ou moyda taki nishana hishabe eḳ muiṭ foriman nia kurbani kanat zalaiba, ar hou titta fani beṭire ḳaoaiba. ");
INSERT INTO syll_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Beṭie zudi zamair loge beimani koria oshoti oia taḳe, te i fani kaoar bade-u tair feṭo kub zala-zontrona oibo. Tair feṭ fulia muṭa oibo, ar nari-ongo nistez oia aṭkura bonizibo, manshe lannot dibar niote tair nam loiba. ");
INSERT INTO syll_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Oile tai zudi oshoti na oia ni-oforadi roy, te tai i lannot taki kalas faibo, ar hurutta zonom deoar ḳemota-o zari roibo. ");
INSERT INTO syll_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Zamai-bour shondoyor bishoye Allar ain to ola. Kunu bou zudi zamair shongsharo roia ku-fote gia oshoti bone, ");
INSERT INTO syll_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ba zamaie tar boure bodmaishir shondoy ḳore, te tarar lagi ou ain. Beṭae tar boure Mabudor samne nibo ar imame ita hoḳolta beṭir ufre bortaiba. ");
INSERT INTO syll_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Teu zamaie tar nalish taki kalas faibo, ar bou hasaror oforadi oile tair shaza boibo.” ");
INSERT INTO syll_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Tumi Boni Israilre zanai deo, kunu beṭa ba beṭie zudi Naziria etekaf ḳorta sain, mani kali Mabudor ebadot-bondegir lagi alada roar mannot ḳorilae, ");
INSERT INTO syll_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","te anguror shorbot ba zekunu nomunar shorab ḳaoa taki tara nichchoy horia taḳte oibo. Anguror shirka ba zekunu nomunar shirka ḳaoa taki-o tara basia roibo. Ar tara taza angur, kismis, ba anguror rosh-o ḳaito nae. ");
INSERT INTO syll_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Mul ḳota oilo, era zotodin Naziria etekafo roibo, otodin angur to duror ḳota, anguror eḳṭa bisi ba baḳol-o tara kunu laḳan-u ḳaito farto nae. ");
INSERT INTO syll_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“Ar zotodinor lagi Naziria etekafor niote nizore alada raḳar mannot ḳorsoin, otodin tarar matat kur-beleiṭ lagani nished. Mabudor name alada roar shomoy era pak-pakiza roite oibo. Matar sul lamba ḳorte oibo. ");
INSERT INTO syll_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","I shomoy kunu mora lashor gese zaito farto nae. ");
INSERT INTO syll_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Tarar ma-baba, bai-boin ḳeu mara gele-o nizore nafak korto farto nae, ḳaron erar matar maze to Allar name alada roar nishana sul lagail. ");
INSERT INTO syll_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Tarar i alada roar miad na fura forzonto, pak-pakiza roite oibo. ");
INSERT INTO syll_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Ar aḳta kunu manush zudi tar samne morizae, te ou morar dae Mabudor name raḳa tar matar sul nafak oizaibo, ar hirbar pak oar lagi shat dinor din tar mata ḳamailite oibo. ");
INSERT INTO syll_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Ar aṭ dinor din he duiṭa ḍufi faki ba duiṭa faro loia Milon-tambur duaro imamor gese zaibo. ");
INSERT INTO syll_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Mora lashor gese gia he nafak oae, oḳon tar nafakir guna mafir lagi imame eḳṭa faki dia gunar koforar kurbani, ar dusra faki dia zalail kurbani adae ḳorba. Ou din-u Mabudor name tar matare noya ḳori pak-pakiza raḳte oibo. ");
INSERT INTO syll_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Ar agor laḳan hirbar Mabudor name alada roar mannot ḳora lagbo. Erloge dush-ḳosurir koforar lagi eḳ bosor boyoshi egu meṛa-baichcha kurbani dibo. Ta-o age zotodin he Mabudor name alada roisil, ita batil oizibo, ḳaron hi shomoy he nafak oigesil. ");
INSERT INTO syll_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Zekunu zone Mabudor name Naziria etekafor miad fura ḳoria harle, fobitro Milon-tambur duaror ḳandat zaibo. ");
INSERT INTO syll_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Gia Mabudor name zalail kurbanir lagi eḳ bosor boyoshi egu nikut meṛa-baichcha, ar gunar koforar kurbanir lagi eḳ bosor boyoshi egu nikut meṛi-baichcha, erloge salamoti kurbanir lagi egu nikut meṛa ante oibo. ");
INSERT INTO syll_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Otar logor dan-gomor sodga ar shorbot-fanir sodga anbo, erloge nirek guṛidi banail teldi baza eḳ ṭukri fiṭa ar tel maḳail safaṭi banaio. Ita kuntat-u ḳamir mishaio na. ");
INSERT INTO syll_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Imame ita hoḳolta nia Mabudor samne toia hari, gunar koforar kurbani ar zalail kurbanir loge diba. ");
INSERT INTO syll_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Ar salamoti kurbanir meṛar loge-o ola ḳamir saṛa ruṭi diba. Erlogor dan-gomor sodga ar shorbot-fanir sodga adae ḳorba. ");
INSERT INTO syll_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Bade Milon-tambur duaror gese Naziria etekaf ḳorra zonor matar sul ḳamaia, ou sul salamoti kurbanir tolor aguino falaiba. ");
INSERT INTO syll_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Ar Mabudor name raḳa ou sul ḳamanir bade imame kurbanir meṛar shiddo ḳora ekkan gordona ar ṭukri taki kamir saṛa ekkan fiṭa ar ekkan tel maḳail safaṭi nia Naziria etekaf ḳorra zonor ato diba. ");
INSERT INTO syll_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Bade imame ota nia Mabudor samne usa ḳori dulaiba. Ita to fak-fobitro zinish, ita hokkolta imamor faona. Dulaia toa sinar ou gust ar kurbanir foshur ran-o imamor faona. Ita hoḳolta ḳorar bade Naziria etekaf ḳorra ou zone anguror shorbot ḳaita farba. ");
INSERT INTO syll_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Ita to Naziria etekaf ḳorra zonor lagi ain. Mabudor name alada roia Naziria etekafor niom mafik, ota hoḳolta kurbani dite oibo. Ar zudi tarar shaiddo mafik aro kunta ḳorar niot ḳore, te ota-o ḳorte oibo. Mabudor name alada roar mannot mafik etekafor zoruri hokkolta era adae ḳorbo.” ");
INSERT INTO syll_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Tumi imam Harun ar tar fuainre zanai deo, Boni Israilor lagi dua ḳorar shomoy tara zanu ola ḳoin, ");
INSERT INTO syll_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Mabude deukka rohom-borkot, ar ḳoroukka tumrare hefazot. ");
INSERT INTO syll_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Tan nuror rushni tumrar ufre foṛouk, tan meherbani hamesha zari rouk. ");
INSERT INTO syll_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Mabude tan muk kan zanu tumrar bae firain, ar tumrare shae-shanti dan ḳoroin. ");
INSERT INTO syll_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Ou laḳan tara Boni Israilor ufre amar nam loiba, teu ami tarare rohom-borkot dimu.” ");
INSERT INTO syll_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Hozrot Musae Allar gor bananir ḳam shesh ḳoria hari, fobitro tel siṭaia gorre fak-fobitro ḳorla. Ar goror hoḳol mal-samana, kurbani kana ar er logor tal-bashon hokkolta fak-fobitro ḳorla. ");
INSERT INTO syll_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Ou din Boni Israilor baro ḳandanor shordar oḳol nanan zator ufohar loia aila. Era oila zarzir gusṭir fordan manush, tarar dayitto asil gonia alog kora hoḳol manshor deḳa-huna ḳora. ");
INSERT INTO syll_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Mabudor name tara sani ala soyḳan gorur gaṛi, barogu goru loia Allar goror samne aila. Forteḳ shordaror torof taki eḳṭa ḳori goru ar dui zonor torof taki ekkan ḳori gorur gaṛi deoa oilo. Tara ita ania Allar goror samne toila. ");
INSERT INTO syll_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Teu Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Tumi tarar ges taki ota shomzia raḳo, zate Milon-tambur ḳamo lagani zae. Lebi kandanor ḳadim oḳlor ḳam buzia tarar maze ota baṭia deo.” ");
INSERT INTO syll_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Erlagi Musae ou gaṛi ar goru oguin Lebi kandanor ḳadim oḳolre baṭia dila. ");
INSERT INTO syll_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Erar maze Lebir foyla fua Zarsunor gusṭir ḳam mafik dukan gorur gaṛi ar sairgu goru tarare dila, ");
INSERT INTO syll_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ar aroḳ fua Mararir gusṭir ḳam buzia tarare dila sair ḳan gaṛi ar aṭgu goru. Imam Harunor fua Isamare ou ḳamor todarki korla. ");
INSERT INTO syll_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Oile Lebir fua Kahator gusṭire ita kunta dila na, ḳaron niom asil tara ḳali fak-fobitro siz oḳol deḳa-huna ḳora, ar otare ḳando ḳori boia neoa. ");
INSERT INTO syll_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Kurbani kanat fobitro tel siṭanir shomoy, ikanre boail ḳorar niote shordar oḳole zarzir boḳshish loia aila. Ania kurbani kanar samne toila. ");
INSERT INTO syll_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Mabude Musare ḳoila, “Forteḳ din eḳ eḳ shordare kurbani kanare boail ḳorar niote tan boḳshish ania shomzaiba.” ");
INSERT INTO syll_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Foyla din Ehuda ḳandanor shordar Aminadabor fua Nahishe tan boḳshish loia aila. ");
INSERT INTO syll_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Tain dan-gomor sodgar lagi ebadot ḳanar mafe eḳ-sho tish tola uzonor rufar ekkan tal, ar shottoir tola uzonor rufar ek gamla ania dila, ou tal ar gamlat bora asil dan-gomor sodgar niote tel maḳail moyda. ");
INSERT INTO syll_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Agor-kushboye bora dosh tola uzonor shunar eḳṭa baṭi, ");
INSERT INTO syll_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","zalail kurbanir lagi eḳṭa bisal, eḳṭa meṛa, eḳ bosor boyoshi egu meṛa-baichcha, ");
INSERT INTO syll_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","gunar koforar kurbanir lagi egu sagol, ");
INSERT INTO syll_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","salamoti kurbanir lagi dugu goru, fasgu meṛa, fasgu sagol ar eḳ bosor boyoshi fasgu meṛa-baichcha anla. Ita oilo Aminadabor fua Nahishor ufohar. ");
INSERT INTO syll_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Dui nombor din Isaḳor ḳandanor shordar Sugaror fua Notonele boḳshish loia aila. ");
INSERT INTO syll_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Tain dan-gomor sodgar lagi ebadot ḳanar mafe eḳ-sho tish tola uzonor rufar ekkan tal, ar shottoir tola uzonor rufar ek gamla ania dila, ou tal ar gamlat bora asil dan-gomor sodgar niote tel maḳail moyda. ");
INSERT INTO syll_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Agor-kushboye bora dosh tola uzonor shunar eḳṭa baṭi, ");
INSERT INTO syll_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","zalail kurbanir lagi eḳṭa bisal, eḳṭa meṛa, eḳ bosor boyoshi egu meṛa-baichcha, ");
INSERT INTO syll_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","gunar koforar kurbanir lagi egu sagol, ");
INSERT INTO syll_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","salamoti kurbanir lagi dugu goru, fasgu meṛa, fasgu sagol ar eḳ bosor boyoshi fasgu meṛa-baichcha anla. Ota asil Sugaror fua Notonelor ufohar. ");
INSERT INTO syll_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Tin nombor din Sobulon ḳandanor shordar Helonor fua Iliabe boḳshish loia aila. ");
INSERT INTO syll_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Tain dan-gomor sodgar lagi ebadot ḳanar mafe eḳ-sho tish tola uzonor rufar ekkan tal, ar shottoir tola uzonor rufar ek gamla ania dila, ou tal ar gamlat bora asil dan-gomor sodgar niote tel maḳail moyda. ");
INSERT INTO syll_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Agor-kushboye bora dosh tola uzonor shunar eḳṭa baṭi, ");
INSERT INTO syll_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","zalail kurbanir lagi eḳṭa bisal, eḳṭa meṛa, eḳ bosor boyoshi egu meṛa-baichcha, ");
INSERT INTO syll_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","gunar koforar kurbanir lagi egu sagol, ");
INSERT INTO syll_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","salamoti kurbanir lagi dugu goru, fasgu meṛa, fasgu sagol ar eḳ bosor boyoshi fasgu meṛa-baichcha anla. Ota asil Helonor fua Iliabor ufohar. ");
INSERT INTO syll_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Sair nombor din Ruben ḳandanor shordar Shadiuror fua Alisure boḳshish loia aila. ");
INSERT INTO syll_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Tain dan-gomor sodgar lagi ebadot ḳanar mafe eḳ-sho tish tola uzonor rufar ekkan tal, ar shottoir tola uzonor rufar ek gamla ania dila, ou tal ar gamlat bora asil dan-gomor sodgar niote tel maḳail moyda. ");
INSERT INTO syll_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Agor-kushboye bora dosh tola uzonor shunar eḳṭa baṭi, ");
INSERT INTO syll_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","zalail kurbanir lagi eḳṭa bisal, eḳṭa meṛa, eḳ bosor boyoshi egu meṛa-baichcha, ");
INSERT INTO syll_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","gunar koforar kurbanir lagi egu sagol, ");
INSERT INTO syll_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","salamoti kurbanir lagi dugu goru, fasgu meṛa, fasgu sagol ar eḳ bosor boyoshi fasgu meṛa-baichcha anla. Ota asil Shadiuror fua Alisuror ufohar. ");
INSERT INTO syll_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Fas nombor din Shimion ḳandanor shordar Shuroshadayor fua Shalumile boḳshish loia aila. ");
INSERT INTO syll_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Tain dan-gomor sodgar lagi ebadot ḳanar mafe eḳ-sho tish tola uzonor rufar ekkan tal, ar shottoir tola uzonor rufar ek gamla ania dila, ou tal ar gamlat bora asil dan-gomor sodgar niote tel maḳail moyda. ");
INSERT INTO syll_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Agor-kushboye bora dosh tola uzonor shunar eḳṭa baṭi, ");
INSERT INTO syll_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","zalail kurbanir lagi eḳṭa bisal, eḳṭa meṛa, eḳ bosor boyoshi egu meṛa-baichcha, ");
INSERT INTO syll_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","gunar koforar kurbanir lagi egu sagol, ");
INSERT INTO syll_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","salamoti kurbanir lagi dugu goru, fasgu meṛa, fasgu sagol ar eḳ bosor boyoshi fasgu meṛa-baichcha anla. Ota asil Shuroshadayor fua Shalumilor ufohar. ");
INSERT INTO syll_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Soy nombor din Sadu ḳandanor shordar Duelor fua Iliasofe boḳshish loia aila. ");
INSERT INTO syll_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Tain dan-gomor sodgar lagi ebadot ḳanar mafe eḳ-sho tish tola uzonor rufar ekkan tal, ar shottoir tola uzonor rufar ek gamla ania dila, ou tal ar gamlat bora asil dan-gomor sodgar niote tel maḳail moyda. ");
INSERT INTO syll_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Agor-kushboye bora dosh tola uzonor shunar eḳṭa baṭi, ");
INSERT INTO syll_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","zalail kurbanir lagi eḳṭa bisal, eḳṭa meṛa, eḳ bosor boyoshi egu meṛa-baichcha, ");
INSERT INTO syll_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","gunar koforar kurbanir lagi egu sagol, ");
INSERT INTO syll_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","salamoti kurbanir lagi dugu goru, fasgu meṛa, fasgu sagol ar eḳ bosor boyoshi fasgu meṛa-baichcha anla. Ota asil Duelor fua Iliasofor ufohar. ");
INSERT INTO syll_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Shat nombor din Afraim ḳandanor shordar Amihudor fua Alishamae boḳshish loia aila. ");
INSERT INTO syll_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Tain dan-gomor sodgar lagi ebadot ḳanar mafe eḳ-sho tish tola uzonor rufar ekkan tal, ar shottoir tola uzonor rufar ek gamla ania dila, ou tal ar gamlat bora asil dan-gomor sodgar niote tel maḳail moyda. ");
INSERT INTO syll_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Agor-kushboye bora dosh tola uzonor shunar eḳṭa baṭi, ");
INSERT INTO syll_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","zalail kurbanir lagi eḳṭa bisal, eḳṭa meṛa, eḳ bosor boyoshi egu meṛa-baichcha, ");
INSERT INTO syll_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","gunar koforar kurbanir lagi egu sagol, ");
INSERT INTO syll_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","salamoti kurbanir lagi dugu goru, fasgu meṛa, fasgu sagol ar eḳ bosor boyoshi fasgu meṛa-baichcha anla. Ota asil Amihudor fua Alishamar ufohar. ");
INSERT INTO syll_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Aṭ nombor din Manosha ḳandanor shordar Fatoshuror fua Gomoliele boḳshish loia aila. ");
INSERT INTO syll_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Tain dan-gomor sodgar lagi ebadot ḳanar mafe eḳ-sho tish tola uzonor rufar ekkan tal, ar shottoir tola uzonor rufar ek gamla ania dila, ou tal ar gamlat bora asil dan-gomor sodgar niote tel maḳail moyda. ");
INSERT INTO syll_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Agor-kushboye bora dosh tola uzonor shunar eḳṭa baṭi, ");
INSERT INTO syll_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","zalail kurbanir lagi eḳṭa bisal, eḳṭa meṛa, eḳ bosor boyoshi egu meṛa-baichcha, ");
INSERT INTO syll_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","gunar koforar kurbanir lagi egu sagol, ");
INSERT INTO syll_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","salamoti kurbanir lagi dugu goru, fasgu meṛa, fasgu sagol ar eḳ bosor boyoshi fasgu meṛa-baichcha anla. Ota asil Fatoshuror fua Gomolielor ufohar. ");
INSERT INTO syll_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Noy nombor din Bin-Iamin ḳandanor shordar Zidaunir fua Abidane boḳshish loia aila. ");
INSERT INTO syll_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Tain dan-gomor sodgar lagi ebadot ḳanar mafe eḳ-sho tish tola uzonor rufar ekkan tal, ar shottoir tola uzonor rufar ek gamla ania dila, ou tal ar gamlat bora asil dan-gomor sodgar niote tel maḳail moyda. ");
INSERT INTO syll_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Agor-kushboye bora dosh tola uzonor shunar eḳṭa baṭi, ");
INSERT INTO syll_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","zalail kurbanir lagi eḳṭa bisal, eḳṭa meṛa, eḳ bosor boyoshi egu meṛa-baichcha, ");
INSERT INTO syll_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","gunar koforar kurbanir lagi egu sagol, ");
INSERT INTO syll_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","salamoti kurbanir lagi dugu goru, fasgu meṛa, fasgu sagol ar eḳ bosor boyoshi fasgu meṛa-baichcha anla. Ota asil Zidaunir fua Abidanor ufohar. ");
INSERT INTO syll_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Dosh nombor din Dan ḳandanor shordar Amishadar fua Akiazare boḳshish loia aila. ");
INSERT INTO syll_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Tain dan-gomor sodgar lagi ebadot ḳanar mafe eḳ-sho tish tola uzonor rufar ekkan tal, ar shottoir tola uzonor rufar ek gamla ania dila, ou tal ar gamlat bora asil dan-gomor sodgar niote tel maḳail moyda. ");
INSERT INTO syll_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Agor-kushboye bora dosh tola uzonor shunar eḳṭa baṭi, ");
INSERT INTO syll_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","zalail kurbanir lagi eḳṭa bisal, eḳṭa meṛa, eḳ bosor boyoshi egu meṛa-baichcha, ");
INSERT INTO syll_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","gunar koforar kurbanir lagi egu sagol, ");
INSERT INTO syll_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","salamoti kurbanir lagi dugu goru, fasgu meṛa, fasgu sagol ar eḳ bosor boyoshi fasgu meṛa-baichcha anla. Ota asil Amishadar fua Akiazaror ufohar. ");
INSERT INTO syll_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Egaro nombor din Ashir ḳandanor shordar Ukranor fua Foziele boḳshish loia aila. ");
INSERT INTO syll_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Tain dan-gomor sodgar lagi ebadot ḳanar mafe eḳ-sho tish tola uzonor rufar ekkan tal, ar shottoir tola uzonor rufar ek gamla ania dila, ou tal ar gamlat bora asil dan-gomor sodgar niote tel maḳail moyda. ");
INSERT INTO syll_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Agor-kushboye bora dosh tola uzonor shunar eḳṭa baṭi, ");
INSERT INTO syll_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","zalail kurbanir lagi eḳṭa bisal, eḳṭa meṛa, eḳ bosor boyoshi egu meṛa-baichcha, ");
INSERT INTO syll_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","gunar koforar kurbanir lagi egu sagol, ");
INSERT INTO syll_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","salamoti kurbanir lagi dugu goru, fasgu meṛa, fasgu sagol ar eḳ bosor boyoshi fasgu meṛa-baichcha anla. Ota asil Ukranor fua Fozielor ufohar. ");
INSERT INTO syll_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Baro nombor din Noftali kandanor shordar Inanor fua Ahire boḳshish loia aila. ");
INSERT INTO syll_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Tain dan-gomor sodgar lagi ebadot ḳanar mafe eḳ-sho tish tola uzonor rufar ekkan tal, ar shottoir tola uzonor rufar ek gamla ania dila, ou tal ar gamlat bora asil dan-gomor sodgar niote tel maḳail moyda. ");
INSERT INTO syll_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Agor-kushboye bora dosh tola uzonor shunar eḳṭa baṭi, ");
INSERT INTO syll_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","zalail kurbanir lagi eḳṭa bisal, eḳṭa meṛa, eḳ bosor boyoshi egu meṛa-baichcha, ");
INSERT INTO syll_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","gunar koforar kurbanir lagi egu sagol, ");
INSERT INTO syll_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","salamoti kurbanir lagi dugu goru, fasgu meṛa, fasgu sagol ar eḳ bosor boyoshi fasgu meṛa-baichcha anla. Ota asil Inanor fua Ahiror ufohar. ");
INSERT INTO syll_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Te fobitro tel dia kurbani kanare boail ḳorar shomoy Boni Israilor shordar oḳole zeta dan ḳorsla ita oilo, baro ḳan rufar tal, baroṭa rufar gamla ar baroṭa shunar baṭi. ");
INSERT INTO syll_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Ebadot ḳanar mafe forteḳ rufar talor uzon asil eḳ-sho tish tola ar gamlar uzon asil shottoir tola. Rufar hoḳol tal-bashonor muṭ uzon asil dui azar sair-sho tola. ");
INSERT INTO syll_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Agor-kushboye bora forteḳ shunar baṭir uzon asil dosh tola, shunar baroṭa baṭir muṭ uzon asil eḳ-sho bish tola. ");
INSERT INTO syll_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Zalail kurbanir lagi muṭ barogu bisal, barogu meṛa ar eḳ bosor boyoshi barogu meṛa-baichcha-o era dan ḳorsla. Ar erlogor dan-gomor sodgar hoḳol zinish. Gunar koforar kurbanir lagi muṭ barogu sagol deoa oisil. ");
INSERT INTO syll_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Salamoti kurbanir lagi muṭ sobbishgu goru, shaiṭgu meṛa, shaiṭgu sagol, eḳ bosor boyoshi shaiṭgu meṛa-baichcha. Fobitro tel siṭaia hari kurbani kanare boail ḳorar shomoy ufohar hishabe i hoḳolta deoa oisil. ");
INSERT INTO syll_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Erbade Musa nobie zebla-u Mabudor loge batchit ḳorar lagi Milon-tambut hamaita, ou shomoy shahadot shondukor ḍaḳnar ufre ze duio Karubi roin, erar mazḳan taki tan buli hunta. Mabude ou nomunae Musa nobir loge batchit ḳorta. ");
INSERT INTO syll_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Mabude Musa nobire ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Tumi Harunre ḳo, amar goror serag danir mazor shatoṭa serag ou nomunae lagaita, zate seragor for serag danir samna bae foṛe.” ");
INSERT INTO syll_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Harune ola-u ḳorla. Musare batail Mabudor hukum mafik tain hoḳol serag olaḳan boaila, zate seragor for serag danir samnedi foṛe. ");
INSERT INTO syll_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Serag danir tol taki agar ful forzonto astaṭa ḳaṭi shuna fiṭaia banail oilo. Mabude Musare zela noksha deḳaisla, ṭik ou laḳan serag dani banail oilo. ");
INSERT INTO syll_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Tumi Boni Israilor maz taki, Lebi kandanre alog koria pak-pakiza ḳoro. ");
INSERT INTO syll_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","I pak-pakiza ḳorar niom oilo, foyla tarar ufre fak-fobitro oar fani siṭaia dibae, siṭaia tara nize asta shorilor sul ḳamaia ḳafoṛ-sufoṛ doia fak-saf bonba. ");
INSERT INTO syll_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Ar tara kurbanir lagi egu bisal anba, bisalor loge dan-gomor sodgar lagi tel maḳail moyda, gunar koforar kurbanir lagi-o aroḳṭa bisal anaio. ");
INSERT INTO syll_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Bade tumi Lebi oḳolre loia Milon-tambur samne aibae, aia hokkol Boni Israilre hono dola ḳorbae. ");
INSERT INTO syll_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Lebi oḳolre tumi Mabudor dorbaro azir ḳorbae ar hoḳol Boni Israile tarare ataia shofia diba. ");
INSERT INTO syll_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Imam Harune hoḳol Boni Israilor fokko taki, dulona kurbani hishabe Lebi oḳolre Mabudor samne boḳshia diba, teu tara Mabudor kezmoto ḳam-ḳaz ḳorta farba. ");
INSERT INTO syll_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Bade Lebi oḳole hou duio bisalor ḳollar ufre atai diba, dile tumi er eḳṭa dia gunar koforar kurbani ar dusraṭa dia zalail kurbani adae ḳorio. Olaḳan Lebi oḳlor nafakir kofora adae oibo. ");
INSERT INTO syll_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Tumi Lebi oḳolre Harun ar tar fuaintor samne uba ḳoraia, Mabudor name tarare dulona kurbani hishabe shofia dibae. ");
INSERT INTO syll_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Ou laḳan tumi oinno Boni Israil taki Lebi kandanre alog korbae, teu tara ḳali amar oiba. ");
INSERT INTO syll_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Lebi oḳolre pak-pakiza ḳoria dulona kurbani hishabe shofia dia harle, tara Milon-tambur kezmoto aiba. ");
INSERT INTO syll_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Boni Israil taki basia alog kora i Lebi kandan ḳali amar, ar ḳeuror nae. Forteḳ Israili beṭintor foyla fuar bodla ami Lebi kandanre amar nizor banaisi. ");
INSERT INTO syll_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Boni Israilor goro zonom loa hoḳol foyla fuain amar. Ami Mishori oḳlor foyla fuaintore marilibar ḳalo, Boni Israilor forteḳ foyla fuare amar lagi fobitro ḳoria raḳsi, ita manshor fut ouk ba foshur baichcha ouk, ita to amar. ");
INSERT INTO syll_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Ar oḳon ami Boni Israilor foyla fuaintor zagat ḳali Lebi oḳolre amar nizor ḳoia kobul ḳorsi. ");
INSERT INTO syll_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Ou Lebi oḳolre ami Harun ar tar fuaintore shomzaisi, zate tara Boni Israilor oia Milon-tambur kezmot ḳoroin, tarar gunar koforar usilla ḳoroin. Erlagi Boni Israilor ḳeu amar goror ḳandat aile-o tar ufre kunu gozob lamto nae.” ");
INSERT INTO syll_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Mabude Lebi oḳlor befare Musa nobire zela hukum disla, ou hukum mafik Musa, Harun ar hoḳol Boni Israile ola ḳorla. ");
INSERT INTO syll_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Lebi oḳole nizore fak-saf ḳoria hari tarar ḳafoṛ-sufoṛ-o toila. Bade Harune tarare Mabudor name dulona kurbani hishabe shofia dila, ar tarare pak-pakiza ḳorar niote tarar gunar koforar bebosta ḳorla. ");
INSERT INTO syll_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Erbade Lebi oḳol-o Harun ar tan fuaintor zimmae Milon-tambur ḳadimdarit gela. Gele Mabude Musare Lebi oḳlor befare zela hukum disla, ṭik oula ḳora oilo. ");
INSERT INTO syll_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Bade Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Lebi oḳlor befare ou niom salu oibo, tarar maze fosish bosor ba tar beshi boyoshi manshe Milon-tambur ḳam-ḳaz ḳorba, ");
INSERT INTO syll_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","oile foinchash bosor oia harle tara oboshor failiba, kezmot ḳam bad dilaiba. ");
INSERT INTO syll_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Ou shomoy tara nizor ate Milon-tambur kunu ḳam ḳora nished, oile tarar mone saile baiaintore Milon-tambur ḳamo shae-shaijjo ḳorba. Ou niome tumi Lebi oḳlor ḳam-ḳaz ṭik kori dibae.” ");
INSERT INTO syll_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Boni Israil zati Mishor desh taki baronir dusra bosoror foyla sando, Sinai morubumit Mabude Musa nobire bataila, ");
INSERT INTO syll_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Boni Israile zanu ṭik shomoye Azadi Id adae ḳoroin. ");
INSERT INTO syll_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Tara ou sandor souddo tarik hainja bala amar niom-ḳanun mania id adae ḳorte oibo.” ");
INSERT INTO syll_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Mabudor hukum faia Musae Boni Israilre zanaila Azadi Id adae ḳorar lagi. ");
INSERT INTO syll_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Erdae tara foyla sandor souddo tarik hainja bala Sinai morubumit ou id adae ḳorla. Mabude Musare zelaḳan hukum disla, tara ṭik olaḳan hoḳolta ḳorla. ");
INSERT INTO syll_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Oile tarar maze ḳoyzone mora lashre soia nafak oae, ou din Azadi Id ḳorto farlo na. Erlagi ou din-u tara Musa ar Harun nobir gese gia azir oila. ");
INSERT INTO syll_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Tara Musare zikaila, “Mora lash soae amra nafak oisi, erlagi Boni Israilor loge ṭik shomoy Mabudor name kurbani ditam fartam na ḳene?” ");
INSERT INTO syll_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Musae zuaf dila, “Tumrar befare Mabudor hukum na zana forzonto tumra bar sao.” ");
INSERT INTO syll_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Ou shomoy Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Tumi Boni Israilre ḳo, tara ba tarar bongshor ḳeu zudi mora lashre dora-soar ḳarone nafak bonizae, ba musafir halote lamba soforo taḳe, te tara-o Mabudor name Azadi Id adae ḳorta farba. ");
INSERT INTO syll_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Dusra sandor souddo tarik hainja bala tara ou id ḳorba. Azadi Idor gustor loge ḳamir saṛa ruṭi ar titta hag furaia ḳaiba. ");
INSERT INTO syll_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Bian forzonto kunuzat ḳani zoma raḳa nished, kurbanir gustor zekunu aḍḍi banga nished. Azadi Idor ou hoḳol niom-ḳanun tara mante oibo. ");
INSERT INTO syll_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Oile zera pak-pakiza halote ase, ar zera soforor maze nae, ila kunu zone zudi Azadi Idor kurbani na dey, te Mabudor ṭik kora shomoye kurbani na deoae, tar zati taki tar nam miṭailibae. Tar gunar shaza he faite oibo. ");
INSERT INTO syll_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Boni Israilor maze boshot ḳorra bideshi kunu manshe zudi Mabudor name Azadi Id adae ḳorto sae, te ḳorto farbo. Oile ou idor niom-ḳanun mania adae ḳorte oibo. Boni Israil ba bin-deshi hoḳole-u eḳoi niom mante oibo.” ");
INSERT INTO syll_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Allar gor shahadot tambu zedin ḳaṛa ḳora oilo, ou din kudroti megor kuṭi aia asta gorre gurililo. Hainja taki bian forzonto hara rait i megor kuṭire nuror agunir laḳan deḳa gelo. ");
INSERT INTO syll_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Erbad taki ola oilo, Allar gor dinor bala hamesha megor kuṭie gura roito, ar raitor bala mono oito ita nuror agunir kuṭi. ");
INSERT INTO syll_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Ar fobitro tambur ufre taki megor kuṭi zebla horto, ou shomoy Boni Israil oḳol soforo bar oita, bade zeno gia ou kuṭi tir oito, tara oḳano-u tambu oḳol gaṛita. ");
INSERT INTO syll_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Mabudor hukume tara soforo bar oita ar tan hukume-u sofor bond ḳoria tambu gaṛita. Allar goror ufre zotoboil megor kuṭi roito, tara otoboil kempor bitre roita. ");
INSERT INTO syll_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Allar goror ufre megor kuṭi beshi din roile, Mabudor hukum mania tara kunu soforo bar oita na. ");
INSERT INTO syll_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Maze maze megor kuṭi Allar goror ufre tuṛa din roito. Boni Israil to Mabudor hukume kempo roita ar tan hukume-u hirbar soforo bar oita. ");
INSERT INTO syll_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Ar maze maze ḳali hainja taki bian forzonto megor kuṭi roito. Biane megor kuṭi horigele tara soforo bar oita. Dino ba rait zekunu shomoy megor kuṭi horar loge loge-u tara soforo bar oita. ");
INSERT INTO syll_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Zotodin megor kuṭi Allar goror ufre roito, otodin tara kempo roita, soforo bar oita na. Ita dui din ouk, eḳ mash ba er beshi oile-o bar oita na, ḳali megor kuṭi horar bade tara soforo bar oita. ");
INSERT INTO syll_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Mabudor hukume tara kemp gaṛita ar tan hukume-u soforo roana oita. Musa nobir marfote faoa hukum mafik, tara Mabudor ou niom mania solta. ");
INSERT INTO syll_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Tumi rufar fat fiṭaia duiṭa sunga banao. Boni Israilre ekḳano dola ḳorar niote ḍakibar lagi ou sunga bazaio, tarar nanan dol soforo roana oar bala-o tumi oguin bazaio. ");
INSERT INTO syll_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Ou duio sunga zebla eḳloge bazani oibo, ou shomoy hoḳol Boni Israil tumar samne Milon-tambur duaror gese aia dola oiba. ");
INSERT INTO syll_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Oile eḳṭa sunga bazani oile ḳali Boni Israilor nanan ḳandanor shordar oḳol tumar samne aia dola oiba. ");
INSERT INTO syll_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Foyla bar sunga bazaile Milon-tambur fubedi zera tambu ṭangaise, tara roana diba. ");
INSERT INTO syll_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Dusra bar bazaile douknor galar dol oḳol roana diba. Ikṭa to soforo roana dibar shongkeṭ. ");
INSERT INTO syll_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Te hoḳol manshore dola ḳorar lagi tumi duio sunga bazaio, oile er shur oibo alada roḳomor. ");
INSERT INTO syll_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Ou sunga bazaiba imam Harunor bongshor imam oḳole. Iṭa tumrar lagi ar tumrar bongshodoror lagi-o siroḳalin niom. ");
INSERT INTO syll_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“Nizor desho gia harle tumra zebla kunu zulumbaz dushmonor loge laṛait bar oibae, ou shomoy duio sunga bazaia shongkeṭ dibae. Teu tumrar Mabud Allae tumrar bae kial ḳoria dushmonor at taki tumrare basaiba. ");
INSERT INTO syll_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Tumrar kushi-bashir onusṭano, tumrar hoḳol ido, sandor foyla din zebla zalail kurbani ba salamoti kurbani dibae, ou shomoy-o sunga bazaio. Ou aoaz hunle tumrar Allae tumrar bae souk firaiba. Mono rakio, ami Alla-u tumrar Mabud.” ");
INSERT INTO syll_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Boni Israil zati Mishor taki baronir dusra bosoror dusra sandor bish tarik shahadot tambu mani Allar goror ufre taki kudroti megor kuṭi horigelo. ");
INSERT INTO syll_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Ou shomoy Boni Israile Sinai morubumi taki roana dila. Hou megor kuṭi Faran morubumit aia tir na oa forzonto tara solat-u roila. ");
INSERT INTO syll_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Musa nobir mazdi Mabudor hukum faia, tara foyla bar ou soforo roana oila. ");
INSERT INTO syll_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Foyla-u Ehudar fotaḳar tino ḳandanor nanan fouzi dole roana dila, erar neta asla Aminadabor fua Nahish. ");
INSERT INTO syll_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Erar maze Isaḳor ḳandanor manshor dayitto asil Sugaror fua Notonelor ufre, ");
INSERT INTO syll_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ar Sobulon ḳandanor manshor dayitto asil Helonor fua Iliabor ufre. ");
INSERT INTO syll_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Bade Allar goror hoḳolta kula oilo, teu Zarsuni ar Mararia oḳole oḳanor hoḳolta boia loia roana dila. ");
INSERT INTO syll_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Erar bade Rubenor fotaḳar tino ḳandanor fouzi dole roana dila, erar shordar oila Shadiuror fua Alisur. ");
INSERT INTO syll_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Erar maze Shimion ḳandanor dayitto asil Shuroshadayor fua Shalumilor ufre, ");
INSERT INTO syll_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ar Sadu ḳandanor dayitto asil, Duelor fua Iliasofor ufre. ");
INSERT INTO syll_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Erar bade Allar goror fak-fobitro mal-samana loia Kahati oḳole roana dila. Kahati oḳol zagat gia fosar age-u Allar gor ḳaṛa ḳorar ḳota asil. ");
INSERT INTO syll_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Erbade Afraim fotaḳar tino fouzi dolor manshe roana dila, erar shordar oila Amihudor fua Alishama. ");
INSERT INTO syll_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Er maze Manosha ḳandanor dayitto asil Fatoshuror fua Gomolielor ufre. ");
INSERT INTO syll_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Ar Bin-Iamin ḳandanor dayitto asil Zidaunir fua Abidanor ufre. ");
INSERT INTO syll_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Hoḳol heshe roana oila Dan fotaḳar tino ḳandanor fouzi dolor manshe, tarar shordar oila Amishadar fua Akiazar. Erar samnor hoḳol fouzi dolre fara dia tarar ḳore ḳore roila. ");
INSERT INTO syll_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Er maze Ashir ḳandanor dayitto asil Ukranor fua Fozielor ufre, ");
INSERT INTO syll_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ar Noftali kandanor dayitto asil Inanor fua Ahiror ufre. ");
INSERT INTO syll_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Ou laḳan Boni Israilor nanan fouzi dol eḳe eḳe roana oila. ");
INSERT INTO syll_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Erbade Musae Madian deshor tan hour Shuaib nobir fua Hubobre ḳoila, “Mabude amrare ze desh dibar oada ḳorsoin, amra hou desho zairamgi. Te tumi-o amrar loge ao. Mabude to oada ḳorsoin, tain Boni Israilre bout meherbani korba. Oḳon tumi amrar loge aile amra tumare kub maya-doya ḳormu.” ");
INSERT INTO syll_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hubobe zuaf dila, “Na, ami zaitam nae. Ami amar desho nizor manshor gese firia zaimugi.” ");
INSERT INTO syll_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Oile Musae ḳoila, “Na, na, tumi amrare falaia zaio na. Tumi-u amrar fot deḳaora zon. Morubumir maze kun zagat amrar tambu gaṛa usit, ita to tumar zana ase, erlagi tumi-u oilae amrar souk. ");
INSERT INTO syll_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Huno, tumi zudi amrar loge ao, te Mabude amrare zoto meherbani korar oada ḳorsoin, tumare-o otar baṭ dimu.” ");
INSERT INTO syll_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Ou laḳan Boni Israile Mabudor faṛ taki roana oia tin dinor fot aguai gela. Ar ziraibar lagi ekkan zaga tukaia bar ḳorar kiale, Mabudor hou fobitro shahadot shonduk tin din dori tarar age age gelo. ");
INSERT INTO syll_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Kemp taki roana oar bade, dinor bela Mabudor gaibi megor kuṭi Boni Israilor ufre roito. ");
INSERT INTO syll_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Ou shahadot shonduk roana oile-u Musae ḳoita, “O Mabud, soloukka. Tumar dushmon oḳol sairobae sitri zauk, tumare zetae ingshain, ita tumar samon taki bagouk.” ");
INSERT INTO syll_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Ar zebla ou shonduk tamizito, tain ḳoita, “O Mabud, laḳ laḳ Boni Israilor gese tumi firia ao.” ");
INSERT INTO syll_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Boni Israile nizor duk-koshṭor lagi bezar oia boḳa-zoḳa ḳorla. Erlagi Mabude tarar ita hunia gusa oigela. Tain gozobi aguin faṭaila ar ou aguin tarar maze zolilo, ete kempor kinarar kisu ongsho aguine zoligelo. ");
INSERT INTO syll_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Erdae tara Musa nobir gese gia ḳanda-ḳaṭi lagaila, teu Musae Mabudor dorbaro dua ḳorae aguin nibi gelo. ");
INSERT INTO syll_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Mabudor aguin tarar maze zolchil ḳori, ou zagar nam oigelo Tabera. ");
INSERT INTO syll_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Boni Israilor loge oinnainno zatir zeta manush asla, tara dusra zator mozar kunu ḳanir lagi fagol bonigela, ar erar deḳa-deki Boni Israile-o hirbar ḳanda-ḳaṭi kori koila, “Ish, amra zudi gust ḳaitam fartam! ");
INSERT INTO syll_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Mishoro taḳte to bina foyshae magna mas ḳaitam, hono tormuz, fiaz-roshun, kira, hag-torḳari hokkolta ḳaitam, ita oḳono mono foṛer. ");
INSERT INTO syll_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Oile oḳon amrar ḳoilja hukai gese. Ino to ḳali manna saṛa ḳaoar ar kunta-u nai.” ");
INSERT INTO syll_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Ou manna deḳte ḍula baḳoror laḳan, er rong oilo kismisor laḳan. ");
INSERT INTO syll_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Manshe sairobae taki manna tukaia ania gail-siadi kuṭia ba hil-faṭadi sesia guṛa ḳorta. Bade ita fatilo una dia ba fiṭa banaia ḳaita. Ita ḳaite teldi banail fiṭar laḳan moza. ");
INSERT INTO syll_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Raitor bala Boni Israilor kempor ashe-pashe kua foṛto, ou kuar loge oia behesti kani manna-o foṛto. ");
INSERT INTO syll_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Musa nobir ḳano ailo, fortek goror manshe zarzir tambur duaror gese ubaia ḳandira. Erdae tain kub bezar oila, ar Mabud-o gusae aguin oigela. ");
INSERT INTO syll_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Teu Musae Mabudre ḳoila, “Tumi kene tumar i gulamre ila bifodo falailae? Ami kita dush ḳorlam, ze ḳarone ota manshor bar amar ḳando dilae? ");
INSERT INTO syll_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Ami kunu tarare feṭo loisi ni, ba tara amar feṭ taki zonmise ni? Tumi tarar baf-dadaintor gese ze desh dibar oada ḳorsilae, tarare hono nibar lagi amare ḳene tarar falok-bafor laḳan banaiso, ar tarare kulo ḳori nibar ḳota ḳene ḳoirae? ");
INSERT INTO syll_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ita manshor ḳanir lagi ami oḳon gust kuai faitam? Tara amar gese ḳali gust gust ḳoia sillaira. ");
INSERT INTO syll_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Tarar zimma neoa boṛo moshkil, amar eḳar fokke i zimma neoa shombob nae. ");
INSERT INTO syll_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Tumi zudi amare i moshkilo falao, te tumar duai dia ḳoiar, oḳon-u amare zane marilao. Ar ḳoiram, ami zudi tumar rohomotor tole taki, te nizor souke nizor behalloti dosha amare deḳaio na.” ");
INSERT INTO syll_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Teu Mabude Musare ḳoila, “Boni Israilor maze tumi zarare murobbi neta ar ijjoti hishabe sino, erar maz taki shottoir zon murobbi netare loia amar gese ao. Tumi tarare ḳo, tara Milon-tambur gese aia tumar loge ubaita. ");
INSERT INTO syll_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Ami hono lamia aia tumar loge batchit ḳormu. Tumar maze Allar ze ruhu asoin, ou ruhu ami tarar ufre-o dan ḳormu. Manshor zimmadari boia nite tara-o tumare shaijjo ḳorba. Teu tumar eḳla boa lagto nae. ");
INSERT INTO syll_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Ar tumi ota manshore zanai deo, tara fak-fobitro oia ḳailkur lagi zuit roita, ḳail-u tara ḳanir gust faiba. Tara to gustor lagi Mabudor dorbaro ḳanda-ḳaṭi koria ḳoisil, Mishoro taḳte-u tara arame asil. Te ḳail Mabude tarare gust diba ar tara ḳaiba. ");
INSERT INTO syll_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","I gust ḳali eḳdin-duidin, fasdin-doshdin, ba bishdin nae, ");
INSERT INTO syll_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","fura eḳ mash bori kaiba. Ḳaite ḳaite tarar naḳedi bar oibo, bade ar zane kulaito nae. Ami ila goṭaimu, ḳaron tumrar loge ze Mabud boshot ḳoroin, ou Mabudre tumra mancho na. Tan samne ḳanda-ḳaṭi koria ḳoiso, Mishor taki horia aoa bule tumrar lagi ṭik oise na.” ");
INSERT INTO syll_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Ikan hunia Musae ḳoila, “Ḳali zuddo ḳorar zuka-u to soy laḳ manush amar loge asoin, ar tumi koirae fura eḳ mash bori tarare gust ḳabaibae. ");
INSERT INTO syll_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Te hokkol goru-meṛa zobo ḳorle-o to oto manshor fuito nae, ar doriar hoḳol mas maria anille-o kulaito nae.” ");
INSERT INTO syll_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Mabude zuaf dila, “O Musa, Mabudor kudroti bol oto ḳomzur ni? Te tumi deḳbae, ami tumare zeta ḳoisi, ita hasa, na misa.” ");
INSERT INTO syll_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Teu Musa bare gela, gia ota manshore Mabudor hukum zanaila. Ar Boni Israilor shottoir zon murobbi netare ania Milon-tambur sairobae ḳaṛa ḳoraila. ");
INSERT INTO syll_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Ou shomoy gaibi megor saḳat oia Mabud lamia aila, aia Musa nobir loge batchit ḳorla. Musar ufre Allai ze ruhu asla, Mabude ou shottoir zon netar ufre-o ou ruhur kisu ongsho dila. Ou ruhu tarare dan ḳorar bade, tara kisu shomoy sufi-dorbeshor eshki bab deḳaila, oile bade ar ila oise na. ");
INSERT INTO syll_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Ar ou shottoir zon murobbi netar mazor duizon murobbi kempor bitre roigela, erar nam Ildad ar Midad, tara Milon-tambur gese gesla na. Tebou Allai ou ruhu tara-o faila, faia tara kempor bitre roia sufi-dorbeshor eshki bab deḳaila. ");
INSERT INTO syll_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Ita dekia eḳ zuan beṭae douṛaia gia Musare ḳoila, “Huzur, hunchoin ni? Ildad ar Midad namor duio murobbie kempor bitre sufi-dorbeshor eshki bab deḳaira.” ");
INSERT INTO syll_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Ou shomoy Nunor fua Iusae Musare ḳoila, “O amar malik, afne erare nished deukka.” Ou Iusa zuankir shuru taki-u Musa nobir ḳas ḳadim asla. ");
INSERT INTO syll_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Musae enre ḳoila, “Amar man-shomman-u tumar gese boṛo oigelo ni? Ami sairam, Mabudor hoḳol bondae-u sufi-dorbeshi faukka, ar Mabude afon ruhu tarare dan ḳoroukka.” ");
INSERT INTO syll_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Erbade Musa ar Boni Israilor murobbi neta oḳol kempo firia gelagi. ");
INSERT INTO syll_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Bade Mabudor hukume boṛo eḳ tufan ailo. Ou tufane doriar far taki kuel faki ṭelia ania kempor sairo gala borai dilo. Eḳdinor fot foriman zaga fakie borigelo. Fakir fal maṭi taki dui at usa tub oia, gis lagia foṛi roilo. ");
INSERT INTO syll_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Teu hou din, hou rait, ar bador asta din manshe bare gia kuel fakin tubaia anla. Tara forteḳe ḳompokke foinchash mon ḳori faki dola ḳorlo. Fakin dola ḳoria kempor sairobae tara boaia toila. ");
INSERT INTO syll_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Oile fakir gust tarar muko haranir loge loge-u Mabud gusae aguin oigela. Gusa ḳoria tain bezuita gozobi bemar ḍalila. ");
INSERT INTO syll_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Erlagi i zagar nam deoa oilo Kibrut-Hutaba, mani lalosi oḳlor ḳoybor, ḳaron ou lalosi oḳolre manshe ono ḳoybor disil. ");
INSERT INTO syll_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Erbade tara Kibrut-Hutaba saṛia gelagi, gia Hazirut namor zagat roila. ");
INSERT INTO syll_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Hozrot Musae Itiopia deshor eḳzon beṭire bia ḳorsla. Enre bia ḳorae Musar boin Moriom ar bai Harune Musar birudde mat-ḳota matila. ");
INSERT INTO syll_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Tara ḳoila, “Mabude ḳali Musar marfote matoin ni? Amrar usillae-o matoin na ni?” Ikan Mabude hunla. ");
INSERT INTO syll_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Ashole Musa nobi to asla eḳzon gorima saṛa manush. Zogotor maze ila gorima saṛa ar kunu manush asil na. ");
INSERT INTO syll_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Musar birudde Harun ar Moriomor mat-ḳota hunia-u Mabude Musa, Harun ar Moriomre ḳoila, “Tumra tinozon bar oia Milon-tambur gese ao.” Teu era tinozon ono aila. ");
INSERT INTO syll_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Ou shomoy Mabude-o kudroti megor saḳat oia lamia aila, aia Milon-tambur duaror ges taki Harun ar Moriomre ḍakila. Tara aguaia aile ");
INSERT INTO syll_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Mabude ḳoila, “Tumra amar ḳota huno. Tumrar maze kunu pir-dorbesh taḳle, ami Mabude doroshonor mazdi amar nizore tar gese zair ḳori ar kuabe tar loge batchit ḳori. ");
INSERT INTO syll_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Oile amar gulam Musar loge ila ḳori na. He amar asta shongsharor hoḳol taki bishashi zon. ");
INSERT INTO syll_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ami tar loge samna-samni oia kula-kuli batchit ḳori, kunuta batuni raki na. Ami Mabude ze surote tare didar dei, he amare ola deḳe. Erbade-o tumra amar gulam Musar birudde matite ḍorailae na ni?” ");
INSERT INTO syll_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Erlagi Harun ar Moriomor ufre Mabud gusae aguin oigela, oia tain horia gelagi. ");
INSERT INTO syll_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Megor saḳa zebla Milon-tambu taki ufre uṭigelo, ou shomoy deḳa gelo, Moriomor asta gotro fosa-kusṭo bemare dudor laḳan dola oigese. Harune Moriomor bae saia ou halot deḳla. ");
INSERT INTO syll_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Dekia tain Musare ḳoila, “O amar malik, amra na buzia ze guna ḳorilisi, i kosuri kan tumi mono rakio na. ");
INSERT INTO syll_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Maʼr feṭo taki zonom oar bala ze huruttar ordeḳ shoril koy oigese, tumi Moriomre ila banaio na.” ");
INSERT INTO syll_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Teu Musae ḳandia Mabudor dorbaro aroz ḳorla, “O Alla, tumi amar boinor bemar shifa ḳori deo.” ");
INSERT INTO syll_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Mabude Musare ḳoila, “Tair bafe zudi tair muko ḳali sef falaita, te shormaia tai shat din goror bare roilo one na ni? Ola shatdin taire kempor bare alog raḳo, bade bitre anbae ne.” ");
INSERT INTO syll_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Erlagi Moriomre shat din kempor bare horai toila. Enre bitre anar ag forzonto manshor soforo baroni bond roilo. ");
INSERT INTO syll_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Bade Boni Israil oḳol Hazirut saṛia Faran morubumit gia kemp gaṛila. ");
INSERT INTO syll_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Erbade Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Boni Israilre ami ze Kenan desh ditam sairam, ou deshor hal-hokikot dekia aoar lagi tumi baro ḳandan taki baro zon shordar faṭao.” ");
INSERT INTO syll_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Mabudor hukum faia Musae ola-u ḳorla. Tain Faran morubumi taki zerare faṭaila, era hoḳol-u Boni Israilor shordar. ");
INSERT INTO syll_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Era oila: Ruben ḳandanor Zakuror fua Shammua, ");
INSERT INTO syll_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Shimion ḳandanor Kurir fua Shofat, ");
INSERT INTO syll_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Ehuda ḳandanor Zifunnir fua Kalut, ");
INSERT INTO syll_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Isaḳor ḳandanor Iusufor fua Zigal, ");
INSERT INTO syll_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Afraim ḳandanor Nunor fua Husia, ");
INSERT INTO syll_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Bin-Iamin ḳandanor Rofur fua Foloti, ");
INSERT INTO syll_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Sobulon ḳandanor Soidor fua Goddiel, ");
INSERT INTO syll_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Iusufor fua Manosha ḳandanor Sushir fua Gaddi, ");
INSERT INTO syll_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Dan ḳandanor Gomollir fua Ammiel, ");
INSERT INTO syll_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Ashir ḳandanor Mikailor fua Sotur, ");
INSERT INTO syll_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Noftali kandanor Boshiror fua Noib, ");
INSERT INTO syll_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","ar Sadu ḳandanor Makir fua Guzoyel. ");
INSERT INTO syll_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Kenan deshor hal-hokikot zania aibar lagi guia hishabe Musa nobie erare faṭaila. Tain Nunor fua Husiare Iusa ḳoia ḍakita. ");
INSERT INTO syll_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Kenan desho faṭanir bala Musae tarare ḳoila, “Tumra Negeb morubumir mazedi gia faṛia elaḳat hamaibae. ");
INSERT INTO syll_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Hamaia deḳbae, ou deshḳan kila. I deshor bashinda manush ḳom na beshi, tara ḳomzur na boloban. ");
INSERT INTO syll_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Tarar deshḳan bala na mondo? Deshor ṭaun oḳol usa baunḍori oal ḳora, na baunḍori saṛa? ");
INSERT INTO syll_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Hinor maṭit rosh ase ki na, gas-fala ase ki na? Ar aoar shomoy dekio, farle hou deshor kunu fol-mul loia aio.” Ou shomoy to angur faḳar shomoy aise. ");
INSERT INTO syll_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Teu tara Zin morubumi taki shuru ḳoria Hamator bae Rahob forzonto gia asta deshor hal-hokikot dekia aila. ");
INSERT INTO syll_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Zaoar ḳalo tara Negeb morubumi oia Hebron ṭauno gia azila. I Hebron ṭaun banail oisil Mishor deshor Suan ṭaun bananir shat bosor age. Hino foyluan Anaki kandanor tinzon manush asil, erar nam oilo Ahiman, Shisai, ar Talmai. ");
INSERT INTO syll_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Bade ou guia oḳol Ashkul namor faṛia ḳalor faro taki eḳ soṛi angur shudda asta eḳ lot ḳaṭia loia aila. I anguror soṛi tarar duizone bang dia boia anla. Loge kisu anuar ar ḍumur fol-o anla. ");
INSERT INTO syll_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Boni Israilor shordar oḳole hon taki ou anguror soṛi kaṭae ou zagar nam oigelo, Ashkulor ḳal, mani soṛir ḳal. ");
INSERT INTO syll_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Asta Kenan deshor hal-hokikot dekia hari, sallish din bade tara hoḳol firia aila. ");
INSERT INTO syll_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Ou guia oḳol Faran morubumir Kadesh namor zagat firia aila, ono Musa nobi, imam Harun ar Boni Israil oḳol asla. Era aia hoḳolre honor ḳobor-antor zanaila ar hou deshor fol-mul deḳaila. ");
INSERT INTO syll_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Tara Musare ḳoila, “Afne amrare ze desho faṭaisla, amra hono gia deḳlam, hi deshḳan hasau dud ar mour banḍar-ala desh. Ou deḳoukka, hou deshor fol. ");
INSERT INTO syll_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Oile hinor manush kub foyluan ar tarar ṭaun-o boṛo boṛo ar usa baunḍori kora. Amra Anaki foyluan ḳandanor manshore-o hono deḳsi. ");
INSERT INTO syll_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amaleki oḳol boshot ḳoroin Negeb morubumit. Hiṭṭi, Zibuzi ar Amuri oḳol faṛi elaḳat roin. Ar Kenani oḳlor ḳeu ḳeu doriar ḳandat ar ḳeu ḳeu Zordan gangor faro roin.” ");
INSERT INTO syll_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Ou shomoy Musar samne zeta manush dola asla, Kalute erar shurgul tamaia ḳoila, “Amrar lagi zorur oilo hono gia ou desh doḳol ḳora, ar ita amra farmu-o.” ");
INSERT INTO syll_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ikan hunia tan logor guia oḳole ḳoila, “Na, na, ita manshor loge laṛai kora amrar lagi oshombob, ita amra taki bout bolala.” ");
INSERT INTO syll_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Era hou deshor befare mongoṛa misa matia ḳoila, “Amra ze desh deḳat geslam, i deshe tar proza oḳolre gilia ḳailae. Hinor manush kub usa-muṭa foyluan. ");
INSERT INTO syll_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Amra hino Nefili zator manshore-o deḳsi, ita deḳte doitto-danobor laḳan. Amra to tarar gese tuchcho fifṛar laḳan, tara-o amrare ola fifṛa mono ḳorse.” Zano to, oḳonkur Anaki zati ou Nefili oḳlor bongshodor. ");
INSERT INTO syll_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Ikan hunia hoḳol Boni Israile silla-silli lagailo. Tara hara rait ḳanda-ḳaṭi korlo. ");
INSERT INTO syll_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Hozrot Musa ar Harunor birudde bout ḳota-barta matilo. Tara hoḳole milia Musa ar Harunre ḳoilo, “Haere hae! Amra ḳene hou Mishor desho ba morubumit morlam na? Hono mora-u to bala asil. ");
INSERT INTO syll_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Mabude ḳene amrare zuddor moydano marar niote ou desho nira? Honor dushmon oḳole amrar bou-baichchainre ḳaṛia niba. Er taki Mishoro firia zaoa-u amrar lagi bala nae ni?” ");
INSERT INTO syll_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Tara eḳe-oinne ḳoilo, “Ao, amra eḳzon neta banaia hirbar Mishoro firia zaigi.” ");
INSERT INTO syll_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","I halot dekia Musa ar Harun asta Boni Israil shomazor samne maṭit soizdat foṛla. ");
INSERT INTO syll_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ar ze guia dole ou deshor hal-hokikot dekia aisla, tarar maz taki Nunor fua Iusa ar Zifunnir fua Kalute monor duke nizor gotror ḳafoṛ-sufoṛ siṛilla, ");
INSERT INTO syll_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","siṛia Boni Israil shomazor hokkolre ḳoila, “Huno, amra ze desh deḳat geslam, i deshḳan kub shundor. ");
INSERT INTO syll_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Mabud zudi amrar ufre kush ar razi taḳoin, te amrare hou desho nia far ḳorba, tain dud ar mour banḍar-ala ou deshḳan amrare dan ḳorba. ");
INSERT INTO syll_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Huno, tumra Mabudor morzir ulṭa ḳam ḳorio na. Tumra hi deshor manshore ḍoraio na, tarare gilia ḳaite-o amrar deri oito nae. Tumra itare ḍoraio na, tarar matar ufror saya nai, amrar loge to Mabud asoin.” ");
INSERT INTO syll_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Oile tara hoḳole-u ḳoila Iusa ar Kalutre fattor maria marilta. Ou shomoy Milon-tambu taki asta Boni Israil shomazor samne Mabudor kudroti nur zair oilo. ");
INSERT INTO syll_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Mabude ḳoila, “O Musa, itae amare ar ḳotodin elami korbo? Tarar samne oto keramoti nishana deḳanir bade-o, tara ar ḳotodin amare ekin ḳorto nae? ");
INSERT INTO syll_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Te huno, ami tarar ufre boṛo ek gozob ḍalimu, amar oada ḳora hou deshor malikana ḳaṛia nimugi. Bade ami tumar maz taki ita tone aro boloban, aro boṛo noya eḳ zati foyda ḳormu.” ");
INSERT INTO syll_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Ikan hunia Musae ḳoila, “O Mabud, tumi zudi ila ḳoro, te Mishori oḳole ita hunba. Ar tumi to Mishor taki ita manshore tumar nizor kudrotie bar ḳori ancho. ");
INSERT INTO syll_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Oḳon Mishori oḳole i deshor manshore-o ita zanai diba. Te O Mabud, inor manshe to emne-u zanilisoin zen, Boni Israilor loge loge tumi aso, tumare kub daro taki deḳa zae. Tara hunchoin, tumar nuror megor saya erar ufre ase, tumi dinor bala megor kuṭi ar rait oile aguinor kuṭir surote erar age age ro. ");
INSERT INTO syll_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Oḳon tumi zudi era hoḳolre eḳloge marilao, te zoto zatir manshe tumar ita kudroti kamor ḳobor hunche, tara ḳoiba, ");
INSERT INTO syll_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Mabude Boni Israilre ze desh dibar oada ḳorsla, hi desho loia zaoar ḳemota tan nai, erlagi tain erare morubumit nia marilisoin. ");
INSERT INTO syll_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Te, O din-duniar malik, tumi age zela ḳoislae ola kudroti kam zair ḳoro. Tumi nu ḳoislae, ");
INSERT INTO syll_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Mabude gusa ḳoroin dir gotie, tan maya-mohobbotor kunu shima nai, tain manshor oinnae ar naformanir mafi dein. Oile dushi zonre shaza-o dein, baf-dadar naformanir shaza tar nati-futi forzonto bortain. ");
INSERT INTO syll_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Te tumar duai dia ḳoiram, Mishor desh saṛia aoa taki oḳon forzonto tumi erare zela mafi dirae, tumar hou mayar ḳatire tarar oḳonkur gunare-o ola maf ḳori dilao.” ");
INSERT INTO syll_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Teu Mabude ḳoila, “Aichcha, tumar ḳotae ami itare maf ḳori dilam. ");
INSERT INTO syll_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Oile ami zinda asi ikan zela hasa, asta zogoto amar lila-ḳelae bora iṭa-o zela hasa, ou laḳan aroḳ hasa oilo, ");
INSERT INTO syll_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","23","ita eḳzone-o amar oada ḳora hi desh deḳar shuzug oito nae, ze desh ditam ḳori ami tarar baf-dadar gese oada ḳorslam. Ḳaron itae amar nuror tozolli deḳsoin, tara Mishoro taḳte ar ou morubumit aia-o amar kudroti lila-ḳela deḳar bade-o itae amare manchoin na, borong dosh-doshbar tara amare forikka ḳorsoin. Te tara zotozone amare elami korse, ita eḳzone-o hi desh deḳar ḳofal oito nae. ");
INSERT INTO syll_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Oile amar bonda Kalutor dilor bab ila nae, he amar hukum furafur mane. Erlagi ze desh deḳat he gesil, ami tare hou desho nimu, tar aolad oḳol hi deshor malik oiba. ");
INSERT INTO syll_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Huno, hou deshor faṛia tol zagainto oḳon Amaleki ar Kenani oḳole boshot ḳorra. Te samnor ḳail tumra fisedi gia Akaba shagoror faredi morubumir bae roana oio.” ");
INSERT INTO syll_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Bade Mabude Musa ar Harunre ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Ou naforman zatie amar birudde ar ḳotodin ber-beri korto? Tara amar birudde zeta mat mater, ita to ami hunchi. ");
INSERT INTO syll_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Oḳon tumra gia Boni Israilre ḳo, ami Mabude nizor zindegir ḳosom ḳaia ḳoiram, ami tumrar mukor zeta mat-ḳota hunchi, ami-o tumrar loge ṭik ola-u ḳormu. ");
INSERT INTO syll_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Manush gonibar shomoy tumrar bish bosor ba tar beshi boyoshor zetare gona oisil, mani zetae amar birudde ber-beri korse, itar lash ou morubumir maze foṛi roibo. ");
INSERT INTO syll_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Ami tumrare ze desh ditam ḳori oada ḳorslam, ḳali Zifunnir fua Kalut ar Nunor fua Iusa saṛa ar ḳeu gia hi desho hamanir ḳofal oito nae. ");
INSERT INTO syll_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ar tumrar zeta huruttare ḳaṛia neoa oibo ḳoislae, ami ou huruttainre-u hou desho far ḳormu, tara-u oiba hi deshor malik, ze deshre tumra elami korso. ");
INSERT INTO syll_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Oile tumrar lash ou morubumit foṛi roibo. ");
INSERT INTO syll_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ou morubumir feṭo tumrar ekkere aḳeri zon na mora forzonto, tumrar beimanir lagi tumrar aolad oḳole sallish bosor ono goru-sagolor raḳali korba. ");
INSERT INTO syll_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Kenan deshor hal-hokikot dekia aite ze sallish din lagsil, er eḳ dinor bodla eḳ bosor, oula muṭ sallish bosor tumrar naformanir lagi koshṭo ḳorbae. Teu buzbae, ami zebla ḳeuror birudita ḳori er dosha kila oy. ");
INSERT INTO syll_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Te ami Mabude ḳoiram, ou naforman zatir zeta manshe amar birudde dol bandise, ita hokkolṭi ou morubumit morba.” ");
INSERT INTO syll_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Kenan deshor hal-hokikot zanar lagi Musae ze guia dolre faṭaisla, erar mazor zeguin firia aia beimani kobor roṭaia, hoḳol Boni Israilre dia Musar birudde boḳa-zoḳa ḳoraisil, ");
INSERT INTO syll_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","mani zera hou deshor befare aze-baze mat roṭaisil, tara hokkol-u moha gozobi bemare Mabudor samne morigela. ");
INSERT INTO syll_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Ou guia dolor maz taki kali Nunor fua Iusa ar Zifunnir fua Kalut basia roila. ");
INSERT INTO syll_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Hozrot Musae Mabudor ḳota hoḳol Boni Israilre zanaila. Ita hunia tara monor duke ḳator oigela. ");
INSERT INTO syll_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Bador din biane tara hou faṛi elaḳat zaoar lagi tiar oia ḳoilo, “Ou deḳo, amra zairamgi. Amra to guna ḳoria harsi, te oḳon amra Mabudor oada ḳora desho-u zaitamgi.” ");
INSERT INTO syll_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Oile Musae ḳoila, “Tumra Mabudor hukumor ulṭa zairae ḳene? Tumrar niot fura oito nae. ");
INSERT INTO syll_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Huno, tumra zaio na, ḳaron Mabud tumrar loge nae. Dushmon oḳlor gese tumra aribae. ");
INSERT INTO syll_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Hino gia tumra Amaleki ar Kenani oḳlor mukamuki oibae. Ar Mabudor log saṛia gesogi kori, tain tumrar loge roita nae. Erlagi tumra zuddor muko morbae.” ");
INSERT INTO syll_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Tebou tara tan ḳota ulṭaia hou faṛi elaḳa bae roana dilo. Oile Musa tarar loge gela na ar Mabudor fobitro shahadot shonduk-o kempor bitre roigelo. ");
INSERT INTO syll_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Tarare dekia-u hou faṛia elaḳar Amaleki ar Kenani oḳol lamia aia hamla salailo, ar honor Horma ṭaun forzonto ḳedaia nilo. ");
INSERT INTO syll_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Tumi Boni Israilre zanai deo, ami ze deshḳanre tumrar nizor desh hishabe dan ḳorram, tumra zebla hou Kenan desho zaibae, ");
INSERT INTO syll_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","gia amare kush raḳar niote agunit deoa geran ala zekunu kurbani hishabe tumrar fal taki zebla gai-goru ba meṛa-sagol ania amar name dibar niot ḳorbae, ar zalail kurbani, kunu mannot furonor kurbani, hoḳol nomunar nofol kurbani, ba zekunu idor kurbani dile, ");
INSERT INTO syll_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","kurbanir forteḳ foshur loge dan-gomor sodga-o dibae. Ou sodgar lagi dui sher moydare eḳ sher teldi maḳaia ḳai banaia anbae. ");
INSERT INTO syll_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Oile kurbanir foshuṭa zudi meṛa-baichcha oy, te iṭar loge shorbot-fanir sodga hishabe anguror eḳ sher shorbot-o dibae. ");
INSERT INTO syll_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Ar ou foshu zudi meṛa oy, te tar loge dan-gomor sodga hishabe shua sher teldi maḳaia sair sher moyda dibae. ");
INSERT INTO syll_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Shorbot-fanir sodgar lagi lagbo anguror shua sher shorbot. Ita ania amare kush ḳorar geran ala kurbani hishabe dite oibo. ");
INSERT INTO syll_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Tumra zudi zalail kurbani, mannot furonor kurbani ba salamoti kurbanir lagi kunu goru loia ao, ");
INSERT INTO syll_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","te erloge dan-gomor sodga hishabe soy sher moydare dui sher teldi maḳaia ḳai ante oibo. ");
INSERT INTO syll_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Ar shorbot-fanir sodgar lagi anguror dui sher shorbot-o ante oibo. “Ita oilo agunit deoa kurbani, i kurbanir dumar gerane ami kushi oi. ");
INSERT INTO syll_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Kurbanir fortek goru, meṛa, meṛa-baichcha ba sagolre ou niome kurbani dibae. ");
INSERT INTO syll_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Tumra zoto foriman foshu-u kurbani deo na ḳene, forteḳ foshur loge ou niome sodga-o dibae. ");
INSERT INTO syll_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“Huno, ami Mabudre kush ḳorar niote, zekunu geran ala agunit deoa kurbani adae ḳorar shomoy, forteḳ Boni Israile ou niome kurbani dibae. ");
INSERT INTO syll_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Oinno zatir kunu musafir ba tumrar loge boshot ḳorra kunu bin-deshie zudi, amare kush ḳorar niote agunit deoa geran ala kurbani dito sae, te he-o tumrar laḳan eḳoi niom mante oibo. ");
INSERT INTO syll_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Oarishor for oarish dori ou niom zari roibo. Tumrar shomazor hoḳlor lagi ou niom salu roibo, ita tumra o ba tumrar loge boshot ḳorra bin-deshi oile-o, hoḳlor lagi-u oarishor for oarish dori ou eḳoi niom zari roibo. I befare ami Mabudor gese tumra zela, bin-deshi oḳol-o oula, hoḳol homan. ");
INSERT INTO syll_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Tumrar lagi ar tumrar maze boshot ḳorra bin-deshi oḳlor lagi eḳlaḳan hukum-ahkam ar eḳoi shoriot salu roibo.” ");
INSERT INTO syll_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Erbade Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Tumi Boni Israilre zanao, ami Mabude tumrare ze desho niar, hono gia harle, ");
INSERT INTO syll_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","tumra zebla hou deshor foy-foshol ḳaibae, ou shomoy tumra itar kisu ongsho amar dorbaro sodga hishabe dibae. ");
INSERT INTO syll_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Tumrar ḳetor foyla daoa fosholor moyda dia ekkan ruṭi banaia amar name sodga dibae. Girost-baṛir sodgar laḳan dibae. ");
INSERT INTO syll_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Foyla daoa fosholor ou sodga, oarishor for oarish dori lilla-sodga hishabe tumra amar name dibae. ");
INSERT INTO syll_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“O Musa, tumi Boni Israilre ḳo, ami Mabude tumar mazdi zoto hukum-ahkam disi, tara zudi na zania ota kunu eḳṭa hukum bangilae, ");
INSERT INTO syll_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ita hoḳol hukum to deoar shomoy taki oarishor for oarish dori zari roy, ");
INSERT INTO syll_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","te i ozana befarṭa zanar bade-u asta Boni Israil shomaze milia kurbani dite oibo. Tara eḳṭa bisal dia ami Mabudre kush ḳorar niote geran ala zalail kurbani dibo, erloge niom mafik dan-gomor sodga ar shorbot-fanir sodga dibo. Ar gunar koforar lagi egu sagol-o kurbani dibo. ");
INSERT INTO syll_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Imam sabe asta Boni Israil shomazor ou ozana gunar kofora adae ḳorba, teu tara mafi faiba. Tara to ichcha ḳoria i naformani korse na, tarar bulor lagi Mabudor name agunit deoa kurbani ar gunar koforar kurbani-o adae ḳorse. ");
INSERT INTO syll_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Teu asta Boni Israil shomaz ar tarar maze boshot ḳorra bin-deshi manshore-o maf ḳora oibo, zudio tara hoḳole-u i bul-ḳosuri korse. ");
INSERT INTO syll_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“Oile ḳeu zudi kali eḳla bul ḳoria monor ozante kunu naformani korilae, te gunar koforar kurbanir lagi he eḳ bosor boyoshi eḳṭa sagi loia azir oite oibo. ");
INSERT INTO syll_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Ar ze zone monor ozante ou guna ḳorse, imam sabe Mabudor dorbaro tar gunar koforar bebosta ḳorba. Ou kurbani kobul oile he mafi faibo. ");
INSERT INTO syll_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Bul ḳoria monor ozante ze manshe naformani korilae, ou laḳan forteḳ manshor lagi i niom salu roibo, he Boni Israil ouk, ba bin-deshi ouk, eḳoi niome solbo. ");
INSERT INTO syll_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“Oile Boni Israil ba tarar maze boshot ḳorra oinno kunu zatir ḳeu zudi ichcha ḳoria kunu naformani kore, te he shoyong Mabudre beijjot ḳore. Ila naformanir lagi shomaz taki ogur nam miṭailite oibo. ");
INSERT INTO syll_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Mabudor hukumre elami korae ar naformani korae ogur nam miṭailite oibo, tar i gunar dae-bar tar ufre-u bortaibo.” ");
INSERT INTO syll_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Boni Israil morubumit soforor ḳalo eḳ Zummabare eḳzon manshore daru tubanit deḳla. ");
INSERT INTO syll_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Zummabare daru tubanit deḳae ou manshe tare doria Musa nobi, imam Harun ar hoḳol Boni Israilor samne loia aila. ");
INSERT INTO syll_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Ou laḳan manshore kita ḳorte oibo, i hukum to Allae oḳono zanaisoin na, erlagi ere tara bondi kori toilo. ");
INSERT INTO syll_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Ou shomoy Mabude Musare zanaila, “Ou manshore zane marilite oibo. Tare kempor bare nia hoḳol Boni Israile fattordi iṭaia marilibae.” ");
INSERT INTO syll_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Teu Musar marfote faoa Mabudor hukum mafik, Boni Israile tare kempor bare nia fattor maria marilla. ");
INSERT INTO syll_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Erbade Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Tumi Boni Israilre ḳo, tumra zarzir lebasor faiṛo zazoir lagao, ar zazoiror fortek giṭre lilua sutadi fesaia mul ḳafoṛor loge zuṛa dio. I hukum oarishor for oarish dori manbae. ");
INSERT INTO syll_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","I zazoir laganir ḳaron oilo, otar bae saile tumra amar hokkol hukumor ḳota iad ḳoria ota amol ḳorbae. Teu tumra amar loge kunu beimani kortae nae, tumrar souḳor ar dilor bod ḳaishor ato nizore shofitae nae. ");
INSERT INTO syll_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Amar hoḳol hukum-ahkam amol ḳorar ḳota tumrar iad roibo, tumrar Allar name tumra fak-forezgar bondar halote roibae. ");
INSERT INTO syll_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ami tumrar Mabud Alla. Tumrar Mabud oar kiale, ami tumrare Mishor taki bar ḳori anchi. Ami-u Alla, tumrar Mabud.” ");
INSERT INTO syll_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","2","Lebi kandanor Kurahe Musa nobir birudde dushmoni lagailo. Ou Kurah oilo Kahati gusṭir Izharor fua. Tar loge Ruben ḳandanor Iliabor fua Daton ar Abiram, ar Foletor fua Oune-o Musa nobir birudita ḳorlo. Erar dolo Boni Israilor aro aṛai-sho zon namḳora murobbi neta-o shorik oila. ");
INSERT INTO syll_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Oia tara dol bandia Musa ar Harunre ḳoila, “Tumra to kub beshi baṛabaṛi korrae. Asta Boni Israilor forteḳ manush-u zebla fak-fobitro, Mabud-o tarar loge asoin. Te tumra Mabudor bonda oḳlor ufre ustadi korrae ḳene?” ");
INSERT INTO syll_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Ikan hunia Musa nobi ufoit oia maṭit foṛla. ");
INSERT INTO syll_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Bade tain Kurah ar tar dolor manshore ḳoila, “Ḳail biane-u Mabude deḳaiba, ḳe tan bonda, ar ḳe fak-fobitro. Tain zare fosond ḳoroin, ḳali tarare-u tan ḳasat aite diba. ");
INSERT INTO syll_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","7","O Kurah, huno, tumi ar tumar logor hoḳole ek kam ḳoro, samnor ḳail tumra hoḳole eḳṭa ḳori agor dani loia Mabudor samne agor-kushboy zalao. Tain zare fosond ḳorba, buzilio he-u tan fak-fobitro bonda. Tumra Lebi kandanor manush to beshi baṛigese.” ");
INSERT INTO syll_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Musae tare eoḳan ḳoila, “Tumra Lebi oḳole amar ekkan ḳota huno. ");
INSERT INTO syll_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Tumra mono ḳorrae ni Mabudor Kaba goro ebadoti kora ar shomazor manshor kezmot ḳora ita ekkere huru-muru befar? Huno, Boni Israilor Allae shomazor oinnainno manush taki tumrare basia nia, tan nizor didaro anchoin, zate tumra ou ḳam ḳoro. ");
INSERT INTO syll_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Tain to tumare ar oinnainno Lebi oḳolre nizor daro aibar shuzug disoin, oile tumra dekiar imamotir fodre-o doḳol ḳortae sairae. ");
INSERT INTO syll_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Harun ar kun manush zen, tumra tar birudde boḳa-zoḳa ḳorrae? Tumi ar tumar dolor manshe to Mabudor birudde-u dol bandiso.” ");
INSERT INTO syll_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Erar bade Musae ḳobor dila, Iliabor dui fua Daton ar Abiram aita ḳori, oile tara zanailo, “Amra oto ṭeḳat nae. ");
INSERT INTO syll_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Tumi ou morubumit ania martae ḳori, dud ar mour banḍar-ala hou Mishor desh taki amrare bar ḳori ancho, hi desho to kuntar-u obab asil na. Er bade-o amrar ufre beṭagiri deḳanit lagso. ");
INSERT INTO syll_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ar tumi to amrare hou laḳan kunu dud ar mour banḍar-ala desho-o niso na, kunu zomi-zoma ba angur baganor malikana-o diso na. Tumi ita manshore anda banaia raḳtae sao ni? Na, amra zaitam nae.” ");
INSERT INTO syll_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Ita hunia Musa kub gorom oia Mabudre ḳoila, “Mabud, tumi erar kurbani kobul ḳorio na. Ami to tarar kunu ḳeti korsi na, tarar egu gada-o ami nisi na.” ");
INSERT INTO syll_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Bade Musae Kurahre ḳoila, “Ḳail tumi ar tumar dolor hoḳol aia Mabudor samne azir oibae. Tumrar loge Harun-o azir oiba. ");
INSERT INTO syll_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Forteḳe aia zarzir agor danit agor-kushboy boria Mabudor name zalaibae. Tumrar aṛai-sho zonor hokkole ola zarzir agor dani zalaio. Erloge tumi ar Harune-o agor-kushboy zalaio.” ");
INSERT INTO syll_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Musar hukum mafik forteḳe zarzir agor danit agor-kushboy ar aguin loia, Milon-tambur duaror samne, Musa ar Harunor loge gia ubaila. ");
INSERT INTO syll_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kurahe zebla shomazor hoḳol manshore uskaia dola ḳorlo, ḳoria Milon-tambur duaror gese Musa ar Harunor birudde ubailo, ou shomoy tara hokkolor samne Mabudor kudroti nur zair oilo. ");
INSERT INTO syll_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Mabude Musa ar Harunre ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Ita manshor ges taki tumra hori zao, ami itare sokur foloḳor loge shesh ḳoriliar.” ");
INSERT INTO syll_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Oile Musa ar Harun soizdat foṛia ḳoila, “O Alla, tumi to hoḳol manshor bitre zan deo. Oḳon ḳali eḳzonor naformanir dae asta Boni Israilor ufre tumi gozob ḍalitae ni?” ");
INSERT INTO syll_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Teu Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Tumi Boni Israilre zanai deo, tara zanu Kurah, Daton ar Abiramor tambur ges taki hori zain.” ");
INSERT INTO syll_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Ikan hunia Musa soizda taki uṭia Daton ar Abiramor gese gela, tan ḳore oia Boni Israilor murobbi neta oḳol-o gela. ");
INSERT INTO syll_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Tain Boni Israilre ḳoila, “Tumra ou naforman oḳlor tambu taki hori zao, itar kunu mal-samanat soio na. Arnae tarar gunar shazar loge tumrare-o binash ḳora oibo.” ");
INSERT INTO syll_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Ikan hunia Kurah, Daton ar Abiramor tambur ges taki hoḳol manush hori gela. Ermaze Daton ar Abirame tarar bou-baichchain ar huru-boṛo hoḳol huruttain loia aia zarzir tambur duaror gese ubat asil. ");
INSERT INTO syll_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Ou shomoy Musae Boni Israilre ḳoila, “Tumra ou alamot dekia buzilibae, ami zeta ḳoriar ita amar mongoṛa kunta nae. Ou ḳamor lagi Mabude-u amare faṭaisoin. ");
INSERT INTO syll_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Erar moron zudi oinnainno manshor laḳan shababik halote oy, te mono ḳorio, Mabude amare faṭaisoin na. ");
INSERT INTO syll_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Oile Mabude zudi asanoḳ noya kunu ḳam ḳoroin, ou zomine muk kulia tarare ar tarar hoḳoltare zinda gililae, tara zinda halote-u maṭir tolor fatalo zaegi, te buzilio, era Mabudre elami korse.” ");
INSERT INTO syll_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Musae oḳan ḳoar loge loge-u erar faor tolor maṭi faṭia dui baṭ oigelo, ");
INSERT INTO syll_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ar maṭie a ḳoria Kurahor foribaror hoḳolre tarar mal-samana shoho gilililo. ");
INSERT INTO syll_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Mal-samana shudda zinda halote tara maṭir tole gelogi, bade maṭir faṭa bond oigelo. Oula Boni Israil taki tara eḳdom nifat oigelo. ");
INSERT INTO syll_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Tarar sik-sillani hunia sairobae taki hoḳol manush douṛaia bagila, itae sillai sillai douṛaia ḳoila, “Maṭie hoyto amrare-o gililibo.” ");
INSERT INTO syll_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Ar hou ze aṛai-sho zone agor-kushboy zalaia kurbani korsil, Mabudor ges taki gaibi aguin aia itare zalaia sali korillo. ");
INSERT INTO syll_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Bade Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Tumi imam Harunor fua Ali-Azorre ḳo, ou zalail zaga taki agor dani guin bar ḳoria, er angra-sali nia tuṛa duroi falanir lagi, i agor dani guin fak-fobitro bonigese. ");
INSERT INTO syll_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Naformanir lagi zeguin morigesoin, ou agor dani to tarar asil. Oile Mabudor samne ita azir ḳora oisil, erlagi i hoḳolṭi fak-fobitro oigese. Te tumi ita bangaia fat banaia fobitro kurbani kanare guria toio. Ita nishana hishabe Boni Israilor gese roibo.” ");
INSERT INTO syll_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Teu aguine zolia zeguin morsila, otar ana fitolor agor dani guin imam Ali-Azore ekḳano dola ḳorla. Bade ota bangaia kurbani kana guria toar fat banaila. ");
INSERT INTO syll_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Mabude Musa nobir mazdi zela hukum disla, ein ou laḳan ḳorla. Ikṭa ḳora oilo zate Boni Israilor mono taḳe zen, ḳali Harunor bongsho saṛa dusra kunu zon, agor-kushboy zalanir lagi Mabudor samne zaito farto nae. Zudi zae, te tar dosha ou Kurah ar tar dolor laḳan oibo. ");
INSERT INTO syll_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Oile bador din-u Boni Israilor manshe Hozrot Musa ar Harunor birudde ber-beri lagailo, tara ḳoilo, “Mabudor bonda oḳolre tumra-u marso.” ");
INSERT INTO syll_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Ar shomazor hoḳol manshe zebla Musa ar Harunor birudita ḳoria Milon-tambur muka guria ubailo, ou shomoy hou gaibi megor kuṭie aḳta-u Milon-tambu guri gelo, Mabudor kudroti nur zair oilo. ");
INSERT INTO syll_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Teu Musa ar Harun Milon-tambur samne gela, ");
INSERT INTO syll_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","ar Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Ita manshor ges taki tumra hori zao, ami itare sokur foloḳor loge shesh ḳoriliar.” Ikan hunia-u tara duio zon soizdat foṛla. ");
INSERT INTO syll_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Bade Musae Harunre ḳoila, “Tumar agor dani ato lo, ar kurbani kana taki aguin neo, nia er ufre agor-kushboy zalaia, zoldi kori ota manshor guna mafir kofora adae ḳoro. Mabud to gusae aguin oigesoin, tan lannoti mohamari shuru oigese.” ");
INSERT INTO syll_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Teu Musar ḳotamoto Harune agor danit aguin ar agor-kushboy loia tarar gese douṛaia gela. Er maze-u itar ufre gozob shuru oigesil, oile Harune agor-kushboy zalaia tarar gunar kofora adae ḳorla. ");
INSERT INTO syll_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Tain zinda ar murda zonor mazḳano ubaila, erlagi gozob bond oigelo. ");
INSERT INTO syll_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Kurahor naformanir lagi zeta mara gesla, iguin bade-o aro souddo azar shat-sho manush gozobi mohamarie morla. ");
INSERT INTO syll_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Mohamari bond oia harle Harun Milon-tambur duaror gese Musar daro firia aila. ");
INSERT INTO syll_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Bade Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Tumi Boni Israilre ḳo, tara zanu tarar baf-dadar ḳandan hishabe fortek kandanor shordaror ges taki eḳṭa ḳori muṭ baroṭa laṭi ania tumar gese dey. Dile tumi zarzir laṭir ufre ou zonor nam leḳbae. ");
INSERT INTO syll_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Lebi kandanor laṭit lekio imam Harunor nam, ola baf-dadar ḳandan mafik fortek kandanor shordaror lagi eḳoṭa laṭi taḳbo. ");
INSERT INTO syll_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Milon-tambur bitre fobitro shahadot shondukor samne ze zagat tumrar loge amar deḳa oy, ou laṭiguin hono toio. ");
INSERT INTO syll_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Teu amar fosond ḳora bondar laṭir maze gasor ḳeng fuṭibo. Ou laḳan tumrar birudde Boni Israilor ber-beri kora ami bond ḳormu.” ");
INSERT INTO syll_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Teu Musae ita hoḳolta Boni Israilre zanaila. Ar tarar baf-dadar ḳandan mafik forteḳ shordare zarzir ḳandanor torof taki egu ḳori, muṭ baro ḳandanor baroṭa laṭi ania dila. Ou laṭintor egu laṭi asil Harun nobir. ");
INSERT INTO syll_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Musae ou laṭiguin nia shahadot tambur bitre Mabudor samne toila. ");
INSERT INTO syll_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Bador din Musa gia shahadot tambur bitre hamaia deḳoin, Lebi kandan taki Harunor name ze laṭi raḳa oise, i laṭit ḳali keng nae, kuṛi dia ful fuṭia badam-o dorilise. ");
INSERT INTO syll_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Teu Musae Mabudor samne taki laṭi guin bar ḳori ania Boni Israilor samne toila. Shordar oḳole laṭi guin deḳla, dekia zarzir laṭi sinia nila. ");
INSERT INTO syll_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Bade Mabude Musare ḳoila, “Birudi naforman oḳlor mono roar lagi nishana hishabe tumi Harunor laṭiṭa hirbar shahadot shondukor samne to. Teu amar birudde tarar bokbok kora ḳan tumi bond ḳortae farbae, tara-o ar morta nae.” ");
INSERT INTO syll_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Mabude Musare zela hukum dila, Musae ṭik ola ḳorla. ");
INSERT INTO syll_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Ita dekia Boni Israile Musare ḳoila, “Amra to morizaiar, binash oiziar, amrar shorbonash oizar! ");
INSERT INTO syll_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Zekunu manush Mabudor goror daro gele-u morizar, te amra hoḳol-u morizimu ni?” ");
INSERT INTO syll_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Mabude Harun nobire ḳoila, “Fobitro ebadot ḳanar befare zoto naformani kora oibo, er day-dayitto bortibo tumar ufre, tumar fuain ar tumar gusṭir hoḳlor ufre-o. Ar imamoti kamor bala zoto laḳan naformani kora oibo, itar dayi oibae ḳali tumi ar tumar fuain. ");
INSERT INTO syll_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Te tumar baf-dadar ḳandan taki aro Lebi oḳolre tumi ano. Tara aia tumare ar tumar fuainre shahadot tambur samnor ebadoti kamo shaijjo ḳorba. Tara tumar zimmae roia shahadot tambur hoḳol ḳam-ḳaz ḳorba. ");
INSERT INTO syll_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Oile kurbani kana ba Allar goror kunu fobitro zinishor daro zaoa tarar lagi nished. Nished na manle tara ar tumra hoḳol-u morbae. ");
INSERT INTO syll_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Tara tumar ḳamo shorik oia Milon-tambur ḳadimdari korba, hoḳol zat ḳamor day-dayitto niba. Ta-o ḳali Lebi oḳol saṛa dusra ḳeu tumrar gese zaoa nished. ");
INSERT INTO syll_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Boni Israilor ufre ami zanu hirbar naraz na oi, erlagi ebadot ḳana ar kurbani kana deḳa-hunar bar tumrar ufre roibo. ");
INSERT INTO syll_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Ami nize tumrare ufohar hishabe dibar lagi, Boni Israilor mazor Lebi oḳolre fosond ḳorsi. Milon-tambur ḳam ḳorar lagi erare Mabudor name shofi deoa oise. ");
INSERT INTO syll_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Oile imam hishabe ḳali tumi ar tumar fuainte kurbani kana ar fordar bitoror Herem Shorifo kezmot ḳam ḳorbae. Imamotir fod ḳan ami ufohar hishabe tumrare dilam. Ḳali Lebi oḳol saṛa dusra ḳeu zudi Milon-tambur shimanat ae, te tare zane marilite oibo.” ");
INSERT INTO syll_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Erbade Mabude Harunre ḳoila, “Amar name zoto laḳan kurbani deoa oy, itar hoḳol zimmadari ami nize-u tumar ato shomzaisi. Te amar name Boni Israilor kurbani kora hoḳol fak-fobitro zinish, ami tumare ar tumar oarishor faona beton hishabe siroḳalor lagi dilailam. ");
INSERT INTO syll_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Ḳas fobitro kurbanir ze ongsho aguino zalani lagto nae, ou baṭo tumra niogi. Te dan-gomor sodga, gunar koforar kurbani, ar dush-ḳosurir koforar kurbanir lagi Boni Israile amar gese zotota loia aiba, ita tumi ar tumar oarish oḳlor faona hok. ");
INSERT INTO syll_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Ita nia hari kas fak-fobitro zinish buzia ijjot ḳoria tumra ḳaio. Tumrar hoḳol beṭainte ita ḳaitae farbae. I kani tumrar lagi fobitro. ");
INSERT INTO syll_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Ar Boni Israilor deoa hoḳol dulona kurbanir zinish-o tumrar oibo. Ita ami tumare ar tumar oarish oḳolre siroḳalin faona hishabe diram. Tumar foribaror zera pak-pakiza halote roiba, tara ita ḳaita farba. ");
INSERT INTO syll_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Boni Israile tarar ḳetor hoḳol taki bala ze tel, noya anguror shorbot ar fosholor ze ongsho Mabudor name sodga diba, ita hokkolta ami tumare dilailam. ");
INSERT INTO syll_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Mabudor gese ana tarar folail foy-fosholor foyla ongsho tumar oibo. Tumar foribaror mazor zera pak-pakiza halote taḳba, tara ita ḳaiba. ");
INSERT INTO syll_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Boni Israile furafur dabi-daoa saṛia mannot hishabe zoto zinish diba, ita-o tumi faibae. ");
INSERT INTO syll_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Mabudor name shofi deoa forteḳ foyla baichcha tumar oibo, ita manshor aolad ouk ba foshur baichcha ouk. Manshor foyla fuare tumi nichchoy ḳalas ḳoria nite dio, ar nafak foshur foyla meda baichchare-o ola ḳalas ḳori nite dio. ");
INSERT INTO syll_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Manshor foyla fuar boyosh eḳ mash oile ḳalas ḳoranir zanor bodla babot, ebadot ḳanar mafe fas tola rufa nia azad ḳori dio. ");
INSERT INTO syll_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Oile gai-goru ba meṛa-sagolor foyla baichchare ḳalas ḳorai nite dio na, iguin to halal. Itare kurbani dia tumi kurbani kanar ufre lou siṭaia dio, ar sorbire agunit deoa kurbani hishabe zalaio. I kurbanir dumar gerane ami Mabud kushi oi. ");
INSERT INTO syll_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Dulona ḳorail sina ar ḍainor ranor gustor laḳan, oguintor gust-o tumi faibae. ");
INSERT INTO syll_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Mabudor name Boni Israilor kurbani kora hoḳol fobitro zinish tumar faona babot ami tumare ar tumar aolad oḳolre siroḳalor lagi dilailam. Ita oilo Mabudor loge tumi ar tumar oarishor lagi siroḳalin chukti, er kunu rod-bodol oito nae.” ");
INSERT INTO syll_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Erbade Mabude Harunre ḳoila, “Boni Israilor desho tumi kunu don-doulotor malikana ba zomi-zomar kunu baṭo faitae nae. Erar maze tumar faona baṭ oilam shoyong ami, ami-u tumar don-doulot.” ");
INSERT INTO syll_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Mabude ḳoila, “Boni Israile tarar ruzi-ruzgaror dosh baṭor eḳ baṭ to amare diba, ami-o ita Lebi kandanor faona beton babot dilailam. Milon-tambut ebadoti kamor mozuri hishabe tara ita faiba. ");
INSERT INTO syll_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Ar aiz taki Boni Israilor dusra kunu gusṭir manush Milon-tambur daro zaoa nished. Gele tarar naformanir dae tara morba. ");
INSERT INTO syll_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Milon-tambur ḳam-ḳaz ḳali Lebi kandane ḳorba, ou ḳamo zekunu naformani korle tara nize-u dayi oiba. Ita oibo oarishor for oarish dori eḳṭa siroḳalin niom. Boni Israilor oinnainno ḳandanor loge kunu don-doulotor malikana Lebi kandane faito nae. ");
INSERT INTO syll_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Er bodla Boni Israile tarar ruzi-ruzgaror ze dosh baṭor eḳ baṭ Mabudor dorbaro azir ḳorba, ita ami erar faona hishabe dilailam. Erlagi erar befare ami Mabude ḳoisi, Lebi oḳole Boni Israilor maze kunu zomi-zomar malikana faita nae.” ");
INSERT INTO syll_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Bade Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Tumi Lebi oḳolre ḳo, oinnainno Boni Israilor ruzi-ruzgaror ze dosh baṭor eḳ baṭ faona hishabe ami tumrare dilam, ita faia harle tumra-o otar dosh baṭor eḳ baṭre, zoḳator zoḳat babot Mabudor name dilaibae. ");
INSERT INTO syll_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Ou zoḳatre-u tumrar ḳetor fosholor ar nizor banail anguror shorbotor zoḳat hishabe gona oibo. ");
INSERT INTO syll_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Boni Israilor baki egaro ḳandanor zoḳat babot ze dosh baṭor eḳ baṭ tumra faibae, oḳan taki tumra-o ola dosh baṭor eḳ baṭ Mabudor name zoḳat dibae. Mabudor namor ou ongsho tumra imam Harunor ato dio. ");
INSERT INTO syll_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Tumrare zotota deoa oibo, tumra-o otar hoḳol taki bala ar fobitro ongsho, Mabudor faona hishabe tanre dio. ");
INSERT INTO syll_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Hoḳol taki bala ongsho Mabudre deoar bade zeta baki roibo, otare tumrar nizor ḳetor foshol, ar tumrar nizor banail anguror shorbot hishabe gona oibo. ");
INSERT INTO syll_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Ou ongsho tumra ar tumrar foribaror manshe zekunu zagat ḳaitae faro, ita to tumrar ḳamor beton, Milon-tambur kezmotor beton. ");
INSERT INTO syll_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Hoḳol taki bala ongsho Mabudor name dilaile, bakita ḳaite tumrar kunu dush nai. Ar Boni Israilor deoa fak-fobitro malre tumra ofobitro ḳorio na, teu tumra mortae nae.” ");
INSERT INTO syll_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Erbade Mabude Musa ar Harunre ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Tumra Boni Israilre ḳo, Mabude shoriotor hukum mafik bataisoin, tumra furafur lal rongor egu ḍeki goru loia amrar gese ao, ou ḍeki shullo-ana nikut oito, ar tair ḳando kunudin zual lagani oise na. ");
INSERT INTO syll_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Ogu ania tumra imam Ali-Azoror gese dibae. Imame iṭare kempor bare nia tan samne zobo ḳoraiba. ");
INSERT INTO syll_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Zobor bade tan angulo kisu lou loia Milon-tambur samna bae shatbar siṭaiba. ");
INSERT INTO syll_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Tan samne-u ou gair ḳal, gust, lou ar gufor shudda at-boṛ aguindi zalailio. ");
INSERT INTO syll_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Ou ḍekire zalanir shomoy imame debdaru gasor kisu daru, esub gasor ḍeṭa, ar lal rongor kisu sutare ou agunir maze falaiba. ");
INSERT INTO syll_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Bade tain naiba, ar finnor ḳafoṛ-sufoṛ-o doiba. Naia-doia harle tain kempor bitre zaita farba, oile hainja forzonto tain nafak halote roiba. ");
INSERT INTO syll_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Ze zone ou ḍekir hoḳolta zalaibo, he-o naia hari kafoṛ-sufoṛ doibo ar hainja forzonto nafak roibo. ");
INSERT INTO syll_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Ou ḍekir zalail sali kanain kunu fak-saf manshe tulia nia, kempor bare kunu pak zagat toibo. Boni Israile fak-saf oar fani tiar ḳorar lagi ou salire zotone toiba. Bade nafak taki fak-saf oar ḳalo ou fani kamo lagaiba. ");
INSERT INTO syll_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Ze zone ou sali tulbo, he-o tar ḳafoṛ-sufoṛ doite oibo ar hainja forzonto nafak roibo. Iṭa Boni Israil ar tarar maze boshot ḳorra hoḳol zatir lagi siroḳalin niom. ");
INSERT INTO syll_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Ḳeu zudi kunu murdar lash soilae, te shat din bora he nafak roibo. ");
INSERT INTO syll_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Lash soar tin nombor ar shat nombor din, fak-saf oar fobitro fani dia nizore doia harle he fak-saf oibo. Ar i niom na manle he nafak-u roibo. ");
INSERT INTO syll_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Lash soar bade ḳeu zudi fak-saf na oy, te he Mabudor gorre nafak banae. Ou zonre Boni Israilor shomaz taki fusilibae. Pak-saf oar fani tar shorilo na siṭanie, tar nafaki tar loge roibo. ");
INSERT INTO syll_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Ar tambur bitre kunu manush morigele, zera ou tambut hamaiba ar zera tambut asla, tara hoḳol-u shat din bora nafak roiba. ");
INSERT INTO syll_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Ou boshot tambur bitoror zeta tal-bashon hora dia gura asil na, ota-o nafak oizibo. ");
INSERT INTO syll_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Bondor maze kula zagat falail kunu lashre zudi keu soilae, te he shat din bora nafak roibo. I lash kunu laṛair ḳarone ouk, ba emne mora ouk, zera soibo era nafak. Kunu mora manshor aḍḍi ba ḳoyborre soile, he-o shat din bora nafak roibo. ");
INSERT INTO syll_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Ola nafak manshore fak-saf ḳorar niote ze lal ḍekir gust zalani oise, ogur kisu sali eḳṭa gamlat loia, ou gamlat futor fani borte oibo. ");
INSERT INTO syll_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Bade kunu fak-saf manshe esub gasor ḳoyṭa ḍeṭa ania fanit buṛaia hou murdar tambu, er bitoror hoḳol mal-samana ar manshor ufre siṭai diba. Zoto zone emne mora, ba kun oia mora kunu murdar lash, morar aḍḍi-guḍḍi ba ḳoybor soise, tarar ufre-o ou fani siṭai diba. ");
INSERT INTO syll_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Pak-saf ou zone nafak manshor ufre haftar tin nombor ar shat nombor din fani siṭai diba, ar shat nombor din tara fak-saf oiba. Tara gusol ḳoria finnor ḳafoṛ-sufoṛ doiba, ar ou shat nombor dinor hainja taki fak-saf bonba. ");
INSERT INTO syll_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Oile nafak oar bade ḳeu zudi nizore fak-saf na ḳore, te tare shomaz taki fusia falaibae. He nizore nafak rakia Mabudor Herem Shorifre-o nafak banaise. Pak-saf oar fani tar ufre na siṭanie, he nafak roise. ");
INSERT INTO syll_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Ita oibo Boni Israilor lagi eḳṭa siroḳalin niom. “Ze zone ou fak-saf oar fani siṭaiba, ein nize-o tan ḳafoṛ-sufoṛ doite oibo. I fak-saf oar fani kunu manshe soile, he hainja forzonto nafak roibo. ");
INSERT INTO syll_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Nafak halote i zone zotota soibo, ita hoḳolta nafak oizibo, tar soa kunu zinish zegie soibo, he-o hainja forzonto nafak roibo.” ");
INSERT INTO syll_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Bosoror foyla sando hokkol Boni Israil Zin morubumit gia Kadesh elaḳat aia roila. Hono Musa nobir boin bibi Moriomor inteḳal oilo ar tanre dafon ḳora oilo. ");
INSERT INTO syll_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Hino ḳaibar kunu fani na faoae Boni Israile Musa ar Harunor birudde dol bandia erar fise lagla. ");
INSERT INTO syll_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Tara Musar loge ḳaijja ḳoria ḳoila, “Amrar logor baiain zebla Mabudor samne morsla, hou shomoy amra-o morigele bala asil. ");
INSERT INTO syll_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Mabudor bonda oḳolre tumi kene ou morubumit anlae, oḳon foshur fal shudda amra hokkole ono zan kuaitam ni? ");
INSERT INTO syll_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Mishor desh taki tumi kene amrare ola zomor gato loia ailae? I zagat na ase kunu dan-saul ba ḍumur fol, na ase angur ba anuar fol? Ar ḳaibar fani-o nai.” ");
INSERT INTO syll_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Ita hunia Musa ar Harun manshor ges taki horia Milon-tambur duaror gese gia soizdat foṛla. Teu Mabudor nuror tozolli tarar samne zair oilo. ");
INSERT INTO syll_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Tumi hou laṭiṭa lo, loia tumi ar tumar bai Harune hoḳol Boni Israilre ekḳano dola ḳoro. Ar ou boṛo ze fattorgu deḳrae, tarar samne ou fattorre hukum deo, dile ou fattore fani dibo. Boni Israil ar tarar foshufal hoḳole zate fani kaito fare, erlagi tumi ou fattor taki fani bar ḳorbae.” ");
INSERT INTO syll_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Mabudor hukum moto tan samne taki Musae laṭiṭa loila. ");
INSERT INTO syll_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Loia Musa ar Harune manshore ou fattoror gese dola ḳorla. Ar Musae tarare ḳoila, “O beimanor zat, huno, amra ou fattor taki tumrar lagi fani bar ḳortam ni?” ");
INSERT INTO syll_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Oḳan ḳoia Musae laṭi dia ou fattoro dui baṛi marla, baṛi marar loge loge fattor taki zure zure fani bar oilo, teu tara ar tarar foshur fale fani kaila. ");
INSERT INTO syll_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Oile Mabude Musa ar Harunre ḳoila, “Tumra to Boni Israilor samne amare fak-fobitro ḳoia manlae na, amar zobanor ufre borosha ḳorlae na. Erlagi ami ze deshḳan Boni Israilre dan ḳormu, tumra tarare loia hino zaitae fartae nae.” ");
INSERT INTO syll_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Fattor taki ze zagat fani bar oilo, ou zagar nam deoa oilo Meriba, mani kaijja. Ino Boni Israile Mabudor loge ḳaijja ḳorsil, ar Mabude ono-u tan fak-fobitrota tarar samne zair ḳorsoin. ");
INSERT INTO syll_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Bade Musae Kadesh taki manush faṭaia Idum deshor bashshare ḳoila, “Amra to Boni Israil, afnar silsilar baiain. Afnar dorbaro amrar ekkan arzi ase, afne to amrar duḳ-mosibotor ḳota zanoin. ");
INSERT INTO syll_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Te amrar baf-dadain to Mishor desho gesla, ar amra bout bosor hono aslam. Mishori oḳole amra ar amrar moy-murobbir ufre zulum-mosibot ḳorae, ");
INSERT INTO syll_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","amra Mabudor dorbaro ḳanda-ḳaṭi korlam. Teu Mabude amrar foriad kobul ḳoria, tan firista faṭaia amrare hou desh taki bar ḳori anchoin. “Erlagi amra oḳon afnar deshor shimanar Kadesh ṭaunor ḳandat aisi. ");
INSERT INTO syll_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Afne amrare afnar deshor mazdi zaibar shuzug kan deukka. Amra afnar kunu ḳet-kishi ba angur baganor mazedi zaitam nae, kunu kua taki fani-o tulia ḳaitam nae. Amra ḳali Raz Fotedi aṭia zaimu, afnar deshor shimana faronir ag forzonto ḍaine-baue kunubae fao baṛaitam nae.” ");
INSERT INTO syll_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Oile Idumor bashshae ḳoila, “Na, na, tumra ibae zaitae fartae nae. Zaibar sesṭa ḳorle amra zuddot bar oia tumrar ufre hamla ḳormu.” ");
INSERT INTO syll_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Teu Boni Israile zuaf dila, “Amra to ḳali Raz Fotedi zaimu. Amra ba amrar foshur fale zudi afnar deshor kunu fani kai, te itar dam dilaimu. Amra faoe aṭia ḳali desh faṛi dia zaitam sairam.” ");
INSERT INTO syll_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Oile Idum deshor bashshae hirbar ḳoilo, “Na, na, ibaedi tumrar zaoa nished.” Bade Idum deshor bout sifaie beṭagiri deḳaia Boni Israilor loge laṛai korat bar oilo. ");
INSERT INTO syll_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Tara Boni Israilre deshor bitredi zaite dilo na, erlagi era hoḳol firia aila. ");
INSERT INTO syll_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Erbade Boni Israil Kadesh taki roana oia Hur faṛor gese gia azila. ");
INSERT INTO syll_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Hino Idum deshor shimanar daro Mabude Musa ar Harunre ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Harun to tar baf-dadar gese ḳoyboro zaitegi oibo. Ar ami Boni Israilre ze desh dimu, he to hi desho zaito farto nae. Mono ase ni, Meriba namor zagat fanir befare tumra amar hukumor ulṭa ḳam ḳorso. ");
INSERT INTO syll_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Te Harun ar tar fua Ali-Azorre loia tumi Hur faṛor ufre uṭo. ");
INSERT INTO syll_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Uṭia Harunor gotor taki imamoti lebas kulia tar fuare findao, ḳaron Harun tar baf-dadar gese zaibogi, hono-u tar inteḳal oibo.” ");
INSERT INTO syll_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Musae Mabudor hukum mafik ola ḳorla. Hoḳol Boni Israilor samne tara Hur faṛor ufre uṭla. ");
INSERT INTO syll_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Uṭar bade Musae Harunor imamoti lebas kulia hari en fua Ali-Azorre findaila. Hou faṛor ufre Harune inteḳal ḳorla. Bade Musa ar Ali-Azor faṛ taki lamia aila. ");
INSERT INTO syll_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Boni Israile Harunor moutor ḳobor hunia fura tish din tan lagi mattom ḳorla. ");
INSERT INTO syll_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Ar Kenani zatir Orad deshor bashsha Negeb morubumit boshot ḳoroin, ein ḳobor faila, Boni Israil zati Otarimor fotedi aṭia aira, oḳan hunia bashshae tarar ufre hamla ḳoria ḳoyzonre doria nilagi. ");
INSERT INTO syll_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Teu Boni Israile Mabudor dorbaro mannot mania ḳoilo, “O Mabud, tumi zudi Orador ou bashinda oḳolre amrar ato shofia deo, te amra tarar gau-geram ar ṭaun oḳol ekkebare binash ḳorilimu.” ");
INSERT INTO syll_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Mabude tarar minoti kobul ḳorla, ar onor Kenani oḳolre tarar ato shofi dila. Tara era hokkolre ar erar ṭaun oḳolre ekkebare binash ḳorillo. Erlagi ou zagar nam oilo Horma, mani binash. ");
INSERT INTO syll_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Erbade Boni Israile Idum deshor galabae guria zaoar lagi Hur faṛor ges taki Nil doriar faredi roana dila. Oile fotor maze tara odoirjo oia, ");
INSERT INTO syll_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Musa nobi ar Alla Pakor birudde mata-mati lagaila, tara ḳoila, “Amrare Mishor desh taki kene bar ḳori anlae, ou morubumit ania marar lagi ni? Ino to ḳani-o nai, fani-o nai. Ar ola baze ḳani amra dui souke deḳtam fari na.” ");
INSERT INTO syll_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Ou shomoy Mabude tarar maze bout bishakto haf faṭaila. Hafor ḳamoṛe tarar bout zon mara gela. ");
INSERT INTO syll_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Teu manshe gia Musare ḳoila, “Amra to afnar ar Mabudor birudde matia guna ḳorilisi. Te afne oḳon Mabudor dorbaro minoti koroukka, zate ou haf guin amrar ges taki horaia neingi.” Teu Musae tarar lagi minoti korla. ");
INSERT INTO syll_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Mabude Musare ḳoila, “Tumi eḳṭa haf banaia usa ek kuṭir ufre to. Ze manshore hafe ḳamṛaibo, he tumar ou hafor bae saile bala oizibo.” ");
INSERT INTO syll_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Teu Musae ḳaṭi tamadi eḳ haf banaia kuṭir ufre toila. Kunu zonre hafe ḳamṛaile he ou tamar hafor bae saito, ar basizito. ");
INSERT INTO syll_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Bade Boni Israile roana dila, ar Obut namor zagat gia tambu gaṛila. ");
INSERT INTO syll_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ar Obut taki roana oia Muab deshor fubor shimanat, morubumir Iya-Abarimo aia tambu ṭanaila. ");
INSERT INTO syll_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Oḳan taki roana oia Zered namor hukna ḳalor faro gia tambu gaṛila. ");
INSERT INTO syll_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Zered taki roana dia Ornon hukna ḳalor hofaro gia tambu ṭanaila. Amuri oḳlor desho taki ze morubumi shuru oise, i kal asil ou morubumit. Ḳalor eḳ faro Muab desh, oinno faro Amuri oḳlor desh. ");
INSERT INTO syll_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Mabudor Jihad namor kitabo to ase, “Shufa elaḳar Baheb ar Ornon hukna ḳal, ");
INSERT INTO syll_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Aur ṭaunor muka zaora usa-nisa nal, ita to Muab deshor eḳ shimana.” ");
INSERT INTO syll_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Oḳan tone roana oia tara Ber namor ek kuar gese aila. Ono aia harle Mabude Musare ḳoila, “Tumi hoḳol manshore ekḳano dola ḳoro, ami tarare fani dimu.” ");
INSERT INTO syll_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Ikan hunia Boni Israile ou gozol gailo, “O kua, tumar fani utlia foṛouk. Tumra kuar ḳatire gozol gao. ");
INSERT INTO syll_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Ikṭa to hou shordar oḳlor kua, raza oḳole tarar laṭir bole kudisoin, ḳandani gollar zure ḳorsoin.” Bade tara morubumi taki Mottana namor zagat gela. ");
INSERT INTO syll_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Mottana taki Noholiel, Noholiel taki Bamut, ");
INSERT INTO syll_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Bamut taki Muabor faṛia ek kalor faro gela. Ou ḳalor ḳandar Pisga faṛor usa ṭilla taki morubumi deḳa zae. ");
INSERT INTO syll_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Boni Israile Amuri oḳlor bashsha Sihunor gese manush faṭaia minot ḳorla, ");
INSERT INTO syll_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Amra afnar deshor bitredi faroi zaitam sairam, amrare zaibar diba ni? Amra to Raz Fot saṛia ḳet-kishi bae ba angur baganedi zaitam nae, kunu kuar fani-o ḳaitam nae. Afnar deshor shimana faronir ag forzonto hamesha Raz Fotedi aṭat roimu.” ");
INSERT INTO syll_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Oile bashsha Sihune tan deshor bitredi tarare zaite dila na. Tain tan sifai dol loia morubumir maze Boni Israilor loge zuddot bar oila. Tain Iyahaz ṭauno aia tarar loge zuddo lagaila. ");
INSERT INTO syll_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Zuddot Boni Israile hou bashshare toluardi kaṭia Ornon ḳal taki Zabbuk kal forzonto tar asta desh doḳol ḳorilila. Tara Boni-Ammanor shimana forzonto hoḳol zaga doḳol ḳorla, oile Boni-Ammanor shimana asil kub mozbut, ikanre ḍingaia zaoa ḳoṭin. ");
INSERT INTO syll_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Boni Israile Hishbon ar er ash-fashor gau-geram shudda Amuri oḳlor hoḳol ṭaun doḳol ḳoria hono boshoti gaṛila. ");
INSERT INTO syll_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hishbon asil to Amuri bashsha Sihunor razdani. Tain Muab deshor agor bashshar loge zuddo ḳoria Ornon ḳal forzonto asta desh doḳol ḳorsila. ");
INSERT INTO syll_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Erlagi kobi oḳole ḳoin, “Ao tumra hoḳol, Hishbon ṭauno ao, raza Sihunor ṭaunre noya ḳori banao. ");
INSERT INTO syll_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Sihunor ou ṭaun taki aguin bar oia, Muabor Aur ṭaunre sarḳar ḳorlo zalaia, Ornon ḳalor usa zaga binash oigelo, honor hoḳol ṭakurre zalaia marillo. ");
INSERT INTO syll_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Haere Muab, shorbonash! O Komush-devtar bokto oḳol tumra to binash oigelae. Komushor fuain bagia horigese, tar fuṛin oḳol bondi oise, Amuri bashsha Sihunor ato bondi tara. ");
INSERT INTO syll_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Amra-u to tarar loge zuddo ḳorsi, Diban forzonto asta Hishbon binash ḳorsi, tarar batti amra nibailisi, Nufa ar Medeba forzonto dongsho-lila salaisi.” ");
INSERT INTO syll_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Erbad taki Boni Israile Amuri oḳlor desho boshot ḳorat roila. ");
INSERT INTO syll_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Hozrot Musae Zazira ṭauno guia faṭanir bade Boni Israile ou ṭaunor ash-fashor gau-geram hoḳolta doḳol ḳorla, ar honor bashinda Amuri oḳolre ḳedai dila. ");
INSERT INTO syll_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Bade tara firia Bashon deshor bae roana oila. Teu Bashonor bashsha Uze tar hoḳol sifai loia tarar loge zuddo ḳorar lagi Idri ṭauno aia azilo. ");
INSERT INTO syll_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Ou shomoy Mabude Musare ḳoila, “Tumi bashsha Uzre ḍoraio na, ami tare, tar asta deshre ar hoḳol sifaire tumar ato tuli disi. Erlagi Hishbonor Amuri oḳlor bashsha Sihunre tumi ze dosha goṭaislae, ogure-o ola ḳorio.” ");
INSERT INTO syll_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Teu tara bashsha Uz, tar fuain ar hoḳol manshore binash ḳorla. Hesh-mesh tara ḳeu ar zinda roilo na. Boni Israile ou fura desh doḳol ḳorla. ");
INSERT INTO syll_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Erbade Boni Israil gia Ziriho ṭaunor ulṭabae Zordan gangor daro Muab deshor tol zagat tambu ṭangaila. ");
INSERT INTO syll_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Boni Israile Amuri oḳlor ze halot ḳorsil, Muab deshor bashsha Balak bin Shipare ita hoḳolta deḳsoin. ");
INSERT INTO syll_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Boni Israilor oto manush dekia Muabi oḳol ḍoraigela. Ashole-u tara kub beshi gabṛi gela. ");
INSERT INTO syll_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Tara Madian deshor murobbi neta oḳolre ḳoila, “Gorue zela bondor ḳesma gashre leia-fusi kailae, ou dole-o oula amrar sairo galar hoḳolta leia-fusi kailibo.” Ou shomoy Muab deshor bashsha asla Balak bin Shipar. ");
INSERT INTO syll_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Bashshae ḍoraia Balam bin Baur namor pir sabre anar lagi kobria faṭaila. Balam to ou shomoy tan nizor deshor Furat gangor faro Fotur ṭauno asla. Balake ḳobriare ḳoia dila, “Tumra gia tanre ḳoio, Mishor desh taki eḳdol manush bar oia aise. Aia asta zomin boria ḳali gisgis ḳorra, tara oḳon amar samne boshot ḳorra. ");
INSERT INTO syll_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Ita to amra taki beshi boloban. Erlagi afne aukka, aia otare lannot deukka. Teu ami hoyto tarare maria desh taki kedaitam farmu. Ar ami to zani, afne zare dua dein he ṭik-u dua fae, ar zare lannot dein tar ufre hasau lannot foṛe.” ");
INSERT INTO syll_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Teu Muab ar Madianor murobbi neta oḳole isteḳara-azirat ḳoranir ṭeḳa loia roana oigela. Bashsha Balake zela hikai disla, tara gia Balamor gese ola ḳoila. ");
INSERT INTO syll_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Teu Balame tarare ḳoila, “Te afnara aiz rait amar ono roukka. Mabude amare zeta zanaiba, ami ota afnarare zanaimu.” Gotike-u tara tan ono roila. ");
INSERT INTO syll_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Mabude Balamor gese zair oia zikaila, “Tumar loge era ḳara?” ");
INSERT INTO syll_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balame zuaf dila, “Muabor bashsha Balak bin Shipare amar gese ḳobria faṭaisoin, ");
INSERT INTO syll_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","ḳoisoin, Mishor desh taki eḳdol manush aia asta desho gisgis ḳorra. Oḳon afne aia tarare lannot deukka. Teu ami zuddo ḳoria tarare bule ḳedaitam farmu.” ");
INSERT INTO syll_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Oile Mabude Balamre ḳoila, “Tumi erar loge zaio na, ar hita manshore kunu lannot-o dio na. Mono rakio, tara amar rohom-borkot faoa bonda.” ");
INSERT INTO syll_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Bador din biane Balam gum taki uṭia Balakor ḳobria oḳolre ḳoila, “Afnara zarzir desho firot zaukkagi. Ar Mabude amare mana ḳorsoin, afnarar loge na zaoar lagi.” ");
INSERT INTO syll_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Teu Muabi neta oḳole firia gia bashsha Balakre ḳoila, “Balam to amrar loge aite razi oisoin na.” ");
INSERT INTO syll_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Oḳan hunia Balake erar saite aro beshi, aro ijjoti neta oḳolre faṭaila. ");
INSERT INTO syll_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Tara gia Balamre ḳoila, “Bashsha Balak bin Shipare ḳoisoin, afne tan gese zaite kunuzator kunu bada manta na. ");
INSERT INTO syll_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Tain afnare bout ijjot-boḳshish diba, ar afne zela ḳoiba, tain ola-u ḳorba. Ḳali afne zanu tan fokko loia ota manshore lannot dein, tain oḳan-u saira.” ");
INSERT INTO syll_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balame zuaf dila, “Bashsha Balake zudi tan shuna-rufae bora razbaṛi kan-o amare dilain, ta-o amar Mabudor hukumor ulṭa gia ami ekkan ḳam-o ḳortam nae, ita huru ḳam ouk ba boṛo ḳam ouk. ");
INSERT INTO syll_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Oile afnara-o agor erar laḳan aizkur rait ḳan ono ḳaṭai laukka. Ami deki, Mabude amare noya kunta ḳoin ni.” ");
INSERT INTO syll_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Hou rait Allae zair oia Balamre ḳoila, “Era zebla tumare neoat aise, te tumi tarar loge zao. Gele ami tumare zela ḳoimu, tumi kali ola-u ḳorio.” ");
INSERT INTO syll_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Bador din biane Balam pir gum taki uṭia tan gadir ufre godi bisaia Muabi neta oḳlor loge roana oila. ");
INSERT INTO syll_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Tan zaoa dekia Alla Pak tan ufre gusae aguin oigela. Tanre bada dibar kiale Allar firistae fot auglia ubai roila. Balam to gadir ufre soṛia zaira, tan duizon saḳor tan loge asil. ");
INSERT INTO syll_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Mabudor firistae toluar ato loia, fotor maze ubai roisoin dekia, gadiṭa fot saṛia zominedi lami gelo. Gadire hirbar foto tular lagi Balame taire mair-doir ḳorla. ");
INSERT INTO syll_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Bade Mabudor firista zominor angur baganor dui ketor mazor ailor ufre ubai roila. Ailor duio galabae faḳa oal deoa asil. ");
INSERT INTO syll_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Mabudor firistare dekia gadie oalor galabae geshia gelo. Erdae Balamor eḳ fao-o kub gosha laglo. Teu tain hirbar gadire marla. ");
INSERT INTO syll_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Erbade Mabudor firista aguaia gia fotor mazor ola eḳ sifa zagat ubaila, zeno ḍaine-baue kunubae horar ufae nai. ");
INSERT INTO syll_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Mabudor firistare dekia gadie Balamre loia maṭit huti gelo. Teu Balam aro gorom oia laṭi dia gadire marla. ");
INSERT INTO syll_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Ou shomoy Mabude gadir mukor zoban kuli dila. Tai Balamre ḳoilo, “Ami afnare kita ḳorsi, afne tin-tinbar amare marla?” ");
INSERT INTO syll_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balame gadire ḳoila, “Tui amare aua banaia ḳeiṛ ḳelaire ni? Hun, amar ato zudi ekkan toluar taḳto, te tore sed mari oḳon-u ḳaṭillam one.” ");
INSERT INTO syll_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Gadie Balamre ḳoilo, “Ami afnar hou gadi nae ni, zegur ufre afne hara zonom dori soṛia aira, ar afnar loge ami kunudin ila ḳorsi ni?” Balame ḳoila, “Na, ila ḳorsot na.” ");
INSERT INTO syll_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Erbade Mabude Balamor souk kulia dila, tain deḳla, Mabudor firistae toluar loia fot bond ḳori ubai roisoin. Dekia tain mata nuaia nak-kofal maṭit lagaila. ");
INSERT INTO syll_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Teu Mabudor firistae tanre zikaila, “Tumar gadire ḳene tin-tinbar marlae? Tumi amar samne amar birudde ḳam ḳorat zairaegi dekia, ami tumare aṭḳaibar lagi ono aisi. ");
INSERT INTO syll_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Tumar gadie amare dekia tin-tinbar horia gesegi. Tai zudi na horto, te ami tumare marillam one, ar taire basai raḳlam one.” ");
INSERT INTO syll_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Ou shomoy Balame Mabudor firistare ḳoila, “Ami to guna ḳorsi. Ashole ami buzchi na, afne amare aṭḳaibar lagi foto ubat asoin. Te afne naraz oile ami firia zaimugi.” ");
INSERT INTO syll_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Mabudor firistae Balamre ḳoila, “Ṭik ase, tumi ota manshor loge zao. Oile ami tumare zela hikai dimu, tumi kali ola-u ḳoibae.” Teu bashsha Balakor faṭail neta oḳlor loge Balam pir solat roila. ");
INSERT INTO syll_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balam piror aoar ḳobor hunia, tanre aguaia anar lagi bashsha Balak Ornon ḳalor faro Muab deshor eḳ ṭauno gela. I ṭaun asil tan deshor hesh shimanat. ");
INSERT INTO syll_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Bashsha Balake Balam pirre ḳoila, “Ami to afnare zoruri tolob ḳorlam. Te afne ḳene foyla bar aila na? Afnare zoiggo boḳshish dibar ḳemota kunu amar nai ni?” ");
INSERT INTO syll_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balame zuaf dila, “Ami oḳon afnar gese aisi. Oile amar nizor kunu mat matar shaiddo nai. Ḳali Allae amaredi zeta ḳoaiba, ami kali oḳan-u ḳoimu.” ");
INSERT INTO syll_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Erbade Balak bashshar loge oia Balam pir Kiriot-Husut gaut gela. ");
INSERT INTO syll_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Gia bashsha Balake goru ar meṛa kurbani dia kisu gust Balam pirre ar tan logor hou neta oḳolre dila. ");
INSERT INTO syll_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Bador din biane bashsha Balake ou Balamre loia Bamut-Baal faṛo gela. Hono ubaia Balame Boni Israilor eḳ ongshore deḳla. ");
INSERT INTO syll_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Ar ou bianku bala Balam pire Balak bashshare ḳoila, “Afne amar lagi shatḳan kurbani kana banaukka, banaia kurbanir lagi shatgu bisal ar shatgu meṛa zugai deukka.” ");
INSERT INTO syll_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balamor ḳotamoto-u Balake ola ḳorla, ḳoria duiozone milia fortek kurbani kanar ufre egu ḳori bisal ar egu ḳori meṛa kurbani dila. ");
INSERT INTO syll_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Erbade Balam pire Balakre ḳoila, “Afnar kurbani deoa ou foshur ḳasat afne roukka. Ami tuṛa horia zairam, oito fare Mabude amare doroshon diba. Tain amare zeta zanaiba, ami aia afnare ḳoimune.” Oḳan ḳoia Balam pir gia faṛor hoḳol taki usa ṭillar ufre uṭila. ");
INSERT INTO syll_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Ou shomoy Mabude tanre doroshon dila. Balam pire Mabudre ḳoila, “O Mabud, tumi to deḳrae, ami shatḳan kurbani kana banaisi ar fortek kurbani kanar ufre egu ḳori bisal ar egu ḳori meṛa kurbani disi.” ");
INSERT INTO syll_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Teu Mabude Balam pirre eḳ buli hikai dila, dia ḳoila, “Tumi gia Balak bashshare ota ḳoio.” ");
INSERT INTO syll_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Teu Balam pire Muab deshor bashsha Balakor gese firia aia deḳla, bashsha Balake Muab deshor hoḳol murobbi netare loia tan kurbani kora foshur ono ubai roisoin. ");
INSERT INTO syll_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Ou shomoy Balam pire Allar hikaia deoa ou buli hoḳol hunaila, ḳoila, “Siria desh taki Balake amare anaisoin, fubor faṛ oḳlor daro taki Muabor bashsha Balake-u more zugaisoin. Zugaia ḳoila, amar fokko loia Iakubor aolad Boni Israilre lannot deukka, otare boddua deukka. ");
INSERT INTO syll_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Oile Allae lannot disoin na zare, ami kilan dimu lannot tare? Mabude ḳeti korar ḳota na ḳorsoin zar, ami kilan ḳetir ḳota ḳoitam tar? ");
INSERT INTO syll_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Deḳsi ami tarare usa ṭilla taki, tarar baedi saisi to faṛor suṛa taki, deḳlam ami era oila ola eḳ zati, tara roin alog oia baki hoḳol taki. ");
INSERT INTO syll_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Iakubor aolad deki balur danar moto, gonia fuṛaito tare ḳar ase shaiddo? Moron zanu oy amar nekkar ou dolor laḳan aḳerato ouk mor tarar-u laḳan.” ");
INSERT INTO syll_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Ikan hunia bashsha Balake Balamre ḳoila, “Afne ita kita ḳorla? Afnare anaitam amar dushmonre lannot dibar lagi, ar afne ḳali tarare dua dila.” ");
INSERT INTO syll_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Balam pire zuaf dila, “Mabude amar muko zeta zugai disoin, ita ami koimu na kila?” ");
INSERT INTO syll_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Bade bashsha Balake Balam pirre ḳoila, “Afne amar loge aroḳ zagat aukka. Hon tone afnar souke Boni Israilor deḳa faiba. Tara hoḳolre deḳa zaito nae, ḳali eḳ ongshore afne deḳba, dekia afne amar fokko loia tarare lannot diba.” ");
INSERT INTO syll_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Oḳan ḳoia bashsha Balake tanre loia Pisga faṛor ufror Zofim namor bondor maze loia gela. Gia hono shatḳan kurbani kana banaia fortek kurbani kanat egu ḳori bisal ar egu ḳori meṛa kurbani dila. ");
INSERT INTO syll_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Bade Balam pire bashsha Balakre ḳoila, “Zalail kurbanir niote zeta foshu kurbani deoa oise, afne otar daro roukka. Ami oinnobae zairam, Mabudor didar faoar ashae.” ");
INSERT INTO syll_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Mabude Balam pirre didar dila, ar tar zobanor maze kisu buli zugai dia ḳoila, “Tumi bashsha Balakor gese amar hikail ou mat matio.” ");
INSERT INTO syll_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Teu tain bashshar gese gela. Gia deḳla bashshae Muab deshor neta oḳolre loia kurbani kora foshur gese ubai roisoin. Bashshae tanre zikaila, “Mabude afnare kita ḳoisoin?” ");
INSERT INTO syll_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Balam pire ou shomoy Allar hikail ou buli koila, “Bashsha Balak kial ḳoro, oḳon huno dia mon, ere Shiparor fut Balak, mor ḳotat deo ḳan. ");
INSERT INTO syll_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Alla Pak to manush nae zen misa matiba, tain kunu Adom shontan nae zen dil bodlaiba. Tain zela ḳota ḳoin ṭik ola-u ḳoroin, tan oada oḳol-u nichchit fura ḳoroin. ");
INSERT INTO syll_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Nek dua ditam ḳori hukum zela faisi, kila bodlaimu ami munibor ou morzi? ");
INSERT INTO syll_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Iakubor aolador maze Allae kunu bod-nosib deḳsoin na, Boni Israilor ḳofalo kunu duḳ-mosibot leḳsoin na. Tarar Mabud Alla tarar loge asoin tarar malikor joy gan tarar loge loge ase. ");
INSERT INTO syll_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Mishor taki tain-u tarare bar ḳori anchoin tarar fokke tain oila zongli boyrar bol. ");
INSERT INTO syll_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Iakubor aolador ufre kunu zadu-montro solto nae, Israil zatir ufre kunu tabiz-ḳobze ḳam aito nae. Tarar befare oḳon ou buli koa zae, Allae zeta ḳorsoin ota saia deḳo. ");
INSERT INTO syll_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Ou zati to shinghir laḳan gunjria uṭibo, ar shinghor laḳan uṭia ag baṛibo. Shikaror lou ar gust na ḳaoa forzonto tara dom loita nae.” ");
INSERT INTO syll_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Ikan hunia bashsha Balake ḳoila, “Bond ḳoroukka, afne tarare dua-o diba na, lannot-o diba na.” ");
INSERT INTO syll_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balam pire zuaf dila, “Ami to afnare age-u ḳoisi, Mabude amare zela ḳoiba, amar ola-u ḳora lagbo.” ");
INSERT INTO syll_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Bade Balak bashshae Balam pirre ḳoila, “Aukka, ami afnare aroḳ zagat loia zaimu. Hono gele oito fare Allae kushi oia amar fokko loiba, ar afnaredi hotar ufre lannot dite diba.” ");
INSERT INTO syll_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Oḳan ḳoia bashshae tanre loia Piyur namor faṛor ufre gela, ou zaga taki morubumi deḳa zae. ");
INSERT INTO syll_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Ou shomoy Balam pire ḳoila, “Ono amar lagi shatḳan kurbani kana banaia, shatgu bisal ar shatgu meṛa kurbanir bebosta ḳoroukka.” ");
INSERT INTO syll_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Pir sabor ḳotamoto bashshae ola-u ḳorla. Tain fortek kurbani kanar ufre egu ḳori bisal ar egu ḳori meṛa kurbani dila. ");
INSERT INTO syll_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Balam pire zebla buzla, Boni Israilre dua deoa-u oilo Mabudor ichcha, buzia tain agor laḳan ar isteḳara-azirator sesṭa ḳorla na. Borong tan nizor muk morubumir bae firailla. ");
INSERT INTO syll_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Firaia deḳla, Boni Israilor nanan ḳandanor tambu eḳ ek kori ṭangani oise. Ou shomoy tan ufre Allar ruhu lamia aila, ");
INSERT INTO syll_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","tain Allar deoa ou ohi koila, “Bauror fut Balame ḳoira, Souk zar kula ase ein ou buli koira. ");
INSERT INTO syll_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Ze zone Allar kalam hunra, Shorbo-shoktimanor didar faira, zein soizdat foṛia batuni kobor deḳoin, ein oḳan ḳoira. ");
INSERT INTO syll_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","O Iakub bongsho, tumar tambu oḳol kub soḳsoḳa! O Boni Israil, tumar roar zaga ḳoto bala! ");
INSERT INTO syll_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Ita to deḳar moto boṛo ḳezur baganor laḳan, gangor faror hazail-faṛail bonor laḳan, Mabudor lagail agoror gasor laḳan tortaza, fanir daror debdaru gasor laḳan shundor. ");
INSERT INTO syll_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Tarar bora ḳoloshi taki fani utlia foṛbo, bisi ar serae bout fani faibo. Tarar bashsha oiba Ogag bashsha taki-o himmoti, tarar desh oibo namḳora ijjoti. ");
INSERT INTO syll_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Allae Mishor taki tarare bar ḳori anchoin, tain oila tarar fokke bolala zongli boyra, tarar loge zoto zatie lagba, itare tara gilia ḳailiba, tarar aḍḍi-guḍḍire guṛa guṛa ḳorba, tir-donukdi tarare gatiba. ");
INSERT INTO syll_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Shinghor laḳan tara ḳaf dori hutibo, tarare laṛanir shaosh oibo kun beṭar? Tumrare zera dua diba, erar ufre dua lamouk; tumrare zetae lannot diba, itar ufre lannot foṛouk.” ");
INSERT INTO syll_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Ita hunia bashsha Balake Balam piror ufre gusae aguin oigela. Tan nizor ator fiṭit tabṛai tabṛai kiṛimiṛi kaia ḳoila, “Ami afnare anaitam amar dushmonre lannot dibar lagi, ar afne tarare ou lagaia tin-tinbar dua dila. ");
INSERT INTO syll_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Afne amar samon taki horoukka, nizor zagat zaukka. Ami afnare bout furuskar dimu ḳoislam, oile Mabude dila na.” ");
INSERT INTO syll_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Teu Balam pire bashsha Balakre ḳoila, “Afnar faṭail manshore ami age-u ḳoisi na ni, ");
INSERT INTO syll_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","bashshae zudi shuna-rufae bora tan asta razbaṛi kan-u amare dilain, tebou ami amar nizor ichchae bala-bura kunta ḳortam fartam nae, ami Mabudor birudde zaitam nae. Mabude amare zela hukum diba, ami kali ola-u ḳoimu. ");
INSERT INTO syll_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Te ami oḳon amar manshor gese firot zairamgi, oile ou zatie bobishote afnar zatir loge kita kita ḳorba, afnar hushiarir lagi ita agam zanai diar.” ");
INSERT INTO syll_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Balam pire Allar deoa ou aroḳ ohi koila, “Bauror fut Balame ḳoira, Souk zar kula ase ein ou buli koira, ");
INSERT INTO syll_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ze zone Allar kalam hunra, zeinor gese Allatalar aḳol-hekmot ase, zein shorbo-shoktimanor didar faira, zein soizdat foṛia batuni kobor deḳoin, ein oḳan ḳoira. ");
INSERT INTO syll_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Ami to hou zonre dekiar, oḳon samne na taḳle-o dekiar. Tain amar ḳasat na oile-o, amar souk gia tan ufre foṛse. Iakubor bongshot aiba asmanor eḳ tera, Boni Israilor maze-u eḳ raz-laṭi zonmiba. Ein Muab zatir mata faṭaia dui ṭukra ḳorba, Shish nobir aolador ḳolla surmar ḳorba. ");
INSERT INTO syll_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Idum deshre enor doḳolo anba, tan dushmonor ou Seir faṛre ḳobza ḳorba, ar Boni Israil zatie foyluani korba. ");
INSERT INTO syll_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Iakubor bongshor eḳzone raz-godi salaiba, Ir ṭauno zara zinda roiba ein tarare-o binash ḳoriliba.” ");
INSERT INTO syll_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Oḳnain ḳoar bade Balam pire souk melia Amaleki oḳolre deḳla. Dekia Allar ou ohi koila, “Amalek to hoḳol zatir maze asil fordan, oile tarar shesh dosha oibo shorbonash.” ");
INSERT INTO syll_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Bade tain Keni oḳolre deḳla, dekia Allar ou ohi koila, “Tumrar boshot ḳana kub mozbut, tumra to fattoror faṛo basha banaiso, ");
INSERT INTO syll_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","oile agedi tumrar binash goṭibo, tumrare bandia Ashiria desho neoa oibo.” ");
INSERT INTO syll_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Bade Balam pire Allar deoa ou shesh ohi koila, “Haere hae! Allae zebla ota goṭaiba, ou shomoy ḳeu ar zinda roibo ni? ");
INSERT INTO syll_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Saipras difor zaz oḳol aibo, aia Ashiriare durdosha dibo, Aberor manshore-o domaibo, oile ou dif nize-o bade binash oizibo.” ");
INSERT INTO syll_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Oḳan ḳoia hari Balam pir uṭia nizor goro gelagi, Balak bashsha-o tan fote roana dila. ");
INSERT INTO syll_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Boni Israil Muab deshor Shiṭim elaḳat boshot ḳorla, tara ono roia roia Muabi beṭintor loge zina ḳorat lagla. ");
INSERT INTO syll_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Honor beṭinte tarar deb-debir name boli dibar onusṭano Boni Israilre daot dila, ar era gia ota beṭintor loge ḳana-dana ḳaia hou deb-debir puja ḳorla. ");
INSERT INTO syll_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Ou nomunae tara honor Piyur faṛor Baal devtar puja-boḳti deoat lagi gela. Erdae Boni Israilor ufre Mabudor gozobor aguin zolia uṭlo. ");
INSERT INTO syll_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Bade Mabude Musare ḳoila, “Tumi shomazor dushi neta oḳolre doria zane marilao, ar otar lash roidor maze ania loṭḳai to. Teu Boni Israilor ufre taki amar hou lannoti gozob horbo.” ");
INSERT INTO syll_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Oḳan hunia Musae Boni Israilor hakim-salish oḳolre ḳoila, “Tumrar zimmae taḳa zoto manshe Piyur faṛor Baal devtar pujat shorik oise, ota hokkolṭire tumra zane marilao.” ");
INSERT INTO syll_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Ermaze ola oilo, Musa nobi ar Boni Israile milia zebla Allar goror duaror gese ḳanda-ḳaṭi korra, ou shomoy tarar samnedi Boni Israilor eḳ beṭae Madiani eḳ beṭire loge loia kempor bitre hamailo. ");
INSERT INTO syll_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Ita dekia imam Harunor nati Finohosh bin Ali-Azor mozlis taki uṭia ekkan sulfi ato loila. ");
INSERT INTO syll_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Loia tarar ḳore ḳore gia Boni Israilor hou beṭar tambut hamaia tar ar hou beṭir feṭedi gatilla. Teu Boni Israilor ufor taki Allar gozob horigelo. ");
INSERT INTO syll_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Oile ou gozobor maze sobbish azar manush morigesil. ");
INSERT INTO syll_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Ou shomoy Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Imam Harunor nati Finohosh bin Ali-Azor Boni Israilor ufre taki amar gozob horaise. Boni Israilor maze amar faona ijjot adae ḳorar befare he to amar zalae-u zoler. Erlagi amar faona ijjot adae ḳorar lagi monor zala taḳle-o ami tarare ar marlam na. ");
INSERT INTO syll_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Te oḳon tumi tare ḳo, ami tar lagi eḳṭa ḳas shanti-chukti boail ḳorsi. ");
INSERT INTO syll_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","He tar Allar faona ijjotor befare kiali oia nizor ichchae Boni Israilor gunar kofora adae ḳorae, ami-o tar lagi ou shanti-chukti boail ḳorsi. Erlagi imamotir fod he ar tar aolador maze siroḳal zari roibo.” ");
INSERT INTO syll_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Madiani hou beṭir loge Boni Israilor ze beṭare mara oisil, he oilo Salur fua Zimri, he to Shimion ḳandanor ek gusṭir neta. ");
INSERT INTO syll_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Ar ze Madiani beṭire mara oisil, tair nam Kosbi, tai asil Madian deshor Shur namor eḳ netar fuṛi, ou Shur-o oila ek gusṭir neta. ");
INSERT INTO syll_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Erbade Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Madiani oḳolre tumrar dushmon mono ḳorio, itare zane marilio. ");
INSERT INTO syll_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Ḳaron Piyuror devtar puja ar Kosbir befare fand fataia tumrare bul fote neoae tara tumrar dushmon bonche. Ar tumi to zano, ou Kosbi asil tarar kuṭum, tai to Madiani eḳ shordaror fuṛi. Piyuror Baal devtare puja ḳorae tumrar ufre zebla lannoti gozob lamsil, ou shomoy taire zane mara oisil.” ");
INSERT INTO syll_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Lannoti ou gozob tami zaoar bade Mabude Musa ar imam Harunor fua Ali-Azorre ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Boni Israilor maze zerar boyosh bish bosor ba er beshi, mani zuddo ḳorar zoiggo zera oigese, erare zarzir gusṭi mafik gono.” ");
INSERT INTO syll_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Erlagi Ziriho ṭaunor ulṭabae Zordan gangor faro Muab deshor ze tol zaga ase, hono Musa nobie ar imam Ali-Azore neta oḳolre ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Mabude Musa nobire zela hukum ḳorsoin, oula tumra bish bosor ba er beshi boyoshi hoḳol beṭaintore gono.” Teu Mishor desh taki Boni Israilor zoto beṭain bar oia aisla, gonar shomoy erar bongshodoror nam leḳa oilo. Era oila: ");
INSERT INTO syll_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Iakub urfe Israilor boṛo fua Rubenor sairo fuar bongshodor: Rubenor boṛo fua Honuk taki Honuki bongsho, Falu taki Falui bongsho, ");
INSERT INTO syll_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hasir taki Hasiri bongsho, ar Kormi taki Kormia bongsho. ");
INSERT INTO syll_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Era hoḳol-u Ruben ḳandanor nanan bongsho. Erar maz taki gonia tetallish azar shat-sho tish zonre faoa gelo. ");
INSERT INTO syll_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Falur fuar nam Iliab, ");
INSERT INTO syll_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Iliabor fuain oila Nomuel, Daton ar Abiram. Daton ar Abiram Boni Israilor duizon neta asla, tara Musa ar Harunor bifokke lagla. Ar Kurahor dol zebla Mabudor birudde asil, ou shomoy era-o Kurahor dolo asla. ");
INSERT INTO syll_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Kurahor loge ou duizonre-o maṭie a ḳori gililisil ar tar dolor aṛai-sho zon aguine zolia morsil. Ita Boni Israilor lagi hushiarir nishana oia roilo. ");
INSERT INTO syll_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Oile Kurahor fuain hi shomoy morsoin na, tarar bongsho zari roise. ");
INSERT INTO syll_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Iakubor fua Shimionor bongshodor oila, Nomuel taki Nomueli bongsho, Zamin taki Zamini bongsho, Zakin taki Zakini bongsho, ");
INSERT INTO syll_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zarah taki Zarahi bongsho ar Shoul taki Shouli bongsho. ");
INSERT INTO syll_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Ita Shimion ḳandanor nanan bongsho. Erar maz taki gonia baish azar dui-sho zon faoa gelo. ");
INSERT INTO syll_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Iakubor fua Sadur bongshodor oila, Sifon taki Sifoni bongsho, Hogi taki Hogia bongsho, Shuni taki Shunia bongsho, ");
INSERT INTO syll_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ozni taki Oznia bongsho, Eiri taki Eiria bongsho, ");
INSERT INTO syll_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Orud taki Orudi bongsho, ar Oreli taki Orelia bongsho. ");
INSERT INTO syll_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Era oila Sadu ḳandanor nanan bongsho. Erar maze gona manush oila sallish azar fas-sho zon. ");
INSERT INTO syll_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Iakubor fua Ehudar dui fuar nam asil Eir ar Onon, Kenan desho taḳar ḳalo era mara gesil. ");
INSERT INTO syll_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Oile Ehudar aro fuain asla, erar bongshodor oila, Shela taki Shelayi bongsho, Firuz taki Firuzi, Zarah taki Zarahi bongsho. ");
INSERT INTO syll_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Firuzor bongshodor oila Hasir taki Hasiri bongsho ar Hamul taki Hamuli bongsho. ");
INSERT INTO syll_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Era hoḳol-u Ehuda ḳandanor nanan bongsho. Erar maz taki gonia siottoir azar fas-sho zonre faoa gelo. ");
INSERT INTO syll_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Iakubor fua Isaḳoror bongshodor oila, Tola taki Tolayi bongsho, Foa taki Foai bongsho, ");
INSERT INTO syll_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Zashub taki Zashubi bongsho ar Shimron taki Shimroni bongsho. ");
INSERT INTO syll_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Era hoḳol Isaḳor ḳandanor nanan bongsho. Erar maz taki gonia soushoṭṭi azar tin-sho zonre faoa gelo. ");
INSERT INTO syll_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Iakubor fua Sobulonor bongshodor oila Sered taki Seredi bongsho, Elon taki Eloni bongsho ar Zoholel taki Zoholeli bongsho. ");
INSERT INTO syll_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Era hoḳol Sobulon ḳandanor nanan bongsho. Erar maz taki shaiṭ azar fas-sho zonre faoa gelo. ");
INSERT INTO syll_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Iakubor fua Iusufor fuain oila Manosha ar Afraim. ");
INSERT INTO syll_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Erar maze, Manoshar bongshodor oila, Makir taki Makiri bongsho, ar Makiror fua Giliod taki Giliodi bongsho. ");
INSERT INTO syll_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Giliodor bongshodor oila Iazir taki Iaziri bongsho, Helok taki Heloki bongsho, ");
INSERT INTO syll_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Osriel taki Osrieli bongsho, Sheḳom taki Sheḳomi bongsho, ");
INSERT INTO syll_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Shimida taki Shimidayi bongsho ar Hefor taki Hefori bongsho. ");
INSERT INTO syll_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Heforor fua Zolafḳad, tar kunu fuain asla na, ḳali fuṛin asla. Fuṛintor nam oilo, Mohola, Nua, Hogla, Milka ar Tirza. ");
INSERT INTO syll_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Era hoḳol-u Manosha ḳandanor nanan bongsho. Erar maz taki gonia bayanno azar shat-sho zonre faoa gelo. ");
INSERT INTO syll_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Iakubor fua Afraimor bongshodor oila, Shutoloh taki Shutolohi, Beḳor taki Beḳori ar Tohon taki Tohoni bongsho. ");
INSERT INTO syll_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Shutolohor bongsho, Eron taki Eroni bongsho. ");
INSERT INTO syll_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Era hoḳol Afraim ḳandanor nanan bongsho. Erar maz taki gonia bottish azar fas-sho zonre faoa gelo. Ḳandan hishabe era hoḳol-u Iusufor bongshodor. ");
INSERT INTO syll_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Iakubor fua Bin-Iaminor bongshodor oila, Bela taki Belayi bongsho, Oshbel taki Oshbeli bongsho, Ahiram taki Ahirami bongsho, ");
INSERT INTO syll_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Shufom taki Shufomi bongsho, ar Hufom taki Hufomi bongsho. ");
INSERT INTO syll_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Belar fuain Ord ar Namanor mazdi Belar bongshodor oila, Ord taki Ordi bongsho ar Naman taki Namani bongsho. ");
INSERT INTO syll_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Era Bin-Iamin ḳandanor nanan bongsho. Erar maz taki foytallish azar soy-sho zonre faoa gelo. ");
INSERT INTO syll_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Iakubor fua Danor bongshodor oila, Shuhom taki Shuhomi bongsho. Era-u asla Dan ḳandanor manush. ");
INSERT INTO syll_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Erar maz taki gonia soushoṭṭi azar sair-sho zonre faoa gelo. ");
INSERT INTO syll_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Iakubor fua Ashiror bongshodor oila, Imna taki Imnayi bongsho, Zisbi taki Zisbia bongsho ar Boria taki Boriayi bongsho. ");
INSERT INTO syll_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Boriar bongshodor oila Hebor taki Hebori bongsho, ar Molkiel taki Molkieli bongsho. ");
INSERT INTO syll_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Ashiror fuṛir nam asil Sera. ");
INSERT INTO syll_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Era hoḳol-u Ashir ḳandanor nanan bongsho. Erar maz taki gonia teppanno azar sair-sho zonre faoa gelo. ");
INSERT INTO syll_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Iakubor fua Noftalir bongshodor oila, Zohoshiel taki Zohoshieli bongsho, Guni taki Gunia bongsho, ");
INSERT INTO syll_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Izer taki Izeri bongsho, ar Shillem taki Shillemi bongsho. ");
INSERT INTO syll_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Era hoḳol-u Noftali kandanor nanan bongsho. Erar maz taki gonia foytallish azar sair-sho zonre faoa gelo. ");
INSERT INTO syll_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Te gonar bade Boni Israilor maze zuddot zaoar zuka beṭaintor foriman oilo, muṭ soy laḳ eḳ azar shat-sho tish zon. ");
INSERT INTO syll_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Gona ou manush mafik asta deshor zomin baṭia dite oibo, zate hoḳole zarzir baṭ fae. ");
INSERT INTO syll_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Ze ḳandanor manush beshi ou ḳandanre beshi ar ze ḳandanor manush ḳom, ou ḳandanre ḳom zaga dibae. Fortek kandanor manshe tar manush hishabe zaga-zomin faibo. ");
INSERT INTO syll_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Ar kun ḳandane kun zagat zomin faibo, ita loṭari maria ṭik kora oibo. Forteḳ bongshor faona ongsho tar ḳandanor name deoa elaḳar maze-u taḳbo. ");
INSERT INTO syll_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Ḳandanor manush ḳom ba beshi zeṭa-u ouk, loṭari maria zaga ṭik kora oibo.” ");
INSERT INTO syll_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Hoḳol heshe Lebi kandanor bongshodor gona oilo. Era oila, Zarsun taki Zarsuni gusṭi, Kahat taki Kahati gusṭi ar Marari taki Mararia gusṭi. ");
INSERT INTO syll_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Lebi kandanor kisu namḳora foribar asil, erar mul bafor nam oilo Libni, Hebron, Moholi, Mushi ar Kurah. Kahator eḳ fuar nam asil Imran. ");
INSERT INTO syll_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Imranor bour nam Iukabez, Mishor desho taḳte Lebi kandanor maze en zonom oisil. En feṭ taki Imranor fuain Harun ar Musa ar tarar boin Moriomor zonom oisil. ");
INSERT INTO syll_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Harunor fuain oila Nadab, Abihu, Ali-Azor ar Isamar. ");
INSERT INTO syll_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Oile Mabudor hukum bangia dusra aguin dia ebadot ḳorat gia Nadab ar Abihu ou dui zonor moron oisil. ");
INSERT INTO syll_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Eḳ mash ba er beshi boyoshor Lebi kandanor beṭaintor foriman asil teish azar. Boni Israilor bitre erare kunu zagar malikana deoa oise na gotike Boni Israilor oinnainno ḳandanor loge erare eḳloge gona-o oise na. ");
INSERT INTO syll_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Ziriho ṭaunor ulṭabae Zordan gangor daro Muabor tol zagat dusrabar manush gonar shomoy Musa nobi ar imam Ali-Azore Boni Israilre gonla. ");
INSERT INTO syll_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Oile foyla bar Sinai morubumit Musa ar imam Harune Boni Israilor zarare gonisla, ou dusrabar gonar shomoy erar mazor eḳzon-o zinda roisoin na. ");
INSERT INTO syll_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Ashole ota Boni Israilor befare Mabude age-u ḳoisla, tara nichchoy ou morubumit mara zaiba. Ar hasau ḳali Zifunnir fua Kalut ar Nunor fua Iusa saṛa tarar mazor dusra ḳeu zinda roisil na. ");
INSERT INTO syll_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Iusufor fua Manoshar ḳandanor Zolafḳador fuṛintor silsila oilo, Manoshar fua Makir, Makiror fua Giliod, Giliodor fua Hefor ar Heforor fuar nam Zolafḳad. Zolafḳador fuṛin oila Mohola, Nua, Hogla, Milka ar Tirza. ");
INSERT INTO syll_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Ou fuṛin aia Milon-tambur duaror samne ubaia Musa nobi, imam Ali-Azor, murobbi neta ar hoḳol Boni Israilre ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Amrar baba to morubumit mara gesoin. Ar Kurahor dolor zeta manshe Mabudor birudde naformani korsla, tain to itar loge asla na. Tain ḳali tan nizor gunar dae mara gesoin. Ar amrar kunu bai zonmisoin na, ");
INSERT INTO syll_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","te bai na taḳae oḳon amrar bafor nam kita i bongsho taki miṭizito ni? Tan shoriḳanor loge amrare-o zaga-zominor baṭ deukka.” ");
INSERT INTO syll_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Teu Musa nobie tarar befare Mabudor dorbaro aroz ḳorla. ");
INSERT INTO syll_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Mabude tanre zuaf dila, ");
INSERT INTO syll_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Zolafḳador fuṛinte ṭik kota-u ḳoise. Tarar bafor shoriḳanor loge tarare-o zomi-zomar baṭ dite oibo. Tara zate tarar bafaiti zomin fain, ikan tumi kial rakio. ");
INSERT INTO syll_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Ar tumi Boni Israilre ḳo, morar ḳalo zudi kunu manshe fuain na toia morizae, te tar zomi-zomar baṭ tar fuṛinte faiba. ");
INSERT INTO syll_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Tar kunu fuṛin na taḳle tar baiainte i shompotti faiba. ");
INSERT INTO syll_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Tar zudi kunu bai na taḳe, te ita tar sasainte faiba. ");
INSERT INTO syll_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Ar tar zudi kunu sasa-o na taḳoin, te tar bongshor hoḳol taki afon zone i shompotti faiba, ein itar malik oiba. Musa nobire batail Mabudor ou hukum oilo, Boni Israilor lagi zomi-zomar ainor eḳ dara.” ");
INSERT INTO syll_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Erbade Mabude Musare ḳoila, “Tumi Abarim faṛor ou usa ṭillar ufre uṭo, uṭia ami Boni Israilre ze desh disi, oḳan dekilao. ");
INSERT INTO syll_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Ar huno, tumar bai Harun zela tar baf-dadar laḳan ḳoyboro huti roise, ou desh deḳar bade tumi-o ola tumar baf-dadar gese zaibaegi. ");
INSERT INTO syll_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Mono ase ni, Zin morubumir Kadesh elaḳar Meriba namor zagar hou fanir ḳota? Morubumit Boni Israile zebla fanir lagi amar birudita ḳorsil, tarar samne tumra-o amare fak-fobitro ḳoia na mania amar hukumor ulṭa geslae.” ");
INSERT INTO syll_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Oḳan hunia Musae aroz ḳorla, ");
INSERT INTO syll_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“O Mabud, zein hoḳol manshor zindegi dan ḳoroin, hou Alla Mabude Boni Israilor ufre ola eḳzon manshore boail ḳoroukka, ");
INSERT INTO syll_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ze netae hoḳol manshore gore-bare, maṭo-moydano hoḳol befare salaiba. Teu Mabudor bonda oḳol a-raḳali goru-sagolor laḳan oita nae.” ");
INSERT INTO syll_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Teu Mabude zuaf dila, “Nunor fut Iusar bitre to Allai ruhu asoin. Tumi tare ania tar ufre tumar at toia ḳelafoti boḳshia deo. ");
INSERT INTO syll_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Tumi imam Ali-Azor ar hoḳol Boni Israilor samne tare azir ḳoria, tarar samne-u tare dayitto shomzai deo. ");
INSERT INTO syll_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Tumare ze ḳemota deoa oise, ou ḳemotar kisu baṭ tare deo, teu hokkol Boni Israil tar ḳotae solba. ");
INSERT INTO syll_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Bade he imam Ali-Azoror gese zaibo, gele Ali-Azore Allar fobitro Urim ar Tummim fattordi loṭari maria Mabudor morzi zanta farba. Ola Iusa ar tamam Boni Israile sola-fira ḳorba.” ");
INSERT INTO syll_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Musa nobie Mabudor hukum mafik kam ḳorla. Tain imam Ali-Azor ar Boni Israilor samne Iusare nia azir ḳorla. ");
INSERT INTO syll_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Ar Mabudor hukum mafik tan ufre at toia tanre dayitto shomzaila. ");
INSERT INTO syll_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Mabude Musa nobire ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Tumi Boni Israilre amar ou hukum zanai deo, amare kushi korar niote geran ala zalail kurbani amar ḳanir lagi shoṭik shomoye azir ḳorte oibo. ");
INSERT INTO syll_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Tarare eoḳan ḳo, tumra Mabudor name fortidinor agunit deoa kurbani adae ḳorar niote ou foshu oḳol anio, fortidin eḳ bosor boyoshi dugu nikut meṛa-baichcha anio. ");
INSERT INTO syll_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Ania egu biane ar egu hainja bala kurbani dibae. ");
INSERT INTO syll_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Erlogor fortidinor dan-gomor sodgar lagi dui sher moyda ar eḳ sher zoytunor fisha tel anbae. ");
INSERT INTO syll_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Iṭa oilo hou fortidinor zalail kurbani, zeta Tur faṛo shaibosto ḳora oisil. Ar ita to amar name agunit deoa kurbani, er dumar gerane ami kushi oi. ");
INSERT INTO syll_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Forteḳ meṛar loge eḳ sher anguror shorbot dia shorbot-fanir sodga adae ḳorio. Mabudor namor kurbanir ou shorbot ebadot ḳanar uṭano ḍali dibae. ");
INSERT INTO syll_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Meṛar aroḳ baichchare hainja bala kurbani dibae. Erloge biankur laḳan dan-gomor sodga ar shorbot-fanir sodga adae ḳorbae. Ita oilo agunit deoa kurbani, er dumar gerane ami Mabud kushi oi. ");
INSERT INTO syll_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“Forteḳ Zummabare eḳ bosor boyoshi dugu meṛa-baichcha kurbani dibae. Erloge shorbot-fanir sodgar samana ar dan-gomor sodgar tel maḳail sair sher moyda-o dibae. ");
INSERT INTO syll_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Fortidinor zalail foshu kurbani ar er logor shorbot-fanir sodga saṛa-o forteḳ Zummabare ou zalail kurbani adae ḳorbae. ");
INSERT INTO syll_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“Forteḳ sandor foyla din Mabudor name zalail kurbanir lagi dugu bisal, egu meṛa ar eḳ bosor boyoshi shatgu meṛa-baichcha kurbani dibae, i hoḳol foshu fura nikut oito. ");
INSERT INTO syll_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Ou forteḳ bisalor loge dan-gomor sodga hishabe tel maḳail soy sher moyda dibae, ar meṛar loge sair sher moyda dio, ");
INSERT INTO syll_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ar forteḳ meṛa-baichchar loge tel maḳail dui sher moyda dio. Ita oilo amar name agunit deoa kurbani, itar dumar gerane ami Mabud kushi oi. ");
INSERT INTO syll_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Shorbot-fanir sodgar lagi forteḳ bisalor loge dui sher anguror shorbot dibae. Forteḳ meṛar loge shua sher ar forteḳ meṛa-baichchar loge eḳ sher shorbot dio. Ita oilo mashik zalail kurbani, bosoror forteḳ sando ita adae ḳorbae. ");
INSERT INTO syll_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Itar loge gunar koforar niote amar name egu sagol kurbani dio. Ta-o forteḳ dinor zalail kurbani, ar er logor shorbot-fanir sodga-o adae ḳorio. ");
INSERT INTO syll_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“Forteḳ bosoror foyla sandor souddo tarik Mabudor name Azadi Id adae ḳorio. ");
INSERT INTO syll_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Ou sandor fonro tarik taki shat din bora aroḳ id adae ḳorio, ikṭar nam Ḳamir Saṛa Ruṭir Id. ");
INSERT INTO syll_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Er foyla din fobitro milon-mahfil ḳorio, i din duniabi niote kunu ḳam-ḳaz ḳora nazaiz. ");
INSERT INTO syll_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Ou din amar name dugu bisal, egu meṛa ar eḳ bosor boyoshi shatgu meṛa-baichchadi agunit deoa zalail kurbani adae ḳorio. Kurbanir forteḳ foshu nikut oite oibo. ");
INSERT INTO syll_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Ou foshur logor dan-gomor sodga hishabe tel maḳail moyda dibae, eḳoṭa bisalor loge soy sher, meṛa faṭar loge sair sher, ");
INSERT INTO syll_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ar meṛa-baichchar loge dui sher dibae. ");
INSERT INTO syll_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Itar loge tumrar gunar koforar lagi egu faṭa sagol-o kurbani dio. ");
INSERT INTO syll_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Forteḳ dinor biankur zalail kurbani to dibae-u, erloge ou kurbani-o adae ḳorbae. ");
INSERT INTO syll_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Ou laḳan fura haftar shatodin amare kushi korar geran ala ḳani hishabe forteḳ din ou agunit deoa kurbani adae ḳorbae. Fortidinor zalail kurbani ar er logor shorbot-fanir sodgar loge ou kurbani-o adae ḳorbae. ");
INSERT INTO syll_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Heshe shat nombor din-o tumra fobitro milon-mahfil ḳorio, ou din duniabi niote kunu ḳam-ḳaz ḳora nazaiz. ");
INSERT INTO syll_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“Fonchaisha Idor din, mani ketor foyla daoa foshol dia zedin tumra amar name fobitro milon-mahfil ḳorbae, hi din kunu duniabi niote ḳam ḳorio na. ");
INSERT INTO syll_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Ou din tumra dugu bisal, egu meṛa ar eḳ bosor boyoshi shatgu meṛa-baichcha dia zalail kurbani adae ḳorio, ou kurbanir dumar gerane ami Mabud kushi oi. ");
INSERT INTO syll_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Ar otar logor dan-gomor sodga hishabe eḳoṭa bisalor loge tel maḳail soy sher moyda, meṛar loge sair sher, ");
INSERT INTO syll_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ar meṛa-baichchar loge dui sher dibae. ");
INSERT INTO syll_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Otar loge egu faṭa sagol-o kurbani dio tumrar gunar koforar lagi. ");
INSERT INTO syll_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Ou hoḳol kurbani ar itar logor shorbot-fanir sodgar loge fortidinor zalail kurbani ar er logor dan-gomor sodga adae ḳorbae. Kial rakio, kurbanir hoḳol foshu zanu furafur nikut oy. ");
INSERT INTO syll_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Mabude aro ḳoira, “Forteḳ bosoror shat nombor sandor foyla din oilo, tumrar Shinga Bazanir Idor din. Ou din tumra fobitro milon-mahfil ḳorio. I din duniabi niote kunu ḳam-ḳaz ḳora nazaiz. ");
INSERT INTO syll_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Ou din tumra amare kushi korar geran ala zalail kurbani hishabe, egu bisal, egu meṛa ar shatgu eḳ bosor boyoshi meṛa-baichchare kurbani dio, hoḳol foshu zanu furafur nikut oy. ");
INSERT INTO syll_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Ar otar logor dan-gomor sodga hishabe tel maḳail moyda dio. Bisalor loge soy sher, meṛar loge sair sher, ");
INSERT INTO syll_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ar forteḳ meṛa-baichchar loge dui sher dibae. ");
INSERT INTO syll_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Itar loge tumrar gunar koforar lagi egu faṭa sagol-o kurbani dibae. ");
INSERT INTO syll_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Forteḳ sandor ar forti dinor zalail kurbani, itar logor dan-gomor sodga ar shorbot-fanir sodga saṛa-o ou kurbani oḳol adae ḳorio. Ita to amar name agunit deoa kurbani, itar dumar gerane ami Mabud kushi oi. ");
INSERT INTO syll_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“Ar ou shat nombor sandor dosh tariko eḳṭa fobitro milon-mahfil ḳorbae. Ou din tumra forteḳe noto oia zarzir dil shofia dibae, i din ḳeu kunuzat ḳam ḳorio na. ");
INSERT INTO syll_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Ami Mabudre kushi korar niote geran ala zalail kurbani hishabe nikut egu bisal, egu meṛa, ar shatgu eḳ bosor boyoshi meṛa-baichchare kurbani dio. ");
INSERT INTO syll_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Ar otar logor dan-gomor sodga hishabe bisalor loge tel maḳail soy sher moyda dio, meṛar loge sair sher, ");
INSERT INTO syll_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ar forteḳ meṛa-baichchar loge dui sher dibae. ");
INSERT INTO syll_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Heshe guna mafir kurbanir lagi egu faṭa sagol-o dibae. Idor ou kurbani oḳol saṛa-o gunar koforar kurbani ar forti dinor zalail kurbani, er logor dan-gomor sodga ar shorbot-fanir sodga-o dio. ");
INSERT INTO syll_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“Tumra Ḍera-goror Idor haftar foyla din mani, shat nombor sandor fonro tariko, eḳṭa fobitro milon-mahfil ḳorbae, ou din tumra duniabi niote kunu ḳam-ḳaz ḳorio na. Ou shat din Mabudor name idor kushi-bashi korio. ");
INSERT INTO syll_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","“Idor foyla din furafur nikut terogu bisal, dugu meṛa ar souddogu eḳ bosor boyoshi meṛa-baichcha dia zalail kurbani adae ḳorio. Er dumar gerane ami Mabud kushi oi. ");
INSERT INTO syll_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Otar forteḳ bisalor logor dan-gomor sodga hishabe tel maḳail soy sher moyda, forteḳ meṛar loge sair sher, ");
INSERT INTO syll_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ar forteḳ meṛa-baichchar loge dui sher dibae. ");
INSERT INTO syll_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Heshe guna mafir kurbanir lagi egu faṭa sagol-o dibae. Dia forti dinor zalail kurbani, er logor dan-gomor sodga ar shorbot-fanir sodga-o dibae. ");
INSERT INTO syll_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“Idor dui nombor din furafur nikut barogu bisal, dugu meṛa ar souddogu eḳ bosor boyoshi meṛa-baichcha kurbani dibae. ");
INSERT INTO syll_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Ou bisal, meṛa ar meṛa-baichcha hokkolṭir loge dan-gomor sodga, shorbot-fanir sodga, foshur foriman mafik adae ḳorio. ");
INSERT INTO syll_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Heshe guna mafir kurbanir lagi egu faṭa sagol-o dibae. Dia forti dinor zalail kurbani, er logor dan-gomor sodga ar shorbot-fanir sodga-o dibae. ");
INSERT INTO syll_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“Idor tin nombor dino furafur nikut egarogu bisal, dugu meṛa ar souddogu eḳ bosor boyoshi meṛa-baichcha kurbani dibae. ");
INSERT INTO syll_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Ou bisal, meṛa ar meṛa-baichcha hokkolṭir loge dan-gomor sodga, shorbot-fanir sodga, foshur foriman mafik adae ḳorio. ");
INSERT INTO syll_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Heshe guna mafir kurbanir lagi egu faṭa sagol-o dibae. Dia forti dinor zalail kurbani, er logor dan-gomor sodga ar shorbot-fanir sodga-o dibae. ");
INSERT INTO syll_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“Idor sair nombor din furafur nikut doshgu bisal, dugu meṛa ar souddogu eḳ bosor boyoshi meṛa-baichcha kurbani dibae. ");
INSERT INTO syll_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Ou bisal, meṛa ar meṛa-baichcha hokkolṭir loge dan-gomor sodga, shorbot-fanir sodga, foshur foriman mafik adae ḳorio. ");
INSERT INTO syll_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Heshe guna mafir kurbanir lagi egu faṭa sagol-o dibae. Dia forti dinor zalail kurbani, er logor dan-gomor sodga ar shorbot-fanir sodga-o dibae. ");
INSERT INTO syll_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“Idor fas nombor din nikut noygu bisal, dugu meṛa ar souddogu eḳ bosor boyoshi meṛa-baichcha kurbani dibae. ");
INSERT INTO syll_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Ou bisal, meṛa ar meṛa-baichcha hokkolṭir loge dan-gomor sodga, shorbot-fanir sodga, foshur foriman mafik adae ḳorio. ");
INSERT INTO syll_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Heshe guna mafir kurbanir lagi egu faṭa sagol-o dibae. Dia forti dinor zalail kurbani, er logor dan-gomor sodga ar shorbot-fanir sodga-o dibae. ");
INSERT INTO syll_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“Idor soy nombor din nikut aṭgu bisal, dugu meṛa ar souddogu eḳ bosor boyoshi meṛa-baichcha kurbani dio. ");
INSERT INTO syll_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Ou bisal, meṛa ar meṛa-baichcha hokkolṭir loge dan-gomor sodga, shorbot-fanir sodga, foshur foriman mafik adae ḳorio. ");
INSERT INTO syll_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Heshe guna mafir kurbanir lagi egu faṭa sagol-o dibae. Dia forti dinor zalail kurbani, er logor dan-gomor sodga ar shorbot-fanir sodga-o dibae. ");
INSERT INTO syll_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“Idor shat nombor din furafur nikut shatgu bisal, dugu meṛa ar souddogu eḳ bosor boyoshi meṛa-baichcha kurbani dibae. ");
INSERT INTO syll_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Ou bisal, meṛa ar meṛa-baichcha hokkolṭir loge dan-gomor sodga, shorbot-fanir sodga, foshur foriman mafik adae ḳorio. ");
INSERT INTO syll_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Heshe guna mafir kurbanir lagi egu faṭa sagol-o dibae. Dia forti dinor zalail kurbani, er logor dan-gomor sodga ar shorbot-fanir sodga-o dibae. ");
INSERT INTO syll_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“Idor aṭ nombor din mani, aḳeri din bidayi mahfil ḳorio, i din tumra duniabi niote kunu ḳam-ḳaz ḳorio na. ");
INSERT INTO syll_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Ar Mabudre kushi korar niote geran ala agunit deoa kurbani hishabe ekkan zalail kurbani dibae. Erlagi nikut egu bisal, egu meṛa ar shatgu eḳ bosor boyoshi meṛa-baichcha kurbani dio. ");
INSERT INTO syll_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Ou bisal, meṛa ar meṛa-baichcha hokkolṭir loge dan-gomor sodga, shorbot-fanir sodga, foshur foriman mafik adae ḳorio. ");
INSERT INTO syll_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Heshe guna mafir kurbanir lagi egu faṭa sagol-o dibae. Dia forti dinor zalail kurbani, er logor dan-gomor sodga ar shorbot-fanir sodga-o dibae. ");
INSERT INTO syll_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“Te forteḳ idor ḳalo Mabudor name tumrar id oḳlor niom mafik kurbani adae ḳorio. Ita saṛa, mannot furonor kurbani, zekunu nofol kurbanir niote zalail kurbani, dan-gomor sodga, shorbot-fanir sodga, ar salamoti kurbani-o adae ḳorio.” ");
INSERT INTO syll_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Mabude Musa nobire zeta hukum-ahkam zanaisla, tain ita hokkolta Boni Israilre zanaila. ");
INSERT INTO syll_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Bade Musa nobie Boni Israilor hoḳol ḳandanor murobbire ḳoila, “Mabude hukum disoin, ");
INSERT INTO syll_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","kunu beṭae zudi Mabudor name kunta mannot ḳore ba ḳosom ḳaia kunuta ḳorar oadae bondi oy, te he zanu tar oada bongo na ḳore. He zeta ḳoise, ita furon ḳora lagbo. ");
INSERT INTO syll_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Kunu abiati fuṛie zudi bafor baṛit taḳar ḳalo Mabudor name kunta mannot ḳore ba kunuta ḳorar oadae bondi oy, ");
INSERT INTO syll_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","ar bafe ita hunia-o fuṛire kunta na ḳoin, te i mannot ba oada tai furon ḳora lagbo. ");
INSERT INTO syll_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Oile ikan hunar loge loge bafe zudi fuṛire ita ḳorte nished ḳoroin, te i mannot ba oada batil oizibo. Bafe nished ḳorae Mabude-o i mannot ba oada bangare maf ḳori diba. ");
INSERT INTO syll_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Ar kunu fuṛie zudi sinta-babna na ḳoria aḳta kunu mannot ba oada ḳorilae ar bade tair bia oizae, ");
INSERT INTO syll_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","biar bade zamaie ikan hunia loge loge kunta na ḳoin, te i mannot ba oadare tai furon ḳora lagbo. ");
INSERT INTO syll_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Oile ita hunar loge loge zamaie zudi nished ḳoroin, te i mannot ba oadar bandon taki tai kalas faibo, Mabude-o ita maf ḳori diba. ");
INSERT INTO syll_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Ar kunu ṛaṛi beṭi ba talaḳ faoa kunu beṭie zudi mannot ḳoria oadae bondi oy, te ita furon ḳora lagbo-u. ");
INSERT INTO syll_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Zamair goror kunu boue zudi ola mannot mane ba ḳosom ḳaia oadae bondi oy, ");
INSERT INTO syll_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","bade tair zamaie ikan hunia kunta na matoin, taire nished na dein, te tai ita furon ḳora lagbo. ");
INSERT INTO syll_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Oile zamaie hunia zudi loge loge nished dein, te i mannot ba oada batil oizibo. Tair zamaie nished ḳorae, Mabude-o ikan maf ḳori diba. ");
INSERT INTO syll_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Boue ḳosom ḳaia oada ḳorle ba kunu mannot manle zamair eḳtiar ase ita mana ba batil ḳorar. ");
INSERT INTO syll_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Oile zamaie zudi beshi din i befare kunta na matia nirai roin, te tar bour mannot ba oadar bandon fakka oizae. Hoḳolta hunar bade-o zamai ou shomoy nirai roae bour mannot ba oadare fakka banailae. ");
INSERT INTO syll_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Oile hoḳolta hunar bade zamaie zudi hou dinor maze kunta na matia shomoy faronir bade nished ḳore, te boue ou mannot fura na ḳorae er dae-bar tair zamair ufre foṛbo.” ");
INSERT INTO syll_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Zamai-bour befare, baf ar bafor baṛit roura fuṛir befare Mabude Musa nobire ola ain hikai dila. ");
INSERT INTO syll_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Mabude Musa nobire ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Madiani oḳole Boni Israilor loge zeta ḳorse, tumi otar oforador bodla deo. Erbade tumi tumar baf-dadar gese siroḳalor lagi huti roibae.” ");
INSERT INTO syll_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Teu Musae Boni Israilre ḳoila, “Madiani oḳlor loge zuddo ḳorar lagi tumrar kisu sifaire zuit ḳoro, tara Mabudor torof taki Madiani oḳlor faona shaza diba. ");
INSERT INTO syll_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Oḳon tumra Boni Israilor fortek kandan taki eḳ azar ḳori sifaire zuddot faṭao.” ");
INSERT INTO syll_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Teu Boni Israilor baro ḳandan taki eḳo azar ḳori muṭ baro azar sifaire zuddor lagi zuit ḳora oilo. ");
INSERT INTO syll_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Musae fortek kandan taki eḳ azar zon sifaire zuddot faṭaila. Erar loge imam Ali-Azoror fua Finohosh-o gela, zaite fobitro Kaba goror kisu samana loge ḳori nila ar tan ato ḳori zuddor aoazor sunga oḳol-o nila. ");
INSERT INTO syll_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Musa nobire deoa Mabudor hukum mafik tara Madiani oḳlor loge zuddo ḳoria otar hoḳol beṭaintore marilila. ");
INSERT INTO syll_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Shadaron manshor loge Madiani oḳlor fas zon bashshare-o tara marilila. Ou bashshain oila, Ibi, Reḳom, Shur, Hur ar Reba. Ar erar loge Balam bin Baur namor hou pirre-o tara zane marilila. ");
INSERT INTO syll_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Tara Madian deshor hoḳol beṭin ar huruttainre bondi korla, tarar goru-sagol ar hokkol mal-samana luṭia anilla. ");
INSERT INTO syll_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Madiani oḳol zoto ṭauno boshot ḳorta, ou ṭaun oḳol ar ṭaunor baror hoḳol tambu tara aguindi zalailila. ");
INSERT INTO syll_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Zuddor bade tarar bondi kora hoḳol manush, gonimotor mal-samana, ar foshur fal loia roana oila. ");
INSERT INTO syll_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Tara Musa nobi, imam Ali-Azor ar Boni Israilor kempo firar niote roana dila. Ou shomoy tarar tambu asil Ziriho elaḳar Zordan gangor daro Muab deshor tol zagat. ");
INSERT INTO syll_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Tarar ḳobor faia Musa nobi, imam Ali-Azor ar Boni Israilor hoḳol murobbi kemp taki bar oia tarar loge deḳa ḳorat gela. ");
INSERT INTO syll_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Gia zuddo taki firot aoa hoḳol kamanḍaror ufre mani azar sifair ar sho-sifair kamanḍar oḳlor ufre Musae kub gorom oia ");
INSERT INTO syll_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","ḳoila, “Tumra dushmonor hoḳol beṭintore zinda raḳlae ḳene? ");
INSERT INTO syll_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Mono nai ni, oguinte Piyur faṛor ufre Balam piror foramishe, Boni Israilre Mabudor ges taki duroi horaisil, erlagi to Mabudor bonda oḳlor ufre gozobi bemar nazil oisil. ");
INSERT INTO syll_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Te oḳon tumra otar hoḳol fuaintore zane marilao, biati ba oshoti hoḳol beṭintore-o marilao. ");
INSERT INTO syll_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Ḳali abiati shoti fuṛintore tumrar lagi zita rakio. ");
INSERT INTO syll_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Ar tumra zera kunu manshore zane marso ba murdar lash soiso, tumra shatdin bora kempor bare roio. Ermaze tin nombor ar shat nombor din tumra nize ar bondi kori ana manshore-o fak-saf ḳorbae. ");
INSERT INTO syll_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Tumrar hoḳol ḳafoṛ-sufoṛ, samṛar mal-samana, laḳṛi ar sagolor rumadi banail hokkol samanare-o fak-saf ḳorbae.” ");
INSERT INTO syll_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Zeta sifai oḳol zuddot gesla, imam Ali-Azore tarare ḳoila, “Ita oilo Musa nobir ate deoa Mabudor shoriotor ekkan ain: ");
INSERT INTO syll_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Tumra shuna, rufa, fitol, lua, ṭin, shishadi banail hoḳol mal-samana, ");
INSERT INTO syll_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","mani zeta mal agunit dile zole na, ita hoḳolta agunir maze dibae, teu ita fak-saf oibo. Oile zalanir bade itare fak-saf ḳorar fanidi doia pak-pakiza ḳora lagbo. Ar zeta aguine nosṭo oizae, itare ḳali fak-saf ḳorar fanidi doilibae. ");
INSERT INTO syll_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Bade shat nombor din tumrar ḳafoṛ-sufoṛ doia harle, pak-pakiza bonia kempor bitre hamaibae.” ");
INSERT INTO syll_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Erbade Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Tumi ar imam Ali-Azor ar shomazor murobbi oḳole milia, bondi kori ana hoḳol manush ar foshuintore gono. ");
INSERT INTO syll_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Gonia hoḳol mal dui baṭ ḳoro. Itar eḳ baṭ dibae zuddot zeta sifai oḳol gesil tarare, ar dusra baṭ bad-baki manshore dio. ");
INSERT INTO syll_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Ou sifai oḳlor baṭo zoto manush, goru-sagol foṛbo, itar forteḳ fas-shoṭa taki eḳṭare Mabudor lagi algai toio. ");
INSERT INTO syll_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Algaia Mabudor faona ou baṭre tumi imam Ali-Azoror ato dibae. ");
INSERT INTO syll_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Ar Boni Israilor baṭo zeta manush, goru-sagol faiba, itar forteḳ foinchashṭa taki eḳṭare alog kori toio. Toia Allar boshot ḳana, Baytulla tambur ḳadim Lebi oḳlor ato ita shomzaio.” ");
INSERT INTO syll_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Mabude Musare zela hukum disla, tain ar imam Ali-Azore ola-u ḳorla. ");
INSERT INTO syll_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Sifai oḳole zitia ana gonimotor mal-samana saṛa-o aro asil, soy laḳ fosottoir azar meṛa ar sagol, ");
INSERT INTO syll_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","baottoir azar goru, ");
INSERT INTO syll_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","eḳshoṭṭi azar gada ");
INSERT INTO syll_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","ar bottish azar abiati shoti fuṛin. ");
INSERT INTO syll_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Teu zuddo ḳorra sifai oḳlor baṭo foṛlo, tin laḳ shaṛtish azar fas-shoṭa meṛa ar sagol, ");
INSERT INTO syll_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ita taki Mabudor faona baṭo foṛlo, soy-sho fosottoirgu sagol-meṛa. ");
INSERT INTO syll_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Ar goru asil soytish azar, ita taki Mabudor baṭo foṛlo baottoirṭa. ");
INSERT INTO syll_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Ermaze gada asil tish azar fas-shoṭa, ita taki Mabudor baṭo foṛlo eḳshoṭṭigu. ");
INSERT INTO syll_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Ar abiati shoti fuṛin asla shullo azar, ita taki Mabudor baṭo foṛlo bottishṭa. ");
INSERT INTO syll_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Mabude Musa nobire zela hukum disla, tain Mabudor faona baṭ nia imam Ali-Azoror ato ola shomzai dila. ");
INSERT INTO syll_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Ar Musae Boni Israilor bad-baki manshor lagi ze baṭ sifai oḳlor ges taki nisla, ");
INSERT INTO syll_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","i baṭo tin laḳ shaṛtish azar fas-shogu meṛa ar sagol, ");
INSERT INTO syll_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","soytish azar goru, ");
INSERT INTO syll_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","tish azar fas-shoṭa gada, ");
INSERT INTO syll_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","ar shullo azar abiati shoti fuṛin asla. ");
INSERT INTO syll_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Bade Mabudor hukum mafik Musa nobie Boni Israilor faoa baṭor, forteḳ foinchash zon abiati fuṛin ar foshuin taki-o, egu ḳori fuṛi ar foshu nia Lebi kandanor manshore dila, zerar ufre Mabudor Kaba goror deḳa-hunar zimmadari asil. ");
INSERT INTO syll_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Erbade sifai dolor azar sifair ar sho-sifair kamanḍar oḳol Musar gese aila, ");
INSERT INTO syll_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","aia ḳoila, “Afnar i gulam oḳole amrar zimmae taḳa sifai oḳolre gonilam. Gonia deḳlam, tara hoḳol fura asoin, zuddot ḳeu morse na. ");
INSERT INTO syll_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Erlagi amra forteḳor baṭo zeta shunar bazu, bala, ator angṭi, ḳanor dul ar golar har faisi, amra ita hoḳolta loia aisi. Amrar zanor koforar kurbani hishabe ota Mabudor dorbaro dilaitam.” ");
INSERT INTO syll_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Teu Musa ar imam Ali-Azore tarar ges taki shunar hoḳol goyna shomzia faila. ");
INSERT INTO syll_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Tara azar sifair ar sho-sifair kamanḍar oḳlor ges taki Mabudor name deoa ze shunar goyna shomzia faila, itar uzon asil shullo azar shat-sho foinchash tola. ");
INSERT INTO syll_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","54","Musa nobi ar imam Ali-Azore azar sifai ar sho-sifair kamanḍar oḳlor ges taki ou shuna oḳol shomzia raḳla. Rakia Mabudor samne Boni Israilor iadgarir nishana hishabe ota shuna oḳol Kaba goror bitre toila. Ita saṛa-o sifai oḳole gonimotor aro mal-samana zarzir gese raḳsila. ");
INSERT INTO syll_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Ruben ar Sadu ḳandanor manshor goru-sagolor boṛo boṛo fal asil. Tara deḳla, Zazira ar Giliod elaḳa foshu falibar lagi kub bala zaga. ");
INSERT INTO syll_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Teu tara Musa nobi, imam Ali-Azor ar Boni Israilor fordan murobbi oḳolre ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","“Afnaintor i gulam oḳole to goru-sagol fali. Ar amrar Mabude Oṭarut, Diban, Zazira, Nimra, Hishbon, Iliali, Sebam, Nobo ar Biun namor zeta zaga Boni Israilor doḳolo anchoin, ita to foshu falibar lagi kub bala zaga. ");
INSERT INTO syll_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Oḳon afne zudi amrare doya ḳoroin, te ou zaga ḳanain afnar i gulam oḳolre dilaukka. Amrare Zordan gangor hifaro nein na zanu.” ");
INSERT INTO syll_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Musa nobie tarare zuaf dila, “Tumrar baiain zuddo ḳorat zaiba, ar tumra ono boi roibae ni? ");
INSERT INTO syll_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Mabude Boni Israilre ze zaga ḳanain disoin, hino zaite tumra ḳene tarar monobol bangi dirae? ");
INSERT INTO syll_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Huno, age zebla ou desh deḳar lagi tumrar baf-dadainre ami Kadesh-Bornea taki faṭaislam, hou shomoy tara-o ola ḳorsla. ");
INSERT INTO syll_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Tara Boni Israilor lagi Mabudor dan ḳora desh deḳat gesil, gia Ashkulor faṛia ḳal forzonto deḳsil, dekia aia hou desho zaite erar monobol bangi disil. ");
INSERT INTO syll_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Erlagi hou din gusae aguin oia Mabude ḳosom ḳaia ḳoisla, ");
INSERT INTO syll_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","ami Mabude ze desh dibar lagi Ibrahim, Isʼhak ar Iakubor gese ḳosom ḳaislam, Mishor taki bar oia aoa manshor maze bish bosor ba er beshi boyoshi kunu zone i desh deḳar shuzug faita nae, ḳenena tara amar ḳota furafur shullo-ana manche na. ");
INSERT INTO syll_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Ḳali Konizi Zifunnir fua Kalut ar Nunor fut Iusae ou desh deḳar shuzug faiba. Tara to amar ḳotare shullo-ana manche. ");
INSERT INTO syll_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Hou shomoy Mabude Boni Israilor ufre gusae aguin oigesla, erlagi tan nozoro naformani korra ota manshor binash na oa forzonto, sallish bosor dori morubumir nanan zagat itare sokkor deoaila. ");
INSERT INTO syll_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“Ar hou gunagar oḳlor aolad oae, oḳon tumra-o zarzir baf-dadar ḳaislot faiso, erlagi Boni Israilor ufre Mabudor gusar aguinre aro baṛairae. ");
INSERT INTO syll_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Oḳon tumra zudi tan hukum mafik na solo, te tain hirbar ota manshore morubumit falai toiba, tan i lannotor ḳaron oibae tumra-u.” ");
INSERT INTO syll_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Ita hunia tara Musar daro biṛia ḳoila, “Sab, amra to ḳali foshur fal raḳar zaga banani ar amrar bou-baichchare toar lagi ono ṭaun oḳol bananir izazot saisi. ");
INSERT INTO syll_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Oile Boni Israilre nizor zagat na fosani forzonto amra zuddor sifair laḳan tarar age age zaimu. Ermaze amrar bou-baichchain baunḍori kora ou ṭauno roile, ota deshor manshor at taki tara nirafode roiba. ");
INSERT INTO syll_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Hokkol Boni Israilre zarzir zomi-mirash na shomzani forzonto amra nizor goro firia aitam nae. ");
INSERT INTO syll_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Ar Zordan gangor hofaro Boni Israilor loge amra kunu zomi-zomar baṭo nitam nae, ḳenena amrar baṭ to gangor ou fubor faro-u miligese.” ");
INSERT INTO syll_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Ikan hunia Musae ḳoila, “Aichcha, tumra zudi hasau ila ḳoro, Allare azir-nazir zania zuddor haze atiar loia zudi hono laṛait zao, ");
INSERT INTO syll_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","ar Allae zotoboil tan dushmon oḳolre tan samne taki kedaia na dein otoboil tumra zuddor haze tan lagi gang faroia hofaro zudi zao, ");
INSERT INTO syll_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","te hou desho Mabudor doḳoldari kaim oia harle tumra ono firot aitae farbae. Teu Mabud ar bad-baki Boni Israilor lagi tumrar ze day-dayitto asil, ita taki kalas oibae; ar Mabudor kushi mafik ou zomino tumrar malikana ḳaim oibo. ");
INSERT INTO syll_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Oile tumra zudi ila na ḳoro, te tumra Mabudor gese gunagar bonbae. Mono rakio, tumrar fafe tumrare saṛto nae. ");
INSERT INTO syll_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Oḳon tumrar bou-baichchar lagi ṭaun oḳol ar goru-sagol toar lagi zaga-o banaitae faro, oile tumra zeḳan oada ḳorso, ita furon ḳora lagbo.” ");
INSERT INTO syll_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Teu Sadu ar Ruben ḳandanor manshe Musa nobire ḳoila, “Afne to amrar malik, afnar i gulam oḳolre afne zela hukum disoin, amra ola-u solmu. ");
INSERT INTO syll_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Amrar bou-baichchain ar goru-sagolor fal onor Giliod elaḳar ṭaun oḳol-o roiba. ");
INSERT INTO syll_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Oile amra amrar malikor hukum mafik zuddor shaz-shoronjam loia gang faroia Mabudor name laṛai korat zaimu.” ");
INSERT INTO syll_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Teu Musae ota manshor befare imam Ali-Azor, Nunor fua Iusa, ar Boni Israilor baro ḳandanor nanan gusṭir murobbi oḳolre hukum dila. ");
INSERT INTO syll_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Tain erare ḳoila, “Sadu ar Ruben ḳandanor hoḳol beṭain zudi hasau zuddor shaz-shoronjam loia Mabudor name laṛai korar niote tumrar loge Zordan gang faroia zain, te hou desh zebla tumrar doḳolo aibo, ou shomoy tumra Giliod elaḳare tarar malikanae shomzai dio. ");
INSERT INTO syll_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Oile tara zudi ila na ḳoroin, te hou Kenan desho-u tumrar loge tarar baṭ niba.” ");
INSERT INTO syll_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Ikan hunia Sadu ar Ruben ḳandanor manshe ḳoila, “Mabude tan i gulam oḳolre zela hukum disoin, amra ola-u ḳormu. ");
INSERT INTO syll_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Amra Mabudor name zuddor shaz-shoronjam loia Zordan gang faroia Kenan desho zaimu, oile amrar zomi-zomar baṭ gangor ofaro roilo.” ");
INSERT INTO syll_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Ikan hunia Musa nobi razi oila. Tain Sadu ar Ruben ḳandanre, erloge Iusufor fua Manosha ḳandanor ordeḳ manshore, ou zagain dila. Musae Amuri oḳlor bashsha Sihun ar Bashonor bashsha Uzor asta razottor hoḳol ṭaun ar gau-geram shoho shob zomi-mirash tarar lagi toila. ");
INSERT INTO syll_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Teu Sadu ḳandanor manshe Diban, Oṭarut, Aruar, ");
INSERT INTO syll_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Aṭrut-Shufan, Zazira, Zogbia, ");
INSERT INTO syll_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bayt-Nimra, Bayt-Haran namor gauain ar ṭaun oḳolre usa usa baunḍori oal gatia mozbut ḳorla. Erloge tarar goru-sagol toibar zaga-o banaila. ");
INSERT INTO syll_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Ruben ḳandanor manshe Hishbon, Iliali, Kiriataim ṭaun, ");
INSERT INTO syll_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","ar Nobo, Baal-Miyun, Sibma namor gauain ṭik-ṭak korla. Ḳoria tara itar noya nam toila. ");
INSERT INTO syll_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Manoshar fua Makiror aolad oḳole Giliodo gia age-u ita doḳol ḳorilisil, ar honor bashinda Amuri oḳolre ḳedai disil. ");
INSERT INTO syll_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Erlagi Musae Manoshar ou aolad Makiri oḳlor baṭo Giliod elaḳare dilaila, tara ono boshot ḳorla. ");
INSERT INTO syll_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Ermaze Manosha ḳandanor Zayir namor eḳzone gia Amuri oḳlor hoḳol gau-geram doḳol ḳorilisil, ar itar nam disil Habbut-Zayir. ");
INSERT INTO syll_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Ar Nuba namor eḳzone gia Konat ar er ḳanda-ḳasar gau-geram oḳol doḳol ḳoria, tar nizor name i zagar nam dilo Nuba. ");
INSERT INTO syll_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Musa ar Harun nobir netagirie Boni Israil zati fouzi dol hazia, Mishor desh taki bar oia aoar bade nanan zagat dom loila. ");
INSERT INTO syll_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Ar Mabudor hukume Musa nobie tarar dom loar zagaintor nam lekia toila. Ou zagain oilo, ");
INSERT INTO syll_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","bosoror foyla sandor fonro tarik, mani Azadi Idor bador din, tara Mishor deshor Ramashesh elaḳa taki roana oila. Mishoror hoḳol manshor sokur samnedi tara buk fulaia bar oia aila. ");
INSERT INTO syll_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Ou shomoy Mishori oḳole tarar boṛo fuaintor lash dafon ḳorat asil. Mabude agor rait tarar hoḳol goror boṛo fuainre marilisla. Tain otar deb-debir ufre-o gozob ḍalia tarar faona shaza disla. ");
INSERT INTO syll_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Boni Israile Ramashesh elaḳa saṛia Sukkoto aia tambu gaṛila. ");
INSERT INTO syll_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Bade Sukkot taki morubumir ḳandat Etom namor zagat aia tambu gaṛila. ");
INSERT INTO syll_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Ar Etom taki Baal-Zafonor samne Migdulor ḳandat Fama-Hirut namor zagat aia tambu gaṛila. ");
INSERT INTO syll_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Bade Fama-Hirut taki doria faroia Etom morubumit gela, ou morubumi bae tin dinor fot faṛi dia Maruat gia tambu gaṛila. ");
INSERT INTO syll_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Bade Marua taki Elimo gela, ino fanir barogu indara ar shottoirgu ḳezur gas asil. ");
INSERT INTO syll_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Erbade Elim saṛia Nil doriar faro gia tambu gaṛila. ");
INSERT INTO syll_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Hono taki Sin morubumit aia roila. ");
INSERT INTO syll_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Ar Sin morubumi taki Dofka namor zagat gia kemp gaṛila. ");
INSERT INTO syll_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Bade Dofka saṛia Alusho gia kemp gaṛila. ");
INSERT INTO syll_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Alush taki Rofidimo gela, ino ḳaibar kunu fani asil na. ");
INSERT INTO syll_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Teu Rofidim saṛia tara Sinai morubumit gia kemp gaṛila. ");
INSERT INTO syll_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Erbade Sinai morubumi taki Kibrut-Hutaba. ");
INSERT INTO syll_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Kibrut-Hutaba taki Hazirut. ");
INSERT INTO syll_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Hazirut taki Ritma. ");
INSERT INTO syll_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Ritma taki Rimmon-Perosh. ");
INSERT INTO syll_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Oḳan taki Libna. ");
INSERT INTO syll_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Libna taki Rissa. ");
INSERT INTO syll_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Rissa taki Kohelata namor zagat tambu gaṛila. ");
INSERT INTO syll_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Bade gela Shefor faṛo. ");
INSERT INTO syll_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Oḳan taki Horada. ");
INSERT INTO syll_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Horada taki Moḳelut. ");
INSERT INTO syll_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","On taki Tohot. ");
INSERT INTO syll_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Bade Tareḳ. ");
INSERT INTO syll_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Tareḳ taki Mitka. ");
INSERT INTO syll_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Mitka taki Hoshmuna. ");
INSERT INTO syll_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Bade Moserut. ");
INSERT INTO syll_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","On taki Boni-Iakan. ");
INSERT INTO syll_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Bade Hur-Hoggidgod. ");
INSERT INTO syll_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","On taki Zotbata. ");
INSERT INTO syll_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Zotbata taki Oboruna. ");
INSERT INTO syll_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Bade Izion-Geber. ");
INSERT INTO syll_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Ar oḳan taki Zin morubumir ḳandat Kadesh elaḳat gia tambu gaṛila. ");
INSERT INTO syll_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Bade Kadesh saṛia Idum deshor shimanar gese Hur faṛo roila. ");
INSERT INTO syll_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Boni Israil Mishor desh taki baroi aoar bade, sallish bosoror fas nombor sandor foyla din imam Harun Mabudor hukume Hur faṛor ufre uṭisla, ar hono tan ufat oilo. ");
INSERT INTO syll_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Tain eḳ-sho teish bosor boyosho Hur faṛor ufre inteḳal ḳorla. ");
INSERT INTO syll_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Ermaze Orad elaḳar Kenani bashshae ḳobor faila, Boni Israil ono aisoin. Tain to Kenan deshor Negeb morubumit roita. ");
INSERT INTO syll_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Bade Boni Israile Hur faṛ saṛia Solmuna namor zagat gia tambu gaṛila. ");
INSERT INTO syll_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Solmuna taki Punon gela. ");
INSERT INTO syll_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Punon taki Obut gela. ");
INSERT INTO syll_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Obut taki Muab deshor shimanat Iya-Abarimo gela. ");
INSERT INTO syll_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Oḳan taki Diban-Sadu gela. ");
INSERT INTO syll_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","On taki Almun-Diblatimo gela. ");
INSERT INTO syll_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Bade tara Abarim faṛo uṭia Nobo namor ṭillar ḳandat kemp gaṛila. ");
INSERT INTO syll_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Erbade Abarim faṛ saṛia Ziriho ṭaunor ulṭabae Zordan gangor ḳandat Muab deshor tol zagat tambu gaṛila. ");
INSERT INTO syll_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","I kempor shimana asil Zordan gangor faro Muab elaḳar tol zaga Bayt-Zishimut taki Abel-Shiṭim ṭaun forzonto. ");
INSERT INTO syll_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Ar ou shomoy Ziriho elaḳar Zordan gangor daro Muab deshor tol zagat Mabude Musa nobire ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Tumi Boni Israilre zanai deo, tumra zebla Zordan gang faroia Kenan desho gia azibae, ");
INSERT INTO syll_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ou shomoy tumrar samon taki honor hoḳol manshore ḳedai dibae. Ḳedaia tarar fattor kudia banail hoḳol murti bangia surmar ḳorbae. Hunaror atiardi banail hoḳol deb-debir murti binash ḳorbae. Ar ṭillar ufror devtar namor foshur-boli kanain tulia falaibae. ");
INSERT INTO syll_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Olaḳan tumra asta desh doḳol ḳoria hono boshot ḳorbae. Mono rakio, tumrar doḳoldarir lagi i deshḳan ami tumrare dan ḳorsi. ");
INSERT INTO syll_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Hono loṭari maria tumrar nanan gusṭir zaga baṭia nio. Ze gusṭit beshi manush tarare beshi zaga, ar ḳom oile ḳom zaga dio. Loṭarit ze gusṭie ze zaga faiba, tara ono-u boshot ḳorba. Ḳandanor mazor nanan gusṭie zarzir ḳandanor elaḳar maze zaga faiba. ");
INSERT INTO syll_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Oile tumra zudi honor bashinda oḳolre na ḳedao, te tarar zeguin roiba, iguin tumrar sokur ḳaṭa ar bukur sel bonia roiba. Itae tumrar boshoti zomino tumrare zulum-mosiboto falaiba. ");
INSERT INTO syll_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Hou shomoy ami tumrare ola shaza dimu, ze shaza ḳali tarar lagi-u ṭik koria toislam.” ");
INSERT INTO syll_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Mabude Musa nobire ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Tumi Boni Israilre amar ou hukum zanai deo, tumra gia Kenan desho hamanir bade hono ze zagar malikana faibae, i zagar shimana oilo, ");
INSERT INTO syll_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Idum deshor boḍaror Zin morubumir kisu elaḳa tumrar deshor douknor shimana. Bade ou douknor shimana taki fubedi gia Luna shagoror hesh mata forzonto. ");
INSERT INTO syll_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Erloge Akrabbim faṛor fot faroia hari Zin morubumit hamaia Kadesh-Bornear douknedi shimana zaibo. Gia oḳan taki Hazor-Ador oia Ozmun forzonto tumrar shimana. ");
INSERT INTO syll_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Ar Ozmun taki guria Mishoror shimanar hukna ḳalor faredi Bumodio shagoro gia lagbo. ");
INSERT INTO syll_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“Tumrar deshor foismor shimana oibo Bumodio shagor. Iṭa-u tumrar foismor ail. ");
INSERT INTO syll_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“Tumrar utoror shimana oibo, Bumodio shagor taki Hur namor faṛ, ");
INSERT INTO syll_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","ou faṛ taki Hamato zaibar fot forzonto, Hamator fot taki tumrar shimana Zidad gau forzonto zaibo. ");
INSERT INTO syll_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Ar Zidad taki Zifrun oia Hazor-Onono gia shesh oibo. Iṭa-u oibo tumrar utoror shimana. ");
INSERT INTO syll_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“Deshor fubor shimana oilo, Hazor-Onon taki Shofam forzonto eḳṭa shimana ail ṭik korio. ");
INSERT INTO syll_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Ou Shofamor shimana taki Oin gaur fubedi gia Ribla forzonto aia lambo, lamia Galil aoror soredi zaibo, ");
INSERT INTO syll_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","gia Zordan gangor faredi Luna shagoro aia shesh oibo. Ou shob oilo tumrar deshor sairo galar shimana ail.” ");
INSERT INTO syll_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Ar Musae Boni Israilre hukum dila, “Mabudor hukum mafik tumra loṭari maro, maria tumrar noy ḳandan ar Manosha ḳandanor ordeḳ manshore ou deshor zomi-maṭi baṭia dia, tumrar doḳoldari kaim ḳoro. ");
INSERT INTO syll_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Zano to, Ruben ḳandan, Sadu ḳandan ar Manosha ḳandanor ordeḳ manshe tarar zarzir gusṭi mafik zomi-zomar baṭ age-u failise. ");
INSERT INTO syll_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Tara Ziriho elaḳar Zordan gangor fubor faro tarar baṭ age-u basia nisoingi.” ");
INSERT INTO syll_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Ou deshor zomi-maṭire baṭia dite zera matobbori korba, erar nam oilo, imam Ali-Azor ar Nunor fua Iusa. ");
INSERT INTO syll_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Zomi-zoma baṭibar ḳalo shaijjo ḳorar lagi fortek kandano taki eḳzon ḳori shordar nibae. ");
INSERT INTO syll_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Ou shordar oila, Ehuda ḳandanor Zifunnir fua Kalut, ");
INSERT INTO syll_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Shimion ḳandanor Amihudor fua Shamuel, ");
INSERT INTO syll_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Bin-Iamin ḳandanor Kislunor fua Ilidod, ");
INSERT INTO syll_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Dan ḳandanor shordar Uzolir fua Bukki, ");
INSERT INTO syll_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Iusufor fua Manosha ḳandanor shordar Ifador fua Hanniel, ");
INSERT INTO syll_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Iusufor fua Afraim ḳandanor shordar Shiftonor fua Komuel, ");
INSERT INTO syll_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Sobulon ḳandanor shordar Fornaḳor fua Ilizafon, ");
INSERT INTO syll_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Isaḳor ḳandanor shordar Azanor fua Foltiel, ");
INSERT INTO syll_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Ashir ḳandanor shordar Sholumir fua Ohihud, ");
INSERT INTO syll_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Noftali kandanor shordar Amihudor fua Fodohel.” ");
INSERT INTO syll_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Mabude ou shordar oḳolre zimmadari shomzaila, Kenan desho Boni Israilor zomi-zoma baṭia dibar lagi. ");
INSERT INTO syll_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Bade Ziriho ṭaunor ḳasat Zordan gangor daro Muab deshor tol zagat Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Tumi Boni Israilre ou hukum deo, tara zarzir ḳandanor zomi-zomar baṭ faia harle, ota taki kisu ṭaun Lebi kandanor manshore dilaita, era ono roiba, erloge bondor kisu zomi-o erare dita. ");
INSERT INTO syll_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Ou ṭauno tara boshot ḳorba, ar bondor zomino tarar foshur fal raḳba. ");
INSERT INTO syll_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Tumra Lebi kandanre ze ṭaun oḳol dibae, itar baunḍori oalor bare tarare aro eḳ azar at zaga dibae, tarar foshur fal raḳar lagi. ");
INSERT INTO syll_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Tumra zoto ṭaun tarare dibae, itar sairo galar baunḍori oalor bare, mani utore-douḳne, fube-foisme, hokkolbae aro dui azar at bondor zaga mafia dio. Ono tarar foshur fal raḳba. ");
INSERT INTO syll_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“Tumra Lebi kandanre zeta ṭaun oḳol dibae, ermazor soyḳan ṭaun oibo kuni manshor asroy ṭaun. Kunu manshe aḳta ḳeurore marilile, he ou ṭauno gia asroy loibo. Ou soy ṭaun bade-o Lebi kandanre aro beyallish ḳan ṭaun dilaibae. ");
INSERT INTO syll_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Muṭ aṭchallish ḳan ṭaun Lebi oḳolre dibae, ar erloge foshur fal raḳar bondor zaga-o dibae. ");
INSERT INTO syll_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Boni Israilor zomi-zoma taki Lebi kandanre zebla ṭaun oḳol dibae, ou shomoy hoḳol ḳandane faoa zominor baṭ taki tarare dibae. Ze ḳandane beshi faise era beshi diba, ar zera ḳom faise era ḳom diba.” ");
INSERT INTO syll_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Erbade Mabude Musare ḳoila, ");
INSERT INTO syll_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Tumi Boni Israilre ḳo, tumra zebla Zordan gang faroia Kenan desho gia hamaibae, ");
INSERT INTO syll_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","ou shomoy tumrar nizor lagi koyḳan asroy ṭaun ṭik korio. Teu kunu manshe zudi aḳta ḳoza ḳoria ḳeurore kun ḳorilae, te bagia hono gia asroy loibo. ");
INSERT INTO syll_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Kunor bodla loura manshor ges taki bagia zan basanir lagi i asroy ṭaun. Ete Boni Israilor adaloto bisaror ag forzonto kunor ashamire ḳeu zane marar shuzug faito nae. ");
INSERT INTO syll_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Erlagi Lebi kandanre tumra ze ṭaun oḳol dibae, itar mazor soyḳan ṭaun oibo tumrar asroy ṭaun. ");
INSERT INTO syll_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Ermazor tinḳan ṭaun oibo Zordan gangor fubor faro, ar tinḳan oibo Kenan deshor bitre. ");
INSERT INTO syll_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Ou soyoḳan ṭaun oibo Boni Israilor lagi, tumrar loge roura bin-deshi oḳlor lagi ar musafir oḳlor lagi asroy ṭaun. Erar mazor ḳeu zudi aḳta bekiale ḳeurore kun ḳorilae, te oḳano gia zan basaibo. ");
INSERT INTO syll_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“Oile kunu manshe zudi luar kunu atiar dia ḳeurore mare ar hou zon morizae, te ogu kuni. Ou kunire zane marilibae. ");
INSERT INTO syll_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Ze fattor dia kunu manshore kun ḳora zaibo, ila kunu fattor zudi keuror ato taḳe, ar ogudi keurore marae hou manush morizae, te ogu-o kuni. I kunire zane marilibae. ");
INSERT INTO syll_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Manush kun oar moto kunu laḳṛir zinish zudi keuror ato taḳe, ar ogu dia ḳeurore marae hou manush morizae, te ogu-o kuni. I kunire zane marilibae. ");
INSERT INTO syll_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Kun oa zonor afon ze manshe i kunor bodla loar ḳota, ḳali he-u ou kunire zane marilibo. Kunir deḳa faile-u tare zane marilibo. ");
INSERT INTO syll_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","“Ar ingsha ḳoria zudi eḳzone aroḳzonre ḍekka mare, ba kunuzat ostrodi ichcha ḳoria iṭa mare ar hou manush morizae, ");
INSERT INTO syll_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","ba dushmonir babe ḳeurore gushi mare ar he morizae, te ze marse he kuni. I kunire zane marilibae. Kun oa zonor afon ze manshe i kunor bodla loar ḳota, he ou kunir lagal faile-u tare zane marilibo. ");
INSERT INTO syll_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“Oile mono kunu dushmoni na rakia bule aḳta ḳeurore ḍekka marle, ba mono kunu ḳarafi na taḳle-o bule tar ufre iṭa mari dile, ");
INSERT INTO syll_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","ba na dekia, manush morizibar zuka kunu fattor ḳeuror ufre falai dile he zudi morizae, te kunuzat dushmonir bab na taḳae, ar ḳeti korar kunu ichcha na taḳae, ");
INSERT INTO syll_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","Boni Israilor adalotor manshe, ou kunir ar kunor bodla loura zonor befare ou niom mania bisar ḳorba. ");
INSERT INTO syll_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Ou shomoy adalotor manshe kunor bodla lourar at taki kuni zonre basaiba, basaia he age zeḳano bagia gesil, hou asroy ṭauno tare hirbar fosai diba. Ar fobitro tel dia ḳelafoti faoa fordan imam sabor moutor ag forzonto he hono roibo. ");
INSERT INTO syll_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Oile he zudi kunu shomoy hou asroy ṭaunor bare bar oia zaegi, ");
INSERT INTO syll_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","ar bodla lourae tare faia zane marilae, te he kunor dayi oito nae. ");
INSERT INTO syll_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Ḳaron fordan imamor mout na oa forzonto he asroy ṭauno roar ḳota. Ḳali fordan imamor moutor bade he nizor baṛit firia aito farbo. ");
INSERT INTO syll_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Tumra deshor zeno-u boshot ḳoro na ḳene, oarishor for oarish dori ita mante oibo, ita to oilo tumrar shoriotor eḳṭa ain. ");
INSERT INTO syll_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“Shakkir zobanbondir ufre nirbor ḳoria kunire zane marilaoa oibo. Oile ḳali eḳzon shakkir ḳotae ḳeurore marilaoa zaito nae. ");
INSERT INTO syll_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Mout-u zar faona shaza, ila kunu kunire kunumonte-u ṭeḳar bodla ḳalas deoa zaito nae. Tare zane marilite-u oibo. ");
INSERT INTO syll_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Ashroy ṭauno roura kunu ashamire ṭeḳar bodla, fordan imamor moutor age tar nizor baṛit firai ana zaito nae. ");
INSERT INTO syll_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Mono rakio, ita ḳoria tumra nizor deshor maṭire nafak korio na. Zano to, kunor loue desh nafak oizae. Ar ze desho kunor lou zorse, hou kunir lou saṛa ar kunumonte-u hi deshor nafakir kofora oy na. ");
INSERT INTO syll_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Ar tumra ze desho roibae ami-o to hono roimu, erlagi i deshre nafak banaio na. Ḳaron ami Mabud Boni Israilor maze boshot ḳori.” ");
INSERT INTO syll_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Iusuf nobir aolador ḳandan oḳol taki, Manoshar nati Makiror fua Giliod gusṭir nanan foribar taki murobbi oḳol aila, aia tara Musa nobi ar Boni Israilor nanan gusṭir shordar oḳlor loge matila. ");
INSERT INTO syll_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Ḳoila, “Mabude amrar i malikre hukum disla, loṭari maria Boni Israilor maze deshor zaga-zomin baṭia dita. Dibar shomoy amrar bai Zolafḳador zomi-zoma ḳanain tar fuṛintore dibar hukum disoin. ");
INSERT INTO syll_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Oile Boni Israilor dusra kunu ḳandanor manshor loge zudi ou fuṛintor bia oy, te amrar baf-dadar samana taki tarar samana bar oia gia, tarar zamair ḳandanor zomi-zomat hamaizibo, ete amrar ḳandanor zomi-mirashor kisu ongsho ḳomizibo. ");
INSERT INTO syll_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Boni Israilor zomi-mirash Firot Faoar hou fobitro foinchash bosoror ḳalo, tarar zomi-zoma gia to tarar zamair ḳandanor samana oizibo. Ou laḳan amrar baf-dadar zomi-mirash taki tarar ongsho bar oia zaibogi.” ");
INSERT INTO syll_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Ikan hunia Mabudor hukum mafik Musae Boni Israilre ḳoila, “Iusufor aolador ou ḳandanor manshe zeta ḳoira, ita to hasa. ");
INSERT INTO syll_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Erlagi Zolafḳador fuṛintor befare Mabude hukum dira, tara zare fosond ḳoroin tar gese-u bia boita farba. Oile shorto oilo, tarar bafor ḳandanor bitre bia boite oibo. ");
INSERT INTO syll_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Boni Israilor zomi-mirash ek kandan taki arok kandano zaito farto nae. Boni Israilor forteḳ zone tar baf-dadar zomi-mirash basani lagbo. ");
INSERT INTO syll_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Boni Israilor forteḳe zate tarar baf-dadar ges taki faoa zomi-zomar malikana ṭikai raḳto fare, otar lagi fortek kandanor zomi-zomar malikana faoa fuṛinte tarar bafor ḳandanor noshar gese bia boite oibo. ");
INSERT INTO syll_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Ek kandan taki arok kandano kunu zomi-zoma zaito nae. Boni Israilor fortek kandane tarar zomi-zomar malikana doria raḳte oibo.” ");
INSERT INTO syll_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Mabude Musare zela hukum disla, Zolafḳador fuṛinte ola manla. ");
INSERT INTO syll_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Tarar bafor ḳandanor baiaintor gese bia boila. Zolafḳador fuṛintor nam oilo, Mohola, Tirza, Hogla, Milka, ar Nua. ");
INSERT INTO syll_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Iusufor fua Manoshar ḳandanor gusṭi oḳlor maze-u tara bia boila. ");
INSERT INTO syll_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Ar huno, Ziriho elaḳar Zordan gangor daro Muab deshor tol zagat, Mabude Musa nobir mazdi Boni Israilre ou hukum-ahkam ar niom-ḳanun oḳol disla.");
INSERT INTO syll_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Musa nobie Zordan gangor fub faror Araba namor morubumit Boni Israil zatire ou boyan ḳorsla, tain Suf gaur samne ubaia tarar loge matila. Er eḳbae asil Faran, ar oinnobae asil Tufol, Labon, Hazirut ar Dizahab, ou sair gau. ");
INSERT INTO syll_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Seiror faṛia fotedi Tur faṛ taki Kadesh-Bornea forzonto aṭia zaite ḳali egaro din lage. ");
INSERT INTO syll_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Oile Boni Israil Mishor taki bar oia unchallish bosor egaro mash forzonto, ortat soforor sallish boros solar ḳalo, ono gurila. Bade ou mashor foyla tariko Musa nobie tarare zanaila Mabude tanre zeta ḳoisla. ");
INSERT INTO syll_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Tain laṛai kori Amuri oḳlor bashsha Sihunre ar Bashon deshor bashsha Uzre araia harle ita ḳoila. Ou Sihune bashshai korta Hishbon ṭauno, ar Uze bashshai korta Osṭarut ar Idri ṭauno. ");
INSERT INTO syll_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Zordan gangor fub faror Muab desho, Musa nobie Allar deoa Tourator talim boyan ḳoria buzaila. Tain ḳoila, ");
INSERT INTO syll_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“O Boni Israil, huno, amra Tur faṛor galat taḳar ḳalo Mabud Allae amrare ḳoisla, ou faṛor galat tumrar bout din guzori gese. ");
INSERT INTO syll_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Te oḳon tumra hoḳole tambu tulia Amuri oḳlor faṛia elaḳa ar ou elaḳar ḳanda-ḳasar hoḳol zagat zaoar lagi roana o. I zaga hoḳolta oilo gia: Araba morubumi ar ou morubumir ḳanda-ḳasar usa faṛia zaga ar nisa faṛia zaga, Negeb morubumi ar doriar kinara, mani Kenan desh taki arombo ḳoria Lebanon desh oia Furat gang forzonto ita hoḳol zaga. ");
INSERT INTO syll_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Mono rakio, ita hoḳol zaga ami tumrare dilaisi. Ami Mabude tumrar baf-dadain Ibrahim, Isʼhak, Iakub ar tarar ḳandanre ze desh deoar oada ḳorslam, tumra oḳon gia ita hoḳol zaga doḳol ḳorilao. ");
INSERT INTO syll_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","“Te baiainre, hou shomoy ami tumrare ḳoislam, tumra hoḳlor bar to ami eḳla boibar shaiddo nai. ");
INSERT INTO syll_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Tumrar Mabud Allae tumrare oto aolad baṛai disoin, erlagi tumra aiz asmanor terar laḳan oiso, gonia fuṛail zae na. ");
INSERT INTO syll_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Tumrar baf-dadar Mabud Allae tumrare aro azar azar gun baṛaukka, ar tan oada mafik tumrare rohom-borkot deukka. ");
INSERT INTO syll_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Oile ami eḳla ḳemne tumrar ḳaijja-fosad miṭaitam, ar tumrar zimmadarir bar boitam? ");
INSERT INTO syll_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Erlagi tumrar fortek kandan taki koyzon aḳoldar, zanra-hunra ar hoḳol manshor gese ijjoti zonre fosond ḳoro, ami tumrar zimmadari erar ato shomzaimu. ");
INSERT INTO syll_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","“Tumra zuaf dislae, aichcha, afne zela ḳoira, ola-u bala oibo. ");
INSERT INTO syll_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Teu ami tumrar fortek kandan taki aḳoldar, buddiman ar zanra-hunra zonre nia tumrar azar zonor ufre, sho zonor ufre, foinchash zonor ufre, dosh zonor ufre shordar banai dislam, ar ofisar-o boail ḳorslam. ");
INSERT INTO syll_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","“Hou shomoy ami tumrar hakim oḳolre hukum dislam, ḳoislam, ḳaijja-fosador bisaro badi-bibadi duio fokkor mat hunia hok insaf ḳorio, ita nizor zatir ouk ba bin zatir ouk. ");
INSERT INTO syll_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Bisaror shomoy tumra ḳeuror fokko loio na, doni-gorib hoḳlor ḳota hunio. Ashole bisaror malik to Alla, erlagi tumra kunu manshore ḍoraio na. Ze bisaror mimangsha ḳora tumrar lagi koṭin oy, ikan amar gese anio, ami deḳmu. ");
INSERT INTO syll_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Ar tumra kila kita ḳortae, ita to ami hou shomoy ḳoia dislam. ");
INSERT INTO syll_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","“Bade amra Mabud Allar hukum faia, Tur faṛ saṛia Amuri oḳlor faṛia elaḳa muka roana oilam. Tumra to deḳso, ḳoto boṛo ar ḳoto marattoḳ morubumi faroia amra Kadesh-Bornea aia azilam. ");
INSERT INTO syll_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Azia hari ami koislam, oḳon to tumra Amuri oḳlor hou faṛia elaḳat aia fosi geso, i deshḳan amrar Mabud Allae amrare dilaira. ");
INSERT INTO syll_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Huno, tumrar Mabud Allar dan ḳora ou asta desh-u tumrar samne foṛi roise. Oḳon zao, gia tumrar baf-dadar Mabud Allar oada ḳora ou deshre doḳol ḳoro. Ḳeu ḍoraio na, nirash oio na. ");
INSERT INTO syll_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","“Ou shomoy tumra hoḳol aia amare ḳoilae, te foyla ḳoyzon guiare ou desho faṭail ouk, tara gia deshḳan dekia aia amrare ḳoiba, kun fote zaoa amrar lagi bala ar zaoar foto kun kun ṭaun foṛbo. ");
INSERT INTO syll_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","“Tumrar foramish amar fosond oilo, erlagi fortek kandan taki eḳzon ḳori muṭ baro zonre alog korlam. ");
INSERT INTO syll_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Tara tumrare ono toia ou faṛor ufre uṭlo, ar Ashkul namor faṛia ḳalo gia bala ḳori hoḳolta dekia ailo. ");
INSERT INTO syll_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Tara hou desh taki kisu fol-mul ania amrare deḳaia ḳoilo, amrar Mabud Allae amrare ze deshḳan dan ḳorra, ikan to boṛo bala zaga. ");
INSERT INTO syll_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","“Oile tumra ou desho zaite razi oilae na. Tumra nizor Mabud Allar hukumor birudita ḳorlae. ");
INSERT INTO syll_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Tumra zarzir tambut hamaia boḳa-zoḳa shuru ḳorlae, ar ḳoilae, Mabude amrar loge dushmoni koroin, erlagi-u amrare binash ḳorar niote, Amuri oḳlor ato falaia marar kiale, Mishor desh taki tain amrare bar ḳori anchoin. ");
INSERT INTO syll_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Amra kila hino zaimu? Amrar guia baiainte aia zano ḍor harai disoin. Tara ḳoisoin, hinor manush bule amra taki bout usa-muṭa foyluan. Tarar ṭaun oḳol-o boṛo boṛo, itar sairobae usa usa oal dia baunḍori kora, asmano soilar lager. Ar foyluan Anaki oḳolre-o bule hono deḳsoin. ");
INSERT INTO syll_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","“Ita hunia ami tumrare ḳoislam, tumra mon gabṛaio na, itare ḍoraio na. ");
INSERT INTO syll_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Tumrar Mabud Alla to tumrar age age zaira. Tain tumrar fokko loia tumrar sokur samne Mishor desho zela zuddo ḳorsla, oḳono oula ḳorba. ");
INSERT INTO syll_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","Ar ou morubumir maze-o to tumra deḳso, ono aia fosar ag forzonto, bafe zelaḳan afon futre kulo ḳori boia nein, oulaḳan Alla Mabude tumrare-o asta fot boia anchoin. ");
INSERT INTO syll_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Otota hunar bade-o tumra tan ufre borosha ḳorlae na. ");
INSERT INTO syll_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","Taine-u to tambu gaṛibar zaga sinanir lagi ar fot sinaia nibar lagi, raitkur shomoy agunir kuṭi ar dinkur shomoy megor kuṭir nomuna oia tumrar age age gesoin. ");
INSERT INTO syll_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","“Oile tumrar ita zuaf hunia Mabude kub gusa ḳorla, tain ḳosom ḳaia ḳoila, ");
INSERT INTO syll_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","ami Mabude tumrar baf-dadar gese ḳosom ḳaislam ou deshḳan ditam ḳori, ta-o oḳonkur ita naforman oḳole i bala zaga ḳan deḳar nosib oito nae, ");
INSERT INTO syll_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","ḳali Zifunnir fua Kalut saṛa. Ikan deḳar shoubaiggo ou Kalute faibo, he amar ḳotare furafur manche, he zeta zaga faodi faṛaia aise, ita zaga ami tare ar tar aolad oḳolre dimu. ");
INSERT INTO syll_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","“Baiainre, tumrar ḳarone Mabude amar ufre-o gusa ḳorla, gusa ḳori amare ḳoila, tumi Musa-o hou desho hamaitae fartae nae. ");
INSERT INTO syll_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Ḳali tumar ḳadim Nunor fua Iusa gia hono hamaibo. Tumi tare shaosh dio, he Boni Israilre i deshor doḳoldari dia malik banaibo. ");
INSERT INTO syll_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Tumra ḳoislae, amrar bebuz nabalik huruttaintore hou deshor manshe doria nibogi. Oile ami Mabude erare-u ou Kenan deshor malik banaimu, era ikan doḳol ḳorba. ");
INSERT INTO syll_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Te oḳon tumra hirbar fisaia gia Nil doriar faredi morubumir bae roana deo. ");
INSERT INTO syll_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","“Ikan hunia tumra ḳoislae, amra to Mabudor dorbaro gunagar oigesi. Ta-o amrar Mabud Allar hukum mafik oḳon gia zuddo ḳormu. Oḳan ḳoia tumra ostro-shostro loilae, ar mono ḳorslae, faṛi elaḳat uṭia zuddo ḳora-o kub shuza. ");
INSERT INTO syll_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","“Oile Mabude amare ḳoila, tumi tarare ḳo, tara zanu zuddor lagi faṛo na uṭe, ḳaron ami tarar loge roitam nae, ar amare saṛia zudi tumrar nizor ichchae zao, te dushmonor gese aribae. ");
INSERT INTO syll_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Ami tumrare hushiari deoar bade-o tumra ita manlae na. Tumra Mabudor hukumor ulṭa gia buk fulaia ou faṛo uṭat laglae. ");
INSERT INTO syll_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Teu faṛor bashinda Amuri zatie tumrare dekia fal bandi bar oilo, mousaḳor mou-fukor laḳan fal bandia tumrar ḳore ḳore ailo, ar marte marte Seiror Horma ṭaun forzonto ḳedaia nilo. ");
INSERT INTO syll_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Bade tumra aia Mabudor gese ḳandon lagailae, oile Mabude ḳan bond ḳorilla, i kandon hunla na. ");
INSERT INTO syll_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Ou nomunae tumra bout din Kadesh elaḳat roilae, lamba shomoy ono guzrilo.” ");
INSERT INTO syll_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Hozrot Musae aro ḳoila, “Mabude amare zela hukum disla, oula amra fisaia gia morubumir mazedi Nil doriar muka roana dilam. Seiror faṛia elaḳa sokkor dia zaite amrar bout din gelogi. ");
INSERT INTO syll_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Bade Mabude amare ḳoila, ");
INSERT INTO syll_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","tumra bakka din taki ou faṛia elaḳat sokkor dirae, oḳon uttor muka roana deo. ");
INSERT INTO syll_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Erbade tain amare ḳoila, ami tumrare zanaitam tumra oḳon Shek Ishʼor aolador doḳole taḳa Seir deshor bitredi zaite oibo. Gele tumrare dekia tara ḍoraiba, oile tumra kub hushiar roio, era to tumrar baiain. ");
INSERT INTO syll_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Tarar loge ḳaijja-fosad ḳorio na. Mono rakio, tarar deshor eḳ inchi zomi-o ami tumrare ditam nae. Ḳaron asta Seir faṛor malikana ami Shek Ishʼre dilaisi. ");
INSERT INTO syll_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Tarar ou desh faroia zaibar ḳalo tumrar ḳani-kuraki lagle ṭeḳadi loia ḳaibae, oula fani-o loia ḳaibae. ");
INSERT INTO syll_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","“Tumrar Mabud Allae hoḳol ḳamor maze-u tumrare rohom-borkot disoin. Ou oto boṛo morubumi faronir bala tain tumrare hefazot ḳorsoin. Ou sallish bosor dori tumrar Mabud Alla tumrar loge loge asoin, erlagi kunu laḳan obab oise na. ");
INSERT INTO syll_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","“Teu amra fatari fote aṭilam, aṭia amrar bai Seiror bashinda Ishʼor aolador desh falaia gelam. Amra Araba tolbumir ze rasta Elat ar Izion-Geber taki bar oia aise, ou fotedi na gia Muabor morubumir muka aṭa dorlam. ");
INSERT INTO syll_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Ar Mabude amare ḳoila, tumra Muabi oḳolre sataio na, kunu zuddor bab-shab deḳaio na. Mono rakio, tarar deshor kunu zomi-u ami tumrare ditam nae. Tarar razdani Aur ṭaunor malikana ami Lut nobir aolad Muabi oḳolre dilaisi.” ");
INSERT INTO syll_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(Age Eimi zatir manush ou elaḳat roita, ita asla foyluan zati, tara forimane asla bout zon, ar deḳte Anaki zatir laḳan usa-muṭa lamba. ");
INSERT INTO syll_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Anaki oḳlor laḳan Eimi oḳolre-o Rofayi name ḍaḳa oito, oile Muabi oḳole itare Eimi koia ḍakita. ");
INSERT INTO syll_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Seir faṛo Hurio oḳole boshot ḳorta, bade Ishʼor aolad oḳole tarare ḳedaia dia ikan doḳol ḳorla. Mabudor ate Boni Israile zela Kenan deshor malikana faia Kenani oḳolre ḳedaiba, ṭik ola Ishʼor aolad oḳole-o ḳorsla. Tara Hurio oḳolre binash ḳoria hoḳol zomi-maṭi doḳol ḳoria nize hono boshot ḳorla.) ");
INSERT INTO syll_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Musa nobie aro ḳoila, “Bade Mabude hukum dila, tumra zoldi kori roana o, ar Zered faṛia ḳal faroia hofaro zao. Teu amra faroilam. ");
INSERT INTO syll_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Ar Kadesh-Bornea taki bar oia hari Zered gulla faroia aite amrar aṭtish bosor lagsil. Ermaze oula oilo, Mabude age ḳosom ḳaia zela ḳoisla, oula Kadesh-Bornea taki baronir ḳalo amrar zoto sifai asla, era hoḳol-u ou aṭtish bosore morigela. ");
INSERT INTO syll_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Boni Israil shomaz taki tarare binash ḳorar ag forzonto Mabud tarar bifokke asla. ");
INSERT INTO syll_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","“Ou hoḳol sifai moria shesh oia harle, ");
INSERT INTO syll_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","Mabude amare ḳoila, ");
INSERT INTO syll_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","Aiz tumra Muabi oḳlor deshor shimana faroibae, tarar razdani Aur ṭaunor ḳandabae zaibae. ");
INSERT INTO syll_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Oile tumra zebla Boni-Amman deshor ḳasat zaibaegi, gia tarare sataio na, tarare zuddor bab-shab deḳaio na. Mono rakio, tarar deshor kunu zaga-u ami tumrare ditam nae, ikanor malikana to ami Lut nobir aolad Boni-Ammanre dilaisi.” ");
INSERT INTO syll_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(Age Rofayi oḳol ono roita, erlagi ikanre Rofayi oḳlor desh ḳoia ḍaḳa oito. Ar Boni-Ammane itare Zam-Zamimi koia ḍakita. ");
INSERT INTO syll_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Rofayi zati foyluan asla, deḳte Anaki zatir laḳan usa-muṭa lamba ar forimane-o bout beshi asla. Mabude Boni-Amman zatir ato itare binash ḳoraila, Boni-Ammane Rofayi zatire ḳedai dia ou desh doḳol ḳorla. ");
INSERT INTO syll_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Mabude Ishʼor aolad oḳolredi ou eḳoi kam ḳoraila, tain erar ato Hurio zatire binash ḳorla. Era Hurio oḳolre ḳedaia dia, tarar Seir desh doḳol ḳoria boshot ḳorra. ");
INSERT INTO syll_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Ermaze Koftur dif taki Kofturi zatie aia Obbi zatire binash ḳorla, tarar maṭire doḳol ḳoria boshot ḳorla. Ou Obbi oḳol Gaza ṭaunor daro boshot ḳorta, honor hoḳol gau-geramo tara roita.) ");
INSERT INTO syll_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“Erbade Mabude ḳoisla, O Boni Israil, tumra bar o, bar oia Ornon ḳalor hofaro zao. Huno, Amuri zatir bashsha Sihun ar tar Hishbon deshre ami tumrar ato shofi disi. Ikan doḳol ḳorat gia bashshare zuddor filḍo lamao, ");
INSERT INTO syll_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","teu deḳbae, ami Mabude aiz taki zogotor hoḳol zatir dilo ḍor harai dimu, tumrar ḍore tara ḳafiba. Tumrar aoaz hunle-u tarar zano doṛfoṛ shuru oibo.” ");
INSERT INTO syll_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Musa nobie Boni Israilre aro ḳoila, “Bade ami shanti-chukti korar kiale Ḳadimut morubumi taki Hishbonor bashsha Sihunor gese ḳobria faṭailam, ḳoilam, ");
INSERT INTO syll_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","amra afnar deshor bitredi faroia zaitam sai, onumoti diba ni? Amra atare-fatare kunubae zaitam nae, ḳali mul shoṛokedi aṭia zaimu. ");
INSERT INTO syll_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","29","Amra nogod ṭeḳadi afnar ges taki kani-kuraki ba fani-o ḳorid ḳoria ḳaimu. Amrar Mabud Allae amrare ze deshḳan dita saira, Zordan gang faroia hou desho zaibar ag forzonto, afnar deshor ufredi amrare aṭia zaite deukka. Seiror faṛia elaḳar bashinda Ishʼor aolad oḳole, ar Aur ṭaunor bashinda Muabi oḳole-o amrare ola faroite disoin. ");
INSERT INTO syll_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","“Oile Hishbonor bashsha Sihun razi oilo na, amrare zaite dilo na. Tumrar Mabud Allae-u tar dilre fashan banailla, tar monor bab luar laḳan oigelo, zate tumrar ato tar binash oy, ar ṭik-u ola oilo. ");
INSERT INTO syll_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Teu Mabude amare ḳoila, O Musa, Sihun ar tar bashshaire ami tumar ato shofi dilam. Oḳon tumi hono zao, gia ou desh doḳole anat lago, ar hono boshot ḳoro. ");
INSERT INTO syll_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","“Teu Iyahaz elaḳat Sihune tar hoḳol sifai dol loia amrar loge laṛai korat ailo, ");
INSERT INTO syll_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","ou shomoy amrar Mabud Allae tare amrar ato falaila. Amra bashshare, tar fuaintore, tar sifai dolre nifat ḳorlam. ");
INSERT INTO syll_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Ar amra tar hoḳol ṭaun, gau-geram hoḳolta doḳol ḳorlam, tarar hoḳol beṭain-beṭin ar huruttare binash ḳorlam. Eḳzon-o zinda roise na. ");
INSERT INTO syll_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Ḳali tarar foshur fal ar gonimotor mal-samana amrar lagi anlam. ");
INSERT INTO syll_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Ornon ḳalor shimanar Aruar ṭaun, ar ou elaḳar ek gau taki arok gau doḳol ḳori kori, Giliod forzonto kunu zaga amrar doḳolor baire roilo na. Amrar Mabud Allae ita hoḳolta amrar ato dila. ");
INSERT INTO syll_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Ḳali Boni-Amman zatir desh, Zabbuk faṛia ḳalor ḳanda-ḳasar hoḳol zila, faṛor ufror gau-geram, ar amrar Mabud Allae zeta zaga doḳol ḳorte nished ḳorsoin, ou zaga ḳanain tumrar doḳolor baire roilo.” ");
INSERT INTO syll_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Hozrot Musae Boni Israilre aro ḳoila, “Hishbon desh taki amra Bashon desho zaoar fote roana oilam. Bashonor bashsha Uze ḳobor faia zuddo ḳorar lagi tar hoḳol sifai dol loia Idri ṭauno ailo. ");
INSERT INTO syll_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Ar Mabude amare ḳoila, O Musa, i bashshare tumi ḍoraio na. Huno, ami tare, tar asta deshre, tar sifai dolre tumar ato tulia dilaisi. Tumi Hishbon desho Amuri zatir bashsha Sihunor ze dosha goṭaiso, ogure-o oula ḳorio. ");
INSERT INTO syll_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","“Ou nomunae amrar Mabud Allae Bashon deshor bashsha Uzre, tar hoḳol manshore amrar ato shomzai dila. Amra-o ita hokkolṭire binash ḳorlam, kunugure zinda raḳsi na. ");
INSERT INTO syll_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Amra tar deshor hoḳol gau-geram, ṭaun-bondor doḳol ḳorlam. Tarar shaiṭ ḳan ṭaun-u doḳol ḳorillam, kunta bad roilo na. Asta Orgub elaḳa, mani Bashonor bashsha Uzor fura bashshai amrar doḳolo nilamgi. ");
INSERT INTO syll_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Ou ṭaun oḳol-o usa usa oal dia baunḍori kora asil, itar geiṭo asil boṛo boṛo kil. Ar baunḍori saṛa-o bout gau-geram asil. ");
INSERT INTO syll_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Amra hoḳol ṭaun ar gau-geramre ekkebare binash ḳorsi. Age Hishbonor bashsha Sihunor ze dosha goṭaisi, oḳon Bashon deshor beṭain-beṭin, huruttain, hoḳol gau-geram ar ṭaunre-o eḳoi laḳan binash ḳorsi. ");
INSERT INTO syll_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Oile tarar hoḳol foshur fal ar gonimotor mal-samana amra loia aisi. ");
INSERT INTO syll_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","“Amra ou shomoy Zordan gangor fub faror Amuri zatir duio bashshar doḳolor, Ornon ḳal taki Hormun faṛ forzonto ḳobza ḳorslam. ");
INSERT INTO syll_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(Sidonor manshe ou Hormun elaḳare Sirion ḳoia ḍaḳoin, ar Amuri zatie ḳoin Sonir.) ");
INSERT INTO syll_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Faṛia elaḳar ou tʼol zagar hoḳol ṭaun ar gau-geram, asta Giliod elaḳa, bashsha Uzor Suloḳa ar Idri ṭaun shoho asta Bashon deshre amra doḳol ḳorlam.” ");
INSERT INTO syll_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(Fura Rofayi zatir maze ḳali Bashon deshor bashsha Uz zita roisla. Ou bashsha luar falongo hutita, ikan lambae noy at ar faṛe sair at. Boni-Amman zatir Rabba ṭauno ikan oḳono toa ase.) ");
INSERT INTO syll_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Hozrot Musae aro ḳoira, “Amrar doḳol ḳora Ornon ḳalor faro Aruar ṭaunor bairor utoror elaḳa, ar faṛia Giliod elaḳar ordeḳ zaga, honor hoḳol ṭaun ar gau-geram oḳol, Boni Israilor Ruben ar Sadu ḳandanre dilailam. ");
INSERT INTO syll_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Giliod deshor baki ongsho ar bashsha Uzor ges taki ana asta Bashon deshre ami Manosha ḳandanor ordeḳ manshore dilam.” (Bashon deshor asta Orgub elaḳare Rofayi zatir desh ḳoia ḍaḳa oito. ");
INSERT INTO syll_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Manosha ḳandanor eḳ zonor nam asil Zayir, he asta Orgub elaḳa mani, Goshuri ar Maḳati zatir shimana forzonto doḳol ḳoria tar nizor namor mile ou Bashon deshor nam dilo Habbut-Zayir. Erlagi oḳono ikanre ou name ḍaḳa oy.) ");
INSERT INTO syll_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","“Ar Giliodor faṛia elaḳa ami Makirre dilam. ");
INSERT INTO syll_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Oile Giliod taki Ornonor faṛia ḳalor mazamazi forzonto hoḳol zaga, ar hon taki Boni-Amman zatir shimana Zabbuk kal forzonto ami Ruben ar Sadu ḳandanre dilam. ");
INSERT INTO syll_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Tarar deshor foismor shimana asil, Araba morubumit Zordan gangor ze ongsho Galil aoror daredi, Pisga namor faṛia elaḳar Araba shagor ba Luna shagor forzonto gese, ou zaga. ");
INSERT INTO syll_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","“Ou zaga oḳnain shomzai dia tarare ḳoilam, iknain bug-doḳol ḳorar lagi tumrar Mabud Allae tumrare disoin. Oile tumrar zeta beṭaintor shorilo bol ase, zera zuddo ḳorar laḳ, era zuit-zait oia Boni Israilor age gia gang far o. ");
INSERT INTO syll_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Oile tumrare deoa ṭaun ar gau-geramo tumrar bou, fua-fuṛin ar goru-sagol hoḳolta roiba. Ami zani tumrar bout foshu asoin. ");
INSERT INTO syll_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Bade Mabude zebla tumrar zatir baiainre tumrar laḳan aramor zaga dilaiba, tumrar Mabud Allae Zordan gangor hofaro tarare ze desh dan ḳorra, oḳanor doḳol faia harle, tumra hirbar amar deoa ou zagat firia aio.” ");
INSERT INTO syll_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Hozrot Musae tarare ḳoira, “Ou shomoy ami Iusare ḳoilam, tumrar Mabud Allae ou duio bashshar kun dosha goṭaisoin, ita to nizor souke deḳso. Te oḳon Zordan faroia tumra zoto deshainto zairae, Mabude ita hokkol deshaintor dosha-o ou laḳan goṭaiba. ");
INSERT INTO syll_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Erlagi tumra itare ḍoraio na, shoyong Alla Mabud tumrar fokko oia tarar loge zuddo ḳorba. ");
INSERT INTO syll_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","“Ar ou shomoy ami Mabudor dorbaro aroz ḳorlam, ");
INSERT INTO syll_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","O Mabud Moula, tumar gulamre to oḳon-u deḳani dorso, tumi koto mohan ar ḳoto boloban. Tumi ou zotota ḳorso, ita ḳorar shaiddo ḳar ase, asmano ba zominor kunu devtar takkot ase ni, tumar laḳan dafoṭ deḳaito? ");
INSERT INTO syll_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Moula go, amar boṛo shoḳ oilo, Zordan gangor hofaro gia tumar oada ḳora ou shundor faṛia elaḳa ar Lebanon desh deḳtam, meherbani kori zaite diba ni? ");
INSERT INTO syll_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Oile Mabude na ḳorla, tain amar arzi hunla na, tumrar ḳarone-u tain amar ufre naraz asla. Mabude zuaf dila, tumi bout ḳoiso, i befare ar mangio na. ");
INSERT INTO syll_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Aichcha, tumi ou Pisga ṭillar ufre uṭo, uṭia utore-douḳne ar fube-foisme souk falao. Zordan gang faroni nished oile-o, on taki ubaia hou deshre dekilao. ");
INSERT INTO syll_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Ar tumar ḳadim Iusare hikai deo, kita kita ḳora lagbo. Tar himmot baṛao, bitre shaosh deo, ḳaron hoḳol manshor age roia he gang far ḳoraibo, ar tumi on taki ze desh deḳrae, he eraredi ou desh doḳol ḳoraibo. ");
INSERT INTO syll_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Oḳan hunia amra Bayt-Piyuror samnor nisa zagat roigelam.” ");
INSERT INTO syll_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Hozrot Musae tarare ḳoila, “O Boni Israil, ami oḳon ze shoriot ar hukum-ahkam ḳoimu, ita tumra kial ḳori huno. Teu tumra zane basbae ar tumrar baf-dadar Mabud Allae tumrare ze desh dan ḳorra, hou desho gia doḳol ḳortae farbae. ");
INSERT INTO syll_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Ami tumrare ze hukum diar, i hukumor loge dusra kunta baṛaio na ba ḳomaio na. Ami zelaḳan ḳoiram, tumra ṭik ola-u tumrar Mabud Allar hoḳol hukum-ahkam mania solio. ");
INSERT INTO syll_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","“Tumra to nizor souke deḳso, age Mabude Baal-Piyuror befare kita ḳorsoin. Tumrar mazor zoto zone Piyur elaḳar Baal devtar puja ḳorsil, Alla Mabude tumrar samne ita hokkolṭire binash ḳorsoin. ");
INSERT INTO syll_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Oile tumra zera dile-zane Alla Mabudor ashik aslae, tumra hoḳol-u oḳono zinda roiso. ");
INSERT INTO syll_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","“Oḳon huno, amar Mabud Allae amare zelaḳan hukum-ahkam disla, ami tumrare ṭik ou hukum-ahkam ar niom-ḳanun hikaisi. Zate tumra oḳon ze desh doḳol ḳorat zairae, hou desho ita ḳamo lagao. ");
INSERT INTO syll_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Erlagi tumra kub hushiar oia ita manio, ar ḳamo lagaio. Teu bad-baki tamam zatir gese-u ita tumrar aḳol-buddi hishabe zair oibo. Ou hukum-ahkamor ḳota hunle tara ḳoiba, hasau era kub boṛo zati ar aḳol-buddi ala zati. ");
INSERT INTO syll_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Ar amrar Mabud Alla zela amrar loge loge roin, tanre ḍakile zela daro fai, ou duniar bukut dusra kunu boṛo zati asoin ni, zetar devta ola loge loge roin? ");
INSERT INTO syll_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Ba ami oḳon ze shoriotor ḳota ḳoiram, ita dusra kunu boṛo zatir ase ni? Ila niom-ḳanun ar nikut hukum-ahkam tarar ase ni? ");
INSERT INTO syll_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","“Oile tumra zotodin basia roibae, otodin nizor befare kub hushiar roio, nizor dilre shabdane rakio, arnae nizor sokur deḳa goṭona oḳol faurilibae, ita tumrar dil taki kuailibae. Ar ou hukum-ahkam tumrar fua-fuṛinre hikao, tara-o ola tarar aoladre hikaiba. ");
INSERT INTO syll_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Ar tumra hou dinor goṭona mono ḳoro, ze din tumra Tur faṛo afon Mabud Allar samne azir oislae. Zebla tain amare ḳoisla, amar kalam hunar lagi tumi hokkol manshore dola ḳoria amar samne ano, teu tara hikba, i zogoto tara zotodin zinda roiba, otodin amare ḍoraia roita, ar tarar huruttainre-o ola solar talim dita. ");
INSERT INTO syll_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Ou shomoy tumra ḳandat gia ou faṛor lamat ubaislae, ubaia deḳlae, asta faṛo dau dau ḳori nuror aguin zoler, aguine gia asman soilise, ar goin gono megor ḳalnie andair asil. ");
INSERT INTO syll_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Hou nuror agunir bitre taki, Mabude tumrare tan kalam hunaila. Tumra tan mukor aoaz hunlae, oile tan kunu surot-aḳar deḳaisoin na, ḳali tan golar aoaz huncho. ");
INSERT INTO syll_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Tain nize tumrare tan loge milonor usillar Allai oada-chuktir ḳas doshṭa hukum-ahkam dila, ar ḳoila oguin mania solar lagi. Tan kudroti ate dui ṭukra fattoror ufre ita lekia-o dila. ");
INSERT INTO syll_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Hou shomoy Mabude amare hukum dila, ami tumrare tan shoriotor hukum-ahkam hikaitam, zate Zordan gangor hofaro tumra ze desh doḳolo zairae, hono gia harle ota mania solo. ");
INSERT INTO syll_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","“Mabude zebla nuror agunir maz taki Tur faṛo tumrar loge batchit ḳorsla, hou din to tumra tan kunu surot-aḳar deḳso na. Erlagi tumra nizor befare kub hushiar roio ");
INSERT INTO syll_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","zate kunu murti na banao, be-foti bonia puja ḳorar kiale kunu beṭa ba beṭir surote murti banaio na. ");
INSERT INTO syll_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","Maṭir ufre solra kunu zib-zanuaror surote, asmano uṛra kunu fakir surote, ");
INSERT INTO syll_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","buk sesraia solra kunu zandaror surote, ba fanit roura kunu zandaror surote murti banaio na. ");
INSERT INTO syll_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Asmanedi saia hari sand, shuruz, tera oḳol dekia ou namor deb-debi ba firistar puja ḳorio na, erar kezmoto lagio na. Itare to tumrar Mabud Allae asmanor tolor hoḳol zatir lagi dan ḳorsoin. ");
INSERT INTO syll_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Mono rakio, Mabude tumrare fosond ḳorsoin lua golanir gorom agunir gato taki, tain Mishor desh taki tumrare bar ḳori anchoin, zate tumra tan afon proza o, ar oḳon to hasau tan proza oiso. ");
INSERT INTO syll_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","“O Boni Israil, tumrar ḳarone Mabude amar ufre-o gusa ḳorsoin. Tain ḳosom ḳaia ḳoisoin, amare Zordan gangor hofaro zaite dita nae, tumrar Mabud Allae tumrare ze deshor malikana dira, ou aramor desho amar zaoa nished. ");
INSERT INTO syll_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Amar mout ono-u oibo. Zordan gang faronir hukum nae. Oile tumra gang faroia hou aramor desh doḳol ḳorat zairae. ");
INSERT INTO syll_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Te tumra nizor befare hushiar roio, tumrar Mabud Allae tumrar loge ze oada-chukti kaim ḳorsoin, ita faurio na. Tumrar Mabud Allar nished omainno ḳoria kunu zinishor murti banaio na. ");
INSERT INTO syll_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Mono rakio, tumrar Mabud Alla to moha dongshor agunir laḳan, tain to la-shorik, kunu shorik shoijjo ḳoroin na, tan nizor faona ebadot sain-u sain.” ");
INSERT INTO syll_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Hozrot Musae tarare eoḳan ḳoila, “Hou aramor desho gia hari, tumra fua-fuṛin, nati-futir zonom dia bout din boshot ḳorar bade-o zudi ku-fote zaogi, ar kunu zinishor surote murti banao, tumrar Mabud Allae zetare ginna ḳoroin, tumra ota ḳoro, ");
INSERT INTO syll_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","te ami oḳon asman-zomin shakki rakia tumrar birudde ḳoiar, Zordan gang faroia ze desh doḳol ḳorat zairae, hino kub zoldi tumrar nam miṭizibo. Beshi din ṭiktae fartae nae, nichchit binash oibae. ");
INSERT INTO syll_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Mabude tumrare nanan zatir maze sitrai diba, tain ḳedai dia zeḳano faṭaiba, hono tumrar kub ḳom manush zinda roiba. ");
INSERT INTO syll_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Ou halote tumra manush-ate banail murtir puja ḳorbae, zetae souke deḳe na, ḳane hune na, ḳaito fare na, kunuzat geran-o hungito fare na, laḳṛir ar fattoror ota murtir puja ḳorbae. ");
INSERT INTO syll_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Ta-o hono roia zudi tumra nizor Mabud Allar tallash ḳoro, te tain tumrare didar diba. Ḳota oilo, dile-zane ḳator oia tane ḍakite oibo. ");
INSERT INTO syll_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Hesh-mesh tumra mosiboto foṛia hirbar touba ḳoria, tumrar Mabud Allar nam loibae, ar tan kushi mafik solbae. ");
INSERT INTO syll_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Mono rakio, tumrar Mabud Alla rohmanur rohim, tain tumrare falaita nae ba binash ḳorta nae. Ar tain ḳosom ḳaia tumrar moy-murobbir loge ze oada-chukti korsoin, ita-o faurita nae.” ");
INSERT INTO syll_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Hozrot Musae tarare eoḳan ḳoira, “Alla Pake zomino manush foyda ḳorar bad taki oḳon forzonto, tumrar agor hokkol zomanar itihash tukao, asta asman-zominor eḳ mata taki aroḳ mata tukaia deḳo, Boni Israilor ufre zoto azob goṭona goṭise, ita laḳan dusra kunu goṭona goṭse ni? Ba ila kunta kunudin huna gese ni? ");
INSERT INTO syll_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Ar nuror aguin taki Alla Pakor buli hunar bade, ḳali tumra saṛa dusra kunu zati zinda roise ni? ");
INSERT INTO syll_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Tumra tallash ḳori deḳo, tumrar Mabud Allae tumrar sokur samne Mishor desho tumrar lagi zotota ḳorsoin, asta zogotor kunu deb-debie ila ḳorto farse ni? Ila forikka loa, kudroti nishana deḳani, laṛai-zuddo ḳora, mozbut ator bol deḳani, boṛo boṛo taijjubi lila-ḳela ar ḍor-ḳof deḳaia, zekunu zatire oinno zatir bitre taki bar ḳori ania nizor proza banaito farse ni? ");
INSERT INTO syll_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","“Te tumra zate furafur buzo, ou Alla-u oila Mabud, tain saṛa ar kunu Mabud nai, oḳan buzanir lagi-u tumrare otota deḳani oisil. ");
INSERT INTO syll_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Tumrare hedayot ḳorar kiale tain behestor arosh taki tan nizor buli hunaila, ar zominor ufre deḳaila nuror agunir kunḍoli. Ou agunir maz taki baroil Allai buli tumra huncho. ");
INSERT INTO syll_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Tain tumrar moy-murobbi oḳolre mohobbot ḳorta, erlagi erar moutor bade tarar aolad oḳolre-o fosond ḳorsoin. Ar tain shoyong azir oia tan moha kudroti kemota ḳaṭaia tumrare Mishor desh taki bar ḳori anchoin. ");
INSERT INTO syll_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","Tan kial asil, tumatan taki boṛo ar boloban zati oḳolre tumrar samon taki kedaia hari, tarar desho nia hou hoḳol deshor malikana tumrare dita. Oḳon deḳrae ni, tain to ita ḳorsoin. ");
INSERT INTO syll_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","“Te oḳonkur ou talim mono rakio, dilor maze gatia toio, huno, ḳali ou Alla-u ufre asman ar tole zominor malik, tain saṛa dusra kunu Mabud nai. ");
INSERT INTO syll_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Erlagi ami oḳon ze shoriot ar hukum-ahkam zanairam, tumra ita mania solio, teu tumra ar tumrar aolad oḳlor balai oibo. Tumrar Mabud Allae siroḳalor lagi tumrare ze desh dan ḳorra, ou desho tumrar hayati lamba oibo.” ");
INSERT INTO syll_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Bade Musa nobie Zordan gangor fub-faror tinḳan ṭaun algaila, ");
INSERT INTO syll_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","zate kunu kuni manush bagia gia ou ṭauno zan basaito fare. Ze manshe kun ḳorar kunu sinta ba dushmoni bab asil na, ḳali aḳta onichchae ḳeurore marilae, he bagia bonobashi bonia ono roito farbo. ");
INSERT INTO syll_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Tino ṭaun oilo, Ruben ḳandanor lagi morubumir kinarar faṛia tʼol zagar Basir namor ṭaun. Sadu ḳandanor lagi Giliod elaḳar Ramut ṭaun. Manosha ḳandanor lagi Bashon deshor Golan ṭaun. ");
INSERT INTO syll_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Musa nobie Boni Israilor samne shoriotor ou hukum boyan ḳorla, ");
INSERT INTO syll_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Mishor desh taki bar oia aoar bade, hoḳol hushiarir ḳota, shoriotor niom-ḳanun ar hukum-ahkam Boni Israilre zanaila. ");
INSERT INTO syll_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","Tain Zordan gangor fubor faro, Hishbon elaḳar Amuri zatir raza Sihunor deshor Bayt-Piyuror samnor tol zagat ita ḳoila. Mishor taki bar oia aia harle Musa nobie ar Boni Israile zuddo ḳori ou bashsha Sihunre araisla. ");
INSERT INTO syll_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","Tara bashsha Sihunor desh ar Bashonor bashsha Uzor desh doḳol ḳorsla. Amuri zatir ou duio bashshar bashshai asil Zordan gangor fubor faro. ");
INSERT INTO syll_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Ornon ḳalor faror Aruar ṭaun taki Sirion faṛ, mani Hormun faṛ forzonto ou duio razar shimana asil. ");
INSERT INTO syll_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","Er bitre ase Zordan gangor fubor faror asta elaḳa. Ikṭa Pisga faṛor ṭillar toledi Araba shagoror kinara forzonto gese. ");
INSERT INTO syll_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Musa nobie tamam Boni Israilre dola ḳoraila, tarare ḳoila, “O Boni Israil, ami oḳon zeta hukum-ahkam ar ain-ḳanun tumrare zanaimu, ita tumra kial ḳori hunio, hunia dilo gatia rakio ar amol ḳorio. ");
INSERT INTO syll_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Amrar Mabud Allae Tur faṛo amrar loge eḳ oada-chukti boail ḳorsoin. ");
INSERT INTO syll_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Ou chukti tain amrar moy-murobbir loge na ḳoria, amrar loge ḳorsoin, amra zoto zon ono zinda asi, amrar loge ḳorsoin. ");
INSERT INTO syll_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Mabude ou faṛor ufre nuror agunir maz taki tumrar loge samna-samni batchit ḳorsoin. ");
INSERT INTO syll_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Tumra agunir ḍore hou shomoy faṛor ufre uṭlae na, erlagi ami tumra ar Mabudor mazḳano ubaia, tan mukor buli tumrare hunaisi. Tain ḳoisla, ");
INSERT INTO syll_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“Ami Alla-u tumrar Mabud. Mishor deshor gulami taki ami-u tumrare ḳalas ḳori anchi. ");
INSERT INTO syll_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“Amar bodla tumra dusra kunu devta manio na. ");
INSERT INTO syll_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","“Puja ḳorar kiale tumra kunu murti banaio na, asman, zomin ba fanir tole zotota ase, ita kunutar surote murti banaio na. ");
INSERT INTO syll_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Tumra itar puja ḳorio na, itar sheba-zoton ḳorio na. Mono rakio, ami Alla-u tumrar Mabud, kunu shorik shoijjo ḳori na. Amare zera mane na, ami tarar gunar shaza dei, tarar foyla siṛi taki sair siṛi aolad forzonto shaza dei. ");
INSERT INTO syll_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","Oile zera amar ashik bonia amar hukum-ahkam amol ḳore, ami tarar azar azar oarish forzonto amar obiram maya-mohobbot deḳaimu. ");
INSERT INTO syll_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","“Beḳama kunu ḳarone tumrar Mabud Allar nam muko 