﻿USE sofia;
DROP TABLE IF EXISTS sofia.syl_vpl;
CREATE TABLE syl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES syl_vpl WRITE;
INSERT INTO syl_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","পয়লাউ আল্লায় আছমান আর দুনিয়া পয়দা করলা। ");
INSERT INTO syl_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","দুনিয়াই নিরাকার আর খালি আছিল, গইন পানির উপরে পুরা আন্দাইর আছিল। আল্লার রুহ এর উপরে চলাচল করতা। ");
INSERT INTO syl_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","বাদে আল্লায় ফরমাইলা ফর অউক, আর ফর অইলো। ");
INSERT INTO syl_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","আল্লায় দেখলা ফর ভালা। তাইন আন্দাইর থাকি ফররে আলগা করিয়া ");
INSERT INTO syl_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","এর নাম রাখলা দিন, আর আন্দাইরর নাম রাখলা রাইত। হাইঞ্জা গেল, বিয়ানও গেল, ইকটা অইলো পয়লা দিন। ");
INSERT INTO syl_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","বাদে আল্লায় ফরমাইলা, পানির মাজে গুম্বুজর লাখান ফাক জাগা অউক, আর পানি দুই ভাগ অইযাউক। ");
INSERT INTO syl_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","আর আল্লায় ফাক জাগা পয়দা করিয়া, তলর আর উপরর পানি আলগা করলা। আর অউলা অইলো। ");
INSERT INTO syl_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","আল্লায় গুম্বুজর লাখান যে জাগা বানাইলা, তার নাম রাখলা আছমান। হাইঞ্জা গেল, বিয়ানও গেল, ইকটা অইলো দুই নম্বর দিন। ");
INSERT INTO syl_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","এরবাদে আল্লায় ফরমাইলা, আছমানর তলর পানি এক জাগাত দলা অউক, আর হুকনা জাগা দেখা যাউক। আর অউলা অইলো। ");
INSERT INTO syl_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","আল্লায় হুকনা জাগার নাম রাখলা জমিন আর জমাইল পানির নাম দরিয়া। তাইন দেখলা ইতা ভালা। ");
INSERT INTO syl_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","বাদে আল্লায় ফরমাইলা, জমিনো ঘাস ফলউক; আর হকল জাতর বিচআলা লতা-পাতা গাছ-গাছালির জনম অউক। আর জমিনর উপরে হকল জাতর ফলর গাছও অউক, এরা নিজর জাতমত ফল ধরবো আর ফলর মাজে যারযির বিচও থাকবো। আর অউলা অইলো। ");
INSERT INTO syl_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","জমিনো ঘাস ফলিলো, হকল জাতর বিচআলা লতা-পাতা গাছ-বিরিক জন্মিলো। জমিনর উপরে হকল জাতর ফলর গাছ অইলো যেতায় যারযির জাতমত ফল ধরে, হি ফলর মাজে যারযির বিচও আছে। আল্লায় দেখলা ইতা ভালা। ");
INSERT INTO syl_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","হাইঞ্জা গেল, বিয়ানও গেল, ইকটা অইলো তিন নম্বর দিন। ");
INSERT INTO syl_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","বাদে আল্লায় ফরমাইলা, আছমানর মাজে অউলা চেরাগ অকল অউক, যারা রাইত থাকি দিনরে আলগা করে। ইতা আলগা আলগা দিন, বছর আর ইদ-উৎসবর নিশানা অইবো। ");
INSERT INTO syl_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","আছমান থাকি তারা দুনিয়াইর উপরে ফর দিবো। অউলাউ অইলো। ");
INSERT INTO syl_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","আল্লায় দুইটা বড় চেরাগ বানাইলা, এরমাজে বড়টারে দিনর উপরে বাদশাই করার লাগি আর হুরুটারে রাইতর উপরে। ইতা ছাড়া তাইন তেরা অকলও পয়দা করলা। ");
INSERT INTO syl_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","তাইন এরারে আছমানর মাজে বওয়াইলা যাতে তারা দুনিয়াইত ফর দেয়। ");
INSERT INTO syl_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","এরা দিন আর রাইতর উপরে বাদশাই করে, আন্দাইর থাকি ফররে আলগা করে। আল্লায় দেখলা ইতা ভালা। ");
INSERT INTO syl_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","হাইঞ্জা গেল, বিয়ানও গেল, ইকটা অইলো চাইর নম্বর দিন। ");
INSERT INTO syl_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","বাদে আল্লায় ফরমাইলা, পানির মাজে জানদার অকল পালে পালে ভরি যাউক, আর দুনিয়াইর উপরে আছমানর মাজে পাখিন উড়উক। ");
INSERT INTO syl_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","আর আল্লায় দরিয়ার বিরাট জানদার অকল, আর পানির মাজে পাল বান্দিয়া ঘুররা হকল জাতর জানদার পয়দা করলা, আর হকল জাতর পাখিও পয়দা করলা। তাইন দেখলা ইতা ভালা। ");
INSERT INTO syl_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","তাইন তারা হকলরে অউ লাখান বরকত নাজিল করলা, তুমরা ফলআলা অইয়া বাড়ো আর দরিয়ার পানি ভরি যাও, দুনিয়াইর মাজে পাখি অকলও বাড়উক। ");
INSERT INTO syl_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","হাইঞ্জা গেল, বিয়ানও গেল, ইকটা অইলো পাচ নম্বর দিন। ");
INSERT INTO syl_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","এরবাদে আল্লায় ফরমাইলা, মাটি থাকি অউলা জানদার অউক যারার নিজর জাত অকলরে বাড়াইবো, এরার মাজে পালা হেমান, মাটিত চলরা হুরু-মুরু জানদার আর জংলি জানুয়ার অকলও। অউলাউ অইলো। ");
INSERT INTO syl_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","আল্লায় দুনিয়াইর মাজে হকল জাতর জংলি জানুয়ার, পালা হেমান আর মাটির মাজে বুকে চলরা জানদার বানাইলা। তাইন দেখলা ইতা ভালা। ");
INSERT INTO syl_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","এরবাদে আল্লায় ফরমাইলা, আও আমরার ছুরতে আমরার লগে মিল রাখিয়া মানুষ বানাই। তারা দরিয়ার মাছ, আছমানর পাখি, জানুয়ার, মাটির মাজে বুকে চলরা জানদার, আর আস্তা দুনিয়াইর উপরে বাদশাই করউক। ");
INSERT INTO syl_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","তাইন তান নিজর ছুরতে মানুষ পয়দা করলা, এক্কেরে নিজর মত করি পয়দা করলা, পয়দা করলা বেটা আর বেটি। ");
INSERT INTO syl_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","আর তারারে বরকত নাজিল করিয়া কইলা, তুমিতাইন ফলআলা অইয়া বাড়িয়া দুনিয়াই ভরি যাও। দুনিয়াইরে শাসন করো, আর দরিয়ার মাছ, আছমানর পাখি, মাটির উপরে চলরা হকল জানদারর উপরে বাদশাই করো। ");
INSERT INTO syl_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","এরবাদে আল্লায় ফরমাইলা, হুনো, দুনিয়ার উপরর হকল জাতর বিচআলা গাছ-বিরিক, আর হকল জাতর ফলর গাছ যারার নিজর জাতমত ফল ধরে যার ফলর মাজে তারার নিজর বিচ আছে, ইতা হকলতা আমি তুমরার খানির লাগি দিলাম। ");
INSERT INTO syl_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","দুনিয়ার পরতেক জানুয়ার, আছমানর পাখিন, মাটির মাজে বুকে চলরা জানদার, ইতা হক্কল জানদারর খানির লাগি আমি হকল লতা-পাতা আর ঘাস দিলাম। অউলাউ অইলো। ");
INSERT INTO syl_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","আল্লায় তান পয়দা করা হকলতা দেখলা, ইতা হকলতাউ খুব ভালা অইছে। হাইঞ্জা গেল, বিয়ানও গেল। ইকটা অইলো ছয় নম্বর দিন। ");
INSERT INTO syl_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","অউ লাখান আছমান-জমিন আর এর মাজর হকলতা পয়দা করা শেষ অইলো। ");
INSERT INTO syl_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","আল্লায় ই হকল কাম শেষ করিয়া হারলে সাত নম্বর দিন আরাম করলা, তাইন ইদিন আর কুন্তা পয়দা করলা না। ");
INSERT INTO syl_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","অউ সাত নম্বর দিনরে বরকত নাজিল করিয়া পাক দিন করলা, তান হকলতা পয়দা করা শেষ করি তাইন অউ দিন জিরাইলা। ");
INSERT INTO syl_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","অউ অইলো আছমান আর জমিন পয়দার বয়ান। মাবুদ আল্লায় যেবলা আছমান আর জমিন পয়দা করছিলা, ");
INSERT INTO syl_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ই সময় জমিনর উপরে কুনুজাতর গাছ-পালা আছিল না আর কুনু লতা-পাতাও ফলিছে না, কারন তাইন জমিনর উপরে মেঘ দিছইন না, আর জমিন আবাদ করার মানুষও আছিল না। ");
INSERT INTO syl_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","অউ সময় মাটির মুর থাকি পানি উঠতো আর জমিন ভিজতো। ");
INSERT INTO syl_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","বাদে মাবুদ আল্লায় ফেক মাটি দিয়া মানুষ বানাইয়া তার নাকর মাজে ফু দিয়া জান হারাইলা। আর অউ মানুষ জানদার অইলো। ");
INSERT INTO syl_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","মাবুদ আল্লায় পুবেদি আদান নামর জাগাত এক বাগান করছিলা, হনো তানর বানাইল অউ মানুষরে রাখলা। ");
INSERT INTO syl_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","হিখানর মাটিত তাইন অউ লাখান গাছ অকল ফলাইছলা, যেতা দেখতে খুব সুন্দর আর ফলও খাইতে খুব মজা। আর বাগানর মাজখানো তাইন “জিন্দেগি-গাছ” আর “নেকি-বদির আখল দেওরা গাছ” নামর দুইটা গাছও রাখছিলা। ");
INSERT INTO syl_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","হউ বাগানো পানি যুগাইয়া দিতো এক গাং আছিল, যেকটা আদানর মাজেদি বার অইয়া চাইর ভাগ অইগেছিল। ");
INSERT INTO syl_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","পয়লা গাংগর নাম আছিল পিশোন, ইকটা আস্তা হবিলা দেশর ভিতরে দিয়া গেছে। ইনো সোনা পাওয়া যায়, ");
INSERT INTO syl_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","আর অউ দেশর সোনা খুব খাটি, ইতা ছাড়াও হিনো মেশকে-আম্বর আর আকিক মনি পাওয়া যায়। ");
INSERT INTO syl_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","দুই নম্বর গাংগর নাম জিহোন, ইকটা আস্তা কুশ দেশর ভিতরে দিয়া গেছে। ");
INSERT INTO syl_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","তিন নম্বর গাংগর নাম দজলা, ইকটা আশিরিয়া দেশর পুবে দিয়া গেছে। আর চাইর নম্বর গাংগর নাম অইলো ফোরাত। ");
INSERT INTO syl_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","বাদে মাবুদ আল্লায় অউ মানুষরে আদান বাগানো রাখলা, হিনো খেত-খামার আর হেফাজত করার লাগি। ");
INSERT INTO syl_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","তাইন আদমরে হুকুম দিলা, “তুমি তুমার খুশিমত ই বাগিচার যেকুনু গাছর ফল খাইতায় পারবায়, ");
INSERT INTO syl_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","খালি নেকি-বদির আখলর গাছর ফল খাইও না, যেদিন তুমি অউ গাছর ফল খাইবায় ইদিন তুমি মরবায়উ মরবায়।” ");
INSERT INTO syl_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","এরবাদে মাবুদ আল্লায় কইলা, “মানষর লাগি একলা থাকা ভালা নায়। আমি তার লাখ একজন জুড়ি বানাইমু।” ");
INSERT INTO syl_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","আর মাবুদ আল্লায় দুনিয়াইর হকল জানদার আর আছমানর হকল পাখি মাটিদি বানাইয়া অউ মানষর ছামনে আনলা, দেখলা এইন ইতারে কিতা কইয়া ডাকইন, আর তাইন যারে যে নামে ডাকলা, তার অউ নাম অইলো। ");
INSERT INTO syl_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","আদমে হকল পালা হেমান, আছমানর পাখি আর জংলি জানুয়ারর নাম রাখলা, ইতার মাজে তান লাখ কুনু জুড়ি মিললো না। ");
INSERT INTO syl_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","এরবাদে তাইন আদমর মাজে বেহুশি ঘুম আনলা। অউ ঘুমর মাজে তান পাইঞ্জরর একটা আড্ডি খুলিয়া নিয়া জাগাটা বন্দ করি দিলা, ");
INSERT INTO syl_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","আর অউ আড্ডি দিয়া মাবুদ আল্লায় এক বেটিমানুষ বানাইয়া আদমর গেছে আনলা। ");
INSERT INTO syl_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","তানে দেখিয়া আদমে কইলা, “অখন অইছে, তাই আমার আড্ডির আড্ডি, গোস্তর গোস্ত। তাইর নাম অইবো নারী, তাইরে নর থাকি নেওয়া।” ");
INSERT INTO syl_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","এরলাগি বেটাইন্তে মা-বাফরে ছাড়িয়া বউর লগে রইবা, তারা দুইওজন এক শরিল অইবা। ");
INSERT INTO syl_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","আদম আর তান বিবির শরিল উদাম থাকতো, ইতা কুনু শরম আছিল না। ");
INSERT INTO syl_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","মাবুদ আল্লার পয়দা করা জমিনর হকল জানদারর মাজে হাফ অইলো হকল থাকি ফন্দিবাজ। অউ হাফে একদিন হি বেটি মানষরে কইলো, “আল্লায় হাছাউ তুমাতানরে কইছইন নি, বাগানর হকল গাছর ফল তুমরা খাইতায় পারতায় নায়?” ");
INSERT INTO syl_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","বেটিয়ে কইলা, “বাগানর যেকুনু গাছর ফল আমরা খাইতাম পারি, ");
INSERT INTO syl_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","খালি বাগানর মাজখানো যে গাছটা আছে, আল্লায় কইছইন, তুমরা এর ফল খাইও না, ছইও-ও না, ছইলেউ মরবায়।” ");
INSERT INTO syl_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","অউ হাফে তানরে কইলো, “না, কুনুমন্তেউ মরতায় নায়। ");
INSERT INTO syl_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","আল্লায় তো জানইন, যেদিন তুমরা ই গাছর ফল খাইলিবায় ইদিন তুমরার চউখ খুলিযিবো, আর নেকি-বদির আখল পাইয়া তুমরা আল্লার লাখান অইযিবায়।” ");
INSERT INTO syl_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","বেটিয়ে যেবলা বুজলা, অউ গাছর ফল খাইতে মজা অইবো, দেখতেও সুন্দর, আর আখলদারও অইযিমু, অউ তাইন ফল পাড়িয়া খাইলা, আর তান জামাইরেও দিলা আর জামাইয়েও খাইলিলা। ");
INSERT INTO syl_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","লগে লগে তারা দুইও জনর চউখ খুলি গেল, আর বুজলা তাইন-তাইন লেমটা। অউ তারা ডুমুর গাছর কয়টা পাতা ছিড়িয়া সিলাই করি লেমটি বানাইলা। ");
INSERT INTO syl_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","হাইঞ্জা বালা তারা মাবুদ আল্লার আওয়াজ হুনলা, তাইন বাগানর মাজে পাকানিত আইরা। তেউ আদম আর তান বউ মাবুদ আল্লার ছামনে না পড়ার লাগি বাগানর গাছর আওড়ে লুকাইলা। ");
INSERT INTO syl_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","মাবুদ আল্লায় আদমরে ডাক দিয়া জিকাইলা, “তুমি কুয়াই?” ");
INSERT INTO syl_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","তাইন কইলা, “বাগানর মাজে আমি তুমার আওয়াজ হুনছি। আমি তো লেমটা, এরলাগি ডরাইয়া লুকাই রইছি।” ");
INSERT INTO syl_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","তেউ মাবুদ আল্লায় জিকাইলা, “তুমি যে লেমটা কে কইলো? যে গাছর ফল খাইতে তুমারে না করছিলাম, খাইলিছো না কিতা?” ");
INSERT INTO syl_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","আদমে কইলা, “যে বেটিমানুষ তুমি আমার লগে দিছো, তাই অউ গাছর ফল আমারে খাওয়াইছে।” ");
INSERT INTO syl_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","অউ মাবুদ আল্লায় বেটিরে জিকাইলা, “তুমি ইতা কিতা করলায়?” তাইন কইলা, “হাফে আমারে ছাল্লা দিয়া খাওয়াইছে।” ");
INSERT INTO syl_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","তেউ মাবুদ আল্লায় হাফরে কইলা, “তুমার ই কামর লাগি হকল পালা হেমান আর হকল জংলি জানুয়ারর মাজে তুমিউ লান্নতি অইলায়। তুমি জিন্দেগিভর পেটো ভরদি চলবায় আর ধুলা-বালু খাইবায়। ");
INSERT INTO syl_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","আমি তুমার আর বেটির মাজে, তুমার বংশ আর বেটি মানষর বংশর মাজে দুশমনি পয়দা করমু। হি বংশে তুমার কল্লা গুড়া করবো, আর তুমি তার পাওর মুরাত কামড়াইবায়।” ");
INSERT INTO syl_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","আর তাইন বেটিরে কইলা, “তুমার হুরুতা অইবার সময় তুমার মছিবত খুব বাড়াই দিমু, তুমি খুব কষ্ট করিয়া হুরুতা পয়দা করবায়। জামাইর বায় তুমার খুব খাইশ থাকবো, আর হে তুমার উপরে বেটাগিরি করবো।” ");
INSERT INTO syl_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","তাইন আদমরে কইলা, “যে গাছর ফল আমি হারাম করিয়া দিছলাম, তুমি তুমার বউর কথা হুনিয়া ইতা খাইছো, অউ কারনে জমিনরে লান্নতি করা অইলো। জিন্দেগিভর জবর তকলিফ করিয়া তুমি জমিনর ফসল খাইবায়। ");
INSERT INTO syl_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","তুমার লাগি মাটির মাজে কাটা-গছা আর বিষআলা জংগল জন্মাইবো, আর তুমার খানি অইবো অউ মাটির ফয়-ফসল। ");
INSERT INTO syl_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","যে মাটি থাকি তুমারে পয়দা করছলাম, হউ মাটিত ফিরিয়া না যাওয়া পর্যন্ত তুমার মাথার ঘাম পাওত ফালাইয়া খানি খাইবায়। তুমার মাটির শরিল, মাটিতউ মিশিযিবো।” ");
INSERT INTO syl_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","আদমে তান বিবির নাম রাখলা হাওয়া মানি, জিন্দেগি-দেওরা, কারন তাইন হকল জিন্দা মানষর মা অইবা। ");
INSERT INTO syl_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","আদম আর তান বিবির লাগি মাবুদ আল্লায় জানুয়ারর চামড়াদি লেবাছ বানাইয়া ফিন্দাইলা। ");
INSERT INTO syl_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","এরবাদে মাবুদ আল্লায় কইলা, “দেখো, নেকি-বদির আখল পাইয়া মানুষ আমরার লাখান অইগেছে, অখন হে যাতে আত বাড়াইয়া জিন্দেগি-গাছর ফল খাইয়া হামেশা জিন্দা না রয়।” ");
INSERT INTO syl_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","অউ কথা কইয়া মাবুদ আল্লায় যে মাটি দিয়া মানষরে পয়দা করছলা, হউ মাটিত খেত-খামার করার লাগি তারে আদান বাগান থাকি খেদাই দিলা। ");
INSERT INTO syl_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","খেদাই দিয়া তাইন জিন্দেগি-গাছর গেছে যাওয়ার পথ পারা দেওয়ার লাগি আদান বাগানর পুবেদি কারুবী ফিরিস্তা অকল রাখলা আর আগুইনর তলোয়ারও ঘুরানিত রাখলা। ");
INSERT INTO syl_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","আদমে তান বিবি হাওয়ার লগে মিলার বাদে তান পেটো হুরুতা আইলো, আর কাবিল নামে তান এক পুয়ার জনম অইলো। তেউ বিবি হাওয়ায় কইলা, “মাবুদর গেছ থনে আমি এক মানুষ কবুল করছি।” ");
INSERT INTO syl_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","হিরবার তান ঘরো কাবিলর ভাই হাবিলর জনম অইলো। হাবিলে ছাগল-মেড়া রাখতো, আর কাবিলে খেত করতো। ");
INSERT INTO syl_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","বাদে একদিন কাবিলে মাবুদর গেছে তার খেতর ফয়-ফসল আনিয়া লিল্লা দিলো ");
INSERT INTO syl_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","আর হাবিলেও তার পালর মাজে পয়লা জন্মিছে অউলা কয়টা ছাগল-মেড়া জবো করিয়া চর্বিআলা অংশ লিল্লা দিলো। মাবুদে হাবিল আর তার লিল্লা কবুল করলা, ");
INSERT INTO syl_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","কাবিল আর তার লিল্লা কবুল করলা না, গতিকে হে খুব গুছা করিয়া মুখ কালা করলো। ");
INSERT INTO syl_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","মাবুদে কাবিলরে কইলা, “তুমি গুছা কররায় কেনে, আর কিতার লাগি তুমি মুখ কালা করছো? ");
INSERT INTO syl_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","তুমি ভালা কাম করলে তুমার মুখ ফর অইলো অনে? আর না করলে তো গুনায় তুমারে ধরার লাগি তুমার দুয়ারো উবাই রইছে। ইগুর উপরে তুমি জিততে অইবো।” ");
INSERT INTO syl_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","বাদে কাবিলে তার ভাই হাবিলরে ডাকিয়া কইলো, “আও আমরা বন্দো যাই।” আর বন্দো গিয়া তার ভাই হাবিলর উপরে আখতা হামলা করিয়া খুন করলো। ");
INSERT INTO syl_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","হেশে মাবুদে কাবিলরে জিকাইলা, “তুমার ভাই কুয়াই?” কাবিলে কইলো, “আমি জানি না, আমার ভাইরে আমি দেখা-হুনা করি নি?” ");
INSERT INTO syl_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","তেউ মাবুদে কইলা, “তুমি ইতা কিতা করলায়? দেখো, জমিন থাকি তুমার ভাইর লউয়ে আমার গেছে ফরিয়াদ করের। ");
INSERT INTO syl_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","জমিনে যেবলা তুমার কারনে তুমার ভাইর লউ খাইলো, অউ সময় তুমি লান্নতি অইয়া জমিন থাকি খেদাইল অইলায়। ");
INSERT INTO syl_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","তুমি যেবলা জমিনো খেত করবায়, জমিনে আর তুমারে ফসল দিতো নায়। তুমি বৈতল অইয়া দুনিয়াই জুড়ি ঘুরবায়।” ");
INSERT INTO syl_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","তেউ কাবিলে মাবুদরে কইলো, “ই শাস্তি আমার আংগাজ অইতো নায়। ");
INSERT INTO syl_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","আইজ তুমি আমারে জমিন থাকি খেদাই দিরায়, আমি তুমার ছামনে থনে হরি যাইমুগি। আর বৈতল অইয়া যেবলা আমি দুনিয়াইত ঘুরমু, অউ সময় যার ছামনেউ আমি পড়মু, হে-উ আমারে খুন করবো।” ");
INSERT INTO syl_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","মাবুদে তারে কইলা, “তে তুমারে যে খুন করবো, তার উপরে আমি সাতগুন বদলা লইমু।” অউ কথা কইয়া মাবুদে কাবিলরে একটা চিন্নত দিলা, যাতে কেউ তারে আতো পাইয়াও না মারে। ");
INSERT INTO syl_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","এরবাদে কাবিল মাবুদর ছামন থাকি হরিয়া আদানর পুবেদি নোদ মানি, ঘুরা-ফিরা দেশো গেলগি। ");
INSERT INTO syl_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","আর কাবিল তার বউর লগে মিলায় তাইর পেটো হুরুতা আইলো, আর হনোকর জনম অইলো। কাবিলে একটা টাউন বানাইয়া তার পুয়ার নামে টাউনর নাম রাখলো হনোক। ");
INSERT INTO syl_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","হনোকর পুয়া ইরদ, ইরদর পুয়া মহুয়ায়েল, মহুয়ায়েলর পুয়া মথুশায়েল, মথুশায়েলর পুয়া লেমক। ");
INSERT INTO syl_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","লেমকে দুই বিয়া করছলা, এক বউর নাম আদা, আরক বউর নাম সিল্লা। ");
INSERT INTO syl_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","আদার ঘরো যাবলর জনম অইলো, যারা তাম্বুত থাকে আর পশু পালে, অউ যাবল তারার মুল বাফ। ");
INSERT INTO syl_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","যাবলর ভাইর নাম যুবল। যারা বাশি আর বীণ বাজায়, অউ যুবল তারার মুল বাফ। ");
INSERT INTO syl_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","সিল্লার পেটো তুবল-কাবিলর জনম অইলো। পিতল আর লুয়ার আতিয়ার বানানি আছিল তার কাম। তার বইনর নাম নায়েমা। ");
INSERT INTO syl_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","একদিন লেমকে তার দুই বউরে কইলো, “ও আদা আর সিল্লা, আমার কথা হুন, লেমকর বিবিন, আমার কথায় দেও কান। যে বেটায় আমারে করিলো জখম, যে বেটায় আমার গাত তুললো আত, হেরে আমি করিলাম নিপাত। ");
INSERT INTO syl_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","কাবিলর খুনর বদলা যুদি সাত গুন অয়, লেমকর বদলা সাতত্তইর গুন নিচ্চয়।” ");
INSERT INTO syl_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","এরমাজে আদমে হিরবার তান বউর লগে মিলায়, তান পেটো আরক পুয়া অইলো, হাওয়ায় তার নাম রাখলা শিস। তাইন কইলা, “কাবিলে হাবিলরে খুন করছে করি আল্লায় হাবিলর বদলা আমারে এক চেরাগ যুগাই দিছইন।” ");
INSERT INTO syl_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","বাদে শিসরও এক পুয়া অইলো, হে তার নাম রাখলো আনুশ, অউ সময় থনে মানষে মাবুদর নাম লওয়া শুরু করলা। ");
INSERT INTO syl_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ইতা অইলো আদমর খান্দানর কলমবন্দি বয়ান। মানুষ পয়দা করার সময় আল্লায় তান নিজর ছুরতে পয়দা করলা। ");
INSERT INTO syl_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","পয়দা করলা বেটা আর বেটি, আর তারারে মাবুদে বরকত দিলা, পয়দা করিয়া নাম রাখলা আদম। ");
INSERT INTO syl_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","আদমর একশো তিশ বরছ বয়সো তান লগে মিল রাখিয়া তান ছুরতে এক পুয়া অইলো। তাইন এর নাম রাখলা শিস। ");
INSERT INTO syl_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","শিসর জনমর বাদে আদম আরো আটশো বরছ বাচলা, এর মাজে তান আরো পুয়া-পুড়িন অইছিল। ");
INSERT INTO syl_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","মোট নয়শো তিশ বরছ জিন্দা থাকার বাদে আদম মারা গেলা। ");
INSERT INTO syl_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","শিসর একশো পাচ বরছ বয়সো তান পুয়া আনুশর জনম অইলো। ");
INSERT INTO syl_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","আনুশর জন্মর বাদে শিস আরো আটশো সাত বরছ বাচলা। এর মাজে তান আরো পুয়া-পুড়ি অইছিল। ");
INSERT INTO syl_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","মোট নয়শো বারো বরছ বাচার বাদে শিস মারা গেলা। ");
INSERT INTO syl_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","আনুশর নব্বই বরছ বয়সো তান পুয়া কিনানর জনম অইলো। ");
INSERT INTO syl_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","কিনানর জন্মর বাদে আনুশ আরো আটশো পনরো বরছ বাচলা। এর মাজে তান আরো পুয়া-পুড়ি অইছিল। ");
INSERT INTO syl_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","মোট নয়শো পাচ বরছ বাচার বাদে আনুশ মারা গেলা। ");
INSERT INTO syl_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","কিনানর সত্তইর বরছ বয়সো তান পুয়া মাহলাইলর জনম অইলো। ");
INSERT INTO syl_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","মাহলাইলর জন্মর বাদে কিনান আরো আটশো চাল্লিশ বরছ বাচলা। এর মাজে তান আরো পুয়া-পুড়ি অইছিল। ");
INSERT INTO syl_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","মোট নয়শো দশ বরছ বাচার বাদে কিনান মারা গেলা। ");
INSERT INTO syl_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","মাহলাইলর পয়ষট্টি বরছ বয়সো তান পুয়া ইয়ারেদর জনম অইলো। ");
INSERT INTO syl_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","ইয়ারেদর জন্মর বাদে মাহলাইল আরো আটশো তিশ বরছ বাচলা। এর মাজে তান আরো পুয়া-পুড়ি অইছিল। ");
INSERT INTO syl_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","মোট আটশো পচানব্বই বরছ বাচার বাদে মাহলাইল মারা গেলা। ");
INSERT INTO syl_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","ইয়ারেদর একশো বাষট্টি বরছ বয়সো তান পুয়া ইদ্রিছর জনম অইলো। ");
INSERT INTO syl_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ইদ্রিছর জন্মর বাদে ইয়ারেদ আরো আটশো বরছ বাচলা, এর মাজে তান আরো পুয়া-পুড়ি অইছিল। ");
INSERT INTO syl_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","মোট নয়শো বাষট্টি বরছ বাচার বাদে ইয়ারেদ মারা গেলা। ");
INSERT INTO syl_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ইদ্রিছর পয়ষট্টি বরছ বয়সো তান পুয়া মাতুশালাখর জনম অইলো। ");
INSERT INTO syl_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","মাতুশালাখর জন্মর বাদে তিনশো বরছ পর্যন্ত, আল্লার লগে ইদ্রিছর খাছ দিদার আছিল। এর মাজে তান আরো পুয়া-পুড়ি অইছিল। ");
INSERT INTO syl_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ইদ্রিছ মোট তিনশো পয়ষট্টি বরছ দুনিয়াইত আছলা। ");
INSERT INTO syl_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","এরবাদে তানে আর দেখা গেল না। আল্লার লগে তান খাছ দিদার আছিল গতিকে আল্লায় তানরে জিন্দা হালতে নিজর গেছে নিলাগি। ");
INSERT INTO syl_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","মাতুশালাখর একশো সাতাশি বরছ বয়সো তান পুয়া লামাকর জনম অইলো। ");
INSERT INTO syl_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","লামাকর জন্মর বাদে মাতুশালাখ আরো সাতশো বিরাশি বরছ বাচলা। এর মাজে তান আরো পুয়া-পুড়ি অইছিল। ");
INSERT INTO syl_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","মোট নয়শো উনুসত্তইর বরছ বাচার বাদে মাতুশালাখ মারা গেলা। ");
INSERT INTO syl_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","লামাকর একশো বিরাশি বরছ বয়সো তান এক পুয়া অইলো। ");
INSERT INTO syl_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","তাইন এর নাম রাখলা নুহ আর কইলা, “হে আমরার আতর ই দুখ-মছিবতর কাম থাকি, মাবুদর লান্নতি জমিন থাকি অখন আরাম দিবো।” ");
INSERT INTO syl_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","নুহর জন্মর বাদে লামাক আরো পাচশো পচানব্বই বরছ বাচলা, এর মাজে তান আরো পুয়া-পুড়ি অইছিল। ");
INSERT INTO syl_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","মোট সাতশো সাতত্তইর বরছ বাচার বাদে লামাক মারা গেলা। ");
INSERT INTO syl_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","নুহর পাচশো বরছ বয়সর বাদে তান পুয়াইন সাম, হাম আর ইয়াফেতর জনম অইলো। ");
INSERT INTO syl_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","দুনিয়ার উপরে যেবলা মানুষ বাড়া আরম্ভ অইলো, আর বউত পুড়িন্তরও জনম অইলো, ");
INSERT INTO syl_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","তেউ গাইবি শক্তিআলা অকলে অউ পুড়িন্তরে খুবছুরত দেখিয়া, যে যারে খুশি তাইরে পছন্দ করি নিলা। ");
INSERT INTO syl_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","ইতা দেখিয়া মাবুদে কইলা, “আমার রুহ হামেশা মানষর লগে থাকতো নায়। মানুষ তো খালি গোস্তর কায়া, অখন থাকি আমি তারারে একশো বিশ বরছ হায়াত দিয়ার।” ");
INSERT INTO syl_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","অউ পুড়িন্তর লগে হউ গাইবি শক্তিআলা অকলর মিলা-মিশার কারনে যে আওলাদর জনম অইলো, তারা আছলা পুরানা জমানার পয়লোয়ান অকল। হি সময় বা তার বাদেও দুনিয়াইত নেফিলী জাতর মানুষ আছিল। ");
INSERT INTO syl_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","মাবুদে দেখলা, দুনিয়াইত মানষর নাফরমানি খুব বাড়ি গেছে, আর তারার দিলর খাইশ, খিয়াল-খুশি খালি খারাপির বায়। ");
INSERT INTO syl_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ইতা দেখিয়া মাবুদে খুব তকলিফ পাইলা, তাইন দুনিয়াইত মানুষ পয়দা করছিলা করি খুব বেজার অইলা। ");
INSERT INTO syl_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","আর কইলা, “আমার পয়দা করা মানষরে, আর তারার লগে হকল জাতর জানুয়ার, মাটিত চলরা হুরু-মুরু জানদার আর আছমানর পাখিও খতম করি দিমু। ইতারে পয়দা করিয়া আমার দিলো দুখ লাগের।” ");
INSERT INTO syl_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","অইলে নুহর উপরে মাবুদ খুশি আছলা। ");
INSERT INTO syl_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","ইতা অইলো নুহর জিন্দেগির বয়ান। নুহ একজন কামিল মানুষ, তান আমলর মানষর মাজে তাইনউ আছলা পাক-পরেজগার। আল্লার লগে তানর খাছ দিদার আছিল। ");
INSERT INTO syl_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","সাম, হাম আর ইয়াফেত নামর তান তিন পুয়া আছিল। ");
INSERT INTO syl_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","ই সময় আল্লার চখুত হারা দুনিয়াই গুনায় পচি গেছে আর জুর-জুলুমে ভরি গেছে। ");
INSERT INTO syl_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","আল্লায় দুনিয়ার বায় চাইয়া দেখলা, ইতা গুনায় পচি গেছে। কারন দুনিয়ার মানষর খাইছলত বে-পথে গেছেগি। ");
INSERT INTO syl_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ইতা দেখিয়া আল্লায় নুহরে কইলা, “তামাম মানুষ জাতরে আমি খতম করিলাইতাম ঠিক করছি। মানষর লাগি দুনিয়াই জুর-জুলুমে ভরি গেছে। মানষর লগে লগে দুনিয়ার হকলতা আমি শেষ করিলিতাম। ");
INSERT INTO syl_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","তুমি গফরর তক্তা দিয়া তুমার লাগি একখান জাজ বানাও। এর ভিতরে আলগা আলগা কুঠা থাকবো। আর জাজর বারে-ভিতরে আলকাতরা লাগাইও। ");
INSERT INTO syl_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","জাজখান লাম্বায় তিনশো আত, পাশে পইঞ্চাশ আত আর খাড়া-উবি তিশ আত বানাইও। ");
INSERT INTO syl_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","আর চালো থাকি এক আত তলে চাইরোবায় খিড়কি রাখবায়, আর দুয়ার দিবায় জাজর এক কান্দাত। জাজখান তিতালা বানাইও। ");
INSERT INTO syl_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","দেখিও, আমি দুনিয়াইত অলা বইন্যা দিমু, আছমানর তলে যত জানদারে দম ফালায় হকলতাউ বিনাশ অইযিবো। দুনিয়াইর হকল জানদারউ মরিযিবো। ");
INSERT INTO syl_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","খালি তুমার লগে আমার ওয়াদা জারি রাখমু। তুমি গিয়া জাজো উঠবায়, আর তুমার লগে তুমার পুয়াইন, তুমার বিবি আর তুমার পুয়াইন্তর বউ-ও। ");
INSERT INTO syl_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","আর জান বাচানির লাগি তুমি হকল জাতর জানদারর বেটা-বেটির জুড়া মিলাইয়া তুমার লগে জাজো তুলবায়। ");
INSERT INTO syl_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","পরতেক জাতর পাখি, হেমান-জানুয়ার আর মাটির মাজে বুকে চলরা জানদাররে বাচানির লাগি জুড়া জুড়া করি তুমার গেছে আনবায়। ");
INSERT INTO syl_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","আর তুমি হকল জাতর লাগি খানির জিনিস যোগাড় করি রাখবায়। ইতা তুমার আর তারার খানি অইবো।” ");
INSERT INTO syl_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","নুহে আল্লার হুকুম মাফিক হকলতাউ করলা। ");
INSERT INTO syl_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","আর মাবুদে নুহরে কইলা, “তুমি আর তুমার পরিবারর হকল আইয়া জাজো উঠবায়। আমি দেখিয়ার ই জমানার মানষর মাজে তুমিউ খালি দীনদার। ");
INSERT INTO syl_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","তুমি হালাল জানুয়ার অকল থাকি নর-মেদি মিলাইয়া সাত জুড়া করি আর হারাম জানুয়ার থাকি এক জুড়া করি তুমার লগে লইও। ");
INSERT INTO syl_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","আছমানো উড়রা পাখির মাজ থাকি নর-মেদি মিলাইয়া সাত জুড়া করি লইও। দুনিয়ার মাজে এরার বংশ বাচানির লাগি ইখান করিও। ");
INSERT INTO syl_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","আমি সাত দিন বাদে দুনিয়াইর উপরে চাল্লিশ দিন চাল্লিশ রাইত একলাগারে মেঘ দিমু, আর হকল জানদাররে দুনিয়া থাকি খতম করমু।” ");
INSERT INTO syl_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","মাবুদর হুকুম মাফিক নুহে হকল কাম করলা। ");
INSERT INTO syl_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","বইন্যা শুরুর সময় নুহর বয়স আছিল ছয়শো বরছ। ");
INSERT INTO syl_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","বইন্যা থাকি বাচার লাগি নুহ, তান বিবি, তান পুয়াইন আর পুয়াইন্তর বউরে লইয়া জাজো গিয়া উঠলা। ");
INSERT INTO syl_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","আল্লার হুকুম মাফিক হালাল-হারাম জানুয়ার, পাখি, বুকে চলরা জানদারর নর-মেদি মিলিয়া জুড়া জুড়া অইয়া নুহর গেছে আইয়া জাজো হামাইলা। ");
INSERT INTO syl_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","অউ সাত দিন বাদে দুনিয়াইত বইন্যা অইলো। ");
INSERT INTO syl_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","নুহর ছয়শো বছরর সময় দুছরা মাসর সতরো তারিখ পাতালর হকল পানি বার অইতো লাগলো, আর আছমান যেনু ফাটি গেল। ");
INSERT INTO syl_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","চাল্লিশ দিন চাল্লিশ রাইত দুনিয়াইর উপরে মেঘ অইলো। ");
INSERT INTO syl_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","যেদিন মেঘ শুরু অইলো, ইদিন নুহ, তান বিবি, তান পুয়াইন সাম, হাম, ইয়াফেত আর তারার বউ অকলও জাজো আইয়া উঠলা। ");
INSERT INTO syl_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","তারার লগে জুড়া জুড়া করি হকল জাতর জংলি জানুয়ার, পালা হেমান, মাটির মাজে বুকে চলরা জানদার, পাখি আর ডাখনা আলা হকলতাও উঠলা। ");
INSERT INTO syl_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","দম ফালাইয়া বাচে ইলা হকল জাতর জানদার নুহর গেছে আইয়া জাজো উঠছিল। ");
INSERT INTO syl_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","আল্লার হুকুম মাফিকউ নর-মেদির জুড়া মিলিয়া তারা উঠছিল। এরবাদে মাবুদে জাজর দুয়ার বন্দ করি দিলা। ");
INSERT INTO syl_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","চাল্লিশ দিন ধরি দুনিয়াইত পানি বাড়তেউ থাকলো। পানি বাড়ি যাওয়ায় জাজখান মাটি থাকি উপরে ভাইয়া উঠলো। ");
INSERT INTO syl_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","বাদে পানি খুব বাড়লো আর জাজখান পানির উপরে চলাচল করলো। ");
INSERT INTO syl_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","আর পানি বাড়তেউ থাকলো। এরলাগি যেনো যত বড় বড় পাহাড় আছিল, হক্কলতা বুড়ি গেল। ");
INSERT INTO syl_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","হকল পাহাড়-পর্বত বুড়িয়া পানি আরো পনরো আত উপরে উঠলো। ");
INSERT INTO syl_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","আর দুনিয়াইত চলরা হকল জানদার, মানি পাখি, পালা হেমান, জংলি জানুয়ার আর পাল বান্দিয়া ঘুররা হকলতা, মানষর লগে বিনাশ অইগেল। ");
INSERT INTO syl_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","মাটির উপরে যত রকমর যত জানদার দম ফালাইয়া বাচে ইতা হকলতাউ মরিগেল। ");
INSERT INTO syl_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","আল্লায় অউ নমুনায় জমিনর হকল জানদার দুনিয়াইর উপর থাকি ফুছিলাইলা। এতে মানুষ, জানুয়ার, বুকে চলরা জানদার আর আছমানর পাখি দুনিয়াই থাকি ছাফ অইগেল। খালি নুহ আর তান লগে যারা আছিল, তারাউ বাচিয়া রইলা। ");
INSERT INTO syl_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","দুনিয়া দেড়শ দিন পানিত বুড়াইল রইলো। ");
INSERT INTO syl_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","জাজো নুহ আর তান লগে যত জানদার আর পালা হেমান আছিল, আল্লায় তারার কথাও ফাউরিলা না। তাইন দুনিয়াইত বাতাস চালাইলে পানি কমা শুরু অইলো। ");
INSERT INTO syl_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","মাটির তল থাকি পানি বারনি আর আছমান থনে মেঘ পড়ার ফাটা বন্দ অইগেল, আর মেঘও দম লইলো। ");
INSERT INTO syl_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","মাটির উপরর পানি হরি গেল, আর দেড়শ দিন বাদে দেখা গেল পানি বউত কমছে। ");
INSERT INTO syl_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","সাত নম্বর মাসর সতরো তারিখ জাজখান আরারাতর পাহাড়ি এলাকাত গিয়া আটকিলো। ");
INSERT INTO syl_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","এরবাদেও পানি কমাত থাকলো, আর দশ নম্বর মাসর পয়লা দিন পাহাড় অকলর মাথা দেখা গেল। ");
INSERT INTO syl_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","এর চাল্লিশ দিন বাদে নুহে জাজর খিড়কি খুললা। ");
INSERT INTO syl_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","আর খিড়কিবায় এক কাউয়া ছাড়লা। মাটি থাকি পানি না হুকানি পর্যন্ত কাউয়াটা আওয়া-যাওয়াত রইলো। ");
INSERT INTO syl_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","মাটির উপর থনে পানি কমছে কি না দেখার লাগি নুহে বাদে একটা পারো ছাড়লা। ");
INSERT INTO syl_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ই সময়ও আস্তা দুনিয়াইত পানি আছিল করি পাও থইবার জাগা না পাইয়া পারোটা হিরবার ফিরিয়া আইলো। তাইন আত বাড়াইয়া তারে ভিতরে আনলা। ");
INSERT INTO syl_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","হেশে তাইন আরো সাত দিন বার চাইয়া হিরবার তারে ছাড়লা। ");
INSERT INTO syl_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","হাইঞ্জা বালা হে তান গেছে ফিরিয়া আইলো, আর তার ঠোটো আছিল জয়তুন গাছর হাজমা পাতা, তাইন বুজলা মাটির উপর থাকি পানি কমি গেছে। ");
INSERT INTO syl_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","আরো সাত দিন বাদে তাইন হিরবার পারোটা ছাড়লা, ইকটা আর ফিরিয়া আইলো না। ");
INSERT INTO syl_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","নুহর বয়স ছয়শো এক বছরর সময় পয়লা মাসর পয়লা দিন মাটির উপর থাকি পানি হরি গেল, আর নুহে জাজর চাল খুলিয়া চাইয়া দেখলা, মাটি হুকানি ধরছে। ");
INSERT INTO syl_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","দুছরা মাসর সাতাইশ দিনর দিন মাটি একইবারে হুকাই গেল। ");
INSERT INTO syl_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","আল্লায় তানরে কইলা, ");
INSERT INTO syl_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“তুমি তুমার বিবি, তুমার পুয়াইন আর তুমার পুয়াইন্তর বউরে লইয়া জাজ থাকি বার অইয়া আও। ");
INSERT INTO syl_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","আর তুমার লগে যত জাতর জানদার আছে - পাখি, জানুয়ার আর মাটির মাজে বুকে চলরা জানদার - তারারেও বার করি লইয়া আও, যেনু হারা দুনিয়াই জুড়ি তারা ছিতরিয়া গিয়া ফলআলা অইয়া বাড়ে।” ");
INSERT INTO syl_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","তেউ নুহে, তান বিবি, তান পুয়াইন আর তারার বউরে লইয়া জাজ থাকি বার অইলা। ");
INSERT INTO syl_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","তারার লগে দুনিয়াইর হকল জানুয়ার, মাটিত চলরা হুরু-মুরু জানদার, আর পাখি, এক কথায় দুনিয়াইত চলরা হকল জানদার, যারযির জাতমত বার অইলো। ");
INSERT INTO syl_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","বাদে নুহে মাবুদর নামে একখান কুরবানি খানা বানাইলা, আর পরতেক জাতর হালাল পশু-পাখি থাকি এক একটা লইয়া জবো করিয়া, জালাইয়া কুরবানি দিলা। ");
INSERT INTO syl_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","মাবুদ ই কুরবানির ধুমার ঘেরানে খুশি অইলা, আর তাইন কইলা, “মানষর লাগি আমি আর কুনু সময়ও মাটিরে লান্নত দিতাম নায়, যুদিও হুরুবালা থাকিউ মানষর মনর খিয়াল খারাপির বায় থাকে। ইফিরা যেলা হকল জানদাররে মারছি, ইলাখান আর কুনু দিনউ মারতাম নায়। ");
INSERT INTO syl_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","যতদিন ই দুনিয়াই থাকবো, অতদিন নিয়মমত বিচ ফালানি আর ফসল কাটা, ঠান্ডা আর গরম, বারিষা আর এওত, দিন আর রাইত চলতেউ থাকবো।” ");
INSERT INTO syl_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","আল্লায় নুহ আর তান পুয়াইন্তরে বরকত দিয়া কইলা, “তুমিতাইন ফলআলা অইয়া বাড়িয়া দুনিয়াই ভরি যাও। ");
INSERT INTO syl_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","দুনিয়াইর জানুয়ার, আছমানর পাখি, মাটির মাজে বুকে চলরা জানদার আর দরিয়ার মাছ, হকলেউ তুমরারে ডর-ভয় করি চলবো। ইতারে তুমরার আতো দেওয়া অইলো। ");
INSERT INTO syl_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","যেলা তুমরারে খেতর ফল-ফসল আর তরি-তরকারি দিছলাম, অউলা অখন জিতা জানদার হকলরেও তুমরার খানির লাগি দিলাম। ");
INSERT INTO syl_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","খালি লউ সহ গোস্ত তুমরা খাইও না, লউ অইলোগি জান। ");
INSERT INTO syl_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","কেউ যুদি মানষরে খুন করে তে আমি অবশ্যউ তার খুনর বদলা লইমু। হে জানুয়ার অউক বা মানুষ অউক, মানষর জান যে নেয়, তার জানও দেওন লাগবো। ");
INSERT INTO syl_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","মানষর লউ যে বার করে, মানষেও তার লউ বার করবো, কারন আল্লায় মানষরে নিজর ছুরতে বানাইছইন। ");
INSERT INTO syl_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","তুমিতাইন বেশ করি ফলআলা অইয়া বাড়ো আর দুনিয়াইত ছিতরিয়া যাও।” ");
INSERT INTO syl_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","বাদে আল্লায় নুহ আর তান পুয়াইন্তরে কইলা, ");
INSERT INTO syl_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“হুনো, আমি জবান দিয়ার, তুমরা আর তুমরার বাদর হকল মানষরে, ");
INSERT INTO syl_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","আর পাখি, পালা হেমান আর দুনিয়াইর যত জানুয়ার তুমরার লগে জাজ থাকি বার অইছে, তারারেও। ");
INSERT INTO syl_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","জবানটা অইলো, বানর পানি দিয়া আর কুনু সময়উ হক্কল জানদাররে মারা অইতো নায়, আর তামাম দুনিয়াই ছাফ করার লাগি ইলা কুনু বানও অইতো নায়।” ");
INSERT INTO syl_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","আল্লায় আরো কইলা, “যে জবান আমি তুমরারে আর তুমরার লগর জানদার অকলরে দিলাম, ইকটা কিয়ামত পর্যন্ত বওয়াল রইবো। ");
INSERT INTO syl_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","আর মেঘর কালনির মাজে আমার রংধেনু দিলাম, ইকটা অইলো দুনিয়াইত আমার জবানর নিশানা। ");
INSERT INTO syl_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","যেবলা আমি দুনিয়াইর উপরে কালনি দিমু, ই সময় অউ রংধেনু দেখবায়। ");
INSERT INTO syl_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","আর অউ সময়উ আমি তুমরার আর হকল জানদারর লগে আমার জবানর কথা ইয়াদ করমু। আর কুনু সময়উ বইন্যা অইয়া হকল জানদাররে পানি দিয়া ধইয়া নিতো নায়। ");
INSERT INTO syl_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","কালনির মাজে যেবলা হি রংধেনু দেখা যাইবো অউ সময় আমি দুনিয়াইর হকল জানদারর লগে আমার ই হামেশাকুর জবানর কথা ইয়াদ করমু।” ");
INSERT INTO syl_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","হেশে আল্লায় নুহরে কইলা, “দুনিয়াইর হকল জানদারর লগে আমি যে জবান দিছি, ইকটা অইলো তার নিশানা।” ");
INSERT INTO syl_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","জাজ থনে নুহর যে পুয়াইন বার অইছলা, তারার নাম অইলো সাম, হাম আর ইয়াফেত। অউ হাম অইলো কেনানর বাফ। ");
INSERT INTO syl_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","নুহর অউ তিনও পুয়ার খান্দান অকল হারা দুনিয়াইত ছিতরি গেলা। ");
INSERT INTO syl_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","নুহে খেত-খামার শুরু করিয়া এক আংগুর-খেত করলা। ");
INSERT INTO syl_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","আর আংগুরর শরাব খাইয়া টাল অইয়া তাম্বুর ভিতরে উদাম অইয়া পড়ি রইলা। ");
INSERT INTO syl_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","কেনানর বাফ হামে আইয়া তার বাফর অউ হাল দেখিয়া বারে গিয়া তার দুইও ভাইর গেছে কইলো। ");
INSERT INTO syl_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","অইলে সাম আর ইয়াফেতে কান্দো করি একখান কাপড় লইয়া পিছে আটিয়া বাফরে অউ কাপড়দি গুরিয়া দিলা, তারার চউখ উল্টাবায় থাকায় বাফরে বে-আবরু হালতে দেখলা না। ");
INSERT INTO syl_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","নিশা কমি যাওয়ার বাদে নুহে তান পুয়ার কান্ড হুনিয়া ");
INSERT INTO syl_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","কইলা, “কেনানর উপরে লান্নত পড়উক, হে তার ভাইয়াইন্তর গেছে গুলামর গুলাম অইবো।” ");
INSERT INTO syl_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","তাইন আরো কইলা, “হকল তারিফ সামর মাবুদ আল্লার, কেনান সামর গুলাম অউক। ");
INSERT INTO syl_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","আল্লায় ইয়াফেতরে বউততা দেউক্কা, হে সামর তাম্বুত থাকউক, আর কেনান তার গুলাম অউক।” ");
INSERT INTO syl_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","বানর বাদে নুহ আরো সাড়ে তিনশো বরছ বাচলা। ");
INSERT INTO syl_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","মোট সাড়ে নয়শো বরছ বয়সো তাইন মারা গেলা। ");
INSERT INTO syl_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","নুহর পুয়াইন সাম, হাম, আর ইয়াফেতর খান্দানর বয়ান। বানর বাদে তারার পুয়া-পুড়ি অইছলা। ");
INSERT INTO syl_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","ইয়াফেতর পুয়াইন্তর নাম: গোমর, মাজুজ, মাদয়, ইয়াবান, তুবল, মেশক আর তীরস। ");
INSERT INTO syl_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","গোমরর পুয়াইন: অস্কিনশ, রিফত আর তোগর্ম। ");
INSERT INTO syl_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","ইয়াবানর পুয়াইন অইলা: ইলিশাহ, তর্শীশ, কিত্তীম আর রোদানীম। ");
INSERT INTO syl_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","এরার বংশর মানষে নানান জাতর মাত-কথা, পরিবার আর জাত হিসাবে দরিয়ার পারর নানান দেশো ছিতরি গেলা। ");
INSERT INTO syl_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","হামর পুয়াইন্তর নাম: কুশ, মিসর, পুট আর কেনান। ");
INSERT INTO syl_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","কুশর পুয়াইন: সবা, হবিলা, সপ্তা, রয়মা আর সপ্তকা। রয়মার পুয়াইন অইলা: সাবা আর দদান। ");
INSERT INTO syl_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","কুশর এক পুয়ার নাম আছিল নমরুদ। অউ নমরুদ দুনিয়াইত পয়লোয়ান অইয়া উঠছিল। ");
INSERT INTO syl_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","মাবুদর গেছে হে আছিল পয়লোয়ান শিকারি। এরলাগি ডাকর কথা আছে, মানুষটা যেন মাবুদর ছামনে নমরুদর লাখান পয়লোয়ান শিকারি। ");
INSERT INTO syl_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","শিনার দেশর বাবিল, এরক, অক্কদ আর কলনী নামর টাউন অকল লইয়া হে বাদশাই শুরু করলো। ");
INSERT INTO syl_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","অন থাকি তার রাইজ্য বাড়িয়া আশিরিয়া দেশ পর্যন্ত গেল। হখানর নিনভ, রহবতপুর, কেলহ ");
INSERT INTO syl_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","আর রেষন নামর টাউন অকলও তার বানাইল। রেষন আছিল নিনভ আর কেলহর মাজখানো, ই তিনটায় মিলিয়া এক বিরাট শহর অইলো। ");
INSERT INTO syl_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","মিসরর বংশ অইলা অউ জাত অকল: লুদী, অনামী, লহাবী, নপ্তোহী, ");
INSERT INTO syl_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","পথ্রোষী, কসলুহী, আর কপ্তোরী, অউ কপ্তোর দ্বীপ থাকি ফিলিস্তিনী অকল বার অইয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","কেনানর বড় পুয়া সিদন, বাদর পুয়া হিট, হিট্টী জাতির মুল বাফ। ");
INSERT INTO syl_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","কেনান আছলা যিবুজী, আমোরী, গির্গাশী, ");
INSERT INTO syl_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","হিব্বী, আর্কী, সীনী, ");
INSERT INTO syl_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","আর্বাদী, জমারী আর হামাতী, অউ জাতি অকলর মুল বাফ। হেশে অউ কেনানী অকল চাইরোবায় ছিতরি গেছলা। ");
INSERT INTO syl_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","সিদন টাউন থাকি গেরারর মুখা গাজা পর্যন্ত, আর গাজা থাকি ছাদুম, আমুরা, অদমা আর ছবয়িম যাওয়ার পথে লাশা পর্যন্ত কেনানী অকলর রাজত্ব আছিল। ");
INSERT INTO syl_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","পরিবার, মাত-কথা, দেশ আর জাত হিসাবে এরা আছিল হামর খান্দান। ");
INSERT INTO syl_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","ইয়াফেতর বড় ভাই সামরও পুয়া-পুড়িন অইছলা। সাম অইলা আবের আর তার খান্দানর বাফ। ");
INSERT INTO syl_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","সামর পুয়াইন্তর নাম: ইলাম, আশুর, আর্ফাক্সাদ, লুদ আর অরাম। ");
INSERT INTO syl_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","অরামর পুয়াইন: উজ, হূল, গেথর আর মশ। ");
INSERT INTO syl_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","আর্ফাক্সাদর পুয়া শালেখ, আর শালেখর পুয়ার নাম আবের। ");
INSERT INTO syl_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","আবেরর দুই পুয়া অইছলা, একজনর নাম ফালেজ মানি, আলগা, তান সময় দুনিয়া আলগ অইছিল করি তান অউ নাম অইলো। ফালেজর ভাইর নাম ইয়াকতান। ");
INSERT INTO syl_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","ইয়াকতানর পুয়াইন অইলা: অলমোদদ, শেলফ, হাযরামাওত, যেরহ, ");
INSERT INTO syl_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","হদোরাম, উজাল, দিক্‌লা, ");
INSERT INTO syl_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ওবল, অবিমায়েল, সাবা, ");
INSERT INTO syl_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ওফির, হবিলা আর যোবব। এরা হকল অইলা ইয়াকতানর পুয়াইন। ");
INSERT INTO syl_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","মেষা থাকি পুবেদি ছেফারো যাওয়ার পথো যে পাহাড়ি জাগা আছে, অনো তারা থাকতা। ");
INSERT INTO syl_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","পরিবার, মাত-কথা, দেশ, আর জাত হিসাবে এরা অইলা সামর খান্দান। ");
INSERT INTO syl_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","জাত আর বংশ হিসাবে এরা অইলো নুহর পুয়াইন্তর পরিবার। বানর বাদে এরার বংশ অকলে নানান জাত অইয়া আস্তা দুনিয়াইত ছিতরি গেছলা। ");
INSERT INTO syl_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","হি জমানাত আস্তা দুনিয়াইত খালি এক ভাষায় মাততা, আর তারার বুলি অকলও একলাখানউ আছিল। ");
INSERT INTO syl_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","তারা পুবেদি আগুয়াইয়া যাইতে যাইতে শিনার দেশর এক হমান জাগা পাইয়া হখানোউ বসত করলা। ");
INSERT INTO syl_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","তারা একে-অইন্যরে কইলো, “আও, আমরা ইট বানাইয়া আগুইনদি জালাই।” কইয়াউ তারা পাথরর বদলা ইট আর চুন-সুরকির বদলা তারতেল লাগাইলো। ");
INSERT INTO syl_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","তারা আরো কইলো, “আও, আমরার নিজর লাগি একটা শহর বানাই, আর অউলা একটা ঘরও বানাই, যেকটার মিনার গিয়া আছমান লাগাল পাইবো। তেউ আমরার নামও অইবো আর আমরা দুনিয়াইত ছিতরিতামও নায়।” ");
INSERT INTO syl_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","মানষে যে উচা ঘর আর শহর বানাইরা ইকটা দেখাত মাবুদ লামি আইলা। ");
INSERT INTO syl_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","আর কইলা, “এরা এক জাতর মানুষ, এরার মাত-কথাও এক; এরলাগি তারা অউ কামর মাজে আত দিছে। নিজর মতলব হাছিলর লাগি এরা আর কুনু বাধাউ মানতো নায়। ");
INSERT INTO syl_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","তে আও, আমরা লামিয়া গিয়া তারার বুলির মাজে গোলমাল লাগাই দেই, যাতে তারা একজনে আরক জনর মাত বুজতো না পারে।” ");
INSERT INTO syl_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","এরবাদে মাবুদে হউ জাগা থাকি তারারে আস্তা দুনিয়াইত ছিতরাই দিলা। আর তারার হউ শহর বানানির কামও বন্দ অইগেল। ");
INSERT INTO syl_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","অউ কারনে হউ জাগার নাম অইলো বাবিল মানি, গোলমাল, হখানোউ মাবুদে হারা দুনিয়াইর বুলির মাজে গোলমাল লাগাই দিছলা। হখান থাকিউ তাইন তারারে আস্তা দুনিয়াইত ছিতরাইলিলা। ");
INSERT INTO syl_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","অউ অইলো সামর খান্দানর বয়ান। বানর দুই বরছ বাদে সামর বয়স যেবলা একশো বরছ, অউ সময় তান পুয়া আর্ফাক্সাদর জনম অইলো। ");
INSERT INTO syl_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","আর্ফাক্সাদর জন্মর বাদে সাম আরো পাচশো বরছ বাচিয়া আছলা। এর মাজে তান আরো পুয়া-পুড়িন অইছলা। ");
INSERT INTO syl_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","আর্ফাক্সাদর পায়তিশ বছরর সময় তান পুয়া শালেখর জনম অইলো। ");
INSERT INTO syl_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","শালেখর জন্মর বাদে তাইন আরো চাইরশো তিন বরছ বাচিয়া আছলা। এর মাজে তান আরো পুয়া-পুড়ি অইছলা। ");
INSERT INTO syl_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","শালেখর তিশ বরছ বয়সর সময় তান পুয়া আবেরর জনম অইলো। ");
INSERT INTO syl_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","আবেরর জন্মর বাদে শালেখ আরো চাইরশো তিন বরছ বাচিয়া আছলা। এর মাজে তান আরো পুয়া-পুড়ি অইছলা। ");
INSERT INTO syl_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","আবেরর চৌতিশ বছরর সময় তান পুয়া ফালেজর জনম অইলো। ");
INSERT INTO syl_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","ফালেজর জন্মর বাদে আবের আরো চাইরশো তিশ বরছ বাচিয়া আছলা। এর মাজে তান আরো পুয়া-পুড়ি অইছলা। ");
INSERT INTO syl_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","ফালেজর তিশ বরছ বয়সর সময় তান পুয়া রাউর জনম অইলো। ");
INSERT INTO syl_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","রাউর জন্মর বাদে ফালেজ আরো দুইশো নয় বরছ বাচিয়া আছলা। এর মাজে তান আরো পুয়া-পুড়ি অইছলা। ");
INSERT INTO syl_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","রাউর বত্তিশ বছরর সময় তান পুয়া সারুজর জনম অইলো। ");
INSERT INTO syl_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","সারুজর জন্মর বাদে রাউ আরো দুইশো সাত বরছ বাচিয়া আছলা। এর মাজে তান আরো পুয়া-পুড়ি অইছলা। ");
INSERT INTO syl_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","সারুজর তিশ বছরর সময় তান পুয়া নাহুরর জনম অইলো। ");
INSERT INTO syl_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","নাহুরর জন্মর বাদে সারুজ আরো দুইশো বরছ বাচিয়া আছলা। এর মাজে তান আরো পুয়া-পুড়ি অইছলা। ");
INSERT INTO syl_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","নাহুরর উনতিশ বছরর সময় তান পুয়া তারেখর জনম অইলো। ");
INSERT INTO syl_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","তারেখর জন্মর বাদে নাহুর আরো একশো উন্নিশ বরছ বাচিয়া আছলা। এর মাজে তান আরো পুয়া-পুড়ি অইছলা। ");
INSERT INTO syl_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","তারেখর সত্তইর বছরর সময় তান পুয়াইন আব্‌রাম (তান বাদর নাম ইব্রাহিম), নাহুর আর হারনর জনম অইছিল। ");
INSERT INTO syl_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","অউ অইলো তারেখর খান্দানর বয়ান। তারেখর পুয়ার নাম আছিল আব্‌রাম, নাহুর আর হারন। আর হারনর পুয়ার নাম লুত। ");
INSERT INTO syl_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","হারন তান বাবা জিন্দা থাকতেউ, তান জনম-মাটি বাবিল দেশর উর টাউনো মারা গেছলা। ");
INSERT INTO syl_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","আব্‌রাম আর নাহুর দুইজনে বিয়া করছলা। আব্‌রামর বউর নাম আছিল ছারা। আর নাহুরর বউর নাম মিলকা। মিলকা আর ইসকা আছলা হারনর পুড়িন। ");
INSERT INTO syl_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","অইলে ছারার কুনু পুয়া-পুড়ি আছিল না, তাইন নিআওলাদি আছলা। ");
INSERT INTO syl_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","তারেখে আব্‌রাম, লুত আর ছারারে লইয়া কেনান দেশো যাওয়ার লাগি বাবিল দেশর উর টাউন থাকি রওয়ানা অইলা। আব্‌রাম অইলা তারেখর পুয়া, হারনর পুয়া লুত অইলা তারেখর নাতি, আর ছারা অইলা তারেখর পুয়া আব্‌রামর বউ। পয়লা তারা হারান নামে এক টাউনো গেলা আর হখানো বসত করলা। ");
INSERT INTO syl_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","তারেখ দুইশো পাচ বরছ বয়সো হারান টাউনো মারা গেলা। ");
INSERT INTO syl_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","বাদে মাবুদে আব্‌রামরে ফরমাইলা, “তুমি তুমার নিজর দেশ, খেশ-কুটুম, আর বাবাইতি ভিটা-মাটি ছাড়িয়া আমি যে দেশ দেখাইমু হউ দেশো যাও। ");
INSERT INTO syl_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","তুমার মাজ থাকি আমি বউত বড় এক জাতি পয়দা করমু। তুমারে রহম-বরকত দিমু। আমি তুমারে বড় ইজ্জতি বানাইমু, আর তুমার উছিলায় আস্তা দুনিয়ার মানষে রহম-বরকত পাইবা। ");
INSERT INTO syl_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","আর হুনো, তুমারে যারা দোয়া দিবা, আমি আল্লায় তারারে রহম-বরকত দিমু, অইলে যারা তুমারে বদদোয়া দিবা, আমি তারারে লান্নত দিমু। দুনিয়ার হকল জাতিয়ে তুমার উছিলায় রহম-বরকত পাইবা।” ");
INSERT INTO syl_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","মাবুদর হুকুম মতউ আব্‌রাম বার অইগেলা, তান ভাতিজা লুতও তান লগে গেলা। হারান টাউন ফালাইয়া যাওয়ার সময় আব্‌রামর বয়স আছিল পচত্তইর বরছ। ");
INSERT INTO syl_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","তান বিবি ছারা আর ভাতিজা লুতরে লইয়া তাইন বার অইলা। হকল মাল-ছামানা লইয়া আর যে গুলাম অকলরে তাইন-তাইন হারান এলাকাত পাইছলা তারারে লইয়া কেনান দেশো যাইতা করি রওয়ানা দিলা। হেশে হনো গিয়া পৌছলা। ");
INSERT INTO syl_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","কেনানর মাজেদি যাইতে যাইতে আব্‌রাম শিখিমো আইয়া মোরির এলন গাছর গেছে জিরাইলা। ই সময় কেনানী অকল হউ দেশো বসত করতা। ");
INSERT INTO syl_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","মাবুদে আব্‌রামরে দরশন দিয়া কইলা, ই দেশখান আমি তুমার ওয়ারিশরে দিলাইমু। আব্‌রামরে যেইন দেখা দিলা, হউ মাবুদর নামে তাইন হনো এক কুরবানি খানা বানাইলা। ");
INSERT INTO syl_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","হন থাকি তাইন বেথেল টাউনর পুবেদি পাহাড়ি এলাকাত আগুয়াই গেলা, গিয়া পইচমে বেথেল পুবে অয় টাউনর মাজখানো তাইন তাম্বু গাড়িলা। মাবুদর নামে তাইন ইনো এক কুরবানি খানা বানাইলা আর মাবুদর নাম লইলা। ");
INSERT INTO syl_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","বাদে তাইন হিন থাকি হরতে হরতে নেগেভ নামর দউকনর মরুভুমির বায়দি গেলাগি। ");
INSERT INTO syl_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","ই সময় কেনান দেশো নিদান দেখা দিলো। ই নিদান খুব কঠিন অওয়ায়, আব্‌রামে মুছাফির অইয়া মিসর দেশো গেলাগি। ");
INSERT INTO syl_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","মিসরর কান্দাত আইয়া আব্‌রামে তান বিবি ছারারে কইলা, “হুনো, আমি জানি তুমি খুব সুন্দরি। ");
INSERT INTO syl_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","তুমি যেবলা মিসরী অকলর চউখো পড়বায়, তেউ তারা বুজবো তুমি আমার বউ, আর তুমারে রাখিয়া আমারে খুন করিলিবো। ");
INSERT INTO syl_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","এরলাগি কইও, তুমি আমার বইন। এতে তুমার লাগি আমার ভালা অইবো, আর আমারে বাচাইয়া রাখবো।” ");
INSERT INTO syl_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","আব্‌রাম মিসরো আইয়া হারলে মিসরর মানষে দেখলা ছারা খুব সুন্দরি। ");
INSERT INTO syl_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","মিসরর বাদশা ফেরাউনর গুইয়া অকলে তানে দেখিয়া ফেরাউনর গেছে গিয়া তান তারিফ করিয়া বউততা কইলা। আর ছারারে রাজবাড়ির ভিতরে নেওয়া অইলো। ");
INSERT INTO syl_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","ছারার লাগি ফেরাউনে আব্‌রামরে মায়া করতা লাগলা। তাইন আব্‌রামরে বউত গরু-ছাগল, গাধা-গাধী, উট, আর বান্দি-গুলাম উপহার দিলা। ");
INSERT INTO syl_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","অইলে বিবি ছারার লাগি মাবুদে ফেরাউন আর তার বাড়ির হকল মানষর মাজে বেসেবা বেমার পয়দা করলা। ");
INSERT INTO syl_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","তেউ ফেরাউনে আব্‌রামরে নিয়া জিকাইলা, “আপনে আমার লগে ইতা কিতা করলা? তানরে কেনে আপনার বউ না কইয়া ");
INSERT INTO syl_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","বইন কইলা? আর আমি তো তানরে বিয়া করার লাগি নেওয়াইছলাম। এইন তো আপনার বিবি, এনে লইয়া আপনে ইন থাকি হরি যাউক্কাগি।” ");
INSERT INTO syl_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","অউ কথা কইয়া ফেরাউনে তান মানষরে হুকুম করলা, আর তারা আব্‌রামর হকল মাল-ছামানা সহ তানে আর তান বিবিরে বিদায় করি দিলা। ");
INSERT INTO syl_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","তেউ আব্‌রাম আর তান বিবিয়ে হকলতা লইয়া মিসর দেশ ফালাইয়া নেগেভ মরুভুমিত গেলাগি, লুতও তান লগে আছলা। ");
INSERT INTO syl_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","আব্‌রাম খুব ধনি আছলা, তান বউত হেমান-জানোয়ার আর সোনা-রুপা আছিল। ");
INSERT INTO syl_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","বাদে তাইন নেগেভ থাকি হরতে হরতে বেথেল পর্যন্ত গেলা। গিয়া তাইন বেথেল আর অয় টাউনর মাজখানো পৌছলা, যে জাগাত তাইন আগে তাম্বু গাড়িছলা ");
INSERT INTO syl_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","আর পয়লা কুরবানি খানা বানাইছলা। অনো গিয়া তাইন হিরবার মাবুদর নাম লইলা। ");
INSERT INTO syl_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","আব্‌রামর লগে মুছাফির আছলা তান ভাতিজা লুত, এনও বউত গরু-ছাগল আর তাম্বু আছিল। ");
INSERT INTO syl_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","অইলে জাগাটা ইলা আছিল না যেন, দুইওজনর পশুর পালে একলগে খাইতা পারবা। গরু-ছাগল আর তাম্বু অতো বেশি আছিল যেন, ইতা লইয়া তারার থাকার উপায় আছিল না। ");
INSERT INTO syl_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","এরলাগি আব্‌রাম আর লুতর রাখাল অকলে হামেশা দরবার-কাইজ্জা করতা। আর হি সময় কেনানী আর ফারিজী অকলও হি দেশো বসত করতো। ");
INSERT INTO syl_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","তেউ আব্‌রামে লুতরে কইলা, “হুনো, আমরা তো দুইওজনউ আপন। তে তুমার-আমার মাজে আর তুমার-আমার রাখালর মাজেও দরবার-কাইজ্জা করা ঠিক নায়। ");
INSERT INTO syl_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","হারা দেশটাউ তুমার ছামনে পড়ি রইছে। তে আও, আমরা আলগা অইযাই। তুমি বাউয়ে পছন্দ করলে, আমি ডাইনে, আর তুমি ডাইনে গেলে, আমি বাউয়ে যাইমু।” ");
INSERT INTO syl_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","লুতে চাইয়া দেখলা, জর্দান গাংগর থল জাগার হকল বায় সোয়ার গাউ পর্যন্ত বউত পানি আছে, মাবুদর বাগিচা বা মিসর দেশর লাখান ই জাগাও ঘাস-পানি আলা। অউ সময়ও মাবুদে ছাদুম আর আমুরা টাউন বিনাশ করছইন না। ");
INSERT INTO syl_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","এরলাগি লুতে জর্দান গাংগর হকল থল জাগা নিজর লাগি বাছিয়া পুবেদি হরিয়া গেলাগি। অউলা তারা আলগা অইগেলা। ");
INSERT INTO syl_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","আব্‌রাম কেনান দেশো রইলা, আর লুত হউ থল জমিনর টাউন অকলর কাছাত গিয়া বসত করলা। তাইন ছাদুম টাউনর কিনারো তাম্বু গাড়িল্লা। ");
INSERT INTO syl_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","ছাদুমর মানুষ অকল খুব খবিছ আছিল, মাবুদর নজরো তারা বেথায়া গুনাগার। ");
INSERT INTO syl_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","লুত আলগা অওয়ার বাদে মাবুদে আব্‌রামরে কইলা, “তুমি যে জাগাত উবাইছো, ইখান থাকি উতরে-দউকনে, পুবে-পইচমে একবার চাইয়া দেখো। ");
INSERT INTO syl_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","যে জাগা অকল তুমি দেখরায়, ইতা আমি তুমারে আর তুমার ওয়ারিশ অকলরে হামেশাকুর লাগি দিলাইমু। ");
INSERT INTO syl_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","আমি তুমার ওয়ারিশরে দুনিয়াইর ধুইল-বালুর লাখান বেহিসাব করমু। দুনিয়ার ধুইল-বালু যুদি কেউ গনিয়া ফুড়াইতো পারে, তে তুমার ওয়ারিশরেও গনতো পারবো। ");
INSERT INTO syl_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","উঠো, আস্তা দেশটা তুমি একবার ঘুরিয়া আও, অউ দেশউ আমি তুমারে দিমু।” ");
INSERT INTO syl_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","তেউ আব্‌রামে তান তাম্বু তুলিয়া, হেবরন এলাকাত মম্রির এলন বনর কান্দাত নিয়া গাড়িলা। হখানো তাইন মাবুদর লাগি কুরবানি খানা বানাইলা। ");
INSERT INTO syl_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","বাবিল দেশর বাদশা অম্রাফেল, ইল্লাসরর বাদশা আরিয়াক, ইলামর বাদশা কদর-লাউমর আর গোয়ীমর বাদশা তিদিয়ল, এরা চাইরোজনে এক অইয়া ");
INSERT INTO syl_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ছাদুমর বাদশা বিরা, আমুরার বাদশা বিরশা, অদমার বাদশা শিনাব, ছবয়িমর বাদশা শিমেবর আর বিলার বা সোয়ারর বাদশার বিরুদ্ধে যুদ্ধ করাত গেলা। ");
INSERT INTO syl_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","অউ পাচজন বাদশায় তারার সিপাই অকলরে একখানো করিয়া সিদ্দিমর তল জাগাত লইয়া গেলা। ই জাগারে লোনা সাগর কইন। ");
INSERT INTO syl_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","হি বাদশা অকলে বারো বরছ বাদশা কদর-লাউমরর গুলামি করিয়া তেরো বছরর সময় বিদ্রোহ করলা। ");
INSERT INTO syl_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","এর বাদর বরছ বাদশা কদর-লাউমর আর তান লগর বাদশা অকলে গিয়া অস্তরোথ-কর্নয়ীমো রফায়ী অকলরে, হমো গিয়া জুজী অকলরে, আর শাবী-কিরিয়াতাইমো গিয়া এইমী অকলরে আরাইলা। ");
INSERT INTO syl_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","বাদে মরুভুমির কাছার এল-ফারন পর্যন্ত সেয়ীর পাহাড়র হোরীয় অকলরেও আরাইলা। ");
INSERT INTO syl_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","হেশে অউ বাদশা অকলে ঘুরিয়া গিয়া ঐন-মিস্পটো বা কাদেশ গেলা। তারা আমালেকী অকলর আস্তা দেশ দখল করলা আর হাজাজন-তামার টাউনো যে আমোরী অকল আছিল তারারেও দখল করলা। ");
INSERT INTO syl_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","বাদে ছাদুম, আমুরা, অদমা, ছবয়িম আর বিলা বা সোয়ারর বাদশা অকলে ");
INSERT INTO syl_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ইলামর বাদশা কদর-লাউমর, গোয়ীমর বাদশা তিদিয়ল, বাবিলর বাদশা অম্রাফেল আর ইল্লাসরর বাদশা আরিয়াকর লগে যুদ্ধ করার লাগি সিদ্দিম নামর তল জাগাত তারার সিপাই অকল হাজাইলা। চাইর বাদশার বিরুদ্ধে পাচ বাদশায় লাগলা। ");
INSERT INTO syl_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","সিদ্দিমর তল জাগাত তারতেলর বউত গাত-গাড়া আছিল। ছাদুম আর আমুরার বাদশাইন যেবলা বাগিয়া যাইরা, ই সময় তারার লগর কেউ কেউ অউ তারতেলর গাতো পড়ি গেলা, আর বাকি অকলে বাগিয়া পাহাড়ো গেলা। ");
INSERT INTO syl_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","তেউ তারার দুশমন অকলে ছাদুম-আমুরার হকল ধন-ছামানা আর খানি-দানির হকলতা লুটিয়া লইয়া গেলগি। ");
INSERT INTO syl_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","আর তারা আব্‌রামর ভাতিজা লুতর হকল মাল-ছামানা সুদ্ধা হউ লুতরেউ ধরিয়া লইয়া গেলাগি, কারন এইনেউ ছাদুম টাউনো রইতা। ");
INSERT INTO syl_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","তেউ একজনে বাগিয়া আইয়া ইবরানি আব্‌রামরে অউ খবর দিলো। আব্‌রাম ই সময় আমোরী মম্রির এলন বনর কাছাত থাকতা। ই মম্রি আছলা আশকুল আর আনেরর ভাই, আব্‌রামর লগে এরার যুদ্ধর সাইয্যর চুক্তি আছিল। ");
INSERT INTO syl_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","তান ভাতিজারে ধরিয়া লইয়া গেছইনগি হুনিয়া আব্‌রামে লাড়াই জানরা নিজর তিনশো আঠারো জন গুলামরে লইয়া দান টাউন পর্যন্ত দুশমনর খরে খরে গেলা। অউ গুলাম অকল তান বাড়িতউ জন্মিছিল। ");
INSERT INTO syl_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","রাইতকুর বালা দুশমন দলর লাগাল পাইয়া এরা হামলা করিয়া হেরারে আরাইল্লা, আর খেদাইতে খেদাইতে দামেস্ক টাউনর উতরে হোবা পর্যন্ত গেলা। ");
INSERT INTO syl_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","লুট করা হক্কল জিনিস তাইন ফিরাইয়া আনলা, মাল-ছামানা সুদ্ধা তান ভাতিজা লুতরেও উদ্ধার করলা। এর লগে হকল বেটিন্তরে আর হকল মানষরেও উদ্ধার করি আনলা। ");
INSERT INTO syl_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","কদর-লাউমর আর তার লগর বাদশা অকলরে আরাইয়া আব্‌রাম ফিরিয়া আওয়ার সময় ছাদুমর বাদশায় তান লগে দেখা করার লাগি শাবী বা বাদশা নামর তল জাগাত বার অইয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","আর শালেমর বাদশা মালকী-সিদ্দিকে আব্‌রামর লাগি রুটি আর আংগুরর শরবত লইয়া আইলা, তাইন অইলা আল্লাতালার পছন্দর ইমাম। ");
INSERT INTO syl_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","তাইন আব্‌রামরে দোয়া করিয়া কইলা, “যেইন আছমান আর জমিন পয়দা করছইন, হউ আল্লাতালা আব্‌রামরে বরকত দান করউক্কা। ");
INSERT INTO syl_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","আপনার দুশমন অকলরে যেইন আপনার আতো সপিছইন, তান নাম ধইন্য অউক।” অউ আব্‌রামে তান হক্কলতার দশবাটর একবাট মালকী-সিদ্দিকরে দিলাইলা। ");
INSERT INTO syl_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","আর ছাদুমর বাদশায় আব্‌রামরে কইলা, “আপনে মাল-ছামানা হকলতা রাখি দেউক্কা, খালি মানুষ গুইন আমারে ফিরত দিলাইন।” ");
INSERT INTO syl_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","আব্‌রামে ছাদুমর বাদশারে কইলা, “যেইন আছমান-জমিন পয়দা করছইন হউ মাবুদ আল্লাতালার নামে আমি আত তুলিয়া কছম করছি, ");
INSERT INTO syl_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","আপনার কুনু জিনিসউ, একছা সুতাউ বা পাওর জুতার একছা ফিতাও আমি নিতাম নায়। আরনায় বাদে আপনে কইবা, আমার ধনেউ আব্‌রাম ধনি অইছে। ");
INSERT INTO syl_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","আমার মানষে যেতা খাইলিছইন ইতা ছাড়া আমি আর কিচ্ছু নিতাম নায়। খালি আনের, আশকুল আর মম্রি যেরা আমার লগে গেছলা, তারার পাওনা বাট তারা নেউক্কাগি।” ");
INSERT INTO syl_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","অতা ঘটনা অকলর বাদে ওহীর মাজে মাবুদর কালাম আব্‌রামর গেছে নাজিল অইলো। তাইন কইলা, “ও আব্‌রাম, ডরাইও না, আমিউ তুমার হেফাজতকারি, তুমার বউত বড় পুরুস্কার।” ");
INSERT INTO syl_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","আব্‌রামে কইলা, “ও মাবুদ মউলা, আমারে কিতা দিতায়? আমি তো নিআওলাদি। আমি মরার বাদে দামেস্কর এলিয়েজের আমার সম্পত্তির মালিক অইবো। ");
INSERT INTO syl_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","তুমি তো আমারে কুনু আওলাদ দিলায় না, এরলাগি আমার বাড়ির গুলাম আমার ওয়ারিশ অইবো।” ");
INSERT INTO syl_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","অউ মাবুদে আব্‌রামরে কইলা, “না, হে নায়, তুমার নিজর বউর আওলাদউ তুমার ওয়ারিশ অইবো।” ");
INSERT INTO syl_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","মাবুদে আব্‌রামরে বারে আনিয়া কইলা, “আছমানর বায় চাও, আর পারলে অউ তেরা অকল গনিয়া ফুড়াও, তুমার বংশর ওয়ারিশ অউলা বেহিসাব অইবো।” ");
INSERT INTO syl_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","আব্‌রামে মাবুদর অউ ওয়াদারে একিন করলা, আর মাবুদে হউ একিনরে দীনদারি কাম হিসাবে কবুল করলা। ");
INSERT INTO syl_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","আর তাইন আব্‌রামরে কইলা, “আমিউ মাবুদ। ই কেনান দেশর অধিকারি অইবার লাগি আমি তুমারে বাবিল দেশর উর টাউন থাকি বার করিয়া আনছি।” ");
INSERT INTO syl_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","অউ আব্‌রামে কইলা, “ও মাবুদ মউলা, আমি ইতার মালিক অইমু করি কিলা বুজমু?” ");
INSERT INTO syl_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","তাইন কইলা, “তুমি তিন বছরর একটা করি ডেকি, ছাগি, আর মেড়ার পাঠা আমার ছামনে লইয়া আও, এর লগে একটা ডুপি পাখি আর একটা পারোর বাইচ্চাও আনিও।” ");
INSERT INTO syl_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","আব্‌রামে অউলা করলা। তাইন ইতা হকলটি আনিয়া দুই টুকরা করিয়া উল্টা-উল্টি করি হাজাইয়া রাখলা, খালি পাখি অকলরে টুকরাইলা না। ");
INSERT INTO syl_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","তেউ হকুন আইয়া অউ টুকরা অকলর উপরে পড়লে, আব্‌রামে খেদাইলা। ");
INSERT INTO syl_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","সুরুজ ডুবার সময় আব্‌রামর এক বেউশি ঘুম আইলো। ঘুমর মাজে বেথায়া ডর আর আন্দাইরে তানে আছর করলো। ");
INSERT INTO syl_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","অউ মাবুদে তানরে কইলা, “তুমি নিচ্চয় অইয়া জানিও, তুমার ওয়ারিশ অকলে অউলা দেশো গিয়া রইবা যেকটা তারার নিজর নায়। হনো তারা খুব জুলুম-মছিবতর মাজে রইয়া চাইরশো বরছ পর্যন্ত গুলামি করবা। ");
INSERT INTO syl_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","আর যে জাতিয়ে তারারে গুলাম বানাইবা, আমি হি জাতির বিচার করমু। বাদে তারা বউত ধন-দৌলত লইয়া হন থনে বার অইয়া আইবা। ");
INSERT INTO syl_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","আর তুমি শান্তিয়ে তুমার বাফ-দাদার গেছে যাইবায়। তুমি পুরা মুরব্বি বয়সো কয়বরো হামাইবায়। ");
INSERT INTO syl_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","তুমার চাইর ছিড়ি বাদে এরা অনো ফিরিয়া আইবা, কারন আমোরী অকলর গুনা অখনও পুরা অইছে না।” ");
INSERT INTO syl_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","সুরুজ ডুবিয়া যেবলা আন্দাইর অইগেল অউ সময় ধুমায় ভরা এক উন্দাল আর আগুনির মুশাল হউ হাজাইয়া রাখা কুরবানির টুকরাইন্তর মাজেদি গেল। ");
INSERT INTO syl_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","মাবুদে হউ দিনউ আব্‌রামর লগে অউলা ওয়াদা করলা, “মিসরর গাং থনে বড় গাং ফোরাত পর্যন্ত আস্তা দেশ আমি তুমার ওয়ারিশরে দিলাম। ");
INSERT INTO syl_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ইকটা অইলো কেনী, কনিজী, কদমোনী, ");
INSERT INTO syl_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","হিট্টী, ফারিজী, রফায়ী, ");
INSERT INTO syl_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","আমোরী, কেনানী, গির্গাশী আর যিবুজী অকলর দেশ।” ");
INSERT INTO syl_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","বিবি ছারার পেটো আব্‌রামর কুনু হুরুতা অইছইন না, অইলে হাজেরা নামে ছারার এক মিসরী বান্দি বেটি আছলা। ");
INSERT INTO syl_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","একদিন ছারায় আব্‌রামরে কইলা, “হুনো, মাবুদে আমারে নিআওলাদি করছইন। তে তুমি আমার বান্দির কাছাত যাও, কিবা তাইরে দিয়া আমি আওলাদ পাইলিতাম পারি।” অউ আব্‌রামও ছারার মাতে রাজি অইলা। ");
INSERT INTO syl_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","কেনান দেশো আব্‌রাম দশ বরছ রওয়ার বাদে ছারায় তান মিসরী বান্দি হাজেরারে নিজর জামাই আব্‌রামর লগে বিয়া দিলা। ");
INSERT INTO syl_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","বাদে আব্‌রাম আর হাজেরা একখানো রইলে তাইর পেটো হুরুতা আইলো। হাজেরায় যেবলা বুজলো তাইর হুরুতা অইতা তেউ তাইর মালিক বিবির বায় বড়াই দেখানিত লাগলো। ");
INSERT INTO syl_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","অউ ছারায় আব্‌রামরে কইলা, “আমার বায় তাইর বেয়াদবির লাগি তুমিউ দায়ী। আমার ই বান্দিরে আমিউ তুমার বিছনাত তুলিয়া দিছলাম, আর অখন তাইর হুরুতা অইতা করি আমারে বড়াই দেখার। মাবুদে তুমার-আমার বিচার করউক্কা।” ");
INSERT INTO syl_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","আব্‌রামে ছারারে কইলা, “দেখো, তুমার বান্দি তো তুমার আতোউ আছে। তুমার যেলা ভালা মনে কয় অলাউ করো।” অউ ছারায় হাজেরারে অউলা দুখ দিলা, দুখে তাই তান গেছ থাকি বাগিয়া গেলগি। ");
INSERT INTO syl_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","পথো মরুভুমির মাজে একটা পানির ইন্দারার কাছাত মাবুদর ফিরিস্তায় হাজেরারে পাইলা। ই ইন্দারা আছিল শুর নামর জাগাত যাওয়ার পথো। ");
INSERT INTO syl_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ফিরিস্তায় কইলা, “ও ছারার বান্দি হাজেরা, তুমি কই থাকি আইরায় আর কই যাইতায়?” হাজেরায় কইলো, “আমি আমার মালিক বিবি ছারার গেছ থাকি বাগিয়া যাইরামগি।” ");
INSERT INTO syl_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","তেউ মাবুদর ফিরিস্তায় কইলা, “তুমার মালিক বিবির গেছে ফিরিয়া গিয়া কল্লা নোয়াইয়া হিরবার তান খেজমতো লাগো।” ");
INSERT INTO syl_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","তাইন আরো কইলা, “আমি তুমার ওয়ারিশ অউলা বাড়াই দিমু, তারারে গনিয়া ফুড়াইতো নায়। ");
INSERT INTO syl_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","হুনো, তুমার পেটো হুরুতা আছে। তুমার এক পুয়া অইবো, তার নাম রাখিও ইছমাইল মানি, আল্লায় হুনইন, কারন মাবুদে তুমার দুখ হুনছইন। ");
INSERT INTO syl_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","আর বড় অইলে হে লাগাম ছাড়া ঘোড়ার লাখান অইবো। হে হক্কলর বায় আত তুলবো, আর হক্কলে তার বায় আত তুলবা। ভাইয়াইন্তর লগে হামেশা তার লাগ থাকবো।” ");
INSERT INTO syl_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","আর হাজেরার লগে মাবুদে মাতিলা করি, তাই তান নাম দিলো “তুমি দেখা দেনেআলা আল্লা”; তাই কইলো, “যেইন আমারে দেখইন, আমি অনোউ তানরে দেখলাম নায় নি?” ");
INSERT INTO syl_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","এরলাগি কাদেশ আর বেরেদর মাজর হি কুয়ার নাম অইলো, বের-লহয়-রোয়ী মানি, যেইন জিন্দা আর আমারে দেখরা, তান কুয়া। ");
INSERT INTO syl_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","বাদে সময় আইলে হাজেরার ঘরো এক পুয়া অইলো, আব্‌রামে অউ পুয়ার নাম রাখলা ইছমাইল। ");
INSERT INTO syl_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","আব্‌রামর বয়স যেবলা ছিয়াশি বছর অইগেছে, অউ সময় হাজেরার ঘরো ইছমাইলর জনম অইলো। ");
INSERT INTO syl_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","আব্‌রামর নিরান্নব্বই বরছর সময় মাবুদে হিরবার তানরে দিদার দিয়া কইলা, “আমি সর্ব-শক্তিমান আল্লা। তুমি আমার দেওয়া পথো থাকিয়া কামিল অও। ");
INSERT INTO syl_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","আমি তুমার-আমার মাজে চুক্তি কাইম করমু আর তুমার ওয়ারিশ খুব বেশি বাড়াই দিমু।” ");
INSERT INTO syl_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","তেউ আব্‌রাম সইজদাত পড়লা, আর আল্লায় তান লগে বাতচিত করি কইলা, ");
INSERT INTO syl_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“তুমার লগে আমি ওয়াদা কাইম করিয়ার, তুমি বউত জাতির মুল বাফ অইবায়। ");
INSERT INTO syl_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","তুমারে আর আব্‌রাম মানি, বড় বাফ কইয়া ডাকা অইতো নায়, অখন থাকি তুমার নাম অইলো ইব্রাহিম মানি, বউত জাতির বাফ, আমি তুমারে বউত জাতির মুল বাফ বানাইলাম। ");
INSERT INTO syl_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","আমি তুমারে বউত ফলআলা করমু, আর তুমার মাজ থনে বউত জাতি আর বাদশা অকল পয়দা করমু। ");
INSERT INTO syl_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","আমি তুমার আর তুমার ওয়ারিশর পর ওয়ারিশ অকলর লগে যে চুক্তি কাইম করমু, ইকটা হর-হামেশা বওয়াল থাকবো, অউ উছিলায় আমি তুমার আর তুমার ওয়ারিশর পর ওয়ারিশ অকলর আল্লা অইমু। ");
INSERT INTO syl_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","আর যে কেনান দেশো তুমি অখন মুছাফির অইয়া থাকরায়, ই পুরাটাউ আমি তুমারে আর তুমার ওয়ারিশ অকলরে হর-হামেশাকুর দখলর লাগি দিমু। আমি তারার আল্লা অইমু।” ");
INSERT INTO syl_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","আল্লায় ইব্রাহিমরে কইলা, “তুমি আমার কাইম করা চুক্তি মানিও, তুমি আর তুমার ওয়ারিশর পর ওয়ারিশ অকলেও মানিয়া চলিও। ");
INSERT INTO syl_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","তুমরার লগে আর তুমরার ওয়ারিশর লগে আমার অউলা চুক্তি কাইম অইলো, তুমরার হকল বেটাইন্তর মছলমানি কাম করাইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","তুমরা হকলে নিজর পুরুষ অংগর মুখার চামড়া কাটবায়। অকটাউ তুমরার আর আমার মাজে বওয়াল করা চুক্তির নিশানা। ");
INSERT INTO syl_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","ওয়ারিশর পর ওয়ারিশ ধরিয়া তুমরার হকল পুয়াইন্তরে জন্মর আট দিনর দিন মছলমানি করাইবায়। যারা তুমার ওয়ারিশ নায়, খালি তুমরার বাড়িত জন্মিছে বা তুমরার খরিদা গুলাম, তারারও মছলমানি করানি লাগবো। ");
INSERT INTO syl_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","তুমরার ঘরো জন্মিছে বা খরিদা গুলাম অকলরে নিচয় মছলমানি করাইবায়। তুমরার শরিলো জারি করা আমার ই চুক্তি হর-হামেশাকুর চুক্তি অইবো। ");
INSERT INTO syl_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","যে বেটায় পুরুষ অংগর মুখার চামড়া কাটতো নায়, তারে তার জাতির মাজ থাকি ফুছিয়া ফালাইল অইবো। হে তো আমার চুক্তির বরখেলাফ করছে।” ");
INSERT INTO syl_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","আল্লায় ইব্রাহিমরে কইলা, “তুমার বিবিরে আর ছারা কইয়া ডাকিও না। এন নাম অইবো ছায়রা মানি, রানী। ");
INSERT INTO syl_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","আমি তাইরে বরকত নাজিল করমু, তাইর ঘরো তুমার এক পুয়া দিমু। আর বরকত নাজিল করিয়া বউত জাতির মুল মা বানাইমু, আর বউত মুল্লুকর বাদশা অকলও পয়দা অইবা।” ");
INSERT INTO syl_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","অউ ইব্রাহিমে মাটিত সইজদাত পড়ি আসিয়া মনে মনে কইলা, “হাছাউ একশো বছরর বুড়ার হুরুতা অইতো নি! তা-ও নব্বই বছরর বুড়ি ছায়রার পেটো?” ");
INSERT INTO syl_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","তাইন আল্লারে কইলা, “আহ! ইছমাইলগু যানু তুমার রহমতে বাচিয়া থাকে।” ");
INSERT INTO syl_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","অউ আল্লায় ফরমাইলা, “ঠিক আছে। অইলে তুমার বিবি ছায়রার পেটো হাছাউ তুমার পুয়া অইবো, তুমি তার নাম রাখবায় ইছহাক মানি, হে আসে। তার লগে আমার চুক্তি কাইম করমু, তার ওয়ারিশর লগে ইকটা আমার হর-হামেশাকুর চুক্তি অইবো। ");
INSERT INTO syl_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","আর ইছমাইলর লাগিও তুমার দোয়া হুনছি। হুনো, আমি তারেও বরকত নাজিল করমু আর তারে ফলআলা করিয়া বউত বাড়াই দিমু। হে বারোজন রাজার বাফ অইবো আর তার মাজেদি আমি বিরাট জাতি পয়দা করমু। ");
INSERT INTO syl_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","ছামনর বরছ ই চান্দো ছায়রার ঘরো তুমার যে হুরুতা অইবো, হউ ইছহাকর লগে আমি আমার চুক্তি কাইম করমু।” ");
INSERT INTO syl_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","ইব্রাহিমর লগে বাতচিত শেষ করিয়া আল্লায় তান গেছ থাকি উঠিয়া তশরিফ নিলাগি। ");
INSERT INTO syl_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","আল্লার হুকুম মত ইব্রাহিমে হউ দিনউ ইছমাইলরে মছলমানি করাইলা। এর লগে খরিদা গুলাম অকল আর তান বাড়িত জন্মিছে ইলা হকল গুলামরে, বাড়ির হক্কল বেটাইন্তরে মছলমানি করাইলা। ");
INSERT INTO syl_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","ইব্রাহিমর নিজর মছলমানি কাম করানির সময় তান বয়স আছিল নিরান্নব্বই বরছ, ");
INSERT INTO syl_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","আর তান পুয়া ইছমাইলর বয়স তেরো। ");
INSERT INTO syl_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","এক দিনেউ ইব্রাহিম আর তান পুয়া ইছমাইলর মছলমানি করাইল অইলো। ");
INSERT INTO syl_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","হি দিন বাড়ির হকল বেটাইন্তর, যারা তান বাড়িত জন্মিছিল আর যেরারে বিদেশ থাকি লইয়া আনছইন, ইতা হকলরউ মছলমানি কাম একলগে করাইল অইলো। ");
INSERT INTO syl_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","বাদে মম্রির এলন বনর কাছাত মাবুদে ইব্রাহিমরে দেখা দিলা। তাইন দিনর গরমর সময় তাম্বুর দরজাত বওয়াত আছলা। ");
INSERT INTO syl_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","অউলা সময় চউখ তুলিয়া দেখলা, তান ছামনে তিনজন মানুষ উবাই রইছইন। দেখিয়াউ তাইন দরজার গেছ থাকি দৌড়াইয়া গিয়া, মাটিত সইজদা করিয়া তারারে কইলা, ");
INSERT INTO syl_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","“ও মুনিব, আমি যুদি আপনারার মায়ার কুনু মানুষ অই, তাইলে আপনারার ই গুলামরে ফালাইয়া যাইন না যেন। ");
INSERT INTO syl_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","আমি থুড়া পানি আনিয়া দিয়ার আপনারা আত-পাও ধইয়া, অউ গাছ তলাত জিরাউক্কা। ");
INSERT INTO syl_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","আর ই গুলামর কাছাত যেবলা আইছইন, তে থুড়া খানি আনিয়া দেই, অতা খাইয়া জানো আরাম অইলে আপনারা হিরবার রওয়ানা দিবানে।” তারা কইলা, “ভালা, আপনে যেবলা কইরা, তে করউক্কা।” ");
INSERT INTO syl_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","ইব্রাহিমে লগে লগে ভিতরে গিয়া ছায়রারে কইলা, “জলদি করিয়া তিন পেটু ভালা ময়দা মাখিয়া পিঠা বানাও।” ");
INSERT INTO syl_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","তাইন দৌড়াইয়া গিয়া গরুর পাল থনে খুব ভালা একটা কছমা বাছুর আনিয়া তান গুলামরে দিলা। হে-ও জলদি করি অকটা রান্দিলো। ");
INSERT INTO syl_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","অউ ইব্রাহিমে দুধ, দই আর গোস্ত আনিয়া তারারে খাইবার দিলা, তারা খাওয়া-দাওয়া করলা। তাইন তারার কান্দাত গাছ তলাত উবাইলা। ");
INSERT INTO syl_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","তারা ইব্রাহিমরে জিকাইলা, “আপনার বিবি ছায়রা কই?” তাইন কইলা, “অউনু, তাম্বুর ভিতরে আছইন।” ");
INSERT INTO syl_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","অউ এরার মাজে একজনে কইলা, “ছামনর বরছ ই চান্দো আমি অবশ্যউ আপনার গেছে আইমু। দেখবা, অউ সময় আপনার বিবি ছায়রার কুলো এক পুয়া থাকবো।” ছায়রায় ইব্রাহিমর খরে তাম্বুর দরজাত উবাইয়া ইতা হুনলা। ");
INSERT INTO syl_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","ই সময় ইব্রাহিম আর ছায়রা বুড়া-জইফ অইগেছইন, হুরুতা অওয়ার লাখান বয়সও ছায়রার রইছিল না। ");
INSERT INTO syl_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","এরলাগি ছায়রায় মনে মনে আসিয়া কইলা, “আমার অউলা হেশকালি বয়সো ইতা খুশি আর আইবো নি? আমার মালিকও মুরব্বি অইগেছইন।” ");
INSERT INTO syl_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","তেউ মাবুদে ইব্রাহিমরে কইলা, “ছায়রায় কিতার লাগি ইতা কইয়া আসলো যেন, হাছাউ আমার হুরুতা অইবো নি, আমি তো বুড়ি? ");
INSERT INTO syl_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","মাবুদে পারইন না ইলা কুন্তা আছে নি? দেখিও, ঠিক সময়ে আমি হিরবার তুমার গেছে আইমু, আর ই সময় ছায়রার কুলো পুয়া থাকবো।” ");
INSERT INTO syl_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","ছায়রায় ডরাইয়া কইলা, “জি না, আমি তো আসছি না।” অউ তাইন কইলা, “না রেগো, তুমি নু আসিলায়।” ");
INSERT INTO syl_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","এরবাদে হউ তিনজনে ইন থনে উঠিয়া ছাদুমর বায় চাইলা। ইব্রাহিমে তারার লগে অইয়া বিদায় দেওয়াত গেলা। ");
INSERT INTO syl_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","তেউ মাবুদে কইলা, “আমি যেতা করতাম চাইয়ার, ইতা কুনু ইব্রাহিমরে লুকাইতাম নি? ");
INSERT INTO syl_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","ইব্রাহিম থাকিয়াউ তো আমি এক মহান হিম্মত আলা জাতি পয়দা করমু, দুনিয়াইর হকল জাতিয়ে অন থনে বরকত কামাইবা। ");
INSERT INTO syl_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","এরলাগিউ আমি তারে খাতির করছি, হে তার ওয়ারিশ আর তার নিজর হকলরে আমার মর্জি মানিয়া হক আর ইনছাফর কাম করার হুকুম দেয়। তারাও যুদি অউ লাখান চলে, তাইলে আমি মাবুদে ইব্রাহিমর বেয়াপারে যততা কইছি, হকলতাউ পুরা করমু।” ");
INSERT INTO syl_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","বাদে মাবুদে কইলা, “ছাদুম আর আমুরার বিরুদ্ধে খুব নালিশ আর ফরিয়াদ হুনিয়ার, তারার গুনাও খুব বেজুইতা। ");
INSERT INTO syl_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","এরলাগি আমি তলে লামিয়া গিয়া দেখি, আমি যেলা নালিশ হুনিয়ার, ইতা হাছাউ অউলা খারাপ কি না। আর না অইলেও তো দেখমু।” ");
INSERT INTO syl_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","অউ হি দুইওজনে ফিরিয়া ছাদুমর বায় রওয়ানা দিলা আর ইব্রাহিম মাবুদর গেছে উবাই রইলা। ");
INSERT INTO syl_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","বাদে ইব্রাহিমে মাবুদর বায় আগুয়াইয়া গিয়া কইলা, “আপনে গুনাগারর লগে হক মানুষ অকলরেও মারিলাইতা নি? ");
INSERT INTO syl_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","টাউনর মাজে যুদি পইঞ্চাশ জন হক মানুষ থাকে তাইলে হউ পইঞ্চাশ জনর খাতিরে টাউনরে মেহেরবানি না করিয়া বিনাশ করিলাইবা নি? ");
INSERT INTO syl_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","তে আপনার কাম তো অউলা নায়, হক আর গুনাগাররে একলগে মারিলাওয়া, এক হমান সাজা দেওয়া, আপনার লাগি তো ঠিক নায়। যেইন হারা দুনিয়ার বিচার করইন, তাইন কুনু হক ইনছাফ করতা নায় নি?” ");
INSERT INTO syl_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","মাবুদে কইলা, “যুদি ছাদুম টাউনো পইঞ্চাশ জনও হক মানুষ থাকইন, তাইলে তারার খাতিরে আমি আস্তা টাউনরে রেহাই দিলাইমু।” ");
INSERT INTO syl_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","ইব্রাহিমে কইলা, “দেখউক্কা, আমি তো ধুইল আর ছালি ছাড়া কুন্তা নায়, তা-ও আমি সাওস করিয়া আমার মালিকর লগে মাতিয়ার। ");
INSERT INTO syl_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ধরউক্কা, যুদি পইঞ্চাশ জন হক মানুষ না অইয়া পাচ জন কম অয়, তাইলে কিতা অউ পাচ জন কমর লাগি আপনে আস্তা টাউন বিনাশ করিলাইবা নি?” তাইন কইলা, “আমি যুদি হিনো পয়তাল্লিশ জনরে পাই, তাইলে ইকটা বিনাশ করতাম নায়।” ");
INSERT INTO syl_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","ইব্রাহিমে তানরে হিরবার কইলা, “ধরউক্কা, যুদি হিনো চাল্লিশ জন পাওয়া যায়?” মাবুদে কইলা, “হউ চাল্লিশ জনর খাতিরে আমি বিনাশ করতাম নায়।” ");
INSERT INTO syl_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","ইব্রাহিমে কইলা, “আমার মালিক যানু আমার মাতে নারাজ না অইন। আইচ্ছা, যুদি হিনো তিশ জনরে পাওয়া যায়?” তাইন কইলা, “যুদি আমি তিশ জনরেও পাই, তাইলেও আমি বিনাশ করতাম নায়।” ");
INSERT INTO syl_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","ইব্রাহিমে কইলা, “আমি যেবলা হিম্মত করিয়া মালিকর লগে বাতচিত করিয়ার তে হিরবার কইয়ার, যুদি হিনো বিশ জনরে পাওয়া যায়?” মাবুদে জুয়াপ দিলা, “হউ বিশ জনর খাতিরেউ আমি ইকটা বিনাশ করতাম নায়।” ");
INSERT INTO syl_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","হেশে ইব্রাহিমে কইলা, “আমার মালিক যানু নারাজ না অইন, আমি খালি আরো একবারতা কইয়ার, যুদি হিনো দশ জন থাকইন?” মাবুদে কইলা, “হউ দশ জনর খাতিরেউ আমি ইকটা বিনাশ করতাম নায়।” ");
INSERT INTO syl_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","ইব্রাহিমর লগে মাবুদর বাত-ছওয়াল শেষ অইয়া হারলে রওয়ানা দিলাইলা, আর ইব্রাহিমও তান বাড়িত ফিরিয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","বাদে হাইঞ্জা বালা হউ দুইজন ফিরিস্তা ছাদুম টাউনো গেলা। ই সময় লুত টাউনর মুল গেইটর গেছে বওয়াত আছলা, এরারে দেখিয়া তাইন উবাইলা আর মাটিত সইজদা করিয়া কইলা, ");
INSERT INTO syl_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“ও আমার মালিক অকল, আমি মিনতি করি কইয়ার, দয়া করি আপনারার অউ গুলামর ঘরো তশরিফ আনিলাউক্কা আর আত-পাও ধইয়া রাইতখান কাটাউক্কা। বিয়ানে হিরবার রওয়ানা অইবানে।” এরা কইলা, “না, আমরা অউ টাউনর ময়দানো রাইত কাটাইমু।” ");
INSERT INTO syl_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","তাইন যেবলা খুব মিনত-কাজ্জি কররা অউ সময় এরা তান বাড়িত হামাইলা। বাদে লুতে রুটি বানাইয়া এরার লাগি খানা-দানা জুইত করলা, আর তারা খাইলা। ");
INSERT INTO syl_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","এরার হুতিবার আগেউ ছাদুম টাউনর হক্কল জুয়ান-বুড়া বেটাইন্তে আইয়া হি বাড়িরে বেরিলাইলা, ");
INSERT INTO syl_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","আর লুতরে ডাকিয়া কইলা, “আইজ রাইত যে দুইজন মানুষ তোর ইনো আইছে, তারা কই? অতারে বার করিয়া আমরার গেছে আন। আমরা অতার লগে মউজ করতাম।” ");
INSERT INTO syl_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","অউ সময় লুতে দরজার বারে গিয়া তান খরর দরজা বন্দ করিয়া তারারে কইলা, ");
INSERT INTO syl_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“ভাইয়াইনরে, আমি মিনত করিয়ার, তুমরা ইলা বদ কাম করিও না। ");
INSERT INTO syl_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","দেখো, আমার দুইটা সতী পুড়ি আছে। আমি বার করিয়া তুমরার গেছে লইয়া আইয়ার, তারা কুনু বেটাইন্তর গেছে রইছইন না, তুমরার যেতা মনে চায় করো; তা-ও, ই মানষর লগে তুমরা কুন্তা করিও না, এরা আমার ঘরো আশ্রয় লইছইন।” ");
INSERT INTO syl_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","অইলে তারা কইলো, “যা, যা, পথ থাকি হর!” তারা আরো কইলো, “অই বেটা, তুই একলা বৈতল অইয়া আইছছ আর খালি আমরার উপরে নেতাগিরি কররে। অখন এরার চাইতে তোর লগে আরো বেশি খবিছি করমু।” কইয়াউ তারা লুতরে ঠেলিয়া হরাইয়া দরজা ভাংগতো চাইলো। ");
INSERT INTO syl_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","অউ সময় হউ দুইজনে আত বাড়াইয়া, লুতরে ঘরর ভিতরে টানিয়া নিয়া দরজা বন্দ করি দিলা। ");
INSERT INTO syl_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","আর দরজার বারে উবাইল হুরু-বড় হকল আখতাউ আন্দা অইগেল, আর দরজা তুকাইতে তুকাইতে হেরান অইগেল। ");
INSERT INTO syl_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","বাদে হউ দুইওজনে লুতরে জিকাইলা, “ইনো তুমার আর কে কে আছে? তুমার পুয়া-পুড়ি আর দামান্দরে লইয়া ইন থনে হরিয়া যাওগি। ");
INSERT INTO syl_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","কারন আমরা ই জাগারে ছারখার করিলাইয়ার। ইনর মানষর বিরুদ্ধে মাবুদর গেছে অউলা বেজুইতা নালিশ অইছে যেন, ইকটা বিনাশ করার লাগি তাইন আমরারে পাঠাইছইন।” ");
INSERT INTO syl_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","অউ লুতে বারে গিয়া তান দামান্দ অকলরে কইলা, “আও, তুমরা ই জাগা ছাড়িয়া বারও কারন মাবুদে ই টাউনরে বিনাশ করার লাগি তিয়ার অইরইছইন।” অইলে তারা মনে করলো, তাইন ইতা তামশা কররা। ");
INSERT INTO syl_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","পতাবালা হউ ফিরিস্তায় লুতরে তাগদা দিয়া কইলা, “উঠো, জলদি করি তুমার বউ আর ই দুইও পুড়িরে লইয়া অন থনে যাওগি। নাইলে অউ গজবর মাজে পড়িয়া বিনাশ অইযিবায়।” ");
INSERT INTO syl_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","লুতে যাই-যাইরাম অউলা কররা। অইলে মাবুদর মায়া তান উপরে আছিল করি হউ দুইওজনে, তাইন আর তান বউ আর তান দুইও পুড়িন্তর আতো ধরি টানিয়া টাউনর বারে লইয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","হকলরে বার করিয়া আনার বাদে তারা কইলা, “বাচতে চাইলে বাগো, খরেদি চাইও না, বাগিয়া পাহাড়ো যাও, ই থল জাগার কুনুখানো উবাইও না আরনায় তুমরাও মরবায়।” ");
INSERT INTO syl_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","অউ লুতে কইলা, “ও আমার মালিক অকল, ইলা করইন না যেন; ");
INSERT INTO syl_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","দেখউক্কা, আপনার ই গুলামরে আপনে মেহেরবানি করছইন, আর আমার জান বাচাইবার লাগি আপনে আমারে মহা দয়া দেখাইছইন। অইলে আমি বাগিয়া পাহাড়ো যাইতাম পারতাম নায়। হয়তো ই বিপদ আইয়া আমারে জাতা মারি ধরলে, আমিও মরমু। ");
INSERT INTO syl_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","দেখউক্কা, বাগিয়া যাইতে তো অউ হুরু গাউটা কাছাত আছে। জান বাচাইবার লাগি আমারে অনো পাঠাই দেউক্কা। গাউটা হুরু-মুরু আছে।” ");
INSERT INTO syl_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","তাইন কইলা, “ঠিক আছে, আমি তুমার ই আরজি মানলাম। তুমি যে গাউর কথা কইলায়, ইটা আমি ধ্বংস করতাম নায়। ");
INSERT INTO syl_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","জলদি করি হিনো যাও। তুমি হনো না পৌছানি পর্যন্ত আমি কুন্তা করতাম পারিয়ার না।” লুতর কথার লাগি হউ গাউর নাম অইলো সোয়ার মানি, হুরু। ");
INSERT INTO syl_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","লুতে যেবলা সোয়ারো গিয়া পৌছলা ই সময় সুরুজ উঠিগেছে। ");
INSERT INTO syl_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","এরবাদেউ মাবুদে আছমান থাকি ছাদুম আর আমুরার উপরে আগুইন আর গন্ধকর গজব ছাড়িলা। ");
INSERT INTO syl_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","তাইন হি টাউন অকল, হকল থল জাগা, হক্কল মানুষ আর হি মাটির উপরর হক্কলতা ধ্বংস করিলাইলা। ");
INSERT INTO syl_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","এরমাজে লুতর বউয়ে খরেদি ফিরিয়া চাওয়ায়, তাইন একটা নুনর চাক্কা অইগেলা। ");
INSERT INTO syl_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","বাদর দিন ইব্রাহিমে বিয়ানে উঠিয়া হউ জাগাত গেলা যেনো আগর দিন তাইন মাবুদর গেছে উবাইছলা। ");
INSERT INTO syl_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","তাইন তলে ছাদুম, আমুরা আর হকল থল জাগার বায় চাইয়া দেখলা, ইট-ভাটা থাকি যেলা ধুমা বারয়, অউ লাখান হউ এলাকা থাকি ধুমা উড়ের। ");
INSERT INTO syl_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","আর লুতে যেখানো বসত করতা, হউ থল জাগার টাউন অকল ধ্বংস করার সময়, আল্লায় ইব্রাহিমর কথা মনো করিয়া লুতরে হিনর গজবর মাজ থাকি হরাইয়া আনলা। ");
INSERT INTO syl_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","সোয়ার গাউত রইতে ডরাইলা করি, লুতে তান দুইও পুড়িরে লইয়া হিন থাকি বার অইয়া পাহাড়ো আইয়া, এক গাতর ভিতরে রইলা। ");
INSERT INTO syl_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","একদিন তান বড় পুড়িয়ে হুরু বইনরে কইলো, “বাবা তো মুরব্বি অইগেছইন। আর জগতর সমাজর নিয়ম মত আমরারে বিয়া করার লাগি ইনো কুনু বেটাইনও নায়। ");
INSERT INTO syl_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","তে আয়, আমরা বাবারে শরাব খাওয়াইয়া তান কাছাত রই। তেউ বাবারেদি আমরার বংশ বাচাইতাম পারমু।” ");
INSERT INTO syl_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","অউ তারা দুইওজনে রাইতর বালা তানরে শরাব খাওয়াইয়া টাল বানাইলো। বাদে বড় বইন বাফর গেছে হুতিতো গেল, অইলে কুন সময় হুতিলো আর কুন সময় উঠিলো, বাফে কুন্তাউ টের পাইলা না। ");
INSERT INTO syl_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","বাদর দিন বড়গুয়ে হুরুগুরে কইলো, “দেখ, কাইল রাইত আমি বাবার গেছে হুতিছলাম। আয়, আইজ রাইতও তানে অউলা শরাব খাওয়াইয়া টাল বানাই, বাদে তুইও গিয়া তান গেছে হুতিছ। তে বাবারেদি আমরার বংশ বাচাইতাম পারমু।” ");
INSERT INTO syl_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","অউ লাখান তারা হউ রাইতও তারার বাফরে শরাব খাওয়াইয়া টাল বানাইলো, আর হুরু পুড়ি তাইর বাফর গেছে হুতিল। তাই কুন সময় হুতিল আর কুন সময় উঠিল, ইতা তাইন কুন্তাউ টের পাইলা না। ");
INSERT INTO syl_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","অউ নমুনায় লুতর দুইও পুড়ির পেটো বাফরেদি হুরুতা আইলো। ");
INSERT INTO syl_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","বাদে বড় পুড়ির ঘরো পুয়া অইলে, এর নাম রাখলো মোয়াব মানি, বাবার গেছ থনে। অউ মোয়াবউ অখনকুর মোয়াবী অকলর মুল বাফ। ");
INSERT INTO syl_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","আর হুরু পুড়িরও এক পুয়া অইলো, এর নাম রাখলো বিন-অম্মি মানি, আমার মুল্লুকর পুয়া। হে অখনকুর বনি-আম্মানর মুল বাফ। ");
INSERT INTO syl_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","আর ইব্রাহিমে হিন থনে নেগেভর মরুভুমির বায় গিয়া কাদেশ আর শুরর মাজখানো গেরার দেশো রইলা। ");
INSERT INTO syl_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","হনো হিরবার তান বউ ছায়রারে নিজর বইন কইয়া পরিচয় দিলা। এরলাগি হিনর বাদশা আবিমালিকে মানুষদি ছায়রারে তান গেছে নিলাগি। ");
INSERT INTO syl_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","আর রাইত আল্লায় আবিমালিকরে খোয়াবে কইলা, “হুনো, অউ যে বেটিরে তুমি লইয়া আইছো, তাইর তো জামাই আছে, এরলাগি তুমি অখন মউতর মুখো।” ");
INSERT INTO syl_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","আবিমালিক অখনও ছায়রার গেছে গেছইন না। এরলাগি তাইন কইলা, “ও মালিক, নি-অপরাধি জাতি অইলেও কিতা আপনে মারিলাইতা নি? ");
INSERT INTO syl_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","অউ মানুষটায় তো নিজেউ কইছে, এইন তার বইন। আর অউ বেটিয়েও কইছইন না নি, এইন তান ভাই? আমি তো সরল মনে নি-অপরাধি আতে ই কাম করছি।” ");
INSERT INTO syl_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","আল্লায় খোয়াবে তানরে কইলা, “আমিও জানি, তুমি সরল মনে ই কাম করছো। এরলাগি তুমারে গুনার কাম থাকি আমি দম লওয়াইলাম। তাইরে ছইতে দিলাম না। ");
INSERT INTO syl_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","অখন তুমি তান বিবিরে তান গেছে ফিরত দিলাও। তাইন একজন নবী। তাইন তুমার লাগি দোয়া করবা, তেউ তুমার জান বাচবো। আর যুদি তাইরে ফিরত না দেও, তে জানিলিও, তুমি আর তুমার হকলউ নিচয় মরবায়।” ");
INSERT INTO syl_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","অউ আবিমালিকে ফজরে উঠিয়া তান নিজর উজির-নাজির অকলরে ইতা হকলতা কইলা, ইতা হুনিয়া তারা খুব বেশি ডরাইলা। ");
INSERT INTO syl_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","বাদে আবিমালিকে ইব্রাহিমরে আনাইয়া কইলা, “আপনে আমরার লগে ইতা কুন জাতর বেবহার করলা? আমি আপনার গেছে কিতা দুষ করছি যেন, আপনে আমারে আর আমার বাদশাইরে অতো বড় গুনার দায়ে ফালাইলা? আপনে তো আমার লগে ইতা অইন্যায় কাম করলা।” ");
INSERT INTO syl_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","আবিমালিকে আরো কইলা, “আপনে কিতা দেখিয়া ইলা কাম করলা?” ");
INSERT INTO syl_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","ইব্রাহিমে জুয়াপ দিলা, “আমি মনে করছলাম, ই জাগার মানষর আল্লার বায় কুনু ডর-ভয় নায়, এরলাগি আমার বউর লালছে হয়তো তারা আমারে খুন করবা। ");
INSERT INTO syl_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","আর তাই হাছাউ আমার বইন লাগে, কারন তাই আমার হাতন ঘরর বইন, আর অখন আমার বউ। ");
INSERT INTO syl_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","আল্লায় যেবলা আমারে আমার বাফর বাড়ি থনে বার করি আনলা, অউ সময় আমি তাইরে কইছলাম, ‘তুমি আমারে অউ মায়াখান করিও, আমরা যেনোউ যাই না কেনে, তুমি আমারে তুমার ভাই কইয়া পরিচয় দিও।’ ” ");
INSERT INTO syl_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","বাদে আবিমালিকে কতটা মেড়া-গরু, বান্দি-গুলাম ইব্রাহিমরে দিলা আর তান বিবি ছায়রারেও ফিরত দিলাইলা। ");
INSERT INTO syl_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","আবিমালিকে কইলা, “দেখউক্কা, আমার আস্তা দেশটাউ আপনার ছামনে পড়ি রইছে, তে আপনার যেনো পছন্দ অনোউ রউক্কা।” ");
INSERT INTO syl_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","তাইন ছায়রারে কইলা, “দেখউক্কা, আমি আপনার ভাইরে এক আজার রুপার টেকা দিলাম। আর আপনার ইজ্জতর হকল বিচারর ফয়ছালা অইলো।” ");
INSERT INTO syl_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","বাদে ইব্রাহিমে আল্লার গেছে দোয়া করলা, আর আল্লায় আবিমালিক, তান বউ আর তান বান্দি অকলরে শিফা করলা আর তারার হুরুতাও অইলা। ");
INSERT INTO syl_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","কারন ইব্রাহিমর বিবি ছায়রার লাগি মাবুদে আবিমালিকর বাড়ির হকল বেটিন্তর হুরুতা অওয়া বন্দ করি দিছলা। ");
INSERT INTO syl_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","মাবুদে তান কালাম মুতাবেক বিবি ছায়রারে হেফাজত করলা, তাইন যেলা ওয়াদা করছলা, অলাউ করলা। ");
INSERT INTO syl_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","আর বিবি ছায়রার পেটো হুরুতা আইলো। আল্লায় যে সময়কুর কথা কইছলা, হউ সময়েউ ইব্রাহিমর মুরব্বি বয়সো তান পুয়ার জনম অইলো। ");
INSERT INTO syl_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","ইব্রাহিমে ছায়রার ঘরর তান অউ পুয়ার নাম রাখলা ইছহাক মানি, আসা। ");
INSERT INTO syl_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","আল্লার হুকুম মত তাইন আট দিনর দিন তান পুয়া ইছহাকর মছলমানি কাম করাইলা। ");
INSERT INTO syl_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","ইব্রাহিমর একশো বছরর সময় তান পুয়া ইছহাকর জনম অইলো। ");
INSERT INTO syl_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","বিবি ছায়রায় কইলা, “আল্লায় আমার মুখো আসি বার করলা, আর ইতা যে হুনবো, হে-ও আমার লগে আসিবো।” ");
INSERT INTO syl_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","তাইন আরো কইলা, “ছায়রায় পুয়াইন্তরে বুকুর দুধ খাওয়াইবো, ইতা ইব্রাহিমরে কে কইলো অনে? আর অখন তো অউ বুড়া বয়সো, আমার পেটো তান পুয়া পয়দা অইলো।” ");
INSERT INTO syl_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ইছহাক বড় অওয়ার বাদে যেদিন তানে মাʼর দুধ ছাড়াইল অইলো, হউদিন ইব্রাহিমে এক বড় মেজবানি করলা। ");
INSERT INTO syl_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","আর মিসরী হাজেরার পেটো ইব্রাহিমর যে পুয়া অইছিল, ছায়রায় দেখলা হে তামশা করের। ");
INSERT INTO syl_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","অউ তাইন ইব্রাহিমরে কইলা, “পুয়া সহ ই বান্দিরে বার করি দেও, বান্দির পুয়া আমার ইছহাকর লগে অংশিদার অইতো পারতো নায়।” ");
INSERT INTO syl_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","পুয়ার ইতা হুনিয়া ইব্রাহিমে মনো খুব তকলিফ পাইলা। ");
INSERT INTO syl_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","অউ আল্লায় তানরে কইলা, “তুমার বান্দি আর তাইর পুয়ার লাগি তুমি বেজার অইও না। ছায়রায় যেলা তুমারে কইছে অউলা করো, কারন তুমার পুয়া ইছহাকর খান্দানরেউ তুমার খান্দান কইয়া গনা অইবো। ");
INSERT INTO syl_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","আর ই বান্দির তরফা পুয়া থাকিও আমি একটা জাতি তৈয়ার করমু, কারন হে-ও তো তুমার আওলাদ।” ");
INSERT INTO syl_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","অউ ইব্রাহিমে আগুয়ান উঠিয়া কিছু রুটি আর পানি ভরা একটা চামড়ার থলি হাজাইয়া হাজেরার কান্দো তুলিয়া দিয়া, পুয়াগুরে তাইর আতো সপিয়া বিদায় করলা। হিন থনে বার অইয়া হাজেরায় বের-শেবার মরুভুমির মাজে চক্কর দিতা লাগলা। ");
INSERT INTO syl_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","থলির পানি শেষ অইগেলে তাইন পুয়ারে একটা জংলার তলে হুতাইয়া থইলা। ");
INSERT INTO syl_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","আর এক ডাকর পরিমান দুরই গিয়া তাইন বইরইলা। “পুয়ার মউত যাতে আমার চউখে না দেখি,” মনে মনে কইয়া, তাইন হনো বইয়াউ চিল্লাইয়া কান্দিলা। ");
INSERT INTO syl_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","পুয়াগুর কান্দন আল্লায় হুনলা, আর আল্লার ফিরিস্তায় আছমান থনে ডাকিয়া হাজেরারে কইলা, “হাজেরা, ও হাজেরা, তুমার কিতা অইছে? ডরাইও না, পুয়াগু যেনো আছে, হন থাকিউ তার কান্দন আল্লায় হুনছইন। ");
INSERT INTO syl_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","তুমি উঠিয়া পুয়াগুর আতো ধরো, আমি তারেদি এক বিরাট জাতি পয়দা করমু।” ");
INSERT INTO syl_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","অউ আল্লায় হাজেরার চউখ খুলিয়া দিলা, আর তাইন এক কুয়া দেখলা। হি কুয়া থনে চামড়ার থলিত পানি ভরি আনিয়া পুয়ারে খাওয়াইলা। ");
INSERT INTO syl_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","আল্লায় হউ পুয়ারে হেফাজত করলা। হে বড় অইলো, আর মরুভুমিত থাকিয়া তীর-ধনুক চালানির উস্তাদ অইলো। ");
INSERT INTO syl_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","হে ফারান মরুভুমিত থাকতো। তার মাʼয় মিসরর এক পুড়িরে আনিয়া তারে বিয়া করাইলা। ");
INSERT INTO syl_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","হউ সময় আবিমালিক আর তান সেনাপতি ফীখোলে ইব্রাহিমরে কইলা, “আপনে যেতাউ করইন, অতাতউ আল্লায় আপনার লগে থাকইন। ");
INSERT INTO syl_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","এরলাগি আল্লার নামে আপনে অখন অনো আমার গেছে কছম করউক্কা, আমার বা আমার আওলাদ অকলর লগে, আপনে কুনু বেইমানি করতা নায়। আর আমি যেলা আপনারে দয়া দেখাইছি, আপনেও আমার লগে আর আপনার মুছাফিরির জাগা, ই দেশর লগে অউলা দয়ার নজর রাখবা।” ");
INSERT INTO syl_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","ইব্রাহিমে কইলা, “জিঅয়, কছম করলাম।” ");
INSERT INTO syl_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","আর আবিমালিকর গুলাম অকলে একটা পানির কুয়া জুরে নিছিলগি করি, তাইন নালিশ দিলা। ");
INSERT INTO syl_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","আবিমালিকে জুয়াপ দিলা, “ইতা কাম কে করছে আমি তো জানি না। আপনেও আমারে ইতা কইছইন না, আইজউ আমি ইকটা হুনলাম।” ");
INSERT INTO syl_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","বাদে ইব্রাহিমে কিছু মেড়া আর গরু আনিয়া আবিমালিকরে দিলা আর দুইওজনে চুক্তি করলা। ");
INSERT INTO syl_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","আর ইব্রাহিমে পাল থনে সাতগু মেড়ি-বাইচ্চা আলগাইলা। ");
INSERT INTO syl_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","আবিমালিকে তানে জিকাইলা, “ই মেড়ি-বাইচ্চা সাতগু আলগা করার মানি কিতা?” ");
INSERT INTO syl_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","ইব্রাহিমে কইলা, “আপনে অগুইন্তরে নেউক্কা। ই কুয়াটা যে আমি খুদছি ইকটা অইলো তার পরমান।” ");
INSERT INTO syl_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","এরলাগি অউ জাগার নাম অইলো বের-শেবা মানি, কছমর কুয়া, অনোউ তারা দুইও জনে কছম করছলা। ");
INSERT INTO syl_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","তারা বের-শেবাত অউ চুক্তি করার বাদে, আবিমালিক আর তান সেনাপতি ফীখোল উঠিয়া ফিলিস্তিনী অকলর দেশো ফিরিয়া গেলাগি। ");
INSERT INTO syl_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","বাদে ইব্রাহিমে বের-শেবাত একটা ঝাউ গাছ রুইলা, আর যে মাবুদর শুরুও নায় শেষও নায়, তান এবাদত করলা। ");
INSERT INTO syl_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","আর ইব্রাহিমে ফিলিস্তিনী অকলর দেশো বউত দিন কাটাইলা। ");
INSERT INTO syl_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","ই ঘটনার বাদে আল্লায় ইব্রাহিমর এক পরিক্ষা লইলা। আল্লায় তানরে ডাক দিলা, “ইব্রাহিম!” তাইন জুয়াপ দিলা, “অউনু আমি।” ");
INSERT INTO syl_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","মাবুদে ফরমাইলা, “তুমার পুয়ারে, যারে তুমি অতো মহব্বত করো, হউ খাছ মায়ার পুত ইছহাকরে লইয়া তুমি মোরিয়া এলাকাত যাও। হখানো যে পাহাড়র কথা আমি তুমারে কইমু, এর উপরে তারে নিয়া জালাইল কুরবানি দেও।” ");
INSERT INTO syl_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","তেউ ইব্রাহিমে ফজরে উঠিয়া গাধার পিঠিত গদ্দি লাগাইয়া তান পুয়া ইছহাক, দুইজন গুলাম আর জালাইল কুরবানির লাগি লাকড়ি কাটিয়া লইয়া, যে জাগার কথা আল্লায় তানরে কইছলা, হবায়দি রওয়ানা অইলা। ");
INSERT INTO syl_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","তিন দিনর দিন ইব্রাহিমে চউখ তুলিয়া চাইতেউ দুরই থাকি হউ জাগাখান দেখলা। ");
INSERT INTO syl_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","অউ তান গুলাম অকলরে কইলা, “তুমরা গাধাটা লইয়া অনো উবাও, আমি আর আমার পুয়া হনো গিয়া এবাদতি শেষ করিয়া হারলে তুমরার গেছে আইমু।” ");
INSERT INTO syl_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","ইব্রাহিমে জালাইল কুরবানির লাকড়ির আটা তান পুয়া ইছহাকর কান্দো তুলিয়া দিয়া নিজে আগুইনর পাতিল আর ছুরি লইয়া, দুইও জনে ছামনর বায় আগুয়াইলা। ");
INSERT INTO syl_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","অউ ইছহাকে তান বাফরে কইলা, “বাবা।” তাইন কইলা, “কিতারে বাফ কও?” ইছহাকে কইলা, “ইনো তো লাকড়ি আর আগুইন আছে, তে কুরবানির মেড়া-বাইচ্চা কুয়াই?” ");
INSERT INTO syl_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","তাইন জুয়াপ দিলা, “বাবারে, কুরবানির লাগি আল্লায় নিজেউ মেড়া-বাইচ্চা যুগাইবা।” অতা মাততে মাততে তারা আগুয়াই গেলা। ");
INSERT INTO syl_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","আল্লার পছন্দর জাগাত পৌছিয়া ইব্রাহিমে কুরবানি খানা বানাইয়া, লাকড়ি হাজাইলা। বাদে নিজর পুয়া ইছহাকরে বান্দিয়া অউ দারুর উপরে হুতাইলা। ");
INSERT INTO syl_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","আর তাইন নিজর পুয়ারে কুরবানির লাগি ছুরি আতো লইলা। ");
INSERT INTO syl_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","অউ মাবুদর ফিরিস্তায় আছমান থনে তানে ডাক দিলা, “ইব্রাহিম! ও ইব্রাহিম!” তাইন কইলা, “অউনু আমি।” ");
INSERT INTO syl_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","ফিরিস্তায় কইলা, “পুয়াগুর বায় তুমার আত তুলিও না, তারে আর কুন্তাউ করিও না। তুমি যেন আল্লারে ডরাও ইতা বুজা গেছে, কারন আমারে তুমার পুয়া, তুমার খাছ মায়ার পুয়া দান করতেও না-খুশ অইছো না।” ");
INSERT INTO syl_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","ইব্রাহিমে চউখ তুলি চাইয়া দেখইন, তান খরে একটা দুম্বা আর তার হিং জংগলর মাজে আটকি রইছে। অউ তাইন গিয়া দুম্বাটা আনিয়া, নিজর পুয়ার বদলা জালাইল কুরবানি দিলা। ");
INSERT INTO syl_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","তাইন হি জাগার নাম রাখলা ইয়াওয়েহ্‌-যিরিহ্‌ মানি, মাবুদে যুগাইন। এরলাগি অখনও মানষে কইন, “মাবুদর পাহাড়ো যুগাইল অইবো।” ");
INSERT INTO syl_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","মাবুদর ফিরিস্তায় আছমান থনে হিরবার ইব্রাহিমরে ডাকিয়া কইলা, ");
INSERT INTO syl_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“হুনো, মাবুদে কইরা, তুমি অউলা করলায়, তুমার পুয়ারে, তুমার খাছ মায়ার পুয়ারে দান করতেও নারাজ অইলায় না। এরলাগি আমি মাবুদে কছম করিয়া কইয়ার, ");
INSERT INTO syl_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","আমি নিচয় তুমারে বরকত নাজিল করমু, তুমার বংশরে আছমানর তেরা আর দরিয়ার চরর বালুর লাখান বেহিসাব করমু। তুমার বংশয় তারার দুশমনর টাউন অকল দখল করবা। ");
INSERT INTO syl_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","আর তুমার বংশর উছিলায় দুনিয়ার হকল জাতিয়ে বরকত হাছিল করবা। কারন তুমি আমার হুকুম মানছো।” ");
INSERT INTO syl_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","বাদে ইব্রাহিমে তান গুলাম অকলর গেছে ফিরিয়া আইলা, আর তারা একলগে বের-শেবা নামর জাগাত গেলা। অউ জাগাতউ তাইন বসতি করলা। ");
INSERT INTO syl_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ই ঘটনার বাদে ইব্রাহিমে খবর পাইলা, তান ভাই নাহুরর বিবি মিলকার কয়গু পুয়াইন অইছইন। ");
INSERT INTO syl_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","এর বড় পুয়ার নাম আউজ, তার ভাইয়াইন্তর নাম বুজ, আর অরামর বাফ কমুয়েল, ");
INSERT INTO syl_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","এরবাদে কেসদ, হসো, পিলদশ, যিদলফ আর বথুয়েল। বথুয়েলর পুড়ির নাম রেবেকা। ");
INSERT INTO syl_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","ইব্রাহিমর ভাই নাহুরর বিবি মিলকার পেটো থাকি ই আটজন পুয়ার জনম অইছিল। ");
INSERT INTO syl_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","নাহুরর এক হাংগার বউ আছিল, তাইর নাম রউমা। তাইর পেটো টেবহ, গহম, তহশ আর মাখার জনম অইছিল। ");
INSERT INTO syl_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","বিবি ছায়রা একশো সাতাইশ বরছ বাচিলা; আল্লায় তানে অতদিনর হায়াতি দিছলা। ");
INSERT INTO syl_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","বাদে কেনান দেশর কিরিয়ত-অর্ব মানি হেবরনো ইন্তেকাল করলা। আর ইব্রাহিমে তান লাগি বউত কান্দা-কাটি আর আহাজারি করলা। ");
INSERT INTO syl_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","হেশে তান মুর্দা বিবির গেছ থনে হরিয়া গিয়া হউ দেশর হিট্টী অকলরে কইলা, ");
INSERT INTO syl_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“আমি তো বিদেশি মুছাফির অইয়া আপনারার অনো রইয়ার। মেহেরবানি করি কবরস্থান বানাইবার লাগি আমারে থুড়া জমি দেউক্কা, আমি আমার ছামনে থনে আমার মুর্দারে দাফন করি।” ");
INSERT INTO syl_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","হিট্টী অকলে তানে কইলা, ");
INSERT INTO syl_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“হুজুর, আমরার কথা হুনউক্কা। আপনে তো আমরার মাজে আল্লার মহব্বতর বুজুর্গ। আমরার গুরুস্থানর মাজে যেনো পছন্দ অয়, অনোউ আপনার মুর্দারে দাফন করউক্কা। তানরে দাফন করার লাগি আমরার কেউ-উ নিজর বানাইল কয়বর ছাড়তে অমত করতো নায়।” ");
INSERT INTO syl_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","অউ ইব্রাহিমে উবাইয়া হিনর হিট্টী অকলর ছামনে মাথা নোয়াইয়া ইজ্জত করি কইলা, ");
INSERT INTO syl_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","“আমার বিবিরে ইনো দাফন করাত যুদি আপনারার কুনু অমত না থাকে, তে দয়া করি আমার আরজিখান হুনউক্কা। আপনারা আমার অইয়া সোহরর পুয়া ইফ্রোনরে কউক্কা, ");
INSERT INTO syl_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","তান জমিনর হেশ মাথাত মকপেলা যে গুহা আছে, অখানতা যেনু কবরস্থান বানানির লাগি তাইন পুরা দাম লইয়া আমার গেছে বেচিলাইন।” ");
INSERT INTO syl_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","আরো হিট্টী অকলর লগে ই সময় ইফ্রোনও হনো বওয়াত আছলা। ইব্রাহিমর মাতর জুয়াপে হউ হিট্টী অকলর ছামনে ইফ্রোনে কইলা, ");
INSERT INTO syl_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“না, না, আপনে দয়া করি আমার মাতখান হুনউক্কা। আমি হকলর ছামনেউ ই জমি আর গুহা আপনারে দিলাইলাম, আপনার মুর্দারে দাফন করিলাইন।” ");
INSERT INTO syl_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","তেউ ইব্রাহিমে হিরবার হিনর হকলর ছামনে মাথা নোয়াইয়া, ");
INSERT INTO syl_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","হি দেশর হক্কলরে হুনাইয়া ইফ্রোনরে কইলা, “হুনউক্কা, জমিখানর দাম আমি দিলাই। আপনেও জমিখানর দাম নেউক্কাগি, বাদে আমার মুর্দারে অনো দাফন করমু।” ");
INSERT INTO syl_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","ইফ্রোনে তানরে জুয়াপ দিলা, ");
INSERT INTO syl_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“হুজুর, আমার কথা হুনউক্কা, অউ জমিখানর দাম অইলোগি চাইরশো তোলা রুপা, তে আপনার-আমার লাগি ইতা কুন্তাউ নায়। আপনার মুর্দারে কয়বর দিলাউক্কা।” ");
INSERT INTO syl_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","অউ ইব্রাহিমে ইফ্রোনর কথা মানিয়া হিট্টী অকলর ছামনে তাইন, ইফ্রোনর চাওয়া দাম মাফিক, পাইকারি মাপে চাইরশো তোলা রুপা তানরে মাপিয়া দিলা। ");
INSERT INTO syl_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","অউ লাখান মম্রি টাউনর গেছে মকপেলাত ইফ্রোনর যে জমিন আছিল হউ জমিন আর হনর গুহা আর জমিনর চাইরোবায় যত গাছ-গাছালি আছিল, ");
INSERT INTO syl_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ইতা হকলতাউ হিনর হিট্টী অকল আর টাউনর মুখর হকলর ছামনে, ইব্রাহিমর মালিকানায় আইলো। ");
INSERT INTO syl_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","বাদে ইব্রাহিমে কেনান দেশর মম্রি টাউন বা হেবরনর মকপেলার গুহাত তান বিবি ছায়রারে দাফন করলা। ");
INSERT INTO syl_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","অউ লাখান মকপেলার অউ গুহা সহ আস্তা জমিনখান গুরুস্থানর লাগি, হিট্টী অকলর আত থনে ইব্রাহিমর আতো আইলো। ");
INSERT INTO syl_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ইব্রাহিম ই সময় খুব মুরব্বি আর যাওয়াগির পথি অইগেছইন। মাবুদে তানরে হকল বায় থনে বরকত নাজিল করছলা। ");
INSERT INTO syl_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","আর তান খাছ গুলাম, বাড়ির পুরান যে গুলামর উপরে তান হকলতার ভার দেওয়া আছিল তারে কইলা, “তুমার আতখান আমার উরাতর তলে হারাও। ");
INSERT INTO syl_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","আমি তুমারে আছমান-জমিনর মালিক আল্লা মাবুদর নামে কছম করাইয়ার, আমি যে কেনানী অকলর মাজে থাকিয়ার, তারার কুনু পুড়িরে আমার পুয়ার বউ বানাইয়া তুমি আনিও না। ");
INSERT INTO syl_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","তুমি আমার দেশো গিয়া, আমার পুয়া ইছহাকর লাগি আমার খেশ-কুটুমর মাজ থাকি এগু কইনা চাইয়া আনবায়।” ");
INSERT INTO syl_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","অউ হি গুলামে তানরে কইলা, “যুদি কুনু পুড়িয়ে আমার লগে ই দেশো আইতে রাজি না অইন, তাইলে যে দেশ ছাড়িয়া আপনে আইছইন, আপনার পুয়ারে আমি হনো লইয়া যাইতাম নি?” ");
INSERT INTO syl_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","তাইন কইলা, “খবরদার! তুমি আমার পুয়ারে কুনুমন্তেউ হিনো লইয়া যাইও না। ");
INSERT INTO syl_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","যে আছমানি আল্লা মাবুদে আমারে, আমার বাফর বাড়ি আর জনম মাটি থনে বার করিয়া আনছইন, তাইন আমার লগে বাত-ছওয়াল করি কছম করিয়া কইছইন, ই দেশখান তাইন আমার ওয়ারিশ অকলরে দিবা। তাইন তুমার আগেউ তান ফিরিস্তারে হনো পাঠাইবা, যাতে আমার পুয়ার লাগি তুমি হন থনে এগু কইনা আনতায় পারো। ");
INSERT INTO syl_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","যুদি কুনু পুড়িয়ে তুমার লগে আইতে রাজি না অয়, তে আমার ই কছম থাকি তুমি খালাছ; তা-ও আমার পুয়ারে তুমি কুনু লাখানউ হিনো লইয়া যাইও না।” ");
INSERT INTO syl_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","অউ হি গুলামে তান মুনিব ইব্রাহিমর উরাতর তলে আত হারাইয়া অউলা কছম করলা। ");
INSERT INTO syl_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","বাদে হউ গুলামে তান মুনিবর উটর পাল থাকি দশটা উট লইলা। আর মুনিবর ভালা ভালা জিনিস অকল লইয়া, অরাম-নহরয়িম দেশর যেনো নাহুর থাকতা হবায়দি রওয়ানা অইলা। ");
INSERT INTO syl_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","আর হাইঞ্জা বালা যেবলা বেটিন্তে পানি আনাত বার অইন, অউ সময় হি গুলামে টাউনর বারে এক কুয়ার কাছাত তান উট অকলরে থইলা। ");
INSERT INTO syl_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","থইয়া অউ দোয়া করলা, “ও মাবুদ, আমার মুনিব ইব্রাহিমর আল্লা, আরজ করি, আইজ আমার ছামনে কামিয়াবি জাইর করো, আর আমার মুনিব ইব্রাহিমরে মেহেরবানি করো। ");
INSERT INTO syl_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","দেখো, ই টাউনর পুড়িন্তে পানি নেওয়াত আইরা আর আমি ইনো কুয়ার কাছাত উবাই রইছি। ");
INSERT INTO syl_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","তে অউ পুড়িন্তর মাজে আমি যারে কইমু, ‘আপনার খৈলা লামাইয়া আমারে থুড়া পানি খাওয়াউক্কা’, এর জুয়াপে যুদি হউ পুড়িয়ে কইন, ‘আপনে পানি খাউক্কা আর আপনার উট অকলরেও আমি পানি খাওয়াইমু’ তাইলে অউ পুড়িউ যানু তুমার গুলাম ইছহাকর লাগি তুমার পছন্দর পুড়ি অইন। তেউ আমি বুজমু, তুমি আমার মুনিবরে মেহেরবানি করলায়।” ");
INSERT INTO syl_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","তান দোয়া শেষ না অইতেউ বথুয়েলর পুড়ি রেবেকায় কাখো খৈলা লইয়া টাউন থাকি বার অইয়া আইলা। অউ বথুয়েল অইলা ইব্রাহিমর ভাই নাহুরর বিবি মিলকার পুয়া। ");
INSERT INTO syl_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","রেবেকা আছলা খুব সুন্দরি, আবিয়াতি, সতী নারী। তাইন কুয়া থাকি খৈলা ভরিয়া যেবলা উঠিয়া আইরা, ");
INSERT INTO syl_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","অউ সময়উ ইব্রাহিমর গুলামে দৌড়াইয়া তান গেছে গিয়া কইলা, “দয়া করি আপনার খৈলা থাকি আমারে থুড়া পানি খাওয়াউক্কা।” ");
INSERT INTO syl_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","রেবেকায় কইলা, “হুজুর, পানি খাউক্কা।” অউ কথা কইয়াউ তাইন জলদি করি খৈলাটা কাখো থনে আতো আনিয়া পানি খাইতে দিলা। ");
INSERT INTO syl_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","পানি খাওয়াইবার বাদে রেবেকায় তানরে কইলা, “আমি আপনার উট অকলরেও তারার পিয়াছ মিটাইয়া পানি খাওয়াইমু, তারা পেট ভরিয়া পানি খাইবা।” ");
INSERT INTO syl_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","কইয়াউ তাইন জলদি করি পানির গামলাত খৈলার পানি ঢালিয়া হিরবার দৌড়াইয়া কুয়ার গেছে গেলা। আর হকল উটরে পানি তুলি দিলা। ");
INSERT INTO syl_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","মাবুদে তান ই ছফর কামিয়াব করছইন কি না ইটা জানার লাগি হি গুলামে নীরবে রেবেকার বায় চাই রইলা। ");
INSERT INTO syl_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","উট অকলে পানি খাইয়া হারলে, তাইন আধা তোলার একটা সোনার নাকর নথ আর দুই আতো দশ তোলার দুইটা সোনার বালা রেবেকারে দিয়া জিকাইলা, ");
INSERT INTO syl_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","“আপনার বাবার নাম কিতা? আপনে কউক্কাছাইন, আপনার বাফর বাড়িত আমরার রাইত থাকার জাগা অইবো নি?” ");
INSERT INTO syl_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","রেবেকায় কইলা, “আমার বাবার নাম বথুয়েল। দাদার নাম নাহুর আর দাদির নাম মিলকা। ");
INSERT INTO syl_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","তে আপনার উটর খানির লাগি আমরার বাড়িত বউত খের-ভুষি আছে আর রইবার জাগাও আছে।” ");
INSERT INTO syl_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","অউ হি গুলামে মাবুদর সইজদা করিয়া কইলা, ");
INSERT INTO syl_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“হক্কল প্রশংসা মাবুদর, যেইন আমার মুনিব ইব্রাহিমর আল্লা। তাইন আমার মালিকরে তান দেওয়া ওয়াদা রাখতে আর ইমানদারি দেখাইতে ফাউরিছইন না। তাইন আমারেও পথ চিনাইয়া আমার মুনিবর কুটমর বাড়িত লইয়া আইছইন।” ");
INSERT INTO syl_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","রেবেকায় দৌড়াইয়া গিয়া তান মাʼর বাড়ির হকলরে ইতা জানাইলা। ");
INSERT INTO syl_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","রেবেকার এক ভাইর নাম আছিল লাবন। অউ লাবনে দৌড়াইয়া কুয়ার কাছাত আইলা এনরে দেখতা করি। ");
INSERT INTO syl_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","বনির আতর বালা আর নাকর নথ দেখিয়া, আর হি মানষে যেতা কইছে ইতা হুনিয়া, তাইন আইয়া দেখলা, মানুষটা কুয়ার কান্দাত তার উটর গেছে উবাই রইছে। ");
INSERT INTO syl_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","লাবনে তানরে কইলা, “ও মাবুদর রহমতর মানুষ, আউক্কা। বারে উবাই রইছইন কেনে? আমি আপনারার লাগি ঘর, আর উটর লাগি জাগা জুইত করিয়া আইছি।” ");
INSERT INTO syl_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","অউ হি গুলামে তারার বাড়িত গিয়া উট অকলর গাইট লামাইতেউ, লাবনে খের আর ভুষি আনিয়া দিলা। তানে আর তান লগর হকলরে আত-পাও ধোয়ার পানিও দিলা। ");
INSERT INTO syl_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","বাদে তান ছামনে খানি দেওয়া অইলো, তেউ তাইন কইলা, “আমি কিতার লাগি ইনো আইছি, ইতা না হুনাইয়া খানি খাইতাম নায়।” লাবনে কইলা, “তে কইলাউক্কা।” ");
INSERT INTO syl_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","অউ তাইন কইলা, “আমি ইব্রাহিমর গুলাম। ");
INSERT INTO syl_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","আমার মালিকরে মাবুদে বউত বরকত নাজিল করছইন, আইজ তাইন বউত ধনি-মানী। মাবুদে তানরে বউত গরু-মেড়া, উট-গাধা, সোনা-রুপা, আর বান্দি-গুলাম দিছইন। ");
INSERT INTO syl_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","তান বিবি ছায়রার মুরব্বি বয়সো মুনিবর একজন পুয়া অইছইন, আর অউ পুয়ারেউ তাইন, তান হকলতা দিলাইছইন। ");
INSERT INTO syl_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","তাইন আমারে কছম করাইয়া কইছইন যেন, তাইন যে দেশো বসত কররা, হি কেনান দেশর কুনু পুড়িরে যাতে তান পুয়ার বউ না বানাই। ");
INSERT INTO syl_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","এর বদলা তান বাফর আর তান খান্দানর বাড়িত গিয়া তান পুয়ার লাগি একজন কইনা চাইয়া নেই। ");
INSERT INTO syl_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","অউ আমি আমার মুনিবরে কইলাম, ‘যুদি কুনু পুড়ি আমার লগে আইতে রাজি না অইন?’ ");
INSERT INTO syl_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","তাইন কইলা, ‘মাবুদ, যানরে আমি খেজমত করি, তাইনউ তান ফিরিস্তারে পাঠাই দিবা, যাতে তুমার ছফর কামিয়াব অয়। আর তুমি আমার নিজর বংশ আর আমার বাফর খান্দান থনে, এগু পুড়িরে আমার পুয়ার লাগি চাইয়া আনবায়। ");
INSERT INTO syl_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","তারার হিনো গেলে যুদি তারা কুনু পুড়িরে না দেইন, তাইলে তুমি আমার ই কছম থাকি খালাছ পাইবায়।’ ");
INSERT INTO syl_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“অউ আইজ আমি কুয়ার গেছে আইয়া দোয়া করলাম, ‘ও মাবুদ, আমার মুনিব ইব্রাহিমর আল্লা, তুমি যুদি আমার ই ছফর কামিয়াব করো তাইলে, ");
INSERT INTO syl_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","দেখো, আমি অউ ভরা কুয়ার গেছে উবাই রইছি, আর কুনু পুড়িয়ে অনো পানি নেওয়াত আইলে আমি কইমু, খৈলা থাকি আমারে থুড়া পানি খাওয়াও। ");
INSERT INTO syl_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","আর যুদি তাই কয়, ‘তুমিও পানি খাও আর তুমার উট অকলরেও আমি পানি তুলিয়া দিমু’, তাইলে অউ পুড়িউ যানু আমার মুনিবর পুয়ার লাগি তুমার পছন্দ করা পুড়ি অয়।’ ");
INSERT INTO syl_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“আমার দোয়া শেষ না অইতেউ দেখি, রেবেকায় খৈলা কাখো লইয়া কুয়াত আইরা পানি তুলতা। পানি তুলার বাদে আমি কইলাম, ‘দয়া করিয়া আমারে থুড়া পানি খাওয়াউক্কা।’ ");
INSERT INTO syl_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","তাইন জলদি করি কাখো থনে খৈলা লামাইয়া আমারে কইলা, ‘অউ নেইন, পানি খাইন। আমি আপনার উট অকলরেও পানি খাওয়াইমু।’ তেউ আমি পানি খাইলাম, আর তাইন আমার উট অকলরেও পানি খাওয়াইলা। ");
INSERT INTO syl_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","বাদে আমি তানে জিকাইলাম, ‘আপনে কার পুড়ি?’ তাইন কইলা, ‘আমি বথুয়েলর পুড়ি, আমার দাদার নাম নাহুর আর দাদির নাম মিলকা।’ অউ আমি তান নাকো নথ আর আতো বালা ফিন্দাইয়া দিলাম। ");
INSERT INTO syl_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","বাদে আমি মাবুদর সইজদা করলাম। আর যেইন আমার মুনিব ইব্রাহিমর আল্লা, হউ মাবুদর শুকুর আদায় করলাম, তাইনউ আমারে ঠিক পথে চালাইয়া আনছইন যাতে আমি আমার মুনিবর ভাতিজিরে, তান পুয়ার লাগি তুকাইয়া পাই। ");
INSERT INTO syl_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","তেউ অখন আপনারা আমার মুনিবর বায় দরদ আর ইনছাফ করবা নি, কউক্কা। যুদি না করইন তা-ও কউক্কা, যাতে আমি ডাইনে-বাউয়ে যাইতাম পারি।” ");
INSERT INTO syl_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","অউ লাবন আর বথুয়েলে কইলা, “ঘটনা তো মাবুদ থাকিউ অইছে। অখন আমরার ভালা-বুরা মাতার কুন্তাউ নায়। ");
INSERT INTO syl_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","অউ দেখউক্কা, রেবেকা তো অনো আছে, তে মাবুদর হুকুম মত আপনার মুনিবর পুয়ার বউ বানাইবার লাগি এরে লইয়া যাইতা পারবা।” ");
INSERT INTO syl_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ই মাত হুনিয়া ইব্রাহিমর গুলামে মাবুদর সইজদা করলা। ");
INSERT INTO syl_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","এরবাদে তাইন সোনা-রুপার গয়না-গাটি আর কাপড়-চুপড় বার করিয়া রেবেকারে দিলা, এর লগে রেবেকার মা-ভাইরেও বউত দামি দামি উপহার দিলা। ");
INSERT INTO syl_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","বাদে তাইন আর তান লগর হকলে খাওয়া-দাওয়া শেষ করিয়া হখানোউ রাইত কাটাইলা। বিয়ানে ঘুম থাকি উঠিয়া তাইন কইলা, “আমার মুনিবর গেছে যাওয়ার লাগি আমারে বিদায় দিলাউক্কা।” ");
INSERT INTO syl_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","তেউ রেবেকার মা আর ভাইয়ে কইলা, “পুড়িগু আরো দশখান দিন আমরার গেছে থাকউক, বাদে যাইবোনে।” ");
INSERT INTO syl_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","অউ হি গুলামে তারারে কইলা, “মাবুদে যেবলা আমার ই ছফর কামিয়াব করছইন, তাইলে আমারে দেরি না করাইয়া বিদায় দিলাউক্কা, আমার মুনিবর গেছে যাইগি।” ");
INSERT INTO syl_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","এরা কইলা, “আমরা তাইলে পুড়িরে ছামনে আনিয়া জিকাইলাই।” ");
INSERT INTO syl_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","আর রেবেকারে ডাকিয়া আনিয়া জিকাইলা, “তুমি কিতা তান লগে যাইবায় নি গো?” তাইন কইলা, “আইচ্ছা, যাইমুনে।” ");
INSERT INTO syl_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","অউ তারা ইব্রাহিমর গুলাম আর তান লগর মানষর লগে তারার বইন আর তান বান্দি বেটিরে বিদায় দিলা। ");
INSERT INTO syl_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","আর রেবেকারে দোয়া করিয়া কইলা, “বইন গো, তুমি লাখ লাখ আওলাদর মা অও। তুমার আওলাদে দুশমন অকলরে ঘাইল করউক।” ");
INSERT INTO syl_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","রেবেকা আর তান বান্দি অকলে তৈয়ার অইয়া উটর উপরে চড়িয়া, ইব্রাহিমর গুলামর খরে অইয়া রওয়ানা দিলা। অউ লাখান হউ গুলামে রেবেকারে লইয়া বার অইলা। ");
INSERT INTO syl_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ইছহাক ই সময় নেগেভো থাকতা। তাইন বের-লহয়-রোয়ী নামর জাগা থনে ফিরত আইলা। ");
INSERT INTO syl_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","একদিন বিয়ালি বালা তাইন বন্দেদি আটাত বার অইলা। আখতাউ চউখ তুলিয়া চাইয়া দেখলা, কয়টা উট আইরা। ");
INSERT INTO syl_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","রেবেকায়ও দুরই থনে ইছহাকরে দেখিয়াউ উটর উপর থাকি লামি গেলা। ");
INSERT INTO syl_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","আর হউ গুলামরে জিকাইলা, “অউ যেইন বন্দর মাজেদি আমরার বায় আইরা, এইন কে?” গুলামে কইলা, “এইন তো আমার মুনিব।” অউ রেবেকায় বুরকার পর্দা লামাই দিলা। ");
INSERT INTO syl_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","আর হি গুলামে যেতা যেতা করিয়া আইছইন, হকলতা ইছহাকরে জানাইলা। ");
INSERT INTO syl_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ইছহাকে তান মা বিবি ছায়রার তাম্বুত রেবেকারে লইয়া গিয়া তানে বিয়া করলা। আর তানরে মায়া করলা। তান মাʼর মউতর বাদে, রেবেকার মায়ায়উ তান জানো শান্তি পাইছলা। ");
INSERT INTO syl_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","ইব্রাহিমে কাতুরা নামর আরো একজন বেটিরে বিয়া করছলা। ");
INSERT INTO syl_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","তান পেটো যিম্রন, যকষন, মদান, মাদিয়ান, যিশবক আর শূহার জনম অইছিল। ");
INSERT INTO syl_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","সাবা আর দদান অইলা যকষনর আওলাদ। আশুরী, লটূশী, লিয়ূম্মী অকল অইলা দদানর আওলাদ। ");
INSERT INTO syl_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","মাদিয়ানর আওলাদ অইলা ঐফা, এফর, হনোক, অবীদ আর ইলদায়া। এরা হকলউ কাতুরার আওলাদ। ");
INSERT INTO syl_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","ইব্রাহিমে তান হকলতা ইছহাকরে দিলাইলা। ");
INSERT INTO syl_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","অইলে তাইন জিন্দা থাকতেউ, তান হেশর বিয়ার আওলাদ অকলরেও আলগা আলগা দান করিয়া, এরারে ইছহাকর লগে না রাখিয়া পুবেদি, পুবর দেশো পাঠাই দিলা। ");
INSERT INTO syl_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","ইব্রাহিম একশো পচত্তইর বরছ বাচিলা, আল্লায় তানে অতদিনর হায়াতি দিছলা। ");
INSERT INTO syl_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","তাইন মুরব্বি অইয়া পুরাপুর বুড়া বয়সো ইন্তেকাল করলা, আর তান বাফ-দাদার গেছে গিয়া আজিলা। ");
INSERT INTO syl_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","হেশে তান পুয়া ইছমাইল আর ইছহাকে মম্রি টাউনর পুবেদি, হিট্টী সোহরর পুয়া ইফ্রোনর জমির মকপেলা-গুহাত, তানরে দাফন করলা। ");
INSERT INTO syl_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ই জমিখান তাইন হিট্টী অকলর গেছ থনে লইছলা। অনোউ তান বিবি ছায়রারে আর তানে দাফন করা অইছে। ");
INSERT INTO syl_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ইব্রাহিমর মউতর বাদে আল্লায় তান পুয়া ইছহাকরে বরকত নাজিল করলা। তাইন বের-লহয়-রোয়ীর গেছে রইতা। ");
INSERT INTO syl_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","অউ অইলো ইছমাইলর খান্দানর বয়ান। বিবি ছায়রার বান্দি মিসরী হাজেরার পেটো ইব্রাহিমর পুয়া ইছমাইলর জনম অইছিল। ");
INSERT INTO syl_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","অউ অইলো ইছমাইলর আওলাদর নাম আর গুষ্টির বয়ান। তান বড় পুয়ার নাম নাবাউত, বাদে কায়দার, অদবেল, মিবসম, ");
INSERT INTO syl_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","মিশমা, দূমা, মাছা, ");
INSERT INTO syl_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","হদদ, তেমা, যিটুর, নাফীশ আর কেদমা। ");
INSERT INTO syl_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ইছমাইলর অউ বারোজন পুয়া আছলা বারো গুষ্টির সর্দার। তারার নামর লাখান হি গাউ আর তাম্বু বিছাইল জাগারও অউ নাম অইছিল। ");
INSERT INTO syl_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ইছমাইলর হায়াত একশো সাড়তিশ বরছ আছিল, হেশে তাইন মারা গেলা আর তান বাফ-দাদার গেছে গেলাগি। ");
INSERT INTO syl_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","হবিলা থনে আশিরিয়ার বায় মিসরর ছামনর শুর পর্যন্ত তান আওলাদ অকল রইতা। ইছমাইলে তান হকল ভাইয়াইন্তর গালাবায় রওয়ার জাগা পাইলা। ");
INSERT INTO syl_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","অউ অইলো ইব্রাহিমর পুয়া ইছহাকর খান্দান-নামা। ইব্রাহিমর ঘরো ইছহাকর জনম অইলো। ");
INSERT INTO syl_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ইছহাকে চাল্লিশ বরছ বয়সো তান মামুর ঘরর বইন রেবেকারে আনাইয়া বিয়া করলা। রেবেকা অইলা পদ্দন-ইরাম দেশর অরামী বথুয়েলর পুড়ি, অরামী লাবনর বইন। ");
INSERT INTO syl_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","তান বউ নিআওলাদি আছলা গতিকে, ইছহাকে মাবুদর গেছে দোয়া করলা। মাবুদে তান দোয়া কবুল করলা, আর রেবেকার পেটো হুরুতা আইলো। ");
INSERT INTO syl_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","বাদে পেটর ভিতরে হুরুতায় লড়া-চড়া করাত লাগলা। অউ তাইন কইলা, “আমার পেটো ইলা লাগের কেনে?” কারন জানার লাগি তাইন মাবুদর গেছে দোয়া করলা। ");
INSERT INTO syl_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","মাবুদে তানরে কইলা, “তুমার পেটো দুইটা জাতি আছে, পেটো থনেউ তারা দুই বংশ অইয়া পয়দা অইবা। এক বংশ থনে আরক বংশ শক্তিআলা অইবো, আর বড়গুয়ে হুরুগুর খেজমত করবো।” ");
INSERT INTO syl_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","হুরুতা পয়দার বালা দেখইন, হাছাউ তান পেটো জোড়র পুয়া। ");
INSERT INTO syl_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","পয়লা যার জনম অইলো হে লাল রংগর আর তার শরিলো পশমি কাপড়র লাখান রুমায় ভরা। তার নাম রাখলা ঈষ মানি, রুমাআলা। ");
INSERT INTO syl_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","বাদে ঈষʼর পাওর মুরাত ধরি তার ভাইর জনম অইলো, এর নাম রাখলা ইয়াকুব মানি, পাওত ধররা। ইছহাকর ষাইট বরছ বয়সো এরা জোড়ে পয়দা অইলা। ");
INSERT INTO syl_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","অউ পুয়াইন বড় অওয়ার বাদে ঈষ খুব ভালা শিকারি আর মরুভুমিত পাকাওরা অইলা, অইলে ইয়াকুব আছলা নিরাই-জিরাই, তাইন তাম্বুত থাকতা। ");
INSERT INTO syl_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","শিকারর গোস্ত মজা লাগতো করি ইছহাকে ঈষʼরে মায়া করতা, আর রেবেকায় ইয়াকুবরে মায়া করতা। ");
INSERT INTO syl_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","একদিন ইয়াকুবে ডাইল রান্দিছইন, অউ সময় তান বড় ভাই ঈষ মরুভুমি থাকি পেটর ভুকে খুব কাতর অইয়া আইলা, আইয়া হুরু ভাই ইয়াকুবরে কইলা, ");
INSERT INTO syl_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","“ভাইরে, আমার খুব ভুক লাগছে। তে অউ রংগিল, রংগিল অতা আমারে পেট ভরি খাইতে দে।” অউ কথার লাগি তান চিড় লাগলো ইদোম মানি, রংগিল। ");
INSERT INTO syl_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","ইয়াকুবে কইলা, “তাইলে বড় ভাই অওয়ার মালিকানা, তুমি আইজ আমার গেছে বেচিলাও।” ");
INSERT INTO syl_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","ঈষে কইলা, “দেখো, আমার জান বার অইযার, আর বড় ভাইর মালিকানাদি আর কিতা করতাম?” ");
INSERT INTO syl_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","ইয়াকুবে কইলা, “আগে তুমি আমার গেছে কছম করো।” অউ ঈষে কছম করিয়া বড় ভাই অওয়ার মালিকানা ইয়াকুবর গেছে বেচিলাইলা। ");
INSERT INTO syl_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","বাদে ইয়াকুবে ঈষʼরে ডাইল আর রুটি খাইতে দিলা। খাওয়া-দাওয়া করিয়া তাইন উঠিয়া গেলাগি। অউ লাখান ঈষে বড় পুয়া অওয়ার কুনু দামউ রাখলা না। ");
INSERT INTO syl_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ইব্রাহিমর জমানার লাখান ইফিরাও দেশো হিরবার এক নিদান দেখা দিলো। তেউ ইছহাক গেরার টাউনো ফিলিস্তিনী অকলর বাদশা আবিমালিকর গেছে গেলাগি। ");
INSERT INTO syl_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","আর মাবুদে ইছহাকরে দিদার দিয়া কইলা, “তুমি মিসরো লামিয়া যাইও না। আমি তুমারে যে দেশর কথা কইমু, অনোউ থাকিও। ");
INSERT INTO syl_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","অউ দেশো তুমি মুছাফির অইয়া রও। আমি তুমার লগে রইয়া, তুমারে বরকত নাজিল করমু। ই দেশ অকল আমি তুমারে আর তুমার ওয়ারিশ অকলরে দিমু। আর তুমার বাফ ইব্রাহিমর গেছে আমি যে কছম করছলাম, অকটা পুরা করমু। ");
INSERT INTO syl_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","আমি তুমার ওয়ারিশ অকলরে আছমানর তেরার লাখান বেহিসাব করমু, অউ দেশ অকলও তারারে দিমু। তুমার ওয়ারিশরেদি, দুনিয়াইর হকল জাতিয়ে বরকত পাইবা। ");
INSERT INTO syl_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ইব্রাহিমে আমার মাত হুনিয়া, আমার হুকুম, আমার আইন আর আমার শরিয়ত অকল আমল করছে।” ");
INSERT INTO syl_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","তেউ ইছহাক গেরার টাউনো রইলা। ");
INSERT INTO syl_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","আর হিনর মানষে তান বউর কথা জিকাইলে, তাইন কইলা এইন আমার বইন। এনরে বউ কইতে তাইন ডরাইলা, মনে করলা, রেবেকা সুন্দরি করিয়া হিনর মানষে রেবেকারে নেওয়ার লাগি তানরে খুন করিলিবা। ");
INSERT INTO syl_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","ইছহাক বউত দিন হনো রওয়ার বাদে একদিন ফিলিস্তিনী অকলর বাদশা আবিমালিকে তান খিড়কি বায়দি চাইয়া দেখলা, ইছহাকে তান বিবি রেবেকারে মায়া কররা। ");
INSERT INTO syl_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","দেখিয়া তাইন ইছহাকরে নেওয়াইয়া কইলা, “দেখউক্কা, রেবেকা তো আসলে আপনার বিবি, তে আপনে কেনে তানরে আপনার বইন কইলা?” ইছহাকে জুয়াপ দিলা, “আমি মনে করছলাম তাইর লাগি আমার জান আরাইমু।” ");
INSERT INTO syl_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","তেউ আবিমালিকে কইলা, “আমরার লগে আপনে ইতা কিতা বেবহার করলা? যেকুনু মানষে তো আপনার বিবির লগে মিলা-মিশা করতো চাইলো অনে আর আপনে আমরারে দুষি বানাইলা অনে।” ");
INSERT INTO syl_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","বাদে আবিমালিকে হকল মানষরে অউ হুকুম জারি করলা, কেউ যুদি ইছহাক বা তান বিবির শরিলো আত দেয়, তারে নিচয় জানে মারা অইবো। ");
INSERT INTO syl_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","আর ইছহাকে হি বরছ খেত করিয়া তান জমিনো রুয়া বিচ থাকি একশো গুন বেশি ফসল পাইলা, মাবুদে তানরে অউলা বরকত নাজিল করলা। ");
INSERT INTO syl_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","তান খালি বাড়তেউ লাগলো, আস্তে আস্তে তাইন খুব মালদার অইগেলা। ");
INSERT INTO syl_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","তান গরু-ছাগল আর গুলাম-বান্দি অউলা বাড়লো যেন, ইতা দেখিয়া ফিলিস্তিনী অকলে ইংসাইতা লাগলা। ");
INSERT INTO syl_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","আর তান বাফ ইব্রাহিমর আমলো, তান গুলাম অকলে যে কুয়া অকল খুদিছলা, ফিলিস্তিনী অকলে ইগুইন মাটিদি ভরিয়া বন্দ করিলাইছলা। ");
INSERT INTO syl_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","বাদে আবিমালিকে ইছহাকরে কইলা, “আপনে আমরার গেছ থনে যাউক্কাগি, আপনে তো আমরা থনে বেশি শক্তিআলা অইগেছইন।” ");
INSERT INTO syl_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","অউ ইছহাকে হন থনে হরিয়া গিয়া গেরার মরা গাংগর চরো তাম্বু গাড়িয়া রইলা। ");
INSERT INTO syl_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","আর তান বাফ ইব্রাহিমর আমলর খুদা কুয়াইন, তাইন হিরবার খুদিলা, কারন ইব্রাহিমর মউতর বাদে ফিলিস্তিনী অকলে ইতা ভরিলাইছলা। আর তান বাফে অউ কুয়াইন্তর যে নাম রাখছলা, তাইনও অউ নাম রাখলা। ");
INSERT INTO syl_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ইছহাকর গুলাম অকলে অউ গাংগর চরো খুদিয়া পানির ফুতআলা এক কুয়া পাইলা। ");
INSERT INTO syl_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","আর গেরারর রাখাল অকলে তান রাখাল অকলর লগে দরবার করিয়া কইলো, ই পানি আমরার। অউ তাইন ই কুয়ার নাম রাখলা এষক মানি, দরবার। ");
INSERT INTO syl_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","বাদে ইছহাকর রাখাল অকলে আরো এক কুয়া খুদিলা, আর ইটা লইয়াও তারা দরবার করলা। অউ তাইন ইটার নাম রাখলা সিটনা মানি, দুশমনি। ");
INSERT INTO syl_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","হেশে তাইন হন থনে হরিয়া গিয়া আরো এক কুয়া খুদাইলা, ইফিরা তারা আর কুনু দরবার করলা না। তেউ ইছহাকে অউ কুয়ার নাম রাখলা রহবত মানি, বউত জাগা। তাইন কইলা, “অখন মাবুদেউ আমরারে বউত জাগা দিলা, আমরা ই দেশো আরো বাড়তাম পারমু।” ");
INSERT INTO syl_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","বাদে ইছহাকে হন থনে হরিয়া বের-শেবাত গেলাগি। ");
INSERT INTO syl_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","হউ রাইতউ মাবুদে তানরে দিদার দিয়া কইলা, “আমি তুমার বাফ ইব্রাহিমর আল্লা। তুমি ডরাইও না, আমার গুলাম ইব্রাহিমর খাতিরে আমি তুমার লগে আছি। আমি তুমারে বরকত নাজিল করমু আর তুমার বংশ বাড়াইমু।” ");
INSERT INTO syl_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","অউ ইছহাকে হনো একখান কুরবানি খানা বানাইয়া মাবুদর নাম লইলা। হনো তাইন তান তাম্বু গাড়িলা আর তান গুলাম অকলে এক কুয়া খুদিলা। ");
INSERT INTO syl_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","বাদে আবিমালিকে তান উজির অহুজত আর সেনাপতি ফীখোলরে লইয়া গেরার থাকি ইছহাকর গেছে আইলা। ");
INSERT INTO syl_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ইছহাকে এরারে কইলা, “আপনারা আমার গেছে কিতার লাগি আইলা? আপনারা তো ইংসা করিয়া আমারে আপনারার গেছ থনে খেদাই দিলাইছইন।” ");
INSERT INTO syl_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","তারা কইলা, “আমরা অখন ছাফ বুজিয়ার যেন, মাবুদ আপনার লগে আছইন। এরলাগি আপনার লগে আমরার এগু ওয়াদা অইযাউক। আউক্কা, আমরা এক চুক্তি করিলাই। ");
INSERT INTO syl_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","আমরা যেলা আপনারে ছইছি না আর আপনার ভালাই ছাড়া কুনু খেতি করছি না, যেলা আপনারে শান্তিয়ে বিদায় দিছি, অউলা আপনেও আমরারে খেতি করতা না। আপনেউ তো মাবুদর বরকতর মানুষ।” ");
INSERT INTO syl_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","বাদে ইছহাকে তারার লাগি খানা-দানা জুইত করলে, তারা খানা-দানা করলা। ");
INSERT INTO syl_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","বাদর দিন বিয়ানে উঠিয়া তারা দুইওজনে কছম করলা। আর ইছহাকে তারারে বিদায় দিলে, তারা দিলর মাজে শান্তি পাইয়া রওয়ানা অইলা। ");
INSERT INTO syl_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","হউ দিনউ তান গুলাম অকলে আইয়া তারার খুদা এক কুয়ার খবর জানাইলা, তারা পানির লাগাল পাইছইন। ");
INSERT INTO syl_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","অউ তাইন এর নাম দিলা শেবা মানি, কছম। এরলাগি আইজও হিনর নাম বের-শেবা রইছে। ");
INSERT INTO syl_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ঈষে চাল্লিশ বরছ বয়সো হিট্টী বেরির পুড়ি যিহুদীথ আর হিট্টী এলনর পুড়ি বাসমতরে শাদি করলা। ");
INSERT INTO syl_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ই দুইও বেটিয়ে ইছহাক আর রেবেকার জানর মাজে খুব দুখ দিলা। ");
INSERT INTO syl_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","মুরব্বি বয়সো ইছহাকর চউখর জুতি কমি যাওয়ায় তাইন আর চউখে দেখতা না। তাইন তান বড় পুয়া ঈষʼরে আনাইয়া কইলা, “বাবারে।” ঈষে জুয়াপ দিলা, “অউনু আমি।” ");
INSERT INTO syl_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","তাইন কইলা, “দেখো, আমি তো বুড়া অইগেছি, কুনদিন মরিযিমু কইতাম পারিয়ার না। ");
INSERT INTO syl_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","তুমি এগু কাম করো; তুমার আতিয়ার, তীর-ধনুক লইয়া জংগলো শিকারো যাও, আর আমার লাগি কুন্তা শিকার করিয়া, ");
INSERT INTO syl_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","আমার পছন্দর ভালা খানি তৈয়ার করি আনো, তেউ মরার আগে ইতা খাইয়া আমার জানে তুমারে দোয়া দিবো।” ");
INSERT INTO syl_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ইছহাকে যেবলা তান পুয়া ঈষʼর লগে ইতা মাতিরা, ই সময় রেবেকায় ইতা হুনছিলা। তেউ ঈষ যেবলা শিকারো গেলাগি, ");
INSERT INTO syl_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","তাইন আইয়া তান পুয়া ইয়াকুবরে কইলা, “হুনো, আমি হুনলাম তুমার বাফে তুমার ভাই ঈষʼরে কইরা, ");
INSERT INTO syl_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘তুমি আমার লাগি কুন্তা শিকার করি ভালা খানি তৈয়ার করো, তেউ আমি মরার আগে অতা খাইয়া, মাবুদর ছামনে তুমারে দোয়া দিমু।’ ");
INSERT INTO syl_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","তে রে পুত, আমি তুমারে অখন যেতা করতায় কইমু, তুমি অউলা হুনিও। ");
INSERT INTO syl_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","তুমি গিয়া পাল থাকি দুইটা তাজা খসি আনো। আমি ইতাদি তুমার বাফর শখর খানি, আচানক মজা করি রান্দিয়া দেই। ");
INSERT INTO syl_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","তেউ তুমি অতা লইয়া তুমার বাফর গেছে যাইও, তাইন ইতা খাইয়া মরার আগে তুমারে দোয়া করবা।” ");
INSERT INTO syl_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","ইয়াকুবে তান মাʼরে কইলা, “হুনো, আমার ভাই ঈষʼর শরিল তো রুমাআলা, আমার শরিলো তো রুমা নায়। ");
INSERT INTO syl_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","যুদি বাবায় আমার শরিলো আতাইন, তে মনো করবা আমি তানে ধুকা দিয়ার, তাইলে আমি দোয়ার বদলা আরো লান্নত ডাকিয়া আনমু।” ");
INSERT INTO syl_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","তেউ তান মাʼয় কইলা, “পুতরে, তুমার ই লান্নত আমার উপরেউ পড়উক। তুমি খালি আমার মাতখান হুনো আর খসিগুইন আনিয়া দেও।” ");
INSERT INTO syl_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","অউ ইয়াকুবে গিয়া খসি আনিয়া তান মাʼরে দিলা। আর তান বাফে যেলা শখ করইন, তাইন অউলা মজা করি রান্দিলা। ");
INSERT INTO syl_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","বাদে তাইন ঘরর মাজে থোয়া বড় পুয়া ঈষʼর ভালা ভালা কাপড়-চুপড় আনিয়া তান হুরু পুয়া ইয়াকুবরে ফিন্দাইলা। ");
INSERT INTO syl_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ইয়াকুবর আতো আর গলাত যে জাগাত রুমা নায়, হউ জাগাত অউ খসির চামড়া লাগাই দিলা। ");
INSERT INTO syl_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","আর নিজর রান্দা হউ মজার খানি আর রুটি তান পুয়া ইয়াকুবর আতো দিলা। ");
INSERT INTO syl_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","ইয়াকুবে তান বাফর গেছে গিয়া ডাক দিলা, “বাবা।” ইছহাকে জুয়াপ দিলা, “অউনু আমি, তুমি কে রে পুত?” ");
INSERT INTO syl_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","ইয়াকুবে তান বাফরে কইলা, “আমি আপনার বড় পুয়া ঈষ। আপনে আমারে যেলা কইছলা, আমি অউলা করছি। দয়া করি উঠিয়া বউক্কা, আমার শিকারর গোস্ত খাউক্কা, খাইয়া হারলে আপনে আমারে দোয়া দিবা।” ");
INSERT INTO syl_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ইছহাকে তান পুয়ারে কইলা, “বাবারে, তুমি অতো জলদি শিকার পাইলায় কিলা?” তাইন কইলা, “আপনার মাবুদ আল্লায় মিলাই দিছইন।” ");
INSERT INTO syl_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","অউ ইছহাকে ইয়াকুবরে কইলা, “বাবা, আমার কাছাত আও তেউ তুমার গতরো আত দিয়া বুজমু, তুমি হাছাউ আমার পুয়া ঈষ নি।” ");
INSERT INTO syl_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","ইয়াকুব তান বাফ ইছহাকর আরো কাছাত গেলা। তাইন শরিলো আতাইয়া কইলা, “গলার আওয়াজটা ইয়াকুবর, অইলে আত দুইওখান তো ঈষʼর।” ");
INSERT INTO syl_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ইয়াকুবর আত তান ভাই ঈষʼর মত রোমে ভরা আছিল করি ইছহাকে তানরে চিনলা না। অউ তাইন ইয়াকুবরে দোয়া দিলা। ");
INSERT INTO syl_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","তাইন জিকাইলা, “তুমি কিতা হাছাউ আমার পুয়া ঈষ নি?” ইয়াকুবে কইলা, “জিঅয় বাবা।” ");
INSERT INTO syl_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","অউ ইছহাকে কইলা, “পুয়ার শিকারর গোস্ত আমার গেছে আনো, ইতা খাইয়া হারলে আমার জানে তুমারে দোয়া দিবো।” ইয়াকুবে গোস্ত লইয়া আইলে তাইন খাইলা। বাদে তানরে আংগুরর শরবত দিলে তাইন এওতা খাইলা। ");
INSERT INTO syl_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","হেশে তান বাফে কইলা, “ও পুত আও, কাছাত আইয়া আমারে হুংগা দেও।” ");
INSERT INTO syl_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","অউ ইয়াকুবে কাছাত গিয়া হুংগা দিলা, আর ইছহাকে তান শরিলর কাপড়র ঘেরান হুংগিয়া তানরে দোয়া দিলা, “দেখো, আমার পুয়ার ঘেরান তো মাবুদর বরকতি খেতর ঘেরানর লাখান। ");
INSERT INTO syl_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","আল্লায় আছমানর খুয়া থনে আর রসাইল জমিন থনে তুমারে দেউক্কা; বউত ফসল আর আংগুরর শরবত তুমারে দেউক্কা। ");
INSERT INTO syl_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","হকল মানুষ তুমার গুলাম অউক, হকল জাতিয়ে তুমার গেছে মাথা নোয়াউক। নিজর জাতর মাজে তুমি বড় মুরব্বি অও, তুমার মাʼর পেটর ভাইয়াইন্তে তুমার গেছে মাথা নোয়াউক। যে তুমারে লান্নত দিবো, তার উপরে লান্নত পড়উক। যে তুমারে দোয়া করবো, হে রহমতি অউক।” ");
INSERT INTO syl_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ইছহাকে ইয়াকুবরে দোয়া করা শেষ অইলে, ইয়াকুব তান বাফ ইছহাকর ছামনে থনে হরতেউ, তান ভাই ঈষে শিকার লইয়া ঘরো আইলা। ");
INSERT INTO syl_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","তাইনও ভালা খানি তৈয়ার করিয়া বাফর গেছে লইয়া আইয়া কইলা, “বাবা, উঠিয়া বইয়া আপনার পুয়ার শিকারর গোস্ত খাউক্কা, খাইয়া হারলে আপনার জানে আমারে দোয়া দিবা।” ");
INSERT INTO syl_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","অউ তান বাফে কইলা, “তুমি কে?” তাইন কইলা, “বাবা, আমি তো আপনার বড় পুয়া ঈষ।” ");
INSERT INTO syl_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","আর ইছহাকর শরিলো বেজুইতা কাপা শুরু অইলো। কাপি কাপি তাইন কইলা, “তাইলে আমার গেছে শিকারর গোস্ত লইয়া যে আইছিল, ইগু কে? তুমি আইবার আগেউ আমি অতা খাইয়া তারে দোয়া দিছি, আর দোয়ার ফল হে-উ পাইবো।” ");
INSERT INTO syl_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","বাফর মাত হুনিয়াউ ঈষে একেবারে বুক ভাংগিয়া চিল্লাইয়া তান বাফরে কইলা, “বাজান, আমারে, আমারেও দোয়া করো!” ");
INSERT INTO syl_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","ইছহাকে কইলা, “তুমার ভাইয়ে আইয়া চতুরি করিয়া তুমার পাওনা দোয়া নিছেগি।” ");
INSERT INTO syl_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","ঈষে কইলা, “তার নাম ইয়াকুব মানি, ধুকাবাজ নায় নি? হাছাউ হে দুইবার আমারে ধুকা দিছে। বড় পুয়া হিসাবে আমার মালিকানা হে আগে চুরি করি নিছিল, আর দেখউক্কা, ইফিরা আমার দোয়াও লইয়া গেলগি।” তাইন ফিরিয়া কইলা, “আপনে আমার লাগি কুনু দোয়াউ রাখছইন না নি?” ");
INSERT INTO syl_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ইছহাকে জুয়াপ দিলা, “হুনো, আমি তারে তুমার নেতা বানাইছি, আর তার গুষ্টিরে তার গুলাম বানাইছি, তারে ফসল আর আংগুরর শরবত দিয়া ছামানি করছি; অখন তুমার লাগি আর কিতা করতামরে পুত?” ");
INSERT INTO syl_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","ঈষে ফিরিয়া তান বাফরে কইলা, “ও বাজান, আপনার গেছে কিতা অউ এক দোয়াউ আছিল নি? বাজান রেবা, আপনে আমারে, আমারেও দোয়া করউক্কা!” অতা কইয়া তাইন জুরে জুরে চিল্লাইয়া কান্দাত লাগলা। ");
INSERT INTO syl_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","অউ তান বাফ ইছহাকে কইলা, “তুমার বসতখানার মাটি নিরস অইবো, হিনো আছমানর খুয়াও পড়তো নায়। ");
INSERT INTO syl_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","তলোয়ারউ তুমার জিন্দেগি অইবো, আর নিজর ভাইর গুলাম অইবায়; অইলে যেবলা তুমি না-মানরা অইযিবায়, অউ সময় নিজর গর্দনা থাকি তার জুয়াল হরাইবায়।” ");
INSERT INTO syl_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","ইয়াকুবে তান বাফর গেছ থনে দোয়া পাইছলা করি ঈষে তানরে ইংসাইতা লাগলা। ঈষে মনে মনে কইলা, “আমার বাফর লাগি মউতর কান্দনর দিন আইচ্চে। এরবাদেউ তারে খুন করমু।” ");
INSERT INTO syl_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","রেবেকায় তান বড় পুয়া ঈষʼর ইতা মাতা-মাতি হুনলা, তেউ হুরু পুয়া ইয়াকুবরে আনাইয়া কইলা, “হুনো, তুমার ভাই ঈষে তুমারে খুন করার নিয়তে দিলরে বান্দিলাইছে। ");
INSERT INTO syl_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","আমার পুত, তুমি আমার মাতখান হুনো, তুমি হারান টাউনো আমার ভাই লাবনর গেছে হরিয়া যাওগি, ");
INSERT INTO syl_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","আর তুমার ভাইর গুছা না কমা পর্যন্ত তান গেছে থাকো। ");
INSERT INTO syl_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","তার গুছা কমিগেলে, তুমি তার লগে যেতা করছো ইতা হে ফাউরিলিলে, আমি খবরিয়াদি তুমারে আনাইমু। কিতাল্লাগি আমি একদিনে তুমরা দুইওজনরে আরাইতাম?” ");
INSERT INTO syl_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","বাদে রেবেকায় ইছহাকরে কইলা, “অউ হিট্টী পুড়িন্তর লাগি আমার আর বাচার স্বাদ নাই। ইয়াকুবেও যুদি অউ লাখান, ই দেশর কুনু হিট্টী পুড়িরে শাদি করিলায়, তাইলে আমার আর বাচিয়াউ লাভ কিতা?” ");
INSERT INTO syl_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","রেবেকার মাত হুনিয়া ইছহাকে, ইয়াকুবরে আনাইয়া দোয়া করলা আর অউ হুকুম দিলা, “তুমি কেনান দেশর কুনু পুড়িরে বিয়া করিও না। ");
INSERT INTO syl_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","তুমি পদ্দন-ইরাম দেশো তুমার নানা বথুয়েলর বাড়িত যাওগি, হনো তুমার মামু লাবনর কুনু পুড়িরে বিয়া করিও। ");
INSERT INTO syl_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","সর্ব-শক্তিমান আল্লায় তুমারে বরকত নাজিল করউক্কা আর ফলদার করিয়া বউত বাড়াউক্কা, যাতে করি তুমি বউত গুষ্টিআলা জাতি অও। ");
INSERT INTO syl_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","যে বরকত তাইন ইব্রাহিমরে নাজিল করছলা, হউ বরকত তাইন তুমারে আর তুমার বংশরে দান করউক্কা। আর যে দেশ আল্লায় ইব্রাহিমরে দিছইন, যেখানো তুমি অখন মুছাফির আছো, ই দেশখান যানু তুমার অয়।” ");
INSERT INTO syl_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","বাদে ইছহাকে ইয়াকুবরে বিদায় দিলা, আর তাইন পদ্দন-ইরামো অরামী বথুয়েলর পুয়া লাবনর গেছে রওয়ানা অইলা। লাবন অইলা রেবেকার ভাই, ইয়াকুব আর ঈষʼর মামু। ");
INSERT INTO syl_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","ঈষে যেবলা হুনলা, ইছহাকে ইয়াকুবরে দোয়া করিয়া বিয়া করানির নিয়তে পদ্দন-ইরামো পাঠাইছইন আর কেনানী পুড়িন্তরে বিয়া করতে নিষেধ করছইন, ");
INSERT INTO syl_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","আর ইয়াকুবে তান মা-বাফর হুকুমে পদ্দন-ইরামো গেছইনগি, ");
INSERT INTO syl_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","অউ ঈষে বুজলা যেন, তান বাফ ইছহাক কেনানী বেটিন্তর উপরে খুশি নায়। ");
INSERT INTO syl_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","এরলাগি দুই বউ থাকলেও তাইন ইব্রাহিমর পুয়া ইছমাইলর গেছে গিয়া তান পুড়ি মহলতরে বিয়া করলা। মহলত অইলা নাবাউতর বইন। ");
INSERT INTO syl_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","আর ইয়াকুবে বের-শেবা ছাড়িয়া তান মামুর বাড়ি হারান টাউনর বায় রওয়ানা দিলা। ");
INSERT INTO syl_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","পথো এক জাগাত সুরুজ ডুবি গেলে তাইন হনোউ রাইত কাটাইলা। হনর পাথরদি হিতান দিয়া ইয়াকুবে ঘুমাইতা করি হুতিলা। ");
INSERT INTO syl_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","হুতিয়া হারলে খোয়াবে দেখলা, দুনিয়াইর উপরে একখান মই উবাই রইছে, ই মইর মাথা আছমানো লাগাইল। তাইন দেখলা আল্লার ফিরিস্তা অকলে অগুবায় উঠা-নামা কররা, ");
INSERT INTO syl_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","আর মাবুদে এর উপরে উবাইয়া কইরা, “আমি মাবুদ, তুমার বাফ-দাদাইন ইব্রাহিমর আল্লা আর ইছহাকর আল্লা। তুমি অউ যে জমিনো হুতিছো, ইটা আমি তুমারে আর তুমার ওয়ারিশ অকলরে দিমু। ");
INSERT INTO syl_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","তুমার ওয়ারিশ অকল দুনিয়াইর ধুইল-বালুর লাখান বেহিসাব অইবা। আর পুবে-পইচমে, উতরে-দউকনে চাইরোবায় মেলিযিবা। তুমি আর তুমার বংশর মাজেদি দুনিয়াইর হক্কল জাতিয়ে বরকত হাছিল করবা। ");
INSERT INTO syl_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","আমি তুমার লগে লগে আছি, তুমি যেনোউ যাও না কেনে আমি তুমারে হেফাজত করমু আর অউ দেশো হিরবার তুমারে ফিরাইয়া আনমু। আমি তুমারে যেতা যেতা কইছি ইতা হাছিল অওয়ার আগে, তুমারে ছাড়তাম নায়।” ");
INSERT INTO syl_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","বাদে ইয়াকুবে ঘুম থাকি উঠিয়া কইলা, “তাইলে হাছাউ মাবুদ ইনো আছইন, আমি তো জানতাম না।” ");
INSERT INTO syl_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","অউ তাইন ডরাইয়া কইলা, “কিজাত গরম ই জাগা! ইখান নিচ্চয় আল্লার ঘর, অখানোউ বেহেস্তর দুয়ার।” ");
INSERT INTO syl_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","তাইন ফজরর সময় উঠিয়া, যে পাথরটা তান মাথার তলে হিতান দিছলা, ইকটা খুটির মত করি গাড়িয়া এর উপরে তেল ঢালিলা। ");
INSERT INTO syl_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","আর হি জাগার নাম রাখলা বেথেল মানি, বায়তুল্লা, ইনর আগর নাম আছিল লুজ। ");
INSERT INTO syl_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","বাদে ইয়াকুবে কছম খাইয়া কইলা, “আল্লায় যুদি আমার ই ছফরো হেফাজত করইন, তাইন আমার খানি-খুরাক, ফিন্দার লেবাছ যুগাই দেইন, ");
INSERT INTO syl_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","আমি হিরবার ছহি-ছালামতে বাফর বাড়িত ফিরিয়া আই, তে অউ মাবুদরেউ আমার আল্লা মানমু। ");
INSERT INTO syl_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","আর অউ যে পাথর আমি খুটি গাড়িয়া থইলাম, অনো বায়তুল্লা শরিফ অইবো। আর তুমি আমারে যততা দিবায়, এর দশ বাটর এক বাট আমি নিচ্চয় তুমারে দিলাইমু।” ");
INSERT INTO syl_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","বাদে ইয়াকুবে আটি আটি পুবর দেশর মানষর এলাকাত গেলাগি। ");
INSERT INTO syl_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","গিয়া হনর বন্দর মাজে এক কুয়া দেখলা। হউ কুয়ার গেছে তিন পাল মেড়া হুতি রইছে; রাখাল অকলে অন থনে তারারে পানি খাওয়াইন। আর কুয়ার মুখো বড় এক পাথর থওয়া অইছে। ");
INSERT INTO syl_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","হকল মেড়ার পাল যেবলা একখানো অইতো, তেউ রাখাল অকলে কুয়ার মুখ থনে পাথরগু হরাই দিয়া মেড়াইন্তরে পানি খাওয়াইতো। বাদে পাথররে হিরবার কুয়ার মুখো থইতো। ");
INSERT INTO syl_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","ইয়াকুবে তারারে জিকাইলা, “ভাই অকল, আপনারা কুন জাগার মানুষ?” তারা কইলা, “হারান টাউনর।” ");
INSERT INTO syl_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","অউ তাইন কইলা, “আপনারা নাহুরর নাতি লাবনরে চিনইন নি?” তারা কইলা, “জিঅয়, চিনি।” ");
INSERT INTO syl_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","ইয়াকুবে জিকাইলা, “তাইন ভালা আছইন নি?” তারা কইলা, “জিঅয়, ভালা আছইন। অউনু তান পুড়ি রাহেলায় মেড়ার পাল লইয়া আইরা।” ");
INSERT INTO syl_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","তাইন কইলা, “দেখউক্কা, অখনও বউত বেইল আছে। তে পশু অকল একখানো অইবার সময় তো অইছে না। আপনারা মেড়াইন্তরে পানি খাওয়াইয়া হিরবার রাখাত লইয়া যাইনগি।” ");
INSERT INTO syl_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","তারা কইলা, “না, আমরা ইলা করতাম পারি না, হক্কল পাল একখানো দলা অইলে বাদে কুয়ার মুখ থনে পাথর হরাইয়া আমরা মেড়াইন্তরে পানি খাওয়াই।” ");
INSERT INTO syl_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","তাইন অখনও তারার লগে মাতো রইছইন, অউ সময় রাহেলায় তান বাফর মেড়ার পাল লইয়া অনো আইলা, তাইন ই পালর রাখালিত আছলা। ");
INSERT INTO syl_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","ইয়াকুবে তান মামু লাবনর পুড়ি রাহেলারে আর তান মেড়ার পাল দেখিয়াউ কুয়ার গেছে গিয়া কুয়ার মুখ থনে পাথরটা হরাইয়া মেড়াইন্তরে পানি খাওয়াইলা। ");
INSERT INTO syl_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","বাদে তাইন রাহেলারে মায়া দিয়া জুরে জুরে কান্দিতা লাগলা। ");
INSERT INTO syl_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","আর তাইন রাহেলারে কইলা যেন, তাইন লাবনর ভাইগনা, রেবেকার পুয়া। অউ রাহেলায় দৌড়াইয়া গিয়া তান বাফরে ই খবর দিলা। ");
INSERT INTO syl_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","লাবনে তান ভাইগনা ইয়াকুবর খবর হুনিয়া দৌড়াইয়া তান লগে দেখা করাত আইলা। তানরে আইঞ্জা করি ধরিয়া হুংগা দিয়া বাড়িত লইয়া গেলা। গিয়া হারলে ইয়াকুবে লাবনরে তান আইবার হক্কলতা জানাইলা। ");
INSERT INTO syl_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","লাবনে কইলা, “তুমি তো আমারউ জান আর আমারউ গোস্ত।” আর ইয়াকুব লাবনর বাড়িত এক মাস রইলা। ");
INSERT INTO syl_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","এক মাস বাদে লাবনে ইয়াকুবরে কইলা, “তুমি আমার কুটুম অইলায় করি বিনা বেতনে আমার চাকরি করতায় নি বা? তুমারে কিতা দিতাম, কইলাও।” ");
INSERT INTO syl_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","লাবনর দুইটা পুড়ি আছিল। বড়গুর নাম লেয়া আর হুরুগুর নাম রাহেলা। ");
INSERT INTO syl_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","লেয়ার খালি চউখউ সুন্দর আছিল, অইলে রাহেলার গঠন আর চেহারা-ছুরত, হক্কলতা সুন্দর আছিল। ");
INSERT INTO syl_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ইয়াকুবে রাহেলারে পছন্দ করতা করি তাইন কইলা, “আপনার হুরু পুড়ি রাহেলার লাগি আমি সাত বরছ আপনার গুলামি করমু।” ");
INSERT INTO syl_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","লাবনে কইলা, “রাহেলারে মানষর আতো দেওয়ার চাইতে তুমার গেছে দেওয়াউ ভালা। তুমি আমার গেছে রও।” ");
INSERT INTO syl_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","তেউ ইয়াকুবে রাহেলার লাগি সাত বরছ গুলামি করলা। রাহেলারে মহব্বত করতা করি, ইতা একো বরছ তান গেছে এক দিনর হমান মনো অইলো। ");
INSERT INTO syl_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","হেশে তাইন লাবনরে কইলা, “আমার গুলামির মিয়াদ পুরি গেছে। অখন আমার বউরে আমার আতো সমজাইয়া দেউক্কা, আমি তাইর গেছে রইতাম চাই।” ");
INSERT INTO syl_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","তেউ লাবনে হউ এলাকার হকল মানষরে বিয়ার দাওত করিয়া খানা-দানা খাওয়াইলা। ");
INSERT INTO syl_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","হেশে রাইত অইলে তাইন তান পুড়ি লেয়ারে ইয়াকুবর গেছে দিলা, আর ইয়াকুবে এন লগে রইলা। ");
INSERT INTO syl_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","লাবনে নিজর বান্দি জিল্পারে, তান পুড়ি লেয়ার বান্দি গিরিত দিলা। ");
INSERT INTO syl_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","অইলে বিয়ানে উঠিয়া দেখইন, এইন তো লেয়া। তেউ ইয়াকুবে লাবনরে কইলা, “আপনে আমার লগে ইতা কুন জাতর কাম করলা? অতো দিন আমি রাহেলার লাগি আপনার গুলামি করছি নায় নি? তে আমারে ধুকা দিলা কেনে?” ");
INSERT INTO syl_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","লাবনে কইলা, “বড় পুড়ির আগে হুরু পুড়ির বিয়া দেওয়া আমরার দেশর চল নায়। ");
INSERT INTO syl_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","তুমি বিয়ার খুশি-বাসির হাপ্তাটা পার অইতে দেও। তেউ হি পুড়িরেও তুমার গেছে বিয়া দিমু, অইলে তুমি আরো সাত বরছ আমার গুলামি করতে অইবো।” ");
INSERT INTO syl_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","ইয়াকুবে তান কথা মানিয়া অউ খুশি-বাসির হাপ্তা পার করলা। বাদে লাবনে তান পুড়ি রাহেলারেও ইয়াকুবর গেছে শাদি দিলা। ");
INSERT INTO syl_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","আর তান বান্দি বিলহারে রাহেলার বান্দি গিরিত দিলা। ");
INSERT INTO syl_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","ইয়াকুবে রাহেলার লগেও রইলা, তাইন লেয়ার চাইতে রাহেলারে বেশি মায়া করতা। বাদে তাইন আরো সাত বরছ তান মামু লাবনর গুলামি করলা। ");
INSERT INTO syl_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","অইলে লেয়ারে মায়া না করায়, মাবুদে লেয়ারে হুরুতা পয়দার খেমতা দিলা, আর রাহেলা নিআওলাদি রইলা। ");
INSERT INTO syl_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","আর লেয়ার ঘরো এক পুয়া অইলো। তাইন পুয়ার নাম রাখলা রুবেন মানি, পুয়ারে দেখো। তাইন কইলা, “মাবুদে আমার দুখ দেখছইন, অখন নিচ্চয় আমার জামাইয়ে আমারে মায়া করবা।” ");
INSERT INTO syl_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","বাদে হিরবার তান ঘরো এক পুয়া অইলো। তাইন পুয়ার নাম রাখলা শিমিয়ন মানি, হুনইন, তাইন কইলা, “আমারে এলামি করার কথা মাবুদে হুনছইন, এরলাগি তাইন আমারে অউ পুয়া দিছইন।” ");
INSERT INTO syl_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","বাদে হিরবার তান ঘরো এক পুয়া অইলো। তাইন কইলা, “অখন আমার জামাইয়ে আমার লগে আশিক অইবা, তান তিনটা পুয়া আমার পেট থনে পয়দা অইলো।” অউ এর নাম রাখলা লেবি মানি, আশিক। ");
INSERT INTO syl_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","বাদে হিরবার তান আরো এক পুয়া অইলে তাইন কইলা, “ইফিরা আমি মাবুদর তারিফ করমু।” আর তাইন অউ পুয়ার নাম রাখলা এহুদা মানি, তারিফ। এরবাদে তান হুরুতা অওয়া বন্দ অইগেল। ");
INSERT INTO syl_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","রাহেলায় যেবলা দেখলা, তান ঘরো ইয়াকুবর কুনু আওলাদ অইরা না, অউ সময় তান বনির বায় ইংসা পয়দা অইলো। তাইন ইয়াকুবরে কইলা, “আমারে আওলাদ দেও, নাইলে আমি মরিযিমু!” ");
INSERT INTO syl_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","তেউ রাহেলার লগে ইয়াকুবে খুব গুছা করিয়া কইলা, “আমি কুনু আল্লা নি? তাইনউ তো তুমার পেট বন্দ করি দিছইন।” ");
INSERT INTO syl_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","রাহেলায় কইলা, “হুনউক্কা, আমার বান্দি বিলহা অনো আছে, আপনে তাইর গেছে যাউক্কা, তাইরেদি হুরুতা পাইয়া আমিও হুরুতা আলা অইযিতাম পারি।” ");
INSERT INTO syl_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","অখান কইয়া হারি রাহেলায় তান বান্দি বিলহারে ইয়াকুবর গেছে হাংগা দিলা, আর ইয়াকুব তাইর গেছে রইলা। ");
INSERT INTO syl_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","তেউ বিলহার ঘরো ইয়াকুবর এক পুয়া অইলো। ");
INSERT INTO syl_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","আর রাহেলায় কইলা, “আল্লায় আমারে ইনছাফ করছইন, আর আমার আহাজারি হুনিয়া এগু পুয়া দিছইন।” তাইন ই পুয়ার নাম রাখলা দান মানি, ইনছাফ। ");
INSERT INTO syl_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","বাদে রাহেলার বান্দি বিলহার ঘরো হিরবার ইয়াকুবর দুছরা পুয়া পয়দা অইলো। ");
INSERT INTO syl_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","আর রাহেলায় কইলা, “বইনর লগে মহা লাড়াইত আমি জিতছি।” অউ তাইন ই পুয়ার নাম রাখলা নপ্তালি মানি, লাড়াই। ");
INSERT INTO syl_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","লেয়ায় যেবলা দেখলা তান ঘরো আর হুরুতা অইরা না, তেউ তাইনও তান বান্দি জিল্পারে ইয়াকুবর গেছে হাংগা দিলা। ");
INSERT INTO syl_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","তেউ লেয়ার বান্দি জিল্পার পেটো ইয়াকুবর এক পুয়া অইলো। ");
INSERT INTO syl_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","আর লেয়ায় কইলা, “আমার কপাল খুলছে!” তাইন এর নাম রাখলা ছাদু মানি, কপাল। ");
INSERT INTO syl_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","বাদে লেয়ার বান্দি জিল্পার ঘরো ইয়াকুবর আরক পুয়া অইলো। ");
INSERT INTO syl_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","আর লেয়ায় কইলা, “আমার কত সুখ! হকল বেটিন্তে আমারে সুখি কইবা।” তেউ তাইন ই পুয়ার নাম রাখলা আশির মানি, সুখি। ");
INSERT INTO syl_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","গম দাওয়ার সময় রুবেনে বন্দো গিয়া কিছু ধুতরা-গুটা পাইয়া, তান মা লেয়ার গেছে আনিয়া দিলা। আর রাহেলায় লেয়ারে কইলা, “তুমার পুয়ার কয়গু ধুতরা-গুটা আমারে দেওছাইন।” ");
INSERT INTO syl_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","লেয়ায় কইলা, “তুমি আমার জামাইরে দখল করছো, ইতায় অইছে না নি? অখন আমার পুয়ার ধুতরা-গুটাও চাইরায় নি?” রাহেলায় কইলা, “তাইলে তুমার পুয়ার ধুতরা-গুটার বদলা আইজ রাইত তাইন তুমার লগে রইবা নে।” ");
INSERT INTO syl_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","হাইঞ্জা বালা ইয়াকুবে বন্দো থনে আইতেউ লেয়ায় বার অইয়া তানে কইলা, “আইজ আমার লগে রইবায়, কারন আমার পুয়ার ধুতরা-গুটার বদলা আমি তুমারে আওলাত নিছি।” অউ হি রাইত তাইন লেয়ার ঘরো হুতিলা। ");
INSERT INTO syl_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","আল্লায় লেয়ার দোয়া কবুল করায়, তান ঘরো ইয়াকুবর পাচ নম্বর পুয়ার জনম অইলো। ");
INSERT INTO syl_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","অউ লেয়ায় কইলা, “আমার জামাইর গেছে আমার বান্দিরে দিছলাম করি, আল্লায় আমারে এর বদলা দিলা।” এরলাগি তাইন ই পুয়ার নাম রাখলা ইছাখর মানি, বদলা। ");
INSERT INTO syl_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","বাদে হিরবার লেয়ার ঘরো ইয়াকুবর ছয় নম্বর পুয়ার জনম অইলো। ");
INSERT INTO syl_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","লেয়ায় কইলা, “আল্লায় আমারে বউত বড় এক নিয়ামত দিলা। অখন আমার জামাইয়ে আমারে দাম দিবা, কারন আমি তান ছয়গু পুয়ার জনম দিছি।” তাইন ই পুয়ার নাম রাখলা সবুলন মানি, দাম। ");
INSERT INTO syl_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","হেশে লেয়ার এক পুড়ি অইলো, তাইর নাম রাখলা দীনা। ");
INSERT INTO syl_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","আল্লায় রাহেলার বায়ও খিয়াল করলা। তাইন রাহেলার দোয়া কবুল করিয়া, তানরে হুরুতা পয়দার তাক্কত দিলা। ");
INSERT INTO syl_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","আর রাহেলার ঘরো এক পুয়া অইলে তাইন কইলা, “আল্লায় আমার শরম হরাইছইন।” ");
INSERT INTO syl_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","তাইন ই পুয়ার নাম রাখলা ইউছুফ মানি, বাড়ানি। তাইন কইলা, “মাবুদে আমারে আরোগু পুয়া বাড়াই দেউক্কা।” ");
INSERT INTO syl_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","রাহেলার ঘরো ইউছুফ অওয়ার বাদে, ইয়াকুবে লাবনরে কইলা, “অখন আমারে বিদায় দিলাউক্কা, আমি নিজর দেশর বাড়িত যাইগি। ");
INSERT INTO syl_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","আপনে তো জানইন, আমি কিলা আপনার গুলামি করছি, আমি আমার বউয়াইন আর পুয়া-পুড়ির লাগি আপনার গুলামি করছি। অখন তারারে লইয়া আমারে যাইতে দেউক্কা।” ");
INSERT INTO syl_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","লাবনে তানরে কইলা, “আমার লাগি যুদি তুমার মায়া থাকে, তে যাইও না। আমি আলামতে বুজিয়ার যেন, তুমার খাতিরে মাবুদে আমারেও বরকত নাজিল করছইন। ");
INSERT INTO syl_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","তুমার বেতন তুমি নিজেউ কইলাও। আমি তুমারে অলাউ দিমু।” ");
INSERT INTO syl_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","অউ ইয়াকুবে তানরে কইলা, “আমি কিলা আপনার গুলামি করছি, আর আমার আতো আপনার পশুর পাল কিলাখান অইছে, ইতা আপনেউ জানইন। ");
INSERT INTO syl_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","আমি আওয়ার আগে আপনে গরিব আছলা। আর অখন তো বাড়িয়া বউততা অইছে। আমার কারনে মাবুদে আপনারে বউত বরকত দিছইন। অইলে আমার নিজর পরিবারর লাগি কুনদিন কামাই করতাম?” ");
INSERT INTO syl_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","তেউ লাবনে কইলা, “আমি তুমারে কিতা দিতাম?” ইয়াকুবে কইলা, “আপনে আমারে কুন্তাউ না দিয়া যুদি আমার এগু মাত রাখইন, তে আমি হিরবার আপনার পশুর পালর খেজমত করমু। ");
INSERT INTO syl_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","আমি আইজ আপনার পশুর পালর মাজে গিয়া, ফুটা ফুটা দাগআলা আর কালা আর চিতরা মেড়াইন আর ছাগলর মাজে চিতরা আর ফুটা ফুটা রংগর হক্কলটি আমার বেতন বাবত নিমুগি। ");
INSERT INTO syl_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","তেউ আপনে যেবলাউ বেতনর কারনে আইবা, ই সময় দেখবা, আমার ইমানদারিয়ে আমার লাগি জুয়াপ দিবো। আর ফুটা ফুটা দাগআলা আর কালা আর চিতরা মেড়াইন আর ছাগলর মাজে চিতরা আর ফুটা ফুটা রংগরতা ছাড়া আর কুন্তা পাইলে মনো করবা, আমি চুরি করছি।” ");
INSERT INTO syl_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","অউ লাবনে কইলা, “আইচ্ছা, তুমার কথাউ ঠিক থাকউক।” ");
INSERT INTO syl_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","লাবনে হউ দিনউ পাল থাকি লাম্বা দাগআলা আর চিতরা ছাগল, ফুটা ফুটা দাগ আর চিতরা থুড়া থুড়া ধলা ছাগিন আর কালা মেড়া অকল আলগাইয়া নিজর পুয়াইন্তর গেছে দিলাইলা। ");
INSERT INTO syl_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","দিয়া তাইন ইয়াকুবর গেছ থাকি তিন দিনর পথ দুরই হরিয়া গেলাগি আর ইয়াকুবে লাবনর বাকি পাল অকলরে রাখাত রইলা। ");
INSERT INTO syl_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","ইয়াকুবে লিবনী, লাউজ আর আর্মোন গাছর কাচা ডাল কাটিয়া উপরে থাকি বাকল ফালাইয়া ডালর মাজে লাম্বা লাম্বা ধলা দাগ দিলা। ");
INSERT INTO syl_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","ছাগলর পালে আইয়া যেখানো পানি খাইন, তাইন অউ বাকল ফালাইল দাগআলা ডাল অকল, হনো পানির গামলার ছামনে থইলা। আর পানি খাওয়ার সময় এরা ফাল খাইতো। ");
INSERT INTO syl_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","তেউ অউ ডালর গেছে আইয়া ফাল খাওয়ায় তারার বাইচ্চাইনও চিতরা, লাম্বা দাগআলা আর ফুটা ফুটা রংগর অইতা। ");
INSERT INTO syl_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","বাদে তাইন অউ বাইচ্চাইন আলগাইতা, আর লাবনর ডোরাআলা আর কালা মেড়াইন্তর বায় মেড়িন্তর চউখ রাখাইতা। অউ লাখান তাইন, তান নিজর পালরে লাবনর পালর লগে মিলাইতা না। ");
INSERT INTO syl_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","আর জুরআলা মেড়ি-ছাগিন্তে ফাল খাওয়ার সময়, তাইন গামলাত তারার চউখর ছামনে অউ ডাল অকল থইতা, ");
INSERT INTO syl_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","অইলে কমজুর পশুর ছামনে ই ডালাইন থইতা না। তেউ লাবনর পশুইন অইতা কমজুর, আর ইয়াকুবর পশুইন অইতা জুরআলা। ");
INSERT INTO syl_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","অউ লাখান কাম করিয়া তাইন বউত ধনি অইলা। তান গুলাম-বান্দি, উট-গাধা আর পশুর পাল বউত বাড়িগেল। ");
INSERT INTO syl_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","বাদে ইয়াকুবর কানো আইলো লাবনর পুয়াইন্তে মাতিরা যেন, “ইয়াকুবে আমরার বাফর হক্কলতা নিছেগি, আর আমরার বাফর মাল দিয়াউ হে মালদার অইগেছে।” ");
INSERT INTO syl_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","আর ইয়াকুবেও খিয়াল করলা, তানবায়দি লাবনর আগর হি মনর ভাব আর নায়। ");
INSERT INTO syl_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","মাবুদে ইয়াকুবরে কইলা, তুমি তুমার বাফ-দাদার দেশো নিজর মানষর গেছে ফিরিয়া যাওগি। আমি তুমার লগে থাকমু। ");
INSERT INTO syl_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","অউ ইয়াকুবে খবরিয়া পাঠাইয়া লেয়া আর রাহেলারে বন্দো তান পশুর পালর গেছে আনাইয়া কইলা, ");
INSERT INTO syl_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","“আমি তুমারতানর বাফর মুখ দেখিয়া বুজিয়ার, তান আগর হি মনর ভাব আমার বায় নায়, অইলে আমার বাফর মাবুদ আল্লা আমার লগে লগে রইছইন। ");
INSERT INTO syl_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","তুমিতাইন তো জানো যেন, আমি আমার হকল শক্তি দিয়াউ তান কত গুলামি করছি, ");
INSERT INTO syl_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","তা-ও তাইন আমারে ঠগিছইন আর দশ-দশবার করিয়া আমার বেতন বদলাইছইন, অইলে আল্লায় আমার কুনু খেতি অইতে দিছইন না। ");
INSERT INTO syl_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","তাইন যেবলা কইলা, তুমার বেতন অইবো, ফুটা ফুটা রংগর পশু, তেউ পালর হকল পশুয়ে অউ লাখান বাইচ্চা দিলো। হিরবার তাইন যেবলা কইলা, তুমার বেতন অইবো ডোরাআলা পশু, তেউ পালর হকল পশুয়ে ডোরাআলা বাইচ্চা দিলো। ");
INSERT INTO syl_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","আল্লায় অউ লাখান করি তান পালর পশু আনিয়া আমারে দিছইন। ");
INSERT INTO syl_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“একবার পশুইন্তে ফাল খাওয়ার সময় আমি খোয়াবে দেখলাম, মেড়ি-ছাগিন্তর উপরে যে পাঠা অকল উঠিরা, ইগুইন ডোরাআলা, চিতরা আর ফুটা ফুটা রংগর। ");
INSERT INTO syl_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","খোয়াবর মাজে আল্লার ফিরিস্তায় আমারে ডাকিলা, ‘ইয়াকুব!’ আমি কইলাম, ‘অউনু আমি।’ ");
INSERT INTO syl_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","তাইন কইলা, ‘তুমি চউখ তুলিয়া দেখো, মেড়ি-ছাগিন্তর উপরে যেতা পাঠাইন উঠিরা, হক্কলটি ডোরাআলা, চিতরা আর ফুটা ফুটা রংগর। লাবনে তুমার লগে যেতা যেতা করছে, ইতা হকলতাউ আমি দেখছি। ");
INSERT INTO syl_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","আমি হউ বেথেলর আল্লা, যেনো তুমি খুটির উপরে তেল ঢালিয়া আমার নামে কছম করছলায়। অখন চলো, ই দেশ ছাড়িয়া তুমার জনম মাটিত ফিরত যাও।’ ” ");
INSERT INTO syl_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","অউ লেয়া আর রাহেলায় কইলা, “বাবার সম্পত্তির কুনু দাবি আর আমরার রইলো নি? ");
INSERT INTO syl_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","তাইন তো আমরারে বেগানা মানুষ মনো করিয়া, আমরারে বেচিলাইছইন আর আমরার হক্কলতাউ খাইলিছইন। ");
INSERT INTO syl_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","এরলাগি আল্লায় আমরার বাবার ছামানা থনে যততা নিছইন, ই হক্কলটিউ অখন আমরার আর আমরার আওলাদর অইছে। তে আল্লায় তুমারে যেলা হুকুম করছইন, তুমিও অউলা করো।” ");
INSERT INTO syl_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","বাদে ইয়াকুবে তান হুরুতাইন আর বিবিন্তরে উটর উপরে তুলিয়া, ");
INSERT INTO syl_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","পদ্দন-ইরামো তান কামাইল পশু অকল আর মাল-ছামানা হক্কলতা লইয়া, কেনান দেশো তান বাফ ইছহাকর গেছে রওয়ানা দিলাইলা। ");
INSERT INTO syl_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","হউ সময় লাবনে তান মেড়াইন্তর রুমা কাটার লাগি গেছলা, আর অউ ফাকে রাহেলায় তান বাফর মুর্তি অকল চুরি করিলিলা। ");
INSERT INTO syl_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","ইয়াকুবে তান যাওয়ার কথা অরামী লাবনরে না জানাইয়া তানরে ঠগিলা। ");
INSERT INTO syl_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","আর তাইন হক্কলতা লইয়া বাগিয়া, ফোরাত গাং পার অইয়া গিলিয়দর পাহাড়র ছামনেদি যাওয়াত রইলা। ");
INSERT INTO syl_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","যাওয়ার তিন দিন বাদে লাবনে হুনলা যেন, ইয়াকুব বাগিয়া গেছইনগি। ");
INSERT INTO syl_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","অউ তাইন খেশ-কুটুমরে লইয়া, ইয়াকুবর খরে অইয়া সাত দিনর পথ গিয়া, গিলিয়দর পাহাড়ো তারার লাগাল পাইলা। ");
INSERT INTO syl_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","অইলে রাইতর বালা আল্লায় খোয়াবে অরামী লাবনর গেছে আইয়া কইলা, “খবরদার! ইয়াকুবরে ভালা-বুরা কুন্তাউ কইও না।” ");
INSERT INTO syl_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","ইয়াকুবে পাহাড়র মাজে তাম্বু গাড়িছলা, আর লাবনে গিয়া তানরে অনোউ লাগাল পাইলিলা, তেউ লাবন আর তান খেশ-কুটুম অকলেও গিলিয়দর হউ পাহাড়র মাজে তাম্বু গাড়িলা। ");
INSERT INTO syl_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","বাদে লাবনে ইয়াকুবরে কইলা, “তুমি কেনে ইতা করলায়? আমারে ঠগিয়া আমার পুড়িন্তরে কেনে যুদ্ধর বন্দির লাখান লইয়া আইলায়? ");
INSERT INTO syl_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","কেনে তুমি ধুকা দিয়া আমারে না জানাইয়া, লুকাইয়া বাগিয়া আইলায়? আমারে জানাইলে তো আমি খুশি-বাসি করিয়া, দুতারা আর মন্দিরা বাজাইয়া গান গাইয়া, তুমারে বিদায় দিলাম অনে। ");
INSERT INTO syl_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","তুমি আমার পুড়িন্তরে আর নাতিনশারেও হুংগা দিতেও দিলায় না, বেআখলর মত কাম করলায়। ");
INSERT INTO syl_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","অখন আমি তো তুমরার খেতি করতাম পারমু, অইলে তুমরার বাফ-দাদার আল্লায় গত রাইত আমারে কইছইন, ‘খবরদার! ইয়াকুবরে ভালা-বুরা কুন্তাউ কইও না।’ ");
INSERT INTO syl_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","তুমার বাফর বাড়িত যাওয়ার লাগি মনে কান্দিছিল করি, তুমি বাগিয়া আইছো মানলাম, তে আমার দেবতা অকল কেনে চুরি করলায়?” ");
INSERT INTO syl_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","ইয়াকুবে জুয়াপ দিলা, “আমি ডরাইছলাম, মনো করছলাম, আপনে জুর করিয়া আপনার পুড়িন্তরে, আমার গেছ থনে কাড়িয়া রাখি দিবা। ");
INSERT INTO syl_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","তে অখন যার গেছে আপনার দেবতাইন পাইবা, তারে জিতা রাখতাম নায়। আমরার খেশ-কুটমর ছামনে হক্কলতা তালাশ করিয়া যুদি আপনার কুন্তা পাইন, তাইলে নেউক্কাগি।” হউ মুর্তি অকল যেন রাহেলায় চুরি করছইন, ইতা তো ইয়াকুবে জানইন না। ");
INSERT INTO syl_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","অউ লাবনে ইয়াকুব, লেয়া আর দুইও বান্দির তাম্বুত হামাইয়া হকলতা তুকাইয়া কুন্তা না পাইয়া, হেশে লেয়ার তাম্বু থনে রাহেলার তাম্বুত গিয়া হামাইলা। ");
INSERT INTO syl_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","রাহেলায় ই মুর্তি অকল নিয়া উটর গদ্দির ভিতরে থইয়া, তাইন অউ গদ্দির উপরে বইলা। লাবনে তান তাম্বুর হকলতা তুকাইয়া হনোও ইতা পাইলা না। ");
INSERT INTO syl_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","আর রাহেলায় তান বাফরে কইলা, “বাজান আমি উঠিয়া উবাইতাম পারিয়ার না করি আপনে বেজার অইন না যেন, বেটিয়ারা বেমারর লাগি আমার শরিল খারাপ।” অউ লাবনে হি মুর্তি অকল আর তুকাইয়া পাইলা না। ");
INSERT INTO syl_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","হেশে ইয়াকুবে গুছা অইয়া লাবনরে ছিড়াইয়া কইলা, “আমার অপরাধ কিয়ানো? আমি কিতা দুষ করছি, আপনে আমার খরে অইয়া অউলা খেদানিত আইলা? ");
INSERT INTO syl_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","আমার হকল মাল-ছামানা আউলাইয়া আপনার ঘরর কুন জিনিসখান পাইলা? পাইলে ইতা আপনার-আমার খেশ-কুটমর ছামনে রাখউক্কা, তারা আমরার বিচার করবা। ");
INSERT INTO syl_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","আমি ই বিশ বরছ আপনার লগে আছলাম। এর মাজে আপনার কুনু মেড়ি বা ছাগির পেটর বাইচ্চা নষ্ট অইছে না বা আপনার পালর কুনু মেড়াও আমি খাইছি না। ");
INSERT INTO syl_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","আর জংলি জানুয়ারে মারা কুনু পশুও আপনার গেছে আনছি না, ইতা আমি নিজেউ পুরিয়া দিছি। দিনো বা রাইত কুনু পশু চুরি অইলে, আপনে আমার গেছ থাকি ভরিয়া লইছইন। ");
INSERT INTO syl_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","আমি অউলা দিন কাটাইছি, দিনো জলছি গরমে আর রাইতে কাপছি শীতে। আমার চখুত ঘুম আইতো না। ");
INSERT INTO syl_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","যে বিশ বরছ আপনার বাড়িত রইছি, এর চৌদ্দ বরছ আমি আপনার দুই পুড়ির লাগি গুলামি করছি, আর ছয় বরছ গেছে আপনার পশুর লাগি। এর মাজে আপনে দশ-দশবার আমার বেতনও বদলাইছইন। ");
INSERT INTO syl_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","আল্লা পাক, যানরে আমার বাফ ইছহাকে মাবুদ হিসাবে ডরাইতা, যেইন আমার দাদা ইব্রাহিমরও মাবুদ, তাইন যুদি আমার লগে না থাকতা, তে হাছাউ অখন আপনে আমারে খালি আতে বিদায় দিলা অনে। আল্লায় আমার মেনত আর দুখ দেখছইন। এরলাগিউ তাইন কাইল রাইত আপনারে ধমকাইছইন।” ");
INSERT INTO syl_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","লাবনে ইয়াকুবরে জুয়াপ দিলা, “ই পুড়িন আমারউ পুড়িন, আর অউ হুরুতাইন আমারউ নাতিনশা, আর ই পশুর পাল অকলও আমার। তুমি অনো যততা দেখরায়, হকলতাউ আমার, তা-ও আমার পুড়িন্তরে বা তারার হুরুতাইন্তরে আমি আর কিতা করমু? ");
INSERT INTO syl_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","আও, আমরা দুইওজনে এক চুক্তি করিলাই। অউ চুক্তির নিশানাটা তুমার-আমার মাজে সাক্ষি রইবো।” ");
INSERT INTO syl_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","অউ ইয়াকুবে এক পাথর লইয়া খুটি গাড়িলা। ");
INSERT INTO syl_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","আর তান খেশ-কুটুম অকলরে কইলা, “আপনারাও পাথর আনউক্কা।” তেউ তারাও পাথর আনিয়া এক ভিটা বানাইলা, হেশে অউ ভিটার গেছে খানি খাইলা। ");
INSERT INTO syl_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","লাবনে হউ ভিটার নাম রাখলা যিগর-সাহদুতা মানি, সাক্ষি-ভিটা অইলে ইয়াকুবে এর নাম রাখলা গল-এদ। ");
INSERT INTO syl_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","লাবনে কইলা, “অউ ভিটা অখন থনে তুমার-আমার সাক্ষি অইলো।” এরলাগি অউ ভিটার নাম অইলো গল-এদ, ");
INSERT INTO syl_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","আর অউ খুটির নাম অইলো মিস্পা মানি, পাহারার জাগা। লাবনে কইলা, “আমরা যেবলা হরিয়া যাইমুগি অউ সময় মাবুদেউ তুমার-আমার পাহারা দিবা। ");
INSERT INTO syl_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","তুমি যুদি আমার পুড়িন্তরে দুখ দেও বা আমার পুড়িন ছাড়া আর কেউররে বিয়া করো, তাইলে কুনু মানুষ আমরার লগে না রইলেও আল্লা আমরার সাক্ষি রইলা।” ");
INSERT INTO syl_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","লাবনে ইয়াকুবরে আরো কইলা, “অউ ভিটা বায় আর অউ খুটির বায় চাও, ইটা তুমার-আমার মাজখানো আমি গাড়লাম। ");
INSERT INTO syl_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ই দুইওটা তুমার-আমার সাক্ষি রইলো। তুমিও ইংসা করি অউ ভিটা আর খুটি ডিংগাইয়া আইবায় না আর আমিও বুরাইর নিয়তে ইতা ডিংগাইয়া যাইতাম নায়। ");
INSERT INTO syl_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","ইব্রাহিমর আল্লা, নাহুরর উপরআলা আর তারার বাফর উপরআলায় তুমার-আমার বিচার করবা।” আর ইয়াকুবে, তান বাফ ইছহাকে যানরে ডরাইতা তান নামে কছম করলা। ");
INSERT INTO syl_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","ইয়াকুবে হউ পাহাড়র উপরে কুরবানি করিয়া তান খেশ-কুটুম অকলরে খাওয়ার দাওয়াত দিলা। খাওয়া-দাওয়া শেষ করিয়া হারি তারা হউ পাহাড়র মাজে রাইত রইলা। ");
INSERT INTO syl_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","বাদর দিন ফজরে লাবনে তান পুড়িন্তরে আর নাতিনশারে হুংগা দিয়া দোয়া করলা, হেশে তান বাড়ি মুখা পথ দিলা। ");
INSERT INTO syl_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","ইয়াকুবও তান পথে রওয়ানা অইলে, আল্লার ফিরিস্তা অকলে তানরে দেখা দিলা। ");
INSERT INTO syl_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","এরারে দেখিয়া তাইন কইলা, “ইতা আল্লার ফৌজ।” আর ই জাগার নাম রাখলা মহনয়িম মানি, দুই ফৌজ। ");
INSERT INTO syl_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","ইয়াকুবে তান আগে করি সেয়ীর বা ইদোম দেশো, তান বড় ভাই ঈষʼর গেছে কয়জন খবরিয়া পাঠাইলা। ");
INSERT INTO syl_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","তাইন এরারে হিকাই দিলা, “তুমরা আমার মুনিব ঈষʼরে কইও, তান গুলাম ইয়াকুবে কইছে, আমি অতদিন থনে আমরার মামু লাবনর গেছে মুছাফিরিত আছলাম। ");
INSERT INTO syl_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","আমার গরু-গাধা, ছাগল-মেড়া আর গুলাম-বান্দি হকলতাউ আছে। আমার মুনিবর গেছে দয়া পাওয়ার আশায় তুমরারে পাঠাইলাম।” ");
INSERT INTO syl_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","খবরিয়া অকলে ফিরিয়া আইয়া ইয়াকুবরে কইলা, “আমরা আপনার ভাই ঈষʼর গেছে গেছলাম। তাইন চাইরশো মানষরে লইয়া আপনার লগে মুলাকাত করাত আইরা।” ");
INSERT INTO syl_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","অউ ইয়াকুবে ডরাইয়া খুব অস্থির অইগেলা। তাইন লগর হকল মানষরে, গরু-ছাগল, মেড়া-মেড়ি আর উট-গাধা অকলরে দুই দলে আলগাইলা। ");
INSERT INTO syl_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","তাইন কইলা, ভাইয়ে আইয়া এক দলরে হামলা করলেও আরক দল নিরাপদে রইবো। ");
INSERT INTO syl_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","আর ইয়াকুবে দোয়া করলা, “ও আল্লা, আমার দাদা ইব্রাহিমর মাবুদ আর আমার বাফ ইছহাকর মাবুদ, তুমিউ আমারে হুকুম করছো যেন, ‘তুমার দেশো তুমার নিজর মানষর গেছে ফিরিয়া যাও, তেউ আমি তুমারে রহম করমু।’ ");
INSERT INTO syl_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","তুমার ই গুলামর বায় যে রহম আর ইমানদারি দেখাইছো, আমি ইতা কুন্তারউ লাখ নায়। আমি তো এগু লাঠি লইয়া ই জর্দান গাং পার অইছলাম, আর অখন দুই দল অইগেছি। ");
INSERT INTO syl_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","মাবুদ, আমি আরজ করিয়ার, আমার ভাই ঈষʼর আত থনে আমারে বাচাও। আমার ডর করের, হে আইয়া বউ পুয়া-পুড়ির লগে আমারেও খুন করবো। ");
INSERT INTO syl_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","তুমিউ তো ওয়াদা করছো, ‘আমি অবশ্যউ তুমার ভালাই করমু, তুমার ওয়ারিশ অকলরে দরিয়ার পারর বালুর লাখান বেহিসাব করমু, যেলা গনিয়া ফুড়ায় না।’ ” ");
INSERT INTO syl_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","ইয়াকুবে ই রাইত হনো রইলা আর তান যততা আছিল এর মাজ থাকি কতখান লইয়া তান ভাই ঈষʼর লাগি এক উপহার তৈয়ার করলা। ");
INSERT INTO syl_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","ইতা অইলো দুইশো ছাগি, কুড়িটা ছাগল, দুইশো মেড়ি, কুড়িটা মেড়া, ");
INSERT INTO syl_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","তিশগু বাইচ্চাআলা দুধর উট, দুই কুড়ি গাই, দশগু বিছাল, এক কুড়ি গাধী আর দশগু গাধা, ");
INSERT INTO syl_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","বাদে তাইন এক এক গুলামর আতো এক এক পাল সমজাই দিয়া কইলা, “তুমরা আমার আগে অইয়া যাও আর এক পাল থাকি আরক পালর মাজে ফাক রাখিও।” ");
INSERT INTO syl_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","পয়লা দলর গুলামরে তাইন হিকাই দিলা, “আমার ভাই ঈষʼর লগে দেখা অওয়ার বাদে যেবলা জিকাইবা, ‘কই যাইতায় বা? তুমি কার মানুষ? তুমার হমখর পশুইন কার?’ ");
INSERT INTO syl_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","তুমি জুয়াপ দিও, ‘ইতা আপনার গুলাম ইয়াকুবর। তাইন আমার মুনিব ঈষʼর লাগি, ইতা উপহার পাঠাইছইন। আর তাইন আমরার খরে অইয়া আইরা।’ ” ");
INSERT INTO syl_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","অউ লাখান তাইন দুই নম্বর, তিন নম্বর দলর গুলাম অকলরেও হিকাই দিলা যেন, “ঈষʼর লগে দেখা অইলে তুমরাও অউলা কইও। ");
INSERT INTO syl_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","আর হেশে কইও, আপনার গুলাম ইয়াকুবও আমরার খরে অইয়া আইরা।” ইয়াকুবে মনো করলা, “আগে উপহার অকল পাঠাইয়া তানে ঠান্ডা করমু, বাদে তান লগে দেখা-সাইক্ষাত করমু, তে তাইন আমারে মায়া করিলিতা পারইন।” ");
INSERT INTO syl_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","তান আগে অইয়া উপহার অকল গেলগি, অইলে তাইন রাইত তান ডেরাত রইলা। ");
INSERT INTO syl_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","হেশে রাইত উঠিয়া তান দুইও বিবিন, দুইও বান্দি আর এগারোগু পুয়ারে লইয়া পাওয়ে আটিয়া, জাব্বোক খালর হপারো থইয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","তাইন এরারে খাল পার করাইয়া তান হকল মাল-ছামানাও হনো পাঠাই দিলা। ");
INSERT INTO syl_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","আর তাইন একলা অনো রইলা, তেউ গাইবি একজন মানুষ আইয়া তান লগে রাইতভর কুস্তা-কুস্তি করলা। ");
INSERT INTO syl_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","অইলে তাইন ইয়াকুবরে কাবু করতা না পারায় এন উরাতর জুড়াত মারলা আর ইয়াকুবর উরাতর আড় জাগা থনে ডুলি গেল। ");
INSERT INTO syl_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","হেশে হি মানষে কইলা, “ফজর অইযার, অখন তুমি আমারে ছাড়ি দেও।” ইয়াকুবে কইলা, “আপনে আমারে দোয়া না করলে ছাড়তাম নায়।” ");
INSERT INTO syl_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","হি মানষে জিকাইলা, “তুমার নাম কিতা?” তাইন কইলা, “ইয়াকুব।” ");
INSERT INTO syl_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","অউ হেইন কইলা, “তুমি আল্লা আর মানষর লগে লাড়াই করিয়া জিতছো করি, তুমার নাম আর ইয়াকুব রইতো নায়, তুমার নাম অইলো ইছরাইল মানি, আল্লার লগে কুস্তি কররা।” ");
INSERT INTO syl_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","ইয়াকুবে তানরে কইলা, “আপনার নামখান কিতা কউক্কা।” তাইন কইলা, “তুমি কিতার লাগি আমার নাম জিকাইরায়?” হেশে তাইন ইয়াকুবরে দোয়া করলা। ");
INSERT INTO syl_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","অউ ইয়াকুবে ই জাগার নাম রাখলা পনুয়েল মানি, আল্লার ছুরত। তাইন কইলা, “আমি আল্লা পাকরে মুখামুখি দেখিয়াও জিন্দা রইছি।” ");
INSERT INTO syl_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","আর ইয়াকুবে পনুয়েল পারনির বাদে সুরুজ উঠিগেল। তান উরাতর মাইরর লাগি লেংড়াইতা লাগলা। ");
INSERT INTO syl_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","এরলাগি বনি ইছরাইলে অখনও রানর জুড়ার গোস্ত খাইন না, কারন তাইন উরাতর জুড়ার রগর মাজে ইয়াকুবরে মারছলা। ");
INSERT INTO syl_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","ইয়াকুবে চাইয়া দেখলা, তান বড় ভাই ঈষে চাইরশো মানুষ লইয়া আগুয়াইয়া আইরা। অউ তাইন হুরুতাইন্তরে তান বিবিন লেয়া আর রাহেলা আর দুইও বান্দির গেছে বাটিয়া দিলাইলা। ");
INSERT INTO syl_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","তাইন তান বান্দিন আর তারার হুরুতাইন্তরে ছামনর কাতারো রাখলা। বাদে লেয়া আর তান হুরুতাইন্তরে, হকল হেশে রাখলা রাহেলা আর ইউছুফরে। ");
INSERT INTO syl_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","আর নিজে এরার আগে গিয়া সাতবার মাটিত সইজদা করিয়া তান ভাইর গেছে আজির অইলা। ");
INSERT INTO syl_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","তেউ ঈষে তান গেছে দৌড়াইয়া আইয়া আইঞ্জা করি গলাত ধরিয়া হুংগা দিলা, আর দুইওজনে কান্দিতা লাগলা। ");
INSERT INTO syl_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","বাদে ঈষে মুখ তুলিয়া অউ বেটিন আর হুরুতাইন্তরে দেখিয়া জিকাইলা, “তুমার লগে এরা খেগু?” তাইন কইলা, “আল্লায় তান রহমতে আপনার গুলামরে ই হুরুতাইন দিছইন।” ");
INSERT INTO syl_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","তেউ পয়লা বান্দি অকলে ঈষʼর কাছাত আইয়া তারার হুরুতা লইয়া মাথা নোয়াইলা, ");
INSERT INTO syl_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","বাদে লেয়ায়ও হুরুতাইন্তরে লইয়া আগুয়াইয়া মাথা নোয়াইলা, হেশে ইউছুফ আর রাহেলায় গিয়া মাথা নোয়াইলা। ");
INSERT INTO syl_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","তেউ ঈষে কইলা, “পথো যেতা দলবল দেখলাম, ইতা কিওর লাগি?” তাইন কইলা, “আমার মুনিবর গেছে দয়া পাওয়ার লাগি।” ");
INSERT INTO syl_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","ঈষে কইলা, “ভাইরে, আমার বউততা আছে, তুমার ইতা তুমারউ থাকউক।” ");
INSERT INTO syl_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","তাইন কইলা, “জি না, আমি মিনত করিয়া কইয়ার, যুদি আমার বায় আপনার দয়া অয়, তাইলে আমার দেওয়া ই দান-দক্ষিনা আপনে নেউক্কা। আপনে যেবলা আমারে খুশি মনে কবুল করছইন, তে আপনার মুখ দেখা আর আল্লার দিদার পাওয়া আমার লাগি হমান। ");
INSERT INTO syl_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","আল্লায় আমারে রহমত দান করছইন, আমার বউততা আছে আর অউ যেতা উপহার আপনার লাগি আনছি, ইতা আপনে নেউক্কা।” তাইন অউলা মিনত-কাজ্জি করায়, ঈষে ইতা কবুল করলা। ");
INSERT INTO syl_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","ঈষে কইলা, “চলো, আমরা রওয়ানা অই, আমি তুমার লগে রইমু।” ");
INSERT INTO syl_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","ইয়াকুবে তানরে কইলা, “আমার মুনিবে তো জানরা, ই হুরুতা অকলও হুরু আর দুধাল গাইয়াইন-মেড়িনও লগে আছে, বেজান অইয়া ইতারে একদিনউ আটাইলে, হক্কলটি মরিযিবা। ");
INSERT INTO syl_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","তে মুনিব, আপনে আমার আগে যাউক্কাগি, পশুর পাল আর হুরুতা অকলর চলার খেমতা বুজিয়া আমি আস্তে আস্তে সেয়ীর এলাকাত আপনার গেছে আইরাম।” ");
INSERT INTO syl_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","ঈষে কইলা, “তাইলে আমার লগর অতা কয়জনরে তুমার গেছে থইয়া যাইগি।” তাইন কইলা, “ইতার দরকার কিতা? আমার মুনিবর গেছে আমি যে রহম পাইছি, অটাউ তো বউততা।” ");
INSERT INTO syl_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","আর ঈষ হউ দিনউ সেয়ীরর বায় রওয়ানা দিলাইলা। ");
INSERT INTO syl_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","অইলে ইয়াকুবে সুক্কতো পৌছিয়া নিজর লাগি ডেরা বানাইয়া, পশুর পালর লাগিও কয়খান বাথান বানাইলা, তেউ ই জাগার নাম অইলো সুক্কত মানি, ডেরা অকল। ");
INSERT INTO syl_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","পদ্দন-ইরাম থনে বার অইয়া ইয়াকুবে, ছহি-ছালামতে কেনান দেশর শিখিম টাউনো আইয়া, টাউনর বারে তাম্বুইন গাড়িলা। ");
INSERT INTO syl_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","হেশে অউ তাম্বুআলা জমিনখান তাইন, শিখিমর বাফ হমোরর পুয়াইন্তর গেছ থনে, রুপার একশো টেকা দিয়া খরিদ করলা। ");
INSERT INTO syl_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","আর হনো একখান কুরবানি খানা বানাইয়া এর নাম দিলা এল-ইলোহে-ইছরাইল মানি, আল্লা, ইছরাইলর উপরআলা। ");
INSERT INTO syl_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","লেয়ার ঘরো দীনা নামে ইয়াকুবর যে পুড়ি অইছিল, এইন একদিন হনর পুড়িন্তর লগে দেখা করাত গেলা। ");
INSERT INTO syl_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","আর শিখিম নামর একজন মানষর চউখো পড়লা। ই শিখিম আছিল হিব্বী জাতির সর্দার হমোরর পুয়া। শিখিমে এরে জুর করি ধরিয়া নিয়া খবিছি কাম করিল্লো। ");
INSERT INTO syl_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","দীনার বায় তার দিল আশিক অইগেল। হে এরে মহব্বত করি এর লগে মিঠা মিঠা মাত মাতিলো। ");
INSERT INTO syl_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","বাদে শিখিমে তার বাফ হমোররে কইলো, “তুমি অউ কইনারে আমার লগে বিয়ার বন্দোবস্ত করো।” ");
INSERT INTO syl_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","ইয়াকুবে খবর পাইলা, শিখিমে তান পুড়িরে বেইজ্জতি করছে, অইলে তান পুয়াইন পশুর পাল লইয়া বন্দো থাকায়, তাইন না-মাতিয়া নিরাই রইলা। ");
INSERT INTO syl_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","শিখিমর বাফ হমোরে ইয়াকুবর গেছে বিয়ার মাত লইয়া আইলো, ");
INSERT INTO syl_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","আর ই খবর হুনিয়া ইয়াকুবর পুয়াইনও বন্দো থনে আইলা। তারা বেথায়া গুছা আর গরম অইলা, কারন ইয়াকুবর পুড়িরে বেইজ্জতি করায় শিখিমে আস্তা ইছরাইলর লগে বেইজ্জতি আর নাজাইজ কাম করছে। ");
INSERT INTO syl_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","তেউ হমোরে এরারে কইলো, “আপনারার কইনার লাগি আমার পুয়া আশিক অইগেছে। দয়া করি, আমার পুয়ার লগে এর শাদি দিলাউক্কা। ");
INSERT INTO syl_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","আমরার লগে কুটুমিতা করউক্কা, আমরার কইনাইন্তরে আপনারা নেউক্কা আর আপনারারতা আমরারে দেউক্কা। ");
INSERT INTO syl_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","আর আমরার লগে থাকউক্কা, ই আস্তা দেশউ তো ছামনে রইছে, আপনারা অনোউ থাকইন, কায়-কারবার করিয়া, নিজর মালিকানা কাইম করইন।” ");
INSERT INTO syl_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","শিখিমে দীনার বাফ-ভাইরে কইলা, “আমার বায় আপনারা দয়া করইন, আপনারা আমার গেছে যেতা চাইবা, আমি অতাউ দিমু। ");
INSERT INTO syl_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","মহরানা আর মাল-ছামানা আপনারা যেতা দাবি করবা আমি দিমু, যেকুনু লাখানউ দীনারে আমার লগে বিয়া দেউক্কা।” ");
INSERT INTO syl_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","শিখিমে তারার বইনরে বেইজ্জতি করছিল করি ইয়াকুবর পুয়াইন্তে তারে আর তার বাফ হমোররে ভানা দেখাইয়া কইলা, ");
INSERT INTO syl_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“মছলমানি কাম না করাইল কুনু দামান্দর লগে আমরার বইনরে বিয়া দিলে আমরার বেইজ্জতি অইবো। ");
INSERT INTO syl_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","অইলে অউ কাম করলে আমরা রাজি অইমু, আপনারা হকল বেটাইন্তে মছলমানি করাইয়া, আমরার লাখান অইবা। ");
INSERT INTO syl_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","তাইলে আমরার পুড়িন্তরে আপনারার গেছে দিমু আর আপনারার পুড়িন্তরেও আমরা আনমু, আমরাও আপনারার লগে এক জাতি অইয়া বসত করমু। ");
INSERT INTO syl_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","অইলে আপনারা ই মছলমানির কথা না মানলে, আমরার কইনারে লইয়া যাইমুগি।” ");
INSERT INTO syl_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","তেউ তারার ই মাতে হমোর আর তার পুয়া শিখিম খুশি অইলা। ");
INSERT INTO syl_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","অউ শিখিম অইলো গুষ্টির মাজে হকল থনে দামি মানুষ। হে দেরি না করিয়া কথা মানিলাইলো, কারন ইয়াকুবর পুড়ির বায় হে আশিক আছিল। ");
INSERT INTO syl_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","বাদে টাউনর দুয়ারর গেছে আইয়া, হমোর আর তান পুয়ায় হক্কল মানষর লগে মাতিয়া কইলা, ");
INSERT INTO syl_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“ই মানুষগুইন্তে আমরারে কুনু জামেলা করের না। আমরার দেশো এরার থাকার লাগি বউত জাগাও আছে, তে এরা অনোউ থাকউক আর কায়-কারবার করউক, আমরা এরার পুড়িন্তরে বিয়া করিয়া আনি আর আমরার পুড়িন্তরেও তারার গেছে দেই। ");
INSERT INTO syl_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","অইলে আমরা একখান কাম করলে, তারা আমরার লগে এক জাতি অইতে রাজি আছইন। কামটা অইলো, তারার লাখান আমরারও হক্কল বেটাইন্তর মছলমানি করানি লাগবো। ");
INSERT INTO syl_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","আর তারার গরু-মেড়া, মাল-ছামানা হক্কলতাউ তো আমরার অইবো, তারার কথায় রাজি অইলেউ তারা আমরার লগে থাকবা।” ");
INSERT INTO syl_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","অউ টাউনর হকল বেটাইন হমোর আর তান পুয়া শিখিমর মাতে রাজি অইলো, আর তারা হকলর মছলমানি কাম করাইলো। ");
INSERT INTO syl_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","হেশে তিন দিনর দিন যেবলা হকল বেটাইন্তে মছলমানির বেদনায় কষ্ট পাইরা, অউ সময় দীনার আপন ভাই ইয়াকুবর দুই পুয়া শিমিয়ন আর লেবি, তারার তলোয়ার লইয়া টাউনো হামাইয়া, এরারে বে-খিয়ালো পাইয়া হকল বেটাইন্তরে মারিলিলো। ");
INSERT INTO syl_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","তারা হমোর আর তান পুয়া শিখিমরেও তলোয়ারদি জানে মারিয়া শিখিমর ঘর থনে দীনারে লইয়া আইলো। ");
INSERT INTO syl_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","এরা তারার বইনরে বেইজ্জতি করছিল করি, ইয়াকুবর হকল পুয়াইন্তে মরা লাশর গেছে আইয়া টাউনো লুট-তরাজ করলা। ");
INSERT INTO syl_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","আর টাউনর ভিতর-বাইরর গরু-গাধা, ছাগল-মেড়া, আর খেতর হকলতা লুটিয়া লইয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","হকল মাল-ছামানা, পুয়া-পুড়িন, বেটিন, আর ঘরর হকলতাও লুট-পাট করলা। ");
INSERT INTO syl_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","হেশে ইয়াকুবে শিমিয়ন আর লেবিরে কইলা, “তুমরা ই দেশর কেনানী আর ফারিজী অকলর গেছে আমারে পচা-ঘিন্নার মানুষ বানাইয়া মছিবতো ফালাইছো। আমার মানুষ কম, অখন তারা একখানো অইয়া আমারে হামলা করলে, আমি পরিবারর হক্কলরে লইয়া মরমু।” ");
INSERT INTO syl_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","তারা জুয়াপ দিলা, “হে আমরার বইনরে নিয়া খানকি বানাইলিতো নি?” ");
INSERT INTO syl_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","এরবাদে আল্লা পাকে ইয়াকুবরে কইলা, “তুমি হিরবার বেথেলো যাওগি। তুমার ভাই ঈষʼর গেছ থনে বাগিবার বালা, যেইন তুমারে দরশন দিছলা, হউ আল্লা পাকর নামে তুমি হনো একখান কুরবানি খানা বানাও।” ");
INSERT INTO syl_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","তেউ ইয়াকুবে তান আপন মানষরে আর লগর হকলরে কইলা, “তুমরার গেছে দেবতার যেতা মুর্তিন আছে, ইতা হক্কলটি ফালাও; আর হকলে পাক-ছাফ অইয়া, ছাফ-ছুতরা লেবাছ ফিন্দো। ");
INSERT INTO syl_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","আর চলো, আমরা বেথেলো যাইতামগি। হনো আমি আল্লার নামে একখান কুরবানি খানা বানাইমু, যেইন মছিবতর দিনো আমার দোয়া কবুল করছলা, আর আমার ছফরর লগি অইছলা।” ");
INSERT INTO syl_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","তেউ তারার যত লাখান দেবতার মুর্তিন আর কানর জেওরাত আছিল, হকলতা ইয়াকুবর আতো দিলাইলা। তাইন ইতা নিয়া শিখিম টাউনর কান্দাত এলন গাছর তলে গাড়িলাইলা। ");
INSERT INTO syl_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","বাদে তারা হন থনে রওয়ানা অইলা আর আল্লায় চাইরোবায় হকল গাউ-গেরামো এক ডর পয়দা করলা, তেউ হিনর কুনু মানষে ইয়াকুবর পুয়াইন্তরে খেদানিত গেল না। ");
INSERT INTO syl_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","হেশে ইয়াকুব আর তান লগর হকলে কেনান দেশর লুজ নামর জাগা, মানি বেথেলো আইয়া পৌছলা। ");
INSERT INTO syl_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","অনো তাইন এক কুরবানি খানা বানাইয়া, অউ জাগার নাম দিলা এল-বেথেল মানি, বেথেলর আল্লা, কারন ভাইর গেছ থাকি বাগিবার বালা আল্লায় অনোউ তানরে দিদার-দরশন দিছলা। ");
INSERT INTO syl_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","আর রেবেকার দাইমা দবোরা মারা গেলা। তানে বেথেলর লামাত এক এলন গাছর তলে মাটি দিলা, তেউ ই জাগার নাম অইলো এলন-বাখুত মানি, কান্দনর গাছ। ");
INSERT INTO syl_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","ইয়াকুবে পদ্দন-ইরাম থাকি আওয়ার বাদে, আল্লায় হিরবার তানরে দিদার দিয়া বরকত নাজিল করলা। ");
INSERT INTO syl_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","আল্লায় কইলা, “তুমার নাম তো ইয়াকুব; অইলে মানষে তুমারে আর ইয়াকুব কইয়া ডাকতা নায়, তুমারে ইছরাইল কইবা।” তেউ তান নাম অইলো ইছরাইল। ");
INSERT INTO syl_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","আল্লায় তানরে কইলা, “আমিউ সর্ব-শক্তিমান আল্লা। তুমি ফলআলা অইয়া বাড়ো। তুমা থনে এক জাতি পয়দা অইবো, ইটা অইবো বউত গুষ্টিআলা জাতি, আর তুমার খান্দানো বাদশা অকল পয়দা অইবা। ");
INSERT INTO syl_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","আমি ইব্রাহিম আর ইছহাকরে যে দেশ দান করছি, হউ দেশ অখন তুমারে আর তুমার বাদর ওয়ারিশরে দিমু।” ");
INSERT INTO syl_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","আল্লায় হনো ইয়াকুবর লগে বাতচিত করিয়া হারলে আছমানো তশরিফ নিলাগি। ");
INSERT INTO syl_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","ইয়াকুবে হউ বাতচিতর জাগাত পাথরর এক খুটি গাড়িয়া, এর উপরে তাইন আল্লার নামে শরবত-পানির ছদগা ঢালিলা, হেশে তেলও ঢালিলা। ");
INSERT INTO syl_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","আল্লায় যেখানো তানরে দিদার দিছলা, ইয়াকুবে ই জাগার নাম রাখছলা বেথেল। ");
INSERT INTO syl_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","বাদে ইয়াকুব আর তান লগর হকলে বেথেল থাকি রওয়ানা করিয়া ইফ্রাথো পৌছার বাক্কা আগে, রাহেলার হুরুতা অওয়ার বিষে ধরলো, তান খুব তকলিফ অইলো। ");
INSERT INTO syl_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","হুরুতা অওয়ার বিষ আরো বাড়লো, তেউ দাই বেটিয়ে কইলো, “ডরাইও না গো, ইবারও তুমার ঘরো পুয়া অইবো।” ");
INSERT INTO syl_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","অইলে রাহেলা মারা গেলা। মরার সময় তাইন পুয়ার নাম রাখলা বিন-অনী মানি, আমার তকলিফর পুয়া অইলে বাফে তার নাম রাখলা বিন-ইয়ামিন মানি, আমার বলর পুয়া। ");
INSERT INTO syl_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","রাহেলার মউতর বাদে ইফ্রাথ, মানি বেথেলহাম, যাওয়ার পথর কান্দাত তানরে মাটি দেওয়া অইলো। ");
INSERT INTO syl_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","মাটি দিয়া হারলে ইয়াকুবে তান কয়বরর উপরে এক পাথরর খুটি গাড়লা, ই খুটি আইজও অনো আছে। ");
INSERT INTO syl_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","অন থনে ইছরাইলে হিরবার রওয়ানা দিলা, আর এদর মিনার ফালাইয়া আইয়া তান তাম্বু গাড়িলা। ");
INSERT INTO syl_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ইছরাইল যেবলা হনো রইরা, অউ ফাকো রুবেনে গিয়া তার বাফর বাদর বিয়ার বউ বিলহার লগে জিনা করলো আর ইতা ইছরাইলর কানো গেল। ");
INSERT INTO syl_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","ইয়াকুবর বারোজন পুয়া আছলা, লেয়ার তরফা তান বড় পুয়া রুবেন, বাদে শিমিয়ন, লেবি, এহুদা, ইছাখর আর সবুলন। ");
INSERT INTO syl_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","রাহেলার তরফা ইউছুফ আর বিন-ইয়ামিন। ");
INSERT INTO syl_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","রাহেলার বান্দি বিলহার তরফা, দান আর নপ্তালি। ");
INSERT INTO syl_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","লেয়ার বান্দি জিল্পার তরফা, ছাদু আর আশির। তান অউ হুরুতা অকল পদ্দন-ইরামো অইছলা। ");
INSERT INTO syl_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","হেশে ইয়াকুব কিরিয়ত-অর্বর, মানি হেবরনর কাছাত মম্রি নামর জাগাত, তান বাফ ইছহাকর গেছে আইলা। অউ জাগাত ইব্রাহিম আর ইছহাকেও বসত করতা। ");
INSERT INTO syl_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ইছহাকর বয়স একশো আশি বরছ অইছিল। ");
INSERT INTO syl_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","আর ইছহাক পুরাপুর বুড়া অইয়া, মুরব্বি বয়সো মারা গিয়া তান বাফ-দাদার গেছে গিয়া আজিলা। তান পুয়া ঈষ আর ইয়াকুবে তানরে দাফন করলা। ");
INSERT INTO syl_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","অউ অইলো ঈষ বা ইদোমর খান্দানর বয়ান। ");
INSERT INTO syl_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","ঈষে কেনানী দুই পুড়িরে বিয়া করছলা। এরা অইলা হিট্টী এলনর পুড়ি আদা, আর হিব্বী জিবিয়নর নাতিন, অনার পুড়ি অহলীবামা। ");
INSERT INTO syl_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","এরার বাদেও তাইন ইছমাইলর পুড়ি নাবাউতর বইন বাসমতরে বিয়া করছলা। ");
INSERT INTO syl_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","আদার পেটো ইলিফজ আর বাসমতর পেটো রুয়েলর জনম অইছিল, ");
INSERT INTO syl_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","আর অহলীবামার পেটো যিয়ূশ, যালম আর কোরহর জনম অইছিল। ঈষʼর ই পুয়াইন্তর জন্ম অইছিল কেনান দেশো। ");
INSERT INTO syl_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","বাদে ঈষে তান বউয়াইন, পুয়া-পুড়িন, ঘরর হকল মানুষ আর পশুর পালাইন, কেনান দেশো কামাই করা হকল ধন-দৌলত লইয়া, তান ভাই ইয়াকুবর গেছ থনে হরিয়া আরক দেশো গেলাগি। ");
INSERT INTO syl_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","ঈষ আর ইয়াকুবর পশুর পাল, মাল-ছামানা অতো বেশি আছিল যেন, এরা একখানো রইতে হি দেশর ই জাগায় আর কুলাইলো না। ");
INSERT INTO syl_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","তেউ ঈষ সেয়ীরর পাহাড়ি এলাকাত গিয়া বসত করলা। এইনউ ইদোম। ");
INSERT INTO syl_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","অউ অইলো সেয়ীরর পাহাড়র ইদোমী অকলর মুল বাফ ঈষʼর খান্দানর বয়ান। ");
INSERT INTO syl_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ঈষʼর পুয়াইন্তর নাম অইলো, ইলিফজ আর রুয়েল। ইলিফজ আদার পুয়া, রুয়েল বাসমতর পুয়া। ");
INSERT INTO syl_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","ইলিফজর পুয়াইন অইলা, তৈমন, ওমার, জফো, গাথাম আর কেনাজ। ");
INSERT INTO syl_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ঈষʼর পুয়া ইলিফজর তিমনা নামর এক হাংগার বউ আছিল, এর ঘরো আমালেকর জনম অইছিল। এরা হকলেউ ঈষʼর বউ আদার আওলাদ। ");
INSERT INTO syl_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","রুয়েলর পুয়াইন অইলা নহথ, জারাহ, শম্ম আর মিজ্জা। এরা ঈষʼর বউ বাসমতর আওলাদ। ");
INSERT INTO syl_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","জিবিয়নর নাতিন, অনার পুড়ি অহলীবামার তরফা ঈষʼর পুয়াইন অইলা যিয়ূশ, যালম আর কোরহ। ");
INSERT INTO syl_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ঈষʼর আওলাদর মাজে এরা আছলা গুষ্টির নেতা। ঈষʼর বড় পুয়া ইলিফজর পুয়াইন অইলা তৈমন, ওমার, জফো, কেনাজ, ");
INSERT INTO syl_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","কোরহ, গাথাম, আর আমালেক। এরা অইলা ইদোম দেশো, আদার পুয়া ইলিফজর আওলাদ। ");
INSERT INTO syl_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","ঈষʼর পুয়া রুয়েলর পুয়াইন যেরা গুষ্টির নেতা অইছলা, তারা অইলা নহথ, জারাহ, শম্ম আর মিজ্জা। এরা অইলা ইদোম দেশো ঈষʼর বউ বাসমতর পুয়া রুয়েলর আওলাদ। ");
INSERT INTO syl_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","ঈষʼর বউ অহলীবামার যে পুয়াইন গুষ্টির নেতা অইছলা, তারা অইলা যিয়ূশ, যালম আর কোরহ। এরা আছলা অনার পুড়ি অহলীবামার আওলাদ। ");
INSERT INTO syl_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","এরা অইলা ঈষ বা ইদোমর খান্দান আর গুষ্টির নেতা। ");
INSERT INTO syl_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","হনর হোরীয় সেয়ীরর পুয়াইন্তর নাম অইলো লোটন, শোবল, জিবিয়ন, অনা, ");
INSERT INTO syl_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","দিশোন, এথসর আর দীশান। এরা হকলে ইদোম দেশো সেয়ীরর পুয়াইন, হোরীয় খান্দানর নেতা আছলা। ");
INSERT INTO syl_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","লোটনর পুয়ার নাম অইলো হোরী আর হেমাম, আর বনির নাম তিমনা। ");
INSERT INTO syl_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","শোবলর পুয়াইন্তর নাম অইলো অলবন, মানহথ, ইবাল, শফো আর ওনম। ");
INSERT INTO syl_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","জিবিয়নর পুয়াইন্তর নাম অইলো অয়া আর অনা। অউ অনাউ তান বাবা জিবিয়নর গাধা রাখাত গিয়া, মরুভুমির মাজে গরম পানির ইন্দারা অকল তুকাইয়া পাইলা। ");
INSERT INTO syl_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","অনার পুয়ার নাম দিশোন আর পুড়ির নাম অহলীবামা। ");
INSERT INTO syl_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","দিশোনর পুয়াইন্তর নাম অইলো হিমদন, ইশবন, যিত্রন আর কেরান। ");
INSERT INTO syl_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","এথসরর পুয়াইন্তর নাম অইলো বিলহন, জাওয়ান আর আকন। ");
INSERT INTO syl_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","দীশানর পুয়াইন্তর নাম অইলো আউজ আর অরান। ");
INSERT INTO syl_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","হোরীয় অকলর নেতা অইলা লোটন, শোবল, জিবিয়ন, অনা, ");
INSERT INTO syl_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","দিশোন, এথসর আর দীশান। এরা অইলা সেয়ীর দেশর হোরীয় গুষ্টির নেতা। ");
INSERT INTO syl_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","বনি ইছরাইলর মাজে বাদশাই হুকুমত আইবার আগে, ইদোম দেশো এরাউ রাজা আছলা। ");
INSERT INTO syl_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","বাউরর পুয়া বেলা ইদোমর রাজা অইলা। তান রাজধানির নাম আছিল দিনহাবা। ");
INSERT INTO syl_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","বেলা মরার বাদে, তান জাগাত বসরা টাউনর জারাহর পুয়া যোবব রাজা অইলা। ");
INSERT INTO syl_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","যোবব মরার বাদে তৈমন দেশর হুশম হনর রাজা অইলা। ");
INSERT INTO syl_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","হুশম মরার বাদে তান জাগাত বদদর পুয়া হদদ রাজা অইলা। তাইন যুদ্ধ করি মোয়াব দেশর মাদিয়ানী অকলরে আরাইলা। তান রাজধানির নাম অইলো অবীথ। ");
INSERT INTO syl_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","হদদ মরার বাদে মস্রেকা টাউনর ছামলা হনর রাজা অইলা। ");
INSERT INTO syl_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","ছামলা মরার বাদে হনর ফোরাত গাংগর পারর রহবত টাউনর শৌল রাজা অইলা। ");
INSERT INTO syl_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","শৌল মরার বাদে তান জাগাত আকবারর পুয়া বাআল-হানন রাজা অইলা। ");
INSERT INTO syl_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","আকবারর পুয়া বাআল-হানন মরার বাদে তান জাগাত হদর রাজা অইলা। তান রাজধানির নাম আছিল পাউ, আর তান বউর নাম আছিল মহেটাবেল। এইন মট্রেদর পুড়ি আর মেজাহাবর নাতিন। ");
INSERT INTO syl_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","ঈষʼর যেতা আওলাদ অকল গুষ্টি আর এলাকার নেতা আছলা, তারার নাম অইলো, তিমনা, অলবা আর যিতেথ, ");
INSERT INTO syl_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","অহলীবামা, এলা, পীনোন, ");
INSERT INTO syl_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","কেনাজ, তৈমন, মিবজার, ");
INSERT INTO syl_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","মগদিয়েল আর অরাম। এরা আছলা যারযির দেশর, যারযির এলাকার ইদোমী নেতা। ইদোমী অকলর মুল বাফ ঈষʼর বয়ান অনোউ শেষ। ");
INSERT INTO syl_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","ইয়াকুব কেনান দেশোউ রইলা, তান বাফও হনো মুছাফির অইয়া আছলা। ");
INSERT INTO syl_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","অউ অইলো ইয়াকুবর খান্দানর বয়ান। ইউছুফে সতরো বরছ বয়স থনে তান ভাইয়াইন্তর লগে মেড়া-ছাগল রাখতা। তাইন হুরুমান থনেউ তান হাতন মা বিলহা আর জিল্পার পুয়াইন্তর লগে রইতা। আর এরার হকল বাদ চাল-চলনর খবর বাফরে জানাইতা। ");
INSERT INTO syl_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","ইউছুফ, ইছরাইলর বুড়া বয়সর পুয়া গতিকে, তাইন এরে হকল থনে বেশি মায়া করতা। তাইন এরে এক খান্দানি জুব্বা বানাই দিলা। ");
INSERT INTO syl_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","বাফে ইউছুফরে হকল থনে বেশি মায়া করইন দেখিয়া, ভাইয়াইন্তে তানরে ঘিন্নাইতা। তারা এন লগে ভালা মনে মাত-কথাও মাততা না। ");
INSERT INTO syl_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ইউছুফে এক খোয়াব দেখিয়া তান ভাইয়াইন্তরে হুনাইলা, তেউ তারা আরো বেশি ঘিন্নাইলা। ");
INSERT INTO syl_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","তাইন কইলা, “আমি খোয়াবে কিতা দেখছি হুনো: ");
INSERT INTO syl_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","আমি দেখলাম, আমরা খেতর মাজে ধানর মুইট বান্দিয়ার আর আমার বান্দা মুইটখান উবাইগেল, তেউ তুমরার মুইট অকলে আমার মুইটরে চাইরোবায় বেরিয়া সইজদা করের।” ");
INSERT INTO syl_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","অউ তান ভাইয়াইন্তে কইলা, “তুই হাছাউ আমরার রাজা অইতে চাইরে নি? তুই রাজা অইয়া আমরার উপরে বেটাগিরি করতে নি?” তেউ তান খোয়াব আর তান মাতর লাগি তারা আরো বেশি ঘিন্নাইলা। ");
INSERT INTO syl_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ইউছুফে হিরবার এক খোয়াব দেখিয়া তান ভাইয়াইন্তরে হুনাইলা। তাইন কইলা, “হুনো, আমি হিরবার খোয়াবে দেখছি, চান-সুরুজ আর এগারোটা তেরায় আমারে সইজদা করের।” ");
INSERT INTO syl_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","তাইন ই খোয়াবর কথা তান বাফ আর ভাইয়াইন্তর গেছে কইয়া হারলে, বাফে তানরে ধমকাইয়া কইলা, “তুইন ইতা কুন জাতর খোয়াব দেখলে, রে পুত? তোর মা-ভাইয়াইন আর আমিও কিতা হাছাউ তরে সইজদা করতাম নি?” ");
INSERT INTO syl_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","আর ইউছুফরে তান ভাইয়াইন্তে খুব ইংসাইতা। অইলে বাফে ই খোয়াবর কথা মনো রাখলা। ");
INSERT INTO syl_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","আর তান ভাইয়াইন্তে বাফর পশুর পাল লইয়া শিখিমো রাখাত গেলা। ");
INSERT INTO syl_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","তেউ ইছরাইলে ইউছুফরে কইলা, “তোর ভাইয়াইন্তে পশুর পাল রাখাত শিখিমো গেছইন, তে আয়, আমি তরেও হনো পাঠাই।” তাইন কইলা, “আইচ্ছা, আমি যাইমু।” ");
INSERT INTO syl_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","ইছরাইলে তানে কইলা, “তুই গিয়া তোর ভাইয়াইন আর পশুর পালর খবর-আন্তর হুনিয়া আইয়া আমারে কইছ।” তেউ তাইন ইউছুফরে হেবরন থনে শিখিমো পাঠাইলা। আর ইউছুফও গিয়া শিখিমো আজির অইলা। ");
INSERT INTO syl_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","আইয়া হারলে তানরে খেতর মাজে ঘুরা-ফিরাত দেখিয়া এক বেটায় জিকাইলা, “তুমি কিতা তুকাইরায় বা?” ");
INSERT INTO syl_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","ইউছুফে কইলা, “আমি আমার ভাইয়াইন্তরে তুকাইয়ার। আপনে জানইন নি, এরা পশুর পাল কুন জাগাত রাখরা?” ");
INSERT INTO syl_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","হি বেটায় কইলা, “তারা ইন থনে গেছইনগি। আমি হুনছি তারা মাতিরা, আও, আমরা দোথনো যাইগি।” অউ ইউছুফে তুকাই তুকাই দোথনো গিয়া তারারে পাইলা। ");
INSERT INTO syl_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","ভাইয়াইন্তে দুরই থনে তানরে দেখলো, আর তারার গেছে পৌছার আগেউ তারা এনে খুন করার মতলব করলো। ");
INSERT INTO syl_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","তারা একজনে আরক জনরে কইলো, “অউ দেখো, খোয়াব দেখরা ছাব আইরা। ");
INSERT INTO syl_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","আও, অখনউ আমরা এনে খতম করিয়া অউ গাতো ফালাই দেই; বাদে কইমু, কুনু জংলি জানুয়ারে খাইলাইছে, হেশে দেখমুনে, তার খোয়াবর দশা কিতা অয়?” ");
INSERT INTO syl_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","অইলে রুবেনে ইতা হুনিয়া তারার আত থাকি এনরে বাচাইবার লাগি কইলা, “তারে জানে মারিও না।” ");
INSERT INTO syl_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","তাইন এরারে পরামিশ দিলা, “খুন-খারাপি করাত যাইও না, নিজর আতে না মারিয়া অগুরে এমনেউ গাতর মাজে ফালাই দেও।” অউলা তাইন ইউছুফরে তারার আত থনে বাচাইয়া, বাফর আতো পাঠানির চেষ্টা করলা। ");
INSERT INTO syl_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","ইউছুফ তান ভাইয়াইন্তর গেছে আইতেউ তারা, তান গতর থনে জুব্বা খুলিলাইলা, হউ খান্দানি জুব্বাটা টানিয়া খুলিলিলা। ");
INSERT INTO syl_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","আর তানে ধরিয়া গাতর মাজে ফালাই দিলা। ই গাত হুকনা আছিল, কুনু পানি আছিল না। ");
INSERT INTO syl_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","হেশে তারা খাওয়াত বইয়া চাইয়া দেখলা, গিলিয়দ থাকি ইছমাইলী এক বেপারির দল ইবায় আর। এরা উটর পিঠিত করি খুশবয় মশলা, আগর, আর মেশকে-আম্বর লইয়া মিসর দেশো যাইতা। ");
INSERT INTO syl_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","অউ এহুদায় তার ভাইয়াইনরে কইলো, “ধরো, ভাইরে খুন করিয়া আমরা লুকাইলিলাম, তেউ আমরার কিতা লাভ অইবো? ");
INSERT INTO syl_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","হে তো আমরারউ ভাই, আমরার আপন লউ আর গোস্ত। তে তার শরিলো আত না দিয়া আও, ইছমাইলী অকলর গেছে তারে বেচিলাই।” অউ ভাইয়াইনও রাজি অইগেলা। ");
INSERT INTO syl_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","হউ মাদিয়ানী বেপারি অকল কাছাত আইতেউ, ভাইয়াইন্তে ইউছুফরে গাতো থনে টানিয়া তুললা আর এক কুড়ি রুপার টেকার বদলা, ইছমাইলী অকলর গেছে তানে বেচিলাইলা। এরা ইউছুফরে লইয়া মিসরো গেলাগি। ");
INSERT INTO syl_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","বাদে রুবেনে হউ গাতর গেছে আইয়া ইউছুফরে না দেখিয়া, তান গতরর কোর্তা ফারিল্লা। ");
INSERT INTO syl_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","ভাইয়াইন্তর গেছে গিয়া কইলা, “পুয়াগু তো ইনো নায়। অখন আমি কিতা করতাম?” ");
INSERT INTO syl_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","অউ তারা এক বকরি মারিয়া, এর লউ ইউছুফর হউ জুব্বাত লাগাইলা। ");
INSERT INTO syl_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","বাদে মানুষদি অউ জুব্বা তারার বাফর গেছে পাঠাইয়া কইলা, “ইটা আমরা পথো পাইছি, তে আপনে ভালা করিয়া দেখউক্কা, ইটা আপনার পুয়ার জুব্বা নি?” ");
INSERT INTO syl_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","ইয়াকুবে ই জুব্বা চিনিয়া কইলা, “ইটা তো আমার পুয়ারউ। তারে কুনু জংলি জানুয়ারে খাইলিছে, তারে নিচয় ছিড়ি-বিড়িলাইছে।” ");
INSERT INTO syl_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","তাইন ফিন্নর কাপড় ছিড়িয়া, কমরো ছলার চট বান্দিয়া, পুয়ার লাগি বউত দিন মাত্তম করলা। ");
INSERT INTO syl_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","তান হকল পুয়া-পুড়িয়ে তানে বুজাইতা চাইলা, অইলে কুনু বুজেউ তান বুক ঠান্ডা অইলো না। তাইন কইলা, “আমি মাত্তম করি করি আমার পুয়ার গেছে কয়বরো হামাইমু।” পুয়ার লাগি তাইন অউ লাখান কান্দা-কাটিত রইলা। ");
INSERT INTO syl_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","এর মাজে মাদিয়ানী অকলে ইউছুফরে মিসরো নিয়া, ফেরাউনর কর্মচারি আজিজর গেছে বেচিলাইলা, ই কর্মচারি আছলা তান পরধান গাড। ");
INSERT INTO syl_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","এহুদায় তার ভাইয়াইন্তরে থইয়া অদুল্লম গাউর হীরা নামর এক মানষর লগে রওয়াত গেল। ");
INSERT INTO syl_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","হনো রইয়া শূয়া নামর এক কেনানী মানষর পুড়ির লগে দেখা অইলো, দেখিয়া হে অউ পুড়িরে বিয়া করলো। ");
INSERT INTO syl_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","বিয়ার বাদে হউ বেটির ঘরো এক পুয়া অইলো, এহুদায় তার নাম রাখলো এইর। ");
INSERT INTO syl_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","হিরবার বেটির ঘরো আরক পুয়া অইলে, মাʼয় তার নাম রাখলো ওনন। ");
INSERT INTO syl_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","হেশে অউ বেটির আরক পুয়া অইলে, তার নাম রাখলো শেলা। ই সময় তারা কষীব গাউত রইতা। ");
INSERT INTO syl_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","আর এহুদায় তার বড় পুয়া এইরর লগে তামার নামর এক পুড়িরে বিয়া দিলো। ");
INSERT INTO syl_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","অইলে তার ই পুয়া মাবুদর নজরো খুব খবিছ আছিল গতিকে, মাবুদে তারে মারিলাইলা। ");
INSERT INTO syl_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","অউ এহুদায় ওননরে কইলো, “তুমার ভাবিরে বিয়া করিলাও। তাইর দেওর অওয়ায় তুমার যেতা করা জরুর আছে, ইতা আদায় করো আর নিজর ভাইর ওয়ারিশ পয়দা করো।” ");
INSERT INTO syl_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ওননে জানতো, ই ওয়ারিশ তার নিজর অইতো নায়, আর তার ভাইর ওয়ারিশ রাখতে তার খিয়াল আছিল না গতিকে, তাইর লগে মিলা-মিশার সময় তার বিজ বাইরে মাটিত ফালাই দিতো। ");
INSERT INTO syl_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","মাবুদে তার ই কামে নারাজ অইলা, তাইন এইররেও মারিলাইলা। ");
INSERT INTO syl_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","অউ এহুদায় তার পুয়ার বউ তামাররে কইলো, “আমার পুয়া শেলা যতদিন বড় না অয়, অতদিন তুমার বাফর বাড়িত গিয়া ড়াড়ি অইয়াউ রও।” এহুদায় ডরাইলো, শেলাও তার ভাইয়াইন্তর লাখান মরিযিবো। আর তামার বাফর বাড়িত গেলগি। ");
INSERT INTO syl_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","বাক্কা কয়দিন বাদে এহুদার বউ, শূয়ার পুড়ি মরিগেল, তেউ কান্দা-কাটি করার বাদে এহুদায় শান্তি অইয়া অদুল্লম গাউর তার দুস্ত হীরার লগে তিমনা গাউত, তার মেড়ার পালর রুমা কাটরা মানষর গেছে রওয়ানা দিলো। ");
INSERT INTO syl_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","আর তামাররে গিয়া কেউ খবর দিলো “তুমার হউরে তান মেড়ার রুমা কাটার লাগি তিমনাত যাইরা।” ");
INSERT INTO syl_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","তামারে দেখলো, শেলা বড় অইলেও হউরে শেলার লগে তাইর বিয়া দিরা না, অউ তাই ড়াড়ির কাপড় বদলাইয়া হাজি-পাড়ি মুখো ঘুমটা দিয়া, আয়নাইমর পথর মুখো গিয়া বইলো। আয়নাইম আছিল তিমনাত যাওয়ার পথো। ");
INSERT INTO syl_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","আর তাই মুখ লুকাইয়া রাখায়, এহুদায় মনো করলো ইগু ছিলান বেটি। ");
INSERT INTO syl_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","তেউ এহুদায় পুয়ার বউরে না চিনায়, পথর ধারো তামারর গেছে গিয়া কইলো, “আও, তুমার লগে মিলা-মিশা করি।” তামারে কইলো, “তে আমারে কিতা দিবায়?” ");
INSERT INTO syl_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","হে কইলো, “আমার পাল থনে বকরি বাইচ্চা এগু পাঠাই দিমু।” তামারে কইলো, “ইটা পাঠানির আগে আমার গেছে কুন্তা জিম্মা থইয়া যাউক্কা।” ");
INSERT INTO syl_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","এহুদায় কইলো, “কিতা থইতাম?” তাই কইলো, “আপনার অউ ফিতাআলা সীল আর আপনার আতর লাঠি থইয়া যাউক্কা।” তেউ এহুদায় অগুইন জিম্মা থইয়া তাইর লগে মিলা-মিশা করলো আর তামারর পেটো হুরুতা আইলো। ");
INSERT INTO syl_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","বাদে তামার উঠিয়া গেলগি আর হি কাপড় বদলাইয়া হিরবার ড়াড়ির কাপড় ফিন্দিলো। ");
INSERT INTO syl_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","হেশে অউ বেটির গেছ থাকি জিম্মার মাল ফিরত নিবার লাগি, তার অদুল্লমর দুস্তরে দিয়া ছাগলর বাইচ্চা এগু পাঠাইলো। হে আইয়া তাইরে তুকাইয়া পাইলো না। ");
INSERT INTO syl_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","অউ হে হনর মানষরে জিকাইলো, “আয়নাইমর পথর ধারো এক সেবক বেটি আছিল, অগু কই?” তারা কইলা, “ইনো তো ইলা কুনু বেটি নায়।” ");
INSERT INTO syl_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","তেউ হে এহুদার গেছে গিয়া কইলো, “আমি গিয়া তাইরে তুকাইয়া পাইলাম না। হনর মানষেও কইলা, ইনো তো ইলা কুনু বেটি আইছে না।” ");
INSERT INTO syl_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","এহুদায় কইলো, “তে ইতা আর তাইর গেছেউ থাকউক। নাইলে আমরা শরমিন্দা অইমু। ছাগলর বাইচ্চা তো পাঠাইলাম, তা-ও তুমি এরে তুকাইয়া পাইলায় না।” ");
INSERT INTO syl_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","অনুমান তিন মাস বাদে এহুদায় হুনলো, তার পুয়ার বউ তামারে জিনা করছে, এরলাগি তাইর হুরুতা অইতা। অউ এহুদায় কইলো, “অগুরে বারে নিয়া আগুইনদি জালাইলাও।” ");
INSERT INTO syl_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","তামাররে যেবলা বারে নিরা, অউ সময় তাইর হউররে খবর দিলো যেন, “যার হুরুতা আমার পেটো আছে, অউ মাল-ছামানা অকল তার। তে দেখউক্কা, অউ ফিতাআলা সীল আর লাঠিগু কার চিনইন নি?” ");
INSERT INTO syl_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","এহুদায় ইতা দেখিয়া কইলো, “তাই তো আমা থাকি বউত বড় পরেজগার। আমার পুয়া শেলার লগে তাইরে বিয়া করাইছি না।” এরবাদে এহুদায় আর কুনুদিনও তামারর গেছে হুতিছে না। ");
INSERT INTO syl_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","হুরুতা অইবার বালা দেখইন, তামারর পেটো জুড়র হুরুতা। ");
INSERT INTO syl_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","পয়লা এগুয়ে তার আত বার করলো আর দাই বেটিয়ে লাল সুতা একছা তার আতো বান্দিয়া কইলো, “ইগু পয়লা পয়দা অইলো।” ");
INSERT INTO syl_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","অইলে হে আত টান দিয়া ভিতরে নিলগি, তেউ তার ভাই পয়লা বার অইলো আর দাই বেটিয়ে কইলো, “তুমি কিলা ফাক করিয়া বার অইলায়?” এরলাগি এর নাম অইলো ফিরোজ মানি, ফাক করা। ");
INSERT INTO syl_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","বাদে তার ভাই লাল সুতা আতো বান্দা লইয়া বার অইলো, তার নাম রাখলা জারাহ। ");
INSERT INTO syl_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","ইউছুফরে মিসর দেশো লইয়া যাওয়ার বাদে, ইছমাইলী অকলর গেছ থনে, আজিজ নামর ফেরাউনর একজন মিসরী কর্মচারিয়ে, ইউছুফরে খরিদ করলা। আজিজ অইলা ফেরাউনর পরধান গাড। ");
INSERT INTO syl_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","মাবুদে ইউছুফর লগি অইলা, এরলাগি ইউছুফ হকল কামো কামিয়াব অইলা। তাইন হউ মিসরী মুনিবর বাড়িত কাম করতা। ");
INSERT INTO syl_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","মাবুদ তান লগে লগে আছইন আর হকল কামো তানে কামিয়াব কররা, তান মুনিবেও ইতা বুজিলাইলা। ");
INSERT INTO syl_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","তেউ মুনিবে ইউছুফরে মায়া করতা লাগলা, তানে মুনিবর খাছ খেজমতগার বানাইলা আর তান বাড়ির হকলতা দেখা-হুনার ভারও ইউছুফর গেছে সমজাই দিলা। ");
INSERT INTO syl_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","ইউছুফরে তান বাড়ির আর হকলতার ভার সপি দেওয়ার বাদে থনে, মাবুদে ইউছুফর লাগিউ, তান মুনিবর হকলতার মাজে বরকত নাজিল করলা। আজিজর বাড়িত আর খেত-খামার, হকল জাগাত মাবুদে বরকত নাজিল করলা। ");
INSERT INTO syl_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","ইতা দেখিয়া আজিজে তান হকলতার ভার ইউছুফর উপরে সপি দিলা, তান নিজর খানা-দানা ছাড়া আর কুন্তারউ খবর লইতা না। ইউছুফর শরিলর গঠন আর চেহারাও সুন্দর আছিল। ");
INSERT INTO syl_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ইতা দেখিয়া তান মুনিবর বউয়ে তান বায় লালছ করলো। তাই ইউছুফরে কইলো, “আমার বিছনাত আও।” ");
INSERT INTO syl_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","অইলে ইউছুফ রাজি না অইয়া মুনিবর বউরে কইলা, “দেখউক্কা, ই বাড়িত কিতা কিতা আছে, আমার মুনিবে কুন্তাউ খবর লইন না, হকলতার ভার আমার উপরে সমজাই দিছইন। ");
INSERT INTO syl_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ই বাড়িত আমা থনে বড় আর কেউ নায়। আপনে তো তান বিবি, এরলাগি আপনারে ছাড়া আর হকলরে তাইন আমার জিম্মায় রাখছইন, তে আমি কিলা অতো বড় এক জঘইন্য কাম করিয়া আল্লার বিরুদ্ধে গুনা করতাম?” ");
INSERT INTO syl_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","তাই হামেশা ইউছুফরে অউলা মিনত করলেও ইউছুফে তাইর গেছে হুততে বা কাছাত রইতেও রাজি অইলা না। ");
INSERT INTO syl_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","হেশে একদিন কুনু এক কামর লাগি ইউছুফ ঘরর ভিতরে হামাইলা, অউ সময় আর কেউ হিনো আছিল না। ");
INSERT INTO syl_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","তেউ আজিজর বউয়ে ইউছুফর কাপড়ো ধরি কইলো, “আমার বিছনাত আয়।” অইলে ইউছুফে তান কাপড় ফালাইয়া দৌড়িয়া গেলাগি। ");
INSERT INTO syl_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","ইউছুফে তাইর আতো কাপড় থইয়া দৌড়াইয়া গেলাগি করি, ");
INSERT INTO syl_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","আজিজর বউয়ে ঘরর মানষরে ডাকিয়া কইলো, “হুনো, তাইন আমরার লগে তামশা করার লাগি ই ইবরানি বেটারে আনছইন। হে আমারে বেইজ্জতি করার মতলবে আমার বিছনাত আইছিল, অউ আমি চিল্লাইয়া উঠছি। ");
INSERT INTO syl_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","আমার চিল্লানি হুনিয়া হে তার ফিন্নর কাপড় আমার গেছে থইয়া বাগিছে।” ");
INSERT INTO syl_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","ইউছুফর মুনিব বাড়িত না আওয়া পর্যন্ত, ই কাপড় তাই নিজর গেছে রাখলো। ");
INSERT INTO syl_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","তাইন আইয়া হারলে তাই নালিশ দিলো, “তুমি যে ইবরানি গুলামরে আমরার গেছে আনছো, হে আমারে বেইজ্জতি করার মতলবে আমার ঘরো হামাইছিল। ");
INSERT INTO syl_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","অইলে আমার হাউকা-হাউকি আর চিল্লানিয়ে হে আমার গেছে তার কাপড় ফালাই থইয়া বাগিছে।” ");
INSERT INTO syl_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","বউর মাত হুনিয়া ইউছুফর মুনিবে গুছায় আগুইন অইগেলা। তান বউয়ে কইলো, “তুমার গুলামে আমার লগে অউ লাখান কাম করছে।” ");
INSERT INTO syl_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","তেউ আজিজে ইউছুফরে নিয়া জেল খানাত হারাইলা। মিসরর বাদশার বন্দি অকলরে যেনো রাখইন, তানেও হউ জেল খানাত থইলা। ");
INSERT INTO syl_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","অইলে ইউছুফর উপরে মাবুদর ছায়া আছিল, তাইন ইউছুফরে বড় জেলার ছাবর গেছে মায়ার মানুষ বানাইলা। ");
INSERT INTO syl_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","বড় জেলার ছাবে জেল খানার হকল বন্দি অকলর সর্দারি ইউছুফর উপরে ছাড়ি দিলা, তেউ হনর হকল কাম-কাজ ইউছুফর হুকুমে চলতো। ");
INSERT INTO syl_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","আর বড় জেলার ছাবে কুন্তাউ দেখা-হুনা করা লাগতো না, কারন মাবুদ ইউছুফর লগে আছলা, এরলাগি ইউছুফে যেতাত আত দিতা, মাবুদে ইতা কামিয়াব করতা। ");
INSERT INTO syl_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ইতার বাদে মিসরর বাদশার দরবারর শরাব বিলাই দেওরা আর রুটি বানাওরা ই দুইওজনে বাদশার গেছে কছুর করলা। ");
INSERT INTO syl_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","তেউ ফেরাউন তারা দুইওজনর উপরে গুছা অইলা, ");
INSERT INTO syl_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","তাইন এরারে বন্দি করিয়া তান বড় জল্লাদর বাড়ির জেলো হারাইলা। অউ জেলো ইউছুফও আছলা। ");
INSERT INTO syl_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","বড় জল্লাদে ই দুইও কয়দির ভারও ইউছুফর আতো দিলা, আর ইউছুফে তারার খেজমত করতা লাগলা। অউলা এরা কিছুদিন জেলো রইলা। ");
INSERT INTO syl_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","বাদে মিসরর বাদশার হউ রুটি বানাওরা আর শরাব বিলাওরা দুইওজনে এক রাইতে দুখান খোয়াব দেখলা, তারার খোয়াবর মানিও আছিল দুই লাখান। ");
INSERT INTO syl_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","বিয়ানে ইউছুফে তারার গেছে গিয়া দেখলা, তারা খুব মন-মরা অইরইছইন। ");
INSERT INTO syl_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","ইউছুফে তারারে জিকাইলা, “কিতা অইছে, আইজ অতো বেজার কেনে?” ");
INSERT INTO syl_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","তারা জুয়াপ দিলা, “আমরা তো খোয়াব দেখছি, অইলে এর তাবির বুজাই দেওরা কেউ নায়।” ইউছুফে তারারে কইলা, “মানি বুজানির খেমতা কিতা আল্লায় দেইন না নি? দেখিছাইন, আমারে হুনাউক্কা।” ");
INSERT INTO syl_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","অউ হি শরাব বিলাওরায়, তান স্বপন ইউছুফরে হুনাইলা। হে কইলো, “আমি দেখলাম, আমার ছামনে এক আংগুরর গাছ। ");
INSERT INTO syl_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","গাছর তিনগু ডাল আছে; হউ ডালো কুড়ি বারনির লগে লগে ফুল ধরলো, আর ছড়া ছড়া আংগুর ধরি পাকি গেল। ");
INSERT INTO syl_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","অউ সময় ফেরাউনর শরবতর পিয়ালা আমার আতো আছিল। আমি হউ আংগুর অকল চিপিয়া রস বার করি ফেরাউনর আতো দিলাম।” ");
INSERT INTO syl_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","ইউছুফে তারে কইলা, “আপনার স্বপনর মানি অইলো, তিন ডাল মানি তিন দিন। ");
INSERT INTO syl_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","অউ তিন দিনর মাজে ফেরাউনে আপনারে বার করিয়া হিরবার আগর কামো লাগাইবা। আপনে হিরবার আগর লাখান ফেরাউনর আতো পিয়ালা তুলি দিবা। ");
INSERT INTO syl_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","অইলে আপনারে মিনতি করি কইয়ার, আপনার ভালাই অওয়ার বাদে আমারে মনো করবা আর দয়া করি ফেরাউনর গেছে আমার কথা কইয়া, ই জেলখানা থনে আমারে খালাছ করাইবা। ");
INSERT INTO syl_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ইবরানি অকলর দেশ থনে আমারে জুর করি ধরিয়া আনা অইছে। আর অনো আইয়াও আমি জেল খাটার মত এমন কুন্তা করছি না।” ");
INSERT INTO syl_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","বাদে হি রুটি বানাওরায় যেবলা দেখলো যেন, শরাব বিলাওরার খোয়াবর মানি ভালা আছে, তেউ হে ইউছুফরে কইলো, “আমিও খোয়াবে দেখছি, দেখলাম যেন আমার মাথাত তিন টুকরি ময়দার রুটি লইছি। ");
INSERT INTO syl_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","আর উপরর টুকরিত আছিল, ফেরাউনর লাগি বউত জাতর পিঠা; তেউ পাখি অকলে আইয়া, আমার মাথার উপরর টুকরি থাকি ইতা খাইলিরা।” ");
INSERT INTO syl_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","ইউছুফে জুয়াপ দিলা, “ই স্বপনর তাবির অইলো, তিন টুকরি মানি তিন দিন। ");
INSERT INTO syl_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","অউ তিন দিনর মাজে, ফেরাউনে আপনার ধড় থনে কল্লা আলগাইয়া, গাছর মাজে লটকাইবা, হেশে পাখিন্তে আইয়া আপনার ধড়র গোস্ত খাইবা।” ");
INSERT INTO syl_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","এর তিন দিনর দিন ফেরাউনর জনম দিন আছিল। ফেরাউনে তান দরবারর হকল মানষর লাগি, খানি তিয়ার করাইলা। আর হউ রুটি বানাওরা আর শরাব বিলাওরা দুইওজনরে আনাইয়া তান দরবারর ছামনে আজির করলা। ");
INSERT INTO syl_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","তাইন শরাব বিলাওরারে হিরবার তান কামো লাগাইলা, হে ফেরাউনর আতো হিরবার পিয়ালা তুলিয়া দিলো। ");
INSERT INTO syl_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","অইলে রুটি বানাওরারে গাছো লটকাইলা। ইউছুফে যেলা কইছলা, এক্কেরে অউলা অইলো। ");
INSERT INTO syl_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","তা-ও ইউছুফর কথা হি শরাব বিলাওরার ইয়াদ রইলো না, হে ফাউরিলিলো। ");
INSERT INTO syl_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","এর পুরা দুই বরছ বাদে ফেরাউনে খোয়াবে দেখলা। তাইন দেখলা, নীল নদর গেছে তাইন উবাই রইছইন, ");
INSERT INTO syl_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","আর নীল নদ থনে সাতগু সুন্দর তরতাজা গরু উঠিয়া আইয়া নল বনর মাজে আটিয়া খাইরা। ");
INSERT INTO syl_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","এরবাদে দেখইন, আরো সাতগু হালাক আর খবিছর লাখান গরু উঠিয়া আইয়া, নীল নদর পারর হউ গরুইন্তর কাছাত উবাইলো। ");
INSERT INTO syl_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","হেশে অউ হালাক আর খবিছর লাখান গরুইন্তে হউ সুন্দর আর তরতাজা সাতো গরুরে খাইলিলো, তেউ ফেরাউনর ঘুম ভাংগি গেল। ");
INSERT INTO syl_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","বাদে তাইন হিরবার ঘুমাইলা আর দুয়ারা খোয়াবে দেখলা, এক গমর ডেটাত সাতগু পুষ্ট আর তাজা ছড়া বার অইছে। ");
INSERT INTO syl_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","হেশে বার অইলো, পুবালি বাতাসর গরমে হুকনা সাতগু কম পুষ্ট ছুছাআলা ছড়া, ");
INSERT INTO syl_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","আর অউ কম পুষ্ট ছড়ায় হউ সাতো পুষ্ট-তাজা ছড়ারে গিলিলাইলো। বাদে ফেরাউনর ঘুম ভাংগি গেল, তাইন বুজলা যেন ইতা তো খোয়াব। ");
INSERT INTO syl_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","বিয়ানে তান মন অস্থির অইগেল, তেউ মিসর দেশর হকল যাদুগির আর পন্ডিতরে খবরিয়াদি আনাইয়া, তান খোয়াব তারারে হুনাইলা, অইলে এরার কেউ এর তাবির কইতো পারলো না। ");
INSERT INTO syl_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","হেশে ফেরাউনর হউ শরাব বিলাওরায় কইলো, “হুজুর, আইজ আমার এক দুষ মনো অইছে। ");
INSERT INTO syl_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","বউত দিন আগে হুজুরে নিজর দুই গুলামর উপরে গুছা করছলা, তাইন আমারে আর রুটি বানাওরারে বড় জেলার ছাবর বাড়ির জেলো থইছলা। ");
INSERT INTO syl_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","আর এক রাইতে আমরা দুইওজনে আলগ আলগ খোয়াব দেখলাম, দুইও খোয়াবর দুই লাখান তাবির আছিল। ");
INSERT INTO syl_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","ই সময় জেলার ছাবর, এক ইবরানি জুয়ান গুলামও অনো আছিল। তারে আমরার খোয়াবর কথা হুনাইলাম, আর হে আমরার খোয়াবর তাবির কইয়া দিলো। ");
INSERT INTO syl_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","হে আমরার খোয়াবর তাবির যেলা কইছিল, এক্কেরে অউ লাখানউ ফলিলো। হুজুরে আমারে হিরবার তান কামো লাগাইলা, অইলে রুটি বানাওরারে গাছো লটকাইলা।” ");
INSERT INTO syl_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","অউ ফেরাউনে ইউছুফরে আনার লাগি মানুষ পাঠাইলা, তারা গিয়া জলদি করি জেলখানা থনে তানরে বার করি আনলা। ইউছুফে দাড়ি-মুছ কামাইয়া, কাপড় বদলাইয়া ফেরাউনর দরবারো আজির অইলা। ");
INSERT INTO syl_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ফেরাউনে তানরে কইলা, “আমি একখান খোয়াব দেখছি, অইলে এর তাবির কেউ কইতো পারের না। তে আমি হুনলাম যেন তুমার গেছে খোয়াব হুনাইলে, তুমি এর তাবির কইতায় পারো।” ");
INSERT INTO syl_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","ইউছুফে জুয়াপ দিলা, “হি খেমতা তো আমার নায়, আল্লা পাকে মহারাজর দিলর শান্তির জুয়াপ বাতাইয়া দিবা নে।” ");
INSERT INTO syl_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","ফেরাউনে ইউছুফরে কইলা, “খোয়াবে দেখলাম, আমি নীল নদর পারো উবাই রইছি। ");
INSERT INTO syl_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","আর দেখি, গাংগো থনে সাতগু সুন্দর, তরতাজা গরু উঠিয়া আইয়া নল বনর মাজে আটিয়া খাইরা। ");
INSERT INTO syl_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","এরবাদে আরো সাতগু গরু উঠিয়া আইলো। ইতা হালাক আর খবিছর লাখান, মিসর দেশর কুনু খানো ইলাখান বে-ছুরত গরু কুনু দিনও দেখছি না। ");
INSERT INTO syl_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","বাদে অউ হালাক আর বে-ছুরত গরুইন্তে, আগর হি সাতো তরতাজা গরুরে খাইলিলো। ");
INSERT INTO syl_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","অইলে তারা ইতারে গিলার বাদে, খাইছে করি বুজাও গেলো না, কারন তারা আগর লাখানউ হালাক আর বে-ছুরত রইলো। হেশে আমার ঘুম ভাংগি গেল। ");
INSERT INTO syl_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","বাদে আমি হিরবার দেখলাম, গমর এক ডেটার মাজে সাতগু বড় আর পুষ্ট ছড়া বার অইলো। ");
INSERT INTO syl_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","পুবালি হাওয়ার গরমে হুকনা সাতগু কম পুষ্ট ছুছাআলা ছড়াও বার অইলো। ");
INSERT INTO syl_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","আর অউ সাতো ছড়ায়, হউ তাজা সাতো ছড়ারে গিলিলিলো। ই খোয়াব আমি যাদুগির অকলরে হুনাইছলাম, অইলে কেউ এর মানি কইতো পারছে না।” ");
INSERT INTO syl_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","ইউছুফে ফেরাউনরে কইলা, “হুজুর, ই দুইও খোয়াবউ আদতে এক। আল্লায় যেতা করতা চাইরা, ইতা আপনারে দেখাইছইন। ");
INSERT INTO syl_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","অউ তরতাজা সাতো গরুর মানি সাত বরছ, আর পুষ্ট সাতো গমর ছড়ার মানিও সাত বরছ। দুইও খোয়াবউ এক। ");
INSERT INTO syl_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","আর হেশে উঠিয়া আওয়া সাতো হালাক আর বে-ছুরত গরু, আর পুবালি হাওয়ার গরমে হুকনা সাতো গমর ছড়া, এরার মানি অইলো, আকালর সাত বরছ। ");
INSERT INTO syl_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","তে আল্লায় যেতা করতা চাইরা, ইতা মহারাজরে দেখাইছইন। অউ কথাউ আমি আপনারে আগে কইছি। ");
INSERT INTO syl_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","হুনউক্কা, হারা মিসর দেশো সাত বরছ খুব বেশি ফসল ফলিবো। ");
INSERT INTO syl_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","এরবাদেউ আইবো আকালর সাত বরছ। তেউ আগর হি বেশি ফসলর কথা মানষে ফাউরিলিবা, আর আকালে দেশরে শেষ করি দিবো। ");
INSERT INTO syl_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","অউ আকালর দরুন, আগর হি ফসলর কথা মানষর মনো রইতো নায়। ই আকাল অইবো খুব বেজুইতা মছিবতর। ");
INSERT INTO syl_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","ই খোয়াব আপনারে দুইবার দেখানির মানি অইলো, আল্লায় ই দশা ঘটাইবা, এক্কেরে ঠিক করিলাইছইন, ইতা খুব জলদি করিউ ঘটিবো। ");
INSERT INTO syl_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","অখন হুজুরে একজন চতুর-বুজদার পন্ডিত মানষরে তুকাইয়া, এন গেছে মিসররে সপি দেউক্কা। ");
INSERT INTO syl_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","আর আপনে অউলা করউক্কা, দেশো আপনার কর্মচারি লাগাইন, অউ সাত বছরে যেবলা খুব বেশি ফসল ফলবো, ই সময় তারা এর পাচ বাটর একবাট দলা করবা। ");
INSERT INTO syl_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","তারা অউ সুদিনর বছরর ধান দলা করিয়া হুজুরর দখলে, বাজারে বাজারে গুদামো ভরিয়া থউক আর হেফাজত করউক। ");
INSERT INTO syl_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","সাত বরছ ধরি মিসরো যে আকাল অইবো, হউ আকালর লাগি ধান জমাইয়া রাখবা, তেউ আকালে দেশর মানুষ মরতা নায়।” ");
INSERT INTO syl_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ইউছুফর ই মাত, ফেরাউন আর তান দরবারর হকলর গেছে খুব ভালা মনো অইলো। ");
INSERT INTO syl_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ফেরাউনে তান উজির-নাজির অকলরে কইলা, “ই বেচাড়ার লাখান আল্লার রুহআলা মানুষ আমি কুয়াই তুকাইয়া পাইমু?” ");
INSERT INTO syl_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","অউ ফেরাউনে ইউছুফরে কইলা, “আল্লায় যেবলা তুমার গেছে ইতা হক্কলতা জাইর করছইন, তে তুমার লাখান বুজদার আর বিবেকমান তো আর কেউ নায়। ");
INSERT INTO syl_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","অখন রাজবাড়ির হক্কলতা তুমিউ চালাইবায়। আমার হকল প্রজা তুমার হুকমে চলবা। খালি বাদশার তখতো, আমি তুমার উপরে থাকমু।” ");
INSERT INTO syl_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","তাইন ইউছুফরে কইলা, “হুনো, আমি আস্তা মিসর দেশ তুমার আতো সপি দিলাম।” ");
INSERT INTO syl_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","আর ফেরাউনে নিজর আংগুইল থাকি বাদশাই সীলর আংটি খুলিয়া ইউছুফর আতো ফিন্দাইলা, তান গলাত সোনার হার দিলা আর দামি কাপড়র সাদা লেবাছও ফিন্দাইলা। ");
INSERT INTO syl_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","বাদে তাইন ইউছুফরে তান রাইজ্যর দুই নম্বর রথর মাজে তুললা আর ইউছুফর আগে আগে এলান করা অইলো, “পরনাম করো! পরনাম করো!” অউ লাখান তাইন ইউছুফর উপরে আস্তা মিসর দেশর ভার সমজাই দিলা। ");
INSERT INTO syl_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ফেরাউনে ইউছুফরে কইলা, “আমিউ ফেরাউন, মিসরর বাদশা! অইলে তুমার হুকুম ছাড়া, আস্তা মিসর দেশো কেউ রুমাও লাড়াইতো পারতো নায়।” ");
INSERT INTO syl_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ফেরাউনে ইউছুফর নয়া নাম রাখলা, সাফনথ-পানেহ। তাইন অউন মন্দিরর বাবন-ঠাকুর পোটিফেরার পুড়ি আসনতরে ইউছুফর লগে বিয়া দিলা আর ইউছুফে আস্তা মিসর দেশো ঘুরাঘুরি করাত লাগলা। ");
INSERT INTO syl_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","ইউছুফে তিশ বরছ বয়সো, মিসরর বাদশা ফেরাউনর কামো লাগলা, তাইন ফেরাউনর দরবার থনে বার অইয়া দেশর হকল জাগা ছফর করলা। ");
INSERT INTO syl_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","আর বেশি ফসলর অউ সাত বছরে দেশো বউত ফসল ফলিলো। ");
INSERT INTO syl_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","তেউ ইউছুফে ই সুদিনর সাত বছরে মিসরর হকল ধান, বাজারর গুদাম ঘরাইন্তো জমা করাইয়া থইলা। তাইন হক্কল বাজারর চাইরো গালার ধান অকল, হউ বাজারর গুদামো জমাইলা। ");
INSERT INTO syl_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","তাইন দরিয়ার বালুর লাখান অউলা বেহিসাব ধান দলা করলা যেন, ইতা আর মাপিয়া ফুড়াইতা পারলা না, তেউ মাপা-মাপি করা বাদ দিলাইলা। ");
INSERT INTO syl_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","আর আকালর আগে অউন মন্দিরর বাবন-ঠাকুর, পোটিফেরার পুড়ি আসনতর পেটো ইউছুফর দুই পুয়া অইলা। ");
INSERT INTO syl_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","ইউছুফে তান বড় পুয়ার নাম রাখলা মানশা মানি, ফাউরিলাওয়া। তাইন কইলা, “আল্লায় আমার হকল তকলিফ আর বাফর বাড়ির হক্কলতা, আমার দিল থনে ফাউরাইলা।” ");
INSERT INTO syl_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","বাদে তান দুছরা পুয়ার নাম রাখলা আফরাইম মানি, ফলদার। তাইন কইলা, “আমি যে দেশো তকলিফ পাইছি, হউ দেশোউ আল্লায় আমারে ফলদার বানাইলা।” ");
INSERT INTO syl_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","আর মিসর দেশর খুব বেশি ফসলর হি সাত বরছ পুরিগেল। ");
INSERT INTO syl_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","তেউ ইউছুফে যেলা কইছলা, অউলা আকালর হউ সাত বরছ আইয়া আজিলো। এর লগে কান্দা-কাছার হকল দেশোও নিদান দেখা দিলো অইলে মিসরর কুনু জাগাত খানি-খুরাকির অভাব অইলো না। ");
INSERT INTO syl_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","হেশে আস্তা মিসর দেশো আকাল দেখা দিলে, প্রজা অকলে আইয়া ফেরাউনর গেছে খানি মাগিলা, তেউ ফেরাউনে কইলা, “তুমরা ইউছুফর গেছে যাও। এইন যেলা কইন, ঠিকউ অউলা করো।” ");
INSERT INTO syl_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","ই আকাল আস্তা দেশ জুড়ি দেখা দিলো। বাদে আরো বেজুইতা অওয়ায় ইউছুফে হকল জাগার গুদাম ঘরাইন খুলিয়া, মিসরী অকলর গেছে ধান বেচাত লাগলা। ");
INSERT INTO syl_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","আস্তা দুনিয়াইত নিদান দেখা দিলো আর হকল দেশর মানষে ধান খরিদ করার লাগি মিসর দেশো ইউছুফর গেছে আইলা। ");
INSERT INTO syl_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","ইয়াকুবেও হুনলা মিসর দেশো ধান আছে, অউ তান পুয়াইন্তরে কইলা, “তুমরা এগুয়ে আরগুর মুখর বায় চাই রইছো কেনে? ");
INSERT INTO syl_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","হুনো, আমি হুনছি, মিসর দেশো ধান আছে, তুমরা হনো গিয়া আমরার লাগি কিছু ধান লইয়া আনো, তেউ আমরা ই মরন থাকিয়া জানে বাচমু।” ");
INSERT INTO syl_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","অউ ইউছুফর দশো ভাইয়ে ধান লইয়া আনার লাগি মিসরো গেলা। ");
INSERT INTO syl_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","অইলে ইয়াকুবে ইউছুফর আপন মাʼর পেটর ভাই বিন-ইয়ামিনরে তারার লগে যাইতে দিলা না, তাইন কইলা, এর কুনু বিপদ অইযিতো পারে। ");
INSERT INTO syl_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","ধান খরিদর লাগি কেনান দেশ থাকি যেরা মিসরো গেল, ইছরাইলর পুয়াইনও তারার দলর লগো অইয়া গেলা, কারন কেনান দেশোও আকাল আছিল। ");
INSERT INTO syl_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","ই সময় ইউছুফউ আছলা মিসর দেশর হক্কলতার মালিক। দেশর হকল মানষর গেছে তাইনউ ধান বেচতা। তেউ ইউছুফর ভাইয়াইনও তান গেছে গিয়া, তারা মাথারে মাটিত লাগাইয়া তানরে ইজ্জত করলা। ");
INSERT INTO syl_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","ইউছুফে তান ভাইয়াইন্তরে দেখিয়াউ চিনিলিলা, অইলে না চিনার ভান করিয়া, তাইন খুব কড়া গলায় তারারে জিকাইলা, “তুমরা কুয়াই থাকি আইছো?” তারা কইলা, “আমরা কেনান দেশ থনে আইছি, ধান নিবার লাগি।” ");
INSERT INTO syl_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","ইউছুফে তান ভাইয়াইনরে হাছারর চিনলেও, ভাইয়াইন্তে তানরে চিনলা না। ");
INSERT INTO syl_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","তাইন এরারে লইয়া খোয়াবে যেতা দেখছলা, হউ কথা তান মনো অইলো। অউ তাইন এরারে কইলা, “তুমরা তো গুইয়া! আমরার দেশর ফাক-ফুকর অতা দেখাত আইছো।” ");
INSERT INTO syl_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","তারা কইলা, “জি না হুজুর, আপনার ই গুলাম অকলে খালি ধান লওয়াত আইছি। ");
INSERT INTO syl_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","আমরা তো হকল এক বাফর আওলাদ আর ছাইচ্চা মানুষ; আপনার ই গুলাম অকল কুনু গুইয়া নায়।” ");
INSERT INTO syl_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","ইউছুফে হিরবার তারারে কইলা, “না, না, তুমরা আমার দেশর ফাক-ফুকর দেখাত আইছো।” ");
INSERT INTO syl_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","তারা কইলা, “আপনার গুলাম অকল, হকলে মিলিয়া বারো ভাই। আমরা কেনান দেশর এক বাফর আওলাদ। আমরার হুরু ভাই অখন বাবার গেছে রইছে, আর আরক ভাই নায়।” ");
INSERT INTO syl_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","ইউছুফে তারারে কইলা, “না, না, আমি ঠিকউ কইছি, তুমরা গুইয়াউ! ");
INSERT INTO syl_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","তে তুমরার পরিক্ষা অলাউ অইযাউক: আমি ফেরাউনর জানর কছম করি কইয়ার, তুমরার হুরু ভাই অনো না আইলে, তুমরাও ইন থনে ছাড়া পাইতায় নায়। ");
INSERT INTO syl_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","তুমরার একজনরে পাঠাইয়া, তুমরার হউ ভাইরে আনাও আর বাকি হকলে বন্দি রও। অউ পরিক্ষায় তুমরার মাতর হাছা-মিছা বুজমু। তারে না আনলে, আমি ফেরাউনর জানর কছম করি কইয়ার, তুমরা নিচয় গুইয়া!” ");
INSERT INTO syl_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","আর ইউছুফে তিন দিন তারারে আজত খানাত বন্দি করি থইলা। ");
INSERT INTO syl_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","হেশে তিন দিনর দিন, ইউছুফে তারারে কইলা, “হুনো, আমি তো আল্লারে ডরাই, তুমরা বাচতে চাইলে, আমি যেলা কই, অউলা করো। ");
INSERT INTO syl_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","তুমরা হাছারর ছাইচ্চা মানুষ অইলে, তুমরার এক ভাই আজতো থাকউক আর বাকি হকলে তুমরার আকালি পরিবারর লাগি ধান লইয়া যাওগি। ");
INSERT INTO syl_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","তুমরার মাত হাছা কি না ইটা বুজার লাগি, তুমরার হুরু ভাইরে আমার গেছে লইয়া আইও। তেউ তুমরা মরতায় নায়।” অউ তারাও রাজি অইলা। ");
INSERT INTO syl_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","বাদে তারা মাতা-মাতি করলা, “হাছাউ তো, আমরার হি ভাইর লগে যেতা করছি ইতা অইন্যায়। হে আমরার গেছে কাজ-মিনতি করলেও, আমরা তার মাতো কান দিছি না। এরলাগি আমরার উপরে ই মছিবত আইছে।” ");
INSERT INTO syl_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","তেউ রুবেনে তারারে কইলা, “আমি তো তুমরারে কইছলাম, তার উপরে কুনু জুলুম করিও না, তুমরা হুনলায় না। দেখো, অখন তার লউর হিসাব-নিকাশ দিতে অর।” ");
INSERT INTO syl_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","অইলে ইউছুফে যেন তারার মাত বুজরা, ইতা তারা জানলো না। কারন তাইন মাত বুজাওরা একজনরে মাজে রাখিয়া, তারার লগে মাততা। ");
INSERT INTO syl_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","তেউ ইউছুফে তারার গেছ থনে হরিয়া গিয়া কান্দিতা লাগলা। বাদে হিরবার আইয়া তারার লগে মাতিলা আর তাইন শিমিয়নরে ধরিয়া তারার ছামনেউ বান্দাইল্লা। ");
INSERT INTO syl_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","বাদে ইউছুফে তারার বস্তার মাজে ধান ভরাইয়া, যারযির টেকা তার বস্তাত ফিরাই দিয়া, এরার পথর খানির মছা দেওয়ার লাগি হুকুম দিলা। আর অউলা করা অইলো। ");
INSERT INTO syl_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","হেশে তারা যারযির গাধার পিঠিত ধানর গাইট বান্দিয়া রওয়ানা অইলা। ");
INSERT INTO syl_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","পথো জিরানির জাগাত গিয়া যেবলা একজনে গাধারে খাওয়ানির লাগি বস্তা খুললো, আর দেখলো, বস্তার মুখো তার টেকার খুতি। ");
INSERT INTO syl_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","অউ হে তার ভাইয়াইনরে কইলো, “দেখো, দেখো, আমার টেকা আমার বস্তাত ফিরত দেওয়া অইছে।” দেখিয়াউ তারার জান উড়ি গেল আর ডরাইয়া কাপতে কাপতে কইলো, “আল্লায় আমরারে ইতা কিতা করলা?” ");
INSERT INTO syl_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","বাদে কেনান দেশো গিয়া তারার বাফ ইয়াকুবর গেছে আজির অইয়া, ইতা হকলতা হুনাইয়া কইলা, ");
INSERT INTO syl_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“হি দেশর মালিকে, আমরারে খুব কড়া গলায় কইছইন, আমরা গুইয়া অইয়া হি দেশো গেছি। ");
INSERT INTO syl_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","আমরা কইছি, আমরা হক মানুষ, কুনু গুইয়া নায়। ");
INSERT INTO syl_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","আমরা বারোজন ভাই, এক বাফর বারো পুয়া, অইলে আমরার একজন নায় আর হকল থনে হুরু ভাই অখন কেনান দেশো বাবার গেছে রইছে। ");
INSERT INTO syl_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","অউ হি মানষে, যেইন হি দেশর মালিক, তাইন আমরারে কইলা, ‘আমি অউলা বুজমু যেন, তুমরা হক মানুষ। তুমরার এক ভাইরে আমার গেছে থইয়া, তুমরার আকালি পরিবারর লাগি ধান লইয়া যাও। ");
INSERT INTO syl_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","আর তুমরার হুরু ভাইরে আমার গেছে লইয়া আইও। তেউ আমি বুজমু, তুমরা হক মানুষ, কুনু গুইয়া নায়। বাদে আমি তুমরার ভাইরে ফিরাই দিমু আর তুমরা ই দেশো কায়-কারবার করতায় পারবায়।’ ” ");
INSERT INTO syl_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","বাদে তারা বস্তা থনে ধান ঢালতেউ দেখইন, তারার হকলর টেকার খুতি বস্তার মাজে রইছে। ইতা দেখিয়া তারার বাফে আর তারাও ডরাইগেলা। ");
INSERT INTO syl_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","তেউ বাফে তারারে কইলা, “তুমরা আমারে আওলাদ ছাড়া বানাইছো। ইউছুফ নায়, শিমিয়নও নায় আর অখন তুমরা হিরবার বিন-ইয়ামিনরেও নিতায় চাইরায়। ইতা হকলতাউ আমার জুলুম।” ");
INSERT INTO syl_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","রুবেনে তান বাফরে কইলা, “আমি বিন-ইয়ামিনরে তুমার গেছে ফিরাইয়া আনতে না পারলে, তুমি আমার দুইও পুয়ারে খুন করিলিও। তারে তুমি আমার আতো ছাড়ি দেও, আমি তারে তুমার গেছে ফিরাইয়া আনমু।” ");
INSERT INTO syl_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","ইয়াকুবে কইলা, “না, আমার ই পুয়া তুমরার লগে দিতাম নায়। তার ভাই মরিগেছে, আর অখন হে একলা জিতা আছে। তুমরার যাওয়ার পথো যুদি তার কুনু বিপদ অয়, তে অউ পাকনা চুলে বউত দুখ দিয়া তুমরা আমারে কয়বরো হারাইবায়।” ");
INSERT INTO syl_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","কেনান দেশর আকালর দশা আরো বেহাল অইলো। ");
INSERT INTO syl_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","আর মিসর দেশ থনে যেতা ধান নিছলা, ইতা ফুড়াই গেলে ইছরাইলে কইলা, “তুমরা হিরবার গিয়া আমরার লাগি আরো কিছু খানি-খুরাকি লইয়া আনোগি।” ");
INSERT INTO syl_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","তেউ এহুদায় তানরে কইলো, “হউ মানষে আমরারে খুব কড়া ভাষায় কইয়া দিছইন, ‘তুমরার ভাই তুমরার লগে না আইলে তুমরা আর আমার ছামনে আইও না।’ ");
INSERT INTO syl_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","অখন তুমি আমরার ভাইরে আমরার লগে করি দেও, তেউ আমরা গিয়া তুমার লাগি খানি লইয়া আইমু। ");
INSERT INTO syl_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","আর তারে লগে না দিলে আমরাও যাইতাম নায়। হি মানষে আমরারে কইয়া দিছইন, ‘তুমরার ভাইরে লগে না আনলে, তুমরা আর আমার ছামনে আইও না।’ ” ");
INSERT INTO syl_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","ইছরাইলে কইলা, “তুমরা কেনে আমার লগে অউলা ফাতরামি করলায়? তুমরার আরক ভাই আছে, ইতা তানরে কেনে কইলায়?” ");
INSERT INTO syl_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","তারা কইলা, “হি মানষে আমরার আর আমরার পরিবারর আগা-গুড়ি হক্কলতা জিকাইছইন, ‘তুমরার বাফ কিতা অখনও জিন্দা আছইন নি? তুমরার আর কুনু ভাই আছইন নি?’ আমরা খালি তান ছওয়ালর জুয়াপ দিছলাম, আমরা কুনু জানতাম নি, তাইন কইবা তুমরার ভাইরেও লইয়া আইও?” ");
INSERT INTO syl_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","এহুদায় তান বাফরে কইলা, “তারে আমার লগে করি দিলাও, আমরা জলদি জলদি রওয়ানা অইযাই, তেউ তুমি, আমরা আর আমরার হুরুতাইন হক্কলউ জানে বাচমু, কেউ মরতাম নায়। ");
INSERT INTO syl_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","আমি নিজেউ তার লাগি জামিন রইলাম, তারে আমার গেছ থনে সমজিয়া নিও। আমি তারে তুমার গেছে ফিরাইয়া না আনলে, তুমার গেছে আজির না করলে, হারা জিন্দেগি ভরা আমি তুমার গেছে দায়ী রইমু। ");
INSERT INTO syl_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","আর অতো দেরি না করলে, আমরা অতদিনে দুইবার ঘুরিয়া আইতাম পারলাম অনে।” ");
INSERT INTO syl_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","অউ তারার বাফ ইছরাইলে কইলা, “অউলা অইলে এক কাম করো, তুমরা যারযির বেগর মাজে অনর ভালা ভালা মাল, আগর, মউ, খুশবয় মশলা, মেশকে-আম্বর, পেস্তা আর বাদাম ভরিয়া হউ মানষর লাগি ছালামি লইয়া যাও। ");
INSERT INTO syl_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","আর তুমরার লগে করি আগর ডাবুল টেকা নেও, বস্তার মুখো যে টেকা ফিরত আইছে, তা-ও হিরবার লইয়া যাও, কি জানি কুনু ভুল অইগেছিল। ");
INSERT INTO syl_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","তুমরার ই ভাইরে লগে লইয়া, জলদি করি হউ মানষর গেছে যাও। ");
INSERT INTO syl_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","সর্ব-শক্তিমান আল্লায় তুমরার লাগি হউ মানষর দিলো মেহেরবানি পয়দা করউক্কা, যাতে তাইন তুমরার হউ ভাই আর বিন-ইয়ামিনরে তুমরার আতো ফিরত দেইন। আর আমার পুয়া খুয়ানি গেলে, না অয় গেলোউ।” ");
INSERT INTO syl_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","তেউ তারা হউ ছালামি, ডাবুল টেকা আর বিন-ইয়ামিনরে লইয়া রওয়ানা অইয়া, মিসর দেশো পৌছিয়া ইউছুফর ছামনে আজির অইলা। ");
INSERT INTO syl_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","তারার লগে বিন-ইয়ামিনরে দেখিয়া ইউছুফে তান বাড়ির খাদিমরে কইলা, “অউ মানুষ অকলরে বাড়ির ভিতরে নেও আর খসি জবো করিয়া গোস্ত রান্দো। তারা মাধানে আমার লগে খাইবা।” ");
INSERT INTO syl_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ইউছুফে যেলা কইলা, খাদিমেও ঠিক অউলা করলো, হে এরারে বাড়ির ভিতরে লইয়া গেল। ");
INSERT INTO syl_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","আর হে এরারে ইউছুফর বাড়ির ভিতরে নেওয়ায়, তারা ডরাইয়া মাতা-মাতি করলা, “আগর ফিরা যে টেকা আমরার বস্তাত করি ফিরত গেছিল, অতার লাগিউ আমরারে অনো নিরা, অখন আমরার দুষ দেখাইয়া মাইর-ধইর করিয়া আমরারে গুলাম বানাইবা, আর গাধা অকলও কাড়িয়া নিবা।” ");
INSERT INTO syl_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","তেউ ইউছুফর বাড়ির দরজার ছামনে আইয়া তারা বাড়ির খাদিমরে কইলা, ");
INSERT INTO syl_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“হুজুর, আমরা এর আগেও ধান লওয়াত আইছলাম, ");
INSERT INTO syl_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","হেশে ফিরত যাওয়ার বালা, দম লইবার জাগাত পৌছিয়া, বস্তা খুলতেউ দেখি, আমরার পুরা টেকা-পয়সা যারযির বস্তার মুখো রইছে, অখন অউ টেকা ফিরত আনছি। ");
INSERT INTO syl_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","আর ধান নেওয়ার লাগি আরো টেকা আনছি, অইলে হি টেকা আমরার বস্তার ভিতরে কে থইছিল জানি না।” ");
INSERT INTO syl_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","অউ খাদিমে কইলো, “তুমরার ভালাই অউক, ডরাইও না। তুমরার আর তুমরার বাফর আল্লায়, ই গাইবি ধন তুমরার বস্তার মাজে দিছইন। তুমরার টেকা আমি পাইছি।” বাদে হে শিমিয়নরে বার করিয়া তারার গেছে লইয়া আইলো। ");
INSERT INTO syl_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","হে হকলরে ইউছুফর বাড়ির ভিতরে নিয়া পানি দিলো তারা পাও ধুইলা আর হে তারার গাধা অকলরেও খানি দিলো। ");
INSERT INTO syl_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ইউছুফ মাধানে আইবা গতিকে, এরা তারার ছালামি অকল জুইত করলা। তারা হুনছলা যেন, তান লগেউ তারার খানা-দানা অইবো। ");
INSERT INTO syl_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","বাদে ইউছুফ বাড়িত আইলে, তারার হউ ছালামি অকল ঘরর ভিতরে নিয়া তানরে দিলা, দিয়া হারলে তানরে সইজদা করলা। ");
INSERT INTO syl_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","তারার ভালা-বুরা খবর হুনিয়া তাইন জিকাইলা, “তুমরার যে মুরব্বি বাফর কথা কইছলায়, তাইন ভালা আছইন নি? তাইন জিন্দা আছইন নি?” ");
INSERT INTO syl_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","তারা জুয়াপ দিলা, “জিঅয়, আপনার গুলাম আমরার বাবা অখনও জিন্দা আছইন আর ভালা আছইন।” হেশে তারা মাথা নোয়াইয়া তানরে ইজ্জত করলা। ");
INSERT INTO syl_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","ইউছুফে চউখ তুলিয়া তান নিজর ভাই বিন-ইয়ামিনরে দেখিয়া কইলা, “অউনি তুমরার হউ হুরু ভাই, যার কথা আগে কইছলায়?” তাইন বিন-ইয়ামিনরে কইলা, “আল্লায় তুমারে রহম করউক্কা।” ");
INSERT INTO syl_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","ভাইরে দেখিয়া ইউছুফর দিল কান্দিতো লাগলো। তাইন জলদি করি বার অইয়া, নিজর কুঠাত গিয়া কান্দিলা। ");
INSERT INTO syl_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","বাদে চউখ-মুখ ধইয়া বার অইয়া আইলা আর নিজরে সামলাইয়া খানি বিলাইবার হুকুম দিলা। ");
INSERT INTO syl_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","অউ ইউছুফরে, তান ভাইয়াইনরে আর তান লগে খানেআলা মিসরী অকলরে আলগ আলগ জাগাত খানি দিলা। কারন মিসরীন্তে ইবরানি অকলর লগে বইয়া খানা-দানা করতো না, ইতা তারা ঘিন করইন। ");
INSERT INTO syl_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","তারা ইউছুফর ছামনে তান ভাইয়াইনরে বড়রে বড়র জাগাত, হুরুরে হুরুর জাগাত বওয়াইলা, তেউ তারা তাইজ্জুব অইয়া একজনে আরক জনর বায় চাই রইলা। ");
INSERT INTO syl_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","আর ইউছুফে নিজর থালর খানি থনে তান ভাইয়াইনরে দেওয়াইলা, অইলে বিন-ইয়ামিনরে হকল থনে পাচ গুন বেশি দেওয়া অইলো। খাইয়া হারলে তারা খুশি অইয়া উঠলা। ");
INSERT INTO syl_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","বাদে ইউছুফে তান বাড়ির খাদিমরে অউ লাখান হুকুম দিলা, “ই মানুষ অকলর বস্তাত যত ধান জাগা অয়, ভরিয়া দিলাও আর যারযির টেকা তার বস্তার মুখো থইও। ");
INSERT INTO syl_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","অইলে অউ হুরু জনর বস্তার মুখো তার টেকার লগে আমার রুপার বাটিও থইও।” ইউছুফে তারে যেলা কইলা, হে অউলা করলো। ");
INSERT INTO syl_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","বাদর দিন বিয়ানেউ তারা গাধা লইয়া বিদায় অইলা। ");
INSERT INTO syl_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","তারা টাউন থাকি থুড়া দুরই যাইতেউ ইউছুফে তান বাড়ির খাদিমরে কইলা, “জলদি করি এরার খরে দৌড়াইয়া গিয়া, এরার লাগাল পাইয়া হারলে কইবায়, তুমরা উপকারর বদলা কেনে খেতি করলায়? আমার মুনিবর রুপার বাটি কেনে চুরি করলায়? ");
INSERT INTO syl_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","অউ বাটিত করিয়া তো তাইন শরবত-পানি খাইন আর তদবিরর কামও করইন। তুমরা ইতা খুব অইন্যায় করছো।” ");
INSERT INTO syl_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","হি খাদিমে তারার খরেদি গিয়া লাগাল পাইয়া অউ লাখান কইলো। ");
INSERT INTO syl_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","অইলে তারা কইলা, “হুজুর ইলা মাত কেনে মাতিরা? আপনার গুলাম অকলে কুনু লাখানউ ইতা কাম করতো নায়। ");
INSERT INTO syl_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","দেখউক্কা, আগরবার আমরার বস্তার মুখো যে টেকা পাইছলাম, ইতা আমরা কেনান দেশ থনে হিরবার আপনার গেছে ফিরত আনছি, তে আমরা কুনু আপনার মুনিবর বাড়ি থনে সোনা-রুপা চুরি করমু নি? ");
INSERT INTO syl_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","আপনার ই গুলাম অকলর মাজে যার গেছে অউ বাটি পাইবা, তারে মারিলাইবা আর আমরাও হুজুরর গুলাম অইযিমু।” ");
INSERT INTO syl_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","তেউ খাদিমে কইলো, “ভালা কথা, তে তুমরা যেলা কইলায়, অউলাউ অউক। যার গেছে অউ বাটি মিলবো, খালি তারে আমার গুলাম বানাইমু আর বাকি হকল খালাছ পাইবায়।” ");
INSERT INTO syl_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","অউ তারা জলদি করি হকলর বস্তা মাটিত লামাইয়া খুললো। ");
INSERT INTO syl_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","আর খাদিমে বড় ভাই থনে হুরু ভাই তরি হকলর বস্তা তুকাইলেও হেশে বিন-ইয়ামিনর বস্তাত হি বাটি মিলল। ");
INSERT INTO syl_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","তেউ তারা যারযির ফিন্নর কাপড় ফাড়িল্লা, বাদে হিরবার গাধার পিঠিত গাইট বান্দিয়া টাউনো আইলো। ");
INSERT INTO syl_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","তেউ এহুদা আর তার ভাইয়াইন ইউছুফর বাড়িত গেলা, ই সময় তাইন হনো আছলা। তারা তান ছামনে গিয়া মাটিত পড়লা। ");
INSERT INTO syl_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","ইউছুফে তারারে কইলা, “তুমরা ইতা কিতা করলায়? আমি যেন হকলতা গনতাম পারি, ইতা তুমরা জানো না নি?” ");
INSERT INTO syl_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","এহুদায় কইলো, “হুজুরর গেছে আমরা কিতা কইমু? কিতা জুয়াপ দিমু? আর কিলা আমরারে বে-কছুর কইতাম? আল্লায়উ তান গুলাম অকলর দুষ দেখাই দিছইন, তে যার গেছে ই বাটি মিলছে, হে আর আমরা হকলেউ হুজুরর গুলাম অইলাম।” ");
INSERT INTO syl_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","অইলে ইউছুফে কইলা, “না, না, আমি ই কাম কুনু লাখানউ করতাম নায়। যার গেছে অউ বাটি মিলছে, হে-উ আমার গুলাম অইবো, বাকি সব ছহি-ছালামতে তুমরার বাফর গেছে যাওগি।” ");
INSERT INTO syl_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","তেউ এহুদায় ইউছুফর কাছাত গিয়া কইলো, “হুজুর আপনে তো ফেরাউনর হমান, তে দয়া করি আপনার গুলামরে একখান মাত মাতার সুযোগ দেউক্কা। আপনার গুলামর উপরে গুছা অইন না যেন। ");
INSERT INTO syl_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","হুজুরে আগে ই গুলাম অকলরে জিকাইছলা, তুমরার বাফ বা কুনু ভাই আছইন নি। ");
INSERT INTO syl_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","আমরা জুয়াপ দিছলাম, আমরার মুরব্বি বাবা জিন্দা আছইন, আর তান হেশকালি বয়সর এগু পুয়া আছে। তার ভাই মরিগেছে, আর হে এক মাʼর এক পুত গতিকে বাবায় তারে খুব মায়া করইন। ");
INSERT INTO syl_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","বাদে আপনার ই গুলাম অকলরে কইছলা, তারে আমার গেছে লইয়া আইও, আমি তারে নিজর চউখে দেখমু। ");
INSERT INTO syl_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","হি সময় আমরা হুজুররে কইছলাম, বাবারে থইয়া হে আইতো পারতো নায় আর থইয়া আইলেও বাবা মারা যাইবা। ");
INSERT INTO syl_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","অইলে আপনে ই গুলাম অকলরে কইছলা, তুমরার হুরু ভাইরে লগে না আনলে, তুমরা আর আমার ছামনে আইও না। ");
INSERT INTO syl_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","এরলাগি আমরা ফিরিয়া গিয়া আপনার গুলাম, আমরার বাবারে হুজুরর হকল কথা হুনাইছলাম। ");
INSERT INTO syl_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","বাদে বাবায় কইলা, তুমরা হিরবার গিয়া আমরার লাগি আরো থুড়া ধান লইয়া আনোগি। ");
INSERT INTO syl_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","তেউ আমরা কইলাম, আমরার হুরু ভাইরে লগে দিলে আমরা যাইমু, আরনায় আমরা গিয়া হি মানষর ছামনে মুখ দেখাইতাম নায়। ");
INSERT INTO syl_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","অউ আপনার গুলাম, আমরার বাবায় কইলা, তুমরা তো জানো, আমার ই বিবির তরফা দুগু পুয়া আছিল। ");
INSERT INTO syl_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","এরার একজন আমার চখুর ছামন থাকি বার অইয়া গেল, আর তো কুনুদিন তারে দেখলাম না, আমি বুজলাম যেন, নিচয় কুনু জানুয়ারে তারে ছিড়ি-বিড়িলাইছে। ");
INSERT INTO syl_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","অখন তুমরা এরেও আমার গেছ থনে নিলেগি আর এর কুনু খেতি অইলে, তার দুখে তুমরা আমারে অউ পাকনা চুলে কয়বরো হারাইবায়। ");
INSERT INTO syl_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","এরলাগি অখন যুদি আপনার গুলাম, আমার বাবার গেছে আমি যাই আর তান ই পুয়ারে লগে না দেখইন, তে এর জানর লগে তান জান একখানো বান্দা গতিকে, ");
INSERT INTO syl_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","তারে না দেখলে, তাইন নিচয় মারা যাইবা। আপনার গুলাম, আমরার মুরব্বি বাফ বউত দুখে পাকনা চুল লইয়া কয়বরো হামাইবা। ");
INSERT INTO syl_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","আর আপনার গুলাম আমি, আমার বাবার গেছে তার লাগি জামিন অইয়া কইছি যেন, তারে ফিরাইয়া আনতে না পারলে, হারা জিন্দেগি ভরা আমি তুমার গেছে দাবিত রইমু। ");
INSERT INTO syl_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","তে হুজুর আমি মিনতি করিয়ার, তার বদলা আমি আপনার গুলামি করমু আর তারে আপনে এরার লগে যাইবার দিলাউক্কা। ");
INSERT INTO syl_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","এরে লগে না নিয়া আমি কিলা বাবার গেছে যাইমু? নাইলে বাবার জানর সর্বনাশ আমার নিজর চউখে দেখন লাগবো।” ");
INSERT INTO syl_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","ইউছুফে তান কর্মচারি অকলর ছামনে নিজরে আর ঠিক রাখতা পারলা না, তাইন চিল্লাইয়া কইলা, “আমার গেছ থনে হক্কল হরি যাও!” তেউ ভাইয়াইন্তর গেছে নিজর পরিচয় দেওয়ার সময় তান ছামনে আর কেউ রইলো না। ");
INSERT INTO syl_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","তাইন চিল্লাইয়া কান্দন শুরু করলা, তেউ মিসরী অকলে ইতা হুনলা আর ফেরাউনর বাড়ির মানষেও ই খবর পাইলা। ");
INSERT INTO syl_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","ইউছুফে তান ভাইয়াইন্তরে কইলা, “আমি ইউছুফ; আমার বাবা অখনও জিন্দা আছইন নি?” অউ তান ভাইয়াইন্তে ডরাইয়া জবান বন্দ অইগেল, মাততা পারলা না। ");
INSERT INTO syl_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","তেউ ইউছুফে তান ভাইয়াইনরে কইলা, “তুমরা আমার কাছাত আও।” তারা কাছাত আইলে তাইন কইলা, “আমি তুমরার হউ ভাই ইউছুফ, মিসরো যাওরা বেপারি অকলর গেছে, তুমরা যারে বেচিলাইছলায়। ");
INSERT INTO syl_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","অইলে তুমরা আমারে বেচিছলায় করি অখন বেজার অইও না, বা নিজর উপরে নারাজ অইও না। মানষর জানর হেফাজতর লাগি, আল্লায়উ তুমরার আগে আমারে অনো পাঠাইছইন। ");
INSERT INTO syl_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","আকাল চলের অউ দুই বরছ ধরি, তে আরো পাচ বরছ কুনু খেত-খামার বা ফসল ফলতো নায়। ");
INSERT INTO syl_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","দুনিয়াইত তুমরার আওলাদ অকলরে বাচাইয়া রাখার লাগি আল্লায়উ তান কুদরতে তুমরার আগে আমারে পাঠাইছইন। ");
INSERT INTO syl_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","তেউ বুজা যায় যেন, তুমরা আমারে ইনো পাঠাইছো না, আল্লায়উ পাঠাইছইন। তাইন আমারে ফেরাউনর বাফর হমানি করিয়া তান পরিবারর চালকদার বানাইছইন, আর হারা মিসর দেশ শাসনর এখতিয়ার দিছইন। ");
INSERT INTO syl_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","অখন তুমরা জলদি করি বাবার গেছে গিয়া কও, তান পুয়া ইউছুফে কইছে, আল্লায় আমারে হারা মিসর দেশর চালকদার বানাইছইন, তে তুমি আর দেরি না করিয়া আমার গেছে আইও। ");
INSERT INTO syl_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","তুমি, তুমার পুয়া-পুড়িন, নাতি-পুতি, গরু-মেড়ার পাল আর তুমার যততা আছে, হক্কলতা লইয়া আমার গেছে গোশন এলাকাত রইবায়। ");
INSERT INTO syl_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","হনো আমি তুমারে দেখা-হুনা করমু, আকাল তো আরো পাচ বরছ রইবো, আরনায় তুমিতাইন হকলে ই আকালে বেহালত অইযিতায় পারো। ");
INSERT INTO syl_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","আমার আপন ভাই বিন-ইয়ামিনে আর তুমরা হকলে নিজর চউখে দেখরায় যেন, আমি নিজর মুখে তুমরার লগে মাতরাম। ");
INSERT INTO syl_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","মিসর দেশো আমার যেতা দাপট, মান-ইজ্জত দেখরায়, তুমরা আমার বাবারে ইতা কইবায়, আর তানরে জলদি করি অখানো লইয়া আইবায়।” ");
INSERT INTO syl_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","হেশে ইউছুফে তান ভাই বিন-ইয়ামিনর গলাত আইঞ্জা করি ধরিয়া কান্দন শুরু করলা আর বিন-ইয়ামিনেও গলাত ধরি কান্দা-কাটি করলা। ");
INSERT INTO syl_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","বাদে ইউছুফে তান হকল ভাইয়াইনরে হুংগা দিলা আর তারার গলাত ধরিও কান্দিলা। তেউ ভাইয়াইন্তেও তান লগে মাত-কথা মাতলা। ");
INSERT INTO syl_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","ইউছুফর ভাইয়াইন আওয়ার খবর ফেরাউনর বাড়িত পৌছিলে, ফেরাউন আর তান কর্মচারি অকল খুশি অইলা। ");
INSERT INTO syl_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ফেরাউনে ইউছুফরে কইলা, “তুমার ভাইয়াইনরে কও যেন, তুমরা গাধার পিঠিত ধানর বস্তা বান্দিয়া কেনান দেশো গিয়া, ");
INSERT INTO syl_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","বাবারে আর তুমরার পরিবারর হক্কলরে লইয়া আমার গেছে আইও। আমি তুমরারে মিসরর ভালা ভালা চিজ অকল দিমু আর তুমরা দেশর হকল থনে ভালা জাগাও পাইবায়। ");
INSERT INTO syl_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","আর তুমরারে আমি হুকুম দিয়ার, তুমরা যারযির বউ, পুয়া-পুড়িন্তর লাগি মিসর দেশ থাকি গাড়ি লইয়া গিয়া, তারারে আর বাবারে লইয়া আইও। ");
INSERT INTO syl_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","আর হনো তুমরার মাল-ছামানার লাগি মায়া দেখাইও না, হারা মিসর দেশর ভালা ভালা চিজ অকল তো তুমরারউ।” ");
INSERT INTO syl_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","ইছরাইলর পুয়াইন্তে অউলাউ করলা। ফেরাউনর হুকুমে ইউছুফে তারার লাগি গাড়ি আর পথর খানির মছা দিলা। ");
INSERT INTO syl_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","তাইন এরা হক্কলরে এক সেট করিয়া কাপড় দিলা, অইলে বিন-ইয়ামিনরে দিলা পাচ সেট কাপড় আর তিনশো রুপার টেকা। ");
INSERT INTO syl_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","তাইন তান বাফর লাগি দশগু গাধার পিঠিত করি মিসরর ভালা ভালা চিজ অকল, আর দশগু গাধীর পিঠিত করি খানির লাগি রুটি আর ধান বোঝাই করি পাঠাইলা। ");
INSERT INTO syl_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","অউ লাখান তান ভাইয়াইন্তরে বিদায় দিলা, বিদায় বালা তাইন এরারে কইলা, “তুমরা পথো লাগা-লাগি করিও না।” ");
INSERT INTO syl_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","বাদে তারা মিসর থনে কেনান দেশো, তারার বাফ ইয়াকুবর গেছে গিয়া কইলা, ");
INSERT INTO syl_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","“ইউছুফ অখনও জিন্দা আছে। হে তো অখন আস্তা মিসর দেশর অর্তাকর্তা।” অইলে ইতা হুনিয়া ইয়াকুবর হুশ উড়ি গেল, তান বিশ্বাসউ অইলো না। ");
INSERT INTO syl_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","বাদে ইউছুফে তারারে যেতা কইয়া দিছলা ইতা হুনিয়া, আর তানে নেওয়ার লাগি ইউছুফর পাঠাইল গাড়িন দেখিয়া, তারার বাফ ইয়াকুবর হুশ ঠিক অইলো। ");
INSERT INTO syl_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ইছরাইলে কইলা, “আমার পুয়া ইউছুফ যেন অখনও জিতা আছে, অটাউ তো বউত, মরার আগে আমি গিয়া তারে দেখাউ লাগবো।” ");
INSERT INTO syl_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","ইছরাইলে তান হক্কলতা লইয়া বার অইগেলা। আর বের-শেবাত আইয়া তান বাফ ইছহাকর আল্লার নামে কুরবানি করলা। ");
INSERT INTO syl_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","বাদে রাইতর বালা আল্লায় ইছরাইলরে দিদার দিয়া কইলা, “ও ইয়াকুব, ইয়াকুব!” তাইন জুয়াপ দিলা, “অউনু আমি।” ");
INSERT INTO syl_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","আল্লায় ফরমাইলা, “আমি আল্লা, তুমার বাফর মাবুদ। তুমি মিসরো যাইতে ডরাইও না, হনো আমি তুমার এক বিরাট জাতি পয়দা করমু। ");
INSERT INTO syl_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","আমি তুমার লগে লগে মিসরো যাইমু, আর আমিউ তুমারে হিরবার ফিরাইয়া আনমু আর তুমার পুয়া ইউছুফে তুমার চউখ মুজাইয়া দিবো।” ");
INSERT INTO syl_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","বাদে ইয়াকুবে বের-শেবা থাকি রওয়ানা অইলা। ফেরাউনে তারারে নেওয়ার লাগি যেতা গাড়িন দিছলা, ইছরাইলর পুয়াইন্তে অতাত করি তারার বাফরে আর তারার বউ, পুয়া-পুড়িনরে লইয়া গেলা। ");
INSERT INTO syl_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","হেশে ইয়াকুব, তান পুয়াইন আর তান পুরা গুষ্টি, পশুর পাল অকল আর কেনান দেশো কামাই করা হক্কল ধন-দৌলত লইয়া মিসরো পৌছলা। ");
INSERT INTO syl_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","অউ লাখান ইয়াকুবে তান পুয়া-পুড়িন, নাতি-নাতিন, পুরা গুষ্টির হক্কলরে লইয়া মিসরো পার অইগেলা। ");
INSERT INTO syl_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","বনি ইছরাইল, মানি ইয়াকুব আর তান আওলাদ অকল যেরা মিসরো গেছলা, তারার খান্দান-নামা অইলো: ইয়াকুবর বড় পুয়া রুবেন; ");
INSERT INTO syl_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","আর রুবেনর পুয়াইন: হনোক, ফালু, হাছির আর কর্মি। ");
INSERT INTO syl_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","শিমিয়নর পুয়াইন: যিমুয়েল, যামীন, ওহদ, যাখীন, সোহর, আর কেনানী বউর তরফা শৌল। ");
INSERT INTO syl_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","লেবির পুয়াইন: জারছুন, কাহাত আর মারারি। ");
INSERT INTO syl_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","এহুদার পুয়াইন: এইর, ওনন, শেলা, ফিরোজ আর জারাহ। অইলে ওনন আর এইর কেনান দেশোউ মরি গেছলা। ফিরোজর পুয়াইন: হাছির আর হামুল। ");
INSERT INTO syl_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ইছাখরর পুয়াইন: তোলা, ফওয়া, যাশুব আর শিমরন। ");
INSERT INTO syl_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","সবুলনর পুয়াইন: ছেরেদ, এলন আর যহলেল। ");
INSERT INTO syl_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","তারা অইলা লেয়ার হুরুতাইন, পদ্দন-ইরামো লেয়ার তরফা ইয়াকুবর ই হুরুতাইন আর তান পুড়ি দীনার জন্ম অইছিল, এরা হক্কলতায় তেত্রিশ জন। ");
INSERT INTO syl_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","ছাদুর পুয়াইন অইলা: ছিফন, হগি, শূনি, ইষবোন, এইরি, অরোদি আর অরেলি। ");
INSERT INTO syl_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","আশিরর পুয়াইন: ইমনা, যিছবা, যিছবি, বরিয়া আর তারার বইন ছেরা। বরিয়ার পুয়াইন: হেবর আর মল্কিয়েল। ");
INSERT INTO syl_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","তারা অইলা জিল্পার হুরুতাইন, লাবনে তান পুড়ি লেয়ার লগে অউ বান্দি জিল্পারে দিছলা, এরা হকলউ তাইর তরফা ইয়াকুবর হুরুতাইন, অউ ষোল জন। ");
INSERT INTO syl_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","ইয়াকুবর বিবি রাহেলার পুয়াইন অইলা: ইউছুফ আর বিন-ইয়ামিন। ");
INSERT INTO syl_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","ইউছুফর পুয়াইন মানশা আর আফরাইম মিসর দেশো জন্মিছলা। এরার মা অইলা অউন মন্দিরর বাবন-ঠাকুর, পোটিফেরার পুড়ি আসনত। ");
INSERT INTO syl_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","বিন-ইয়ামিনর পুয়াইন: বেলা, বেখর, অশবেল, গেরা, নামান, এহী, রোশ, মুপ্পীম, হুপ্পীম আর অর্দ। ");
INSERT INTO syl_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","তারা অইলা রাহেলার তরফা ইয়াকুবর হুরুতাইন, অউ চৌদ্দ জন। ");
INSERT INTO syl_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","দানর পুয়া: হুশীম। ");
INSERT INTO syl_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","নপ্তালির পুয়াইন: যহসিয়েল, গুনি, ইজের আর শিল্লেম। ");
INSERT INTO syl_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","তারা অইলা বিলহার হুরুতাইন, লাবনে তান পুড়ি রাহেলার লগে অউ বান্দি বিলহারে দিছলা। এরা হকলউ তাইর তরফা ইয়াকুবর হুরুতাইন, অউ সাত জন। ");
INSERT INTO syl_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","ইয়াকুবর নানান তরফার জন্মর যারা মিসরো আইলা, তান পুয়াইন্তর বউ বাদ দিয়া এরা হকলে মিলিয়া ছয়ষট্টি জন আছলা। ");
INSERT INTO syl_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","মিসর দেশো ইউছুফর দুইজন পুয়া জন্মিছলা। এরা সহ ইয়াকুবর পরিবারর যারা মিসরো আইলা, তারা মোট সত্তইর জন। ");
INSERT INTO syl_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","এর আগে ইয়াকুবে এহুদারে ইউছুফর গেছে পাঠাইলা, গোশনো যাওয়ার পথ চিনার লাগি, তেউ তারা হক্কল অনো গিয়া পৌছলা। ");
INSERT INTO syl_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","আর ইউছুফেও ঘোড়ার গাড়ি হাজাইয়া তান বাফ ইছরাইলর লগে গোশনো দেখা করাত গেলা, আর তানরে দেখিয়াউ আইঞ্জা করি গলাত ধরিয়া বউত সময় কান্দিলা। ");
INSERT INTO syl_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","তেউ ইছরাইলে ইউছুফরে কইলা, “তুমি যেন জিন্দা আছো রে পুত, ইটা নিজর চউখে দেখলাম। অখন শান্তিয়েউ মরতাম পারমু।” ");
INSERT INTO syl_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","অউ ইউছুফে তান ভাইয়াইন্তরে আর তান বাফর লগর হকলরে কইলা, “আমি গিয়া ফেরাউনরে জানাইমু, আমার ভাইয়াইন আর আমার বাফর বাড়ির হকল, কেনান দেশ থনে আমার গেছে আইচ্ছইন। ");
INSERT INTO syl_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","তারার কাম অইলো পশু পালা। তারা তো ছাগল-মেড়া পালইন, আর তারার পশুর পাল অকল আর হক্কল মাল-ছামানা লইয়া আইচ্ছইন। ");
INSERT INTO syl_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","ফেরাউনে যেবলা তুমরারে জিকাইবা, আপনারা কিতা কাম করইন? ");
INSERT INTO syl_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","অউ সময় তুমরা কইও, আপনার ই গুলাম অকলে আর তারার বাফ-দাদা অকলেও হুরুমান থনেউ পশু পালিয়া বাচইন। তেউ তুমরা গোশনো রইতায় পারবায়। কারন পশু পালরা মানষরে মিসরী অকলে ঘিন করইন।” ");
INSERT INTO syl_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","ইউছুফে ফেরাউনর গেছে গিয়া কইলা, “আমার বাবা আর ভাইয়াইন্তে, তারার গরু-ছাগল আর তারার হক্কলতা লইয়া, কেনান দেশ ছাড়িয়া আইছইন। তারা আইয়া গোশনো পৌছি গেছইন।” ");
INSERT INTO syl_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","ভাইয়াইন্তর মাজে পাচ জনরে নিয়া তাইন ফেরাউনর ছামনে আজির করলা। ");
INSERT INTO syl_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ফেরাউনে তারারে জিকাইলা, “তুমরা কিতা কাম করো?” তারা কইলা, “আপনার ই গুলাম অকলে বাফ-দাদার আমল থাকিউ পশু পালি।” ");
INSERT INTO syl_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","তারা হিরবার কইলা, “আমরা ই দেশো মুছাফির অইয়া থাকার লাগি আইছি। কেনান দেশো অখন বেজুইতা নিদান চলের করি, হিনো আমরার পশুর পালর খুরাকি নায়। এরলাগি দয়া করি আপনার ই গুলাম অকলরে, গোশনো রইবার সুযোগ দেউক্কা।” ");
INSERT INTO syl_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ফেরাউনে ইউছুফরে কইলা, “তুমার বাফ-ভাইয়াইন তুমার গেছে আইছইন; ");
INSERT INTO syl_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","আস্তা মিসর দেশউ তো তুমার ছামনে পড়ি রইছে। দেশর হকল থাকি ভালা জাগাত তারারে রইতে দেও, তারা গোশনোউ থাকউক আর এরার মাজে যোইগ্য মানুষ পাইলে, তারারে আমার পশুর পালর চালকদার বানাইলাও।” ");
INSERT INTO syl_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","বাদে ইউছুফে তান বাফ ইয়াকুবরে ফেরাউনর ছামনে আনাইলা আর ইয়াকুবে ফেরাউনরে দোয়া দিলা। ");
INSERT INTO syl_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ফেরাউনে ইয়াকুবরে জিকাইলা, “আপনার বয়স কত অইছে?” ");
INSERT INTO syl_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","ইয়াকুবে কইলা, “দুনিয়াইত আমার মুছাফিরির আয়ু একশো তিশ বরছ অইছে, ইতা তো বেশি নায়, আর খুব তকলিফেউ ই দিন কাটছে; আমার বাফ-দাদার মুছাফিরির আয়ুর হমান অখনও অইছে না।” ");
INSERT INTO syl_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","হেশে ইয়াকুবে ফেরাউনরে দোয়া করিয়া বিদায় লইলা। ");
INSERT INTO syl_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","তেউ ইউছুফে ফেরাউনর হুকুম মত, তান বাফ-ভাইয়াইনরে মিসর দেশর হকল থাকি ভালা জাগা, রামাষেষ এলাকাত রইতা দিলা। ");
INSERT INTO syl_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","ইউছুফে তান বাফ-ভাইয়াইন আর তারার পরিবাররে যারযির দরকারি, খানি-খুরাকি হকলতা যুগাই দিলা। ");
INSERT INTO syl_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","বাদে আকাল আরো বেথায়া অইলো, দেশর কুনু জাগাত খানির কুন্তা আছিল না। তেউ মিসর আর কেনান দেশ এক্কেবারে কাহিল অইগেল। ");
INSERT INTO syl_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","মিসর আর কেনান দেশর মানষর যত টেকা-পয়সা সোনা-রুপা আছিল, ইতাদি তারা ধান খরিদ করায়, ইউছুফে অতা দলা করিয়া ফেরাউনর ভান্ডারো জমাইলা। ");
INSERT INTO syl_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","মিসর আর কেনান দেশর হকল সোনা-রুপা যেবলা ফুড়াই গেল, তেউ মিসরী অকলে আইয়া ইউছুফরে কইলা, “আমরারে খানির কুন্তা দেউক্কা। আমরার সোনা-রুপা ফুড়াই গেছে করি আপনার চউখর ছামনে মরিযিতাম নি?” ");
INSERT INTO syl_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","ইউছুফে কইলা, “তাইলে তুমরার পশু অকল আনিয়া দেও, সোনা-রুপা ফুড়াই গেলেও পশু অকলর বদলা আমি তুমরারে খানি-খুরাকি দিমু।” ");
INSERT INTO syl_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","তেউ তারা যারযির গরু-ছাগল, ঘোড়া-মেড়া, গাধা-গাধী ইউছুফর গেছে আনলা আর ইউছুফে এর বদলা তারারে ধান দিলা। অউ লাখান তারার হক্কল পশুর বদলা, হি বছরর খুরাকি চালাইলা। ");
INSERT INTO syl_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","আর হি বরছ গেল, এর বাদর বরছ মানষে আইয়া ইউছুফরে কইলা, “হুজুরর গেছে আমরা কুন্তাউ লুকাইয়ার না, আমরার হকল সোনা-রুপা শেষ অইগেছে আর পশু অকলও আপনারে দিলাইছি। অখন আমরার আর কুন্তাউ রইছে না, খালি অউ শরিল আর জাগা-জমিন ছাড়া। ");
INSERT INTO syl_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","এরলাগি আপনার চউখর ছামনে জমি-জমা সহ আমরা কিলা মরিযিতাম? তে আপনে আমরারেও আর আমরার হকল জমি-জমাও লইলাউক্কা, আমরা ফেরাউনর গুলামি করমু, তা-ও আমরারে খানি দেউক্কা আর বিচ দেউক্কা, তেউ আমরাও মরা থনে বাচমু আর জমিন খানাইনও বরবাদ অইতো নায়।” ");
INSERT INTO syl_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","অউ ইউছুফে মিসর দেশর হক্কল জমিন ফেরাউনর নামে লইলিলা, কারন ই আকাল অউলা বেজুইতা অইছিল যেন, মিসরর হকলেউ তারার জাগা-জমিন বেচিলাইলা। তেউ দেশর হকল জমিন ফেরাউনর আতো আইল্লো। ");
INSERT INTO syl_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","আর ইউছুফে মিসর দেশর এক মাথা থাকি আরক মাথার হকল মানষরে টাউনো পার করিলিলা। ");
INSERT INTO syl_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","খালি বাবন অকলর জাগা-জমিন তাইন লইলা না, কারন এরারে ফেরাউনে বেতন দিতা, আর অতা দিয়াউ তারা চলতা। ");
INSERT INTO syl_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","হেশে ইউছুফে মানষরে কইলা, “হুনো, ফেরাউনর নামে আমি তুমরারে আর তুমরার হকল জাগা-জমিনও লইলিলাম। অখন তুমরা অউ বিচ অকল নেও আর জমিনো বাইন করো। ");
INSERT INTO syl_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","তেউ জমিনো যেতা ফসল ফলিবো, এর পাচ বাটর এক বাট ফেরাউনরে দিও আর বাকি চাইর বাট, জমিনর বিচ, তুমরা আর তুমরার পরিবার আর হুরুতাইন্তর খানির লাগি নিওগি।” ");
INSERT INTO syl_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","তেউ মানষে কইলা, “আপনে আমরার জান বাচাইলা। হুজুরে আমরারে দয়া করলে, আমরা ফেরাউনর গুলামি করমু।” ");
INSERT INTO syl_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","বাদে ইউছুফে মিসর দেশর জাগা-জমিনর লাগি অউ আইন জারি করলা, হকল ফসলর পাচ বাটর এক বাট ফেরাউনে পাইবা, খালি বাবন অকলর জমিন বাদে। অউ আইন অখনও চলের। ");
INSERT INTO syl_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","বনি ইছরাইলে মিসর দেশর গোশনো বসত করলা। তারা হনর দখলদারি পাইয়া, খুব ফলআলা অইলা আর তারার বউত আওলাদ অইলা। ");
INSERT INTO syl_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","মিসর দেশো আইয়া ইয়াকুব সতরো বরছ জিন্দা রইলা। তেউ তাইন হকলতায় একশো সাতচাল্লিশ বরছ বাচিলা। ");
INSERT INTO syl_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","ইছরাইলর মউতর দিন কাছাইয়া আইলে তান পুয়া ইউছুফরে খবর দি আনাইয়া কইলা, “আমার বায় তুমার মেহেরবানি অইলে একখান অছিয়ত করাইতাম, তুমি আমার উরাতর তলে তুমার আতখান হারাও, তুমি আমার বায় দয়া আর হালালি দেখাইও, আমারে মিসরো দাফন করিও না। ");
INSERT INTO syl_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","আমি যেবলা আমার বাফ-দাদার গেছে যাইমুগি, অউ সময় তুমি আমারে মিসর দেশ থাকি নিয়া, আমার বাফ-দাদার কবরস্থানো দাফন করিও।” ইউছুফে কইলা, “আপনে যেলা কইলা, অউলাউ করমু।” ");
INSERT INTO syl_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","তেউ ইয়াকুবে কইলা, “তে তুমি আমার গেছে কছম করো।” ইউছুফে কছম করলা। অউ ইছরাইলে তান বিছনার হিতান বায় কাইত অইলা। ");
INSERT INTO syl_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","এরবাদে ইউছুফে খবর পাইলা, তান বাফ বেমার, অউ তান দুইও পুয়া মানশা আর আফরাইমরে লইয়া বাফরে দেখাত আইলা। ");
INSERT INTO syl_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","ইয়াকুবে যেবলা হুনলা, তান পুয়া ইউছুফ আইছইন, অউ তাইন শরিলর হকল বল খাটাইয়া, উঠিয়া বিছনাত বইলা। ");
INSERT INTO syl_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","আর তাইন ইউছুফরে কইলা, “সর্ব-শক্তিমান আল্লায় কেনান দেশর লুজ টাউনো, আমারে দিদার দিয়া বরকত দান করিয়া কইছলা, ");
INSERT INTO syl_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","‘হুনো, আমি তুমারে ফলদার করমু আর বউত আওলাদ দিমু, তুমা থনে বউত গুষ্টিআলা এক জাতি পয়দা করমু আর তুমার ওয়ারিশ অকলরে, হামেশাকুর লাগি ই দেশর মালিকানা দিমু।’ ");
INSERT INTO syl_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","আমি তুমার গেছে মিসরো আইবার আগে, তুমার যে দুইও পুয়া মিসরো জন্মিছইন, তারা আমারউ। রুবেন আর শিমিয়ন যেলা আমার, অউলা মানশা আর আফরাইমও আমার অইবা। ");
INSERT INTO syl_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","অইলে এরার বাদে তুমার যেতা হুরুতা অইছইন, তারা তুমারউ রইবা, আর তারার ভাইর নামেউ এরার মালিকানা কাইম অইবো। ");
INSERT INTO syl_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","আর পদ্দন থাকি আমরা আওয়ার সময়, কেনান দেশর ইফ্রাথ থাকি থুড়া দুরই থাকতেউ, রাহেলা মারা গেলা। তেউ আমি হনর ইফ্রাথো, বেথেলহামর পথর ধারো তানরে দাফন করলাম।” ");
INSERT INTO syl_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","বাদে ইউছুফর পুয়াইন্তর বায় চাইয়া ইছরাইলে জিকাইলা, “এরা কে?” ");
INSERT INTO syl_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","ইউছুফে তানরে কইলা, “এরা আমার পুয়াইন, আল্লায় অউ দেশোউ এরারে দিছইন।” তাইন কইলা, “এরারে আমার কাছাত আনো। আমি তারারে দোয়া করতাম।” ");
INSERT INTO syl_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","মুরব্বি বয়সো চউখর জুতি কমি যাওয়ায় ইছরাইলে ভালা করি দেখতা না। তেউ এরা কাছাত আইলে, ইছরাইলে তারারে আইঞ্জা করি ধরিয়া হুংগা দিলা। ");
INSERT INTO syl_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","তাইন ইউছুফরে কইলা, “বাবারে, আমি মনো করছলাম তুমার মুখ আর কুনু দিন দেখতাম নায়, অইলে আল্লায় তুমার আওলাদ অকলরেও দেখাইলিলা।” ");
INSERT INTO syl_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","তেউ ইউছুফে তান বাফর গেছ থনে, পুয়াইন্তরে হরাইয়া মাটিত সইজদা করলা। ");
INSERT INTO syl_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","আর ইউছুফে তান দুইও পুয়ারে লইয়া, ডাইন আত দিয়া আফরাইমরে ধরিয়া ইছরাইলর বাউ গালাত, আর বাউ আত দিয়া মানশারে ধরিয়া ইছরাইলর ডাইন গালাত আনিয়া আজির করলা। ");
INSERT INTO syl_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","অইলে ইছরাইলর নিজর আখলে, তান আত আড়া-আড়ি করিয়া, ডাইনর আত হুরু পুয়া আফরাইমর মাথাত আর ইউছুফর বড় পুয়া মানশার মাথাত থইলা তান বাউ আত। ");
INSERT INTO syl_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","বাদে তাইন ইউছুফরে দোয়া করিয়া কইলা, “হউ আল্লা, যান মর্জিয়ে আমার বাফ-দাদা, ইব্রাহিম আর ইছহাকে চলতা, হউ আল্লা, যেইন পয়লা থাকি আইজ পর্যন্ত আমারে পালিয়া আইরা, ");
INSERT INTO syl_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","হউ ফিরিস্তা, যেইন আমারে হকল মছিবত থাকি বাচাইছইন, তাইনউ অউ দুইও পুয়ারে বরকত নাজিল করউক্কা। এরারে দিয়াউ ইব্রাহিম আর ইছহাক আর আমার নাম জিন্দা থাকউক। দুনিয়াইর মাজে তারার বউত গুষ্টি অউক।” ");
INSERT INTO syl_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","বাফে তান ডাইন আত আফরাইমর মাথাত রাখলা করি ইউছুফ বেজার অইগেলা। আর আফরাইমর মাথা থাকি হরাইয়া, মানশার মাথাত দেওয়ার লাগি, তান বাফর আত উচা করলা। ");
INSERT INTO syl_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","তাইন আতো ধরিয়া কইলা, “বাবা, ই লাখান নায়। অউনু আমার বড় পুয়া, তে আপনার ডাইন আত তার মাথাত রাখউক্কা।” ");
INSERT INTO syl_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","অইলে তান বাফে না-খুশ অইয়া কইলা, “বাবারে, আমি ইতা জানি, আমি ইতা জানিরে পুত। তারও এক জাতি অইবো আর মহান অইবো, অইলে তার হুরু ভাই তার চাইতেও মহান অইবো, আর তার আওলাদর বউত গুষ্টি অইবো।” ");
INSERT INTO syl_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","ইছরাইলে এরবাদে অউ দুইও নাতিরে দোয়া করিয়া কইলা, “বনি ইছরাইলে কুনু মানষরে দোয়া করলে অউলা কইবা, আল্লায় তুমারে আফরাইম আর মানশার লাখান করউক্কা।” অউলা তাইন মানশার চাইতে আফরাইমরে বড় বানাইলা। ");
INSERT INTO syl_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","হেশে হজরত ইছরাইলে ইউছুফরে কইলা, “দেখো, আমার মরনর অখত আইচ্চে। আল্লা তুমরার লগে রইবা, আর তুমরারে হিরবার তুমরার বাফ-দাদার দেশো নিচ্চয় ফিরাইয়া নিবা। ");
INSERT INTO syl_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","তুমার ভাইয়াইন্তর চাইতে তুমারে এক বাট বেশি দিলাম। অউ বাট তো শিখিম এলাকা, ইতা আমার তলোয়ার-ধনুক দিয়া আমোরী অকলর গেছ থাকি আনছলাম।” ");
INSERT INTO syl_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","বাদে ইয়াকুবে তান পুয়াইন্তরে আনাইয়া কইলা, “তুমরা হক্কল একখানো অও। ভবিষ্যতে তুমরার জিন্দেগি কিলা যাইবো, ইতা আমি তুমরারে কইরাম। ");
INSERT INTO syl_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","ইয়াকুবর পুয়াইন, তুমরা একখানো আও; তুমরার বাফ ইছরাইলর বুলি হুনো। ");
INSERT INTO syl_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","রুবেন তুমি আমার বড় পুয়া, তুমি আমার বল, আমার জুয়ানকির পয়লা ফল; তুমি হকল থাকি তেজি আর হিম্মতি। ");
INSERT INTO syl_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","তুমি উতরাইল গরম পানির লাখান, তুমার বড়াই রইতো নায়; তুমি আপন বাফর বিছনাত গেছো, হাতন মাʼর লগে নাপাকি কাম করছো। ");
INSERT INTO syl_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","শিমিয়ন আর লেবি দুই ভাই; তারার তলোয়ার জালিমর আতিয়ার। ");
INSERT INTO syl_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","ও আমার জান, তারার মজলিছো হামাইও না; ও আমার শান, তারার সমাজো যাইও না। তারা গুছা করি খুন করলো; আড়ুয়ামি করি বিছালর রগ কাটলো। ");
INSERT INTO syl_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","তারার গুছা তো লান্নতি, ইতা বড় বেজুইতা; লান্নতি তারার জুলুম, ইতা তো পাষান। আমি তারারে ইয়াকুবর মাজে বাটিমু; বনি ইছরাইলর মাজে ছিতরাই দিমু। ");
INSERT INTO syl_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","এহুদা, তুমার ভাইয়াইন্তে তুমার তারিফ করবা; তুমি দুশমনর গর্দনাত ধরবায়; তুমার বাফর ওয়ারিশ অকলে, তুমার গেছে মাথা নোয়াইবা। ");
INSERT INTO syl_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","তুমি তো সিংহর বাইচ্চা এহুদা। তুমি শিকারর গোস্ত খাইয়া হরিয়া আইলায়; হে সিংহর লাখান লেটিয়া হুতিয়া গড়িয়াইলো; সিংহীরে খেগুয়ে ঘুম ভাংগাইতো? ");
INSERT INTO syl_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","এহুদার আত থনে তো রাজ-লাঠি হরতো নায়; তার দুইও পাওর মাজ থনে বিচারর গদা যাইতো নায়; যতদিন শীলো না আইবা, আর হকল জাতি তান হুকুমে চলবা। ");
INSERT INTO syl_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","হে আংগুর গাছো বানবো তার গাধা; আংগুরর সুন্দর ডালো বানবো গাধার বাইচ্চা; লাল আংগুরর রসদি ধুইবো তার জুব্বা, আংগুরর লউদি করবো লেবাছ ছফা। ");
INSERT INTO syl_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","তার চউখ আংগুরর রসে লাল টকটকা, আর তার দাত দুধর লাখান ধলা। ");
INSERT INTO syl_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","সবুলন দরিয়ার পারো বসত করিবো, হে জাজ ভিড়ানির ঘাট অইবো, সিদন পর্যন্ত তার সীমানা অইবো। ");
INSERT INTO syl_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","ইছাখর এগু বলআলা গাধা, হে খুঅড়র ভিতরে হুতে। ");
INSERT INTO syl_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","হে দেখলো জিরানির জাগাখান ভালা, দেশখান সুন্দর; তেউ গাইট বইবার লাগি কান্দ লামাইলো, আর জুরর গুলাম অইলো। ");
INSERT INTO syl_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","দানে তার নিজর প্রজা অকলর বিচার করবো, ইছরাইলর এক গুষ্টির লাখান। ");
INSERT INTO syl_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","হে অইবো সড়কর ধারর হাফ, পথর বিষআলা আলদ; যেগিয়ে ঘোড়ার পাওত কামড় মারে, ঘোড়-ছওয়ার খরেদি উল্টিয়া পড়ে। ");
INSERT INTO syl_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","ও মাবুদ, আমি তুমার নাজাতর মুখা চাই রইছি। ");
INSERT INTO syl_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","ছাদুরে লুটরা দলে হামলা করবো, বাদে হে-ও তারার খরেদি লুটিবো। ");
INSERT INTO syl_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","আশিরর খুব ভালা ফসল ফলিবো, হে বাদশার জুকা খানি যুগাইবো। ");
INSERT INTO syl_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","নপ্তালি অইলো ছাড়া হরিনী, তার মুখো আছে মিঠা মিঠা মাত। ");
INSERT INTO syl_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","ইউছুফ ফলআলা গাছর ডাল, ইন্দারার ধারর ফলআলা গাছর ডাল; তার ডালাইন বেড় পার অইযায়। ");
INSERT INTO syl_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","তীর-ধনুক আলাইন্তে তারে বেজুইতা তকলিফ দিছলা, তীর মারিয়া তারে বেকায়দাত ফালাইছলা; ");
INSERT INTO syl_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","অইলে তার ধনুক মজবুত রইলো, তার আতর হনাত বল রইলো; ইয়াকুবর হউ মহান শক্তিআলার আত দিয়া, যেইন ইছরাইলর আশ্রয় টিল্লা, তানরে দিয়া। ");
INSERT INTO syl_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","তুমার বাফর হউ আল্লারে দিয়া, যেইন তুমারে সাইয্য করবা; হউ সর্ব-শক্তিমানরে দিয়া, যেইন তুমারে বরকত নাজিল করবা; উপরে থওয়া আছমান থাকি লামরা বরকতে, তলে বিছাইল পানি থাকি বার অওয়া ঝরনার বরকতে, বুকুর দুধ আর পেট থাকি বার অওয়া বরকতে। ");
INSERT INTO syl_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","আমার বাফ-দাদার দোয়া থাকি, তুমার বাফর দেওয়া দোয়া বউত ভালা অউক; ইতা হামেশাকুর খাড়া হাজাইল পাহাড়-পর্বত থাকি লামউক। হউ দোয়া ইউছুফর মাথাত পড়উক; ভাইয়াইন থাকি আলগর মাথার তালুত পড়উক। ");
INSERT INTO syl_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","বিন-ইয়ামিন অইলো বড়-বাঘর লাখান, হে বিয়ানে খায় শিকারর গোস্ত, আর হাইঞ্জায় বিলায় লুটর মাল।” ");
INSERT INTO syl_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","এরা অইলা ইছরাইলর বারো গুষ্টি, তারার বাফে তারার লাগি দোয়ার সময় অউলা কইলা। তাইন এরা হক্কলরে যারযির পাওনা দোয়া দিলা। ");
INSERT INTO syl_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","বাদে ইয়াকুবে তান পুয়াইন্তরে অছিয়ত করাইলা যেন, “আমার তো বাফ-দাদার গেছে যাওয়ার সময় অইগেছে, তে হিট্টী ইফ্রোনর জমিনর গুহাত, আমার বাফ-দাদার কান্দাত আমারে দাফন করিও। ");
INSERT INTO syl_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ই গুহা কেনান দেশর, মম্রির ধারো মকপেলার জমিত। ইব্রাহিমে হিট্টী ইফ্রোনর গেছ থনে অউ জমিন লইছলা কবরস্থান বানানির লাগি। ");
INSERT INTO syl_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","অনোউ ইব্রাহিম আর তান বিবি ছায়রারে দাফন করা অইছে, ইছহাক আর তান বিবি রেবেকারেও অনো দাফন করা অইছে, আর আমি লেয়ারেও অনো দাফন করছি। ");
INSERT INTO syl_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ই জমিন আর এর মাজর গুহা হিট্টী অকলর গেছ থনে লইছলা।” ");
INSERT INTO syl_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","ইয়াকুবে তান পুয়াইন্তরে অছিয়ত করা শেষ অইলে, বিছনার উপরে তান দুইও পাও একখানো করলা আর আখেরি দম ছাড়িয়া তান বাফ-দাদার গেছে গেলাগি। ");
INSERT INTO syl_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","ইউছুফে তান বাফর মুখর উপরে মুখ লাগাইয়া কান্দিতা লাগলা আর তানরে হুংগা দিলা। ");
INSERT INTO syl_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","বাদে তাইন নিজর অধীনর হেকিম অকলরে হুকুম দিলা, তারা তান বাফর লাশরে মমি বানাইবার লাগি। তেউ তারা তান গতরো মমির মশলা লাগাইলা। ");
INSERT INTO syl_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","তারা ই কামো চাল্লিশ দিন লাগাইলা, অউ কামো তো চাল্লিশ দিনউ লাগে। আর মিসরী অকলে তান লাগি সত্তইর দিন ভরিয়া আহাজারি করলা। ");
INSERT INTO syl_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","অউ আহাজারির দিনর বাদে, ইউছুফে ফেরাউনর বাড়ির মানষরে কইলা, “আপনারা যুদি আমারে দয়া করইন, তে ফেরাউনরে আমার অউ কথাখান জানাউক্কা যেন। ");
INSERT INTO syl_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","বাবায় আমারে কছম করাইয়া কইছলা, ‘হুনো, আমি তো মরিযিমু, তে কেনান দেশো আমার লাগি জুইত করা কয়বরো আমারে দাফন করিও।’ তেউ অখন তানরে দাফনর লাগি, দয়া করি আমারে যাইতে দেউক্কা, বাবারে কয়বর দিয়াউ আমি হিরবার আইমু।” ");
INSERT INTO syl_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ফেরাউনে জুয়াপ দিলা, “তাইন তুমারে যেলা কছম করাইছইন, তুমি গিয়া অউলাউ করো।” ");
INSERT INTO syl_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","তেউ ইউছুফে তান বাফরে দাফনর লাগি রওয়ানা দিলা; আর ফেরাউনর হকল গুলামে, তান দরবারর মুরব্বি অকলে আর মিসরর ময়-মুরব্বি অকলে, ");
INSERT INTO syl_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ইউছুফর নিজর পরিবার, তান ভাইয়াইন আর তান বাফর পরিবারর হকলে রওয়ানা দিলা। গোশনো খালি তারার হুরুতাইন আর গরু-মেড়ার পালাইন থইয়া গেলা। ");
INSERT INTO syl_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","তারা বউত ঘোড়ার গাড়ি আর ঘোড়-ছওয়ার অকল লইয়া এক বিরাট দল হাজিয়া রওয়ানা দিলা। ");
INSERT INTO syl_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","আর জর্দান গাংগর হপারো আটাদর ধান মাড়ার জাগাত গিয়া, তারা হকলে সাতদিন ধরি ইউছুফর বাফর লাগি খুব আহাজারি আর বিলাপ করলা। ");
INSERT INTO syl_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","আটাদর ধান মাড়ার জাগাত তারারে ইলা আহাজারি করাত দেখিয়া, হি দেশর বাসিন্দা কেনানী অকলে কইলা, মিসরী অকলর লাগি ইটা খুব বেজুইতা আহাজারি; এরলাগি জর্দান গাংগর পারর অউ জাগার নাম অইগেল, আবেল-মিসরয়ীম মানি, মিসরী অকলর আহাজারি। ");
INSERT INTO syl_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","ইছরাইলে তান পুয়াইন্তরে যেলা অছিয়ত করছলা, তারা তানরে অলাউ করলা। ");
INSERT INTO syl_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","তারা তান লাশ কেনান দেশো লইয়া গেলা, আর মম্রির গেছে মকপেলার জমিনর, গুহার মাজে তানরে দাফন করলা। ইটা কবরস্থান বানানির লাগি ইব্রাহিমে, হিট্টী ইফ্রোনর গেছ থাকি লইছলা। ");
INSERT INTO syl_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","বাফরে দাফন করার বাদে ইউছুফ, তান ভাইয়াইন আর যত মানুষ তান বাফরে দাফন করাত লগে গেছলা, তারা হকলে মিসরো ফিরিয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","বাফ মরিগেছইন দেখিয়া ইউছুফর ভাইয়াইন্তে মাতা-মাতি করলা, ইউছুফে কিবা আমরারে ঘিন্নাইবো আর আমরা তার যেতা খেতি করছি, অখন ইতা হক্কলতার বদলা লইবো। ");
INSERT INTO syl_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","তেউ তারা ইউছুফর গেছে খবরিয়া পাঠাইয়া কইলা, “তুমার বাফে মরার আগে ই অছিয়ত করছলা যেন, ");
INSERT INTO syl_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","তুমরা ইউছুফরে অউ কথাখান কইও, তুমার ভাইয়াইন্তে তুমার যেতা খেতি করছইন, দয়া করি তুমি তারার হি অইন্যায় আর গুনা মাফ করি দিও। এরলাগি আমরা মিনত করিয়ার, তুমার বাফর আল্লার অউ গুলাম অকলরে মাফ করি দিলাও।” তারার মাত হুনিয়া ইউছুফর কান্দন আইল্লো। ");
INSERT INTO syl_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","বাদে তান ভাইয়াইন্তে তান ছামনে আইয়া মাটিত পড়িয়া কইলা, “হুনো, আমরা তো তুমার গুলাম।” ");
INSERT INTO syl_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","অইলে ইউছুফে তারারে কইলা, “তুমরা ডরাইও না। আমি কুনু আল্লার খলিফা নি? ");
INSERT INTO syl_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","তুমরা তো আমার খেতি করতায় চাইছলায়, অইলে আল্লায় ইতারে ভালাই বানাইল্লা, যেলা আইজ দেখরায়, তে তান খিয়াল আছিল অউ লাখান করি বউত মানষর জান বাচাইতা। ");
INSERT INTO syl_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","তুমরা অখন ডরাইও না। আমি তুমরারে আর তুমরার পুয়া-পুড়িন্তরে দেখা-হুনা করমু।” তাইন অউ লাখান করি তারারে বুজ দিলা আর খুশ দিলে মাত-কথা মাতিলা। ");
INSERT INTO syl_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","বাদে ইউছুফ আর তান বাফর আওলাদ অকলে মিসরো বসত করাত রইলা। ইউছুফ একশো দশ বরছ জিন্দা আছলা। ");
INSERT INTO syl_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","তাইন আফরাইমর নাতিনশা পর্যন্ত দেখলা আর মানশার পুয়া মাখীরর হুরুতাইনও ইউছুফর আতো পয়দা অইলা। ");
INSERT INTO syl_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","বাদে ইউছুফে তান ভাইয়াইন্তরে কইলা, “আমার তো মউতর অখত আইচ্চে, নিচয় আল্লায় তুমরার বায় নজর রাখবা। তাইন ইব্রাহিম, ইছহাক আর ইয়াকুবর গেছে যে দেশ দিতা করি কছম করছইন, তুমরারে অন থাকি হউ দেশো লইয়া যাইবা।” ");
INSERT INTO syl_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","আর ইউছুফে বনি ইছরাইলরে অউ অছিয়ত করাইলা, “নিচয় আল্লায় কুনুদিন তুমরার বায় নজর করবা। তে অন থাকি যাওয়ার বালা তুমরা আমার আড্ডি অকল তুলিয়া লইয়া যাইও।” ");
INSERT INTO syl_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","হেশে একশো দশ বরছ বয়সো ইউছুফ মারা গেলা। তেউ মানষে তান লাশরে খুশবু-মশলাদি মাখিয়া মমি বানাইয়া মিসর দেশো এক কাফনর বাক্সর ভিতরে থইলা॥");
INSERT INTO syl_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","আল্লায় হজরত ইয়াকুবর নয়া নাম দিছলা ইছরাইল, এরলাগি তান বংশর নাম অইলো বনি ইছরাইল। ইয়াকুবে তান বিবিন-বাইচ্চাইন আর পরিবারর হকলরে লইয়া মিসর দেশো গেলাগি। অউ সময় তান লগে অইয়া যেরা গেলা, এরার নাম অইলো, ");
INSERT INTO syl_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","রুবেন, শিমিয়ন, লেবি, এহুদা, ");
INSERT INTO syl_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ইছাখর, সবুলন, বিন-ইয়ামিন, ");
INSERT INTO syl_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","দান, নপ্তালি, ছাদু আর আশির। ");
INSERT INTO syl_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","ইয়াকুবর বংশর হক্কলতায় মিলিয়া সত্তইর জন আছলা। আর ইউছুফ আগ থাকিউ মিসরো থাকতা। ");
INSERT INTO syl_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","বাদে ইউছুফ, তান ভাইয়াইন, আর হি আমলর হকল মারা গেলা। ");
INSERT INTO syl_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","অইলে তারার বাদর বংশধর বাড়িয়া খুব বলআলা অইলা। এরা চাইরোবায় ছিতরিয়া আস্তা মিসর দেশ ভরিগেলা। ");
INSERT INTO syl_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","এরমাজে মিসরো একজন নয়া বাদশা অইলা, এইন ইউছুফরে চিনইন না। ");
INSERT INTO syl_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","এইন নিজর প্রজা অকলরে কইলা, “চাইয়া দেখো, বনি ইছরাইল আমরা থাকি বেশিও আর বলআলাও। ");
INSERT INTO syl_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","তে আও, আমরা এক ফন্দি করি, ইতা যেনু আর না বাড়ইন। আরনায় তারা বাড়িয়া হেশে যুদ্ধর কালো আমরার দুশমনর লগে মিলিয়া আমরার বিরুদ্ধে যুদ্ধ করবো, বাদে আমরার দেশ থাকি যাইবোগি।” ");
INSERT INTO syl_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","তেউ তারা সর্দার লাগাইলা এরারে মারিয়া-ধরিয়া জুর-জুলুম করিয়া কাম করানির লাগি। এরা ফেরাউনর ফসল রাখার লাগি পীথুম আর রামাষেষ নামর দুইটা টাউনও বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","অইলে এরার উপরে যত বেশি জুর-জুলুম করা অইলো, এরাও অতো বেশি বাড়িলা আর ছিতরিলা। এরলাগি মিসরী অকলে বনি ইছরাইলরে খুব ডরাইগেলা। ");
INSERT INTO syl_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ডরাইয়া এরারেদি আরো কঠিন কাম করাইলা। ");
INSERT INTO syl_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","মাটি কাম, ইটর কাম আর খেতর মাজে কষ্টর কাম করাইয়া এরার জানরে তিত্বা বানাইলিলো। আর তারা জুর-জুলুম করিয়া নিষ্ঠুর-পাষানর লাখান কাম করাইতো। ");
INSERT INTO syl_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","বাদে মিসরর বাদশায় শিফ্রা আর ফুয়া নামর দুইজন ইবরানি দাই বেটিরে হুকুম দিলা, ");
INSERT INTO syl_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“তুমরা ইবরানি বেটিন্তর দাই গিরিত গিয়া, ইতার পুয়াইন পয়দা অইলেউ মারিলাইও, খালি পুড়িন্তরে জিতা রাখিও।” ");
INSERT INTO syl_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","অইলে হি দাই বেটিন্তে আল্লারে ডরাইতা গতিকে, মিসরী বাদশার হুকুম না মানিয়া পুয়াইন্তরেও জিতা রাখতা। ");
INSERT INTO syl_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","তেউ বাদশায় এরারে নিয়া জিকাইলা, “ইতা কাম কেনে করলায়? পুয়াইন্তরে কেনে জিতা রাখলায়?” ");
INSERT INTO syl_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","তারা জুয়াপ দিলা, “ইবরানি বেটিন মিসরী বেটিন্তর লাখান নায়, তারা বউত বলআলা। দাইবেটি তারার কাছাত যাইবার আগেউ তারার হুরুতা পয়দা অইযায়।” ");
INSERT INTO syl_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","অউ দুইও বেটিয়ে আল্লারে ডরাইতা করি, আল্লায় রহমত করিয়া তারারেও আওলাদ দিলা। আর বনি ইছরাইলও আরো বেশি করি বাড়িয়া খুব শক্তিমান অইলা। ");
INSERT INTO syl_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ইতা দেখিয়া ফেরাউনে নিজর প্রজা অকলরে হুকুম দিলা, “ইবরানি অকলর কুনু পুয়াইন অইলেউ তুমরা নীল নদো ফালাই দিও, খালি পুড়িন্তরে জিতা রাখিও।” ");
INSERT INTO syl_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","এরমাজে লেবি খান্দানর একজন মানষে, তান নিজর খান্দানর এক কইনারে শাদি করলা। ");
INSERT INTO syl_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","অউ কইনার ঘরো এক পুয়ার জনম অইলো। পুয়াগু দেখতে খুব সুন্দর অওয়ায়, তিন মাস ধরি লুকাই রাখলা। ");
INSERT INTO syl_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","হেশে আর লুকাইতা না পারিয়া, তাইন নল-খাগড়ার এক টুকরি লইলা। অউ টুকরিত মাটিয়া তেল আর আলকাতরা লেপিয়া অগুর ভিতরে হুরুতারে হারাইয়া, গাংগর চরর নল বনর মাজে থইয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","আর এর কিতা দশা অয় দেখার লাগি, তার বইন দুরই উবাইলো। ");
INSERT INTO syl_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","থুড়া বাদে ফেরাউনর পুড়ি গাংগো নাওয়াত আইলা। গাংগর পারো তান বান্দি অকল ঘুরাঘুরিত আছিল। তাইন চরর নল-খাগড়ার মাজে অউ টুকরি দেখিয়া, তান বান্দিরে কইলা, “অউ টুকরিগু আন।” ");
INSERT INTO syl_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","টুকরির ডালা খুলিয়া দেখলা, এর ভিতরে এক পুয়ায় কান্দের। দেখিয়া তান মায়া লাগিগেল। তাইন কইলা, “ইস, ইগু তো কুনু ইবরানির পুয়া।” ");
INSERT INTO syl_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","অউ সময় পুয়ার বইন আইয়া ফেরাউনর পুড়িরে জিকাইলো, “রানী মা, ই হুরুতারে দুধ খাওয়ানির লাগি কুনু ইবরানি বেটিরে পাইলে আপনার গেছে আনতাম নি?” ");
INSERT INTO syl_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","ফেরাউনর পুড়িয়ে কইলা, “যা আনগি।” তেউ পুড়িয়ে গিয়া পুয়ার মাʼরে লইয়া আইলো। ");
INSERT INTO syl_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ফেরাউনর পুড়িয়ে তানরে কইলা, “ওগো, আমি তুমার বেতন দিমুনে, তুমি আমার অইয়া অউ পুয়াগুরে বুকুর দুধ খাওয়াও।” অউ হি বেটিয়ে নিয়া হুরুতারে দুধ খাওয়াইয়া পালিলা। ");
INSERT INTO syl_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","পুয়াগু কিছু বড় অওয়ার বাদে তাইন নিয়া ফেরাউনর পুড়ির গেছে দিলাইলা। ফেরাউনর পুড়িয়ে এনরে নিজর পুয়া বানাইয়া পালিলা। তাইন কইলা, “আমি তারে পানি থাকি টানিয়া তুলছি।” এরলাগি তার নাম রাখলা মুছা মানি, টানিয়া তুলা। ");
INSERT INTO syl_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","হেশে মুছা বড় অইগেলে একদিন তান নিজর জাতির ভাইয়াইন্তর গেছে গিয়া দেখলা, তারা খুব কষ্টর কাম কররা। এরমাজে দেখলা, তান নিজর ইবরানি জাতির এক বেটারে, এক মিসরীয়ে মাইর-ধইর করের। ");
INSERT INTO syl_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","দেখিয়া চাইরোবায় চাইয়া আর কুনু মানুষ না দেখায়, তাইন হউ মিসরীরে খুন করিয়া বালুর তলে গাড়িল্লা। ");
INSERT INTO syl_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","বাদর দিনও তাইন হিরবার বারে গেলা। গিয়া দেখলা, দুইজন ইবরানিয়ে নিজে নিজে মারামারি করের। অউ তাইন দুষি জনরে কইলা, “ওবা, তুমার ভাইরে কেনে মাররায়?” ");
INSERT INTO syl_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","হে কইলো, “তুমারে খেগিয়ে আমরার হাকিম বানাইয়া বিচার করাত পাঠাইলো? কাইল যেলা হউ মিসরীরে খুন করছো, অউলা আমারেও খুন করিলতায় চাইরায় নি?” অউ মুছায় ডরাইগেলা। তাইন বুজলা ইতা তো জানা-জানি অইগেছে। ");
INSERT INTO syl_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","আর ফেরাউনেও ইতা হুনিয়া মুছারে মারিলতা চাইলা। অউ সময় মুছা ফেরাউনর গেছ থাকি বাগি গেলা। বাগিয়া মাদিয়ান দেশো বসত করার লাগি আইলা। আইয়া হনর এক কুয়ার কাছাত বইলা। ");
INSERT INTO syl_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","মাদিয়ান দেশো শোয়াইব নামর এক ইমাম ছাব আছলা। তান সাতজন পুড়িন আছইন। অউ পুড়িন্তে কুয়ার পারো আইয়া, তারার বাফর ছাগল-মেড়ারে পানি খাওয়ানির লাগি গামলা ভরাত লাগলা। ");
INSERT INTO syl_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","অউ সময় অইন্য রাখাল অকলে তারারে খেদাইয়া দিলাইলো। অইলে মুছা উবাইয়া তারারে সাইয্য করলা, আর তারার পালরে পানি খাওয়াইলা। ");
INSERT INTO syl_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","তারা তারার বাফর ধারো গিয়া হারলে তাইন জিকাইলা, “তুমরা আইজ অতো জলদি কেমনে আইলায়?” ");
INSERT INTO syl_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","তারা কইলা, “এক মিসরী বেটায় আমরারে রাখাল অকলর আত থাকি বাচাইছইন। এইন আমরার ছাগল-মেড়ারে পানি তুলিয়া খাওয়াইছইন।” ");
INSERT INTO syl_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","তেউ তাইন জিকাইলা, “ই মানুষগু কুয়াই? তুমরা তারে থইয়া আইল্লায় কেনে? এরে ডাকিয়া আনিয়া খানা খাওয়াও।” ");
INSERT INTO syl_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","এরবাদে মুছায় অউ ইমামর বাড়িত রইতে রাজি অইলা। ইমাম ছাবে তান পুড়ি সফুরারে মুছার লগে শাদি দিলা। ");
INSERT INTO syl_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","বাদে সফুরার ঘরো এক পুয়া অইলে মুছায় কইলা, “আমি তো বৈতল বনিয়া বিদেশো রইরাম।” এরলাগি অউ পুয়ার নাম রাখলা যারছুম মানি, বৈতল। ");
INSERT INTO syl_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","বউত দিন বাদে মিসরর বাদশা মরিগেলা। বনি ইছরাইলে গুলামির লাগি কাতর অইয়া কান্দা-কাটি করলো। তারার কান্দন আল্লার গেছে কবুল অইগেল। ");
INSERT INTO syl_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","আল্লায় তারার ফরিয়াদ হুনলা। তাইন ইব্রাহিম, ইছহাক আর ইয়াকুবর লগে তান ওয়াদার কথা ইয়াদ করলা। ");
INSERT INTO syl_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","আর বনি ইছরাইলর বায় মুখ ফিরাইলা, দয়ার নজরে তারার বায় চাইলা। ");
INSERT INTO syl_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","অউ সময় মুছায় তান হউর মাদিয়ান জাতির ইমাম ছাব হজরত শোয়াইবর ছাগল-মেড়া রাখতা। একদিন তান ছাগলর পাল লইয়া মরুভুমির হেশ গালাত আল্লার হউ তুর পাহাড়র কাছাত গেলা। ");
INSERT INTO syl_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","হনো এক জংলার মাজে মাবুদর ফিরিস্তায় আগুনির লাখান নুরর মাজ থাকি তানরে দেখা দিলা। মুছায় দেখলা, জংলার মাজে আগুইন জলের অইলে জংলা জলের না। ");
INSERT INTO syl_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","অউ তাইন তাইজ্জুব অইয়া কইলা, “জংলা যে জলের না, এর কারন কিতা? তে আরো কাছাত গিয়া দেখিছাইন।” ");
INSERT INTO syl_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","আল্লায় যেবলা দেখলা এইন দেখার লাগি কাছাত যাইরাগি, অউ সময় তাইন জংলার মাজ থাকি ডাকিয়া কইলা, “মুছা, ও মুছা!” মুছায় কইলা, “অউনু আমি।” ");
INSERT INTO syl_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","আল্লায় কইলা, “আর ছামনে আগুয়াইও না। তুমার পাও থাকি জুতা খুলিলাও। জানো নি, তুমি অখন যে জাগাত উবাইছো ইখান পাক জাগা। ");
INSERT INTO syl_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","হুনো, আমি আল্লাউ তুমার বাফর মাবুদ, ইব্রাহিমর মাবুদ, ইছহাকর মাবুদ আর ইয়াকুবরও মাবুদ।” ইখান হুনিয়াউ মুছায় তান মুখ লুকাইল্লা। আল্লার বায় চাইতে তান দিলো ডর হামাইগেল। ");
INSERT INTO syl_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","মাবুদে কইলা, “আমি মিসর দেশো আমার বন্দা অকলর দুখ-মছিবত দেখিয়ার। মিসরী সর্দার অকলর জুলুমর লাগি তারার কান্দন হুনিয়ার। তারার দুখ-কষ্ট হকলতা আমি দেখছি। ");
INSERT INTO syl_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","দেখিয়া মিসরী অকলর আত থাকি তারারে বাচাইতাম করি আমি নিজে লামিয়া আইছি। তে আমি তারারে মিসর থাকি হরাইয়া নিমুগি। নিয়া রসাইল জমির বউত বড় সুন্দর এক দেশ দিমু। ইখান দুধ আর মউর ভান্ডার আলা দেশ। অউ দেশ অইলো অখনকুর কেনানী, হিট্টী, আমোরী, ফারিজী, হিব্বী আর যিবুজী অকলর দেশ। ");
INSERT INTO syl_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","বনি ইছরাইলর ফরিয়াদ আমার দরবারো আইছে, মিসরী অকলে তারারে যেলা ছাতাইরা, ইতা আমি দেখিয়ার। ");
INSERT INTO syl_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","এরলাগি আমি তুমারে ফেরাউনর গেছে পাঠাইয়ার। তুমি যাও, গিয়া আমার বন্দা বনি ইছরাইলরে মিসর থাকি বার করিয়া আনো।” ");
INSERT INTO syl_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","মুছায় জুয়াপ দিলা, “আমি আরক জন কে, যেইন ফেরাউনর ছামনে গিয়া মিসর দেশ থাকি তারারে হরাইতাম পারমু?” ");
INSERT INTO syl_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","আল্লায় কইলা, “আমি তো তুমার লগে লগে রইমু। তুমি মিসর থাকি মানষরে হরাইয়া আনিয়া, তারারে লইয়া অউ পাহাড়ো আমার এবাদত করবায়। তেউ বুজবায় আমিউ তুমারে পাঠাইছি।” ");
INSERT INTO syl_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","মুছায় আরজ করলা, “দেখউক্কা, আমি যেবলা বনি ইছরাইলরে গিয়া কইমু, তুমরার বাফ-দাদার মাবুদে আমারে পাঠাইছইন, অউ সময় তারা যুদি জিকাইন তান নাম কিতা, তে তারারে কিতা জুয়াপ দিতাম?” ");
INSERT INTO syl_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","আল্লায় কইলা, “আমি যেইন আছি, আছিউ। বনি ইছরাইলরে অউলা কইও, যেন নাম ‘আমি আছি’ তাইন আমারে তুমরার গেছে পাঠাইছইন।” ");
INSERT INTO syl_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","তাইন আরো কইলা, “তুমি গিয়া তারারে কইও, ‘হউ আল্লা যেইন হর-হামেশা আছইন, এইন তুমরার বাফ-দাদার মাবুদ, ইব্রাহিমর মাবুদ, ইছহাকর মাবুদ আর ইয়াকুবরও মাবুদ, এইনউ আমারে তুমরার গেছে পাঠাইছইন।’ “আমার হর-হামেশাকুর নাম ‘আমি যেইন আছি’। যুগে যুগে, পুরুষে পুরুষে অউ নাম কাইম রইবো। ");
INSERT INTO syl_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","তুমি যাও, গিয়া বনি ইছরাইলর মুরব্বি অকলরে একখানো দলা করিয়া কও, হউ আল্লা, যেইন তুমরার বাফ-দাদার মাবুদ, ইব্রাহিম, ইছহাক আর ইয়াকুবর মাবুদ, তাইন আমারে দিদার দিয়া কইছইন, তাইন তুমরার বায় খিয়াল করছইন, তুমরার উপরর জুলুম-মছিবত দেখছইন, মিসর দেশো তুমরার বায় যেতা করা অর এওতা তাইন খিয়াল করছইন। ");
INSERT INTO syl_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","অখন তাইন কইরা, মিসরর গুলামি থাকি তুমরারে বাচাইয়া কেনানী, হিট্টী, আমোরী, ফারিজী, হিব্বী আর যিবুজী অকলর দুধ আর মউর ভান্ডার আলা দেশো তাইন তুমরারে নিবাগি।” ");
INSERT INTO syl_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","আল্লায় আরো কইলা, “বনি ইছরাইলর মুরব্বি অকলে তুমার কথা হুনবা, তুমি তারারে লগে লইয়া মিসরর বাদশার গেছে যাইও। গিয়া কইও, ‘আল্লা যেইন ইবরানি অকলর মাবুদ, তাইন আমারে দরশন দিছইন। এরলাগি আমরা তান নামে একখান কুরবানি করতাম চাইয়ার, আমরা মরুভুমির বায় তিন দিনর পথ গিয়া কুরবানি দিমু, তে আমরারে যাওয়ার অনুমতি দেউক্কা।’ ");
INSERT INTO syl_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","অইলে আমি জানি মিসরর বাদশায় তুমরারে যাইতে দিতো নায়, জুর-জবরদস্তি করলেও দিতো নায়। ");
INSERT INTO syl_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","তেউ আমি আমার কুদরতি আত লাগাইমু আর অউলা আচানক গজব নাজিল করমু, যাতে হে তুমরারে যাইতে দেয়। ");
INSERT INTO syl_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","আর আমি মিসরী অকলর দিলর মাজে বনি ইছরাইলর বায় এমন এক দয়ার ভাব পয়দা করাইমু, এরা যানু মিসর থাকি খালি আতে না যাইন। ");
INSERT INTO syl_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","হকল ইছরাইলি বেটিন্তে তারার আরি-ফরি বা যেরার বাড়িত তারা রইন, অউলা মিসরী বেটিন্তর গেছ থাকি তারার সোনা-রুপার গয়না-গাটি আর ভালা কাপড়-চুপড় খুজিয়া নিও। অতা দিয়া তুমরার পুয়া-পুড়িনরেও হাজাইও, অউ নমুনায় তুমরা মিসরীন্তর ধন-ছামানা দখল করবায়।” ");
INSERT INTO syl_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","মুছায় জুয়াপ দিলা, “ও মাবুদ, তারা যুদি আমারে একিন না করইন, আমার মাত না হুনইন বা তারা যুদি কইন, মাবুদে তুমারে দরশন দিছইন না, তে আমি কিতা করতাম?” ");
INSERT INTO syl_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","তেউ আল্লায় তানে জিকাইলা, “তুমার আতো ইগু কিতা?” তাইন কইলা, “এগু লাঠি।” ");
INSERT INTO syl_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","আল্লায় কইলা, “অকটা মাটিত ফালাও।” মুছায় লাঠিরে মাটিত ফালাইতেউ ইটা হাফ অইগেল। হাফ দেখিয়াউ তাইন ফালদি হরি গেলা। ");
INSERT INTO syl_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","আল্লায় তানে হুকুম করলা, “আত বাড়াইয়া অগুর লেনজো ধরো।” আর তাইন ধরার লগে লগে অগু হিরবার লাঠি অইগেল। ");
INSERT INTO syl_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","বাদে আল্লায় কইলা, “তুমিও অউলা করিও, তেউ তারা হাছাউ একিন করবা তারার বাফ-দাদাইন্তর মাবুদ, ইব্রাহিমর মাবুদ, ইছহাকর মাবুদ আর ইয়াকুবর মাবুদে তুমারে দরশন দিছইন।” ");
INSERT INTO syl_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","আল্লায় আরো কইলা, “তুমার আত তুমার চাদ্দরর তলে হারাও।” তাইন আত হারাইলা, আর বার করার বাদেউ তান আত কুষ্ঠ-ধলবেদা বেমারে দুধর লাখান ধলা অইগেল। ");
INSERT INTO syl_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","আল্লায় কইলা, “তুমার আত হিরবার হনো হারাও।” তাইন হারাইলা আর চাদ্দরর তল থাকি বার করিয়া দেখইন, আগর লাখান ভালা অইগেছে। ");
INSERT INTO syl_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","আল্লায় কইলা, “তারা যুদি তুমারে একিন না করইন, তে তুমার লাঠিরে হাফ অওয়া দেখলে একিন করবা, আর এওটায় একিন না করলে তুমার আতর বেমারর কেরামতি দেখলে তারা একিন করবা। ");
INSERT INTO syl_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","আর যুদি ই দুইও কেরামতিয়েও একিন না করইন, তুমার কথা না মানইন, তে তুমি নীল নদ থাকি থুড়া পানি আনিয়া হুকনা মাটিত ফালাইও, দেখবায় মাটিত পড়িয়াউ ই পানি লউ অইযিবো।” ");
INSERT INTO syl_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","অউ মুছায় মাবুদরে কইলা, “ও মালিক, আমি তো ভালা করি মাত-কথাউ মাততাম পারি না, আগেও পারতাম না আর আপনে ই গুলামর লগে বাতচিত করার বাদেও পারি না, আমার তো জিফরা বাড়ুয়া।” ");
INSERT INTO syl_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","আল্লায় কইলা, “মানষর মুখ কে বানাইছে, আমি নায় নি? কে মানষরে বোবা, খালুয়া বা আন্দা বানাইন? চউখে দেখার লাগি চখুর পাওয়ার কে দেইন? ইতা তো আমি আল্লায়উ দেই না নি? ");
INSERT INTO syl_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","তে তুমি যাও, গিয়া কিতা মাতিতায় আমি হিকাইয়া দিমু। তুমার মুখর জবানরে আমি সাইয্য করমু।” ");
INSERT INTO syl_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","তাইন কইলা, “ও মালিক, আমি মিনত করিয়ার, অইন্য কেউররে পাঠাই দেউক্কা।” ");
INSERT INTO syl_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","অউ মুছার উপরে মাবুদর গুছা উঠলো। তাইন কইলা, “তুমার ভাই হারুন বিন লেবি আছে না নি? আমি জানি, হে ভালা বখতিতা দিতো পারে। হে অখন তুমার লগে দেখা করাত আর, তুমারে দেখিয়া হে খুব খুশি অইবো। ");
INSERT INTO syl_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","তুমি হিকাইয়া দিও আর কইও হে কিতা মাতিতো। আমি তুমরা দুইওজনর মুখর জবানরে সাইয্য করমু। আর হনো গিয়া কিতা করতায় আমি হিকাইয়া দিমু। ");
INSERT INTO syl_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","তুমার ভাই হারুনর মুখ অইবো তুমার মুখ, হে তুমার অইয়া মানষর লগে মাতিবো। পেগাম্বর অকলে যেলা আল্লার কালাম কইন, হারুনে অউলা তুমার বুলি কইবো। ");
INSERT INTO syl_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","অউ লাঠি তুমার আতো রাখিও, ইটা দিয়া হউ কেরামতি-মোজেজা অকল জাইর করবায়।” ");
INSERT INTO syl_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","19","মাদিয়ান দেশো থাকতেউ মাবুদে মুছারে হুকুম করছলা, “তুমি মিসরো যাওগি, কারন মিসরর যেতা মানষে তুমারে খুন করতা চাইছলা, ইতা অখন মরি গেছইন।” তেউ মুছায় তান হউর শোয়াইবর কাছাত গিয়া কইলা, “আমি আমার জনম মাটি মিসর দেশো যাইতাম চাইরাম, আমার খেশ-কুটুম অকল জিতা আছইন কি না, তারার হাল-হকিকত দেখাত যাইতাম, তে আমারে যাওয়ার অনুমতি দেউক্কা।” হউরে কইলা, “আইচ্ছা, ছহি-ছালামতে যাও।” ");
INSERT INTO syl_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","অউ মুছায় তান বিবি আর পুয়াইন্তরে গাধার উপরে চড়াইয়া মিসরর পথে রওয়ানা অইলা। তান আতো আল্লাই কেরামতির হউ লাঠি রাখলা। ");
INSERT INTO syl_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","আল্লায় মুছারে হুকুম দিলা, “তুমি মিসরো গিয়া হারলে আমার দেওয়া কেরামতি অকল ফেরাউনর ছামনে দেখাইও, অইলে আমি তার দিলরে পাষান বানাইলিমু, হে মানষরে ছাড়তো নায়। ");
INSERT INTO syl_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","তুমি ফেরাউনরে কইও, মাবুদে নিজে কইছইন, ‘বনি ইছরাইল তো আমার পয়লা পুতর লাখান। ");
INSERT INTO syl_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","আমি নিজে তুমারে হুকুম করছলাম, আমার এবাদতো যাইতা করি তুমি আমার পুতরে ছাড়ি দিতায়, অইলে তুমি মানছো না। এরদায় আমিও তুমার পয়লা পুতরে মারিলিমু।’ ” ");
INSERT INTO syl_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","বাদে মিসরো যাওয়ার পথো রাইত কাটাইবার জাগাত আইলে মাবুদে মুছারে মারিলিতা করি মুখামুখি অইলা। ");
INSERT INTO syl_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","অইলে তান বিবি সফুরায় একখান ধারাইল পাথর লইয়া তান পুয়ার মছলমানি করাইল্লা আর অকটা তান জামাই মুছার পাওর মাজে ছোয়াইয়া কইলা, “লউর বদলা আমি তুমারে জামাই হিসাবে পাইছি।” ");
INSERT INTO syl_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","তেউ মুছারে মাবুদে ছাড়িদিলা। মছলমানি কামর বেয়াপারে সফুরায় তো অউ কথাউ কইছলা। ");
INSERT INTO syl_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","এরমাজে মাবুদে হারুনরে কইলা, “তুমি মরুভুমিত গিয়া মুছার লগে দেখা করো।” অউ তাইন গেলা আর আল্লার পাহাড় তুরর গেছে আইয়া মুছারে পাইয়া চুমা দিলা। ");
INSERT INTO syl_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","আর মাবুদে যেতা যেতা কইবার লাগি মুছারে হুকুম দিছলা, মুছায় ইতা হক্কলতা হারুনরে জানাইলা। মাবুদে যত লাখান কেরামতি-মোজেজা দেখানির হুকুম দিছইন, ইতা হকলতাউ তাইন হারুনরে বুজাইলা। ");
INSERT INTO syl_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","বাদে মুছা আর হারুন মিসর দেশো গিয়া বনি ইছরাইলর হকল মুরব্বিরে দলা করলা। ");
INSERT INTO syl_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","মাবুদে মুছারে যততা কইছলা, হারুনে ইতা হকলতা তারারে জানাইলা, আর হউ কেরামতি অকলও মানষর ছামনে দেখাইলা। ");
INSERT INTO syl_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","এরলাগি মানষে ইতা একিন করলা। তারা যেবলা হুনলা, মাবুদে তারার বায় খিয়াল করছইন, তারার উপরর জুলুম-মছিবত দেখছইন, অউ তারা তানরে সইজদা করলা। ");
INSERT INTO syl_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","মুছা আর হারুনে গিয়া ফেরাউনরে কইলা, “মাবুদ, যেইন বনি ইছরাইলর আল্লা, তাইন নিজে কইছইন, আমার বন্দা অকলরে তুমি ছাড়ি দেও, আমার নামে হজ করার লাগি, তারা মরুভুমিত হিজরত করতে অইবো, তুমি তারারে ছাড়ো।” ");
INSERT INTO syl_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","ফেরাউনে জুয়াপ দিলো, “ই মাবুদ আরক জন কে, যেন হুকুম মানিয়া আমি বনি ইছরাইলরে ছাড়ি দিতাম? ইলা কুনু মাবুদরে আমি চিনি না, আর বনি ইছরাইলরেও আমি ছাড়তাম নায়।” ");
INSERT INTO syl_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","তারা কইলা, “ইবরানি অকলর আল্লায় আমরারে দরশন দিছইন। এরলাগি আমরা মিনত করিয়ার আমরারে মরুভুমির বায় তিন দিনর পথ গিয়া, আমরার মাবুদ আল্লার নামে কুরবানি করতে দেউক্কা, আরনায় তাইন আমরারে গজবি বেমার দিয়া বা যুদ্ধর মাজে ফালাইয়া মারিলাইবা।” ");
INSERT INTO syl_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","মিসরর বাদশায় জুয়াপ দিলা, “ও মুছা আর হারুন, তুমরা মানষরে কেনে কামো থাকি ফিরাইরায়? যাও, তুমরাও গিয়া কামো লাগো। ");
INSERT INTO syl_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","দেখরায় নি, দেশো তুমরার মানুষ বউত বাড়িগেছইন, আর তুমরার লাই পাইয়া ইতায় কুনু কাম কররা না।” ");
INSERT INTO syl_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","অউ ফেরাউনে হউ দিনউ মিসরী জালিম সর্দার আর ইবরানি ছুবেদার অকলরে হুকুম করলা, ");
INSERT INTO syl_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“ইট বানাইবার লাগি তুমরা মানষরে আগর লাখান খের-নেরা আনিয়া দিও না, তারা গিয়া ইতা যোগাড় করউক। ");
INSERT INTO syl_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","অইলে আগে তারা যতখান ইট বানাইতো অখনও অতখান বানাইতে অইবো, একখানও কম অইতো নায়। ইতা আলসিয়া অইগেছইন করি, অনো আইয়া তারার আল্লার নামর কুরবানি করতা কইয়া চিল্লাইরা। ");
INSERT INTO syl_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","তুমরা তারারে আরো কষ্টর কামো লাগাও, তেউ ইতায় কুনু লাখান বাজে মাত না হুনিয়া কামর মাজে মন দিবা।” ");
INSERT INTO syl_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","অউ হি সর্দার আর ছুবেদার অকল বার অই গিয়া মানষরে কইলা, “ফেরাউনে কইছইন, অখন থাকি তাইন আর ইট বানানির খের যুগাই দিতা নায়। ");
INSERT INTO syl_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","তুমরা যেন থাকি পারো খের-নেরা যুগাইও, অইলে তুমরার কাম কুন্তাউ কমাইল অইতো নায়।” ");
INSERT INTO syl_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","অউ মানষে খের-নেরা তুকাইবার লাগি হারা মিসর দেশো ছিতরি গেলা। ");
INSERT INTO syl_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","আর সর্দার অকলে বারে বারে তাগদা দিয়া কইলো, “আগে খের যুগাইয়া দেওয়ার বালা তুমরা পরতেক দিন যতখান ইট বানাইতায়, অখনও অতখান বানাও।” ");
INSERT INTO syl_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ফেরাউনর জালিম সর্দার অকলে বনি ইছরাইলর উপরে যে ছুবেদার লাগাইছিল, হউ সর্দার অকল আইয়া ছুবেদার অকলরে মাইর-ধইর করিয়া জিকাইলো, “তুমরা আগে যতখান ইট দিতায়, অখন অতখান দেও না কেনে?” ");
INSERT INTO syl_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","অউ বনি ইছরাইলর ছুবেদার অকলে আইয়া ফেরাউনর গেছে নালিশ দিলা, “আপনার ই গুলাম অকলর লগে ইলা বেবহার কেনে কররা? ");
INSERT INTO syl_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","সর্দার অকলে আমরারে খের-নেরা যুগাই দেইন না, তা-ও ইট বানাইবার হুকুম দেইন আর আপনার ই গুলাম অকলরে মাইর-ধইর করইন, অইলে দুষ তো আপনার নিজর সর্দারর।” ");
INSERT INTO syl_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","ফেরাউনে জুয়াপ দিলো, “তুমরা আলসিয়া, কুড়িয়া, এরলাগি কইরায় মাবুদর নামে কুরবানি করাত যাইতাম। ");
INSERT INTO syl_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","যাও, কাম করো গিয়া। তুমরারে খের দেওয়া যাইতো নায়, তা-ও পরতেক দিন যতখান ইট বানাইবার কথা আছিল, অতখানউ বানাইতে অইবো।” ");
INSERT INTO syl_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","অউ বনি ইছরাইলর ছুবেদার অকলে বুজলা, তারা বিপদর মাজে পড়ছইন, কারন তারারে হুকুম করা অইছে, আগে যতখান ইট বানানি লাগতো, অখনও অতখান ইট বানাইতে অইবো, কম অইতো নায়। ");
INSERT INTO syl_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","তারা ফেরাউনর গেছ থাকি যাওয়ার পথো মুছা আর হারুনর লগে দেখা অইলো, এরা উবাইয়া বার চাওয়াত আছলা। ");
INSERT INTO syl_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","ছুবেদার অকলে কইলা, “মাবুদে আপনারার পাওনা সাজা দিবা, আপনারা ফেরাউন আর তার উজির-নাজিরর গেছে আমরারে পচা-গান্দা বানাইয়া, আমরারে খুন করার লাগি তলোয়ার নিয়া তারার আতো দিছইন।” ");
INSERT INTO syl_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","অউ মুছায় হিরবার গিয়া মাবুদর গেছে ফরিয়াদ করলা, “ও দীন দুনিয়ার মালিক, তুমি কেনে তুমার বন্দারে মছিবতো ফালাইলায়? আর আমারে কিতাল্লাগি পাঠাইলায়? ");
INSERT INTO syl_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","ফেরাউনর গেছে তুমার কথা হুনানির বাদ থাকিউ তুমার বন্দা অকলর উপরে জুলুম তো আরো বাড়িছে। অইলে তুমি তো কুন্তাউ করলায় না।” ");
INSERT INTO syl_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","মাবুদে মুছারে কইলা, “ফেরাউনর কিতা দশা অয় তুমি দেখিও, আমার আতর জুর দেখলেউ হে মানষরে ছাড়ি দিবো। জুরআলা আতর কুদরত দেখলেউ হে তার দেশ থাকি এরারে খেদাই দিবো।” ");
INSERT INTO syl_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","আল্লায় মুছার লগে বাতচিত করি কইলা, “আমার নামউ ‘আল্লা যেইন আছইন’। ");
INSERT INTO syl_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","আমি ইব্রাহিম, ইছহাক আর ইয়াকুবর গেছে সর্ব-শক্তিমান আল্লা নামে দিদার দিতাম, ‘আল্লা যেইন আছইন’ নামে তারারে দিদার দিতাম না। ");
INSERT INTO syl_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","আমি তারার লগে অউ ওয়াদা করছলাম, আমি তুমরারে কেনান দেশ দিমু, যে দেশো তুমরা মুছাফির অইয়া রও, অউ দেশউ আমি তুমরারে দিমু। ");
INSERT INTO syl_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","খাছ করি মিসরী অকলে বনি ইছরাইলরে গুলামি করানির লাগি এরার কান্দন হুনিয়া, আমার হউ ওয়াদা অখন ইয়াদ করলাম। ");
INSERT INTO syl_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","এরলাগি তুমি গিয়া বনি ইছরাইলরে কও, মাবুদে কইছইন, আমি মাবুদ, আমি তুমরারে মিসরী অকলর তল থাকি বার করিয়া আনমু, তারার গুলামি থাকি আজাদ করমু। তারারে দেখার মত সাজা দিয়া, আমার কুদরতি আতদি তুমরারে খালাছ করমু। ");
INSERT INTO syl_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","হেশে তুমরারে আমার নিজর বন্দা বানাইমু, আমি নিজে তুমরার আল্লা অইমু। তেউ তুমরা বুজবায়, আমি আল্লাউ তুমরার মাবুদ, আর মিসরী অকলর ভারর তল থাকি আমিউ তুমরারে বাচাইছি। ");
INSERT INTO syl_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","আমি ইব্রাহিম, ইছহাক, ইয়াকুবর লগে যে দেশর কথা ওয়াদা করছি, হউ দেশো তুমরারে লইয়া যাইমু, তুমরা হউ দেশর মালিক অইবায়। আমিউ মাবুদ।” ");
INSERT INTO syl_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","মুছায় গিয়া ইতা হকলতা তারারে জানাইলা, অইলে হি বেথায়া জুলুম-তকলিফ আর গুলামি করতে করতে মন-মরা অইযাওয়ায়, তারা আর মুছার মাতে কান দিলা না। ");
INSERT INTO syl_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","অউ মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“তুমি গিয়া মিসরর বাদশা ফেরাউনরে কও, হে যানু তার দেশ থাকি এরারে যাইতে দেয়।” ");
INSERT INTO syl_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","মুছায় জুয়াপ দিলা, “বনি ইছরাইলেউ যেবলা আমার মাত হুনের না, তে ফেরাউনে কিলা হুনবো? আর আমার তো মাততে মুখো লাগি যায়।” ");
INSERT INTO syl_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","তেউ মাবুদে মুছা আর হারুনরে কইলা, “তুমরা বনি ইছরাইল আর মিসরর রাজা ফেরাউনরে কও, মাবুদে আমরারে হুকুম দিছইন, বনি ইছরাইলরে মিসর থাকি বার করি নেওয়ার লাগি।” ");
INSERT INTO syl_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","বনি ইছরাইল জাতির মুল মুরব্বি অইলা হজরত ইয়াকুব, আল্লায় অউ ইয়াকুবর নয়া নাম দিছলা ইছরাইল। তান পুয়াইন অইলা রুবেন, শিমিয়ন, লেবি সহ মোট বারোজন। মুছা আর হারুন অইলা অউ হজরত লেবির বংশধর। ইছরাইলর বড় পুয়া রুবেনর পুয়াইন অইলা হনোক, ফালু, হাছির আর কর্মি, এরা তো রুবেন খান্দানর নানান গুষ্টির মুল মুরব্বি। ");
INSERT INTO syl_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","শিমিয়নর পুয়াইন অইলা যিমুয়েল, যামীন, ওহদ, যাখীন, সোহর আর তার কেনানী বউর তরফা পুয়া শৌল, এরা শিমিয়ন খান্দানর নানান গুষ্টির মুল মুরব্বি। ");
INSERT INTO syl_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","খান্দান তালিকা হিসাবে হজরত লেবির পুয়াইন অইলা জারছুন, কাহাত আর মারারি। লেবি একশো সাড়তিশ বরছ বাচিছলা। ");
INSERT INTO syl_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","যারযির গুষ্টির পরধান হিসাবে জারছুনর পুয়াইন অইলা লিবনি আর শিমেই। ");
INSERT INTO syl_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","কাহাতর পুয়াইন অইলা ইমরান, ইজহার, হেবরন আর উজ্জল। কাহাত একশো তেত্রিশ বরছ বাচিছলা। ");
INSERT INTO syl_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","মারারির পুয়াইন অইলা, মহলি আর মুশি। এরাউ অইলা লেবি খান্দানর নানান গুষ্টির মুল মুরব্বি। ");
INSERT INTO syl_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","ইমরানর পুয়াইন অইলা মুছা আর হারুন। ইমরানে তান ফুফু ইউখাবেজরে বিয়া করছলা, তান পেটো এরার জনম অইছিল। ইমরান একশো সাড়তিশ বরছ বাচিছলা। ");
INSERT INTO syl_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","ইজহারর পুয়াইন অইলা কুরাহ, নেফগ, জিখরি। ");
INSERT INTO syl_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","উজ্জলর পুয়াইন মিশায়েল, এলজাফন আর যিতরি। ");
INSERT INTO syl_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","আর হারুনে আমিনাদাবর পুড়ি নাহিশর বইন ইলিশেবারে বিয়া করায়, তান হুরুতা অইলা নাদাব, আবিহু, আলি-আজর আর ইছামার। ");
INSERT INTO syl_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","কুরাহর পুয়াইন অইলা অসীর, ইলকানা, অবিয়াসফ। এরা কুরাহী অকলর নানান গুষ্টির মুল মুরব্বি। ");
INSERT INTO syl_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","আলি-আজরর পুয়া অইলা পীনহস। হারুনর পুয়া আলি-আজরে পুটিয়েলর পুড়িরে বিয়া করায় তাইর পেটো পীনহসর জনম অইছিল। এরা অইলা লেবি খান্দানর নানান গুষ্টির মুল মুরব্বি। ");
INSERT INTO syl_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","অউ হারুন আর মুছারে মাবুদে হুকুম করছলা, তুমরা বনি ইছরাইলরে সিপাই দলর লাখান হাজিয়া মিসর থাকি বার করো। ");
INSERT INTO syl_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","মুছা আর হারুনেউ বনি ইছরাইলরে মিসর থাকি বার করি আনার কথা মিসরর বাদশা ফেরাউনর লগে মাতিছলা। ");
INSERT INTO syl_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","মাবুদে মুছার লগে যেদিন মিসর দেশো বাতচিত করলা, ");
INSERT INTO syl_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","হউ দিন তাইন কইলা, “আমি মাবুদ। তে তুমারে অখন যেতা যেতা কইমু, ইতা হকলতা তুমি মিসরর বাদশা ফেরাউনরে কইও।” ");
INSERT INTO syl_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","মুছায় মাবুদর দরবারো আরজ করলা, “দেখউক্কা, আমার তো মাততে মুখো লাগি যায়, ফেরাউনে কুনু আমার মাত হুনবো নি?” ");
INSERT INTO syl_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","অউ মাবুদে মুছারে কইলা “হুনো, আমি ফেরাউনর গেছে তুমারে আল্লার লাখান বানাইমু। আর তুমার ভাই হারুনরে বানাইমু তুমার নবী। ");
INSERT INTO syl_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","আমি তুমারে যেলা হুকুম করমু, তুমি অউলা হারুনরে কইবায়, আর হারুনে অতা ফেরাউনরে কইবো; যাতে হে বনি ইছরাইলরে তার দেশ থাকি ছাড়ি দেয়। ");
INSERT INTO syl_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","অইলে আমি ফেরাউনর দিলরে পাষান করিলিমু। মিসর দেশো আমি বউত কেরামতি আর কুদরতি লিলা-খেলা দেখাইমু। ");
INSERT INTO syl_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","তার বাদেও ফেরাউনে তুমরার মাতর দাম দিতো নায়। তেউ আমি মিসরর উপরে আমার আত লাগাইয়া, দেখার মত সাজা দিয়া মিসর দেশ থাকি আমার নিজর বন্দা বনি ইছরাইলরে সিপাইর লাখান দলে দলে বার করমু। ");
INSERT INTO syl_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","মিসরর মাজে আমার নিজর আত লাগাইমু, মিসরী অকলর মাজ থাকি বনি ইছরাইলরে বার করিয়া আনমু, অউদিন তারা বুজবা আমিউ মাবুদ।” ");
INSERT INTO syl_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","বাদে মুছা আর হারুনে অউলা করলা, মাবুদর হুকুম মাফিক কাম করলা। ");
INSERT INTO syl_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","ফেরাউনর লগে মাত-কথার সময় মুছার বয়স আছিল আশি, আর হারুনর তিরাশি বরছ। ");
INSERT INTO syl_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","অউ সময় মাবুদে মুছা আর হারুনরে কইলা, ");
INSERT INTO syl_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“ফেরাউনে যেবলা কইবো, তুমরার নিজর কুনু কেরামতি কাম দেখাও, তেউ তুমি হারুনরে কইও, তার লাঠি নিয়া ফেরাউনর ছামনে ফালাইতো, ফালানির লগে লগেউ ইটা হাফ অইযিবো।” ");
INSERT INTO syl_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","বাদে মুছা আর হারুন ফেরাউনর গেছে গেলা, গিয়া মাবুদর হুকুম মাফিক কাম করলা। হারুনে ফেরাউন আর তার উজির-নাজিরর ছামনে হউ লাঠি ফালানির লগে লগেউ ইটা হাফ অইগেল। ");
INSERT INTO syl_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","অউ ফেরাউনেও তার গুনিন আর যাদুগির অকলরে আনাইলো, তারাও তারার যাদু-মন্ত্র দিয়া অউলা দেখাইলা। ");
INSERT INTO syl_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","তারা হকলেউ যারযির লাঠি ছাড়লো, আর এওতা হাফ অইগেল, অইলে হারুনর লাঠিয়ে তারার হক্কল লাঠিরে গিলিলিলো। ");
INSERT INTO syl_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ইতা দেখিয়াও ফেরাউনর দিল পাষান রইলো, হে এরার মাতে কান দিলো না, যেলা মাবুদে আগে কইছলা। ");
INSERT INTO syl_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","বাদে মাবুদে মুছারে কইলা, “ফেরাউনর দিল তো পাষান, হে মানষরে ছাড়তে রাজি নায়। ");
INSERT INTO syl_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","তে তুমি বিয়ানি বালা ফেরাউনর গেছে যাইও, গেলে দেখবায় হে পানির গেছে যাইবো, তুমি তার লগে দেখা করার লাগি নীল নদর পারো উবাইও। তুমার যে লাঠি হাফ অইছিল, অউ লাঠি আতো করি নিও। ");
INSERT INTO syl_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","নিয়া তারে কইও, ‘মাবুদ, যেইন ইবরানি অকলর আল্লা, তাইন নিজে আমারে পাঠাইছইন আপনারে অখান কইতাম, তুমি আমার বন্দা অকলরে ছাড়ি দেও, তারা আমার বন্দেগি করার লাগি মরুভুমিত হিজরত করউক, তা-ও অখনও তুমি হুনরায় না। ");
INSERT INTO syl_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","এরলাগি অখন তুমি বুজবায়, আমিউ মাবুদ।’ অখান কইয়া হারি তুমি কইও, ‘দেখউক্কা, আমি নিজর আতর লাঠি দিয়া অউ নীল নদর পানিত বাড়ি মারমু, আর হক্কল পানি লউ অইযিবো। ");
INSERT INTO syl_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","হক্কল মাছ মরিযিবো আর পচা গন্দ বার অইবো, তেউ মিসরী অকলে অউ নীল নদর পানি খাইতা পারতা নায়।’ ” ");
INSERT INTO syl_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","মাবুদে মুছারে কইলা, “হারুনরে অউ কথা কও, তুমি নিজর লাঠি লইয়া মিসরী অকলর হক্কল পানির উপরে, দেশর গাং-নালা, খাল-বিল, আওর-বাওর চাইরোবায় তুমার আত বাড়াও, তেউ ইতার হক্কল পানি লউ অইযিবো। পাথর খুদিয়া বানাইল বা লাকড়ির পাতিল-কলসর মাজে থওয়া পানিও লউ অইযিবো।” ");
INSERT INTO syl_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","অউ মুছা আর হারুনে মাবুদর হুকুম মাফিক অউলা করলা, তাইন লাঠি উচা করি ফেরাউন আর তার উজির-নাজিরর ছামনে নীল নদর পানিত বাড়ি মারলা, তেউ হকল পানি লউ অইগেল। ");
INSERT INTO syl_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","নীল নদর হকল মাছ মরিগেল, হকল পানিত পচা গন্দ বার অইলো, মিসরী অকলে পানি আর খাইতা পারলা না, মিসর দেশর হকল পানি লউ অইগেল। ");
INSERT INTO syl_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","মিসরী যাদুগির অকলেও তারার যাদু-মন্ত্র ছাড়িয়া অউলা করলো, এতে ফেরাউনর দিল পাষান রইলো। হে এরার মাতো কান দিলো না, যেলা মাবুদে আগে কইছলা। ");
INSERT INTO syl_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","বাদে ফেরাউনে মুছা আর হারুনরে পিছ দিয়া তার রাজবাড়িত গেলগি, ইতা কুন্তাতউ কান দিলো না। ");
INSERT INTO syl_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","অইলে কুনু মিসরীয়ে গাংগর পানি খাইতে না পারায়, পানি খাওয়ার লাগি গাংগর পারর চাইরোবায় তারা গাত খুদিলা। ");
INSERT INTO syl_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","নীল নদর পানিত মাবুদর গজব নাজিল অওয়ার বাদে সাত দিন গুজরি গেল। ");
INSERT INTO syl_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","অউ সাত দিন বাদে মাবুদে মুছারে কইলা, “তুমি ফেরাউনর গেছে যাও, গিয়া তারে কও, মাবুদে নিজে কইরা, আমার খেজমত করার লাগি আমার বন্দা অকলরে ছাড়ি দেও। ");
INSERT INTO syl_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","তারারে না ছাড়িয়া কুনু বাধা দিলে, আমি বেঙ দিয়া তুমার আস্তা দেশো গজব ঢালমু। ");
INSERT INTO syl_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","আস্তা নীল নদ বেঙে ভরিযিবা, আর ইতা আইয়া তুমার রাজবাড়িত, হুতিবার ঘরো, তুমার বিছনাত উঠিবা। আর তুমার উজির-নাজিরর ঘরো, তুমার প্রজা অকলর ঘরো, তুমার উন্দাল আর পিঠা বানাইবার গামলাতও আইয়া হামাইবা। ");
INSERT INTO syl_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","তুমার, আর তুমার উজির-নাজিরর, আর প্রজা অকলর গতরো বেঙ উঠিবা।” ");
INSERT INTO syl_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","বাদে মাবুদে মুছারে কইলা, “হারুনরে কও, তুমি নীল নদ আর খাল-বিলর উপরে হউ লাঠি আলা আত বাড়াইয়া আস্তা মিসরো বেঙ আনাও।” ");
INSERT INTO syl_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","অউ হারুনে মিসরর হকল পানির উপরে তান আত বাড়াইলা, তেউ বেঙাইন্তে আইয়া মিসর দেশ ভরিয়া জাম অইগেলা, কুনু জাগা খালি রইলো না। ");
INSERT INTO syl_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","অইলে যাদুগির অকলেও তারার যাদু-মন্ত্র দিয়া মিসরো অউলা বেঙ আনলো। ");
INSERT INTO syl_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","বাদে ফেরাউনে মুছা আর হারুনরে আনাইয়া কইলা, “মাবুদর গেছে আরজ করো, তাইন আমার গেছ থাকি আর আমার প্রজা অকলর গেছ থাকি ই বেঙ অকল হরাইয়া নেউক্কা, তাইলে আমি মানষরে ছাড়ি দিমু, যাতে তারা গিয়া মাবুদর নামে কুরবানি করতো পারে।” ");
INSERT INTO syl_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","অউগি মুছায় ফেরাউনরে কইলা, “আপনে আমারে ঠিক করি কউক্কা, আমি কুন সময়কুর লাগি মিনতি করতাম, কুন সময় আপনার ঘর, আপনার উজির-নাজির আর প্রজা অকলর ঘর থাকি বেঙ অকল হরিয়া যাইতাগি, গিয়া খালি গাংগো রইতা?” ");
INSERT INTO syl_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","তাইন কইলা “কাইলকুর লাগি।” অউ মুছায় কইলা, “আপনার জবান মতউ অউক, যাতে আপনে বুজতা পারইন, আমরার মাবুদ আল্লার হমানি আর কেউ নাই। ");
INSERT INTO syl_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","বেঙাইন্তে আপনার গেছ থাকি, আপনার ঘর-বাড়ি থাকি, আপনার উজির-নাজির আর প্রজা অকলর ঘর থাকি হরিয়া গিয়া খালি নীল নদো রইবা।” ");
INSERT INTO syl_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","মুছা আর হারুন ফেরাউনর গেছ থাকি বারে গেলা, গিয়া মুছায় মাবুদর গেছে ফরিয়াদ করলা, ফেরাউনর উপর থাকি বেঙর গজব হরানির লাগি। ");
INSERT INTO syl_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","মাবুদে মুছার আরজি কবুল করায়, তারার বাড়ি-ঘর, উঠান আর বন্দর হকল বেঙ মরিগেল। ");
INSERT INTO syl_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","আর মানষে ইতারে জাগায় জাগায় দলা করলে, পচিয়া দেশো গন্দ বার অইলো। ");
INSERT INTO syl_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","অইলে ফেরাউনে যেবলা দেখলো, গজব তো হরিগেছে, অউ হে তার দিল পাষান করিল্লো। এরার মাতো আর কান দিলো না, যেলা মাবুদে আগে কইছলা। ");
INSERT INTO syl_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","বাদে মাবুদে মুছারে কইলা, “তুমি হারুনরে কও, তুমি তুমার লাঠি বাড়াইয়া মাটির ধুলিত বাড়ি মারো, তেউ ই ধুইল মশা অইয়া আস্তা মিসর দেশ ভরিযিবো।” ");
INSERT INTO syl_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","তারা অউলা করলা, হারুনে তান লাঠি আলা আত বাড়াইয়া মাটির ধুলিত বাড়ি মারলা, তেউ মাটির হক্কল ধুইল মশা অইগেল। অউ মশায় মানুষ, জানুয়ার আর মিসরর হক্কলবায় ভরিগেল। ");
INSERT INTO syl_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","আর যাদুগির অকলেও তারার যাদু-মন্ত্র দিয়া অউলা মশা বানাইতো চাইলো, অইলে পারলো না। মানুষ আর জানুয়ারর মাজে মশা রইলো। ");
INSERT INTO syl_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","তেউ যাদুগির অকলে ফেরাউনরে কইলা, “ইতা তো আল্লার কুদরত।” তা-ও ফেরাউনর দিল পাষান রইলো, হে এরার মাতে কান দিলো না, যেলা মাবুদে আগে কইছলা। ");
INSERT INTO syl_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","বাদে মাবুদে মুছারে কইলা, “তুমি ফজরে উঠিয়া ফেরাউনর গেছে আজির অও, গেলে দেখবায় হে পানির গেছে আইবো। তুমি তারে অউলা কইও, মাবুদে নিজে কইরা, আমার খেজমত করার লাগি তুমি আমার বন্দা অকলরে ছাড়ি দেও। ");
INSERT INTO syl_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","যুদি না ছাড়ো তাইলে আমি তুমার, তুমার উজির-নাজির, তুমার প্রজা অকলর উপরে, আর তুমার ঘরাইন্তর মাজে কামড়াওরা ডাশ-মাছির পাল পাঠাইমু, ইতা পালে পালে আইয়া মিসরী অকলর ঘরো আর তারার বসত-ভিটা সহ হকল জাগাত জাম অইযিবা। ");
INSERT INTO syl_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","অইলে আমি আমার বন্দা অকলর বসত খানা গোশন এলাকারে ইতা থাকি বাচাইমু, ইনো ডাশ-মাছির পাল আইতা নায়। তেউ তুমি বুজতায় পারবায়, আমি আল্লা ই দেশো আছি। ");
INSERT INTO syl_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","আমি তো আমার বন্দা আর তুমার প্রজার মাজে তফাত-পার্থক্য করমু, কাইল ই নমুনা দেখবায়।” ");
INSERT INTO syl_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","আর মাবুদে অউলা করলা, ফেরাউন আর তার উজির-নাজিরর ঘরো কামড়াওরা ডাশ-মাছির পাল আইলো, আস্তা মিসর দেশর হক্কলবায় ডাশ-মাছির লাগি সর্বনাশ অইগেল। ");
INSERT INTO syl_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","তেউ ফেরাউনে মুছা আর হারুনরে ডাকাইয়া কইলা, “তুমরা যাও, দেশর ভিতরে তুমরার আল্লার নামে কুরবানি করোগি।” ");
INSERT INTO syl_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","মুছায় কইলা, “ইলা করা ঠিক নায়, কারন আমরার মাবুদ আল্লার নামে মিসরী অকলর ঘিন্না করা কুরবানি করতে অইবো। আর দেখউক্কা, মিসরী অকলর ছামনে তারার ঘিন্না করা কুরবানি করলে তারা তো আমরারে পাথরদি ইটাইয়া মারিলিবা। ");
INSERT INTO syl_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","তে আমরার মাবুদ আল্লায় যেলা হুকুম করবা, আমরা মরুভুমির বায় তিন দিনর পথ হরিয়া গিয়া, তান নামে অউলা কুরবানি করমু।” ");
INSERT INTO syl_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","ফেরাউনে কইলা, “আমি তুমরারে ছাড়ি দিয়ার, তুমরা মরুভুমিত গিয়া তুমরার আল্লার কুরবানি করো। অইলে বেশি দুরই যাইও না, তুমরা আমার লাগিও মিনত করিও।” ");
INSERT INTO syl_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","অউ মুছায় কইলা, “দেখউক্কা, আমি আপনার গেছ থাকি হরিয়া গিয়া মাবুদর গেছে মিনতি করমু, তেউ কাইল আপনার গেছ থাকি, আপনার উজির-নাজির আর আপনার প্রজা অকলর গেছ থাকি ডাশ-মাছির পাল হরিযিবা। অইলে মানষে মাবুদর কুরবানি করাত যাইতে আপনে আর কুনু ভাওতাবাজি করইন না যানু।” ");
INSERT INTO syl_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","বাদে মুছায় ফেরাউনর গেছ থাকি গিয়া মাবুদর গেছে মিনতি করলা। ");
INSERT INTO syl_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","আর মাবুদে মুছার আরজি মাফিক কাম করলা। ফেরাউন, তার উজির-নাজির আর তার প্রজা অকলর গেছ থাকি হক্কল ডাশ-মাছি হরিগেলা, এগুও রইলো না। ");
INSERT INTO syl_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","অইলে হিরবার ফেরাউনে তার দিল পাষান করিল্লো, মানষরে ছাড়লো না। ");
INSERT INTO syl_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","বাদে মাবুদে মুছারে কইলা, “তুমি ফেরাউনর কাছাত গিয়া তারে কও, মাবুদ, যেইন ইবরানি অকলর আল্লা, তাইন নিজে কইরা, আমার এবাদত করার লাগি আমার বন্দা অকলরে ছাড়ি দেও। ");
INSERT INTO syl_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","তারারে ছাড়তে রাজি না অইয়া অখনও বাধা দিলে, ");
INSERT INTO syl_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","হুনিয়া রাখো, বন্দর মাজে তুমার পশুইন্তর উপরে, ঘোড়াইন্তর, গাধাইন্তর, উট, আর গরু-ছাগল, মেড়াইন্তর উপরেও আমি মাবুদে আত দিমু, বেথায়া বেমারর মরকি ছাড়িমু। ");
INSERT INTO syl_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","অইলে আমি মাবুদে মিসরর আর বনি ইছরাইলর পশুর মাজে তফাত করমু; বনি ইছরাইলর কুনু পশু মরতা নায়।” ");
INSERT INTO syl_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","আর মাবুদে সময়ও ঠিক করিয়া দিলাইলা, ছামনর কাইল তাইন দেশো ই কাম করবা। ");
INSERT INTO syl_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","হাছাউ বাদর দিন মাবুদে অউলাউ করলা, তেউ মিসরর হক্কল পশু মরিগেলা, অইলে বনি ইছরাইলর এগু পশুও মরলা না। ");
INSERT INTO syl_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ফেরাউনে মানুষদি খবর লইয়া দেখলো, বনি ইছরাইলর এগু পশুও মরছইন না; তা-ও তার দিল পাষান রইলো, হে মানষরে ছাড়লো না। ");
INSERT INTO syl_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","অউ মাবুদে মুছা আর হারুনরে কইলা, “তুমরা দুইওজনে মুইট ভরিয়া উন্দালর ছালি আনো, আনিয়া মুছায় অউ ছালিরে ফেরাউনর ছামনে উপরেদি ছিটাই দেও। ");
INSERT INTO syl_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","দেখবায়নে, ইতা হারা মিসর দেশর মাজে পাতলা ধুইল অইয়া হকল জাগার মানুষ আর পশুইন্তর গতরো গজবি বিষ-ফুরি অইবো।” ");
INSERT INTO syl_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","তেউ তারা উন্দালর ছালি আনিয়া ফেরাউনর ছামনে উবাইয়া, মুছায় উপরেদি ছিটাই দিলা, এতে মানষর আর পশুইন্তর গতরো বিষ-ফুরি ফুটিলো। ");
INSERT INTO syl_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","আর অউ ফুরির লাগি যাদুগির অকলে মুছার ছামনে উবাইতা পারলা না, হকল মিসরী আর যাদুগির অকলর গতরোও বিষ-ফুরি অইলো। ");
INSERT INTO syl_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","অইলে মাবুদে ফেরাউনর দিল পাষান করিল্লা। হে এরার মাতে কান দিলো না, যেলা মাবুদে আগে কইছলা। ");
INSERT INTO syl_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","বাদে মাবুদে মুছারে কইলা, “তুমি বিয়ানে উঠিয়া ফেরাউনর ছামনে উবাইয়া অউলা কইও, মাবুদ, যেইন ইবরানি অকলর আল্লা, তাইন নিজে কইরা, আমার এবাদত করার লাগি আমার বন্দা অকলরে ছাড়ি দেও। ");
INSERT INTO syl_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","নাইলে ইফিরা আমি তুমার, তুমার উজির-নাজির আর তুমার প্রজা অকলর মাজে আমার হক্কল জাতর গজব ছাড়িমু। তেউ তুমি বুজবায়, হারা দুনিয়াইত আমার হমানি কেউ নাই। ");
INSERT INTO syl_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","এর আগেউ আমি আমার আত বাড়াইয়া বেথায়া মরকি দিয়া তুমারে আর তুমার প্রজা অকলরে মারতাম পারলাম অনে, তুমি দুনিয়াই থাকি বিনাশ অইগেলায় অনে। ");
INSERT INTO syl_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","আসলে এরলাগিউ আমি তুমারে দুনিয়াইত অতদিন বাচাইছি, যাতে তুমারে আমার লিলা-খেলা দেখাই, আর হারা দুনিয়াইত আমার নাম জাইর অয়। ");
INSERT INTO syl_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","তুমি অখনও আমার বন্দা অকলরে ছাড়রায় না, তুমার বেটাগিরি দেখাইরায়, ");
INSERT INTO syl_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","তে দেখিও, কাইল ই সময়ে আমি অউ লাখান হিল-তুফান আর মেঘ দিমু, যেতা মিসরর জনম থাকি আইজ পর্যন্ত কুনুদিন অইছে না। ");
INSERT INTO syl_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","এরলাগি বন্দর মাজে তুমার পশুইন আর যততা আছে, ইতারে আনিয়া ঘরো হারাও; মানুষ বা পশুইন যেতা ঘরো হামাইতা নায়, ইতার উপরে হিল পড়িয়া হক্কলটি মরবা।” ");
INSERT INTO syl_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","তেউ ফেরাউনর উজির-নাজিরর মাজে যেরা মাবুদর জবানে ডরাইলা, তারা জলদি করি নিজর গুলাম আর পশুইন্তরে ঘরর ভিতরে আনাইলা। ");
INSERT INTO syl_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","অইলে মাবুদর জবানরে যেতায় দাম দিলো না, তারার গুলাম আর পশুইন্তরে বন্দর মাজে থইলো। ");
INSERT INTO syl_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","বাদে মাবুদে মুছারে কইলা, “তুমি আছমানর বায় নিজর আত বাড়াও, তেউ মিসরর হক্কল জাগাত হিল-তুফান অইবো, মিসরর মানুষ, পশু আর খেতর হকল গাছ-গাছালির উপরে ইতা পড়বো।” ");
INSERT INTO syl_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","অউ মুছায় তান আতর লাঠি উপরেদি তুললা, মাবুদে মিসর দেশর উপরে মেঘর ডাক-জিলকানির লগে হিল-তুফান দেওয়াইলা; আর আছমানি ঠাটা জমিনো পড়লো। ");
INSERT INTO syl_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","অউ হিলর লগে মেঘর জিলকানি আর ঠাটাও আছিল। ই লাখান গজবি হিল-তুফান মিসর দেশর জনম থাকি কুনুদিনও অইছে না। ");
INSERT INTO syl_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","হারা মিসর দেশর বন্দর মাজর হক্কল মানুষ আর পশুইন্তর উপরেও খুব জুরে জুরে হিল পড়লো, আর খেতর হকল ফসল নষ্ট অইগেল আর হকল গাছ-গাছালিও ভাংগি গেল। ");
INSERT INTO syl_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","খালি বনি ইছরাইলর বসত খানা গোশন এলাকাত হিল-তুফান অইলো না। ");
INSERT INTO syl_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","বাদে ফেরাউনে মানুষ পাঠাইয়া মুছা আর হারুনরে আনাইয়া কইলো, “ইফিরা আমি অপরাধ করছি। মাবুদ তো পাক-পবিত্র, অইলে আমি আর আমার প্রজা অকল অপরাধি। ");
INSERT INTO syl_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","তে গজবি মেঘর ডাক আর হিল-তুফান তো বউত অইছে, আর জারতাম পারিয়ার না। এরলাগি আমি অখন তুমরারে ছাড়ি দিমু, আর আটকাইতাম নায়। তুমরা আমার লাগি মাবুদর গেছে মিনত করো।” ");
INSERT INTO syl_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","মুছায় তারে কইলা, “আমি টাউনর বাইরে গিয়াউ মাবুদর গেছে আত তুলমু, তেউ মেঘর ডাক, হিল-তুফান বন্দ অইযিবো, যাতে আপনে বুজতা পারইন ই দুনিয়াই তো মাবুদর। ");
INSERT INTO syl_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","অইলে আমি তো জানি, আপনে বা আপনার উজির-নাজির অকলে অখনও আল্লা মাবুদরে ডরাইরা না।” ");
INSERT INTO syl_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","ই সময় খেতর হকল নালিয়া গাছ আর বার্লি ফসল নষ্ট অইগেল, কারন নালিয়া গাছর ফুল আর বার্লির ছড়া বার অইগেছিল। ");
INSERT INTO syl_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","অইলে কুনুজাতর গমর গাছ বড় না অওয়ায় ইতার খেতি অইলো না। ");
INSERT INTO syl_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","তেউ মুছায় ফেরাউনর ছামনে থাকি টাউনর বারে গিয়া মাবুদর গেছে আত তুললা, লগে লগে মেঘর ডাক, হিল-তুফান বন্দ অইলো, মেঘর জড়িও বন্দ অইগেল। ");
INSERT INTO syl_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","অইলে ফেরাউন আর তার উজির-নাজির অকলে মেঘ, মেঘর ডাক আর হিল পড়া বন্দ অইগেছে দেখিয়া তারার দিল পাষান করিল্লা। ফেরাউনে হিরবার গুনা করলো। ");
INSERT INTO syl_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","তার দিল পাষান অইযাওয়ায়, হে বনি ইছরাইলরে ছাড়লো না, মাবুদে আগে যেলা মুছারে কইছলা। ");
INSERT INTO syl_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","মাবুদে মুছারে কইলা, “তুমি ফেরাউনর গেছে যাও; আমি তো তার আর তার উজির-নাজিরর দিলরে পাষান করিলিছি, যাতে তারার ছামনে আমি আমার কুদরতি লিলা-খেলা দেখাইতাম পারি। ");
INSERT INTO syl_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","আমি মিসরী অকলর উপরে যেতা যেতা কঠিন গজব দিছি, তারার মাজে কুদরতি যেতা লিলা-খেলা জাইর করছি, তুমি ইতা তুমার আওলাদ আর নাতি-পুতির গেছে গফ করতায় পারো, আর আমিউ যেন মাবুদ ইটা বুজতায় পারো।” ");
INSERT INTO syl_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","তেউ মুছা আর হারুনে ফেরাউনর গেছে গিয়া কইলা, “আল্লা, যেইন ইবরানি অকলর মাবুদ, তাইন নিজে কইরা, তুমি আমার ছামনে মাথা নোয়াইতে আর কতদিন হরাইল রইতায়? হুনো, তুমি আমার বন্দা অকলরে আমার এবাদত করার লাগি ছাড়ি দেও। ");
INSERT INTO syl_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","তারারে ছাড়তে রাজি না অইলে দেখিও, আমি কাইল তুমার সীমানাত পংগপাল অকল ছাড়িমু। ");
INSERT INTO syl_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ইতায় আইয়া তুমার আস্তা জমিনরে অউলা বেরিলিবা, কুনু মানষে মাটি দেখতো পারতো নায়। হিল-তুফান থাকি যততা বাচিগেছে, খেতর মাজে যত গাছ-গাছালি রইছে, ইতা হক্কলতা তারা খাইলিবা। ");
INSERT INTO syl_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","তুমার নিজর ঘর-বাড়ি, তুমার উজির-নাজিরর ঘরাইন, আর হক্কল মিসরী অকলর ঘরাইন ভরিয়া জাম অইযিবা। তুমার ময়-মুরব্বি আর তারার বাফ-দাদা অকলেও দুনিয়াইত তারার জনম থাকি আইজ পর্যন্ত কুনুদিন অউলা দেখছইন না।” অখান কইয়াউ তাইন মুখ ফিরাইয়া ফেরাউনর গেছ থাকি বারে গেলাগি। ");
INSERT INTO syl_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","ফেরাউনর উজির-নাজিরে তারে কইলা, “ই বেটায় আর কতদিন আমরারে ছাতাইতো? অতার মাবুদ আল্লার এবাদতর লাগি অতারে ছাড়ি দেউক্কা। আপনে অখনও কুন্তা বুজরা না নি, আস্তা মিসর দেশনু ছারখার অইযার?” ");
INSERT INTO syl_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","অউ ফেরাউনে মুছা আর হারুনরে হিরবার আনাইলো, আনাইয়া কইলো, “তুমরা যাওগি, গিয়া তুমরার মাবুদ আল্লার এবাদত করো। অইলে কে কে যাইতায় চাইরায়?” ");
INSERT INTO syl_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","মুছায় কইলা, “আমরা তো মাবুদর নামে হজো যাইরাম। তে আমরার হুরুতাইন, মুরব্বি, পুয়া-পুড়িন আর গরু-ছাগল লইয়া যাইমু।” ");
INSERT INTO syl_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ফেরাউনে কইলো, “আইচ্ছা, আমি যুদি হাছাউ তুমরারে হুরুতা-মুরুতা দিয়া ছাড়ি দেই, তে তুমরার অউ মাবুদও যানু তুমরার লগে অইয়া যায়গি। খবরদার! তুমরার মতলব তো ভালা নায়। ");
INSERT INTO syl_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","না, ইলা তো অইতো নায়, তুমরার হক্কলতা নিতে দিতাম নায়। তুমরা যেবলা যাইতায়উ চাইরায়, তে খালি বেটাইন যাওগি।” অখান কইয়া হারি ফেরাউনে তার ছামনে থাকি মুছা আর হারুনরে খেদাই দিলো। ");
INSERT INTO syl_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","তেউ মাবুদে মুছারে কইলা, “তুমি মিসর দেশর উপরে পংগপালর লাগি আত তুলো, পংগপালে আইয়া মিসরর জমিনর হকল গাছ-গাছালি খাইলিবো। হিল-তুফান থাকি যততা বাচিছে, ইতা হক্কলতা খাইলিবো।” ");
INSERT INTO syl_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","মুছায় মিসরর উপরে তান লাঠি মেলিয়া ধরলা, আর মাবুদে হারা দিন হারা রাইত দেশর মাজে পুবালি হাওয়া ছাড়লা, অউ পুবালি হাওয়ায় বিয়ানে পংগপাল লইয়া আজিলো। ");
INSERT INTO syl_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","হারা মিসর দেশর উপরে পংগপালে জাম অইগেলা। মিসরর হকল জাগাত পংগপালে গিছগিছ করলা, খুব বেশি পংগপাল আইলা, অতো পংগপাল এর আগেও কুনু দিন অইছইন না আর বাদেও কুনু দিন অইতা নায়। ");
INSERT INTO syl_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","তারা আস্তা জমিনর উপর গুরিলিলা, দেশ আন্দাইর অইগেল, আর জমিনর যত খেত, গাছ-গাছালি হিল-তুফান থাকি বাচি গেছিল, ইতা হক্কলতা খাইলিলা। আস্তা মিসরর কুনু গাছ-গাছালি বা খেতর ফসল কুন্তাউ রইলো না। ");
INSERT INTO syl_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","ফেরাউনে জলদি করি মুছা আর হারুনরে আনাইয়া কইলো, “আমি তো তুমরা আর তুমরার মাবুদ আল্লার গেছে গুনাগার অইগেছি। ");
INSERT INTO syl_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","তে মিনত করিয়ার, খালি একখান বার আমার গুনা মাফ করি দেও। আমার গেছ থাকি ই মরন আপদরে হরাই নেওয়ার লাগি, তুমরার মাবুদ আল্লারে মিনত করো।” ");
INSERT INTO syl_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","অউ মুছায় ফেরাউনর গেছ থাকি হরিয়া গিয়া মাবুদর গেছে মিনত করলা; ");
INSERT INTO syl_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","আর মাবুদে খুব জুরে পচ্চিমা হাওয়া ছাড়লা, ইতায় পংগপাল অকলরে খেদাইয়া ছাফ করিয়া নীল দরিয়াত ফালাইলো, মিসরর কুনু জাগাত এগু পুকও রইলো না। ");
INSERT INTO syl_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","অইলে মাবুদে ফেরাউনর দিল পাষান করিল্লা, হে বনি ইছরাইলরে ছাড়লো না। ");
INSERT INTO syl_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","বাদে মাবুদে মুছারে কইলা, “তুমি আছমান মুখা তুমার আত বাড়াও; তেউ হারা দেশো অতো ঘনো আন্দাইর অইবো, ই আন্দাইর আত দিয়া ছোয়া যাইবো।” ");
INSERT INTO syl_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","মুছায় আছমান মুখা আত বাড়াইলে তিন দিন পর্যন্ত হারা মিসর দেশ খুব ঘনো আন্দাইর অইলো। ");
INSERT INTO syl_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","তিন দিন কেউ কেউরর মুখও দেখতো পারলো না, কেউ জাগা থাকি লড়তো পারলো না। অইলে বনি ইছরাইলর হকল ঘরো কুনু রুশনির অভাব আছিল না। ");
INSERT INTO syl_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","ফেরাউনে মুছারে আনাইয়া কইলো, “যাও, তুমরা গিয়া তুমরার মাবুদর এবাদত করো, তুমরার হুরুতাইনরেও নেওগি, খালি তুমরার গরু-ছাগলর পাল থাকউক।” ");
INSERT INTO syl_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","মুছায় কইলা, “আমরার মাবুদ আল্লার নামে দিবার লাগি, পশু কুরবানি আর জালাইল কুরবানির পশুইন আমরার লগে নিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","আমরার লগে অইয়া আমরার পশুইনও যাইবা, পশুর একখান খুরাও থইয়া যাইতাম নায়। আমরার মাবুদ আল্লার এবাদতর লাগি অন থাকি কুরবানি করা লাগবো, আর কিতা কিতা কুরবানি করতাম, ইতা আমরা হনো না গেলে কইতাম পারতাম নায়।” ");
INSERT INTO syl_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","অইলে মাবুদে ফেরাউনর দিল পাষান করিল্লা, হে এরারে ছাড়তে রাজি অইলো না। ");
INSERT INTO syl_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","ফেরাউনে কইলো, “আমার ছামনে থাকি বাগো। খবরদার! আমার মুখর ছামনে আর কুনুদিন আইও না। আমার ছামনে যেদিন আইবায়, হিদিন জান খুয়াইবায়।” ");
INSERT INTO syl_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","মুছায় কইলা, “ভালারে ভালা! আমি শখ করিয়া কুনুদিনউ আপনার মুখ দেখাত আইতাম নায়।” ");
INSERT INTO syl_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","মাবুদে মুছারে কইলা, “আমি ফেরাউন আর মিসর দেশর উপরে আর মাত্র একটা গজব ছাড়মু, এরবাদে হে তুমরারে অনথনে ছাড়িদিবো, ছাড়ার বালা হে তুমরারে এক্কেবারে খেদাই দিবো। ");
INSERT INTO syl_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","তুমি বনি ইছরাইলরে হিকাই দেও, হক্কল বেটাইন-বেটিন্তে তারার মিসরী আরি-ফরির গেছ থাকি সোনা-রুপার গয়না-গাটি খুজিয়া নেউক।” ");
INSERT INTO syl_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","অউ হালতো মিসরী অকলর নজরো মায়া পাইতে মাবুদে সাইয্য করলা। এরমাজে মিসর দেশো ফেরাউনর উজির-নাজির আর প্রজা অকলর গেছে হজরত মুছা খুব ইজ্জতি বনিগেলা। ");
INSERT INTO syl_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","মুছায় ফেরাউনরে কইলা, “মাবুদে নিজে কইরা, আমি আধা রাইতকুর বালা মিসর দেশর মাজদি যাইমু। ");
INSERT INTO syl_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","এতে গদিত বওয়া ফেরাউনর বড় পুয়া থাকি বারা-ভানরা বান্দির পুয়া পর্যন্ত, মিসর দেশর মাজে রওরা হক্কল পরিবারর বড় পুয়াইন মরিযিবা। এরলগে হকল পশুইন্তর পয়লা মেদা বাইচ্চাও মরিযিবা। ");
INSERT INTO syl_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","ই লাখান দশা মিসর দেশো কুনুদিন অইছেও না আর অইতোও নায়, আস্তা মিসর দেশো অউ লাখান কান্দন কান্দিবা। ");
INSERT INTO syl_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","অইলে বনি ইছরাইলর কুনু মানুষ বা পশুর বায় এগু কুত্তায়ও উহ করতো নায়, যাতে আপনারা বুজতা পারইন আমি মাবুদে মিসরী আর বনি ইছরাইলর মাজে তফাত করি।” ");
INSERT INTO syl_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","হেশে মুছায় ফেরাউনরে কইলা, “অউ সময় আপনার হক্কল উজির-নাজিরে আইয়া আমার পাওত পড়িয়া কইবা, আপনে আপনার হকল মানষরে লইয়া বিদায় নেইনগি, এরবাদে আমি বার অইমু।” অখান কইয়া তাইন গুছায় আগুইন অইয়া ফেরাউনর গেছ থাকি হরিয়া গেলা। ");
INSERT INTO syl_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","মাবুদে মুছারে কইছলা, “ফেরাউনে তুমার কথা মানতো নায়, যাতে মিসর দেশো আমার কেরামতির পরিমান আরো বাড়ে।” ");
INSERT INTO syl_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","এরলাগি মুছা আর হারুনে ফেরাউনর ছামনে অউ কেরামতি অকল দেখাইলা। অইলে মাবুদে ফেরাউনর দিলরে পাষান করিল্লা, হে নিজর দেশ থাকি বনি ইছরাইলরে ছাড়লো না। ");
INSERT INTO syl_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","বাদে অউ মিসর দেশর ভিতরে মাবুদে মুছা আর হারুনরে কইলা, ");
INSERT INTO syl_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“ই চান্দখান বছরর পয়লা চান্দ অইবো, তুমরা ই চান্দরে বছরর পয়লা চান্দ গনিও। ");
INSERT INTO syl_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","তুমিতাইন তামাম বনি ইছরাইলরে দলা করি জানাই দেও, অউ চান্দর দশ তারিখো তুমরার হকল পরিবারর মুরব্বিয়ে, যারযির পরিবারর লাগি এগু করি মেড়া বা ছাগলর বাইচ্চা নিবায়। ");
INSERT INTO syl_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","অইলে কুনু পরিবারো এর গোস্ত খাওয়ার মানুষ কম অইলে, লাগা ঘরর মানষর লগে মিলিয়া, দুইও পরিবারে যতখান খাইতা পারইন, হউ অনুমানে মেড়া বা ছাগলর বাইচ্চা নিবায়। ");
INSERT INTO syl_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","ই বাইচ্চা অইবো নিখুত, এক বরছ বয়সর পাঠা বাইচ্চা অইতে অইবো; তুমরা মেড়া বা ছাগলর বাইচ্চা নিতায় পারবায়। ");
INSERT INTO syl_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","আর অউ চান্দর চৌদ্দ তারিখ পর্যন্ত ইটার যতন করবায়, বাদে তামাম বনি ইছরাইল একলগে মিলিয়া, তারা হাইঞ্জা বালা যারযির পরিবারে অউ বাইচ্চাইন জবো করবা। ");
INSERT INTO syl_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","জবো করার বাদে তারা এর কিছু লউ নিয়া যত ঘরো এর গোস্ত খাইবা, অতো ঘরর দুয়ারর চৌকাঠর দুইও গালাত আর উপরর চৌকাঠো অউ লউ লাগাইবা। ");
INSERT INTO syl_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","হউ রাইতউ তারা ই গোস্ত আগুইনদি ছেকিয়া খামির ছাড়া রুটি আর তিত্বা হাগর লগে মিলাইয়া খাইবা। ");
INSERT INTO syl_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","ই গোস্ত তুমরা কাচা, বা পানিদি রান্দিয়া খাইও না। খালি আগুইনদি ছেকিয়া খাইও, এর ঠেং, কল্লা সুদ্ধা ভিতরর হক্কলতা একখানো ছেকিও, বাদে খাইও। ");
INSERT INTO syl_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","রাইত পুয়ানির আগে খানি শেষ করিও, বিয়ান পর্যন্ত কুন্তাউ বাকি থইও না। যুদি কুন্তা বাকি রইযায়, তে আগুইনদি জালাইলিও। ");
INSERT INTO syl_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","ই খানি খাওয়ার বালা তুমরার কমরর কাপড় মজবুত করি ফিন্দিও, পাওত জুতা লাগাইও, আতর লাঠি লইও। জলদি করি খানি খাইও। ইটা অইলো মাবুদর নামর আজাদি ইদ। ");
INSERT INTO syl_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","হউ রাইতউ আমি মিসর দেশর মাজদি যাইমু, দেশর হক্কল মানষর বড় পুয়ারে আর পশুর পয়লা মেদা বাইচ্চারেও মারিলিমু। মিসরর হকল দেব-দেবীর বিচার করিয়া সাজা দিমু; আমিউ মাবুদ। ");
INSERT INTO syl_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","অইলে তুমরার দুয়ারর চৌকাঠো লেপা লউ দেখলে আমি বুজমু ই ঘরো তুমরা রও। এরলাগি আমি মিসর দেশো গজব ঢালিবার সময়, লউ লেপা অউ ঘর বাদ দিয়া ছামনেদি যাইমু। মউতর গজব থনে তুমরা রেহাই পাইবায়। ");
INSERT INTO syl_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","অউ দিনরে তুমরা ইয়াদ রাখিও আর আমি মাবুদর নামে ইদর দিন মানিও। ই ইদরে তুমরা আমার হুকুম মনো করিয়া হর-হামেশা ওয়ারিশর পর ওয়ারিশ ধরি মানিয়া যাইও।” ");
INSERT INTO syl_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","মাবুদে কইলা, “তুমরা সাত দিন পর্যন্ত খামির ছাড়া রুটি খাইবায়। পয়লা দিনউ যারযির ঘর থাকি হকল খামির ফালাই দিবায়। ই সাতো দিনর মাজে যেগুয়ে খামির আলা নান রুটি খাইবো, তারে বনি ইছরাইল থনে ফুছিয়া ফালাইল অইবো। ");
INSERT INTO syl_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","পয়লা দিন আর সাত নম্বর দিন তুমরা পবিত্র মিলন-মাহফিল আদায় করবায়, ই দুই দিন খালি জরুরি খাওয়া-দাওয়া ছাড়া দুছরা কুনু কাম-কাজ করবায় না। ");
INSERT INTO syl_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","অউ লাখান তুমরা খামির ছাড়া রুটির ই ইদ আদায় করিও, আমার হুকুম মনো করিয়া ওয়ারিশর পর ওয়ারিশ ধরি হর-হামেশা ই ইদ আদায় করিও। অউ দিনউ আমি তুমরারে সিপাই দলর লাখান করি মিসর দেশ থাকি বার করি আনমু। ");
INSERT INTO syl_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","তুমরা পয়লা চান্দর চৌদ্দ তারিখর হাইঞ্জা থাকি শুরু করিয়া, একুইশ তারিখর হাইঞ্জা পর্যন্ত খামির ছাড়া রুটি খাইও। ");
INSERT INTO syl_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","অউ সাত দিন যাতে তুমরার ঘরো খামিরর কুনু নাম-নিশানা না থাকে, অউ সময় কেউ যুদি খামির আলা খানি খায়, তে হে তুমরার নিজর জাতির অউক বা ভিন জাতির অউক, তারে বনি ইছরাইলর সমাজ থাকি ফুছিয়া ফালাইল অইবো। ");
INSERT INTO syl_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","ই সাত দিন তুমরা যেনোউ রও না কেনে খামির আলা কুন্তাউ খাইও না; খালি খামির ছাড়া রুটি খাইও।” ");
INSERT INTO syl_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","মুছায় বনি ইছরাইলর হকল ময়-মুরব্বিরে দলা করিয়া কইলা, “আপনারা যাউক্কা, গিয়া যারযির পরিবারর লাগি আজাদি ইদর মেড়া-বাইচ্চা আনিয়া জবো করউক্কা। ");
INSERT INTO syl_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","আর ‘এছুব’ গাছর এক আটি ডেটা লইয়া, পাতিলো থওয়া লউত বুড়াইয়া দুয়ারর চৌকাঠর দুইও গালাত আর উপরে লাগাইও। সাবধান! সুরুজ উঠার আগে কেউ ঘরর বারে বার অইও না। ");
INSERT INTO syl_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","মিসরী অকলরে মারার লাগি মাবুদে যেবলা মিসর দেশর মাজদি তশরিফ নিবা, অউ সময় তুমরার চৌকাঠর উপরে আর দুইও গালাত লউ দেখলে, তাইন ই ঘর বাদ দিয়া ছামনেদি আগুয়াইবা। আজরাইল ফিরিস্তারে তুমরার ঘরো হামাইয়া মারতে দিতা নায়। ");
INSERT INTO syl_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“আমার বাতাইল হুকুম মনো করিয়া তুমরা আর তুমরার আওলাদ অকলে ই ইদরে আদায় করিও। ");
INSERT INTO syl_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","আমি আমার নিজর ওয়াদা মাফিক তুমরারে যে দেশ দিমু, হউ দেশো গিয়া হারলেও তুমরা ই ইদ আদায় করিও। ");
INSERT INTO syl_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","তুমরার হুরুতাইন্তে যেবলা তুমরারে জিকাইবা, ই ইদর কারন কিতা? ইটা কিলা আইছে? ");
INSERT INTO syl_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","তে তুমরা জুয়াপ দিও, ইটা মাবুদর নামে আজাদি ইদর কুরবানি। মিসরী অকলরে মারবার বালা তাইন মিসর দেশো বনি ইছরাইলর ঘর বাদ দিয়া ছামনেদি আগুয়াই গিয়া, আমরারে আজাদ করছলা।” ইখান হুনিয়া হকল মানষে মাবুদরে সইজদা করলা। ");
INSERT INTO syl_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","মুছা আর হারুনরে মাবুদে যেলা বাতাই দিছলা, হকল বনি ইছরাইল তারার ঘরো গিয়া অউ লাখান কাম করলা। ");
INSERT INTO syl_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","হেশে মাজ রাইতে অউ লাখান ঘটলো, মাবুদে গদিত বওয়া ফেরাউনর পুয়া থনে জেল খানার বন্দির পুয়া পর্যন্ত হক্কলরে মারিলিলা। মিসর দেশর হক্কল পরিবারর বড় পুয়াইন আর পশুইন্তর পয়লা মেদা বাইচ্চারেও তাইন মারিলিলা। ");
INSERT INTO syl_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","তেউ ফেরাউন আর তার উজির-নাজির অকল, মিসরর হকল মানুষ হজাগ অইয়া উঠলা, আস্তা মিসর দেশো বেথায়া কান্দনর রুইল পড়লো; কারন অলা কুনু ঘর রইছিল না, যে ঘরো কেউ না কেউ মরছে না। ");
INSERT INTO syl_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","হউ রাইতউ ফেরাউনে মুছা আর হারুনরে আনাইয়া কইলো, “তুমরা জলদি যাও, বনি ইছরাইলরে লইয়া আমার প্রজার গেছ থনে হরো। তুমরা যেলা কইছো, অউলা গিয়া মাবুদর এবাদত করো। ");
INSERT INTO syl_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","তুমরার জবান মতউ তুমরার গরু-মেড়ার পাল অকলরেও নেওগি। তুমরা আমারেও নেক দোয়া দেও।” ");
INSERT INTO syl_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","মিসরী অকলে খুব ডরাইলা, তারা মনো করলা তারাও মরিযিবা। এরলাগি তারা তাগদা দিতা লাগলা, বনি ইছরাইল জলদি করি বিদায় অইতা। ");
INSERT INTO syl_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","বনি ইছরাইলে তারার ময়দার খাইর মাজে খামির পুরাইবার আগেউ, খাই সহ গামলাইন কাপড়দি গাইট বান্দিয়া কান্দো লইলা। ");
INSERT INTO syl_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","হকল বনি ইছরাইলে মুছার পরামিশ মত, মিসরী অকলর সোনা-রুপার গয়না-গাটি আর কাপড়-চুপড় খুজিয়া নিলা। ");
INSERT INTO syl_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","মাবুদে আগ থনেউ মিসরী অকলর দিলর মাজে এক দয়া-মায়া পয়দা করছলা, যাতে বনি ইছরাইলে যেতা খুজিবা, অতাউ যানু তারারে দেইন। অউ লাখান করি তারা মিসরী অকলর বউত ধন-দৌলতও কবজা করলা। ");
INSERT INTO syl_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","অতা নিয়া বনি ইছরাইল রামাষেষ এলাকা থাকি সুক্কতর মুখা রওয়ানা অইলা। তারার মাজে অনুমান ছয় লাখ সবল বেটাইন আটিয়া গেলা। এরার লগে বেটিন আর হুরুতাইনও আছলা। ");
INSERT INTO syl_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","বনি ইছরাইল বাদেও তারার লগে রওরা আরো বউত মানুষ, গরু-মেড়ার পাল হকলতা মিলিয়া বউত বড় দল বান্দিয়া রওয়ানা দিলা। ");
INSERT INTO syl_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","বাদে তারা মিসর থাকি আনা হউ ময়দার খাই দিয়া খামির ছাড়া রুটি বানাইলা। মিসর থাকি তারারে জলদি করি বিদায় দেওয়ায় ই খাইত খামির মাখাইবার সময়উ পাইছলা না, আর পথর লাগি কুনু মছাও নিতা পারছলা না। ");
INSERT INTO syl_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","বনি ইছরাইল মিসরো হক্কলতায় চাইরশো তিশ বরছ বসত করছলা। ");
INSERT INTO syl_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","ঠিক অউ চাইরশো তিশ বরছ পুরা অইবার দিনো মাবুদর হক্কল বন্দা, সিপাই দলর লাখান হাজিয়া মিসর দেশ থাকি বার অইলা। ");
INSERT INTO syl_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","অউ রাইত মাবুদে আপন কুদরতি ছায়ায় পাহারা দিয়া তারারে মিসর দেশ থাকি বার করিয়া আনায়, ই রাইতখান এবাদতির রাইত। হক্কল বনি ইছরাইলর লাগি ওয়ারিশর পর ওয়ারিশ ধরি, মাবুদর নামে উজাগরি করার এক খাছ রাইত। ");
INSERT INTO syl_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","মাবুদে মুছা আর হারুনরে কইলা, “আজাদি ইদর কুরবানির নিয়ম-কানুন আমি তুমরারে হিকাই দিয়ার। হুনো, অইন্য কুনু জাতির মানষরে এর গোস্ত খাইতে দিবায় না। ");
INSERT INTO syl_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","অইলে খরিদা গুলামে মছলমানি করানির বাদে ইতা খাইতো পারবো। ");
INSERT INTO syl_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","অইন্য যেকুনু জাতির মুছাফির বা বেতনদারি কামলারেও ইতা খাওয়াইও না। ");
INSERT INTO syl_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","তুমরা যার বাড়িত পশু জবো করবায় হউ বাড়িতউ এর গোস্ত খাইতে অইবো; বাড়ির বারে কুন্তাউ নিবায় না, পশুর কুনু আড্ডি ভাংগিবায় না। ");
INSERT INTO syl_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","তামাম বনি ইছরাইলে অউ ইদ আদায় করবায়। ");
INSERT INTO syl_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","তুমরার লগে রওরা কুনু আবাদিয়ে যুদি মাবুদর নামর ই ইদ মানতো চায়, তে পয়লা তার পরিবারর হকল বেটাইন্তর মছলমানি করানি লাগবো। বাদে হে বনি ইছরাইলর লাখান ইদ আদায় করতো পারবো। অইলে মছলমানি করানি ছাড়া কেউ ই গোস্ত খাইতো পারতো নায়। ");
INSERT INTO syl_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","বনি ইছরাইলর লাগি আর আবাদির লাগিও এক হমান আইন জারি অইলো।” ");
INSERT INTO syl_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","মাবুদে মুছা আর হারুনরে যেলা হুকুম দিছলা, বনি ইছরাইলে হাছারর অউলাউ আমল করলা। ");
INSERT INTO syl_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","মাবুদে হউ দিনউ সিপাই দলর লাখান করি, বনি ইছরাইল অকলরে মিসর দেশ থাকি বার করি আনলা। ");
INSERT INTO syl_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","মাবুদে মুছারে হুকুম দিলা, ");
INSERT INTO syl_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“তুমি বনি ইছরাইলর হক্কল পরিবারর বড় পুয়াইনরে আমার নামে আলগ করিয়া সপিয়া দেও। ইতা কুনু মানষর পুয়া অউক বা পশুর বাইচ্চা অউক। হকলতার বড় পুয়াইন খালি আমারউ।” ");
INSERT INTO syl_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","তেউ মুছায় মানষরে কইলা, “ই দিন খানরে তুমরা ইয়াদ রাখিও, অউ দিনউ তুমরা মিসরর গুলামি থাকি আজাদ অইছো। মাবুদে তান কুদরতি আত দিয়া তুমরারে হন থাকি বার করছইন। ই দিন কুনুজাতর খামির আলা খানা খাইও না। ");
INSERT INTO syl_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","আবীব চান্দর অউ তারিখো তুমরা বার অইলায়। ");
INSERT INTO syl_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","মাবুদে তুমরার বাফ-দাদার গেছে ওয়াদা করছইন, কেনানী, হিট্টী, আমোরী, হিব্বী আর যিবুজী অকলর দেশো তুমরারে নিবাগি। ই দেশ দুধ আর মউর ভান্ডার আলা দেশ। তে হনো গিয়া হারলেও তুমরা পরতেক বছর আবীব চান্দর অউ ইদ আদায় করিও। ");
INSERT INTO syl_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","“তুমরা সাত দিন পর্যন্ত খামির ছাড়া রুটি খাইও, বাদে সাত নম্বর দিনো মাবুদর নামে ইদ আদায় করিও। ");
INSERT INTO syl_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ই সাতো দিন খামির ছাড়া রুটি খাওয়া লাগবো, তুমরার গেছে খামির আলা কুনুজাতর খানা যাতে না দেখি, তুমরার আস্তা দেশর ভিতরেও যানু কুনু খামির না মিলে। ");
INSERT INTO syl_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","ই দিন তুমরা হকলে যারযির পুয়াইন্তরে কইও, ‘আমরা যেবলা মিসর থাকি বার অইয়া আইছলাম, অউ সময় মাবুদে আমরারে যেলা রহম করছলা, অতারে মনো রাখার লাগি আমিও অখন অলা কররাম।’ ");
INSERT INTO syl_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","অউ লাখান তুমরা যারযির আওলাদ অকলরে মাবুদর হুকুম তালিম দিও, যাতে তুমরার মনো রয়, মাবুদে তান কুদরতি আত দিয়া তুমরারে মিসর দেশ থাকি বার করি আনছইন। তুমরার আতর বা কপালর তাবিজ-কবজর লাখান, অউ তালিমরেও হামেশা চখুর ছামনে রাখিও। ");
INSERT INTO syl_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","এরলাগি পরতেক বরছ অউ অখত আইলেউ তুমরা ই নিয়ম আদায় করিও। ");
INSERT INTO syl_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“মাবুদে তুমরার গেছে আর তুমরার বাফ-দাদাইন্তর গেছে যেলা ওয়াদা করছইন, অউ ওয়াদা মাফিক তাইন তুমরারে কেনানী অকলর দেশ দান করছইন। তে মাবুদে হনো নিয়া হারলে, ");
INSERT INTO syl_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","তুমরা যারযির বড় পুয়ারে মাবুদর নামে সপিয়া দিলাইও; এরলগে তুমরার হকল পশুইন্তর পয়লা মেদা বাইচ্চারেও মাবুদর নামে দিলাইও, ইতা তো মাবুদরউ। ");
INSERT INTO syl_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","অইলে হকল গাধীন্তর পয়লা মেদা বাইচ্চার বদলা, তুমরা এগু মেড়া-বাইচ্চা দিয়া খালাছ করাইও। খালাছ না করাইলে গাধা বাইচ্চার গর্দনা ভাংগি দিও। মনো রাখিও, তুমরার হক্কল পরিবারর বড় পুয়াইনরে খালাছ করানি লাগবো। ");
INSERT INTO syl_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“তুমরার পুয়াইন্তে যেবলা জিকাইবা, ইতা কিতার লাগি করা লাগে? তুমরা জুয়াপ দিও, ‘মাবুদে তান কুদরতি আত দিয়া আমরারে মিসরর গুলামি থাকি আজাদ করি আনছইন। ");
INSERT INTO syl_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ফেরাউনে না-হুমারি করিয়া যেবলা আমরারে আইতে দিলো না, অউ সময় মাবুদে মিসর দেশর হকল পরিবারর বড় পুয়াইন্তরে, মানষর পুয়াইন আর পশুইন্তর পয়লা মেদা বাইচ্চাইনরে মারিল্লা। অউ কারনে আমরার বড় পুয়াইনরে মাবুদর গেছ থাকি খালাছ করাই, আর পশুর পয়লা মেদা বাইচ্চারে কুরবানি দেই। ");
INSERT INTO syl_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","ইটা অমন এক ইয়াদগারির ইদ, আত বা কপালো বান্দা তাবিজ-কবজর লাখান যানু হামেশা চখুর ছামনে রয়, আর মাবুদে তান কুদরতি আত দিয়া আমরারে মিসর থাকি বার করি আনছইন, অখান মনো রয়।’ ” ");
INSERT INTO syl_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ফেরাউনে বনি ইছরাইলরে ছাড়ার বাদে, ফিলিস্তিনী অকলর দেশর মাজদি সিধা পথ থাকলেও আল্লায় তারারে হি পথেদি নিলা না। আল্লায় কইলা, হেশে যুদি কুনু যুদ্ধর মুকাবিলা করা লাগে, তে মানষে যুদ্ধর ডরে হিরবার মিসরো ফিরিযিতো পারে। ");
INSERT INTO syl_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","এরলাগি তাইন মানষরে নীল দরিয়ার পারেদি মরুভুমি বায় নেওয়াইলা; তামাম বনি ইছরাইলে সিপাই দলর লাখান হাজি-পাড়ি মিসর দেশ থাকি রওয়ানা অইলা। ");
INSERT INTO syl_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","যাওয়ার বালা মুছা নবীয়ে হজরত ইউছুফর কয়বর থাকি তান আড্ডি-গুড্ডি লগে করি নিলা। ইউছুফে বনি ইছরাইলরে মজবুত করি কছম করাই কইছলা, “আল্লায় নিচয় তুমরারে হেফাজত করবা, তে তুমরা যাওয়ার বালা আমার আড্ডিগুইন তুলিয়া লগে করি নিওগি।” ");
INSERT INTO syl_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","বাদে তারা সুক্কত গাও থাকি রওয়ানা অইয়া মরুভুমির কিনারো এথম নামর জাগাত আইয়া তাম্বু গাড়িলা। ");
INSERT INTO syl_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","আর মাবুদে তারারে পথ চিনানির লাগি দিনর বালা মেঘর খুটির ছুরতে রইতা, আর রাইতর বালায় ফর দেখানির লাগি আগুনির খুটির ছুরতে তারার আগে আগে যাইতা, এরলাগি তারা রাইত-দিন হমানে চলতা পারতা। ");
INSERT INTO syl_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","মানষর ছামনে হামেশা দিনর বালা মেঘর খুটি আর রাইতর বালা আগুনির খুটি রইতো। ");
INSERT INTO syl_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“তুমি বনি ইছরাইলরে কও, তারা ঘুরিয়া আইয়া ফামা-হিরোত নামর জাগার কান্দাত মিগদোল আর দরিয়ার মাজামাজি, বাআল-জাফন এলাকার ছামনে দরিয়ার চরর মাজে তাম্বু গাড়িতা। ");
INSERT INTO syl_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","ইতা দেখলে ফেরাউনে মনো করবো, বনি ইছরাইলে কুনুবায় পথ না পাইয়া ঘুরাঘুরি করতে করতে মরুভুমিত আটকি গেছইন। ");
INSERT INTO syl_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","আমি ফেরাউনর দিলরে পাষান বানাইমু, হে তুমরার খরে খরে খেদানিত আইবো। তেউ ফেরাউন আর তার সিপাই অকলরেদি আমার নাম উজিলা অইবো; ইতা দেখিয়া মিসরী অকলেও বুজিলিবা, আমিউ মাবুদ।” মাবুদর হুকুম মাফিক বনি ইছরাইলে অউলা করলা। ");
INSERT INTO syl_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","হাছাউ মিসরর বাদশা ফেরাউনে যেবলা খবর পাইলো, বনি ইছরাইল অকল বাগি গেছইন, হুনিয়াউ ফেরাউন আর তার উজির-নাজিরর দিল ফিরিগেল। তারা কইলা, “হায়, হায়! আমরা ইতা কিতা করছি? ইতারে আমরার গুলামি থাকি কেনে ছাড়লাম?” ");
INSERT INTO syl_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","অখান কইয়াউ ফেরাউনে তার যুদ্ধর ঘোড়ার গাড়ি হাজানির হুকুম দিয়া, তার সিপাই অকলরে জুইত করাইলো। ");
INSERT INTO syl_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","হে তার খাছ শক্তিমান ছয়শ ঘোড়ার গাড়ি, মিসরর সব ঘোড়ার গাড়িন আর এরার চালকদার সিপাইরেও লগে লইলো। ");
INSERT INTO syl_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","মাবুদে মিসরর বাদশা ফেরাউনর দিলরে পাষান করিল্লা, হে বনি ইছরাইলর খরে খরে খেদানিত আইলো। এরা যেবলা হিম্মত করি আটিয়া যাইরা, অউ সময় হে এরারে ধরাত আইলো। ");
INSERT INTO syl_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","হে মিসর দেশর হকল ঘোড়-ছওয়ার সিপাই, ঘোড়ার গাড়িআলা সিপাই সহ আস্তা আর্মি দল লইয়া এরারে ধরার লাগি এরার কান্দাত আইল্লো। অউ সময় বনি ইছরাইল অকল দরিয়ার পারো বাআল-জাফনর ছামনে ফামা-হিরোতর কান্দাত আছলা। ");
INSERT INTO syl_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","তারা কান্দাত আইতেউ বনি ইছরাইলে চাইয়া দেখলা, তারার খরে অইয়া মিসরী সিপাই আইরা; দেখিয়াউ জানর ডরে মাবুদর দরবারো কান্দন লাগাইলা। ");
INSERT INTO syl_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","তারা মুছারে কইলা, “মিসরো কয়বর দিবার জাগা নাই দেখিয়া, আমরারে মারতায় করি অউ মরুভুমিত লইয়া আইছো নি? তুমি ইতা কিতা করলায়? কেনে আমরারে মিসর থাকি বার করলায়? ");
INSERT INTO syl_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","মিসরর ভিতরে আমরা তুমারে কইছি না নি, আমরারে অনো রইতে দেও, আমরা মিসরীন্তর গুলামি করি? ই মরুভুমিত মরার চাইতে মিসরীন্তর গুলামি করাউ তো আমরার লাগি ভালা আছিল।” ");
INSERT INTO syl_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","মুছায় তারারে কইলা, “তুমরা ডরাইও না। হকলে নিরাই অইয়া দেখো, মাবুদে আইজ কিলা বাচাইন। অউ যেতা মিসরীন্তরে অখন দেখরায়, ইতারে আর কুনুদিনউ দেখতায় নায়। ");
INSERT INTO syl_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","তুমরা অখন শান্তি অও, দেখো, মাবুদেউ তুমরার পক্ষ অইয়া যুদ্ধ করবা।” ");
INSERT INTO syl_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","বাদে মাবুদে মুছারে কইলা, “তুমি কেনে আমার গেছে কান্দিরায়? বনি ইছরাইলরে কও না, ছামনেদি আগুয়াইতা। ");
INSERT INTO syl_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","আর তুমার আতর লাঠিরে বাড়াইয়া দরিয়ার উপরে উচা করি ধরো, দরিয়ারে দুই ভাগ করিলাও। তেউ তামাম বনি ইছরাইল হুকনা বায় আটিয়া দরিয়া পার অইবা। ");
INSERT INTO syl_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","খিয়াল রাখিও, আমি মিসরী অকলর দিল অলা পাষান বানাইমু, তারা এরারে ধরার নিয়তে দরিয়াত হামাইবা। এরবাদে ফেরাউন, তার সিপাই, তার ঘোড়ার গাড়িন, তার ঘোড়-ছওয়ার অকলর মাজদি আমার জালাল-শান জাইর অইবো। ");
INSERT INTO syl_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","ফেরাউনর হাল-হকিকত দেখিয়া বাকি মিসরী অকলেও বুজিলিবা, আমিউ মাবুদ।” ");
INSERT INTO syl_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","এরমাজে আল্লার যে ফিরিস্তা বনি ইছরাইলর আগে অইয়া যাওয়াত আছলা, এইন জাগা বদলাইয়া বনি ইছরাইলর খরে গেলাগি। এন লগে অইয়া কুদরতি হউ মেঘর খুটিও ছামনে থাকি হরিয়া খরে আইল্লো। ");
INSERT INTO syl_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","খরে আইয়া মিসরী আর বনি ইছরাইলি দুইও দলর মাজখানো উবাইলো। এরলাগি অউ মেঘর খুটির আন্দাইরে মিসরী অকল আন্দারিত পড়িগেলা, তারা রাইতর বালা বনি ইছরাইলর কান্দা লইতা পারলা না। অইলে বনি ইছরাইলর ছামনে রাইতর বালাও মেঘর খুটির ফরসা রইলো। ");
INSERT INTO syl_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","বাদে মুছায় দরিয়ার উপরে তান আত বাড়াইলা, আর মাবুদে হারা রাইত খুব জুরে পুবালি হাওয়া দিয়া দরিয়ার পানি হরাইয়া দুই বাট করিল্লা, দরিয়া হুকাইয়া মাজেদি হুকনা পথ বার অইলো। ");
INSERT INTO syl_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","বনি ইছরাইল অকলে হুকনা পাওয়ে দরিয়ার মাজদি রওয়ানা দিলা, দরিয়ার পানি তারার ডাইনে-বাউয়ে ওয়ালর লাখান উবাই রইলো। ");
INSERT INTO syl_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","ইতা দেখিয়া মিসরী অকলে তারারে খেদাইয়া দরিয়ার হউ হুকনা পথেদি গেলা। ফেরাউনর হক্কল ঘোড়ার গাড়ি, ঘোড়া, আর ঘোড়-ছওয়ার অকল খেদাই খেদাই দরিয়ার হউ পথো গিয়া হামাইলা। ");
INSERT INTO syl_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","আর পতাবালা মাবুদে হউ কুদরতি আগুইন আর মেঘর খুটি থাকি মিসরী সিপাইর বায় লান্নতি নজরে চাইলা, তেউ তারা বেদিশা লাগি গেলা। ");
INSERT INTO syl_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","তাইন এরার ঘোড়ার গাড়ির চাক্কা নষ্ট করি দিলা, এরলাগি তারার খুব কষ্ট করিয়াও গাড়ি চালানিত রইলো; এরমাজে তারা একে-অইন্যরে কইলো, “অইছে, আর বাদ দেও, আমরা বনি ইছরাইলর খর থনে হরি যাই। মাবুদে নিজে তারার পক্ষ অইয়া আমরার লগে যুদ্ধ কররা।” ");
INSERT INTO syl_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","অউ সময় মাবুদে মুছারে কইলা, “তুমি দরিয়ার উপরে হিরবার আত বাড়াও। তুমার আত বাড়াইলে পানি হিরবার মিসরীন্তর উপরে, তারার ঘোড়ার গাড়ি আর ঘোড়-ছওয়ারর উপরে আইব্বো।” ");
INSERT INTO syl_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","মুছায় দরিয়ার উপরে আত বাড়াইলা, আর বিয়ান অওয়ার আগেউ দরিয়ার পানি হিরবার হমান অইগেল; মিসরীন্তে ডাইনে-বাউয়ে দৌড়া-দৌড়ি লাগাইলা, অইলে মাবুদে তারারে দরিয়ার পানিদি ভাওয়াই দিলা। ");
INSERT INTO syl_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","পানি হিরবার জাগাত আইল্লো, তারার ঘোড়ার গাড়িন, সিপাইন, আর ঘোড়-ছওয়ার অকল, মানি বনি ইছরাইলর খরে অইয়া খেদানিত আওরা হক্কলতা পানিয়ে বুড়ি গেল, এগুও জিতা রইলা না। ");
INSERT INTO syl_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","অইলে বনি ইছরাইল অকলে হুকনা পথে দরিয়ার মাজদি গেলা, তারার ডাইনে-বাউয়ে পানি ওয়ালর লাখান উবাই রইলো। ");
INSERT INTO syl_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","অউ নমুনায় মাবুদে হি দিন মিসরী অকলর আত থাকি বনি ইছরাইলরে বাচাইলা, তারা নিজর চউখে দেখলা, মিসরীন্তর মরা লাশ দরিয়ার চরো পড়িয়া রইছে। ");
INSERT INTO syl_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","মিসরীন্তর উপরে মাবুদর কুদরতি লিলা-খেলা দেখিয়া, বনি ইছরাইলেও মাবুদরে ডরাইগেলা। তারা মাবুদর উপরে আর তান গুলাম হজরত মুছার উপরে পুরাপুর ইমান আনলা। ");
INSERT INTO syl_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","আল্লার কুদরতে নীল দরিয়া পার অইয়া আইয়া হারলে, হজরত মুছা আর তামাম বনি ইছরাইলে মাবুদর নামে অউ শুকুরানা গজল গাইলা: “আমি মাবুদর নামে গজল গাই, হকলর ছামনে তান কুদরতি মহিমা বাড়িছে, ঘোড়-ছওয়ার সুদ্ধা ঘোড়াইনরে তাইনউ দরিয়ার পানিত ফালাইছইন। ");
INSERT INTO syl_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","আল্লাউ তো আমার বল, তাইনউ আমার গজল, আমারে বাচানির কল-কবজা তান আতো আছে। অউ আল্লাউ আমার মাবুদ, আমার বাফ-দাদার মাবুদ, আমি তান হামদ গাইমু, তান লিলা-খেলার বয়ান করমু। ");
INSERT INTO syl_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","মাবুদ অইলা পয়লোয়ান সিপাই, তান নামউ মাবুদ। ");
INSERT INTO syl_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ফেরাউনর ঘোড়ার গাড়িরে আর সিপাইরে তাইন পানিত ফালাইলা, তার নামকরা ছুবেদার অকল নীল দরিয়াত বুড়িয়া মরলা। ");
INSERT INTO syl_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","গইন পানিয়ে তারারে গিলিল্লো, আর ভারি পাথরর লাখান তারা দরিয়ার তলে গেলাগি। ");
INSERT INTO syl_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","ও মাবুদ, তুমার ডাইন আতখান কুদরতি লিলায় ভরা, তুমার আতে নিচ্চয় দুশমনরে চুরমার করছে। ");
INSERT INTO syl_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","তুমার বিরুদ্ধে যেতায় লাগছিলা, কুদরতি বলে তারারে গইন গাতো ফালাইলায়। তুমার পাঠাইল গজবি আগুইনে, হুকনা খের-নেরার লাখান তারারে জালাইলিলো। ");
INSERT INTO syl_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","তুমার নাকর দমে হকল পানি দলা অইগেল, পানির ফুত অকল জাগাত উবাই রইলো, দরিয়ার গইন পানি চাক্কা বনিগেল। ");
INSERT INTO syl_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","দুশমনে কইছিল, ‘আমি ইতারে খেদাইয়া নিমু, দৌড়াইয়া নিয়া ধরমু, তারার হকলতা কাড়িয়া আনিয়া বাটিমু। তারার মালদি আমি মালদার অইমু, ইতাদি আমার মনর খাইশ পুরাইমু। আমার তলোয়ারদি মারিয়া তারার নাম মিটাইলিমু।’ ");
INSERT INTO syl_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","অইলে তুমি ফু দিয়া বাতাস দিলায়, আর দরিয়ায় তারারে গুরিলিলো, তারা সীসার লাখান গইন পানিত তলাইগেল। ");
INSERT INTO syl_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","ও মাবুদ, কুন দেব-দেবী তুমার হমান? কে তুমার লাখান অতো পবিত্র মহান, আর তুমার মত ভয়ংকর কুদরতি মহিমা কার আছে? ");
INSERT INTO syl_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","তুমার বলআলা ডাইন আতখান বাড়াইলায়, আর দুনিয়ায় তারারে গিলিলিলো। ");
INSERT INTO syl_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","তুমার খাছ মায়ায় যেরারে বাচাইছো, তারারে তো তুমিউ চালাইরায়, তুমার আপন কুদরতি বলে তুমার পবিত্র বসত খানাত নিরায়। ");
INSERT INTO syl_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","ইতা হুনিয়া হক্কল জাতিয়ে কাপিরা, ফিলিস্তিনী বে-দীন অকলর মন ছটফট করের। ");
INSERT INTO syl_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ইদোমর সর্দার অকল ডরাইয়া বেদিশা লাগিগেলা, মোয়াবর নেতা অকলে থর-থরাইয়া কাপিলা, কেনানী অকল ডরাইয়া হরি গেলা। ");
INSERT INTO syl_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","তারার ভিতরে ডর-খফ আইয়া হামাইছে, তুমার আতর ঠেলায় পাথরর লাখান নিরাই অইগেছে। ও মাবুদ, তুমার প্রজা অকল, তুমার খরিদা গুলাম অকল, পুরাপুর পার না অওয়া পর্যন্ত তুমি অউলা রাখছো। ");
INSERT INTO syl_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","তুমি এরারে নিয়া গাছর চেরার লাখান, তুমার নিজর পাহাড়ো রুইবায়। ও মাবুদ, হখানউ তুমার বসত খানা, তুমার আপন আতর গড়া হেরেম শরিফ। ");
INSERT INTO syl_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","ও মাবুদ, যুগ যুগ ধরি তুমিউ খালি বাদশাই করবায়।” ");
INSERT INTO syl_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","ফেরাউনর ঘোড়াইন, তার ঘোড়ার গাড়িন আর ঘোড়-ছওয়ার অকল যেবলা দরিয়ার মাজে হামাইগেল, মাবুদে তারার উপরে দরিয়ার পানি ফিরাই আনলা, অইলে বনি ইছরাইল হকল তো হুকনা পথে দরিয়ার মাজেদি আগে আটিয়া গেছলাগি। ");
INSERT INTO syl_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","হারুনর বইন হজরত মরিয়মও নবী আছলা, তাইন ডুগি আতো লইয়া বাজাইলা, আর বাকি হকল বেটিন্তেও তান খরেদি ডুগি লইয়া নাচি নাচি বার অই আইলা। ");
INSERT INTO syl_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","আর মরিয়মেও মানষর ছামনে অউলা গাইলা: “তুমরা মাবুদর নামে গজল গাও, হকলর ছামনে তান কুদরতি মহিমা বাড়িছে, ঘোড়-ছওয়ার সুদ্ধা ঘোড়াইনরে তাইনউ দরিয়ার পানিত ফালাইছইন।” ");
INSERT INTO syl_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","মুছায় বনি ইছরাইলরে নীল দরিয়া থাকি ছামনেদি লইয়া রওয়ানা অইলা, আর শুর নামর মরুভুমিত গেলা। তারার যাওয়ার পথো তিন দিন ধরি কুনু পানি পাইলা না। ");
INSERT INTO syl_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","বাদে তারা মারুয়া নামর এক জাগাত আইলা, অইলে হিনর পানিও খাইতা পারলা না, হিনর পানি খুব তিত্বা। এরলাগি অউ জাগার নাম লাগলো মারুয়া মানি, তিত্বা। ");
INSERT INTO syl_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","আর মানষে মুছার বিরুদ্ধে কানা-কানি করি কইলা, “আমরা অখন পানি খাইতাম কিলা?” ");
INSERT INTO syl_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","মুছায় মাবুদর গেছে ফরিয়াদ করলা, মাবুদে তানরে এগু গাছ দেখাই দিলা, তাইন হউ গাছরে নিয়া পানিত ফালাইলা, আর পানি মিঠা অইগেল। মাবুদে হউ জাগাত বনি ইছরাইলর পরিক্ষা লইলা, আর তারার লাগি নিয়ম-কানুন বাতাই দিলা। ");
INSERT INTO syl_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","তাইন কইলা, “তুমরা যুদি খিয়াল করিয়া তুমরার মাবুদ আল্লার কালাম হুনো আর অউ লাখান আমল করো, আমি যেতা পছন্দ করি অতা করো, আমার হুকুম মানো, তে আমি মাবুদে মিসরী অকলরে যেতা বেমার-আজার দিছি, ইতা কুনু বেমার তুমরার উপরে দিতাম নায়; জানো তো, আমি মাবুদ তুমরার শিফা করনেআলা।” ");
INSERT INTO syl_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","হেশে তারা এলীমো গিয়া পৌছলা, হিনো বারোগু পানির ইন্দারা আর সত্তইরগু খেজুর গাছ আছিল। তারা অউ পানির কান্দাত তাম্বু গাড়িলা। ");
INSERT INTO syl_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","বাদে তামাম বনি ইছরাইলে এলীম থাকি রওয়ানা দিলাইলা। মিসর দেশ থাকি বারনির বাদর চান্দর পনরো তারিখো তারা ছীন নামর মরুভুমিত আইয়া আজিলা। ছীন অইলো তুর পাহাড় আর এলীমর মাজখানো। ");
INSERT INTO syl_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","অউ সময় তামাম বনি ইছরাইলে মুছা আর হারুনর বিরুদ্ধে কানা-কানি লাগাইলা। ");
INSERT INTO syl_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","এরা দুইও জনর বিরুদ্ধে বনি ইছরাইলে কইলা, “হায়রে হায়, ইতার কথায় আমরা কেনে আইলাম, মাবুদে কেনে নিজর আতে আমরারে মিসর দেশো মারলা না? হি সময় আমরা গোস্তর ডেগর কান্দাত বইতাম, পেট ভরিয়া গোস্ত-রুটি খাইতাম, অইলে ইতায় আমরারে উপাসে আর পেটর ভুকে মারতা করি অনো আনছইন।” ");
INSERT INTO syl_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","ইখান হুনিয়া মাবুদে মুছারে কইলা, “আমি তারারে পরিক্ষা করিয়া দেখমু, তারা আমার নিয়ম-কানুন মানইন কি না। আমি তুমরার খানি মেঘর জড়ির লাখান আছমান থাকি জমিনো ছাড়িমু। মানষে বাইরে আইয়া হাপ্তার পরতেক দিনর খানি পরতি দিন তুলিয়া নিবা। ");
INSERT INTO syl_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","খালি হাপ্তার ছয় নম্বর দিনো তারা যেতা তুলিয়া আনবা, ইতা তৈয়ার করার বাদে অইন্য দিনর খানি থাকি ডাবুল অইযিবো।” ");
INSERT INTO syl_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","বাদে মুছা আর হারুনে হক্কল বনি ইছরাইলরে কইলা, “মাবুদর বিরুদ্ধে তুমরা যেবলা কানা-কানি লাগাইছো, তে আইজ হাইঞ্জা বালাউ বুজবায়, অউ মাবুদেউ তুমরারে মিসর থাকি বার করি আনছইন। ");
INSERT INTO syl_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","বিয়ান অইলেউ তুমরা মাবুদর কুদরতি নুর দেখবায়, তাইন তো হুনছইন, তুমরা কিতা কানা-কানি করছো। তে আমরা আর কিতা যেন, তুমরা আমরার বিরুদ্ধে অততা মাতিরায়?” ");
INSERT INTO syl_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","মুছায় তারারে কইলা, “মাবুদে হাইঞ্জা বালা তুমরারে গোস্ত দিবা, আর বিয়ানে পেট ভরা রুটিও দিবা। মাবুদর বিরুদ্ধে তুমরা যেতা কানা-কানি করছো, ইতা তাইন হুনছইন। আসলে আমরা দুইজন কিতা যেন, তুমরা আমরার বিরুদ্ধে অততা মাতিরায়? ই মাত তো আমরার বিরুদ্ধে নায়, তুমরা মাবুদর বিরুদ্ধেউ মাতিরায়।” ");
INSERT INTO syl_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","এরবাদে মুছায় হারুনরে কইলা, “তুমি হক্কল বনি ইছরাইলরে জানাই দেও, তুমরা মাবুদর বিরুদ্ধে যেতা মাতিছো, ইতা তাইন হুনছইন। অখন তুমরা আইয়া মাবুদর ছামনে আজির অও।” ");
INSERT INTO syl_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","তেউ হারুনে তারারে অউ সংবাদ জানাইরা, অউ সময় মরুভুমির বায় তারার চউখ পড়তেউ দেখইন, মেঘর কালনির মাজে মাবুদর কুদরতি নুর জাইর অইছে। ");
INSERT INTO syl_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","এরমাজে মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“আমি বনি ইছরাইলর হক্কল মাত-কথা হুনছি। অখন তুমি জানাই দেও, তারা পরতেক দিন হাইঞ্জা বালা খাইবা গোস্ত আর বিয়ানে খাইবা পেট ভরা রুটি। তেউ তারা বুজবা, আমি আল্লাউ তারার মাবুদ।” ");
INSERT INTO syl_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","হাছাউ হাইঞ্জা বালা কুয়েল পাখির পাল আইয়া তারার আস্তা কেম্পো জাম অইগেলো, বাদর দিন বিয়ানে খুয়া পড়িয়া কেম্পর চাইরোবায় ভিজিগেল। ");
INSERT INTO syl_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","বেইল অওয়ার বাদে অউ খুয়া হুকাইলে দেখা গেল, সাগুর দানার লাখান একজাতর পাতলা জিনিস মাটির উপরে পড়ি রইছে। ");
INSERT INTO syl_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ইতা দেখিয়া বনি ইছরাইলে একে-অইন্যয় জিকাইলা, “ওবা, ইতা কিতা? ইতা কিতা পড়ছে, আমরা কেউ তো চিনরাম না।” তেউ মুছায় কইলা, “ইতা তো বেহেস্তি খানি, তুমরা খাইতায় করি মাবুদে দান করছইন। ");
INSERT INTO syl_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","অউ খানির কথাউ মাবুদে হুকুম দিছইন, পরতেক জনে যারযির পরিবারর লাগি খানি তুকাইয়া নেও। ঘরর হকলর লাগি জন-পিছে এক পেটু করি তুকাইও।” ");
INSERT INTO syl_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","তেউ তারা অউলা করলা, মানুষ অনুমানে কেউ বেশ করি নিলা, কেউ কম নিলা। ");
INSERT INTO syl_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","বাদে পেটুদি মাপিয়া দেখলা, যেইন বেশি তুকাইছলা, তানও বেশি অইছে না, আর যেইন থুড়া তুকাইছলা, তানও কম অইছে না; হকলেউ যারযির পরিবারর খানির অনুমানে তুকাইছইন। ");
INSERT INTO syl_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","মুছায় তারারে কইলা, “তুমরা কাইল বিয়ানকুর খানির লাগি ইতা মোটেউ জমাই থইও না।” ");
INSERT INTO syl_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","তা-ও কেউ কেউ মুছার কথা না মানিয়া বাদর দিনর লাগিও থুড়া থইলো। এরলাগি ইতা পচিয়া কিড়া-পুক জন্মিয়া গন্দ বার অইলো; ইতা দেখিয়া মুছা তারার উপরে খুব গুছা অইলা। ");
INSERT INTO syl_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","অলা পরতেক দিন ফজরে তারা যারযির খানির অনুমানে তুকাইতো, অইলে রইদ গরম অইলেউ ইতা গলিযিতো। ");
INSERT INTO syl_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","বাদে ছয় নম্বর দিনো তারার খানির লাগি ডাবুল খানি, মানি দুই পেটু করি তুকাইলো, আর গুষ্টির মুরব্বি অকলে আইয়া মুছারে জানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","মুছায় তারারে কইলা, “ইতা ঠিক আছে, মাবুদেউ অউলা হুকুম দিছইন; কাইল তো হাপ্তার শেষ দিন, জুম্মাবার; মাবুদর পাক-পবিত্র দিন। তে তুমরার যেতা রান্দার দরকার আছে ইতা আইজ রান্দিলাও, আর বিরান করার জরুর অইলে বিরান করো, বাকি হকলতা বাদর দিন বিয়ানকুর লাগি থই দেও।” ");
INSERT INTO syl_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","অউ মুছার হুকুম মাফিক তারা বাদর দিন পর্যন্ত ইতা ঘরো থইলো, ইতার মাজে কুনু গন্দও বার অইলো না, কিড়ায়ও ধরলো না। ");
INSERT INTO syl_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","বাদে মুছায় তারারে কইলা, “আইজ তুমরা ইতা খাও, কারন আইজ মাবুদর পাক-পবিত্র দিন, জুম্মাবার। আইজ তুমরা বন্দর মাজে ই খানি পাইতায় নায়। ");
INSERT INTO syl_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","তুমরা হাপ্তাত ছয় দিন ই খানি তুকাইও, অইলে সাত নম্বর দিন তো জুম্মাবার, ই দিন ইতা পাইতায় নায়।” ");
INSERT INTO syl_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","তা-ও কুনু কুনু জনে সাত নম্বর দিনও অউ খানি তুকাইবার লাগি বারে গেল, গিয়া কুন্তা পাইলো না। ");
INSERT INTO syl_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","তেউ মাবুদে মুছারে কইলা, “তুমরা আর কতদিন আমার হুকুম আর নিয়ম-কানুন ভাংগিতায়? ");
INSERT INTO syl_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","হুনো, তুমরার জিরানির লাগি ই জুম্মাবার তো মাবুদেউ তুমরারে দিছইন, এরলাগি তাইন হাপ্তার ছয় নম্বর দিনো তুমরারে দুই দিনর খানি দেইন; অখন থাকি অউ সাত নম্বর দিন, মানি জুম্মাবারে তুমরা হকলে যারযির ঘরো রইয়া জিরাইও, কেউ ঘরর বারে যাইও না।” ");
INSERT INTO syl_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","এরবাদ থাকি হাপ্তার সাত নম্বর দিনো মানষে জিরাইতো। ");
INSERT INTO syl_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","বনি ইছরাইলে ই খানির নাম থইলো, মান্না; ইতা দেখতে ধলা ডুলা বিচির লাখান, আর খাইতে মউ মাখাইল পিঠার লাখান মজা। ");
INSERT INTO syl_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","বাদে মুছায় তারারে কইলা, “মাবুদে অউ হুকুম দিছইন, তুমরা এক পেটু পরিমান মান্না তুলিয়া তুমরার বাদর বংশধর অকলর লাগি জমা করি থও, তেউ তারাও দেখবা, মিসর দেশ থাকি তুমরারে বার করি নেওয়ার কালো মরুভুমির মাজে তাইন কিতা খাওয়াইছইন।” ");
INSERT INTO syl_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","মুছায় হারুনরে কইলা, “তুমি এগু বৈয়ামর মাজে এক পেটু পরিমান মান্না তুলিয়া মাবুদর ছামনে থও, ইতা তুমরার ওয়ারিশর পর ওয়ারিশ ধরি জমা রইবো।” ");
INSERT INTO syl_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","মাবুদে মুছারে যেলা হুকুম করছলা, অউ লাখান হারুনে অউ মান্না বৈয়ামো ভরলা। বাদে তাইন পবিত্র সন্দুকর ভিতরে শাহাদত পাথরর ছামনে থইলা। ");
INSERT INTO syl_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","বনি ইছরাইলে চাল্লিশ বরছ ধরি ই মান্না খাইলো, তারা যতদিন পর্যন্ত মানুষ বসত করার জাগা, মানি কেনান দেশর সীমানাত আইয়া না পৌছিলো, অতদিন অউ খানিউ খাইলা। ");
INSERT INTO syl_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","এক পেটু অইলোগি, এক ফুরারর দশ বাটর এক বাট। ");
INSERT INTO syl_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","বাদে মাবুদর হুকুমে তামাম বনি ইছরাইল ছীন মরুভুমি থাকি রওয়ানা দিয়া, এক জাগা থাকি আরক জাগাত গিয়া গিয়া হেশে রফিদিমো আইয়া তাম্বু গাড়িলা, অইলে হিনো মানষর খাওয়ার পানি আছিল না। ");
INSERT INTO syl_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","এরলাগি মানষে মুছার লগে কাইজ্জা করি কইলা, “আমরারে খাওয়ার পানি দেউক্কা।” মুছায় তারারে কইলা, “তুমরা কেনে আমার লগে কাইজ্জা কররায়? কেনে মাবুদরে পরিক্ষা কররায়?” ");
INSERT INTO syl_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","মানষে পানির পিয়াছে কাহিল অইয়া মুছার বিরুদ্ধে গালি-গালাজ করি কইলা, “তুমি আমরারে মারতায় করি মিসর দেশ থাকি আনছো নি? আমরারে, আমরার হুরুতাইন্তরে, আমরার পশুর পালরে আনা-পানিয়ে মারতায় করি অনো আনছো নি?” ");
INSERT INTO syl_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","তেউ মুছায় মাবুদর গেছে ফরিয়াদ করি কইলা, “আমি ই মানষরে কিতা করতাম? আর থুড়া দেরি অইলেউ তো তারা পাথরদি ইটাইয়া আমারে মারিলিবা।” ");
INSERT INTO syl_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","মাবুদে জুয়াপ দিলা, “তুমি যে লাঠিদি নীল নদো বাড়ি মারছলায়, হউ লাঠি আতো লও, আর বনি ইছরাইলর কয়জন মুরব্বিরে লগে লইয়া মানষর আগে আগে যাও। ");
INSERT INTO syl_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","গিয়া হারলে আমি তুর পাহাড়র কান্দাত এক পাথরর উপরে আজির অইমু, তুমি অউ পাথরো বাড়ি মারলে অগু থাকি পানি বার অইবো, তেউ মানষে খাইতা পারবা।” হাছাউ মুছায় ইছরাইলর মুরব্বি অকলর ছামনে অউলা করলা। ");
INSERT INTO syl_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","অউ রফিদিমো আইয়া মানষে কাইজ্জা করি কইছলা, “মাবুদ কিতা আমরার লগে আছইন নি, না হরি গেছইন?” অউলা কইয়া তারা মাবুদরে পরিক্ষা করছলা করি, ই জাগার নাম অইলো মাছা মানি, পরিক্ষা আর মেরীবা মানি, কাইজ্জা। ");
INSERT INTO syl_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","অউ সময় বনি ইছরাইলর লগে যুদ্ধ করার লাগি আমালেকী সিপাই অকল রফিদিমো আইলা। ");
INSERT INTO syl_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","তেউ মুছায় তান খাদিম হজরত ইউছারে কইলা, “তুমি আমরার মানুষ থাকি লাড়াই কররা জন বাছিয়া নিয়া, আমালেকী অকলর লগে যুদ্ধ করাত যাও। আমিও কাইল আল্লাই কুদরতি লাঠি আতো লইয়া পাহাড়র উপরে উবাইমু।” ");
INSERT INTO syl_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","ইউছায়ও মুছার হুকুম মাফিক কাম করলা। আমালেকী অকলর লগে যুদ্ধ করলা, মুছা, হারুন, আর হূর, অউ তিনো জন গিয়া পাহাড়র টিল্লার উপরে উঠলা। ");
INSERT INTO syl_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","বাদে দেখা গেল, মুছায় যত সময় আত উচা করি রাখইন, অতো সময় বনি ইছরাইলর দল জিতইন, অইলে মুছায় আত লামাইলেউ আমালেকী দল জিতইন। ");
INSERT INTO syl_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","আস্তে আস্তে মুছার আত ভার অওয়া ধরলো। অউ তারা একখান পাথর আনিয়া মুছারে বইবার বেবস্থা দিলা। অউ পাথরর উপরে মুছা বইলা, হারুন আর হূর দুইওজনে মুছার দুই গালাত উবাইয়া তান আত উচা করি ধরলা। তেউ সুরুজ ডুবার আগ পর্যন্ত তান আত উচা রইলো। ");
INSERT INTO syl_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","এরলাগি আমালেকী সিপাইর লগে যুদ্ধ করিয়া ইউছা জিতিগেলা। ");
INSERT INTO syl_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","বাদে মাবুদে মুছারে কইলা, “ইতা ইয়াদ রাখার লাগি তুমি একখান কিতাবর মাজে লেখিয়া থও আর ইউছারেও জানাও। মনো রাখিও, আমি দুনিয়ার বুক থাকি আমালেকী অকলর নাম মিটাইলিমু।” ");
INSERT INTO syl_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","মুছায় একখান কুরবানি খানা বানাইয়া এর নাম থইলা, মাবুদউ আমার যুদ্ধর ঝান্ডা। ");
INSERT INTO syl_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","তাইন কইলা, “মাবুদর যুদ্ধর ঝান্ডা আমরা আতো লই, তেউ মাবুদেও ওয়ারিশর পর ওয়ারিশ ধরি আমালেকী অকলর লগে যুদ্ধ করবা।” ");
INSERT INTO syl_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","আল্লায় হজরত মুছারে আর তান বন্দা বনি ইছরাইলরে যত লাখান রহম করছইন, ইতা হকলতা মুছার হউর মাদিয়ান দেশর ইমাম শোয়াইবর কানো গেলো। মাবুদে বনি ইছরাইলরে মিসর দেশ থাকি কিলা বার করি আনছইন, এওতা তাইন হুনলা। ");
INSERT INTO syl_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","মুছায় আগে তান বিবি সফুরারে হউর বাড়িত পাঠাই দিছলা, এরলাগি তান হউরে মুছার বিবিরে আর দুইও পুয়ারে নিজর গেছে রাখলা। ");
INSERT INTO syl_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ই দুইও পুয়ার মাজর একজনর নাম আছিল যারছুম মানি, বৈতল। মুছায় কইলা, “আমি ভিন দেশো বৈতলর লাখান রইরাম।” ");
INSERT INTO syl_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","আর দুছরা জনর নাম আছিল এলিয়েজের মানি, আল্লা সহায়। তাইন কইলা, “আমার বাফর আল্লা আমার সহায় অইয়া আমারে ফেরাউনর তলোয়ার থাকি হেফাজত করছইন।” ");
INSERT INTO syl_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","মুছার হউর শোয়াইবে মুছার বিবি আর তান দুইও পুয়ারে লইয়া মুছার গেছে আইলা। অউ সময় বনি ইছরাইল আর মুছার তাম্বু আছিল আল্লার পাহাড় তুরর কান্দাত। ");
INSERT INTO syl_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","তান হউর অনো আইয়া মুছারে খবর দিলা, “আমি তুমার হউর শোয়াইব। তে আমি তুমার বিবি আর দুইও পুয়ারে লইয়া অনো আইছি।” ");
INSERT INTO syl_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","খবর পাইয়া মুছায় তান হউরর লগে দেখা করাত বার অইলা। তাইন মাটিত সইজদা করিয়া তান হউররে ছালাম করলা আর মায়ার হুংগা দিলা। বাদে দুইওজনে ভালা-বুরা জিকাইয়া হারি তাম্বুর ভিতরে হামাইলা। ");
INSERT INTO syl_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","মাবুদে বনি ইছরাইলর পক্ষ লইয়া ফেরাউন আর মিসরী অকলর লগে যেতা যেতা করছইন, ইতা হক্কলতা তান হউররে হুনাইলা। মিসর থাকি যাওয়ার বালা তারার কত কষ্ট অইছিল আর আল্লায় কিলা তারারে বাচাইছইন এওতাও তানরে জানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","আর মাবুদে মিসরী অকলর আত থাকি বনি ইছরাইলরে আজাদ করিয়া তারারে যত লাখান আছান করছইন, ইতা হুনিয়া তান হউর খুব খুশি অইলা। ");
INSERT INTO syl_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","তাইন কইলা, “হকল তারিফ মাবুদর, যেইন ফেরাউন আর মিসরী অকলর আত থাকি তুমরারে আজাদ করছইন। ");
INSERT INTO syl_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","অখন আমি নিজেও বুজিয়ার, হকল দেবতার চাইতে আল্লাউ মহান। কারন মিসরীন্তে যেতা বেয়াপার লইয়া তুমরার বিরুদ্ধে বাহাদুরি করতা, ইতার কবজা থাকি তাইনউ তুমরারে বাচাইছইন।” ");
INSERT INTO syl_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","বাদে মুছার হউর শোয়াইবে আল্লার নামে জালাইল কুরবানি আর হকল জাতর কুরবানি জুইত করি লইয়া আইলা। হেশে হারুন আর বনি ইছরাইলর মুরব্বি অকল আইয়া, মুছার হউরর লগে বইয়া আল্লার ছামনে খানা-পিনা খাইলা। ");
INSERT INTO syl_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","বাদর দিন মুছায় মানষর বিচার-সালিশ করাত বইলা। বিচারর লাগি মানুষ আইয়া বিয়ান থাকি হাইঞ্জা পর্যন্ত হারাদিন তান ছামনে উবাই রইলা। ");
INSERT INTO syl_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","মুছায় অলা কররা দেখিয়া তান হউরে কইলা, “তুমি মানষরে লইয়া ইতা কিতা কররায়? কিতার লাগি তুমি একলা অনো বিচারো বইছো, আর বিয়ান থাকি হাইঞ্জা পর্যন্ত হকল মানুষ তুমার গেছে উবাই রইছে?” ");
INSERT INTO syl_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","মুছায় জুয়াপ দিলা, “বিচারর বেয়াপারে আল্লার ফয়ছালা হুনার লাগি মানুষ আমার গেছে আইন। ");
INSERT INTO syl_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","তারা কুনু কাইজ্জা-ফসাদ করলে আমার কাছাত আইন, আইলে আমি দুইও দলর বিচার করি, আর আল্লার হুকুম-আহকাম তারারে বাতাই।” ");
INSERT INTO syl_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","তেউ মুছার হউরে কইলা, “তুমি যেলাখান ইতা কররায়, ইতা তো ভালা নায়। ");
INSERT INTO syl_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","ইলা করলে তুমি আর তুমার হকল মানুষও কাহিল অইযিবায়। ই কাম তুমার তাক্কত থাকি বেশি, তুমি একলা ইতা কুলাইতায় পারতায় নায়। ");
INSERT INTO syl_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","তে আমি তুমারে কইয়ার, তুমি আমার পরামিশ হুনো, এতে আল্লাও তুমার লগে রইবা। তুমি মানষর বিচার-আচার ফয়ছালা করার নিয়তে, তারার ইমাম হিসাবে হকল বেয়াপার আল্লার ছামনে আজির করিও। ");
INSERT INTO syl_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","আর মানষরেও আল্লার হুকুম-আহকাম তালিম দিও। তারা কিলা চলতা, কিতা করতা না করতা, অতা তারারে বুজাইও। ");
INSERT INTO syl_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","আর তুমি এরার মাজ থাকি বাছিয়া অউলা যোইগ্য মানুষ বার করো, যেরা আল্লারে ডরাইন, হক পথে চলইন, আর ঘুষ খাওয়ারে ঘিন করইন। এরারে তুমি মানষর বিচার-আচারর দায়িত্ব দেও। এরা কুনু জনরে আজার জনর উপরে, কেউররে শ জন, কেউররে পইঞ্চাশ জন, আর কেউররে দশ জনর উপরে বিচার-আচারর ভার দেও। ");
INSERT INTO syl_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","এরাউ হামেশা মানষর বিচার-ইনছাফ করবা। হুরু-মুরু হকল বিচার তারা করবা, খালি বড় বড় বিচার তুমার গেছে আনবা। তেউ তুমার ভার কিছু কমবো, তারাও তুমার লগে কিছু ভার বউক্কা। ");
INSERT INTO syl_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","আল্লার হুকুম পাইয়া তুমি যুদি অউলা করো, তে তুমি কুলাইতায় পারবায়, আর মানষেও আরামে যারযির জাগাত যাইতা পারবা।” ");
INSERT INTO syl_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","মুছায় তান হউরর পরামিশ মানলা, তাইন যেলা কইলা মুছায় অউলা করলা। ");
INSERT INTO syl_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","মুছায় তামাম বনি ইছরাইল থাকি বাছিয়া উপযুক্ত মানুষ তুকাইয়া, তারা কেউররে আজার জন, কেউররে শ জন, কেউররে পইঞ্চাশ আর কেউররে দশ জনর উপরে নেতা বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","এরা হামেশা মানষর বিচার-আচার করতা। খালি বড় বড় ঘটনা অকল মুছার কাছাত আনতা, আর হুরু হুরু হকলতা তারা মিটাইতা। ");
INSERT INTO syl_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","হেশে মুছায় তান হউররে বিদায় দিলে, তাইন নিজর দেশো তশরিফ নিলাগি। ");
INSERT INTO syl_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","মিসর দেশ থাকি বনি ইছরাইল অকল বারনির বাদে, তিন নম্বর চান্দর পয়লা দিনউ তারা রফিদিম অইয়া সিনাই মরুভুমিত পৌছিলা। অনো আইয়া তারা মরুভুমির তুর পাহাড়র ছামনে তাম্বু গাড়িলা। ");
INSERT INTO syl_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","এরমাজে হজরত মুছা তুর পাহাড়র উপরে আল্লার দরবারো গেলা। মাবুদে পাহাড়র উপরে থাকি তানরে ডাকিয়া কইলা, “ও মুছা, তুমি ইয়াকুবর আওলাদ অকলরে কও, বনি ইছরাইলরে জানাই দেও, ");
INSERT INTO syl_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","আমি মাবুদে মিসরী অকলর দশা কিতা ঘটাইছি, ইতা তো তুমরার নিজর চউখে দেখছো। চিলে যেলা তার বাইচ্চারে ডাখনাদি বইয়া নেয়, আমিও অউ নমুনায় তুমরারে আমার গেছে বইয়া আনছি। ");
INSERT INTO syl_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","অখন তুমরা যুদি আমার তামাম হুকুম-আহকাম মানো, আর আমার লগর ওয়াদা আদায় করো, তে দুনিয়ার হক্কল জাতির মাজ থাকি তুমরাউ অইবায় আমার খাছ সম্পদ। মনো রাখিও, হারা দুনিয়ার হকলতাউ আমার এখতিয়ারো। ");
INSERT INTO syl_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","তুমরারে দিয়াউ কাইম অইবো আমার ইমাম অকলর বাদশাই, তুমরাউ অইবায় আমার পবিত্র জাতি। তে আমার অউ বুলি খানাইন তুমি বনি ইছরাইলরে জানাও।” ");
INSERT INTO syl_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","অউ মুছায় আইয়া বনি ইছরাইলর মুরব্বি অকলরে দলা করাইলা। দলা করাইয়া কইলা, মাবুদে তানরে কিতা কিতা হুকুম দিছইন। ");
INSERT INTO syl_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","তেউ হকল মানষে একলগে কইলা, “মাবুদে যেলা বাতাইছইন, আমরা অলা হক্কলতা করমু।” মানষে যেমনে জুয়াপ দিলা, মুছায় গিয়া মাবুদর দরবারো অলা জানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","আর মাবুদে মুছারে কইলা, “আমি যেবলা তুমার লগে বাতচিত করমু, অউ বাতচিত যাতে মানষে নিজর কানে হুনতো পারে, এরলাগি আমি ঘনো এক মেঘর কালনির মাজে রইয়া বাতচিত করমু। তেউ মানষে ইতা হুনবা, আর তুমার উপরে হর-হামেশা পুরাপুর একিন রাখবা।” বাদে মুছা গিয়া তারারও হকল কথা মাবুদরে জানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","ইখান হুনিয়া মাবুদে মুছারে কইলা, “তুমি আইজ আর কাইল দুইও দিন মানষর কাছাত গিয়া তারারে পাক-ছাফ করো। তারা যারযির কাপড়-চুপড় ধইয়া দেউক। ");
INSERT INTO syl_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","তারা পরশু দিনর লাগি তৈয়ার অউক, অউ দিন আমি মাবুদ তুর পাহাড়র উপরে লামিয়া আইয়া তারা হকলরে দিদার দিমু। ");
INSERT INTO syl_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","তে তুমি পাহাড়র চাইরোবায় একটা সীমানা ঠিক করিয়া দিলাও। দিয়া তারারে হুশিয়ার করি কও, তারা যানু ই পাহাড়ো না উঠে আর পাহাড়র সীমানাত না ছয়। কেউ যুদি ই পাহাড়ো ছয়, তে তার সাজা অইলো মউত। ");
INSERT INTO syl_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","মারার বালা তার গতরো আত না দিয়া, তারে পাথর বা তীর মারিয়া মারবায়। হে মানুষ অউক বা জানুয়ার অউক তারে মারিলিবায়। খালি একলগে বউত সময় শিংগা বাজানির আওয়াজ হুনলে, তারা অউ পাহাড়র কান্দাত আইতা পারবা।” ");
INSERT INTO syl_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","তেউ মুছায় পাহাড়ো থাকি লামিয়া আইয়া মানষরে পাক-ছাফ করলা, মানষে তারার কাপড়-চুপড় ধইয়া দিলো। ");
INSERT INTO syl_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","মুছায় তারারে কইলা, “তুমরা পরশু দিনর লাগি জুইত অও, এরমাজে কেউ বিবির লগে মিলা-মিশা করিও না।” ");
INSERT INTO syl_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","হাছাউ হউ পরশু দিন আইলে বিয়ানকু বালা পাহাড়র উপরে ঘনো মেঘর কালনি দেখা গেল, খুব বেশি মেঘর ডাক-জিলকানি শুরু অইলো। জুরে জুরে শিংগার আওয়াজ হুনা গেল, তেউ বনি ইছরাইলর কেম্পর ভিতরর হকল মানুষ ডরাইয়া কাপা ধরলা। ");
INSERT INTO syl_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","অউ সময় মুছায় মানষরে আল্লার ছামনে নেওয়ার লাগি কেম্প থাকি বার করলা। তারা হকল গিয়া পাহাড়র লামাত উবাইলা। ");
INSERT INTO syl_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","আর আস্তা তুর পাহাড় ধুমায় ভরি গেল, মাবুদ মউলায় আগুনির লাখান নুরর ছুরতে পাহাড়র উপরে তশরিফ আনলা। ইট-ভাট্টার ধুমার লাখান ধুমা উড়া শুরু অইলো আর আস্তা পাহাড় জুড়ি বেজুইতা কাপ শুরু অইলো। ");
INSERT INTO syl_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","সিংগার আওয়াজ আরো জুরে জুরে বাজিলো। অউ সময় মুছায় আল্লার লগে মাতিলা, আর আল্লায়ও নিজর আওয়াজদি মুছার মাতর জুয়াপ দিলা। ");
INSERT INTO syl_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","মাবুদ নিজে তুর পাহাড়র মাথাত লামিয়া আইয়া মুছারে ডাকিলা, তেউ মুছা উঠিয়া পাহাড়র উপরে গেলা। ");
INSERT INTO syl_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","গিয়া হারলে মাবুদে তানরে কইলা, “তুমি লামাত যাও, গিয়া মানষরে কড়া করি কইয়া আও, আরনায় আমারে দেখার লাগি তারা সীমানা পার অইয়া উপরে আইব্বা। আইলে বউত মানুষ মারা যাইবা। ");
INSERT INTO syl_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","আর যে ইমাম অকল হামেশা আমার ছামনে আজির অইন, আসলে তারার কামউ আমার ছামনে আজির অওয়া, তারাও নিজে নিজরে পাক-ছাফ করবা। আরনায় আমি তারার উপরেও গজব ঢালিমু।” ");
INSERT INTO syl_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","মুছায় মাবুদরে জুয়াপ দিলা, “তারা তো এমনেউ তুর পাহাড়ো আইতা নায়, আপনে আগেউ আমরারে কড়া হুশিয়ারি দিছইন। আমরাও পাহাড়র চাইরোবায় দাগ দিয়া আপনার লাগি পাক সীমানা আলগাইছি।” ");
INSERT INTO syl_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","অইলে মাবুদে তানরে কইলা, “না, তুমি লামাত যাও। বাদে তুমি আর হারুন দুইওজনে মিলিয়া উপরে আইও। খিয়াল রাখিও, কুনু ইমাম বা দুছরা কুনু মানুষ যাতে সীমানা ছাড়িয়া আমার কাছাত না আইন, আইলে আমি তারার উপরে লান্নতি গজব ঢালমু।” ");
INSERT INTO syl_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","ইখান হুনিয়া মুছা লামাত গেলা, গিয়া মানষরে হকলতা জানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","বাদে মাবুদে ফরমাইলা, ");
INSERT INTO syl_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“ও বনি ইছরাইল অকল, আমি আল্লাউ তুমরার মাবুদ। মিসর দেশর গুলামি থাকি আমিউ তুমরারে খালাছ করি আনছি। ");
INSERT INTO syl_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“আমার বদলা তুমরা দুছরা কুনু দেবতা মানিও না। ");
INSERT INTO syl_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“পুজা করার খিয়ালে তুমরা কুনু মুর্তি বানাইও না, আছমান, জমিন বা পানির তলে যততা আছে, ইতা কুনুতার ছুরতে মুর্তি বানাইও না। ");
INSERT INTO syl_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","তুমরা ইতার পুজা করিও না, ইতার সেবা-যতন করিও না। মনো রাখিও, আমি আল্লা তো লা-শরিক মাবুদ, কুনু শরিক সইয্য করি না। হুনো, আমারে যেরা মানে না, আমি তারার গুনার সাজা দেই, তারার তিন-চাইর ছিড়ি পর্যন্ত সাজা দেই। ");
INSERT INTO syl_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","অইলে যেরা আমার আশিক বনিয়া আমার হুকুম-আহকাম আমল করে, আমি তারার আজার আজার ওয়ারিশ পর্যন্ত আমার অবিরাম মায়া-মহব্বত দেখাইমু। ");
INSERT INTO syl_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“বেকামা কুনু কারনে তুমরার মাবুদ আল্লার নাম মুখো লইও না। কেউ যুদি খামোখা মাবুদর নাম লয়, তে কুনুমন্তেউ আমার সাজা থাকি রেহাই পাইতো নায়। ");
INSERT INTO syl_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“ইয়াদ করিয়া জুম্মাবাররে পবিত্র দিন মানিও। ");
INSERT INTO syl_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","হাপ্তার ছয়দিন তুমরা কাম-কাজ করিও, তুমরার দরকারি হকল কাম সারিও। ");
INSERT INTO syl_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","অইলে সাত নম্বর দিন অইলো জুম্মাবার, তুমার মাবুদ আল্লার নামে জিরাইবার দিন। ই দিন তুমি, তুমার পুয়া-পুড়িন, তুমার গুলাম-বান্দিন, তুমার পশুর পাল, তুমার গাউত বা টাউনো রওরা মুছাফির বা ভিন-দেশি, কেউ কুনুজাতর কাম-কাজ করিও না। ");
INSERT INTO syl_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","জানো তো, মাবুদে ছয়দিনে আছমান-জমিন, দরিয়া আর এরার মাজর হকলতা পয়দা করছইন, বাদে সাত নম্বর দিন জিরাইছইন, কুনু কাম করছইন না। অউ দিনরে মাবুদে রহমত দিয়া পাক দিন করছইন। ");
INSERT INTO syl_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“তুমরার মা-বাফরে ইজ্জত করিও। তেউ তুমরার মাবুদ আল্লায় যে দেশ দিবা, হউ দেশো তুমরার হায়াতি বাড়িবো। ");
INSERT INTO syl_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“খুন করিও না। ");
INSERT INTO syl_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“জিনা করিও না। ");
INSERT INTO syl_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“চুরি করিও না। ");
INSERT INTO syl_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“কেউরর বিরুদ্ধে মিছা সাক্ষি দিও না। ");
INSERT INTO syl_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“পরর ঘর-দুয়ারর বায় লালছ করিও না, তার বউ, গুলাম-বান্দি, গরু-গাধা, বা কুনু কিচ্ছুর বায় লালছ করিও না।” ");
INSERT INTO syl_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","বনি ইছরাইলে যেবলা পাহাড় থাকি মেঘর ডাক, জিলকানি, শিংগার আওয়াজ, আর ধুমা বারনিত দেখলা, দেখিয়া তারা দুরই থাকিউ ডরাইয়া কাপা ধরলা। ");
INSERT INTO syl_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","তারা মুছারে কইলা, “আপনেউ আমরার লগে মাতউক্কা, আমরা হুনমু; অইলে আল্লায় আমরার লগে বাতচিত করলে তো আমরা মরিযিমু।” ");
INSERT INTO syl_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","মুছায় তারারে কইলা, “তুমরা ডরাইও না। আল্লায় তুমরারে পরিক্ষাত ফালাইছইন, যাতে তুমরার জানো আল্লার ডর হামায়, ডরাইয়া তুমরা গুনা থাকি বাচিয়া রও। এরলাগিউ তাইন নিজে দিদার দিছইন।” ");
INSERT INTO syl_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","হকল মানুষ দুরই উবাই রইলা, আর মুছা আল্লার হাজিরার হউ মেঘর কালনির আন্দারির গেছে গেলা। ");
INSERT INTO syl_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","মাবুদে মুছারে কইলা, “তুমি বনি ইছরাইলরে কও, তুমরা নিজেউ তো দেখলায়, আমি মাবুদে আছমান থাকি তুমরার লগে বাতচিত করলাম। ");
INSERT INTO syl_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","এরলাগি এবাদত করার নিয়তে, আমার বদলা দুছরা কুনুজাত দেবতা বানাইও না। তুমরা সোনা বা রুপাদিও নিজর কুনু দেব-দেবী বানাইও না। ");
INSERT INTO syl_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“আমার লাগি খালি মাটি দিয়া কুরবানি খানা বানাইও। এর উপরে তুমরার জালাইল কুরবানি আর ছালামতি কুরবানির গরু-ছাগল আনিয়া কুরবানি দিও। যেতা জাগাইন্তো আমি আমার নাম ইয়াদ করাই দিমু, হউ জাগাইন্তো আমি নিজে আজির অইয়া তুমরারে দোয়া দিমু। ");
INSERT INTO syl_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","তুমরা আমার লাগি পাথরদি কুনু কুরবানি খানা বানানিত লাগলে, হি পাথরগুইন কাটিও না। এর উপরে আতিয়ার চালাইলে তুমরা ইতারে নাপাক বানাইলিবায়। ");
INSERT INTO syl_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","আমার কুরবানি খানা অউলা করি বানাইও, যাতে এর উপরে উঠতে কুনু মই বা ছিড়ি না লাগে, মই বা ছিড়ি বায় উঠাত গেলে কিবা তুমরার শরম দেখা যাইবো।” ");
INSERT INTO syl_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","মাবুদে মুছারে আরো কইলা, “তুমি বনি ইছরাইলরে আমার অউ নিয়ম-কানুন অকল জানাও। ");
INSERT INTO syl_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“তুমরা যুদি কুনু ইবরানি বেটারে খরিদ করিয়া গুলাম বানাও, তে অউ গুলামে ছয় বছর তুমরার গুলামি করবো, বাদে সাত বছরর বালা তার গেছ থাকি কুন্তা না নিয়া, তারে এমনেউ আজাদ করি দিবায়। ");
INSERT INTO syl_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","হে যুদি একলা তুমরার গেছে আয় তে একলাউ যাইবো; আর যুদি বউরে লগে লইয়া আয়, তে বউ লইয়া যাইবো। ");
INSERT INTO syl_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","অইলে তার মুনিবে যুদি তারে বিয়া করাই থাকে, আর তার কুনু হুরুতা-মুরুতা অইন, তাইলে ই বেটি আর হুরুতাইন মুনিবর গেছেউ রইবা; হে খালি একলা আজাদ অইবো। ");
INSERT INTO syl_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","আর হি গুলামে যুদি ছাফ করি কয় যেন, হে তার মুনিব আর তার বউ-বাইচ্চার মায়ায়, এরারে ছাড়িয়া যাইতো নায়, ");
INSERT INTO syl_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","তে ই মালিকে তারে লইয়া আল্লার দরবারো আজির অইবো। তারে দুয়ারর কপাট বা চৌকাঠর লগে উবা করিয়া মুনিবে শিক দিয়া তার কানো ফুড় করবো। তেউ হে হারা জিন্দেগিভর মুনিবর গুলামিত রইবো। ");
INSERT INTO syl_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“কুনু মানষে যুদি বান্দিগিরিত দিবার লাগি তার নিজর পুড়িরে বেচিলায়, তে গুলাম অকল যেলা ছয় বছর বাদে মুনিবর বাড়ি থাকি এমনেউ আজাদ অইযাইন, অউ পুড়ি তো ইলা আজাদ অইতো নায়। ");
INSERT INTO syl_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","তাইর মুনিব যুদি তাইর উপরে খুশি না অইন, তে টেকা-পয়সার বদলা তাইরে আজাদ করি দিতে অইবো। তাইরে দুছরা কুনু জাতির মানষর গেছে বেচিবার এখতিয়ার নাই, কারন মুনিবে তো তান নিজর দায়িত্ব আদায় করছইন না। ");
INSERT INTO syl_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","অইলে মুনিবে যুদি তান নিজর পুয়ার লাগি তাইরে পছন্দ করিয়া নেইন, তে তাইরে আপন পুড়ির লাখান হকল খেমতা দিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","মুনিবে যুদি অউ বান্দিরে বিয়া করার বাদে, দুছরা কুনু কইনারে বিয়া করে, তা-ও ই বান্দির খুরাকি, কাপড়-চুপড় আর শরিলর পাওনা হক তাইরে দেওয়া লাগবো। ");
INSERT INTO syl_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","হে যুদি অউ তিনো হক পুরাপুর আদায় না করে, তে ই পুড়িরে একদম বিনা পয়সায় আজাদ করি দিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“মাইর খাইয়া যুদি কুনু মানুষ মরিযায়, তে যেগিয়ে তারে মারছে, তারেও জানে মারা অইবো। ");
INSERT INTO syl_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","অইলে হে নিজে যুদি খুন না করার নিয়তে মারে, আখতা কুনু কারনে ঘটিযায় বা আমি আল্লার মর্জিয়ে ইতা অয়, তে অউ খুনি জন গিয়া অলা কুনু জাগাত বাগিতো পারবো, যে জাগার কথা আমি তুমরারে কইমু। ");
INSERT INTO syl_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","আর কেউ যুদি জানিয়া-হুনিয়া ইচ্ছা করি কেউররে খুন করিয়া, বাদে আইয়া আমার কুরবানি খানার গেছেও আশ্রয় লয়, তা-ও হন থাকি ধরিয়া নিয়া তারে জানে মারা অইবো। ");
INSERT INTO syl_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“যে মানষে তার আপন মা বা বাফর উপরে আত তুলে, তারে নিচয় জানে মারা অইবো। ");
INSERT INTO syl_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“কেউ যুদি কুনু মানষরে চুরি করিয়া আনিয়া বেচিলায়, বা অউ মানষরে তার গেছে পাওয়া যায়, তে তারে নিচ্চয় জানে মারা অইবো। ");
INSERT INTO syl_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“যে মানষে আপন মা বা বাফরে গালি-গালাজ করে, তারেও নিচ্চয় জানে মারা অইবো। ");
INSERT INTO syl_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“কুনু মানষে কাইজ্জাত লাগিয়া যুদি লগর জনরে ঠুসি বা পাথরদি মারে, ই মাইর খাইয়া অউ জন না মরলেও বিছনাত হুতিয়া পড়নো থাকে, ");
INSERT INTO syl_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","হেশে উঠিয়া লাঠি ভর দিয়া চলা-ফিরা করার জরুর অয়, তে যেগিয়ে তারে মারছে তারে জানে মারিও না। খালি হউ জনর কাম-কাজর খেতি আর তার ষোলআনা দাওয়াই খরচ দিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“কেউ যুদি তার খরিদা গুলাম-বান্দিরে লাঠি দিয়া মারে আর মাইর খাইয়া অগু মরিযায়, তে এরে সাজা দিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","অইলে মাইর খাওয়ার দুই-একদিন বাদে যুদি বাচিয়া রয়, তে কুনু সাজা দেওয়া লাগতো নায়, কারন অউ গুলাম তো তার নিজর ছামানা আছিল। ");
INSERT INTO syl_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“মারামারি করাত লাগিয়া যুদি আখতা কেউ কুনু বেটিরে মারে আর তাইর পেটর বাইচ্চা নষ্ট অইযায়, অইলে আর কুনু খেতি না অয়, তে অউ বেটির জামাইর দাবি আর বিচারি-সালিশর বিবেচনা মাফিক এরে খেতি-পুরন দিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","অইলে যুদি তাইর আরো কুনু খেতি অয়, তাইলে এরে অউ লাখান সাজা দিবায়: ");
INSERT INTO syl_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","জানর বদলা জান, চউখর বদলা চউখ, দাতর বদলা দাত, আতর বদলা আত, পাওর বদলা পাও, ");
INSERT INTO syl_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","জালানির বদলা জালানি, জখমর বদলা জখম, দাগর বদলা দাগ দিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“কেউ যুদি তার খরিদা গুলাম বা বান্দির কুনু চখুত মারায় চউখ নষ্ট অইযায়, তে অউ চউখর বদলা হে ই গুলামরে আজাদ করি দিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","যুদি মারিয়া এর দাত ফালাই দেয়, তা-ও এরে আজাদ করি দেওয়া লাগবো। ");
INSERT INTO syl_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“কুনু গরুয়ে গুতাইয়া যুদি কুনু বেটা বা বেটিরে মারিলায়, তে গরুর মালিকরে কুনু সাজা দেওয়া লাগতো নায়। খালি হি গরুরে পাথরদি ইটাইয়া মারিলিতে অইবো, ই গরুর গোস্ত কেউ খাইতো পারতো নায়। ");
INSERT INTO syl_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","অইলে ই গরুর যুদি হামেশা অউলা গুতানির খাইচ্ছত থাকে, আর হি মালিকরে হুশিয়ার করার বাদেও হে ইটারে আটকায় না, এরমাজে ই গরুয়ে কুনু বেটা বা বেটিরে মারিলায়, তে ই গরুরে পাথর মারিয়া মারিলিতে অইবো, আর তার মালিকরেও মারিলিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","যুদি ই মালিকর গেছে কুনু খেতি-পুরন চাওয়া অয়, তাইলে হে অউ জরিমানা দিয়া নিজর জান বাচাইতো পারবো। ");
INSERT INTO syl_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","ই গরুয়ে যুদি কুনু হুরুতারে গুতাইয়া মারিলায়, তাইলে এরলাগিও অউ হমান নিয়ম অইবো। ");
INSERT INTO syl_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","কুনু গরুয়ে যুদি কেউরর গুলাম বা বান্দিরে গুতাইয়া মারিলায়, তাইলে গরুর মালিকে হি গুলামর মালিকরে তিশ তোলা পরিমান রুপা দিতে অইবো আর হি গরুরেও পাথর মারি মারিলিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“কেউ যুদি কুনু গাতর মুখ খুলিয়া থয় বা গাত খুদিয়া ইগুর মুখ গুরিয়া না থয়, আর ই গাতর ভিতরে কুনু গরু বা গাধা পড়িযায়, ");
INSERT INTO syl_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","তাইলে গাতর মালিকে পশুর মালিকরে খেতি-পুরন দিতে অইবো। অইলে ই মরা পশু পাইবো গাতর মালিকে। ");
INSERT INTO syl_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“কেউরর গরুয়ে যুদি আরক জনর গরুরে গুতাইয়া মারিলায়, তে হউ জিতা গরুরে বেচিয়া, এর দাম আর মরা গরুর দামও এরা দুইওজনে হমান হমান করি বাটিয়া নিবা। ");
INSERT INTO syl_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","অইলে আগ থাকি যুদি জানা-হুনা থাকে যেন, ই গরুয়ে অলা গুতায়, আর তার মালিকে তারে না আটকায়, তে গরুর বদলা গরু দিতে অইবো, বদলা দেওরা জনে অউ মরা গরুটা পাইবো। ");
INSERT INTO syl_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“কেউ কুনু মানষর গরু বা মেড়া-ছাগল চুরি করিয়া আনিয়া যুদি বেচিলায় বা জবো করিলায়, তে এক গরুর বদলা পাচগু, এক মেড়া বা ছাগলর বদলা চাইরগু ফিরত দিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","চুরে তার চুরির মালর খেতি-পুরন দিতে অইবো, অইলে তার যুদি খেতি-পুরন দিবার কুনু তাক্কত না থাকে, তে তারে বেচিয়া এর খেতি-পুরন আদায় করতে অইবো। চুরি করা গরু-গাধা বা মেড়া-ছাগল যুদি চুরর গেছে জিতা পাওয়া যায়, তাইলে হে ইতা এগুর বদলা দুগু ফিরত দিতে অইবো। “কুনু চুরে যুদি চুরিত গিয়া ঘরো হামাইবার বালা ধরা খাইলায় আর জখম অইয়া মরিযায়, তাইলে তারে মারার লাগি মাররা জন দায়ী অইতো নায়। অইলে সুরুজ উঠার বাদে যুদি দিনর বালা ইলা অয়, তে ই খুনর লাগি হে দায়ী অইবো। ");
INSERT INTO syl_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“কেউ যুদি তার গরু-ছাগল নিজর বাগানো বা খেতর মাজে রাখাত গিয়া ছাড়ি দেয়, আর ইতায় গিয়া মানষর খেতর ফসল খাইলায়, তে তার নিজর খেতর হকল থাকি ভালা অংশ বদলা দিয়া খেতি-পুরন দিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“কুনু জাগা থাকি আগুইন লাগিয়া যুদি জুপ-জংগল জলে, আর বাদে অউ আগুইন গিয়া কেউরর খেতর মাজে বান্দা মুইট, টেকি বা আস্তা খেত জলি যায়, তে আগুইন যেগিয়ে জালাইছিল, হে ইতার খেতি-পুরন দিবো। ");
INSERT INTO syl_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“কেউ যুদি আরক জনর গেছে মাল-ছামানা বা টেকা-পয়সা আমানত থয়, আর আমানত-দারর ঘর থাকি ইতা চুরি অইযায়, তে অউ চুর ধরা পড়লে, চুরে এর ডাবুল ফিরত দিবো। ");
INSERT INTO syl_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","অইলে চুর ধরা না পড়লে, হি ঘরর মালিকে নিজেউ ইতা লুকাইছে নি, অখান জানার লাগি তারে আল্লার দরবারো আজির করবায়। ");
INSERT INTO syl_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“আরক জনর দখলো আছে, অউলা কুনু গরু-গাধা, মেড়া-ছাগল, ফিন্নর কাপড় বা যেকুনু আরাইল ছামানা দেখিয়া কেউ যুদি মনো করে ইটা তার মাল, তাইলে ইটার সালিশির লাগি তারা দুইওজন গিয়া আল্লার দরবারো আজির অইবো। আল্লায় যারে দুষি সাইবস্তো করবা, হে তার বিরুধি জনরে এর ডাবুল ফিরত দিবো। ");
INSERT INTO syl_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“কেউ যুদি তার গরু-গাধা, ছাগল-মেড়া বা অইন্য কুনু পশুরে কুনু গিরস্তর গেছে রাখাত দেয়, আর অগু মরিযায়, জখম অইযায় বা আরাইযায়, অইলে এর কুনু সাক্ষি না মিলে, ");
INSERT INTO syl_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","তে অউ গিরস্তে নিজেউ যেন ইতা করছে না, ইটা হে মাবুদর ছামনে গিয়া কছম করিয়া মিট-মাট করবো। ই পশুর মালিকেও ইখান মানতে অইবো, তাইন কুনু খেতি-পুরন পাইতা নায়। ");
INSERT INTO syl_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","অইলে ই গিরস্তর গেছ থাকি যুদি ইটা চুরি অইযায়, তে মালিকে খেতি-পুরন পাইবো। ");
INSERT INTO syl_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","যুদি কুনু জংলি জানুয়ারে ধরিয়া ইগুরে মারিলায়, তাইলে এর পরমানর লাগি অগুর ফারা-ছিড়া টুকরাইন আনিয়া দেখানি লাগবো। তেউ এর কুনু খেতি-পুরন লাগতো নায়। ");
INSERT INTO syl_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“কেউরর গেছ থাকি খুজিয়া আনা কুনু পশু যুদি মালিকর আফরখে জখম অয় বা মরিযায়, তে যেইন খুজিয়া আনছইন, এইন এর খেতি-পুরন দিবা। ");
INSERT INTO syl_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","অইলে মালিকর ছামনেউ যুদি অউলা অয়, তে খেতি-পুরন লাগতো নায়। ই পশু যুদি টেকা দিয়া ভাড়া করি আনা অয়, তে অউ ভাড়ার টেকাউ অইবো এর খেতি-পুরন। ");
INSERT INTO syl_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“বিয়ার আখত অইছে না, অউলা কুনু সতী পুড়িরে কেউ যুদি মিছা মাতিয়া আনিয়া তাইর লগে জিনা করিলায়, তাইলে হউ বেটায় পুড়ির বাফরে জরিমানা দিয়া অউ পুড়িরে বিয়া করতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","অইলে পুড়ির বাফে যুদি তার পুড়িরে ই পুয়ার গেছে বিয়া দিতে কুনুমন্তেউ রাজি না অয়, তা-ও ই জরিমানা দিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“কুনু যাদুগির বেটিরে তুমি জিতা রাখিও না। ");
INSERT INTO syl_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“কুনু পশুর লগে কেউ জিনা করলে, তারে নিচয় জানে মারা অইবো। ");
INSERT INTO syl_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“খালি মাবুদ ছাড়া দুছরা কুন্তার নামে যুদি কেউ কুনু বলি-পসাদ দেয়, তে তারেও শেষ করিলতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“কুনু ভিন-দেশি মানষর লগে বাদ বেবহার করিও না, তারে জুলুম করিও না। মনো রাখিও, তুমরাও এক সময় মিসর দেশো মুছাফির আছলায়। ");
INSERT INTO syl_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“কুনু ড়াড়ি বেটিরে বা কুনু এতিম হুরুতারে দুখ দিও না। ");
INSERT INTO syl_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","তারারে দুখ দিলে তারা যুদি কান্দে, তে ই কান্দন নিচয় আমি কবুল করমু। ");
INSERT INTO syl_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","এতে আমার গুছা অইবো আগুইন বরাবর। তুমরা যুদ্ধত পড়িয়া মরবায়, তুমরার বউও ড়াড়ি অইবো, তুমরার হুরুতাইনও অউলা এতিম অইবা। ");
INSERT INTO syl_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“তুমরা যুদি আমার কুনু অভাবি বন্দারে করজ দেও, তাইলে সুদখুরর লাখান তার গেছ থাকি সুদ নিও না। ");
INSERT INTO syl_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","কেউরর গতরর চাদ্দর বন্ধক রাখলে, সুরুজ ডুবার আগেউ তার চাদ্দর ফিরত দিলাইও। ");
INSERT INTO syl_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","কারন উড়িবার লাগি অটাউ তার একমাত্র সম্বল। ইখান নিলেগি হে কিতা উড়িয়া হুতিবো? হুনো, হে যুদি আমার গেছে কান্দে, তে আমি তো রহমানুর রহিম, আমি তার কান্দন হুনমুউ। ");
INSERT INTO syl_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“তুমি আল্লার বিরুদ্ধে মাতিও না, তুমার কুনু বিচারক-সালিশরেও বদদোয়া দিও না। ");
INSERT INTO syl_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“তুমরার খেতর ফসল বা আংগুরর শরবতর যে বাট আমারে দিবার কথা, আমার ই বাট দিতে দেরি করিও না। তুমরা হকলর বড় পুয়াইন আমারে দিলাইবায়। ");
INSERT INTO syl_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","তুমরার গরু-বাছুর আর ছাগল-মেড়ার লাগিও অউ এক সমান হুকুম। ইতার হকল বড় মেদা বাইচ্চাইন সাতদিন পর্যন্ত তারার মাʼর গেছে রইবা, আট দিনর দিন আমারে দিলাইবায়। ");
INSERT INTO syl_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“তুমরাউ অইবায় আমার পাক-পবিত্র বন্দা। জংলি জানুয়ারে মারিয়া ফালাইছে, ইলা কুনু জানদারর গোস্ত তুমরা খাইও না; ইতা কুকুররে খাওয়াইও। ");
INSERT INTO syl_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“তুমরা মিছা কুনু বদনাম বার করিও না। পক্ষপাতি করি মিছা সাক্ষি দিয়া কুনু খবিছ মানষরে সাইয্য করিও না। ");
INSERT INTO syl_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","সমাজর দশজনে অইন্যায় করের দেখিয়া তুমিও অউলা করিও না। কুনু মামলা-মকদ্দমার সাক্ষি দেওয়াত গিয়া, শক্তিআলা দলর পক্ষ লইয়া অইন্যায় কাম করিও না। ");
INSERT INTO syl_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","আর কুনু গরিবর বিচারো গিয়া, হে গরিব গতিকেউ তার পক্ষ লইও না। ");
INSERT INTO syl_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“তুমার দুশমনর কুনু গরু-গাধারে বে-পথে যাওয়াত দেখলে, ইটা ফিরাইয়া আনিয়া তার গেছে দিও। ");
INSERT INTO syl_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","তুমারে ইংসা করে ইলা কুনু মানষর গাধারে ভারর তলে পড়িগেছে দেখলে, তারে ইলা ফালাইয়া যাইও না। অউ গাধারে তুলাত তুমি অবশ্যই সাইয্য করবায়। ");
INSERT INTO syl_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“কুনু গরিবর মামলা-মকদ্দমাত অইন্যায় সালিশি করিও না। ");
INSERT INTO syl_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","হাজাইল মিছা মামলা থাকি হরিয়া রইও। কুনু বে-কছুর বা নি-অপরাধি মানষরে মউতর সাজা দিও না। যেগিয়ে ইলা অইন্যায় করবো, তারে আমি ছাড়তাম নায়। ");
INSERT INTO syl_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","ঘুষ খাইও না, কারন ঘুষে চউখ আলা মানষরেও আন্দা করিলায়। ঘুষে ভালা মানষর মাতর মাজেও পেচ লাগাই দেয়। ");
INSERT INTO syl_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“কুনু ভিন-দেশি মানষর উপরে জুলুম করিও না। মুছাফিরর হাল-হকিকত তো তুমরা জানো, কারন তুমরাও মিসর দেশো মুছাফির আছলায়। ");
INSERT INTO syl_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“তুমরা একলাগারে ছয় বরছ জমিনো খেত করিও আর ফসল কাটিও, ");
INSERT INTO syl_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","বাদে সাত নম্বর বরছো জমিনো কুনু খেত না করিয়া পতিত রাখিও, জমিনরে আরাম দিও। এতে জমিনো এমনেউ যেতা ফলিবো, অতা তুমরার গরিব অকলে খাইয়া বাচিবা। তারা নেয়ার বাদে যেতা পড়ি রইবো, ইতা জংলি পশু-পাখিন্তে খাইবা। তুমরার আংগুরর বাগান বা জয়তুন বাগানর লাগিও অউ হুকুম মানিও। ");
INSERT INTO syl_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“তুমরা হাপ্তাত ছয় দিন কাম করিও, অইলে সাত নম্বর দিন তো জুম্মাবার, ইদিন কুন্তা করিও না। তেউ তুমরার গরু-গাধায় জিরাইবা, আর তুমরার বাড়িত জন্মিছে ই গুলাম আর মুছাফির অকলর জানেও আরাম পাইবো। ");
INSERT INTO syl_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“আমি তুমরারে যেতা হুকুম দিলাম, ইতা খুব হুশিয়ার অইয়া আমল করিও। কুনু দেবতার নাম মুখো লইও না, ইতার নাম যানু তুমরার মুখো না হুনা যায়। ");
INSERT INTO syl_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“তুমরা পরতেক বরছ তিনবার আমার নামে ইদ আদায় করিও। ");
INSERT INTO syl_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","পয়লা, খামির ছাড়া রুটির ইদ আদায় করিও। আমি যেলা হুকুম করছি, এক্কেরে অউ লাখান আবীব চান্দর সাতদিন খামির ছাড়া রুটি খাইও, কারন অউ চান্দো তুমরা মিসর থাকি বার অইয়া আইছলায়। ইদর সময় লিল্লা-ছদগা ছাড়া তুমরার কেউ যানু খালি আতে আমার গেছে না আয়। ");
INSERT INTO syl_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","দুছরা, তুমরা ফসল দাওয়ার ইদ মানিও। খেতর মাজে তুমরা যেতা রুইছো, ইতা দাওয়ার বাদে পয়লা ফসল দিয়াউ ইদ করিও। তিছরা ইদ, বছরর হেশ চান্দো বাগানর পাকনা ফল বাড়িত আনার বাদে ডেরা-ঘরর ইদ করিও। ");
INSERT INTO syl_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","অউ তিনো ইদর সময়, বছরো তিনবার তুমরার হকল বেটাইন আইয়া হজ করার নিয়তে আমি আল্লা মালিকর ছামনে আজির অইও। ");
INSERT INTO syl_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“তুমরা যেবলা আমার নামে পশু কুরবানি দেও, অউ সময় খামির আলা কুনুজাত রুটি ইতার লগে পুরাইয়া লিল্লা দিও না। ইদর সময় আমার নামে যেতা পশু কুরবানি দিবায়, ইতার চর্বিআলা টুকরাইন বিয়ান পর্যন্ত রাখিও না। ");
INSERT INTO syl_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","তুমরার খেতর হকল থাকি ভালা ফসল, তুমরার মাবুদ আল্লার ঘরো আনিও। “আর হুনো, কুনু ছাগলর বাইচ্চার গোস্ত তার মাʼর দুধ দিয়া রান্দিও না। ");
INSERT INTO syl_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“আমি তুমরার লাগি যে জাগা জুইত করি রাখছি, হনো তুমরারে হেফাজতে পৌছানির লাগি, আমি তুমরার আগে আগে একজন ফিরিস্তা পাঠাইমু। ");
INSERT INTO syl_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","তুমরা এন কথা মন দিয়া হুনিও আর মানিও, এন লগে তো আমিও আছি। হুশিয়ার রইও, এন বিরুদ্ধে যাইও না। আরনায় এইন তুমরার অপরাধ মাফ করতা নায়। ");
INSERT INTO syl_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","অইলে তুমরা যুদি এন হুকুম মানো, আর আমি যেলা কইছি অউলা চলো, তাইলে তুমরার দুশমনর লগে আমি দুশমনি করমু, যেরা তুমরার বিরুদ্ধে লাগবো, আমি তারার বিরুদ্ধে লাগমু। ");
INSERT INTO syl_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","আমোরী, হিট্টী, ফারিজী, কেনানী, হিব্বী আর যিবুজী অকলর দেশো আমার ফিরিস্তায় তুমরারে নিয়া হারাইবা। আমি তারা হকলটিরে বিনাশ করিলিমু। ");
INSERT INTO syl_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","তুমরা তারার দেবতারে পুজা করিও না, খেজমতও করিও না, আর হিনর মানষে যেতা করইন তুমরা ইতা করিও না। তুমরা তারার দেব-দেবীর মুর্তিন আর তারার পুজার মন্ডপ অকল ভাংগিয়া চুরমার করিলিও। ");
INSERT INTO syl_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","তুমরা খালি তুমরার মাবুদ আল্লা, মানি আমার এবাদত করিও। তেউ তুমরার রিজেকর মাজে রহমত দিমু, আর তুমরার হক্কল বেমার-আজার দুর করমু। ");
INSERT INTO syl_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","তুমরার দেশর কুনু বেটির পেটর হুরুতা নষ্ট অইতো নায়, কেউ আটকুরা রইতো নায়। আমি তুমরারে পুরাপুর হায়াতি পর্যন্ত বাচাইয়া রাখমু। ");
INSERT INTO syl_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","তুমরা যত জাতির কাছাত যাইবায়, তারার দিলর মাজে আগ থাকি আমার ডর-খফ পয়দা করমু, তারারে বেদিশা বানাইলিমু। তুমরার হক্কল দুশমন খরেদি বাগিবা। ");
INSERT INTO syl_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","হিব্বী, কেনানী আর হিট্টী অকলরে তুমরার ছামনা থাকি খেদাইবার লাগি, আমি তুমরার আগে করি ভিংগুলর পাল পাঠাইমু। ");
INSERT INTO syl_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","অইলে আমি তারা হক্কলরে একই বছরর ভিতরে খেদাইতাম নায়, আরনায় আস্তা দেশ পতিত রইয়া জংলি জানুয়ারে ভরিযিবা, বাদে ইতায় তুমরারে ছাতাইবা। ");
INSERT INTO syl_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","আমি আস্তে আস্তে তারারে খেদাইমু, আর তুমরার মানুষ বাড়িয়া আস্তা দেশ আবাদ করবায়। ");
INSERT INTO syl_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","আমি নীল দরিয়া থাকি ফিলিস্তিনী দেশর সাগর, মানি ভূমধ্য সাগর পর্যন্ত, আর দউকনর মরুভুমি থাকি ফোরাত গাং পর্যন্ত তুমরার দেশর সীমানা গাড়মু। ই দেশো যেরা বসত করের তারারে তুমরার আতো সপিমু, আর তুমরা তারারে ই দেশ থাকি খেদাই দিবায়। ");
INSERT INTO syl_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","তারার লগে বা তারার দেবতা অকলর লগে তুমরা কুনু চুক্তি করিও না। ");
INSERT INTO syl_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","তুমরার দেশর ভিতরে তারারে রইবার দিও না। আরনায় তারা তুমরারে আমার গেছ থাকি হরাইয়া গুনার পথে টানিয়া নিবোগি। তুমরা যুদি তারার দেব-দেবীর পুজা করো, তাইলে নিচ্চিত তুমরাও তারার ফান্দো হামাইবায়।” ");
INSERT INTO syl_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","মাবুদে মুছারে কইলা, “তুমি আর হারুন, হারুনর পুয়াইন নাদাব আর আবিহু, আর বনি ইছরাইলর সত্তইর জন মুরব্বি নেতা আমার গেছে উঠিয়া আও। আইবার বালা তুমরা দুরই থাকি আমারে সইজদা করিও। ");
INSERT INTO syl_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","অইলে খালি তুমি একলা আমার কাছাত উপরে আইবায়, আর কেউ নায়। এরার লগে আর কুনু বনি ইছরাইল যানু না উঠে।” ");
INSERT INTO syl_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","মুছায় মানষর গেছে আইয়া মাবুদর হক্কল কালাম আর আইন-কানুন হুনাইলা, ইতা হুনিয়া হকল মানষে একলগে কইলা, “মাবুদে যততা বাতাইছইন ইতা হক্কলতা আমরা মানমু।” ");
INSERT INTO syl_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","মাবুদর বাতাইল হকল কালাম মুছায় লেখিয়া থইলা। বাদর দিন ফজরে উঠিয়া পাহাড়র লামাত একখান কুরবানি খানা বানাইলা, আর বনি ইছরাইলর বারো গুষ্টিরে ইয়াদ রাখার লাগি বারোগু খুটা বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","বাদে তাইন বনি ইছরাইলর জুয়ান অকলরে পাঠাইলা আর তারা মাবুদর নামে বউত জালাইল কুরবানি দিলা, আর বউত বিছাল জবো করিয়া ছালামতি কুরবানিও দিলা। ");
INSERT INTO syl_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","মুছায় কুরবানির লউর অর্ধেক নিয়া কয়টা বাটিত থইলা, আর বাকি অর্ধেক নিয়া কুরবানি খানার উপরে ছিটাই দিলা। ");
INSERT INTO syl_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","বাদে তাইন আল্লার লগে মিলনর উছিলার নিয়ম-কানুন লেখা কিতাব খান তিলাওত করি মানষরে হুনাইলা। ইতা হুনিয়া মানষে জুয়াপ দিলা, “আমরা মাবুদর হকল হুকুম হুনমু, তাইন যততা কইছইন হকলতা মানমু।” ");
INSERT INTO syl_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","অখান হুনিয়া মুছায় লউ লইয়া মানষর উপরে ছিটাইয়া কইলা, “ই লউ অইলো আল্লাই মিলনর হউ উছিলার লউ, যে উছিলা মাবুদে তান হকল শর্ত মাফিক তুমরার লগে বওয়াল করছইন।” ");
INSERT INTO syl_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","তেউ মুছা, হারুন, নাদাব, আবিহু আর বনি ইছরাইলর সত্তইর জন মুরব্বি নেতা পাহাড়র উপরে উঠলা। ");
INSERT INTO syl_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","তারা নিজর চউখে বনি ইছরাইলর আল্লা পাকর দিদার দেখলা। তারা দেখলা, আল্লার পাও মুবারকর তলে আছে, চকচকা লীল মনি পাথরর তৈয়ারি ছাতর লাখান, আছমানর নমুনায় ছাফ। ");
INSERT INTO syl_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","বনি ইছরাইলর মুরব্বি অকলে আল্লারে দেখলেও তাইন এরারে মারার লাগি আত তুললা না। তারা তান দিদার পাইলা আর খাওয়া-দাওয়া করলা। ");
INSERT INTO syl_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","বাদে মাবুদে মুছারে কইলা, “তুমি অউ পাহাড়র উপরে আমার কান্দাত আও, আইয়া কয়দিন রও। মানষরে তালিম দিবার লাগি আমার যে হুকুম-আহকাম পাথরর উপরে লেখছি, অতা আমি তুমারে দিমু।” ");
INSERT INTO syl_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","তেউ মুছায় তান খাদিম ইউছারে লগে লইয়া পাহাড়ো উঠলা, আর মুছা আল্লার পাহাড়ো গেলা। ");
INSERT INTO syl_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","তাইন মুরব্বি অকলরে কইয়া গেলা, “আমরা ফিরত আইবার আগ পর্যন্ত আপনারা আমরার লাগি অনো বার চাইবা। হারুন আর হূর আপনারার কাছাত আছইন, কুনু কাইজ্জা-ফসাদ লাগলে এরার গেছে যাইবা।” ");
INSERT INTO syl_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","মুছা পাহাড়ো উঠতেউ আস্তা পাহাড় মেঘর কালনিয়ে গুরি গেলো, ");
INSERT INTO syl_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","আর তুর পাহাড়র উপরে মাবুদর নুরর তজল্লি জাইর অইলো। ছয় দিন আস্তা পাহাড় কালনিয়ে গুরা রইলো। সাত নম্বর দিন অউ কালনি থাকি মাবুদে মুছারে ডাকিলা। ");
INSERT INTO syl_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","বনি ইছরাইলে মাবুদর নুরর তজল্লি দেখলা, তারা দেখলা পাহাড়র উপরে আগুনির লাখান জলের। ");
INSERT INTO syl_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","পাহাড় বাইয়া উঠি উঠি মুছা হউ কালনির ভিতরে হামাই গেলা। তাইন চাল্লিশ দিন চাল্লিশ রাইত হউ পাহাড়ো রইলা। ");
INSERT INTO syl_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“তুমি বনি ইছরাইলরে কও, তারা আমার গেছে দান-খয়রাত লইয়া আজির অউক। তারার নিজর খুশিয়ে যেতা দান করবা, অতা তুমি সমজিয়া রাখিও। ");
INSERT INTO syl_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","তারার গেছ থাকি অউ লাখান মাল সমজিও: সোনা, রুপা, পিতল; ");
INSERT INTO syl_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","লিলুয়া, বাইংগনি, লাল রংগর সুতা; দামি সুতি কাপড় আর ছাগলর রুমা; ");
INSERT INTO syl_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","লাল রং লাগাইল মেড়ার চামড়া, দরিয়া ফুʼ মাছর চামড়া; বাবলা লাকড়ি; ");
INSERT INTO syl_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","চেরাগ অকল জালানির লাগি জয়তুনর তেল; খেলাফতি সমজিবার তেলর মশলা আর আগর-খুশবয় বানানির মশলা; ");
INSERT INTO syl_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ইমামর লেবাছর এফ্রোন আর বুকুর উপরর থলিত লাগানির আকিক মনি আর বাকি হকল জাতর দামি পাথর। ");
INSERT INTO syl_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“আমার রওয়ার লাগি তুমি বনি ইছরাইল অকলরেদি পাক-পবিত্র একখান জাগা তৈয়ার করাইবায়। তেউ আমি তারার লগে বসত করমু। ");
INSERT INTO syl_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","আমার রওয়ার ঘর আর মাল-ছামানার বেয়াপারে আমি তুমারে যেলা নমুনা দেখাইমু, এক্কেরে অউ লাখান করি হকলতা তিয়ার করাইও। ");
INSERT INTO syl_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“তারা বাবলা লাকড়ি দিয়া এগু সন্দুক বানাইবা। ইটা লাম্বায় আড়াই আত, দেড় আত পাশ আর দেড় আত উচা। ");
INSERT INTO syl_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","এর বারে-ভিতরে খাটি সোনাদি লেপিয়া দিও, আর চাইরো কিনারো সোনার নকশা লাগাইও। ");
INSERT INTO syl_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","আগুইনদি সোনা গলাইয়া চাইরটা কড়া এর চাইরো কুনাত লাগাইও, অগালাত দুইটা আর হগালাত দুইটা লাগাইও। ");
INSERT INTO syl_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","বাবলা লাকড়িদি দুগু বেন্দা বানাইয়া সোনাদি লেপিয়া দিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","সন্দুকরে বইয়া নেওয়ার লাগি দুইও গালার কড়ার মাজেদি, অউ দুইও বেন্দা হারানি লাগবো। ");
INSERT INTO syl_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","বেন্দা দুইওটা সন্দুকর কড়ার ভিতরে হারাইল রইবো, ইগুইন খুলিও না। ");
INSERT INTO syl_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","আমি আমার হুকুম-আহকাম লেখা যে পবিত্র শাহাদত পাথর তুমারে দিমু, তুমি ইটা অউ সন্দুকর ভিতরে থইও। ");
INSERT INTO syl_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“খাটি সোনাদি সন্দুকর একখান ঢাকনা বানাইও, অখানর উপরে গুনার কফরা আদায় করা অইবো। ই ঢাকনা লাম্বায় আড়াই আত আর পাশে দেড় আত অইবো। ");
INSERT INTO syl_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","19","তুমি হউ ঢাকনার কিনারো সোনা পিটাইয়া দুগু কারুবী বানাইও। অউ কারুবী দেখতে দুলদুল ঘোড়ার লাখান ডাখনা আলা। বানাইয়া সন্দুকর দুই গালাত লাগাইও, অগালাত একটা, আর হগালাত একটা। দুইও কারুবী ঢাকনার লগে অউ লাখান করি সোনাদি বানানি লাগবো, যেটা আস্তাটায় খালি এক চিজ অয়। ");
INSERT INTO syl_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","এর ডাখনা দুইওখান উপরেদি মেলাইল রইবো, আর এর ছায়ার তলে থাকবো সন্দুকর ঢাকনা। দুইও কারুবী মুখামুখি উবা থাকবো, আর তারার চউখ রইবো ঢাকনার বায়। ");
INSERT INTO syl_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","ই ঢাকনারে সন্দুকর উপরে লাগাইও, আর আমার হুকুম-আহকাম লেখা যে শাহাদত পাথর তুমারে দিমু, অউ পাথর তুমি সন্দুকর ভিতরে থইও। ");
INSERT INTO syl_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","ই শাহাদত সন্দুকর ঢাকনার উপরে দুইও কারুবীর মাজখানো, আমি তুমারে দিদার দিমু। অউ দিদারর সময় বনি ইছরাইলর লাগি আমার হকল আইন-কানুন জানাইমু। ");
INSERT INTO syl_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“বাবলা লাকড়ি দিয়া দুই আত লাম্বা, এক আত পাশ আর দেড় আত উচা করি একখান টেবুল বানাইও। ");
INSERT INTO syl_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","অখানরে খাটি সোনাদি লেপিয়া চাইরো কিনারো নকশা লাগাইও। ");
INSERT INTO syl_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","টেবুলর চাইরো কিনারো চাইর আংগুল উচা করি এক হাজ দিবায়, হাজর মাজে সোনাদি নকশা করবায়। ");
INSERT INTO syl_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","টেবুলর চাইরো কুনাত চাইরো পায়ার উপরে সোনার চাইরটা কড়া লাগাইবায়। ");
INSERT INTO syl_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","ই চাইরো কড়াইন টেবুলর কুনার হউ উচা হাজর তলে লাগাইও, যাতে টেবুল বইয়া নেওয়ার বালা কড়ার ভিতরে বেন্দা হারাইল যায়। ");
INSERT INTO syl_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","বেন্দা দুইওটা বাবলা লাকড়িদি বানাইয়া সোনাদি লেপিবায়, অউ বেন্দাদি টেবুল বইয়া নিবায়। ");
INSERT INTO syl_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","টেবুলর উপরর থাল-বাসন, আল্লার নামে ঢালিয়া দিবার শরবত-পানির ছদগার জগ আর মগ, হকলতা খাটি সোনাদি বানানি লাগবো। ");
INSERT INTO syl_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","অউ টেবুলর উপরে আমার ছামনে হামেশা পবিত্র রুটি রাখবায়, ই রুটি যানু সব সময় থওয়া অয়।” ");
INSERT INTO syl_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","মাবুদে মুছারে কইলা, “তুমি খাটি সোনাদি একখান চেরাগ দানি বানাইবায়, চেরাগ দানির তলা আর ডান্ডি খাটি সোনা পিটাইয়া গড়াইবায়। অউ ডান্ডি, ফুলর লাখান পিয়ালা, কুড়ি আর পাপড়ি অকল, চেরাগ দানির হকলতায় একলগে এক পিছ অইবো। ");
INSERT INTO syl_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","চেরাগ দানির ডান্ডির দুই গালাত তিনটা করি মোট ছয়টা ডাল থাকবো। ");
INSERT INTO syl_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","পরতেক ডালর মাজে জবা ফুলর লাখান তিনগু করি পিয়ালা থাকবো। চেরাগ দানির ছয়ও ডালো এক লাখান কাম করা অইবো। ");
INSERT INTO syl_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","চেরাগ দানির মুল ডান্ডির মাজেও জবা ফুলর লাখান চাইরটা পিয়ালা থাকবো। ");
INSERT INTO syl_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","অউ মুল ডান্ডি থাকি বারইল ছয়টা ডালর মাজে, পয়লা দুইও ডালর জুড়াত এগু কুড়ি, দুছরা দুইও ডালর জুড়াত আরক কুড়ি, আর হেশর দুইও ডালর জুড়াতও কুড়ি দিও। ");
INSERT INTO syl_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","কুড়ি আর ডাল হকলতা চেরাগ দানি থাকি বার অইবো, হকলতা মিলিয়া এক চিজ অইবো। আস্তাটাউ খাটি সোনা পিটাইয়া বানানি লাগবো। ");
INSERT INTO syl_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","এরবাদে সাতটা চেরাগ বানাইয়া অউ চেরাগ দানির উপরে অউ লাখান করি লাগানি লাগবো, যাতে চেরাগ অকল জালানির বাদে চেরাগ দানির ছামনা ফর অয়। ");
INSERT INTO syl_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","চেরাগর ফিতা ছাফ করার চিমটা আর জালাইল ফিতার ছালি থওয়ার লাগি কয়গু বাটি, খাটি সোনাদি বানানি লাগবো। ");
INSERT INTO syl_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","চেরাগ দানির হকলতা বানানির লাগি এক মন খাটি সোনা লাগবো। ");
INSERT INTO syl_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","“হুনো, অউ পাহাড়র উপরে তুমারে যেলা নকশা দেখাইল অইলো, এক্কেরে অউ লাখান করি হকলতা বানাইও।” ");
INSERT INTO syl_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","মাবুদে মুছারে কইলা, “তুমি দশ টুকরা পেচাইল সুতার দামি সুতি কাপড়দি আমার ঘরর পর্দাইন বানাইও। আর লিলুয়া, বাইংগনি, লাল সুতাদি ভালা উস্তাদরেদি এর মাজে কারুবী অকলর ছবি বাইন করাইও। ");
INSERT INTO syl_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","হকল টুকরাইন এক মাপর অইবো, লাম্বায় আটাইশ আত আর ফাড়ে চাইর আত। ");
INSERT INTO syl_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","ই টুকরাইন্তর পাচখান পাচখান করি একখানো জুড়া দিয়া, দুখান বড় গিলাফ বানাইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","বড় গিলাফর পয়লা টুকরার পাশর এক কিনারো লিলুয়া সুতাদি হুকর ফুড় বানাইতে অইবো। দুছরা টুকরাতও অউলা করতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","পয়লা গিলাফর কিনারো পইঞ্চাশগু হুকর ফুড় আর দুছরা গিলাফো অউলা পইঞ্চাশগু ফুড় দিতে অইবো। দুইও বড় গিলাফর হুকর ফুড় এগু আরেগুর উল্টামুখা থাকবো। ");
INSERT INTO syl_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","বাদে সোনাদি পইঞ্চাশগু হুক বানাইয়া হউ ফুড়র মাজেদি হারাইয়া, বড় দুইও গিলাফরে আটকাই দিও। তেউ ই দুইও টুকরাদি একখান ঘর তিয়ার অইবো। ");
INSERT INTO syl_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“আমার ঘরর উপর গুরার লাগি ছাগলর রুমা দিয়া গিলাফর লাখান এগারোখান টুকরা বানানি লাগবো। ");
INSERT INTO syl_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","হকল টুকরাইন এক মাপর অইবো, তিশ আত লাম্বা আর চাইর আত ফাড়। ");
INSERT INTO syl_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","অন থাকি পাচ টুকরা একলগে জুড়া দিয়া বড় এক গিলাফ বানাইতে অইবো। আর বাকি ছয় টুকরা জুড়া দিয়া, বড় আরক গিলাফ বানাইয়া হারলে, অউ দুছরা গিলাফর যে টুকরা বাড়তি রইবো, অখানরে তাম্বুর ছামনর বায় দুই ভাইঞ্জ করি দিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","পয়লা বড় গিলাফর পাশর এক কিনারো পইঞ্চাশগু হুকর ফুড় বানাইতে অইবো, আর দুছরা গিলাফোও অউলা অইবো। ");
INSERT INTO syl_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","বাদে পিতল দিয়া পইঞ্চাশগু হুক বানাইয়া হউ হুকর ফুড়র মাজে হারাইয়া, অউ বড় দুইও গিলাফ একখানো জুড়া দিতে অইবো। তেউ ই দুইও গিলাফ মিলিয়া একখান ছানি অইবো। ");
INSERT INTO syl_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","ছাগলর রুমার বড় গিলাফর যে আধা টুকরা বাড়তি অইবো, ইখান খরেদি লটকাইল রইবো। ");
INSERT INTO syl_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","ই গিলাফ খান তলর কাপড় থাকি এক আত বড় অওয়ায় ইখান দুইও গালাবায় লটকাইল রইয়া হারা ঘররে গুরিলিবো। ");
INSERT INTO syl_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","এর উপর গুরার লাগি লাল রং করা মেড়ার চামড়াদি আরোখান গিলাফ বানাইয়া গুরি দিতে অইবো। বাদে এর উপরে দরিয়ার ফুʼ মাছর চামড়াদি ছানি তৈয়ার করি গুরি দিতে অইবো।” ");
INSERT INTO syl_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","মাবুদে মুছারে কইলা, “আমার ঘরর লাগি বাবলা লাকড়িদি কʼখান ফ্রেইম বানানি লাগবো। ");
INSERT INTO syl_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","পরতেক ফ্রেইম বানাইবায় দশ আত লাম্বা আর দেড় আত ফাড়। ");
INSERT INTO syl_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","অউ ফ্রেইমো দুগু করি পায়া থাকবো। হকল ফ্রেইম এক লাখান বানাইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","দক্ষিন গালার লাগি বিশখান ফ্রেইম বানানি লাগবো। ");
INSERT INTO syl_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ই ফ্রেইমর পায়ার তলে দেওয়ার লাগি চাল্লিশগু রুপার চুঙি বানানি লাগবো, পরতেক ফ্রেইমর দুই পায়ার লাগি দুগু চুঙি লাগবো। ");
INSERT INTO syl_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","আমার ঘরর উত্তর গালার লাগিয়াও বিশখান ফ্রেইম লাগবো, ");
INSERT INTO syl_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","আর পরতেক ফ্রেইমর পায়ার তলর লাগি দুগু করি চাল্লিশগু রুপার চুঙি বানানি লাগবো। ");
INSERT INTO syl_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","পইচমর গালার লাগি, মানি খর গালার লাগি ছয়খান ফ্রেইম, ");
INSERT INTO syl_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","আর খরর দুইও কুনার লাগি আরো দুখান ফ্রেইম লাগবো। ");
INSERT INTO syl_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","ই দুই ফ্রেইমরে দুই কুনার দুইও ফ্রেইমর লগে তলে-উপরে একখানো জুড়া দিতে অইবো। পরতেক কুনার দুই ফ্রেইম ধারর ফ্রেইমর লগে বাত্তি মারিয়া একলগে জুড়া দিতে অইবো। দুইও কুনা এক লাখান অইবো। ");
INSERT INTO syl_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","তেউ খরেদি আটখান ফ্রেইম অইবো, আর পরতেক ফ্রেইমর তলে দেওয়ার লাগি দুগু করি ষোলগু রুপার চুঙি লাগবো। ");
INSERT INTO syl_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“তুমি ফ্রেইমরে জুড়া দিবার লাগি বাবলা লাকড়িদি কয়গু লাম্বা বাত্তি বানাইও। ");
INSERT INTO syl_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","এর মাজে পাচগু বাত্তি ঘরর এক গালার লাগি, আর বাকি পাচগু আরক গালার লাগি, আর পাচগু লাগবো খর গালা, মানি পচিম গালার ফ্রেইমর লাগি। ");
INSERT INTO syl_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","ফ্রেইমর মাজখানো লাগাইল অউ বাত্তিদি হকল ফ্রেইমর এক মাথা থাকি আরক মাথা পর্যন্ত আটকাইবায়। ");
INSERT INTO syl_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","ফ্রেইম খানাইন সোনাদি লেপতে অইবো, আর বাত্তি হারানির লাগি সোনার কড়া বানাইয়া ফ্রেইমো লাগাইতে অইবো। ই বাত্তি অকলও সোনাদি লেপতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","আমার ঘরর যে নকশা তুমারে অউ তুর পাহাড়র উপরে দেখাইলাম, তুমি এক্কেরে অউ লাখান করি ইটা তৈয়ার করাইও।” ");
INSERT INTO syl_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","মাবুদে মুছারে কইলা, “তুমি লিলুয়া, লাল, বাইংগনি সুতা আর পেচাইল দামি সুতি কাপড়দি একখান পর্দা বানাইও। ভালা কুনু উস্তাদরেদি এর উপরে কারুবী অকলর ছবি বাইন করাইও। ");
INSERT INTO syl_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","ই পর্দাখান বাবলা লাকড়িদি চাইরটা খুটির লগে লাগাইয়া সোনার কড়াদি লটকাই দিবায়, খুটির মাথাত সোনার কড়া লাগাইবায়। আর খুটিগুইন সোনাদি লেপাইবায়, খুটির তলাত রুপার চুঙি লাগাইবায়। ");
INSERT INTO syl_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","পর্দার উপরর সুতি কাপড়ো লাগাইল হুকর লগে পর্দাখান লটকাইল রইবো। ই পর্দার খরে শাহাদত সন্দুক থইবায়। পর্দাদি আমার ঘরর হেরেম শরিফ, মানি খাছ পাক জাগা আর পাক জাগার মাজখানো বেড়া দিও। ");
INSERT INTO syl_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","অউ হেরেম শরিফর ভিতরে শাহাদত সন্দুকর উপরে এর ঢাকনা লাগাইও। ");
INSERT INTO syl_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","ই পর্দার বারে হেরেম শরিফর উত্তর গালাত পবিত্র রুটি রাখার টেবুলখান থইও, আর এর উল্টামুখা দক্ষিন গালাত থইও চেরাগ দানি। ");
INSERT INTO syl_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“আমার ঘরর দুয়ারর লাগি একখান পর্দা বানাইও, ইখান দামি সুতি কাপড়দি বানাইয়া হারি, লিলুয়া, বাইংগনি, লাল রংগর সুতাদি নকশা করিও। ");
INSERT INTO syl_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","ই পর্দার লাগি সোনার কড়া আর বাবলা লাকড়ির পাচটা খুটি বানাইও। খুটিগুইন সোনাদি লেপাইও, খুটির তলাত পিতলর পাচগু চুঙি লাগাইও।” ");
INSERT INTO syl_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","মাবুদে মুছারে কইলা, “তুমি বাবলা লাকড়িদি পাচ আত লাম্বা, পাচ আত পাশ আর তিন আত উবি দিয়া চাইরকুনি করি একখান কুরবানি খানা তৈয়ার করাইও। ");
INSERT INTO syl_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","এর চাইরো কুনার উপরে লাকড়িদি চাইরটা হিং দিও। অউ হিং কুনার লাকড়ি খুদিয়া বানানি লাগবো, ই আস্তাখান এক চিজ অইবো। বাদে পুরা কুরবানি খানা পিতলদি লেপাইও। ");
INSERT INTO syl_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","কুরবানি খানার ছালি তুলার বড় চামচ আর গামলা, লউ থওয়ার বাটি, গোস্ত তুলার বড় কাটা-ছিফ, আংরা থওয়ার পাতিল, হকলতা পিতলদি বানাইও। ");
INSERT INTO syl_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","পিতলদি একখান জালি বানাইবায়। এর চাইর কুনাত চাইরটা পিতলর কড়া লাগাইও। ");
INSERT INTO syl_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","কুরবানি খানার তলা থাকি উপরর মাজামাজি জাগার তাড়িয়ার তলে অউ জালি বওয়াইও। ");
INSERT INTO syl_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","কুরবানি খানা বইয়া নিবার লাগি বাবলা লাকড়িদি দুগু বেন্দা বানাইও, বানাইয়া দুইওগু পিতলদি লেপিও। ");
INSERT INTO syl_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","ই বেন্দাইন কড়ার ভিতরেদি হারানি লাগবো। তেউ কুরবানি খানা বইয়া নেয়ার বালা দুইও বেন্দাইন কুরবানি খানার দুই গালাবায় থাকবো। ");
INSERT INTO syl_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","কুরবানি খানা তক্তাদি বানাইয়া এর ভিতরে ফাক রাখিও। আমি অউ পাহাড়র উপরে তুমারে যেলা নকশা দেখাইলাম, এক্কেরে অলাখান করি বানানি লওয়াইও। ");
INSERT INTO syl_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“আমার ঘরর চাইরোবায় উঠান থাকবো। এর দক্ষিন গালাবায় একশো আত রাখিও, ই মুখা দিবায় দামি সুতি কাপড়র পর্দা। ");
INSERT INTO syl_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","ই পর্দা টানানির লাগি বিশগু খুটি দিবায়। খুটির তলাত দিবায় একটা করি পিতলর চুঙি, পর্দা টানানির লাগি রুপার কড়া আর বান্দিবার তার লাগাইবায়। ");
INSERT INTO syl_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","উত্তর গালাবায় একশো আত উঠান রাখবায়। হনোও পর্দা দিও, বিশগু খুটি, বিশগু পিতলর চুঙি, খুটির লগে লাগাইও রুপার কড়া আর তার। ");
INSERT INTO syl_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","পইচমে পইঞ্চাশ আত উঠান রাখিও, হনোও কয়খান পর্দা, দশগু খুটি, পরতেক খুটির তলাত একটা করি চুঙি দিও। ");
INSERT INTO syl_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","পুবেদিও পইঞ্চাশ আত উঠান রাখিও; ");
INSERT INTO syl_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","গেইটর এক গালাত পনরো আত লাম্বা পর্দা, তিনটা খুটি আর তিনটা চুঙি লাগাইবায়, ");
INSERT INTO syl_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","অলা দুছরা গালাতও পনরো আত পর্দা, তিনটা খুটি আর তিনটা চুঙি দিও। ");
INSERT INTO syl_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","উঠানর গেইটর লাগি চাইরটা খুটি, চাইরটা চুঙি আর বিশ আত লাম্বা একখান পর্দা। পর্দাখান দামি সুতি কাপড়দি বানাইয়া লিলুয়া, বাইংগনি, লাল সুতাদি নকশা করাইও। ");
INSERT INTO syl_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","উঠানর চাইরো গালার হক্কল খুটিরে বান্দিবার তার আর কড়া অইবো রুপার, এর তলে পিতলর চুঙি থাকবো। ");
INSERT INTO syl_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","উঠানখান লাম্বায় একশো আত আর পাশে পইঞ্চাশ আত অইবো। এর চাইরোবায় পাচ আত উবি পর্দা দিও, পর্দা অইবো দামি সুতি কাপড়র, আর খুটিন্তর তলে দিও পিতলর চুঙি। ");
INSERT INTO syl_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","আমার ঘরর কামর হকল চিজ পিতলদি বানাইবায়, মুল তাম্বু আর উঠানর বেড়ার টানার রশির তলর পেরেগ অকল পিতলর অইবো। ");
INSERT INTO syl_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“তুমি বনি ইছরাইল অকলরে হুকুম দিও, তারা জয়তুন ছেচিয়া তেল বানাইয়া তুমার গেছে আনতো, যাতে চেরাগ অকল হামেশা জালাইল রয়। ");
INSERT INTO syl_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","মিলন-তাম্বুর শাহাদত সন্দুকর ছামনে যে পর্দাখান থাকবো, অউ পর্দার বারে হারুন আর তার পুয়াইন্তে হাইঞ্জা থাকি ফজর পর্যন্ত, মাবুদর ছামনে চেরাগ গুইন দেখা-হুনা করবা। আমার অউ হুকুম যানু বনি ইছরাইলে ওয়ারিশর পর ওয়ারিশ ধরি হর-হামেশা আমল করে।” ");
INSERT INTO syl_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","মাবুদে মুছারে কইলা, “ও মুছা, বনি ইছরাইলর মাজে ইমামতি করার লাগি তুমার ভাই হারুন, তার পুয়া নাদাব, আবিহু, আলি-আজর আর ইছামাররে তুমার ছামনে আনাও। ");
INSERT INTO syl_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","“তুমার ভাই হারুনর ইজ্জত আর সুন্দর বাড়ানির লাগি পবিত্র লেবাছ তৈয়ার করাও। ");
INSERT INTO syl_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","আমি পাক রুহ দিয়া যেতা উস্তাদ অকলরে কারিগরি কামর আখল-হেকমত দিছি, তুমি হউ কারিগর অকলরে হুকুম দেও, তারা হারুনর লাগি অউলা পবিত্র লেবাছ বানাউক্কা, যে লেবাছ খালি আমার ইমামতির কামো লাগে। ");
INSERT INTO syl_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","ই লেবাছর মাজে বুকুর উপরর থলি, এফ্রোন, আলখেল্লা, চেকর কাপড়র পাইঞ্জাবি, পাউগড়ি আর কমরর বন্দনি বানাইও। তুমার ভাই হারুন আর তার পুয়াইন্তে যাতে আমার ইমামতি কাম করতা পারইন, এরলাগি তারার পাক-পবিত্র লেবাছ বানাইও। ");
INSERT INTO syl_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","লেবাছ বানাইতে তারা লিলুয়া, বাইংগনি, লাল সুতা, আর দামি সুতি কাপড়, এর লগে সোনাও লাগাইবা। ");
INSERT INTO syl_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“পরধান ইমামর এফ্রোন বানাইবায় লিলুয়া, বাইংগনি, লাল সুতা, দামি সুতি কাপড়, আর সোনাদি। ইতা ভালা কুনু উস্তাদরেদি বানাইও। ");
INSERT INTO syl_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","এফ্রোনর কান্দর দুই গালা জুড়া দিবার লাগি দুখান পট্টি বানাইয়া, এফ্রোনর উপরর কুনাত লাগাইও। ");
INSERT INTO syl_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","এফ্রোনর লগে জুড়া লাগাইল পেটর উপরর বেল্ট খানও এফ্রোনর লাখান লিলুয়া, বাইংগনি, লাল সুতা, দামি সুতি কাপড়, আর সোনাদি বানাইও। ");
INSERT INTO syl_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“তুমি দুইটা আকিক পাথর আনিয়া এর উপরে ইছরাইল, মানি ইয়াকুবর পুয়াইন্তর নাম খুদাইয়া লেখাইও। ");
INSERT INTO syl_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","পয়লা পাথরর উপরে, তারার জন্মর হিসাবে বড় থাকি হুরু মুখা ছয় জনর নাম, আর দুছরা পাথরর উপরেও বাকি ছয় জনর নাম খুদাইয়া লেখাইও। ");
INSERT INTO syl_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","হুনার অকলে দামি পাথরর উপরে খুদিয়া যেলা সীল বানাইন, এক্কেরে অউ লাখান করি দুগু পাথরর উপরে ইছরাইলর পুয়াইন্তর নাম খুদাইও। ");
INSERT INTO syl_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","পাথর দুইওগু সোনার জাজইরর মাজে লাগাইয়া এফ্রোনর কান্দর পট্টির লগে লাগাইও। ইছরাইলর পুয়াইন্তর বায় মাবুদর নজর রাখার লাগি, ই পাথর হারুনে মাবুদর ছামনে তার কান্দর মাজে লাগাইবো। ");
INSERT INTO syl_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","14","দুইও জাজইরর লগে সোনাদি বানাইল দুকছা চেইন লাগাইও। অউ দুইও চেইন খাটি সোনাদি রশির নমুনায় পেচাইয়া বানাইও। ");
INSERT INTO syl_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“আমার রায়-ফয়ছালা জানার লাগি বুকুর উপরর থলি বানাইও। ভালা উস্তাদ কুনু দর্জিরেদি বানাইও। এফ্রোনর কামর লাখান ইটাও লিলুয়া, বাইংগনি, লাল সুতা, দামি সুতি কাপড়, আর সোনাদি বানাইও। ");
INSERT INTO syl_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","ইটা অইবো লাম্বায় আধা আত, পাশে আধা আত, চাইর কুনা আলা দুই ভাইঞ্জ করা একখান কাপড়। ");
INSERT INTO syl_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","এর উপরে হাইর ধরাইয়া চাইর হাইর পাথর লাগাইবায়। পয়লা হারিত ইয়াকুত, পীত, আর পান্না মনি। ");
INSERT INTO syl_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","দুছরা হারিত লালমনি, লীল মনি আর হীরা; ");
INSERT INTO syl_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","তিন নম্বর হারিত ফিরুজ, গোমেদ আর পদ্মরাগ মনি। ");
INSERT INTO syl_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","চাইর নম্বর হাইরো পোখরাজ, বৈদুর্য আর সুরুজ মনি। ই পাথর অকল সোনার জাজইরদি লাগাইও। ");
INSERT INTO syl_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","ইছরাইলর বারো পুয়ার লাগি বারোটা পাথর লাগবো। ইতা একো পাথরো এক এক পুয়ার নাম খুদিয়া লেখাইও, যেলা খুদিয়া সীল বানাইল অয়। ");
INSERT INTO syl_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“বুকুর উপরর থলির লাগি খাটি সোনাদি রশির লাখান পেচাইয়া দুকছা চেইন বানাইও। ");
INSERT INTO syl_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","সোনার দুইটা কড়া বানাইয়া বুকুর অউ থলির উপরর কুনাত লাগাইও। ");
INSERT INTO syl_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","আর চেইন দুইওগেছা দুইও কড়ার লগে আটকাইও। ");
INSERT INTO syl_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","দুইও কান্দর এফ্রোনর ছামনর ফিতাত সোনার জাজইরর লগে চেইনর এক মাথা বান্দিও। ");
INSERT INTO syl_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","আরো দুইটা সোনার কড়া বানাইয়া বুকুর উপরর থলির দুই কুনাত লাগাইও। ই দুইওটা এফ্রোনর লগে বুকুর থলির তলে রইবো। ");
INSERT INTO syl_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","বাদে আরো দুইটা সোনার কড়া বানাইয়া, এফ্রোনর কান্দর পট্টির সই তলেদি, পেটর উপরর বেল্টর উপরর সিলাইর কাছাত লাগাইও। ");
INSERT INTO syl_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","বাদে বুকুর উপরর থলির তলর কড়ার লগে পেটর উপরর নকশা করা বেল্টর কড়া লিলুয়া সুতাদি বান্দিও। তেউ অউ থলি এফ্রোনর উপরে থাকি হরতো নায়। ");
INSERT INTO syl_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“পাক জাগাত হামাইবার বালা হারুনে আমার রায়-ফয়ছালা হুনার লাগি, বুকুর উপরর থলির উপরে লেখা ইছরাইলর বারো পুয়ার নাম লাগাইতে অইবো, ই থলিটায় তারারে হর-হামেশা মাবুদর ছামনে রাখবো। ");
INSERT INTO syl_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","আমার রায়-ফয়ছালার অউ থলির ভিতরে উরিম আর তুম্মিম নামর পবিত্র পাথরগুইন রাখিও। হারুন যেবলা মাবুদর ছামনে আজির অইবো, অউ সময় ইতা তার বুকুর উপরে রইবো। হারুনে বনি ইছরাইলর লাগি আমার রায়-ফয়ছালা জানার উপায় হিসাবে হর-হামেশা তার বুকুর উপরে মাবুদর দেওয়া অউ চিজ রাখবো।” ");
INSERT INTO syl_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","মাবুদে মুছারে কইলা, “এফ্রোনর তলে লাম্বা যে আলখেল্লা রইবো, ইকটা পুরাটাউ লিলুয়া রংগর সুতাদি বানাইও। ");
INSERT INTO syl_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","মাথা হারাইবার লাগি এর মাজখানো ফাক রাখিও। ই ফাক জাগা যাতে না ছিড়ে, এরলাগি এর চাইরো গালা মজবুত করি বাইন করতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","লিলুয়া, বাইংগনি, লাল রংগর সুতাদি আনুয়ার ফলর লাখান বানাইয়া, অউ আলখেল্লার তলর মুড়ির চাইরোবায় লাগাইও। আর ইতার মাজে মাজে দিও সোনার ঘুংগুর। ");
INSERT INTO syl_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","ই মুড়িত দিবায় এগু করি আনুয়ার আর এগু ঘুংগুর। ");
INSERT INTO syl_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","ইমামতি করার বালা হারুনে ই লেবাছ ফিন্দিবো। হে যেবলা পাক জাগাত মাবুদর ছামনে আজির অইবো, আর হন থাকি বারে বার অইবো, অউ সময় অউ ঘুংগুর অকলর আওয়াজ হুনা যাইবো, তেউ হে মরতো নায়। ");
INSERT INTO syl_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“খাটি সোনাদি একখান পাত বানাইয়া এর উপরে সীলর লাখান খুদিয়া অউ আয়াত লেখাইও, ‘মাবুদর নামে পাক-পবিত্র।’ ");
INSERT INTO syl_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","ই পাতখান পাউগড়ির ছামনর গালাত লাগাইয়া লিলুয়া সুতাদি বান্দিও। ");
INSERT INTO syl_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","ইটা হারুনর কপালর উপরে রইবো। যত পাক-পবিত্র মাল বনি ইছরাইলে দান-খয়রাত লইয়া আইবা, ইতার হকল নমুনার দুষ-তিরুটির ভার হারুনে বইবো। মাবুদে যাতে তারারে কবুল করইন, এরলাগি হারুনে কপালর উপরে ই সোনার পাতখান হামেশা লাগাইয়া রাখবো। ");
INSERT INTO syl_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","ইমামর পাইঞ্জাবি আর পাউগড়ি তৈয়ার করাইও চেকর দামি সুতি কাপড়দি। কমরর বন্দনি খান সুই-সুতাদি নকশা করি বানাইও। ");
INSERT INTO syl_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“হারুনর পুয়াইন্তর ইজ্জত আর সুন্দরর লাগি পাইঞ্জাবি, তকি আর কমরর বন্দনি তৈয়ার করাইও। ");
INSERT INTO syl_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","তুমি তুমার ভাই হারুন আর তার পুয়াইন্তরে ই কাপড় ফিন্দাইও। তারার মাথাত পবিত্র তেল ঢালিয়া খেলাফতি সমজাইয়া ইমামতি কামো লাগাইও। তুমি তারারে পাক-পবিত্র করিও, যাতে তারা আমার ইমাম অইতা পারইন। ");
INSERT INTO syl_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","কমর থাকি উরাত পর্যন্ত শরমর জাগা গুরার লাগি সুতি কাপড়দি হাফ-পেন্টর লাখান জাংগিয়া বানাইও। ");
INSERT INTO syl_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","হারুন আর তার পুয়াইন যেবলা মিলন-তাম্বুত হামাইবা, বা কুরবানি খানার গেছে পাক জাগাত হামাইয়া ইমামতির কামো লাগবা, অউ সময় তারা অউ জাংগিয়া ফিনবা। তেউ তারা নি-অপরাধি রইবা, মরতা নায়। হারুন আর তার ওয়ারিশর ছিলছিলার লাগি ই আইন হর-হামেশা চালু রইবো।” ");
INSERT INTO syl_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","মাবুদে মুছারে কইলা, “তুমি ইমাম অকলরে অউ লাখান পাক-ছাফ করিও, যাতে ইমাম বনিয়া তারা আমার এবাদত কাম চালাইতা পারইন। তুমি নিখুত এগু বিছাল আর দুগু মেড়ার পাঠা আনাইও। ");
INSERT INTO syl_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","এরলগে ময়দাদি রুটি, তেলদি ভাজা পিঠা, আর তেল মাখাইল চাপাটি বানাইও। ইতা কুন্তাতউ খামির মিশাইও না। ");
INSERT INTO syl_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","অতা বানাইয়া এক টুকরিত লইও, এরলগে হউ বিছাল আর দুইও মেড়ার পাঠা লইয়া আমার ছামনে আইও। ");
INSERT INTO syl_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","বাদে হারুন আর তার পুয়াইন্তরে মিলন-তাম্বুর দুয়ারর কাছাত আনিয়া, পানিদি নাওয়াই দিও। ");
INSERT INTO syl_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","আর হউ পবিত্র লেবাছ অকল আনিয়া হারুনরে ফিন্দাইও। পাইঞ্জাবি, আলখেল্লা, এফ্রোন আর বুকুর উপরর থলি হকলতা ফিন্দাইও। এফ্রোনর লগে উস্তাদি আতর বানাইল হউ পেটর উপরর বেল্ট খানও বান্দিয়া দিও। ");
INSERT INTO syl_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","তার মাথাত পাউগড়ি ফিন্দাইও আর সোনার পাতদি বানাইল পবিত্র তাজ খানও লাগাইও। ");
INSERT INTO syl_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","বাদে খেলাফতির তেল তার মাথাত ঢালিয়া তারে খেলাফতি দিও। ");
INSERT INTO syl_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","তার পুয়াইন্তরেও আনিয়া পাইঞ্জাবি ফিন্দাইও। ");
INSERT INTO syl_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","হারুন আর তার পুয়াইন্তরে কমরর বন্দনি বান্দিয়া দিও। পুয়াইন্তর মাথাত দিও তকি। অউ লাখান হারুন আর তার পুয়াইন্তরে ইমামর পদো বওয়াল করিও, যাতে চিরকালিন নিয়ম হিসাবে ইমামতির পদ খালি তারার বংশত থাকে। ");
INSERT INTO syl_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“বাদে হউ বিছালরে তুমি মিলন-তাম্বুর ছামনে আনিও, হারুন আর তার পুয়াইন্তে অগুর কল্লা আতাইয়া দিবা। ");
INSERT INTO syl_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","আতানির বাদে অউ বিছালরে মিলন-তাম্বুর দুয়ারর কাছাত নিয়া মাবুদর ছামনে জবো করিও। ");
INSERT INTO syl_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","জবো করিয়া হারলে থুড়া লউ তুমার আংগুলিত লাগাইয়া কুরবানি খানার হিংগর মাজে লাগাইও, আর বাকি লউ কুরবানি খানার তলে ঢালি দিও। ");
INSERT INTO syl_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","বিছালর পেটর ভিতরর আত-ভড়র চর্বি, কইলজার লগর মাটিয়া, দুইও কিডনি আর এর চর্বি, কুরবানি খানার উপরে নিয়া জালাইলিও। ");
INSERT INTO syl_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","এর গোস্ত, খাল, আত-ভড় গুফর সুদ্ধা বনি ইছরাইলর কেম্পর বারে নিয়া জালাইলিও, ইতা তো গুনার কফরার কুরবানি। ");
INSERT INTO syl_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“বাদে হউ দুইও মেড়া থাকি এগু মেড়া আনিও, আনলে হারুনে আর তার পুয়াইন্তে অগুর কল্লা আতাইয়া দিবা। ");
INSERT INTO syl_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","আর অউ মেড়ারে জবো করিয়া এর লউ নিয়া কুরবানি খানার চাইরো গালাত ছিটাই দিও। ");
INSERT INTO syl_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","মেড়ারে কাটিয়া টুকরাইয়া তার ঠেং আর পেটর ভিতরর হকলতা ধইয়া, কল্লা আর বাকি টুকরাইন্তর লগে থইও। ");
INSERT INTO syl_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","হেশে ই আস্তাগু কুরবানি খানার উপরে নিয়া জালাইলিও। ইতা অইলো মাবুদর নামে জালাইল কুরবানি, মাবুদর নিয়তে আগুনিত দেওয়া ঘেরান আলা ছদগা। ");
INSERT INTO syl_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“বাদে দুছরা মেড়ারেও আনিয়া হারুনে আর তার পুয়াইন্তে কল্লা আতাই দিবা। ");
INSERT INTO syl_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","আতানির বাদে অগুরে জবো করিয়া এর থুড়া লউ নিয়া হারুন আর তার পুয়াইন্তর ডাইন কানর লতিত, ডাইন আতর আর ডাইন পাওর বুড়ি আংগুলর মাজে লাগাইও। আর বাকি লউ নিয়া কুরবানি খানার চাইরো গালাবায় ছিটাই দিও। ");
INSERT INTO syl_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","বাদে খেলাফতির তেল আর কুরবানি খানা থাকি থুড়া লউ লইয়া, হারুন আর তার পুয়াইন্তর গতরো আর লেবাছর উপরে ছিটাই দিও। তেউ লেবাছ সুদ্ধা হারুন আর তার পুয়াইন পাক-ছাফ অইবা। ");
INSERT INTO syl_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","তুমি অউ মেড়ার চর্বি, চর্বি আলা লেংগুড়, পেটর ভিতরর হকলতার উপরর চর্বি, কইলজার লগর মাটিয়া, দুইও কিডনি, এর চর্বি, আর ডাইনর রান নিও, ইটা অইলো ইমামতি কামো বওয়ালর লাগি বখশিয়া দিবার মেড়া। ");
INSERT INTO syl_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","বাদে মাবুদর নজরো থওয়া খামির ছাড়া রুটির টুকরি থাকি একখান রুটি, তেলদি ভাজা একখান পিঠা আর তেল মাখাইল চাপাটি একখান লইও। ");
INSERT INTO syl_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","লইয়া ইতা হকলতা হারুন আর তার পুয়াইন্তর আতো দিয়া, মাবুদর ছামনে রাখার নিয়তে দুলনা কুরবানি হিসাবে দুলাইবায়। ");
INSERT INTO syl_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","আর অতা তারার আত থাকি নিয়া, মাবুদর ছামনে কুরবানি খানার উপরে, হউ জালাইল কুরবানির উপরে জালাইলিবায়। ইটা অইলো মাবুদর নামে আগুনিত দেওয়া ছদগা। ইতার ধুমার ঘেরানে মাবুদ খুশি অইন।” ");
INSERT INTO syl_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","মাবুদে মুছারে কইলা, “তুমি হারুনরে ইমামতির কামো বওয়াল করার লাগি, খেলাফতি সমজিবার মেড়ার ছিনার টুকরা লইয়া মাবুদর ছামনে দুলনা কুরবানি হিসাবে দুলাইবায়। ইটা অইলো তুমার বাট। ");
INSERT INTO syl_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","হারুন আর তার পুয়াইন্তরে ইমামতির কামো বওয়ালর লাগি দুলাইল অউ ছিনা আর রান তুমি পাক-পবিত্র করিও। ");
INSERT INTO syl_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","অউ লাখান বনি ইছরাইলর দেওয়া অউ কুরবানির টুকরাইন হর-হামেশা হারুন আর তার পুয়াইন্তে পাইবা। ইতা অইবো মাবুদর নামে বনি ইছরাইলর দেওয়া ছালামতি কুরবানির একটা অংশ। ");
INSERT INTO syl_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“হারুনর বেবহার করা পবিত্র লেবাছ অকল তার ওয়ারিশ অকলে পাইবা। অউ লেবাছ ফিন্দিয়া তারা খেলাফতি পাইবা আর ইমামতির কামো বওয়াল অইবা। ");
INSERT INTO syl_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","হারুনর বাদে তার যে পুয়া ইমাম অইয়া মিলন-তাম্বুর পাক জাগাত কাম করবো, হে সাতদিন পর্যন্ত ই লেবাছ তার গতরো রাখবো। ");
INSERT INTO syl_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“খেলাফতি সমজিবার মেড়ার অউ গোস্ত খানাইন নিয়া কুনু পবিত্র জাগাত রান্দিবায়। ");
INSERT INTO syl_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","হারুন আর তার পুয়াইন্তে মিলন-তাম্বুর দুয়ারর কাছাত বইয়া, টুকরিত থওয়া হউ রুটির লগে অউ গোস্ত খাইবা। ");
INSERT INTO syl_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","ইমামর কামো বওয়াল করার লাগি, তারারে পাক-ছাফ করার লাগি, খানির যেতা চিজ অকল গুনার মাফির লাগি কুরবানি দেওয়া অইবো, ইতা খালি হারুন আর তার পুয়াইন্তে খাইবা। আর কেউ ইতা খাইতো পারতো নায়, কারন ইতা অইলো পাক-পবিত্র খানা। ");
INSERT INTO syl_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","অউ বওয়াল করার কুরবানির মেড়ার কুনু গোস্ত বা রুটি যুদি বিয়ান পর্যন্ত রইযায়, তে ইতা জালাইলিতে অইবো, কেউ খাইতো পারতো নায়, ইতা তো পাক-পবিত্র। ");
INSERT INTO syl_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“হারুন আর তার পুয়াইন্তর লাগি, আমি তুমারে যততা করার হুকুম দিছি, তুমি অউলা করিও। বওয়াল করার অউ কাম তুমি সাতদিন ভরা করিও। ");
INSERT INTO syl_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","গুনার কফরা হিসাবে তুমি পরতেক দিন এগু করি বিছাল কুরবানি দিবায়। আর কুরবানি খানারে পাক-পবিত্র করার লাগিও অউ লাখান কুরবানি দিও, আর পাক-ছাফ অওয়ার লাগি পবিত্র তেল ঢালিও। ");
INSERT INTO syl_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","কুরবানি খানারে পাক-পবিত্র করার লাগি সাতদিন ভরা কুরবানি দিয়া, গুনা মাফির কফরা আদায় করিয়া পাক-পবিত্র করিও। তেউ ই কুরবানি খানা এক মহা-পবিত্র জাগা অইবো। যেকুনু জিনিস ই কুরবানি খানাত ছোয়াইলে, ইতা পাক-পবিত্র অইযিবো। ");
INSERT INTO syl_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“এর বাদ থাকি পরতেক দিন ই কুরবানি খানার উপরে, এক বরছ বয়সর দুগু মেড়া-বাইচ্চা কুরবানি দিবায়, ");
INSERT INTO syl_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","এগু বিয়ানে আর এগু হাইঞ্জা বালা। ");
INSERT INTO syl_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","পয়লা মেড়া-বাইচ্চার লগে দুই সের ময়দা আর এক সের জয়তুনর পিষা তেল মিশাইতে অইবো। আর শরবত-পানির ছদগার লাগি আংগুরর এক সের শরবতও আল্লার নামে দিবায়। ");
INSERT INTO syl_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","হাইঞ্জা বালা যে মেড়া কুরবানি দিবায়, এরলগেও বিয়ানকুর লাখান ধান-গমর ছদগা আর শরবত-পানির ছদগার হকলতা দিতে অইবো। ইতা অইলো মাবুদর নিয়তে আগুনিত দেওয়া ঘেরান আলা কুরবানি। ");
INSERT INTO syl_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“ওয়ারিশর পর ওয়ারিশ ধরি মিলন-তাম্বুর দুয়ারর গেছে, মানি আমার ছামনে পরতেক দিন ই জালাইল কুরবানি দিতে অইবো। হনো আমি তুমরারে দিদার দিমু, তুমার লগে বাতচিত করমু। ");
INSERT INTO syl_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","বনি ইছরাইলর গেছে আমি হনো দিদার দিমু, আর আমার কুদরতে অউ জাগা পাক-পবিত্র অইবো। ");
INSERT INTO syl_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","আমি মিলন-তাম্বু আর কুরবানি খানা পবিত্র করমু। আমার ইমামতির লাগি হারুন আর তার পুয়াইন্তরেও আমি পবিত্র করমু। ");
INSERT INTO syl_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","আমি বনি ইছরাইলর মাবুদ অইয়া তারার মাজে বসত করমু। ");
INSERT INTO syl_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","তেউ তারা জানবা, আমি আল্লাউ তারার মাবুদ। আমি তারার লগে বসত করার লাগিউ তো তারারে মিসর দেশ থাকি বার করিয়া আনছি। আমি আল্লাউ তারার মাবুদ।” ");
INSERT INTO syl_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","মাবুদে মুছারে কইলা, “আগর-খুশবয় জালাইবার লাগি তুমি বাবলা লাকড়িদি একখান টেবুল বানাইও। ");
INSERT INTO syl_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","ইগু অইবো চাইরকুনা আলা, এক আত লাম্বা, এক আত পাশ, দুই আত উবি। আস্তা খানউ হিং সুদ্ধা একখানো লাগাইল রইবো। ");
INSERT INTO syl_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","এর উপরর ছানি, ছানির চাইরো কিনারা আর হিং, হকলতা খাটি সোনাদি লেপিবায়। চাইরো কিনারো সোনার নকশা করাইবায়। ");
INSERT INTO syl_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","এর দুই কিনারর নকশার তলে দুগু করি সোনার কড়া লাগাইও। ই কড়ার ভিতরে বেন্দা হারাইয়া অগু বইয়া নেওয়া অইবো। ");
INSERT INTO syl_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","ই বেন্দা গুইন বাবলা লাকড়িদি বানাইয়া সোনাদি লেপাইও। ");
INSERT INTO syl_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","শাহাদত সন্দুকর ঢাকনার কাছাত যে পর্দাখান আছে, অউ টেবুল এর ছামনে রাখিও। অউ জাগাত আমি তুমারে দিদার দিমু। ");
INSERT INTO syl_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“পরতেক দিন বিয়ানে চেরাগ গুইন জুইত-জাইত করার বালা, হারুনে অউ টেবুলর উপরে খুশবয় আলা আগর জালাইবো। ");
INSERT INTO syl_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","হাইঞ্জা বালা চেরাগ জালানির সময়, হে হিরবার আগর-খুশবয় জালাইবো। তুমরার ওয়ারিশর পর ওয়ারিশ ধরি মাবুদর ছামনে হর-হামেশা অউ আগর-খুশবয় জলবো। ");
INSERT INTO syl_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","ই আগর-খুশবয় জালানির টেবুলর উপরে দুছরা কুনুজাতর খুশবয় জালাইও না। কুনু জালাইল কুরবানি, ধান-গমর ছদগা, বা শরবত-পানির ছদগা দিও না। ");
INSERT INTO syl_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","গুনার মাফির কফরা হিসাবে, হারুনে বছরো একবার গুনার কফরার কুরবানির লউ, টেবুলর হিংগ অকলর উপরে লাগাইতে অইবো। তেউ ইখান মাবুদর নামে মহা-পবিত্র অইবো। ওয়ারিশর পর ওয়ারিশ ধরি পরধান ইমামে বছরো একবার অউ লাখান করতে অইবো।” ");
INSERT INTO syl_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","বাদে মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“তুমি যেবলা বনি ইছরাইলর মানষর পরিমান গনবায়, অউ সময় তারা হকলেউ যারযির জানর বদলা রুপা দিতে অইবো, যাতে ই গনার লাগি তারার উপরে কুনু গজব না আয়। ");
INSERT INTO syl_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","তারারে গনার বালা অউলা বদলা লইও, গনা অইছে দলো যেরা হামাইবা, এরা এবাদত খানার মাপে আধা তোলা রুপা দিবা। পরতেক বিশ রতিয়ে এক তোলা গনিও। ই রুপা অইবো মাবুদর। ");
INSERT INTO syl_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","বিশ বরছ বা এর বেশি বয়সর যেকুনু জন গনা শেষ অওয়া দলো হামাইলে, এন জানর বদলা মাবুদরে অউ রুপা দিবা। ");
INSERT INTO syl_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","জানর বদলা দেওয়ার সময় ধনি অকলে অউ আধা তোলার বেশি দিতা পারতা নায়, আর গরিবেও কম দিলে অইতো নায়। ");
INSERT INTO syl_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","তুমি বনি ইছরাইলর গেছ থাকি জানর বদলা অউ রুপা নিয়া, আমার ঘরর কামো লাগাইও। তুমরার জানর বদলা ই রুপায়, বনি ইছরাইল অকলরে মাবুদর দরবারো ইয়াদ করাই দিবো।” ");
INSERT INTO syl_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“অজু করার লাগি তুমি পিতলর একটা গামলা, আর গামলা থওয়ার লাগি পিতলর একখান চকি-খাট বানাইও। মিলন-তাম্বু আর কুরবানি খানার মাজখানো পানি ভরিয়া অগু থইও। ");
INSERT INTO syl_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","ই পানিদি হারুন আর তার পুয়াইন্তে অজু করবা। ");
INSERT INTO syl_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","তারা যাতে না মরইন, এরলাগি পরতেকবার মিলন-তাম্বুত হামাইবার বালা অউ পানিদি অজু করতে অইবো। ইমাম হিসাবে মাবুদর নামে আগুনিত দেওয়া যেকুনু কুরবানি আদায় করার সময়ও অজু করতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","তারা জানে বাচিয়া রওয়ার লাগি অউ অজু করবা। ই হুকুম তারার লাগি হর-হামেশা চালু রইবো, ওয়ারিশর পর ওয়ারিশ ধরি বওয়াল রইবো।” ");
INSERT INTO syl_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“তুমার নিজর গেছে খুশবয়দার ভালা ভালা মশলা অকল দলা করো। তুমি পাচশো তোলা মুরা নামর আতর, আড়াইশ তোলা খুশবয় আলা ডাইলচিনি, আর আড়াইশ তোলা বছ, ");
INSERT INTO syl_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","সাধারন ডাইলচিনি পাচশো তোলা, আর জয়তুনর তেল চাইর সের দলা করিও। ই মাপ অইলো এবাদত খানার মাপে। ");
INSERT INTO syl_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","অউ মশলা অকল দিয়া আগর-খুশবয় মশলা বানানির কারিগরর নিয়মে তুমি খেলাফতি সমজিবার তেল বানাইও, ই তেল তো পবিত্র। ");
INSERT INTO syl_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","অউ তেল দিয়া তুমি মিলন-তাম্বু, শাহাদত সন্দুক, ");
INSERT INTO syl_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","টেবুল, টেবুলর উপরর হকল ছামানা, চেরাগ দানির হকলতা, আর আগর-খুশবয় জালানির টেবুল, ");
INSERT INTO syl_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","কুরবানি খানা আর এর মাজর হকল ছামানা, অজুর গামলা আর এর তলর চকি-খাট হকলতারে ফুছিয়া পাক-পবিত্র করিও। ");
INSERT INTO syl_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","তেউ ই হকলতা মহা-পবিত্র ছামানা অইবো। ইতা ছামানা কেউ ছইলে, হে-ও মহা-পবিত্র অইযিবো। ");
INSERT INTO syl_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“তুমি হারুনরে আর তার পুয়াইনরে আমার ইমামতির কামর লাগি খেলাফতির তেল দিয়া পাক-পবিত্র করিও। ");
INSERT INTO syl_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","আর বনি ইছরাইলরে জানাই দিও, ওয়ারিশর পর ওয়ারিশ ধরি ইটাউ অইবো আমার খেলাফতি সমজিবার পবিত্র তেল। ");
INSERT INTO syl_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","ই তেল মানষর গতরো দেওয়া যাইতো নায়। ই নিয়মে তারা যাতে আর কুনু তেল না বানায়। ই তেল তো পবিত্র। তুমরা ইটারে পাক-পবিত্র মনো করিয়া ইজ্জত করতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","কেউ যুদি ই লাখান তেল তৈয়ার করে, বা ইমাম ছাব ছাড়া আর কেউ ই তেল গতরো মাখে, তে তারে নিজর জাতি থাকি ফুছিলিবায়।” ");
INSERT INTO syl_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","মাবুদে মুছারে কইলা, “তুমি নিজর গেছে কিছু খুশবয় আলা মশলা: গুগগুলু, নখী, কুন্দুরু আর খাটি লোবান দলা করিও। দলা করিয়া অতা হমান হমান করি মিশাইও। ");
INSERT INTO syl_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","আর যেরা আগর-খুশবয় বানাইন, তারারেদি অউ কাম করাইও। ইতার লগে নুন মিশাইও, ইতা অইবো নির্ভেজাল খাটি পাক-পবিত্র আগর। ");
INSERT INTO syl_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","অউ আগরর থুড়া গুড়া নিয়া মিলন-তাম্বুর শাহাদত সন্দুকর ছামনে থইও। হনো আমি তুমারে দিদার দিমু। তুমরা ই আগররে মহা-পবিত্র ছামানা মনো করিও। ");
INSERT INTO syl_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","অউ মশলা দিয়া ই নিয়মে কেউ যাতে তার নিজর লাগি কুনু আগর-খুশবয় না বানায়। ইতা তো মাবুদর নামে পাক-পবিত্র চিজ, ইখান খিয়াল রাখিও। ");
INSERT INTO syl_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","খুশবয়দার চিজ মনো করিয়া কেউ যুদি ইতা তৈয়ার করিলায়, তে তারে ই জাতি থাকি ফুছিলিবায়।” ");
INSERT INTO syl_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“হুনো, আমি এহুদা গুষ্টির হূরর নাতি, উরির পুয়া বাতছেললরে পছন্দ করছি। ");
INSERT INTO syl_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","আমি তারে আল্লাই রুহ দিয়া কামিল করছি। হকল লাখান কারিগরি কামর আখল-বুদ্ধি, বিদ্যায় উস্তাদি কামর খেমতা দিছি। ");
INSERT INTO syl_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","এরলাগি হে সোনা, রুপা, পিতলর উপরে সুন্দর সুন্দর নকশা বানাইতো পারবো। ");
INSERT INTO syl_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","দামি দামি পাথর কাটিয়া মনি-মুক্তা লাগানি, লাকড়ির উপরে নকশার কাম আর হকল জাতর আতর কাম করতো পারবো। ");
INSERT INTO syl_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","তার যুগালি হিসাবে আমি দান গুষ্টির অহিছামাকর পুয়া আহলিয়াবরে পছন্দ করছি। যে উস্তাদ অকলে ই কাম করতা পারবা, আমি তারারে কামর আখল দিছি, যাতে তুমারে বাতাইল আমার হুকুম মাফিক, ইতা হকলতা তারা বানাইতা পারইন। ");
INSERT INTO syl_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","তারা বানাইবা, মিলন-তাম্বু, শাহাদত সন্দুক, এর উপরর ঢাকনা, তাম্বুর হকল মাল-ছামানা, ");
INSERT INTO syl_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","টেবুল, টেবুলর লগর চিজ অকল, খাটি সোনার চেরাগ দানি, চেরাগ দানির লগর হকলতা আর আগর-খুশবয় জালানির টেবুল, ");
INSERT INTO syl_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","কুরবানি খানা আর এর হকল মাল-ছামানা, হান্ডি-বাসন, অজুর পানির গামলা আর এর চকি-খাট, ");
INSERT INTO syl_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ইমামতি কামর লাগি হারুনর ইমামতির লেবাছ আর তার পুয়াইন্তর লেবাছ, ");
INSERT INTO syl_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","খেলাফতির তেল, পাক জাগার লাগি খুশবয় আলা আগর। আমি তুমারে যেলা হুকুম দিছি, এক্কেরে অউ লাখান তারা বানাইবা।” ");
INSERT INTO syl_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“তুমি নিজে বনি ইছরাইলরে কও, তুমরা আমার দেওয়া পরতেক জুম্মাবার মানিও। ই জুম্মাবার ওয়ারিশর পর ওয়ারিশ ধরি তুমরা আর আমার মাজে এক নিশানা অইবো, যাতে তুমরা বুজবায়, আমিউ মাবুদ, আর আমি তুমরারে আমার পবিত্র বন্দা অওয়ার লাগি আলাদা করছি। ");
INSERT INTO syl_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“তুমরা জুম্মাবার মানিও, অউ দিনরে তুমরার লাগি পাক দিন করা অইছে। কেউ যুদি ই দিন না মানে, তে তারে মারিলিতে অইবো। যে মানষে ইদিন কুনুজাত কাম করবো, তারে তার জাতির মাজ থাকি ফুছিলিবায়। ");
INSERT INTO syl_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","তুমরা হাপ্তার ছয়দিন কাম করিও, অইলে সাত নম্বর দিন মাবুদর নামে আরামর দিন, জুম্মাবার। শুক্রবার সুরুজ ডুবা থাকি শনিবার সুরুজ ডুবার আগ পর্যন্ত জুম্মাবার। ই দিন যে মানষে কাম করবো, তারে মারিলিবায়। ");
INSERT INTO syl_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","বনি ইছরাইল অকলে আমার দেওয়া চিরকালিন নিয়ম হিসাবে, ওয়ারিশর পর ওয়ারিশ ধরি হর-হামেশা ই জুম্মাবার মানতে অইবো। ");
INSERT INTO syl_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","ই জুম্মাবার তো বনি ইছরাইল আর আমার মাজে হামেশাকুর লাগি চিরকালিন এক নিশানা। কারন ছয়দিনে মাবুদে আছমান-জমিন হকলতা পয়দা করলা, অইলে সাত নম্বর দিন কুনু কাম না করিয়া জিরাইলা।” ");
INSERT INTO syl_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","মাবুদে তুর পাহাড়র উপরে হজরত মুছার লগে অউ বাতচিত শেষ করিয়া হারলে, মুছার আতো দুই টুকরা শাহাদত পাথর দিলা। অউ পাথরর মাজে আল্লা পাকে তান নিজর আতে তান হুকুম-আহকাম লেখছইন। ");
INSERT INTO syl_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","মুছা নবী পাহাড় থাকি লামিয়া আইতে দেরি অর দেখিয়া, মানষে আইয়া হারুনর চাইরোবায় দলা অইয়া কইলা, “আমরারে পথ চিনাইয়া নেওয়ার লাগি, আপনে আমরারে দেবতা বানাই দেউক্কা। কারন, যে মুছায় আমরারে মিসর থাকি বার করি আনছে, তার কিতা ঘটছে আমরা তো জানি না।” ");
INSERT INTO syl_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","ইখান হুনিয়া হারুনে তারারে কইলা, “তুমরা যারযির বউ আর পুয়া-পুড়িন্তর কানো থাকি সোনার গয়না খুলিয়া আমার গেছে আনো।” ");
INSERT INTO syl_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","তেউ হকলে তারার কানর গয়না খুলিয়া হারুনর গেছে আনিয়া দিলো। ");
INSERT INTO syl_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","মানষে যেতা সোনা আনিয়া দিলা, হারুনে অতা নিয়া আগুইনদি গলাইয়া, হুনারর আতিয়ারদি এক বাছুরর মুর্তি বানাইলা। অগু দেখিয়া বনি ইছরাইলে কইলা, “ভাই অকল, অউ এইনউ তুমরার দেবতা, যেইন তুমরারে মিসর দেশ থাকি বার করি আনছইন।” ");
INSERT INTO syl_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","ই হালত দেখিয়া হারুনে হউ বাছুরর ছামনে এক বলি খানা বানাইয়া জানাই দিলা, “ছামনর কাইল মাবুদর নামে খুশি-বাসি করা অইবো।” ");
INSERT INTO syl_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","তেউ বাদর দিন খুব ছবরে উঠিয়া মানষে দেবতার ছামনে আইয়া মংগল বলি আর পশু জালাইয়া বলি দিলা। বাদে তারা খাওয়া-দাওয়া করিয়া হারি, হৈ-হুল্লা করি নাচ-গান, ফুর্তি-আমোদ করাত লাগলা। ");
INSERT INTO syl_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","অউ মাবুদে মুছারে কইলা, “তুমি পাহাড়র লামাত যাও। তুমার অউ যেতা মানষরে মিসর দেশ থাকি বার করি আনছো, ইতা তো নাফরমান বনিগেছে। ");
INSERT INTO syl_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","আমি তারারে যেলা চলার হুকুম দিছলাম, তারা ইতা বাদ দিয়া নিজর লাগি এক বাছুরর মুর্তি বানাইয়া, মাটিত পড়িয়া অগুরে পরনাম করের। অগুর নামে তারা পশু বলি দের আর কর, ভাই অকল, অউ এইনউ তুমরার দেবতা, যেইন তুমরারে মিসর দেশ থাকি বার করি আনছইন।” ");
INSERT INTO syl_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","মাবুদে মুছারে কইলা, “আমি ইতা মানষরে চিনি, ইতা তো গাড়তেড়া-একগুইয়া জাত। ");
INSERT INTO syl_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","অখন তুমি আমারে বাধা দিও না, ইতার উপরে আমার গুছা আগুইনর লাখান দাউ দাউ করি জলের, আমি ইতারে ছারখার করিলিমু। বাদে আমি তুমার মাজ থাকি এক মহা জাতি পয়দা করমু।” ");
INSERT INTO syl_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","তেউ মুছায় তান মাবুদ আল্লারে মিনত-কাজ্জি করিয়া কইলা, “ও মাবুদ, তুমি তুমার কুদরতি আত দিয়া তুমার মহা কুদরতি বলে যেতারে মিসর থাকি বার করি আনছো, তারার উপরে তুমি কেনে অতো গুছা অইলায়? ");
INSERT INTO syl_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","মিসরী অকলে কেনে ইখান মাতার সুযোগ পাইতা, পাহাড়িয়া এলাকাত আনিয়া তারারে খতম করিয়া, দুনিয়া থাকি তারার নাম মিটাইলিবার লাগি তুমি তারারে মিসর থাকি বার করিয়া আনছো? মাবুদ গো, তুমার ই বেথায়া গুছা খান তুমি থামাইলাও। মেহেরবানি করি, তুমার বন্দা অকলর উপরে ই গজব খান আনিও না। ");
INSERT INTO syl_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","তুমার আপন গুলাম ইব্রাহিম, ইছহাক আর ইয়াকুবর কথা ইয়াদ করো। তুমি নিজর নামে কছম খাইয়া তারারে কইছলায়, তারার ওয়ারিশ অকলরে তুমি আছমানর তেরার লাখান বাড়াইবায়, আর তুমার ওয়াদা করা অউ আস্তা দেশর মালিকানাও তারারে দিবায়, আর তারা হর-হামেশাকুর লাগি এর দখল পাইবা।” ");
INSERT INTO syl_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","ইখান হুনিয়া মাবুদর মেহেরবানি অইলো। তাইন তান বন্দা অকলর উপরে যে গজব ঢালিতা চাইছলা, ইতা বাদ দিলাইলা। ");
INSERT INTO syl_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","এরবাদে মুছায় আল্লার দেওয়া দুইওখান শাহাদত পাথর লইয়া লামাত আইলা। ই পাথরর উল্টা-ভাটিয়ল দুইও গালাত লেখা আছিল। ");
INSERT INTO syl_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","ই দুইও পাথর অইলো আল্লা পাকর নিজর আতর কাম, আর ই পাথরর উপরে খুদিয়া লেখা খানও তান নিজর আতর লেখা। ");
INSERT INTO syl_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","মুছার খাদিম ইউছায় মানষর ইতা হৈ-হুল্লা হুনিয়া মুছারে কইলা, “ছাব, আমরার কেম্পর মাজে যুদ্ধর আওয়াজ হুনা যার।” ");
INSERT INTO syl_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","মুছায় কইলা, “ইতা তো কুনু যুদ্ধর আরা-জিতার আওয়াজ নায়। আমি যেতা হুনিয়ার, ইতা তো গানর আওয়াজর লাখান লাগের।” ");
INSERT INTO syl_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","বাদে মুছায় কেম্পর কাছাত আইয়া মানষর নাচা-নাচি আর বাছুরর মুর্তি দেখলা। দেখিয়াউ তাইন গুছায় আগুইন অইয়া, আতর পাথর দুইওখান ইটা মারি ফালাই দিলা। তেউ পাথর দুইওখান পাহাড়র তলে পড়িয়া চুরমার অইগেল। ");
INSERT INTO syl_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","আর মুছায় তারার বানাইল বাছুরর মুর্তি নিয়া আগুনিত ফালাইয়া জালাইলিলা। বাদে অগুরে পিষিয়া গুড়া বানাইয়া পানিত মিশাইয়া, বনি ইছরাইল অকলরে খাওয়াই দিলা। ");
INSERT INTO syl_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","তাইন হারুনরে কইলা, “ইতা মানষে তুমারে কিতা করছিল, তুমি কেনে তারারেদি শিরিকি কাম করাইলায়?” ");
INSERT INTO syl_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","হারুনে জুয়াপ দিলা, “মালিক, আপনে গুছা করইন না যানু, আপনে তো জানইনউ, ইতা মানুষ খালি খারাপ কামর আশিক। ");
INSERT INTO syl_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","তারা আইয়া আমারে কইলা, আমরারে পথ চিনাইয়া লইয়া যাওয়ার লাগি দেবতা বানাই দেউক্কা, কারন যে মুছায় আমরারে মিসর থাকি বার করি আনছইন, এন কিতা অইছে, আমরা তো জানিয়ার না। ");
INSERT INTO syl_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","ইখান হুনিয়া আমি তারারে কইলাম, তুমরার গেছে যেতা সোনা-দানা আছে, অতা খুলিয়া আমার গেছে আনো। তারা আনিয়া আমার আতো দিলা, আর আমি অখনাইন ইটা মারি আগুনিত ফালাইলাম, তেউ অউ বাছুর অগু বার অইয়া আইলো।” ");
INSERT INTO syl_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","মুছায় দেখলা, ই মানুষ গুইন বেপরোয়া অইগেছইন। তাইন বুজলা, হারুনে তারারে বেপরোয়া অওয়ার সুযোগ দিছইন। এরলাগি দুশমন অকলে আসিবার সুযোগ পাইছইন। ");
INSERT INTO syl_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","অউ মুছায় কেম্পর গেইটর গেছে উবাইয়া কইলা, “তুমরা যত জন মাবুদর পক্ষে আছো, হকল আমার কাছাত আও।” তেউ লেবি গুষ্টির হকল মানুষ তান গেছে আইলো। ");
INSERT INTO syl_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","আইয়া হারলে মুছায় তারারে কইলা, “মাবুদ, যেইন বনি ইছরাইলর আল্লা, তাইন নিজে হুকুম করছইন, তুমরা হকলে যারযির কমরো তলোয়ার বান্দো, আর কেম্পর ভিতরে যারে ছামনে পাও জানে মারো। আস্তা কেম্পর ভিতরে ভাই-বন্ধু, আরি-ফরি যারে পাও মারো।” ");
INSERT INTO syl_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","তেউ লেবি গুষ্টির মানষে মুছার হুকুম মাফিক কাম করলা। হি দিন অনুমান তিন আজার মানুষ মারা গেলা। ");
INSERT INTO syl_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","বাদে মুছায় কইলা, “তুমরা আইজ মাবুদর নামে যারযির পুয়া আর ভাই-বিরাদরর উপরে আত তুলতে খরেদি গেছো না, মাবুদর কামর লাগি তুমরা আলাদা অইছো, এরলাগি মাবুদে তুমরারে রহমত দিছইন।” ");
INSERT INTO syl_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","বাদর দিন মুছায় মানষরে কইলা, “তুমরা তো বেজুইতা গুনা করছো। তে আমি অখন হিরবার তুর পাহাড়ো মাবুদর দরবারো যাইরাম, পারলে তুমরার গুনা মাফির কফরার কুনু পথ বার করমু।” ");
INSERT INTO syl_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","মুছায় মাবুদর দরবারো গিয়া আরজ করলা, “ও মাবুদ, ই মানুষ গুইন্তে বেজুইতা গুনা করিলিছে। তারা নিজর লাগি সোনার মুর্তি বানাইছে। ");
INSERT INTO syl_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","তে তুমি মেহেরবানি করিয়া তারার গুনারে অখন মাফ করি দিলাও, আর যুদি মাফ না করো, তাইলে তুমার লেখা খাতা থাকি আমার নামখানও কাটিলাও।” ");
INSERT INTO syl_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","মাবুদে জুয়াপ দিলা, “হুনো, আমার বিরুদ্ধে যেরা গুনা করছে, আমি খালি তারার নামরেউ আমার খাতা থাকি ফুছিলিমু। ");
INSERT INTO syl_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","তে তুমি অখন যাওগি, আর আমি যে দেশর কথা কইছি, তুমি তারারে লইয়া হউ দেশো রওয়ানা দিলাও। আমার ফিরিস্তায় তুমরারে পথ দেখাইয়া নিবা। বাদে যেবলা সাজা দেওয়ার সময় আইবো, অউ সময় আমি তারার গুনার সাজা দিমু।” ");
INSERT INTO syl_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","হারুনর আতে বানাইল হউ বাছুরর মুর্তির লাগি মানষে যেতা করছিলা, অতার লাগি মাবুদে তারার উপরে গজব নাজিল করলা। ");
INSERT INTO syl_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","মাবুদে মুছারে কইলা, “যাও, তুমি অউ যেরারে মিসর থাকি আনছো, এরারে লইয়া অখনউ ই জাগা ছাড়িয়া যাওগি। আমার ওয়াদা করা হউ দেশো যাও। আমি ইব্রাহিম, ইছহাক আর ইয়াকুবর গেছে ওয়াদা করছলাম, তারার ওয়ারিশ অকলরে অউ দেশ অকল দিমু, তে তুমি তারারে লইয়া হনো যাওগি। ");
INSERT INTO syl_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","আমি তুমরার আগে করি একজন ফিরিস্তা পাঠাইমু। এইন গিয়া হনর কেনানী, আমোরী, হিট্টী, ফারিজী, হিব্বী আর যিবুজী অকলরে খেদাই দিবা। ");
INSERT INTO syl_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","ইতা তো দুধ আর মউর ভান্ডার আলা দেশ। অইলে আমি তুমরার লগে অইয়া যাইতাম নায়, কারন তুমরা খুব গাড়তেড়া-একগুইয়া জাত, কিযানু আমি পথর মাজেউ তুমরারে নিপাত করিলাই।” ");
INSERT INTO syl_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","ই বিপদর কথা হুনিয়া মানষে কান্দা-কাটি লাগাইলা। তারা কেউ কুনুজাত গয়না-গাটি ফিনলা না। ");
INSERT INTO syl_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","কারন মাবুদে মুছারে কইছলা, “তুমি বনি ইছরাইল অকলরে কও, তুমরা অইলায় গাড়তেড়া-একগুইয়া জাত। আমি এক পলকর লাগি গেলেও তুমরারে নিপাত করিলিমু। তুমরার গতরো থাকি হকল গয়না-গাটি খুলিলাও, তেউ আমি বুজমু, তুমরার লাগি কিতা করতাম।” ");
INSERT INTO syl_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","তেউ বনি ইছরাইলে তুর পাহাড়োউ তারার গয়না-গাটি হকলতা খুলিলিলা, ইতা আর ফিনলা না। ");
INSERT INTO syl_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","হজরত মুছার এক তাম্বু আছিল, তাইন বনি ইছরাইলর কেম্পর বারে দুরই নিয়া অউ তাম্বু পাতিতা, ই তাম্বুরে তাইন খানেকা-তাম্বু কইয়া ডাকিতা। মাবুদর গেছ থাকি কেউ কুন্তা জানতে চাইলে তারা অউ খানেকার গেছে যাইতা। ");
INSERT INTO syl_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","মুছা যেবলা হি খানেকা শরিফো রওয়ানা দিতা, অউ সময় হক্কল মানুষ যারযির তাম্বুর দুয়ারো উবাইতা আর মুছা খানেকাত না হামানি পর্যন্ত হকলে তান বায় চাই রইতো। ");
INSERT INTO syl_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","তাইন হি খানেকা শরিফো হামানির বাদেউ আল্লাই মেঘর খুটি খানেকার দুয়ারর মুখো লামিয়া আইতো, আর মাবুদে যতবইল মুছার লগে বাতচিত করতা, অতবইল ই খুটি অনো রইতো। ");
INSERT INTO syl_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","মানষে যেবলাউ ই মেঘর খুটিরে খানেকার দুয়ারর গেছে দেখতো, অউ সময় তারা যারযির দুয়ারর গেছ থাকি মাবুদরে সইজদা করতো। ");
INSERT INTO syl_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","কুনু মানষে তার দুস্তর লগে মুখামুখি বইয়া যেলা বাতচিত করে, মাবুদেও মুছার লগে অউলা মুখামুখি বাতচিত করতা। বাদে মুছা কেম্পো ফিরিয়া আইতা, অইলে তান খাদিম নূনর পুয়া ইউছা নামর ই জুয়ান, খানেকা শরিফ থাকি বার অইতা না। ");
INSERT INTO syl_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","মুছায় মাবুদর দরবারো আরজ করলা, “মাবুদ, তুমি তো কইরায় আমি অতা মানষরে লইয়া যাইতামগি, অইলে আমার লগে আর কারে দিরায়, ইখান তো আমারে জানাইলায় না। তুমি খালি কইলায়, তুমি আমারে তুমার নিজর জন মনো করো আর আমারে তুমার খাছ মায়ার নজরো রাখছো। ");
INSERT INTO syl_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","তে হাছাউ যুদি আমি তুমার মায়ার নজরো থাকি, তাইলে তুমি কুন খিয়ালে কিতা করো, অতা আমারে জানাও, যাতে আমি তুমারে পুরাপুর চিনি আর তুমার রহমতর মাজে রই। তুমি তো জানোউ, ই ইছরাইল জাতি তুমারউ প্রজা।” ");
INSERT INTO syl_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","মাবুদে জুয়াপ দিলা, “হুনো, আমি নিজেউ তুমার লগে অইয়া যাইমু আর তুমারে আরাম দিমু।” ");
INSERT INTO syl_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","অউ তাইন কইলা, “তুমি যুদি আমরার লগে না যাও, তে আমরারে ইন থাকি বিদায় দিও না। ");
INSERT INTO syl_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","তুমি না গেলে মানষে কিলা বুজবা, আমার উপরে আর তুমার ই বন্দা অকলর উপরে তুমার রহমত আছে? আমরাউ যেন দুনিয়ার হকল জাতি থাকি আলাদা, ইখান কিলা বুজবা?” ");
INSERT INTO syl_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","মাবুদে মুছারে কইলা, “ঠিক আছে, তুমি যেলা কইলায়, আমি অলা করমু। তুমি তো আমার মায়ার নজরো আছো, তুমারে আমার নিজর আপন মনো করি।” ");
INSERT INTO syl_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","তেউ মুছায় আরজ করলা, “তে তুমার শান-তজল্লি আমারে দেখাওনা।” ");
INSERT INTO syl_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","মাবুদে কইলা, “আমি যারে খুশি দয়া করমু, আর যারে খুশি রহম করমু। হুনো, তুমার ছামনেদি আমি আমার হক্কল নেক ছুরত জাইর করমু। ‘মাবুদ, যেইন আছইন’ তুমার ছামনে আমি আমার অউ নাম এলান করমু। ");
INSERT INTO syl_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","অইলে আমার মুখ দেখার তাক্কত তুমার অইতো নায়। কারন আমারে দেখিল্লে কুনু আদম জাত বাচে না। ");
INSERT INTO syl_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","তে হুনো, তুমি আমার কাছার অউ জাগা বায় চাও, দেখরায় নি, পাথরর এক থাক আছে, অউ থাকর উপরে তুমি উবাও। ");
INSERT INTO syl_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","তেউ তুমার ছামনে দিয়া আমার শান-তজল্লি যাওয়ার বালা, আমি তুমারে অউ পাথরর ফাটার ভিতরে হারাইমু। আমি না যাওয়া পর্যন্ত, আমার আত দিয়া তুমারে গুরিয়া রাখমু। ");
INSERT INTO syl_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","বাদে আমার আত হরাইলে, তুমি আমার খর গালা দেখতায় পারবায়, অইলে কেউ আমার মুখর দিদার পাইতো নায়।” ");
INSERT INTO syl_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","মাবুদে মুছারে কইলা, “আগর পাথরর লাখান তুমি নয়া দুখান পাথর তিয়ার করো। তুমি যে দুখান ভাংগিছলায়, হি পাথরর মাজে যে হুকুম লেখা আছিল, অউ হুকুম অকল আমি হিরবার ই দুইও পাথরো লেখিয়া দিমু। ");
INSERT INTO syl_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","ফজর বাদেউ তুমি তিয়ার অইয়া তুর পাহাড়র উপরে উঠিও। উঠিয়া পাহাড়র মাথাত আমার ছামনে আজির অইও। ");
INSERT INTO syl_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","তুমার লগে কুনু মানষরে আনিও না, ই পাহাড়র কুনুখানো যাতে কুনু মানুষ না আয়। পাহাড়র কান্দাত কুনু গরু-ছাগল বা মেড়া-মেড়িরে রাখতে দিও না।” ");
INSERT INTO syl_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","তেউ মুছায় আগর পাথরর লাখান দুখান পাথর বানাইলা, আর মাবুদর হুকুম মাফিক ফজরে উঠিয়া পাথর দুইওখান আতো লইয়া তুর পাহাড়র উপরে উঠিলা। ");
INSERT INTO syl_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","আর মাবুদও মেঘর কালনির মাজে লামিয়া আইলা। তাইন হজরত মুছার ধারো উবাইয়া তান “মাবুদ, যেইন আছইন” নাম এলান করলা। ");
INSERT INTO syl_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","তাইন মুছার ছামনা দিয়া তশরিফ নিলা, আর অউ কালাম এলান করি করি গেলা, “মাবুদ, যেইন আছইন, রহমান আর রহিম আল্লা, তাইন গুছা করইন ধীর গতিয়ে, তান অবিরাম মায়া-মহব্বত আর হক-হালালির কুনু সীমা নাই। ");
INSERT INTO syl_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","তাইন আজার আজার ওয়ারিশ পর্যন্ত অবিরাম মায়া-মহব্বত করইন, মানষর অইন্যায়-অপরাধ, নাফরমানি আর গুনার মাফি দেইন, অইলে দুষি জনরে সাজাও দেইন। বাফ-দাদার নাফরমানির সাজা, তারার নাতি-পুতি পর্যন্ত বর্তাইন।” ");
INSERT INTO syl_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","ইখান হুনিয়াউ মুছা নবী লগে লগে সইজদাত পড়িয়া কইলা, ");
INSERT INTO syl_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“ও মালিক, আমি যুদি তুমার দরবারো রহমত পাই, তে মেহেরবানি করি তুমিও আমরার লগ খানো চলো। অউ জাতি যুদিও খুব গাড়তেড়া-একগুইয়া জাত, তা-ও তুমি আমরার গুনা আর কছুরিরে মাফ করিয়া দিলাও। আমরারে তুমার আপন প্রজা হিসাবে কবুল করিলাও।” ");
INSERT INTO syl_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","মাবুদে কইলা, “হুনো, আমি এক উছিলা বওয়াল করিয়ার, আমি তুমার হকল মানষর ছামনে অউ লাখান কেরামতি কাম দেখাইমু, যেতা আস্তা দুনিয়ার কুনু জাতির ছামনে কুনুদিনও করা অইছে না। তুমি অউ যেতা মানষর লগে বসত কররায়, তারা দেখবা, আমি মাবুদে তুমরার লাগি কিতা করিয়ার, ইতা দেখিয়া তারার জানো ডর হামাইবো। ");
INSERT INTO syl_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","আমি আইজ তুমরারে যেতা হুকুম দিমু, ইতা খিয়াল করি আমল করো। আমি আমোরী, কেনানী, হিট্টী, ফারিজী, হিব্বী আর যিবুজী অকলরে তুমরার ছামনা থাকি খেদাই দিমু। ");
INSERT INTO syl_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","অইলে খবরদার! তুমরা যে দেশো যাইরায়, ই দেশর মানষর লগে কুনুজাত চুক্তি করিও না, আরনায় ফান্দো হামাইবায়। ");
INSERT INTO syl_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","তুমরা তারার পুজা-মন্ডপ ভাংগিয়া টুকরা টুকরা করবায়, তারার বলি খানাইন ভাংগিলিবায়, আর তারার আশেরা-দেবীর নিশানা খুটি অকল কাটিয়া ফালাইবায়। ");
INSERT INTO syl_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","তুমরা কুনু দেব-দেবির পুজা করিও না। আমি আল্লা তো লা-শরিক মাবুদ, কুনু শরিক সইয্য করি না, আমার পাওনা এবাদত আমি চাইউ চাই। ");
INSERT INTO syl_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“হউ দেশর মানষর লগে কুনুজাত চুক্তি করিও না, আরনায় তারা যেবলা শিরিকি কামর নিয়তে, তারার দেব-দেবীর ছামনে নিজরে সপিয়া দিবা, দেবতার নামে বলি দিবা, অউ সময় তারা তুমরারেও দাওত দিবা আর তুমরা গিয়া তারার অউ বলির গোস্ত খাইবায়। ");
INSERT INTO syl_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","তুমরার পুয়াইন্তর লগে তারার পুড়িন্তর বিয়া-শাদি দিবায়, আর অউ পুড়িন্তে তারার দেবতার গেছে গিয়া শিরিকি কাম করবা, তারার লগে তুমরার পুয়াইন্তরেও টানবা। ");
INSERT INTO syl_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“তুমরা নিজর লাগি কুনুজাতর মুর্তি বানাইও না। ");
INSERT INTO syl_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“তুমরা খামির ছাড়া রুটির ইদ আদায় করিও। সাত দিন খামির ছাড়া রুটি খাইও। আবীব চান্দর ঠিক করা তারিখো তুমরারে যেলা হুকুম দেওয়া অইছে, অউ লাখান ইদ আদায় করিও। মনো রাখিও, অউ চান্দো তুমরা মিসর থাকি বার অইয়া আইছলায়। ");
INSERT INTO syl_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“তুমরার পেটর পয়দা হকল পয়লা পুয়া আমার অইবো। এরলগে তুমরার গরু-ছাগল বা পশুর পয়লা মেদা বাইচ্চাও আমার অইবো। ");
INSERT INTO syl_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","খালি গাধীন্তর পয়লা মেদা বাইচ্চার বদলা, আমারে এগু মেড়া-বাইচ্চা বদলা দিয়া অগুরে খালাছ করিয়া নিও। খালাছ না করাইলে অগুর গর্দনা ভাংগিলিও। তুমরার হক্কল বড় পুয়াইনরে অলা খালাছ করাই নিও। “হুনো, ইদর সময় কেউ খালি আতে আমার কাছাত আইও না। ");
INSERT INTO syl_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“হাপ্তার ছয়দিন তুমরা কাম করিও, অইলে সাত নম্বর দিন জিরাইও। খেত করা আর ফসল দাওয়ার বালাও জিরাইও। ");
INSERT INTO syl_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“অউ তিনো ইদ তুমরা মানিও, পঞ্চাইশা ইদ, খেতর পয়লা দাওয়া গম দিয়া নয়া ফসলর ইদ, আর বছরর হেশ মাসো বাগানর পাকনা ফল বাড়িত আনিয়া ডেরা-ঘরর ইদ আদায় করিও। ");
INSERT INTO syl_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","বছরো তিনবার তুমরার হকল বেটাইন আইয়া হজ করার নিয়তে আমার গেছে আজির অইও। মনো রাখিও, আমিউ মাবুদ, বনি ইছরাইলর আল্লা। ");
INSERT INTO syl_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","আমি হউ দেশর হকল জাতিরে তুমরার ছামন থাকি খেদাই দিমু। তুমরার দেশর সীমানা বাড়াইয়া বড় করমু। তুমরা বছরো তিনবার নিজর মাবুদ আল্লার ছামনে আজির অইও, তেউ তুমরার জাগা-জমিনর বায় কেউ লালছ করতো নায়। ");
INSERT INTO syl_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“আমার নামর কুরবানির পশুর লগে তুমরা খামির আলা কুন্তা লিল্লা-কুরবানি দিও না। আজাদি ইদর কুরবানির কুনুজাত খানি বিয়ান পর্যন্ত রাখিও না। ");
INSERT INTO syl_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“তুমরার খেতর দাওয়া পয়লা ফসলর হকল থাকি ভালা অংশ আল্লা মাবুদর ঘরো লইয়া আইও। “আর হুনো, ছাগলর বাইচ্চার গোস্ত তার মাʼর দুধদি রান্দিও না।” ");
INSERT INTO syl_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","বাদে মাবুদে মুছারে কইলা, “তুমি ই কালাম অকল লেখিয়া থও। আমি অউ কালাম মাফিক তুমার লগে আর বনি ইছরাইলর লগে আমার মিলনর উছিলা বওয়াল করলাম।” ");
INSERT INTO syl_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","অউ সময় মুছা নবী চাল্লিশ দিন চাল্লিশ রাইত মাবুদর ধারো পাহাড়র উপরে রইলা। তাইন কুনুজাত দানা-পানি খাইলা না। মাবুদে হউ দুইও পাথরর উপরে তান লগে মিলনর উছিলার অউ আয়াত অকল, মানি শরিয়তর দশটা হুকুম-আহকাম লেখিয়া দিলা। ");
INSERT INTO syl_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","তেউ মুছায় শাহাদত পাথর দুইওখান আতো লইয়া তুর পাহাড় থাকি লামিয়া আইলা। মাবুদর লগে বাতচিত করায় মুছার মুখর ছুরত নুরানি অইগেল, অইলে মুছায় ইখান টের পাইলা না। ");
INSERT INTO syl_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","অউ সময় হারুন আর হকল বনি ইছরাইলে মুছার নুরানি ছুরত দেখলা, দেখিয়া তারা কাছাত আইতে ডরাইগেলা। ");
INSERT INTO syl_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","অইলে মুছায় তারারে ডাক দিলা, তেউ হারুন আর বনি ইছরাইলর মুরব্বি অকল তান গেছে আইলা, আর মুছায় তারার লগে মাত-কথা মাতিলা। ");
INSERT INTO syl_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","বাদে হকল বনি ইছরাইল তান কাছাত আইলা। আইয়া হারলে তাইন তুর পাহাড়র উপরে মাবুদর দেওয়া হকল হুকুম-আহকাম তারারে জানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","তারার লগে মাত-কথা শেষ অইগেলে মুছায় তান নুরানি চেহারা লুকানির লাগি মুখো পর্দা লাগাই দিলা। ");
INSERT INTO syl_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","অইলে মুছায় যেবলা মাবুদর লগে বাতচিতর লাগি খানেকার ভিতরে তান ছামনে যাইতা, অউ সময় ই পর্দা খুলিলিতা। বাদে বারে আইয়া পর্দা লাগাইতা, আর আল্লার দেওয়া হুকুম অকল বনি ইছরাইলরে জানাইতা। ");
INSERT INTO syl_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","হকল মানষে দেখতা মুছার মুখ নুরানি অইগেছে। মুছায় তান মুখ গুরিলিতা আর মাবুদর ছামনে যাওয়ার আগ পর্যন্ত তান মুখ গুরা রইতো। ");
INSERT INTO syl_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","মুছা নবীয়ে বনি ইছরাইলর হকল গুষ্টিরে দলা করিয়া কইলা, “মাবুদে হুকুম দিছইন, তান অউ হুকুম-আহকাম আমল করার লাগি। ");
INSERT INTO syl_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","তুমরা হাপ্তার ছয়দিন কাম করিও, অইলে সাত নম্বর দিন মাবুদর নামে পাক-পবিত্র দিন, আরামর দিন, জুম্মাবার। ই দিন যে মানষে কাম করবো, তারে মারিলিবায়। ");
INSERT INTO syl_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","জুম্মাবারে তুমরার কেউরর ঘরো আগুইন জালাইও না।” ");
INSERT INTO syl_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","হজরত মুছায় বনি ইছরাইলরে কইলা, “মাবুদে হুকুম দিছইন, ");
INSERT INTO syl_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","তুমরা যারযির দিলর খুশি মাফিক মাবুদর নামে লিল্লা লইয়া আও। আনার সময় অউলা চিজ অকল লিল্লা আনিও: সোনা, রুপা, পিতল; ");
INSERT INTO syl_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","লিলুয়া, বাইংগনি, লাল রংগর সুতা; দামি সুতি কাপড় আর ছাগলর রুমা; ");
INSERT INTO syl_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","লাল রং লাগাইল মেড়ার চামড়া, ফুʼর চামড়া; বাবলা লাকড়ি; ");
INSERT INTO syl_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","চেরাগ জালানির লাগি জয়তুনর তেল; খেলাফতি সমজিবার তেলর মশলা আর আগর-খুশবয় বানানির মশলা; ");
INSERT INTO syl_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ইমামর এফ্রোন আর বুকুর উপরর থলিত লাগানির লাগি আকিক মনি আর হকল নমুনার দামি পাথর। ");
INSERT INTO syl_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“তুমরার মাজে যারা ভালা উস্তাদ কারিগর, তারা আইয়া অউ হকলতা বানাইবা, যেলা মাবুদে হুকুম দিছইন: ");
INSERT INTO syl_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","আল্লার ঘর, ঘরর চাল, হুক, ফ্রেইম, বাত্তি, খুটি, খুটির তলর চুঙি; ");
INSERT INTO syl_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","শাহাদত সন্দুক, সন্দুকর ঢাকনা, সন্দুক বইয়া নেওয়ার বেন্দা; সন্দুকরে আগলা দিবার পর্দা; ");
INSERT INTO syl_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","বেন্দা সুদ্ধা টেবুল, টেবুলর উপরর হকল চিজ, মাবুদর নামর পবিত্র রুটি; ");
INSERT INTO syl_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ফর দিবার লাগি চেরাগ দানি, এর লগর হকল চিজ আর চেরাগ অকল, চেরাগ জালানির তেল; ");
INSERT INTO syl_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","আগর-খুশবয় জালানির টেবুল, ইখান বইয়া নেওয়ার বেন্দা; খেলাফতির তেল, খুশবয় আলা আগর, আল্লার ঘরর দুয়ারর পর্দা; ");
INSERT INTO syl_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","জালাইল কুরবানি দিবার কুরবানি খানা; এর পিতলর জালি আর বইয়া নেয়ার বেন্দা; কুরবানি খানার হক্কল মাল-ছামানা; অজুর গামলা আর গামলা থওয়ার চকি-খাট; ");
INSERT INTO syl_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","উঠানর পর্দাইন, খুটিন আর খুটির তলর চুঙি; উঠানো হামানির গেইটর পর্দা; ");
INSERT INTO syl_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ঘরর পেরেগ আর দড়ি, উঠানর পেরেগ আর দড়ি; ");
INSERT INTO syl_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","পাক জাগাত ইমামতি কামর লাগি, ইমাম হারুনর পবিত্র লেবাছ, আর তান পুয়াইন্তরও ইমামতির লেবাছ।” ");
INSERT INTO syl_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","মুছা নবীর বয়ান বাদে বনি ইছরাইলর হকল গুষ্টি বিদায় অইগেলা। ");
INSERT INTO syl_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","গিয়া তারার দিলর এশকি মাফিক যারযির ইচ্ছায় আল্লার মিলন-তাম্বু বানানির লাগি, ইমাম হারুনর পাক-পবিত্র লেবাছর লাগি আর এবাদত কামর লাগি হকল নমুনার মাল-ছামানা লইয়া আইলা। আল্লার নামে লিল্লা দিবার লাগি অতা লইয়া তারা আজির অইলা। ");
INSERT INTO syl_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","বেটাইন বা বেটিন্তর মাজে যারার মনে চাইলো, তারা ইতা দিলা। তারা যারযির কাপড়র পিং, কানর ইয়ারিং, আংটি, গলার হার, আর হকল জাতর সোনার গয়না আনিয়া মাবুদর নামে দুলনা কুরবানি হিসাবে দিলা। ");
INSERT INTO syl_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","আর যেরার গেছে লিলুয়া সুতা, বাইংগনি, লাল সুতা, দামি সুতি কাপড়, ছাগলর রুমা, লাল রং করা মেড়ার চামড়া, ফুʼর চামড়া আছিল, তারা ইতা হকলতা লইয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","যেরার গেছে রুপা আর পিতল আছিল, তারাও ইতা আনিয়া মাবুদর নামে লিল্লা দিলা। আল্লার ঘরর কামো লাগানির জুকা বাবলা লাকড়ি যেরার গেছে আছিল, তারাও ইতা লইয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","যেতা বেটিন্তে সুতা বানানিত উস্তাদ, তারা নিজর আতে লিলুয়া, বাইংগনি, লাল রংগর সুতা, আর দামি সুতি কাপড় বানাইয়া আনলা। ");
INSERT INTO syl_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","আর সুতা বানাওরা যেতা বেটিন্তর দিলর মাজে এশকি পয়দা অইলো, তারা ছাগলর রুমা দিয়া সুতা বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","মুরব্বি অকলে এফ্রোন আর বুকুর উপরর থলিত লাগানির লাগি, আকিক মনি আর দামি দামি পাথর লইয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","চেরাগ জালানির তেল, খেলাফতি সমজিবার তেল, আগর-খুশবয় বানানির মশলা আর জয়তুনর তেলও আনলা। ");
INSERT INTO syl_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","মাবুদে মুছার মাজদি যেতা যেতা করার হুকুম দিছলা, ইতা পুরা করার লাগি বনি ইছরাইলর হকল বেটাইন-বেটিন্তে, যারযির খুশি মাফিক লিল্লা লইয়া আজির অইলো। ");
INSERT INTO syl_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","বাদে মুছায় হকল বনি ইছরাইলরে কইলা, “মাবুদে এহুদা গুষ্টির হূরর নাতি, উরির পুয়া বাতছেললরে পছন্দ করছইন। ");
INSERT INTO syl_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","তাইন এরে নিজর রুহ মুবারক দিয়া কামিল বানাইয়া, হকল লাখান কারিগরি কামর আখল-বুদ্ধি, বিদ্যায় উস্তাদি কামর খেমতা দিছইন। ");
INSERT INTO syl_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","এরলাগি এইন কারিগরি কাম করার বালা নিজর আখল খাটাইয়া সোনা, রুপা, পিতলর উপরে সুন্দর সুন্দর নকশা বানাইতা পারবা। ");
INSERT INTO syl_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","দামি দামি পাথর কাটা, লাকড়ির উপরে নকশা, আর হকল নমুনার আতর কাম করতা পারবা। ");
INSERT INTO syl_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","আর অইন্য মানষরেও ইতা কাম হিকানির লাগি বাতছেলল আর দান গুষ্টির অহিছামাকর পুয়া আহলিয়াবর দিলো মাবুদে আখল দিছইন। ");
INSERT INTO syl_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","তাইন এরারে নানান জাতর নকশার কাম, লিলুয়া, বাইংগনি, লাল সুতাদি কাপড় বাইন করা, নকশা করা, সিলাই করা, আর দামি সুতি কাপড় সিলাই করারও আখল দিছইন। তারা হকল নমুনার আতর কাম করতা পারবা, আর নিজর মন থাকি নানান নমুনার নকশা বানাইতা পারবা।” ");
INSERT INTO syl_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","মুছা নবীয়ে এওখান কইলা, “মাবুদে বাতছেলল, আহলিয়াব আর অইন্য কারিগর অকলরে আখল-বুদ্ধি দান করলা, যাতে তারা পবিত্র এবাদত খানার হকল কাম-কাজ করতা পারইন। মাবুদে যেলা হুকুম করছইন, অউ লাখান তারা যানু এবাদত খানার হকলতা বানাইন আর হাজাইন।” ");
INSERT INTO syl_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","অউ কাম করানির লাগি মুছায় বাতছেলল আর আহলিয়াবরে আনাইলা। মাবুদে যেতা উস্তাদ কারিগর অকলরে আখল-হেকমত দিছইন, আর ই কাম করার লাগি যেরার দিলো খাইশ পয়দা অইছে, মুছায় তারারেও আনাইলা। ");
INSERT INTO syl_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","তারা আইয়া পবিত্র এবাদত খানা বানানির লাগি, বনি ইছরাইলর দেওয়া লিল্লার হকল মাল-ছামানা মুছার গেছ থাকি সমজিয়া নিলা। মানষে খুশি অইয়া নিজর ইচ্ছায় পরতেক দিন বিয়ানে আরো চিজ অকল আনিয়া অনো লিল্লা দিতা। ");
INSERT INTO syl_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","যে উস্তাদ কারিগর অকল এবাদত খানার কামো আছলা, তারা ইতা দেখিয়া, নিজর কাম থইয়া আইয়া মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","“মাবুদে যেতা যেতা বানানির হুকুম দিছইন, ইতা বানানির লাগি মানষে দরকার থাকি আরো বেশি মাল-ছামানা লইয়া আইরা।” ");
INSERT INTO syl_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","তেউ মুছার হুকুমে মানষে হকল বনি ইছরাইলরে জানাই দিলা, এবাদত খানা বানানির লাগি, কেউ যানু আর কুনু মাল-ছামানা লিল্লা না দেইন। অউগি মানষে লিল্লা দেওয়া বন্দ করলা। ");
INSERT INTO syl_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","কারন এবাদত খানার কামর লাগি দরকার থাকি আরো বেশি চিজ যোগাড় অইগেছিল। ");
INSERT INTO syl_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","বাদে কাম কররা উস্তাদ অকলে পেচাইল সুতার দামি সুতি কাপড়, লিলুয়া, বাইংগনি, আর লাল সুতাদি বানাইল দশ টুকরা কাপড় দিয়া আল্লার ঘরর পর্দা বানাইলা। আর উস্তাদ অকলে এর উপরে কারুবী অকলর নকশা বাইন করলা। ");
INSERT INTO syl_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","পরতেক টুকরাইন এক মাপর আছিল, লাম্বায় আটাইশ আত আর পাশে চাইর আত। ");
INSERT INTO syl_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","বাদে পাচখান পাচখান করি একখানো জুড়া দিয়া বড় করি দুখান গিলাফ বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","আর দুইও গিলাফর পাশর এক কিনারো, লিলুয়া সুতাদি হুকর ফুড় দেওয়া অইলো। ");
INSERT INTO syl_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","অউলা পয়লা গিলাফর কিনারো পইঞ্চাশগু হুকর ফুড় আর দুছরা গিলাফর কিনারো পইঞ্চাশগু হুকর ফুড় লাগাইল অইলো। ই দুইও হুকর ফুড় এগু আরেগুর উল্টামুখা করা অইলো। ");
INSERT INTO syl_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","বাদে সোনাদি পইঞ্চাশগু হুক বানাইয়া হউ হুকর ফুড়র মাজেদি হারাইয়া, বড় দুইও গিলাফরে জুড়া দেওয়া অইলো। তেউ একখান ঘর তিয়ার অইলো। ");
INSERT INTO syl_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","আল্লার ঘরর চালর লাগি ছাগলর রুমা দিয়া গিলাফর লাখান এগারোখান টুকরা বানাইল অইলো। ");
INSERT INTO syl_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","ইতা পরতেক খান একই মাপর আছিল, তিশ আত লাম্বা আর চাইর আত পাশ। ");
INSERT INTO syl_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","অন থাকি পাচ টুকরা একলগে জুড়া দিয়া বড় এক গিলাফ বানাইলা। আর বাকি ছয় টুকরা জুড়া দিয়া, আরোখান বড় গিলাফ বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","পয়লা বড় গিলাফর পাশর এক কিনারো পইঞ্চাশগু হুকর ফুড় লাগাইলা, আর দুছরা গিলাফোও অউলা লাগাইলা। ");
INSERT INTO syl_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","বাদে পিতল দিয়া পইঞ্চাশগু হুক বানাইয়া হউ হুকর ফুড়র মাজেদি হারাইয়া, অউ বড় দুইও গিলাফ একখানো জুড়া দিলা। তেউ ই দুইও গিলাফ মিলিয়া একখান ছানি অইলো। ");
INSERT INTO syl_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","লাল রং করা মেড়ার চামড়াদি এর উপরর ছানি বানাইল অইলো, বাদে ফুʼর চামড়াদি আরোখান ছানি তৈয়ার করিয়া এর উপরে গুরি দেওয়া অইলো। ");
INSERT INTO syl_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","বাদে বাবলা লাকড়িদি কয়খান ফ্রেইম বানাইল অইলো। ");
INSERT INTO syl_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","পরতেক ফ্রেইম আছিল লাম্বায় দশ আত আর ফাড়ে দেড় আত। ");
INSERT INTO syl_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","পরতেক ফ্রেইমো দুগু করি পায়া লাগাইয়া ঘরর হকল ফ্রেইম এক লাখান বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","অউ ঘরর দক্ষিন গালার লাগি বিশখান ফ্রেইম জুইত করলা। ");
INSERT INTO syl_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ই বিশো ফ্রেইমর পায়ার তলে চাল্লিশগু রুপার চুঙি লাগাইলা। পরতেক ফ্রেইমর দুই পায়ার তলে দুগু চুঙি লাগাইল অইলো। ");
INSERT INTO syl_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","আল্লার ঘরর উত্তর গালার লাগিয়াও বিশখান ফ্রেইম জুইত করলা। ");
INSERT INTO syl_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ই পরতেক ফ্রেইমর পায়ার তলে চাল্লিশগু রুপার চুঙি লাগাইলা। একো ফ্রেইমর তলে দুগু করি চুঙি লাগাইল অইলো। ");
INSERT INTO syl_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","আর পচিম গালার লাগি, মানি খর গালার লাগি ছয়খান ফ্রেইম বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","আর খরর দুইও কুনাত দুখান ফ্রেইম লাগাইলা। ");
INSERT INTO syl_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ই দুইও কুনার ফ্রেইমরে কাছার ফ্রেইমর লগে তলে-উপরে জুড়া দেওয়া অইলো। পরতেক কুনার দুইও ফ্রেইমরে ধারর ফ্রেইমর লগে বাত্তি মারিয়া জুড়া দেওয়া অইলো। ");
INSERT INTO syl_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","তেউ আটখান ফ্রেইম আর ষোলগু রুপার চুঙি লাগলো, একো ফ্রেইমর তলে দুইটা করি চুঙি দিলা। ");
INSERT INTO syl_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","বাদে ফ্রেইমরে জুড়া দিবার লাগি বাবলা লাকড়িদি কয়গু লাম্বা বাত্তি বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ঘরর এক গালার লাগি পাচগু বাত্তি, আরক গালার লাগি আরো পাচগু, আর পাচগু বাত্তি খর গালা, মানি পচিম গালার লাগি বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","ফ্রেইমর মাজখানো লাগাইল অউ বাত্তিদি হকল ফ্রেইমর একমাথা থাকি আরক মাথা আটকাই দিলা। ");
INSERT INTO syl_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","বাদে ই ফ্রেইম খানাইন সোনাদি লেপিলা। আর বাত্তি লাগানির লাগি সোনার কড়া লাগাইয়া, বাত্তিরেও সোনাদি লেপিলা। ");
INSERT INTO syl_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","অউ উস্তাদ কারিগর অকলে দামি সুতি কাপড়দি একখান পর্দা বানাইলা। পর্দার উপরে লিলুয়া, বাইংগনি, লাল সুতা দিয়া কারুবী অকলর ছবি বাইন করলা। ");
INSERT INTO syl_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","ই পর্দা টানানির লাগি বাবলা লাকড়িদি চাইরটা খুটি বানাইলা, বানাইয়া অউ খুটিন্তরেও সোনাদি লেপিলা, খুটিন্তর মাথাত সোনার কড়া লাগাইলা। খুটির তলর লাগি রুপার চাইরটা চুঙি বানাইল অইলো। ");
INSERT INTO syl_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","তাম্বুর দুয়ারর লাগি লিলুয়া, বাইংগনি, লাল সুতা আর দামি সুতি কাপড়দি নকশা করি একখান পর্দা বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","ই পর্দার লাগি পাচটা কড়া আর পাচটা খুটি বানাইল অইলো। খুটির মাথা আর তল সোনাদি লেপা অইলো, খুটির তলর লাগি পিতলর পাচগু চুঙি বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","বাতছেললে বাবলা লাকড়িদি পবিত্র শাহাদত সন্দুক বানাইলা। ইটা আড়াই আত লাম্বা, দেড় আত পাশ আর দেড় আত উচা। ");
INSERT INTO syl_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","এর বারে-ভিতরে খাটি সোনাদি লেপিলা, এর চাইরো কিনারো সোনার নকশা লাগাইলা। ");
INSERT INTO syl_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","আগুইনদি সোনা গলাইয়া চাইরটা সোনার কড়া এর চাইরো কুনাত লাগাইলা, অগালাত দুইটা আর হগালাত দুইটা লাগাইলা। ");
INSERT INTO syl_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","বাবলা লাকড়িদি দুগু বেন্দা বানাইয়া সোনাদি লেপিলা। ");
INSERT INTO syl_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","সন্দুক বইয়া নেওয়ার লাগি ই দুইও বেন্দা, সন্দুকর দুই গালার কড়ার ভিতরেদি হারাইলা। ");
INSERT INTO syl_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","বাদে খাটি সোনাদি সন্দুকর একখান ঢাকনা বানাইলা, অখানর উপরে গুনার কফরা আদায় করার লাগি। ই ঢাকনা লাম্বায় আড়াই আত, আর পাশে দেড় আত। ");
INSERT INTO syl_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","সোনা পিটাইয়া ঢাকনার দুইও গালাত দুইটা কারুবী বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","দুইও কারুবী সন্দুকর ঢাকনার দুই কিনারো রইলো। ই দুইও কারুবী ঢাকনার লগে একখানো করি বানাইল অইলো, ই আস্তাটা খালি এক চিজ অইলো। ");
INSERT INTO syl_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","কারুবী দেখতে দুলদুল ঘোড়ার লাখান ডাখনা আলা, এর দুইও ডাখনা উপরেদি মেলিয়া দেওয়ায়, অউ ডাখনার ছায়ার তলে সন্দুকর ঢাকনা হামাইগেল। ইটা মুখামুখি উবা রইলো। আর তারার চউখ রইলো সন্দুকর ঢাকনার বায়। ");
INSERT INTO syl_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","বাতছেললে বাদে বাবলা লাকড়িদি দুই আত লাম্বা, এক আত পাশ আর দেড় আত উচা করি একখান টেবুল বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","বানাইয়া হারলে খাটি সোনাদি লেপিয়া এর চাইরো কিনারো নকশা লাগাইলা। ");
INSERT INTO syl_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","আর এর ছানির চাইরো কিনারো চাইর আংগুল উচা করি এক হাজ দিলা, হাজর মাজে সোনাদি নকশা লাগাইলা। ");
INSERT INTO syl_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","টেবুলর চাইরো কুনার পায়ার উপরে সোনার চাইরটা কড়া লাগাইলা। ");
INSERT INTO syl_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","ই চাইরো কড়াইন টেবুলর কুনার হউ উচা হাজর তলে লাগানি অইলো, যাতে টেবুল বইয়া নেওয়ার বালা কড়ার ভিতরে বেন্দা হারাইল যায়। ");
INSERT INTO syl_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","টেবুলরে বইয়া নেওয়ার লাগি বাবলা লাকড়িদি দুগু বেন্দা বানাইয়া সোনাদি লেপিলা। ");
INSERT INTO syl_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","টেবুলর উপরর থাল-বাসন, আল্লার নামে শরবত-পানির ছদগার জগ আর মগ, হকলতা খাটি সোনাদি গড়াইলা। ");
INSERT INTO syl_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","বাদে খাটি সোনাদি একখান চেরাগ দানি তিয়ার করলা। চেরাগ দানির তলা আর উপরর ডান্ডি খাটি সোনা পিটাইয়া গড়াইলা। এর ডান্ডি, ফুলর লাখান পিয়ালা, কুড়ি আর পাপড়ি অকল চেরাগ দানির লগে একখানো করি বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","চেরাগ দানির ডান্ডির দুই গালাত তিনটা করি মোট ছয়টা ডাল দেওয়া অইলো। ");
INSERT INTO syl_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","পরতেক ডালর মাজে জবা ফুলর লাখান তিনগু করি পিয়ালা তিয়ার করা অইলো। চেরাগ দানির ছয়ও ডালো এক লাখান কাম করা অইলো। ");
INSERT INTO syl_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","চেরাগ দানির মুল ডান্ডির মাজেও জবা ফুলর লাখান চাইরটা পিয়ালা দেওয়া অইলো। ");
INSERT INTO syl_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","অউ মুল ডান্ডি থাকি বারইল ছয়টা ডালর মাজে, পয়লা দুইও ডালর জুড়াত এগু করি কুড়ি, দুছরা দুইও ডালর জুড়াত আরক কুড়ি, আর হেশর দুইও ডালর জুড়াতও কুড়ি লাগাইল অইলো। ");
INSERT INTO syl_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","কুড়ি আর ডাল হকলতা চেরাগ দানি থাকি বার অইলো, হকলতা মিলিয়া এক চিজ অইলো। আস্তাটাউ খাটি সোনা পিটাইয়া বানানি অইলো। ");
INSERT INTO syl_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","খাটি সোনাদি সাতটা চেরাগ, চেরাগর ফিতা ছাফ করার চিমটা, জালাইল ফিতার ছালি থওয়ার লাগি কয়গু বাটি বানাইল অইলো। ");
INSERT INTO syl_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","এক মন খাটি সোনাদি ই চেরাগ দানি, আর লগর হকলতা তিয়ার করা অইলো। ");
INSERT INTO syl_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","বাদে বাবলা লাকড়িদি চাইর কুনা আলা আগর-খুশবয় জালানির টেবুল বানাইল অইলো। এক আত লাম্বা, এক আত পাশ, আর দুই আত উবি দিয়া ই টেবুল বানাইলা। এর চাইরো কুনার চাইরো হিংও একখানো করি বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","ছানি, ছানির চাইরো কিনার আর হিং, হকলতা খাটি সোনাদি লেপিয়া চাইরো কিনারো সোনার নকশা লাগাইলা। ");
INSERT INTO syl_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","এর দুই কিনারর নকশার তলে দুগু করি সোনার কড়া লাগাইল অইলো, যাতে এর ভিতরে বেন্দা হারাইয়া বইয়া নেওয়া যায়। ");
INSERT INTO syl_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","বাবলা লাকড়িদি বইয়া নেওয়ার বেন্দা বানাইলা, ইটারেও সোনাদি লেপিলা। ");
INSERT INTO syl_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","বাদে খুশবয় আলা মশলা বানানির কারিগরর নিয়মে খেলাফতি সমজিবার পবিত্র তেল আর খুশবয় আলা খাটি আগর তিয়ার করলা। ");
INSERT INTO syl_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","জালাইল কুরবানির লাগি বাবলা লাকড়িদি পাচ আত লাম্বা, পাচ আত পাশ আর তিন আত উবি দিয়া চাইরকুনি করি একখান কুরবানি খানা বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","এর চাইরো কুনার উপরে লাকড়িদি চাইরটা হিং দিলা। অউ হিং বানাইলা ছানির উপরর কুনার লাকড়ি খুদিয়া, এরলাগি ই আস্তাখান এক চিজ অইলো। বাদে পুরা কুরবানি খানা পিতলদি লেপাইলা। ");
INSERT INTO syl_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","কুরবানি খানার ছালি তুলার বড় চামচ আর ছালি থওয়ার গামলা, লউ থওয়ার বাটি, গোস্ত তুলার বড় কাটা-ছিফ, আংরা থওয়ার পাতিল, হকলতা পিতলদি বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","কুরবানি খানার লাগি পিতলদি একখান জালি বানাইলা, বানাইয়া ই জালিরে কুরবানি খানার ভিতরর মাজখানর চাইরো গালার তাড়িয়ার তলে লাগাইলা। ");
INSERT INTO syl_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","আর বেন্দা হারানির লাগি জালির চাইরো কুনাত চাইরটা কড়া লাগাইলা। ");
INSERT INTO syl_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","বইয়া নেওয়ার বেন্দা বানাইলা বাবলা লাকড়িদি, বানাইয়া দুইওগু পিতলদি লেপাইলা। ");
INSERT INTO syl_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","আর কুরবানি খানারে বইবার লাগি এর কুনার কড়ার ভিতরে অউ বেন্দা হারাইলা। কুরবানি খানা বানাইলা তক্তাদি, আর এর ভিতরে ফাক রাখলা। ");
INSERT INTO syl_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","অজুর পানি থওয়ার লাগি পিতলর এক গামলা বানাইলা। এবাদতি কামর লাগি যেতা বেটিন মিলন-তাম্বুর দুয়ারর কাছাত আইতা, তারার পিতলর আয়নাদি ই গামলা আর এর চকি-খাট তৈয়ার করা অইলো। ");
INSERT INTO syl_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","বাতছেললে আল্লার ঘরর চাইরো গালাবায় উঠানর জাগা রাখলা। উঠানর দক্ষিন গালার একশো আত জাগার লাগি দামি সুতি কাপড়দি পর্দা বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","ই পর্দা টানানির লাগি বিশগু খুটি বানাইলা। খুটির তলাত দিবার লাগি পিতলর বিশগু চুঙি বানাইলা, আর পর্দা টানানির লাগি রুপার কড়া আর বান্দিবার তার বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","উঠানর উত্তর গালার একশো আত জাগার লাগি বিশগু খুটি, খুটির তলে দিবার লাগি পিতলর বিশগু চুঙি, আর পর্দা টানানির লাগি রুপার কড়া আর বান্দিবার তার বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","পচিম গালার পইঞ্চাশ আত উঠানর লাগি পর্দা, দশগু খুটি, দশগু চুঙি, পর্দা টানানির লাগি রুপার কড়া আর বান্দিবার তার বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","পুব গালার উঠানও পইঞ্চাশ আত আছিল। ");
INSERT INTO syl_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","উঠানর গেইটর এক গালার লাগি পনরো আত লাম্বা পর্দা, তিনটা খুটি, খুটির তলর তিনগু চুঙি, ");
INSERT INTO syl_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","আর দুছরা গালাতও অউ লাখান করি তিনটা খুটি, তিনটা চুঙি আর পনরো আত পর্দা বানাইল অইলো। ");
INSERT INTO syl_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","উঠানর চাইরো গালার হক্কল পর্দাইন দামি সুতি কাপড়দি বানাইল অইলো। ");
INSERT INTO syl_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","খুটির তলর হক্কল চুঙি পিতলর, পর্দা টানানির কড়া আর বান্দিবার তার অইলো রুপার, খুটির মাথাও রুপাদি পেচাইল অইলো। উঠানর চাইরো গালার হক্কল খুটিত রুপার তারদি বান্দা অইলো। ");
INSERT INTO syl_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","উঠানর গেইটর লাগি দামি সুতি কাপড়দি একখান পর্দা বানাইল অইলো। বাদে লিলুয়া, বাইংগনি, লাল সুতাদি নকশা করা অইলো। পর্দা খান বিশ আত লাম্বা, আর উঠানর বাকি পর্দার লাখান ইটাও পাচ আত উচা দেওয়া অইলো। ");
INSERT INTO syl_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","এর চাইরো খুটি আর চুঙি পিতলর, খুটির কড়া আর বান্দার তার রুপার, খুটির মাথাও রুপাদি পেচাই দেওয়া অইলো। ");
INSERT INTO syl_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","আল্লার ঘর আর উঠানর চাইরো গালার খুটির পেরেগ অকল পিতলদি বানাইল। ");
INSERT INTO syl_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","আল্লার ঘর মানি অউ শাহাদত তাম্বু বানাইতে যেতা মাল-ছামানা লাগছিল, ইমাম হারুনর পুয়া ইছামারর জিম্মায় লেবি খান্দানর মানষে ইতার হিসাব রাখলা। মুছা নবীয়ে অউ হিসাব রাখার হুকুম দিছলা। ");
INSERT INTO syl_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","মাবুদে মুছারে যেলাখান হুকুম দিছলা, ই হুকুম মাফিক এহুদা গুষ্টির উরির পুয়া বাতছেললে ইতা হক্কলতা বানাইলা, তাইন আছলা হূরর নাতি। ");
INSERT INTO syl_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","দান গুষ্টির অহিছামাকর পুয়া আহলিয়াবে বাতছেললরে সাইয্য করলা। হকল জাতর আতর কাম আর নকশা বানানির কামো তাইন উস্তাদ আছলা। দামি সুতি কাপড়র মাজে লিলুয়া, বাইংগনি, লাল সুতাদি নকশা করার কামোও তাইন উস্তাদ আছলা। ");
INSERT INTO syl_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","দুলনা কুরবানি থাকি পাওয়া উনতিশ মন সাতশো তিশ তোলা সোনা অউ এবাদত খানা বানাইতে লাগছে। ই মাপ অইলো এবাদত খানার তোলার মাপে। ");
INSERT INTO syl_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","বনি ইছরাইলর মানুষ গনিবার বালা যেরারে গনা অইছিল, তারার গেছ থাকি একশো মন এক আজার সাতশো পচত্তইর তোলা রুপা পাওয়া গেছিল, ই মাপ অইলো এবাদত খানার মাপে। ");
INSERT INTO syl_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","গনা অইছে অউলা মানুষ, মানি বিশ বরছ বা এর চাইতে বেশি বয়স আলা, হউ ছয় লাখ তিন আজার সাড়ে পাচশো মানষে এবাদত খানার মাপে মাথা পিছু আধা তোলা করি রুপা দিছিল। ");
INSERT INTO syl_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","ই রুপা থাকি একশো মন রুপা দিয়া এবাদত খানা আর পর্দার খুটির তলর চুঙি বানাইল অইছিল। এক এক চুঙিত এক মন রুপা দিয়া মোট একশোগু চুঙি বানাইল অইছে। ");
INSERT INTO syl_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","আর বাকি এক আজার সাতশ পচত্তইর তোলা রুপা খুটির কড়া, খুটির মাথা পেচানি, আর বান্দিবার তার বানানিত লাগছে। ");
INSERT INTO syl_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","দুলনা কুরবানি থাকি লিল্লার পিতল দলা অইছিল সত্তইর মন দুই আজার চাইরশো তোলা। ");
INSERT INTO syl_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ইতা দিয়া মিলন-তাম্বুর দুয়ারর চুঙি, পিতলর কুরবানি খানা, এর পিতলর জালি আর কুরবানি খানার হক্কল চিজ বানাইল অইছে, ");
INSERT INTO syl_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","উঠানর চাইরো গালার চুঙি, গেইটর চুঙি, তাম্বু আর উঠানর চাইরো গালার খুটির পেরেগ বানাইল অইছে। ");
INSERT INTO syl_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","আল্লার ঘরর পাক জাগাত ইমামতি কামর সময় ফিন্দার লাগি, তারা লাল, বাইংগনি আর লিলুয়া সুতাদি সুন্দর করি লেবাছ বানাইলা। মাবুদে মুছারে যেলা হুকুম দিছলা, এক্কেরে অউ লাখান করি ইমাম হারুনর লাগি পবিত্র লেবাছ বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","অউ উস্তাদ কারিগর অকলে লিলুয়া, বাইংগনি, লাল সুতা, দামি সুতি কাপড় আর সোনাদি পরধান ইমামর এফ্রোন বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","সোনা পিটাইয়া পাত বানাইয়া, সুতার লাখান সোনার তার তিয়ার করলা। বাদে লিলুয়া, বাইংগনি, লাল সুতা, দামি সুতি কাপড় আর সোনার তার একলগে মিলাইয়া কাপড় বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","এফ্রোনর কান্দর গালা জুড়া দিবার লাগি দুখান পট্টি বানাইয়া, এফ্রোনর উপরর কুনাত লাগাইলা। ");
INSERT INTO syl_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","এফ্রোনর লগে জুড়া লাগাইল পেটর উপরর বেল্ট খানও এফ্রোনর সুতাদি বানাইলা। তারা লিলুয়া, বাইংগনি, লাল সুতা, দামি সুতি কাপড় আর সোনার তার দিয়া ঠিক এফ্রোনর নমুনায় বানাইলা। মাবুদে মুছারে যেলা হুকুম দিছলা, এক্কেরে অউ লাখান করি হক্কলতা বানাইল অইলো। ");
INSERT INTO syl_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","বাদে তারা দুইটা আকিক পাথর কাটিয়া, এর উপরে সোনার জাজইর বওয়াইলা। হুনার অকলে দামি পাথর খুদিয়া যেলা সীল বানাইন, অউলা পাথর খুদিয়া ইছরাইলর পুয়াইন্তর নাম লেখলা। ");
INSERT INTO syl_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","আর অউ দুইও পাথর সোনার জাজইরর মাজে লাগাইয়া, এফ্রোনর কান্দর ফিতার লগে বান্দিলা। ইছরাইলর পুয়াইন্তর বায় মাবুদর নজর রাখার লাগি ইলা করলা। মাবুদে মুছারে যেলা হুকুম দিছলা, অউলা হকলতা করা অইলো। ");
INSERT INTO syl_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","বাদে এফ্রোনর লাখান ভালা উস্তাদ দর্জিরেদি লিলুয়া, বাইংগনি, লাল সুতা, দামি সুতি কাপড় আর সোনাদি বুকুর উপরর থলি বানাইল অইলো। ");
INSERT INTO syl_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","ইটা অইলো লাম্বায় আধা আত, পাশে আধা আত, চাইরকুনি দুই ভাইঞ্জ করা কাপড়। ");
INSERT INTO syl_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","এর উপরে তারা চাইর হাইর করি দামি পাথর লাগাইলা। পয়লা হারিত ইয়াকুত, পীত আর পান্না মনি; ");
INSERT INTO syl_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","দুছরা হারিত লালমনি, লীল মনি আর হীরা; ");
INSERT INTO syl_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","তিন নম্বর হারিত ফিরুজ, গোমেদ আর পদ্মরাগ মনি; ");
INSERT INTO syl_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","চাইর নম্বর হারিত পোখরাজ, বৈদুর্য আর সুরুজ মনি। ই পাথর অকল সোনার জাজইরর উপরে লাগাইল অইলো। ");
INSERT INTO syl_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","ইছরাইলর বারো পুয়ার লাগি বারোটা পাথর লাগাইলা। ইতা একো পাথরো এক এক পুয়ার নাম খুদিয়া লেখা অইলো, যেলা খুদিয়া সীল বানাইল অয়। ");
INSERT INTO syl_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","বুকুর উপরর থলির লাগি খাটি সোনাদি রশির লাখান পেচাইয়া দুকছা চেইন বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","আর সোনার দুখান জাজইর আর দুইটা কড়া বানাইয়া, বুকুর অউ থলির উপরর দুই কুনাত লাগাইলা। ");
INSERT INTO syl_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","আর চেইন দুইওগেছা দুইও কড়ার লগে আটকাইলা। ");
INSERT INTO syl_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","দুইও কান্দর এফ্রোনর ছামনর ফিতাত সোনার জাজইরর লগে চেইনর একমাথা বান্দিলা। ");
INSERT INTO syl_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","আরো দুইটা সোনার কড়া বানাইয়া বুকুর উপরর থলির দুই কুনাত লাগাইলা। ই দুইওটা এফ্রোনর লগে বুকুর থলির তলে রইলো। ");
INSERT INTO syl_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","বাদে আরো দুইটা সোনার কড়া বানাইয়া, এফ্রোনর কান্দর পট্টির সই তলেদি, পেটর উপরর বেল্টর উপরর সিলাইর কাছাত লাগাই দিলা। ");
INSERT INTO syl_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","আর বুকুর উপরর থলির তলর কড়ার লগে পেটর উপরর নকশা করা বেল্টর কড়া বান্দিলা, আর অউ থলিয়ে লড়া-চড়া না করার লাগি তলর কড়ার লগে লিলুয়া সুতাদি বান্দি দিলা, যেলা মাবুদে মুছারে হুকুম করছলা। ");
INSERT INTO syl_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","বাদে তারা এফ্রোনর তলর আলখেল্লা লিলুয়া রংগর সুতাদি বাইন করলা, ");
INSERT INTO syl_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","আর মাথা হারাইবার বালা গলার ফাক ছিড়তো না করি এর চাইরো গালা পট্টি দিয়া দড়ো করি বাইন করলা, গলার অউ ফাক রাখলা মাজ বরাবর। ");
INSERT INTO syl_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","লিলুয়া, বাইংগনি, লাল রংগর পেচাইল সুতাদি আনুয়ার ফলর লাখান বানাইলা। বানাইয়া অগুইনরে আলখেল্লার তলর মুড়ির চাইরোবায় লাগাইলা। ");
INSERT INTO syl_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","বাদে খাটি সোনার ঘুংগুর বানাইয়া অউ আনুয়ারর ফাকে ফাকে লাগাইলা, ");
INSERT INTO syl_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","আস্তা তলর মুড়িত এগু করি আনুয়ার আর এগু করি ঘুংগুর লাগাইল অইলো। এবাদতি কামর বালা ইমাম ছাবে অউ আলখেল্লা ফিন্দিতা। মাবুদে মুছারে যেলা হুকুম দিছলা, এক্কেরে অউলা করা অইলো। ");
INSERT INTO syl_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","বাদে তারা হারুন আর তান পুয়াইন্তর লাগি দামি সুতি সুতাদি পাইঞ্জাবি বানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","মাথার পাউগড়ি আর তকিগুইনও দামি সুতি কাপড়দি বানাইলা, আর হাফ-পেন্টর লাখান জাংগিয়াও বানাইলা অউ কাপড়দি। ");
INSERT INTO syl_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","কমরর একখান বন্দনি বানাইলা, দামি সুতি কাপড়, লিলুয়া, বাইংগনি আর লাল সুতাদি নকশা করি বানাইলা। মাবুদে মুছারে যেলা হুকুম দিছলা, এক্কেরে অউলা করা অইলো। ");
INSERT INTO syl_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","আর পাউগড়ির ছামনে লাগানির লাগি, খাটি সোনার পাতদি একখান পবিত্র তাজ তিয়ার করলা। সীলর উপরে যেলা খুদিয়া লেখা অয়, অউ পাতর উপরে অলা খুদিয়া লেখলা, “মাবুদর নামে পবিত্র।” ");
INSERT INTO syl_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","মাবুদে মুছারে যেলা হুকুম দিছলা, অউ হুকুম মাফিকউ ই পাতরে লিলুয়া সুতাদি পাউগড়ির ছামনে বান্দি দিলা। ");
INSERT INTO syl_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","অউ লাখান মিলন-তাম্বু সহ আল্লার ঘরর হক্কল কাম-কাজ শেষ অইলো। মাবুদে মুছারে যেলা হুকুম দিছলা, বনি ইছরাইলে এক্কেরে অউ লাখান হকলতা করলা। ");
INSERT INTO syl_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","বাদে তারা আল্লার ঘরর লাগি বানাইল হক্কলতা মুছার কাছাত লইয়া আইলা। তারা আনলা: মিলন-তাম্বু, তাম্বুর হকল মাল-ছামানা, হুক, ফ্রেইম, বাত্তি, খুটি, খুটির তলর চুঙি; ");
INSERT INTO syl_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","লাল রং করা মেড়ার চামড়ার ছানি, ফুʼর চামড়ার ছানি, হেরেম শরিফর বেড়ার পর্দা; ");
INSERT INTO syl_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","শাহাদত সন্দুক, সন্দুক বইয়া নেওয়ার বেন্দা, সন্দুকর ঢাকনা; ");
INSERT INTO syl_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","টেবুল, টেবুলর হকল চিজ, মাবুদর নামর পবিত্র রুটি; ");
INSERT INTO syl_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","খাটি সোনার চেরাগ দানি, এর লগর হকল চিজ, জালানির তেল; ");
INSERT INTO syl_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","সোনার আগর-খুশবয় জালানির টেবুল, খেলাফতির তেল, খুশবয় আলা আগর, আল্লার ঘরর দুয়ারর পর্দা; ");
INSERT INTO syl_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","পিতলর কুরবানি খানা, পিতলর জালি, কুরবানি খানা বইয়া নেওয়ার বেন্দা, কুরবানি খানার হক্কল মাল-ছামানা, অজুর গামলা আর এর তলর চকি-খাট; ");
INSERT INTO syl_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","উঠানর পর্দাইন, খুটিন, খুটির তলর চুঙি, উঠানো হামানির গেইটর পর্দা, উঠানর পেরেগ আর দড়ি; এক কথায়, মিলন-তাম্বু সহ আল্লার ঘরর হক্কল মাল-ছামানা; ");
INSERT INTO syl_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","আর পাক জাগাত ইমামতি কামর লাগি ইমাম হারুনর পবিত্র লেবাছ, আর তান পুয়াইন্তরও ইমামতির লেবাছ। ");
INSERT INTO syl_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","মাবুদে মুছারে যেলা হুকুম দিছলা, অউ লাখান বনি ইছরাইল অকলে হকল কাম করলা। ");
INSERT INTO syl_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","হেশে মুছায় ইতা হকলতা দেখিয়া বুজলা, মাবুদে যেলা হুকুম দিছলা, অউ লাখানউ করা অইছে। এরলাগি তাইন হকল বনি ইছরাইলরে দোয়া দিলা। ");
INSERT INTO syl_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","মাবুদে মুছা নবীরে কইলা, ");
INSERT INTO syl_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“তুমি বছরর পয়লা চান্দর পয়লা তারিখো মিলন-তাম্বু সহ আমার ঘররে খাড়া করিও। ");
INSERT INTO syl_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","ঘরর ভিতরে শাহাদত সন্দুকরে হারাইয়া, মাজে পর্দা টানাইয়া সন্দুকরে আওড়ে থইও। ");
INSERT INTO syl_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","টেবুলরেও ভিতরে হারাইয়া, এর উপরর চিজ অকল হাজাইও। বাদে চেরাগ দানি ভিতরে আনিয়া তার চেরাগ অকল জালাই দিও। ");
INSERT INTO syl_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","সোনাদি বানাইল আগর-খুশবয় জালানির টেবুল শাহাদত সন্দুকর ছামনে থইও, থইয়া আমার ঘরর দুয়ারর পর্দা লাগাইও। ");
INSERT INTO syl_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","আমার ঘরর মিলন-তাম্বুর দুয়ারর ছামনে জালাইল কুরবানি খানা থইও। ");
INSERT INTO syl_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","কুরবানি খানা আর মিলন-তাম্বুর মাজখানো অজুর গামলা পানিদি ভরিয়া থইও। ");
INSERT INTO syl_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","বাদে উঠানর চাইরো গালাবায় পর্দা টানাইও, আর উঠানর গেইটোও পর্দা লাগাইও। ");
INSERT INTO syl_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“বাদে তুমি খেলাফতির তেল দিয়া আমার ঘর আর আমার ঘরর হকল মাল-ছামানারে পবিত্র করিও। তেউ ইতা হকলতা মহা পাক-পবিত্র অইবো। ");
INSERT INTO syl_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","আর জালাইল কুরবানি খানার উপরেও খেলাফতির তেল দিয়া পবিত্র করিও। কুরবানি খানার হকল মাল-ছামানারেও পবিত্র করিও। তেউ ই কুরবানি খানা মহা-পবিত্র চিজ অইবো। ");
INSERT INTO syl_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","অজুর পানির গামলা আর এর তলর চকি-খাটরেও খেলাফতির তেল দিয়া পবিত্র করিও। ");
INSERT INTO syl_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“বাদে হারুন আর তার পুয়াইনরে মিলন-তাম্বুর দুয়ারর ছামনে আনিয়া পানিদি নাওয়াই দিও। ");
INSERT INTO syl_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","নাওয়ানির বাদে হারুনরে পাক-পবিত্র লেবাছ অকল ফিন্দাইও, আর আমার ইমাম অওয়ার লাগি তারে পবিত্র তেল লাগাইয়া খেলাফতি দিয়া পবিত্র করিও। ");
INSERT INTO syl_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","তার পুয়াইন্তরে আনিয়া ইমামতির পাইঞ্জাবি ফিন্দাইও। ");
INSERT INTO syl_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","তারার বাফরে যেলা পবিত্র তেলদি ইমামতি কামর খেলাফতি দিছো, তারারেও অউলা খেলাফতি দিও, যাতে তারাও আমার ইমামতি কাম করতা পারইন। ই খেলাফতির মাজদি ইমামতির যে নিয়ম চালু অইবো, ইতা ওয়ারিশর পর ওয়ারিশ ধরি চালু রইবো।” ");
INSERT INTO syl_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","মাবুদর হুকুম মাফিক মুছায় ইতা হকলতা করলা। ");
INSERT INTO syl_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","দুছরা বছরর পয়লা চান্দর পয়লা তারিখো আল্লার ঘর খাড়া করা অইলো। ");
INSERT INTO syl_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","মুছায় ই ঘর খাড়া করলা, পয়লা এর খুটির তলর চুঙি বওয়াইলা, খুটিন উবা করলা, বেড়ার ফ্রেইম লাগাইলা, ফ্রেইমর ভিতরেদি বাত্তি দিলা। ");
INSERT INTO syl_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","মাবুদর হুকুম মাফিক তাইন ছাগলর রুমা দিয়া ঘরর পয়লা ছানি দিলা, এর উপরে দিলা আরো দুইটা ছানি। ");
INSERT INTO syl_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","বাদে হউ দুইওখান পবিত্র শাহাদত পাথর আনিয়া সন্দুকর ভিতরে হারাইলা। সন্দুক বইয়া নেওয়ার বেন্দা লাগাইলা, সন্দুকর উপরর ঢাকনাও লাগাইলা। ");
INSERT INTO syl_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","আর সন্দুকরে নিয়া আল্লার ঘরর ভিতরে হারাইলা। হারাইয়া পর্দা টানাইয়া সন্দুকরে আওড়ে রাখলা, যেলা মাবুদে মুছারে হুকুম দিছলা। ");
INSERT INTO syl_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","সন্দুকর অউ পর্দার বারে উত্তর গালাবায়, মিলন-তাম্বুর মাজে পবিত্র রুটির টেবুল রাখলা। ");
INSERT INTO syl_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","টেবুলর উপরে মাবুদর নামর পবিত্র রুটি হাজাইয়া থইলা, যেলা মাবুদে মুছারে হুকুম দিছলা। ");
INSERT INTO syl_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","টেবুলর ছামনে তাম্বুর দক্ষিন গালাত চেরাগ দানি থইলা। ");
INSERT INTO syl_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","বাদে মাবুদর ছামনে চেরাগ গুইন জালাইলা, যেলা মাবুদে মুছারে হুকুম দিছলা। ");
INSERT INTO syl_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","মিলন-তাম্বুর মাজখানর পর্দার ছামনে সোনাদি বানাইল আগর-খুশবয় জালানির টেবুল থইলা। ");
INSERT INTO syl_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","অখানর উপরে খুশবয় আলা আগর জালাইলা, যেলা মাবুদে মুছারে হুকুম দিছলা। ");
INSERT INTO syl_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","বাদে মুছায় দুয়ারর পর্দা টানাইলা। ");
INSERT INTO syl_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","তাইন আল্লার ঘরর মিলন-তাম্বুর দুয়ারর কান্দাত জালাইল কুরবানি খানা থইলা। থইয়া এর উপরে জালাইল পশু কুরবানি আর ধান-গমর ছদগা দিলা, যেলা মাবুদে মুছারে হুকুম দিছলা। ");
INSERT INTO syl_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","বাদে মিলন-তাম্বু আর কুরবানি খানার মাজখানো অজুর গামলা থইলা, থইয়া অজুর পানি ভরিয়া দিলা। ");
INSERT INTO syl_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","অউ পানি দিয়া মুছা, হারুন আর হারুনর পুয়াইন্তে অজু করতা। ");
INSERT INTO syl_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","মাবুদর হুকুম মাফিক তারা মিলন-তাম্বুত হামানির আগে, বা কুরবানি খানার কান্দাত যাওয়ার আগে অজু করতা। ");
INSERT INTO syl_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","বাদে মুছায় আল্লার ঘর আর কুরবানি খানার চাইরোবায় পর্দা টানাইয়া উঠান বানাইলা। উঠানর গেইটর পর্দা লাগাইলা। অউ লাখান মুছায় তান হকল কাম শেষ করলা। ");
INSERT INTO syl_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","কাম শেষ করিয়া হারলে, গাইবি মেঘর খুটি আইয়া অউ মিলন-তাম্বুরে গুরিলিলো, মাবুদর মহিমা আর কুদরতে আস্তা ঘর ভরি গেল। ");
INSERT INTO syl_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","এরলাগি মুছা আর মিলন-তাম্বুত হামাইতা পারলা না, কারন এর উপরে হউ মেঘর খুটি আছিল, আর মাবুদর কুদরতি মহিমায় আস্তা ঘর ভরি গেছিল। ");
INSERT INTO syl_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","বনি ইছরাইলর অউ আস্তা ছফরর মাজে, আল্লার ঘরর উপরে থাকি মেঘর খুটি হরিয়া হারলে তারা আটিয়া রওয়ানা দিতা। ");
INSERT INTO syl_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","অইলে মেঘর খুটি উপরে থাকি না হরা পর্যন্ত তারা বার অইতা না, অউ খুটি হরার লাগি বার চাইতা। ");
INSERT INTO syl_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","কারন বনি ইছরাইলর অউ আস্তা ছফরর মাজেউ, দিনর বালা তারার চখুর ছামনে আল্লার ঘরর উপরে মেঘর খুটি রইতো, আর রাইতর বালা রইতো আগুইনর খুটি॥");
INSERT INTO syl_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","অউ পবিত্র কাবা ঘর মানি মিলন-তাম্বু বানানির বাদে, মাবুদে মুছা নবীরে অনো আনাইয়া কইলা, ");
INSERT INTO syl_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“তুমি হকল বনি ইছরাইলরে জানাই দেও, কেউ যুদি কুরবানি হিসাবে মাবুদর দরবারো কুনু পশু দিতো চায়, তে গরু বা ছাগল-মেড়ার পাল থাকি পশু আনিয়া কুরবানি দিলাউক। ");
INSERT INTO syl_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“কুরবানি দেওরায় যুদি গরুর পাল থাকি জালাইল কুরবানি আদায় করতো চায়, তে পুরাপুর নিখুত এগু বিছাল আনতে অইবো। আনিয়া মাবুদরে খুশি করার নিয়তে অউ বিছালরে মিলন-তাম্বুর দুয়ারর গেছে লইয়া আইবো। ");
INSERT INTO syl_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","আইয়া জালাইল কুরবানির নিয়তে আনা অউ বিছালর কল্লার উপরে আত থইবো, তেউ তার গুনার কফরা হিসাবে ইটারে কবুল করা অইবো। ");
INSERT INTO syl_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","বাদে মাবুদর ছামনে অউ বিছালরে হে জবো করবো। আর ইমাম হারুনর যে পুয়াইন্তে ইমামতি করইন, তারা অউ বিছালর লউ নিয়া মিলন-তাম্বুর দুয়ারর ছামনর কুরবানি খানার চাইরো গালাত ছিটাই দিবা। ");
INSERT INTO syl_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","বাদে কুরবানি দেওরায় অউ বিছালর খাল খালিয়া হারি, অগুর গোস্ত টুকরা টুকরা করবা। ");
INSERT INTO syl_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","আর ইমাম হারুনর পুয়াইন্তে কুরবানি খানার উপরে জালাইল আংরা থইবা, এর উপরে দারু হাজাইবা। ");
INSERT INTO syl_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","হাজাইয়া অউ দারুর উপরে বিছালর কল্লা, চর্বি, গোস্তর টুকরাইন থইবা। ");
INSERT INTO syl_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","কুরবানি দেওরায় গরুর ঠেং আর পেটর ভিতরর হক্কলতা পানি দিয়া ধইয়া ছাফ করিয়া দিবা, আর ইমামে অতা নিয়া আস্তা বিছালর হক্কলতা কুরবানি খানার উপরে জালাইলিবা। ইটার নাম অইলো জালাইল কুরবানি, মাবুদর নামে আগুনিত দেওয়া কুরবানি, অউ ধুমার ঘেরানে তাইন খুশি অইন। ");
INSERT INTO syl_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“আর কুনু মানষে যুদি ছাগল-মেড়ার পাল থাকি জালাইল কুরবানি আদায় করার খিয়ালি অয়, তে ইকটা পুরাপুর নিখুত এগু পাঠা অইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","কুরবানি দেওরায় ইকটারে কুরবানি খানার উত্তর গালাত নিয়া মাবুদর ছামনে জবো করিয়া হারলে, ইমাম হারুনর যে পুয়াইন্তে ইমামতি করইন, তারা অগুর লউ নিয়া কুরবানি খানার চাইরো গালাত ছিটাই দিবা। ");
INSERT INTO syl_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","বাদে কুরবানি দেওরায় ইটার গোস্ত টুকরা টুকরা করি কাটিয়া দিলে, ইমাম ছাবে অগুর চর্বি, কল্লা আর গোস্তর টুকরাইন নিয়া কুরবানি খানার জালাইল আংরার উপরর দারুর উপরে হাজাইবা। ");
INSERT INTO syl_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","কুরবানি দেওরায় ইটার ঠেং, পেটর ভিতরর হক্কলতা পানি দিয়া ধইয়া ছাফ করিয়া দিবা, আর ইমাম ছাবে ইতা হক্কলতা সমেত আস্তা পশুরে কুরবানি খানার উপরে জালাইলিবা। ইটা অইলো জালাইল কুরবানি, মাবুদর নামে আগুনিত দেওয়া ঘেরান আলা কুরবানি, অউ ধুমার ঘেরানে তাইন খুশি অইন। ");
INSERT INTO syl_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“আর কুনু পাখি দিয়া যুদি মাবুদর নামর অউ জালাইল কুরবানি আদায় করার খিয়াল অয়, তে কুরবানি দেওরায় ডুপি পাখি বা পারো লইয়া আইবো। ");
INSERT INTO syl_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","আইলে, ইমামে কুরবানি খানার ধারো গিয়া অউ পাখির কল্লা মুরা মারিয়া ছিড়িয়া আলগাইয়া হারি কুরবানি খানার উপরে অউ কল্লারে জালাইলিবা, আর অগুর লউ নিয়া কুরবানি খানার এক গালাত ছিটাই দিবা। ");
INSERT INTO syl_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","ইমামে পাখির ভিতরর গিলা-থলি আর ফইর নিয়া কুরবানি খানার পুব গালার ছালির টেকির মাজে ফালাই দিবা। ");
INSERT INTO syl_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","আর অগুর ডাখনাত ধরিয়া অলা বাটে ছিড়িবা, যাতে ইটার দুই টুকরা পুরাপুর আলগ না অয়। বাদে ইমাম ছাবে ইটা নিয়া কুরবানি খানার জালাইল আংরার উপরর দারুর উপরে থইয়া জালাইলিবা। ইটাও অইলো জালাইল কুরবানি, মাবুদর নামে আগুনিত দেওয়া ঘেরান আলা কুরবানি, অউ ধুমার ঘেরানে তাইন খুশি অইন। ");
INSERT INTO syl_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“কুনু মানষে যুদি ধান-গম দিয়া মাবুদর নামে লিল্লা-ছদগা দিতো চায়, তে নিরেক ময়দা দিয়া আদায় করবো। অউ ময়দার উপরে হে জয়তুনর তেল আর লোবান-আগরর ধুনা দিবো। ");
INSERT INTO syl_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","দিয়া ইমাম হারুনর যে পুয়াইন্তে ইমামতি করইন তারার গেছে অতা লইয়া আইবো। ইমামে অতা থাকি তেল মিশাইল এক মুইট ময়দা আর হকল আগর লইয়া, তার আনা হক্কলতার বদলা নিশানা হিসাবে অউ অংশরে কুরবানি খানার উপরে জালাইলিবা। ইতা অইলো মাবুদর নামে আগুনিত দেওয়া কুরবানি, ইতার ধুমার ঘেরানে তাইন খুশি অইন। ");
INSERT INTO syl_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","জালানির বাদে যতখান বাকি রইবো, ইতা ইমাম হারুন আর তান পুয়াইন্তে পাইবা। মাবুদর নামর আগুনিত দেওয়া কুরবানির অংশ অওয়ায়, বাচি যাওয়া অউ ময়দা তো খাছ পবিত্র জিনিস। ");
INSERT INTO syl_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“আর কেউ যুদি তুন্দুরি উন্দালো হেদিয়া আনা কুনু ধান-গমর ছদগা আদায় করতো চায়, তে তেল মিশাইল নিরেক ময়দা দিয়া খামির ছাড়া রুটি বা বানাইল রুটিত তেল মাখাইয়া লইয়া আইবো। ");
INSERT INTO syl_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","আর অউ ছদগার রুটি যুদি তাওয়াত হেদিয়া আনা অয়, তে ইতা তেল মিশাইল খামির ছাড়া নিরেক ময়দা দিয়া বানাইয়া আনতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","আনিয়া ইতা টুকরা টুকরা করিয়া এর উপরে তেল ঢালিয়া দিতে অইবো, ইতাও ধান-গমর এক নমুনার ছদগা। ");
INSERT INTO syl_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","আর অউ ছদগার রুটি যুদি লুয়াড়ির মাজে ভাজিয়া আনা অয়, তে ইতাও তেল আর নিরেক ময়দা দিয়া বানাইয়া আনবায়। ");
INSERT INTO syl_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","অলা যেকুনু নমুনায় বানাইল ধান-গমর ছদগারে মাবুদর নামে আনিয়া ইমামর আতো সমজাই দিবায়, ইমামে ইতা কুরবানি খানার গেছে নিবা। ");
INSERT INTO syl_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","নিয়া তার আনা অউ হক্কলতার বদলা নিশানা হিসাবে, ইমামে অখান থাকি কিছু অংশ আলগাইয়া কুরবানি খানার উপরে জালাইলিবা। ইতা অইলো আগুনিত দেওয়া কুরবানি, এর ধুমার ঘেরানে মাবুদ খুশি অইন। ");
INSERT INTO syl_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","অউ অংশ জালাইয়া হারলে বাদ-বাকি যেতা রইবো, ইতা হকলতা ইমাম হারুন আর তান পুয়াইন্তে পাইবা। মাবুদর নামে আগুনিত দেওয়া কুরবানির অংশ অওয়ায়, বাচি যাওয়া অউ ছদগার রুটি তো খাছ পবিত্র জিনিস। ");
INSERT INTO syl_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“আর হুনো, মাবুদর নামে ধান-গমর ছদগার নিয়তে যততা আনা অইবো, ইতা হকলতাউ যানু খামির ছাড়া তিয়ার করা অয়। হুশিয়ার রইও, তুমরা মাবুদর নামর আগুনিত দেওয়া লিল্লা-ছদগার মালর লগে কুনু খামির বা মউ জালাইও না। ");
INSERT INTO syl_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","তা-ও খেতর পয়লা ফয়-ফসলর ছদগার লগে তুমরা মউ বা খামির মাবুদর নামে দিতায় পারবায়, অইলে ধুমার ঘেরান আলা ছদগার নিয়তে খামির বা মউ কুরবানি খানাত জালাইল যাইতো নায়। ");
INSERT INTO syl_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","খিয়াল রাখিও, তুমরা ধান-গমর ছদগার নিয়তে যততা বানাইয়া আনবায়, ইতা হক্কলতার মাজে নুন মিশাইবায়। বনি ইছরাইলর আল্লার ওয়াদা-চুক্তিরে মনো রাখিয়া, তুমরা হকল নমুনার ধান-গমর ছদগাত নুন দিতে ফাউরিও না। তুমরার হক্কল কুরবানির মাজে নুন দিও। ");
INSERT INTO syl_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“তুমরার খেতর পয়লা দাওয়া ধান-গমর কুনু ফসল যুদি মাবুদর নামে লিল্লা-ছদগা হিসাবে লইয়া আও, তে ইতা মাড়া দেওয়া কাচা নয়া ধান-গম বা আস্তা ছড়ারে আগুইনদি হেদিয়া আনবায়। ");
INSERT INTO syl_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","ইতার উপরে তেল আর লোবান-আগর দিবায়, ইতা অইলো এক নমুনার ধান-গমর ছদগা। ");
INSERT INTO syl_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","অউ ছদগা লইয়া আইলে, ইমাম ছাবে নিশানা হিসাবে অউ জনর আনা ধান-গমর ছদগার কিছু অংশ, কিছু তেল আর হকল আগর নিয়া কুরবানি খানাত জালাইলিবা, ইতা অইলো মাবুদর নামে আগুনিত দেওয়া কুরবানি। ");
INSERT INTO syl_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“কুনু মানষে যুদি মাবুদর নামে নিজর খুশিয়ে ছালামতি কুরবানি আদায় করার নিয়তে কুনু গাই বা বিছালরে কুরবানি দিতো চায়, তে ই গরু পুরাপুর নিখুত অইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","কুরবানি দেওরায় অউ পশুর কল্লা আতাইয়া দিয়া, মিলন-তাম্বুর দুয়ারর ছামনে ইটারে জবো করবো। বাদে ইমাম হারুনর পুয়াইন্তর মাজর ইমাম অকলে অগুর লউ নিয়া কুরবানি খানার চাইরো গালাত ছিটাই দিবা। ");
INSERT INTO syl_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","আর কুরবানি দেওরায় মাবুদর নামে আনা ছালামতি কুরবানির পশুর অউ অংশ অকল দিবা। অগুর পেটর ভিতরর হক্কলতার উপরর চর্বি, ");
INSERT INTO syl_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","দুইও কিডনি আর অতার চর্বি, কইলজার লগর মাটিয়া, অউ হকলতা আনিয়া ইমামর গেছে দিবা। ");
INSERT INTO syl_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","বাদে হারুনর পুয়াইন্তে কুরবানি খানার উপরে হাজাইল দারু আর কুরবানির পশুর উপরে ইতা হকলতা রাখিয়া একলগে জালাইলিবা। ইতা তো এক নমুনার আগুনিত দেওয়া কুরবানি, ইতার ধুমার ঘেরানে মাবুদ খুশি অইন। ");
INSERT INTO syl_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“কুনু মানষে যুদি মাবুদর নামে ছালামতি কুরবানি আদায় করার লাগি ছাগল-মেড়ার পাল থাকি কুনু পশুরে কুরবানি দিবার নিয়ত করে, তে ই পশু মেদা বা মেদি অইলেও চলবো, অইলে ইটা পুরাপুর নিখুত অইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","কুরবানি দিবার নিয়তে যুদি মেড়া আনে, তে মাবুদর ছামনে ইটা আজির করবা। ");
INSERT INTO syl_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","কুরবানি দেওরায় অউ মেড়ার কল্লা আতাই দিয়া, মিলন-তাম্বুর দুয়ারর ছামনে ইটারে জবো করবো। বাদে ইমাম হারুনর পুয়াইন্তর মাজর ইমাম অকলে অগুর লউ নিয়া কুরবানি খানার চাইরো গালাত ছিটাই দিবা। ");
INSERT INTO syl_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","কুরবানি দেওরায় মাবুদর নামে আগুনিত দেওয়া কুরবানি হিসাবে আনা, অউ ছালামতি কুরবানির মেড়ার হকল চর্বি ইমামর গেছে দিবা। তাইন চর্বি আলা লেংগুড়, পেটর ভিতরর হকলতার উপরর চর্বি, ইতার লগে লাগাইল চর্বি, ");
INSERT INTO syl_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","দুইও কিডনি আর অতার হকল চর্বি, কইলজার লগর মাটিয়া, অতা হকলতা আনিয়া ইমাম ছাবর গেছে দিবা। ");
INSERT INTO syl_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","ইমামে ইতা নিয়া কুরবানি খানার আগুনির উপরে জালাইলিবা, ইতা অইলো মাবুদর নামে আগুনিত দেওয়া কুরবানির খানি। ");
INSERT INTO syl_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“আর কুরবানি দিবার নিয়তে হে যুদি ছাগল আনে, তে হে ইটারে মাবুদর ছামনে আজির করবো। ");
INSERT INTO syl_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","হে অগুর কল্লা আতাই দিয়া, মিলন-তাম্বুর দুয়ারর ছামনে ইটারে জবো করবো, বাদে হারুনর পুয়াইন্তে অগুর লউ নিয়া কুরবানি খানার চাইরো গালাত ছিটাই দিবা। ");
INSERT INTO syl_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","কুরবানি দেওরায় পশুর অউ অংশ অকল নিয়া, মাবুদর নামে আগুনিত দেওয়া কুরবানি হিসাবে ইমামর গেছে দিবো। হে পশুর পেটর ভিতরর হকলতার উপরর চর্বি, ইতার লগে লাগাইল চর্বি, ");
INSERT INTO syl_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","দুইও কিডনি আর অতার উপরর চর্বি, কইলজার লগর মাটিয়া, অতা হকলতা আনিয়া ইমামর গেছে দিবো। ");
INSERT INTO syl_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","ইমামে ইতা হকলতা নিয়া কুরবানি খানার উপরে জালাইলিবা, ইতা তো আগুনিত দেওয়া কুরবানির খানি, ইতার ধুমার ঘেরানে মাবুদ খুশি অইন। “মনো রাখিও, কুরবানির পশুর হক্কল চর্বি অইলো মাবুদর। ");
INSERT INTO syl_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","তুমরা বংশর পর বংশ ধরিয়া অউ নিয়ম মানিও, যেকুনু জাগাত বসত করো না কেনে কুনুদিন চর্বি বা লউ খাইও না, ইতা হারাম।” ");
INSERT INTO syl_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","বাদে মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“তুমি বনি ইছরাইলরে কও, না জানার কারনে কেউ যুদি ভুল করিয়া আল্লার নিষেধ করা কুনু গুনার কাম করিলায়, তে তাইন অউ নমুনায় গুনার কফরার কুরবানি আদায় করবা। ");
INSERT INTO syl_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“এইন খেলাফতি পাওয়া পরধান ইমাম ছাব অইলে, তান গুনার দায়-ভার হকল মানষর উপরে বর্তে, এরলাগি তাইন নিখুত এগু বিছাল আনিয়া মাবুদর দরবারো তান গুনার কফরার কুরবানি দিবা। ");
INSERT INTO syl_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","অউ বিছাল লইয়া তাইন মিলন-তাম্বুর দুয়ারর গেছে মাবুদর ছামনে আইবা, আইয়া অগুর কল্লা আতাই দিয়া, মাবুদর ছামনে জবো করবা। ");
INSERT INTO syl_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","করিয়া অউ বিছালর থুড়া লউ নিয়া মিলন-তাম্বুর ভিতরে যাইবা। ");
INSERT INTO syl_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","গিয়া লউর মাজে নিজর আংগুল ছুবাইয়া লউ লাগাইয়া হেরেম শরিফর পর্দার বায় মাবুদর ছামনে সাত বার ছিটাই দিবা। ");
INSERT INTO syl_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","বাদে আরো থুড়া লউ লইয়া মিলন-তাম্বুর মাজে মাবুদর ছামনে আগর-খুশবয় জালানির টেবুলর চাইরো কুনার হিং অকলর মাজে লাগাইবা। আর বাদ-বাকি লউ নিয়া মিলন-তাম্বুর দুয়ারর ছামনর জালাইল কুরবানি খানার তলে ঢালি দিবা। ");
INSERT INTO syl_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","বাদে গুনার কফরার লাগি দেওয়া কুরবানির অউ বিছালর হকল চর্বি বার করবা, পেটর ভিতরর হক্কলতার উপরর চর্বি, ইতার লগে লাগাইল হকল চর্বি, ");
INSERT INTO syl_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","দুইও কিডনি আর অতার উপরর চর্বি, আর কইলজার লগর মাটিয়া। ");
INSERT INTO syl_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","ছালামতি কুরবানির গরুর চর্বির লাখান, অউ কুরবানির বিছালর হকল চর্বিরেও অলা বার করবা। বাদে ইমামে অউ চর্বি নিয়া জালাইল কুরবানি খানাত জালাইলিবা। ");
INSERT INTO syl_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","অইলে অউ বিছালর কল্লা, খাল, গোস্ত, ঠেং, আত-ভড়, গুফর, ");
INSERT INTO syl_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","হকলতা নিয়া বনি ইছরাইলর কেম্পর বারে যেখানো কুরবানির ছালির টেকি থইন, হউ পাক-ছাফ জাগার ছালির টেকির উপরে অতা থইয়া হারি, লাকড়ির আগুইনদি জালাইলিবা। ");
INSERT INTO syl_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“আর আস্তা বনি ইছরাইল সমাজ না জানার কারনে যুদি ভুল করিয়া কুনু গুনার কাম করিলায়, আল্লার নিষেধ করা কুনু কাম করিয়া দুষি বনিযায়, তে না জানিয়া করলেও তারা হকলউ গুনাগার। ");
INSERT INTO syl_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","বাদে যেবলা তারা জানবা, জানিয়া হারি অউ গুনার কফরার লাগি হকলর তরফ থাকি এগু বিছাল কুরবানি দিবা, অউ বিছাল লইয়া তারা মিলন-তাম্বুর ছামনে আজির অইবা। ");
INSERT INTO syl_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","অইয়া বনি ইছরাইলর মুরব্বি অকলে অউ বিছালর কল্লা আতাই দিবা, আর ইমামে মাবুদর ছামনে অকটা জবো করবা। ");
INSERT INTO syl_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","জবোর বাদে খেলাফতি পাওয়া ইমাম ছাবে বিছালর থুড়া লউ লইয়া মিলন-তাম্বুর ভিতরে হামাইবা। ");
INSERT INTO syl_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","হামাইয়া অউ লউর মাজে তান আতর আংগুইল ছুবাইয়া, থুড়া লউ হেরেম শরিফর পর্দার বায় সাত বার মাবুদর ছামনে ছিটাইবা। ");
INSERT INTO syl_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","বাদে আরো থুড়া লউ লইয়া মাবুদর ছামনে থওয়া, মিলন-তাম্বুর ভিতরর আগর-খুশবয় জালানির টেবুলর হিং অকলো লাগাইবা। বাদ-বাকি লউ ফুটাইন মিলন-তাম্বুর দুয়ারর ছামনর জালাইল কুরবানি খানার তলে ঢালি দিবা। ");
INSERT INTO syl_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","আর বিছালর হকল চর্বি বার করিয়া কুরবানি খানাত জালাইলিবা। ");
INSERT INTO syl_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","পরধান ইমামর গুনার কফরার লাগি বিছালরে যেলা কুরবানি দেওয়া অয়, ইমামে অউ বিছালরেও অলা কুরবানি করবা। তাইন অউ সমাজর গুনার কফরার কুরবানি আদায় করলে, তারার গুনার মাফি মিলবো। ");
INSERT INTO syl_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","ইমাম ছাবে বিছালর বাদ-বাকি হকলতা লইয়া কেম্পর বারে যাইবা। গিয়া তান নিজর গুনার কফরার হউ বিছালর লাখান অউ বিছালর হকলতাও কেম্পর বারে অলা জালাইলিবা। ইতা অইলো আস্তা সমাজর গুনার কফরার কুরবানি। ");
INSERT INTO syl_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“আর বনি ইছরাইলর কুনু সর্দারে না জানার কারনে যুদি ভুল করিয়া অলা গুনা করিলাইন, তে আল্লার নিষেধ করা কাম করায় তাইন তো দুষি। ");
INSERT INTO syl_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","তাইন যেবলা অউ গুনার বেয়াপারে জানিলিবা, জানার বাদে কফরার কুরবানি দিবার লাগি নিখুত এগু পাঠা ছাগল লইয়া আইবা। ");
INSERT INTO syl_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","আইয়া অউ পাঠার কল্লার উপরে আতাই দিয়া, জালাইল কুরবানির পশু জবো করার জাগাত নিয়া অগুরে মাবুদর ছামনে জবো করবা। ইতা তো তান গুনার কফরার কুরবানি। ");
INSERT INTO syl_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","বাদে ইমাম ছাবে অউ পশুর থুড়া লউ তান আতর আংগুলিত করি লইয়া, জালাইল কুরবানি খানার হিং অকলর উপরে লাগাইবা। বাদ-বাকি লউ নিয়া তাইন কুরবানি খানার তলে ঢালি দিবা। ");
INSERT INTO syl_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","আর ছালামতি কুরবানির পশুর চর্বির লাখান অগুর হকল চর্বিরে কুরবানি খানার উপরে জালাইলিবা। অউ লাখান ইমামে হউ সর্দারর গুনার মাফির লাগি কফরা আদায় করলে, তাইন মাফি পাইবা। ");
INSERT INTO syl_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“আর বনি ইছরাইলর কুনু সাধারন জনে না জানার কারনে যুদি ভুল করিয়া কুনু গুনার কাম করিলায়, মাবুদর নিষেধ করা কুনু কাম করিয়া দুষি বনিযায়, ");
INSERT INTO syl_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","তে হে যেবলা তার গুনার বেয়াপারে জানিলিবো, জানিয়া অউ গুনার কফরার লাগি হে নিখুত এগু ছাগি লইয়া আইবো। ");
INSERT INTO syl_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","আইয়া অউ ছাগির কল্লার উপরে আতাই দিয়া, জালাইল কুরবানির জবোর জাগাত নিয়া অগুরে জবো করবো। ");
INSERT INTO syl_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","বাদে ইমাম ছাবে তান আতর আংগুলিত করি অগুর থুড়া লউ লাগাইয়া, কুরবানি খানার হিং অকলর উপরে লাগাইবা। বাদ-বাকি লউ তাইন কুরবানি খানার তলে ঢালি দিবা। ");
INSERT INTO syl_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","আর ছালামতি কুরবানির মেড়ার চর্বির লাখান অগুর হকল চর্বি বার করিয়া কুরবানি খানার উপরে জালাইলিবা। ইতার ধুমার ঘেরানে মাবুদ খুশি অইন। অউ নমুনায় ইমামে হউ জনর গুনার কফরা আদায় করলে, তার মাফি মিলবো। ");
INSERT INTO syl_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“গুনার কফরার কুরবানির নিয়তে কেউ যুদি কুনু মেড়া আনে, তে ইটা নিখুত মেড়ি-বাইচ্চা অইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","হে অগুর কল্লার উপরে আতাই দিয়া, জালাইল কুরবানির পশুর জবোর জাগাত নিয়া, গুনার কফরার কুরবানির নিয়তে অগুরে জবো করবো। ");
INSERT INTO syl_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","বাদে ইমাম ছাবে তান আতর আংগুলিত করি অউ মেড়ির থুড়া লউ লইয়া, কুরবানি খানার হিং অকলর উপরে লাগাইবা। বাদ-বাকি লউ তাইন কুরবানি খানার তলে ঢালি দিবা। ");
INSERT INTO syl_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","আর ছালামতি কুরবানির মেড়ার চর্বি যেলা বার করইন, অগুর হকল চর্বিরেও অলা বার করবা। বার করিয়া কুরবানি খানাত কুরবানি দেওয়া হকলতার উপরে থইয়া অউ চর্বিরেও জালাইলিবা, অউ নমুনায় ইমামে হউ জনর গুনার কফরা আদায় করিয়া হারলে, হে মাফি পাইবো। ");
INSERT INTO syl_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“কুনু মানষে যুদি নিজর চউখে দেখা বা কানে হুনা কুনু ঘটনা জানে, আর বিচারর কালো আদালতো সাক্ষির সুযোগ পাইয়াও সাক্ষি না দেয়, তে ইতার লাগি হে গুনা করে, তার ই অপরাধর সাজা হে বইবো। ");
INSERT INTO syl_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“কেউ যুদি না জানিয়া কুনু নাপাক জিনিস ছইলায়, তে হে নাপাক আর দুষি বনবো। ইতা কুনুজাতর জংলি হারাম মরা পশু, ঘরো পালা কুনু মরা জানদার বা মাটির মাজে বুকে চলরা যেকুনু মরা জানদাররে না জানিয়া ছইলেও দুষি-নাপাক বনবো। ");
INSERT INTO syl_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“মানষর শরিলরে যেতায় নাপাক করিলায়, শরিল থাকি বারইল অউ লাখান কুনুতা কেউ যুদি না জানিয়া ছইলায়, তে ইতা জানার বাদে হে দুষি অইবো। ");
INSERT INTO syl_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“আখল-বিবেক না খাটাইয়া আখতা যুদি কেউ কুনু কছম করিলায়, ভালা বা বুরা কুন্তা করমু কইয়া মনর বে-খিয়ালে কেউ কুনু কছম খাইলেও, হে যেবলা ইখান বুজিলিবো অউ সময় হে দুষি বনবো। ");
INSERT INTO syl_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“অউ লাখান যেকুনু অপরাধ করিয়া কেউ দুষি বনিগেলে, হে নিজর গুনারে স্বীকার করতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","আর অউ গুনার জরিমানা হিসাবে হে মাবুদর নামে, গুনার কফরার কুরবানির নিয়তে একটা মেড়ি বা ছাগি আনবো, আর ইমামে তার গুনার কফরা আদায় করবা। ");
INSERT INTO syl_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“আর হে যুদি মেড়ি বা ছাগি আনতে অপারগ অয়, তে অউ গুনার জরিমানা বাবত দুইটা ডুপি পাখি বা পারো আনিয়া মাবুদর নামে দিতে অইবো। ইতার মাজর এগু অইবো গুনার কফরার কুরবানি, আর দুছরাটা জালাইল কুরবানি। ");
INSERT INTO syl_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","আর হে ইতা আনিয়া ইমামর আতো দিবো, ইমামে গুনার কফরার কুরবানি হিসাবে পয়লা এগু পাখিরে কুরবানি দিবা। তাইন অগুর কল্লা মুরাইয়া মারবা, অইলে কল্লা আলগাইতা নায়। ");
INSERT INTO syl_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","বাদে অগুর থুড়া লউ নিয়া কুরবানি খানার চাইরো গালাত ছিটাই দিবা, আর বাদ-বাকি লউ কুরবানি খানার তলে ঢালি দিবা। ইতা অইলো গুনার কফরার লাগি কুরবানি। ");
INSERT INTO syl_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","আর দুছরা পাখিটারে ইমাম ছাবে নিয়ম মাফিক জালাইল কুরবানি দিবা। দিয়া, তার গুনার কফরা আদায় করবা, তেউ হে মাফি পাইবো। ");
INSERT INTO syl_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“আর যুদি অউ গুনার কফরার লাগি দুইটা ডুপি পাখি বা পারো আনতো না পারে, তে হে দুই সের ময়দা আনতে অইবো। ইতা গুনার কফরার কুরবানি অওয়ায় ইতার উপরে কুনু তেল বা লোবান-আগর দিও না। ");
INSERT INTO syl_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","অউ ময়দা লইয়া হে ইমামর গেছে যাইবো, গেলে অউ আস্তা কুরবানির বদলা নিশানা হিসাবে এক মুইট ময়দা ইমাম ছাবে কুরবানি খানার উপরে মাবুদর নামে জালাইলিবা। ইতা অইলো মাবুদর নামে গুনার কফরার কুরবানি। ");
INSERT INTO syl_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","হে যে অপরাধ করছে, অতার মাফির লাগি ইমামে অলা কফরা আদায় করবা, তেউ তার গুনার মাফি পাইবো। আর কুরবানি দেওয়ার বাদে ই ময়দার যতখান রইবো, ধান-গমর ছদগার লাখান ইতা হকলতা ইমামে পাইবা।” ");
INSERT INTO syl_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","বাদে মাবুদে মুছা নবীরে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“কেউ যুদি না জানিয়া মাবুদর পাক-পবিত্র কুনু মাল-ছামানার বেয়াপারে এমনেউ কুনু দুষ-কছুরি করিলায়, তে অউ গুনার জরিমানা হিসাবে এবাদত খানার মাপে যত তোলা রুপাদি মেড়ার দাম ঠিক করা অয়, তে হে তার নিজর পাল থাকি অউ পরিমান দামর বা হমান দামদি কিনিয়া নিখুত এগু মেড়ার পাঠা মাবুদর নামে কুরবানি দিতে অইবো। ইতা তো দুষ-কছুরির কফরার কুরবানি। ");
INSERT INTO syl_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","আর হে অউ পাক-পবিত্র মাল-ছামানার বেয়াপারে যে দুষ-কছুরি করছে, ইতার খেতি-পুরনও দিতে অইবো। হে অউ মেড়ার দামর লগে আরো পাচ বাটর এক বাট পরিমান নগদ টেকা ইমাম ছাবর আতো দিবো। বাদে ইমামে তার কছুরি মাফির নিয়তে অউ মেড়ারে নিয়া দুষ-কছুরির কফরার কুরবানি আদায় করিয়া হারলে, হে মাফি পাইবো। ");
INSERT INTO syl_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“আর কুনু মানষে যুদি ভুল করিয়া না জানিয়া আল্লার নিষেধ করা কুনু দুষ-কছুরির কাম করিলায়, তে ইতার লাগি হে দুষি। ই গুনার লাগি তারে দায়ী করা অইবো। ");
INSERT INTO syl_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","হে তার অউ দুষ-কছুরির কফরা হিসাবে, এগু নিখুত মেড়ার পাঠা বা এর দাম আনিয়া ইমাম ছাবর গেছে দিবো। হে না জানিয়া যে দুষ-কছুরি করিলিছে, ইমাম ছাবে অতার কফরা আদায় করবা, তেউ তার মাফি মিলবো। ");
INSERT INTO syl_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","ইতা তো দুষ-কছুরির কফরার কুরবানি, হে মাবুদর দরবারো দুষ করছে।” ");
INSERT INTO syl_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","মাবুদে মুছা নবীরে আরো কইলা, ");
INSERT INTO syl_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“হুনো, কুনু মানষে যেবলা তার আরি-ফরির লগে হারামি করিয়া মাবুদর দরবারো গুনা করে, তার গেছে থওয়া আমানত বা বন্ধকি জিনিসর খিয়ানত করে, বা চুরি করি কুনু মাল নেয় বা ঠগাঠগি করে, ছল-চতুরি করিয়া বেইমানি মাতে, ");
INSERT INTO syl_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","তুবাইয়া পাওয়া মালর বেয়াপারে বেইমানি মাতে বা অতা হক্কলতার বেয়াপারে কুনু মিছা কছম খায়, বা অউ লাখান আরো কুনু গুনা করে, ");
INSERT INTO syl_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","তে অউ নমুনার গুনা করিয়া অপরাধি বনায়, হে যেতা মাল আত্মসাত করছে, বা ছল-চতুরি করিয়া নিছে, বা আমানতর খিয়ানত করছে, তুবাই পাওয়া মাল লুকাইছে, ");
INSERT INTO syl_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","বা যেকুনু মালর বেয়াপারে মিছা কছম খাইছে, ইতা হকলতা হে ফিরত দিবো, এরলগে জরিমানা হিসাবে আরো পাচ বাটর এক বাট বেশি দিবো। হে যেদিন তার দুষ স্বীকার করবো, অউ দিন মালর মালিকরে ইতা ফিরাই দিবো। ");
INSERT INTO syl_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","আর নিজর দুষ-কছুরি মাফির নিয়তে হে মাবুদর দরবারো কুরবানি লইয়া আজির অইবো, ইমাম ছাবর ঠিক করা দামর এগু নিখুত মেড়ার পাঠা লইয়া আইবো। ");
INSERT INTO syl_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","ইমামে মাবুদর দরবারো তার গুনার কফরা আদায় করবা। হে অতার মাজর যেকুনু গুনা করলে, অউ নমুনায় তার গুনার মাফি পাইবো।” ");
INSERT INTO syl_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","বাদে মাবুদে মুছা নবীরে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“তুমি হারুন আর তার পুয়াইন্তরে হিকাই দেও, জালাইল কুরবানি আদায় করার মুছলা অইলো, কুরবানির পশু ফজর পর্যন্ত হারা রাইত কুরবানি খানার আগুনির উপরে রইবো, আর আগুইনও জালাইল রইবো। ");
INSERT INTO syl_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","বিয়ানি বালা ইমাম ছাবে সুতি কাপড়দি বানাইল হাফ-পেন্টর লাখান নিজর জাংগিয়াখান আর তান ইমামতির বাকি হকল সুতির লেবাছ ফিন্দিবা। ফিন্দিয়া কুরবানির পশু জালানির ছালি তুলিয়া নিয়া কুরবানি খানার কান্দাত থইবা। ");
INSERT INTO syl_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","বাদে তাইন অউ লেবাছ বদলাইয়া, দুছরা লেবাছ ফিন্দিয়া, অউ ছালিরে কেম্পর বারে কুনু পাক-ছাফ জাগাত নিয়া ফালাইবা। ");
INSERT INTO syl_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","অইলে কুরবানি খানাত আগুইন জালাইল রইবো, ইতা নিভতো না। পরতেক দিন বিয়ানে ইমামে অউ আগুনির উপরে জালানির দারু দিবা, দিয়া দারুর উপরে জালাইল কুরবানির পশুরে হাজাইবা, হাজাইয়া এর উপরে ছালামতি কুরবানির চর্বিরে জালাইবা। ");
INSERT INTO syl_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","হুশিয়ার রইও, কুরবানি খানার আগুইন হামেশা জলাত রইবো, ইতা কুনু সময়উ নিভতো না। ");
INSERT INTO syl_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ধান-গম ছদগার নিয়ম অইলো, হারুনর পুয়াইন থাকি একজন ইমামে অউ ছদগার ময়দা আর দরকারি হক্কলতা লইয়া কুরবানি খানার গেছে মাবুদর ছামনে আজির অইবা। ");
INSERT INTO syl_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","আর ইমামে অখান থাকি এক মুইট ময়দা, কিছু তেল আর ছদগার হকল লোবান-আগর নিয়া আস্তা ছদগার নিশানা হিসাবে অউ অংশরে কুরবানি খানার উপরে জালাইবা। ইতার ধুমার ঘেরানে তো মাবুদ খুশি অইন। ");
INSERT INTO syl_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","ছদগার মালর বাদ-বাকি অংশ ইমাম হারুন আর তার পুয়াইন্তে খাইবা। তারা ইতার মাজে কুনু খামির না মিশাইয়া রুটি বানাইবা, বানাইয়া মিলন-তাম্বুর উঠানো কুনু পাক জাগাত বইয়া খাইবা। ");
INSERT INTO syl_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","মনো রাখিও, কুনু খামির পুরাইয়া ইতারে ছেকিও না। আমার নামে দেওয়া জালাইল কুরবানির অউ অংশ আমি তারারে দিলাম। গুনার কফরার কুরবানি, আর দুষ-কছুরির কফরার কুরবানির লাখান ধান-গমর ছদগার অউ অংশও অইলো খাছ পবিত্র। ");
INSERT INTO syl_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","খালি ইমাম হারুনর বংশর হকল বেটা মানষে ইতা খাইতা পারবা, মাবুদর নামর জালাইল কুরবানির অউ অংশ তো ওয়ারিশর পর ওয়ারিশ ধরি তারাউ পাইবা। খুব খিয়াল রাখিও, যেছাতায় ইতার লগে লাগবো, অতাও পাক-পবিত্র বনিযিবো, মানি ইমাম অকলর বাইরা মানষর লাগি হারাম।” ");
INSERT INTO syl_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","মাবুদে মুছা নবীরে আরো কইলা, ");
INSERT INTO syl_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“হারুনে যেদিন ইমামতির খেলাফতি সমজিয়া কামো বওয়াল অইবা, অউ দিন হারুন আর তার পুয়াইন্তে ধান-গমর ছদগার নিয়ম মাফিক দুই সের ময়দা মাবুদর দরবারো আনবা। ইতার অর্ধেক বিয়ানে আর অর্ধেক হাইঞ্জা বালা দিবা। ");
INSERT INTO syl_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","তারা তেল দিয়া খাই বানাইয়া তাওয়াত ছেকিয়া হারলে ইতা টুকরা টুকরা করিয়া মাবুদর ছামনে ধান-গমর ছদগা হিসাবে আজির করবা, ইতার ধুমার ঘেরানে মাবুদ খুশি অইন। ");
INSERT INTO syl_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","হারুনর বাদে তার যে পুয়ারে পরধান ইমাম হিসাবে খেলাফতি দেওয়া অইবো, হে-ও অউলা ছদগা আদায় করবো। ইতা তো মাবুদর হর-হামেশাকুর পাওনা, অউ ছদগার পুরা অংশ জালাইলিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","ইমাম অকলর নিজর দেওয়া ধান-গমর ছদগার হক্কলতা জালাইলিতে অইবো, ইতা খাওয়ার কুনু হুকুম নায়।” ");
INSERT INTO syl_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","বাদে মাবুদে মুছা নবীরে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“তুমি হারুন আর তার পুয়াইন্তরে গুনার কফরার কুরবানির নিয়ম হিকাও। জালাইল কুরবানির পশুরে যে জাগাত জবো করইন, গুনার কফরার কুরবানির পশুরেও অনো জবো করবা। ই কুরবানির গোস্ত তো খাছ পবিত্র। ");
INSERT INTO syl_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","যে ইমামে অউ কুরবানি আদায় করবা, এইন অউ গোস্ত খাইবা। মিলন-তাম্বুর উঠানো পবিত্র জাগাত অউ গোস্ত খাইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","যেতা জিনিসে অউ গোস্তরে ছইবো, ইতা পাক-পবিত্র অইযিবো। কুনু কাপড়র মাজে যুদি এর লউর ছিটা লাগে, তে পাক-পবিত্র কুনু জাগাত ইতা ধইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","আর মাটির যে পাতিলো অউ গোস্ত রান্দা অইবো, ইতা বাদে ভাংগিলিবায়। অইলে পিতলর পাতিলো রান্দিলে ইটা মাঞ্জিয়া পানিদি ধইয়া পাক-ছাফ করবায়। ");
INSERT INTO syl_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","ইমাম বংশর যেকুনু বেটাইন্তে অউ কুরবানির গোস্ত খাইতা পারবা, ইতা তো খাছ পবিত্র গোস্ত। ");
INSERT INTO syl_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","অইলে গুনার কফরার কুরবানির পশুর লউ যুদি মিলন-তাম্বুর ভিতরে নেওয়া অইযায়, তে ই কুরবানির গোস্ত খাওয়া নিষেধ, ইতা জালাইলিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“দুষ-কছুরির কফরার কুরবানির মুছলা অইলো, ই কুরবানির গোস্ত তো খাছ পবিত্র। ");
INSERT INTO syl_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","জালাইল কুরবানির পশুরে যে জাগাত জবো করা অয়, অউ কুরবানির পশুরেও অনো জবো করতে অইবো। ইতার লউ কুরবানি খানার চাইরো গালাবায় ছিটাই দিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","আর ইতার হকল চর্বিরে লইবো, মানি চর্বি আলা লেংগুড়, পেটর ভিতরর হকলতার উপরর চর্বি, ");
INSERT INTO syl_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","এর লগে দুইও কিডনি আর অতার উপরর চর্বি, আর কইলজার লগর মাটিয়া, ই হকলতা আলগাইবা। ");
INSERT INTO syl_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","আলগাইয়া ইমামে অউ হকলতা নিয়া মাবুদর নামে আগুনিত দেওয়া কুরবানি হিসাবে কুরবানি খানার উপরে জালাইলিবা, ইতা অইলো দুষ-কছুরির কফরার কুরবানি। ");
INSERT INTO syl_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","কুরবানির গোস্ত ইমাম পরিবারর যেকুনু বেটা মানষে খাইতা পারবা। ইতা তো খাছ পবিত্র জিনিস, এরলাগি তারা যেকুনু পাক জাগাত বইয়া খাইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“গুনার কফরার কুরবানি আর দুষ-কছুরির কফরার কুরবানির নিয়ম-কানুন তো একই নমুনার। যে ইমাম ছাবে অউ কফরার কুরবানিরে আদায় করবা, এইন অউ গোস্ত পাইবা। ");
INSERT INTO syl_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","আর যে ইমামে জালাইল কুরবানি আদায় করবা, এইন অউ কুরবানির পশুর চামড়াও নিতা পারবা। ");
INSERT INTO syl_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","লুয়াড়িত, তাওয়াত বা তুন্দুরি উন্দালো হেদিয়া আনা ধান-গমর ছদগার রুটি খালি হউ ইমামে পাইবা, যেইন ই ছদগা আদায় করছইন। ");
INSERT INTO syl_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","অইলে ধান-গমর বাদ-বাকি হকল ছদগা, ইতা তেল মাখাইল বা হুকনা যেকুনু লাখান অউক, ইমাম হারুনর হকল পুয়াইন্তে ইতার হমান বাট পাইবা। ");
INSERT INTO syl_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“মাবুদর নামে দেওয়া ছালামতি কুরবানির নিয়ম অইলো, ");
INSERT INTO syl_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","কুনু মানষে যুদি মাবুদর শুকরিয়া আদায় করার খিয়ালে ছালামতি কুরবানি দেয়, তে অউ কুরবানির পশুর লগে তেল মিশাইল নিরেক ময়দা দিয়া খামির ছাড়া রুটি বা বানাইল রুটিত তেল মাখাইয়া লইয়া আইবো, বা তেল মিশাইল খামির ছাড়া নিরেক ময়দার পিঠা বানাইয়া আনতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","শুকরিয়া আদায় করার খিয়ালে ছালামতি কুরবানির জিনিসর লগে খামির আলা থুড়া রুটিও আনবো। ");
INSERT INTO syl_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","মাবুদর নামে দেওয়ার লাগি হে অউ পরতেক জিনিস থাকি একটা একটা করি আনবো। যে ইমামে ছালামতি কুরবানির পশুর লউ ছিটাইবা, এইন ইতা পাইবা। ");
INSERT INTO syl_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","শুকুরানা আদায় করার নিয়তে দেওয়া অউ কুরবানির গোস্ত অউ দিনউ খাইলিতে অইবো। ইতা বাদর দিন বিয়ানকুর লাগি থওয়া যাইতো নায়। ");
INSERT INTO syl_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“অউ ছালামতি কুরবানি যুদি কুনু মান্নত আদায় করার নিয়তে দেও, বা এমনে খুশি অইয়া কুরবানি দেও, তে ইতার গোস্ত অউ দিনউ খাইও, আর কিছু বাকি রইলে বাদর দিনও খাইতায় পারবায়। ");
INSERT INTO syl_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","অইলে দুই দিন বাদে ই গোস্ত রইলে, ইতা জালাইলিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","তিন নম্বর দিন ই গোস্ত খাইলে কুরবানি কবুল অইতো নায়। কুরবানি দেওরার আমল-নামাত ইতা উটতো নায়, অউ গোস্ত তো নাপাক অইগেছে, কুনু মানষে ইতা খাইলে তারে নাফরমান হিসাবে গনা অইবো। ");
INSERT INTO syl_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ছালামতি কুরবানির গোস্তর মাজে নাপাক কুনু জিনিস লাগিগেলে, ই গোস্তর ই অংশ আর খাওয়া যাইতো নায়, ইতা জালাইলিবা। অইলে বাকি গোস্ত খাওয়া যাইবো, পাক-ছাফ হালতে যে কুনু জনে ইতা খাইতা পারবা। ");
INSERT INTO syl_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","আর নাপাক হালতে কুনু মানষে যুদি মাবুদর নামে দেওয়া অউ ছালামতি কুরবানির গোস্ত খাইলায়, তে সমাজ থাকি তার নাম মিটাইলিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","কুনু মানষে যুদি পশুর বা মানষর কুনু নাপাক জিনিস ছইয়া হারি বা দুছরা নাপাক কুন্তা ছইয়া হারি মাবুদর নামে দেওয়া ছালামতি কুরবানির গোস্ত খাইলায়, তে তার নামও সমাজ থাকি মিটাইলিতে অইবো।” ");
INSERT INTO syl_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","আর মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“তুমি বনি ইছরাইলরে জানাই দেও, তুমরা গরু-ছাগল বা মেড়ার কুনুজাত চর্বি খাইও না। ");
INSERT INTO syl_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","কুনু মরা পশুর বা জংলি জানুয়ারে মারা পশুর চর্বিরে তুমরা অইন্য কুনু কামো লাগাইতায় পারবায়, অইলে খাইতায় পারতায় নায়। ");
INSERT INTO syl_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","যত নমুনার পশু দিয়া মাবুদর নামে আগুনিত দেওয়া কুরবানি আদায় করা অয়, ইতা জাতর পশুর চর্বি যেগুয়ে খাইবো, তার নামরে সমাজ থাকি মিটাইলিবায়। ");
INSERT INTO syl_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","তুমরা যেকুনু জাগাত বসত করো না কেনে, কুনুজাত পশু বা পাখির লউ খাওয়া জাইজ নায়। ");
INSERT INTO syl_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","কুনু মানষে যুদি লউ খায়, তে সমাজ থাকি তার নাম মিটাইলিতে অইবো।” ");
INSERT INTO syl_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","বাদে মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“তুমি বনি ইছরাইলরে জানাই দেও, যেকুনু মানষে কুনু পশু দিয়া ছালামতি কুরবানি আদায় করলে, কুরবানির গোস্তর একটা অংশ মাবুদর দরবারো দিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","মাবুদর নামে আগুনিত দেওয়া কুরবানির অউ অংশ, মানি ছিনা আর ছিনার উপরর চর্বি হে নিজর আতে আনিয়া ইমাম ছাবরে দিবো। ইমামে ইতারে উচা করিয়া মাবুদর ছামনে দুলাইবা। ");
INSERT INTO syl_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","বাদে তাইন চর্বিরে কুরবানি খানার উপরে জালাইলিবা, অইলে অউ ছিনার গোস্ত ইমাম হারুন আর তান পুয়াইন্তে পাইবা। ");
INSERT INTO syl_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","ছালামতি কুরবানির পশুর ডাইনর রানর গোস্ত ইমাম ছাবরে দিলাইবায়। ");
INSERT INTO syl_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","ইমাম হারুনর বংশর যে কেউ ছালামতি কুরবানির পশুর লউ আর চর্বিরে কুরবানি দিবা, তান পাওনা হিসাবে অউ রানর গোস্ত নিবা। ");
INSERT INTO syl_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","বনি ইছরাইলর দেওয়া হকল ছালামতি কুরবানির গোস্ত থাকি দুলনা কুরবানির ছিনা আর ডাইনর রানর গোস্ত আমি ইমাম হারুন আর তার পুয়াইন্তরে দিলাম। বনি ইছরাইলর দেওয়া কুরবানির ই অংশ অইলো তারার হামেশাকুর পাওনা হক।” ");
INSERT INTO syl_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","হারুন আর তার পুয়াইন্তরে যেদিন থাকি ইমামতির কামো বওয়াল করা অইছিল, হউ দিন থাকি মাবুদর নামে আগুনিত দেওয়া হকল নমুনার কুরবানির অউ অংশরে তারার পাওনা হক হিসাবে ধরা অইছে। ");
INSERT INTO syl_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","তারারে যেদিন খেলাফতি সমজাইয়া বওয়াল করা অইছে, হউ দিন মাবুদে বনি ইছরাইলরে হুকুম দিছলা, কুরবানির গোস্তর অউ অংশ হর-হামেশা এরারে দিবার লাগি। ");
INSERT INTO syl_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","ইতা অইলো জালাইল কুরবানি, ধান-গমর ছদগা, গুনার কফরার কুরবানি, দুষ-কছুরির কফরার কুরবানি, ইমামতি সমজিবার ছদগা, আর ছালামতি কুরবানির নিয়ম। ");
INSERT INTO syl_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","সিনাই মরুভুমিত মাবুদে যেদিন বনি ইছরাইলরে হুকুম দিছলা তান নামে কুরবানির জিনিস আনার লাগি, হউ দিন তাইন তুর পাহাড়র উপরে মুছা নবীরে অউ হক্কল নিয়ম-কানুন জানাইছলা। ");
INSERT INTO syl_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","বাদে মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“তুমি হারুন আর তার পুয়াইন্তরে লইয়া আমার গেছে আজির অও। এর লগে তারার ইমামতির লেবাছ, খেলাফতি সমজিবার তেল, গুনার কফরার কুরবানির বিছাল, দুগু মেড়ার পাঠা আর খামির ছাড়া রুটির টুকরিও আনিও। ");
INSERT INTO syl_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","আর তুমি তামাম বনি ইছরাইলরে মিলন-তাম্বুর দুয়ারর কান্দাত দলা করো।” ");
INSERT INTO syl_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","তেউ মাবুদর হুকুম মাফিক মুছা নবীয়ে হকলতা করলা, হকল বনি ইছরাইল মিলন-তাম্বুর দুয়ারর কান্দাত দলা অইলা। ");
INSERT INTO syl_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","অউ সময় মুছায় এরারে কইলা, “মাবুদে হুকুম দিছইন ইতা করার লাগি।” ");
INSERT INTO syl_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","অখান কইয়া তাইন ইমাম হারুন আর তান পুয়াইন্তরে ছামনে আনিয়া পানি দিয়া নাওয়াইলা। ");
INSERT INTO syl_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","বাদে তাইন হারুনরে ইমামতি লেবাছর পাইঞ্জাবি ফিন্দাইয়া হারি কমরর বন্দনি বান্দিয়া দিলা। তাইন আলখেল্লা আর এফ্রোন ফিন্দাইয়া পেটর উপরর নকশা করা কাপড়রে ফিতাদি বান্দি দিলা। ");
INSERT INTO syl_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","বাদে বুকুর উপরর থলি ফিন্দাইয়া এর ভিতরে পবিত্র উরিম আর তুম্মিম হারাইলা। ");
INSERT INTO syl_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","এরবাদে হারুনর মাথাত পাউগড়ি ফিন্দাইয়া হউ পবিত্র তাজ, মানি সোনার পাতখান পাউগড়ির ছামনাবায় লাগাইলা। মুছায় ই হকলতা করলা মাবুদর হুকুম মাফিক। ");
INSERT INTO syl_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","বাদে তাইন মিলন-তাম্বু আর এর ভিতরর হকল মাল-ছামানারে খেলাফতির তেল দিয়া পবিত্র করলা। ");
INSERT INTO syl_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","অউ তেল থাকি থুড়া তেল নিয়া তাইন কুরবানি খানার উপরে সাত বার ছিটাইলা। কুরবানি খানা আর এর লগর হকল মাল-ছামানা, হান্ডি-বাসন, আর অজুর পানির গামলা আর এর তলর চকি-খাটরে, তেল দিয়া পাক-পবিত্র করলা। ");
INSERT INTO syl_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","আরো থুড়া তেল নিয়া ইমাম হারুনর মাথার মাজে ঢালিয়া তানরে পাক-পবিত্র বনার লাগি খেলাফতি দিলা। ");
INSERT INTO syl_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","আর হারুনর পুয়াইন্তরে ছামনে আনিয়া তারার গতরো পাইঞ্জাবি ফিন্দাইলা, কমরর বন্দনি বান্দিয়া হারি মাথার তকি ফিন্দাইলা। ইতা হকলতা করলা তাইন মাবুদর হুকুম মাফিক। ");
INSERT INTO syl_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","এরবাদে তাইন গুনার কফরার কুরবানির বিছাল আনলা, আনলে হারুন আর তান পুয়াইন্তে বিছালর কল্লা আতাই দিলা। ");
INSERT INTO syl_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","তেউ মুছায় অউ বিছালরে জবো করিয়া অগুর কিছু লউ নিয়া, কুরবানি খানারে পাক-ছাফ করার খিয়ালে অখানর হিং অকলর মাজে আতর আংগুইলদি লউ মাখাইলা। বাকি লউ তাইন কুরবানি খানার তলে ঢালি দিলা। অউ নমুনায় তাইন গুনার কফরার কুরবানির লউ দিয়া কুরবানি খানারে পাক-ছাফ করলা। ");
INSERT INTO syl_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","বাদে তাইন বিছালর পেটর ভিতরর হকল চর্বি, কইলজার লগর মাটিয়া, চর্বি সমেত দুইও কিডনি নিয়া কুরবানি খানার উপরে জালাইলিলা। ");
INSERT INTO syl_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","অইলে বিছালর খাল, গোস্ত, গুফর নিয়া তাইন কেম্পর বারে জালাইলা। মুছায় ইতা হকলতা করলা মাবুদর হুকুম মাফিক। ");
INSERT INTO syl_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","বাদে তাইন জালাইল কুরবানির মেড়ার পাঠারে আনলা। আনলে হারুন আর তান পুয়াইন্তে অগুর কল্লা আতাই দিলা। ");
INSERT INTO syl_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","আর মুছায় অউ মেড়ারে জবো করিয়া কুরবানি খানার চাইরো গালাত লউ ছিটাই দিলা। ");
INSERT INTO syl_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","তাইন মেড়ারে টুকরাইয়া অগুর কল্লা, গোস্তর টুকরা আর চর্বিরে জালাইলা। ");
INSERT INTO syl_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","আর অউ মেড়ার পেটর ভিতরর হকলতা, তার চাইরো ঠেং পানি দিয়া ধইয়া হারি, আস্তা মেড়ারে জালাইল কুরবানি হিসাবে কুরবানি খানার উপরে জালাইলিলা। ইতা তো মাবুদর নামে আগুনিত দেওয়া জালাইল কুরবানি, ইতার ধুমার ঘেরানে তাইন খুশি অইন। মুছায় ইতা হকলতা করলা মাবুদর হুকুম মাফিক। ");
INSERT INTO syl_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","বাদে তাইন ইমামতি কামো বওয়ালর নিয়তে, দুছরা মেড়ারে আনিয়া হারলে হারুন আর তান পুয়াইন্তে মেড়ার কল্লা আতাই দিলা। ");
INSERT INTO syl_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","মুছায় অউ মেড়ারে জবো করিয়া, অগুর থুড়া লউ নিয়া হারুনর ডাইন কানর লতিত, ডাইন আতর আর ডাইন পাওর বুড়ি আংগুলিত লাগাইলা। ");
INSERT INTO syl_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","আর হারুনর পুয়াইন্তরেও ছামনে আনিয়া, তারার ডাইন কানর লতিত, আর ডাইন আত, ডাইন পাওর বুড়ি আংগুলিত থুড়া লউ লাগাই দিলা। আরো থুড়া লউ নিয়া কুরবানি খানার চাইরো গালাত ছিটাই দিলা। ");
INSERT INTO syl_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","তাইন মেড়ার চর্বি, চর্বি আলা লেংগুড়, কইলজার লগর মাটিয়া, চর্বি সমেত দুইও কিডনি, আর ডাইনর রান নিলা। ");
INSERT INTO syl_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","আর মাবুদর ছামনে থওয়া খামির ছাড়া রুটির টুকরি থাকি একখান রুটি, আর তেলদি ভাজা একখান পিঠা, আর তেল মাখাইল একখান রুটি নিয়া হউ চর্বি আর রানর উপরে থইলা। ");
INSERT INTO syl_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","থইয়া ইতা হকলতা হারুন আর তান পুয়াইন্তর আতো দিয়া দুলনা কুরবানি হিসাবে মাবুদর ছামনে দুলাইলা। ");
INSERT INTO syl_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","বাদে তাইন ইতা তারার আত থাকি নিয়া হারি কুরবানি খানার পশুর উপরে থইয়া জালাইলিলা। ইতা তো খেলাফতি সমজিবার কুরবানি, মাবুদর নামে আগুনিত দেওয়া কুরবানি, ইতার ধুমার ঘেরানে তাইন খুশি অইন। ");
INSERT INTO syl_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","বাদে তাইন নিজর পাওনা অংশ, মানি খেলাফতি সমজিবার কুরবানির মেড়ার ছিনা নিয়া দুলনা কুরবানি হিসাবে মাবুদর ছামনে দুলাইলা। তাইন ইতা হকলতা করলা মাবুদর হুকুম মাফিক। ");
INSERT INTO syl_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","বাদে মুছায় খেলাফতি সমজিবার থুড়া পবিত্র তেল নিলা, আর কুরবানি খানা থাকি থুড়া লউ আনিয়া হারুন আর তান পুয়াইন্তর উপরে আর তারার লেবাছর উপরে ছিটাই দিলা। অউ নমুনায় হারুন আর তান পুয়াইন্তরে, আর তারার লেবাছরেও পাক-পবিত্র করা অইলো। ");
INSERT INTO syl_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","বাদে মুছায় হারুন আর এন পুয়াইন্তরে কইলা, “তুমরা মিলন-তাম্বুর দুয়ারর ছামনে অউ গোস্ত রান্দো, রান্দিয়া হনো বইয়া খেলাফতি সমজিবার টুকরির রুটি দিয়া অতা খাও। আমারে তো আগে অউ কথা জানাইল অইছে, ইতা খালি তুমি আর তুমার পুয়াইন্তে খাইবায়। ");
INSERT INTO syl_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","খানির বাদে যেতা গোস্ত আর রুটি বাকি রইবো, ইতারে আগুইনদি জালাইলিও। ");
INSERT INTO syl_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","তুমরারে খেলাফতি সমজিবার অউ মাহফিল সাত দিন ধরি চলবো। ই সাত দিন তুমরা মিলন-তাম্বুর দুয়ারর কান্দা থাকি হরিও না। ");
INSERT INTO syl_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","আইজ যেতা করলাম, ইতা তো তুমরার গুনার কফরা হিসাবে মাবুদর হুকুম মাফিক করলাম। ");
INSERT INTO syl_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","তে তুমরা জানে বাচিয়া রওয়ার লাগি আইজ থাকি সাত দিন পর্যন্ত অউ মিলন-তাম্বুর দুয়ারর কান্দাত রইও। দিন-রাইত অনো রইয়া মাবুদর হুকুম মাফিক কাম করিও। তুমরা অলা করার লাগি তো আমি হুকুম পাইছি।” ");
INSERT INTO syl_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","মুছা নবীর মাজদি মাবুদে যততা করার হুকুম দিছলা, হারুন আর তান পুয়াইন্তে ইতা হকলতা করলা। ");
INSERT INTO syl_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","খেলাফতি সমজিবার মাহফিলর আট দিনর দিন মুছা নবীয়ে ইমাম হারুনরে, তান পুয়াইন্তরে আর বনি ইছরাইলর মুরব্বি অকলরেও আনাইলা। ");
INSERT INTO syl_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","আনাইয়া হারুনরে কইলা, “তুমার গুনার কফরার কুরবানির লাগি তুমি এগু বিছাল আনো, আর জালাইল কুরবানির লাগি এগু মেড়ার পাঠা লইয়া মাবুদর দরবারো আজির অও। কুরবানির পশু গুইন পুরাপুর নিখুত অইতো। ");
INSERT INTO syl_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","আর তুমি বনি ইছরাইলরে কও, তারা যানু মাবুদর নামর কুরবানি লইয়া আজির অয়। তারা গুনার কফরার লাগি এগু ছাগল, আর জালাইল কুরবানির লাগি এক বছর বয়সি নিখুত এগু গরু-বাছুর, আর এগু মেড়া-বাইচ্চা আনে, ");
INSERT INTO syl_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","আর ছালামতি কুরবানির লাগি এগু বিছাল আর এগু মেড়ার পাঠা লইয়া আজির অয়। ইতার লগে তারা তেল মাখাইল ধান-গমর ছদগাও আনবা। মাবুদে তারারে আইজ দিদার দিবা, এরলাগি তারা অতা লইয়া আজির অউক্কা।” ");
INSERT INTO syl_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","মুছা নবীর হুকুম মাফিক তারা হক্কলতা লইয়া মিলন-তাম্বুর ছামনে আইলা। হকল বনি ইছরাইল মাবুদর ছামনে আইয়া উবাইলা। ");
INSERT INTO syl_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","অউ সময় মুছায় তারারে কইলা, “মাবুদে তুমরারে ইতা করার লাগি হুকুম দিছইন, ইতা আদায় করলে তুমরার ছামনে তান কুদরতি নুর জাইর অইবো।” ");
INSERT INTO syl_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","বাদে তাইন ইমাম হারুনরে কইলা, “তুমি গিয়া কুরবানি খানার কান্দাত যাও, গিয়া তুমার নিজর আর মানষর গুনার কফরার লাগি, জালাইল কুরবানি আর গুনার কফরার কুরবানি আদায় করো। আর মানষর আনা কুরবানিও আদায় করো, মাবুদে আমারে অলা হুকুম দিছইন।” ");
INSERT INTO syl_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","তেউ ইমাম হারুন কুরবানি খানার কান্দাত গিয়া, তান নিজর গুনার কফরার কুরবানির বাছুর জবো করলা। ");
INSERT INTO syl_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","জবোর বাদে তান পুয়াইন্তে অগুর লউ লইয়া তান ধারো গেলা। তাইন অউ লউর মাজে আংগুল ডুবাইয়া থুড়া লউ নিয়া কুরবানি খানার হিং অকলো মাখাইলা, আর বাকি লউ কুরবানি খানার তলে ঢালিলা। ");
INSERT INTO syl_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","মাবুদে মুছারে যেলা হুকুম দিছলা, ইমাম হারুনে ঠিক অউ লাখান গুনার কফরার কুরবানির বাছুরর চর্বি, দুইও কিডনি আর কইলজার লগর মাটিয়ারে কুরবানি খানার উপরে নিয়া জালাইলিলা। ");
INSERT INTO syl_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","কুরবানির গোস্ত আর চামড়া নিয়া তাইন কেম্পর বারে জালাইলা। ");
INSERT INTO syl_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","বাদে ইমাম হারুনে জালাইল কুরবানির মেড়ারে জবো করলা। তান পুয়াইন্তে অগুর লউ নিয়া তান আতো দিলা, তাইন অউ লউরে কুরবানি খানার চাইরো গালাত ছিটাইলা। ");
INSERT INTO syl_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","তারা জালাইল কুরবানির মেড়ার কল্লা আর গোস্তর টুকরাইন এক এক করি হারুনর আতো দিলা, তাইন ইতা কুরবানি খানার উপরে জালাইলিলা। ");
INSERT INTO syl_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","মেড়ার ঠেং আর পেটর ভিতরর হকলতা পানি দিয়া ধইয়া ছাফ করিয়া, জালাইল কুরবানি পশুর লগে ইতা হক্কলতাও কুরবানি খানার উপরে জালাইলিলা। ");
INSERT INTO syl_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","বাদে তাইন সমাজর মানষর লাগি কুরবানির পশু অকল আনাইলা। তাইন মানষর গুনার কফরার কুরবানির ছাগল জবো করলা, আর আগর লাখান কুরবানি আদায় করলা। ");
INSERT INTO syl_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","এরবাদে তাইন তারার জালাইল কুরবানির পশুরেও মাবুদর হুকুম মাফিক কুরবানি দিলা। ");
INSERT INTO syl_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","আর ধান-গমর ছদগার লাগি আনা ছামানা থাকি এক মুইট নিয়া হারি কুরবানি খানার উপরে জালাইলা। ইতা ছাড়াও তাইন বিয়ানি বালার হামেশাকুর জালাইল কুরবানি আদায় করলা। ");
INSERT INTO syl_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","তাইন মানষর ছালামতি কুরবানির অউ গরু আর মেড়ারে জবো করলা। জবোর বাদে তান পুয়াইন্তে অগুর লউ আনিয়া তান আতো দিলা, লউ নিয়া তাইন কুরবানি খানার চাইরো গালাত ছিটাই দিলা। ");
INSERT INTO syl_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","আর ইমাম হারুনরে হউ গরু আর মেড়ার লগে লাগাইল হকল চর্বি, মানি চর্বি আলা লেংগুড়, পেটর ভিতরর হকলতার উপরর চর্বি, দুইও কিডনি আর অতার উপরর চর্বি, কইলজার লগর মাটিয়াও আনিয়া দিলা। ");
INSERT INTO syl_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","তারা অউ হকল চর্বিরে হউ পশুর ছিনার উপরে থইলা। আর ইমাম হারুনে অউ চর্বি নিয়া কুরবানি খানার উপরে জালাইলা। ");
INSERT INTO syl_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","মুছা নবীর হুকুম মাফিক হারুনে বাদে কুরবানির পশুর ছিনা আর ডাইনর রান নিয়া মাবুদর ছামনে দুলনা কুরবানি হিসাবে দুলাইলা। ");
INSERT INTO syl_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","বাদে ইমাম হারুনে মানষর বায়দি তান আত বাড়াইয়া তারারে দোয়া দিলা। তাইন গুনার কফরার কুরবানি, জালাইল কুরবানি আর ছালামতি কুরবানি আদায় করিয়া হারলে, কুরবানি খানা থাকি লামিয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","এরবাদে মুছা নবী আর ইমাম হারুন গিয়া মিলন-তাম্বুর ভিতরে হামাইলা, বাদে হন থাকি বার অইয়া আইয়া হকল মানষরে দোয়া দিলা। অউ সময় হকল মানষর ছামনে মাবুদে তান কুদরতি নুর জাইর করলা। ");
INSERT INTO syl_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","মাবুদর গেছ থাকি কুদরতি আগুইন আইয়া, কুরবানি খানার উপরর জালাইল কুরবানির পশু আর হক্কল চর্বিরে জালাইয়া ছালি করিলিলো। ইতা দেখিয়া হকল মানুষ খুশিয়ে ছুবহানাল্লা কইয়া চিক দিয়া সইজদাত পড়লা। ");
INSERT INTO syl_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","বাদে অলা অইলো, ইমাম হারুনর পুয়া নাদাব আর আবিহুয়ে তারার যারযির আগর-খুশবয় দানিত আগুইন জালাইলা, আর অউ আগুনির উপরে আগর-খুশবয় দিলা। তারা মাবুদর হুকুমর উল্টা গিয়া দুছরা আগুইন দিয়া মাবুদর নামে আগর-খুশবয় জালাইলা। ");
INSERT INTO syl_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","অতার লাগি মাবুদর গেছ থাকি আগুইন লামিয়া আইয়া তারারে জালাইলিলো, তারা মাবুদর ছামনে মরিগেলা। ");
INSERT INTO syl_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","তেউ মুছায় হারুনরে কইলা, “মাবুদে তো আগেউ জানাই দিছলা, আমার ছামনে যেরা আজির অয়, তারা আমারে পাক-পবিত্র কইয়া মানবো, হকল মানষর ছামনে আমার গৌরব-মহিমা জাইর করবো।” ইখান হুনিয়া হারুন চুপচাপ রইলা। ");
INSERT INTO syl_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","বাদে মুছায় হারুনর চাচা উজ্জলর পুয়াইন মিশায়েল আর এলজাফনরে খবর দিয়া আনাইলা, আনাইয়া কইলা, “তুমরা হেরেম শরিফর ছামন থাকি তুমরার দুইও ভাতিজার লাশরে বার করিয়া কেম্পর বারে নেও।” ");
INSERT INTO syl_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","তান হুকুম পাইয়া তারা গিয়া নাদাব আর আবিহুর লাশরে ইমামতি পাইঞ্জাবির কাপড়ো ধরি টানিয়া কেম্পর বারে নিলা। ");
INSERT INTO syl_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","বাদে ইমাম হারুন আর তান পুয়াইন আলি-আজর আর ইছামাররে মুছায় কইলা, “তারার মউতর দুখে তুমরা নিজর চুলরে আউলা-জাউলা করিও না, আর ফিন্নর কাপড়-চুপড় ফারিও না। ইতা করলে তুমরাও মরবায়, আর আস্তা সমাজর উপরে মাবুদর গজবি গুছা লামবো। অইলে মাবুদে যেরারে আগুইনদি জালাই মারছইন, তারার দুখে তুমরার কুটুম-খেশ মানি বাদ-বাকি বনি ইছরাইলে মাত্তম-আহাজারি করতা পারবা। ");
INSERT INTO syl_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","তুমরার গতরো তো মাবুদর নামর খেলাফতি সমজিবার পবিত্র তেল দেওয়া অইছে, এরলাগি তুমরা মিলন-তাম্বুর দুয়ারর বারে যাইও না, গেলেউ মরবায়।” তারাও মুছার কথা মানলা। ");
INSERT INTO syl_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","এরবাদে মাবুদে ইমাম হারুনরে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“তুমি আর তুমার পুয়াইন্তে আংগুরর শরবত বা শরাব খাইয়া মিলন-তাম্বুর ভিতরে হামাইও না, হামাইলেউ মরবায়। ই হুকুম ওয়ারিশর পর ওয়ারিশ ধরি হর-হামেশা মানিও। ");
INSERT INTO syl_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","কুনটা হারাম আর কুনটা হালাল, কুনটা পাক আর কুনটা নাপাক, ইতা বুজিয়া-হুনিয়া চলিও। ");
INSERT INTO syl_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","আর আমি মাবুদে মুছার মারফতে বনি ইছরাইলরে যত হুকুম-আহকাম বাতাইছি, ইতা তারারে তালিম দিও।” ");
INSERT INTO syl_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","বাদে হারুন আর তান বাকি দুইও পুয়া আলি-আজর আর ইছামাররে মুছায় কইলা, “মাবুদর নামে আগুনিত দেওয়া কুরবানির লগর ধান-গমর ছদগার যে অংশ বাকি রইছে, অতা দিয়া খামির ছাড়া রুটি বানাইয়া কুরবানি খানার কান্দাত নিয়া তুমরা খাইও। ইতা তো খাছ পবিত্র জিনিস। ");
INSERT INTO syl_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","তুমরা পবিত্র কাবা ঘরর সীমানার ভিতরে অতা খাইও। মাবুদর নামে আগুনিত দেওয়া কুরবানির অউ অংশ তো তুমার আর তুমার পুয়াইন্তর পাওনা। মাবুদে আমারে অলা হুকুম দিছইন। ");
INSERT INTO syl_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","অইলে মাবুদর নামে দুলনা কুরবানির ছিনা আর রানর গোস্ত তুমরা আর তুমরার পুয়া-পুড়িন্তেও খাইতায় পারবায়। যেকুনু পাক-ছাফ জাগাত বইয়া তুমরা ইতা খাইও। বনি ইছরাইলর হকল ছালামতি কুরবানির গোস্তর অউ অংশ তুমরারে আর তুমরার পুয়া-পুড়িন্তরে দেওয়া অইছে। ");
INSERT INTO syl_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","অউ কুরবানির পশুর চর্বি যেবলা আনা অইবো, অউ সময় দুলনা কুরবানির লাগি ছিনা আর রানর গোস্তও আনা লাগবো। মাবুদর হুকুম মাফিক অউ রান আর ছিনার গোস্ত তুমি আর তুমার পুয়া-পুড়িন্তর চিরকালিন পাওনা।” ");
INSERT INTO syl_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","বাদে মুছায় খুব খিয়ালি অইয়া তাল্লাশি করিয়া জানলা, যে ছাগল দিয়া গুনার কফরার কুরবানি আদায় করা অইছিল, অগুর হকল গোস্ত তারা জালাইলিছে। এরলাগি মুছায় হারুনর বাকি দুইও পুয়া আলি-আজর আর ইছামারর উপরে গুছা করিয়া কইলা, ");
INSERT INTO syl_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“গুনার কফরার কুরবানির গোস্ত তুমরা কাবা ঘরর সীমানাত খাইলায় না কেনে? ইতা তো খাছ পবিত্র জিনিস। মাবুদর ছামনে বনি ইছরাইলর গুনার কফরা আদায় করিয়া, তারার দুষ-কছুরি মাফির লাগি ইতা তো তুমরারে দেওয়া অইছিল। ");
INSERT INTO syl_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","কুরবানির ছাগলর লউ যেবলা হেরেম শরিফর ভিতরে নেওয়া অইছে না, তে আমার হুকুম মাফিক ইতার গোস্ত তো তুমরা কাবা ঘরর সীমানার ভিতরে খাওয়া জরুর আছিল।” ");
INSERT INTO syl_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","হারুনে জুয়াপ দিলা, “আইজ মাবুদর ছামনে তারার গুনার কফরার কুরবানি আর জালাইল কুরবানি আদায় করার বাদে আমার উপরেদি অততা ঘটিলো। তে আইজকুর দিনো আমি অউ কুরবানির গোস্ত খাইলে মাবুদ কুনু খুশি অইবা নি?” ");
INSERT INTO syl_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","ই জুয়াপ হুনিয়া মুছা নবী খুশি অইলা। ");
INSERT INTO syl_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","মাবুদে মুছা আর হারুনরে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“তুমরা বনি ইছরাইলরে জানাই দেও, মাটির উপরর পশুর মাজে যেতা পশু তুমরার লাগি হালাল, অতা অইলো: ");
INSERT INTO syl_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","“যেতা পশুর পাওর খুরা পুরাপুর চিরা, আর খানিরে পাজায়, ইতার গোস্ত তুমরার লাগি হালাল। ");
INSERT INTO syl_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","তা-ও এর মাজর কুনু কুনু পশুয়ে খালি খানিরে পাজায়, আর কুনু কুনু পশুর খালি খুরা চিরা, ইতা তো তুমরার লাগি হারাম। উটে খানিরে পাজাইলেও তার খুরা চিরা নায়, এরলাগি উট হারাম। ");
INSERT INTO syl_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","শাফন-উন্দুরে খানিরে পাজাইলেও, ইতার খুরা চিরা নায়, অতার লাগি ইতাও হারাম। ");
INSERT INTO syl_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","খরগুশেও খানিরে পাজায়, অইলে ইতার খুরা চিরা নায়, অতার লাগি হারাম। ");
INSERT INTO syl_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","শুয়রর খুরা পুরাপুর চিরা, অইলে ইতায় খানিরে পাজায় না, এরলাগি ইতা তুমরার লাগি হারাম। ");
INSERT INTO syl_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","ইতার গোস্ত তুমরার লাগি হারাম, ইতার মরা লাশরেও ছইও না। ইতা তুমরার লাগি নাপাক। ");
INSERT INTO syl_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“পানির মাজে যেতা জানদারে বসত করইন, ইতার মাজে যেতার ফইর আর ডাখনা আছে, ইতা তুমরার লাগি হালাল। ");
INSERT INTO syl_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","অইলে যেতার ফইর আর ডাখনা নাই, ইতা তুমরার লাগি নাজাইজ। ইতা পানির মাজে পাল বান্দিয়া ঘুররা জানদার অউক বা আরো কুনু জানদার অউক, ইতারে তুমরা ঘিন্নাইও। ");
INSERT INTO syl_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","নাজাইজ অওয়ায় ইতারে হারাম মনো করিও, ইতা তুমরা খাইও না। ইতার মরা লাশরেও তুমরা ঘিন্নাইও। ");
INSERT INTO syl_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","পানির মাজে বসত করে, অইলে কুনু ফইর বা ডাখনা নাই, ইলাখান হকল জানদাররে তুমরা ঘিন্নাইও। ");
INSERT INTO syl_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“আর পাখি অকলর মাজর অউ লাখান পাখিরে তুমরা ঘিন্নাইও, ইতা তুমরা খাইও না। অতা অইলা, বড় চিল, হকুন, হাফ-খাউরি, ");
INSERT INTO syl_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","হকল জাতর চিল, হকল জাত কাউয়া, ");
INSERT INTO syl_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","উট পাখি, ");
INSERT INTO syl_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","নিম পাখি, গাংচিল, হকল নমুনার বাজ পাখি, ");
INSERT INTO syl_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","হকল জাত পেচা, হকল জাতর কুড়া, ছলা-কাক, বলুয়া পাখি, ");
INSERT INTO syl_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","পানি-খাউরি, ");
INSERT INTO syl_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","হকল জাতর জাটিয়া, হকল জাতর বগলা, মন-চুরা পাখি আর বাদুর, ইতা তুমরার লাগি হারাম। ");
INSERT INTO syl_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“পুক-ফরিং অকলর মাজে অউ লাখান পুক-ফরিং তুমরার লাগি নাজাইজ, যেতায় পাওদি আটে আর উড়াল দেয়, ইতারে তুমরা ঘিন্নাইও। ");
INSERT INTO syl_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","অইলে ইতার মাজর যেতার আটু আছে, আর মাটির উপরে ফালাই ফালাই চলে, ইতার মাজর কুনু কুনুটা তুমরার লাগি হালাল। ");
INSERT INTO syl_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","ইতা অইলো, হকল জাতর পংগপাল, বাঘা-ফরিং, ঘাস-ফরিং। ");
INSERT INTO syl_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","অইলে ইতা ছাড়া বাদ-বাকি যত পুক-ফরিংয়ে চাইর পাওয়ে আটে আর উড়িতো পারে, ইতা হকলতা তুমরা ঘিন্নাইও। ");
INSERT INTO syl_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“তুমরা অউ লাখান কাম করলে নাপাক অইযিবায়; কুনু মানষে যুদি অউ হারাম পশু, পাখি, মাছ, পুক-ফরিং অতার মরা লাশ ছইলায়, তে হে হাইঞ্জা পর্যন্ত নাপাক রইবো। ");
INSERT INTO syl_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","আর কেউ যুদি অতা হারাম জিনিসর লাশর কুনু অংশরে আতদি ধরিয়া বইয়া নেয়, তে হে তার কাপড়-চুপড় ধইয়া দিতে অইবো, আর হাইঞ্জা পর্যন্ত নাপাক রইবো। ");
INSERT INTO syl_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“আর যেতা পশুর পাওর খুরা পুরাপুর চিরা নায়, বা যে পশুয়ে খানিরে পাজায় না, ইতা তো তুমরার লাগি হারাম। অউ হারাম পশুরে যে জনে ছইবো, হে নাপাক বনিযিবো। ");
INSERT INTO syl_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","চাইর পাওয়ে আটরা জানুয়ার অকলর মাজে, যে পশুয়ে পাওর তালুত ভর দিয়া আটে, ইতাও তুমরার লাগি হারাম। কেউ যুদি ইতার মরা লাশ ছইলায়, তে হাইঞ্জা পর্যন্ত নাপাক রইবো। ");
INSERT INTO syl_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","আর কুনু মানষে যুদি ইতার লাশ আতদি ধরিয়া বইয়া নেয়, তে তার কাপড়-চুপড় ধইয়া দিতে অইবো, আর হাইঞ্জা পর্যন্ত হে নাপাক রইবো। ইতা জানুয়ার অকল তো তুমরার লাগি হারাম। ");
INSERT INTO syl_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“আর মাটিত চলরা হুরু-মুরু জানদারর মাজে নেউল, উন্দুর, হকল জাতর গিরগিটি, ");
INSERT INTO syl_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","টিকটিকি, গুইল-হাফ, মই-হাফ, আইঞ্জাইল আর কাকলাস, তুমরার লাগি হারাম। ");
INSERT INTO syl_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","মাটিত চলরা হুরু-মুরু জানদারর মাজর অউ জাতর জানদার তো তুমরার লাগি নাজাইজ। ইতার মরা লাশ কেউ ছইলে, হে হাইঞ্জা পর্যন্ত নাপাক রইবো। ");
INSERT INTO syl_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","অতার মাজর যেকুনু এগুর মরা লাশ যুদি অইন্য জিনিসর উপরে পড়ে, যেলান লাকড়ি, কাপড়-চুপড়, চামড়া বা ছলার চট দিয়া বানাইল যেকুনু মালর উপরে পড়লেউ ইতা নাপাক অইযিবো। নাপাক মালরে পানিত ভিজাইয়া থইবায়। হাইঞ্জা পর্যন্ত ইতা নাপাক রইবো, বাদে পাক-ছাফ অইবো। ");
INSERT INTO syl_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","আর অউ নাপাক জানদারর কুনুটার মরা লাশ যুদি কুনু মাটির বাসনর মাজে পড়ে, তে ইগুর ভিতরর হকলতা নাপাক অইযিবো, ই বাসনরেও ভাংগিলিবায়। ");
INSERT INTO syl_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","অউ বাসনর পানি বা রস যুদি কুনু খানির জিনিসর উপরে পড়ে, তে ই খানি নাপাক অইযিবো। ইকটার মাজে যুদি পানি জাতিয় কুনুতা থওয়া থাকে, তে ইতাও নাপাক অইযিবো। ");
INSERT INTO syl_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","আর অতার মরা লাশ যুদি কুনু জিনিসর উপরে পড়ে, তে ইতা নাপাক অইযিবো। ইতা কুনু উন্দালো পড়লে, ই উন্দাল ভাংগিলিবায়। ই উন্দাল তো তুমরার লাগি নাপাক, ইতারে নাপাক গইন্য করিও। ");
INSERT INTO syl_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","অইলে ইতা যুদি কুনু কুয়ার ভিতরে বা ইন্দারার মাজে পড়ে, তে ই কুয়া বা ইন্দারা নাপাক অইতো নায়। খালি ইতার মরা লাশ যে জনে ছইবো, হে নাপাক অইযিবো। ");
INSERT INTO syl_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","জমিনো বাইন দিবার নিয়তে থওয়া কুনুজাতর বিচর উপরে যুদি অতার লাশ পড়ে, তে ইতা নাপাক অইতো নায়। ");
INSERT INTO syl_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","অইলে কুনু বিচর উপরে পানি দিয়া ভিজানির বাদে যুদি ইতা পড়ে, তে ই বিচ তুমরার লাগি নাপাক। ");
INSERT INTO syl_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“তুমরার হালাল কুনু পশু মরিগেলে, ইগুর লাশ যে জনে ছইবো, হে হাইঞ্জা পর্যন্ত নাপাক রইবো। ");
INSERT INTO syl_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","কেউ যুদি অউ মরা পশুর গোস্ত খায়, তে হে তার কাপড়-চুপড় ধইয়া দিতে অইবো, আর হে হাইঞ্জা পর্যন্ত নাপাক রইবো। আর কেউ যুদি অউ পশুর লাশরে আত দিয়া তুলে, তে হে তার কাপড়-চুপড় ধইয়া দিতে অইবো, হে-ও হাইঞ্জা পর্যন্ত নাপাক রইবো। ");
INSERT INTO syl_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“হুনো, মাটির মাজে চলরা হকল জাতর হুরু-মুরু জানদার খাওয়া তুমরার লাগি হারাম, ইতারে তুমরা ঘিন্নাইও। ");
INSERT INTO syl_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","ইতা বুকে চলরা জানদার অউক, বা চাইর পাওয়ে আটরা জানদার বা বউত পাওয়ে চলরা অউক, হকল নমুনার মাটিত চলরা হুরু-মুরু জানদার তুমরা খাইও না, ইতারে ঘিন্নাইও। ");
INSERT INTO syl_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","তুমরা ইতা কুনুতার লাগি নিজরে ঘিন্নার জন বানাইও না, বা অতায়ও যানু তুমরারে নাপাক না বানায়। ");
INSERT INTO syl_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","মনো রাখিও, আমি আল্লাউ তুমরার মাবুদ। আমার নিয়তে তুমরা নিজরে পাক-পবিত্র রাখিও। জানো তো, আমি নিজেও পবিত্র। এরলাগি মাটিত চলরা কুনু হুরু-মুরু জানদারর লাগি তুমরা নিজরে নাপাক বানাইও না। ");
INSERT INTO syl_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","আমি তো আল্লা, আমি তুমরার মাবুদ অওয়ার খিয়ালে, মিসর দেশ থাকি তুমরারে বার করি আনছি। আমি নিজে পবিত্র, এরলাগি তুমরাও পবিত্র রইও। ");
INSERT INTO syl_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“তে পশু, পাখি, পানিত বসত কররা জানদার, আর মাটির মাজে চলরা হকল নমুনার হুরু-মুরু জানদারর বেয়াপারে তুমরা আমার হুকুম-আহকাম মানিও। ");
INSERT INTO syl_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","কুনটা তুমরার লাগি জাইজ আর কুনটা নাজাইজ, কুন পশুর গোস্ত হালাল আর কুনটা হারাম, ইতা তুমরা বুজিয়া-হুনিয়া চলিও।” ");
INSERT INTO syl_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","এরবাদে মাবুদে মুছা নবীরে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“তুমি বনি ইছরাইলরে জানাই দেও, কুনু বেটির ঘরো যুদি কুনু পুয়ার জনম অয়, তে বেটিয়ারা বেমারর সময়কুর লাখান ই বেটি নাপাক রইবো। তাইর অউ নাপাকি হালত সাত দিন রইবো। ");
INSERT INTO syl_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","বাদে আট দিনর দিন পুয়ারে মছলমানি কাম করাইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","আর অউ বেটির হুরুতা জনমর লউ যাওয়ার কারনে তেত্রিশ দিন পর্যন্ত নাপাক রইবো। অউ মিয়াদ না পুরা পর্যন্ত তাই কুনু পবিত্র জিনিসো ধরা-ছোয়া জাইজ নায়। আর পবিত্র কাবা ঘরর সীমানাত যাইবার হুকুম নায়। ");
INSERT INTO syl_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","অইলে ই বেটির ঘরো যুদি পুড়ির জনম অয়, তে বেটিয়ারা মাসিক বেমারর লাখান তাই নাপাক রইবো, তা-ও ই নাপাকি হালত পুরা দুই হাপ্তা চলবো। বাদে অউ বেমার থাকি পাক-পাকিজা অওয়ার লাগি আরো ছয়ষট্টি দিন বার চাইবো। ");
INSERT INTO syl_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“পুয়া বা পুড়ির জন্মর বাদে পাক-পাকিজা অওয়ার সময় আইলে, বেটিয়ে কুরবানি আদায় করার নিয়তে মিলন-তাম্বুর দুয়ারর কান্দাত ইমাম ছাবর গেছে যাইবো। যাইতে জালাইল কুরবানির লাগি এক বছর বয়সি এগু মেড়া, আর গুনার কফরার কুরবানির লাগি এগু পারো বা ডুপি পাখি লগে নিবো। ");
INSERT INTO syl_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","তেউ ইমাম ছাবে মাবুদর ছামনে অউ কফরা আদায় করিয়া লউ যাওয়া বেমার থাকি বেটিরে পাক-পাকিজা করবা। বেটিন্তর ঘরো পুয়া বা পুড়ির জন্মর বাদে পাক-পাকিজা অওয়ার লাগি অউ নিয়ম জারি রইলো। ");
INSERT INTO syl_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","আর কুরবানির লাগি মেড়া আনার তৌফিক যুদি না থাকে, তে দুগু পারো বা ডুপি পাখি আনবো। এরমাজর এগু অইবো জালাইল কুরবানি, আর দুছরাটা গুনার কফরার কুরবানি। অউ নমুনায় ইমাম ছাবে কুরবানি আদায় করিয়া তাইরে নাপাকি থাকি বাচাইবা, তেউ ই বেটি পাক-পাকিজা বনবো। ");
INSERT INTO syl_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","বাদে মাবুদে মুছা আর হারুনরে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“কুনু মানষর গতরর চামড়ার কুনু জাগা যুদি আখতা ফুলি যায়, বা কুনু কুলশ উঠে বা কুনুজাত দাগ দেখা যায়, আর মনো সন্দয় অয় যেন, ইতা বাদে পচা-কুষ্ঠ বেমার অইতো পারে, তে ইমাম হারুন বা তান পুয়াইন্তর মাজর কুনু ইমামর গেছে তারে লইয়া যাইবায়। ");
INSERT INTO syl_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","ইমাম ছাবে তার চামড়ার অউ জাগা দেখবা, হি জাগার রুমা যুদি ধলা অইযায়, আর বুজা যায় ই বেমার চামড়ার তলর গোস্তর মাজে লাগিগেছে, তে বুজবায়, ইতা নাপাক পচা-কুষ্ঠ বেমার। ইলা বেমারি দেখলে ইমামে তারে নাপাক কইয়া এলান করবা। ");
INSERT INTO syl_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","অইলে তার চামড়ার মাজে অউ দাগ যুদি খালি ধলা অয়, আর ইতা চামড়ার তলর গোস্তর মাজে না লাগে, অনর রুমা ধলা না অয়, তে ইমাম ছাবে অউ জনরে সাত দিন ধরি হকল মানষর গেছ থাকি হরাই রাখবা। ");
INSERT INTO syl_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","বাদে সাত দিনর দিন তারে হিরবার দেখবা। যুদি দেখা যায়, অউ বেমার চামড়ার তলেদি না গিয়া যেলা আছিল অলা রইছে, তে ইমামে তারে আরো সাত দিন আলগা রাখবা। ");
INSERT INTO syl_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","আর হিরবার সাত দিনর দিন তারে দেখবা, এরমাজে যুদি তার বেমার না বাড়িয়া হুকাইয়া কমি যায়, তে বুজবা, ইতা খালি কুলশ উঠছে। ইমামে তারে পাক-ছাফ কইয়া এলান করবা। হে তার কাপড়-চুপড় ধইয়া হারি পাক-ছাফ বনবো। ");
INSERT INTO syl_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","অইলে ইমামে তারে পাক-ছাফ কইয়া এলান করার বাদে যুদি তার গতরর কুলশ আরো বাড়ি যায়, তে তারে হিরবার ইমামর গেছে দেখাইবায়। ");
INSERT INTO syl_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","ইমামে হিরবার দেখবা, যুদি অউ বেমার চামড়ার উপরে আরো বাড়ি যায়, তে বুজা যাইবো, ইতা নাপাক পচা-কুষ্ঠ বেমার, তাইন এরে নাপাক কইয়া এলান করবা। ");
INSERT INTO syl_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“কুনু মানষর চামড়াত পচা-কুষ্ঠ বেমারর লাখান দেখা গেলে তারে নিয়া ইমাম ছাবর গেছে দেখাইবায়। ");
INSERT INTO syl_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","ইমামে দেখবা, তার গতরো কুনু জাগার চামড়ার উপরে যুদি ধলা অইয়া ফুলি যায়, আর হনর রুমা ধলা অইযায়, অউ ফুলা জাগাত কাচা ঘা থাকে, ");
INSERT INTO syl_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","তে তো ইটা একটা পুরানা পচা-কুষ্ঠ বেমার। ইমামে তারে নাপাক কইয়া এলান করবা। তারে পরিক্ষার লাগি সমাজর মানষর গেছ থাকি কুনু মিয়াদে দুরই রাখার জরুর নায়, হে তো এমনেউ নাপাক হালতে আছে। ");
INSERT INTO syl_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“অইলে ই বেমার যুদি আস্তা শরিলো অইযায়, আর ইমামে শরিলর যত জাগা দেখতা পারইন, অতা দেখিয়া যুদি তান মনো অয়, ই বেমার মাথা থাকি পাও পর্যন্ত আছে, ");
INSERT INTO syl_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","তে তারে আরো ভালামন্তে দেখবা, আর দেখিয়া যুদি বুজা যায়, ই বেমারে তার আস্তা গতর ধলা অইগেছে, তে তারে পাক-ছাফ কইয়া এলান করবা। তার আস্তা গতর ধলা অওয়ায় হে নাপাক নায়। ");
INSERT INTO syl_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","অইলে এরবাদে যুদি কুনু কাচা ঘা দেখা দেয়, তে হে নাপাক। ");
INSERT INTO syl_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","ইমামে অউ ঘা দেখিয়া তারে নাপাক কইয়া এলান করবা। অউ ঘা তো নাপাক, তার নাপাক পচা-কুষ্ঠ বেমার অইছে। ");
INSERT INTO syl_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","বাদে অউ কাচা ঘা হুকাইয়া যুদি ধলা অইযায়, তে তারে হিরবার ইমামর গেছে নিবা। ");
INSERT INTO syl_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","ইমামে তারে হিরবার দেখবা, তার আস্তা গতরর বেমার যুদি পুরাপুর ধলা অইযায়, তে ইমামে তারে পাক-ছাফ কইয়া এলান করবা, হে আসলেউ পাক-ছাফ। ");
INSERT INTO syl_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“কুনু মানষর গতরো যুদি বরন অইয়া ইটা ভালা অইযায়, ");
INSERT INTO syl_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","আর অউ জাগা বাদে ধলা অইয়া ফুলি যায়, বা লালটি-ধলা দাগ অয়, তে তারে ইমামর গেছে নিবা। ");
INSERT INTO syl_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","ইমামে তারে দেখবা, হি বেমার যুদি চামড়ার তলে গিয়া গোস্তর মাজে লাগি যায়, রুমা ধলা অইযায়, তে ইটা তো বরনর জাগাত জনম লওয়া পচা-কুষ্ঠ বেমার, ইমামে তারে নাপাক কইয়া এলান করবা। ");
INSERT INTO syl_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","অইলে ইমামে কুনু ধলা রুমা না দেখলে, আর অউ ঘা যুদি চামড়ার তলে না গিয়া হুকাইযিবার লাখান অয়, তে ইমামে তারে সাত দিন পর্যন্ত সমাজ থাকি আলগ রাখবা। ");
INSERT INTO syl_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","বাদে যুদি দেখা যায়, ইতা চামড়ার উপরে ছিতরি যার, তে ইমামে তারে নাপাক কইয়া এলান করবা, ইতা এক লাখান পচা-কুষ্ঠ বেমার। ");
INSERT INTO syl_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","অইলে কুনু লাখান কম-বেশি না অইলে, না ছিতরিলে বুজা যাইবো ইতা খালি বরনর দাগ, ইমামে তারে পাক-ছাফ কইয়া এলান করবা। ");
INSERT INTO syl_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“কুনু মানষর গতরর কুনু অংশ যুদি আগুইনে জলি যায়, আর অউ জলার জাগাত কাচা ঘার মাজে লালটি বা ধলা দাগ দেখা দেয়, ");
INSERT INTO syl_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","তে ইমামে তারে পরিক্ষা করি দেখবা। আর যুদি দেখা যায়, রুমা ধলা অইগেছে, অউ ঘা চামড়ার তলে গিয়া গোস্তর মাজে লাগিগেছে, তে ইটা তো জালাইল জাগাত জনম লওয়া পচা-কুষ্ঠ বেমার অইয়া বার অইছে। ইতা তো নাপাক পচা-কুষ্ঠ বেমার, এরলাগি ইমামে তারে নাপাক কইয়া এলান করবা। ");
INSERT INTO syl_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","অইলে ইমামে পরিক্ষা করিয়া যুদি দেখইন, ই জাগার রুমা ধলা অইছে না, আর ঘা ছিতরিয়া গিয়া গোস্তর মাজে না লাগিয়া মিলি যার, তে ইমামে তারে সাত দিন পর্যন্ত সমাজ থাকি আলগ রাখবা। ");
INSERT INTO syl_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","বাদে ইমামে সাত দিনর দিন তারে হিরবার দেখবা, যুদি দেখইন, অউ বেমার বাড়ি যার, তে ইমামে তারে নাপাক কইয়া এলান করবা। ইতা এক লাখান নাপাক পচা-কুষ্ঠ বেমার। ");
INSERT INTO syl_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","অইলে ই জাগা যুদি কুনু কম-বেশ না অইয়া যেলা আছিল অলা থাকে, আর চামড়ার মাজে না ছিতরিয়া মিলি যাওয়াত রয়, তে ইতা আগুইনে জলার ফুলা কইয়া ধরা অইবো। ইতা তো এক লাখান জলার দাগ, আর ইমামে তারে পাক-ছাফ কইয়া এলান করবা। ");
INSERT INTO syl_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“আর কুনু বেটা বা বেটির মাথা বা দাড়ি-মুছর মাজে যুদি কুনু ঘার আলামত দেখা দেয়, ");
INSERT INTO syl_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","তে ইমাম ছাবে তারে পরিক্ষা করি দেখবা। তাইন যুদি দেখইন, বেমারি জাগার চুল বা রুম অলদিয়া অইয়া চিকন অইগেছে, আর ঘা চামড়ার তলে গিয়া গোস্তর মাজে লাগিগেছে, তে ইটা তো এক লাখান দাউদ-খাউজলির মুখ, ইতা দাড়ি-মুছ বা মাথার চামড়াত পচা-কুষ্ঠ বেমার বার অইছে। এরলাগি ইমামে তারে নাপাক কইয়া এলান করবা। ");
INSERT INTO syl_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","অইলে ইমামে যুদি বেমার পরিক্ষা করিয়া দেখইন, ই ঘা চামড়ার তলে গেছে না, আর অনর চুল বা রুম তো কালা নায়, তে অউ বেমারিরে সাত দিন পর্যন্ত সমাজ থাকি আলগ রাখবা। ");
INSERT INTO syl_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","বাদে সাত দিনর দিন ইমামে হিরবার পরিক্ষা করি যুদি দেখইন, ই দাউদ-খাউজলি বেমার বাড়ছে না, বা চুল-রুমও অলদিয়া অইছে না, আর অনর ঘা চামড়ার তলর গোস্তর মাজে লাগছে না, ");
INSERT INTO syl_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","তে অউ দাউদ-খাউজলির জাগা বাদ দিয়া, তার শরিলর বাদ-বাকি চুল বা দাড়ি-মুছ কামাইলিতে অইবো। বাদে ইমামে তারে আরো সাত দিন সমাজ থাকি আলগ রাখবা। ");
INSERT INTO syl_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","আর সাত দিনর দিন ইমামে হিরবার পরিক্ষা করিয়া যুদি দেখইন, ই দাউদ-খাউজলি চামড়ার উপরে ছিতরিছে না, বা চামড়ার তলেদি গোস্তর মাজেও লাগছে না, তে ইমামে তারে পাক-ছাফ কইয়া এলান করবা। আর হে কাপড়-চুপড় ধইয়া হারি পাক-পাকিজা বনবো। ");
INSERT INTO syl_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","তা-ও ইমামে তারে পাক-ছাফ কইয়া এলান করার বাদেও যুদি ই দাউদ-খাউজলি চামড়ার উপরে ছিতরি যায়, ");
INSERT INTO syl_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","তে ইমামে তারে হিরবার দেখবা। তাইন যুদি দেখইন, ই দাউদ-খাউজলি ছিতরি গেছে, তে চুল বা রুম অলদিয়া অইছে কি না ইতা আর পরিক্ষা করার জরুর নায়, হে তো এমনেউ নাপাক। ");
INSERT INTO syl_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","অইলে ইমামে যুদি মনো করইন, ইতা যেলা আছিল অলাউ রইছে, আর ই জাগাত কালা রুমা উঠের, তে বুজবা, ইতা ভালা অইগেছে। হে তো পাক-পাকিজা আছে। ইমামে তারে পাক-ছাফ কইয়া এলান করবা। ");
INSERT INTO syl_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“কুনু বেটা বা বেটির চামড়ার মাজে যুদি ধলা চকচকা দাগ দেখা যায়, ");
INSERT INTO syl_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","তে ইমামে তারে পরিক্ষা করি দেখবা। তাইন যুদি দেখইন, তার দাগ ধলা ফাইনশা অইগেছে, তে ইটা তো খালি ধল-ফিস্তি অইছে। ইতায় কুনু খেতি অইতো নায়, হে তো পাক-ছাফ আছে। ");
INSERT INTO syl_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“আর কুনু মানষর যুদি মাথার চুল পড়িয়া টাক অইযায়, তে হে নাপাক অইতো নায়। ");
INSERT INTO syl_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","তার মাথার ছামনর গালার চুল পড়িয়া যুদি কপালর বায় টাক পড়ি যায়, তে হে-ও নাপাক অইতো নায়। ");
INSERT INTO syl_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","অইলে ই টাক পড়া মাথা বা কপালর মাজে যুদি লালটি দাগ দেখা দেয়, তে বুজবায়, তার মাথা বা কপালো পচা-কুষ্ঠ বেমার বার অইছে। ");
INSERT INTO syl_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","আর ইমাম ছাবে তারে পরিক্ষা করিয়া যুদি দেখইন, তার কপালো বা মাথাত নাপাক পচা-কুষ্ঠ বেমারির লাখান হউ দাগ তো ফুলি গেছে, ");
INSERT INTO syl_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","তে বুজা যাইবো, তার নাপাক পচা-কুষ্ঠ বেমার অইছে, হে তো নাপাক। তার মাথার অউ বেমারর লাগি ইমামে তারে নাপাক কইয়া এলান করবা। ");
INSERT INTO syl_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“আর অউ লাখান পচা-কুষ্ঠ বেমার যে মানষর অইবো, হে ফারা-চিরা কাপড় ফিন্দিতে অইবো। তার মাথার চুল আউলা-জাউলা রইবো। তার মুখরে হিজাবর লাখান কাপড়দি গুরিয়া চিল্লাই চিল্লাই কইবো, নাপাক, নাপাক। ");
INSERT INTO syl_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","ই বেমার তার গতরো যতদিন রইবো, অতদিন হে নাপাক হালতে রইবো। হে বনি ইছরাইলর কেম্পর বারে একলা একলা রইবো। ");
INSERT INTO syl_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“কুনু কাপড়র মাজে যুদি ছাবা ছাবা দাগ লাগে, উলর কাপড় বা সুতি কাপড়র মাজে যুদি ফেউকনি পড়ার আলামত মিলে, ");
INSERT INTO syl_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ইতা উলর কাপড় বা সুতি কাপড় বানানির টানা বা তাতর মাজে অউক, বা চামড়া আর চামড়াদি বানাইল যেকুনু জিনিসর মাজে যুদি ফেউকনির দাগ মিলে, ");
INSERT INTO syl_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","আর ফিন্নর কাপড়র টানা বা তাতর মাজে, চামড়ার কুনু জিনিসো যুদি লালটি বা কচুয়া কুনুজাত দাগ মিলে, তে ইতা অইলো ফেউকনির আলামত। ইলা অইলে ইমাম ছাবর গেছে দেখানি লাগবো। ");
INSERT INTO syl_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","ইমাম ছাবে ইতা ভালামন্তে পরিক্ষা করি দেখিয়া, অউ জিনিসরে সাত দিন হকলতা থাকি হরাইয়া রাখবা। ");
INSERT INTO syl_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","বাদে সাত দিনর দিন ইমামে হিরবার দেখবা। তাইন যুদি দেখইন, অউ কাপড়র টানাত বা তাতো, বা চামড়ার জিনিসো লালটি বা কচুয়া দাগ বাড়িছে, তে হউ ফেউকনি বেমার বড় মারাত্মক, অউ জিনিস তো নাপাক। ");
INSERT INTO syl_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","এরলাগি ই কাপড়, বা চামড়ার অউ জিনিস, গামছা বা উড়না যেতার মাজে ইলা ফেউকনির দাগ মিলবো, ইতা হাছরিবো করি হকলতা জালাইলিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“অইলে ইমামে যুদি দেখইন, ই কাপড় বা চামড়ার জিনিসর দাগ না ছিতরিয়া একই জাগাত রইছে, ");
INSERT INTO syl_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","তে তাইন ইতারে পানিদি ধইয়া দিবার হুকুম দিবা। ধইয়া হারি অউ জিনিসরে সাত দিন দুছরা হকলতা থাকি হরাই রাখবা। ");
INSERT INTO syl_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","বাদে ইমামে হিরবার দেখবা। তাইন যুদি দেখইন, ই ফেউকনির দাগ কুনুবায় না ছিতরিলেও আগর লাখান রং রইছে, তে ইতা নাপাক। ইগুর উল্টা-ভাটিয়ল যেকুনু গালাবায় ই দাগ রউক, ইগুরে আগুইনদি জালাইলিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","অইলে ইতা ধইয়া দেওয়ার বাদে যুদি ইমামে দেখইন, ই জাগার রং ফাইনশা অইগেছে, তে অউ জাগা ছিড়িয়া ফালাই দিবায়। ");
INSERT INTO syl_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","আর ধওয়ার বাদেও যুদি অউ জিনিসো হিরবার ফেউকনির দাগ দেখা যায়, তে বুজবায়, ইতা ছিতরি যাওয়া বেমার, এরলাগি ই জিনিসরে আগুইনদি জালাইলিবায়। ");
INSERT INTO syl_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","আর অউ জিনিস ধওয়ার বাদে যুদি দেখইন, অউ দাগ মিলাইগেছে, তে ইতা হিরবার ধইয়া হারলে পাক-ছাফ বুজবায়। ");
INSERT INTO syl_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","“অউ নিয়ম-কানুন মানিয়া উলর কাপড়, সুতি কাপড় বা চামড়ার কুনু জিনিসো ফেউকনির দাগ লাগলে, পাক বা নাপাক কইয়া এলান করবায়।” ");
INSERT INTO syl_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","বাদে মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“পচা-কুষ্ঠ বেমারিরে পাক-ছাফ করার দিন অউ নিয়ম মানিও। ইমাম ছাবে তারে দেখার লাগি, ");
INSERT INTO syl_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","কেম্পর বারে গিয়া পরিক্ষা করিয়া দেখবা। তাইন যুদি দেখইন হে হাছাউ ভালা অইগেছে, ");
INSERT INTO syl_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","তে ইমামে হুকুম দিবা, পাক-ছাফ অওয়া জনর নিয়তে জিতা দুইটা হালাল পাখি, দেবদারু গাছর কিছু লাকড়ি, এছুব গাছর ডেটা আর লাল সুতা লইয়া আইতা। ");
INSERT INTO syl_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","বাদে ইমামে হুকুম দিবা, ফুতর পানি থাকি পানি আনিয়া মাটির গামলাত থওয়া পানির উপরে, হউ দুইও পাখির মাজর একটারে জবো করার লাগি। ");
INSERT INTO syl_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","জবোর বাদে ইমামে বাকি হউ জিতা পাখিরে, দেবদারু গাছর লাকড়িরে, লাল সুতারে আর এছুব গাছর ডেটারে, ফুতর পানির গামলার উপরে জবো করা হউ পাখির লউর মাজে ছুবাইবা। ");
INSERT INTO syl_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","আর অউ যে বেমারিরে পাক-ছাফ করা অইতো, ইমামে তার উপরে হউ লউ সাত বার ছিটাইয়া হারি, তারে পাক-ছাফ কইয়া এলান করবা। বাদে ইমামে হউ জিতা পাখিরে খুলা জাগাত ছাড়ি দিবা। ");
INSERT INTO syl_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","আর পাক-ছাফ বনরা অউ বেমারিয়ে তার কাপড়-চুপড় ধইবো, তার গতরর আর মাথার হকল চুল-রুম কামাইয়া হারি পানি দিয়া নাইতে অইবো, তেউ হে পাক-ছাফ বনবো। এরবাদে হে আইয়া বনি ইছরাইলর কেম্পর ভিতরে হামাইতো পারবো, অইলে তার নিজর তাম্বুর বারে সাত দিন রইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","বাদে সাত দিনর দিন হিরবার তার শরিলর হকল চুল, মানি মাথার চুল, দাড়ি-মুছ, চখুর ভুরি আর গতরর হকল রুমা কামাইতে অইবো। বাদে তার কাপড়-চুপড় ধইয়া নাইয়া হারলে হে পুরাপুর পাক-ছাফ অইবো। ");
INSERT INTO syl_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“বাদর দিন হে পুরাপুর নিখুত দুইটা মেড়া-বাইচ্চা আর এক বছরর এগু মেড়ি লইয়া আইবো। আর এর লগর ধান-গমর ছদগার নিয়তে হে ছয় সের তেল মাখাইল ময়দা আর এক পাওয়া তেল আনবো। ");
INSERT INTO syl_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","আনিয়া হারলে তার পাক-ছাফর লাগি যে ইমাম ছাবে কাম কররা, এইন অউ জনরে আর কুরবানির মাল-ছামানারে মিলন-তাম্বুর দুয়ারর গেছে মাবুদর ছামনে আজির করবা। ");
INSERT INTO syl_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“ইমাম ছাবে হউ দুইও মেড়া-বাইচ্চা থাকি এগু মেড়া আর হউ তেল নিয়া দুষ-কছুরির কফরার কুরবানি আদায় করবা, করিয়া দুলনা কুরবানি হিসাবে মাবুদর ছামনে ইতা দুলাইবা। ");
INSERT INTO syl_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","বাদে পবিত্র কাবা ঘরর সীমানার যে জাগাত গুনার কফরার কুরবানি আর জালাইল কুরবানির পশু জবো করা অয়, হউ জাগাত অউ পশুরেও জবো করবা। গুনার কফরার কুরবানির লাখান দুষ-কছুরির কফরার কুরবানির গোস্তও ইমাম ছাবে পাইবা, ইতা তো খাছ পবিত্র গোস্ত। ");
INSERT INTO syl_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","যে জনরে পাক-ছাফ করা অইবো, ইমাম ছাবে দুষ-কছুরির কফরার কুরবানির কিছু লউ নিয়া তার ডাইন কানর লতিত, ডাইন আতর আর ডাইন পাওর বুড়ি আংগুলিত লাগাইবা। ");
INSERT INTO syl_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","বাদে ইমামে হউ তেল থাকি কিছু তেল তান বাউ আতর তালুর মাজে ঢালিবা। ");
INSERT INTO syl_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","আর ডাইন আতর আংগুইল দিয়া, বাউ আত থাকি তেল তুলিয়া মাবুদর নামে সাত বার ছিটাইবা। ");
INSERT INTO syl_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","বাদে আতর তালুর বাদ-বাকি তেল থাকি কিছু তেল নিয়া ইমামে হউ জনর ডাইন কানর লতিত, ডাইন আতর আর ডাইন পাওর বুড়ি আংগুলিত দুষ-কছুরির কফরার কুরবানির লউর উপরে লাগাইবা। ");
INSERT INTO syl_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","আর আতর তালুর বাকি তেল তাইন হউ পাক-ছাফ অওয়া জনর মাথাত লাগাইবা। “আর অউ নমুনায় তার কফরা আদায় করবা, ");
INSERT INTO syl_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","যে জনরে পাক-ছাফ করা অইবো, তার আনা গুনার কফরার কুরবানির পশুরে ইমাম ছাবে জবো করবা। বাদে জালাইল কুরবানির পশুও জবো করিয়া, ");
INSERT INTO syl_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","ধান-গমর ছদগার জিনিসর লগে মিলাইয়া, ইমাম ছাবে কুরবানি খানার উপরে ইতা দিবা। অউ নমুনায় তার কফরা আদায় করিয়া তার নাপাকি হরাইবা। ");
INSERT INTO syl_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“অইলে অউ জন যুদি গরিব অয়, ইতা হকলতা আনার তৌফিক তার না থাকে, তে দুষ-কছুরির কফরার কুরবানির লাগি খালি এগু মেড়া-বাইচ্চা আনতে অইবো, আনলে ইমামে তার কফরা আদায় করার লাগি অকটারে কুরবানি দিয়া দুলাইবা। আর এর লগর ধান-গমর ছদগা হিসাবে তার আনা তেল মাখাইল দুই সের ময়দা, এক পাওয়া তেল ");
INSERT INTO syl_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","আর তার দুইটা ডুপি পাখি বা পারো আনতে অইবো, যেলা তার তাক্কতে কুলায়। দুইও পাখির মাজর একটা গুনার কফরার কুরবানির লাগি, আর একটা জালাইল কুরবানির লাগি। ");
INSERT INTO syl_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","বাদে আট দিনর দিন পাক-ছাফ অওয়ার নিয়তে হে ইতা হকলতা আনিয়া মিলন-তাম্বুর দুয়ারর ধারো মাবুদর ছামনে ইমামর গেছে সমজাইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","ইমামে দুষ-কছুরির কফরার কুরবানির মেড়া আর অউ তেল নিয়া মাবুদর ছামনে দুলনা কুরবানি হিসাবে দুলাইবা। ");
INSERT INTO syl_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","বাদে ইমামে মেড়ারে জবো করিয়া অগুর কিছু লউ নিয়া হউ জনর ডাইন কানর লতিত, ডাইন আতর আর ডাইন পাওর বুড়ি আংগুলিত লাগাইবা। ");
INSERT INTO syl_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","বাদে হউ তেল থাকি কিছু তেল তান বাউ আতর তালুর মাজে ঢালিবা। ");
INSERT INTO syl_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","আর ডাইন আতর আংগুইল দিয়া ইমামে বাউ আতর কিছু তেল তুলিয়া মাবুদর ছামনে সাত বার ছিটাইবা। ");
INSERT INTO syl_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","এরলগে তার ডাইন কানর লতিত, ডাইন আতর আর ডাইন পাওর বুড়ি আংগুলির যে জাগাত দুষ-কছুরির কফরার কুরবানির লউ লাগাইল অইছে, হউ জাগার উপরে অউ তেলও লাগাইবা। ");
INSERT INTO syl_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","মাবুদর ছামনে হউ পাক-ছাফ অওয়া জনর কফরার নিয়তে ইমামর আতর বাকি তেল তার মাথাত ঢালি দিবা। ");
INSERT INTO syl_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","বাদে হউ জনর তাক্কত মাফিক আনা ডুপি বা পারো জুড়া নিয়া, ");
INSERT INTO syl_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ইমামে এগুরে গুনার কফরার কুরবানি হিসাবে, আর দুছরাটারে জালাইল কুরবানি হিসাবে কুরবানি দিবা। লগে ধান-গমর ছদগারেও দিবা। ইমামে অউ নমুনায় মাবুদর ছামনে তার কফরা আদায় করবা। ");
INSERT INTO syl_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","পচা-কুষ্ঠ বেমারি পাক-ছাফ অওয়ার লাগি যেলাখান কুরবানি আদায় করার কথা, ইতা আদায় করার তাক্কত যেরার নাই, তারার লাগি অউ নিয়ম দেওয়া অইছে।” ");
INSERT INTO syl_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","বাদে মাবুদে মুছা আর হারুনরে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“আমি যে দেশখানরে তুমরার মালিকানায় দিমু, অউ কেনান দেশো হামানির বাদে, আমি যুদি হনর কুনু ঘরর মাজে নাপাক-ফেউকনি বেমার পাঠাই, ");
INSERT INTO syl_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","তে ঘরর মালিকে গিয়া ইমাম ছাবরে কইবা, আমার ঘরো নাপাক-ফেউকনির লাখান কিতা যানু দেখিয়ার। ");
INSERT INTO syl_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","তেউ ইমামে ই ফেউকনি পরিক্ষা করিয়া দেখাত আইয়া, ঘরর হকল মাল-ছামানারে যাতে নাপাক কইয়া এলান করা না লাগে, অউ নিয়তে তাইন মালিকরে হুকুম দিবা, আমি ঘরো হামানির আগে তুমার ঘরর হকল মাল-ছামানা বারে বার করিলাও। হকলতা বার করিয়া হারলে তাইন ঘরো হামাইয়া পরিক্ষা করবা। ");
INSERT INTO syl_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","তাইন যুদি দেখইন, ঘরর ওয়ালর কুনু ফেউকনির দাগ গিয়া ভিতরেদি হামাইছে, আর অউ দাগর রং কচুয়া বা লালটি, ");
INSERT INTO syl_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","তে তাইন ই ঘর থাকি বার অই আইয়া, ঘরর দুয়ার সাত দিন বন্দ করি থইবা। ");
INSERT INTO syl_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","অউ সাত দিন বাদে হিরবার পরিক্ষা করি দেখবা, যুদি দেখা যায়, ই দাগ ওয়ালর মাজে আরো ছিতরিছে, ");
INSERT INTO syl_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","তে তাইন হুকুম দিবা, অউ ওয়ালর দাগ আলা পাথর বা ইট খুলিয়া হারি, গাউ বা টাউনর বারে নিয়া নাপাক কুনু জাগাত ফালাই দিতা। ");
INSERT INTO syl_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","বাদে আস্তা ঘরর ভিতরর হকল ওয়াল চাছিয়া আস্তর তুলিয়া হারি, অতা নিয়া টাউনর বারে নাপাক কুনু জাগাত ফালাইতা। ");
INSERT INTO syl_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","আর ওয়ালর যে জাগা থাকি পাথর বা ইট খুলা অইছে, হনো নয়া পাথর লাগাইবা, লাগাইয়া আস্তা ঘর হিরবার নয়া আস্তর করতা। ");
INSERT INTO syl_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“ওয়ালর পাথর খুলিয়া ফালাইয়া চাছিয়া আস্তর তুলার বাদে, নয়া আস্তর লাগাইয়া হারলেও যুদি ওয়ালো হিরবার অলা দাগ দেখা যায়, ");
INSERT INTO syl_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","তে ইমামে হিরবার গিয়া ইতা পরিক্ষা করি দেখবা। তাইন যুদি দেখইন, ওয়ালর মাজর দাগ ছিতরিয়া আরো বাড়ছে, তে বুজবা, অউ ঘরো নাপাক-ফেউকনি বেমার আছে, এরলাগি ই ঘর খান নাপাক। ");
INSERT INTO syl_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","নাপাক অউ ঘরর হকল পাথর বা ইট, হকল আস্তর, ঘরর লাকড়ি, হক্কলতা ভাংগিয়া টাউনর বারে কুনু নাপাক জাগাত নিয়া ফালাইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“আর হউ সাত দিন বন্দ রাখার কালো যুদি কুনু মানুষ গিয়া ই ঘরো হামায়, তে হে অউ দিন হাইঞ্জা পর্যন্ত নাপাক হালতে রইবো। ");
INSERT INTO syl_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","আর কেউ যুদি অউ ঘরো খানা-পিনা খায় বা ঘুমায়, তে তার ফিন্নর কাপড়-চুপড় ধইয়া দিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“অইলে ই ঘর আস্তর করার বাদে ইমামে পরিক্ষা করিয়া যুদি দেখইন, ওয়ালর দাগ আর দেখা যার না, তে ইমামে ই ঘররে পাক-ছাফ কইয়া এলান করবা। ই ঘরো তো নাপাক-ফেউকনি বেমারর কুনু আলামত অখন নাই। ");
INSERT INTO syl_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","আর ঘররে পাক-ছাফ করার লাগি ইমাম ছাবে দুইটা পাখি, দেবদারু গাছর কিছু লাকড়ি, এছুব গাছর ডেটা, আর লাল রংগর সুতা লইয়া অনো আইবা। ");
INSERT INTO syl_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","আইয়া ফুতর পানি থাকি আনা মাটির গামলাত থওয়া অউ পানির উপরে একটা পাখিরে জবো করবা। ");
INSERT INTO syl_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","আর দুছরা জিতা পাখিরে, দেবদারু গাছর লাকড়িরে, লাল সুতা আর এছুব গাছর ডেটারে, ফুতর পানির গামলার উপরে জবো করা হউ পাখির লউর মাজে ইমাম ছাবে ছুবাইবা, ছুবাইয়া হারি অউ ঘরর মাজে সাত বার ছিটাইবা। ");
INSERT INTO syl_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","পাখির লউ, ফুতর পানি, জিতা পাখি, দেবদারু গাছর লাকড়ি, এছুব গাছর ডেটা আর লাল সুতা দিয়া অউ ঘররে পাক-ছাফ করা অইবো। ");
INSERT INTO syl_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","এরবাদে অউ জিতা পাখিরে নিয়া গাউ বা টাউনর বারে খুলা জাগাত ছাড়ি দিবা। অউ নমুনায় হউ ঘরর নাপাকি হরাইয়া হারলে, ইখান পাক-ছাফ অইবো।” ");
INSERT INTO syl_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","তে হকল লাখান পচা-কুষ্ঠ বেমার, দাউদ-খাউজলি, ");
INSERT INTO syl_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","কাপড় বা ঘরর ওয়ালর ফেউকনির দাগ, ");
INSERT INTO syl_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","গতরর চামড়াত কুলশ উঠা, বরন বা কুনু জাতর দাগর বেয়াপারে অউ লাখান হুকুম জানাইল অইলো। ");
INSERT INTO syl_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ইতা বেমারে কুন সময় পাক, আর কুন সময় নাপাক, অখান জানানির লাগি অউ নিয়ম-কানুন দেওয়া অইলো। ");
INSERT INTO syl_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","মাবুদে মুছা আর হারুনরে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“তুমরা বনি ইছরাইলরে জানাও, কুনু বেটা মানষর পেসাবর রাস্তায় যুদি হামেশা ধাতু বার অয়, তে তার শরিল নাপাক। ");
INSERT INTO syl_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","তার শরিল থাকি ধাতু বারনিত রইলে বা শরিলো আটকি রইলেও হে নাপাক। ");
INSERT INTO syl_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","অলা নাপাক হালতে হে যে বিছনাত হুতিবো, বা যে জাগাত বইবো, হউ বিছনা আর হউ জাগাও নাপাক অইযিবো। ");
INSERT INTO syl_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","অউ ধাতু যাওরা নাপাক বেটার বিছনা যে জনে ছইবো, হে নিজর কাপড়-চুপড় ধইয়া দিয়া পানিদি নাইবো, তা-ও হাইঞ্জা পর্যন্ত হে নাপাক হালতে রইবো। ");
INSERT INTO syl_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","অলাখান হউ বেটার বওয়ার জাগাত যে জন বইবো, হে-ও তার কাপড়-চুপড় ধইয়া দিয়া পানিদি নাইবো, তা-ও হাইঞ্জা পর্যন্ত হে নাপাক হালতে রইবো। ");
INSERT INTO syl_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","আর ই ধাতু যাওরা বেটারে যে জনে ছইবো হে-ও তার কাপড়-চুপড় ধইয়া দিয়া পানিদি নাইবো, তা-ও হাইঞ্জা পর্যন্ত হে নাপাক হালতে রইবো। ");
INSERT INTO syl_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","হউ ধাতু যাওরা বেটায় যুদি কুনু পাক-ছাফ মানষর গতরো ছেফ ফালায়, তে অউ জনেও তার কাপড়-চুপড় ধইয়া দিয়া পানিদি নাইবো, তা-ও হাইঞ্জা পর্যন্ত হে নাপাক হালতে রইবো। ");
INSERT INTO syl_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","অউ ধাতু যাওরা বেটায় কুনু জাগাত যাইবার কালো গাড়ি-ঘোড়া কুনুতার সিটো বইয়া গেলে, ই সিট নাপাক অইযিবো। ");
INSERT INTO syl_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","অউ সিট কুনু মানষে ছইলে হে হাইঞ্জা পর্যন্ত নাপাক হালতে রইবো। অউ সিট যে জনে তুলবো, হে তার কাপড়-চুপড় ধইয়া দিয়া পানিদি নাইবো, তা-ও হাইঞ্জা পর্যন্ত হে নাপাক হালতে রইবো। ");
INSERT INTO syl_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","অউ ধাতু যাওরা বেটায় পানিদি আত না ধইয়া যুদি কুনু মানষরে ছইলায়, তে যারে ছইবো, হে তার কাপড়-চুপড় ধইয়া দিয়া পানিদি নাইবো, তা-ও হাইঞ্জা পর্যন্ত হে নাপাক হালতে রইবো। ");
INSERT INTO syl_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","আর ধাতু যাওরা বেটায় যুদি কুনু মাটির বাসন ছইলায়, তে ইতা ভাংগিলিতে অইবো, আর লাকড়িদি বানাইল কুনু জিনিস ছইলে, ইতা পানিদি ধইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“হউ ধাতু যাওরা বেমারি বেটার বেমার যেদিন কমিযিবো, অউ দিন থাকি গনিয়া সাত দিনর দিন হে তার কাপড়-চুপড় ধইয়া দিয়া ফুতর পানিত নাইয়া হারি পাক-ছাফ অইবো। ");
INSERT INTO syl_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","বাদে আট দিনর দিন হে দুইটা ডুপি পাখি বা দুগু পারো লইয়া মাবুদর ছামনে মিলন-তাম্বুর দুয়ারর গেছে আজির অইয়া, ইমাম ছাবর আতো দিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","ইমামে হউ দুইটার এগুরে দিয়া গুনার কফরার কুরবানি, আর দুছরাটা দিয়া জালাইল কুরবানি আদায় করবা। ধাতু যাওরা বেটার নাপাকি হরানির নিয়তে, ইমাম ছাবে মাবুদর ছামনে অউ নমুনায় তার কফরা আদায় করবা। ");
INSERT INTO syl_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“কুনু বেটা মানষর যৌবনর পানি বার অইগেলে হে তার আস্তা শরিলরে পানিদি ধইতে অইবো, আর হাইঞ্জা পর্যন্ত হে নাপাক হালতে রইবো। ");
INSERT INTO syl_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","অউ যৌবনর পানি কুনু কাপড় বা চামড়ার জিনিসো লাগিগেলে, ইতা পানিদি ধইতে অইবো, আর হাইঞ্জা পর্যন্ত ইতা নাপাক হালতে রইবো। ");
INSERT INTO syl_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","কুনু বেটায় তার বউর লগে মিলা-মিশার কালো যৌবনর পানি বার অইলে, তারা দুইওজনে পানিদি নাইতে অইবো, দুইওজন হাইঞ্জা পর্যন্ত নাপাক হালতে রইবো। ");
INSERT INTO syl_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“কুনু বেটির মাসিক বেমারর লউ যাওয়ার সময় তাই সাত দিন নাপাক হালতে রইবো। অউ সময় ই বেটিরে যে জনে ছইবো, হে হাইঞ্জা পর্যন্ত নাপাক হালতে রইবো। ");
INSERT INTO syl_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","অউ বেটিয়ারা বেমারর সময় তাই যেতার উপরে বইবো বা হুতিবো, ইতা হকলতা নাপাক অইযিবো। ");
INSERT INTO syl_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","তাইর বিছনা যে জনে ছইবো, হে-ও তার কাপড়-চুপড় ধইয়া দিয়া পানিদি নাইবো, তা-ও হাইঞ্জা পর্যন্ত হে নাপাক হালতে রইবো। ");
INSERT INTO syl_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","অউ বেমারি বেটি যেতার উপরে বইছে, ইতা যুদি কেউ ছইলায়, তে হে-ও তার কাপড়-চুপড় ধইয়া দিয়া পানিদি নাইবো, তা-ও হাইঞ্জা পর্যন্ত হে নাপাক হালতে রইবো। ");
INSERT INTO syl_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","তাইর বিছনা বা চেয়ারো কেউ ছইলে, বা ইতার উপরে থওয়া কুন্তা ছইলেও, হে হাইঞ্জা পর্যন্ত নাপাক হালতে রইবো। ");
INSERT INTO syl_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","বেটিয়ারা বেমারি বেটির লগে কুনু বেটা মানুষ যুদি হুতে, আর তাইর মাসিকর লউ তার শরিলো লাগে, তে অউ বেটাও সাত দিন নাপাক হালতে রইবো। অউ সাত দিনর মাজে হে যে বিছনাত হুতিবো, ইতাও নাপাক অইযিবো। ");
INSERT INTO syl_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“কুনু বেটি মানষর যুদি বউত দিন ধরি লউ যাওয়াত রয়, মাসিক বেমারর সাত দিন পারনির বাদেও যুদি লউ যাওয়াত রয়, তে যতদিন পর্যন্ত ইলা লউ যাইবো, অতদিন তাই নাপাক রইবো। ");
INSERT INTO syl_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","বেটিয়ারা মাসিক বেমারর লাখান অউ লউ যাইবার সময় তাই যেতাত হুতিবো বা বইবো, ইতা নাপাক অইযিবো। ");
INSERT INTO syl_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","ই বিছনা বা চেয়ার যে জনে ছইবো, হে-ও নাপাক অইযিবো। হে তার কাপড়-চুপড় ধইয়া দিয়া পানিদি নাইবো, তা-ও হাইঞ্জা পর্যন্ত হে নাপাক হালতে রইবো। ");
INSERT INTO syl_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","অউ বেটির লউ যাওয়া বন্দ অওয়ার বাদেও, তাই গনিয়া আরো সাত দিন বার চাইতে অইবো, এরবাদে তাই পাক-ছাফ অইবো। ");
INSERT INTO syl_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","আর আট দিনর দিন তাই দুইটা ডুপি পাখি বা পারো লইয়া মিলন-তাম্বুর দুয়ারর গেছে ইমাম ছাবর ধারো যাইবো। ");
INSERT INTO syl_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","ইমামে হউ দুইও পাখির মাজর এগুদি গুনার কফরার কুরবানি, আর দুছরাটা দিয়া জালাইল কুরবানি আদায় করবা। অউ নমুনায় ইমামে তাইর লউ যাইবার নাপাকি হরানির কফরা মাবুদর ছামনে আদায় করবা। ");
INSERT INTO syl_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ও মুছা আর হারুন, অউ নমুনায় তুমরা বনি ইছরাইল সমাজরে হকল নমুনার নাপাকি থাকি বাচাইও, আরনায় তারার মাজে রওয়া আমার পবিত্র বসত খানারে যুদি তারা নাপাক বানাইন, তে অউ নাপাকির দায় তো তারার মরন অইবো।” ");
INSERT INTO syl_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","33","তে বেটাইন্তর ধাতু যাওয়া বেমার, যৌবনর পানি বারনি, বেটিন্তর মাসিক বেমার, বেটা বা বেটিন্তর যেকুনু লাখান ধাতু যাওয়া, নাপাক বউর লগে মিলা-মিশা করা, ইতা যেকুনু জনর লাগি অউ নিয়ম জারি অইলো। ");
INSERT INTO syl_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","ইমাম হারুনর বড় দুই পুয়ায় নাফরমানি করিয়া মাবুদর ছামনে পড়িয়া মারা গেলো করি, মাবুদে মুছা নবীর লগে বাতচিত করলা। ");
INSERT INTO syl_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","মাবুদে কইলা, “তুমার ভাই হারুনরে কও, হে যানু যেবলা মনে চায় এবলা শাহাদত সন্দুকর ঢাকনার গেছে যাওয়ার লাগি হেরেম শরিফর পর্দার ভিতরে না হামায়, আরনায় হে মরবোউ। জানো তো, অউ ঢাকনার উপরর ধুমার আন্দাইরর মাজে আমি নিজে আজির অই। ");
INSERT INTO syl_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“ইনো হামানির আগে হে যানু গুনার কফরার কুরবানির লাগি এগু বিছাল আর জালাইল কুরবানির লাগি এগু মেড়ার পাঠা লইয়া ইনো আইয়া হামায়। ");
INSERT INTO syl_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","সাদা সুতি কাপড়দি বানাইল পবিত্র আলখেল্লা আর হাফ-পেন্টর লাখান জাংগিয়া ফিন্দিয়া ভিতরে হামাইবো। তার কমরো বান্দার সুতি কাপড়র বন্দনি বান্দিবো আর মাথাত সুতি কাপড়র পাউগড়ি লাগাইবো। ইতা তো পাক-পবিত্র লেবাছ, ইতা লেবাছ ফিন্দিবার আগে পানিদি নাইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","গুনার কফরার কুরবানির লাগি হে বনি ইছরাইলর গেছ থাকি দুইটা পাঠা ছাগল আর জালাইল কুরবানির লাগি এগু মেড়ার পাঠা নিবো। ");
INSERT INTO syl_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","ইমাম হারুনে তার নিজর আর তার আওলাদ অকলর গুনার মাফির লাগি, গুনার কফরার বিছালরে কুরবানি দিবো। ");
INSERT INTO syl_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","বাদে হউ ছাগল দুইওটা মিলন-তাম্বুর দুয়ারর গেছে মাবুদর ছামনে আনবো। ");
INSERT INTO syl_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","আনিয়া হে লটারি মারিয়া দেখবো, কুন ছাগল মাবুদর লাগি আর কুনটা আজাজিলর লাগি। ");
INSERT INTO syl_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","লটারিত মাবুদর নামে যে ছাগল উঠবো, হারুনে অগুদি গুনার কফরার কুরবানি আদায় করবো। ");
INSERT INTO syl_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","আর আজাজিলর নামে যে ছাগল উঠবো, অগুরে জিতা হালতে মাবুদর ছামনে থইবো, যাতে বাদে অগুরে মরুভুমিত নিয়া আজাজিলর নামে আউরি ছাড়ি দেওয়া অয়। অউ নমুনায় গুনার কফরা আদায় করিও। ");
INSERT INTO syl_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“ইমাম হারুনে তার নিজর আর তার আওলাদ অকলর গুনার কফরার লাগি, তার নিজর আনা হউ বিছালরে জবো করবো। ");
INSERT INTO syl_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","মাবুদর ছামনে আগর-খুশবয় জালানির যে টেবুল আছে অউ টেবুল থাকি কিছু জালাইল আংরা লইয়া হে আগর দানির মাজে ভরবো, আর দুই মুইট আগর-খুশবয়র গুড়াও লইবো, বাদে পর্দার ভিতরে হেরেম শরিফো হামাইবো। ");
INSERT INTO syl_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","হামাইয়া অউ আংরার উপরে আগর-খুশবয় দিয়া মাবুদর ছামনে জালাইবো, তেউ অতার ধুমায় শাহাদত সন্দুকর ঢাকনার উপরর গালা আন্দাইরে গুরিযিবো, যাতে হে মাবুদর ছামনে না মরইন। ");
INSERT INTO syl_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","বাদে হে কুরবানির হউ বিছালর থুড়া লউ নিয়া আতর আংগুইল দিয়া অউ ঢাকনার ছামনর গালাবায় ছিটাই দিবো। এরবাদে আংগুলির মাজে আরো থুড়া লউ লাগাইয়া ঢাকনার ছামনর বায় সাত বার ছিটাইয়া দিবো। ");
INSERT INTO syl_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“আর হে মানষর গুনার কফরার নিয়তে আনা ছাগলটারে জবো করবো, করিয়া অগুর লউ নিয়া পর্দার ভিতরে হেরেম শরিফো গিয়া, বিছালর লউদি যেলা করা অইছিল, অগুর লউদিও অলা করতে অইবো। সন্দুকর ঢাকনার উপরে আর ছামনে অউ লউ ছিটাইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","বনি ইছরাইলর গুনা, নাপাকি, আর নাফরমানিয়ে হেরেম শরিফরেও নাপাক করিলায়, এরলাগি তারার মাজে যে মিলন-তাম্বু আছে, অখানর নাপাকি হরানির নিয়তে ইমাম হারুনে অউ নমুনায় গুনার কফরা আদায় করবা। ");
INSERT INTO syl_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","হেরেম শরিফর ভিতরে হামাইয়া হারি হারুনে তান নিজর, তান আওলাদ অকলর আর আস্তা সমাজর গুনার কফরার হকল কাম শেষ করিয়া যতবিল না বার অইয়া আইন, অতবিল দুছরা কুনু মানুষ মিলন-তাম্বুর ভিতরে হামানি নিষেধ। ");
INSERT INTO syl_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","হেরেম শরিফ থাকি বার অইয়া হারুনে মাবুদর ছামনে যে আগর-খুশবয় জালানির টেবুল আছে অউ টেবুলর কান্দাত যাইবা, যাইয়া টেবুলর লাগিও কফরা আদায় করবা। হউ বিছাল আর ছাগলর থুড়া লউ নিয়া তাইন অউ টেবুলর হিংগর মাজে লাগাইবা। ");
INSERT INTO syl_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","বনি ইছরাইলর গুনার কারনে টেবুলর মাজে যে নাপাকি লাগাইল অইছে, হউ নাপাকি হরাইয়া অউ টেবুলরে পবিত্র করার লাগি হারুনে তার আতর আংগুইল দিয়া অউ টেবুলর উপরে সাত বার লউ ছিটাইবো। ");
INSERT INTO syl_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“হেরেম শরিফ, মিলন-তাম্বু, আর কুরবানি খানার নাপাকি হরানির কফরার কাম শেষ করিয়া হারলে হারুনে আজাজিলর নামে দেওয়ার লাগি হউ জিতা ছাগলরে লইয়া আইবা। ");
INSERT INTO syl_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","আইয়া অউ ছাগলর কল্লার উপরে তার দুইও আত থইয়া, বনি ইছরাইলর হকল গুনা-নাফরমানি আর বদ কামর কথা স্বীকার করিয়া ছাগলর কল্লার উপরে অতা বর্তাই দিবো। বাদে আগ থাকি জুইত অওয়া এক বেটারে দিয়া অউ ছাগলরে হে মরুভুমিত পাঠাই দিবো। ");
INSERT INTO syl_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","হউ বেটায় নিয়া অগুরে মরুভুমিত ছাড়িয়া আইবো। তারার হকল নাফরমানিরে অউ ছাগলে লইয়া নিরাই নির্জন মরুভুমিত আজীবন ঘুরিবো। ");
INSERT INTO syl_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“আর হেরেম শরিফো হামাইবার কালো হারুনে সাদা সুতি কাপড়র যত লেবাছ ফিন্দিছলা, তাইন মিলন-তাম্বুত ফিরিয়া আইয়া ইতা খুলিয়া থই দিবা। ");
INSERT INTO syl_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","খুলিয়া তাইন কাবা ঘরর সীমানার ভিতরে পানিদি নাইয়া তান নিজর লেবাছ ফিন্দিবা। বাদে তাইন বারে আইয়া তান নিজর আর মানষর লাগি এগু করি জালাইল কুরবানি আদায় করিয়া, তান নিজর আর মানষর গুনার কফরাও আদায় করবা। ");
INSERT INTO syl_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","গুনার কফরার কুরবানির চর্বিরে তাইন কুরবানি খানার উপরে জালাইলিবা। ");
INSERT INTO syl_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","যে বেটায় আজাজিলর নামর ছাগলরে মরুভুমিত ছাড়িয়া আইবো, হে-ও তার কাপড়-চুপড় ধইয়া হারি পানি দিয়া নাইয়া বাদে কেম্পর ভিতরে হামাইতো পারবো। ");
INSERT INTO syl_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","গুনা মাফির লাগি কুরবানির যে বিছাল আর গুনার কফরার কুরবানির যে ছাগলর লউরে হেরেম শরিফো নিবার হুকুম দেওয়া অইছে, অতার হকল গোস্ত, খাল, গুফর আর হকলতারে কেম্পর বারে নিয়া একজনে জালাইলিও। ");
INSERT INTO syl_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","যে জনে ইতা হকলতা বারে নিয়া জালাইবো, হে-ও তার কাপড়-চুপড় ধইয়া, পানিদি নাইয়া হারি বাদে আইয়া কেম্পর ভিতরে হামাইতো পারবো। ");
INSERT INTO syl_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“এরবাদে আমি যেতা কইরাম, ইতা অইলো তুমরার লাগি হর-হামেশাকুর নিয়ম। পরতেক বছরর সাত নম্বর চান্দর দশ নম্বর দিন, তুমরার পরতেক জনে হকল জাতর কাম-কাজ আর রুজি-রুজগার বাদ দিয়া, নত অইয়া দিল সপিয়া দিবায়। বনি ইছরাইল বা তুমরার লগে বসত কররা ভিন-দেশি হকল জনে ইতা মানতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","কারন অউদিন তুমরার গুনা মাফির লাগি গুনার কফরা আদায় করা অইবো, তেউ তুমরা মাবুদর ছামনে হকল নমুনার গুনা থাকি পাক-ছাফ অইবায়। ");
INSERT INTO syl_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","অউদিন তুমরা হকল নমুনার কাম-কাজ বাদ দিয়া আরাম করবায়, পরতেকে নত অইয়া যারযির দিল সপিয়া দিবায়। ইটা অইলো তুমরার লাগি চিরকালিন নিয়ম। ");
INSERT INTO syl_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","যেকুনু ইমামরে যেবলা পরধান ইমাম হিসাবে তার বাফর জাগাত খেলাফতি সমজাইয়া বওয়াল করা অইবো, হে-ও অলা সাদা সুতি কাপড়র পবিত্র লেবাছ ফিন্দিয়া অউ নমুনায় গুনার কফরা আদায় করবো। ");
INSERT INTO syl_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","হেরেম শরিফ, পবিত্র কাবা ঘর, কুরবানি খানা, বাকি ইমাম অকল, আর আস্তা বনি ইছরাইল সমাজরে পাক-ছাফ করার লাগি কফরা আদায় করবো। ");
INSERT INTO syl_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","ইটা অইলো তুমরার লাগি হর-হামেশাকুর নিয়ম। পরতেক বছর একবার হকল বনি ইছরাইলর গুনার কফরা অলা আদায় করতে অইবো।” তেউ মাবুদে মুছারে যেলা হুকুম দিছলা, ঠিক অউ লাখান হকলতা করা অইলো। ");
INSERT INTO syl_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","বাদে মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“আমার অউ হুকুম খান তুমি ইমাম হারুনরে, তার পুয়াইন্তরে আর তামাম বনি ইছরাইলরে জানাই দেও। তারারে কও, ");
INSERT INTO syl_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","বনি ইছরাইলর কেউ যুদি কুনু গরু, ছাগল বা মেড়ারে তারার বসত তাম্বু এলাকাত বা কেম্পর বারে যে কুনু জাগাত কুরবানি নিয়তে জবো করিলায়, ");
INSERT INTO syl_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","অউ পশুরে হে মাবুদর কাবা ঘরর ছামনে, মানি মিলন-তাম্বুর দুয়ারর গেছে মাবুদর নামে কুরবানির নিয়তে জবো না করে, তে হে অউ পশুর খুনর দায়ী অইবো, এরলাগি সমাজ থাকি তার নাম মিটাইলিবায়। ");
INSERT INTO syl_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","বনি ইছরাইলে অখন গাউ-গেরামর খুলা জাগাত যেতা পশু কুরবানি দেইন, অউ পশু যানু তারা মাবুদর ছামনে মিলন-তাম্বুর দুয়ারর গেছে আনে। আনিয়া ইমাম ছাবর আতো সমজাইয়া ছালামতি কুরবানি হিসাবে ইতা মাবুদর নামে দিলায়। ");
INSERT INTO syl_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","ইমাম ছাবে পশু জবো করিয়া, মিলন-তাম্বুর দুয়ারর গেছে মাবুদর যে কুরবানি খানা আছে, হনো অগুর লউ ছিটাই দিবা, আর পশুর চর্বিরে তাইন ঘেরান আলা কুরবানি হিসাবে জালাইলিবা, অউ ধুমার ঘেরানে মাবুদ খুশি অইন। ");
INSERT INTO syl_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","খবরদার! তারা যানু মাবুদর লগে বেইমানি করিয়া ছাগলরুপি দেও-ভুতর নামে আইজ থাকি আর কুনু পশু বলি না দেয়। অউ হুকুম আমি তারার ওয়ারিশর পর ওয়ারিশ ধরি চিরকালর লাগি জারি করলাম। ");
INSERT INTO syl_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“আর তুমি তারারে জানাই দেও, বনি ইছরাইলর কুনু জন বা তারার মাজে বসত কররা কুনু ভিন-দেশিয়ে যুদি জালাইল কুরবানি বা যেকুনু কুরবানি আদায় করে, ");
INSERT INTO syl_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","আর কুরবানির অউ পশুরে মাবুদর নামে সপিবার লাগি আমার মিলন-তাম্বুর দুয়ারর গেছে না আনে, তে ই জাতির মাজ থাকি তার নাম মিটাইলিতো। ");
INSERT INTO syl_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“তুমি আরো জানাই দেও, কুনু বনি ইছরাইল বা তারার মাজে বসত কররা কুনু ভিন-দেশিয়ে যুদি কুনুজাত লউ খায়, তে আমি মাবুদে তার খেতি করাত লাগিযিমু, সমাজ থাকি তার নাম মিটাইলিমু। ");
INSERT INTO syl_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","লউর মাজেউ তো হকল জানদারর জান থাকে। এরলাগি তুমরার জানর বদলা কুরবানির লউরে কুরবানি খানাত ছিটাইয়া আমি তুমরার গুনার কফরার সুযোগ দিছি। লউর মাজে জান আছে করিউ লউর বদলা গুনার কফরা আদায় অয়। ");
INSERT INTO syl_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","এরলাগি আমি বনি ইছরাইলরে কইয়ার, তুমরা আর তুমরার লগে বসত কররা কুনু ভিন-দেশিয়েও যানু লউ না খায়। ");
INSERT INTO syl_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","বনি ইছরাইলর যেকুনু জনে বা তুমরার লগে বসত কররা কুনু ভিন-দেশি মানষে যুদি, শিকারো গিয়া হালাল কুনু পশু বা পাখি শিকার করিয়া আনে, তে অগুর লউ বার করিয়া মাটিত গাড়িলিবায়। ");
INSERT INTO syl_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","জানো তো, জিন্দা হকল জানদারর লউর মাজেউ তার জান থাকে। এরলাগি আমি বনি ইছরাইলরে কইয়ার, তারা যানু কুনু জানদারর লউ না খায়, লউ অইলো হকল জানদারর জান। যে জনে অউ লউ খাইবো, তার নাম মিটাইলিবায়। ");
INSERT INTO syl_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“আর কুনু মানষে যুদি মরা পশুর বা জংলি জানুয়ারে মারা কুনু পশুর গোস্ত খাইলায়, তে হে বনি ইছরাইল অউক, বা তারার লগে বসত কররা ভিন-দেশি অউক, হে তার কাপড়-চুপড় ধইয়া দিয়া পানিদি নাইতে অইবো। তা-ও হাইঞ্জা পর্যন্ত হে নাপাক হালতে রইবো, এরবাদে হে পাক-ছাফ বনবো। ");
INSERT INTO syl_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","অইলে হে যুদি কাপড়-চুপড় ধইয়া না দেয় আর পানিদি না নায়, তে ই কছুরির লাগি হে দায়ী রইবো।” ");
INSERT INTO syl_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","আর মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“তুমি বনি ইছরাইলরে কও, আমি আল্লাউ তুমরার মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","এরলাগি তুমরা আগে যে মিসর দেশো বসত করতায়, হিনর মানষে যেতা করে তুমরা ইতা করিও না। আর আমি তুমরারে যে কেনান দেশো নিরাম, হউ দেশো গিয়া হারলে, হনর মানষে যেতা করে ইতাও তুমরা করিও না। তারা যেলা চলে, তুমরা ইলা চলিও না। ");
INSERT INTO syl_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","বরং আমার দেওয়া শরিয়ত মাফিক তুমরার জিন্দেগি কাটাইবায়। খুব খিয়াল করিয়া আমার দেওয়া হুকুম-আহকাম আমল করবায়। মনো রাখিও, আমি আল্লাউ তুমরার মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","আমার বাতাইল নিয়ম-কানুন আর শরিয়তর হুকুম-আহকাম তুমরা আমল করবায়, যে জনে ইতা আমল করে হে এর উছিলায় তার জান বাচাইবো। আমিউ তো মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“আপন লউর খেশ-কুটুমর লগে শরিলি মিলা-মিশা বা বেইজ্জতি কাম করিও না। আমিউ তো মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","তুমরার মাজর কেউ যানু নিজর মাʼর লগে শরিলি মিলা-মিশা করিয়া তার বাফর মান-ইজ্জত না লুটে। এইন তো তার মা, এন লগে মিলা-মিশা করা হারাম। ");
INSERT INTO syl_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","হাতন মাʼর লগেও মিলা-মিশা করা হারাম, আরনায় বাফর বেইজ্জতি অইবো। ");
INSERT INTO syl_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","নিজর বইন বা হাতন বইনর লগে মিলা-মিশা করাও হারাম, আপন বাফর তরফা বইন বা মাʼর তরফা বইন অইলেও হারাম। তারা এক বাড়িত জনম অউক বা আলাদা বাড়িত জনম অইলেও হারাম। ");
INSERT INTO syl_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","পুয়া বা পুড়ির ঘরর নাতিনর লগে শরিলি মিলা-মিশা করা হারাম, ইতায় তো নিজর বেইজ্জতি অয়। ");
INSERT INTO syl_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","হাতন মাʼর ঘরর বইনর লগে শরিলি মিলা-মিশা করা হারাম, তাই তো বইন। ");
INSERT INTO syl_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","আপন ফুফুর লগে শরিলি মিলা-মিশা করা হারাম, এইন তো বাফর লউর কুটুম। ");
INSERT INTO syl_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","আপন মইর লগে শরিলি মিলা-মিশা করা হারাম, এইন তো মাʼর লউর কুটুম। ");
INSERT INTO syl_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","আপন চাচার মান-ইজ্জত লুটিয়া তান বউর লগে শরিলি মিলা-মিশা করা হারাম, এইন তো চাচী। ");
INSERT INTO syl_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","আপন পুয়ার বউর লগে শরিলি মিলা-মিশা করা হারাম, তাই তো নিজর বউমা। ");
INSERT INTO syl_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","ভাইর বউর লগে শরিলি মিলা-মিশা করা হারাম, আরনায় ভাইর বেইজ্জতি অইবো। ");
INSERT INTO syl_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","কুনু বেটি মানষর লগে শরিলি মিলা-মিশার বাদে তাইর পুড়ির লগে, তাইর পুয়া বা পুড়ির ঘরর নাতিনর লগে শরিলি মিলা-মিশা করা হারাম, এরা তো তাইর লউর কুটুম, ইতা বড় খবিছি কাম। ");
INSERT INTO syl_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","আর বউ জিতা থাকা হালতে হালি বা জেঠালিরে বিয়া করিয়া হতিয়ালা করাও হারাম। ");
INSERT INTO syl_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“হায়েজ বা বেটিয়ারা মাসিক বেমার থাকা হালতে কুনু বেটিন্তর লগে মিলা-মিশা করা হারাম। ");
INSERT INTO syl_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","দুছরা কুনু বেটার বউর লগে শরিলি মিলা-মিশা করিয়া, নিজরে নাপাক বানাইও না। ");
INSERT INTO syl_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“তুমরার মাজর কেউ নিজর পুয়া বা পুড়িরে আগুইনদি জালাইয়া, মুলক দেবতার নামে বলি দিয়া, আপন আল্লার পবিত্র নামরে অসম্মান করিও না। আমিউ তো মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“বেটিন্তর লগে যেলা শরিলি মিলা-মিশা করইন, বেটাইন্তে-বেটাইন্তে অলা খবিছি পুংগামি করা হারাম। ");
INSERT INTO syl_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","কুনু পশুর লগে খবিছি মিলা-মিশা করিয়া, কুনু বেটাইন নাপাক বনিও না। কুনু পশুর লগে কুনু বেটিন্তেও খবিছি মিলা-মিশা করিও না। ইলাখান খবিছি মিলা-মিশা তো জগতর নিয়মর উল্টা। ");
INSERT INTO syl_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“অউ লাখান কুনু খবিছি বেইজ্জতি কাম করিয়া, তুমরার মাজর কেউ যানু নিজরে নাপাক না বানায়। মনো রাখিও, তুমরার ছামনে থাকি যত জাতি অকলরে আমি খেদাই দিরাম, তারা তো অতা খবিছি করিয়া নিজরে নাপাক করছিল। ");
INSERT INTO syl_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","অতার লাগি তারার দেশর মাটি নাপাক বনিগেছে, তারার নাফরমানির কারনে আমি অউ দেশরে সাজা দিরাম, অউ দেশর মাটিয়ে তার প্রজা অকলরে বমি করি ফালাই দের। ");
INSERT INTO syl_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","অইলে তুমরা খালি আমার দেওয়া শরিয়ত আর হুকুম-আহকাম মানিয়া চলিও। তুমরার নিজর জাতির বা তুমরার মাজে বসত কররা ভিন-দেশি কেউ যানু অলা খবিছি বেইজ্জতির কুনুজাত কাম না করে। ");
INSERT INTO syl_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","আগে থাকি যেতা জাতি অকল হউ দেশো বসত করের, তারা অউ নমুনার খবিছি বেইজ্জতি কাম অকল করায় হনর মাটিরে নাপাক বানাইলিছে। ");
INSERT INTO syl_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","অখন তুমরাও হনো গিয়া যুদি হতার লাখান নাপাকি কাম করো, তে তারার লাখান তুমরারেও হউ দেশর মাটিয়ে বমি করি ফালাইবো। ");
INSERT INTO syl_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ইলা খবিছি কুনু কাম কেউ করলে, তুমরার সমাজ থাকি তার নাম মিটাইলিবায়। ");
INSERT INTO syl_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","আমার হুকুম-আহকাম তুমরা মানিও, তুমরা হউ দেশো গিয়া হারি হনর পুরানা বাসিন্দা অকলর চাল-চলনে চলিও না। তারার খবিছি রীতি-রেওয়াজ মানিয়া তুমরা নাপাক অইও না। মনো রাখিও, আমি আল্লাউ তুমরার মাবুদ।” ");
INSERT INTO syl_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","মাবুদে মুছা নবীরে আরো কইলা, ");
INSERT INTO syl_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“তুমি হকল বনি ইছরাইলরে কও, আমি তুমরার মাবুদ আল্লা তো পাক-পবিত্র, এরলাগি তুমরাও পাক-পবিত্র অও। ");
INSERT INTO syl_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","তুমরা পরতেকে যারযির মা-বাফরে তাজিম করিও, আর আমার দেওয়া হকল জুম্মাবার মানিও। আমি আল্লাউ তুমরার মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","তুমরা কুনুজাতর দেব-দেবীর পুজা করিও না, পুজা করার নিয়তে ফর্মাত ঢালিয়া সোনা-রুপা, পিতল-তামাদি কুনু দেব-দেবীর মুর্তিও বানাইও না। মনো রাখিও, আমি আল্লাউ তুমরার মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“তুমরা যেবলা নিজর খুশিয়ে মাবুদর নামে কুনু ছালামতি কুরবানি দেও, অউ সময় অলা ভাব লইয়া দিও, যাতে মাবুদর দরবারো ইতা কবুল অয়। ");
INSERT INTO syl_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","আর ইতার হকল গোস্ত কুরবানির দিন বা বাদর দিন খাইলিতে অইবো। তিন দিনর দিন কুনু গোস্ত বাকি রইলে, ইতা আগুইনদি জালাইলিও। ");
INSERT INTO syl_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","তিন দিনর দিন তো ই গোস্ত নাপাক বনিযায়, ইতা খাইলে তুমরার কুরবানি কবুল অইতো নায়। ");
INSERT INTO syl_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ই গোস্ত কেউ খাইলে হে নাফরমানির দাড়ো পড়বো, হে তো মাবুদর নামর পাক-পবিত্র জিনিসরে নাপাক বানাইছে। তে তুমরার সমাজ থাকি তার নাম মিটাইলিবায়। ");
INSERT INTO syl_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“খেতর ফসল কাটার সময় তুমরা জমিনর আইলর কান্দার ফসল ছাফ করিয়া কাটিও না, আর কাটার বাদে জমিনো ফালাইল ফসল লুরিয়া নিও না। ");
INSERT INTO syl_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","আংগুর খেতর আংগুর পাড়িবার কালো, তলে ফালাইল আংগুর তুবাইয়া তুলিও না, আর হকল আংগুর ছাফ করি পাড়িয়া নিও না। সমাজর গরিব-দুখি আর বিদেশি মুছাফিরর লাগি ইতা কিছু থইয়া যাইও। আমি আল্লাউ তো তুমরার মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“চুরি করিও না, মিছা মাতিও না, আর একে-অইন্যে ঠগাঠগি করিও না। ");
INSERT INTO syl_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","তুমরা আমার নাম লইয়া মিছা কছম খাইও না, ইলা করলে তুমরার আল্লার নামরে অপবিত্র করা অয়। আমিউ তো মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“কুনু আরি-ফরির উপরে জুর-জুলুম করিও না, তারার কুনু জিনিস কাড়িয়া নিও না। রুজি কামলার বেতন অউ দিনর মাজেউ আদায় করিও, বাদর দিন পর্যন্ত তার বেতন আটকাই থইও না। ");
INSERT INTO syl_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","কুনু খালুয়ারে বদদোয়া দিও না, কানা বা আন্দায় উষ্টা খাইবার লাগি তার পথর মাজে কুন্তা থইও না। তুমরা নিজর মাবুদ আল্লারে ইজ্জত-তাজিম করিও, আমিউ তো মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“না-হক বিচার করিও না, বিচারর মাজে গরিব-ধনি, বা হুরু-বড়র পক্ষপাতি অইও না, হকলর লাগি হক বিচার করিও। ");
INSERT INTO syl_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","মানষর বদনাম গাইয়া গাইয়া ঘুরিও না, কুনু মানষর জানর খেতি অয়, ইলা কুনু কাম করিও না। আমিউ তো মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“আপন আরি-ফরির বায় ইংসা-দুশমনির ভাব মনর মাজে গাথিয়া রাখিও না। তার অপরাধ তারে বুজাই দিও, তেউ তার গুনার ভার তুমার উপরে আইতো নায়। ");
INSERT INTO syl_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","নিজর জাতির মানষর বদলা লইও না, তারার বায় জিদ-ইংসার ভাব মনর মাজে গাথিয়া রাখিও না। আরি-ফরিরে তুমার নিজর লাখান মায়া করিও। আমিউ তো মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“তুমরা আমার নিয়ম-কানুন মানিয়া চলিও। এক জাতর পশুর লগে আরক জাতর পশুরে ফাল খাবাইও না। এক জমিনো দুই জাতর বিচ খেত করিও না, আর দুই জাতর সুতাদি বানাইল কাপড় ফিন্দিও না। ");
INSERT INTO syl_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“কুনু বান্দি বেটির বিয়া ঠিক করা অইছে, অইলে তাইর মহরানার টেকা দেওয়া অইছে না, বা মালিকে যেগুরে আজাদ করিয়া দিছইন না, ইলা কুনু বান্দির লগে কেউ শরিলি মিলা-মিশা করলে, তে হে খেতি-পুরন দিতে অইবো। ই দুইও জনরে জানে মারিও না, কারন অউ বান্দি পুড়ি তো আজাদ অইছে না। ");
INSERT INTO syl_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","অইলে অউ বেটায় তার দুষ-কছুরির কফরার কুরবানির লাগি, মাবুদর নামে নিখুত এগু মেড়া লইয়া মিলন-তাম্বুর দুয়ারর ছামনে আজির অইবো। ");
INSERT INTO syl_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","দুষ-কছুরির কফরার কুরবানির লাগি আনা হউ পশুরে কুরবানি দিয়া, ইমাম ছাবে মাবুদর ছামনে তার গুনার কফরা আদায় করার বাদে, হে অউ গুনার মাফি পাইবো। ");
INSERT INTO syl_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“তুমরা নিজর দেশো গিয়া হারি কুনু ফলর গাছ লাগাইলে, তিন বছর পর্যন্ত ই গাছর ফল তুমরার লাগি হারাম। অউ তিন বছরর মাজে ই গাছর ফল খাওয়া নাজাইজ। ");
INSERT INTO syl_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","চাইর নম্বর বছরো ই গাছর হকল ফল মাবুদর শুকুর-গুজারির নিয়তে তান নামে দিলাইবায়। ");
INSERT INTO syl_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","পাচ নম্বর বছর থাকি অউ গাছর ফল তুমরার লাগি হালাল। ইতা মানলে তুমরার গাছো বউত ফল আইবো। মনো রাখিও, আমি আল্লাউ তুমরার মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“তুমরা লউ সমেত কুনু গোস্ত খাইও না। কুনু জাতর যাদু-মন্ত্র বা গনা-বাছা হিকিও না, আর বেবহারও করিও না। ");
INSERT INTO syl_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","মাথার দুইও গালার চুল ছাটা, বা দাড়ির আগা কাটিও না। ");
INSERT INTO syl_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","মুর্দার লাগি আহাজারি করাত গিয়া নিজর শরিলো জখম করিও না। গতরর মাজে কুনুজাত চাপ-ছবি আকিও না। আমিউ তো মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“টেকা রুজির নিয়তে নিজর পুড়িরে ছিলানি-বদমাইশিত লাগাইও না। আরনায় আস্তা দেশ জিনায় ভরিযিবো, পুরা দেশো খবিছি বাড়িবো। ");
INSERT INTO syl_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","আমার দেওয়া জুম্মাবারে জিরাইও, আর আমার কাবা ঘররে ইজ্জত করিও। আমিউ তো মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“জিন্নাত বা পেরত সাধক, গনক বা যাদু-টুনা কররার গেছে যাইও না, ইতার লগে মিশিও না। আরনায় ইতায় তুমরারে নাপাক বানাইলিবা। মনো রাখিও, আমি আল্লাউ তুমরার মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“মুরব্বি মানুষ ধারো আইলে তুমরা উবাইয়া ইজ্জত দিও। তুমরা নিজর আল্লার ডর-খফে রইও। আমিউ তো মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“তুমরার দেশো তুমরার লগে বসত কররা ভিন-দেশি মানষর উপরে জুলুম করিও না। ");
INSERT INTO syl_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","নিজর জাতির লগে যেলা বেবহার করো, তারার লগেও অলা বেবহার করিও, তারারে নিজর লাখান মায়া করিও। মনো রাখিও, তুমরাও মিসর দেশো ভিন-দেশি হালতে আছলায়, আর আমি আল্লাউ তুমরার মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“তুমরা কুনুজাত মাপ-জুকো আর পাল্লার উজনো বে-ইনছাফি করিও না। ");
INSERT INTO syl_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","তুমরার পাল্লা-পাথর, হের-ফুরা, নল-দড়ি, মাপর হকলতা যানু ঠিক-ঠাক থাকে। আমি আল্লাউ তুমরার মাবুদ, আর মিসর দেশ থাকি আমিউ তুমরারে বার করি আনছি। ");
INSERT INTO syl_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","আমার বাতাইল হকল নিয়ম-কানুন আর পুরাপুর শরিয়ত তুমরা মানিয়া চলিও। আমিউ তো মাবুদ।” ");
INSERT INTO syl_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","বাদে মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“তুমি বনি ইছরাইলরে জানাই দেও, তুমরার মাজর কুনু মানষে বা তুমরার লগে বসত কররা ভিন-দেশি কুনু মানষে যুদি তার পুয়া বা পুড়িরে মুলক দেবতার নামে বলি দেয়, তে অগুরে জানে মারিলিবায়, দেশর মানষে মিলিয়া পাথরদি ইটাইয়া তারে মারবায়। ");
INSERT INTO syl_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","হে নিজর পুয়া বা পুড়িরে আগুইনদি জালাইয়া মুলক দেবতার নামে বলি দিয়া, আমার কাবা ঘররে নাপাক বানাইছে আর আমার পাক-পবিত্র নামরে অসম্মান করছে। এরলাগি আমি তার খেতি করাত লাগমু, ই জাতির মাজ থাকি তার নাম মিটাইলিমু। ");
INSERT INTO syl_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","অউ দেবতার নামে তার পুয়া বা পুড়িরে বলি দেওয়ার সময়, ই দেশর মানষে যুদি দেখিয়াও না-দেখার ভান করইন, আর ই বলি দেওরারে জানে না মারইন, ");
INSERT INTO syl_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","তে আমি নিজে অউ নাফরমান আর তার পরিবারর খেতি করাত লাগিযিমু। আমি অগুর নাম আর অগুর লাখান আরো যেগুইন্তে ইলা নাফরমানি করবো, অতা হক্কলটির নাম বনি ইছরাইল সমাজ থাকি মিটাইলিমু। এরা তো আমার লগে বেইমানি করিয়া হউ মুলক দেবতার আতো নিজরে সপি দিছে। ");
INSERT INTO syl_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“কুনু মানষে যুদি আমার লগে বেইমানি করিয়া, জিন-ভুত সাধক বা গনকর লগে মিশিয়া নিজরে সপি দিলায়, তে তারও খেতি করাত লাগিযিমু আর ই জাতির মাজ থাকি তার নাম মিটাইলিমু। ");
INSERT INTO syl_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“তুমরা আমার লাগি নিজরে আলাদা করো আর পাক-পবিত্র অও। মনো রাখিও, আমি আল্লাউ তুমরার মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","আমার নিয়ম-কানুন পুরাপুর আমল করিও। আমিউ তো মাবুদ, আমিউ তুমরারে পাক-পবিত্র করি। ");
INSERT INTO syl_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“যে মানষে আপন মা-বাফরে গালি-গালাজ করিয়া বেইজ্জত করে, তারেও জানে মারবায়। অউ নাফরমানির দায় তার মউতর লাগি হে নিজেউ দায়ী। ");
INSERT INTO syl_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“কুনু মানষে যুদি আরি-ফরির কুনু জনর বউর লগে জিনা করে, তে অউ বেটা-বেটি দুইও জনরে জানে মারিলিবায়। ");
INSERT INTO syl_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","যে মানষে তার হাতন মাʼর লগে জিনা করে, হে তার বাফরে বেইজ্জত করে। এরলাগি তারে আর হাতন মাʼরে জানে মারবায়। তারার মউতর লাগি তো তারাউ দায়ী। ");
INSERT INTO syl_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“কুনু মানষে যুদি আপন পুয়ার বউর লগে জিনা করে, তে তারা দুইও জনরে জানে মারবায়। তারা মানব সমাজর উল্টা চলায়, তারার মউতর লাগি নিজেউ দায়ী। ");
INSERT INTO syl_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","কুনু বেটায় যুদি আরক বেটার লগে জিনা-পুংগামি করে, তে তারা দুইও জনেউ বড় খবিছি করছে, এরলাগি দুইও জনরে জানে মারিলিবায়, তারার মউতর লাগি তারাউ দায়ী। ");
INSERT INTO syl_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“কুনু বেটায় যুদি কুনু পুড়িরে আর তাইর মাʼরেও হাংগা করে, তে অউ বেটা আর মা-পুড়ি তিনো জনরে আগুইনদি জালাইয়া মারিলিবায়, যাতে ইলা নাফরমানি কাম তুমরার মাজে না ঘটে। ");
INSERT INTO syl_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","কুনু পশুর লগে কুনু মানষে জিনা করলে, হউ মানুষ আর পশু দুইওগুরে জানে মারবায়। ");
INSERT INTO syl_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","কুনু বেটিয়ে যুদি কুনু পশুর লগে জিনা করাত যায়, তে হউ বেটি আর পশুরেও জানে মারবায়। তারার মউতর লাগি তারাউ দায়ী। ");
INSERT INTO syl_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“কুনু বেটায় যুদি তার আপন বইন, হাতন মা বা হাতন বাফর ঘরর বইনর লগে শরিলি মিলা-মিশা করে, ইতা তো শরমর কাম। তারারে সমাজ থাকি হরাইলিবায়, আর হে সাজা পাইবো। ");
INSERT INTO syl_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","কুনু বেটি মানষর মাসিক বেমারর সময় তাইর লগে যে বেটায় শরিলি মিলা-মিশা করে, ই বেটিয়ে তো তাইর মাসিক কালর ইজ্জত দেয় না, আর ই বেটায়ও তাইর মাসিকরে দাম দেয় না। এরলাগি বনি ইছরাইল সমাজ থাকি ই দুইওগুর নাম মিটাইলিবায়। ");
INSERT INTO syl_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","কুনু বেটায় যানু তার খালা বা ফুফুর লগে জিনা না করে, আরনায় আপন লউর কুটুমরে বেইজ্জতি করায় তারা দুইও জনে সাজা পাইবো। ");
INSERT INTO syl_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","কেউ যুদি তার চাচী বা মামীর লগে জিনা করে, তে তারা দুইও জনে সাজা পাইবো, নিআওলাদি হালতে তারার মরন অইবো, হে তো তার চাচা বা মামারে বেইজ্জত করছে। ");
INSERT INTO syl_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","ভাই জিন্দা থাকতে যুদি আরক ভাইয়ে তার ভাবীরে হাংগা করে, তে তার ভাইরে বেইজ্জত করায়, ইটা বড় নাফরমানি। তারা কুনু আওলাদ পাইতা নায়। ");
INSERT INTO syl_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“তুমরা বসত করার লাগি আমি তুমরারে যে দেশো নিয়ার, হউ দেশর মাটিয়ে যানু তুমরারে বমি করিয়া না ফালায়। এরলাগি তুমরা আমার বাতাইল হকল শরিয়ত আর নিয়ম-কানুন অকল আমল করিও। ");
INSERT INTO syl_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","তুমরার ছামনে থাকি আমি যেতা জাতি অকলরে খেদাই দিরাম, ইতার চাল-চলনে তুমরা চলিও না। তারার হউ চাল-চলনর লাগিউ আমি তারারে লান্নত দিছি, ");
INSERT INTO syl_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","এরলাগিউ আমি তুমরারে ওয়াদা দিছলাম তারার দেশরে আমি তুমরার দখলে দিমু, তারার হউ দুধ আর মউর ভান্ডার আলা দেশ আমি তুমরারে দান করমু। আমি আল্লাউ তুমরার মাবুদ, জগতর হকল জাতি থাকি আমিউ তুমরারে আলাদা করছি। ");
INSERT INTO syl_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","এরলাগি তুমরা হালাল আর হারাম পশুইন্তর মাজে তফাত রাখিও, হালাল আর হারাম পাখিন্তর মাজে তফাত রাখিও। পশু-পাখি আর মাটির উপরে চলরা হুরু হুরু জানদারর মাজে যেতারে আমি হারাম কইছি, অতা দিয়া তুমরা নিজর শরিলরে নাপাক বানাইয়া লান্নতি বনিও না। ");
INSERT INTO syl_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","আমি মাবুদ তো পাক-পবিত্র, এরলাগি তুমরাও পবিত্র অইতে অইবো। আমার আপন প্রজা অওয়ার লাগি আমিউ তুমরারে জগতর হকল জাতি থাকি বাছিয়া আলগ করছি। ");
INSERT INTO syl_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“যেতা বেটা বা বেটিন্তে জিন-ভুত সাধন, গনক বা জাদু-টুনার কাম করে, ইতারে জানে মারিলিবায়। পাথরদি ইটাইয়া জানে মারিলিবায়, তারার মউতর লাগি তারাউ দায়ী।” ");
INSERT INTO syl_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","এরবাদে মাবুদে মুছারে কইলা, “তুমি হারুনর বংশর ইমাম অকলরে কইও, তারার কুনু কুটুম-খেশর মউতর কারনে মাত্তম করিয়া তারা যানু নিজরে নাপাক না বানায়। ");
INSERT INTO syl_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","খালি তারার নিজর মা-বাফ, পুয়া-পুড়ি বা আপন ভাই মারা গেলে তারা নিজরে নাপাক বানানি জাইজ আছে। ");
INSERT INTO syl_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","আর ভাইর ঘরো রওরা আবিয়াতি কুনু বইন মারা গেলে তাইরে দাফন-কাফনর লাগি তাইর ভাই নাপাক বনা জাইজ। ");
INSERT INTO syl_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","অইলে হউর বাড়ির কুনু কুটুম-খেশর মউতর দায় কুনু ইমাম ছাবে নিজর পবিত্র হালত থাকি নাপাক বনা জাইজ নায়। ");
INSERT INTO syl_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ইমাম ছাব অকলর মাথার চুল কামানি, দাড়ির আগা ছাটা, বা নিজর শরিলো কুনুজাত কাটা-চিরা করা জাইজ নায়। ");
INSERT INTO syl_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","তারা যানু আপন আল্লার পবিত্র নামরে অসম্মান না করইন, আর পাক-পাকিজা রইয়া জিন্দেগি কাটাইন। অখান মনো রাখইন যেন, অউ ইমাম অকলেউ মাবুদর নামে আগুনিত দেওয়া ছদগা আর কুরবানি অকল আদায় করইন, আর কুরবানির মাল তো নিজর আল্লার দরবারর রিজেক। ");
INSERT INTO syl_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","ইমাম অকলে কুনু বদমাইশ, ছিলান বা তালাক পাওয়া কুনু বেটিরে বিয়া করা জাইজ নায়। কারন তারার আপন আল্লার নামে তারা পবিত্র। ");
INSERT INTO syl_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","ও বনি ইছরাইল, তুমরা ইমাম ছাব অকলরে হামেশা পবিত্র হিসাবে মানিও, তারাউ তো তুমরার আল্লার দরবারো কুরবানির খানি সপিয়া দেইন। এরলাগিউ তারারে পবিত্র কইয়া মানিও, মনো রাখিও, আমিউ তুমরারে পবিত্র বানাইছি, আর আমি নিজে তো পাক-পবিত্র। ");
INSERT INTO syl_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","কুনু ইমামর পুড়ি যুদি ছিলানি-বদমাইশির পথে গিয়া নাপাক বনিযায়, তে তাইর বাফরেও তাই বেইজ্জত করিলায়। এরলাগি তাইরে আগুইনদি জালাইয়া মারিলিবায়। ");
INSERT INTO syl_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“আর ইমাম পরিবারর ভাইয়াইন্তর মাজে হকল বড় যেইন, এইনউ তো পরধান ইমাম, এন মাথাত খেলাফতি সমজিবার তেল ঢালা অইছে, খেলাফতি সমজিয়া তাইন পরধান ইমামর পবিত্র লেবাছ ফিন্দিবার দায়িত্ব পাইছইন। এরলাগি কুনু মুর্দার লাগিয়া কান্দন-আহাজারির নিয়তে তান মাথার পাউগড়ি খুলিয়া চুল আউলা-জাউলা করা, বা তান ফিন্নর লেবাছ ছিড়াও জাইজ নায়। ");
INSERT INTO syl_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","এইন কুনু মরা লাশর কান্দাত যাওয়া জাইজ নায়। নিজর মা-বাফ মারা গেলেও এইন নিজরে নাপাক বানানি জাইজ নায়। ");
INSERT INTO syl_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","যেকুনু মুর্দার লাগি তাইন আল্লার পবিত্র কাবা ঘর ছাড়িয়া কুনুখানো গিয়া আল্লার অউ ঘররে নাপাক বানানি তান লাগি হারাম। মনো রাখিও, তান আপন আল্লার নামর খেলাফতি সমজিবার তেল ঢালিয়া তানরে পবিত্র বানাইল অইছে। আমিউ তো মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“কুনু আবিয়াতি সতী কইনারে শাদি করা তান লাগি জাইজ আছে। ");
INSERT INTO syl_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","অইলে কুনু ড়াড়ি বেটি, বদমাইশ-ছিলান বেটি বা তালাক পাওয়া কুনু বেটিরে ইমাম ছাবে শাদি করা জাইজ নায়। খালি নিজর গুষ্টির কুনু আবিয়াতি সতী কইনারে শাদি করা তান লাগি জাইজ। ");
INSERT INTO syl_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","আরনায় তান কারনে তান নিজর খান্দানর মাজে তান আওলাদ অকল পবিত্র হালত থাকি নাপাক বনবো। আমিউ তো মাবুদ, আমিউ তানরে পাক-পবিত্র বানাইছি।” ");
INSERT INTO syl_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","এরবাদে মাবুদে মুছারে আরো কইলা, ");
INSERT INTO syl_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“তুমি ইমাম হারুনরে জানাই দেও, তান খান্দানর মাজর শরিলর খুত আলা কুনু জনেউ আল্লার নামে কুরবানি আদায় করার নিয়তে, কুরবানি খানার কান্দাত যাওয়া নিষেধ। ");
INSERT INTO syl_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","যে জনর শরিলো খুত আছে, মানি আন্দা, লেংড়া, নাক-কাটা, আত-পাও নিয়মর বেশি লাম্বা-বাট্টি বা আংগুইল কম-বেশি, ");
INSERT INTO syl_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","আত বা পাও ভাংগা, ");
INSERT INTO syl_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","পিঠ গুজা, বাট্টি ভেংগাই মানুষ, চউখর বেমারি, দাউদ-খাউজলি, পচা-ঘা বেমারি বা অন্ডকুস নষ্ট, ইলা খুত আলা কুনু মানুষ কুরবানি খানার কান্দাত যাওয়া জাইজ নায়। ");
INSERT INTO syl_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","ইমাম হারুনর বংশর শরিলর খুত আলা কুনু জনে মাবুদর নামে আগুনিত দেওয়া কুরবানি আদায় করা নিষেধ। তার গতরো খুত থাকায় হে কুরবানি খানার কান্দাত গিয়া আমার নামর খানিরে কুরবানি দেওয়া জাইজ নায়। ");
INSERT INTO syl_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","অইলে অউ কুরবানির খানি খাওয়া তার লাগি জাইজ, ইতা পবিত্র বা খাছ-পবিত্র অইলেও জাইজ আছে। ");
INSERT INTO syl_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","তার শরিলো খুত থাকায় হে কাবা ঘরর হেরেম শরিফর পর্দার কান্দাত বা কুরবানি খানার কান্দাত যাওয়া নিষেধ, হে যানু আমার পাক-পবিত্র জাগা অকলরে নাপাক না বানায়। মনো রাখিও, আমিউ মাবুদ, আর আমিউ অউ জাগাইন্তরে পবিত্র করি।” ");
INSERT INTO syl_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","বাদে মুছায় গিয়া ইতা হকলতা ইমাম হারুন, তান পুয়াইন আর হকল বনি ইছরাইলরে জানাইলা। ");
INSERT INTO syl_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","এরবাদে মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“তুমি ইমাম হারুন আর তার পুয়াইন্তরে কও, বনি ইছরাইলে আমার নামে লিল্লা আর কুরবানি দিবার নিয়তে যততা আনইন, ইতা তো পবিত্র। এরলাগি অতা হক্কলতারে ইমাম অকলে ইজ্জত-তাজিম করা জরুর। ই বেয়াপারে তারা যানু আমার পাক-পবিত্র নামরে অসম্মান না করে। আমিউ তো মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“তুমি তারারে জানাই দেও, তারার আওলাদর মাজর কেউ যুদি নাপাক হালতে মাবুদর নামে দেওয়া কুরবানির কুনু জিনিসর কান্দাত যায়, তে তারে আমার ছামন থাকি হরাইলিবায়। আমিউ তো মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","হারুনর আওলাদ অকলর মাজে কেউ যুদি পচা-কুষ্ঠ বেমারি বা ধাতু যাওয়া বেমারি অয়, তে পাক-ছাফ না অওয়া পর্যন্ত হে কুরবানির কুনুতা খাওয়া নাজাইজ। আর মরা লাশরে বা অউ লাশর লাগি যেতা কামো লাগাইল অইছে ইতা কুনুতা ছইয়া যুদি কেউ নাপাক বনে, বা কেউরর যৌবনর পানি বার অয়, ");
INSERT INTO syl_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","আর যে জন কুনুজাত মাটিত চলরা হুরু-মুরু নাপাক জানদার বা যেকুনু কারনে নাপাক অওয়া কুনু মানষরে ছইয়া হে নিজরে নাপাক বানায়, ");
INSERT INTO syl_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","তে হাইঞ্জা পর্যন্ত হে নাপাক হালতেউ রইবো, আর পানিদি নাইয়া হারি পাক-ছাফ না অওয়া পর্যন্ত কুরবানির কুনু পবিত্র জিনিস খাওয়া তার লাগি হারাম। ");
INSERT INTO syl_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","বাদে সুরুজ ডুবিয়া হারলে হে যেবলা পাক-ছাফ অইবো, অউ সময় হে ইতা খাইতো পারবো। ইতা তো তারউ খানি। ");
INSERT INTO syl_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","ইমামে কুনু মরা পশু বা জংলি জানুয়ারর থাবায় মারা কুনু পশুর গোস্ত খাইয়া নিজরে নাপাক বানাইও না। আমিউ তো মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ইমাম অকলর বেয়াপারে আমি যেতা আইন-কানুন দিছি, ইতা তারা মানিয়া চলউক। আরনায় দুষি বনবায় আর নাপাকির দরুন তারার মরন অইবো। মনো রাখিও, আমি মাবুদেউ তারারে পবিত্র করি। ");
INSERT INTO syl_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ইমাম পরিবারর মানুষ ছাড়া দুছরা কুনু জনে কুরবানির পবিত্র জিনিস খাওয়া নিষেধ। ইমামর কুনু মেহমান বা কামলায়ও ইতা খাওয়া হারাম। ");
INSERT INTO syl_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","অইলে ইমামর খরিদা গুলামে বা তান বাড়িত জন্মিছে ইলাখান গুলামে ইতা খাওয়া জাইজ। ");
INSERT INTO syl_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","ইমামর পুড়ি যুদি আরক ইমাম ছাড়া বাইরা কুনু দামান্দর লগে বিয়া-শাদি অয়, তে তাইও কুরবানির অউ পবিত্র জিনিস খাওয়া হারাম। ");
INSERT INTO syl_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","অইলে ইমামর কুনু ড়াড়ি পুড়ি বা তালাক পাওয়া নিআওলাদি কুনু পুড়ি যুদি বাফর বাড়িত রইবার লাগি হিরবার আইঅয়, তে তাই তো বাফর খানির অংশ পাইবো। “ইমাম পরিবারর বাইরা কুনু জনে কুরবানির পবিত্র কুনু খানি খাওয়া জাইজ নায়। ");
INSERT INTO syl_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","কেউ যুদি ভুল করিয়া ইতা খাইলায়, তে ই জনে ইমামর গেছে খেতি-পুরন দিতে অইবো। অউ খানির দামর লগে আরো পাচ বাটর এক বাট দাম বেশি দিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","বনি ইছরাইলে মাবুদর নামে তারার যে জিনিস পবিত্র কুরবানি হিসাবে দান করইন, ইমাম অকলে যানু ইতারে অপবিত্র না বানাইন। ");
INSERT INTO syl_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","তারা বাইরা মানষরে ইতা খাইতে দিয়া মানষরে দুষি বানাইয়া খেতি-পুরনর দাড়ো যানু না ফালাইন। মনো রাখিও, আমি মাবুদেই তারারে পবিত্র করি।” ");
INSERT INTO syl_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","বাদে মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“তুমি গিয়া ইমাম হারুন, তার পুয়াইন আর হকল বনি ইছরাইলরে কও, তুমরার কুনু মানষে বা তুমরার লগে বসত কররা ভিন-দেশি কুনু জনে যুদি মান্নত আদায় করার লাগি বা নিজর খুশিয়ে নফল কুরবানি হিসাবে মাবুদর নামে জালাইল কুরবানি দিবার নিয়তে কুনুতা লইয়া আয়, ");
INSERT INTO syl_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","তে ইকটা অইতে অইবো এগু নিখুত বিছাল, মেড়া বা ছাগলর পাঠা। ইলা না অইলে তো মাবুদে কবুল করতা নায়। ");
INSERT INTO syl_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","খুত আলা কুনু পশুদি যানু কুরবানি আদায় না করে, করলেও তার কুনু ফায়দা অইতো নায়। ");
INSERT INTO syl_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","কুনু মান্নত আদায় করার লাগি বা নিজর খুশিয়ে নফল কুরবানি হিসাবে কেউ যুদি মাবুদর নামে ছালামতি কুরবানি দিতো চায়, তে ইতার লাগি এগু নিখুত গরু, মেড়া বা ছাগল আনতে অইবো। গতরো খুত আলা কুনু পশুদি কুরবানি দিলে ইতা কবুল অইতো নায়। ");
INSERT INTO syl_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","কুনু মানষে যানু কুরবানির নিয়তে আন্দা, লেংড়া, কাটা-চিরা, কুনু অংগ কাটা, পুজআলা ঘা, বা দাউদ-খাউজলি কুনু পশুরে মাবুদর দরবারো না আনে, জালাইল কুরবানির লাগি অলা খুত আলা কুনু পশুরে কুরবানি খানার উপরে তুলিও না। ");
INSERT INTO syl_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","তা-ও পশুর কুনু অংগ নিয়মর বেশি লাম্বা বা বাট্টি থাকলে, অলাখান পশুরে নিজর খুশিয়ে নফল কুরবানি হিসাবে দিতা পারবা, অইলে কুনু মান্নত পুরনর লাগি ইলাখান কুরবানি কবুল অইতো নায়। ");
INSERT INTO syl_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","কুনু পশুর অন্ডকুস যুদি থেতলা, ছেচা, কাটা-চিরা থাকে, তে ইতারে তুমরা মাবুদর নামে কুরবানি দিও না, নিজর দেশো গিয়া ইলা করিও না। ");
INSERT INTO syl_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","ভিন জাতির কুনু মানষর গেছ থাকি অলাখান পশু আনিয়া তুমরার আল্লার নামে কুরবানি দিও না। ইতার গতরো খুত থাকায় ইতাদি কুরবানি দিলে তুমরার কুনু ফায়দা অইতো নায়।” ");
INSERT INTO syl_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","বাদে মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“জন্মর বাদ থাকি সাত দিন পর্যন্ত গরু বা ছাগল বা মেড়া-বাইচ্চারে তার মাʼর লগে রইতে দিবায়। আট নম্বর দিন থাকি ইতারে মাবুদর নামে আগুনিত দেওয়া কুরবানি হিসাবে দেওয়া যাইবো। ");
INSERT INTO syl_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","তা-ও গাই আর তাইর বাছুররে, মেড়ি বা ছাগি আর তাইর বাইচ্চারে, একই দিনে জবো করা হারাম। ");
INSERT INTO syl_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","তুমরা মাবুদর নামে কুনু শুকুরানা কুরবানি দিতে চাইলে, ইতা অউ নমুনায় আদায় করিও যেলা তাইন খুশি অইন। ");
INSERT INTO syl_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","কুরবানির গোস্ত কুরবানির দিনর মাজে খাইলিতে অইবো, ইতা বাদর দিন বিয়ান পর্যন্ত থওয়া হারাম। আমিউ তো মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“তুমরা আমার হুকুম মানিও আর অউ লাখান চলিও। আমিউ তো মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","তুমরা আমার পাক-পবিত্র নামরে অসম্মান করিও না, যাতে বনি ইছরাইলর মাজে আমি পাক-পবিত্র হিসাবে গইন্য অই। আমি আল্লায় তুমরারে পাক-পবিত্র বানাই। ");
INSERT INTO syl_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","আমি তুমরার মাবুদ অওয়ার নিয়তে তুমরারে মিসর দেশ থাকি বার করি আনছি। আমিউ তো মাবুদ।” ");
INSERT INTO syl_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","বাদে মাবুদে মুছা নবীরে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“তুমি বনি ইছরাইলরে জানাই দেও, আমি মাবুদে তুমরার লাগি অউ ইদ অকল ঠিক করলাম, তুমরা ইতারে পবিত্র মিলন-মাহফিলর দিন হিসাবে মানবায়। ");
INSERT INTO syl_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“হাপ্তাত ছয় দিন তুমরা কাম-কাজ করিও, আর সাত নম্বর দিন অইলো জিরাইবার দিন, পবিত্র মিলন-মাহফিলর জুম্মাবার। ই দিন তুমরা কুনু কাম-কাজ করিও না, তুমরা যেকুনু জাগাত বসত করো, ই দিন খান তুমরার মাবুদর নামে পবিত্র জুম্মাবার হিসাবে মানিও। ");
INSERT INTO syl_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“তুমরার লাগি আমার ঠিক করা যত ইদ আছে, মানি পবিত্র মিলন-মাহফিলর দিন হিসাবে যেতা মানতায়, ইতা আমি কইরাম। ইতা অইলো: ");
INSERT INTO syl_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“বছরর পয়লা চান্দর চৌদ্দ তারিখর হাইঞ্জা থাকি মাবুদর নামে আজাদি ইদ আরম্ভ অইবো, ");
INSERT INTO syl_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","আর অউ চান্দর পনরো তারিখো মাবুদর নামে খামির ছাড়া রুটির ইদ আরম্ভ অইবো। পুরা সাত দিন তুমরা খামির ছাড়া রুটি খাইবায়। ");
INSERT INTO syl_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","অউ সাত দিনর পয়লা দিন তুমরার পবিত্র মিলন-মাহফিল অইবো, অউ দিন দুনিয়াবি নিয়তে কুনুজাত কাম-কাজ করা তুমরার লাগি হারাম। ");
INSERT INTO syl_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","অউ সাত দিনর পরতেক দিন তুমরা মাবুদর নামে আগুনিত দেওয়া কুরবানি দিবায়। বাদে সাত নম্বর দিন তুমরার পবিত্র মিলন-মাহফিল অইবো, অউ দিন তুমরা দুনিয়াবি নিয়তে কুনু কাম-কাজ করা হারাম।” ");
INSERT INTO syl_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","মাবুদে মুছা নবীরে আরো কইলা, ");
INSERT INTO syl_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“তুমি বনি ইছরাইলরে জানাই দেও, আমি মাবুদে তুমরারে যে দেশ অকলর মালিকানা দিরাম, হনো গিয়া হারলে তুমরা যতবার জমিনর ফসল দাইবায়, অতবার খেতর পয়লা কাটা একখান মুইট লইয়া ইমাম ছাবর গেছে যাইও। ");
INSERT INTO syl_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","গেলে ইমামে অউ মুইট নিয়া মাবুদর ছামনে দুলাইবা। জুম্মাবারর বাদর দিন তাইন ইখান দুলাইবা, তেউ মাবুদ তুমরার উপরে খুশি অইবা। ");
INSERT INTO syl_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","ইমাম ছাবে যেদিন অউ মুইট দুলাইবা, অউ দিন তুমরা মাবুদর নামে এক বছর বয়সি এগু নিখুত মেড়া-বাইচ্চারে জালাইল কুরবানি হিসাবে দিবায়। ");
INSERT INTO syl_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","এরলগে ধান-গমর ছদগার লাগি তেল মাখাইল চাইর সের ময়দা দিবায়। ইতা তো মাবুদর নামর আগুনিত দেওয়া ছদগা, ইতার ধুমার ঘেরানে তাইন খুশি অইন। আর এর লগর শরবত-পানির ছদগার নিয়তে আংগুরর এক সের শরবতও দিবায়। ");
INSERT INTO syl_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","তুমরার খেতর ফসল দাইয়া হারি, তুমরার আল্লার নামর অউ ছদগা আদায় করার আগ পর্যন্ত নয়া ফসল তুমরা খাইও না। ইতাদি রুটি বানাইয়া বা আগুনিত ভাজিয়া খাওয়াও নিষেধ। তুমরা যেনোউ রও না কেনে, ওয়ারিশর পর ওয়ারিশ ধরি চিরকাল অউ নিয়ম মানিও। ");
INSERT INTO syl_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“আর অউ জুম্মাবারর বাদর দিন, মানি যেদিন দুলনা কুরবানি লাগি ফসলর মুইট লইয়া আইবায়, অউ দিন থাকি সাত হাপ্তায় সাত জুম্মাবার গনিবায়। ");
INSERT INTO syl_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","অউ সাত জুম্মার বাদর দিন, মানি পইঞ্চাশ দিনর দিন তুমরা মাবুদর নামে নয়া ফসলর ছদগা আদায় করবায়। ");
INSERT INTO syl_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","তুমরা নিজর বাড়ি থাকি মাবুদর নামে দুলনা কুরবানি দিবার নিয়তে খেতর পয়লা ফসল থাকি কিছু ফসল আনিও। তুমরা চাইর সের ময়দাদি বানাইল খামির পুরাইল দুখান নান রুটি আনিও। ");
INSERT INTO syl_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","অউ রুটির লগে এক বছর বয়সি সাতটা নিখুত মেড়া-বাইচ্চা, একটা বিছাল, মেড়ার দুইটা পাঠা আনিও। অউ পশু অকল দিয়া মাবুদর নামে একখান জালাইল কুরবানি আদায় করবায়, অতার লগে নিয়ম মাফিক ধান-গমর ছদগা আর শরবত-পানির ছদগাও দিবায়। ইতা তো আগুনিত দেওয়া এক নমুনার কুরবানি, ইতার ধুমার ঘেরানে মাবুদ খুশি অইন। ");
INSERT INTO syl_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","বাদে তুমরা গুনার কফরার কুরবানি হিসাবে এগু পাঠা ছাগল, আর ছালামতি কুরবানির লাগি এক বছর বয়সি দুগু মেড়া-বাইচ্চা কুরবানি দিবায়। ");
INSERT INTO syl_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","ইমাম ছাবে দুলনা কুরবানি হিসাবে মাবুদর ছামনে অউ দুইও মেড়া-বাইচ্চা আর খেতর পয়লা ফসলদি বানাইল রুটি নিয়া দুলাইবা। ইতা তো মাবুদর নামর কুরবানির পাক-পবিত্র ছামানা, ইতা ইমাম ছাবর পাওনা। ");
INSERT INTO syl_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","খেতর ফসল দাওয়ার অউ ইদর দিন তুমরা একটা পবিত্র মিলন-মাহফিল করিও। অউ দিন দুনিয়াবি নিয়তে কুনু কাম-কাজ করিও না। তুমরা যেনোউ রও না কেনে, ওয়ারিশর পর ওয়ারিশ ধরি হর-হামেশা ইতা আমল করিও। ");
INSERT INTO syl_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“তুমরা যেবলা খেতর ফসল দাইবায়, অউ সময় তুমরা জমিনর আইলর কান্দার ফসল ছাফ করিয়া কাটিও না, আর দাওয়ার বাদে অউ জমিনো ফালাইল ফসল লুরিও না। গরিব-দুখি আর বিদেশি মুছাফিরর লাগি ইতা থইও। মনো রাখিও, আমি আল্লাউ তুমরার মাবুদ।” ");
INSERT INTO syl_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","বাদে মাবুদে মুছা নবীরে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“তুমি বনি ইছরাইলরে জানাই দেও, বছরর সাত নম্বর চান্দর পয়লা দিনরে তুমরা পুরাপুর জিরানির দিন হিসাবে মানিও। অউ দিন তুমরা শিংগা বাজাইও আর হকলে মিলিয়া ইদর পবিত্র মিলন-মাহফিল করিও। ");
INSERT INTO syl_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","অউ দিন তুমরা দুনিয়াবি নিয়তে কুনু কাম-কাজ করিও না, খালি মাবুদর নামে আগুনিত দেওয়া ছদগা আদায় করিও।” ");
INSERT INTO syl_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“অউ সাত নম্বর চান্দর দশ নম্বর দিন অইলো কফরার ইদর দিন। ই দিন তুমরা একটা পবিত্র মিলন-মাহফিল করিও। পরতেক জনে নত অইয়া যারযির দিল সপিয়া দিয়া মাবুদর নামে আগুনিত দেওয়া ছদগা আদায় করিও। ");
INSERT INTO syl_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ইতা অইলো কফরার ইদ, তুমরার মাবুদ আল্লার ছামনে তুমরার গুনার কফরা আদায় করা অইবো, আস্তা ই দিনো কুনুজাত কাম-কাজ করা হারাম। ");
INSERT INTO syl_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","যে মানষে হউ দিন নত অইয়া নিজর দিল সপিয়া না দেয়, তার নাম ই জাতির মাজ থাকি মিটাইলিবায়। ");
INSERT INTO syl_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","আর হউ দিন যুদি কেউ কুনু কাম-কাজ করে, তে তার নাম আমি ই জাতির মাজ থাকি শেষ করিলিমু। ");
INSERT INTO syl_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","অউ দিন তুমরা কুনুজাত কাম-কাজ করিও না। তুমরা যেনোউ রও না কেনে, ওয়ারিশর পর ওয়ারিশ ধরি হর-হামেশা অউ নিয়ম মানিও। ");
INSERT INTO syl_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","অউ দিন অইবো তুমরার লাগি পবিত্র জুম্মার দিন, এরলাগি নত অইয়া দিল সপিয়া দিও। অউ চান্দর নয় নম্বর দিনর হাইঞ্জা থাকি বাদর দিন হাইঞ্জা পর্যন্ত পবিত্র অউ জুম্মার দিন মানিও।” ");
INSERT INTO syl_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","এরবাদে মাবুদে মুছা নবীরে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“তুমি বনি ইছরাইলরে কও, অউ সাত নম্বর চান্দর পনরো তারিখ থাকি মাবুদর নামে ডেরা-ঘরর ইদ আরম্ভ অইয়া, সাত দিন পর্যন্ত ইদ চলবো। ");
INSERT INTO syl_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","অউ সাত দিনর পয়লা দিন তুমরার পবিত্র মিলন-মাহফিল অইবো। ই দিন তুমরা দুনিয়াবি নিয়তে কুনু কাম-কাজ করিও না। ");
INSERT INTO syl_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","অউ ইদর সাতো দিন তুমরা মাবুদর নামে আগুনিত দেওয়া কুরবানি আদায় করবায়। বাদে আট নম্বর দিনো তুমরা হিরবার পবিত্র মিলন-মাহফিল করবায় আর মাবুদর নামে আগুনিত দেওয়া কুরবানি দিবায়। ইটা অইলো শেষ দিনর আখেরি মাহফিল, অউ দিনও তুমরা দুনিয়াবি নিয়তে কুনু কাম-কাজ করিও না। ");
INSERT INTO syl_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“আস্তা বছরর মাজে যত লাখান ইদ আছে, অতা হক্কল জাতর ইদ অকল তো মাবুদেউ ধাইর্য করি দিছইন। এরলাগি ইদর অউ দিন অকলরে তুমরা পবিত্র মিলন-মাহফিলর দিন হিসাবে মানিও, এর পরতেক দিন যেতা যেতা করা জরুর, ইতা আদায় করিও। মানি, জালাইল কুরবানি, ধান-গমর ছদগা, নিজর খুশিয়ে ছালামতি কুরবানি, আর এর লগর শরবত-পানির ছদগা। অউ কুরবানি অকল আল্লার ধাইর্য করা দিনো তুমরা আদায় করিও। ");
INSERT INTO syl_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","অইলে খিয়াল রাখিও, তুমরারে বাতাইল অতা হক্কল লাখান ইদ অকলর কুরবানি আর লিল্লা-ছদগারে আদায় করিয়া, মাবুদর নামে জুম্মাবারর কুরবানি, হকল নমুনার লিল্লা-ছদগা, মান্নত আর নিজর খুশিয়ে দেওয়া ছালামতি কুরবানিরেও আদায় করিও। হতা ইদ অকলর কুরবানির লগে ইতারে মিলাইও না, আলাদা রাখিও। ");
INSERT INTO syl_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“আর সাত নম্বর চান্দর পনরো তারিখো, খেতর হকল ফল-ফসল তুলার বাদে, তুমরা মাবুদর নামে সাত দিন ধরিয়া ডেরা-ঘরর অউ ইদ আদায় করিও। অউ সাত দিনর পয়লা দিন আর শেষর আট নম্বর দিন অইলো তুমরার পুরাপুর জিরাইবার দিন। ");
INSERT INTO syl_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","এর পয়লা দিন তুমরা তরতাজা গাছর ডাল পালা, মানি খেজুর পাতা, হকল নমুনার পাতা-বাহার গাছর ডাল পালা, আর গাংগর পারর ইজল গাছর ডাল লইয়া আজির অইও। অইয়া অউ সাতো দিন তুমরা নিজর মাবুদ আল্লার ছামনে খুশি-বাসি করিও। ");
INSERT INTO syl_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","পরতেক বছরর সাত নম্বর চান্দর সাত দিন তুমরা মাবুদর নামে ই ইদ আদায় করিও। ওয়ারিশর পর ওয়ারিশ ধরি হর-হামেশা ইতা মানিও। ");
INSERT INTO syl_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","পুরা সাত দিন তুমরা হকল গিয়া ডেরা-ঘরো রইও, বনি ইছরাইলর হকল মানুষ অউ সময় ডেরা-ঘরো থাকিও। ");
INSERT INTO syl_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","তেউ অতা দেখিয়া হারি তুমরার আওলাদ অকলেও বুজবা, বনি ইছরাইলরে মিসর দেশ থাকি বার করি আনিয়া হারলে আমি মরুভুমির মাজে তারারে অলা ডেরা-ঘরো বসত করাইছলাম। মনো রাখিও, আমি আল্লাউ তুমরার মাবুদ।” ");
INSERT INTO syl_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","এরবাদে মুছা নবী গিয়া মাবুদর বাতাইল অউ হকল ইদর কথা বনি ইছরাইলরে জানাইলা। ");
INSERT INTO syl_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","বাদে মাবুদে মুছা নবীরে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“তুমি বনি ইছরাইলরে হুকুম দেও, চেরাগ দানির চেরাগ অকল হামেশা জালাইয়া রাখার নিয়তে, তারা জয়তুন ছেচিয়া খাটি তেল বানাইয়া তুমার গেছে লইয়া আইতো। ");
INSERT INTO syl_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","আর কাবা ঘরর ভিতরে শাহাদত সন্দুকর পর্দার বারে, ইমাম হারুনে হাইঞ্জা থাকি ফজর পর্যন্ত চেরাগ দানির চেরাগ অকল জালাই রাখবা। ওয়ারিশর পর ওয়ারিশ ধরি হর-হামেশা ইতা জারি রইবো। ");
INSERT INTO syl_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","মাবুদর ছামনে থওয়া অউ খাটি সোনার চেরাগ দানির চেরাগ অকলরে তাইন হামেশা যায়-যতন করবা। ");
INSERT INTO syl_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“আর হুনো, ময়দা দিয়া বারো খান রুটি বানাইও, পরতেক রুটি অইবো দুই সের ময়দার। ");
INSERT INTO syl_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","বানাইয়া অউ রুটিরে মাবুদর ছামনর খাটি সোনার টেবুলর উপরে ছয়খান ছয়খান করি দুই লাইনে হাজাই থইও। ");
INSERT INTO syl_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","পরতেক লাইনর রুটির ধারো খাটি লোবান-আগর থইও। থইয়া নিশানা হিসাবে রুটির বদলা অউ আগরদি মাবুদর নামে আগুনিত দেওয়া কুরবানি আদায় করিও। ");
INSERT INTO syl_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","পরতেক জুম্মাবারে বনি ইছরাইলর পক্ষ থাকি পবিত্র অউ রুটিরে ইমাম ছাবে মাবুদর নজরর ছামনে হাজাইয়া থইবা। তারার অউ রুটি দেওয়া তো হর-হামেশা চিরকাল জারি রইবো। ");
INSERT INTO syl_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","বাদে ইমাম হারুন আর তান বংশধরে পবিত্র কাবা ঘরর সীমানার ভিতরে অউ রুটি খাইবা, ইতা অইলো মাবুদর নামে আগুনিত দেওয়া কুরবানির জিনিসর মাজে এক খাছ পবিত্র জিনিস। ইতা তো ইমাম অকলর পাওনা, অউ নিয়ম হর-হামেশা জারি রইবো।” ");
INSERT INTO syl_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","বনি ইছরাইলর মাজে অলা এক বেটা আছিল, যেগুর বাফ অইলো মিসরী আর মা বনি ইছরাইল জাতির। ই বেটায় আর বনি ইছরাইলর আরক বেটায় কেম্পর ভিতরে মারামারি লাগলো। ");
INSERT INTO syl_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","অউ সময় বনি ইছরাইলি বেটির পুয়ায় মাবুদর নামে কুফুরি মাত মাতিয়া লান্নত দিলো। ইতা হুনিয়া মানষে তারে মুছা নবীর গেছে লইয়া গেলা। অউ বেটার মাʼর নাম শালোমি, তাই আছিল দান খান্দানর দিবরির পুড়ি। ");
INSERT INTO syl_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","আর মানষে অউ বেয়াপারে মাবুদর মর্জি হুনার লাগি অউ বেটারে আটকাইয়া থইলা। ");
INSERT INTO syl_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","বাদে মাবুদে মুছা নবীরে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“আমার নামে লান্নত দেওরা অউ বেটারে লইয়া কেম্পর বারে যাও। গেলে যেতা মানষে অউ কুফুরি মাত হুনছে, তারা হকলে অগুর মাথা আতাই দেউক, বাদে সমাজর হকল মানষে পাথর মারিয়া তারে জানে মারউক। ");
INSERT INTO syl_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","আর তুমি বনি ইছরাইলরে জানাই দেও, যে মানষে আল্লারে লান্নত দেয়, তার নাফরমানির লাগি হে নিজেউ দায়ী। ");
INSERT INTO syl_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","আর যে মানষে মাবুদর নামে কুফুরি মাত মাতিবো, তারে জানে মারিলিবায়। বনি ইছরাইলর সমাজে তারে পাথর মারিয়া জানে মারবা। হে বনি ইছরাইলি অউক বা তারার লগে বসত কররা ভিন জাতির মানুষ অউক, আল্লার নামে যেগিয়ে কুফুরি মাত মাতিবো, তারে নিচ্চিত জানে মারবায়। ");
INSERT INTO syl_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“কুনু মানষে যুদি দুছরা মানষরে খুন করিলায়, তে তুমরা তারেও খুন করবায়। ");
INSERT INTO syl_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","কুনু মানষে যুদি দুছরা মানষর কুনু পশুরে মারিলায়, তে অগুর বদলা হে আরক পশুর দাম দিয়া খেতি-পুরন দিবো। জানর বদলা জান। ");
INSERT INTO syl_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","কেউ যুদি আরক জনরে মারে, আর অউ মাইরর লাগি শরিলর কুনু অংগর খেতি অয়, তে হে যেলা খেতি করছে, তার অংগরেও অলা খেতি করবায়। ");
INSERT INTO syl_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","আড্ডি ভাংগার বদলা আড্ডি ভাংগিবায়, চউখর বদলা চউখ, দাতর বদলা দাত। হউ জনর যে অংগরে হে খেতি করছে, তারও অলা খেতি করবায়। ");
INSERT INTO syl_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","কুনু পশুরে জানে মারলে এর খেতি-পুরন দিতে অইবো, অইলে কুনু মানুষরে খুন করলে তারেউ জানে মারিলিবায়। ");
INSERT INTO syl_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","বনি ইছরাইল বা তুমরার লগে বসত কররা ভিন জাতির মানষর লাগি অউ একই আইন জারি রইবো। মনো রাখিও, আমি আল্লাউ তুমরার মাবুদ।” ");
INSERT INTO syl_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","বাদে মুছা নবীয়ে বনি ইছরাইলরে ইতা হকলতা জানাইলা। তেউ যে বেটায় হউ কুফুরি মাতিছিল, মানষে অগুরে কেম্পর বারে নিয়া পাথর মারিয়া জানে মারিলিলা। মাবুদে মুছারে যেলা হুকুম দিছলা, বনি ইছরাইলে ঠিক অলাউ করলা। ");
INSERT INTO syl_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","আর মাবুদে তুর পাহাড়র উপরে মুছা নবীরে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“তুমি বনি ইছরাইলরে জানাই দেও, আমি যে দেশখান তুমরারে দিয়ার, হউ দেশো গিয়া হারলে তুমরা খিয়াল রাখিও, হনর জমি-মাটিয়ে যানু মাবুদর নামে আরাম করার সময় পায়। ");
INSERT INTO syl_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","তুমরা ছয় বছর জমিনো খেত-খামার করিও, আংগুর গাছর ডাল পালা ছাটিয়া ফয়-ফসল বাড়িত আনিও। ");
INSERT INTO syl_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","অইলে সাত নম্বর বছর জমি-জমারে জিরানির সুযোগ দিও। ইটা অইলো মাবুদর নিয়তে আরামর বছর। অউ বছর তুমরা জমিনো খেত করিও না, আংগুর গাছর ডাল পালা ছাটিও না। ");
INSERT INTO syl_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","আর জমিনর মাজে এমনেউ যেতা ফলিবো, ইতা নিয়া তুমরার উগারো থইও না। বিনা যতনে আংগুর গাছো যেতা ফল ধরবো, ইতা পাড়িয়া নিয়া জমাইও না। হকল জমি-জমারে পুরা এক বছর জিরানির সময় দিও। ");
INSERT INTO syl_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","জিরানির বছর জমিনো এমনে যেতা ফলিবো, ইতা তো তুমরা নিজর, তুমরার গুলাম-বান্দির, তুমরার দেশর ভিন-দেশি মুছাফির, তুমরার সমাজর মেনতি কামলা, হকল জাতর মানষর, ");
INSERT INTO syl_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","তুমরার পালা হেমান, আর দেশর জংলি জানুয়ারর খানি-খুরাক অইবো। অউ বছর জমিনো এমনে যেতা ফলিবো, ইতা তুমরা হকলে খাইও। ");
INSERT INTO syl_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“আর হুনো, সাত বছর করি করি সাতখান জিরানির বছররে তুমরা গনিও, গনিলে সাতবার সাত বছরে উনুপইঞ্চাশ বছর অইবো। ");
INSERT INTO syl_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","এর বাদর বছর, মানি পইঞ্চাশ নম্বর বছর, অউ বছরর সাত নম্বর চান্দর দশ নম্বর দিন, ইতা তো গুনার কফরা আদায় করার দিন, হউ দিন তুমরা আস্তা দেশর হকল জাগাত শিংগা বাজাইও। ");
INSERT INTO syl_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","অউ পইঞ্চাশ নম্বর বছররে তুমরা পাক-পবিত্র মানিও, দেশর হকল মানষরে আজাদির কথা জানাইও। ই বছর অইলো তুমরার জমি-মিরাস ফিরত পাওয়ার বছর। অউ বছর তুমরা যারযির পরিবার আর খান্দানর জমি-জমার দখলদারি ফিরত পাইবায়। ");
INSERT INTO syl_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","পরতেক পইঞ্চাশ নম্বর বছর অইবো, তুমরার দখলদারি ফিরত পাওয়ার বছর। অউ বছর তুমরা জমিনো কুনু বিচি বাইন করিও না, জমিনো এমনেউ যেতা জন্মিবো ইতা তুমরা নিও না। আর বিনা যতনে আংগুর গাছো যেতা ফল ধরবো, ইতাও তুমরা ঘরো আনিও না। ");
INSERT INTO syl_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","অউ বছর অইলো ফিরত পাইবার বছর। তুমরা অউ বছররে পাক-পবিত্র হিসাবে মানিও। জমিনো যেতা ফসল পাইবায়, অতাউ তুমরা খাইও। ");
INSERT INTO syl_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ফিরত পাওয়ার বছরো তুমরা পরতেকে যারযির পরিবারর জমি-মিরাসো ফিরিয়া যাইও। ");
INSERT INTO syl_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","নিজর জমি-জমা খরিদ-বিকির সময় তুমরা আপন বা পর কেউরর উপরে জুর-জবরদস্তি করিও না। ");
INSERT INTO syl_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","জমি খরিদ করার সময় খরিদ-বিকি কররা দুইও জনে খিয়াল রাখবায়, ফিরত আওয়ার হউ পইঞ্চাশ বছর বাদে কতদিন গেছেগি, আর ছামনর পইঞ্চাশ বছর পুরতে কতদিন বাকি আছে, অখান হিসাব করিয়া জমিনর দরদাম ঠিক করবায়। ");
INSERT INTO syl_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","যুদি বেশি বছর ফসল পাওয়ার সময় থাকে তে দামও বেশি অইবো, আর কম অইলে দামও কমবো। আসলে ফসল পাওয়ার বছরর উপরেউ খরিদ-বিকির দাম ঠিক অইবো। ");
INSERT INTO syl_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","তুমরা নিজর সমাজর কেউরর উপরে জুর-জুলুম করিও না। পরতেক জনউ আল্লার ডর-খফে চলিও। মনো রাখিও, আমি আল্লাউ তুমরার মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“তুমরা আমার বাতাইল শরিয়ত আর হকল হুকুম-আহকাম হামেশা মানিও। তেউ তুমরার দেশ অইবো নিরাপদ বসত খানা। ");
INSERT INTO syl_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","আর তুমরার খেতর জমিন থাকি ষোলআনা ফসল পাইবায়, পাইয়া পেট ভরি খাইয়া দাইয়া হনো নিরাপদে বসত করবায়। ");
INSERT INTO syl_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","তুমরা মনে মনে কইতায় পারো, সাত নম্বর বছরো যুদি কুনু খেত না করি আর ফসল না কাটি, তে আমরা খাইমু কিতা? ");
INSERT INTO syl_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","এর জুয়াপ অইলো, ছয় নম্বর বছরো আমি তুমরার জমিনো অলা রহম-বরকত দিমু, জমিনো তিন বছরর হমান ফসল পাইয়া খাইয়া-ফিন্দিয়া বাচবায়। ");
INSERT INTO syl_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","এরলাগি আট নম্বর বছরো খেত করার বিচ বাইন দেওয়ার সময়ও অউ পুরানা ফসল খাইবায়, আর নয় নম্বর বছরর ফসল দাইবার আগ পর্যন্ত অউ ফসলেউ তুমরার খানি-খুরাকি চলবো। ");
INSERT INTO syl_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“মনো রাখিও, চিরকালর লাগি কেউরর জমি-জমা খরিদ-বিকি চলতো নায়। আসলে হকল জমিনর মালিক তো আমি আল্লা, তুমরা আমার ছামনে হনো খালি ভিন-দেশি মুছাফির। ");
INSERT INTO syl_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","তুমরা পরতেক জনর খরিদা জমি-মিরাস বিকিদাররে হিরবার ফিরত নিবার সুযোগ দিও। ");
INSERT INTO syl_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","তুমরার জাতির কুনু ভাই অভাবো পড়িয়া যুদি তার পরিবারর জমিনর কিছু অংশ বেচিলায়, তে তার হকল থাকি আপন জনে আইয়া অউ বেচা জমি ছাড়াইয়া নিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","কেউরর যুদি ছাড়াইয়া নিবার মানুষ না থাকে, তে হে নিজে ধন-ছামানা জমাইয়া হারি নিজেউ যুদি ছাড়াইয়া নিতো চায়, ");
INSERT INTO syl_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","তে তার বিকির বছর থাকি ছাড়ানি পর্যন্ত সময় হিসাব করিয়া, মালিকর পাওনা টেকা দিয়া তার জমি ফিরত নিবো। ");
INSERT INTO syl_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","অইলে জমি ফিরত নিবার ছামানা হে জমাইতে না পারলে, তার বেচা জমিন ফিরত পাওয়ার হউ পইঞ্চাশ বছর পুরার আগ পর্যন্ত খরিদদারে খাইবা, আর পইঞ্চাশ বছরর কালো তারে ফিরত দিবা, হে তার জমিন এমনেউ বিনা পয়সায় ফিরত পাইবো। ");
INSERT INTO syl_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“আর বাউন্ডরি করা নিরাপদ টাউনর কুনু বাসা-বাড়ি যুদি কেউ বেচিলায়, তে বেচার বাদে পুরা এক বছরর মাজে হে অউ বাড়ি ফিরত নিতো পারবো। পুরা এক বছরর মাজে হে ফিরত নিবার সুযোগ পাইবো। ");
INSERT INTO syl_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","এক বছরর মাজে ইটা ফিরত না নিলে, চিরকালর লাগি অউ বাড়ি খরিদদার আর তার ওয়ারিশর অইবো। ফিরত পাওয়ার বছরো ইটা ফিরত পাইতো নায়। ");
INSERT INTO syl_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","অইলে যেতা গাউ-গেরামো কুনু বাউন্ডরি নায়, অউ জাগার বাড়ি-ঘররে খেতর জমিনর লাখান মনো করবায়। ইতা ছাড়াইয়া আনা যাইবো, আর ফিরত পাওয়ার বছরো ফিরত দিতে অইবোউ। ");
INSERT INTO syl_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“খালি লেবি খান্দানর টাউনর বাড়ি-ঘর অকল হামেশা ফিরত আনা যাইবো। ");
INSERT INTO syl_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","তারার টাউনর কুনু বাড়ি-ঘর বেচিলে, ফিরত পাওয়ার বছরো ইটা ফিরত পাইবা। তুমরার তো জানা আছে, খালি টাউনর বাড়ি-ঘরউ অইলো লেবি খান্দানর সম্পত্তি, বনি ইছরাইলর মাজে তারা অউ সম্পত্তিউ পাইছে। ");
INSERT INTO syl_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","অইলে তারার টাউনর ধারো পশু রাখার বন্দর জাগা তারা খরিদ-বিকি করতা পারতা নায়, ইতা তো তারার চিরকালিন সম্পত্তি। ");
INSERT INTO syl_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“তুমরার নিজর সমাজর কুনু ভাই যুদি গরিবি হালতর লাগি তার নিজর খাওয়া-ফিন্দা যুগাইতো না পারে, তে ভিন-দেশি মুছাফিরর লাখান তারেও সাইয্য করিও, যাতে হে তুমরার লগে বসত করতো পারে। ");
INSERT INTO syl_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","তুমরা তার গেছ থাকি কুনু নমুনার সুদ খাইও না। বরং হে যাতে হামেশা তুমরার গেছে রইবার সুযোগ পায়, অউ নিয়তে তুমরা নিজর মাবুদ আল্লার ডর-খফ ভিতরে রাখিও। ");
INSERT INTO syl_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","তুমরা সুদ খাইবার নিয়তে তারে টেকা-পয়সা কর্জো দিও না। তার গেছে খানি-খুরাকির মাল বেচলে ইতার লাভ লইও না। ");
INSERT INTO syl_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","মনো রাখিও, আমি আল্লাউ তুমরার মাবুদ। আস্তা কেনান দেশ দান করার খিয়ালে, আর তুমরার আপন মাবুদ অওয়ার খিয়ালে, আমিউ তুমরারে মিসর দেশ থাকি বার করি আনছি। ");
INSERT INTO syl_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“বনি ইছরাইলি সমাজর কুনু ভাই যুদি গরিবি হালতো পড়িয়া নিজে নিজে তুমরার কেউরর গেছে বিকি খাইলায়, তে তারে খরিদা গুলামর লাখান খাটাইও না। ");
INSERT INTO syl_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","তুমরার মুছাফির আর রুজি কামলার লগে যেলা বেবহার করো, তার লগেও অলা করিও। হে হউ ফিরত পাওয়ার বছর পর্যন্ত তুমার কাম-কাজ করবো। ");
INSERT INTO syl_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","বাদে তারে আর তার পুয়া-পুড়িরে আজাদ করি দিও। তেউ হে তার নিজর খান্দানর ময়-মুরব্বির জমিনো ফিরত যাইবো। ");
INSERT INTO syl_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","হুনো, বনি ইছরাইল তো খালি আমার গুলাম। আমি তারারে মিসর দেশ থাকি আজাদ করি আনছি, এরলাগি দুছরা কেউরর গুলামির লাগি তারারে বেচার এখতিয়ার নাই। ");
INSERT INTO syl_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","তুমরা নিজর মাবুদর ডর-খফে চলিও, একে-অইন্যে পাষান-নিষ্টুর বেবহার করিও না। ");
INSERT INTO syl_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“তুমরার আরি-ফরি যত জাতি আছইন, অতার মাজ থাকি তুমরার গুলাম-বান্দি নিতায় পারবায়। ");
INSERT INTO syl_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","তুমরার মাজে বসত কররা ভিন জাতির মানুষ থাকি, আর তারার যেতা আওলাদ তুমরার দেশো জন্মিছইন, অতার মাজ থাকিও তুমরা নিজর লাগি গুলাম-বান্দি নিতায় পারবায়। ");
INSERT INTO syl_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","অউ লাখান গুলাম-বান্দিরে নিজর ছামানা হিসাবে তুমরার পুয়া-পুড়িনরেও দিয়া যাইতায় পারবায়। ইতারে হারা জিন্দেগি তুমরার গুলামি করাইতায় পারবায়, অইলে তুমরার নিজর জাতি বনি ইছরাইলর উপরে পাষান মালিকানা খাটাইও না। ");
INSERT INTO syl_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“তুমরার মাজে বসত কররা ভিন-দেশি কুনু মানুষ যুদি ধনি বনিযায়, আর তুমরার কুনু ভাই যুদি অভাবো পড়িয়া তার গেছে বা তার কুনু আওলাদর গেছে নিজরে বেচিলায়, ");
INSERT INTO syl_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","তে হে নিজরে আজাদ করার সুযোগ পাইবো। তার নিজর কুনু ভাইয়ে তারে আজাদ করতো পারবো। ");
INSERT INTO syl_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","তার চাচা বা চাচার ঘরর ভাইয়ে, বা তার খান্দানর আপন যেকুনু জনে তারে আজাদ করাইতা পারবা। নিজর হালত বদলাইলিতে পারলে, হে নিজরে নিজে আজাদ করতো পারবো। ");
INSERT INTO syl_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","যে বছর নিজরে বেচিছিল অউ বছর থাকি হিসাব করিয়া ফিরত আওয়ার বছর পর্যন্ত যত বছর বাকি থাকে অউ সময়কুর কামর বেতনর হিসাব-নিকাশ মাফিক তার আজাদির দাম ঠিক করা অইবো। ");
INSERT INTO syl_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","ফিরত পাওয়ার বছর যুদি বেশি দুরই অয়, তে যে দামে হে নিজরে বেচিছিল, অউ দামর বড় এক অংশ তার আজাদির বদলা হিসাবে দিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","আর ফিরত পাওয়ার বছর আইতে যুদি কম সময় বাকি রয়, তে অউ সময় হিসাবে টেকা দিয়া হে নিজরে আজাদ করতো পারবো। ");
INSERT INTO syl_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","তারে বছর চুক্তি কামলার লাখান দেখিও, আর খিয়াল রাখিও, মালিকে যানু তার লগে পাষান বেবহার না করে। ");
INSERT INTO syl_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","অলা কুনু লাখান উপায়ে যুদি হে আজাদ অইতো না পারে, তে তারে আর তার পুয়া-পুড়িরে ফিরত পাওয়া বছরর সময় এমনেউ আজাদ করি দিলাইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","মনো রাখিও, বনি ইছরাইল তো খালি আমার গুলাম। আমি তারারে মিসর দেশ থাকি আজাদ করি আনছি, তারা খালি আমার। আমি আল্লাউ তুমরার মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“তুমরা কুনু নমুনার দেব-দেবীর মুর্তি বানাইও না। লাকড়িদি বানাইল মুর্তি, বা কুনুজাত পাথররে দেবতা হিসাবে বওয়াল করিও না। পুজার নিয়তে পাথর খুদিয়া বানাইল কুনুজাত মুর্তি তুমরার দেশর মাজে রাখিও না। মনো রাখিও, আমি আল্লাউ তুমরার মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","আমার দেওয়া পরতেক জুম্মাবার তুমরা মানিও, আমার পবিত্র কাবা ঘররে তুমরা ইজ্জত করিও। আমিউ তো মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“তুমরা যুদি আমার হকল হুকুম-আহকাম আর নিয়ম-কানুন মানিয়া আমল করো, ");
INSERT INTO syl_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","তে আমি তুমরারে ঠিকমতো মেঘ-পানি দিমু। তেউ তুমরার জমিনো ফয়-ফসল ফলিবো আর গাছ-গাছালিয়েও ফল-মুল দিবো। ");
INSERT INTO syl_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","তুমরার খেতর ফয়-ফসল অতো বেশি অইবো যেন, আংগুর তুলার সময় আজিলেও, তুমরার ফসল মাড়া দেওয়াত রইবায়। আর জমিনর মাজে নয়া বিচ বাইন দেওয়ার সময় আজিলেও, অউ সময় পর্যন্ত আংগুর তুলাত রইবায়। তুমরা পেট ভরিয়া খানা-পিনা খাইবায়, আর নিরাপদে নিজর বাড়িত বসত করবায়। ");
INSERT INTO syl_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“আমি তুমরার দেশো শান্তি দিমু, তুমরা শান্তিয়ে ঘুমাইবায়, কেউ আইয়া তুমরারে কুনু ডর-খফ দেখাইতো নায়। তুমরার দেশ থাকি হকল জাতর হিংস্র জানুয়াররে আমি খেদাই দিমু, আর কুনু সিপাই দলেও তুমরার দেশো হামলা করাত আইতো নায়। ");
INSERT INTO syl_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","তুমরার দুশমন অকলরে খেদাইয়া নিবায়, তুমরার চখুর ছামনে তারার মরন অইবো। ");
INSERT INTO syl_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","তুমরার খালি পাচ জন সিপাইয়ে একশো দুশমনরে, আর একশো সিপাইয়ে দশ আজার জনরে খেদাইয়া নিবায়, তুমরার দুশমন তুমরার চখুর ছামনে তলোয়ারর তলে মরবো। ");
INSERT INTO syl_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","আমি তুমরার বায় দয়ার নজরে চাইমু, তুমরার আওলাদ বাড়াইয়া তুমরার খান্দান বড় করমু, আর তুমরার লগে আমার ওয়াদা-চুক্তি বওয়াল রাখমু। ");
INSERT INTO syl_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","নয়া বছরর ফসল তুলার লাগি উগার খালি করার আগ পর্যন্ত, আগর বছরর ফসলদি তুমরার খানা-পিনা চলবো। ");
INSERT INTO syl_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","তুমরার বায় থাকি আমার মুখ ফিরাইতাম নায়, তুমরার মাজেউ রইবো আমার বসত ঘর। ");
INSERT INTO syl_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","আমি তুমরার লগে চলা-ফিরা করমু, আমি অইমু তুমরার মাবুদ, তুমরা অইবায় আমার খাছ প্রজা। ");
INSERT INTO syl_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","খিয়াল রাখিও, আমি আল্লাউ তুমরার মাবুদ। মিসর দেশ থাকি আমিউ তুমরারে আজাদ করি আনছি, যাতে তুমরা মিসরী অকলর গুলামি করা না লাগে। তুমরার গর্দনা থাকি জুয়াল ভাংগিয়া ফালাইয়া, মাথা উচা করি আটিবার হালতো আমিউ তুমরারে আনছি। ");
INSERT INTO syl_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“অইলে তুমরা যুদি আমার কথা না হুনো, আমার অউ হুকুম-আহকাম না মানো, ");
INSERT INTO syl_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","আমার বাতাইল আইন-কানুনরে নাপছন্দ করো, আমার দেওয়া শরিয়তরে এলামি করো, আর আমার হুকুম না মানিয়া, আমার ওয়াদা-চুক্তির উল্টা চলো, ");
INSERT INTO syl_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","তে আমি তুমরার উপরে অলা খাড়া মছিবত দিমু, তুমরার শরিল ক্ষয় অওয়ার বেমার দিমু, গজবি যক্ষা বেমার আর বেজুইতা তাপ অইবো, অতা বেমারে তুমরার চখুর পাওয়ার ক্ষয় অইবো, শরিলর কমজুরি আইবো। তুমরা জমিনো খেত করলেও ফায়দা অইতো নায়, তুমরার ফসল দুশমনে খাইবো। ");
INSERT INTO syl_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","আমি তুমরার খেতি করাত লাগিযিমু, আর তুমরা নিজর দুশমনর গেছে আরিবায়। তুমরারে যেতায় ইংসা করইন, অতায় তুমরারে শাসন করবা, আর কেউ তুমরারে না খেদাইলেও, তুমরা জানর ডরে এমনেউ বাগিবায়। ");
INSERT INTO syl_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“এরবাদেও যুদি তুমরা আমার কথা না হুনো, তে আমি তুমরার গুনার সাত গুন বেশি সাজা দিমু। ");
INSERT INTO syl_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","আমি তুমরার বল-শক্তির বেটাগিরি ভাংগিয়া চুরমার করিলিমু। তুমরার মাথার উপরর আছমানরে লুয়ার লাখান, আর পাওর তলর মাটিরে তামার লাখান শক্ত করমু। ");
INSERT INTO syl_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","তেউ তুমরা অতো মেনত করিয়াও কুনু ফল পাইতায় নায়। খেতর জমিনো ফসল ধরতো নায়, গাছ-গাছালিত ফল মিলতো নায়। ");
INSERT INTO syl_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“তুমরার দিলর মাজে যুদি আমার লাগি কুনুজাতর দুশমনি থাকে, আমার বাতাইল হুকুম যুদি তুমরার কানো না হামায়, তে আমি তুমরার নাফরমানির লাগি সাত গুন বেশি সাজা দিমু। ");
INSERT INTO syl_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","তুমরার মাজে আমি হিংস্র জানুয়ার পাঠাইমু, ইতায় তুমরার পুয়া-পুড়িন্তরে খাইবা, তুমরার পশুর পালরে বিনাশ করবা, আর তুমরার মানষর পরিমানও কমাইলিবা, দেশর পথ-ঘাট খালি পড়ি রইবো। ");
INSERT INTO syl_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“অউ হকল ঘটনা ঘটার বাদেও তুমরা যুদি আমার আইন-কানুনর উল্টা চলো, ");
INSERT INTO syl_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","তে আমি নিজে তুমরার দুশমন বনিয়া, তুমরার গুনার সাত গুন বেশি সাজা দিমু। ");
INSERT INTO syl_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","আমার ওয়াদা-চুক্তিরে না মানায় আমি তুমরার উপরে লাড়াই-যুদ্ধ আনাইমু। দুশমনরে দেখিয়া তুমরা যেবলা টাউনো গিয়া হামাইবায়, হনো আমি তুমরার উপরে গজবি মরকি ছাড়িমু, তেউ তুমরা দুশমনর আতো ধরা পড়বায়। ");
INSERT INTO syl_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","আমি তুমরার খানি-খুরাকির মাজে অভাব ঘটাইমু, তেউ দশ জন বেটিয়ে রান্দিতে এক চুলার বেশি লাগতো নায়। খানিত বইয়া তুমরা রুটি মাপি মাপি খাইবায়, পেট ভরা খানি জুটতো নায়। ");
INSERT INTO syl_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ইতা হকলতার বাদেও যুদি আমার কথা না হুনিয়া আমার উল্টা চলো, ");
INSERT INTO syl_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","তে আমি গুছায় আগুইন অইয়া আমিও তুমরার উল্টা চলমু, আর তুমরার গুনার সাত গুন সাজা দিমু। ");
INSERT INTO syl_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","পেটর ভুকে অউ সময় তুমরা নিজর পুয়া-পুড়িন্তরে চিবাইয়া খাইবায়। ");
INSERT INTO syl_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","আমি তুমরার পুজার হকল মান্ডব আর ধুপ-ধুনা জালানির জাগারেও বিনাশ করমু, তুমরার দেব-দেবীর মুর্তির উপরে আমি তুমরার লাশর টেকি থইমু, আমি তুমরার বায় খুব ঘিন্নার নজরে চাইমু। ");
INSERT INTO syl_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","আমি তুমরার গাউ আর টাউন অকল, আর হকল মছিদ-মন্দির বিনাশ করিলিমু। তুমরার ছদগা-কুরবানির ধুমার ঘেরান আমি আর কবুল করতাম নায়। ");
INSERT INTO syl_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","আমি তুমরার দেশর উপরে অলা গজব দিমু, যেতা দেখিয়া তুমরার দুশমন অকলেও ডরাইয়া কাপিবা। ");
INSERT INTO syl_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","নানান জাতির মাজে আমি তুমরারে ছিতরাই দিমু, তলোয়ার আতো লইয়া আমি তুমরারে খেদাইমু। তুমরার দেশ বিনাশ অইবো, তুমরার টাউন আর গাউ-গেরাম খালি পড়ি রইবো। ");
INSERT INTO syl_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","“তুমরা দুশমনর দেশো থাকার সময়, তুমরার নিজর দেশর জমিনে তার পাওনা জিরানির বছর জিরাইবো। অউ সময় দেশর মাটিয়ে তার পাওনা আরাম পাইবো। ");
INSERT INTO syl_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","তুমরা নিজে থাকার সময় যেবলা অউ জমিন অকলে জিরানির বছর পাইছিল না, অখন দেশ বিনাশর সময় ইতায় হউ পাওনা জিরানি জিরাইবো। ");
INSERT INTO syl_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","তুমরার মাজর যেরা গিয়া দুশমনর দেশো বাচিয়া রইবা, তারার ভিতরে আমি অউ লাখান ডর-খফ হারাই দিমু, লাড়াইর কালো মানষে যেলা দুশমনর আত থাকি বাচার লাগি দৌড়িয়া বাগে, অউলা এগু পাতা পড়ার আওয়াজ হুনলেউ তারা দৌড়িয়া বাগিবা। ");
INSERT INTO syl_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","তলোয়ারর তল থাকি বাচার লাগি মানষে যেলা জান লইয়া দৌড়ায়, কেউ তুমরারে না দৌড়াইলেও তুমরা নিজে নিজে দৌড়াইয়া অলা একে-অইন্যর উপরে পড়বায়। দুশমনর ছামনে তুমরা উবাইতায় পারতায় নায়। ");
INSERT INTO syl_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","তুমরা নানান জাতির মানষর মাজে ছিতরিয়া মরবায়, আর দুশমনর দেশে তুমরারে গিলিয়া খাইবো। ");
INSERT INTO syl_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","এরবাদেও যুদি তুমরার মাজর কেউ হনো বাচিয়া রয়, তে তারাও নিজর আর তারার ময়-মুরব্বির নাফরমানির লাগি ক্ষয় অওয়াত রইবা। ");
INSERT INTO syl_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“তারা অখান স্বীকার করা লাগবো যেন, তারা আর তারার ময়-মুরব্বিয়ে আমার লগে বেইমানি করছে, আমার হুকুমর বিরুধিতা করিয়া গুনা করছে, ");
INSERT INTO syl_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","এরলাগি আমিও তারার লগে দুশমনর লাখান বেবহার করছি, তারারে ভিটা-মাটি ছাড়াইয়া দুশমনর দেশো আনাইছি। অতা স্বীকার করিয়া তারা যুদি কাতর অইয়া নরম দিলে তৌবা করিয়া গুনার সাজা বইতে রাজি অয়, ");
INSERT INTO syl_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","তে আমি ইয়াকুবর লগে কাইম করা আমার ওয়াদা-চুক্তির কথা ইয়াদ করমু, ইছহাকর লগে করা ওয়াদা-চুক্তির কথারেও মনো করমু, আর ইব্রাহিমর লগে করা আমার ওয়াদা-চুক্তিরে ইয়াদ করমু, তারারে দেওয়া দেশর কথাও খিয়াল করমু। ");
INSERT INTO syl_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","“তারা দেশ ছাড়িয়া যাওয়ার বাদে তারার বিনাশ অওয়া দেশ খালি পড়ি রইবো, জমিনর পাওনা জিরানির বছর অকলো জিরাইবোউ জিরাইবো। আমার হুকুমর বিরুধিতা করিয়া নাফরমানি করায়, আমার আইনর উল্টা চলায় তারা অলা সাজা পাইবা। ");
INSERT INTO syl_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","অইলে দুশমনর দেশো থাকার কালো আমি তারারে অলা কুনু ঘিন্না বা এলামির চউখে দেখতাম নায়, তারারে এক্কেরে বিনাশ অইতে দিতাম নায়, যাতে তারার লগে করা আমার ওয়াদা-চুক্তি ভংগ না অয়। মনো রাখিও, আমি আল্লাউ তারার মাবুদ। ");
INSERT INTO syl_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","তারার লাগি আমি তারার ময়-মুরব্বির লগর ওয়াদা-চুক্তিরে ইয়াদ করমু। অউ ময়-মুরব্বি অকলর মাবুদ অওয়ার নিয়তে হকল জাতির ছামন দিয়া আমি তারারে মিসর দেশ থাকি বার করিয়া আনছি। আমিউ তো মাবুদ।” ");
INSERT INTO syl_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","ইতা অইলো হউ শরিয়ত, হুকুম-আহকাম, আর নিয়ম-কানুন, যেতা তুর পাহাড়র উপরে মাবুদে মুছা নবীর মারফতে বনি ইছরাইলর লাগি বওয়াল করছইন। ");
INSERT INTO syl_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","বাদে মাবুদে মুছা নবীরে কইলা, ");
INSERT INTO syl_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“তুমি তামাম বনি ইছরাইলরে জানাই দেও, কেউ যুদি কুনু মানষরে আল্লার নামে দেওয়ার মান্নত করে, তে অউ জনর বদলা অলাখান হাদিয়া দিতে অইবো: ");
INSERT INTO syl_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","বিশ থাকি ষাইট বছর বয়সি বেটাইন্তর লাগি, এবাদত খানার মাপে পইঞ্চাশ তোলা রুপা হাদিয়া দিতে অইবো, ");
INSERT INTO syl_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","অউ বয়সি বেটিন্তর লাগি তিশ তোলা। ");
INSERT INTO syl_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","পাচ বছর থাকি বিশ বছর বয়সি পুয়াইন্তর লাগি বিশ তোলা রুপা, অউ বয়সি পুড়িন্তর লাগি দশ তোলা। ");
INSERT INTO syl_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","একমাস থাকি পাচ বছর বয়সি পুয়াইন্তর লাগি পাচ তোলা রুপা, অউ বয়সি পুড়িন্তর লাগি তিন তোলা রুপা। ");
INSERT INTO syl_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","ষাইট বছর বা এর বেশি বয়সি বেটাইন্তর লাগি পনরো তোলা, অউ বয়সি বেটিন্তর লাগি দশ তোলা রুপা দিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“অইলে অউ মান্নত কররা জন যুদি গরিব মানুষ অয়, তার মান্নতর হাদিয়া দিবার তাক্কত না থাকে, তে তারে লইয়া ইমাম ছাবর গেছে যাইবায়, গেলে ইমাম ছাবে তার হালত বুজিয়া হাদিয়া ঠিক করবা। ");
INSERT INTO syl_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“যুদি কবুল অওয়ার জুকা কুনু পশুরে মাবুদর নামে মান্নত করা অয়, তে অউ পশুরে মাবুদর ছামানা হিসাবে পবিত্র কইয়া গইন্য করিও। ");
INSERT INTO syl_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","অউ পশুর বদলা দুছরা কুনু পশু দিলে কবুল অইতো নায়। ইটা ভালা অইলে এর বদলা বাদ পশু, বা বাদ অইলে এর বদলা ভালা কুনু পশু দিলেও কবুল অইতো নায়। হে যুদি একটার বদলা আরকটা পশুরে দিলায়, তে অউ দুইওটারে পবিত্র হিসাবে গইন্য করিও। ");
INSERT INTO syl_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","অইলে মাবুদর নামে কবুল অওয়ার জুকা নায়, ইলা কুনু নাপাক জাতর পশুরে কেউ যুদি মান্নত হিসাবে মানিলায়, তে অকটারে লইয়া ইমাম ছাবর গেছে যাইও, ");
INSERT INTO syl_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","গেলে তাইন অকটার হাল-হকিকত বুজিয়া হারি যে দাম ঠিক করবা, অউ দামউ অইবো ইটার সঠিক দাম। ");
INSERT INTO syl_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","মান্নত কররায় ইটারে খালাছ করার খিয়াল অইলে, অউ দামর লগে আরো পাচ বাটর এক বাট দাম বেশি দিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“কেউ যুদি তার কুনু বাড়ি-ঘররে মাবুদর নামে পাক-পবিত্র ছামানা হিসাবে মান্নত করিলায়, তে ইমাম ছাবে অউ বাড়ির হাল-হকিকত বুজিয়া যে দাম ঠিক করবা, ইটাউ অইবো এর সঠিক দাম। ");
INSERT INTO syl_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","অখন অউ বাড়িরে হে খালাছ করিয়া নিতো চাইলে, অউ দামর লগে আরো পাচ বাটর এক বাট বেশি দিতে অইবো। তেউ বাড়ি খান তার অইবো। ");
INSERT INTO syl_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“কুনু মানষে যুদি তার নিজর জমি-মিরাসর কুনু এক অংশরে মাবুদর নামে মান্নত করিয়া পাক-পবিত্র কইয়া আলগ করিলায়, তে অউ জমিনো যে পরিমানে খেত অয়, অউ ফসলর পরিমান বুজিয়া এর দাম ঠিক করতে অইবো। পরতেক পাচ মন বার্লি বিচর দাম হিসাবে আধা সের রুপা ধরবায়। ");
INSERT INTO syl_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","আর জমি-মিরাস ফিরত পাওয়ার বছর যুদি হে তার জমিনরে পাক-পবিত্র কইয়া মান্নত করে, তে অউ নিয়ম মাফিক ইমাম ছাবে যে দাম ঠিক করবা, ইটাউ অইবো এর সঠিক দাম। ");
INSERT INTO syl_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","অইলে ফিরত পাওয়ার বছরর বাদে যুদি হে তার মান্নত করে, তে বাদর ফিরত পাওয়ার বছর পর্যন্ত হিসাব করিয়া যত বছর অয়, অতো বছরর ফসলর হিসাবে ইমাম ছাবে এর দাম ঠিক করবা, বছর হিসাবে জমিনর দাম কমবো। ");
INSERT INTO syl_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","আর মান্নত কররা জনে যুদি তার জমিনরে খালাছ করিয়া নিতো চায়, তে ঠিক করা অউ দামর লগে আরো পাচ বাটর এক বাট বেশি দিতে অইবো, তেউ জমি খান তার অইবো। ");
INSERT INTO syl_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","অইলে হে যুদি খালাছ করি না নেয়, বা দুছরা জনর গেছে বেচিলায়, তে অউ জমিন খান আর খালাছ করিয়া নিবার পথ নাই। ");
INSERT INTO syl_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","জমি-মিরাস ফিরত পাইবার বছর যেবলা জমি খান এমনেউ খালাছ অইযিবো, অউ সময় ই জমি খান মাবুদর নামে চিরকালিন সাফ-কবালা জমিনর লাখান পাক-পবিত্র ছামানা হিসাবে গইন্য অইবো। ইখান অইযিবো ইমাম ছাবর জমি। ");
INSERT INTO syl_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","নিজর বাফাইতি জমি নায় ইলা কুনু খরিদা জমিনরে কেউ যুদি মান্নত মানিয়া পাক-পবিত্র হিসাবে গইন্য করায়, ");
INSERT INTO syl_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","তে ইমাম ছাবে ফিরত পাওয়ার বছর পর্যন্ত হিসাব করিয়া ইখানর দাম ঠিক করবা, আর হউ দিনউ অউ জমিনর দামরে হে মাবুদর নামে পাক-পবিত্র ছামানা হিসাবে দিলাইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","আর জমি খান হে যার গেছ থাকি লইছিল, জমি-মিরাস ফিরত পাইবার বছর ইখান হিরবার হউ মুল মালিকর আতো যাইবো। ");
INSERT INTO syl_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","হকল জিনিসর দাম ঠিক করিও, এবাদত খানার মাপে। পরতেক বিশ রতিয়ে এক তোলা গনিও। ");
INSERT INTO syl_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“কুনু পশুর পয়লা মেদা বাইচ্চারে কেউ মাবুদর নামে লিল্লা দিবার লাগি মান্নত করতো পারতো নায়, ইটা তো এমনেউ মাবুদর। ইতা গরু-ছাগল, মেড়া যেতার বাইচ্চাউ অউক, ইটা মাবুদর। ");
INSERT INTO syl_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","যুদি ইটা কুনু হারাম পশুর পয়লা মেদা বাইচ্চা অয়, তে ইমাম ছাবর ঠিক করা দামর লগে আরো পাচ বাটর এক বাট বেশি দিয়া ইটারে খালাছ করি নিতো পারবো। আর হে যুদি খালাছ করি না নেয়, তে অউ দামে ইটারে বেচিলিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“অইলে কুনু মানষে যুদি তার নিজর কুনু ছামানা মাবুদর নামে চিরকালিন ছাফ-কবালা দলিলর লাখান মান্নত করিলায়, তে অউ মান্নত করা ছামানা আর খালাছ করিয়া ফিরত নিতো পারতো নায়, বা বেচতোও পারতো নায়। ইতা জমি-জমা অউক, বা কুনু মানুষ, বা পশু অইলেও, ইতা চিরকালর লাগি মাবুদর নামে খাছ পবিত্র ছামানা হিসাবে গইন্য অইবো। ");
INSERT INTO syl_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","কুনু মানষরে মাবুদর নামে চিরকালর লাগি অলা মান্নত করিয়া দিলাইলে, তারে আর খালাছ করি নেওয়া যাইতো নায়, তারে জানে মারিলিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“জমিনো থাকি যেতা ফল-ফসল মিলে, ইতার দশ বাটর এক বাট তো মাবুদর। ইতা খেতর ফসল অউক বা গাছর ফল অউক, হকলতাউ মাবুদর নামে পাক-পবিত্র। ");
INSERT INTO syl_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","কেউ যুদি তার অউ দশ বাটর এক বাট খালাছ করিয়া নিতো চায়, তে এর লগে আরো পাচ বাটর এক বাট বেশি দিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","পরতেক পশুর পালর দশ বাটর এক বাট মাবুদর, মানি পালে পশু গনার সময় পরতেক দশ নম্বর পশু অগু মাবুদর নামে পাক-পবিত্র। ");
INSERT INTO syl_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","অউ দশ নম্বর পশু অগুইন বাদ বা ভালা ইতা দেখার কুনু জরুর নায়, বা ইটা বদলাইয়া দিবার সুযোগ নাই। কেউ যুদি ইটার বদলা দেয়, তে অউ দশ নম্বর পশু আর বদলা পশু দুইওটাউ মাবুদর নামে পাক-পবিত্র অইযিবো, ইতা আর খালাছ করি নেওয়া যাইতো নায়।” ");
INSERT INTO syl_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","মাবুদে তুর পাহাড়র উপরে মুছা নবীর গেছে, বনি ইছরাইলর লাগি অউ হুকুম-আহকাম অকল দান করছিলা॥");
INSERT INTO syl_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","বনি ইছরাইল জাতি মিসর দেশ থাকি বার অইয়া আওয়ার দুই নম্বর বছরর সময়, দুই নম্বর চান্দর পয়লা দিন, মাবুদে সিনাই মরুভুমিত মিলন-তাম্বুর ভিতরে হজরত মুছার লগে বাতচিত করলা। তাইন মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“অখন তামাম বনি ইছরাইলর গুষ্টি আর পরিবার মাফিক এক এক করি হকল বেটাইন্তর নাম লেখো। ");
INSERT INTO syl_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","তুমি আর তুমার ভাই হারুনে বিশ বছর বা এর বেশি বয়সি, মানি যুদ্ধত যাওয়ার জুকা ফৌজি দল মাফিক তারারে গনো। ");
INSERT INTO syl_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","পরতেক খান্দানর একজনে তুমরারে সাইয্য করবা, এরা অইবা নিজর গুষ্টির পরধান মুরব্বি। ");
INSERT INTO syl_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","যারা সাইয্য করবা, এরার নাম অইলো, রুবেন খান্দানর সাদিউরর পুয়া আলিছুর, ");
INSERT INTO syl_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","শিমিয়ন খান্দানর সুরশাদায়র পুয়া শালুমিল, ");
INSERT INTO syl_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","এহুদা খান্দানর আমিনাদাবর পুয়া নাহিশ, ");
INSERT INTO syl_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ইছাখর খান্দানর ছুগারর পুয়া নথনেল, ");
INSERT INTO syl_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","সবুলন খান্দানর হেলনর পুয়া ইলিয়াব, ");
INSERT INTO syl_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","ইউছুফর পুয়াইন্তর মাজ থাকি: আফরাইম খান্দানর আমিহুদর পুয়া আলিশামা, মানশা খান্দানর ফাতসুরর পুয়া গমলীয়েল, ");
INSERT INTO syl_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","বিন-ইয়ামিন খান্দানর জিদাউনির পুয়া আবিদান, ");
INSERT INTO syl_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","দান খান্দানর আমিশাদার পুয়া আখিআজার, ");
INSERT INTO syl_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","আশির খান্দানর উকরানর পুয়া ফজিয়েল, ");
INSERT INTO syl_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","ছাদু খান্দানর দোয়েলর পুয়া ইলিয়াছফ, ");
INSERT INTO syl_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","নপ্তালি খান্দানর ইনানর পুয়া আহির।” ");
INSERT INTO syl_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","বনি ইছরাইলর মাজ থাকি অউ বারো জনরে পছন্দ করি নেওয়া অইলো। এরা অইলা তারার বাফ-দাদাইন্তর পরিবারর পরধান, বনি ইছরাইলর ফৌজি দলর সর্দার। ");
INSERT INTO syl_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","মাবুদে যেরার নাম কইছলা, মুছা আর হারুনে অউ সর্দার অকলরে খবরদি আনাইলা, ");
INSERT INTO syl_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","আর অউ বছরর দুছরা চান্দর পয়লা দিন হকল বনি ইছরাইলরে একখানো দলা করলা। তারা যারযির গুষ্টি আর পরিবার মাফিক তারার নাম লেখাইলো। বিশ বছর বা এর বেশি বয়সর বেটাইন্তর নাম এক এক করি লেখা অইলো। ");
INSERT INTO syl_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","মাবুদর হুকুম মাফিক সিনাই মরুভুমিত মুছায় এরারে গনিলা। ");
INSERT INTO syl_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","ইয়াকুব উরফে ইছরাইলর বড় পুয়ার নাম রুবেন, অউ খান্দান থাকি যেরার বয়স বিশ বছর বা এর বেশি, মানি যারা যুদ্ধত যাওয়ার জুকা আছিল, গুষ্টি আর পরিবারর পরিচয় মাফিক এরার নাম এক এক করি লেখা অইলো। ");
INSERT INTO syl_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","রুবেন খান্দান থাকি পাওয়া গেল ছয়চাল্লিশ আজার পাচশো জন। ");
INSERT INTO syl_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","শিমিয়ন খান্দানর মাজে যেরার বয়স বিশ বছর বা এর বেশি, মানি যারা যুদ্ধত যাওয়ার জুকা আছিল, গুষ্টি আর পরিবারর পরিচয় মাফিক এরার নাম এক এক করি লেখা অইলো। ");
INSERT INTO syl_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","শিমিয়ন খান্দান থাকি পাওয়া গেল উনুষাইট আজার তিনশো জন। ");
INSERT INTO syl_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","ছাদু খান্দানর মাজে যেরার বয়স বিশ বছর বা এর বেশি, মানি যারা যুদ্ধত যাওয়ার জুকা আছিল, গুষ্টি আর পরিবারর পরিচয় মাফিক এরার নাম এক এক করি লেখা অইলো। ");
INSERT INTO syl_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","ছাদু খান্দান থাকি পাওয়া গেল পয়তাল্লিশ আজার ছয়শো পইঞ্চাশ জন। ");
INSERT INTO syl_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","এহুদা খান্দানর মাজে যেরার বয়স বিশ বছর বা এর বেশি, মানি যারা যুদ্ধত যাওয়ার জুকা আছিল, গুষ্টি আর পরিবারর পরিচয় মাফিক এরার নাম এক এক করি লেখা অইলো। ");
INSERT INTO syl_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","এহুদা খান্দান থাকি পাওয়া গেল চৌয়াত্তইর আজার ছয়শো জন। ");
INSERT INTO syl_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","ইছাখর খান্দানর মাজে যেরার বয়স বিশ বছর বা এর বেশি, মানি যারা যুদ্ধত যাওয়ার জুকা আছিল, গুষ্টি আর পরিবারর পরিচয় মাফিক এরার নাম এক এক করি লেখা অইলো। ");
INSERT INTO syl_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","ইছাখর খান্দান থাকি পাওয়া গেল চৌয়ান্ন আজার চাইরশো জন। ");
INSERT INTO syl_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","সবুলন খান্দানর মাজে যেরার বয়স বিশ বছর বা এর বেশি, মানি যারা যুদ্ধত যাওয়ার জুকা আছিল, গুষ্টি আর পরিবারর পরিচয় মাফিক এরার নাম এক এক করি লেখা অইলো। ");
INSERT INTO syl_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","সবুলন খান্দান থাকি পাওয়া গেল সাতান্ন আজার চাইরশো জন। ");
INSERT INTO syl_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","ইউছুফর পুয়া আফরাইম খান্দানর মাজে যেরার বয়স বিশ বছর বা এর বেশি, মানি যারা যুদ্ধত যাওয়ার জুকা আছিল, গুষ্টি আর পরিবারর পরিচয় মাফিক এরার নাম এক এক করি লেখা অইলো। ");
INSERT INTO syl_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","আফরাইম খান্দান থাকি পাওয়া গেল চাল্লিশ আজার পাচশো জন। ");
INSERT INTO syl_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","আর তান ভাই মানশা খান্দানর মাজে যেরার বয়স বিশ বছর বা এর বেশি, মানি যারা যুদ্ধত যাওয়ার জুকা আছিল, গুষ্টি আর পরিবারর পরিচয় মাফিক এরার নাম এক এক করি লেখা অইলো। ");
INSERT INTO syl_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","মানশা খান্দান থাকি পাওয়া গেল বত্তিশ আজার দুইশো জন। ");
INSERT INTO syl_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","বিন-ইয়ামিন খান্দানর মাজে যেরার বয়স বিশ বছর বা এর বেশি, মানি যারা যুদ্ধত যাওয়ার জুকা আছিল, গুষ্টি আর পরিবারর পরিচয় মাফিক এরার নাম এক এক করি লেখা অইলো। ");
INSERT INTO syl_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","বিন-ইয়ামিন খান্দান থাকি পাওয়া গেল পায়তিশ আজার চাইরশো জন। ");
INSERT INTO syl_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","দান খান্দানর মাজে যেরার বয়স বিশ বছর বা এর বেশি, মানি যারা যুদ্ধত যাওয়ার জুকা আছিল, গুষ্টি আর পরিবারর পরিচয় মাফিক এরার নাম এক এক করি লেখা অইলো। ");
INSERT INTO syl_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","দান খান্দান থাকি পাওয়া গেল বাষট্টি আজার সাতশো জন। ");
INSERT INTO syl_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","আশির খান্দানর মাজে যেরার বয়স বিশ বছর বা এর বেশি, মানি যারা যুদ্ধত যাওয়ার জুকা আছিল, গুষ্টি আর পরিবারর পরিচয় মাফিক এরার নাম এক এক করি লেখা অইলো। ");
INSERT INTO syl_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","আশির খান্দান থাকি পাওয়া গেল একচাল্লিশ আজার পাচশো জন। ");
INSERT INTO syl_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","নপ্তালি খান্দানর মাজে যেরার বয়স বিশ বছর বা এর বেশি, মানি যারা যুদ্ধত যাওয়ার জুকা আছিল, গুষ্টি আর পরিবারর পরিচয় মাফিক এরার নাম এক এক করি লেখা অইলো। ");
INSERT INTO syl_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","নপ্তালি খান্দান থাকি পাওয়া গেল তেপ্পান্ন আজার চাইরশো জন। ");
INSERT INTO syl_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","হজরত মুছা, হারুন আর বনি ইছরাইলর বারো জন মুরব্বি নেতায় অউ মানষরে গনিলা। অউ বারো জন নেতা আছলা বারো খান্দানর সর্দার। ");
INSERT INTO syl_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","আস্তা বনি ইছরাইলর মাজে যেরার বয়স বিশ বছর বা তার বেশি, মানি যুদ্ধত যাওয়ার জুকা বয়স, যারযির গুষ্টি মাফিক তারারে গনা অইলো। ");
INSERT INTO syl_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","গনিয়া হক্কলতায় ছয় লাখ তিন আজার পাচশো পইঞ্চাশ জন পাওয়া গেল। ");
INSERT INTO syl_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","অইলে লেবি খান্দানরে, মানি ইমাম বংশরে এরার লগে গনা অইলো না। ");
INSERT INTO syl_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","মাবুদে আগেউ মুছারে কইছলা, ");
INSERT INTO syl_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“তুমি লেবি খান্দানরে গনবায় না, গনার সময় বনি ইছরাইলর অইন্য মানষর লগে এরারে হিসাব করিও না। ");
INSERT INTO syl_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","তুমি তারারে শাহাদত তাম্বু, মানি আমার ঘরর সাজ-সরঞ্জাম আর হকলতার দেখা-হুনার ভার দিবায়। তারার কাম অইবো, আমার ঘর আর এর হকল সাজ-সরঞ্জাম বইয়া নেওয়া। তারা এর চাইরো গালাবায় যারযির তাম্বু টাংগাইয়া রইবা আর আমার ঘরর দেখা-হুনা করবা। ");
INSERT INTO syl_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","আমার ঘররে এক জাগা থাকি আরক জাগাত নিতে অইলে, লেবি খান্দানর মানষে ইখান খুলবা, বাদে আরক জাগাত গিয়া এক এক করি জুড়া লাগাইয়া হিরবার বানাইবা। খালি লেবি খান্দান ছাড়া অইন্য কেউ ইতার কান্দাত গেলে তারে জানে মারা অইবো। ");
INSERT INTO syl_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","বাদ-বাকি বনি ইছরাইলে তারার ফৌজি দল মাফিক যারযির তাম্বু টাংগাইবা। পরতেকে যারযির দলর সীমানার মাজে, দলর নিশানা লাগাইল পতাকার তলে রইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","বনি ইছরাইলর উপরে যাতে মাবুদর গজব না লামে, এরলাগি লেবি খান্দানর মানষে আমার শাহাদত তাম্বুর পারাদারি করার লাগি আমার ঘরর চাইরো গালাবায় তারার তাম্বু টাংগাইয়া রইবা।” ");
INSERT INTO syl_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","মাবুদে মুছা নবীরে যেলা হুকুম দিছলা, বনি ইছরাইলে ঠিক অলাউ করলা। ");
INSERT INTO syl_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","বাদে মাবুদে মুছা আর হারুনরে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“মিলন-তাম্বুর চাইরো গালাবায় থুড়া খালি জাগা থইয়া বনি ইছরাইলে তারার তাম্বু টানাইবা। পরতেকে যারযির ফৌজি দলর সীমানাত যারযির গুষ্টির পতাকার ধারো রইবা। ");
INSERT INTO syl_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","“মিলন-তাম্বুর পুবেদি, সুরুজ উঠার মুখা, এহুদার পতাকার তিনো খান্দানর ফৌজি দলে তারার তাম্বু টানাইবা। এহুদা খান্দানর সর্দার অইলা আমিনাদাবর পুয়া নাহিশ, ");
INSERT INTO syl_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","অউ খান্দানো সিপাইর জুকা মানুষ অইলা, চৌয়াত্তইর আজার ছয়শো জন। ");
INSERT INTO syl_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","এরার এক গালাত ইছাখর খান্দান রইবা, অউ খান্দানর সর্দার অইলা ছুগারর পুয়া নথনেল, ");
INSERT INTO syl_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","তার খান্দানো সিপাইর জুকা মানুষ অইলা, চৌয়ান্ন আজার চাইরশো জন। ");
INSERT INTO syl_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","দুছরা গালাত তাম্বু গাড়িবা সবুলন খান্দানে, অউ খান্দানর সর্দার অইলা হেলনর পুয়া ইলিয়াব, ");
INSERT INTO syl_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","তার খান্দানো সিপাইর জুকা মানুষ অইলা, সাতান্ন আজার চাইরশো জন। ");
INSERT INTO syl_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","এহুদার পতাকার অউ তিনো খান্দানর গনা সিপাইর জুকা মোট মানুষ অইলা, এক লাখ ছিয়াশি আজার চাইরশো। ছফরর সময় তারার কাফেলা হকলর আগে রওয়ানা দিবা। ");
INSERT INTO syl_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“মিলন-তাম্বুর দক্ষিন গালাত তাম্বু গাড়িবা, রুবেনর পতাকার তিনো খান্দানর ফৌজি দলে। রুবেন খান্দানর সর্দার অইলা সাদিউরর পুয়া আলিছুর, ");
INSERT INTO syl_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","তার খান্দানো সিপাইর জুকা মানুষ অইলা, ছয়চাল্লিশ আজার পাচশো জন। ");
INSERT INTO syl_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","এরার এক গালাত শিমিয়ন খান্দান রইবা, অউ খান্দানর সুরশাদায়র পুয়া শালুমিল অইলা তারার সর্দার, ");
INSERT INTO syl_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","তার খান্দানো সিপাইর জুকা মানুষ অইলা, উনুষাইট আজার তিনশো জন। ");
INSERT INTO syl_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","দুছরা গালাত তাম্বু গাড়িবা ছাদু খান্দানে, অউ খান্দানর সর্দার অইলা দোয়েলর পুয়া ইলিয়াছফ, ");
INSERT INTO syl_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","তার খান্দানো সিপাইর জুকা মানুষ অইলা, পাচ্চাল্লিশ আজার ছয়শো পইঞ্চাশ জন। ");
INSERT INTO syl_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","রুবেনর পতাকার অউ তিনো খান্দানো গনা সিপাইর জুকা মোট মানুষ অইলা, এক লাখ একান্ন আজার চাইরশো পইঞ্চাশ জন। ছফরর সময় তারা দুছরা কাফেলাত রওয়ানা দিবা। ");
INSERT INTO syl_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“বাদে লেবি খান্দানর মানষে মিলন-তাম্বুরে লইয়া রওয়ানা দিবা, হকলর মাজখানো এরা রইবা। যারযির তাম্বু টানানির ছিরিয়াল মাফিক লাইন ধরিয়া রওয়ানা অইবা। ফৌজি দলর যারযির পতাকার মানুষ নিজর দলর লগে রইবা। ");
INSERT INTO syl_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“মিলন-তাম্বুর পইচমর গালাত তাম্বু গাড়িবা, আফরাইম পতাকার তিনো ফৌজি দলর মানষে। আফরাইম খান্দানর সর্দার অইলা আমিহুদর পুয়া আলিশামা, ");
INSERT INTO syl_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","অউ খান্দানো সিপাইর জুকা মানুষ অইলা, চাল্লিশ আজার পাচশো জন। ");
INSERT INTO syl_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","এরার এক গালাত মানশা খান্দানে তাম্বু গাড়িবা, ফাতসুরর পুয়া গমলীয়েল অইলা তারার সর্দার, ");
INSERT INTO syl_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","অউ খান্দানো সিপাইর জুকা মানুষ অইলা, বত্তিশ আজার দুইশো জন। ");
INSERT INTO syl_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","আর দুছরা গালাত রইবা বিন-ইয়ামিন খান্দান, এরার সর্দার অইলা জিদাউনির পুয়া আবিদান, ");
INSERT INTO syl_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","তার খান্দানো সিপাইর জুকা মানুষ অইলা, পায়তিশ আজার চাইরশো জন। ");
INSERT INTO syl_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","আফরাইমর পতাকার অউ তিনো খান্দানর গনা সিপাইর জুকা মোট মানুষ অইলা, এক লাখ আট আজার একশো জন। তারা তিন নম্বর কাফেলাত রওয়ানা দিবা। ");
INSERT INTO syl_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“মিলন-তাম্বুর উত্তর গালাত তাম্বু গাড়িবা দান পতাকার তিনো খান্দানর ফৌজি দলর মানষে, তারার সর্দার অইলা আমিশাদার পুয়া আখিআজার, ");
INSERT INTO syl_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","অউ খান্দানো সিপাইর জুকা মানুষ অইলা, বাষট্টি আজার সাতশো জন। ");
INSERT INTO syl_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","এরার এক গালাত আশির খান্দানে তাম্বু গাড়িবা, অউ খান্দানর সর্দার অইলা, উকরানর পুয়া ফজিয়েল। ");
INSERT INTO syl_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","তার খান্দানো সিপাইর জুকা মানুষ অইলা, একচাল্লিশ আজার পাচশো জন। ");
INSERT INTO syl_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","আর দুছরা গালাত রইবা নপ্তালি খান্দান, অউ খান্দানর সর্দার অইলা, ইনানর পুয়া আহির। ");
INSERT INTO syl_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","তার খান্দানো সিপাইর জুকা মানুষ অইলা, তেপ্পান্ন আজার চাইরশো জন। ");
INSERT INTO syl_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","দানর পতাকার অউ তিনো খান্দানর গনা সিপাইর জুকা মোট মানুষ অইলা, এক লাখ সাতান্ন আজার ছয়শো জন। এরা হকল হেশর কাফেলাত রওয়ানা দিবা।” ");
INSERT INTO syl_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","অউ নমুনায় হকল বনি ইছরাইলরে যারযির গুষ্টি মাফিক গনা অইলো। গনিয়া হারলে হকল ফৌজি দলে সিপাইর জুকা মোট মানুষ অইলা, ছয় লাখ তিন আজার পাচশো পইঞ্চাশ জন। ");
INSERT INTO syl_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","তা-ও মাবুদে মুছা নবীরে যেলা হুকুম দিছলা, হুকুম মাফিক বনি ইছরাইলরে গনার সময় লেবি খান্দানরে গনাত ধরা অইলো না। ");
INSERT INTO syl_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","মাবুদে মুছারে যেলা হুকুম দিছলা, বনি ইছরাইলে হকল কাম-কাজ করতা অউ হুকুম মাফিক। তারা যারযির দলর জাগাত তাম্বু টানাইতা, আর ছফরো রওয়ানা অইতা নিজর গুষ্টি আর পরিবার মাফিক আপন ফৌজি দলর পতাকার ধারো রইয়া। ");
INSERT INTO syl_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","তুর পাহাড়র উপরে মাবুদে যেবলা মুছা নবীর লগে বাতচিত করছলা, হউ সময় হারুন আর তান ভাই মুছার বংশ-বুনিয়াদ আছলা অউ এইনতাইন: ");
INSERT INTO syl_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","হারুনর পুয়াইন অইলা নাদাব, আবিহু, আলি-আজর আর ইছামার। এরার মাজে নাদাব আছলা বড়। ");
INSERT INTO syl_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","ইমামতি কামর লাগি হারুনর অউ চাইরো পুয়াইনরে খেলাফতি দিয়া এবাদতি কামো বওয়াল করা অইছিল। ");
INSERT INTO syl_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","অইলে সিনাই মরুভুমিত রওয়ার কালো, নাদাব আর আবিহুয়ে মাবুদর বাতাইল নিয়ম ভাংগিয়া, দুছরা আগুইনদি আগর-খুশবয় জালানির সময় মাবুদর ছামনেউ তারার মরন অইগেল। তারার কুনু আওলাদ না থাকায়, তারার বাফ হারুন নবীর লগে রইয়া আলি-আজর আর ইছামারে ইমামতি কাম করলা। ");
INSERT INTO syl_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","বাদে মাবুদে মুছা নবীরে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“তুমি লেবি খান্দানর মানষরে আনিয়া ইমাম হারুনর আতো সমজাও, তারা ইমামতি কামো তানরে সাইয্য করবা। ");
INSERT INTO syl_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","তারা ইমাম হারুনর জিম্মায় মিলন-তাম্বুর ছামনে হকল বনি ইছরাইলর তরফ থাকি আমার ঘরর খাদিমদারি করবা। ");
INSERT INTO syl_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","তারাউ মিলন-তাম্বুর মাল-ছামানা দেখা-হুনা আর আল্লার ঘরর খেজমত করিয়া বনি ইছরাইলর পক্ষে এবাদত-বন্দেগির দায়-দায়িত্ব আদায় করবা। ");
INSERT INTO syl_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","লেবি খান্দানর খাদিম অকলরে তুমি হারুন আর তার পুয়াইন্তর আতো সমজাই দেও। বনি ইছরাইলর মাজ থাকি এরারে ইমাম হারুনর আতো সপি দেওয়া অইলো। ");
INSERT INTO syl_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","ইমামতি কামর লাগি তুমি হারুন আর তার বংশরে বাছিয়া নেও। তারা ছাড়া দুছরা কেউ ইমামতি করাত গেলে অগুরে জানে মারা অইবো।” ");
INSERT INTO syl_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","মাবুদে মুছারে এওখান কইলা, ");
INSERT INTO syl_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“হুনো, বনি ইছরাইলি বেটিন্তর ঘরো জনম লওয়া পয়লা পুয়ার বদলা বাবত, আমি লেবি খান্দানরে পছন্দ করছি। এরলাগি লেবি অকল আমার। ");
INSERT INTO syl_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","আসলে হক্কল পয়লা পুয়াইনউ আমার। মিসরী অকলর হকল পয়লা পুয়াইন্তরে মারিলিবার দিন, বনি ইছরাইলর পরতেক পয়লা পুয়ারে আমার লাগি পবিত্র করিয়া রাখছি, ইতা মানষর পুত অউক বা পশুর বাইচ্চা অউক। তারা তো আমার, আমিউ মাবুদ।” ");
INSERT INTO syl_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","সিনাই মরুভুমির মাজে মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“তুমি গুষ্টি আর পরিবার মাফিক লেবি অকলরে গনো। এক মাস বা এর বেশি বয়সর হকল বেটাইন্তরে গনো।” ");
INSERT INTO syl_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","মাবুদর হুকুম মাফিক তাইন লেবি খান্দানরে গনিলা। ");
INSERT INTO syl_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","গনার কালো পাইলা, লেবির পুয়াইন জারছুন, কাহাত আর মারারি। ");
INSERT INTO syl_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","জারছুনর পুয়াইন লিবনি আর শিমেই আছলা দুই গুষ্টির মুরব্বি নেতা। ");
INSERT INTO syl_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","কাহাতর পুয়াইন ইমরান, ইজহার, হেবরন আর উজ্জল অইলা চাইর ভাই। ");
INSERT INTO syl_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","মারারির পুয়াইন মহলি আর মুশি অইলা দুই ভাই। এরা অইলা বংশ আর পরিবার হিসাবে লেবি খান্দানর নানান গুষ্টি। ");
INSERT INTO syl_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","জারছুন আছলা লিবনিয়া আর শিমেইয়া গুষ্টির মুল মুরব্বি। ");
INSERT INTO syl_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","এরার মাজে এক মাস আর এক মাসর বেশি বয়সর হকল পুয়াইন্তরে গনিয়া সাড়ে সাত আজার পাওয়া গেল। ");
INSERT INTO syl_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","পচ্চিম গালাবায় আল্লার ঘরর খরেদি জারছুনী অকলর তাম্বু টাংগানি অইতো। ");
INSERT INTO syl_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","জারছুন গুষ্টির পরধান আছলা লায়েলর পুয়া ইলিয়াছফ। ");
INSERT INTO syl_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","মিলন-তাম্বুর বেয়াপারে জারছুনী অকলর উপরে, যেতা কাপড়াইন দিয়া আল্লার ঘর বানানি অইছে খালি অতা কাপড় অকল, বারা বাজুর গিলাফ আর ছানি অকল আর অউ ঘরর ভিতরে হামাইবার পর্দা দেখা-হুনা করার দায়িত্ব আছিল। ");
INSERT INTO syl_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","আর আল্লার ঘর আর কুরবানি খানার চাইরোবায় যে উঠান আছে অগুর পর্দাইন, আর উঠানো হামানির লাগি যে গেইট আছে অউ গেইটর পর্দা, আর সব রশি অকলরউ দেখা-হুনা করা, আর অতা হকল কাম-কাজ করা, অউ হক্কলতাউ তানতানর দায়িত্ব আছিল। ");
INSERT INTO syl_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","কাহাত আছলা ইমরান, ইজহার, হেবরন আর উজ্জল, অউ চাইর গুষ্টির মুল মুরব্বি। ");
INSERT INTO syl_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","অউ গুষ্টিন্তর মাজে এক মাস বা তার বেশি বয়সর হকল পুয়াইন্তরে গনিয়া আট আজার ছয়শো জন পাওয়া গেল। এরার দায়িত্ব আছিল পবিত্র এবাদত খানার দেখা-হুনা করা। ");
INSERT INTO syl_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","আল্লার ঘরর দক্ষিন গালাবায় কাহাতী অকলর তাম্বু টাংগানি অইতো। ");
INSERT INTO syl_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","কাহাতী গুষ্টির পরধান আছলা উজ্জলর পুয়া ইলিজাফন। ");
INSERT INTO syl_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","অউ কাহাতী গুষ্টির দায়িত্ব আছিল শাহাদত সন্দুক, টেবুল, চেরাগ দানি, কুরবানি খানা, আগর-খুশবয় জালানির টেবুল, পবিত্র এবাদত খানার এবাদতির হকল জিনিস আর হেরেম শরিফর পর্দার দেখা-হুনা করা, লগে বাদ-বাকি কাম করা। ");
INSERT INTO syl_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","লেবি খান্দানর নানান গুষ্টির মুরব্বি অকলর পরধান আছলা ইমাম হারুনর পুয়া আলি-আজর। এরলগে পবিত্র এবাদত খানার দেখা-হুনার দায়িত্ব যেরারে দেওয়া অইছিল, এরারে নজরদারি করার লাগি তানরে বওয়াল করা অইছিল। ");
INSERT INTO syl_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","মারারি আছলা মহলি আর মুশির অউ দুই গুষ্টির মুল মুরব্বি। ");
INSERT INTO syl_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","অউ গুষ্টিন্তর মাজে এক মাস বা তার বেশি বয়সর হকল পুয়াইন্তরে গনিয়া ছয় আজার দুইশো পাওয়া গেল। ");
INSERT INTO syl_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","মারারিয়া গুষ্টির পরধান আছলা আবিয়েলর পুয়া ছুরিয়েল। আল্লার ঘরর উতরেদি তারার তাম্বু টাংগানি অইতো। ");
INSERT INTO syl_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","এরার দায়িত্ব আছিল আল্লার ঘরর ফ্রেইম, ফ্রেইমর বাত্তি, খুটি, চুঙি আর এর হকল চিজ, ");
INSERT INTO syl_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","উঠানর বেড়ার চাইরো গালার খুটি, চুঙি, বেড়া টানানির রশি আর পেরেগর দেখা-হুনা আর এর লগর হকল কাম-কাজ করা। ");
INSERT INTO syl_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","মিলন-তাম্বুর ছামনেদি মানি আল্লার ঘরর পুবেদি হজরত মুছা, হারুন আর তান পুয়াইন্তর তাম্বু অকল টাংগানি অইতো। এরার দায়িত্ব আছিল বনি ইছরাইলর তরফ থাকি পবিত্র এবাদত খানাত হকল এবাদতি কাম আদায় করা। এরা ছাড়া আর কেউ এবাদত খানার কান্দাত গেলে তারে মারিলাওয়া অইতো। ");
INSERT INTO syl_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","মাবুদর হুকুম মাফিক মুছা আর হারুনে, লেবি খান্দানর এক মাস বা তার বেশি বয়সর হকল পুয়াইন্তরে গুষ্টি মাফিক গনিলা, গনিয়া বাইশ আজার জন পাওয়া গেল। ");
INSERT INTO syl_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","এরবাদে মাবুদে মুছারে কইলা, “বনি ইছরাইলর হকল পরিবারর পয়লা পুয়াইনরে গনো, যেরার বয়স এক মাস বা এর বেশি, এরারে গনিয়া এরার নাম এক খাতাত লেখো। ");
INSERT INTO syl_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","বনি ইছরাইলর হকল পয়লা পুয়াইন্তর জানর বদলা লেবি অকলরে আমার কইয়া গনা অইবো। আর তারার পশুর পয়লা বাইচ্চার বদলা লেবি অকলর পশুর পয়লা বাইচ্চারে আমার কইয়া গনা অইবো। আমিউ মাবুদ।” ");
INSERT INTO syl_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","মাবুদর হুকুম মাফিক মুছায় বনি ইছরাইলর হকল পরিবারর পয়লা পুয়াইনরে গনিলা। ");
INSERT INTO syl_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","তেউ এক মাস বা তার বেশি বয়সি পুয়াইন্তরে গনিয়া মোট বাইশ আজার দুইশো তেয়াত্তইর জন পাওয়া গেল। ");
INSERT INTO syl_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","মাবুদে মুছারে আরো কইলা, ");
INSERT INTO syl_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“বনি ইছরাইলর হকল পয়লা পুয়াইন্তর বদলা লেবি অকলরে, আর তারার পয়লা পশুর বাইচ্চার বদলা লেবি অকলর পয়লা পশুর বাইচ্চারে আমার কইয়া ধরা অইবো। লেবি অকল তো আমার অইবা। আমিউ মাবুদ। ");
INSERT INTO syl_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","লেবি খান্দানর মোট পরিমান থাকি বনি ইছরাইলর পয়লা পুয়াইন্তর পরিমান দুইশো তেয়াত্তইর জন বেশি। ");
INSERT INTO syl_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","অউ দুইশো তেয়াত্তইর জনরে খালাছ করার লাগি জানর বদলা হিসাবে, পরতেক জনর লাগি এবাদত খানার মাপে পাচ তোলা রুপা আদায় করিও। ");
INSERT INTO syl_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","আদায় করা অউ রুপা নিয়া তুমি ইমাম হারুন আর তার পুয়াইন্তরে দিলাইও।” ");
INSERT INTO syl_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","তেউ লেবি খান্দানর বদলা বনি ইছরাইলরে খালাছ করিয়া নিবার বাদে, তারার যত জন বাকি রইলা, এরার জানর বদলা হিসাবে মুছা নবীয়ে রুপা আদায় করলা। ");
INSERT INTO syl_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","তাইন বনি ইছরাইলর পয়লা পুয়াইন্তর গেছ থাকি এবাদত খানার মাপে এক আজার তিনশো পয়ষট্টি তোলা রুপা আদায় করলা। ");
INSERT INTO syl_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","মাবুদর হুকুম মাফিক মুছায় অউ রুপা হারুন আর তান পুয়াইন্তরে দিলাইলা। ");
INSERT INTO syl_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","মাবুদে মুছা আর হারুন নবীরে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“তুমরা লেবি খান্দানর মাজর কাহাতী অকল আলাদা করি গনো, তারার হকল পরিবার আর গুষ্টি মাফিক গনো। ");
INSERT INTO syl_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","তিশ থাকি পইঞ্চাশ বছর বয়সর যেতা বেটাইন্তে মিলন-তাম্বুর কাম-কাজ করাত আইবা, খালি তারারে গনিও। ");
INSERT INTO syl_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“কাহাতী অকলর কাম অইবো, মিলন-তাম্বুর খাছ পবিত্র চিজ অকলর দেখা-হুনা করা। ");
INSERT INTO syl_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","বনি ইছরাইল ছফরো বারনির সময়, হারুন আর তার পুয়াইন্তে আমার ঘরর ভিতরে হামাইয়া, হেরেম শরিফর পর্দা খুলিয়া হারি, অখানদি শাহাদত সন্দুকরে গুরিয়া দিবা। ");
INSERT INTO syl_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","এর উপরে দরিয়ার ফুʼ মাছর চামড়ার গিলাফদি গুরিবা, বাদে পুরাপুর লিলুয়া রংগর একখান কাপড়দি গুরিয়া দিয়া, সন্দুক বইয়া নিবার বেন্দা গুইন জাগা মত হারাইবা। ");
INSERT INTO syl_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","পবিত্র রুটি রাখার টেবুলর উপরে তারা লিলুয়া রংগর একখান কাপড় বিছাইয়া, অখানর উপরে হুরু-বড় হকল থাল-বাসন, আর শরবত-পানির ছদগা ঢালিবার জগ-মগ থইবা। পবিত্র যেতা রুটি হামেশা টেবুলর উপরে থওয়া থাকে, ইতা টেবুলর উপরেউ রইবো। ");
INSERT INTO syl_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","অতার উপরে লাল একখান কাপড় বিছাইয়া, ফুʼর চামড়াদি অখানরে গুরিবা, আর টেবুল বইয়া নিবার বেন্দা গুইন জাগা মত হারাই দিবা। ");
INSERT INTO syl_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","বাদে লিলুয়া একখান কাপড়দি আস্তা চেরাগ দানি, এর চেরাগ অকল, চেরাগর ফিতা ছাফ করার চিমটা, জালাইল ফিতার ছালি থওয়ার বাটি আর তেলর ফিফারে গুরিয়া দিবা। ");
INSERT INTO syl_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","হকল মাল-ছামানা সমেত চেরাগ দানিরে ফুʼর চামড়াদি বেরাইয়া, বইয়া নিবার খাটিয়ার উপরে থইবা। ");
INSERT INTO syl_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","আর আগর-খুশবয় জালানির সোনার টেবুলর উপরে লিলুয়া একখান কাপড় বিছাইয়া, ফুʼর চামড়াদি গুরিয়া দিবা, বাদে অউ টেবুল বইয়া নেওয়ার বেন্দা গুইন জাগা মত হারাইবা। ");
INSERT INTO syl_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","এবাদত খানার খেজমতর হকল মাল-ছামানা তারা লিলুয়া কাপড়দি পেচাইয়া, ফুʼর চামড়াদি গুরিয়া হারি, অতা বইয়া নিবার খাটিয়ার উপরে থইবা। ");
INSERT INTO syl_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“কুরবানি খানার ভিতরর হকল ছালি ফালাইয়া, বাইংগনি রংগর একখান গিলাফদি গুরিয়া দিবা। ");
INSERT INTO syl_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","বাদে কুরবানি খানার হকল মাল-ছামানা অকল, অর্থাত আংরা থওয়ার পাতিল, গোস্ত তুলার বড় কাটা-ছিফ, ছালি তুলার বড় চামচ, লউ থওয়ার বাটি, ইতা হকলতা কুরবানি খানার উপরে থইবা। থইয়া ফুʼর চামড়াদি গুরিয়া দিয়া, এর বেন্দা গুইন ঠিক জাগাত হারাইবা। ");
INSERT INTO syl_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","হারুন আর তার পুয়াইন্তে যেবলা অউ পাক-পবিত্র জিনিস অকল আর এবাদত খানার মাল-ছামানা হকলতা গুরিলিবা, তারা তাম্বু তুলিয়া ছফরো বারনির লাগি যেবলা তিয়ার অইযিবা, অউ সময় অতা বইয়া নিবার লাগি কাহাতী অকল আইবা। অইলে তারা কুনু পাক-পবিত্র চিজরে আতদি ছইতা পারতা নায়, ছইলেউ মরবা। মিলন-তাম্বুর অউ হক্কল জিনিস তারা বইয়া নিবা। ");
INSERT INTO syl_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“আর ইমাম হারুনর পুয়া আলি-আজরর উপরে চেরাগ দানির তেল, জালানির লাগি আগর-খুশবয়, পর্তিদিনর ধান-গমর ছদগা আর খেলাফতি সমজিবার তেলর দায়িত্ব রইবো। আল্লার ঘর, ঘরর হকল মাল-ছামানা, মানি এবাদত খানা আর তার হকল মাল-ছামানার তদারকি রইবো আলি-আজরর উপরে।” ");
INSERT INTO syl_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","এরবাদে মাবুদে হজরত মুছা আর হারুনরে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“তুমরা খিয়াল রাখিও, লেবি খান্দানর মাজে কাহাতী বংশ থাকি কেউ কেউ যাতে হর-হামেশা থাকইন। ");
INSERT INTO syl_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","তারা যানু খাছ পবিত্র চিজ অকলর কাছাত গিয়া না মরে বরং বাচিয়া রয়, অতার লাগি হারুন আর তার পুয়াইন্তে আমার ঘরর ভিতরে গিয়া যারযির কাম-কাজ বুজাই দিবা। আর কে কিতা বইয়া নিতা, অতাও ঠিক করি দিবা। ");
INSERT INTO syl_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","অইলে হেরেম শরিফর ভিতরর অউ পাক-পবিত্র জিনিস এক পলকর লাগিও দেখার নিয়তে কাহাতী অকল ভিতরে কুনু লাখানউ হামাইতা পারতা নায়, অউ নিয়তে হামাইলেউ মরি যাইবা।” ");
INSERT INTO syl_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“তুমি গুষ্টি আর পরিবার মাফিক জারছুনী অকলরে গনো। ");
INSERT INTO syl_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","তিশ থাকি পইঞ্চাশ বছর বয়সর যেতা জারছুনী বেটাইন্তে মিলন-তাম্বুর কাম করতা পারবা, খালি তারারে গনিও। ");
INSERT INTO syl_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“মিলন-তাম্বুর খেজমত করা আর ভার বওয়ার সময় জারছুনী অকলর কাম অইলো, ");
INSERT INTO syl_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","আমার ঘরর হকল পর্দাইন, মিলন-তাম্বু আর এর গিলাফ, তার উপরর ফুʼর চামড়ার ছানি, আর মিলন-তাম্বুর দুয়ারর পর্দা বইয়া নেওয়া। ");
INSERT INTO syl_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","এরলগে আল্লার ঘর আর কুরবানি খানার উঠানর চাইরো গালার পর্দা আর এর দড়ি অকল, উঠানো হামানির গেইটর পর্দা, অতার লগর দরকারি হকল মাল তারা বইয়া নিবা, আর অউ বেয়াপারে যত কাম-কাজ আছে, ইতা তারা করবা। ");
INSERT INTO syl_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","ভার বইবার কাম অউক বা অইন্য কুনু কাম অউক, হকলতা হারুন আর তার পুয়াইন্তর হুকুম মাফিক জারছুনী অকলে করবা। তারা কিতা কিতা বইয়া নিতো, ইতা তুমরাউ তারারে কইয়া দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","অতাউ অইলো মিলন-তাম্বুর কামো জারছুনী অকলর দায়-দায়িত্ব। তারার কাম-কাজর তদারকি করবা ইমাম হারুনর পুয়া ইছামারে। ");
INSERT INTO syl_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“তুমরা গুষ্টি আর পরিবার মাফিক মারারিয়া অকলর পরিমান গনো। ");
INSERT INTO syl_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","তিশ থাকি পইঞ্চাশ বছর বয়সর যেতা মারারিয়া বেটাইন্তে মিলন-তাম্বুর কাম করতা পারবা, তুমরা খালি তারারে গনিও। ");
INSERT INTO syl_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","মিলন-তাম্বুর মাজে মারারিয়া অকলর দায়িত্ব অইলো, আল্লার ঘরর হকল ফ্রেইম, ফ্রেইমর বাত্তি, খুটি আর খুটির তলর চুঙি বইয়া নেওয়া। ");
INSERT INTO syl_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","এরলগে চাইরো গালার উঠানর হকল খুটি আর চুঙি, উঠানর পর্দা টানানির পেরেগ আর দড়ি আর অতার লগর মাল-ছামানা যেতা দরকারি ইতা হকলতা তারা বইয়া নিবা। তারা কে কিতা বইয়া নিতো, ইতা তুমরা কইয়া দিও। ");
INSERT INTO syl_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","অতাউ অইলো মিলন-তাম্বুর মাজে মারারিয়া গুষ্টির দায়-দায়িত্ব। তারার কাম-কাজর তদারকি করবা ইমাম হারুনর পুয়া ইছামারে।” ");
INSERT INTO syl_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","তেউ গুষ্টি আর পরিবার মাফিক হজরত মুছা, হারুন আর বনি ইছরাইলর সর্দার অকলে কাহাতী অকলরে গনিলা। ");
INSERT INTO syl_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","তিশ থাকি পইঞ্চাশ বছর বয়সি যেতা বেটাইন্তে মিলন-তাম্বুর কাম-কাজ করার কথা, খালি তারারে গনিলা। ");
INSERT INTO syl_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","গনিয়া তারার গুষ্টি মাফিক দুই আজার সাতশো পইঞ্চাশ জন পাওয়া গেল। ");
INSERT INTO syl_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","এরাউ আছলা কাহাতী গুষ্টির মোট মানুষ, যেরা মিলন-তাম্বুর কাম-কাজ করতা। মুছা নবীর মারফতে মাবুদর বাতাইল হুকুম মাফিক মুছা আর হারুনে তারারে গনিলা। ");
INSERT INTO syl_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","গুষ্টি আর পরিবার মাফিক জারছুনী অকলরে গনা অইছিল। ");
INSERT INTO syl_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","তিশ থাকি পইঞ্চাশ বছর বয়সর যেতা বেটাইন্তে মিলন-তাম্বুর কাম-কাজ করার কথা, ");
INSERT INTO syl_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","গুষ্টি আর পরিবার মাফিক তারারে গনিয়া হারি দুই আজার ছয়শো তিশ জন পাওয়া গেল। ");
INSERT INTO syl_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","এরাউ আছলা জারছুনী গুষ্টির মোট মানুষ, যেরা মিলন-তাম্বুর কাম-কাজ করতা। মাবুদর হুকুম মাফিক মুছা আর হারুনে তারারে গনিলা। ");
INSERT INTO syl_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","গুষ্টি আর পরিবার মাফিক মারারিয়া অকলরে গনা অইছিল। ");
INSERT INTO syl_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","তিশ থাকি পইঞ্চাশ বছর বয়সর যেতা বেটাইন্তে মিলন-তাম্বুর কাম-কাজ করার কথা, ");
INSERT INTO syl_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","গুষ্টি মাফিক তারারে গনিয়া তিন আজার দুইশো জন পাওয়া গেল। ");
INSERT INTO syl_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","এরাউ আছলা মারারিয়া গুষ্টির মোট মানুষ, যেরা মিলন-তাম্বুর কাম-কাজ করতা। হজরত মুছার মারফতে পাওয়া মাবুদর হুকুম মাফিক মুছা আর হারুনে তারারে গনিলা। ");
INSERT INTO syl_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","গুষ্টি আর পরিবার মাফিক হজরত মুছা, হারুন আর বনি ইছরাইলর মুরব্বি অকলে আস্তা লেবি খান্দানরে গনিলা। ");
INSERT INTO syl_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","তিশ থাকি পইঞ্চাশ বছর বয়সি যেতা বেটাইন্তে মিলন-তাম্বুর খেজমত আর মাল-ছামানা বইয়া নিবার কথা, ");
INSERT INTO syl_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","গুষ্টি মাফিক তারারে গনিয়া আট আজার পাচশো আশি জন পাওয়া গেল। ");
INSERT INTO syl_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","হজরত মুছার মারফতে মাবুদর বাতাইল হুকুম মাফিক এরা পরতেক জনর কাম-কাজ আর কে কিতা বইয়া নিতা, হকলতা বুজাই দেওয়া অইছিল। মাবুদর দেওয়া হুকুম মাফিক মুছা নবীয়ে লেবি খান্দানরে গনিলা। ");
INSERT INTO syl_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“তুমি বনি ইছরাইলরে অউ হুকুম দেও, তারা যানু কেম্প থাকি হকল পচা-কুষ্ঠ বেমারিরে বার করি দেয়, আর হকল নমুনার ধাতু বেমারি, মরা লাশ ছইয়া যেরা নাপাক অইছে তারারেও কেম্প থাকি বার করি দেউক। ");
INSERT INTO syl_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","বেটা বা বেটি অউক, অগুরে কেম্প থাকি বার করি দিবায়। বনি ইছরাইলর কেম্প যাতে এরা নাপাক না বানায়, অউ নিয়তে অতারে বার করি দিবায়, জানো তো, স্বয়ং আমি বনি ইছরাইলর মাজে বসত করি।” ");
INSERT INTO syl_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","তেউ বনি ইছরাইলে অলা করলা। মাবুদে মুছারে যেলা হুকুম দিছলা, তারা ঠিক অউলাউ করলা। তারা নাপাক হকল মানষরে কেম্প থাকি বার করি দিলা। ");
INSERT INTO syl_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","বাদে মাবুদে মুছা নবীরে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“তুমি বনি ইছরাইলরে জানাই দেও, কুনু মানষে যুদি মাবুদর নাফরমানি করিয়া দুছরা মানষর খেতি করে, তে হে বেটা বা বেটি অইলেও নিচ্চয় দুষি। ");
INSERT INTO syl_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","হে তার গুনার স্বীকারুক্তি দিতে অইবো। আর হে যে মানষর খেতি করছে, তারে ষোলআনা খেতি-পুরন দিতে অইবো। যে জিনিসর খেতি করছে, খেতি-পুরন হিসাবে অউ জিনিসর মুল দামর লগে আরো পাচ বাটর এক বাট বেশি দিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","খেতি-পুরন নেওয়ার জুকা মানুষ যুদি না রইন আর তার কুনু আপন জন না থাকইন, তে ইতা মাবুদর পাওনা অইবো। অউ খেতি-পুরন আর গুনার কফরার কুরবানির মেড়াটা ইমাম ছাবে পাইবা। ");
INSERT INTO syl_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","বনি ইছরাইলে পাক-পবিত্র যত জিনিস ইমামর গেছে লইয়া আইবা, ইতা হক্কলতাউ ইমামে পাইবা। ");
INSERT INTO syl_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","পরতেক জনর কুরবানি দেওয়া জিনিস ইমামে পাইবা। ইমামর আতো যে জিনিস দেওয়া অইবো, ইতা ইমামরউ অইবো।” ");
INSERT INTO syl_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","বাদে মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“তুমি বনি ইছরাইলরে জানাই দেও, কেউরর বউ যুদি কু-পথে যায়গি, ");
INSERT INTO syl_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","আর জামাইরে লুকাইয়া আরক বেটার লগে জিনা করিয়া অসতী বনে, তাইর জামাইয়ে ইখান না জানে বা ইতার কুনু সাক্ষিও না থাকে, তাই কুনু ধরা না-ও খায়। ");
INSERT INTO syl_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","এরবাদেও জামাইয়ে বউরে সন্দয় করিলায়, তার ভিতরে অশান্তি করের, কিবা বউয়ে কুনু অসতী কাম না করলেও জামাইয়ে খালি তাইরে সন্দয় করে, এরলাগি তার মনর মাজে অশান্তি হামাইযায়, ");
INSERT INTO syl_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","তে জামাইয়ে তার বউরে লইয়া ইমাম ছাবর গেছে যাইতে অইবো। যাওয়ার সময় তার বউর তরফ থাকি ছদগা হিসাবে দুই সের বার্লির ময়দা নিতে অইবো। অউ ময়দা অইলো সন্দয়র লাগি ছদগা, মাবুদর ছামনে অপরাধ জাইর করার ছদগা, এরলাগি ইতার মাজে কুনু তেল বা খুশবয়দার লোবান মিশানি নিষেধ। ");
INSERT INTO syl_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ইমামে অউ বেটার বউরে মাবুদর ছামনে খাড়া করাইবা। ");
INSERT INTO syl_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","আর মাটির এক গামলার মাজে কিছু পবিত্র পানি ভরবা, ভরিয়া আল্লার ঘরর ভিতরর মাটির উপর থাকি কিছু ধুইল তুলিয়া অউ পানিত ছাড়িবা। ");
INSERT INTO syl_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","বেটিরে মাবুদর ছামনে উবা করিয়া হারলে তাইন বেটির মাথার চুল খুলিয়া দিবা, আর বেটির অপরাধর হাছা-মিছা জাইর অওয়ার লাগি আনা ছদগার বার্লির ময়দারে তাইর আতো দিবা। দিয়া তান নিজর আতো লইবা হউ লান্নত ডাকিয়া আনার তিত্বা পানি। ");
INSERT INTO syl_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","পানি লইয়া ইমামে অউ বেটিরে কছম করাইয়া কইবা, ‘তুমার বিয়ার বাদে যুদি কুনু বেটায় তুমার লগে জিনা না করে, বা কু-পথে গিয়া তুমি অসতী না অও, তে অউ লান্নত আনার তিত্বা পানিয়ে যানু তুমার কুনু খেতি না অয়। ");
INSERT INTO syl_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","অইলে বিয়ার বাদে কু-পথে গিয়া দুছরা কুনু বেটার লগে জিনা করিয়া যুদি অসতী অও,’ ");
INSERT INTO syl_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","—অখান কইয়া ইমামে অউ বেটিরে নিজর উপরে লান্নত ডাকিয়া আনার কছম করাইয়া হারি হিরবার কইবা— ‘তে মাবুদে তুমারে অউ গজব দেউক্কা, তুমার নারী-অংগ নিস্তেজ অইযাউক, আর তুমার পেট ফুলিয়া মোটা অইযাউক। তেউ ইতা দেখিয়া তুমার সমাজর মানষে যেকুনু বদদোয়া আর লান্নতি কছম খাওয়ার সময় তুমার নাম তারা ইয়াদ করবো। ");
INSERT INTO syl_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","আর অউ লান্নত আনার পানি তুমার শরিলো হামাইয়া যানু অলা কাম করে, যাতে তুমার পেট ফুলিযায় আর তুমার নারী-অংগ নিস্তেজ অইযায়।’ তেউ বেটিয়ে কইবো, ‘আমিন, অলাউ অউক।’ ");
INSERT INTO syl_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ইমামে অউ লান্নত আনা কছমর কথা এক চামড়ার উপরে লেখিয়া হারি, পানি ঢালিয়া অউ লেখার কালি তিত্বা পানিত ফালাইবা। ");
INSERT INTO syl_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","লান্নত আনার অউ তিত্বা পানি বেটিরে খাওয়ানির বাদে বেটির পেটো খুব জালা-যন্ত্রনা পয়দা অইবো। ");
INSERT INTO syl_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","ইমামে পয়লা অউ বেটির আত থাকি সন্দয়র ছদগার ময়দা নিয়া মাবুদর ছামনে দুলাইয়া কুরবানি খানাত লইয়া যাইবা। ");
INSERT INTO syl_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","বাদে তাইন পুরা ছদগার বদলা অউ ময়দা থাকি নিশানা হিসাবে এক মুইট পরিমান নিয়া কুরবানি খানাত জালাইবা, আর হউ তিত্বা পানি বেটিরে খাওয়াইবা। ");
INSERT INTO syl_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","বেটিয়ে যুদি জামাইর লগে বেইমানি করিয়া অসতী অইয়া থাকে, তে ই পানি খাওয়ার বাদেউ তাইর পেটো খুব জালা-যন্ত্রনা অইবো। তাইর পেট ফুলিয়া মোটা অইবো, আর নারী-অংগ নিস্তেজ অইয়া আটকুরা বনিযিবো, মানষে লান্নত দিবার নিয়তে তাইর নাম লইবা। ");
INSERT INTO syl_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","অইলে তাই যুদি অসতী না অইয়া নি-অপরাধি রয়, তে তাই ই লান্নত থাকি খালাছ পাইবো, আর হুরুতা জনম দেওয়ার খেমতাও জারি রইবো। ");
INSERT INTO syl_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","জামাই-বউর সন্দয়র বিষয়ে আল্লার আইন তো অলা। কুনু বউ যুদি জামাইর সংসারো রইয়া কু-পথে গিয়া অসতী বনে, ");
INSERT INTO syl_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","বা জামাইয়ে তার বউরে বদমাইশির সন্দয় করে, তে তারার লাগি অউ আইন। বেটায় তার বউরে মাবুদর ছামনে নিবো আর ইমামে ইতা হকলতা বেটির উপরে বর্তাইবা। ");
INSERT INTO syl_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","তেউ জামাইয়ে তার নালিশ থাকি খালাছ পাইবো, আর বউ হাছারর অপরাধি অইলে তাইর সাজা বইবো।” ");
INSERT INTO syl_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“তুমি বনি ইছরাইলরে জানাই দেও, কুনু বেটা বা বেটিয়ে যুদি নাজিরিয়া এতেকাফ করতা চাইন, মানি খালি মাবুদর এবাদত-বন্দেগির লাগি আলাদা রওয়ার মান্নত করিলায়, ");
INSERT INTO syl_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","তে আংগুরর শরবত বা যেকুনু নমুনার শরাব খাওয়া থাকি তারা নিচ্চয় হরিয়া থাকতে অইবো। আংগুরর সিরকা বা যেকুনু নমুনার সিরকা খাওয়া থাকিও তারা বাচিয়া রইবো। আর তারা তাজা আংগুর, কিছমিছ, বা আংগুরর রসও খাইতো নায়। ");
INSERT INTO syl_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","মুল কথা অইলো, এরা যতদিন নাজিরিয়া এতেকাফো রইবো, অতদিন আংগুর তো দুরর কথা, আংগুরর একটা বিচি বা বাকলও তারা কুনু লাখানউ খাইতো পারতো নায়। ");
INSERT INTO syl_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“আর যতদিনর লাগি নাজিরিয়া এতেকাফর নিয়তে নিজরে আলাদা রাখার মান্নত করছইন, অতদিন তারার মাথাত খুর-বেলেইট লাগানি নিষেধ। মাবুদর নামে আলাদা রওয়ার সময় এরা পাক-পাকিজা রইতে অইবো। মাথার চুল লাম্বা করতে অইবো। ");
INSERT INTO syl_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","ই সময় কুনু মরা লাশর গেছে যাইতো পারতো নায়। ");
INSERT INTO syl_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","তারার মা-বাবা, ভাই-বইন কেউ মারা গেলেও নিজরে নাপাক করতো পারতো নায়, কারন এরার মাথার মাজে তো আল্লার নামে আলাদা রওয়ার নিশানা চুল লাগাইল। ");
INSERT INTO syl_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","তারার ই আলাদা রওয়ার মিয়াদ না পুরা পর্যন্ত, পাক-পাকিজা রইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“আর আখতা কুনু মানুষ যুদি তার ছামনে মরিযায়, তে অউ মরার দায় মাবুদর নামে রাখা তার মাথার চুল নাপাক অইযাইবো, আর হিরবার পাক অওয়ার লাগি সাত দিনর দিন তার মাথা কামাইলিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","আর আট দিনর দিন হে দুইটা ডুপি পাখি বা দুইটা পারো লইয়া মিলন-তাম্বুর দুয়ারো ইমামর গেছে যাইবো। ");
INSERT INTO syl_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","মরা লাশর গেছে গিয়া হে নাপাক অওয়ায়, অখন তার নাপাকির গুনা মাফির লাগি ইমামে একটা পাখি দিয়া গুনার কফরার কুরবানি, আর দুছরা পাখি দিয়া জালাইল কুরবানি আদায় করবা। অউ দিনউ মাবুদর নামে তার মাথারে নয়া করি পাক-পাকিজা রাখতে অইবো। ");
INSERT INTO syl_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","আর আগর লাখান হিরবার মাবুদর নামে আলাদা রওয়ার মান্নত করা লাগবো। এরলগে দুষ-কছুরির কফরার লাগি এক বছর বয়সি এগু মেড়া-বাইচ্চা কুরবানি দিবো। তা-ও আগে যতদিন হে মাবুদর নামে আলাদা রইছিল, ইতা বাতিল অইযিবো, কারন হি সময় হে নাপাক অইগেছিল। ");
INSERT INTO syl_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“যেকুনু জনে মাবুদর নামে নাজিরিয়া এতেকাফর মিয়াদ পুরা করিয়া হারলে, পবিত্র মিলন-তাম্বুর দুয়ারর কান্দাত যাইবো। ");
INSERT INTO syl_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","গিয়া মাবুদর নামে জালাইল কুরবানির লাগি এক বছর বয়সি এগু নিখুত মেড়া-বাইচ্চা, আর গুনার কফরার কুরবানির লাগি এক বছর বয়সি এগু নিখুত মেড়ি-বাইচ্চা, এরলগে ছালামতি কুরবানির লাগি এগু নিখুত মেড়া আনতে অইবো। ");
INSERT INTO syl_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","অতার লগর ধান-গমর ছদগা আর শরবত-পানির ছদগা আনবো, এরলগে নিরেক গুড়িদি বানাইল তেলদি ভাজা এক টুকরি পিঠা আর তেল মাখাইল চাপাটি বানাইও। ইতা কুন্তাতউ খামির মিশাইও না। ");
INSERT INTO syl_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","ইমামে ইতা হকলতা নিয়া মাবুদর ছামনে থইয়া হারি, গুনার কফরার কুরবানি আর জালাইল কুরবানির লগে দিবা। ");
INSERT INTO syl_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","আর ছালামতি কুরবানির মেড়ার লগেও অলা খামির ছাড়া রুটি দিবা। এরলগর ধান-গমর ছদগা আর শরবত-পানির ছদগা আদায় করবা। ");
INSERT INTO syl_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","বাদে মিলন-তাম্বুর দুয়ারর গেছে নাজিরিয়া এতেকাফ কররা জনর মাথার চুল কামাইয়া, অউ চুল ছালামতি কুরবানির তলর আগুইনো ফালাইবা। ");
INSERT INTO syl_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","আর মাবুদর নামে রাখা অউ চুল কামানির বাদে ইমামে কুরবানির মেড়ার সিদ্ধ করা একখান গর্দনা আর টুকরি থাকি খামির ছাড়া একখান পিঠা আর একখান তেল মাখাইল চাপাটি নিয়া নাজিরিয়া এতেকাফ কররা জনর আতো দিবা। ");
INSERT INTO syl_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","বাদে ইমামে অতা নিয়া মাবুদর ছামনে উচা করি দুলাইবা। ইতা তো পাক-পবিত্র জিনিস, ইতা হক্কলতা ইমামর পাওনা। দুলাইয়া থওয়া ছিনার অউ গোস্ত আর কুরবানির পশুর রানও ইমামর পাওনা। ইতা হকলতা করার বাদে নাজিরিয়া এতেকাফ কররা অউ জনে আংগুরর শরবত খাইতা পারবা। ");
INSERT INTO syl_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ইতা তো নাজিরিয়া এতেকাফ কররা জনর লাগি আইন। মাবুদর নামে আলাদা রইয়া নাজিরিয়া এতেকাফর নিয়ম মাফিক, অতা হকলতা কুরবানি দিতে অইবো। আর যুদি তারার সাইধ্য মাফিক আরো কুন্তা করার নিয়ত করে, তে অতাও করতে অইবো। মাবুদর নামে আলাদা রওয়ার মান্নত মাফিক এতেকাফর জরুরি হক্কলতা এরা আদায় করবো।” ");
INSERT INTO syl_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“তুমি ইমাম হারুন আর তার পুয়াইনরে জানাই দেও, বনি ইছরাইলর লাগি দোয়া করার সময় তারা যানু অলা কইন, ");
INSERT INTO syl_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","মাবুদে দেউক্কা রহম-বরকত, আর করউক্কা তুমরারে হেফাজত। ");
INSERT INTO syl_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","তান নুরর রুশনি তুমরার উপরে পড়উক, তান মেহেরবানি হামেশা জারি রউক। ");
INSERT INTO syl_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","মাবুদে তান মুখ খান যানু তুমরার বায় ফিরাইন, আর তুমরারে শায়-শান্তি দান করইন। ");
INSERT INTO syl_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","অউ লাখান তারা বনি ইছরাইলর উপরে আমার নাম লইবা, তেউ আমি তারারে রহম-বরকত দিমু।” ");
INSERT INTO syl_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","হজরত মুছায় আল্লার ঘর বানানির কাম শেষ করিয়া হারি, পবিত্র তেল ছিটাইয়া ঘররে পাক-পবিত্র করলা। আর ঘরর হকল মাল-ছামানা, কুরবানি খানা আর এর লগর থাল-বাসন হক্কলতা পাক-পবিত্র করলা। ");
INSERT INTO syl_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","অউ দিন বনি ইছরাইলর বারো খান্দানর সর্দার অকল নানান জাতর উপহার লইয়া আইলা। এরা অইলা যারযির গুষ্টির পরধান মানুষ, তারার দায়িত্ব আছিল গনিয়া আলগ করা হকল মানষর দেখা-হুনা করা। ");
INSERT INTO syl_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","মাবুদর নামে তারা ছানি আলা ছয়খান গরুর গাড়ি, বারোগু গরু লইয়া আল্লার ঘরর ছামনে আইলা। পরতেক সর্দারর তরফ থাকি একটা করি গরু আর দুই জনর তরফ থাকি একখান করি গরুর গাড়ি দেওয়া অইলো। তারা ইতা আনিয়া আল্লার ঘরর ছামনে থইলা। ");
INSERT INTO syl_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","তেউ মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“তুমি তারার গেছ থাকি অতা সমজিয়া রাখো, যাতে মিলন-তাম্বুর কামো লাগানি যায়। লেবি খান্দানর খাদিম অকলর কাম বুজিয়া তারার মাজে অতা বাটিয়া দেও।” ");
INSERT INTO syl_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","এরলাগি মুছায় অউ গাড়ি আর গরু অগুইন লেবি খান্দানর খাদিম অকলরে বাটিয়া দিলা। ");
INSERT INTO syl_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","এরার মাজে লেবির পয়লা পুয়া জারছুনর গুষ্টির কাম মাফিক দুখান গরুর গাড়ি আর চাইরগু গরু তারারে দিলা, ");
INSERT INTO syl_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","আর আরক পুয়া মারারির গুষ্টির কাম বুজিয়া তারারে দিলা চাইর খান গাড়ি আর আটগু গরু। ইমাম হারুনর পুয়া ইছামারে অউ কামর তদারকি করলা। ");
INSERT INTO syl_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","অইলে লেবির পুয়া কাহাতর গুষ্টিরে ইতা কুন্তা দিলা না, কারন নিয়ম আছিল তারা খালি পাক-পবিত্র চিজ অকল দেখা-হুনা করা, আর অতারে কান্দো করি বইয়া নেওয়া। ");
INSERT INTO syl_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","কুরবানি খানাত পবিত্র তেল ছিটানির সময়, ইখানরে বওয়াল করার নিয়তে সর্দার অকলে যারযির বখশিশ লইয়া আইলা। আনিয়া কুরবানি খানার ছামনে থইলা। ");
INSERT INTO syl_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","মাবুদে মুছারে কইলা, “পরতেক দিন এক এক সর্দারে কুরবানি খানারে বওয়াল করার নিয়তে তান বখশিশ আনিয়া সমজাইবা।” ");
INSERT INTO syl_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","পয়লা দিন এহুদা খান্দানর সর্দার আমিনাদাবর পুয়া নাহিশে তান বখশিশ লইয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","তাইন ধান-গমর ছদগার লাগি এবাদত খানার মাপে একশো তিশ তোলা উজনর রুপার একখান থাল, আর সত্তইর তোলা উজনর রুপার এক গামলা আনিয়া দিলা, অউ থাল আর গামলাত ভরা আছিল ধান-গমর ছদগার নিয়তে তেল মাখাইল ময়দা। ");
INSERT INTO syl_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","আগর-খুশবয়ে ভরা দশ তোলা উজনর সোনার একটা বাটি, ");
INSERT INTO syl_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","জালাইল কুরবানির লাগি একটা বিছাল, একটা মেড়া, এক বছর বয়সি এগু মেড়া-বাইচ্চা, ");
INSERT INTO syl_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","গুনার কফরার কুরবানির লাগি এগু ছাগল, ");
INSERT INTO syl_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ছালামতি কুরবানির লাগি দুগু গরু, পাচগু মেড়া, পাচগু ছাগল আর এক বছর বয়সি পাচগু মেড়া-বাইচ্চা আনলা। ইতা অইলো আমিনাদাবর পুয়া নাহিশর উপহার। ");
INSERT INTO syl_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","দুই নম্বর দিন ইছাখর খান্দানর সর্দার ছুগারর পুয়া নথনেলে বখশিশ লইয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","তাইন ধান-গমর ছদগার লাগি এবাদত খানার মাপে একশো তিশ তোলা উজনর রুপার একখান থাল, আর সত্তইর তোলা উজনর রুপার এক গামলা আনিয়া দিলা, অউ থাল আর গামলাত ভরা আছিল ধান-গমর ছদগার নিয়তে তেল মাখাইল ময়দা। ");
INSERT INTO syl_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","আগর-খুশবয়ে ভরা দশ তোলা উজনর সোনার একটা বাটি, ");
INSERT INTO syl_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","জালাইল কুরবানির লাগি একটা বিছাল, একটা মেড়া, এক বছর বয়সি এগু মেড়া-বাইচ্চা, ");
INSERT INTO syl_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","গুনার কফরার কুরবানির লাগি এগু ছাগল, ");
INSERT INTO syl_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ছালামতি কুরবানির লাগি দুগু গরু, পাচগু মেড়া, পাচগু ছাগল আর এক বছর বয়সি পাচগু মেড়া-বাইচ্চা আনলা। অতা আছিল ছুগারর পুয়া নথনেলর উপহার। ");
INSERT INTO syl_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","তিন নম্বর দিন সবুলন খান্দানর সর্দার হেলনর পুয়া ইলিয়াবে বখশিশ লইয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","তাইন ধান-গমর ছদগার লাগি এবাদত খানার মাপে একশো তিশ তোলা উজনর রুপার একখান থাল, আর সত্তইর তোলা উজনর রুপার এক গামলা আনিয়া দিলা, অউ থাল আর গামলাত ভরা আছিল ধান-গমর ছদগার নিয়তে তেল মাখাইল ময়দা। ");
INSERT INTO syl_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","আগর-খুশবয়ে ভরা দশ তোলা উজনর সোনার একটা বাটি, ");
INSERT INTO syl_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","জালাইল কুরবানির লাগি একটা বিছাল, একটা মেড়া, এক বছর বয়সি এগু মেড়া-বাইচ্চা, ");
INSERT INTO syl_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","গুনার কফরার কুরবানির লাগি এগু ছাগল, ");
INSERT INTO syl_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ছালামতি কুরবানির লাগি দুগু গরু, পাচগু মেড়া, পাচগু ছাগল আর এক বছর বয়সি পাচগু মেড়া-বাইচ্চা আনলা। অতা আছিল হেলনর পুয়া ইলিয়াবর উপহার। ");
INSERT INTO syl_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","চাইর নম্বর দিন রুবেন খান্দানর সর্দার সাদিউরর পুয়া আলিছুরে বখশিশ লইয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","তাইন ধান-গমর ছদগার লাগি এবাদত খানার মাপে একশো তিশ তোলা উজনর রুপার একখান থাল, আর সত্তইর তোলা উজনর রুপার এক গামলা আনিয়া দিলা, অউ থাল আর গামলাত ভরা আছিল ধান-গমর ছদগার নিয়তে তেল মাখাইল ময়দা। ");
INSERT INTO syl_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","আগর-খুশবয়ে ভরা দশ তোলা উজনর সোনার একটা বাটি, ");
INSERT INTO syl_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","জালাইল কুরবানির লাগি একটা বিছাল, একটা মেড়া, এক বছর বয়সি এগু মেড়া-বাইচ্চা, ");
INSERT INTO syl_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","গুনার কফরার কুরবানির লাগি এগু ছাগল, ");
INSERT INTO syl_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ছালামতি কুরবানির লাগি দুগু গরু, পাচগু মেড়া, পাচগু ছাগল আর এক বছর বয়সি পাচগু মেড়া-বাইচ্চা আনলা। অতা আছিল সাদিউরর পুয়া আলিছুরর উপহার। ");
INSERT INTO syl_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","পাচ নম্বর দিন শিমিয়ন খান্দানর সর্দার সুরশাদায়র পুয়া শালুমিলে বখশিশ লইয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","তাইন ধান-গমর ছদগার লাগি এবাদত খানার মাপে একশো তিশ তোলা উজনর রুপার একখান থাল, আর সত্তইর তোলা উজনর রুপার এক গামলা আনিয়া দিলা, অউ থাল আর গামলাত ভরা আছিল ধান-গমর ছদগার নিয়তে তেল মাখাইল ময়দা। ");
INSERT INTO syl_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","আগর-খুশবয়ে ভরা দশ তোলা উজনর সোনার একটা বাটি, ");
INSERT INTO syl_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","জালাইল কুরবানির লাগি একটা বিছাল, একটা মেড়া, এক বছর বয়সি এগু মেড়া-বাইচ্চা, ");
INSERT INTO syl_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","গুনার কফরার কুরবানির লাগি এগু ছাগল, ");
INSERT INTO syl_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ছালামতি কুরবানির লাগি দুগু গরু, পাচগু মেড়া, পাচগু ছাগল আর এক বছর বয়সি পাচগু মেড়া-বাইচ্চা আনলা। অতা আছিল সুরশাদায়র পুয়া শালুমিলর উপহার। ");
INSERT INTO syl_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ছয় নম্বর দিন ছাদু খান্দানর সর্দার দোয়েলর পুয়া ইলিয়াছফে বখশিশ লইয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","তাইন ধান-গমর ছদগার লাগি এবাদত খানার মাপে একশো তিশ তোলা উজনর রুপার একখান থাল, আর সত্তইর তোলা উজনর রুপার এক গামলা আনিয়া দিলা, অউ থাল আর গামলাত ভরা আছিল ধান-গমর ছদগার নিয়তে তেল মাখাইল ময়দা। ");
INSERT INTO syl_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","আগর-খুশবয়ে ভরা দশ তোলা উজনর সোনার একটা বাটি, ");
INSERT INTO syl_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","জালাইল কুরবানির লাগি একটা বিছাল, একটা মেড়া, এক বছর বয়সি এগু মেড়া-বাইচ্চা, ");
INSERT INTO syl_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","গুনার কফরার কুরবানির লাগি এগু ছাগল, ");
INSERT INTO syl_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ছালামতি কুরবানির লাগি দুগু গরু, পাচগু মেড়া, পাচগু ছাগল আর এক বছর বয়সি পাচগু মেড়া-বাইচ্চা আনলা। অতা আছিল দোয়েলর পুয়া ইলিয়াছফর উপহার। ");
INSERT INTO syl_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","সাত নম্বর দিন আফরাইম খান্দানর সর্দার আমিহুদর পুয়া আলিশামায় বখশিশ লইয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","তাইন ধান-গমর ছদগার লাগি এবাদত খানার মাপে একশো তিশ তোলা উজনর রুপার একখান থাল, আর সত্তইর তোলা উজনর রুপার এক গামলা আনিয়া দিলা, অউ থাল আর গামলাত ভরা আছিল ধান-গমর ছদগার নিয়তে তেল মাখাইল ময়দা। ");
INSERT INTO syl_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","আগর-খুশবয়ে ভরা দশ তোলা উজনর সোনার একটা বাটি, ");
INSERT INTO syl_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","জালাইল কুরবানির লাগি একটা বিছাল, একটা মেড়া, এক বছর বয়সি এগু মেড়া-বাইচ্চা, ");
INSERT INTO syl_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","গুনার কফরার কুরবানির লাগি এগু ছাগল, ");
INSERT INTO syl_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ছালামতি কুরবানির লাগি দুগু গরু, পাচগু মেড়া, পাচগু ছাগল আর এক বছর বয়সি পাচগু মেড়া-বাইচ্চা আনলা। অতা আছিল আমিহুদর পুয়া আলিশামার উপহার। ");
INSERT INTO syl_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","আট নম্বর দিন মানশা খান্দানর সর্দার ফাতসুরর পুয়া গমলীয়েলে বখশিশ লইয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","তাইন ধান-গমর ছদগার লাগি এবাদত খানার মাপে একশো তিশ তোলা উজনর রুপার একখান থাল, আর সত্তইর তোলা উজনর রুপার এক গামলা আনিয়া দিলা, অউ থাল আর গামলাত ভরা আছিল ধান-গমর ছদগার নিয়তে তেল মাখাইল ময়দা। ");
INSERT INTO syl_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","আগর-খুশবয়ে ভরা দশ তোলা উজনর সোনার একটা বাটি, ");
INSERT INTO syl_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","জালাইল কুরবানির লাগি একটা বিছাল, একটা মেড়া, এক বছর বয়সি এগু মেড়া-বাইচ্চা, ");
INSERT INTO syl_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","গুনার কফরার কুরবানির লাগি এগু ছাগল, ");
INSERT INTO syl_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ছালামতি কুরবানির লাগি দুগু গরু, পাচগু মেড়া, পাচগু ছাগল আর এক বছর বয়সি পাচগু মেড়া-বাইচ্চা আনলা। অতা আছিল ফাতসুরর পুয়া গমলীয়েলর উপহার। ");
INSERT INTO syl_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","নয় নম্বর দিন বিন-ইয়ামিন খান্দানর সর্দার জিদাউনির পুয়া আবিদানে বখশিশ লইয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","তাইন ধান-গমর ছদগার লাগি এবাদত খানার মাপে একশো তিশ তোলা উজনর রুপার একখান থাল, আর সত্তইর তোলা উজনর রুপার এক গামলা আনিয়া দিলা, অউ থাল আর গামলাত ভরা আছিল ধান-গমর ছদগার নিয়তে তেল মাখাইল ময়দা। ");
INSERT INTO syl_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","আগর-খুশবয়ে ভরা দশ তোলা উজনর সোনার একটা বাটি, ");
INSERT INTO syl_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","জালাইল কুরবানির লাগি একটা বিছাল, একটা মেড়া, এক বছর বয়সি এগু মেড়া-বাইচ্চা, ");
INSERT INTO syl_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","গুনার কফরার কুরবানির লাগি এগু ছাগল, ");
INSERT INTO syl_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ছালামতি কুরবানির লাগি দুগু গরু, পাচগু মেড়া, পাচগু ছাগল আর এক বছর বয়সি পাচগু মেড়া-বাইচ্চা আনলা। অতা আছিল জিদাউনির পুয়া আবিদানর উপহার। ");
INSERT INTO syl_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","দশ নম্বর দিন দান খান্দানর সর্দার আমিশাদার পুয়া আখিআজারে বখশিশ লইয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","তাইন ধান-গমর ছদগার লাগি এবাদত খানার মাপে একশো তিশ তোলা উজনর রুপার একখান থাল, আর সত্তইর তোলা উজনর রুপার এক গামলা আনিয়া দিলা, অউ থাল আর গামলাত ভরা আছিল ধান-গমর ছদগার নিয়তে তেল মাখাইল ময়দা। ");
INSERT INTO syl_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","আগর-খুশবয়ে ভরা দশ তোলা উজনর সোনার একটা বাটি, ");
INSERT INTO syl_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","জালাইল কুরবানির লাগি একটা বিছাল, একটা মেড়া, এক বছর বয়সি এগু মেড়া-বাইচ্চা, ");
INSERT INTO syl_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","গুনার কফরার কুরবানির লাগি এগু ছাগল, ");
INSERT INTO syl_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ছালামতি কুরবানির লাগি দুগু গরু, পাচগু মেড়া, পাচগু ছাগল আর এক বছর বয়সি পাচগু মেড়া-বাইচ্চা আনলা। অতা আছিল আমিশাদার পুয়া আখিআজারর উপহার। ");
INSERT INTO syl_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","এগারো নম্বর দিন আশির খান্দানর সর্দার উকরানর পুয়া ফজিয়েলে বখশিশ লইয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","তাইন ধান-গমর ছদগার লাগি এবাদত খানার মাপে একশো তিশ তোলা উজনর রুপার একখান থাল, আর সত্তইর তোলা উজনর রুপার এক গামলা আনিয়া দিলা, অউ থাল আর গামলাত ভরা আছিল ধান-গমর ছদগার নিয়তে তেল মাখাইল ময়দা। ");
INSERT INTO syl_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","আগর-খুশবয়ে ভরা দশ তোলা উজনর সোনার একটা বাটি, ");
INSERT INTO syl_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","জালাইল কুরবানির লাগি একটা বিছাল, একটা মেড়া, এক বছর বয়সি এগু মেড়া-বাইচ্চা, ");
INSERT INTO syl_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","গুনার কফরার কুরবানির লাগি এগু ছাগল, ");
INSERT INTO syl_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ছালামতি কুরবানির লাগি দুগু গরু, পাচগু মেড়া, পাচগু ছাগল আর এক বছর বয়সি পাচগু মেড়া-বাইচ্চা আনলা। অতা আছিল উকরানর পুয়া ফজিয়েলর উপহার। ");
INSERT INTO syl_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","বারো নম্বর দিন নপ্তালি খান্দানর সর্দার ইনানর পুয়া আহিরে বখশিশ লইয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","তাইন ধান-গমর ছদগার লাগি এবাদত খানার মাপে একশো তিশ তোলা উজনর রুপার একখান থাল, আর সত্তইর তোলা উজনর রুপার এক গামলা আনিয়া দিলা, অউ থাল আর গামলাত ভরা আছিল ধান-গমর ছদগার নিয়তে তেল মাখাইল ময়দা। ");
INSERT INTO syl_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","আগর-খুশবয়ে ভরা দশ তোলা উজনর সোনার একটা বাটি, ");
INSERT INTO syl_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","জালাইল কুরবানির লাগি একটা বিছাল, একটা মেড়া, এক বছর বয়সি এগু মেড়া-বাইচ্চা, ");
INSERT INTO syl_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","গুনার কফরার কুরবানির লাগি এগু ছাগল, ");
INSERT INTO syl_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ছালামতি কুরবানির লাগি দুগু গরু, পাচগু মেড়া, পাচগু ছাগল আর এক বছর বয়সি পাচগু মেড়া-বাইচ্চা আনলা। অতা আছিল ইনানর পুয়া আহিরর উপহার। ");
INSERT INTO syl_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","তে পবিত্র তেল দিয়া কুরবানি খানারে বওয়াল করার সময় বনি ইছরাইলর সর্দার অকলে যেতা দান করছলা ইতা অইলো, বারো খান রুপার থাল, বারোটা রুপার গামলা আর বারোটা সোনার বাটি। ");
INSERT INTO syl_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","এবাদত খানার মাপে পরতেক রুপার থালর উজন আছিল একশো তিশ তোলা আর গামলার উজন আছিল সত্তইর তোলা। রুপার হকল থাল-বাসনর মোট উজন আছিল দুই আজার চাইরশ তোলা। ");
INSERT INTO syl_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","আগর-খুশবয়ে ভরা পরতেক সোনার বাটির উজন আছিল দশ তোলা, সোনার বারোটা বাটির মোট উজন আছিল একশো বিশ তোলা। ");
INSERT INTO syl_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","জালাইল কুরবানির লাগি মোট বারোগু বিছাল, বারোগু মেড়া আর এক বছর বয়সি বারোগু মেড়া-বাইচ্চাও এরা দান করছলা। আর এরলগর ধান-গমর ছদগার হকল জিনিস। গুনার কফরার কুরবানির লাগি মোট বারোগু ছাগল দেওয়া অইছিল। ");
INSERT INTO syl_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","ছালামতি কুরবানির লাগি মোট চব্বিশগু গরু, ষাইটগু মেড়া, ষাইটগু ছাগল, এক বছর বয়সি ষাইটগু মেড়া-বাইচ্চা। পবিত্র তেল ছিটাইয়া হারি কুরবানি খানারে বওয়াল করার সময় উপহার হিসাবে ই হকলতা দেওয়া অইছিল। ");
INSERT INTO syl_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","এরবাদে মুছা নবীয়ে যেবলাউ মাবুদর লগে বাতচিত করার লাগি মিলন-তাম্বুত হামাইতা, অউ সময় শাহাদত সন্দুকর ঢাকনার উপরে যে দুইও কারুবী রইন, এরার মাজখান থাকি তান বুলি হুনতা। মাবুদে অউ নমুনায় মুছা নবীর লগে বাতচিত করতা। ");
INSERT INTO syl_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","মাবুদে মুছা নবীরে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“তুমি হারুনরে কও, আমার ঘরর চেরাগ দানির মাজর সাতোটা চেরাগ অউ নমুনায় লাগাইতা, যাতে চেরাগর ফর চেরাগ দানির ছামনা বায় পড়ে।” ");
INSERT INTO syl_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","হারুনে অলাউ করলা। মুছারে বাতাইল মাবুদর হুকুম মাফিক তাইন হকল চেরাগ অলাখান বওয়াইলা, যাতে চেরাগর ফর চেরাগ দানির ছামনেদি পড়ে। ");
INSERT INTO syl_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","চেরাগ দানির তল থাকি আগার ফুল পর্যন্ত আস্তাটা খাটি সোনা পিটাইয়া বানাইল অইলো। মাবুদে মুছারে যেলা নকশা দেখাইছলা, ঠিক অউ লাখান চেরাগ দানি বানাইল অইলো। ");
INSERT INTO syl_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“তুমি বনি ইছরাইলর মাজ থাকি, লেবি খান্দানরে আলগ করিয়া পাক-পাকিজা করো। ");
INSERT INTO syl_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","ই পাক-পাকিজা করার নিয়ম অইলো, পয়লা তারার উপরে পাক-পবিত্র অওয়ার পানি ছিটাইয়া দিবায়, ছিটাইয়া তারা নিজে আস্তা শরিলর চুল কামাইয়া কাপড়-চুপড় ধইয়া পাক-ছাফ বনবা। ");
INSERT INTO syl_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","আর তারা কুরবানির লাগি এগু বিছাল আনবা, বিছালর লগে ধান-গমর ছদগার লাগি তেল মাখাইল ময়দা, গুনার কফরার কুরবানির লাগিও আরকটা বিছাল আনাইও। ");
INSERT INTO syl_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","বাদে তুমি লেবি অকলরে লইয়া মিলন-তাম্বুর ছামনে আইবায়, আইয়া হক্কল বনি ইছরাইলরে হনো দলা করবায়। ");
INSERT INTO syl_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","লেবি অকলরে তুমি মাবুদর দরবারো আজির করবায় আর হকল বনি ইছরাইলে তারারে আতাইয়া সপিয়া দিবা। ");
INSERT INTO syl_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","ইমাম হারুনে হকল বনি ইছরাইলর পক্ষ থাকি, দুলনা কুরবানি হিসাবে লেবি অকলরে মাবুদর ছামনে বখশিয়া দিবা, তেউ তারা মাবুদর খেজমতো কাম-কাজ করতা পারবা। ");
INSERT INTO syl_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","বাদে লেবি অকলে হউ দুইও বিছালর কল্লার উপরে আতাই দিবা, দিলে তুমি এর একটা দিয়া গুনার কফরার কুরবানি আর দুছরাটা দিয়া জালাইল কুরবানি আদায় করিও। অলাখান লেবি অকলর নাপাকির কফরা আদায় অইবো। ");
INSERT INTO syl_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","তুমি লেবি অকলরে হারুন আর তার পুয়াইন্তর ছামনে উবা করাইয়া, মাবুদর নামে তারারে দুলনা কুরবানি হিসাবে সপিয়া দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","অউ লাখান তুমি অইন্য বনি ইছরাইল থাকি লেবি খান্দানরে আলগ করবায়, তেউ তারা খালি আমার অইবা। ");
INSERT INTO syl_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“লেবি অকলরে পাক-পাকিজা করিয়া দুলনা কুরবানি হিসাবে সপিয়া দিয়া হারলে, তারা মিলন-তাম্বুর খেজমতো আইবা। ");
INSERT INTO syl_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","বনি ইছরাইল থাকি বাছিয়া আলগ করা ই লেবি খান্দান খালি আমার, আর কেউরর নায়। পরতেক ইছরাইলি বেটিন্তর পয়লা পুয়ার বদলা আমি লেবি খান্দানরে আমার নিজর বানাইছি। ");
INSERT INTO syl_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","বনি ইছরাইলর ঘরো জনম লওয়া হকল পয়লা পুয়াইন আমার। আমি মিসরী অকলর পয়লা পুয়াইন্তরে মারিলিবার কালো, বনি ইছরাইলর পরতেক পয়লা পুয়ারে আমার লাগি পবিত্র করিয়া রাখছি, ইতা মানষর পুত অউক বা পশুর বাইচ্চা অউক, ইতা তো আমার। ");
INSERT INTO syl_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","আর অখন আমি বনি ইছরাইলর পয়লা পুয়াইন্তর জাগাত খালি লেবি অকলরে আমার নিজর কইয়া কবুল করছি। ");
INSERT INTO syl_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","অউ লেবি অকলরে আমি হারুন আর তার পুয়াইন্তরে সমজাইছি, যাতে তারা বনি ইছরাইলর অইয়া মিলন-তাম্বুর খেজমত করইন, তারার গুনার কফরার উছিলা করইন। এরলাগি বনি ইছরাইলর কেউ আমার ঘরর কান্দাত আইলেও তার উপরে কুনু গজব লামতো নায়।” ");
INSERT INTO syl_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","মাবুদে লেবি অকলর বেয়াপারে মুছা নবীরে যেলা হুকুম দিছলা, অউ হুকুম মাফিক মুছা, হারুন আর হকল বনি ইছরাইলে অলা করলা। ");
INSERT INTO syl_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","লেবি অকলে নিজরে পাক-ছাফ করিয়া হারি তারার কাপড়-চুপড়ও ধইলা। বাদে হারুনে তারারে মাবুদর নামে দুলনা কুরবানি হিসাবে সপিয়া দিলা, আর তারারে পাক-পাকিজা করার নিয়তে তারার গুনার কফরার বেবস্থা করলা। ");
INSERT INTO syl_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","এরবাদে লেবি অকলও হারুন আর তান পুয়াইন্তর জিম্মায় মিলন-তাম্বুর খাদিমদারিত গেলা। গেলে মাবুদে মুছারে লেবি অকলর বেয়াপারে যেলা হুকুম দিছলা, ঠিক অউলা করা অইলো। ");
INSERT INTO syl_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","বাদে মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“লেবি অকলর বেয়াপারে অউ নিয়ম চালু অইবো, তারার মাজে পচিশ বছর বা তার বেশি বয়সি মানষে মিলন-তাম্বুর কাম-কাজ করবা, ");
INSERT INTO syl_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","অইলে পইঞ্চাশ বছর অইয়া হারলে তারা অবসর পাইলিবা, খেজমত কাম বাদ দিলাইবা। ");
INSERT INTO syl_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","অউ সময় তারা নিজর আতে মিলন-তাম্বুর কুনু কাম করা নিষেধ, অইলে তারার মনে চাইলে ভাইয়াইন্তরে মিলন-তাম্বুর কামো সায়-সাইয্য করবা। অউ নিয়মে তুমি লেবি অকলর কাম-কাজ ঠিক করি দিবায়।” ");
INSERT INTO syl_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","বনি ইছরাইল জাতি মিসর দেশ থাকি বারনির দুছরা বছরর পয়লা চান্দো, সিনাই মরুভুমিত মাবুদে মুছা নবীরে বাতাইলা, ");
INSERT INTO syl_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“বনি ইছরাইলে যানু ঠিক সময়ে আজাদি ইদ আদায় করইন। ");
INSERT INTO syl_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","তারা অউ চান্দর চৌদ্দ তারিখ হাইঞ্জা বালা আমার নিয়ম-কানুন মানিয়া ইদ আদায় করতে অইবো।” ");
INSERT INTO syl_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","মাবুদর হুকুম পাইয়া মুছায় বনি ইছরাইলরে জানাইলা আজাদি ইদ আদায় করার লাগি। ");
INSERT INTO syl_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","এরদায় তারা পয়লা চান্দর চৌদ্দ তারিখ হাইঞ্জা বালা সিনাই মরুভুমিত অউ ইদ আদায় করলা। মাবুদে মুছারে যেলাখান হুকুম দিছলা, তারা ঠিক অলাখান হকলতা করলা। ");
INSERT INTO syl_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","অইলে তারার মাজে কয়জনে মরা লাশরে ছইয়া নাপাক অওয়ায়, অউ দিন আজাদি ইদ করতো পারলো না। এরলাগি অউ দিনউ তারা মুছা আর হারুন নবীর গেছে গিয়া আজির অইলা। ");
INSERT INTO syl_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","তারা মুছারে জিকাইলা, “মরা লাশ ছওয়ায় আমরা নাপাক অইছি, এরলাগি বনি ইছরাইলর লগে ঠিক সময় মাবুদর নামে কুরবানি দিতাম পারতাম না কেনে?” ");
INSERT INTO syl_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","মুছায় জুয়াপ দিলা, “তুমরার বেয়াপারে মাবুদর হুকুম না জানা পর্যন্ত তুমরা বার চাও।” ");
INSERT INTO syl_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","অউ সময় মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“তুমি বনি ইছরাইলরে কও, তারা বা তারার বংশর কেউ যুদি মরা লাশরে ধরা-ছোয়ার কারনে নাপাক বনিযায়, বা মুছাফির হালতে লাম্বা ছফরো থাকে, তে তারাও মাবুদর নামে আজাদি ইদ আদায় করতা পারবা। ");
INSERT INTO syl_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","দুছরা চান্দর চৌদ্দ তারিখ হাইঞ্জা বালা তারা অউ ইদ করবা। আজাদি ইদর গোস্তর লগে খামির ছাড়া রুটি আর তিত্বা হাগ পুরাইয়া খাইবা। ");
INSERT INTO syl_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","বিয়ান পর্যন্ত কুনুজাত খানি জমা রাখা নিষেধ, কুরবানির গোস্তর যেকুনু আড্ডি ভাংগা নিষেধ। আজাদি ইদর অউ হকল নিয়ম-কানুন তারা মানতে অইবো। ");
INSERT INTO syl_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","অইলে যেরা পাক-পাকিজা হালতে আছে, আর যেরা ছফরর মাজে নায়, ইলা কুনু জনে যুদি আজাদি ইদর কুরবানি না দেয়, তে মাবুদর ঠিক করা সময়ে কুরবানি না দেওয়ায়, তার জাতি থাকি তার নাম মিটাইলিবায়। তার গুনার সাজা হে পাইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“বনি ইছরাইলর মাজে বসত কররা বিদেশি কুনু মানষে যুদি মাবুদর নামে আজাদি ইদ আদায় করতো চায়, তে করতো পারবো। অইলে অউ ইদর নিয়ম-কানুন মানিয়া আদায় করতে অইবো। বনি ইছরাইল বা ভিন-দেশি হকলেউ একই নিয়ম মানতে অইবো।” ");
INSERT INTO syl_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","আল্লার ঘর শাহাদত তাম্বু যেদিন খাড়া করা অইলো, অউ দিন কুদরতি মেঘর খুটি আইয়া আস্তা ঘররে গুরিলিলো। হাইঞ্জা থাকি বিয়ান পর্যন্ত হারা রাইত ই মেঘর খুটিরে নুরর আগুনির লাখান দেখা গেল। ");
INSERT INTO syl_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","এরবাদ থাকি অলা অইলো, আল্লার ঘর দিনর বালা হামেশা মেঘর খুটিয়ে গুরা রইতো, আর রাইতর বালা মনো অইতো ইতা নুরর আগুনির খুটি। ");
INSERT INTO syl_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","আর পবিত্র তাম্বুর উপরে থাকি মেঘর খুটি যেবলা হরতো, অউ সময় বনি ইছরাইল অকল ছফরো বার অইতা, বাদে যেনো গিয়া অউ খুটি থির অইতো, তারা অখানোউ তাম্বু অকল গাড়িতা। ");
INSERT INTO syl_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","মাবুদর হুকুমে তারা ছফরো বার অইতা আর তান হুকুমেউ ছফর বন্দ করিয়া তাম্বু গাড়িতা। আল্লার ঘরর উপরে যতবইল মেঘর খুটি রইতো, তারা অতবইল কেম্পর ভিতরে রইতা। ");
INSERT INTO syl_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","আল্লার ঘরর উপরে মেঘর খুটি বেশি দিন রইলে, মাবুদর হুকুম মানিয়া তারা কুনু ছফরো বার অইতা না। ");
INSERT INTO syl_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","মাজে মাজে মেঘর খুটি আল্লার ঘরর উপরে থুড়া দিন রইতো। বনি ইছরাইল তো মাবুদর হুকুমে কেম্পো রইতা আর তান হুকুমেউ হিরবার ছফরো বার অইতা। ");
INSERT INTO syl_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","আর মাজে মাজে খালি হাইঞ্জা থাকি বিয়ান পর্যন্ত মেঘর খুটি রইতো। বিয়ানে মেঘর খুটি হরিগেলে তারা ছফরো বার অইতা। দিনো বা রাইত যেকুনু সময় মেঘর খুটি হরার লগে লগেউ তারা ছফরো বার অইতা। ");
INSERT INTO syl_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","যতদিন মেঘর খুটি আল্লার ঘরর উপরে রইতো, অতদিন তারা কেম্পো রইতা, ছফরো বার অইতা না। ইতা দুই দিন অউক, একমাস বা এর বেশি অইলেও বার অইতা না, খালি মেঘর খুটি হরার বাদে তারা ছফরো বার অইতা। ");
INSERT INTO syl_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","মাবুদর হুকুমে তারা কেম্প গাড়িতা আর তান হুকুমেউ ছফরো রওয়ানা অইতা। মুছা নবীর মারফতে পাওয়া হুকুম মাফিক, তারা মাবুদর অউ নিয়ম মানিয়া চলতা। ");
INSERT INTO syl_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“তুমি রুপার পাত পিটাইয়া দুইটা চুংগা বানাও। বনি ইছরাইলরে একখানো দলা করার নিয়তে ডাকিবার লাগি অউ চুংগা বাজাইও, তারার নানান দল ছফরো রওয়ানা অওয়ার বালাও তুমি অগুইন বাজাইও। ");
INSERT INTO syl_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","অউ দুইও চুংগা যেবলা একলগে বাজানি অইবো, অউ সময় হকল বনি ইছরাইল তুমার ছামনে মিলন-তাম্বুর দুয়ারর গেছে আইয়া দলা অইবা। ");
INSERT INTO syl_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","অইলে একটা চুংগা বাজানি অইলে খালি বনি ইছরাইলর নানান খান্দানর সর্দার অকল তুমার ছামনে আইয়া দলা অইবা। ");
INSERT INTO syl_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","পয়লা বার চুংগা বাজাইলে মিলন-তাম্বুর পুবেদি যেরা তাম্বু টাংগাইছে, তারা রওয়ানা দিবা। ");
INSERT INTO syl_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","দুছরা বার বাজাইলে দউকনর গালার দল অকল রওয়ানা দিবা। ইকটা তো ছফরো রওয়ানা দিবার সংকেত। ");
INSERT INTO syl_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","তে হকল মানষরে দলা করার লাগি তুমি দুইও চুংগা বাজাইও, অইলে এর সুর অইবো আলাদা রকমর। ");
INSERT INTO syl_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","অউ চুংগা বাজাইবা ইমাম হারুনর বংশর ইমাম অকলে। ইটা তুমরার লাগি আর তুমরার বংশধরর লাগিও চিরকালিন নিয়ম। ");
INSERT INTO syl_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“নিজর দেশো গিয়া হারলে তুমরা যেবলা কুনু জুলুমবাজ দুশমনর লগে লাড়াইত বার অইবায়, অউ সময় দুইও চুংগা বাজাইয়া সংকেত দিবায়। তেউ তুমরার মাবুদ আল্লায় তুমরার বায় খিয়াল করিয়া দুশমনর আত থাকি তুমরারে বাচাইবা। ");
INSERT INTO syl_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","তুমরার খুশি-বাসির অনুষ্টানো, তুমরার হকল ইদো, চান্দর পয়লা দিন যেবলা জালাইল কুরবানি বা ছালামতি কুরবানি দিবায়, অউ সময়ও চুংগা বাজাইও। অউ আওয়াজ হুনলে তুমরার আল্লায় তুমরার বায় চউখ ফিরাইবা। মনো রাখিও, আমি আল্লাউ তুমরার মাবুদ।” ");
INSERT INTO syl_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","বনি ইছরাইল জাতি মিসর থাকি বারনির দুছরা বছরর দুছরা চান্দর বিশ তারিখ শাহাদত তাম্বু মানি আল্লার ঘরর উপরে থাকি কুদরতি মেঘর খুটি হরিগেল। ");
INSERT INTO syl_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","অউ সময় বনি ইছরাইলে সিনাই মরুভুমি থাকি রওয়ানা দিলা। হউ মেঘর খুটি ফারান মরুভুমিত আইয়া থির না অওয়া পর্যন্ত তারা চলাতউ রইলা। ");
INSERT INTO syl_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","মুছা নবীর মাজদি মাবুদর হুকুম পাইয়া, তারা পয়লা বার অউ ছফরো রওয়ানা অইলা। ");
INSERT INTO syl_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","পয়লাউ এহুদার পতাকার তিনো খান্দানর নানান ফৌজি দলে রওয়ানা দিলা, এরার নেতা আছলা আমিনাদাবর পুয়া নাহিশ। ");
INSERT INTO syl_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","এরার মাজে ইছাখর খান্দানর মানষর দায়িত্ব আছিল ছুগারর পুয়া নথনেলর উপরে, ");
INSERT INTO syl_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","আর সবুলন খান্দানর মানষর দায়িত্ব আছিল হেলনর পুয়া ইলিয়াবর উপরে। ");
INSERT INTO syl_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","বাদে আল্লার ঘরর হকলতা খুলা অইলো, তেউ জারছুনী আর মারারিয়া অকলে অখানর হকলতা বইয়া লইয়া রওয়ানা দিলা। ");
INSERT INTO syl_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","এরার বাদে রুবেনর পতাকার তিনো খান্দানর ফৌজি দলে রওয়ানা দিলা, এরার সর্দার অইলা সাদিউরর পুয়া আলিছুর। ");
INSERT INTO syl_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","এরার মাজে শিমিয়ন খান্দানর দায়িত্ব আছিল সুরশাদায়র পুয়া শালুমিলর উপরে, ");
INSERT INTO syl_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","আর ছাদু খান্দানর দায়িত্ব আছিল, দোয়েলর পুয়া ইলিয়াছফর উপরে। ");
INSERT INTO syl_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","এরার বাদে আল্লার ঘরর পাক-পবিত্র মাল-ছামানা লইয়া কাহাতী অকলে রওয়ানা দিলা। কাহাতী অকল জাগাত গিয়া পৌছার আগেউ আল্লার ঘর খাড়া করার কথা আছিল। ");
INSERT INTO syl_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","এরবাদে আফরাইম পতাকার তিনো ফৌজি দলর মানষে রওয়ানা দিলা, এরার সর্দার অইলা আমিহুদর পুয়া আলিশামা। ");
INSERT INTO syl_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","এর মাজে মানশা খান্দানর দায়িত্ব আছিল ফাতসুরর পুয়া গমলীয়েলর উপরে। ");
INSERT INTO syl_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","আর বিন-ইয়ামিন খান্দানর দায়িত্ব আছিল জিদাউনির পুয়া আবিদানর উপরে। ");
INSERT INTO syl_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","হকল হেশে রওয়ানা অইলা দান পতাকার তিনো খান্দানর ফৌজি দলর মানষে, তারার সর্দার অইলা আমিশাদার পুয়া আখিআজার। এরার ছামনর হকল ফৌজি দলরে পারা দিয়া তারার খরে খরে রইলা। ");
INSERT INTO syl_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","এর মাজে আশির খান্দানর দায়িত্ব আছিল উকরানর পুয়া ফজিয়েলর উপরে, ");
INSERT INTO syl_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","আর নপ্তালি খান্দানর দায়িত্ব আছিল ইনানর পুয়া আহিরর উপরে। ");
INSERT INTO syl_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","অউ লাখান বনি ইছরাইলর নানান ফৌজি দল একে একে রওয়ানা অইলা। ");
INSERT INTO syl_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","এরবাদে মুছায় মাদিয়ান দেশর তান হউর শোয়াইব নবীর পুয়া হোববরে কইলা, “মাবুদে আমরারে যে দেশ দিবার ওয়াদা করছইন, আমরা হউ দেশো যাইরামগি। তে তুমিও আমরার লগে আও। মাবুদে তো ওয়াদা করছইন, তাইন বনি ইছরাইলরে বউত মেহেরবানি করবা। অখন তুমি আমরার লগে আইলে আমরা তুমারে খুব মায়া-দয়া করমু।” ");
INSERT INTO syl_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","হোববে জুয়াপ দিলা, “না, আমি যাইতাম নায়। আমি আমার দেশো নিজর মানষর গেছে ফিরিয়া যাইমুগি।” ");
INSERT INTO syl_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","অইলে মুছায় কইলা, “না, না, তুমি আমরারে ফালাইয়া যাইও না। তুমিউ আমরার পথ দেখাওরা জন। মরুভুমির মাজে কুন জাগাত আমরার তাম্বু গাড়া উচিত, ইতা তো তুমার জানা আছে, এরলাগি তুমিউ অইলায় আমরার চউখ। ");
INSERT INTO syl_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","হুনো, তুমি যুদি আমরার লগে আও, তে মাবুদে আমরারে যত মেহেরবানি করার ওয়াদা করছইন, তুমারেও অতার বাট দিমু।” ");
INSERT INTO syl_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","অউ লাখান বনি ইছরাইলে মাবুদর পাহাড় থাকি রওয়ানা অইয়া তিন দিনর পথ আগুয়াই গেলা। আর জিরাইবার লাগি একখান জাগা তুকাইয়া বার করার খিয়ালে, মাবুদর হউ পবিত্র শাহাদত সন্দুক তিন দিন ধরি তারার আগে আগে গেল। ");
INSERT INTO syl_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","কেম্প থাকি রওয়ানা অওয়ার বাদে, দিনর বেলা মাবুদর গাইবি মেঘর খুটি বনি ইছরাইলর উপরে রইতো। ");
INSERT INTO syl_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","অউ শাহাদত সন্দুক রওয়ানা অইলেউ মুছায় কইতা, “ও মাবুদ, চলউক্কা। তুমার দুশমন অকল চাইরোবায় ছিতরি যাউক, তুমারে যেতায় ইংসাইন, ইতা তুমার ছামন থাকি বাগউক।” ");
INSERT INTO syl_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","আর যেবলা অউ সন্দুক থামিযিতো, তাইন কইতা, “ও মাবুদ, লাখ লাখ বনি ইছরাইলর গেছে তুমি ফিরিয়া আও।” ");
INSERT INTO syl_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","বনি ইছরাইলে নিজর দুখ-কষ্টর লাগি বেজার অইয়া বকা-জকা করলা। এরলাগি মাবুদে তারার ইতা হুনিয়া গুছা অইগেলা। তাইন গজবি আগুইন পাঠাইলা আর অউ আগুইন তারার মাজে জলিলো, এতে কেম্পর কিনারার কিছু অংশ আগুইনে জলিগেল। ");
INSERT INTO syl_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","এরদায় তারা মুছা নবীর গেছে গিয়া কান্দা-কাটি লাগাইলা, তেউ মুছায় মাবুদর দরবারো দোয়া করায় আগুইন নিভি গেল। ");
INSERT INTO syl_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","মাবুদর আগুইন তারার মাজে জলছিল করি, অউ জাগার নাম অইগেল তাবেরা। ");
INSERT INTO syl_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","বনি ইছরাইলর লগে অইন্যান্য জাতির যেতা মানুষ আছলা, তারা দুছরা জাতর মজার কুনু খানির লাগি পাগল বনিগেলা, আর এরার দেখা-দেখি বনি ইছরাইলেও হিরবার কান্দা-কাটি করি কইলা, “ইস, আমরা যুদি গোস্ত খাইতাম পারতাম! ");
INSERT INTO syl_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","মিসরো থাকতে তো বিনা পয়সায় মাগনা মাছ খাইতাম, হনো তরমুজ, পিয়াজ-রসুন, কিরা, হাগ-তরকারি হক্কলতা খাইতাম, ইতা অখনও মনো পড়ের। ");
INSERT INTO syl_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","অইলে অখন আমরার কইলজা হুকাই গেছে। ইনো তো খালি মান্না ছাড়া খাওয়ার আর কুন্তাউ নাই।” ");
INSERT INTO syl_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","অউ মান্না দেখতে ঢুলা বাখরর লাখান, এর রং অইলো কিছমিছর লাখান। ");
INSERT INTO syl_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","মানষে চাইরোবায় থাকি মান্না তুকাইয়া আনিয়া ঘাইল-ছিয়াদি কুটিয়া বা হিল-পাটাদি ছেচিয়া গুড়া করতা। বাদে ইতা পাতিলো উনা দিয়া বা পিঠা বানাইয়া খাইতা। ইতা খাইতে তেলদি বানাইল পিঠার লাখান মজা। ");
INSERT INTO syl_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","রাইতর বালা বনি ইছরাইলর কেম্পর আশে-পাশে খুয়া পড়তো, অউ খুয়ার লগে অইয়া বেহেস্তি খানি মান্নাও পড়তো। ");
INSERT INTO syl_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","মুছা নবীর কানো আইলো, পরতেক ঘরর মানষে যারযির তাম্বুর দুয়ারর গেছে উবাইয়া কান্দিরা। এরদায় তাইন খুব বেজার অইলা, আর মাবুদও গুছায় আগুইন অইগেলা। ");
INSERT INTO syl_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","তেউ মুছায় মাবুদরে কইলা, “তুমি কেনে তুমার ই গুলামরে ইলা বিপদো ফালাইলায়? আমি কিতা দুষ করলাম, যে কারনে অতা মানষর ভার আমার কান্দো দিলায়? ");
INSERT INTO syl_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","আমি কুনু তারারে পেটো লইছি নি, বা তারা আমার পেট থাকি জনমিছে নি? তুমি তারার বাফ-দাদাইন্তর গেছে যে দেশ দিবার ওয়াদা করছিলায়, তারারে হনো নিবার লাগি আমারে কেনে তারার পালক-বাফর লাখান বানাইছো, আর তারারে কুলো করি নিবার কথা কেনে কইরায়? ");
INSERT INTO syl_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","ইতা মানষর খানির লাগি আমি অখন গোস্ত কুয়াই পাইতাম? তারা আমার গেছে খালি গোস্ত গোস্ত কইয়া চিল্লাইরা। ");
INSERT INTO syl_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","তারার জিম্মা নেওয়া বড় মশকিল, আমার একার পক্ষে ই জিম্মা নেওয়া সম্ভব নায়। ");
INSERT INTO syl_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","তুমি যুদি আমারে ই মশকিলো ফালাও, তে তুমার দুয়াই দিয়া কইয়ার, অখনউ আমারে জানে মারিলাও। আর কইরাম, আমি যুদি তুমার রহমতর তলে থাকি, তে নিজর চউখে নিজর বেহাল্লতি দশা আমারে দেখাইও না।” ");
INSERT INTO syl_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","তেউ মাবুদে মুছারে কইলা, “বনি ইছরাইলর মাজে তুমি যারারে মুরব্বি নেতা আর ইজ্জতি হিসাবে চিনো, এরার মাজ থাকি সত্তইর জন মুরব্বি নেতারে লইয়া আমার গেছে আও। তুমি তারারে কও, তারা মিলন-তাম্বুর গেছে আইয়া তুমার লগে উবাইতা। ");
INSERT INTO syl_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","আমি হনো লামিয়া আইয়া তুমার লগে বাতচিত করমু। তুমার মাজে আল্লার যে রুহ আছইন, অউ রুহ আমি তারার উপরেও দান করমু। মানষর জিম্মাদারি বইয়া নিতে তারাও তুমারে সাইয্য করবা। তেউ তুমার একলা বওয়া লাগতো নায়। ");
INSERT INTO syl_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","আর তুমি অতা মানষরে জানাই দেও, তারা পাক-পবিত্র অইয়া কাইলকুর লাগি জুইত রইতা, কাইলউ তারা খানির গোস্ত পাইবা। তারা তো গোস্তর লাগি মাবুদর দরবারো কান্দা-কাটি করিয়া কইছিল, মিসরো থাকতেউ তারা আরামে আছিল। তে কাইল মাবুদে তারারে গোস্ত দিবা আর তারা খাইবা। ");
INSERT INTO syl_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","ই গোস্ত খালি একদিন-দুইদিন, পাচদিন-দশদিন, বা বিশদিন নায়, ");
INSERT INTO syl_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","পুরা এক মাস ভরি খাইবা। খাইতে খাইতে তারার নাকেদি বার অইবো, বাদে আর জানে কুলাইতো নায়। আমি ইলা ঘটাইমু, কারন তুমরার লগে যে মাবুদ বসত করইন, অউ মাবুদরে তুমরা মানছো না। তান ছামনে কান্দা-কাটি করিয়া কইছো, মিসর থাকি হরিয়া আওয়া বুলে তুমরার লাগি ঠিক অইছে না।” ");
INSERT INTO syl_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","ইখান হুনিয়া মুছায় কইলা, “খালি যুদ্ধ করার জুকাউ তো ছয় লাখ মানুষ আমার লগে আছইন, আর তুমি কইরায় পুরা এক মাস ভরি তারারে গোস্ত খাবাইবায়। ");
INSERT INTO syl_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","তে হক্কল গরু-মেড়া জবো করলেও তো অতো মানষর ফুইতো নায়, আর দরিয়ার হকল মাছ মারিয়া আনিল্লেও কুলাইতো নায়।” ");
INSERT INTO syl_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","মাবুদে জুয়াপ দিলা, “ও মুছা, মাবুদর কুদরতি বল অতো কমজুর নি? তে তুমি দেখবায়, আমি তুমারে যেতা কইছি, ইতা হাছা, না মিছা।” ");
INSERT INTO syl_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","তেউ মুছা বারে গেলা, গিয়া অতা মানষরে মাবুদর হুকুম জানাইলা। আর বনি ইছরাইলর সত্তইর জন মুরব্বি নেতারে আনিয়া মিলন-তাম্বুর চাইরোবায় খাড়া করাইলা। ");
INSERT INTO syl_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","অউ সময় গাইবি মেঘর চাখাত অইয়া মাবুদ লামিয়া আইলা, আইয়া মুছা নবীর লগে বাতচিত করলা। মুছার উপরে আল্লাই যে রুহ আছলা, মাবুদে অউ সত্তইর জন নেতার উপরেও অউ রুহর কিছু অংশ দিলা। অউ রুহ তারারে দান করার বাদে, তারা কিছু সময় ছুফি-দরবেশর এশকি ভাব দেখাইলা, অইলে বাদে আর ইলা অইছে না। ");
INSERT INTO syl_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","আর অউ সত্তইর জন মুরব্বি নেতার মাজর দুইজন মুরব্বি কেম্পর ভিতরে রইগেলা, এরার নাম ইলদাদ আর মিদাদ, তারা মিলন-তাম্বুর গেছে গেছলা না। তেবউ আল্লাই অউ রুহ তারাও পাইলা, পাইয়া তারা কেম্পর ভিতরে রইয়া ছুফি-দরবেশর এশকি ভাব দেখাইলা। ");
INSERT INTO syl_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","ইতা দেখিয়া এক জুয়ান বেটায় দৌড়াইয়া গিয়া মুছারে কইলা, “হুজুর, হুনছইন নি? ইলদাদ আর মিদাদ নামর দুইও মুরব্বিয়ে কেম্পর ভিতরে ছুফি-দরবেশর এশকি ভাব দেখাইরা।” ");
INSERT INTO syl_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","অউ সময় নূনর পুয়া ইউছায় মুছারে কইলা, “ও আমার মালিক, আপনে এরারে নিষেধ দেউক্কা।” অউ ইউছা জুয়ানকির শুরু থাকিউ মুছা নবীর খাছ খাদিম আছলা। ");
INSERT INTO syl_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","মুছায় এনরে কইলা, “আমার মান-সম্মানউ তুমার গেছে বড় অইগেল নি? আমি চাইরাম, মাবুদর হকল বন্দায়উ ছুফি-দরবেশি পাউক্কা, আর মাবুদে আপন রুহ তারারে দান করউক্কা।” ");
INSERT INTO syl_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","এরবাদে মুছা আর বনি ইছরাইলর মুরব্বি নেতা অকল কেম্পো ফিরিয়া গেলাগি। ");
INSERT INTO syl_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","বাদে মাবুদর হুকুমে বড় এক তুফান আইলো। অউ তুফানে দরিয়ার পার থাকি কুয়েল পাখি ঠেলিয়া আনিয়া কেম্পর চাইরো গালা ভরাই দিলো। একদিনর পথ পরিমান জাগা পাখিয়ে ভরিগেল। পাখির পাল মাটি থাকি দুই আত উচা তুব অইয়া, গিছ লাগিয়া পড়ি রইলো। ");
INSERT INTO syl_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","তেউ হউ দিন, হউ রাইত, আর বাদর আস্তা দিন মানষে বারে গিয়া কুয়েল পাখিন তুবাইয়া আনলা। তারা পরতেকে কমপক্ষে পইঞ্চাশ মন করি পাখি দলা করলো। পাখিন দলা করিয়া কেম্পর চাইরোবায় তারা বওয়াইয়া থইলা। ");
INSERT INTO syl_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","অইলে পাখির গোস্ত তারার মুখো হারানির লগে লগেউ মাবুদ গুছায় আগুইন অইগেলা। গুছা করিয়া তাইন বেজুইতা গজবি বেমার ঢালিলা। ");
INSERT INTO syl_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","এরলাগি ই জাগার নাম দেওয়া অইলো কিবরুত-হুতাবা, মানি লালচি অকলর কয়বর, কারন অউ লালচি অকলরে মানষে অনো কয়বর দিছিল। ");
INSERT INTO syl_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","এরবাদে তারা কিবরুত-হুতাবা ছাড়িয়া গেলাগি, গিয়া হাজিরুত নামর জাগাত রইলা। ");
INSERT INTO syl_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","হজরত মুছায় ইথিওপিয়া দেশর একজন বেটিরে বিয়া করছলা। এনরে বিয়া করায় মুছার বইন মরিয়ম আর ভাই হারুনে মুছার বিরুদ্ধে মাত-কথা মাতিলা। ");
INSERT INTO syl_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","তারা কইলা, “মাবুদে খালি মুছার মারফতে মাতইন নি? আমরার উছিলায়ও মাতইন না নি?” ইখান মাবুদে হুনলা। ");
INSERT INTO syl_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","আসলে মুছা নবী তো আছলা একজন গরিমা ছাড়া মানুষ। জগতর মাজে ইলা গরিমা ছাড়া আর কুনু মানুষ আছিল না। ");
INSERT INTO syl_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","মুছার বিরুদ্ধে হারুন আর মরিয়মর মাত-কথা হুনিয়াউ মাবুদে মুছা, হারুন আর মরিয়মরে কইলা, “তুমরা তিনোজন বার অইয়া মিলন-তাম্বুর গেছে আও।” তেউ এরা তিনোজন অনো আইলা। ");
INSERT INTO syl_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","অউ সময় মাবুদেও কুদরতি মেঘর চাখাত অইয়া লামিয়া আইলা, আইয়া মিলন-তাম্বুর দুয়ারর গেছ থাকি হারুন আর মরিয়মরে ডাকিলা। তারা আগুয়াইয়া আইলে ");
INSERT INTO syl_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","মাবুদে কইলা, “তুমরা আমার কথা হুনো। তুমরার মাজে কুনু পীর-দরবেশ থাকলে, আমি মাবুদে দরশনর মাজদি আমার নিজরে তার গেছে জাইর করি আর খোয়াবে তার লগে বাতচিত করি। ");
INSERT INTO syl_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","অইলে আমার গুলাম মুছার লগে ইলা করি না। হে আমার আস্তা সংসারর হকল থাকি বিশ্বাসি জন। ");
INSERT INTO syl_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","আমি তার লগে ছামনা-ছামনি অইয়া খুলা-খুলি বাতচিত করি, কুনুতা বাতুনি রাখি না। আমি মাবুদে যে ছুরতে তারে দিদার দেই, হে আমারে অলা দেখে। এরবাদেও তুমরা আমার গুলাম মুছার বিরুদ্ধে মাতিতে ডরাইলায় না নি?” ");
INSERT INTO syl_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","এরলাগি হারুন আর মরিয়মর উপরে মাবুদ গুছায় আগুইন অইগেলা, অইয়া তাইন হরিয়া গেলাগি। ");
INSERT INTO syl_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","মেঘর চাখা যেবলা মিলন-তাম্বু থাকি উপরে উঠিগেল, অউ সময় দেখা গেল, মরিয়মর আস্তা গতরো পচা-কুষ্ঠ বেমারে দুধর লাখান ধলা অইগেছে। হারুনে মরিয়মর বায় চাইয়া অউ হালত দেখলা। ");
INSERT INTO syl_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","দেখিয়া তাইন মুছারে কইলা, “ও আমার মালিক, আমরা না বুজিয়া যে গুনা করিলিছি, ই কছুরি খান তুমি মনো রাখিও না। ");
INSERT INTO syl_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","মাʼর পেটো থাকি জনম অওয়ার বালা যে হুরুতার অর্ধেক শরিল ক্ষয় অইগেছে, তুমি মরিয়মরে ইলা বানাইও না।” ");
INSERT INTO syl_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","তেউ মুছায় কান্দিয়া মাবুদর দরবারো আরজ করলা, “ও আল্লা, তুমি আমার বইনর বেমার শিফা করি দেও।” ");
INSERT INTO syl_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","মাবুদে মুছারে কইলা, “তাইর বাফে যুদি তাইর মুখো খালি ছেফ ফালাইতা, তে শরমাইয়া তাই সাত দিন ঘরর বারে রইলো অনে না নি? অলা সাতদিন তাইরে কেম্পর বারে আলগ রাখো, বাদে ভিতরে আনবায় নে।” ");
INSERT INTO syl_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","এরলাগি মরিয়মরে সাত দিন কেম্পর বারে হরাই থইলা। এনরে ভিতরে আনার আগ পর্যন্ত মানষর ছফরো বারনি বন্দ রইলো। ");
INSERT INTO syl_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","বাদে বনি ইছরাইল অকল হাজিরুত ছাড়িয়া ফারান মরুভুমিত গিয়া কেম্প গাড়িলা। ");
INSERT INTO syl_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","এরবাদে মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“বনি ইছরাইলরে আমি যে কেনান দেশ দিতাম চাইরাম, অউ দেশর হাল-হকিকত দেখিয়া আওয়ার লাগি তুমি বারো খান্দান থাকি বারো জন সর্দার পাঠাও।” ");
INSERT INTO syl_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","মাবুদর হুকুম পাইয়া মুছায় অলাউ করলা। তাইন ফারান মরুভুমি থাকি যেরারে পাঠাইলা, এরা হকলউ বনি ইছরাইলর সর্দার। ");
INSERT INTO syl_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","এরা অইলা: রুবেন খান্দানর জাকুরর পুয়া শাম্মুয়া, ");
INSERT INTO syl_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","শিমিয়ন খান্দানর খোরির পুয়া শফাত, ");
INSERT INTO syl_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","এহুদা খান্দানর যিফুন্নির পুয়া কালুত, ");
INSERT INTO syl_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ইছাখর খান্দানর ইউছুফর পুয়া যিগাল, ");
INSERT INTO syl_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","আফরাইম খান্দানর নূনর পুয়া হোছিয়া, ");
INSERT INTO syl_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","বিন-ইয়ামিন খান্দানর রফুর পুয়া ফলতি, ");
INSERT INTO syl_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","সবুলন খান্দানর ছইদর পুয়া গদ্দিয়েল, ");
INSERT INTO syl_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","ইউছুফর পুয়া মানশা খান্দানর ছুশির পুয়া গাদ্দি, ");
INSERT INTO syl_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","দান খান্দানর গমল্লির পুয়া আম্মিয়েল, ");
INSERT INTO syl_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","আশির খান্দানর মিকাইলর পুয়া ছতুর, ");
INSERT INTO syl_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","নপ্তালি খান্দানর বশিরর পুয়া নইব, ");
INSERT INTO syl_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","আর ছাদু খান্দানর মাখির পুয়া গুজয়েল। ");
INSERT INTO syl_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","কেনান দেশর হাল-হকিকত জানিয়া আইবার লাগি গুইয়া হিসাবে মুছা নবীয়ে এরারে পাঠাইলা। তাইন নূনর পুয়া হোছিয়ারে ইউছা কইয়া ডাকিতা। ");
INSERT INTO syl_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","কেনান দেশো পাঠানির বালা মুছায় তারারে কইলা, “তুমরা নেগেভ মরুভুমির মাজেদি গিয়া পাহাড়িয়া এলাকাত হামাইবায়। ");
INSERT INTO syl_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","হামাইয়া দেখবায়, অউ দেশখান কিলা। ই দেশর বাসিন্দা মানুষ কম না বেশি, তারা কমজুর না বলবান। ");
INSERT INTO syl_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","তারার দেশখান ভালা না মন্দ? দেশর টাউন অকল উচা বাউন্ডরি ওয়াল করা, না বাউন্ডরি ছাড়া? ");
INSERT INTO syl_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","হিনর মাটিত রস আছে কি না, গাছ-পালা আছে কি না? আর আওয়ার সময় দেখিও, পারলে হউ দেশর কুনু ফল-মুল লইয়া আইও।” অউ সময় তো আংগুর পাকার সময় আইছে। ");
INSERT INTO syl_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","তেউ তারা জীন মরুভুমি থাকি শুরু করিয়া হামাতর বায় রাহোব পর্যন্ত গিয়া আস্তা দেশর হাল-হকিকত দেখিয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","যাওয়ার কালো তারা নেগেভ মরুভুমি অইয়া হেবরন টাউনো গিয়া আজিলা। ই হেবরন টাউন বানাইল অইছিল মিসর দেশর সোয়ান টাউন বানানির সাত বছর আগে। হিনো পয়লোয়ান আনাকী খান্দানর তিনজন মানুষ আছিল, এরার নাম অইলো আহিমান, সিছাই, আর তালমাই। ");
INSERT INTO syl_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","বাদে অউ গুইয়া অকল আশকুল নামর পাহাড়িয়া খালর পারো থাকি এক ছড়ি আংগুর সুদ্ধা আস্তা এক লত কাটিয়া লইয়া আইলা। ই আংগুরর ছড়ি তারার দুইজনে ভাং দিয়া বইয়া আনলা। লগে কিছু আনুয়ার আর ডুমুর ফলও আনলা। ");
INSERT INTO syl_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","বনি ইছরাইলর সর্দার অকলে হন থাকি অউ আংগুরর ছড়ি কাটায় অউ জাগার নাম অইগেল, আশকুলর খাল, মানি ছড়ির খাল। ");
INSERT INTO syl_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","আস্তা কেনান দেশর হাল-হকিকত দেখিয়া হারি, চাল্লিশ দিন বাদে তারা হকল ফিরিয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","অউ গুইয়া অকল ফারান মরুভুমির কাদেশ নামর জাগাত ফিরিয়া আইলা, অনো মুছা নবী, ইমাম হারুন আর বনি ইছরাইল অকল আছলা। এরা আইয়া হকলরে হনর খবর-আন্তর জানাইলা আর হউ দেশর ফল-মুল দেখাইলা। ");
INSERT INTO syl_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","তারা মুছারে কইলা, “আপনে আমরারে যে দেশো পাঠাইছলা, আমরা হনো গিয়া দেখলাম, হি দেশখান হাছাউ দুধ আর মউর ভান্ডার আলা দেশ। অউ দেখউক্কা, হউ দেশর ফল। ");
INSERT INTO syl_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","অইলে হিনর মানুষ খুব পয়লোয়ান আর তারার টাউনও বড় বড় আর উচা বাউন্ডরি করা। আমরা আনাকী পয়লোয়ান খান্দানর মানষরেও হনো দেখছি। ");
INSERT INTO syl_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","আমালেকী অকল বসত করইন নেগেভ মরুভুমিত। হিট্টী, যিবুজী আর আমোরী অকল পাহাড়ি এলাকাত রইন। আর কেনানী অকলর কেউ কেউ দরিয়ার কান্দাত আর কেউ কেউ জর্দান গাংগর পারো রইন।” ");
INSERT INTO syl_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","অউ সময় মুছার ছামনে যেতা মানুষ দলা আছলা, কালুতে এরার শুরগুল থামাইয়া কইলা, “আমরার লাগি জরুর অইলো হনো গিয়া অউ দেশ দখল করা, আর ইতা আমরা পারমুও।” ");
INSERT INTO syl_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","ইখান হুনিয়া তান লগর গুইয়া অকলে কইলা, “না, না, ইতা মানষর লগে লাড়াই করা আমরার লাগি অসম্ভব, ইতা আমরা থাকি বউত বলআলা।” ");
INSERT INTO syl_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","এরা হউ দেশর বেয়াপারে মনগড়া মিছা মাতিয়া কইলা, “আমরা যে দেশ দেখাত গেছলাম, ই দেশে তার প্রজা অকলরে গিলিয়া খাইলায়। হিনর মানুষ খুব উচা-মোটা পয়লোয়ান। ");
INSERT INTO syl_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","আমরা হিনো নেফিলী জাতর মানষরেও দেখছি, ইতা দেখতে দৈত্য-দানবর লাখান। আমরা তো তারার গেছে তুচ্ছ পিপড়ার লাখান, তারাও আমরারে অলা পিপড়া মনো করছে।” জানো তো, অখনকুর আনাকী জাতি অউ নেফিলী অকলর বংশধর। ");
INSERT INTO syl_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","ইখান হুনিয়া হকল বনি ইছরাইলে চিল্লা-চিল্লি লাগাইলো। তারা হারা রাইত কান্দা-কাটি করলো। ");
INSERT INTO syl_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","হজরত মুছা আর হারুনর বিরুদ্ধে বউত কথাবার্তা মাতিলো। তারা হকলে মিলিয়া মুছা আর হারুনরে কইলো, “হায়রে হায়! আমরা কেনে হউ মিসর দেশো বা মরুভুমিত মরলাম না? হনো মরাউ তো ভালা আছিল। ");
INSERT INTO syl_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","মাবুদে কেনে আমরারে যুদ্ধর ময়দানো মারার নিয়তে অউ দেশো নিরা? হনর দুশমন অকলে আমরার বউ-বাইচ্চাইনরে কাড়িয়া নিবা। এর থাকি মিসরো ফিরিয়া যাওয়াউ আমরার লাগি ভালা নায় নি?” ");
INSERT INTO syl_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","তারা একে-অইন্যে কইলো, “আও, আমরা একজন নেতা বানাইয়া হিরবার মিসরো ফিরিয়া যাইগি।” ");
INSERT INTO syl_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","ই হালত দেখিয়া মুছা আর হারুন আস্তা বনি ইছরাইল সমাজর ছামনে মাটিত সইজদাত পড়লা। ");
INSERT INTO syl_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","আর যে গুইয়া দলে অউ দেশর হাল-হকিকত দেখিয়া আইছলা, তারার মাজ থাকি নূনর পুয়া ইউছা আর যিফুন্নির পুয়া কালুতে মনর দুখে নিজর গতরর কাপড়-চুপড় ছিড়িল্লা, ");
INSERT INTO syl_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ছিড়িয়া বনি ইছরাইল সমাজর হক্কলরে কইলা, “হুনো, আমরা যে দেশ দেখাত গেছলাম, ই দেশখান খুব সুন্দর। ");
INSERT INTO syl_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","মাবুদ যুদি আমরার উপরে খুশ আর রাজি থাকইন, তে আমরারে হউ দেশো নিয়া পার করবা, তাইন দুধ আর মউর ভান্ডার আলা অউ দেশখান আমরারে দান করবা। ");
INSERT INTO syl_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","হুনো, তুমরা মাবুদর মর্জির উল্টা কাম করিও না। তুমরা হি দেশর মানষরে ডরাইও না, তারারে গিলিয়া খাইতেও আমরার দেরি অইতো নায়। তুমরা ইতারে ডরাইও না, তারার মাথার উপরর ছায়া নাই, আমরার লগে তো মাবুদ আছইন।” ");
INSERT INTO syl_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","অইলে তারা হকলেউ কইলা ইউছা আর কালুতরে পাথর মারিয়া মারিলতা। অউ সময় মিলন-তাম্বু থাকি আস্তা বনি ইছরাইল সমাজর ছামনে মাবুদর কুদরতি নুর জাইর অইলো। ");
INSERT INTO syl_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","মাবুদে কইলা, “ও মুছা, ইতায় আমারে আর কতদিন এলামি করবো? তারার ছামনে অতো কেরামতি নিশানা দেখানির বাদেও, তারা আর কতদিন আমারে একিন করতো নায়? ");
INSERT INTO syl_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","তে হুনো, আমি তারার উপরে বড় এক গজব ঢালিমু, আমার ওয়াদা করা হউ দেশর মালিকানা কাড়িয়া নিমুগি। বাদে আমি তুমার মাজ থাকি ইতা থনে আরো বলবান, আরো বড় নয়া এক জাতি পয়দা করমু।” ");
INSERT INTO syl_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","ইখান হুনিয়া মুছায় কইলা, “ও মাবুদ, তুমি যুদি ইলা করো, তে মিসরী অকলে ইতা হুনবা। আর তুমি তো মিসর থাকি ইতা মানষরে তুমার নিজর কুদরতিয়ে বার করি আনছো। ");
INSERT INTO syl_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","অখন মিসরী অকলে ই দেশর মানষরেও ইতা জানাই দিবা। তে ও মাবুদ, ইনর মানষে তো এমনেউ জানিলিছইন যেন, বনি ইছরাইলর লগে লগে তুমি আছো, তুমারে খুব ধারো থাকি দেখা যায়। তারা হুনছইন, তুমার নুরর মেঘর ছায়া এরার উপরে আছে, তুমি দিনর বালা মেঘর খুটি আর রাইত অইলে আগুইনর খুটির ছুরতে এরার আগে আগে রও। ");
INSERT INTO syl_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","অখন তুমি যুদি এরা হকলরে একলগে মারিলাও, তে যত জাতির মানষে তুমার ইতা কুদরতি কামর খবর হুনছে, তারা কইবা, ");
INSERT INTO syl_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","মাবুদে বনি ইছরাইলরে যে দেশ দিবার ওয়াদা করছলা, হি দেশো লইয়া যাওয়ার খেমতা তান নাই, এরলাগি তাইন এরারে মরুভুমিত নিয়া মারিলিছইন। ");
INSERT INTO syl_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“তে, ও দীন-দুনিয়ার মালিক, তুমি আগে যেলা কইছলায় অলা কুদরতি কাম জাইর করো। তুমি নু কইছলায়, ");
INSERT INTO syl_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","মাবুদে গুছা করইন ধীর গতিয়ে, তান মায়া-মহব্বতর কুনু সীমা নাই, তাইন মানষর অইন্যায় আর নাফরমানির মাফি দেইন। অইলে দুষি জনরে সাজাও দেইন, বাফ-দাদার নাফরমানির সাজা তার নাতি-পুতি পর্যন্ত বর্তাইন। ");
INSERT INTO syl_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","তে তুমার দোহাই দিয়া কইরাম, মিসর দেশ ছাড়িয়া আওয়া থাকি অখন পর্যন্ত তুমি এরারে যেলা মাফি দিরায়, তুমার হউ মায়ার খাতিরে তারার অখনকুর গুনারেও অলা মাফ করি দিলাও।” ");
INSERT INTO syl_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","তেউ মাবুদে কইলা, “আইচ্ছা, তুমার কথায় আমি ইতারে মাফ করি দিলাম। ");
INSERT INTO syl_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","অইলে আমি জিন্দা আছি ইখান যেলা হাছা, আস্তা জগতো আমার লিলা-খেলায় ভরা ইটাও যেলা হাছা, অউ লাখান আরক হাছা অইলো, ");
INSERT INTO syl_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","23","ইতা একজনেও আমার ওয়াদা করা হি দেশ দেখার সুযোগ অইতো নায়, যে দেশ দিতাম করি আমি তারার বাফ-দাদার গেছে ওয়াদা করছলাম। কারন ইতায় আমার নুরর তজল্লি দেখছইন, তারা মিসরো থাকতে আর অউ মরুভুমিত আইয়াও আমার কুদরতি লিলা-খেলা দেখার বাদেও ইতায় আমারে মানছইন না, বরং দশ-দশবার তারা আমারে পরিক্ষা করছইন। তে তারা যতজনে আমারে এলামি করছে, ইতা একজনেও হি দেশ দেখার কপাল অইতো নায়। ");
INSERT INTO syl_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","অইলে আমার বন্দা কালুতর দিলর ভাব ইলা নায়, হে আমার হুকুম পুরাপুর মানে। এরলাগি যে দেশ দেখাত হে গেছিল, আমি তারে হউ দেশো নিমু, তার আওলাদ অকল হি দেশর মালিক অইবা। ");
INSERT INTO syl_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","হুনো, হউ দেশর পাহাড়িয়া তল জাগাইন্তো অখন আমালেকী আর কেনানী অকলে বসত কররা। তে ছামনর কাইল তুমরা পিছেদি গিয়া আকাবা সাগরর পারেদি মরুভুমির বায় রওয়ানা অইও।” ");
INSERT INTO syl_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","বাদে মাবুদে মুছা আর হারুনরে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“অউ নাফরমান জাতিয়ে আমার বিরুদ্ধে আর কতদিন বের-বেরি করতো? তারা আমার বিরুদ্ধে যেতা মাত মাতের, ইতা তো আমি হুনছি। ");
INSERT INTO syl_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","অখন তুমরা গিয়া বনি ইছরাইলরে কও, আমি মাবুদে নিজর জিন্দেগির কছম খাইয়া কইরাম, আমি তুমরার মুখর যেতা মাত-কথা হুনছি, আমিও তুমরার লগে ঠিক অলাউ করমু। ");
INSERT INTO syl_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","মানুষ গনিবার সময় তুমরার বিশ বছর বা তার বেশি বয়সর যেতারে গনা অইছিল, মানি যেতায় আমার বিরুদ্ধে বের-বেরি করছে, ইতার লাশ অউ মরুভুমির মাজে পড়ি রইবো। ");
INSERT INTO syl_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","আমি তুমরারে যে দেশ দিতাম করি ওয়াদা করছলাম, খালি যিফুন্নির পুয়া কালুত আর নূনর পুয়া ইউছা ছাড়া আর কেউ গিয়া হি দেশো হামানির কপাল অইতো নায়। ");
INSERT INTO syl_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","আর তুমরার যেতা হুরুতারে কাড়িয়া নেওয়া অইবো কইছলায়, আমি অউ হুরুতাইনরেউ হউ দেশো পার করমু, তারাউ অইবা হি দেশর মালিক, যে দেশরে তুমরা এলামি করছো। ");
INSERT INTO syl_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","অইলে তুমরার লাশ অউ মরুভুমিত পড়ি রইবো। ");
INSERT INTO syl_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","অউ মরুভুমির পেটো তুমরার এক্কেরে আখেরি জন না মরা পর্যন্ত, তুমরার বেইমানির লাগি তুমরার আওলাদ অকলে চাল্লিশ বছর অনো গরু-ছাগলর রাখালি করবা। ");
INSERT INTO syl_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","কেনান দেশর হাল-হকিকত দেখিয়া আইতে যে চাল্লিশ দিন লাগছিল, এর এক দিনর বদলা এক বছর, অউলা মোট চাল্লিশ বছর তুমরার নাফরমানির লাগি কষ্ট করবায়। তেউ বুজবায়, আমি যেবলা কেউরর বিরুধিতা করি এর দশা কিলা অয়। ");
INSERT INTO syl_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","তে আমি মাবুদে কইরাম, অউ নাফরমান জাতির যেতা মানষে আমার বিরুদ্ধে দল বান্দিছে, ইতা হক্কলটি অউ মরুভুমিত মরবা।” ");
INSERT INTO syl_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","কেনান দেশর হাল-হকিকত জানার লাগি মুছায় যে গুইয়া দলরে পাঠাইছলা, এরার মাজর যেগুইন ফিরিয়া আইয়া বেইমানি খবর রটাইয়া, হকল বনি ইছরাইলরে দিয়া মুছার বিরুদ্ধে বকা-জকা করাইছিল, ");
INSERT INTO syl_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","মানি যেরা হউ দেশর বেয়াপারে আজে-বাজে মাত রটাইছিল, তারা হক্কলউ মহা গজবি বেমারে মাবুদর ছামনে মরিগেলা। ");
INSERT INTO syl_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","অউ গুইয়া দলর মাজ থাকি খালি নূনর পুয়া ইউছা আর যিফুন্নির পুয়া কালুত বাচিয়া রইলা। ");
INSERT INTO syl_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","হজরত মুছায় মাবুদর কথা হকল বনি ইছরাইলরে জানাইলা। ইতা হুনিয়া তারা মনর দুখে কাতর অইগেলা। ");
INSERT INTO syl_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","বাদর দিন বিয়ানে তারা হউ পাহাড়ি এলাকাত যাওয়ার লাগি তিয়ার অইয়া কইলো, “অউ দেখো, আমরা যাইরামগি। আমরা তো গুনা করিয়া হারছি, তে অখন আমরা মাবুদর ওয়াদা করা দেশোউ যাইতামগি।” ");
INSERT INTO syl_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","অইলে মুছায় কইলা, “তুমরা মাবুদর হুকুমর উল্টা যাইরায় কেনে? তুমরার নিয়ত পুরা অইতো নায়। ");
INSERT INTO syl_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","হুনো, তুমরা যাইও না, কারন মাবুদ তুমরার লগে নায়। দুশমন অকলর গেছে তুমরা আরিবায়। ");
INSERT INTO syl_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","হিনো গিয়া তুমরা আমালেকী আর কেনানী অকলর মুখামুখি অইবায়। আর মাবুদর লগ ছাড়িয়া গেছোগি করি, তাইন তুমরার লগে রইতা নায়। এরলাগি তুমরা যুদ্ধর মুখো মরবায়।” ");
INSERT INTO syl_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","তেবউ তারা তান কথা উল্টাইয়া হউ পাহাড়ি এলাকা বায় রওয়ানা দিলো। অইলে মুছা তারার লগে গেলা না আর মাবুদর পবিত্র শাহাদত সন্দুকও কেম্পর ভিতরে রইগেল। ");
INSERT INTO syl_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","তারারে দেখিয়াউ হউ পাহাড়িয়া এলাকার আমালেকী আর কেনানী অকল লামিয়া আইয়া হামলা চালাইলো, আর হনর হর্মা টাউন পর্যন্ত খেদাইয়া নিলো। ");
INSERT INTO syl_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“তুমি বনি ইছরাইলরে জানাই দেও, আমি যে দেশখানরে তুমরার নিজর দেশ হিসাবে দান কররাম, তুমরা যেবলা হউ কেনান দেশো যাইবায়, ");
INSERT INTO syl_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","গিয়া আমারে খুশ রাখার নিয়তে আগুনিত দেওয়া ঘেরান আলা যেকুনু কুরবানি হিসাবে তুমরার পাল থাকি যেবলা গাই-গরু বা মেড়া-ছাগল আনিয়া আমার নামে দিবার নিয়ত করবায়, আর জালাইল কুরবানি, কুনু মান্নত পুরনর কুরবানি, হকল নমুনার নফল কুরবানি, বা যেকুনু ইদর কুরবানি দিলে, ");
INSERT INTO syl_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","কুরবানির পরতেক পশুর লগে ধান-গমর ছদগাও দিবায়। অউ ছদগার লাগি দুই সের ময়দারে এক সের তেলদি মাখাইয়া খাই বানাইয়া আনবায়। ");
INSERT INTO syl_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","অইলে কুরবানির পশুটা যুদি মেড়া-বাইচ্চা অয়, তে ইটার লগে শরবত-পানির ছদগা হিসাবে আংগুরর এক সের শরবতও দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","আর অউ পশু যুদি মেড়া অয়, তে তার লগে ধান-গমর ছদগা হিসাবে সোয়া সের তেলদি মাখাইয়া চাইর সের ময়দা দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","শরবত-পানির ছদগার লাগি লাগবো আংগুরর সোয়া সের শরবত। ইতা আনিয়া আমারে খুশ করার ঘেরান আলা কুরবানি হিসাবে দিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","তুমরা যুদি জালাইল কুরবানি, মান্নত পুরনর কুরবানি বা ছালামতি কুরবানির লাগি কুনু গরু লইয়া আও, ");
INSERT INTO syl_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","তে এরলগে ধান-গমর ছদগা হিসাবে ছয় সের ময়দারে দুই সের তেলদি মাখাইয়া খাই আনতে অইবো। ");
INSERT INTO syl_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","আর শরবত-পানির ছদগার লাগি আংগুরর দুই সের শরবতও আনতে অইবো। “ইতা অইলো আগুনিত দেওয়া কুরবানি, ই কুরবানির ধুমার ঘেরানে আমি খুশি অই। ");
INSERT INTO syl_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","কুরবানির পরতেক গরু, মেড়া, মেড়া-বাইচ্চা বা ছাগলরে অউ নিয়মে কুরবানি দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","তুমরা যত পরিমান পশুউ কুরবানি দেও না কেনে, পরতেক পশুর লগে অউ নিয়মে ছদগাও দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“হুনো, আমি মাবুদরে খুশ করার নিয়তে, যেকুনু ঘেরান আলা আগুনিত দেওয়া কুরবানি আদায় করার সময়, পরতেক বনি ইছরাইলে অউ নিয়মে কুরবানি দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","অইন্য জাতির কুনু মুছাফির বা তুমরার লগে বসত কররা কুনু ভিন-দেশিয়ে যুদি, আমারে খুশ করার নিয়তে আগুনিত দেওয়া ঘেরান আলা কুরবানি দিতো চায়, তে হে-ও তুমরার লাখান একই নিয়ম মানতে অইবো। ");
INSERT INTO syl_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","ওয়ারিশর পর ওয়ারিশ ধরি অউ নিয়ম জারি রইবো। তুমরার সমাজর হকলর লাগি অউ নিয়ম চালু রইবো, ইতা তুমরা অও বা তুমরার লগে বসত কররা ভিন-দেশি অইলেও, হকলর লাগিউ ওয়ারিশর পর ওয়ারিশ ধরি অউ একই নিয়ম জারি রইবো। ই বেয়াপারে আমি মাবুদর গেছে তুমরা যেলা, ভিন-দেশি অকলও অউলা, হকল হমান। ");
INSERT INTO syl_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","তুমরার লাগি আর তুমরার মাজে বসত কররা ভিন-দেশি অকলর লাগি এক লাখান হুকুম-আহকাম আর একই শরিয়ত চালু রইবো।” ");
INSERT INTO syl_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","এরবাদে মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“তুমি বনি ইছরাইলরে জানাও, আমি মাবুদে তুমরারে যে দেশো নিয়ার, হনো গিয়া হারলে, ");
INSERT INTO syl_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","তুমরা যেবলা হউ দেশর ফয়-ফসল খাইবায়, অউ সময় তুমরা ইতার কিছু অংশ আমার দরবারো ছদগা হিসাবে দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","তুমরার খেতর পয়লা দাওয়া ফসলর ময়দা দিয়া একখান রুটি বানাইয়া আমার নামে ছদগা দিবায়। গিরস্ত-বাড়ির ছদগার লাখান দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","পয়লা দাওয়া ফসলর অউ ছদগা, ওয়ারিশর পর ওয়ারিশ ধরি লিল্লা-ছদগা হিসাবে তুমরা আমার নামে দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ও মুছা, তুমি বনি ইছরাইলরে কও, আমি মাবুদে তুমার মাজদি যত হুকুম-আহকাম দিছি, তারা যুদি না জানিয়া অতা কুনু একটা হুকুম ভাংগিলায়, ");
INSERT INTO syl_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ইতা হকল হুকুম তো দেওয়ার সময় থাকি ওয়ারিশর পর ওয়ারিশ ধরি জারি রয়, ");
INSERT INTO syl_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","তে ই অজানা বেয়াপারটা জানার বাদেউ আস্তা বনি ইছরাইল সমাজে মিলিয়া কুরবানি দিতে অইবো। তারা একটা বিছাল দিয়া আমি মাবুদরে খুশ করার নিয়তে ঘেরান আলা জালাইল কুরবানি দিবো, এরলগে নিয়ম মাফিক ধান-গমর ছদগা আর শরবত-পানির ছদগা দিবো। আর গুনার কফরার লাগি এগু ছাগলও কুরবানি দিবো। ");
INSERT INTO syl_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","ইমাম ছাবে আস্তা বনি ইছরাইল সমাজর অউ অজানা গুনার কফরা আদায় করবা, তেউ তারা মাফি পাইবা। তারা তো ইচ্ছা করিয়া ই নাফরমানি করছে না, তারার ভুলর লাগি মাবুদর নামে আগুনিত দেওয়া কুরবানি আর গুনার কফরার কুরবানিও আদায় করছে। ");
INSERT INTO syl_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","তেউ আস্তা বনি ইছরাইল সমাজ আর তারার মাজে বসত কররা ভিন-দেশি মানষরেও মাফ করা অইবো, যুদিও তারা হকলেউ ই ভুল-কছুরি করছে। ");
INSERT INTO syl_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“অইলে কেউ যুদি খালি একলা ভুল করিয়া মনর অজান্তে কুনু নাফরমানি করিলায়, তে গুনার কফরার কুরবানির লাগি হে এক বছর বয়সি একটা ছাগি লইয়া আজির অইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","আর যে জনে মনর অজান্তে অউ গুনা করছে, ইমাম ছাবে মাবুদর দরবারো তার গুনার কফরার বেবস্থা করবা। অউ কুরবানি কবুল অইলে হে মাফি পাইবো। ");
INSERT INTO syl_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","ভুল করিয়া মনর অজান্তে যে মানষে নাফরমানি করিলায়, অউ লাখান পরতেক মানষর লাগি ই নিয়ম চালু রইবো, হে বনি ইছরাইল অউক, বা ভিন-দেশি অউক, একই নিয়মে চলবো। ");
INSERT INTO syl_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“অইলে বনি ইছরাইল বা তারার মাজে বসত কররা অইন্য কুনু জাতির কেউ যুদি ইচ্ছা করিয়া কুনু নাফরমানি করে, তে হে স্বয়ং মাবুদরে বেইজ্জত করে। ইলা নাফরমানির লাগি সমাজ থাকি অগুর নাম মিটাইলিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","মাবুদর হুকুমরে এলামি করায় আর নাফরমানি করায় অগুর নাম মিটাইলিতে অইবো, তার ই গুনার দায়-ভার তার উপরেউ বর্তাইবো।” ");
INSERT INTO syl_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","বনি ইছরাইল মরুভুমিত ছফরর কালো এক জুম্মাবারে একজন মানষরে দারু তুবানিত দেখলা। ");
INSERT INTO syl_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","জুম্মাবারে দারু তুবানিত দেখায় অউ মানষে তারে ধরিয়া মুছা নবী, ইমাম হারুন আর হকল বনি ইছরাইলর ছামনে লইয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","অউ লাখান মানষরে কিতা করতে অইবো, ই হুকুম তো আল্লায় অখনও জানাইছইন না, এরলাগি এরে তারা বন্দি করি থইলো। ");
INSERT INTO syl_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","অউ সময় মাবুদে মুছারে জানাইলা, “অউ মানষরে জানে মারিলিতে অইবো। তারে কেম্পর বারে নিয়া হকল বনি ইছরাইলে পাথরদি ইটাইয়া মারিলিবায়।” ");
INSERT INTO syl_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","তেউ মুছার মারফতে পাওয়া মাবুদর হুকুম মাফিক, বনি ইছরাইলে তারে কেম্পর বারে নিয়া পাথর মারিয়া মারিল্লা। ");
INSERT INTO syl_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","এরবাদে মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“তুমি বনি ইছরাইলরে কও, তুমরা যারযির লেবাছর পাইড়ো জাজইর লাগাও, আর জাজইরর পরতেক গিটরে লিলুয়া সুতাদি পেচাইয়া মুল কাপড়র লগে জুড়া দিও। ই হুকুম ওয়ারিশর পর ওয়ারিশ ধরি মানবায়। ");
INSERT INTO syl_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","ই জাজইর লাগানির কারন অইলো, অতার বায় চাইলে তুমরা আমার হক্কল হুকুমর কথা ইয়াদ করিয়া অতা আমল করবায়। তেউ তুমরা আমার লগে কুনু বেইমানি করতায় নায়, তুমরার চউখর আর দিলর বদ খাইশর আতো নিজরে সপিতায় নায়। ");
INSERT INTO syl_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","আমার হকল হুকুম-আহকাম আমল করার কথা তুমরার ইয়াদ রইবো, তুমরার আল্লার নামে তুমরা পাক-পরেজগার বন্দার হালতে রইবায়। ");
INSERT INTO syl_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","আমি তুমরার মাবুদ আল্লা। তুমরার মাবুদ অওয়ার খিয়ালে, আমি তুমরারে মিসর থাকি বার করি আনছি। আমিউ আল্লা, তুমরার মাবুদ।” ");
INSERT INTO syl_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","2","লেবি খান্দানর কুরাহে মুছা নবীর বিরুদ্ধে দুশমনি লাগাইলো। অউ কুরাহ অইলো কাহাতী গুষ্টির ইজহারর পুয়া। তার লগে রুবেন খান্দানর ইলিয়াবর পুয়া দাথন আর আবিরাম, আর ফলেতর পুয়া অউনেও মুছা নবীর বিরুধিতা করলো। এরার দলো বনি ইছরাইলর আরো আড়াইশো জন নামকরা মুরব্বি নেতাও শরিক অইলা। ");
INSERT INTO syl_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","অইয়া তারা দল বান্দিয়া মুছা আর হারুনরে কইলা, “তুমরা তো খুব বেশি বাড়াবাড়ি কররায়। আস্তা বনি ইছরাইলর পরতেক মানুষউ যেবলা পাক-পবিত্র, মাবুদও তারার লগে আছইন। তে তুমরা মাবুদর বন্দা অকলর উপরে উস্তাদি কররায় কেনে?” ");
INSERT INTO syl_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","ইখান হুনিয়া মুছা নবী উফইত অইয়া মাটিত পড়লা। ");
INSERT INTO syl_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","বাদে তাইন কুরাহ আর তার দলর মানষরে কইলা, “কাইল বিয়ানেউ মাবুদে দেখাইবা, কে তান বন্দা, আর কে পাক-পবিত্র। তাইন যারে পছন্দ করইন, খালি তারারেউ তান কাছাত আইতে দিবা। ");
INSERT INTO syl_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","7","ও কুরাহ, হুনো, তুমি আর তুমার লগর হকলে এক কাম করো, ছামনর কাইল তুমরা হকলে একটা করি আগর দানি লইয়া মাবুদর ছামনে আগর-খুশবয় জালাও। তাইন যারে পছন্দ করবা, বুজিলিও হে-উ তান পাক-পবিত্র বন্দা। তুমরা লেবি খান্দানর মানুষ তো বেশি বাড়িগেছো।” ");
INSERT INTO syl_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","মুছায় তারে এওখান কইলা, “তুমরা লেবি অকলে আমার একখান কথা হুনো। ");
INSERT INTO syl_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","তুমরা মনো কররায় নি মাবুদর কাবা ঘরো এবাদতি করা আর সমাজর মানষর খেজমত করা ইতা এক্কেরে হুরু-মুরু বেয়াপার? হুনো, বনি ইছরাইলর আল্লায় সমাজর অইন্যান্য মানুষ থাকি তুমরারে বাছিয়া নিয়া, তান নিজর দিদারো আনছইন, যাতে তুমরা অউ কাম করো। ");
INSERT INTO syl_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","তাইন তো তুমারে আর অইন্যান্য লেবি অকলরে নিজর ধারো আইবার সুযোগ দিছইন, অইলে তুমরা দেখিয়ার ইমামতির পদরেও দখল করতায় চাইরায়। ");
INSERT INTO syl_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","হারুন আর কুন মানুষ যেন, তুমরা তার বিরুদ্ধে বকা-জকা কররায়? তুমি আর তুমার দলর মানষে তো মাবুদর বিরুদ্ধেউ দল বান্দিছো।” ");
INSERT INTO syl_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","এরার বাদে মুছায় খবর দিলা, ইলিয়াবর দুই পুয়া দাথন আর আবিরাম আইতা করি, অইলে তারা জানাইলো, “আমরা অতো ঠেকাত নায়। ");
INSERT INTO syl_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","তুমি অউ মরুভুমিত আনিয়া মারতায় করি, দুধ আর মউর ভান্ডার আলা হউ মিসর দেশ থাকি আমরারে বার করি আনছো, হি দেশো তো কুন্তারউ অভাব আছিল না। এর বাদেও আমরার উপরে বেটাগিরি দেখানিত লাগছো। ");
INSERT INTO syl_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","আর তুমি তো আমরারে হউ লাখান কুনু দুধ আর মউর ভান্ডার আলা দেশোও নিছো না, কুনু জমি-জমা বা আংগুর বাগানর মালিকানাও দিছো না। তুমি ইতা মানষরে আন্দা বানাইয়া রাখতায় চাও নি? না, আমরা যাইতাম নায়।” ");
INSERT INTO syl_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","ইতা হুনিয়া মুছা খুব গরম অইয়া মাবুদরে কইলা, “মাবুদ, তুমি এরার কুরবানি কবুল করিও না। আমি তো তারার কুনু খেতি করছি না, তারার এগু গাধাও আমি নিছি না।” ");
INSERT INTO syl_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","বাদে মুছায় কুরাহরে কইলা, “কাইল তুমি আর তুমার দলর হকল আইয়া মাবুদর ছামনে আজির অইবায়। তুমরার লগে হারুনও আজির অইবা। ");
INSERT INTO syl_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","পরতেকে আইয়া যারযির আগর দানিত আগর-খুশবয় ভরিয়া মাবুদর নামে জালাইবায়। তুমরার আড়াইশো জনর হক্কলে অলা যারযির আগর দানি জালাইও। এরলগে তুমি আর হারুনেও আগর-খুশবয় জালাইও।” ");
INSERT INTO syl_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","মুছার হুকুম মাফিক পরতেকে যারযির আগর দানিত আগর-খুশবয় আর আগুইন লইয়া, মিলন-তাম্বুর দুয়ারর ছামনে, মুছা আর হারুনর লগে গিয়া উবাইলা। ");
INSERT INTO syl_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","কুরাহে যেবলা সমাজর হকল মানষরে উস্কাইয়া দলা করলো, করিয়া মিলন-তাম্বুর দুয়ারর গেছে মুছা আর হারুনর বিরুদ্ধে উবাইলো, অউ সময় তারা হক্কলর ছামনে মাবুদর কুদরতি নুর জাইর অইলো। ");
INSERT INTO syl_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","মাবুদে মুছা আর হারুনরে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“ইতা মানষর গেছ থাকি তুমরা হরি যাও, আমি ইতারে চখুর পলকর লগে শেষ করিলিয়ার।” ");
INSERT INTO syl_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","অইলে মুছা আর হারুন সইজদাত পড়িয়া কইলা, “ও আল্লা, তুমি তো হকল মানষর ভিতরে জান দেও। অখন খালি একজনর নাফরমানির দায় আস্তা বনি ইছরাইলর উপরে তুমি গজব ঢালিতায় নি?” ");
INSERT INTO syl_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","তেউ মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“তুমি বনি ইছরাইলরে জানাই দেও, তারা যানু কুরাহ, দাথন আর আবিরামর তাম্বুর গেছ থাকি হরি যাইন।” ");
INSERT INTO syl_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","ইখান হুনিয়া মুছা সইজদা থাকি উঠিয়া দাথন আর আবিরামর গেছে গেলা, তান খরে অইয়া বনি ইছরাইলর মুরব্বি নেতা অকলও গেলা। ");
INSERT INTO syl_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","তাইন বনি ইছরাইলরে কইলা, “তুমরা অউ নাফরমান অকলর তাম্বু থাকি হরি যাও, ইতার কুনু মাল-ছামানাত ছইও না। আরনায় তারার গুনার সাজার লগে তুমরারেও বিনাশ করা অইবো।” ");
INSERT INTO syl_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","ইখান হুনিয়া কুরাহ, দাথন আর আবিরামর তাম্বুর গেছ থাকি হকল মানুষ হরি গেলা। এরমাজে দাথন আর আবিরামে তারার বউ-বাইচ্চাইন আর হুরু-বড় হকল হুরুতাইন লইয়া আইয়া যারযির তাম্বুর দুয়ারর গেছে উবাত আছিল। ");
INSERT INTO syl_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","অউ সময় মুছায় বনি ইছরাইলরে কইলা, “তুমরা অউ আলামত দেখিয়া বুজিলিবায়, আমি যেতা করিয়ার ইতা আমার মনগড়া কুন্তা নায়। অউ কামর লাগি মাবুদেউ আমারে পাঠাইছইন। ");
INSERT INTO syl_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","এরার মরন যুদি অইন্যান্য মানষর লাখান স্বাভাবিক হালতে অয়, তে মনো করিও, মাবুদে আমারে পাঠাইছইন না। ");
INSERT INTO syl_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","অইলে মাবুদে যুদি আচানক নয়া কুনু কাম করইন, অউ জমিনে মুখ খুলিয়া তারারে আর তারার হকলতারে জিন্দা গিলিলায়, তারা জিন্দা হালতেউ মাটির তলর পাতালো যায়গি, তে বুজিলিও, এরা মাবুদরে এলামি করছে।” ");
INSERT INTO syl_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","মুছায় অখান কওয়ার লগে লগেউ এরার পাওর তলর মাটি ফাটিয়া দুই বাট অইগেল, ");
INSERT INTO syl_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","আর মাটিয়ে আ করিয়া কুরাহর পরিবারর হকলরে তারার মাল-ছামানা সহ গিলিলিলো। ");
INSERT INTO syl_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","মাল-ছামানা সুদ্দা জিন্দা হালতে তারা মাটির তলে গেলগি, বাদে মাটির ফাটা বন্দ অইগেল। অউলা বনি ইছরাইল থাকি তারা একদম নিপাত অইগেল। ");
INSERT INTO syl_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","তারার চিক-চিল্লানি হুনিয়া চাইরোবায় থাকি হকল মানুষ দৌড়াইয়া বাগিলা, ইতায় চিল্লাই চিল্লাই দৌড়াইয়া কইলা, “মাটিয়ে হয়তো আমরারেও গিলিলিবো।” ");
INSERT INTO syl_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","আর হউ যে আড়াইশো জনে আগর-খুশবয় জালাইয়া কুরবানি করছিল, মাবুদর গেছ থাকি গাইবি আগুইন আইয়া ইতারে জালাইয়া ছালি করিল্লো। ");
INSERT INTO syl_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","বাদে মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“তুমি ইমাম হারুনর পুয়া আলি-আজররে কও, অউ জালাইল জাগা থাকি আগর দানি গুইন বার করিয়া, এর আংরা-ছালি নিয়া থুড়া দুরই ফালানির লাগি, ই আগর দানি গুইন পাক-পবিত্র বনিগেছে। ");
INSERT INTO syl_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","নাফরমানির লাগি যেগুইন মরিগেছইন, অউ আগর দানি তো তারার আছিল। অইলে মাবুদর ছামনে ইতা আজির করা অইছিল, এরলাগি ই হকলটি পাক-পবিত্র অইগেছে। তে তুমি ইতা ভাংগাইয়া পাত বানাইয়া পবিত্র কুরবানি খানারে গুরিয়া থইও। ইতা নিশানা হিসাবে বনি ইছরাইলর গেছে রইবো।” ");
INSERT INTO syl_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","তেউ আগুইনে জলিয়া যেগুইন মরছিলা, অতার আনা পিতলর আগর দানি গুইন ইমাম আলি-আজরে একখানো দলা করলা। বাদে অতা ভাংগাইয়া কুরবানি খানা গুরিয়া থওয়ার পাত বানাইলা। ");
INSERT INTO syl_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","মাবুদে মুছা নবীর মাজদি যেলা হুকুম দিছলা, এইন অউ লাখান করলা। ইকটা করা অইলো যাতে বনি ইছরাইলর মনো থাকে যেন, খালি হারুনর বংশ ছাড়া দুছরা কুনু জন, আগর-খুশবয় জালানির লাগি মাবুদর ছামনে যাইতো পারতো নায়। যুদি যায়, তে তার দশা অউ কুরাহ আর তার দলর লাখান অইবো। ");
INSERT INTO syl_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","অইলে বাদর দিনউ বনি ইছরাইলর মানষে হজরত মুছা আর হারুনর বিরুদ্ধে বের-বেরি লাগাইলো, তারা কইলো, “মাবুদর বন্দা অকলরে তুমরাউ মারছো।” ");
INSERT INTO syl_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","আর সমাজর হকল মানষে যেবলা মুছা আর হারুনর বিরুধিতা করিয়া মিলন-তাম্বুর মুখা ঘুরিয়া উবাইলো, অউ সময় হউ গাইবি মেঘর খুটিয়ে আখতাউ মিলন-তাম্বু গুরি গেল, মাবুদর কুদরতি নুর জাইর অইলো। ");
INSERT INTO syl_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","তেউ মুছা আর হারুন মিলন-তাম্বুর ছামনে গেলা, ");
INSERT INTO syl_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","আর মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“ইতা মানষর গেছ থাকি তুমরা হরি যাও, আমি ইতারে চখুর পলকর লগে শেষ করিলিয়ার।” ইখান হুনিয়াউ তারা দুইও জন সইজদাত পড়লা। ");
INSERT INTO syl_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","বাদে মুছায় হারুনরে কইলা, “তুমার আগর দানি আতো লও, আর কুরবানি খানা থাকি আগুইন নেও, নিয়া এর উপরে আগর-খুশবয় জালাইয়া, জলদি করি অতা মানষর গুনা মাফির কফরা আদায় করো। মাবুদ তো গুছায় আগুইন অইগেছইন, তান লান্নতি মহামারি শুরু অইগেছে।” ");
INSERT INTO syl_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","তেউ মুছার কথামতো হারুনে আগর দানিত আগুইন আর আগর-খুশবয় লইয়া তারার গেছে দৌড়াইয়া গেলা। এর মাজেউ ইতার উপরে গজব শুরু অইগেছিল, অইলে হারুনে আগর-খুশবয় জালাইয়া তারার গুনার কফরা আদায় করলা। ");
INSERT INTO syl_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","তাইন জিন্দা আর মুর্দা জনর মাজখানো উবাইলা, এরলাগি গজব বন্দ অইগেল। ");
INSERT INTO syl_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","কুরাহর নাফরমানির লাগি যেতা মারা গেছলা, ইগুইন বাদেও আরো চৌদ্দ আজার সাতশো মানুষ গজবি মহামারিয়ে মরলা। ");
INSERT INTO syl_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","মহামারি বন্দ অইয়া হারলে হারুন মিলন-তাম্বুর দুয়ারর গেছে মুছার ধারো ফিরিয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","বাদে মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“তুমি বনি ইছরাইলরে কও, তারা যানু তারার বাফ-দাদার খান্দান হিসাবে পরতেক খান্দানর সর্দারর গেছ থাকি একটা করি মোট বারোটা লাঠি আনিয়া তুমার গেছে দেয়। দিলে তুমি যারযির লাঠির উপরে অউ জনর নাম লেখবায়। ");
INSERT INTO syl_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","লেবি খান্দানর লাঠিত লেখিও ইমাম হারুনর নাম, অলা বাফ-দাদার খান্দান মাফিক পরতেক খান্দানর সর্দারর লাগি একোটা লাঠি থাকবো। ");
INSERT INTO syl_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","মিলন-তাম্বুর ভিতরে পবিত্র শাহাদত সন্দুকর ছামনে যে জাগাত তুমরার লগে আমার দেখা অয়, অউ লাঠিগুইন হনো থইও। ");
INSERT INTO syl_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","তেউ আমার পছন্দ করা বন্দার লাঠির মাজে গাছর খেং ফুটিবো। অউ লাখান তুমরার বিরুদ্ধে বনি ইছরাইলর বের-বেরি করা আমি বন্দ করমু।” ");
INSERT INTO syl_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","তেউ মুছায় ইতা হকলতা বনি ইছরাইলরে জানাইলা। আর তারার বাফ-দাদার খান্দান মাফিক পরতেক সর্দারে যারযির খান্দানর তরফ থাকি এগু করি, মোট বারো খান্দানর বারোটা লাঠি আনিয়া দিলা। অউ লাঠিন্তর এগু লাঠি আছিল হারুন নবীর। ");
INSERT INTO syl_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","মুছায় অউ লাঠিগুইন নিয়া শাহাদত তাম্বুর ভিতরে মাবুদর ছামনে থইলা। ");
INSERT INTO syl_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","বাদর দিন মুছা গিয়া শাহাদত তাম্বুর ভিতরে হামাইয়া দেখইন, লেবি খান্দান থাকি হারুনর নামে যে লাঠি রাখা অইছে, ই লাঠিত খালি খেং নায়, কুড়ি দিয়া ফুল ফুটিয়া বাদামও ধরিলিছে। ");
INSERT INTO syl_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","তেউ মুছায় মাবুদর ছামনে থাকি লাঠি গুইন বার করি আনিয়া বনি ইছরাইলর ছামনে থইলা। সর্দার অকলে লাঠি গুইন দেখলা, দেখিয়া যারযির লাঠি চিনিয়া নিলা। ");
INSERT INTO syl_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","বাদে মাবুদে মুছারে কইলা, “বিরুধি নাফরমান অকলর মনো রওয়ার লাগি নিশানা হিসাবে তুমি হারুনর লাঠিটা হিরবার শাহাদত সন্দুকর ছামনে থও। তেউ আমার বিরুদ্ধে তারার বকবক করা খান তুমি বন্দ করতায় পারবায়, তারাও আর মরতা নায়।” ");
INSERT INTO syl_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","মাবুদে মুছারে যেলা হুকুম দিলা, মুছায় ঠিক অলা করলা। ");
INSERT INTO syl_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","ইতা দেখিয়া বনি ইছরাইলে মুছারে কইলা, “আমরা তো মরিযাইয়ার, বিনাশ অইযিয়ার, আমরার সর্বনাশ অইযার! ");
INSERT INTO syl_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","যেকুনু মানুষ মাবুদর ঘরর ধারো গেলেউ মরিযার, তে আমরা হকলউ মরিযিমু নি?” ");
INSERT INTO syl_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","মাবুদে হারুন নবীরে কইলা, “পবিত্র এবাদত খানার বেয়াপারে যত নাফরমানি করা অইবো, এর দায়-দায়িত্ব বর্তিবো তুমার উপরে, তুমার পুয়াইন আর তুমার গুষ্টির হকলর উপরেও। আর ইমামতি কামর বালা যত লাখান নাফরমানি করা অইবো, ইতার দায়ী অইবায় খালি তুমি আর তুমার পুয়াইন। ");
INSERT INTO syl_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","তে তুমার বাফ-দাদার খান্দান থাকি আরো লেবি অকলরে তুমি আনো। তারা আইয়া তুমারে আর তুমার পুয়াইনরে শাহাদত তাম্বুর ছামনর এবাদতি কামো সাইয্য করবা। তারা তুমার জিম্মায় রইয়া শাহাদত তাম্বুর হকল কাম-কাজ করবা। ");
INSERT INTO syl_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","অইলে কুরবানি খানা বা আল্লার ঘরর কুনু পবিত্র জিনিসর ধারো যাওয়া তারার লাগি নিষেধ। নিষেধ না মানলে তারা আর তুমরা হকলউ মরবায়। ");
INSERT INTO syl_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","তারা তুমার কামো শরিক অইয়া মিলন-তাম্বুর খাদিমদারি করবা, হকল জাত কামর দায়-দায়িত্ব নিবা। তা-ও খালি লেবি অকল ছাড়া দুছরা কেউ তুমরার গেছে যাওয়া নিষেধ। ");
INSERT INTO syl_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","বনি ইছরাইলর উপরে আমি যানু হিরবার নারাজ না অই, এরলাগি এবাদত খানা আর কুরবানি খানা দেখা-হুনার ভার তুমরার উপরে রইবো। ");
INSERT INTO syl_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","আমি নিজে তুমরারে উপহার হিসাবে দিবার লাগি, বনি ইছরাইলর মাজর লেবি অকলরে পছন্দ করছি। মিলন-তাম্বুর কাম করার লাগি এরারে মাবুদর নামে সপি দেওয়া অইছে। ");
INSERT INTO syl_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","অইলে ইমাম হিসাবে খালি তুমি আর তুমার পুয়াইন্তে কুরবানি খানা আর পর্দার ভিতরর হেরেম শরিফো খেজমত কাম করবায়। ইমামতির পদ খান আমি উপহার হিসাবে তুমরারে দিলাম। খালি লেবি অকল ছাড়া দুছরা কেউ যুদি মিলন-তাম্বুর সীমানাত আয়, তে তারে জানে মারিলিতে অইবো।” ");
INSERT INTO syl_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","এরবাদে মাবুদে হারুনরে কইলা, “আমার নামে যত লাখান কুরবানি দেওয়া অয়, ইতার হকল জিম্মাদারি আমি নিজেউ তুমার আতো সমজাইছি। তে আমার নামে বনি ইছরাইলর কুরবানি করা হকল পাক-পবিত্র জিনিস, আমি তুমারে আর তুমার ওয়ারিশর পাওনা বেতন হিসাবে চিরকালর লাগি দিলাইলাম। ");
INSERT INTO syl_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","খাছ পবিত্র কুরবানির যে অংশ আগুইনো জালানি লাগতো নায়, অউ বাটও তুমরা নিওগি। তে ধান-গমর ছদগা, গুনার কফরার কুরবানি, আর দুষ-কছুরির কফরার কুরবানির লাগি বনি ইছরাইলে আমার গেছে যততা লইয়া আইবা, ইতা তুমি আর তুমার ওয়ারিশ অকলর পাওনা হক। ");
INSERT INTO syl_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","ইতা নিয়া হারি খাছ পাক-পবিত্র জিনিস বুজিয়া ইজ্জত করিয়া তুমরা খাইও। তুমরার হকল বেটাইন্তে ইতা খাইতায় পারবায়। ই খানি তুমরার লাগি পবিত্র। ");
INSERT INTO syl_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","আর বনি ইছরাইলর দেওয়া হকল দুলনা কুরবানির জিনিসও তুমরার অইবো। ইতা আমি তুমারে আর তুমার ওয়ারিশ অকলরে চিরকালিন পাওনা হিসাবে দিরাম। তুমার পরিবারর যেরা পাক-পাকিজা হালতে রইবা, তারা ইতা খাইতা পারবা। ");
INSERT INTO syl_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“বনি ইছরাইলে তারার খেতর হকল থাকি ভালা যে তেল, নয়া আংগুরর শরবত আর ফসলর যে অংশ মাবুদর নামে ছদগা দিবা, ইতা হক্কলতা আমি তুমারে দিলাইলাম। ");
INSERT INTO syl_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","মাবুদর গেছে আনা তারার ফলাইল ফয়-ফসলর পয়লা অংশ তুমার অইবো। তুমার পরিবারর মাজর যেরা পাক-পাকিজা হালতে থাকবা, তারা ইতা খাইবা। ");
INSERT INTO syl_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“বনি ইছরাইলে পুরাপুর দাবি-দাওয়া ছাড়িয়া মান্নত হিসাবে যত জিনিস দিবা, ইতাও তুমি পাইবায়। ");
INSERT INTO syl_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","মাবুদর নামে সপি দেওয়া পরতেক পয়লা বাইচ্চা তুমার অইবো, ইতা মানষর আওলাদ অউক বা পশুর বাইচ্চা অউক। মানষর পয়লা পুয়ারে তুমি নিচ্চয় খালাছ করিয়া নিতে দিও, আর নাপাক পশুর পয়লা মেদা বাইচ্চারেও অলা খালাছ করি নিতে দিও। ");
INSERT INTO syl_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","মানষর পয়লা পুয়ার বয়স একমাস অইলে খালাছ করানির জানর বদলা বাবত, এবাদত খানার মাপে পাচ তোলা রুপা নিয়া আজাদ করি দিও। ");
INSERT INTO syl_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","অইলে গাই-গরু বা মেড়া-ছাগলর পয়লা বাইচ্চারে খালাছ করাই নিতে দিও না, ইগুইন তো হালাল। ইতারে কুরবানি দিয়া তুমি কুরবানি খানার উপরে লউ ছিটাইয়া দিও, আর চর্বিরে আগুনিত দেওয়া কুরবানি হিসাবে জালাইও। ই কুরবানির ধুমার ঘেরানে আমি মাবুদ খুশি অই। ");
INSERT INTO syl_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","দুলনা করাইল ছিনা আর ডাইনর রানর গোস্তর লাখান, অগুইন্তর গোস্তও তুমি পাইবায়। ");
INSERT INTO syl_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","মাবুদর নামে বনি ইছরাইলর কুরবানি করা হকল পবিত্র জিনিস তুমার পাওনা বাবত আমি তুমারে আর তুমার আওলাদ অকলরে চিরকালর লাগি দিলাইলাম। ইতা অইলো মাবুদর লগে তুমি আর তুমার ওয়ারিশর লাগি চিরকালিন চুক্তি, এর কুনু রদ-বদল অইতো নায়।” ");
INSERT INTO syl_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","এরবাদে মাবুদে হারুনরে কইলা, “বনি ইছরাইলর দেশো তুমি কুনু ধন-দৌলতর মালিকানা বা জমি-জমার কুনু বাটও পাইতায় নায়। এরার মাজে তুমার পাওনা বাট অইলাম স্বয়ং আমি, আমিউ তুমার ধন-দৌলত।” ");
INSERT INTO syl_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","মাবুদে কইলা, “বনি ইছরাইলে তারার রুজি-রুজগারর দশ বাটর এক বাট তো আমারে দিবা, আমিও ইতা লেবি খান্দানর পাওনা বেতন বাবত দিলাইলাম। মিলন-তাম্বুত এবাদতি কামর মজুরি হিসাবে তারা ইতা পাইবা। ");
INSERT INTO syl_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","আর আইজ থাকি বনি ইছরাইলর দুছরা কুনু গুষ্টির মানুষ মিলন-তাম্বুর ধারো যাওয়া নিষেধ। গেলে তারার নাফরমানির দায় তারা মরবা। ");
INSERT INTO syl_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","মিলন-তাম্বুর কাম-কাজ খালি লেবি খান্দানে করবা, অউ কামো যেকুনু নাফরমানি করলে তারা নিজেউ দায়ী অইবা। ইতা অইবো ওয়ারিশর পর ওয়ারিশ ধরি একটা চিরকালিন নিয়ম। বনি ইছরাইলর অইন্যান্য খান্দানর লগে কুনু ধন-দৌলতর মালিকানা লেবি খান্দানে পাইতো নায়। ");
INSERT INTO syl_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","এর বদলা বনি ইছরাইলে তারার রুজি-রুজগারর যে দশ বাটর এক বাট মাবুদর দরবারো আজির করবা, ইতা আমি এরার পাওনা হিসাবে দিলাইলাম। এরলাগি এরার বেয়াপারে আমি মাবুদে কইছি, লেবি অকলে বনি ইছরাইলর মাজে কুনু জমি-জমার মালিকানা পাইতা নায়।” ");
INSERT INTO syl_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","বাদে মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“তুমি লেবি অকলরে কও, অইন্যান্য বনি ইছরাইলর রুজি-রুজগারর যে দশ বাটর এক বাট পাওনা হিসাবে আমি তুমরারে দিলাম, ইতা পাইয়া হারলে তুমরাও অতার দশ বাটর এক বাটরে, যকাতর যকাত বাবত মাবুদর নামে দিলাইবায়। ");
INSERT INTO syl_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","অউ যকাতরেউ তুমরার খেতর ফসলর আর নিজর বানাইল আংগুরর শরবতর যকাত হিসাবে গনা অইবো। ");
INSERT INTO syl_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","বনি ইছরাইলর বাকি এগারো খান্দানর যকাত বাবত যে দশ বাটর এক বাট তুমরা পাইবায়, অখান থাকি তুমরাও অলা দশ বাটর এক বাট মাবুদর নামে যকাত দিবায়। মাবুদর নামর অউ অংশ তুমরা ইমাম হারুনর আতো দিও। ");
INSERT INTO syl_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","তুমরারে যততা দেওয়া অইবো, তুমরাও অতার হকল থাকি ভালা আর পবিত্র অংশ, মাবুদর পাওনা হিসাবে তানরে দিও। ");
INSERT INTO syl_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“হকল থাকি ভালা অংশ মাবুদরে দেওয়ার বাদে যেতা বাকি রইবো, অতারে তুমরার নিজর খেতর ফসল, আর তুমরার নিজর বানাইল আংগুরর শরবত হিসাবে গনা অইবো। ");
INSERT INTO syl_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","অউ অংশ তুমরা আর তুমরার পরিবারর মানষে যেকুনু জাগাত খাইতায় পারো, ইতা তো তুমরার কামর বেতন, মিলন-তাম্বুর খেজমতর বেতন। ");
INSERT INTO syl_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","হকল থাকি ভালা অংশ মাবুদর নামে দিলাইলে, বাকিতা খাইতে তুমরার কুনু দুষ নাই। আর বনি ইছরাইলর দেওয়া পাক-পবিত্র মালরে তুমরা অপবিত্র করিও না, তেউ তুমরা মরতায় নায়।” ");
INSERT INTO syl_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","এরবাদে মাবুদে মুছা আর হারুনরে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“তুমরা বনি ইছরাইলরে কও, মাবুদে শরিয়তর হুকুম মাফিক বাতাইছইন, তুমরা পুরাপুর লাল রংগর এগু ডেকি গরু লইয়া আমরার গেছে আও, অউ ডেকি ষোলআনা নিখুত অইতো, আর তাইর কান্দো কুনুদিন জুয়াল লাগানি অইছে না। ");
INSERT INTO syl_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","অগু আনিয়া তুমরা ইমাম আলি-আজরর গেছে দিবায়। ইমামে ইটারে কেম্পর বারে নিয়া তান ছামনে জবো করাইবা। ");
INSERT INTO syl_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","জবোর বাদে তান আংগুলো কিছু লউ লইয়া মিলন-তাম্বুর ছামনা বায় সাত বার ছিটাইবা। ");
INSERT INTO syl_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","তান ছামনেউ অউ গাইর খাল, গোস্ত, লউ আর গুফর সুদ্ধা আত-ভড় আগুইনদি জালাইলিও। ");
INSERT INTO syl_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","অউ ডেকিরে জালানির সময় ইমামে দেবদারু গাছর কিছু দারু, এছুব গাছর ডেটা, আর লাল রংগর কিছু সুতারে অউ আগুনির মাজে ফালাইবা। ");
INSERT INTO syl_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","বাদে তাইন নাইবা, আর ফিন্নর কাপড়-চুপড়ও ধইবা। নাইয়া-ধইয়া হারলে তাইন কেম্পর ভিতরে যাইতা পারবা, অইলে হাইঞ্জা পর্যন্ত তাইন নাপাক হালতে রইবা। ");
INSERT INTO syl_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","যে জনে অউ ডেকির হকলতা জালাইবো, হে-ও নাইয়া হারি কাপড়-চুপড় ধইবো আর হাইঞ্জা পর্যন্ত নাপাক রইবো। ");
INSERT INTO syl_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","অউ ডেকির জালাইল ছালি খানাইন কুনু পাক-ছাফ মানষে তুলিয়া নিয়া, কেম্পর বারে কুনু পাক জাগাত থইবো। বনি ইছরাইলে পাক-ছাফ অওয়ার পানি তিয়ার করার লাগি অউ ছালিরে যতনে থইবা। বাদে নাপাক থাকি পাক-ছাফ অওয়ার কালো অউ পানি কামো লাগাইবা। ");
INSERT INTO syl_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","যে জনে অউ ছালি তুলবো, হে-ও তার কাপড়-চুপড় ধইতে অইবো আর হাইঞ্জা পর্যন্ত নাপাক রইবো। ইটা বনি ইছরাইল আর তারার মাজে বসত কররা হকল জাতির লাগি চিরকালিন নিয়ম। ");
INSERT INTO syl_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“কেউ যুদি কুনু মুর্দার লাশ ছইলায়, তে সাত দিন ভরা হে নাপাক রইবো। ");
INSERT INTO syl_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","লাশ ছওয়ার তিন নম্বর আর সাত নম্বর দিন, পাক-ছাফ অওয়ার পবিত্র পানি দিয়া নিজরে ধইয়া হারলে হে পাক-ছাফ অইবো। আর ই নিয়ম না মানলে হে নাপাকউ রইবো। ");
INSERT INTO syl_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","লাশ ছওয়ার বাদে কেউ যুদি পাক-ছাফ না অয়, তে হে মাবুদর ঘররে নাপাক বানায়। অউ জনরে বনি ইছরাইলর সমাজ থাকি ফুছিলিবায়। পাক-ছাফ অওয়ার পানি তার শরিলো না ছিটানিয়ে, তার নাপাকি তার লগে রইবো। ");
INSERT INTO syl_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“আর তাম্বুর ভিতরে কুনু মানুষ মরিগেলে, যেরা অউ তাম্বুত হামাইবা আর যেরা তাম্বুত আছলা, তারা হকলউ সাত দিন ভরা নাপাক রইবা। ");
INSERT INTO syl_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","অউ বসত তাম্বুর ভিতরর যেতা থাল-বাসন হরা দিয়া গুরা আছিল না, অতাও নাপাক অইযিবো। ");
INSERT INTO syl_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“বন্দর মাজে খুলা জাগাত ফালাইল কুনু লাশরে যুদি কেউ ছইলায়, তে হে সাত দিন ভরা নাপাক রইবো। ই লাশ কুনু লাড়াইর কারনে অউক, বা এমনে মরা অউক, যেরা ছইবো এরা নাপাক। কুনু মরা মানষর আড্ডি বা কয়বররে ছইলে, হে-ও সাত দিন ভরা নাপাক রইবো। ");
INSERT INTO syl_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“অলা নাপাক মানষরে পাক-ছাফ করার নিয়তে যে লাল ডেকির গোস্ত জালানি অইছে, অগুর কিছু ছালি একটা গামলাত লইয়া, অউ গামলাত ফুতর পানি ভরতে অইবো। ");
INSERT INTO syl_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","বাদে কুনু পাক-ছাফ মানষে এছুব গাছর কয়টা ডেটা আনিয়া পানিত বুড়াইয়া হউ মুর্দার তাম্বু, এর ভিতরর হকল মাল-ছামানা আর মানষর উপরে ছিটাই দিবা। যত জনে এমনে মরা, বা খুন অইয়া মরা কুনু মুর্দার লাশ, মরার আড্ডি-গুড্ডি বা কয়বর ছইছে, তারার উপরেও অউ পানি ছিটাই দিবা। ");
INSERT INTO syl_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","পাক-ছাফ অউ জনে নাপাক মানষর উপরে হাপ্তার তিন নম্বর আর সাত নম্বর দিন পানি ছিটাই দিবা, আর সাত নম্বর দিন তারা পাক-ছাফ অইবা। তারা গোছল করিয়া ফিন্নর কাপড়-চুপড় ধইবা, আর অউ সাত নম্বর দিনর হাইঞ্জা থাকি পাক-ছাফ বনবা। ");
INSERT INTO syl_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","অইলে নাপাক অওয়ার বাদে কেউ যুদি নিজরে পাক-ছাফ না করে, তে তারে সমাজ থাকি ফুছিয়া ফালাইবায়। হে নিজরে নাপাক রাখিয়া মাবুদর হেরেম শরিফরেও নাপাক বানাইছে। পাক-ছাফ অওয়ার পানি তার উপরে না ছিটানিয়ে, হে নাপাক রইছে। ");
INSERT INTO syl_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","ইতা অইবো বনি ইছরাইলর লাগি একটা চিরকালিন নিয়ম। “যে জনে অউ পাক-ছাফ অওয়ার পানি ছিটাইবা, এইন নিজেও তান কাপড়-চুপড় ধইতে অইবো। ই পাক-ছাফ অওরার পানি কুনু মানষে ছইলে, হে হাইঞ্জা পর্যন্ত নাপাক রইবো। ");
INSERT INTO syl_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","নাপাক হালতে ই জনে যততা ছইবো, ইতা হকলতা নাপাক অইযিবো, তার ছওয়া কুনু জিনিস যেগিয়ে ছইবো, হে-ও হাইঞ্জা পর্যন্ত নাপাক রইবো।” ");
INSERT INTO syl_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","বছরর পয়লা চান্দো হক্কল বনি ইছরাইল জীন মরুভুমিত গিয়া কাদেশ এলাকাত আইয়া রইলা। হনো মুছা নবীর বইন বিবি মরিয়মর ইন্তেকাল অইলো আর তানরে দাফন করা অইলো। ");
INSERT INTO syl_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","হিনো খাইবার কুনু পানি না পাওয়ায় বনি ইছরাইলে মুছা আর হারুনর বিরুদ্ধে দল বান্দিয়া এরার পিছে লাগলা। ");
INSERT INTO syl_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","তারা মুছার লগে কাইজ্জা করিয়া কইলা, “আমরার লগর ভাইয়াইন যেবলা মাবুদর ছামনে মরছলা, হউ সময় আমরাও মরিগেলে ভালা আছিল। ");
INSERT INTO syl_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","মাবুদর বন্দা অকলরে তুমি কেনে অউ মরুভুমিত আনলায়, অখন পশুর পাল সুদ্ধা আমরা হক্কলে অনো জান খুয়াইতাম নি? ");
INSERT INTO syl_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","মিসর দেশ থাকি তুমি কেনে আমরারে অলা যমর গাতো লইয়া আইলায়? ই জাগাত না আছে কুনু ধান-চাউল বা ডুমুর ফল, না আছে আংগুর বা আনুয়ার ফল? আর খাইবার পানিও নাই।” ");
INSERT INTO syl_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","ইতা হুনিয়া মুছা আর হারুন মানষর গেছ থাকি হরিয়া মিলন-তাম্বুর দুয়ারর গেছে গিয়া সইজদাত পড়লা। তেউ মাবুদর নুরর তজল্লি তারার ছামনে জাইর অইলো। ");
INSERT INTO syl_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“তুমি হউ লাঠিটা লও, লইয়া তুমি আর তুমার ভাই হারুনে হকল বনি ইছরাইলরে একখানো দলা করো। আর অউ বড় যে পাথরগু দেখরায়, তারার ছামনে অউ পাথররে হুকুম দেও, দিলে অউ পাথরে পানি দিবো। বনি ইছরাইল আর তারার পশুপাল হকলে যাতে পানি খাইতো পারে, এরলাগি তুমি অউ পাথর থাকি পানি বার করবায়।” ");
INSERT INTO syl_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","মাবুদর হুকুম মত তান ছামনে থাকি মুছায় লাঠিটা লইলা। ");
INSERT INTO syl_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","লইয়া মুছা আর হারুনে মানষরে অউ পাথরর গেছে দলা করলা। আর মুছায় তারারে কইলা, “ও বেইমানর জাত, হুনো, আমরা অউ পাথর থাকি তুমরার লাগি পানি বার করতাম নি?” ");
INSERT INTO syl_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","অখান কইয়া মুছায় লাঠি দিয়া অউ পাথরো দুই বাড়ি মারলা, বাড়ি মারার লগে লগে পাথর থাকি জুরে জুরে পানি বার অইলো, তেউ তারা আর তারার পশুর পালে পানি খাইলা। ");
INSERT INTO syl_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","অইলে মাবুদে মুছা আর হারুনরে কইলা, “তুমরা তো বনি ইছরাইলর ছামনে আমারে পাক-পবিত্র কইয়া মানলায় না, আমার জবানর উপরে ভরসা করলায় না। এরলাগি আমি যে দেশখান বনি ইছরাইলরে দান করমু, তুমরা তারারে লইয়া হিনো যাইতায় পারতায় নায়।” ");
INSERT INTO syl_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","পাথর থাকি যে জাগাত পানি বার অইলো, অউ জাগার নাম দেওয়া অইলো মেরীবা, মানি কাইজ্জা। ইনো বনি ইছরাইলে মাবুদর লগে কাইজ্জা করছিল, আর মাবুদে অনোউ তান পাক-পবিত্রতা তারার ছামনে জাইর করছইন। ");
INSERT INTO syl_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","বাদে মুছায় কাদেশ থাকি মানুষ পাঠাইয়া ইদোম দেশর বাদশারে কইলা, “আমরা তো বনি ইছরাইল, আপনার ছিলছিলার ভাইয়াইন। আপনার দরবারো আমরার একখান আরজি আছে, আপনে তো আমরার দুখ-মছিবতর কথা জানইন। ");
INSERT INTO syl_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","তে আমরার বাফ-দাদাইন তো মিসর দেশো গেছলা, আর আমরা বউত বছর হনো আছলাম। মিসরী অকলে আমরা আর আমরার ময়-মুরব্বির উপরে জুলুম-মছিবত করায়, ");
INSERT INTO syl_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","আমরা মাবুদর দরবারো কান্দা-কাটি করলাম। তেউ মাবুদে আমরার ফরিয়াদ কবুল করিয়া, তান ফিরিস্তা পাঠাইয়া আমরারে হউ দেশ থাকি বার করি আনছইন। “এরলাগি আমরা অখন আপনার দেশর সীমানার কাদেশ টাউনর কান্দাত আইছি। ");
INSERT INTO syl_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","আপনে আমরারে আপনার দেশর মাজদি যাইবার সুযোগ খান দেউক্কা। আমরা আপনার কুনু খেত-কিষি বা আংগুর বাগানর মাজেদি যাইতাম নায়, কুনু কুয়া থাকি পানিও তুলিয়া খাইতাম নায়। আমরা খালি রাজ পথেদি আটিয়া যাইমু, আপনার দেশর সীমানা পারনির আগ পর্যন্ত ডাইনে-বাউয়ে কুনুবায় পাও বাড়াইতাম নায়।” ");
INSERT INTO syl_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","অইলে ইদোমর বাদশায় কইলা, “না, না, তুমরা ইবায় যাইতায় পারতায় নায়। যাইবার চেষ্টা করলে আমরা যুদ্ধত বার অইয়া তুমরার উপরে হামলা করমু।” ");
INSERT INTO syl_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","তেউ বনি ইছরাইলে জুয়াপ দিলা, “আমরা তো খালি রাজ পথেদি যাইমু। আমরা বা আমরার পশুর পালে যুদি আপনার দেশর কুনু পানি খাই, তে ইতার দাম দিলাইমু। আমরা পাওয়ে আটিয়া খালি দেশ পাড়ি দিয়া যাইতাম চাইরাম।” ");
INSERT INTO syl_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","অইলে ইদোম দেশর বাদশায় হিরবার কইলো, “না, না, ইবায়দি তুমরার যাওয়া নিষেধ।” বাদে ইদোম দেশর বউত সিপাইয়ে বেটাগিরি দেখাইয়া বনি ইছরাইলর লগে লাড়াই করাত বার অইলো। ");
INSERT INTO syl_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","তারা বনি ইছরাইলরে দেশর ভিতরেদি যাইতে দিলো না, এরলাগি এরা হকল ফিরিয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","এরবাদে বনি ইছরাইল কাদেশ থাকি রওয়ানা অইয়া হুর পাহাড়র গেছে গিয়া আজিলা। ");
INSERT INTO syl_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","হিনো ইদোম দেশর সীমানার ধারো মাবুদে মুছা আর হারুনরে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“হারুন তো তার বাফ-দাদার গেছে কয়বরো যাইতেগি অইবো। আর আমি বনি ইছরাইলরে যে দেশ দিমু, হে তো হি দেশো যাইতো পারতো নায়। মনো আছে নি, মেরীবা নামর জাগাত পানির বেয়াপারে তুমরা আমার হুকুমর উল্টা কাম করছো। ");
INSERT INTO syl_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","তে হারুন আর তার পুয়া আলি-আজররে লইয়া তুমি হুর পাহাড়র উপরে উঠো। ");
INSERT INTO syl_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","উঠিয়া হারুনর গতর থাকি ইমামতি লেবাছ খুলিয়া তার পুয়ারে ফিন্দাও, কারন হারুন তার বাফ-দাদার গেছে যাইবোগি, হনোউ তার ইন্তেকাল অইবো।” ");
INSERT INTO syl_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","মুছায় মাবুদর হুকুম মাফিক অলা করলা। হকল বনি ইছরাইলর ছামনে তারা হুর পাহাড়র উপরে উঠলা। ");
INSERT INTO syl_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","উঠার বাদে মুছায় হারুনর ইমামতি লেবাছ খুলিয়া হারি এন পুয়া আলি-আজররে ফিন্দাইলা। হউ পাহাড়র উপরে হারুনে ইন্তেকাল করলা। বাদে মুছা আর আলি-আজর পাহাড় থাকি লামিয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","বনি ইছরাইলে হারুনর মউতর খবর হুনিয়া পুরা তিশ দিন তান লাগি মাত্তম করলা। ");
INSERT INTO syl_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","আর কেনানী জাতির অরাদ দেশর বাদশা নেগেভ মরুভুমিত বসত করইন, এইন খবর পাইলা, বনি ইছরাইল জাতি অথারিমর পথেদি আটিয়া আইরা, অখান হুনিয়া বাদশায় তারার উপরে হামলা করিয়া কয়জনরে ধরিয়া নিলাগি। ");
INSERT INTO syl_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","তেউ বনি ইছরাইলে মাবুদর দরবারো মান্নত মানিয়া কইলো, “ও মাবুদ, তুমি যুদি অরাদর অউ বাসিন্দা অকলরে আমরার আতো সপিয়া দেও, তে আমরা তারার গাউ-গেরাম আর টাউন অকল এক্কেবারে বিনাশ করিলিমু।” ");
INSERT INTO syl_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","মাবুদে তারার মিনতি কবুল করলা, আর অনর কেনানী অকলরে তারার আতো সপি দিলা। তারা এরা হক্কলরে আর এরার টাউন অকলরে এক্কেবারে বিনাশ করিল্লো। এরলাগি অউ জাগার নাম অইলো হর্মা, মানি বিনাশ। ");
INSERT INTO syl_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","এরবাদে বনি ইছরাইলে ইদোম দেশর গালাবায় ঘুরিয়া যাওয়ার লাগি হুর পাহাড়র গেছ থাকি নীল দরিয়ার পারেদি রওয়ানা দিলা। অইলে পথর মাজে তারা অধৈর্য অইয়া, ");
INSERT INTO syl_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","মুছা নবী আর আল্লা পাকর বিরুদ্ধে মাতা-মাতি লাগাইলা, তারা কইলা, “আমরারে মিসর দেশ থাকি কেনে বার করি আনলায়, অউ মরুভুমিত আনিয়া মারার লাগি নি? ইনো তো খানিও নাই, পানিও নাই। আর অলা বাজে খানি আমরা দুই চউখে দেখতাম পারি না।” ");
INSERT INTO syl_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","অউ সময় মাবুদে তারার মাজে বউত বিষাক্ত হাফ পাঠাইলা। হাফর কামড়ে তারার বউত জন মারা গেলা। ");
INSERT INTO syl_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","তেউ মানষে গিয়া মুছারে কইলা, “আমরা তো আপনার আর মাবুদর বিরুদ্ধে মাতিয়া গুনা করিলিছি। তে আপনে অখন মাবুদর দরবারো মিনতি করউক্কা, যাতে অউ হাফ গুইন আমরার গেছ থাকি হরাইয়া নেইনগি।” তেউ মুছায় তারার লাগি মিনতি করলা। ");
INSERT INTO syl_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","মাবুদে মুছারে কইলা, “তুমি একটা হাফ বানাইয়া উচা এক খুটির উপরে থও। যে মানষরে হাফে কামড়াইবো, হে তুমার অউ হাফর বায় চাইলে ভালা অইযিবো।” ");
INSERT INTO syl_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","তেউ মুছায় খাটি তামাদি এক হাফ বানাইয়া খুটির উপরে থইলা। কুনু জনরে হাফে কামড়াইলে হে অউ তামার হাফর বায় চাইতো, আর বাচিযিতো। ");
INSERT INTO syl_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","বাদে বনি ইছরাইলে রওয়ানা দিলা, আর অবুত নামর জাগাত গিয়া তাম্বু গাড়িলা। ");
INSERT INTO syl_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","আর অবুত থাকি রওয়ানা অইয়া মোয়াব দেশর পুবর সীমানাত, মরুভুমির ইয়া-আবারীমো আইয়া তাম্বু টানাইলা। ");
INSERT INTO syl_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","অখান থাকি রওয়ানা অইয়া জেরেদ নামর হুকনা খালর পারো গিয়া তাম্বু গাড়িলা। ");
INSERT INTO syl_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","জেরেদ থাকি রওয়ানা দিয়া অরনন হুকনা খালর হপারো গিয়া তাম্বু টানাইলা। আমোরী অকলর দেশো থাকি যে মরুভুমি শুরু অইছে, ই খাল আছিল অউ মরুভুমিত। খালর এক পারো মোয়াব দেশ, অইন্য পারো আমোরী অকলর দেশ। ");
INSERT INTO syl_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","মাবুদর জিহাদ নামর কিতাবো তো আছে, “শুফা এলাকার বাহেব আর অরনন হুকনা খাল, ");
INSERT INTO syl_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","আউর টাউনর মুখা যাওরা উচা-নিচা নাল, ইতা তো মোয়াব দেশর এক সীমানা।” ");
INSERT INTO syl_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","অখান থনে রওয়ানা অইয়া তারা বের নামর এক কুয়ার গেছে আইলা। অনো আইয়া হারলে মাবুদে মুছারে কইলা, “তুমি হকল মানষরে একখানো দলা করো, আমি তারারে পানি দিমু।” ");
INSERT INTO syl_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","ইখান হুনিয়া বনি ইছরাইলে অউ গজল গাইলো, “ও কুয়া, তুমার পানি উথলিয়া পড়উক। তুমরা কুয়ার খাতিরে গজল গাও। ");
INSERT INTO syl_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","ইকটা তো হউ সর্দার অকলর কুয়া, রাজা অকলে তারার লাঠির বলে খুদিছইন, খান্দানি গল্লার জুরে করছইন।” বাদে তারা মরুভুমি থাকি মত্তানা নামর জাগাত গেলা। ");
INSERT INTO syl_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","মত্তানা থাকি নহলীয়েল, নহলীয়েল থাকি বামোত, ");
INSERT INTO syl_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","বামোত থাকি মোয়াবর পাহাড়িয়া এক খালর পারো গেলা। অউ খালর কান্দার পিছগা পাহাড়র উচা টিল্লা থাকি মরুভুমি দেখা যায়। ");
INSERT INTO syl_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","বনি ইছরাইলে আমোরী অকলর বাদশা সীহোনর গেছে মানুষ পাঠাইয়া মিনত করলা, ");
INSERT INTO syl_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“আমরা আপনার দেশর ভিতরেদি পার অই যাইতাম চাইরাম, আমরারে যাইবার দিবা নি? আমরা তো রাজ পথ ছাড়িয়া খেত-কিষি বায় বা আংগুর বাগানেদি যাইতাম নায়, কুনু কুয়ার পানিও খাইতাম নায়। আপনার দেশর সীমানা পারনির আগ পর্যন্ত হামেশা রাজ পথেদি আটাত রইমু।” ");
INSERT INTO syl_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","অইলে বাদশা সীহোনে তান দেশর ভিতরেদি তারারে যাইতে দিলা না। তাইন তান সিপাই দল লইয়া মরুভুমির মাজে বনি ইছরাইলর লগে যুদ্ধত বার অইলা। তাইন ইয়াহাজ টাউনো আইয়া তারার লগে যুদ্ধ লাগাইলা। ");
INSERT INTO syl_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","যুদ্ধত বনি ইছরাইলে হউ বাদশারে তলোয়ারদি কাটিয়া অরনন খাল থাকি জাব্বোক খাল পর্যন্ত তার আস্তা দেশ দখল করিলিলা। তারা বনি-আম্মানর সীমানা পর্যন্ত হকল জাগা দখল করলা, অইলে বনি-আম্মানর সীমানা আছিল খুব মজবুত, ইখানরে ডিংগাইয়া যাওয়া কঠিন। ");
INSERT INTO syl_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","বনি ইছরাইলে হিশবন আর এর আশ-পাশর গাউ-গেরাম সুদ্ধা আমোরী অকলর হকল টাউন দখল করিয়া হনো বসতি গাড়িলা। ");
INSERT INTO syl_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","হিশবন আছিল তো আমোরী বাদশা সীহোনর রাজধানি। তাইন মোয়াব দেশর আগর বাদশার লগে যুদ্ধ করিয়া অরনন খাল পর্যন্ত আস্তা দেশ দখল করছিলা। ");
INSERT INTO syl_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","এরলাগি কবি অকলে কইন, “আও তুমরা হকল, হিশবন টাউনো আও, রাজা সীহোনর টাউনরে নয়া করি বানাও। ");
INSERT INTO syl_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","সীহোনর অউ টাউন থাকি আগুইন বার অইয়া, মোয়াবর আউর টাউনরে ছারখার করলো জালাইয়া, অরনন খালর উচা জাগা বিনাশ অইগেলো, হনর হকল ঠাকুররে জালাইয়া মারিল্লো। ");
INSERT INTO syl_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","হায়রে মোয়াব, সর্বনাশ! ও কমোশ-দেবতার ভক্ত অকল তুমরা তো বিনাশ অইগেলায়। কমোশর পুয়াইন বাগিয়া হরিগেছে, তার পুড়িন অকল বন্দি অইছে, আমোরী বাদশা সীহোনর আতো বন্দি তারা। ");
INSERT INTO syl_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","আমরাউ তো তারার লগে যুদ্ধ করছি, দীবান পর্যন্ত আস্তা হিশবন বিনাশ করছি, তারার বাত্তি আমরা নিভাইলিছি, নোফা আর মেদেবা পর্যন্ত ধ্বংস-লিলা চালাইছি।” ");
INSERT INTO syl_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","এরবাদ থাকি বনি ইছরাইলে আমোরী অকলর দেশো বসত করাত রইলা। ");
INSERT INTO syl_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","হজরত মুছায় জাজিরা টাউনো গুইয়া পাঠানির বাদে বনি ইছরাইলে অউ টাউনর আশ-পাশর গাউ-গেরাম হকলতা দখল করলা, আর হনর বাসিন্দা আমোরী অকলরে খেদাই দিলা। ");
INSERT INTO syl_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","বাদে তারা ফিরিয়া বাশন দেশর বায় রওয়ানা অইলা। তেউ বাশনর বাদশা উজে তার হকল সিপাই লইয়া তারার লগে যুদ্ধ করার লাগি ইদরি টাউনো আইয়া আজিলো। ");
INSERT INTO syl_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","অউ সময় মাবুদে মুছারে কইলা, “তুমি বাদশা উজরে ডরাইও না, আমি তারে, তার আস্তা দেশরে আর হকল সিপাইরে তুমার আতো তুলি দিছি। এরলাগি হিশবনর আমোরী অকলর বাদশা সীহোনরে তুমি যে দশা ঘটাইছলায়, অগুরেও অলা করিও।” ");
INSERT INTO syl_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","তেউ তারা বাদশা উজ, তার পুয়াইন আর হকল মানষরে বিনাশ করলা। হেশ-মেশ তারা কেউ আর জিন্দা রইলো না। বনি ইছরাইলে অউ পুরা দেশ দখল করলা। ");
INSERT INTO syl_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","এরবাদে বনি ইছরাইল গিয়া যিরিহো টাউনর উল্টাবায় জর্দান গাংগর ধারো মোয়াব দেশর তল জাগাত তাম্বু টাংগাইলা। ");
INSERT INTO syl_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","বনি ইছরাইলে আমোরী অকলর যে হালত করছিল, মোয়াব দেশর বাদশা বালাক বিন সিপারে ইতা হকলতা দেখছইন। ");
INSERT INTO syl_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","বনি ইছরাইলর অতো মানুষ দেখিয়া মোয়াবী অকল ডরাইগেলা। আসলেউ তারা খুব বেশি ঘাবড়ি গেলা। ");
INSERT INTO syl_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","তারা মাদিয়ান দেশর মুরব্বি নেতা অকলরে কইলা, “গরুয়ে যেলা বন্দর খেছমা ঘাসরে লেইয়া-ফুছি খাইলায়, অউ দলেও অউলা আমরার চাইরো গালার হকলতা লেইয়া-ফুছি খাইলিবো।” অউ সময় মোয়াব দেশর বাদশা আছলা বালাক বিন সিপার। ");
INSERT INTO syl_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","বাদশায় ডরাইয়া বালাম বিন বাউর নামর পীর ছাবরে আনার লাগি খবরিয়া পাঠাইলা। বালাম তো অউ সময় তান নিজর দেশর ফোরাত গাংগর পারো ফতুর টাউনো আছলা। বালাকে খবরিয়ারে কইয়া দিলা, “তুমরা গিয়া তানরে কইও, মিসর দেশ থাকি একদল মানুষ বার অইয়া আইছে। আইয়া আস্তা জমিন ভরিয়া খালি গিছগিছ কররা, তারা অখন আমার ছামনে বসত কররা। ");
INSERT INTO syl_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","ইতা তো আমরা থাকি বেশি বলবান। এরলাগি আপনে আউক্কা, আইয়া অতারে লান্নত দেউক্কা। তেউ আমি হয়তো তারারে মারিয়া দেশ থাকি খেদাইতাম পারমু। আর আমি তো জানি, আপনে যারে দোয়া দেইন হে ঠিকউ দোয়া পায়, আর যারে লান্নত দেইন তার উপরে হাছাউ লান্নত পড়ে।” ");
INSERT INTO syl_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","তেউ মোয়াব আর মাদিয়ানর মুরব্বি নেতা অকলে ইস্তেখারা-আজিরাত করানির টেকা লইয়া রওয়ানা অইগেলা। বাদশা বালাকে যেলা হিকাই দিছলা, তারা গিয়া বালামর গেছে অলা কইলা। ");
INSERT INTO syl_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","তেউ বালামে তারারে কইলা, “তে আপনারা আইজ রাইত আমার অনো রউক্কা। মাবুদে আমারে যেতা জানাইবা, আমি অতা আপনারারে জানাইমু।” গতিকেউ তারা তান অনো রইলা। ");
INSERT INTO syl_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","মাবুদে বালামর গেছে জাইর অইয়া জিকাইলা, “তুমার লগে এরা কারা?” ");
INSERT INTO syl_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","বালামে জুয়াপ দিলা, “মোয়াবর বাদশা বালাক বিন সিপারে আমার গেছে খবরিয়া পাঠাইছইন, ");
INSERT INTO syl_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","কইছইন, মিসর দেশ থাকি একদল মানুষ আইয়া আস্তা দেশো গিছগিছ কররা। অখন আপনে আইয়া তারারে লান্নত দেউক্কা। তেউ আমি যুদ্ধ করিয়া তারারে বুলে খেদাইতাম পারমু।” ");
INSERT INTO syl_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","অইলে মাবুদে বালামরে কইলা, “তুমি এরার লগে যাইও না, আর হিতা মানষরে কুনু লান্নতও দিও না। মনো রাখিও, তারা আমার রহম-বরকত পাওয়া বন্দা।” ");
INSERT INTO syl_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","বাদর দিন বিয়ানে বালাম ঘুম থাকি উঠিয়া বালাকর খবরিয়া অকলরে কইলা, “আপনারা যারযির দেশো ফিরত যাউক্কাগি। আর মাবুদে আমারে মানা করছইন, আপনারার লগে না যাওয়ার লাগি।” ");
INSERT INTO syl_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","তেউ মোয়াবী নেতা অকলে ফিরিয়া গিয়া বাদশা বালাকরে কইলা, “বালাম তো আমরার লগে আইতে রাজি অইছইন না।” ");
INSERT INTO syl_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","অখান হুনিয়া বালাকে এরার চাইতে আরো বেশি, আরো ইজ্জতি নেতা অকলরে পাঠাইলা। ");
INSERT INTO syl_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","তারা গিয়া বালামরে কইলা, “বাদশা বালাক বিন সিপারে কইছইন, আপনে তান গেছে যাইতে কুনুজাতর কুনু বাধা মানতা না। ");
INSERT INTO syl_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","তাইন আপনারে বউত ইজ্জত-বখশিশ দিবা, আর আপনে যেলা কইবা, তাইন অলাউ করবা। খালি আপনে যানু তান পক্ষ লইয়া অতা মানষরে লান্নত দেইন, তাইন অখানউ চাইরা।” ");
INSERT INTO syl_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","বালামে জুয়াপ দিলা, “বাদশা বালাকে যুদি তান সোনা-রুপায় ভরা রাজবাড়ি খানও আমারে দিলাইন, তা-ও আমার মাবুদর হুকুমর উল্টা গিয়া আমি একখান কামও করতাম নায়, ইতা হুরু কাম অউক বা বড় কাম অউক। ");
INSERT INTO syl_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","অইলে আপনারাও আগর এরার লাখান আইজকুর রাইত খান অনো কাটাই লাউক্কা। আমি দেখি, মাবুদে আমারে নয়া কুন্তা কইন নি।” ");
INSERT INTO syl_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","হউ রাইত আল্লায় জাইর অইয়া বালামরে কইলা, “এরা যেবলা তুমারে নেওয়াত আইছে, তে তুমি তারার লগে যাও। গেলে আমি তুমারে যেলা কইমু, তুমি খালি অলাউ করিও।” ");
INSERT INTO syl_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","বাদর দিন বিয়ানে বালাম পীর ঘুম থাকি উঠিয়া তান গাধীর উপরে গদি বিছাইয়া মোয়াবী নেতা অকলর লগে রওয়ানা অইলা। ");
INSERT INTO syl_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","তান যাওয়া দেখিয়া আল্লা পাক তান উপরে গুছায় আগুইন অইগেলা। তানরে বাধা দিবার খিয়ালে আল্লার ফিরিস্তায় পথ আউগলিয়া উবাই রইলা। বালাম তো গাধীর উপরে চড়িয়া যাইরা, তান দুইজন চাকর তান লগে আছিল। ");
INSERT INTO syl_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","মাবুদর ফিরিস্তায় তলোয়ার আতো লইয়া, পথর মাজে উবাই রইছইন দেখিয়া, গাধীটা পথ ছাড়িয়া জমিনেদি লামি গেলো। গাধীরে হিরবার পথো তুলার লাগি বালামে তাইরে মাইর-ধইর করলা। ");
INSERT INTO syl_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","বাদে মাবুদর ফিরিস্তা জমিনর আংগুর বাগানর দুই খেতর মাজর আইলর উপরে উবাই রইলা। আইলর দুইও গালাবায় পাকা ওয়াল দেওয়া আছিল। ");
INSERT INTO syl_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","মাবুদর ফিরিস্তারে দেখিয়া গাধীয়ে ওয়ালর গালাবায় ঘেষিয়া গেলো। এরদায় বালামর এক পাওয়ো খুব ঘষা লাগলো। তেউ তাইন হিরবার গাধীরে মারলা। ");
INSERT INTO syl_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","এরবাদে মাবুদর ফিরিস্তা আগুয়াইয়া গিয়া পথর মাজর অলা এক চিপা জাগাত উবাইলা, যেনো ডাইনে-বাউয়ে কুনুবায় হরার উপায় নাই। ");
INSERT INTO syl_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","মাবুদর ফিরিস্তারে দেখিয়া গাধীয়ে বালামরে লইয়া মাটিত হুতি গেলো। তেউ বালাম আরো গরম অইয়া লাঠি দিয়া গাধীরে মারলা। ");
INSERT INTO syl_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","অউ সময় মাবুদে গাধীর মুখর জবান খুলি দিলা। তাই বালামরে কইলো, “আমি আপনারে কিতা করছি, আপনে তিন-তিনবার আমারে মারলা?” ");
INSERT INTO syl_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","বালামে গাধীরে কইলা, “তুই আমারে আউয়া বানাইয়া খেইড় খেলাইরে নি? হুন, আমার আতো যুদি একখান তলোয়ার থাকতো, তে তরে ছেদ মারি অখনউ কাটিল্লাম অনে।” ");
INSERT INTO syl_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","গাধীয়ে বালামরে কইলো, “আমি আপনার হউ গাধী নায় নি, যেগুর উপরে আপনে হারা জনম ধরি চড়িয়া আইরা, আর আপনার লগে আমি কুনুদিন ইলা করছি নি?” বালামে কইলা, “না, ইলা করছত না।” ");
INSERT INTO syl_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","এরবাদে মাবুদে বালামর চউখ খুলিয়া দিলা, তাইন দেখলা, মাবুদর ফিরিস্তায় তলোয়ার লইয়া পথ বন্দ করি উবাই রইছইন। দেখিয়া তাইন মাথা নোয়াইয়া নাক-কপাল মাটিত লাগাইলা। ");
INSERT INTO syl_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","তেউ মাবুদর ফিরিস্তায় তানরে জিকাইলা, “তুমার গাধীরে কেনে তিন-তিনবার মারলায়? তুমি আমার ছামনে আমার বিরুদ্ধে কাম করাত যাইরায়গি দেখিয়া, আমি তুমারে আটকাইবার লাগি অনো আইছি। ");
INSERT INTO syl_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","তুমার গাধীয়ে আমারে দেখিয়া তিন-তিনবার হরিয়া গেছেগি। তাই যুদি না হরতো, তে আমি তুমারে মারিল্লাম অনে, আর তাইরে বাচাই রাখলাম অনে।” ");
INSERT INTO syl_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","অউ সময় বালামে মাবুদর ফিরিস্তারে কইলা, “আমি তো গুনা করছি। আসলে আমি বুজছি না, আপনে আমারে আটকাইবার লাগি পথো উবাত আছইন। তে আপনে নারাজ অইলে আমি ফিরিয়া যাইমুগি।” ");
INSERT INTO syl_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","মাবুদর ফিরিস্তায় বালামরে কইলা, “ঠিক আছে, তুমি অতা মানষর লগে যাও। অইলে আমি তুমারে যেলা হিকাই দিমু, তুমি খালি অলাউ কইবায়।” তেউ বাদশা বালাকর পাঠাইল নেতা অকলর লগে বালাম পীর চলাত রইলা। ");
INSERT INTO syl_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","বালাম পীরর আওয়ার খবর হুনিয়া, তানরে আগুয়াইয়া আনার লাগি বাদশা বালাক অরনন খালর পারো মোয়াব দেশর এক টাউনো গেলা। ই টাউন আছিল তান দেশর হেশ সীমানাত। ");
INSERT INTO syl_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","বাদশা বালাকে বালাম পীররে কইলা, “আমি তো আপনারে জরুরি তলব করলাম। তে আপনে কেনে পয়লা বার আইলা না? আপনারে যোইগ্য বখশিশ দিবার খেমতা কুনু আমার নাই নি?” ");
INSERT INTO syl_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","বালামে জুয়াপ দিলা, “আমি অখন আপনার গেছে আইছি। অইলে আমার নিজর কুনু মাত মাতার সাইধ্য নাই। খালি আল্লায় আমারেদি যেতা কওয়াইবা, আমি খালি অখানউ কইমু।” ");
INSERT INTO syl_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","এরবাদে বালাক বাদশার লগে অইয়া বালাম পীর কিরিয়ত-হুছোত গাউত গেলা। ");
INSERT INTO syl_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","গিয়া বাদশা বালাকে গরু আর মেড়া কুরবানি দিয়া কিছু গোস্ত বালাম পীররে আর তান লগর হউ নেতা অকলরে দিলা। ");
INSERT INTO syl_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","বাদর দিন বিয়ানে বাদশা বালাকে অউ বালামরে লইয়া বামোত-বাআল পাহাড়ো গেলা। হনো উবাইয়া বালামে বনি ইছরাইলর এক অংশরে দেখলা। ");
INSERT INTO syl_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","আর অউ বিয়ানকু বালা বালাম পীরে বালাক বাদশারে কইলা, “আপনে আমার লাগি সাতখান কুরবানি খানা বানাউক্কা, বানাইয়া কুরবানির লাগি সাতগু বিছাল আর সাতগু মেড়া যুগাই দেউক্কা।” ");
INSERT INTO syl_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","বালামর কথামতোউ বালাকে অলা করলা, করিয়া দুইওজনে মিলিয়া পরতেক কুরবানি খানার উপরে এগু করি বিছাল আর এগু করি মেড়া কুরবানি দিলা। ");
INSERT INTO syl_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","এরবাদে বালাম পীরে বালাকরে কইলা, “আপনার কুরবানি দেওয়া অউ পশুর কাছাত আপনে রউক্কা। আমি থুড়া হরিয়া যাইরাম, অইতো পারে মাবুদে আমারে দরশন দিবা। তাইন আমারে যেতা জানাইবা, আমি আইয়া আপনারে কইমুনে।” অখান কইয়া বালাম পীর গিয়া পাহাড়র হকল থাকি উচা টিল্লার উপরে উঠিলা। ");
INSERT INTO syl_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","অউ সময় মাবুদে তানরে দরশন দিলা। বালাম পীরে মাবুদরে কইলা, “ও মাবুদ, তুমি তো দেখরায়, আমি সাতখান কুরবানি খানা বানাইছি আর পরতেক কুরবানি খানার উপরে এগু করি বিছাল আর এগু করি মেড়া কুরবানি দিছি।” ");
INSERT INTO syl_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","তেউ মাবুদে বালাম পীররে এক বুলি হিকাই দিলা, দিয়া কইলা, “তুমি গিয়া বালাক বাদশারে অতা কইও।” ");
INSERT INTO syl_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","তেউ বালাম পীরে মোয়াব দেশর বাদশা বালাকর গেছে ফিরিয়া আইয়া দেখলা, বাদশা বালাকে মোয়াব দেশর হকল মুরব্বি নেতারে লইয়া তান কুরবানি করা পশুর অনো উবাই রইছইন। ");
INSERT INTO syl_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","অউ সময় বালাম পীরে আল্লার হিকাইয়া দেওয়া অউ বুলি হকল হুনাইলা, কইলা, “সিরিয়া দেশ থাকি বালাকে আমারে আনাইছইন, পুবর পাহাড় অকলর ধারো থাকি মোয়াবর বাদশা বালাকেউ মোরে যুগাইছইন। যুগাইয়া কইলা, আমার পক্ষ লইয়া ইয়াকুবর আওলাদ বনি ইছরাইলরে লান্নত দেউক্কা, অতারে বদদোয়া দেউক্কা। ");
INSERT INTO syl_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","অইলে আল্লায় লান্নত দিছইন না যারে, আমি কিলান দিমু লান্নত তারে? মাবুদে খেতি করার কথা না করছইন যার, আমি কিলান খেতির কথা কইতাম তার? ");
INSERT INTO syl_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","দেখছি আমি তারারে উচা টিল্লা থাকি, তারার বায়দি চাইছি তো পাহাড়র চুড়া থাকি, দেখলাম আমি এরা অইলা অলা এক জাতি, তারা রইন আলগ অইয়া বাকি হকল থাকি। ");
INSERT INTO syl_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","ইয়াকুবর আওলাদ দেখি বালুর দানার মত, গনিয়া ফুড়াইতো তারে কার আছে সাইধ্য? মরন যানু অয় আমার নেককার অউ দলর লাখান আখেরাতো অউক মোর তারারউ লাখান।” ");
INSERT INTO syl_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","ইখান হুনিয়া বাদশা বালাকে বালামরে কইলা, “আপনে ইতা কিতা করলা? আপনারে আনাইলাম আমার দুশমনরে লান্নত দিবার লাগি, আর আপনে খালি তারারে দোয়া দিলা।” ");
INSERT INTO syl_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","বালাম পীরে জুয়াপ দিলা, “মাবুদে আমার মুখো যেতা যুগাই দিছইন, ইতা আমি কইমু না কিলা?” ");
INSERT INTO syl_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","বাদে বাদশা বালাকে বালাম পীররে কইলা, “আপনে আমার লগে আরক জাগাত আউক্কা। হন থনে আপনার চউখে বনি ইছরাইলর দেখা পাইবা। তারা হকলরে দেখা যাইতো নায়, খালি এক অংশরে আপনে দেখবা, দেখিয়া আপনে আমার পক্ষ লইয়া তারারে লান্নত দিবা।” ");
INSERT INTO syl_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","অখান কইয়া বাদশা বালাকে তানরে লইয়া পিছগা পাহাড়র উপরর জফিম নামর বন্দর মাজে লইয়া গেলা। গিয়া হনো সাতখান কুরবানি খানা বানাইয়া পরতেক কুরবানি খানাত এগু করি বিছাল আর এগু করি মেড়া কুরবানি দিলা। ");
INSERT INTO syl_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","বাদে বালাম পীরে বাদশা বালাকরে কইলা, “জালাইল কুরবানির নিয়তে যেতা পশু কুরবানি দেওয়া অইছে, আপনে অতার ধারো রউক্কা। আমি অইন্যবায় যাইরাম, মাবুদর দিদার পাওয়ার আশায়।” ");
INSERT INTO syl_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","মাবুদে বালাম পীররে দিদার দিলা, আর তার জবানর মাজে কিছু বুলি যুগাই দিয়া কইলা, “তুমি বাদশা বালাকর গেছে আমার হিকাইল অউ মাত মাতিও।” ");
INSERT INTO syl_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","তেউ তাইন বাদশার গেছে গেলা। গিয়া দেখলা বাদশায় মোয়াব দেশর নেতা অকলরে লইয়া কুরবানি করা পশুর গেছে উবাই রইছইন। বাদশায় তানরে জিকাইলা, “মাবুদে আপনারে কিতা কইছইন?” ");
INSERT INTO syl_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","বালাম পীরে অউ সময় আল্লার হিকাইল অউ বুলি কইলা, “বাদশা বালাক খিয়াল করো, অখন হুনো দিয়া মন, এরে সিপারর পুত বালাক, মোর কথাত দেও কান। ");
INSERT INTO syl_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","আল্লা পাক তো মানুষ নায় যেন মিছা মাতিবা, তাইন কুনু আদম সন্তান নায় যেন দিল বদলাইবা। তাইন যেলা কথা কইন ঠিক অলাউ করইন, তান ওয়াদা অকলউ নিচ্চিত পুরা করইন। ");
INSERT INTO syl_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","নেক দোয়া দিতাম করি হুকুম যেলা পাইছি, কিলা বদলাইমু আমি মুনিবর অউ মর্জি? ");
INSERT INTO syl_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","ইয়াকুবর আওলাদর মাজে আল্লায় কুনু বদ-নছিব দেখছইন না, বনি ইছরাইলর কপালো কুনু দুখ-মছিবত লেখছইন না। তারার মাবুদ আল্লা তারার লগে আছইন তারার মালিকর জয় গান তারার লগে লগে আছে। ");
INSERT INTO syl_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","মিসর থাকি তাইনউ তারারে বার করি আনছইন তারার পক্ষে তাইন অইলা জংলি বয়রার বল। ");
INSERT INTO syl_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","ইয়াকুবর আওলাদর উপরে কুনু যাদু-মন্ত্র চলতো নায়, ইছরাইল জাতির উপরে কুনু তাবিজ-কবজে কাম আইতো নায়। তারার বেয়াপারে অখন অউ বুলি কওয়া যায়, আল্লায় যেতা করছইন অতা চাইয়া দেখো। ");
INSERT INTO syl_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","অউ জাতি তো সিংহীর লাখান গুঞ্জরিয়া উঠিবো, আর সিংহর লাখান উঠিয়া আগ বাড়িবো। শিকারর লউ আর গোস্ত না খাওয়া পর্যন্ত তারা দম লইতা নায়।” ");
INSERT INTO syl_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","ইখান হুনিয়া বাদশা বালাকে কইলা, “বন্দ করউক্কা, আপনে তারারে দোয়াও দিবা না, লান্নতও দিবা না।” ");
INSERT INTO syl_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","বালাম পীরে জুয়াপ দিলা, “আমি তো আপনারে আগেউ কইছি, মাবুদে আমারে যেলা কইবা, আমার অলাউ করা লাগবো।” ");
INSERT INTO syl_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","বাদে বালাক বাদশায় বালাম পীররে কইলা, “আউক্কা, আমি আপনারে আরক জাগাত লইয়া যাইমু। হনো গেলে অইতো পারে আল্লায় খুশি অইয়া আমার পক্ষ লইবা, আর আপনারেদি হতার উপরে লান্নত দিতে দিবা।” ");
INSERT INTO syl_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","অখান কইয়া বাদশায় তানরে লইয়া পিয়োর নামর পাহাড়র উপরে গেলা, অউ জাগা থাকি মরুভুমি দেখা যায়। ");
INSERT INTO syl_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","অউ সময় বালাম পীরে কইলা, “অনো আমার লাগি সাতখান কুরবানি খানা বানাইয়া, সাতগু বিছাল আর সাতগু মেড়া কুরবানির বেবস্থা করউক্কা।” ");
INSERT INTO syl_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","পীর ছাবর কথামতো বাদশায় অলাউ করলা। তাইন পরতেক কুরবানি খানার উপরে এগু করি বিছাল আর এগু করি মেড়া কুরবানি দিলা। ");
INSERT INTO syl_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","বালাম পীরে যেবলা বুজলা, বনি ইছরাইলরে দোয়া দেওয়াউ অইলো মাবুদর ইচ্ছা, বুজিয়া তাইন আগর লাখান আর ইস্তেখারা-আজিরাতর চেষ্টা করলা না। বরং তান নিজর মুখ মরুভুমির বায় ফিরাইল্লা। ");
INSERT INTO syl_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","ফিরাইয়া দেখলা, বনি ইছরাইলর নানান খান্দানর তাম্বু এক এক করি টাংগানি অইছে। অউ সময় তান উপরে আল্লার রুহ লামিয়া আইলা, ");
INSERT INTO syl_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","তাইন আল্লার দেওয়া অউ ওহী কইলা, “বাউরর পুত বালামে কইরা, চউখ যার খুলা আছে এইন অউ বুলি কইরা। ");
INSERT INTO syl_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","যে জনে আল্লার কালাম হুনরা, সর্ব-শক্তিমানর দিদার পাইরা, যেইন সইজদাত পড়িয়া বাতুনি খবর দেখইন, এইন অখান কইরা। ");
INSERT INTO syl_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","ও ইয়াকুব বংশ, তুমার তাম্বু অকল খুব চকচকা! ও বনি ইছরাইল, তুমার রওয়ার জাগা কত ভালা! ");
INSERT INTO syl_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","ইতা তো দেখার মত বড় খেজুর বাগানর লাখান, গাংগর পারর হাজাইল-পাড়াইল বনর লাখান, মাবুদর লাগাইল আগরর গাছর লাখান তরতাজা, পানির ধারর দেবদারু গাছর লাখান সুন্দর। ");
INSERT INTO syl_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","তারার ভরা কলসি থাকি পানি উথলিয়া পড়বো, বিচি আর চেরায় বউত পানি পাইবো। তারার বাদশা অইবা অগাগ বাদশা থাকিও হিম্মতি, তারার দেশ অইবো নামকরা ইজ্জতি। ");
INSERT INTO syl_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","আল্লায় মিসর থাকি তারারে বার করি আনছইন, তাইন অইলা তারার পক্ষে বলআলা জংলি বয়রা, তারার লগে যত জাতিয়ে লাগবা, ইতারে তারা গিলিয়া খাইলিবা, তারার আড্ডি-গুড্ডিরে গুড়া গুড়া করবা, তীর-ধনুকদি তারারে গাথিবা। ");
INSERT INTO syl_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","সিংহর লাখান তারা খাপ ধরি হুতিবো, তারারে লাড়ানির সাওস অইবো কুন বেটার? তুমরারে যেরা দোয়া দিবা, এরার উপরে দোয়া লামউক; তুমরারে যেতায় লান্নত দিবা, ইতার উপরে লান্নত পড়উক।” ");
INSERT INTO syl_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","ইতা হুনিয়া বাদশা বালাকে বালাম পীরর উপরে গুছায় আগুইন অইগেলা। তান নিজর আতর পিঠিত তাবড়াই তাবড়াই কিড়িমিড়ি খাইয়া কইলা, “আমি আপনারে আনাইলাম আমার দুশমনরে লান্নত দিবার লাগি, আর আপনে তারারে অউ লাগাইয়া তিন-তিনবার দোয়া দিলা। ");
INSERT INTO syl_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","আপনে আমার ছামন থাকি হরউক্কা, নিজর জাগাত যাউক্কা। আমি আপনারে বউত পুরুস্কার দিমু কইছলাম, অইলে মাবুদে দিলা না।” ");
INSERT INTO syl_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","তেউ বালাম পীরে বাদশা বালাকরে কইলা, “আপনার পাঠাইল মানষরে আমি আগেউ কইছি না নি, ");
INSERT INTO syl_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","বাদশায় যুদি সোনা-রুপায় ভরা তান আস্তা রাজবাড়ি খানউ আমারে দিলাইন, তেবউ আমি আমার নিজর ইচ্ছায় ভালা-বুরা কুন্তা করতাম পারতাম নায়, আমি মাবুদর বিরুদ্ধে যাইতাম নায়। মাবুদে আমারে যেলা হুকুম দিবা, আমি খালি অলাউ কইমু। ");
INSERT INTO syl_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","তে আমি অখন আমার মানষর গেছে ফিরত যাইরামগি, অইলে অউ জাতিয়ে ভবিষ্যতে আপনার জাতির লগে কিতা কিতা করবা, আপনার হুশিয়ারির লাগি ইতা আগাম জানাই দিয়ার।” ");
INSERT INTO syl_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","বালাম পীরে আল্লার দেওয়া অউ আরক ওহী কইলা, “বাউরর পুত বালামে কইরা, চউখ যার খুলা আছে এইন অউ বুলি কইরা, ");
INSERT INTO syl_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","যে জনে আল্লার কালাম হুনরা, যেইনর গেছে আল্লাতালার আখল-হেকমত আছে, যেইন সর্ব-শক্তিমানর দিদার পাইরা, যেইন সইজদাত পড়িয়া বাতুনি খবর দেখইন, এইন অখান কইরা। ");
INSERT INTO syl_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","আমি তো হউ জনরে দেখিয়ার, অখন ছামনে না থাকলেও দেখিয়ার। তাইন আমার কাছাত না অইলেও, আমার চউখ গিয়া তান উপরে পড়ছে। ইয়াকুবর বংশত আইবা আছমানর এক তেরা, বনি ইছরাইলর মাজেউ এক রাজ-লাঠি জন্মিবা। এইন মোয়াব জাতির মাথা ফাটাইয়া দুই টুকরা করবা, শিস নবীর আওলাদর কল্লা চুরমার করবা। ");
INSERT INTO syl_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ইদোম দেশরে এনর দখলো আনবা, তান দুশমনর অউ সেয়ীর পাহাড়রে কবজা করবা, আর বনি ইছরাইল জাতিয়ে পয়লোয়ানি করবা। ");
INSERT INTO syl_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","ইয়াকুবর বংশর একজনে রাজ-গদি চালাইবা, ঈর টাউনো যারা জিন্দা রইবা এইন তারারেও বিনাশ করিলিবা।” ");
INSERT INTO syl_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","অখনাইন কওয়ার বাদে বালাম পীরে চউখ মেলিয়া আমালেকী অকলরে দেখলা। দেখিয়া আল্লার অউ ওহী কইলা, “আমালেক তো হকল জাতির মাজে আছিল পরধান, অইলে তারার শেষ দশা অইবো সর্বনাশ।” ");
INSERT INTO syl_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","বাদে তাইন কেনী অকলরে দেখলা, দেখিয়া আল্লার অউ ওহী কইলা, “তুমরার বসত খানা খুব মজবুত, তুমরা তো পাথরর পাহাড়ো বাসা বানাইছো, ");
INSERT INTO syl_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","অইলে আগেদি তুমরার বিনাশ ঘটিবো, তুমরারে বান্দিয়া আশিরিয়া দেশো নেওয়া অইবো।” ");
INSERT INTO syl_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","বাদে বালাম পীরে আল্লার দেওয়া অউ শেষ ওহী কইলা, “হায়রে হায়! আল্লায় যেবলা অতা ঘটাইবা, অউ সময় কেউ আর জিন্দা রইবো নি? ");
INSERT INTO syl_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","সাইপ্রাস দ্বীপর জাজ অকল আইবো, আইয়া আশিরিয়ারে দুর্দশা দিবো, আবেরর মানষরেও দমাইবো, অইলে অউ দ্বীপ নিজেও বাদে বিনাশ অইযিবো।” ");
INSERT INTO syl_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","অখান কইয়া হারি বালাম পীর উঠিয়া নিজর ঘরো গেলাগি, বালাক বাদশাও তান পথে রওয়ানা দিলা। ");
INSERT INTO syl_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","বনি ইছরাইল মোয়াব দেশর শিটীম এলাকাত বসত করলা, তারা অনো রইয়া রইয়া মোয়াবী বেটিন্তর লগে জিনা করাত লাগলা। ");
INSERT INTO syl_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","হনর বেটিন্তে তারার দেব-দেবীর নামে বলি দিবার অনুষ্টানো বনি ইছরাইলরে দাওত দিলা, আর এরা গিয়া অতা বেটিন্তর লগে খানা-দানা খাইয়া হউ দেব-দেবীর পুজা করলা। ");
INSERT INTO syl_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","অউ নমুনায় তারা হনর পিয়োর পাহাড়র বাআল দেবতার পুজা-ভক্তি দেওয়াত লাগি গেলা। এরদায় বনি ইছরাইলর উপরে মাবুদর গজবর আগুইন জলিয়া উঠলো। ");
INSERT INTO syl_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","বাদে মাবুদে মুছারে কইলা, “তুমি সমাজর দুষি নেতা অকলরে ধরিয়া জানে মারিলাও, আর অতার লাশ রইদর মাজে আনিয়া লটকাই থও। তেউ বনি ইছরাইলর উপরে থাকি আমার হউ লান্নতি গজব হরবো।” ");
INSERT INTO syl_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","অখান হুনিয়া মুছায় বনি ইছরাইলর হাকিম-সালিশ অকলরে কইলা, “তুমরার জিম্মায় থাকা যত মানষে পিয়োর পাহাড়র বাআল দেবতার পুজাত শরিক অইছে, অতা হক্কলটিরে তুমরা জানে মারিলাও।” ");
INSERT INTO syl_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","এরমাজে অলা অইলো, মুছা নবী আর বনি ইছরাইলে মিলিয়া যেবলা আল্লার ঘরর দুয়ারর গেছে কান্দা-কাটি কররা, অউ সময় তারার ছামনেদি বনি ইছরাইলর এক বেটায় মাদিয়ানী এক বেটিরে লগে লইয়া কেম্পর ভিতরে হামাইলো। ");
INSERT INTO syl_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","ইতা দেখিয়া ইমাম হারুনর নাতি পীনহস বিন আলি-আজর মজলিছ থাকি উঠিয়া একখান ছুলফি আতো লইলা। ");
INSERT INTO syl_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","লইয়া তারার খরে খরে গিয়া বনি ইছরাইলর হউ বেটার তাম্বুত হামাইয়া তার আর হউ বেটির পেটেদি গাথিল্লা। তেউ বনি ইছরাইলর উপর থাকি আল্লার গজব হরিগেলো। ");
INSERT INTO syl_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","অইলে অউ গজবর মাজে চব্বিশ আজার মানুষ মরিগেছিল। ");
INSERT INTO syl_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","অউ সময় মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“ইমাম হারুনর নাতি পীনহস বিন আলি-আজর বনি ইছরাইলর উপরে থাকি আমার গজব হরাইছে। বনি ইছরাইলর মাজে আমার পাওনা ইজ্জত আদায় করার বেয়াপারে হে তো আমার জালায়উ জলের। এরলাগি আমার পাওনা ইজ্জত আদায় করার লাগি মনর জালা থাকলেও আমি তারারে আর মারলাম না। ");
INSERT INTO syl_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","তে অখন তুমি তারে কও, আমি তার লাগি একটা খাছ শান্তি-চুক্তি বওয়াল করছি। ");
INSERT INTO syl_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","হে তার আল্লার পাওনা ইজ্জতর বেয়াপারে খিয়ালি অইয়া নিজর ইচ্ছায় বনি ইছরাইলর গুনার কফরা আদায় করায়, আমিও তার লাগি অউ শান্তি-চুক্তি বওয়াল করছি। এরলাগি ইমামতির পদ হে আর তার আওলাদর মাজে চিরকাল জারি রইবো।” ");
INSERT INTO syl_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","মাদিয়ানী হউ বেটির লগে বনি ইছরাইলর যে বেটারে মারা অইছিল, হে অইলো ছালুর পুয়া জিমরি, হে তো শিমিয়ন খান্দানর এক গুষ্টির নেতা। ");
INSERT INTO syl_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","আর যে মাদিয়ানী বেটিরে মারা অইছিল, তাইর নাম কছবি, তাই আছিল মাদিয়ান দেশর শোর নামর এক নেতার পুড়ি, অউ শোরও অইলা এক গুষ্টির নেতা। ");
INSERT INTO syl_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","এরবাদে মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“মাদিয়ানী অকলরে তুমরার দুশমন মনো করিও, ইতারে জানে মারিলিও। ");
INSERT INTO syl_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","কারন পিয়োরর দেবতার পুজা আর কছবির বেয়াপারে ফান্দ পাতাইয়া তুমরারে ভুল পথে নেওয়ায় তারা তুমরার দুশমন বনছে। আর তুমি তো জানো, অউ কছবি আছিল তারার কুটুম, তাই তো মাদিয়ানী এক সর্দারর পুড়ি। পিয়োরর বাআল দেবতারে পুজা করায় তুমরার উপরে যেবলা লান্নতি গজব লামছিল, অউ সময় তাইরে জানে মারা অইছিল।” ");
INSERT INTO syl_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","লান্নতি অউ গজব থামি যাওয়ার বাদে মাবুদে মুছা আর ইমাম হারুনর পুয়া আলি-আজররে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“বনি ইছরাইলর মাজে যেরার বয়স বিশ বছর বা এর বেশি, মানি যুদ্ধ করার যোইগ্য যেরা অইগেছে, এরারে যারযির গুষ্টি মাফিক গনো।” ");
INSERT INTO syl_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","এরলাগি যিরিহো টাউনর উল্টাবায় জর্দান গাংগর পারো মোয়াব দেশর যে তল জাগা আছে, হনো মুছা নবীয়ে আর ইমাম আলি-আজরে নেতা অকলরে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“মাবুদে মুছা নবীরে যেলা হুকুম করছইন, অউলা তুমরা বিশ বছর বা এর বেশি বয়সি হকল বেটাইন্তরে গনো।” তেউ মিসর দেশ থাকি বনি ইছরাইলর যত বেটাইন বার অইয়া আইছলা, গনার সময় এরার বংশধরর নাম লেখা অইলো। এরা অইলা: ");
INSERT INTO syl_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","ইয়াকুব উরফে ইছরাইলর বড় পুয়া রুবেনর চাইরো পুয়ার বংশধর: রুবেনর বড় পুয়া হনোক থাকি হনোকী বংশ, ফালু থাকি ফালুয়ী বংশ, ");
INSERT INTO syl_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","হাছির থাকি হাছিরী বংশ, আর কর্মি থাকি কর্মিয়া বংশ। ");
INSERT INTO syl_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","এরা হকলউ রুবেন খান্দানর নানান বংশ। এরার মাজ থাকি গনিয়া তেতাল্লিশ আজার সাতশো তিশ জনরে পাওয়া গেলো। ");
INSERT INTO syl_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","ফালুর পুয়ার নাম ইলিয়াব, ");
INSERT INTO syl_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ইলিয়াবর পুয়াইন অইলা নমুয়েল, দাথন আর আবিরাম। দাথন আর আবিরাম বনি ইছরাইলর দুইজন নেতা আছলা, তারা মুছা আর হারুনর বিপক্ষে লাগলা। আর কুরাহর দল যেবলা মাবুদর বিরুদ্ধে আছিল, অউ সময় এরাও কুরাহর দলো আছলা। ");
INSERT INTO syl_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","কুরাহর লগে অউ দুইজনরেও মাটিয়ে আ করি গিলিলিছিল আর তার দলর আড়াইশো জন আগুইনে জলিয়া মরছিল। ইতা বনি ইছরাইলর লাগি হুশিয়ারির নিশানা অইয়া রইলো। ");
INSERT INTO syl_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","অইলে কুরাহর পুয়াইন হি সময় মরছইন না, তারার বংশ জারি রইছে। ");
INSERT INTO syl_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","ইয়াকুবর পুয়া শিমিয়নর বংশধর অইলা, নমুয়েল থাকি নমুয়েলী বংশ, যামীন থাকি যামীনী বংশ, যাখীন থাকি যাখীনী বংশ, ");
INSERT INTO syl_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","জারাহ থাকি জারাহী বংশ আর শৌল থাকি শৌলী বংশ। ");
INSERT INTO syl_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","ইতা শিমিয়ন খান্দানর নানান বংশ। এরার মাজ থাকি গনিয়া বাইশ আজার দুইশো জন পাওয়া গেলো। ");
INSERT INTO syl_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","ইয়াকুবর পুয়া ছাদুর বংশধর অইলা, ছিফন থাকি ছিফনী বংশ, হগি থাকি হগিয়া বংশ, শূনি থাকি শূনিয়া বংশ, ");
INSERT INTO syl_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ওজনি থাকি ওজনিয়া বংশ, এইরি থাকি এইরিয়া বংশ, ");
INSERT INTO syl_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","অরোদ থাকি অরোদী বংশ, আর অরেলি থাকি অরেলিয়া বংশ। ");
INSERT INTO syl_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","এরা অইলা ছাদু খান্দানর নানান বংশ। এরার মাজে গনা মানুষ অইলা চাল্লিশ আজার পাচশো জন। ");
INSERT INTO syl_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","ইয়াকুবর পুয়া এহুদার দুই পুয়ার নাম আছিল এইর আর ওনন, কেনান দেশো থাকার কালো এরা মারা গেছিল। ");
INSERT INTO syl_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","অইলে এহুদার আরো পুয়াইন আছলা, এরার বংশধর অইলা, শেলা থাকি শেলায়ী বংশ, ফিরোজ থাকি ফিরোজী, জারাহ থাকি জারাহী বংশ। ");
INSERT INTO syl_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","ফিরোজর বংশধর অইলা হাছির থাকি হাছিরী বংশ আর হামুল থাকি হামুলী বংশ। ");
INSERT INTO syl_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","এরা হকলউ এহুদা খান্দানর নানান বংশ। এরার মাজ থাকি গনিয়া ছিয়ত্তইর আজার পাচশো জনরে পাওয়া গেল। ");
INSERT INTO syl_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","ইয়াকুবর পুয়া ইছাখরর বংশধর অইলা, তোলা থাকি তোলায়ী বংশ, ফওয়া থাকি ফওয়াই বংশ, ");
INSERT INTO syl_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","যাশুব থাকি যাশুবী বংশ আর শিমরন থাকি শিমরনী বংশ। ");
INSERT INTO syl_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","এরা হকল ইছাখর খান্দানর নানান বংশ। এরার মাজ থাকি গনিয়া চৌষট্টি আজার তিনশো জনরে পাওয়া গেল। ");
INSERT INTO syl_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","ইয়াকুবর পুয়া সবুলনর বংশধর অইলা ছেরেদ থাকি ছেরেদী বংশ, এলন থাকি এলনী বংশ আর যহলেল থাকি যহলেলী বংশ। ");
INSERT INTO syl_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","এরা হকল সবুলন খান্দানর নানান বংশ। এরার মাজ থাকি ষাইট আজার পাচশো জনরে পাওয়া গেলো। ");
INSERT INTO syl_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","ইয়াকুবর পুয়া ইউছুফর পুয়াইন অইলা মানশা আর আফরাইম। ");
INSERT INTO syl_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","এরার মাজে, মানশার বংশধর অইলা, মাখীর থাকি মাখীরী বংশ, আর মাখীরর পুয়া গিলিয়দ থাকি গিলিয়দী বংশ। ");
INSERT INTO syl_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","গিলিয়দর বংশধর অইলা ইয়াজির থাকি ইয়াজিরী বংশ, হেলক থাকি হেলকী বংশ, ");
INSERT INTO syl_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","অছরিয়েল থাকি অছরিয়েলী বংশ, শেখম থাকি শেখমী বংশ, ");
INSERT INTO syl_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","শিমিদা থাকি শিমিদায়ী বংশ আর হেফর থাকি হেফরী বংশ। ");
INSERT INTO syl_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","হেফরর পুয়া জলাপখাদ, তার কুনু পুয়াইন আছলা না, খালি পুড়িন আছলা। পুড়িন্তর নাম অইলো, মহলা, নোয়া, হগলা, মিলকা আর তিরজা। ");
INSERT INTO syl_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","এরা হকলউ মানশা খান্দানর নানান বংশ। এরার মাজ থাকি গনিয়া বায়ান্ন আজার সাতশো জনরে পাওয়া গেল। ");
INSERT INTO syl_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","ইয়াকুবর পুয়া আফরাইমর বংশধর অইলা, শুথলহ থাকি শুথলহী, বেখর থাকি বেখরী আর তহন থাকি তহনী বংশ। ");
INSERT INTO syl_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","শুথলহর বংশ, এরন থাকি এরনী বংশ। ");
INSERT INTO syl_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","এরা হকল আফরাইম খান্দানর নানান বংশ। এরার মাজ থাকি গনিয়া বত্তিশ আজার পাচশো জনরে পাওয়া গেল। খান্দান হিসাবে এরা হকলউ ইউছুফর বংশধর। ");
INSERT INTO syl_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","ইয়াকুবর পুয়া বিন-ইয়ামিনর বংশধর অইলা, বেলা থাকি বেলায়ী বংশ, অশবেল থাকি অশবেলী বংশ, আহিরাম থাকি আহিরামী বংশ, ");
INSERT INTO syl_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","শুফম থাকি শুফমী বংশ, আর হুফম থাকি হুফমী বংশ। ");
INSERT INTO syl_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","বেলার পুয়াইন অর্দ আর নামানর মাজদি বেলার বংশধর অইলা, অর্দ থাকি অর্দী বংশ আর নামান থাকি নামানী বংশ। ");
INSERT INTO syl_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","এরা বিন-ইয়ামিন খান্দানর নানান বংশ। এরার মাজ থাকি পয়তাল্লিশ আজার ছয়শো জনরে পাওয়া গেল। ");
INSERT INTO syl_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","ইয়াকুবর পুয়া দানর বংশধর অইলা, শুহম থাকি শুহমী বংশ। এরাউ আছলা দান খান্দানর মানুষ। ");
INSERT INTO syl_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","এরার মাজ থাকি গনিয়া চৌষট্টি আজার চাইরশো জনরে পাওয়া গেল। ");
INSERT INTO syl_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","ইয়াকুবর পুয়া আশিরর বংশধর অইলা, ইমনা থাকি ইমনায়ী বংশ, যিছবি থাকি যিছবিয়া বংশ আর বরিয়া থাকি বরিয়ায়ী বংশ। ");
INSERT INTO syl_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","বরিয়ার বংশধর অইলা হেবর থাকি হেবরী বংশ, আর মল্কিয়েল থাকি মল্কিয়েলী বংশ। ");
INSERT INTO syl_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","আশিরর পুড়ির নাম আছিল ছেরা। ");
INSERT INTO syl_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","এরা হকলউ আশির খান্দানর নানান বংশ। এরার মাজ থাকি গনিয়া তেপ্পান্ন আজার চাইরশো জনরে পাওয়া গেল। ");
INSERT INTO syl_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","ইয়াকুবর পুয়া নপ্তালির বংশধর অইলা, যহসিয়েল থাকি যহসিয়েলী বংশ, গুনি থাকি গুনিয়া বংশ, ");
INSERT INTO syl_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","ইজের থাকি ইজেরী বংশ, আর শিল্লেম থাকি শিল্লেমী বংশ। ");
INSERT INTO syl_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","এরা হকলউ নপ্তালি খান্দানর নানান বংশ। এরার মাজ থাকি গনিয়া পয়তাল্লিশ আজার চাইরশো জনরে পাওয়া গেল। ");
INSERT INTO syl_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","তে গনার বাদে বনি ইছরাইলর মাজে যুদ্ধত যাওয়ার জুকা বেটাইন্তর পরিমান অইল, মোট ছয় লাখ এক আজার সাতশো তিশ জন। ");
INSERT INTO syl_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“গনা অউ মানুষ মাফিক আস্তা দেশর জমিন বাটিয়া দিতে অইবো, যাতে হকলে যারযির বাট পায়। ");
INSERT INTO syl_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","যে খান্দানর মানুষ বেশি অউ খান্দানরে বেশি আর যে খান্দানর মানুষ কম, অউ খান্দানরে কম জাগা দিবায়। পরতেক খান্দানর মানষে তার মানুষ হিসাবে জাগা-জমিন পাইবো। ");
INSERT INTO syl_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","আর কুন খান্দানে কুন জাগাত জমিন পাইবো, ইতা লটারি মারিয়া ঠিক করা অইবো। পরতেক বংশর পাওনা অংশ তার খান্দানর নামে দেওয়া এলাকার মাজেউ থাকবো। ");
INSERT INTO syl_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","খান্দানর মানুষ কম বা বেশি যেটাউ অউক, লটারি মারিয়া জাগা ঠিক করা অইবো।” ");
INSERT INTO syl_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","হকল হেশে লেবি খান্দানর বংশধর গনা অইলো। এরা অইলা, জারছুন থাকি জারছুনী গুষ্টি, কাহাত থাকি কাহাতী গুষ্টি আর মারারি থাকি মারারিয়া গুষ্টি। ");
INSERT INTO syl_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","লেবি খান্দানর কিছু নামকরা পরিবার আছিল, এরার মুল বাফর নাম অইলো লিবনি, হেবরন, মহলি, মুশি আর কুরাহ। কাহাতর এক পুয়ার নাম আছিল ইমরান। ");
INSERT INTO syl_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","ইমরানর বউর নাম ইউখাবেজ, মিসর দেশো থাকতে লেবি খান্দানর মাজে এন জনম অইছিল। এন পেট থাকি ইমরানর পুয়াইন হারুন আর মুছা আর তারার বইন মরিয়মর জনম অইছিল। ");
INSERT INTO syl_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","হারুনর পুয়াইন অইলা নাদাব, আবিহু, আলি-আজর আর ইছামার। ");
INSERT INTO syl_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","অইলে মাবুদর হুকুম ভাংগিয়া দুছরা আগুইন দিয়া এবাদত করাত গিয়া নাদাব আর আবিহু অউ দুই জনর মরন অইছিল। ");
INSERT INTO syl_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","একমাস বা এর বেশি বয়সর লেবি খান্দানর বেটাইন্তর পরিমান আছিল তেইশ আজার। বনি ইছরাইলর ভিতরে এরারে কুনু জাগার মালিকানা দেওয়া অইছে না গতিকে বনি ইছরাইলর অইন্যান্য খান্দানর লগে এরারে একলগে গনাও অইছে না। ");
INSERT INTO syl_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","যিরিহো টাউনর উল্টাবায় জর্দান গাংগর ধারো মোয়াবর তল জাগাত দুছরা বার মানুষ গনার সময় মুছা নবী আর ইমাম আলি-আজরে বনি ইছরাইলরে গনলা। ");
INSERT INTO syl_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","অইলে পয়লা বার সিনাই মরুভুমিত মুছা আর ইমাম হারুনে বনি ইছরাইলর যারারে গনিছলা, অউ দুছরা বার গনার সময় এরার মাজর একজনও জিন্দা রইছইন না। ");
INSERT INTO syl_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","আসলে অতা বনি ইছরাইলর বেয়াপারে মাবুদে আগেউ কইছলা, তারা নিচ্চয় অউ মরুভুমিত মারা যাইবা। আর হাছাউ খালি যিফুন্নির পুয়া কালুত আর নূনর পুয়া ইউছা ছাড়া তারার মাজর দুছরা কেউ জিন্দা রইছিল না। ");
INSERT INTO syl_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","ইউছুফর পুয়া মানশার খান্দানর জলাপখাদর পুড়িন্তর ছিলছিলা অইলো, মানশার পুয়া মাখীর, মাখীরর পুয়া গিলিয়দ, গিলিয়দর পুয়া হেফর আর হেফরর পুয়ার নাম জলাপখাদ। জলাপখাদর পুড়িন অইলা মহলা, নোয়া, হগলা, মিলকা আর তিরজা। ");
INSERT INTO syl_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","অউ পুড়িন আইয়া মিলন-তাম্বুর দুয়ারর ছামনে উবাইয়া মুছা নবী, ইমাম আলি-আজর, মুরব্বি নেতা আর হকল বনি ইছরাইলরে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“আমরার বাবা তো মরুভুমিত মারা গেছইন। আর কুরাহর দলর যেতা মানষে মাবুদর বিরুদ্ধে নাফরমানি করছলা, তাইন তো ইতার লগে আছলা না। তাইন খালি তান নিজর গুনার দায় মারা গেছইন। আর আমরার কুনু ভাই জন্মিছইন না, ");
INSERT INTO syl_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","তে ভাই না থাকায় অখন আমরার বাফর নাম কিতা ই বংশ থাকি মিটিযিতো নি? তান শরিকানর লগে আমরারেও জাগা-জমিনর বাট দেউক্কা।” ");
INSERT INTO syl_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","তেউ মুছা নবীয়ে তারার বেয়াপারে মাবুদর দরবারো আরজ করলা। ");
INSERT INTO syl_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","মাবুদে তানরে জুয়াপ দিলা, ");
INSERT INTO syl_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“জলাপখাদর পুড়িন্তে ঠিক কথাউ কইছে। তারার বাফর শরিকানর লগে তারারেও জমি-জমার বাট দিতে অইবো। তারা যাতে তারার বাফাইতি জমিন পাইন, ইখান তুমি খিয়াল রাখিও। ");
INSERT INTO syl_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","আর তুমি বনি ইছরাইলরে কও, মরার কালো যুদি কুনু মানষে পুয়াইন না থইয়া মরিযায়, তে তার জমি-জমার বাট তার পুড়িন্তে পাইবা। ");
INSERT INTO syl_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","তার কুনু পুড়িন না থাকলে তার ভাইয়াইন্তে ই সম্পত্তি পাইবা। ");
INSERT INTO syl_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","তার যুদি কুনু ভাই না থাকে, তে ইতা তার চাচাইন্তে পাইবা। ");
INSERT INTO syl_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","আর তার যুদি কুনু চাচাও না থাকইন, তে তার বংশর হকল থাকি আপন জনে ই সম্পত্তি পাইবা, এইন ইতার মালিক অইবা। মুছা নবীরে বাতাইল মাবুদর অউ হুকুম অইলো, বনি ইছরাইলর লাগি জমি-জমার আইনর এক ধারা।” ");
INSERT INTO syl_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","এরবাদে মাবুদে মুছারে কইলা, “তুমি আবারীম পাহাড়র অউ উচা টিল্লার উপরে উঠো, উঠিয়া আমি বনি ইছরাইলরে যে দেশ দিছি, অখান দেখিলাও। ");
INSERT INTO syl_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","আর হুনো, তুমার ভাই হারুন যেলা তার বাফ-দাদার লাখান কয়বরো হুতি রইছে, অউ দেশ দেখার বাদে তুমিও অলা তুমার বাফ-দাদার গেছে যাইবায়গি। ");
INSERT INTO syl_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","মনো আছে নি, জীন মরুভুমির কাদেশ এলাকার মেরীবা নামর জাগার হউ পানির কথা? মরুভুমিত বনি ইছরাইলে যেবলা পানির লাগি আমার বিরুধিতা করছিল, তারার ছামনে তুমরাও আমারে পাক-পবিত্র কইয়া না মানিয়া আমার হুকুমর উল্টা গেছলায়।” ");
INSERT INTO syl_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","অখান হুনিয়া মুছায় আরজ করলা, ");
INSERT INTO syl_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“ও মাবুদ, যেইন হকল মানষর জিন্দেগি দান করইন, হউ আল্লা মাবুদে বনি ইছরাইলর উপরে অলা একজন মানষরে বওয়াল করউক্কা, ");
INSERT INTO syl_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","যে নেতায় হকল মানষরে ঘরে-বারে, মাঠো-ময়দানো হকল বেয়াপারে চালাইবা। তেউ মাবুদর বন্দা অকল আ-রাখালি গরু-ছাগলর লাখান অইতা নায়।” ");
INSERT INTO syl_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","তেউ মাবুদে জুয়াপ দিলা, “নূনর পুত ইউছার ভিতরে তো আল্লাই রুহ আছইন। তুমি তারে আনিয়া তার উপরে তুমার আত থইয়া খেলাফতি বখশিয়া দেও। ");
INSERT INTO syl_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","তুমি ইমাম আলি-আজর আর হকল বনি ইছরাইলর ছামনে তারে আজির করিয়া, তারার ছামনেউ তারে দায়িত্ব সমজাই দেও। ");
INSERT INTO syl_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","তুমারে যে খেমতা দেওয়া অইছে, অউ খেমতার কিছু বাট তারে দেও, তেউ হক্কল বনি ইছরাইল তার কথায় চলবা। ");
INSERT INTO syl_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","বাদে হে ইমাম আলি-আজরর গেছে যাইবো, গেলে আলি-আজরে আল্লার পবিত্র উরিম আর তুম্মিম পাথরদি লটারি মারিয়া মাবুদর মর্জি জানতা পারবা। অলা ইউছা আর তামাম বনি ইছরাইলে চলা-ফিরা করবা।” ");
INSERT INTO syl_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","মুছা নবীয়ে মাবুদর হুকুম মাফিক কাম করলা। তাইন ইমাম আলি-আজর আর বনি ইছরাইলর ছামনে ইউছারে নিয়া আজির করলা। ");
INSERT INTO syl_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","আর মাবুদর হুকুম মাফিক তান উপরে আত থইয়া তানরে দায়িত্ব সমজাইলা। ");
INSERT INTO syl_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","মাবুদে মুছা নবীরে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“তুমি বনি ইছরাইলরে আমার অউ হুকুম জানাই দেও, আমারে খুশি করার নিয়তে ঘেরান আলা জালাইল কুরবানি আমার খানির লাগি সঠিক সময়ে আজির করতে অইবো। ");
INSERT INTO syl_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","তারারে এওখান কও, তুমরা মাবুদর নামে পরতিদিনর আগুনিত দেওয়া কুরবানি আদায় করার নিয়তে অউ পশু অকল আনিও, পরতিদিন এক বছর বয়সি দুগু নিখুত মেড়া-বাইচ্চা আনিও। ");
INSERT INTO syl_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","আনিয়া এগু বিয়ানে আর এগু হাইঞ্জা বালা কুরবানি দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","এরলগর পরতিদিনর ধান-গমর ছদগার লাগি দুই সের ময়দা আর এক সের জয়তুনর পিষা তেল আনবায়। ");
INSERT INTO syl_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","ইটা অইলো হউ পরতিদিনর জালাইল কুরবানি, যেতা তুর পাহাড়ো সাইবস্তো করা অইছিল। আর ইতা তো আমার নামে আগুনিত দেওয়া কুরবানি, এর ধুমার ঘেরানে আমি খুশি অই। ");
INSERT INTO syl_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","পরতেক মেড়ার লগে এক সের আংগুরর শরবত দিয়া শরবত-পানির ছদগা আদায় করিও। মাবুদর নামর কুরবানির অউ শরবত এবাদত খানার উঠানো ঢালি দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","মেড়ার আরক বাইচ্চারে হাইঞ্জা বালা কুরবানি দিবায়। এরলগে বিয়ানকুর লাখান ধান-গমর ছদগা আর শরবত-পানির ছদগা আদায় করবায়। ইতা অইলো আগুনিত দেওয়া কুরবানি, এর ধুমার ঘেরানে আমি মাবুদ খুশি অই। ");
INSERT INTO syl_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“পরতেক জুম্মাবারে এক বছর বয়সি দুগু মেড়া-বাইচ্চা কুরবানি দিবায়। এরলগে শরবত-পানির ছদগার ছামানা আর ধান-গমর ছদগার তেল মাখাইল চাইর সের ময়দাও দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","পরতিদিনর জালাইল পশু কুরবানি আর এর লগর শরবত-পানির ছদগা ছাড়াও পরতেক জুম্মাবারে অউ জালাইল কুরবানি আদায় করবায়। ");
INSERT INTO syl_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“পরতেক চান্দর পয়লা দিন মাবুদর নামে জালাইল কুরবানির লাগি দুগু বিছাল, এগু মেড়া আর এক বছর বয়সি সাতগু মেড়া-বাইচ্চা কুরবানি দিবায়, ই হকল পশু পুরা নিখুত অইতো। ");
INSERT INTO syl_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","অউ পরতেক বিছালর লগে ধান-গমর ছদগা হিসাবে তেল মাখাইল ছয় সের ময়দা দিবায়, আর মেড়ার লগে চাইর সের ময়দা দিও, ");
INSERT INTO syl_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","আর পরতেক মেড়া-বাইচ্চার লগে তেল মাখাইল দুই সের ময়দা দিও। ইতা অইলো আমার নামে আগুনিত দেওয়া কুরবানি, ইতার ধুমার ঘেরানে আমি মাবুদ খুশি অই। ");
INSERT INTO syl_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","শরবত-পানির ছদগার লাগি পরতেক বিছালর লগে দুই সের আংগুরর শরবত দিবায়। পরতেক মেড়ার লগে সোয়া সের আর পরতেক মেড়া-বাইচ্চার লগে এক সের শরবত দিও। ইতা অইলো মাসিক জালাইল কুরবানি, বছরর পরতেক চান্দো ইতা আদায় করবায়। ");
INSERT INTO syl_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","ইতার লগে গুনার কফরার নিয়তে আমার নামে এগু ছাগল কুরবানি দিও। তা-ও পরতেক দিনর জালাইল কুরবানি, আর এর লগর শরবত-পানির ছদগাও আদায় করিও। ");
INSERT INTO syl_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“পরতেক বছরর পয়লা চান্দর চৌদ্দ তারিখ মাবুদর নামে আজাদি ইদ আদায় করিও। ");
INSERT INTO syl_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","অউ চান্দর পনরো তারিখ থাকি সাত দিন ভরা আরক ইদ আদায় করিও, ইকটার নাম খামির ছাড়া রুটির ইদ। ");
INSERT INTO syl_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","এর পয়লা দিন পবিত্র মিলন-মাহফিল করিও, ই দিন দুনিয়াবি নিয়তে কুনু কাম-কাজ করা নাজাইজ। ");
INSERT INTO syl_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","অউ দিন আমার নামে দুগু বিছাল, এগু মেড়া আর এক বছর বয়সি সাতগু মেড়া-বাইচ্চাদি আগুনিত দেওয়া জালাইল কুরবানি আদায় করিও। কুরবানির পরতেক পশু নিখুত অইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","অউ পশুর লগর ধান-গমর ছদগা হিসাবে তেল মাখাইল ময়দা দিবায়, একোটা বিছালর লগে ছয় সের, মেড়া পাঠার লগে চাইর সের, ");
INSERT INTO syl_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","আর মেড়া-বাইচ্চার লগে দুই সের দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","ইতার লগে তুমরার গুনার কফরার লাগি এগু পাঠা ছাগলও কুরবানি দিও। ");
INSERT INTO syl_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","পরতেক দিনর বিয়ানকুর জালাইল কুরবানি তো দিবায়উ, এরলগে অউ কুরবানিও আদায় করবায়। ");
INSERT INTO syl_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","অউ লাখান পুরা হাপ্তার সাতোদিন আমারে খুশি করার ঘেরান আলা খানি হিসাবে পরতেক দিন অউ আগুনিত দেওয়া কুরবানি আদায় করবায়। পরতিদিনর জালাইল কুরবানি আর এর লগর শরবত-পানির ছদগার লগে অউ কুরবানিও আদায় করবায়। ");
INSERT INTO syl_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","হেশে সাত নম্বর দিনও তুমরা পবিত্র মিলন-মাহফিল করিও, অউ দিন দুনিয়াবি নিয়তে কুনু কাম-কাজ করা নাজাইজ। ");
INSERT INTO syl_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“পঞ্চাইশা ইদর দিন, মানি খেতর পয়লা দাওয়া ফসল দিয়া যেদিন তুমরা আমার নামে পবিত্র মিলন-মাহফিল করবায়, হি দিন কুনু দুনিয়াবি নিয়তে কাম করিও না। ");
INSERT INTO syl_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","অউ দিন তুমরা দুগু বিছাল, এগু মেড়া আর এক বছর বয়সি সাতগু মেড়া-বাইচ্চা দিয়া জালাইল কুরবানি আদায় করিও, অউ কুরবানির ধুমার ঘেরানে আমি মাবুদ খুশি অই। ");
INSERT INTO syl_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","আর অতার লগর ধান-গমর ছদগা হিসাবে একোটা বিছালর লগে তেল মাখাইল ছয় সের ময়দা, মেড়ার লগে চাইর সের, ");
INSERT INTO syl_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","আর মেড়া-বাইচ্চার লগে দুই সের দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","অতার লগে এগু পাঠা ছাগলও কুরবানি দিও তুমরার গুনার কফরার লাগি। ");
INSERT INTO syl_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","অউ হকল কুরবানি আর ইতার লগর শরবত-পানির ছদগার লগে পরতিদিনর জালাইল কুরবানি আর এর লগর ধান-গমর ছদগা আদায় করবায়। খিয়াল রাখিও, কুরবানির হকল পশু যানু পুরাপুর নিখুত অয়। ");
INSERT INTO syl_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","মাবুদে আরো কইরা, “পরতেক বছরর সাত নম্বর চান্দর পয়লা দিন অইলো, তুমরার শিংগা বাজানির ইদর দিন। অউ দিন তুমরা পবিত্র মিলন-মাহফিল করিও। ই দিন দুনিয়াবি নিয়তে কুনু কাম-কাজ করা নাজাইজ। ");
INSERT INTO syl_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","অউ দিন তুমরা আমারে খুশি করার ঘেরান আলা জালাইল কুরবানি হিসাবে, এগু বিছাল, এগু মেড়া আর সাতগু এক বছর বয়সি মেড়া-বাইচ্চারে কুরবানি দিও, হকল পশু যানু পুরাপুর নিখুত অয়। ");
INSERT INTO syl_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","আর অতার লগর ধান-গমর ছদগা হিসাবে তেল মাখাইল ময়দা দিও। বিছালর লগে ছয় সের, মেড়ার লগে চাইর সের, ");
INSERT INTO syl_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","আর পরতেক মেড়া-বাইচ্চার লগে দুই সের দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","ইতার লগে তুমরার গুনার কফরার লাগি এগু পাঠা ছাগলও কুরবানি দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","পরতেক চান্দর আর পরতি দিনর জালাইল কুরবানি, ইতার লগর ধান-গমর ছদগা আর শরবত-পানির ছদগা ছাড়াও অউ কুরবানি অকল আদায় করিও। ইতা তো আমার নামে আগুনিত দেওয়া কুরবানি, ইতার ধুমার ঘেরানে আমি মাবুদ খুশি অই। ");
INSERT INTO syl_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“আর অউ সাত নম্বর চান্দর দশ তারিখো একটা পবিত্র মিলন-মাহফিল করবায়। অউ দিন তুমরা পরতেকে নত অইয়া যারযির দিল সপিয়া দিবায়, ই দিন কেউ কুনুজাত কাম করিও না। ");
INSERT INTO syl_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","আমি মাবুদরে খুশি করার নিয়তে ঘেরান আলা জালাইল কুরবানি হিসাবে নিখুত এগু বিছাল, এগু মেড়া, আর সাতগু এক বছর বয়সি মেড়া-বাইচ্চারে কুরবানি দিও। ");
INSERT INTO syl_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","আর অতার লগর ধান-গমর ছদগা হিসাবে বিছালর লগে তেল মাখাইল ছয় সের ময়দা দিও, মেড়ার লগে চাইর সের, ");
INSERT INTO syl_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","আর পরতেক মেড়া-বাইচ্চার লগে দুই সের দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","হেশে গুনা মাফির কুরবানির লাগি এগু পাঠা ছাগলও দিবায়। ইদর অউ কুরবানি অকল ছাড়াও গুনার কফরার কুরবানি আর পরতি দিনর জালাইল কুরবানি, এর লগর ধান-গমর ছদগা আর শরবত-পানির ছদগাও দিও। ");
INSERT INTO syl_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“তুমরা ডেরা-ঘরর ইদর হাপ্তার পয়লা দিন মানি, সাত নম্বর চান্দর পনরো তারিখো, একটা পবিত্র মিলন-মাহফিল করবায়, অউ দিন তুমরা দুনিয়াবি নিয়তে কুনু কাম-কাজ করিও না। অউ সাত দিন মাবুদর নামে ইদর খুশি-বাসি করিও। ");
INSERT INTO syl_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","“ইদর পয়লা দিন পুরাপুর নিখুত তেরগু বিছাল, দুগু মেড়া আর চৌদ্দগু এক বছর বয়সি মেড়া-বাইচ্চা দিয়া জালাইল কুরবানি আদায় করিও। এর ধুমার ঘেরানে আমি মাবুদ খুশি অই। ");
INSERT INTO syl_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","অতার পরতেক বিছালর লগর ধান-গমর ছদগা হিসাবে তেল মাখাইল ছয় সের ময়দা, পরতেক মেড়ার লগে চাইর সের, ");
INSERT INTO syl_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","আর পরতেক মেড়া-বাইচ্চার লগে দুই সের দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","হেশে গুনা মাফির কুরবানির লাগি এগু পাঠা ছাগলও দিবায়। দিয়া পরতি দিনর জালাইল কুরবানি, এর লগর ধান-গমর ছদগা আর শরবত-পানির ছদগাও দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ইদর দুই নম্বর দিন পুরাপুর নিখুত বারোগু বিছাল, দুগু মেড়া আর চৌদ্দগু এক বছর বয়সি মেড়া-বাইচ্চা কুরবানি দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","অউ বিছাল, মেড়া আর মেড়া-বাইচ্চা হক্কলটির লগে ধান-গমর ছদগা, শরবত-পানির ছদগা, পশুর পরিমান মাফিক আদায় করিও। ");
INSERT INTO syl_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","হেশে গুনা মাফির কুরবানির লাগি এগু পাঠা ছাগলও দিবায়। দিয়া পরতি দিনর জালাইল কুরবানি, এর লগর ধান-গমর ছদগা আর শরবত-পানির ছদগাও দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ইদর তিন নম্বর দিনো পুরাপুর নিখুত এগারোগু বিছাল, দুগু মেড়া আর চৌদ্দগু এক বছর বয়সি মেড়া-বাইচ্চা কুরবানি দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","অউ বিছাল, মেড়া আর মেড়া-বাইচ্চা হক্কলটির লগে ধান-গমর ছদগা, শরবত-পানির ছদগা, পশুর পরিমান মাফিক আদায় করিও। ");
INSERT INTO syl_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","হেশে গুনা মাফির কুরবানির লাগি এগু পাঠা ছাগলও দিবায়। দিয়া পরতি দিনর জালাইল কুরবানি, এর লগর ধান-গমর ছদগা আর শরবত-পানির ছদগাও দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ইদর চাইর নম্বর দিন পুরাপুর নিখুত দশগু বিছাল, দুগু মেড়া আর চৌদ্দগু এক বছর বয়সি মেড়া-বাইচ্চা কুরবানি দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","অউ বিছাল, মেড়া আর মেড়া-বাইচ্চা হক্কলটির লগে ধান-গমর ছদগা, শরবত-পানির ছদগা, পশুর পরিমান মাফিক আদায় করিও। ");
INSERT INTO syl_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","হেশে গুনা মাফির কুরবানির লাগি এগু পাঠা ছাগলও দিবায়। দিয়া পরতি দিনর জালাইল কুরবানি, এর লগর ধান-গমর ছদগা আর শরবত-পানির ছদগাও দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ইদর পাচ নম্বর দিন নিখুত নয়গু বিছাল, দুগু মেড়া আর চৌদ্দগু এক বছর বয়সি মেড়া-বাইচ্চা কুরবানি দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","অউ বিছাল, মেড়া আর মেড়া-বাইচ্চা হক্কলটির লগে ধান-গমর ছদগা, শরবত-পানির ছদগা, পশুর পরিমান মাফিক আদায় করিও। ");
INSERT INTO syl_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","হেশে গুনা মাফির কুরবানির লাগি এগু পাঠা ছাগলও দিবায়। দিয়া পরতি দিনর জালাইল কুরবানি, এর লগর ধান-গমর ছদগা আর শরবত-পানির ছদগাও দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ইদর ছয় নম্বর দিন নিখুত আটগু বিছাল, দুগু মেড়া আর চৌদ্দগু এক বছর বয়সি মেড়া-বাইচ্চা কুরবানি দিও। ");
INSERT INTO syl_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","অউ বিছাল, মেড়া আর মেড়া-বাইচ্চা হক্কলটির লগে ধান-গমর ছদগা, শরবত-পানির ছদগা, পশুর পরিমান মাফিক আদায় করিও। ");
INSERT INTO syl_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","হেশে গুনা মাফির কুরবানির লাগি এগু পাঠা ছাগলও দিবায়। দিয়া পরতি দিনর জালাইল কুরবানি, এর লগর ধান-গমর ছদগা আর শরবত-পানির ছদগাও দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ইদর সাত নম্বর দিন পুরাপুর নিখুত সাতগু বিছাল, দুগু মেড়া আর চৌদ্দগু এক বছর বয়সি মেড়া-বাইচ্চা কুরবানি দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","অউ বিছাল, মেড়া আর মেড়া-বাইচ্চা হক্কলটির লগে ধান-গমর ছদগা, শরবত-পানির ছদগা, পশুর পরিমান মাফিক আদায় করিও। ");
INSERT INTO syl_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","হেশে গুনা মাফির কুরবানির লাগি এগু পাঠা ছাগলও দিবায়। দিয়া পরতি দিনর জালাইল কুরবানি, এর লগর ধান-গমর ছদগা আর শরবত-পানির ছদগাও দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ইদর আট নম্বর দিন মানি, আখেরি দিন বিদায়ি মাহফিল করিও, ই দিন তুমরা দুনিয়াবি নিয়তে কুনু কাম-কাজ করিও না। ");
INSERT INTO syl_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","আর মাবুদরে খুশি করার নিয়তে ঘেরান আলা আগুনিত দেওয়া কুরবানি হিসাবে একখান জালাইল কুরবানি দিবায়। এরলাগি নিখুত এগু বিছাল, এগু মেড়া আর সাতগু এক বছর বয়সি মেড়া-বাইচ্চা কুরবানি দিও। ");
INSERT INTO syl_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","অউ বিছাল, মেড়া আর মেড়া-বাইচ্চা হক্কলটির লগে ধান-গমর ছদগা, শরবত-পানির ছদগা, পশুর পরিমান মাফিক আদায় করিও। ");
INSERT INTO syl_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","হেশে গুনা মাফির কুরবানির লাগি এগু পাঠা ছাগলও দিবায়। দিয়া পরতি দিনর জালাইল কুরবানি, এর লগর ধান-গমর ছদগা আর শরবত-পানির ছদগাও দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“তে পরতেক ইদর কালো মাবুদর নামে তুমরার ইদ অকলর নিয়ম মাফিক কুরবানি আদায় করিও। ইতা ছাড়া, মান্নত পুরনর কুরবানি, যেকুনু নফল কুরবানির নিয়তে জালাইল কুরবানি, ধান-গমর ছদগা, শরবত-পানির ছদগা, আর ছালামতি কুরবানিও আদায় করিও।” ");
INSERT INTO syl_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","মাবুদে মুছা নবীরে যেতা হুকুম-আহকাম জানাইছলা, তাইন ইতা হক্কলতা বনি ইছরাইলরে জানাইলা। ");
INSERT INTO syl_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","বাদে মুছা নবীয়ে বনি ইছরাইলর হকল খান্দানর মুরব্বিরে কইলা, “মাবুদে হুকুম দিছইন, ");
INSERT INTO syl_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","কুনু বেটায় যুদি মাবুদর নামে কুন্তা মান্নত করে বা কছম খাইয়া কুনুতা করার ওয়াদায় বন্দি অয়, তে হে যানু তার ওয়াদা ভংগ না করে। হে যেতা কইছে, ইতা পুরন করা লাগবো। ");
INSERT INTO syl_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“কুনু আবিয়াতি পুড়িয়ে যুদি বাফর বাড়িত থাকার কালো মাবুদর নামে কুন্তা মান্নত করে বা কুনুতা করার ওয়াদায় বন্দি অয়, ");
INSERT INTO syl_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","আর বাফে ইতা হুনিয়াও পুড়িরে কুন্তা না কইন, তে ই মান্নত বা ওয়াদা তাই পুরন করা লাগবো। ");
INSERT INTO syl_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","অইলে ইখান হুনার লগে লগে বাফে যুদি পুড়িরে ইতা করতে নিষেধ করইন, তে ই মান্নত বা ওয়াদা বাতিল অইযিবো। বাফে নিষেধ করায় মাবুদেও ই মান্নত বা ওয়াদা ভাংগারে মাফ করি দিবা। ");
INSERT INTO syl_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“আর কুনু পুড়িয়ে যুদি চিন্তা-ভাবনা না করিয়া আখতা কুনু মান্নত বা ওয়াদা করিলায় আর বাদে তাইর বিয়া অইযায়, ");
INSERT INTO syl_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","বিয়ার বাদে জামাইয়ে ইখান হুনিয়া লগে লগে কুন্তা না কইন, তে ই মান্নত বা ওয়াদারে তাই পুরন করা লাগবো। ");
INSERT INTO syl_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","অইলে ইতা হুনার লগে লগে জামাইয়ে যুদি নিষেধ করইন, তে ই মান্নত বা ওয়াদার বান্দন থাকি তাই খালাছ পাইবো, মাবুদেও ইতা মাফ করি দিবা। ");
INSERT INTO syl_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“আর কুনু ড়াড়ি বেটি বা তালাক পাওয়া কুনু বেটিয়ে যুদি মান্নত করিয়া ওয়াদায় বন্দি অয়, তে ইতা পুরন করা লাগবোউ। ");
INSERT INTO syl_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“জামাইর ঘরর কুনু বউয়ে যুদি অলা মান্নত মানে বা কছম খাইয়া ওয়াদায় বন্দি অয়, ");
INSERT INTO syl_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","বাদে তাইর জামাইয়ে ইখান হুনিয়া কুন্তা না মাতইন, তাইরে নিষেধ না দেইন, তে তাই ইতা পুরন করা লাগবো। ");
INSERT INTO syl_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","অইলে জামাইয়ে হুনিয়া যুদি লগে লগে নিষেধ দেইন, তে ই মান্নত বা ওয়াদা বাতিল অইযিবো। তাইর জামাইয়ে নিষেধ করায়, মাবুদেও ইখান মাফ করি দিবা। ");
INSERT INTO syl_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","বউয়ে কছম খাইয়া ওয়াদা করলে বা কুনু মান্নত মানলে জামাইর এখতিয়ার আছে ইতা মানা বা বাতিল করার। ");
INSERT INTO syl_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","অইলে জামাইয়ে যুদি বেশি দিন ই বেয়াপারে কুন্তা না মাতিয়া নিরাই রইন, তে তার বউর মান্নত বা ওয়াদার বান্দন পাক্কা অইযায়। হকলতা হুনার বাদেও জামাই অউ সময় নিরাই রওয়ায় বউর মান্নত বা ওয়াদারে পাক্কা বানাইলায়। ");
INSERT INTO syl_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","অইলে হকলতা হুনার বাদে জামাইয়ে যুদি হউ দিনর মাজে কুন্তা না মাতিয়া সময় পারনির বাদে নিষেধ করে, তে বউয়ে অউ মান্নত পুরা না করায় এর দায়-ভার তাইর জামাইর উপরে পড়বো।” ");
INSERT INTO syl_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","জামাই-বউর বেয়াপারে, বাফ আর বাফর বাড়িত রওরা পুড়ির বেয়াপারে মাবুদে মুছা নবীরে অলা আইন হিকাই দিলা। ");
INSERT INTO syl_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","মাবুদে মুছা নবীরে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“মাদিয়ানী অকলে বনি ইছরাইলর লগে যেতা করছে, তুমি অতার অপরাধর বদলা দেও। এরবাদে তুমি তুমার বাফ-দাদার গেছে চিরকালর লাগি হুতি রইবায়।” ");
INSERT INTO syl_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","তেউ মুছায় বনি ইছরাইলরে কইলা, “মাদিয়ানী অকলর লগে যুদ্ধ করার লাগি তুমরার কিছু সিপাইরে জুইত করো, তারা মাবুদর তরফ থাকি মাদিয়ানী অকলর পাওনা সাজা দিবা। ");
INSERT INTO syl_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","অখন তুমরা বনি ইছরাইলর পরতেক খান্দান থাকি এক আজার করি সিপাইরে যুদ্ধত পাঠাও।” ");
INSERT INTO syl_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","তেউ বনি ইছরাইলর বারো খান্দান থাকি একো আজার করি মোট বারো আজার সিপাইরে যুদ্ধর লাগি জুইত করা অইলো। ");
INSERT INTO syl_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","মুছায় পরতেক খান্দান থাকি এক আজার জন সিপাইরে যুদ্ধত পাঠাইলা। এরার লগে ইমাম আলি-আজরর পুয়া পীনহসও গেলা, যাইতে পবিত্র কাবা ঘরর কিছু ছামানা লগে করি নিলা আর তান আতো করি যুদ্ধর আওয়াজর চুংগা অকলও নিলা। ");
INSERT INTO syl_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","মুছা নবীরে দেওয়া মাবুদর হুকুম মাফিক তারা মাদিয়ানী অকলর লগে যুদ্ধ করিয়া অতার হকল বেটাইন্তরে মারিলিলা। ");
INSERT INTO syl_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","সাধারন মানষর লগে মাদিয়ানী অকলর পাচ জন বাদশারেও তারা মারিলিলা। অউ বাদশাইন অইলা, ইবি, রেকম, শোর, হূর আর রেবা। আর এরার লগে বালাম বিন বাউর নামর হউ পীররেও তারা জানে মারিলিলা। ");
INSERT INTO syl_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","তারা মাদিয়ান দেশর হকল বেটিন আর হুরুতাইনরে বন্দি করলা, তারার গরু-ছাগল আর হক্কল মাল-ছামানা লুটিয়া আনিল্লা। ");
INSERT INTO syl_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","মাদিয়ানী অকল যত টাউনো বসত করতা, অউ টাউন অকল আর টাউনর বারর হকল তাম্বু তারা আগুইনদি জালাইলিলা। ");
INSERT INTO syl_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","যুদ্ধর বাদে তারার বন্দি করা হকল মানুষ, গনিমতর মাল-ছামানা, আর পশুর পাল লইয়া রওয়ানা অইলা। ");
INSERT INTO syl_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","তারা মুছা নবী, ইমাম আলি-আজর আর বনি ইছরাইলর কেম্পো ফিরার নিয়তে রওয়ানা দিলা। অউ সময় তারার তাম্বু আছিল যিরিহো এলাকার জর্দান গাংগর ধারো মোয়াব দেশর তল জাগাত। ");
INSERT INTO syl_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","তারার খবর পাইয়া মুছা নবী, ইমাম আলি-আজর আর বনি ইছরাইলর হকল মুরব্বি কেম্প থাকি বার অইয়া তারার লগে দেখা করাত গেলা। ");
INSERT INTO syl_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","গিয়া যুদ্ধ থাকি ফিরত আওয়া হকল কামান্ডারর উপরে মানি আজার সিপাইর আর শ-সিপাইর কামান্ডার অকলর উপরে মুছায় খুব গরম অইয়া ");
INSERT INTO syl_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","কইলা, “তুমরা দুশমনর হকল বেটিন্তরে জিন্দা রাখলায় কেনে? ");
INSERT INTO syl_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","মনো নাই নি, অগুইন্তে পিয়োর পাহাড়র উপরে বালাম পীরর পরামিশে, বনি ইছরাইলরে মাবুদর গেছ থাকি দুরই হরাইছিল, এরলাগি তো মাবুদর বন্দা অকলর উপরে গজবি বেমার নাজিল অইছিল। ");
INSERT INTO syl_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","তে অখন তুমরা অতার হকল পুয়াইন্তরে জানে মারিলাও, বিয়াতি বা অসতী হকল বেটিন্তরেও মারিলাও। ");
INSERT INTO syl_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","খালি আবিয়াতি সতী পুড়িন্তরে তুমরার লাগি জিতা রাখিও। ");
INSERT INTO syl_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“আর তুমরা যেরা কুনু মানষরে জানে মারছো বা মুর্দার লাশ ছইছো, তুমরা সাতদিন ভরা কেম্পর বারে রইও। এরমাজে তিন নম্বর আর সাত নম্বর দিন তুমরা নিজে আর বন্দি করি আনা মানষরেও পাক-ছাফ করবায়। ");
INSERT INTO syl_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","তুমরার হকল কাপড়-চুপড়, চামড়ার মাল-ছামানা, লাকড়ি আর ছাগলর রুমাদি বানাইল হক্কল ছামানারেও পাক-ছাফ করবায়।” ");
INSERT INTO syl_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","যেতা সিপাই অকল যুদ্ধত গেছলা, ইমাম আলি-আজরে তারারে কইলা, “ইতা অইলো মুছা নবীর আতে দেওয়া মাবুদর শরিয়তর একখান আইন: ");
INSERT INTO syl_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","তুমরা সোনা, রুপা, পিতল, লুয়া, টিন, সীসাদি বানাইল হকল মাল-ছামানা, ");
INSERT INTO syl_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","মানি যেতা মাল আগুনিত দিলে জলে না, ইতা হকলতা আগুনির মাজে দিবায়, তেউ ইতা পাক-ছাফ অইবো। অইলে জালানির বাদে ইতারে পাক-ছাফ করার পানিদি ধইয়া পাক-পাকিজা করা লাগবো। আর যেতা আগুইনে নষ্ট অইযায়, ইতারে খালি পাক-ছাফ করার পানিদি ধইলিবায়। ");
INSERT INTO syl_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","বাদে সাত নম্বর দিন তুমরার কাপড়-চুপড় ধইয়া হারলে, পাক-পাকিজা বনিয়া কেম্পর ভিতরে হামাইবায়।” ");
INSERT INTO syl_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","এরবাদে মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“তুমি আর ইমাম আলি-আজর আর সমাজর মুরব্বি অকলে মিলিয়া, বন্দি করি আনা হকল মানুষ আর পশুইন্তরে গনো। ");
INSERT INTO syl_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","গনিয়া হকল মাল দুই বাট করো। ইতার এক বাট দিবায় যুদ্ধত যেতা সিপাই অকল গেছিল তারারে, আর দুছরা বাট বাদ-বাকি মানষরে দিও। ");
INSERT INTO syl_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","অউ সিপাই অকলর বাটো যত মানুষ, গরু-ছাগল পড়বো, ইতার পরতেক পাচশোটা থাকি একটারে মাবুদর লাগি আলগাই থইও। ");
INSERT INTO syl_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","আলগাইয়া মাবুদর পাওনা অউ বাটরে তুমি ইমাম আলি-আজরর আতো দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","আর বনি ইছরাইলর বাটো যেতা মানুষ, গরু-ছাগল পাইবা, ইতার পরতেক পইঞ্চাশটা থাকি একটারে আলগ করি থইও। থইয়া আল্লার বসত খানা, বায়তুল্লা তাম্বুর খাদিম লেবি অকলর আতো ইতা সমজাইও।” ");
INSERT INTO syl_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","মাবুদে মুছারে যেলা হুকুম দিছলা, তাইন আর ইমাম আলি-আজরে অলাউ করলা। ");
INSERT INTO syl_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","সিপাই অকলে জিতিয়া আনা গনিমতর মাল-ছামানা ছাড়াও আরো আছিল, ছয় লাখ পচত্তইর আজার মেড়া আর ছাগল, ");
INSERT INTO syl_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","বাওত্তইর আজার গরু, ");
INSERT INTO syl_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","একষট্টি আজার গাধা ");
INSERT INTO syl_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","আর বত্তিশ আজার আবিয়াতি সতী পুড়িন। ");
INSERT INTO syl_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","তেউ যুদ্ধ কররা সিপাই অকলর বাটো পড়লো, তিন লাখ সাড়তিশ আজার পাচশোটা মেড়া আর ছাগল, ");
INSERT INTO syl_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ইতা থাকি মাবুদর পাওনা বাটো পড়লো, ছয়শো পচত্তইরগু ছাগল-মেড়া। ");
INSERT INTO syl_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","আর গরু আছিল ছয়তিশ আজার, ইতা থাকি মাবুদর বাটো পড়লো বাওত্তইরটা। ");
INSERT INTO syl_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","এরমাজে গাধা আছিল তিশ আজার পাচশোটা, ইতা থাকি মাবুদর বাটো পড়লো একষট্টিগু। ");
INSERT INTO syl_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","আর আবিয়াতি সতী পুড়িন আছলা ষোল আজার, ইতা থাকি মাবুদর বাটো পড়লো বত্তিশটা। ");
INSERT INTO syl_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","মাবুদে মুছা নবীরে যেলা হুকুম দিছলা, তাইন মাবুদর পাওনা বাট নিয়া ইমাম আলি-আজরর আতো অলা সমজাই দিলা। ");
INSERT INTO syl_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","আর মুছায় বনি ইছরাইলর বাদ-বাকি মানষর লাগি যে বাট সিপাই অকলর গেছ থাকি নিছলা, ");
INSERT INTO syl_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","ই বাটো তিন লাখ সাড়তিশ আজার পাচশোগু মেড়া আর ছাগল, ");
INSERT INTO syl_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","ছয়তিশ আজার গরু, ");
INSERT INTO syl_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","তিশ আজার পাচশোটা গাধা, ");
INSERT INTO syl_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","আর ষোল আজার আবিয়াতি সতী পুড়িন আছলা। ");
INSERT INTO syl_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","বাদে মাবুদর হুকুম মাফিক মুছা নবীয়ে বনি ইছরাইলর পাওয়া বাটর, পরতেক পইঞ্চাশ জন আবিয়াতি পুড়িন আর পশুইন থাকিও, এগু করি পুড়ি আর পশু নিয়া লেবি খান্দানর মানষরে দিলা, যেরার উপরে মাবুদর কাবা ঘরর দেখা-হুনার জিম্মাদারি আছিল। ");
INSERT INTO syl_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","এরবাদে সিপাই দলর আজার সিপাইর আর শ-সিপাইর কামান্ডার অকল মুছার গেছে আইলা, ");
INSERT INTO syl_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","আইয়া কইলা, “আপনার ই গুলাম অকলে আমরার জিম্মায় থাকা সিপাই অকলরে গনিলাম। গনিয়া দেখলাম, তারা হকল পুরা আছইন, যুদ্ধত কেউ মরছে না। ");
INSERT INTO syl_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","এরলাগি আমরা পরতেকর বাটো যেতা সোনার বাজু, বালা, আতর আংটি, কানর দুল আর গলার হার পাইছি, আমরা ইতা হকলতা লইয়া আইছি। আমরার জানর কফরার কুরবানি হিসাবে অতা মাবুদর দরবারো দিলাইতাম।” ");
INSERT INTO syl_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","তেউ মুছা আর ইমাম আলি-আজরে তারার গেছ থাকি সোনার হকল গয়না সমজিয়া পাইলা। ");
INSERT INTO syl_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","তারা আজার সিপাইর আর শ-সিপাইর কামান্ডার অকলর গেছ থাকি মাবুদর নামে দেওয়া যে সোনার গয়না সমজিয়া পাইলা, ইতার উজন আছিল ষোল আজার সাতশো পইঞ্চাশ তোলা। ");
INSERT INTO syl_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","54","মুছা নবী আর ইমাম আলি-আজরে আজার সিপাই আর শ-সিপাইর কামান্ডার অকলর গেছ থাকি অউ সোনা অকল সমজিয়া রাখলা। রাখিয়া মাবুদর ছামনে বনি ইছরাইলর ইয়াদগারির নিশানা হিসাবে অতা সোনা অকল কাবা ঘরর ভিতরে থইলা। ইতা ছাড়াও সিপাই অকলে গনিমতর আরো মাল-ছামানা যারযির গেছে রাখছিলা। ");
INSERT INTO syl_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","রুবেন আর ছাদু খান্দানর মানষর গরু-ছাগলর বড় বড় পাল আছিল। তারা দেখলা, জাজিরা আর গিলিয়দ এলাকা পশু পালিবার লাগি খুব ভালা জাগা। ");
INSERT INTO syl_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","তেউ তারা মুছা নবী, ইমাম আলি-আজর আর বনি ইছরাইলর পরধান মুরব্বি অকলরে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","“আপনাইন্তর ই গুলাম অকলে তো গরু-ছাগল পালি। আর আমরার মাবুদে অটারুত, দীবান, জাজিরা, নিম্রা, হিশবন, ইলিয়ালী, সেবাম, নবো আর বিয়োন নামর যেতা জাগা বনি ইছরাইলর দখলো আনছইন, ইতা তো পশু পালিবার লাগি খুব ভালা জাগা। ");
INSERT INTO syl_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","অখন আপনে যুদি আমরারে দয়া করইন, তে অউ জাগা খানাইন আপনার ই গুলাম অকলরে দিলাউক্কা। আমরারে জর্দান গাংগর হিপারো নেইন না যানু।” ");
INSERT INTO syl_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","মুছা নবীয়ে তারারে জুয়াপ দিলা, “তুমরার ভাইয়াইন যুদ্ধ করাত যাইবা, আর তুমরা অনো বই রইবায় নি? ");
INSERT INTO syl_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","মাবুদে বনি ইছরাইলরে যে জাগা খানাইন দিছইন, হিনো যাইতে তুমরা কেনে তারার মনোবল ভাংগি দিরায়? ");
INSERT INTO syl_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","হুনো, আগে যেবলা অউ দেশ দেখার লাগি তুমরার বাফ-দাদাইনরে আমি কাদেশ-বর্নেয়া থাকি পাঠাইছলাম, হউ সময় তারাও অলা করছলা। ");
INSERT INTO syl_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","তারা বনি ইছরাইলর লাগি মাবুদর দান করা দেশ দেখাত গেছিল, গিয়া আশকুলর পাহাড়িয়া খাল পর্যন্ত দেখছিল, দেখিয়া আইয়া হউ দেশো যাইতে এরার মনোবল ভাংগি দিছিল। ");
INSERT INTO syl_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","এরলাগি হউ দিন গুছায় আগুইন অইয়া মাবুদে কছম খাইয়া কইছলা, ");
INSERT INTO syl_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","আমি মাবুদে যে দেশ দিবার লাগি ইব্রাহিম, ইছহাক আর ইয়াকুবর গেছে কছম খাইছলাম, মিসর থাকি বার অইয়া আওয়া মানষর মাজে বিশ বছর বা এর বেশি বয়সি কুনু জনে ই দেশ দেখার সুযোগ পাইতা নায়, কেনেনা তারা আমার কথা পুরাপুর ষোলআনা মানছে না। ");
INSERT INTO syl_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","খালি কনিজী যিফুন্নির পুয়া কালুত আর নূনর পুত ইউছায় অউ দেশ দেখার সুযোগ পাইবা। তারা তো আমার কথারে ষোলআনা মানছে। ");
INSERT INTO syl_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","হউ সময় মাবুদে বনি ইছরাইলর উপরে গুছায় আগুইন অইগেছলা, এরলাগি তান নজরো নাফরমানি কররা অতা মানষর বিনাশ না অওয়া পর্যন্ত, চাল্লিশ বছর ধরি মরুভুমির নানান জাগাত ইতারে চক্কর দেওয়াইলা। ");
INSERT INTO syl_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“আর হউ গুনাগার অকলর আওলাদ অওয়ায়, অখন তুমরাও যারযির বাফ-দাদার খাইছলত পাইছো, এরলাগি বনি ইছরাইলর উপরে মাবুদর গুছার আগুইনরে আরো বাড়াইরায়। ");
INSERT INTO syl_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","অখন তুমরা যুদি তান হুকুম মাফিক না চলো, তে তাইন হিরবার অতা মানষরে মরুভুমিত ফালাই থইবা, তান ই লান্নতর কারন অইবায় তুমরাউ।” ");
INSERT INTO syl_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","ইতা হুনিয়া তারা মুছার ধারো ভিড়িয়া কইলা, “ছাব, আমরা তো খালি পশুর পাল রাখার জাগা বানানি আর আমরার বউ-বাইচ্চারে থওয়ার লাগি অনো টাউন অকল বানানির ইজাজত চাইছি। ");
INSERT INTO syl_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","অইলে বনি ইছরাইলরে নিজর জাগাত না পৌছানি পর্যন্ত আমরা যুদ্ধর সিপাইর লাখান তারার আগে আগে যাইমু। এরমাজে আমরার বউ-বাইচ্চাইন বাউন্ডরি করা অউ টাউনো রইলে, অতা দেশর মানষর আত থাকি তারা নিরাপদে রইবা। ");
INSERT INTO syl_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","হক্কল বনি ইছরাইলরে যারযির জমি-মিরাস না সমজানি পর্যন্ত আমরা নিজর ঘরো ফিরিয়া আইতাম নায়। ");
INSERT INTO syl_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","আর জর্দান গাংগর হপারো বনি ইছরাইলর লগে আমরা কুনু জমি-জমার বাটও নিতাম নায়, কেনেনা আমরার বাট তো গাংগর অউ পুবর পারোউ মিলিগেছে।” ");
INSERT INTO syl_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","ইখান হুনিয়া মুছায় কইলা, “আইচ্ছা, তুমরা যুদি হাছাউ ইলা করো, আল্লারে আজির-নাজির জানিয়া যুদ্ধর হাজে আতিয়ার লইয়া যুদি হনো লাড়াইত যাও, ");
INSERT INTO syl_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","আর আল্লায় যতবইল তান দুশমন অকলরে তান ছামনে থাকি খেদাইয়া না দেইন অতবইল তুমরা যুদ্ধর হাজে তান লাগি গাং পার অইয়া হপারো যুদি যাও, ");
INSERT INTO syl_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","তে হউ দেশো মাবুদর দখলদারি কাইম অইয়া হারলে তুমরা অনো ফিরত আইতায় পারবায়। তেউ মাবুদ আর বাদ-বাকি বনি ইছরাইলর লাগি তুমরার যে দায়-দায়িত্ব আছিল, ইতা থাকি খালাছ অইবায়; আর মাবুদর খুশি মাফিক অউ জমিনো তুমরার মালিকানা কাইম অইবো। ");
INSERT INTO syl_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","অইলে তুমরা যুদি ইলা না করো, তে তুমরা মাবুদর গেছে গুনাগার বনবায়। মনো রাখিও, তুমরার পাপে তুমরারে ছাড়তো নায়। ");
INSERT INTO syl_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","অখন তুমরার বউ-বাইচ্চার লাগি টাউন অকল আর গরু-ছাগল থওয়ার লাগি জাগাও বানাইতায় পারো, অইলে তুমরা যেখান ওয়াদা করছো, ইতা পুরন করা লাগবো।” ");
INSERT INTO syl_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","তেউ ছাদু আর রুবেন খান্দানর মানষে মুছা নবীরে কইলা, “আপনে তো আমরার মালিক, আপনার ই গুলাম অকলরে আপনে যেলা হুকুম দিছইন, আমরা অলাউ চলমু। ");
INSERT INTO syl_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","আমরার বউ-বাইচ্চাইন আর গরু-ছাগলর পাল অনর গিলিয়দ এলাকার টাউন অকলো রইবা। ");
INSERT INTO syl_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","অইলে আমরা আমরার মালিকর হুকুম মাফিক যুদ্ধর সাজ-সরঞ্জাম লইয়া গাং পার অইয়া মাবুদর নামে লাড়াই করাত যাইমু।” ");
INSERT INTO syl_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","তেউ মুছায় অতা মানষর বেয়াপারে ইমাম আলি-আজর, নূনর পুয়া ইউছা, আর বনি ইছরাইলর বারো খান্দানর নানান গুষ্টির মুরব্বি অকলরে হুকুম দিলা। ");
INSERT INTO syl_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","তাইন এরারে কইলা, “ছাদু আর রুবেন খান্দানর হকল বেটাইন যুদি হাছাউ যুদ্ধর সাজ-সরঞ্জাম লইয়া মাবুদর নামে লাড়াই করার নিয়তে তুমরার লগে জর্দান গাং পার অইয়া যাইন, তে হউ দেশ যেবলা তুমরার দখলো আইবো, অউ সময় তুমরা গিলিয়দ এলাকারে তারার মালিকানায় সমজাই দিও। ");
INSERT INTO syl_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","অইলে তারা যুদি ইলা না করইন, তে হউ কেনান দেশোউ তুমরার লগে তারার বাট নিবা।” ");
INSERT INTO syl_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","ইখান হুনিয়া ছাদু আর রুবেন খান্দানর মানষে কইলা, “মাবুদে তান ই গুলাম অকলরে যেলা হুকুম দিছইন, আমরা অলাউ করমু। ");
INSERT INTO syl_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","আমরা মাবুদর নামে যুদ্ধর সাজ-সরঞ্জাম লইয়া জর্দান গাং পার অইয়া কেনান দেশো যাইমু, অইলে আমরার জমি-জমার বাট গাংগর অপারো রইলো।” ");
INSERT INTO syl_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","ইখান হুনিয়া মুছা নবী রাজি অইলা। তাইন ছাদু আর রুবেন খান্দানরে, এরলগে ইউছুফর পুয়া মানশা খান্দানর অর্ধেক মানষরে, অউ জাগাইন দিলা। মুছায় আমোরী অকলর বাদশা সীহোন আর বাশনর বাদশা উজর আস্তা রাজত্বর হকল টাউন আর গাউ-গেরাম সহ সব জমি-মিরাস তারার লাগি থইলা। ");
INSERT INTO syl_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","তেউ ছাদু খান্দানর মানষে দীবান, অটারুত, আরোয়ার, ");
INSERT INTO syl_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","আটরুত-শুফান, জাজিরা, জগবিয়া, ");
INSERT INTO syl_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","বায়ত-নিমরা, বায়ত-হারান নামর গাউয়াইন আর টাউন অকলরে উচা উচা বাউন্ডরি ওয়াল গাথিয়া মজবুত করলা। এরলগে তারার গরু-ছাগল থইবার জাগাও বানাইলা। ");
INSERT INTO syl_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","রুবেন খান্দানর মানষে হিশবন, ইলিয়ালী, কিরিয়াতাইম টাউন, ");
INSERT INTO syl_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","আর নবো, বাআল-মিয়োন, ছিবমা নামর গাউয়াইন ঠিক-ঠাক করলা। করিয়া তারা ইতার নয়া নাম থইলা। ");
INSERT INTO syl_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","মানশার পুয়া মাখীরর আওলাদ অকলে গিলিয়দো গিয়া আগেউ ইতা দখল করিলিছিল, আর হনর বাসিন্দা আমোরী অকলরে খেদাই দিছিল। ");
INSERT INTO syl_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","এরলাগি মুছায় মানশার অউ আওলাদ মাখীরি অকলর বাটো গিলিয়দ এলাকারে দিলাইলা, তারা অনো বসত করলা। ");
INSERT INTO syl_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","এরমাজে মানশা খান্দানর যায়ীর নামর একজনে গিয়া আমোরী অকলর হকল গাউ-গেরাম দখল করিলিছিল, আর ইতার নাম দিছিল হাব্বুত-যায়ীর। ");
INSERT INTO syl_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","আর নুবা নামর একজনে গিয়া কনাত আর এর কান্দা-কাছার গাউ-গেরাম অকল দখল করিয়া, তার নিজর নামে ই জাগার নাম দিলো নুবা। ");
INSERT INTO syl_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","মুছা আর হারুন নবীর নেতাগিরিয়ে বনি ইছরাইল জাতি ফৌজি দল হাজিয়া, মিসর দেশ থাকি বার অইয়া আওয়ার বাদে নানান জাগাত দম লইলা। ");
INSERT INTO syl_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","আর মাবুদর হুকুমে মুছা নবীয়ে তারার দম লওয়ার জাগাইন্তর নাম লেখিয়া থইলা। অউ জাগাইন অইলো, ");
INSERT INTO syl_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","বছরর পয়লা চান্দর পনরো তারিখ, মানি আজাদি ইদর বাদর দিন, তারা মিসর দেশর রামাষেষ এলাকা থাকি রওয়ানা অইলা। মিসরর হকল মানষর চখুর ছামনেদি তারা বুক ফুলাইয়া বার অইয়া আইলা। ");
INSERT INTO syl_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","অউ সময় মিসরী অকলে তারার বড় পুয়াইন্তর লাশ দাফন করাত আছিল। মাবুদে আগর রাইত তারার হকল ঘরর বড় পুয়াইনরে মারিলিছলা। তাইন অতার দেব-দেবীর উপরেও গজব ঢালিয়া তারার পাওনা সাজা দিছলা। ");
INSERT INTO syl_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","বনি ইছরাইলে রামাষেষ এলাকা ছাড়িয়া সুক্কতো আইয়া তাম্বু গাড়িলা। ");
INSERT INTO syl_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","বাদে সুক্কত থাকি মরুভুমির কান্দাত এথম নামর জাগাত আইয়া তাম্বু গাড়িলা। ");
INSERT INTO syl_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","আর এথম থাকি বাআল-জাফনর ছামনে মিগদোলর কান্দাত ফামা-হিরোত নামর জাগাত আইয়া তাম্বু গাড়িলা। ");
INSERT INTO syl_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","বাদে ফামা-হিরোত থাকি দরিয়া পার অইয়া এথম মরুভুমিত গেলা, অউ মরুভুমি বায় তিন দিনর পথ পাড়ি দিয়া মারুয়াত গিয়া তাম্বু গাড়িলা। ");
INSERT INTO syl_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","বাদে মারুয়া থাকি এলীমো গেলা, ইনো পানির বারোগু ইন্দারা আর সত্তইরগু খেজুর গাছ আছিল। ");
INSERT INTO syl_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","এরবাদে এলীম ছাড়িয়া নীল দরিয়ার পারো গিয়া তাম্বু গাড়িলা। ");
INSERT INTO syl_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","হনো থাকি ছীন মরুভুমিত আইয়া রইলা। ");
INSERT INTO syl_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","আর ছীন মরুভুমি থাকি দপকা নামর জাগাত গিয়া কেম্প গাড়িলা। ");
INSERT INTO syl_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","বাদে দপকা ছাড়িয়া আলুশো গিয়া কেম্প গাড়িলা। ");
INSERT INTO syl_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","আলুশ থাকি রফিদিমো গেলা, ইনো খাইবার কুনু পানি আছিল না। ");
INSERT INTO syl_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","তেউ রফিদিম ছাড়িয়া তারা সিনাই মরুভুমিত গিয়া কেম্প গাড়িলা। ");
INSERT INTO syl_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","এরবাদে সিনাই মরুভুমি থাকি কিবরুত-হুতাবা। ");
INSERT INTO syl_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","কিবরুত-হুতাবা থাকি হাজিরুত। ");
INSERT INTO syl_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","হাজিরুত থাকি রিতমা। ");
INSERT INTO syl_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","রিতমা থাকি রিম্মন-পেরস। ");
INSERT INTO syl_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","অখান থাকি লিবনা। ");
INSERT INTO syl_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","লিবনা থাকি রিসসা। ");
INSERT INTO syl_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","রিসসা থাকি কহেলাতা নামর জাগাত তাম্বু গাড়িলা। ");
INSERT INTO syl_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","বাদে গেলা শেফর পাহাড়ো। ");
INSERT INTO syl_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","অখান থাকি হরাদা। ");
INSERT INTO syl_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","হরাদা থাকি মখেলোত। ");
INSERT INTO syl_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","অন থাকি তহত। ");
INSERT INTO syl_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","বাদে তারেখ। ");
INSERT INTO syl_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","তারেখ থাকি মিতকা। ");
INSERT INTO syl_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","মিতকা থাকি হশমুনা। ");
INSERT INTO syl_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","বাদে মছেরুত। ");
INSERT INTO syl_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","অন থাকি বনি-ইয়াকান। ");
INSERT INTO syl_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","বাদে হুর-হগ্গিদগদ। ");
INSERT INTO syl_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","অন থাকি জতবাতা। ");
INSERT INTO syl_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","জতবাতা থাকি অবরুনা। ");
INSERT INTO syl_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","বাদে ইজিয়ন-গেবর। ");
INSERT INTO syl_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","আর অখান থাকি জীন মরুভুমির কান্দাত কাদেশ এলাকাত গিয়া তাম্বু গাড়িলা। ");
INSERT INTO syl_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","বাদে কাদেশ ছাড়িয়া ইদোম দেশর সীমানার গেছে হুর পাহাড়ো রইলা। ");
INSERT INTO syl_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","বনি ইছরাইল মিসর দেশ থাকি বার অই আওয়ার বাদে, চাল্লিশ বছরর পাচ নম্বর চান্দর পয়লা দিন ইমাম হারুন মাবুদর হুকুমে হুর পাহাড়র উপরে উঠিছলা, আর হনো তান উফাত অইলো। ");
INSERT INTO syl_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","তাইন একশো তেইশ বছর বয়সো হুর পাহাড়র উপরে ইন্তেকাল করলা। ");
INSERT INTO syl_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","এরমাজে অরাদ এলাকার কেনানী বাদশায় খবর পাইলা, বনি ইছরাইল অনো আইছইন। তাইন তো কেনান দেশর নেগেভ মরুভুমিত রইতা। ");
INSERT INTO syl_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","বাদে বনি ইছরাইলে হুর পাহাড় ছাড়িয়া সলমুনা নামর জাগাত গিয়া তাম্বু গাড়িলা। ");
INSERT INTO syl_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","সলমুনা থাকি পুনন গেলা। ");
INSERT INTO syl_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","পুনন থাকি অবুত গেলা। ");
INSERT INTO syl_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","অবুত থাকি মোয়াব দেশর সীমানাত ইয়া-আবারীমো গেলা। ");
INSERT INTO syl_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","অখান থাকি দীবান-ছাদু গেলা। ");
INSERT INTO syl_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","অন থাকি আলমুন-দিব্লাতিমো গেলা। ");
INSERT INTO syl_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","বাদে তারা আবারীম পাহাড়ো উঠিয়া নবো নামর টিল্লার কান্দাত কেম্প গাড়িলা। ");
INSERT INTO syl_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","এরবাদে আবারীম পাহাড় ছাড়িয়া যিরিহো টাউনর উল্টাবায় জর্দান গাংগর কান্দাত মোয়াব দেশর তল জাগাত তাম্বু গাড়িলা। ");
INSERT INTO syl_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","ই কেম্পর সীমানা আছিল জর্দান গাংগর পারো মোয়াব এলাকার তল জাগা বায়ত-জিশিমুত থাকি আবেল-শিটিম টাউন পর্যন্ত। ");
INSERT INTO syl_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","আর অউ সময় যিরিহো এলাকার জর্দান গাংগর ধারো মোয়াব দেশর তল জাগাত মাবুদে মুছা নবীরে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“তুমি বনি ইছরাইলরে জানাই দেও, তুমরা যেবলা জর্দান গাং পার অইয়া কেনান দেশো গিয়া আজিবায়, ");
INSERT INTO syl_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","অউ সময় তুমরার ছামন থাকি হনর হকল মানষরে খেদাই দিবায়। খেদাইয়া তারার পাথর খুদিয়া বানাইল হকল মুর্তি ভাংগিয়া চুরমার করবায়। হুনারর আতিয়ারদি বানাইল হকল দেব-দেবীর মুর্তি বিনাশ করবায়। আর টিল্লার উপরর দেবতার নামর পশুর-বলি খানাইন তুলিয়া ফালাইবায়। ");
INSERT INTO syl_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","অলাখান তুমরা আস্তা দেশ দখল করিয়া হনো বসত করবায়। মনো রাখিও, তুমরার দখলদারির লাগি ই দেশখান আমি তুমরারে দান করছি। ");
INSERT INTO syl_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","হনো লটারি মারিয়া তুমরার নানান গুষ্টির জাগা বাটিয়া নিও। যে গুষ্টিত বেশি মানুষ তারারে বেশি জাগা, আর কম অইলে কম জাগা দিও। লটারিত যে গুষ্টিয়ে যে জাগা পাইবা, তারা অনোউ বসত করবা। খান্দানর মাজর নানান গুষ্টিয়ে যারযির খান্দানর এলাকার মাজে জাগা পাইবা। ");
INSERT INTO syl_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","অইলে তুমরা যুদি হনর বাসিন্দা অকলরে না খেদাও, তে তারার যেগুইন রইবা, ইগুইন তুমরার চখুর কাটা আর বুকুর ছেল বনিয়া রইবা। ইতায় তুমরার বসতি জমিনো তুমরারে জুলুম-মছিবতো ফালাইবা। ");
INSERT INTO syl_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","হউ সময় আমি তুমরারে অলা সাজা দিমু, যে সাজা খালি তারার লাগিউ ঠিক করিয়া থইছলাম।” ");
INSERT INTO syl_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","মাবুদে মুছা নবীরে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“তুমি বনি ইছরাইলরে আমার অউ হুকুম জানাই দেও, তুমরা গিয়া কেনান দেশো হামানির বাদে হনো যে জাগার মালিকানা পাইবায়, ই জাগার সীমানা অইলো, ");
INSERT INTO syl_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","ইদোম দেশর বডারর জীন মরুভুমির কিছু এলাকা তুমরার দেশর দউকনর সীমানা। বাদে অউ দউকনর সীমানা থাকি পুবেদি গিয়া লোনা সাগরর হেশ মাথা পর্যন্ত। ");
INSERT INTO syl_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","এরলগে আকরাব্বিম পাহাড়র পথ পার অইয়া হারি জীন মরুভুমিত হামাইয়া কাদেশ-বর্নেয়ার দউকনেদি সীমানা যাইবো। গিয়া অখান থাকি হাজর-আদর অইয়া অজমুন পর্যন্ত তুমরার সীমানা। ");
INSERT INTO syl_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","আর অজমুন থাকি ঘুরিয়া মিসরর সীমানার হুকনা খালর পারেদি ভূমধ্য সাগরো গিয়া লাগবো। ");
INSERT INTO syl_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“তুমরার দেশর পইচমর সীমানা অইবো ভূমধ্য সাগর। ইটাউ তুমরার পইচমর আইল। ");
INSERT INTO syl_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“তুমরার উতরর সীমানা অইবো, ভূমধ্য সাগর থাকি হুর নামর পাহাড়, ");
INSERT INTO syl_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","অউ পাহাড় থাকি হামাতো যাইবার পথ পর্যন্ত, হামাতর পথ থাকি তুমরার সীমানা জিদাদ গাউ পর্যন্ত যাইবো। ");
INSERT INTO syl_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","আর জিদাদ থাকি জিফরুন অইয়া হাজর-অননো গিয়া শেষ অইবো। ইটাউ অইবো তুমরার উতরর সীমানা। ");
INSERT INTO syl_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“দেশর পুবর সীমানা অইলো, হাজর-অনন থাকি শফাম পর্যন্ত একটা সীমানা আইল ঠিক করিও। ");
INSERT INTO syl_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","অউ শফামর সীমানা থাকি ঐন গাউর পুবেদি গিয়া রিবলা পর্যন্ত আইয়া লামবো, লামিয়া গালিল আওরর চরেদি যাইবো, ");
INSERT INTO syl_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","গিয়া জর্দান গাংগর পারেদি লোনা সাগরো আইয়া শেষ অইবো। অউ সব অইলো তুমরার দেশর চাইরো গালার সীমানা আইল।” ");
INSERT INTO syl_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","আর মুছায় বনি ইছরাইলরে হুকুম দিলা, “মাবুদর হুকুম মাফিক তুমরা লটারি মারো, মারিয়া তুমরার নয় খান্দান আর মানশা খান্দানর অর্ধেক মানষরে অউ দেশর জমি-মাটি বাটিয়া দিয়া, তুমরার দখলদারি কাইম করো। ");
INSERT INTO syl_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","জানো তো, রুবেন খান্দান, ছাদু খান্দান আর মানশা খান্দানর অর্ধেক মানষে তারার যারযির গুষ্টি মাফিক জমি-জমার বাট আগেউ পাইলিছে। ");
INSERT INTO syl_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","তারা যিরিহো এলাকার জর্দান গাংগর পুবর পারো তারার বাট আগেউ বাছিয়া নিছইনগি।” ");
INSERT INTO syl_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“অউ দেশর জমি-মাটিরে বাটিয়া দিতে যেরা মাতব্বরি করবা, এরার নাম অইলো, ইমাম আলি-আজর আর নূনর পুয়া ইউছা। ");
INSERT INTO syl_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","জমি-জমা বাটিবার কালো সাইয্য করার লাগি পরতেক খান্দানো থাকি একজন করি সর্দার নিবায়। ");
INSERT INTO syl_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","অউ সর্দার অইলা, এহুদা খান্দানর যিফুন্নির পুয়া কালুত, ");
INSERT INTO syl_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","শিমিয়ন খান্দানর আমিহুদর পুয়া শামুয়েল, ");
INSERT INTO syl_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","বিন-ইয়ামিন খান্দানর কিছলোনর পুয়া ইলীদদ, ");
INSERT INTO syl_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","দান খান্দানর সর্দার উজলির পুয়া বুক্কি, ");
INSERT INTO syl_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","ইউছুফর পুয়া মানশা খান্দানর সর্দার ইফাদর পুয়া হান্নিয়েল, ");
INSERT INTO syl_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","ইউছুফর পুয়া আফরাইম খান্দানর সর্দার শিপ্তনর পুয়া কমুয়েল, ");
INSERT INTO syl_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","সবুলন খান্দানর সর্দার ফর্নাখর পুয়া ইলিজাফন, ");
INSERT INTO syl_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","ইছাখর খান্দানর সর্দার আযানর পুয়া ফলতিয়েল, ");
INSERT INTO syl_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","আশির খান্দানর সর্দার শলোমির পুয়া অহীহুদ, ");
INSERT INTO syl_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","নপ্তালি খান্দানর সর্দার আমিহুদর পুয়া পদহেল।” ");
INSERT INTO syl_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","মাবুদে অউ সর্দার অকলরে জিম্মাদারি সমজাইলা, কেনান দেশো বনি ইছরাইলর জমি-জমা বাটিয়া দিবার লাগি। ");
INSERT INTO syl_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","বাদে যিরিহো টাউনর কাছাত জর্দান গাংগর ধারো মোয়াব দেশর তল জাগাত মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“তুমি বনি ইছরাইলরে অউ হুকুম দেও, তারা যারযির খান্দানর জমি-জমার বাট পাইয়া হারলে, অতা থাকি কিছু টাউন লেবি খান্দানর মানষরে দিলাইতা, এরা অনো রইবা, এরলগে বন্দর কিছু জমিও এরারে দিতা। ");
INSERT INTO syl_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","অউ টাউনো তারা বসত করবা, আর বন্দর জমিনো তারার পশুর পাল রাখবা। ");
INSERT INTO syl_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","তুমরা লেবি খান্দানরে যে টাউন অকল দিবায়, ইতার বাউন্ডরি ওয়ালর বারে তারারে আরো এক আজার আত জাগা দিবায়, তারার পশুর পাল রাখার লাগি। ");
INSERT INTO syl_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","তুমরা যত টাউন তারারে দিবায়, ইতার চাইরো গালার বাউন্ডরি ওয়ালর বারে, মানি উতরে-দউকনে, পুবে-পইচমে, হক্কলবায় আরো দুই আজার আত বন্দর জাগা মাপিয়া দিও। অনো তারার পশুর পাল রাখবা। ");
INSERT INTO syl_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“তুমরা লেবি খান্দানরে যেতা টাউন অকল দিবায়, এরমাজর ছয়খান টাউন অইবো খুনি মানষর আশ্রয় টাউন। কুনু মানষে আখতা কেউররে মারিলিলে, হে অউ টাউনো গিয়া আশ্রয় লইবো। অউ ছয় টাউন বাদেও লেবি খান্দানরে আরো বেয়াল্লিশ খান টাউন দিলাইবায়। ");
INSERT INTO syl_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","মোট আটচাল্লিশ খান টাউন লেবি অকলরে দিবায়, আর এরলগে পশুর পাল রাখার বন্দর জাগাও দিবায়। ");
INSERT INTO syl_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","বনি ইছরাইলর জমি-জমা থাকি লেবি খান্দানরে যেবলা টাউন অকল দিবায়, অউ সময় হকল খান্দানে পাওয়া জমিনর বাট থাকি তারারে দিবায়। যে খান্দানে বেশি পাইছে এরা বেশি দিবা, আর যেরা কম পাইছে এরা কম দিবা।” ");
INSERT INTO syl_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","এরবাদে মাবুদে মুছারে কইলা, ");
INSERT INTO syl_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“তুমি বনি ইছরাইলরে কও, তুমরা যেবলা জর্দান গাং পার অইয়া কেনান দেশো গিয়া হামাইবায়, ");
INSERT INTO syl_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","অউ সময় তুমরার নিজর লাগি কয়খান আশ্রয় টাউন ঠিক করিও। তেউ কুনু মানষে যুদি আখতা কজা করিয়া কেউররে খুন করিলায়, তে বাগিয়া হনো গিয়া আশ্রয় লইবো। ");
INSERT INTO syl_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","খুনর বদলা লওরা মানষর গেছ থাকি বাগিয়া জান বাচানির লাগি ই আশ্রয় টাউন। এতে বনি ইছরাইলর আদালতো বিচারর আগ পর্যন্ত খুনর আসামিরে কেউ জানে মারার সুযোগ পাইতো নায়। ");
INSERT INTO syl_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","এরলাগি লেবি খান্দানরে তুমরা যে টাউন অকল দিবায়, ইতার মাজর ছয়খান টাউন অইবো তুমরার আশ্রয় টাউন। ");
INSERT INTO syl_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","এরমাজর তিনখান টাউন অইবো জর্দান গাংগর পুবর পারো, আর তিনখান অইবো কেনান দেশর ভিতরে। ");
INSERT INTO syl_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","অউ ছয়োখান টাউন অইবো বনি ইছরাইলর লাগি, তুমরার লগে রওরা ভিন-দেশি অকলর লাগি আর মুছাফির অকলর লাগি আশ্রয় টাউন। এরার মাজর কেউ যুদি আখতা বে-খিয়ালে কেউররে খুন করিলায়, তে অখানো গিয়া জান বাচাইবো। ");
INSERT INTO syl_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“অইলে কুনু মানষে যুদি লুয়ার কুনু আতিয়ার দিয়া কেউররে মারে আর হউ জন মরিযায়, তে অগু খুনি। অউ খুনিরে জানে মারিলিবায়। ");
INSERT INTO syl_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","যে পাথর দিয়া কুনু মানষরে খুন করা যাইবো, ইলা কুনু পাথর যুদি কেউরর আতো থাকে, আর অগুদি কেউররে মারায় হউ মানুষ মরিযায়, তে অগুও খুনি। ই খুনিরে জানে মারিলিবায়। ");
INSERT INTO syl_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","মানুষ খুন অওয়ার মত কুনু লাকড়ির জিনিস যুদি কেউরর আতো থাকে, আর অগু দিয়া কেউররে মারায় হউ মানুষ মরিযায়, তে অগুও খুনি। ই খুনিরে জানে মারিলিবায়। ");
INSERT INTO syl_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","খুন অওয়া জনর আপন যে মানষে ই খুনর বদলা লওয়ার কথা, খালি হে-উ অউ খুনিরে জানে মারিলিবো। খুনির দেখা পাইলেউ তারে জানে মারিলিবো। ");
INSERT INTO syl_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","“আর ইংসা করিয়া যুদি এক জনে আরক জনরে ডেক্কা মারে, বা কুনুজাত অস্ত্রদি ইচ্ছা করিয়া ইটা মারে আর হউ মানুষ মরিযায়, ");
INSERT INTO syl_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","বা দুশমনির ভাবে কেউররে ঘুষি মারে আর হে মরিযায়, তে যে মারছে হে খুনি। ই খুনিরে জানে মারিলিবায়। খুন অওয়া জনর আপন যে মানষে ই খুনর বদলা লওয়ার কথা, হে অউ খুনির লাগাল পাইলেউ তারে জানে মারিলিবো। ");
INSERT INTO syl_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“অইলে মনো কুনু দুশমনি না রাখিয়া ভুলে আখতা কেউররে ডেক্কা মারলে, বা মনো কুনু খারাপি না থাকলেও ভুলে তার উপরে ইটা মারি দিলে, ");
INSERT INTO syl_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","বা না দেখিয়া, মানুষ মরিযিবার জুকা কুনু পাথর কেউরর উপরে ফালাই দিলে হে যুদি মরিযায়, তে কুনুজাত দুশমনির ভাব না থাকায়, আর খেতি করার কুনু ইচ্ছা না থাকায়, ");
INSERT INTO syl_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","বনি ইছরাইলর আদালতর মানষে, অউ খুনির আর খুনর বদলা লওরা জনর বেয়াপারে অউ নিয়ম মানিয়া বিচার করবা। ");
INSERT INTO syl_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","অউ সময় আদালতর মানষে খুনর বদলা লওরার আত থাকি খুনি জনরে বাচাইবা, বাচাইয়া হে আগে যেখানো বাগিয়া গেছিল, হউ আশ্রয় টাউনো তারে হিরবার পৌছাই দিবা। আর পবিত্র তেল দিয়া খেলাফতি পাওয়া পরধান ইমাম ছাবর মউতর আগ পর্যন্ত হে হনো রইবো। ");
INSERT INTO syl_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","অইলে হে যুদি কুনু সময় হউ আশ্রয় টাউনর বারে বার অইয়া যায়গি, ");
INSERT INTO syl_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","আর বদলা লওরায় তারে পাইয়া জানে মারিলায়, তে হে খুনর দায়ী অইতো নায়। ");
INSERT INTO syl_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","কারন পরধান ইমামর মউত না অওয়া পর্যন্ত হে আশ্রয় টাউনো রওয়ার কথা। খালি পরধান ইমামর মউতর বাদে হে নিজর বাড়িত ফিরিয়া আইতো পারবো। ");
INSERT INTO syl_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","তুমরা দেশর যেনোউ বসত করো না কেনে, ওয়ারিশর পর ওয়ারিশ ধরি ইতা মানতে অইবো, ইতা তো অইলো তুমরার শরিয়তর একটা আইন। ");
INSERT INTO syl_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“সাক্ষির জবানবন্দির উপরে নির্ভর করিয়া খুনিরে জানে মারিলাওয়া অইবো। অইলে খালি একজন সাক্ষির কথায় কেউররে মারিলাওয়া যাইতো নায়। ");
INSERT INTO syl_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","মউতউ যার পাওনা সাজা, ইলা কুনু খুনিরে কুনুমন্তেউ টেকার বদলা খালাছ দেওয়া যাইতো নায়। তারে জানে মারিলিতেউ অইবো। ");
INSERT INTO syl_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","আশ্রয় টাউনো রওরা কুনু আসামিরে টেকার বদলা, পরধান ইমামর মউতর আগে তার নিজর বাড়িত ফিরাই আনা যাইতো নায়। ");
INSERT INTO syl_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","মনো রাখিও, ইতা করিয়া তুমরা নিজর দেশর মাটিরে নাপাক করিও না। জানো তো, খুনর লউয়ে দেশ নাপাক অইযায়। আর যে দেশো খুনর লউ ঝরছে, হউ খুনির লউ ছাড়া আর কুনুমন্তেউ হি দেশর নাপাকির কফরা অয় না। ");
INSERT INTO syl_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","আর তুমরা যে দেশো রইবায় আমিও তো হনো রইমু, এরলাগি ই দেশরে নাপাক বানাইও না। কারন আমি মাবুদ বনি ইছরাইলর মাজে বসত করি।” ");
INSERT INTO syl_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","ইউছুফ নবীর আওলাদর খান্দান অকল থাকি, মানশার নাতি মাখীরর পুয়া গিলিয়দ গুষ্টির নানান পরিবার থাকি মুরব্বি অকল আইলা, আইয়া তারা মুছা নবী আর বনি ইছরাইলর নানান গুষ্টির সর্দার অকলর লগে মাতিলা। ");
INSERT INTO syl_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","কইলা, “মাবুদে আমরার ই মালিকরে হুকুম দিছলা, লটারি মারিয়া বনি ইছরাইলর মাজে দেশর জাগা-জমিন বাটিয়া দিতা। দিবার সময় আমরার ভাই জলাপখাদর জমি-জমা খানাইন তার পুড়িন্তরে দিবার হুকুম দিছইন। ");
INSERT INTO syl_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","অইলে বনি ইছরাইলর দুছরা কুনু খান্দানর মানষর লগে যুদি অউ পুড়িন্তর বিয়া অয়, তে আমরার বাফ-দাদার ছামানা থাকি তারার ছামানা বার অইয়া গিয়া, তারার জামাইর খান্দানর জমি-জমাত হামাইযিবো, এতে আমরার খান্দানর জমি-মিরাসর কিছু অংশ কমিযিবো। ");
INSERT INTO syl_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","বনি ইছরাইলর জমি-মিরাস ফিরত পাওয়ার হউ পবিত্র পইঞ্চাশ বছরর কালো, তারার জমি-জমা গিয়া তো তারার জামাইর খান্দানর ছামানা অইযিবো। অউ লাখান আমরার বাফ-দাদার জমি-মিরাস থাকি তারার অংশ বার অইয়া যাইবোগি।” ");
INSERT INTO syl_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","ইখান হুনিয়া মাবুদর হুকুম মাফিক মুছায় বনি ইছরাইলরে কইলা, “ইউছুফর আওলাদর অউ খান্দানর মানষে যেতা কইরা, ইতা তো হাছা। ");
INSERT INTO syl_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","এরলাগি জলাপখাদর পুড়িন্তর বেয়াপারে মাবুদে হুকুম দিরা, তারা যারে পছন্দ করইন তার গেছেউ বিয়া বইতা পারবা। অইলে শর্ত অইলো, তারার বাফর খান্দানর ভিতরে বিয়া বইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","বনি ইছরাইলর জমি-মিরাস এক খান্দান থাকি আরক খান্দানো যাইতো পারতো নায়। বনি ইছরাইলর পরতেক জনে তার বাফ-দাদার জমি-মিরাস বাচানি লাগবো। ");
INSERT INTO syl_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","বনি ইছরাইলর পরতেকে যাতে তারার বাফ-দাদার গেছ থাকি পাওয়া জমি-জমার মালিকানা টিকাই রাখতো পারে, অতার লাগি পরতেক খান্দানর জমি-জমার মালিকানা পাওয়া পুড়িন্তে তারার বাফর খান্দানর নশার গেছে বিয়া বইতে অইবো। ");
INSERT INTO syl_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","এক খান্দান থাকি আরক খান্দানো কুনু জমি-জমা যাইতো নায়। বনি ইছরাইলর পরতেক খান্দানে তারার জমি-জমার মালিকানা ধরিয়া রাখতে অইবো।” ");
INSERT INTO syl_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","মাবুদে মুছারে যেলা হুকুম দিছলা, জলাপখাদর পুড়িন্তে অলা মানলা। ");
INSERT INTO syl_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","তারার বাফর খান্দানর ভাইয়াইন্তর গেছে বিয়া বইলা। জলাপখাদর পুড়িন্তর নাম অইলো, মহলা, তিরজা, হগলা, মিলকা, আর নোয়া। ");
INSERT INTO syl_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","ইউছুফর পুয়া মানশার খান্দানর গুষ্টি অকলর মাজেউ তারা বিয়া বইলা। ");
INSERT INTO syl_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","আর হুনো, যিরিহো এলাকার জর্দান গাংগর ধারো মোয়াব দেশর তল জাগাত, মাবুদে মুছা নবীর মাজদি বনি ইছরাইলরে অউ হুকুম-আহকাম আর নিয়ম-কানুন অকল দিছলা॥");
INSERT INTO syl_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","মুছা নবীয়ে জর্দান গাংগর পুব পারর আরাবা নামর মরুভুমিত বনি ইছরাইল জাতিরে অউ বয়ান করছলা, তাইন সুফ গাউর ছামনে উবাইয়া তারার লগে মাতিলা। এর একবায় আছিল ফারান, আর অইন্যবায় আছিল তোফল, লাবন, হাজিরুত আর দিজাহাব, অউ চাইর গাউ। ");
INSERT INTO syl_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","সেয়ীরর পাহাড়িয়া পথেদি তুর পাহাড় থাকি কাদেশ-বর্নেয়া পর্যন্ত আটিয়া যাইতে খালি এগারো দিন লাগে। ");
INSERT INTO syl_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","অইলে বনি ইছরাইল মিসর থাকি বার অইয়া উনচাল্লিশ বছর এগারো মাস পর্যন্ত, অর্থাত ছফরর চাল্লিশ বরছ চলার কালো, অনো ঘুরিলা। বাদে অউ মাসর পয়লা তারিখো মুছা নবীয়ে তারারে জানাইলা মাবুদে তানরে যেতা কইছলা। ");
INSERT INTO syl_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","তাইন লাড়াই করি আমোরী অকলর বাদশা সীহোনরে আর বাশন দেশর বাদশা উজরে আরাইয়া হারলে ইতা কইলা। অউ সীহোনে বাদশাই করতা হিশবন টাউনো, আর উজে বাদশাই করতা অষ্টারোত আর ইদরি টাউনো। ");
INSERT INTO syl_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","জর্দান গাংগর পুব পারর মোয়াব দেশো, মুছা নবীয়ে আল্লার দেওয়া তৌরাতর তালিম বয়ান করিয়া বুজাইলা। তাইন কইলা, ");
INSERT INTO syl_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“ও বনি ইছরাইল, হুনো, আমরা তুর পাহাড়র গালাত থাকার কালো মাবুদ আল্লায় আমরারে কইছলা, অউ পাহাড়র গালাত তুমরার বউত দিন গুজরি গেছে। ");
INSERT INTO syl_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","তে অখন তুমরা হকলে তাম্বু তুলিয়া আমোরী অকলর পাহাড়িয়া এলাকা আর অউ এলাকার কান্দা-কাছার হকল জাগাত যাওয়ার লাগি রওয়ানা অও। ই জাগা হকলতা অইলো গিয়া: আরাবা মরুভুমি আর অউ মরুভুমির কান্দা-কাছার উচা পাহাড়িয়া জাগা আর নিচা পাহাড়িয়া জাগা, নেগেভ মরুভুমি আর দরিয়ার কিনারা, মানি কেনান দেশ থাকি আরম্ভ করিয়া লেবানন দেশ অইয়া ফোরাত গাং পর্যন্ত ইতা হকল জাগা। ");
INSERT INTO syl_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","মনো রাখিও, ইতা হকল জাগা আমি তুমরারে দিলাইছি। আমি মাবুদে তুমরার বাফ-দাদাইন ইব্রাহিম, ইছহাক, ইয়াকুব আর তারার খান্দানরে যে দেশ দেওয়ার ওয়াদা করছলাম, তুমরা অখন গিয়া ইতা হকল জাগা দখল করিলাও। ");
INSERT INTO syl_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","“তে ভাইয়াইনরে, হউ সময় আমি তুমরারে কইছলাম, তুমরা হকলর ভার তো আমি একলা বইবার সাইধ্য নাই। ");
INSERT INTO syl_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","তুমরার মাবুদ আল্লায় তুমরারে অতো আওলাদ বাড়াই দিছইন, এরলাগি তুমরা আইজ আছমানর তেরার লাখান অইছো, গনিয়া ফুড়াইল যায় না। ");
INSERT INTO syl_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","তুমরার বাফ-দাদার মাবুদ আল্লায় তুমরারে আরো আজার আজার গুন বাড়াউক্কা, আর তান ওয়াদা মাফিক তুমরারে রহম-বরকত দেউক্কা। ");
INSERT INTO syl_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","অইলে আমি একলা কেমনে তুমরার কাইজ্জা-ফসাদ মিটাইতাম, আর তুমরার জিম্মাদারির ভার বইতাম? ");
INSERT INTO syl_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","এরলাগি তুমরার পরতেক খান্দান থাকি কয়জন আখলদার, জানরা-হুনরা আর হকল মানষর গেছে ইজ্জতি জনরে পছন্দ করো, আমি তুমরার জিম্মাদারি এরার আতো সমজাইমু। ");
INSERT INTO syl_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","“তুমরা জুয়াপ দিছলায়, আইচ্ছা, আপনে যেলা কইরা, অলাউ ভালা অইবো। ");
INSERT INTO syl_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","তেউ আমি তুমরার পরতেক খান্দান থাকি আখলদার, বুদ্ধিমান আর জানরা-হুনরা জনরে নিয়া তুমরার আজার জনর উপরে, শ জনর উপরে, পইঞ্চাশ জনর উপরে, দশ জনর উপরে সর্দার বানাই দিছলাম, আর অফিসারও বওয়াল করছলাম। ");
INSERT INTO syl_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","“হউ সময় আমি তুমরার হাকিম অকলরে হুকুম দিছলাম, কইছলাম, কাইজ্জা-ফসাদর বিচারো বাদি-বিবাদি দুইও পক্ষর মাত হুনিয়া হক ইনছাফ করিও, ইতা নিজর জাতির অউক বা ভিন জাতির অউক। ");
INSERT INTO syl_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","বিচারর সময় তুমরা কেউরর পক্ষ লইও না, ধনি-গরিব হকলর কথা হুনিও। আসলে বিচারর মালিক তো আল্লা, এরলাগি তুমরা কুনু মানষরে ডরাইও না। যে বিচারর মিমাংসা করা তুমরার লাগি কঠিন অয়, ইখান আমার গেছে আনিও, আমি দেখমু। ");
INSERT INTO syl_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","আর তুমরা কিলা কিতা করতায়, ইতা তো আমি হউ সময় কইয়া দিছলাম। ");
INSERT INTO syl_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","“বাদে আমরা মাবুদ আল্লার হুকুম পাইয়া, তুর পাহাড় ছাড়িয়া আমোরী অকলর পাহাড়িয়া এলাকা মুখা রওয়ানা অইলাম। তুমরা তো দেখছো, কত বড় আর কত মারাত্মক মরুভুমি পার অইয়া আমরা কাদেশ-বর্নেয়া আইয়া আজিলাম। ");
INSERT INTO syl_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","আজিয়া হারি আমি কইছলাম, অখন তো তুমরা আমোরী অকলর হউ পাহাড়িয়া এলাকাত আইয়া পৌছি গেছো, ই দেশখান আমরার মাবুদ আল্লায় আমরারে দিলাইরা। ");
INSERT INTO syl_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","হুনো, তুমরার মাবুদ আল্লার দান করা অউ আস্তা দেশউ তুমরার ছামনে পড়ি রইছে। অখন যাও, গিয়া তুমরার বাফ-দাদার মাবুদ আল্লার ওয়াদা করা অউ দেশরে দখল করো। কেউ ডরাইও না, নিরাশ অইও না। ");
INSERT INTO syl_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","“অউ সময় তুমরা হকল আইয়া আমারে কইলায়, তে পয়লা কয়জন গুইয়ারে অউ দেশো পাঠাইল অউক, তারা গিয়া দেশখান দেখিয়া আইয়া আমরারে কইবা, কুন পথে যাওয়া আমরার লাগি ভালা আর যাওয়ার পথো কুন কুন টাউন পড়বো। ");
INSERT INTO syl_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","“তুমরার পরামিশ আমার পছন্দ অইলো, এরলাগি পরতেক খান্দান থাকি একজন করি মোট বারো জনরে আলগ করলাম। ");
INSERT INTO syl_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","তারা তুমরারে অনো থইয়া অউ পাহাড়র উপরে উঠলো, আর আশকুল নামর পাহাড়িয়া খালো গিয়া ভালা করি হকলতা দেখিয়া আইলো। ");
INSERT INTO syl_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","তারা হউ দেশ থাকি কিছু ফল-মুল আনিয়া আমরারে দেখাইয়া কইলো, আমরার মাবুদ আল্লায় আমরারে যে দেশখান দান কররা, ইখান তো বড় ভালা জাগা। ");
INSERT INTO syl_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","“অইলে তুমরা অউ দেশো যাইতে রাজি অইলায় না। তুমরা নিজর মাবুদ আল্লার হুকুমর বিরুধিতা করলায়। ");
INSERT INTO syl_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","তুমরা যারযির তাম্বুত হামাইয়া বকা-জকা শুরু করলায়, আর কইলায়, মাবুদে আমরার লগে দুশমনি করইন, এরলাগিউ আমরারে বিনাশ করার নিয়তে, আমোরী অকলর আতো ফালাইয়া মারার খিয়ালে, মিসর দেশ থাকি তাইন আমরারে বার করি আনছইন। ");
INSERT INTO syl_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","আমরা কিলা হিনো যাইমু? আমরার গুইয়া ভাইয়াইন্তে আইয়া জানো ডর হারাই দিছইন। তারা কইছইন, হিনর মানুষ বুলে আমরা থাকি বউত উচা-মোটা পয়লোয়ান। তারার টাউন অকলও বড় বড়, ইতার চাইরোবায় উচা উচা ওয়াল দিয়া বাউন্ডরি করা, আছমানো ছইলার লাগের। আর পয়লোয়ান আনাকী অকলরেও বুলে হনো দেখছইন। ");
INSERT INTO syl_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","“ইতা হুনিয়া আমি তুমরারে কইছলাম, তুমরা মন ঘাবড়াইও না, ইতারে ডরাইও না। ");
INSERT INTO syl_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","তুমরার মাবুদ আল্লা তো তুমরার আগে আগে যাইরা। তাইন তুমরার পক্ষ লইয়া তুমরার চখুর ছামনে মিসর দেশো যেলা যুদ্ধ করছলা, অখনও অউলা করবা। ");
INSERT INTO syl_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","আর অউ মরুভুমির মাজেও তো তুমরা দেখছো, অনো আইয়া পৌছার আগ পর্যন্ত, বাফে যেলাখান আপন পুতরে কুলো করি বইয়া নেইন, অউলাখান আল্লা মাবুদে তুমরারেও আস্তা পথ বইয়া আনছইন। ");
INSERT INTO syl_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","অততা হুনার বাদেও তুমরা তান উপরে ভরসা করলায় না। ");
INSERT INTO syl_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","তাইনেউ তো তাম্বু গাড়িবার জাগা চিনানির লাগি আর পথ চিনাইয়া নিবার লাগি, রাইতকুর সময় আগুনির খুটি আর দিনকুর সময় মেঘর খুটির নমুনা অইয়া তুমরার আগে আগে গেছইন। ");
INSERT INTO syl_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","“অইলে তুমরার ইতা জুয়াপ হুনিয়া মাবুদে খুব গুছা করলা, তাইন কছম খাইয়া কইলা, ");
INSERT INTO syl_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","আমি মাবুদে তুমরার বাফ-দাদার গেছে কছম খাইছলাম অউ দেশখান দিতাম করি, তা-ও অখনকুর ইতা নাফরমান অকলে ই ভালা জাগা খান দেখার নছিব অইতো নায়, ");
INSERT INTO syl_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","খালি যিফুন্নির পুয়া কালুত ছাড়া। ইখান দেখার সৌভাইগ্য অউ কালুতে পাইবো, হে আমার কথারে পুরাপুর মানছে, হে যেতা জাগা পাওদি পাড়াইয়া আইছে, ইতা জাগা আমি তারে আর তার আওলাদ অকলরে দিমু। ");
INSERT INTO syl_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","“ভাইয়াইনরে, তুমরার কারনে মাবুদে আমার উপরেও গুছা করলা, গুছা করি আমারে কইলা, তুমি মুছাও হউ দেশো হামাইতায় পারতায় নায়। ");
INSERT INTO syl_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","খালি তুমার খাদিম নূনর পুয়া ইউছা গিয়া হনো হামাইবো। তুমি তারে সাওস দিও, হে বনি ইছরাইলরে ই দেশর দখলদারি দিয়া মালিক বানাইবো। ");
INSERT INTO syl_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","তুমরা কইছলায়, আমরার বেবুজ নাবালিক হুরুতাইন্তরে হউ দেশর মানষে ধরিয়া নিবোগি। অইলে আমি মাবুদে এরারেউ অউ কেনান দেশর মালিক বানাইমু, এরা ইখান দখল করবা। ");
INSERT INTO syl_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","তে অখন তুমরা হিরবার পিছাইয়া গিয়া নীল দরিয়ার পারেদি মরুভুমির বায় রওয়ানা দেও। ");
INSERT INTO syl_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","“ইখান হুনিয়া তুমরা কইছলায়, আমরা তো মাবুদর দরবারো গুনাগার অইগেছি। তা-ও আমরার মাবুদ আল্লার হুকুম মাফিক অখন গিয়া যুদ্ধ করমু। অখান কইয়া তুমরা অস্ত্র-শস্ত্র লইলায়, আর মনো করছলায়, পাহাড়ি এলাকাত উঠিয়া যুদ্ধ করাও খুব সুজা। ");
INSERT INTO syl_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","“অইলে মাবুদে আমারে কইলা, তুমি তারারে কও, তারা যানু যুদ্ধর লাগি পাহাড়ো না উঠে, কারন আমি তারার লগে রইতাম নায়, আর আমারে ছাড়িয়া যুদি তুমরার নিজর ইচ্ছায় যাও, তে দুশমনর গেছে আরিবায়। ");
INSERT INTO syl_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","আমি তুমরারে হুশিয়ারি দেওয়ার বাদেও তুমরা ইতা মানলায় না। তুমরা মাবুদর হুকুমর উল্টা গিয়া বুক ফুলাইয়া অউ পাহাড়ো উঠাত লাগলায়। ");
INSERT INTO syl_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","তেউ পাহাড়র বাসিন্দা আমোরী জাতিয়ে তুমরারে দেখিয়া পাল বান্দি বার অইলো, মউচাকর মউ-পুকর লাখান পাল বান্দিয়া তুমরার খরে খরে আইলো, আর মারতে মারতে সেয়ীরর হর্মা টাউন পর্যন্ত খেদাইয়া নিলো। ");
INSERT INTO syl_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","বাদে তুমরা আইয়া মাবুদর গেছে কান্দন লাগাইলায়, অইলে মাবুদে কান বন্দ করিল্লা, ই কান্দন হুনলা না। ");
INSERT INTO syl_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","অউ নমুনায় তুমরা বউত দিন কাদেশ এলাকাত রইলায়, লাম্বা সময় অনো গুজরিলো।” ");
INSERT INTO syl_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","হজরত মুছায় আরো কইলা, “মাবুদে আমারে যেলা হুকুম দিছলা, অউলা আমরা পিছাইয়া গিয়া মরুভুমির মাজেদি নীল দরিয়ার মুখা রওয়ানা দিলাম। সেয়ীরর পাহাড়িয়া এলাকা চক্কর দিয়া যাইতে আমরার বউত দিন গেলগি। ");
INSERT INTO syl_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","বাদে মাবুদে আমারে কইলা, ");
INSERT INTO syl_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","তুমরা বাক্কা দিন থাকি অউ পাহাড়িয়া এলাকাত চক্কর দিরায়, অখন উত্তর মুখা রওয়ানা দেও। ");
INSERT INTO syl_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","এরবাদে তাইন আমারে কইলা, আমি তুমরারে জানাইতাম তুমরা অখন শেখ ঈষʼর আওলাদর দখলে থাকা সেয়ীর দেশর ভিতরেদি যাইতে অইবো। গেলে তুমরারে দেখিয়া তারা ডরাইবা, অইলে তুমরা খুব হুশিয়ার রইও, এরা তো তুমরার ভাইয়াইন। ");
INSERT INTO syl_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","তারার লগে কাইজ্জা-ফসাদ করিও না। মনো রাখিও, তারার দেশর এক ইঞ্চি জমিও আমি তুমরারে দিতাম নায়। কারন আস্তা সেয়ীর পাহাড়র মালিকানা আমি শেখ ঈষʼরে দিলাইছি। ");
INSERT INTO syl_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","তারার অউ দেশ পার অইয়া যাইবার কালো তুমরার খানি-খুরাকি লাগলে টেকাদি লইয়া খাইবায়, অউলা পানিও লইয়া খাইবায়। ");
INSERT INTO syl_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","“তুমরার মাবুদ আল্লায় হকল কামর মাজেউ তুমরারে রহম-বরকত দিছইন। অউ অতো বড় মরুভুমি পারনির বালা তাইন তুমরারে হেফাজত করছইন। অউ চাল্লিশ বছর ধরি তুমরার মাবুদ আল্লা তুমরার লগে লগে আছইন, এরলাগি কুনু লাখান অভাব অইছে না। ");
INSERT INTO syl_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","“তেউ আমরা ফাতারি পথে আটিলাম, আটিয়া আমরার ভাই সেয়ীরর বাসিন্দা ঈষʼর আওলাদর দেশ ফালাইয়া গেলাম। আমরা আরাবা তলভুমির যে রাস্তা এলাত আর ইজিয়ন-গেবর থাকি বার অইয়া আইছে, অউ পথেদি না গিয়া মোয়াবর মরুভুমির মুখা আটা ধরলাম। ");
INSERT INTO syl_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","আর মাবুদে আমারে কইলা, তুমরা মোয়াবী অকলরে ছাতাইও না, কুনু যুদ্ধর ভাব-সাব দেখাইও না। মনো রাখিও, তারার দেশর কুনু জমিউ আমি তুমরারে দিতাম নায়। তারার রাজধানি আউর টাউনর মালিকানা আমি লুত নবীর আওলাদ মোয়াবী অকলরে দিলাইছি।” ");
INSERT INTO syl_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(আগে এইমী জাতির মানুষ অউ এলাকাত রইতা, ইতা আছলা পয়লোয়ান জাতি, তারা পরিমানে আছলা বউত জন, আর দেখতে আনাকী জাতির লাখান উচা-মোটা লাম্বা। ");
INSERT INTO syl_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","আনাকী অকলর লাখান এইমী অকলরেও রফায়ী নামে ডাকা অইতো, অইলে মোয়াবী অকলে ইতারে এইমী কইয়া ডাকিতা। ");
INSERT INTO syl_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","সেয়ীর পাহাড়ো হোরীয় অকলে বসত করতা, বাদে ঈষʼর আওলাদ অকলে তারারে খেদাইয়া দিয়া ইখান দখল করলা। মাবুদর আতে বনি ইছরাইলে যেলা কেনান দেশর মালিকানা পাইয়া কেনানী অকলরে খেদাইবা, ঠিক অলা ঈষʼর আওলাদ অকলেও করছলা। তারা হোরীয় অকলরে বিনাশ করিয়া হকল জমি-মাটি দখল করিয়া নিজে হনো বসত করলা।) ");
INSERT INTO syl_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","মুছা নবীয়ে আরো কইলা, “বাদে মাবুদে হুকুম দিলা, তুমরা জলদি করি রওয়ানা অও, আর জেরেদ পাহাড়িয়া খাল পার অইয়া হপারো যাও। তেউ আমরা পার অইলাম। ");
INSERT INTO syl_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","আর কাদেশ-বর্নেয়া থাকি বার অইয়া হারি জেরেদ গুল্লা পার অইয়া আইতে আমরার আটতিশ বছর লাগছিল। এরমাজে অউলা অইলো, মাবুদে আগে কছম খাইয়া যেলা কইছলা, অউলা কাদেশ-বর্নেয়া থাকি বারনির কালো আমরার যত সিপাই আছলা, এরা হকলউ অউ আটতিশ বছরে মরিগেলা। ");
INSERT INTO syl_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","বনি ইছরাইল সমাজ থাকি তারারে বিনাশ করার আগ পর্যন্ত মাবুদ তারার বিপক্ষে আছলা। ");
INSERT INTO syl_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","“অউ হকল সিপাই মরিয়া শেষ অইয়া হারলে, ");
INSERT INTO syl_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","মাবুদে আমারে কইলা, ");
INSERT INTO syl_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","আইজ তুমরা মোয়াবী অকলর দেশর সীমানা পার অইবায়, তারার রাজধানি আউর টাউনর কান্দাবায় যাইবায়। ");
INSERT INTO syl_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","অইলে তুমরা যেবলা বনি-আম্মান দেশর কাছাত যাইবায়গি, গিয়া তারারে ছাতাইও না, তারারে যুদ্ধর ভাব-সাব দেখাইও না। মনো রাখিও, তারার দেশর কুনু জাগাউ আমি তুমরারে দিতাম নায়, ইখানর মালিকানা তো আমি লুত নবীর আওলাদ বনি-আম্মানরে দিলাইছি।” ");
INSERT INTO syl_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(আগে রফায়ী অকল অনো রইতা, এরলাগি ইখানরে রফায়ী অকলর দেশ কইয়া ডাকা অইতো। আর বনি-আম্মানে ইতারে জাম-জামিমী কইয়া ডাকিতা। ");
INSERT INTO syl_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","রফায়ী জাতি পয়লোয়ান আছলা, দেখতে আনাকী জাতির লাখান উচা-মোটা লাম্বা আর পরিমানেও বউত বেশি আছলা। মাবুদে বনি-আম্মান জাতির আতো ইতারে বিনাশ করাইলা, বনি-আম্মানে রফায়ী জাতিরে খেদাই দিয়া অউ দেশ দখল করলা। ");
INSERT INTO syl_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","মাবুদে ঈষʼর আওলাদ অকলরেদি অউ একই কাম করাইলা, তাইন এরার আতো হোরীয় জাতিরে বিনাশ করলা। এরা হোরীয় অকলরে খেদাইয়া দিয়া, তারার সেয়ীর দেশ দখল করিয়া বসত কররা। ");
INSERT INTO syl_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","এরমাজে কপ্তোর দ্বীপ থাকি কপ্তোরী জাতিয়ে আইয়া অব্বী জাতিরে বিনাশ করলা, তারার মাটিরে দখল করিয়া বসত করলা। অউ অব্বী অকল গাজা টাউনর ধারো বসত করতা, হনর হকল গাউ-গেরামো তারা রইতা।) ");
INSERT INTO syl_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“এরবাদে মাবুদে কইছলা, ও বনি ইছরাইল, তুমরা বার অও, বার অইয়া অরনন খালর হপারো যাও। হুনো, আমোরী জাতির বাদশা সীহোন আর তার হিশবন দেশরে আমি তুমরার আতো সপি দিছি। ইখান দখল করাত গিয়া বাদশারে যুদ্ধর ফিল্ডো লামাও, ");
INSERT INTO syl_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","তেউ দেখবায়, আমি মাবুদে আইজ থাকি জগতর হকল জাতির দিলো ডর হারাই দিমু, তুমরার ডরে তারা কাপিবা। তুমরার আওয়াজ হুনলেউ তারার জানো ধড়ফড় শুরু অইবো।” ");
INSERT INTO syl_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","মুছা নবীয়ে বনি ইছরাইলরে আরো কইলা, “বাদে আমি শান্তি-চুক্তি করার খিয়ালে খাদিমোত মরুভুমি থাকি হিশবনর বাদশা সীহোনর গেছে খবরিয়া পাঠাইলাম, কইলাম, ");
INSERT INTO syl_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","আমরা আপনার দেশর ভিতরেদি পার অইয়া যাইতাম চাই, অনুমতি দিবা নি? আমরা আতারে-ফাতারে কুনুবায় যাইতাম নায়, খালি মুল সড়কেদি আটিয়া যাইমু। ");
INSERT INTO syl_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","29","আমরা নগদ টেকাদি আপনার গেছ থাকি খানি-খুরাকি বা পানিও খরিদ করিয়া খাইমু। আমরার মাবুদ আল্লায় আমরারে যে দেশখান দিতা চাইরা, জর্দান গাং পার অইয়া হউ দেশো যাইবার আগ পর্যন্ত, আপনার দেশর উপরেদি আমরারে আটিয়া যাইতে দেউক্কা। সেয়ীরর পাহাড়িয়া এলাকার বাসিন্দা ঈষʼর আওলাদ অকলে, আর আউর টাউনর বাসিন্দা মোয়াবী অকলেও আমরারে অলা পার অইতে দিছইন। ");
INSERT INTO syl_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","“অইলে হিশবনর বাদশা সীহোন রাজি অইলো না, আমরারে যাইতে দিলো না। তুমরার মাবুদ আল্লায়উ তার দিলরে পাষান বানাইল্লা, তার মনর ভাব লুয়ার লাখান অইগেল, যাতে তুমরার আতো তার বিনাশ অয়, আর ঠিকউ অলা অইলো। ");
INSERT INTO syl_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","তেউ মাবুদে আমারে কইলা, ও মুছা, সীহোন আর তার বাদশাইরে আমি তুমার আতো সপি দিলাম। অখন তুমি হনো যাও, গিয়া অউ দেশ দখলে আনাত লাগো, আর হনো বসত করো। ");
INSERT INTO syl_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","“তেউ ইয়াহাজ এলাকাত সীহোনে তার হকল সিপাই দল লইয়া আমরার লগে লাড়াই করাত আইলো, ");
INSERT INTO syl_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","অউ সময় আমরার মাবুদ আল্লায় তারে আমরার আতো ফালাইলা। আমরা বাদশারে, তার পুয়াইন্তরে, তার সিপাই দলরে নিপাত করলাম। ");
INSERT INTO syl_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","আর আমরা তার হকল টাউন, গাউ-গেরাম হকলতা দখল করলাম, তারার হকল বেটাইন-বেটিন আর হুরুতারে বিনাশ করলাম। একজনও জিন্দা রইছে না। ");
INSERT INTO syl_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","খালি তারার পশুর পাল আর গনিমতর মাল-ছামানা আমরার লাগি আনলাম। ");
INSERT INTO syl_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","অরনন খালর সীমানার আরোয়ার টাউন, আর অউ এলাকার এক গাউ থাকি আরক গাউ দখল করি করি, গিলিয়দ পর্যন্ত কুনু জাগা আমরার দখলর বাইরে রইলো না। আমরার মাবুদ আল্লায় ইতা হকলতা আমরার আতো দিলা। ");
INSERT INTO syl_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","খালি বনি-আম্মান জাতির দেশ, জাব্বোক পাহাড়িয়া খালর কান্দা-কাছার হকল জিলা, পাহাড়র উপরর গাউ-গেরাম, আর আমরার মাবুদ আল্লায় যেতা জাগা দখল করতে নিষেধ করছইন, অউ জাগা খানাইন তুমরার দখলর বাইরে রইলো।” ");
INSERT INTO syl_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","হজরত মুছায় বনি ইছরাইলরে আরো কইলা, “হিশবন দেশ থাকি আমরা বাশন দেশো যাওয়ার পথে রওয়ানা অইলাম। বাশনর বাদশা উজে খবর পাইয়া যুদ্ধ করার লাগি তার হকল সিপাই দল লইয়া ইদরি টাউনো আইলো। ");
INSERT INTO syl_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","আর মাবুদে আমারে কইলা, ও মুছা, ই বাদশারে তুমি ডরাইও না। হুনো, আমি তারে, তার আস্তা দেশরে, তার সিপাই দলরে তুমার আতো তুলিয়া দিলাইছি। তুমি হিশবন দেশো আমোরী জাতির বাদশা সীহোনর যে দশা ঘটাইছো, অগুরেও অউলা করিও। ");
INSERT INTO syl_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","“অউ নমুনায় আমরার মাবুদ আল্লায় বাশন দেশর বাদশা উজরে, তার হকল মানষরে আমরার আতো সমজাই দিলা। আমরাও ইতা হক্কলটিরে বিনাশ করলাম, কুনুগুরে জিন্দা রাখছি না। ");
INSERT INTO syl_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","আমরা তার দেশর হকল গাউ-গেরাম, টাউন-বন্দর দখল করলাম। তারার ষাইট খান টাউনউ দখল করিল্লাম, কুন্তা বাদ রইলো না। আস্তা অরগুব এলাকা, মানি বাশনর বাদশা উজর পুরা বাদশাই আমরার দখলো নিলামগি। ");
INSERT INTO syl_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","অউ টাউন অকলো উচা উচা ওয়াল দিয়া বাউন্ডরি করা আছিল, ইতার গেইটো আছিল বড় বড় খিল। আর বাউন্ডরি ছাড়াও বউত গাউ-গেরাম আছিল। ");
INSERT INTO syl_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","আমরা হকল টাউন আর গাউ-গেরামরে এক্কেবারে বিনাশ করছি। আগে হিশবনর বাদশা সীহোনর যে দশা ঘটাইছি, অখন বাশন দেশর বেটাইন-বেটিন, হুরুতাইন, হকল গাউ-গেরাম আর টাউনরেও একই লাখান বিনাশ করছি। ");
INSERT INTO syl_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","অইলে তারার হকল পশুর পাল আর গনিমতর মাল-ছামানা আমরা লইয়া আইছি। ");
INSERT INTO syl_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","“আমরা অউ সময় জর্দান গাংগর পুব পারর আমোরী জাতির দুইও বাদশার দখলর, অরনন খাল থাকি হর্মোন পাহাড় পর্যন্ত কবজা করছলাম। ");
INSERT INTO syl_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(সিদনর মানষে অউ হর্মোন এলাকারে সিরিয়ন কইয়া ডাকইন, আর আমোরী জাতিয়ে কইন ছনির।) ");
INSERT INTO syl_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","পাহাড়িয়া এলাকার অউ থল জাগার হকল টাউন আর গাউ-গেরাম, আস্তা গিলিয়দ এলাকা, বাদশা উজর ছুলখা আর ইদরি টাউন সহ আস্তা বাশন দেশরে আমরা দখল করলাম।” ");
INSERT INTO syl_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(পুরা রফায়ী জাতির মাজে খালি বাশন দেশর বাদশা উজ জিতা রইছলা। অউ বাদশা লুয়ার পালংগো হুতিতা, ইখান লাম্বায় নয় আত আর ফাড়ে চাইর আত। বনি-আম্মান জাতির রাব্বা টাউনো ইখান অখনও থওয়া আছে।) ");
INSERT INTO syl_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","হজরত মুছায় আরো কইরা, “আমরার দখল করা অরনন খালর পারো আরোয়ার টাউনর বাইরর উতরর এলাকা, আর পাহাড়িয়া গিলিয়দ এলাকার অর্ধেক জাগা, হনর হকল টাউন আর গাউ-গেরাম অকল, বনি ইছরাইলর রুবেন আর ছাদু খান্দানরে দিলাইলাম। ");
INSERT INTO syl_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","গিলিয়দ দেশর বাকি অংশ আর বাদশা উজর গেছ থাকি আনা আস্তা বাশন দেশরে আমি মানশা খান্দানর অর্ধেক মানষরে দিলাম।” (বাশন দেশর আস্তা অরগুব এলাকারে রফায়ী জাতির দেশ কইয়া ডাকা অইতো। ");
INSERT INTO syl_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","মানশা খান্দানর এক জনর নাম আছিল যায়ীর, হে আস্তা অরগুব এলাকা মানি, গশুরী আর মাখাতী জাতির সীমানা পর্যন্ত দখল করিয়া তার নিজর নামর মিলে অউ বাশন দেশর নাম দিলো হাব্বুত-যায়ীর। এরলাগি অখনও ইখানরে অউ নামে ডাকা অয়।) ");
INSERT INTO syl_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","“আর গিলিয়দর পাহাড়িয়া এলাকা আমি মাখীররে দিলাম। ");
INSERT INTO syl_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","অইলে গিলিয়দ থাকি অরননর পাহাড়িয়া খালর মাজামাজি পর্যন্ত হকল জাগা, আর হন থাকি বনি-আম্মান জাতির সীমানা জাব্বোক খাল পর্যন্ত আমি রুবেন আর ছাদু খান্দানরে দিলাম। ");
INSERT INTO syl_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","তারার দেশর পইচমর সীমানা আছিল, আরাবা মরুভুমিত জর্দান গাংগর যে অংশ গালিল আওরর ধারেদি, পিছগা নামর পাহাড়িয়া এলাকার আরাবা সাগর বা লোনা সাগর পর্যন্ত গেছে, অউ জাগা। ");
INSERT INTO syl_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","“অউ জাগা অখনাইন সমজাই দিয়া তারারে কইলাম, ইখনাইন ভোগ-দখল করার লাগি তুমরার মাবুদ আল্লায় তুমরারে দিছইন। অইলে তুমরার যেতা বেটাইন্তর শরিলো বল আছে, যেরা যুদ্ধ করার লাখ, এরা জুইত-জাইত অইয়া বনি ইছরাইলর আগে গিয়া গাং পার অও। ");
INSERT INTO syl_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","অইলে তুমরারে দেওয়া টাউন আর গাউ-গেরামো তুমরার বউ, পুয়া-পুড়িন আর গরু-ছাগল হকলতা রইবা। আমি জানি তুমরার বউত পশু আছইন। ");
INSERT INTO syl_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","বাদে মাবুদে যেবলা তুমরার জাতির ভাইয়াইনরে তুমরার লাখান আরামর জাগা দিলাইবা, তুমরার মাবুদ আল্লায় জর্দান গাংগর হপারো তারারে যে দেশ দান কররা, অখানর দখল পাইয়া হারলে, তুমরা হিরবার আমার দেওয়া অউ জাগাত ফিরিয়া আইও।” ");
INSERT INTO syl_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","হজরত মুছায় তারারে কইরা, “অউ সময় আমি ইউছারে কইলাম, তুমরার মাবুদ আল্লায় অউ দুইও বাদশার কুন দশা ঘটাইছইন, ইতা তো নিজর চউখে দেখছো। তে অখন জর্দান পার অইয়া তুমরা যত দেশাইন্তো যাইরায়, মাবুদে ইতা হক্কল দেশাইন্তর দশাও অউ লাখান ঘটাইবা। ");
INSERT INTO syl_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","এরলাগি তুমরা ইতারে ডরাইও না, স্বয়ং আল্লা মাবুদ তুমরার পক্ষ অইয়া তারার লগে যুদ্ধ করবা। ");
INSERT INTO syl_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","“আর অউ সময় আমি মাবুদর দরবারো আরজ করলাম, ");
INSERT INTO syl_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","ও মাবুদ মউলা, তুমার গুলামরে তো অখনউ দেখানি ধরছো, তুমি কত মহান আর কত বলবান। তুমি অউ যততা করছো, ইতা করার সাইধ্য কার আছে, আছমানো বা জমিনর কুনু দেবতার তাক্কত আছে নি, তুমার লাখান দাপট দেখাইতো? ");
INSERT INTO syl_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","মউলা গো, আমার বড় শখ অইলো, জর্দান গাংগর হপারো গিয়া তুমার ওয়াদা করা অউ সুন্দর পাহাড়িয়া এলাকা আর লেবানন দেশ দেখতাম, মেহেরবানি করি যাইতে দিবা নি? ");
INSERT INTO syl_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","অইলে মাবুদে না করলা, তাইন আমার আরজি হুনলা না, তুমরার কারনেউ তাইন আমার উপরে নারাজ আছলা। মাবুদে জুয়াপ দিলা, তুমি বউত কইছো, ই বেয়াপারে আর মাংগিও না। ");
INSERT INTO syl_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","আইচ্ছা, তুমি অউ পিছগা টিল্লার উপরে উঠো, উঠিয়া উতরে-দউকনে আর পুবে-পইচমে চউখ ফালাও। জর্দান গাং পারনি নিষেধ অইলেও, অন থাকি উবাইয়া হউ দেশরে দেখিলাও। ");
INSERT INTO syl_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","আর তুমার খাদিম ইউছারে হিকাই দেও, কিতা কিতা করা লাগবো। তার হিম্মত বাড়াও, ভিতরে সাওস দেও, কারন হকল মানষর আগে রইয়া হে গাং পার করাইবো, আর তুমি অন থাকি যে দেশ দেখরায়, হে এরারেদি অউ দেশ দখল করাইবো। ");
INSERT INTO syl_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","অখান হুনিয়া আমরা বায়ত-পিয়োরর ছামনর নিচা জাগাত রইগেলাম।” ");
INSERT INTO syl_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","হজরত মুছায় তারারে কইলা, “ও বনি ইছরাইল, আমি অখন যে শরিয়ত আর হুকুম-আহকাম কইমু, ইতা তুমরা খিয়াল করি হুনো। তেউ তুমরা জানে বাচবায় আর তুমরার বাফ-দাদার মাবুদ আল্লায় তুমরারে যে দেশ দান কররা, হউ দেশো গিয়া দখল করতায় পারবায়। ");
INSERT INTO syl_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","আমি তুমরারে যে হুকুম দিয়ার, ই হুকুমর লগে দুছরা কুন্তা বাড়াইও না বা কমাইও না। আমি যেলাখান কইরাম, তুমরা ঠিক অলাউ তুমরার মাবুদ আল্লার হকল হুকুম-আহকাম মানিয়া চলিও। ");
INSERT INTO syl_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","“তুমরা তো নিজর চউখে দেখছো, আগে মাবুদে বাআল-পিয়োরর বেয়াপারে কিতা করছইন। তুমরার মাজর যত জনে পিয়োর এলাকার বাআল দেবতার পুজা করছিল, আল্লা মাবুদে তুমরার ছামনে ইতা হক্কলটিরে বিনাশ করছইন। ");
INSERT INTO syl_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","অইলে তুমরা যেরা দিলে-জানে আল্লা মাবুদর আশিক আছলায়, তুমরা হকলউ অখনও জিন্দা রইছো। ");
INSERT INTO syl_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","“অখন হুনো, আমার মাবুদ আল্লায় আমারে যেলাখান হুকুম-আহকাম দিছলা, আমি তুমরারে ঠিক অউ হুকুম-আহকাম আর নিয়ম-কানুন হিকাইছি। যাতে তুমরা অখন যে দেশ দখল করাত যাইরায়, হউ দেশো ইতা কামো লাগাও। ");
INSERT INTO syl_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","এরলাগি তুমরা খুব হুশিয়ার অইয়া ইতা মানিও, আর কামো লাগাইও। তেউ বাদ-বাকি তামাম জাতির গেছেউ ইতা তুমরার আখল-বুদ্ধি হিসাবে জাইর অইবো। অউ হুকুম-আহকামর কথা হুনলে তারা কইবা, হাছাউ এরা খুব বড় জাতি আর আখল-বুদ্ধি আলা জাতি। ");
INSERT INTO syl_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","আর আমরার মাবুদ আল্লা যেলা আমরার লগে লগে রইন, তানরে ডাকিলে যেলা ধারো পাই, অউ দুনিয়ার বুকুত দুছরা কুনু বড় জাতি আছইন নি, যেতার দেবতা অলা লগে লগে রইন? ");
INSERT INTO syl_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","বা আমি অখন যে শরিয়তর কথা কইরাম, ইতা দুছরা কুনু বড় জাতির আছে নি? ইলা নিয়ম-কানুন আর নিখুত হুকুম-আহকাম তারার আছে নি? ");
INSERT INTO syl_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","“অইলে তুমরা যতদিন বাচিয়া রইবায়, অতদিন নিজর বেয়াপারে খুব হুশিয়ার রইও, নিজর দিলরে সাবধানে রাখিও, আরনায় নিজর চখুর দেখা ঘটনা অকল ফাউরিলিবায়, ইতা তুমরার দিল থাকি খুয়াইলিবায়। আর অউ হুকুম-আহকাম তুমরার পুয়া-পুড়িনরে হিকাও, তারাও অলা তারার আওলাদরে হিকাইবা। ");
INSERT INTO syl_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","আর তুমরা হউ দিনর ঘটনা মনো করো, যে দিন তুমরা তুর পাহাড়ো আপন মাবুদ আল্লার ছামনে আজির অইছলায়। যেবলা তাইন আমারে কইছলা, আমার কালাম হুনার লাগি তুমি হক্কল মানষরে দলা করিয়া আমার ছামনে আনো, তেউ তারা হিকবা, ই জগতো তারা যতদিন জিন্দা রইবা, অতদিন আমারে ডরাইয়া রইতা, আর তারার হুরুতাইনরেও অলা চলার তালিম দিতা। ");
INSERT INTO syl_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","অউ সময় তুমরা কান্দাত গিয়া অউ পাহাড়র লামাত উবাইছলায়, উবাইয়া দেখলায়, আস্তা পাহাড়ো দাউ দাউ করি নুরর আগুইন জলের, আগুইনে গিয়া আছমান ছইলিছে, আর গইন ঘনো মেঘর কালনিয়ে আন্দাইর আছিল। ");
INSERT INTO syl_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","হউ নুরর আগুনির ভিতরে থাকি, মাবুদে তুমরারে তান কালাম হুনাইলা। তুমরা তান মুখর আওয়াজ হুনলায়, অইলে তান কুনু ছুরত-আকার দেখাইছইন না, খালি তান গলার আওয়াজ হুনছো। ");
INSERT INTO syl_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","তাইন নিজে তুমরারে তান লগে মিলনর উছিলার আল্লাই ওয়াদা-চুক্তির খাছ দশটা হুকুম-আহকাম দিলা, আর কইলা অগুইন মানিয়া চলার লাগি। তান কুদরতি আতে দুই টুকরা পাথরর উপরে ইতা লেখিয়াও দিলা। ");
INSERT INTO syl_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","হউ সময় মাবুদে আমারে হুকুম দিলা, আমি তুমরারে তান শরিয়তর হুকুম-আহকাম হিকাইতাম, যাতে জর্দান গাংগর হপারো তুমরা যে দেশ দখলো যাইরায়, হনো গিয়া হারলে অতা মানিয়া চলো। ");
INSERT INTO syl_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","“মাবুদে যেবলা নুরর আগুনির মাজ থাকি তুর পাহাড়ো তুমরার লগে বাতচিত করছলা, হউ দিন তো তুমরা তান কুনু ছুরত-আকার দেখছো না। এরলাগি তুমরা নিজর বেয়াপারে খুব হুশিয়ার রইও ");
INSERT INTO syl_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","যাতে কুনু মুর্তি না বানাও, বে-পথি বনিয়া পুজা করার খিয়ালে কুনু বেটা বা বেটির ছুরতে মুর্তি বানাইও না। ");
INSERT INTO syl_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","মাটির উপরে চলরা কুনু জীব-জানুয়ারর ছুরতে, আছমানো উড়রা কুনু পাখির ছুরতে, ");
INSERT INTO syl_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","বুক ছেচরাইয়া চলরা কুনু জানদারর ছুরতে, বা পানিত রওরা কুনু জানদারর ছুরতে মুর্তি বানাইও না। ");
INSERT INTO syl_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","আছমানেদি চাইয়া হারি চান্দ, সুরুজ, তেরা অকল দেখিয়া অউ নামর দেব-দেবী বা ফিরিস্তার পুজা করিও না, এরার খেজমতো লাগিও না। ইতারে তো তুমরার মাবুদ আল্লায় আছমানর তলর হকল জাতির লাগি দান করছইন। ");
INSERT INTO syl_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","মনো রাখিও, মাবুদে তুমরারে পছন্দ করছইন লুয়া গলানির গরম আগুনির গাতো থাকি, তাইন মিসর দেশ থাকি তুমরারে বার করি আনছইন, যাতে তুমরা তান আপন প্রজা অও, আর অখন তো হাছাউ তান প্রজা অইছো। ");
INSERT INTO syl_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","“ও বনি ইছরাইল, তুমরার কারনে মাবুদে আমার উপরেও গুছা করছইন। তাইন কছম খাইয়া কইছইন, আমারে জর্দান গাংগর হপারো যাইতে দিতা নায়, তুমরার মাবুদ আল্লায় তুমরারে যে দেশর মালিকানা দিরা, অউ আরামর দেশো আমার যাওয়া নিষেধ। ");
INSERT INTO syl_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","আমার মউত অনোউ অইবো। জর্দান গাং পারনির হুকুম নায়। অইলে তুমরা গাং পার অইয়া হউ আরামর দেশ দখল করাত যাইরায়। ");
INSERT INTO syl_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","তে তুমরা নিজর বেয়াপারে হুশিয়ার রইও, তুমরার মাবুদ আল্লায় তুমরার লগে যে ওয়াদা-চুক্তি কাইম করছইন, ইতা ফাউরিও না। তুমরার মাবুদ আল্লার নিষেধ অমাইন্য করিয়া কুনু জিনিসর মুর্তি বানাইও না। ");
INSERT INTO syl_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","মনো রাখিও, তুমরার মাবুদ আল্লা তো মহা ধ্বংসর আগুনির লাখান, তাইন তো লা-শরিক, কুনু শরিক সইয্য করইন না, তান নিজর পাওনা এবাদত চাইনউ চাইন।” ");
INSERT INTO syl_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","হজরত মুছায় তারারে এওখান কইলা, “হউ আরামর দেশো গিয়া হারি, তুমরা পুয়া-পুড়িন, নাতি-পুতির জনম দিয়া বউত দিন বসত করার বাদেও যুদি কু-পথে যাওগি, আর কুনু জিনিসর ছুরতে মুর্তি বানাও, তুমরার মাবুদ আল্লায় যেতারে ঘিন্না করইন, তুমরা অতা করো, ");
INSERT INTO syl_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","তে আমি অখন আছমান-জমিন সাক্ষি রাখিয়া তুমরার বিরুদ্ধে কইয়ার, জর্দান গাং পার অইয়া যে দেশ দখল করাত যাইরায়, হিনো খুব জলদি তুমরার নাম মিটিযিবো। বেশি দিন টিকতায় পারতায় নায়, নিচ্চিত বিনাশ অইবায়। ");
INSERT INTO syl_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","মাবুদে তুমরারে নানান জাতির মাজে ছিতরাই দিবা, তাইন খেদাই দিয়া যেখানো পাঠাইবা, হনো তুমরার খুব কম মানুষ জিন্দা রইবা। ");
INSERT INTO syl_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","অউ হালতে তুমরা মানুষ-আতে বানাইল মুর্তির পুজা করবায়, যেতায় চউখে দেখে না, কানে হুনে না, খাইতো পারে না, কুনুজাত ঘেরানও হুংগিতো পারে না, লাকড়ির আর পাথরর অতা মুর্তির পুজা করবায়। ");
INSERT INTO syl_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","তা-ও হনো রইয়া যুদি তুমরা নিজর মাবুদ আল্লার তালাশ করো, তে তাইন তুমরারে দিদার দিবা। কথা অইলো, দিলে-জানে কাতর অইয়া তানে ডাকিতে অইবো। ");
INSERT INTO syl_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","হেশ-মেশ তুমরা মছিবতো পড়িয়া হিরবার তৌবা করিয়া, তুমরার মাবুদ আল্লার নাম লইবায়, আর তান খুশি মাফিক চলবায়। ");
INSERT INTO syl_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","মনো রাখিও, তুমরার মাবুদ আল্লা রহমানুর রহিম, তাইন তুমরারে ফালাইতা নায় বা বিনাশ করতা নায়। আর তাইন কছম খাইয়া তুমরার ময়-মুরব্বির লগে যে ওয়াদা-চুক্তি করছইন, ইতাও ফাউরিতা নায়।” ");
INSERT INTO syl_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","হজরত মুছায় তারারে এওখান কইরা, “আল্লা পাকে জমিনো মানুষ পয়দা করার বাদ থাকি অখন পর্যন্ত, তুমরার আগর হক্কল জমানার ইতিহাস তুকাও, আস্তা আছমান-জমিনর এক মাথা থাকি আরক মাথা তুকাইয়া দেখো, বনি ইছরাইলর উপরে যত আজব ঘটনা ঘটিছে, ইতা লাখান দুছরা কুনু ঘটনা ঘটছে নি? বা ইলা কুন্তা কুনুদিন হুনা গেছে নি? ");
INSERT INTO syl_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","আর নুরর আগুইন থাকি আল্লা পাকর বুলি হুনার বাদে, খালি তুমরা ছাড়া দুছরা কুনু জাতি জিন্দা রইছে নি? ");
INSERT INTO syl_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","তুমরা তালাশ করি দেখো, তুমরার মাবুদ আল্লায় তুমরার চখুর ছামনে মিসর দেশো তুমরার লাগি যততা করছইন, আস্তা জগতর কুনু দেব-দেবীয়ে ইলা করতো পারছে নি? ইলা পরিক্ষা লওয়া, কুদরতি নিশানা দেখানি, লাড়াই-যুদ্ধ করা, মজবুত আতর বল দেখানি, বড় বড় তাইজ্জুবি লিলা-খেলা আর ডর-খফ দেখাইয়া, যেকুনু জাতিরে অইন্য জাতির ভিতরে থাকি বার করি আনিয়া নিজর প্রজা বানাইতো পারছে নি? ");
INSERT INTO syl_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","“তে তুমরা যাতে পুরাপুর বুজো, অউ আল্লাউ অইলা মাবুদ, তাইন ছাড়া আর কুনু মাবুদ নাই, অখান বুজানির লাগিউ তুমরারে অততা দেখানি অইছিল। ");
INSERT INTO syl_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","তুমরারে হেদায়ত করার খিয়ালে তাইন বেহেস্তর আরশ থাকি তান নিজর বুলি হুনাইলা, আর জমিনর উপরে দেখাইলা নুরর আগুনির কুন্ডলি। অউ আগুনির মাজ থাকি বারইল আল্লাই বুলি তুমরা হুনছো। ");
INSERT INTO syl_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","তাইন তুমরার ময়-মুরব্বি অকলরে মহব্বত করতা, এরলাগি এরার মউতর বাদে তারার আওলাদ অকলরেও পছন্দ করছইন। আর তাইন স্বয়ং আজির অইয়া তান মহা কুদরতি খেমতা খাটাইয়া তুমরারে মিসর দেশ থাকি বার করি আনছইন। ");
INSERT INTO syl_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","তান খিয়াল আছিল, তুমাতান থাকি বড় আর বলবান জাতি অকলরে তুমরার ছামন থাকি খেদাইয়া হারি, তারার দেশো নিয়া হউ হকল দেশর মালিকানা তুমরারে দিতা। অখন দেখরায় নি, তাইন তো ইতা করছইন। ");
INSERT INTO syl_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","“তে অখনকুর অউ তালিম মনো রাখিও, দিলর মাজে গাথিয়া থইও, হুনো, খালি অউ আল্লাউ উপরে আছমান আর তলে জমিনর মালিক, তাইন ছাড়া দুছরা কুনু মাবুদ নাই। ");
INSERT INTO syl_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","এরলাগি আমি অখন যে শরিয়ত আর হুকুম-আহকাম জানাইরাম, তুমরা ইতা মানিয়া চলিও, তেউ তুমরা আর তুমরার আওলাদ অকলর ভালাই অইবো। তুমরার মাবুদ আল্লায় চিরকালর লাগি তুমরারে যে দেশ দান কররা, অউ দেশো তুমরার হায়াতি লাম্বা অইবো।” ");
INSERT INTO syl_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","বাদে মুছা নবীয়ে জর্দান গাংগর পুব-পারর তিনখান টাউন আলগাইলা, ");
INSERT INTO syl_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","যাতে কুনু খুনি মানুষ বাগিয়া গিয়া অউ টাউনো জান বাচাইতো পারে। যে মানষে খুন করার কুনু চিন্তা বা দুশমনি ভাব আছিল না, খালি আখতা অনিচ্ছায় কেউররে মারিলায়, হে বাগিয়া বনবাসি বনিয়া অনো রইতো পারবো। ");
INSERT INTO syl_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","তিনো টাউন অইলো, রুবেন খান্দানর লাগি মরুভুমির কিনারার পাহাড়িয়া থল জাগার বাছির নামর টাউন। ছাদু খান্দানর লাগি গিলিয়দ এলাকার রামোত টাউন। মানশা খান্দানর লাগি বাশন দেশর গোলান টাউন। ");
INSERT INTO syl_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","মুছা নবীয়ে বনি ইছরাইলর ছামনে শরিয়তর অউ হুকুম বয়ান করলা, ");
INSERT INTO syl_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","মিসর দেশ থাকি বার অইয়া আওয়ার বাদে, হকল হুশিয়ারির কথা, শরিয়তর নিয়ম-কানুন আর হুকুম-আহকাম বনি ইছরাইলরে জানাইলা। ");
INSERT INTO syl_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","তাইন জর্দান গাংগর পুবর পারো, হিশবন এলাকার আমোরী জাতির রাজা সীহোনর দেশর বায়ত-পিয়োরর ছামনর তল জাগাত ইতা কইলা। মিসর থাকি বার অইয়া আইয়া হারলে মুছা নবীয়ে আর বনি ইছরাইলে যুদ্ধ করি অউ বাদশা সীহোনরে আরাইছলা। ");
INSERT INTO syl_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","তারা বাদশা সীহোনর দেশ আর বাশনর বাদশা উজর দেশ দখল করছলা। আমোরী জাতির অউ দুইও বাদশার বাদশাই আছিল জর্দান গাংগর পুবর পারো। ");
INSERT INTO syl_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","অরনন খালর পারর আরোয়ার টাউন থাকি সিরিয়ন পাহাড়, মানি হর্মোন পাহাড় পর্যন্ত অউ দুইও রাজার সীমানা আছিল। ");
INSERT INTO syl_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","এর ভিতরে আছে জর্দান গাংগর পুবর পারর আস্তা এলাকা। ইকটা পিছগা পাহাড়র টিল্লার তলেদি আরাবা সাগরর কিনারা পর্যন্ত গেছে। ");
INSERT INTO syl_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","মুছা নবীয়ে তামাম বনি ইছরাইলরে দলা করাইলা, তারারে কইলা, “ও বনি ইছরাইল, আমি অখন যেতা হুকুম-আহকাম আর আইন-কানুন তুমরারে জানাইমু, ইতা তুমরা খিয়াল করি হুনিও, হুনিয়া দিলো গাথিয়া রাখিও আর আমল করিও। ");
INSERT INTO syl_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","আমরার মাবুদ আল্লায় তুর পাহাড়ো আমরার লগে এক ওয়াদা-চুক্তি বওয়াল করছইন। ");
INSERT INTO syl_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","অউ চুক্তি তাইন আমরার ময়-মুরব্বির লগে না করিয়া, আমরার লগে করছইন, আমরা যত জন অনো জিন্দা আছি, আমরার লগে করছইন। ");
INSERT INTO syl_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","মাবুদে অউ পাহাড়র উপরে নুরর আগুনির মাজ থাকি তুমরার লগে ছামনা-ছামনি বাতচিত করছইন। ");
INSERT INTO syl_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","তুমরা আগুনির ডরে হউ সময় পাহাড়র উপরে উঠলায় না, এরলাগি আমি তুমরা আর মাবুদর মাজখানো উবাইয়া, তান মুখর বুলি তুমরারে হুনাইছি। তাইন কইছলা, ");
INSERT INTO syl_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“আমি আল্লাউ তুমরার মাবুদ। মিসর দেশর গুলামি থাকি আমিউ তুমরারে খালাছ করি আনছি। ");
INSERT INTO syl_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“আমার বদলা তুমরা দুছরা কুনু দেবতা মানিও না। ");
INSERT INTO syl_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","“পুজা করার খিয়ালে তুমরা কুনু মুর্তি বানাইও না, আছমান, জমিন বা পানির তলে যততা আছে, ইতা কুনুতার ছুরতে মুর্তি বানাইও না। ");
INSERT INTO syl_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","তুমরা ইতার পুজা করিও না, ইতার সেবা-যতন করিও না। মনো রাখিও, আমি আল্লাউ তুমরার মাবুদ, কুনু শরিক সইয্য করি না। আমারে যেরা মানে না, আমি তারার গুনার সাজা দেই, তারার পয়লা ছিড়ি থাকি চাইর ছিড়ি আওলাদ পর্যন্ত সাজা দেই। ");
INSERT INTO syl_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","অইলে যেরা আমার আশিক বনিয়া আমার হুকুম-আহকাম আমল করে, আমি তারার আজার আজার ওয়ারিশ পর্যন্ত আমার অবিরাম মায়া-মহব্বত দেখাইমু। ");
INSERT INTO syl_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","“বেকামা কুনু কারনে তুমরার মাবুদ আল্লার নাম মুখো লইও না। কেউ যুদি খামোখা মাবুদর নাম লয়, তে কুনুমন্তেউ আমার সাজা থাকি রেহাই পাইতো নায়। ");
INSERT INTO syl_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","“আর তুমরার মাবুদ আল্লার হুকুম মাফিক, জুম্মাবাররে পবিত্র দিন মানিও। ");
INSERT INTO syl_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","হাপ্তার ছয়দিন তুমরা কাম-কাজ করিও, তুমরার দরকারি হকল কাম সারিও। ");
INSERT INTO syl_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","অইলে সাত নম্বর দিন অইলো জুম্মাবার, তুমরার মাবুদ আল্লার নামে জিরাইবার দিন। ই দিন তুমরা, তুমরার পুয়া-পুড়িন, গুলাম-বান্দিন, গরু-গাধাইন, তুমরার গাউত বা টাউনো রওরা মুছাফির বা ভিন-দেশি, কেউ কুনুজাতর কাম-কাজ করিও না। তুমার গুলাম-বান্দিয়েও তুমার লাখান জিরাইবা। ");
INSERT INTO syl_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","মনো রাখিও, মিসর দেশো থাকতে তুমরাও অলা গুলাম আছলায়, আর তুমরার মাবুদ আল্লায় তান বলআলা-মজবুত কুদরতি আতদি তুমরারে আজাদ করি আনছইন। এরলাগি তাইন হুকুম দিছইন, তুমরা জুম্মাবাররে পবিত্র দিন মানতায়। ");
INSERT INTO syl_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","“তুমরার মাবুদ আল্লার হুকুম মাফিক তুমরার মা-বাফরে ইজ্জত করিও। তেউ তুমরার মাবুদ আল্লায় যে দেশ দিরা, হউ দেশো তুমরার হায়াতি বাড়িবো আর তুমরার ভালাই অইবো। ");
INSERT INTO syl_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","“খুন করিও না। ");
INSERT INTO syl_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","“জিনা করিও না। ");
INSERT INTO syl_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","“চুরি করিও না। ");
INSERT INTO syl_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","“কেউরর বিরুদ্ধে মিছা সাক্ষি দিও না। ");
INSERT INTO syl_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","“পরর বউর বায় লালছ করিও না। পরর ঘর-বাড়ি, জমি-মিরাস, গুলাম-বান্দি, গরু-গাধা, বা কুনু জিনিসর বায় লালছ করিও না। ");
INSERT INTO syl_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","“মনো রাখিও, স্বয়ং মাবুদে তুমরারে তুর পাহাড়র উপরর হউ নুরর আগুইন থাকি, মেঘর কালনি আর গইন আন্দারির ভিতরে থাকি, খুব জুরে জুরে অউ হুকুম দিছইন। খালি অউ হুকুম-আহকাম ছাড়া তুমরারে আর কুনুতা কইছইন না। বাদে অউ কালাম অকলরে দুই টুকরা পাথরর উপরে তান কুদরতি আতে লেখিয়া আমার আতো দিছলা। ");
INSERT INTO syl_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","অইলে তান নুরর তজল্লিয়ে যেবলা পাহাড় জলের, এরমাজে তুমরা নিজর কানে হুনলায়, হউ আন্দারির ভিতরে থাকি মাবুদর গলার আওয়াজ, হুনিয়া তুমরার হকল খান্দানর আমির অকল, তুমরার ময়-মুরব্বি অকল আমার গেছে উঠিয়া আইলা, ");
INSERT INTO syl_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","আইয়া কইলা, আমরার মাবুদ আল্লায় দিদার দিয়া তান জালাল আর মহিমা আমরারে দেখাইছইন, নুরর আগুইন থাকি বারইল তান গলার আওয়াজ আমরা হুনছি। আর অখন আমরা বুজলাম, কুনু আদম জাতে আল্লা পাকর লগে বাতচিত করার বাদেও, ই আদম বাচিয়া রয়। ");
INSERT INTO syl_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","অইলে অখন কেনে আমরা ইনো মরতাম? কুদরতি ই আগুইনে তো আমরারে জালাইলিবো, আমরা যুদি আরো বেশ করি আমরার মাবুদ আল্লার গলার আওয়াজ হুনাত রই, তে তো নির্গাত মরন অইবো। ");
INSERT INTO syl_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","আমরার লাখান ইলা আর কুনু আদম জাত আছইন নি, যেরা নুরর আগুইন থাকি জিন্দা আল্লা পাকর গলার আওয়াজ হুনার বাদেও জিতা আছে? ");
INSERT INTO syl_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","তে আমরার মাবুদ আল্লায় যততা বাতাইছইন, তান কান্দাত গিয়া আপনেউ অতা হুনিয়া আইউক্কা। তাইন আপনার গেছে যেতা জানাইবা, আপনে আইয়া অতা আমরারে হুনাইবা। তেউ আমরা অতা আমল করমু। ");
INSERT INTO syl_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","“আর হউ সময় তুমরা যেবলা আমার লগে মাতিরায়, স্বয়ং মাবুদে ইতা হুনলা, হুনিয়া আমারে কইলা, অউ মানুষ অকলর মাত-কথা তো আমি হুনছি, তারা তুমারে যেতা কইছইন ইতা হকলতাউ ভালা। ");
INSERT INTO syl_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","হাছাউ যুদি তারা আমারে অলা ডরাইন, হামেশা আমার হুকুম-আহকাম মানিয়া চলার খিয়ালি অইন, তে তারা আর তারার আওলাদ অকলর চিরকালিন ভালাই অইবো। ");
INSERT INTO syl_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","“অখন তুমি লামাত যাও আর তারারে কও, তারার তাম্বুত ফিরিয়া যাইতাগি। ");
INSERT INTO syl_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","অইলে তুমি অনো আমার কান্দাত রইও। আমি তুমারে আমার হকল হুকুম-আহকাম, আইন-কানুন আর শরিয়ত বাতাইমু, তুমি গিয়া তারারে অতা হিকাইবায়। তেউ আমি তারারে যে দেশর দখলদারি দিয়ার, হউ দেশো গিয়া হারি তারা অতা আমল করবা। ");
INSERT INTO syl_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","“এরলাগিউ তুমরার মাবুদ আল্লায় তুমরারে যেতা হুকুম-আহকাম দিছইন, ইতা যতন করিয়া আদায় করিও, ইতার তিল পরিমান হের-ফের করিও না। ");
INSERT INTO syl_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","তাইন যে পথে চলার লাগি হুকুম দিছইন, ঠিক অউ পথে চলিও, তেউ তুমরা জানে বাচবায়, তুমরার ভালাই অইবো, আর তুমরা যে দেশর দখলদারি পাইবায়, হউ দেশো তুমরার হায়াতি বউত লাম্বা অইবো। ");
INSERT INTO syl_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","“তুমরারে হিকানির নিয়তে তুমরার মাবুদ আল্লায় আমারে অউ হুকুম-আহকাম, শরিয়ত আর আইন-কানুন দিছইন, যাতে হউ যে দেশ দখল করার নিয়তে তুমরা জর্দান গাং পার অইয়া যাইরায়, হনো গিয়া হারি তুমরা ইতা আমল করো। ");
INSERT INTO syl_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","তেউ তুমরা, তুমরার হুরুতাইন আর তারার আওলাদ অকলে হারা জিন্দেগি আল্লা মাবুদরে ডরাইয়া তান দেওয়া নিয়ম আর হুকুম অকল আমল করিও। অলা করলে তুমরা বউত দিন বাচিয়া রইবায়। ");
INSERT INTO syl_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","ও বনি ইছরাইল, তুমরা আমার কথা হুনো আর হুশিয়ার অইয়া ইতা আমল করো, তেউ তুমরার বাফ-দাদা অকলর মাবুদ আল্লার ওয়াদা মাফিক, হউ দুধ আর মউর ভান্ডার আলা দেশো তুমরার ভালাই অইবো আর তুমরা বউত বাড়িবায়। ");
INSERT INTO syl_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","“ও বনি ইছরাইল, হুনো, আল্লা আমরার মাবুদ, তাইনউ এক। ");
INSERT INTO syl_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","তুমরা পরতেকে তুমরার আস্তা দিল, আস্তা জান আর হকল বল-শক্তি দিয়া তুমরার মাবুদ আল্লারে মহব্বত করিও। ");
INSERT INTO syl_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","আইজ আমি তুমরারে যে হুকুম দিয়ার, ইতা তুমরার দিলো গাথিয়া রাখিও। ");
INSERT INTO syl_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","তুমরা হকলে তুমরার হুরুতাইনরে ইতা খিয়াল করি হিকাইও। আর ঘরো বইয়া, পথে-ঘাটে চলার সময়, ঘুমানির সময়, ঘুম থাকি উঠার বাদেও অতা বেয়াপারে মাতা-মাতি করিও। ");
INSERT INTO syl_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","মনো রাখার নিশানা হিসাবে ইতা আতো বান্দিয়া রাখিও আর কপালর মাজে লাগাইও। ");
INSERT INTO syl_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","তুমরার দুয়ারর চৌকাঠো আর মুল গেইটো লেখিয়া রাখিও। ");
INSERT INTO syl_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","“তুমরার বাফ-দাদা ইব্রাহিম, ইছহাক আর ইয়াকুবর গেছে তুমরার মাবুদ আল্লায় কছম খাইয়া যে দেশ দেওয়ার ওয়াদা করছইন, হউ দেশ তাইন তুমরারে নিবা। হিনো সুন্দর সুন্দর আর বড় বড় টাউন অকল আছে, যেতা তুমরা বানাইছো না, খালি এমনেউ পাইবায়। ");
INSERT INTO syl_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","আর মাল-ছামানায় ভরা হাজাইল-পাড়াইল ঘর-দুয়ার পাইবায়, যেতা তুমরা যুগাইছো না, পানির কুয়া পাইবায় যেতা তুমরা খুদিছো না, আংগুরর বাগান আর জয়তুনর বাগান পাইবায় যেতা তুমরা লাগাইছো না। ");
INSERT INTO syl_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","অইলে তুমরা হুশিয়ার রইও, ইতা হকলতা পাইয়া হারি মালদার বনিয়া তুমরার হউ আল্লা মাবুদরে ফাউরিও না, যেইন তুমরারে মিসর দেশর গুলামি থাকি খালাছ করিয়া আনছইন। ");
INSERT INTO syl_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","“তুমরার মাবুদ আল্লারে ডরাইয়া চলিও, খালি তান এবাদত করিও, আর তান নামে কছম খাইও। ");
INSERT INTO syl_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","তুমরা আরি-ফরি জাতির দেব-দেবীর পুজা করিও না। ");
INSERT INTO syl_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","জানো তো, তুমরার মাবুদ আল্লা যেইন তুমরার লগে আছইন, তাইন তো লা-শরিক মাবুদ, কুনু শরিক সইয্য করইন না। এরলাগি হুশিয়ার রইও, ইতার পুজা করলে তাইন গুছায় আগুইন অইয়া তুমরারে দুনিয়া থাকি ফুছিলিবা। ");
INSERT INTO syl_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","তুমরার মাবুদ আল্লারে পরিক্ষা করাত লাগিও না, যেলা আগে হউ মাছা নামর জাগাত করছলায়। ");
INSERT INTO syl_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","তুমরার মাবুদ আল্লায় তুমরারে যত হুকুম-আহকাম, হুশিয়ারি আর নিয়ম-কানুন দিছইন, ইতা তুমরা খিয়াল করি মানিও। ");
INSERT INTO syl_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","19","আর মাবুদর নজরো যেতা সঠিক, তাইন যেতা ভালা পাইন, তুমরা অতাউ করিও, তেউ তুমরার ভালাই অইবো। মাবুদে তুমরার বাফ-দাদার গেছে যে দেশ দিবার কছম করছইন, হউ দেশ থাকি তুমরার দুশমনরে তাইন খেদাইয়া দিবা। আর মাবুদর ওয়াদা মাফিক হউ আরামর দেশর দখলদারিও তুমরা পাইবায়। ");
INSERT INTO syl_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","“ভবিষ্যতে যেবলা তুমরার আওলাদ অকলে তুমরারে জিকাইবা, আমরার মাবুদ আল্লায় অউ যেতা হুকুম-আহকাম, নিয়ম-কানুন, আর হুশিয়ারি দিছইন ইতার মানি কিতা? ");
INSERT INTO syl_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","অউ সময় জুয়াপ দিও, মিসর দেশো আমরা ফেরাউনর গুলাম আছলাম, অইলে আল্লায় তান বলআলা কুদরতি আত দিয়া আমরারে বার করিয়া আনছইন। ");
INSERT INTO syl_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","মাবুদে আমরার চখুর ছামনে ফেরাউন আর তার বাড়ির হকলর উপরে, আস্তা মিসর দেশর উপরে বড় বড় গজবি নিশানা, বেজুইতা বালা-মছিবত আর কুদরতি কাম দেখাইলা। ");
INSERT INTO syl_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","অইলে আমরারে তাইন হউ দেশ থাকি বার করিয়া আনলা, যাতে যে দেশ দিবার লাগি আমরার বাফ-দাদা অকলর গেছে কছম খাইছলা, হউ দেশো আমরারে পার করিয়া দখলদারি দেইন। ");
INSERT INTO syl_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","আর তাইন হুকুম দিলা, আমরা যানু তান হকল হুকুম-আহকাম মানি, তানরে ডরাইয়া চলি, তেউ আমরার ভালাই অইবো আর আমরা অখনকুর লাখান হামেশা বাচিয়া রইমু। ");
INSERT INTO syl_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","অখন আমরা যুদি আমরার মাবুদ আল্লার হুকুম মাফিক তান দেওয়া নিয়ম-কানুন খিয়াল করিয়া মানি, তে ইটাউ অইলো আমরার পরেজগারি।” ");
INSERT INTO syl_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","হজরত মুছায় আরো কইলা, “হুনো, তুমরা যে দেশ দখল করাত যাইরায়, তুমরার মাবুদ আল্লায়উ তুমরারে হনো নিবা আর বউত জাতিরে তুমরার ছামনে থাকি খেদাইয়া হারি ইতা দখল করাইবা। তাইন হিট্টী, গির্গাশী, আমোরী, কেনানী, ফারিজী, হিব্বী আর যিবুজী জাতিরে খেদাই দিবা, ই সাতো জাতিউ পরিমানে তুমরা থাকি বড় আর বলআলা। ");
INSERT INTO syl_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","তুমরার মাবুদ আল্লায় যেবলা ইতারে তুমরার আতো সপিয়া দিবা, অউ সময় তুমরা তারারে এক্কেবারে বিনাশ করিলিও, তারার লগে কুনু চুক্তি করিও না, আর কুনু দয়া-মায়া দেখাইও না। ");
INSERT INTO syl_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","ইতার লগে বিয়া-শাদির বেয়াপারে কুনু চুক্তি করিও না। তুমরার পুড়িন্তরে তারার পুয়াইন্তর গেছে বিয়া দিও না, আর তারার পুড়িনরেও তুমরার পুয়াইন্তর লাগি আনিও না। ");
INSERT INTO syl_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","কারন ইতায় তুমরার পুয়া-পুড়িনরে আমার গেছ থাকি হরাইয়া দেব-দেবীর পুজা করাইবো। তেউ আল্লা মাবুদে তুমরার উপরে গুছা অইয়া, লগে লগেউ তুমরারে বিনাশ করবা। ");
INSERT INTO syl_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","এরলাগি তুমরা তারার হকল পুজা-মন্ডপ ভাংগিলিও, পুজার জাগা অকল বিনাশ করিও, আশেরা-দেবীর নিশানা খুটি কাটিয়া ফালাইও, আর হকল জাতর মুর্তিরে আগুইনদি জালাইও। ");
INSERT INTO syl_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","মনো রাখিও, তুমরাউ অইলায় আল্লা মাবুদর পবিত্র প্রজা। দুনিয়ার হকল জাতির মাজ থাকি তাইনউ তুমরারে নিজর প্রজা আর খাছ সম্পদ হিসাবে আলগ করছইন। ");
INSERT INTO syl_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","“কেনে আলগ করছইন? অইন্য জাতি থাকি তুমরার মানুষ বেশি, অতার লাগি নি? না, মোটেউ না। তুমরা তো হকল জাতি থাকি কম আছলায়। ");
INSERT INTO syl_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","তা-ও তাইন তুমরারে খুব মায়া-মহব্বত করইন, আর তুমরার বাফ-দাদা অকলর গেছে যে কছম করছলা, অতার লাগিউ তুমরারে আলগ করছইন। মাবুদে তান কুদরতি আত লাগাইয়া তুমরারে বার করিয়া আনছইন, মিসরর বাদশা ফেরাউনর আত থাকি আর গুলামির দেশ থাকি তুমরারে আজাদ করছইন। ");
INSERT INTO syl_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","অখন তুমরা মনো রাখিও, তুমরার মাবুদ আল্লাউ অইলা আসল মাবুদ। তাইনউ চিরকালিন হক-হালাল। যেরা আশিক অইয়া তানে মহব্বত করে আর তান হুকুম-আহকাম মানে, তাইন তারার আজার আজার ছিড়ি পর্যন্ত নিজর ওয়াদা করা জবান আর দয়া বওয়াল রাখইন। ");
INSERT INTO syl_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","অইলে যেতায় বদ সাওস করিয়া তান বায় পিছ দিলায়, তাইন ইতারে বিনাশ করিয়া জলদি করি বদলা দেইন। ");
INSERT INTO syl_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","এরলাগি আইজ তুমরারে যে হুকুম-আহকাম, নিয়ম-কানুন আর শরিয়ত দিরাম, ইতা খুব খিয়াল করিয়া আমল করিও। ");
INSERT INTO syl_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","“ও বনি ইছরাইল, তুমরা অউ হুকুম-আহকামর কথা কান পাতিয়া হুনো, আর ইতা খিয়াল করি আমল করো। তেউ তুমরার মাবুদ আল্লায় তুমরার বাফ-দাদাইন্তর লগে, তান দয়া-মায়ার বেয়াপারে কছম খাইয়া যে ওয়াদা-চুক্তি করছলা, ইতা তুমরার লগে বওয়াল রাখবা। ");
INSERT INTO syl_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","তাইন তুমরারে মায়া-মহব্বত করবা, রহম-বরকত দিবা আর তুমরার মানষর পরিমান বাড়াইবা। তুমরারে যে দেশ দিবার লাগি তুমরার ময়-মুরব্বির গেছে কছম খাইছলা, অউ দেশো তুমরারে রহম-বরকত দিবা। তুমরারে আওলাদ বাড়াই দিবা, তুমরার বাগানর ফল-মুল, খেতর ফসল, আংগুরর রস, জয়তুনর তেল, গরু-বাছুর, মেড়া-ছাগল হকলতারে বাড়াই দিবা। ");
INSERT INTO syl_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","হকল জাতি থাকি তুমরা বেশি রহম-বরকত পাইবায়, তুমরার বেটাইন-বেটিন বা তুমরার পশুর পালর কেউ আটকুরা রইতো নায়। ");
INSERT INTO syl_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","আল্লা মাবুদে তুমরারে হকল লাখান বেমার থাকি বাচাইবা। মিসর দেশো তুমরা যেতা কঠিন বেমার-আজার দেখছো, ইতা তুমরারে দিতা নায়, খালি তুমরার দুশমন অকলরে দিবা। ");
INSERT INTO syl_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","তুমরার মাবুদ আল্লায় যত জাতির মানষরে তুমরার আতো সপিবা, ইতারে তুমরা এক্কেবারে শেষ করিলাইও, কুনু দয়া করিও না, আর তুমরা ইতার দেবতারে পুজা করিও না, আরনায় ইতা তুমরার পথর কাটা অইবা। ");
INSERT INTO syl_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","“তুমরা হয়তো মনে মনে কইবায়, আমরা কিলাখান তারারে খেদাইয়া দিমু? ইতা জাতির মানুষ তো পরিমানে আমরা থাকি বাক্কা বেশি। ");
INSERT INTO syl_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","অইলে তুমরা ইতারে ডরাইও না। ফেরাউন আর আস্তা মিসর দেশর উপরে তুমরার মাবুদ আল্লায় কিতা করছইন, ইতা তুমরা ফাউরিও না। ");
INSERT INTO syl_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","মাবুদে কত বড় বড় গজব-মছিবত ঢালিয়া তারারে বিনাশ করছইন, ইতা তো নিজর চউখেও দেখছো। তান বউত কুদরতি কাম, বউত লাখান নিশানা দেখছো, তান বলআলা মজবুত আত দিয়া তুমরারে বার করিয়া আনছইন, ইতা হকলতা মনো রাখিও। আর তুমরা অখন যেতা জাতি অকলরে দেখিয়া ডরাইরায়, ইতার উপরেও তুমরার মাবুদ আল্লায় ঠিক অউলা ঘটাইবা। ");
INSERT INTO syl_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","এরবাদেও তুমরার গেছ থাকি লুকাইয়া যেগুইন জিতা রইযিবা, তুমরার মাবুদ আল্লায় ভিংগুলর পাল পাঠাইয়া ইতা হকলটিরে বিনাশ করবা। ");
INSERT INTO syl_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","তে তুমরা ইতারে ডরাইও না, জানো তো, তুমরার মাবুদ আল্লা যেইন তুমরার লগে বসত করইন, এইন বড় ভয়ংকর আর মহান। ");
INSERT INTO syl_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","তুমরার মাবুদ আল্লায় তুমরার ছামনে থাকি আস্তে আস্তে অতা জাতিরে খেদাই দিবা। অইলে হকলটিরে তো তুমরা একলগে খেদাইতায় পারতায় নায়, খেদাইলে জংলি জানুয়ারে তুমরার চাইরোবায় ভরিযিবা। ");
INSERT INTO syl_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","তা-ও তারা এক্কেরে বিনাশ অওয়ার আগ পর্যন্ত তুমরার মাবুদ আল্লায় তারারে বেজুইতা অশান্তিত ফালাইয়া তুমরার আতো সপিয়া বিনাশ করাইবা। ");
INSERT INTO syl_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","তারার রাজা-বাদশা অকলরেও তুমরার আতো সপিবা, তুমরা দুনিয়া থাকি ইতার নাম মিটাইলিবায়, ইতারে বিনাশ করার আগ পর্যন্ত কেউ আইয়া তুমরার ছামনে উবানির তাক্কত অইতো নায়। ");
INSERT INTO syl_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","“তুমরা ইতার মুর্তি অকলরে আগুনিত ফালাইয়া জালাইলিও। তারার গতরর সোনা-রুপার বায় লালছ করিও না, আরনায় ফান্দো পড়বায়। মনো রাখিও, তুমরার মাবুদ আল্লায় ইতারে ঘিন্নাইন। ");
INSERT INTO syl_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","ঘিন্নার কুনু জিনিস তুমরার ঘরো হারাইলে তুমরাও অতার লাখান বনিযিবায়। বরং তুমরাও ইতারে খুব ঘিন্নাইও আর তুচ্ছ করিও, ইতা তো লান্নতি। ");
INSERT INTO syl_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","“অখন আমি তুমরারে যে হুকুম দিরাম, তুমরা খুব খিয়ালি অইয়া ইতা আমল করিও, তেউ তুমরা বাচিয়া রইবায়, তুমরার আওলাদ বাড়িবো, আর তুমরার ময়-মুরব্বির গেছে মাবুদে কছম খাইয়া যে দেশ দিবার ওয়াদা করছইন, হউ দেশো হামাইয়া দখল করতায় পারবায়। ");
INSERT INTO syl_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","আর তুমরা মনো রাখিও, তুমরার মাবুদ আল্লায় অউ চাল্লিশ বছরে মরুভুমির মাজদি তুমরারে কিলা লইয়া আইছলা, তুমরার বড়াই-বেটাগিরি ভাংগিবার লাগি, আর তুমরা তান হুকুম-আহকাম মানবায় কি না অখান পরিক্ষা করার নিয়তে, তুমরার দিলর খবর জানার লাগি তাইন তুমরারে নত করছইন। ");
INSERT INTO syl_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","তুমরার ময়-মুরব্বিরে খানি-খুরাকি না দিয়া উপাস রাখলা, বাদে যে খানি তারা চিনতা না, মান্না নামর অউ খানি খাওয়াইয়া তাইন তুমরার বড়াই-বেটাগিরি ভাংগিছইন। তাইন তুমরারে হিকাইতা চাইলা, খালি রুটি খাইলেউ মানুষ বাচে না, বরং আল্লার পরতেক কালামেউ মানষর জান বাচে। ");
INSERT INTO syl_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","অউ চাল্লিশ বছরর মাজে তুমরার গতরর কাপড়-চুপড় নষ্ট অইছে না, দিন-রাইত আটিলেও তুমরার পাও ফুলছে না। ");
INSERT INTO syl_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","অখন তুমরার দিলো গাথিয়া রাখিও, বাফে যেলা নিজর পুয়ারে শাসন করে, তুমরার মাবুদ আল্লায় তুমরারেও অলা শাসন করইন। ");
INSERT INTO syl_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","“তুমরা নিজর মাবুদ আল্লার হুকুম-আহকাম আমল করিও, তান পথে চলিও, আর তানরে ডরাইও। ");
INSERT INTO syl_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","তুমরার মাবুদ আল্লায় তুমরারে যে আরামর দেশো নিরা, ই জাগাত পাহাড়-পর্বত, পাহাড়িয়া খাল, পানির ইন্দারা আছে, আর মাটির তলেও পানি আছে। ");
INSERT INTO syl_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","হিনো গম, বার্লি, আংগুর, ডুমুর গাছ, আনুয়ার ফল, জয়তুনর তেল আর মউ আছে। ");
INSERT INTO syl_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","হি দেশো বউত খানি-পানি পাইবায়, কুন্তার অভাব তুমরার অইতো নায়। হিনোর পাথরর মাজে লুয়া আছে, হনর পাহাড় খুদিলে তুমরা তামা-পিতল পাইবায়। ");
INSERT INTO syl_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","হউ দেশো পেট ভরিয়া খানা-পিনা খাইয়া হারলে তুমরার মাবুদ আল্লার দেওয়া অউ আরামর দেশর লাগি তান শুকরিয়া আদায় করিও। ");
INSERT INTO syl_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","“তা-ও তুমরা হুশিয়ার রইও, তুমরার মাবুদ আল্লারে কুনু সময় ফাউরিও না, আর আমি অখন তুমরারে যেতা হুকুম-আহকাম, নিয়ম-কানুন, আর শরিয়ত জানাইরাম, ইতা আমল করতে কুনু গাফলতি করিও না। ");
INSERT INTO syl_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","হনো গিয়া পেট ভরি খানা-পিনা খাইয়া, সুন্দর করি ঘর-বাড়ি বানাইয়া, ");
INSERT INTO syl_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","তুমরার গরু-ছাগলর পাল বাড়িলে, সোনা-রুপা জমাইয়া, হকল মন্তে ধন-ছামানা বাড়িয়া হারলে হুশিয়ার রইও। ");
INSERT INTO syl_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","তুমরার দিলরে বড়াই-বেটাগিরি করতে দিও না। আর হউ আল্লা মাবুদরে ফাউরিও না, যেইন তুমরারে মিসর দেশ থাকি, হউ গুলামি থাকি বার করিয়া আনছইন। ");
INSERT INTO syl_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","তাইন তো তুমরারে বেজুইতা বিপদ-আপদে ভরা বিরাট মরুভুমি থাকি, কঠিন বিষাক্ত হাফ, বিষাক্ত কাকড়া-বিছায় ভরা পথেদি তুমরারে পার করি আনছইন। শক্ত পাথরর ভিতর থাকি তুমরার লাগি পানি বার করছইন। ");
INSERT INTO syl_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","তাইন হউ মরুভুমির মাজে তুমরারে মান্না খাবাইছইন, যেতার নাম তুমরার ময়-মুরব্বি অকলে হুনছইনও না। তুমরার ভিতরর বড়াই-বেটাগিরি ভাংগিবার লাগি, আর তুমরারে পরিক্ষা করার নিয়তেউ ইতা করছইন, যাতে হেশে তুমরার ভালাই অয়। ");
INSERT INTO syl_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","তুমরা মনে মনে কইও না, আমার নিজর বল-শক্তিয়ে নিজর কামাই দিয়া ধনি অইছি। ");
INSERT INTO syl_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","অইলে তুমরার নিজর মাবুদ আল্লায় তুমরার ময়-মুরব্বির গেছে কছম খাইয়া যেতা ওয়াদা-চুক্তি করছলা, অতা অখন পুরাপুর করার লাগি তুমরারে ই ধন-ছামানা দিছইন, এরলাগি তানরে মনো রাখিও। ");
INSERT INTO syl_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","“তুমরা যুদি কুনু দিন তুমরার মাবুদ আল্লারে ফাউরিলাও, আর দেব-দেবীর পুজা করাত লাগো, অতার খেজমত বা ভজনা করো, তে আমি অখন তুমরারে হুশিয়ারি দিয়ার, তুমরা নিচ্চিত বিনাশ অইযিবায়। ");
INSERT INTO syl_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","তুমরার মাবুদ আল্লার হুকুম-আহকাম না মানলে, তুমরার ছামনে হউ যেতা জাতি অকলরে তাইন বিনাশ করছইন, তুমরারেও অলা বিনাশ করবা।” ");
INSERT INTO syl_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","হজরত মুছায় আরো কইলা, “ও বনি ইছরাইল হুনো, তুমরা থাকি বলআলা আর পরিমানেও বউত বেশি, বড় বড় জাতির দেশরে দখল করার লাগি অখন জর্দান গাং পার অইয়া যাইবায়, তারার টাউন অকলও বড় বড়, অউ টাউনর বাউন্ডরির ওয়াল আছমানো ছইলিছে। ");
INSERT INTO syl_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","তারা অইলা উচা-মোটা পয়লোয়ান, এরা হকলউ আনাকী বংশর মানুষ। তুমরা তো আগেউ তারার বেয়াপারে হুনছো, আনাকী অকলর লগে লাগার তাক্কত কার আছে? ");
INSERT INTO syl_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","অইলে তুমরা অখান মনো রাখিও, তুমরার মাবুদ আল্লা তো তুমরার আগে আগে যাইরা, তাইন জালাইয়া ছারখার কররা আগুনির লাখান। তাইনউ ইতারে দমাইয়া তুমরার তলুয়া বানাইবা। তেউ মাবুদে আগে যেলাখান কইছলা, তুমরা অলাউ তারারে খেদাই দিয়া জলদি করি বিনাশ করবায়। ");
INSERT INTO syl_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","“তুমরার মাবুদ আল্লায় যেবলা তুমরার ছামনে থাকি তারারে খেদাইয়া দিবা, হউ সময় তুমরা মনে মনে কইও না, আমরার পরেজগারির ফল হিসাবে মাবুদে আমরারে অউ দেশ দখল করার লাগি আনছইন। আসলে হউ জাতি অকলর নাফরমানির লাগিউ মাবুদে তারারে তুমরার ছামনে থাকি খেদাই দিবা। ");
INSERT INTO syl_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","তুমরার পরেজগারি বা সততার লাগি তো হি দেশর দখলদারি পাইরায় না, বরং হউ জাতির নাফরমানির লাগি, আর তুমরার মাবুদ আল্লায় তুমরার ময়-মুরব্বি ইব্রাহিম, ইছহাক আর ইয়াকুবর গেছে যে ওয়াদা করছলা, অখান পুরন করার লাগি, তাইনউ তুমরার ছামনে থাকি ইতারে খেদাইয়া দিবা। ");
INSERT INTO syl_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","এরলাগি তুমরা জানিয়া রাখিও, তুমরার পরেজগারি দেখিয়া তো তুমরার মাবুদ আল্লায় অউ আরামর দেশর দখলদারি তুমরারে দিরা না, তুমরা অইলায় গাড়তেড়া-একগুইয়া জাতি। ");
INSERT INTO syl_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","“আর হউ মরুভুমির মাজে তুমরা কিলা নিজর মাবুদ আল্লার গুছা তুলাইছলায়, ইখান মনো রাখিও, কুনুদিন ফাউরিও না। মিসর দেশ ছাড়িয়া আওয়ার দিন থাকি অখানো আওয়া পর্যন্ত, হামেশা তুমরার মনর ভিতরে মাবুদর বিরুধিতা আছে। ");
INSERT INTO syl_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","তুর পাহাড়র মাজেও তুমরা মাবুদর গুছা তুলাইছলায়, এরলাগি তাইন তুমরারে বিনাশ করিলতা চাইলা। ");
INSERT INTO syl_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","মাবুদে তুমরার লগে যে ওয়াদা-চুক্তি বওয়াল করছইন, অউ চুক্তি নামা লেখা দুইও খান পাথর আনার লাগি আমি পাহাড়ো উঠিছলাম, চাল্লিশ দিন চাল্লিশ রাইত কুনু দানা-পানি না খাইয়া আমি রোজা আছলাম। ");
INSERT INTO syl_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","আর মাবুদে তান পবিত্র আতর আংগুইলদি লেখা হউ দুইও খান পাথর আমারে দিলা। তুমরা হকল যেদিন তুর পাহাড়ো আইয়া দলা অইলায়, অউ দিন মাবুদে জালাইল আগুনির মাজ থাকি তুমরারে যেতা বাতাইছলা, অউ দুইও পাথরর মাজে তো অতা লেখা আছিল। ");
INSERT INTO syl_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","“হউ চাল্লিশ দিন আর চাল্লিশ রাইতর বাদে মাবুদে অউ চুক্তি নামা লেখা পাথর দুইও খান আমার আতো দিলা। ");
INSERT INTO syl_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","দিয়া কইলা, যাও, তুমি জলদি করি লামাত যাও, কারন তুমি যেতা মানষরে মিসর থাকি বার করিয়া আনছো, ইতা কু-পথে গেছইন