﻿USE sofia;
DROP TABLE IF EXISTS sofia.syb_vpl;
CREATE TABLE syb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES syb_vpl WRITE;
INSERT INTO syb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Naa mendadi kini si Isukristu, kinii gesalanen. Sala tawan ginepuꞌay ni Isukristu, iin si David, sapuꞌ pa dema ni Abraham dengantu. ");
INSERT INTO syb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Naa mendadi, kinii gesalan ni Isukristu genat dini Abraham sampay dini Adiꞌ David. Si Abraham, kaliꞌ pegbataꞌ, iinig bataꞌen, si Isaac. Si Isaac, iinig bataꞌen, si Jacob. Si Jacob, iinig bataꞌen, si Juda sampay su nga pateden. ");
INSERT INTO syb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Si Juda, iinig bataꞌen, si Fares mukaꞌ si Sara. (Iini ginaꞌ nilan, si Tamar.) Si Fares, iinig bataꞌen, si Esrom. Si Esrom, iinig bataꞌen, si Aram. ");
INSERT INTO syb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Si Aram, iinig bataꞌen, si Aminadab. Si Aminadab, iinig bataꞌen, si Naason. Si Naason, iinig bataꞌen, si Salmon. ");
INSERT INTO syb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Si Salmon, iinig bataꞌen, si Boos. (Iini ginaꞌ ni Boos, si Rahab.) Si Boos, iinig bataꞌen, si Obed. (Iini ginaꞌ ni Obed, si Ruth.) Si Obed, iinig bataꞌen, si Isai. ");
INSERT INTO syb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Mendadi si Isai, iin pelumig bataꞌen, si Adiꞌ David. Naa kini pelumi gesalan ni Isukristu genat dini David sampay di kenguit tug bansa Israel ditug benwa Babilonia. Mendadi, kaliꞌ pegbataꞌ si David, iin pelum si Salomon. (Iini ginaꞌen, su sawa sia ni Urias dengantu.) ");
INSERT INTO syb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Si Salomon, iinig bataꞌen, si Roboam. Si Roboam, iinig bataꞌen, si Abias. Si Abias, iinig bataꞌen, si Asa. ");
INSERT INTO syb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Si Asa, iinig bataꞌen, si Josafat. Si Josafat, iinig bataꞌen, si Joram. Si Joram, iinig bataꞌen, si Usias. ");
INSERT INTO syb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Si Usias, iinig bataꞌen, si Jotam. Si Jotam, iinig bataꞌen, si Acas. Si Acas, iinig bataꞌen, si Ezequias. ");
INSERT INTO syb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Si Ezequias, iinig bataꞌen, si Manases. Si Manases, iinig bataꞌen, si Amon. Si Amon, iinig bataꞌen, si Josias. ");
INSERT INTO syb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Si Josias, iinig bataꞌen, si Jeconias sampay su nga pateden, mitaang su kegigetaw nilan tu kenguit tug bansa Israel ditug Babilonia. ");
INSERT INTO syb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Naa kini pelumi gesalan ni Isukristu genat tu kenguit tu getaw Israel ditug Babilonia sampay di kegigetaw na ni Isukristu. Mendadi si Jeconias kia, kaliꞌ pegbataꞌ, iinig bataꞌen, si Salatiel. Si Salatiel, iinig bataꞌen, si Sorobabel. ");
INSERT INTO syb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Si Sorobabel, iinig bataꞌen, si Abiud. Si Abiud, iinig bataꞌen, si Eliaquim. Si Eliaquim, iinig bataꞌen, si Asor. ");
INSERT INTO syb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Si Asor, iinig bataꞌen, si Sadoc. Si Sadoc, iinig bataꞌen, si Aquim. Si Aquim, iinig bataꞌen, si Eliud. ");
INSERT INTO syb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Si Eliud, iinig bataꞌen, si Eleasar. Si Eleasar, iinig bataꞌen, si Matan. Si Matan, iinig bataꞌen, si Jacob. ");
INSERT INTO syb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Si Jacob, kaliꞌ pegbataꞌ, iin pelum si Jose, su minginsawa dini Maria. Mendadi, kaliꞌ pelum pegbataꞌ si Maria, kini na tuꞌu si Isus, ki gilal Tinduꞌ nu Megbebayaꞌ Meglekaunutan. ");
INSERT INTO syb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kaas genat ditu ni Abraham, benaꞌ sepuluꞌ buꞌ paat sumpat, dekag pa migigetaw si David. Dayun genat ditu ni David sampay tu kenguit tu nga getaw Israel ditug Babilonia, sepuluꞌ buꞌ paat sumpat pa pagid. Genat itu, benaꞌ sepuluꞌ buꞌ paat sumpat na pelum, iin na tuꞌu su kegigetaw ni Isukristu, ki Tinduꞌ nu Megbebayaꞌ Meglekaunutan. ");
INSERT INTO syb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Naa kini si Isukristu, kiniig bian nu kegigetawen. Ki mbaal ginaꞌen si Maria, mimbeng diniin ki sala tawan si Jose. Laak dagid su ndaꞌ pa pegawid duayan si Jose mukaꞌ si Maria, misimaꞌ ni Maria puꞌ masiꞌ pelepuunan na, sabaꞌ laak nug Balakat nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Naa kini si Jose, mekesuun getaw, kaas delendemanen, subay butasenen sug bembengen dini Maria. Laak pegbuniinen tug launan getaw, adun ndiꞌen mpengumpiidan si Maria. ");
INSERT INTO syb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Dagid sinegay megdelendem pa si Jose, duun masiꞌi sesuguꞌen nu Kaunutan Megbebayaꞌ getaw langit mituaꞌ diniin di teginepenen, kaliꞌ pektaluꞌ diniin, “Jose, sapuꞌa ni David, ndiꞌa mekalangalang menginsawa dini Maria. Puꞌ kig bedesanen kiin, mikpuun tug Balakat nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Naa megbataꞌ tuꞌu si Maria, iinig bataꞌen, laki. Iini baal niu ngalanen, si Isus, puꞌ iini meglegawen tu piglegetawanen di nga salaꞌ nilan.” ");
INSERT INTO syb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kaas mipenggulaulaig launanen kini, puꞌ adun menuud su pisulat nu Kaunutan Megbebayaꞌ tu pimuunanen dengantu ditu Misulat Taluꞌen, laung, ");
INSERT INTO syb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mendadi, duunig delaga megbedes, dayun megbataꞌ, bataꞌlaki. Iini baalen ngalanen, si Immanuel” (maꞌananen, “Kini su Megbebayaꞌ, suminalabuuk na dinita”). ");
INSERT INTO syb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Naa si Jose, benaꞌ mitanud genat mekteginep, delendemanen diunenen da penginsuaay si Maria, maaꞌ dadema nu tinituluꞌ diniin nu sesuguꞌen nu Kaunutan Megbebayaꞌ. Saꞌ maꞌnia, mikpungun ilan, ");
INSERT INTO syb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","laak tebiaꞌ, ndaꞌ pa siben ubayay ni Jose si Maria, sampay da dun migbataꞌ. Benaꞌ migbataꞌ tuꞌu si Maria, iin dayuni binaal ni Jose ngalan nu gembataꞌ kia, si Isus. ");
INSERT INTO syb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maꞌantu, migigetaw si Isus ditug lunsud Betlehem, sakup prubinsya Judea, timpu ni Adiꞌ Herodes. Naa tubus nitu, ndaꞌ maiben, duuni mituaꞌ ditu Jerusalem nga mengumitun, genat ilan tu dapit silangan. ");
INSERT INTO syb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Mendadi benaꞌ minateng su mengumitun kia, sinaak nilan tu nga getaw dia, “Ki gembataꞌ migigetaw dini, gasalen meglegadiꞌ tu nga getaw Judea, adin ma dun? Puꞌ duuni minitaꞌ namiig bitun misebang ditu silangan, iini tuꞌus di kegigetawen. Kaas mipanaw ami dini, adun mengamuyuꞌ ami lumuꞌud diniin.” ");
INSERT INTO syb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Naa kini si Adiꞌ Herodes, benaꞌ midengegen su tinaluꞌ nu nga mengumitun, milibuleng patiꞌ. Sampay sug launan getaw dia Jerusalem, milibuleng ilan dun dadema. ");
INSERT INTO syb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Saꞌ maꞌnia, pipungun ni Herodes su kelaun kaunutan nug belian nu getaw Judea mukaꞌ su nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ. Benaꞌ misabi ilan, sinaak ni Herodes dinilan, “Naa mekatag di Tinduꞌ nu Megbebayaꞌ Meglekaunutan, alanduni sinulat ditu Taluꞌ nu Megbebayaꞌ, adin daw pegigetaw?” ");
INSERT INTO syb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Kaliꞌ ilan sembag, “Diag lunsud Betlehem, sakup dadema prubinsya Judea kini, puꞌ iini sinulat nu pimuunan nu Megbebayaꞌ dengantu ditu Misulat Taluꞌen, laung, ");
INSERT INTO syb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Yaꞌa Betlehem, sakupa Judea, yaꞌai tampusan metaas di ngag lunsud di Judea. Puꞌ megenat pa diniꞌa ki kaunutan, iini meguit tu piglegetawan ku, sug bansa Israel!’” ");
INSERT INTO syb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Naa saꞌ maꞌnia, kini si Herodes, pitawagen pelum su nga miguliug kia genat tu dapit silangan, laak pigbuninen, sinaaken dayun dinilan su gebii nu kesebang nug bitun kia. ");
INSERT INTO syb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Benaꞌ pisuun nilan diniin, sinuguꞌen ilan dayun mundas ditug Betlehem, kaliꞌ pektituluꞌ dinilan, “Naa, panaw namu, penengaw niu gupia ki gembataꞌ kiin! Dayun saꞌ mbaangan na niu, pesuun niu dinaan, adun mekeditu dau dema mengamuyuꞌ diniin.” ");
INSERT INTO syb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Mipanaw dayuni nga mengumitun kia. Benaꞌ dia nailan dalan, masiꞌ minitaꞌ nilan puliꞌ kig bitun kia, su gandang minitaꞌ nilan ditu silangan. Saꞌ minitaꞌ nilan, aba, pinleliag ilan dun patiꞌ! Mukaꞌ ibayan ilan nug bitun kia sampay midepet nilan sug balay pigigetawan nu gembataꞌ kia, dia dayun tuminlen sug bitun. ");
INSERT INTO syb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Sumiled ilan diag balay, minitaꞌ nilan dayun tuꞌu ki gembataꞌ kia, sampay su ginaꞌen si Maria. Minginluꞌud ilan dayun, tuminamuy ilan diniin. Mukaꞌ pinukaꞌan nilani nga giwit nilan ngag bulawan, pelinan, mukaꞌ mira, iini seginis pagemut, bigay nilan dayun dia gembataꞌ kia. ");
INSERT INTO syb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tubus itu, minuliꞌ tug benwa nilan su nga mengumitun. Laak lain dalanig bianan nilan, puꞌ pigad dinilan nu Megbebayaꞌ pibian di teginepen, subay ndiꞌ daw mpuliꞌ mian ditu ni Herodes su nga mengumitun kia. ");
INSERT INTO syb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mendadi benaꞌ su kepalus nu nga mengumitun, si Jose kiin, duun pelumi sesuguꞌen nu Kaunutan Megbebayaꞌ getaw langit mituaꞌ diniin, pibian da gusay di teginepen. Kaliꞌ pektaluꞌ su getaw langit, “Duunig delendeman ni Herodes, ki gembataꞌ kiin, penengaunen, puꞌ petainen. Naa pegbuata, uit mu su gembataꞌ dakus su ginaꞌen, laguy amu tug benwa Ehipto. Ditu amu dayun pegbenwa, sampay di gendaw teluꞌen ku pa diniꞌa.” ");
INSERT INTO syb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Benaꞌ mideksuꞌ mektaluꞌ su getaw langit, migbuat dayun si Jose, iwiten tuꞌu su gembataꞌ dakus su ginaꞌen, mingelem ilan mpanaw, pangay ilan tug benwa Ehipto. ");
INSERT INTO syb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Naa benaꞌ minibeniben, minateng ilan ditug Ehipto, mukaꞌ ditu ilan migbenwa sampay minatay si Herodes. Kaas mipenggulaulaig launanen kia, puꞌ adun menuud su pisulat nu Kaunutan Megbebayaꞌ tu pimuunanen dengantu ditu Misulat Taluꞌen, laung, “Sinuguꞌu sug Bataꞌu megawaꞌ tug benwa Ehipto.” ");
INSERT INTO syb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Naa mendadi kini si Herodes, benaꞌ misuunanen puꞌ masiꞌ pigekalan nu nga miguliug kia genat tu dapit silangan, mitutung gupia gangit si Herodes. Kaliꞌ pegleketau, mikpalinta dayun pemetain ki kelaun gembataꞌ diag Betlehem sampay ditug lumibut benwa, saꞌ gembataꞌ laki duaꞌ tauni gidaden, kampuꞌ nu nga sumilung dun. Iini piglekwinta ni Herodes tu gidad nu gembataꞌ kiin mpeduma sia matay, su gendaw nu kesebang nug bitun kia pisuun diniin nu nga miguliug kia. ");
INSERT INTO syb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Maꞌantu, minuud su sinulat dengantu ditu Misulat Taluꞌ nu Megbebayaꞌ nu pimuunanen si Jeremias, laungen, ");
INSERT INTO syb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Duuni tingeg ditug lunsud Rama, miktenlis sabaꞌ meliget kelegenay. Puꞌ si Raquel, pingeduyanen su ngag bataꞌen. Ndaꞌiduni mekengamuꞌ dun, puꞌ su ngag bataꞌen, ndaꞌ na.” ");
INSERT INTO syb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Naa saꞌ minibeniben, minatay si Herodes. Mendadi benaꞌ ndaꞌ na si Herodes, duun pelumi sesuguꞌen nu Kaunutan Megbebayaꞌ getaw langit mituaꞌ dini Jose ditu pa benwa Ehipto, pibian da puliꞌ di teginepen. ");
INSERT INTO syb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Kaliꞌ pektaluꞌ su getaw langit, “Naa, pegbuata, uit mu kig bataꞌ kiin dakus su ginaꞌen, uliꞌ namu ditug benwa nu nga getaw Israel. Puꞌ su mekpatay sia dig bataꞌ kia, minatay na.” ");
INSERT INTO syb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Maꞌantu, benaꞌ migendaw, migbuat dayun si Jose, iwiten puliꞌ tuꞌu su gembataꞌ dakus su ginaꞌen ditug benwa nu nga getaw Israel. ");
INSERT INTO syb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Laak pisuun dini Jose puꞌ iini misukli dini Herodes meglegadiꞌ ditu Judea, si Arquelao, bataꞌ da gusay ni Herodes. Kaliꞌ medengeg ni Jose, mindek iin mpuliꞌ ditu Judea. Laak tinituluꞌan puliꞌ nu sesuguꞌen nu Kaunutan genat tug langit, pibian da gusay di teginepen, kaas minundas ilan tu prubinsya Galilea, ");
INSERT INTO syb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","dia ilan dayun migbenwa lunsud piningalan dun Nazaret. Maꞌantu, minuud pa padun su tinaluꞌ dengantu nu nga pimuunan nu Megbebayaꞌ, “Iini paingalan diniin, Getaw Nazaret.” ");
INSERT INTO syb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Naa benaꞌ santaꞌ taun, duuni getaw mituaꞌ diag limawaꞌ tu prubinsya Judea, ngalanen si Juan, piningalan dun nu nga getaw su Memunag Tubig. Kini si Juan, miktituluꞌ tu nga getaw, ");
INSERT INTO syb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","kaliꞌ pektaluꞌ, “Peksikesuun amu, puꞌ ki Keglekaunutan nu Megbebayaꞌ, sungu na mektelipuun!” ");
INSERT INTO syb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Si Juan kia, iini kenuud nu sinulat dengantu ditu Misulat Taluꞌ nu Megbebayaꞌ nu pimuunanen si Isaias, laungen, “Duuni getaw mektawag diag limawaꞌ, laungen, ‘Pengendamay niu sug bianan nu Kaunutan Megbebayaꞌ, pelegdeng niu kig dalanen!’” ");
INSERT INTO syb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Naa kini si Juan, penepetenen ki ginabel bembul petubuꞌen paingalan dun kamelyu. Sug bakesen, panit dadema petubuꞌen. Ki gaanen, gapan mukaꞌ teneb. ");
INSERT INTO syb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Mendadi, kaliꞌ pektituluꞌ si Juan, melaun getaw minangay mekineeg diniin, sakup ilan di Jerusalem dakus tu tibuuk prubinsya Judea sampay tu tibuuk benwa mesempel di tubig Jordan. ");
INSERT INTO syb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Pigukit nilan su nga salaꞌ nilan, mukaꞌ mikpebunag ilan dayun dini Juan tubig ditug lawas Jordan. ");
INSERT INTO syb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Laak melaun duma getaw minangay mekpebunag dini Juan tubig, sakup ilan nu pikumpungan nu getaw Judea piningalan dun nga Pariseo mukaꞌ nga Saduseo. Mendadi kini si Juan, saꞌ minitaꞌen ilan, miktaluꞌ dinilan, “Paa, yamu pa di nga mamak! Taꞌ taway duni mikpegad diniu, adun sia peleguyan niu ki ginukuman nu Megbebayaꞌ sungu mateng? ");
INSERT INTO syb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Subay menggulaula amu gempia, ki mbantang di nga getaw miksikesuun, damikian duni gayu megbunga melengas. ");
INSERT INTO syb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mukaꞌ ndiꞌ amu pektaluꞌ dig dialem ginaa niu puꞌ mipemilang namu nu Megbebayaꞌ mekesuun puun di kesapuꞌ niu dini Abraham. Puꞌ taman taluꞌu diniu, pia ki ngag batu dinig lupaꞌ kini, mesuꞌat dadema beluyay nu Megbebayaꞌ nga sapuꞌ ni Abraham! ");
INSERT INTO syb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Dagid nandaw, minuyaꞌ na sug wasay, dia na tuꞌu puun nu gayu. Kaas adini gayu ndiꞌ megbunga gempia, penegaꞌen nu Megbebayaꞌ, dayun piglakay tu gapuy. ");
INSERT INTO syb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Mendadi naan kini,” laung padun ni Juan, “memunagu laak tubig diniu, tuꞌus tu keksikesuun niu. Dagid duuni sungu metuaꞌ, mbinayaꞌ pa dinaan, laak pia maꞌantu, metaas pai ginuungen batul danaan. Pia su sepatusen, kanaꞌu mbantang meguit dun diniin. Dagid iin, bunagenen diniu kig Balakat nu Megbebayaꞌ, mukaꞌ gapuy. ");
INSERT INTO syb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Iin, minuyaꞌ na mekpalid di ginani. Saꞌ metubus mekpalid, pungunenen su trigo, teguꞌenen dayun tug lulunen. Laak dagid su gepis mukaꞌ gebas, sensulanen tu gapuy ndiꞌ na mpaleng.” ");
INSERT INTO syb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Naa mendadi kini si Isus, su saanan ni Juan memunag tubig tu nga getaw, mituaꞌ na tuꞌu dia prubinsya Judea genat tu Galilea. Benaꞌ minateng si Isus, minangay dini Juan dia tubig Jordan, mikpebunag diniin tubig. ");
INSERT INTO syb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Dagid belibadan sia ni Juan, laungen, “Baa, Sir, mauma dema mekpebunaga dinaan tubig, asa iin siaig bentanganen, yaꞌai megbunag dinaan tubig!” ");
INSERT INTO syb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Kaliꞌ sembag si Isus, “Baa, petuyangen na. Puꞌ subay maꞌninii mbianan ta, adun gelaꞌen ta petuuday su pimuun nu Megbebayaꞌ dinita.” Naa saꞌ maꞌnia, miliag na si Juan. ");
INSERT INTO syb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Lemen laak mitubus bunagay tubig si Isus, guminawen dayun dia tubig. Minitaꞌen dayun mipukaꞌ masiꞌ sug langit, mukaꞌ sug Balakat nu Megbebayaꞌ, luminusad, miglanguban di maꞌniin palas limuun, minapun dayun dini Isus. ");
INSERT INTO syb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Duun dayuni miktaluꞌ ditug langit, laungen, “Kini na tuꞌu sug Bataꞌu, ki petailen ku, leliagenu gupia diniin.” ");
INSERT INTO syb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Naa ndaꞌ maiben, kini si Isus, inabay nug Balakat nu Megbebayaꞌ tug limawaꞌ, adun pengindanan nu Palin. ");
INSERT INTO syb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Benaꞌ ditug limawaꞌ si Isus, mikpuasa paat puluꞌ gebii, ndaꞌ siben aan, dayun migutem gupia. ");
INSERT INTO syb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mendadi ki Palin kini, mikpesempel dini Isus, miktaluꞌ diniin, “Mendadi, yaꞌaig Bataꞌ nu Megbebayaꞌ, daw. Naa saꞌ pinenggiꞌ metuud, naa ki ngag batu kinuꞌ, pebaluy mu daw nga pan.” ");
INSERT INTO syb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Dagid sumimbag si Isus, laungen, “Paa, duuni sinulat ditu Misulat Taluꞌ nu Megbebayaꞌ, laung, ‘Kanaꞌ gaan laaki ketubuꞌan nu kilawan. Iini mekpetubuꞌ tantu di getaw, su kelaun teluꞌen nu Megbebayaꞌ.’” ");
INSERT INTO syb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Naa saꞌ maꞌantu, iwit na pelum nu Palin si Isus tu Jerusalem, sug lunsud pimiliꞌ nu Megbebayaꞌ, piꞌindegen dayun ditu tampusan ditaas nug Balay Pengedapan tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Miktaluꞌ dayun su Palin diniin, “Saꞌ metuud puꞌ yaꞌa tuꞌuig Bataꞌ nu Megbebayaꞌ, naa sampaka diag lupaꞌ. Puꞌ duuni misulat ditu Taluꞌ nu Megbebayaꞌ, laung, ‘Suguꞌen nu Megbebayaꞌ su nga sesuguꞌenen getaw langit megingat diniꞌa. Sipupuun ka nilan, adun ndiꞌa meseknun dig batu.’” ");
INSERT INTO syb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Dagid sumimbag si Isus, laungen, “Duun pagidi misulat, ‘Su Kaunutan mu Megbebayaꞌ, ndiꞌ mu pengindanay mekatag di tinaluꞌen.’” ");
INSERT INTO syb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Mendadi, iwit na pelum nu Palin si Isus di metaas gupia bentud, pinitaꞌen dayun diniin su kelaunan nasud mukaꞌ peglegediꞌan dinig dibabaw lumbang, sampay su kelengasen. ");
INSERT INTO syb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Miktaluꞌ dayun su Palin, “Naa kig launanen kiin, gelaꞌen ku begay diniꞌa, saꞌ menginluluda di gedapan ku, mengamuyuꞌ dinaan.” ");
INSERT INTO syb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Dagid sumimbag si Isus, laungen, “Paa, pegawaꞌa diin, Satanas! Puꞌ duun pa pagidi misulat, ‘Su Kaunutan mu Megbebayaꞌ laaki penluꞌudan mu, ndaꞌig lain temuyen mu.’” ");
INSERT INTO syb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Saꞌ mideksuꞌ mektaluꞌ si Isus, bilengan dayun nu Palin. Duun dayuni nga sesuguꞌen nu Megbebayaꞌ getaw langit mituaꞌ, pigebangan nilan si Isus. ");
INSERT INTO syb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Naa pisuunan si Isus puꞌ si Juan kiin, masiꞌ pinirisu. Mendadi benaꞌ misuunanen, migawaꞌ si Isus dia, mipuliꞌ ditu prubinsya Galilea. ");
INSERT INTO syb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ndaꞌ na pegbenwa ditug lunsud Nazaret, ditu pelum minuliꞌ Capernaum, lunsud dia geksid Linaw Galilea, sakup benwa ni Zabulon mukaꞌ ni Neftali dengantu. ");
INSERT INTO syb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Dia minuliꞌ si Isus, adun menuud su sinulat dengantu ditu Misulat Taluꞌ nu Megbebayaꞌ nu pimuunanen si Isaias, laungen, ");
INSERT INTO syb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Aa naa, ki nga sakup kiin nug benwa ni Zabulon mukaꞌ ni Neftali, ditu mesempel dagat, ditug dipag Jordan, ditu Galilea, benwa dadema nu nga kanaꞌ getaw Judea! ");
INSERT INTO syb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ilan kiin, migbenwa ilan di medelem, dagid minitaꞌ na nilan ki tiag, medelag gupia. Sakup ilan nug benwa nu kepatay, mileman ilan dun, dagid midelagan nailan nu tiag.” ");
INSERT INTO syb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mendadi benaꞌ mikauliꞌ si Isus dia Galilea, pikpuunanen na ki kektituluꞌen. Kaliꞌ pektaluꞌ, “Peksikesuun amu, puꞌ ki Keglekaunutan nu Megbebayaꞌ, pikpuunan na!” ");
INSERT INTO syb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Naa duuni gendaw, mikpanaw si Isus dia geksid Linaw Galilea. Sinegayen mpanaw, duunig duaꞌ tawan menelisedaꞌ mipegitaꞌen, pekpenadap ilan diag linaw. Mekpated ilan, ngalan nilan si Simon sala ngalanen si Pedro mukaꞌ si Andres. ");
INSERT INTO syb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Mendadi sinabi ilan ni Isus, laungen, “Pegdunut amu dinaan. Kanaꞌ na sedaꞌi peglaaman niu, puꞌ getaw na, adun sumakup ilan dinaan.” ");
INSERT INTO syb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Lemen laak midengeg nug duaꞌ tawan kini su tinaluꞌ ni Isus, bileng nilan dayun su sadap nilan, migdunut ilan tuꞌu dini Isus, suminakup nailan diniin. ");
INSERT INTO syb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Naa benaꞌ minundas pa si Isus, duun pelumi mipegitaꞌen duaꞌ tawan mekpated dadema, si Santiago mukaꞌ si Juan, gamaꞌ nilan si Sebedeo. Dia ilan duaꞌ sekayan nilan, ilan nu gamaꞌ nilan kia si Sebedeo, pengendamen nilan su pukut nilan. Inggat ilan dayun ni Isus sumakup diniin. ");
INSERT INTO syb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Sikna midengeg nilan, binilin nilan dayun su sekayan nilan sampay su gamaꞌ nilan, dayun ilan duaꞌ megdunut dini Isus, suminakup nailan dema diniin. ");
INSERT INTO syb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Naa mendadi si Isus, lineepen su tibuuk prubinsya Galilea kia, mikpetuꞌun dia nga simbaan nu getaw Judea mukaꞌ migukit di Gempia Petenday puꞌ pikpuunan na su Keglekaunutan nu Megbebayaꞌ. Pineguliꞌanen pa pagid su nga migladu, pia alandunig leduunen atawaka kulang dig lawasen. ");
INSERT INTO syb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Saꞌ maꞌantu, misigwag sug dengeganen, sampay tu tibuuk benwa Siria, kaas iwit ditu niin su kelaun getaw misaitan. Adin su milegenan, pia alanduni puunanen, saꞌ leduun saꞌ silunuꞌan menulay, saꞌ binabuy sampay su pilung, pineguliꞌan ni Isus gelaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kaas melaun gupia getaw duminunut diniin. Sug duma, getaw Galilea, sug duma, genat ilan tu Sepuluꞌ Lunsudan mukaꞌ tu Jerusalem, dakus tug liwagan Judea, sampay tug dipag Jordan. ");
INSERT INTO syb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Naa benaꞌ minitaꞌ ni Isus su melaun gupia getaw mipungun dia, subay tumiwad iin dig bentud, dayun migingkud. Piglidungan dayun si Isus nu nga sakupen, ");
INSERT INTO syb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","dayun mikpuun mektituluꞌ tu nga getaw. ");
INSERT INTO syb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Mendadi kaliꞌ pektaluꞌ si Isus, “Naa, adin su engkenenen puꞌ duuni kulangen tu kekesuunen, liliag iin, puꞌ mikesakup tu Keglekaunutan nu Megbebayaꞌ! ");
INSERT INTO syb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Adin su milegenan, liliag dadema, puꞌ pengemuꞌen nu Megbebayaꞌ! ");
INSERT INTO syb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Adin su mekpebabaꞌ dig lawasen, liliag dadema, puꞌ pitenged diniin su tibuuk lumbang! ");
INSERT INTO syb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Adin su megutem mukaꞌ kuaun di kekesuunen, liliag dadema, puꞌ pebesugen dun nu Megbebayaꞌ! ");
INSERT INTO syb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Adin su melilelaaten tug dumanen, liliag dadema, puꞌ lelaatan dadema nu Megbebayaꞌ! ");
INSERT INTO syb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Adin su mekesuun gupia dig delendemanen, liliag dadema, puꞌ maitaꞌen pa su Megbebayaꞌ! ");
INSERT INTO syb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Adin su mekpeseksud tu samatawen, liliag dadema, puꞌ iini paingalan dun nu Megbebayaꞌ, bataꞌen! ");
INSERT INTO syb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Adin su pelegetan sabaꞌ nu kekesuunen, liliag dadema, puꞌ mikesakup na tu Keglekaunutan nu Megbebayaꞌ!” ");
INSERT INTO syb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Laung padun ni Isus, “Naa saꞌ maꞌantu, saꞌ tampalaksaan amu mukaꞌ pelegetan amu dakus duuni membaal mekatag diniu sabaꞌ nu kesakup niu dinaan, naa liliag amu. ");
INSERT INTO syb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kaas saꞌ maꞌniai mbianan niu, pegleliag amu dun, puꞌ duun pai sugda diniu gembagel ditu gekbus langit. Puꞌ iini sama niu, su nga pimuunan nu Megbebayaꞌ dengantu, puꞌ maꞌantu dademai kekpeleget dinilan nu getaw.” ");
INSERT INTO syb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Kaliꞌ pektaluꞌ si Isus, “Naa yamu, pitanggiꞌu amu tu masin nu tibaꞌan getaw. Laak ki masin, saꞌ meksitebang, kendutaꞌen ma dun pekpepuliꞌ tu kepaiten? Saꞌ kanaꞌ na gempait, ndaꞌ nai gatagen, benaꞌ belengen, maindegan na laak nu getaw. ");
INSERT INTO syb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Pitanggiꞌu damu dema tu suluꞌ, medelagan dun su tibaꞌan getaw dig lumbang. Mukaꞌ kig lunsud pa pagid, saꞌ pinenggiꞌ dig dibabaw bentud mbetang, medayag gupia nu getaw. ");
INSERT INTO syb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mesama dadema di suluꞌ. Saꞌ tutudan, ndiꞌ dayun ukluban bandi, segaga betangen dig dempaꞌan, adun medelaganen su tibaꞌan getaw dia seled nug balay. ");
INSERT INTO syb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kaas yamu, maꞌantu dadema. Subay mekesuun amu, damikian dun tuiag amu di gedapan nu getaw, adun maitaꞌ nilan ki penggulaulaan niu melengas, penalan nilan dayun su Gamaꞌ niu ditu gekbus langit.” ");
INSERT INTO syb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Kaliꞌ pektaluꞌ si Isus, “Mendadi, kanaꞌ iini delendemen niu puꞌ luminusadu dun dinig lumbang adun suklian ku su Palinta nu Megbebayaꞌ pisulaten dini Moises mukaꞌ tu ngag duma pimuunanen dengantu. Sinangkaliꞌ su Palinta, penuuden ku! ");
INSERT INTO syb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Puꞌ taman taluꞌu diniu, sampay megelaꞌ mbeleng su gekleb langit buꞌ lupaꞌ, ki Palinta, ndiꞌ mengkanan sektaang taluꞌ, subay megelaꞌ menuud. ");
INSERT INTO syb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kagina maꞌantu, pia su tampusan megaan pinalinta, adin su memilas dun mukaꞌ tituluꞌaneni samatawen memilas da dun dema, iini mbaal tampusan gembabaꞌ sakup di Keglekaunutan nu Megbebayaꞌ. Dagid adin dema su dumunut tu Palinta mukaꞌ mektituluꞌ di samatawen dumunut da dun dema, iini mbaal metaas sakup di Keglekaunutan nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kaas taman taluꞌu diniu, ndiꞌ amu mekesakup tu Keglekaunutan nu Megbebayaꞌ, subay ki kekesuun niu, metuud pa di kekesuun nu nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ mukaꞌ nu nga Pariseo.” ");
INSERT INTO syb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Naa mendadi, miktituluꞌ si Isus, laungen, “Misuunan niu puꞌ dengantu, tinituluꞌ tu nga getaw su palinta, laung, ‘Ndiꞌa pekpatay. Adin su mekpatay, ukuman.’ ");
INSERT INTO syb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Laak dagid iin pa paduni taluꞌu diniu nandaw, adin su getaw mangit di samatawen, ukuman dadema. Adin su menampalaksa dig dumanen, dengaten ditu Pikumpungan nu Metaas Gukum nu getaw Judea. Adin su getaw mektaluꞌ dig dumanen, ‘Benguꞌbenguꞌen ka,’ mekangay tug linaw gapuy su mektaluꞌ dun. ");
INSERT INTO syb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kaas saladuaꞌ diniu, saꞌ diaan ka gentudan gilak megilaka sia tu Megbebayaꞌ, dayun melabuꞌ dig delendeman mu puꞌ duunig laatan ginaa nug duma mu diniꞌa, ");
INSERT INTO syb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","naa ndiꞌ mu pa ilakay sug betang mu. Subay bilinen mu deliꞌ dia mesempel di gentudan gilak, puꞌ laaway mu pa deliꞌ sug duma mu kia adun megeksud amu, dekaga pa mpuliꞌ megilak tu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Laung ni Isus, “Saꞌ duuni dumangat diniꞌa, dedeliꞌay mu pengamuyuꞌay, selian niu duaꞌ dia pa dalan pangay tu pengukuman. Puꞌ tekaw mbuus saꞌ mateng amu ditu pengukuman, pegwakila niin dayun tu kuis. Dayun pegwakila pelum tu pulis. Deksuꞌanen, pirisuun ka. ");
INSERT INTO syb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Taman taluꞌu diniꞌa, ndiꞌa na mekeguaꞌ tu pirisuan, subay megelaꞌ mu pa sia biaday su selaꞌan mu, ndiꞌ na engkanan, pia selaad siin.” ");
INSERT INTO syb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Pibundas gusay ni Isus su taluꞌen, “Mendadi, misuunan niu puꞌ duuni palinta ditu Misulat Taluꞌ nu Megbebayaꞌ, laung, ‘Ndiꞌ a pegdusa.’ ");
INSERT INTO syb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Dagid duun pa paduni taluꞌu diniu nandaw, pia laak pegenlengan da nu getawig libun, saꞌ tebiaꞌ dialem ginaanen mayak dun, naa kiin, mikesalaꞌ dusa. ");
INSERT INTO syb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kaas saladuaꞌ diniu, saꞌ pegdaangan ka, ki mata mu dapit lintui mekesabaꞌ dun, naa asak mui mata mu kiin, beleng mu dayun! Puꞌ melengas pa diniꞌa saꞌ salabuukig lisu mata mu, sabayaꞌ su tibuuk lawas mu, lebuꞌen tug linaw gapuy. ");
INSERT INTO syb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mukaꞌ pagid saꞌ pegdaangan ka, ki kemet mu pelum dapit lintui mekesabaꞌ dun, naa putuk mui kemet mu kiin, beleng mu dayun! Puꞌ tumuꞌ pa pungkula, sabayaꞌ mekauliꞌ tug linaw gapuy su tibuuk lawas mu. ");
INSERT INTO syb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Naa duun pagidi palinta, laung, ‘Adin sug laki belengenen su sawanen, subay mekpebaal pa keligenan tuꞌus dun, begayen dayun ditu sawanen.’ ");
INSERT INTO syb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Dagid iin pa paduni taluꞌu diniu nandaw, adin sug laki belengenen su sawanen, asa ndaꞌ penlelingay sug libun, dayun saꞌ duun pelumig lain laki menginsawa dun, naa kiin, mikesalaꞌ dusa sug libun, laak sug bekna sawaneni mikesabaꞌ dun. Mukaꞌ padun saꞌ megbeleng su senlangan, adin dayunig lain laki menginsawa pelum dig libun kia, naa mikesalaꞌ dadema dusa. ");
INSERT INTO syb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Naa misuunan niu puꞌ duun pagidi palinta tu getaw dengantu, laung, ‘Ndiꞌa sumapa dig balus. Adin su pesaden mu tu Kaunutan Megbebayaꞌ, tumanay mu.’ ");
INSERT INTO syb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Dagid iin pa paduni taluꞌu diniu nandaw, saꞌ masad amu, ndiꞌ amu sapa. Saladuaꞌ diniu, ndiꞌa daan sapa sembayan mu sug langit, puꞌ iini gingkudan nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ndiꞌa dadema sapa, sembayan mu sug lumbang, puꞌ iinig bendayan nu Megbebayaꞌ. Dakus su Jerusalem dadema, ndiꞌa dadema sapa sembayan mu, puꞌ iinig lunsud nu Tampusan Metaas Gadiꞌ, su Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ndiꞌa daan sapa, pia sembayan mu su gumul mu. Puꞌ su kilawan, kanaꞌ iini megbayaꞌ tu gumulen. Puꞌ pia su sebalu tug buuk mu, kanaꞌ yaꞌai megbayaꞌ di keputiꞌen. ");
INSERT INTO syb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kaas pengakuꞌ na laak amu atawaka pegbelibad amu, daal daia. Puꞌ saꞌ sumapa amu, midunutan niu su mauyaꞌan nu Palin. ");
INSERT INTO syb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Naa misuunan niu pa pagid puꞌ duuni palinta, laung, ‘Saꞌ duuni getaw mekpebuta di samatawen, su mikpebuta, butaan dadema. Mesama di getaw meksepuꞌ ngisi nu samatawen, sepuꞌan dadema ngisi.’ ");
INSERT INTO syb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Dagid iin pa paduni taluꞌu diniu nandaw, saꞌ pelaatan amu, ndiꞌ amu suliꞌ. Kaas saladuaꞌ diniu, saꞌ pinenggiꞌ depiꞌen ka di muluꞌ mu dapit lintu, pedapiꞌ mu dun pa pagid su sedibaluy muluꞌ mu ditug duminapiꞌ diniꞌa. ");
INSERT INTO syb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Saꞌ duuni dumangat diniꞌa, iini peluaten diniꞌa ki suub mu, begay mu dun pa pagid su kamisita mu, peduma mu padun su suub mu. ");
INSERT INTO syb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Saꞌ duuni pebaba diniꞌa nu getaw sala kilumitru, baba mu duaꞌ kilumitru. ");
INSERT INTO syb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Saꞌ duuni menengi diniꞌa, begayay mu. Saꞌ duuni medam diniꞌa, pedam mu. ");
INSERT INTO syb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Naa misuunan niu pa pagid su penteluꞌen dengantu, laung, ‘Petail mu sug duma mu. Su kuntra mu, bentaay mu.’ ");
INSERT INTO syb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Laak kinii taluꞌu diniu nandaw, ki nga kuntra niu, petail da niu dema. Ki nga mekpeleget diniu, penenebiay niu mpianan. ");
INSERT INTO syb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Puꞌ saꞌ maꞌniai penggulaulaan niu, mengemaꞌan amu tu Gamaꞌ niu ditu gekbus langit dig betad. Puꞌ daniin betad, pedelaganen gendaw su mekesuun getaw mesama di nga melaat getaw, begayanen dupiꞌ su gempiaig betaden mesama da di nga melaatig betaden. ");
INSERT INTO syb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Puꞌ saꞌ iin da laaki petailen niu su mekpetail diniu, bantang bamu sugdaan dun nu Megbebayaꞌ? Puꞌ pia su nga melimbung mendawat buis, mekpetail dailan dema tu nga mekpetail dinilan! ");
INSERT INTO syb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mukaꞌ saꞌ iin laaki penembaꞌen niu su nga sambat niu, penalan bamu dun? Pia su kanaꞌ mekpetuud tu Megbebayaꞌ, maꞌnia dademaig betad nilan! ");
INSERT INTO syb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yamu dagid, subay menggangeti kekesuun niu, maaꞌ dadema nu Gamaꞌ niu ditu gekbus langit, mekesuun tantu.” ");
INSERT INTO syb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Mendadi, kaliꞌ pektaluꞌ si Isus, “Pektalentenay niu ki kektamuy niu tu Megbebayaꞌ, adun ndiꞌ niu pektemuyen su Megbebayaꞌ dia laak gedapan nu melaun getaw, adun mekpaitaꞌitaꞌ laak di samataw niu. Puꞌ saꞌ maꞌniai kektamuy niu diniin, ndaꞌi sugda dun diniu nu Gamaꞌ niu ditu gekbus langit. ");
INSERT INTO syb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Kaas saladuaꞌ diniu, saꞌ meglegamuta tu nga pubri, ndiꞌ mu pegangyaꞌ ki kegamut mu, maaꞌ nu nga tautau mekesuun. Puꞌ dia ilan pegbegay gamut gedapan nu melaun getaw, dia simbaan mukaꞌ dia nga selengayan, adun penalan ilan nu getaw. Taman taluꞌu diniu, saꞌ penalan ilan nu getaw, daal daitui sugda dinilan. ");
INSERT INTO syb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Yaꞌa dagid, saꞌ meglegamuta tu pubri, ndiꞌ mu pesuun di getaw, pia di putulpused mu. ");
INSERT INTO syb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Laak dagid pia egluden tu getaw ki kektamuy mu, mesuunan da nu Gamaꞌ mu, puꞌ su tibaꞌan mitebunan, maitaꞌen. Iin dayuni sumugda diniꞌa.” ");
INSERT INTO syb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Kaliꞌ pektaluꞌ si Isus, “Mendadi saladuaꞌ diniu, ndiꞌ mu penunggilingay su kenenabi nu nga tautau mekesuun! Puꞌ megindeg ilan menenabi diag dialem simbaan atawaka dia nga selengayan, adun maitaꞌ ilan nu tibaꞌan getaw. Taman taluꞌu diniu, su sugda dinilan, migelaꞌ na nilan malap. ");
INSERT INTO syb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Yaꞌa dagid, saꞌ menenabia, angaya dia sugud mu, takep mu, diaan ka dayun penenabi tu Gamaꞌ mu, sala mu da. Puꞌ su Gamaꞌ mu, maitaꞌen su kelaun mitebunan, kaas iin dademai sumugda diniꞌa di kenenabi mu. ");
INSERT INTO syb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","8","“Mukaꞌ pagid ndiꞌ niu penunggilingay ki kenenabi nu nga kanaꞌ mekpetuud tu Megbebayaꞌ, paibenen nilan gupia su kenenabi nilan, asa ndaꞌiduni maꞌananen. Puꞌ laung nilan dun, duaten nug diwata su kenenabi nilan sabaꞌ maiben metubus. Laak dagid adin su kulang di sukat niu, daan na misuunan nu Gamaꞌ niu, pia ndaꞌ pa niu mpenenebiay. ");
INSERT INTO syb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Mendadi,” laung padun ni Isus, “kiniig bian nu kenenabi niu. Iini taluꞌ niu, ‘Uu Amaꞌ nami tu gekbus langit, Melengas pegbesaan ka nu nga getaw puꞌ yaꞌa su Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Melengas pekpuunan na su Keglekaunutan mu. Su mauyaꞌan mu, penuuden dinig dibabaw lumbang, maaꞌ dadema nu penggulaulaan ditu gekbus langit. ");
INSERT INTO syb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Begay mu dinami gendawgendaw ki gaan nami, sukal di ketubuꞌ nami. ");
INSERT INTO syb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pedasun mu ami di nga salaꞌ nami, maaꞌ dadema nu kekpedasun nami tu nga mekesalaꞌ dinami. ");
INSERT INTO syb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mukaꞌ ndiꞌ mu buangay, mpenulay ami, gawen mu ami di Palin.’” ");
INSERT INTO syb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Diksuꞌ ni Isus su taluꞌen, “Puꞌ saꞌ pedesunen niu su salaꞌ nu nga samataw niu, pedesunen damu dema nu Gamaꞌ niu ditu gekbus langit. ");
INSERT INTO syb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Laak dagid saꞌ ndiꞌ niu pedesunen su salaꞌ nu nga samataw niu, ndiꞌ dema pedesunen nu Gamaꞌ niu su salaꞌ niu.” ");
INSERT INTO syb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Kaliꞌ pelum pektaluꞌ si Isus, “Mendadi saꞌ mekpuasa amu, ndiꞌ amu pegdemeng, maaꞌ nu nga tautau mekesuun. Penlikusengen nilan su muluꞌ nilan, adun mailala nu nga getaw puꞌ mikpuasa ilan. Taman taluꞌu diniu, migelaꞌ na nilan malap su sugda dinilan. ");
INSERT INTO syb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Dagid yamu pelum, saladuaꞌ diniu saꞌ mekpuasaa, pengulamusa mukaꞌ penundaya, ");
INSERT INTO syb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","adun ndiꞌ mesuunan nu getaw puꞌ mikpuasaa, puꞌ misuunan da nu Gamaꞌ mu, su maitaꞌen su kelaun mitebunan. Iin demai sumugda diniꞌa.” ");
INSERT INTO syb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Kaliꞌ pektaluꞌ si Isus, “Naa ki gimu dinig dibabaw lumbang, kanaꞌ iini penteguꞌen niu, su melemu aanen guled atawaka gaangen, melemu dadema pegdaun nu getaw. ");
INSERT INTO syb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Segaga iini taguꞌ niu, ki gimu ditu gekbus langit, ndiꞌ mesuꞌat aanen guled atawaka gaang, sampay ndiꞌ dadema mesuꞌat pegdaun. ");
INSERT INTO syb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Puꞌ adin mibetang su gimu niu, ditu dademaig delendeman niu.” ");
INSERT INTO syb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Kaliꞌ pektaluꞌ si Isus, “Naa su mata nu getaw, iini suluꞌ nug lawasen. Kaas saladuaꞌ diniu saꞌ gempiai mata mu, naa medelagan na su tibuuk lawas mu. ");
INSERT INTO syb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Laak dagid saꞌ duuni mesait di mata mu, naa medeleman dademai tibuuk lawas mu. Su laung mu dun tiag mu, masiꞌ medelem!” ");
INSERT INTO syb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Laung ni Isus, “Naa su peneligan, ndiꞌ mesuꞌat pegdenganen tindanay nug duaꞌ tawan gegalen. Puꞌ saꞌ maꞌantu, mesengayen sug bekna gegalenen, laak petailenen su keduaꞌ gegalenen. Atawaka iini petuudenen sug bekna gegalenen, dagid teliudanen laak su keduaꞌen. Kaas su Megbebayaꞌ mukaꞌ su gaꞌus, ndiꞌ mesuꞌat pegdenganen pebegelay di ginaa niu. ");
INSERT INTO syb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Kaas taluꞌu diniu, ndiꞌ niu libulengayi ketubuꞌ niu, saꞌ taꞌ ma saani aanen niu mukaꞌ inumen niu, saꞌ taꞌi kenapet niu. Puꞌ su ketubuꞌ nu getaw, kanaꞌ ba gembageli pantagen sabayaꞌ nu kaꞌaanen? Sug lawas nu getaw, kanaꞌ ba gembagel dademai pantagen, sabayaꞌ nu kenapeten? ");
INSERT INTO syb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mukaꞌ pegbentayay niu pagid su nga manukmanuk. Su manukmanuk, ndiꞌ memula, ndiꞌ dadema meglegani, ndaꞌidun dademai timuden nilan. Laak pia maꞌantu, paanen da nu Gamaꞌ niu ditu gekbus langit su manukmanuk! Naa kanaꞌ ba labi pamu paanen, ki metaas paig lagaꞌ niu, sabayaꞌ nu nga manukmanuk? ");
INSERT INTO syb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Keduaꞌen, duun bai sala tawan diniu, megaganen petaasayi gumulen sendaw pebian di kelibulengen dun?” ");
INSERT INTO syb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Laung ni Isus, “Kiin pelum penepeten niu, alandun bai malap niu saꞌ melibuleng amu dun? Pegdelendem niu pagid sug bulak nu sigbet. Ndiꞌ mengimbaal su sigbet, ndiꞌ dadema megabel. ");
INSERT INTO syb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Laak taluꞌu diniu, pia si Adiꞌ Salomon, saꞌ migimakay gupia, ndaꞌi salabuuk bulak sigbet, kanaꞌ melengas pa di kenapet ni Salomon kitu. ");
INSERT INTO syb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Naa su sigbet, maitaꞌ nandaw, lemaꞌ mbaluy laak tagun. Laak pia maꞌantu, begayan nu Megbebayaꞌ pekayan su sigbet, saꞌitada sug bulaken. Saꞌ maꞌantu, kanaꞌ bamu labi na begayan nu Megbebayaꞌ penepeten niu? Kaas mauma dema maikaꞌ da ki kesalig niu tu Megbebayaꞌ?” ");
INSERT INTO syb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Diksuꞌ ni Isus su taluꞌen, “Kaas ndiꞌ amu melibuleng, dig dialem ginaa niu, ‘Adin ta ma sukatay ki kaꞌaan ta? Mukaꞌ kainum ta? Mukaꞌ penepeten ta?’ ");
INSERT INTO syb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","(Puꞌ su nga kanaꞌ mekpetuud, gembagelig delendeman nilan dun.) Yamu pelum, misuunan na nu Gamaꞌ niu ditu gekbus langit su kelaun kulang di sukat niu. ");
INSERT INTO syb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Segaga iini pebagel niu dig delendeman niu, ki kesakup niu tu Keglekaunutan nu Megbebayaꞌ, mukaꞌ ki kekesuun niu. Saꞌ maꞌantu, su kelaun gininisan sukat, begay dadema nu Megbebayaꞌ diniu. ");
INSERT INTO syb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kaas su kelegenay ndaꞌ pa niu mbianay, ndiꞌ amu melibuleng dun. Puꞌ gendawgendaw duuni kelegenay nu getaw. Sukal pegdelendemen saꞌ mateng na tuꞌu.” ");
INSERT INTO syb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Kaliꞌ pektaluꞌ si Isus, “Mendadi, ndiꞌ niu pegdenaꞌay su nga samataw niu, adun ndiꞌ amu ukumen nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Puꞌ su kegdenaꞌ niu dig duma niu, iin dademai kengukum diniu nu Megbebayaꞌ, mukaꞌ adini tepengan niu dig begay niu, iin dademai tepengan nu Megbebayaꞌ tug begayen pelum diniu. ");
INSERT INTO syb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Naa saꞌ maꞌnia, mauma dema saladuaꞌ diniu, maitaꞌ mu ki maikaꞌ puling di mata nug duma mu, laak yaꞌa, ndaꞌ mu metukaway puꞌ duun dademai puling mu, gembagel? ");
INSERT INTO syb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Mukaꞌ pagid mauma dema teluꞌen mu pelum tug duma mu, ‘Uy, uaꞌen ku pa deliꞌ ki puling mu kiin,’ asa yaꞌa dema, mipulinga dadema gembagel puling? ");
INSERT INTO syb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Baa, yaꞌa kiin, tautau mekesuun ka! Kaas unaay mu uaꞌay ki gembagel puling di mata mu kiin, adun mpalas mu su maikaꞌ puling nug duma mu, adun mawaꞌ mu.” ");
INSERT INTO syb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Laung pagid ni Isus, “Ki nga gituꞌ, ndiꞌ niu paan dun su ginilak ditu Megbebayaꞌ, puꞌ mbuus lumingay diniui gituꞌ kia, penupasen amu nilan. Mesama da ki ngag babuy, ndiꞌ niu piglakay dyamanti, puꞌ ndiꞌ nilan aanen, laak maindegan nilan.” ");
INSERT INTO syb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Laung ni Isus, “Mendadi penamal amu menenabi tu Megbebayaꞌ, begayan amu niin. Penamal amu menengaw, puꞌ mekebaang amu. Peksabi amu namal diag bisuangan, puꞌ pukaꞌan amu tuꞌu. ");
INSERT INTO syb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Puꞌ adini menamal menenabi, begayan tuꞌu. Adini menamal menengaw, mekebaang, mukaꞌ adini meksabi diag bisuangan, mpukaꞌan. ");
INSERT INTO syb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Puꞌ yamu ngag duunig bataꞌen, duun bai sala tawan diniu, saꞌ pinenggiꞌ menengi panig bataꞌen, begayen sungkin diniin batu? ");
INSERT INTO syb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Atawaka saꞌ meksaak sedaꞌ, begayen pelum diniin mamak? ");
INSERT INTO syb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mendadi yamu, saꞌ metau amu megbegay kepianan tu gembataꞌ niu, asa melaat getaw amu, naa labi na su Gamaꞌ niu ditu gekbus langit, begayen dema tuꞌu kepianan tu nga meksaak dun diniin! ");
INSERT INTO syb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Mendadi pia taꞌ alanduni melabuꞌ dig delendeman niu melengas sia gabang nug duma niu diniu, iini baal niu dinilan. Puꞌ maꞌniai tantu gulugan nu tibuuk Palinta nu Megbebayaꞌ pisulaten dini Moises mukaꞌ tu ngag duma pimuunanen dengantu.” ");
INSERT INTO syb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Laung ni Isus, “Mendadi iini bianay niu, ki mesikut gengaꞌan. Puꞌ ki sala gengaꞌan pangay tug linaw gapuy, meliwag, dayun sug dalan pangay ditu, melemu dadema unuten, melaun getaw mayan dun. ");
INSERT INTO syb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ki pelum gengaꞌan pangay tu ketubuꞌ ndaꞌi tamanen, mesikut, dayun sug dalan pangay ditu, melegen unuten, meliangi getaw mekebaang dun. ");
INSERT INTO syb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mendadi ki nga mekpetuꞌun dig balus, peglengilamay niu. Puꞌ saꞌ metuaꞌ ilan diniu, pitanggiꞌu ilan di nga malig metetubuꞌ mendapaꞌ di karniru, laak miglanguban dadema di karniru. ");
INSERT INTO syb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Naa, kiniig bian niu mengilala dun saꞌ metuud mai piktuꞌun, saꞌ balus ma. Kimanay niu su penggulaulaan nu mekpetuꞌun. Puꞌ sug bunga gubas, maupuꞌ ba dig dugi? Maupuꞌ ba dig dugi sug bunga igera? ");
INSERT INTO syb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Adini gempia gayu, megbunga dadema melengas. Dagid adini melaat gayu, megbunga dadema melaat. ");
INSERT INTO syb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Puꞌ ndaꞌiduni gempia gayu megbunga melaaten. Mesama di melaat gayu, ndaꞌiduni megbunga melengas. ");
INSERT INTO syb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Mukaꞌ pagid adini gayu ndiꞌ megbunga gempia, penegaꞌen nu Megbebayaꞌ, dayun piglakay tu gapuy. ");
INSERT INTO syb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kaas ki nga mekpetuꞌun dig balus, mailala niu tu penggulaulaan nilan.” ");
INSERT INTO syb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Laung ni Isus, “Mendadi kanaꞌ iini mekesakup tu Keglekaunutan nu Megbebayaꞌ, ki kelaun getaw gelalenu nilan Kaunutan. Iin laaki mekesakup dun, ki menggulaula tu mauyaꞌan nu Gamaꞌu ditu gekbus langit. ");
INSERT INTO syb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kaas saꞌ mateng ki Gendaw nu Kengukum nu Megbebayaꞌ di tibaꞌan getaw, melaun getaw mektaluꞌ dinaan, ‘Uu Kaunutan nami, migwali ami Taluꞌ nu Megbebayaꞌ pibian di pegbayaꞌ mu, mukaꞌ pingutidan namii menenulay, dakus melaun mekesalebuꞌ pinggulaula nami pibian di pegbayaꞌ mu!’ ");
INSERT INTO syb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Dayun ku sembagay, ‘Baa, yamu kiin, ndiꞌu amu mailala. Pelayuꞌ amu dinaan, yamu nu nga meglimbung!’” ");
INSERT INTO syb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Laung ni Isus, “Mendadi adin su getaw mekineeg di teluꞌen ku kini dayun megdunut dun, penenggiꞌan duni telisebuten getaw migbaal balay, gintuden di telektap sug balayen. ");
INSERT INTO syb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Naa benaꞌ mitubus sug balay, migdupiꞌ gempales, migbaaꞌ, mukaꞌ dinulukan medekdes genus sug balay. Laak ndaꞌ megebaꞌ, sabaꞌ gintud dig batu. ");
INSERT INTO syb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Laak dagid adini getaw medengegen ki taluꞌu kini laak ndiꞌen dunutan, iini maaꞌ nug benguꞌbenguꞌen getaw, migbaal balayen dia pentad. ");
INSERT INTO syb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Migdupiꞌ dadema gempales, migbaaꞌ pa pagid. Dayun kig balayen kia, dinulukan metikteg genus, migebaꞌ gupia. Pia sebulus tu pataꞌen, ndaꞌiduni mibilin dun.” ");
INSERT INTO syb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Naa benaꞌ mideksuꞌ ni Isus su pidengegen tu melaun getaw, misebuꞌan ilan dun su tituluꞌen kia. ");
INSERT INTO syb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Puꞌ su tituluꞌanen, duuni pegbayaꞌen. Saꞌ iini mektituluꞌ dinilan su nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, naa mamaꞌ ndaꞌi pegbayaꞌ nilan. ");
INSERT INTO syb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Naa saꞌ duminiksun si Isus genat dig bentud kia, melaun gupia getaw migdunut diniin. ");
INSERT INTO syb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mendadi duuni pegladu mekesalebuꞌ nuka mikpesempel dini Isus, minginlulud dayun di gedapanen, laungen diniin, “Sir, saꞌ mauyaꞌan mu da, misuunan ku megaga mau pauliꞌay.” ");
INSERT INTO syb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tinggal ni Isusi kemeten, dipenaneni getaw kia, kaliꞌ pektaluꞌ, “Naa, mauyaꞌan ku lai. Mauliꞌan ka dadema tuꞌu!” Seduꞌunduꞌun miawaꞌ dayun su mekesalebuꞌ nukanen. ");
INSERT INTO syb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Laak laung ni Isus, “Petuud mu gupiai taluꞌu kini diniꞌa! Pia sala tawan, ndaꞌiduni ukitan mu di mipenggulaula kini. Segaga angaya ditug belian, pekpebantaya diniin, dayun ilak mu sug betang pinalinta ni Moises dengantu, puꞌ adun metakesiꞌan ka nu getaw miawaꞌ na su kelemuꞌay mu.” ");
INSERT INTO syb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Mendadi benaꞌ midepet si Isus tug lunsud Capernaum, duuni kaunutan di sundalu nu getaw Roma luminabet diniin, mikpaingabang diniin, ");
INSERT INTO syb_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","laungen, “Sir, kelelaat diniꞌa, duuni sesuguꞌen ku ditug balayu migladu gupia, mipilung. Milegenan gupia dun.” ");
INSERT INTO syb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Kaliꞌ sembag si Isus, “Naa, medituunu, pauliꞌan ku.” ");
INSERT INTO syb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Dagid sumimbag su kaunutan di sundalu, “Naa naan, Sir, kanaꞌ mbantang seledan muig balayu. Pektaluꞌa laak diin, naa misuunan ku puꞌ mauliꞌan tuꞌui sesuguꞌen ku kia. ");
INSERT INTO syb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Puꞌ maaꞌ dinaan kini, duuni metaas pa dinaan sumuguꞌ dinaan, duun pa pagidi sundalu suguꞌen ku. Teluꞌan kui sala tawan, ‘Dituun ka angay,’ meditu dayun. Teluꞌan ku pelumi sala tawan, ‘Diniin ka angay,’ medini dadema. Saꞌ teluꞌan ku su gulipen ku, ‘Maꞌniniꞌi baalen mu,’ naa baalenen dayun.” ");
INSERT INTO syb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Benaꞌ midengeg ni Isusi tinaluꞌ kia nu sundalu, misebuꞌan dun gupia. Kaliꞌ pektaluꞌ dia nga tumindug diniin, “Taman taluꞌu diniu, ki kaunutan kini, ndaꞌu mainsan mbianayi kesalig mesama di kesaligen, pia pa dini nita nga getaw Israel! ");
INSERT INTO syb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kaas taman taluꞌu diniu, saꞌ meglekaunutan na tuꞌu su Megbebayaꞌ, melaun tuꞌu getaw dig lain bansa metuaꞌ, genat ilan tu silangan sampay tu sindepan, sumaup ilan tu keglekebibu ditu Keglekaunutanen, puꞌ dungan ami maan dini nga Abraham, si Isaac, mukaꞌ si Jacob. ");
INSERT INTO syb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Dagid ki nga duma getaw gasal nilan sia mpeduma ilan tu Keglekaunutan nu Megbebayaꞌ puꞌ getaw Israel ilan, naa piglaken laak ilan ditug liu, tu medelem. Ditu ilan dayun mengaduy, lamug mengkiget ilan di ngisi nilan.” ");
INSERT INTO syb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Laung dayun ni Isus tu kaunutan di sundalu, “Uliꞌa na, puꞌ su pituud mu, menuud tuꞌu.” Iin dayun tuꞌui kauliꞌay nu sesuguꞌenen kia, mitaang gupia ditu ketaluꞌ dun ni Isus. ");
INSERT INTO syb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Naa minundas si Isus ditug balay ni Pedro. Mendadi benaꞌ mitulan dia si Isus, minitaꞌen pegladu ki penugangan ni Pedro libun, mipanas, ndiꞌ mekegbuat. ");
INSERT INTO syb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Dipenan dayun ni Isus su kemet nug libun. Lemen laak midepenan ni Isus, migwanan dayuni panasen. Migbuat sug libun mukaꞌ mikpelutuꞌ, migilak dayun dini nga Isus. ");
INSERT INTO syb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Naa benaꞌ lelabung na, melaun getaw piglegetan menenulay pinguit nu nga getaw ditu ni Isus. Pingutidanen dayun dinilan su menenulay, sektaang laaki tinaluꞌen, minawaꞌ ilan dayun. Mukaꞌ pineguliꞌanen pa pagid su kelaun pegladu. ");
INSERT INTO syb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kaas maꞌniai mipenggulaula, adun menuud su sinulat dengantu ditu Misulat Taluꞌ nu Megbebayaꞌ nu pimuunanen si Isaias, laungen, “Inawaꞌen su mesait ta, pineguliꞌanen su ngag leduun ta.” ");
INSERT INTO syb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Naa benaꞌ lain endaw, benaꞌ minitaꞌ ni Isusi melaun gupia getaw mikpungun diniin, kaliꞌ pektaluꞌ tu nga sakupen, “Naa, dumipag ita dinig linaw.” ");
INSERT INTO syb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Laak saꞌ ndaꞌ pailan pekepanaw, duuni getaw mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ luminabet dini Isus, kaliꞌ pektaluꞌ diniin, “Sir, pia adin ka angay, megdunutu diniꞌa.” ");
INSERT INTO syb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Kaliꞌ sembag si Isus, “Laak naan, kig Bataꞌ nu Kilawan, ndaꞌidun tanani pektulugan ku. Tumuꞌ pa su nga teleksuy, duuni gateb nilan, mukaꞌ su nga manukmanuk, duuni salag nilan.” ");
INSERT INTO syb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Naa duun pelumig lain getaw, sakup ni Isus, kaliꞌ pektaluꞌ diniin, “Sir, muliꞌ pau deliꞌ, puꞌ unaan ku pa lebengay su gamaꞌu.” ");
INSERT INTO syb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Kaliꞌ pelum sembag si Isus, “Baa, dunuta dinaan. Su nga pangay tu kepatay ndaꞌi tamanen, melengas ilan nai meglebeng tu nga matay dinilan.” ");
INSERT INTO syb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Naa duminangan si Isus di sekayan, ilan nu nga sakupen. ");
INSERT INTO syb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mendadi benaꞌ ditu nailan laud nug linaw, tekaw miksalindapak, misipukan dayun tubig ki sekayan nilan kia. Dagid si Isus, pektulug. ");
INSERT INTO syb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Mikpesempel dayun diniin su nga sakupen, tinanud nilan dayun, laung nilan, “Ii, Kaunutan, gawen mu ami! Megbayaꞌbayaꞌ ita dun ini!” ");
INSERT INTO syb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kaliꞌ sembag si Isus, “Mauma mendek mamu? Maikaꞌ da ki kesalig niu dinaan!” Migbuat si Isus, pimaagen dayun su genus mukaꞌ su nabek. Miksilengen gupia tuꞌu sug linaw. ");
INSERT INTO syb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Su kelaun duma ni Isus, misebuꞌan ilan dun. Laung nilan, “Taꞌ gasal dun saan ini, pia su genus mukaꞌ nabek, mekpetuud diniin?” ");
INSERT INTO syb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Naa, midengguꞌ si nga Isus tug dipag nug linaw, ditug benwa piningalan dun Gadara. Benaꞌ mikelusad ilan, duunig duaꞌ tawan suminungkak dini Isus, betad nilan dia nailan pegbenwa nga sangyab kelebengan, puꞌ ki getaw kini, silunuꞌan ilan menenulay. Mekendekendek ilan gupia, kaas kanaꞌ bianan nu getawig dalan mekebian di kelebengan kia. ");
INSERT INTO syb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Mendadi, benaꞌ minitaꞌ nu nga silunuꞌan kia si Isus, minekeg ilan megbeksay, laung nilan, “Ii, yaꞌa, Bataꞌa nu Megbebayaꞌ, taꞌ maig labet mu dinami? Peglegetan mu ami, asa kanaꞌ pa timpu nu Kengukum?” ");
INSERT INTO syb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Naa duuni sala kauluan babuy meglunang dia mesempel, melaun gupia babuy. ");
INSERT INTO syb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Pinengi nu menenulay dini Isus, laung nilan, “Naa saꞌ utidan mu ami, peselunuꞌ mu ami ditu ngag babuy kia.” ");
INSERT INTO syb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kaliꞌ sembag si Isus, “Naa, mesuꞌat.” Dayun memegawaꞌ dia getaw kia su menenulay, sumilunuꞌ ilan pelum ditu ngag babuy. Benaꞌ su sala kauluan babuy, migelaꞌ ilan menggebek dumiksun ditug delipasan, migelaꞌ ilan dayun melemes diag linaw. ");
INSERT INTO syb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mendadi su nga megingat tu ngag babuy, minggebek ilan ditug lunsud, pigukit nilan dayun dia ki kelaun mipenggulaula kia nu nga getaw silunuꞌan menenulay. ");
INSERT INTO syb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Saꞌ maꞌnia, su kelaun getaw ditug lunsud, linaawan nilan si Isus. Benaꞌ midepet ilan diniin, inubug nilan diniin, megawaꞌ diag benwa nilan. ");
INSERT INTO syb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Naa duminangan na pelum si Isus dia sekayan, duminipag muliꞌ tug lunsud tinuunanen. ");
INSERT INTO syb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Naa benaꞌ minateng dia, duuni nga getaw pegbuligan nilan di sinampuyuan ki mipilung, iwit nilan dia ni Isus. Mendadi si Isus, benaꞌ minitaꞌen ki kesalig nilan diniin, miktaluꞌ di pilung kia, “Naung, pia dai ginaa mu! Pidasun na su salaꞌ mu.” ");
INSERT INTO syb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Naa ki nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, benaꞌ midengeg nilan ki tinaluꞌ kia ni Isus, kaliꞌ ilan pektaluꞌ dig dialem delendeman nilan, “Paa, ki getaw kini, piksudiꞌanen pelum su Megbebayaꞌ!” ");
INSERT INTO syb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Dagid misuunan ni Isusig dialem delendeman nilan kia. Kaliꞌ dayun pektaluꞌ dinilan, “Mauma dema melaatig delendeman niu? ");
INSERT INTO syb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Puꞌ saꞌ su kilawan laak, melemu pebelusen saꞌ teluꞌenen, ‘Pidasun na su salaꞌ mu.’ Melemu dadema pebelusen saꞌ teluꞌenen, ‘Pegbuata, panawa dayun.’ ");
INSERT INTO syb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Dagid naan kini, luminusad nau, miksibaluyu Bataꞌ nu Kilawan. Saꞌ maꞌantu, paitaꞌu diniu puꞌ duuni pegbayaꞌu mekpedasun di salaꞌ dinig dibabaw lumbang.” Luminingay dayun si Isus tu pilung mukaꞌ miktaluꞌ diniin, “Naa, pegbuata, sikwat mui sinampuyuan diniꞌa kiin, mukaꞌ uliꞌa na!” ");
INSERT INTO syb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Migbuat tuꞌu su pilung kia, dayun minuliꞌ tug balayen. ");
INSERT INTO syb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Benaꞌ minitaꞌ nu melaun getaw dia, mindek ilan dunut mipenalan nilan su Megbebayaꞌ, puꞌ masiꞌ mekesalebuꞌi pegbayaꞌ bigayen tu kilawan. ");
INSERT INTO syb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Naa benaꞌ minundas si Isus, duuni mipekitaꞌen sala tawan mendawat buis pegingkud diag bataꞌ gupisinanen, ngalanen si Mateo. Sinabi ni Isus si Mateo, laungen, “Dunuta dinaan.” Benaꞌ midengeg ni Mateo, migbuat dayun, migdunut tuꞌu dini Isus, suminakup na diniin. ");
INSERT INTO syb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Naa duuni gendaw, minaan si Isus diag balay ni Mateo. Melaun mendawat buis mukaꞌ duma mekesesalaꞌ getaw dumingan maan dini Isus, ilan nu nga sakupen. ");
INSERT INTO syb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mendadi ki nga Pariseo, benaꞌ minitaꞌ nilan, sinaakan nilan dayun su nga sakup ni Isus. Laung nilan, “Paa, mauma dema ki mekpetuꞌun diniu kia, dumingan main maan di nga getaw, maꞌniaig betad nilan?” ");
INSERT INTO syb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Laak kaliꞌ medengeg ni Isus su sinaak nilan, simbagen, “Naa su getaw ndaꞌig leduunen, ndiꞌ kambat mekpebulung, subay su laak duunig leduunen. ");
INSERT INTO syb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Yamu kiin, subay mesabut niu ki misulat ditu Taluꞌ nu Megbebayaꞌ, laung, ‘Iini mauyaꞌan ku penggulaulaan nu getaw, kig linelaatay, sabayaꞌ su ngag betang ilaken niu dinaan.’” Mendadi, diksuꞌ ni Isus su taluꞌen, “Naa naan kini, iini luminusadu dun dinig lumbang, adun pesikesuunen ku su laak mekesesalaꞌ getaw, kanaꞌ nu nga gandang mekesuun getaw.” ");
INSERT INTO syb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Naa mendadi duuni gendaw, su nga sakup ni Juan kiin su Memunag Tubig, luminabet ilan dini Isus, kaliꞌ ilan saak diniin, “Sir, mauma dema maꞌantu? Yami, mekpuasa mami. Saꞌ su nga Pariseo, maꞌantu dadema. Dagid su ngag daniꞌa sakup, ndiꞌ mailan mekpuasa.” ");
INSERT INTO syb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Kaliꞌ sembag si Isus, “Waꞌa daan, puꞌ penenggiꞌan dun sug belaꞌi. Su nga suminaup dig belaꞌi, kendutaꞌen ba nilan pekpuasa, saanan duma pa nilan su menginsawa? Laak dagid duuni gendaw mateng, uiꞌen dinilan ki menginsawa, dekag pailan tuꞌu pekpuasa.” ");
INSERT INTO syb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Laung pagid ni Isus, “Mesama da saꞌ eklebani suub. Duun bai getaw, iini ekleben dig danul suuben kig begu gupia penepeten? Puꞌ saꞌ pinenggiꞌ pemaꞌantuunen, saꞌ mengeleeꞌ sug begu penepeten, mauguten dayun sug danul kia, benaꞌ megdegadega dayun su keliwag nu gediten. ");
INSERT INTO syb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Mukaꞌ pagid sug betad megbetang penginumen di pemetangan binaal panit petubuꞌen, maꞌantu dadema. “Kig begu penginumen, betangen ba dig daan pemetangan? Puꞌ saꞌ pinenggiꞌ maꞌnia, saꞌ tumulin su penginumen, ndiꞌ ba megbetu su panit petubuꞌen? Deksuꞌanen, megulaꞌ su penginumen, mukaꞌ meglaat dadema su pemetanganen. Kaas sug begu penginumen, subay begu dadema su pemetanganen, puꞌ adun ndiꞌ meglaat su penginumen, sampay su pemetanganen.” ");
INSERT INTO syb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mendadi segay pa ni Isus mektaluꞌ, duuni kaunutan di simbaan nu getaw Judea minangay dia niin. Minginlulud su kaunutan di gedapan ni Isus, laungen dayun diniin, “Sir, nandaw ia sug bataꞌu delaga, minatay. Dagid pia maꞌantu, kelelaat dema tuꞌu diniꞌa, Sir, laaway mu. Puꞌ suunan ku saꞌ depenan mu, metubuꞌ puliꞌ kig bataꞌu kia.” ");
INSERT INTO syb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kaliꞌ medengeg ni Isus su tinaluꞌ nu kaunutan kia, migbuat, dayun migdunut diniin, ilan nu nga sakupen. ");
INSERT INTO syb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Laak saanan ni Isus mpanaw, duuni sala tawan libun, sepuluꞌ buꞌ duaꞌ taun na, tebiaꞌ leduunen kig betad libun. Mendadi kig libun kini, mikpesempel dia teliudan ni Isus, diluꞌen dayun su kuyamay suuben. ");
INSERT INTO syb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Puꞌ maaꞌ laungen dig dialem ginaanen, “Pia medeluꞌu laaki suuben kiin, mauliꞌan nau dun.” ");
INSERT INTO syb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Benaꞌ miakuy nug libun su suuben, luminingay si Isus, minitaꞌen dayun sug libun, kaliꞌ pektaluꞌ diniin, “Naa Enaung, gempia dai ginaa mu. Miuliꞌan ka na, sabaꞌ nu kesalig mu.” Sikna mitaluꞌ ni Isus, miuliꞌan sug libun. ");
INSERT INTO syb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Naa iin pa bundas si Isus tug balay nu kaunutan di simbaan kiin. Mendadi, benaꞌ minateng ilan ditu, minitaꞌ ni Isus su nga getaw misasaw, dakus su menlantuyan sia. ");
INSERT INTO syb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Miktaluꞌ si Isus, “Baa, gawaꞌ amu diin, launan niu! Puꞌ gembataꞌ kiin, kanaꞌ ma minatay. Pektulug da!” Piketuanan laak nu nga getaw si Isus. ");
INSERT INTO syb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mendadi si Isus, benaꞌ piguaꞌen dia su nga melaun getaw, sumiled dayun dia sugud belilidan nu gembataꞌ. Benaꞌ mikeseled, piguidanen dayun su gembataꞌ di kemet. Migbuat dayun su gembataꞌ. ");
INSERT INTO syb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Naa saꞌ maꞌantu, migleep diag lumibut benwa su gukiten nu mipenggulaula kia. ");
INSERT INTO syb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Naa benaꞌ minundas si Isus, duunig duaꞌ tawan buta tuminakin diniin. Migbeksay ilan, laung nilan, “Uu Sir, Sapuꞌa ni David, lelaatay mu ami!” ");
INSERT INTO syb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Mendadi benaꞌ mitulan dig balay si Isus, mikpesempel diniin kig duaꞌ tawan buta kini. Sinaak ni Isus dinilan, “Naa, mikpetuud amu dun puꞌ megagau meneguliꞌ diniu?” “Waꞌa, Sir!” simbag nilan. ");
INSERT INTO syb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dipenan dayun ni Isus ki mata nilan, dunut tinaluꞌen, “Kagina suminalig amu dinaan, mekengitaꞌ namu!” ");
INSERT INTO syb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mikengitaꞌ dayun tuꞌu sug buta. Laak inungub pailan gupia ni Isus, laungen, “Pia sala tawan, ndaꞌiduni ukitan niu di mipenggulaula kini!” ");
INSERT INTO syb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Dagid mipanawig duaꞌ tawan kia, lineep nilan sug benwa kia, pinemalan nilan ukitay ki pinggulaula kia ni Isus dinilan. ");
INSERT INTO syb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Naa mendadi su kepalus nu nga kamun buta, duun pagidi nga getaw mituaꞌ dini Isus, migated ilan beed, sabaꞌ silunuꞌan menulay. ");
INSERT INTO syb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Lemen laak miutidan ni Isus ki menulay kia, mikektaluꞌ dayun puliꞌ sug beed. Misebuꞌan dayun su nga melaun getaw dia, laung nilan, “Ita nga getaw Israel, ugat pa ta maitaꞌ ki mipenggulaula maꞌnini palas.” ");
INSERT INTO syb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Dagid su nga Pariseo, laung nilan, “Aa, ki getaw kiin, iini megaganen dun utidayi menenulay, puꞌ bigayan ginuung nu kaunutan nu menenulay.” ");
INSERT INTO syb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Mendadi mipanaw si Isus, lineepen su ngag lunsud mukaꞌ gimbelayan diag lumibut benwa. Mikpetuꞌun si Isus dia nga simbaan nu getaw Judea mukaꞌ migukit di Gempia Petenday puꞌ pikpuunan na su Keglekaunutan nu Megbebayaꞌ. Pineguliꞌanen pa pagid su nga migladu, pia alandunig leduunen atawaka kulang dig lawasen. ");
INSERT INTO syb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kaliꞌen pegbentayay su melaun gupia getaw, milelaat dinilan si Isus. Puꞌ meligeti kelegenay nilan, mukaꞌ ndaꞌiduni gengagan nilan dun, dialem ginaanen, maaꞌ ilan karniru ndaꞌiduni megingat dun. ");
INSERT INTO syb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Miktaluꞌ si Isus di nga sakupen, “Naa ki sengkuꞌ, gembagel gupia sia, laak meliang dai getaw meglegani dun. ");
INSERT INTO syb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kaas penenabi amu tu Megbebayaꞌ, su gapuꞌ nu sengkuꞌ, adun suguꞌenen pai ngag duma getaw meglegani.” ");
INSERT INTO syb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Naa ki sepuluꞌ buꞌ duaꞌ peneligan ni Isus, sinabinen ilan. Mendadi benaꞌ misabi ilan, bigayanen ilan pegbayaꞌ mengutid di menenulay mukaꞌ meneguliꞌ tu nga kelaun leduun mukaꞌ kulang dig lawas nu getaw. ");
INSERT INTO syb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Naa kinii nga ngalan nu nga sepuluꞌ buꞌ duaꞌ peneligan ni Isus. Sug beknanen, si Simon (sala ngalanen si Pedro), mukaꞌ su pateden si Andres, dayun si Santiago mukaꞌ su pateden si Juan, gamaꞌ nilan duaꞌ si Sebedeo, ");
INSERT INTO syb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","dayun si Felipe mukaꞌ si Bartolome, dayun si Tomas mukaꞌ si Mateo, getaw mendawat buis, dayun si Santiago gamaꞌen si Alfeo, mukaꞌ si Tadeo, ");
INSERT INTO syb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","dayun si Simon, sakup nu nga mingatu di gubirnu. Mendadi su kesepuluꞌ buꞌ duaꞌen, iin si Judas Iscariote, su tumipu pa dini Isus. ");
INSERT INTO syb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Maꞌantu, ki sepuluꞌ buꞌ duaꞌ peneligan ni Isus kia, sinuguꞌen ilan mpanaw. Dekag ilan pasiꞌ mipanaw, miktituluꞌ dinilan si Isus, laungen, “Ndiꞌ amu angay dig benwa nu kanaꞌ getaw Judea, sampay dig lunsud nu getaw Samaria. ");
INSERT INTO syb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Segaga angay amu tu sama ta getaw Israel, ki pitanggiꞌu di nga karniru mibeleng. ");
INSERT INTO syb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mendadi panaw amu, pengukit amu, iini taluꞌ niu, ‘Ki Keglekaunutan nu Megbebayaꞌ, pikpuunan na!’ ");
INSERT INTO syb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Su pegladu, peneguliꞌay niu. Su minatay, petubuꞌ niu puliꞌ. Su megladu mekesalebuꞌ nuka, peneguliꞌay niu dadema. Su peglegetan menulay, utiday niu ditu nilan su menenulay. Kagina bigayan amu di ndaꞌig bayad niu dun, begayay dadema niu su nga samataw niu, di ndiꞌ da niu dema pebiaden. ");
INSERT INTO syb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ndiꞌ amu peguit kwarta bulawan atawaka pelata, pia sinsilyu tumbaga. ");
INSERT INTO syb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Saꞌ mpanaw amu, ndaꞌiduni sengkapan uiten niu, pia gambag, gilisan suub, sepatus, sampay sekud. Puꞌ ki getaw megabang di ngag dumanen, mbantang gestuan di kaꞌaanen.” ");
INSERT INTO syb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Laung pagid ni Isus, “Naa saꞌ mateng amu dig lunsud atawaka gimbelayan, bundas amu, penengaw amu getaw meliag tulugan niuig balayen. Ditu laak amu tuun, sampay mekebundas amu dig lain lunsud. ");
INSERT INTO syb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Laak saꞌ metulan amu dia, iini taluꞌ niu di nga getaw dia, ‘Pepianan amu.’ ");
INSERT INTO syb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Dayun saꞌ penembaꞌen amu nu getaw diag balay kia, naa mpianan ilan dema. Laak dagid saꞌ ndiꞌ ilan menembaꞌ diniu, ndiꞌ dailan dema mpianan. ");
INSERT INTO syb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mukaꞌ adin sug balay atawaka lunsud ndiꞌ menembaꞌ diniu dakus ndiꞌ mekineeg diniu, pegawaꞌ amu dayun dia, mukaꞌ ekpug niu sug lepup lupaꞌ di geksud niu. ");
INSERT INTO syb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Taman taluꞌu diniu, saꞌ mateng ki Gendaw nu Kengukum nu Megbebayaꞌ di tibaꞌan getaw, tumuꞌ megaan pai ginukuman tug lunsud Sodoma mukaꞌ Gomora dengantu, sabayaꞌ di ginukuman tug lunsud kia ndiꞌ menembaꞌ diniu!” ");
INSERT INTO syb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Kaliꞌ pektaluꞌ si Isus, “Pektalentenay niu ini! Ki kesuguꞌu diniu mpanaw, petanggiꞌu amu di karniru mingingelet di nga mendapaꞌ dun. Subay megaliꞌ amu, mesama tug betad mamak. Mukaꞌ su pegbetaden niu, mayaꞌmayaꞌ, sama da nug betad limuun. ");
INSERT INTO syb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kaas peglengilam amu, puꞌ dengaten amu di gedapan nu kuis dakus pembedasen amu nu getaw Judea tug dialem nga simbaan nilan, ");
INSERT INTO syb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","dakus dengaten amu di gedapan nga gadiꞌ mukaꞌ duma kaunutan, sabaꞌ nu kesakup niu dinaan. Mendadi mpenggulaula kia, adun su sembag niu dun, iini mbaal sikaw niu megukit di Gempia Petenday tu nga kaunutan kia, sampay tu nga kanaꞌ getaw Judea. ");
INSERT INTO syb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kaas saꞌ dengaten namu, ndiꞌ amu melibuleng dun, saꞌ taꞌ alandun mai gempia niu sembag dun. Segaga saꞌ penenaakan namu, petaluꞌ na diniu su gempia sembag niu dun. ");
INSERT INTO syb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Puꞌ ki sembag niu, kanaꞌ laak daniu taluꞌ, puꞌ pedelendem da diniu nug Balakat nu Gamaꞌ niu ditu gekbus langit.” ");
INSERT INTO syb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Laung ni Isus, “Duuni getaw megwakil di nga pated nilan petain, mukaꞌ maꞌniin dademai penggulaulaan nu nga getaw dig bataꞌen. Sampay su nga gembataꞌ, kuntraanen dadema su ginaꞌen mukaꞌ gamaꞌen, sampay meksimawiꞌ dinilan ki petain. ");
INSERT INTO syb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mukaꞌ bentaan amu nu kelaun getaw sabaꞌ nu kesakup niu dinaan. Dagid adin su getaw mektigel sampay mengikteb, iini megawen. ");
INSERT INTO syb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Naa saꞌ peglegetan amu di salabuuk lunsud, laguy amu dig lain. Naa taman taluꞌu diniu, ndiꞌ niu tagad meleep su kelaun lunsud dig benwa Israel, naan kini, kig Bataꞌ nu Kilawan, lumusadu puliꞌ dinig lumbang. ");
INSERT INTO syb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Puꞌ su getaw mektuꞌun,” maaꞌ laung dema ni Isus, “kanaꞌ metaas pa di mekpetuꞌun diniin. Su sesuguꞌen, kanaꞌ metaas pa di suminuguꞌ dun. ");
INSERT INTO syb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kaas su getaw mektuꞌun, saꞌ iini mbiananen ki mibianan dadema nu mekpetuꞌun diniin, subay senguꞌenen. Su gulipen dema, saꞌ iini mbiananen ki mibianan dadema nu mingulipen dun, naa senguꞌenen dadema. Puꞌ ki gamaꞌ, saꞌitada naan, saꞌ iini piningalan nu getaw dinaan Beelsebul, naa labi pamu nga gembataꞌ, maꞌantu dademai paingalan nilan diniu!” ");
INSERT INTO syb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Laung ni Isus, “Mendadi kagina maꞌantu, ndiꞌ niu endekay su kilawan. Puꞌ ndaꞌiduni mitebunan nemun, ndiꞌ mbuasan. Ndaꞌiduni giglud nemun, ndiꞌ dema mesuunan. ");
INSERT INTO syb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kaas adin su teluꞌen ku diniu di meleglud, pegukit niu tu gedapan. Adin su kimedu diniu, ukit niu tu tebuꞌan! ");
INSERT INTO syb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kaas ndiꞌ niu daan endekayi sama kilawan niu, puꞌ daal da laaki megaganen petayay, sug lawas nu getaw. Laak su gimuud nu getaw, ndiꞌen megaga petayay. Segaga iin laaki gempia gendekan niu su Megbebayaꞌ, kig duuni pegbayaꞌen mekpatay di getaw, mukaꞌ pa padun megbeleng dun ditug linaw gapuy. ");
INSERT INTO syb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Puꞌ pegdelendem niu deliꞌ su manukmanuk. Duaꞌ buuk leksayaw, ndiꞌ ba mesaluy selaad siin? Laak pia maꞌantu, ndaꞌi salabuuk dun matay, saꞌ kanaꞌ buangen nu Gamaꞌ niu. ");
INSERT INTO syb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Yamu pelum, pia kig buuk di gulu niu, misuunan da nu Megbebayaꞌ saꞌ santaꞌ balu. ");
INSERT INTO syb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kaas ndiꞌ amu mendek daan, puꞌ gembagel gupiaig lagaꞌ niu tu Megbebayaꞌ, sabayaꞌ nu nga manukmanuk! ");
INSERT INTO syb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Mendadi, adini getaw kanaꞌ mpiid meglegintuud di gedapan nu nga getaw puꞌ suminakup dinaan, naa naan, engkenen ku dadema iin ditu gedapan nu Gamaꞌu tu gekbus langit. ");
INSERT INTO syb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Dagid adin demai memalaw di gedapan nu getaw puꞌ kanaꞌ sakupu iin, naa pemelaun ku dadema iin ditu gedapan nu Gamaꞌu tu gekbus langit.” ");
INSERT INTO syb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Laung ni Isus, “Mendadi, ndiꞌ niu delendemay puꞌ iini luminusadu dun, pesalabuuken kui getaw dinig dibabaw lumbang. Kanaꞌ maꞌantu! Puꞌ meksual ilan pasiꞌ, naani puunen! ");
INSERT INTO syb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Meksumpakiꞌig delendeman nug laki mukaꞌ nu gamaꞌen, maꞌnia dademaig libun mukaꞌ su ginaꞌen. Meksumpakiꞌ dademai minugangan libun mukaꞌ su penuganganen libun. ");
INSERT INTO syb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Deksuꞌanen, saladuaꞌ iini tampusan kuntranen, su na laak betaꞌanen gupia. ");
INSERT INTO syb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Mendadi adini getaw, saꞌ su kekpetailen tu ginaꞌen buꞌ gamaꞌen, gembagel pa di kekpetailen dinaan, naa ki getaw kia, kanaꞌ mbantang sumakup dinaan. Mesama da su getaw, saꞌ su kekpetailen dig bataꞌen libun laki, gembagel pa di kekpetailen dinaan, iin, kanaꞌ dadema mbantang sumakup dinaan. ");
INSERT INTO syb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Puꞌ adini ndiꞌ mekpisan kurusen dakus dumunut dinaan, naa kiin, kanaꞌ mbantang sumakup dinaan. ");
INSERT INTO syb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Naa adini mpauk megwakil gumulen dinaan, mbeleng diniin su ketubuꞌ ndaꞌi tamanen. Adin su pegwakilen dinaan su gumulen sabaꞌ nu kesakupen dinaan, iin, malapen sungkin su ketubuꞌ ndaꞌi tamanen.” ");
INSERT INTO syb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Laung ni Isus, “Mendadi adini menembaꞌ diniu, naa gitunganen, naani mipenembaꞌen. Mukaꞌ kagina pinembaꞌu niin, mipenembaꞌen dadema su suminuguꞌ dinaan. ");
INSERT INTO syb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mukaꞌ adin su menembaꞌ di getaw megwali taluꞌ nu Megbebayaꞌ, sabaꞌ misuunanen puꞌ megwalii getaw kia, sugdaan da nu Megbebayaꞌ su menembaꞌ dun, lepeng tu sugda ditu megwali kia. Maꞌantu dadema su menembaꞌ di mekesuun getaw, sabaꞌ misuunanen puꞌ mekesuuni getaw kia, iin, sugdaan dadema nu Megbebayaꞌ su menembaꞌ dun, lepeng tu sugda ditu mekesuun getaw kia. ");
INSERT INTO syb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kaas taman taluꞌu diniu, pinenggiꞌ duuni getaw megbegay sala tasa tubig di tampusan gembabaꞌ sakupu, sabaꞌ misuunanen puꞌ sakupui getaw kia, naa sugdaan tuꞌu nu Megbebayaꞌ su getaw mekpainum dun.” ");
INSERT INTO syb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Naa benaꞌ mitubus ni Isus tituluꞌay su sepuluꞌ buꞌ duaꞌ tawan sakupen, mipanaw, minangay megukit mukaꞌ mektituluꞌ dia ngag lumibut lunsud. ");
INSERT INTO syb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Naa si Juan kiin, su Memunag Tubig, benaꞌ pitendayan ditu pirisuan mekatag di nga pinggulaula ni Kristu, duun dayuni nga sakup ni Juan sinuguꞌen meditu ni Kristu. ");
INSERT INTO syb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Mendadi, benaꞌ midepet dia ni Isus su nga sinuguꞌ, sinaak nilan diniin, “Sir, saꞌ mesuꞌat, taluꞌ mu dinami, yaꞌa na tuꞌu ki pisuun pedaan ni Juan puꞌ lumusad, atawaka megelat pami dig lain?” ");
INSERT INTO syb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Mendadi, sumimbag si Isus, laungen, “Naa, puliꞌ amu ditu ni Juan, ukit niu diniin ki taman minitaꞌ niu kini mukaꞌ ki midengeg niu. ");
INSERT INTO syb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Su ngag buta, mikengitaꞌ na. Su nga pilung, mikepanaw na. Su nga migladu mekesalebuꞌ nuka, miuliꞌan na. Su ngag bengel dema, mikedengeg na. Sampay su nga minatay, pitubuꞌ na puliꞌ. Mukaꞌ su gempusuk getaw, inukitan na tu Gempia Petenday. ");
INSERT INTO syb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kaas adini getaw ndiꞌ memilas dinaan, iini liliag!” ");
INSERT INTO syb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Mendadi saꞌ mipalus su nga pimuunan ni Juan, migukit si Isus tu melaun getaw mekatag dini Juan. Sinaak ni Isus dinilan, “Naa kini si Juan, saꞌ linaawan niu iin ditug limawaꞌ, alandun mai pedetengen niu diniin? Laung ba niu dun si Juan, maaꞌ nu sala puun tigbaw, melemu mpilay nu genus? Kanaꞌen. ");
INSERT INTO syb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Naa saꞌ maꞌantu, alandun mai pedetengen niu diniin? Laung niu dun puꞌ getaw migimakay? Baa, kanaꞌen dadema, puꞌ su getaw migimakay, subay ditu laak penengaway balay nu nga gadiꞌ! ");
INSERT INTO syb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mendadi saꞌ maꞌantu, taꞌi pedetengen niu maitaꞌ niu? Getaw pimuunan nu Megbebayaꞌ? Waꞌa lai! Mukaꞌ taman taluꞌu diniu, kini si Juan, kanaꞌ laak pimuunan nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Puꞌ iinen dadema su mibetang ditu Misulat Taluꞌ nu Megbebayaꞌ, laung, ‘Miktaluꞌ su Megbebayaꞌ, Mendadi paunaan ku diniꞌa ki pemuunan ku, puꞌ adun pengendamenen sug bianan mu.’ ");
INSERT INTO syb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Naa taman taluꞌu diniu,” laung ni Isus, “genat pa dini Adan sampay nemun, ndaꞌi sala tawan metaas pa dini Juan. Laak dagid pia maꞌantu, adin su tampusan gembabaꞌ sakup di Keglekaunutan nu Megbebayaꞌ, iini metaas padun dini Juan. ");
INSERT INTO syb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Puꞌ genat tu ketuaꞌ ni Juan sampay nemun, ki Keglekaunutan nu Megbebayaꞌ, mamaꞌ peglumpakan nu melaun gupia getaw, puꞌ mektinantu sumakup dun su getaw. ");
INSERT INTO syb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Naa su Keglekaunutanen, sinulat pedaan nu kelaun pimuunan nu Megbebayaꞌ ditu Misulat Taluꞌen, dakus sinulat dadema ditu Palinta ni Moises, su ndaꞌ pa metuaꞌ si Juan. ");
INSERT INTO syb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Dayun si Juan, saꞌ petuuden niu saꞌ ndiꞌ, iini misugat ditu misulat pedaan puꞌ duuni pemuunan, ngalanen si Elias, metuaꞌ dinig lumbang. ");
INSERT INTO syb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mendadi, adin sug duuni telinganen, mekineeg dema tuꞌu!” ");
INSERT INTO syb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Sinumpatan gusay ni Isus su taluꞌen, laungen, “Mendadi ki getaw nemun, alandun mai penenggiꞌan ku dun? Petanggiꞌu di gembataꞌ pemeglingkulu pegayep dia padiꞌan. Beksayan nilan su nga samambataꞌ nilan, laung nilan, ");
INSERT INTO syb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Mauma saꞌ minlantuyan ami diniu, ndaꞌ amu peksabay? Dayun saꞌ miksulang ami, mauma ndaꞌ amu pelum pengaduy?’ ");
INSERT INTO syb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Puꞌ mituaꞌ si Juan,” laung ni Isus, “iinig betaden mekpuasa mukaꞌ ndiꞌ minum mekebulek. Laung dayun nu nga getaw, ‘Pingepuꞌan menulay!’ ");
INSERT INTO syb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tubus itu naan kini, kig Bataꞌ nu Kilawan, mituaꞌu pelum, betadu maan dau mukaꞌ minum dau dema. Laung pelum nu getaw, ‘Paa, bentayay pa daan niu, medalu masiꞌ maan mukaꞌ penenatan meginum, sambaten pa paduni nga mendawat buis mukaꞌ ngag duma mekesesalaꞌ getaw!’ Laak dagid ki tantu sinuunan genat tu Megbebayaꞌ, mailala dia penggulaulaan nu megdunut dun.” ");
INSERT INTO syb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Naa su getaw sakup di ngag lunsud dia tandaꞌ melaun mekesalebuꞌ pinggulaula ni Isus, ndaꞌ ilan gusay peksikesuun. Mendadi, pimaag ilan ni Isus, laungen, ");
INSERT INTO syb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Paa, yamu pa di nga getaw Corasin mukaꞌ getaw Betsaida, mekelelaatlelaat amu! Puꞌ su nga mekesalebuꞌ pinggulaulau dig lunsud niu, saꞌ pinenggiꞌ ditu mipenggulaula Tiro mukaꞌ Sidon dengantu, aba, su nga getaw ditu, migdedaliꞌ ilan sia memekseluk saku dakus meglebug gabu dig lawas nilan, tuꞌus tu kegbiksuꞌ nilan sia tu salaꞌ nilan! ");
INSERT INTO syb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kaas taman taluꞌu diniu, saꞌ mateng ki Gendaw nu Kengukum nu Megbebayaꞌ di tibaꞌan getaw, tumuꞌ megaan pa su ginukuman di nga getaw Tiro mukaꞌ Sidon kitu, sabayaꞌ di ginukuman diniu! ");
INSERT INTO syb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mukaꞌ yamu dadema di nga getaw Capernaum! Petaasen ma niu siai tindeg niu, sampay medepet amu ditu gekbus langit? Baa, lebuꞌen amu tug linaw gapuy! Puꞌ su mekesalebuꞌ pinggulaulau dig lunsud niu, saꞌ pinenggiꞌ mibaal ditu Sodoma dengantu, naa ditu pa sia sug lunsud kia sampay da dun nemun, ndaꞌ sia ukumay!” ");
INSERT INTO syb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Diksuꞌ ni Isus su taluꞌen, “Taman taluꞌu diniu, saꞌ mateng su Gendaw nu Kengukum nu Megbebayaꞌ di tibaꞌan getaw, tumuꞌ megaan pai ginukuman tug lunsud Sodoma kitu, sabayaꞌ di ginukuman diniu!” ");
INSERT INTO syb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Naa mitaang dun, minenabi si Isus, laungen, “Mikpaladpaladu diniꞌa, Amaꞌ, yaꞌai Kaunutan di gekleb langit buꞌ lupaꞌ! Puꞌ su tantu sinuunan kini, iglud mu tu nga getaw metaasi sinuunanen, puꞌ iin laaki pisuunan mu dun, ki nga getaw kini maikaꞌi sebutenen. ");
INSERT INTO syb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Naa melengas da, Amaꞌ, puꞌ maꞌnia dai miuyaꞌan mu.” ");
INSERT INTO syb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Laung padun ni Isus, “Sug lumaun metuud, migelaꞌ pegwakil dinaan nu Gamaꞌu. Naa naan kini, kig Bataꞌen, ndaꞌiduni suminambat dinaan, subay su Gamaꞌu laak. Mukaꞌ su Gamaꞌu, ndaꞌidun dademai suminambat diniin, subay naan laak kini nug Bataꞌen, sampay adin laaki getaw mauyaꞌan ku pesambatu dun.” ");
INSERT INTO syb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Laung ni Isus, “Mendadi, pedini namu naan, adin diniuig bilayan sabaꞌ megbaba gembegat, puꞌ naan, peleliin ku amu. ");
INSERT INTO syb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Iini baba niu, ki pebabau diniu, mukaꞌ pektuꞌun amu dinaan. Puꞌ sug betadu, mesumayaꞌ, mukaꞌ mekpebabaꞌu dig lawasu. Kaas saꞌ medini amu naan, mekengulali amu tuꞌu. ");
INSERT INTO syb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Puꞌ ki pepisan ku diniu, melemu maban. Ki pebabau diniu dema, megaan.” ");
INSERT INTO syb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Naa benaꞌ ndaꞌ maiben, duuni Gendaw Pelali, minayan si nga Isus di pegimulanan trigo. Naa megutem dema su nga sakupen, mikpuun ilan mengetes tu trigo, dayun nilan pekaanay. ");
INSERT INTO syb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mendadi ki nga Pariseo, benaꞌ minitaꞌ nilan su kengetes nu nga sakup ni Isus tu trigo, laung nilan diniin, “Paa, bentayay mu pa daan kig baalen ni nga sakup mu kiin! Ki Gendaw Pelali, binandu dinita ditu Misulat Palinta nu Megbebayaꞌ duunig baalen ta di gendaw kini!” ");
INSERT INTO syb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kaliꞌ sembag si Isus dinilan, “Baa, pia da. Puꞌ si David kanugdiin, ndaꞌ ba niu mbasa ki pinggulaulanen dadema saꞌ migutem, ilan nu ngag dumanen? ");
INSERT INTO syb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Puꞌ sumiled si David ditug Balay Pengedapan tu Megbebayaꞌ, inaanen su pan ginilak ditu Megbebayaꞌ, ilan nu ngag dumanen. Asa binandu dinilan ki pan kia, puꞌ misulat ditu Palinta nu Megbebayaꞌ, ndaꞌiduni maan dun, subay su laak ngag belian. ");
INSERT INTO syb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Keduaꞌen, ndaꞌ ba niu dadema mbasa ki sala sinulat ditu Palinta nu Megbebayaꞌ, puꞌ su ngag belian dengantu, kada Gendaw Pelali, duun daig baalen nilan ditu seled nug Balay Pengedapan tu Megbebayaꞌ? Maꞌantu, lepeng pimilas nilan su Misulat Palinta mekatag di Gendaw Pelali, laak pia maꞌantu, ndaꞌ dailan dema mekesalaꞌ di pegitaꞌen nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Naa taman taluꞌu diniu, duun nai mituaꞌ dini, metaas pa dig Balay Pengedapan tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mukaꞌ duuni sinulat ditu Taluꞌ nu Megbebayaꞌ, laung, ‘Iini mauyaꞌan ku, lelaatan niu su samataw niu, sabayaꞌ su ngag betang ilaken niu dinaan.’ Kaas saꞌ sia mesabut niu gupia ki misulat kia, ndiꞌ niu sia pegdenaꞌay nga sakupu kini, ndaꞌ ilan mekesalaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Puꞌ naan kini, kig Bataꞌ nu Kilawan, naani Kaunutan megbayaꞌ dig baalen nu kilawan metaang di Gendaw Pelali.” ");
INSERT INTO syb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Benaꞌ minundas si Isus, minangay di simbaan nu getaw Judea. ");
INSERT INTO syb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Naa mitaang duuni getaw dia, mingupesi sedibaluy kemeten. Mendadi ki ngag duma getaw dia, mauyaꞌan nilan, duun siai gempia dangat nilan dini Isus. Kaliꞌ ilan saak diniin, “Naa saꞌ metaang di Gendaw Pelali, biwang ba dinita ditu Misulat Palinta nu Megbebayaꞌ, meneguliꞌ ita?” ");
INSERT INTO syb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Sinaak dayun ni Isus, “Naa saꞌ pinenggiꞌ duuni sala tawan diniu duuni karnirunen, dayun melabuꞌ di medalem luak su karnirunen, metaang di Gendaw Pelali, ndiꞌen ba selebeten dayun, adun guunenen? ");
INSERT INTO syb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Naa su getaw, metaas pa tananig lagaꞌen, sabayaꞌ nu karniru! Kagina maꞌantu, biwang ditu Misulat Palinta nu Megbebayaꞌ, pepianan tai samataw ta metaang di Gendaw Pelali.” ");
INSERT INTO syb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Laung dayun ni Isus di mingupesi kemeten kia, “Naa, tenggal mui kemet mu.” Tinggalen dayun, mukaꞌ miuliꞌan, ndaꞌ nai pegisuanen tug dibaluy kemeten. ");
INSERT INTO syb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Naa ki nga Pariseo kini, benaꞌ minitaꞌ nilan, mingguaꞌ ilan dayun dia. Migyagayaga ilan dayun, minengaw ilan bian nilan mekpatay dini Isus. ");
INSERT INTO syb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Mendadi kaliꞌ mesuunay ni Isus sug delendeman kia nu nga Pariseo, migawaꞌ dia. Melaun gupia getaw miglendug diniin. Dayun su kelaun mimegladu, pineguliꞌanen, ");
INSERT INTO syb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","laak pimeeken ilan, adun ndiꞌ nilan pesuun di ngag lain getaw ki pinggulaulanen. ");
INSERT INTO syb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Iini pigbuninen dun, puꞌ adun menuud su pisulat dengantu nu Megbebayaꞌ ditu Taluꞌen, ki sinulat nu pimuunanen si Isaias, laungen, ");
INSERT INTO syb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Kini su pimiliꞌu sesuguꞌen ku, ki petailen ku, leliagenu dun gupia. Pepengapuꞌu diniin sug Balakatu, kaas ki melegdeng betad puun dinaan, iini mekpetenday dun tu kelaun bansa. ");
INSERT INTO syb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Sug betaden, kanaꞌ meksual. Ndiꞌ megbeksay, ndiꞌ dadema menekeg mekpelaktag dia tebuꞌan. ");
INSERT INTO syb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Saꞌ su getaw pitanggiꞌu di tigbaw mibuyuk, ndiꞌen bekluꞌen. Mesama di getaw maaꞌ nu suluꞌ laak meglekaꞌlekaꞌ na, ndiꞌen dadema pelengen. Penemalanen su metuud, sampay daagen nu metuud sug limbung, ");
INSERT INTO syb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","sampay su kelaun bansa nu getaw, sumalig na diniin.” ");
INSERT INTO syb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mendadi, duuni sala tawan iwit ditu ni Isus, buta mukaꞌ beed pa pagid, sabaꞌ silunuꞌan menulay. Piuliꞌan dayun ni Isusi getaw kia, mikektaluꞌ puliꞌ mukaꞌ mikengitaꞌ na. ");
INSERT INTO syb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Misebuꞌan dayun su melaun getaw dia, sinaak nilan, “Kalukalu iinen na su pedetengen ta Sapuꞌ ni David?” ");
INSERT INTO syb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Laak ki nga Pariseo, saꞌ midengeg nilan, kaliꞌ ilan pektaluꞌ, “Aa, ki getaw kiin, iini megaganen dun utidayi menenulay, puꞌ bigayan ginuung ni Beelsebul, su kaunutan nilan.” ");
INSERT INTO syb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Laak misuunan ni Isus sug delendeman nilan. Kaliꞌ pektaluꞌ dinilan, “Adin su nasud meksimawiꞌ mukaꞌ megunay megbunuꞌ, ndiꞌ maiben metulag. Samanen ki salabuuk lunsud, atawaka salapenan. Saꞌ meksimawiꞌ mukaꞌ meksual, metulag dadema. ");
INSERT INTO syb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Naa, maꞌantu dadema si Satanas. Saꞌ pinenggiꞌ utidani menenulay di pegbayaꞌ da gusay ni Satanas, naa maꞌantu, ndiꞌ ba meksimawiꞌi peglegediꞌanen? Dayun deksuꞌanen, ndiꞌ ba metulag? ");
INSERT INTO syb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Asa teluꞌen niu, pengutidan ku su menenulay puun tu pegbayaꞌ ni Beelsebul. Keduaꞌen, saꞌ sia metuud puꞌ genat dini Beelsebuli pegbayaꞌu mengutid dun, naa su nga sakup niu pelum, adin ba genat su pegbayaꞌ nilan? Puꞌ ilan, utidan da nilan demai menenulay. Baa, mitakesil amu nu pinggulaula nu nga sakup niu! ");
INSERT INTO syb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Laak dagid saꞌ iin pasiꞌi migbegay dinaan pegbayaꞌ mengutid dun, sug Balakat nu Megbebayaꞌ, naa maꞌananen, mituaꞌ na tuꞌu diniu ki Keglekaunutan nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Mendadi laung ni Isus, “Ki getaw suled tug balay letaban getaw puꞌ adun elapenen su pimetangen, mekendutaꞌ mai kegalapen tu pimetangen, subay unaanen pa beluday kig letaban kia? Dayun saꞌ megaganen beluday kig letaban kia, naa megaganen tuꞌu elapay ki pimetangen kia.” ");
INSERT INTO syb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Diksuꞌ ni Isus su taluꞌen, “Adini getaw kanaꞌu sugut, iini kuntrau. Adini ndiꞌ megabang dinaan mekpungun sakupu, iini mekpelak dun. ");
INSERT INTO syb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kagina maꞌantu, taman taluꞌu diniu, su kelaun salaꞌ nu kilawan sampay su kelaun keksudiꞌen, pedesunen da. Dagid adin su getaw peksudiꞌanen sug Balakat nu Megbebayaꞌ, kiin, ndiꞌ na pedesunen. ");
INSERT INTO syb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Adin pagidi getaw meksudiꞌ dinaan kig Bataꞌ nu Kilawan, pedesunen da dun. Dagid adin su getaw peksudiꞌanen sug Balakat nu Megbebayaꞌ, ndiꞌ na pedesunen nemun, sampay di gendaw kiin ditug binayaꞌ gebii buꞌ gendaw.” ");
INSERT INTO syb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Kaliꞌ pektaluꞌ si Isus, “Naa su melengas bunga gayu, subay ditu penengaway melengas dadema gayu. Su pelum melaat gayu, melaat dademaig bunganen. Kaas saꞌ peksimaꞌen su gayu, iini kimanan, kig bunganen. ");
INSERT INTO syb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Paa, yamu pa di nga mamak! Mauma teluꞌen niu su gempia, asa melaat amu getaw? Puꞌ ki taluꞌ nu getaw, iini megbuas dig delendemanen. ");
INSERT INTO syb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kaas saꞌ mekesuun getawi mektaluꞌ, naa gempiai metaluꞌen. Su pelum medupang getaw, melaat dademai metaluꞌen. ");
INSERT INTO syb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Taman taluꞌu diniu, saꞌ mateng su Gendaw nu Kengukum nu Megbebayaꞌ di tibaꞌan getaw, ukumen su getaw mekatag di taman mitaluꞌen, kampuꞌ nu milaksapen laak metaluꞌ. ");
INSERT INTO syb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kaas saladuaꞌ diniu, saꞌ ukumen ka na nu Megbebayaꞌ, iini peksimaꞌen, ki mitaluꞌ mu, adun gempantek saꞌ mbantanga ukuman saꞌ kanaꞌ.” ");
INSERT INTO syb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Naa mendadi, duuni nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ mukaꞌ nga Pariseo, laung nilan dini Isus, “Sir, saꞌ mesuꞌat, penggulaula mu dawi mekesalebuꞌ tuꞌus di pegbayaꞌ mu, puꞌ bentayan nami.” ");
INSERT INTO syb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Dagid kaliꞌ sembag si Isus, “Paa, yamu pa di nga getaw nemun, medupang amu gupia, memilas amu pelum tu Megbebayaꞌ! Penengiin niu dinaani mekesalebuꞌ tuꞌus, asa daal da laaki tuꞌus begay diniu, ki maaꞌ nu pinggulaula nu pimuunan nu Megbebayaꞌ dengantu si Jonas. ");
INSERT INTO syb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Puꞌ si Jonas, telu gebii diag dagat, tug dialem tian nu gembagel sedaꞌ. Naa naan kini, kig Bataꞌ nu Kilawan, maꞌantu dadema, subay telu gebiiu dig dialem lupaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Kaas saꞌ mateng su Gendaw nu Kengukum nu Megbebayaꞌ di tibaꞌan getaw, naa su nga getaw dengantu sakup Ninibe, mbantang ilan megindeg tumakesil diniu nga getaw nemun. Puꞌ saꞌ tinituluꞌan ilan ni Jonas, miksikesuun ilan. Naa yamu kiin, duun kinii mituaꞌ diniu, metaas pa dini Jonas! ");
INSERT INTO syb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mukaꞌ saꞌ mateng na tuꞌu su Kengukum di tibaꞌan getaw, naa sug Bai pa pagid tug benwa Seba dengantu, mbantang dadema megindeg tumakesil diniu! Puꞌ daniin, miktegel mpanaw dinig benwa ta Israel, melayuꞌ gupia dig benwanen, puꞌ adun mekineeg ditu telisebuten tituluꞌan ni Adiꞌ Salomon. Mendadi yamu, taman taluꞌu diniu, duun kinii mituaꞌ diniu, metaas pa dini Salomon! ");
INSERT INTO syb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Mendadi su menulay,” laung ni Isus, “saꞌ utidan di getaw, leepenen dayunig benwa ndaꞌi tubig dun menengaw pelelianen. Naa benaꞌ ndaꞌiduni mbaanganen, ");
INSERT INTO syb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","maaꞌ laungen dig dialem ginaanen, ‘Tumuꞌ muliꞌ nau tug balay kia pigenatan ku.’ Naa benaꞌ mateng puliꞌ tug balay kia, aba, metaanganen ndaꞌ nai pegbenwa dun, siniligan na sug balay dakus pingikpesan. ");
INSERT INTO syb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Saꞌ maꞌantu, mangay dayun dumanen menenulay pitu buuk, melaat pa dun diniin, dayun megelaꞌ ilan muliꞌ dia. Kaas deksuꞌanen, su kebetang nu getaw kia piglegetan salabuuk da sia menulay, melaat pa tug bekna mipenggulaulanen. Naa ki mpenggulaulanen kia, maꞌantu dademai mbianan pa nu getaw nemun, melaat gupiaig betad nilan.” ");
INSERT INTO syb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Naa benaꞌ sinegay pa ni Isus mektituluꞌ tu nga getaw, minateng su ginaꞌen mukaꞌ su nga pateden. Pegindeg ilan diag liu, pisabi nilan dayun si Isus. ");
INSERT INTO syb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mendadi, pisuun dayun dini Isus, laung nu getaw, “Sir, su ginaꞌ mu mukaꞌ su nga pated mu, pegindeg ilan diag liu, peksebiin ka nilan.” ");
INSERT INTO syb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Sumimbag si Isus, “Naa, waꞌa. Laak taway dun mai ginaꞌu? Mukaꞌ taway dun mai patedu?” ");
INSERT INTO syb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Dayunen tenduꞌay su nga sakupen, laungen, “Kini paduni ginaꞌu mukaꞌ nga patedu! ");
INSERT INTO syb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Adini getaw megdunut tu mauyaꞌan nu Gamaꞌu ditu gekbus langit, iin pa pagidi patedu, libun saꞌ laki, sampay ginaꞌu.” ");
INSERT INTO syb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Naa benaꞌ di gendaw kia, migawaꞌ si Isus diag balay, minangay tu geksid linaw, migingkud dia geksid. ");
INSERT INTO syb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Laak sabaꞌ melaun gupia getaw mikpungun diniin, subay duminangan si Isus di sekayan, migingkud dayun mengadap tu melaun getaw kia pegindeg dia geksid linaw. ");
INSERT INTO syb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mendadi benaꞌ mikaingkud si Isus dia sekayan, melaun dayuni pigwalinen di nga getaw kia, pibian di sambingay. Kaliꞌ pektaluꞌ si Isus, “Duuni getaw minangay tug binaalanen adun megimula. ");
INSERT INTO syb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Laak benaꞌ saananen meksigwag, duunig beniꞌ mitenaꞌ ditug dalan, kaas pingektuk nu nga manukmanuk. ");
INSERT INTO syb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Naa duun dademai mitenaꞌ ditug betuan, menipisig lupaꞌ dun. Mintubuꞌ ganam sug beniꞌ, laak dagid kagina menipisig lupaꞌ dun, ");
INSERT INTO syb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","benaꞌ mipedesan, milawes. Mukaꞌ kagina gembabawi gangeten, minatay da pelum. ");
INSERT INTO syb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Naa duun pa pagidig beniꞌ mitenaꞌ dig dugian. Kaliꞌ pentubuꞌ su ngag dugi mukaꞌ tuminulin, milebeng dun su pimula. ");
INSERT INTO syb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Laak tumuꞌ kig duma beniꞌ, mitenaꞌ tuꞌu di pialupaꞌ, kaas mikegbunga. Benaꞌ sumingkuꞌ, duuni pingmegatus, duuni pigenem puluꞌ, duun pagidi piktelu puluꞌ.” ");
INSERT INTO syb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Diksuꞌ dayun ni Isus su taluꞌen, “Adin sug duuni telinganen, mekineeg dema tuꞌu!” ");
INSERT INTO syb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Naa mendadi, minadap ditu ni Isus su nga sakupen, sinaak nilan diniin, “Sir, saꞌ inukitan mu su melaun getaw, taꞌ mai miksambingaya dun dinilan?” ");
INSERT INTO syb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Kaliꞌ sembag si Isus, “Aa naa, yamu, buasan na diniu su gandang pigbuni mekatag di kesakup tu Keglekaunutan nu Megbebayaꞌ. Laak dagid tug lain getaw, ndaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Puꞌ adin su getaw duunig daniin, begayan pa padun, sampay melaunig daniin. Adin pasiꞌ su getaw ndaꞌidunig daniin, laak uiꞌen diniin su maikaꞌ sia daniin. ");
INSERT INTO syb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kaas pebian laak di sambingay su kegukitu dinilan, puꞌ ilan kiin, mengenleng dailan, laak ndiꞌ ilan mekengitaꞌ. Mekineeg dailan, laak ndiꞌ ilan mekedengeg mukaꞌ ndiꞌ ilan mekesabut. ");
INSERT INTO syb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Maꞌantu, misugat ilan nu sinulat pedaan ditu Misulat Taluꞌ nu Megbebayaꞌ nu pimuunanen si Isaias, laungen, ‘Ki getaw kini, menamal ilan mekineeg, laak ndiꞌ ilan mekesabut. Menamal ilan mengenleng, laak ndiꞌ ilan mekengitaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Puꞌ sug delendeman nilan, mimilas gupia. Su telinga nilan, sinseng nilan pelum. Dakus su mata nilan, pideng nilan pa pagid. Puꞌ tekaw mbuus mekengitaꞌ dailan mukaꞌ mekedengeg dailan, dakus mekesabut dailan, dayun lumingay ilan puliꞌ sia dinaan, laung nu Megbebayaꞌ, adun guunen ku ilan.’ ");
INSERT INTO syb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Dagid yamu,” laung ni Isus tu nga sakupen, “liliag amu tantu! Puꞌ mikengitaꞌ namu, mukaꞌ mikedengeg amu. ");
INSERT INTO syb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Taman taluꞌu diniu, melaun pimuunan nu Megbebayaꞌ mukaꞌ mekesuun getaw, taginaa nilan dun sia maitaꞌ nilan ki minitaꞌ niu kini, dagid ndaꞌ nilan maitaꞌ. Taginaa nilan dun pagid medengeg nilan ki midengeg niu kini, dagid ndaꞌ nilan dadema medengeg.” ");
INSERT INTO syb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Pidayun gusay ni Isus su taluꞌen, “Mendadi, kinii gulugan nu sambingay mekatag di kegimula. ");
INSERT INTO syb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Naa sug beniꞌ mitenaꞌ diag dalan, damikian dun su nga getaw mikedengeg tu Gempia Petenday mekatag di kesakup tu Keglekaunutan nu Megbebayaꞌ, laak ndiꞌ nilan mesabut. Saꞌ maꞌantu, mateng dayun su Palin, uaꞌenen pelum tug delendeman nilan su Gempia Petenday. ");
INSERT INTO syb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Naa su pelum beniꞌ mitenaꞌ diag betuan, iin su nga getaw lemen laak medengeg nilan su Gempia Petenday, telimaꞌen nilan dayun mukaꞌ penleliagen ilan dun. ");
INSERT INTO syb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Laak ndaꞌ pengganget dig delendeman nilan, kaas ndiꞌ maiben su kekpetuud nilan. Saꞌ matengi kelegenay nilan, saꞌitada saꞌ peglegetan ilan sabaꞌ nu kekpetuud nilan di Gempia Petenday, teliudan nilan dayun su kekpetuud nilan. ");
INSERT INTO syb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Naa sug beniꞌ mitenaꞌ dema dig dugian, iin su getaw mikedengeg tu Gempia Petenday, laak dagid megelaꞌi ginaa nilan tu kelibuleng nilan tu kegleketubuꞌ nilan nemun mukaꞌ su gayak nilan tu gaꞌus, kaas ndaꞌ na dig delendeman nilan su pitenday dinilan. Benaꞌ kig beniꞌ kia, ndiꞌ na megbunga. ");
INSERT INTO syb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mendadi kig beniꞌ mitenaꞌ dia pialupaꞌ, iin tumuꞌ su nga getaw mekedengeg tu Gempia Petenday dayun mekesabut ilan dun, kaas megbunga ilan. Benaꞌ sungkuꞌ, duuni pingmegatus, duuni pigenem puluꞌ, duun pagidi piktelu puluꞌ.” ");
INSERT INTO syb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Mendadi, duun pa pagidi sambingay ni Isus. Kaliꞌ pektaluꞌ, “Ki Keglekaunutan nu Megbebayaꞌ, maꞌniniꞌig bianen. Duuni getaw mimula melengas beniꞌ tug binaalanen. ");
INSERT INTO syb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Benaꞌ sala gebii, miktulug su getaw, duun pelumi kuntra nu gapuꞌ lupaꞌ kia minangay tug binaalanen kia, pimulananen pa puliꞌ, laak iin masiꞌi linamugen pemulanay di nga trigo, lumbus sigbet. Dayun minuliꞌ su kuntranen kia. ");
INSERT INTO syb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Naa mintubuꞌ su trigo, mukaꞌ migbedes na. Benaꞌ mimensut, baa, masiꞌ melaun sigbet milamug dun. ");
INSERT INTO syb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kaas su nga sesuguꞌen nu gapuꞌ lupaꞌ kia, minangay ilan dia niin, sinaak nilan diniin, ‘Sir, kig beniꞌ pimula mu diag binaalan mu, gempia da sia. Naa, adin ma genati nga sigbet kia?’ ");
INSERT INTO syb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Kaliꞌ sembag su gapuꞌ lupaꞌ, ‘Apelai! Masiꞌ duuni kuntrau mikesabaꞌ dun.’ Sinaak nu nga sesuguꞌenen, ‘Naa, mauyaꞌan mu mangay nami deliꞌ memakut dun?’ ");
INSERT INTO syb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Dagid kaliꞌ pektaluꞌ su gapuꞌ lupaꞌ, ‘Baa, ndiꞌ na. Puꞌ mbuus sabaꞌ niu memakut dun, duuni nga trigo mpeduma di sigbet mbakut. ");
INSERT INTO syb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kaas petulinen ta pa deliꞌ su trigo sampay su sigbet, sampay dig basa meglegani. Mendadi saꞌ basa na meglegani, teluꞌen ku tu nga meglegani dun, unaan nilan bekutay ki sigbet kia, pungunen, pengegbeden, dayun sensulay. Dekag pa geniay ki trigo, mukaꞌ iini teguꞌen tug luluu.’” ");
INSERT INTO syb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Naa duun pa pagidi sala sinambingay ni Isus. Kaliꞌ pektaluꞌ, “Mendadi ki Keglekaunutan nu Megbebayaꞌ, penenggiꞌan dun ki salabuuk lisu sangay nu mustasa su ngalanen, pimula nu getaw diag binaalanen. ");
INSERT INTO syb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Naa ki mustasa kini, iini tampusan maikaꞌ di kelaun lisu pimula. Laak saꞌ mentubuꞌ mukaꞌ tumulin, melebawanen su kelaun gininisan pimula, maꞌniin na bagel gayu. Kaas pegepunan nu nga manukmanuk sabaꞌ kebagelen, mukaꞌ megbaal ilan salag nilan dia piktebenan nu nga panganen.” ");
INSERT INTO syb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Naa duun pa pagidi sinambingay ni Isus. Kaliꞌ pektaluꞌ, “Mendadi ki Keglekaunutan nu Megbebayaꞌ, penenggiꞌan dun ki petulin di pan, lemugen nug libun di pitu gantang garina. Mendadi genat lemugay dun, mpakayaw tumulin su tibuuk baalen pan.” ");
INSERT INTO syb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Maꞌantu, su kelaun ginukit ni Isus tu nga melaun getaw, pibian di sambingay, ndaꞌiduni inukiten dinilan saꞌ kanaꞌ lumbus sambingay. ");
INSERT INTO syb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kia, adun menuud su sinulat dengantu nu pimuunan nu Megbebayaꞌ ditu Taluꞌen, laungen, “Saꞌ megukitu, meksambingayu. Ki pigbuni genat tu kebuat tu gekleb langit buꞌ lupaꞌ, ukiten ku.” ");
INSERT INTO syb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Naa migudas si Isus tu nga melaun getaw minangay mekineeg diniin, dayun sumiled diag balay. Benaꞌ mitulan, linabet nu nga sakupen si Isus, laung nilan diniin, “Sir, saꞌ mesuꞌat, pegulug mu dinami ki sinambingay mu kiin mekatag di sigbet diag binaalan.” ");
INSERT INTO syb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Mendadi, kaliꞌ sembag si Isus, “Naa su getaw kia migimula gempia beniꞌ, naan kini, kig Bataꞌ nu Kilawan. ");
INSERT INTO syb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Sug binaalanen pelum, iini tibuuk lumbang. Ki gempia beniꞌ, iin su nga getaw suminakup tu Keglekaunutan nu Megbebayaꞌ. Naa su sigbet dema, iin su nga sakup nu Palin. ");
INSERT INTO syb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Su pelum kuntra nu gapuꞌ lupaꞌ, su mimula lisu sigbet kia, iin su Palin. Naa sug basa meglegani, iini kelengkeb nug benwa. Mukaꞌ su nga getaw meglegani, iini nga sesuguꞌen nu Megbebayaꞌ getaw langit. ");
INSERT INTO syb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Naa su nga sigbet pungunen dayun sensulay, maꞌantu dademai mpenggulaula saꞌ sungu na melengkebig benwa. ");
INSERT INTO syb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Naan kini, kig Bataꞌ nu Kilawan, suguꞌen ku ditu nga getaw tu Keglekaunutan ku su nga sesuguꞌen ku getaw langit, puꞌ adun pungunen nilan su mikesabaꞌ tug dumanen mekesalaꞌ, sampay su kelaun meglimbung. ");
INSERT INTO syb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Dayun ilan kini, lebuꞌen ilan nu nga getaw langit tug linaw gapuy. Ditu ilan dayun mengaduy, lamug mengkiget ilan di ngisi nilan. ");
INSERT INTO syb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Dagid ki nga mekesuun getaw dema, pitanggiꞌu tu tiag nu gendaw, puꞌ mpeduma ilan di kegdedengeg nu Megbebayaꞌ saꞌ meglekaunutan na tuꞌu iin.” Diksuꞌ ni Isus su taluꞌen, “Adin sug duuni telinganen, mekineeg dema tuꞌu! ");
INSERT INTO syb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Mendadi kig lagaꞌ nu kesakup nu getaw tu Keglekaunutan nu Megbebayaꞌ, penenggiꞌan dun kig lagaꞌ kwarta iglud dig dialem lupaꞌ. Naa pinenggiꞌ duuni getaw mekaitaꞌ tu kwarta kia. Lebengenen deliꞌ puliꞌ dia, dayun muliꞌ tug balayen, leliagen gupia. Mangay dayun meksesaluy di taman gimunen, dayunen seluyay kig lupaꞌ kia. ");
INSERT INTO syb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Mendadi kig lagaꞌ nu kesakup nu getaw tu Keglekaunutan nu Megbebayaꞌ, sala pa penenggiꞌan dun kig lagaꞌ dyamanti. Pinenggiꞌ duuni getaw mendagang dyamanti, penengauneni nga mesibaꞌ gupia. ");
INSERT INTO syb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Mendadi saꞌ metuunen ki melagaꞌ gupia dyamanti, mangay dayun meksesaluy tu kelaun gimunen, dayunen seluyay kig dyamanti kia.” ");
INSERT INTO syb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Laung padun ni Isus, “Mendadi saꞌ meglekaunutan na tuꞌu su Megbebayaꞌ, ki mpenggulaula, iini penenggiꞌan dun su nga getaw memaling diag linaw. Pinenggiꞌ ektaken nilan sug baling nilan, melaun dayun sedaꞌ melaam nilan, megleleginis su sedaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Naa saꞌ mpenuꞌ sug baling, guyuden nilan dayun tu geksid, megingkud ilan dia, pemiliꞌan nilan dayun su sedaꞌ. Ki melengas dun, teguꞌen nilan dia ngag betangan nilan. Ki ndiꞌ pia aanen dema, belengen nilan. ");
INSERT INTO syb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mendadi, maꞌnia dademai mpenggulaula saꞌ sungu na melengkebig benwa. Metuaꞌ su nga sesuguꞌen nu Megbebayaꞌ genat tu gekbus langit, dayun pungunen nilan ki nga melaat getaw, painen nilan ditu nga mekesuun getaw. ");
INSERT INTO syb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Dayun su melaat getaw, lebuꞌen nilan tug linaw gapuy. Ditu ilan dayun mengaduy, lamug mengkiget ilan di ngisi nilan.” ");
INSERT INTO syb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Naa saꞌ maꞌantu, sinaak ni Isus tu nga sakupen, “Naa kig launanen kini, mesabut niu?” “Waꞌa,” simbag nilan. ");
INSERT INTO syb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Laung ni Isus, “Saꞌ maꞌnia, adin su getaw gandang mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, dayun sumakup tu Keglekaunutan nu Megbebayaꞌ, iin, petanggiꞌu di gapuꞌ balay melaun gimunen mitaguꞌen, begu saꞌ daan, misangkap na.” ");
INSERT INTO syb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Naa benaꞌ mitubus ni Isus su nga sambingayen kia, migawaꞌ dig benwa kia, ");
INSERT INTO syb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","minuliꞌ ditug daan lunsuden. Benaꞌ minateng ditu, mikpetuꞌun dia simbaan nu getaw Judea. Mendadi su nga getaw mikineeg diniin, misebuꞌan ilan dun, kaliꞌ ilan pektaluꞌ, “Paa, ki getaw kini, adinen ma pigenati sinuunanen kini? Pikendunen ma duni nga mekesalebuꞌ pinggulaulanen kiin? ");
INSERT INTO syb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Puꞌ kanaꞌ bain sug bataꞌ laak nu panday kiin dig balay? Kanaꞌ ba ginaꞌen si Maria, mukaꞌ pateden si Santiago, si Jose, si Simon, mukaꞌ si Judas? ");
INSERT INTO syb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kanaꞌ ba dini da pegbenwa su kelaun pateden libun? Naa saꞌ maꞌantu, alandun saani pigenatanen di kelaunanen kini?” ");
INSERT INTO syb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Maꞌantu, pimilas nilan si Isus. Mendadi, miktaluꞌ dinilan si Isus, “Ki pimuunan nu Megbebayaꞌ, pegbesaan pia adin angay. Laak dagid diag daan benwanen, diag daniin betaꞌan, ndiꞌ daan pegbesaan.” ");
INSERT INTO syb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Saꞌ maꞌantu, meliangi mekesalebuꞌ pinggulaula ni Isus diag benwa kia, sabaꞌ ndaꞌ pekpetuud diniin su nga getaw dia. ");
INSERT INTO syb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Naa su kaunutan dia Galilea si Herodes, midengegen su pinggulaula ni Isus. ");
INSERT INTO syb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Benaꞌ midengeg ni Herodes, kaliꞌ pektaluꞌ, “Uy, kiin si Isus, iin si Juan su Memunag Tubig, masiꞌ mitubuꞌ puliꞌ! Kaas ma duuni ginuungen menggulaula mekesalebuꞌ.” ");
INSERT INTO syb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kaas maꞌniai tinaluꞌ ni Herodes, puꞌ begudiin su ndaꞌ pa patay si Juan, suminuguꞌ si Herodes puꞌ daapen si Juan, pibaluden dakus pipirisunen. Puꞌ iini puunanen, begudiin duuni sala tawan libun ngalanen si Herodias, inagaw ni Herodes, asa sawa nu pated ni Herodes si Felipe. ");
INSERT INTO syb_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kaas si Juan, tatap mektaluꞌ dini Herodes, “Binandu ma ditu Misulat Palinta nu Megbebayaꞌ, penginsuaan mu si Herodias!” ");
INSERT INTO syb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Naa kagina maꞌantu, petain sia ni Herodes si Juan, laak mendek si Herodes tu melaun getaw, puꞌ sug delendeman nilan, pimuunan nu Megbebayaꞌ si Juan. ");
INSERT INTO syb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Naa kini si Herodes, miglumpuk metaang di gendawanen. Benaꞌ miglumpuk si Herodes, duunig bataꞌ nu sawanen kia si Herodias, delaga, suminayaw dia gedapan nu nga getaw suminaup dia. Si Herodes, liliag dayun tu kesayaw nug delaga kia. ");
INSERT INTO syb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Suminapa dayun si Herodes, laungen, “Naa, Enuꞌ, pia taꞌ alanduni penengiin mu dinaan, begayu diniꞌa!” ");
INSERT INTO syb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","“Naa, iini begay mu dinaan, ki gulu ni Juan, su Memunag Tubig, betangen nandaw dig dekulan!” Laak ki sembagen kini, tinituluꞌ dun nu ginaꞌen sug delaga. ");
INSERT INTO syb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Naa, apelai, milegenani gadiꞌ kini. Dagid sabaꞌ nu kesapanen kia di gedapan nug launan bisitanen, subay suguꞌenen begay tug delaga ki pinenginen kia. Suminuguꞌ dayun si Herodes, ");
INSERT INTO syb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","pinutukan tuꞌu gulu si Juan diag dialem pirisuan. ");
INSERT INTO syb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Iwit dayun diag delaga ki gulu ni Juan, bitang tuꞌu dig dekulan, tinulun diag delaga, dayun pigwakilen dia ginaꞌen. ");
INSERT INTO syb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Naa duun dayuni nga sakup ni Juan mituaꞌ dia, inangay nilan sug bangkay ni Juan, dayun nilan lebengay. Benaꞌ milebeng nilan, minundas ilan tu ni Isus, inukit nilan diniin su mipenggulaula ni Juan. ");
INSERT INTO syb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Naa si Isus, benaꞌ midengegen su pitenday kia di mipenggulaula ni Juan, migawaꞌ dayun diag benwa kia, suminakay sekayan, adun mekpain pa sia di meliawliaw benwa. Laak su nga melaun getaw dia ngag lumibut lunsud, misuunan nilani kepanaw kia ni Isus. Saꞌ maꞌantu, miglendug ilan, ditu ilan minian lupaꞌan. ");
INSERT INTO syb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Saꞌ maꞌnia, benaꞌ mikelusad si Isus tu sekayan, minitaꞌen ki melaun gupia getaw. Milelaat dinilan si Isus, pineguliꞌanen dayun su nga pegladu dinilan. ");
INSERT INTO syb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Naa benaꞌ sungu na mesindepi gendaw, mikpesempel dini Isus su nga sakupen, kaliꞌ ilan pektaluꞌ, “Sir, sungu na mesindepi gendaw, mukaꞌ kig benwa kini, meliaw pa pelum. Kaas melengas suguꞌen mu, Sir, su nga getaw, mangay ilan tu ngag lunsud puꞌ adun mekesaluy ilan lebungan nilan.” ");
INSERT INTO syb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Sumimbag si Isus, “Ndiꞌ ilan kambat mundas ditu. Yamu mai mekpaan dinilan!” ");
INSERT INTO syb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","“Apelai, Sir!” simbag nu nga sakupen. “Duun laakig lima buuk pan nami kini, dayun duunig duaꞌ buuk sedaꞌ.” ");
INSERT INTO syb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Laung ni Isus, “Naa, uit niu dini naan.” ");
INSERT INTO syb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mendadi, pimaingkud dayun ni Isus su melaun getaw diag lamalama. Mendadi benaꞌ migelaꞌ ilan mekaingkud, inimud ni Isus kig lima buuk pan mukaꞌ sug duaꞌ buuk sedaꞌ, dayun megangag tug langit mukaꞌ mekpaladpalad tu Megbebayaꞌ. Pikpetapetanen dayun su pan kia, piktukiden pegilasay tu nga sakupen. Pingilak nilan dayun tu nga melaun getaw. ");
INSERT INTO syb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Minaan dayun su kelaun getaw, mukaꞌ migelaꞌ ilan mbesug. Benaꞌ mibesug nailan, kaliꞌ pengikpesay nu nga sakup ni Isus su sawad nilan dun, sepuluꞌ buꞌ duaꞌ dig belanan mipenuꞌen. ");
INSERT INTO syb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Su getaw minaan dun, lima ngibu tawan su laak lumbus laki, ndaꞌig labeti ngag libun mukaꞌ nga gembataꞌ. ");
INSERT INTO syb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Naa benaꞌ mitubus maan su nga kelaun getaw, pisakay ni Isus su nga sakupen tu sekayan, piunanen ilan dumipag tug linaw. Daniin, piuliꞌen pa su melaun getaw. ");
INSERT INTO syb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Naa benaꞌ migudas na dema ditu nga getaw, tumiwad dayun si Isus salanen dig bentud, adun menenabi dia. Saꞌ maꞌantu, benaꞌ miglegebii na, sala da ni Isus dia. ");
INSERT INTO syb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Su sekayan nu nga sakupen, ditu na titengaꞌ laud nug linaw. Mikiwangiwang patiꞌ sabaꞌ nu medekdes nabek, puꞌ misensung nilan su genus. ");
INSERT INTO syb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mendadi, benaꞌ sungu na daliꞌ endaw, minangay si Isus ditu nilan, pekpanaw diag dibabaw tubig. ");
INSERT INTO syb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Benaꞌ midayag nilan si Isus masiꞌ pekpanaw diag dibabaw tubig, mindek ilan patiꞌ. Migbeksay ilan, laung nilan, “Multu main!” ");
INSERT INTO syb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Dagid miktaluꞌ si Isus dinilan, “Naa, gempia dai ginaa niu. Naan daini. Ndiꞌ amu mendek.” ");
INSERT INTO syb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Si Pedro, suminambut mektaluꞌ, laungen, “Kaunutan, saꞌ metuud puꞌ yaꞌa tuꞌu, sabi mau mediin niꞌa, pepenaun mau dema dig dibabaw tubig kini.” ");
INSERT INTO syb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Naa, diniin ka!” simbag ni Isus. Aba, guminawas dayun si Pedro di sekayan, mukaꞌ mipanaw dema diag dibabaw tubig, suminungkak sia dini Isus. ");
INSERT INTO syb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Dagid kaliꞌen mbetikay su metikteg genus, mindek pelum si Pedro, benaꞌ peglened na. “Kaunutan,” laungen, “gawen mau!” ");
INSERT INTO syb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tinggal dayun ni Isus sug baingkenen, piguidanen si Pedro, laungen diniin, “Mauma dema maikaꞌi kesalig mu dinaan? Mauma dema duaꞌduaꞌi kesalig mu dinaan?” ");
INSERT INTO syb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Suminakay dayun ilan duaꞌ dia sekayan. Misikpaꞌ dayuni genus. ");
INSERT INTO syb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Minginlulud dayun di gedapan ni Isus su nga sakupen dia sekayan, laung nilan, “Metuud lai daan, yaꞌa na gupia sug Bataꞌ nu Megbebayaꞌ!” ");
INSERT INTO syb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Mendadi, minundas si nga Isus dumipag diag linaw. Benaꞌ dumingguꞌ ilan tu Genesaret, ");
INSERT INTO syb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","miꞌilala dayun nu nga getaw dia si Isus. Saꞌ maꞌnia, pimuun nilan dayun su nga pegladu di kelaun lumibut benwa, pinguit ilan dayun dia ni Isus. ");
INSERT INTO syb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Inubug nilan dini Isus, pia laak daw sia medeluꞌ nu nga megladu su kuyamay suuben. Mukaꞌ adin su taman getaw mikedeluꞌ dun, migelaꞌ ilan dayun mauliꞌay. ");
INSERT INTO syb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mendadi duuni nga Pariseo mukaꞌ nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ genat tu Jerusalem, minadap ilan dini Isus, sinaak nilan diniin, ");
INSERT INTO syb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Mauma ki nga sakup mu kiin, pimilas nilan sug betad pingumbilin dinita nu nga ginepuꞌay ta? Ndiꞌ nilan gelaꞌen dunutay sug betad ta mekatag di pengingenaw dekag pa aan!” ");
INSERT INTO syb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Kaliꞌ sembag si Isus dinilan, “Paa, yamu kiin, mauma pimilas niu su palinta nu Megbebayaꞌ, iin sungkini dunutan niu, sug daniu betad? ");
INSERT INTO syb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Puꞌ duuni palinta nu Megbebayaꞌ, laung, ‘Pegbesaay mu su ginaꞌ mu mukaꞌ su gamaꞌ mu.’ Mukaꞌ duun pagidi palinta, ‘Adin su getaw menampalaksa tu ginaꞌen atawaka tu gamaꞌen, subay petain.’” ");
INSERT INTO syb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Laung pa ni Isus, “Dagid iinig daniu tituluꞌan, saꞌ duun siai ginabang begay nu getaw tu ginaꞌen atawaka tu gamaꞌen, mesuꞌat daw teluꞌen nu getaw kia, ‘Kini, begay sungkin tu Megbebayaꞌ.’ ");
INSERT INTO syb_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Dayun saꞌ kiai teluꞌen nu getaw, naa sug basanen sia tu gamaꞌen, ndiꞌ na daw kambat begay diniin. Naa saꞌ maꞌnia, su Misulat Palinta nu Megbebayaꞌ, bileng niu, sinukli niu dun kig daniu laak betad. ");
INSERT INTO syb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Paa, yamu kiin, tautau mekesuun amu! Misugat amu gupia ditu sinulat pedaan ni Isaias dengantu ditu Taluꞌ nu Megbebayaꞌ, laungen, ");
INSERT INTO syb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ki nga getaw kini, laung nu Megbebayaꞌ, pegbesaanu nilan diin laak babaꞌ nilan, dagid sug delendeman nilan, melayuꞌ ma dinaan. ");
INSERT INTO syb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Su kektamuy nilan dinaan, ndaꞌiduni pantagen, puꞌ su tituluꞌan nilan, kinilawan laak, asa piningalan nilan dun, pinalintau!’” ");
INSERT INTO syb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Naa sinabi ni Isus su nga melaun getaw mekpesempel diniin. Benaꞌ mikpesempel ilan, kaliꞌ pektaluꞌ si Isus dinilan, “Pekineegay niu gupia ki teluꞌen ku kini, adun mesabut niu gupia! ");
INSERT INTO syb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kanaꞌ iini mekesalaꞌ dun tu Megbebayaꞌ su getaw, ki mekeseled dig babaꞌen genat dig liu. Iini mekesalaꞌ dun su getaw, ki guaꞌ dig babaꞌen.” ");
INSERT INTO syb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Naa benaꞌ mideksuꞌ mektituluꞌ si Isus, mikpesempel diniin su nga sakupen, laung nilan, “Sir, ki tinaluꞌ mu kia, misuunan mu ma, milaati ginaa dun nu nga Pariseo?” ");
INSERT INTO syb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Kaliꞌ sembag si Isus, “Paa, duuni gendaw mateng, adin su mentubuꞌ kanaꞌ pimula nu Gamaꞌu ditu gekbus langit, bekuten. ");
INSERT INTO syb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kaas ki nga Pariseo kiin, petuyang na niu ilan! Puꞌ maꞌniin ilan buta, dayun egaken nilani nga getaw, buta dadema. Naa pinenggiꞌ meginegakayig duaꞌ tawan lungkan buta, dayun buus duunig luak dia gunaan nilan, ndiꞌ ba megelaꞌ ilan dayun melabuꞌ dia?” ");
INSERT INTO syb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Laung ni Pedro, “Naa, Sir, ki sambingay mu kia, pegulug mu dinami.” ");
INSERT INTO syb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Kaliꞌ sembag si Isus, “Apelai, pia pamu, ndaꞌ dadema niu mesabut? ");
INSERT INTO syb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ndaꞌ ba niu mesabut puꞌ pia taꞌ alanduni aanen nu getaw, mpalus da laak tu tianen, dayun guaꞌ da pelum dig lawasen? ");
INSERT INTO syb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Dagid ki guaꞌ dig babaꞌen kia, genat tug delendemanen, iin tantui mekesalaꞌ dun su getaw. ");
INSERT INTO syb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Puꞌ kig delendeman nu getaw, iini pigenatan nu melaat delendeman, su puun nu kegbunuꞌ, su kenlelingay, sug dusa, su kegdaaw, su kegbalus, mukaꞌ su tampalaksa. ");
INSERT INTO syb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kini tuꞌui mekesalaꞌ dun su getaw. Laak su kemilas tug betad mekatag di pengingenaw dekag pa aan, kanaꞌ mekesalaꞌ dun su getaw tu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Naa migawaꞌ na dia si Isus, minangay pelum tug benwa mesempel tug lunsud Tiro mukaꞌ Sidon. ");
INSERT INTO syb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mendadi benaꞌ minateng ditu si Isus, duuni mikpesempel diniin libun dangen dia laak lain bansa, puꞌ getaw Canaan. Migbeksay sug libun, laungen, “Uu Sir, Sapuꞌa ni David, lelaatay mau! Puꞌ duunig bataꞌu libun, silunuꞌan menulay, milesayan dun gupia.” ");
INSERT INTO syb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Dagid ndaꞌ sembag si Isus, pia sektaang. Minadap diniin su nga sakupen, inubug nilan diniin, “Pawaꞌ mu iin! Puꞌ peglenduglendug da gusay dinita, meksasak gupia!” ");
INSERT INTO syb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Kaliꞌ sembag si Isus tug libun kia, “Iini sinuguꞌu dun lumusad dinig lumbang, adun pegebangan ku su laak bansa Israel, ki pitanggiꞌu di nga karniru mibeleng.” ");
INSERT INTO syb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Dagid kig libun kini, mikpesempel dayun dini Isus, minginlulud ditu gedapanen. Laungen, “Sir, gebangay mau dema tuꞌu!” ");
INSERT INTO syb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kaliꞌ sembag si Isus, “Ndiꞌ mpia awiꞌ tu gembataꞌ su gaanen, adun tikpuꞌen dia nga gituꞌ.” ");
INSERT INTO syb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kaliꞌ sembag sug libun, “Metuud la Sir, dagid pia su nga gituꞌ, aanen nilan su nga mikulaꞌ gaan dia silung nug lemisaan nu gapuꞌ nilan.” ");
INSERT INTO syb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Sumimbag dayun si Isus, “Aa naa, Dadaꞌ, gembageli kesalig mu! Kagina maꞌnia, su mauyaꞌan mu, mialap mu na.” Naa, iin da tuꞌu su kauliꞌay nug bataꞌ nug libun kia. ");
INSERT INTO syb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Naa minundas si Isus, inunuten su geksid nug Linaw Galilea. Tumiwad dig bentud, dayun migingkud dia. ");
INSERT INTO syb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mendadi melaun gupia getaw minangay dia niin, iwit nilan dadema ditui nga getaw mipilung, ngag buta, nga migisu, ngag beed, mukaꞌ melaun pa pemegladu. Adin su iwit nilan dia gedapan ni Isus, pineguliꞌanen dayun. ");
INSERT INTO syb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Misebuꞌan gupia su nga getaw ditu minitaꞌ nilan, puꞌ su kamun beed, mikabit na. Su kamun migisu, miuliꞌan na. Su kamun mipilung, mikepanaw na. Dakus su ngag buta kamun, mikengitaꞌ na. Kaas inal nilan su Megbebayaꞌ pektemuyen nu nga getaw Israel. ");
INSERT INTO syb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Mendadi, sinabi ni Isus su nga sakupen. Benaꞌ mikpesempel ilan diniin, kaliꞌ pektaluꞌ si Isus, “Milelaatu di nga melaun getaw kini, puꞌ telu endaw na ndaꞌ ilan pesuay dinaan, dayun migelaꞌ na demaig balun nilan. Naa, mpauku mekpauliꞌ dinilan ndaꞌ ilan mekaꞌaan, puꞌ tekaw mbuus belunusan ilan dig dalan.” ");
INSERT INTO syb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Dagid kaliꞌ sembag su nga sakup ni Isus, “Sir, kig benwa kini, limawaꞌ. Saꞌ maꞌantu, adin ta ma elapayi gaan, sukal paan ta sia di nga melaun getaw kini?” ");
INSERT INTO syb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","“Naa, sanu buuki pan niu diin?” sinaak ni Isus. Kaliꞌ ilan sembag, “Pitu buuk, mukaꞌ duun pagidi santaꞌ buuk mekaikaꞌ sedaꞌ.” ");
INSERT INTO syb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Mendadi, pimaingkud dayun ni Isus su nga getaw diag lupaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Benaꞌ mikaingkud ilan, inalap dayun ni Isus ki pitu buuk pan kia mukaꞌ su sedaꞌ, dayun mekpaladpalad tu Megbebayaꞌ. Benaꞌ mitubus mekpaladpalad, pikpetapetanen su pan, piktukiden pegilasay tu nga sakupen. Pingilak nilan dayun tu nga melaun getaw. ");
INSERT INTO syb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Minaan dayun su kelaun getaw, mukaꞌ migelaꞌ ilan mbesug. Benaꞌ mibesug ilan, kaliꞌ pengikpesay nu nga sakup ni Isus su sawad nilan, pitu dig bukag mipenuꞌ pa nu samaꞌ nilan. ");
INSERT INTO syb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Su getaw minaan ditu nga pan, paat ngibu tawanig laki, ndaꞌig labeti ngag libun mukaꞌ nga gembataꞌ. ");
INSERT INTO syb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Naa benaꞌ mitubus maan su melaun getaw, piuliꞌ ilan ni Isus. Duminangan dayun tu sekayan si Isus, minangay tug benwa sakup Magadan. ");
INSERT INTO syb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Naa duuni nga Pariseo mukaꞌ Saduseo minangay kumitaꞌ dini Isus, pengimanan nilan sia iin. Saꞌ maꞌnia, miksaak ilan diniin mekesalebuꞌ tuꞌus, adun gempantek daw puꞌ genat tu Megbebayaꞌ su pegbayaꞌen. ");
INSERT INTO syb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Dagid kaliꞌ sembag si Isus, “Paa, yamu kiin, saꞌ sungu mesindepi gendaw, iini teluꞌen niu, ‘Gempiaig benwa lemaꞌ, puꞌ gempulaig langit.’ ");
INSERT INTO syb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Dayun saꞌ siselem, laung niu, ‘Dumupiꞌ buus, puꞌ gempulaig langit, mukaꞌ megdelem.’ Saꞌ maꞌantu, metau amu mengatuk tuꞌus dig langit, dayun ndiꞌ niu maulug ki tuꞌus dig basa kini nandaw. ");
INSERT INTO syb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Paa, yamu pa di nga getaw nemun, medupang amu gupia, memilas amu pelum tu Megbebayaꞌ! Penengiin niu dinaani mekesalebuꞌ tuꞌus, asa daal da laaki tuꞌus begay diniu, ki maaꞌ nu pinggulaula nu pimuunan nu Megbebayaꞌ dengantu, si Jonas.” Saꞌ maꞌnia, migawaꞌ dinilan si Isus, mipanaw dayun. ");
INSERT INTO syb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Naa saꞌ duminipag si nga Isus diag linaw, milingawan nu nga sakupen megbalun pan. ");
INSERT INTO syb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Mendadi kaliꞌ pektaluꞌ si Isus dinilan, “Ki petulin nu nga Pariseo mukaꞌ nu nga Saduseo di pan, peglengilamay niu.” ");
INSERT INTO syb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Benaꞌ midengeg nu nga sakupen, kaliꞌ ilan pegyagayaga, laung nilan, “Kaas tinaluꞌeni maꞌnia, puꞌ ndaꞌ ita kegbalun pan.” ");
INSERT INTO syb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Laak dagid misuunan ni Isusi pigyagayaga nilan kia. Kaliꞌ pektaluꞌ dinilan, “Paa, mauma pelum pegyegayegaan niu ki pan, saꞌ ndaꞌidun diniu? Maikaꞌ gupiai kesalig niu dinaan! ");
INSERT INTO syb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Masiꞌ ndaꞌ pa niu mesabut? Milingawan ba niu su kemetau tug lima buuk pan, ki piꞌaan dayun tug lima ngibu tawan kitu? Dayun sanu belanan pai samaꞌ dun, su pingikpes niu dun kitu? ");
INSERT INTO syb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Mukaꞌ su kemetau tu pitu buuk pan, ki piꞌaan pelum tu paat ngibu tawan, sanu bukag ma pelumi pingikpes niu tu sawad nilan maan? ");
INSERT INTO syb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Saꞌ maꞌantu, mauma dema ndaꞌ niu gusay mesabut puꞌ kanaꞌ nu pani tinaluꞌu diniu? Kaas peglengilamay niu daan ki petulin nu nga Pariseo mukaꞌ Saduseo di pan!” ");
INSERT INTO syb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Naa dekag pa misabut nu nga sakup ni Isus puꞌ kanaꞌ nu tantu petulin di pani kenegulen dinilan kia, segaga ki tituluꞌan nu nga Pariseo mukaꞌ Saduseo. ");
INSERT INTO syb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Naa minangay si nga Isus tug benwa sakup dig lunsud Cesarea Filipo. Benaꞌ ditu nailan, sinaak ni Isus tu nga sakupen, “Mendadi naan kini, kig Bataꞌ nu Kilawan, saꞌ su gasalu, alanduni ketaluꞌ dun nu getaw?” ");
INSERT INTO syb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kaliꞌ sembag su nga sakupen, “Sug duma getaw, teluꞌen nilan, yaꞌa daw si Juan su Memunag Tubig. Saꞌ sug duma mektaluꞌ, yaꞌa daw si Elias dengantu. Mukaꞌ duun pa pagidi mektaluꞌ, yaꞌa daw si Jeremias, atawaka sala tawan pa pelum pimuunan nu Megbebayaꞌ dengantu.” ");
INSERT INTO syb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Mendadi yamu dema,” sinaak ni Isus, “taꞌ mai ketaluꞌ niu dun, ki gasalu?” ");
INSERT INTO syb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sumimbag si Simon Pedro, “Yaꞌa na gupia su Tinduꞌ nu Megbebayaꞌ Meglekaunutan, kig Bataꞌ nu Megbebayaꞌ ndaꞌi gumulen.” ");
INSERT INTO syb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","“Aa naa, Simon, bataꞌa ni Jonas,” laung ni Isus, “leliagenu diniꞌa tuꞌu! Puꞌ kiin, kanaꞌ nu kilawani mikpesuun dun diniꞌa, puꞌ su Gamaꞌu ditu gekbus langit! ");
INSERT INTO syb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mendadi, taman taluꞌu diniꞌa, yaꞌa si Pedro. Naa saꞌ maꞌantu, saꞌ baalen ku na kig balayu, saꞌitada ki pikumpungan nu nga sakupu, naa kiniig batu gentudan ku nug balayu. Mukaꞌ ki pikumpungan kia, ndiꞌ na daagen nu kepatay. ");
INSERT INTO syb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Pegwakilu diniꞌa su nga gunsiꞌ tu Keglekaunutan nu Megbebayaꞌ. Naa saꞌ maꞌantu, adin sug benduun mu dinig dibabaw lumbang, benduun dadema ditu gekbus langit. Adin sug buangen mu dinig dibabaw lumbang, buangen dadema ditu gekbus langit.” ");
INSERT INTO syb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Dayun inungub gupia ni Isus su nga sakupen, ndiꞌ nilan pekpesuun tu getaw puꞌ iin su Tinduꞌ nu Megbebayaꞌ Meglekaunutan. ");
INSERT INTO syb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mendadi, genat di gendaw kia, mikpuun si Isus menluksad tu nga sakupen. Laungen, “Mendadi naan, subay medituunu Jerusalem, dayun melaun pai kekpeleget dinaan nu nga kaunutan nu getaw Judea mukaꞌ nu nga kaunutan nug belian nilan kampuꞌ nu mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ. Deksuꞌanen, petainu nilan. Laak dagid di ketelu endawen genat di kepatayu, petubuꞌenu puliꞌ.” ");
INSERT INTO syb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Dagid benaꞌ midengeg ni Pedro, inabigen si Isus, dayun pimaagen, laungen, “Kaunutan, penensili kanaꞌ maꞌantu! Ndiꞌ mesuꞌat maꞌniai mbianan mu!” ");
INSERT INTO syb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Laak dagid si Isus, liningayen si Pedro, kaliꞌ pektaluꞌ diniin, “Pegawaꞌa dinaan, Satanas! Mauma pegdaangan mau sia? Puꞌ kig delendeman mu kiin, kanaꞌ genat tu Megbebayaꞌ, puꞌ delendeman laak nu kilawan!” ");
INSERT INTO syb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kaliꞌ dayun pektaluꞌ si Isus tu nga sakupen, “Mendadi, saꞌ duuni getaw mauyaꞌanen sumakup dinaan, subay teliudanen sug daniin delendeman, pisanenen dayun ki kurusen, dakus dumunut gusay dinaan. ");
INSERT INTO syb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Puꞌ adini mpauk megwakil gumulen dinaan, mbeleng diniin su ketubuꞌ ndaꞌi tamanen. Adin su pegwakilen dinaan su gumulen sabaꞌ nu kesakupen dinaan, iin, malapen sungkin su ketubuꞌ ndaꞌi tamanen. ");
INSERT INTO syb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Puꞌ pia pa malap nu getaw su tibuuk lumbang, dayun mbeleng diniin su ketubuꞌ ndaꞌi tamanen, naa alandun bai gatagen? Ndaꞌidun! Puꞌ saꞌ mbeleng na di getaw su ketubuꞌ ndaꞌi tamanen, duun bai mbayaden, adun melekaten sia puliꞌ su ketubuꞌen? ");
INSERT INTO syb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Puꞌ ndiꞌ na maiben, naan kini, kig Bataꞌ nu Kilawan, lumusadu puliꞌ, medayag na su kelengas nu pegbayaꞌ nu Gamaꞌu, maitaꞌ di tiagu, dumau su nga sesuguꞌen ku getaw langit. Dayun saꞌ matengu, sugdaan ku su nga getaw saladuaꞌ, mbantang tu pinggulaulanen, gempia saꞌ melaaten.” ");
INSERT INTO syb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Diksuꞌ ni Isus su taluꞌen, “Taman taluꞌu diniu, yamu nga getaw pegindeg dini nandaw, duun diniui ndiꞌ matengi gumulen, meduaꞌ matanen meglekaunutan nau tuꞌu, naan kini, kig Bataꞌ nu Kilawan.” ");
INSERT INTO syb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Naa benaꞌ minayani genem gebii, tumiwad si Isus di metaas bentud. Pidunuten si Pedro mukaꞌ duaꞌ tawan mekpated, si Santiago mukaꞌ si Juan, ilanilan da laak. ");
INSERT INTO syb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mendadi, benaꞌ ditu nailan dibabaw nug bentud, saanan nu nga sakupen megbantay diniin, masiꞌ mitekaw mpalin su palas ni Isus, tumiagi muluꞌen, maaꞌ nu tiag nu gendaw. Sampay su nga penepetenen, miputiꞌ tantu, maaꞌ nug delag. ");
INSERT INTO syb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mukaꞌ padun minitaꞌ nilanig duaꞌ tawan dengantu pimuunan nu Megbebayaꞌ, masiꞌ si Moises mukaꞌ si Elias, pegabitabit ilan ni Isus. ");
INSERT INTO syb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Si Pedro, kaliꞌ pektaluꞌ dini Isus, “Aa Kaunutan, melengas puꞌ dini dami! Naa saꞌ meliaga da, megbaalu dini bebelayan telu buuk, salabuuk daniꞌa, salabuuk dani Moises, mukaꞌ salabuuk dani Elias.” ");
INSERT INTO syb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Benaꞌ ndaꞌ medeksuꞌ mektaluꞌ si Pedro, duuni gabun mituaꞌ, tumiag gupia, mikeleklem dinilan. Duuni miktaluꞌ dig dialem gabun kia, laungen, “Kini na tuꞌu sug Bataꞌu, ki petailen ku, leliagenu dun gupia. Pekineegay niu iin!” ");
INSERT INTO syb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Naa benaꞌ midengeg nu nga sakup ni Isus ki taluꞌ kia, mipatiꞌ ilan mendek, mikeglaub ilan diag lupaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Dagid mikpesempel dinilan si Isus, dipenanen ilan, laungen, “Naa, pegbuat amu. Ndiꞌ amu mendek!” ");
INSERT INTO syb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kaliꞌ ilan tingag, ndaꞌidun nai getaw minitaꞌ nilan dia, sala da dun ni Isus. ");
INSERT INTO syb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mendadi duminiksun ilan genat diag bentud. Saanan nilan dumiksun, inungub ni Isus su nga sakupen, laungen, “Ki pinitaꞌ diniu kia, ndaꞌiduni ukitan niu dun, pia sala tawan, sampay da dun petubuꞌen puliꞌ kig Bataꞌ nu Kilawan genat matay.” ");
INSERT INTO syb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Sinaak nu nga sakupen dini Isus, “Sir, saꞌ maꞌnia, su nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, taꞌ mai ketaluꞌ nilan dun puꞌ subay lumusad pa si Elias, dekag pa ki Tinduꞌ nu Megbebayaꞌ Meglekaunutan?” ");
INSERT INTO syb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Kaliꞌ sembag si Isus, “Naa metuud, si Elias, mauna daan metuaꞌ, puꞌ adun pengusainen pa sug launan. ");
INSERT INTO syb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Dagid taman taluꞌu diniu, si Elias, daan na mituaꞌ, dagid iin, ndaꞌ mailala nu getaw, dayun linaksap nilan peglegetay. Mendadi naan kini, kig Bataꞌ nu Kilawan, maꞌantu dadema, pelegetan dau dema nu getaw.” ");
INSERT INTO syb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Iin pa mesabut nu nga sakup ni Isus puꞌ ki tinaluꞌen kia mekatag dini Elias, iini pisugaten dun si Juan su Memunag Tubig. ");
INSERT INTO syb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mendadi benaꞌ minateng puliꞌ si nga Isus dia tandaꞌ nu melaun getaw kia, duuni sala tawan mikpesempel dini Isus, minginlulud di gedapanen, ");
INSERT INTO syb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","kaliꞌ pektaluꞌ, “Sir, lelaatay mu kig bataꞌu kini! Puꞌ binabuy patiꞌ, tatap melabuꞌ di gapuy atawaka di tubig. ");
INSERT INTO syb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Naa, iwitu dini nga sakup mu kini, laak ndaꞌ nilan megaga pauliꞌay.” ");
INSERT INTO syb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Kaliꞌ pektaluꞌ si Isus tu nga getaw dia, “Ay, yamu pa di nga getaw nemun, ndaꞌi salig niu dinaan, mipenulay amu! Pinlukas nau dumuma diniu. Santaꞌ pai kaibenen, ki ketigelu diniu? Uit niu dini naani gembataꞌ kiin!” ");
INSERT INTO syb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Mendadi pimaag dayun ni Isus ki menulay kia. Migawaꞌ dayun su menulay, mitekaw mauliꞌay su gembataꞌ. ");
INSERT INTO syb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Naa benaꞌ ndaꞌidunig lain getaw duma nilan, minadap dini Isus su nga sakupen, sinaak nilan diniin, “Sir, alanduni puunanen, ndaꞌ nami mautiday dun su menulay kitu?” ");
INSERT INTO syb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Simbag ni Isus dinilan, “Sabaꞌ kulangi kesalig niu! Puꞌ taman taluꞌu diniu, ki kesalig niu, pia laak sia maꞌniin bagel salabuuk lisu mustasa, naa megaga niu suguꞌayig bentud kinuꞌ, laung niu, ‘Awaꞌa diin, galin ka ditu!’ dayun gumalin dema tuꞌu kig bentud. Kaas ndaꞌiduni ndiꞌ niu megaga! ");
INSERT INTO syb_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Dagid ki maꞌniin palas, ndiꞌ mautidan, subay pebianen laak di kenenabi mukaꞌ di kekpuasa.” ");
INSERT INTO syb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Naa benaꞌ mikpungun dini Isus ditu Galilea su nga sakupen, kaliꞌ pektaluꞌ si Isus dinilan, “Mendadi naan kini, kig Bataꞌ nu Kilawan, duuni gendaw mateng, pegwakilu tu pegbayaꞌ nu getaw. ");
INSERT INTO syb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Deksuꞌanen, petainu nilan. Laak dagid di ketelu endawen genat di kepatayu, petubuꞌenu puliꞌ.” Milegenan dayun gupia su nga sakupen ditu tinaluꞌ kia ni Isus. ");
INSERT INTO syb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Naa minundas si Isus tu Capernaum, ilan nu nga sakupen. Mendadi duuni nga getaw mendawat buis tug Balay Pengedapan tu Megbebayaꞌ, luminabet ilan dini Pedro, sinaak nilan diniin, “Naa ki mekpetuꞌun diniu kia, megbayad ma buis tu Pengedapan tu Megbebayaꞌ?” ");
INSERT INTO syb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Baa, mauma ndiꞌ?” simbag ni Pedro. Minundas dayun si Pedro ditug balay. Sikna na mitulan si Pedro, miguna mektaluꞌ si Isus, sinaaken, “Naa, Simon, alandunig delendeman mu? Saꞌ su nga gadiꞌ dinig dibabaw lumbang, taꞌ taway duni megbayad buis dinilan? Su nga sakup nilan, saꞌ kig lain getaw?” ");
INSERT INTO syb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Kaliꞌ sembag si Pedro, “Baa, ki ngag lain getaw da laak.” “Naa saꞌ maꞌantu,” laung ni Isus, “su sakup nu nga gadiꞌ, ndiꞌ ilan kambat megbayad buis dinilan. ");
INSERT INTO syb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Dagid ki mendawat buis kia, tekaw mbuus melaati ginaa nilan dinita. Saꞌ maꞌnia, alapa benggwit, angaya dayun diag linaw, tikpuꞌ mu dia sug benggwit mu. Siknaa mekelaam, pegbentayay muig dialem babaꞌ ni sedaꞌ kia, duun dayuni maitaꞌ mu kwarta, sukal dig buis ta duaꞌ tu Pengedapan. Iin dayunig buis mu dinilan.” ");
INSERT INTO syb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mendadi ndaꞌ maiben, mikpesempel dini Isus su nga sakupen, sinaak nilan diniin, “Naa Sir, ki nga sakup di Keglekaunutan nu Megbebayaꞌ, taꞌ taway duni tampusan metaasi tindegen?” ");
INSERT INTO syb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Saꞌ maꞌnia, suminabi si Isus sala tawan gembataꞌ, piꞌindegen di gedapan nilan. ");
INSERT INTO syb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Kaliꞌ pektaluꞌ si Isus, “Naa taman taluꞌu diniu, ndiꞌ amu mekesakup tu Keglekaunutan nu Megbebayaꞌ, subay megbegu betad amu, penunggilingan niu sug betad nu gembataꞌ. ");
INSERT INTO syb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Puꞌ adin su menunggiling di gembataꞌ kini, saꞌitada mekpebabaꞌ dig lawasen, iin tuꞌu ki tampusan metaas sakup di Keglekaunutan nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mukaꞌ pa padun, adin su menembaꞌ di sala tawan gembataꞌ maaꞌ ni gembataꞌ kini sabaꞌ nu kesakupen dinaan, naa gitunganen, naani mipenembaꞌen.” ");
INSERT INTO syb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Kaliꞌ pagid pektaluꞌ si Isus, “Mendadi adin su getaw mekegdaang di sala tawan gembataꞌ kini, ki mikpetuud na dinaan, naa ki mekegdaang dun kia, saꞌ pinenggiꞌ palintangan gembagel galingan dayun lemesay tug laud, tumuꞌ megaan daitu, sabayaꞌ nu ginukuman nu Megbebayaꞌ tu getaw mekegdaang di gembataꞌ kini. ");
INSERT INTO syb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mekelelaatlelaat su kelaun getaw dig dibabaw lumbang sabaꞌ nu kegdaang di getaw. Minget ndiꞌ mesuꞌat puꞌ ndaꞌiduni kegdaang, laak pia maꞌantu, ki getaw mekegdaang di samatawen, iini mekelelaatlelaat gupia! ");
INSERT INTO syb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Kaas saladuaꞌ diniu, saꞌ pegdaangan ka, ki kemet mu atawaka geksud mui mekesabaꞌ dun, naa putuk mui kemet mu kiin atawaka geksud mu, beleng mu dayun! Puꞌ tumuꞌ pa mpedumaa di ketubuꞌ ndaꞌi tamanen, pungkula, sabayaꞌ mesangkapi kemet mu mukaꞌ geksud mu, laak lebuꞌen ka tug linaw gapuy ndaꞌ nai kepalengen! ");
INSERT INTO syb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mesama da saꞌ pegdaangan ka, ki mata mu pelumi mekesabaꞌ dun, naa asak mui mata mu kiin, beleng mu dayun! Puꞌ melengas pa diniꞌa saꞌ mpedumaa tu ketubuꞌ ndaꞌi tamanen, salabuuk daig lisu mata mu, sabayaꞌ mesangkapi mata mu, laak lebuꞌen ka tug linaw gapuy.” ");
INSERT INTO syb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Laung ni Isus, “Kaas petubud amu, adun ndiꞌ niu peksudiꞌani nga gembataꞌ kini, pia sala tawan dinilan. Puꞌ taman taluꞌu diniu, saladuaꞌ dinilan, duuni sesuguꞌen nu Megbebayaꞌ getaw langit mektagikul dun. Mukaꞌ su getaw langit kia, gebii gendaw madap ditu Gamaꞌu tu gekbus langit. ");
INSERT INTO syb_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Keduaꞌen, naan kini, kig Bataꞌ nu Kilawan, iini luminusadu dun, puꞌ adun guunen ku ki nga getaw mibeleng. ");
INSERT INTO syb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Puꞌ alandunig delendeman niu? Pinenggiꞌ duuni sala tawan megatusi karnirunen, dayun mbelengi salabuuk dun. Ndiꞌen ba bilinen diag binentudan su siam puluꞌ buꞌ siam, adun penengaunen ki salabuuk kia mibeleng? Penengaunen lai! ");
INSERT INTO syb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Dayun saꞌ metuunen na, taman taluꞌu diniu, kig leliagen di salabuuk kia, gembagel pa dig leliagen ditu siam puluꞌ buꞌ siam karnirunen kia, su ndaꞌ mbeleng. ");
INSERT INTO syb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Naa, maꞌantu dadema su Gamaꞌ niu ditu gekbus langit. Iini mauyaꞌanen, ki nga gembataꞌ kini, ndaꞌiduni mbeleng dun, pia sala tawan dinilan.” ");
INSERT INTO syb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Laung ni Isus, “Saladuaꞌ diniu, saꞌ duuni samasakup mu mekesalaꞌ diniꞌa, naa laaway mu sug duma mu kia, pesuun mu diniin ki salaꞌen kia. Laak abig mu, amu duaꞌ da. Dayun saꞌ mekineeg da diniꞌa, paingalan ta dun, mipegawen mu ki samasakup mu kia. ");
INSERT INTO syb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Dagid saꞌ ndiꞌ mekineeg diniꞌa, naa laaway mu puliꞌ, tituluꞌay mu, laak pedunut mu pelumi sala tawan atawaka duaꞌ tawan, maaꞌ dadema nu sinulat ditu Taluꞌ nu Megbebayaꞌ, laung, ‘Saꞌ duuni getaw dengatenen sug dumanen, subay takesiꞌan telu tawan. Saꞌ ndiꞌ mesuꞌati telu, sukal da saꞌ duaꞌ tawan.’ ");
INSERT INTO syb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Dagid,” laung ni Isus, “saꞌ ndiꞌ dadema gusay mekineeg dinilan su samasakup mu kia, naa suknaꞌay mu pelum tu gedapan nu pikumpungan nu nga sakupu. Pidag pa tanan, saꞌ ndiꞌ pa gusay mekineeg ditu pikumpungan, naa ki getaw kia, pelepeng mu di kanaꞌ mekpetuud, atawaka di getaw mendawat buis.” ");
INSERT INTO syb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Laung padun ni Isus, “Kaas taman taluꞌu diniu, adin sug benduun niu dinig dibabaw lumbang, benduun dadema ditu gekbus langit. Adin sug buangen niu dinig dibabaw lumbang, buangen dadema ditu gekbus langit. ");
INSERT INTO syb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Mukaꞌ padun taman taluꞌu diniu, adinig duaꞌ tawan diniu senguꞌen niui penenebiin niu, naa pia alanduni penengiin niu, begay dadema nu Gamaꞌu ditu gekbus langit. ");
INSERT INTO syb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Puꞌ adinig duaꞌ tawan atawaka telu tawan mekpungun miksekat di kesakup nilan dinaan, naa naan, ditu dau dema, mungun dau dema dinilan.” ");
INSERT INTO syb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Mendadi mikpesempel dini Isus si Pedro, kaliꞌ saak diniin, “Naa Kaunutan, saꞌ duuni samasakupu menamal mekesalaꞌ dinaan, sanu deksuꞌ mai pedasun ku diniin? Sampay nga pitu deksuꞌ?” ");
INSERT INTO syb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Simbag ni Isus, “Kanaꞌ lai pitu deksuꞌ da laak. Sinangkaliꞌ saꞌ pinenggiꞌ pitu puluꞌi pitu, naa pedasun mu pa gusay. ");
INSERT INTO syb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Puꞌ su Keglekaunutan nu Megbebayaꞌ, maꞌniniig bianen. Penenggiꞌan ku duni gadiꞌ, piningilanen su nga sesuguꞌenen di nga gutang nilan diniin. ");
INSERT INTO syb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mendadi benaꞌ miningil dun su gadiꞌ, duuni sesuguꞌenen iwit diniin, aba, kanaꞌ laak sanu laksaꞌi gutangen, ");
INSERT INTO syb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ndaꞌidun pa paduni sukatanen dun. Naa saꞌ maꞌnia, sinuguꞌ sia nu gadiꞌ peksaluy ki sesuguꞌen kia adun mbaal gulipen, kampuꞌ nu sawanen mukaꞌ su kelaun bataꞌen. Sampay su gikteb gimunen, peksaluy pa pagid sia, adun elapen sia nu gadiꞌ su galinen, bayad tu gutang kia. ");
INSERT INTO syb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Dagid benaꞌ midengeg nu sesuguꞌen kinii sinuguꞌ sia nu gadiꞌ, minginlulud di gedapanen mekpekilelaat diniin, laungen, ‘Ay, Adiꞌ, kelelaat pektigela dinaan, puꞌ biadan ku daig launanen!’ ");
INSERT INTO syb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mendadi ki gadiꞌ kini, kaliꞌen medengeg, milelaat tuꞌu diniin, pituyangen su gutangen mukaꞌ biluyen su sesuguꞌenen kia. ");
INSERT INTO syb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Dagid su kepalus laak nu sesuguꞌen kia dia gadiꞌ,” laung pa ni Isus, “duuni misungkaken sala tawan sama sesuguꞌenen. Naa ki sama sesuguꞌenen kini, duun dademai gutangen diniin, megatus denario da laak. Dagid kaliꞌ maitaꞌ nu sesuguꞌen su mikautang diniin kia, piguidanen masiꞌ dig liig, lingeken sia, laungen diniin, ‘Naa, biaday mu na su gutang mu kia dinaan!’ ");
INSERT INTO syb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Miglaub dayun di gedapanen su sama sesuguꞌenen, mikpekilelaat diniin, laungen, ‘Kelelaat diniꞌa, pektigela dinaan, puꞌ biadan ku da diniꞌa!’ ");
INSERT INTO syb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Dagid kig bekna sesuguꞌen kini, ndaꞌ peliag. Palu pa mekpedasun dun, ndiꞌ na daan. Pipirisunen sungkini sama sesuguꞌenen, sampay da dun mbayaden sia su gutangen. ");
INSERT INTO syb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Naa kaliꞌ mesuunay nu ngag duma sesuguꞌen, milegenan ilan dun gupia, linaawan nilan dayun su gadiꞌ, inukit nilan diniinig launanen kia. ");
INSERT INTO syb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kaliꞌ medengeg nu gadiꞌ, sinabinen su sesuguꞌen kia, tinaluꞌen diniin, ‘Paa, melaata sesuguꞌen! Ndaꞌu ba pedesunay ki gutang mu kia, gembagel dadema gupia? Minengia laak kelelaat, pidasun ku yaꞌa dayun. ");
INSERT INTO syb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Saꞌ maꞌnia, iini bentanganen, lilaatan mu dadema sia su sama sesuguꞌen mu, puꞌ yaꞌa, lilaatan ku yaꞌa dadema.’ ");
INSERT INTO syb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Maꞌantu, mitutung gangit su gadiꞌ. Pipirisunen dayun su sesuguꞌenen kia dakus pisilutanen. Naa alandun bai keguaꞌen, subay gelaꞌenen pa biaday su tibuuk gutangen?” ");
INSERT INTO syb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Diksuꞌ ni Isus su taluꞌen, “Mendadi yamu dema, diadia maꞌantui penggulaulaan diniu nu Gamaꞌu ditu gekbus langit, saꞌ ndiꞌ niu pedesunen su salaꞌ nu nga samasakup niu di ndiꞌ megduaꞌduaꞌig delendeman niu dun.” ");
INSERT INTO syb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Naa benaꞌ mideksuꞌ ni Isus su kektituluꞌen kia, migawaꞌ dia Galilea, duminipag tu Tubig Jordan, miditu prubinsya Judea pelum. ");
INSERT INTO syb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Melaun gupia getaw migdunut diniin, pineguliꞌaneni pegladu dinilan. ");
INSERT INTO syb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mendadi, duuni nga Pariseo kuminitaꞌ dini Isus, pengimanan nilan sia iin. Suminaak dini Isus su nga Pariseo, “Naa, biwang ba dinita ditu Misulat Palinta nu Megbebayaꞌ, belengen nug laki su sawanen, pia alanduni puunanen?” ");
INSERT INTO syb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Suminuliꞌ dayun si Isus sumaak dinilan, laungen, “Baa, ndaꞌ ba niu mbasa su misulat ditu Taluꞌ nu Megbebayaꞌ puꞌ ditu pikpuunan nug launan, biwat nu Megbebayaꞌ su getaw laki mukaꞌ libun? ");
INSERT INTO syb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Mukaꞌ padun miktaluꞌ su Megbebayaꞌ, ‘Mendadi kagina maꞌantu, sug laki, suay ditu ginaꞌen buꞌ gamaꞌen, sumalabuuk na tu sawanen. Kaas su kamun duaꞌ lawas pailan, meksala lawas nailan.’ ");
INSERT INTO syb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Naa saꞌ maꞌantui pisulat nu Megbebayaꞌ, maꞌananen, sug laki mukaꞌ su sawanen, kanaꞌ nailan duaꞌ lawas, puꞌ sala lawas nailan. Su piksalabuuk nu Megbebayaꞌ, subay ndiꞌ nu kilawan pepegbelengen.” ");
INSERT INTO syb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Sinaak pelum nu nga Pariseo, “Naa saꞌ maꞌantu, taꞌ mai duuni palinta dun ni Moises puꞌ sug laki, mekpebaal pa keligenan tuꞌus dun, dayun megbeleng tug sawanen?” ");
INSERT INTO syb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Kaliꞌ sembag si Isus, “Paa, kaas ma biwang ditu palinta nu Megbebayaꞌ sinulat ni Moises, mbeleng niu su nga sawa niu, puꞌ sabaꞌ nu ketegas nu gulu niu. Laak dagid genat tu kebuat nu Megbebayaꞌ di gekleb langit buꞌ lupaꞌ, kanaꞌ maꞌnia. ");
INSERT INTO syb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kaas naan kini, iini taluꞌu diniu, adin sug laki belengenen su sawanen, asa ndaꞌ peglelingay sug libun, dayun menginsawa na puliꞌ dig lain libun sug laki, naa kiin, mikesalaꞌ dusa.” ");
INSERT INTO syb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kaliꞌ dayun pektaluꞌ su nga sakup ni Isus, “Apelai Sir, naa saꞌ maꞌniai palinta mekatag di senlangan, iini gempia, ndiꞌ menginsawai getaw.” ");
INSERT INTO syb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Kaliꞌ sembag si Isus, “Aa naa, ki teluꞌen mu kia, ndiꞌ megaga dunutay nu kelaun getaw, subay su laak tenduꞌen nu Megbebayaꞌ adun mekedunut dun. ");
INSERT INTO syb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Puꞌ duunig laki ndiꞌ mekenginsawa, sabaꞌ gasalen. Duun pelumi ndiꞌ dadema mekenginsawa, puꞌ tebiaꞌ, iningemuan nu samatawen. Mukaꞌ pa padun, duun pelumi ndiꞌ menginsawa, puꞌ adun teleduunen su gabangen tu Keglekaunutan nu Megbebayaꞌ. Kaas adin su mekegaga tu teluꞌen kini, naa gempia pedunutanen.” ");
INSERT INTO syb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Naa duuni getaw mimeguit bataꞌ nilan ditu ni Isus adun pendepenanen ilan mukaꞌ penenebianen. Laak dagid su nga sakup ni Isus, pimaag nilani nga getaw kia. ");
INSERT INTO syb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kaliꞌ pektaluꞌ si Isus, “Ki nga gembataꞌ kiin, petuyang niu ilan mangay dinaan, ndiꞌ niu belibaday. Puꞌ iin laaki mekesakup tu Keglekaunutan nu Megbebayaꞌ, su megimbataꞌ dig betaden.” ");
INSERT INTO syb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Saꞌ maꞌnia, dipenan dayun ni Isus su nga gembataꞌ kia. Mitubusen depenay, mipanaw si Isus. ");
INSERT INTO syb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mendadi duuni getaw kuminitaꞌ dini Isus, sinaaken diniin, “Sir, taꞌ alanduni gempia penggulaulaan ku, adun mpedumau tu ketubuꞌ ndaꞌi tamanen?” ");
INSERT INTO syb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Suminaak puliꞌ si Isus di getaw kia, “Baa, mauma dema saakan mau mekatag di gempia penggulaulaan? Sala Tawan da laaki mekesuun tantu. Dagid saꞌ mauyaꞌan mu mpedumaa tu ketubuꞌ ndaꞌi tamanen, iini pektalentenay mu su nga palinta.” ");
INSERT INTO syb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Sinaak ni getaw kia, “Naa, taꞌ ma palintaay dun?” Kaliꞌ sembag si Isus, “Maꞌniin ndiꞌa pekpatay, ndiꞌa pegdusa, ndiꞌa pegdaaw, ndiꞌa penakesiꞌ dig balus, ");
INSERT INTO syb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","pegbesaay mu su ginaꞌ mu buꞌ gamaꞌ mu, petail mu sug duma mu. Su kepetail mu diniin, pelepeng mu di kepetail mu dig lawas mu.” ");
INSERT INTO syb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kaliꞌ sembagig begu getaw kia, “Naa Sir, ki kelaun palinta kia, dinunutan ku. Naa saꞌ maꞌantu, alandun pai kulang dinaan?” ");
INSERT INTO syb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","“Mendadi,” laung ni Isus, “saꞌ mauyaꞌan mu mekesuun ka tantu, naa panawa na, peksaluy mu ki kelaun gimu mu, dayun pemegay mu tu nga pubri getaw su galinen. Duun dayuni gaꞌus mu ditu gekbus langit. Dayun puliꞌa dini naan, pegdunuta dinaan.” ");
INSERT INTO syb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Dagid kaliꞌ medengeg nug begu getaw ki tinaluꞌ kia ni Isus, migawaꞌ dia ni Isus, milegenan patiꞌ, puꞌ medatuꞌ gupia getaw iin. ");
INSERT INTO syb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Mendadi su kepalus nug begu getaw kia, kaliꞌ pektaluꞌ si Isus tu nga sakupen, “Taman taluꞌu diniu, ki medatuꞌ getaw, melegen tuꞌu ki kesakupen tu Keglekaunutan nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Puliꞌan ku teluꞌay diniu, melemu pa su kebian nu petubuꞌen kamelyu dig luang taiꞌ, sabayaꞌ nu kesakup nu medatuꞌ getaw tu Keglekaunutan nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Naa benaꞌ midengeg nu nga sakup ni Isus su tinaluꞌen kia, mipatiꞌ ilan mesebuꞌay dun. Laung nilan, “Saꞌ maꞌantu, Sir, duun bai megawen?” ");
INSERT INTO syb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Pingenlengan ni Isus su nga sakupen, kaliꞌ pektaluꞌ, “Ndiꞌ daan megaga nu kilawan. Dagid su Megbebayaꞌ, ndaꞌiduni ndiꞌen megaga.” ");
INSERT INTO syb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Suminambut dayun mektaluꞌ si Pedro, laungen, “Sir, yami kini, bileng na nami gupia ki kelaunanen, adun megdunut ami diniꞌa. Naa saꞌ maꞌantu, alanduni sugda dinami?” ");
INSERT INTO syb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Laung ni Isus, “Taman taluꞌu diniu, saꞌ mateng su Kebuat Puliꞌ tu gekleb langit buꞌ lupaꞌ, naan kini, kig Bataꞌ nu Kilawan, mingkud nau tuꞌu meglekaunutan, medayag na su kelengas nu pegbayaꞌu. Naa saꞌ mingkud nau meglekaunutan, yamu nu nga sepuluꞌ buꞌ duaꞌ tawan sakupu, mingkud damu dema mengukum tu nga sepuluꞌ buꞌ duaꞌ bansa nu getaw Israel. ");
INSERT INTO syb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Mukaꞌ adini getaw belengenen sug balayen, saꞌ su nga pateden libun laki, ginaꞌen saꞌ gamaꞌen, ngag bataꞌen sampay sug lupaꞌen, sabaꞌ nu kesakupen dinaan, naa sugdaan megatus piluꞌ, mukaꞌ mpeduma pa pagid tu ketubuꞌ ndaꞌi tamanen. ");
INSERT INTO syb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Laak dagid melaun getawi mauna nemun, iini mbinayaꞌ saꞌ matengi gendaw kiin ditug binayaꞌ gebii buꞌ gendaw. Melaun dadema getaw mbinayaꞌ nemun, iin na sungkini mbaluy muna saꞌ matengi gendaw kiin.” ");
INSERT INTO syb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kaliꞌ pektaluꞌ si Isus, “Mendadi saꞌ meglekaunutan na tuꞌu su Megbebayaꞌ, maꞌniniꞌig bianen. Petanggiꞌu di getaw meliwagig lupaꞌen, milapus mpanaw, puꞌ menengaw tindananen mengimbaal dia pegimulananen gubas. ");
INSERT INTO syb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mendadi benaꞌ mibaangan nu gapuꞌ lupaꞌi nga tindananen, mikpasad ilan, iini tindan dinilan ki sendaw, sala denario, iinig lagaꞌen ki sendaw di timpu kitu. Naa saꞌ maꞌantu, sinuguꞌen dayun ilan mangay mengimbaal dia pegimulananen kia. ");
INSERT INTO syb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Mendadi benaꞌ miginengaꞌ menaiki gendaw, mipanaw puliꞌ su gapuꞌ lupaꞌ, minangay puliꞌ tu tebuꞌan. Duuni nga getaw minitaꞌen pemegindeg laak dia, ndaꞌig baalen nilan. ");
INSERT INTO syb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Tinaluꞌen dinilan, ‘Naa yamu pagid, angay amu dema pengimbaal ditu pegimulanan ku. Dayun ki tindan diniu, peksemaan ku di kengimbaal niu.’ ");
INSERT INTO syb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Saꞌ maꞌnia, mipanaw ilan dema. Naa iin nai migbatag ia, saꞌ miktui gendaw mukaꞌ ginengaꞌ menaugi gendaw, maꞌantu da gusayi pinggulaula ni gapuꞌ lupaꞌ kia. ");
INSERT INTO syb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Benaꞌ sungu na mesindepi gendaw, mipanaw na puliꞌ ditu tebuꞌan. Duun pa gusayi nga getaw pemegindeg dia. Sinaakanen ilan dayun, laungen, ‘Mauma iin sendaw amu gupia dini, ndaꞌig baalen niu?’ ");
INSERT INTO syb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Kaliꞌ ilan sembag, ‘Waꞌa, puꞌ ndaꞌiduni tumindan dinami.’ Laung dayun nu gapuꞌ lupaꞌ, ‘Naa saꞌ maꞌantu, angay amu pengimbaal ditu pegimulanan ku.’” ");
INSERT INTO syb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Laung pa ni Isus, “Mendadi benaꞌ misindep nai gendaw, miktaluꞌ su gapuꞌ lupaꞌ ditu kapatasen, ‘Naa, sabi mu su nga tinindanan, tindanay mu ilan. Laak iini pauna mu tindanay, su mibinayaꞌ mengimbaal. Dayun mu tindanay su ngag duma, sampay su miuna mengimbaal, iini binayaꞌ mu tindanay.’ ");
INSERT INTO syb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Naa su nga getaw mikpuun mengimbaal saꞌ sungu na mesindepi gendaw, iini tindan dinilan, piksala denario. ");
INSERT INTO syb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mendadi su nga miuna mekpuun mengimbaal, saꞌ ilan pelumi minangay mekpetindan, laung nilan dun melaun siaig danilan tindan. Dagid su da daan masiꞌ, piksala denario da gusayi tindan dinilan. ");
INSERT INTO syb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kaliꞌ nilan medawat su kwarta nilan, pigbensi nilan su gegalen nilan kia. ");
INSERT INTO syb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Laung nilan, ‘Paa, ki nga tampusan binayaꞌ kia, mingimbaal laak sauras da! Yami dagid, sendaw ami gupia miktigel mengimbaal, mesait pedes pa padun! Kaas mauma ki tindan dinilan, pisama mu da gusay di tindan dinami?’ ");
INSERT INTO syb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Dagid kaliꞌ pektaluꞌ su gapuꞌ lupaꞌ di sala tawan dinilan, ‘Aba, lai, ndaꞌu yaꞌa limbungay. Puꞌ iini pegdelendem mu, sinanguꞌ mu su tindan sendaw, sala denario. ");
INSERT INTO syb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kaas alap mu ki tindan mu kini, uliꞌa dayun. Puꞌ iini mauyaꞌan ku, peksemaan ku su tindan diniꞌa mukaꞌ su tindan tu mibinayaꞌ mengimbaal. ");
INSERT INTO syb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ki kwartau kia, kanaꞌ ba naani megbayaꞌ dun? Naa saꞌ metawalu, mauma mingimbegua dun?’” ");
INSERT INTO syb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Diksuꞌ ni Isus su taluꞌen, “Kaas ki nga getaw mbinayaꞌ nemun, iini mbaluy mauna di gendaw kiin ditug binayaꞌ gebii buꞌ gendaw. Ki nga getaw mauna nemun, iin na sungkini mbinayaꞌ di gendaw kiin.” ");
INSERT INTO syb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Naa maꞌantu, pektuad si nga Isus tu Jerusalem. Mendadi sinegay nilan mpanaw, sinabi ni Isus su sepuluꞌ buꞌ duaꞌ tawan sakupen. Kaliꞌ pektaluꞌ si Isus dinilan, ");
INSERT INTO syb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Naa, pektalentenay niu gupia ini. Kini, tuad naita tuꞌu di Jerusalem. Mendadi saꞌ mateng ita dia, naan kini, kig Bataꞌ nu Kilawan, pegwakilu tu nga kaunutan nug belian nu getaw Judea mukaꞌ tu nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ. Ukumanu dayun nilan lagaꞌ na ginau, ");
INSERT INTO syb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","mukaꞌ pegwakilu nilan tu nga kanaꞌ getaw Judea, pengimusaunganu nilan mukaꞌ bedasenu nilan. Dayunu lensangay di kurus. Laak dagid di ketelu endawen genat di kepatayu, petubuꞌenu puliꞌ.” ");
INSERT INTO syb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Naa duunig libun, sawa ni Sebedeo, minadap dini Isus, ilan nug duaꞌ tawan bataꞌen si Santiago kiin mukaꞌ si Juan. Minginlulud dayun di gedapan ni Isus sug libun, puꞌ duuni ubugenen diniin. ");
INSERT INTO syb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Mendadi sinaak ni Isus tug libun, “Alandun mai penengiin mu baalen ku diniꞌa?” Kaliꞌ sembag, “Naa Sir, saꞌ mingkuda na tuꞌu meglekaunutan, naa iin siai penengiin ku diniꞌa, kig duaꞌ tawan bataꞌu kini, naa paingkuden mu ilan ditu gupid mu. Su sala tawan, diin dapit lintu mu, su sala tawan pelum, diin dapit bibang mu.” ");
INSERT INTO syb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Liningay dayun ni Isus kig duaꞌ tawan mekpated, bataꞌ nig libun kia, kaliꞌ sembag dinilan, “Baa, ndaꞌ niu mesuunay ki inubug niu kiin. Taꞌ itu, megaga ba niu minum di tasa mipenuꞌ kelegenay, ki sunguun ku na inumay?” “Waꞌa, Sir,” laung nilan, “megaga da nami.” ");
INSERT INTO syb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Laung ni Isus, “Naa metuud, ki tasa ginuman ku, mekainum amu dun daan tuꞌu. Laak dagid pia maꞌantu, ndaꞌi pegbayaꞌu memiliꞌ tu getaw mingkud di gupidu, diin dapit lintuu mukaꞌ di dapit bibangu. Puꞌ iin da laaki mekesaing dinaan, adin su gandang mitenduꞌ nu Gamaꞌu.” ");
INSERT INTO syb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Naa su nga sepuluꞌ tawan samasakup nilan dini Isus, benaꞌ midengeg nilan ki inubug kia nu ginaꞌ ni Santiago mukaꞌ ni Juan puꞌ ilan siai sumaing dini Isus saꞌ meglekaunutan, lingetan ilan dun. ");
INSERT INTO syb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mendadi, sinabi ni Isusi kelaun sakupen kia, kaliꞌ pektaluꞌ dinilan, “Naa su nga kanaꞌ getaw Judea, misuunan niu puꞌ gembegati kegbayaꞌ dinilan nu kaunutan nilan. Mukaꞌ su ngag begelal nilan, metegas demai keguit nilan tu nga sakup nilan. ");
INSERT INTO syb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Dagid yamu, ndiꞌ amu mpia mengmaꞌantu. Sinangkaliꞌ adin diniui mauyaꞌanen sia metaasi tindegen, subay iin nai mbaal sesuguꞌen niu. ");
INSERT INTO syb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kaas adini mauyaꞌanen sia puꞌ iini tampusan metaasi tindegen dig launan niu, subay iin nai mbaal maaꞌ nu gulipen niu. ");
INSERT INTO syb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Puꞌ pia pa naan kini, kig Bataꞌ nu Kilawan, kanaꞌ iini luminusadu dun dinig lumbang, puꞌ adun duuni megabang dinaan. Segaga iin sungkini ginangayu medini, puꞌ adun ebangan ku su kilawan, sampay petainu, puꞌ adun lekaten ku su melaun getaw.” ");
INSERT INTO syb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Naa saꞌ minundas pelum si nga Isus genat dia Jerico, melaun gupia getaw mimegdunut dinilan. ");
INSERT INTO syb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Naa saꞌ mipalus ilan dig lunsud kia, duunig duaꞌ tawan buta pegingkud dia geksid dalan. Mendadi benaꞌ midengeg nug buta puꞌ megbian dia si Isus, migbeksay ilan dayun, laung nilan, “Uu Sir, Sapuꞌa ni David, lelaatay mu ami!” ");
INSERT INTO syb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kig buta kia, pigbeluꞌan dayun nu melaun getaw, pimaag nilan sia. Laak palu pa mpemaag, ndiꞌ, minamal ilan mektawag, laung nilan, “Uu Sir, Sapuꞌa ni David, lelaatay mu ami dema tuꞌu!” ");
INSERT INTO syb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tuminlen dayun si Isus, sinabinen su ngag buta kia. Sinaak ni Isus, “Taꞌi penengiin niu dinaan?” ");
INSERT INTO syb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“Sir, liagan nami sia, mekengitaꞌ nami!” ");
INSERT INTO syb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Milelaat si Isus dinilan, dipenanen dayun ki mata nilan. Lemen laak ilan dipenan ni Isus, mikengitaꞌ na tuꞌu sug duaꞌ tawan buta. Mukaꞌ tumindug ilan dini Isus tug dalan. ");
INSERT INTO syb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Mendadi, minundas na tuꞌu ditu Jerusalem si nga Isus. Benaꞌ mesempel nailan dia, misebang ilan dig lunsud piningalan dun Betpahe, dia guksad nug Bentud nu nga Gayu Olibo, suminuguꞌ si Isus dig duaꞌ tawan sakupen. ");
INSERT INTO syb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Laungen dinilan, “Bundas amu diag lunsud kia dia gunaan. Mendadi saꞌ mateng amu ditu, duun dayuni maitaꞌ niu petubuꞌen asno iniketan, dakus duuni natinen. Naa kiin, ubaday niu, agak niu dayun dini naan. ");
INSERT INTO syb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Naa saꞌ duuni sumaak diniu, taluꞌ niu diniin, ‘Duunig baalan dun nu Kaunutan.’ Begayen dayun diniu.” ");
INSERT INTO syb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kaas maꞌniai mipenggulaula, puꞌ adun menuud su sinulat dengantu nu pimuunan nu Megbebayaꞌ ditu Misulat Taluꞌen, laungen, ");
INSERT INTO syb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Teluꞌay niu su nga getaw Sion, Bentayay pa daan niu, pegdateng na ki gadiꞌ niu! Iin, mekpebabaꞌ dig lawasen, peksakay laak asno. Laak kanaꞌ pa asno, nati laak.” ");
INSERT INTO syb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Naa saꞌ maꞌantu, mipanaw sug duaꞌ tawan sakup ni Isus, pituud nilan su suguꞌanen dinilan. ");
INSERT INTO syb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Inagak nilan ditu ni Isus sug asno, dakus su natinen. Mendadi benaꞌ minateng ilan dia ni Isus, inigan nilan suub nilan sug lekud nu ngag asno. Suminakay dayun si Isus ditu nati. ");
INSERT INTO syb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mukaꞌ melaun getaw mimelat suub nilan dia karsada mbianan ni Isus, basa nilan diniin. Sug duma pelum, minalap panga gayu daunan, inikam nilan dadema dia karsada. ");
INSERT INTO syb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mendadi su nga melaun getaw mpanaw di gunaan ni Isus, mesama di nga getaw peglendug dig binayaꞌen, mimeksay ilan, laung nilan, “Pegbesaan ki Sapuꞌ ni David kini! Melengas pepianan iin nu Megbebayaꞌ, ki minateng na pigwekilan nu Kaunutan Megbebayaꞌ! Pegbesaan dadema su Megbebayaꞌ ditu gekbus langit!” ");
INSERT INTO syb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Naa benaꞌ minateng na tuꞌu di Jerusalem si Isus, misasawi ginaa nu kelaun getaw dia. Kaliꞌ ilan peksinaakay, “Taꞌi gasalen iin?” ");
INSERT INTO syb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Simbag nu melaun getaw kia mimegdunut dini Isus, “Kini si Isus, pimuunan nu Megbebayaꞌ, getaw Nazaret, sakup Galilea.” ");
INSERT INTO syb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Naa minangay si Isus tu Pengedapan tu Megbebayaꞌ. Mendadi benaꞌ minateng dia, ki kelaun mendagang guliden mukaꞌ su nga menaluy dia, pingutidanen. Pimbelikwangen pa pagid su ngag lemisaan nu nga membeles selapiꞌ, sampay su nga gingkudan nu nga mendagang malepati, guliden tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Miktaluꞌ si Isus dinilan, “Misulat ditu Taluꞌ nu Megbebayaꞌ, ‘Ki Pengedapan dinaan, iini paingalan dun, balay penenebian.’ Dagid yamu kiin, binaal niu pegegludan ngag limbungan getaw ki Pengedapan kini!” ");
INSERT INTO syb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mendadi saanan ni Isus dia Pengedapan, miditu niin su ngag buta dakus su nga pilung, pineguliꞌanen ilan dayun. ");
INSERT INTO syb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Dagid ki nga kaunutan nug belian nu getaw Judea mukaꞌ ki nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, minitaꞌ nilan ki mekesalebuꞌ pinggulaula kia ni Isus dakus nga gembataꞌ memeksay, laung nilan, “Pegbesaan ki Sapuꞌ ni David!” Sabaꞌ minitaꞌ nu nga kaunutan kini, milaat dayuni ginaa nilan dini Isus. ");
INSERT INTO syb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Sinaak nilan diniin, “Baa, midengeg mu da su pekteluꞌen nu nga gembataꞌ kiin?” “Midengegu lai,” simbag ni Isus. “Mendadi, ndaꞌ ba niu mbasa ki misulat ditu Taluꞌ nu Megbebayaꞌ kini? Iini misulat dun, ‘Uu Megbebayaꞌ, piktuꞌunan mu megenal diniꞌa su nga gembataꞌ, sampay su nga pegduduꞌ pa.’” ");
INSERT INTO syb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Bilengan dayun ni Isus ki nga kaunutan kia, migawaꞌ na puliꞌ dia Jerusalem, mipuliꞌ pa ditug lunsud Betania, minangay pa mengintulugan dia. ");
INSERT INTO syb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Naa benaꞌ miksala gendaw, milapus si Isus mpuliꞌ dia Jerusalem. Saananen diag dalan, migutem si Isus. ");
INSERT INTO syb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kaliꞌ megutem, duuni minitaꞌen dia geksid dalan sala puun gayu igera. Linaawan dayun ni Isusi gayu kia, laak kaliꞌ pekpesempel dun, lumbus laak masiꞌ daun kig igera kia. Miktaluꞌ dayun si Isus tu gayu, laungen, “Genat nandaw, ndaꞌidun na puliꞌig bunga mu!” Lemen laak mitaluꞌ ni Isus, milanes dayun su gayu igera. ");
INSERT INTO syb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Naa mendadi su nga sakup ni Isus, benaꞌ minitaꞌ nilani gayu igera kia, mipatiꞌ ilan mesebuꞌay, laung nilan, “Apelai, mikendutaꞌi gayu kini, mitekaw pelum melanes?” ");
INSERT INTO syb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Simbag ni Isus dinilan, “Taman taluꞌu diniu, saꞌ sumalig amu mukaꞌ kanaꞌ megduaꞌduaꞌi kesalig niu, naa mpenunggilingan dadema niu ki pinggulaulau dig igera kini. Pidag pa tanan, pia pa mektaluꞌ amu dig bentud kinuꞌ, ‘Mainata, peksilabuꞌa tug dagat,’ naa kiin, menuud dema tuꞌu. ");
INSERT INTO syb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mendadi pia alanduni penenebiin niu, malap niu, saꞌ sumalig amu.” ");
INSERT INTO syb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Naa mipuliꞌ si Isus tu Pengedapan tu Megbebayaꞌ, sumiled dayun dia. Mendadi saꞌ mikpetuꞌun si Isus, ki nga kaunutan nug belian nu getaw Judea mukaꞌ su ngag duma kaunutan nilan, minadap ilan diniin. Sinaak nilan diniin, “Paa, ki pinggulaula mu kini, taꞌ bai pegbayaꞌ mu menggulaula dun? Taꞌ taway dun bai migbegay diniꞌa pegbayaꞌ penggulaulaan mu?” ");
INSERT INTO syb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Laung pelum ni Isus dinilan, “Naa, saakan ku amu deliꞌ sektaang. Dayun saꞌ mesembag na niu, pesuun ku dadema diniu su pigenatan nu pegbayaꞌu penggulaulaan kui maꞌnini kini. ");
INSERT INTO syb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Iini sembag niu dinaan, si Juan kiin, adin genat su pegbayaꞌen memunag tubig tu nga getaw? Genat tu Megbebayaꞌ, saꞌ genat ba laak di kilawan?” Naa saꞌ maꞌnia, migyagayaga dayuni nga kaunutan kia, laung nilan, “Naa, taꞌ ma? Saꞌ pinenggiꞌ sembagen ta, ‘Su pegbayaꞌ ni Juan, genat tu Megbebayaꞌ,’ naa sumumpat dayun si Isus kini, ‘Saꞌ maꞌantu, mauma dema ndaꞌ niu petuuday si Juan?’ ");
INSERT INTO syb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Saꞌ sembagen ta pasiꞌ, ‘Genat laak di kilawan,’ mendek ita tu nga getaw, puꞌ su kelaun getaw, mituudan ilan dun puꞌ pimuunan nu Megbebayaꞌ si Juan.” ");
INSERT INTO syb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kaas iin laaki mesembag nilan dini Isus, “Ndaꞌ nami mesuunay.” Laung dayun ni Isus dinilan, “Naa saꞌ maꞌantu, ndiꞌu dadema pesuun diniu saꞌ taꞌi pigenatan nu pegbayaꞌu penggulaulaan kui maꞌnini kini.” ");
INSERT INTO syb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Sinumpatan pa gusay ni Isus su taluꞌen di nga kaunutan kia, laungen, “Alandun ma demaig delendeman niu dun kini? Duuni getaw, duaꞌ tawanig bataꞌen. Mendadi duuni gendaw, linaawan nu getaw kini sug bataꞌen gulangbataꞌ, laungen, ‘Naung, angaya nandaw mengimbaal ditu pegimulanan ta gubas.’ ");
INSERT INTO syb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Dagid kig bataꞌen kini, kaliꞌ sembag, ‘Baa, mpauku.’ Laak benaꞌ ndaꞌ maiben, migilengig delendemanen, minangay da dayun mengimbaal ditu. ");
INSERT INTO syb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Dayun su gamaꞌen kia, linaawanen pelum kig bataꞌen kia ngudan, maꞌnia dademai sinuguꞌen diniin. Naa ki ngudan kini, kaliꞌ sembag, ‘Naa waꞌa, Amaꞌ.’ Asa iin, ndaꞌ da angay ditu mengimbaal. ");
INSERT INTO syb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Naa saꞌ maꞌnia, kig duaꞌ tawan kia, adin ma su mikpetuud tu suguꞌan nu gamaꞌen?” “Baa,” simbag nilan, “su da gulangbataꞌ.” Kaliꞌ dayun pektaluꞌ si Isus di nga kaunutan nu getaw Judea kia, “Taman taluꞌu diniu, su nga mendawat buis mukaꞌ tebiaꞌ, su ngag libun meglaat pekesuunan, mauna ilan diniu sumakup tu Keglekaunutan nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Puꞌ si Juan kiin Memunag Tubig, mituaꞌ mekpenuluꞌ diniu tug dalan tu tantu kekesuun, dagid ndaꞌ niu iin petuuday. Asa su nga mendawat buis mukaꞌ ngag libun meglaat pekesuunan, mikpetuud ilan dini Juan. Dagid yamu kiin, pia pa minitaꞌ niu puꞌ mikpetuud ilan diniin, naa ndaꞌ amu gusay peksikesuun, ndaꞌ niu petuuday si Juan.” ");
INSERT INTO syb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Kaliꞌ gusay pektaluꞌ si Isus di nga getaw Judea kia, “Kineegay niu ki salabuuk sambingay. Duuni getaw meliwagig lupaꞌen, migimula pegimulanan gubas. Benaꞌ mitubusen pemulanay, binaliten dayuni pegimulananen, migengkul seludan tu nga tubig nu gubas saꞌ intesenen, mukaꞌ migbaal pa pagid metaas pegelungan dun. Saꞌ mitubus, pisaꞌupen di nga getawi pegimulananen kia, dayun mipanaw dig lain benwa. ");
INSERT INTO syb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Mendadi benaꞌ sungu na sungkuꞌ su pegimulanan, suminuguꞌ su gapuꞌen di nga sesuguꞌenen meditu nga saꞌup, puꞌ adun elapen nilan sug daniin gilas. ");
INSERT INTO syb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Laak dagid kaliꞌ dateng ditu su nga sinuguꞌ, aba, ginapus nu nga saꞌup. Sala tawan sesuguꞌen, binadas nilan. Sala tawan pelum, binunuꞌ nilan. Sala tawan pa pagid, binatu nilan. ");
INSERT INTO syb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Naa suminuguꞌ na pelum su gapuꞌ nu pegimulanan di nga sesuguꞌenen, melaun pailan pelum. Benaꞌ minateng ditu su nga sinuguꞌ, maꞌantu da gusayi pinggulaula dinilan nu nga saꞌup. ");
INSERT INTO syb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Mendadi tigaꞌwan, iin na sungkini sinuguꞌ nu gapuꞌ nu pegimulanan mangay tu nga saꞌup, ki na bataꞌen. Puꞌ maaꞌ laungen pa dig dialem delendemanen, ‘Tumuꞌ saꞌ kig bataꞌu na kini, pegbesaan nilan iin.’ ");
INSERT INTO syb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Laak dagid saꞌ midayag na nu nga saꞌup sug bataꞌen kia, miksabutsabut ilan dayun, laung nilan, ‘Aa naa, kiin na tuꞌu sug bataꞌ nu gapuꞌ nu pegimulanan kini. Tala, tumuꞌ petain tain, adun danita na su petenged sia diniin!’ ");
INSERT INTO syb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Mendadi benaꞌ minateng dia nilan kig bataꞌ kini nu gapuꞌ nu pegimulanan, inukpaꞌan nilan, piniglak nilan tug liu nu pegimulanan, pinatay nilan tuꞌu. ");
INSERT INTO syb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Naa saꞌ maꞌnia,” sinaak ni Isus, “saꞌ mateng su gapuꞌ nu pegimulanan gubas, alandun ma dayuni penggulaulaanen di nga saꞌup kini?” ");
INSERT INTO syb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Kaliꞌ ilan sembag, “Baa, pemunuꞌenen ilan la tuꞌu! Melaatig betad nilan, melaat dademai palas nu kepatay nilan. Dayun lain getaw na pelumi pesaꞌupen tu pegimulananen kia, adin su meseligan megbegay diniin gilasen saꞌ sungkuꞌ na su pegimulanan.” ");
INSERT INTO syb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","“Waꞌa daan,” simbag ni Isus. “Puꞌ ndaꞌ ba niu mbasa su sinulat ditu Misulat Taluꞌ nu Megbebayaꞌ, maꞌniniꞌ? ‘Kig batu pimilas nu nga megbaal balay, iini mibaal tampusan gempagen gintudan nug balay. Puꞌ kiin, pigbaal nu Kaunutan Megbebayaꞌ, kaas leliagen ita dun gupia!’” ");
INSERT INTO syb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Pidayun gusay ni Isus su taluꞌen di nga kaunutan nu getaw Judea kia, laungen, “Kaas taman taluꞌu diniu, iini puunanen, uiꞌen diniu su kesakup niu tu Keglekaunutan nu Megbebayaꞌ, begay sungkin dig lain bansa nu getaw, ki megbegay diniin gempia sengkuꞌ. ");
INSERT INTO syb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Naa kig batu kini, adin getawi medapal dun, mbeliꞌan patiꞌ. Saꞌ pasiꞌ melabuꞌ kig batu kini, adin su metenaꞌanen, melasak tananig lawasen.” ");
INSERT INTO syb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Naa ki nga kaunutan nug belian nu getaw Judea mukaꞌ su nga Pariseo, benaꞌ midengeg nilan su nga sinambingay kia ni Isus, misimaꞌ nilan puꞌ ilani pisugaten dun. ");
INSERT INTO syb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kaas pidaap nilan sia si Isus, laak mindek ilan ditu nga getaw, puꞌ su melaun getaw, mituudan ilan dun puꞌ pimuunan nu Megbebayaꞌ si Isus. ");
INSERT INTO syb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Naa miksambingay pa gusay si Isus tu nga getaw, laungen, ");
INSERT INTO syb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Mendadi saꞌ meglekaunutan na tuꞌu su Megbebayaꞌ, maꞌniniꞌig bianen. Petanggiꞌu di gadiꞌ miglekebibu, puꞌ beliꞌiin sug bataꞌen. ");
INSERT INTO syb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Mendadi benaꞌ sungu na megdeksuꞌ sug belaꞌi, suminuguꞌ ki gadiꞌ kini di nga sesuguꞌenen meksabi tu nga getaw pisebutanen, adun sumaup nailan ditug belaꞌi. Laak dagid ki nga ginggaten sumaup kini, mpauk ilan masiꞌ sumaup. ");
INSERT INTO syb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Naa saꞌ maꞌantu, suminuguꞌ su gadiꞌ di ngag duma sesuguꞌenen, pimuunen tu nga ginggaten kia, ‘Minuyaꞌ nai gilak. Tinitiꞌu na su ngag bakau, sampay su pilembuꞌu nati, mukaꞌ minuyaꞌ naig launanen. Kaas saup namu dinig belaꞌi kini!’ ");
INSERT INTO syb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Laak dagid su nga ginggat sia sumaup kia, maꞌniin ndaꞌ nilan medengeg, mipanaw laak ilan sungkin. Sala tawan, minangay tug binaalanen. Sala tawan pelum, minangay tu tindanen. ");
INSERT INTO syb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Sug duma pelum, inukpaꞌan nilani nga sesuguꞌen kia nu gadiꞌ, dayun piksudawan nilan patiꞌ. Deksuꞌanen, binunuꞌ nilan. ");
INSERT INTO syb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mendadi ki gadiꞌ kini, mitutung dayun gangiten. Sinuguꞌen meditu su nga sundalunen, adun bunuꞌen nilan su nga minunuꞌ tu sesuguꞌenen kia mukaꞌ sensulan nilan sug lunsud nilan. ");
INSERT INTO syb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Naa benaꞌ mitubus, suminabi pa su gadiꞌ di nga sesuguꞌenen, kaliꞌ pektaluꞌ dinilan, ‘Naa kini, minuyaꞌ naig belaꞌi. Laak dagid su nga getaw inggatu sia, kanaꞌ ilan mbantang sumaup dun. ");
INSERT INTO syb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kaas peditu namu karsada mbianan nu melaun getaw, dayun adin su taman getaw maitaꞌ niu, enggat niu ilan gelaꞌ.’ ");
INSERT INTO syb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Naa saꞌ maꞌantu, miditu gembagel karsada su nga sesuguꞌen kia nu gadiꞌ, pinungun nilan dayun ki nga getaw, su mekesuun saꞌ su medupang, adin su taman mitaangan nilan. Dekag pa gembibu ilan diag balay pemeliꞌian. ");
INSERT INTO syb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Laak dagid su gadiꞌ, benaꞌ minangay madap tu nga suminaup tug belaꞌi, duuni minitaꞌen sala tawan, ndaꞌ masiꞌ pekseluk pekayan dig belaꞌi. ");
INSERT INTO syb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Sinaakan nu gadiꞌ ki getaw kini, ‘Baa lai, mauma ndiꞌa mpiid suled dini, ndaꞌ mu selukay su penepeten nu sumaup tug belaꞌi?’ Ndaꞌ kesembag ki getaw kini. ");
INSERT INTO syb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Liningay dayun nu gadiꞌi nga sesuguꞌenen kia, kaliꞌ pektaluꞌ dinilan, ‘Naa, balud niui getaw kia, kampuꞌ nu geksuden, dayun niu piglak tug liu, ditu medelem. Ditu dayun mengaduy, lamugen mengkiget di ngisinen.’” ");
INSERT INTO syb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Diksuꞌ ni Isus su taluꞌen, laungen, “Kaas melaun siai getaw enggaten sumakup, laak dagid meliangi tinduꞌ nu Megbebayaꞌ sakupen.” ");
INSERT INTO syb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Naa ki nga Pariseo, minawaꞌ ilan dia, dayun mikpungun ilan, minengaw ilan bian nilan mengiman dini Isus di teluꞌenen. ");
INSERT INTO syb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Mendadi duuni nga sakup nilan mukaꞌ nga sakup ni Herodes sinuguꞌ nilan mangay ditu ni Isus. Benaꞌ minadap dini Isus su nga sinuguꞌ kia, tautau ilan suminaak diniin, “Naa Sir, misuunan nami puꞌ pektuꞌun mu su metuud. Ndaiꞌ pegisuun mu tu tindeg nu getaw, kaas ndiꞌa mpesuay di metuud, pektuꞌun mu gusay su tantu mauyaꞌan nu Megbebayaꞌ pegbetaden nu getaw. ");
INSERT INTO syb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Naa saꞌ maꞌantu, iini taluꞌ mu dinami, ki megbuis ditu tampusan gadiꞌ si Cesar, alandunig delendeman mu dun? Biwang ba ditu Misulat Palinta nu Megbebayaꞌ, saꞌ ndaꞌ?” ");
INSERT INTO syb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Laak dagid misuunan ni Isus puꞌ iini puun nu kesaak nilan diniin kia, su melaat delendeman nilan. Kaas laungen dinilan, “Baa, yamu kiin nu nga tautau mekesuun! Mauma pengimanan ma niau? ");
INSERT INTO syb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Paitaꞌ niu deliꞌ dinaan selapiꞌ bayad dig buis kia!” Tinulunan nilan dayun si Isus selapiꞌ. ");
INSERT INTO syb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Sinaak dayun ni Isus dinilan, “Naa, taꞌ taway dun baig lingaw kini? Taꞌ ngalan dun bai misulat dadema dini kini?” ");
INSERT INTO syb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Laung nilan, “Dani Cesar.” Kaliꞌ pektaluꞌ si Isus, “Naa saꞌ maꞌantu, kig dani Cesar, bayad da niu diniin. Dagid sug danu Megbebayaꞌ, begay da niu dema ditu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Naa benaꞌ midengeg nu nga sinuguꞌ nu Pariseo kia su simbag ni Isus, misebuꞌan ilan dun. Bilengan nilan si Isus, migawaꞌ ilan dia. ");
INSERT INTO syb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Naa benaꞌ su gendaw kia, duuni nga Saduseo mituaꞌ ditu ni Isus. Naa ki nga Saduseo kini, ilani sala pikumpungan ndiꞌ ilan metuudan dun puꞌ su nga minatay, metubuꞌ puliꞌ. ");
INSERT INTO syb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Mendadi, kaliꞌ pembaalbaal sumaak dini Isus ki nga Saduseo, “Naa Sir, duuni palinta pisulat nu Megbebayaꞌ dini Moises, ‘Saꞌ daw matayig laki, laak ndaꞌidunig bataꞌen, naa subay sukliin nu pated nu minatay. Iini menginsawa tug balulibun, adun duunig bataꞌ nilan, lepeng bataꞌ nu minatay kitu.’ ");
INSERT INTO syb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mendadi, duuni pitu tawan dinami mekpated. Minginsawa su gulangbataꞌ dayun minatay, ndaꞌidun paig bataꞌen, kaas sug balu, sinukli penginsuaay nu medapit ditu minatay. ");
INSERT INTO syb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Dayun su keduaꞌ pateden pelum, maꞌantu dadema, dakus su ketelu pateden. Iin nai migbatag ia, gikteb nu pitu tawan kia. ");
INSERT INTO syb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tigaꞌwan sug libun, minatay dadema. ");
INSERT INTO syb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Naa paladpalad saꞌ duun siai metubuꞌ daw puliꞌ genat matay, naa kig libun kia, adin ma dayuni sawanen ditu pitu tawan kia, kagina migelaꞌ ma mayan mpenginsawa nu mekpated kia?” ");
INSERT INTO syb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Laak dagid kaliꞌ sembag si Isus, “Baa, gembagel gupiaig lapang niu! Puꞌ ndaꞌ niu mesabut su Misulat Taluꞌ nu Megbebayaꞌ, sampay ndaꞌ niu dadema mesabut su gikteb nu ginuung nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Puꞌ saꞌ metubuꞌ na puliꞌ su nga minatay, ndiꞌ nailan meksenlangan, segaga mesama ilan ditu nga sesuguꞌen nu Megbebayaꞌ getaw langit. ");
INSERT INTO syb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mukaꞌ padun, petubuꞌen daan puliꞌ tuꞌu su nga minatay, puꞌ ndaꞌ ba niu mbasa ki tinaluꞌ nu Megbebayaꞌ diniu, maꞌniniꞌ? Maaꞌ laung nu Megbebayaꞌ, ");
INSERT INTO syb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Naani Megbebayaꞌ pektemuyen ni Abraham, pektemuyen ni Isaac, mukaꞌ ni Jacob.’” Kaliꞌ gusay pektaluꞌ si Isus, “Naa misuunan ta, iini mektamuy tu Megbebayaꞌ su getaw tetubuꞌ, kanaꞌ nu nga minatay.” ");
INSERT INTO syb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Naa benaꞌ midengeg nu nga melaun getaw ki pituꞌun kia ni Isus, misebuꞌan ilan dun gupia. ");
INSERT INTO syb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Naa su nga Pariseo, benaꞌ misuunan nilan puꞌ midempek ni Isus su nga Saduseo, mikpungun ilan puliꞌ. ");
INSERT INTO syb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Mendadi, duuni sala tawan dinilan mekpetuꞌun di Misulat Palinta mikpesempel dini Isus, puꞌ adun pengimanenen sia su metaluꞌen. ");
INSERT INTO syb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Suminaak dini Isus su mekpetuꞌun, “Naa Sir, taꞌ palintaay duni tampusan metaas ditu Misulat Palinta nu Megbebayaꞌ?” ");
INSERT INTO syb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Kaliꞌ sembag si Isus, “‘Kini. Saladuaꞌ diniu, petail mu tantu su Kaunutan mu Megbebayaꞌ, saꞌitada pegwakil mu diniin su tibuuk ginaa mu mukaꞌ su tibuuk gimuud mu, dakus su tibuuk delendeman mu.’ ");
INSERT INTO syb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kinii tampusan metaas palinta. ");
INSERT INTO syb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mukaꞌ dumanen dadema ki keduaꞌ metaas palinta kini. ‘Petail mu dadema sug duma mu. Su kepetail mu diniin, pelepeng mu di kepetail mu dig lawas mu.’” ");
INSERT INTO syb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kaliꞌ pagid pektaluꞌ si Isus, “Kig duaꞌ buuk palinta kini, iini pikumpungan nu tibuuk Palinta nu Megbebayaꞌ pisulaten dini Moises mukaꞌ tu ngag duma pimuunanen dengantu.” ");
INSERT INTO syb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Naa benaꞌ mikpungun ki nga Pariseo, sinaak ni Isus dinilan, ");
INSERT INTO syb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Naa ki gasal nu Tinduꞌ nu Megbebayaꞌ Meglekaunutan, alandunig delendeman niu dun? Taꞌ taway dun gupiai ginepuꞌayen?” Kaliꞌ ilan sembag, “Sapuꞌ ni David.” ");
INSERT INTO syb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Simbag ni Isus, “Dagid ki Tinduꞌ nu Megbebayaꞌ Meglekaunutan, saꞌ sapuꞌ laak sia ni David, naa taꞌ mai migelal dun si David Kaunutan? Mukaꞌ su kegelalen dun maꞌnia, pisulat si David nug Balakat nu Megbebayaꞌ, laungen, ");
INSERT INTO syb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Tinaluꞌ nu Kaunutan Megbebayaꞌ ditu Kaunutan ku, Pegingkuda dini gupidu, dini dapit lintuu, sampay di gendaw pelebaun ku yaꞌa daagen mu su nga kuntra mu.’” ");
INSERT INTO syb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Suminaak na puliꞌ si Isus dinilan, “Kaas ki Tinduꞌ nu Megbebayaꞌ Meglekaunutan, gilal ni David Kaunutan. Mendadi kagina maꞌantu, ki gasalen, sapuꞌ ba laak ni David?” ");
INSERT INTO syb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Naa su sinaak ni Isus dinilan kia, ndaꞌiduni mekesembag dun, pia sektaang taluꞌ. Naa genat itu, ndaꞌidun nai getaw mekakuꞌ sumaak dini Isus. ");
INSERT INTO syb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kaliꞌ pektaluꞌ si Isus tu nga melaun getaw mukaꞌ tu nga sakupen, ");
INSERT INTO syb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Mendadi ki nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ mukaꞌ ki nga Pariseo, ilan dawi tinduꞌ megulug tu Palinta nu Megbebayaꞌ pisulaten dini Moises. ");
INSERT INTO syb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Naa kagina maꞌantu, subay petuuden niu su nga mekpetuꞌun di Palinta kini mukaꞌ su nga Pariseo, subay dunutan niu su kelaun pektituluꞌen nilan diniu. Dagid kig betad nilan, ndiꞌ niu penunggilingay, puꞌ laini pektituluꞌen nilan, lain dademai pegbetaden nilan. ");
INSERT INTO syb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pipisan nilan gembegat tituluꞌan tu nga samataw nilan, asa ilan, ndiꞌ nilan tanan etateni salabuuk tu nga tenduꞌ nilan meguit tu guiten nug duma nilan kia. ");
INSERT INTO syb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Su kelaun baalen nilan, penggulaulaan nilan adun mekpaitaꞌitaꞌ laak di samataw nilan. Puꞌ su igbed nilan kia di gangas nilan mukaꞌ baingken nilan sinulatan Taluꞌ nu Megbebayaꞌ, pilekpang nilan gupia! Dakus su nga gungmay nu suub nilan, su tuꞌus tu kektamuy nilan tu Megbebayaꞌ, pilebian nilan petaasay! ");
INSERT INTO syb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mukaꞌ saꞌ ditu ilan keglekebibu, liagan nilan su pegingkudan nu pegbesaan getaw. Mesama dia simbaan, mauyaꞌan nilan su tampusan metaas gingkudan. ");
INSERT INTO syb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Saꞌ ditu pelum tebuꞌan, mauyaꞌan nilan pegbesaan ilan nu nga getaw, dakus gelalen ilan, ‘Mekpetuꞌun.’ ");
INSERT INTO syb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Yamu pasiꞌ, kanaꞌ amu gempia gelalen ‘Mekpetuꞌun,’ puꞌ miksama laak amu, lumbus amu samasakup, mukaꞌ sala tawan da laaki Mekpetuꞌun diniu. ");
INSERT INTO syb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Maꞌantu dadema, ndaꞌiduni sama kilawan niu dinig dibabaw lumbang gempia niu gelalen ‘Amaꞌ,’ puꞌ ndaꞌig lain gamaꞌ niu, subay su laak Gamaꞌ niu ditu gekbus langit. ");
INSERT INTO syb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mukaꞌ pagid kanaꞌ damu dema gempia gelalen ‘Kaunutan,’ puꞌ sala tawan laaki kaunutan niu, ki Tinduꞌ nu Megbebayaꞌ Meglekaunutan.” ");
INSERT INTO syb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Diksuꞌ ni Isus su taluꞌen, “Sinangkaliꞌ pa tanan, ki tampusan metaasi tindegen diniu, subay iin nai mbaal sesuguꞌen niu. ");
INSERT INTO syb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Adin su getaw petaasenen siai tindegen, iini pebebaꞌen. Adin dema su getaw mekpebabaꞌ dig lawasen, iini petaasen.” ");
INSERT INTO syb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Maaꞌ laung pa ni Isus, “Mekelelaatlelaat amu dema tuꞌu, yamu nu nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ mukaꞌ yamu nu nga Pariseo! Paa, tautau amu mekesuun! Puꞌ siniraan niu sug bisuangan nu Keglekaunutan nu Megbebayaꞌ mukaꞌ inapaꞌ niu su nga getaw sumakup dun sia, dagid yamu, ndaꞌ damu dema sakup dun! ");
INSERT INTO syb_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mekelelaatlelaat amu daan, yamu nu nga mekpetuꞌun di Palinta mukaꞌ yamu nu nga Pariseo! Paa, tautau amu daan mekesuun! Puꞌ peglimbungan niui ngag balulibun, mengagaw amu tu nga pimetang nilan, asa petaasen niu su kenenabi niu, pekpaitaꞌitaꞌ laak niu. Naa maꞌnia, midugangan dema tuꞌui kebegat nu ginukuman diniu.” ");
INSERT INTO syb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Laung pagid ni Isus, “Mekelelaatlelaat amu daan, yamu nu nga mekpetuꞌun di Palinta mukaꞌ yamu nu nga Pariseo! Paa, tautau amu daan mekesuun! Puꞌ mileep niu su tibuuk lumbang, adun puluꞌ duuni sala tawan mesakup niu. Dayun saꞌ duuni sumakup na diniu, pebantang niu iin belengen tug linaw gapuy, labi pa di kebantang dun dig lawas niu! ");
INSERT INTO syb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Mekelelaatlelaat amu daan, yamu nu nga megagak di getaw, asa maaꞌ amu nug buta! Puꞌ iini pektituluꞌen niu dinilan, ‘Saꞌ duun laungi sumapa, iini sembayanen su Pengedapan tu Megbebayaꞌ, naa ndiꞌen kambat tumanen ki sapanen kia. Dagid saꞌ iin sungkini sembayanen sug bulawan bitang diag dialem nu Pengedapan, naa subay penuudenen laung ki sapanen kia.’ ");
INSERT INTO syb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Paa, buta amu mukaꞌ benguꞌbenguꞌen amu pa pagid! Puꞌ adin bai metaas, sug bulawan saꞌ su Pengedapan tu Megbebayaꞌ? Kanaꞌ nu Pengedapan? Puꞌ sug bulawan, iini pinaas dun, puꞌ dia mibetang dialem Pengedapan tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mukaꞌ duun pai pektituluꞌen niu, ‘Saꞌ duun laungi sumapa, iini sembayanen sug betang inilak dia gentudan gilak tu Megbebayaꞌ, naa subay tumanenen ki sapanen kia. Dagid saꞌ iin sungkini sembayanen su gentudan gilak, teluꞌen niu puꞌ ndiꞌen kambat tumanen su sapanen kia.’ ");
INSERT INTO syb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Paa, saꞌ maꞌantu, lepeng buta amu tantu! Adin ba su metaas, sug betang atawaka su gentudan gilak tu Megbebayaꞌ? Kanaꞌ baini metaas su gentudan gilak? Puꞌ iini pinaas dun sug betang, puꞌ dia ilakay gentudan gilak tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kaas ma, saꞌ sumapai getaw, sembayanen su gentudan gilak tu Megbebayaꞌ, maꞌananen, mipedumanen dadema sembayay su kelaun betang inilak tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mesama dadema saꞌ duuni getaw sumapa, sembayanen su Pengedapan. Maꞌananen, misambayen su Pengedapan, mipeduma dun su Megbebayaꞌ, su luminusad pegbenwa dun. ");
INSERT INTO syb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Maꞌantu da pagid, saꞌ duuni sumapa, sembayanen su gekbus langit, maꞌananen, misembayanen su gingkudan nu Megbebayaꞌ, kampuꞌ nu pegingkud dun.” ");
INSERT INTO syb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Maaꞌ laung pa ni Isus, “Mekelelaatlelaat amu daan, yamu nu nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ mukaꞌ yamu nu nga Pariseo! Paa, tautau mekesuun amu daan! Puꞌ pia su gininisan pegdaut, begay niu tu Megbebayaꞌ su kesepuluꞌ ilasen. Dagid ki metaas gupia pinalinta, saꞌitada ki melegdeng betad, ki keglinelaatay mukaꞌ ki keseligan, baa, kig launanen kia, ndaꞌ dig delendeman niu. Asa kiin siaig bantang pegbetaden niu, sampay su nga duma pinalinta pa pagid. ");
INSERT INTO syb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Baa, yamu kiin, megagak amu daan tu getaw, asa buta amu! Puꞌ saꞌ duuni inumen niu melebuꞌan nu salabuuk maikaꞌ langaw, seluten niu, dagid saꞌ melebuꞌan kamelyu, inumen niu dayun! ");
INSERT INTO syb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mekelelaatlelaat amu daan, yamu nu nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ mukaꞌ yamu nu nga Pariseo! Paa, tautau mekesuun amu daan! Puꞌ ugasan niu sug dibabaw nu pinggan niu mukaꞌ tasa niu, laak dagid sug dialemen, mipenuꞌ nu pingagaw niu puun dig limbung niu mukaꞌ gayak niu. ");
INSERT INTO syb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Paa, yaꞌa pa dig buta Pariseo! Una mu pa ugasay ki seled nu tasa, dayun melimpiu dadema sug dibabawen!” ");
INSERT INTO syb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Laung ni Isus, “Mekelelaatlelaat amu daan, yamu nu nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ mukaꞌ yamu nu nga Pariseo! Paa, tautau amu daan mekesuun! Puꞌ pitanggiꞌu amu di ngag lebeng piputiꞌ gupia, kaas sug dibabawen, melengas gupia pegbentayan. Laak sug dialemen, mipenuꞌ tulan mukaꞌ nga mimegeduꞌ. ");
INSERT INTO syb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Maꞌantu damu dema. Saꞌ sug dibabaw lawas niu, mekesuun amu getaw di pegitaꞌen nu kelaun getaw. Dagid kig dialem nug delendeman niu, mipenuꞌ pembaalbaal mukaꞌ ngag limbung.” ");
INSERT INTO syb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Pidayun gusay ni Isus su taluꞌen, “Mekelelaatlelaat amu daan, yamu nu nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ mukaꞌ yamu nu nga Pariseo! Paa, tautau amu daan mekesuun! Puꞌ migbaal amu melengas lebeng tu nga pimuunan nu Megbebayaꞌ dengantu, mukaꞌ peksibaꞌan dadema niui nga pantiun nu mekesuun getaw. ");
INSERT INTO syb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mukaꞌ teluꞌen niu, ‘Yami kini, saꞌ pinenggiꞌ misagut nami sia su gendawan kitu nu nga ginepuꞌay nami, naa yami, ndiꞌ ami sia mpeduma di kekpatay nilan tu nga pimuunan nu Megbebayaꞌ kia.’ ");
INSERT INTO syb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Dagid saꞌ tinaluꞌ niui maꞌnia, miangken niu puꞌ sapuꞌ amu nu nga mimunuꞌ tu nga pimuunan nu Megbebayaꞌ kia! ");
INSERT INTO syb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kaas saꞌ maꞌnia, naa sigi na, tubus niu dayun ki pinggulaula nu nga ginepuꞌay niu kia! ");
INSERT INTO syb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Paa, yamu pa di nga mamak, sapuꞌ damu dema mamak! Kendutaꞌ mai keliaw niu dun ki ginukuman, belengen amu tug linaw gapuy? ");
INSERT INTO syb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kaas taman taluꞌu diniu, suguꞌen ku diniui nga pemuunan ku dakus nga telisebuten getaw mukaꞌ nga mekpetuꞌun. Dagid sug duma, petain niu. Sug duma pelum, lensangen niu di kurus. Sug duma pa pagid, pembedasen niu diag dialem nga simbaan niu, dayun pengeteden pa niu tu ngag lain lunsud. ");
INSERT INTO syb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kaas iini puunanen, yamu kiin, melabuꞌ tuꞌu diniu su ginukuman tu kemunuꞌ ditu kelaun getaw pinatay di ndaꞌi salaꞌ nilan, genat dini Abel su ndaꞌi salaꞌen sampay dini Zacarias, bataꞌ ni Baraquias, su pinatay niu kia ditu Pengedapan tu Megbebayaꞌ, dia gelet nu Meꞌelig Sugud mukaꞌ su gentudan gilak.” ");
INSERT INTO syb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Diksuꞌ ni Isus su taluꞌen, “Taman taluꞌu diniu, melabuꞌ tuꞌu diniu nga getaw nemun su ginukuman tu kelaun kemunuꞌ kitu!” ");
INSERT INTO syb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Laung padun ni Isus, “Uy, yamu nga getaw Jerusalem, yamu nga mekpatay di nga pimuunan nu Megbebayaꞌ, betuun pa pagid niu su nga sinuguꞌ diniu nu Megbebayaꞌ! Tatapu amu sia ekupay, maaꞌ nu nga pesuy pegleeman nu ginaꞌen! Dagid mpauk amu dun! ");
INSERT INTO syb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kaas belengan tuꞌu nu Megbebayaꞌ kig lunsud niu, dayun pelengan gapuy. ");
INSERT INTO syb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Taman taluꞌu diniu, genat nandaw, ndiꞌ na niau puliꞌ maitaꞌ, sampay mateng su gendaw metaluꞌ niu, ‘Aa naa, kiin na, minateng na ki pigwekilan nu Kaunutan Megbebayaꞌ. Melengas pepianan iin nu Megbebayaꞌ.’” ");
INSERT INTO syb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Naa migawaꞌ si Isus tu Pengedapan tu Megbebayaꞌ. Mendadi, saananen megawaꞌ dia, mikpesempel diniin su nga sakupen, tinduꞌ nilan diniin ki nga mekelengas ginumbelayan misakup tu Pengedapan kia. ");
INSERT INTO syb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Sumimbag si Isus dinilan, “Waꞌa daan, maitaꞌ niu nandawig launanen kini. Dagid taman taluꞌu diniu, duuni gendaw mateng, pia salabuuk batu di kitentudanen, ndaꞌiduni mesamaꞌ dun, megelaꞌ gupia penggebaꞌay.” ");
INSERT INTO syb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Naa pegingkud si Isus tug dibabaw Bentud nu nga Gayu Olibo. Mendadi minadap diniin su nga sakupen, ilanilan da, suminaak nilan diniin, “Naa saꞌ mesuꞌat, Sir, pesuun mu dinami, nanu ma mpenggulaula kig launanen kia? Mukaꞌ alanduni tuꞌusan dun saꞌ sungua lumusad puliꞌ, mukaꞌ saꞌ sungu melengkebig benwa?” ");
INSERT INTO syb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Sumimbag si Isus, “Naa, peglengilam amu, adun ndiꞌ amu melimbungan nu getaw. ");
INSERT INTO syb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Puꞌ melaun metuaꞌ, engkenen nilani gelalu, laung nilan, ‘Naani Tinduꞌ nu Megbebayaꞌ Meglekaunutan.’ Benaꞌ melaun getaw melimbungan nilan. ");
INSERT INTO syb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mukaꞌ pa pagid, duuni medengeg niu pegbunuꞌ dia mesempel sampay tu melayuꞌ, laak ndiꞌ amu melibuleng dun. Puꞌ subay mpenggulaula itu, laak kanaꞌ paini kelengkeb nug benwa. ");
INSERT INTO syb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Puꞌ su sala nasud, lumumpak daan dig lain nasud. Su sala peglegediꞌan, lumumpak dig lain peglegediꞌan. Mukaꞌ mian pa pagidi meliget gutem, dakus duuni ngag linug di tibuuk benwa. ");
INSERT INTO syb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Dagid kig launan gempenggulaula kia, maꞌniin laak penenggiꞌan saꞌ mekpuun pa megbatik tian sug libun. ");
INSERT INTO syb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Mukaꞌ duun diniui daapen mukaꞌ pegwakil di nga getaw adun peglegetan amu mukaꞌ petain amu. Bentaan amu nu kelaun getaw sabaꞌ nu kesakup niu dinaan. ");
INSERT INTO syb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Naa saꞌ maꞌniai mpenggulaula, melaun sakup tuliud tu kekpetuud nilan. Kaas mektinipuay ilan, mukaꞌ megbanta su samasakup. ");
INSERT INTO syb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Dayun melaun paduni tautau pimuunan nu Megbebayaꞌ metuaꞌ, melaun getaw peglimbungan nilan. ");
INSERT INTO syb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Menamal dayun sug limbung, benaꞌ melauni ndiꞌ na mekpinetailay. ");
INSERT INTO syb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Dagid adin su getaw mektigel sampay mengikteb, iini megawen. ");
INSERT INTO syb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mukaꞌ ki Gempia Petenday kini mekatag di kesakup tu Keglekaunutan nu Megbebayaꞌ, pegukit pa tu tibuuk lumbang, puꞌ adun meketakesiꞌ dun su kelaun bansa nu getaw. Tigaꞌwan, dekag pa melengkebig benwa.” ");
INSERT INTO syb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Kaliꞌ gusay pektaluꞌ si Isus, “Naa ki giningelanan Mekelemuꞌ mukaꞌ Mekpelaat, su sinulat dengantu ditu Taluꞌ nu Megbebayaꞌ nu pimuunanen si Daniel, naa maitaꞌ pa niu ki Mekelemuꞌ mukaꞌ Mekpelaat kia, paindegen dia pinaas Pengedapan tu Megbebayaꞌ.” (Naa ki sinulat kini, subay sebuten gupia nu megbasa dun!) ");
INSERT INTO syb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Maaꞌ laung padun ni Isus, “Mendadi, saꞌ metandaꞌ na dia ki Mekelemuꞌ mukaꞌ Mekpelaat kia, naa su nga getaw dini Judea, subay meglaguy tu ngag binentudan. ");
INSERT INTO syb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Adin su getaw metaang dia gatep nug balayen, ndiꞌ pia melangan suled pa diag dialem puꞌ malap tu pimetangen. ");
INSERT INTO syb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Samanen su getaw metaang ditug binaalanen, ndiꞌ dadema mpia melangan muliꞌ puꞌ engainen pa sia su melambak suuben. ");
INSERT INTO syb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Naa sug libun saꞌ metaang dig bedesanen ki gendaw kiin, mesama su pegduduꞌan pa, aa, mekelelaatlelaat ilan gupia! ");
INSERT INTO syb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mukaꞌ iini penenebiin niu, ki kelaguy niu kia, ndiꞌ metaang di timpu metegdaw atawaka metaang di Gendaw Pelali! ");
INSERT INTO syb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Puꞌ ki kelegenay di gendaw kiin, ndaꞌidun naig lain kelegenay mekelepeng dun, genat ditu kebuat di gekleb langit buꞌ lupaꞌ sampay nandaw, mukaꞌ sampay pa dema dig binayaꞌ gebii buꞌ gendaw. ");
INSERT INTO syb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kaas saꞌ ndiꞌ engkanan nu Megbebayaꞌ su kaiben nu kelegenay kia, ndaꞌidun na siai mesamaꞌ getaw tetubuꞌ, megelaꞌ ilan sia mesapul. Dagid engkanan pa tuꞌu nu Megbebayaꞌ su kaibenen, sabaꞌ nu nga tinduꞌen sakupen. ");
INSERT INTO syb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Mendadi,” maaꞌ laung pa ni Isus, “saꞌ duuni mektaluꞌ diniu, ‘Bentayay pa daan niu, kiin na su Tinduꞌ nu Megbebayaꞌ Meglekaunutan!’ atawaka duuni mektaluꞌ, ‘Kia nain!’ naa ndiꞌ amu pekpetuud dun. ");
INSERT INTO syb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Puꞌ duun pai nga metuaꞌ tautau iini Tinduꞌ nu Megbebayaꞌ Meglekaunutan, mukaꞌ metuaꞌ dademai nga tautau pimuunan nu Megbebayaꞌ. Mekpaitaꞌ ilan nga ginuung mukaꞌ mekesalebuꞌ tuꞌus, puꞌ adun megaga nilan sia peglimbungay pia pa su tinduꞌ nu Megbebayaꞌ sakupen. ");
INSERT INTO syb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kaas pekineeg amu gupia, daan ku na pisuun diniu ki mpenggulaula! ");
INSERT INTO syb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Mesama da saꞌ duuni mektaluꞌ diniu, ‘Naa, sug Bataꞌ nu Kilawan, kitu na, ditu na limawaꞌ!’ – ndiꞌ niu laaway. Mesama da saꞌ duuni mektaluꞌ, ‘Naa, kitu na, ditu na megeglud!’ – ndiꞌ niu dadema petuuday. ");
INSERT INTO syb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Puꞌ maaꞌ nu gilat, tekaw tiaganen sug langit genat tu dapit silangan mangay tu sindepan, maꞌantu dau dema, naan kini kig Bataꞌ nu Kilawan, saꞌ lumusadu puliꞌ. ");
INSERT INTO syb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Adin sug duunig bangkay dun, ditu dayun mekpungun su nga menagit.” ");
INSERT INTO syb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Pidayun gusay ni Isus su taluꞌen, laungen, “Mendadi, saꞌ laak mengikteb nai kelegenay di gendaw kia, su gendaw, ndiꞌ na tuiag, mukaꞌ sug bulan, ndiꞌ na dema meglamag. Su ngag bitun ditug langit, meglabuꞌ, mukaꞌ su kelaun mibetang ditu gawanawan, mekegyugegyug. ");
INSERT INTO syb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Naa mendadi saꞌ menuud naig launanen, naan kini, kig Bataꞌ nu Kilawan, medayag dayun tug langit ki tuꞌusu. Dayun su taman bansa getaw dig dibabaw lumbang kini, memektenlis ilan saꞌ medayag nau nilan tuꞌu, naan kini kig Bataꞌ nu Kilawan, metuaꞌu di gabun, medayag na su ginuungu, mukaꞌ maitaꞌ di tiagu su kelengas nu metaas pegbayaꞌu. ");
INSERT INTO syb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mendadi saꞌ lumusadu, medengeg dayun ki metikteg bugyung, mukaꞌ suguꞌen ku dayun su nga sesuguꞌen ku getaw langit, adun leepen nilan sug dibabaw lumbang, pungunen nilan su getaw pimiliꞌ nu Megbebayaꞌ sakupen, genat ditu pingikteban benwa ditu dapit silangan sampay ditu tampusan benwa dapit sindepan.” ");
INSERT INTO syb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Laung ni Isus, “Naa, alap niu tituluꞌan ki gayu igera. Sug igera, saꞌ mentubil su panganen dayun megbegu daun, mesuunan niu puꞌ sungu na memedesig benwa. ");
INSERT INTO syb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Naa maꞌantu dadema, saꞌ maitaꞌ na niuig launan gempenggulaula kini, mesuunan niu dadema puꞌ naan, sungu nau mateng puliꞌ, gitunganen, dia nau bisuangan nug balay. ");
INSERT INTO syb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Taman taluꞌu diniu, ndiꞌ tagad mematay su nga getaw tetubuꞌ nemun, megelaꞌ pa menuudig launanen kini. ");
INSERT INTO syb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Puꞌ su gekleb langit buꞌ lupaꞌ, megelaꞌ da mbeleng. Laak dagid ki pekteluꞌen ku kini, ndaꞌi kebelengen. ");
INSERT INTO syb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Laak dagid ki gempenggulaula kiin, ndaꞌiduni getaw mekesuun dun, saꞌ taꞌ endaway dun atawaka taꞌ urasay dun. Pia pa su nga sesuguꞌen nu Megbebayaꞌ ditu gekbus langit sampay naan, kig Bataꞌen, ndaꞌi mekesuun dun, subay su laak Gamaꞌu. ");
INSERT INTO syb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Puꞌ ki kelusadu puliꞌ, naan kini kig Bataꞌ nu Kilawan, iini samanen, su mipenggulaula ditu timpu ni Noe. ");
INSERT INTO syb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Di gendaw kitu minaan su getaw, mininum ilan, migbelaꞌi ilan, sampay da dun di gendaw nu keseled ni nga Noe tug butuk. ");
INSERT INTO syb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Puꞌ ndaꞌ dig delendeman nilan su sungu mpenggulaula, kaas mikpuun sug Bagyu Lampap, dayun mitekawan melemesi kelaun getaw kitu. Mendadi, naan kini kig Bataꞌ nu Kilawan, maꞌantu dadema ki kelusadu puliꞌ. ");
INSERT INTO syb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Saꞌ matengu, duunig duaꞌ tawan laki pekpengimbaal dig lupaꞌ, elapen su sala tawan, mbilin dayun su sala tawan. ");
INSERT INTO syb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Duun pa pagidig duaꞌ tawan libun peglegaling. Tekaw elapen su sala tawan, bilinen sug dumanen. ");
INSERT INTO syb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kaas pegenduk amu, saꞌitada pektalenten amu, puꞌ ndaꞌ niu mesuunay saꞌ taꞌ endaway dun ki ketuaꞌ puliꞌ nu Kaunutan niu. ");
INSERT INTO syb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mukaꞌ pegdelendem niu pa pagidi gapuꞌ balay. Saꞌ pinenggiꞌ mesuunan pedaan nu gapuꞌ balay su kedateng nu getaw malap sia di pimetangen, ndiꞌ ba megenduk, adun ndiꞌ sia mbegdakan sug dending nug balayen? ");
INSERT INTO syb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mendadi naan kini, kig Bataꞌ nu Kilawan, lumusadu puliꞌ di guras kanaꞌ niu pedetengen. Kaas pengandam amu gusay. ");
INSERT INTO syb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Mendadi,” laung ni Isus, “adin su sesuguꞌen meseligan mukaꞌ telisebuten, iin dayuni pebiaꞌen nu gegalenen tu nga sama sesuguꞌenen, iini mekilas tu gaan nilan saꞌ matengi kegilas dun. ");
INSERT INTO syb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Saꞌ mateng su gegalenen mukaꞌ iini medetenganen, petuuden nu sesuguꞌen su sinuguꞌ diniin, naa leliagen su sesuguꞌen kia! ");
INSERT INTO syb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Taluꞌu diniu tuꞌu, saꞌ maꞌnia, pegwakil dayun nu gegalenen diniin su kelaunan pimetangen. ");
INSERT INTO syb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Dagid saꞌ medupangi sesuguꞌen kia, dialem delendemanen, ‘Aa, su gegalen ku, maiben pa dateng,’ ");
INSERT INTO syb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kaas pesaitanen su nga sama sesuguꞌenen mukaꞌ meksidalu maan, meginum, dakus megbebulek, naa saꞌ maꞌnia, taꞌ ma dayuni mpenggulaula? ");
INSERT INTO syb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Duuni gendaw metekaw muliꞌ su gegalenen di guras ndaꞌen pedetengay. ");
INSERT INTO syb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mendadi, silutan dayun nu gegalenen ki sesuguꞌenen kia, dayun pedumaay tu nga tautau mekesuun, benaꞌ mengaduy, lamugen mengkiget di ngisinen.” ");
INSERT INTO syb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kaliꞌ gusay pektaluꞌ si Isus, “Mendadi ki gendaw kiin saꞌ meglekaunutan na tuꞌu su Megbebayaꞌ, maꞌniniꞌig bianen. Penenggiꞌan dunig belaꞌi. Naa duuni sepuluꞌ tawan delaga minalap suluꞌ nilan, puꞌ minangay ilan sumungkak tu menginsawa. ");
INSERT INTO syb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Naa lima tawan di ngag delaga kia, telisebuten ilan. Kig lima tawan pelum kia, benguꞌbenguꞌen ilan. ");
INSERT INTO syb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mendadi benaꞌ mipanaw ilan, kig lima tawan kia benguꞌbenguꞌen, ndaꞌidunig lana giwit nilan pengandam nilan sia di nga suluꞌ nilan kia. ");
INSERT INTO syb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Dagid kig lima tawan kia telisebuten, miguit ilan betangan mipenuꞌ lana. ");
INSERT INTO syb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Naa benaꞌ dia nailan tandaꞌ sungkakan nilan dun, sabaꞌ milangan su menginsawa, tulugeni ngag delaga kini, mukaꞌ miktulug ilan tuꞌu. ");
INSERT INTO syb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Mendadi benaꞌ tengaꞌ gebii na,” maaꞌ laung padun ni Isus, “duuni miktawag, ‘Uy, kia na su menginsawa! Sungkak na niu ganam!’ ");
INSERT INTO syb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Migelaꞌ dayun metanudi ngag delaga kini, tinutudan nilan dayuni nga suluꞌ nilan. ");
INSERT INTO syb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Laung ni ngag benguꞌbenguꞌen delaga kia dia nga telisebuten, ‘Naa, bataꞌ begayay niu ami dig lana niu kiin, puꞌ pekpaleng nai suluꞌ nami kini.’ ");
INSERT INTO syb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","‘Baa,’ simbag ni nga telisebuten delaga kia, ‘mbuus ndiꞌ metukid dinita, launan ta. Melengas angay amu ditu mendagang lana, saluy amu ditu.’ ");
INSERT INTO syb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Minangay dayun sumaluy lana su ngag benguꞌbenguꞌen delaga. Laak ndaꞌ ilan tagad dateng puliꞌ, minateng na tuꞌu ki menginsawa. Lemen laak minateng dia, sumiled dayun dia pemeliꞌian su menginsawa, kampuꞌ su ngag lima tawan delaga kia, ki mikandam na kia. Tinakep dayun sug bisuangan. ");
INSERT INTO syb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Naa saꞌ maꞌantu, sug lima tawan pelum, ndaꞌ maiben, minateng dailan dema. Kaliꞌ ilan peksabi, ‘Uu Sir, kelelaat pukaꞌay mu ami!’ ");
INSERT INTO syb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Dagid sumimbag su menginsawa, ‘Baa, yamu kiin, ndiꞌu amu mailala.’” ");
INSERT INTO syb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Mendadi diksuꞌ ni Isus su taluꞌen, “Saꞌ maꞌantu, yamu dema, pegenduk amu lelayun, puꞌ ndaꞌ niu mesuunay su gendaw sampay su gurasen. ");
INSERT INTO syb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Naa mendadi,” laung ni Isus, “ki gendaw kiin saꞌ meglekaunutan na tuꞌu su Megbebayaꞌ, sala pa penenggiꞌan dun ki getaw mipanaw di melayuꞌ. Mendadi, selian ndaꞌ pa panawi getaw kini, pinsabineni nga sesuguꞌenen, pisaligen dayun dinilan su gimunen. ");
INSERT INTO syb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Diadia pigwekilanen kwarta, pilepengen tu tinawan nu piseliganen kia. Su sala tawan, pigwekilanen lima ngibu. Su sala tawan pelum, duaꞌ ngibu. Dayun su sala pelum, sengibu da laak. Naa benaꞌ migelaꞌen pesalig dia nga sesuguꞌenen su gimunen, mipanaw dayuni gegalen nilan kia. ");
INSERT INTO syb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Naa benaꞌ mipalus su gegalen nilan kia,” maaꞌ laung ni Isus, “naa ki sesuguꞌen kia pigwekilan lima ngibu, mipanaw dayun, pinelapiꞌen su kwarta pigwakil diniin. Midugangan dayun lima ngibu pa pelum, su tubuꞌen. ");
INSERT INTO syb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Naa ki sesuguꞌen kia pigwekilan duaꞌ ngibu, maꞌantu dadema, kaas sug daniin, mitubuꞌ dadema, duaꞌ ngibu. ");
INSERT INTO syb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Dagid ki pigwekilan laak sengibu kini, minangay megengkul diag lupaꞌ, dayunen laak lebengay diag dialem lupaꞌ ki pigwakil diniin nu gegalenen. ");
INSERT INTO syb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Naa benaꞌ miniben, ki gegalen nu nga sesuguꞌen kia, minuliꞌ na pelum, piningilanen ilan dayun. ");
INSERT INTO syb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Benaꞌ miningil, minadap diniin su sesuguꞌen kia su pigwekilanen lima ngibu, dayunen tulunay dia gegalenen lima ngibu, kampuꞌ nu tubuꞌen. Kaliꞌ pektaluꞌ, ‘Naa Sir, lima ngibui pigwakil mu dinaan, kini pa pagidig lima ngibu, tubuꞌen.’ ");
INSERT INTO syb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","‘Aa naa, melengas!’ laung nu gegalenen. ‘Gempiaa sesuguꞌen, meseligan ka! Naa kagina meseligan ka megbayaꞌ di maikaꞌ, pebayaꞌu diniꞌa melaun. Naa, seleda pa dinig dialem, pedumanan ku yaꞌa dig leliagu!’” ");
INSERT INTO syb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Laung pa ni Isus, “Mendadi, suminukli madap tu gegalen su sesuguꞌen kia pigwekilan duaꞌ ngibu, kaliꞌ pektaluꞌ, ‘Sir, naan dadema, duaꞌ ngibui pibayaꞌ mu dinaan. Naa, kini paig duaꞌ ngibu pagid, tubuꞌen.’ ");
INSERT INTO syb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‘Aa naa, melengas!’ laung nu gegalenen. ‘Gempiaa sesuguꞌen, meseligan ka! Naa, kagina meseligan ka megbayaꞌ di maikaꞌ, pebayaꞌu diniꞌa melaun. Naa, seleda pa dinig dialem, pedumanan ku yaꞌa dig leliagu!’ ");
INSERT INTO syb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Laak dagid benaꞌ minadap tu gegalen ki pigwekilan kia laak sengibu, kaliꞌ pektaluꞌ, ‘Sir, misuunan ku puꞌ metegasig betad mu, geniin mu su ndaꞌ mu pemulanay, penteguꞌen mu pa pagid dig lulu mu su ndaꞌ mu dadema peliday. ");
INSERT INTO syb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kagina maꞌantu, mindeku, kaas ki kwarta mu kia, gigludu diag dialem lupaꞌ. Naa, kini da gusay su kwarta mu.’ ");
INSERT INTO syb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","‘Paa,’ simbag nu gegalenen, ‘melaata sesuguꞌen, melelaꞌa pa pagid! Misuunan mu ba puꞌ geniin ku su ndaꞌu pemulanay, dakus penteguꞌen ku su ndaꞌu dadema peliday? ");
INSERT INTO syb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Naa saꞌ maꞌantu, ki kwartau kiin, mauma pelum ndaꞌ mu betangay dig bangkuꞌ, adun medawatu sia puliꞌ saꞌ mekauliꞌu, kampuꞌ nu tubuꞌen? ");
INSERT INTO syb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Naa, awiꞌ niu diniin ki sengibu kiin, begay niu di sala tawan kiin sepuluꞌ ngibuig daniin. ");
INSERT INTO syb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Puꞌ adin su getaw duunig daniin, begayan pa padun, sampay melaunig daniin. Adin pelumi getaw ndaꞌidunig daniin, laak uiꞌen diniin su maikaꞌ sia daniin. ");
INSERT INTO syb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mendadi ki getaw kini ndiꞌ metau suguꞌen, piglak niu tug liu, ditu medelem. Ditu dayun mengaduy, lamug mengkiget di ngisinen.’” ");
INSERT INTO syb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Kaliꞌ gusay pektaluꞌ si Isus, “Mendadi naan, kig Bataꞌ nu Kilawan, metuaꞌu tuꞌu puliꞌ, medayag na su kelengas nu pegbayaꞌu, dumau sug lumaun sesuguꞌen nu Megbebayaꞌ getaw langit. Dayun saꞌ metuaꞌu, mingkud nau tuꞌu meglegadiꞌ. ");
INSERT INTO syb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Dayun saꞌ mekaingkudu, ki kelaun bansa nu kilawan, pungunen na ditu gedapan ku. Dayun ku ilan pekpainay duaꞌ penunan, maaꞌ nug betad nu megingat karniru, pekpainenen su nga karniru mukaꞌ kanding. ");
INSERT INTO syb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ki nga mekesuun getaw, painen ku di dapit lintuu. Ki nga melimbung getaw dema, dig bibangu. ");
INSERT INTO syb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Mendadi naan, ki Gadiꞌ, teluꞌan ku dayun ki nga getaw kia diag lintuu, ‘Naa ma, dini namu, yamu nga pipianan nu Gamaꞌu! Dini amu, puꞌ petenged na tuꞌu diniu su Keglekaunutan nu Megbebayaꞌ, ki pitenged na daan diniu, su ndaꞌ pa mbaali gekleb langit buꞌ lupaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Puꞌ saꞌ migutemu, bigayan ma niau gaan. Saꞌ kiwawu, piꞌinum ma niau. Saꞌ genatu di melayuꞌ, pinembaꞌ ma niau. ");
INSERT INTO syb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Saꞌ kulangi penepeten ku, bigayan niau penepeten ku. Saꞌ migladuu, tinagikul niau. Saꞌ mipirisuu, bintaw ma niau.’ ");
INSERT INTO syb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Dayun sumbag su nga mekesuun getaw kia, ‘Aba, Kaunutan, ndaꞌa nami mainsan paꞌaanay saꞌ migutema, dakus ndaꞌa nami dadema painumay saꞌ kiwawa! ");
INSERT INTO syb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ndaꞌa nami dadema mainsan penembaꞌay saꞌ genata di melayuꞌ, dakus ndaꞌa nami mainsan begayay penepeten mu saꞌ kulangi penepeten mu! ");
INSERT INTO syb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Mukaꞌ ndaꞌa nami mainsan bentaway, saꞌ mibianan mui migladua atawaka mipirisua!’ ");
INSERT INTO syb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Naa saꞌ maꞌantu,” maaꞌ laung padun ni Isus, “naan kini, ki Gadiꞌ, sembagen ku ilan, ‘Taman taluꞌu diniu, adin su tampusan gembabaꞌ mimated dinaan kini gibangan niu, naa kanaꞌ laak iini gibangan niu, puꞌ naan, gibangan niau dadema!’ ");
INSERT INTO syb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Mendadi,” maaꞌ laung padun ni Isus, “ki nga getaw dia dapit bibangu, teluꞌen ku pelum dinilan, ‘Naa pelayuꞌ amu dinaan, yamu nu nga inukum nu Megbebayaꞌ! Dituun amu angay linaw gapuy ndiꞌ na mpaleng, ki miandam ditu Palin mukaꞌ tu nga sesuguꞌenen getaw langit! ");
INSERT INTO syb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Puꞌ saꞌ migutemu, ndaꞌ ma niau paꞌaanay. Saꞌ kiwawu, ndaꞌ ma niau painumay. ");
INSERT INTO syb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Saꞌ genatu di melayuꞌ, ndaꞌ ma niau penembaꞌay. Saꞌ kulangi penepeten ku, ndaꞌ niau begayay. Saꞌ migladuu dakus mipirisuu, ndaꞌ ma niau bentaway.’ ");
INSERT INTO syb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Dayun sumbag su nga getaw diag bibangu, ‘Aba, uu Kaunutan, ndaꞌa ma nami mainsan maitaꞌ mibianan mu migutema, saꞌ kiwawa, saꞌ genata di melayuꞌ, saꞌ kulangi penepeten mu, saꞌ migladua atawaka mipirisua, dayun ndaiꞌ gabang nami diniꞌa!’ ");
INSERT INTO syb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Mendadi, sembagen ku ilan dayun, ‘Taman taluꞌu diniu, adin su tampusan gembabaꞌ sakupu kini ndaꞌ niu pegebangay, naa kanaꞌ laak iini ndaꞌ niu pegebangay, pia naan, ndaꞌ dadema niau pegebangay.’ ");
INSERT INTO syb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Mendadi, ki nga getaw dig bibangu, pebundasen ilan dayun tu ginukuman ndaꞌi tamanen. Ki nga mekesuun getaw pelum, ditu ilan dayun pebundasay ketubuꞌ ndaꞌi tamanen.” ");
INSERT INTO syb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Naa benaꞌ mideksuꞌen su kelaun tinituluꞌen kia, miktaluꞌ si Isus tu nga sakupen, ");
INSERT INTO syb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Naa misuunan niu puꞌ duaꞌ gebii pa mektelipuun sug Lumpuk tug Liniusan. Mendadi saꞌ mektelipuun na, naan kini, kig Bataꞌ nu Kilawan, pegwakilu ditu getaw, adun lensangenu nilan di kurus.” ");
INSERT INTO syb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mendadi ki nga kaunutan nug belian mukaꞌ ki ngag duma kaunutan nu getaw Judea, mikpungun ilan tug balay nu Tampusan Metaas Belian, si Caifas. ");
INSERT INTO syb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Puꞌ iini peksebutsebutan nilan, ki kedaap nilan dini Isus, puꞌ adun pepatay nilan iin. Laak pigunguban nilan, ");
INSERT INTO syb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","laung nilan, “Ndiꞌ mesuꞌat metaang dig Lumpuk, puꞌ buus menlimuuk su nga getaw.” ");
INSERT INTO syb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Naa si Isus, sinegayen ditu pelum Betania, inggat maan diag balay ni Simon, su getaw kiin minayan megladu mekesalebuꞌ nuka. ");
INSERT INTO syb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Benaꞌ saanan ni Isus maan, duuni minadap diniin libun peguit bataꞌ bandi gemputiꞌ, mipenuꞌ pagemut, melagaꞌ gupia. Mendadi benaꞌ mikpesempel dini Isus sug libun, binunagen dayun di gulu ni Isus. ");
INSERT INTO syb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Dagid dekag minitaꞌ nu nga sakup ni Isus, milaati ginaa nilan dun, laung nilan, “Baa, mauma dema ki pagemut kia, pikulaꞌulaꞌan laak? ");
INSERT INTO syb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Iin siai melengas, piksaluy sia, mabuꞌ malin pa sia melaun, dayun begay tu nga pubri su galinen!” ");
INSERT INTO syb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Dagid misuunan ni Isus su pekteluꞌen nu nga sakupen kia, kaas miktaluꞌ dinilan, “Mauma libulengen ma niuig libun kini? Ki pinggulaulanen dinaan, melengas. ");
INSERT INTO syb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Su pubri, lelayun niu mpungun megbenwa. Naan dagid, kanaꞌ nau maiben dumuma diniu dini. ");
INSERT INTO syb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Naa ki pinggulaula nug libun kini, maꞌananen, pigupiananen pedaanig lawasu di kelebeng sungu dinaan. ");
INSERT INTO syb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mendadi taman taluꞌu diniu, pia adin pegukit su Gempia Petenday dinig dibabaw lumbang, naa mpeduma dun dadema pegukit ki pinggulaula nig libun kini, puꞌ adun ndiꞌ iin melingawan.” ");
INSERT INTO syb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mendadi kini si Judas Iscariote, sala tawan di nga sepuluꞌ buꞌ duaꞌ peneligan ni Isus, linaawanen su nga kaunutan nug belian nu getaw Judea. ");
INSERT INTO syb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Suminaak si Judas dinilan, “Mendadi si Isus kiin, saꞌ tipuun ku diniu, alandun mai begay niu dinaan?” Mendadi ki ngag belian kini, binilang nilan dayuni telu puluꞌ laad siin pelata, tinulun nilan dayun dini Judas. ");
INSERT INTO syb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kaas genat nitu, si Judas kini, piksuꞌatsuꞌaten dayuni sikawen tumipu dini Isus. ");
INSERT INTO syb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mendadi, benaꞌ minateng sug bekna gendawan nug Lumpuk di Pan ndaꞌ Petulinay, minadap dini Isus su nga sakupen, suminaak ilan diniin, “Sir, kig Lebungan ta tug Liniusan, adin mu ami paulingelay?” ");
INSERT INTO syb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kaliꞌ sembag si Isus, “Bundas amu ditu syudad. Saꞌ mateng amu ditu, laaway niu si Uan kia. Naa saꞌ mateng amu ditu niin, taluꞌ niu dayun diniin, ‘Naa, pimuun nu Mekpetuꞌun, laungen, Sungu na metektaki sesaꞌu. Kaas dini nami maan Lebungan nami tug Liniusan, yami nu nga sakupu, dinig balay mu.’” ");
INSERT INTO syb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Pituud dayun nu nga sakup ni Isus su sinuguꞌanen dinilan kia. Pigulingel nilan dayun sug Lebungan nilan tug Liniusan. ");
INSERT INTO syb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Naa benaꞌ misindepi gendaw, mingingkud maan si nga Isus, ilan nu nga sepuluꞌ buꞌ duaꞌ tawan sakupen. ");
INSERT INTO syb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mendadi, benaꞌ pekaan nailan, kaliꞌ pektaluꞌ si Isus dinilan, “Taman taluꞌu diniu, ki sala tawan diniu, mektipu dinaan.” ");
INSERT INTO syb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Milibuleng dayun su nga sakup ni Isus. Miglimbuslimbus ilan sumaak diniin, “Asa uu Kaunutan, kanaꞌ da sia naani pekteluꞌen mu kiin?” ");
INSERT INTO syb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Sumimbag si Isus, “Sala tawan lai suminalu gupia dinaan kini, iini tumipu dinaan. ");
INSERT INTO syb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Puꞌ naan kini, kig Bataꞌ nu Kilawan, mbinasau tuꞌu, maaꞌ dadema nu misulat pedaan ditu Taluꞌ nu Megbebayaꞌ. Laak dagid pia maꞌantu, ki getaw mektipu dinaan, kig Bataꞌ nu Kilawan, mekelelaatlelaat gupia! Tumuꞌ pa ndaꞌ na sia pegigetawi getaw kiin!” ");
INSERT INTO syb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Kini si Judas, su mektipu kia dini Isus, suminaak dayun diniin, “Asa Sir, kanaꞌ dema tuꞌu naan?” “Maꞌnia da, yaꞌai miktaluꞌ dun,” simbag ni Isus. ");
INSERT INTO syb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mendadi benaꞌ maan ilan, minalap si Isus pan, mikpaladpalad dayun tu Megbebayaꞌ. Pimetanen dayun su pan, dayunen pentulunay dia nga peneliganen. Kaliꞌ pektaluꞌ, “Naa, alap amu dun ini, aan niu. Kini sug lawasu.” ");
INSERT INTO syb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Minalap pelum si Isus sala tasa penginumen. Benaꞌ mikpaladpalad na puliꞌ tu Megbebayaꞌ, dayunen tulunay dia nga sakupen ki tasa kini. Kaliꞌ pagid pektaluꞌ dinilan, “Naa, inum amu dun ini, launan niu. ");
INSERT INTO syb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kini sug duguꞌu, ki mekigis na, adun mpedasun su salaꞌ nu melaun getaw. Kig duguꞌuig bian nug begu pasad nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mendadi, taman taluꞌu diniu, genat nandaw, ndiꞌ nau puliꞌ minum di penginumen kini, sampay da dun mateng su gendaw meglekaunutan na tuꞌu su Gamaꞌu. Dekag paita pegdengan minum dig begu ginis penginumen ditu Keglekaunutanen.” ");
INSERT INTO syb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Naa benaꞌ mitubus si nga Isus maan Lebungan nilan, migbebat ilan kegenal tu Megbebayaꞌ, dayun ilan mengguaꞌ dia, tumiwad ilan tug Bentud nu nga Gayu Olibo. ");
INSERT INTO syb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mendadi, kaliꞌ pektaluꞌ si Isus tu nga peneliganen, “Yamu kini, mbuus laak gebii kini, megelaꞌ amu tuliud dinaan. Puꞌ iini misulat ditu Taluꞌ nu Megbebayaꞌ, ‘Miktaluꞌ su Megbebayaꞌ, petain ku ki megingat tu karniru, dayun mesigwag su nga karniru pegingatenen.’” ");
INSERT INTO syb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Maaꞌ laung pa ni Isus, “Dagid benaꞌ genatu petubuꞌay puliꞌ, megunau diniu ditu Galilea.” ");
INSERT INTO syb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Miktaluꞌ si Pedro, “Aba, Sir, pia teliudan ka nu nga kelaun dumau, naan kini, ndiꞌ nau gusay tuliud diniꞌa!” ");
INSERT INTO syb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","“Taman taluꞌu diniꞌa,” laung ni Isus, “dekag pasiꞌ peguni su manuk gebii kini, metelu deksuꞌa na memalaw puꞌ kanaꞌ mau mailala.” ");
INSERT INTO syb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Dagid miktaluꞌ si Pedro, “Pia mekendutaꞌ, saliunungan ku yaꞌa, ndiꞌu da lai pemelaun puꞌ kanaꞌu yaꞌa mailala!” Mukaꞌ su kelaun sakup ni Isus, maꞌnia dademai penteluꞌen nilan. ");
INSERT INTO syb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Naa minundas si Isus tu pegimulanan gayu piningalan dun Getsemane, ilan nu nga sakupen. Benaꞌ minateng ilan dia, kaliꞌ pektaluꞌ si Isus dia nga sakupen, “Naa pegingkud amu deliꞌ dini, puꞌ mundas pau dia gunaan, menenabi pau dia.” ");
INSERT INTO syb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Dayun iwiten dumanen si Pedro mukaꞌ sug duaꞌ tawan kiin bataꞌ ni Sebedeo. Mendadi benaꞌ melayuꞌlayuꞌ nailan diag duma nilan, milegenan patiꞌ si Isus, diduaꞌani ginaanen. ");
INSERT INTO syb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Laungen dayun dia telu tawan dumanen, “Milegenanu ini, mibegatanu dun patiꞌ, maꞌniin na petayan ku ini. Kaas dini damu dun deliꞌ, dumanay niau megenduk.” ");
INSERT INTO syb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Minundas kemaikaꞌ dia gunaan si Isus, dayun miglaub dig lupaꞌ, kaliꞌ penenabi, “Uu Amaꞌu, saꞌ sia mesuꞌat diniꞌa, ki tasa mipenuꞌ nug lesayan ku sunguu na inumay, naa peliaw sia dinaan, adun ndiꞌu na mainum! Laak dagid, Amaꞌ, sug daniꞌa mauyaꞌan, iini penuuden, kanaꞌ nug danaan.” ");
INSERT INTO syb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Naa saꞌ maꞌnia, pinuliꞌan ni Isus su telu tawan sakupen kia. Midetenganen, tinulug ilan. Sinabi dayun ni Isus si Pedro, laungen, “Taꞌ itu, masiꞌ ndaꞌ na niau megaga dumanay megenduk, pia laak sauras? ");
INSERT INTO syb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Baa,” laung ni Isus, “peglengilam amu mukaꞌ penenabi amu daan, adun ndiꞌ amu mpenulay. Puꞌ dig delendeman niu, gangut niu sia mekpetuud amu tu mauyaꞌan nu Megbebayaꞌ. Dagid su kekilawan niu, melubay, ndiꞌ mekpetuud dun.” ");
INSERT INTO syb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Mipanaw na puliꞌ si Isus, minenabi na puliꞌ, laungen, “Uu Amaꞌu, saꞌ ndiꞌ mesuꞌat peliaw dinaan ki tasa mipenuꞌ nug lesayan ku kini subay inumen ku, naa maꞌantu da, senguꞌen ku kig daniꞌa laak delendeman kia.” ");
INSERT INTO syb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Mendadi, kaliꞌen puliꞌay pelum su nga peneliganen, iin da gusayi mitaanganen, tinulug ilan pelum, puꞌ ndiꞌ nilan metigeli tulug nilan. ");
INSERT INTO syb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Naa saꞌ maꞌantu, mipanaw na puliꞌ si Isus, minenabi di ketelu deksuꞌen, miksama da gusayi kenenabinen. ");
INSERT INTO syb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Dayunen puliꞌay pelum su nga sakupen kia, kaliꞌ pektaluꞌ dinilan, “Taꞌ ma, tinulug pamu gusay, milali amu? Naa ma, mitektak na su sesaꞌ! Mendadi naan kini, kig Bataꞌ nu Kilawan, pegwakil nau tuꞌu tu pegbayaꞌ nga kanaꞌ megbasa tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kaas pegbuat amu, mpanaw naita. Bentayay pa daan niu, kiin na tuꞌu ki tumipu dinaan!” ");
INSERT INTO syb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mendadi ndaꞌ pa medeksuꞌ mektaluꞌ si Isus, misebang si Judas, ki sala tawan kiin di sepuluꞌ buꞌ duaꞌ peneligan ni Isus. Melaun gupia getaw tumindug dini Judas kini, peguit ilan badung mukaꞌ bentul, sinuguꞌ ilan nu nga kaunutan nug belian mukaꞌ sug duma kaunutan nu getaw Judea. ");
INSERT INTO syb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Naa si Judas, ki tumipu dini Isus, duuni tuꞌus gandang bigayen di ngag dumanen kia, puꞌ tinaluꞌen dinilan, “Adin su getaw elekan ku, iinen na su penengaun niu. Daap niu dayun!” ");
INSERT INTO syb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Mendadi kini si Judas, tuminuun dayun madap dini Isus. Kaliꞌ pektaluꞌ, “Uu Sir, gempia dai ginaa mu!” Dunut ilekanen si Isus. ");
INSERT INTO syb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Laung ni Isus, “Naa, Sambat, kig baalen mu, baal mu ganam!” Mikpesempel ilan dini Isus, dinaap nilan dayun. ");
INSERT INTO syb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Naa sala tawan duma ni Isus, migbakut badungen, dayunen tigbasayi gulipen nu Tampusan Metaas Belian nu getaw Judea, miseksipi sedibaluy telinganen. ");
INSERT INTO syb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Dagid laung ni Isus, “Baa, gumaꞌ muig badung mu kiin. Puꞌ adini getaw memunuꞌan, bunuꞌ dademai palas nu kepetayanen. ");
INSERT INTO syb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Keduaꞌen, ndaꞌ mu masiꞌ mesuunay puꞌ mesuꞌatu mekpaingabang ditu Gamaꞌu, duun dayuni petuaꞌenen sesuguꞌenen getaw langit, kanaꞌ da dun santaꞌ laksaꞌ, adun sumugut dinaan? ");
INSERT INTO syb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Laak dagid saꞌ pinenggiꞌ maꞌniai mpenggulaula, naa kendutaꞌ mai kenuud nu sinulat ditu Misulat Taluꞌ nu Megbebayaꞌ puꞌ maꞌnini tuꞌui mpenggulaula?” ");
INSERT INTO syb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Miktaluꞌ dayun si Isus dia nga melaun getaw kia, “Naa, tulisan bau, kambat amu meguit badung mukaꞌ bentul saꞌ daapen niau? Asa gendawgendaw, migingkudu dia Pengedapan tu Megbebayaꞌ, mikpetuꞌunu dia, laak ndaꞌ niau daapay. ");
INSERT INTO syb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Laak dagid kini, subay mpenggulaula daan, adun menuud su sinulat dengantu nu nga pimuunan nu Megbebayaꞌ ditu Taluꞌen.” Naa saꞌ maꞌnia, bilengan dayun si Isus nu nga sakupen, mimeglaguy ilan, launan nilan. ");
INSERT INTO syb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Naa saꞌ maꞌantu, inagak si Isus nu nga migdaap diniin ditug balay nu Tampusan Metaas Belian nu getaw Judea, si Caifas. Mipungun dia su nga mekpetuꞌun di Palinta nu Megbebayaꞌ mukaꞌ su nga kaunutan nu getaw Judea. ");
INSERT INTO syb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Naa si Pedro, miglendug dadema di melayuꞌlayuꞌ, gikteb laak diag lenuꞌan nug balay kia. Benaꞌ minateng dia, luminamug dayun si Pedro di nga megingat pemegingkud dia, adun mesuunanen saꞌ taꞌi mpenggulaula. ");
INSERT INTO syb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mendadi ki nga kaunutan nug belian kia dakus ki tibuuk Pikumpungan nu Metaas Gukum nu getaw Judea, minengaw ilan sia pembaalbaal takesiꞌ mekatag dini Isus, puꞌ adun maukuman iin petain. ");
INSERT INTO syb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Laak dagid pia melaun minadap dinilan menakesiꞌ tu pimbaal dini Isus, mibulugan laak su nga kaunutan kia menengaw gempia dangat nilan diniin. Tigaꞌwan, migindeg di gedapanig duaꞌ tawan, ");
INSERT INTO syb_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","kaliꞌ ilan pektaluꞌ, “Naa ki getaw kini, tinaluꞌen, ‘Ki Pengedapan daw tu Megbebayaꞌ, megagau da gebaꞌay. Dayun gikteb telu endaw, baalen ku puliꞌ.’” ");
INSERT INTO syb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mendadi, migindeg na su Tampusan Metaas Belian kia. Sinaakanen dayun si Isus, laungen, “Naa, ndaꞌidun bai sembag mu di tinakesiꞌ ni nga getaw kini mekatag diniꞌa?” ");
INSERT INTO syb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Dagid ndaꞌ sembag si Isus. Kaliꞌ pektaluꞌ su Tampusan Metaas Belian, “Mendadi, pesepaan ku yaꞌa, sembayan ku su Megbebayaꞌ ndaꞌi gumulen, pemantek mu na dinami, yaꞌa ba tuꞌu su Tinduꞌ nu Megbebayaꞌ Meglekaunutan, kig Bataꞌ nu Megbebayaꞌ?” ");
INSERT INTO syb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Sumimbag si Isus, “Naa, maꞌnia da, yaꞌai miktaluꞌ dun. Dagid taman taluꞌu diniu, duuni gendaw mateng, naan kini, kig Bataꞌ nu Kilawan, maitaꞌ niau, pegingkudu tuꞌu ditu dapit lintu nu Tampusan Ginuungan! Dakus maitaꞌ niau, lumusadu puliꞌ dinig lumbang kini, metuaꞌu di gabun dia gawanawan!” ");
INSERT INTO syb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Naa, apelai. Ki Tampusan Metaas Belian kini, kaliꞌen medengeg pilepeng ni Isus sug lawasen tu Megbebayaꞌ, lingetan dini Isus sug Belian. Giditen su penepetenen, kaliꞌ pektaluꞌ, “Paa, piksudiꞌanen su Megbebayaꞌ! Ndiꞌ ta na kambat dugangan su takesiꞌ! Puꞌ midengeg na niu ki keksudiꞌen tu Megbebayaꞌ! ");
INSERT INTO syb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mendadi, alanduni kitab niu dun?” Simbag nu nga gukum, “Bantang na petain.” ");
INSERT INTO syb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Saꞌ maꞌnia, pindulaꞌan nilan ki muluꞌ ni Isus, dayun nilan denegay. Duun pa pagidi tuminampaling diniin, ");
INSERT INTO syb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","kaliꞌ ilan pektaluꞌ, “Naa, saꞌ sia metuud puꞌ yaꞌa su Tinduꞌ daw nu Megbebayaꞌ Meglekaunutan, suunan ka, atuk mu saꞌ taway dun dinamii mikpesait diniꞌa!” ");
INSERT INTO syb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Naa si Pedro, pegingkud diag liu, diag lenuꞌan nu pengukuman. Mendadi, duuni sala tawan delaga, sesuguꞌen nu Tampusan Metaas Belian nu getaw Judea, mikpesempel dini Pedro, kaliꞌ pektaluꞌ, “Uy, yaꞌa kiin, dumaa pagid ni getaw Galilea kiin, si Isus.” ");
INSERT INTO syb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Dagid mimalaw si Pedro di gedapan nu melaun getaw mipungun dia. “Baa,” laungen, “ki teluꞌen mu kiin, ndiꞌu lai mesabut.” ");
INSERT INTO syb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Migawaꞌ dayun dia si Pedro. Benaꞌ dia na mesempel dig bisuangan, minitaꞌ na pelum ni sala delaga, sesuguꞌen dadema. Laung nug delaga dia nga getaw pegindeg dia, “Ki getaw kini, duma ma nu getaw Nazaret kiin, si Isus.” ");
INSERT INTO syb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Laak dagid mimalaw na puliꞌ si Pedro, kaliꞌ pektaluꞌ, “Baa, bisan saak tug diwata, teluꞌen ku diniui metuud, ki getaw kiin, ndiꞌu mailala!” ");
INSERT INTO syb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Naa benaꞌ ndaꞌ maiben, su nga getaw pemegindeg dia, miktaluꞌ ilan pelum dini Pedro, “Naa yaꞌa, minget dumaa lai nilan, puꞌ mituꞌusan ma nami dia pikebitan mu!” ");
INSERT INTO syb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Dagid mingaduguꞌ tanan si Pedro, laungen, “Apelii lai! Ndiꞌu dema tuꞌu mailalai getaw kiin!” Iin demai keguni manuk. ");
INSERT INTO syb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Milabuꞌ dayun dig delendeman ni Pedro su tinaluꞌ kiin ni Isus, laungen, “Dekag pasiꞌ peguni su manuk, metelu deksuꞌa na memalaw puꞌ kanaꞌ mau mailala.” Gumiwaꞌ dayun dia si Pedro, lilugutan dayun mengaduy. ");
INSERT INTO syb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Naa benaꞌ putiꞌ delagay na, ki nga kelaun kaunutan nug belian mukaꞌ su ngag duma kaunutan nu getaw Judea, miksabutsabut ilan dig bian nilan mekpatay dini Isus. ");
INSERT INTO syb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Benaꞌ mitubus ilan meksabutsabut, pibalud nilan si Isus, dayun nilan egakay ditu ni Pilato, su gubirnadur tinduꞌ nu nga getaw Roma, pigwakil nilan dayun diniin si Isus. ");
INSERT INTO syb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Naa kini si Judas, su tuminipu dini Isus kiin, benaꞌ misuunanen puꞌ inukuman si Isus lagaꞌ na ginaanen, migbiksuꞌ dun. Saꞌ maꞌnia, minangay ditu Pengedapan tu Megbebayaꞌ, dayun ki telu puluꞌ laad siin pelata kiin, inuliꞌen ditu nga kaunutan nug belian kampuꞌ nu ngag duma kaunutan. ");
INSERT INTO syb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kaliꞌ pektaluꞌ si Judas, “Masiꞌ mikesalaꞌu, puꞌ ki getaw ndaꞌi salaꞌen, misabaꞌu ukuman lagaꞌ na ginaanen!” “Naa, tinibabaꞌ mu laꞌa!” simbag nu nga kaunutan kia. “Yami, ndaꞌig labet nami dun.” ");
INSERT INTO syb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tinikpuꞌ dayun ni Judasi kwarta kia dia saleg nu Pengedapan, migawaꞌ dayun dia. Minangay dayun megeget si Judas, miksilengek. ");
INSERT INTO syb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Naa su kepalus ni Judas, pingimud nu nga kaunutan nug belian ki kwarta kia tinikpuꞌ ni Judas dia saleg. “Naa kini,” laung nilan, “binandu ditu Misulat Palinta nu Megbebayaꞌ saꞌ melamug di gemutan di Pengedapan tu Megbebayaꞌ, puꞌ tindan di kebinasa di getaw.” ");
INSERT INTO syb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Saꞌ maꞌnia, migyagayaga ilan, iin dayuni pidelendem nilan, duunig lupaꞌ seluyen nilan, lupaꞌ nu mendiun gulen, puꞌ baalen nilan kelebengan di ngag lain getaw, saꞌitada su kanaꞌ dangen dia Jerusalem. ");
INSERT INTO syb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kaas sampay nemun, kig lupaꞌ kia, piningalan dun nu getaw, “Lupaꞌ nu Kegbinasa di Getaw.” ");
INSERT INTO syb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Naa saꞌ misaluyig lupaꞌ kia, iin nai kebianen, minuud su sinulat dengantu nu pimuunan nu Megbebayaꞌ si Jeremias ditu Taluꞌen, laungen, “Inalap nilan ki telu puluꞌ laad siin pelata, su pilegaꞌan nu getaw Israel diniin, ");
INSERT INTO syb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","dayun iinig bayad nilan tug lupaꞌ nu mendiun gulen, maaꞌ dadema nu sinuguꞌ nu Kaunutan Megbebayaꞌ dinaan.” ");
INSERT INTO syb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Naa mendadi, minadap si Isus ditu ni Gubirnadur Pilato kia, dayun sinaakanen. Suminaak si Pilato dini Isus, “Naa, metuud ba, yaꞌa su gadiꞌ nu getaw Judea?” Kaliꞌ sembag si Isus, “Yaꞌa mai miktaluꞌ dun.” ");
INSERT INTO syb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Melaun dayun inaleg nu nga kaunutan nug belian mukaꞌ nug duma kaunutan nu getaw Judea dini Isus. Laak dagid ndaꞌ gusay sembag si Isus tu kelaun dangat nilan diniin. ");
INSERT INTO syb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Sinaak pelum ni Pilato dini Isus, “Ndaꞌ mu ba medengegi melaun dangat nilan kini diniꞌa?” ");
INSERT INTO syb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Laak dagid ndaꞌ gusay sembagay ni Isus ki kelaun dinangat kia. Mipatiꞌ mesebuꞌay dun su gubirnadur kia. ");
INSERT INTO syb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Naa tauntaun, metaang dig Lumpuk kiin nu getaw Judea gindan tug Liniusan, duunig betad nu gubirnadur, beluyeneni sala tawan pinikutan, adini ubugen diniin nu melaun getaw. ");
INSERT INTO syb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Naa su taun kia, mitaang dema duuni sala tawan pinikutan, ngalanen si Isus Barabas, melaat gupiaig dengeganen. ");
INSERT INTO syb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Naa mendadi, benaꞌ mikpungun su nga melaun getaw, sinaak dayun ni Pilato dinilan, “Mendadi, taꞌ taway duni mauyaꞌan niu beluyen ku diniu? Si Isus Barabas ba, saꞌ si Isus kini, ki gilal Tinduꞌ nu Megbebayaꞌ Meglekaunutan?” ");
INSERT INTO syb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Iini tinaluꞌ dun ni Pilato maꞌnia, puꞌ misuunanen, kaas pa dinangat diniin nu nga kaunutan nu getaw Judea si Isus, puꞌ misigi mailan diniin. ");
INSERT INTO syb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Naa keduaꞌen, selian ni Pilato megingkud dia pengukuman, duuni pimuun nu sawanen diniin, laungen, “Ki getaw kiin ndaꞌi salaꞌen, ndiꞌa dema tuꞌu megduma di kaukum dun. Puꞌ duuni teginepen ku kagebii mekatag diniin, milegenanu dun patiꞌ!” ");
INSERT INTO syb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Laak dagid ki nga kaunutan nug belian kampuꞌ nug duma kaunutan nu getaw Judea, pingmetuudan nilan su melaun getaw, adun ubugen nilan dini Pilato, iinig beluyen si Barabas. Kini si Isus, petain. ");
INSERT INTO syb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Naa saꞌ maꞌantu, sinaak puliꞌ ni Pilato di nga melaun getaw, “Naa taꞌ ma, adin ma dun dig duaꞌ tawan kiai mauyaꞌan niu beluyen ku diniu?” Sumimbag ilan, “Si Barabas!” ");
INSERT INTO syb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Mendadi, suminaak puliꞌ si Pilato tu nga getaw, “Saꞌ maꞌantu, taꞌ mai penggulaulaan ku dini Isus kiin, ki gilal Tinduꞌ nu Megbebayaꞌ Meglekaunutan?” “Lensangen di kurus!” simbag nu nga kelaun getaw. ");
INSERT INTO syb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Sinaak na pelum ni Pilato, “Mauma, alandun bai salaꞌen?” Laak migdegadega ilan memeksay, laung nilan, “Ki getaw kiin, lensangen ba di kurus!” ");
INSERT INTO syb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Naa si Pilato, misabuten puꞌ palu pa mpalinig delendeman nu nga melaun getaw kia, ndiꞌ na daan, buus menlimuuk ilan. Naa saꞌ maꞌnia, minalap tubig si Pilato, dayun mingingenaw dia gedapan nu melaun getaw, dunut miktaluꞌ, “Naa kia, saꞌ petaini getaw kia, naan, ndaꞌig labetu dun! Daniu da pegbayaꞌ!” ");
INSERT INTO syb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Migdengan dayun sumbag su nga kelaun getaw, “Waꞌa, danami da pegbayaꞌ, sampay megbalaꞌ di nga sapuꞌ nami!” ");
INSERT INTO syb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Naa saꞌ maꞌantu, biluy tuꞌu ni Pilato si Barabas ditu nga melaun getaw. Kini si Isus, pibadasen, dayunen pegwakil tu nga sundalu, adun lensangen nilan di kurus. ");
INSERT INTO syb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Naa saꞌ maꞌantu, inagak si Isus nu nga sundalu nu gubirnadur, si Pilato, tug balayen. Piglidungan dayun si Isus nu kelaunan sundalu. ");
INSERT INTO syb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Benaꞌ miktabuꞌ ilan dini Isus, piluas nilan su suuben, piselukan nilan dayun melambung suub gempula, tautau suub gadiꞌ. ");
INSERT INTO syb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Mukaꞌ miglingkin ilan dugi, tautau tundek gadiꞌ dadema, dayun nilan peselup di gulu ni Isus. Piwidan nilan dayun seputuk belaw dig lintunen, tautau bastunen, dayun minginlulud ilan di gedapanen, dunut piksudiꞌan nilan, laung nilan, “Naa mpianan ka, Sir, Gadiꞌa daw nu nga getaw Judea!” ");
INSERT INTO syb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Pindulaꞌan pa nilan padun si Isus, dayun inawiꞌ nilan pelum diniin kig belaw kia, pimentul nilan dayun di gulu ni Isus. ");
INSERT INTO syb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mendadi, benaꞌ mitubus nilan peksudiꞌay, piluas nilan diniin su gempula suub, piseluk nilan puliꞌ diniin sug daniin suub. Dayun nilan egakay si Isus ditu tandaꞌ lensangan nilan dun di kurus. ");
INSERT INTO syb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Mendadi, benaꞌ mipalus nailan dia syudad, duuni misungkak nilan getaw Cirene, ngalanen si Simon, iini tigel nu nga sundalu mekpisan tu kurus ni Isus. ");
INSERT INTO syb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Naa saꞌ maꞌantu, midepet ilan dia dapit nu syudad piningalan dun “Tulan Gulu.” Saꞌ dig danilan pikebitan, Golgota. ");
INSERT INTO syb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Benaꞌ minateng ilan dia, duuni piꞌinum nu nga sundalu dini Isus penginumen limugan gempait bulung. Laak dagid benaꞌ miꞌinaman ni Isus, mipauk minum dun. ");
INSERT INTO syb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Dayun nilan lensangay tu kurus si Isus. Benaꞌ milansang na tu kurus si Isus, piktali nu nga sundalu su nga penepetenen, bian nilan mekilas dun. ");
INSERT INTO syb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Dayun mimegingkud dia su nga sundalu, pegingaten nilan si Isus dia kurus. ");
INSERT INTO syb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Naa duuni tuꞌus pidekep nilan dia tandaꞌ nug dimpulunen, sinulatan sumbungan diniin, “Kini si Isus, su Gadiꞌ nu getaw Judea.” ");
INSERT INTO syb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mukaꞌ pa pagid duunig duaꞌ tawan tulisan piduma nilan dini Isus lensangay di kurus, miktimpang di kurus ni Isus su kurus nilan. ");
INSERT INTO syb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Naa su nga getaw minian dia, pingimusaungan nilan si Isus, miktakuꞌtakuꞌ ilan, dunut teluꞌen nilan, ");
INSERT INTO syb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Yaꞌa mai miktaluꞌ puꞌ gebaꞌen mu su Pengedapan tu Megbebayaꞌ, dayun gikteb telu endaw, baalen mu puliꞌ! Naa saꞌ maꞌnia, gawen mu nandawig lawas mu, saꞌ yaꞌa tuꞌu sug Bataꞌ nu Megbebayaꞌ! Penauga di kurus kiin!” ");
INSERT INTO syb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ki nga kaunutan nug belian mukaꞌ su nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, kampuꞌ nu ngag duma kaunutan nu getaw Judea, maꞌantu dadema, pingimusaungan da nilan dema si Isus, laung nilan, ");
INSERT INTO syb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Paa, megaganen daw megaweni ngag lain getaw, laak ndiꞌen pelum megaga guunayig lawasen! Naa ki Gadiꞌ daw nu nga getaw Israel, melengas saꞌ menaug ma nandaw di kurus kiin, dekag paita pekpetuud diniin! ");
INSERT INTO syb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Suminalig daw tu Megbebayaꞌ. Saꞌ maꞌantu, melengas guunen na sia nandaw nu Megbebayaꞌ, saꞌ mauyaꞌanen da. Puꞌ tinaluꞌen ma, ‘Naanig Bataꞌ nu Megbebayaꞌ.’” ");
INSERT INTO syb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Sampay sug duaꞌ tawan tulisan dumanen linansang di nga kurus, maꞌantu dadema, pingimusaungan dadema nilan si Isus. ");
INSERT INTO syb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Naa su kelansang dini Isus tu kurus, benaꞌ miktui gendaw, tekaw dumilemi tibuuk benwa, duun saani telu uras, sampay miginengaꞌ menaugi gendaw. ");
INSERT INTO syb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Mendadi, benaꞌ miginengaꞌ menaugi gendaw, minekeg megbeksay si Isus, laungen, “Eli, Eli, lama sabaktani?” Maꞌananen, “Uu Megbebayaꞌ pektemuyen ku, Megbebayaꞌ pektemuyen ku, mauma bilengan mau tuꞌu?” ");
INSERT INTO syb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Midengeg nu ngag duma getaw pegindeg dia, kaliꞌ ilan pektaluꞌ, “Naa, tuaganen si Elias dengantu!” ");
INSERT INTO syb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Duun dayuni gumibek malap maaꞌ palas napes, inulemen dayun di penginumen, tinangenen di gayu tigbaw, pisangalen dayun dig babaꞌ ni Isus adun meseksepen. ");
INSERT INTO syb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Dagid laung nu ngag duma getaw, “Ala, pegbentayan ta pa deliꞌ, kalukalu lumusad na buus si Elias, adun gumawen diniin!” ");
INSERT INTO syb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Mendadi si Isus, benaꞌ mitubus megeksep di penginumen kia, migbeksay dayun puliꞌ mainsan, metenug. Dayun megetusi ginaanen. ");
INSERT INTO syb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Naa mendadi, su kurtina bilet ditug dialem nu Pengedapan tu Megbebayaꞌ, masiꞌ mitekaw meginengaꞌ megedit, genat diin dapit ditaas sampay ditu geksiden diin dapit silung. Miglinug dayun, mimegbektik pa paduni nga genduk. ");
INSERT INTO syb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mukaꞌ melaun lebeng mipukaꞌ, kig libengan nga piglegetawan nu Megbebayaꞌ, pitubuꞌ ilan puliꞌ. ");
INSERT INTO syb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Mimegawaꞌ ilan dayun diag lebeng nilan, naa benaꞌ mitubuꞌ puliꞌ si Isus, mipanaw ilan dayun tu Jerusalem, kaas minitaꞌ ilan nga melaun getaw dia. ");
INSERT INTO syb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Naa duuni kaunutan sundalu kampuꞌ nu nga sama sundalunen megingat dini Isus dia pa kurus. Benaꞌ mibetikan nilan sug linug dakus su kelaun mipenggulaula, mipatiꞌ ilan mendek. Mitaluꞌ nilan dayun, “Aa naa, masiꞌ metuud tuꞌu, ki getaw kini, iin sug Bataꞌ nu Megbebayaꞌ!” ");
INSERT INTO syb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Melaun pa pagidi ngag libun dia mesempel, pegbantay dailan dema, ilan su tumindug dini Isus genat ditu Galilea, puꞌ miktagikul ilan diniin. ");
INSERT INTO syb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Telu tawan dinilan, si Maria Magdalena, mukaꞌ si Maria su ginaꞌ ni Santiago mukaꞌ ni Jose, mukaꞌ su sawa ni Sebedeo, su ginaꞌ nu sala Santiago mukaꞌ ni Juan. ");
INSERT INTO syb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Naa benaꞌ sungu na mesindepi gendaw, duuni getaw minateng dia genat tug lunsud Arimatea, ngalanen si Jose. Iin kiin, medatuꞌ getaw, sakup dadema ni Isus. ");
INSERT INTO syb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Mendadi si Jose, minangay madap dini Pilato, inubugen diniin, elapenen sug bangkay ni Isus. Sinanguꞌ dadema ni Pilato, sinuguꞌen dayun pegwakil diniin. ");
INSERT INTO syb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Naa saꞌ maꞌantu, inalap ni Jose sug bangkay ni Isus. Benaꞌ mialapen, pinutusen dig begu penepeten gemputiꞌ. ");
INSERT INTO syb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Naa si Jose kini, duuni sangyab begunen peluakay di telektap, inandamen pedaan di kelebeng gupia diniin saꞌ matengi gumulen. Ditu dayun ni Jose libeng sug bangkay ni Isus. Benaꞌ milebengen, linuliden dayuni gembagel batu, tinakepen ditu gengaꞌan nug lebeng. Benaꞌ mitubus, minawaꞌ dia si Jose. ");
INSERT INTO syb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Naa si Maria Magdalena mukaꞌ su sala Maria, pegingkud pailan dia mesunguꞌan nug lebeng ni Isus. ");
INSERT INTO syb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Naa benaꞌ miksala gendaw, saꞌitada su Gendaw Pelali nu getaw Judea, ki nga kaunutan nug belian sampay su nga Pariseo, minadap ilan dini Pilato, ");
INSERT INTO syb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","kaliꞌ ilan pektaluꞌ diniin, “Naa Sir, milabuꞌ dig delendeman nami ki tinaluꞌ nug belusen getaw kiin su tetubuꞌ pa, laungen, ‘Di ketelu endawen genat di kepatayu, petubuꞌenu puliꞌ.’ ");
INSERT INTO syb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Naa kagina maꞌantu, Sir, melengas suguꞌen mu pepegenen kig lebengen kia sampay telu gebii, puꞌ kalukalu mbuus su nga sakupen, engain nilan pegdaaway sug bangkayen, dayun teluꞌen nilan tu melaun getaw, pitubuꞌ daw puliꞌ iin. Benaꞌ su tampusan balusen kia, melaaten pa ditug bekna.” ");
INSERT INTO syb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Kaliꞌ sembag si Pilato, “Naa, mesuꞌat, alap amu nga megingat dun, angay niu dayun pepegenay kig lebeng kia, gikteb di megaga niu.” ");
INSERT INTO syb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Naa saꞌ maꞌnia, mipanaw ilan, pipagen nilan sibaꞌ ki gembagel batu kia mitakep dig lebeng kia. Binaalan nilan gindanan sug bisuangan, adun mesuunan saꞌ buus iginen nu getawig batu kia. Mukaꞌ duun pa demai nga megingat binilin nilan dia. ");
INSERT INTO syb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Mendadi benaꞌ mipapas na su Gendaw Pelali, benaꞌ daliꞌ endaw na gendaw Duminggu, si Maria Magdalena mukaꞌ su sala Maria, linaawan nilan puliꞌ su sangyab libengan dini Isus. ");
INSERT INTO syb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mendadi, benaꞌ minateng ilan dia, mitekaw meglinug metikteg, puꞌ duuni sesuguꞌen nu Kaunutan Megbebayaꞌ luminusad genat tu gekbus langit. Benaꞌ mituaꞌ dia su getaw langit, mikpesempel dayun tu gembagel batu tinakep tu sangyab, linuliden dayun dia gupid nug bisuangan nu sangyab, migingkud dayun dig batu kia. ");
INSERT INTO syb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Naa su muluꞌ ni getaw langit kini, metinggas, maaꞌ nug delag nu gilat, dayun su penepetenen pa pagid, mekesulaw sabaꞌ nu keputiꞌen. ");
INSERT INTO syb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mendadi su nga getaw pelum piꞌingat diag libengan dini Isus, mipatiꞌ ilan saabay, midataꞌ ilan dayun, sabaꞌ mipendeenan ilan. ");
INSERT INTO syb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Laak kaliꞌ pektaluꞌ ki getaw langit kia tu ngag libun, “Naa, ndiꞌ amu mendek. Puꞌ misuunan ku, iini penengaun niu sia dini si Isus, kig linansang di kurus kitu. ");
INSERT INTO syb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Naa, ndaꞌ nain dini. Mitubuꞌ na puliꞌ, maaꞌ da nu gandang tinaluꞌen. Puꞌ seled amu dini, bentayay pa daan niu, kinuꞌ da sia sug bililidanen. ");
INSERT INTO syb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Naa, pemagas amu, laaway niu ganam su nga sakupen, ukitay niu dayun ilan, maꞌniniꞌi taluꞌ niu. ‘Si Isus, mitubuꞌ na puliꞌ. Mukaꞌ pa padun miguna na diniu ditu Galilea. Mpegitaꞌ da niu ditu!’ Naa, daal daitui pimuun dinaan petenday diniu.” ");
INSERT INTO syb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Maꞌantu, migdedaliꞌ megawaꞌ dia sangyab su ngag libun. Pia mindek ilan, mipatiꞌ ilan pagid penleliagay. Gumibek ilan dayun, puꞌ laawan nilan su nga sakup ni Isus, adun ukitan nilan dun. ");
INSERT INTO syb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mendadi benaꞌ dia pa dalan kig duaꞌ tawan libun kia, duuni mitekaw sumungkak dinilan dia gunaan nilan, masiꞌ si Isus. Kaliꞌ pektaluꞌ, “Gempia dai ginaa niu.” Naa, apelai. Ki ngag libun kini, mikpesempel ilan dini Isus, minginlulud ilan dayun dia gedapanen, piguidan nilani geksuden. ");
INSERT INTO syb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Laung ni Isus, “Naa, ndiꞌ amu mendek. Segaga laaway niu dayun su nga mimated dinaan kiin, iini taluꞌ niu dinilan, mundas ilan ditu Galilea, puꞌ sungkaken ku pailan ditu.” ");
INSERT INTO syb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Saꞌ maꞌantu, benaꞌ mipalus dia sangyabi ngag libun kia, su nga getaw kiin piꞌingat tug lebeng, mimeguliꞌ ilan ditu Jerusalem, inukit nilan dayun tu nga kaunutan nug belian su kelaun mipenggulaula kia. ");
INSERT INTO syb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Naa saꞌ maꞌantu, mikpungun su nga kaunutan nug belian dakus su ngag duma kaunutan nu getaw Judea, miksabutsabut ilan. Tinindanan nilan dayun su nga migingat dig libengan dini Isus kia, melaun kwarta bigay nilan dinilan, ");
INSERT INTO syb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","puꞌ adun megbalus ilan tu melaun getaw. Kaliꞌ pektaluꞌi nga kaunutan kini, “Naa, maꞌniniꞌi taluꞌ niu ditu melaun getaw. Taluꞌ niu dinilan, benaꞌ miglegebii, miktulug amu. Benaꞌ miktulug amu, naa su nga sakup ni Isus, mituaꞌ ilan ditu, dayun nilan pegdaaway, laung niu, kig bangkay ni Isus. ");
INSERT INTO syb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Laak dagid kalukalu mekeseled di telinga nu Gubirnadur puꞌ miktulug amu daw, naa yami laaki metau mengamuꞌ diniin, adun ndiꞌ amu mekendutaꞌ dun.” ");
INSERT INTO syb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Naa saꞌ maꞌantu, dinawat dayun nu nga migingat kia su kwarta, minangay ilan tuꞌu megukit dig balus, maaꞌ dadema nu pimuun dinilan kia. Kaas maꞌniai petuuden nu nga getaw Judea dakus peksigwagen nilan pa gusay, sampay nemun. ");
INSERT INTO syb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Maꞌantu, su nga sepuluꞌ buꞌ sala tawan sakup ni Isus, minundas ilan dayun tu salabuuk bentud ditu Galilea, ki gandang tinduꞌ ni Isus dinilan. ");
INSERT INTO syb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Benaꞌ minateng ilan diag bentud, mipekitaꞌ nilan tuꞌu si Isus, minginluꞌud ilan dayun diniin. Laak sug duma, migduaꞌduaꞌig delendeman nilan diniin. ");
INSERT INTO syb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Mendadi, mikpesempel dayun dia nga sakupen si Isus, kaliꞌ pektaluꞌ dinilan, “Ndaꞌiduni mesamaꞌ pegbayaꞌ di gekleb langit buꞌ lupaꞌ, migelaꞌ na gupia pegwakil dinaan. ");
INSERT INTO syb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Mendadi kagina maꞌantu, panaw amu, leep niu su kelaun bansa nu nga getaw, pesakup niu ilan dinaan. Bunagay niu ilan tubig, sembayay niu su Gamaꞌ mukaꞌ sug Bataꞌen sampay sug Balakat nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Petuꞌunay niu su kelaun bansa nu getaw, puꞌ adun petuuden nilan su taman nu pinalintau diniu.” Diksuꞌ ni Isus su taluꞌen, “Mukaꞌ ndiꞌ niu selingaway ini. Naani dumuma gusay diniu, sampay ditu kelengkeb nug benwa.”");
INSERT INTO syb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Mendadi, kini su Gempia Petenday mekatag dini Isukristu, kig Bataꞌ nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Duuni sala tawan dengantu pimuunan nu Megbebayaꞌ, si Isaias. Sinulat ni Isaias ki tinaluꞌ nu Megbebayaꞌ ditug Bataꞌen kiin, laungen, “Miktaluꞌ su Megbebayaꞌ, ‘Mendadi, paunaan ku diniꞌa ki pemuunan ku, puꞌ adun pengendamenen sug bianan mu.’ ");
INSERT INTO syb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Duuni getaw mektawag diag limawaꞌ, laungen, ‘Pengendamay niu sug bianan nu Kaunutan Megbebayaꞌ, pelegdeng niu kig dalanen!’” ");
INSERT INTO syb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Naa mendadi, minuud ki sinulat kia ni Isaias, mituaꞌ tuꞌui sala tawan, si Juan, diag limawaꞌ. Kini si Juan, pimbunaganen tubig su nga getaw mukaꞌ miktituluꞌ dinilan. Kaliꞌ pektaluꞌ si Juan, “Peksikesuun amu, mukaꞌ pekpebunag amu tubig tuꞌus dun, adun pedesunen nu Megbebayaꞌ ki salaꞌ niu.” ");
INSERT INTO syb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Mendadi, melaun getaw sakup prubinsya Judea sampay getaw Jerusalem minangay mekineeg ditu ni Juan. Pigukit nilan su nga salaꞌ nilan, mukaꞌ mikpebunag ilan dayun diniin tubig ditug lawas Jordan. ");
INSERT INTO syb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Naa kini si Juan, penepetenen ki ginabel bembul petubuꞌen kamelyu. Sug bakesen, panit dadema petubuꞌen. Ki gaanen, gapan mukaꞌ teneb. ");
INSERT INTO syb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Mendadi, kaliꞌ pegwali tu nga getaw si Juan, laungen, “Duuni sungu metuaꞌ, mbinayaꞌ pa dinaan, laak pia maꞌantu, metaas pai ginuungen batul danaan. Pia su sepatusen, kanaꞌu mbantang megdungguꞌ megubad dun diniin. ");
INSERT INTO syb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Puꞌ naan kini, megbunagu laak tubig diniu. Dagid iin, bunagenen diniu kig Balakat nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Naa mendadi kini si Isus, su saanan ni Juan memunag tubig tu nga getaw, mituaꞌ na tuꞌu ditu ni Juan, genat tug lunsud Nazaret, sakup prubinsya Galilea. Mikpebunag dini Juan tubig diag lawas Jordan. ");
INSERT INTO syb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Lemen laak mikegawen si Isus dia tubig, minitaꞌen mipukaꞌ sug langit, mukaꞌ sug Balakat nu Megbebayaꞌ, luminusad, miglanguban di maꞌniin palas limuun, minapun dayun diniin. ");
INSERT INTO syb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Duun dayuni miktaluꞌ ditug langit, laungen, “Yaꞌai petailen ku Bataꞌu, leliagenu gupia diniꞌa.” ");
INSERT INTO syb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mendadi kini si Isus, benaꞌ mibunagan na ni Juan tubig, iwit dayun nug Balakat nu Megbebayaꞌ tug limawaꞌ. ");
INSERT INTO syb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Paat puluꞌ gebii dia si Isus, pingindanan namal ni Satanas. Naa kig benwa kia, pegbenwanan mekekaꞌid metetubuꞌ. Dagid duuni nga sesuguꞌen nu Megbebayaꞌ getaw langit mituaꞌ, pigebangan nilan si Isus. ");
INSERT INTO syb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Laak si Juan kiin, masiꞌ pinirisu. Saꞌ mipirisu na si Juan, kini si Isus, mipuliꞌ ditu Galilea, migukit dayun di Gempia Petenday genat tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Miktaluꞌ si Isus, “Naa mitektak na tuꞌu su sesaꞌ. Ki Keglekaunutan nu Megbebayaꞌ, pikpuunan na! Mendadi peksikesuun amu, petuud niu ki Gempia Petenday!” ");
INSERT INTO syb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Naa duuni gendaw mikpanaw si Isus dia geksid Linaw Galilea. Sinegayen mpanaw, duunig duaꞌ tawan menelisedaꞌ mipegitaꞌen, si Simon mukaꞌ su pateden si Andres, pekpenadap ilan diag linaw. ");
INSERT INTO syb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Mendadi sinabi ilan ni Isus, laungen, “Pegdunut amu dinaan. Kanaꞌ na sedaꞌi peglaaman niu, puꞌ getaw na, adun sumakup ilan dinaan.” ");
INSERT INTO syb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Lemen laak midengeg nug duaꞌ tawan kini su tinaluꞌ ni Isus, bileng nilan dayun su sadap nilan, migdunut ilan tuꞌu dini Isus, suminakup nailan diniin. ");
INSERT INTO syb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Naa benaꞌ minundas kemaikaꞌ si Isus, duun pelumi mipegitaꞌen duaꞌ tawan mekpated dadema, si Santiago mukaꞌ si Juan, gamaꞌ nilan si Sebedeo. Dia ilan duaꞌ sekayan nilan, pengendamen nilan su pukut nilan. ");
INSERT INTO syb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kaliꞌ ilan maitaꞌ ni Isus, inggaten ilan sumakup diniin. Luminusad ilan dayun, binilin nilan dayun dia sekayan su gamaꞌ nilan kia si Sebedeo, dumanen laak su nga tinindananen. Dayun ilan megdunut dini Isus, suminakup nailan dema diniin. ");
INSERT INTO syb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Naa minundas si nga Isus ditug lunsud Capernaum. Benaꞌ su Gendaw Pelali, miditu si Isus simbaan nu nga getaw Judea, dayun mikpetuꞌun dia. ");
INSERT INTO syb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Saꞌ mikpetuꞌun si Isus, misebuꞌan su getaw, puꞌ su tituluꞌanen, duuni pegbayaꞌen. Saꞌ iini mektituluꞌ dinilan su nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, naa mamaꞌ ndaꞌi pegbayaꞌ nilan. ");
INSERT INTO syb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mendadi, saanan ni Isus mekpetuꞌun, tekaw duuni getaw sumiled dia simbaan, piglegetan menulay. Miktegas dayun, laungen, ");
INSERT INTO syb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Ii, yaꞌa Isus kiin, getaw Nazaret, taꞌ maig labet mu dinami? Midiniin ka ba mekpatay dinami? Mailalau yaꞌa, yaꞌa ma su Pimiliꞌ nu Megbebayaꞌ!” ");
INSERT INTO syb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pimaag ni Isus su menulay, laungen, “Naa ndiꞌa pesasak! Pegawaꞌa di getaw kiin!” ");
INSERT INTO syb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Naa ki menulay kini, pisedileni getaw kia, miktegas mainsan, dayun tuꞌu megawaꞌ diniin. ");
INSERT INTO syb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mendadi su kelaun getaw dia, misebuꞌan ilan dun gupia. Laung nilan, “Alandun ini? Begu tituluꞌan masiꞌ ini? Ki getaw kini, pia su menenulay, duuni pegbayaꞌen mesuguꞌen, mekpetuud ilan dayun diniin!” ");
INSERT INTO syb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kaas genat itu, misempun megleleep ditu tibuuk Galilea sug dengegan ni Isus. ");
INSERT INTO syb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Naa benaꞌ gumiwaꞌ si nga Isus dia simbaan nu getaw Judea, minangay ilan ditug balay ni Simon mukaꞌ ni Andres, duma nilan si Santiago mukaꞌ si Juan. ");
INSERT INTO syb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mendadi mitaang dun dema, pegladu ki penugangan ni Simon libun, mipanas. Mendadi, dekag mitulan si Isus, inukit dayun diniin su pegladu kia. ");
INSERT INTO syb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Mikpesempel dayun si Isus di pegladu kini, dayunen peguiday di kemet, biwaten. Migwanan dayuni panasen. Migbuat sug libun mukaꞌ mikpelutuꞌ, migilak dayun dini nga Isus. ");
INSERT INTO syb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Naa benaꞌ sungu na mesindepi gendaw, pinguit nu nga getaw ditu ni Isus su nga kelaun pegladu dakus su nga piglegetan menenulay. ");
INSERT INTO syb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mukaꞌ su kelaunan getaw dig lunsud kia, mikpungun ilan diag liu nug balay kia tinuunan ni Isus. ");
INSERT INTO syb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Dayun pineguliꞌan ni Isusi melaun getaw, migininisan naig leduunen. Mukaꞌ melaun padun piglegetan menenulay, pingutidan ni Isus dinilan su menenulay. Laak ndaꞌen begay mektaluꞌtaluꞌ su menenulay, puꞌ adun ndiꞌ nilan pesuun ki gasal ni Isus. ");
INSERT INTO syb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Naa benaꞌ miksala gendaw, daliꞌ endaw pa tanan, milapus megbuat si Isus, migawaꞌ diag balay. Miditug limawaꞌ, adun menenabi dia. ");
INSERT INTO syb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Laak dagid si nga Simon, mipanaw dailan dema, penengaun nilan si Isus. ");
INSERT INTO syb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Naa benaꞌ mibaangan nilan, laung nilan, “Sir, penengaun ka ma nu ngag launan getaw.” ");
INSERT INTO syb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kaliꞌ sembag si Isus, “Mundas ita pelum ditu ngag lain lunsud dig lumibut benwa kini, puꞌ adun megwali pau pagid ditu, puꞌ iini luminusadu dun dinig lumbang.” ");
INSERT INTO syb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Naa saꞌ maꞌantu, lineep dayun ni Isus su tibuuk prubinsya Galilea, migwali dia nga simbaan nu getaw Judea, mukaꞌ pingutidanen di getawi menenulay. ");
INSERT INTO syb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mendadi duuni getaw pegladu mekesalebuꞌ nuka mikpesempel dini Isus, minginlulud dayun di gedapanen, kaliꞌ penengi diniin, laungen, “Sir, saꞌ mauyaꞌan mu da, misuunan ku megaga mau pauliꞌay.” ");
INSERT INTO syb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Milelaat dayun si Isus di pegladu kia. Tinggaleni kemeten, dipenaneni getaw kia, kaliꞌ pektaluꞌ, “Naa, mauyaꞌan ku lai. Mauliꞌan ka dadema tuꞌu!” ");
INSERT INTO syb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Seduꞌunduꞌun dayun miawaꞌi mekesalebuꞌ nukanen, miseksud dun tuꞌu sug daan lawasen. ");
INSERT INTO syb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Mendadi, pipanaw dayun ni Isus su kamun pegladu, ");
INSERT INTO syb_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","laak inunguben pa gupia, laungen, “Petuud mu gupiai taluꞌu kini diniꞌa. Pia sala tawan, ndaꞌiduni ukitan mu di mipenggulaula kini. Segaga angaya ditug belian, pekpebantaya diniin, dayun ilak mu sug betang pinalinta ni Moises dengantu puꞌ adun metakesiꞌan ka nu getaw, miawaꞌ na su kelemuꞌay mu.” ");
INSERT INTO syb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Naa saꞌ maꞌantu, mipanaw dayun su getaw, laak palu pa miunguben, ndaꞌ. Minamal megukit ditu mipenggulaula diniin, sinigwagen sungkin su gukitan dun. Kaas genat itu si Isus, ndiꞌ na mesuꞌat mekpaitaꞌ ditu ngag lunsud, ditu na laak pegbebenwa limawaꞌ. Laak dagid pia maꞌantu, pinemalan da gusay peglaaway nu nga getaw dig lumibut benwa kia. ");
INSERT INTO syb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Naa duuni santaꞌ gebii, mipuliꞌ si Isus ditu Capernaum. Naa benaꞌ misuunan nu nga getaw diag lunsud puꞌ dia na balay si Isus, ");
INSERT INTO syb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","melaun dayun getaw mikpungun dia, ndaꞌ megelaꞌ diag dialem balay su nga getaw. Mikeet dadema sug lenuꞌan. Pigukit dayun ni Isus dinilan su Gempia Petenday. ");
INSERT INTO syb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mendadi saanan ni Isus megukit, duuni nga getaw minateng, pegbuligan nilan di sinampuyuan ki pilung, paat tawani pegbulig dun. ");
INSERT INTO syb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Naa sabaꞌ nu melaun getaw, ndiꞌ mesuꞌati kekpesempel nilan dini Isus. Laak kaliꞌ ilan pegleketau, minaik ilan ditu gatep, giwangan nilan dayun su gatep dia tandaꞌ ni Isus. Saꞌ miguangan na nilan, tintun nilan dayun su pilung, dia da gusay sinampuyuan nilan dun. ");
INSERT INTO syb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Mendadi si Isus, benaꞌ minitaꞌen ki kesalig nilan diniin, miktaluꞌ di pilung kia, “Naung, pidasun na su salaꞌ mu.” ");
INSERT INTO syb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Naa, duun pelumi nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, pegingkud ilan dia. Mendadi ki nga mekpetuꞌun kini, benaꞌ midengeg nilan ki tinaluꞌ kia ni Isus, kaliꞌ ilan taluꞌ dig dialem delendeman nilan, ");
INSERT INTO syb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Paa, ki getaw kini, mauma dema mekakuꞌ mektaluꞌ di maꞌnini? Piksudiꞌanen pelum su Megbebayaꞌ! Taꞌ mai mekepedasun di salaꞌ, subay su laak Megbebayaꞌ?” ");
INSERT INTO syb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Misuunan dayun ni Isusig dialem nug delendeman nilan kia. Kaliꞌ dayun pektaluꞌ dinilan, “Mauma dema maꞌniini teluꞌen niu dig dialem delendeman niu? ");
INSERT INTO syb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Puꞌ saꞌ su kilawan laak, melemu pebelusen saꞌ teluꞌenen tu mipilung, ‘Pidasun na su salaꞌ mu.’ Melemu dadema pebelusen saꞌ teluꞌenen, ‘Pegbuata, sikwat mui sinampuyuan diniꞌa kiin, panawa dayun.’ ");
INSERT INTO syb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Dagid naan kini, luminusad nau, miksibaluyu Bataꞌ nu Kilawan. Saꞌ maꞌantu, paitaꞌu diniu puꞌ duuni pegbayaꞌu mekpedasun di salaꞌ dinig dibabaw lumbang.” Luminingay dayun si Isus tu pilung mukaꞌ miktaluꞌ diniin, ");
INSERT INTO syb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Naa, taluꞌu tuꞌu diniꞌa, pegbuata, sikwat mui sinampuyuan diniꞌa kiin, mukaꞌ uliꞌa!” ");
INSERT INTO syb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Suminambut tuꞌu megbuat su mipilung kia, sinikwaten su sinampuyuan diniin kia, dayun mipanaw dia gedapan nu kelaunan getaw. Naa saꞌ maꞌnia, mipatiꞌ ilan gupia mesebuꞌay dun dunut mipenalan nilan gelaꞌ su Megbebayaꞌ, laung nilan, “Kitu nai kaibenen, iin pa ta maitaꞌi mipenggulaula maꞌnini kini!” ");
INSERT INTO syb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Naa mipanaw na pelum si Isus, mipuliꞌ ditu geksid Linaw Galilea. Benaꞌ melaun gupia getaw mikpungun ditu niin, piktuꞌunanen ilan dayun. ");
INSERT INTO syb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Benaꞌ mipanaw na puliꞌ si Isus, duuni mipekitaꞌen sala tawan mendawat buis pegingkud diag bataꞌ gupisinanen, ngalanen si Levi, gamaꞌen si Alfeo. Sinabi ni Isus si Levi, laungen, “Dunuta dinaan.” Benaꞌ midengeg ni Levi, migbuat dayun, migdunut tuꞌu dini Isus, suminakup na diniin. ");
INSERT INTO syb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Naa duuni gendaw, si Isus mukaꞌ su nga sakupen, minaan ilan diag balay ni Levi kia. Melaun mendawat buis mukaꞌ duma mekesesalaꞌ getaw dumingan dinilan maan. Puꞌ melaun getaw maaꞌ danilan betad suminakup na dini Isus. ");
INSERT INTO syb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Naa mitaang dun, dia dademai nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, sakup ilan nu pikumpungan nu getaw Judea piningalan dun nga Pariseo. Mendadi ki nga mekpetuꞌun kini, benaꞌ minitaꞌ nilan si Isus dumingan maan di nga mendawat buis mukaꞌ di ngag duma mekesesalaꞌ getaw, sinaakan nilan dayun su nga sakup ni Isus. Laung nilan, “Paa, mauma dema dumingan main maan di nga getaw, maꞌniaig betad nilan?” ");
INSERT INTO syb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kaliꞌ medengeg ni Isus su sinaak nilan, simbagen, “Naa su getaw ndaꞌig leduunen, ndiꞌ kambat mekpebulung, subay su laak duunig leduunen. Naa, naan kini, maꞌantu dadema, iini luminusadu dun dinig lumbang, adun pesikesuunen ku su laak mekesesalaꞌ getaw, kanaꞌ nu nga gandang mekesuun getaw.” ");
INSERT INTO syb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Naa duuni gendaw, su nga sakup ni Juan kiin su memunag tubig mukaꞌ su nga Pariseo, mikpuasa ilan. Mendadi duuni nga getaw minangay tu ni Isus, kaliꞌ ilan saak diniin, “Sir, mauma dema maꞌantu? Su nga sakup ni Juan mukaꞌ nu nga Pariseo, betad nilan, mekpuasa ma. Dagid su ngag daniꞌa sakup, ndiꞌ mailan mekpuasa.” ");
INSERT INTO syb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Kaliꞌ sembag si Isus, “Waꞌa daan, puꞌ penenggiꞌan dun sug belaꞌi. Su nga suminaup dig belaꞌi, kendutaꞌen ba nilan pekpuasa, saanan duma pa nilan su menginsawa? Sinegay duma pa nilan iin, ndiꞌ mailan mekpuasa! ");
INSERT INTO syb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Laak dagid, duuni gendaw mateng, uiꞌen na dinilan ki menginsawa, dekag pailan tuꞌu mekpuasa.” ");
INSERT INTO syb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Laung pagid ni Isus, “Mesama da saꞌ eklebani suub. Duun bai getaw, iini ekleben dig danul suuben kig begu gupia penepeten? Puꞌ saꞌ pinenggiꞌ pemaꞌantuunen, saꞌ mengeleeꞌ sug begu penepeten, mauguten dayun sug danul kia, benaꞌ megdegadega dayun su keliwag nu gediten. ");
INSERT INTO syb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Mukaꞌ pa pagid sug betad megbetang penginumen di pemetangan binaal panit petubuꞌen, maꞌantu dadema. Duun bai getaw megbetang begu penginumen dig daan pemetangan? Puꞌ saꞌ pinenggiꞌ maꞌnia, saꞌ tumulin su penginumen, ndiꞌ ba megbetu su panit petubuꞌen? Deksuꞌanen, megulaꞌ su penginumen, mukaꞌ meglaat dadema su pemetanganen. Kaas sug begu penginumen, subay begu dadema su pemetanganen.” ");
INSERT INTO syb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Naa duuni Gendaw Pelali, minayan si nga Isus di pegimulanan trigo. Naa selian nilan mayan dia, mikpuun su nga sakup ni Isus mengetes tu trigo. ");
INSERT INTO syb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mendadi ki nga Pariseo, benaꞌ minitaꞌ nilan su kengetes nu nga sakup ni Isus tu trigo, laung nilan diniin, “Paa, bentayay mu pa daan kig baalen ni nga sakup mu kiin! Ki Gendaw Pelali, binandu dinita ditu Misulat Palinta nu Megbebayaꞌ duunig baalen ta di gendaw kini!” ");
INSERT INTO syb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Kaliꞌ sembag si Isus dinilan, “Baa, pia da. Puꞌ si David kanugdiin, ndaꞌ ba niu mbasa su pinggulaulanen dadema saꞌ mitegelan ilan megutem, ilan nu ngag dumanen? ");
INSERT INTO syb_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Puꞌ sumiled si David ditug Balay Pengedapan tu Megbebayaꞌ, inaanen su pan ginilak tu Megbebayaꞌ, inilasanen dun padun su ngag dumanen. Su pinggulaulanen dun, timpu pa ni Abiatar, su Tampusan Metaas Belian nu getaw Judea. Asa binandu ditu Misulat Palinta nu Megbebayaꞌ duuni maan di pan kia, subay su laak ngag belian.” ");
INSERT INTO syb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Diksuꞌ ni Isus su sinumpaten di nga Pariseo, “Ki Gendaw Pelali, kanaꞌ iini biwat dun nu Megbebayaꞌ su kilawan, puꞌ adun pegbesaanen su Gendaw Pelali. Iin pasiꞌi pinain dun nu Megbebayaꞌ su Gendaw Pelali, adun mbaal pepia tu nga kilawan. ");
INSERT INTO syb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mendadi naan kini, kig Bataꞌ nu Kilawan, naani Kaunutan megbayaꞌ dig baalen nu kilawan, pia su metaang di Gendaw Pelali.” ");
INSERT INTO syb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Naa duuni gendaw, minangay na pelum si Isus di simbaan nu getaw Judea. Naa mitaang duuni getaw dia, mingupesi sedibaluy kemeten. ");
INSERT INTO syb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Naa ki ngag duma getaw dia, mauyaꞌan nilan, duun siai gempia dangat nilan dini Isus. Saꞌ maꞌantu, piktuliktulikan nilan gupia si Isus, saꞌ meneguliꞌ di getaw kia metaang di Gendaw Pelali, saꞌ ndiꞌ. ");
INSERT INTO syb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Mendadi, kaliꞌ pektaluꞌ si Isus di getaw kia mingupesi kemeten, “Naa, pediniin ka. Pegindega dini gedapan nug launan.” Minangay dayun dia niin. ");
INSERT INTO syb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Laung dayun ni Isus dia nga getaw menengaw dangat nilan diniin, “Taꞌ alandun mai biwang dinita ditu Misulat Palinta nu Megbebayaꞌ, baalen ta metaang di Gendaw Pelali? Pepianan ta bai samataw ta di Gendaw Pelali, atawaka pelaatan ta? Guunen ta su ginaanen, atawaka petain ta ba?” Laak ndaꞌiduni mesembag nilan dun. ");
INSERT INTO syb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Pingenlengan ilan dayun ni Isus, milaati ginaanen dinilan. Laak pia maꞌantu, milelaat dadema dinilan si Isus, sabaꞌ nu ketegas gulu nilan. Laungen dayun di getaw kia mingupesi kemeten, “Naa, tenggal mui kemet mu.” Tinggalen dayun, mukaꞌ miuliꞌan. ");
INSERT INTO syb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Naa ki nga Pariseo kini, benaꞌ minitaꞌ nilan, mingguaꞌ ilan dayun dia simbaan. Linaawan nilan dayuni nga sakup ni Herodes, migyagayaga ilan dayun, puꞌ genat itu, minengaw ilan bian nilan mekpatay dini Isus. ");
INSERT INTO syb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Naa saꞌ maꞌantu, migawaꞌ si Isus dia, ilan nu nga sakupen, minundas ilan ditu geksid Linaw Galilea. Melaun gupia getaw miglendug dini Isus. Kanaꞌ laak genat dia Galilea su getaw, puꞌ su ngag duma, genat ilan ditu Judea ");
INSERT INTO syb_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","mukaꞌ ditu Jerusalem. Saꞌ midengeg nu nga getaw su pinggulaula ni Isus, melaun pa pagidi getaw mituaꞌ genat tug Edumea, mukaꞌ tug dipag Jordan, sampay tug benwa lumibut dig lunsud Tiro mukaꞌ Sidon. ");
INSERT INTO syb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Mendadi, sinuguꞌ ni Isus su nga sakupen mangay sekayan, puꞌ galiꞌen adun gingkudanen saꞌ mbuus maisel nu melaun getaw. ");
INSERT INTO syb_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kagina melaun na getaw pineguliꞌanen, mikagawagaw mekpesempel diniin su ngag launan pegladu, adun medeluꞌ nilan si Isus. ");
INSERT INTO syb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mukaꞌ pa pagid, adini getaw piglegetan menulay, kaliꞌ nilan mpekitaꞌ si Isus, miglaub ilan di gedapanen, dunut migbeksay ilan, laung nilan, “Yaꞌa tuꞌuig Bataꞌ nu Megbebayaꞌ!” ");
INSERT INTO syb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Laak pimeek gupia ni Isus su menenulay, adun ndiꞌ nilan pesuun ki gasalen. ");
INSERT INTO syb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Naa, duuni gendaw tumiwad si Isus dig bentud. Adin su pimiliꞌen dumunut diniin, sinabinen. Minangay ilan dayun ditu niin. ");
INSERT INTO syb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Mendadi, tinduꞌ ni Isus ki sepuluꞌ buꞌ duaꞌ tawan peneliganen. Kaliꞌ pektaluꞌ si Isus, “Yamui pimiliꞌu dumunut dinaan. Mukaꞌ suguꞌen ku amu mpanaw, adun megukit amu tu Gempia Petenday. ");
INSERT INTO syb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Mukaꞌ pagid begayan ku amu pegbayaꞌ mengutid di menenulay.” ");
INSERT INTO syb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Naa, kinii sepuluꞌ buꞌ duaꞌ tawan tinduꞌ ni Isus peneliganen. Sug beknanen, si Simon (piningalan dun ni Isus si Pedro), ");
INSERT INTO syb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","dayun si Santiago mukaꞌ su pateden si Juan, gamaꞌ nilan duaꞌ si Sebedeo, (piningalan dun ni Isus si Boanerges, guluganen “Nga Getaw Maaꞌ Dedalak”), ");
INSERT INTO syb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","dayun si Andres, si Felipe, si Bartolome, si Mateo, si Tomas, si Santiago gamaꞌen si Alfeo, si Tadeo, dayun si Simon, sakup nu nga mengatu di gubirnu. ");
INSERT INTO syb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Mendadi su kesepuluꞌ buꞌ duaꞌen, iin si Judas Iscariote, su tumipu pa dini Isus. ");
INSERT INTO syb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Mendadi, minuliꞌ si Isus. Benaꞌ minuliꞌ, pikpungunan na pelum nga melaun getaw. Kaas si Isus mukaꞌ su nga sakupen, ndaꞌ naig lakay nilan, pia laak kaꞌaan nilan. ");
INSERT INTO syb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mendadi su ginaꞌ ni Isus dakus su nga pateden, benaꞌ midengeg nilan puꞌ mitegelan iin sabaꞌ nu kelaun getaw, linaawan nilan dayun, ulipiten nilan sia, puꞌ laung nu nga getaw, miktalintalin dawi ginaa ni Isus. ");
INSERT INTO syb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Naa ki nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, genat ilan ditu Jerusalem, pekteluꞌen nilan dadema mekatag dini Isus, “Aa, ki getaw kiin, pingepuꞌan ni Beelsebul! Kaas iini megaganen dun utidayi menenulay, puꞌ bigayan ginuung nu kaunutan nilan.” ");
INSERT INTO syb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Mendadi, sinabi ni Isus su nga getaw miktaluꞌ maꞌnia. Migwali dayun dinilan si Isus pebian di penenggiꞌan, laungen, “Naa saꞌ sia metuud ia, naa si Satanas, kendutaꞌenen ma dun pegutidig daniin lawas? ");
INSERT INTO syb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Puꞌ pinenggiꞌ duuni nasud meksimawiꞌ mukaꞌ megunay megbunuꞌ, ndiꞌ maiben metulag. ");
INSERT INTO syb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Samanen ki salapenan, saꞌ meksimawiꞌ mukaꞌ meksual, metulag dadema. ");
INSERT INTO syb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Maꞌantu dadema si Satanas. Saꞌ pinenggiꞌ meksimawiꞌ su peglegediꞌanen, dayun megunay megbunuꞌ, ndiꞌ ba metulag, deksuꞌanen, mbeleng? ");
INSERT INTO syb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Mendadi,” laung ni Isus, “ki getaw suled tug balay letaban getaw puꞌ adun elapenen su pimetangen, ndiꞌen malap su pimetangen, subay unaanen pa beluday kig letaban. Dayun saꞌ megaganen beluday kig letaban kia, naa megaganen na tuꞌu elapay ki pimetangen kia. ");
INSERT INTO syb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Taman taluꞌu diniu, su nga kelaun salaꞌ nu kilawan, pedesunen da, sampay su kelaun keksudiꞌ nu getaw tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Dagid adin su getaw peksudiꞌanen sug Balakat nu Megbebayaꞌ, kiin, ndiꞌ na pedesunen, puꞌ mikesalaꞌ dun sampay saumul.” ");
INSERT INTO syb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Kaas tinaluꞌ ni Isusi maꞌnia, puꞌ laung nug duma getaw, “Pingepuꞌan main menulay.”) ");
INSERT INTO syb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Naa su ginaꞌ ni Isus mukaꞌ su nga pateden, minateng nailan diag balay tinuunan ni Isus. Pegindeg ilan diag liu, pisabi nilan dayun si Isus. ");
INSERT INTO syb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Melaun getaw pegingkud dia, piglidungan nilan si Isus. Mendadi, pisuunan nilan dayun si Isus, laung nilan, “Sir, kia na liu su ginaꞌ mu mukaꞌ su nga pated mu, peksebiin ka nilan.” ");
INSERT INTO syb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Sumimbag si Isus, “Naa, waꞌa. Laak taway dun mai ginaꞌu? Mukaꞌ taway dun mai patedu?” ");
INSERT INTO syb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Pingenlenganen su nga getaw pegingkud migalidung diniin, kaliꞌ pektaluꞌ dinilan, “Kini paduni ginaꞌu mukaꞌ nga patedu! ");
INSERT INTO syb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Adini getaw megdunut tu mauyaꞌan nu Megbebayaꞌ, iin pa pagidi patedu, libun saꞌ laki, sampay ginaꞌu.” ");
INSERT INTO syb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Naa mikpuun na pelum si Isus mekpetuꞌun tu nga getaw ditu geksid Linaw Galilea. Laak sabaꞌ melaun gupia getaw mikpungun ditu niin, subay duminangan si Isus di sekayan diag linaw. Benaꞌ mikaingkud na dia sekayan, piktuꞌunanen dayun su nga getaw pemegindeg dia geksid linaw. ");
INSERT INTO syb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Melaun tinituluꞌ ni Isus dinilan pibian di sambingay. Kaliꞌ pektaluꞌ si Isus, ");
INSERT INTO syb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Pekineeg amu gupia! Duuni getaw minangay tug binaalanen adun megimula. ");
INSERT INTO syb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Laak benaꞌ saananen meksigwag, duunig beniꞌ mitenaꞌ ditug dalan, kaas pingektuk nu nga manukmanuk. ");
INSERT INTO syb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Naa duun dademai mitenaꞌ ditug betuan, menipisig lupaꞌ dun. Mintubuꞌ ganam sug beniꞌ, laak dagid kagina menipisig lupaꞌ dun, ");
INSERT INTO syb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","benaꞌ mipedesan, milawes. Mukaꞌ kagina gembabawi gangeten, minatay da pelum. ");
INSERT INTO syb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Naa duun pa pagidig beniꞌ mitenaꞌ dig dugian. Kaliꞌ pentubuꞌ su ngag dugi mukaꞌ tuminulin, milebeng dun su pimula. Kaas ndaꞌidunig bunganen. ");
INSERT INTO syb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Laak tumuꞌ kig duma beniꞌ, mitenaꞌ tuꞌu di pialupaꞌ, kaas mekelengasi tubuꞌen mukaꞌ tuminulin dayun, dakus mikegbunga gupia. Benaꞌ sumingkuꞌ, duuni piktelu puluꞌ, duuni pigenem puluꞌ, duun pagidi pingmegatus.” ");
INSERT INTO syb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Diksuꞌ dayun ni Isus su taluꞌen, “Adin sug duuni telinganen, mekineeg dema tuꞌu!” ");
INSERT INTO syb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Naa benaꞌ ilanilan na laak, mikpesempel dini Isus su sepuluꞌ buꞌ duaꞌ tawan peneliganen, dakus su ngag duma mektuꞌun tatapen petendugay. Mendadi, migubug su nga sakupen dini Isus pegulugenen dinilan ki nga sinambingayen. ");
INSERT INTO syb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kaliꞌ sembag si Isus dinilan, “Aa naa yamu, buasan na diniu su gandang pigbuni mekatag di kesakup tu Keglekaunutan nu Megbebayaꞌ. Laak dagid su ngag lain getaw, pebianen laak di sambingay su kegukit dun dinilan, ");
INSERT INTO syb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","adun menuud su misulat ditu Taluꞌ nu Megbebayaꞌ, laungen, ‘Menamal dailan mengenleng, laak ndiꞌ ilan mekengitaꞌ. Menamal dailan mekineeg, laak ndiꞌ ilan mekesabut. Puꞌ tekaw buus, laung nu Megbebayaꞌ, lumingay ilan puliꞌ sia dinaan, adun pedesunen ku su salaꞌ nilan.’” ");
INSERT INTO syb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kaliꞌ pektaluꞌ si Isus tu nga sakupen, “Masiꞌ ki sambingay kiin, ndaꞌ ba niu mesabut? Saꞌ maꞌnia, taꞌ ma demai kesabut niu dun su ngag duma sambingay? ");
INSERT INTO syb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mendadi, kig beniꞌ kiin, iin su Gempia Petenday genat tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Naa sug beniꞌ mitenaꞌ diag dalan, damikian dun su nga getaw, lemen laak nilan medengeg su Gempia Petenday kia, mateng dayun si Satanas, uaꞌenen pelum tug delendeman nilan su Gempia Petenday. ");
INSERT INTO syb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Naa su pelum beniꞌ mitenaꞌ diag betuan, iin su nga getaw lemen laak medengeg nilan su Gempia Petenday, telimaꞌen nilan dayun mukaꞌ penleliagen ilan dun. ");
INSERT INTO syb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Laak ndaꞌ pengganget dig delendeman nilan, kaas kanaꞌ maiben su kekpetuud nilan. Saꞌ matengi kelegenay nilan, saꞌitada saꞌ peglegetan ilan sabaꞌ nu kekpetuud nilan di Gempia Petenday, teliudan nilan dayun su kekpetuud nilan. ");
INSERT INTO syb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Naa sug beniꞌ mitenaꞌ dema dig dugian, iin su getaw tumuꞌ mikedengeg tu Gempia Petenday, ");
INSERT INTO syb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","laak dagid megelaꞌi ginaa nilan tu kelibuleng nilan tu kegleketubuꞌ nilan nemun mukaꞌ su gayak nilan tu gaꞌus, sampay tu gininisan delendeman kinilawan, kaas maulakanen su Gempia Petenday. Benaꞌ kig beniꞌ kia, ndiꞌ na megbunga. ");
INSERT INTO syb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mendadi kig beniꞌ mitenaꞌ dia pialupaꞌ, iin tumuꞌ su nga getaw mekedengeg tu Gempia Petenday dayun mektelimaꞌ ilan dun, kaas megbunga ilan. Sug duma, megbunga piktelu puluꞌ. Sug duma, pigenem puluꞌ. Sug duma, pingmegatus.” ");
INSERT INTO syb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kaliꞌ pagid pektaluꞌ si Isus, “Mendadi ki suluꞌ, duun bai getaw meguit dun dig dialem balay, dayunen uklubay bandi, atawaka betangenen tu silung belilidan? Ndiꞌen ba betangen tug dempaꞌani suluꞌ? ");
INSERT INTO syb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kaas adin su giglud nandaw, iini iglud dun deliꞌ, puꞌ adun buasan da saꞌ maiben. Adin su pigbuni nandaw, iini pigbuni dun deliꞌ, puꞌ adun pesuunen da saꞌ maiben. ");
INSERT INTO syb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mendadi, adin sug duuni telinganen, mekineeg dema tuꞌu! ");
INSERT INTO syb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Naa ki kelaunanen kini medengeg niu dini naan, talentenay niu gupia! Puꞌ adin su tepengan niu dig begay niu, iin dademai tepengan nu medawat niu genat tu Megbebayaꞌ, mukaꞌ dugangan pa padun. ");
INSERT INTO syb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Puꞌ adin su getaw duunig daniin, begayan pa padun. Adin pasiꞌ su getaw ndaꞌidunig daniin, laak uiꞌen diniin su maikaꞌ sia daniin.” ");
INSERT INTO syb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kaliꞌ gusay pektaluꞌ si Isus, “Ki ketulin nu Keglekaunutan nu Megbebayaꞌ, petanggiꞌu dig beniꞌ misigwag dig binaalan. ");
INSERT INTO syb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Su getaw mimula dun, gebii gendaw mektulug metanud, laak petuyangenen pa sug beniꞌ. Dagid tekaw memunsengit mukaꞌ tumulin sug beniꞌ, ndiꞌ mesuunan nu getaw sug bian nu ketubuꞌen. ");
INSERT INTO syb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Puꞌ sug lupaꞌi metau mekpetubuꞌ tu pimula dakus mekpebunga dun. Kaas bekna, mentaiꞌ. Ndiꞌ maiben, memensut. Dayun ndiꞌ maiben, meteken pelum, ndaꞌidun pa gusayi gabang dun nu getaw kia mimula dun. ");
INSERT INTO syb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Dagid lemen laak mainug, malap garab su getaw, puꞌ gempia na tuꞌu geniin.” ");
INSERT INTO syb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kaliꞌ pektaluꞌ si Isus, “Mendadi ki Keglekaunutan nu Megbebayaꞌ, alanduni tenggiꞌan ta dun? Taꞌ mai sambingay ta dun? ");
INSERT INTO syb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kinii pesemaan ta dun, ki salabuuk lisu sangay nu mustasa su ngalanen. Naa ki mustasa kiin, iini tampusan maikaꞌ lisu dig dibabaw lumbang. Laak genat pemulanay, ");
INSERT INTO syb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","saꞌ mentubuꞌ mukaꞌ tumulin, melebawanen su kelaun gininisan pimula, maꞌniin na bagel gayu. Mekpanga meketaas, kaas su nga manukmanuk, megbaal ilan salag nilan dia piktebenan nu nga panganen, sabaꞌ kebagelen.” ");
INSERT INTO syb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Mendadi, minamal si Isus megukit di Gempia Petenday tu nga getaw pibian di nga sambingay, su gikteb laak nu mesabut nilan. ");
INSERT INTO syb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ndaꞌiduni inukit ni Isus dinilan saꞌ kanaꞌ lumbus sambingay. Laak dagid benaꞌ ilanilan da laak nu nga sakupen, gilaꞌen da pengulugay dinilan su nga sambingayen. ");
INSERT INTO syb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Naa benaꞌ lelabung na, kaliꞌ pektaluꞌ si Isus tu nga sakupen, “Naa, dumipag ita dinig linaw.” ");
INSERT INTO syb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Naa saꞌ maꞌantu, bilengan nilan dayun su nga melaun getaw, duminangan su nga sakupen tu sekayan gandang pegingkudan ni Isus. Iwit dayun nu nga sakupen dumipag si Isus. Mukaꞌ duun dademai ngag duma sekayan duminipag. ");
INSERT INTO syb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mendadi, benaꞌ ditu nailan titengaꞌ laud nug linaw, tekaw miksalindapak, misipukan dayun tubig ki sekayan nilan kia, pekepenuꞌ na tubig. ");
INSERT INTO syb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Dagid si Isus, pektulug, migulunan, dia gulinan nu sekayan nilan. Tinanud dayun nu nga sakupen, laung nilan, “Ii, Sir, masiꞌ petuyangen mu na, pia megbayaꞌbayaꞌ ita dun ini?” ");
INSERT INTO syb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Migbuat si Isus, pimaagen dayun su genus, laungen, “Sikpaꞌa.” Tiluꞌanen pa pagid sug linaw, “Peksilengen ka.” Misikpaꞌ ki salindapak, miksilengen gupia tuꞌu sug linaw. ");
INSERT INTO syb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kaliꞌ pektaluꞌ si Isus dia nga sakupen, “Mauma mendek mamu? Masiꞌ ndaꞌidun pa gusay kesalig niu dinaan?” ");
INSERT INTO syb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Naa saꞌ maꞌnia, mipatiꞌ ilan gupia mendek. Kaliꞌ ilan peksinaakay, “Taꞌ gasal dun saan ini, pia su genus mukaꞌ nabek, mekpetuud diniin?” ");
INSERT INTO syb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Naa midengguꞌ si nga Isus tug dipag nug Linaw Galilea, ditug benwa paingalan dun Gerasa. ");
INSERT INTO syb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Benaꞌ mikelusad si Isus tu sekayan, duuni getaw suminungkak diniin, genat tu kelebengan. Ki getaw kini, silunuꞌan menulay, ");
INSERT INTO syb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","dia na pegbenwa nga sangyab kelebengan. Ndaꞌiduni getaw mekegaga megbalud diniin, pia kadinai giket dun. ");
INSERT INTO syb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Puꞌ tatap na sia beluday tali mukaꞌ kadina, dagid getusenen laak su tali sampay su kadina. Mukaꞌ ndaꞌiduni mekegapus diniin, puꞌ mesekeg gupia. ");
INSERT INTO syb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Gebii gendaw nai panawpanawen dia kelebengan sampay tu ngag binentudan, lamugen menamal megbeksay, mukaꞌ lamugen dadema menguglit batu dig lawasen. ");
INSERT INTO syb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mendadi, benaꞌ minitaꞌ nu silunuꞌan kia si Isus, laak melayuꞌlayuꞌ pa, gumibek sumungkak dini Isus, minginlulud dayun di gedapanen. ");
INSERT INTO syb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Minekeg megbeksay, laungen, “Ii, yaꞌa Isus, Bataꞌa nu Tampusan Metaas Megbebayaꞌ, taꞌ maig labet mu dinaan? Kelelaat dema tuꞌu diniꞌa, pengaduguꞌa di gedapan nu Megbebayaꞌ, ndiꞌ mau peglegetay!” ");
INSERT INTO syb_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(Kaas mitaluꞌ dun nu menulay, puꞌ tinaluꞌ ni Isus diniin, “Yaꞌa menulaya, pegawaꞌa di getaw kiin!”) ");
INSERT INTO syb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Mendadi, sinaakan ni Isus ki menulay kia, “Taꞌ mai ngalan mu?” Kaliꞌ sembag, “Si Linaksaꞌ, puꞌ melaun ami!” ");
INSERT INTO syb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Pinemalanen dayun pegubugay dini Isus, ndiꞌen dema tuꞌu puaꞌen dig benwa kia su menenulay. ");
INSERT INTO syb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Naa duuni sala kauluan babuy dia mesempel, melaun gupia babuy, meglunang ilan dia gabig. ");
INSERT INTO syb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Pinengi nu menenulay dini Isus, laung nilan, “Peditu mu ami ngag babuy kia, adun sulunuꞌ ami dinilan.” ");
INSERT INTO syb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Mendadi, biwang ni Isus. Dayun memegawaꞌ dia getaw kia su menenulay, sumilunuꞌ ilan pelum ditu ngag babuy. Benaꞌ su sala kauluan babuy, mabuꞌ duunig duaꞌ ngibuig launen, minggebek dumiksun ditug delipasan pangay diag linaw, migelaꞌ ilan dayun melemes. ");
INSERT INTO syb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mendadi su nga megingat tu ngag babuy, minggebek ilan ditug lunsud, pigukit nilan dayun dia ki mipenggulaula kia sampay ditug lumibut benwa. Benaꞌ su getaw inukitan nilan dun, linaawan nilan su mipenggulaula kia. ");
INSERT INTO syb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Benaꞌ midepet ilan ditu ni Isus, iini mitaangan nilan, su getaw silunuꞌan kamun nu melaun menulay, pegingkud laak iin, mikseluk na suuben, miseksud na tuꞌu su pianan ginaanen. Naa, mindek patiꞌ su nga getaw. ");
INSERT INTO syb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Inukit dayun nu nga mikaitaꞌ dun su mipenggulaula nu getaw kia silunuꞌan menenulay, mukaꞌ su mipenggulaula nu ngag babuy. ");
INSERT INTO syb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Benaꞌ midengeg nu nga getaw, inubug nilan dini Isus, megawaꞌ diag benwa nilan. ");
INSERT INTO syb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Naa benaꞌ duminangan na si Isus ditu sekayan nilan, migubug tundug diniin ki getaw kia, su silunuꞌan sia nu menenulay. ");
INSERT INTO syb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Dagid ndaꞌ peliag si Isus. Kaliꞌ pektaluꞌ, “Uliꞌa na tu ngag betaꞌan mu, pegukit mu ditu nilan su gikteb nu pinggulaula nu Kaunutan diniꞌa, sampay sug lelaaten diniꞌa.” ");
INSERT INTO syb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Naa saꞌ maꞌantu, mipanaw dayun su getaw kia, dayunen pegleleepay su Sepuluꞌ Lunsudan, inukiten ditu su pinggulaula ni Isus diniin. Kaas su nga kelaun getaw mikedengeg dun, mipatiꞌ ilan mesebuꞌay. ");
INSERT INTO syb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Naa duminipag puliꞌ si nga Isus ditug linaw. Benaꞌ midengguꞌ ilan ditug dipag, melaun na pelum getaw mikpungun dini Isus dia geksid linaw. ");
INSERT INTO syb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mendadi, duuni minangay ditu ni Isus kaunutan di simbaan nu getaw Judea, ngalanen si Jairo. Benaꞌ minitaꞌ ni Jairo si Isus, miglaub di gedapanen, ");
INSERT INTO syb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","laungen dayun diniin, “Sir, sug bataꞌu delaga, meliget megladu, pekagawinaa na. Kaas kelelaat dema tuꞌu diniꞌa, Sir, laaway mu, depenay mu, adun mauliꞌan, metubuꞌ da kig bataꞌu kiin!” ");
INSERT INTO syb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Migdunut dayun dini Jairo si Isus. Melaun gupia getaw tuminakin diniin, miꞌisel nilan si Isus. ");
INSERT INTO syb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Laak duuni sala tawan libun, sepuluꞌ buꞌ duaꞌ taun na, tebiaꞌ leduunen kig betad libun. ");
INSERT INTO syb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mitegelan na gupia di kebulung diniin, puꞌ melaun nai memulung migbulung diniin. Migelaꞌ nai selapiꞌen dun, laak palu pa mawaꞌ sug leduunen, ndiꞌ, sinangkaliꞌ migiseg. ");
INSERT INTO syb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Mendadi kig libun kini, benaꞌ midengegen su gukiten mekatag dini Isus, minguliksuk dia tebenan nu nga melaun getaw, mikpesempel dia teliudan ni Isus. ");
INSERT INTO syb_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Puꞌ maaꞌ laungen dig dialem delendemanen, “Pia medeluꞌu laaki suuben kiin, mauliꞌan nau dun.” ");
INSERT INTO syb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Lemen laak mideluꞌeni suub ni Isus, misikpaꞌ dayun sug duguꞌen, mukaꞌ mibatiken, miuliꞌan na tuꞌu. ");
INSERT INTO syb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mendadi si Isus, mibetikanen puꞌ duuni ginuungen gumiwaꞌ. Miktekaw lumingay tu nga getaw, sinaaken dinilan, “Taꞌ taway duni mikpuleg di suubu?” ");
INSERT INTO syb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kaliꞌ sembag su nga sakupen, “Sir, pegitaꞌen mu da melaun gupia getaw minisel diniꞌa, mauma saaken mu pa saꞌ taꞌ taway duni mikpuleg di suub mu?” ");
INSERT INTO syb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Laak dagid meglingaylingay gusay mengenleng si Isus di nga getaw di mektabuꞌen, penengaunen saꞌ taway duni minggulaula dun. ");
INSERT INTO syb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Naa sug libun, benaꞌ misuunanen su mipenggulaula diniin, mikpesempel dayun dini Isus, mipatiꞌ mengedeg sabaꞌ gendeken. Minginlulud dayun di gedapanen, inuntulen dayun teluꞌay diniin su mipenggulaulanen. ");
INSERT INTO syb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kaliꞌ pektaluꞌ si Isus diniin, “Naa, Enaung, miuliꞌan ka na, sabaꞌ nu kesalig mu. Uliꞌa na, gempia nai ginaa mu, puꞌ miawaꞌ naig leduun mu.” ");
INSERT INTO syb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Naa selian ni Isus mektaluꞌ, duuni minateng nga sinuguꞌ genat ditug balay ni Jairo, ki kaunutan di simbaan kiin. Benaꞌ minateng ilan dia ni Jairo, kaliꞌ ilan pektaluꞌ, “Naa Sir, sug bataꞌ mu kiin, ndaꞌ mu na mesaguti ginaanen. Kaas ndiꞌ na kambat salibaꞌeni Mekpetuꞌun kiin.” ");
INSERT INTO syb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Laak ndaꞌ ni Isus pengebetayi tinaluꞌ nilan kia. Kaliꞌ pektaluꞌ dini Jairo, “Naa, ndiꞌa na melibuleng, saliga laak.” ");
INSERT INTO syb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mendadi, ndaꞌ peliag si Isus saꞌ duun paig lain getaw megdunut diniin, subay si Pedro laak mukaꞌ sug duaꞌ tawan mekpated, si Santiago buꞌ si Juan. ");
INSERT INTO syb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mendadi, benaꞌ minateng ilan ditug balay ni Jairo, minitaꞌ ni Isus su melaun getaw misasaw, mukaꞌ midengegeni mesekeg gaduy mukaꞌ kenembit nilan. ");
INSERT INTO syb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Sumiled dayun si Isus diag balay, kaliꞌ pektaluꞌ di nga getaw, “Mauma dema misasaw amu? Taꞌi pengeduyan niu? Gembataꞌ kiin, kanaꞌ ma minatay. Pektulug da!” ");
INSERT INTO syb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Piketuanan laak nu nga getaw si Isus. Mendadi si Isus, piguaꞌen dia su nga melaun getaw. Sumiled dayun dia sugud belilidan nu gembataꞌ, pidunuten laak su ginaꞌ nu gembataꞌ mukaꞌ su gamaꞌen sampay su telu tawan sakupen kia. ");
INSERT INTO syb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Benaꞌ mikeseled ilan, piguidan dayun ni Isus su gembataꞌ di kemeten. “Talita kumi!” maaꞌ laung ni Isus. Guluganen, “Enaung, taluꞌu diniꞌa, pegbuata!” ");
INSERT INTO syb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Suminambut megbuat su gembataꞌ, mikpanawpanaw dayun. (Naa sepuluꞌ buꞌ duaꞌ taun nai gidaden.) Naa saꞌ maꞌantu, su kelaun duma ni Isus, mipatiꞌ ilan mesebuꞌay. ");
INSERT INTO syb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Dagid inungub ilan gupia ni Isus, pia laak daw sala tawan, ndaꞌiduni pesuunan nilan di mipenggulaula kia. Laung ni Isus, “Naa, paanen niui gembataꞌ kiin.” ");
INSERT INTO syb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Naa migawaꞌ si Isus dig benwa kia, minuliꞌ ditug daan lunsuden. Migdunut dadema diniin su nga sakupen. ");
INSERT INTO syb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Benaꞌ su Gendaw Pelali na, mikpetuꞌun si Isus dia simbaan nu getaw Judea. Mendadi su melaun getaw dia simbaan, saꞌ midengeg nilan su pituꞌun ni Isus, misebuꞌan ilan dun, kaliꞌ ilan peksinaakay, laung nilan, “Paa, ki getaw kini, adinen ma pigenati kelaunanen kini? Taꞌ sinuunan duni tinulung diniin? Pikendunen ma duni nga mekesalebuꞌ pingulaulanen kiin? ");
INSERT INTO syb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Puꞌ kanaꞌ bain su panday laak kiin dig balay, ginaꞌen si Maria, pateden si nga Santiago, si Jose, si Judas mukaꞌ si Simon? Kanaꞌ ba dini da pegbenwa su nga pateden libun?” Maꞌantu, pimilas nilan si Isus. ");
INSERT INTO syb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Mendadi, miktaluꞌ dinilan si Isus, “Ki pimuunan nu Megbebayaꞌ, pegbesaan pia adin pangay. Laak dagid diag daan benwanen, diag daniin betaꞌan, ndiꞌ daan pegbesaan.” ");
INSERT INTO syb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Saꞌ maꞌantu, ndaꞌiduni mekesalebuꞌ mipenggulaula ni Isus dia Nazaret, duun laaki nga santaꞌ tawan getaw pegladu pindepenanen, pineguliꞌanen. ");
INSERT INTO syb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Misebuꞌan gupia si Isus puꞌ ndaꞌ pekpetuud diniin su nga getaw dia. Mendadi, mipanaw si Isus, lineepen su ngag lunsud diag lumibut benwa, piktuꞌunanen su nga getaw. ");
INSERT INTO syb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Naa ki sepuluꞌ buꞌ duaꞌ tawan peneligan ni Isus, sinabinen ilan. Mendadi benaꞌ misabinen ilan, sinuguꞌ ilan dayun ni Isus mpanaw pigdeduaꞌ tawan. Bigayanen ilan pegbayaꞌ mengutid di menenulay. ");
INSERT INTO syb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Miktituluꞌ dinilan si Isus, laungen, “Saꞌ mpanaw amu, ndaꞌiduni sengkapan uiten niu, pia balun niu pan, gambag, atawaka selapiꞌ. Laak mesuꞌat meguit amu sekud, ");
INSERT INTO syb_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","mesuꞌat amu menepatus, dagid salabuuk laaki suub niu.” ");
INSERT INTO syb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Laung pagid ni Isus dinilan, “Adin sug bekna balay mekpepenaik diniu, ditu laak amu tuun, sampay mekebundas amu dig lain lunsud. ");
INSERT INTO syb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Adin sug lunsud ndiꞌ menembaꞌ diniu dakus ndiꞌ mekineeg diniu, pegawaꞌ amu dayun dia, mukaꞌ ekpug niu sug lepup lupaꞌ di geksud niu, adun metakesiꞌanig lunsud kia!” ");
INSERT INTO syb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Mendadi maꞌnia, mipanaw tuꞌu su nga sepuluꞌ buꞌ duaꞌ peneligan ni Isus. Miktituluꞌ ilan dayun, iini tinituluꞌ nilan tu nga getaw, subay meksikesuun ilan. ");
INSERT INTO syb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Melaun menulay inutidan nilan di nga getaw, mukaꞌ melaun dademai nga pegladu pineguliꞌan nilan, binunagan nilan lana su pegladu. ");
INSERT INTO syb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Naa si Adiꞌ Herodes, midengegen su pinggulaula ni Isus, kagina misigwag na dig benwa sug dengegan ni Isus. Sug duma getaw, pekteluꞌen nilan, “Kiin si Isus, iin si Juan su Memunag Tubig, masiꞌ mitubuꞌ puliꞌ! Kaas ma duuni ginuungen menggulaula mekesalebuꞌ.” ");
INSERT INTO syb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Dagid sug duma mektaluꞌ, laung nilan, “Kiin si Isus, iin si Elias dengantu.” Mukaꞌ duun pa pagidi mektaluꞌ, laung nilan, “Si Isus kiin, iini sala tawan pelum pimuunan nu Megbebayaꞌ, maaꞌ nu nga pimuunan nu Megbebayaꞌ dengantu.” ");
INSERT INTO syb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Laak dagid kini si Herodes, benaꞌ midengegen su pinggulaula ni Isus, laungen, “Uy, kiin pasiꞌ si Juan, su Memunag Tubig! Masiꞌ si Juan, ki piputukan ku gulu kitu, mitubuꞌ puliꞌ!” ");
INSERT INTO syb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kaas maꞌniai tinaluꞌ ni Herodes, puꞌ begudiin su ndaꞌ pa patay si Juan, suminuguꞌ si Herodes puꞌ daapen si Juan, pibaluden dakus pipirisunen. Puꞌ iini puunanen, begudiin duuni sala tawan libun ngalanen si Herodias, inagaw ni Herodes, asa sawa nu pated ni Herodes si Felipe. ");
INSERT INTO syb_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Kaas si Juan, tatap miktaluꞌ dini Herodes, “Binandu ma ditu Misulat Palinta nu Megbebayaꞌ, ndiꞌ mesuꞌat egaun mu su sawa nu pated mu, iini penginsuaan mu.” ");
INSERT INTO syb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Mendadi kagina maꞌantu, kini si Herodias, duunig laatan ginaanen dini Juan. Pepatayen sia, laak ndiꞌ mesuꞌat, puꞌ su sawanen si Herodes, ");
INSERT INTO syb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","mendek dini Juan. Puꞌ misuunan ni Herodes mekesuun getaw si Juan, mukaꞌ pimiliꞌ nu Megbebayaꞌ. Kaas pegingaten laak ni Herodes si Juan adun ndiꞌ mekaꞌidan. Puꞌ saꞌ kineegan ni Herodes su pegwali ni Juan, melibuleng dun gupia, laak pia maꞌantu, pekineeganen da gusay, puꞌ leliagen dun. ");
INSERT INTO syb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mendadi duuni gendaw, kini si Herodias, duun nai sikawen mekpatay dini Juan. Puꞌ si Herodes, miglumpuk mitaang di gendawanen, inggaten su nga kelaun begelal, su nga kaunutan nu sundalu, mukaꞌ su nga meselagetaw dia prubinsya Galilea. ");
INSERT INTO syb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mendadi, benaꞌ miglumpuk nailan, duunig bataꞌ ni Herodias delaga, sumiled dia puꞌ suminayaw. Liliag dun dayun si Herodes, sampay su ngag bisitanen. Kaliꞌ pektaluꞌ su gadiꞌ diag delaga, “Naa Enuꞌ, mesuꞌat duuni penengiin mu dinaan. Pia taꞌ alanduni penengiin mu dinaan, begayu diniꞌa.” ");
INSERT INTO syb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Suminapa pa pagid diag delaga kia, laungen, “Pesaden ku diniꞌa, pia taꞌ alanduni penengiin mu, pia seginengaꞌ di peglegediꞌan ku kini, begayu diniꞌa.” ");
INSERT INTO syb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Lumiu dayun sug delaga, sinaaken ditu ginaꞌen, “Taꞌ mai penengiin ku?” “Ki gulu ni Juan, su Memunag Tubig,” simbag nu ginaꞌen. ");
INSERT INTO syb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Lemen laak midengeg nug delaga, migdedaliꞌ dayun mpuliꞌ tu gupid nu gadiꞌ, pinenginen diniin, “Naa, iini mauyaꞌan ku begay mu dinaan, ki gulu ni Juan, su Memunag Tubig, betangen nandaw dig dekulan!” ");
INSERT INTO syb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Naa apelai, milegenan patiꞌi gadiꞌ kini. Dagid ndiꞌ mesuꞌat megbelibad, sabaꞌ nu kesapanen kia di gedapan nug launan bisitanen. ");
INSERT INTO syb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Suminuguꞌ dayun di sundalunen, uitenen ditu niin ki gulu ni Juan. Mendadi, mipanawi sundalu kia, pinutukanen tuꞌu gulu si Juan diag dialem pirisuan. ");
INSERT INTO syb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Iwiten dia gadiꞌ ki gulu ni Juan, bitang tuꞌu dig dekulan, tinulunen diag delaga, dayun pigwakilen dia ginaꞌen. ");
INSERT INTO syb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Naa benaꞌ midengeg nu nga sakup ni Juan ki mipenggulaula kia, inangay nilan sug bangkay ni Juan, dayun nilan lebengay. ");
INSERT INTO syb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Naa ki nga peneligan ni Isus, su nga sinuguꞌen mangay megukit, mipuliꞌ nailan ditu ni Isus. Benaꞌ minateng ilan, inukit nilan dayun diniin su kelaunan pinggulaula nilan sampay su nga pituꞌun nilan. ");
INSERT INTO syb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Laak melaun gupia getaw mikpungun dia ni Isus, miglimbuslimbus ilan media, kaas ndaꞌ naig lakay ni nga Isus, pia laak kaꞌaan nilan. Saꞌ maꞌnia, kaliꞌ pektaluꞌ si Isus tu nga peneliganen, “Naa, megawaꞌ ita deliꞌ dini, ditu ita meliawliaw, ita na laak, adun mekengulali amu ndiꞌ maiben.” ");
INSERT INTO syb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Naa saꞌ maꞌnia, sumikat ilan tuꞌu, suminakay ilan tu sekayan nilan, ilanilan da laak, adun mekpain ilan sia di meliawliaw benwa. ");
INSERT INTO syb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Laak dagid melaun gupia getaw mikaitaꞌ di kesekat nilan, minilala nilan si nga Isus. Saꞌ maꞌantu, minggebek ilan sumungkak dini nga Isus, genat ilan di ngag lumibut lunsud. Ditu ilan minian lupaꞌan, kaas miuna pailan dateng ditu tandaꞌ kedengguꞌan ni nga Isus. ");
INSERT INTO syb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Naa saꞌ maꞌnia, benaꞌ mikelusad si Isus tu sekayan, minitaꞌen ki melaun gupia getaw. Milelaat dinilan si Isus, puꞌ dialem ginaanen, maaꞌ ilan karniru ndaꞌiduni megingat dun. Dayun pikpuunanen ilan petuꞌunay, melauni pituꞌunen dinilan. ");
INSERT INTO syb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Naa benaꞌ sungu na mesindepi gendaw, mikpesempel dini Isus su nga sakupen, kaliꞌ ilan pektaluꞌ diniin, “Sir, sungu na mesindepi gendaw, mukaꞌ kig benwa kini, meliaw pa pelum. ");
INSERT INTO syb_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kaas melengas suguꞌen mu, Sir, su nga getaw, mangay ilan tu ngag lunsud mukaꞌ tu mektabuꞌ benwa, puꞌ adun mekesaluy ilan lebungan nilan.” ");
INSERT INTO syb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Sumimbag si Isus, “Yamu mai pekpaan dinilan.” “Apelai, Sir!” simbag nu nga sakupen. “Mabuꞌ ndiꞌ dadema mesuꞌat suguꞌen mu ami mangay sumaluy pan, bali duaꞌ gatus denario siai selapiꞌ, adun paꞌaan dinilan?” ");
INSERT INTO syb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Sinaak ni Isus, “Naa, sanu buuki pan niu kiin? Ipusay niu pa deliꞌ diin.” Kaliꞌ nilan maipusay, “Duun laakig lima buuk pan nami, dayun duunig duaꞌ buuk sedaꞌ.” ");
INSERT INTO syb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Mendadi, pimaingkuden su nga getaw diag lamalama, pikpinigpinigen ilan. ");
INSERT INTO syb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mikpanunpanun tuꞌu megingkud su nga getaw, duuni pingmegatus sala penunan dun, mukaꞌ duun dademai piglima puluꞌ tawan. ");
INSERT INTO syb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Mendadi, inimud ni Isus kig lima buuk pan kia mukaꞌ sug duaꞌ buuk sedaꞌ, dayun megangag tug langit mukaꞌ mekpaladpalad tu Megbebayaꞌ. Pikpetapetanen dayun su pan, piktukiden pegilasay tu nga sakupen, adun pengilaken nilan tu nga getaw. Sampay sug duaꞌ buuk sedaꞌ, pikilasen dadema ditu kelaun getaw. ");
INSERT INTO syb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Minaan dayun su kelaun getaw, mukaꞌ migelaꞌ ilan mbesug. ");
INSERT INTO syb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Benaꞌ mibesug nailan, kaliꞌ pengikpesay nu nga sakup ni Isus su sawad nilan, sepuluꞌ buꞌ duaꞌ dig belanan mipenuꞌ pa nu samaꞌ tu pan mukaꞌ sedaꞌ. ");
INSERT INTO syb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Su getaw minaan ditu nga pan, lima ngibu tawan su laak lumbus laki. ");
INSERT INTO syb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Naa benaꞌ mitubus maan su nga kelaun getaw, pisakay ni Isus tu sekayan su nga sakupen, piunanen ilan dumipag pangay ditug Betsaida, tu sedipag linaw. Daniin, pauliꞌenen pa su nga melaun getaw. ");
INSERT INTO syb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Naa benaꞌ migudas na dema ditu nga getaw, tumiwad dayun si Isus dig bentud, adun menenabi dia. ");
INSERT INTO syb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Saꞌ maꞌantu, benaꞌ miglegebii na, ditu na titengaꞌ laud nug linaw su sekayan nu nga sakupen. Si Isus pelum, salanen da dia taasan. ");
INSERT INTO syb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kaliꞌen pengundiagay su nga sakupen, ditu nailan titengaꞌ laud nug linaw, mitegelan ilan gupia memelula, puꞌ misensung nilan su genus. Mendadi, benaꞌ sungu na daliꞌ endaw, minangay si Isus ditu nilan, pekpanaw diag dibabaw tubig. Naa mian laak sia si Isus di mesempel nu nga sakupen. ");
INSERT INTO syb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Dagid midayag nilan si Isus, masiꞌ pekpanaw diag dibabaw tubig. Migbeksay ilan dayun, puꞌ laung nilan dun, multu. ");
INSERT INTO syb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Sug launan nilan mikaitaꞌ diniin, mindek ilan patiꞌ. Laung ni Isus, “Naa, gempia dai ginaa niu. Naan daini. Ndiꞌ amu mendek.” ");
INSERT INTO syb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Suminakay dayun si Isus dia sekayan nilan. Misikpaꞌ dayuni genus. Mipatiꞌ gupia mesebuꞌay dun su nga sakupen, ");
INSERT INTO syb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","puꞌ pia minitaꞌ na nilan su mipenggulaula mekatag di pan kitu, ndaꞌ gusay metekad nug delendeman nilan su gikteb nu ginuung ni Isus. Puꞌ metegasi gulu nilan. ");
INSERT INTO syb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Mendadi, minundas si nga Isus dumipag diag linaw. Dumingguꞌ ilan tu Genesaret, iniketan nilan su sekayan nilan dia geksid. ");
INSERT INTO syb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Benaꞌ minlusad ilan genat ditu sekayan nilan, su nga getaw dia, minilala nilan dayun si Isus. ");
INSERT INTO syb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Minggebek ilan dayun, lineep nilan sug benwa, kaas saꞌ midengeg nu getaw puꞌ minateng diag benwa kia si Isus, pinguit nilan dayun dia su nga pegladu, pibelilid di nga sampuyuan. ");
INSERT INTO syb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kaas pia adin pangay si Isus tu nga mikapuluꞌ balay atawaka tu ngag lunsud, pia adin dia miktabuꞌ benwa, su nga getaw, pinguit nilan su nga pegladu tu nga padiꞌan, ditu na dayun pemegbelilid. Inubug nilan dini Isus, pia laak daw sia medeluꞌ nu nga megladu su kuyamay suuben. Mukaꞌ adin su taman getaw mikedeluꞌ dun, migelaꞌ ilan dayun mauliꞌay. ");
INSERT INTO syb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Naa duuni nga Pariseo mukaꞌ nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ mikpungun ditu ni Isus, genat ilan ditu Jerusalem. ");
INSERT INTO syb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Naa ki nga Pariseo kini mukaꞌ su nga mekpetuꞌun di Palinta, minitaꞌ nilan puꞌ sug duma sakup ni Isus, saꞌ minaan ilan, milemuꞌan ilan, saꞌitada ndaꞌ nilan pegelaꞌ dunutay sug bian mengingenaw tinituluꞌ nu nga Pariseo tu nga getaw. ");
INSERT INTO syb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Puꞌ su nga Pariseo sampay su kelaun getaw Judea, ndiꞌ ilan maan saꞌ ndiꞌ nilan medunutan sug bian mengingenaw pingumbilin dinilan nu nga ginepuꞌay nilan. ");
INSERT INTO syb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mukaꞌ saꞌ mateng ilan genat di padiꞌan, ndiꞌ ilan maan, subay unaan pa nilan ki kengingenaw nilan kia. Mukaꞌ melaun pa betad pingumbilin dinilan dunutan nilan, pinenggiꞌ duunig bian nilan mengugas nga tasa, tegayan, mukaꞌ nga kaldiru tumbaga.) ");
INSERT INTO syb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mendadi, ki nga Pariseo kini mukaꞌ nga mekpetuꞌun di Misulat Palinta, sinaak nilan dini Isus, “Mauma ki nga sakup mu kiin, ndiꞌ ma nilan dunutan sug betad pingumbilin dinita nu nga ginepuꞌay ta? Milemuꞌan ilan, puꞌ miglaksap mailan maan, pia milemuꞌi kemet nilan.” ");
INSERT INTO syb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Dagid sumimbag si Isus dinilan, “Paa, yamu kiin, tautau mekesuun amu! Misugat amu gupia ditu sinulat pedaan ni Isaias dengantu ditu Taluꞌ nu Megbebayaꞌ, laungen, ‘Ki nga getaw kini, laung nu Megbebayaꞌ, pegbesaanu nilan diin laak babaꞌ nilan, dagid sug delendeman nilan, melayuꞌ ma dinaan. ");
INSERT INTO syb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Su kektamuy nilan dinaan, ndaꞌiduni pantagen, puꞌ su tituluꞌan nilan, kinilawan laak, asa paingalan nilan dun, pinalintau!’” ");
INSERT INTO syb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Maaꞌ laung pa ni Isus, “Yamu kiin, bileng niu tuꞌu su palinta nu Megbebayaꞌ, iin sungkini dunutan niu kig betad pingumbilin nu kilawan. ");
INSERT INTO syb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Metau daan amu gupia megbeleng tu Misulat Palinta nu Megbebayaꞌ, puꞌ adun petindegen niu sungkin sug daniu betad! ");
INSERT INTO syb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Puꞌ duuni palinta nu Megbebayaꞌ sinulat ni Moises, laungen, ‘Pegbesaay mu su ginaꞌ mu mukaꞌ su gamaꞌ mu.’ Mukaꞌ duun pagidi palinta, ‘Adin su getaw menampalaksa tu ginaꞌen atawaka tu gamaꞌen, subay petain.’” ");
INSERT INTO syb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Laung pa ni Isus, “Dagid iinig daniu tituluꞌan, saꞌ duun siai ginabang begay nu getaw tu ginaꞌen atawaka gamaꞌen, mesuꞌat daw teluꞌen nu getaw kia, ‘Corban ini.’ (Ki Corban, maꞌananen, begay sungkin tu Megbebayaꞌ.) ");
INSERT INTO syb_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Dayun saꞌ kiai teluꞌen nu getaw, naa su ginabang begayen sia tu ginaꞌen atawaka gamaꞌen, ndiꞌ niu pelum pebegay dinilan. ");
INSERT INTO syb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Naa saꞌ maꞌniai tituluꞌan niu, bileng niu daan su Misulat Palinta nu Megbebayaꞌ, iin sungkini pituꞌun niu tu nga getaw, sug daniu laak betad. Mukaꞌ melaun pai gininisan pinggulaula niu, maꞌnia dademaig bianen.” ");
INSERT INTO syb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Naa sinabi puliꞌ ni Isus su nga melaun getaw, mekpesempel ilan diniin. Benaꞌ mikpesempel nailan, kaliꞌ pektaluꞌ si Isus dinilan, “Pekineegay niu gupia ki teluꞌen ku kini, launan niu, adun mesabut niu gupia! ");
INSERT INTO syb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ndaꞌiduni mekeseled dig babaꞌ nu getaw genat dig liu, mekesalaꞌ dun tu Megbebayaꞌ su getaw. Iini mekesalaꞌ dun su getaw, ki guaꞌ dig delendemanen. ");
INSERT INTO syb_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Adin sug duuni telinganen, mekineeg dema tuꞌu.” ");
INSERT INTO syb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Mendadi, migawaꞌ si Isus ditu tebenan getaw. Kaliꞌ seled tug balay, sinaakan dayun nu nga sakupen mekatag di sambingayen kia. ");
INSERT INTO syb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Kaliꞌ sembag si Isus, “Apelai, pia pamu, ndaꞌ dadema niu mesabut? Ndaꞌ ba niu mesabut puꞌ pia taꞌ alanduni aanen nu getaw, ndiꞌ mekesalaꞌ dun su getaw minaan dun? ");
INSERT INTO syb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Puꞌ adin su aanen nu getaw, ndiꞌ da suled tug delendemanen, ditu da laak mbetang tianen, dayun guaꞌ da pelum dig lawasen.” (Kaas saꞌ maꞌantui tinaluꞌ ni Isus, mipesuunen puꞌ su kelaun gempia aanen, ndaꞌiduni binandu dun tu getaw.) ");
INSERT INTO syb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","“Mendadi,” laung pa ni Isus, “iini tantu mekesalaꞌ dun su getaw, ki guaꞌ dig delendemanen. ");
INSERT INTO syb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Puꞌ kig delendeman nu getaw, iini pigenatan nu melaat delendeman, sug dusa, su kegdaaw, su kegbunuꞌ, ");
INSERT INTO syb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","su kenlelingay, su kesaku, su melaat gulaula, sug limbung, su mekepiidpiid, su kengimbegu, su tampalaksa, su kekpelabawlabaw, mukaꞌ sug dupangan. ");
INSERT INTO syb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Sug launan melaat gulaula kini, genat daan dig delendeman nu getaw. Iin tuꞌui mekesalaꞌ dun su getaw tu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Naa migawaꞌ na dia si Isus, minangay pelum tug benwa mesempel tug lunsud Tiro. Benaꞌ minateng ditu, tuminuun dia salabuuk balay. Pigbuni sia, dagid ndaꞌ dain mekegeglud. ");
INSERT INTO syb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mendadi duunig libun, silunuꞌan menulayig bataꞌen libun. Lemen laak midengeg nug libun su kedateng ni Isus, linaawanen dayun, miglaub di gedapanen. ");
INSERT INTO syb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Laak kig libun kini, kanaꞌ getaw Judea, puꞌ getaw Fenicia, sakup Siria. Mendadi, minengi dayun sug libun dini Isus, utidanen sia ditug bataꞌen su menulay. ");
INSERT INTO syb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Laak iini simbag ni Isus, “Unaan ta paanay su nga gembataꞌ. Ndiꞌ pia awiꞌ tu gembataꞌ su gaanen, adun tikpuꞌen dia nga gituꞌ.” ");
INSERT INTO syb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kaliꞌ sembag sug libun, “Metuud la Sir, dagid pia su gituꞌ dia silung lemisaan, aanenen dadema su nga mikulaꞌ gaan nu nga gembataꞌ!” ");
INSERT INTO syb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kaliꞌ dayun pektaluꞌ si Isus diag libun, “Aa naa, kagina maꞌniai tinaluꞌ mu, mesuꞌat na muliꞌa. Iini medetengan mu saꞌ mateng ka, minawaꞌ na tug bataꞌ mu su menulay.” ");
INSERT INTO syb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Minuliꞌ dayun su ginaꞌ nu gembataꞌ, midetenganen tuꞌu sug bataꞌen pegbelilid laak tug belilidanen, minawaꞌ na diniin su menulay. ");
INSERT INTO syb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Naa mipanaw puliꞌ si Isus genat ditug benwa sakup Tiro, minundas tu Sidon, dayun mipuliꞌ ditug Linaw Galilea, mibiananen pa sug benwa paingalan dun Nga Sepuluꞌ Lunsudan. ");
INSERT INTO syb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mendadi, saanan ni Isus dia, duuni sala tawan bengel mukaꞌ beed pa pagid, iwit nu nga getaw dia niin. Inubug nilan dayun diniin, depenaneni getaw kia. ");
INSERT INTO syb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Mendadi pisuay ni Isus ditu melaun getawig bengel mukaꞌ beed kia. Benaꞌ duaꞌduaꞌ dailan, diluꞌ dayun ni Isus ki telinga ni getaw kia, mukaꞌ liwayanenig dilaꞌen. ");
INSERT INTO syb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Migangag si Isus tug langit, dayun migbagel ginaa, dunut tinaluꞌen, “Efata,” guluganen, mpukaꞌ na. ");
INSERT INTO syb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Lemen laak mitaluꞌ ni Isus, mikedengeg dayun sug bengel. Mukaꞌ miawaꞌ naig beeden, melegdeng na dema su kabiten. ");
INSERT INTO syb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Dayun inungub sia ni Isus su nga getaw, adun ndaꞌi ukitan nilan dun. Laak pia kendutaꞌenen dun pegungub, migdegadega ilan sungkin megukit dun. ");
INSERT INTO syb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Liliag patiꞌ su nga getaw, laung nilan, “Ki getaw kini, ki tibaꞌan penggulaulanen, melengas! Puꞌ pia sug bengel, megaganen mekedengeg. Sug beed, mesuꞌaten mekektaluꞌ!” ");
INSERT INTO syb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Naa benaꞌ lain gendaw, mikpungun na pelum ditu ni Isus ki melaun gupia getaw. Mendadi, benaꞌ migelaꞌ nai gaan nilan, sinabi ni Isus su nga sakupen. Benaꞌ mikpesempel ilan diniin, kaliꞌ pektaluꞌ si Isus, ");
INSERT INTO syb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Milelaatu di nga melaun getaw kini, puꞌ telu endaw na, ndaꞌ ilan pesuay dinaan, dayun migelaꞌ na demaig balun nilan. ");
INSERT INTO syb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Saꞌ dema pauliꞌen ku ilan ndaꞌ ilan mekaꞌaan, belunusan ilan dig dalan, puꞌ duma kiin, melayuꞌi pigenatanen.” ");
INSERT INTO syb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Dagid kaliꞌ sembag su nga sakup ni Isus, “Sir, kig benwa kini, limawaꞌ. Saꞌ maꞌantu, adin ta ma elapayi gaan, paan ta sia di nga melaun getaw kini?” ");
INSERT INTO syb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“Naa, sanu buuki pan niu diin?” sinaak ni Isus. Kaliꞌ ilan sembag, “Pitu buuk.” ");
INSERT INTO syb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Mendadi, pimaingkud dayun ni Isus su nga getaw diag lupaꞌ. Benaꞌ mikaingkud nailan, inalap dayun ni Isus ki pitu buuk pan kia, dayun mekpaladpalad tu Megbebayaꞌ. Benaꞌ mitubus mekpaladpalad, pikpetapetanen su pan, piktukiden dayun pegilasay tu nga sakupen, adun pengilaken nilan tu nga getaw. Piktukidtukid nilan dayun pemegay ditu nga melaun getaw. ");
INSERT INTO syb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Duun pagidi giwit nilan santaꞌ buuk mekaikaꞌ sedaꞌ. Mikpaladpalad dadema si Isus tu Megbebayaꞌ mekatag dig bataꞌ sedaꞌ kia. Mitubusen penenebiay, pikilasilas dadema su sedaꞌ ditu nga getaw. ");
INSERT INTO syb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Minaan dayun su nga melaun getaw, mukaꞌ mibesug ilan. Pingikpes dayun nu nga sakup ni Isus su sawad nu nga getaw maan, pitu dig bukag pai samaꞌ nilan. ");
INSERT INTO syb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Naa su nga getaw mikaꞌaan dun, duun saani paat ngibu tawan. Saꞌ maꞌantu, benaꞌ mitubus ilan maan, ");
INSERT INTO syb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","piuliꞌ ni Isus su nga melaun getaw, duminangan dayun tu sekayan, ilan nu nga sakupen, minangay ilan tug benwa Dalmanuta. ");
INSERT INTO syb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Naa duuni nga Pariseo minangay kumitaꞌ dini Isus, mikpuun ilan dayun meglantugiꞌ diniin. Ki nga Pariseo kini, minengi ilan dini Isus mekesalebuꞌ tuꞌus genat tu Megbebayaꞌ. Puꞌ pengindanan nilan si Isus. ");
INSERT INTO syb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Dagid benaꞌ midengeg ni Isus, migbagel ginaa dayun, kaliꞌ pektaluꞌ, “Paa, yamu pa di getaw nemun, mauma dema menengi mamu mekesalebuꞌ tuꞌus? Taman taluꞌu diniu, ndaꞌiduni mekesalebuꞌ tuꞌus paitaꞌ diniu nga getaw nemun!” ");
INSERT INTO syb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Saꞌ maꞌnia, migawaꞌ dayun dinilan si Isus, duminangan puliꞌ ditu sekayan, duminipag diag linaw. ");
INSERT INTO syb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Naa benaꞌ sumikat nailan dumipag diag linaw, milingawan nu nga sakup ni Isusi megbalun pan, salabuuk laaki pan nilan dia sekayan. ");
INSERT INTO syb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Mendadi benaꞌ tuminulak nailan, mikpegad si Isus dinilan, laungen, “Ki petulin nu nga Pariseo mukaꞌ ni Herodes di pan, peglengilamay niu.” ");
INSERT INTO syb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Benaꞌ midengeg nu nga sakupen, kaliꞌ ilan pegyagayaga, laung nilan, “Kaas tinaluꞌeni maꞌnia, puꞌ ndaꞌiduni pan ta.” ");
INSERT INTO syb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Laak dagid misuunan ni Isusi pigyagayaga nilan kia. Kaliꞌ pektaluꞌ dinilan, “Paa, mauma pelum megyagayaga amu mekatag di pan, saꞌ ndaꞌidun diniu? Masiꞌ ndiꞌ pa niu mesabut? Aba, metegas gupiai gulu niu? ");
INSERT INTO syb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Duun siai mata niu, masiꞌ ndiꞌ amu gusay mekengitaꞌ? Duun siai telinga niu, ndiꞌ damu gusay mekedengeg?” Sinaaken dayun dinilan, “Milingawan ba niu ");
INSERT INTO syb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","su kemetau tug lima buuk pan, ki piꞌaan dayun tug lima ngibu tawan kitu? Dayun sanu belanan pai samaꞌ dun, su pingikpes niu dun kitu?” Kaliꞌ ilan sembag, “Sepuluꞌ buꞌ duaꞌ dig belanan.” ");
INSERT INTO syb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Sinaak pagid ni Isus dinilan, “Mukaꞌ su kemetau tu pitu buuk pan, ki piꞌaan pelum tu paat ngibu tawan, sanu bukag ma pelumi pingikpes niu tu sawad nilan maan?” Laung nilan, “Pitu dig bukag.” ");
INSERT INTO syb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Laung dayun ni Isus dinilan, “Saꞌ maꞌantu, mauma ndaꞌ niu gusay mesabut?” ");
INSERT INTO syb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Maꞌantu, midepet na si nga Isus tug lunsud Betsaida. Benaꞌ minateng ilan, duuni sala tawan buta iwit nu nga getaw ditu ni Isus. Pinengi nilan dayun diniin, depenanen kig buta kia. ");
INSERT INTO syb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Mendadi, piguidanen di kemet sug buta, dayunen egakay ditug liu nug lunsud. Benaꞌ miliu nilan sug lunsud, liwayan ni Isus su mata nug buta. Genaten luayay, dipenanen dayunig buta kia, kaliꞌen saakay, “Naa ma, duun taꞌi minitaꞌ mu?” ");
INSERT INTO syb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Kaliꞌ tingagig buta kia, laungen, “Mikaitaꞌ nau getaw, laak dagid maꞌniin palas gayu pekpanawpanaw.” ");
INSERT INTO syb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Pinuliꞌan na pelum ni Isus depenay su matanen. Mininggas dayun mekimanig buta kia. Mukaꞌ miuliꞌan nai matanen, mipalasen gupiaig launan mesugat matanen. ");
INSERT INTO syb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Piuliꞌ dayun ni Isus su kamun mibuta, dunut binduanen, laungen, “Ndiꞌa gusay mpuliꞌ diag lunsud kia.” ");
INSERT INTO syb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Naa minundas na si Isus, ilan nu nga sakupen, minangay ilan tu nga mikapuluꞌ balay sakup dig lunsud Cesarea Filipo. Mendadi, sinegay nilan dig dalan, sinaak ni Isus tu nga sakupen, “Mendadi naan kini, saꞌ su gasalu, alanduni ketaluꞌ dun nu getaw?” ");
INSERT INTO syb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kaliꞌ sembag su nga sakupen, “Yaꞌa daw si Juan su Memunag Tubig. Saꞌ sug duma mektaluꞌ, yaꞌa daw si Elias dengantu. Mukaꞌ duun pa pagidi mektaluꞌ, yaꞌa dawi sala tawan pa pelum pimuunan nu Megbebayaꞌ dengantu.” ");
INSERT INTO syb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Mendadi yamu dema,” sinaak ni Isus, “taꞌ mai ketaluꞌ niu dun, ki gasalu?” Sumimbag si Pedro, “Yaꞌa na gupia su Tinduꞌ nu Megbebayaꞌ Meglekaunutan.” ");
INSERT INTO syb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Laak dagid inungub ni Isus su nga sakupen, ndiꞌ nilan pekpesuun tu getaw ki gasalen kia. ");
INSERT INTO syb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Mendadi, genat di gendaw kia, mikpuun si Isus mektuꞌun di nga sakupen, laungen, “Naan, kig Bataꞌ nu Kilawan, melaun pai kekpeleget dinaan. Mukaꞌ pemilasenu pa pagid nu nga kaunutan nu getaw Judea mukaꞌ su nga kaunutan nug belian nilan kampuꞌ nu mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ. Deksuꞌanen, petainu nilan. Laak dagid di ketelu endawen genat di kepatayu, metubuꞌu puliꞌ.” ");
INSERT INTO syb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Pinluksad gupia ni Isus dinilan ki tinaluꞌen kini. Dagid benaꞌ midengeg ni Pedro, inabigen si Isus, dayun pimaag ni Pedro si Isus mekatag di tinaluꞌen kia mbiananen sungu. ");
INSERT INTO syb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Laak dagid si Isus, liningayen su nga sakupen, pimaagen dayun si Pedro, laungen, “Pegawaꞌa dinaan, Satanas! Puꞌ kig delendeman mu kiin, kanaꞌ genat tu Megbebayaꞌ, puꞌ delendeman laak nu kilawan!” ");
INSERT INTO syb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Naa, sinabi ni Isus su nga melaun getaw sampay su nga sakupen. Benaꞌ misempel ilan, kaliꞌ dayun pektaluꞌ si Isus, “Mendadi, saꞌ duuni getaw mauyaꞌanen sumakup dinaan, subay teliudanen sug daniin delendeman, pisanenen dayun ki kurusen, dakus dumunut gusay dinaan. ");
INSERT INTO syb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Puꞌ adini mpauk megwakil gumulen dinaan, mbeleng diniin su ketubuꞌ ndaꞌi tamanen. Adin su pegwakilen dinaan su gumulen sabaꞌ nu kesakupen dinaan dakus tu kegukiten di Gempia Petenday, iin, malapen sungkin su ketubuꞌ ndaꞌi tamanen. ");
INSERT INTO syb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Puꞌ pia pa malap nu getaw su tibuuk lumbang, dayun mbeleng diniin su tantu ketubuꞌ, naa alandun bai gatagen? Ndaꞌidun! ");
INSERT INTO syb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Puꞌ saꞌ mbeleng na di getaw su ketubuꞌ ndaꞌi tamanen, duun bai mbayaden, adun melekaten sia puliꞌ su ketubuꞌen? ");
INSERT INTO syb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Puꞌ su getaw nemun, memilas ilan tu Megbebayaꞌ mukaꞌ mikesalaꞌ ilan. Naa adini getaw mpiid mangken di kesakupen dinaan mukaꞌ di taluꞌu di gendaw kini, naa naan, kig Bataꞌ nu Kilawan, mpiid dau dema mangken diniin sakupu saꞌ lumusadu puliꞌ dini. Mukaꞌ saꞌ lumusadu puliꞌ, maitaꞌ na di tiagu su kelengas nu pegbayaꞌ nu Gamaꞌu, dumau su nga pinaas sesuguꞌenen getaw langit.” ");
INSERT INTO syb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Mukaꞌ tinaluꞌ pa pagid ni Isus tu nga sakupen, “Taman taluꞌu diniu, yamu nga getaw pegindeg dini nandaw, duun diniui ndiꞌ matengi gumulen, meduaꞌ matanen ki Keglekaunutan na tuꞌu nu Megbebayaꞌ, medayag na tuꞌui ginuungen.” ");
INSERT INTO syb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Naa, benaꞌ minayani genem gebii, tumiwad si Isus di metaas bentud. Pidunuten si nga Pedro, si Santiago mukaꞌ si Juan, ilanilan da laak. Mendadi, benaꞌ ditu nailan dibabaw nug bentud, saanan nu nga sakupen megbantay diniin, masiꞌ mitekaw mpalin su palas ni Isus. ");
INSERT INTO syb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Sampay su nga penepetenen, metinggas gupia sabaꞌ keputiꞌen, ndaꞌiduni megaga nu mengekdak dig dibabaw benwa melepeng di keputiꞌen. ");
INSERT INTO syb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mukaꞌ padun minitaꞌ nilanig duaꞌ tawan dengantu pimuunan nu Megbebayaꞌ, masiꞌ si Elias mukaꞌ si Moises, pegabitabit ilan ni Isus. ");
INSERT INTO syb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Naa benaꞌ minitaꞌ ni Pedro, kaliꞌ pektaluꞌ dini Isus, “Aa Sir, melengas puꞌ dini dami! Naa, megbaal ami bebelayan telu buuk, salabuuk daniꞌa, salabuuk dani Moises, mukaꞌ salabuuk dani Elias.” ");
INSERT INTO syb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kaas mitaluꞌ dun ni Pedro, puꞌ ndaꞌen mesuunayi gempia sia teluꞌenen, sabaꞌ mindek gupia, ilan nu ngag dumanen. ");
INSERT INTO syb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Benaꞌ ndaꞌ medeksuꞌ mektaluꞌ si Pedro, duuni gabun mituaꞌ mikeleklem dinilan. Duuni miktaluꞌ dig dialem gabun, laungen, “Kini na tuꞌu sug Bataꞌu, ki petailen ku! Pekineegay niu iin!” ");
INSERT INTO syb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kaliꞌ ilan peglingaylingay, tekaw ndaꞌidun nai getaw minitaꞌ nilan dia, sala da dun ni Isus. ");
INSERT INTO syb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mendadi, duminiksun ilan genat diag bentud. Saanan nilan dumiksun, inungub ni Isus su nga sakupen, laungen, “Ki minitaꞌ niu kia, ndaꞌiduni ukitan niu dun pia sala tawan, sampay da dun metubuꞌ puliꞌ kig Bataꞌ nu Kilawan genat matay.” ");
INSERT INTO syb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Naa saꞌ maꞌantu, ndaꞌ nilan tuꞌu pesuun tug lain getaw. Pegyegayegaan laak nilan, laung nilan, “Alandun saani maꞌananen, ki tinaluꞌen kiin puꞌ metubuꞌ daw puliꞌ iin saꞌ genat matay?” ");
INSERT INTO syb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Sinaak nilan dini Isus, “Sir, saꞌ maꞌnia, su nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, taꞌ mai ketaluꞌ nilan dun puꞌ subay lumusad pa si Elias, dekag pa ki Tinduꞌ nu Megbebayaꞌ Meglekaunutan?” ");
INSERT INTO syb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Kaliꞌ sembag si Isus, “Naa metuud, si Elias, mauna daan metuaꞌ, puꞌ adun pengusainen pa sug launan. Dagid mekatag pelum dinaan, kig Bataꞌ nu Kilawan, taꞌ mai misulat dun ditu Taluꞌ nu Megbebayaꞌ puꞌ gembageli kekpeleget dinaan, mukaꞌ peksudiꞌan pau padun? ");
INSERT INTO syb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Dagid taman taluꞌu diniu, si Elias, daan na mituaꞌ, dayun linaksap peglegetay nu getaw, maaꞌ dadema nu daan na misulat mekatag diniin ditu Taluꞌ nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Naa benaꞌ mipuliꞌ si nga Isus ditug duma sakupen, melaun gupia getaw minitaꞌ nilan, pegapuluꞌ ilan dia nga sakupen. Dakus duuni nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, siwal nilan su nga sakup ni Isus. ");
INSERT INTO syb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Benaꞌ minitaꞌ nu nga melaun getaw si Isus, mitekawan ilan gupia diniin, minggebek ilan dayun sumungkak diniin, didialan nilan gupia iin. ");
INSERT INTO syb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Mendadi, kaliꞌ saak si Isus dinilan, “Naa, taꞌi piksualan niu kiin?” ");
INSERT INTO syb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kaliꞌ sembagi sala tawan, “Sir, kig bataꞌu kini, iwitu sia dini niꞌa, puꞌ peglegetan menulay, kaas beed. ");
INSERT INTO syb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Saꞌ matengi kegleget dun, mbuksak tug lupaꞌ, dayun megbulaꞌig babaꞌen dunut mengkiget di ngisinen, dayun mengekilig lawasen. Naa, inubugu di nga sakup mu kini, utidan nilan sia ki menulay, laak ndaꞌ nilan megaga.” ");
INSERT INTO syb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Kaliꞌ pektaluꞌ si Isus tu nga getaw dia, “Ay, yamu pa di nga getaw nemun, ndaꞌi salig niu! Pinlukas nau dumuma diniu. Santaꞌ pai kaibenen ki ketigelu diniu? Uit niu dini naani gembataꞌ kiin.” ");
INSERT INTO syb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Iwit tuꞌu dia ni Isus su gembataꞌ. Naa ki menulay kia, lemen laak minitaꞌen si Isus, silunuꞌanen pelum su gembataꞌ, binabuy dayun. Mibuksak diag lupaꞌ, migenselenselig lawasen mukaꞌ migbulaꞌig babaꞌen. ");
INSERT INTO syb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Sinaak ni Isus tu gamaꞌ nu gembataꞌ, “Minibenen na betikayi maꞌnini kini?” Kaliꞌ sembag su gamaꞌen, “Genat pa kaikaꞌayen. ");
INSERT INTO syb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Tatap lebuꞌen nu menulay di gapuy atawaka di tubig, petainen sia. Kaas kalukalu megaga mu da sia, lelaatay mu dema tuꞌu ami, ebangay mu ami!” ");
INSERT INTO syb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Kaliꞌ pektaluꞌ si Isus, “Ditu pa taluꞌ mu saꞌ megaga mau, naa iin pasiꞌi gempia teluꞌen, saꞌ yaꞌa pelumi mekegaga dun! Saꞌ sumaligi getaw, ndaꞌiduni ndiꞌen megaga.” ");
INSERT INTO syb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Minekeg dayun mektaluꞌ su gamaꞌ nu gembataꞌ, laungen, “Duun siai kesaligu Sir, laak kulang. Kaas dugangay mu ki kesaligu!” ");
INSERT INTO syb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Misimaꞌ ni Isus puꞌ pegisel dinilan su melaun getaw. Mendadi pimaag dayun ni Isus ki menulay kia, laungen, “Yaꞌa menulaya, bengelen mukaꞌ beed nga ginuung, gawaꞌa, mukaꞌ ndiꞌa na gusay puliꞌ selunuꞌ di gembataꞌ kiin!” ");
INSERT INTO syb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Migbeksay su menulay, mukaꞌ pisedilen patiꞌ su gembataꞌ. Dayun megawaꞌ diniin su menulay. Naa su gembataꞌ, maꞌniin palas minatay, kaas mitaluꞌ nu nga getaw dia, “Minatay na!” ");
INSERT INTO syb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Laak dagid si Isus, piguidanen su kemet nu gembataꞌ, biwaten. Migindeg dayun su gembataꞌ. ");
INSERT INTO syb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Naa saꞌ minuliꞌ si nga Isus tug balay nilan, benaꞌ ndaꞌidunig lain getaw duma nilan, sinaak nu nga sakupen, “Sir, alanduni puunanen, ndaꞌ nami mautiday dun su menulay kitu?” ");
INSERT INTO syb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Simbag ni Isus dinilan, “Ki maꞌniin palas, ndiꞌ mautidan, subay pebianen laak di kenenabi.” ");
INSERT INTO syb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Naa minundas pelum si nga Isus genat dig benwa kia, minian ilan ditu Galilea. Laak pigbuni ni Isus su kepanaw nilan, ");
INSERT INTO syb_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","puꞌ pektuꞌunanen pa su nga sakupen. Kaliꞌ pektaluꞌ si Isus, “Mendadi naan kini, kig Bataꞌ nu Kilawan, duuni gendaw mateng, pegwakilu tu pegbayaꞌ nu getaw. Deksuꞌanen, petainu nilan. Laak dagid di ketelu endawen genat di kepatayu, metubuꞌu puliꞌ.” ");
INSERT INTO syb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Dagid ki tinaluꞌ kia ni Isus, ndaꞌ metekad nu nga sakupen, mukaꞌ mekalangalang ilan dema sumaak dun diniin. ");
INSERT INTO syb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Maꞌantu, minateng ditu Capernaum si nga Isus. Benaꞌ mikauliꞌ nailan tug balay, sinaak ni Isus tu nga sakupen, “Taꞌ alanduni pigyagayaga niu kiin, su diin paita dalan?” ");
INSERT INTO syb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Naa mpauk ilan meksembag, puꞌ iin masiꞌi pigyagayaga nilan diag dalan, saꞌ taway dun dinilani tampusan metaasi tindegen. ");
INSERT INTO syb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Mendadi, migingkud si Isus, sinabinen su nga sepuluꞌ buꞌ duaꞌ tawan sakupen, pisempelen ilan diniin. Kaliꞌ taluꞌ si Isus, “Su getaw mauyaꞌanen sia iini tampusan metaasi tindegen, subay iin sungkini mbaal tampusan gembabaꞌi tindegen diniu, sampay mbaal sesuguꞌen nu kelaun samasakupen.” ");
INSERT INTO syb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Dayun suminabi si Isus sala tawan gembataꞌ, piꞌindegen di gedapan nilan. Sinipiten dayun su gembataꞌ, kaliꞌ pektaluꞌ, ");
INSERT INTO syb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Adin su menembaꞌ di sala tawan gembataꞌ maaꞌ ni gembataꞌ kini sabaꞌ nu kesakupen dinaan, naa gitunganen, naani mipenembaꞌen. Pidag pa tanan, kagina pinembaꞌu niin, mipenembaꞌen dadema su suminuguꞌ dinaan.” ");
INSERT INTO syb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Laak dagid si Juan, kaliꞌ pektaluꞌ dini Isus, “Sir, duuni minitaꞌ nami getaw megutid di menenulay, sembayanen su ngalan mu. Laak pimaag nami, puꞌ kanaꞌ tain samasakup di pikumpungan ta.” ");
INSERT INTO syb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Laak kaliꞌ sembag si Isus, “Naa, ndiꞌ niu dema pemaagay. Puꞌ ki getaw menggulaula mekesalebuꞌ, sembayanen su ngalan ku, kanaꞌ dayun meglibak dinaan. ");
INSERT INTO syb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Adini getaw kanaꞌ kuntra ta, iini sugut ta. ");
INSERT INTO syb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Taman taluꞌu diniu, pinenggiꞌ duuni getaw megbegay diniu sala tasai tubig sabaꞌ sakup amu dinaan kini, si Kristu, naa su getaw mekpainum dun diniu, sugdaan tuꞌu nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Kaliꞌ pektaluꞌ si Isus, “Mendadi, adin su getaw mekegdaang di sala tawan gembataꞌ kini, ki mikpetuud na dinaan, naa ki mekegdaang dun kia, saꞌ pinenggiꞌ palintangan gembagel galingan dayun lebuꞌay tug laud, tumuꞌ megaan daitu, sabayaꞌ nu ginukuman nu Megbebayaꞌ tu getaw mekegdaang di gembataꞌ kini. ");
INSERT INTO syb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kaas saladuaꞌ diniu, saꞌ pegdaangan ka, ki kemet mui mekesabaꞌ dun, naa putuk mui kemet mu kiin! Puꞌ tumuꞌ pa mpedumaa di ketubuꞌ ndaꞌi tamanen, pungkula, sabayaꞌ mesangkapi kemet mu, laak mekauliꞌa tug linaw gapuy ndaꞌ nai kepalengen. ");
INSERT INTO syb_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Mukaꞌ misulat ditu Taluꞌ nu Megbebayaꞌ puꞌ tug linaw gapuy, ‘Su guled mengaan dig bangkay nilan, ndiꞌ na matay. Mukaꞌ su gapuy ditu mektutung dinilan, ndaꞌ nai kepalengen.’” ");
INSERT INTO syb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Mukaꞌ miktaluꞌ pagid si Isus, “Mesama da saꞌ pegdaangan ka, ki geksud mu pelumi mekesabaꞌ dun, naa putuk mui geksud mu kiin! Puꞌ melengas pa diniꞌa saꞌ mpedumaa ditu ketubuꞌ ndaꞌi tamanen, sedibaluyi geksud mu, sabayaꞌ mesangkapi geksud mu, laak lebuꞌen ka tug linaw gapuy. ");
INSERT INTO syb_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","‘Su nga guled ditu, ndaꞌ daani kepatayen. Su gapuy ditu, ndaꞌ nai kepalengen.’ ");
INSERT INTO syb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mukaꞌ pagid, saꞌ pegdaangan ka, ki mata mu pelumi mekesabaꞌ dun, naa asak mui mata mu kiin! Puꞌ melengas pa diniꞌa saꞌ mpedumaa tu Keglekaunutan nu Megbebayaꞌ, salabuuk daig lisu mata mu, sabayaꞌ mesangkapi mata mu, laak lebuꞌen ka tug linaw gapuy. ");
INSERT INTO syb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Su nga guled ditu, ndaꞌi kepatayen. Su gapuy ditu, ndaꞌ nai kepalengen.’” ");
INSERT INTO syb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Laung pa ni Isus, “Menukid di nga getaw, esinan gapuy. ");
INSERT INTO syb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Naa ki masin, gembageli gatagen. Laak dagid saꞌ meksitebang su masin, kendutaꞌen ma dun pekpepuliꞌ tu kepaiten? “Peksalabuuk amu di ginaa, puꞌ adun sug betad niu, melengas, maaꞌ nu kelengas nu masin.” ");
INSERT INTO syb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Naa migawaꞌ si Isus dig benwa kia, minangay tu prubinsya Judea, dakus duminipag tu Tubig Jordan. Melaun getaw pelum mikpungun suminungkak diniin. Pituꞌunanen dadema ilan, maaꞌ da gusay nug daan betaden. ");
INSERT INTO syb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mendadi, duuni nga Pariseo kuminitaꞌ dini Isus, pengimanan nilan sia iin. Suminaak dini Isus su nga Pariseo, “Naa, biwang ba dinita ditu Misulat Palinta nu Megbebayaꞌ, belengen nug laki su sawanen?” ");
INSERT INTO syb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Suminuliꞌ dayun si Isus sumaak dinilan, laungen, “Naa, alandun mai palinta nu Megbebayaꞌ sinulat diniu ni Moises?” ");
INSERT INTO syb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kaliꞌ ilan sembag, “Biwang ni Moises puꞌ sug laki, mekpebaal pa keligenan tuꞌus dun, dayun megbeleng tu sawanen.” ");
INSERT INTO syb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Dagid miktaluꞌ si Isus dinilan, “Paa, kaas ma biwang dun ditu palinta nu Megbebayaꞌ sinulat ni Moises diniu, puꞌ sabaꞌ nu ketegas nu gulu niu. ");
INSERT INTO syb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Laak dagid genat tu pikpuunan nug launan, su kebuat nu Megbebayaꞌ di gekleb langit buꞌ lupaꞌ, kanaꞌ maꞌnia. Puꞌ iini misulat ditu Taluꞌ nu Megbebayaꞌ, ‘Biwat nu Megbebayaꞌ su getaw laki mukaꞌ libun.’ ");
INSERT INTO syb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Mukaꞌ misulat pa pagid, ‘Mendadi kagina maꞌantu, sug laki, suay ditu ginaꞌen buꞌ gamaꞌen, sumalabuuk na tu sawanen. ");
INSERT INTO syb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Kaas su kamun duaꞌ lawas pailan, meksala lawas nailan.’ Naa saꞌ maꞌantui pisulat nu Megbebayaꞌ, maꞌananen, sug laki mukaꞌ su sawanen, kanaꞌ nailan duaꞌ lawas, puꞌ sala lawas nailan. ");
INSERT INTO syb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Naa kagina maꞌantu, su piksalabuuk nu Megbebayaꞌ, subay ndiꞌ nu kilawan pepegbelengen.” ");
INSERT INTO syb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Naa benaꞌ ditu ilan balay, sinaakan pelum si Isus nu nga sakupen mekatag di kegbeleng nu senlangan. ");
INSERT INTO syb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kaliꞌ sembag si Isus, “Adin sug laki, belengenen su sawanen dayun menginsawa na puliꞌ dig lain libun, naa kiin, mikesalaꞌ dusa. ");
INSERT INTO syb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mesama da sug libun, saꞌ belengenen su sawanen, dayun penginsuaan puliꞌ lain laki, naa kiin, mikesalaꞌ dadema dusa sug libun.” ");
INSERT INTO syb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Naa duuni nga getaw mimeguit bataꞌen ditu ni Isus, adun pendepenanen ilan. Laak dagid su nga sakup ni Isus, pimaag nilani nga getaw kia. ");
INSERT INTO syb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mendadi, kaliꞌ mesuunay ni Isus, milaati ginaanen tu nga sakupen. Kaliꞌ pektaluꞌ dinilan, “Ki nga gembataꞌ kiin, petuyang niu ilan mangay dinaan, ndiꞌ niu belibaday. Puꞌ iin laaki mekesakup tu Keglekaunutan nu Megbebayaꞌ, su megimbataꞌ dig betaden. ");
INSERT INTO syb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Taman taluꞌu diniu, ndaꞌi getaw mekesakup tu Keglekaunutan nu Megbebayaꞌ, subay su kesaligen, maꞌniin nu kesalig nu gembataꞌ kini.” ");
INSERT INTO syb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Saꞌ maꞌnia, suminipit si Isus tu nga gembataꞌ kia, dipenanen ilan dayun mukaꞌ pinenebianen ilan. ");
INSERT INTO syb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Benaꞌ sumikat na pelum mpanaw si Isus, duuni getaw gumibek mekpesempel diniin dayun menginlulud di gedapanen, kaliꞌ saak diniin, “Sir, mekesuun ka. Naa taꞌ alanduni gempiau penggulaulaan, adun mpedumau tu ketubuꞌ ndaꞌi tamanen?” ");
INSERT INTO syb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Suminaak puliꞌ si Isus di getaw kia, “Baa, mauma dema paingalan mu dinaan, mekesuun? Ndaꞌiduni mekesuun tantu, subay su laak Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Dagid, misuunan mu na ki nga palinta, maꞌniin ‘Ndiꞌa pekpatay, ndiꞌa pegdusa, ndiꞌa pegdaaw, ndiꞌa penakesiꞌ dig balus, ndiꞌa peglimbung, pegbesaay mu su ginaꞌ mu buꞌ gamaꞌ mu.’” ");
INSERT INTO syb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Kaliꞌ sembagi getaw kia, “Naa Sir, ki kelaun palinta kia, dinunutan ku, genat pa di kaikaꞌayu.” ");
INSERT INTO syb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Pingenlengan dayun ni Isusi getaw kia, gembagelig lelaaten diniin. Laak kaliꞌ pektaluꞌ diniin si Isus, “Naa, duun pa gusayi kulang diniꞌa. Panawa na, peksaluy mu ki kelaun gimu mu, dayun pemegay mu tu nga pubri getaw su galinen. Duun dayuni gaꞌus mu ditu gekbus langit. Dayun puliꞌa dini naan, pegdunuta dinaan.” ");
INSERT INTO syb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Dagid kaliꞌ medengeg nu getaw ki tinaluꞌ kia ni Isus, migdemeng. Migawaꞌ dia ni Isus, milegenan patiꞌ, puꞌ medatuꞌ gupia getaw iin. ");
INSERT INTO syb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Mendadi, su kepalus nu getaw kia, pingenlengan ni Isus su nga sakupen, kaliꞌ pektaluꞌ dinilan, “Ki medatuꞌ getaw, melegen tuꞌu ki kesakupen tu Keglekaunutan nu Megbebayaꞌ!” ");
INSERT INTO syb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Benaꞌ midengeg nu nga sakupen, misebuꞌan ilan dun gupia. Kaliꞌ gusay pektaluꞌ si Isus, “Yamu nga gembataꞌu, taluꞌu diniu, ki kesakup tu Keglekaunutan nu Megbebayaꞌ, melegen daan tuꞌu! ");
INSERT INTO syb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Melemu pa su kebian nu petubuꞌen kamelyu dig luang taiꞌ, sabayaꞌ nu kesakup nu medatuꞌ getaw tu Keglekaunutan nu Megbebayaꞌ!” ");
INSERT INTO syb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Naa benaꞌ midengeg nu nga sakup ni Isus su tinaluꞌen kia, migiseg patiꞌi kesebuꞌay nilan dun. Kaliꞌ ilan peksinaakay, “Saꞌ maꞌantu, duun bai megawen?” ");
INSERT INTO syb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Pingenlengan puliꞌ ni Isus su nga sakupen, kaliꞌ pektaluꞌ dinilan, “Ndiꞌ daan megaga nu kilawan. Dagid su Megbebayaꞌ, megaganen, puꞌ ndaꞌiduni ndiꞌen megaga.” ");
INSERT INTO syb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Laak dagid si Pedro, kaliꞌ pektaluꞌ, “Sir, yami kini, bileng na nami gupia ki kelaunanen, adun megdunut ami diniꞌa.” ");
INSERT INTO syb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","“Waꞌa,” laung ni Isus. “Mukaꞌ taman taluꞌu diniu, adini getaw belengenen sug balayen, saꞌ su nga pateden libun laki, ginaꞌen saꞌ gamaꞌen, ngag bataꞌen, sampay sug lupaꞌen, sabaꞌ nu kesakupen dinaan mukaꞌ sabaꞌ kegukiten di Gempia Petenday, ");
INSERT INTO syb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","naa nemun, sugdaan dun melaun. Sugdaan dun megatus piluꞌ ngag balay, pateden libun laki, ginaꞌen, ngag bataꞌen sampay lupaꞌen. Laak dunut dun, malapen pa pagid ki kekpeleget diniin. Dayun di gendaw kiin ditug binayaꞌ gebii buꞌ gendaw, mpeduma pa pagid tu ketubuꞌ ndaꞌi tamanen. ");
INSERT INTO syb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Laak dagid melaun getawi mauna nemun, iini mbinayaꞌ saꞌ matengi gendaw kiin ditug binayaꞌ gebii buꞌ gendaw. Melaun dadema getaw mbinayaꞌ nemun, iin na sungkini mbaluy muna saꞌ matengi gendaw kiin.” ");
INSERT INTO syb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Naa benaꞌ diin nailan dalan pektuad ilan tu Jerusalem, inunanan ni Isus su nga sakupen. Kagina sungu ilan medepet di Jerusalem, mipatiꞌ melibuleng su nga sakupen, dakus mindek dadema su nga getaw tuminakin dinilan. Mendadi, sinabi ni Isus su sepuluꞌ buꞌ duaꞌ tawan peneliganen. Benaꞌ mikpesempel ilan diniin, pigukiten puliꞌ dinilan ki mpenggulaulanen sungu. ");
INSERT INTO syb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kaliꞌ pektaluꞌ si Isus, “Naa, pektalentenay niu gupia ini. Kini, tuad naita tuꞌu di Jerusalem. Mendadi, saꞌ mateng ita dia, naan kini, kig Bataꞌ nu Kilawan, pegwakilu tu nga kaunutan nug belian nu getaw Judea mukaꞌ tu nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ. Ukumanu dayun nilan lagaꞌ na ginau, mukaꞌ pegwakilu nilan tu pegbayaꞌ nga kanaꞌ getaw Judea. ");
INSERT INTO syb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Pengimusaunganu nilan, pendulaꞌanu nilan, mukaꞌ bedasenu nilan. Dayunu petayay. Laak dagid di ketelu endawen genat di kepatayu, metubuꞌu puliꞌ.” ");
INSERT INTO syb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Mendadi si Santiago mukaꞌ si Juan, su ngag bataꞌ ni Sebedeo, minadap ilan dini Isus, kaliꞌ ilan pektaluꞌ, “Sir, duun siai tuyuꞌ nami pebaal diniꞌa.” ");
INSERT INTO syb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Sinaak ni Isus dinilan, “Alandun mai penengiin niu baalen ku diniu?” ");
INSERT INTO syb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Kaliꞌ ilan sembag, “Naa Sir, saꞌ mingkuda na tuꞌu meglekaunutan, medayag na dema su kelengas nu pegbayaꞌ mu, naa iin siai penengiin nami diniꞌa, paingkuden mu dami dema ditu gupid mu. Su sala tawan dinami, diin dapit lintu mu, su sala tawan pelum, diin dapit bibang mu.” ");
INSERT INTO syb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kaliꞌ sembag dinilan si Isus, “Baa, ndaꞌ niu mesuunay ki inubug niu kiin. Taꞌ itu, megaga ba niu minum di tasa mipenuꞌ kelegenay, ki sunguu na inumay? Mukaꞌ megaga ba niu bunagan amu tubig maꞌniin nu kebunag sungu dinaan tubig?” ");
INSERT INTO syb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Laung nilan, “Waꞌa, Sir, megaga da nami.” “Naa, metuud,” laung ni Isus. “Ki tasa ginuman ku, mekainum amu daan dun tuꞌu. Ki tubig sungu bunag dinaan, mbunagan daan damu dun dema. ");
INSERT INTO syb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Laak dagid pia maꞌantu, ndaꞌi pegbayaꞌu memiliꞌ tu getaw mingkud di gupidu, diin dapit lintuu mukaꞌ di dapit bibangu. Puꞌ iin da laaki mekesaing dinaan, adin su gandang mitenduꞌ nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Naa su nga sepuluꞌ tawan samasakup nilan dini Isus, benaꞌ midengeg nilan ki inubug kia ni Santiago mukaꞌ ni Juan puꞌ ilan siai sumaing dini Isus saꞌ meglekaunutan, lingetan ilan dun. ");
INSERT INTO syb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Mendadi, sinabi ni Isusi kelaun sakupen kia, kaliꞌ pektaluꞌ dinilan, “Naa su nga kanaꞌ getaw Judea, misuunan niu puꞌ gembegati kegbayaꞌ dinilan nu nga pegengagen nilan. Mukaꞌ su ngag begelal nilan, metegas demai keguit nilan tu nga sakup nilan. ");
INSERT INTO syb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Dagid yamu, ndiꞌ amu mpia mengmaꞌantu. Sinangkaliꞌ adin diniui mauyaꞌanen sia metaasi tindegen, subay iin nai mbaal sesuguꞌen niu. ");
INSERT INTO syb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kaas adini mauyaꞌanen sia puꞌ iini tampusan metaasi tindegen dig launan niu, subay iin nai mbaal maaꞌ nu gulipen nug launan niu. ");
INSERT INTO syb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Puꞌ pia pa naan kini, kig Bataꞌ nu Kilawan, kanaꞌ iini luminusadu dun dinig lumbang, puꞌ adun duuni megabang dinaan. Segaga iin sungkini ginangayu medini, puꞌ adun ebangan ku su kilawan, sampay petainu, puꞌ adun lekaten ku su melaun getaw.” ");
INSERT INTO syb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Maꞌantu, midepet tu Jerico si Isus, ilan nu nga sakupen. Benaꞌ minundas ilan pelum genat ditu, melaun gupia getaw mimegdunut dinilan. Naa saꞌ mipalus ilan dig lunsud kia, duunig buta pegingkud dia geksid dalan, menengi limus. Ngalanen si Bartimeo, gamaꞌen si Timeo. ");
INSERT INTO syb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mendadi benaꞌ midengeg nug buta puꞌ megbian dia si Isus, ki getaw Nazaret kiin, migbeksay dayun, laungen, “Uu Isus, Sapuꞌa ni David, lelaatay mau!” ");
INSERT INTO syb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kig buta kia, pigbeluꞌan dayun nu melaun getaw, pimaag nilan sia. Laak palu pa mpemaag, ndiꞌ, minamal mektawag, laungen puliꞌ, “Uu Sir, Sapuꞌa ni David, lelaatay mau dema tuꞌu!” ");
INSERT INTO syb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tuminlen dayun si Isus. Laungen, “Sabi niu iin.” Sinabi dayun sug buta, laung nu miksabi dun, “Gempia dai ginaa mu! Pegbuata, puꞌ sinabia niin.” ");
INSERT INTO syb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bileng dayun nug buta su melambak suuben, suminambut dayun megbuat, mikpesempel dini Isus. ");
INSERT INTO syb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Sinaak ni Isus, “Taꞌi penengiin mu dinaan?” “Sir, liagan ku sia, mekengitaꞌ nau.” ");
INSERT INTO syb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Miktaluꞌ si Isus, “Naa, sigi, maꞌnia na. Miuliꞌan ka na, puun tu kesalig mu.” Lemen laak mitaluꞌ ni Isus, mikengitaꞌ dayun tuꞌu sug buta. Mukaꞌ tumindug dini Isus tug dalan. ");
INSERT INTO syb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Mendadi, minundas na tuꞌu ditu Jerusalem si nga Isus. Benaꞌ mesempel nailan dia, misebang ilan dig duaꞌ maikaꞌ lunsud piningalan dun Betpahe mukaꞌ Betania, dia guksad nug Bentud nu nga Gayu Olibo, suminuguꞌ si Isus dig duaꞌ tawan sakupen. ");
INSERT INTO syb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Laungen dinilan, “Bundas amu diag lunsud kia dia gunaan. Mendadi saꞌ mateng amu ditu, duun dayuni maitaꞌ niu petubuꞌen nati asno iniketan, ndaꞌ mainsan sekayay getaw. Naa kiin, ubaday niu, agak niu dayun dini naan. ");
INSERT INTO syb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Naa saꞌ duuni sumaak diniu mauma ubadan niu, iini taluꞌ niu diniin, ‘Duunig baalan dun nu Kaunutan, laak uliꞌenen da ganam.’” ");
INSERT INTO syb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Naa saꞌ maꞌantu, mipanaw sug duaꞌ tawan sinuguꞌ ni Isus, mitaangan nilan tuꞌu dia geksid karsadai nati asno, iniketan dig bisuangan balay. Inubadan nilan dayun. Benaꞌ pegubadan nilan, ");
INSERT INTO syb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","suminaak dinilan tuꞌui nga getaw pegindeg dia, laung nilan, “Uy, taꞌ maig baalen niu kiin? Mauma dema ubadan ma niui nati kiin?” ");
INSERT INTO syb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Simbag dayun nug duaꞌ tawan sakup ni Isus su pimuunen dinilan. Miliag da dayun su nga getaw. ");
INSERT INTO syb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Mendadi, inagak nilan ditu ni Isus su nati asno. Benaꞌ minateng ilan dia ni Isus, inigan nilan suub nilan sug lekud nug asno, suminakay dayun si Isus. ");
INSERT INTO syb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mukaꞌ melaun getaw mimelat suub nilan dia karsada mbianan ni Isus, basa nilan diniin. Sug duma pelum, minalap panga gayu daunan dia giuan, inikam nilan dadema diag biananen. ");
INSERT INTO syb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mendadi su nga melaun getaw mpanaw di gunaan ni Isus, mesama di nga getaw peglendug dig binayaꞌen, mimeksay ilan, laung nilan, “Pegbesaan kini! Melengas pepianan iin nu Megbebayaꞌ ki minateng na pigwekilan nu Kaunutan Megbebayaꞌ! ");
INSERT INTO syb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kini su sumumpat tu keglekaunutan nu ginepuꞌay ta si Adiꞌ David! Melengas pepianan nu Megbebayaꞌ ki Kaunutan kini! Pegbesaan dadema su Megbebayaꞌ ditu gekbus langit!” ");
INSERT INTO syb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Naa benaꞌ minateng na tuꞌu di Jerusalem si Isus, minundas ditu Pengedapan tu Megbebayaꞌ. Piglingaylingayen dayun su kelaunanen dia. Naa benaꞌ lelabung na gupia, minuliꞌ pa si Isus ditug Betania, ilan nu nga sepuluꞌ buꞌ duaꞌ tawan sakupen. ");
INSERT INTO syb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Naa benaꞌ miksala gendaw, mipuliꞌ si nga Isus dia Jerusalem genat tug Betania. Saanan nilan dig dalan, migutem si Isus. ");
INSERT INTO syb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kaliꞌ megutem, duuni minitaꞌen dia melayuꞌlayuꞌ sala puun gayu igera, melabung naig daunen. Linaawan dayun ni Isusi gayu kia, tekaw duun siaig bunganen. Laak kaliꞌ pekpesempel dun, lumbus laak masiꞌ daun kig igera kia, puꞌ kanaꞌ pa timpu memunga. ");
INSERT INTO syb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Miktaluꞌ dayun si Isus tu gayu, laungen, “Genat nandaw, ndaꞌidun naig bunga mu maꞌaan nu getaw!” Naa midengeg nu nga sakupen ki tinaluꞌ kia ni Isus. ");
INSERT INTO syb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Benaꞌ minateng ilan pelum tu Jerusalem, minangay puliꞌ si Isus tu Pengedapan tu Megbebayaꞌ. Mendadi benaꞌ minateng dia, ki nga mendagang guliden mukaꞌ su nga menaluy dia, pingutidanen. Pimbelikwangen pa pagid su ngag lemisaan nu nga membeles selapiꞌ, sampay su nga gingkudan nu nga mendagang malepati, guliden tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mukaꞌ ndaꞌ iin peliag saꞌ duuni getaw meguit pimetang, baalanen laak lektesan ki Pengedapan kia tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Dayun mikpetuꞌun si Isus tu nga getaw dia, laungen, “Misulat ditu Taluꞌ nu Megbebayaꞌ, ‘Ki Pengedapan dinaan, iini paingalan dun, balay penenebian nug launan bansa getaw.’ Dagid yamu kiin, binaal niu pegegludan ngag limbungan getaw ki Pengedapan kini.” ");
INSERT INTO syb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Mendadi ki nga kaunutan nug belian nu getaw Judea mukaꞌ ki nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, midengeg nilan ki pinggulaula kia ni Isus. Sabaꞌ midengeg nilan, mikpuun ilan dayun menengaw pebianan nilan mekpatay diniin. Mindek ilan diniin, kagina su kelaun getaw, mipatiꞌ ilan mesebuꞌay ditu tituluꞌan ni Isus. ");
INSERT INTO syb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Naa benaꞌ miglegebii pelum, migawaꞌ na puliꞌ si nga Isus dia Jerusalem. ");
INSERT INTO syb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Naa benaꞌ miksiselem, mibianan puliꞌ ni nga Isus ki gayu igera kiin. Kaliꞌ nilan maitaꞌ, masiꞌ milanes, minatay dadema su gangeten. ");
INSERT INTO syb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Naa si Pedro, milabuꞌ dayun dig delendemanen su tinaluꞌ ni Isus mekatag di gayu kia. Laung ni Pedro, “Apelai Sir, bentayay mu pa daan! Ki gayu igera kia piktuyudan mu, milanes na tuꞌu!” ");
INSERT INTO syb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Kaliꞌ pektaluꞌ si Isus tu ngag dumanen, “Waꞌa daan. Kaas yamu, salig amu dadema tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Puꞌ taman taluꞌu diniu, saꞌ duuni mektaluꞌ dig bentud kinuꞌ, ‘Mainata, peksilabuꞌa tug dagat,’ dayun kanaꞌ megduaꞌduaꞌi kesalig nu mektaluꞌ dun, puꞌ petuudenen puꞌ menuudi tinaluꞌen kia, naa kiin, menuud dema tuꞌu. ");
INSERT INTO syb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mendadi taluꞌu diniu, pia alanduni penenebiin niu, pekpetuud amu dun puꞌ malap niu, adun begay dadema diniu su pinengi niu. ");
INSERT INTO syb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mukaꞌ saꞌ megindeg amu menenabi, adin su taman dunig laatan ginaa niu dig duma niu, gelaꞌ niu pedesunay. Puꞌ saꞌ maꞌnia, su Gamaꞌ niu ditu gekbus langit, mekpedasun dadema diniu di melaat penggulaula niu. ");
INSERT INTO syb_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Laak saꞌ ndiꞌ niu pedesunen su samataw niu, naa ndiꞌ damu dema pedesunen nu Gamaꞌ niu ditu gekbus langit di melaat penggulaula niu.” ");
INSERT INTO syb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Saꞌ maꞌnia, minateng na puliꞌ si nga Isus dia Jerusalem. Benaꞌ minateng ilan, mikpanawpanaw si Isus diag lenuꞌan nu Pengedapan tu Megbebayaꞌ. Mendadi ki nga kaunutan nug belian nu getaw Judea mukaꞌ su nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ kampuꞌ nu ngag duma kaunutan nu getaw Judea, minadap ilan dini Isus. ");
INSERT INTO syb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Sinaak nilan diniin, “Paa, ki pinggulaula mu kini, taꞌ bai pegbayaꞌ mu menggulaula dun? Taꞌ taway dun bai migbegay diniꞌa pegbayaꞌ penggulaulaan mu?” ");
INSERT INTO syb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Laung pelum ni Isus dinilan, “Naa, saakan ku amu deliꞌ sektaang. Dayun saꞌ mesembag na niu, pesuun ku dadema diniu su pigenatan nu pegbayaꞌu penggulaulaan kui maꞌnini kini. ");
INSERT INTO syb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Iini sembag niu dinaan, si Juan kiin, adin genat su pegbayaꞌen memunag tubig tu nga getaw? Genat tu Megbebayaꞌ, saꞌ genat ba laak di kilawan? Iini sembag niu.” ");
INSERT INTO syb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Naa saꞌ maꞌnia, migyagayaga dayuni nga kaunutan kia, laung nilan, “Naa, taꞌ ma? Saꞌ pinenggiꞌ sembagen ta, ‘Su pegbayaꞌ ni Juan, genat tu Megbebayaꞌ,’ naa sumumpat dayun si Isus kini, ‘Saꞌ maꞌantu, mauma dema ndaꞌ niu petuuday si Juan?’ ");
INSERT INTO syb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Saꞌ sembagen ta pasiꞌ, ‘Genat laak di kilawan,’ naa ndiꞌ mesuꞌat.” (Puꞌ saꞌ maꞌniai sembag nilan, mendek ilan tu nga getaw, puꞌ su kelaun getaw, mituudan ilan dun puꞌ pimuunan nu Megbebayaꞌ si Juan.) ");
INSERT INTO syb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kaas iin laaki mesembag nilan dini Isus, “Ndaꞌ nami mesuunay.” Laung dayun ni Isus dinilan, “Naa saꞌ maꞌantu, ndiꞌu dadema pesuun diniu saꞌ taꞌi pigenatan nu pegbayaꞌu penggulaulaan kui maꞌnini kini.” ");
INSERT INTO syb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Mendadi, migukit si Isus sambingay tu nga Pariseo kia. Laungen, “Duuni getaw migimula pegimulanan gubas. Benaꞌ mitubusen pemulanay, binaliten dayuni pegimulananen, migengkul seludan tu nga tubig nu gubas saꞌ intesenen, mukaꞌ migbaal pa pagid metaas pegelungan dun. Saꞌ mitubus, pisaꞌupen di nga getawi pegimulananen kia, dayun mipanaw dig lain benwa. ");
INSERT INTO syb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mendadi benaꞌ sumingkuꞌ na su pegimulanan, suminuguꞌ su gapuꞌen di sala tawan sesuguꞌenen meditu nga saꞌup, puꞌ adun elapenen sug daniin gilas tu nilan. ");
INSERT INTO syb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Laak dagid kaliꞌ dateng ditu su sinuguꞌ, aba, ginapus nu nga saꞌup, binadas nilan pa pagid dayun piuliꞌ, ndaꞌiduni miwiten pia maikaꞌ. ");
INSERT INTO syb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Naa su gapuꞌ nu pegimulanan, suminuguꞌ pa pelum sala tawan sesuguꞌenen. Benaꞌ minateng ditu su sinuguꞌ, bintul nu nga saꞌup di gulu, piksudiꞌan nilan pa pagid. ");
INSERT INTO syb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Naa su gapuꞌ nu pegimulanan, suminuguꞌ na pelum di ketelu tawan sesuguꞌenen. Benaꞌ minateng ditu nga saꞌup, binunuꞌ nilan. Naa melaun pai sinuguꞌ, iin nai migbatag ia. Sug duma sinuguꞌ, binadas nilan, mukaꞌ sug duma, binunuꞌ nilan. ");
INSERT INTO syb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mendadi benaꞌ miniben, mibilin laaki sala tawan, ki na bataꞌ nu gapuꞌ pegimulanan kia, ki petailenen gupia. Tigaꞌwan, iin na sungkini sinuguꞌen mangay tu nga saꞌup. Puꞌ maaꞌ laung pa nu gapuꞌ nu pegimulanan dialem delendemanen, ‘Tumuꞌ saꞌ kig bataꞌu na kini, pegbesaan nilan iin.’ ");
INSERT INTO syb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Laak dagid saꞌ midayag nu nga saꞌup sug bataꞌen kia, miksabutsabut ilan dayun, laung nilan, ‘Aa naa, kiin na tuꞌu sug bataꞌ nu gapuꞌ nu pegimulanan kini. Tala, tumuꞌ petain tain, adun danita na su petenged sia diniin!’ ");
INSERT INTO syb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mendadi benaꞌ minateng dia nilan kig bataꞌ kini nu gapuꞌ nu pegimulanan, inukpaꞌan nilan, pinatay nilan tuꞌu. Sug bangkayen dayun, piniglak nilan tug liu nu pegimulanan. ");
INSERT INTO syb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Naa saꞌ maꞌnia,” sinaak ni Isus, “alandun ma dayuni penggulaulaan nu gapuꞌ nu pegimulanan gubas? Iin nai mangay ditu pegimulananen, adun pemunuꞌenen ki nga saꞌup kia. Dayun lain getaw na pelumi pesaꞌupen tu pegimulananen kia. ");
INSERT INTO syb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Puꞌ ndaꞌ ba niu mbasa su sinulat ditu Misulat Taluꞌ nu Megbebayaꞌ, maꞌniniꞌ? ‘Kig batu pimilas nu nga megbaal balay, iini mibaal tampusan gempagen gintudan nug balay. ");
INSERT INTO syb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Puꞌ kiin, pigbaal nu Kaunutan Megbebayaꞌ, kaas leliagen ita dun gupia!’” ");
INSERT INTO syb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Naa ki nga kaunutan nu getaw Judea, benaꞌ midengeg nilani tinaluꞌ kia ni Isus, pedaap nilan sia iin, puꞌ misimaꞌ nilan puꞌ ilani pisugaten ditu nga saꞌup tu sambingayen kia. Kaas pidaap nilan sia si Isus, laak ndaꞌ nilan megaga daapay, puꞌ mindek ilan tu melaun getaw. Kaas bilengan nilan si Isus, migawaꞌ ilan dia. ");
INSERT INTO syb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Naa duuni nga Pariseo mukaꞌ nga sakup ni Herodes, sinuguꞌ ilan nu kaunutan nilan mangay ditu ni Isus lumantugiꞌ diniin, adun sia metaban nilan si Isus di teluꞌenen. ");
INSERT INTO syb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Mendadi minadap dini Isus su sinuguꞌ, tautau suminaak ilan, “Naa Sir, misuunan nami puꞌ pektuꞌun mu su metuud. Ndaiꞌ pegisuun mu tu tindeg nu getaw, kaas ndiꞌa mpesuay di metuud, pektuꞌun mu gusay su tantu mauyaꞌan nu Megbebayaꞌ pegbetaden nu getaw. Naa saꞌ maꞌantu, biwang ba ditu Misulat Palinta nu Megbebayaꞌ, megbuis ita ditu tampusan gadiꞌ si Cesar, saꞌ ndaꞌ? Megbuis bami dun, saꞌ ndiꞌ?” ");
INSERT INTO syb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Laak dagid misuunan ni Isus puꞌ iini puun nu kesaak nilan diniin kia, su tautau kekesuun nilan. Kaas laungen dinilan, “Baa, mauma pengimanan ma niau? Alap amu selaad selapiꞌ, paitaꞌ niu deliꞌ dinaan.” ");
INSERT INTO syb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tinulunan nilan dayun si Isus selapiꞌ. Sinaak dayun ni Isus dinilan, “Naa, taꞌ taway dun baig lingaw kini? Taꞌ ngalanen bai misulat dadema dini kini?” Laung nilan, “Dani Cesar.” ");
INSERT INTO syb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kaliꞌ pektaluꞌ si Isus, “Naa saꞌ maꞌantu, kig dani Cesar, bayad da niu diniin. Dayun sug danu Megbebayaꞌ, begay da niu dema ditu Megbebayaꞌ.” Kaliꞌ medengeg nu nga sinuguꞌ ki tinaluꞌ kia ni Isus, misebuꞌan ilan diniin. ");
INSERT INTO syb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Naa duun pelumi nga Saduseo mituaꞌ ditu ni Isus. Naa ki nga Saduseo kini, ilani sala pikumpungan ndiꞌ ilan mengintuudan dun puꞌ su nga minatay, metubuꞌ daw puliꞌ. Mendadi, kaliꞌ pembaalbaal sumaak dini Isus ki nga Saduseo, ");
INSERT INTO syb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Naa Sir, duuni palinta dinita pisulat nu Megbebayaꞌ dini Moises, ‘Saꞌ daw matayig laki mikenginsawa na, laak ndaꞌidunig bataꞌen, naa subay sukliin nu pated nu minatay. Iini menginsawa tug balulibun, adun duunig bataꞌ nilan, lepeng bataꞌ nu minatay kitu. ");
INSERT INTO syb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mendadi, duuni pitu tawan mekpated. Minginsawa su gulangbataꞌ dayun minatay, ndaꞌidun paig bataꞌen.’ ");
INSERT INTO syb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Dayun su keduaꞌ pateden pelum, pinginsawanen sug balulibun dayun minatay, dakus su ketelu pateden. ");
INSERT INTO syb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Iin nai migbatag, gikteb nu pitu tawan kia, lumbus minatay, ndaꞌidun da gusayig bataꞌen. Dayun sug libun, minatay dadema. ");
INSERT INTO syb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Naa paladpalad saꞌ duun siai metubuꞌ daw puliꞌ genat matay, naa kig libun kia, adin ma dayuni sawanen ditu pitu tawan kia, kagina migelaꞌ ma mayan mpenginsawa nu mekpated kia?” ");
INSERT INTO syb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Laak dagid kaliꞌ sembag si Isus, “Baa, gembagel gupiaig lapang niu! Puꞌ ndaꞌ niu mesabut su Misulat Taluꞌ nu Megbebayaꞌ, sampay ndaꞌ niu dadema mesabut su gikteb nu ginuung nu Megbebayaꞌ! ");
INSERT INTO syb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Puꞌ saꞌ metubuꞌ na puliꞌ su nga minatay, ndiꞌ nailan meksenlangan, segaga mesama ilan ditu nga sesuguꞌen nu Megbebayaꞌ getaw langit. ");
INSERT INTO syb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mukaꞌ padun, petubuꞌen daan puliꞌ tuꞌu su nga minatay, puꞌ ndaꞌ ba niu mbasa ki sinulat ni Moises dengantu, ditu sinulaten mekatag di sigbet kiin migligaꞌ? Maaꞌ laung nu Megbebayaꞌ dini Moises, ‘Naani Megbebayaꞌ pektemuyen ni Abraham, pektemuyen ni Isaac, mukaꞌ ni Jacob.’” ");
INSERT INTO syb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kaliꞌ gusay pektaluꞌ si Isus, “Naa misuunan ta, iini mektamuy tu Megbebayaꞌ su getaw tetubuꞌ, kanaꞌ nu nga minatay.” Laung pa ni Isus tu nga Saduseo, “Kagina maꞌantu, mipatiꞌ amu daan melapang.” ");
INSERT INTO syb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Naa duuni sala tawan dia mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ. Benaꞌ midengegen su keglantugiꞌ nilan dini Isus, misabuten puꞌ misugatan ni Isus su sembagen dia nga Saduseo mingindan diniin. Mendadi, minangay dia gupid ni Isus suminaak diniin, “Sir, ta palintaay duni tampusan metaas di nga kelaunanen kiin?” ");
INSERT INTO syb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Kaliꞌ sembag si Isus, “Inii tampusan metaas di kelaunan palinta, ‘Pekineeg amu gupia, yamu nu nga getaw Israel! Su Kaunutan ta Megbebayaꞌ, salanen da, salabuuk laaki Kaunutan. ");
INSERT INTO syb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Saladuaꞌ diniu, petail mu tantu su Kaunutan mu Megbebayaꞌ, saꞌitada pegwakil mu diniin su tibuuk ginaa mu mukaꞌ su tibuuk gimuud mu dakus su tibuuk delendeman mu sampay su gikteb sekeg mu.’ ");
INSERT INTO syb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Dayun kini pelum ki keduaꞌ metaas palinta, ‘Petail mu dadema sug duma mu. Su kepetail mu diniin, pelepeng mu di kepetail mu dig lawas mu.’” Kaliꞌ pagid pektaluꞌ si Isus, “Naa kig duaꞌ buuk palinta kini, ndaꞌidun naig lain palinta metaas pa dun dini.” ");
INSERT INTO syb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Benaꞌ mideksuꞌ mektaluꞌ si Isus, suminumpati sala tawan kia mekpetuꞌun di Misulat Palinta, “Aa naa, Sir, metuud lai daan! Metuud gupia ki tinaluꞌ mu kiin, salabuuk laaki Kaunutan Megbebayaꞌ, ndaꞌig lain. ");
INSERT INTO syb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Su Megbebayaꞌ, subay petailen tantu nu getaw, saꞌitada pegwakil nu getaw diniin su tibuuk ginaanen mukaꞌ su tibuuk delendemanen, sampay su tibuuk sekegen, dakus subay petailen nu getaw sug dumanen, lepeng di kekpetailen dig lawasen. Tumuꞌ pa petuuden nu getaw kig duaꞌ buuk palinta kini, sabayaꞌ mengilak tu Megbebayaꞌ guliden mukaꞌ sug lumaun betang pengilaken diniin.” ");
INSERT INTO syb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Naa benaꞌ mideksuꞌ nu mekpetuꞌun su tinaluꞌen, misimaꞌ ni Isus puꞌ telisebuteni sembag nu getaw kia. Kaas tiluꞌan dayun ni Isus iin, “Sungua na mekesakup tu Keglekaunutan nu Megbebayaꞌ.” Naa genat itu, ndaꞌidun nai getaw mekakuꞌ sumaak dini Isus. ");
INSERT INTO syb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Mendadi, saanan pa ni Isus mekpetuꞌun dia Pengedapan tu Megbebayaꞌ, duuni sinaaken tu nga getaw, laungen, “Su nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, mauma dema maꞌniniꞌi pekteluꞌen nilan? Ki gasal nu Tinduꞌ nu Megbebayaꞌ Meglekaunutan, laung nilan sapuꞌ laak daw ni David. ");
INSERT INTO syb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Naa, mauma dema maꞌniaig laung nilan, asa si David, iin gupiai pisulat nug Balakat nu Megbebayaꞌ maꞌniniꞌ? ‘Tinaluꞌ nu Kaunutan Megbebayaꞌ ditu Kaunutan ku, Pegingkuda dini gupidu, dini dapit lintuu, sampay di gendaw pelebaun ku yaꞌa daagen mu su nga kuntra mu.’” ");
INSERT INTO syb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Suminaak pa puliꞌ si Isus dinilan, “Kaas ki Tinduꞌ nu Megbebayaꞌ Meglekaunutan, gilal ni David Kaunutan. Mendadi kagina maꞌantu, ki gasalen, sapuꞌ ba laak ni David?” Laak dagid su melaun getaw pelum, benaꞌ midengeg nilan su piktuꞌun ni Isus, liliag ilan mekineeg dun. ");
INSERT INTO syb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mendadi, selian ni Isus mekpetuꞌun, duuni tinaluꞌen maꞌniniꞌ. “Peglengilam amu, adun ndiꞌ amu megelinan nug betad nu nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, ki nga meliag mekpanawpanaw mekseluk melambak suub, sampay mauyaꞌan nilan pegbesaan ilan nu getaw tu nga tebuꞌan. ");
INSERT INTO syb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Mukaꞌ saꞌ ditu ilan keglekebibu, pemiliꞌen nilan su pegingkudan nu pegbesaan getaw. Mesama dia simbaan, pemiliꞌen nilan su tampusan metaas gingkudan. ");
INSERT INTO syb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mukaꞌ padun, peglimbungan nilani ngag balulibun, mengagaw ilan tu pimetang nilan, asa petaasen nilan su kenenabi nilan, pekpaitaꞌitaꞌ laak nilan. Naa maꞌnia, midugangan dema tuꞌui kebegat nu ginukuman ditu nga mekpetuꞌun di Palinta kiin!” ");
INSERT INTO syb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Naa pegingkud si Isus diag Balay Pengedapan tu Megbebayaꞌ, dia mesempel nug betangan nu nga getaw gamut nilan. Pegbentayanen su nga getaw megbegay gamut nilan ditu Pengedapan. Saꞌ miglegamut ilan, melaun mekedatuꞌ getaw dia, melaun dademai ginamut nilan. ");
INSERT INTO syb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mendadi, duun pelumig balulibun minateng, pubri gupia, migbetang dadema gamuten, laak duaꞌ laad sinsilyu. ");
INSERT INTO syb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Benaꞌ minitaꞌ ni Isus, sinabinen dayun su nga sakupen mekpesempel diniin. Kaliꞌ pektaluꞌ dinilan, “Taman taluꞌu diniu, ki pubri kini balulibun, gembagel pai ginamuten kiin, sabayaꞌ su ginamut nu nga kelaun getaw dini. ");
INSERT INTO syb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Puꞌ sug duma getaw, ginamuten su laak kapin nu gimunen. Dagid kig balulibun kini, pia pubri gupia, gilaꞌen da gusay begay sug bataꞌ misukaten.” ");
INSERT INTO syb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Mendadi, saanan ni nga Isus megawaꞌ dia Pengedapan tu Megbebayaꞌ, laung nu sala tawan sakupen, “Sir, bentayay mu pa daan, melengas gupiai nga ginumbelayan kini! Mesibaꞌi ngag batu pengimbaalanen!” ");
INSERT INTO syb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Sumimbag si Isus, “Waꞌa daan, maitaꞌ pa niu nandaw ki mekelengas gupia ginumbelayan kini. Dagid duuni gendaw mateng, pia salabuuk batu di kitentudanen, ndaꞌiduni mesamaꞌ dun, megelaꞌ gupia penggebaꞌay.” ");
INSERT INTO syb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Naa pegingkud si Isus tug dibabaw nug Bentud Olibo, tug dipag miꞌentag nug Balay Pengedapan tu Megbebayaꞌ. Mendadi si Pedro, si Santiago, si Juan mukaꞌ si Andres, minadap ilan dini Isus, ilanilan da, ");
INSERT INTO syb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","suminaak ilan diniin, “Naa saꞌ mesuꞌat, Sir, pesuun mu dinami, nanu ma mpenggulaula? Mukaꞌ alanduni tuꞌusan dun saꞌ sungu na menuudig launan tinaluꞌ mu kiin?” ");
INSERT INTO syb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Sumimbag si Isus, “Naa, peglengilam amu, adun ndiꞌ amu melimbungan nu getaw. ");
INSERT INTO syb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Puꞌ melaun metuaꞌ, engkenen nilani gelalu, laung nilan, ‘Naani Tinduꞌ nu Megbebayaꞌ Meglekaunutan!’ Benaꞌ melaun getaw melimbungan nilan. ");
INSERT INTO syb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mukaꞌ pagid, saꞌ duuni medengeg niu pegbunuꞌ dia mesempel sampay tu melayuꞌ, ndiꞌ amu melibuleng dun. Puꞌ subay mpenggulaula itu, laak kanaꞌ paini kelengkeb nug benwa. ");
INSERT INTO syb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Puꞌ su sala nasud, lumumpak daan dig lain nasud. Su sala peglegediꞌan, lumumpak dig lain peglegediꞌan. Mukaꞌ duuni ngag linug di tibuuk benwa, dakus mian pa pagidi meliget gutem. Dagid ki nga gempenggulaula kia, maꞌniin laak penenggiꞌan saꞌ mekpuun pa megbatik tian sug libun. ");
INSERT INTO syb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Dagid peglengilam amu daan. Puꞌ dengaten amu di gedapan nu kuis dakus pemesaitan amu nu getaw Judea tug dialem nga simbaan nilan, dakus dengaten amu di gedapan nu nga gadiꞌ mukaꞌ duma kaunutan, sabaꞌ nu kesakup niu dinaan. Mendadi su sembag niu dun, iini mbaal sikaw niu megukit di Gempia Petenday. ");
INSERT INTO syb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mukaꞌ ki Gempia Petenday kini, subay pegukit pa ditu kelaun bansa, dekag pa melengkebig benwa. ");
INSERT INTO syb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kaas saꞌ daapen namu dakus dengaten amu tu gedapan nu kuis, ndiꞌ amu melibuleng dun pedaan, saꞌ taꞌ alandun mai sembag niu. Segaga saꞌ penenaakan namu, taluꞌ niu laak ki petaluꞌ pa diniu. Puꞌ ki sembag niu, kanaꞌ laak daniu taluꞌ, puꞌ pedelendem da diniu nug Balakat nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Laung ni Isus, “Duuni getaw megwakil di nga pated nilan petain, mukaꞌ maꞌniin dademai penggulaulaan nu nga getaw dig bataꞌen. Sampay su nga gembataꞌ, kuntraanen dadema su ginaꞌen mukaꞌ gamaꞌen, sampay meksimawiꞌ dinilan ki petain. ");
INSERT INTO syb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bentaan amu nu kelaun getaw sabaꞌ nu kesakup niu dinaan. Dagid adin su getaw mektigel sampay mengikteb, iini megawen.” ");
INSERT INTO syb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Kaliꞌ gusay pektaluꞌ si Isus, “Naa ki giningelanan Mekelemuꞌ mukaꞌ Mekpelaat, maitaꞌ pa niu, paindegen diag Balay Pengedapan tu Megbebayaꞌ, dia tandaꞌ kanaꞌ bantang paindegan dun.” (Naa ki sinulat kini, subay sebuten gupia nu megbasa dun!) Maaꞌ laung padun ni Isus, “Mendadi saꞌ metandaꞌ na dia ki Mekelemuꞌ mukaꞌ Mekpelaat kia, naa su nga getaw dini Judea, subay meglaguy tu ngag binentudan. ");
INSERT INTO syb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Adin su getaw metaang dia gatep nug balayen, ndiꞌ pia melangan suled pa diag dialem puꞌ malap di pimetangen. ");
INSERT INTO syb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Samanen su getaw saꞌ metaang ditug binaalanen, ndiꞌ dadema mpia melangan muliꞌ puꞌ engainen laak sia su melambak suuben. ");
INSERT INTO syb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Naa sug libun saꞌ metaang dig bedesanen ki gendaw kiin, mesama su pegduduꞌan pa, aa, mekelelaatlelaat ilan gupia! ");
INSERT INTO syb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mukaꞌ iini penenebiin niu, ndiꞌ dadema metaang di timpu metegdaw! ");
INSERT INTO syb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Puꞌ ki kelegenay di gendaw kiin, ndaꞌidun naig lain kelegenay mekelepeng dun, genat ditu pikpuunan, su kebuat nu Megbebayaꞌ di gekleb langit buꞌ lupaꞌ sampay nandaw, mukaꞌ sampay ditug binayaꞌ gebii buꞌ gendaw. ");
INSERT INTO syb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kaas saꞌ ndiꞌ nu Kaunutan Megbebayaꞌ engkanan su kaiben nu kelegenay kia, ndaꞌidun na siai mesamaꞌ getaw tetubuꞌ, megelaꞌ ilan sia mesapul. Dagid engkanan pa tuꞌu nu Megbebayaꞌ su kaibenen, sabaꞌ nu nga tinduꞌen sakupen. ");
INSERT INTO syb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Mendadi,” maaꞌ laung pa ni Isus, “saꞌ duuni mektaluꞌ diniu, ‘Bentayay pa daan niu, kiin na su Tinduꞌ nu Megbebayaꞌ Meglekaunutan!’ atawaka duuni mektaluꞌ, ‘Kia nain!’ naa ndiꞌ amu pekpetuud dun. ");
INSERT INTO syb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Puꞌ duun pai nga metuaꞌ tautau iini Tinduꞌ nu Megbebayaꞌ Meglekaunutan, mukaꞌ metuaꞌ dademai nga tautau pimuunan nu Megbebayaꞌ. Mekpaitaꞌ ilan nga ginuung mukaꞌ mekesalebuꞌ tuꞌus, puꞌ adun megaga nilan sia peglimbungay pia pa su tinduꞌ nu Megbebayaꞌ sakupen. ");
INSERT INTO syb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kaas peglengilam amu! Puꞌ daan ku na pisuun diniu kig launan mpenggulaula.” ");
INSERT INTO syb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Pidayun gusay ni Isus su taluꞌen, laungen, “Mendadi, saꞌ mengikteb nai kelegenay kia, su gendaw, ndiꞌ na tuiag, mukaꞌ sug bulan, ndiꞌ na dema meglamag. ");
INSERT INTO syb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Su ngag bitun ditug langit, meglabuꞌ, mukaꞌ su kelaun mibetang ditu gawanawan, mekegyugegyug. ");
INSERT INTO syb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Naa mendadi saꞌ menuud naig launanen, naan kini, kig Bataꞌ nu Kilawan, medayag nau tuꞌu nu kilawan, metuaꞌu di gabun, medayag na su metaas ginuungu, mukaꞌ maitaꞌ di tiagu su kelengas nu pegbayaꞌu. ");
INSERT INTO syb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Mendadi saꞌ lumusadu, suguꞌen ku dayun su nga sesuguꞌen ku getaw langit, adun leepen nilan sug dibabaw lumbang, pungunen nilan su getaw pimiliꞌ nu Megbebayaꞌ sakupen, genat ditu pingikteban benwa ditu dapit silangan sampay ditu tampusan benwa dapit sindepan.” ");
INSERT INTO syb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Kaliꞌ gusay pektaluꞌ si Isus, “Naa, alap niu tituluꞌan ki gayu igera. Sug igera, saꞌ mentubil su panganen dayun megbegu daun, mesuunan niu puꞌ sungu na memedesig benwa. ");
INSERT INTO syb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Naa maꞌantu dadema, saꞌ maitaꞌ niui nga gempenggulaula kini, mesuunan niu dadema puꞌ naan, sungu nau tuꞌu mateng puliꞌ, gitunganen, dia nau bisuangan nug balay. ");
INSERT INTO syb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Taman taluꞌu diniu, ndiꞌ tagad mematay su nga getaw tetubuꞌ nemun, megelaꞌ pa menuudig launanen kini. ");
INSERT INTO syb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Puꞌ su gekleb langit buꞌ lupaꞌ, megelaꞌ da mbeleng. Laak dagid ki pekteluꞌen ku kini, ndaꞌi kebelengen.” ");
INSERT INTO syb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Kaliꞌ gusay pektaluꞌ si Isus, “Laak dagid ki gempenggulaula kiin, ndaꞌiduni getaw mekesuun dun, saꞌ taꞌ endaway dun atawaka taꞌ urasay dun. Pia pa su nga sesuguꞌen nu Megbebayaꞌ ditu gekbus langit sampay naan, kig Bataꞌen, ndaꞌi mekesuun dun, subay su laak Gamaꞌu. ");
INSERT INTO syb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kaas pegenduk amu, saꞌitada pektalenten amu, puꞌ ndaꞌ niu mesuunay saꞌ nanu mpenggulaula. ");
INSERT INTO syb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Puꞌ kiin, penenggiꞌan dun ki getaw mipanaw di melayuꞌ. Saꞌ sinegay ndiꞌ pa mpanawi getaw kini, pegwekilanen su nga sesuguꞌenen, tukidenen dinilani pebaalen dinilan, mukaꞌ teluꞌenen tu megingat dig bisuangan, megenduk gusay. ");
INSERT INTO syb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Naa saꞌ maꞌantu, yamu dema, pegenduk amu lelayun, puꞌ ndaꞌ niu mesuunay saꞌ nanu dateng ki gapuꞌ balay kini, saꞌ lelabung ma, saꞌ titengaꞌ gebii ba, atawaka daliꞌ endaw, atawaka saꞌ siselem na gupia. ");
INSERT INTO syb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Saꞌ mbuus metekawi kedatengen, ndiꞌ pia medetenganen ki pektulug amu. ");
INSERT INTO syb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kaas ki tinaluꞌu diniu kini, taluꞌu dadema di nga tibaꞌan getaw, peglengilam amu!” ");
INSERT INTO syb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Maꞌantu, duaꞌ gebii pa mekpuun sug Lumpuk tug Liniusan, metaang dun sug Lumpuk di Pan ndaꞌ Petulinay. Mendadi ki nga kaunutan nug belian nu getaw Judea mukaꞌ ki nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, minengaw ilan suꞌatan nilan di kedaap nilan dini Isus, puꞌ adun pepatay nilan iin. Laak pigunguban nilan. ");
INSERT INTO syb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Laung nilan, “Ndiꞌ mesuꞌat metaang dig Lumpuk, puꞌ buus menlimuuk su nga getaw.” ");
INSERT INTO syb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Naa si Isus, sinegay ditu pelum Betania, inggat iin maan diag balay ni Simon, su getaw kiin minayan megladu mekesalebuꞌ nuka. Benaꞌ saanan ni Isus maan, duuni minateng libun peguit bataꞌ bandi gemputiꞌ, mipenuꞌ pagemut piningalan dun ki pagemut kia, nardo, melagaꞌ gupia. Mendadi pinungak dayun nug libun sug liig nug bataꞌ bandinen bitangan pagemut, binunagen dayun di gulu ni Isus. ");
INSERT INTO syb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Dagid duunig duma getaw dia, milaati ginaa nilan dun, diadia pekteluꞌenen dig dumanen, “Baa, mauma dema ki pagemut kiin, pikulaꞌulaꞌan laak? ");
INSERT INTO syb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Iin siai melengas, piksaluy sia, mabuꞌ malin sia labi telu gatus denario, dayun begay tu nga pubri su galinen.” Mukaꞌ pigbeluꞌan nilan namal kig libun kini. ");
INSERT INTO syb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Dagid miktaluꞌ si Isus, “Aba, maꞌnia da! Mauma libulengen ma niuig libun kini? Ki pinggulaulanen dinaan, melengas. ");
INSERT INTO syb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Su pubri, lelayun niu mpungun megbenwa. Kaas pia taꞌ endaway dun, saꞌ mauyaꞌan niu ebangan niu, naa mesuꞌat da gusay. Naan dagid, kanaꞌ nau maiben dumuma diniu dini. ");
INSERT INTO syb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Naa kig libun kini, adin su gikteb megaganen baalenen, binaalen dayun. Puꞌ pigupiananen pedaanig lawasu di kelebeng sungu dinaan. ");
INSERT INTO syb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mendadi taman taluꞌu diniu, pia adin pegukit su Gempia Petenday dinig dibabaw lumbang, naa mpeduma dun dadema pegukit ki pinggulaula nig libun kini, puꞌ adun ndiꞌ iin melingawan.” ");
INSERT INTO syb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Mendadi kini si Judas Iscariote, sala tawan di nga sepuluꞌ buꞌ duaꞌ peneligan ni Isus, linaawanen su nga kaunutan nug belian nu getaw Judea, adun tipuunen dinilan si Isus. ");
INSERT INTO syb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mendadi ki nga kaunutan kini, benaꞌ midengeg nilani tinaluꞌ kia ni Judas, aa naa, didialan nilan, pisadan nilan dayun si Judas, tindanan nilan iin selapiꞌ. Kaas genat nitu, si Judas kini, piksuꞌatsuꞌaten dayuni sikawen tumipu dini Isus. ");
INSERT INTO syb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mendadi, minateng sug bekna gendaw nug Lumpuk di Pan ndaꞌ Petulinay, metaang dun sug betad nu nga getaw Judea mektitiꞌ nati karniru guliden nilan tu Megbebayaꞌ, gindan nilan tug Liniusan. Mendadi, suminaak dini Isus su nga sakupen, “Sir, kig Lebungan ta tug Liniusan, adin mu ami pengayay, adun ulingelen nami?” ");
INSERT INTO syb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Sinuguꞌ dayun ni Isusig duaꞌ tawan sakupen, laungen dinilan, “Bundas amu ditu syudad. Saꞌ mateng amu ditu, duun dayunig laki mesungkak niu, pekpisan bandi bitangan tubig. Iini tendugay niu, ");
INSERT INTO syb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","adin sug balay seledanen, taluꞌ niu dayun ditu gapuꞌ balay, ‘Naa, pimuun nu Mekpetuꞌun, laungen, Adin dapit su sugud pengaanan nami tug Lebungan nami tug Liniusan, yami nu nga sakupu?’ ");
INSERT INTO syb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Naa saꞌ maꞌnia,” laung ni Isus, “paitaꞌen dayun diniu ki gembagel sugud dia dapit ditaas, misangkap na. Dia na niu pegulingelayig Lebungan ta.” ");
INSERT INTO syb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Mipanaw dayun sug duaꞌ tawan sakup ni Isus. Benaꞌ minateng ilan tu syudad, midetengan nilan tuꞌu, maaꞌ dadema nu tinaluꞌ ni Isus. Pigulingel nilan dayun dia sug Lebungan nilan tug Liniusan. ");
INSERT INTO syb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Naa benaꞌ misindep nai gendaw, miditu si Isus, ilan nu nga sepuluꞌ buꞌ duaꞌ tawan sakupen. ");
INSERT INTO syb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mendadi, benaꞌ pekaan nailan, kaliꞌ pektaluꞌ si Isus dinilan, “Taman taluꞌu diniu, ki sala tawan diniu suminalu gupia dinaan maan kini, mektipu dinaan.” ");
INSERT INTO syb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Milibuleng dayun su nga sakup ni Isus. Miglimbuslimbus ilan sumaak diniin, “Asa Sir, kanaꞌ da sia naani pekteluꞌen mu kiin?” ");
INSERT INTO syb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Sumimbag si Isus, “Sala tawan lai diniu, yamu nga sepuluꞌ buꞌ duaꞌ tawan kini suminalu gupia dinaan. ");
INSERT INTO syb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Puꞌ naan kini, kig Bataꞌ nu Kilawan, mbinasau tuꞌu, maaꞌ dadema nu misulat pedaan ditu Taluꞌ nu Megbebayaꞌ. Laak dagid pia maꞌantu, ki getaw mektipu dinaan, kig Bataꞌ nu Kilawan, mekelelaatlelaat gupia! Tumuꞌ pa ndaꞌ na sia pegigetawi getaw kiin!” ");
INSERT INTO syb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mendadi benaꞌ maan ilan, minalap si Isus pan, mikpaladpalad dayun tu Megbebayaꞌ. Pimetanen dayun su pan, dayunen pentulunay dia nga peneliganen. Kaliꞌ pektaluꞌ, “Naa, alap amu dun ini. Kini sug lawasu.” ");
INSERT INTO syb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Minalap pelum si Isus sala tasa penginumen. Benaꞌ mikpaladpalad na puliꞌ tu Megbebayaꞌ, dayunen tulunay dia nga sakupen ki tasa kini. Mininum ilan dun dayun, launan nilan. ");
INSERT INTO syb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kaliꞌ pagid pektaluꞌ si Isus, “Kini sug duguꞌu, ki mekigis na, adun gugas tu salaꞌ nu melaun getaw. Kig duguꞌuig bian nug begu pasad nu Megbebayaꞌ tu getaw. ");
INSERT INTO syb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mendadi, taman taluꞌu diniu, genat nandaw, ndiꞌ nau puliꞌ minum di penginumen kini, sampay da dun mateng su gendaw meglekaunutan na tuꞌu su Megbebayaꞌ. Dekagu pa inumay kig begu ginis penginumen ditu Keglekaunutanen.” ");
INSERT INTO syb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Naa benaꞌ mitubus si nga Isus maan Lebungan nilan, migbebat ilan kegenal tu Megbebayaꞌ, dayun ilan mengguaꞌ dia, tumiwad ilan tug Bentud nu nga Gayu Olibo. ");
INSERT INTO syb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Mendadi, kaliꞌ pektaluꞌ si Isus tu nga peneliganen, “Yamu kini, megelaꞌ amu tuliud dinaan. Puꞌ iini misulat ditu Taluꞌ nu Megbebayaꞌ, ‘Miktaluꞌ su Megbebayaꞌ, petain ku ki megingat tu karniru, dayun megelaꞌ mesigwag su nga karniru.’” ");
INSERT INTO syb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Maaꞌ laung pa ni Isus, “Dagid benaꞌ genatu petubuꞌay puliꞌ, megunau diniu ditu Galilea.” ");
INSERT INTO syb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Kaliꞌ sumpat si Pedro, “Aba Sir, pia teliudan ka nu nga kelaun dumau, naan kini, ndiꞌ nau gusay tuliud diniꞌa!” ");
INSERT INTO syb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","“Taman taluꞌu diniꞌa,” laung ni Isus, “dekag pasiꞌ peguni su manuk duaꞌ deksuꞌ gebii kini, metelu deksuꞌa na memalaw puꞌ kanaꞌ mau mailala.” ");
INSERT INTO syb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Dagid mimantek gupia si Pedro mektaluꞌ, laungen, “Pia mekendutaꞌ, saliunungan ku yaꞌa, ndiꞌu da lai pemelaun puꞌ kanaꞌu yaꞌa mailala!” Mukaꞌ su kelaun sakup ni Isus, maꞌnia dademai penteluꞌen nilan. ");
INSERT INTO syb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Naa minundas si nga Isus tu pegimulanan gayu piningalan dun Getsemane. Benaꞌ minateng ilan dia, kaliꞌ pektaluꞌ si Isus di nga sakupen, “Naa, pegingkud amu deliꞌ dini, puꞌ menenabi pau dia.” ");
INSERT INTO syb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Dayun iwiten dumanen si Pedro, si Santiago, mukaꞌ si Juan. Mendadi benaꞌ melayuꞌlayuꞌ nailan diag duma nilan, diduaꞌani ginaa ni Isus, milegenan dun gupia. ");
INSERT INTO syb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Laungen dayun dia telu tawan dumanen, “Milegenanu ini, mibegatanu dun patiꞌ, maꞌniin na petayan ku ini. Kaas dini damu dun deliꞌ, pegenduk amu.” ");
INSERT INTO syb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Minundas kemaikaꞌ dia gunaan si Isus, dayun miglaub dig lupaꞌ menenabi. Iini pinenabinen saꞌ sia mesuꞌat, ndiꞌ na mayan diniin ki kegbinasa diniin. ");
INSERT INTO syb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kaliꞌ pektaluꞌ, “Uu Amaꞌu, ndaꞌiduni ndiꞌ mu megaga. Kaas ki tasa mipenuꞌ nug lesayan ku sunguu na inumay, naa peliaw mu sia dinaan, adun ndiꞌu na mainum. Laak dagid, Amaꞌ, sug daniꞌa mauyaꞌan, iini penuuden, kanaꞌ nug danaan.” ");
INSERT INTO syb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Naa saꞌ maꞌnia, pinuliꞌan ni Isus su telu tawan sakupen kia. Midetenganen, tinulug ilan. Sinabi dayun ni Isus si Pedro, laungen, “Uu Simon, taꞌ itu, tinuluga? Masiꞌ ndaꞌ mu na megagai megenduka, pia laak sauras? ");
INSERT INTO syb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Baa,” laung ni Isus, “peglengilam amu mukaꞌ penenabi amu daan, adun ndiꞌ amu mpenulay. Puꞌ dig delendeman niu, gangut niu sia mekpetuud amu tu mauyaꞌan nu Megbebayaꞌ. Dagid su kekilawan niu, melubay, ndiꞌ mekpetuud dun.” ");
INSERT INTO syb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Mipanaw na puliꞌ si Isus puꞌ menenabi na pelum, maaꞌ dadema nug bekna kenenabinen. ");
INSERT INTO syb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Mendadi, kaliꞌen puliꞌay pelum su nga peneliganen, iin da gusayi mitaanganen, tinulug ilan pelum, puꞌ ndiꞌ nilan metigeli tulug nilan. Ndaꞌidun naig daꞌawa nilan. ");
INSERT INTO syb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Mendadi, benaꞌ ketelu deksuꞌ na ni Isus mpuliꞌ dia sakupen kia, kaliꞌ pektaluꞌ dinilan, “Taꞌ ma, tinulug pamu gusay, milali amu? Naa ma, pia da, sukal na! Mitektak na su sesaꞌ! Mendadi naan kini, kig Bataꞌ Kilawan, pegwakil nau tuꞌu tu pegbayaꞌ nu nga kanaꞌ megbasa tu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kaas pegbuat amu, mpanaw naita. Bentayay pa daan niu, kiin na tuꞌu ki tumipu dinaan! ");
INSERT INTO syb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Mendadi, ndaꞌ pa medeksuꞌ mektaluꞌ si Isus, misebang si Judas, ki sala tawan kiin di sepuluꞌ buꞌ duaꞌ peneligan ni Isus. Melaun getaw tumindug dini Judas kini, peguit ilan badung mukaꞌ bentul, sinuguꞌ ilan nu nga kaunutan nug belian mukaꞌ su mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ kampuꞌ nug duma kaunutan nu getaw Judea. ");
INSERT INTO syb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Naa si Judas, ki tumipu dini Isus, duuni tuꞌus gandang bigayen di ngag dumanen kia, puꞌ tinaluꞌen pedaan dinilan, “Adin su getaw elekan ku, iinen na su penengaun niu. Daap niu dayun, uit niu, peksibaꞌay niu gupia ingatay.” ");
INSERT INTO syb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mendadi kini si Judas, sikna minateng, tuminuun dayun madap dini Isus. Kaliꞌ pektaluꞌ, “Uu, Sir!” Dunut ilekanen si Isus. ");
INSERT INTO syb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Dinaap dayun si Isus, dayun gepusay gupia. ");
INSERT INTO syb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Naa sala tawan pegindeg dia mesempel, migbakut badungen, dayunen tigbasayi gulipen nu Tampusan Metaas Belian nu getaw Judea. Miseksipi sedibaluy telinganen. ");
INSERT INTO syb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Miktaluꞌ dayun si Isus dia nga melaun getaw kia, “Naa, tulisan bau, kambat amu meguit badung mukaꞌ bentul saꞌ daapen niau? ");
INSERT INTO syb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Asa gendawgendaw, naanig duma niu dia Pengedapan tu Megbebayaꞌ, mikpetuꞌunu dia, laak ndaꞌ niau daapay. Laak dagid kini, subay mpenggulaula daan, puꞌ su sinulat dengantu ditu Misulat Taluꞌ nu Megbebayaꞌ, subay menuud.” ");
INSERT INTO syb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Naa saꞌ maꞌnia, bilengan dayun si Isus nu nga sakupen, mimeglaguy ilan, launan nilan. ");
INSERT INTO syb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Laak duuni sala tawan begu getaw peglenduglendug dini Isus, mipeliumutan laak gumut, dinaap dadema sia nu ngag duma ni Judas. ");
INSERT INTO syb_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Laak ndaꞌ nilan melaam, puꞌ kaliꞌ nilan daapay, su laak gumuteni miselabet nilan. Mikelaguyi getaw kia, ndaꞌidun nai penepetenen. ");
INSERT INTO syb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Naa saꞌ maꞌantu, inagak si Isus ditug balay nu Tampusan Metaas Belian nu getaw Judea. Mikpungun ditu su kelaun kaunutan nug belian dakus su ngag duma kaunutan nu getaw Judea, sampay su nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Naa si Pedro, miglendug dadema di melayuꞌlayuꞌ, gikteb diag lenuꞌan nig balay kia. Luminamug dayun si Pedro dia nga megingat, pemegingkud ilan menalang dia gapuy. ");
INSERT INTO syb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mendadi ki nga kaunutan nug belian kia dakus ki tibuuk Pikumpungan nu Metaas Gukum nu getaw Judea, minengaw ilan sia takesiꞌ mekatag dini Isus, puꞌ adun maukuman iin petain. Laak dagid mibulugan laak su nga kaunutan kia menengaw gempia dangat nilan diniin. ");
INSERT INTO syb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Puꞌ pia melauni minakesiꞌ tu pimbaal dini Isus, ndaꞌ pektukmaꞌi teluꞌen nilan. ");
INSERT INTO syb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Duun dayuni nga getaw migindeg, tuminakesiꞌ ilan laak balus mekatag dini Isus. Laung nilan, ");
INSERT INTO syb_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Duuni midengeg nami tinaluꞌen, ‘Ki Pengedapan daw tu Megbebayaꞌ, kig binaal nu kilawan,’ laungen, ‘gebaꞌen ku. Dayun gikteb telu endaw, baalen ku puliꞌ ki sukli dun, ki kanaꞌ na pigbaal nu kilawan.’” ");
INSERT INTO syb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Laak su nga tuminakesiꞌ dig balus, ndaꞌ dadema pektukmaꞌi pekteluꞌen nilan. ");
INSERT INTO syb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mendadi su Tampusan Metaas Belian, migindeg na ditu gedapan nu ngag launan getaw. Sinaakanen dayun si Isus, laungen, “Naa, ndaꞌidun bai sembag mu di tinakesiꞌ ni nga getaw kini mekatag diniꞌa?” ");
INSERT INTO syb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Dagid ndaꞌ sembag si Isus, pia sektaang taluꞌ. Sinaakan puliꞌ nu Tampusan Metaas Belian, “Yaꞌa ba tuꞌu su Tinduꞌ nu Megbebayaꞌ Meglekaunutan, kig Bataꞌ nu Megdedengeg Megbebayaꞌ?” ");
INSERT INTO syb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","“Waꞌa,” laung ni Isus, “naan ma. Mukaꞌ duuni gendaw mateng, naan kini, kig Bataꞌ Kilawan, maitaꞌ niau, pegingkudu tuꞌu ditu dapit lintu nu Tampusan Ginuungan! Dakus maitaꞌ niau, lumusadu puliꞌ dinig lumbang kini, metuaꞌu di gabun dia gawanawan!” ");
INSERT INTO syb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Naa, apelai. Ki Tampusan Metaas Belian kini, kaliꞌen medengeg pilepeng ni Isus sug lawasen tu Megbebayaꞌ, lingetan dini Isus sug Belian. Giditen su penepetenen, kaliꞌ pektaluꞌ, “Paa, ndiꞌ ta na kambat dugangan su takesiꞌ! ");
INSERT INTO syb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Puꞌ midengeg na niu ki keksudiꞌen tu Megbebayaꞌ. Mendadi, alanduni kitab niu dun?” Piksalabuukan nilan ukumay selaꞌan si Isus, bantang na petain. ");
INSERT INTO syb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Naa saꞌ maꞌnia, su ngag duma, pindulaꞌan nilan si Isus. Tinimpeng nilan pagidi matanen, dayun nilan denegay, kaliꞌ ilan pektaluꞌ diniin, “Naa, saꞌ sia metuud puꞌ suunan ka, atuk mu saꞌ taꞌ taway dun dinamii mimesait diniꞌa?” Dayun su nga mimegingat dini Isus, binatak nilan tampalingay si Isus. ");
INSERT INTO syb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Naa si Pedro, dia pa lenuꞌan nu pengukuman. Mendadi, duuni sala tawan delaga minateng dia, sesuguꞌen nu Tampusan Metaas Belian. ");
INSERT INTO syb_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Benaꞌ minitaꞌ nug delaga si Pedro menalang dia gapuy, tintengen gupia, kaliꞌ pektaluꞌ, “Uy, yaꞌa kiin, dumaa pagid ni getaw Nazaret kiin, si Isus.” ");
INSERT INTO syb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Dagid mimalaw si Pedro. “Baa,” laungen, “ki teluꞌen mu kiin, ndiꞌu lai mesabut.” Migawaꞌ dayun dia si Pedro. Benaꞌ dia na geksid nug lenuꞌan si Pedro, duuni manuk miguni. ");
INSERT INTO syb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Naa minitaꞌ na puliꞌ nu sesuguꞌen kia si Pedro. Laung nu sesuguꞌen dia nga getaw pemegindeg dia, “Ki getaw kini, duma ma nilan!” ");
INSERT INTO syb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Laak dagid mimalaw na puliꞌ si Pedro. Naa benaꞌ ndaꞌ maiben, su getaw pemegindeg dia, miktaluꞌ ilan pelum dini Pedro, “Naa yaꞌa, minget dumaa lai nilan, puꞌ getawa Galilea ma dema.” ");
INSERT INTO syb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Dagid mingaduguꞌ tanan si Pedro, laungen, “Apelii lai! Ndiꞌu dema tuꞌu mailalai getaw pekteluꞌen niu kiin!” ");
INSERT INTO syb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Iin demai keguni manuk, keduaꞌen na meguni. Milabuꞌ dayun dig delendeman ni Pedro su tinaluꞌ kiin ni Isus, laungen, “Dekag pasiꞌ meduaꞌ peguni su manuk, metelu deksuꞌa na memalaw puꞌ kanaꞌ mau mailala.” Lilugutan dayun mengaduy si Pedro. ");
INSERT INTO syb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Naa benaꞌ putiꞌ delagay na, ki nga kaunutan nug belian mukaꞌ su ngag duma kaunutan nu getaw Judea dakus su mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, saꞌitada ki tibuuk Pikumpungan nu Metaas Gukum, miksabutsabut ilan saꞌ endutaꞌen nilan dun si Isus. Benaꞌ mitubus ilan meksabutsabut, pibalud nilan si Isus, dayun nilan egakay ditu gubirnadur, si Pilato. Benaꞌ ditu nailan gedapan ni Pilato, pigwakil nilan dayun diniin. ");
INSERT INTO syb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Mendadi, suminaak si Pilato dini Isus, “Naa, metuud ba, yaꞌa su gadiꞌ nu getaw Judea?” Kaliꞌ sembag si Isus, “Yaꞌa mai miktaluꞌ dun.” ");
INSERT INTO syb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Melaun dayun inaleg nu nga kaunutan nug belian dini Isus. ");
INSERT INTO syb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kaliꞌ pelum saakay ni Pilato si Isus, “Ndaꞌi sembag mu di melaun dangat nilan kini diniꞌa?” ");
INSERT INTO syb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Laak dagid ndaꞌ gusay peksembag si Isus. Mipatiꞌ mesebuꞌay dun si Pilato. ");
INSERT INTO syb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Naa tauntaun, metaang dig Lumpuk kiin nu getaw Judea gindan tug Liniusan, duunig betad nu gubirnadur, si Pilato, beluyeneni sala tawan pinikutan, adini ubugen diniin nu nga getaw Judea. ");
INSERT INTO syb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Naa su taun kia, mitaang dema duuni nga getaw pinikutan, mingatu ilan di gubirnu dakus minunuꞌ ilan samataw nilan mitaang di sasaw. Sala tawan dinilan, ngalanen si Barabas. ");
INSERT INTO syb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Naa mendadi, kagina minadap dini Pilato su nga melaun getaw, inubug nilan dayun diniin, baalenen na puliꞌ su tigaman nilan pegbetadenen metaang dig Lumpuk tug Liniusan. ");
INSERT INTO syb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Sinaak dayun ni Pilato tu nga getaw, “Mendadi, taꞌ ma, mauyaꞌan niu beluyen ku diniu ki gadiꞌ nu getaw Judea?” ");
INSERT INTO syb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Iini tinaluꞌ dun ni Pilato maꞌnia, puꞌ misimaꞌen, kaas pa dinangat diniin nu nga kaunutan nug belian si Isus, puꞌ misigi mailan diniin. ");
INSERT INTO syb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Laak dagid ki nga kaunutan nug belian, sinamuk nilan su ginaa nu melaun getaw, adun ubugen nilan dini Pilato, iinig beluyenen dinilan si Barabas kia, sabayaꞌ ni Isus. ");
INSERT INTO syb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Mendadi, sinaak puliꞌ ni Pilato di nga melaun getaw, “Saꞌ maꞌantu, taꞌ mai penggulaulaan ku di getaw kiin gilal niu gadiꞌ nu nga getaw Judea?” ");
INSERT INTO syb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Mimeksay su nga getaw, “Lensangen di kurus!” ");
INSERT INTO syb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Sinaak na pelum ni Pilato, “Mauma, alandun bai salaꞌen?” Laak migdegadega ilan memeksay, laung nilan, “Ki getaw kiin, lensangen ba di kurus!” ");
INSERT INTO syb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Naa si Pilato, anguten dun mamuꞌamuꞌi ginaa nu melaun getaw kia. Saꞌ maꞌantu, biluyen tuꞌu dinilan si Barabas. Kini si Isus, pibadas ni Pilato, dayunen pegwakil tu nga sundalu, puꞌ adun lensangen nilan di kurus. ");
INSERT INTO syb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Naa saꞌ maꞌantu, inagak nu nga sundalu si Isus ditug lenuꞌan nug balay nu gubirnadur, si Pilato. Pinungun nilan dayun su kelaunan sundalu. ");
INSERT INTO syb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Benaꞌ mipungun ilan, piselukan nilan dayun si Isus melambung suub gempula, tautau suub gadiꞌ. Mukaꞌ miglingkin ilan dugi, tautau tundek gadiꞌ dadema, dayun nilan peselup di gulu ni Isus. ");
INSERT INTO syb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tautau didialan nilan iin, laung nilan, “Naa, mpianan ka, Sir, Gadiꞌa daw nu nga getaw Judea!” ");
INSERT INTO syb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Pimentul nilan tigbaw su gulu ni Isus, mukaꞌ pindulaꞌan pa nilan padun si Isus, dayun minginlulud ilan di gedapanen. ");
INSERT INTO syb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mendadi, benaꞌ mitubus nilan peksudiꞌay, piluas nilan diniin su gempula suub, piseluk nilan puliꞌ diniin sug daniin suub. Dayun nilan egakay si Isus ditu tandaꞌ lensangan nilan dun di kurus. ");
INSERT INTO syb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Naa saanan nu nga sundalu megagak dini Isus adun lensangen nilan ditu kurus, duuni mipegitaꞌ nilan getaw sungu na mesebang dia Jerusalem, ngalanen si Simon. (Si Simon kini, getaw Cirene, gamaꞌ ni Alejandro mukaꞌ ni Rufo.) Iini tigel nu nga sundalu mekpisan tu kurus ni Isus. ");
INSERT INTO syb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Naa saꞌ maꞌantu, iwit dayun nu nga sundalu si Isus gumawas dia syudad, midepet ilan dia dapit dun piningalan dun “Tulan Gulu.” Saꞌ dig danilan pikebitan, Golgota. ");
INSERT INTO syb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Benaꞌ minateng ilan dia, duuni piꞌinum nilan dini Isus penginumen limugan bulung, paingalan dun mira. Laak dagid mipauk minum dun si Isus. ");
INSERT INTO syb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Dayun nilan lensangay tu kurus si Isus. Benaꞌ milansang tu kurus si Isus, piktali dayun nu nga sundalu su nga penepetenen, bian nilan mekilas dun. ");
INSERT INTO syb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Su kelansang dini Isus tu kurus, duun saani ginengaꞌ menaik laak lemeni gendaw. ");
INSERT INTO syb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Naa duuni tuꞌus sinulatan sumbungan diniin, “Kini su Gadiꞌ nu nga getaw Judea.” ");
INSERT INTO syb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mukaꞌ pa pagid duunig duaꞌ tawan tulisan piduma dini Isus lensangay di kurus, miktimpang di kurus ni Isus su kurus nilan. ");
INSERT INTO syb_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ki mipenggulaula kini, minuud dun su sinulat ditu Taluꞌ nu Megbebayaꞌ, “Iin, pimilang duma nu nga melaat getaw.” ");
INSERT INTO syb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Naa su nga getaw minian dia, pingimusaungan nilan si Isus, miktakuꞌtakuꞌ ilan, dunut teluꞌen nilan, “Aha, yaꞌai miktaluꞌ puꞌ gebaꞌen mu su Pengedapan tu Megbebayaꞌ, dayun gikteb telu endaw, baalen mu puliꞌ! ");
INSERT INTO syb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Naa saꞌ maꞌnia, gawen mu nandawig lawas mu. Penauga di kurus kiin!” ");
INSERT INTO syb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ki nga kaunutan nug belian mukaꞌ su nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, maꞌantu dadema, pingimusaungan da nilan dema si Isus, laung nilan tug duma nilan, “Paa, megaganen daw megaweni ngag lain getaw, laak ndiꞌen pelum megaga guunayig lawasen! ");
INSERT INTO syb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ipusan ta ki Tinduꞌ daw nu Megbebayaꞌ Meglekaunutan, ki Gadiꞌ nu nga getaw Israel, ipusan ta saꞌ menaug ma nandaw di kurus kiin, dekag paita pekpetuud diniin!” Sampay sug duaꞌ tawan tulisan dumanen linansang di nga kurus, pingimusaungan da nilan dema si Isus. ");
INSERT INTO syb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Naa su kelansang dini Isus tu kurus, benaꞌ miktui gendaw, tekaw dumilemi tibuuk benwa, sampay miginengaꞌ menaugi gendaw. ");
INSERT INTO syb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Mendadi, benaꞌ miginengaꞌ menaugi gendaw, minekeg megbeksay si Isus, laungen, “Eloi, Eloi, lama sabaktani?” Maꞌananen, “Uu Megbebayaꞌ pektemuyen ku, Megbebayaꞌ pektemuyen ku, mauma bilengan mau tuꞌu?” ");
INSERT INTO syb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Midengeg nu ngag duma getaw pegindeg dia, kaliꞌ ilan pektaluꞌ, “Naa, kineegay pa daan niu, tuaganen si Elias dengantu!” ");
INSERT INTO syb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Duun dayuni gumibek malap maaꞌ palas napes, inulemen dayun di penginumen, tinangenen di tigbaw, pisangalen dayun dig babaꞌ ni Isus adun meseksepen. Laung nu getaw kia, “Ala, pegbentayan ta pa deliꞌ, kalukalu lumusad na buus si Elias, adun uaꞌenen iin dia kurus!” ");
INSERT INTO syb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mendadi si Isus, benaꞌ mitubus minum di penginumen kia, migbeksay dayun puliꞌ mainsan, metenug. Dayun megetusi ginaanen. ");
INSERT INTO syb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Naa mendadi, su kurtina bilet ditug dialem nu Pengedapan tu Megbebayaꞌ, masiꞌ mitekaw meginengaꞌ megedit, genat diin dapit ditaas sampay ditu geksiden diin dapit silung. ");
INSERT INTO syb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Naa dia misunguꞌan nu kurus linsangan dini Isus, duuni kaunutan sundalu pegindeg dia. Benaꞌ minitaꞌen su kegetus ginaa ni Isus, mitaluꞌen dayun, “Aa naa, masiꞌ metuud tuꞌu, ki getaw kini, iin sug Bataꞌ nu Megbebayaꞌ!” ");
INSERT INTO syb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Duun pa pagidi ngag libun dia mesempel, megbantay dailan dadema. Telu tawan dinilan, si Maria Magdalena, mukaꞌ si Maria su ginaꞌ ni Santiago mukaꞌ ni Jose, mukaꞌ si Salome. ");
INSERT INTO syb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ilan su tumindug dini Isus saananen ditu pa Galilea, puꞌ miktagikul ilan diniin. Mukaꞌ melaun dademaig duma nilan libun dia, su nga tuminakin diniin pangay ditu Jerusalem. ");
INSERT INTO syb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Naa benaꞌ sungu na mesindepi gendaw, duuni getaw minateng dia genat tug lunsud Arimatea, ngalanen si Jose. Iin kiin, sala tawan ditu Pikumpungan nu Metaas Gukum nu getaw Judea. Pegbesaan gupia nu samatawen si Jose, dakus mekpedateng tu Keglekaunutan nu Megbebayaꞌ. Naa su gendaw kiin, Birnis, su pengandam di Gendaw Pelali nu getaw Judea (puꞌ sala gendaw paitu). Mendadi si Jose, miksibeluꞌ mangay madap dini Pilato, inubugen diniin, elapenen sug bangkay ni Isus. ");
INSERT INTO syb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Dagid kaliꞌ medengeg ni Pilato puꞌ masiꞌ si Isus, daan na minatay, mitekawan dun si Pilato. Sinabinen dayun su kaunutan sundalu, sinaakanen saꞌ minatay na tuꞌu si Isus. ");
INSERT INTO syb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Benaꞌ midengeg ni Pilato su ginukit nu kaunutan sundalu, bigayen dayun elapen ni Jose sug bangkay ni Isus. ");
INSERT INTO syb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Naa saꞌ maꞌantu, minangay deliꞌ si Jose sumaluy penepeten gemputiꞌ, dayunen egwatay dia kurus sug bangkay ni Isus. Benaꞌ miagwaten, pinutusen di penepeten kia, ditunen dayun libeng sangyab liwakan di telektap. Benaꞌ milebengen, linuliden dayuni gembagel batu, tinakepen ditu gengaꞌan nug lebeng. ");
INSERT INTO syb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Naa si Maria Magdalena mukaꞌ su sala Maria, ginaꞌ ni Jose, migbantay ilan, kaas minitaꞌ nilan sug libengan dini Isus. ");
INSERT INTO syb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Naa benaꞌ Sabadu na, su Gendaw Pelali nu nga getaw Judea, benaꞌ misindep nai gendaw, si Maria Magdalena mukaꞌ si Maria ginaꞌ ni Santiago, su ketelunen si Salome, minangay ilan menaluy nga pagemut, adun penguklausen nilan sia ditug bangkay ni Isus. ");
INSERT INTO syb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mendadi benaꞌ siselem na gendaw Duminggu, lemen laak sumibangi gendaw, minangay ilan tuꞌu ditu sangyab libengan dini Isus. ");
INSERT INTO syb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Selian diin pailan dalan, migyagayaga ilan, laung nilan, “Naa sug batu tinakep ditu sangyab, buus ndaꞌi meglulid dun dinita.” ");
INSERT INTO syb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Laak dagid benaꞌ misempel nailan dia sangyab, kaliꞌ ilan tingag, sug batu tinakep tu sangyab, masiꞌ linulid na. Asa gembagel gupia batu kitu. ");
INSERT INTO syb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Dayun sumuut dia sangyabi ngag libun kia. Aba, duuni minitaꞌ nilan begutaw diag dialem, pegingkud dia dapit lintu nu sangyab, peksuub melambung, gemputiꞌ suub. Mipatiꞌ dayun mendeki ngag libun kia. ");
INSERT INTO syb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Laak kaliꞌ pektaluꞌ dinilan ki getaw kia, “Naa, ndiꞌ amu mendek. Puꞌ suunan ku iini penengaun niu sia si Isus, ki getaw Nazaret, sug linansang di kurus kitu. Naa, ndaꞌ nain dini. Mitubuꞌ na puliꞌ. Bentayay pa daan niu, kinuꞌ da sia su pibelilidan nilan diniin. ");
INSERT INTO syb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Naa, uliꞌ amu, ukitay niu dayun su nga sakupen kampuꞌ ni Pedro, maꞌniniꞌi taluꞌ niu. ‘Si Isus, miguna na diniu ditu Galilea. Mpegitaꞌ da niu ditu, maaꞌ da nu gandang tinaluꞌen diniu.’” ");
INSERT INTO syb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Maꞌantu, migawaꞌ dia sangyab su ngag libun, miglaguy ilan dayun. Sinaaban ilan sabaꞌ tiklab nilan. Mukaꞌ pia sala tawan, ndaꞌiduni inukitan nilan dun su minitaꞌ nilan, puꞌ sabaꞌ gendek nilan. ");
INSERT INTO syb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Naa su ketubuꞌ puliꞌ ni Isus, sikna siselem dig bekna gendaw nu simana, saꞌitada su gendaw Duminggu. Kig bekna pinitaꞌan ni Isus genat tu ketubuꞌen puliꞌ, iin si Maria Magdalena, su gandang pingutid ni Isus diniini pitu buuk menenulay. ");
INSERT INTO syb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mendadi si Maria, benaꞌ mikpaitaꞌ diniin si Isus, minangay dayun megukit tu nga getaw tatap dumuma dini Isus. Saꞌ minateng si Maria ditu nilan, mitaanganen pekpengaduy ilan, milegenan ilan patiꞌ. ");
INSERT INTO syb_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Laak dagid pia pa midengeg nilan puꞌ mitubuꞌ puliꞌ si Isus, mukaꞌ mikaitaꞌ dun gupia si Maria, pia maꞌantu, ndaꞌ dailan gusay pekpetuud dun. ");
INSERT INTO syb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mendadi genat itu, benaꞌ lain gendaw puliꞌ, mikpaitaꞌ si Isus dig duaꞌ tawan sakupen saanan nilan dig dalan, pegangay ilan tug buid. Laak sala na pelumi palas ni Isus. ");
INSERT INTO syb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Mendadi, benaꞌ minitaꞌ nilan iin, mipuliꞌ ilan ditu nga samasakup nilan, inukit nilan dayun dinilan. Laak dagid su ngag duma sakup ni Isus, ndaꞌ dailan gusay pekpetuud dun. ");
INSERT INTO syb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mendadi tigaꞌwan, mikpaitaꞌ na pelum si Isus ditu sepuluꞌ buꞌ sala peneliganen, saanan nilan maan. Pigbeluꞌan ilan dayun ni Isus puꞌ sabaꞌ ndaꞌi kekpetuud nilan mukaꞌ metegasi gulu nilan, puꞌ mauma ndaꞌ ilan pekpetuud ditu mikaitaꞌ diniin puꞌ tetubuꞌ na puliꞌ. ");
INSERT INTO syb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Mendadi, miktaluꞌ si Isus tu nga peneliganen, laungen, “Panaw amu, leep niu su tibuuk lumbang, pegukit niu dig launan kilawan dinig dibabaw benwa ki Gempia Petenday. ");
INSERT INTO syb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Adin dayun su mekpetuud dun mukaꞌ mekpebunag tubig, iini megawen. Dagid adin pelum su ndiꞌ mekpetuud, iini ukuman.” ");
INSERT INTO syb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kaliꞌ pagid pektaluꞌ si Isus, “Naa ki nga mekpetuud, baalen nilani nga mekesalebuꞌ penggulaula. Pengutidan nilani menenulay pebian di pegbayaꞌu, sampay mekabit ilan lain pikebitan, ki ndaꞌ nilan mainsan pektuꞌunay. ");
INSERT INTO syb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Saꞌ mpeguidan nilani mamak, mesama saꞌ mekainum ilan bulit, ndiꞌ ilan mekendutaꞌ dun. Sampay depenan nilan su nga pegladu, mauliꞌan dadema.” ");
INSERT INTO syb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Naa mendadi, ki Kaunutan kiin si Isus, benaꞌ mideksuꞌen su pekteluꞌenen tu nga peneliganen, pilentu dayun ditu gekbus langit, piꞌingkud dayun nu Megbebayaꞌ diin dapit lintunen. ");
INSERT INTO syb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Dayun su nga peneliganen, mipanaw ilan tuꞌu, lineep nilan su tibuukan benwa, pingukit nilan su Gempia Petenday. Ibangan ilan gupia nu Kaunutan Megbebayaꞌ, bigayan ilan niin ginuung megbaal mekesalebuꞌ tuꞌus, adun metakesiꞌan dun, metuud ki gukiten nilan. (v 9) Naa mendadi, su ngag libun kia minangay ditug libengan dini Isus, linaawan nilan tuꞌu si nga Pedro, inukit nilan dayun dedaliꞌ dinilan su kelaun tinaluꞌ nug begutaw ditug dialem sangyab. (v 10) Mendadi, pimuunan ni Isus gupia su nga peneliganen, adun ukiten nilan ditug launan getaw ki Gempia Petenday. Pilaktag ni Isus dinilan dini tibuukan benwa su Gempia Petenday, genat diin dapit silangan sampay ditu dapit sindepan. Ki Gempia Petenday kini, ndaꞌi kebelengen sampay saumul. Puꞌ kini, puun tu Megbebayaꞌ. Adin su getaw mekpetuud dun, megawen di salaꞌen di ndaꞌi tamanen.");
INSERT INTO syb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Diniꞌa, pegbesaan Teofilo, ki sinulat kini, genat dini Lucas. Mendadi Sir, ki kelaun pinggulaula ni Isukristu saananen pa dumuma dinita, melaun nai mikpulingkas meksumpatsumpat gukiten dun. ");
INSERT INTO syb_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Dayun yami, pidengegan ami dun pa pagid nu nga mikaitaꞌ dun genat di puunanen, ilan dademai migukit di Gempia Petenday nu kepedasun tu salaꞌ nu getaw. ");
INSERT INTO syb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Naa kagina maꞌantu, naan dema, laung ku melengas saꞌ peksibaꞌan ku sumpatayi gukiten dun kini, puitu diniꞌa, uu pegbesaan Teofilo, kagina piksimaꞌu gupia sug launanen genat di pikpuunanen. ");
INSERT INTO syb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Kaas piwitu diniꞌa Sir ki sulat kini, adun mesuunan mu puꞌ ki pisuun diniꞌa kiin nu nga sakup ni Isus, naa lumbus metuud. ");
INSERT INTO syb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Naa su timpu pa ni Herodes meglegadiꞌ ditu prubinsya Judea, sala tawan di ngag belian nu getaw Judea, si Zacarias, sakup nu pikumpungan belian sapuꞌ ni Abias. Iini sawa ni Zacarias si Elisabet, sapuꞌ dadema ni Aaron. ");
INSERT INTO syb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ki senlangan kini, mekesuun ilan duaꞌ di pegitaꞌen nu Megbebayaꞌ, puꞌ ndaꞌiduni misulat palintanen ndaꞌ nilan dunutay. ");
INSERT INTO syb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Laak ndaꞌig bataꞌ nilan, puꞌ si Elisabet, ndiꞌ mapet bataꞌen, mukaꞌ megulang nailan duaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Naa su timpu nu pikumpungan ni Abias meguit tu kektamuy ditug Balay Pengedapan tu Megbebayaꞌ, iinig belian mikanu, si Zacarias kini. ");
INSERT INTO syb_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Saꞌ mekanu, betad nu ngag belian, pekteliin su mektutung pelinan. Mendadi, duuni gendaw piktali si Zacarias mektutung pelinan. Saꞌ maꞌnia, sumiled ditu Pengedapan si Zacarias. ");
INSERT INTO syb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Su melaun getaw pelum, minenabi ilan diag liu, selian mektutung pelinan diag dialem. ");
INSERT INTO syb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mendadi benaꞌ miktutung pelinan si Zacarias, mitekaw duuni mituaꞌ dia niin, masiꞌ sesuguꞌen nu Kaunutan Megbebayaꞌ getaw langit, pegindeg dia dapit lintu nu pektutungan pelinan. ");
INSERT INTO syb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Dekag minitaꞌ ni Zacarias, mitekawan dun, mipatiꞌ mendek. ");
INSERT INTO syb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Laak dagid kaliꞌ pektaluꞌ su getaw langit, “Ndiꞌa mendek, Zacarias, puꞌ midengeg nu Megbebayaꞌ su kenenabi mu. Kaas megbataꞌ amu nu sawa mu kiin si Elisabet, bataꞌlaki. Iini baal niu ngalan nu gembataꞌ kiin, si Juan. ");
INSERT INTO syb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Naa mpatiꞌa leliagay dun ki kegigetawen, gempia ki ginaa mu, dakus leliagen dun dademai melaun getaw! ");
INSERT INTO syb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ki gembataꞌ niu kiin, metaas di pegitaꞌen nu Kaunutan Megbebayaꞌ. Subay ndiꞌ minum mekebulek. Dekag pa pegigetaw, pengepuꞌan na nug Balakat nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kaas kini si Juan, melaun samasapuꞌen dini Israel pepuliꞌenen sug delendeman nilan ditu Kaunutan nilan Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Iini metenduꞌ mauna ditu Kaunutan metuaꞌ, iini mandam dig biananen. Begayan tuꞌu ginuung nug Balakat nu Megbebayaꞌ, maaꞌ nu sala tawan dengantu pimuunan nu Megbebayaꞌ si Elias, adun pegeksudenen diadia su gembataꞌ megulang migbanta, mukaꞌ pesikesuunenen puliꞌ su getaw mimilas. Maꞌantu, pepengendamenen su getaw tu kedateng nu Kaunutan.” ");
INSERT INTO syb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Kaliꞌ saak si Zacarias tu getaw langit, “Paa, alandun bai kesuun ku dun puꞌ metuud, megbataꞌ ami? Puꞌ naan, megulang nau. Su sawau, megulang dadema.” ");
INSERT INTO syb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kaliꞌ sembag su getaw langit, “Naan si Gabriel, dituunu metatap pegindeg gedapan nu Megbebayaꞌ. Sinuguꞌu niin medini niꞌa adun petendayu diniꞌa ki kepianan kini. ");
INSERT INTO syb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Naa genat nandaw, megbeeda, sampay di gendaw menuudi tinaluꞌu keni, sabaꞌ ndaꞌa metuuday dini pitendayu diniꞌa. Puꞌ menuud da tuꞌu saꞌ metektak nai sesaꞌen.” ");
INSERT INTO syb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Naa saꞌ maꞌantu, pigelatan si Zacarias nu nga getaw diag liu nu Pengedapan tu Megbebayaꞌ. Misebuꞌan ilan ditu kilengananen dia seled. ");
INSERT INTO syb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Laak saꞌ gumiwaꞌ na si Zacarias, ndaꞌ mekekabit dinilan. Kaas misimaꞌ nilan puꞌ duuni pinitaꞌ nu Megbebayaꞌ diniin dia seled nu Pengedapan. Laak miksinyas dinilan, sabaꞌ nu kegbeeden kia. ");
INSERT INTO syb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Naa saꞌ mitubus mekanu si Zacarias, minuliꞌ dayun tug balayen. ");
INSERT INTO syb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Naa benaꞌ ndaꞌ maiben, migbedes tuꞌu su sawa ni Zacarias, si Elisabet. Lima bulan pegbedes, ndaꞌ pegleleguaꞌ diag balay si Elisabet. Laungen, ");
INSERT INTO syb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Aa naa, dekag pa milelaat dinaan su Kaunutan Megbebayaꞌ, kaas maꞌninii pinggulaulanen dinaan, adun mawaꞌi piidan ku di nga getaw!” ");
INSERT INTO syb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Naa di keꞌenem bulan nug bedesan ni Elisabet, sinuguꞌ puliꞌ nu Megbebayaꞌ su sesuguꞌenen kiin getaw langit, si Gabriel, mangay na pelum dig lunsud pegingelanan Nazaret, sakup Galilea. ");
INSERT INTO syb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Sinuguꞌ su getaw langit ditu sala tawan delaga, ngalanen si Maria. Kini si Maria, iini mimbeng diniin ki sala tawan begutaw, ngalanen si Jose. Si Jose, sapuꞌ ni Adiꞌ David. ");
INSERT INTO syb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mendadi, benaꞌ mituaꞌ ditu ni Maria su getaw langit, kaliꞌ pektaluꞌ diniin, “Aa naa, gempia nai ginaa mu! Pigebangan ka nu Kaunutan Megbebayaꞌ! Pipianan ka niin gupia!” ");
INSERT INTO syb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Milibuleng patiꞌ si Maria di tinaluꞌ nu getaw langit. Migdelendem gupia si Maria, saꞌ taꞌ alandun saani maꞌanan nu tinaluꞌen kia. ");
INSERT INTO syb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kaliꞌ pektaluꞌ su getaw langit, “Naa, ndiꞌa mendek, Maria, puꞌ pipianan ka nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Puꞌ ndiꞌ maiben, megbedesa. Dayun megbataꞌa, iinig bataꞌ mu, laki. Iini baal niu ngalanen, si Isus. ");
INSERT INTO syb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Metaas gupia su gelalen, paingalan dun iin sug Bataꞌ nu Tampusan Metaas Megbebayaꞌ. Baalen nu Kaunutan Megbebayaꞌ kaunutan maaꞌ nu ginepuꞌayen si David, ");
INSERT INTO syb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","iin nai meglegadiꞌ di nga samasapuꞌen dini Jacob. Su keglekaunutanen, ndaꞌi kepapasen!” ");
INSERT INTO syb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kaliꞌ saak si Maria tu getaw langit, “Naa, mekendutaꞌ mai kegbataꞌu, ndaꞌ pau siben pegawid duayan?” ");
INSERT INTO syb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kaliꞌ sembag su getaw langit, “Sug Balakat nu Megbebayaꞌ, lumusad diniꞌa, melekleman ka di ginuung nu Tampusan Metaas Megbebayaꞌ, dayun megbataꞌa. Kaas sug bataꞌ mu, pimiliꞌ nu Megbebayaꞌ, paingalan dun sug Bataꞌ nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Puꞌ pegdelendem mu sug betaꞌan mu kiin si Elisabet. Pia megulang na, miapet dadema bataꞌen. Nandawi keꞌenem bulan na bedesanen, asa iini ndiꞌ daw mapet bataꞌen. ");
INSERT INTO syb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Puꞌ su Megbebayaꞌ, ndaꞌiduni ndiꞌen mesuꞌat baalay.” ");
INSERT INTO syb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kaliꞌ sumpat si Maria, “Naa naan, sesuguꞌenu laak nu Kaunutan Megbebayaꞌ. Saꞌ maꞌnia, melengas menuud tuꞌu dinaan ki tinaluꞌ mu.” Dayun minawaꞌ dia si Gabriel, su sesuguꞌen nu Megbebayaꞌ getaw langit. ");
INSERT INTO syb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tubus nituꞌ ndaꞌ maiben, migdedaliꞌ si Maria mangay di sala lunsud tug binentudan sakup prubinsya Judea. ");
INSERT INTO syb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Benaꞌ minateng si Maria dia, minundas diag balay ni nga Zacarias, sinabinen dayun si Elisabet. ");
INSERT INTO syb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kaliꞌ medengeg ni Elisabet su taluꞌ ni Maria, mikuleg su gembataꞌ dia tian ni Elisabet. Pingepuꞌan dayun nug Balakat nu Megbebayaꞌ si Elisabet, ");
INSERT INTO syb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","kaas minekeg mekabit, laungen dini Maria, “Yaꞌai pipianan nu Megbebayaꞌ di nga kelaun libun! Melengas pepianan dadema ki gembataꞌ dia tian mu! ");
INSERT INTO syb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Taꞌ alandun maig bentanganen, mingumbelayan ka ma dini naan, asa yaꞌai ginaꞌ nu Kaunutan ku? ");
INSERT INTO syb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Puꞌ sikna midengegu su taluꞌ mu, didialan ka nu gembataꞌ dini tian ku, kaas mikuleg. ");
INSERT INTO syb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Naa liliaga lai tuꞌu, puꞌ mituudan ka puꞌ ki pitenday nu Kaunutan Megbebayaꞌ diniꞌa, menuud!” ");
INSERT INTO syb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mendadi kini si Maria, kaliꞌ pektaluꞌ, “Su Kaunutan Megbebayaꞌ, pegenalen ku iin dema tuꞌu, ");
INSERT INTO syb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","pinleliagu sabaꞌ nu Megbebayaꞌ Meglegawen dinaan. ");
INSERT INTO syb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Puꞌ liningiꞌanu niin, asa gembabaꞌu laak getaw kini, sesuguꞌenu laak niin. Kaas genat nandaw, paingalan dun dinaan nu nga getaw sumpat menumpat, pipiananu nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Puꞌ pipiananu tuꞌu nu Ginuungan Megbayaꞌ tug launan, iin dadema su pinaas Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Lelaatanen su kelaunanen megbasa diniin, pia sanu sumpat. ");
INSERT INTO syb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pinitaꞌen su metaas ginuungen, puꞌ su getaw mekpelabawlabaw, pibuluganen sug delendemanen. ");
INSERT INTO syb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Su nga metaas gadiꞌ, inawiꞌen su pegbayaꞌ nilan, pitaasen sukli dun su nga gembabaꞌi tindegen. ");
INSERT INTO syb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Su nga mekegutem, pibesugen di gempia gaan. Su nga mekegaꞌus, piuliꞌen, ndaꞌi miwit nilan. ");
INSERT INTO syb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ita nug bansa Israel, su sesuguꞌenen, ibanganen, pinuuden tuꞌu su pinasaden melelaat dinita. ");
INSERT INTO syb_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Saꞌitada ndaꞌen selingaway ki pinasaden ditu ginepuꞌay ta si Abraham, ki pinasaden dadema dinita nga sapuꞌen sampay menumpat menumpat!” ");
INSERT INTO syb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Naa saꞌ maꞌantu, migbebenwa pa si Maria ditu ni nga Elisabet duun saani telu bulan, puli pasiꞌ si Maria minuliꞌ. ");
INSERT INTO syb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mendadi kini pelum si Elisabet, benaꞌ minateng na su kegbataꞌen, migbataꞌ tuꞌu. Iinig bataꞌen, bataꞌlaki. ");
INSERT INTO syb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Benaꞌ midengeg nu nga sumbalay ni Elisabet dakus nu ngag betaꞌanen ki gembagel lelaat kini nu Kaunutan Megbebayaꞌ diniin, didialan dadema nilan su kegigetaw nu gembataꞌ. ");
INSERT INTO syb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mendadi di kewalu endawen genat di kegigetawen, minangay dia su nga getaw, puꞌ kitui gendaw peksirkunsisu ditu gembataꞌ. Mukaꞌ baalan da nilan dema ngalanen, pesangay sia di gamaꞌen kia si Zacarias. ");
INSERT INTO syb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Laak dagid laung nu ginaꞌ nu gembataꞌ, “Ndiꞌ lai mesuꞌat! Iini baal ta dun ngalan, si Juan.” ");
INSERT INTO syb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kaliꞌ ilan sumpat dini Elisabet, “Mauma dema? Ndaꞌ ma lai betaꞌan mu mesangay di ngalan kiin!” ");
INSERT INTO syb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Miksinyas ilan dayun di gamaꞌen, beed pa buꞌ bengel pa, iin pelumi sinaakan nilan, saꞌ taꞌig baalen ngalan nug bataꞌen. ");
INSERT INTO syb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Si Zacarias, minengi penulatan, sinulaten dayun su pitenday diniin kiin nu getaw langit paingalan dun, laungen, “Ngalanen si Juan.” Misebuꞌan ilan gelaꞌ di sinulaten kia. ");
INSERT INTO syb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Dekag pa miawaꞌ sug beed ni Zacarias, sampay sug bengelen. Miktaluꞌ dayun, inalen su Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Naa apelai, sug lumaun sumbalay ni nga Zacarias, mindek ilan patiꞌ. Genat itu, su tibaꞌan mipenggulaula, pegyegayegaan nu nga getaw tu tibuuk binentudan Judea. ");
INSERT INTO syb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Adinadin dayun su mikedengeg dun, pegdelendemenen gupia, laungen, “Ki gembataꞌ kini, taꞌ alandun ma saani gasalen?” Puꞌ gempantek, bigayan nu Kaunutan Megbebayaꞌ ginuung ki gembataꞌ kini, si Juan. ");
INSERT INTO syb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Naa si Zacarias kiin, su gamaꞌ ni Juan, pingepuꞌan nug Balakat nu Megbebayaꞌ. Benaꞌ pimuunan, kaliꞌ pektaluꞌ, ");
INSERT INTO syb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Mendadi, enalen su Kaunutan Megbebayaꞌ, su pektemuyen ta nu nga getaw Israel! Liningiꞌan ita niin nga piglegetawanen, likat ita niin. ");
INSERT INTO syb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Pilusaden ki ginuungan Meglegawen dinita, iini sapuꞌ ni David, su sesuguꞌen kitu nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kinii kenuud nu pisulat pedaan nu Megbebayaꞌ tu nga getaw dengantu pimiliꞌen pemuunanen, ");
INSERT INTO syb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","puꞌ guunen ita niin di nga kuntra ta, di gengkeman nug lumaun memensengay dinita. ");
INSERT INTO syb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Minuud tuꞌu su tinaluꞌ nu Megbebayaꞌ puꞌ lelaatanen su ginepuꞌay ta, mukaꞌ ndiꞌen selingawan su pasaden kiin, ");
INSERT INTO syb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","ki sinapanen ditu ginepuꞌay ta si Abraham. Iini pinasaden dini Abraham, lekaten ita niin di nga kuntra ta, adun meketamuy ita diniin di ndaꞌ nai gendekan ta. ");
INSERT INTO syb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kaas pegbetaden ta su mbantang tu getaw pinaas nu Megbebayaꞌ, dakus mekesuun ita di pegitaꞌenen sampay di gendaw matengi gumul ta.” ");
INSERT INTO syb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Kaliꞌ padun pektaluꞌ si Zacarias, “Mendadi yaꞌa ki Mbataꞌ, gelalen ka nu nga getaw, pimuunan nu Tampusan Metaas Megbebayaꞌ. Yaꞌa dademai tinduꞌ mauna ditu Kaunutan, puꞌ adun pengendamen mu sug biananen, ");
INSERT INTO syb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","saꞌitada pesuun mu tu nga piglegetawanen ki kegawen nu Megbebayaꞌ dinilan pebian di kepedasunen di nga salaꞌ nilan. ");
INSERT INTO syb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kiin, puun di gembagel lelaat nu Megbebayaꞌ, su pektemuyen ta. Ki keglegawenen kiin dinita, maaꞌ nu kesebang nu gendaw. ");
INSERT INTO syb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Puꞌ nandaw, migbebenwa paita di medelem, saꞌitada mideleman ita di kepatay ndaꞌi tamanen. Dagid ndiꞌ maiben, mesebang ditug langit ki gendaw di kegawenen dinita, dayun metiagan ita dun, dakus magak ita ditug dalan pegangay tu kelinaw.” ");
INSERT INTO syb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mendadi su gembataꞌ kia si Juan, tuminulin, mukaꞌ migiseg dademai sinuunanen. Laak migbebenwa tug limawaꞌ, sampay di gendaw minangay tu nga getaw Israel. ");
INSERT INTO syb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Naa di timpu kia, su tampusan gadiꞌ nu getaw Roma si Augusto, mikpelaktag puꞌ penlistaan sug launan getaw ditu peglegediꞌanen. ");
INSERT INTO syb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kiaig bekna kenlista di nga getaw, saanan nu kaingkud dadema ni Cirenio gubirnadur tu Siria. ");
INSERT INTO syb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Naa maꞌantu, diadia subay minangay tug benwa nu ginepuꞌayen adun mekpelista dia. ");
INSERT INTO syb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Mendadi kini si Jose, ki gandang linaawan nu getaw langit kiin, benaꞌ midengegen su pimuun kia nu gadiꞌ, sumikat dema tug lunsud Nazaret, sakup Galilea, miditug Betlehem, lunsud ditu tandaꞌ nu kegigetaw ni Adiꞌ David, puꞌ sapuꞌ ni David si Jose. ");
INSERT INTO syb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Miditu dayun mekpelista, dumanen si Maria, kig bimbengen kiin, begat na. ");
INSERT INTO syb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Mendadi, benaꞌ dia nailan Betlehem, minateng ki kegbataꞌ ni Maria. ");
INSERT INTO syb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Migbataꞌ tuꞌu penganay bataꞌen, bataꞌlaki. Laak sabaꞌ ndaꞌidun nai sugud diag balay pektulugan nu nga getaw, ibenan ni Maria ki gembataꞌ, dayunen pebeliliday diag dialem palungan nu nga petubuꞌen. ");
INSERT INTO syb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Naa diag benwa kia, duuni nga megingat karniru, pegingaten nilan su nga karniru nilan diag beluyan saꞌ gebii. ");
INSERT INTO syb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mendadi, saanan nilan megingat dun, tekaw duuni mituaꞌ dia nilani sesuguꞌen nu Kaunutan Megbebayaꞌ getaw langit. Mitiagan dayun nu kelengas nu Kaunutan Megbebayaꞌ su nga megingat karniru. Mipatiꞌ ilan dayun mendek. ");
INSERT INTO syb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Dagid miktaluꞌ su getaw langit dinilan, “Ndiꞌ amu mendek! Puꞌ ki petendayu kini diniu, gempia, dedialan gupia nug launan getaw. ");
INSERT INTO syb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Puꞌ gebii kini, ki Meglegawen diniu, su Kaunutan si Kristu, migigetaw na tuꞌu ditug lunsud ni David! ");
INSERT INTO syb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Naa maꞌniniꞌi tuꞌusan niu dun. Adin sug begu pegigetaw gembataꞌ ibenan, pibelilid di palungan.” ");
INSERT INTO syb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mideksuꞌ laak mektaluꞌ su getaw langit, mitekaw metuaꞌ melaun gupia dumanen, getaw langit dadema. Inal nilan su Megbebayaꞌ, laung nilan, ");
INSERT INTO syb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Enalen su Megbebayaꞌ ditu gekbus langit! Dayun su nga getaw petailenen dinig dibabaw lumbang, gembageli kelinaw nilan!” ");
INSERT INTO syb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mendadi, mimegawaꞌ su nga sesuguꞌen nu Megbebayaꞌ ditu megingat karniru, mimeguliꞌ ilan ditu gekbus langit. Benaꞌ mipalus ilan, laung nu nga megingat karniru, “Tala. Mpanaw ita ditug Betlehem, bentayan ta ki mipenggulaula kini pisuun dinita nu Kaunutan Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Migapas dayun mpanaw su nga megingat karniru, mibaangan nilan tuꞌu si Maria buꞌ si Jose dakus ki gembataꞌ kia, pibelilid tuꞌu dia palungan. ");
INSERT INTO syb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Dekag minitaꞌ nu nga megingat karniru su gembataꞌ kia, inukit nilan di ngag duma getaw su pisuun dinilan nu nga getaw langit mekatag di gembataꞌ kini. ");
INSERT INTO syb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Sug launan mikedengeg ditu ginukit nu nga megingat karniru, misebuꞌan ilan dun. ");
INSERT INTO syb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Laak si Maria, tinaguꞌen gupia dig delendemanen kig lumaun mipenggulaula, pigdelendemen gusay. ");
INSERT INTO syb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tubus itu, mipuliꞌ su nga megingat, inal nilan tantu su Megbebayaꞌ sabaꞌ nug lumaun minitaꞌ nilan mukaꞌ midengeg nilan, maaꞌ dadema nu pitenday dinilan nu getaw langit. ");
INSERT INTO syb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Naa ki gembataꞌ kini, benaꞌ di kewalu endawen genat kegigetawen, su gendaw peksirkunsisu dun, binaalan na ngalanen. Iini piningalan diniin, si Isus, ki ngalan pitenday nu sesuguꞌen nu Megbebayaꞌ getaw langit, su kanaꞌ pa bedesan dun nu ginaꞌen. ");
INSERT INTO syb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Naa mitektak na su kekanu ni Maria mekatag di palinta pisulat nu Kaunutan Megbebayaꞌ ditu ni Moises dengantu, adun mawaꞌ su kelemuꞌay ni Maria genat megbataꞌ. Mendadi benaꞌ mitektak na, miditu Jerusalem si Maria buꞌ si Jose, iini guliden nilan su misulat ditu Palinta, laung, “Duaꞌ buukig buun atawaka duaꞌ buuki gekpis malepati.” Iwit pa pagid nu mekegulangen su gembataꞌ kia si Isus, puꞌ adun pegwakil tu Kaunutan Megbebayaꞌ. Puꞌ misulat ditu Palinta, “Adini penganay gembataꞌ, saꞌ laki, paingalan dun pinaas, puꞌ danu Kaunutan Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Naa mitaang duuni getaw migbenwa dia Jerusalem, ngalanen si Simeon. Mekesuun si Simeon, mikpetuud gupia tu Megbebayaꞌ, dakus mikpedateng di kenlekat tug bansa Israel. Naa pingepuꞌan gusay nug Balakat nu Megbebayaꞌ si Simeon. ");
INSERT INTO syb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Kaas gandang pisuun nug Balakat nu Megbebayaꞌ diniin puꞌ ndiꞌ pa matengi gumulen, subay maitaꞌen pa ki Tinduꞌ nu Megbebayaꞌ Meglekaunutan, metuaꞌ na tuꞌu. ");
INSERT INTO syb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Naa duuni gendaw, ibayan si Simeon nug Balakat nu Megbebayaꞌ meditu Pengedapan tu Megbebayaꞌ. Mendadi, midengan dun su gembataꞌ kia si Isus, inated nu mekegulangen dia, adun penggulaulaan nilan na tuꞌu diniin sug betad kia misulat ditu Palinta nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Naa, benaꞌ minitaꞌ ni Simeon ki gembataꞌ kia, ginibanen, mukaꞌ pikpeladpeladanen su Megbebayaꞌ, laungen, ");
INSERT INTO syb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Aa naa, uu Kaunutan, mesuꞌat na buang mu dinaan, ki sesuguꞌen mu kini, matayu di gempia ginaa, maaꞌ dadema nu gandang tinaluꞌ mu dinaan. ");
INSERT INTO syb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Puꞌ miduaꞌ matau na tuꞌu ki meglegawen genat diniꞌa, ");
INSERT INTO syb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ki gandang sinukat mu, medayag pa nu kelaun bansa nu getaw. ");
INSERT INTO syb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kinii tilaw mekpedelag pa tu nga kanaꞌ getaw Judea, iin dademai puunen, enalen ami nu nga getaw Israel, ki piglegetawan mu.” ");
INSERT INTO syb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Naa benaꞌ midengeg nu ginaꞌ ni Isus mukaꞌ nu gamaꞌen su kelaun tinaluꞌ kia ni Simeon mekatag di gembataꞌ, misebuꞌan ilan dun. ");
INSERT INTO syb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Pinenebian dailan dema ni Simeon. Kaliꞌ padun pektaluꞌ si Simeon tu ginaꞌ nu gembataꞌ si Maria, “Naa ki gembataꞌ kini, gasalen, mekpuun diniin, melaun getaw Israel ndiꞌ mpeduma tu ketubuꞌ ndaꞌi tamanen. Mukaꞌ melaun getaw Israel mpeduma pasiꞌ tu ketubuꞌ kia, puun da gusay dig bataꞌ kini. Gasalen dadema, iini mbaal tuꞌus genat tu Megbebayaꞌ, laak pemilasen nu nga getaw, ");
INSERT INTO syb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","kaas su iglud delendeman nu melaun getaw, mbuasan da. Dagid daniꞌa pelum Maria, melegenan ka patiꞌ mekpuun diniin, maaꞌ teduken sundangi pusung mu.” ");
INSERT INTO syb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Naa duun pagidi sala tawan libun dia, pimuunan nu Megbebayaꞌ, ngalanen si Ana, bataꞌ ni Panuel, sapuꞌ ni Aser. ");
INSERT INTO syb_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Megulang gupia si Ana, puꞌ pitu taun megawid duayan, dayun genat itu mibalu, sampay walu puluꞌ buꞌ paat tauni gidaden. Betad ni Ana, gebii gendaw mektamuy dia Pengedapan, mekpuasa mukaꞌ menenabi. ");
INSERT INTO syb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mendadi, benaꞌ mideksuꞌ mektaluꞌ si Simeon mekatag di gembataꞌ kia, iin demai kedateng ni Ana dia, mikpaladpalad dayun tu Megbebayaꞌ si Ana. Genat itu, adini getaw mekpedateng di kenlekat tu nga getaw Jerusalem, pegwelian ni Ana mekatag di gembataꞌ si Isus. ");
INSERT INTO syb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mendadi si Maria mukaꞌ si Jose, benaꞌ migelaꞌ nilan petuuday sug lumaun betad kia sinulat ditu Misulat Palinta nu Kaunutan Megbebayaꞌ, minuliꞌ ilan ditug lunsud pegbenwanan nilan, ditu Nazaret, sakup Galilea. ");
INSERT INTO syb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tuminulin dayun su gembataꞌ, tuminulin sug lawasen mukaꞌ migiseg gupia su sinuunanen. Liliag dun dadema su Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Naa su mekegulang ni Isus, tauntaun mangay ilan ditu Jerusalem sumaup tug Lumpuk nu getaw Judea gindan tug Liniusan. ");
INSERT INTO syb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Naa saꞌ maꞌantu, ki gembataꞌ kia si Isus, benaꞌ sepuluꞌ buꞌ duaꞌ nai taunen, migdunut tu mekegulangen meditu Jerusalem sumaup, maaꞌ nu gandang betad nilan. ");
INSERT INTO syb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mendadi, benaꞌ miglinggwang na sug Lumpuk, sumikat su nga mekegulang ni Isus muliꞌ. Laak su gembataꞌ si Isus, miksibilin pa dia Jerusalem. Ndaꞌ mesuunay nu mekegulangen, ");
INSERT INTO syb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","laak laung nilan dun, diin da piktendugan nilan. Kaas lagaꞌ sendaw ilan mpanaw, dekag pa nilan metukaway, dayun nilan penengaway ditu ngag betaꞌan nilan mukaꞌ di kailala nilan. ");
INSERT INTO syb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mendadi benaꞌ ndaꞌ nilan maitaꞌ, mipuliꞌ ilan ditu Jerusalem, pekpenengaun nilan ditu. ");
INSERT INTO syb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Benaꞌ di ketelu endawen, dekag pa nilan mbaangay, dia masiꞌ Pengedapan. Pegingkud dia si Isus, dumanen su nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, pekineeg dinilan, bineegen sumaak dinilan. ");
INSERT INTO syb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Sug launan mikedengeg dun, misebuꞌan ilan tu sinuunan ni Isus sampay su penembagen. ");
INSERT INTO syb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Benaꞌ mibaangan nu mekegulangen si Isus, misebuꞌan ilan dun gupia. Laung nu ginaꞌen, “Apelai, Naung, mauma dema pimaꞌniin mu ami? Su gamaꞌ mu mukaꞌ naan, milegenan ami gupia menengaw diniꞌa.” ");
INSERT INTO syb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Dagid kaliꞌ sembag si Isus, “Aa, masiꞌ penengaun niau? Ndaꞌ niu masiꞌ mesuunay puꞌ subay mediniinu Balay nu Gamaꞌu?” ");
INSERT INTO syb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Laak ndaꞌ mesabut nu mekegulang ni Isus su gulugan nu tinaluꞌen kia. ");
INSERT INTO syb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Naa saꞌ maꞌantu, migdunut si Isus dia mekegulangen muliꞌ ditu Nazaret, mukaꞌ mikpetuud dinilan. Saꞌ su ginaꞌen, tinaguꞌen dig delendemanen su kelaun mipenggulaula kini. ");
INSERT INTO syb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Mendadi, migiseg su sinuunan ni Isus sampay tuminulinig lawasen. Liliag dun su Megbebayaꞌ, sampay pitail dadema nu nga samatawen. ");
INSERT INTO syb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Naa di kesepuluꞌ buꞌ lima taun nu tampusan gadiꞌ nu getaw Roma si Tiberio, iini gubirnadur dig benwa Judea si Poncio Pilato. Su kaunutan tu Galilea, si Herodes. Su kaunutan dig benwa Iturea buꞌ Trakonite, si Felipe, ngudan ni Herodes. Su kaunutan dig Abilena, si Lisanias. ");
INSERT INTO syb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Dakus iin su Tampusan Metaas Belian nu getaw Judea, ilan si Anas mukaꞌ si Caifas. Naa mitaang dun kini si Juan, kig bataꞌ kiin ni Zacarias, pimuunan nu Megbebayaꞌ selianen diag limawaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Mendadi genat itu, lineep ni Juan kig benwa lumibut di tubig Jordan, miktituluꞌ tu nga getaw. Kaliꞌ pektaluꞌ si Juan, “Peksikesuun amu, mukaꞌ pekpebunag amu tubig tuꞌus dun, adun pedesunen nu Megbebayaꞌ ki salaꞌ niu.” ");
INSERT INTO syb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kaas saꞌ migukit si Juan, minuud su sinulat dengantu ditu Misulat Taluꞌ nu Megbebayaꞌ nu pimuunanen si Isaias, laungen, “Duuni getaw mektawag diag limawaꞌ, laungen, ‘Pengendamay niu sug bianan nu Kaunutan Megbebayaꞌ, pelegdeng niu kig dalanen! ");
INSERT INTO syb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Su nga kelaun sebeng, tempulan, su nga kelaun bentud, maikaꞌ saꞌ gembagel, lumbangen. Mukaꞌ su nga mekelikuꞌ dalan, pelegdengen, dakus su mimaledmaled, pelenuꞌen dadema. ");
INSERT INTO syb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Dayun maitaꞌ nu kelaun kilawan ki kegawen nu Megbebayaꞌ!’” ");
INSERT INTO syb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Naa saꞌ maꞌantu, melaun gupia getaw minangay ditu ni Juan mekpebunag tubig. Laak dagid sug duma, miktaluꞌ si Juan dinilan, “Paa, yamu pa di nga mamak! Taꞌ taway duni mikpegad diniu, adun sia peleguyan niu ki ginukuman nu Megbebayaꞌ sungu mateng? ");
INSERT INTO syb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Subay menggulaula amu gempia, ki mbantang di nga getaw miksikesuun, damikian duni gayu megbunga melengas. Mukaꞌ ndiꞌ amu pektaluꞌ dig dialem ginaa niu puꞌ mipemilang namu nu Megbebayaꞌ mekesuun puun di kesapuꞌ niu dini Abraham. Puꞌ taman taluꞌu diniu, pia ki ngag batu dinig lupaꞌ kini, mesuꞌat dadema beluyay nu Megbebayaꞌ nga sapuꞌ ni Abraham! ");
INSERT INTO syb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Dagid nandaw, minuyaꞌ na sug wasay, dia na tuꞌu puun nu gayu. Kaas adini gayu ndiꞌ megbunga gempia, penegaꞌen nu Megbebayaꞌ, dayun piglakay tu gapuy.” ");
INSERT INTO syb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Benaꞌ midengeg nu nga melaun getaw ki tinaluꞌ ni Juan, sinaak nilan diniin, “Saꞌ maꞌantu, taꞌ alandun maig baalen nami?” ");
INSERT INTO syb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Kaliꞌ sembag si Juan, “Naa maꞌniniꞌ. Adini getaw duaꞌ buuki suuben, subay begayen su salabuuk ditu ndaꞌidunig daniin. Adin pelumig duuni gaanen, maꞌantu dadema.” ");
INSERT INTO syb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Naa duun pagidi nga mendawat buis minangay dadema ditu ni Juan mekpebunag diniin tubig. Kaliꞌ ilan saak, “Naa Sir, yami pelum, taꞌ mai pegbetaden nami?” ");
INSERT INTO syb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Kaliꞌ sembag si Juan, “Iin na laaki pebuis niu tu nga getaw, su gikteb tinduꞌ diniu.” ");
INSERT INTO syb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Naa duun pai nga sundalu, laung nilan pelum, “Yami, taꞌ mai baalen nami?” Kaliꞌ sembag, “Naa ndiꞌ na niu limbungayi getaw pebian di pendeg atawaka galeg. Adin su gikteb nu tindan diniu, iin dai sanguꞌ niu.” ");
INSERT INTO syb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Saꞌ maꞌantu, migisegi kegdedama nu nga getaw, sinaak nilan dig delendeman nilan saꞌ si Juan kini, mabuꞌ iin na tuꞌu su pedetengen nilan Tinduꞌ nu Megbebayaꞌ Meglekaunutan. ");
INSERT INTO syb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Dagid miktaluꞌ si Juan dinilan, “Baa, naan kini, megbunagu laak tubig diniu. Dagid duuni sungu metuaꞌ, metaas pai ginuungen batul danaan. Pia su sepatusen, kanaꞌu mbantang megubad dun diniin. Iin, bunagen diniu kig Balakat nu Megbebayaꞌ mukaꞌ gapuy. ");
INSERT INTO syb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Iin, minuyaꞌ na mekpalid di ginani. Saꞌ metubus mekpalid, pungunenen su trigo, teguꞌenen dayun tug lulunen. Laak dagid su gepis mukaꞌ gebas, sensulanen tu gapuy ndiꞌ na mpaleng.” ");
INSERT INTO syb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Naa melaun pa paduni tituluꞌan ni Juan tu nga getaw selianen megukit dinilan Gempia Petenday. ");
INSERT INTO syb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Dagid su kaunutan dia si Herodes, pigbeluꞌan ni Juan, puꞌ duunig libun, ngalanen si Herodias, inagaw ni Herodes, asa sawa nu pateden. Mukaꞌ melaun pai melaat gulaula ni Herodes, pigbeluꞌan dadema dun ni Juan iin. ");
INSERT INTO syb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kaas deksuꞌanen, sala paig dugang ni Herodes ditu melaat pinggulaulanen, pipirisunen si Juan. ");
INSERT INTO syb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Laak su saanan pa ni Juan megukit tu kelaun getaw, pimbunaganen ilan tubig. Mendadi si Isus, mikpebunag dadema dini Juan tubig. Benaꞌ mitubus bunagay tubig si Isus, kaliꞌ penenabi, mipukaꞌ sug langit. ");
INSERT INTO syb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Dayun sug Balakat nu Megbebayaꞌ, kuminilawan, miglanguban di maꞌniin palas limuun, luminusad dini Isus. Duun dayuni miktaluꞌ ditug langit, laungen, “Yaꞌai petailen ku Bataꞌu, leliagenu gupia diniꞌa.” ");
INSERT INTO syb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Naa su kekpuun ni Isukristu tu kengimbaalen, minayan na saani telu puluꞌi taunen. Mendadi, kinii gesalan ni Isus. Laung dun nu nga getaw, iini gamaꞌen, si Jose kiin. Si Jose pelum, iini gamaꞌen si Heli. ");
INSERT INTO syb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Si Heli, iini gamaꞌen si Matat. Si Matat, iini gamaꞌen si Levi. Si Levi, iini gamaꞌen si Melqui. Si Melqui, iini gamaꞌen si Jana. Si Jana, iini gamaꞌen su sala Jose. ");
INSERT INTO syb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Si Jose, iini gamaꞌen si Matatias. Si Matatias, iini gamaꞌen si Amos. Si Amos, iini gamaꞌen si Nahum. Si Nahum, iini gamaꞌen si Esli. Si Esli, iini gamaꞌen si Nagai. ");
INSERT INTO syb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Si Nagai, iini gamaꞌen si Maat. Si Maat, iini gamaꞌen si Matatias. Si Matatias, iini gamaꞌen si Semei. Si Semei, iini gamaꞌen si Jose. Si Jose, iini gamaꞌen si Juda. ");
INSERT INTO syb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Si Juda, iini gamaꞌen si Joan. Si Joan, iini gamaꞌen si Resa. Si Resa, iini gamaꞌen si Sorobabel. Si Sorobabel, iini gamaꞌen si Salatiel. Si Salatiel, iini gamaꞌen si Neri. ");
INSERT INTO syb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Si Neri, iini gamaꞌen si Melqui. Si Melqui, iini gamaꞌen si Adi. Si Adi, iini gamaꞌen si Cosam. Si Cosam, iini gamaꞌen si Elmodam. Si Elmodam, iini gamaꞌen si Er. ");
INSERT INTO syb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Si Er, iini gamaꞌen si Josue. Si Josue, iini gamaꞌen si Eliezer. Si Eliezer, iini gamaꞌen si Jorim. Si Jorim, iini gamaꞌen si Matat. Si Matat, iini gamaꞌen si Levi. ");
INSERT INTO syb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Si Levi, iini gamaꞌen si Simeon. Si Simeon, iini gamaꞌen si Juda. Si Juda, iini gamaꞌen su sala Jose pelum. Si Jose, iini gamaꞌen si Jonan. Si Jonan, iini gamaꞌen si Eliakim. ");
INSERT INTO syb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Si Eliakim, iini gamaꞌen si Melea. Si Melea, iini gamaꞌen si Mainan. Si Mainan, iini gamaꞌen si Matata. Si Matata, iini gamaꞌen si Natan. Si Natan, iin pelumi gamaꞌen si David. ");
INSERT INTO syb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Si David, iini gamaꞌen si Isai. Si Isai, iini gamaꞌen si Obed. Si Obed, iini gamaꞌen si Boos. Si Boos, iini gamaꞌen si Salmon. Si Salmon, iini gamaꞌen si Naason. ");
INSERT INTO syb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Si Naason, iini gamaꞌen si Aminadab. Si Aminadab, iini gamaꞌen si Admin. Si Admin, iini gamaꞌen si Arni. Si Arni, iini gamaꞌen si Hezron. Si Hezron, iini gamaꞌen si Fares. Si Fares, iini gamaꞌen si Juda. ");
INSERT INTO syb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Si Juda, iini gamaꞌen si Jacob. Si Jacob, iini gamaꞌen si Isaac. Si Isaac, iin pelumi gamaꞌen si Abraham. Si Abraham, iini gamaꞌen si Tare. Si Tare, iini gamaꞌen si Nahor. ");
INSERT INTO syb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Si Nahor, iini gamaꞌen si Serug. Si Serug, iini gamaꞌen si Ragau. Si Ragau, iini gamaꞌen si Peleg. Si Peleg, iini gamaꞌen si Eber. Si Eber, iini gamaꞌen si Sala. ");
INSERT INTO syb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Si Sala, iini gamaꞌen si Cainan. Si Cainan, iini gamaꞌen si Arfaxad. Si Arfaxad, iini gamaꞌen si Sem. Si Sem, iin pelumi gamaꞌen si Noe. Si Noe, iini gamaꞌen si Lamec. ");
INSERT INTO syb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Si Lamec, iini gamaꞌen si Matusela. Si Matusela, iini gamaꞌen si Enoc. Si Enoc, iini gamaꞌen si Jared. Si Jared, iini gamaꞌen si Mahalaleel. Si Mahalaleel, iini gamaꞌen si Cainan. ");
INSERT INTO syb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Si Cainan, iini gamaꞌen si Enos. Si Enos, iini gamaꞌen si Set. Si Set, iin na pelumi gamaꞌen, naa si Adan. Mukaꞌ si Adan pelum, iin na gupiai gamaꞌen, su Megbebayaꞌ. Kinii gesalan ni Isus. ");
INSERT INTO syb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Naa mendadi kini si Isus, minuliꞌ genat ditu tubig Jordan, pingepuꞌan na nug Balakat nu Megbebayaꞌ. Benaꞌ ndaꞌ maiben, inabay dayun si Isus nug Balakat nu Megbebayaꞌ mekpanawpanaw tug limawaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Saananen dia, pingindanan nu Palin si Isus seled paat puluꞌ gebii. Laak gikteb nu kegbebenwanen dia, ndaꞌ siben aan si Isus. Kaas benaꞌ mitektaki paat puluꞌ gebii, migutem gupia. ");
INSERT INTO syb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Mendadi, miktaluꞌ su Palin dini Isus, “Mendadi, yaꞌa sug Bataꞌ nu Megbebayaꞌ, daw. Naa saꞌ pinenggiꞌ metuud, naa kig batu kinuꞌ, pebaluy mu daw pan.” ");
INSERT INTO syb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Dagid sumimbag si Isus, laungen, “Paa, duuni sinulat ditu Misulat Taluꞌ nu Megbebayaꞌ, laung, ‘Kanaꞌ gaan laaki ketubuꞌan nu kilawan.’” ");
INSERT INTO syb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Naa saꞌ maꞌantu, pituad pelum nu Palin si Isus, pinitaꞌen dayun diniin selingka su kelaunan peglegediꞌan dinig dibabaw lumbang. ");
INSERT INTO syb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Miktaluꞌ pelum su Palin dini Isus, “Naa kig launanen kiin, yaꞌa nai begayan ku dun, yaꞌai pebiaꞌen ku dun, mukaꞌ daniꞌa su kelaunlaun kelengasen. Puꞌ naani pigwekilan dun, kaas pia taꞌ taway duni pegwekilan ku dun, naan dai metau dun. ");
INSERT INTO syb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kaas saꞌ mengamuyuꞌa dinaan, daniꞌa na su kelaunanen.” ");
INSERT INTO syb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Dagid sumimbag si Isus, laungen, “Duun pagidi misulat, ‘Su Kaunutan mu Megbebayaꞌ laaki penluꞌudan mu, ndaꞌig lain temuyen mu.’” ");
INSERT INTO syb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Mendadi, iwit na pelum nu Palin si Isus tu Jerusalem, piꞌindegen dayun ditu tampusan ditaas nug Balay Pengedapan tu Megbebayaꞌ. Miktaluꞌ dayun su Palin diniin, “Saꞌ metuud puꞌ yaꞌa tuꞌu sug Bataꞌ nu Megbebayaꞌ, naa sampaka diag lupaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Puꞌ duuni misulat ditu Taluꞌ nu Megbebayaꞌ, laung, ‘Suguꞌen nu Megbebayaꞌ su nga sesuguꞌenen getaw langit megingat diniꞌa.’ ");
INSERT INTO syb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Mukaꞌ duun pa pagidi misulat, ‘Sipupuun ka nilan, adun ndiꞌa meseknun dig batu.’” ");
INSERT INTO syb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Dagid sumimbag si Isus, laungen, “Duun pagidi misulat, ‘Su Kaunutan mu Megbebayaꞌ, ndiꞌ mu pengindanay mekatag di tinaluꞌen.’” ");
INSERT INTO syb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Naa benaꞌ mitubus si Isus penulayay sia di kelaun gininisan kengindan dun, bilengan pa deliꞌ nu Palin. ");
INSERT INTO syb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Naa saꞌ maꞌantu, mipuliꞌ si Isus ditu Galilea, ginuungan, sabaꞌ pingepuꞌan nug Balakat nu Megbebayaꞌ. Mileep dig lumibut benwa sug dengeganen. ");
INSERT INTO syb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Minamal mektituluꞌ dia nga simbaan nu getaw Judea, enalen dadema nu kelaun getaw. ");
INSERT INTO syb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Naa minateng puliꞌ si Isus ditu Nazaret, sug lunsud tandaꞌ mitenudanen. Benaꞌ sala Gendaw Pelali, minangay si Isus tu simbaan nu getaw Judea, maaꞌ nug betaden. Benaꞌ dia seled simbaan, migindeg adun megbasa di Misulat Taluꞌ nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Mendadi, tinulun diniin su sinulat nu pimuunan nu Megbebayaꞌ si Isaias. Kaliꞌ belatay ni Isus su sinulat, minitaꞌen ki misulat dakus binasanen, laungen, ");
INSERT INTO syb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Naan, pingepuꞌanu nug Balakat nu Kaunutan Megbebayaꞌ, puꞌ tinduꞌu niin megukit Gempia Petenday tu nga gempusuk getaw. Pimuunanu niin adun petendayu tu nga dinaap sug bian kebeluy dinilan. Pimuunanu niin adun petendayu tu ngag buta sug bian keneguliꞌ di mata nilan. Sinuguꞌu niin tu nga getaw pilaatan, adun lukatu dinilan ");
INSERT INTO syb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","dakus pesuun ku dinilan su taun nu kegawen nu Kaunutan Megbebayaꞌ di nga kilawan.” ");
INSERT INTO syb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Benaꞌ mitubusen besaay, linulun puliꞌ ni Isus su sinulat, inuliꞌen di sala tawan migabang dia. Migingkud puliꞌ si Isus, pinentengan gupia nu kelaun getaw dia simbaan. ");
INSERT INTO syb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kaliꞌ pektaluꞌ si Isus di nga getaw dia, “Mendadi, ki misulat kini di Taluꞌ nu Megbebayaꞌ, minuud gupia nandaw, pebian di kegbasau dun diniu.” ");
INSERT INTO syb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Saꞌ maꞌantu, didial si Isus nu kelaun getaw dia. Misebuꞌan ilan ditu melengas gupia taluꞌen. Dagid maaꞌ laung pa nilan, “Asa ki getaw kini, kanaꞌ bain sug bataꞌ laak ni Jose?” ");
INSERT INTO syb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Benaꞌ midengeg ni Isus, kaliꞌ sembag, “Mabuꞌ teluꞌen pa niu dinaan ki penteluꞌen nu getaw, laung, ‘Memulung, pauliꞌay muig lawas mu. Saꞌitada su nga mekesalebuꞌ tuꞌus midengeg nami pinggulaula ditug lunsud Capernaum, naa iini baal mu pa pagid dinig daan benwa mu.’ ");
INSERT INTO syb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Naa metuud daan,” maaꞌ laung pa ni Isus, “ki pimuunan nu Megbebayaꞌ, kanaꞌ mpenembaꞌ diag daan benwanen. ");
INSERT INTO syb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Naa taluꞌu diniu tuꞌu, maꞌnia dademai mipenggulaula dengantu, su timpu pa ni Elias. Kig benwa Judea kini, ndaꞌig dupiꞌ dun gikteb telu taun buꞌ ginengaꞌ, kaas mibianan meliget gutem su tibuuk benwa. Laak pia melaun paig balulibun dinig benwa ta Israel, ");
INSERT INTO syb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ndaꞌ nu Megbebayaꞌ suguꞌay si Elias ditu nilan, subay ditu laak sala tawan balulibun tug lain bansa, ditu Sarepta sakup Sidon. ");
INSERT INTO syb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Mesama dadema ditu timpu nu pimuunan nu Megbebayaꞌ si Eliseo. Melaun pasiꞌ sakup Israel pegladu mekesalebuꞌ nuka, laak ndaꞌidun lain piuliꞌanen, daal da ki sala tawan ngalanen si Naaman, getaw Siria.” ");
INSERT INTO syb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Mendadi, su melaun getaw dig dialem simbaan, benaꞌ midengeg nilani tinaluꞌ kia ni Isus, mitutung ilan gangit. ");
INSERT INTO syb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Minlibuat ilan megutid dini Isus diag lunsud. Inagak nilan tu gilidan nug bentud tandaꞌ pisekan tug lunsud. Benaꞌ midepet ilan tu keba, lebuꞌen nilan sia si Isus. ");
INSERT INTO syb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Laak dagid minguliksuk si Isus di tebenan getaw, mikegliaw dinilan. ");
INSERT INTO syb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Naa tumigbeng si Isus tu Capernaum, sala lunsud na pelum, sakup dadema Galilea. Benaꞌ Gendaw Pelali na, mikpetuꞌun dia simbaan nu getaw Judea. ");
INSERT INTO syb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Saꞌ mikpetuꞌun si Isus, misebuꞌan su nga getaw, puꞌ su tituluꞌanen, duuni pegbayaꞌen. ");
INSERT INTO syb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Naa duuni sala tawan dia, piglegetan menulay. Iin, benaꞌ minitaꞌen si Isus, miktegas dayun, laungen, ");
INSERT INTO syb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ii, yaꞌa Isus kiin, getaw Nazaret, taꞌ maig labet mu dinami? Midiniin ka ba mekpatay dinami? Mailalau yaꞌa, yaꞌa ma su Pimiliꞌ nu Megbebayaꞌ!” ");
INSERT INTO syb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Pimaag ni Isus su menulay, laungen, “Ndiꞌa pesasak! Pegawaꞌa di getaw kiin!” Naa ki menulay kini, pibuksaken su getaw di gedapan nilan, dayun tuꞌu megawaꞌ diniin, ndaꞌen tanan mpesaitay ki piglegetanen kia. ");
INSERT INTO syb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mendadi su kelaun getaw dia, misebuꞌan ilan dun gupia. Laung nilan, “Alandun ini, ki tituluꞌan nu getaw kini? Pia su menenulay, duuni ginuungen mukaꞌ pegbayaꞌen mesuguꞌen, mautidan ilan dayun!” ");
INSERT INTO syb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Saꞌ maꞌantu, migleleep ditug lumibut benwa sug dengegan ni Isus. ");
INSERT INTO syb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Naa benaꞌ gumiwaꞌ si nga Isus dia simbaan nu getaw Judea, minangay ilan ditug balay ni Simon. Mendadi mitaang dun dema, pegladu ki penugangan ni Simon libun, gembagai panasen. Mendadi, inubug nu nga getaw dini Isus, pegebanganen kig libun kia. ");
INSERT INTO syb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Mikpesempel diniin si Isus, sinuguꞌen dayun mawaꞌ su panasen. Migwanan dayun. Suminambut megbuat sug libun mukaꞌ mikpelutuꞌ, migilak dayun dini nga Isus. ");
INSERT INTO syb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Naa benaꞌ sungu na mesindepi gendaw, adini nga getaw duunig dumanen pegladu, pinguit nilan ditu ni Isus, migininisan naig leduun nilan. Pigleteb ia ni Isus depenay, diadia piuliꞌanen. ");
INSERT INTO syb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mukaꞌ pa padun, melaun getaw piglegetan menenulay, pingutidan dadema ni Isus dinilan su menenulay. Miktegas su menenulay, laung nilan, “Yaꞌa sug Bataꞌ nu Megbebayaꞌ!” Laak ndaꞌ begay ni Isus mektaluꞌtaluꞌ su menenulay, puꞌ misuunan nilan, iin tuꞌu su Tinduꞌ nu Megbebayaꞌ Meglekaunutan. ");
INSERT INTO syb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Naa benaꞌ miglegendaw, minawaꞌ si Isus diag lunsud, minangay tug limawaꞌ. Laak pinengaw nu nga getaw dia. Naa benaꞌ mibaangan nilan, inubug nilan sia diniin, ndiꞌ na mekpesuay dinilan. ");
INSERT INTO syb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Laak kaliꞌ pektaluꞌ si Isus, “Subay megwali pau dema Gempia Petenday nu Keglekaunutan nu Megbebayaꞌ ditu ngag lain lunsud, puꞌ iini sinuguꞌ dinaan nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Naa saꞌ maꞌantu, minundas si Isus, pegwali dia nga simbaan nug benwa Judea. ");
INSERT INTO syb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Laak duuni gendaw, pegindeg si Isus ditu geksid linaw Genesaret. Mikpungunpungun dini Isus su nga getaw, adun kineegan nilan su Gempia Petenday genat tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Naa saanan ni Isus megukit dia, minitaꞌenig duaꞌ buuk sekayan midengguꞌ di geksid linaw. Laak su menelisedaꞌ, luminusad na, pingugasan nilan sug baling nilan. ");
INSERT INTO syb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Saꞌ maꞌantu, luminulan si Isus di salabuuk sekayan, iini gapuꞌen si Simon, dayunen petulaktulakay dini Simon kemaikaꞌ. Naa benaꞌ miꞌigin su sekayan melayuꞌlayuꞌ di geksid, pegingkud si Isus diag dialem nu sekayan, pituꞌunanen gusay su nga getaw dia geksid. ");
INSERT INTO syb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mendadi benaꞌ mitubus na megukit, laung ni Isus dini Simon, “Naa, bundas pamu diag laud nug linaw kini, dia amu pemaling, adun mekelaam amu.” ");
INSERT INTO syb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","“Laak Sir,” laung ni Simon, “piglegendawan mami metegelan memaling, ndaꞌ ami tanan mekelaam. Dagid saꞌ teluꞌen mu memalingu, naa memalingu gusay.” ");
INSERT INTO syb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Mimaling ilan dayun diag laud mukaꞌ mikelaam ilan, ndiꞌ na mbilangi sedaꞌ milaam nilan. Naa benaꞌ meglegetus na sia su ngag baling nilan, ");
INSERT INTO syb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","kipayan ni nga Simon su ngag duma nilan diag lain sekayan, mikpaingabang ilan dinilan. Mikpesempel ilan, dayun sug duaꞌ buuk sekayan, mipenuꞌ gupia, sampay peglened na sia. ");
INSERT INTO syb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Laak si Simon Pedro, benaꞌ minitaꞌen su mipenggulaula, minginlulud di gedapan ni Isus, laungen, “Uu Kaunutan, pelayuꞌa dinaan, puꞌ mikesalaꞌu getaw!” ");
INSERT INTO syb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kaas maꞌniai tinaluꞌ ni Pedro, puꞌ misebuꞌan patiꞌ, sampay su kelaun dumanen, ditu melaun sedaꞌ milaam nilan. ");
INSERT INTO syb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Maꞌantu dademai ngag duma ni Simon, si Santiago buꞌ si Juan, ngag bataꞌ ni Sebedeo. Kaliꞌ pektaluꞌ si Isus dini Simon, “Ndiꞌa na mendek. Puꞌ genat nandaw, kanaꞌ na sedaꞌi peglaaman mu, puꞌ getaw na, adun sumakup ilan dinaan.” ");
INSERT INTO syb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Naa benaꞌ midengguꞌ nilan su nga sekayan nilan, binilin nilan dayun sug launan pimetang nilan, migdunut ilan dayun dini Isus, suminakup ilan diniin. ");
INSERT INTO syb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Naa selian ni Isus di sala lunsud, mitaang duuni getaw dia, mileep mekesalebuꞌ nukaig lawasen. Mendadi, benaꞌ minitaꞌ nu getaw kini si Isus, miglaub dayun di gedapanen, kaliꞌ penengi diniin, laungen, “Sir, saꞌ mauyaꞌan mu da, suunan ku megaga mau pauliꞌay!” ");
INSERT INTO syb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tinggal ni Isusig baingkenen, dipenaneni getaw kia, kaliꞌ pektaluꞌ, “Naa, mauyaꞌan ku lai. Mauliꞌan ka dadema tuꞌu!” Seduꞌunduꞌun dayun miawaꞌ su mekesalebuꞌ nukanen. ");
INSERT INTO syb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Laak inungub ni Isus su piuliꞌanen kia, laungen, “Pia sala tawan, ndaꞌiduni ukitan mu di mipenggulaula kini. Segaga angaya tug belian, pekpebantaya diniin, dayun ilak mu sug betang pinalinta ni Moises dengantu, puꞌ adun metakesiꞌan ka nu getaw, miawaꞌ na su kelemuꞌay mu.” ");
INSERT INTO syb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Dagid minamal laak mesigwag sug dengegan ni Isus. Kaas melaun gupia getaw mikpungun adun mekineeg diniin dakus mekpebulung diniin di ngag leduun nilan. ");
INSERT INTO syb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Laak taang dun, megawaꞌ si Isus di tebenan getaw, mangay tu meliaw benwa, adun menenabi dia. ");
INSERT INTO syb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Naa duuni gendaw, mikpetuꞌun si Isus. Duun dademai pemegingkud dia ki nga sakup nu pikumpungan nu getaw Judea piningalan dun Pariseo, mukaꞌ nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ. Genat ilan di kelaun lunsud sakup Galilea dakus Judea, sampay genat tu Jerusalem. Naa si Isus, ginuungan meneguliꞌ di pegladu, puun tu Kaunutan Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mendadi, duuni nga getaw minateng, pegbuligan nilan di sinampuyuan ki mipilung. Benaꞌ midepet ilan diag balay kia, peseleden nilan sia ki mipilung, adun pebeliliden nilan di gedapan ni Isus. ");
INSERT INTO syb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Laak dagid sabaꞌ nu melaun getaw, ndiꞌ mesuꞌati keseled nilan diag balay. Kaliꞌ ilan pegleketau, minaik ilan tu gatep, inawaꞌ nilan dayuni nga santaꞌ laad nu gatep kia tisaꞌ. Saꞌ miguangan su gatep, tintun nilan dayun su mipilung, dia da gusay sinampuyuan dun. Pibelilid nilan dayun dia titengaꞌ nu nga getaw, dia gedapan ni Isus. ");
INSERT INTO syb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Mendadi si Isus, benaꞌ minitaꞌen ki kesalig nilan diniin, miktaluꞌ di pilung kia, “Naung, pidasun na su salaꞌ mu.” ");
INSERT INTO syb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Naa mendadi, ki nga Pariseo kini mukaꞌ ki nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, benaꞌ midengeg nilan ki tinaluꞌ kia ni Isus, kaliꞌ ilan taluꞌ dig dialem delendeman nilan, “Paa, ki getaw kini, mauma dema piksudiꞌanen pelum su Megbebayaꞌ? Taꞌ mai mekepedasun di salaꞌ, subay su laak Megbebayaꞌ?” ");
INSERT INTO syb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Misuunan dayun ni Isusig dialem nug delendeman nilan kia. Kaliꞌ dayun pektaluꞌ dinilan, “Mauma dema maꞌniini teluꞌen niu dig dialem delendeman niu? ");
INSERT INTO syb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Puꞌ saꞌ su kilawan laak, melemu pebelusen saꞌ teluꞌenen tu pilung, ‘Pidasun na su salaꞌ mu.’ Melemu dadema pebelusen saꞌ teluꞌenen, ‘Pegbuata, panawa.’ ");
INSERT INTO syb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Dagid naan kini, luminusad mau, miksibaluyu Bataꞌ nu Kilawan. Saꞌ maꞌantu, paitaꞌu diniu puꞌ duuni pegbayaꞌu mekpedasun di salaꞌ dinig dibabaw lumbang.” Luminingay dayun si Isus tu pilung mukaꞌ miktaluꞌ diniin, “Naa, taluꞌu tuꞌu diniꞌa, pegbuata, sikwat mui sinampuyuan diniꞌa kiin, mukaꞌ uliꞌa!” ");
INSERT INTO syb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Suminambut tuꞌu megbuat dia gedapan nu melaun getaw su pilung kia, sinikwaten su sinampuyuan diniin kia, dayun muliꞌ, pegenalanen su Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Naa su kelaun getaw dia, mipatiꞌ ilan mesebuꞌay dun, inal nilan gelaꞌ su Megbebayaꞌ dunut mindek pailan pagid, laung nilan, “Mekesalebuꞌ gupiai minitaꞌ ta kini nandaw!” ");
INSERT INTO syb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tubus nitu, mipanaw si Isus. Benaꞌ mipanaw, duuni mipekitaꞌen sala tawan mendawat buis pegingkud diag bataꞌ gupisinanen, ngalanen si Levi. Sinabi ni Isus si Levi, laungen, “Dunuta dinaan.” ");
INSERT INTO syb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Benaꞌ midengeg ni Levi, migbuat dayun, bilengen tanan su kelaun sengkapanen, migdunut tuꞌu dini Isus, suminakup na diniin. ");
INSERT INTO syb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Naa si Levi, pigbesaanen si Isus di gaan tug balayen, gembibu gupia. Melaun mendawat buis suminaup, melaun dademai getaw dumingan dinilan maan. ");
INSERT INTO syb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mendadi ki nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ mukaꞌ ki nga sama Pariseo nilan, pigbensi nilan su nga sakup ni Isus, laung nilan, “Paa, mauma dema dumingan mamu maan di nga mendawat buis kia mukaꞌ di ngag duma mekesesalaꞌ getaw?” ");
INSERT INTO syb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Kaliꞌ sembag si Isus, “Naa su getaw ndaꞌig leduunen, ndiꞌ kambat mekpebulung, subay su laak duunig leduunen. ");
INSERT INTO syb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Naa naan kini, maꞌantu dadema, iini luminusadu dun dinig lumbang, adun pesikesuunen ku su laak mekesesalaꞌ getaw, kanaꞌ nu nga gandang mekesuun getaw.” ");
INSERT INTO syb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Naa mendadi duuni nga getaw, kaliꞌ ilan pektaluꞌ dini Isus, “Saꞌ su nga sakup ni Juan, betad nilan mekpuasa mukaꞌ menenabi. Mesama dadema su nga sakup nu nga Pariseo. Dagid su ngag daniꞌa sakup, laak maan ilan dakus minum ilan pelum.” ");
INSERT INTO syb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Kaliꞌ sembag si Isus, “Waꞌa daan, puꞌ penenggiꞌan dun sug belaꞌi. Su nga suminaup dig belaꞌi, kendutaꞌen ba nilan pekpuasa, saanan duma pa nilan su menginsawa? ");
INSERT INTO syb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Laak dagid duuni gendaw mateng, uiꞌen na dinilan ki menginsawa, dekag pailan tuꞌu pekpuasa.” ");
INSERT INTO syb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Naa minalap pelum si Isus penenggiꞌan, laungen, “Duun bai getaw sukpay dig begu suuben, adun iini ekleben dig danul suuben kig begu gupia penepeten? Puꞌ saꞌ pinenggiꞌ pemaꞌantuunen, mesabaꞌen megedit sug begu, asa kig begu gekleb, ndiꞌ dadema mbantang ditug daan penepeten. ");
INSERT INTO syb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Mukaꞌ pa pagid sug betad megbetang penginumen di pemetangan binaal panit petubuꞌen, maꞌantu dadema. Duun bai getaw megbetang begu penginumen dig daan pemetangan? Puꞌ saꞌ pinenggiꞌ maꞌnia, saꞌ tumulin sug begu penginumen, ndiꞌ ba megbetu su panit petubuꞌen? Deksuꞌanen, megulaꞌ su penginumen, mukaꞌ meglaat dadema su pemetanganen. ");
INSERT INTO syb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kaas sug begu penginumen, subay begu dadema su pemetanganen. ");
INSERT INTO syb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Laak ndaꞌi getaw mitagam na meginum dig daan penginumen, metumuꞌen dayun sug begu penginumen. Puꞌ laungen, ‘Melengas sug daan.’” ");
INSERT INTO syb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Naa duuni Gendaw Pelali, minayan si nga Isus di pegimulanan trigo. Naa selian nilan mayan dia, mingetes tu trigo su nga sakup ni Isus, kinusu nilan, dayun nilan pekaanay. ");
INSERT INTO syb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mendadi ki nga Pariseo, benaꞌ minitaꞌ nilan su kengetes nu nga sakup ni Isus tu trigo kia, kaliꞌ ilan pektaluꞌ, “Paa, mauma iin maꞌniinig baalen niu? Ki Gendaw Pelali, binandu dinita ditu Misulat Palinta nu Megbebayaꞌ duunig baalen ta di gendaw kini!” ");
INSERT INTO syb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Kaliꞌ sembag si Isus dinilan, “Baa, pia da. Puꞌ si David kanugdiin, ndaꞌ ba niu mbasa ki pinggulaulanen dadema saꞌ migutem, ilan nu ngag dumanen? ");
INSERT INTO syb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Puꞌ sumiled si David ditug Balay Pengedapan tu Megbebayaꞌ, inalapen su pan ginilak tu Megbebayaꞌ, dayunen aanay, inilasanen dun padun su ngag dumanen. Asa binandu ditu Misulat Palinta nu Megbebayaꞌ duuni maan di pan kia, subay su laak ngag belian.” ");
INSERT INTO syb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Diksuꞌ ni Isus su sinumpaten di nga Pariseo, “Mendadi naan kini, kig Bataꞌ nu Kilawan, naani Kaunutan megbayaꞌ dig baalen nu kilawan metaang di Gendaw Pelali.” ");
INSERT INTO syb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Naa benaꞌ lain Gendaw Pelali, minangay si Isus di simbaan nu getaw Judea, miktituluꞌ dia. Naa mitaang duuni getaw dia, mingupesi sedibaluy kemeten dapit lintu. ");
INSERT INTO syb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Naa ki nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ mukaꞌ ki nga Pariseo, penengaun nilan siai gempia dangat nilan dini Isus. Saꞌ maꞌantu, piktuliktulikan nilan gupia si Isus saꞌ meneguliꞌ metaang di Gendaw Pelali, saꞌ ndiꞌ. ");
INSERT INTO syb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Laak misuunan ni Isus kig delendeman nilan kia. Mendadi, kaliꞌ pektaluꞌ si Isus di getaw kia mingupesi kemeten, “Naa, pegindega, pediniin ka gedapan nug launan.” Migbuat dayun, migindeg di gedapan nilan. ");
INSERT INTO syb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Laung dayun ni Isus di nga getaw kia menengaw dangat nilan diniin, “Naa, duuni saaken ku diniu. Taꞌ alandun mai biwang dinita ditu Misulat Palinta nu Megbebayaꞌ, baalen ta metaang di Gendaw Pelali? Pepianan ta bai samataw ta di Gendaw Pelali, atawaka pelaatan ta? Guunen ta su ginaanen, atawaka petain ta ba?” ");
INSERT INTO syb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Pingenlengan ilan dayun ni Isus diadia, tinaluꞌen dayun di getaw kia mingupesi kemeten, “Naa, tenggal mui kemet mu.” Tinggalen dayun, mukaꞌ miuliꞌan. ");
INSERT INTO syb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mendadi ki nga mekpetuꞌun di Palinta kia mukaꞌ ki nga Pariseo, mitutung ilan patiꞌ gangit. Migyagayaga ilan dayun, endutaꞌen nilan dun si Isus. ");
INSERT INTO syb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Naa ndaꞌ maiben, duuni gendaw tumiwad si Isus dig bentud adun menenabi ditu. Benaꞌ mitingkag tug bentud, pigendawan dia menenabi ditu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mendadi benaꞌ miglegendaw, sinabi ni Isus su nga sakupen. Saꞌ mipungun ilan dia niin, pimiliꞌanen ilan, tinduꞌen ki sepuluꞌ buꞌ duaꞌ tawan dinilan, ilani gilal ni Isus nga peneliganen. ");
INSERT INTO syb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Sug beknanen, si Simon, piningalan dun ni Isus si Pedro. Dayun si Andres, pated ni Simon, mukaꞌ si Santiago, si Juan, si Felipe, si Bartolome. ");
INSERT INTO syb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Dayun si Mateo, si Tomas, si Santiago, gamaꞌen si Alfeo, dayun si Simon, piningalan dun su mingatu tu gubirnu. ");
INSERT INTO syb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Dayun si Judas, gamaꞌen su sala Santiago. Mendadi su kesepuluꞌ buꞌ duaꞌen, iin si Judas Iscariote, su tumipu pa dini Isus. ");
INSERT INTO syb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Naa mindiksun si nga Isus. Benaꞌ pegindeg ilan diag datag, mikpungun dia ni Isus su melaun gupia sakupen, dakus melaun getaw genat tu tibuuk Judea dakus Jerusalem sampay genat tu geksid dagat, ditug lunsud paingalan dun Tiro mukaꞌ Sidon. Mituaꞌi melaun gupia getaw adun mekineeg dini Isus dakus mekpebulung diniin ditug leduun nilan. ");
INSERT INTO syb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Sampay su nga piglegetan menulay, pineguliꞌan ilan dadema. ");
INSERT INTO syb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Su kelaun getaw, diadia pinengawenig bianen megdeluꞌ dini Isus, puꞌ duuni ginuung gumiwaꞌ diniin, kaas ndaꞌidun dinilani ndaꞌ mauliꞌay. ");
INSERT INTO syb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Mendadi, pingenlengan ni Isus su nga sakupen, kaliꞌ pektaluꞌ dinilan, “Naa, yamu nu nga gempusuk getaw, liliag amu, puꞌ mikesakup amu tu Keglekaunutan nu Megbebayaꞌ! ");
INSERT INTO syb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Yamu nu nga megutem nemun, liliag amu dadema, puꞌ pebesugen dun amu nu Megbebayaꞌ! Yamu nu nga pengaduy nemun, liliag amu dadema, puꞌ duuni gendaw, pentuaan amu!” ");
INSERT INTO syb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Laung padun ni Isus, “Naa saꞌ maꞌantu, saꞌ bentaan amu nu getaw dakus pemilasen amu nilan mukaꞌ tampalaksaan amu, mukaꞌ saꞌ peksudiꞌan amu pa pagid sabaꞌ nu kesakup niu dinaan kini, kig Bataꞌ nu Kilawan, naa liliag amu! ");
INSERT INTO syb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Kaas saꞌ maꞌniai mbianan niu, pegleliag amu dun, sampay megleksuleksu amu. Puꞌ maꞌananen, duun pai sugda diniu gembagel ditu gekbus langit. Puꞌ iini sama niu, su nga pimuunan nu Megbebayaꞌ dengantu, puꞌ maꞌantu dademai kekpeleget dinilan nu ginepuꞌay nu getaw nemun.” ");
INSERT INTO syb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Laung padun ni Isus, “Dagid yamu nu nga medatuꞌ getaw, mekelelaatlelaat amu, puꞌ su memis kebetang, migelaꞌ na niu malap! ");
INSERT INTO syb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Yamu nga mibesug nemun, mekelelaatlelaat damu dema, puꞌ megutem pamu! Yamu nga peketawa nandaw, mekelelaatlelaat amu pagid, puꞌ melegenan pamu, mukaꞌ mekengaduy pamu! ");
INSERT INTO syb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mukaꞌ mekelelaatlelaat amu saꞌ penalan amu nug launan getaw, puꞌ iini sama niu su nga getaw dengantu tautau pimuunan nu Megbebayaꞌ, pinalan dailan dema nu ginepuꞌay nu getaw nemun.” ");
INSERT INTO syb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Kaliꞌ gusay pektaluꞌ si Isus, “Laak yamu nu nga mekineeg, kinii taluꞌu diniu nandaw, petail niui nga kuntra niu. Ki nga getaw megbanta diniu, pepianay niu dadema. ");
INSERT INTO syb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ki nga mektuyud diniu, penenebiay niu mpianan, sampay su mekpelaat diniu. ");
INSERT INTO syb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Saladuaꞌ diniu, saꞌ pinenggiꞌ depiꞌen ka di muluꞌ mu dapit lintu, pedapiꞌ mu pagid su sedibaluy muluꞌ mu ditug duminapiꞌ diniꞌa. Adin su malap suub mu, begay mu dun pa pagid su kamisita mu, peduma mu padun su suub mu. ");
INSERT INTO syb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ki kelaun menengi diniꞌa, begayay mu. Saꞌ duuni malap pimetang mu, ndiꞌ mu peksaakay puliꞌ diniin. ");
INSERT INTO syb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kaas pia taꞌ alanduni melabuꞌ dig delendeman niu melengas sia gabang nug duma niu diniu, iini baal niu dinilan.” ");
INSERT INTO syb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kaliꞌ padun pektaluꞌ si Isus, “Saꞌ iin da laaki petailen niu su mekpetail diniu, bantang bamu sugdaan nu Megbebayaꞌ? Puꞌ pia su nga mikesalaꞌ getaw, mekpetail dailan dema tu nga mekpetail dinilan! ");
INSERT INTO syb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mukaꞌ saꞌ iin laaki pepianan niu su mekpepia diniu, naa bantang bamu sugdaan dun? Pia su nga mikesalaꞌ getaw, maꞌniaig betad nilan! ");
INSERT INTO syb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mukaꞌ padun, saꞌ iin laaki pedamen niu su laung niu metau meguliꞌ pelum diniu gidamen, naa bantang bamu sugdaan dun? Pia su mikesalaꞌ getaw, pedamen da nilan dema sug duma nilan, adun biadan nilan puliꞌ su miutang! ");
INSERT INTO syb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Dagid yamu, petail niu su nga kuntra niu. Pepianay niu su nga samataw niu. Pedam niu ilan di ndaꞌi pedetengen niu dun mpuliꞌ diniu. Puꞌ saꞌ maꞌniai penggulaulaan niu, naa gembagel gupiai sugda diniu, mengemaꞌan amu tu Tampusan Metaas. Puꞌ daniin betad, melilelaaten. Pia su getaw ndiꞌ metau ebangan sampay su medupang getaw, lelaatanen da gusay. ");
INSERT INTO syb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kaas melilelaaten amu, maaꞌ dadema nu Gamaꞌ niu Megbebayaꞌ, melilelaaten.” ");
INSERT INTO syb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Kaliꞌ pektaluꞌ si Isus, “Ndiꞌ niu pegdenaꞌay su nga samataw niu, mukaꞌ ndiꞌ amu ukumen nu Megbebayaꞌ. Ndiꞌ niu peselaꞌay su samataw niu, mukaꞌ ndiꞌ damu dema ukuman nu Megbebayaꞌ. Pedasun niu su samataw niu, pedesunen damu dema nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Begayay niu su samataw niu, dayun begayan damu dema nu Megbebayaꞌ. Pebegelen dayun nu Megbebayaꞌ sug betanganen tug begayen diniu, tisenenen pa pagid mukaꞌ engkugenen dakus pepenuꞌenen sampay meglapay. Puꞌ adini tepengan niu dig begay niu, iin dademai tepengan nu Megbebayaꞌ tug begayen pelum diniu.” ");
INSERT INTO syb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Mendadi, miksambingay si Isus di nga getaw, laungen, “Sug buta, mesuꞌaten ba egakay dig dalanig dumanen, buta dadema? Pinenggiꞌ egakenen, dayun buus duunig luak dia gunaan nilan, ndiꞌ ba megelaꞌ ilan dayun melabuꞌ dia? ");
INSERT INTO syb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","“Su getaw mektuꞌun, kanaꞌ metaas pa di mekpetuꞌun diniin. Laak adin su metubus na pektuꞌunay, melepengen dadema su mikpetuꞌun diniin.” ");
INSERT INTO syb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Kaliꞌ padun pektaluꞌ si Isus, “Naa mauma dema saladuaꞌ diniu, maitaꞌ mu ki maikaꞌ puling di mata nug duma mu, laak yaꞌa, ndaꞌ mu metukaway puꞌ duun dademai puling mu, gembagel? ");
INSERT INTO syb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Mukaꞌ pagid mauma dema teluꞌen mu pelum tug duma mu, ‘Uy, Mingumpated, uaꞌen ku pa deliꞌ ki puling mu kiin,’ asa yaꞌa dema, ndiꞌ mu maitaꞌ puꞌ mipulinga dadema gembagel puling? Baa, yaꞌa kiin, tautau mekesuun ka! Kaas unaay mu uaꞌay ki gembagel puling di mata mu kiin, adun mpalas mu su maikaꞌ puling nug duma mu, adun mawaꞌ mu.” ");
INSERT INTO syb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Kaliꞌ pagid pektaluꞌ si Isus, “Ndaꞌiduni gempia gayu megbunga melaaten. Mesama dadema di melaat gayu, ndiꞌ megbunga melengas. ");
INSERT INTO syb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kaas saꞌ peksimaꞌen su gayu, iini kimanan, kig bunganen. Sug bunga igera, kanaꞌ maupuꞌ dig dugi. Kanaꞌ dadema maupuꞌ dig dugi sug bunga gubas. ");
INSERT INTO syb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Maꞌniin dadema su mekesuun getaw, gempiai pegbetadenen, puꞌ sug betaden, puun di gempia delendemanen. Su pelum medupang getaw, melaati pegbetadenen, puꞌ sug betaden, puun dadema di melaat delendemanen. Puꞌ ki taluꞌ nu getaw, iini megbuas dig delendemanen.” ");
INSERT INTO syb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Kaliꞌ gusay pektaluꞌ si Isus, “Naa, mauma dema gelalen niau Kaunutan, asa ki suguꞌan ku diniu, ndiꞌ niu pelum petuuden? ");
INSERT INTO syb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Adin su getaw medini naan adun mekineeg di teluꞌen ku, dayun megdunut dun, maꞌniniꞌi petenggiꞌan ku dun. ");
INSERT INTO syb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Penenggiꞌan duni getaw migbaal balay. Migengkul medalem, adun entudenen di telektap sug balayen. Naa benaꞌ mitubus sug balay, migbaaꞌ su tubig, kaas midenlagan nu guluan layas sug balay. Laak ndaꞌ tanan pegegdel, sabaꞌ gempageni kebaal dun. ");
INSERT INTO syb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Laak dagid adini getaw mekedengeg di taluꞌu kini laak ndiꞌen dunutan, iini maaꞌ nu getaw migbaal balayen diag lupaꞌ laak, ndaꞌi gintudanen dun. Dayun kig balayen kia, benaꞌ midenlagan baaꞌ, migebaꞌ dayun, gembagelig dulebaken.” ");
INSERT INTO syb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Naa benaꞌ mideksuꞌen su kelaun pidengegen tu nga getaw dia, mipanaw si Isus ditug lunsud piningalan dun Capernaum. ");
INSERT INTO syb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Naa duuni getaw diag lunsud kia, kaunutan di sundalu nu getaw Roma, migladui petailenen sesuguꞌenen, pekagawinaa da dun. ");
INSERT INTO syb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mendadi su kaunutan, benaꞌ midengegen su kedateng ni Isus, duuni sinuguꞌen nga kaunutan nu getaw Judea, adun sebiin nilan si Isus, adun sia mangay meneguliꞌ di sesuguꞌenen kia. ");
INSERT INTO syb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Naa benaꞌ minateng ditu ni Isus su nga sinuguꞌ, kaliꞌ ilan penengi diniin, “Ki kaunutan sundalu kiin, mbantang dema tuꞌu ebangan mu, ");
INSERT INTO syb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","puꞌ melelaat dig bansa ta, iini miglegastu di simbaan nami.” ");
INSERT INTO syb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Saꞌ maꞌantu, sumikat tuꞌu si Isus, migdunut dayun tu nga sinuguꞌ kia. Laak benaꞌ mesempel nailan tug balay, suminuguꞌ su kaunutan sundalu di nga sambaten mangay mekpetenday dini Isus, pimuunen dinilan, “Naa Sir, petuyangen na, laungen, ndiꞌa na mundas. Puꞌ naan, kanaꞌ mbantang penaikan muig balayu. ");
INSERT INTO syb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kaas ndaꞌu makuꞌ madap diniꞌa. Pektaluꞌa laak diin, naa misuunan ku puꞌ mauliꞌan tuꞌui sesuguꞌen ku kia. ");
INSERT INTO syb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Puꞌ maaꞌ dinaan kini, duuni metaas pa dinaan sumuguꞌ dinaan, duun pa pagidi sundalu suguꞌen ku. Teluꞌan kui sala tawan, ‘Dituun ka angay,’ meditu dayun. Teluꞌan ku pelumi sala tawan, ‘Diniin ka angay,’ medini dadema. Saꞌ teluꞌan ku su gulipen ku, ‘Maꞌniniꞌi baalen mu,’ naa baalenen dayun.” ");
INSERT INTO syb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Benaꞌ midengeg ni Isus su pimuunen kia, misebuꞌan dun gupia. Liningayen dayun su kelaun getaw tumindug diniin, laungen dinilan, “Taman taluꞌu diniu, ki kaunutan kiin, ndaꞌu mainsan mbianayi kesalig mesama di kesaligen, pia pa dini nita nga getaw Israel!” ");
INSERT INTO syb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Naa benaꞌ minateng puliꞌ su nga sinuguꞌ ditug balay nu kaunutan sundalu, iini mitaangan nilan, miuliꞌan na tuꞌu su sesuguꞌen kia. ");
INSERT INTO syb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tubus nituꞌ ndaꞌ maiben, mipanaw si Isus, ilan nu nga sakupen sampay melaun gupia getaw, minangay ilan ditug lunsud piningalan dun Nain. ");
INSERT INTO syb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Naa benaꞌ misebang ilan tu gengaꞌan nug lunsud, duuni nga getaw pegbulig minatay misungkak nilan. Ki minatay kini, buntung bataꞌ balulibun. Dakus melaun getaw genat tug lunsud migdunut tug balulibun. ");
INSERT INTO syb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mendadi su Kaunutan si Isus, benaꞌ minitaꞌen sug balulibun, milelaat dun dayun, laungen diniin, “Naa Dadaꞌ, ndiꞌa na pengaduy.” ");
INSERT INTO syb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Naa mukaꞌ mikpesempel si Isus, dipenanen sug lungun. Mitenlen dayun su nga migbulig dun. Miktaluꞌ si Isus, “Naa Nuung, taluꞌu diniꞌa, pegbuata!” ");
INSERT INTO syb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Migingkud tuꞌu ki minatay kia, dunut mikektaluꞌ na. Pigwakil dayun ni Isus tu ginaꞌen. ");
INSERT INTO syb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Naa apelai, su nga kelaun getaw, mindekan ilan patiꞌ. Inal nilan dayun su Megbebayaꞌ, laung nilan, “Mituaꞌ na dinita ki metaas pimuunan nu Megbebayaꞌ! Liningiꞌan na tuꞌu nu Megbebayaꞌi nga piglegetawanen!” ");
INSERT INTO syb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Naa saꞌ maꞌantu, mileep tug benwa Judea su gukiten di pinggulaula ni Isus, sampay ditug lumibut benwa. ");
INSERT INTO syb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Naa si Juan kiin, su Memunag Tubig, inukit diniin nu nga sakupen su tibaꞌan pinggulaula ni Isus. ");
INSERT INTO syb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Mendadi sinabi ni Juanig duaꞌ tawan sakupen, sinuguꞌen ilan meditu nu Kaunutan si Isus, pimuunen dinilan, laung, “Sir, kelelaat taluꞌ mu dinami saꞌ yaꞌa na tuꞌu su pedetengen nami lumusad, atawaka mekpedateng pami dig lain?” ");
INSERT INTO syb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Naa benaꞌ midepet ditu ni Isus su nga sinuguꞌ ni Juan, laung nilan diniin, “Sir, sinuguꞌ ami ni Juan su Memunag Tubig. Pimuunen dadema dinami saaken diniꞌa, saꞌ yaꞌa ma daw su pedetengen nami lumusad, atawaka megelat pami dig lain?” ");
INSERT INTO syb_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Naa mitaang dun, melaun mimegladu mukaꞌ mesaitan pineguliꞌan ni Isus dakus melaun getaw piglegetan menenulay, sampay melaun buta pipengitaꞌen. ");
INSERT INTO syb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Mendadi, sumimbag si Isus ditu nga sakup ni Juan, laungen, “Naa, puliꞌ amu ditu ni Juan, ukit niu diniin ki taman minitaꞌ niu kini mukaꞌ ki midengeg niu. Su ngag buta, mikengitaꞌ na. Su nga pilung, mikepanaw na. Su nga migladu mekesalebuꞌ nuka, miuliꞌan na. Su ngag bengel dema, mikedengeg na. Sampay su nga minatay, pitubuꞌ na puliꞌ. Mukaꞌ su gempusuk getaw, inukitan na tu Gempia Petenday. ");
INSERT INTO syb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kaas adini getaw ndiꞌ memilas dinaan, iini liliag!” ");
INSERT INTO syb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Mendadi, saꞌ mipalus su nga sakup ni Juan, migukit si Isus tu melaun getaw mekatag dini Juan. Sinaak ni Isus dinilan, “Naa kini si Juan, saꞌ linaawan niu iin ditug limawaꞌ, alandun mai pedetengen niu diniin? Laung niu ba si Juan, maaꞌ nu sala puun tigbaw, melemu mpilay nu genus? Kanaꞌen. ");
INSERT INTO syb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Naa saꞌ maꞌantu, alandun mai pedetengen niu diniin? Laung niu dun puꞌ getaw migimakay? Baa, kanaꞌen dadema, puꞌ su getaw migimakay dakus melengasi kebetangen, subay ditu laak penengaway balay nu nga gadiꞌ! ");
INSERT INTO syb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mendadi saꞌ maꞌantu, taꞌi pedetengen niu maitaꞌ niu? Getaw pimuunan nu Megbebayaꞌ? Waꞌa lai! Mukaꞌ taman taluꞌu diniu, kini si Juan, kanaꞌ laak pimuunan nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Puꞌ iinen dadema su mibetang ditu Misulat Taluꞌ nu Megbebayaꞌ, laung, ‘Miktaluꞌ su Megbebayaꞌ, Mendadi paunaan ku diniꞌa ki pemuunan ku, puꞌ adun pengendamenen sug bianan mu.’” ");
INSERT INTO syb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kaliꞌ gusay pektaluꞌ si Isus, “Naa saꞌ maꞌantu, taman taluꞌu diniu, genat pa dini Adan sampay nemun, ndaꞌi sala tawan metaas pa dini Juan. Laak dagid pia maꞌantu, adin su tampusan gembabaꞌ sakup di Keglekaunutan nu Megbebayaꞌ, iini metaas padun dini Juan.” ");
INSERT INTO syb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Naa su melaun getaw kampuꞌ nu nga mendawat buis, benaꞌ midengeg nilan su tinaluꞌ kia ni Isus, mikpetuud ilan tu Megbebayaꞌ, ilani gandang binunagan ni Juan tubig. ");
INSERT INTO syb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Laak dagid su nga Pariseo mukaꞌ su nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, pimilas nilan sug delendeman nu Megbebayaꞌ dinilan, kaas mipauk ilan bunagan ni Juan tubig. ");
INSERT INTO syb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kaliꞌ padun pektaluꞌ si Isus, “Mendadi ki getaw nemun, alandun mai penenggiꞌan ku dun? Alandun bai samanen? ");
INSERT INTO syb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Petanggiꞌu di gembataꞌ pemeglingkulu pegayep dia padiꞌan. Beksayan nilan su nga samambataꞌ nilan, laung nilan, ‘Mauma saꞌ minlantuyan ami diniu, ndaꞌ amu peksabay? Dayun saꞌ miksulang ami, mauma ndaꞌ amu pelum pengaduy?’ ");
INSERT INTO syb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Puꞌ si Juan,” laung ni Isus, “mituaꞌ diniu, iinig betaden mekpuasa mukaꞌ ndiꞌ minum mekebulek. Laung niu dayun, ‘Pingepuꞌan menulay!’ ");
INSERT INTO syb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Tubus itu naan kini, kig Bataꞌ nu Kilawan, mituaꞌu pelum diniu, betadu maan dau mukaꞌ minum dau dema. Laung niu pelum, ‘Paa, bentayay pa daan niu, medalu masiꞌ maan mukaꞌ penenatan meginum, sambaten pa paduni nga mendawat buis mukaꞌ ki ngag duma mekesesalaꞌ getaw!’ ");
INSERT INTO syb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Laak dagid ki tantu sinuunan genat tu Megbebayaꞌ, mailala dia penggulaulaan nu megdunut dun.” ");
INSERT INTO syb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Naa inggat si Isus maan tug balay nu sala tawan Pariseo. Miliag si Isus, midia dayun adun sumalu dinilan maan. ");
INSERT INTO syb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Naa duuni sala tawan libun dangen dig lunsud kia, tebiaꞌ meglaat pekesuunan. Laak pia maꞌantu, kig libun kini, benaꞌ midengegen pekaan si Isus diag balay nu Pariseo, midia dayun, peguit bataꞌ bandi gemputiꞌ, mipenuꞌ pagemut. ");
INSERT INTO syb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mendadi, benaꞌ mitulan sug libun, migindeg di teliudan ni Isus, mesempel di geksuden. Pengaduy namal sug libun kia, mitegduꞌan luaꞌen su geksud ni Isus. Benaꞌ mibasaꞌ luaꞌen su geksud ni Isus, pinunasan dayun nug libun, iini pinunasen dun sug buuken, dunut pingelekanen su geksud ni Isus, kegbasanen diniin. Binunaganen padun nu pagemut su geksud ni Isus. ");
INSERT INTO syb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Dekag minitaꞌ nu Pariseo kia, maaꞌ laungen pa dig dialem delendemanen, “Paa, ki getaw kini, saꞌ sia metuud puꞌ pimuunan nu Megbebayaꞌ, mailalanen siaig libun kini mikpuleg diniin, mesimaꞌen sia puꞌ meglaat pekesuunan!” ");
INSERT INTO syb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Dagid si Isus, kaliꞌ pektaluꞌ, “Simon, duuni teluꞌen ku diniꞌa.” Kaliꞌ sembag si Simon, “Sigi, Sir, pedayun mu.” ");
INSERT INTO syb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Kaliꞌ pektaluꞌ si Isus, “Naa, duuni mekpautang kwarta, piutangen duaꞌ tawan. Ki sala tawan, inutangen lima gatus denario. Su sala, lima puluꞌ da. ");
INSERT INTO syb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Naa sabaꞌ ndaꞌ ilan mekebayad, pidasun nailan duaꞌ. Naa saꞌ maꞌantu, taꞌ ma, adin saan dinilan duaꞌ su gembageli kepetailen ditu mikpedasun diniin?” ");
INSERT INTO syb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Laung ni Simon, “Mabuꞌ ki getaw gembageli gutangen pidasun.” “Metuud,” laung ni Isus. ");
INSERT INTO syb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Liningayen dayun sug libun kia, kaliꞌ pektaluꞌ dini Simon, “Naa, maꞌantu dadema kig libun kini. Yaꞌa, saꞌ mitulanu dinig balay mu, ndaꞌ mau tanan begayay tubig gugasu sia di geksudu. Laak kig libun kini, kig luaꞌen nai ginugasen di geksudu, sug buuken demai pinunasen dun. ");
INSERT INTO syb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yaꞌa, ndaꞌ mau dedialay di galek. Laak dagid iin, sikna nau mitulan dini, ndaꞌen mainsan sikpaꞌay pengelekayi geksudu. ");
INSERT INTO syb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Yaꞌa, ndaꞌ mu bunagay lanai guluu, laak dagid iin, binunaganen pagemuti geksudu. ");
INSERT INTO syb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Paladpalad taman taluꞌu diniꞌa, ki salaꞌ nig libun kini, pia melaun, gempantek puꞌ pidasun na, puꞌ gembageli kepetailen dinaan. Laak adin su getaw pidasun di maikaꞌ, maikaꞌ dademai kepetailen.” ");
INSERT INTO syb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Miktaluꞌ dayun si Isus dig libun kia, “Pidasun nai salaꞌ mu.” ");
INSERT INTO syb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Naa su ngag duma ni Isus maan, benaꞌ midengeg nilan ki tinaluꞌen kini, mikpuun ilan sumaak dig delendeman nilan, laung nilan, “Paa, adin saan getaw ini, pia su salaꞌ, pedesunenen?” ");
INSERT INTO syb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Laung ni Isus tug libun kia, “Naa, migawen ka tuꞌu, sabaꞌ nu kesalig mu. Uliꞌa na, gempia nai ginaa mu.” ");
INSERT INTO syb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Naa ndaꞌ maiben, mipanaw si Isus, lineepen su ngag lunsud mukaꞌ gimbelayan diag lumibut benwa, pegukitenen ki Gempia Petenday puꞌ pikpuunan na su Keglekaunutan nu Megbebayaꞌ. Duma ni Isus su sepuluꞌ buꞌ duaꞌ tawan peneliganen, ");
INSERT INTO syb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","dakus duun dademai migdunut dinilan ngag libun, su nga gandang pingutid duni menenulay mukaꞌ piuliꞌan dig leduun nilan. Su sala tawan dinilan, si Maria Magdalena, su pingutidan diniini pitu buuk menenulay, ");
INSERT INTO syb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","dayun si Juana, sawa ni Cusa peneligan ni Herodes, sampay si Susana. Dakus melaun paig libun, ilani migabang meglegamut tu ketubuꞌan ni nga Isus. ");
INSERT INTO syb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Naa pinemalan si Isus laaway nu nga getaw genat tu ngag lumibut lunsud. Benaꞌ melaun gupia getaw mikpungun ditu niin, migukit si Isus dinilan sambingay. ");
INSERT INTO syb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Kaliꞌ pektaluꞌ si Isus, “Duuni getaw minangay tug binaalanen adun megimula. Laak benaꞌ saananen meksigwag, duunig beniꞌ mitenaꞌ ditug dalan, kaas miꞌindegan nu nga getaw mukaꞌ pingektuk nu nga manukmanuk. ");
INSERT INTO syb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Naa duun dademai mitenaꞌ ditug betuan. Benaꞌ mintubuꞌ, milawes dayun, puꞌ memala sug lupaꞌ. Minatay da pelum. ");
INSERT INTO syb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Naa duun pa pagidig beniꞌ mitenaꞌ dig dugian. Kaliꞌ pentubuꞌ su sigwag, mintubuꞌ dadema su ngag dugi. Benaꞌ tuminulin, milebeng dun su pimula. ");
INSERT INTO syb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Laak tumuꞌ kig duma beniꞌ, mitenaꞌ tuꞌu di pialupaꞌ, kaas mekelengasi tubuꞌen. Benaꞌ sumingkuꞌ, duuni pingmegatus.” Diksuꞌ dayun ni Isus su taluꞌen, “Adin sug duuni telinganen, mekineeg dema tuꞌu!” ");
INSERT INTO syb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Naa mendadi, inubug dini Isus nu nga sakupen, pegulugenen dinilan su sinambingayen kia. ");
INSERT INTO syb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Kaliꞌ sembag si Isus, “Aa naa yamu, buasan na diniu su gandang pigbuni mekatag di kesakup tu Keglekaunutan nu Megbebayaꞌ. Laak dagid pebian laak di sambingay su kegukit dun tug lain getaw, adun mengenleng dailan, laak ndiꞌ ilan mekengitaꞌ. Mekineeg dailan, laak ndiꞌ ilan mekesabut.” ");
INSERT INTO syb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Kaliꞌ gusay pektaluꞌ si Isus, “Naa mendadi, kinii gulugan nu sambingay kia. Kig beniꞌ kiin, iin su Gempia Petenday genat tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Naa sug beniꞌ mitenaꞌ diag dalan, damikian dun su nga getaw mikedengeg tu Gempia Petenday kia, laak benaꞌ medengeg nilan, mateng dayun su Palin, uaꞌenen pelum tug delendeman nilan su Gempia Petenday, adun ndiꞌ ilan mekpetuud dun, kaas ndiꞌ dailan dema megawen. ");
INSERT INTO syb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Naa su pelum beniꞌ mitenaꞌ diag betuan, iin su nga getaw, sikna medengeg nilan ki Gempia Petenday, telimaꞌen nilan dayun mukaꞌ penleliagen ilan dun. Laak ndaꞌ pengganget dig delendeman nilan, kaas kanaꞌ maiben su kekpetuud nilan. Saꞌ matengi kepenulay dinilan, teliudan nilan su kekpetuud nilan. ");
INSERT INTO syb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Naa sug beniꞌ mitenaꞌ dema dig dugian, iin su getaw tumuꞌ mikedengeg tu Gempia Petenday, laak dagid tubus itu, megelaꞌi ginaa nilan tu kelibuleng nilan tu kegleketubuꞌ nilan mukaꞌ su gaꞌus nilan sampay di nga gayepan nilan, kaas maulakanen su Gempia Petenday. Benaꞌ ki mamaꞌ bunga nilan, ndiꞌ na mainug. ");
INSERT INTO syb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mendadi kig beniꞌ mitenaꞌ dia pialupaꞌ, iin tumuꞌ su nga getaw mekedengeg tu Gempia Petenday dayun pepengganget nilan dig delendeman nilan, sabaꞌ gempia mukaꞌ melegdengig delendeman nilan. Dayun mektigel ilan, sampay megbunga ilan.” ");
INSERT INTO syb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kaliꞌ pektaluꞌ si Isus, “Mendadi ki suluꞌ, ndiꞌ tutudan dayun uklubay bandi, atawaka betangen tu silung belilidan. Segaga betangen dig dempaꞌan, adun medelaganen su nga getaw suled tug balay. ");
INSERT INTO syb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Kaas adin su giglud nandaw, mbuasan da saꞌ maiben. Adin su pigbuni nandaw, pesuunen da saꞌ maiben. ");
INSERT INTO syb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Kaas ki kelaunanen kini medengeg niu dini naan, talentenay niu gupia. Puꞌ adin su getaw duunig daniin, begayan pa padun. Adin pasiꞌ su getaw ndaꞌidunig daniin, laak uiꞌen pa diniin su maikaꞌ sia daniin.” ");
INSERT INTO syb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Naa su ginaꞌ ni Isus mukaꞌ su nga pateden, linaawan nilan sia si Isus, laak ndiꞌ mesuꞌati kekpesempel nilan diniin, sabaꞌ nu melaun getaw. ");
INSERT INTO syb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mendadi, pisuunan dun dayun si Isus, laung nu getaw diniin, “Sir, su ginaꞌ mu mukaꞌ su nga pated mu, pegindeg ilan diag liu, peksebiin ka nilan.” ");
INSERT INTO syb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Sumimbag si Isus, “Naa, waꞌa. Laak adini getaw mekineeg di Gempia Petenday genat tu Megbebayaꞌ, dayun pegdunutanen, iin pa pagidi ginaꞌu mukaꞌ nga patedu.” ");
INSERT INTO syb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Naa duuni gendaw duminangan si Isus di sekayan, ilan nu nga sakupen. Laung ni Isus, “Naa, dumipag ita dinig linaw.” Tuminulak nailan dema. ");
INSERT INTO syb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Selian nilan mekpangay tug dipag, tinulug si Isus. Mendadi ndaꞌ maiben, tekaw miksalindapak, misipukan dayun ki sekayan nilan kia, misimpitan ilan gupia. ");
INSERT INTO syb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Mikpesempel dini Isus su nga sakupen, tinanud nilan dayun iin, laung nilan, “Ii, Sir, megbayaꞌbayaꞌ ita dun ini!” Migbuat si Isus, pimaagen dayun su genus mukaꞌ su nga nabek. Misikpaꞌ ki salindapak, miksilengen gupia tuꞌu sug linaw. ");
INSERT INTO syb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kaliꞌ pektaluꞌ si Isus dia nga sakupen, “Mauma dema ndaꞌiduni kesalig niu dinaan?” Mindek dayun su nga sakup ni Isus, misebuꞌan ilan dun gupia. Kaliꞌ ilan peksinaakay, “Taꞌ gasal dun saan ini, pia su genus mukaꞌ nabek, masiꞌ mesuguꞌen, mekpetuud dayun diniin?” ");
INSERT INTO syb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Naa midengguꞌ si nga Isus ditug benwa tug dipag Galilea piningalan dun Gerasa. ");
INSERT INTO syb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Benaꞌ mikelusad si Isus tu sekayan, duuni getaw dangen dig lunsud kia suminungkak diniin. Ki getaw kini, silunuꞌan menulay. Miniben na ndaꞌ peginapet, kanaꞌ na dema megbenwa dig balay, puꞌ dia na kelebengan pegbenwa. ");
INSERT INTO syb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Mendadi, benaꞌ minitaꞌ nu silunuꞌan kia si Isus, mimeksay, miglaub di gedapan ni Isus, minekeg mektaluꞌ, laungen, “Ii, yaꞌa Isus, Bataꞌa nu Tampusan Metaas Megbebayaꞌ, taꞌ maig labet mu dinaan? Kelelaat dema tuꞌu diniꞌa, ndiꞌ mau pa peglegetay!” ");
INSERT INTO syb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Kaas mitaluꞌ dun nu menulay, puꞌ sinuguꞌ ni Isus megawaꞌ di getaw kia. Betaden, tatap peglegetay nu menulay ki getaw kia, kaas ginapus nu nga getaw, pinusasan kadina, iniketan pa padun su geksuden. Dagid getusenen laak su ngag baluden, dayun uitay nu menulay tug limawaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Mendadi, sinaakan ni Isus ki menulay kia, “Taꞌ mai ngalan mu?” Kaliꞌ sembag, “Si Linaksaꞌ.” Puꞌ melaun gupia menenulay sumilunuꞌ dun. ");
INSERT INTO syb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Pigubug nilan dini Isus, ndiꞌen pailan pedituun linaw gapuy. ");
INSERT INTO syb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Naa duuni sala kauluan babuy dia mesempel, melaun gupia babuy, meglunang ilan dia gabig. Pinengi nu menenulay dini Isus, pedituunen ilan ngag babuy kia, adun sulunuꞌ ilan dinilan. Mendadi, biwang ni Isus. ");
INSERT INTO syb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Dayun memegawaꞌ dia getaw kia su menenulay, sumilunuꞌ ilan pelum ditu ngag babuy. Benaꞌ su sala kauluan babuy, minggebek dumiksun ditug delipasan pangay diag linaw, migelaꞌ ilan dayun melemes. ");
INSERT INTO syb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mendadi, benaꞌ minitaꞌ nu nga megingat tu ngag babuy, minggebek ilan ditug lunsud, pigukit nilan dayun dia ki mipenggulaula kia, sampay ditug lumibut benwa. ");
INSERT INTO syb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Benaꞌ su getaw inukitan nilan dun, linaawan nilan su mipenggulaula kia. Benaꞌ midepet ilan ditu ni Isus, iini mitaangan nilan, su getaw inutidan tu menenulay, pegingkud laak iin di gedapan ni Isus. Mikseluk na suuben, miseksud na tuꞌu su pianan ginaanen. Naa, mindek patiꞌ su nga getaw. ");
INSERT INTO syb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Inukit dayun nu nga mikaitaꞌ dun su kebian kauliꞌay nu getaw kia silunuꞌan menenulay. ");
INSERT INTO syb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Saꞌ maꞌantu, su tibaꞌan getaw dig lumibut nu Gerasa, inubug nilan dini Isus, megawaꞌ dia nilan, puꞌ mindekan ilan patiꞌ. Saꞌ maꞌantu, duminangan puliꞌ si Isus ditu sekayan nilan, puꞌ dumipag ilan puliꞌ diag linaw. ");
INSERT INTO syb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Migubug tundug dini Isus ki getaw kia, su inutidan tu menenulay. Dagid piuliꞌ ni Isusi getaw kia, laungen, ");
INSERT INTO syb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Uliꞌa ma, pegukit mu ditu su gabang nu Megbebayaꞌ diniꞌa.” Naa saꞌ maꞌantu, mipanaw su getaw kia, sinigwagen tuꞌu ukitay dig lunsud kia su pinggulaula ni Isus diniin. ");
INSERT INTO syb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Naa benaꞌ minateng puliꞌ si nga Isus ditug dipag linaw, didialan si Isus nu kelaun getaw dia, puꞌ pigelatan nilan iin. ");
INSERT INTO syb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mendadi, duuni minangay ditu ni Isus kaunutan di simbaan nu getaw Judea, ngalanen si Jairo. Benaꞌ minateng, miglaub di gedapan ni Isus, inubugen dayun diniin megdunut tug balayen. ");
INSERT INTO syb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Puꞌ duunig buntung bataꞌen delaga meliget megladu, pekagawinaa na. Kig bataꞌen kini, mabuꞌ sepuluꞌ buꞌ duaꞌ tauni gidaden. Migdunut dayun dini Jairo si Isus. Naa selian ni Isus mpanaw, melaun gupia getaw tuminakin diniin, miꞌisel nilan si Isus. ");
INSERT INTO syb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Laak duuni sala tawan libun dia, sepuluꞌ buꞌ duaꞌ taun na, tebiaꞌ leduunen kig betad libun. Pia migelaꞌen su selapiꞌen di kepebulungen, ndaꞌi mekeneguliꞌ diniin. ");
INSERT INTO syb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mendadi kig libun kini, mikpesempel dia teliudan ni Isus, diluꞌen dayun su kuyamay suuben. Lemen laak mideluꞌeni suub ni Isus, misikpaꞌ dayun sug duguꞌen. ");
INSERT INTO syb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Sinaak dayun ni Isus, “Taꞌ taway duni mikpuleg dinaan?” Mimalaw laak su kelaun getaw. Kaliꞌ pektaluꞌ si Pedro, “Sir, linibutan ka nu nga melaun getaw kini, miꞌisela nilan!” ");
INSERT INTO syb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Dagid simbag ni Isus, “Duun laii mikpuleg dinaan, puꞌ mibetikan ku duuni ginuungu gumiwaꞌ dinaan.” ");
INSERT INTO syb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Naa sug libun kia, benaꞌ misuunanen puꞌ mitukawan iin, mikpesempel dayun dini Isus, miglaub dayun di gedapanen, mipatiꞌ mengedeg. Pigukiten dayun di gedapan nu kelaun getaw su kedeluꞌen dini Isus sampay su kauliꞌayen midengan dun. ");
INSERT INTO syb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kaliꞌ pektaluꞌ si Isus diniin, “Naa, Enaung, miuliꞌan ka na, sabaꞌ nu kesalig mu. Uliꞌa na, gempia nai ginaa mu.” ");
INSERT INTO syb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Naa selian ni Isus mektaluꞌ, duuni minateng sinuguꞌ genat ditug balay ni Jairo, ki kaunutan di simbaan kiin. Benaꞌ minateng dia ni Jairo, kaliꞌ pektaluꞌ, “Naa Sir, sug bataꞌ mu kiin, ndaꞌ mu na mesaguti ginaanen. Kaas ndiꞌ na kambat salibaꞌeni Mekpetuꞌun kiin.” ");
INSERT INTO syb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Laak benaꞌ midengeg ni Isus, kaliꞌ pektaluꞌ dini Jairo, “Naa, ndiꞌa na melibuleng, saliga laak, dayun mauliꞌan.” ");
INSERT INTO syb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Mendadi, benaꞌ minateng si Isus tug balay ni Jairo, ndaꞌen peseledayig lain getaw dumanen, subay si Pedro laak mukaꞌ si Juan, si Santiago, dakus su mekegulang nu gembataꞌ kia. ");
INSERT INTO syb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Naa sug launan getaw dia, mimengaduy ilan, penembiten nilan su gembataꞌ. Dagid miktaluꞌ si Isus, “Naa, ndiꞌ amu dega pengaduy. Puꞌ ki gembataꞌ kiin, kanaꞌ ma minatay. Pektulug da!” ");
INSERT INTO syb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Piketuanan laak nu nga getaw si Isus, puꞌ misuunan nilan, minatay tantu su gembataꞌ. ");
INSERT INTO syb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mendadi, piguidan ni Isus su gembataꞌ di kemeten. Sinabinen dayun, laungen, “Naa, Enaung, pegbuata!” ");
INSERT INTO syb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Mipuliꞌ dayun su gimuuden. Suminambut dayun megbuat su gembataꞌ. Sinuguꞌ dayun ni Isus, paanen nilan. ");
INSERT INTO syb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Naa su mekegulang nu gembataꞌ, mipatiꞌ ilan mesebuꞌay. Dagid inungub ilan ni Isus, pia laak daw sala tawan, ndaꞌiduni pesuunan nilan di mipenggulaula kia. ");
INSERT INTO syb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Naa su sepuluꞌ buꞌ duaꞌ tawan kiin mitenduꞌ ni Isus peneliganen, sinabinen ilan. Mendadi, benaꞌ mipungun ilan, bigayan ilan ni Isus ginuung mukaꞌ pegbayaꞌ mengutid tu kelaun menenulay mukaꞌ meneguliꞌ tu ngag leduun. ");
INSERT INTO syb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Sinuguꞌ ilan dayun ni Isus mpanaw, adun megukit ilan mekatag di Keglekaunutan nu Megbebayaꞌ mukaꞌ meneguliꞌ tu nga pegladu. ");
INSERT INTO syb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Puli pailan mpanaw, piktituluꞌanen ilan, laungen, “Saꞌ mpanaw amu, ndaꞌiduni sengkapan uiten niu, pia sekud, gambag, balun niu pan, atawaka selapiꞌ, mukaꞌ salabuuk laaki suub niu. ");
INSERT INTO syb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Adin sug bekna balay mekpepenaik diniu, ditu laak amu tuun, sampay mekebundas amu dig lain lunsud. ");
INSERT INTO syb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Adin sug lunsud ndiꞌ menembaꞌ diniu, pegawaꞌ amu dayun dia, mukaꞌ ekpug niu sug lepup lupaꞌ di geksud niu, adun metakesiꞌanig lunsud kia.” ");
INSERT INTO syb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mendadi maꞌnia, mipanaw tuꞌu su nga sepuluꞌ buꞌ duaꞌ peneligan ni Isus, lineep nilan dayun su ngag lunsud, migukit ilan tuꞌu di Gempia Petenday mukaꞌ pineguliꞌan nilan su nga pegladu tu kelaun benwa gingayan nilan. ");
INSERT INTO syb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Naa su kaunutan dia Galilea si Herodes, benaꞌ midengegen sug lumaun pinggulaula ni Isus, mikalangalangig delendemanen. Puꞌ sug duma getaw, pekteluꞌen nilan puꞌ kiin si Isus, iin si Juan su Memunag Tubig, masiꞌ mitubuꞌ puliꞌ. ");
INSERT INTO syb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Dagid sug duma mektaluꞌ, laung nilan puꞌ kiin si Isus, iin si Elias dengantu, mituaꞌ puliꞌ daw. Mukaꞌ duun pa pagidi mektaluꞌ, laung nilan puꞌ si Isus kiin, iini sala tawan pelum pimuunan dengantu, mitubuꞌ puliꞌ daw. ");
INSERT INTO syb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kaas mitaluꞌ ni Herodes, “Uy, si Juan, piputukan ku ma gulu. Naa saꞌ maꞌantu, kini midengegu, adin dun saan getaw iin?” Saꞌ maꞌnia, mauyaꞌan gupia ni Herodes mpekitaꞌen sia si Isus. ");
INSERT INTO syb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Naa ki nga peneligan ni Isus, su nga sinuguꞌen mangay megukit, mipuliꞌ nailan ditu ni Isus. Benaꞌ minateng ilan, inukit nilan dayun diniin su kelaunan pinggulaula nilan. Saꞌ mitubus, inggat ilan ni Isus mekpain ilan sia deliꞌ ditu sala lunsud piningalan dun Betsaida. ");
INSERT INTO syb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Laak su nga melaun getaw, misuunan nilani kepanaw kia ni nga Isus. Saꞌ maꞌantu, miglendug ilan. Laak didialan ilan ni Isus, inukitanen ilan dayun mekatag di Keglekaunutan nu Megbebayaꞌ, sampay pineguliꞌanen su nga pegladu dinilan. ");
INSERT INTO syb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mendadi, benaꞌ sungu na mesindepi gendaw, mikpesempel dini Isus su sepuluꞌ buꞌ duaꞌ tawan peneliganen, kaliꞌ ilan pektaluꞌ diniin, “Sir, su nga melaun getaw, melengas suguꞌen mu mangay ilan tu ngag lunsud mukaꞌ tu mektabuꞌ benwa, puꞌ adun mekesukat ilan lebungan nilan dakus mekenengaw ilan pektulugan nilan. Puꞌ kig benwa kini, meliaw ma.” ");
INSERT INTO syb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Sumimbag si Isus, “Yamu mai pekpaan dinilan.” “Apelai, Sir!” simbag nu nga sakupen. “Duun laakig lima buuk pan nami, dayun duunig duaꞌ buuk sedaꞌ. Naa mabuꞌ ndiꞌ dadema mesuꞌat suguꞌen mu ami mangay sumaluy gaan, ki sukal dini nga melaun gupia getaw kini?” ");
INSERT INTO syb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Puꞌ su getaw dia, lima ngibu tawan su laak lumbus laki.) Mendadi, kaliꞌ pektaluꞌ si Isus di nga sakupen, “Naa pekpinigpinigen niu ilan pemaingkuday, duun saani piglima puluꞌ tawan sala penunan dun.” ");
INSERT INTO syb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Piningkud nilan tuꞌu sug launan getaw. ");
INSERT INTO syb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Mendadi, inimud ni Isus kig lima buuk pan kia mukaꞌ sug duaꞌ buuk sedaꞌ, dayun megangag tug langit mukaꞌ mekpaladpalad tu Megbebayaꞌ. Pikpetapetanen dayun su pan mukaꞌ sedaꞌ, piktukiden pegilasay tu nga sakupen, adun pengilaken nilan tu nga getaw. ");
INSERT INTO syb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Minaan dayun su kelaun getaw, mukaꞌ migelaꞌ ilan mbesug. Benaꞌ mibesug nailan, kaliꞌ pengikpesay nu nga sakup ni Isus su sawad nilan, sepuluꞌ buꞌ duaꞌ dig belanan mipenuꞌen. ");
INSERT INTO syb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Naa, duuni gendaw sumiway si Isus tu melaun getaw adun menenabi, dumanen laak su nga sakupen. Benaꞌ misuay ilan, sinaak ni Isus tu nga sakupen, “Mendadi naan kini, saꞌ su gasalu, alanduni ketaluꞌ dun nu getaw?” ");
INSERT INTO syb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kaliꞌ sembag su nga sakupen, “Yaꞌa daw si Juan su Memunag Tubig. Saꞌ sug duma mektaluꞌ, yaꞌa daw si Elias dengantu. Mukaꞌ duun pa pagidi mektaluꞌ, yaꞌa dawi sala tawan pa pelum pimuunan nu Megbebayaꞌ dengantu, mitubuꞌ daw puliꞌ.” ");
INSERT INTO syb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Mendadi yamu dema,” sinaak ni Isus, “taꞌ mai ketaluꞌ niu dun, ki gasalu?” Sumimbag si Pedro, “Yaꞌa na gupia su Tinduꞌ nu Megbebayaꞌ Meglekaunutan.” ");
INSERT INTO syb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Laak dagid benaꞌ midengeg ni Isus su tinaluꞌ kia ni Pedro, inunguben su nga sakupen, ndiꞌ nilan pesuun tu getaw ki gasalen kia. ");
INSERT INTO syb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kaliꞌ pagid pektaluꞌ dinilan, “Naan, kig Bataꞌ nu Kilawan, melaun pai kekpeleget dinaan. Mukaꞌ pemilasenu pa pagid nu nga kaunutan nu getaw Judea mukaꞌ su nga kaunutan nug belian kampuꞌ nu mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ. Deksuꞌanen, petainu nilan. Laak dagid di ketelu endawen genat di kepatayu, petubuꞌenu puliꞌ.” ");
INSERT INTO syb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kaliꞌ dayun pektaluꞌ si Isus tu melaun getaw, “Mendadi, saꞌ duuni getaw mauyaꞌanen sumakup dinaan, iin, subay teliudanen sug daniin delendeman, pisanenen dayun gendawgendaw ki kurusen, dakus dumunut dinaan. ");
INSERT INTO syb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Puꞌ adini mpauk megwakil gumulen dinaan, mbeleng diniin su ketubuꞌ ndaꞌi tamanen. Adin su pegwakilen dinaan su gumulen sabaꞌ nu kesakupen dinaan, iin, malapen sungkin su ketubuꞌ ndaꞌi tamanen. ");
INSERT INTO syb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Puꞌ pia pa malap nu getaw su tibuuk lumbang, dayun mbeleng diniin su ketubuꞌ ndaꞌi tamanen, naa alandun bai gatagen? Ndaꞌidun! ");
INSERT INTO syb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Adini getaw mpiid mangken di kesakupen dinaan mukaꞌ di taluꞌu, naa naan, kig Bataꞌ nu Kilawan, mpiid dau dema mangken diniin sakupu saꞌ lumusadu puliꞌ dini. Mukaꞌ saꞌ lumusadu puliꞌ, maitaꞌ na di tiagu su kelengas nu pegbayaꞌu, iin dademai kelengas nu pegbayaꞌ nu Gamaꞌu Megbebayaꞌ mukaꞌ danu nga pinaas sesuguꞌenen getaw langit.” ");
INSERT INTO syb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Diksuꞌ ni Isus su taluꞌen, “Taman taluꞌu diniu, yamu nga getaw pegindeg dini nandaw, duun diniui ndiꞌ matengi gumulen, meduaꞌ matanen ki Keglekaunutan na tuꞌu nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Naa duun saani sala simana, tumiwad si Isus dig bentud adun menenabi dia. Pidunuten si nga Pedro, si Juan, mukaꞌ si Santiago. ");
INSERT INTO syb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mendadi, selian ni Isus menenabi, masiꞌ mitekaw mpalini palasen. Sampay su nga penepetenen, metilak gupia sabaꞌ keputiꞌen. ");
INSERT INTO syb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Mukaꞌ padun tekaw duunig duaꞌ tawan dumanen pegabitabit, masiꞌ si Moises mukaꞌ si Elias, ");
INSERT INTO syb_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","tumiag dademai palas nilan. Pegyegaan nilan sug delendeman nu Megbebayaꞌ sungu penuuday ni Isus saꞌ mateng ditu Jerusalem, saꞌitada ki kepatayen. ");
INSERT INTO syb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Laak si nga Pedro kia, tinulug pailan gupia. Dagid mitanud ilan, kaas minitaꞌ nilan dayun tumiagi palas ni Isus. Minitaꞌ nilan dadema sug duaꞌ tawan pegindeg di gupiden. ");
INSERT INTO syb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Saanan lumilung nug duaꞌ tawan duma ni Isus, kaliꞌ pektaluꞌ si Pedro, “Aa Sir, melengas puꞌ dini dami! Naa, megbaal ami bebelayan telu buuk, salabuuk daniꞌa, salabuuk dani Moises, mukaꞌ salabuuk dema dani Elias.” (Laak ndaꞌ ni Pedro mesuunayi gempia sia teluꞌenen.) ");
INSERT INTO syb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Naa selian ni Pedro mektaluꞌ, duuni gabun mituaꞌ mikeleklem dinilan. Kaliꞌ peleklemay dun si nga Pedro, mipatiꞌ ilan mendek. ");
INSERT INTO syb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Duuni miktaluꞌ dig dialem gabun, laungen, “Kini na tuꞌu sug Bataꞌu, ki pimiliꞌu. Pekineegay niu iin!” ");
INSERT INTO syb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Dekag mideksuꞌ mektaluꞌ, minitaꞌ nilan, sala da dun ni Isus dia. Genat itu, pigunguban pa nilan ki minitaꞌ nilan kia, miniben pa dekag nilan pegukit di nga getaw. ");
INSERT INTO syb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Naa benaꞌ miksala gendaw, duminiksun si nga Isus. Kaliꞌ ilan diksun, melaun gupia getaw suminungkak dini Isus. ");
INSERT INTO syb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mendadi, kaliꞌ pektawagi sala tawan, laungen, “Sir, kig bataꞌu kini, penengiin ku diniꞌa, bentayay mu, puꞌ buntung bataꞌu! ");
INSERT INTO syb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Iin, peglegetan menulay. Saꞌ matengi kegleget dun, metekaw megbeksay, dayun bebuyen, megbulaꞌig babaꞌen. Ndiꞌ sia megawaꞌ diniin ki menulay. Dekag pa megawaꞌ diniin, metegelan dun gupiaig bataꞌu kini! ");
INSERT INTO syb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Naa, inubugu di nga sakup mu kini, utidan nilan sia ki menulay, laak ndaꞌ nilan megaga.” ");
INSERT INTO syb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Kaliꞌ pektaluꞌ si Isus tu nga getaw dia, “Ay, yamu pa di nga getaw nemun, ndaꞌi salig niu, mipenulay amu! Pinlukas nau dumuma diniu. Santaꞌ pai kaibenen, ki ketigelu diniu?” Laung ni Isus tu gamaꞌ nu gembataꞌ kia, “Uit mu dini kig bataꞌ mu kiin!” ");
INSERT INTO syb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Puli pa midepet dia ni Isus su gembataꞌ, pibuksak nu menulay kia, binabuy dayun. Mendadi pimaag dayun ni Isus ki menulay kia, piuliꞌanen tuꞌu su gembataꞌ, pigwakilen dayun puliꞌ tu gamaꞌen. ");
INSERT INTO syb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Su kelaun getaw migbantay, misebuꞌan ilan patiꞌ di metaas ginuung kia nu Megbebayaꞌ. Mendadi, selian misebuꞌan su melaun getaw tu taman pinggulaulanen, kaliꞌ pektaluꞌ si Isus tu nga sakupen, ");
INSERT INTO syb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mendadi yamu, talentenay niu gupia kini taluꞌu diniu. Naan kini, kig Bataꞌ nu Kilawan, duuni gendaw mateng, pegwakilu tu pegbayaꞌ nu getaw.” ");
INSERT INTO syb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Dagid ki tinaluꞌ kia ni Isus, ndaꞌ metekad nu nga sakupen. Puꞌ ndaꞌ pa mbuasay sug delendeman nilan, kaas ndiꞌ pa nilan mesabut, mukaꞌ mekalangalang ilan dema sumaak dun diniin. ");
INSERT INTO syb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Naa mendadi su nga peneligan ni Isus, miksual ilan, saꞌ taway dun dinilani tampusan metaasi tindegen. ");
INSERT INTO syb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Laak misuunan ni Isus kig delendeman nilan kia. Dayun suminabi si Isus sala tawan gembataꞌ, piꞌindegen dia gupiden, ");
INSERT INTO syb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","kaliꞌ pektaluꞌ, “Adin su menembaꞌ di gembataꞌ kini sabaꞌ nu kesakupen dinaan, naa gitunganen, naani mipenembaꞌen. Pidag pa tanan, kagina pinembaꞌu niin, mipenembaꞌen dadema su suminuguꞌ dinaan. Puꞌ adin diniui mekpebabaꞌ gupia dig lawasen, iini tampusan metaasi tindegen.” ");
INSERT INTO syb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Laak dagid si Juan, kaliꞌ pektaluꞌ dini Isus, “Sir, duuni minitaꞌ nami getaw megutid di menenulay, sembayanen su ngalan mu. Laak pimaag nami, puꞌ kanaꞌ tain samasakup di pikumpungan ta.” ");
INSERT INTO syb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Laak kaliꞌ sembag si Isus, “Naa, ndiꞌ niu pemaagay. Puꞌ adini getaw kanaꞌ kuntra niu, iini sugut niu.” ");
INSERT INTO syb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Naa mendadi, saꞌ sungu na mateng su kepuliꞌ ni Isus ditu gekbus langit, pia maꞌantu, pinanteken di ginaanen megdayun da gusay tu Jerusalem. Saꞌ maꞌantu, sumikat ilan dayun, ");
INSERT INTO syb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","duuni piuna ni Isus nga sakupen mangay tu salabuuk lunsud tu Samaria, adun pengendamen nilan sia su kengintuluganen dia. ");
INSERT INTO syb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Dagid su nga getaw Samaria kia, benaꞌ misuunan nilan kig delendeman ni Isus pegangay ditu Jerusalem, benwa nu getaw Judea, naa ndaꞌ nilan dayun penembaꞌay si nga Isus diag lunsud nilan. ");
INSERT INTO syb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Saꞌ maꞌantu, laung nu sakupen, si Santiago mukaꞌ si Juan, “Naa, uu Kaunutan, liagan mu ba mekpelabuꞌ ami dinilan dupiꞌ gapuy genat tug langit, adun mesapul ilan?” ");
INSERT INTO syb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Laak liningay ni Isus su nga sakupen kia, pimaagen ilan dayun. ");
INSERT INTO syb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Minundas dayun tug lain lunsud si nga Isus. ");
INSERT INTO syb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Naa mendadi, selian ni nga Isus mundas, duuni getaw pektaluꞌ diniin, “Sir, pia adin ka angay, megdunutu diniꞌa.” ");
INSERT INTO syb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Kaliꞌ sembag si Isus, “Laak naan, kig Bataꞌ nu Kilawan, ndaꞌidun tanani pektulugan ku. Tumuꞌ pa su nga teleksuy, duuni gateb nilan, mukaꞌ su nga manukmanuk, duuni salag nilan.” ");
INSERT INTO syb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Naa duun pelumig lain getaw, miktaluꞌ si Isus diniin, “Sakupa dinaan.” Kaliꞌ sembag, “Laak Sir, muliꞌ pau deliꞌ, puꞌ unaan ku pa lebengay su gamaꞌu.” ");
INSERT INTO syb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Kaliꞌ pelum sembag si Isus, “Baa, su nga pangay tu kepatay ndaꞌi tamanen, melengas ilan nai meglebeng tu nga matay dinilan. Yaꞌa pelum, angaya na megukit mekatag di Keglekaunutan nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Duun pa pelumi sala tawan, kaliꞌ pektaluꞌ dini Isus, “Sir, sumakupu diniꞌa. Laak saꞌ mesuꞌat, buang mu dinaan, megudas pau deliꞌ tu nga gapen ku.” ");
INSERT INTO syb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Kaliꞌ pelum sembag si Isus diniin, “Paa, adin su getaw mekpuun megdaru, dayun peglingay peglingay tu teliudanen, kiin, kanaꞌ mbantang megabang tu Keglekaunutan nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Mendadi tubus nitu, duun pa paduni tinduꞌ nu Kaunutan pitu puluꞌ buꞌ duaꞌ tawan, sinuguꞌen ilan meguna diniin pigdeduaꞌ tawan, adun tukiden nilan laaway su ngag lunsud maikaꞌ saꞌ gembagel, adin su sungunen dadema laaway. ");
INSERT INTO syb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Miktaluꞌ si Isus di nga sakupen, “Naa ki sengkuꞌ, gembagel gupia sia, laak meliang dai getaw meglegani dun. Kaas penenebi amu tu Megbebayaꞌ, su gapuꞌ nu sengkuꞌ, adun suguꞌenen pai ngag duma getaw meglegani. ");
INSERT INTO syb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mendadi,” maaꞌ laung pa ni Isus, “panaw namu! Dagid pektalentenay niu ini. Ki kesuguꞌu diniu mpanaw, petanggiꞌu amu di karniru mingingelet di nga mendapaꞌ dun. ");
INSERT INTO syb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Naa ndaꞌi uiten niu pitaka, saꞌ gambag, pia sepatus. Mukaꞌ ndiꞌ amu melangan megabitabit dig dalan. ");
INSERT INTO syb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Adin sug bekna balay mekpepenaik diniu, udasay niu su getaw dun. Taluꞌ niu, ‘Pepianani nga getaw dini.’ ");
INSERT INTO syb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Dayun su getaw dig balay kia, saꞌ pangay tu tantu kepia, naa mpianan tuꞌu. Laak saꞌ kanaꞌ pangay tu kepia, ndiꞌ dadema mpianan. ");
INSERT INTO syb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Naa kig balay kia pepenaiken amu dun, ditu laak amu tuun. Adin su gikteb ilaken nilan diniu, aan niu, mukaꞌ su painum diniu, inum niu dadema. Puꞌ ki getaw megabang di ngag dumanen, mbantang gestuan di kaꞌaanen. Mukaꞌ ndiꞌ amu peglelegalin dig lain. ");
INSERT INTO syb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Naa pia adinig lunsud medetengan niu, dayun penembaꞌen amu dun, naa pia alanduni ilaken diniu dia, ndiꞌ amu mekalangalang maan dun. ");
INSERT INTO syb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pauliꞌay niu su nga megladu dig lunsud kia, mukaꞌ taluꞌ niu dinilan, ‘Mesempel na diniu su Keglekaunutan nu Megbebayaꞌ.’ ");
INSERT INTO syb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Adin sug lunsud medetengan niu, dayun ndiꞌ menembaꞌ diniu, naa angay amu diag duuni tebuꞌan dun, pektaluꞌ amu, ");
INSERT INTO syb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Paa, pia sug lepup lupaꞌ mineket di geksud nami, punasen nami, adun metakesiꞌanig lunsud kini. Laak talentenay niu ini, mesempel na diniu su Keglekaunutan nu Megbebayaꞌ!’” ");
INSERT INTO syb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Diksuꞌ ni Isus su taluꞌen, “Taman taluꞌu diniu, saꞌ mateng su Gendaw nu Kengukum nu Megbebayaꞌ di tibaꞌan getaw, tumuꞌ megaan pai ginukuman tug lunsud Sodoma kitu, sabayaꞌ di ginukuman tug lunsud kia ndiꞌ menembaꞌ diniu!” ");
INSERT INTO syb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kaliꞌ pektaluꞌ si Isus, “Paa, yamu pa di nga getaw Corasin mukaꞌ getaw Betsaida, mekelelaatlelaat amu! Puꞌ su nga mekesalebuꞌ pinggulaulau dig lunsud niu, saꞌ pinenggiꞌ ditu mipenggulaula Tiro mukaꞌ Sidon dengantu, aba, su nga getaw ditu, migdedaliꞌ ilan sia memekseluk saku dakus meglebug gabu dig lawas nilan, tuꞌus tu kegbiksuꞌ nilan sia tu salaꞌ nilan! ");
INSERT INTO syb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kaas saꞌ mateng ki Gendaw nu Kengukum nu Megbebayaꞌ di tibaꞌan getaw, tumuꞌ megaan pa su ginukuman di nga getaw Tiro mukaꞌ Sidon kitu, sabayaꞌ di ginukuman diniu. ");
INSERT INTO syb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mukaꞌ yamu dadema di nga getaw Capernaum! Petaasen ma niu siai tindeg niu, sampay medepet amu ditu gekbus langit? Baa, lebuꞌen amu tug linaw gapuy!” ");
INSERT INTO syb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Laung pa ni Isus tu nga sakupen, “Adini mekineeg diniu, iin dademai mikineeg dinaan. Adini memilas diniu, iin dademai mimilas dinaan. Mukaꞌ adini memilas dinaan, mipemilasen dadema su suminuguꞌ dinaan.” ");
INSERT INTO syb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Naa ki pitu puluꞌ buꞌ duaꞌ tawan kiin sinuguꞌ ni Isus mpanaw, mipuliꞌ ilan ditu niin, pinleliag ilan gupia. Kaliꞌ ilan pektaluꞌ, “Aa naa, Sir, pia su menenulay, masiꞌ daagen nami, sabaꞌ nu pegbayaꞌ mu!” ");
INSERT INTO syb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Kaliꞌ sumpat si Isus, “Waꞌa daan. Naa kiin, iin su minitaꞌu mitekaw melabuꞌ si Satanas genat tug langit, maaꞌ nu kelabuꞌ nug letiꞌ. ");
INSERT INTO syb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Puꞌ metuud lai daan, bigayan ku amu pegbayaꞌ adun maindegan niui nga mamak atawaka nga gulangulang, dakus daagen niu su gikteb pegbayaꞌ nu Kuntra ta, di ndiꞌ damu mekendutaꞌ dun. ");
INSERT INTO syb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Laak dagid pia maꞌantu, kanaꞌ laak iini pegleliag amu dun, su kedaag niu tu menenulay. Segaga iini pegleliag amu dun, su kepeduma nu ngalan niu mesulat tu nga ngalan nu suminakup ditu gekbus langit.” ");
INSERT INTO syb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Naa mitaang dun, liliag patiꞌ si Isus, sabaꞌ nug Balakat nu Megbebayaꞌ. Kaliꞌ pektaluꞌ si Isus, “Mikpaladpaladu diniꞌa, Amaꞌ, yaꞌai Kaunutan di gekleb langit buꞌ lupaꞌ. Puꞌ su tantu sinuunan kini, iglud mu tu nga getaw metaasi sinuunanen, puꞌ iin laaki pisuunan mu dun, ki nga getaw kini maikaꞌi sebutenen. Naa melengas da, Amaꞌ, puꞌ maꞌnia dai miuyaꞌan mu.” ");
INSERT INTO syb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Laung pa padun ni Isus, “Sug lumaun metuud, migelaꞌ pegwakil dinaan nu Gamaꞌu. Naa naan kini, kig Bataꞌen, ndaꞌiduni mekesuun dinaan, subay su Gamaꞌu laak. Mukaꞌ su Gamaꞌu, ndaꞌidun dademai mekesuun diniin, subay naan laak kini, kig Bataꞌen, sampay adin laaki getaw mauyaꞌan ku pesuunan ku dun.” ");
INSERT INTO syb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Mendadi, minadap si Isus dia nga sakupen, kaliꞌ pektaluꞌ dinilan, ilan da laak, “Naa, yamu, liliag amu tantu, sabaꞌ nu minitaꞌ niu kini! ");
INSERT INTO syb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Puꞌ taman taluꞌu diniu, melaun pimuunan nu Megbebayaꞌ mukaꞌ gadiꞌ, taginaa nilan dun sia maitaꞌ nilan ki minitaꞌ niu kini, dagid ndaꞌ nilan maitaꞌ. Taginaa nilan dun pagid medengeg nilan ki midengeg niu kini, dagid ndaꞌ nilan dadema medengeg.” ");
INSERT INTO syb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mendadi, duuni mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ minadap dini Isus, puꞌ adun pengimanenen sia su metaluꞌen. Suminaak dini Isus su mekpetuꞌun, “Naa Sir, taꞌ alandun mai gempia penggulaulaan ku adun mpedumau tu ketubuꞌ ndaꞌi tamanen?” ");
INSERT INTO syb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Kaliꞌ sembag si Isus, “Naa, taꞌ alanduni misulat ditu Palinta nu Megbebayaꞌ? Taꞌi kesabut mu dun?” ");
INSERT INTO syb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Kaliꞌ sembag su mekpetuꞌun di Palinta, laungen, “Kini. Saladuaꞌ diniu, petail mu tantu su Kaunutan mu Megbebayaꞌ, saꞌitada pegwakil mu diniin su tibuuk ginaa mu mukaꞌ su tibuuk gimuud mu dakus su gikteb sekeg mu sampay su tibuuk delendeman mu. Mukaꞌ pa pagid, petail mu dadema sug duma mu. Su kepetail mu diniin, pelepeng mu di kepetail mu dig lawas mu.” ");
INSERT INTO syb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Laung dayun ni Isus, “Aa naa, misugatan mu gupiai sembag mu kiin. Kiai penggulaula mu, adun mpedumaa tuꞌu tu ketubuꞌ ndaꞌi tamanen.” ");
INSERT INTO syb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Laak su mengiman sia dini Isus kia, mpauk daagen. Kaas sinaaken na pelum dini Isus, “Asa taꞌ adin dunig dumau petailen ku?” ");
INSERT INTO syb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Kaliꞌ sembag si Isus, “Naa, maꞌniniꞌ. Duuni getaw mipanaw, pegdiksun pangay tu Jerico genat ditu Jerusalem. Naa selian pekpanawi getaw kini, inapaꞌ tulisan. Libasan nu tulisan, bintul nilan padun, dayun nilan belengay, simaꞌan nilan ginaa maikaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Naa mendadi mitaang dun, duuni minian diag dalan kia belian nu getaw Judea. Sug belian, benaꞌ minitaꞌeni tinulis kini, migliaw laak diag dipag dalan, minundas. ");
INSERT INTO syb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Benaꞌ ndaꞌ maiben, duun pelumi sala tawan sapuꞌ ni Levi minian dadema dia. Benaꞌ minitaꞌ nu sapuꞌ ni Levi su tinulis, maꞌnia dadema, migliaw laak pelum diag dipag dalan, minundas dadema. ");
INSERT INTO syb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Laak dagid, duuni getaw Samaria mipanaw, mituaꞌ dadema dia. Iin, benaꞌ minitaꞌen su tinulis, milelaat dun. ");
INSERT INTO syb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Mikpesempel dayun diniin mukaꞌ binulungen penginumen buꞌ lana su ngag banegen, igbeden pa pagid. Dayunen pesakay tu petubuꞌenen, inateden di pektulugan nu nga getaw, tinagikulen dia. ");
INSERT INTO syb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Benaꞌ migendaw, migbegay duaꞌ denario tu gapuꞌ nu pektulugan kia, laungen, ‘Saꞌ mesuꞌat, yaꞌai pegibaꞌ dun. Adin su kulang nu gastu dun, biadan ku da diniꞌa saꞌ mpuliꞌu dini.’” ");
INSERT INTO syb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Benaꞌ mideksuꞌ ni Isus su sambingayen, sinaakanen dayun su mengiman sia diniin di taluꞌen, “Naa taꞌ ma, alandunig delendeman mu? Ki telu tawan kia, adin ma dinilani mibaal gitunganen duma nu inapaꞌ tulisan kia?” ");
INSERT INTO syb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Simbag nu mekpetuꞌun di Palinta, “Su milelaat diniin.” Laung ni Isus diniin, “Naa yaꞌa, penunggilingay mu dadema.” ");
INSERT INTO syb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Naa sabaꞌ ni nga Isus mpanaw, midepet ilan dig lunsud. Naa duunig libun dia, ngalanen si Marta, pinembaꞌen si nga Isus ditug balayen. ");
INSERT INTO syb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Naa duuni pated ni Marta, ngalanen si Maria. Benaꞌ sumiled tug balay su Kaunutan, kini si Maria, migingkud di gedapanen, adun pektalentenanen su teluꞌenen. ");
INSERT INTO syb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Si Marta pelum, milibuleng patiꞌ tu pegulingelenen, puꞌ melaun gupia. Mendadi, linabet ni Marta si Isus, laungen, “Naa, Sir, petuyangen mau masiꞌ, salau laak megilak, ndiꞌ megabangi ngudan ku kiin? Melengas sia teluꞌen mu diniin, megabang dinaan!” ");
INSERT INTO syb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kaliꞌ sembag su Kaunutan, “Ay, yaꞌa Marta, kelibuleng mu gupiai melaun baalen mu kiin! ");
INSERT INTO syb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Segaga salabuuk laaki talentenan nu getaw, gembageli gatagen. Tumuꞌ kiin, ki piktalentenan ni Maria, ki ndiꞌ na mawiꞌ diniin.” ");
INSERT INTO syb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Mendadi duuni gendaw, menenabi si Isus. Benaꞌ mitubus, kaliꞌ pektaluꞌi sala tawan sakupen, “Sir, saꞌ mesuꞌat, pektuꞌunay mu ami menenabi, maꞌniin ni Juan kiin, piktuꞌunanen dadema su nga sakupen.” ");
INSERT INTO syb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Kaliꞌ pektaluꞌ si Isus, “Naa saꞌ menenabi amu, kiniig bian nu kenenabi niu. Iini taluꞌ niu, ‘Uu Amaꞌ nami, melengas pegbesaan ka nu nga getaw puꞌ yaꞌa su Megbebayaꞌ. Melengas pekpuunan na su Keglekaunutan mu. ");
INSERT INTO syb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Begayay mu ami gendawgendaw di nga gaan nami, sukal di ketubuꞌ nami. ");
INSERT INTO syb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pedasun mu ami di nga salaꞌ nami, puꞌ yami, mekpedasun ami dadema tu taman mekesalaꞌ dinami, mukaꞌ ndiꞌ mu buangay mpenulay ami.’” ");
INSERT INTO syb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Mendadi, miksambingay si Isus, laungen, “Naa pinenggiꞌ sala tawan diniu, mangay tug balay nu sambaten meginengaꞌi gebii, teluꞌenen dayun, ‘Uu Sambat, saꞌ mesuꞌat, pautang mau telu buuk pan. ");
INSERT INTO syb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Puꞌ duuni sala sambatu minateng ditu naan, melayuꞌi pigenatanen! Naa ndaꞌidun pelumi ilaku dun!’ ");
INSERT INTO syb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Dayun sumbag su sambaten dia seled, ‘Aa, ndiꞌ mu semukayi tulugu! Siniraan naig balayu. Migbelilid nai nga gembataꞌu, sampay naan. Kaas ndiꞌu mesuꞌat megbuat megbegay diniꞌa.’” ");
INSERT INTO syb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Maaꞌ laung pa ni Isus, “Naa, taꞌ ma dayuni mpenggulaula? Taluꞌu tuꞌu diniu, ki sambaten kia, pia mpauk megbuat megbegay diniin puun tu kesambat nilan, laak metegelan da gusay megbuat dakus megbegay tu kelaun kulang diniin, saꞌ su menengi, ndiꞌ lumukas menengi diniin. ");
INSERT INTO syb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kaas pesamau dademai teluꞌen ku diniu. Penamal amu menenabi tu Megbebayaꞌ, begayan amu niin. Penamal amu menengaw, puꞌ mekebaang amu. Peksabi amu namal diag bisuangan, puꞌ pukaꞌan amu tuꞌu. ");
INSERT INTO syb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Puꞌ adini menamal menenabi, begayan tuꞌu. Adini menamal menengaw, mekebaang, mukaꞌ adini meksabi diag bisuangan, mpukaꞌan. ");
INSERT INTO syb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Puꞌ yamu ngag duunig bataꞌen, duun bai sala tawan diniu, saꞌ pinenggiꞌ menengi sedaꞌig bataꞌen, begayen sungkin diniin mamak? ");
INSERT INTO syb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Atawaka saꞌ meksaak gumanuk, begayen pelum diniin gulangulang? ");
INSERT INTO syb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mendadi yamu, saꞌ metau amu megbegay kepianan tu gembataꞌ niu, asa melaat getaw laak amu, naa labi na su Gamaꞌ niu ditu gekbus langit, pepengapuꞌen dema tuꞌu kig Balakat nu Megbebayaꞌ tu nga meksaak dun diniin!” ");
INSERT INTO syb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Naa duuni getaw beed, sabaꞌ silunuꞌan menulay. Inutidan ni Isus su migleget dun. Benaꞌ miutidanen su menulay, mikektaluꞌ puliꞌ sug beed. Misebuꞌan dayun su nga getaw dia. ");
INSERT INTO syb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Laak laung nug duma getaw, “Aa, ki getaw kiin, iini megaganen dun utidayi menenulay, puꞌ bigayan ginuung ni Beelsebul, su kaunutan nilan.” ");
INSERT INTO syb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Naa sug duma getaw pelum, pengimanan nilan sia si Isus, kaas miksaak ilan diniin mekesalebuꞌ tuꞌus, adun gempantek daw puꞌ genat tu Megbebayaꞌ su pegbayaꞌen. ");
INSERT INTO syb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Laak misuunan ni Isus sug delendeman nilan. Kaliꞌ pektaluꞌ dinilan, “Adin su nasud meksimawiꞌ mukaꞌ megunay megbunuꞌ, ndiꞌ maiben metulag. Samanen ki salapenan, saꞌ meksimawiꞌ mukaꞌ meksual, metulag dadema. ");
INSERT INTO syb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Naa, maꞌantu dadema si Satanas. Saꞌ pinenggiꞌ meksimawiꞌ su peglegediꞌanen dayun megunay megbunuꞌ, ndiꞌ ba metulag, deksuꞌanen mbeleng? Asa teluꞌen niu pengutidan ku su menenulay puun nu pegbayaꞌ ni Beelsebul. ");
INSERT INTO syb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Keduaꞌen, saꞌ sia metuud puꞌ genat dini Beelsebuli pegbayaꞌu mengutid dun, naa su nga sakup niu pelum, adin ba genat su pegbayaꞌ nilan? Puꞌ ilan, utidan da nilan demai menenulay. Baa, mitakesil amu nu pinggulaula nu nga sakup niu! ");
INSERT INTO syb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Laak dagid saꞌ iin pasiꞌi migbegay dinaan pegbayaꞌ mengutid dun su Megbebayaꞌ, naa maꞌananen, mituaꞌ na diniu su Keglekaunutan nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Laung pa pagid ni Isus, “Kig letaban getaw, saꞌ meksangkap na besi dayun iin da gupiai megingat tug balayen, naa ndiꞌ sia magaw su pimetangen. ");
INSERT INTO syb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Laak pia maꞌantu, saꞌ duuni mateng lumabaw pa dun diniin, iin pelumi dumaag. Egaunen dayun su kelaun besi seligan nu gapuꞌ balay, dakus su kelaun gimunen, pekilasenen dayun tu ngag dumanen.” ");
INSERT INTO syb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Miktaluꞌ padun si Isus, laungen, “Adini getaw kanaꞌu sugut, iini kuntrau. Adini ndiꞌ megabang dinaan mekpungun sakupu, iini mekpelak dun.” ");
INSERT INTO syb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Kaliꞌ pektaluꞌ si Isus, “Mendadi su menulay, saꞌ utidan di getaw, leepenen dayunig benwa ndaꞌi tubig dun menengaw pelelianen. Naa benaꞌ ndaꞌiduni mbaanganen, maaꞌ laungen dig dialem delendemanen, ‘Tumuꞌ muliꞌ nau ditug balay kia pigenatan ku.’ ");
INSERT INTO syb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Naa benaꞌ mateng puliꞌ tug balay kia, aba, metaanganen siniligan na sug balay dakus pingikpesan. ");
INSERT INTO syb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Saꞌ maꞌantu, mangay dayun dumanen menenulay pitu buuk, melaat pa dun diniin, dayun megelaꞌ ilan muliꞌ dia. Kaas deksuꞌanen, su kebetang nu getaw kia piglegetan salabuuk da sia menulay, melaat pa tug bekna mipenggulaulanen.” ");
INSERT INTO syb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Naa selian ni Isus mektaluꞌ, duunig libun dia tebenan getaw minekeg mektaluꞌ dini Isus, laungen, “Sug libun minataꞌ diniꞌa mukaꞌ mikpeduduꞌ diniꞌa, liliag tantu!” ");
INSERT INTO syb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kaliꞌ pektaluꞌ si Isus, “Tumuꞌ su getaw mekedengeg di taluꞌ nu Megbebayaꞌ dakus mekpetuud dun, iin tantu gupiai liliag!” ");
INSERT INTO syb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Mendadi benaꞌ pekpungunpungun su nga getaw mekpesempel dini Isus, kaliꞌ pektaluꞌ si Isus, “Paa, yamu pa di nga getaw nemun, medupang amu gupia! Penengiin niu dinaani mekesalebuꞌ tuꞌus, asa daal da laaki tuꞌus begay diniu, ki maaꞌ nu mipenggulaula nu pimuunan nu Megbebayaꞌ dengantu si Jonas. ");
INSERT INTO syb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Puꞌ si Jonas, mibaal tuꞌus tu getaw Ninibe. Naa naan kini kig Bataꞌ nu Kilawan, maꞌantu dadema, mbaalu tuꞌus diniu nga getaw nemun. ");
INSERT INTO syb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Dayun sug Bai tug benwa Seba dengantu, mbantang megindeg tumakesil diniu saꞌ mateng su Gendaw nu Kengukum nu Megbebayaꞌ di tibaꞌan getaw. Puꞌ daniin, miktegel mpanaw dinig benwa ta Israel, melayuꞌ gupia dig benwanen, puꞌ adun mekineeg ditu telisebuten tituluꞌan ni Adiꞌ Salomon. Naa yamu kiin, duun kinii mituaꞌ diniu, metaas pa dini Salomon. ");
INSERT INTO syb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mukaꞌ saꞌ mateng na tuꞌu su Kengukum, naa su nga getaw pa pagid dengantu sakup Ninibe kitu, mbantang dailan dema megindeg tumakesil diniu nga getaw nemun. Puꞌ maꞌantu dadema ilan, saꞌ tinituluꞌan ilan ni Jonas, miksikesuun ilan. Mendadi yamu, taman taluꞌu diniu, duun kinii mituaꞌ diniu, metaas pa dini Jonas!” ");
INSERT INTO syb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Mendadi kaliꞌ pektaluꞌ si Isus, “Ki suluꞌ, ndiꞌ tutudan dayun egluden nu getaw, mesama ndiꞌen ukluban bandi. Segaga betangen dig dempaꞌan, adun medelaganen su nga getaw suled tug balay. ");
INSERT INTO syb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Naa su mata niu, iini suluꞌ nug lawas niu. Kaas saladuaꞌ diniu saꞌ pinenggiꞌ gempiai mata mu, naa medelagan na su tibuuk lawas mu. Laak dagid saꞌ duuni mesait di mata mu, naa medeleman dademai tibuuk lawas mu. ");
INSERT INTO syb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kaas peglengilama, tekaw mbuus sug laung mu dun tiag mu, masiꞌ medelem. ");
INSERT INTO syb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Laak saꞌ meleep dig lawas mu ki medelag, ndaꞌiduni medelem dun, naa maꞌantu, lumbus medelag, maꞌniin mitiagan ka suluꞌ.” ");
INSERT INTO syb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Naa benaꞌ mideksuꞌ megukit si Isus, duuni Pariseo migenggat diniin maan tug balayen. Saꞌ maꞌnia, minangay dema dia si Isus, migingkud dayun maan. ");
INSERT INTO syb_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Laak saꞌ minaan si Isus, misebuꞌan su Pariseo, kaliꞌen maitaꞌ puꞌ ndaꞌ ni Isus pegelaꞌ dunutay sug bian mengingenaw tinituluꞌ nu nga Pariseo tu nga getaw. ");
INSERT INTO syb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Dagid kaliꞌ pektaluꞌ su Kaunutan, “Paa, yamu pa di nga Pariseo, ugasan niu sug dibabaw nu pinggan niu mukaꞌ tasa niu, laak dagid dig dialem, mipenuꞌ amu nu pingagaw niu puun di melaat betad niu. ");
INSERT INTO syb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Benguꞌbenguꞌen amu! Su Megbebayaꞌ miwat tug lawas nu getaw, kanaꞌ bain da gusayi miwat tug delendemanen? ");
INSERT INTO syb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Segaga peglegamut amu tu pubri, adun melimpiu amu tantu, saꞌitada mekesuun amu.” ");
INSERT INTO syb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Laung pa ni Isus, “Yamu pa di nga Pariseo, mekelelaatlelaat amu! Puꞌ pia su mekaikaꞌ pimula niu sampay su gininisan pegdaut, naa begay niu tu Megbebayaꞌ su kesepuluꞌ ilasen. Dagid ki melegdeng betad mukaꞌ ki kepetail niu sia tu Megbebayaꞌ, baa, ndaꞌ dig delendeman niu. Asa kiin siaig bantang pegbetaden niu, sampay su ngag duma pinalinta pa pagid. ");
INSERT INTO syb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Yamu nga Pariseo, mekelelaatlelaat amu daan! Puꞌ saꞌ ditu simbaan ta, liagan niu su tampusan metaas gingkudan. Saꞌ ditu amu pelum tebuꞌan, mauyaꞌan niu pegbesaan amu nu nga getaw. ");
INSERT INTO syb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mekelelaatlelaat amu dema tuꞌu! Puꞌ pitanggiꞌu amu di ngag lebeng ndaꞌi tuꞌus dun, maindegan laak nu getaw, puꞌ ndaꞌ nilan suunay puꞌ masiꞌ lebeng itu, kanaꞌ mpia.” ");
INSERT INTO syb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Naa mendadi, duuni mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, kaliꞌ sumpat, “Naa Sir, saꞌ maꞌniai teluꞌen mu, pepiidpiidan mu dami dema!” ");
INSERT INTO syb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kaliꞌ sembag si Isus, “Waꞌa lai! Yamu nu nga mekpetuꞌun di Palinta, mekelelaatlelaat amu dadema! Pipisan niu gembegat tituluꞌan tu nga samataw niu, asa yamu, ndiꞌ niu tanan etateni salabuuk tu nga tenduꞌ niu meguit tu guiten nilan kia. ");
INSERT INTO syb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mekelelaatlelaat amu daan! Puꞌ su ginepuꞌay niu, binunuꞌ nilan su nga pimuunan nu Megbebayaꞌ dengantu. Yamu dadema, migbaal amu melengas lebeng tu nga pimuunan kitu. ");
INSERT INTO syb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Naa saꞌ maꞌantu, mitakesiꞌan niu su kesanguꞌ niu tu melaat gulaula kia nu nga ginepuꞌay niu. Puꞌ su ginepuꞌay niui mimunuꞌ dun, dayun yamui migbaal melengas lebeng nilan. ");
INSERT INTO syb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kaas maꞌniniꞌi tinaluꞌ nu Megbebayaꞌ, genat di ketelisebutayen, ‘Suguꞌen ku dinilani nga pemuunan ku mukaꞌ peneligan ku. Dagid sug duma, peglegetan pa nilan. Sug duma pelum, petain nilan.’” ");
INSERT INTO syb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kaliꞌ padun pektaluꞌ si Isus, “Naa kagina maꞌantu, yamu pa di getaw nemun, melabuꞌ tuꞌu diniu su ginukuman tu kekpatay ditu kelaun pimuunan nu Megbebayaꞌ, genat pa kebuat di gekleb langit buꞌ lupaꞌ ");
INSERT INTO syb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","sampay tu kekpatay dini Abel dakus su kebunuꞌ dini Zacarias, su pinatay kia ditug Balay Pengedapan tu Megbebayaꞌ, dia gelet nu gentudan gilak mukaꞌ su Meꞌelig Sugud. Taman taluꞌu diniu nga getaw nemun kini, melabuꞌ tuꞌu diniu su ginukuman tu kelaun kemunuꞌ kitu!” ");
INSERT INTO syb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Laung pa padun ni Isus, “Mekelelaatlelaat amu dema tuꞌu, yamu nu nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ! Puꞌ inawiꞌ niu su gunsiꞌ mekepukaꞌ tu metuud, mukaꞌ inapaꞌ niu su nga getaw suled sia, dagid yamu, ndaꞌ damu dema seled!” ");
INSERT INTO syb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Naa selian ni Isus megawaꞌ dia, pigbensi nu nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ mukaꞌ su nga Pariseo. Piglantugiꞌan nilan gupia, ");
INSERT INTO syb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","pengepaꞌan nilan siai taluꞌen, adun metaban nilan sia si Isus di teluꞌenen. ");
INSERT INTO syb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Naa selian ni Isus megukit, kanaꞌ da dun santaꞌ ngibu tawan nga getaw mikpungunpungun diniin, diadia maindeganenig dumanen. Mendadi, inuna ni Isus tituluꞌay su nga sakupen, laungen, “Peglengilamay niu su petulin nu nga Pariseo di pan, saꞌitada kig betad nilan tautau mekesuun. ");
INSERT INTO syb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Puꞌ ndaꞌiduni tibunan nemun, ndiꞌ mbuasan. Ndaꞌiduni giglud nemun, ndiꞌ dema mesuunan. ");
INSERT INTO syb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kaas adin su tinaluꞌ niu di meleglud, medengeg pa tu gedapan. Adin su kimed niu dig dialem sugud, mpegukit tu tebuꞌan.” ");
INSERT INTO syb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Kaliꞌ gusay pektaluꞌ si Isus, “Taman taluꞌu diniu nga sambatu, ndiꞌ niu endekayi sama kilawan niu, puꞌ daal da laaki megaganen petayay, sug lawas nu getaw. ");
INSERT INTO syb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Segaga pesuun ku diniu ki gempia niu endekan. Iin laaki gempia endekan niu, su Megbebayaꞌ, kig duuni pegbayaꞌen mekpatay di getaw, mukaꞌ pa padun megbeleng dun ditug linaw gapuy. Iin dema tuꞌui endekay niu, su Megbebayaꞌ!” ");
INSERT INTO syb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Laung pa ni Isus, “Naa pegdelendem niu deliꞌ su manukmanuk. Lima buuk leksayaw, ndiꞌ ba mesaluy duaꞌ laad siin? Laak pia maꞌantu, ndaꞌi salabuuk dun ndiꞌ eklungan nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Yamu pelum, pia kig buuk di gulu niu, misuunan da nu Megbebayaꞌ saꞌ santaꞌ balu. Kaas ndiꞌ amu mendek, puꞌ gembagel gupiaig lagaꞌ niu tu Megbebayaꞌ, sabayaꞌ nu nga manukmanuk!” ");
INSERT INTO syb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Kaliꞌ pektaluꞌ si Isus, “Kini pagidi taluꞌu diniu, adin su getaw kanaꞌ mpiid meglegintuud di gedapan nu nga getaw puꞌ suminakup dinaan nug Bataꞌ nu Kilawan, naa naan, engkenen ku dadema iin ditu gedapan nu nga sesuguꞌen nu Megbebayaꞌ getaw langit. ");
INSERT INTO syb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Adin demai memalaw di gedapan nu getaw puꞌ kanaꞌ sakupu iin, naa pemelaun ku dadema iin ditu gedapan nu nga getaw langit. ");
INSERT INTO syb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Adin pagidi getaw meksudiꞌ dinaan kig Bataꞌ nu Kilawan, pedesunen da dun. Dagid adin su getaw peksudiꞌanen sug Balakat nu Megbebayaꞌ, ndiꞌ na pedesunen.” ");
INSERT INTO syb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Laung pa ni Isus, “Mendadi saꞌ dengaten amu ditu nga simbaan nu getaw Judea, mesama tu gedapan nu nga gukum buꞌ kaunutan, naa ndiꞌ amu melibuleng saꞌ taꞌ alandun mai gempia niu sembag dun. ");
INSERT INTO syb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Puꞌ saꞌ dengaten namu, iin na gupiai mektituluꞌ diniu tu gempia sembag niu dun, sug Balakat nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Naa mendadi, duuni sala tawan dia nga melaun getaw, laungen dini Isus, “Naa Sir, saꞌ mesuꞌat, taluꞌ mu tu gulangbataꞌu, ilasanu dun su pusakaꞌ nami.” ");
INSERT INTO syb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Kaliꞌ sembag si Isus, “Baa lai, laung mu dun tinduꞌu gukum niu mekilas pusakaꞌ diniu?” ");
INSERT INTO syb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kaliꞌ dayun pektaluꞌ si Isus tu nga getaw, “Petubud amu, peglengilamay niu ki mesaku amu, pia taꞌ alanduni mesaku amu dun sia. Puꞌ su tantu ketubuꞌ nu getaw, ndaꞌig labeten dun su pimetangen, maikaꞌ saꞌ melaun.” ");
INSERT INTO syb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Migbaal dayun si Isus penenggiꞌan dun, laungen, “Duuni medatuꞌ getaw, singkuꞌan gupia. ");
INSERT INTO syb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kaas dialem ginaanen, ‘Naa, kendutaꞌen ku ma duni sengkuꞌu kini? Sabaꞌ kelaunen, ndaꞌidun naig betangan ku dun.’ ");
INSERT INTO syb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kaliꞌ pegleketau, laungen, ‘Aa naa, pemaꞌniniin ku. Tulagen ku su ngag bengelan ku, puꞌ baalen ku puliꞌ ki gembagel pa padun, diaan ku na penteguꞌayi sengkuꞌu sampay su nga pimetangu. ");
INSERT INTO syb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Dayun teluꞌen ku dig delendeman ku, Aa naa, melaun na mitaguꞌu, sukal da di santaꞌ taun! Mesuꞌat na melaliu, maan laak, meginum, mukaꞌ meglekebibu!’ ");
INSERT INTO syb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Laak dagid miktaluꞌ diniin su Megbebayaꞌ, ‘Benguꞌbenguꞌen ka getaw! Gebii kini, matengi gumul mu. Dayun ki kelaun ginandam mu kiin, taway dun mai malap dun?’” ");
INSERT INTO syb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Diksuꞌ ni Isus su sambingayen, laungen, “Mendadi, maꞌnia su getaw mektimud gaꞌus kinilawan, laak di pegitaꞌen nu Megbebayaꞌ, gempusuk da.” ");
INSERT INTO syb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Naa pidayun gusay sumpatay ni Isus su taluꞌen tu nga sakupen, “Kaas taluꞌu diniu, ndiꞌ niu libulengayi ketubuꞌ niu, saꞌ taꞌ ma saani aanen niu. Dakus ndiꞌ niu dadema libulengay sug lawas niu, saꞌ taꞌi kenapet niu. ");
INSERT INTO syb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Puꞌ su ketubuꞌ nu getaw, gembageli pantagen sabayaꞌ nu kaꞌaanen. Sug lawas nu getaw, gembagel dademai pantagen, sabayaꞌ nu kenapeten. ");
INSERT INTO syb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mukaꞌ pegdelendem niu pagid su nga guak. Su guak, ndiꞌ memula, ndiꞌ dadema meglegani, ndaꞌidun tananig bengelanen. Laak pia maꞌantu, paanen da nu Megbebayaꞌ su guak! Naa kanaꞌ ba labi pamu paanen, ki metaas pa tananig lagaꞌ niu, sabayaꞌ nu nga manukmanuk? ");
INSERT INTO syb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Keduaꞌen, duun bai sala tawan diniu, megaganen petaasayi gumulen sendaw pebian di kelibulengen dun? ");
INSERT INTO syb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Naa saꞌ ndiꞌ niu megagai maikaꞌ kia, alandun bai malap niu saꞌ melibuleng amu dig duma ketubuꞌan niu? ");
INSERT INTO syb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mukaꞌ pegdelendem niu pagid sug bulak nu sigbet. Ndiꞌ mengimbaal su sigbet, ndiꞌ dadema megabel. Laak taluꞌu diniu, pia si Adiꞌ Salomon, saꞌ migimakay gupia, ndaꞌi salabuuk bulak sigbet, kanaꞌ melengas pa di kenapet ni Salomon kitu. ");
INSERT INTO syb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Naa su sigbet, maitaꞌ nandaw, lemaꞌ mbaluy laak tagun. Laak pia maꞌantu, begayan nu Megbebayaꞌ pekayanen su sigbet, saꞌitada sug bulaken. Saꞌ maꞌantu, kanaꞌ bamu labi na begayan nu Megbebayaꞌ penepeten niu? Kaas mauma dema maikaꞌ da ki kesalig niu tu Megbebayaꞌ?” ");
INSERT INTO syb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Diksuꞌ ni Isus su taluꞌen, “Kaas ndiꞌ mbagel dig delendeman niu ki kaꞌaan niu buꞌ kainum niu, mukaꞌ ndiꞌ amu melibuleng dun. ");
INSERT INTO syb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","(Puꞌ su nga kanaꞌ mekpetuud dinig dibabaw lumbang, gembagelig delendeman nilan dun.) Yamu pasiꞌ, misuunan nu Gamaꞌ niu su kelaun kulang di sukat niu. ");
INSERT INTO syb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Segaga iini pebagel niu dig delendeman niu, ki kesakup niu tu Keglekaunutan nu Megbebayaꞌ. Saꞌ maꞌantu, su gininisan sukat, begay dadema nu Megbebayaꞌ diniu.” ");
INSERT INTO syb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kaliꞌ pektaluꞌ si Isus tu nga sakupen, “Naa yamu, pia maikaꞌi pikumpungan niu, ndiꞌ amu mendek. Puꞌ pigdelendem na nu Gamaꞌ niu, mpeduma amu tu Keglekaunutanen. ");
INSERT INTO syb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kaas su pimetang niu, peksaluy niu, mukaꞌ begay niu tu pubri su galinen. Saꞌ maꞌniai penggulaulaan niu, gitunganen, mikalap amu pitaka ndiꞌ na medanul, miktaguꞌ amu gimu ditu gekbus langit, ki gimu ndiꞌ mengkanan, ki ndiꞌ dadema mesempelan nu megdaaw, sampay ndiꞌ mesuꞌat aanen guled. ");
INSERT INTO syb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Puꞌ adin mibetang su gimu niu, ditu dademaig delendeman niu.” ");
INSERT INTO syb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Kaliꞌ pektaluꞌ si Isus, “Mendadi, pengandam amu, peginapet amu, ndiꞌ niu gusay pelengayi suluꞌ niu. ");
INSERT INTO syb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Iini penunggilingay niu, ki nga sesuguꞌen megelat tu gegalen nilan muliꞌ genat tug belaꞌi, adun mpukaꞌan nilan ganam saꞌ mateng na mukaꞌ meksabi. ");
INSERT INTO syb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Naa saꞌ metaangan nu gegalen saꞌ mateng, ndaꞌ ilan tulugay, naa penleliagen ilan gupia! Mukaꞌ taluꞌu tuꞌu diniu, su gegalen kia, megilis, dayun paingkudenen puꞌ maan ki nga sesuguꞌenen kia, iin masiꞌi megilak dinilan. ");
INSERT INTO syb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pia mateng di meginengaꞌi gebii, mesama da saꞌ daliꞌ endaw, saꞌ maꞌniai medetenganen, penleliagen su nga sesuguꞌen! ");
INSERT INTO syb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mukaꞌ pegdelendem niu pa pagidi gapuꞌ balay. Saꞌ pinenggiꞌ mesuunan pedaan nu gapuꞌ balay su kedateng nu getaw malap sia di pimetangen, ndiꞌ ba megenduk, adun ndiꞌ na sia mbegdakan sug dending nug balayen? ");
INSERT INTO syb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mendadi naan kini, kig Bataꞌ nu Kilawan, lumusadu puliꞌ di guras kanaꞌ niu pedetengen. Kaas pengandam amu gusay.” ");
INSERT INTO syb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Mendadi, sinaakan ni Pedro si Isus mekatag di sambingayen kia, laungen, “Naa Sir, yami ba laaki tituluꞌan mu dun, atawaka sug launan getaw?” ");
INSERT INTO syb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kaliꞌ sembag su Kaunutan, “Naa, adin su sesuguꞌen meseligan mukaꞌ telisebuten, iin dayuni pebiaꞌen nu gegalenen tu nga sama sesuguꞌenen, iini mekilas tu gaan nilan saꞌ matengi kegilas dun. ");
INSERT INTO syb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Saꞌ mateng su gegalenen mukaꞌ iini medetenganen, petuuden nu sesuguꞌen su sinuguꞌ diniin, naa leliagen su sesuguꞌen kia! ");
INSERT INTO syb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Taluꞌu diniu tuꞌu, saꞌ maꞌnia, pegwakil dayun nu gegalenen diniin su kelaunan pimetangen. ");
INSERT INTO syb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Dagid saꞌ dialem delendeman nu sesuguꞌen, ‘Aa, su gegalen ku, maiben pa dateng,’ kaas pesaitanen su nga sama sesuguꞌenen libun saꞌ laki mukaꞌ meksidalu maan, meginum, dakus megbebulek, naa saꞌ maꞌnia, taꞌ ma dayuni mpenggulaula? ");
INSERT INTO syb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Duuni gendaw metekaw muliꞌ su gegalenen di guras ndaꞌen pedetengay. Mendadi, silutan dayun patiꞌ nu gegalenen ki sesuguꞌenen kia, dayun pedumaay tu nga getaw ndiꞌ mekpetuud. ");
INSERT INTO syb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Adin su sesuguꞌen mesuunanen su mauyaꞌan nu gegalenen, laak ndiꞌ mengandam mukaꞌ ndiꞌ dadema mekpetuud, bedasen gupia. ");
INSERT INTO syb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Adin su ndiꞌen mesuunan su mauyaꞌan nu gegalenen, laak iini penggulaulaanen sug bantang badas, bedasen tuꞌu, laak ndiꞌ melebian. Adin su getaw melauni pegwakil diniin, melaun dademai saaken puliꞌ diniin. Dayun su getaw melaun pai pesalig diniin, labi na melaun dademai pedetengen diniin.” ");
INSERT INTO syb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Kaliꞌ pektaluꞌ si Isus, “Mendadi, iini luminusadu dun, puꞌ adun tutudan ku su tibuuk lumbang. Melengas sia migleket na! ");
INSERT INTO syb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mukaꞌ naan, duuni kelegenayu subay bunagen dinaan. Mibegatanu patiꞌ, sampay da dun di gendaw metubusu na bunagay dun! ");
INSERT INTO syb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Laung niu dun ba, iini luminusadu dun, puꞌ pesalabuuken kui getaw dinig dibabaw lumbang? Kanaꞌ maꞌantu! Taluꞌu tuꞌu diniu, iini mituaꞌu dun dini, meguitu sumpakiꞌ. ");
INSERT INTO syb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Puꞌ pinenggiꞌ lima tawani salapenan. Genat nandaw, meksumpakiꞌ ilan, telu tawan dig dibaluy, dayun dig dibaluy, duaꞌ tawan pelum. ");
INSERT INTO syb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Meksumpakiꞌ naig delendeman nu gamaꞌ mukaꞌ nug bataꞌlaki, maꞌnia dadema su ginaꞌ mukaꞌ sug bataꞌlibun, meksumpakiꞌ su penugangan libun mukaꞌ su minugangan dun libun.” ");
INSERT INTO syb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Naa miktaluꞌ si Isus tu melaun getaw, “Mendadi, saꞌ maitaꞌ niui medikpel megdelem diin dapit sindepan, laung niu dayun megdupiꞌ, megdupiꞌ daan tuꞌu. ");
INSERT INTO syb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mukaꞌ saꞌ mbatik niu dumuluki genus genat di gilidan gendaw, laung niu dayun, ‘Sungu memedes,’ memedes dayun. ");
INSERT INTO syb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Dagid tautau da lai amu mekesuun! Metau amu mengatuk tuꞌus dig benwa mukaꞌ dig langit, mauma ndiꞌ niu dadema maulug ki tuꞌus dig basa kini nandaw? ");
INSERT INTO syb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Mauma dema ndiꞌ amu memilang tu melengas sia penggulaulaan? ");
INSERT INTO syb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Saladuaꞌ diniu, saꞌ uiten ka nu duminangat diniꞌa tu pengukuman, penugaling mu iin pengamuyuꞌay, selian niu duaꞌ dia pa dalan pangay tu pengukuman. Puꞌ tekaw mbuus tegelen ka egakay tuꞌu tu kuis, dayun su kuis, pegwakila niin dayun tu pulis, dayun pirisuun ka nu pulis. ");
INSERT INTO syb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Taluꞌu tuꞌu diniꞌa, saꞌ maꞌnia, ndiꞌa na mekeguaꞌ tu pirisuan, subay megelaꞌ pa sia biaday su selaꞌan mu, ndiꞌ na engkanan, pia selaad siin.” ");
INSERT INTO syb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mendadi mitaang dun, duuni getaw migukit dini Isus puꞌ duuni nga getaw Galilea pipatay ni Gubirnadur Pilato, selian nilan mekanu. ");
INSERT INTO syb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Kaliꞌ sembag si Isus, “Naa kagina maꞌantui mibianan nu nga getaw kia, laung ba niu dun, gembagel pai salaꞌ nilan sabayaꞌ nug duma getaw Galilea? ");
INSERT INTO syb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kanaꞌ lai! Mendadi taluꞌu tuꞌu diniu, yamu pagid, saꞌ ndiꞌ amu meksikesuun, iini petayan niu, maaꞌ dadema dinilan. ");
INSERT INTO syb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Dayun ki sepuluꞌ buꞌ walu tawan kiin minatay dadema, puꞌ miulakan ilan nu metaas balay mibuksak ditu Siloe. Laung ba niu dun, gembagel pai salaꞌ nilan di ngag duma getaw dia Jerusalem? ");
INSERT INTO syb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kanaꞌ dema! Taluꞌu tuꞌu diniu, yamu pagid, saꞌ ndiꞌ amu daan meksikesuun, iin daani petayan niu, launan niu, maaꞌ dadema dinilan.” ");
INSERT INTO syb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Miksambingay si Isus, laungen, “Duuni getaw mimula sala puun gayu igera tu pegimulananen. Naa piglaawlaawanen su gayunen kini, adun upuꞌenen siaig bunganen, laak ndaꞌidun gusayig bunganen. ");
INSERT INTO syb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Mendadi benaꞌ minibeniben, kaliꞌ pektaluꞌ su gapuꞌ lupaꞌ di tinindananen, ‘Naa, bentayay mu pa daan, ki gayu igera kini, telu taun nau megangayangay dini mengupuꞌ sia bunganen, laak ndaꞌidun tanani maitaꞌu. Kaas penagaꞌ mu! Tumuꞌ lain nai pemula ta dinig lupaꞌ kini.’ ");
INSERT INTO syb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Dagid kaliꞌ sembag su tinindanan kia, ‘Naa Sir, ndiꞌ pa sia penegaꞌen di taun kini. Subay ilemunan ku pa deliꞌ mukaꞌ abunuan. ");
INSERT INTO syb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Gelatan ta laaki taun kini, kalukalu megbunga, naa melengas. Dagid saꞌ ndiꞌ gusay megbunga, naa dekag mu pa pepenagaꞌ tuꞌu dinaan.’” ");
INSERT INTO syb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Naa duuni Gendaw Pelali, mikpetuꞌun si Isus di simbaan nu getaw Judea. ");
INSERT INTO syb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Naa mitaang duunig libun dia, sepuluꞌ buꞌ walu taun na megladu, sabaꞌ piglegetan menulay. Mibektut, ndiꞌ tanan metandengi gindegen. ");
INSERT INTO syb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Mendadi, benaꞌ minitaꞌ ni Isus sug libun kia, sinabinen dayun, laungen diniin, “Dadaꞌ, miuliꞌan ka na di mesait mu kiin!” ");
INSERT INTO syb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Dipenan ni Isus sug libun kia. Lemen laak midepenen, mitandeng nai gindegen. Inal dayun nug libun su Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Laak su kaunutan tu simbaan, miangit, sabaꞌ duunig binaal daw ni Isus di Gendaw Pelali, piuliꞌaneni getaw kia. Kaliꞌ pektaluꞌ ki kaunutan di nga getaw dia, “Ki sala simana, duuni genem endaw biwang dinita pengimbaalan ta. Kaas angay amu dini mekpepeneguliꞌ di genem endaw kia, ndiꞌ niu taangay di Gendaw Pelali!” ");
INSERT INTO syb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","“Paa,” simbag nu Kaunutan si Isus. “Yamu pa di nga tautau mekesuun! Pia metaang di Gendaw Pelali, duun bai sala tawan diniu, ndiꞌen ubadan sug bakanen atawaka sug asnonen tu giniketan dun, dayunen uitay tu tubig puꞌ painumenen? ");
INSERT INTO syb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Naa kig libun kini samasapuꞌ ta dini Abraham, dayun sepuluꞌ buꞌ walu taun na di gengkeman ni Satanas, ndiꞌ ba mbantang beluyen dun metaang di Gendaw Pelali?” ");
INSERT INTO syb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Naa ki nga kelaun kuntra kia ni Isus, benaꞌ midengeg nilani tinaluꞌen kia, mipiid ilan. Laak su ngag duma getaw, liliag ilan gupia dig launan gulaula ni Isus, melengas gupia. ");
INSERT INTO syb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kaliꞌ pektaluꞌ si Isus, “Mendadi ki Keglekaunutan nu Megbebayaꞌ, alanduni pesemaan ku dun? Alandun mai petanggiꞌu dun? ");
INSERT INTO syb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kinii samanen, ki salabuuk lisu, sangay nu mustasa su ngalanen. Genat pemulanay, saꞌ mentubuꞌ mukaꞌ tumulin, maꞌniin na bagel gayu. Su nga manukmanuk, megbaal ilan salag nilan dia nga panganen, sabaꞌ kebagelen.” ");
INSERT INTO syb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kaliꞌ gusay pektaluꞌ si Isus, “Mendadi ki Keglekaunutan nu Megbebayaꞌ, taꞌ alandun pai petanggiꞌu dun? ");
INSERT INTO syb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Sala pa penenggiꞌan dun, petulin di pan, lemugen nug libun tu pitu gantang garina. Mendadi genat lemugay dun, mpakayaw tumulin su tibuuk baalen pan.” ");
INSERT INTO syb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Saꞌ maꞌantu, minundas si Isus mpanaw pangay tu Jerusalem, biananeni ngag lunsud gembagel saꞌ maikaꞌ, puꞌ mekpetuꞌun dia. ");
INSERT INTO syb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mendadi, duuni getaw suminaak dini Isus, laungen, “Sir, meliang laaki getaw guunen nu Megbebayaꞌ?” Kaliꞌ sembag si Isus, ");
INSERT INTO syb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Penugaling amu bian ditu mesikut gengaꞌan. Puꞌ taluꞌu tuꞌu diniu, melaun getaw suled sia, laak ndiꞌ na mekeseled. ");
INSERT INTO syb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Puꞌ duuni gendaw megbuat su gapuꞌ balay, tekepenen na su gengaꞌan. Tekaw mbuus diaan amu liu pegindeg, meksabi amu, laung niu, ‘Uu Sir, kelelaat pukaꞌay mu ami!’ Laak meksembag su gapuꞌ balay, ‘Baa, yamu kiin, ndaꞌu mesuunay adin amu getaw!’ ");
INSERT INTO syb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mektaluꞌ amu dayun, ‘Miksalu maita maan mukaꞌ minum, mikpetuꞌun ka pa padun tu tebuꞌan nami!’ ");
INSERT INTO syb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Laak dagid mektaluꞌ diniu su gapuꞌ balay, ‘Ndaꞌu daan mesuunay adin amu getaw. Pelayuꞌ amu dinaan, launan niu nu nga mikesalaꞌ getaw!’ ");
INSERT INTO syb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Kaas saꞌ maitaꞌ niu si Abraham, si Isaac, si Jacob sampay su kelaun pimuunan nu Megbebayaꞌ dengantu, ditu ilan seled nu Keglekaunutan nu Megbebayaꞌ, naa mengaduy amu, lamug mengkiget amu di ngisi niu. Puꞌ yamu, piglaken laak amu tug liu! ");
INSERT INTO syb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Asa duun pa pagidi getaw metuaꞌ ditu genat tu silangan mukaꞌ sindepan sampay tu gilidan gendaw, sumaup ilan tu keglekebibu dia Keglekaunutan nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mukaꞌ taluꞌu tuꞌu diniu, duuni getaw mbinayaꞌ nemun, iini mauna saꞌ matengi gendaw kiin ditug binayaꞌ gebii buꞌ gendaw. Duun dademai getaw mauna nemun, iin na sungkini mbaluy mbinayaꞌ saꞌ matengi gendaw kiin.” ");
INSERT INTO syb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Naa mendadi mitaang ia, duuni nga Pariseo minateng. Minadap ilan dini Isus, kaliꞌ ilan pektaluꞌ diniin, “Awaꞌa dini, puꞌ si Herodes, pekpetain ka niin sia.” ");
INSERT INTO syb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Kaliꞌ sembag si Isus, “Naa, angay amu ditu niin, ki metawakal getaw kia, iini petenday niu diniin, laung niu, ‘Pengutidan ku pai menenulay, peneguliꞌan ku pa gusayi nga getaw nandaw mukaꞌ lemaꞌ. Dayun gitunganen denlag, tubusen ku ki penggulaulaan ku.’ ");
INSERT INTO syb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Dagid pia maꞌantu, subay mundasu tuꞌu nandaw mukaꞌ lemaꞌ, sampay denlag. Puꞌ ki pimuunan nu Megbebayaꞌ, ndiꞌ mesuꞌat binesaan, subay ditu laak Jerusalem.” ");
INSERT INTO syb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Kaliꞌ gusay pektaluꞌ si Isus, “Uy, yamu nga getaw Jerusalem, yamu nga mekpatay di nga pimuunan nu Megbebayaꞌ, betuun pa pagid niu su nga sinuguꞌ diniu nu Megbebayaꞌ! Tatapu amu sia ekupay, maaꞌ nu nga pesuy pegleeman nu ginaꞌen! Dagid mpauk amu dun! ");
INSERT INTO syb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kaas belengan tuꞌu nu Megbebayaꞌ kig lunsud niu. Mukaꞌ taluꞌu dema tuꞌu diniu, genat nandaw, ndiꞌ na niau puliꞌ maitaꞌ, sampay mateng su gendaw metaluꞌ niu, ‘Aa naa, kiin na, minateng na ki pigwekilan nu Kaunutan Megbebayaꞌ. Melengas pepianan iin nu Megbebayaꞌ!’” ");
INSERT INTO syb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Naa duuni sala Gendaw Pelali, inggat si Isus maan diag balay nu sala tawan kaunutan di nga Pariseo. Naa su ngag duma getaw dia, pektuliktulikan nilan si Isus, saꞌ alanduni gulaulaanen. ");
INSERT INTO syb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mendadi, duuni getaw dia gedapan ni Isus, mingabul. ");
INSERT INTO syb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Benaꞌ minitaꞌ ni Isus, suminaak tu nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ mukaꞌ tu nga Pariseo, “Naa saꞌ metaang di Gendaw Pelali, biwang ba dinita ditu Misulat Palinta nu Megbebayaꞌ meneguliꞌ ita, saꞌ kanaꞌ ba?” ");
INSERT INTO syb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ndaꞌ sembag ki nga kuntra ni Isus kia. Piguidan ni Isus di kemet su mingabul, piuliꞌanen tuꞌu. Dayunen pauliꞌay tug balayen. ");
INSERT INTO syb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Sinaak dayun ni Isus tu nga getaw, “Naa ma. Saꞌ pinenggiꞌ duuni sala tawan diniu, melabuꞌig bataꞌen di medalem luak di Gendaw Pelali, pia pa sug bakanen laaki melabuꞌ. Ndiꞌen ba dedeliꞌen guunay?” ");
INSERT INTO syb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Naa ndaꞌidun gusayi mesembag nilan dun. ");
INSERT INTO syb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Naa sug duma getaw inggat maan diag balay kia, minitaꞌ ni Isus puꞌ pemiliꞌen nilan su gingkudan ginandam tu metaas getaw. Saꞌ maꞌantu, migbaal si Isus penenggiꞌan dun, laungen dinilan, ");
INSERT INTO syb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Naa saladuaꞌ diniu, saꞌ pinenggiꞌ enggaten ka sumaup dig belaꞌi, saꞌ mateng ka, ndiꞌa pegingkud di gingkudan nu metaas getaw. Puꞌ kalukalu duuni inggat metaas pa diniꞌa, ");
INSERT INTO syb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","dayun tekaw mbuus mekpesempel diniꞌa su migenggat diniu duaꞌ, maaꞌ laungen dayun diniꞌa, ‘Ay, beliu amu gingkudan, puꞌ iini paingkuden di giningkudan mu kiin.’ Benaꞌ mekegalin ka tu tampusan gembabaꞌ gingkudan nu getaw, mpatiꞌa mpiid. ");
INSERT INTO syb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Segaga saꞌ enggaten ka sumaup dig lumpuk, pegingkuda tu tampusan gembabaꞌ gingkudan. Saꞌ maꞌnia, mbuus mekpesempel diniꞌa su migenggat diniꞌa, maaꞌ laungen dayun, ‘Baa, Sambat, galin ka dini metaas.’” Maaꞌ laung ni Isus, “Saꞌ maꞌantu, mpegbesaan ka di gedapan nu kelaun duma mu meglekebibu. ");
INSERT INTO syb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Puꞌ adin su getaw petaasenen siai tindegen, iini pebebaꞌen. Adin dema su getaw mekpebabaꞌ dig lawasen, iini petaasen.” ");
INSERT INTO syb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kaliꞌ pelum pektaluꞌ si Isus tu getaw migenggat diniin, “Yaꞌa pelum, maꞌantu dadema, saꞌ megenggata tu melaun getaw maan atawaka meglekebibu, ndiꞌ pia saꞌ iin laaki enggaten mu su nga sambat mu, nga pated mu, betaꞌan mu, atawaka su nga sumbalay niu medatuꞌ getaw. Puꞌ saꞌ ilani enggaten mu, naa enggaten ka nilan pelum. Maꞌantu, mpekput na ki sugda dun diniꞌa, ndaꞌiduni mbilin. ");
INSERT INTO syb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Segaga saꞌ meglekebibua, iini enggat mu su pubri, su nga mibektut, su nga pilung, sampay su ngag buta. ");
INSERT INTO syb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Leliagen ka dayun, puꞌ kagina ndiꞌ mekesuliꞌ diniꞌa su nga getaw inggat mu, sugdaan ka dun nu Megbebayaꞌ saꞌ mateng su gendaw metubuꞌ puliꞌ su nga mekesuun getaw minatay.” ");
INSERT INTO syb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Naa su ngag duma ni Isus maan, benaꞌ midengeg nilani tinaluꞌen kia, laung nu sala tawan, “Ki getaw mekesaup tu keglekebibu ditu Keglekaunutan nu Megbebayaꞌ, leliagen tantu!” ");
INSERT INTO syb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Kaliꞌ sembag diniin si Isus, “Dagid pegdelendem mu ini. Duuni getaw miglumpuk, melaun getaw pisebutanen. ");
INSERT INTO syb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mendadi, benaꞌ minuyaꞌ na su gilak, suminuguꞌ su gapuꞌ peglumpuk di nga sesuguꞌenen meksabi tu nga getaw pisebutanen, laungen, ‘Naa ditu namu, minuyaꞌ nai gilak!’ ");
INSERT INTO syb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Laak dagid ki nga ginggaten sumaup kini, diadia mipauk ilan, lumbus laak ilan migbaalbaal lapal. Duuni miktaluꞌ, ‘Begu dau mekesaluy lupaꞌ, subay engain ku pa bentayay. Naa saꞌ mesuꞌat, taluꞌ mu ditu, ndiꞌ dau sumaup.’ ");
INSERT INTO syb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Laung nug duma, ‘Suminaluyu lima parisan baka, engain ku pa indanay pegdaru. Kaas saꞌ mesuꞌat, pemuunen ku diniꞌa, ndiꞌ nau sumaup.’ ");
INSERT INTO syb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Laung pagid nug duma, ‘Begu pau kini penginsawa, kaas ndiꞌu mekesaup.’ ");
INSERT INTO syb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Naa saꞌ maꞌantu, minuliꞌ su sesuguꞌen kia, inukiten ditu gegalenen sug launanen kiin. Mendadi ki gapuꞌ balay, mitutung patiꞌi gangiten. Kaliꞌ pektaluꞌ di sesuguꞌenen kia, ‘Gebeka, leep mu su karsada maikaꞌ saꞌ gembagel dinig lunsud, penguit mu dayun dini su nga pubri, su nga mibektut, su ngag buta, dakus su nga pilung.’ ");
INSERT INTO syb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Naa saꞌ maꞌantu, benaꞌ minateng puliꞌ su sesuguꞌen kia, laungen, ‘Sir, ki suguꞌan mu dinaan, mitubus na, laak duun pai gingkudan.’ ");
INSERT INTO syb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kaliꞌ pektaluꞌ su gapuꞌ peglumpuk, ‘Naa pedituun ka pelum nga karsada sampay dalan. Adini getaw metaangan mu, tegel mu sumaup, adun gembibu ita dinig balayu keni. ");
INSERT INTO syb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Puꞌ taluꞌu tuꞌu diniu, kig bekna pisebutan ku kitu, ndaꞌidun dinilani mpeduma di keglekebibuu, pia sala tawan dinilan!’” ");
INSERT INTO syb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Naa saꞌ mipanaw si Isus, metibaꞌ gupia getaw tumindug diniin. Mendadi, luminingay si Isus dinilan, kaliꞌ pektaluꞌ, ");
INSERT INTO syb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Adin su getaw sumakup dinaan, subay ki kepetailen dinaan, gembagel pa di kepetailen tu ginaꞌen mukaꞌ tu gamaꞌen, tu sawanen, bataꞌen, pateden libun laki, sampay su kepetailen tug lawasen. Puꞌ saꞌ kanaꞌ maꞌniai kepetailen dinaan, naa ndiꞌ mesuꞌat sumakup dinaan. ");
INSERT INTO syb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Adin su ndiꞌ mekpisan kurusen dakus megdunut dinaan, naa kiin, ndiꞌ mesuꞌat sumakup dinaan.” ");
INSERT INTO syb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Laung ni Isus, “Pinenggiꞌ duun diniui getaw meliag megbaal gembagel balay. Naa ndiꞌ ba megingkud pa deliꞌ meglekwinta di gastu dun, saꞌ megaganen tubusay saꞌ ndiꞌ? ");
INSERT INTO syb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Puꞌ saꞌ ndiꞌ meglekwinta, tekaw buus laak mbulugen pesekay sug balay, dayun ndiꞌen megaga tubusay, pegimusaungan nu nga kelaun mekaitaꞌ dun, ");
INSERT INTO syb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","kaliꞌ ilan taluꞌ, ‘Haa, ki getaw kiin, mikpuun megbaal balay, dayun ndaꞌen pelum megaga tubusay!’” ");
INSERT INTO syb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Laung pagid ni Isus, “Mesama da ki gadiꞌ, saꞌ mangay megbunuꞌ tu sama adiꞌen. Dekag pasiꞌ mpanaw, ndiꞌ ba megingkud pa deliꞌ, pengentapenen saꞌ su sundalunen selaksaꞌ tawan, megaganen ba pengetuay sug dibaluy, duaꞌ laksaꞌ pelumi sundalunen? ");
INSERT INTO syb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Dayun saꞌ pengentapenen ndiꞌen megaga, selian melayuꞌ pai sama adiꞌen, ndiꞌ ba memuun tu sama adiꞌen kia, adun megeksud ilan? ");
INSERT INTO syb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ndaꞌi sala tawan diniu mekesakup dinaan, subay ndaꞌ na dig delendemanen su kelaun petailenen.” ");
INSERT INTO syb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Kaliꞌ gusay pektaluꞌ si Isus, “Naa ki masin, gembageli gatagen. Laak saꞌ meksitebang su masin, naa kendutaꞌen ma dun pekpepuliꞌ tu kepaiten? ");
INSERT INTO syb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Saꞌ kanaꞌ na gempait, ndaꞌ nai gatagen, pia baalen sia gabunu. Benaꞌ belengen na laak nu getaw. Naa adin sug duuni telinganen, mekineeg dema tuꞌu!” ");
INSERT INTO syb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Naa melaun mendawat buis mukaꞌ duma mekesesalaꞌ getaw mikpungun dia ni Isus adun mekineeg ilan tu taluꞌen. ");
INSERT INTO syb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Laak su nga Pariseo mukaꞌ su nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, linibak nilan si Isus, laung nilan, “Paa, ki getaw kiin, penembaꞌeneni nga mekesesalaꞌ getaw, dungan pa padun dinilan maan!” ");
INSERT INTO syb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mendadi, benaꞌ misuunan ni Isus sug libakan nilan, migukit dayun dinilan sambingay, laungen, ");
INSERT INTO syb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Naa mendadi, pinenggiꞌ duuni sala tawan diniu megatusi karnirunen, dayun mbelengi salabuuk dun. Ndiꞌen ba bilinen dia pengeksaban su siam puluꞌ buꞌ siam, adun penengaunen ki salabuuk kia mibeleng? Penengaunen lai, sampay metuunen! ");
INSERT INTO syb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Dayun saꞌ metuunen nai salabuuk kia, pisanenen muliꞌ, leliagen gupia. ");
INSERT INTO syb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Naa saꞌ mateng dig balayen, sebiinen dayun su nga sambaten dakus su sumbalayen, laungen dinilan, ‘Megleliag ita, puꞌ ki mibeleng karniruu, mituun ku na!’ ");
INSERT INTO syb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Naa maꞌantu dadema, saꞌ meksikesuuni sala tawan laak mikesalaꞌ getaw, taluꞌu diniu, dedialan gupia ditu gekbus langit, gembagel pa dig leliag dun di siam puluꞌ buꞌ siam tawan mekesuun getaw, su ndiꞌ kambat meksikesuun.” ");
INSERT INTO syb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kaliꞌ pektaluꞌ si Isus, “Mesamaig libun, pinenggiꞌ duuni siinen sepuluꞌ laad pelata. Saꞌ mbeleng diniin selaad, ndiꞌen ba tutudani suluꞌen mukaꞌ siliganen sug liwagan nug balayen, penengaunen sibaꞌ sampay metuunen? ");
INSERT INTO syb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Dayun saꞌ metuunen na, sebiinen su nga sambaten mukaꞌ sumbalayen mekpungun diag balayen, teluꞌenen dayun dinilan, ‘Megleliag ita, puꞌ su siin ku mibeleng, minitaꞌu na!’” ");
INSERT INTO syb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Diksuꞌ ni Isus su taluꞌen, “Maꞌantu dadema, saꞌ meksikesuuni sala tawan laak mikesalaꞌ getaw, taluꞌu diniu, gembagel tuꞌuig leliag ditu gedapan nu nga sesuguꞌen nu Megbebayaꞌ getaw langit.” ");
INSERT INTO syb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kaliꞌ pagid peksambingay si Isus, laungen, “Mendadi, duuni getaw, duaꞌ tawanig bataꞌen, lumbus laki. ");
INSERT INTO syb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Naa duuni gendaw ki ngudan dun, miktaluꞌ tu gamaꞌen, ‘Naa Amaꞌ, saꞌ mesuꞌat diniꞌa, begay mu na dinaan nandaw su gilasu tu pusakaꞌ petenged dinaan.’ Pikilas dayun nu gamaꞌen su pusekaꞌenen dig bataꞌen kia duaꞌ tawan. ");
INSERT INTO syb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mendadi, benaꞌ santaꞌ gebii, ki ngudan, pinungunen su kelaun gimunen, dayunen uitay mpanaw tu melayuꞌ benwa. Naa benaꞌ minateng ditu ki ngudan kini, sipalaanen laak gelaꞌay su gimunen sabaꞌen megayep. ");
INSERT INTO syb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Mendadi, benaꞌ migelaꞌ na gupia su kwartanen, mibianan pelum meliget gutemig benwa kiin, ndaꞌidun dayuni ketubuꞌan nug begutaw kini. ");
INSERT INTO syb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Saꞌ maꞌantu, mikpetindan di getaw dangen dia, bitang dayun iin di telunan megingat babuy. ");
INSERT INTO syb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Naa, apelai. Pia su gaan nu ngag babuy kia, mauyaꞌanen sia maan dun, sabaꞌ peglegunusan na. Laak ndaꞌi getaw mekpaan diniin. ");
INSERT INTO syb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Dagid benaꞌ minibeniben, kaliꞌ pegleketau, laungen dig dialem delendemanen, ‘Su kelaun tinindanan ni Amaꞌu, sukali gaan nilan, ndiꞌ nilan megelaꞌ sabaꞌ kelaunen. Naan pelum kini, peglegunusan nau! ");
INSERT INTO syb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Tumuꞌ pa megawaꞌu dini ganam, muliꞌu tu ni Amaꞌu. Saꞌ matengu ditu, teluꞌen ku dayun diniin, “Amaꞌ, mikesalaꞌu diniꞌa, sampay ditu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Kaas kanaꞌ na mbantang gelalen mau bataꞌ mu. Saꞌ maꞌantu, Amaꞌ, mekpetindan nau laak diniꞌa.”’ ");
INSERT INTO syb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Naa saꞌ maꞌantu, minuliꞌ tuꞌu ditu gamaꞌen ki ngudan kini. “Naa saꞌ melayuꞌlayuꞌ paig begutaw kini, midayag na nu gamaꞌen. Iin, kaliꞌen maitaꞌ sug bataꞌen, milelaat dun gupia. Gibeken sungkakay, dayunen ekepay dakus pingelekanen. ");
INSERT INTO syb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","‘Naa Amaꞌ,’ laung nug begutaw, ‘mikesalaꞌu diniꞌa dakus tu Megbebayaꞌ. Kanaꞌ na mbantang gelalen mau bataꞌ mu.’ ");
INSERT INTO syb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Dagid su gamaꞌen, miksabi tu nga sesuguꞌenen, laungen dinilan, ‘Pemagas amu, angay niui melengas gupia suub kiin, peseluk niu diniin. Penising niu, pesepetusay niu pa pagid. ");
INSERT INTO syb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mukaꞌ titiꞌ niu ki pilembuꞌ ta nati baka kiin, adun meglekebibu ita, megleliag ita! ");
INSERT INTO syb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Puꞌ kig bataꞌu kini, lepeng minatay na, dayun mitubuꞌ puliꞌ. Mibeleng na sia, dayun mibaangan na.’ Mendadi, miglekebibu ilan tuꞌu.” ");
INSERT INTO syb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Laung pa ni Isus, “Mendadi su gulangbataꞌen pelum, ditu pa pegimulanan nilan. Benaꞌ minuliꞌ, kaliꞌ mesebang dig balay, midengegen su gigungan mukaꞌ sibayan. ");
INSERT INTO syb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Sinabinen dayuni sesuguꞌen nilan, sinaakanen saꞌ taꞌ alanduni mipenggulaula kia. ");
INSERT INTO syb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kaliꞌ sembag su sesuguꞌen, ‘Minateng na su ngudan mu. Tinitiꞌ nu gamaꞌ niu su melembuꞌ nati baka, puꞌ mialapen puliꞌ daw sug bataꞌen, ndaꞌ mekaꞌiday.’ ");
INSERT INTO syb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Naa ki gulangbataꞌ kini, benaꞌ midengegen, miglebut dun patiꞌ, mipauk dayun suled. Gumiwaꞌ dayun su gamaꞌen, pikamuꞌamuꞌen sug bataꞌen kia adun suled. ");
INSERT INTO syb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Laak kaliꞌ sembag, ‘Paa, Amaꞌ, kitui kaibenen, kanaꞌ laak santaꞌ taun mingimbaalu diniꞌa, ndaꞌu mainsan pemilas di suguꞌan mu dinaan. Laak pia maꞌantu, ndaꞌ mau mainsan begayay pia salabuuk nati kanding, adun meglekebibu ami sia nu nga sambatu! ");
INSERT INTO syb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Laak benaꞌ minatengig bataꞌ mu kiin, su gumilaꞌ tu misukat mu gimu megunung di ngag libun, naa tinitiꞌ mu pelum diniin su pilembuꞌ nati baka!’ ");
INSERT INTO syb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Dagid sumimbag su gamaꞌen, ‘Naa, Naung, ita duaꞌ, meksalabuuk ita gusay megbenwa, kaas adin sug danaan, daniꞌa dadema. ");
INSERT INTO syb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Dagid ndiꞌ mesuꞌat saꞌ ndiꞌ ita daan meglekebibu mukaꞌ megleliag, puꞌ ki ngudan mu kiin, lepeng minatay na, dayun mitubuꞌ pelum. Mibeleng, dayun mibaangan na.’” ");
INSERT INTO syb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Naa migukit si Isus tu nga sakupen, laungen dinilan, “Duuni peneligan nu medatuꞌ getaw. Mendadi ki peneligan kini, dinangat ditu medatuꞌ getaw, ndiꞌen daw peksibaꞌan su gaꞌus pigwakil diniin. ");
INSERT INTO syb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Naa saꞌ maꞌantu, sinabi nu medatuꞌ getaw peneliganen, sinaakanen, ‘Naa ma, metuud ba ki midengegu kini mekatag diniꞌa? Uliꞌ mu dinaan su keglekwinta mu tu kelaun pigwakil diniꞌa, puꞌ kanaꞌa na peneligan ku.’ ");
INSERT INTO syb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Benaꞌ midengeg nu peneligan su tinaluꞌ nu gegalenen, laungen dig dialem ginaanen, ‘Naa, taꞌ mai baalen ku keni, kagina uiꞌen dinaan nu gegalen kui ketendanan ku? Ndiꞌu ma megaga mengimbaal dig lupaꞌ, mpiidu dema menengi.’ ");
INSERT INTO syb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Kaliꞌ pegleketau, laungen, ‘Aa naa, adun duun pai getaw menembaꞌ dinaan tug balayen saꞌ mawiꞌ dinaani ketendanan ku, tumuꞌ maꞌniniig baalen ku!’ ");
INSERT INTO syb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Mendadi, sinabinen su nga kelaun miutangan tu gegalenen, piksesala tawan. Sinaakanen su miuna dateng, ‘Naa yaꞌa ma, sanui gutang mu tu gegalen ku?’ ");
INSERT INTO syb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Kaliꞌ sembag, ‘Megatus taruig lana.’ Kaliꞌ pektaluꞌ su peneligan, ‘Naa, kiniig lista mu. Pegingkuda deliꞌ, sulat mu dayun, lima puluꞌ laak.’ ");
INSERT INTO syb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Sinaakanen pelum su sala tawan, ‘Naa daniꞌa ma, sanui gutang mu?’ Kaliꞌ sembag, ‘Megatus bakidi trigo.’ Kaliꞌ pektaluꞌ su peneligan, ‘Naa, kiniig lista mu. Sulat mu diin, walu puluꞌ bakid laak.’ ");
INSERT INTO syb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Naa mendadi,” maaꞌ laung ni Isus, “saꞌ midengeg nu gegalenen su pinggulaula nug limbungan peneliganen kia, pinalanen, puꞌ telisebuten daw. Puꞌ su nga getaw kinilawanig delendemanen, metau ilan mengandam di kepianan nilan ditug binayaꞌ gebii buꞌ gendaw. Telisebuten ilan mengandam dun, batul nu nga midelagan getaw. ");
INSERT INTO syb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Kaas taluꞌu tuꞌu diniu,” maaꞌ laung pa ni Isus, “ki gaꞌus niu kinilawan, peksaluy niu, adun gabang niu tu nga samataw niu. Dayun saꞌ mateng na su gendaw kiin mpapas su gaꞌus, mpenembaꞌ amu gusay ditug benwa ndaiꞌ kebelengen. ");
INSERT INTO syb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Adin su meseligan di maikaꞌ ketendananen, iini meseligan dadema di gembagel. Adin su meglimbung di maikaꞌ, iini meglimbung dadema di melaun. ");
INSERT INTO syb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kaas diadia saꞌ kanaꞌa meseligan gumamit di gaꞌus kinilawan, pesalig ba diniꞌa ki gaꞌus ditu gekbus langit? ");
INSERT INTO syb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mukaꞌ saꞌ kanaꞌa meseligan di gimu laak pisalig pa deliꞌ diniꞌa, begayan ka ba nu Megbebayaꞌ dig daniꞌa gupia gimu?” ");
INSERT INTO syb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Diksuꞌ ni Isus su tinaluꞌen, “Naa su peneligan, ndiꞌ mesuꞌat pegdenganen tindanay nug duaꞌ tawan gegalen. Puꞌ saꞌ maꞌantu, mesengayen sug bekna gegalenen, laak petailenen su keduaꞌ gegalenen. Atawaka iini petuudenen sug bekna gegalenen, dagid teliudanen laak su keduaꞌen. Kaas su Megbebayaꞌ mukaꞌ su gaꞌus, ndiꞌ mesuꞌat pegdenganen pebegelay di ginaa niu.” ");
INSERT INTO syb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Naa su nga Pariseo, benaꞌ midengeg nilan su kelaun tinaluꞌ kia ni Isus, piksudiꞌan nilan iin, sabaꞌ mesaku ilan gupia di kwarta. ");
INSERT INTO syb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Dagid kaliꞌ pektaluꞌ si Isus, “Paa, yamu di nga Pariseo, mekpaitaꞌitaꞌ amu mekesuun di gedapan nu nga getaw, laak misuunan nu Megbebayaꞌi tantu delendeman niu. Ki melagaꞌ gupia di pegitaꞌ dun nu kilawan, melemuꞌ laak dun su Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Kaliꞌ pektaluꞌ si Isus, “Naa dekag pasiꞌ mituaꞌ si Juan su Memunag Tubig, pigbiaꞌan su nga getaw nu Palinta nu Megbebayaꞌ pisulaten dini Moises mukaꞌ tu ngag duma pimuunanen dengantu. Dayun genat di ketuaꞌ ni Juan, pegukiten su Gempia Petenday mekatag di Keglekaunutan nu Megbebayaꞌ, kaas su kelaun getaw, mektinantu sumakup dun. ");
INSERT INTO syb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Laak dagid pia maꞌantu, ki Misulat Palinta nu Megbebayaꞌ, ndiꞌ mpalin su pegbayaꞌen. Melemu pa megelaꞌ mbeleng su gekleb langit buꞌ lupaꞌ kini, sabayaꞌ nu Palinta, mengkanan sektaang taluꞌ.” ");
INSERT INTO syb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Kaliꞌ pektaluꞌ si Isus, “Adin sug laki belengenen su sawanen dayun menginsawa na puliꞌ dig lain libun, naa kiin, mikesalaꞌ dusa. Mesama da saꞌ duuni senlangan megbeleng, dayun penginsuaan nug lain laki sug libun. Kiin, mikesalaꞌ dadema dusa su menginsawa dun.” ");
INSERT INTO syb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Naa miksambingay si Isus, laungen, “Duuni medatuꞌ getaw, iini penepetenen gempula suub gadiꞌ dakus sug duma melagaꞌ penepeten. Gendawgendaw meglekebibu. ");
INSERT INTO syb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Naa diag bisuangan nu medatuꞌ getaw, duuni pegbelilid dia pubri getaw, ngalanen si Lazaro, mileepig lawasen penekit. ");
INSERT INTO syb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Puꞌ liagan sia ni Lazaro, maan di nga mumu melabuꞌ diag lemisaan nu medatuꞌ getaw. Pidag pa tanan su penekiten, pinilaꞌan nu nga gituꞌ. ");
INSERT INTO syb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Mendadi benaꞌ miniben, minatay si Lazaro, iwit dayun nu nga sesuguꞌen nu Megbebayaꞌ getaw langit tu gupid ni Abraham. Naa ki medatuꞌ getaw kini, minatay dadema mukaꞌ libeng. ");
INSERT INTO syb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Naa benaꞌ ditu na linaw gapuy su medatuꞌ, miligetan gupia. Kaliꞌ tingag, minitaꞌen ditu melayuꞌ si Abraham, sampay si Lazaro, masiꞌ dia peksainganen gupia si Abraham. ");
INSERT INTO syb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“Tiwagan dayun nu medatuꞌ getaw si Abraham, laungen, ‘Uu Apuꞌ Abraham, lelaatay mau! Suguꞌ mu si Lazaro, adun lesekenen pia laak sebanay di tenduꞌen di metegdaw tubig, adun petegduꞌanen dinig dilaꞌu. Puꞌ mitegelanu patiꞌ dini gapuy keni!’ ");
INSERT INTO syb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Laak dagid miktaluꞌ si Abraham, ‘Naa Apuꞌ, iini pegdelendem mu, yaꞌa, mibianan mu na su nga memis kebetang, saanan pa tetubuꞌa. Si Lazaro, mibiananen dema su nga gempait kebetang. Dagid nemun, mipianan iin dini. Yaꞌa pelumi mitegelan diin. ");
INSERT INTO syb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Keduaꞌen, duuni gembagel gupia gawang di gelet ta, adun ndiꞌ mekebian su mangay sia diniu diin genat dini. Mukaꞌ ndaꞌ dademai mekebian mangay dinami kini genat diniu dapit.’ ");
INSERT INTO syb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Kaliꞌ sumpat su medatuꞌ getaw, ‘Laak kelelaat diniꞌa Apuꞌ, penengiin ku dema tuꞌu diniꞌa, suguꞌ mu si Lazaro meditug balay nu gamaꞌu, ");
INSERT INTO syb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","adun penegulanen su patedu, puꞌ duunig lima tawan patedu ditu, adun ndiꞌ ilan sia mpeduma mekedini benwa nu kelegenay!’ ");
INSERT INTO syb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“‘Baa,’ simbag ni Abraham, ‘ki Palinta nu Megbebayaꞌ pisulaten dini Moises mukaꞌ tu ngag duma pimuunanen dengantu, mipeduunan ilan dun. Melengas kitui kineegan nilan.’ ");
INSERT INTO syb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Laung pelum nu medatuꞌ getaw, ‘Naa kanaꞌ maꞌnia, Apuꞌ Abraham. Saꞌ tumuꞌ duun siai getaw genat matay mangay mekpegad dinilan, naa dekag pailan tuꞌu peksikesuun.’ ");
INSERT INTO syb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“‘Baa,’ simbag ni Abraham, ‘saꞌ ndiꞌ nilan kineegan ki Palinta nu Megbebayaꞌ pisulaten dini Moises mukaꞌ tu ngag duma pimuunanen dengantu, naa ndiꞌ ilan gusay metuudan, pia pa duuni getaw metubuꞌ puliꞌ genat matay.’” ");
INSERT INTO syb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Kaliꞌ pektaluꞌ si Isus tu nga sakupen, “Naa, minget ndiꞌ mesuꞌat puꞌ ndaꞌiduni kegdaang di getaw. Laak pia maꞌantu, mekelelaatlelaat su getaw mekegdaang di samatawen! ");
INSERT INTO syb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ki mekegdaang dun, saꞌ pinenggiꞌ palintangan galingan dayun lebuꞌay tug laud, tumuꞌ megaan daitu, sabayaꞌ nu ginukuman nu Megbebayaꞌ tu getaw mekegdaang di sala tawan gembataꞌ kini. ");
INSERT INTO syb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kaas pekpetubud amu! “Saladuaꞌ diniu, saꞌ duuni samasakup mu mekesalaꞌ diniꞌa, naa tituluꞌay mu iin. Dayun saꞌ megbiksuꞌig duma mu kia, pedasun mu. ");
INSERT INTO syb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Pia pa mekesalaꞌ diniꞌa pitu deksuꞌ sendaw, dayun pitu deksuꞌ dadema mekpuliꞌpuliꞌ diniꞌa mektaluꞌ, ‘Migbiksuꞌu dun,’ naa pia maꞌantu, subay pedesunen mu gusayig duma mu kia.” ");
INSERT INTO syb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Naa kaliꞌ pektaluꞌ tu Kaunutan su nga peneliganen, “Sir, paiseg mu ki kesalig nami.” ");
INSERT INTO syb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kaliꞌ sembag su Kaunutan, “Ki kesalig niu, pia laak sia maꞌniin bagel salabuuk lisu mustasa, naa megaga niu suguꞌayi gembagel gayu kinuꞌ, laung niu, ‘Mbakuta, mpemulaa dayun tug laud!’ Naa maꞌantu da, mekpetuud dadema diniu ki gayu kia.” ");
INSERT INTO syb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Kaliꞌ pektaluꞌ si Isus, “Naa pinenggiꞌ sala tawan diniu, duuni sesuguꞌen mu megdaru atawaka megingat karniru. Naa saꞌ muliꞌ diag balay su sesuguꞌen mu, teluꞌen mu ba di sesuguꞌen mu kia, ‘Bundasa dini, gingkuda maan’? ");
INSERT INTO syb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ndiꞌ mu ba teluꞌen sungkin diniin, ‘Naa, baꞌugay mau, pegilisa, ilakay mau dayun’? Mukaꞌ teluꞌen mu pagid diniin, ‘Naa saꞌ metubusu maan mukaꞌ minum, dekaga pa aan.’ ");
INSERT INTO syb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Dayun saꞌ metubus nu sesuguꞌen su sinuguꞌan mu diniin, mekpaladpalada ba diniin? Mabuꞌ ndiꞌ. ");
INSERT INTO syb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mendadi maꞌantu dadema amu, saꞌ mpenggulaula niuig launan sinuguꞌ diniu, naa iin dayuni taluꞌ niu, ‘Sesuguꞌen laak ami, daal da laaki binaal nami su mbantang baalen nami.’” ");
INSERT INTO syb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Naa selian ni nga Isus dig dalan pangay tu Jerusalem, mikebian ilan dig dulunan nu Samaria mukaꞌ nu Galilea. ");
INSERT INTO syb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Mendadi, benaꞌ misebang ilan di maikaꞌ lunsud, duuni suminungkak dini Isus sepuluꞌ tawan migladu mekesalebuꞌ nuka. Ki nga pegladu kini, pegindeg ilan di melayuꞌlayuꞌ, ");
INSERT INTO syb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","kaliꞌ ilan pektawag diniin, laung nilan, “Uu Sir Isus, lelaatay mu ami!” ");
INSERT INTO syb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Benaꞌ minitaꞌ ni Isus su sepuluꞌ tawan, laungen dinilan, “Angay amu tug belian, pebantay niu dunig lawas niu.” Lemen laak ilan mikepanaw, mitekaw mawaꞌi mekesalebuꞌ nuka nilan. ");
INSERT INTO syb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Naa sala tawan di sepuluꞌ kia, benaꞌ mibatiken puꞌ miuliꞌan na, mipuliꞌ dia ni Isus, pekpenekeg megenal tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Benaꞌ midepet di gedapan ni Isus, miglaub mekpaladpalad diniin. Asa iin, getaw Samaria. ");
INSERT INTO syb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Benaꞌ midengeg ni Isus su kekpaladpaladen, kaliꞌ pektaluꞌ, “Asa kanaꞌ ba sepuluꞌ tawani pineguliꞌan? Saꞌ maꞌantu, adin ma su nga siam? ");
INSERT INTO syb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Daal da laak masiꞌi mipuliꞌ megenal tu Megbebayaꞌi sala tawan kini kanaꞌ getaw Judea?” ");
INSERT INTO syb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Laung dayun ni Isus tu getaw Samaria, “Naa, pegbuata, bundasa di gengayan mu. Miuliꞌan ka puun di kesalig mu.” ");
INSERT INTO syb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Naa duuni nga Pariseo, sinaak nilan dini Isus saꞌ nanu meglekaunutan na tuꞌu su Megbebayaꞌ. Kaliꞌ sembag si Isus, “Ki Keglekaunutan na tuꞌu nu Megbebayaꞌ, ndiꞌ mbentayan nu getaw. ");
INSERT INTO syb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ndiꞌ metaluꞌ nu getaw, ‘Bentayay pa daan niu, kiin na!’ atawaka ‘Kia nain!’ Puꞌ taluꞌu diniu, ki Keglekaunutan nu Megbebayaꞌ, dini na niu tuꞌu.” ");
INSERT INTO syb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kaliꞌ gusay pektaluꞌ si Isus tu nga sakupen, “Duuni gendaw mateng, taginaa niu dun, mbianan niu su Keglekaunutan ku, naan kini kig Bataꞌ nu Kilawan, pia sendaw laak sia. Laak bulug ndiꞌ niu pa mbianan. ");
INSERT INTO syb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mukaꞌ duun pai mektaluꞌ diniu maꞌniniꞌ, ‘Bentayay pa daan niu, kiin na!’ atawaka duuni mektaluꞌ, ‘Bentayay pa daan niu, kinuꞌ na!’ Laak ndiꞌ niu laaway. ");
INSERT INTO syb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Puꞌ maaꞌ nu gilat, tekaw tiaganen sug langit genat tu dapit silangan mangay tu sindepan, maꞌantu dau dema, naan kini kig Bataꞌ nu Kilawan, saꞌ mateng su gendaw di kelusadu puliꞌ. ");
INSERT INTO syb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Laak iinig bekna mpenggulaula, naan, kig Bataꞌ nu Kilawan, mianu di meliget lasay, pemilasen pau pagid nu nga getaw nemun. ");
INSERT INTO syb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Puꞌ ki kelusadu puliꞌ, naan kini kig Bataꞌ nu Kilawan, iini samanen, su mipenggulaula ditu timpu pa ni Noe. ");
INSERT INTO syb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Di gendaw kitu, minaan su getaw, mininum ilan, migbelaꞌi ilan, sampay da dun di gendaw nu keseled ni nga Noe tug butuk, dayun mikpuun sug Bagyu Lampap. Dayun mitekawan melemesi kelaun getaw kitu. ");
INSERT INTO syb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Maꞌantu da pagid su gendawan ni Lot. Ndaꞌidunig lain delendeman nu getaw, minaan laak ilan, mininum, mindagang, migimula ilan, dakus migbaal balay. ");
INSERT INTO syb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Laak dagid su gendaw nu kelaguy ni nga Lot tug lunsud Sodoma, iin na dayun su kepelabuꞌ gapuy mukaꞌ batu megligaꞌ tug lunsud kitu genat tug langit. Mitekaw dayun megelaꞌ matay su nga getaw dia. ");
INSERT INTO syb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mendadi, naan kini kig Bataꞌ nu Kilawan, maꞌantu dadema ki ketuaꞌu puliꞌ.” ");
INSERT INTO syb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kaliꞌ pektaluꞌ si Isus, “Mendadi, saꞌ matengi gendaw kiin, adin su getaw metaang dia gatep nug balayen, laak su pimetangen, dia da dialem balayen, ndiꞌ pia melangan suled pa diag dialem puꞌ malap di pimetangen. Samanen su getaw saꞌ metaang ditug binaalanen, ndiꞌ dadema mpia muliꞌ. ");
INSERT INTO syb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Iini pegdelendem niu, su sawa ni Lot dengantu. ");
INSERT INTO syb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Naa adini mpauk megwakil gumulen dinaan, mbeleng diniin su ketubuꞌ ndaꞌi tamanen. Adin su pegwakilen dinaan su gumulen, iin, malapen sungkin su ketubuꞌ ndaꞌi tamanen. ");
INSERT INTO syb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Taluꞌu tuꞌu diniu, saꞌ matengu gebii, metaang duunig duaꞌ tawan megubay metulug, tekaw elapen su sala tawan, mbilin sug dumanen. ");
INSERT INTO syb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Duun pa pagidig duaꞌ tawan libun peglegaling. Tekaw mawaꞌi sala tawan, elapen, bilinen su sala tawan. ");
INSERT INTO syb_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Duun pa pagidig duaꞌ tawan laki pekpengimbaal dig lupaꞌ, benaꞌ su sala tawan, tekaw uaꞌay, mbilin laak sug dumanen.” ");
INSERT INTO syb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Benaꞌ midengeg nu nga sakup ni Isus, sinaak nilan diniin, “Sir, adin ma mpenggulaula?” Kaliꞌ sembag si Isus, “Adin sug duunig bangkay dun, ditu dayun mekpungun su nga menagit.” ");
INSERT INTO syb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Naa migukit si Isus tu nga sakupen sambingay, bianen mektituluꞌ dinilan puꞌ subay tatap ilan menenabi, ndiꞌ ilan lumukas dun. ");
INSERT INTO syb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kaliꞌ pektaluꞌ si Isus, “Naa dia salabuuk lunsud, duuni kuis dia. Ki kuis kini, kanaꞌ mendek ditu Megbebayaꞌ, ndiꞌ dadema megbasa di samatawen. ");
INSERT INTO syb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Naa duun pagidig balulibun diag lunsud kia. Kig balulibun kini, tatap mangay ditu kuis, kaliꞌ pegubug diniin, ‘Sugutay mau ditu mipenggulaulau tu kuntrau!’ ");
INSERT INTO syb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Naa sug bekna kitu, mpauk sia megabang su kuis ditug balulibun kia. Laak saꞌ miniben, laungen dig dialem ginaanen, ‘Aa, pia ndiꞌu mendek tu Megbebayaꞌ mukaꞌ ndiꞌu dadema megbasa di samatawu, ");
INSERT INTO syb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kig balulibun kini, peksemukenu niin patiꞌ. Tumuꞌ pedaagen ku na laak, adun ndiꞌu penlukasen diniin, tatap pelum mekpuliꞌpuliꞌ dini!’ ");
INSERT INTO syb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","“Naa saꞌ maꞌantu,” maaꞌ laung pa nu Kaunutan tu nga sakupen, “pia melaatig betad nu kuis kiin, pegdelendem niu ki tinaluꞌen tug libun. ");
INSERT INTO syb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Naa su Megbebayaꞌ pelum, saꞌ menamal menenabi diniin gebii gendaw su nga pimiliꞌen sakupen, kanaꞌ ba labi pa mekpepia dinilan? Melangan ba megabang dinilan? ");
INSERT INTO syb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Taluꞌu diniu, pepiananen dayun, sembutenen pepianay. Laak dagid pia maꞌantu, saꞌ lumusadu puliꞌ dinig lumbang, naan kini kig Bataꞌ nu Kilawan, metaangan ku ba, sumalig tu Megbebayaꞌi nga getaw?” ");
INSERT INTO syb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Mendadi, miksambingay pa gusay si Isus, pisugaten ditu sambingayen su nga getaw delendeman nilan dun, ilan laaki mekesuun, peksudiꞌan nilan su kelaun samataw nilan. ");
INSERT INTO syb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Kaliꞌ pektaluꞌ si Isus, “Duuni Pariseo minangay ditug Balay Pengedapan tu Megbebayaꞌ, adun menenabi dia. Mukaꞌ duuni sala tawan mendawat buis, midia dadema puꞌ menenabi. ");
INSERT INTO syb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Naa ki Pariseo kia, kaliꞌ pegindeg menenabi, laungen dig dialem ginaanen, ‘Uu Megbebayaꞌ, mekpaladpaladu diniꞌa, puꞌ naan kini, kanaꞌu maaꞌ nug lain getaw, meglimbung, menggulaula melaat, megdusa, saꞌitada maaꞌ nu mendawat buis kinuꞌ. ");
INSERT INTO syb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Puꞌ kada sala simana, meduaꞌu mekpuasa. Adin su sukatu, begayu diniꞌa su kesepuluꞌ ilas dun.’ ");
INSERT INTO syb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Laak dagid su mendawat buis, pegindeg dia melayuꞌlayuꞌ, ndaꞌ tanan pegangag tug langit, sabaꞌ mipatiꞌ mpiid. Pengekdukeneni gegdeben, laungen, ‘Uu Megbebayaꞌ, lelaatay mau, mekesesalaꞌu getaw!’ ");
INSERT INTO syb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Naa,” maaꞌ laung ni Isus, “taluꞌu tuꞌu diniu, ki mendawat buis kia, saꞌ minuliꞌ tug balayen di gendaw kia, mekesuun na di pegitaꞌen nu Megbebayaꞌ. Su sala tawan, ndaꞌ. Puꞌ adin su petaasenenig lawasen, iini pebebaꞌen. Adin dema su pebebaꞌenenig lawasen, iini petaasen.” ");
INSERT INTO syb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Naa pia su nga maikaꞌ gembataꞌ, pinguit nu nga getaw ditu ni Isus, adun pendepenanen ilan. Laak dagid benaꞌ minitaꞌ nu nga sakup ni Isus, pimaag nilani getaw kia. ");
INSERT INTO syb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mendadi si Isus, pibundasen dia niin su nga gembataꞌ, laungen tu nga sakupen, “Ki nga gembataꞌ kiin, petuyang niu ilan mangay dinaan, ndiꞌ niu belibaday. Puꞌ iin laaki mekesakup tu Keglekaunutan nu Megbebayaꞌ, su megimbataꞌ dig betaden. ");
INSERT INTO syb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Taman taluꞌu diniu, ndaꞌi getaw mekesakup tu Keglekaunutan nu Megbebayaꞌ, subay su kesaligen, maꞌniin nu kesalig nu gembataꞌ kini.” ");
INSERT INTO syb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mendadi duuni kaunutan nu getaw Judea suminaak dini Isus, “Sir, mekesuun ka. Naa taꞌ alanduni gempiau penggulaulaan, adun mpedumau tu ketubuꞌ ndaꞌi tamanen?” ");
INSERT INTO syb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Suminaak puliꞌ si Isus di getaw kia, “Baa, mauma dema paingalan mu dinaan, mekesuun? Ndaꞌiduni mekesuun tantu, subay su laak Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Dagid, misuunan mu na ki nga palinta, maꞌniin ‘Ndiꞌa pegdusa, ndiꞌa pekpatay, ndiꞌa pegdaaw, ndiꞌa penakesiꞌ dig balus, pegbesaay mu su ginaꞌ mu buꞌ gamaꞌ mu.’” ");
INSERT INTO syb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Kaliꞌ sembag su kaunutan, “Sir, ki kelaun palinta kia, dinunutan ku genat pa di kaikaꞌayu.” ");
INSERT INTO syb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Laak benaꞌ midengeg ni Isus, kaliꞌ padun pektaluꞌ, “Naa, duun pa gusayi kulang diniꞌa. Peksaluy mu ki kelaun gimu mu, dayun pemegay mu tu nga pubri getaw su galinen. Duun dayuni gaꞌus mu ditu gekbus langit. Dayun puliꞌa dini naan, pegdunuta dinaan.” ");
INSERT INTO syb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Dagid kaliꞌ medengeg nu kaunutan ki tinaluꞌ kia ni Isus, milegenan patiꞌ, puꞌ medatuꞌ gupia getaw iin. ");
INSERT INTO syb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Mendadi, benaꞌ minitaꞌ ni Isus, kaliꞌ pektaluꞌ, “Ki medatuꞌ getaw, melegen tuꞌu ki kesakupen tu Keglekaunutan nu Megbebayaꞌ! ");
INSERT INTO syb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Melemu pa su kebian nu petubuꞌen kamelyu dig luang taiꞌ, sabayaꞌ nu kesakup nu medatuꞌ getaw tu Keglekaunutan nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","“Aba,” laung nu nga mikedengeg tu tinaluꞌ kia ni Isus, “saꞌ maꞌantu, duun bai megawen?” ");
INSERT INTO syb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Kaliꞌ sembag si Isus, “Su ndiꞌ megaga nu kilawan, megaga gusay nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Laak dagid si Pedro, kaliꞌ pektaluꞌ, “Sir, yami kini, pia sug balay nami, bileng na nami gupia, adun megdunut ami diniꞌa!” ");
INSERT INTO syb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","“Waꞌa,” laung ni Isus. “Mukaꞌ taman taluꞌu diniu, adini getaw belengenen sug balayen, saꞌ su sawanen, nga pateden, mekegulangen sampay su ngag bataꞌen, sabaꞌ nu kesakupen tu Keglekaunutan nu Megbebayaꞌ, ");
INSERT INTO syb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","naa nemun, sugdaan dun melaun. Dayun di gendaw kiin ditug binayaꞌ gebii buꞌ gendaw, mpeduma pa pagid tu ketubuꞌ ndaꞌi tamanen.” ");
INSERT INTO syb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Naa sinabi ni Isus su sepuluꞌ buꞌ duaꞌ tawan peneliganen. Benaꞌ ilanilan da laak, kaliꞌ pektaluꞌ si Isus, “Naa, pektalentenay niu gupia ini. Kini, tuad naita tuꞌu di Jerusalem. Mendadi, saꞌ mateng ita dia, naan kini, kig Bataꞌ nu Kilawan, menuud tuꞌu ki kelaun misulat dengantu nu nga pimuunan nu Megbebayaꞌ mekatag dinaan. ");
INSERT INTO syb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Pegwakilu tu nga kanaꞌ getaw Judea, dayun pengimusaunganu nilan, peksudiꞌanu mukaꞌ pendulaꞌanu nilan, ");
INSERT INTO syb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","pembedasen pau nilan pagid. Dayunu petayay. Laak dagid di ketelu endawen genat di kepatayu, metubuꞌu puliꞌ.” ");
INSERT INTO syb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Laak dagid su nga peneligan ni Isus, ndaꞌi misabut nilan di kelaun tinaluꞌen kia. Iglud pa deliꞌ dinilan, kaas ndaꞌ nilan mesuunay su tantu kelebuꞌan nu tinaluꞌen dinilan. ");
INSERT INTO syb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Naa saꞌ misebang si nga Isus dig lunsud Jerico, mitaangan nilan, duunig buta pegingkud dia geksid dalan, menengi limus. ");
INSERT INTO syb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mendadi benaꞌ midengeg nug buta su gelang nu mimegbian kia getaw, sinaaken, “Alandun main?” ");
INSERT INTO syb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Laung nu ngag dumanen, “Megbian na dini si Isus, ki getaw Nazaret kiin.” ");
INSERT INTO syb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Migbeksay dayun sug buta, laungen, “Uu Isus, Sapuꞌa ni David, lelaatay mau!” ");
INSERT INTO syb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Kig buta kia, pigbeluꞌan dayun nu nga getaw pekpanaw di gunaan ni Isus, pimaag nilan sia. Laak palu pa mpemaag, ndiꞌ, minamal mektawag, laungen puliꞌ, “Uu Sir, sapuꞌa ni David, lelaatay mau dema tuꞌu!” ");
INSERT INTO syb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tuminlen dayun si Isus. Piagaken kig buta kia di gupiden. Benaꞌ mesempel diniin, ");
INSERT INTO syb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","sinaak ni Isus, “Taꞌi penengiin mu dinaan?” “Sir, liagan ku sia, mekengitaꞌ nau.” ");
INSERT INTO syb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Miktaluꞌ si Isus, “Mekengitaꞌa na! Miuliꞌan ka na, puun di kesalig mu.” ");
INSERT INTO syb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Lemen laak mitaluꞌ ni Isus, mikengitaꞌ dayun tuꞌu sug buta. Mukaꞌ tumindug dayun dini Isus, pegenalenen su Megbebayaꞌ. Kampuꞌ nu ngag lumaun getaw dia, saꞌ minitaꞌ nilan su mipenggulaula, inal nilan dadema su Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Naa midepet si nga Isus tug lunsud Jerico. Benaꞌ minian ilan dia, mitaanganen ");
INSERT INTO syb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","duuni getaw dia, ngalanen si Saqueo, kaunutan nu nga mendawat buis, kaas medatuꞌ getaw. ");
INSERT INTO syb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Mauyaꞌan ni Saqueo maitaꞌen si Isus, laak ndiꞌ mesuꞌat sabaꞌ kelaun getaw, puꞌ gembabaꞌ getaw si Saqueo kini. ");
INSERT INTO syb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Paladpalad kaliꞌ pegleketau, gumibek tu gunaan ni nga Isus, minaik dayun di gayu sikomoro adun maitaꞌen si Isus, puꞌ mekebian dia. ");
INSERT INTO syb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Mendadi, benaꞌ mitandaꞌ si Isus di gayu kia, migangag dini Saqueo, kaliꞌ pektaluꞌ diniin, “Naa Saqueo, dedaliꞌa penaug, puꞌ subay mapitu mektulug tug balay mu nandaw.” ");
INSERT INTO syb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Naa saꞌ maꞌantu, migdedaliꞌ menaug si Saqueo, didialanen gupia si Isus tug balayen. ");
INSERT INTO syb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Laak benaꞌ minitaꞌ nu nga getaw, linibak nilan dayun si Isus, laung nilan, “Paa, mauma iin, minapit mektulug dig balay nu mekesesalaꞌ getaw?” ");
INSERT INTO syb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Dagid si Saqueo, migindeg, kaliꞌ pektaluꞌ tu Kaunutan, “Mendadi Sir, su seginengaꞌ pimetangu, begayu na tu gempusuk getaw. Mukaꞌ adin sug linimbungan ku, uliꞌen ku dema tuꞌu diniini paat piluꞌ.” ");
INSERT INTO syb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Kaliꞌ sembag si Isus, “Aa naa, saꞌ maꞌniin, minateng na tuꞌu nandaw dinig balay kini ki kegawen nu Megbebayaꞌ, kagina ki getaw kini, sapuꞌ dadema ni Abraham. ");
INSERT INTO syb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Puꞌ naan kini, kig Bataꞌ nu Kilawan, iini luminusadu dun, puꞌ adun penengaun ku ki nga getaw mibeleng, adun guunen ku.” ");
INSERT INTO syb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Naa selian pekineegan nu nga getaw su pekteluꞌenen, duuni sinumpat dun ni Isus sambingay. Puꞌ kagina sungu na mateng tu Jerusalem si Isus, laung dun nu nga getaw, kia na tuꞌu su kesebang nu Keglekaunutan nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kaas miksambingay si Isus, laungen, “Duuni metaas getaw mipanaw di melayuꞌ, puꞌ adun iini metenduꞌ gadiꞌ diag benwanen, dayun muliꞌ. ");
INSERT INTO syb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Mendadi, selian ndaꞌ pa panawi metaas getaw kini, pinsabineni sepuluꞌ tawan sesuguꞌenen. Benaꞌ misabinen ilan, duuni pigwakilen dinilan kwarta bulawan, pikselaad dinilan, kaliꞌ pektaluꞌ dinilan, ‘Kini, penelapiꞌ niu, sampay matengu puliꞌ.’ ");
INSERT INTO syb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Laak dagid su nga samasakupen tug benwa kia, mesengay nilani metaas getaw kini. Kaas saꞌ mipanaw iin, duuni sinuguꞌ nilan meglendug diniin, mangay dadema ditug benwa pegengayanen, pimuunan nilan maꞌniniꞌ. ‘Mpauk ami saꞌ meglegadiꞌ dinamii getaw kia.’ ");
INSERT INTO syb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Laak dagid ki kaunutan kini, mialapen gusayi pegbayaꞌen meglegadiꞌ tug benwa kia. Mendadi benaꞌ minuliꞌ, pinsabinen dayun su nga sesuguꞌenen, su pigwekilanen kiin nu kwarta, adun mesuunanen su gikteb nu tubuꞌen saꞌ pinelapiꞌ nilan. ");
INSERT INTO syb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Benaꞌ misabinen ilan, minadap diniin sug bekna, kaliꞌ pektaluꞌ, ‘Naa Sir, kig bigay mu dinaan kia selaad bulawan, midugangan pa sepuluꞌ laad.’ ");
INSERT INTO syb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“‘Aa naa, melengas!’ laung nu gegalenen. ‘Gempiaa sesuguꞌen! Naa, kagina meseligan ka di maikaꞌ, pebayaꞌu diniꞌa sepuluꞌ lunsudan.’” ");
INSERT INTO syb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Laung ni Isus, “Mendadi, suminukli madap tu kaunutan su keduaꞌ tawanen, kaliꞌ pektaluꞌ, ‘Sir, kig bigay mu dinaan dema, midugangan na lima laad.’ ");
INSERT INTO syb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Laung nu kaunutan, ‘Naa yaꞌa, megbayaꞌa dadema dig lima lunsudan.’ ");
INSERT INTO syb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Laak dagid ki sala tawan pelum, benaꞌ minadap tu gegalen, kaliꞌ pektaluꞌ, ‘Sir, kini da gusayig bulawan mu, pinutusu di panwilu, dayun ku teguꞌay. ");
INSERT INTO syb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Puꞌ mindeku diniꞌa, sabaꞌ metegasig betad mu. Elapen mu su kanaꞌ daniꞌa, geniin mu su ndaꞌ mu dadema pemulanay.’ ");
INSERT INTO syb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“‘Paa,’ simbag nu kaunutan, ‘melaata sesuguꞌen! Ukuman ku yaꞌa pebian di milabuꞌ taluꞌ mu kia! Misuunan mu ba metegasig betadu, elapen ku su kanaꞌ dinaan, dakus geniin ku su ndaꞌu pemulanay? ");
INSERT INTO syb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Naa saꞌ maꞌantu, ki kwartau kiin, mauma pelum ndaꞌ mu betangay dig bangkuꞌ, adun medawatu sia puliꞌ saꞌ mekauliꞌu, kampuꞌ nu tubuꞌen?’ ");
INSERT INTO syb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Liningay dayun nu kaunutan su nga getaw pegindeg dia, laungen dinilan, ‘Awiꞌ niu diniin ki selaad bulawan kiin, begay niu di sala tawan kiin sepuluꞌig daniin.’ ");
INSERT INTO syb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","‘Laak Sir,’ laung nilan, ‘duun naig daniin, sepuluꞌ laad!’ ");
INSERT INTO syb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kaliꞌ sembag su kaunutan, ‘Taluꞌu tuꞌu diniu, adin su getaw duunig daniin, begayan pa padun. Adin pelumi getaw ndaꞌidunig daniin, laak uiꞌen diniin su maikaꞌ sia daniin. ");
INSERT INTO syb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Laak dagid ki nga kuntrau kiin mpauk mesakup di peglegediꞌan ku, naa angay niu, bunuꞌ niu dayun dini gedapan ku!’” ");
INSERT INTO syb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Naa benaꞌ mideksuꞌ si Isus meksambingay, minundas ilan mpanaw, tumiwad nailan tu Jerusalem, miuna si Isus di piktendugan nilan. ");
INSERT INTO syb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mendadi benaꞌ misebang ilan dig duaꞌ maikaꞌ lunsud paingalan dun Betpahe mukaꞌ Betania, dia guksad nug Bentud nu nga Gayu Olibo, suminuguꞌ si Isus dig duaꞌ tawan sakupen. ");
INSERT INTO syb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Laungen dinilan, “Bundas amu dig lunsud kia di gunaan. Mendadi saꞌ mateng amu ditu, duun dayuni maitaꞌ niu petubuꞌen nati asno iniketan, ndaꞌ mainsan sekayay getaw. Naa kiin, ubaday niu, agak niu dayun dini naan. ");
INSERT INTO syb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Naa saꞌ duuni sumaak diniu mauma ubadan niu, iini taluꞌ niu diniin, ‘Duunig baalan dun nu Kaunutan.’” ");
INSERT INTO syb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Naa sa maꞌantu, mipanaw sug duaꞌ tawan sakupen. Benaꞌ midepet ilan tug lunsud kia, mitaangan nilan tuꞌu ki maaꞌ dadema nu tinaluꞌ ni Isus dinilan. ");
INSERT INTO syb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Inubadan nilan dayun su nati asno. Benaꞌ pegubadan nilan, suminaak tuꞌu dinilan su nga gapuꞌen, “Uy, mauma dema ubadan ma niui nati kiin?” ");
INSERT INTO syb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Laung nu nga sakup ni Isus, “Duunig baalan dun nu Kaunutan.” ");
INSERT INTO syb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Mendadi, inagak nilan ditu ni Isus su nati asno. Benaꞌ minateng ilan dia ni Isus, inigan nilan suub nilan sug lekud nug asno, pisakay nilan dun dayun si Isus. ");
INSERT INTO syb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Naa benaꞌ minundas si Isus, peksakay na, mimelat su nga getaw suub nilan dia karsada mbianan ni Isus, basa nilan diniin. ");
INSERT INTO syb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Naa, mesempel na tuꞌu si Isus di Jerusalem, mitandaꞌ na dig dalan pegdiksun diag Bentud nga Gayu Olibo. Mendadi ki kelaun sakupen kia mitendug diniin, pinleliag ilan patiꞌ, minekeg ilan pa pagid megenal tu Megbebayaꞌ, sabaꞌ nu nga mekesalebuꞌ pinggulaula ni Isus minitaꞌ nilan. ");
INSERT INTO syb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Laung nilan, “Melengas pepianan nu Megbebayaꞌ ki Gadiꞌ ta kini minateng na pigwekilan nu Kaunutan Megbebayaꞌ! Melinaw na dema ditu gekbus langit! Pegbesaan su Megbebayaꞌ!” ");
INSERT INTO syb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Laak dagid duun dademai nga Pariseo dia piktendugan nilan. “Sir,” laung nilan, “melengas pemaagen mui nga sakup mu kiin!” ");
INSERT INTO syb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Kaliꞌ sembag si Isus, “Taluꞌu tuꞌu diniu, saꞌ mekeneng ilan nandaw, pia ki ngag batu kia, sumukli menekeg megdedial dinaan!” ");
INSERT INTO syb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Naa misebang na tuꞌu tu Jerusalem si Isus. Mendadi benaꞌ midayagen sug lunsud, mikengaduy si Isus. ");
INSERT INTO syb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Kaliꞌ penembit, “Ay, yaꞌa Jerusalem, saꞌ sia minilala mu dema tuꞌu nandaw kig bian nu keseksud mu tu Megbebayaꞌ! Laak mitebunan nandawi mata mu. ");
INSERT INTO syb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kaas mateng pai gendaw, medending ka nu nga kuntra mu, pektebuꞌan ka nilan, pegbeletan ka padun. ");
INSERT INTO syb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Gebaꞌen nilan dayun tananig lunsud mu, bataꞌ megulangi mpeduma dun. Deksuꞌanen, su ngag batu binaal balay mu, ndaꞌidun nai metentud dun dig dumanen. Naa lumbus itu mpenggulaula, sabaꞌ ndaꞌ mu mailala ki gendaw linaawan ka nu Megbebayaꞌ!” ");
INSERT INTO syb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Naa minangay si Isus tu Pengedapan tu Megbebayaꞌ. Mendadi benaꞌ minateng dia, ki nga mendagang guliden dia, pingutidanen. ");
INSERT INTO syb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Miktaluꞌ si Isus dinilan, “Misulat ditu Taluꞌ nu Megbebayaꞌ, ‘Ki Pengedapan dinaan, balay penenebian.’ Dagid yamu kiin, binaal niu pegegludan ngag limbungan getaw ki Pengedapan kini!” ");
INSERT INTO syb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Naa genat itu, gendawgendaw mekpetuꞌun si Isus dia Pengedapan tu Megbebayaꞌ. Dagid su nga kaunutan nug belian nu getaw Judea mukaꞌ su nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ sampay su ngag duma metaas getaw, minengaw ilan panaw nilan mekpatay dini Isus. ");
INSERT INTO syb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Laak ndiꞌ nilan mesuꞌat, puꞌ sug launan getaw, pekineegan nilan gupia si Isus, mpauk ilan saꞌ duuni sektaang taluꞌen ndiꞌ nilan medengeg. ");
INSERT INTO syb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Naa pekpetuꞌun gusay si Isus di nga getaw ditug Balay Pengedapan tu Megbebayaꞌ, pegukitenen su Gempia Petenday. Mendadi duuni gendaw, ki nga kaunutan nug belian nu getaw Judea mukaꞌ su nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ kampuꞌ nu ngag duma kaunutan nu getaw Judea, minadap ilan dini Isus. ");
INSERT INTO syb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Sinaak nilan diniin, “Naa, taluꞌ mu dinami, ki pinggulaula mu kini, taꞌ bai pegbayaꞌ mu menggulaula dun? Taꞌ taway dun bai migbegay diniꞌa pegbayaꞌ penggulaulaan mu?” ");
INSERT INTO syb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Laung pelum ni Isus dinilan, “Naa, saakan ku amu deliꞌ sektaang. Taluꞌ niu deliꞌ dinaan, ");
INSERT INTO syb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","si Juan kiin, adin genat su pegbayaꞌen memunag tubig tu nga getaw? Genat tu Megbebayaꞌ, saꞌ genat ba laak di kilawan?” ");
INSERT INTO syb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Naa saꞌ maꞌnia, migyagayaga dayuni nga kaunutan kia, laung nilan, “Naa, taꞌ ma? Saꞌ pinenggiꞌ sembagen ta, ‘Su pegbayaꞌ ni Juan, genat tu Megbebayaꞌ,’ naa sumumpat dayun si Isus kini, ‘Saꞌ maꞌantu, mauma dema ndaꞌ niu petuuday si Juan?’ ");
INSERT INTO syb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Saꞌ sembagen ta pasiꞌ, ‘Genat laak di kilawan,’ naa mbuus betuun ita nu kelaun getaw, puꞌ mituudan ilan dun puꞌ pimuunan nu Megbebayaꞌ si Juan.” ");
INSERT INTO syb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kaas iin laaki mesembag nilan dini Isus, “Ndaꞌ nami mesuunay, saꞌ adin genat su pegbayaꞌ ni Juan.” ");
INSERT INTO syb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Laung dayun ni Isus dinilan, “Naa saꞌ maꞌantu, ndiꞌu dadema pesuun diniu saꞌ taꞌi pigenatan nu pegbayaꞌu penggulaulaan kui maꞌnini kini.” ");
INSERT INTO syb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Mendadi, migukit si Isus sambingay tu nga getaw, laungen, “Duuni getaw migimula pegimulanan gubas. Benaꞌ mitubusen pemulanay, pisaꞌupen di nga getaw, dayun mipanaw dig lain benwa, miniben ditu. ");
INSERT INTO syb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Mendadi benaꞌ sumingkuꞌ na su pegimulanan, suminuguꞌ su gapuꞌen tu sala tawan sesuguꞌenen meditu nga saꞌup, puꞌ adun elapenen sug daniin gilas tu nilan. Laak dagid kaliꞌ dateng su sinuguꞌ, aba, binadas nu nga saꞌup dayun piuliꞌ nilan, ndaꞌiduni miwiten pia maikaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Naa su gapuꞌ nu pegimulanan, suminuguꞌ na pelum sala tawan sesuguꞌen. Benaꞌ minateng ditu su sinuguꞌ, binadas dadema nu nga saꞌup, mukaꞌ piksudiꞌan nilan pa pagid, dayun nilan utiday dia, ndaꞌ dademai miwiten. ");
INSERT INTO syb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Naa su gapuꞌ nu pegimulanan, suminuguꞌ pa pelum ketelu tawan sesuguꞌenen. Iin, dinaneg dadema nu nga saꞌup, inutidan nilan pa pagid dia. ");
INSERT INTO syb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Naa saꞌ maꞌantu, laung nu gapuꞌ nu pegimulanan dig dialem delendemanen, ‘Naa, taꞌ maig baalen ku? Aa naa, tumuꞌ iin nai pengain ku ditu, kig bataꞌu na kini, ki petailen ku gupia. Mabuꞌ pegbesaan nilan iin.’ ");
INSERT INTO syb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Laak dagid saꞌ midayag nu nga saꞌup sug bataꞌen kia, miksabutsabut ilan dayun, laung nilan, ‘Aa naa, kiin na tuꞌu sug bataꞌ nu gapuꞌ nu pegimulanan kini. Tumuꞌ petain tain, adun danita na su petenged sia diniin.’ ");
INSERT INTO syb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Mendadi benaꞌ minateng dia nilan kig bataꞌ kini nu gapuꞌ nu pegimulanan, pinatay nilan tuꞌu. “Naa saꞌ maꞌnia,” sinaak ni Isus, “alandun ma dayuni penggulaulaan nu gapuꞌ nu pegimulanan gubas? ");
INSERT INTO syb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Iin nai mangay ditu pegimulananen, adun pemunuꞌenen ki nga saꞌup kia. Dayun lain getaw na pelumi pesaꞌupen tu pegimulananen kia.” Su ngag duma ni Isus, benaꞌ midengeg nilan, laung nilan, “Baa, penensili ndiꞌ da maꞌantui mpenggulaula!” ");
INSERT INTO syb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Dagid pigenlengan ilan ni Isus, sinaakanen ilan, “Dagid saꞌ pinenggiꞌ ndiꞌ mpenggulaula, kendutaꞌ mai kenuud nu sinulat ditu Misulat Taluꞌ nu Megbebayaꞌ, maꞌniniꞌ? ‘Kig batu pimilas nu nga megbaal balay, iini mibaal tampusan gempagen gintudan nug balay.’ ");
INSERT INTO syb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Naa kig batu kini,” maaꞌ laung pa ni Isus, “adin su getaw medapal dun, mbeliꞌan patiꞌ. Saꞌ pasiꞌ melabuꞌ kig batu kini, adin su metenaꞌanen, melasak tananig lawasen.” ");
INSERT INTO syb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Naa ki nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ mukaꞌ su nga kaunutan nug belian nu getaw Judea, benaꞌ midengeg nilani tinaluꞌ kia ni Isus, misimaꞌ nilan puꞌ ilani pisugaten ditu nga saꞌup tu sambingayen kia. Kaas pidaap nilan sia ganam si Isus, laak ndaꞌ nilan megaga daapay, puꞌ mindek ilan tu nga getaw. ");
INSERT INTO syb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Minengaw pa laak ilan sikaw nilan. Mendadi, duuni sinuguꞌ nilan tautau sumaak dini Isus, adun sia metaban nilan di teluꞌenen, adun mbaal sia dangat nilan dini Isus, puꞌ pegwakil nilan sia iin tu pegbayaꞌ nu Gubirnadur. ");
INSERT INTO syb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Mendadi minadap dini Isus su sinuguꞌ, tautau suminaak ilan, “Naa Sir, suunan nami puꞌ pektuꞌun mu su metuud. Ndaꞌi pegisuun mu tu tindeg nu getaw, kaas ndiꞌa mpesuay di metuud, pektuꞌun mu gusay su tantu mauyaꞌan nu Megbebayaꞌ pegbetaden nu getaw. ");
INSERT INTO syb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Naa saꞌ maꞌantu, biwang ba ditu Misulat Palinta nu Megbebayaꞌ, megbuis ita ditu tampusan gadiꞌ nu getaw Roma si Cesar, saꞌ ndaꞌ?” ");
INSERT INTO syb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Dagid misuunan ni Isus puꞌ iini puun nu kesaak nilan diniin kia, su tautau kekesuun nilan. Kaas laungen dinilan, ");
INSERT INTO syb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Paitaꞌ niu deliꞌ dinaan selaad selapiꞌ. Naa, taꞌ taway dun baig lingaw kini? Taꞌ ngalanen bai sinulat dadema dini kini?” Laung nilan, “Dani Cesar.” ");
INSERT INTO syb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kaliꞌ pektaluꞌ si Isus, “Naa saꞌ maꞌantu, kig dani Cesar, bayad da niu diniin. Dayun sug danu Megbebayaꞌ, begay da niu dema ditu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Maꞌantu, ndaꞌ nilan mesuꞌat melaamayi taluꞌ ni Isus di gedapan nu nga getaw. Misebuꞌan ilan ditu simbagen, mipelepeeꞌ laak su getaw sinuguꞌ sumaak diniin. ");
INSERT INTO syb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Naa duun pelumi nga Saduseo mituaꞌ ditu ni Isus. Naa ki nga Saduseo, ilan kinii sala pikumpungan ndiꞌ ilan metuudan dun puꞌ su nga minatay, metubuꞌ daw puliꞌ. ");
INSERT INTO syb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Mendadi, kaliꞌ ilan pembaalbaal sumaak dini Isus, “Naa Sir, duuni palinta dinita pisulat nu Megbebayaꞌ dini Moises, ‘Saꞌ daw matayig laki mikenginsawa na, laak ndaꞌidunig bataꞌen, naa subay sukliin nu pated nu minatay. Iini menginsawa tug balulibun, adun duunig bataꞌ nilan, lepeng bataꞌ nu minatay kitu.’ ");
INSERT INTO syb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Mendadi, duuni pitu tawan mekpated. Minginsawa su gulangbataꞌ, dayun minatay, ndaꞌidun paig bataꞌen. ");
INSERT INTO syb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Dayun su keduaꞌ pateden pelum, pinginsawanen sug balulibun dayun minatay, ");
INSERT INTO syb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","dakus su ketelu pateden dadema. Iin nai migbatag, gikteb nu pitu tawan kia, lumbus minatay, ndaꞌidun da gusayig bataꞌen. ");
INSERT INTO syb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Dayun sug libun, minatay dadema. ");
INSERT INTO syb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Naa paladpalad saꞌ duun siai metubuꞌ daw puliꞌ genat matay, naa kig libun kia, adin ma dayuni sawanen ditu pitu tawan kia, kagina migelaꞌ ma mayan mpenginsawa nu mekpated kia?” ");
INSERT INTO syb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Laak dagid kaliꞌ sembag si Isus, “Baa, su kilawan pa nemun, libun laki, meksenlangan pa. ");
INSERT INTO syb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Laak su getaw mipemilang bantang medepet ditu gekbus langit di gendaw kiin ditug binayaꞌ gebii buꞌ gendaw, ki mitubuꞌ puliꞌ genat matay, naa ilan, ndiꞌ nailan meksenlangan. ");
INSERT INTO syb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ndiꞌ nailan mesuꞌat matay puliꞌ, segaga mesama ilan ditu nga sesuguꞌen nu Megbebayaꞌ getaw langit. Maꞌantu, bataꞌ nailan tuꞌu nu Megbebayaꞌ, kagina ki gasal nilan, mipeduma nailan di ketubuꞌ puliꞌ nu nga minatay. ");
INSERT INTO syb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mukaꞌ pa padun, petubuꞌen daan puliꞌ tuꞌu su nga minatay, puꞌ pia si Moises, tinakesiꞌanen dadema puꞌ metuud. Puꞌ ditu sinulat ni Moises dengantu mekatag di sigbet kiin migligaꞌ, iini piningalan dun ni Moises su Kaunutan ta, su Megbebayaꞌ pektemuyen ni Abraham, pektemuyen ni Isaac, mukaꞌ ni Jacob.” ");
INSERT INTO syb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kaliꞌ gusay pektaluꞌ si Isus, “Naa misuunan ta, iini mektamuy tu Megbebayaꞌ su getaw tetubuꞌ, kanaꞌ nu nga minatay. Mekatag di Megbebayaꞌ, ndaꞌi minatay, lumbus tetubuꞌi getaw.” ");
INSERT INTO syb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Saꞌ maꞌantu, kaliꞌ sembag dini Isusig duma mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, “Naa Sir, misugatan mui tinaluꞌ mu kia!” ");
INSERT INTO syb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Puꞌ ndiꞌ na nilan mesuang sumaak puliꞌ diniin. ");
INSERT INTO syb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Mendadi, kaliꞌ pelum saak si Isus tu nga Saduseo kia, “Mauma dema maꞌniniꞌi pekteluꞌen nu getaw? Ki gasal nu Tinduꞌ nu Megbebayaꞌ Meglekaunutan, laung nilan sapuꞌ laak daw ni David. ");
INSERT INTO syb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Naa, mauma dema maꞌniaig laung nilan, asa si David, iin na gupiai suminulat dun, ditu sala pisulat nu Megbebayaꞌ piningalan dun ngag Bebat, maꞌniniꞌ? ‘Tinaluꞌ nu Kaunutan Megbebayaꞌ ditu Kaunutan ku, Pegingkuda di gupidu, dini dapit lintuu, ");
INSERT INTO syb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","sampay di gendaw pelebaun ku yaꞌa daagen mu su nga kuntra mu.’” ");
INSERT INTO syb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Suminaak na puliꞌ si Isus dinilan, “Kaas ki Tinduꞌ nu Megbebayaꞌ Meglekaunutan, gilal ni David Kaunutan. Mendadi kagina maꞌantu, ki gasalen, sapuꞌ ba laak ni David?” ");
INSERT INTO syb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Naa miktituluꞌ si Isus tu nga sakupen di gedapan nu melaun getaw. ");
INSERT INTO syb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Mendadi, kaliꞌ pektaluꞌ, “Peglengilam amu, adun ndiꞌ amu megelinan nug betad nu nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, ki nga meliag mekpanawpanaw mekseluuk melambak suub, sampay mauyaꞌan nilan pegbesaan ilan nu getaw tu nga tebuꞌan. Mukaꞌ saꞌ ditu ilan keglekebibu, pemiliꞌen nilan su pegingkudan nu pegbesaan getaw. Mesama dia simbaan, pemiliꞌen nilan su tampusan metaas gingkudan. ");
INSERT INTO syb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Mukaꞌ padun, peglimbungan nilani ngag balulibun, mengagaw ilan tu pimetang nilan, asa petaasen nilan su kenenabi nilan, pekpaitaꞌitaꞌ laak nilan. Naa maꞌnia, midugangan dema tuꞌui kebegat nu ginukuman ditu nga mekpetuꞌun di Palinta kiin!” ");
INSERT INTO syb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tubus nituꞌ ndaꞌ maiben, kaliꞌ tingag si Isus, minitaꞌeni nga medatuꞌ getaw, migbegay ilan gamut nilan tug Balay kia Pengedapan tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Duun pagidi minitaꞌ ni Isus balulibun, pubri gupia, migbetang dadema gamuten, laak duaꞌ laad sinsilyu. ");
INSERT INTO syb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kaliꞌ pektaluꞌ si Isus, “Taman taluꞌu diniu, ki pubri kini balulibun, gembagel pai ginamuten kiin, sabayaꞌ su ginamut nu nga kelaun getaw dini. ");
INSERT INTO syb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Puꞌ sug duma getaw, ginamuten su laak kapin nu gimunen. Dagid kig balulibun kini, pia pubri gupia, gilaꞌen da gusay begay sug bataꞌ misukaten.” ");
INSERT INTO syb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Naa pegyegaan nu ngag duma ni Isus kig Balay kia Pengedapan tu Megbebayaꞌ, mesibaꞌ laungi nga pengimbaalanen batu, sampay su nga pekayan dig Balay pimegay nu nga getaw. ");
INSERT INTO syb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Dagid miktaluꞌ si Isus, “Naa, kig launanen kini maitaꞌ pa niu nandaw, duuni gendaw mateng, pia salabuuk batu di kitentudanen, ndaꞌiduni mesamaꞌ dun, megelaꞌ gupia penggebaꞌay.” ");
INSERT INTO syb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mendadi suminaak dini Isus su nga sakupen, “Naa saꞌ mesuꞌat, Sir, pesuun mu dinami, nanu ma mpenggulaula? Mukaꞌ alanduni tuꞌusan dun saꞌ sungu na menuudi tinaluꞌ mu kiin?” ");
INSERT INTO syb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Sumimbag si Isus, “Naa, peglengilam amu, adun ndiꞌ amu melimbungan nu getaw. Puꞌ melaun metuaꞌ, engkenen nilani gelalu, laungen, ‘Naani Tinduꞌ nu Megbebayaꞌ Meglekaunutan!’ Mukaꞌ teluꞌen nilan pagid, ‘Meglekaunutan na tuꞌu su Megbebayaꞌ!’ Naa kiin, ndiꞌ niu dema tuꞌu pegdunutay. ");
INSERT INTO syb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mukaꞌ pagid saꞌ duuni medengeg niui pegbunuꞌ mukaꞌ sasaw, ndiꞌ amu mendek dun. Puꞌ subay mauna mpenggulaula itu, laak kanaꞌ paini kelengkeb nug benwa.” ");
INSERT INTO syb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kaliꞌ gusay pektaluꞌ si Isus, “Su sala nasud, lumumpak daan dig lain nasud. Su sala peglegediꞌan, lumumpak dig lain peglegediꞌan. ");
INSERT INTO syb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mukaꞌ duuni ngag linug metikteg, dakus mian pa pagidi meliget gutem mukaꞌ nga pelabuꞌ di tibuuk benwa. Melaun dademai mekendekendek penggulaula mukaꞌ mekesalebuꞌ tuꞌus dig langit. ");
INSERT INTO syb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Laak dagid dekag pa mpenggulaulaig launanen kini, daapen amu nu nga getaw, peglegetan amu dayun. Dengaten amu tu nga simbaan nu getaw Judea, dayun amu pirisuay. Dengaten damu dema di gedapan nu nga gadiꞌ mukaꞌ duma kaunutan, sabaꞌ nu kesakup niu dinaan. ");
INSERT INTO syb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mendadi su sembag niu dun, iini mbaal sikaw niu megukit di Gempia Petenday. ");
INSERT INTO syb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","“Kaas buklus niui ginaa niu,” laung pa ni Isus, “di ndiꞌ niu pegdelendemen pedaan ki sembag niu. ");
INSERT INTO syb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Saꞌ pensaakan namu, naan nai megbegay diniu tinawan niu sumbag dun. Kaas ndaꞌidun tanani kuntra niu mekepemilas tu teluꞌen niu, ndiꞌ damu dema nilan mpebalus. ");
INSERT INTO syb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Laak dagid pia pa su nga mekegulang niu, su nga pated niu, su ngag betaꞌan niu mukaꞌ su nga sambat niu, pegwakil amu nilan tu nga kuntra niu. Mukaꞌ meksimawiꞌ ilan di ngag duma diniu ki petain. ");
INSERT INTO syb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Bentaan amu nu kelaun getaw sabaꞌ nu kesakup niu dinaan. ");
INSERT INTO syb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Laak dagid pia maꞌantu, pia sebalu dig buuk niu, ndaꞌiduni mekaꞌidan. ");
INSERT INTO syb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mendadi saꞌ mektigel amu, mpeduma amu tu ketubuꞌ ndaꞌi tamanen.” ");
INSERT INTO syb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Laung pagid ni Isus, “Naa ki Jerusalem kini, maitaꞌ pa niu pegbeletan sundalu. Saꞌ maitaꞌ na niu, mesuunan niu puꞌ sungu na pelengay gapuyig lunsud. ");
INSERT INTO syb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mendadi saꞌ mpemaꞌniin na, su nga getaw dini Judea, subay meglaguy tu ngag binentudan. Adin su getaw metaang dig dialem lunsud kini, subay guaꞌ. Adin su getaw metaang dia mektabuꞌ benwa, ndiꞌ pia medinig lunsud. ");
INSERT INTO syb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Puꞌ kiin na tuꞌu ki Gendaw nu Ginukuman nu Megbebayaꞌ, ki gendaw nu kenuud tuꞌu nu kelaun sinulat ditu Taluꞌ nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Naa sug libun, saꞌ metaang dig bedesanen ki gendaw kiin, mukaꞌ mesama su pegduduꞌan pa, aa, mekelelaatlelaat ilan gupia! Puꞌ mbianan meliget kelegenayig dibabaw lumbang kini. Kig bansa kini, melebuꞌan nu ginukuman nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Duuni pembunuꞌen, duun dademai pendaapen, dayun uitay mesigwag tu kelaun benwa. Ki Jerusalem kini, peglaatan nu nga kanaꞌ getaw Judea, sampay da dun metektak su pegbayaꞌ nug lain bansa dig lunsud kini.” ");
INSERT INTO syb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Kaliꞌ padun pektaluꞌ si Isus, “Mukaꞌ duun pai nga mekesalebuꞌ tuꞌus ditu mata gendaw, ditug bulan, mukaꞌ ditu ngag bitun. Melegenan dun patiꞌ su ngag bansa dig dibabaw lumbang, sabaꞌ nu kesebuꞌay nilan tug deguk nug dagat sampay tu medekdes kegbelulun nu nga nabek. ");
INSERT INTO syb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Memegdaan su nga kilawan sabaꞌ nu gendek nilan dakus su kededuaꞌay nu ginaa nilan ditu nga sungu mpenggulaula di tibuuk lumbang. Puꞌ su kelaun mibetang ditu gawanawan, mekegyugegyug. ");
INSERT INTO syb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Naa mendadi saꞌ menuud naig launanen, naan kini, kig Bataꞌ nu Kilawan, medayag nau tuꞌu, metuaꞌu di gabun, medayag na su ginuungu mukaꞌ maitaꞌ di tiagu su kelengas nu metaas pegbayaꞌu. ");
INSERT INTO syb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kaas saꞌ maitaꞌ na niu kini mekpuun na menuud, naa pegindeg amu, ndiꞌ amu dega pegdungguꞌ, dedialay niu ki kenlekat diniu, puꞌ mesebang na tuꞌu.” ");
INSERT INTO syb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Naa miksambingay si Isus tu nga sakupen, laungen, “Naa pegdelendem niu ki gayu igera, dakus sug duma gayu. ");
INSERT INTO syb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Saꞌ maitaꞌ niu su gayu megbegu daun, mesuunan niu puꞌ sungu na memedesig benwa. ");
INSERT INTO syb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Naa maꞌantu dadema, saꞌ maitaꞌ niui nga gempenggulaula kini, mesuunan da niu dema puꞌ sungu na tuꞌu meglekaunutan su Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Diksuꞌ ni Isus su taluꞌen, “Taman taluꞌu diniu, ndiꞌ tagad mematay su nga getaw tetubuꞌ nemun, megelaꞌ na menuudig launanen kini. ");
INSERT INTO syb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Puꞌ su gekleb langit buꞌ lupaꞌ, megelaꞌ da mbeleng. Laak dagid ki pekteluꞌen ku kini, ndaꞌi kebelengen.” ");
INSERT INTO syb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Kaliꞌ gusay pektaluꞌ si Isus, “Mendadi, pektalenten amu, adun ndiꞌ megelaꞌig delendeman niu di keglekebibu niu milebianan, mukaꞌ di kegbebulek niu, sampay su kelibuleng niu di ketubuꞌay niu. Puꞌ mbuus metekawan amu di Gendaw kiin, gitunganen su metaban giman. ");
INSERT INTO syb_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Puꞌ ki Gendaw kiin, metekaw gupiai kesebangen di tibaꞌan getaw dig dibabaw lumbang. ");
INSERT INTO syb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kaas pegenduk amu lelayun, dunut penenabi amu, adun metigel niu ki kelaun mpenggulaula kitu, mukaꞌ ndiꞌ damu dema mpiid madap dinaan kini, kig Bataꞌ nu Kilawan, di kelusadu puliꞌ.” ");
INSERT INTO syb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Maꞌantu, gendawgendaw pekpetuꞌun si Isus dia Pengedapan tu Megbebayaꞌ. Laak saꞌ lelabung, megawaꞌ na puliꞌ dia Jerusalem, mangay pa mengintulugan ditug Bentud nu nga Gayu Olibo. ");
INSERT INTO syb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Su melaun getaw, gendawgendaw melapus mekpungun ditu Pengedapan, puꞌ adun mekineeg dini Isus. ");
INSERT INTO syb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Maꞌantu, sungu na mekpuun sug lumpuk nu nga getaw Judea, sug Lumpuk di Pan ndaꞌ Petulinay, sala ngalanen sug Lumpuk tug Liniusan. ");
INSERT INTO syb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Mendadi ki nga kaunutan nug belian nu getaw Judea mukaꞌ ki nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ, minengaw ilan suꞌatan nilan di kepatay nilan dini Isus, puꞌ mendek ilan, mbuus mesasaw su nga getaw. ");
INSERT INTO syb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Mendadi kini si Judas Iscariote, sala tawan di nga sepuluꞌ buꞌ duaꞌ peneligan ni Isus, pingepuꞌan ni Satanas. ");
INSERT INTO syb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Benaꞌ pingepuꞌan si Judas, linaawanen ki nga kaunutan nug belian kia mukaꞌ ki nga kaunutan nu pegingat tu Pengedapan tu Megbebayaꞌ, adun pegyegaan nilan ki melengas bianan ni Judas, tipuunen dinilan si Isus. ");
INSERT INTO syb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Mendadi, benaꞌ mikitaꞌ ilan, aa naa, didialan nu nga kaunutan si Judas. Pisadan nilan dayun si Judas, tindanan nilan iin selapiꞌ. ");
INSERT INTO syb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Sinanguꞌ dema ni Judas su sabut nilan. Kaas genat itu, si Judas kini, piksuꞌatsuꞌaten dayuni sikawen tumipu dini Isus, laak ndiꞌ mekpailagilag tu melaun getaw. ");
INSERT INTO syb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mendadi, minateng su gendaw nug Lumpuk di Pan ndaꞌ Petulinay, metaang dun sug betad nu nga getaw Judea mektitiꞌ nati karniru, guliden nilan tu Megbebayaꞌ gindan nilan tug Liniusan. ");
INSERT INTO syb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Mendadi sinuguꞌ ni Isus si Pedro buꞌ si Juan, laungen dinilan, “Panaw amu, pegulingel niu kig Lebungan ta tug Liniusan.” ");
INSERT INTO syb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Kaliꞌ ilan saak, “Adin mu ami paulingelay?” ");
INSERT INTO syb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Kaliꞌ sembag si Isus, “Naa maꞌniniꞌ. Saꞌ mateng amu ditu syudad, duun dayunig laki mesungkak niu, pekpisan bandi bitangan tubig. Iini tendugay niu, dunutay niu tug balay seledanen. ");
INSERT INTO syb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Naa saꞌ metulan amu, taluꞌ niu dayun ditu gapuꞌ balay, ‘Naa pimuun nu Mekpetuꞌun, laungen, Adin dapit su sugud pengaanan nami tug Lebungan tug Liniusan, yami nu nga sakupu?’ ");
INSERT INTO syb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Naa saꞌ maꞌnia,” laung ni Isus, “paitaꞌen dayun diniu ki gembagel sugud dia dapit ditaas, misangkap na. Dia na niu pegulingelayig Lebungan ta.” ");
INSERT INTO syb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mipanaw dayun si Pedro buꞌ si Juan, mukaꞌ midetengan nilan tuꞌu, maaꞌ dadema nu tinaluꞌ ni Isus. Pigulingel nilan dayun dia sug Lebungan nilan tug Liniusan. ");
INSERT INTO syb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Naa benaꞌ mitektak na sug Lebungan tug Liniusan, migingkud maan si Isus, ilan nu nga peneliganen. ");
INSERT INTO syb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Mendadi kaliꞌ pektaluꞌ si Isus dia nga peneliganen, “Aa naa, kini na su pedetengen ku gupia, meksalu ita maan dig Lebungan tug Liniusan kini, dekag pau mekebian dig lesayan ku! ");
INSERT INTO syb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Puꞌ taluꞌu tuꞌu diniu, ndiꞌ nau puliꞌ maan dun, sampay da dun di gendaw mekpalas na ki tantu Lumpuk tug Liniusan, saꞌ meglekaunutan na tuꞌu su Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Naa saꞌ maꞌantu, minalap si Isus sala tasa penginumen. Benaꞌ mikpaladpalad tu Megbebayaꞌ, kaliꞌ pektaluꞌ dia nga sakupen, “Tabuk niu ini, pekilasilas niu inumay. ");
INSERT INTO syb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mendadi taluꞌu tuꞌu diniu, genat nandaw, ndiꞌ nau puliꞌ minum di penginumen kini, sampay da dun mateng su gendaw meglekaunutan na tuꞌu su Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Minalap pelum si Isus pan. Benaꞌ mikpaladpalad na puliꞌ tu Megbebayaꞌ, pimetanen dayun su pan, dayunen pentulunay dia nga peneliganen. Kaliꞌ pektaluꞌ, “Naa, kini sug lawasu, ki begayu gumantiꞌ diniu. Kini, aan niu lelayun, puꞌ adun medelendem niau.” ");
INSERT INTO syb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Naa maꞌnia dadema, benaꞌ mitubus ilan maan, minalap pelum si Isus sala tasa penginumen, dunut tinaluꞌen, “Ki penginumen kini, iin sug duguꞌu, ki mekigis na, adun gugas tu salaꞌ niu. Kig duguꞌuig bian nug begu pasad nu Megbebayaꞌ tu getaw. ");
INSERT INTO syb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Dagid bentayay pa daan niu!” laung pa ni Isus. “Ki getaw mektipu dinaan, suminalu gupia dinaan maan kini! ");
INSERT INTO syb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Puꞌ naan kini, kig Bataꞌ nu Kilawan, mbinasau tuꞌu, maaꞌ dadema nu pigdelendem pedaan nu Megbebayaꞌ. Laak dagid pia maꞌantu, ki getaw mektipu dinaan, mekelelaatlelaat gupia!” ");
INSERT INTO syb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Naa saꞌ maꞌantu, kaliꞌ medengeg nu peneligan ni Isusi tinaluꞌen kia, miksinaakay ilan dayun, saꞌ adin saan getaw dinilani mekenggulaula di maꞌnia kia. ");
INSERT INTO syb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Naa su nga peneligan ni Isus, miksual ilan, saꞌ taꞌ taway dun dinilani tampusan metaasi tindegen. ");
INSERT INTO syb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Dagid kaliꞌ pektaluꞌ si Isus dinilan, “Naa su nga kanaꞌ getaw Judea, metegasi kegbayaꞌ dinilan nu nga gadiꞌ nilan. Mukaꞌ su nga kaunutan nilan, engkenen nilan su gelal Pegengagen, laung, nu nga sakup nilan. ");
INSERT INTO syb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Dagid yamu, ndiꞌ amu mpia mengmaꞌantu. Sinangkaliꞌ adini tampusan metaasi tindegen diniu, subay iin nai mbaal maaꞌ nu tampusan ngudan. Ki kaunutan diniu padun, subay mbaal maaꞌ nu sesuguꞌen. ");
INSERT INTO syb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Puꞌ maꞌniniꞌ. Adin ba su metaas, su pegingkud maan, saꞌ su megilak diniin? Kanaꞌ ba su pegingkud maan? Laak dagid pia naan, keni nau, maꞌniin sesuguꞌen niau.” ");
INSERT INTO syb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Laung pa ni Isus tu nga peneliganen, “Naa yamui miksaliunung dinaan, pia di nga kengindan dinaan. ");
INSERT INTO syb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Naa kagina mitenduꞌu nu Gamaꞌu meglekaunutan, naa yamu, tenduꞌen ku amu pa pagid, meglekaunutan damu dema. ");
INSERT INTO syb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Maꞌantu, duuni gendaw meksalu ita maan buꞌ minum ditu Keglekaunutan ku, mukaꞌ padun mingkud damu dema mengukum tu nga sepuluꞌ buꞌ duaꞌ bansa nu getaw Israel.” ");
INSERT INTO syb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kaliꞌ pektaluꞌ si Isus dini Simon Pedro, “Simon, pekineega! Si Satanas, migubug tu Megbebayaꞌ mekpalid diniu, maaꞌ nu kepalid di trigo, adun mpaini melaaten di gempia. ");
INSERT INTO syb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Dagid pinenebian ku yaꞌa, Pedro, adun ndiꞌ mbeleng ki kekpetuud mu. Mendadi saꞌ meksikesuun ka na puliꞌ, pepagen mu dayun su kekpetuud nu nga mimated diniꞌa kini.” ");
INSERT INTO syb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Kaliꞌ sembag si Pedro, “Aba, Sir, penensili mpirisua, sampay petain ka, minuyaꞌ nau meksaliunung diniꞌa!” ");
INSERT INTO syb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Kaliꞌ pektaluꞌ si Isus, “Pedro, taluꞌu diniꞌa, dekag pasiꞌ peguni su manuk gebii kini, metelu deksuꞌa na memalaw puꞌ kanaꞌ mau mailala.” ");
INSERT INTO syb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kaliꞌ pagid pektaluꞌ si Isus, “Naa su sinuguꞌu amu mpanaw kitu, ki ndaꞌi giwit niu pitaka, gambag, dakus ndaꞌi sepatus niu kitu, duun bai kulang niu?” “Ndaꞌidun,” laung nilan. ");
INSERT INTO syb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Dagid genat nandaw,” laung padun ni Isus, “adin diniuig duuni pitakanen, subay uitenen, sampay gambag. Mukaꞌ adini ndaꞌidunig badungen, subay peksaluyen su suuben, adun mekesaluy badung. ");
INSERT INTO syb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Puꞌ taluꞌu diniu, subay menuud dinaan ki misulat ditu Taluꞌ nu Megbebayaꞌ, laung, ‘Iin, mipemilang melaat getaw.’” Diksuꞌ ni Isus su tinaluꞌen, “Adin su misulat pedaan mekatag dinaan, megelaꞌ na tuꞌu menuud.” ");
INSERT INTO syb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kaliꞌ sembag su nga sakupen, “Naa, Sir, kiniig duaꞌ buuk badung!” Simbag ni Isus, “Sukal naini.” ");
INSERT INTO syb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Gumiwaꞌ dia si Isus, tumiwad dayun tug Bentud nu nga Gayu Olibo, maaꞌ dadema nug betaden, migdunut dadema diniin su nga sakupen. ");
INSERT INTO syb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Benaꞌ minateng ilan diag bentud, kaliꞌ pektaluꞌ si Isus tu nga sakupen, “Penenabi amu, adun ndiꞌ amu mpenulay.” ");
INSERT INTO syb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Naa sumiway deliꞌ si Isus dia nga sakupen, minundas dia gunaan, maꞌniin layuꞌ nu mesampet piglak, dayun minginlulud menenabi. ");
INSERT INTO syb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Kaliꞌ pektaluꞌ, “Uu Amaꞌ, saꞌ sia mesuꞌat diniꞌa, ki tasa mipenuꞌ nug lesayan ku sunguu na inumay, naa peliaw mu sia dinaan, adun ndiꞌu na mainum. Laak dagid, Amaꞌ, sug daniꞌa mauyaꞌan, iini penuuden, kanaꞌ nug danaan.” ");
INSERT INTO syb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tubus itu, duuni mituaꞌ dini Isus sesuguꞌen nu Megbebayaꞌ genat tu gekbus langit, dinuganganen su sekegen. ");
INSERT INTO syb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Minamal gusay si Isus menenabi, sabaꞌ mibegatan patiꞌi ginaanen. Inulasan patiꞌ, maꞌniin duguꞌi gulasen mitegduꞌ diag lupaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Naa saꞌ maꞌnia, benaꞌ migbuat si Isus genat menenabi, pinuliꞌanen su nga sakupen kia. Midetenganen, tinulug ilan, melubay ilan sabaꞌ nu kelegenay nilan. ");
INSERT INTO syb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Sinabinen ilan dayun, laungen, “Baa, mauma dema tinulug amu? Pegbuat amu, penenabi amu daan, adun ndiꞌ amu mpenulay.” ");
INSERT INTO syb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Naa ndaꞌ pa medeksuꞌ mektaluꞌ si Isus, miksebangi melaun getaw. Iini pekpenuluꞌ dinilan si Judas, ki sala tawan kiin di sepuluꞌ buꞌ duaꞌ peneligan ni Isus. Mendadi, benaꞌ minateng ilan dia, kini si Judas, tuminuun dayun madap dini Isus, dunut ilekanen. ");
INSERT INTO syb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Laung ni Isus, “Naa, Judas, galek masiꞌi tipu mu dig Bataꞌ nu Kilawan?” ");
INSERT INTO syb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Naa su ngag duma ni Isus, benaꞌ misimaꞌ nilan su sungu mpenggulaula, sinaak nilan, “Naa, Sir, bekuten na namiig badung nami?” ");
INSERT INTO syb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Dayun sala tawan dinilan, tinigbaseni gulipen nu Tampusan Metaas Belian nu getaw Judea. Miseksipi sedibaluy telinganen, dapit lintunen. ");
INSERT INTO syb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Dagid laung ni Isus, “Baa, sukal na!” Dayunen depenayi telinganen, piuliꞌaneni gulipen kia. ");
INSERT INTO syb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Naa ki nga getaw kini minangay dumaap dini Isus, ilani nga kaunutan nug belian, mukaꞌ duun dademai nga kaunutan nu pegingat tu Pengedapan tu Megbebayaꞌ, dakus ngag duma kaunutan nu getaw Judea. Miktaluꞌ dayun si Isus dinilan, “Naa, tulisan bau, kambat amu meguit badung mukaꞌ bentul saꞌ daapen niau? ");
INSERT INTO syb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Asa gendawgendaw, naanig duma niu dia Pengedapan, laak ndaꞌ niau daapay. Dagid minateng daan tuꞌui pegbayaꞌ niu, ki pegbayaꞌ nu medelem.” ");
INSERT INTO syb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dinaap dayun si Isus. Benaꞌ midaap, inagak dayun ditug balay nu Tampusan Metaas Belian nu getaw Judea. Naa kini si Pedro, miglendug dadema di melayuꞌlayuꞌ. ");
INSERT INTO syb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Benaꞌ minateng ilan diag lenuꞌan nug balay, duuni gapuy inuklak dia. Luminamug dayun si Pedro di nga getaw pemegingkud menalang dia gapuy. ");
INSERT INTO syb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mendadi, duuni sala tawan delaga dia, sesuguꞌen diag balay kia. Benaꞌ minitaꞌ nug delaga si Pedro pegingkud dia, midelagan nu gapuy, ilelaanen gupia, kaliꞌ pektaluꞌ, “Uy, ki getaw kini, duma pagid ni Isus!” ");
INSERT INTO syb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Dagid mimalaw si Pedro. “Baa, Enaung,” laungen, “ndiꞌu mailala ki getaw kiin!” ");
INSERT INTO syb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tubus nituꞌ ndaꞌ maiben, duunig duma getaw mikaitaꞌ dini Pedro. Kaliꞌ pektaluꞌ, “Aa, yaꞌa, dumaa ma nilan dema!” “Baa, kanaꞌ lai!” laung ni Pedro. ");
INSERT INTO syb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Naa benaꞌ duun saani sauras, duun pelumi sala tawan miglegintuud mektaluꞌ, “Naa, ki getaw kini, minget tendug lai tuꞌu ni Isus, puꞌ getaw Galilea ma dema!” ");
INSERT INTO syb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Dagid sumimbag si Pedro, “Apelii lai, ki teluꞌen mu kiin, ndiꞌu lai mesabut!” Mendadi, ndaꞌ pa medeksuꞌ mektaluꞌ si Pedro, iin na demai keguni manuk. ");
INSERT INTO syb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Dekag su Kaunutan, luminingay dini Pedro, dayun pingenlenganen. Milabuꞌ dayun dig delendeman ni Pedro su tinaluꞌ kiin nu Kaunutan, laungen, “Dekag pasiꞌ peguni su manuk gebii kini, metelu deksuꞌa na memalaw puꞌ kanaꞌ mau mailala.” ");
INSERT INTO syb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Gumiwaꞌ dayun dia si Pedro, lilugutan dayun mengaduy. ");
INSERT INTO syb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Naa su nga pegingat dini Isus kia, pingimusaungan nilan iin mukaꞌ dinaneg nilan. ");
INSERT INTO syb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tinimpeng nilan pagidi mata ni Isus, kaliꞌ ilan pektaluꞌ diniin, “Naa, saꞌ sia metuud puꞌ suunan ka, atuk mu saꞌ taꞌ taway dun dinamii mikpesait diniꞌa!” ");
INSERT INTO syb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Dayun melaun pa paduni kegimusaung nilan dini Isus. ");
INSERT INTO syb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mendadi benaꞌ putiꞌ delagay na, mikpungun ki nga kaunutan nu getaw Judea, kampuꞌ nu nga kaunutan nug belian nilan mukaꞌ su nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ. Benaꞌ mipungun ilan, inagak dayun si Isus ditu gedapan nu Pikumpungan nu Metaas Gukum nu getaw Judea. ");
INSERT INTO syb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Mendadi benaꞌ mideksaꞌ dia Pikumpungan nu nga Gukum si Isus, migbaalbaal sumaak diniin su nga gukum, laung nilan, “Mendadi, pemantek mu na dinami, yaꞌa ba tuꞌu su Tinduꞌ nu Megbebayaꞌ Meglekaunutan?” Kaliꞌ sembag si Isus, “Saꞌ taluꞌu diniu, ndiꞌ amu metuudan dun. ");
INSERT INTO syb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Saꞌ sumaaku diniu, ndiꞌ niau sembagen. ");
INSERT INTO syb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Laak dagid genat nandaw, naan kini, kig Bataꞌ nu Kilawan, pegingkudu tuꞌu ditu dapit lintu nu Megbebayaꞌ, su Tampusan Ginuungan.” ");
INSERT INTO syb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Migdengan dayun su nga gukum membaalbaal saak dini Isus, laung nilan, “Naa kumalenged maꞌantu, taꞌ itu, yaꞌa ba tuꞌu kig Bataꞌ nu Megbebayaꞌ?” Sumimbag si Isus, “Naa, maꞌnia da, yamui miktaluꞌ dun.” ");
INSERT INTO syb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","“Paa,” laung dayun nu nga gukum, “ndiꞌ ta na kambat duganganig dangat diniin! Puꞌ midengeg ta na kini dig babaꞌen gupia!” ");
INSERT INTO syb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Naa mendadi ki Pikumpungan kia nu Metaas Gukum nu getaw Judea, migdengan ilan megbuat, dayun nilan egakay si Isus ditu gubirnadur, si Pilato. Benaꞌ ditu ilan gedapan ni Pilato, ");
INSERT INTO syb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","binukaꞌ nilan dayun sug dangat nilan dini Isus, kaliꞌ ilan pektaluꞌ, “Ki getaw kini, mitaangan nami pesuainen sug delendeman nug bansa nami di gubirnu. Pektituluꞌanen su nga getaw, ndiꞌ nailan megbegay buis daw ditu tampusan gadiꞌ si Cesar, mukaꞌ engkenenen pa pagid puꞌ iin su Tinduꞌ nu Megbebayaꞌ Meglekaunutan, saꞌitada gadiꞌ daw iin.” ");
INSERT INTO syb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Mendadi, suminaak si Pilato dini Isus, “Naa, metuud ba, yaꞌa su gadiꞌ nu getaw Judea?” Kaliꞌ sembag si Isus, “Yaꞌa mai miktaluꞌ dun.” ");
INSERT INTO syb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kaliꞌ pektaluꞌ si Pilato tu nga kaunutan nug belian dakus tu melaun getaw, “Ki getaw kini, ndaꞌiduni misimaꞌu kepemilasen tug balaꞌud.” ");
INSERT INTO syb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Minamal laak dumangat dini Isus su nga getaw Judea, laung nilan, “Dagid peksemukenen su ginaa nu nga getaw, sabaꞌ lineepen sug liwagan benwa Judea mekpetuꞌun. Mikpuun ditu Galilea, laak nemun, midepet na gupia dini Jerusalem.” ");
INSERT INTO syb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Benaꞌ midengeg ni Pilato su tinaluꞌ kia nu nga getaw Judea, sinaaken dinilan, “Naa si Isus kini, masiꞌ getaw Galilea?” ");
INSERT INTO syb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Benaꞌ misuunanen puꞌ si Isus, sakup tuꞌu nug benwa pegbiaꞌan ni Herodes, pibundasen dayun si Isus pegdeksaꞌ ditu niin. Puꞌ si Herodes, mitaang dadema dia Jerusalem di gendaw kia. ");
INSERT INTO syb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Naa benaꞌ mipebundas si Isus ditu ni Herodes, liliag gupia si Herodes, puꞌ kitu nai kaibenen, mauyaꞌanen maitaꞌen si Isus, sabaꞌ nug dengeganen. Mauyaꞌanen dadema maitaꞌen siai mekesalebuꞌ penggulaulaanen. ");
INSERT INTO syb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Naa saꞌ maꞌantu, melaun sinaak ni Herodes dini Isus, laak dagid iin, ndaꞌ sembag. ");
INSERT INTO syb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Naa ki nga kaunutan nug belian mukaꞌ ki nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ kia, mimegindeg ilan dia, pinemalan nilan patiꞌ pengelegay si Isus. ");
INSERT INTO syb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Dayun si Herodes kampuꞌ nu nga sundalunen, migininisan dayuni keksudiꞌ nilan dini Isus. Sala keksudiꞌ nilan diniin, piselukan nilan tautau suub gadiꞌ. Dayun piwit nilan puliꞌ iin ditu ni Pilato. ");
INSERT INTO syb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Mendadi, kiin nai keseksud ni Herodes mukaꞌ ni Pilato, asa miniben ilan duaꞌ ndaꞌ pektubus. ");
INSERT INTO syb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Mendadi si Pilato, pinsabinen ki nga kaunutan nug belian nu getaw Judea dakus su ngag duma meselagetaw nilan, sampay su nga melaun getaw. ");
INSERT INTO syb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Benaꞌ mipungun ilan dia gedapanen, kaliꞌ pektaluꞌ dinilan si Pilato, “Naa mendadi ki getaw kini, dinangat niu dini naan, laung niu pesuainen sug delendeman nu nga getaw di gubirnu. Laak sinaakan ku di gedapan niu, dagid mekatag di kelaun dangat niu diniin, ndaꞌidun mai misimaꞌu salaꞌen dun. ");
INSERT INTO syb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Mukaꞌ padun,” maaꞌ laung pa ni Pilato, “maꞌantu dademaig delendeman ni Herodes, kumalenged pigwakilen puliꞌ dinita. Naa, ndaꞌidun daani salaꞌ nu getaw kini lagaꞌ na ginaanen. ");
INSERT INTO syb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kaas danaan, pebadasu laak, dayun beluyay.” ");
INSERT INTO syb_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Laak iini tinaluꞌ dun ni Pilatoi maꞌnia, puꞌ tauntaun, metaang dig Lumpuk tug Liniusan, duunig betad ni Pilato, subay beluyenen tu nga getaw Judeai sala tawan dinilan pinikutan. ");
INSERT INTO syb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Dagid su kelaunan getaw, benaꞌ midengeg nilan puꞌ beluyen sia si Isus, migdengan ilan memeksay. “Petain iin!” laung nilan. “Beluyen dinami si Barabas!” ");
INSERT INTO syb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Naa si Barabas kiin, iini sala tawan pinikutan mekatag di sasaw di syudad kia, mukaꞌ migbunuꞌ samatawen.) ");
INSERT INTO syb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Naa saꞌ maꞌantu, mikpulingkas pa puliꞌ madap di melaun getaw si Pilato. Puꞌ mauyaꞌanen sia, iini beluyenen dinilan si Isus. ");
INSERT INTO syb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Laak mimeksay su nga getaw, laung nilan, “Lensangen di kurus! Lensangen ba di kurus!” ");
INSERT INTO syb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ketelu deksuꞌ na ni Pilato saak dinilan, “Mauma, alandun bai salaꞌen? Ndaꞌidun daani misimaꞌu salaꞌen lagaꞌ na ginaanen! Paladpalad pebadasu laak, dayun beluyay.” ");
INSERT INTO syb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Laak migdegadega memeksay su nga getaw, lensangen daw di kurus si Isus. Tigaꞌwan, duminaagig beksay nilan. ");
INSERT INTO syb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Sinanguꞌ ni Pilato ki pinengi kia nu melaun getaw, inukumanen si Isus. ");
INSERT INTO syb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Su sala tawan kia pinengi nilan beluyen, ki pinirisu kia sabaꞌ mingatu tu gubirnu mukaꞌ migbunuꞌ, biluy tuꞌu ni Pilato. Kini si Isus, pigwakil ni Pilato tu petayanen, sinanguꞌen sug delendeman nu melaun getaw. ");
INSERT INTO syb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Naa saꞌ maꞌantu, inagak si Isus ditu tandaꞌ petayan diniin. Naa su nga migagak diniin, duuni mipegitaꞌ nilan getaw sungu na mesebang dia Jerusalem, ngalanen si Simon, getaw Cirene. Iini linabet nu nga pegagak dini Isus, pipisan nilan dayun diniin ki kurus ni Isus, pilendug nilan diag binayaꞌ ni Isus. ");
INSERT INTO syb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Naa melaun gupia getaw migdedunut dini Isus, kampuꞌ nu ngag libun pekpengaduy, milegenan ilan patiꞌ ditu mbianan ni Isus. ");
INSERT INTO syb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Laak liningay ni Isus su ngag libun, kaliꞌ pektaluꞌ dinilan, “Naa yamu ngag libun, getaw Jerusalem, ndiꞌ niau pengeduyay! Iin sungkini pengeduyay niu, kig lawas niu gupia, mukaꞌ su ngag bataꞌ niu. ");
INSERT INTO syb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Puꞌ duun tuꞌui gendaw mateng, teluꞌen nu getaw, ‘Tumuꞌ pa su nga ndiꞌ mapet bataꞌen! Tumuꞌ pa su ndaꞌ mainsan mekepeduduꞌ gembataꞌ!’” ");
INSERT INTO syb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Laung pa ni Isus, “Metaluꞌ pagid nu nga getaw tu ngag binentudan, ‘Yamu bentud amu, tumuꞌ tubakay niu ami!’ Dakus tu nga maikaꞌ bentud, ‘Yamu ngag bataꞌ bentud, tebunay niu ami!’” ");
INSERT INTO syb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Diksuꞌ ni Isus su tinaluꞌen, “Puꞌ saꞌ maꞌniniꞌi kekpeleget dinaan kini, gitunganen mailaw tagun mau, naa yamu kiin, alandun saani mpenggulaula niu, gitunganen migangu tagun amu?” ");
INSERT INTO syb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Naa duun dademaig duaꞌ tawan mimilas tug balaꞌud nu gubirnu, piduma dini Isus egakay ditu pepatay dinilan. ");
INSERT INTO syb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Naa saꞌ maꞌantu, guminawas ilan dia syudad, midepet ilan dia dapit piningalan dun “Tulan Gulu.” Dayun nilan lensangay tu kurus si Isus. Piduma dadema lensangay kig duaꞌ tawan kia mimilas tug balaꞌud, miktimpang di kurus ni Isus su kurus nilan. ");
INSERT INTO syb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kaliꞌ pektaluꞌ si Isus, “Uu Amaꞌu, pedasun mu ilan! Puꞌ ndaꞌ nilan mesabut su kelebuꞌan nu pinggulaula nilan kini.” Naa benaꞌ milansang na tu kurus si Isus, piktali dayun nu sundalu su nga penepetenen, bian nilan mekilas dun. ");
INSERT INTO syb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Minelindeg dia su nga getaw, pegbantay ilan tu mipenggulaula. Su pelum kaunutan nu getaw Judea, pingimusaungan nilan si Isus, laung nilan, “Paa, megaganen daw megaweni ngag lain getaw, naa melengas guunenenig lawasen, saꞌ sia metuud, kini tuꞌu su pimiliꞌ nu Megbebayaꞌ, ki Tinduꞌen Meglekaunutan!” ");
INSERT INTO syb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Su nga sundalu, piksudiꞌan ilan pa pagid si Isus. Mikpesempel ilan diniin, dayun ilan peksangal penginumen dig babaꞌen, ");
INSERT INTO syb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","kaliꞌ ilan pektaluꞌ, “Naa saꞌ pinenggiꞌ yaꞌa su gadiꞌ nu getaw Judea, naa gawen muig lawas mu!” ");
INSERT INTO syb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Naa duuni tuꞌus pidekep dia tandaꞌ nug dimpulu ni Isus, iini sinulat dun, “Kini su Gadiꞌ nu nga getaw Judea.” ");
INSERT INTO syb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Naa sug duaꞌ tawan duma ni Isus linansang di nga kurus, su mimilas tug balaꞌud, mingimusaung dini Isus su sala tawan, laungen, “Haa, kanaꞌ ba yaꞌai Tinduꞌ nu Megbebayaꞌ Meglekaunutan? Saꞌ maꞌnia, mauma dema ndiꞌa ma meksigawen, guunen mu dadema ami?” ");
INSERT INTO syb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Laak su sala tawan pelum, pimaagenig dumanen kia, laungen diniin, “Ndiꞌa masiꞌ mendek tu Megbebayaꞌ, asa inukuman ka na dema? ");
INSERT INTO syb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Laak ita kini, bantangen laaki maꞌninii ginukuman dinita, puꞌ sugda tu melaat gulaula ta. Kig duma ta kini, ndaꞌ mai melaat gulaulanen.” ");
INSERT INTO syb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kaliꞌ pagid pektaluꞌ dini Isus, “Uu Isus, saꞌ meglekaunutan ka na tuꞌu, ndiꞌ mau da selingaway!” ");
INSERT INTO syb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Kaliꞌ sembag si Isus, “Naa, taluꞌu tuꞌu diniꞌa, nandaw kini, meksalabuuk ita ditu Paraiso,” saꞌitada tu gekbus langit. ");
INSERT INTO syb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Naa su kelansang dini Isus tu kurus, mabuꞌ miktui gendaw, tekaw dumilemi tibuuk benwa, ndaꞌ tiagi gendaw sampay miginengaꞌ menaugi gendaw. ");
INSERT INTO syb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Su kurtina bilet ditug dialem nu Pengedapan tu Megbebayaꞌ, mitekaw meginengaꞌ megedit. ");
INSERT INTO syb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Mendadi minekeg dayun megbeksay si Isus, laungen, “Naa, uu Amaꞌu, pegwakilu diniꞌai gimuudu!” Dayun megetusi ginaanen. ");
INSERT INTO syb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Naa su kaunutan sundalu dia, benaꞌ minitaꞌen su mipenggulaula, inalen dayun su Megbebayaꞌ, laungen, “Aa naa, masiꞌ metuud tuꞌu, ki getaw kini, ndaꞌiduni salaꞌen!” ");
INSERT INTO syb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Su pelum melaun gupia getaw mipungun dia adun megbantay, benaꞌ minitaꞌ nilan su kelaun mipenggulaula, mimeguliꞌ ilan, pengekduken nilani gegdeb nilan sabaꞌ nu gembegat kelegenay nilan. ");
INSERT INTO syb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Naa sug launan sambat ni Isus kampuꞌ nu ngag libun tumindug diniin genat tu Galilea, pemegindeg ilan dia mesempelsempel, adun maitaꞌ nilan su mipenggulaula. ");
INSERT INTO syb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Naa duuni getaw genat tug lunsud Arimatea, sakup dadema Judea kia, ngalanen si Jose. Mekesuun getaw si Jose, melegdengig betaden, dakus mekpedateng tu Keglekaunutan nu Megbebayaꞌ. Iini sala tawan dadema ditu Pikumpungan nu Metaas Gukum nu getaw Judea, laak ndaꞌ sanguꞌ ditu sabut kiin nu Pikumpungan mekatag dini Isus, sampay su pinggulaula nilan diniin. ");
INSERT INTO syb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Mendadi kini si Jose, minangay madap dini Pilato, inubugen diniin, elapenen sug bangkay ni Isus. ");
INSERT INTO syb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Saꞌ maꞌantu, inangay dayun ni Jose egwatay dia kurus sug bangkay ni Isus. Benaꞌ miagwaten, pinutusen di penepeten gemputiꞌ, ditunen dayun libeng sangyab liwakan di telektap, ki ndaꞌ mainsan melebengay getaw. ");
INSERT INTO syb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Naa su gendaw kia, Birnis, su pengandam di Gendaw Pelali nu getaw Judea, puꞌ sala gendaw paitu. ");
INSERT INTO syb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Naa su ngag libun kiin tumindug dini Isus genat tu Galilea, lindug nilan si Jose, kaas minitaꞌ nilan su sangyab, dakus minitaꞌ nilan dadema su kebetang nug bangkay ni Isus dia. ");
INSERT INTO syb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Benaꞌ minuliꞌ ilan, pigulingel nilani nga memut tagek dakus su gininisan pagemut penguklaus nilan sia ditug bangkay ni Isus. Benaꞌ su Gendaw Pelali nilan, milali pa su ngag libun, maaꞌ nu pinalinta nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Mendadi benaꞌ daliꞌ endaw di gendaw Duminggu, ki ngag libun kia, mipanaw ilan, mipuliꞌ ilan ditu sangyab libengan dini Isus, iwit nilan su nga pagemut miandam nilan adun penguklaus sia ditug bangkay ni Isus. ");
INSERT INTO syb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Laak dagid benaꞌ mesempel nailan dia sangyab, iini midetengan nilan, su gembagel batu tinakep tu sangyab, masiꞌ linulid na. ");
INSERT INTO syb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Dayun ilan sumuut dia sangyab, dagid ndaꞌ nilan mbaangay dia sug bangkay nu Kaunutan si Isus. ");
INSERT INTO syb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mendadi, benaꞌ pekelibuleng pa su ngag libun saꞌ taꞌ alandun saani mipenggulaula, tekaw dayun duunig duaꞌ tawan suminaing dinilan pegindeg, meketinggasi penepetenen. ");
INSERT INTO syb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ki ngag libun kini, mikegdungguꞌ ilan, sabaꞌ mipatiꞌ ilan mendek. Dagid kaliꞌ pektaluꞌ dinilan kig duaꞌ tawan kia, “Ki getaw tetubuꞌ, mauma dema penengaun niu sia dinig lebengan di nga minatay? Kiin, ndaꞌ na dini. Pitubuꞌ na puliꞌ. ");
INSERT INTO syb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Iini pegdelendem niu su tinaluꞌen diniu kiin saanan niu ditu pa Galilea, ");
INSERT INTO syb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","maaꞌ laungen, ‘Naan kini kig Bataꞌ nu Kilawan, subay pegwakilu di pegbayaꞌ nu mikesalaꞌ getaw, mukaꞌ lensangenu di kurus. Dayun di ketelu endawen, metubuꞌu puliꞌ.’” ");
INSERT INTO syb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Iin pa midelendem tuꞌu nu ngag libun su tinaluꞌ kia ni Isus. ");
INSERT INTO syb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Mendadi saꞌ maꞌantu, mipuliꞌ ilan dayun genat tu sangyab, pingukitan nilan su nga sepuluꞌ buꞌ sala tawan peneligan ni Isus dakus su kelaun duma nilan ditug launan mipenggulaula. ");
INSERT INTO syb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Naa su migukit dun tu nga peneligan ni Isus, ilan si Maria Magdalena mukaꞌ si Juana, dakus si Maria ginaꞌ ni Santiago, sampay nga samalibun nilan. ");
INSERT INTO syb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Laak benaꞌ midengeg nu nga peneligan ni Isus, dig delendeman nilan, sagya laak gukiten, kaas ndaꞌ ilan pekpetuud dun. ");
INSERT INTO syb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Laak dagid si Pedro, suminambut megbuat, gumibek dayun ditu sangyab. Benaꞌ midepet dia, migdungguꞌ mekselip diag dialem. Iin laaki minitaꞌen su nga penepeten, su kamun pinutus ditug bangkay ni Isus. Minuliꞌ dayun si Pedro, milibuleng gupia, saꞌ taꞌ alandun saani mipenggulaula. ");
INSERT INTO syb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Naa mendadi su gendaw kia, duunig duaꞌ tawan sakup ni Isus pekpanaw dadema, pegangay ilan tu maikaꞌ lunsud piningalan dun Emmaus, genat ilan tu Jerusalem, mabuꞌ duuni sepuluꞌ buꞌ telu kilumitruig layuꞌen. ");
INSERT INTO syb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Naa saanan nilan dig dalan, pegyegaan nilan su kelaun mipenggulaula kia. ");
INSERT INTO syb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Naa segay nilan megyagayaga mukaꞌ meksinaakay, mitekaw metuaꞌ dia nilan, si Isus na gupia. Tumindug dayun dinilan. ");
INSERT INTO syb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Laak dagid pia minitaꞌ nilan iin, ndaꞌ nilan mailala. ");
INSERT INTO syb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Sinaak ni Isus dinilan, “Taꞌ alanduni pegyegaan niu kiin, sinegay niu mpanaw?” Tuminlen ilan dayun, midemeng ilan gupia. ");
INSERT INTO syb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Dayun su sala tawan, ngalanen si Cleopas, kaliꞌ sembag, “Taꞌ itu, kig launan getaw dia Jerusalem nemun, sala mu da masiꞌi ndaꞌ mu mesuunay ki mipenggulaula dia kia nemun?” ");
INSERT INTO syb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Taꞌ mai mipenggulaula?” sinaak ni Isus. Kaliꞌ ilan sembag, “Su nga mipenggulaula ni Isus, getaw Nazaret. Puꞌ pimuunan iin nu Megbebayaꞌ, ginuungan tantu su kengukiten dakus su nga penggulaulaanen di pegitaꞌen nu nga getaw sampay di pegitaꞌen nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Laak dagid tinipu nu nga kaunutan nug belian ta dakus nga meselagetaw, adun ukuman lagaꞌ na ginaanen. Pilansang nilan dayun di kurus. ");
INSERT INTO syb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Asa yami, pedetengen nami sia, iin na tuꞌu ki meglegawen dig bansa ta Israel! Mukaꞌ padun, kini nai ketelu endawen genat di kepatayen. ");
INSERT INTO syb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pidag pa tanan, duuni ngag libun di pikumpungan nami, misebuꞌan ami dun gupia, puꞌ kamun daliꞌ endaw, milapus ilan mpanaw tu sangyab libengan dun. ");
INSERT INTO syb_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Laak benaꞌ minateng ilan dia, ndaꞌ nilan pelum mbaangay sug bangkay ni Isus. Naa mipuliꞌ ilan dayun, inukit nilan dinami, duuni mikpaitaꞌ daw dinilani nga sesuguꞌen nu Megbebayaꞌ getaw langit. Tinaluꞌ daw nu nga getaw langit, mitubuꞌ na puliꞌ daw si Isus. ");
INSERT INTO syb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Naa saꞌ maꞌantu, duunig duma nami minangay ditug libengan dun, dayun minitaꞌ nilan, maaꞌ da gupia nu tinaluꞌ nu ngag libun. Laak dagid si Isus, ndaꞌ nilan dema maitaꞌ.” ");
INSERT INTO syb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","“Ay, yamu pa di getaw,” laung ni Isus, “benguꞌbenguꞌen amu! Mauma dema melegen amu metuuday dun, su kelaun sinulat dengantu ditu Taluꞌ nu Megbebayaꞌ nu nga getaw pimuunanen? ");
INSERT INTO syb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kanaꞌ ba metuud, ki Tinduꞌ nu Megbebayaꞌ Meglekaunutan, su gasalen, mbiananeni kelaun lasayen kini, dayun gasalen dadema, megdedengeg na tantu?” ");
INSERT INTO syb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Dayun pigulug ni Isus dig duaꞌ tawan kia su kelaun sinulat pedaan mekatag diniin ditu Taluꞌ nu Megbebayaꞌ. Pikpuunanen su nga sinulat ni Moises, dayun gilaꞌen su sinulat nu kelaun duma getaw pimuunan nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Naa maꞌantu, misebang ilan diag lunsud gengayan nilan. Si Isus, maꞌniin mundas pa, ");
INSERT INTO syb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","laak ginuut nug duaꞌ tawan kia ndiꞌ pa mundas, laung nilan, “Naa, pektuluga na dia nami, puꞌ lelabung na, sungu na meglegebii.” Paladpalad migdunut si Isus dinilan suled diag balay, mektulug dia sia. ");
INSERT INTO syb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Naa dekag dia nailan pengaanan, inimud ni Isus su pan. Dekag mikpaladpalad tu Megbebayaꞌ, pimetanen su pan, tinulunen dayun dinilan. ");
INSERT INTO syb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Naa maꞌniin mibuasan nai mata nilan, minilala nilan dayun si Isus. Luminilung dayun si Isus. ");
INSERT INTO syb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Mendadi, sug duaꞌ tawan sakupen, kaliꞌ ilan pegyagayaga, laung nilan, “Pia su diin paita dalan kamun, kanaꞌ ba misingkuꞌ tug langitig leliag ta, segayen megyaga dinita, su inubaden dinita kia su Misulat Taluꞌ nu Megbebayaꞌ?” ");
INSERT INTO syb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Maꞌantu, migbuat dayun sug duaꞌ tawan, mipuliꞌ ilan ganam ditu Jerusalem. Midetengan nilan, mipungun na su sepuluꞌ buꞌ sala tawan peneligan ni Isus dakus su nga samasakup nilan. ");
INSERT INTO syb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Laung dayun nu nga mipungun kia, “Naa, metuud daan tuꞌu, mitubuꞌ su Kaunutan! Mikpaitaꞌ ma na dini Simon!” ");
INSERT INTO syb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Dayun sug duaꞌ tawan genat tug Emmaus, inukit nilan pa pagid ki mipenggulaula nilan kia diag dalan, sampay su kailala nilan dini Isus saananen mekpeta tu pan. ");
INSERT INTO syb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Naa ndaꞌ pa medeksuꞌ nug duaꞌ tawan su gukiten nilan, mitekaw metuaꞌ si Isus, iin gupiai suminaing mindeg dinilan. Kaliꞌ pektaluꞌ, “Naa, gempiai ginaa niu.” ");
INSERT INTO syb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Laak maꞌniin ilan igyang, mipatiꞌ ilan mendek, puꞌ laung nilan dun, maitaꞌ nilani multu. ");
INSERT INTO syb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Dagid kaliꞌ pektaluꞌ si Isus, “Mauma dema melibuleng amu? Mauma dema duaꞌduaꞌi kesalig niu? ");
INSERT INTO syb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tayay pa daani kemetu kini mukaꞌ geksudu, naan tantu ini. Depenay niau, adun mesuunan niu. Puꞌ su multu, ndaꞌi guneden, ndaꞌidun dademai tulanen, maꞌniin dinaan minitaꞌ niu kini.” ");
INSERT INTO syb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Dayunen paitaꞌ dinilan su geksuden dakus kemeten. ");
INSERT INTO syb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Melegen nilan metuuday, sabaꞌ leliag nilan. Saanan nilan mesebuꞌan dun, sinaak ni Isus, “Duuni gaan niu dini?” ");
INSERT INTO syb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tinulun nilan dayun diniini sedaꞌ, tinitiꞌ. ");
INSERT INTO syb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Dayun tuꞌu aanay ni Isus di pegitaꞌen nilan. ");
INSERT INTO syb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Mendadi, kaliꞌ pektaluꞌ si Isus tu nga sakupen, “Naa, kini na tuꞌu su tinaluꞌu pedaan diniu sug diin, su duminuma pau diniu. Ki misulat mekatag dinaan ditu Taluꞌ nu Megbebayaꞌ, tinaluꞌu daan diniu puꞌ subay megelaꞌ menuud, genat tu Palinta misulat ni Moises mukaꞌ su nga pimuunan nu Megbebayaꞌ dengantu, sampay su ngag Bebat.” ");
INSERT INTO syb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Naa saꞌ maꞌantu, biwasan ni Isus sug delendeman nu nga sakupen kia, adun mesabut na nilan su Misulat Taluꞌ kia nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kaliꞌ pektaluꞌ dinilan, “Iini misulat, ki Tinduꞌ nu Megbebayaꞌ Meglekaunutan, subay mayan dig lasay, dayun di ketelu endawen, metubuꞌ puliꞌ. ");
INSERT INTO syb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Mukaꞌ misulat dadema, subay pegukit pebian di pegbayaꞌu ki keksikesuun nu getaw adun pedesunen su salaꞌen. Pekpuunan pegukitay dini Jerusalem, dayun ditu kelaun bansa nu getaw. ");
INSERT INTO syb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mendadi, yamu nai menakesiꞌ di kelaun mipenggulaula kini. ");
INSERT INTO syb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Naa taluꞌu diniu, pelusaden ku pa tuꞌu dini niu kig Balakat nu Megbebayaꞌ, ki pinasad ni Amaꞌu. Laak pegunung pamu dini syudad, sampay da dun di gendaw lumusad iin genat tu gekbus langit, dayun begayan amu niin ginuung.” ");
INSERT INTO syb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Naa inagak ni Isus su nga sakupen tug liu nu syudad, gikteb tug lunsud Betania. Benaꞌ minateng ilan dia, tinggal ni Isus kig baingkenen, pinenebianeni nga sakupen kia. ");
INSERT INTO syb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mendadi, selianen menenabi dinilan, sumiway dayun dinilan, pilentu ditu gekbus langit si Isus. ");
INSERT INTO syb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Naa su nga sakupen, linuꞌudan nilan si Isus, dayun ilan puliꞌ tu Jerusalem, mipatiꞌ ilan penleliagay. ");
INSERT INTO syb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Genat itu, tatap ilan meditug Balay Pengedapan tu Megbebayaꞌ, pegenalan nilan dia su Megbebayaꞌ.");
INSERT INTO syb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Dengantu, su ndaꞌ pa mbaali gekleb langit buꞌ lupaꞌ, kini si Isus, daan na. Iin sug duma nu Megbebayaꞌ. Gelalen su Taluꞌ mukaꞌ iin dademai Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Genat di pikpuunan nug launanen, iinig duma nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Adin su binaal, pibaal nu Megbebayaꞌ diniin. Ndaꞌiduni mibaal, iini minaal dun. ");
INSERT INTO syb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ki Taluꞌ kini, iini pikpuunan nu ketubuꞌ. Kagina iini mekpetubuꞌ tu getaw, mekpedelag tug delendeman nu nga getaw. ");
INSERT INTO syb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Dumilag su tiag dig dialem medelem, ndaꞌ magaw nu medelem. ");
INSERT INTO syb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Naa duuni getaw tinduꞌ nu Megbebayaꞌ, ngalanen si Juan. Kini si Juan, sinuguꞌ nu Megbebayaꞌ ");
INSERT INTO syb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","mangay megukit di nga getaw mekatag di getaw piningalan dun su tiag, adun medengeg nilan mukaꞌ metuudan ilan dun, launan nilan. ");
INSERT INTO syb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Kanaꞌ nu tiag, laak sinuguꞌ ukitanen su nga getaw mekatag di tiag. ");
INSERT INTO syb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Su tantu tiag si Isus, luminusad na dinig lumbang mekpedelag dig delendeman nug launan getaw. ");
INSERT INTO syb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Mendadi si Isus, gelalen su Taluꞌ, midinig lumbang kini. Laak, pia pibaal diniin nu Megbebayaꞌ sug lumbang, ndaꞌ mailala nu nga kilawan. ");
INSERT INTO syb_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Minangay ditug daan benwanen, laak ndaꞌ penembaꞌay nu nga samanen getaw Judea. ");
INSERT INTO syb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pia maꞌantu, duuni minembaꞌ diniin. Adin su nga minembaꞌ diniin, su nga mikpetuud gupia diniin, diadia bigayanen pegbayaꞌ betaꞌen nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Mikendutaꞌi kebataꞌ dinilan? Kanaꞌ gasal getawi puunanen. Ndaꞌ ilan pegigetaw ngag bataꞌ nu kinilawan, puꞌ su Megbebayaꞌ nai tantu Gamaꞌ nilan. ");
INSERT INTO syb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mendadi ki Taluꞌ kini, miksibaluy getaw. Suminala dinami megbenwa, kaas minitaꞌ nami su kelengas nu pegbayaꞌen, puꞌ sabaꞌ iinig buntung Bataꞌ nu Gamaꞌ ta Megbebayaꞌ. Ndaꞌiduni gikteben su tulungen di nga getaw mukaꞌ su ketuuden. ");
INSERT INTO syb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Naa si Juan kiin, duuni gendaw miktaluꞌ mekatag di Taluꞌ kini. Minekeg mektaluꞌ, laungen, “Kini da sug bekna pekteluꞌen ku diniu puꞌ duuni metuaꞌ, mbinayaꞌ pa dinaan, laak pia maꞌantu, metaas pai pegbayaꞌen batul danaan, puꞌ su ndaꞌ pau pegigetaw, daan nain.” ");
INSERT INTO syb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Naa, kagina ndaꞌi giktebeni tulungen dinita, pepianan ita niin gebii gendaw, launan ta. ");
INSERT INTO syb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Dengantu pisuunan ita ni Moises tu Palinta nu Megbebayaꞌ, laak nemun, pibian dini Isukristu, mbianan ta su tulungen mukaꞌ su ketuuden. ");
INSERT INTO syb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ndaꞌi getaw mikaitaꞌ ditu Megbebayaꞌ. Su da laak buntung Bataꞌen, sug duma nu Gamaꞌen Megbebayaꞌ, iini mikpesuun dun tu nga getaw. ");
INSERT INTO syb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Naa mendadi su nga kaunutan nu nga getaw Judea tu Jerusalem, suminuguꞌ ilan di ngag belian nilan mukaꞌ nga sapuꞌ ni Levi meditu ni Juan kia, adun saaken nilan diniin, “Naa yaꞌa, alanduni gelal mu?” ");
INSERT INTO syb_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Mendadi kini si Juan, ndaꞌ pegbelibad sumbag dun, miglegintuud gupia, laungen, “Kanaꞌu nu Tinduꞌ nu Megbebayaꞌ Meglekaunutan.” ");
INSERT INTO syb_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Sinaak nilan, “Saꞌ maꞌnia, alanduni gelal mu? Si Eliasa?” Simbag ni Juan, “Kanaꞌen.” Sinaak na nilan pelum, “Su ba pedetengen nami Pimuunan nu Megbebayaꞌ?” “Kanaꞌ,” simbag ni Juan. ");
INSERT INTO syb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“Mendadi,” laung nilan, “pesuun mu dinami saꞌ taꞌi gelal mu, adun mesembag nami su nga suminuguꞌ dinami medini niꞌa. Taꞌi ketaluꞌ mu mekatag dig lawas mu?” ");
INSERT INTO syb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Saꞌ maꞌnia, inalap dayun ni Juan sembagen su sinulat dengantu ditu Misulat Taluꞌ nu Megbebayaꞌ nu pimuunanen si Isaias, laungen, “Naani ‘mektawag diag limawaꞌ,’ laung ku, ‘Pelegdeng niu kig dalan nu Kaunutan Megbebayaꞌ!’” ");
INSERT INTO syb_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Naa su nga sinuguꞌ kia, sinuguꞌ ilan nu pikumpungan nu getaw Judea piningalan dun Pariseo. ");
INSERT INTO syb_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Kaliꞌ ilan saak pelum dini Juan, “Naa mauma dema memunaga tubig tu getaw, saꞌ kanaꞌ yaꞌa su Tinduꞌ nu Megbebayaꞌ Meglekaunutan mukaꞌ kanaꞌa ni Elias, mukaꞌ kanaꞌa dadema nu Pimuunan nu Megbebayaꞌ?” ");
INSERT INTO syb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Kaliꞌ sembag si Juan, “Naan kini, megbunagu laak tubig tu nga getaw. Dagid duuni megduma diniu, ndaꞌ niu mailala. ");
INSERT INTO syb_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Iin, mbinayaꞌ pa dinaan, laak pia su sepatusen, kanaꞌu bantang megubad dun diniin.” ");
INSERT INTO syb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Naa kig launanen kia, ditug Betania mipenggulaula, tug dipag Jordan, dia tandaꞌ mimunag si Juan tubig tu nga getaw. ");
INSERT INTO syb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mendadi benaꞌ migendaw, kini si Isus, minitaꞌ tuꞌu ni Juan misebang pangay dia niin. Kaliꞌ pektaluꞌ si Juan, “Aa naa, kiin na tuꞌu su piningalan dun Nati Karniru nu Megbebayaꞌ, su mbaal guliden tu Megbebayaꞌ, puꞌ adun mpedasun su salaꞌ nu tibaꞌan getaw! ");
INSERT INTO syb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iini tinaluꞌu sug laung ku, ‘Duuni sungu metuaꞌ, mbinayaꞌ pa dinaan, laak pia maꞌantu, metaas pa gupia dinaan, puꞌ su ndaꞌ pau pegigetaw, daan nain.’ ");
INSERT INTO syb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Naa sug bekna,” laung pa ni Juan, “ndaꞌu iin mailala. Laak dagid iini mituaꞌu dun memunag tubig tu getaw, puꞌ adun pailalau iin di nga getaw Israel.” ");
INSERT INTO syb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Mendadi tinakesiꞌan ni Juan si Isus, laungen, “Minitaꞌu sug Balakat nu Megbebayaꞌ luminusad genat tu gekbus langit, miglanguban di maꞌniin palas limuun, dayun ndaꞌ na awaꞌ diniin. ");
INSERT INTO syb_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ndaꞌu pain mailala, dagid su Megbebayaꞌ, su suminuguꞌ dinaan memunagu tubig tu nga getaw, daan na miktaluꞌ dinaan, ‘Maitaꞌ mu sug Balakat nu Megbebayaꞌ lumusad mukaꞌ ndiꞌ na mawaꞌ di getaw. Mendadi ki getaw kiin, iin su bunagenen tu nga getaw sug Balakat nu Megbebayaꞌ.’” ");
INSERT INTO syb_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Diksuꞌ ni Juan, “Naa kagina minitaꞌu tuꞌu, taluꞌu diniu, iinen na tuꞌu sug Bataꞌ nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Naa benaꞌ miksala gendaw, dia na puliꞌ pegindeg si Juan, ilan nu sakupen duaꞌ tawan. ");
INSERT INTO syb_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Mendadi, minitaꞌ ni Juan si Isus minayan dia. Kaliꞌ pektaluꞌ si Juan, “Naa, bentayay pa daan niu, kia na su Nati Karniru nu Megbebayaꞌ!” ");
INSERT INTO syb_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Naa kig duaꞌ tawan kini sakup ni Juan, benaꞌ midengeg nilani tinaluꞌen kia, lindug nilan si Isus. ");
INSERT INTO syb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Luminingay dayun si Isus, minitaꞌen ilan miglendug diniin. Sinaaken dinilan, “Taꞌ alanduni penengaun niu?” Kaliꞌ ilan sembag, “Rabi, adin ka pektulugan?” (Su gelalen Rabi, guluganen, “Mekpetuꞌun.”) ");
INSERT INTO syb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Simbag ni Isus, “Tendug amu dinaan, adun niu maitaꞌ.” Mendadi tumindug ilan tuꞌu diniin, minitaꞌ nilan dema su pegbenwananen, lilabung ilan dayun dia niin. (Puꞌ ginengaꞌ na menaugi gendaw gembabaꞌ.) ");
INSERT INTO syb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Naa sala tawan di nga mikedengeg tu tinaluꞌ ni Juan kia dayun miglendug dini Isus, iin si Andres, pated ni Simon Pedro. ");
INSERT INTO syb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Si Andres, linaawanen dayun ki gulangbataꞌen si Simon, laungen diniin, “Minitaꞌ na nami su Tinduꞌ nu Megbebayaꞌ Meglekaunutan.” (Naa ki gelalen “Tinduꞌ nu Megbebayaꞌ Meglekaunutan,” iin su gulugan nu ngalanen si Kristu.) ");
INSERT INTO syb_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Inunutan dayun ni Andres si Simon ditu ni Isus. Mendadi si Isus, pingenlenganen si Simon, kaliꞌ pektaluꞌ diniin, “Yaꞌa si Simon, bataꞌ ni Juan. Dagid genat nandaw, paingalan diniꞌa, si Cefas.” (Su ngalan Cefas, guluganen “batu,” sala ngalanen si Pedro.) ");
INSERT INTO syb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Benaꞌ miksala gendaw, pigdelendem ni Isus meditu Galilea. Mendadi linaawaneni sala tawan si Felipe, kaliꞌ pektaluꞌ diniin, “Pegdunuta dinaan!” ");
INSERT INTO syb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Naa kini si Felipe, getaw Betsaida, sug lunsud dadema ni Andres buꞌ ni Pedro.) ");
INSERT INTO syb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Mendadi si Felipe, linaawanen si Natanael, kaliꞌ dayun pektaluꞌ diniin, “Minitaꞌ na nami su sinulat ni Moises ditu Misulat Palinta nu Megbebayaꞌ, su sinulat dadema nu ngag duma pimuunan nu Megbebayaꞌ dengantu. Ngalanen si Isus, bataꞌ ni Jose, getaw Nazaret.” ");
INSERT INTO syb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Dagid kini si Natanael, kaliꞌ sembag, “Baa, duun bai melengas megenat dig lunsud Nazaret kiin?” “Naa, tenduga dinaan,” laung ni Felipe, “adun mu maitaꞌ.” ");
INSERT INTO syb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Mendadi kini si Isus, benaꞌ minitaꞌen si Natanael pegangay dia niin, kaliꞌ pektaluꞌ di ngag dumanen, “Bentayay pa daan niu, ki getaw kia, tantu getaw Israel. Ndaꞌig limbungen!” ");
INSERT INTO syb_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Sinaak ni Natanael dini Isus, “Taꞌ mai kailala mu dinaan?” “Su ndaꞌa pa melaaway ni Felipe,” laung ni Isus, “minitaꞌu yaꞌa minilunga dia gayu igera.” ");
INSERT INTO syb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","“Aa naa, Sir,” simbag ni Natanael, “saꞌ maꞌantu, yaꞌa na gupia sug Bataꞌ nu Megbebayaꞌ! Yaꞌa su Gadiꞌ nami nu nga getaw Israel!” ");
INSERT INTO syb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Kaliꞌ pektaluꞌ si Isus, “Mituudan ka ba dinaan sabaꞌ di tinaluꞌu kia puꞌ minitaꞌu yaꞌa saꞌ minilunga diag igera? Maitaꞌ mu pa ki mekesalebuꞌ padun gupia! ");
INSERT INTO syb_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Taman taluꞌu diniu, maitaꞌ pa niu kig langit mpukaꞌ, mukaꞌ ki nga sesuguꞌen nu Megbebayaꞌ getaw langit luntu mukaꞌ lumusad dinaan kini, kig Bataꞌ nu Kilawan.” ");
INSERT INTO syb_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Naa genat itu di ketelu endawen, duunig belaꞌi tug lunsud Cana sakup Galilea. Suminaup tug belaꞌi su ginaꞌ ni Isus, ");
INSERT INTO syb_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","pisebutan dadema si Isus kampuꞌ nu nga sakupen. ");
INSERT INTO syb_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mendadi benaꞌ migelaꞌ nai penginumen, laung nu ginaꞌ ni Isus diniin, “Ki penginumen nilan, migelaꞌ na daw.” ");
INSERT INTO syb_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","“Baa,” simbag ni Isus, “ndiꞌ mau pegbiaꞌay. Ndaꞌ pa dateng su gendawu.” ");
INSERT INTO syb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Kaliꞌ dayun pektaluꞌ su ginaꞌ ni Isus di nga megilak, “Adin su teluꞌenen diniu, petuud niu.” ");
INSERT INTO syb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Naa su nga getaw Judea, duuni ngag betad nilan mekatag di kengugas adun mawaꞌ su kelemuꞌay nilan. Kaas duuni genem buuk gunsuꞌ dia bitangan tubig pengugas, kada salabuuk gunsuꞌ, melepisanen saani paat buuk taru sabaꞌ kebagelen. ");
INSERT INTO syb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Mendadi kini si Isus, miktaluꞌ di nga megilak, “Pepenuꞌ niu tubig ki nga gunsuꞌ kini.” Bitangan nilan dayun tubig, pilepeng nilan tug babaꞌen. ");
INSERT INTO syb_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Laung dayun ni Isus, “Naa, saguk amu dun, uit niu dia meguit dig belaꞌi.” Iwitan nilan dun dayun iin. ");
INSERT INTO syb_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ininaman dayun nu meguit dig belaꞌi ki tubig kini binaluy na penginumen. Sinabinen dayun su menginsawa, puꞌ ndaꞌen suunay ki pigenatan nu penginumen kini (asa misuunan nu nga megilak kia, su miksaguk dun). ");
INSERT INTO syb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Laung nu meguit tug belaꞌi dia menginsawa, “Saꞌ su kelaun duma getaw, unaanen peksuday su mekepia penginumen. Benaꞌ melaun nai miꞌinum nu nga suminaup, peksudenen dayun pelum su sinukalay. Dagid yaꞌa, masiꞌ sinawad mu ki mekepia penginumen kini, iin mu pa peksuday!” ");
INSERT INTO syb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kiniig bekna mekesalebuꞌ tuꞌus pinggulaula ni Isus. Pinggulaulanen dia Cana sakup Galilea. Maꞌnia, pinitaꞌen di nga getaw ki kelengas nu pegbayaꞌen, kaas mikpetuud dayun diniin su nga sakupen. ");
INSERT INTO syb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Naa mendadi, tumigbeng dayun si Isus tu Capernaum, ilan nu ginaꞌen, su nga pateden mukaꞌ nga sakupen. Migbebenwa ilan dayun dia nga santaꞌ gebii. ");
INSERT INTO syb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Naa saꞌ sungu mektelipuun sug Lumpuk nu nga getaw Judea gindan ditug Liniusan, miditu si Isus syudad Jerusalem. ");
INSERT INTO syb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Benaꞌ midepet tug Balay Pengedapan tu Megbebayaꞌ, mitaanganen ki nga mendagang guliden, su nga meksesaluy baka, karniru mukaꞌ malepati. Minitaꞌen dadema ki nga membeles selapiꞌ, dia ilan pegingkud lemisaan nilan. ");
INSERT INTO syb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Mendadi kini si Isus, minimud tali, binaalen dayun badas, pingutidanen ilan dayun dia Pengedapan, pimugawen dadema dia ki ngag baka mukaꞌ karniru. Binunagen pa pagid su selapiꞌ nu nga memeles selapiꞌ, mukaꞌ pimbelikwangen su ngag lemisaan nilan. ");
INSERT INTO syb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Miktaluꞌ si Isus tu nga mendagang malepati, “Awaꞌ niu dini! Ndiꞌ niu baalay tebuꞌan kig Balay kini Pengedapan tu Gamaꞌu!” ");
INSERT INTO syb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Milabuꞌ dayun dig delendeman nu nga sakupen su sinulat dengantu ditu Misulat Taluꞌ nu Megbebayaꞌ, laung, “Mibagai gangitu, uu Megbebayaꞌ, miksekat di kepetailu tu Pengedapan diniꞌa.” ");
INSERT INTO syb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Mendadi duuni nga kaunutan nu getaw Judea suminaak dini Isus, “Duun bai mekesalebuꞌ paitaꞌ mu dinami, tuꞌus di pegbayaꞌ mu menggulaula dun kia?” ");
INSERT INTO syb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Kaliꞌ sembag si Isus, “Naa kig Balay kini Pengedapan tu Megbebayaꞌ, gebaꞌ niu. Dayun gikteb telu endaw, baalen ku puliꞌ.” ");
INSERT INTO syb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","“Apelii lai!” laung nilan. “Paat puluꞌ buꞌ enem taun pegbaalayi Pengedapan kini. Dayun baalen mu puliꞌ gikteb telu endaw?” ");
INSERT INTO syb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Laak dagid kig balay kia tinaluꞌ ni Isus, piuluganen dunig lawasen. ");
INSERT INTO syb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Mendadi benaꞌ pitubuꞌ puliꞌ si Isus, milabuꞌ dayun dig delendeman nu nga sakupen su tinaluꞌen kia. Mituudan ilan dayun ditu sinulat dengantu ditu Misulat Taluꞌ nu Megbebayaꞌ mekatag diniin, sampay tu tinaluꞌ kia ni Isus. ");
INSERT INTO syb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Naa selian ni Isus dia Jerusalem mitaang dig Lumpuk nug Liniusan, melaun getaw mikpetuud diniin saꞌ minitaꞌ nilan su nga mekesalebuꞌ tuꞌus pinggulaulanen. ");
INSERT INTO syb_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Laak ndaꞌ pesalig dinilan si Isus, puꞌ sinuunanenig betad nilan, tibaꞌan nilan. ");
INSERT INTO syb_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ndiꞌ kambat pesuunan dun, puꞌ migelaꞌen mesuunay sug dialem delendeman nu getaw. ");
INSERT INTO syb_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Naa duuni kaunutan nu getaw Judea ngalanen si Nicodemo, sakup di pikumpungan nu Pariseo. ");
INSERT INTO syb_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mendadi duuni gebii, kini si Nicodemo, luminabet dini Isus, kaliꞌ pektaluꞌ diniin, “Naa Sir, misuunan nami puꞌ mekpetuꞌun ka genat tu Megbebayaꞌ. Puꞌ ndaꞌi getaw mekenggulaula di nga mekesalebuꞌ tuꞌus mu kia, subay ebangan nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Si Isus, kaliꞌ sembag, “Taman taluꞌu diniꞌa, ndiꞌ mpedumai getaw tu Keglekaunutan nu Megbebayaꞌ, subay megigetaw iin puliꞌ.” ");
INSERT INTO syb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Kaliꞌ dayun saak si Nicodemo, “Endunen ma duni kegigetaw puliꞌ nu megulang getaw? Mesuꞌat ba mpuliꞌ ditu tian nu ginaꞌen dayun megigetaw puliꞌ?” ");
INSERT INTO syb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Kaliꞌ sembag si Isus, “Taman taluꞌu diniꞌa, ndaꞌi getaw mekesakup tu Keglekaunutan nu Megbebayaꞌ, subay megigetaw pebian di tubig mukaꞌ pebian dig Balakat nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Adin su megigetaw mekpuun di kilawan, kilawan dademai gasalen. Saꞌ su megigetaw mekpuun dig Balakat nu Megbebayaꞌ, diniwata dademai gasalen. ");
INSERT INTO syb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ndiꞌa mesebuꞌan dun su tinaluꞌu diniꞌa puꞌ subay megelaꞌ amu megigetaw puliꞌ. ");
INSERT INTO syb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Pinanggiꞌu tu genus. Su gengayan nu genus, su genus laaki metau dun. Medengeg mu, laak ndiꞌ mu mesuunani gengayanen sampay pigenatanen. Naa, maꞌantu dadema su megigetaw di pegbayaꞌ nug Balakat nu Megbebayaꞌ, ndiꞌ mu mesuunan saꞌ mikendutaꞌ dun.” ");
INSERT INTO syb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“Apelai,” laung ni Nicodemo, “kendutaꞌ main?” ");
INSERT INTO syb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Kaliꞌ sembag si Isus, “Aa, yaꞌa kini, memintuluꞌa nu getaw Israel, laak ndaꞌ mu ba mesuunay ia? ");
INSERT INTO syb_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Taman taluꞌu diniꞌa, pekteluꞌen nami diniu su misuunan nami, pegukiten nami su minitaꞌ nami, laak ndiꞌ amu metuudan dun. ");
INSERT INTO syb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Naa saꞌ ndiꞌ amu metuudan dun su tinaluꞌu mekatag di gempenggulaula dinig lumbang, metuudan bamu dun su teluꞌen ku mekatag dig langit? ");
INSERT INTO syb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ndaꞌi getaw mikelentu adun meditug langit, subay laak sug luminusad, sug Bataꞌ nu Kilawan, naan. ");
INSERT INTO syb_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Naa dengantu, si Moises kiin, selian nu nga getaw Israel dia pa limawaꞌ, binaalenig ledawan, mamak galang. Ininaten dayun bitangen ditu patal nu sekuden. Naan, mpemaꞌniin dau dema, subay mainat dau dema dayun mbetangu di pasek, ");
INSERT INTO syb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","puꞌ adun, adin su getaw metuudan dinaan, begayan ketubuꞌ ndaꞌi tamanen. ");
INSERT INTO syb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Puꞌ kagina melelaat gupia su Megbebayaꞌ di tibaꞌan getaw, bigayen matay sug buntung Bataꞌen, adun adin su metuudan diniin, ndiꞌ matay, segaga begayan ketubuꞌ ndaꞌi tamanen. ");
INSERT INTO syb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kanaꞌ iini sinuguꞌ dun nu Megbebayaꞌ kig Bataꞌen lumusad dinig lumbang puꞌ adun mengukum tu tibaꞌan getaw. Segaga iin sungkini luminusad dun dinig lumbang, meglegawen tu tibaꞌan getaw. ");
INSERT INTO syb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Mendadi adin su metuudan dinaan, kig Bataꞌ nu Megbebayaꞌ, ndiꞌ ukuman di melaat. Laak dagid adin su memilas dinaan, duun nai ginukuman dun, puꞌ ndaꞌen seligayig buntung Bataꞌ nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Iini kaukum dun. Ki tiag, luminusad dinig lumbang, laak pimilas nu nga getaw. Mauyaꞌan nilan su medelem sabayaꞌ su tiag, puꞌ melaat gupiai pigbetad nilan. ");
INSERT INTO syb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Adin su getaw penggulaulaanen su melaat, mpauk ditu tiag. Ndiꞌ mekpesempel di tiag, adun ndiꞌ medayag su penggulaulaanen ndaꞌi pantagen. ");
INSERT INTO syb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Laak dagid adin su getaw melengasi pegbetadenen mikpuun tu metuud, naa mekpesempel di medelag, adun maitaꞌ gupia su penggulaulaanen, puꞌ dunutanen sug delendeman nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Naa tubus itu, miditu si Isus prubinsya Judea, ilan nu nga sakupen. Migbebenwa ilan dia ndaꞌ maiben, pimbunagan ni Isus tubig su nga getaw. ");
INSERT INTO syb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Naa si Juan, migbunag dadema tubig tu nga getaw diag benwa Enon, mesempel tug lunsud Salim, puꞌ melaun tubig dia. Melaun getaw miditu niin, binunagan ilan dayun ni Juan tubig. ");
INSERT INTO syb_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Su timpu kia, ndaꞌ pa mpirisu si Juan.) ");
INSERT INTO syb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Mendadi duuni nga sakup ni Juan mukaꞌ sala tawan getaw Judea, miglantugiꞌ ilan mekatag di kengugas adun mawaꞌ su kelemuꞌay nu getaw. ");
INSERT INTO syb_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Saꞌ maꞌnia, minadap dini Juan su nga sakupen kia, laung nilan diniin, “Sir, ki tinakesiꞌan mu duma mu kiin ditug dipag Jordan, mimunag nain tubig di nga getaw, mukaꞌ meditu niin su kelaun getaw!” ");
INSERT INTO syb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Kaliꞌ sembag si Juan, “Petekenen na niu, puꞌ pia taꞌ taway dun, ndaꞌiduni mpenggulaulanen subay bigay dun nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Misuunan da niu gupia su tinaluꞌu diniu, puꞌ kanaꞌ naan su pedetengen Tinduꞌ nu Megbebayaꞌ Meglekaunutan. Laak dagid pisuun ku diniu sinuguꞌu laak nu Megbebayaꞌ pepengendamen ku su nga getaw di pegdateng nu Tinduꞌen kiin. ");
INSERT INTO syb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Naa, iin pitanggiꞌu di menginsawa. Danu menginsawa su penginsuaan. Leliagen su sambaten samalakinen, su pegindeg dia gupiden mukaꞌ mekineeg, puꞌ medengegen su tingeg nu menginsawa. Naa, maꞌniin dinaan. Benaꞌ medengegu puꞌ duuni getaw suminakup dini Isus, megelaꞌig leliagu. ");
INSERT INTO syb_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Sug dengegan ni Isus, subay megdugang, sug danaan, megengkan.” ");
INSERT INTO syb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Naa, ki getaw kini genat tug langit, iin si Isus, su tampusan metaas. Su genat dinig lumbang, piktuꞌunen sug betad dinig lumbang, puꞌ iini pigenatanen. Su genat tug langit, ndaꞌ naig lumabaw diniin. ");
INSERT INTO syb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ukitenen su minitaꞌen mukaꞌ su midengegen, laak dagid pemilasen nu nga getaw su gukitenen. ");
INSERT INTO syb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Laak adin su menembaꞌ ditu teluꞌenen, peglegintuudenen puꞌ su Megbebayaꞌi puunan nu metuud. ");
INSERT INTO syb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Puꞌ su sinuguꞌ nu Megbebayaꞌ medini, bigayan gupia Balakat nu Megbebayaꞌ, kaas petendayen su taluꞌ nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Petailen gupia nu Gamaꞌ Megbebayaꞌ sug Bataꞌen, kaas pipegbayaꞌ nu Megbebayaꞌ dig Bataꞌen sug launanen. ");
INSERT INTO syb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mendadi adin su mekpetuud tug Bataꞌ nu Megbebayaꞌ, si Isus kini, iini begayan ketubuꞌ ndaꞌi tamanen. Adin su memilas diniin, ndiꞌ medawat nu Megbebayaꞌ, puꞌ ndiꞌ meleknas diniin su gangit nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Naa ki nga Pariseo kini, midengeg nilan puꞌ melaun getaw daw pisakup ni Isus mukaꞌ binunaganen tubig, melaun pa dig dani Juan. (Asa kanaꞌ si Isusi mimunag tubig, su laak nga sakupen.) Naa benaꞌ misuunan ni Isus su teluꞌen nu nga Pariseo, migawaꞌ dayun diag benwa Judea, ilan nu nga sakupen, minuliꞌ ilan tu Galilea. ");
INSERT INTO syb_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Laak subay minayan ilan tug benwa Samaria. ");
INSERT INTO syb_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Benaꞌ dia na Samaria si Isus, midepet tug lunsud Sikar, mesempel dig lupaꞌ bigay dengantu ni Jacob tug bataꞌen si Jose. ");
INSERT INTO syb_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Dia pa sug delungan pigbaal ni Jacob. Dayun migingkud si Isus dia gupid nug delungan kia, puꞌ bilayan sabaꞌ nu kepanawen. Duun saan miktui gendaw. ");
INSERT INTO syb_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mendadi, duunig libun mituaꞌ diag delungan kia, puꞌ mangay tubig. Laung ni Isus diniin, “Begayay mau di tubig kiin.” ");
INSERT INTO syb_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Naa su nga sakupen, minundas ilan tug lunsud menaluy gaan.) ");
INSERT INTO syb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","“Aba,” simbag nug libun kia, “mauma pinengian mau tubig, asa yaꞌa, getaw Judeaa, mukaꞌ naan, getaw Samaria mau?” (Puꞌ su nga getaw Judea mukaꞌ getaw Samaria, migbanta ilan.) ");
INSERT INTO syb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Kaliꞌ sembag si Isus, “Naa saꞌ misuunan mu siaig begay nu Megbebayaꞌ di nga getaw, mukaꞌ saꞌ miꞌilala mu sia ki minengi diniꞌa kini tubig, naa yaꞌa siai menengi dinaan tubig. Begayu dayun diniꞌa ki tubig mekpetubuꞌ di getaw.” ");
INSERT INTO syb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","“Naa Sir,” laung nug libun, “ndaꞌiduni sigeb mu, medalem dademaig delungan kini. Adin mu elapay ki tubig mekpetubuꞌ di getaw? ");
INSERT INTO syb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mukaꞌ keduaꞌen, su ginepuꞌay nami si Jacob, pingumbilinen dinamiig delungan kini, iin dademai ginumanen, ilan nu ngag bataꞌen, pia su nga petubuꞌenen. Yaꞌa, metaasa pa ba dini Jacob?” ");
INSERT INTO syb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Sumimbag si Isus, “Adin su minum di tubig dig delungan kini, kuaun da puliꞌ. ");
INSERT INTO syb_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Dagid adin su minum di tubig begayu, ndiꞌ na puliꞌ kuaun. Kig begayu diniin, mbaluy maaꞌ nu tebud dig dialem delendeman nu getaw, puꞌ mekegbegay gupia diniin ketubuꞌ ndaꞌi tamanen.” ");
INSERT INTO syb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","“Sir!” laung nug libun. “Saꞌ mesuꞌat, begayay mau dun ki tubig kiin, adun ndiꞌ nau kuaun puliꞌ, mukaꞌ ndiꞌ nau megangay tubig dini.” ");
INSERT INTO syb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Kaliꞌ sembag si Isus, “Naa, laaway mu deliꞌ su sawa mu, peduma mu dayun mpuliꞌ dini.” ");
INSERT INTO syb_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Kaliꞌ sembag, “Ndaꞌiduni sawau.” Laung ni Isus, “Waꞌa daan, metuud, ndaꞌiduni sawa mu. ");
INSERT INTO syb_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Lima tawani minginsawa diniꞌa, mukaꞌ kig duma mu kiin nemun, kanaꞌ amu bilaꞌi. Metuudi tinaluꞌ mu kia.” ");
INSERT INTO syb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","“Masiꞌ daan, Sir,” laung nug libun, “pimuunan ka nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Naa su ginepuꞌay nami, miktamuy ilan tu Megbebayaꞌ dinig bentud kini. Laak yamu nga getaw Judea, laung niu subay ditu da daw Jerusalem pektemuyay su Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Kaliꞌ pektaluꞌ si Isus, “Aa lai, petuud mau, duuni gendaw mateng, su nga getaw, ndiꞌ nailan mektamuy tu Gamaꞌ ta dinig bentud kini sampay ditu Jerusalem. ");
INSERT INTO syb_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Yamu nu nga getaw Samaria, ndaꞌ niu mesuunay su tantu pektemuyen niu. Yami nu nga getaw Judea, misuunan nami su pektemuyen nami, puꞌ su keglegawen di kilawan, mikpuun di getaw Judea. ");
INSERT INTO syb_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Laak duuni gendaw mateng, mektamuy su nga getaw tu Megbebayaꞌ meksekat di ginuung nug Balakaten, pektemuyen nilan su tantu Diwata. Maꞌantu su kektamuy nilan, iin sug betad mauyaꞌan nu Gamaꞌ ta Megbebayaꞌ. Mukaꞌ ki gendaw kia, minateng na tuꞌu. ");
INSERT INTO syb_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ndiꞌ maitaꞌ su Megbebayaꞌ, kaas su nga mektamuy dun, subay meksekat dig Balakat nu Megbebayaꞌ su kektamuy nilan diniin, puꞌ adun pektemuyen nilan su tantu Diwata.” ");
INSERT INTO syb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Laung nug libun, “Naa misuunan ku duuni gendaw, mateng su Tinduꞌ nu Megbebayaꞌ Meglekaunutan, su piningalan dun si Kristu. Naa saꞌ mateng iin, pesuunenen daw dinita sug launanen.” ");
INSERT INTO syb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Kaliꞌ pektaluꞌ si Isus, “Kig duma mu kini megabitabit, iin naini, naan ma.” ");
INSERT INTO syb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Naa iin dademai kedateng puliꞌ nu nga sakup ni Isus. Misebuꞌan ilan dun gupia puꞌ dumanen megabitabit, libun. Laak ndaꞌi mekakuꞌ sumaak tug libun saꞌ taꞌ mai tuyuꞌen, atawaka sumaak dini Isus saꞌ taꞌ mai migabitabit ilan dun. ");
INSERT INTO syb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mendadi binilin nug libun dia sug bandi bitanganen tubig, minuliꞌ dayun tug lunsud, inukitanen dayun su nga getaw dia, laungen, ");
INSERT INTO syb_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Dunutay niau, paitaꞌu diniu ki migukit dinaan tu kelaun mipenggulaulau genat kaikaꞌayu. Taꞌ ma, kanaꞌ ba iinen na saan su Tinduꞌ nu Megbebayaꞌ Meglekaunutan?” ");
INSERT INTO syb_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Benaꞌ midengeg nu nga getaw su tinaluꞌ nug libun kia, migawaꞌ ilan diag lunsud, miditu ilan ni Isus. ");
INSERT INTO syb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mendadi su keteliud nug libun, ginuut sia nu nga sakupen si Isus, laung nilan, “Sir, aan ka deliꞌ!” ");
INSERT INTO syb_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Dagid simbag ni Isus dinilan, “Duun nai gaan ku, ki ndaꞌ niu mesuunay.” ");
INSERT INTO syb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Benaꞌ midengeg nu nga sakupen, miksinaakay ilan, laung nilan, “Aw, masiꞌ duuni migilak diniin saanan ta ditug lunsud?” ");
INSERT INTO syb_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Laak kaliꞌ pektaluꞌ si Isus, “Iini maꞌniin gaan ku, su kegdunutu tu mauyaꞌan nu suminuguꞌ dinaan, mukaꞌ su ketubusu di pibaalen dinaan. ");
INSERT INTO syb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Duuni peneluꞌen niu puꞌ paat bulan dekag pai meglegani. Laak taluꞌu diniu, pengmata amu, pegbentayay niu su ngag binaalan duminalag na, mpia na geniin. ");
INSERT INTO syb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Su meglegani, sukayan, puꞌ empunenen su ginani, su bigayan di ketubuꞌ ndaꞌi tamanen. Su memula taluꞌ nu Megbebayaꞌ di ginaa nu nga getaw, mukaꞌ su meglegani, meksamasama ilan dayun leliagay. ");
INSERT INTO syb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Metuud su peneluꞌen niu puꞌ sala laungi memula, salai gumani. ");
INSERT INTO syb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Sinuguꞌu amu gumani dinig benwa ndaꞌ niu pengimbaalay. Lain tawani mingimbaal dini, laak miꞌilasan amu di sengkuꞌen.” ");
INSERT INTO syb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mendadi, melaun getaw Samaria dig lunsud kia mikpetuud dini Isus sabaꞌ nu tinaluꞌ nug libun kia, “Inukiten dinaan su kelaun pinggulaulau genat kaikaꞌayu.” ");
INSERT INTO syb_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Saꞌ maꞌnia, benaꞌ minangay dia ni Isusi nga getaw Samaria kia, ginuut nilan tunlen pa dia nilan, miduaꞌ gebii pa si Isus dia nilan. ");
INSERT INTO syb_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mukaꞌ melaun pa padun getaw Samaria mikpetuud dini Isus saꞌ midengeg nilan su taluꞌen na gupia. ");
INSERT INTO syb_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Laung nilan tug libun kia, “Bekna, mikpetuud ami sabaꞌ nu ginukit mu. Laak nemun, telinga na namii mikedengeg di piktuꞌunen, kaas mituudan ami gupia, iini tantu Meglegawen tu tibaꞌan getaw.” ");
INSERT INTO syb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Benaꞌ mipapas naig duaꞌ gebii kia, minundas si nga Isus tu Galilea. ");
INSERT INTO syb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Selian nilan mpanaw, kaliꞌ pektaluꞌ si Isus, “Ki pimuunan nu Megbebayaꞌ, ndiꞌ pegbesaan diag daan benwanen.” ");
INSERT INTO syb_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Laak benaꞌ minateng ilan dia Galilea, pinembaꞌ si Isus nu nga getaw dia, puꞌ mikesaup ilan tug Lumpuk kiin tug Liniusan ditu Jerusalem, kaas minitaꞌ nilan su kelaun pinggulaula ni Isus saanan nug lumpuk kitu. ");
INSERT INTO syb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Naa mipuliꞌ si Isus tu Cana, sakup Galilea, sug lunsud tandaꞌ pibaluyen penginumeni tubig. Naa duuni getaw dia metaasi gelalen, pegladu kig bataꞌen ditu Capernaum. ");
INSERT INTO syb_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mendadi benaꞌ midengeg nu metaas getaw kia su kedateng ni Isus dia Galilea genat tu Judea, linaawanen si Isus, pinenginen dayun diniin meditu Capernaum meneguliꞌ tug bataꞌen, pekagawinaa na. ");
INSERT INTO syb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Dagid kaliꞌ pektaluꞌ si Isus diniin, “Paa, yamu pa di getaw, saꞌ ndiꞌ niu maitaꞌi mekesalebuꞌ penggulaula mukaꞌ tuꞌus, ndiꞌ amu mekpetuud.” ");
INSERT INTO syb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","“Sir,” laung nu kaunutan, “dunuta dema tuꞌu dinaan, puꞌ mbuus matayig bataꞌu.” ");
INSERT INTO syb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Kaliꞌ sembag si Isus diniin, “Naa, uliꞌa na. Metubuꞌ da kig bataꞌ mu!” Mituudan dun dayun ki getaw kia tu tinaluꞌ ni Isus, dayun muliꞌ. ");
INSERT INTO syb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mendadi saananen muliꞌ tug benwanen, suminungkak diniin su nga sesuguꞌenen, laung nilan, “Mitubuꞌ da sug bataꞌ mu!” ");
INSERT INTO syb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Sinaaken dayun dinilan saꞌ taꞌ urasay dun mikpuuni kepia ginaa nug bataꞌen. Kaliꞌ ilan sembag, “Kalabung di palisi gendaw ki kawaꞌ panasen.” ");
INSERT INTO syb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Milabuꞌ dayun dig delendeman nu gamaꞌen, mitaang dun gupia su ketaluꞌ ni Isus diniin, “Metubuꞌ da sug bataꞌ mu.” Mikpetuud dayun dini Isus, sampay su nga kelaun gapenen. ");
INSERT INTO syb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kinii keduaꞌ mekesalebuꞌ pinggulaula ni Isus sikna minateng dia Galilea genat tu Judea. ");
INSERT INTO syb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tubus itu, miglumpuk su nga getaw Judea ditu Jerusalem adun mektamuy tu Megbebayaꞌ, mukaꞌ suminaup dadema si Isus. ");
INSERT INTO syb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Naa dia Jerusalem duunig bulenaw, mesempel di gengaꞌan nug lunsud piningalan dun su Gengaꞌan nu Karniru. Piningalan dun di Hinebreo sug bulenaw kia, Betsata. Lima buuki kemalig binaal dia, ");
INSERT INTO syb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","megbelilid dia su nga pegladu. Melaun gupia pemegladu dia, duuni ngag buta, duun dademai nga mipilung mukaꞌ nga minatay seputul lawasen. Pegelatan nilan ki keglibual nu tubig, ");
INSERT INTO syb_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","puꞌ taang dun, duuni sesuguꞌen nu Megbebayaꞌ getaw langit lumusad dia tubig, meglibual dayun su tubig. Genat tu keglibual nu tubig, adin dayuni getaw mauna sugbu dia, mauliꞌan dayun, pia alandunig leduunen. ");
INSERT INTO syb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Naa duuni sala tawan dia, telu puluꞌ buꞌ walu taun na migladu. ");
INSERT INTO syb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Mendadi si Isus, benaꞌ minitaꞌen ki pegladu kini mukaꞌ misuunanen miniben na megladu, sinaaken diniin, “Mauyaꞌan mu ma mauliꞌan ka?” ");
INSERT INTO syb_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Kaliꞌ sembagi pegladu kia, “Waꞌa sia, Sir, laak saꞌ meglibual su tubig, ndaꞌi megabang dinaan sugbu dia, kaas saanan ku sugbu sia, maunanan nau dumau.” ");
INSERT INTO syb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","“Naa, pegbuata,” laung ni Isus. “Sikwat mui sinampuyuan diniꞌa kiin, mukaꞌ panawa.” ");
INSERT INTO syb_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Mitekaw dayun mauliꞌay. Sinikwaten tuꞌu su sinampuyuan diniin kia, dayun mpanaw. Naa su kauliꞌay nu getaw kia, mitaang di Gendaw Pelali. ");
INSERT INTO syb_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Mendadi ki nga kaunutan nu getaw Judea, kaliꞌ ilan pektaluꞌ tu piuliꞌan, “Naa, Gendaw Pelali maini. Binandu ma ditu Misulat Palinta nu Megbebayaꞌ, uiten mu nandawi sinampuyuan diniꞌa kiin.” ");
INSERT INTO syb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Kaliꞌ sembag, “Ki getaw kiin mineguliꞌ dinaan, tinaluꞌen dinaan, sikwaten kui sinampuyuan dinaan, mukaꞌ mpanawu.” ");
INSERT INTO syb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Sinaak nilan pelum diniin, “Naa, taꞌ taway duni miktaluꞌ dun diniꞌa?” ");
INSERT INTO syb_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Naa ki piuliꞌan kia, ndaꞌen suunay, puꞌ migawaꞌ na dia si Isus adun meliawen su tebenan getaw. ");
INSERT INTO syb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mendadi tubus itu ndaꞌ maiben, milabet ni Isus ki piuliꞌan kia diag Balay Pengedapan tu Megbebayaꞌ. Kaliꞌ pektaluꞌ si Isus diniin, “Naa, bentayay mu pa daan, miuliꞌan ka na. Ndiꞌa puliꞌ pegbaal salaꞌ, puꞌ tekaw mbuus mbianan mui melaat pa ditug leduun mu kitu.” ");
INSERT INTO syb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Saꞌ maꞌnia, mipuliꞌ su miuliꞌan ditu nga kaunutan nu getaw Judea, pisuunen dinilan puꞌ si Isusi mineguliꞌ dun. ");
INSERT INTO syb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mendadi, iin dayuni puunan nu kegleget nu nga getaw Judea dini Isus, puꞌ mineguliꞌ kia metaang di Gendaw Pelali. ");
INSERT INTO syb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Laak sumimbag si Isus dinilan, “Su Gamaꞌu Megbebayaꞌ, ndaꞌi kelalinen. Iin dademai pinunggilingan ku.” ");
INSERT INTO syb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Mendadi ki nga kaunutan nu nga getaw Judea, benaꞌ midengeg nilani tinaluꞌ kia ni Isus, minamal laakig delendeman nilan petain nilan si Isus. Puꞌ pimilasen daw su Gendaw Pelali, mukaꞌ inangkenen pa padun, iini Gamaꞌen su Megbebayaꞌ, saꞌitada pilepengenig lawasen tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kaliꞌ gusay sembag si Isus di nga kaunutan, “Taman taluꞌu diniu, naan kini kig Bataꞌen, ndaꞌiduni penggulaulaan ku saꞌ ndiꞌu maitaꞌ puꞌ iin dademai penggulaulaan nu Gamaꞌu. Adin su penggulaulaan nu Gamaꞌu, iin dademai penunggilingan ku. ");
INSERT INTO syb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Puꞌ naan kini, kig Bataꞌen, petailenu nu Gamaꞌu, kaas pinitaꞌen dinaan sug launan penggulaulaanen. Mukaꞌ duuni mekesesebuꞌ pa dun di kauliꞌay nu mipilung kia, paitaꞌen pa dinaan, kaas mesebuꞌan amu dun gupia. ");
INSERT INTO syb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Petubuꞌen puliꞌ nu Gamaꞌu su minatay. Naa maꞌantu dadema danaan, adin su mauyaꞌan ku, petubuꞌen ku dadema puliꞌ. ");
INSERT INTO syb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Kanaꞌ na nu Gamaꞌui mengukum di nga getaw, puꞌ naan nai paukumenen dun, ");
INSERT INTO syb_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","adun pegbesaanu nu ngag launan getaw maaꞌ nu kegbasa nilan tu Gamaꞌu. Adin su ndiꞌ megbasa dinaan kig Bataꞌen, ndiꞌ dadema megbasa tu Gamaꞌu, puꞌ iini suminuguꞌ dinaan medini.” ");
INSERT INTO syb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Laung padun ni Isus, “Taman taluꞌu diniu, adin su mekedengeg tu teluꞌen ku mukaꞌ mekpetuud tu suminuguꞌ dinaan, iini mpeduma tu ketubuꞌ ndaꞌi tamanen. Ndiꞌ maukuman, puꞌ migawen na di kepatayen mukaꞌ mialapenig begu ketubuꞌ. ");
INSERT INTO syb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Taman taluꞌu diniu, sungu matengi gendaw mekedengeg di tingegu su nga minatay, puꞌ naanig Bataꞌ nu Megbebayaꞌ. Adin su mekedengeg di tingegu, mpeduma dayun di ketubuꞌ ndaꞌi tamanen. Mukaꞌ ki gendaw kia, minateng na. ");
INSERT INTO syb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Naa su Gamaꞌu, iini puun nu ketubuꞌ. Maꞌnia dadema naan, kig Bataꞌen. Bigayanu niin pegbayaꞌu, puun dau dema nu ketubuꞌ. ");
INSERT INTO syb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Bigayan dau niin dema pegbayaꞌu mengukum tu nga getaw, puꞌ naanig Bataꞌ nu Kilawan. ");
INSERT INTO syb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mauma dema mesebuꞌan amu dun su tinaluꞌu diniu? Bentayay pa daan niu, duun daani gendaw mateng medengeg nug launan minatay su tingegu ");
INSERT INTO syb_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","mukaꞌ megbuat ilan tu ngag lebeng nilan. Dayun adin su melengasi pigbetaden, iini metubuꞌ puliꞌ di ndaꞌi tamanen. Mukaꞌ adin su melaati pigbetaden, megbuat tug lebengen, dayun iini ginukuman dun gupia, segbuun ditug linaw gapuy.” ");
INSERT INTO syb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Laung gusay ni Isus, “Ndaꞌiduni penggulaulaan ku mikpuun tu pegbayaꞌu, laak dagid saꞌ mengukumu, iini pektalentenan ku, su da teluꞌen dinaan nu Gamaꞌu, kaas melegdengi kengukumu, puꞌ medunut tu mauyaꞌan nu Gamaꞌu suminuguꞌ dinaan, kanaꞌ nug danaan laak mauyaꞌan. ");
INSERT INTO syb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Naa saꞌ upama naani tumakesiꞌ mekatag dig lawasu, ndiꞌ kambat medawat su teluꞌen ku. ");
INSERT INTO syb_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Laak tumuꞌ duunig duma tumakesiꞌ mekatag dinaan. Misuunan ku dadema puꞌ metuudi teluꞌenen mekatag dinaan. ");
INSERT INTO syb_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Naa si Juan, saꞌ piksaakan niu iin, miglegintuud mekatag dinaan. ");
INSERT INTO syb_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Laak naan, kanaꞌu seligan takesiꞌanu nu nga getaw. Mitaluꞌu da dun diniu su mekatag dini Juan kia, adun megawen amu. ");
INSERT INTO syb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Si Juan kiin, iin su maaꞌ nu suluꞌ mikpedelag diniu, pisuunanen amu tu metuud. Miuyaꞌan niu su piktuꞌunen diniu, laak ndaꞌ maiben. ");
INSERT INTO syb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Duun pai metaas takesiꞌ di tinakesiꞌan ni Juan kiin. Adin su pipenggulaula dinaan nu Gamaꞌu, iini takesiꞌ mekatag dinaan puꞌ sinuguꞌu nu Gamaꞌu Megbebayaꞌ medini. ");
INSERT INTO syb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tuminakesiꞌ dadema dinaan su Gamaꞌu suminuguꞌ dinaan, laak ndaꞌ niu mainsan medengeg su tingegen, mukaꞌ ndaꞌ niu mainsan maitaꞌ su palasen. ");
INSERT INTO syb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ndaꞌ niu pa pagid pektalentenay su taluꞌ nu Gamaꞌu, puꞌ ndiꞌ amu metuudan dun su sinuguꞌen medini. ");
INSERT INTO syb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Penilung niu su Misulat Taluꞌ nu Megbebayaꞌ, puꞌ laung niu dun saꞌ penemalan niu gupia besaay, mpeduma amu tu ketubuꞌ ndaꞌi tamanen. Laak dagid ki sinulat kiin, miketakesiꞌ dadema dinaan. ");
INSERT INTO syb_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Laak dagid pia mitakesiꞌanu dun, ndaꞌ amu pekpaingabang dinaan, adun mpeduma amu sia tu ketubuꞌ ndaꞌi tamanen.” ");
INSERT INTO syb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Diksuꞌ ni Isus su taluꞌen, “Naa, kanaꞌu tuyuꞌ penalanu nu nga getaw. ");
INSERT INTO syb_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Laak yamu nu nga kaunutan, misuunan ku sug betad niu, misuunan ku dadema puꞌ ndiꞌ amu mekpetail tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Pigwekilanu nu Gamaꞌu medini, laak dagid ndaꞌ niau penembaꞌay. Saꞌ upama lain tawani medini mekpuun tu pegbayaꞌen laak, iini penembaꞌen niu. ");
INSERT INTO syb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Iini mauyaꞌan niu, mpenalan amu nu ngag duma niu, laak mpauk amu penalan nu Megbebayaꞌ salanen da, kaas mekendutaꞌ mai kekpetuud niu dinaan? ");
INSERT INTO syb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Naa mabuꞌ laung niu dun dengaten ku amu tu Gamaꞌu. Ndiꞌu. Iini dumangat, si Moises, su siligan niu tantu. ");
INSERT INTO syb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Laung niu dun mituudan amu ditu sinulat ni Moises, laak dagid saꞌ iin siai pituud niu, pituud niau dadema sia, puꞌ itu su sinulaten mekatag dinaan. ");
INSERT INTO syb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mendadi kagina ndiꞌ amu mekpetuud ditu sinulat ni Moises, ndiꞌ damu dema mekpetuud ditu petuꞌun ku.” ");
INSERT INTO syb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Naa tubus itu, duminipag si Isus dig Linaw Galilea (sala piningalan dun sug Linaw Tiberias). ");
INSERT INTO syb_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Melaun gupia getaw miglendug dini Isus, sabaꞌ minitaꞌ nilan su nga mekesalebuꞌ tuꞌus pinggulaulanen saꞌ pineguliꞌanen su pemegladu. ");
INSERT INTO syb_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tumiwad si Isus dig bentud, ilan nu nga sakupen, dayun ilan megingkud dia. ");
INSERT INTO syb_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Naa sungu na mektelipuun sug Lumpuk tug Liniusan. ");
INSERT INTO syb_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Mendadi, benaꞌ midayag ni Isus su nga mimeglendug getaw pangay dia niin, sinaaken dini Felipe, “Adin ta ma mesaluyi gaan, sukal paan ta sia di melaun getaw kini?” ");
INSERT INTO syb_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Naa su piksaak kini ni Isus dini Felipe, pingindananen laak si Felipe, puꞌ suunanen ki penggulaulaanen sungu.) ");
INSERT INTO syb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Kaliꞌ sembag si Felipe, “Ndiꞌ ta megaga, puꞌ pia bali duaꞌ gatus denario siai pan, kulang pa dinilan, pia pekaikaꞌen gupia.” ");
INSERT INTO syb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Naa sala tawan sakup ngalanen si Andres, ngudan ni Pedro, laungen dini Isus, ");
INSERT INTO syb_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Duuni gembataꞌ dini migbalun lima buuk pan sebada, mukaꞌ duaꞌ buuk sedaꞌ. Laak kendutaꞌen ta ma dun pekpaan di nga melaun getaw kini?” ");
INSERT INTO syb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","“Naa, pemaingkud niui nga getaw kia,” laung ni Isus. (Puꞌ meliwagig lamalama dia.) Saꞌ maꞌnia, mimegingkud dayun su nga getaw, duun saanig lima ngibu tawan su laak lumbus laki. ");
INSERT INTO syb_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Inalap dayun ni Isus ki pan kia, mikpaladpalad tu Megbebayaꞌ, dayun pikilasilasen tu nga getaw pemegingkud dia. Maꞌantu dadema sug duaꞌ buuk sedaꞌ, pikilasilasen dadema dinilan. Minaan dayun ki kelaun getaw, taman luminukas ilan maan. ");
INSERT INTO syb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Naa benaꞌ migelaꞌ ilan mbesug, laung ni Isus tu nga sakupen, “Pengikpes niui nga sawad, adun ndaꞌiduni mekulaꞌulaꞌ.” ");
INSERT INTO syb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kaliꞌ nilan pengikpesay, sepuluꞌ buꞌ duaꞌ dig belanani mipenuꞌ pa nu samaꞌ tug lima buuk pan sebada ginaan nu nga getaw kia. ");
INSERT INTO syb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Benaꞌ minitaꞌ nu nga getaw ki mekesalebuꞌ tuꞌus kia pinggulaula ni Isus, laung nilan, “Kini na tuꞌu su Pimuunan nu Megbebayaꞌ pedetengen ta lumusad dinig lumbang!” ");
INSERT INTO syb_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Laak si Isus, benaꞌ misuunanen puꞌ sungu lumpakay nu nga getaw adun petegelan nilan sia meglegadiꞌ dinilan, laak migawaꞌ dia nilan. Minundas salanen tug binentudan. ");
INSERT INTO syb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Naa benaꞌ mikagaw gebii buꞌ gendaw, duminiksun su nga sakup ni Isus tu geksid linaw. ");
INSERT INTO syb_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Duminangan ilan di sekayan, suminakay ilan dayun dumipag pangay tug lunsud Capernaum. Gibii ilan diag linaw, laak ndaꞌ pa peglendug dinilan si Isus. ");
INSERT INTO syb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Duminuluki metikteg genus, mimukay sug linaw. ");
INSERT INTO syb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Naa benaꞌ pimelulanan nilan, duun saanig lima kilumitrui giniginanen, minitaꞌ nilan si Isus, masiꞌ pekpanaw diag dibabaw tubig, misebang dia sekayan nilan. Mipatiꞌ ilan mendek. ");
INSERT INTO syb_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Dagid miktaluꞌ si Isus dinilan, “Naa, ndiꞌ amu mendek. Naan daini!” ");
INSERT INTO syb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Pisakay nilan dayun iin dia sekayan nilan. Mitekaw dayun mateng tu pegengayan nilan su sekayan nilan kia. ");
INSERT INTO syb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Naa benaꞌ migendaw puliꞌ, su nga getaw mibilin ditug dipag, misuunan nilan puꞌ salabuuk laaki sekayan midengguꞌ dia kalabung, mukaꞌ saꞌ suminakay su nga sakupen, ndaꞌ pegdunut si Isus, su nga sakupen laaki suminakay. ");
INSERT INTO syb_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Naa duuni ngag duma sekayan genat tu Tiberias midengguꞌ dia tandaꞌ mesempel pingaanan nilan nu nga pan kiin saꞌ genat mekpaladpalad dun tu Megbebayaꞌ su Kaunutan si Isus. ");
INSERT INTO syb_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Benaꞌ misuunan nu nga getaw puꞌ ndaꞌ na dia si Isus dakus su nga sakupen, suminakay dailan dema di nga sekayan kia, pangay ilan ditu Capernaum, penengaun nilan si Isus. ");
INSERT INTO syb_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Naa benaꞌ mibaangan nu nga getaw si Isus ditug dipag linaw, sinaak nilan diniin, “Sir, nanuun ka minateng dini?” ");
INSERT INTO syb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Kaliꞌ sembag si Isus, “Taman taluꞌu diniu, kanaꞌ iini menengaw amu dun dinaan puꞌ sabaꞌ nu kesabut niu tu tuꞌus pinggulaulau. Segaga, iin sungkini menengaw amu dun, puꞌ sabaꞌ nu kepaꞌaan ku diniu kalabung nu pan, mibesug amu dun gelaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Naa ndiꞌ namu penamal meksukat gaan mekpetubuꞌ dig lawas niu, puꞌ kiin, duuni gikteben. Subay penamal amu sukat gaan megbegay ketubuꞌ ndaꞌi tamanen. Iin su gaan begayu diniu, puꞌ pinitaꞌ na nu Gamaꞌu Megbebayaꞌ puꞌ bigayanu niin pegbayaꞌu, naan kini, kig Bataꞌ nu Kilawan.” ");
INSERT INTO syb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kaliꞌ ilan saak diniin, “Kendutaꞌ mai kedunut nami tu mauyaꞌan nu Megbebayaꞌ?” ");
INSERT INTO syb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Kaliꞌ sembag si Isus, “Iini mauyaꞌan nu Megbebayaꞌ baalen niu, petuuden niu ki sinuguꞌen medini niu.” ");
INSERT INTO syb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kaliꞌ ilan pektaluꞌ, “Naa saꞌ maꞌantu, paitaꞌ mu dinamii mekesalebuꞌ tuꞌus, adun metuudan ami dun. Taꞌ alandun mai penggulaulaan mu? ");
INSERT INTO syb_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Saꞌ pinenggiꞌ maaꞌ nu ginaan nu ginepuꞌay ta diag limawaꞌ, su gaan genat tug langit, puꞌ sinulat dengantu, ‘Bigay ni Moises dinilan gaan genat tug langit.’” ");
INSERT INTO syb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Kaliꞌ pektaluꞌ si Isus, “Taman taluꞌu diniu, kanaꞌ ni Moisesi migbegay diniu gaan genat tug langit, su laak Gamaꞌu. Mukaꞌ nemun kini, begay diniu nu Gamaꞌu ki tantu gaan genat tug langit. ");
INSERT INTO syb_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Puꞌ su gaan begay nu Megbebayaꞌ, lumusad genat tug langit. Ki gaan kini, iin su megbegay tu tibaꞌan getaw ketubuꞌ ndaꞌi tamanen.” ");
INSERT INTO syb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","“Sir,” laung nilan, “saꞌ megdadi, begayay mu ami lelayun di gaan kiin.” ");
INSERT INTO syb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Kaliꞌ pektaluꞌ si Isus, “Naani gaan kini, puꞌ megbegayu tu tibaꞌan getaw ketubuꞌ ndaꞌi tamanen. Adin su getaw mekpaingabang dinaan, ndiꞌ na puliꞌ megutem. Adin su metuudan dinaan, ndiꞌ na puliꞌ kuaun.” ");
INSERT INTO syb_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Naa,” laung padun ni Isus, “iini tinaluꞌu diniu puꞌ minitaꞌ niau laak ndaꞌ niau petuuday. ");
INSERT INTO syb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Pia na. Adin su tinduꞌ nu Gamaꞌu sumakup dinaan, mekpaingabang dinaan, mukaꞌ lumbus, penembaꞌen ku. ");
INSERT INTO syb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Puꞌ ndaꞌu lusad genat tug langit adun petuuden ku sug danaan delendeman. Segaga iini luminusadu dun, petuuden ku su mauyaꞌan nu suminuguꞌ dinaan. ");
INSERT INTO syb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Iini mauyaꞌan nu suminguꞌ dinaan, ndiꞌu mbeleng su nga sakup bigayen dinaan, pia sala tawan dinilan. Dayun saꞌ sungu melengkebig benwa, gelaꞌen ku ilan petubuꞌay puliꞌ. ");
INSERT INTO syb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Puꞌ iin pa pagidi mauyaꞌan nu Gamaꞌu, adin su mekailala dinaan kini, kig Bataꞌen, mukaꞌ mekpetuud dinaan, naa mpeduunan ketubuꞌ ndaꞌi tamanen. Mukaꞌ saꞌ sungu melengkebig benwa, petubuꞌen ku puliꞌ.” ");
INSERT INTO syb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Mendadi su nga getaw Judea dia, mikunlumunlum ilan, pigbensi nilan dun ki tinaluꞌ kia ni Isus, laungen, “Naa, naan laungi gaan kini luminusad genat tug langit.” ");
INSERT INTO syb_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Kaliꞌ ilan peksinaakay, “Asa ki getaw kini, kanaꞌ bain si Isus, sug bataꞌ laak ni Jose? Miꞌilala ta gupia su mekegulangen. Maumanen ma teluꞌay, iin su genat tug langit?” ");
INSERT INTO syb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Kaliꞌ pelum pektaluꞌ si Isus, “Ndiꞌ amu dega pekunlumunlum maꞌniin. ");
INSERT INTO syb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ndaꞌi getaw mekesakup dinaan saꞌ kanaꞌ iini egaken nu Gamaꞌu, su suminuguꞌ dinaan. Mukaꞌ ki sumakup dinaan, petubuꞌen ku puliꞌ saꞌ sungu melengkebig benwa. ");
INSERT INTO syb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ndaꞌ ba sulat nu nga pimuunan nu Megbebayaꞌ dengantu, laung nilan, ‘Ki tibaꞌan getaw, petuꞌunan nu Megbebayaꞌ.’ Naa adin su mektalenten tu pituꞌun nu Gamaꞌu, menembaꞌ dinaan. ");
INSERT INTO syb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Laak ndaꞌu teluꞌay puꞌ duuni mikaitaꞌ tu Gamaꞌu. Naan laaki mikaitaꞌ tu Megbebayaꞌ, puꞌ su Megbebayaꞌi pigenatan ku. ");
INSERT INTO syb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Taman taluꞌu diniu, adin su metuudan dinaan, iin laaki mpeduunan ketubuꞌ ndaꞌi tamanen. ");
INSERT INTO syb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Puꞌ naani gaan, puꞌ megbegayu tu tibaꞌan getaw ketubuꞌ ndaꞌi tamanen. ");
INSERT INTO syb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Naa su nga ginepuꞌay niu, saanan nilan ditug limawaꞌ, iin daanig lebungan seleman nilan su gaan pilusad dinilan nu Megbebayaꞌ. Laak dagid pia maꞌantu, benaꞌ minatengi gumul nilan, migelaꞌ dailan matay. ");
INSERT INTO syb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Laini tantu gaan lumusad genat tug langit, puꞌ adin su maan dun, ndiꞌ na matay. ");
INSERT INTO syb_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mukaꞌ naani gaan luminusad genat tug langit megbegay ketubuꞌ. Saꞌ maan su getaw di gaan kini, iini metubuꞌ di ndaꞌi tamanen. Mukaꞌ ki gaan begayu, iini gunedu, begayu adun metubuꞌi tibaꞌan getaw.” ");
INSERT INTO syb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Benaꞌ midengeg nu nga getaw Judea dia, miksinualay ilan patiꞌ, kaliꞌ ilan pektaluꞌ, “Pekendutaꞌen dun nu getaw kini kepaꞌaanen dinita tu guneden?” ");
INSERT INTO syb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Mendadi diksuꞌ ni Isus su taluꞌen dinilan, “Taman taluꞌu diniu, saꞌ ndiꞌ niu aanen su guned nug Bataꞌ nu Kilawan, mukaꞌ saꞌ ndiꞌ niu inumen sug duguꞌen, naa ndiꞌ niu malap su ketubuꞌ ndaꞌi tamanen. ");
INSERT INTO syb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Naa naan kini, kig Bataꞌ nu Kilawan, adin su getaw maan di gunedu mukaꞌ minum dig duguꞌu, iini mpeduma tu ketubuꞌ ndaꞌi tamanen. Saꞌ sungu melengkebig benwa, petubuꞌen ku dadema iin puliꞌ. ");
INSERT INTO syb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Puꞌ iini tantu gaan su gunedu, mukaꞌ kig duguꞌui tantu ginumen, ");
INSERT INTO syb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","kaas adin su getaw maan di gunedu mukaꞌ minum dig duguꞌu, dumangen dini naan, mukaꞌ naan, diin dau dema niin. ");
INSERT INTO syb_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Suminuguꞌ dinaan su Gamaꞌu. Kagina tetubuꞌ iin, metubuꞌ dau dema. Maꞌantu dadema, adin su maan dinaan, metubuꞌ dadema iin. ");
INSERT INTO syb_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mendadi naan laaki tantu gaan luminusad genat tug langit, kanaꞌ maaꞌ nu ginaan nu nga ginepuꞌay niu, puꞌ minatay dailan. Adin su maan di gaan tantu kini, metubuꞌ di ndaꞌi tamanen.” ");
INSERT INTO syb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tinaluꞌ ia ni Isus sinegayen mekpetuꞌun dia simbaan nu getaw Judea ditu Capernaum. ");
INSERT INTO syb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Benaꞌ midengeg nu nga sakup ni Isusi tinaluꞌen kia, melaun dinilani miktaluꞌ, “Ndiꞌ ta muitani tinaluꞌen kini. Taꞌ mai mekesanguꞌ dun ini?” ");
INSERT INTO syb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Mendadi, kini si Isus, misuunanen su kegbensi nu nga sakupen kia pia ndaꞌ pesuun dun. Kaliꞌ pektaluꞌ dinilan, “Mauyaꞌan ba niu mundang amu sabaꞌ nu tinaluꞌu kia? ");
INSERT INTO syb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Saꞌ maitaꞌ niu kig Bataꞌ nu Kilawan, naan kini, luntuu puliꞌ ditu pigenatan ku, melegenan pa bamu gusay? ");
INSERT INTO syb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kanaꞌ nu pegbayaꞌ nu getaw megbegay ketubuꞌ tu getaw, su laak Balakat nu Megbebayaꞌ. Naa, ki tinaluꞌu kini, iini meguit diniu Balakat nu Megbebayaꞌ megbegay ketubuꞌ. ");
INSERT INTO syb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Laak duun diniui ndiꞌ metuudan dinaan.” (Kaas maꞌniai tinaluꞌ ni Isus, puꞌ genat tu puunanen, misuunanen su nga ndiꞌ metuudan dun, mukaꞌ misuunanen dadema ki tumipu diniin.) ");
INSERT INTO syb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kaliꞌ padun pektaluꞌ si Isus di nga sakupen kia, “Kaas maꞌniai tinaluꞌu diniu, puꞌ ndaꞌi mekenembaꞌ dinaan, subay pedelendem dun nu Gamaꞌu.” ");
INSERT INTO syb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Mendadi genat tu ketaluꞌen dun kia, melaun sakup ni Isus tumiliud diniin, ndaꞌ nailan dunut diniin. ");
INSERT INTO syb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Saꞌ maꞌnia, suminaak si Isus tu sepuluꞌ buꞌ duaꞌ tawan peneliganen, laungen, “Mendadi yamu, tuliud damu dema dinaan?” ");
INSERT INTO syb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Sumimbag si Simon Pedro, “Uu Kaunutan, saꞌ tuliud ami diniꞌa, taway dun bai pegengagan nami? Sug daniꞌa taluꞌ laaki mekegbegay tu ketubuꞌ ndaꞌi tamanen. ");
INSERT INTO syb_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Mukaꞌ mituudan ami gupia diniꞌa, suunan nami puꞌ yaꞌa na gupia su Pimiliꞌ nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Kaliꞌ sembag si Isus, “Naa kanaꞌ ba metuud, pimiliꞌu amu nu sepuluꞌ buꞌ duaꞌ tawan? Dayun sala tawan diniu, menulay!” ");
INSERT INTO syb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ki tinaluꞌ kini ni Isus, pilebuꞌanen dun si Judas, kig bataꞌ ni Simon Iscariote kiin. Puꞌ pia sala tawan si Judas di nga sepuluꞌ buꞌ duaꞌ tawan peneliganen, iini tumipu pa dini Isus. ");
INSERT INTO syb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Genat itu, mipanaw si Isus dia laak benwa Galilea. Ndaꞌ peditu Judea, puꞌ su nga kaunutan nu getaw Judea ditu, mekpatay ilan sia diniin. ");
INSERT INTO syb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mendadi, sungu na mektelipuun sug lumpuk nu nga getaw Judea piningalan dun sug Lumpuk ngag Bebelayan. ");
INSERT INTO syb_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Kaliꞌ pektaluꞌ dini Isus su nga pateden, “Tumuꞌ awaꞌa dini, dituun ka Judea, adun maitaꞌ nu nga sakup mu ditu ki penggulaulaan mu. ");
INSERT INTO syb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Puꞌ su getaw saꞌ mekpededengeg, ndiꞌen egluden su penggulaulaanen. Ki nga penggulaulaan mu kini, subay pedayag mu tu tibaꞌan getaw!” ");
INSERT INTO syb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Iini tinaluꞌ dun nu nga patedeni maꞌnia, puꞌ pia ilan, ndaꞌ ilan pekpetuud diniin.) ");
INSERT INTO syb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Kaliꞌ pektaluꞌ si Isus, “Paa, naan, ndaꞌ pa dateng ki gendawu. Yamu, pia taꞌ endaway dun, megdadi da. ");
INSERT INTO syb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ndiꞌ amu mesengay nu nga kilawan, dagid naan, misengayu nilan, puꞌ penluksaden ku dinilan melaatig betad nilan. ");
INSERT INTO syb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mendadi, yamu nai peditug lumpuk. Naan, ndiꞌu meditu, puꞌ ndaꞌ pa dateng ki gendawu.” ");
INSERT INTO syb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Saꞌ maꞌniai tinaluꞌen, mibilin dia Galilea si Isus. ");
INSERT INTO syb_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Mendadi benaꞌ miditug lumpuk su nga pated ni Isus mukaꞌ duuni santaꞌ gebii, miditu dadema si Isus, laak dagid ndaꞌ pailagilag dia. ");
INSERT INTO syb_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Naa ki nga kaunutan nu getaw Judea, pekpenengaun nilan si Isus diag lumpuk, sinaak nilan tu nga getaw, “Adin main?” ");
INSERT INTO syb_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Su nga melaun getaw suminaup, miglelekemeday ilan patiꞌ mekatag dini Isus. Duuni miktaluꞌ, “Gempia getaw iin,” duun dademai miktaluꞌ, “Kanaꞌ ma da, peglimbunganen su nga getaw.” ");
INSERT INTO syb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Laak pigbuni nilan su teluꞌen nilan kia, puꞌ mindek ilan tu nga kaunutan nu getaw Judea. ");
INSERT INTO syb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mendadi benaꞌ miginengaꞌ na saan sug lumpuk, miditu si Isus Balay Pengedapan tu Megbebayaꞌ, piktuꞌunanen su nga getaw dia. ");
INSERT INTO syb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ki nga kaunutan nu getaw Judea, misebuꞌan ilan dun, kaliꞌ ilan peksinaakay, “Paa, ki getaw kini, pikendun ma dun metaasi sinuunanen, asa ndaꞌ ma petuꞌunay di Palinta ta?” ");
INSERT INTO syb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Mendadi kaliꞌ pektaluꞌ si Isus, “Ki tinituluꞌu kini, kanaꞌ danaan delendeman, segaga danu suminuguꞌ dinaan. ");
INSERT INTO syb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Adin su getaw delendemanen penggulaulaanen su mauyaꞌan nu Megbebayaꞌ, mesuunanen saꞌ taꞌi pigenatan nu tituluꞌu, saꞌ genat ba tu Megbebayaꞌ, saꞌ mikpuun bain tug danaan laak pegbayaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Adin su mekpetuꞌun puun dig daniin laak pegbayaꞌ, mekpenalenal da, laak dagid adin su mekpetuꞌun adun pegleleepenenig dengegan nu Megbebayaꞌ, su suminuguꞌ diniin, iini tantu mekpetuꞌun, kanaꞌ belusen. ");
INSERT INTO syb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Maꞌniin ni Moises, bigayanen amu Palinta nu Megbebayaꞌ dengantu, laak dagid, ndaꞌiduni getaw diniu dinunutanen gelaꞌ su Palinta kia. Puꞌ saꞌ sia duun diniui getaw dinunutanen gelaꞌ su Palinta, mauma dema naan, petain ma niau sia, asa duuni pinalinta ni Moises, ndiꞌ mekpatay?” ");
INSERT INTO syb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Kaliꞌ sembag su melaun getaw, “Pingepuꞌan ka menulay! Pia ndaꞌi miksaad matay diniꞌa.” ");
INSERT INTO syb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Kaliꞌ padun sembag si Isus dinilan, “Naa, mainsan pinggulaulaui mekesalebuꞌ, mitekawan amu dun, launan niu. ");
INSERT INTO syb_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Bentayay pa daan niu. Pinalinta diniu ni Moises pentuꞌusan niuig bataꞌ niu puꞌ getaw Judea nailan, kaas megbaal amu tuꞌus, pia di Gendaw Pelali (laak kanaꞌ ni Moisesi pigenatanen, su laak nga ginepuꞌay niu). ");
INSERT INTO syb_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Naa, saꞌ sirkunsisuuni getaw di Gendaw Pelali, puꞌ adun medunutani palinta ni Moises, taꞌ mai mangit amu dun dinaan saꞌ pineguliꞌan ku gupiaig lawas nu getaw kiin di Gendaw Pelali? ");
INSERT INTO syb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mendadi, ndiꞌ amu pegdedaliꞌ mengukum di minitaꞌ niu, subay unaan pa niu pegdelendem saꞌ gempia ba su pinggulaula, saꞌ melaaten ba.” ");
INSERT INTO syb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Naa duuni nga getaw Jerusalem miktaluꞌ, “Ki getaw kini, kanaꞌ bain su petain sia nu nga kaunutan? ");
INSERT INTO syb_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Laak bentayay pa daan niu, megyaga iin di gedapan, laak ndiꞌ nilan pemaagen! Aa, mabuꞌ misuunan ba nilan puꞌ iinen tuꞌu su Tinduꞌ nu Megbebayaꞌ Meglekaunutan? ");
INSERT INTO syb_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Dagid saꞌ mateng daw su Tinduꞌ nu Megbebayaꞌ, ndaꞌ dawi mekesuun dun ki pegenatanen. Naa kig launan ta kini, misuunan ta su pigenatan nu getaw kini.” ");
INSERT INTO syb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Mendadi, selian ni Isus mekpetuꞌun dia Pengedapan tu Megbebayaꞌ, minekeg mektaluꞌ, laungen, “Naa, laung niu dun puꞌ miꞌilala ba niau mukaꞌ misuunan ba niui pigenatan ku? Kanaꞌ danaan delendeman su kediniin ku. Metuud, duuni Megbebayaꞌ mukaꞌ iini suminuguꞌ dinaan, laak iin, kanaꞌ niu mailala. ");
INSERT INTO syb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Dagid naan, mikesuunu diniin, puꞌ iini pigenatan ku, mukaꞌ iini suminuguꞌ dinaan medini.” ");
INSERT INTO syb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Mendadi ki nga kaunutan kia, sikna midengeg nilan, daapen nilan sia si Isus, laak ndaꞌi mekedaap dun, puꞌ ndaꞌ pa dateng ki gendawen. ");
INSERT INTO syb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Laak melaun getaw dia, mituudan ilan dini Isus, laung nilan, “Saꞌ metuaꞌ su Tinduꞌ nu Megbebayaꞌ Meglekaunutan, melaun pai mekesalebuꞌ penggulaulaanen, sabayaꞌ nu getaw kini?” ");
INSERT INTO syb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Naa ki nga Pariseo, midengeg nilan su kaunlumunlum kia nu nga melaun getaw mekatag dini Isus. Saꞌ maꞌnia, ilan kia mukaꞌ su nga kaunutan nug belian nu getaw Judea, sinuguꞌ nilan dayuni nga megingat tu Pengedapan tu Megbebayaꞌ, adun daapen nilan si Isus. ");
INSERT INTO syb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kaliꞌ pektaluꞌ si Isus, “Dumuma pau diniu ndiꞌ maiben, dayun megawaꞌu dini, mpuliꞌu ditu suminuguꞌ dinaan. ");
INSERT INTO syb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Dayun penengaun niau, laak ndiꞌ niau mbaangan, puꞌ ndiꞌ amu mekeditu pegengayan ku.” ");
INSERT INTO syb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Naa ki nga kaunutan nu getaw Judea kia, miksinaakay ilan dayun, laung nilan, “Adin ma saan angayi getaw kini, ndiꞌ ta mbaangan? Mabuꞌ mangay ditu ngag duma ta misigwag, su luminamug tu nga getaw Grecia, puꞌ adun petuꞌunanen pelum su nga getaw Grecia? ");
INSERT INTO syb_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Taꞌ mai guluganen ki tinaluꞌen kia puꞌ penengaun ta, laak ndiꞌ tain mbaangan, puꞌ ndiꞌ ita mekeditu daw pegengayanen?” ");
INSERT INTO syb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Naa benaꞌ sug deksuꞌan nug Lumpuk nug Liniusan, si Isus, migindeg di gedapan nug launan getaw, minekeg dayun mektaluꞌ dinilan, “Pia adini getaw kuaun, mekangay minum dini naan. ");
INSERT INTO syb_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ndaꞌ ba mesulat di Misulat Taluꞌ nu Megbebayaꞌ, ‘Adin su metuudan dinaan, duuni maaꞌ nu tebud dig dialem ginaanen menelegan megbegay ketubuꞌ ndaꞌi tamanen.’” ");
INSERT INTO syb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Naa, ki tinaluꞌ ni Isus kia, iini mekatag di penggulaula nug Balakat nu Megbebayaꞌ, su sungu begay tu nga mekpetuud diniin. Ndaꞌ pa ia begay, puꞌ ndaꞌ pa lentu si Isus ditu gekbus langit adun maitaꞌ nug launan biwat su kelengas nu pegbayaꞌen. ");
INSERT INTO syb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Naa benaꞌ midengeg nu nga melaun getaw ki tinaluꞌ kia ni Isus, duuni miktaluꞌ, “Ki getaw kini, iinen na tuꞌu su pedetengen ta Pimuunan nu Megbebayaꞌ!” ");
INSERT INTO syb_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Saꞌ sug dumai mektaluꞌ, laung nilan, “Iinen na tuꞌu su Tinduꞌ nu Megbebayaꞌ Meglekaunutan!” Dagid duun pa pagidi mektaluꞌ, “Su Tinduꞌ nu Megbebayaꞌ Meglekaunutan, kanaꞌ ma genat tu Galilea! ");
INSERT INTO syb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Iini sinulat ditu Misulat Taluꞌ nu Megbebayaꞌ, su Tinduꞌ nu Megbebayaꞌ Meglekaunutan, sapuꞌ ni Adiꞌ David, kaas genat dig Betlehem, sug lunsud ni David.” ");
INSERT INTO syb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Iin dayuni sumpakiꞌ nug delendeman nu nga getaw mekatag dini Isus. ");
INSERT INTO syb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Sug duma, mauyaꞌan nilan sia daapen iin, laak ndaꞌ pai kedaap diniin. ");
INSERT INTO syb_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Naa su nga megingat tu Pengedapan kiin, benaꞌ mipuliꞌ ilan ditu nga kaunutan nug belian mukaꞌ tu nga Pariseo kia, sinaakan ilan, “Naa, mauma dema ndaꞌ ma niu iin uitay?” ");
INSERT INTO syb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Kaliꞌ sembag su nga megingat, “Puꞌ iin pa duuni getaw mikiteluꞌay maaꞌ nu getaw kiin!” ");
INSERT INTO syb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","“Apelai!” sinaak nu nga Pariseo. “Milimbungan damu niin dema? ");
INSERT INTO syb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Saꞌ yami nu nga kaunutan mukaꞌ Pariseo, duun bai misuunan niu sala tawan dinami mituudan di getaw kiin? ");
INSERT INTO syb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Baa, nga melaun getaw kini! Ndaꞌ nilan mesuunay su Palinta nu Megbebayaꞌ pisulaten dini Moises, kaas inukuman nailan nu Megbebayaꞌ!” ");
INSERT INTO syb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Naa sala tawan di nga Pariseo kia, si Nicodemo, su miditu ni Isus sug diin kiin. Kaliꞌ pektaluꞌ si Nicodemo, ");
INSERT INTO syb_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Asa binandu ditu Palinta ta, ukumani getaw subay unaan pa biselaay.” ");
INSERT INTO syb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Kaliꞌ sembag su nga Pariseo, “Masiꞌ yaꞌa, dumaa dadema niin getaw Galilea? Naa, penilung mu su Misulat Taluꞌ nu Megbebayaꞌ. Mesuunan mu dayun, ndaꞌi pimuunan nu Megbebayaꞌ genat tu Galilea.” ");
INSERT INTO syb_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Saꞌ maꞌantu, minuliꞌ su nga kelaun getaw. ");
INSERT INTO syb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Laak si Isus, miditug Bentud nu nga Gayu Olibo. ");
INSERT INTO syb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Benaꞌ migendaw puliꞌ, milapus mangay ditug Balay Pengedapan tu Megbebayaꞌ. Dekag minateng dia, mikpungun diniin su melaun getaw. Migingkud dayun si Isus, piktuꞌunanen ilan. ");
INSERT INTO syb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Naa duunig libun iwit dia nu nga mekpetuꞌun di Palinta nu Megbebayaꞌ mukaꞌ nu nga Pariseo. Kig libun kini, duun dawi mikaitaꞌ dun, tebiaꞌ miglaat pekesuunan. Mendadi, pinindeg nilan dia gedapan nu nga getaw kig libun kia. ");
INSERT INTO syb_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Laung nu miguit dun dia, “Sir, kig libun kini, duuni mikaitaꞌ dun gupia miglaat pekesuunan daw. ");
INSERT INTO syb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Naa, iini palinta nu Megbebayaꞌ dinita pisulaten dini Moises, subay betuun ta. Mendadi yaꞌa, taꞌ mai ketaluꞌ mu dun?” ");
INSERT INTO syb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Naa iini tinaluꞌ nilan duni maꞌnia, puꞌ pengimanan nilan sia si Isus di metaluꞌen, adun dengaten nilan sia. Mendadi si Isus, migdukung, sinulatanen tenduꞌen sug lupaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Minamal ilan dayun sumaak diniin. Migindeg dayun si Isus, kaliꞌ pektaluꞌ, “Naa, adin diniui ndaꞌi salaꞌen, iini meguna megbatu dun.” ");
INSERT INTO syb_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Migdukung puliꞌ si Isus, dayun peksulat puliꞌ diag lupaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Mendadi ki nga getaw kia, mimegawaꞌ ilan dayun dia, piksesala tawan dinilan mipanaw, miguna su nga megulang dinilan. Tigaꞌwan, iin laaki mibilin dia si Isus, dumanen laak sug libun pegindeg pa dia. ");
INSERT INTO syb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Mendadi, migindeg puliꞌ si Isus, kaliꞌ saak tug libun, “Ibun, adin mailan? Ndaꞌ bai mbilin mukum diniꞌa?” ");
INSERT INTO syb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Kaliꞌ sembag, “Sir, ndaꞌidun.” “Mendadi naan,” laung ni Isus, “ndiꞌ dau dema mukum diniꞌa. Uliꞌa na, mukaꞌ ndiꞌa puliꞌ pegbaal salaꞌ.” ");
INSERT INTO syb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Naa, mikpetuꞌun puliꞌ si Isus tu nga getaw. Kaliꞌ pektaluꞌ, “Naa, pektalentenay niu ini. Naani Tiag mekpedelag di tibaꞌan getaw. Adin su getaw dumunut dinaan, iini medelagan nu Tiag, su puun nu ketubuꞌ ndaꞌi tamanen, mukaꞌ iin, ndiꞌ na mekepanaw di medelem.” ");
INSERT INTO syb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Kaliꞌ pektaluꞌ su nga Pariseo, “Naa, taꞌ mai metuudan ami dun, puꞌ yaꞌa laaki tuminakesiꞌ dun? Su takesiꞌ mu, ndaꞌi gatagen.” ");
INSERT INTO syb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Kaliꞌ sembag si Isus, “Pia naan laaki miketakesiꞌ dig lawasu, laak metuudi tinakesiꞌan ku, puꞌ misuunan kui pigenatan ku mukaꞌ peguliꞌan ku, laak yamu, ndaꞌ niu mesuunay ia. ");
INSERT INTO syb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Saꞌ mukum amu, su kinilawan dai pigunut niu. Naan, ndiꞌu mukum di kilawan. ");
INSERT INTO syb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Laak saꞌ pinenggiꞌ puꞌ mukumu di nga getaw, mpiai kaukumu dun, puꞌ kanaꞌu laak salai mukum dun, puꞌ dumananu dun nu suminuguꞌ dinaan. ");
INSERT INTO syb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Pektalentenay niu ini, misulat di Palinta niu sinulat ni Moises, saꞌ duaꞌ tawani meketakesiꞌ dun, mpemilang metuud su takesiꞌan nilan. ");
INSERT INTO syb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Naa, mitakesiꞌan kuig lawasu mukaꞌ tinakesiꞌan dau dema nu Gamaꞌu, su suminuguꞌ dinaan.” ");
INSERT INTO syb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kaliꞌ saak su nga Pariseo, “Naa ki gamaꞌ mu kini, adin ma dun?” Kaliꞌ sembag si Isus, “Ndiꞌ amu sumambat dinaan, mukaꞌ su Gamaꞌu dema, ndiꞌ amu sumambat dun. Saꞌ sia suminambat amu tantu dinaan, naa suminambat damu dema tantu tu Gamaꞌu.” ");
INSERT INTO syb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Kiai tinaluꞌ ni Isus su dia pa Pengedapan tu Megbebayaꞌ mekpetuꞌun dia nga getaw, dia mesempel nug betangan nu nga getaw gamut nilan ditu Pengedapan. Ndaꞌ pai duminaap dini Isus, puꞌ ndaꞌ pa datengi gendaw su tinduꞌ nu Megbebayaꞌ kedaap diniin. ");
INSERT INTO syb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Kaliꞌ padun pektaluꞌ si Isus tu nga getaw, “Naa mawaꞌu dini, penengaun niau dayun, laak ndiꞌ niau mbaangan. Kaas matay damu, ndaꞌ namu lelaatay di salaꞌ niu. Ndiꞌ amu mekeditu pegengayan ku.” ");
INSERT INTO syb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Naa, su nga kaunutan nu getaw Judea, kaliꞌ ilan pektaluꞌ, “Kagina tinaluꞌen puꞌ ndiꞌ ita mekeditu pegengayanen, mabuꞌ iini guluganen, megeget.” ");
INSERT INTO syb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Kaliꞌ sembag si Isus, “Yamu, dangen amu dinig lumbang. Naan, genatu tu gekbus langit, kaas sakup amu laak nu kekinilawan. Laak naan, kanaꞌu sakup kekinilawan. ");
INSERT INTO syb_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kiai tinaluꞌu dun puꞌ matay damu ndaꞌ namu lelaatay di nga salaꞌ niu. Matay amu tuꞌu ndaꞌ amu lelaatay, subay metuudan amu dun naan su pekteluꞌen ku kini.” ");
INSERT INTO syb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Kaliꞌ ilan saak, “Adin ka getaw?” Simbag dayun ni Isus, “Naa genat tu puunanen, naani pekteluꞌen ku diniu. ");
INSERT INTO syb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yamu kiin, melaun pa paduni metaluꞌu mekatag diniu, laak ndiꞌu teluꞌen. Melaun dademai maukuman ku amu dun, laak ndiꞌu dadema mukum. Su taluꞌ nu suminuguꞌ dinaan, iin su metuud mukaꞌ iin laaki ukiten ku di tibaꞌan getaw.” ");
INSERT INTO syb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Naa su nga mikedengeg tu tinaluꞌen kia, ndaꞌ nilan mesabut puꞌ su pekteluꞌenen dinilan, iin su Gamaꞌen Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Maꞌantu, kaliꞌ dayun pektaluꞌ si Isus, “Naanig Bataꞌ nu Kilawan. Saꞌ inaten na niau, mesuunan na niu puꞌ naan su pekteluꞌen ku kiin. Mukaꞌ dema mesuunan niu dayun ndaꞌi penggulaulaan ku mikpuun tug danaan pegbayaꞌ, puꞌ teluꞌen ku su laak pisuun dinaan nu Gamaꞌu. ");
INSERT INTO syb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Iin su suminuguꞌ dinaan, megduma lelayun dinaan mukaꞌ ndaꞌu niin petuyangay salau, puꞌ pinemalan ku lelayun penggulaulaay su mauyaꞌanen.” ");
INSERT INTO syb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Mendadi melauni nga mikedengeg tu tinaluꞌ kia ni Isus, mituudan ilan diniin. ");
INSERT INTO syb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Mendadi, kaliꞌ pektaluꞌ si Isus tu nga getaw Judea dia mikpetuud na diniin, “Saꞌ penemalan niu dunutay su teluꞌen ku, naa sakupu namu tantu. ");
INSERT INTO syb_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Mesuunan pa niu dayuni metuud mukaꞌ pebeluyen amu nu metuud.” ");
INSERT INTO syb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Su nga getaw Judea, kaliꞌ ilan pektaluꞌ, “Mauma dema teluꞌen mu puꞌ pebeluyen ami, asa sapuꞌ ami ni Abraham, ndaꞌ nami mainsan mbianayi gulipen di getaw. Taꞌ mai pengmaꞌanan mu pebeluyen ami?” ");
INSERT INTO syb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Kaliꞌ sembag si Isus, “Naa, taman taluꞌu diniu, adin su mikesalaꞌ, malap gulipen nu salaꞌen. ");
INSERT INTO syb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Saꞌ upama gulipen, kanaꞌ sakup lelayun nu mingulipen dun, laak dagid sug bataꞌ nu mikpaulipen dun, danilan da lelayun. ");
INSERT INTO syb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kaas saꞌ iini mekpebeluy diniu sug Bataꞌ nu Megbebayaꞌ, naa mbeluy damu gupia. ");
INSERT INTO syb_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Naa, misuunan ku puꞌ yamui sapuꞌ ni Abraham, laak pia maꞌantu, mauyaꞌan niu petain niau, puꞌ ndaꞌ pengganget dig delendeman niu su pekteluꞌen ku. ");
INSERT INTO syb_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Naan, piktuꞌun ku diniu su pinitaꞌ dinaan nu Gamaꞌu. Yamu dema, penggulaulaan niu su midengeg niu dig daniu gamaꞌ.” ");
INSERT INTO syb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Sumimbag ilan, “Sapuꞌ ami ni Abraham.” “Saꞌ upama sapuꞌ amu ni Abraham, penunggilingan niu sia su pinggulaula ni Abraham, ");
INSERT INTO syb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","laak dagid iini penggulaulaan niu sia, petain niau. Naa, ndaꞌi pinggulaula ni Abraham maꞌnia. Daal dai pinggulaulau, inukitu diniu su midengegu metuud tinaluꞌ nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Yamu, iini pinunggilingan niu, su pinggulaula nu tantu gamaꞌ niu.” “Salabuuk dai gamaꞌ nami, su da laak Megbebayaꞌ. Bataꞌ ami niin tantu.” ");
INSERT INTO syb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","“Kanaꞌ, puꞌ saꞌ iini tantu Gamaꞌ niu, petailen niau sia, puꞌ iini pigenatan ku su Megbebayaꞌ, mukaꞌ kini dau. Kanaꞌ laak puun tu pegbayaꞌu su kediniin ku, puꞌ iini suminuguꞌ dinaan su Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mauma dema ndaꞌ niu mesabuti taluꞌu? Iini pikpuunanen, ndiꞌ niu muit su pekteluꞌen ku. ");
INSERT INTO syb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mingemaꞌan damu gusay tu gamaꞌ niu, su Palin. Iin laaki mauyaꞌan niu pektalentenay, su mauyaꞌan nu Palin. Su Palin, genat tu pikpuunanen, memunuꞌan iin mukaꞌ belusen, puꞌ ndaꞌ na daan pegilengig delendemanen tu metuud, pia maikaꞌ. Saꞌ megbalus, bantangen da, puꞌ belusen, mukaꞌ iin demai pigenatan nug balus. ");
INSERT INTO syb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kaas, iini ndiꞌ amu metuudan dun dinaan, puꞌ teluꞌen ku su metuud. ");
INSERT INTO syb_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ndaꞌidun diniui mekeglegintuud dun puꞌ naani mikesalaꞌ. Saꞌ piglegintuudu su kekesuun, mauma dema ndaꞌ amu metuuday dun? ");
INSERT INTO syb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Pektalentenay niu ini, adin su tantu sakup nu Megbebayaꞌ, iini mekineeg tu taluꞌ nu Megbebayaꞌ, laak ndiꞌ niu pektalentenan, puꞌ kanaꞌ amu daniin piglegetawan.” ");
INSERT INTO syb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Mendadi ki nga getaw Judea kia, kaliꞌ ilan saak dini Isus, “Ndiꞌ ba metuud, yaꞌa su pekteluꞌen nami getaw Samaria, su pingepuꞌan menulay?” ");
INSERT INTO syb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Kaliꞌ sembag si Isus, “Ndaꞌu lai pengepuꞌay menulay. Adin su pinggulaulau, mekpebasau dun tu Gamaꞌu, laak yamu, piksudiꞌan niau. ");
INSERT INTO syb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ndaꞌu pegelapayi megdedengegu dun, laak dagid duuni mekpededengeg dun dinaan, puꞌ iini metau mukum. ");
INSERT INTO syb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Naa, taman taluꞌu diniu, adin su mekpetuud tu tinaluꞌu, ndiꞌ na matay.” ");
INSERT INTO syb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Kaliꞌ ilan taluꞌ diniin, “Nandaw, mitekad na nami tantu pingepuꞌan ka tuꞌu menulay! Puꞌ si Abraham mukaꞌ su nga pimuunan nu Megbebayaꞌ dengantu, minatay da. Dayun pelum iini teluꞌen mu, su mekpetuud di tinaluꞌ mu, ndaꞌ nai petayanen. ");
INSERT INTO syb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Su ginepuꞌay ta si Abraham, minatay da. Masiꞌ metaasa pa ba diniin? Su nga pimuunan nu Megbebayaꞌ dengantu, minatay dadema. Taiꞌ delendeman mu dun, adin ka getaw?” ");
INSERT INTO syb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Laung ni Isus, “Saꞌ naani migalap dun sug dengegan ku, ndaꞌi gatagen. Laak iini migbegay dun dinaan su Gamaꞌu, iin su tinaluꞌ niu pektemuyen niu. ");
INSERT INTO syb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Laak dagid sampay nemun, ndaꞌ niu iin sembatay. Naan, suminambatu gupia diniin. Saꞌ pinenggiꞌ gelalen ku ndaꞌu sembatay, naa, belusenu maꞌniin diniu, puꞌ suminambatu gupia diniin, mukaꞌ piktalentenan ku su teluꞌenen. ");
INSERT INTO syb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Naa si Abraham kiin, su gamaꞌ niu laung, pigleliag, puꞌ mikpedateng di ketuaꞌu dini. Naa minitaꞌen na, mukaꞌ liliag na gupia.” ");
INSERT INTO syb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","“Kendutaꞌ mai kaitaꞌ mu dini Abraham, asa ndaꞌ pa peglima puluꞌi taun mu?” ");
INSERT INTO syb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","“Taman taluꞌu diniu, su ndaꞌ pa pegigetaw si Abraham, naan, daan nau.” ");
INSERT INTO syb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Mingimud dayun batu su nga kaunutan kia, puꞌ betuun nilan sia si Isus adun matay. Laak dagid si Isus, luminamug tu tebenan getaw, migawaꞌ dayun dia Pengedapan tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Mendadi selian ni Isus mekpanaw, duuni mipekitaꞌen buta, mibuta sikna mbataꞌen. ");
INSERT INTO syb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Sinaak nu nga sakup ni Isus, “Sir, taꞌ mai mikesalaꞌ di maꞌnia kia, migigetaw, daan ma na buta? Iin, atawaka su nga mekegulangen?” ");
INSERT INTO syb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Kaliꞌ sembag si Isus, “Kanaꞌ iini mikesabaꞌ dun butai kegigetawen, puun di salaꞌen, sampay salaꞌ nu mekegulangen. Ki getaw kini, migigetaw dun buta, adun mpaitaꞌ nu Megbebayaꞌ su ginuungen pebian di penggulaulaanen diniin. ");
INSERT INTO syb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Naa selian gendaw pa, subay penggulaulaan ta su pipenggulaula dinita nu suminuguꞌ dinaan. Puꞌ ndiꞌ maiben, meglegebii na, dayun ndaꞌidun nai mekenggulaula dun. ");
INSERT INTO syb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Selian ku dinig lumbang, naani tiag tu tibaꞌan getaw.” ");
INSERT INTO syb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Selian ni Isus mektaluꞌ, migdulaꞌ dig lupaꞌ, binasaꞌen dun sug lawayen. Inugidanen dun dayun ki mata nug buta kia, ");
INSERT INTO syb_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","dunut miktaluꞌ diniin, “Naa, angaya tug Bulenaw Siloe, pengulamusa ditu.” (Su gulugan nu ngalan kia Siloe, “Sinuguꞌ.”) Mipanaw dayun kig buta kia diag bulenaw, mingulamus, dayun mipuliꞌ, mikengitaꞌ na. ");
INSERT INTO syb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Naa su nga sumbalay nug buta kia kampuꞌ nu getaw mikaitaꞌ diniin mekpenengi limus, sinaak nilan, “Kanaꞌ ba iinen ini su pegingkudingkud mekpenengi limus?” ");
INSERT INTO syb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Simbag nu ngag duma, “Iin main.” Laak laung nug duma getaw, “Kanaꞌen, ganggiden laak.” Kaliꞌ dayun pektaluꞌ ki miuliꞌan kia, “Naan laꞌ lai.” ");
INSERT INTO syb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","“Naa saꞌ maꞌantu,” sinaak nilan, “taꞌ mai mikengitaꞌa dun nandaw?” ");
INSERT INTO syb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Kaliꞌ sembag, “Ki getaw pegingelanan si Isus, migbasaꞌ lupaꞌ, binasaꞌen dun lawayen, inugiden dayun di matau. Tinaluꞌen dayun dinaan mangayu ditug Bulenaw Siloe, mengulamusu. Minangayu dayun mengulamus, iin dayuni kengitaꞌu.” ");
INSERT INTO syb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Sinaak nilan, “Naa ki getaw kiin, adin ma dun?” Kaliꞌ sembag su minayan buta, “Taꞌ dun.” ");
INSERT INTO syb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Naa ki minayan buta kia, iwit nu getaw tu gedapan nu nga Pariseo. ");
INSERT INTO syb_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Naa su kegbasaꞌ ni Isus lupaꞌ mukaꞌ kepauliꞌayen tug buta kia, mitaang di Gendaw Pelali. ");
INSERT INTO syb_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mendadi, sinaakan pelum nu nga Pariseo ki getaw kia, saꞌ taꞌig bian nu kengitaꞌen. Kaliꞌ sembag, “Ki getaw kiin, inugidanen ki matau basak. Benaꞌ mingulamusu, mikengitaꞌ nau dayun.” ");
INSERT INTO syb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Naa ki nga Pariseo kini, kaliꞌ pektaluꞌ sug duma, “Ki getaw kiin mineguliꞌ dun, kanaꞌ genat tu Megbebayaꞌ, puꞌ ndiꞌen pektalentenani Gendaw Pelali.” Laak sug duma pelum, laung nilan, “Naa saꞌ pinenggiꞌ mikesalaꞌ tuꞌui getaw kiin, mekendutaꞌ bai kenggulaulanen di nga mekesalebuꞌ kia?” Saꞌ maꞌnia, miksumpakiꞌ ilan dun. ");
INSERT INTO syb_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Naa saꞌ maꞌnia, sinaakan puliꞌ nu nga Pariseo su miuliꞌan kia, laung nilan, “Kagina yaꞌai pipengitaꞌ nu getaw kitu, taꞌ mai ketaluꞌ mu mekatag diniin?” Kaliꞌ sembag, “Mituudanu dun puꞌ pimuunan iin nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Naa ki nga kaunutan nu nga getaw Judea kini, beknanen, ndaꞌ ilan metuuday dun puꞌ ki getaw kia, daan buta, dayun mikengitaꞌ na. Saꞌ maꞌnia, pinsabi nilan su nga mekegulangen, ");
INSERT INTO syb_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","suminaak ilan dayun dinilan, “Bataꞌ niu maini? Naa, pekteluꞌen niu mibuta sikna mbataꞌen. Saꞌ maꞌantu, taꞌ mai mikengitaꞌ dun ia nandaw?” ");
INSERT INTO syb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Kaliꞌ sembag su nga mekegulangen, “Kini, misuunan nami puꞌ bataꞌ nami tantu, mukaꞌ misuunan nami, daan buta iin sikna mbataꞌen. ");
INSERT INTO syb_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Laak tumuꞌ ndaꞌ nami suunay saꞌ taꞌ mai mikengitaꞌ dun nandaw, mukaꞌ ndaꞌ nami dadema suunay saꞌ taꞌ taway duni mineguliꞌ dun. Tumuꞌ iin nai saakay niu, gembagel nain, metau na sumbag!” ");
INSERT INTO syb_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Kaas maꞌniai simbag dun nu nga mekegulangen, puꞌ mindek ilan di nga kaunutan kia. Puꞌ duuni sabut nu nga kaunutan, adin su meglegintuud dun puꞌ si Isus su Tinduꞌ nu Megbebayaꞌ Meglekaunutan, subay utidan di simbaan nu getaw Judea. ");
INSERT INTO syb_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kaas maꞌniai mitaluꞌ dun nu nga mekegulangen, laung nilan, “Gembagel ma na, iini saakay niu!” ");
INSERT INTO syb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mendadi, keduaꞌ deksuꞌ na sebiay ki minayan buta kini. Kaliꞌ ilan pektaluꞌ diniin, “Naa sapaa tu gedapan nu Megbebayaꞌ puꞌ teluꞌen mui metuud! Ki getaw kiin, suunan nami puꞌ mikesalaꞌ getaw iin.” ");
INSERT INTO syb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","“Taꞌ dun,” simbagen, “saꞌ mikesalaꞌ bain, saꞌ kanaꞌ. Iin laaki misuunan ku, butau, dagid nandaw, mekengitaꞌ nau.” ");
INSERT INTO syb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Sinaak nilan diniin, “Taꞌ maig binaalen diniꞌa? Pikendutaꞌen ma kauliꞌayi mata mu?” ");
INSERT INTO syb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Kaliꞌ sembag, “Naa, daan ku na tinaluꞌ diniu, laak ndaꞌ niu pekineegay. Naa mauma dema mauyaꞌan ma niu medengeg niu puliꞌ? Mauyaꞌan niu ba, sumakup damu dema diniin?” ");
INSERT INTO syb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Pinampalaksaan nilan dayun kig buta kia, laung nilan, “Paa, yaꞌa kiin, sakupa niin. Yami, sakup mami ni Moises. ");
INSERT INTO syb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Naa si Moises, misuunan nami puꞌ ginukitan tuꞌu iin nu Megbebayaꞌ. Laak ki getaw kiin, ndaꞌ nami suunay saꞌ adini pigenatanen!” ");
INSERT INTO syb_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Kaliꞌ pektaluꞌ su miuliꞌan buta, “Misebuꞌanu gupia diniu! Ndaꞌ niu suunay saꞌ adini pigenatanen, asa piuliꞌaneni matau! ");
INSERT INTO syb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Suunan ta puꞌ su nga mekesesalaꞌ getaw, ndiꞌ penembaꞌen nu Megbebayaꞌ su kenengi nilan. Penembaꞌen laak nu Megbebayaꞌ su kenengi nu megbasa gupia diniin mukaꞌ menggulaula tu mauyaꞌanen. ");
INSERT INTO syb_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Puꞌ genat pa dengantu, iin pa pegdedengeg duuni meneguliꞌ dig buta, mibuta sikna mbataꞌen. ");
INSERT INTO syb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Naa saꞌ kanaꞌ genat tu Megbebayaꞌ ki getaw kiin, ndaꞌen sia mpenggulaula.” ");
INSERT INTO syb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","“Apelai, yaꞌa kiin,” simbag nilan. “Genat tu kaikaꞌay mu, mekesesalaꞌa getaw. Dayun yaꞌa bai mekpetuꞌun dinami?” Dayun nilan puaꞌay tu simbaan nilan su miuliꞌan buta. ");
INSERT INTO syb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Mendadi si Isus, benaꞌ midengegen puꞌ ki piuliꞌanen kia, piawaꞌ tu simbaan nu getaw Judea, pinengawen. Benaꞌ mibaanganen, sinaaken diniin, “Mikpetuuda ma dig Bataꞌ nu Kilawan?” ");
INSERT INTO syb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Kaliꞌ sembag su miuliꞌan kia, “Naa saꞌ mesuꞌat, Sir, pesuun mu dinaan saꞌ taꞌ taway dun iin, adun mekpetuudu diniin!” ");
INSERT INTO syb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","“Minitaꞌ mu na,” simbag ni Isus. “Iinig duma mu megabitabit.” ");
INSERT INTO syb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“Sir,” laungen, “mekpetuudu!” Minginlulud dayun di gedapan ni Isus. ");
INSERT INTO syb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Kaliꞌ pektaluꞌ si Isus, “Iini luminusadu dun dinig lumbang, puꞌ adun pekpainen ku ki ngag buta mukaꞌ ki nga getaw mangken puꞌ mekengitaꞌ ilan daw. Mekengitaꞌ dayun sug buta kia, mukaꞌ buta na sug laung nilan dun mekengitaꞌ.” ");
INSERT INTO syb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Dekag midengeg nu nga Pariseo pegindeg dia, sinaak nilan dini Isus, “Taꞌi ketaluꞌ mu dun? Yami, buta bami dema?” ");
INSERT INTO syb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Kaliꞌ sembag si Isus, “Saꞌ upama buta amu tantu, naa ndaꞌi salaꞌ niu. Dagid kagina engkenen niu puꞌ mekengitaꞌ amu, gempantek, mikesalaꞌ amu.” ");
INSERT INTO syb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Kaliꞌ pektaluꞌ si Isus, “Taman taluꞌu diniu, pinenggiꞌ duuni galad melauni karniru dun. Naa, adin su ndiꞌ mian di gengaꞌan saꞌ suled, laak mengkalemikit tug labat, iini megdaaw mukaꞌ tulisan. ");
INSERT INTO syb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Laak dagid adin su mian tu gengaꞌan saꞌ suled, iin su tantu megingat tu karniru. ");
INSERT INTO syb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Iin, saꞌ mateng tu galad, pukaꞌan nu megingat tu gengaꞌan. Saꞌ suled, medengeg dayun nu nga karniru su tingegen. Tuaganen su ngag daniin karniru, piksesalabuuk ingelananen ilan, mukaꞌ egakenen ilan mangay ditug liu. ");
INSERT INTO syb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Benaꞌ megelaꞌen ilan uitay ditug liu, meguna dinilan mpanaw. Dunutan nilan iin gupia, puꞌ mailala nilan su tingegen. ");
INSERT INTO syb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ndiꞌ ilan dumunut tug lain getaw, segaga menggebek ilan, puꞌ ndiꞌ nilan mailalai tingeg nug lain getaw.” ");
INSERT INTO syb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Naa iini sinambingay ni Isus tu nga kaunutan nu getaw Judea, laak ndaꞌ nilan mesabuti guluganen. ");
INSERT INTO syb_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Mendadi, laung dayun ni Isus, “Taman taluꞌu diniu, naani gengaꞌan bianan nu nga karniru saꞌ suled. ");
INSERT INTO syb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Sug launan getaw miuna dinaan, tautau pegwekilan ilan nu Megbebayaꞌ, ilani megdaaw mukaꞌ tulisan, laak ndaꞌ ilan pekineegay nu nga karniru. ");
INSERT INTO syb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Naani gengaꞌan, adin su mian di gengaꞌan kini saꞌ suled, iini megawen. Suled dayun mukaꞌ luyu meksukat meseksaben. ");
INSERT INTO syb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Naa saꞌ pinenggiꞌ su megdaaw, metuaꞌ adun laak megdaaw mukaꞌ mekpatay sampay menggebaꞌ. Iini midiniinu dun puꞌ adun mpeduunan su sumakup dinaan ketubuꞌ ndaꞌi tamanen, su ketubuꞌ ndaꞌ dademai taman nu kelengasen.” ");
INSERT INTO syb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Laung pa ni Isus, “Naani gempia megingat tu nga karniru. Naa, su gempia megingat tu nga karniru, iin su miuyaꞌ gumantiꞌ di kepetayan nilan. ");
INSERT INTO syb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Laak dagid su tinindanan, su kanaꞌ megingat tantu, saꞌ maitaꞌen mesebangi mendapaꞌ tu karniru, gubek, belenganen su nga karniru, puꞌ kanaꞌ maini gapuꞌen. Dumapaꞌ dayun su mendapaꞌ tu karniru mukaꞌ mpelak su ngag duma. ");
INSERT INTO syb_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Gubek su tinindanan, puꞌ tinindanan laak mukaꞌ ndiꞌ melelaat tu nga karniru. ");
INSERT INTO syb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Laak naan su gempia megingat. Suminambatu tug danaan karniru mukaꞌ suminambat ilan dinaan, ");
INSERT INTO syb_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","maaꞌ nu kesambat nu Gamaꞌu dinaan sampay su kesambatu diniin. Miuyaꞌ nau gumantiꞌ dadema di kepatay nu nga karniruu. ");
INSERT INTO syb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Naa duun pai ngag lain karniruu kanaꞌ pa di sekauluan kini. Subay engain ku ilan dema. Mektalenten ilan di tingegu, mbaluy ilan pa pagid sekauluan, sala tawan dai megingat dun. ");
INSERT INTO syb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Iini pegbesaanu dun nu Gamaꞌu, begayu matayig lawasu, puꞌ metubuꞌu puliꞌ. ");
INSERT INTO syb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Pia taꞌ taway dun, ndaꞌi mekegbayaꞌ mekpatay dinaan, subay begayan ku pegbayaꞌen mekpatay dinaan. Mukaꞌ saꞌ begayu, danaan da delendeman. Duuni pegbayaꞌu megbegay dun, mukaꞌ duun dademai pegbayaꞌu metubuꞌu puliꞌ. Iini sinuguꞌan dinaan nu Gamaꞌu.” ");
INSERT INTO syb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Naa sikna midengeg nu nga getaw Judea su tinaluꞌ kia ni Isus, miksumpakiꞌ puliꞌig delendeman nilan. ");
INSERT INTO syb_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Melaun mektaluꞌ, “Pingepuꞌan ma menulay ki getaw kiin! Mibuꞌang! Mauma dema pekineegan niu?” ");
INSERT INTO syb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Laak sug duma, laung nilan, “Saꞌ pinenggiꞌ pingepuꞌan menulay, kanaꞌ maꞌniai teluꞌenen. Ki menulay, mekeneguliꞌ ba dig buta?” ");
INSERT INTO syb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Naa kagina timpu na metegdaw, miktelipuun dia Jerusalem sug lumpuk nu getaw Judea gindan tu Kegugas Balay Pengedapan tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Si Isus, mikpanawpanaw dia Pengedapan, dia silung piningalan dun Silung ni Salomon. ");
INSERT INTO syb_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Mendadi ki nga getaw Judea, miktabuꞌ ilan diniin, kaliꞌ ilan pektaluꞌ, “Taꞌ ma, maiben mu pa pekegelegelayig delendeman nami? Pemantek mu dinami, yaꞌa ba tuꞌu su Tinduꞌ nu Megbebayaꞌ Meglekaunutan?” ");
INSERT INTO syb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Kaliꞌ sembag si Isus, “Mitubusu na taluꞌ diniu, laak ndaꞌ amu metuuday dun. Iini miketakesiꞌ gupia dinaan, su pinggulaulau, su pigwakil dinaan nu Gamaꞌu. ");
INSERT INTO syb_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Laak dagid, ndiꞌ niu petuuden, puꞌ kanaꞌu amu karniru. ");
INSERT INTO syb_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Puꞌ saꞌ su nga karniruu, pektalentenan nilan su tingegu. Suminambat dau dema dinilan, kaas duminunut ilan dinaan. ");
INSERT INTO syb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Begayan ku ilan ketubuꞌ ndaꞌi tamanen, ndiꞌ ilan matay, mukaꞌ ndaꞌ demai mekagaw dun di gengkeman ku. ");
INSERT INTO syb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Su Gamaꞌu migbegay dun dinaan, iin su megbayaꞌ pa dun dig launan. Ndaꞌi mekagaw dun di gengkemanen.” ");
INSERT INTO syb_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Diksuꞌ ni Isus su taluꞌen, “Naa, naan mukaꞌ su Gamaꞌu, iin da.” ");
INSERT INTO syb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Benaꞌ midengeg nu nga getaw Judea, mingimud ilan puliꞌ batu, puꞌ betuun nilan sia si Isus adun matay. ");
INSERT INTO syb_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kaliꞌ pektaluꞌ si Isus, “Naa, melaun gempia pinitaꞌu diniu di pipenggulaula nu Gamaꞌu dinaan. Taꞌ mai betuun niau dun?” ");
INSERT INTO syb_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Kaliꞌ ilan sembag, “Kanaꞌ nu gempia pinggulaula mu. Iinig betuun ka nami dun, puꞌ sudiꞌan mu su Megbebayaꞌ! Puꞌ pilepeng mu sug lawas mu tu Megbebayaꞌ, asa kilawan ka da!” ");
INSERT INTO syb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Laung dayun ni Isus, “Ndaꞌ ba mesulat di Palinta niu puꞌ miktaluꞌ su Megbebayaꞌ, ‘Yamui ngag diwata’? ");
INSERT INTO syb_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Misuunan ta puꞌ su Misulat Taluꞌ nu Megbebayaꞌ, ndaꞌi gikteb nu ketuuden. Mukaꞌ su nga getaw kia dengantu pimuunan nu Megbebayaꞌ, piningalanen dun ngag diwata. ");
INSERT INTO syb_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Saꞌ maꞌantu, ndiꞌ niu mpia teluꞌen puꞌ piksudiꞌan ku su Megbebayaꞌ saꞌ tinaluꞌu puꞌ naanig Bataꞌ nu Megbebayaꞌ, asa pimiliꞌu niin medinig lumbang. ");
INSERT INTO syb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Saꞌ pinenggiꞌ ndiꞌu sia penggulaulaan su pibaal dinaan nu Gamaꞌu, naa megdadi ndiꞌ amu metuudan dun. ");
INSERT INTO syb_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Laak dagid, saꞌ penggulaulaan ku tuꞌui pibaalen dinaan, naa pia ndiꞌ niu duateni taluꞌu, subay petuuden niu su nga penggulaulau. Saꞌ pemaꞌantuun niu, naa subay metuudan amu dun, naan mukaꞌ su Gamaꞌu, iin da tanan.” ");
INSERT INTO syb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Mendadi, pikpulingkasan puliꞌ nu nga getaw Judea daapay si Isus, dagid migliaw dinilan. ");
INSERT INTO syb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Saꞌ maꞌnia, mipuliꞌ si Isus ditug dipag tubig Jordan tandaꞌ pigbunagan ni Juan diniin tubig, migbebenwa pa dia. ");
INSERT INTO syb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Melaun getaw miditu niin, laung nilan, “Si Juan kiin, ndaꞌi mekesalebuꞌ pinggulaulanen. Laak dagid ki kelaun tinaluꞌ ni Juan mekatag di getaw kini, lumbus minuud.” ");
INSERT INTO syb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Melaun dayun getaw dia mituudan dini Isus. ");
INSERT INTO syb_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Naa duuni getaw pegladu, ngalanen si Lazaro. Kini si Lazaro, pegbenwa diag Betania, ilan nu nga pateden si Maria mukaꞌ si Marta. ");
INSERT INTO syb_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Si Maria kini, iin su migbunag kiin pagemut tu geksud nu Kaunutan si Isus mukaꞌ pinunasen dun kig buuken. Su pateden si Lazaro, iin su migladu kia.) ");
INSERT INTO syb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mendadi, pimuun si Isus nug duaꞌ tawan libun kia mekpated, laung nilan, “Sir, pegladu ki petailen mu sambat si Lazaro.” ");
INSERT INTO syb_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Mendadi kini si Isus, benaꞌ midengegen, kaliꞌ pektaluꞌ, “Naa, ki kegladu kini ni Lazaro, kanaꞌ iinig deksuꞌanen su petayanen. Iini migladu dun, puꞌ adun megleepig dengegan nu Megbebayaꞌ, mukaꞌ adun megleep dadema kig dengegan nug Bataꞌ nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Naa si Isus, milelaat gupia dini Marta mukaꞌ su pateden kia libun sampay si Lazaro. ");
INSERT INTO syb_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Laak pia maꞌantu, benaꞌ misuunanen puꞌ migladu si Lazaro, milangan pa duaꞌ gebii. ");
INSERT INTO syb_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Benaꞌ mitektakig duaꞌ gebii, laung ni Isus tu nga sakupen, “Mpuliꞌ ita ditu Judea.” ");
INSERT INTO syb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","“Aba, Sir,” simbag nu nga sakupen. “Mpuliꞌa na pelum ditu, asa begua da betuay sia nu nga getaw Judea dia?” ");
INSERT INTO syb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Kaliꞌ sembag si Isus, “Naa su gendaw, kanaꞌ ba sepuluꞌ buꞌ duaꞌ uras? Naa saꞌ mpanawi getaw metaang di gendaw, ndiꞌ medapal, puꞌ maitaꞌen su mekpedelag dig lumbang. ");
INSERT INTO syb_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Laak saꞌ dagid mengelem, naa medapal, puꞌ ndaꞌi mekpedelag diniin.” ");
INSERT INTO syb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Saꞌ mideksuꞌen teluꞌay kia, miktaluꞌ padun si Isus, “Naa su sambat ta si Lazaro, tinulug na. Dagid meditu dau niin, adun tenuden ku.” ");
INSERT INTO syb_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Kaliꞌ sembag su nga sakupen, “Sir, saꞌ tinulug da, mauliꞌan da.” ");
INSERT INTO syb_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Naa ki tinaluꞌ ni Isus kia, pingmaꞌananen dun, minatay si Lazaro. Laak laung dun nu nga sakupen, tulug laaki teluꞌenen. ");
INSERT INTO syb_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Saꞌ maꞌnia, pinluksad ni Isus dinilan, laungen, “Minatay na si Lazaro. ");
INSERT INTO syb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Laak dagid sabaꞌ diniu,” maaꞌ laung pa ni Isus, “liliagu dun puꞌ ndaꞌu ditu, puꞌ adun sumalig amu dinaan. Naa laawan taitu.” ");
INSERT INTO syb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Mendadi sala tawan dinilan si Tomas (piningalan dun su Gapid), laungen tu nga samasakupen kia, “Naa megdunut daita dema di Mekpetuꞌun dinita, adun saꞌ petain, meksaliunung daita diniin!” ");
INSERT INTO syb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Naa benaꞌ minateng si Isus diag Betania, pisuun diniin puꞌ paat gebii na dig lupaꞌ si Lazaro. ");
INSERT INTO syb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Naa kig lunsud Betania kia, duun saani telu kilumitru laakig layuꞌen tu Jerusalem. ");
INSERT INTO syb_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Saꞌ maꞌnia, melaun getaw Judea miditu ni nga Marta mukaꞌ si Maria, adun megbelangbelang ilan di ginaa nilan mekatag di kepatay nu pated nilan kia. ");
INSERT INTO syb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Naa si Marta, benaꞌ midengegen puꞌ pegdateng si Isus, inangayen sungkakay, laak si Maria, mibilin diag balay nilan. ");
INSERT INTO syb_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mendadi kini si Marta, kaliꞌ pektaluꞌ dini Isus, “Sir, saꞌ sia diniin ka, ndiꞌ sia matay su patedu! ");
INSERT INTO syb_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Dagid pia maꞌantu, suunan ku puꞌ adini penengiin mu tu Megbebayaꞌ, begayen diniꞌa.” ");
INSERT INTO syb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","“Metubuꞌ puliꞌ ki pated mu kiin,” laung ni Isus. ");
INSERT INTO syb_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","“Naa suunan ku,” simbag ni Marta, “petubuꞌen puliꞌ nu Megbebayaꞌ su nga getaw di gendaw kiin saꞌ sungu na melengkebig benwa, kaas metubuꞌ daan puliꞌ si Lazaro.” ");
INSERT INTO syb_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Kaliꞌ pektaluꞌ si Isus diniin, “Naani mekpetubuꞌ puliꞌ tu nga getaw, mukaꞌ naan dademai puun nu ketubuꞌ nu getaw. Adin su getaw metuudan dinaan, pia matay, metubuꞌ puliꞌ. ");
INSERT INTO syb_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Mukaꞌ adin su metubuꞌ mukaꞌ sumalig dinaan, ndiꞌ na matay iin. Metuudan ka dun?” ");
INSERT INTO syb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Waꞌa, Sir!” simbag ni Marta. “Mituudanu dun puꞌ yaꞌa na tuꞌu su Tinduꞌ nu Megbebayaꞌ Meglekaunutan, sug Bataꞌ nu Megbebayaꞌ, su pidateng nami lumusad dinig lumbang.” ");
INSERT INTO syb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Benaꞌ mideksuꞌ mektaluꞌ si Marta, minangay meksabi tu pateden kia si Maria. Kimeden dun dayun, laungen, “Diin na su Mekpetuꞌun, sinabia niin.” ");
INSERT INTO syb_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Kaliꞌ medengeg ni Maria, migdedaliꞌ megbuat, miditu dayun sumungkak dini Isus. ");
INSERT INTO syb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Puꞌ ndaꞌ pa dateng diag lunsud si Isus, ditu pa tandaꞌ nu pekitaꞌan nilan ni Marta.) ");
INSERT INTO syb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Naa su nga getaw Judea kia megbelangbelang dini Maria diag dialem balay, benaꞌ minitaꞌ nilan si Maria migdedaliꞌ megbuat mukaꞌ luyu, lindug nilan, puꞌ laung nilan dun meditug lebeng lumalek. ");
INSERT INTO syb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Naa si Maria, benaꞌ minateng dia ni Isus, miglaub di gedapanen. “Uu Kaunutan,” laungen, “saꞌ sia diniin ka, ndiꞌ sia matay su patedu!” ");
INSERT INTO syb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mendadi si Isus, saꞌ minitaꞌen si Maria luminalek sampay su ngag dumanen getaw Judea luminalek dailan dema, misasawi ginaanen, milegenan patiꞌ. ");
INSERT INTO syb_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Adin niu libeng?” sinaaken. Kaliꞌ ilan sembag, “Naa Sir, unutan ka nami ditu, adun maitaꞌ mu.” ");
INSERT INTO syb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Mikengaduy si Isus. ");
INSERT INTO syb_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Laung nu nga getaw dia, “Pegbentayay pa daan niu, mikpetail gupia dini Lazaro.” ");
INSERT INTO syb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Laak sug duma, laung nilan, “Naa, pipengitaꞌ nu getaw kini sug buta. Mauma ndaꞌen ma metabangi gumul ni Lazaro?” ");
INSERT INTO syb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Benaꞌ minateng si Isus tug lebeng ni Lazaro, mipatiꞌ puliꞌ mesasawi ginaanen. Naa kig lebeng kia, sinangyab, tinakep gembagel batu. ");
INSERT INTO syb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Laung dayun ni Isus, “Pegawaꞌ niuig batu kia!” “Dagid Sir,” laung ni Marta, su pated nu minatay kia, “paat gebii na dig lupaꞌ! Meduꞌ na.” ");
INSERT INTO syb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Kaliꞌ sembag si Isus, “Naa, ndaꞌ bau pektaluꞌ diniꞌa puꞌ saꞌ sumaliga dinaan, maitaꞌ mu ki kelengas nu pegbayaꞌ nu Megbebayaꞌ?” ");
INSERT INTO syb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Inawaꞌ nilan dayun su gembagel batu. Migangag dayun si Isus, kaliꞌ pektaluꞌ, “Uu Amaꞌ, mikpaladpaladu diniꞌa, puꞌ mipenembaꞌ mui kenengiu. ");
INSERT INTO syb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Misuunan ku gebii gendaw pekineegan mau, laak iini mipedengegu dun ki kenengiu diniꞌa kini, sabaꞌ nu nga getaw kini, puꞌ adun metuudan ilan dun puꞌ sinuguꞌ mau lumusad dinig lumbang.” ");
INSERT INTO syb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mideksuꞌ menenabi si Isus, minekeg dayun meksabi, laungen, “Uu Lazaro, guaꞌa na dini!” ");
INSERT INTO syb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Gumiwaꞌ dayun si Lazaro. Laak linibedan pa penepeten sampay su kemeten mukaꞌ geksuden, pinutus dema tulapuki gulunen. “Ubaday niu,” laung ni Isus, “adun mekepanaw.” ");
INSERT INTO syb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Naa melaun getaw tumindug dini Maria, mituudan ilan dini Isus saꞌ minitaꞌ nilan su pinggulaulanen kia. ");
INSERT INTO syb_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Laak sug duma, miditu ilan nga Pariseo, pisuun nilan dayun dun ki pinggulaula kia ni Isus. ");
INSERT INTO syb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mendadi ki nga Pariseo kini mukaꞌ ki nga kaunutan nug belian nu getaw Judea, mikpungun ilan dayun, ilan nu Pikumpungan nu Metaas Gukum nilan. Kaliꞌ ilan pektaluꞌ, “Naa, alanduni melengas baalen ta? Melaun mekesalebuꞌ pinggulaula nu getaw kiin! ");
INSERT INTO syb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Saꞌ ndiꞌ ta pemaagen, megelaꞌ sumakup diniin su nga getaw. Mbuus medengeg nu gubirnu ditug Roma, suguꞌen nilan dayuni nga sundalu medini, peglaatan nilan dayuni gelal ta kaunutan, puꞌ gebaꞌen nilan su Pengedapan ta tu Megbebayaꞌ mukaꞌ leneden nilani nasud ta!” ");
INSERT INTO syb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Mendadi sala tawan dinilan si Caifas, iini mitenduꞌ Tampusan Metaas Belian di taun kia, kaliꞌ pektaluꞌ, “Paa, benguꞌbenguꞌen amu! ");
INSERT INTO syb_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ndaꞌ niu ba mesuunay puꞌ melengas pa pegantiꞌ ta ki sala tawan di kepatay nug launan getaw batul nu megelaꞌ matay su tibuuk bansa ta?” ");
INSERT INTO syb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Naa kagina iini Tampusan Metaas Belian, ki tinaluꞌ kini ni Caifas, kanaꞌ daniin delendeman. Pidelendem diniin nu Megbebayaꞌ puꞌ gumantiꞌ di nga getaw Judea si Isus. ");
INSERT INTO syb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Mukaꞌ kanaꞌ laak su kepatay nu nga getaw Judea ki gentiꞌenen, puꞌ pesalabuukenen pa pagid su kelaun piglegetawan nu Megbebayaꞌ misigwag dig dibabaw lumbang. ");
INSERT INTO syb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Mendadi genat tu gendaw kia, ki nga kaunutan kini nu getaw Judea, minengaw ilan suꞌatan nilan di kepatay nilan dini Isus. ");
INSERT INTO syb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Saꞌ maꞌnia, ndaꞌ pekpaitaꞌ si Isus mekpanawpanaw dia Judea. Miditug lunsud Efraim tu geksid limawaꞌ, migbebenwa dia, ilan nu nga sakupen. ");
INSERT INTO syb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Naa saꞌ sungu na mektelipuun sug Lumpuk tug Liniusan, melaun getaw tumiwad ditu Jerusalem genat dig lumibut benwa, minangay ilan mekanu adun mawaꞌ su kelemuꞌay nilan. ");
INSERT INTO syb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Naa pekpenengaun nu nga getaw dia Jerusalem si Isus. Saꞌ mikpungun ilan ditug Balay Pengedapan tu Megbebayaꞌ, miksinaakay ilan, laung nilan, “Naa, taꞌi ketaluꞌ niu dun? Si Isus, mabuꞌ ndiꞌ sumaup dig Lumpuk kini?” ");
INSERT INTO syb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Puꞌ su nga kaunutan nug belian mukaꞌ nga Pariseo kia, pilaktag nilan tu nga getaw, saꞌ duuni mekesuun dun saꞌ adin si Isus, subay pesuunen dinilan, adun daapen nilan iin. ");
INSERT INTO syb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Naa saꞌ genem gebii pa mektelipuun sug Lumpuk tug Liniusan, miditug Betania si Isus, sug lunsud ni Lazaro, su pitubuꞌ puliꞌ kiin ni Isus. ");
INSERT INTO syb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Benaꞌ minateng dia si Isus, pigbesaan nu nga getaw dia di gaan. Iini migilak dun si Marta, dumingan dini nga Isus maan si Lazaro. ");
INSERT INTO syb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mendadi benaꞌ pekaan nailan, si Maria, minalap sala butilya melagaꞌ pagemut piningalan dun nardo, binunagen dayun di geksud ni Isus mukaꞌ pinunasen dun sug buuken. Mileep dayun tu seled balay su sapu nu pagemut. ");
INSERT INTO syb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Naa sala tawan sakup ni Isus, si Judas Iscariote, su tumipu pa dini Isus, kaliꞌ pektaluꞌ, ");
INSERT INTO syb_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Baa, mauma dema ki pagemut kiin, ndaꞌ ma peksaluy, mabuꞌ malin sia telu gatus denario, adun begay tu nga pubri su galinen?” ");
INSERT INTO syb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Laak kanaꞌ iini tinaluꞌ dun ni Judas puꞌ melelaat tu nga pubri. Tinaluꞌen duni maꞌnia, puꞌ megdaaw. Kagina iini meguit tu kwarta ni nga Isus, taang dun malap dun. ");
INSERT INTO syb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Dagid miktaluꞌ si Isus, “Aba, maꞌnia da! Melengas teguꞌenen, pengandamen di gendaw nu kelebeng dinaan. ");
INSERT INTO syb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Su pubri, lelayun niu mpungun megbenwa. Naan dagid, kanaꞌ nau maiben dumuma diniu dini.” ");
INSERT INTO syb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Naa su nga getaw miglumpuk dia Jerusalem, benaꞌ midengeg nilan puꞌ minateng na si Isus ditug lunsud Betania, miditu dailan dema, melaun ilan gupia. Mauyaꞌan nilan kitaꞌen nilan pa pagid si Lazaro, su pitubuꞌ puliꞌ ni Isus. ");
INSERT INTO syb_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Mendadi sug delendeman nu nga kaunutan nug belian, petain da nilan dema si Lazaro, ");
INSERT INTO syb_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","puꞌ iini puunanen, melaun getaw Judea sumiway dinilan, suminakup ilan dini Isus. ");
INSERT INTO syb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Naa benaꞌ migendaw, su nga melaun getaw kia suminaup tug Lumpuk, midengeg nilan pegdateng si Isus dia Jerusalem. ");
INSERT INTO syb_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Mendadi mingalap su nga getaw paka pisa pegbaasbaas nilan basa nilan dini Isus, dayun lumiu ilan diag lunsud, sungkaken nilan si Isus. Mimeksay ilan, laung nilan, “Pegbesaan kini! Melengas pepianan iin nu Megbebayaꞌ, ki minateng na pigwekilan nu Kaunutan Megbebayaꞌ, ki Gadiꞌ nu getaw Israel!” ");
INSERT INTO syb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Mendadi kini si Isus, duuni minitaꞌen petubuꞌen nati asno. Sikayanen dayun, maaꞌ dadema nu sinulat pedaan ditu Misulat Taluꞌ nu Megbebayaꞌ, laung, ");
INSERT INTO syb_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Yamu nga getaw Sion, ndiꞌ amu mendek! Puꞌ bentayay pa daan niu, pegdateng na su gadiꞌ niu, peksakay di nati asno.” ");
INSERT INTO syb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Naa su nga sakup ni Isus, ndaꞌ nilan mesabut di gendaw kia saꞌ taꞌ mai suminakay dun si Isus. Laak benaꞌ midayag na su kelengas nu pegbayaꞌ ni Isus, milabuꞌ dayun dig delendeman nilan su sinulat kia ditu Misulat Taluꞌ nu Megbebayaꞌ, dakus su kenggulaula nilan dun diniin di gendaw kia. ");
INSERT INTO syb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Naa su nga melaun getaw tumindug dini Isus su kesabinen dini Lazaro ditug dialem sangyab dayunen petubuꞌay puliꞌ, inukitan nilan dun su nga getaw pegbebenwa dia Jerusalem. ");
INSERT INTO syb_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Iini minangay dun sumungkak dini Isus su nga getaw, puꞌ midengeg nilan ki mekesalebuꞌ pinggulaulanen kia. ");
INSERT INTO syb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mendadi ki nga Pariseo, kaliꞌ nilan pegyegayegaay, “Naa, bentayay pa daan niu, daagen ita! Minampuꞌ na diniin su tibaꞌan getaw!” ");
INSERT INTO syb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Naa duuni nga getaw Grecia minampuꞌ di nga getaw Judea mangay dia Jerusalem mengamuyuꞌ tu Megbebayaꞌ metaang dig Lumpuk kia. ");
INSERT INTO syb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Mendadi ilan kini, luminabet ilan dini Felipe, (si Felipe, getaw Betsaida sakup Galilea). Kaliꞌ ilan pektaluꞌ diniin, “Sir, kumitaꞌ ami sia dini Isus.” ");
INSERT INTO syb_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Saꞌ maꞌnia, linaawan ni Andres si Felipe, pisuunen diniin su kenengi nu getaw Grecia, dayun ilan duaꞌ mangay mekpesuun dini Isus. ");
INSERT INTO syb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Mendadi benaꞌ midengeg ni Isus, kaliꞌ pektaluꞌ, “Naa, mitektak na su sesaꞌ. Naan kini, kig Bataꞌ nu Kilawan, begay na dinaan nu Megbebayaꞌ su kelengas nu pegbayaꞌu. ");
INSERT INTO syb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Taman taluꞌu diniu, pinenggiꞌ su sebalu trigo, saꞌ ndiꞌ metenaꞌ tug lupaꞌ mukaꞌ lebengen, ndaꞌi pulesen. Laak saꞌ metenaꞌ tug lupaꞌ mukaꞌ lebengen, iini sungkuꞌ gupia. ");
INSERT INTO syb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Naa adini mpauk megwakil gumulen dinaan, mbeleng diniin su ketubuꞌ ndaꞌi tamanen. Adin su pegwakilen dinaan su gumulen, iin, malapen sungkin su ketubuꞌ ndaꞌi tamanen. ");
INSERT INTO syb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mendadi saꞌ duuni getaw mauyaꞌanen megabang dinaan, iin, subay dumunut dinaan. Pia tandaꞌu, ditu dadema iin. Saꞌ megabang dinaan, iin demai pegbesaan nu Gamaꞌu.” ");
INSERT INTO syb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Kaliꞌ pektaluꞌ si Isus, “Milegenanu ini. Ndiꞌu mesuunani gempia penenebiin ku. Penenebiin ku taꞌ, ‘Uu Amaꞌ, gawen mau di kelegenayu’? Ndiꞌ mesuꞌat, puꞌ iini luminusadu dun dinig lumbang, adun melegenanu.” ");
INSERT INTO syb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Minenabi dayun si Isus, laungen, “Uu Amaꞌ, pegleep mu sug dengegan mu!” Duun dayuni miktaluꞌ ditug langit, laungen, “Pigleepu na sug dengegan ku mukaꞌ pegleepen ku pa puliꞌ.” ");
INSERT INTO syb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Benaꞌ midengeg nu melaun getaw pegindeg dia, laung dun nug duma, limuduꞌan. Laung dun pagid nug duma, “Mabuꞌ duuni sesuguꞌen nu Megbebayaꞌ getaw langit migabitabit diniin!” ");
INSERT INTO syb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Dagid kaliꞌ pektaluꞌ si Isus, “Kanaꞌ naani pidengegan dun ki tingeg kiin, pidengeg diniu. ");
INSERT INTO syb_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Puꞌ minateng nai gendaw tinduꞌ nu Megbebayaꞌ, ukumanen su tibaꞌan getaw. Nemun su meglekaunutan di tibaꞌan getaw, su Palin, daagen iin. ");
INSERT INTO syb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Naan, saꞌ mainatu adun melansangu dia, empunen ku sug launan getaw megelaꞌ mekesakup dinaan.” ");
INSERT INTO syb_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Iini miktaluꞌ dun si Isus, puꞌ adun mesuunan nu nga getaw kig bian nu kepatayen.) ");
INSERT INTO syb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Kaliꞌ sembag su melaun getaw, “Naa iini mipesuun dinami nu Palinta dinami kanugdiin, puꞌ su Tinduꞌ nu Megbebayaꞌ Meglekaunutan, ndaꞌi gumulen. Naa saꞌ maꞌantu, saꞌ iinig laung mu Bataꞌ nu Kilawan, mauma tinaluꞌ mu mainat iin adun melansang dia? Taꞌ taway duni Bataꞌ nu Kilawan kiin?” ");
INSERT INTO syb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Kaliꞌ sembag si Isus, “Taman taluꞌu diniu, ki Tiag kini, ndiꞌ na maiben di mata niu, kaas sinegay dini pa su Tiag, bundas amu panaw, adun ndiꞌ amu medepetan nu medelem. Adin su mpanaw di medelem, ndiꞌen mesuunani gengayanen. ");
INSERT INTO syb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Selian diin pa mata niu, subay metuudan amu tu Tiag, adun mbaal amu sakup nu Tiag.” Mendadi sikna mideksuꞌ mektaluꞌ si Isus, bilenganen su nga getaw kia, pigliawen ilan dayun. ");
INSERT INTO syb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Puꞌ pia melaun mekesalebuꞌ pinggulaulanen dia gedapan nilan, ndaꞌ ilan metuuday dun diniin. ");
INSERT INTO syb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Maꞌnia, minuud su sinulat dengantu nu pimuunan nu Megbebayaꞌ si Isaias, laungen, “Uu Kaunutan, taꞌ taway duni mituudan dun su ginukit nami dinilan? Ndaꞌidun. Mukaꞌ taꞌ taway duni pinitaꞌan di pegbayaꞌ nu Kaunutan? Ndaꞌidun.” ");
INSERT INTO syb_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Saꞌ maꞌnia, su nga mikaitaꞌ tu mekesalebuꞌ pinggulaula ni Isus, ndaꞌ ilan metuuday dun. Puꞌ duun pagidi sala sinulat ni Isaias, laungen, ");
INSERT INTO syb_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Lininged nu Megbebayaꞌ su nga mata nilan, adun ndiꞌ nilan maitaꞌ. Pitegasen su nga gulu nilan adun ndiꞌ nilan mesabut, puꞌ tekaw mbuus lumingay dailan puliꞌ dinaan, laung nu Megbebayaꞌ, adun peneguliꞌan ku ilan.” ");
INSERT INTO syb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Iini miktaluꞌ dun si Isaias maꞌnia, puꞌ minitaꞌen su kelengas nu pegbayaꞌ ni Isus, dayun inukiten. ");
INSERT INTO syb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pia maꞌantu, melauni kaunutan nu getaw Judea mituudan dini Isus, laak pigbuni nilan. Ndaꞌ nilan pekpailag, puꞌ mindek ilan mbuus utidan ilan nu nga Pariseo di simbaan nu getaw Judea. ");
INSERT INTO syb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Iini mauyaꞌan nilan, pegbesaan ilan nu nga getaw, sabayaꞌ nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Naa mendadi, minekeg mektaluꞌ si Isus, laungen, “Adin su metuudan dinaan, kanaꞌ naan laak su pituuden, puꞌ pituuden dadema su suminuguꞌ dinaan. ");
INSERT INTO syb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Mukaꞌ adin su getaw mekaitaꞌ dinaan, maitaꞌen dadema su suminuguꞌ dinaan. ");
INSERT INTO syb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Naani Tiag, midiniinu lumbang adun pedelagan ku sug delendeman nu nga getaw. Adin su getaw metuudan dinaan, ndiꞌ metenlen di medelem. ");
INSERT INTO syb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mukaꞌ, adin su mekedengeg tu taluꞌu, asa ndiꞌen pektalentenan, kanaꞌu mukum dun. Puꞌ kanaꞌ iini midiniinu dun puꞌ adun mengukum tu nga getaw, segaga iin sungkini midiniinu dun, guunen ku su nga getaw. ");
INSERT INTO syb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Adin su memilas dinaan mukaꞌ memilas dadema tu taluꞌu, duuni mengukum dun. Su tinaluꞌu, iini mengukum dun saꞌ sungu melengkebig benwa. ");
INSERT INTO syb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Di menepet metuud lai daan, kanaꞌ mikpuun tu pegbayaꞌu su tinaluꞌu, iini tinaluꞌu tu nga getaw, su laak sinuguꞌan dinaan nu Gamaꞌ ta. ");
INSERT INTO syb_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Suunan ku su sinuguꞌanen, iini megbegay ketubuꞌ ndaꞌi tamanen, kaas iini tinaluꞌu, su sinuguꞌan dinaan nu Gamaꞌ ta.” ");
INSERT INTO syb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Naa, sendaw pa mektelipuun sug Lumpuk tug Liniusan. Mendadi kini si Isus, misuunanen puꞌ minateng na ki kegawaꞌen dinig lumbang, adun muliꞌ ditu Gamaꞌen. Kagina melelaat gupia tu nga piglegetawanen dinig lumbang, mauyaꞌanen paitaꞌen dinilan su gikteb lelaaten dinilan. ");
INSERT INTO syb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Mendadi, miglebungan si nga Isus. Naa kini si Judas Iscariote, bataꞌ ni Simon, daan na pinulayan nu Palin tumipu dini Isus. ");
INSERT INTO syb_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Si Isus, misuunanen puꞌ migelaꞌ pegwakil diniin nu Gamaꞌen su pegbayaꞌ dig launanen. Misuunanen dadema puꞌ pigenatanen su Megbebayaꞌ, mukaꞌ su Megbebayaꞌ dademai uliꞌanen. ");
INSERT INTO syb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mendadi migbuat si Isus dia pengaanan, liwasen su suuben mukaꞌ linibedanen tualyai gawaken. ");
INSERT INTO syb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tinukakanen dayun tubigi palenggana, mikpuun dayun mengugas di geksud nu nga sakupen, pimunasanen dayun tualya kia linibed di gawaken. ");
INSERT INTO syb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Laak benaꞌ midepet dini Simon Pedro, laung ni Pedro, “Aba, Sir, masiꞌ yaꞌa mai mengugas di geksudu?” ");
INSERT INTO syb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Kaliꞌ sembag si Isus, “Ndaꞌ mu pa mesabut nandaw ki pinggulaulaan ku kini diniꞌa. Laak mesuunan mu da saꞌ maiben.” ");
INSERT INTO syb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Laung ni Pedro, “Sampay saumulu, ndiꞌu lai begay ugasan mui geksudu!” “Saꞌ ndiꞌ mu paugasi geksud mu dinaan, kanaꞌa na sakupu,” simbag ni Isus. ");
INSERT INTO syb_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Kaliꞌ sembag si Simon Pedro, “Saꞌ maꞌantu, Sir, kanaꞌ laak nu geksudui ugasan mu! Sampay kemetu mukaꞌ guluu pa pagid!” ");
INSERT INTO syb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Miksembag pelum si Isus, “Naa kanaꞌ. Adin su mikeliguꞌ na, miugasan nai tibuuk lawasen, ndiꞌ na kambat meliguꞌ puliꞌ. Subay ugasan laaki geksuden dig lepup lupaꞌ. Naa, yamu dema, miugasan namu, laak ndaꞌ amu megelaꞌ.” ");
INSERT INTO syb_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Kaas tinaluꞌ dun ni Isusi maꞌnia puꞌ ndaꞌ ilan megelaꞌ maugasay, puꞌ misuunanen saꞌ taꞌ taway dun dinilani tumipu diniin.) ");
INSERT INTO syb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Benaꞌ mitubusen ugasay su geksud nilan, si Isus, siluken puliꞌi suuben mukaꞌ mipuliꞌ diag lemisaan. Kaliꞌ pektaluꞌ dinilan, “Naa mesabut ma niui pinggulaulau diniu kini? ");
INSERT INTO syb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Gilal niau Mekpetuꞌun mukaꞌ Kaunutan. Paladpalad saꞌ maꞌnia, puꞌ naan, tantu mikpetuꞌunu diniu mukaꞌ miglekaunutanu diniu. ");
INSERT INTO syb_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Naa, saꞌ naani mikpetuꞌun diniu mukaꞌ miglekaunutan diniu, dayun naani mingugas di geksud niu, subay peginugasay amu geksud niu. ");
INSERT INTO syb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ki pinggulaulau kini, binaalu lendasan, adun penunggilingan niu, kaas pekpepianay amu. ");
INSERT INTO syb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Taman taluꞌu diniu, su sesuguꞌen, kanaꞌ metaas pa di suminuguꞌ diniin, mukaꞌ su pegwekilan, kanaꞌ metaas pa di migwakil dun. ");
INSERT INTO syb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Maꞌantu, saꞌ mesabut niu ini, leliagen amu dun saꞌ penggulaulaan niu!” ");
INSERT INTO syb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Diksuꞌ ni Isus, “Laak dagid ki tinaluꞌu kini, kanaꞌ mekatag diniu gelaꞌ. Misuunan kuig delendeman nu nga pimiliꞌu sumakup dinaan, laak dagid iini mpenggulaula, adun menuud su sinulat ditu Misulat Taluꞌ nu Megbebayaꞌ, laung, ‘Ki suminalu gupia dinaan maan, iin dademai tuminipu dinaan.’ ");
INSERT INTO syb_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Naa, iini teluꞌen ku diniu nandaw, su ndaꞌ pa mpenggulaula, adun saꞌ mpenggulaula na, metuudan amu dun naan su pekteluꞌen ku. ");
INSERT INTO syb_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Taman taluꞌu diniu, adin su menembaꞌ tu suguꞌen ku, naa gitunganen, naani mipenembaꞌen. Pidag pa tanan, kagina pinembaꞌu niin, mipenembaꞌen dadema su suminuguꞌ dinaan.” ");
INSERT INTO syb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Benaꞌ mideksuꞌi tinaluꞌen kia, milayuꞌ dayuni ginaa ni Isus. Pinluksaden dayun teluꞌay di nga peneliganen kia, “Taman taluꞌu diniu, ki sala tawan diniu, mektipu dinaan.” ");
INSERT INTO syb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Miksesindapay dayun su nga sakupen, puꞌ misebuꞌan ilan dun gupia saꞌ taꞌ taway duni mitenduꞌanen tu taluꞌen kiin. ");
INSERT INTO syb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Naa sala tawan di nga sakup ni Isus, su petailenen gupia, pegingkud dia gupid ni Isus. ");
INSERT INTO syb_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Mendadi kinipayan dayun iin ni Pedro, laungen, “Saak mu lai diniin saꞌ taꞌ taway duni pekteluꞌenen kia.” ");
INSERT INTO syb_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Minigini sakupen kia dia mesempel ni Isus, sinaaken dayun diniin, “Sir, taꞌ taway dun iin?” ");
INSERT INTO syb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Kaliꞌ sembag si Isus, “Naa, duliten ku di sabawi pan kini. Adin su tulunan ku dun, iin nain.” Benaꞌ dinuliten tuꞌu, tinulunen dayun dini Judas, sug bataꞌ ni Simon Iscariote. ");
INSERT INTO syb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kini si Judas, benaꞌ mitabuken su pan, pingepuꞌan dayun ni Satanas. Laung ni Isus diniin, “Naa kig baalen mu, baal mu na dayun!” ");
INSERT INTO syb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Naa su ngag duma sakup ni Isus dia pengaanan kia, ndaꞌidun dinilani mekesabut dun saꞌ taꞌ alanduni tinaluꞌ dun kia ni Isus dini Judas. ");
INSERT INTO syb_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Laung dun nu ngag duma, kagina si Judasi meguit tug bataꞌ kahun betangan nu kwarta nilan, sinuguꞌ ni Isus diniin mangay menaluy gimpan dig Lebungan nilan gindan ditug Liniusan. Laung dun nug duma, suguꞌen ni Isus pemegayanen su nga pubri. ");
INSERT INTO syb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Benaꞌ inaanen su pan kia, tumikaw dayun guaꞌ si Judas. Gebii kia dema. ");
INSERT INTO syb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Benaꞌ gumiwaꞌ dia si Judas, kaliꞌ pektaluꞌ si Isus, “Naa naan kini, kig Bataꞌ nu Kilawan, mbuasan nai kelengas nu pegbayaꞌu. Buasan ku dadema su kelengas nu pegbayaꞌ nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Saꞌ mbuasan na su kelengas nu pegbayaꞌ nu Megbebayaꞌ pebian dinaan, su kelengas nu pegbayaꞌu, buasan ganam nu Megbebayaꞌ meksekat di keksalabuuku diniin, naan kini, kig Bataꞌ nu Kilawan. ");
INSERT INTO syb_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yamu nu nga binataꞌu, kanaꞌ nau maiben dumuma diniu dini. Penengaun niau dayun, laak puliꞌan ku taluꞌ diniu su tinaluꞌu tu nga kaunutan nu getaw Judea puꞌ ndiꞌ amu mekeditu pegengayan ku. ");
INSERT INTO syb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Laak pengumbilin ku diniu kig begu palinta, pekpinetailay amu gupia. Pekpinetailay amu maaꞌ nu kepetailu diniu. ");
INSERT INTO syb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Iin dayuni kesuun dun nu nga getaw puꞌ yamui sakupu, saꞌ mekpinetailay amu.” ");
INSERT INTO syb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Sinaak ni Simon Pedro dini Isus, “Sir, adin ka ma angay?” Kaliꞌ sembag si Isus, “Ndiꞌa pa mekedunut dinaan nandaw ditu pegengayan ku. Dagid duuni gendaw, mekeglenduga daan tuꞌu.” ");
INSERT INTO syb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","“Laak Sir,” sinaak ni Pedro, “mauma dema ndiꞌ pau mekedunut diniꞌa nandaw? Minuyaꞌ nau meksaliunung diniꞌa!” ");
INSERT INTO syb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","“Taꞌ ma, Pedro,” simbag ni Isus, “meksaliununga tantu dinaan? Taman taluꞌu diniꞌa, dekag pasiꞌ peguni su manuk, metelu deksuꞌa na memalaw puꞌ kanaꞌ mau mailala.” ");
INSERT INTO syb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Kaliꞌ gusay pektaluꞌ si Isus, “Naa yamu, ndiꞌ amu melibuleng. Salig amu tu Megbebayaꞌ, salig damu dema dinaan. ");
INSERT INTO syb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Sug balay nu Gamaꞌu, melauni suguden. Megunau ditu, endamen ku su nga pegbenwanan niu. Saꞌ kanaꞌ metuud, ndiꞌu na sia ukit diniu. ");
INSERT INTO syb_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Saꞌ ditu nau, mandamu dayun su ngag daniu, mpuliꞌu dini engain ku amu, adun pia tandaꞌu, ditu damu dema. ");
INSERT INTO syb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mukaꞌ mesuunan niuig bianan pangay ditu pegengayan ku.” ");
INSERT INTO syb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Naa sala tawan dinilan si Tomas, kaliꞌ pektaluꞌ, “Sir, ndaꞌ nami suunay su pegengayan mu. Kendutaꞌ mai kesuun nami dun sug bianan?” ");
INSERT INTO syb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Kaliꞌ sembag si Isus, “Naa, naan laig bianan megbuas tu metuud mekatag di Megbebayaꞌ, mukaꞌ naani megbegay tu nga getaw ketubuꞌ ndaꞌi tamanen. Ndaꞌi getaw mekangay ditu Gamaꞌ ta, subay mekebian dinaan. ");
INSERT INTO syb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kagina suminambat amu dinaan, suminambat damu dema tu Gamaꞌu. Genat nandaw sumambat amu gupia diniin, mukaꞌ minitaꞌ na niu su Gamaꞌu.” ");
INSERT INTO syb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Naa sala tawan dinilan pelum si Felipe, kaliꞌ pektaluꞌ, “Sir, saꞌ mesuꞌat, paitaꞌ mu dinami su Gamaꞌ mu, iini sukal dinami.” ");
INSERT INTO syb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Kaliꞌ sembag si Isus, “Kitui kaibenen duminumau diniu, Felipe, laak ndaꞌ mau pa gusay tantu mailala? Adin su mikaitaꞌ dinaan, mikaitaꞌ dadema tu Gamaꞌu. Taꞌ mai teluꞌan mau dun paitaꞌu diniu su Gamaꞌu? ");
INSERT INTO syb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Masiꞌ, Felipe, ndaꞌa pa metuuday dun puꞌ naan mukaꞌ su Gamaꞌu, iin da tanan? Su pekteluꞌen ku diniu, kanaꞌ laak delendeman ku, su Gamaꞌu sumalabuuk dinaan, iini mikpepenggulaula dun dinaan. ");
INSERT INTO syb_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Subay metuudan amu dun ki tinaluꞌu puꞌ salabuuk ami nu Gamaꞌu di ginaa. Laak saꞌ ndiꞌ amu metuudan dun, subay metuudan amu sabaꞌ nu pinggulaulau. ");
INSERT INTO syb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Taman taluꞌu diniu, adin su suminalig dinaan, penunggilinganen su pinggulaulau, mukaꞌ mekesalebuꞌ pai penggulaulaanen, puꞌ muliꞌu tu Gamaꞌu. ");
INSERT INTO syb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Pia alanduni penenebiin niu, saꞌ sumalabuuk amu dinaan, naa penggulaulaan ku, adun megleepig dengegan nu Gamaꞌ ta Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Pia alanduni penenebiin niu dinaan, saꞌ sumalabuuk amu dinaan, naa penggulaulaan ku.” ");
INSERT INTO syb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Kaliꞌ gusay pektaluꞌ si Isus, “Naa, saꞌ mekpetail amu dinaan, subay petuuden niu su nga suguꞌan ku. ");
INSERT INTO syb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Penengiin ku dayun tu Gamaꞌ ta begayan amu niin sala pa Mengingabang, su dumuma lelayun diniu. ");
INSERT INTO syb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Iin sug Balakat nu Megbebayaꞌ, su megbuas diniu tu metuud mekatag di Megbebayaꞌ. Iin, ndiꞌ mpenembaꞌ nu ngag duma kilawan dinig lumbang kini, puꞌ ndiꞌ nilan maitaꞌ, mukaꞌ ndiꞌ ilan sumambat diniin. Laak yamu, suminambat amu diniin, puꞌ suminala na diniu, mukaꞌ bigay na diniu. ");
INSERT INTO syb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Naa, mekawaꞌu pasiꞌ dini, laak ndiꞌu amu belengan maaꞌ nu gidu, puꞌ mpuliꞌ dau dini niu. ");
INSERT INTO syb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ndiꞌ maiben, ndiꞌ nau gusay maitaꞌ nu nga kilawan, laak dagid yamu, maitaꞌ pa niau puliꞌ. Kagina metubuꞌu, metubuꞌ damu dema di ndaꞌi tamanen. ");
INSERT INTO syb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Saꞌ mateng ki gendaw kia, mesuunan niu puꞌ naan mukaꞌ su Gamaꞌu, iin da, mukaꞌ salabuuk daita dema di ginaa. ");
INSERT INTO syb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Adin su dumawat tu suguꞌan ku mukaꞌ mekpetuud dun, iini mekpetail dinaan. Mukaꞌ dema adin su mekpetail dinaan, iini petailen dadema nu Gamaꞌu. Melelaat dau dema diniin mukaꞌ mekpaitaꞌu dun gupia.” ");
INSERT INTO syb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Naa sala tawan dinilan si Judas (sangay ni Judas Iscariote), kaliꞌ pektaluꞌ, “Sir, taꞌ mai mekpaitaꞌa dun dinami, laak dagid ndiꞌa mekpaitaꞌ tu tibaꞌan getaw?” ");
INSERT INTO syb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Kaliꞌ sembag si Isus, “Adini getaw mekpetail dinaan, dunutanen su tituluꞌan ku. Melelaat dun dayun su Gamaꞌu mukaꞌ meditu ami niin. Puꞌ yami duaꞌ nu Gamaꞌu, sumala ami diniin megbenwa. ");
INSERT INTO syb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Naa, adin su ndiꞌ mekpetail dinaan, ndiꞌen dunutan su tituluꞌan ku. Su teluꞌen ku medengeg niu, kanaꞌ danaan laak delendeman, puꞌ danu Gamaꞌu, su suminuguꞌ dinaan. ");
INSERT INTO syb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Naa, su saanan ku dini niu, pekteluꞌen ku ia diniu. ");
INSERT INTO syb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Saꞌ mpalus nau dini niu, kig Balakat nu Megbebayaꞌ, su Mengingabang, suguꞌen nu Gamaꞌu medini niu, puꞌ iini meksalabuuk gupia dinaan. Pektuꞌunan amu niin dayun dig launanen, mukaꞌ tegyungen amu niin tug launan tinaluꞌu diniu. ");
INSERT INTO syb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Mendadi, iini pengumbilin ku diniu, ki pianan ginaa, maꞌniin nug danaan. Kanaꞌ maaꞌ nu kebegay dun nu kilawan, kaas ndiꞌ amu melibuleng mukaꞌ ndiꞌ amu mendek. ");
INSERT INTO syb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Midengeg niu su tinaluꞌu puꞌ mpalus nau dini niu mukaꞌ mpuliꞌ dau dini. Saꞌ mekpetail amu gupia dinaan, leliagen amu dun sia saꞌ muliꞌu tu Gamaꞌu, puꞌ iini metaas pa dinaan. ");
INSERT INTO syb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Iini tinaluꞌu dun diniu su ndaꞌ pa mpenggulaula, puꞌ adun saꞌ mpenggulaula na, sumalig amu dinaan. ");
INSERT INTO syb_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Naa, ndiꞌu paibeneni teluꞌen ku diniu, puꞌ peksebang na dini su kaunutan nu tibaꞌan getaw, su Palin. Ndaꞌi pegbayaꞌen dini naan. ");
INSERT INTO syb_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Laak dagid penggulaulaan ku laak su sinuguꞌan dinaan nu Gamaꞌu, adun mesuunan nu nga kilawan puꞌ petailen ku su Gamaꞌu. “Kaas pegbuat amu, puꞌ guaꞌ ita dini.” ");
INSERT INTO syb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Kaliꞌ pektaluꞌ si Isus tu nga sakupen, “Mendadi, naani tantu puun nu pimula. Su Gamaꞌui megingat dun. ");
INSERT INTO syb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Adin su pangau ndiꞌ megbunga, tenluun nu Gamaꞌu, mukaꞌ adin su megbunga, timpadanen, adun meksilaun paig bunganen. ");
INSERT INTO syb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Naa, yamu nu nga sakupu, maꞌniin namu nu miugasan nu tinaluꞌu diniu. ");
INSERT INTO syb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kaas salabuuk amu gusay dinaan. Salabuuk dau dema diniu. Puꞌ saꞌ su panga nu pimula, ndiꞌ mekegbunga saꞌ suuay tu puunen. Maꞌantu damu dema, ndiꞌ niu mpenggulaulaani gempia, subay sumalabuuk amu dinaan gusay. ");
INSERT INTO syb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Naa, naani puun nu pimula, yamui nga panganen. Adin su sumalabuuk dinaan lelayun, mukaꞌ sumalabuuk dau dema diniin, iini megbunga melaun. Puꞌ saꞌ kanaꞌ da naan, ndiꞌ niu mpenggulaula. ");
INSERT INTO syb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Naa, saꞌ duuni getaw ndiꞌ sumalabuuk dinaan, mesama tu panga belengen kaas megangu dayun. Pungunen dayun sug launan migangu, pemiglaken tu gapuy adun metutung. ");
INSERT INTO syb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Saꞌ sumalabuuk amu dinaan gusay, mukaꞌ mengganget pa padun dig delendeman niu ki teluꞌen ku, pia alanduni penenebiin niu, begay diniu nu Gamaꞌu. ");
INSERT INTO syb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Puꞌ saꞌ penggulaulaan niui gempia, megleep dayunig dengegan nu Gamaꞌu, mukaꞌ mekpalas su kesakup niu dinaan. ");
INSERT INTO syb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Naa, melelaatu diniu maaꞌ nug lelaat nu Gamaꞌu dinaan. Yamu dema, subay salig amu lelayun tug lelaatu diniu. ");
INSERT INTO syb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Saꞌ petuuden niu su nga tinituluꞌu diniu, sumalig damu dema dayun dig lelaatu diniu. Maꞌniin dinaan, pituudu su tinituluꞌ nu Gamaꞌu, mukaꞌ suminalig dau dig lelaaten dinaan. ");
INSERT INTO syb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Naa tinaluꞌu ia diniu, adun meleep diniuig leliagu, mukaꞌ megelaꞌig leliag niu. ");
INSERT INTO syb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Iini pinalintau diniu, pekpinetailay amu lepeng di kepetailu diniu. ");
INSERT INTO syb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Su tampusan petailan, iin saꞌ upama duuni getaw sumaliunung tu sambaten, iin, lamig da dun matay sabaꞌ tu petailanen. ");
INSERT INTO syb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Naa yamu, sambatu amu saꞌ penggulaulaan niu su nga tinituluꞌu diniu. ");
INSERT INTO syb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ndiꞌu na paingalan diniu nga sesuguꞌen ku, puꞌ paingalan ku diniu nga sambatu. Saꞌ upama ki sesuguꞌen, ndiꞌen suunani penggulaulaan nu tuminindan diniin, laak yamu, migelaꞌu pesuun diniu su midengegu di Gamaꞌu. ");
INSERT INTO syb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kanaꞌ yamui mimiliꞌ dinaan. Naani mimiliꞌ diniu, mukaꞌ tinduꞌu amu mangay amu menggulaula gempia, maꞌniin memunga amu ngag bunga ndaꞌi gikteben. Kaas adin su penenebiin niu tu Gamaꞌ ta, saꞌ sumalabuuk amu dinaan, begayen diniu. ");
INSERT INTO syb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Iin dayuni tituluꞌu diniu, pekpinetailay amu.” ");
INSERT INTO syb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Laung padun ni Isus, “Naa, su nga kilawan, saꞌ megbanta ilan diniu, ndiꞌ niu selingaway puꞌ miunau nilan bentaay. ");
INSERT INTO syb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Saꞌ sia duma amu nu nga kilawan dig lumbang kini, mekpetail ilan sia diniu, puꞌ metau ilan melelaat tu samataw nilan. Kagina pimiliꞌu amu di nga kilawan mukaꞌ pinaasu amu dinilan, bentaan amu nilan. ");
INSERT INTO syb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ndiꞌ niu selingaway su tinaluꞌu diniu puꞌ su sesuguꞌen, kanaꞌ metaas pa di suminuguꞌ dun. Kaas saꞌ peglegetanu nu nga kilawan, peglegetan damu dema nilan. Laak dagid saꞌ dunutan nilan su tinituluꞌu, dunutan da nilan dema su tituluꞌ niu. ");
INSERT INTO syb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Iini puun gupia nug launan kegleget nilan diniu, puꞌ sabaꞌ sakupu amu mukaꞌ ndaꞌ nilan mesuunay su suminuguꞌ dinaan medini niu. ");
INSERT INTO syb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Saꞌ sia ndaꞌu pedini mekpetuꞌun dinilan, ndaꞌ siai salaꞌ nilan. Laak nemun ndaꞌig lapal nilan di nga salaꞌ nilan. ");
INSERT INTO syb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Adin su getaw megbanta dinaan, megbanta dadema tu Gamaꞌu. ");
INSERT INTO syb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Saꞌ ndaꞌ nilan sia maitaꞌ su pinggulaulau ndaꞌ mainsan penggulaulaay nug lain getaw, ndaꞌ siai salaꞌ nilan. Laak gembagel nai salaꞌ nilan, puꞌ minitaꞌ na nilan su mekesalebuꞌ pinggulaulau, laak ndaꞌ nilan petuuday, kaas bentaanu nilan mukaꞌ su Gamaꞌu. ");
INSERT INTO syb_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Su kebanta nu nga kilawan, iini mipenggulaula dun adun menuud su sinulat dengantu di Palinta nilan. Puꞌ ndaꞌ ba mesulat, ‘Ndaꞌi sabaꞌu dun ki kebanta nilan dinaan.’” ");
INSERT INTO syb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Laung pa ni Isus, “Naa, su Mengingabang suguꞌen ku medini niu, sug Balakat nu Megbebayaꞌ, saꞌ mateng nain, peglegintuudenu niin di nga getaw, puꞌ buasanen su metuud mekatag di Gamaꞌu. Pigenatanen padun su Gamaꞌu. ");
INSERT INTO syb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Yamu dema, peglegintuuden niau tu nga getaw, puꞌ genat di pikpuunanen, suminalabuuk amu dinaan.” ");
INSERT INTO syb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Maaꞌ laung padun ni Isus, “Naa iini tinaluꞌu dun diniuig launanen, adun pia melegenan amu, ndiꞌ amu lumukas sumalig dinaan, kaas tuliud amu tu kekpetuud niu. ");
INSERT INTO syb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Duuni gendaw mateng, utidan amu nu nga getaw Judea dia simbaan nilan. Mukaꞌ dema, duuni nga getaw, saꞌ bunuꞌen amu nilan, laung nilan dun, suminugut ilan tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Memaꞌantu ilan, puꞌ ndaꞌ ilan sambat tu Gamaꞌ ta, mukaꞌ ndaꞌ ilan dema sambat dinaan. ");
INSERT INTO syb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Iini tinaluꞌu dun diniu, adun saꞌ matengi gendaw nu kegleget nilan diniu maꞌnia, melabuꞌ dayun dig delendeman niu puꞌ iin na su pekteluꞌen ku.” Laung padun ni Isus, “Naa ki nga tinaluꞌu kini diniu, genat tu puunanen, ndaꞌu pesuun diniu, puꞌ duminuma pau diniu. ");
INSERT INTO syb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nandaw pisuun ku na diniu, puꞌ muliꞌu tu suminuguꞌ dinaan. Bisan maꞌantu, pia sala tawan diniu, ndaꞌi suminaak dun dinaan saꞌ tandaꞌu pangay. ");
INSERT INTO syb_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Laak dagid miubaꞌ amu gupia sabaꞌ nu tinaluꞌu diniu. ");
INSERT INTO syb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Taman taluꞌu diniu, mpianan amu saꞌ mawaꞌ nau dini. Saꞌ ndiꞌu mawaꞌ dini, naa su Mengingabang diniu, ndiꞌ medini niu. Laak saꞌ mawaꞌu dini, suguꞌen ku iin medini. ");
INSERT INTO syb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Mukaꞌ ki Mengingabang kini, saꞌ mateng, pesuunen di nga kilawan su sayep nilan mekatag di salaꞌ, di kekesuun, mukaꞌ di ginukuman. ");
INSERT INTO syb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Pesuunen dinilan su sayep nilan mekatag di salaꞌ, puꞌ su puun nug limbung, iin su kemilas nilan dinaan. ");
INSERT INTO syb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Pesuunen dadema dinilan su sayep nilan mekatag dig bianan nu kekesuun, puꞌ muliꞌu tu Gamaꞌu, ndiꞌ niau dayun maitaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Pesuunen pa padun dinilan su sayep nilan mekatag di ginukuman di nga kilawan, puꞌ su Palin, su kaunutan nu tibaꞌan kilawan, daan na inukuman. ");
INSERT INTO syb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Melaun pai teluꞌen ku diniu, laak nemun, ndiꞌ na niu muitan. ");
INSERT INTO syb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Laak kig Balakat nu Megbebayaꞌ, su megbuas di metuud mekatag di Megbebayaꞌ, saꞌ mateng na, munut diniu tu taman metuud. Su teluꞌenen, kanaꞌ mikpuun tu pegbayaꞌen, iini pesuunen su da medengegen. Teluꞌenen dadema su gembianan tug binayaꞌ gebii buꞌ gendaw. ");
INSERT INTO syb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Megleepig dengegan ku puun diniin, puꞌ petendayen dadema diniu su pemuun ku. ");
INSERT INTO syb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Adin sug danu Gamaꞌu, danaan dadema, kaas kiai tinaluꞌu dun puꞌ petenday diniu nug Balakat nu Megbebayaꞌ su pemuun ku.” ");
INSERT INTO syb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Laung padun ni Isus, “Naa naan kini, ndiꞌ nau maiben di mata niu. Dayun laak ndiꞌ maiben, maitaꞌ da niau puliꞌ.” ");
INSERT INTO syb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Duun dayuni nga sakupen miksinaakay, laung nilan, “Taꞌ mai tinaluꞌen dun dinita puꞌ ndiꞌ na maiben di mata ta, dayun ndiꞌ maiben, maitaꞌ ta daw puliꞌ? Taꞌ alanduni guluganeni tinaluꞌen kia, ‘Puꞌ muliꞌu,’ laungen, ‘tu Gamaꞌu’? ");
INSERT INTO syb_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Taꞌ mai guluganeni tinaluꞌen kia, ‘Ndiꞌ maiben’? Ndiꞌ ta mesabut!” ");
INSERT INTO syb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Naa, si Isus, misuunanen puꞌ saakan nilan sia. Kaliꞌ pektaluꞌ dinilan, “Iin mai migduaꞌduaꞌig delendeman niu dun su gulugan nu tinaluꞌu diniu puꞌ ndiꞌ nau maiben di mata niu, dayun ndiꞌ maiben, maitaꞌ da niau puliꞌ? ");
INSERT INTO syb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Taman taluꞌu diniu, mektenlis amu mengaduy, melegenan amu, laak su ngag lain kilawan, leliagen. Su kelegenay niu, ndiꞌ maiben mbaluy leliag niu. ");
INSERT INTO syb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Pinenggiꞌ duunig libun megbataꞌ. Saꞌ sungu megbatik tian, melibuleng. Laak saꞌ migbataꞌ na, milingawanen su kelibulengen, puꞌ liliag tug bataꞌen migigetaw na dinig dibabaw lumbang ta kini. ");
INSERT INTO syb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Yamu, maꞌantu damu dema, melegenan namu. Laak dagid mekitaꞌ ita puliꞌ, dayun megelaꞌig leliag niu, mukaꞌ ndaꞌidun nai mekepalin dun diniu. ");
INSERT INTO syb_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Taman taluꞌu diniu, ki gendaw kiin, ndiꞌ na niau mesaakan, puꞌ iini penengian niu su Gamaꞌu. Pia alanduni penenebiin niu diniin, begayen diniu saꞌ sumalabuuk amu dinaan. ");
INSERT INTO syb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Sampay nemun, ndaꞌi pinenabi niu mesembayan pa niui ngalan ku. Naa, penenabi amu, begayan amu dayun, adun megelaꞌig leliag niu.” ");
INSERT INTO syb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Mendadi, diksuꞌ ni Isus ki tinaluꞌen, laungen, “Naa, kiai sinambingayu diniu, laak sungu matengi gendaw, ndiꞌ nau meksambingay, puꞌ penluksaden ku na diniu gupia sug betad nu Gamaꞌ ta. ");
INSERT INTO syb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Naa ki gendaw kiin, saꞌ menenabi amu, mesambay niui ngalan ku. Ndiꞌu namu kambat penenebian tu Gamaꞌ ta, ");
INSERT INTO syb_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","puꞌ iin, melelaat dadema diniu gupia. Melelaat diniu, puꞌ mekpetail amu dinaan, mukaꞌ mituudan amu dun puꞌ pigenatan ku iin. ");
INSERT INTO syb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Su kediniin ku lumbang, genatu tu Gamaꞌ ta. Nandaw, mawaꞌu dinig lumbang, puꞌ muliꞌu tu Gamaꞌ ta.” ");
INSERT INTO syb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Kaliꞌ pektaluꞌ su nga sakupen, “Naa, pinluksad mu na, ndaꞌ mu na sambingayay. ");
INSERT INTO syb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Misuunan na nami puꞌ yaꞌai mekesuun tug launanen. Puꞌ pia ndiꞌa saakan nu getaw, sembagen mui misebuꞌan dun, kaas mituudan ami dun puꞌ genata tu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Kaliꞌ taluꞌ si Isus, “Mituudan bamu dun nandaw? ");
INSERT INTO syb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Bentayay pa daan, pegdateng na su gendaw megelaꞌ amu mesigwag, puꞌ belengan niau, piksesala tawan diniu, muliꞌ tug balayen. Mukaꞌ minateng nai gendaw kia. Laak kanaꞌu da sala, puꞌ suminalabuuk dinaan su Gamaꞌu. ");
INSERT INTO syb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Iini tinaluꞌu dun diniu, adun mpiai ginaa niu puun di keksalabuuk niu dinaan. Peglegetan amu nu nga kilawan sabaꞌ nu keksalabuuk niu dinaan. Laak ndiꞌ amu mendek, puꞌ dinaagu na su nga kilawan!” ");
INSERT INTO syb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Mendadi si Isus, benaꞌ mideksuꞌ mektaluꞌ, migangag tug langit, kaliꞌ penenabi, laungen, “Amaꞌ, mitektak na su sesaꞌ. Paitaꞌ mu di nga getaw su kelengas nu pegbayaꞌu, naan kig Bataꞌ mu, adun paitaꞌu dinilan su kelengas nug daniꞌa. ");
INSERT INTO syb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Puꞌ bigay mu megbayaꞌu di tibaꞌan getaw, adun begayan ku ketubuꞌ ndaꞌi tamanen su nga getaw pisalig mu dinaan. ");
INSERT INTO syb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Adin su getaw mekesuun diniꞌa, su tantu Diwata, mukaꞌ mekesuun dinaan, si Isukristu ki sinuguꞌ mu medinig lumbang, iini mpeduunan ketubuꞌ ndaꞌi tamanen. ");
INSERT INTO syb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Su kelengas nu pegbayaꞌ mu, pinitaꞌu na di nga kilawan dinig lumbang kini, puꞌ gilaꞌu tubusay su pipenggulaula mu dinaan. ");
INSERT INTO syb_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Uu, Amaꞌ! Su ndaꞌ pa mbaalig lumbang, miksalabuuk ita di kelengas nu pegbayaꞌ ta. Nandaw, uliꞌ mu dinaan su kelengasen. ");
INSERT INTO syb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Naa, ki nga getaw kini pisakup mu dinaan pimiliꞌ mu tu nga kilawan, pisuun ku dinilan ki gasal mu. Bekna, sakup mu ilan, dayun pisakup mu ilan dinaan. Pituud nilan dadema su tinaluꞌ mu. ");
INSERT INTO syb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Mukaꞌ nemun, misuunan nilan puꞌ yaꞌai pigenatan nug launan taman nug bigay mu dinaan. ");
INSERT INTO syb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Pitendayu dinilan su pimuun mu dinaan, mukaꞌ dinawat nilan ia, kaas misuunan nilan tuꞌu puꞌ yaꞌai pigenatan ku. Mituudan ilan dun puꞌ suminuguꞌa dinaan medini.” ");
INSERT INTO syb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Laung pa ni Isus, “Naa ki nga bigay mu dinaan, penenebian ku ilan diniꞌa, puꞌ ilan, daniꞌa tuꞌu. Kanaꞌ nu tibaꞌan getaw dig lumbang kinii penenebian ku. ");
INSERT INTO syb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Kig launan danaan, daniꞌa dadema. Sug launan daniꞌa, danaan da pagid, kaas maitaꞌ na su kelengas nu pegbayaꞌu pebian dinilan nu nga sakup bigay mu dinaan. ");
INSERT INTO syb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mekauliꞌ nau tu niꞌa, mekawaꞌu dinig lumbang kini, laak ki nga sakupu kini, dini pailan lumbang. Uu Amaꞌ, mekesuun ka, Amaꞌ! Ingat mu ilan, pebian di ginuung nu ngalan mu, ki ngalan bigay mu dinaan, adun meksalabuuk ilan maꞌniin nu keksalabuuk ta. ");
INSERT INTO syb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Sinegay diin pau nilan, iningatu ilan gupia pebian di ginuung nu ngalan mu bigay mu dinaan. Pilayuꞌu ilan tu melaat, kaas ndaꞌi mbeleng, subay su getaw tinduꞌan dun mbeleng tuꞌu. Iini mbeleng adun menuud su sinulat dengantu di Misulat Taluꞌ mu. ");
INSERT INTO syb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nandaw sunguu muliꞌ tu niꞌa, kaas su saanan ku dini pa lumbang, pekteluꞌen ku ini, adun meleep di nga sakupuig leliagu mukaꞌ megelaꞌig leliag nilan. ");
INSERT INTO syb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Pitendayu dadema dinilan su pimuun mu dinaan. Kaas binanta ilan nu nga kilawan dig lumbang kini, puꞌ kanaꞌ nailan duma nu nga kilawan, maꞌniin dinaan, kanaꞌu duma nu nga kilawan. ");
INSERT INTO syb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mendadi, kanaꞌ iini pekpenenebiin kui kekpawaꞌ mu dinilan dig lumbang kini, puꞌ iini pinenabiu diniꞌa, pelayuꞌ mu ilan di Palin, adun ndiꞌ ilan metalin. ");
INSERT INTO syb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Kanaꞌu duma nu nga kilawan dig lumbang kini. Mesama da, kanaꞌ dailan dema duma ditu. ");
INSERT INTO syb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Pegwakil mu ilan dig lawas mu pebian di metuud. Iini metuud su taluꞌ mu. ");
INSERT INTO syb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Sinuguꞌu ilan mekpelak ilan di tibuuk benwa maaꞌ nu kesuguꞌ mu dinaan kediniin ku lumbang. ");
INSERT INTO syb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mukaꞌ pegwakilu diniꞌaig lawasu gumantiꞌ di kepatay nilan, adun mpegwakil dailan dema diniꞌa tantu. ");
INSERT INTO syb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Naa ki nga sakupu kini, kanaꞌ laak ilani penenebian ku, puꞌ duun pai nga metuudan dinaan sabaꞌ nu gukiten nilan. Naa, ilan pai penenebian ku, ");
INSERT INTO syb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","adun megelaꞌ ilan meksalabuuk, maꞌniin nu keksalabuuk ta di ginaa. Iini mauyaꞌan ku, Amaꞌ, salabuuk ilan di ginaa, launan nilan, puꞌ adun metuudan dun su nga kilawan dig lumbang puꞌ yaꞌai suminuguꞌ dinaan tuꞌu medini. ");
INSERT INTO syb_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Su kelengas nu pegbayaꞌu bigay mu dinaan, bigayu dadema dinilan, adun meksalabuuk dailan dema maꞌniin keksalabuuk ta. ");
INSERT INTO syb_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Miksalabuuku dinilan mukaꞌ suminalabuuka dinaan, puꞌ adun mengganget su keksalabuuk nilan. Mesuunan dayun nu nga kilawan puꞌ sinuguꞌ mau medini mukaꞌ pitail mu su nga sakupu maaꞌ nu kepetail mu dinaan.” ");
INSERT INTO syb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Diksuꞌ ni Isus ki kenenabinen, “Naa, uu Amaꞌ! Iini mauyaꞌan ku dadema, su nga sakup bigay mu dinaan, dumunut ilan dinaan pia tandaꞌu, adun maitaꞌ nilan su kelengas nu pegbayaꞌu bigay mu dinaan sabaꞌ nu kepetail mu dinaan, saꞌ ndaꞌ pa mbaalig lumbang. ");
INSERT INTO syb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Amaꞌ, mekesuun ka! Ndaꞌ sambat su nga kilawan diniꞌa, laak dagid naan, suminambatu diniꞌa mukaꞌ ki nga sakupu kini, misuunan nilan puꞌ sinuguꞌ mau. ");
INSERT INTO syb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Inukitan ku ilan mekatag diniꞌa mukaꞌ ukitan ku pa gusay, adun mengganget dig delendeman nilan su kepetail mu dinaan, mukaꞌ adun meksalabuuk ami nu nga sakupu kini.” ");
INSERT INTO syb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Naa benaꞌ mitubus menenabi si Isus, gumiwaꞌ dia, ilan nu nga sakupen, duminipag ilan tu sapaꞌ Kidron. Duuni pegimulanan gayu dia, sumiled dayun dia si nga Isus. ");
INSERT INTO syb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Naa kini si Judas, su mektipu dini Isus, misuunaneni pegimulanan gayu kia, puꞌ tatap pekpungunay ni Isus, ilan nu nga sakupen. ");
INSERT INTO syb_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Mendadi, minangay si Judas dia pegimulanan, inunutanen diai nga sundalu nu getaw Roma mukaꞌ nga pegingat tu Pengedapan tu Megbebayaꞌ, ki sinuguꞌ nu nga kaunutan nug belian nu getaw Judea mukaꞌ nu nga Pariseo. Misangkap ilan besi mukaꞌ tilaw. ");
INSERT INTO syb_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Mendadi si Isus, kagina daanen na mesuunay sug launan mpenggulaula diniin, suminungkak dinilan, kaliꞌ saak dinilan, “Taꞌ taway duni pekpenengaun niu?” ");
INSERT INTO syb_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Kaliꞌ ilan sembag, “Si Isus, getaw Nazaret.” “Naan main,” laung ni Isus. Naa pegindeg dia si Judas, su mektipu diniin, kampuꞌ nu melaun dumanen kia. ");
INSERT INTO syb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Sikna mitaluꞌ ni Isus dinilan, “Naan,” mingegdud ilan, mikedingkalang ilan tanan. ");
INSERT INTO syb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Sinaak puliꞌ ni Isus dinilan, “Taꞌ taway dun daani penengaun niu?” Laung nilan puliꞌ, “Si Isus, getaw Nazaret.” ");
INSERT INTO syb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Kaliꞌ dayun pektaluꞌ si Isus, “Naa, tinaluꞌu na daan diniu puꞌ naan main kini. Mendadi saꞌ naan da laaki penengaun niu, ndiꞌ da niu peduma ki ngag dumau kini.” ");
INSERT INTO syb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Kaas maꞌniai tinaluꞌ ni Isus, puꞌ adun menuud ki kinenabinen kamun, laungen, “Uu Amaꞌ, su nga piglegetawan ku bigay mu dinaan, pia sala tawan, ndaꞌi mibeleng dun dinaan.”) ");
INSERT INTO syb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Naa si Simon Pedro, duunig badungen. Binakuten dayun, tinigbaseni gulipen nu Tampusan Metaas Belian nu getaw Judea. Miseksipi sedibaluy telinganen, dapit lintunen. Su ngalan nu gulipen kia, si Malco. ");
INSERT INTO syb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Kaliꞌ pektaluꞌ si Isus dini Pedro, “Baa, gumaꞌ muig badung mu kiin! Ki tasa mipenuꞌ kelegenay pininum dinaan nu Gamaꞌu, ndiꞌu ba tebuken?” ");
INSERT INTO syb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mendadi dinaap si Isus nu nga sundalu mukaꞌ nu nga kaunutan nilan sampay su nga pegingat sinuguꞌ nu getaw Judea. Pinalik nilan dayun. ");
INSERT INTO syb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Bekna, inagak nilan tu ni Anas, iin su penugangan ni Caifas, su Tampusan Metaas Belian nu getaw Judea di taun kia. ");
INSERT INTO syb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Naa si Caifasi miktaluꞌ kiin tu nga kaunutan nu getaw Judea puꞌ papas sala tawani gumantiꞌ di kepatay nu tibaꞌan getaw. ");
INSERT INTO syb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Naa kini si Pedro, miglendug dini Isus, dumaneni sala tawan samasakupen. Kagina minilala nu Tampusan Metaas Belian su sala sakup ni Isus kia, mikegdunut iin dini Isus suled diag lenuꞌan nug balay nu Tampusan Metaas Belian. ");
INSERT INTO syb_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Laak si Pedro, pegindeg pa diag liu, mesempel tu gengaꞌan nug lenuꞌan. Dayun puliꞌ gumiwaꞌ su sala sakup kia, migabitabit dayun tug delaga migingat tu gengaꞌan, piseleden dayun si Pedro diag lenuꞌan. ");
INSERT INTO syb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Sinaak dayun nug delaga kia dini Pedro, “Kanaꞌa ba sakup dadema nu getaw kiin?” “Baa, kanaꞌ lai,” laung ni Pedro. ");
INSERT INTO syb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Naa su nga sesuguꞌen mukaꞌ su nga megingat dia, miguklak ilan musing, puꞌ metegdaw dia. Pemegindeg ilan menalang dia, luminamug dayun dinilan pegindeg si Pedro, menalang dadema. ");
INSERT INTO syb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mendadi su Tampusan Metaas Belian, sinaakanen si Isus mekatag di nga sakupen mukaꞌ tu tinituluꞌen. ");
INSERT INTO syb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Kaliꞌ sembag si Isus, “Ki tinaluꞌu, pinluksadu tu tibaꞌan getaw. Lelayunu mikpetuꞌun dia nga simbaan nu getaw Judea mukaꞌ ditu Pengedapan tu Megbebayaꞌ, dia tandaꞌ pekpungunan nu kelaun getaw. Ndaꞌi taluꞌu mileglud. ");
INSERT INTO syb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Naa mauma dema sinaakan mau? Melengas iini penenaakan mu, su nga mikedengeg tu tinaluꞌu kitu, saꞌ taꞌ alanduni tinaluꞌu dinilan. Puꞌ misuunan nilani tinaluꞌu.” ");
INSERT INTO syb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Sikna mitaluꞌ ni Isus, dinapiꞌ dayun nu sala tawan pegingat migindeg dia, laungen, “Masiꞌ mekakuꞌa sumbag maꞌnia di Tampusan Metaas Belian?” ");
INSERT INTO syb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Kaliꞌ sembag si Isus, “Saꞌ mikektaluꞌu melaat, melengas peglegintuud mu di nga getaw kini. Dagid saꞌ metuudi tinaluꞌu, naa mauma dema depiꞌen mau dun?” ");
INSERT INTO syb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Mendadi, sinuguꞌ dayun ni Anas egaken si Isus, pinalik pa gusay, ditu ni Caifas, su sala Tampusan Metaas Belian. ");
INSERT INTO syb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Naa kini si Simon Pedro, pegindeg pa diag lenuꞌan ni Anas, bineeg menalang. Sinaak nu ngag dumanen dia, “Kanaꞌa ba sakup pa pagid nu getaw kiin?” Dagid mimalaw puliꞌ si Pedro, laungen, “Baa, kanaꞌ lai.” ");
INSERT INTO syb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Naa duuni sesuguꞌen nu Tampusan Metaas Belian dia, betaꞌan nu getaw kia tinigbas ni Pedroi telinganen. Iin, suminaak pelum dini Pedro, “Kanaꞌ ba yaꞌa su minitaꞌu dumanen ditu pegimulanan gayu kitu?” ");
INSERT INTO syb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","“Baa, kanaꞌ lai!” laung ni Pedro. Iin na demai keguni manuk. ");
INSERT INTO syb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Naa benaꞌ putiꞌ delagay, su nga kaunutan nu getaw Judea, inagak nilan si Isus tug balay nu gubirnadur genat diag balay ni Caifas. Laak ndaꞌ nilan dayun seledayig balay kia, adun ndiꞌ ilan melemuꞌan, mbuus ndiꞌ ilan mekaꞌaan tug Lebungan gindan ditug Liniusan. ");
INSERT INTO syb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Mendadi ki gubirnadur kia si Pilato, lumiu dia gedapan nilan, sinaakanen dayun ilan, laungen, “Mendadi, taꞌ alandunig dangat niu mekatag di getaw kini?” ");
INSERT INTO syb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Kaliꞌ sembag su nga kaunutan kini, “Naa saꞌ kanaꞌ da mikesalaꞌi getaw kiin, ndiꞌ nami sia pegwakil diniꞌa.” ");
INSERT INTO syb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Kaliꞌ sembag si Pilato, “Naa saꞌ maꞌantu, uit niu iin adun ukumen niu mekatag dig balaꞌud niu.” Kaliꞌ ilan sembag, “Naa ndiꞌ mesuꞌat, puꞌ ndaꞌi pegbayaꞌ nami ukuman namii getaw lagaꞌ na ginaanen.” ");
INSERT INTO syb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Kinii mipenggulaula, adun menuud ki tinaluꞌ kiin ni Isus, su pisuunen pedaan kig bian nu kepatayen.) ");
INSERT INTO syb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Saꞌ maꞌnia, sumiled puliꞌ si Pilato diag balayen, sinabinen si Isus. Mendadi suminaak dayun si Pilato diniin, “Naa, metuud ba, yaꞌai gadiꞌ nu getaw Judea?” ");
INSERT INTO syb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Kaliꞌ sembag si Isus, “Ki sinaak mu kini, daniꞌa da delendeman, atawaka lain getaw mai miktaluꞌ dun diniꞌa mekatag dinaan?” ");
INSERT INTO syb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Kaliꞌ sembag si Pilato, “Laung mu dun getaw Judea mau? Su nga kaunutan niu mukaꞌ su nga kaunutan nug belian niui migwakil diniꞌa dinaan. Naa, taꞌ alanduni melaat pinggulaula mu?” ");
INSERT INTO syb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Kaliꞌ pektaluꞌ si Isus, “Ki keglekaunutan ku, kanaꞌ miksekat dig lumbang kini. Saꞌ upama miksekat sia dig lumbang kini, naa sumugut sia su nga sakupu, adun ndiꞌu mpegwakil tu nga kaunutan nu getaw Judea. Dagid ki keglekaunutan ku, kanaꞌ daan miksekat dig lumbang kini!” ");
INSERT INTO syb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Sinaak pelum ni Pilato, “Mendadi, gadiꞌa ba?” Kaliꞌ sembag si Isus, “Yaꞌa mai miktaluꞌ dun puꞌ gadiꞌu. Iini migigetawu dun mukaꞌ iini luminusadu dun dinig lumbang, puꞌ adun peglegintuuden ku su metuud. Adin su getaw mektalenten tu metuud, mekineeg tu taluꞌu.” ");
INSERT INTO syb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Laung ni Pilato, “Naa saꞌ maꞌantu, taꞌ mai metuud?” Benaꞌ mideksuꞌ mektaluꞌ si Pilato kia, lumiu puliꞌ dia gedapan nu nga getaw Judea. Kaliꞌ pektaluꞌ dinilan, “Ki getaw kini, ndaꞌidun mai misimaꞌu salaꞌen. ");
INSERT INTO syb_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Dagid kagina duunig betad niu beluyen kui sala tawan pinikutan metaang dig Lumpuk niu gindan tug Liniusan, naa taꞌ ma? Mauyaꞌan niu beluyen ku diniu ki gadiꞌ nu getaw Judea?” ");
INSERT INTO syb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Mimeksay ilan dayun sumbag, laung nilan, “Kanaꞌ iin! Si Barabasi mauyaꞌan nami!” (Naa si Barabas kia, tulisan.) ");
INSERT INTO syb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tubus itu si Isus, pibadas ni Pilato tu nga sundalu. ");
INSERT INTO syb_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Miglingkin ilan dugi, tautau tundek gadiꞌ, dayun nilan peselup di gulunen. Mukaꞌ pikselukan nilan melambung suub gempula, tautau suub gadiꞌ. ");
INSERT INTO syb_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Minadap ilan dayun diniin, laung nilan, “Naa mpianan ka, Sir, Gadiꞌa daw nu nga getaw Judea!” Pinemalan nilan padun depiꞌay si Isus. ");
INSERT INTO syb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Mendadi si Pilato, lumiu na pelum dia gedapan nu melaun getaw kia, kaliꞌ pektaluꞌ dinilan, “Naa bentayay pa daan niu, pediniin ku puliꞌ iin di gedapan niu, adun mesuunan niu puꞌ ndaꞌidun ma daani misimaꞌu salaꞌen.” ");
INSERT INTO syb_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Lumiu dayun si Isus dia gedapan nu nga getaw, piselupan pa tundek dugi kia mukaꞌ piselukan pa nu melambung suub gempula. Laung ni Pilato tu nga getaw, “Naa, bentayay pa daan niu! Kini na su getaw!” ");
INSERT INTO syb_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Mendadi ki nga kaunutan nug belian kini mukaꞌ nga megingat tu Pengedapan tu Megbebayaꞌ, saꞌ minitaꞌ nilan si Isus, mimeksay ilan, laung nilan, “Lensangen di kurus! Lensangen di kurus!” Laung ni Pilato dinilan, “Naa, alap niu, yamu nai lansang dun di kurus. Naan, ndaꞌidun daan tuꞌui misimaꞌu salaꞌen.” ");
INSERT INTO syb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Kaliꞌ pelum sembag su nga melaun getaw, “Duunig balaꞌud nami subay matayi getaw kiin, puꞌ inangkenen iin sug Bataꞌ nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Sikna midengeg ni Pilato su tinaluꞌ nilan, migiseg laaki gendeken. ");
INSERT INTO syb_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Sumiled puliꞌ diag balayen, sinaaken puliꞌ dini Isus, “Naa taꞌ mai tantu pigenatan mu?” Laak dagid ndaꞌ sembag si Isus. ");
INSERT INTO syb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Laung ni Pilato diniin, “Masiꞌ ndiꞌ mau sembagen? Ndaꞌ mu ba mesuunay puꞌ duuni pegbayaꞌu lekaten ka atawaka lensangen ka di kurus?” ");
INSERT INTO syb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Simbag ni Isus, “Ndaꞌidun siai pegbayaꞌ mu dinaan, saꞌ kanaꞌ laak bigay diniꞌa nu Megbebayaꞌ. Kaas su getaw migwakil dinaan diniꞌa, iini gembagel paduni salaꞌen.” ");
INSERT INTO syb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Benaꞌ midengeg ni Pilato, anguten dun gupia beluyenen si Isus. Dagid mimeksay puliꞌ su nga getaw Judea, laung nilan, “Saꞌ beluyen mu ki getaw kiin, kanaꞌa sugut nu tampusan gadiꞌ si Cesar! Adin su mekpeꞌadiꞌadiꞌ, mingatu iin dini Cesar!” ");
INSERT INTO syb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Sikna midengeg ni Pilato, iwiten puliꞌ diag liu si Isus. Migingkud dayun si Pilato ditu gingkudan pengukuman bitang dia tandaꞌ piningalan dun “Platapurma Batu.” (Piningalan dun di Hinebreo su platapurma kia, “Gabata.”) ");
INSERT INTO syb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Naa su gendaw kia, Birnis, su pengandam dig Lumpuk tug Liniusan. Benaꞌ sungu mektui gendaw, laung ni Pilato tu nga getaw Judea, “Bentayay pa daan niu, kini na ki gadiꞌ niu!” ");
INSERT INTO syb_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Laak dagid mimeksay ilan, laung nilan, “Petain! Petain! Lensangen di kurus!” “Lensangen ku ba su gadiꞌ niu?” sinaak ni Pilato. Simbag nu nga kaunutan nug belian, “Ndaꞌi gadiꞌ nami subay si Cesar.” ");
INSERT INTO syb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Dayun pegwakil ni Pilato si Isus dinilan, puꞌ adun lensangen nilan di kurus. Mendadi, inagak si Isus nu nga sundalu ");
INSERT INTO syb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","lumiu ilan dia syudad, si Isusi mekpisan di kurusen. Saꞌ maꞌnia, midepet ilan dia dapit nu syudad piningalan dun “Tulan Gulu.” (Di Hinebreo, piningalan dun “Golgota.”) ");
INSERT INTO syb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Dia nilan dayun lensangay tu kurus si Isus. Piduma nilan dadema lensangayig duaꞌ tawan, miktimpang di kurus ni Isus su kurus nilan, dia titengaꞌ si Isus. ");
INSERT INTO syb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Mikpesulat dayun si Pilato tuꞌus pidekepen tu kurus, iini sinulat dun, “Kini si Isus, getaw Nazaret, su Gadiꞌ nu nga getaw Judea.” ");
INSERT INTO syb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Melaun getaw Judea mikebasa dun, puꞌ mesempel tu syudad sug linsangan dini Isus. Mukaꞌ ki tuꞌus kia, misulat di Hinebreo mukaꞌ dig Linatin sampay di Ginerecia. ");
INSERT INTO syb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Naa ki nga kaunutan nug belian nu getaw Judea, kaliꞌ ilan pektaluꞌ dini Pilato, “Ndiꞌ mu sia pesulat ‘Kini su Gadiꞌ nu nga getaw Judea.’ Melengas sia iini pesulat mu, ‘Laung nu getaw kini, naan, laung, su Gadiꞌ nu nga getaw Judea.’” ");
INSERT INTO syb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Kaliꞌ sembag si Pilato, “Ki pisulatu, ndiꞌ pelinen.” ");
INSERT INTO syb_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Benaꞌ milansang nilan na tu kurus si Isus, inalap nu nga sundalu su nga penepetenen. Pikilas nilan paat ilasan, piksailas dinilan. Inalap dadema nilan su melambung suuben. Kagina ndaꞌi tinaiꞌanen puꞌ tinibuuki kabel dun, ");
INSERT INTO syb_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","laung nilan, “Ndiꞌ ta gediten, pekteliin ta, saꞌ adin dun dinitai mekalap dun.” Kinii mipenggulaula adun menuud su sinulat dengantu ditu Misulat Taluꞌ nu Megbebayaꞌ, laung, “Pikilas nilan su nga penepeten ku, mukaꞌ su melambung suubu, piktali nilan.” Naa maꞌantu dademai binaal nu nga sundalu kia. ");
INSERT INTO syb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Naa pegindeg dia mesempel nu kurus ni Isus su ginaꞌen mukaꞌ su pated nu ginaꞌen libun, sampay si Maria sawa ni Cleofas, kepaaten si Maria Magdalena. ");
INSERT INTO syb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Naa benaꞌ minitaꞌ ni Isus pegindeg dia su ginaꞌen mukaꞌ su sakupen kiin su petailenen gupia, laungen tu ginaꞌen, “Libun, bentayay mu pa daan, kini naig bataꞌ mu.” ");
INSERT INTO syb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Mukaꞌ laungen tu sakupen kia, “Bentayay mu pa daan, kini nai ginaꞌ mu.” Kaas genat itu, piuliꞌ na nu sakupen kia su ginaꞌ ni Isus diag balayen. ");
INSERT INTO syb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Tubus itu, misuunan ni Isus puꞌ mitubus na su kelaun mpenggulaula. Mendadi adun megelaꞌ gupia menuud su sinulat dengantu ditu Misulat Taluꞌ nu Megbebayaꞌ mekatag diniin, laungen, “Kuaunu.” ");
INSERT INTO syb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Naa duunig yaꞌung dia, mipenuꞌ penginumen. Inulem dun dayuni maaꞌ palas napes, tinangen di gayu sigbet, pisangal dayun tug babaꞌ ni Isus. ");
INSERT INTO syb_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Mendadi si Isus, benaꞌ mitubus megeksep di penginumen kia, miktaluꞌ, “Naa, mitubus na!” Migdungguꞌ dayun, mukaꞌ migetusi ginaanen. ");
INSERT INTO syb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Mendadi inubug nu nga kaunutan nu nga getaw Judea dini Pilato, beliꞌen nilan su geksud nu ngag linansang kia adun matay ilan ganam, puꞌ adun egwaten ilan dayun dia nga kurus. Puꞌ su gendaw kia, Birnis, pengandam di Gendaw Pelali nilan, ndiꞌ pia saꞌ duunig bangkay mbilin di nga kurus di Gendaw Pelali kia, puꞌ pegbesaan gupia gendaw. ");
INSERT INTO syb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Saꞌ maꞌnia, minangay su nga sundalu megbaliꞌ di geksud nug bekna getaw linansang di gupid ni Isus, dayun sug dumanen. ");
INSERT INTO syb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Laak benaꞌ mikpesempel ilan dini Isus, minitaꞌ nilan puꞌ minatay na, kaas ndaꞌ nilan iin beliꞌay geksud. ");
INSERT INTO syb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Laak dagid sala tawan sundalu, tinugdaꞌanen telawan su gilid ni Isus. Mibugyag dayun di gilidenig duguꞌ mukaꞌ tubig. ");
INSERT INTO syb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Naa su mikaitaꞌ dun gupia kini, iini migukit dun, adun metuudan amu dun. Ki takesiꞌen kini, minget metuud, pinanteken puꞌ metuud.) ");
INSERT INTO syb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Maꞌantui mipenggulaula, adun menuud su sinulat dengantu ditu Misulat Taluꞌ nu Megbebayaꞌ, laung, “Ndaꞌig bekegen mbaliꞌ, pia salabuuk.” ");
INSERT INTO syb_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Mukaꞌ duun paduni sala sinulat dun, laung, “Pegenlengan nilan su tinugdaꞌan nilan.” ");
INSERT INTO syb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Mendadi tubus itu si Jose, getaw dig lunsud Arimatea, inubugen dini Pilato, elapenen sug bangkay ni Isus. (Si Jose, sakup ni Isus, laak melegludi kesakupen, puꞌ mendek tu nga kaunutan nu getaw Judea.) Sinanguꞌ dadema ni Pilato. Naa saꞌ maꞌnia, inangay dayun ni Jose egwatay dia kurus sug bangkay ni Isus. ");
INSERT INTO syb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Naa si Nicodemo, su Pariseo kiin kuminitaꞌ begudiin dini Isus gebii, migdunut dini Jose, peguit si Nicodemo lima puluꞌ kilui piglamug pagemut piningalan dun mira mukaꞌ aloe. ");
INSERT INTO syb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Mendadi benaꞌ miagwat nilan duaꞌ sug bangkay ni Isus, pinutus nilan dayun di penepeten gemputiꞌ pidumanan pagemut, puꞌ iinig betad nu getaw Judea saꞌ meglebeng ilan. ");
INSERT INTO syb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Naa duuni pegimulanan gayu dia mesempel tug linsangan dini Isus, duuni sangyab dia begu luakay, ki ndaꞌ mainsan melebengay getaw. ");
INSERT INTO syb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Naa kagina mitaang di pengandam di Gendaw Pelali nu getaw Judea, linagut nilan lebengay sug bangkay ni Isus dia sangyab kia, puꞌ mesempel da dia. ");
INSERT INTO syb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Mendadi benaꞌ sikna siselem di gendaw Duminggu, si Maria Magdalena, milapus mangay ditu sangyab, medelemdelem pa. Mendadi benaꞌ minateng si Maria, iini minitaꞌen, su gembagel batu tinakep tu sangyab, masiꞌ inawaꞌ na dia. ");
INSERT INTO syb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Gumibek dayun si Maria, linaawanen si Simon Pedro mukaꞌ su sala tawan sakup kiin ni Isus, su petailenen gupia. Kaliꞌ pektaluꞌ dinilan si Maria, “Inawaꞌ nilan tug lebengen su Kaunutan! Ndaꞌ nami suunay saꞌ adin nilan bitang!” ");
INSERT INTO syb_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Sikna midengeg ni Pedro mukaꞌ su sala tawan sakup kia, miditu ilan dema sangyab. ");
INSERT INTO syb_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Minggebek ilan duaꞌ, laak su sala tawan sakup, miunananen si Pedro, iini miuna dateng diag lebeng. ");
INSERT INTO syb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Benaꞌ midepet dia sangyab, migdungguꞌ mekselip diag dialem, minitaꞌen dia su penepeten kamun pinutus dig bangkay ni Isus. ");
INSERT INTO syb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Laak ndaꞌen suutay su sangyab. Mikelendug si Pedro, suminuut dayun diag dialem sangyab. Minitaꞌen dayun dia su penepeten gemputiꞌ, ");
INSERT INTO syb_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","mukaꞌ ki tulapuk kamun pinutus tu gulu ni Isus, dia da pagid, laak ndaꞌ melamug dia, mipain da melulun. ");
INSERT INTO syb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Miglendug dayun suled su sala tawan sakup kia, su miuna dateng dia sangyab. Benaꞌ minitaꞌeni kebetang nu penepeten, mituudan dun dayun. ");
INSERT INTO syb_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Puꞌ kiin, ndaꞌ gusay mesabut nu nga sakup ni Isus kia su sinulat dengantu ditu Misulat Taluꞌ nu Megbebayaꞌ puꞌ subay metubuꞌ puliꞌ iin.) ");
INSERT INTO syb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Mendadi, minuliꞌ dayun sug duaꞌ tawan kia sakup ni Isus. ");
INSERT INTO syb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Naa si Maria kia, pegindeg diag liu nu sangyab, luminalek. Mendadi selianen lumalek, migdungguꞌ mekselip diag dialem sangyab. ");
INSERT INTO syb_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Minitaꞌen masiꞌ diag dialem duaꞌ tawan sesuguꞌen nu Megbebayaꞌ getaw langit mikseluk gemputiꞌ, pegingkud ilan dia tandaꞌ bililidan dini Isus. Sala tawan, dia dapit gulunanen, sala tawan di sikwayanen. ");
INSERT INTO syb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Kaliꞌ ilan pektaluꞌ, “Libun, taꞌ mai mingaduya dun?” Kaliꞌ sembag, “Duuni migalap tug bangkay nu Kaunutan ku, mukaꞌ ndaꞌu suunay saꞌ adin bitang!” ");
INSERT INTO syb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Sikna mitaluꞌ ni Maria, luminingay. Minitaꞌen dayun, si Isus, pegindeg dia gupiden. Laak ndaꞌen mailala. ");
INSERT INTO syb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Sinabi ni Isus, “Libun, taꞌ mai mingaduya dun? Taꞌ taway duni penengaun mu?” Laung dun dayun ni Maria, kia su megingat tu pegimulanan gayu kia. Laungen diniin, “Naa Sir, saꞌ yaꞌai migawaꞌ dun dini, pesuun mu dinaan saꞌ adin mu bitang, adun engain ku.” ");
INSERT INTO syb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","“Maria!” laung ni Isus. Sikna midengegen, minadap diniin, mitaluꞌen di Hinebreo, “Rabboni!” (Guluganen, “Mekpetuꞌun.”) ");
INSERT INTO syb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","“Ndiꞌ mau peguiday,” laung ni Isus. “Puꞌ ndaꞌ pau kelentu puliꞌ ditu Gamaꞌu. Naa, angaya ditu nga kepetedan ku, taluꞌ mu dinilan puꞌ luntuu puliꞌ ditu Gamaꞌu, ki Gamaꞌ nilan dema, ditu Megbebayaꞌ pektemuyen ku, ki pektemuyen nilan dema.” ");
INSERT INTO syb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Linaawan dayun ni Maria su nga sakupen, inukiten dinilan puꞌ minitaꞌen su Kaunutan, mukaꞌ pitendayen dema dinilan ki pimuun kia ni Isus diniin. ");
INSERT INTO syb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Naa benaꞌ gebii kia di gendaw Duminggu, mabuꞌ duun nai tulug bataꞌ, su nga sakup ni Isus, mipungun ilan dia salabuuk balay, piksibaꞌan nilan tekepay sug balay, puꞌ mindek ilan tu nga kaunutan nu getaw Judea. Mendadi, mitekaw metuaꞌ si Isus, suminaing dinilan megindeg. Kaliꞌ pektaluꞌ, “Naa, gempiai ginaa niu.” ");
INSERT INTO syb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Mitubusen teluꞌay, pinitaꞌen dinilan ki kemeten mukaꞌ giliden. Mipatiꞌ ilan leliagay sabaꞌ minitaꞌ nilan su Kaunutan. ");
INSERT INTO syb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kaliꞌ puliꞌ pektaluꞌ si Isus dinilan, “Gempiai ginaa niu. Mendadi, suguꞌen ku amu mangay megukit, maaꞌ nu kesuguꞌ dinaan nu Gamaꞌu.” ");
INSERT INTO syb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Sikna mitaluꞌen, pisengawanen ilan ginaa, dunut mektaluꞌ, “Tabuk niu ini Balakat nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mendadi yamu, adin su getaw pedesunen niui salaꞌen, mpedasun tuꞌu. Mukaꞌ adin su getaw ndiꞌ niu pedesuneni salaꞌen, ndiꞌ dema mpedasun.” ");
INSERT INTO syb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Naa sala tawan di nga sepuluꞌ buꞌ duaꞌ tawan sakup ni Isus, si Tomas (piningalan dun su Gapid), ndaꞌ kedunut dinilan su ketuaꞌ ni Isus dinilan kia. ");
INSERT INTO syb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Mendadi inukitan nu nga samasakupen si Tomas, laung nilan, “Minitaꞌ nami su Kaunutan!” Kaliꞌ sembag si Tomas, “Naan, ndiꞌu metuudan dun, subay maitaꞌu pa ki paliꞌ nug lansang dia kemeten mukaꞌ mpulegu, sampay mpulegu ki giliden.” ");
INSERT INTO syb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Naa tubus itu benaꞌ walu gebii na, mipungun puliꞌ su nga sakup ni Isus dig dialem balay, minampuꞌ dinilan si Tomas. Mendadi, tinakep puliꞌ sug balay, laak pia maꞌantu, mitekaw na pelum metuaꞌ si Isus, suminaing mindeg dinilan, laungen, “Naa, gempiai ginaa niu.” ");
INSERT INTO syb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Laung dayun ni Isus dini Tomas, “Bentayay mu pa daan ki kemetu kini, puleg mu tenduꞌ mu. Mukaꞌ tenggal mui kemet mu, puleg mui gilidu. Ndiꞌ mu dega pegduaꞌduaꞌayig delendeman mu dinaan, petuuda dinaan!” ");
INSERT INTO syb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Simbag ni Tomas diniin, “Yaꞌai Kaunutan ku, yaꞌai Megbebayaꞌ pektemuyen ku!” ");
INSERT INTO syb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Laung dayun ni Isus, “Mituudan ka ba dinaan sabaꞌ minitaꞌ mau? Labi na leliagen ki nga getaw ndaꞌ mekaitaꞌ dinaan, laak mukaꞌ mituudan ilan dinaan!” ");
INSERT INTO syb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Naa, melaun pai tuꞌus pinggulaula ni Isus di gedapan nu nga sakupen, laak ndaꞌ mesulat dig libru kini. ");
INSERT INTO syb_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Laak su gikteben kini, sinulat adun metuudan amu dun puꞌ si Isus su Tinduꞌ nu Megbebayaꞌ Meglekaunutan, sug Bataꞌ nu Megbebayaꞌ. Puꞌ saꞌ metuudan amu dun, naa mpeduma amu tu ketubuꞌ ndaꞌi tamanen meksekat tu pegbayaꞌen. ");
INSERT INTO syb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Genat itu, si Isus, mikpaitaꞌ na pelum di nga sakupen diag Linaw Tiberias. Kiniig bian nu mipenggulaula. ");
INSERT INTO syb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Si Simon Pedro, si Tomas (piningalan dun su Gapid), si Natanael (getaw Cana sakup Galilea), sug duaꞌ tawan bataꞌ ni Sebedeo, mukaꞌ duaꞌ tawan pai sakup, mipungun ilan dia geksid linaw. ");
INSERT INTO syb_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Mendadi laung ni Simon Pedro tu ngag dumanen, “Naan, menegutusu.” “Megdunut ami diniꞌa,” laung nu ngag dumanen. Luminulan ilan dayun di sekayan. Piglegendawan ilan dayun memaling, ndaꞌ ilan tanan mekelaam. ");
INSERT INTO syb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Benaꞌ dumilag na, pegindeg si Isus dia geksid linaw, laak ndaꞌ mailala nu nga sakupen kia. ");
INSERT INTO syb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Kaliꞌ tawag si Isus, “Naa lai, mikelaam damu?” “Baa, ndaꞌ,” simbag nilan. ");
INSERT INTO syb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kaliꞌ pektaluꞌ si Isus, “Dia niu ektakayig baling niu dapit lintu nu sekayan niu kia. Mekelaam amu dayun.” Iktak nilan tuꞌu sug baling, dayun ndaꞌ nilan megaga betunay puliꞌ, sabaꞌ kelaun sedaꞌ milaam nilan. ");
INSERT INTO syb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Naa sala tawan dinilan, ki sakup ni Isus kiin petailenen gupia, kaliꞌ pektaluꞌ dini Pedro, “Su Kaunutan maia!” Sikna midengeg ni Pedro puꞌ su Kaunutan si Isus, mikseluk dayun suuben (puꞌ migluas suub kamun), suminampak dayun dia tubig, luminanguy. ");
INSERT INTO syb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Su ngag dumanen, suminakay ilan dema pangay dia geksid, pegbintengen nilan sug baling mipenuꞌ sedaꞌ. Mesempel dailan di geksid, mabuꞌ lima puluꞌ depa saanig layuꞌen. ");
INSERT INTO syb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Benaꞌ mikekawas ilan tu geksid, minitaꞌ nilani guklak musing, duuni sedaꞌ tinitiꞌ mukaꞌ duun dademai pan dia. ");
INSERT INTO syb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Laung ni Isus dinilan, “Uit niu dinii santaꞌ buuk di sedaꞌ kia milaam niu.” ");
INSERT INTO syb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Mendadi duminangan puliꞌ si Simon Pedro tu sekayan, biniglasen dayun di pentadan sug baling, mipenuꞌ mekebagel sedaꞌ, megatus buꞌ lima puluꞌ buꞌ telu buukig launen. Laak pia maꞌantu, ndaꞌ peglegetus sug baling. ");
INSERT INTO syb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Laung dayun ni Isus dinilan, “Pedini amu, maan naita.” Naa, ndaꞌiduni mikakuꞌ sumaak diniin saꞌ taꞌ taway dun iin, puꞌ misuunan nilan iin su Kaunutan. ");
INSERT INTO syb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Mendadi, inimud ni Isus su pan, dayunen pentulunay dinilan. Maꞌantu dadema su sedaꞌ. ");
INSERT INTO syb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Kiai ketelunen mekpaitaꞌ si Isus di nga sakupen genat tu kepetubuꞌ puliꞌ diniin. ");
INSERT INTO syb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Naa benaꞌ mitubus ilan maan, sinaak ni Isus dini Simon Pedro, “Uu Simon, bataꞌa ni Juan, petailen mau ba, labi pa di kepetail dinaan nu ngag duma mu kini?” “Waꞌa, Kaunutan,” simbag ni Pedro, “suunan mu puꞌ petailen ku yaꞌa.” Kaliꞌ pektaluꞌ si Isus, “Naa saꞌ maꞌantu, tagikul mu ki nga maaꞌ nu nati karniruu.” ");
INSERT INTO syb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Sinaak puliꞌ ni Isus, “Simon, bataꞌa ni Juan, petailen mau ba?” “Waꞌa, Kaunutan,” simbagen puliꞌ, “suunan mu puꞌ petailen ku yaꞌa.” Kaliꞌ puliꞌ pektaluꞌ si Isus, “Naa, ingat mu su nga karniruu.” ");
INSERT INTO syb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ketelu deksuꞌen na sumaak si Isus, laungen, “Simon, bataꞌa ni Juan, petailen mau ba?” Sikna midengeg ni Simon Pedro su ketelunen sumaak, “Petailen mau ba?” milegenan dun. Laung ni Pedro, “Uu Kaunutan, misuunan mu sug launanen, kaas suunan mu puꞌ petailen ku yaꞌa!” Kaliꞌ pektaluꞌ si Isus diniin, “Tagikul mu daan su nga karniruu. ");
INSERT INTO syb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mukaꞌ taman taluꞌu diniꞌa, su begu getawa pa, mimakesa, dayun pia adini mauyaꞌan mu gengayan mu, medituun ka dayun. Laak dagid saꞌ megulanga na, subay tenggalen muig baingken mu, adun mbaluda nug lain getaw, dayun ka egakay tu kanaꞌ mu mauyaꞌan gengayan.” ");
INSERT INTO syb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Naa ki tinaluꞌ kia ni Isus, pisuunen diniin kig bian nu kepatay ni Pedro, adun megleepig dengegan nu Megbebayaꞌ.) Laung ni Isus dini Pedro, “Naa, dunuta dinaan!” ");
INSERT INTO syb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Naa kini si Pedro, miglingay, minitaꞌen dayun meglendug ki sakup kia ni Isus su petailenen gupia, su pegingkud dia gupid ni Isus su pingaanan nilan nu gebii kiin mukaꞌ sinaaken, “Uu Kaunutan, taꞌ taway duni tumipu pa diniꞌa?” ");
INSERT INTO syb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Sikna minitaꞌ ni Pedro ki sala tawan sakup kia, sinaaken dini Isus, “Naa Kaunutan, ki getaw kia, taꞌi mpenggulaulanen?” ");
INSERT INTO syb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Kaliꞌ sembag si Isus dini Pedro, “Saꞌ mauyaꞌan ku puꞌ metubuꞌ iin sampay matengu puliꞌ, naa taꞌ maig labet mu dun? Yaꞌa, dunuta dinaan!” ");
INSERT INTO syb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Mendadi duun dayuni gukiten mipelak tu nga sakup ni Isus, ndiꞌ daw matay ki sakupen kia. Laak dagid ndaꞌ metaluꞌ ni Isus puꞌ ndiꞌ matay. Iini tinaluꞌen, “Saꞌ mauyaꞌan ku puꞌ metubuꞌ iin sampay matengu puliꞌ, naa yaꞌa, taꞌ maig labet mu dun?” ");
INSERT INTO syb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Naa su sakupen kia, iinen iin su suminulat dun ini, mukaꞌ piglegintuuden sug launan mipenggulaula. Misuunan ta puꞌ metuudi pingukiten. ");
INSERT INTO syb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Naa melaun pa pinggulaula ni Isus. Saꞌ sia gelaꞌen sulatay, mabuꞌ ndiꞌ megelaꞌ dig dibabaw lumbang ki ngag libru mesulat.");
INSERT INTO syb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Diniꞌa, pegbesaan Teofilo, ki sinulat kini, genat dini Lucas. Naa sug bekna sinulatu kitu diniꞌa, iini miukit dun su kelaunan pinggulaula ni Isus mukaꞌ pituluꞌen ");
INSERT INTO syb_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","sampay di gendaw nu kepelentu diniin nu Megbebayaꞌ ditu gekbus langit. Mendadi kini si Isus, su ndaꞌ pa pelentu ditug langit, pimituluꞌanen su nga pimiliꞌen peneliganen. Su pituluꞌen dinilan kia, miksekat di ginuung nug Balakat nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Naa genat di kepatayen gikteb di paat puluꞌ gebii, melaun gupia pituꞌusen di nga peneliganen kia puꞌ mitubuꞌ puliꞌig lawasen. Miduaꞌ mata nilan si Isus, mukaꞌ pingukitanen ilan mekatag di Keglekaunutan nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Mendadi, su selian ni Isus dumuma pa di nga peneliganen kia, tinituluꞌanen ilan, laungen, “Ndiꞌ amu pa pegawaꞌ dini Jerusalem, pegelatay pa niu mateng su tinaluꞌu diniu kiin, su tulung pinasad nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Puꞌ kiin, misuunan niu puꞌ si Juan kitu, migbunag laak tubig diniu. Mendadi ndiꞌ maiben, maꞌniin bunagan amu peluman, puꞌ mengapuꞌ diniu kig Balakat nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Naa duuni gendaw mikpungun na pelum ditu ni Isus su nga peneliganen. Kaliꞌ ilan saak diniin, “Sir, nemun ini ki ketindeg mu dig bansa ta Israel su Keglekaunutan?” ");
INSERT INTO syb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Kaliꞌ pektaluꞌ si Isus, “Su Gamaꞌu laak, iini suunanen su gendaw nu kelaun mpenggulaula, puꞌ iini megbayaꞌ dun. Yamu, ndiꞌ niu mesuunan. ");
INSERT INTO syb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Laak dagid saꞌ mengapuꞌ na diniu kig Balakat nu Megbebayaꞌ, begayan amu niin ginuung. Tumakesiꞌ amu dayun dinaan. Tumakesiꞌ amu dini Jerusalem mukaꞌ di tibuuk Judea, tu Samaria, sampay tu tibuuk lumbang.” ");
INSERT INTO syb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Benaꞌ mideksuꞌen teluꞌay, pilentu na dayun si Isus ditu gekbus langit. Saanan megbantay su nga peneliganen, milinged na gabun si Isus, ndiꞌ na nilan dayun maitaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Mendadi selian nu nga peneligan ni Isus megangag ditug langit, mitekaw duunig duaꞌ tawan pegindeg dia gupid nilan, gemputiꞌi penepeten nilan. ");
INSERT INTO syb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Laung nug duaꞌ tawan kia, “Yamu nga getaw Galilea, mauma dema amu mimegangag tug langit? Si Isus kiin, mpuliꞌ da dini. Adin su kelentunen minitaꞌ niu kini, maꞌantu dadema ki kelusaden puliꞌ.” ");
INSERT INTO syb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tubus itu, minuliꞌ ditu Jerusalem su nga peneligan ni Isus genat ditug Bentud nu nga Gayu Olibo. Su pekilayuꞌ nug bentud kia mukaꞌ su Jerusalem, sala kilumitru. ");
INSERT INTO syb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Benaꞌ minateng su nga peneliganen tug balay pektulugan nilan, minaik ilan dayun tu sugud nilan diag ditaas. Ilan si nga Pedro, si Juan, si Santiago, si Andres, si Felipe, si Tomas, si Bartolome, si Mateo, si Santiago bataꞌ ni Alfeo, si Simon su piningalan dun Gembeluꞌ Megukit, mukaꞌ si Judas bataꞌ nu sala Santiago. ");
INSERT INTO syb_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Sug launan nilan kia, miksalabuuk ilan menamal menenabi. Duminuma dadema dinilan su ngag libun kampuꞌ ni Maria su ginaꞌ ni Isus, sampay su nga pated ni Isus. ");
INSERT INTO syb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Naa ndaꞌ maiben, duuni gendaw mikpungun puliꞌ su nga mikpetuud dini Isus kia, duun saani megatus buꞌ duaꞌ puluꞌ tawan ilan. Mendadi migindeg si Pedro, kaliꞌ pektaluꞌ dinilan, ");
INSERT INTO syb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Yamu nga kepetedan ku, subay minuud ki pisulat nug Balakat nu Megbebayaꞌ dini David dengantu ditu Misulat Taluꞌ nu Megbebayaꞌ mekatag dini Judas, su minunut tu nga getaw duminaap dini Isus. ");
INSERT INTO syb_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Begudiin si Judas kiin, duma ta di pikumpungan ta, mukaꞌ pimiliꞌ dadema ni Isus megabang dig baalen ta.” ");
INSERT INTO syb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Puꞌ su tinindan dini Judas ditug limbungen kia, piksaluy dun ni Judas lupaꞌ. Milabuꞌ dayun si Judas diag lupaꞌen kia, migbetui tianen, miliwasagi tinainen. ");
INSERT INTO syb_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Naa ndaꞌ maiben, misuunan nu kelaun getaw dia Jerusalem su mipenggulaula kia ni Judas, kaas piningalan nilan dun sug lupaꞌ kia, Akeldama, guluganen “Lupaꞌ nu Kegbinasa di Getaw.”) ");
INSERT INTO syb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Laung padun ni Pedro, “Puꞌ kiin, duuni misulat ditu pisulat nu Megbebayaꞌ piningalan dun ngag Bebat, maꞌniniꞌ. ‘Belenganig balayen, ndaꞌi pegbenwa dun.’ Mukaꞌ duun pa pagidi misulat, ‘Lain tawan nai sumukli dig baalenen.’ ");
INSERT INTO syb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Naa mendadi,” maaꞌ laung padun ni Pedro, “kagina maꞌantu, subay duunig lain tawan sukli dini Judas. Melengas pemiliꞌen tai sala tawan suminalabuuk na dinita su keduma dinita ni Isus ");
INSERT INTO syb_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","genat di kebunag ni Juan diniin tubig sampay di gendaw nu kepelentu diniin tu gekbus langit. Ki mpemiliꞌ ta, megabang dayun dinita tumakesiꞌ di ketubuꞌ puliꞌ nu Kaunutan ta si Isus.” ");
INSERT INTO syb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Mendadi, pinindeg dayun nu nga peneliganig duaꞌ tawan, si Jose mukaꞌ si Matias. Lain ngalan ni Jose kia, si Barsabas. (Sala pa ngalanen, si Justo.) ");
INSERT INTO syb_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Minenabi dayun si nga Pedro, laung nilan, “Uu Kaunutan Megbebayaꞌ, suunan mu sug delendeman nu tibaꞌan getaw. Saꞌ maꞌantu, paitaꞌ mu dinami ki pimiliꞌ mu sukli dini Judas, saꞌ adin dun dig duaꞌ tawan kini. ");
INSERT INTO syb_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Iin nai mbaal peneligan mu mekesukli di kelaun baalen ni Judas bilengen, puꞌ si Judas kiin, minuliꞌ na ditu guliꞌanen.” ");
INSERT INTO syb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Piktali dayun ni nga Pedro saꞌ taꞌ taway duni mpemiliꞌ dig duaꞌ tawan kia. Iini mipemiliꞌ, si Matias. Iin dayuni mitektub ditu sepuluꞌ buꞌ duaꞌ tawan peneligan ni Isus. ");
INSERT INTO syb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Naa benaꞌ sungu mateng su keglinggwang nug lumpuk nu getaw Judea piningalan dun Pentecostes, mikpungun di salabuuk balay su nga mikpetuud dini Isus. ");
INSERT INTO syb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mendadi benaꞌ migingkud ilan dia, mitekaw nilan medengegi maaꞌ migbegembuti metikteg genus genat tug langit, mileep dia seled balay kia. ");
INSERT INTO syb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Mukaꞌ minitaꞌ nilani maaꞌ ligaꞌ gapuy, mitukid dayun melabuꞌ dinilan. ");
INSERT INTO syb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Dayun ilan pengepuꞌay nug Balakat nu Megbebayaꞌ, launan nilan. Diadia mikektaluꞌ, masiꞌ sala nai pikebitanen, puꞌ miksekat dig Balakat nu Megbebayaꞌ kia. ");
INSERT INTO syb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Naa duuni nga getaw Judea pegbebenwa dia Jerusalem mikpetuud gupia ditu Megbebayaꞌ, genat ilan di kelaun benwa dig dibabaw lumbang. ");
INSERT INTO syb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ilan, benaꞌ midengeg nilan ki gelang diag balay kia, minampuꞌ dailan dema dia. Benaꞌ mikineeg ilan di taluꞌ kia nu nga peneligan, diadia midengegen sug daniin pikebitan, misasaw dayuni ginaa nilan. ");
INSERT INTO syb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Misebuꞌan ilan patiꞌ, laung nilan, “Ki getaw kini mektaluꞌ, lumbus ilan laak getaw Galilea! ");
INSERT INTO syb_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Naa saꞌ maꞌnia, mauma dema ini, midengeg ta dinilanig launan pikebitan ta? ");
INSERT INTO syb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Puꞌ ita, getaw Partia ita, getaw Media, getaw Elam. Duuni getaw genat di Mesopotamia, duuni getaw Judea, getaw Capadocia, getaw Ponto mukaꞌ getaw Asia, ");
INSERT INTO syb_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","getaw Frigia, getaw Panfilia, getaw Ehipto, getaw Libya sakup Cirene, mukaꞌ duuni megbebenwa dini genat tug Roma. ");
INSERT INTO syb_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Duuni getaw Judea tantu mukaꞌ su laak miginetaw na Judea. Duuni getaw Creta mukaꞌ getaw Arabia. Dagid launan ta, medengeg tai nga pikebitan ta kini, pigukit dun nu nga getaw Galilea kini ki nga mekesalebuꞌ gulaula nu Megbebayaꞌ!” ");
INSERT INTO syb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Saꞌ maꞌnia, misebuꞌan ilan lamug milibuleng ilan, kaliꞌ ilan peksinaakay, “Alanduni guluganen ki mipenggulaula kini?” ");
INSERT INTO syb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Laak sug duma getaw, piksudiꞌan nilan su nga mikpetuud dini Isus, laung nilan, “Baa, migbebulek laak ilan!” ");
INSERT INTO syb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Laak dagid si Pedro, migindeg, ilan nu ngag dumanen sepuluꞌ buꞌ sala tawan. Tuminubang si Pedro ditu nga getaw minampuꞌ, minekeg dayun mektaluꞌ, laungen, “Yamu nu nga samau getaw Judea mukaꞌ launan niu migbebenwa dini Jerusalem, talentenay niui taluꞌu kini, puꞌ ulugen ku diniu ki mipenggulaula kini. ");
INSERT INTO syb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ki nga getaw kini, kanaꞌ ilan migbebulek, maaꞌ nug delendeman niu dun, puꞌ ginengaꞌ menaik pa laaki gendaw. ");
INSERT INTO syb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Sinangkaliꞌ ki mipenggulaula kini, iin su kenuud na tuꞌu nu pisulat dengantu nu Megbebayaꞌ ditu Taluꞌen, su sinulat nu pimuunanen si Joel, laungen, ");
INSERT INTO syb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Saꞌ sungu melengkebig benwa,’ maaꞌ laung nu Megbebayaꞌ, ‘pepengapuꞌu kig Balakatu tu kelaun bansa nu getaw. Kaas su nga sumumpat diniu libun laki, ukiten nilan dayun ki pemuun ku dinilan. Su ngag begu getaw, duuni paitaꞌu dinilan mekesalebuꞌ, mukaꞌ su mekegulang, duun dademai peteginepu dinilan.’ ");
INSERT INTO syb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Laung nu Megbebayaꞌ, ‘Metuud ia, su nga sesuguꞌen ku libun laki, pepengapuꞌu dinilan kig Balakatu di gendaw kiin, adun pelaktag nilan su pemuun ku dinilan. ");
INSERT INTO syb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Paitaꞌu demai nga mekesalebuꞌ tuꞌus dig langit mukaꞌ nga mekesalebuꞌ penggulaula dig benwa. Metuaꞌig duguꞌ, mukaꞌ gapuy, buꞌ melabung gebel. ");
INSERT INTO syb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Su gendaw, dulem. Sug bulan, palasen maaꞌ duguꞌ. Tubus itu, mateng ki mekesalebuꞌ Gendaw kiin, su Gendaw nu Kengukumu tu tibaꞌan getaw, naan su Kaunutan Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Mendadi adin su getaw mekpaingabang dinaan nu Kaunutan Megbebayaꞌ, guunen ku iin.’” ");
INSERT INTO syb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Laung padun ni Pedro, “Mendadi yamu nu nga samau getaw Israel, talentenay niui taluꞌu diniu. Kini si Isus, getaw Nazaret, pinilala diniu puꞌ bigayan iin nu Megbebayaꞌ pegbayaꞌ, puꞌ melaun ginuung mukaꞌ tuꞌus pinggulaula nu Kaunutan Megbebayaꞌ pebian diniin. Kia, misuunan niu gupia, puꞌ miduaꞌ mata na niu. ");
INSERT INTO syb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Mendadi si Isus kiin, pibunuꞌ niu di nga kanaꞌ megbasa tu Megbebayaꞌ, pilansang niu di kurus. Laak dagid saꞌ kanaꞌ genat tu Megbebayaꞌ, pia su kedaap niu dun, ndiꞌ niu sia megaga. ");
INSERT INTO syb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Dagid pitubuꞌ puliꞌ nu Megbebayaꞌ si Isus, biluyen di kelegenayen, puꞌ ndiꞌ megdadi mbilin iin di gengkeman nu kepatay. ");
INSERT INTO syb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Maꞌantu dadema su sinulat dengantu ni David mekatag diniin ditu Misulat Taluꞌ nu Megbebayaꞌ, laungen, ‘Tatapu maitaꞌ su Kaunutan di gedapan ku, tatapu niin penendingay, kaas ndiꞌu mendek. ");
INSERT INTO syb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Mendadi gempiai ginau, liliagu gupia. Naan, pia kilawanu, mekpedatengu ndiꞌ melasakig lawasu, ");
INSERT INTO syb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ndiꞌ mu belengen su gimuudu ditug bayaꞌ. Meseligan sesuguꞌen mau, kaas ndiꞌ mu begay melasak diag lebengig lawasu. ");
INSERT INTO syb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Pisuun mu dinaan kig dalan pangay tu ketubuꞌ ndaꞌi tamanen. Ndiꞌ mau na pesuay, kaas liliagu gupia.’” ");
INSERT INTO syb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Laung padun ni Pedro, “Mendadi yamu kepetedan ku, taluꞌu tuꞌu diniu puꞌ ki megdedengeg ginepuꞌay ta si Adiꞌ David, suunan ta puꞌ minatay iin dakus libeng. Su pantiunen, deksuꞌ nemun dia pa, ndaꞌ pa peglaat. ");
INSERT INTO syb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Laak si David kia, pimuunan nu Megbebayaꞌ. Misuunanen su gempagen pinasad nu Megbebayaꞌ diniin puꞌ tenduꞌen nu Megbebayaꞌ ki sala tawan sapuꞌen meglegadiꞌ, maaꞌ ni David kia. ");
INSERT INTO syb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Mendadi misuunan ni David ki penggulaulaan nu Megbebayaꞌ dig binayaꞌ gebii buꞌ gendaw. Kaas suminulat si David mekatag di ketubuꞌ puliꞌ nu Tinduꞌ nu Megbebayaꞌ Meglekaunutan, laungen, ‘Ndaꞌ belengay ditug bayaꞌ su gimuuden, mukaꞌ ndaꞌ melasak diag lebengig lawasen.’” ");
INSERT INTO syb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Laung padun ni Pedro, “Naa si Isus kiin, pitubuꞌ puliꞌ nu Megbebayaꞌ. Launan nami kini, miketakesiꞌ ami gupia di ketubuꞌen puliꞌ. ");
INSERT INTO syb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Mendadi, pilentu na si Isus tu gupid nu Gamaꞌen Megbebayaꞌ ditu gekbus langit, di dapit lintunen. Pipengapuꞌ dun nu Gamaꞌen Megbebayaꞌ sug Balakaten, maaꞌ dadema nu pinasaden. Mendadi adin su minitaꞌ niu dini nandaw mukaꞌ ki midengeg niu, iin su tinulung dinami nug Balakat nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","“Laak suunan ta puꞌ si David, kanaꞌ iini lumintu kia ditu gekbus langit. Puꞌ si David, iin sungkini suminulat dun maꞌniniꞌ, ‘Tinaluꞌ nu Kaunutan Megbebayaꞌ ditu Kaunutan ku, Pegingkuda dini gupidu, dini dapit lintuu, ");
INSERT INTO syb_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","sampay di gendaw pelebaun ku yaꞌa daagen mu su nga kuntra mu.’” ");
INSERT INTO syb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Diksuꞌ ni Pedro, “Mendadi pesuun ku dema tuꞌu diniu nga samau getaw Israel, kini si Isus, sug linansang niu di kurus, iin tuꞌui su gilal nu Megbebayaꞌ Tinduꞌen Meglekaunutan, mukaꞌ gilalen dadema su Kaunutan!” ");
INSERT INTO syb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Naa benaꞌ midengeg nu nga getaw minampuꞌ dia su tinaluꞌ kia ni Pedro, milegenan ilan patiꞌ. Sinaak nilan dini nga Pedro, “Plii lai, mekendutaꞌ nami dun?” ");
INSERT INTO syb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Kaliꞌ sembag si Pedro dinilan, “Saladuaꞌ diniu, subay meksikesuun amu, mukaꞌ mekpebunag amu tubig tuꞌus di kesakup niu dini Isukristu, adun pedesunen su salaꞌ niu. Begay dayun diniu, pengepuꞌan amu nug Balakat nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Puꞌ pinasad nu Megbebayaꞌ, pengepuꞌan amu nug Balakaten mukaꞌ pengepuꞌanen dadema su nga gembataꞌ niu, sampay su nga melayuꞌ getaw, pia adini ginggat nu Kaunutan ta Megbebayaꞌ sumakup diniin.” ");
INSERT INTO syb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Naa melaun pai tinaluꞌ ni Pedro ditu nga getaw mipungun dia. Tinituluꞌanen ilan, laungen, “Pekpesuay amu tu nga melaat getaw nemun, puꞌ adun ndiꞌ amu mpeduma di ginukuman dinilan!” ");
INSERT INTO syb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Naa su nga mikpetuud ditu taluꞌ ni Pedro, mikpebunag ilan dayun tubig. Su gendaw kia, duun saani telu ngibu tawan midugang ditu pikumpungan nu nga sakup ni Isus. ");
INSERT INTO syb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Minamal ilan dayun mektuꞌun, pituꞌunan ilan nu nga peneligan ni Isus, suminalabuuk dailan dema dinilan. Dumingan ilan maan ditug lebungan gindan tu kepatay ni Isus, mukaꞌ migduma dailan dema menenabi. ");
INSERT INTO syb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Naa melaun ginuung mukaꞌ mekesalebuꞌ tuꞌus pinggulaula nu nga peneligan ni Isus. Misebuꞌan dun patiꞌ sug launan getaw. ");
INSERT INTO syb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ki ngag launan mikpetuud, miksalabuuk ilan gupia, mukaꞌ adin sug duuni sukaten, migbegay ditu ndaꞌig daniin. ");
INSERT INTO syb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Su ngag duma, piksaluyenig lupaꞌen mukaꞌ pimetangen, dayunen begayay dun su gendaꞌi kwartanen, bigayen duni sukal diniin. ");
INSERT INTO syb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Gendawgendaw mikpungun ilan ditug Balay Pengedapan tu Megbebayaꞌ, mukaꞌ dia ngag balay nilan, dumingan dailan dema maan ditug lebungan gindan tu kepatay ni Isus. Pikilas nilan dema su nga gaan nilan, mukaꞌ gempia gupiai ginaa nilan. ");
INSERT INTO syb_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Inal nilan su Megbebayaꞌ, mukaꞌ pigbesaan ilan pagid nu nga kelaun getaw. Mukaꞌ gendawgendaw, adin su migawen nu Kaunutan Megbebayaꞌ, midugang di pikumpungan nu nga mikpetuud. ");
INSERT INTO syb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Naa duuni gendaw si Pedro mukaꞌ si Juan, pegangay ilan ditug Balay Pengedapan tu Megbebayaꞌ, puꞌ betad nilan mangay ilan menenabi saꞌ meginengaꞌ menaugi gendaw. ");
INSERT INTO syb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Naa dia gengaꞌan nu Pengedapan piningalan dun su Melengas Gengaꞌan, duuni getaw pilung, mipilung sikna mbataꞌen. Ki pilung kini, gendawgendaw pegbuligan nu ngag dumanen dia mesempel gengaꞌan nu Pengedapan kia, adun menengi limus ditu nga getaw suled dia. ");
INSERT INTO syb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Naa mendadi ki pilung kia, benaꞌ minitaꞌen si Pedro mukaꞌ si Juan sungu suled dia, minengi dayun limus dinilan. ");
INSERT INTO syb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pingenlengan ni Pedro mukaꞌ ni Juan, laung dayun ni Pedro, “Pegbentayay mu ami!” ");
INSERT INTO syb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Migbantay dinilan su pilung, puꞌ laungen dun, begayan. ");
INSERT INTO syb_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Laak dagid kaliꞌ pektaluꞌ si Pedro, “Naa ndaꞌiduni kwartau bulawan atawaka pelata, dagid adin sug duun dinaan, iinig begayu diniꞌa. Miksekat di pegbayaꞌ ni Isukristu su getaw Nazaret, taluꞌu diniꞌa, panawa!” ");
INSERT INTO syb_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Piguidan ni Pedro ki pilung kini dig lintu kemeten, biwaten dayun. Tekaw mipeduunan sekegi geksuden. ");
INSERT INTO syb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Mikpalintuk dayun ki pilung, mikepanawpanaw na. Migdunut dayun dini Pedro mukaꞌ dini Juan suled tu Pengedapan tu Megbebayaꞌ, migleksuleksu mukaꞌ migenal tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Naa su ngag launan getaw dia, minitaꞌ nilan su kamun pilung, mikepanaw na, dunut inalen su Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Benaꞌ miꞌilala nilan puꞌ iin su migingkud menengi limus ditu Melengas Gengaꞌan, mipatiꞌ ilan mesebuꞌay ditu mipenggulaula diniin. ");
INSERT INTO syb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Naa dia Pengedapan tu Megbebayaꞌ, duuni sala balay piningalan dun nu getaw su silungen, Silung ni Salomon. Naa dia Silung ni Salomon kia, su kamun pilung, ginapusen si Pedro mukaꞌ si Juan. Migdedaliꞌ dayun mekpungun dia su nga getaw. ");
INSERT INTO syb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Mendadi si Pedro, benaꞌ minitaꞌen su nga getaw mipungun, laungen dinilan, “Yamu nu nga getaw Israel, mauma dema misebuꞌan amu di mipenggulaula kini? Mauma pelum penentengan niu ami? Laung niu dun ba, mekepanaw nai getaw kini miksekat di ginuung nami atawaka su kepagen nu kekpetuud nami? ");
INSERT INTO syb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Su Megbebayaꞌ, su piktamuy nu ginepuꞌay ta si Abraham, si Isaac, mukaꞌ si Jacob, puun diniin migleep sug dengegan nu Sesuguꞌenen si Isus. Laak dagid kini si Isus, pigwakil niu ditu gubirnadur si Pilato, dayun niu pemelaway ditu gedapan nu gubirnadur. Pia beluyen sia ni Pilato, tigel niu si Pilato, ndiꞌen beluyen. ");
INSERT INTO syb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Pimilas niu si Isus, ki mekesuun mukaꞌ leliagen dun su Megbebayaꞌ, puꞌ inubug niu dini Pilato, beluyeneni memunuꞌan, sabayaꞌ ni Isus. ");
INSERT INTO syb_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Su puun nu ketubuꞌ, pinatay niu. Dagid pitubuꞌ puliꞌ iin nu Megbebayaꞌ. Yami kini, miketakesiꞌ ami dun. ");
INSERT INTO syb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Mendadi si Isus kia, miksekat di pegbayaꞌeni sekeg nu pilung kini minitaꞌ niu. Miuliꞌani getaw kini miksekat di kesalig nami dini Isus. Miduaꞌ mata na niu nandaw, launan niu.” ");
INSERT INTO syb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Kaliꞌ padun pektaluꞌ si Pedro, “Mendadi, yamu nu kepetedan ku, suunan ku puꞌ su kekpatay niu dini Isus, yamu nu nga kaunutan niu, ndaꞌ niu mesuunay saꞌ taꞌ alanduni gasalen. ");
INSERT INTO syb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Laak minuud dun su pisulat dengantu nu Megbebayaꞌ ditu Taluꞌen, su sinulat nug launan pimuunanen puꞌ ki Tinduꞌen Meglekaunutan, subay mayan dig lesayan. ");
INSERT INTO syb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kaas peksikesuun amu, lingay amu ditu Megbebayaꞌ, adun ugasanen su nga salaꞌ niu. ");
INSERT INTO syb_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Saꞌ meksikesuun amu, tatap dayun pepianay nu Kaunutan Megbebayaꞌi ginaa niu, mukaꞌ pelusadenen su Tinduꞌen Meglekaunutan si Isus, su gandang pimiliꞌen megabang diniu. ");
INSERT INTO syb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Laak dagid subay pegelatan pa ni Isus ditu gekbus langit su gendaw pegupianan nu Megbebayaꞌ su gekleb langit buꞌ lupaꞌ, ki pisuun nu Megbebayaꞌ dengantu pebian di nga pimiliꞌen pimuunanen. ");
INSERT INTO syb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Puꞌ sinulat ni Moises, laungen, ‘Suguꞌen nu Kaunutan Megbebayaꞌ diniu ki pemuunanen maaꞌ dinaan, ki samataw ta dig bansa ta. Ki pemuunanen kia, adin su teluꞌenen, talentenay niu. ");
INSERT INTO syb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Adin su ndiꞌ mektalenten diniin, ukuman nu Megbebayaꞌ di patay, adun mbeleng ditu piglegetawan nu Megbebayaꞌ.’ ");
INSERT INTO syb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Naa su kelaun pimuunan nu Megbebayaꞌ, genat dini Samuel sampay di nga mibinayaꞌ pa diniin, mikpesuun ilan di gulaula nemun. ");
INSERT INTO syb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","“Naa, yamui sapuꞌ nu nga pimuunanen kia. Adin su pinasad nu Megbebayaꞌ dinilan, pinasad dadema diniu. Iini pinasad nu Megbebayaꞌ dini Abraham, laungen, ‘Ki sapuꞌ mu kiin, pepiananen sug launan bansa di tibuuk lumbang.’” ");
INSERT INTO syb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Diksuꞌ ni Pedro, “Naa bekna, sinuguꞌ nu Megbebayaꞌ diniu su Sesuguꞌenen, adun pepianan amu niin, saladuaꞌ diniu, peteliudenen tu salaꞌen.” ");
INSERT INTO syb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Naa selian ni Pedro mukaꞌ ni Juan megwali ditu nga getaw mipungun dia, luminabet dinilan su ngag belian nu getaw Judea mukaꞌ su nga Saduseo kampuꞌ nu nga kaunutan nu nga pegingat tu Pengedapan tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Naa ki nga getaw kini minateng, melaati ginaa nilan, puꞌ midengeg nilan pigukit ni nga Pedro tu nga getaw puꞌ mitubuꞌ puliꞌ si Isus. Kaas iini delendeman nilan, mbuus peglegintuuden nu nga getaw, metubuꞌ puliꞌi nga minatay getaw. ");
INSERT INTO syb_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Mendadi dinaap nilan si nga Pedro, dayun nilan pikutay pa deliꞌ, puꞌ gebii na. ");
INSERT INTO syb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Laak melaun getaw mikedengeg ditu kegwali ni nga Pedro, mituudan ilan dun. Su nga mikpetuud, midepet na saan lima ngibu tawan. ");
INSERT INTO syb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Naa benaꞌ miglegendaw, mikpungun dia Jerusalem su nga kaunutan nu getaw Judea, su nga gukum, mukaꞌ su nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Minampuꞌ dadema dinilan su Tampusan Metaas Belian si Anas mukaꞌ si Caifas, si Juan, si Alejandro, sampay su kelaun betaꞌan ni Anas. ");
INSERT INTO syb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Mendadi ki nga kaunutan kini, benaꞌ inagak nilan si nga Pedro dia gedapan, sinaakan nilan dayun, laung nilan, “Ki pinggulaula niu kia kalabung, kendutaꞌi kebaal niu dun? Taꞌ taway duni mikpebayaꞌ diniu adun mekenggulaula amu di maꞌantu kalabung?” ");
INSERT INTO syb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Mendadi kini si Pedro, pingepuꞌan nug Balakat nu Megbebayaꞌ di sembagen. Kaliꞌ pektaluꞌ si Pedro, “Yamu nga kaunutan mukaꞌ gukum, ");
INSERT INTO syb_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","saꞌ saakan niu ami mekatag di kepia tu pilung kia, mukaꞌ saꞌ saaken niu dinami kendutaꞌi kauliꞌayen, ");
INSERT INTO syb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","naa melengas sembagen ku amu, adun mesuunan niu dakus mesuunan nu kelaun getaw Israel. Mikegindeg ki getaw kini di gedapan niu sabaꞌ miuliꞌan miksekat di ginuung ni Isukristu, getaw Nazaret, kig linansang niu di kurus, laak pitubuꞌ puliꞌ nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Kini si Isus, iini pisugatan ditu Taluꞌ nu Megbebayaꞌ, laungen, ‘Kig batu pimilas niu nu nga megbaal balay, iini mibaal tampusan gempagen gentudan nug balay.’” ");
INSERT INTO syb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Laung pa ni Pedro, “Mendadi, ndaꞌidunig lain mekegawen dinita, subay si Isus. Puꞌ ndaꞌidunig lain getaw dig dibabaw lumbang pipegbayaꞌ nu Megbebayaꞌ adun guunen ita niin, subay laak si Isus. Ndaꞌiduni kegawen dinita subay pebian diniin.” ");
INSERT INTO syb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Naa mendadi ki nga gukum kini, benaꞌ minitaꞌ nilan si Pedro mukaꞌ si Juan gembeluꞌ gupia sumbag, asa maikaꞌi mituꞌunan nilan, misebuꞌan ilan dun gupia. Miꞌilala nilan dayun puꞌ pigdumanan ilan ni Isus. ");
INSERT INTO syb_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Naa ndaꞌ maulakay nu nga gukum su simbag ni Pedro, puꞌ ki miuliꞌan kia, dia ma pegindeg gupid ni nga Pedro. ");
INSERT INTO syb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Saꞌ maꞌantu, ki nga gukum kini, pipeguaꞌ nilan deliꞌ si nga Pedro dia pengukuman, adun peksebutsebuten nilan ki ginukuman nilan dia mipenggulaula. ");
INSERT INTO syb_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Laak laung nilan, “Taꞌ alandun maig baalen ta di nga getaw kiin? Puꞌ ndiꞌ ta ma dema mpemilas ki mekesalebuꞌ pinggulaula nilan kiin, puꞌ misuunan nug launan getaw dini Jerusalem. ");
INSERT INTO syb_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Tumuꞌ pemaagen ta laak ilan, ndiꞌ na nilan sembayan ki ngalan ni Isus kiin, pia tu sala tawan, adun ndiꞌ mesigwag di nga getawi gukiten nu mipenggulaula kini.” ");
INSERT INTO syb_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Mendadi, sinabi puliꞌ nu nga kaunutan si Pedro mukaꞌ si Juan. Pimaag nilan dayun, adun ndaꞌidun nai pegukit nilan, ndaꞌiduni pektuꞌun nilan, sembayan nilan su ngalan ni Isus kiin. ");
INSERT INTO syb_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Dagid sumimbag si Pedro mukaꞌ si Juan, laung nilan, “Naa, yamui petitengaꞌ dun, saꞌ alanduni gempia di pegitaꞌen nu Megbebayaꞌ. Mekpetuud ami diniin, atawaka mekpetuud ami diniu? ");
INSERT INTO syb_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Puꞌ ndiꞌ nami metigel saꞌ ndiꞌ nami pegukiten tu nga getaw ki minitaꞌ nami mukaꞌ ki midengeg nami mekatag dini Isus.” ");
INSERT INTO syb_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Naa pisilutan sia nu nga kaunutan si nga Pedro, laak ndiꞌ mesuꞌat, puꞌ mbuus sumugut dini nga Pedro su nga getaw, kagina migleep di nga kelaun getaw sug dengegan nu Megbebayaꞌ sabaꞌ nu pilung kia miuliꞌan, minayan na paat puluꞌi taunen. Maꞌantu, pingimeekan patiꞌ nu nga kaunutan si nga Pedro, mukaꞌ biluy ilan dayun. ");
INSERT INTO syb_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Naa dekag biluy si Pedro mukaꞌ si Juan, mipuliꞌ ilan ditu ngag duma nilan, inukit nilan dayun ditug launan ki tinaluꞌ dinilan kia nu nga kaunutan nug belian mukaꞌ nu ngag duma kaunutan nu getaw Judea. ");
INSERT INTO syb_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Mendadi benaꞌ midengeg nu nga mikpetuud, miksalabuuk ilan dayun menenabi ditu Megbebayaꞌ, laung nilan, “Uu Megbebayaꞌ, yaꞌai Mikleb tug langit, Miwat tug lupaꞌ, Minunag tug dagat, Minaglis tu tubig, mukaꞌ Mitang dig lumaun bitang dun! ");
INSERT INTO syb_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ki ginepuꞌay nami si David, sesuguꞌen mu, pisulat nug Balakat mu, laungen, ‘Mauma dema mimeluꞌ su nga kanaꞌ getaw Judea? Mauma dema iini delendeman nu nga samatawu su ndaiꞌ gatagen? ");
INSERT INTO syb_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Su nga gadiꞌ dema dig lumbang kini, mingandam ilan, su nga kaunutan padun, mikpungun ilan, adun lumpakan nilan su Kaunutan Megbebayaꞌ mukaꞌ su Tinduꞌen Meglekaunutan.’” ");
INSERT INTO syb_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Kaliꞌ gusay penenabi su nga mikpetuud, “Naa, uu Megbebayaꞌ, mikpungun na tuꞌu dinig lunsud kini si Herodes mukaꞌ si Poncio Pilato, kampuꞌ nu nga getaw Israel mukaꞌ su nga kanaꞌ, suminugut ilan kumuntra ditu pimiliꞌ Sesuguꞌen mu si Isus, su Tinduꞌ mu Meglekaunutan. ");
INSERT INTO syb_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Laak dagid sug launan mipenggulaula nilan kia, lumbus daniꞌa pegbayaꞌ mukaꞌ delendeman mpenggulaula. ");
INSERT INTO syb_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Mendadi nandaw, uu Kaunutan, talentenay mu su kengimeek nilan dinami, yami nga sesuguꞌen mu, mukaꞌ begay mu dinami meksibeluꞌ ami megukit tu taluꞌ mu. ");
INSERT INTO syb_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Peduma mu dun pagid paitaꞌ di nga getaw su ginuung mu mekpauliꞌ dun su nga megladu, mukaꞌ menggulaula mekesalebuꞌ mukaꞌ tuꞌus pebian di pegbayaꞌ nu pimiliꞌ Sesuguꞌen mu si Isus.” ");
INSERT INTO syb_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Mendadi benaꞌ mitubus menenabi su nga mikpetuud, mikelegyug sug balay piglumpukan nilan. Dayun ilan gelaꞌ pengepuꞌay nug Balakat nu Megbebayaꞌ. Minibeluꞌ ilan dayun megukit tu taluꞌ nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Naa su pikumpungan nu nga mikpetuud, miksalabuuk ilan dig delendeman sampay di ginaa. Ndaꞌiduni minangken nga pimetangen, miktinebangay laak ilan. ");
INSERT INTO syb_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Su nga peneligan ni Isus, bigayan ilan ginuung tumakesiꞌ di ketubuꞌ puliꞌ nu Kaunutan si Isus, mukaꞌ migelaꞌ pepianay nu Megbebayaꞌ su nga mikpetuud. ");
INSERT INTO syb_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ndaꞌi sala tawan di pikumpungan nilan ndaꞌiduni kulangen, puꞌ adin sug duunig lupaꞌen atawaka balayen, piksaluyen, dayunen uitay su galinen ");
INSERT INTO syb_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","pigwakil ditu nga peneligan ni Isus. Pikilas nilan dayun, adin sug duuni kulangen, bigayan nilan di sukal diniin. ");
INSERT INTO syb_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Mendadi duuni getaw Cipre ngalanen si Jose, sapuꞌ ni Levi, piningalan dun nu nga peneligan ni Isus si Bernabe, (guluganen “Su Metau Mekamuꞌamuꞌ”). ");
INSERT INTO syb_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Si Bernabe, duunig lupaꞌen piksaluyen, dayunen pegwakil su galinen ditu nga peneligan ni Isus. ");
INSERT INTO syb_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Laak duuni getaw ngalanen si Ananias, su sawanen si Safira. Kini si nga Ananias, duunig lupaꞌ nilan piksaluy nilan. ");
INSERT INTO syb_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Dagid duuni sinawad dun ni Ananias su galinen, sinanguꞌ dadema nu sawanen. Dayun uitay ni Ananias su galinen ditu nga peneligan ni Isus, pigwakilen dinilan. ");
INSERT INTO syb_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Dagid sinaak ni Pedro diniin, “Ananias, mauma dema pinulaya ni Satanas, adun migbalusa tug Balakat nu Megbebayaꞌ? Miksawada dun su galin nug lupaꞌ niu kiin. ");
INSERT INTO syb_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Naa su ndaꞌ mu pa peksaluy, yaꞌai metau dun. Mukaꞌ saꞌ piksaluy mu, yaꞌa da gusayi megbayaꞌ dun su galinen. Naa, mauma dema midelendem mu menggulaula maꞌniin? Kanaꞌ laak nu kilawani piglimbungan mu, su na Megbebayaꞌ!” ");
INSERT INTO syb_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Lemen laak midengeg ni Ananiasi tinaluꞌ kia ni Pedro, miseksud dayun, mitigbak. Mindek dayun patiꞌ su nga mikedengeg dun. ");
INSERT INTO syb_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Dekag minatay si Ananias, migbuat su ngag begu getaw, pigupianan nilan dayun sug bangkayen, iwit nilan diag liu, inangay nilan dayun lebengay. ");
INSERT INTO syb_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Mendadi, duun saani telu uras, minateng su sawa ni Ananias, laak ndaꞌen suunayi mipenggulaula. ");
INSERT INTO syb_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Miktaluꞌ si Pedro dini Safira kini, “Pesuun mu dinaan saꞌ iin baig launen, ki galin nug lupaꞌ niu.” “Waꞌa,” simbag ni Safira, “daal daitu.” ");
INSERT INTO syb_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kaliꞌ pektaluꞌ si Pedro diniin, “Mauma dema amu duaꞌ, midelendem niu pengindanan niu sug Balakat nu Megbebayaꞌ? Naa, diin na bisuangan kiin su nga getaw miglebeng tu sawa mu mundiin. Pedumaan ka nilan lebengay!” ");
INSERT INTO syb_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Mitekaw dayun meseksud ki sawa ni Ananias kia, mitigbak pagid. Sumiled dia su ngag begu getaw kia. Benaꞌ minitaꞌ nilan puꞌ minatay dadema iin, iwit nilan diag liu, dayun nilan lebengay, ditu dadema gupid nug lebeng nu sawanen. ");
INSERT INTO syb_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Benaꞌ midengeg nu pikumpungan nu sakup ni Isus ki mipenggulaula kia, migelaꞌ ilan mendek. Maꞌantu dadema su taman mikedengeg dun, sakup saꞌ kanaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Naa su nga peneligan ni Isus, melaun mekesalebuꞌ penggulaula mukaꞌ tuꞌus binaal nilan di pegitaꞌen nu nga getaw. Tatap mekpungun su nga kelaun mikpetuud ditu Pengedapan tu Megbebayaꞌ, dia Silung ni Salomon. ");
INSERT INTO syb_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Pigbesaan gupia nu nga getaw su nga suminakup dini Isus, laak pia maꞌantu, mindek lumamug dinilan su ngag duma getaw. ");
INSERT INTO syb_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Laak minamal ilan gupia megdugang, puꞌ melaun gupia getaw mikpetuud tu Kaunutan si Isus, libun laki. ");
INSERT INTO syb_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kaas su nga migladu, iwit nug dumanen dia nga karsada, pibelilid nilan di sampuyuan atawaka di gikam adun puluꞌ sug duma dun, mbianan ilan nug lingu laak ni Pedro. ");
INSERT INTO syb_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Melaun getaw mikpungun ditu nga peneligan ni Isus dia Jerusalem genat di ngag lumibut lunsud, peguiten nilan dia su nga pegladu mukaꞌ nga piglegetan menenulay. Mendadi miuliꞌan ilan dayun, launan nilan. ");
INSERT INTO syb_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Naa kagina maꞌantu, ki Tampusan Metaas Belian nu getaw Judea mukaꞌ ki ngag dumanen di pikumpungan nu nga Saduseo, misigi ilan patiꞌ ditu nga peneligan ni Isus. ");
INSERT INTO syb_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Mendadi dinaap nilan si nga Pedro mukaꞌ pinikutan nilan. ");
INSERT INTO syb_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Dagid su gebii kitu, duun masiꞌi sesuguꞌen nu Megbebayaꞌ getaw langit minukaꞌ tu pirisuan, inagaken dayun si nga Pedro gumawas dia. Kaliꞌ pektaluꞌ dinilan, ");
INSERT INTO syb_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Naa, puliꞌ amu ditu Pengedapan tu Megbebayaꞌ. Pegindeg amu dia, pegukit amu dayun ditu nga getaw mekatag dig begu ketubuꞌ kini.” ");
INSERT INTO syb_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Benaꞌ midengeg nu nga peneligan ni Isus kia, pituud nilan dayun. Benaꞌ daliꞌ endaw, milapus ilan mpanaw ditu Pengedapan, mikpetuꞌun ilan dayun dia. Mendadi ki Tampusan Metaas Belian kia mukaꞌ ki ngag dumanen, pinsabi nilan su tibuuk Pikumpungan nu Metaas Gukum nu getaw Judea. Benaꞌ migelaꞌ ilan mpungun, piangay nilan sia su nga peneligan ni Isus dia pirisuan. ");
INSERT INTO syb_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Laak dagid saꞌ minateng dia pirisuan su nga pegingat tu Pengedapan tu Megbebayaꞌ, ndaꞌ na nilan metaangay su nga peneligan ni Isus. Mipuliꞌ ilan dayun ditu nga gukum, kaliꞌ ilan pegukit dinilan, ");
INSERT INTO syb_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Saꞌ minateng ami ditu pirisuan, mitaangan nami, pimegenan pa tekepay. Su nga megingat di pirisuan, dia dailan bisuanganen. Laak benaꞌ pinukaꞌ nami, ndaꞌidun nai getaw diag dialem!” ");
INSERT INTO syb_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Naa, apelai. Benaꞌ midengeg nu nga kaunutan nug belian kini mukaꞌ nu kaunutan di pegingat tu Pengedapan, milibuleng ilan gupia, saꞌ taꞌ alandun pai mpenggulaula dig binayaꞌ gebii buꞌ gendaw. ");
INSERT INTO syb_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Naa segay nilan mesebuꞌay dun, duuni getaw minateng, laungen dinilan, “Ki nga pinikutan niu kiin, dia dailan dibaluy nu Pengedapan kini, mikpetuꞌun ilan tu nga getaw!” ");
INSERT INTO syb_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Saꞌ maꞌnia, inangay dayun nu nga megingat kia su nga peneligan ni Isus, dinunutan ilan nu kaunutan nilan. Laak ndaꞌ nilan pendegay si nga Pedro, puꞌ mendek ilan mbuus betuun ilan nu nga getaw miktabuꞌ dia. ");
INSERT INTO syb_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Mendadi benaꞌ inagak dia su nga peneligan ni Isus, pinindeg ilan dia gedapan nu Pikumpungan nu nga Gukum, sinaakan ilan dayun nu Tampusan Metaas Belian. ");
INSERT INTO syb_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Kaliꞌ pektaluꞌ su Metaas Belian, “Naa mendadi, pimeek nami amu gupia puꞌ ndiꞌ niu sembayani ngalan kini saꞌ mekpetuꞌun amu! Naa bentayay pa daan niu, su pigukit niu, mileep na dini Jerusalem! Mukaꞌ pingelegan niu ami, laung niu yamii mikpatay di getaw kiin!” ");
INSERT INTO syb_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Kaliꞌ sembag si nga Pedro, “Subay mekpetuud ami tu Megbebayaꞌ, sabayaꞌ diniu. ");
INSERT INTO syb_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Puꞌ su Megbebayaꞌ pektemuyen nu nga ginepuꞌay ta, iini mikpetubuꞌ puliꞌ dini Isus kiin, su pinatay niu, linansang niu di kurus. ");
INSERT INTO syb_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Mendadi kini si Isus, pitaas dadema nu Megbebayaꞌ, piꞌingkuden di gupiden dapit lintunen adun iini meglekaunutan mukaꞌ meglegawen, adun ebangan ita niin nga getaw Israel meksikesuun mukaꞌ pedesunen ita niin di nga salaꞌ ta. ");
INSERT INTO syb_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Naa, yami kenii miketakesiꞌ di ketubuꞌen puliꞌ. Miketakesiꞌ dun padun sug Balakat nu Megbebayaꞌ, su pepengepuꞌen nu Megbebayaꞌ di nga mekpetuud dini Isus.” ");
INSERT INTO syb_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Mendadi ki nga gukum kini, benaꞌ midengeg nilan su sembag kia ni nga Pedro, mitutung ilan gangit, taginaa nilan dun, pepatay nilan su nga peneligan kia. ");
INSERT INTO syb_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Dagid migindegi sala tawan gukum, ngalanen si Gamaliel, iini sala tawan di pikumpungan piningalan dun Pariseo. Mekpetuꞌun si Gamaliel di Misulat Palinta nu Megbebayaꞌ, pegbesaan gupia nu nga kelaun getaw. Migindeg dia gedapan nu nga gukum si Gamaliel, sinuguꞌen dayun peguaꞌen deliꞌ dia si nga Pedro. ");
INSERT INTO syb_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Benaꞌ mipalus ilan, kaliꞌ pektaluꞌ si Gamaliel dia nga gukum, “Mendadi yamu nga samau getaw Israel, peksibaꞌan ta ki gulaula ta di nga getaw kiin, adun ndiꞌ ita melapang. ");
INSERT INTO syb_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Puꞌ misuunan ta puꞌ begudiin, duuni getaw ngalanen si Teudas, inangkenen metaasi gelalen. Duun saani paat gatus tawan suminakup dayun diniin. Laak binunuꞌ iin, dayun mipelak su nga kelaun sakupen, mibulugan na laak. ");
INSERT INTO syb_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Mendadi tubus itu, duuni getaw Galilea ngalanen si Judas. Su timpu pa nu kenlista tu nga getaw, melaun getaw suminakup dini Judas kia. Laak minatay dadema, mipelak dayun su nga kelaun sakupen.” ");
INSERT INTO syb_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Laung pa ni Gamaliel, “Naa mendadi taluꞌu diniu nandaw, ndiꞌ ta pulegen ki nga getaw kiin. Petuyangen ta nailan! Puꞌ saꞌ genat laak di kilawani penggulaulaan nilan kini, mbulugan laak. ");
INSERT INTO syb_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Dagid saꞌ genat tu Megbebayaꞌ, naa ndiꞌ ta maulakan. Mbuus mpengetuan ta su Megbebayaꞌ!” Mendadi, sinanguꞌ nu nga gukum su tinaluꞌ kia ni Gamaliel. ");
INSERT INTO syb_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Dekag sinabi puliꞌ su nga peneligan ni Isus kia, pimbadas ilan mukaꞌ pimaag dinilan ki keksambay nilan dini Isus, dayun ilan beluyay. ");
INSERT INTO syb_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Naa su nga peneligan ni Isus, benaꞌ mikeguaꞌ ilan dia Pikumpungan nu nga Gukum, liliag ilan gupia, kagina mipemilang ilan nu Megbebayaꞌ mbantang pepiidan sabaꞌ nu kesakup nilan dini Isus. ");
INSERT INTO syb_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Genat itu, dia ngag balay mesama ditu Pengedapan tu Megbebayaꞌ, gendawgendaw minamal ilan mekpetuꞌun mukaꞌ megwali di Gempia Petenday mekatag dini Isus, su Tinduꞌ nu Megbebayaꞌ Meglekaunutan. ");
INSERT INTO syb_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Naa selian megdugang su nga mikpetuud dini Isus, duuni nga sakupen miksual. Su ngag duma sakup, getaw Judea, laak mektaluꞌ ilan pikebitan nu nga getaw Grecia, mukaꞌ duun dademai sakup mektaluꞌ ilan pikebitan nu getaw Judea. Naa laung nu nga sakup kia mektaluꞌ pikebitan nu getaw Grecia, gendawgendaw saꞌ pekilasen su ketubuꞌan, duuni ngag balulibun dinilan meleksawan. ");
INSERT INTO syb_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Mendadi, sinabi nu nga sepuluꞌ buꞌ duaꞌ tawan peneligan ni Isus su tibuuk pikumpungan nu nga mikpetuud. Benaꞌ mipungun ilan, kaliꞌ pektaluꞌ su nga peneligan, “Ndiꞌ mpia mundang ami megukit di taluꞌ nu Megbebayaꞌ, adun mekegilas ami di ketubuꞌan. ");
INSERT INTO syb_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Iini melengas, uu Mingumpated, pemiliꞌ amu di ngag duma niu pitu tawan, iini pemiliꞌ niu ki melengasig dengeganen, mukaꞌ pingepuꞌan nug Balakat nu Megbebayaꞌ dakus mekesuun gupia. Saꞌ mpemiliꞌ na niu, tenduꞌen nami ilan dayun mekilas di ketubuꞌan. ");
INSERT INTO syb_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Naa yami dema, menamal dami menenabi mukaꞌ megukit di taluꞌ nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Sinanguꞌ dayun nu tibuuk pikumpungan nu nga sakup ki tinaluꞌ kia nu nga peneligan ni Isus. Pimiliꞌ nilan dayun si Esteban, sala tawan suminalig gupia tu Megbebayaꞌ mukaꞌ pingepuꞌan nug Balakaten. Pimiliꞌ nilan pagid si nga Felipe, si Procoro, si Nicanor, si Timon, si Parmenas mukaꞌ si Nicolas getaw Antioquia, kanaꞌ getaw Judea laak miginetaw Judea. ");
INSERT INTO syb_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Mendadi ki pitu tawan pimiliꞌ nilan, inunutan ilan dayun tu gedapan nu nga peneligan ni Isus. Pinenebian ilan dayun nu nga peneligan ni Isus mukaꞌ dipenan ilan, tuꞌus tinduꞌ ilan mekilas di ketubuꞌan. ");
INSERT INTO syb_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Maꞌantu, minamal megdugang su nga mikedengeg ditu taluꞌ nu Megbebayaꞌ pigukit nu nga peneligan ni Isus. Migdugang dayun gupia su nga sakup ni Isus dia Jerusalem, melaun dademaig belian nu nga getaw Judea mikpetuud dun. ");
INSERT INTO syb_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Naa si Esteban kia, tinulungan gupia nu Megbebayaꞌ mukaꞌ bigayanen ginuung, kaas melaun mekesalebuꞌ pinggulaula mukaꞌ tuꞌus binaalen di gedapan nu nga getaw. ");
INSERT INTO syb_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Dagid kini si Esteban, siwal nu sakup di sala simbaan nu getaw Judea, su Simbaan nu nga Gulipen Pibeluy, (iini piningalan dun). Ki nga sakup di simbaan kia, getaw Cirene sug duma, dayun duun pagidi getaw Alejandria, getaw Cilicia, mukaꞌ getaw Asia. ");
INSERT INTO syb_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Dagid ilan kini, ndaꞌ ilan kegaga di telisebutay ni Esteban miksekat tug Balakat nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Saꞌ maꞌnia, tinindanan nilani nga getaw megukit dig balus, adun teluꞌen nilan, “Midengeg nami si Esteban kiin, mimilas tu palinta ni Moises sampay miksudiꞌ tu Megbebayaꞌ!” ");
INSERT INTO syb_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Maꞌnia, sinasaw nilani ginaa nu nga getaw kampuꞌ nu nga kaunutan nu getaw Judea mukaꞌ su nga mekpetuꞌun di Misulat Palinta nu Megbebayaꞌ. Mendadi, dinaap nilan si Esteban, iwit nilan dayun tu gedapan nu Pikumpungan nu Metaas Gukum. ");
INSERT INTO syb_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Dekag minateng ilan ditu, duuni sinabi nilan nga tumakesiꞌ dig balus mekatag dini Esteban kia. Kaliꞌ dayun pektaluꞌ su tumakesiꞌ kia, “Ki getaw kini, tatap menampalaksa tu Pengedapan ta tu Megbebayaꞌ mukaꞌ tu Palinta nu Megbebayaꞌ pisulaten dini Moises. ");
INSERT INTO syb_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Midengeg nami ki tinaluꞌen puꞌ ki Pengedapan tu Megbebayaꞌ kini, gebaꞌen daw ni Isus kiin getaw Nazaret, dakus pelinenen daw padun su kelaun betad ta pingumbilin dinita ni Moises!” ");
INSERT INTO syb_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Saꞌ maꞌnia, tintengan gupia si Esteban nu ngag launan kaunutan kia. Pegitaꞌ nilan dun su muluꞌen, maaꞌ danu sesuguꞌen nu Megbebayaꞌ getaw langit. ");
INSERT INTO syb_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mendadi, sinaakan nu Tampusan Metaas Belian si Esteban, laungen, “Metuud kaliꞌig dinangat nilan kini mekatag diniꞌa?” ");
INSERT INTO syb_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Kaliꞌ pektaluꞌ si Esteban, “Yamu nga Mekegulang mukaꞌ yamu nga Mingumpated, pekineegay niui teluꞌen ku kini! Su megdedengeg Megbebayaꞌ pektemuyen ta, mikpaitaꞌ ditu ginepuꞌay ta si Abraham su diin pa Mesopotamia, su ndaꞌ pa kegbenwa si Abraham tu Haran. ");
INSERT INTO syb_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Miktaluꞌ su Megbebayaꞌ diniin, ‘Pegawaꞌa dig daan benwa mu kini mukaꞌ di ngag betaꞌan mu, uliꞌa dig lain benwa, ki paitaꞌu pa diniꞌa.’ ");
INSERT INTO syb_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Mendadi saꞌ maꞌantu, migawaꞌ tuꞌu si Abraham dig daan benwanen, sug benwa nu getaw Caldea, mukaꞌ minuliꞌ tu Haran. Selian nilan dia, minatay su gamaꞌ ni Abraham, iin pa pibundas nu Megbebayaꞌ si Abraham dini pegbenwanan ta nandaw. ");
INSERT INTO syb_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Laak ndaꞌig lupaꞌ bigay nu Megbebayaꞌ dini Abraham, pia laak maꞌniin palad. Laak dagid pinasad nu Megbebayaꞌ diniin, kig benwa kini, begayen pa diniin, adun daniin benwa mukaꞌ danu nga sapuꞌen. Asa ndaꞌidun paig bataꞌ ni Abraham di gendaw kia. ");
INSERT INTO syb_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Miktaluꞌ su Megbebayaꞌ dini Abraham, ‘Su sapuꞌ mu, muliꞌ pailan dig lain benwa, ki kanaꞌ danilan benwa. Baalen ilan gulipen ditu dakus pelaatan ilan sampay paat gatus taun. ");
INSERT INTO syb_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Laak dagid sug bansa nu getaw mengulipen dinilan, ukuman ku. Kaas tubus itu, mekegawaꞌ ilan dig benwa kitu, muliꞌ ilan dinig benwa kini, adun mektamuy ilan dinaan dini.’” ");
INSERT INTO syb_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Laung padun ni Esteban, “Naa mukaꞌ tubus itu, tinaluꞌ pa pagid nu Megbebayaꞌ dini Abraham puꞌ su ngag bataꞌen, di kewalu endawen genat kegigetawen, subay sirkunsisuun, tuꞌus di pasad kia nu Megbebayaꞌ dinilan. Saꞌ maꞌantu, su kegigetaw nug bataꞌen si Isaac, di kewalu endawen, sinirkunsisu tuꞌu ni Abraham si Isaac. Maꞌantu dadema su pinggulaula ni Isaac tug bataꞌen si Jacob. Dayun su pelum sepuluꞌ buꞌ duaꞌ tawan bataꞌ ni Jacob, su nga ginepuꞌay ta kitu, pimaꞌnia ilan dadema ni Jacob. ");
INSERT INTO syb_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Mendadi sala tawan bataꞌ ni Jacob, iin si Jose. Naa kini si Jose, mingimbegu gupia diniin su nga gulangbataꞌen. Saꞌ maꞌantu, piksaluy nilan iin, dayun iwit nu mingulipen dun ditug Ehipto. Dagid ibangan nu Megbebayaꞌ si Jose diag Ehipto, ");
INSERT INTO syb_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ginawenen dayun dig launan kelegenayen. Pipianan gupia nu Megbebayaꞌ, kaas liliag dini Jose su gadiꞌ, puꞌ di pegitaꞌen dun, mekesuun gupia si Jose. Saꞌ maꞌnia, binaal dayun nu gadiꞌ si Jose kaunutan di tibuuk benwa Ehipto, sampay diag balay nu gadiꞌ.” ");
INSERT INTO syb_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Maaꞌ laung padun ni Esteban, “Naa ndaꞌ maiben, binianan gutem kig benwa Ehipto kia sampay su Canaan, milegenan dun gupia su getaw. Su ginepuꞌay ta si nga Jacob dia Canaan, ndaꞌiduni sukatan nilan gaan. ");
INSERT INTO syb_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Mendadi benaꞌ midengeg ni Jacob duun dawi gaan ditug Ehipto, sinuguꞌen su ngag bataꞌen memuku ditu. Iinig bekna keditu nu nga ginepuꞌay ta. ");
INSERT INTO syb_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Dayun di keduaꞌ deksuꞌ nilan mpanaw ditug Ehipto, mikpailala dinilan si Jose. Misuunan dayun nu gadiꞌ, pated ilan ni Jose. ");
INSERT INTO syb_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tubus itu, pimuunan ni Jose su gamaꞌen si Jacob muliꞌ dia, sampay su nga kelaun betaꞌanen, pitu puluꞌ buꞌ lima tawan ilan. ");
INSERT INTO syb_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Naa saꞌ maꞌnia, minuliꞌ ilan tuꞌu ditug Ehipto. Ditu na dayun minatay si Jacob, sampay su nga ginepuꞌay ta kitu. ");
INSERT INTO syb_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Laak iwit puliꞌ ditu Canaan, dia dapit Siquem, su ngag bangkay nilan, dayun libeng tug lebengan sinaluy dengantu ni Abraham di ngag bataꞌ ni Hamor, getaw Siquem. ");
INSERT INTO syb_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Mendadi saꞌ sungu mateng su kenuud nu pinasad kiin nu Megbebayaꞌ dini Abraham, miksilaun na gupia diag Ehipto su getaw nug bansa ta. ");
INSERT INTO syb_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Laak di timpu kia duunig lain gadiꞌ meglekaunutan diag Ehipto, su ndaꞌ maukitay ditu tindeg dengantu ni Jose, ");
INSERT INTO syb_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","kaas pilaatanen su ginepuꞌay ta. Sinuguꞌen dinilan peliuun dig balay su nga gembataꞌ nilan, sug begu pa pegigetaw, adun sia mematay.” ");
INSERT INTO syb_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Laung padun ni Esteban, “Naa su timpu kitu, migigetaw si Moises, piabataꞌ gupia di pegitaꞌ dun nu Megbebayaꞌ. Kini si Moises, telu bulan pegingatay nu mekegulangen diag balay nilan, ");
INSERT INTO syb_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","dayun nilan peliuay dia. Laak dagid minitaꞌ bataꞌ nu gadiꞌ, libun, dayunen betaꞌay. ");
INSERT INTO syb_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Piktuꞌunan dayun si Moises dig launan betad nu getaw Ehipto. Saꞌ migineken na, metau gupia megyaga, dakus mekesuun su gulaulanen. ");
INSERT INTO syb_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Naa benaꞌ paat puluꞌ nai taun ni Moises, midelendemen laawanen su kebetang nu nga samanen getaw Israel. ");
INSERT INTO syb_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Mendadi selianen ditu nilan, minitaꞌ ni Moises sala tawani getaw Israel pilaatan getaw Ehipto. Sinugutan dayun ni Moises, pinatayen su getaw Ehipto. ");
INSERT INTO syb_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","(Laung dun ni Moises, mesuunan dayun nu nga samanen getaw Israel, iini pimiliꞌ nu Megbebayaꞌ gumawen dinilan. Laak ndaꞌ nilan mesuunayi ginangayen kia.) ");
INSERT INTO syb_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Naa benaꞌ migendaw puliꞌ, duun pelumi midetengan ni Moises duaꞌ tawan miksual, lumbus getaw Israel. Pimaag ilan dayun ni Moises, piksuden ilan sia, laungen dinilan, ‘Baa lai, mauma dema meksual amu, asa megbetaꞌan damu?’ ");
INSERT INTO syb_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Laak su mikpelaat tug dumanen, tinuluden si Moises, laungen diniin, ‘Yaꞌa, bigayan ka ba pegbayaꞌ dinami? Gukuma ba dinami? ");
INSERT INTO syb_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Petain mau pa padun,’ sinaak padun nu getaw kia dini Moises, ‘maaꞌ nu pinatay mu su getaw Ehipto kalabung?’ ");
INSERT INTO syb_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Benaꞌ midengeg ni Moises, minawaꞌ dayun diag Ehipto, miglaguy tug benwa Midian. Segayen megbenwa tu Midian, duun naig bataꞌen duaꞌ tawan, lumbus laki. ");
INSERT INTO syb_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Naa mendadi,” laung pa ni Esteban, “benaꞌ paat puluꞌ taun ditu Midian si Moises, duuni gendaw, ditu si Moises limawaꞌ mesempel dig Bentud Sinai. Selianen dia, duuni mikpekitaꞌ diniin sesuguꞌen nu Megbebayaꞌ getaw langit. Ki getaw langit kini, mituaꞌ dia titengaꞌ nu sala puun sigbet migligaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Misebuꞌan dun gupia si Moises. Kaliꞌ pekpesempel di sigbet kia, pigipusen sug ligaꞌ, midengegen su taluꞌ nu Kaunutan Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Kaliꞌ pektaluꞌ, ‘Naan su Megbebayaꞌ, su pektemuyen nu nga ginepuꞌay mu si Abraham, si Isaac mukaꞌ si Jacob.’ Sinaaban dayun si Moises, ndiꞌ mekakuꞌ megbantay dun. ");
INSERT INTO syb_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Maaꞌ laung padun nu Kaunutan Megbebayaꞌ diniin, ‘Luas mu su sepatus mu kiin, puꞌ kig lupaꞌ kiin ginindegan mu, danaan dain. ");
INSERT INTO syb_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Naa mendadi,’ maaꞌ laung padun nu Megbebayaꞌ, ‘minitaꞌu dema tuꞌu su meliget kelegenay nu nga piglegetawan ku. Midengegu pa pagid sug degu nilan, kaas mituaꞌu adun gumawen dinilan di kaulipen dinilan. Mendadi yaꞌa, Moises, yaꞌai suguꞌen ku mpanaw ditug Ehipto.’” ");
INSERT INTO syb_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Maaꞌ laung padun ni Esteban, “Naa kini si Moises, ki pimilas kiin nu nga getaw Israel, su tiluꞌan nilan begudiin, ‘Ndaꞌi pegbayaꞌ mu dinami, mukaꞌ kanaꞌa gukum dinami,’ iin masiꞌ tuꞌu su sinuguꞌ nu Megbebayaꞌ meglekaunutan dinilan mukaꞌ gumawen dinilan, kaas ibangan si Moises nu getaw langit, su mikpaitaꞌ diniin dia sigbet migligaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Naa saꞌ maꞌantu, iwit tuꞌu ni Moises su nga getaw Israel memegawaꞌ diag Ehipto. Melaun mekesalebuꞌ pinggulaula mukaꞌ tuꞌus binaal ni Moises ditug Ehipto mukaꞌ tu Gempula Dagat sampay ditug limawaꞌ, paat puluꞌ taun ilan ditug limawaꞌ kia. ");
INSERT INTO syb_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mendadi kini si Moises, iini miktaluꞌ tu nga getaw Israel maꞌniniꞌ. ‘Duun pai tenduꞌen nu Megbebayaꞌ pemuunanen diniu, maꞌniin dinaan, sama da niu dema getaw Israel.’ ");
INSERT INTO syb_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Kaas si Moises, iinig duma nu nga getaw Israel mipungun ditug limawaꞌ, ki ginepuꞌay ta, mukaꞌ iin dademaig duma nu getaw langit miktaluꞌ diniin ditug Bentud Sinai. Iin pa paduni pigwekilan taluꞌ nu Megbebayaꞌ ndaꞌi kebelengen, adun pengumbilinen dinita.” ");
INSERT INTO syb_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Laung padun ni Esteban, “Laak dagid pia maꞌantu, su nga ginepuꞌay ta, ndaꞌ ilan pekpetuud dini Moises. Mimilas ilan diniin, puꞌ migindaw nilan su kebetang nilan ditug Ehipto. ");
INSERT INTO syb_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Kaas laung nu getaw Israel dini Aaron, ‘Baalay mu ami ngag ledawan mekpenuluꞌ dinami bianan nami. Puꞌ si Moises kiin,’ laung nilan, ‘su miguit dinami memegawaꞌ ditug Ehipto, naa ndaꞌ nami suunay saꞌ adin dun.’ ");
INSERT INTO syb_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","“Mendadi maꞌantu, binaalan ilan tuꞌu ni Aaron ledawan maꞌniin palas nati baka, iini pingilakan nilan dayun. Liliag ilan gupia dia pimbaalbaal nilan kia. ");
INSERT INTO syb_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Saꞌ maꞌantu, tiliudan ilan dayun nu Megbebayaꞌ, pituyang ilan niin mektamuy ditu ngag bitun tug langit, maaꞌ dadema nu sinulat nu nga pimuunan nu Megbebayaꞌ ditu Misulat Taluꞌen, laungen, ‘Yamu nu nga getaw Israel! Kanaꞌ naani piktamuy niu, kanaꞌ naani pingilakan niu guliden, saanan nu kepanaw niu kiin paat puluꞌ taun ditug limawaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Pegeguiten niu sug lepintaw binaal luna bitangan ledawan, ngalanen si Moloc, mukaꞌ sug binaal niu ledawan nug diwata niu bitun, ngalanen si Repan, lumbus pimbaalbaal laak niu, adun pektemuyen niu. Kaas iini puunanen, puaꞌen ku amu dig benwa kini, penguiten amu dayun ditu dapit dibaluy nug benwa Babilonia.’” ");
INSERT INTO syb_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Laung padun ni Esteban, “Mendadi, saanan nu ginepuꞌay ta ditug limawaꞌ, ditu nilan sug Lepintaw nu Takesiꞌ binaal luna, iini pengedapan nilan tu Megbebayaꞌ. Kig lepintaw kia, binaal maaꞌ nu tinituluꞌ dun nu Megbebayaꞌ dini Moises, maꞌniin gupia nug lendasan pinitaꞌ diniin. ");
INSERT INTO syb_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Naa benaꞌ miawiꞌ na nu ginepuꞌay ta si Josue kig benwa kitu, puꞌ piawaꞌ na nu Megbebayaꞌ su ngag lain bansa, iwit nilan sug lepintaw kitu pinusakaꞌ dinilan nu nga gamaꞌ nilan. Dia dayun sug lepintaw, sampay di gendaw ni David. ");
INSERT INTO syb_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Naa si David kia, liliag gupia diniin su Megbebayaꞌ, kaas mikpekilelaat si David ditu Megbebayaꞌ, iin siai megbaal balay pegbenwanan nu Megbebayaꞌ, su pektemuyen ni Jacob kitu. ");
INSERT INTO syb_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Laak iini migbaal dun, si Salomon na.” ");
INSERT INTO syb_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Laung padun ni Esteban, “Laak dagid su Tampusan Metaas Megbebayaꞌ, ndiꞌen pegbenwananig balay binaal nu kilawan. Iini sinulat dengantu nu pimuunan nu Megbebayaꞌ ditu Misulat Taluꞌen, laungen, ");
INSERT INTO syb_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Gingkudan ku sug langit, laung nu Kaunutan Megbebayaꞌ, mukaꞌ bendayan ku sug lumbang. Metau bamu megbaal balay mbantang dinaan? Duun bai pelelian ku? ");
INSERT INTO syb_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Kanaꞌ ba naani migbaal dun sug launan bitang di gekleb langit buꞌ lupaꞌ?’” ");
INSERT INTO syb_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Mendadi, miktaluꞌ pa padun si Esteban tu nga gukum kia, “Naa yamu pa di nga getaw, meketegas gupiai gulu niu! Sug delendeman niu, maaꞌ nug delendeman nu nga kanaꞌ getaw Judea! Ndiꞌ niu talentenan su tinaluꞌ nu Megbebayaꞌ! Mesama damu di nga ginepuꞌay niu, puꞌ tatap niu pemilasay sug Balakat nu Megbebayaꞌ! ");
INSERT INTO syb_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Duun bai sala tawan pimuunan nu Megbebayaꞌ dengantu, ndaꞌ peglegetay nu nga ginepuꞌay niu? Binunuꞌ nilan su nga pimuunanen mekpetenday pedaan tu ketuaꞌ nu mekesuun Sesuguꞌenen. Mendadi yamu pelum, benaꞌ mituaꞌ nain diniu, tinipu niu mukaꞌ binunuꞌ niu. ");
INSERT INTO syb_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Yamui pigwekilan nu sesuguꞌen nu Megbebayaꞌ getaw langit tu Palintanen, dagid ndaꞌ niu dunutay!” ");
INSERT INTO syb_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Naa ki nga gukum kini, benaꞌ midengeg nilan su tinaluꞌ kia ni Esteban, mingkiget ilan di ngisi nilan, sabaꞌ mitutung ilan gangit diniin. ");
INSERT INTO syb_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Dagid kini si Esteban, pingepuꞌan nug Balakat nu Megbebayaꞌ. Migangag tug langit, minitaꞌen di tiag su kelengas nu pegbayaꞌ nu Megbebayaꞌ, mukaꞌ minitaꞌen pa pagid si Isus pegindeg dia dapit lintu nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Tayay pa daan!” laung ni Esteban. “Pegitaꞌen ku sug langit mipukaꞌ, mukaꞌ kig Bataꞌ nu Kilawan pegindeg dia dapit lintu nu Megbebayaꞌ!” ");
INSERT INTO syb_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Mendadi ki nga gukum kini, mimeksay ilan tanan dunut tinimpeng nilani telinga nilan. Pigbatak nilan dayun si Esteban, ");
INSERT INTO syb_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","dindel nilan dayun ditug liu nug lunsud nilan. Dayun betuay si Esteban nu nga tuminakesiꞌ kia dig balus. Su nga migbatu dun, binilin nilani nga suub nilan di gedapan nu sala tawan begutaw, ngalanen si Saulo. ");
INSERT INTO syb_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Pinemalan nilan dayun betuay si Esteban kini. Si Esteban, minenabi, laungen, “Uu Kaunutan Isus, dawat mu su gimuudu!” ");
INSERT INTO syb_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Minginlulud dayun si Esteban mukaꞌ minekeg menenabi, laungen, “Uu Kaunutan Megbebayaꞌ! Saꞌ mesuꞌat, ndiꞌ mu pemilangayi salaꞌ nilan kini!” Mideksuꞌ teluꞌay, migetus nai ginaa ni Esteban. ");
INSERT INTO syb_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Naa si Saulo kia, sinanguꞌen su kepatay dini Esteban kia. Naa mendadi su gendaw kia, pikpuunan gupia peglegetay su pikumpungan nu nga mikpetuud dini Isus dia Jerusalem. Ki nga piglegetan kia, mipelak ilan dayun di tibuuk Judea mukaꞌ Samaria, iin laaki mibilin dinilan dia Jerusalem su nga sepuluꞌ buꞌ duaꞌ tawan peneligan ni Isus. ");
INSERT INTO syb_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Naa duuni nga getaw mikpetuud gupia tu Megbebayaꞌ, miglebeng ilan tug bangkay ni Esteban, lilekan nilan gupia iin. ");
INSERT INTO syb_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Mendadi si Saulo kia, piglegetanen patiꞌ su pikumpungan nu sakup ni Isus. Minamal suled di ngag bilayan, pimintengen su nga mikpetuud libun laki, dayunen uitay dia pirisuan. ");
INSERT INTO syb_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Laak su nga mipelak kiin, pia adin ilan mekangay, minamal ilan megukit di Gempia Petenday. ");
INSERT INTO syb_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Si Felipe kiin, minangay dig lunsud sakup Samaria, pigukiten tu nga getaw ditu puꞌ si Isus su Tinduꞌ nu Megbebayaꞌ Meglekaunutan. ");
INSERT INTO syb_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Benaꞌ midengeg nu melaun getaw su ginukit ni Felipe mukaꞌ minitaꞌ nilan su mekesalebuꞌ pinggulaulanen, piktalentenan nilan gupia su taluꞌen. ");
INSERT INTO syb_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Melaun menenulay pingutidan ditu getaw piglegetan nilan, menekeg mektegas su menenulay selian nilan mautid. Melaun dadema getaw miuliꞌan minatay seputul lawasen, sampay ngag duma mipilung. ");
INSERT INTO syb_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Saꞌ maꞌnia, liliag gupia su nga getaw Samaria kia. ");
INSERT INTO syb_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Naa diag lunsud kia duuni getaw mensaled, ngalanen si Simon. Kini si Simon, miniben na mesebuꞌay su nga getaw Samaria ditu penggulaulanen. Inangkenen metaasi tindegen. ");
INSERT INTO syb_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ndaꞌig datuꞌ ndaꞌi pusuk, migelaꞌ mektalenten diniin su nga getaw dia. Laung nilan, “Su ginuung nu getaw kiin, ginuung nu Megbebayaꞌ. Su gelalen, ‘Su Mekesalebuꞌ Ginuung.’” ");
INSERT INTO syb_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tinalentenan gupia nu nga getaw si Simon, puꞌ miniben nailan mesebuꞌay tu nga kenaleden. ");
INSERT INTO syb_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Laak dagid benaꞌ mikpetuud ilan ditu Gempia Petenday ginukit ni Felipe mekatag di Keglekaunutan nu Megbebayaꞌ dakus mekatag dini Isukristu, suminakup ilan dayun tu Megbebayaꞌ, binunagan ilan dayun tubig, libun laki. ");
INSERT INTO syb_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Sampay si Simon kini, mikpetuud na pagid. Tubus bunagay tubig si Simon, migduma dini Felipe. Saꞌ minitaꞌen su nga mekesalebuꞌ mipenggulaula mukaꞌ tuꞌus, misebuꞌan dun gupia si Simon. ");
INSERT INTO syb_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Naa su nga peneligan ni Isus ditu Jerusalem, benaꞌ midengeg nilan puꞌ dinawat na nu getaw Samaria su Gempia Petenday nu Megbebayaꞌ, sinuguꞌ nilan si Pedro mukaꞌ si Juan meditu Samaria. ");
INSERT INTO syb_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Benaꞌ minateng ditu si Pedro mukaꞌ si Juan, pinenebian nilan su nga mikpetuud dini Isus dia, adun pengepuꞌan ilan nug Balakat nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Puꞌ ndaꞌ pa lusad di nga getaw kia sug Balakat nug Megbebayaꞌ, binunagan ilan laak tubig, tuꞌus di kesakup nilan dini Isus. ");
INSERT INTO syb_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Mendadi benaꞌ pindepenan ni Pedro mukaꞌ ni Juan su nga getaw Samaria kia, pingepuꞌan ilan dayun tuꞌu nug Balakat nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Naa kia si Simon, benaꞌ minitaꞌen puꞌ saꞌ depenan nu nga peneligan ni Isus su nga mikpetuud, pengepuꞌan ilan dayun nug Balakat nu Megbebayaꞌ, miktulun sia si Simon kwarta dini nga Pedro. ");
INSERT INTO syb_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Kaliꞌ pektaluꞌ dinilan, “Saꞌ mesuꞌat, begayay niau di ginuung niu kiin, adun saꞌ duuni getaw depenan ku, pengepuꞌan ilan dadema nug Balakat nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","“Baa, ukuman ka nu Megbebayaꞌ,” simbag ni Pedro, “yaꞌa mukaꞌ su kwarta mu kiin! Masiꞌ delendeman mu, kig begay nu Megbebayaꞌ, megdadi seluyay? ");
INSERT INTO syb_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ndaꞌig labet mu dun su penggulaulaan nami. Puꞌ kig delendeman mu kiin, ndiꞌ pia di pegitaꞌen nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Pegbiksuꞌay mui melaat delendeman mu kiin. Penenebiay mu saꞌ megdadi, pedesunen ka nu Megbebayaꞌ dig delendeman mu melaaten. ");
INSERT INTO syb_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Puꞌ misuunan ku migbayaꞌ gupia dig delendeman mu su kengimbegu mu, mibaluda nu salaꞌ mu.” ");
INSERT INTO syb_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Laung dayun ni Simon dini Pedro mukaꞌ dini Juan, “Kelelaat penenebiay niau tu Kaunutan Megbebayaꞌ, ndiꞌ na mpenggulaula ki kelaun tinaluꞌ niu kia.” ");
INSERT INTO syb_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Tubus itu, tuminakesiꞌ si Pedro mukaꞌ si Juan ditu nga getaw, mukaꞌ migukit ilan di taluꞌ nu Kaunutan si Isus. Benaꞌ mitubus, minuliꞌ ilan ditu Jerusalem. Selian nilan dig dalan pegangay dia Samaria, inukit da nilan dema su Gempia Petenday dia melaun lunsud mibianan nilan. ");
INSERT INTO syb_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Naa mendadi si Felipe kiin, duuni sesuguꞌen nu Megbebayaꞌ getaw langit suminuguꞌ diniin, laungen, “Pengikpesa, angaya dia dapit gilidan gendaw, dia karsada pegangay ditu Gasa genat dini Jerusalem.” (Ki karsada kia, mikebian di meliwag limawaꞌ.) ");
INSERT INTO syb_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Saꞌ maꞌnia, benaꞌ mideksuꞌ mektaluꞌ su getaw langit, migbuat si Felipe, mipanaw tuꞌu. Naa duuni getaw Etiopia, metaas pegwekilan ni Candace, sug libun meguit tu getaw Etiopia, trisurirunen. Ki trisuriru kini, miditu Jerusalem mektamuy tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Mendadi saꞌ minuliꞌ pelum ditug Etiopia, suminakay prada, dunut pegbasa libru, su Misulat Taluꞌ nu Megbebayaꞌ pisulaten dengantu tu pimuunanen si Isaias. ");
INSERT INTO syb_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Mendadi selian nu trisuriru megbasa dun, kini pelum si Felipe, tiluꞌan nug Balakat nu Megbebayaꞌ, laungen, “Pekpesempela di prada kia, tenduga dun.” ");
INSERT INTO syb_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pingeted dayun ni Felipe su prada, mukaꞌ midengegeni getaw kia, pegbesaanen su sinulat kia nu pimuunan nu Megbebayaꞌ si Isaias. Sinaakan dayun ni Felipe su trisuriru, laungen, “Mesabut mu dai pigbasa mu kiin?” ");
INSERT INTO syb_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Kaliꞌ sembag ki getaw Etiopia kia, “Kendutaꞌi kesabutu dun, subay duuni megluas dun dinaan?” Inggaten dayun si Felipe menaik megingkud dia gupiden. ");
INSERT INTO syb_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Iinig binasanen ditu Misulat Taluꞌ nu Megbebayaꞌ, laung, “Ki getaw kini, sug betaden, maꞌniin betad karniru egaken tu pektitiꞌan dun, maꞌniin dema betad nati karniru, ndiꞌ megengaꞌ saꞌ untingan. Puꞌ selian piglegetan, ndaꞌiduni taluꞌen. ");
INSERT INTO syb_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Pipiidpiidan iin, kanaꞌ bantang su ginukuman diniin. Ndaꞌi mekengasal dunig liwaten, puꞌ pipeleki gumulen.” ");
INSERT INTO syb_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Laung nu getaw Etiopia dini Felipe, “Naa saꞌ megdadi, ki sinulat kini, pesuun mu dinaan saꞌ taꞌ taway duni misugat ini nu pimuunan nu Megbebayaꞌ. Iinen da su suminulat dun, atawaka lain tawan saan?” ");
INSERT INTO syb_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Mendadi si Felipe, pikpuunanen pegweliay su sinulat kia, dayunen pegukit dia trisuriru su Gempia Petenday mekatag dini Isus. ");
INSERT INTO syb_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Naa mukaꞌ kebaal nilan mundas dia karsada, midepet nailan di tubig. Miktaluꞌ su trisuriru, “Naa, tayay pa daan, duuni tubig. Mabuꞌ megdadi, bunaganu tubig.” ");
INSERT INTO syb_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Kaliꞌ sembag si Felipe, “Megdadi da bunagan ka dun, saꞌ gelaꞌen mui ginaa mu di kekpetuud mu.” Kaliꞌ sembag, “Aa, naa, mikpetuudu lai. Mituudanu dun puꞌ si Isukristu, iinig Bataꞌ nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Pitenlen dayun nu trisuriru su prada. Minaug ilan duaꞌ, dayun minlusad ilan tu tubig. Binunagan dayun ni Felipe su trisuriru. ");
INSERT INTO syb_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Benaꞌ guminawen ilan dia tubig, inabay dayun si Felipe nug Balakat nu Megbebayaꞌ megawaꞌ dia. Ndaꞌ na maitaꞌ nu trisuriru. Minundas nain, mipatiꞌ na leliagay. ");
INSERT INTO syb_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Naa si Felipe, dia na mitandaꞌ lunsud Asoto. Genat diag Asoto, minundas tu Cesarea. Adin su ngag linunsudan gembiananen, pengukiten ni Felipe dia su Gempia Petenday. ");
INSERT INTO syb_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Laak si Saulo kiin, penemalanen sidaꞌay su nga sakup nu Kaunutan si Isus, pemetainen ilan sia. ");
INSERT INTO syb_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Saꞌ maꞌnia, miditu si Saulo Tampusan Metaas Belian nu getaw Judea, minengi diniin sulat uitenen tu nga kaunutan di nga simbaan nu getaw Judea tug lunsud Damasco, adun saꞌ duuni maitaꞌen dia, sakup nug Bianan nu Kaunutan si Isus, daapenen sia libun laki, penguitenen dayun puliꞌ ditu Jerusalem. ");
INSERT INTO syb_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Naa mendadi kini si Saulo, saꞌ sungu na mesebang diag lunsud Damasco kia, masiꞌ mitiagan tekaw tiag genat tug langit. ");
INSERT INTO syb_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Mibelilid diag lupaꞌ si Saulo, mukaꞌ duuni midengegen taluꞌ, laungen, “Saulo! Mauma dema peglegetan mau?” ");
INSERT INTO syb_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","“Sir, taꞌ taway dun ka?” sinaak ni Saulo. Kaliꞌ sembag su pektaluꞌ kia, “Naan laꞌa si Isus, su peglegetan mu. ");
INSERT INTO syb_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Naa pegbuata, bundasa diag lunsud kia. Saꞌ mateng ka, teluꞌan ka dayun taꞌ alanduni gempia baalen mu.” ");
INSERT INTO syb_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Naa su nga tendug ni Saulo, tuminlen ilan, ndaꞌ ilan pektaluꞌtaluꞌ, puꞌ midengeg nilan ki tingeg kia, laak ndaꞌi minitaꞌ nilan. ");
INSERT INTO syb_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Migbuat si Saulo, laak benaꞌ mingmata, masiꞌ ndiꞌ mekengitaꞌ. Kaas inulipit laak nu ngag dumanen mundas diag Damasco. ");
INSERT INTO syb_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Telu gebii ndiꞌ mekengitaꞌ, ndaꞌ na aan mukaꞌ ndaꞌ na inum. ");
INSERT INTO syb_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Naa duuni sakup ni Isus diag Damasco, ngalanen si Ananias. Mendadi kini si Ananias, mikpaitaꞌ gupia diniin su Kaunutan si Isus. “Ananias! sinabi ni Isus.” “Uu Kaunutan, keni dau,” laung ni Ananias. ");
INSERT INTO syb_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Kaliꞌ pektaluꞌ si Isus diniin, “Pegbuata, angaya ditu karsada piningalan dun Su Melegdeng Karsada. Laaway mu dayun diag balay ni Judasi sala tawan getaw Tarso, ngalanen si Saulo. Puꞌ iin, menenabi, ");
INSERT INTO syb_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","mukaꞌ duuni pinitaꞌ diniin nu Megbebayaꞌ getaw sumiled dia suguden, ngalanen si Ananias, megdepen diniin adun mekengitaꞌ puliꞌ.” ");
INSERT INTO syb_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Dagid kaliꞌ sembag si Ananias, “Uu Kaunutan, melaun migukit dinaan mekatag dini Saulo kiin, pilaatanen daw gupia su piglegetawan mu ditu Jerusalem. ");
INSERT INTO syb_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Mukaꞌ bigayan daw nu nga kaunutan nug belian pegbayaꞌen, daapenen sug launan mekpaingabang diniꞌa.” ");
INSERT INTO syb_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Dagid sumimbag su Kaunutan si Isus, “Panawa dema tuꞌu tu niin, puꞌ si Saulo kia, pimiliꞌu mbaal sesuguꞌen ku megukit mekatag dinaan tu nga kanaꞌ getaw Judea, tu nga gadiꞌ, sampay tu nga getaw Israel dadema. ");
INSERT INTO syb_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mukaꞌ pagid paitaꞌu pa diniin ki kelegenay mbiananen meksekat di kesakupen dinaan.” ");
INSERT INTO syb_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Saꞌ maꞌnia, mipanaw dayun si Ananias. Benaꞌ minateng mukaꞌ sumiled diag balay kia, dipenanen dayun si Saulo. Miktaluꞌ diniin si Ananias, “Uu Mimated Saulo, sinuguꞌu nu Kaunutan si Isus, su mituaꞌ diniꞌa dia karsada su kepanaw mu dini. Naa, iini sinuguꞌu niin medini niꞌa, adun mekengitaꞌa puliꞌ, dakus pengepuꞌan ka nug Balakat nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Mitekaw dayun mawaꞌ ki mamaꞌ gunap sedaꞌ mitabun dia mata ni Saulo, mikengitaꞌ puliꞌ. Suminambut megbuat, mikpebunag dayun tubig. ");
INSERT INTO syb_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Tubus itu minaan si Saulo, dayun mipuliꞌ su sekegen. Mendadi genat itu migbebenwa si Saulo santaꞌ gebii dia nga sakup ni Isus diag Damasco. ");
INSERT INTO syb_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Miditu dayun nga simbaan nu getaw Judea, pingukiten dia puꞌ si Isus, iin sug Bataꞌ nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Naa sug launan mikedengeg di taluꞌ ni Saulo, misebuꞌan ilan gupia, laung nilan, “Kanaꞌ bain nu migleget gupia tu nga mekpaingabang dini Isus ditu Jerusalem? Mukaꞌ kanaꞌ baini midini dun, puꞌ adun daapenen siai nga mikpetuud dini Isus, adun uitenen ditu gedapan nu nga kaunutan nug belian ta ditu Jerusalem?” ");
INSERT INTO syb_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Dagid migdugang laaki ginuung ni Saulo megukit, kaas ndiꞌ maulakan nu nga getaw Judea megbenwa diag Damasco. Pinepet dinilan ni Saulo puꞌ si Isus, iin su Tinduꞌ nu Megbebayaꞌ Meglekaunutan. ");
INSERT INTO syb_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Mendadi benaꞌ santaꞌ gebii, ki nga getaw Judea kini, mikpasad ilan petain nilan si Saulo. ");
INSERT INTO syb_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Dagid duuni getaw mikpesuun dun dini Saulo. Naa gebii gendaw, pegingaten nu getaw Judea su nga gengaꞌan nug lunsud Damasco, adun epaꞌen nilan sia petayay si Saulo. ");
INSERT INTO syb_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Laak dagid duuni gebii, kaliꞌ pegleketau su nga sakup ni Saulo, iwit nilan iin tu gembagel dending nug lunsud kia, inisen nilan dig bukag, dayun nilan tentunay diag liu si Saulo. ");
INSERT INTO syb_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Mendadi, minuliꞌ na pelum ditu Jerusalem si Saulo, minampuꞌ dayun sia dia nga sakup ni Isus. Dagid mendek ilan diniin, puꞌ ndaꞌ ilan metuuday dun puꞌ suminakup nain dini Isus. ");
INSERT INTO syb_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Dagid si Bernabe, suminugut dini Saulo. Iwit ni Bernabe si Saulo ditu nga peneligan ni Isus, inukiten dinilan su kekitaꞌ ni Saulo ditu Kaunutan dia karsada, su kangayen kiin ditug Damasco. Inukit pagid ni Bernabe dinilan su kekabit nu Kaunutan diniin, sampay su kenibeluꞌ ni Saulo mengukit mekatag dini Isus ditug Damasco. ");
INSERT INTO syb_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Saꞌ maꞌnia, migduma si Saulo dia nga peneligan ni Isus dia Jerusalem. Minibeluꞌ gupia si Saulo megukit mekatag di Kaunutan. ");
INSERT INTO syb_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Dagid saꞌ miglantugiꞌ si Saulo di nga getaw Judea mektaluꞌ pikebitan nu getaw Grecia, ilan kini, petain nilan sia si Saulo. ");
INSERT INTO syb_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Benaꞌ misuunan nu kepetedan sug delendeman nu getaw Judea kia, iwit nilan si Saulo tu Cesarea, dayun pibundas nilan peleguyay tu Tarso. ");
INSERT INTO syb_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Maꞌantu, su tibuuk pikumpungan nu nga sakup ni Isus, ndaꞌ nai megleget dun dig liwagan Judea, Galilea, mukaꞌ Samaria. Kagina pinguliksegan ilan nug Balakat nu Megbebayaꞌ, migisegi sinuunan nilan di kekpetuud, minamal ilan megbasa tu Megbebayaꞌ mukaꞌ migdugang ilan. ");
INSERT INTO syb_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Naa si Pedro, sabaꞌen mengepitan tu nga sakup ni Isus di ngag lunsud, minateng diag Lida, mingumbelayan tu piglegetawan nu Megbebayaꞌ dia. ");
INSERT INTO syb_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Mendadi duuni mipekitaꞌen getaw dia, ngalanen si Eneas, mipilung, walu taun ndaꞌ siben pekegbuat diag belilidanen. ");
INSERT INTO syb_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Kaliꞌ pektaluꞌ si Pedro diniin, “Naa Eneas, pauliꞌan ka ni Isukristu. Pegbuata, pengikpesay muig belilidan mu kiin.” Dayun pegbuat si Eneas. ");
INSERT INTO syb_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Naa su ngag launan getaw pegbenwa diag Lida mukaꞌ di Saron, benaꞌ minitaꞌ nilan si Eneas mikepanaw na, miagak ilan dayun sumakup tu Kaunutan si Isus. ");
INSERT INTO syb_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Naa duunig libun ditug lunsud Jope mikpetuud dini Isus, ngalanen si Tabita. (Di pikebitan nu getaw Grecia, si Dorcas, maꞌananen gusa.) Kini si Tabita, pinemalanen pepianay su nga getaw, pegebanganen su nga pubri. ");
INSERT INTO syb_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mendadi mitaang dun, migladu si Tabita, dayun minatay. Benaꞌ mitubus nu ngag dumanen ugasay, bitang nilan sug bangkayen di sugud diag ditaas. ");
INSERT INTO syb_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Naa sug lunsud Jope kia, mesempel diag Lida. Mendadi benaꞌ midengeg nu nga sakup dia Jope puꞌ diag Lida si Pedro, suminuguꞌ ilan duaꞌ tawan, pimuun nilan dini Pedro, “Kelelaat pediniin ka nami deliꞌ.” ");
INSERT INTO syb_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Saꞌ maꞌnia, mingikpes si Pedro, migdunut tuꞌu dinilan. Benaꞌ minateng dia Jope, pibundas si Pedro dia sugud diag ditaas. Mikpungun dayun dini Pedro su kelaun balulibun. Pekelegenan ilan gupia, pinitaꞌ nilan pagid dini Pedro su nga suub mukaꞌ duma penepeten pimenaiꞌ ni Tabita su tetubuꞌ pa. ");
INSERT INTO syb_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Mendadi, piawaꞌ ni Pedro dia sugud sug launan getaw. Minginlulud dayun si Pedro menenabi. Benaꞌ mitubus menenabi, liningay ni Pedro kig bangkay kia, kaliꞌ peksabi, “Tabita, pegbuata!” Mingmata si Tabita. Minitaꞌen si Pedro, dayun migbuat. ");
INSERT INTO syb_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Inulagak ni Pedro megindeg. Dayun sebiay ni Pedro su nga kelaun mikpetuud kampuꞌ nu ngag balulibun, pigwakilen dayun dinilan si Tabita, mitubuꞌ na puliꞌ. ");
INSERT INTO syb_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Mileep dayun diag lunsud Jope su gukiten dun. Melaun dayun mikpetuud tu Kaunutan si Isus. ");
INSERT INTO syb_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Si Pedro, migbebenwa pa santaꞌ gebii dia Jope diag balay ni Simon, getaw meninaꞌ panit. ");
INSERT INTO syb_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Naa duuni getaw tu Cesarea, ngalanen si Cornelio, kaunutan nu pikumpungan sundalu nu getaw Roma piningalan dun “Su Pikumpungan nu Getaw Italia.” ");
INSERT INTO syb_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kini si Cornelio, mikpetuud gupia tu Megbebayaꞌ. Pia kanaꞌ getaw Judea, migbasa tu Megbebayaꞌ, sampay su nga gapenen. Tatapen pemegayay su nga getaw Judea, mukaꞌ menamal menenabi tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Mendadi duuni gendaw, ginengaꞌ menaugi gendaw, duuni sesuguꞌen nu Megbebayaꞌ getaw langit pinitaꞌ masiꞌ nu Megbebayaꞌ dini Cornelio, mituaꞌ dia suguden. Kaliꞌ peksabi su getaw langit, “Cornelio!” ");
INSERT INTO syb_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Si Cornelio, tintengen su getaw langit, sabaꞌ mindek gupia. Sinaaken diniin, “Sir, taꞌi tuyuꞌ mu sia dinaan?” Kaliꞌ sembag su getaw langit, “Su kenenabi mu mukaꞌ sug betad mu memegay, tilimaꞌ nu Megbebayaꞌ, midelendema niin. ");
INSERT INTO syb_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Mendadi, suguꞌ mui sesuguꞌen mu meditu Jope, adun uiten nilan puliꞌ dinii sala tawan getaw, si Simon, sala ngalanen si Pedro. ");
INSERT INTO syb_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Iin, migbebenwa diag balay nu sala Simon, getaw meninaꞌ panit, dia geksid dagat sug balayen.” ");
INSERT INTO syb_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Naa saꞌ maꞌnia, benaꞌ migawaꞌ dia su getaw langit, miksabi si Cornelio duaꞌ tawan sesuguꞌenen dakus sala tawani sundalu megilak diniin. Su sundalu, migbasa dadema tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Naa benaꞌ inukitan ilan ni Cornelio di mipenggulaula kia, sinuguꞌen ilan tuꞌu mangay ditu Jope. ");
INSERT INTO syb_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Mendadi benaꞌ di sala gendaw, saanan dia pailan dalan su nga sinuguꞌ kia mukaꞌ mesempel nailan tug lunsud Jope, kini si Pedro, minaik tu gatep menenabi, miktui gendaw. ");
INSERT INTO syb_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Naa mukaꞌ migutem na, mauyaꞌanen sia maan. Laak selianen pa megelat gilak, pinitaꞌ masiꞌ nu Megbebayaꞌ diniin maꞌniin ");
INSERT INTO syb_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","mipukaꞌ sug langit, duun dayuni mitentun dia gupiden maꞌniin palas gembagel gumut miketan di paat buuk sunguten. ");
INSERT INTO syb_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Bitang dia su kelaun gininisan metetubuꞌ, sampay mamak mukaꞌ manukmanuk. ");
INSERT INTO syb_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Duun dayuni midengeg ni Pedro taluꞌ, laungen, “Naa, Pedro, pegbuata, titiꞌ mu ki sedaꞌan mu, aan ka dayun!” ");
INSERT INTO syb_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Dagid kaliꞌ sembag si Pedro, “Pelai, uu Kaunutan! Ndaꞌu mainsan aan dun, su melemuꞌan ami dun sampay su ndiꞌ nami maꞌaan nga getaw Judea.” ");
INSERT INTO syb_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Midengeg pa puliꞌ ni Pedro su taluꞌ, laungen, “Adin su tinaluꞌ nu Megbebayaꞌ mpia aanen, ndiꞌ mu teluꞌay ndiꞌ mu maꞌaan.” ");
INSERT INTO syb_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mendadi ki mipenggulaula kia, telu deksuꞌ pa pauliꞌay, dekag pa mibatun na puliꞌ diag langit su gumut. ");
INSERT INTO syb_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Mendadi selian ni Pedro melibuleng di gulugan nu pinitaꞌ diniin kia, mibaangan na nu nga sinuguꞌ ni Cornelio kia sug balay ni Simon, pegindeg nailan dia gengaꞌanen. ");
INSERT INTO syb_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Miksabi ilan dayun, sinaak nilan, “Diin ma pegbebenwa si Simon, sala ngalanen si Pedro?” ");
INSERT INTO syb_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Naa segay ni Pedro megulug sia di pinitaꞌ diniin kia, tiluꞌan masiꞌ iin nug Balakat nu Megbebayaꞌ, laungen, “Pekineega! Duuni telu tawan getaw minateng, pekpenengaun ka nilan. ");
INSERT INTO syb_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Pegbuata, penauga. Ndiꞌa pegalangalang megdunut dinilan, puꞌ naani suminuguꞌ dinilan.” ");
INSERT INTO syb_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Saꞌ maꞌnia, minaug dayun si Pedro, laungen ditu telu tawan kia, “Mabuꞌ naani pekpenengaun niu. Taꞌ mai tuyuꞌ niu dinaan?” ");
INSERT INTO syb_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Kaliꞌ ilan sembag, “Sinuguꞌ ami nu kaunutan nami si Cornelio. Si Cornelio kiin, mekesuun getaw. Pigbesaanen su Megbebayaꞌ, mukaꞌ inal dain dema nu kelaun getaw Judea. Naa, duuni sesuguꞌen nu Megbebayaꞌ getaw langit miktaluꞌ diniin puꞌ inggaten ka nami meditug balayen, puꞌ adun medengegen ki gukiten mu.” ");
INSERT INTO syb_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Saꞌ maꞌnia, piseled ilan ni Pedro, adun mektulug pailan dia gebii kia. Naa benaꞌ miglegendaw, mingikpes si Pedro, tumindug dayun dinilan mpanaw. Duun dademai nga getaw Jope migdunut dinilan, nga kepetedan nilan. Naa si Cornelio kia, saananen mekpedateng dinilan, inggateni ngag betaꞌanen mukaꞌ nga sambaten mekpungun diag balayen. ");
INSERT INTO syb_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Benaꞌ puliꞌ gendaw, minateng si nga Pedro dia Cesarea. ");
INSERT INTO syb_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Benaꞌ sungu metulan diag balay si Pedro, sinungkak dayun ni Cornelio, miglaub si Cornelio dia gedapanen, luminuꞌud dayun diniin. ");
INSERT INTO syb_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Laak dagid inulagak ni Pedro, laungen diniin, “Pegindega, puꞌ sama kilawan mau da laak.” ");
INSERT INTO syb_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Selian nilan megabitabit, minundas si Pedro dia seled, minitaꞌen su melaun getaw mipungun dia. ");
INSERT INTO syb_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Kaliꞌ pektaluꞌ si Pedro dinilan, “Mendadi yamu nu nga getaw, suunan niu puꞌ binandu diag betad dinami nu nga getaw Judea, lumamug tu getaw dig lain bansa atawaka mengumbelayan dun. Dagid pisuun na dinaan nu Megbebayaꞌ, subay ndaꞌi getaw pemilangen ku milemuꞌan atawaka kanaꞌ penembaꞌen nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kaas saꞌ piangayu ni Cornelio, ndaꞌu belibaday. Naa mendadi, uu Cornelio, saꞌ maꞌantu, taꞌ mai tuyuꞌ mu dinaan?” ");
INSERT INTO syb_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kaliꞌ sembag si Cornelio, “Naa, paat gebii na nandaw genat kenenabiu diag balayu, ginengaꞌ menaugi gendaw. Mendadi saanan ku menenabi, mitekaw duuni getaw mituaꞌ di gedapan ku, tumiagi penepetenen, ");
INSERT INTO syb_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","miktaluꞌ dinaan, ‘Cornelio! Tilimaꞌ nu Megbebayaꞌ su kenenabi mu, mukaꞌ pingebeten su kepepia mu tu nga getaw. ");
INSERT INTO syb_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Naa saꞌ maꞌantu, suguꞌ mui getaw mangay ditu Jope, ditu ni Simon sala ngalanen si Pedro. Migbebenwa diag balay nu sala Simon, getaw meninaꞌ panit dia geksid dagat.’ ");
INSERT INTO syb_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kaas iini miksabiu dun diniꞌa ganam,” maaꞌ laung pa ni Cornelio. “Naa milelaata dinaan, puꞌ minangaya dini. Mendadi, dini nami gedapan nu Megbebayaꞌ, ki tibuuk pikpungunan nami, adun kineegan nami su gikteb nu pitaluꞌ nu Megbebayaꞌ diniꞌa.” ");
INSERT INTO syb_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Mendadi, kaliꞌ pektaluꞌ si Pedro, “Aa naa, minget misuunan ku na, ndaꞌig lingken petailen nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Adin su megbasa diniin mukaꞌ menggulaula melengas, pia taꞌ bensaay dun, duaten iin nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Mendadi, misuunan niu ki tinaluꞌ nu Megbebayaꞌ dinami nga getaw Israel, ki Gempia Petenday, ki kepeseksud di getaw tu Megbebayaꞌ pebian dini Isukristu, su Kaunutan nu tibaꞌan getaw. ");
INSERT INTO syb_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Suunan niu puꞌ dekag miktituluꞌ si Juan mekatag di kekpebunag tubig, duuni mekesalebuꞌ mipenggulaula diag liwagan Galilea sampay Judea. ");
INSERT INTO syb_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Midengeg niu si Isus getaw Nazaret, sug bigayan nu Megbebayaꞌ Balakaten mukaꞌ ginuungen. Kini si Isus, lineepen su tibuuk benwa Judea, pipiananen su nga getaw mukaꞌ pineguliꞌanen su nga pilegetan nu Palin, puꞌ ibangan iin nu Megbebayaꞌ.” ");
INSERT INTO syb_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Laung padun ni Pedro, “Mendadi, sug launan pinggulaula ni Isus dia Judea mukaꞌ ditu Jerusalem, yamii miketakesiꞌ dun. Dagid kini si Isus, pinatay nu nga getaw Judea, linansang nilan di kurus. ");
INSERT INTO syb_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Benaꞌ di ketelu endawen, pitubuꞌ puliꞌ iin, pitubuꞌ nu Megbebayaꞌ, mukaꞌ pinitaꞌ pa pagid nu Megbebayaꞌ di getaw. ");
INSERT INTO syb_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ndaꞌen paitaꞌ di tibaꞌan getaw, pinitaꞌen laak di ngag daansamaꞌ mipemiliꞌen, saꞌitada dinami nu nga miksalu dema diniin maan mukaꞌ minum, su ketubuꞌen puliꞌ. ");
INSERT INTO syb_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Yami demai sinuguꞌen megukit dun ki Gempia Petenday tu nga getaw dakus megukit dun puꞌ iini tinduꞌ nu Megbebayaꞌ mengukum ditu tibaꞌan getaw tetubuꞌ saꞌ minatay. ");
INSERT INTO syb_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Iin dademai tinakesiꞌan nu kelaun pimuunan nu Megbebayaꞌ dengantu, sinulat nilan ditu Misulat Taluꞌen puꞌ adin su mekpetuud dini Isus, pedesunen nu Megbebayaꞌ su salaꞌen, sabaꞌ nu pegbayaꞌ ni Isus.” ");
INSERT INTO syb_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Mendadi selian ni Pedro megukit, mitekaw pengepuꞌay nug Balakat nu Megbebayaꞌ ki kelaunan mikineeg di pitendayen kia. ");
INSERT INTO syb_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Su nga getaw Judea mikpetuud dini Isus tumindug dini Pedro genat ditu Jope, misebuꞌan ilan dun dayun, kagina ki kanaꞌ getaw Judea, bigay dadema nu Megbebayaꞌ dinilan pingepuꞌan ilan nug Balakaten. ");
INSERT INTO syb_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Puꞌ midengeg nilan su nga kanaꞌ getaw Judea kia, mipalin su pikebitan nilan, dakus inal nilan su Megbebayaꞌ. Kaliꞌ pektaluꞌ si Pedro, ");
INSERT INTO syb_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Naa ki nga getaw kini, pingepuꞌan nailan nug Balakat nu Megbebayaꞌ, maaꞌ dadema gupia dinita. Mendadi kagina maꞌantu, duun bai mekebelibad dun, bunagan nailan tubig?” ");
INSERT INTO syb_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Saꞌ maꞌnia, suminuguꞌ dayun si Pedro, bunagan ilan tubig tuꞌus di kesakup nilan dini Isukristu. Tubus itu, ginuut ni nga Cornelio si Pedro, ndiꞌ pa deliꞌ muliꞌ di nga santaꞌ gebii. ");
INSERT INTO syb_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Naa midengeg nu nga peneligan ni Isus mukaꞌ nu ngag duma mimated ditu Judea puꞌ ki nga kanaꞌ getaw Judea, mitelimaꞌ nilan dadema su taluꞌ nu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Mendadi benaꞌ midengeg nilan, sug duma sakup, teluꞌen nilan dayun puꞌ ki nga kanaꞌ getaw Judea kia suminakup na, subay sirkunsisuun dailan dema. Saꞌ maꞌantu, ilan kini, benaꞌ minateng puliꞌ si Pedro ditu Jerusalem, pigbensi nilan si Pedro, laung nilan diniin, ");
INSERT INTO syb_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Mauma dema mingumbelayan ka ma ditu nga kanaꞌ getaw Judea, su ndaꞌ mesirkunsisu? Mauma dema dumingan ka padun maan dinilan?” ");
INSERT INTO syb_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Saꞌ maꞌnia, gilaꞌ dayun ni Pedro pegukit dinilan su kelaun mipenggulaula genat tu pikpuunanen. ");
INSERT INTO syb_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Kaliꞌ pektaluꞌ si Pedro, “Mendadi, su ditu pau lunsud Jope, minenabiu, mitekaw duun masiꞌi pinitaꞌ nu Megbebayaꞌ dinaan. Minitaꞌu duuni mitentun genat tug langit maꞌniin palas gumut miketan di paat buuk sunguten, mitenaꞌ dia gedapan ku. ");
INSERT INTO syb_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Saꞌ pigipusu diag dialem, minitaꞌu ki nga gininisan metetubuꞌ medengen saꞌ malig, nga mamak sampay manukmanuk. ");
INSERT INTO syb_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Midengegu dayuni taluꞌ, laungen, ‘Naa, Pedro, pegbuata, titiꞌ mu ki sedaꞌan mu, aan ka dayun!’ ");
INSERT INTO syb_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Dagid simbagu, ‘Plai, uu Kaunutan! Ndaꞌu mainsan aan dun, su melemuꞌan ami dun sampay su ndiꞌ nami maꞌaan nga getaw Judea.’ ");
INSERT INTO syb_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Midengegu pa puliꞌ su miktaluꞌ,” maaꞌ laung padun ni Pedro. “Laung nu miktaluꞌ, ‘Adin su tinaluꞌ nu Megbebayaꞌ maꞌaan, ndiꞌ mu teluꞌay ndiꞌ mu maꞌaan.’ ");
INSERT INTO syb_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mendadi ki mipenggulaula kia, telu deksuꞌ pa pauliꞌay, dekag pa mibatun na puliꞌ ditug langit sug launanen kia. ");
INSERT INTO syb_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Mendadi su kebatun dun puliꞌ tug langit, iin dademai kedateng nu telu tawan diag balay pektulugan ku. Sinuguꞌ ilan nu sala tawan kaunutan sundalu dia Cesarea, meditu ilan naan. ");
INSERT INTO syb_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Mukaꞌ tiluꞌanu nug Balakat nu Megbebayaꞌ, ndiꞌu mekalangalang megdunut dinilan. Saꞌ maꞌantu, tumindug dadema dinaan meditu Cesareai nga genem tawan kepetedan ta kini, miditu ami balay nu getaw suminuguꞌ dinilan, si Cornelio. ");
INSERT INTO syb_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Benaꞌ minateng ami ditu, tinaluꞌ ni Cornelio dinami puꞌ duun masiꞌi minitaꞌen getaw langit pegindeg diag dialem balayen. Miktaluꞌ daw diniin su getaw langit, ‘Suguꞌ mui getaw mangay ditu Jope, ditu ni Simon sala ngalanen si Pedro. ");
INSERT INTO syb_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Iin nai mekpetenday diniꞌa dig bian nu kegawen mu, kampuꞌ nu kelaun gapen mu.’” ");
INSERT INTO syb_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Laung pa ni Pedro, “Naa mendadi, benaꞌ mikpuunu mekpetenday dinilan, ilan kiin, pingepuꞌan ilan dayun nug Balakat nu Megbebayaꞌ, maaꞌ dadema gupia dinita sug diin kiin. ");
INSERT INTO syb_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Midelendemu dayun su tinaluꞌ begudiin nu Kaunutan si Isus, laungen, ‘Si Juan, migbunag laak tubig di nga getaw. Dagid yamu, bunagen diniu kig Balakat nu Megbebayaꞌ.’ ");
INSERT INTO syb_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Naa mendadi gempantek,” maaꞌ laung padun ni Pedro, “ki nga kanaꞌ getaw Judea, pisama nu Megbebayaꞌ sug bigayen dinilan ditug bigayen dinita sug diin kiin, su mikpetuud ita tu Kaunutan ta si Isukristu. Naa kagina maꞌantu, naan, kanaꞌu memaag ditu Megbebayaꞌ!” ");
INSERT INTO syb_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Naa, su nga getaw migbensi dini Pedro kia, benaꞌ midengeg nilan su tinaluꞌen kia, misikpaꞌ ilan dayun mektaluꞌ. Inal nilan su Megbebayaꞌ, laung nilan, “Mendadi saꞌ maꞌantu, masiꞌ ki nga kanaꞌ getaw Judea, bigay pagid nu Megbebayaꞌ dinilan keksikesuun nilan mukaꞌ kepeduma nilan tu ketubuꞌ ndaꞌi tamanen!” ");
INSERT INTO syb_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Naa genat tu kepatay kiin ni Esteban, pinemalan peglegetay su nga sakup ni Isus. Saꞌ maꞌantu, mipelak ilan, duuni midepet tu Fenicia, duuni midepet tu puluꞌ Cipre, mukaꞌ duun dademai midepet tug Antioquia. Adin su midepetan nilan, migukit ilan taluꞌ nu Megbebayaꞌ dia, iin laaki inukitan nilan dun su nga getaw Judea. ");
INSERT INTO syb_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Laak diag Antioquia, duuni nga ginukitan nilan dun kanaꞌ getaw Judea. Inukit dinilan nu nga sakup ni Isus genat ditu Cipre mukaꞌ ditu Cirene su Gempia Petenday mekatag di Kaunutan si Isus. ");
INSERT INTO syb_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Kagina bigayan nu Kaunutan Megbebayaꞌ ginuung su migukit dun, melaun gupia getaw mikpetuud mukaꞌ luminingay tu Megbebayaꞌ. ");
INSERT INTO syb_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Naa su pikumpungan nu nga sakup ni Isus ditu Jerusalem, saꞌ midengeg nilan puꞌ mikpetuud na su nga kanaꞌ getaw Judea, sinuguꞌ nilan si Bernabe mangay ditug Antioquia. ");
INSERT INTO syb_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Benaꞌ minateng ditu si Bernabe mukaꞌ misimaꞌen puꞌ tinulung tuꞌu nu Megbebayaꞌ su nga sakup ni Isus kanaꞌ getaw Judea, liliag dayun gupia si Bernabe. Tinituluꞌ ni Bernabe dinilan, launan nilan, gelaꞌen nilani ginaa nilan tu kesalig nilan tu Kaunutan. ");
INSERT INTO syb_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Puꞌ si Bernabe kia, mekesuun getaw, pingepuꞌan gupia nug Balakat nu Megbebayaꞌ, sampay suminalig gupia tu Megbebayaꞌ. Saꞌ maꞌnia, melaun getaw Antioquia miagak sumakup tu Kaunutan si Isus. ");
INSERT INTO syb_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Mendadi si Bernabe, mipanaw ditu Tarso, penengaunen si Saulo kiin. ");
INSERT INTO syb_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Benaꞌ mibaanganen, iwiten puliꞌ ditug Antioquia. Setaun ilan dayun mekpungun dia pikumpungan nu sakup ni Isus, minamal ilan mekpetuꞌun di nga melaun gupia getaw ditu. Mukaꞌ iini puunanen, piningalan dun nu nga getaw su nga sakup ni Isus, nga Kristianu. ");
INSERT INTO syb_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Naa saanan nilan diag Antioquia, duuni nga pimuunan nu Megbebayaꞌ minateng genat tu Jerusalem. ");
INSERT INTO syb_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mendadi sala tawan dinilan, ngalanen si Agabo, migindeg adun megyaga. Bigayan nug Balakat nu Megbebayaꞌ ginuung, kaas pisuunen pedaan puꞌ duuni gendaw, mateng pai meliget gutem di tibuuk lumbang. (Kia, minuud di timpu ni Claudio su tampusan gadiꞌ nu getaw Roma.) ");
INSERT INTO syb_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Benaꞌ midengeg nu nga sakup ni Isus diag Antioquia, delendeman nilan dayun, puitan nilan pemegay su nga kepetedan nilan ditu Judea, diadia begayen su gikteb mesukaten. ");
INSERT INTO syb_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Saꞌ maꞌantu, piwit nilan dayun su pemegay nilan tu nga kaunutan nu pikumpungan nu sakup ni Isus ditu Judea, iini migated dun si Bernabe mukaꞌ si Saulo. ");
INSERT INTO syb_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Naa mendadi su timpu kiin, duuni nga sakup ni Isus pilegetan ni Adiꞌ Herodes. ");
INSERT INTO syb_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Pipatay ni Herodes su sala Santiago, pated ni Juan, piputukanen gulu. ");
INSERT INTO syb_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Naa su nga getaw Judea, pinleliag ilan ditu pinggulaula kia ni Herodes. Benaꞌ midengeg ni Herodes puꞌ pinleliag ilan dun, pidaapen padun si Pedro. (Su kedaap diniin, mitaang dig lumpuk nu getaw Judea piningalan dun sug Lumpuk di Pan ndaꞌ Petulinay.) ");
INSERT INTO syb_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Mendadi kini si Pedro, benaꞌ midaap, pinikutan dayun, piꞌingat di paat penunan sundalu. Sala penunan, duuni pikpaat tawan. Sug delendeman ni Herodes, ukumenen sia si Pedro ditu gedapan nug launan getaw saꞌ meglinggwang pa sug Lumpuk tug Liniusan. ");
INSERT INTO syb_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Saꞌ maꞌnia, pegingaten pa si Pedro diag dialem pirisuan, laak su pikumpungan nu nga sakup ni Isus, pinenebian nilan namal ditu Megbebayaꞌ si Pedro. ");
INSERT INTO syb_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Naa benaꞌ gebii, saꞌitada sendaw pa su kepeguaꞌ ni Herodes dini Pedro dia pirisuan adun ukumenen, kini si Pedro, pektulug, piktimpangan ingatay duaꞌ tawan sundalu. Binalud si Pedro kadina duaꞌ buuk, mukaꞌ duun pa pagidi sundalu pegingat dia gengaꞌan nu pirisuan. ");
INSERT INTO syb_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Mendadi, tekaw duuni mituaꞌ dini Pedro sesuguꞌen nu Kaunutan Megbebayaꞌ getaw langit, mukaꞌ midelagan su sugud. Dinapiꞌ dayun nu getaw langit si Pedro adun metanud, laungen, “Pegdedaliꞌa pegbuat!” Mitekaw dayun melengaꞌ su ngag balud dia kemet ni Pedro. ");
INSERT INTO syb_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Laung dayun nu getaw langit, “Pegbaling ka mukaꞌ penepatusa.” Mikpetuud dun dayun si Pedro. Laung nu getaw langit, “Peksuuba, dunuta dayun dinaan!” ");
INSERT INTO syb_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Migdunut tuꞌu si Pedro diag liu nu pirisuan. Laak ndaꞌen mesuunay saꞌ mipenggulaula tantu, laungen dun teginepen da laak. ");
INSERT INTO syb_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Mendadi benaꞌ mibianan nilan sug bekna megingat, dayun su keduaꞌ megingat, minateng ilan dayun tu gengaꞌan putaw bianan pangay diag lunsud. Masiꞌ miksipala laak mpukaꞌ su gengaꞌan. Mikeguaꞌ ilan dayun. Benaꞌ mipapas nilan ki sebulus karsada, luminilung dayun su getaw langit. ");
INSERT INTO syb_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Iin pa mitenudan ni Pedro, laungen dig dialem delendemanen, “Aa naa, misuunan ku na puꞌ metuud! Sinuguꞌ tuꞌu nu Kaunutan Megbebayaꞌ su sesuguꞌenen getaw langit gumawen dinaan di gengkeman ni Herodes, sampay di kelaun pedetengen nu nga getaw Judea mpenggulaula sia dinaan.” ");
INSERT INTO syb_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Naa benaꞌ misimaꞌ ni Pedro su mipenggulaula, miditug balay ni Maria, su ginaꞌ ni Juan sala ngalanen si Marcos. Melaun getaw mipungun diag balay kia puꞌ menenabi. ");
INSERT INTO syb_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Mendadi, benaꞌ minateng si Pedro mukaꞌ mikpetelubatik diag liu nu gengaꞌan, duun dayuni sesuguꞌen lumiu dia, delaga ngalanen si Roda, puꞌ pukaꞌanen. ");
INSERT INTO syb_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Miꞌilala ni Roda su tingeg ni Pedro, kaas sumiled dayun puliꞌ, inukiten dia nga minenabi puꞌ pegindeg diag liu si Pedro. Laak sabaꞌ leliagen, ndaꞌen na pukaꞌay su gengaꞌan. ");
INSERT INTO syb_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","“Baa, buꞌangbuꞌang ka!” laung nilan. Laak miglegintuud sug delaga kia. Simbag nilan, “Iini mikpetelubatik su la getaw langit megingat dini Pedro.” ");
INSERT INTO syb_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Mendadi kini si Pedro, laak menamal mekpetelubatik. Tigaꞌwan, pinukaꞌan na nu nga sakup su gengaꞌan, miꞌilala nilan dayun si Pedro. Mipatiꞌ ilan mesebuꞌay diniin. ");
INSERT INTO syb_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Saꞌ maꞌnia, pipengamed ilan ni Pedro, inukiten dayun dinilan su kebeluy diniin nu Kaunutan Megbebayaꞌ dia pirisuan. Diksuꞌ ni Pedro su taluꞌen, “Ukitay niu di kebeluyu si Santiago kampuꞌ nu ngag duma kepetedan ta.” Benaꞌ mideksuꞌ mektaluꞌ si Pedro, gumiwaꞌ dia, minangay tug lain benwa. ");
INSERT INTO syb_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Mendadi su nga sundalu ditu pirisuan, benaꞌ miglegendaw, misasaw ilan gupia saꞌ mikendutaꞌ dun saan si Pedro. ");
INSERT INTO syb_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Si Herodes kia, ndaꞌ nai ndaꞌen maulikaw, sabaꞌen menengaw dini Pedro. Benaꞌ ndiꞌen mbaangay, pinsaakanen su nga migingat dini Pedro, dayunen ilan pepatay. Tubus itu, migawaꞌ si Herodes dia Judea, miditu pelum Cesarea pegbebenwa. ");
INSERT INTO syb_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Naa kini si Herodes, melaat gupiai ginaanen tu getaw Tiro mukaꞌ tu getaw Sidon. Saꞌ maꞌnia, duuni gendaw mikpungun su nga getaw kia, minadap ilan dini Herodes, miksaak ilan diniin kelinaw. Laak mikpaingabang ilan peguna dini Blasto, su pigwekilan ni Herodes. Benaꞌ mituudan dinilan si Blasto, iin pa miksaak ilan dayun tuꞌu dini Herodes kelinaw, puꞌ su ketubuꞌan nilan, genat di peglegediꞌan kia ni Herodes. ");
INSERT INTO syb_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Naa benaꞌ su gendaw na nu sesaꞌen, kini si Herodes, mikseluk pekayan gadiꞌ, migingkud dayun dia gingkudanen gadiꞌ, migagdat dayun tu nga getaw. ");
INSERT INTO syb_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Selian ni Herodes mektaluꞌ, mimeksay su nga getaw, laung nilan, “Ki tingegen kiin, kanaꞌ taluꞌ kilawan, puꞌ taluꞌ diwata!” ");
INSERT INTO syb_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Mitekaw dayun pelebuꞌay nu sesuguꞌen nu Megbebayaꞌ getaw langit si Herodes, sabaꞌ dinawaten su kegenal nu nga getaw diniin, ndaꞌen sungkin pegbesaay su Megbebayaꞌ. Inuled dayun si Herodes mukaꞌ minatay. ");
INSERT INTO syb_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Laak dagid su taluꞌ nu Megbebayaꞌ, minamal mesigwag, minamal dadema megdugang su mikpetuud dun. ");
INSERT INTO syb_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Naa si Bernabe mukaꞌ si Saulo kiin, benaꞌ mitubus na nilan su ginangay nilan dia, mipuliꞌ ilan genat tu Jerusalem, pidunutan nilan si Juan kia, sala ngalanen si Marcos. ");
INSERT INTO syb_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Naa su pikumpungan nu nga sakup ni Isus ditug lunsud Antioquia, duuni nga getaw megwali taluꞌ nu Megbebayaꞌ, mukaꞌ duun dademai nga mekpetuꞌun. Ilan si nga Bernabe, si Simon (piningalan dun si Maitem), si Lucio (getaw Cirene), si Manaen binataꞌ nu gamaꞌ ni Gubirnadur Herodes, mukaꞌ si Saulo. ");
INSERT INTO syb_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ilan kini, duuni gendaw miktamuy ilan ditu Kaunutan mukaꞌ mikpua