﻿USE sofia;
DROP TABLE IF EXISTS sofia.swp_vpl;
CREATE TABLE swp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES swp_vpl WRITE;
INSERT INTO swp_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Bagubagunana eai Eaubada galewa eo tanoubu i hetubudi. ");
INSERT INTO swp_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Tanoubu nige ana ao, eo aha’ahana, eo gabogabo potana eai masigiri mo; na Eaubada Earuana gabogabo wa i moimoiutawaidi. ");
INSERT INTO swp_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Na Eaubada i ene, “Bena i mara;” to ie mara. ");
INSERT INTO swp_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Eaubada mara wa ie ita i lolo; eo Eaubada masigiri arinai mara wa i torehesuara. ");
INSERT INTO swp_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Marana wa Eaubada esana ie tore Asubena, eo masigiri wa esana ie tore Maiona. Abo maimailahi, eo maratomtom, asubena bagubagunana. ");
INSERT INTO swp_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Abo Eaubada i ene, “Galewa tehana abo goila duaduaridi eai, abo goila i soiedi.” ");
INSERT INTO swp_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","To galewa tehana wa Eaubada i ginauri, eo goila tehana wa ubuna eai eo tehana wa ewana eai i tore udoiedi. Hinage doha, ie tubu. ");
INSERT INTO swp_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Eo Eaubada tehana wa esana ie tore Galewa. Abo maimailahi, eo maratomtom asubena helabuina. ");
INSERT INTO swp_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Abo Eaubada i ene, “Bena goila galewa ubuna eai i abigogoi ena aba’ota esega, bena tano pitapitarina i taumasaraha.” Hinage doha, ie tubu. ");
INSERT INTO swp_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Eaubada tano pitapitarina wa esana ie tore Tanoubu, eo goila se he’esegaidi wa esadi ie tore Gabogabo. Eo Eaubada ie ita i lolo. ");
INSERT INTO swp_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Abo Eaubada i ene, “Bena tano ginauri ini’inidi se ini, ma tumadi, eo uaua oeagidi, uauadi se toredi boeadi eai tumadi, esa, esa ano ao i lauwatai tano potana eai.” Hinage doha, ie tubu. ");
INSERT INTO swp_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Tano ginauri ini’indi i he’inidi, ma tumadi adi ao udoi udoi eai, eo oeagi uauadi se toredi, uauadi wa ma tumadi, adi ao udoi udoi se lauwataidi. Eo Eaubada ie ita i lolo. ");
INSERT INTO swp_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Abo maimailahi, eo maratomtom, asubena hehaionana. ");
INSERT INTO swp_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Abo Eaubada i ene, “Galewa tehana eai bena maradi, asubena eo maiona aba‐abi’udoiedi; isi abo heiheinoi, eo huia aba‐nonoidi, asubena eo borimai. ");
INSERT INTO swp_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Eo wau maradi wa galewa tehana eai abo hinage tanoubu se hemara.” Hinage doha, ie tubu. ");
INSERT INTO swp_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Eo Eaubada mara lailaidi labui i hetubudi, lailai aririna bena asubena i tanuagai, mara gagirina bena maiona i tanuagai; ipora hinage i ginauridi. ");
INSERT INTO swp_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Eaubada i toredi galewa tehana eai bena tanoubu se hemara, ");
INSERT INTO swp_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","eo bena asubena eo maiona se tanuagaidi, eo bena mara eo masigiri se soiedi. Eo Eaubada ie ita i lolo. ");
INSERT INTO swp_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Abo maimailahi, eo maratomtom, asubena hehasina. ");
INSERT INTO swp_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Eaubada i ene, “Bena gabogabo ginauri maumauridi eawoidi i hetubudi, eo manu tano ewana eai se loiloiusi galewa tehana eai.” ");
INSERT INTO swp_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Arinai ede Eaubada gabogabo ginauridi lailai didigadi i hetubudi, eo ginauri maumauridi tau moimoiu maudoidi, gabogabo eai taumia, adi ao udoi udoi eai, eo manu mabedi gamagaridi, adi ao udoi udoi eai. Eo Eaubada ie ita i lolo. ");
INSERT INTO swp_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Eo Eaubada i ribahelolodi, i ene, “Au ua, au hegamagarimiu gabogabo goiladi au hemonaudi, manu hinage tano potana eai bena se gamagari.” ");
INSERT INTO swp_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Abo maimailahi, eo maratomtom asubena hehaligigina. ");
INSERT INTO swp_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Eaubada i ene, “Bena tano ginauri maumauridi adi ao udoi udoi eai i hetubudi; bulumakau ginauri se daladalausi, suisui udoi udoi adi ao udoi udoi eai.” Hinage doha, ie tubu. ");
INSERT INTO swp_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Eaubada tano suisuidi i hetubudi, adi ao udoi udoi eai, eo bulumakau adi ao udoi udoi eai, eo ginauri maudoidi tano eai se daladalausi esa esa ana ao eai. Eo Eaubada ie ita i lolo. ");
INSERT INTO swp_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Abotai Eaubada i ene, “Bena tau ta hetubu tautauda eai, eo ada ao eai; eo isi bena gabogabo eamadi se tanuagaidi, eo eada manudi, eo bulumakau, eo tano maudoina, eo ginauri gamagaridi tano eai tau‐daladalausi.” ");
INSERT INTO swp_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Arinai ede Eaubada tau i hetubu iabom tautauna eai tau i hetubu, tau eo sine i hetubudi. ");
INSERT INTO swp_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Eo Eaubada i ribahelolodi, eo Eaubada i ribalau aridi eai i ene, “Au ua, au hegamagarimiu, tanoubu au hemonau eo tanoubu tanuagaina eai au lau; gabogabo eamadi hinage au tanuagaidi, eada manudi hinage eo ginauri maumauridi gamagaridi isi ede tano potana eai se moimoiu.” ");
INSERT INTO swp_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Eo Eaubada i ene, “Au ita, ginauri ini’inidi gamagaridi tuma se hetuhetubudi, tanoubu maudoina potana eai, isi ede ea lediwa’o, oeagi gamagaridi hinage uauadi eai tumadi; abo au abidi ami aiai. ");
INSERT INTO swp_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Eo tano suisuidi gamagaridi, eo eada manudi eo ginauri gamagaridi tano eai taudala, ginauri maudoidi aridi eai mauri eahuana aridi eai hinage ginauri in’inidi ea mosedi’o adi aiai.” Hinage doha, ie tubu. ");
INSERT INTO swp_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Abo Eaubada ginauri gamagaridi i hetubudi wa ie italau aridi eai, ie ita, se lolo ariri. Abo maimailahi eo maratomtom, asubena hehaligigi‐esegana. ");
INSERT INTO swp_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Doha ina galewa eo tanoubu se heohidi, ginauridi maudoudoidi. ");
INSERT INTO swp_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Na asubena hehaligigi‐labuina eai Eaubada paisoa i paisoaei wa, i heohi, arinai asubena hehaligigi‐labuina eai ana paisoa gamagaridi wa i aiyawasiedi. ");
INSERT INTO swp_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Arinai Eaubada asubena hehaligigi‐labuina i ainauiai eo i hetabuei, paana arinai Eaubada ana paisoa wa i aiyawasiei, ena hetuhetubu paisoana wa. ");
INSERT INTO swp_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Galewa eo tanoubu huia hetubudi wasadi. Asubena eai ne GUIAU Eaubada tanoubu eo galewa i ginauridi. ");
INSERT INTO swp_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Huiana ne sora nige oea ginaurina ini’inina esau tano eai i tubu, eo sora nige oea lagauna i inisaema, paana GUIAU Eaubada sora nige nabu i hetaru tano eai, eo sora nige tau esau tano i giari; ");
INSERT INTO swp_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","na goura mo tano eai ie sae, iaede tano maudoina i hebuta. ");
INSERT INTO swp_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Abotai GUIAU Eaubada tau i hetubu tanoubu muamuana eai, mauri eahuana i eahualau isuna eai; abo tau wa i hemala doga ma earuana maumaurina. ");
INSERT INTO swp_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Abo GUIAU Eaubada oea i umai Edena eai, tupo aruabu eai, temetai abo tau wa ie tore, iaede i ginauri wa. ");
INSERT INTO swp_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Eo tano eai GUIAU Eaubada oeagi gamagaridi i hetubudi, isi ede adi ao se lolo, eo isi hinage aiaidi se lolo; mauri oeagina hinage oea duaduarina eai, eo lolo eo baaea italobaina oeagina hinage. ");
INSERT INTO swp_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Saga esau Edena eai i didipesa, oea wa ana goila, abo i hemala saga hasi. ");
INSERT INTO swp_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Bagubagunana esana Pisona; ia ede i lau Havila tehana maudoina i hetaiiri, temetai gold wa; ");
INSERT INTO swp_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","eanua ne ena gold i lolo dumaduma; bedelium eo onyx we’una hinage metai. ");
INSERT INTO swp_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Saga helabuina esana Gihona; ia ede Kusa oeana maudoina i tauhetaiiri. ");
INSERT INTO swp_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Hehaionana esana ede Hidekela, Asiria tupo aruabuna eai ie lau. Eo saga hehasina ede Euparatea. ");
INSERT INTO swp_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","GUIAU Eaubada tau wa ie abi ie tore Edena oeana eai, bena i giari eo i itawatai. ");
INSERT INTO swp_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","GUIAU Eaubada tau wa i lauhesom, i ene, “Oea ta oeagina gamagaridi uauadi abo au ainapaidi; ");
INSERT INTO swp_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","na lolo eo baaea italobaina oeagina iabom mo taba nige au ai, nei asubenana eai ne au ai abo au mate.” ");
INSERT INTO swp_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Abo GUIAU Eaubada i ene, “Nige i lolo tau iabom mo i mia; ana sagu abo ea ginauri abo i lau loloei.” ");
INSERT INTO swp_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Arinai tano eai GUIAU Eaubada oea suisuidi gamagaridi, eo eada manudi gamagaridi i hetubudi, eo i woeaidima Adamu arinai, ia bena esadi i toredi, eo Adamu wa esa saha i mosedi ginauri maumauridi gamagaridi eai, isi esadi ede. ");
INSERT INTO swp_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Adamu esa i mosedi suisui gamagaridi oea eai taumia; na Adamu iabom sora nige ana sagu mamohoina se lobai. ");
INSERT INTO swp_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Arinai GUIAU Eaubada Adamu i heenomate, ia ma eno‐matena oitarina esau i abihai eo bulumana i hemauuioi; ");
INSERT INTO swp_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","eo wau oitarina wa GUIAU Eaubada tau lisilisina eai i niusihai wa, arinai sine i ginauri, eo i woeaiyama tau arinai. ");
INSERT INTO swp_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Abo Adamu i ene, “Teina abotai ede siadagu siadana, eo bulumagu bulumana; ia esana abo se atai Sine, paana tau arinai se abihaiyama.” ");
INSERT INTO swp_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Arinai ede tau tamana eo sinana abo i laugabaedi i patudidini monena arinai, eo isi se hemala bulumadi esega. ");
INSERT INTO swp_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Wau tau wa ma monena isi taudi labui ma kohakohadi, na nige se taumaeamaea. ");
INSERT INTO swp_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Nuura suisuidi GUIAU Eaubada i hetubudi wa, boeadi eai mota iabom i sonoga ariri. I ribalau sine arinai i ene, “Eaubada i ene taba nige oea ta oeagina uauadi au aidi, wa?” ");
INSERT INTO swp_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Sine i ribalau mota arinai i ene, “Oea ta oeagina uauadi taba ai aidi, ");
INSERT INTO swp_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","na Eaubada i ribaei mo i ene, ‘Oeagi wa oea duaduarina eai i totoro, temeta mo uauana taba nige au ai, hinage taba nige au abilau arinai, ata au mate’.” ");
INSERT INTO swp_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Mota abo i ribalau sine arinai i ene, “Mamohoi taba nige au mate; ");
INSERT INTO swp_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Eaubada abina i ata huiana eai ena omi au ai abo matamiu se lala, abo omi doha Eaubada, lolo eo baaea italobaina abo au italobai.” ");
INSERT INTO swp_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Arinai sine wa ie ita oeagi wa uauana omihede i lolo, ana ao matana eai i lolo, oeagi gadolelehina, paana tau arinai i sibasiba, abo i abilau uauana arinai, to ie ai; tupona i mosei monena arinai ia hinage ie ai. ");
INSERT INTO swp_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Abotai abo tataodi labui se matalala, se italobaiuioidi hede ma kohakohadi. Abo kuhou lugudi se bodigogoidi, edi nogi se ginauridi. ");
INSERT INTO swp_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Abo GUIAU Eaubada dagudaguguna se ataiei, oea eai wa i laulauwaiyo maimailahi wayawayauna eai, Adamu ma monena GUIAU Eaubada matana eai se bawayamui oea wa oeagina boeadi eai. ");
INSERT INTO swp_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Na GUIAU Eaubada i eogalau Adamu arinai i ene, “Oa ede haedi?” ");
INSERT INTO swp_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ia abo i heuioi i ene, “Dagugum ea ataiei oea eai, na ea matausi paana ma kohakohagu ina, arinai ea bawayamui.” ");
INSERT INTO swp_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ia i ene, “Eai i heribam u kohakoha? Oeagi uauana ue ai, wa, iaede ea gorai bena tabu u ai?” ");
INSERT INTO swp_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Tau wa i ene, “Sine u leama ia bena maegu wa, ia oeagi wa uauana i leama, to ea ai.” ");
INSERT INTO swp_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","GUIAU Eaubada sine wa arinai ie riba, i ene: “Saha ina u ginauri ta?” Sine i ene, “Mota i boraigu, to ea ai.” ");
INSERT INTO swp_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","GUIAU Eaubada mota arinai ie riba, i ene; “Paana teina oa u ginauri, ea ribahematem ta suisui gamagaridi eo suisui manamanabaradi boeadi eai; bogam eai abo u nenene, tano muamuana abo u ai, em mauri asubenadi gamagaridi eai. ");
INSERT INTO swp_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Hewaiununa abo ea tore oa eo sine duaduarimiu eai, eo oa tumamyao eo sine tumanayao duaduaridi eai hinage; ia abo urum i utuhegaro, eo oa abo ae gedurina u oihegaro.” ");
INSERT INTO swp_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Sine arinai i ene, “Abi‐merumeru arinai abo em amamna ea hegamagari; amamna boeadi eai abo nanatumyao u labasidi, taiede, em gadosisi abo otana mo monem arinai, ia hinage abo i tanuagaim.” ");
INSERT INTO swp_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Adamu arinai i ene, “Paana monem arinana u ataiei, eo oeagi wa ue ai, ea lauhesom wa, ‘Tabu u ai,’ tano ea ribahebaaea ta debam eai; paisoa amamnana mo abo aiaina u ai em mauri asubenadi gamagaridi eai; ");
INSERT INTO swp_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","nurinuri eo lagau baabaaeadi abo i he’inidiwa; eo oea wa aiaidi se ini iaede abo au aidi. ");
INSERT INTO swp_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Debam muiasana eai aiai abo u ai, i lau e u uio tano arinai, ede tano eai se hetubum wa; oa tano ede, arinai abo u hemalatanouio.” ");
INSERT INTO swp_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adamu monena esana ie tore Eva paana ginauri maumauridi gamagaridi ia sinadi ede. ");
INSERT INTO swp_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","GUIAU Eaubada Adamu ma monena adi lulu suisui opidi eai i ginauridi, eo i heluidi. ");
INSERT INTO swp_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Abo GUIAU Eaubada i ene, “Paana tau i hemala doha ita esau, lolo eo baaea italobaina i italobaiyao, ata nimana i helele mauri oeagina uauana hinage i ai, abo maurina i lau esegai e nige nosina.” ");
INSERT INTO swp_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Arinai GUIAU Eaubada Edena oeana eai i hepesa, i hetamari bena wau tano arinai ia se hetubu wa i giari. ");
INSERT INTO swp_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Arinai tau wa i aiduiei; to oeana tupo aruabu eai serubim esau i hetoro, eo elepa balebalelemna i he’ode tupo gamagari eai, mauri oeagina dobilana wa i taugudui. ");
INSERT INTO swp_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamu monena Eva i nuatui, to ie boga abo Kaina i labasi, i ene, “Tau esau GUIAU arinai ea aabi.” ");
INSERT INTO swp_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Abotai hinage ia ena tau Abela i labasi. Abela abo i hemala mamoe tauitawataina esau, na Kaina ia tano taugiarina. ");
INSERT INTO swp_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Huiana abo ie lage, Kaina oea uauana i leama GUIAU arinai, ena ainauia. ");
INSERT INTO swp_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Na Abela ena mamoe eawoina natu‐ealahoudi, tubutubu‐lolodi i ledima. GUIAU Abela ena ainauia i heasisiei, ");
INSERT INTO swp_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","na Kaina eo ena ainauia nige i nualoloedi. Arinai Kaina i ouyalayala ariri, eo ana ao i hebaaea. ");
INSERT INTO swp_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","GUIAU i ribalau Kaina arinai i ene, “Paana saha u ouyalayala, eo paana saha am ao u hebaaea? ");
INSERT INTO swp_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ena em abi se dudurai, abo se nualoloem, e nige’e? Ena em abi nige se dudurai, baaea dobila eai i wesewesem, ena gadosisi bena i abim, na oa mo bena u saepoini.” ");
INSERT INTO swp_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kaina i ribalau ena tau Abela arinai i ene, “U laoma ta lau oea eai.” Isi taudi labui se lage’o oea eai abo Kaina i toro ena tau Abela i lului abo i eatu’nui. ");
INSERT INTO swp_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","GUIAU abo i ribalau Kaina arinai ie ene, “Em tau Abela wa ia haedi?” I heuio i ene, “Ibai: bena eau egu tau tauitawataina wa?” ");
INSERT INTO swp_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","GUIAU i ene, “Saha ue abi ina? Em tau osinana arinana tano eai i dou‐saema arigu eai. ");
INSERT INTO swp_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Tano wa awana i dabari em tau osinana oa nimam eai ie abi ia ede i ribahematem ta. ");
INSERT INTO swp_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Oa tano abo u giari, iamo adidirina taba nige i leawa’uioi; oa abo taudago eo tauelitata tanoubu eai ta.” ");
INSERT INTO swp_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kaina abo i ribalau GUIAU arinai i ene, “Egu maisa i lai ariri, nige gonoana ea bahei. ");
INSERT INTO swp_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","U ita, wau tano eai ta u aiduiegu; oa matam eai hinage abo ea tauyamui; eau abo taudago eo tauelitata tanoubu eai ta, ena esau i lobaigu abo i unuigu.” ");
INSERT INTO swp_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Abo GUIAU arinai ie riba i ene, “Taba nige’e! Ena taba esau Kaina i unuhemate, ana gum abo i hearo, ma haligigi‐labui.” Abo GUIAU heiheinoina ie tore Kaina arinai, ata tau esau i lobai abo i unui. ");
INSERT INTO swp_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kaina GUIAU matana abo i laugabaei, ia abo Nodi oeana eai ie mia, Edena teha aruabu eai. ");
INSERT INTO swp_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kaina ia monena i nuatui, ia abo ie boga, to Enoka i labasi; abo eanua lailai i hetubu, eanua wa natuna esana i mosei, Enoka. ");
INSERT INTO swp_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoka arinai Irada se labasi; Irada ia Mehuiaele tamana; Mehuiaele ia Metusaela tamana, eo Metusaela ie Lameka tamana. ");
INSERT INTO swp_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameka monenayao labui; esau esana Ada, eo esau Silaha. ");
INSERT INTO swp_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada Iabala i labasi, ia numa‐lulu taumia eo bulumakau tauitawata tamadi ede. ");
INSERT INTO swp_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ena tau esana Iubala; ia huelele tauoi eo baubau tauyuhi tataodi tamadi ede. ");
INSERT INTO swp_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Silaha abo Tubala‐kaina i labasi; ia ena aba‐paisoa poasi, iron eo bronze tauginaurina. Tubala‐kaina louna ede Naama. ");
INSERT INTO swp_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameka i ribalau monenayao aridi eai, “Ada eo Silaha e, arinagu ta au ataiei, Omi Lameka monenayao e, hage egu riba au ataiei: tau esau ea eatu’nui paana agu gai ie tore, hewari esau paana i talaigu: ");
INSERT INTO swp_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ena Kaina ana gum abo ma haligigi‐labui, mamohoi Lameka enana ma tatao‐haiona‐se‐mate‐sau‐doudoi‐haligigi‐labui!” ");
INSERT INTO swp_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Abo Adamu monena i nuatuiuioi, to natuna i labasi esana ie tore Seta, i ene, “Eaubada natugu esau i tauribaei enagu, Abela Kaina i unui wa helaudamaina.” ");
INSERT INTO swp_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seta hinage natuna tau se labasi ia esana Inosi. Meta huia eai ne tatao se hetubu GUIAU esana se atai. ");
INSERT INTO swp_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adamu isina bukana ede ina. Huia ne Eaubada tau i hetubu, Eaubada ana ao eai ia i hetubu. ");
INSERT INTO swp_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","I hetubudi tau eo sine, eo i ainauiaidi, esadi i mosedi Tau, huiana i hetubudi wa. ");
INSERT INTO swp_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adamu ia borimai handere esega, eo tau‐esega‐i‐mate‐saudoudoi, abo i hemala tama, natuna iabom ana ao eai, eo ia tautauna eai, esana wa ie tore Seta. ");
INSERT INTO swp_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Adamu asubenana, huia ne i hemala tama wa murina eai ede borimai handere haligigi‐haiona; nanatunayaao headi tatao eo sisine hinage i labasidi. ");
INSERT INTO swp_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Arinai Adamu ena mauri asubenadi maudoidi ede borimai handere haligigi‐hasi eo tau‐esega‐i‐mate‐saudoudoi; abotai ie mate. ");
INSERT INTO swp_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seta ie mia borimai handere esega eo haligigi, muridi eai abo i hemala Inosi tamana. ");
INSERT INTO swp_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Inosi se labasi wa murina eai Seta ie mia borimai handere haligigi‐haiona eo haligigi‐labui; ia nanatunayao headi tatao eo sisine i abidi hinage. ");
INSERT INTO swp_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Arinai Seta ena mauri asubenadi maudoidi ede borimai handere haligigi‐hasi eo saudoudoi‐labui. Abotai ie mate. ");
INSERT INTO swp_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Inosi ie mia wa borimai tatao‐hasi‐se‐mate‐saudoudoi, abotai i hemala Kenana tamana. ");
INSERT INTO swp_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenana se labasi wa murina eai Inosi borimai handere haligigi‐haiona eo saudoudoi‐haligigi ie mia, eo nanatunayao headi tatao eo sisine ie abidi hinage. ");
INSERT INTO swp_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Arinai Inosi ena mauri asubenadi maudoidi ede handere haligigi‐hasi eo haligigi; abotai ie mate. ");
INSERT INTO swp_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenana ie mia borimaina tatao‐haiona‐se‐mate‐saudoudoi, abo i hemala Mahalalela tamana. ");
INSERT INTO swp_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahalalela se labasi murina eai Kenana ie mia borimai handere haligigi‐haiona eo tatao‐labui‐se‐mate, eo nanatunayao tatao eo sisine headi i abidi. ");
INSERT INTO swp_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Arinai Kenana ena mauri asubenadi maudoidi ede borimai handere haligigi‐hasi eo saudoudoi; abotai ie mate. ");
INSERT INTO swp_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalela ie mia borimaina tatao‐haiona‐se‐matehaligigi, abo i hemala Iareda tamana. ");
INSERT INTO swp_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Iareda se labasi wa murina eai Mahalalela borimai handere haligigi‐haiona eo tau‐esega‐i‐mate‐saudoudoi, eo nanatunayao tatao eo sisine headi i abidi. ");
INSERT INTO swp_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Arinai Mahalalela ena mauri asubenadi maudoidi ede borimai handere haligigi‐haiona eo tatao‐hasi‐se‐mate‐saudoudoihaligigi; abotai abo ie mate. ");
INSERT INTO swp_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Iareda borimai handere esega eo tatao‐haiona‐se‐mate eo labui ie mia, abo i hemala Enoka tamana! ");
INSERT INTO swp_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Enoka se labasi wa murina eai Iareda borimai handere haligigi‐haiona ie mia, eo nanatunayao tatao eo sisine headi i abidi hinage. ");
INSERT INTO swp_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Arinai Iareda ena mauri asubenadi ede borimai handere haligigi‐hasi eo tatao‐haiona‐se‐mate eo labui; abotai ie mate. ");
INSERT INTO swp_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoka borimai tatao‐haiona‐se‐mate eo haligigi ie mia, abo i hemala Metusela tamana. ");
INSERT INTO swp_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Metusela se labasi wa murina eai Enoka Eaubada maena se laulau borimai handerehaiona, eo nanatunayao tatao eo sinine headi i abidi. ");
INSERT INTO swp_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Arinai Enoka ena mauri asubenadi maudoidi ede borimai handere haiona eo tatao‐haiona‐se‐mate eo haligigi. ");
INSERT INTO swp_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoka Eaubada maena se laulau esega, i lau e ia nige’e, paana Eaubada ia i abiya’o. ");
INSERT INTO swp_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela ie mia borimaina handere esega, eo tatao‐hasi‐se‐mate haligigi‐labui, abo i hemala Lameka tamana. ");
INSERT INTO swp_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lameka se labasi wa murina eai Metusela ie mia borimai handere haligigi‐labui eo tatao‐hasi‐se‐mate eo labui, eo nanatunayao tatao eo sisine headi i abidi. ");
INSERT INTO swp_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Arinai Metusela ena mauri asubenadi maudoidi ede borimai handere haligigi‐hasi eo tatao‐haiona‐se‐mate eo haligigi‐hasi; abo ie mate. ");
INSERT INTO swp_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lameka borimai handere esega eo tatao‐hasi‐se‐mate eo labui ie mia, natuna tau esau se labasi. ");
INSERT INTO swp_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","To esana wa ie tore Noa, i ene, “Tano GUIAU i ribahemate wa boeana eai te ina ta abo aba‐aiyawasina i leama, ada paisoa arinai eo nimada edi paipaisoa aridi eai.” ");
INSERT INTO swp_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Noa se labasi wa murina eai Lameka ie mia borimaina handere haligigi eo tatao‐hasi‐semate‐saudoudoi‐haligigi, eo nanatunayao headi, tatao eo sisine i abidi. ");
INSERT INTO swp_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Arinai Lameka ena mauri asubenadi maudoidi ede borimai handere haligigi‐labui eo tatao‐haiona‐se‐mate‐sau‐doudoi‐haligigi‐labui; abo ie mate. ");
INSERT INTO swp_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noa borimai handere haligigi ie mia, abo i hemala Sema, Hama eo Iapeta tamadi. ");
INSERT INTO swp_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Tatao se hetubu se gamagari ariri tanoubu potana eai, eo nanatudiyao sisine se labasidi, ");
INSERT INTO swp_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","abo Eaubada nanatunayao tatao se italau sisine wa aridi eai tatao nanatudiyao se itadi adi ao se lolo; abo headi se abidi monediyao, esa esa ena hinehineri eai. ");
INSERT INTO swp_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Abo GUIAU i ene, “Earuagu taba nige i haiabi da’oi tau nuana eai, ia buluma, ena asubena abo se lau borimai handere esega eo tau‐esega‐i‐mate.” ");
INSERT INTO swp_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Tatao lailaidi tanoubu eai ma miadi nei asubenadi eai ne, huia ne murina eai hinage, Eaubada nanatunayao wa, huia eai ne se laulau tatao nanatudiyao sisine aridi eai, isi abo nanatudiyao se labasidi. Teina tatao ta tatao adiadidiridi ede mumuga eai, eo tatao wasadi se lai. ");
INSERT INTO swp_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","GUIAU tau ena abi baaea tanoubu eai ie ita i lai ariri, eo nuaboeana eai ena itaitasipo eo ena nuanuatu se baaea mo, huia gamagari, ");
INSERT INTO swp_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","GUIAU tau i hetubu tanoubu eai wa i nuadubuei, eo nuana i heamamna aririei. ");
INSERT INTO swp_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Abo GUIAU i ene, “Tau ea hetubu wa abo ea saugabaei tanoubu potana eai, tau eo suisui eo ginauri se daladalausi eo malagaibu manudi, hede nuagu i baaea ea hetubudi wa.” ");
INSERT INTO swp_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Na GUIAU matana eai Noa iabom arinai i nualoloei. ");
INSERT INTO swp_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Noa wa isina ede ina. Noa tau laulau duduraina, isina boeana eai iabom nige giruna; Noa maena Eaubada se laulau esega. ");
INSERT INTO swp_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Eo Noa nanatunayao haiona, Sema, Hama eo Iapeta. ");
INSERT INTO swp_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Tanoubu Eaubada matana eai i posa ariri, eo manamanabara i monau. ");
INSERT INTO swp_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Eaubada tanoubu ie ita, hede ie posa, paana buluma gamagari edi dobila se hebaaea’o tanoubu eai. ");
INSERT INTO swp_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Abo Eaubada Noa arinai ie riba, i ene, “Nuagu bena buluma gamagari ea helautomdi; paana isi debadi eai manamanabara tanoubu i monau; besi, maedi tanoubu abo ea hebaaeadi. ");
INSERT INTO swp_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Oa bena ake enam u ginauri, gopa oeagina eai, aroarona u biliutu’utusidi, murimurina eai eo arona eai tar arinai u aibadini. ");
INSERT INTO swp_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Teina doha abo em abiabina; ake wa lohana bena kubita handere haiona; magagana bena kubita tatao‐labui‐se‐mate‐saudoudoi, eo dedeana saena kubita tau‐esega‐i‐mate saudoudoi. ");
INSERT INTO swp_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Atohina eai tomlapaina abo u ginauri, kubita esega ewana eai u heohi; ake dedeana eai abo gudana u tore; eo matuna esau ubu eai, ewana eai isi helabuina eo hehaionana. ");
INSERT INTO swp_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Paana u ita, eau abo dibori utu’utu lailaididigana ea leama tanoubu eai ta, buluma maudoina arinai abo ea hebaaeadi, saha eo saha mauri eawasina aridi eai, galewa ubuna eai, ginauri gamagari tanoubu potana eai abo se mate. ");
INSERT INTO swp_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Na oa mo arim eai egu aigora abo ea hetoro; oa abo u awasaema ake arona eai, oa eo nanatumyao tatao wa, eo monem, eo nanatumyao monediyao maemyao. ");
INSERT INTO swp_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Eo ginauri maumauridi, buluma udoi udoi, labui to labui abo u ledima ake arona eai, maemyao au mauri, isi abo tamoana eo bawesina. ");
INSERT INTO swp_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Manudi hinage, adi ao udoi udoi eai, suisui adi ao udoi udoi eai, lie udoi udoi, labui to labui, abo u heawasedima, mauridi bena u sogohidi. ");
INSERT INTO swp_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Aiai udoi udoi se aiaidi, hinage adi.” ");
INSERT INTO swp_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noa teina i ginauri; riba maudoina Eaubada i ribahasahasai wa, i ginauri heohidi. ");
INSERT INTO swp_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Abotai GUIAU i ribalau Noa arinai i ene, “U awasae ake arona eai, oa eo maem numa taumia gamagaridi, paana ea itam’o oa tau abidudurai matagu eai, teina isi ta boeana eai. ");
INSERT INTO swp_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Suisui aadi wa abo haligigi‐labui, hari ao, hari ao, tamoana eo bawesina; suisui wa nige se aa, isi labui to labui mo, tamoana eo bawesina. ");
INSERT INTO swp_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Malagaibu manudi hari ao haligigi‐labui, tamoana eo bawesina, arinai edi gorugoru maumauridi se laulau tanoubu potana eai. ");
INSERT INTO swp_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Paana asubena haligigi‐labui eai abo nabu ea hetaru tanoubu potana eai abo asubena tatao‐labui‐se‐mate, maiona tatao‐labui‐se‐mate, i lauesegai; ginauri maumauridi ea ginauridi, gamagaridi abo ea hearugabaedi tano potana eai ta.” ");
INSERT INTO swp_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Abo Noa riba gamagaridi GUIAU i lauhesom wa, i ginauriheohidi. ");
INSERT INTO swp_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa ena borimai handere haligigi‐esega, nei huia ne dibori utu’utu i lagema tanoubu potana eai. ");
INSERT INTO swp_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Abo Noa ma nanatunayao tatao, ma monena, ma nanatunayao wa monediyao, se awasaegogo ake eai dibori utu’utu goilana wa bena se dagoei. ");
INSERT INTO swp_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Suisui aa’aadi, eo suisui nige se aa, ea manu eo ginauri tano eai tau daladalausi, ");
INSERT INTO swp_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","labui labui, tamoana eo bawesina, Noa maena i abiesegaidi ake wa alona eai, doha Eaubada Noa i lauhesom wa. ");
INSERT INTO swp_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Asubena haligigi‐labui muridi eai, abotai abo dibori utu’utu tanoubu i unuhai. ");
INSERT INTO swp_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noa ena borimai handere hehaligigi‐esegana eai, nawalai helabuina eai, nawalai asubenana hesaudoudoi‐haligigi‐labuina eai, temeta asubenana eai ne, goila edi aba‐ota gabotum lailaidi eai se malapai, se boriri saema, eo galewa tomlapaidi se soeauridi. ");
INSERT INTO swp_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Nabu abo i taru esegai, tanoubu potana eai asubena tatao‐labui‐se‐mate eo maiona tatao‐labui‐se‐mate. ");
INSERT INTO swp_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Asubena eai ne Noa ma nanatunayao Sema, Hama, eo Iapeta, eo Noa monena, eo nanatunayao monediyao haiona, se awasae ake eai wa. ");
INSERT INTO swp_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Isi maedi suisui udoi udoi ao udoi udoi eai, eo bulumakau adi ao udoi udoi, eo ginauri tau daladalausi, tano eai adi ao udoi udoi eai hinage, eo manu adi ao udoi udoi, manu gamagaridi wa adi ao eai. ");
INSERT INTO swp_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Se awasae ake alona eai, maedi Noa, buluma maudoina mauri eawasina aridi eai wa, labui to labui se awasae. ");
INSERT INTO swp_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Isi tau awasae, buluma maudoina enadi tamoana eo bawesina, se awasae doha Eaubada i lauhesom wa, abotai GUIAU i birigudui. ");
INSERT INTO swp_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Dibori utu’utu wa i laulau asubena tatao‐labui‐se‐mate tanoubu potana eai; goila tanoubu i laugirihai abo ake wa i lausini, i poupouli, i sae ariri tanoubu ewana eai. ");
INSERT INTO swp_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Goila wa i sae ariri eo tanoubu potana i lau girihai i lau e ake i ahai goila wa potana eai. ");
INSERT INTO swp_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Goila wa i lai ariri eo i didiga tanoubu potana eai i lau e oea tupidi gamagaridi galewa maudoina ubuna eai, i hetauyamuidi. ");
INSERT INTO swp_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Goila i helahelai oea tupidi potadi eai i lau e oea deba pogadi edi gabotum doha kubita saudoudoi‐haligigi. ");
INSERT INTO swp_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Buluma maudoina tanoubu eai se moimoiu ede se mate ohi, manu, bulumakau, suisui, eo ginauri maumauridi eawoidi tanoubu eai se laulau; eo tatao gamagaridi. ");
INSERT INTO swp_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ginauri gamagaridi, tano pitapitarina eai taumia, isudi eai mauri eawasina, se mate. ");
INSERT INTO swp_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ginauri maumauridi tanoubu potana eai ta, i saugabae‐heohidi, tau, suisui, ginauri daladalausidi, malagaibu manudi, tanoubu eai se saugabaedi. Noa iabom ie mia, eo isi wa ia maenayao ake alona eai wa. ");
INSERT INTO swp_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Goila wa tanoubu i laugirihai asubena gamagarina handere esega eo tatao‐labui‐se‐mate‐saudoudoi. ");
INSERT INTO swp_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Na Eaubada Noa i nuatui, eo suisui gamagaridi eo bulumakau gamagaridi ia maena ake eai wa. Abo Eaubada mana i hetoa tanoubu eai, abo goila i hetubu ie dobi; ");
INSERT INTO swp_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","edi aba‐ota gabotum lailaidi eai wa, eo galewa tomlapaidi wa, se gududi, nabu galewa eai se abi‐nuahi. ");
INSERT INTO swp_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Eo huia gamagari magu tanoubu eai i hetubu i laulau. Asubena handere esega eo tatao‐labui‐se‐mate‐saudoudoi adisiga eai goila se dobi’o. ");
INSERT INTO swp_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Eo nawalai hehaligigi‐labuina eai, nawalai asubenana hesaudoudoi‐haligigi‐labuina eai, ake wa ie otadobi Ararata oea tupidi eai. ");
INSERT INTO swp_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Goila wa i dobidobi i lau e nawalai hesaudoudoina eai, nawalai asubenana bagubagunana eai, oea tupidi abotai se taumasaraha. ");
INSERT INTO swp_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Asubena tatao‐labui‐se‐mate muridi eai Noa ake i ginauri wa tomlapaina ie soe. ");
INSERT INTO swp_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ao’ao i heloi; ie loi sae, ie loi dobi i lau e goila tanoubu eai se guma’o. ");
INSERT INTO swp_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Abotai bunebune esau i heloi, bena i ita, goila tanoubu eai se guma’o e sora. ");
INSERT INTO swp_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Na bunebune wa aena nige ena aba‐toa i lobai, arinai ie uioma ake eai, paana goila wa sorana tanoubu maudoina potana eai. Arinai nimana i helele, bunebune wa i abiuioi ia arinai, ake alona eai. ");
INSERT INTO swp_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","I bagibagiuio asubena haligigi‐labui se lau’o, abotai bunebune ake eai wa i hetamariuioi. ");
INSERT INTO swp_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Maimailahi eai bunebune wa i uioma arinai, to ne, awana eai olive luguluguna harihariuna ie losi arinai Noa ie ita, omihede goila se guma’o tanoubu eai. ");
INSERT INTO swp_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Abo i bagibagiuio asubena haligigi‐labui headi se lau’o bunebune wa i heloiuioi, na nige i uioma ia arinai. ");
INSERT INTO swp_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Borimai handere hehaligigi‐esegana eai, nawalai bagubagunana asubenana bagubagunana eai, goila se guma’o tanoubu eai; Noa ake atohina abo i abihai, i italau tanoubu ana ao ie ita, i pitari’o. ");
INSERT INTO swp_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Nawalai helabuina eai, nawalai asubenana tau esega‐i‐mate‐haligigi‐labuina eai, tanoubu abo i pitari mamohoi. ");
INSERT INTO swp_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Abo Eaubada i ribalau Noa arinai, i ene, ");
INSERT INTO swp_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Ake me u pesagabaei, oa ma monem, ma nanatumyao, ma nanatumyao monediyao maemyao. ");
INSERT INTO swp_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ginauri maumauridi arim eai wa, buluma maudoina u woea‐hepesadi, manu, suisui, ginauri daladalausidi tano eai taudaladalausi wa, bena tanoubu eai ta se hegamagariuioidi, eo au ua, au gamagari tanoubu eai ta.” ");
INSERT INTO swp_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Arinai abo Noa ie pesa, ma nanatunayao, ma monena eo nanatunayao ma monediyao. ");
INSERT INTO swp_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Eo suisui gamagamagari, eo ginauri se daladalausi, eo manu udoi udoi, eo ginauri saha tanoubu eai ta se moimoiu, ma bodadi ake se pesagabaei. ");
INSERT INTO swp_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noa abo aitalasam hatahatana i hetoro GUIAU arinai, eo suisui aa’aadi udoi udoi wa, eo manu aa’aadi, esega esega i abidi ena aitalasam hatana eai i gabudi. ");
INSERT INTO swp_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Abo pane lolona GUIAU i ataiei, to GUIAU ia nuana eai i ene, “Taba nige huia esau tano ea ribahemateuioi tau debana eai, paana tau nuana kamanina i baaea mo, ma hewarina eai i laoma; taba nige huia esau ginauri maumauridi gamagaridi ea hebaaeauioidi, doha ea ginauriyao wa. ");
INSERT INTO swp_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Tanoubu ma otana eai, umauma huiana eo masuri huiana, huia gogoma eo huia gigibori, huia siwaro eo borimai, taba nige se lautom.” ");
INSERT INTO swp_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Abo Eaubada Noa mananatunayao i ainauiaidi, aridi eai i ene, “Au ua hegamagari, tanoubu au hemonau. ");
INSERT INTO swp_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Tano suisuina eo malagaibu manuna abo matausimiu eo mae’emiu eai se laulau, ginauri gamagaridi tano eai se daladalausi hinage gabogabo eamana; nimamiu eai ede se lediwa. ");
INSERT INTO swp_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ginauri maumauridi moimoyudi isi abo ami aiai ede, doha hinage ginauri ini’inidi eo ginauri gamagaridi eau ea lediwa’o. ");
INSERT INTO swp_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Taiede taba nige ginauri ma maurina au ai, iaede ma osinana. ");
INSERT INTO swp_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Paana emi mauri osinana abo ea hetala suisui enana hinage abo ea nuatui eo tau enana; tau ena doga ena mauri maisana ede tau ena mauri. ");
INSERT INTO swp_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Aitea tau, tau esau osinana i heboriri, ia osinana hinage tau abo i heboriri; paana Eaubada tau i hetubu iabom tautauna eai. ");
INSERT INTO swp_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Na omi, au ua eo au gamagari, aniomiu bena se tubu ariri tanoubu eai ta, eo arinai bena au tadada.” ");
INSERT INTO swp_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Abo Eaubada i ribalau Noa ma nanatunayao aridi eai i ene, ");
INSERT INTO swp_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Au ita, egu ribahesunuma ea hetoro arimiu eai, eo ami isimurita se laoma aridi eai hinage. ");
INSERT INTO swp_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Eo ginauri maumauridi gamagaridi arimiu eai wa, manu eo bulumakau eo tano taumiaina gamagaridi maemiuyao ake eai au pesama wa. ");
INSERT INTO swp_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Egu aigora ea ribaei arimiu eai, ede taba nige huia esau buluma maudoina ea tomgabaeuioidi dibori utu’utu goiladi eai, eo taba nige huia esau i diboriuio doha nei bena tanoubu i hebaaea.” ");
INSERT INTO swp_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Abo Eaubada i ene, “Aigorana heiheinoina ede ina, ede ea ginauri eau eo omi eo ginauri maumauridi maemiuyao wa matada eai, eo isidi gamagaridi maraitom asubena enadi hinage. ");
INSERT INTO swp_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Egu wari ea tore eada eai, abo egu aigora heiheinoina ede, eau eo tanoubu duaduarimai eai. ");
INSERT INTO swp_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ena eada ea ledima tanoubu ewana eai to boeadi eai wari se ita, ");
INSERT INTO swp_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","abo egu aigora ea henuaisini, ia ede eau eo omi eo buluma ginauridi maumauridi gamagaridi wa matada eai; ede goila taba nige se hemala abaita lailai bena buluma maudoudoina se hebaaeauioidi. ");
INSERT INTO swp_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ena wari i taumasaraha eada eai, abo ea italau arinai, abo egu aigora wa i laulau e huia nige nosina wa, ea nuatui, iaede Eaubada eo buluma ginauridi maumauridi gamagaridi eai tanoubu eai.” ");
INSERT INTO swp_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Eaubada i ribalau Noa arinai i ene, “Aigora heiheinoina ede ina, eau ea hetoro ede, eau eo buluma maudoudoina tanoubu eai ta matada eai.” ");
INSERT INTO swp_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noa nanatunayao tatao wa, isi ede ake se pesagabaei wa, ede Sema, Hama eo Iapeta. Hama ede Kanana tamana. ");
INSERT INTO swp_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Teina tataodi haiona ta ede Noa nanatunayao, isi aridi eai tanoubu maudoina se tubuma. ");
INSERT INTO swp_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa ede tano tau giarina bagubagunana. Ia vine oeana i umai; ");
INSERT INTO swp_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","arinai waina i ginauri, to i nom‐eaueaure to ena numa‐lulu alona eai ie guri, ie ota tau aha’ahana. ");
INSERT INTO swp_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","To Hama wa, Kanana tamana, tamana ma kohakohana eai ie ita, to ena tataoyao labui murimuri eai i heribadi. ");
INSERT INTO swp_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Abo Sema eo Iapeta lulu esau se abi, dabayarodi eai se wese, eo se murimuri siwasiwa se laulau e abo tamadi kohakohana se heabobo; matadi wa se laei hesuara tamadi ma kohakohana wa nige se ita. ");
INSERT INTO swp_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Abotai Noa ena waina nomna arinai i siliata, natuna taumurita wa ena abi i nuatuiya’o. ");
INSERT INTO swp_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","I ene, “Kanana ea ribahebaaea ta; abo i hemala ena tataoyao edi tauauau edi heaheari.” ");
INSERT INTO swp_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Hinage i ene, “GUIAU egu Eaubada ia abo Sema i ainauiai, abo Kanana ia ena heaheari tauauauna. ");
INSERT INTO swp_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Eaubada abo Iapeta i helai, Sema ena numa‐lulu aridi eai abo i mia. abo Kanana ia ena heaheari tauauauna.” ");
INSERT INTO swp_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Dibori utu’utu wa murina eai, Noa borimai handere haiona eo tatao‐labui‐se‐mate‐saudoudoi ie mia. ");
INSERT INTO swp_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Noa ena asubena gamagaridi ede borimai handere haligigi‐hasi eo tatao labui‐se‐mate‐saudoudoi; abotai ie mate. ");
INSERT INTO swp_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Noa ma nanatunayao Sema, Hama eo Iapeta, isidi ede ina; ma nanatudiyao hinage dibori utu’utu wa murina eai se labasidi. ");
INSERT INTO swp_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Iapeta nanatunayao tatao: Gomera, Magoga, Madai, Iavan, Tubala, Meseka eo Tirasa. ");
INSERT INTO swp_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomera nanatunayao tatao: Askenasa, Ripata eo Togarama. ");
INSERT INTO swp_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Iavan nanatunayao tatao: Elisa, Tarisiso, Kitima, eo Dodanima. ");
INSERT INTO swp_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Teina tatao ta aridi eai geregere taumia se tadada. Isi wa Iapeta nanatunayao isibom edi tano eai, eo isibom arinadi eo adi bogao eo edi basileia se tubu. ");
INSERT INTO swp_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hama nanatunayao tatao: Kusa, Aigupito, Puta eo Kanana. ");
INSERT INTO swp_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kusa nanatunayao tatao: Seba, Havila, Sabata, Raama eo Sabeteka. Raama nanatunayao tatao: Siba eo Dedani. ");
INSERT INTO swp_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusa i hemala Nimoroda tamana; ia taubagubagunana tanoubu eai ta i hemala tau didididigana. ");
INSERT INTO swp_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ia tauailoea saesaena GUIAU matana eai; arinai ede se ribaei si ene, “Doha Nimoroda, tauailoea saesaena GUIAU matana eai.” ");
INSERT INTO swp_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ena basileia ena aba‐tubu ede Babela, Ereke, eo Akada eai, gamagaridi Sinara oeana eai. ");
INSERT INTO swp_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Oea eai ne i torohai i lau Asiria, eo Ninive eanuana i hetoro, eo Rehobote‐iro, Kalaha, ");
INSERT INTO swp_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","eo Reseni Ninive eo Kalaha duaduaridi eai; ia eanua lailaina wa. ");
INSERT INTO swp_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Aigupito i hemala Ludim, Anamino, Lehabim, eo Naputuhim tamadi. ");
INSERT INTO swp_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Eo Paturusim eo Kasuluhim (Pilistia tataodi edi aba‐laoma) eo Kapotorim. ");
INSERT INTO swp_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanana i hemala Sidona tamana, ana taubaguna, eo Heta. ");
INSERT INTO swp_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Eo Iebusi tataodi, Amore eo Girogaso tataodi. ");
INSERT INTO swp_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiwi tataodi, Areka tataodi, Sini tataodi. ");
INSERT INTO swp_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Aravadi tataodi, Semara tataodi eo Hamata tataodi. Abotai Kanana ana isimurita se adau se dobi tanoubu hari tupo eai. ");
INSERT INTO swp_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kanana tataodi edi tano Sidona eai i tubu i lau e Gerara, ie dobi e lage Gasa, eo Sodoma, Gomara, Adama, Seboima edadi eai i lau e Lahasa eai. ");
INSERT INTO swp_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Teina Hama nanatunayao ede, eo adi bogao, edi arina, edi tano eo edi basileia. ");
INSERT INTO swp_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sema arinai hinage, Ebera nanatunayao tamadi wa, eo Iapeta ana taubaguna, ia arinai merumeru se labasidi. ");
INSERT INTO swp_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sema nanatunayao tatao: Elama, Asura, Arepakasa, Luda eo Arama. ");
INSERT INTO swp_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Arama nanatunayao tatao: Usa, Hula, Getera eo Masaha. ");
INSERT INTO swp_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arepakasa i hemala Sela tamana; eo Sela i hemala Ebera tamana. ");
INSERT INTO swp_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebera arinai tatao labui se labasidi: esau esana Pelege, paana ena mauri asubenadi eai, tanoubu se soiei, eo ena tau esana Ioketana. ");
INSERT INTO swp_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ioketana nanatunayao Alemodada, Selepi, Hasamaweta, Iera. ");
INSERT INTO swp_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadorama, Usala, Dikala, ");
INSERT INTO swp_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obala, Abimela, Siba. ");
INSERT INTO swp_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opira, Havila eo Iobaba; gamagaridi ta Ioketana nanatunayao ede. ");
INSERT INTO swp_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Tano arinai se mia wa lohana ede Mesa i lau Separa oea tupidi tupo aruabu eai wa. ");
INSERT INTO swp_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Teina Sema ana isimurita, adi bogaoyao, arinadi, edi tano, eo edi basileia. ");
INSERT INTO swp_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Teina Noa nanatunayao adi bogaoyao ede, ma adi isi edi basileia eai; basileia ta aridi eai se tadada tanoubu tupo gamagari eai, dibori utu’utu wa murina eai. ");
INSERT INTO swp_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Tanoubu maudoina arinadi esega eo riba heguhegurina gonogonoana. ");
INSERT INTO swp_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Tatoa se lauheagogo se lau tupo aruabu, nei eai gonu lailai se lobai Sinara eanuana eai to arinai se mia. ");
INSERT INTO swp_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Abo se oiriba si ene, “Ehei, hage bricks tano eai ta ginauridi, ta gabu komakomanidi.” Wau bricks wa se wa se hepaisoaedi doha edi we’u, eo tar se hepaisoa aba hepatu guduidi. ");
INSERT INTO swp_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Abo si ene, “Ehei, hage eda eanua lailaina ta hetoro, eo numa lailaina ewana i sae e galewa, abo esada edi aba’ataina abo tanoubu matana eai taba nige se hetatagorigorida.” ");
INSERT INTO swp_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Abo GUIAU i dobima eanua i itasipoi, eo numa lailaina wa tatao nanatudiyao se hetoro. ");
INSERT INTO swp_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Abo GUIAU i ene, “Iaede, isi tatao peledi esega, eo arinadi esega; ina aba hetubuna mo, sora saha abo se ginauri; saha se nuatui bena se ginauri abo gonoadi se ginauri. ");
INSERT INTO swp_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Besi, ta dobi arinadi ta hepilipilidi, abo esau esau arinadi nige se atailobaidi.” ");
INSERT INTO swp_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Arinai GUIAU i hetatagorigoridi, nei eai se lau tanoubu tupo gamagari, eo eanua se ginauri wa arinai se paisoa lautom. ");
INSERT INTO swp_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Arinai esana se ribaei Babela, paana nei eai GUIAU tanoubu tataodi arinadi i hepilipilidi, eo nei eai i hetatagorigoridi tanoubu potana eai se lau tupo gamagari. ");
INSERT INTO swp_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sema ana isimurita ede ina. Sema ena borimai handere esega, abotai i hemala Arepakasa tamana borimai labui dibori utu’utu murina eai. ");
INSERT INTO swp_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arepakasa se labasi murina eai Sema borimai handere haligigi ie mia, eo nanatunayao headi tatao eo sisine i hetubudi. ");
INSERT INTO swp_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arepakasa borimai tau‐esega‐i‐mate‐saudoudoi‐haligigi ie mia, abo Sela i hetubu; ");
INSERT INTO swp_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Sela se labasi murina eai Arepakasa ena borimai handere hasi eo haiona ie mia, eo nanatunayao headi, tatao eo sisine, i hetubudi. ");
INSERT INTO swp_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela borimai tau‐esega‐i‐mate‐saudoudoi ie mia, abotai i hemala Ebera tamana; ");
INSERT INTO swp_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ebera se labasi murina eai Sela borimai handere hasi eo haiona ie mia, eo nanatunayao headi, tatao eo sisine, i hetubudi. ");
INSERT INTO swp_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebera borimai tau‐esega‐i‐mate‐saudoudoi‐hasi ie mia, abotai i hemala Pelege tamana. ");
INSERT INTO swp_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pelege se labasi murina eai Ebera borimai handere hasi eo tau‐esega‐i‐mate‐saudoudoi ie mia, eo nanatunayao headi, tatao eo sisine, i hetubudi. ");
INSERT INTO swp_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelege borimai tau‐esega‐i‐mate‐saudoudoi ie mia, abotai i hemala Reu tamana; ");
INSERT INTO swp_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Reu se labasi murina eai Pelege borimai handere labui eo haligigi‐hasi ie mia eo nanatunayao headi, tatao eo sisine, i hetubudi. ");
INSERT INTO swp_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu borimai tau‐esega‐i‐mate‐saudoudoi‐labui ie mia, abotai i hemala Seruga tamana. ");
INSERT INTO swp_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Seruga se labasi murina eai Reu ena borimai handere labui eo haligigi‐labui ie mia, eo nanatunayao headi, tatao eo sisine, i hetubudi. ");
INSERT INTO swp_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seruga borimai tau‐esega‐i‐mate saudoudoi ie mia, abotai i hemala Nahora tamana; ");
INSERT INTO swp_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nahora se labasi murina eai Seruga borimai handere labui ie mia, eo nanatunayao headi, tatao eo sisine i hetubudi. ");
INSERT INTO swp_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahora borimai tau‐esega‐i‐mate eo haligigi‐hasi ie mia, abotai i hemala Teraha tamana; ");
INSERT INTO swp_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Teraha se labasi murina eai Nahora borimai handere esega eo saudoudoi‐haligigihasi‐ie‐mia, eo nanatunayao headi, tatao eo sisine, i hetubudi. ");
INSERT INTO swp_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Teraha ena borimai tatao‐haiona‐se‐mate‐saudoudoi ie mia, abotai i hemala Aberama tamana eo Nahora, eo Harana. ");
INSERT INTO swp_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Teraha ana isimurita ede ina. Teraha ia Aberama, Nahora, eo Harana tamadi; na Harana ia Lota tamana. ");
INSERT INTO swp_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Harana ia i mate baguna, sora tamana ma miana eai, edi eanua edi aba‐labasina eai, ede Uro, Kalidea tataodi enadi wa. ");
INSERT INTO swp_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Aberama eo Nahora monediyao se tawasoraidi; Aberama monena wa esana Sara, eo Nahora monena esana Mileka, ia Harana natuna, Mileka eo Iseka tamadi wa. ");
INSERT INTO swp_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Na Sara mo i agari; ia nige natuna. ");
INSERT INTO swp_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Teraha natuna Aberama eo tubuna Lota, Harana wa natuna, eo bosiana‐sine Sara natuna Aberama wa monena, i woeahaidi Uro, Kalidea tataodi edi eanua, se laugabaei se lau Kanana oeana eai; na Harana eai se lage abo se tarutoro eo nei eai se miahai. ");
INSERT INTO swp_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Teraha ena asubena gamagarina ede borimai handere labui eo haligigi; abo Teraha Harana eai ie mate. ");
INSERT INTO swp_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","GUIAU i ribalau Aberama arinai i ene, “Em eanua, am bogaoyao, eo tamam ena numa, u torohaigabaedi, u lau eanua esau arinai, iaede abo ea heitam. ");
INSERT INTO swp_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Eau abo ea hetorom u hemala basileia lailaina, abo ea ainauiaim, esam abo ea helai, arinai oa abo tauainauia. ");
INSERT INTO swp_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Isi tauainauiaim abo hinage ea ainauiaidi, eo ia tauribahematem abo hinage ea ribahemate; na oa debam eai boga gamagari tanoubu eai helolona abo se lobai.” ");
INSERT INTO swp_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Arinai Aberama i torohai, doha GUIAU i heriba wa; Lota hinage maena se lau. Aberama ena borimai tatao‐haiona‐se‐mate saudoudoi‐haligigi, huiana ne Harana i torohaigabaei. ");
INSERT INTO swp_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Aberama monena Sara i woeai, eo Lota ena tau natuna wa, eo edi gogo gamagari se lauheagogo, eo edi tataoyao Harana eai se abidi; eo se torohai bena se lau Kanana tanona eai. Se lage’o Kanana tanona eai. ");
INSERT INTO swp_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Aberama eanua i baeawai i lau e ie lage teha esau Sekema eai, More aiaruna wa arinai. Nei huiana eai ne Kanana tataodi ma miadi tano eai ne. ");
INSERT INTO swp_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Abo GUIAU i taumasaraha Aberama arinai, i ene, “Am isimurita aridi eai tano ta abo ea mosedi.” Arinai aba‐aitalasam esau i hetoro metai, GUIAU enana wa i taumasaraha arinai. ");
INSERT INTO swp_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Abo i taulau oea tupina Beteli tupo aruabuna eai, ena numa‐lulu i hetoro, Beteli tupo ealasi eai, eo Eiai tupo aruabu eai, nei eai aba‐aitalasam esau i hetoro GUIAU enana, eo GUIAU esana i atai. ");
INSERT INTO swp_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Abotai Aberama ena lauwasi i lauei Negeba hesabana ie lau. ");
INSERT INTO swp_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Abo guriam lailai ie tubu eanua eai ne. Arinai Aberama ie dobi Aigupito, nei eai bena i mia, paana guriam wa i baaea ariri edi tupo eai. ");
INSERT INTO swp_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Se hanahanau bena se lage Aigupito eai, i ribalau monena Sara arinai, i ene, “Ea nuatui oa sine abo se itam am ao i lolo, ");
INSERT INTO swp_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Aigupito tataodi se itam abo si ene, ‘Teina monena ede;’ arinai eau abo si unuigu, oa mo abo se hemiam. ");
INSERT INTO swp_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","U riba u ene oa lougu, arinai abo i lau loloegu oa debam eai eo abo se eari ea mauri.” ");
INSERT INTO swp_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Aberama i lusora Aigupito eai hinage Aigupito tataodi se ita hede sine wa ana ao i lolo ariri. ");
INSERT INTO swp_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Parao ena wasawasa headi ia se ita hinage se ribatausaei Parao arinai. Abo sine wa se abi se laei Parao ena numa eai. ");
INSERT INTO swp_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Sine wa debana eai Aberama i abi komakomani; ena mamoe, ena bulumakau, ena asini tamoadi, ena tatao‐paisoa, ena sisine‐paisoa, ena asini bawesinadi eo ena kamela, enana se mosedi. ");
INSERT INTO swp_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Na GUIAU Parao i heai’iwala, ma ena numa taumiana, iwala lailaidi se hearodi, Sara, Aberama monena wa, debana eai. ");
INSERT INTO swp_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Abo Parao Aberama i eogai, i ene, “Saha ina ue abi arigu eai ta? Paana saha nige u heribagu u ene ia monem? ");
INSERT INTO swp_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Paana saha u ene, ‘Ia lougu’ arinai ea abi bena monegu? Ehei, monem ede ina, u woeai au lau.” ");
INSERT INTO swp_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Parao tatao abo i lauhesomdi Aberama debana eai; abo dobila eai se woeai se woeai se hetamari, ma monena eo maena ginauri maudoidi. ");
INSERT INTO swp_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Arinai Aberama Aigupito i laugabaei, ia ma monena, eo ena ginauri maudoidi, maena Lota hinage, se seuio Negeba eai. ");
INSERT INTO swp_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Aberama ena gogo abo i laiariri, suisui, eo silver eo gold. ");
INSERT INTO swp_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ena lauwasi wa Negeba eai i taudaru ie lau e Beteli eai ie lage, ena numa‐lulu ena aba‐hetorona bagubagunana eai wa, Beteli eo Eiai sorasoradi eai. ");
INSERT INTO swp_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Eanua wa arinai aba‐aitalasam ena aba‐hetorona wa; temetai Aberama GUIAU esana i atai. ");
INSERT INTO swp_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lota ia Aberama i hemuriwatai wa, ia hinage ena mamoe eawoidi eo ena bulumakau eo ena numa‐lulu se gamagari. ");
INSERT INTO swp_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Nige gonoadi tanona ne i heaidi ena se mia esega, paana edi gogo se lai ariariri, nige gonoadi se mia gogo. ");
INSERT INTO swp_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Eo hinage Aberama ena bulumakau tauitawataidi eo Lota ena bulumakau tauitawataidi se haihaiabi. Huia eai ne Kanana tataodi eo Perisi tataodi tano ne se haihaimiai. ");
INSERT INTO swp_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abo Aberama i ribalau Lota arinai i ene, “Oa eo eau tabu ta haiabi eo em heaheari tataodi egu heaheari tataodi hinage, paana ita boga esega. ");
INSERT INTO swp_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Tano maudoina ede matam eai me, e nige’e? Besi u abihesuara’uioim. Ena tupo nima‐seuseurim eai u abi, eau abo tupo tutu eai ea lau; e ena oa bena tupo tutu u abi, eau abo ea lau tupo seuseuri eai.” ");
INSERT INTO swp_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Abo Lota matana i helabaisinidi, Ioridana gonuna ie ita, goilana se gamagari tupo gamagari eai, doha GUIAU ena oea, doha Aigupito tanona, Soara edana eai wa, huiana eai wa GUIAU sora nige Sodoma eo Gomara i hebaaeadi. ");
INSERT INTO swp_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Arinai Lota Ioridana gonuna iabom enana i hineri, eo Lota ie lau tupo aruabu; arinai se hai‐tausuaraedi. ");
INSERT INTO swp_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Aberama Kanana oeana eai ie mia, na Lota eanua lailaidi gonu eai wa boeadi eai ie mia eo ena numa‐lulu i hesigilaei i lau Sodoma eai. ");
INSERT INTO swp_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Wau Sodoma tataodi se hemanabara ariri, GUIAU tauhebaaeana saesaedi ede isi. ");
INSERT INTO swp_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lota i abihesuara’uioi wa murina eai GUIAU i ribalau Aberama arinai, i ene, “Matam u helabaisinidi, em aba‐toro eai me u italau, tupo bauri, tupo eawana, tupo aruabu, tupo ealasi, ");
INSERT INTO swp_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","paana eanua maudoina u itaitai ne abo ea leawa, eo am isimurita, i lau e huia gamagari ana huia ana tasi. ");
INSERT INTO swp_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Am isimurita abo ea hetubudi doha tano muaridi; ena gonoana tano muaridi se hasiridi abo gonoana hinage am isimurita se hasiridi. ");
INSERT INTO swp_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","U toro, tano ta u taudadai, lohana eo magagana, paana eau abo ea leawa.” ");
INSERT INTO swp_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Arinai Aberama ena numa‐lulu i hesigilaei, i laoma Mamare aiarudi boeadi eai ie mia, isi ede Heberona eai wa; nei eai hinage aba‐aitalasam hatana i hetoro GUIAU enana. ");
INSERT INTO swp_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Huiadi eai ne Amerapele ia Sinara edi wasawasa, Arioka ia Elasara edi wasawasa, Kedorolaoma ia Elama edi wasawasa, eo Tidala ia Goiima edi wasawasa, ");
INSERT INTO swp_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","teina wasawasa ta iala se hetubu Bera, Sodoma edi wasawasa arinai, eo Birisa, Gomara edi wasawasa arinai, eo Sinaba, Adama edi wasawasa arinai, eo Semeba, Seboima edi wasawasa arinai, eo Bela edi wasawasa hinage (ia ede Soara wa.) ");
INSERT INTO swp_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Gamagaridi se heoiesegaidi Sidima gonuna eai (ia ede Gabogabo Ariaritana wa.) ");
INSERT INTO swp_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Borimai saudoudoi‐labui Kedorolaoma se heayaiyei, na borimai hesaudoudoi‐haiona na na se oipiriei. ");
INSERT INTO swp_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Kedorolaoma ena borimai hesaudoudoi‐hasina eai ia eo wasawasa maenayao wa se laoma tatao ta se saepoidi, Repaima Aseterota‐karanaima eai wa, eo Susim Hama eai wa, eo Emima Save‐kiriataima eai wa. ");
INSERT INTO swp_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Eo Hori tataodi edi oea‐tupina Seira eai wa i lau Elparana eai, barabara lailai sigasigana eai. ");
INSERT INTO swp_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Abotai se sinibui se laoma Eni‐misapata (ia ede Kadesa) eo tano maudoina se saepoi, Amaleka tataodi enadi eo Amore tataodi enadi hinage, isi wa Hasasona‐tamara eai se miamia. ");
INSERT INTO swp_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Abotai Sodoma edi wasawasa, Gomara edi wasawasa, Adama edi wasawasa Seboima edi wasawasa eo Bela edi wasawasa, (ia ede Soara) se torohai se lau iala hesabana Sidima gonuna eai wa, ");
INSERT INTO swp_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","bena Kedorolaoma, Elama edi wasawasa, eo Tidala, Goiima edi wasawasa, Amarapele, Sinara edi wasawasa, eo Arioka, Elasara edi wasawasa, se ialaidi, wasawasa hasi se lau wasawasa haligigi hesabadi. ");
INSERT INTO swp_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Na Sidima gonuna tar ipudi se monau; Sodoma eo Gomara edi wasawasa se dagodago, na isi headi wau ipudi aridi eai se beu maudoidi se dago se sae oea tupidi eai. ");
INSERT INTO swp_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Arinai adi waiunu wa Sodoma eo Gomara edi gogo gamagaridi se girihaidi, eo adi aiai maudoidi se baheidi se laedi. ");
INSERT INTO swp_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Lota hinage se toai, Aberama ena tau natuna Sodoma eai i miamia wa, ena gogo hinage se abiesegaidi to se lau. ");
INSERT INTO swp_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Abotai tau esau taudagogabaedi i laoma Aberama i heriba, ia Heberu tauna, Mamare ena aiaru boeadi eai i mia. Amore tauna wa, Esekola eo Anera edi tau; ina tatao ta Aberama tausaguidi ede. ");
INSERT INTO swp_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Aberama wasa i ataiei ana boga esau se abi se pai, abo ia ena tataoyao se heata komakomanidi’o, ena numa eai se labasidi, tataodi handere haiona eo saudoudoi‐haligigi‐haiona, i woeaidi se aihenau se lau e se lage Dani eai. ");
INSERT INTO swp_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ena tatao i soi komakomanidi maiona eai, ia maena heaheari tataodi se hetatagorigoridi eo se henaudi i lau e Hoba eai, Damaseko tupo bauri eai. ");
INSERT INTO swp_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Abo gogo maudoina wa i baheuioi, eo ana boga tauna Lota i woeauioi, maena gogo, ena sisine eo ena tatao. ");
INSERT INTO swp_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Kedorolaoma eo wasawasa maenayao wa tausaguina wa i hetatagorigoridi to i uioma na Sodoma edi wasawasa i torohai bena i hailobai Save gonuna eai (ia ede Wasawasa ena Gonu.) ");
INSERT INTO swp_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Abo Melekisedeka Salem edi wasawasa falawa eo waina i bahema, ia Eaubada Saesae‐aririna ena kohena tauna. ");
INSERT INTO swp_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Eo i ribaheloloei i ene, “Eaubada Saesae‐aririna Aberama i ribahewoiwoinaei, ia wa galewa eo tanoubu tauginauridi; ");
INSERT INTO swp_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Eo Eaubada Saesae‐aririna ia i nuawoiwoinaem, am waiunuyao wa taulediwa nimam eai!” Eo Aberama ginauri gamagaridi wa i soiedi, hesaudoudoina lausoisoina esega i mosei. ");
INSERT INTO swp_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodoma edi wasawasa Aberama arinai ie riba i ene, “Dodoga mo u ledima, na gogo u abi oabom enam.” ");
INSERT INTO swp_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Na Aberama Sodoma edi wasawasa arinana i heuio i ene, “GUIAU Eaubada Saesaearirina galewa eo tanoubu tauginauridi, arinai ea riba aigora’o. ");
INSERT INTO swp_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Oa em ginauri taba nige maina bodibodi e ae’um aba‐auna e oa em ginauri esa enam ea abilau arinai, ata u ene, ‘Eau Aberama ana gogo lailai taumoseina.’ ");
INSERT INTO swp_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Eau taba nige saha ea abi, egu hewari adi aiai mo se aiya’o, eo tatao maeguyao taulau wa edi tupo abo se abi, Anera, Esekola, eo Mamare isi hinage edi tupo taba se abi.” ");
INSERT INTO swp_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Teina ginauridi ta muridi eai GUIAU ena riba i laoma Aberama arinai, enosuai eai, “Aberama e, tabu u matausi, eau em opea ede, em ainauia abo i lai ariri.” ");
INSERT INTO swp_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Na Aberama i ene, “Guiau EAUBADA, saha abo u leama, paana eau nige natugu, eo egu numa tanuagana hede Eliesera, Damaseko tauna wa.” ");
INSERT INTO swp_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Aberama i ene, “U ita, nige natugu u leama, arinai tau‐auau esau egu numa eai se labasi, ia abo egu gogo tauabina.” ");
INSERT INTO swp_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Na hedeona, GUIAU ena riba i uioma arinai, i ene, “Teina tau ta ia taba nige em gogo tauabina; oabom natum tahunuana em gogo abo i abi.” ");
INSERT INTO swp_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ia abo i woea‐hepesa, i ene, “U itasae galewa eai, ipora hage u hasiridi ena gonoana u hasiridi.” Abo i ribalau arinai i ene, “Am isimurita abo doha ede.” ");
INSERT INTO swp_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Na ia GUIAU ena riba i awa‐mamohoiei, arinai ede se nuatulaei si ene laulau‐duduraina meta. ");
INSERT INTO swp_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Eo i ribalau arinai i ene, “Eau GUIAU tau‐woeahaim Uro eai, Kalidea tataodi enadi wa, bena eanua ta ea leawa u abi enam.” ");
INSERT INTO swp_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Na ia i heuio i ene, “Guiau EAUBADA e, edohana abo ea nuatui, hede abo ea abi enagu?” ");
INSERT INTO swp_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Arinai i ene, “Bulumakau bawesina ena borimai haiona u leama, eo goti bawesina ena borimai haiona, eo mamoe tamoana ena borimai haiona, eo bunebune, eo gabubu natuna.” ");
INSERT INTO swp_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ginauri gamagaridi ta i abidima, i tomutusidi, tupo esa i torelaei tupo esa potana eai, manu mo nige i tomutusidi. ");
INSERT INTO swp_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Manu sinare tauaidi se loidobima eaudi wa hesabadi, na Aberama i henaudi se lau. ");
INSERT INTO swp_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Mahana ie dui na Aberama i enomate ariri; to matausi eo masigiri lailai aririna se taru potana eai. ");
INSERT INTO swp_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Abo GUIAU i ribalau Aberama arinai i ene, “Nuam eai bena i masaraha ariri, am isimurita abo eanua udoi arinai se mia, eanuana nige enadi, na ma‐auaudi abo se mia, eo abo se heporohedi borimai handere hasi sorasoradi eai. ");
INSERT INTO swp_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Na basileia wa se heayaiyei eau abo heduduraina ea ginauri, eo abotai abo se pesagabaei ma edi gogo maudoidi. ");
INSERT INTO swp_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Na oa mo abo u lau tamamyao aridi eai ma nuabigam; u tautaubada‐ariri’o abotai se torem. ");
INSERT INTO swp_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Isi abo se uioma inai, isi hehasina huiana eai; paana Amore tataodi edi baaea sora nige se ohi mamohoi.” ");
INSERT INTO swp_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Mahana i dui’o eo i masigiri’o, abo ne gulewa ginaha aba baheina ma asuasuna, eo osiri ala‐balebalelemna se taumasaraha wau aitalasam suisui eaudi wa boeadi eai. ");
INSERT INTO swp_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Asubena eai ne GUIAU ena aigora i ginauri Aberama arinai i ene, “Am isimurita tano ta abo ea mosedi, Aigupito sagana eai i lau saga lailaina eai wa, Euparatea sagana. ");
INSERT INTO swp_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Kemi tataodi edi tano, eo Kenisa, eo Kademonia, ");
INSERT INTO swp_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","eo Hito, eo Perisi, eo Repaima. ");
INSERT INTO swp_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Eo Amore, eo Kanana, eo Girogaso, eo Iebusi enadi.” ");
INSERT INTO swp_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sara, Aberama monena wa, ia nige nanatunayao i labasidi. Ena heaheari Aigupito sinena esana ede Hagara. ");
INSERT INTO swp_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Abo Sara i ribalau Aberama arinai i ene, “U itayao GUIAU abi merumeru eai i nuahigu; besi, u lau egu heaheari sinena arinai; ata bena ia debana eai abo nanatuguyao ea lobaidi.” Aberama Sara arinana ea i awaabiei. ");
INSERT INTO swp_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Arinai Aberama Kanana tehana eai borimai saudoudoi i mia’o, abotai Sara, Aberama monena, ena heaheari Aigupito sinena wa Hagara i woeai monena Aberama arinai, bena monena. ");
INSERT INTO swp_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","To ie lau Hagara arinai, to i heabi; ia wa huiana i italobai ie boga abo ena tanuaga i isuewaei. ");
INSERT INTO swp_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sara abo ie ribalau Aberama arinai i ene, “Se abi‐baaeaigu ta oa hinage am giru! Egu heaheari sinena eau ea leawa nuapoum eai em haitalagado eai, i lau e i itayao ie boga abotai i isuewaigu. GUIAU abo i hegiruda, oa eo eau!” ");
INSERT INTO swp_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Na Aberama Sara ena riba i heuio i ene, “Taiede, em heaheari sinena ta ede oa nimam eai; saha u henua u abi arinai abo u abi.” Abo Sara sine wa i abi‐baaeai, to ie dago. ");
INSERT INTO swp_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","GUIAU ena aneru sine wa abo i lobai, barabara eai, goila bunubunuasina esau gegesina eai, bunubunuasina wa Sura edana eai. ");
INSERT INTO swp_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","I ribalau arinai i ene, “Hagara, Sara ena heaheari sinena e, haedi eai u laoma eo haedi u laulau ina?” I ene, “Tanuagagu Sara arinai ea dadago.” ");
INSERT INTO swp_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","GUIAU ena aneru abo i ribalau i ene, “U seuio am tanuaga arinai, eo arinai u awaabi.” ");
INSERT INTO swp_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","GUIAU ena aneru ie riba hinage, i ene, “Am isimurita abo ea hegamagari aririedi, edi gamagari taba nige si hasiridi.” ");
INSERT INTO swp_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Eo GUIAU ena aneru wa enaba, “U ita, oa ue boga, eo natum tau abo u labasi; esana abo u tore Isamaela; paana GUIAU i atailaowa em nuaamamna arinai. ");
INSERT INTO swp_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ia abo tau‐hemanabara tauna, doha nuura asinina, nimana abo tatao gamagaridi i ialaidi, tatao gamagaridi hinage nimadi ia abo se ialai; eo ana bogaoyao abo i miasuaraedi eo i hewaiunuedi.” ");
INSERT INTO swp_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Arinai GUIAU enana tauriba wa esana i atai, “Oa tauitagu Eaubadana,” paana i ene “Mamohoi ede, wa, Eaubada ea i’ita, ea itayao na sora mamaumaurigu.” ");
INSERT INTO swp_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Arinai goila wa esana se ribaei Biera‐lahai‐roi; ia ede Kadesa eo Bereda duaduaridi eai. ");
INSERT INTO swp_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hagara Aberama natuna abo i labasi; eo Aberama natuna Hagara i labasi wa esana ie tore Isamaela. ");
INSERT INTO swp_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Aberama ena borimai tatao‐hasi‐se‐mate‐haligigi‐esega huiana ne Hagara Aberama natuna i labasi. ");
INSERT INTO swp_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Aberama ena borimai se lage’o tatao‐hasi‐se‐mate‐saudoudoi‐harigigi‐hasi GUIAU i taumasaraha Aberama arinai, i ribalau i ene, “Eau Gigibori‐aririna Eaubadana; matagu eai bena u laulau eo nige aba hegirum. ");
INSERT INTO swp_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Egu aigora oa eo eau matada eai wa abo, ea hemamohoiei, eo oa abo ea hegamagari‐aririem.” ");
INSERT INTO swp_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Aberama abo i duludobi tano eai, abo Eaubada i ribalau arinai, i ene, ");
INSERT INTO swp_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“U ita, egu aigora wa u abiyao, oa abo basileia gamagaridi tamadi ede. ");
INSERT INTO swp_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Esam taba nige se ataiuioi Aberama, esam abo se atai Aberahama, paana ea hetorom basileia moutuadi tamadi. ");
INSERT INTO swp_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Abo ea ainauiaim u ua ariariri; basileia arim eai abo se tubu, eo wasawasa abo boeam eai se laoma. ");
INSERT INTO swp_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Egu aigora, oa eo eau matada eai wa, abo ea hemamohoiei am isimurita se tubu‐muritama aridi eai, i lau e hari isi to hari isi, aigora miatahitahina, eau abo em Eaubada, am isimurita enadi hinage. ");
INSERT INTO swp_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Em aba‐tautausi tanona ta abo ea leawa oa arim eai, eo am isimurita se muritama aridi eai, Kanana tanona maudoudoina ta, abo enamiu i lau e huia nige nosina; eau hinage abo edi Eaubada.” ");
INSERT INTO swp_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Eaubada ie riba Aberahama arinai i ene, “Na oa mo, oa abo egu aigora ribadi u sogohidi, oa eo am isimurita se murimuritama wa, isidi gamagaridi eai. ");
INSERT INTO swp_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Egu aigora heiheinoina ina, abo au abiwatai, eau eo oa eo am isimurita murim eai, enadi, boeamiu eai tatao gamagaridi abo se peritome. ");
INSERT INTO swp_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Abo se heperitomemiu opimiu bulumadi eai, eda aigora heiheinoina abo, eau eo omi duaduarida eai. ");
INSERT INTO swp_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Eai boeamiu eai ena asubena hehaligigi‐haionana eai abo se heperitome; merumeru tatao, am isi gamagaridi eai, numa eai se labasidi e em moni eai ue uneidi murimuri tauna esau arinai ia nige natumiu mamohoi. ");
INSERT INTO swp_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ia wa em numa eai, eo ia wa em moni eai se unehai, taudi labui abo se peritomedi. Arinai abo egu aigora wa bulumamiu eai, aigorana taba nige i lautom. ");
INSERT INTO swp_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Tau esa nige se peritome bulumana opina eai abo ena tataoyao boeadi eai se tomhai; egu aigora i utusi ede.” ");
INSERT INTO swp_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Eaubada abo i ribalau Aberahama arinai, i ene, “Na Sara monem wa, tabu esana u atai Sara, ia esana abo Saraha. ");
INSERT INTO swp_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ia abo ea ainauiai, hinage oa natum abo eo leawa, ia debana eai; abo ea ainauiai to i hemala basileia gamagaridi sinadi; tatao edi wasawasa ia boeana eai abo se tubuma.” ");
INSERT INTO swp_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Aberahama abo i gurisalaoba matana eai, to i maruhi iabom nuana eai, ie riba i ene, “Abo merumeru se labasi tau ena borimai handere esega arinai? Abo Saraha natuna i labasi, ia i lage’o borimai tatao‐hasi‐se‐mate saudoudoi?” ");
INSERT INTO swp_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abo Aberahama i riba Eaubada arinai, i ene, “Ae, taba Isamaela i mia matam eai mo!” ");
INSERT INTO swp_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Eaubada i ene, “Nige’e, na monem Saraha abo natum i labasi, eo esana abo u atai Isaako. Egu aigora abo ea hemamohoiei ia arinai, aigora miamiatahitahina eo ana isimurita murina eai enadi hinage. ");
INSERT INTO swp_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Na Isamaela wa, em riba ea ataieiya’o; u ita, abo ea ainauiai hinage, ea he’ua eo ea hegamagari aririei; wasawasa saudoudoi‐labui ia abo tamadi ede, abo ea hetoro i hemala basileia saesaena. ");
INSERT INTO swp_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Na egu aigora wa Isaako arinai abo ea hetoro, ia wa Saraha abo enam i labasi, inata arinai ie lau borimai esega.” ");
INSERT INTO swp_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Maena se ribariba lautom, Eaubada i laugabaei. ");
INSERT INTO swp_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Aberahama natuna Isamaela abo i woeai, maena ena heaheari tauauau tataodi ena numa eai se labasidi, eo ena moni eai se unehaidi, tau maudoina Aberahama ena numa tataodi, to bulumadi opidi eai i heperitomedi asubena esega eai ne, doha Eaubada i heriba wa. ");
INSERT INTO swp_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Aberahama ena borimai tatao‐hasi‐se‐mate‐saudoudoi‐haligigi‐hasi huiana ne bulumana opina eai se heperitome. ");
INSERT INTO swp_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Natuna tau Isamaela ena borimai saudoudoihaiona se lauo abo se heperitome bulumana opina eai. ");
INSERT INTO swp_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Asubena esega eai Aberahama eo natuna Isamaela se heperitome esegaidi. ");
INSERT INTO swp_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Eo tatao gamagaridi ena numa eai se labasidi, eo isi wa moni eai se unehaidi murimuri‐tataodi aridi eai, maenayao se heperitome esegaidi. ");
INSERT INTO swp_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","GUIAU i taumasaraha ia arinai, Mamare aiarudi eai, ia ena numa‐lulu dobilana eai i babawa, asuasubenalai gigiborina eai. ");
INSERT INTO swp_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Matana i helabaisinidi ie italau, hede tatao haiona matana eai se totoro. Ie itadi abo ena numa‐lulu wa dobilana i laugabaei ie tau hesabadi bena i hailobaidi, abo tano eai i tabaohu. ");
INSERT INTO swp_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","I ene, “Egu guiau e, ena matam eai ea henualolom, tabu em heaheari tauna u laugabaei. ");
INSERT INTO swp_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Goila begana hage se leawa, aemiu aba deuridi, eo au aieawasi begana oeagi loguloguna eai ta. ");
INSERT INTO swp_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Na aiai ami begana ea leama, amnamiu se lolo abotai emi eda eai au lau; paana au laoma’o ina emi heaheari tauna arinai.” To si ene, “Besi, doha u ribaei wa u ginauri.” ");
INSERT INTO swp_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abo Aberahama i heuheula ie lau numa‐lulu alona eai wa, Saraha arinai, eo i ene, “U heula falawa lolololona nonoina haiona u henonohaidi, u helasa eo keke u ginauridi.” ");
INSERT INTO swp_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Aberahama abo i aitautau ena bulumakau eawoina arinai, bulumakau natuna esau ie abi, natuhariuna, lolo aririna, i mosei ena heaheari esau arinai, ia ie abi heulai bena i henonohai. ");
INSERT INTO swp_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Abo bata eo susu ie abi, eo bulumakau natuna se henonohaiya’o wa, eo i toredi matadi eai wa na isi se aiai. ");
INSERT INTO swp_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Se ribalau ia arinai si ene, “Monem Saraha wa ia haedi?” Ia i ene, “Ia hede numa‐lulu alona eai.” ");
INSERT INTO swp_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","I ene, “Abo ea uioma arimiu eai, borimai sigana eai, monem Saraha abo natum i labasi.” Na Saraha wa ia numa‐lulu guduna murina eai i ata’atai, dagelana eai. ");
INSERT INTO swp_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Aberahama eo Saraha se tautaubada se sinesinebada ariri, eo edi borimai se gamagari; sisine kamanidi wa Saraha arinai i lautom’o. ");
INSERT INTO swp_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Arinai Saraha nuaboeana eai i maruhi, i ene, “Ea sinesinebada’o, eo monegu i tautaubada’o, abo gonoamai kodena ai lobai?” ");
INSERT INTO swp_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","GUIAU abo ie riba Aberahama arinai, i ene, “Paana saha Saraha i maruhi, eo i ene, ‘Mamohoi abo merumeru ea labasi, ea sinesinebada’o ta?’ ");
INSERT INTO swp_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Au ene bena ginauri esau i piripiri ariri GUIAU arinai? Huiana se tauribaei, arinai abo ea uioma, borimai sigana eai, Saraha natuna tau abo i abi.” ");
INSERT INTO swp_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Na Saraha i halele, i ene, “Eau nige ea maruhi” — paana i matausi. GUIAU i ene, “Nige’e, na u maruhi wa!” ");
INSERT INTO swp_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Abo tatao wa se torohai, se italau Sodoma edana eai; Aberahama maedi se lau, bena edi dobila eai i healatudi. ");
INSERT INTO swp_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","GUIAU i ene, “Laulau abo ea ginauri wa, abo ea toreyamui Aberahama arinai, wa? ");
INSERT INTO swp_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Paana ia abo i hemala basileia saesaena eo gigigiborina, eo tanoubu basileiadi gamagaridi abo se helolouioidi ia debana eai. ");
INSERT INTO swp_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Nige’e, paana ia egu hineri tauna, abo nanatunayao eo ena numa tataodi murina eai i heatadi GUIAU ena laulau se sogohidi, laulau dudurai eo abi dudurai hinage; bena GUIAU saha i ribahesunumadi wa abo i hetubudi Aberahama arinai.” ");
INSERT INTO swp_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Abotai GUIAU i ene, “Lauhegiru Sodoma eo Gomara aridi eai i lai ariri, paana edi baaea i lai ariariri, ");
INSERT INTO swp_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Arinai abo ea dobi ea ita, lauhegiru i laoma arigu eai wa, mamohoi se ginauri ede; eo ena nige’e, abo abina ea ata.” ");
INSERT INTO swp_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Arinai tatao wa se sinibui, se lau Sodoma hesabana; na Aberahama sora i totoro GUIAU matana eai. ");
INSERT INTO swp_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Aberahama i sigilaoma i ene, “Mamohoi abo tatao duduraidi u hebaaeadi maediyao tatao baaeadi wa? ");
INSERT INTO swp_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ena taba ta ene tatao duduraidi tatao‐labui‐se‐mate‐saudoudoi ma miadi eanua eai me, abo eanuana u hebaaea, taba nige u nuatoatoaei wau tatao duduraidi tatao‐labui‐se‐mate‐saudoudoi miamiadi wa debadi eai? ");
INSERT INTO swp_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Oa taba nige em laulau doha nei, laulau dudurai tataodi eo laulau baaea tataodi u unuesegaidi doha tatao baaeadi se heai gonogonoaiei! Taba nige em laulau doha nei! Tanoubu maudoina Tauheduduraina abo nige ena abi i dudurai?” ");
INSERT INTO swp_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Abo GUIAU i ene, “Ena Sodoma eai tau laulau dudurai tatao‐labui‐se‐mate‐saudoudoi ea lobaidi, eanuana abo ea nuatoatoaei, isi debadi eai.” ");
INSERT INTO swp_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Aberahama riba ta i heuio i ene, “U ita, nuagu ea tore ina, bena Guiau arinai ea riba, eau doha wenu eo ahu mo. ");
INSERT INTO swp_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ena taba ta ene, wau tau laulau duduraidi tatao‐labui‐se‐mate‐hesaudoudoina wa haligigi wa nige’e? Abo eanua maudoina u hebaaea, paana haligigi wa nige’e?” I ene, “Taba nige ea hebaaea ena tatao‐labui‐se‐mate‐haligigi nei eai ea lobaidi.” ");
INSERT INTO swp_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abo i ribauio, i ene, “Ena taba tatao‐labui‐se‐mate mo u lobaidi nei eai?” I heuio i ene, “Tatao labui‐se‐mate mo debadi eai taba nige eo ginauri.” ");
INSERT INTO swp_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abo i ene, “Agutoi, tabu Guiau i ouyalayala, na egu riba ea ribaei mo. Ena tau esega‐i‐mate‐saudoudoi se lobaidi nei eai?” I heuio i ene “Taba nige ea ginauri, ena tau‐esega‐i‐mate‐saudoudoi ea lobaidi nei eai.” ");
INSERT INTO swp_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abo i ene, “U itagu ta, awagu ea dabariyao Guiau arinai. Ena taba tau‐esege‐i‐mate se lobaidi?” I heuio i ene, “Tau‐esega‐i‐mate debadi eai taba nige ea hebaaea.” ");
INSERT INTO swp_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abo i ene, “Agutoi, tabu Guiau i ouyalayala, na ma esegana ta ea ribauio. Ena taba saudoudoi se lobaidi nei eai?” I heuio i ene, “Saudoudoi debadi eai taba nige ea hebaaea.” ");
INSERT INTO swp_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Abo GUIAU ena eda eai ie lau, huiana maena Aberahama se ribariba lautom; na Aberaham ie uio ena abamia eai. ");
INSERT INTO swp_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Aneru labui wa maimailahi eai se lage Sodoma eai; na Sodoma dobila aba lusorana eai Lota i babawa. Lota ie itadi abo i toro bena i hailobaidi, eo i tabaohu dobi tano eai. ");
INSERT INTO swp_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","I ene, “Egu guiau e, ea aibodaimiu bena au awasaema emi heaheari ta ena numa eai au eno, eo aemiu au deuridi; maraitom abo au toro heula emi dobila eai au lau.” Si ene, “Nige’e, ai abo maiona ta ai abi eanua dobiladi eai.” ");
INSERT INTO swp_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Na i dudu adidiri; arinai se utugesi, se awasae ena numa eai; adi mataasi i ginauri eo falawa ahaaha adi ie gabu, to se ai. ");
INSERT INTO swp_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Na sora nige se eno, eanua tataodi, Sodoma tataodi, hewahewaridi eo tatao lailaidi, tau maudoina, numa se hetaiiri. ");
INSERT INTO swp_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Lota arinai se eoga si ene, “Tatao wa haedi, maiona ta se laowa arim eai wa? U hepesadima arimai eai bena abidi ai ata.” ");
INSERT INTO swp_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lota ie lau numa dobila guduna eai tatao aridi eai, ena numa guduna dagelana eai ie gudu, ");
INSERT INTO swp_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","I ene, “Egu tataoyao e, ea aibodaimiu ta, tabu emi laulau se baaea doha ina. ");
INSERT INTO swp_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Besi eau nanatuguyao sisine labui, isi sora nige tau se hailobai, besi ea hepesadiwa, saha au henua aridi eai au abi abo au abi; ia mo tatao ta aridi eai tabu saha au abi, paana isi se laoma egu numa tauaitaumana.” ");
INSERT INTO swp_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Na isi mo si ene, “U torohihisi.” Eo si ene, “Tau ta ia taulaolaoma mo, na bena i toro doha tauhedudurai! Sora oa abo ai abi‐baaea aririem, abotai isi.” Lota se dudui aririei, se hanahanaui arinai bena dobila guduna se eatulopa. ");
INSERT INTO swp_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Na wau tatao labui wa numa‐alo eai wa nimadi se helele Lota se toai se niuriama aridi eai, dobilana se gudu. ");
INSERT INTO swp_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Tatao numa dobilana eai se totoro wa matadi se oihegibudi, gagiridi eo lailaidi, i lau e se heoheoidada dobila se eo’oeo’oi, to se heamnabaaeauioidi. ");
INSERT INTO swp_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Abotai wau tatao labui se ribalau Lota arinai si ene, “Em tataoyao aidobudi inai? Bosiamyao, eo nanatumyao tatao, e nanatumyao sisine, enamyao eai eanua eai ta, teha eai ta u woea‐hepesadi. ");
INSERT INTO swp_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Paana teha ta abo ai hebaaea, paana oipilina taumiaina debadi eai i lai ariri, GUIAU matana eai, arinai ede GUIAU i hetamarimai bena ai hebaaea.” ");
INSERT INTO swp_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Arinai Lota ie pesa, i ribalau tatao bosianayao aridi eai, isi bena abo nanatunayao sisine se tawasoraidi wa, i ene, “Ehei, eanua ta au torohaigabaei; paana GUIAU eanua ta abo i hebaaea.” Na bosianayao wa aridi eai riba doha talawasi mo. ");
INSERT INTO swp_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Huiana mara i iuiari, aneru wa Lota se dudui, si ene, “U torohai, monem ma nanatumyao sisine labui inai wa u woeahaidi, ata eanua ta ena maisa eai abo au putuhai.” ");
INSERT INTO swp_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Na Lota i laulau bebeda, arinai tatao labui wa se tabelaeidi, ia ma monena, ma nanatunayao sisine labui, nimadi eai se abilau, GUIAU hede i nuatoatoaedi, arinai i woeaidi eo i hetorohaidi eanua murimurina eai. ");
INSERT INTO swp_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Se woea‐hepesadi abo si ene, “Au dago emi mauri debana eai; tabu au itasinibui, e haedi gonu eai ta au tarutoro, ata se unuimiu.” ");
INSERT INTO swp_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lota abo i ribalau aridi eai, i ene, “Agu tanuagayao, taba nige’e. ");
INSERT INTO swp_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Na emi heaheari tauna ta nualolomiu i hearo ina, eo emi abi se lolo ariri arinai au hemaurigu ta; na taba nige ea dago ea lau oea tupidi eai, ata nei eai sabom i hearogu to ea mate. ");
INSERT INTO swp_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Au italau nei, eanua esau hanahanau eai, gonoagu arinai taba ea dago hinage eanua gagirina wa. Metai bena ea dago — i gagiri, e nige’e? — abo nei eai egu mauri ea abi!” ");
INSERT INTO swp_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","I ribaheuio i ene, “Besi, em aiboda ta ea leawa hinage, arinai eanua u ribaei ne taba nige ea hebaaea. ");
INSERT INTO swp_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","U dago heula arinai; taba nige saha ea ginauri i lau e u lage nei eai.” Arinai eanuana esana wa Soara. ");
INSERT INTO swp_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Mahana i dalasaema’o tanoubu i sinai abotai Lota ie lage Soara eai. ");
INSERT INTO swp_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Abo GUIAU we’u gigibori eo alaalasi galewa eai GUIAU arinai i hetarudobei Sodoma eo Gomara potadi eai. ");
INSERT INTO swp_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Eanua ne i heasibuidi, eo gonuna maudoina i hebaaea, eanua wa taumiaidi gamagaridi hinage, eo saha tano eai se ini’ini. ");
INSERT INTO swp_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Na Lota monena ia murina eai i laulau, i itasinibui, to i hemala arita we’una. ");
INSERT INTO swp_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Maratomtom gagirina eai Aberahama, i sae heuheula ena abatoro eai wa GUIAU matana eai; ");
INSERT INTO swp_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","ie itadobi Sodoma eo Gomara eo gonu ne tehana maudoina arinai, ie ita, eanua asuasuna i ini’inisae doha um lailai abagabugabuna asuasuna. ");
INSERT INTO swp_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Arinai ede, huia eai ne Eaubada gonu ne eanuadi i hebaaeadi wa, Aberahama i nuatui, arinai Lota i hepesa bagunai heasibuina boeana eai, huiana ne eanuadi wa aridi eai Lota i miamia wa i heasibuidi. ");
INSERT INTO swp_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lota abotai Soara i laugabaei, ie sae oea tupidi eai ie mia, ma nanatunayao sisine labui, paana Soara miana i matausiei; to we’u duhana esau eai ie mia, ma nanatunayao sisine labui. ");
INSERT INTO swp_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Abo tau‐bagunana i ribalau taumuritana arinai i ene, “Tamada i tautaubad’o, eo tanoubu eai ta nige tau esau taba arida eai i laoma, doha tanoubu ta kamanina. ");
INSERT INTO swp_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ehei, tamada hage waina ta henom, arinai abo ta eno’enoei, doha nei ada isimurita abo se tubu, tamada debana eai.” ");
INSERT INTO swp_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Arinai maionana eai ne tamadi waina se henom; abo taubaguna ie lau, ma tamana se eno; ia nige abina ie ata, aitea huia eai natuna ie eno, eo aitea huia eai i torohaiuio. ");
INSERT INTO swp_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Mara ie ton eai taubaguna wa abo i ribalau taumurita arinai ie ene, “U ita boni tamada maegu aie eno; hage maiona ta waina eai ta henomuioi; oa abo u lau maem au eno, abo ada isimurita se tubu, tamada debana eai.” ");
INSERT INTO swp_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Arinai maionana eai ne hinage tamadi waina se henomuioi; taumurita wa ie lau ma tamana se eno; ia nige abina ie ata aitea huia eai natuna ie eno, e aitea huia eai i torohaiuio. ");
INSERT INTO swp_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Arinai abo Lota nanatunayao sisine wa taudi labui se boga, tamadi debana eai. ");
INSERT INTO swp_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Taubaguna abo natuna tau i labasi, esana ie tore Moaba; ia Moaba tataodi tamadi ede, i laoma e wau ta. ");
INSERT INTO swp_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Taumurita ia hinage natuna tau i labasi, eo esana ie tore Ben‐ami; ie Amona tataodi tamadi ede, i laoma e wau ta. ");
INSERT INTO swp_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Nei eai Aberahama i torohai i lauwasi ie lau Negeba tanona eai, Kadesa eo Sura duaduaridi eai ie mia; eo Gerara eai hinage ie mia. ");
INSERT INTO swp_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Aberahama abo monena Saraha wa i ribaei i ene, “Ia lougu ede.” Arinai Abimeleko, Gerara edi wasawasa, i lauhetamari eo Saraha ie abi. ");
INSERT INTO swp_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Na Eaubada i laoma Abimeleko arinai, enosuai eai, maiona eai, i ribalau arinai, i ene, “U ita, oa taumate, sine ue abi wa debana eai, paana ia tau esau monena.” ");
INSERT INTO swp_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimeleko wa sora nige i lau sine wa arinai; arinai i ene; “Guiau e, tatao nige adi giru abo u unuidi? ");
INSERT INTO swp_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ia i heribagu, e nige’e, i ene, ‘Lougu ina.’ Sine wa hinage i ene, ‘Tau ta lougu.’ Ma nua‐duduraigu eai, eo ma nima‐aagu eai laulau ta ea abi.” ");
INSERT INTO swp_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Abo Eaubada enosuai eai i ribalau arinai i ene, “Hedeona, ea nuatuiyao oa ma nua‐duduraim eai laulau ta ue abi, eo eau ede ea abi nuahim to nige baaea u ginauri arigu eai, arinai nige ea eari ia bena u abilau arinai. ");
INSERT INTO swp_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Besi, tau wa monena u moseuioi; paana ia peroweta, ia abo enam i lau‐uura arinai oa abo u mauri. Na ena nige u moseuioi, u nuatui mamohoi ariri abo u mate, oa maem tataoyao gamagaridi.” ");
INSERT INTO swp_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimeleko maratomtom eai i toro heuheula, ena heaheari tataodi gamagaridi i eogaidi, ginauri gamagaridi ta i heribadi; ena tatao wa abo se matausi ariri. ");
INSERT INTO swp_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimeleko abo Aberahama i eogai, i ribalau arinai i ene, “U sahaimai ina? Eo eau saha arinai ea hebaaeam arinai baaea lailai u leama eau eo egu basileia potamai eai? Ginauri nige i lolo se ginauridi, arigu eai u abidi ede.” ");
INSERT INTO swp_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimeleko Aberahama abo i heriba i ene, “Oa em nuatu saha, na laulau ta u hetubu?” ");
INSERT INTO swp_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Aberahama i ene, “Ea ginauri paana egu nuatu ea ene, Eaubada matausina ina tupo maudoina eai ta nige’e, arinai abo se unuigu monegu debana eai. ");
INSERT INTO swp_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Hinage mamohoi ia lougu ede, tamagu natuna esau, na nige sinagu natuna, to i hemala eau monegu. ");
INSERT INTO swp_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Huiana ne Eaubada i hetamarigu bena tamagu ena numa ea laugabaei ea elielitatausi, ea ribalau sine arinai ea ene, ‘Teina em abataubigaigu ede, haedi ta lage abo u ribaegu u ene, ia lougu.’” ");
INSERT INTO swp_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abimeleko abo mamoe eo bulumakau i abidi, eo heaheari tauauaudi eo sisinedi, i mosedi Aberahama arinai, eo monena Saraha i moseuioi arinai. ");
INSERT INTO swp_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimeleko abo i ene, “U ita, egu tano ede matam eai, aisega dimo u henua arinai u mia.” ");
INSERT INTO swp_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Saraha arinai i ene, “U ita, loum wa moni silver tausani esega ea mosei, em taumaeamaea maisana isi gamagaridi maem wa matadi eai, eo tatao gamagaridi matadi eai oa se heduduraim’o.” ");
INSERT INTO swp_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Aberahama i lau‐uura Eaubada arinai; Eaubada abo Abimeleko i helolouioi, monena hinage eo ena heaheari sisinedi, isi abotai merumeru se labasidi. ");
INSERT INTO swp_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Paana GUIAU Abimeleko ena numa taumia sisinedi gamagaridi bogadi i he’agaridi, Saraha, Aberahama monena wa debana eai. ");
INSERT INTO swp_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","GUIAU ie lage Saraha arinai doha i ribaei wa, eo ena ribahesunuma hinage GUIAU ginauriwatai. ");
INSERT INTO swp_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Saraha abo ie boga, eo Aberahama natuna i labasi, ia i tautaubadao, huiana eai wa Eaubada i heribayao. ");
INSERT INTO swp_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Aberahama ia natuna Saraha i labasi wa, esana ie tore Isaako. ");
INSERT INTO swp_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Aberahama natuna i heperitome ia ena asubena hehaligigi‐haionana eai, doha Eaubada ena lauhesom wa. ");
INSERT INTO swp_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Aberahama ena borimai handere esega huiana eai ne natuna Isaako se labasi. ");
INSERT INTO swp_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Na Saraha i ene, “Eaubada egu aba maruhi i leama, aidimodi wasagu se ataiei abo se maruhi maeguyao.” ");
INSERT INTO swp_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Hinage i ene, “Eai gonoana taba Aberahama i heriba i ene, ‘Saraha ia abo merumeru tauhemadodi esau?’ Ia mo natuna ea labasiyao ia tautaubadana eai ta.” ");
INSERT INTO swp_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Merumeru wa abo ie tubu, ie lau e susu se hedabu: hedabuna asubenana eai wa Aberahama mataasi lailaina i ginauri. ");
INSERT INTO swp_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Na Saraha Aigupito sinena Hagara natuna Aberahama enana i labasi wa, ie ita maena ia natuna Isaako se aiaihea, ");
INSERT INTO swp_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","to i ribalau Aberahama arinai i ene, “Heaheari sinena ta ma natuna u aiduiedi. Heaheari sinena ta natuna ia taba nige gogo tupona i abi natugu Isaako maena.” ");
INSERT INTO swp_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Riba ta Aberahama i heamna baaea, natuna wa debana eai, ");
INSERT INTO swp_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Na Eaubada Aberahama arinai ie riba i ene, “Tabu nuam i amamna gama ta debana eai, eo em heaheari sinena debana eai. Saraha saha i ribaei u ginauri, ena riba u lauwatai, paana Isaako debana eai abo oa am isimurita esadi se ataidi. ");
INSERT INTO swp_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Na heaheari sinena natuna wa ia hinage abo i hemala basileia, paana ia hinage natum.” ");
INSERT INTO swp_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Arinai maratomtom eai Aberahama i toroheula ariri falawa ie abi, eo sarai opina eai goila i hegoi, Hagara i mosei, i toresae dabayarona eai, natuna hinage, eo i hetamari ie lau. To ie lau abo i laulau gaibu Biera‐siba barabarana eai. ");
INSERT INTO swp_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","I lau e goila sarai opina eai wa ie ohi abo merumeru i gabadobei oeagi gagirina esau paana eai. ");
INSERT INTO swp_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","I tausuara begana to ie bawa, edana lohana doha pidu se tu, paana i ene, “Nige ea henua bena merumeru matagu eai i mate.” Ma babawasuarana merumeru arinana i helai ie dou. ");
INSERT INTO swp_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Gama wa arinana Eaubada i ataiei abo Eaubada ena aneru galewa eai ie eoga Hagara arinai i ene, “Hagara e, saha i henuadubum ta? Tabu u matausi, Eaubada gama wa arinana i ataieyao em aba ota eai ne. ");
INSERT INTO swp_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","U toro gama u abisini, u abididini nimam eai, paana ia arinai abo basileia lailaina ea hetubu.” ");
INSERT INTO swp_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Abo Eaubada sine wa matana i helaladi to goila ipuna ie ita: abo ie lau sarai opina wa goila eai i hemonau, eo gama ana i mosei ie nom. ");
INSERT INTO swp_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Gama wa abo i tubusae Eaubada maena; barabara eai ie mia eo i hemala pidu tautuna esau. ");
INSERT INTO swp_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Parana barabarana eai ie mia to sinana Aigupito oeana eai sine esau i woeaiama abo monena. ");
INSERT INTO swp_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Huiana eai nei Abimeleko eo Pikolo ena tauiala bodadi tauwoeaidi se ribalau Aberahama arinai si ene, “Em abiabi gamagaridi eai ea ita Eaubada maem, ");
INSERT INTO swp_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Arinai bena Eaubada esana eai enagu u riba aigora, taba nige huia esau abo abiborabora arigu eai u ginauri e nanatuguyao aridi eai, eo agu isimurita. Doha eau egu abilolo arim eai oa hinage bena em abiabi doha nei eau arigu eai, eo tano arinai u miamia ta hinage.” ");
INSERT INTO swp_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Aberahama i ene, “Abo ea riba aigora.” ");
INSERT INTO swp_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Huiana Aberahama Abimeleko ena heaheari tataodi i hegirudi paana ana goila sarana esau se girihai. ");
INSERT INTO swp_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimeleko i ene, “Eau nige abina ea ata eai laulau ta i ginauri: oa nige u heribagu, eo wasana nige ea ataiei i laoma e asubena ta.” ");
INSERT INTO swp_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Arinai Aberahama mamoe eo bulumakau i abidi eo Abimeleko i mosedi, eo tataodi labui edi ribahesunuma se ginauri. ");
INSERT INTO swp_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Aberahama mamoe eawoina eai mamoe nanatudiyao bawesinadi haligigi‐labui i abihesuaradi. ");
INSERT INTO swp_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimeleko i ribalau Aberahama arinai i ene, “Ina mamoe nanatunayao bawesinadi haligigi‐labui u abi hesuaradi ta, aniona saha?” ");
INSERT INTO swp_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","I heuio i ene, “Ina mamoe nanatudiyao bawesinadi haligigi‐labui ta abo eau nimagu eai u abidi, abo oa enagu tauriba ede, goila huana ta eau tau sarana.” ");
INSERT INTO swp_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Arinai teha ne esana se tore Biera‐siba paana nei eai taudi labui se riba aigora. ");
INSERT INTO swp_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Arinai Biera‐siba eai edi ribahesunuma se ginauri, abotai Abimeleko maena Pikolo ena iala bodana tauwoeaina wa se torohai se uio Pilistia edi tano eai. ");
INSERT INTO swp_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Aberahama oeagi tabuna esau i umai Biera‐siba eai abo nei eai GUIAU esana i atai, Mauri Nige Nosina Eaubadana. ");
INSERT INTO swp_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abo Aberahama Pilistia eai ie mia asubena gamagamagari. ");
INSERT INTO swp_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ina ginauri ta muridi eai Eaubada lauita i mosei Aberahama arinai, i ribalau arinai ie ene, “Aberahama e!” I riba heuio i ene, “Eau ede ina.” ");
INSERT INTO swp_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Eaubada i ene, “Natum u woeai, natu‐ese’esegam u gadosisie wa, Isaako, abo au lau tupo Moria eai, nei eai ia abo u moselaei em aitalasam gabugabuna oea tupina esau potana eai, sora abo ea heitam.” ");
INSERT INTO swp_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Arinai Aberahama i toroheula maratomtom gagirina eai, ena asini abageruina ie au, ana hewari labui maenayao eo natuna Isaako i woeaesegaidi; oeagi i aitom aitalasam gabugabuna enana, abo se torohai se lau wau tupo wa Eaubada i heribayao wa arinai. ");
INSERT INTO swp_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Asubena hehaionana eai Aberahama matana i helabaisinidi dimona wa ie ita eda lohaloha eai. ");
INSERT INTO swp_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abo Aberahama ena hewari i heribadi, “Inai au mia, asini maemiu; gama ta maegu abo ai lau nei eai ai aihelahui, abotai ai uioma arimiu eai.” ");
INSERT INTO swp_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abo Aberahama aitalasam gabugabuna oeagina ie abi ie tore natuna tau Isaako dabayarona eai; eo nimana eai oeagi ala’alasina eo nigo i abidi, abo taudi labui se lau esega. ");
INSERT INTO swp_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaako i ribalau tamana arinai i ene, “Tamagu!” Aberahama i heuio, i ene, “Natugu, eau ede ina.” I ene, “Oeagi alaalasina ina eo oeagi augogona, na mamoe bena aitalasam gabugabuna mo haedi eai?” ");
INSERT INTO swp_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Na Aberahama i ene, “Natugu e, Eaubada iabom mamoe esau aitalasam gabugabuna enana abo i henonohai.” To taudi labui se lau labulabui se lau. ");
INSERT INTO swp_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Dimo wa Eaubada i ribaei wa arinai se lage, abotai Aberahama aba‐aitalasam i tarini, potana eai oeagi i hatai komakomanidi, natuna Isaako abo ie pai, eo i he’enosaei oeagi wa potadi eai. ");
INSERT INTO swp_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abotai Aberahama nimana i loloilaei nigo i abilau arinai natuna bena i unuhemate, ");
INSERT INTO swp_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","na GUIAU ena aneru galewa eai i eogalau, i ene, “Aberahama e! Aberahama e!” To i heuio, “Eau ede ina.” ");
INSERT INTO swp_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","I ene, “Nimam tabu u torelaei natum potana eai, eo tabu u sahai; paana ea itayao ede, Eaubada u matausiei arinai natum ta, natueseesegam ta nige u nuahi arigu eai.” ");
INSERT INTO swp_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Aberahama matana i helabaisinidi, i italau, na dagelana eai mamoe tamoana ie ita donana oeagi gagirina eai se aitala’ahi: Aberahama mamoe tamoana wa i toai i toresae ena aitalasam ie gabu, natuna helaudamaina. ");
INSERT INTO swp_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Arinai dimo ne esana Aberahama ie tore ‘GUIAU enada abo i leama’, doha se ribaribaei i laoma e wauta, si ene, “GUIAU ena oea‐tupina eai enada abo se leama.” ");
INSERT INTO swp_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","GUIAU ena aneru ena eogahelabuina galewa eai, ");
INSERT INTO swp_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","I ene, “Eaubom enagu eai ea riba aigora, GUIAU i ribaei, paana laulau ta ue abi, to natum nige u nuahi, natueseesegam tau: ");
INSERT INTO swp_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Mamohoi ariri abo ea ainauiaim, am isimurita abo ea hegamagaridi doha galewa iporadi, eo doha gelegele gabogabo hasarina eai wa. Am isimurita hinage abo adi waiunuyao edi dobila abo se tanuagaidi. ");
INSERT INTO swp_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Eo oa am isimurita debadi eai tanoubu basileiadi gamagaridi abo se helolodi, paana arinagu u awaabiei.” ");
INSERT INTO swp_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Arinai Aberahama ie uio ana hewari aridi eai to se torohai se lau esega se lau Biera‐siba, Aberahama ena aba mia Biera‐siba eai. ");
INSERT INTO swp_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ina ginauri ta muridi eai Aberahama se heriba, “Mileka hinage merumeru i labasidi em tau Nahora enana.” ");
INSERT INTO swp_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Husa taubaguna, maena tau Busa, Kemuela, Arama tamana. ");
INSERT INTO swp_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesa, Haso, Piledasa, Iedelapa eo Betuela. ");
INSERT INTO swp_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuela abotai Rebeka tamana ede, tataodi haligigi haiona Mileka i labasidi Nahora enana, Aberahama ena tau. ");
INSERT INTO swp_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Hinage ena wowosara esana Reumaha, ia Teba, Gaham, Tahasa eo Mahaka i labasidi. ");
INSERT INTO swp_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saraha ie mia ena borimai handere esega eo tau‐esegai‐mate‐haligigi‐haiona; teina Saraha ena mauri huiana borimaidi ede. ");
INSERT INTO swp_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Abotai Saraha i odalele Kiriata‐araba eai, (ia ede Heberona) Kanana tanona eai. Aberahama ie lau Saraha enana i muromuroro eo douna i dou. ");
INSERT INTO swp_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abo ena tau matematena wa i torohaigabaei i ribalau Hito tataodi aridi eai, i ene, ");
INSERT INTO swp_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Eau laolaoma tauna mo, ea miamia boeamiu eai ta: egu tano au leama bena egu aba‐toretoretau emi tupo eai, abo egu taumate edi aba‐puruyamuidi.” ");
INSERT INTO swp_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hito tataodi Aberahama se ribaheuio si ene, ");
INSERT INTO swp_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Ema guiau e, hage u ataiemai; oa wasawasa saesaena boeamai eai. Taba em bousa lolodumadumana u hineri, arinai enam taumate u toredi taba nige esau ena bousa i nuahi e i guduguduim bena taumate u tore.” ");
INSERT INTO swp_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Aberahama i toro, abo i taba’ohu, Hito, eanua tataodi aridi eai, ");
INSERT INTO swp_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","I ribalau aridi eai, i ene, “Ena aue eari egu taumate matagu eai ea puruyamui, au ataiegu eo enagu au awanori bena Eperona, Sohara natuna arinai, ");
INSERT INTO swp_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Makepela duhana, ia enana wa, i leama arigu eai; iaede ena oea sigasigana eai, maisana maudoina debana eai i leama omi matamiu eai, abo ea abi enagu, egu aba‐toretoretau.” ");
INSERT INTO swp_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Wau Eperona wa i babawa Hito tataodi boeadi eai, abo Eperona, Hito tauna wa, Aberahama ena riba i hemaisa Hito tataodi gamagaridi matadi eai, eo isi ena eanua dobilana aba‐lusorana matadi eai, i ene: ");
INSERT INTO swp_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Nige’e, egu guiau e, egu riba u ataiei, oea ta abo ea ainauiaim, eo duha wa boeana eai, egu tatao nanatudiyao matadi eai ea leawa ta, arinai abo em tau mate u toredi.” ");
INSERT INTO swp_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Aberahama i taba’ohu eanua tataodi matadi eai, ");
INSERT INTO swp_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","I ribalau Eperona arinai, eanua tataodi gamagaridi ena riba se ataiei, i ene, “Na ena au ataiegu mo; oea maisana abo ea leawa nimagu eai bena u abi, bena egu taumate egu aba‐toredi.” ");
INSERT INTO swp_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Eperona Aberahama i heuoi i ene, ");
INSERT INTO swp_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Egu guiau e, u ataiegu wa, tano maisana silver sekela handere hasi, oa eo eau arida eai meta saha? Bena em taumate u tore mo.” ");
INSERT INTO swp_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Aberahama maena Eperona nuadi esega, arinai Aberahama silver i ribaei wa, i nonoi Eperona enana, iaede doha i ribaei wa Hito tataodi beadi eai, silver sekela handere hasi doha tau uneune edi nonononoi huiana ne. ");
INSERT INTO swp_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Arinai, Makepela, Eperona ena tano wa Mamare tupo aruabu eai, oea eo hinage duha, eo oeagi gamagaridi tehana maudoina eai se mosegabaei ");
INSERT INTO swp_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Aberahama arinai, i hemala ia enana, Hito tataodi matadi eai eo isi gamagaridi tau awasae ena eanua dobilana eai. ");
INSERT INTO swp_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Inata murina eai Aberahama monena Sahara ie tore duha alona eai Makepela ena oea eai Mamare matana eai; ia ede Heberona, Kanana eanuana eai. ");
INSERT INTO swp_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Oea eo hinage duha wa se hemala Aberahama enana tahunuana bena ena aba‐toretau, Hito tataodi aridi. ");
INSERT INTO swp_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Aberahama i tautaubada’o, ena borimai se gamagari’o, eo ginauri gamagaridi eai GUIAU Aberahama i ainauiai, ");
INSERT INTO swp_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Aberahama i ribalau ena heaheari tauna arinai, ia taubagubagunana wa ena numa alona eai eo ena ginauri maudoidi ia tauitawataina ede, i ene, “Nimam u tore gotugu ubuna eai. ");
INSERT INTO swp_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Ea henua bena u riba aigora GUIAU debana eai, ia galewa eo tanoubu Eaubadana, taba nige natugu monena u eooi Kanana nanatunayao sisinedi boeadi eai, isi wa boeadi eai ea miamia. ");
INSERT INTO swp_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Na u lau mo egu eanua tahunuana eai eo agu bogaoyao aridi eai, nei eai abo natugu Isaako monena u abi.” ");
INSERT INTO swp_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Heaheari tauna wa arinai i heuio i ene, “Ena taba sinena wa nige i eari bena i hemuriwataiguma eanua eai ta, abo natum eo woeauioi eanua ne arinai u laoma wa?” ");
INSERT INTO swp_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Aberahama i ribalau arinai i ene, “U komakomani, tabu natugu u woeaiuioi nei eai. ");
INSERT INTO swp_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","GUIAU, galewa Eaubadana, ia tamagu ena numa eai eo egu eanua abalabasigu eai i woeahaiguma, i ribalaoma arigu eai ie riba aigora i ene, ‘Am isimurita aridi eai abo tano ta ea mosei’, ia abo ena aneru i hetamari mugaiem, natugu monena abo u lobai nei eai. ");
INSERT INTO swp_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Na ena sinena wa nige i eari bena i hemuriwataim, besi ina aigora ta arinai abo ea earihaim; ia mo natugu tau tabu u woeauioi eanua eai ne.” ");
INSERT INTO swp_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Arinai tauheaheari wa nimana ie tore tanuagana Aberahama gotuna ubuna eai, riba ta aigorana i aigoraei. ");
INSERT INTO swp_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Abotai heaheari tauna wa tanuagana ena kamela saudoudoi i abidi i torohai, ainauia lolololodi gamagaridi tanuagana i mosedi, bena i laedi nimana eai; na i torohai ie lau Mesapotamia eai, Nahora ena eanua eai. ");
INSERT INTO swp_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Abo kamela i heturibonodi, eanua murimurina eai goila huana gegesina eai maimailahi huiana sisine edi huia pesama bena goila se oi. ");
INSERT INTO swp_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","To i ene, “GUIAU e, tanuagagu Aberahama ena Eaubada e, wau ta bena egu laoma aniona i tubu, ea aibodaim ta em gadosisi otaotahaina tanuagagu Aberahama arinai wa bena u hemasaraha ina. ");
INSERT INTO swp_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","U itagu ea totoro goila bunubunuwasina eai ta, eanua tataodi nanatudiyao sisine se laolaoma bena goila se oi, ");
INSERT INTO swp_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","taba mo siuna arinai ea riba, ea ene, ‘Agutoi em ledu me u dobeiama bena ea nom,’ eo ia ena riba i ene, ‘U nom eo em kamela adi hinage abo ea oi,’ ia ena taba sinena ede, ia u tauribaei em heaheari Isaako enana. Teina arinai abo ea nuatui, em gadosisi otaotahaina ede u hemasaraha tanuagagu arinai.” ");
INSERT INTO swp_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Na Rebeka ie ita, sora ma ribaribana, Betuela natuna, ia Mileka natuna, Nahora Aberahama ena tau wa monena. Siu wa i pesama dabayarona eai goila leduna i bahei, i laolaoma. ");
INSERT INTO swp_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Sine wa ana ao i lolo ariri, ia sine nuanuasupuna, sora nige tau esau abina i ata; abo ie dobi goila huana eai wa, ena ledu i hemonau to i saema. ");
INSERT INTO swp_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Heaheari tauna wa abo i taulau bena i hailobai, i ene, “Agutoi, goila begana agu u leama em ledu eai me.” ");
INSERT INTO swp_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Sine wa i ene, “Taubada e, u nom” — abo ena ledu nimana eai i laudobei heulai i mosei ie nom. ");
INSERT INTO swp_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","I mosei e i nomlautom abo i ene, “Em kamela adi hinage abo ea oiyama i lau e se nomohi.” ");
INSERT INTO swp_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Arinai ena ledu i hegoiheulai edi abanomnom arinai i aitautau bena huana arinai i hedawadobei i oiuioi ena kamela gamagaridi adi ie oi. ");
INSERT INTO swp_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Tau wa i monomonou eo i aiaiewai i nuatu dadaasaeai, GUIAU ena lauwasi ta i heanio e nige’e. ");
INSERT INTO swp_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kamela se nom lautom abo tau wa nima’au gold porohena sekela tupona, eo arima gold labui, porohedi sekela gold saudoudoi i abidi, ");
INSERT INTO swp_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","to i ene, “Ea aibodaim bena u heribagu, oa eai natuna? Tamam ena numa eai susuana arinai taba ai mia?” ");
INSERT INTO swp_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Siuna i ribaheuio i ene, “Eau Betuela natuna sine, ia Mileka natuna tau, Nahora arinai i labasi.” ");
INSERT INTO swp_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Hinage i ene, “Arimai eai lei aba‐aibai, eo aiai gonoana, eo numa susuana hinage, arinai taba au mia.” ");
INSERT INTO swp_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Tau wa i dulu dobi, GUIAU i aihelahui, ");
INSERT INTO swp_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","I ene, “GUIAU, tanuagagu Aberahama ena Eaubada ea hedebasaei, ena gadosisi ota’otahaina, eo ena abilolo tanuagagu arinai nige i nuagabaei, na eau, GUIAU egu eda eai ta i woeaigu, ea lage tanuagagu ana bogaoyao edi numa eai.” ");
INSERT INTO swp_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Siu wa abo i aitautau sinana ena numa taumiana ginauri ta i heribadi. ");
INSERT INTO swp_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka louna esau esana Labana i aitautau ie lau goila huana wa arinai, wau tau wa hesabana. ");
INSERT INTO swp_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Nima’au ie ita, eo arima louna nimana eai, eo louna Rebeka ena riba i ataiei i ene, “Tau ta ena ribariba arigu eai doha ina” abo ie lau tau wa arinai; tau wa ie ita ena kamela hasaridi eai i totoro goila huana eai. ");
INSERT INTO swp_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","I ene, “GUIAU ena helolo tauna e, u awasaema; paana saha murimuri eai u totoro? Em abamia ea henonohayao, eo kamela aba‐toredi hinage.” ");
INSERT INTO swp_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Arinai tau wa i awasaema numa eai, eo Labana kamela mainadi i iairidi, lagau lei, eo aiai i mosedi, eo goila ie oi bena aena i deuridi, eo tatao maenayao aedi hinage. ");
INSERT INTO swp_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Abo aiai se tore matana eai bena abo i aiai, na i ene, “Taba nige ea aiai, na sora egu laoma mata paana ea riba bagunai.” I ene, “U ribariba.” ");
INSERT INTO swp_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Arinai enaba, “Eau Aberahama ena heaheari tauna. ");
INSERT INTO swp_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","GUIAU tanuagagu i ainauia aririei, i hemala taulailaina, mamoe eo bulumakau eawoidi i mosedi, silver eo gold, heaheari tataodi, eo heaheari sisinedi, kamela eo asini. ");
INSERT INTO swp_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Na Saraha, tanuagagu monena, tanuagagu natuna i labasi na i sinesinebada’o, eo ena gogo maudoina i moseyao. ");
INSERT INTO swp_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Tanuagagu i lauhesomgu gena ea riba aigora, i ene, ‘Taba nige natugu monena u eooi Kanana nanatudiyao sisinedi aridi eai, isi wa edi tano eai ea mia ta. ");
INSERT INTO swp_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Na abo u lau tamagu ena asa eai, eo agu bogaoyao aridi eai, metai abo natugu monena u abi.’ ");
INSERT INTO swp_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ea ribalau tanuagagu arinai ea ene, ‘Ata bena sine wa nige i henua i hemuriwataiguma.’ ");
INSERT INTO swp_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Na i ene, ‘GUIAU, ia matana eai ea laulau ta ena aneru abo i hetamari maem, em eda eai abo i helolom, na oa abo sine u woeaiama agu bogaoyao aridi eai, eo tamagu ena asa eai abo natugu monena u abi. ");
INSERT INTO swp_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Arinai abo em aigora arimai ea eairihaim; ena u lage agu bogaoyao aridi eai na nige se eari bena se leawa, taiede, em aigora arinai abo ea eairigabaem.” ");
INSERT INTO swp_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Wauta ea lalage goila huana eai ea ene, ‘GUIAU e, tanuagagu Aberahama ena Eaubada e, taba egu lauwasi bena u heanio. ");
INSERT INTO swp_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","U itagu goila huana gegesina eai ea totoro ta, ena taba siu esau i pesama goila bena i oi, na ea ribalau ea ene, “Agutoi, goila agu begana u leama em ledu eai me ea nom.” ");
INSERT INTO swp_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ena egu riba i heuio i ene, “U nom, em kamela adi hinage abo ea oiyama.” taba ia bena sinena ede, ia ede GUIAU i tauribaei wa tanuagagu, natuna tau enana.’ ");
INSERT INTO swp_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Nuaboeagu eai ma ribaribagu na ne Rebeka ea ita i pesama ledu dabayarona eai i bahei, ie dobi goila huana ie oi. Ea ribalau arinai ea ene, ‘Agutoi, taba ea nom.’ ");
INSERT INTO swp_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ena ledu dabayarona eai i laudobei heuheulai i ene, ‘U nom em kamela adi abo ea oi hinage.’ Arinai ea nonom eo egu kamela adi i mosedi se nom hinage. ");
INSERT INTO swp_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Abo ea oimuri ea ene, ‘Oa eai natuna?’ I ene, ‘Eau Betuela natuna siu, ia Nahora natuna, Mileka i labasi wa.’ Arinai bea omo’omo ea toredi, eo arima imana eai. ");
INSERT INTO swp_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Eau ea dulu dobi GUIAU ea aihelahui, GUIAU ea ribahelolo, tanuagagu Aberahama ena Eaubada ia eda duduraina eai i woeaigu arinai tanuagagu ana bogao tauna natuna siu abo ea woeai ia natuna tau enana. ");
INSERT INTO swp_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ehei, ena emi abi se dudulai, eo em abi se lolo tanuagagu arinai au heribagu, ena nige’e au heribagu, hinage abo ea nuatui, tupo tutu eai ea lau e tupo seuseuri.” ");
INSERT INTO swp_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Abo Labana eo Betuela ribana se heuio si ene, “Ginauri ta GUIAU arinai i laoma, ai taba nige saha ai ribaei lolona e baaeana. ");
INSERT INTO swp_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka u ita, matam eai me, u woeai, u laei, ia abo tanuagam natuna monena doha GUIAU i ribaei.” ");
INSERT INTO swp_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Aberahama ena heaheari tauna edi riba i ataiedi, i tabaohu tano eai GUIAU matana eai. ");
INSERT INTO swp_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Heaheari wa pasa silver eo gold i lahahepesadi, eo lulu, to i mosedi Rebeka arinai, sinana eo louna hinage pasa maisa lailaidi i mosedi. ");
INSERT INTO swp_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Abo ia maena tataoyao se ai eo se nom, eo nei eai maiona eai se eno: Mara‐ie‐tom, se eno toro i ene, “Au hetamarigu bena ea uio tanuagu arinai.” ");
INSERT INTO swp_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Sinana eo louna si ene, “Sora siu ta i mia begana arimai eai doha asubena saudoudoi, muridi eai abo au lau.” ");
INSERT INTO swp_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Na heaheari ia wa i ribalau aridi eai i ene, “Tabu au heboneawagu, GUIAU egu laoma ta i heanio, besi au buigabaegu, ea uio tanuagagu arinai.” ");
INSERT INTO swp_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Si ene, “Siuna abo ta eogai ta hesioei.” ");
INSERT INTO swp_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","To Rebeka se eogai se ribalau arinai si ene, “Abo ina tau ta maem au lau wa?” Ia i ene, “Abo ea lau.” ");
INSERT INTO swp_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Arinai Rebeka, loudi wa, se hetamari ie lau, maena sinetauitawataina, eo Aberahama ena heaheari tauna, eo ana sasaguyao. ");
INSERT INTO swp_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Eo Rebeka se ribahelolo, se ribalau si ene, “Loumai e, oa abo tausani eo tausani saudoudoi sinadi ede: eo am isimurita tau hewaiunuedi edi aba‐lau se abi enadi!” ");
INSERT INTO swp_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Abotai Rebeka ma ena heaheari sisinedi se torohai kamela dageladi eai se geru, tau wa se hemuriwatai. Doha ina heaheari tauna wa Rebeka ie abi eo ena dobila eai ie lau. ");
INSERT INTO swp_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isaako Biera‐lahai‐roi huana eai wa i laoma, Negeba tehana eai i miamia. ");
INSERT INTO swp_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Maimailahi eai Isaako ie pesa oea eai i laulauwayo bena nuana i hedosiuioi eo i nuanuatuadidiri; abo matana i helabaisinidi to nei kamela i itadi se laolaoma. ");
INSERT INTO swp_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka i itasae, Isaako ie ita, to kamela i pesagabaei. ");
INSERT INTO swp_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","eo iribalau heaheari tauna wa arinai i ene, “Tau ne eai, oea eai i laolaoma bena i hailobaida?” Heaheari tauna wa i ene, “Meta agu tanuaga.” Arinai ena abobo ie abi to matana i umui. ");
INSERT INTO swp_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Heaheari tauna wa ginauri gamagaridi i ginauridi wa Isaako i heriba. ");
INSERT INTO swp_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isaako abo Rebeka wa i woeai sinana Sahara ena numa‐lulu eai, abo Rebeka ie abi, i hemala monena, eo i gadosisiei. Abotai Isaako ena abo nuabiga i lobai sinana ena mate murina eai. ");
INSERT INTO swp_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Aberahama monena esau ie abi, esana Ketura, ");
INSERT INTO swp_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Nanatunayao Simarana, Iokosan, Medana, Midiani, Isabaka, eo Sua i labasidi. ");
INSERT INTO swp_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Iokosan ia Siba eo Dedani tamadi. Dedani nanatunayao tatao ede Asurim, Letusima eo Leumimo. ");
INSERT INTO swp_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midiani nanatunayao tatao ede Epaha, Epera, Hanoka, Abida, Eladaa, gamagaridi ta Ketura tubutubunayao. ");
INSERT INTO swp_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Aberahama ena gogo maudoina i mosei Isaako arinai, ");
INSERT INTO swp_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","na ena wowosara nanatudiyao Aberahama ainauia mo i mosedi, eo ia ma miana na i hetamaridi natuna Isaako se miasuaraei, tupo aruabu tehana eai se mia. ");
INSERT INTO swp_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Aberahama ena mauri asubenadi eo borimaidi ede ina, borimai handere esega, eo tatao‐haiona‐se‐mate‐saudoudoi‐haligigi. ");
INSERT INTO swp_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Aberahama eawasina ie ohi to i odalele, i tautaubada aririo ena borimai gamagamagaridi sigadi eai, eo se laei ana bogaoyao aridi eai. ");
INSERT INTO swp_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Nanatunayao Isaako eo Isamaela tamadi se tore duha esau Makepela eai, Eperona Sohara natuna ena oea eai, ia Hito tauna wa, Mamare tupo aruabu eai, ");
INSERT INTO swp_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","tano Aberahama ie une Hito tataodi aridi eai. Temetai Aberahama se tore monena Saraha hasarina eai. ");
INSERT INTO swp_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Aberahama ena mate murina eai natuna Isaako, Eaubada i helolo, Isaako wa Biera‐lahai‐roi eai ie mia. ");
INSERT INTO swp_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Isamaela ana isimurita ede ina: ia wa Aberahama natuna Saraha ena heaheari Hagara Aigupito sinena wa i labasi. ");
INSERT INTO swp_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Isamaela nanatunayao tatao esadi ede ina, tau baguna i lau e tau murita: Nebaiota, Isamaela natu ealahouna, eo Kedare, Adebeala eo Mibasam. ");
INSERT INTO swp_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misima, Dumaha, Masa. ");
INSERT INTO swp_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadadi, Tema, Ietura, Napisi, eo Kedema. ");
INSERT INTO swp_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Teina Isamaela nanatunayao tatao esadi ede, edi asa, eo edi gougou esadi hinage, edi wasawasa saudoudoi‐labui boga hasihasirina ede. ");
INSERT INTO swp_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isamaela ena mauri borimaidi ede ina, handere esega eo tau‐esega‐i‐mate‐saudoudoi‐haligigi‐labui: eawasina ie ohi to ie mate, eo se laei ana bogaoyao aridi eai. ");
INSERT INTO swp_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Isi edi aba‐mia Havila i lau e Sura, ia ede Aigupito matana eai, Asiria edana eai. Ana bogaoyao gamagaridi nei eai i miasuaraedi. ");
INSERT INTO swp_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Isaako, Aberahama natuna, ana isimurita ede ina. Aberahama Isaako tamana ede. ");
INSERT INTO swp_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaako ena borimai tatao labui se mate, na Rebeka ie abi monena, ia Betuela natuna siu, Arama tauna wa Padana‐arama eai ie mia, eo louna Labana Arama tauna. ");
INSERT INTO swp_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Na Isaako GUIAU arinai i aiboda monena debana eai, paana i agari: na GUIAU ena uura i ataiei, abo Rebeka ie boga. ");
INSERT INTO swp_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Merumeru tauna boeana eai se haiabi, to i ene, “Paana saha doha ina ea hearo?” To ie lau GUIAU arinai i oimuri. ");
INSERT INTO swp_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","GUIAU i ribalah ia arinai i ene, “Basileia labui oa bogam eai, tatao peledi labui oa arim eai se labasidi, abo se peilabuiedi, esau abo i adidiri, ena tau abo i saepoi, taubaguna abo tau murita ena heaheari eai i lau.” ");
INSERT INTO swp_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ena asubena se ohi bena i haisu, hede mamohoi godegode ia bogana eai. ");
INSERT INTO swp_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Bagubagunana i laoma i buiabuia, tauna maudoina se orooro doha lulu oroorona; arinai esana se tore Isoa. ");
INSERT INTO swp_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Murina eai ena tau se labasi nimana eai ae gedurina i abididini, arinai esana se tore Iakobo. Isaako ena borimai tatao‐haiona‐se‐mate huiana eai ne monena i labasidi. ");
INSERT INTO swp_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Merumeru wa se taulailai abo Isoa ia tauailoea saesaena na Iakobo ia tau manabiga, numaalo tau miamiaina. ");
INSERT INTO swp_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaako Isoa i gadosisiei paana aiailoea aiaidi i aidi, na Rebeka Iakobo i gadosisiei. ");
INSERT INTO swp_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Huia esau Iakobo liu ie riga, Isoa oea eai i laoma to i wesari ariri. ");
INSERT INTO swp_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Isoa i ribalau Iakobo arinai i ene, “Liu buiabuiana u leama ea ai paana ea wesari matemate!” (Arinai esana esau ede Edoma.) ");
INSERT INTO swp_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Iakobo i ene, “Em ealahou ainauiana u unegabaei arigu eai baguna.” ");
INSERT INTO swp_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Isoa i ene, “Mate i hanahanauigu ta ealahou ainauiana ena lolo saha abo i helologu?” ");
INSERT INTO swp_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Iakobo i ene, “U riba aigora arigu eai wauta.” Arinai i riba aigora, to ena ealahou ainauiana i unegabaei Iakobo arinai. ");
INSERT INTO swp_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Abotai Iakobo falawa eo liu buiabuiana ma aiaina i mosei Isoa arinai ie ai eo ie nom, eo i torohai ena eda eai ie lau. Doha ina Isoa ena ealahou ainauiana i nuatuhegagiri. ");
INSERT INTO swp_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Abotai guriam lailai eanua eai ne ie tubu doha guriam bagubagunana wa, Aberahama ena huia eai. Isaako abo ie dobi Gerara eai Abimeleko Pilistia edi wasawasa arinai. ");
INSERT INTO swp_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","GUIAU i hemasarahauioi ia arinai i ene, “Tabu u dobi Aigupito eai, eanua enam ea ribaei mo arinai u mia. ");
INSERT INTO swp_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Teina eanua eai ta u miahai eau abo maem, abo ea ainauiaim paana tano gamagaridi ta abo ea lediwa oa arim eai, eo am isimurita hinage, eo egu aigora tamam Aberahama arinai abo ea hemamohoieidi. ");
INSERT INTO swp_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Am isimurita abo ea hegamagaridi doha ipora galewa eai eo tano gamagaridi ta abo ea mosedi am isimurita aridi eai, eo am isimurita debadi eai tanoubu basileiadi gamagaridi abo se helolodi. ");
INSERT INTO swp_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Paana Aberahama arinagu ie ataiei eo egu riba i sogohi, egu lauhesom egu laugagaeo eo egu riba hedudurai.” ");
INSERT INTO swp_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Arinai Isaako Gerara eai ie mia. ");
INSERT INTO swp_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Huiana ne eanua tataodi monena se hetala, i ene, “Lougu ede,” i matausi ena i ene, “Monegu ede,” ena nuatu “Eanua tataodi ata se unuigu Rebeka debana eai,” paana sine wa ana ao i lolo ariri. ");
INSERT INTO swp_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isi huia lohaloha ma miadi nei eai, Abimeleko, Pilistia edi wasawasa ena numa tamlapaina eai i italau Isaako ie ita monena Rebeka i haitalagadoi. ");
INSERT INTO swp_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","To Abimeleko Isaako i eogai i ene, “Hedeomi monem meta, paana saha u ene ‘ia lougu’?” Isaako ena riba i heuio, “Paana ea nuatui ata ia debana eai ea mate.” ");
INSERT INTO swp_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimeleko i ene, “Ina saha ue abi arimai eai? Ena tau esau ata bena ma monem se eno, abo giru lailai u leama potamai eai.” ");
INSERT INTO swp_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Arinai Abimeleko ena tatao gamagaridi i ribahesanapuedi, i ene, “Aitea tau ena i abilau tau ta e sine ta aridi eai, ia abo se unuhemate.” ");
INSERT INTO swp_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaako oea eai ne ie uma, eo borimaina ne boeana eai ena umauma masurina laina doha ma tatao‐haligigi‐se‐mate, eo GUIAU i ainauia aririei. ");
INSERT INTO swp_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Arinai tau wa i hemala gogo tauna, ena gogo i helahelai i lau e i hemala tau monamonaune mamohoi. ");
INSERT INTO swp_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ena gogo ede mamoe eawoidi, bulumakau eawoidi, eo ena numa taumiaidi se gamagari ariri, to Pilistia tataodi se aiaromagigiriei. ");
INSERT INTO swp_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","(Arinai goila huadi ia tamana ena heaheari tataodi se saradi wa, Pilistia tataodi abo se gududi, eo tano eai se wuidi, isi ede tamana Aberahama ene huia eai se saradi wa.) ");
INSERT INTO swp_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimeleko i ribalau Isaako arinai i ene, “Besi, u lausuaraemai, paana u didiga ariri, nige doha ai.” ");
INSERT INTO swp_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Arinai Isaako i torohaigabaedi, Gerara gadogadoana eai i abiapa to nei eai ie mia. ");
INSERT INTO swp_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Goila huadi wa tamana Aberahama ena huia eai se saradi wa, Isaako i sarauioidi, paana Aberahama ie mate abo Pilistia tataodi se wuidi, eo esadi tamana i toredi wa i toreuioidi. ");
INSERT INTO swp_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isaako ena heaheari tataodi gadoa ne se sara to goila huana eai ne bunubunuasi se lobai. ");
INSERT INTO swp_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Abo Gerara edi bulumakau tauitawataidi maedi Isaako ena bulumakau tauitawataidi se haiabi, si ene, “Goila ta enamai.” Arinai hua esana se tore Eseka paana sabina se haiabi. ");
INSERT INTO swp_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Abo goila huana esau se sara to hinage se haiabiei; arinai esana ie tore Sitina. ");
INSERT INTO swp_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Abo se sigi se lau tupo esau eai, nei eai hinage goila huana se sara, na nige se luluei arinai esana ie tore Rehobote, i ene, “Abotai GUIAU susuada i ginauri, abo oea eai ta eda masuri ta lobai.” ");
INSERT INTO swp_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Nei eai i torohai ie sae Biera‐siba. ");
INSERT INTO swp_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Maionana eai ne GUIAU i taumasaraha ia arinai i ene, “Eau tamam Aberahama ena Eaubada, tabu u matausi, eau maem abo ea ainauiaim, eo am isimurita abo ea hegamagaridi egu heaheari tauna Aberahama debana eai.” ");
INSERT INTO swp_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Arinai nei eai aba’aitalasam hatana i hetoro eo GUIAU esana i atai eo nei eai ena numa‐lulu i hetoro. Nei eai hinage Isaako ena heaheari tataodi goila huana esau se sara. ");
INSERT INTO swp_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abotai Abimeleko ma ana sagu Ahusata, eo Pikolo ena iala bodana tauwoeaina, isi Gerara eai se torohai se lau Isaako hesabana. ");
INSERT INTO swp_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaako i ribalau aridi eai i ene, “Paana saha au laoma arigu eai, omi tau hewaiunuegu eo tau aiduiegu wa?” ");
INSERT INTO swp_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Si ene, “Au ita i masaraha ariri hede GUIAU oa maem, arinai ai ene taba oa eo ai eda aigora duaduarida eai, eo ta ribahesunumauioida, ");
INSERT INTO swp_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","bena taba nige u hebaaeamai, doha ai nige saha ai ginauri arim eai na lolo mo eo ai hetamarim ue lau ma nuabigam. Wauta oa GUIAU i helolom.” ");
INSERT INTO swp_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Arinai mataasi enadi i ginauri to se ai eo se nom. ");
INSERT INTO swp_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Maraietom se toro heuheula esa esa maediyao se riba aigora, abo Isaako i healatudi to se laugabaei ma nua tarudi. ");
INSERT INTO swp_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Nei asubenana esegana eai Isaako ena heaheari tataodi se laoma hua se sara wasana se heriba, si ene, “Goila ai lobaiyao.” ");
INSERT INTO swp_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Esana ie tore Siba; ia ede eanua esana wa i laoma e wauta ede Biera‐siba. ");
INSERT INTO swp_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Isoa ena borimai tatao‐labui‐se‐mate abo monena Iudita ie hai Bieri Hito tatuna natuna sine, eo Basemata, Elona, Hito tauna natuna sine; ");
INSERT INTO swp_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Na isi Isaako eo Rebeka edi mia se hekalapi aririei. ");
INSERT INTO swp_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaako i tautaubadao eo matana se gaugau, nige i itaita komakomani, ia natuna taubaguna Isoa wa i eogai ia ene, “Natugu e,” eo i heuio i ene, “Eau ede ina.” ");
INSERT INTO swp_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","I ene, “U itagu, ea tautaubada’o, egu mate asubenana nige abina ea ata. ");
INSERT INTO swp_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ehei, em alahia u abidi, em pidu eo pidu gigina, u lau nuura eai agu u ailoea. ");
INSERT INTO swp_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Abo agu anihu lolona u abinonohai, doha agu henuhenu wa abo u leama ea ai, eo sora nige ea mate ea ribahelolom.” ");
INSERT INTO swp_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Isaako natuna Isoa enana i ribariba na Rebeka i ataiei. Arinai Isoa wa ie lau nuura eai bena ailoea aiaina hesabana, ");
INSERT INTO swp_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka i ribalau natuna Iakobo arinai i ene, “Tamam ena riba Isoa arinai ea ataiei, i ene, ");
INSERT INTO swp_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Agu sarai u abiama, agu anihu lolona u henonohai abo eai ai, to GUIAU matana eai sora nige ea mate, na abo ea ribahelolom.’ ");
INSERT INTO swp_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ehei, natugu e, egu riba u awa’abiei ina ea lauhesom ta. ");
INSERT INTO swp_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","U lau goti eawoidi aridi eai, goti nanatudi labui u abidima, aridi eai abo anihu lolona ea ginauri tamam ana, doha ana henuhenu wa. ");
INSERT INTO swp_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Abo u leama tamam ana i ai sora nige ie mate, na oa ede abo i ribahelolom.” ");
INSERT INTO swp_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Na Iakobo i ribalau sinana Rebeka arinai, i ene, “Agutoi, egu tau Isoa ia tau oroorona, eau taugu i sabusabu. ");
INSERT INTO swp_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ata tamagu i abiitagu, ata i ene ea borai, abo nige ribahelolo ribana, na ribahebaaea ribana ea hearo.” ");
INSERT INTO swp_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Sinana i ene, “Natugu e, riba hebaaea abo eau potagu eai i taru, oa mo egu riba u awaabiei, u lau u abidima.” ");
INSERT INTO swp_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Arinai ie lau i abidima sinana arinai, sinana abo anihu gurewana ie riga tamana ena henuhenu wa, ");
INSERT INTO swp_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","abo Rebeka ena taubaguna Isoa ana lulu lolodi numa eai se ota i abidi, eo aridi eai natuna taumurita Iakobo i helui. ");
INSERT INTO swp_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Eo wau goti nanatudi wiadi i toredi nimana eai eo gadona tupo subusabuna eai. ");
INSERT INTO swp_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Eo aiai ma anihu eo falawa i abinonohaidi wa, i toredi natuna Iakobo nimana eai. ");
INSERT INTO swp_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","I awasae tamana arinai i ene, “Tamagu,” to i ene, “Eau ede ina; oa natugu aisega?” ");
INSERT INTO swp_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Iakobo i ene, “Eau Isoa em taubaguna. Em riba ea ginauriyao; u toro u bawa ailoea wa aiaina u ai na u ribahelologu.” ");
INSERT INTO swp_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Na Isaako i ribalau natuna arinai i ene, “Natugu e, edohana to u lobai heula aririei?” I ene, “Paana GUIAU em Eaubada i leama arigu eai.” ");
INSERT INTO swp_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Abo Isaako i ribalau Iakobo arinai, “Natugu u sigilaoma bena ea abi’itam, bena abina ea ata, mamohoi, oa natugu tau Isoa e nige’e?” ");
INSERT INTO swp_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","To Iakobo i sigilau tamana Isaako gegesina eai, tamana i abi’ita, i ene, “Arinam doha Iakobo arinana, na nimam doha Isoa nimana.” ");
INSERT INTO swp_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","I hekau paana nimana se oro’oro doha ena tau Isoa nimana, arinai i ribahelolo. ");
INSERT INTO swp_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Na i ene, “Mamohoi oa natugu Isoa wa?” I ene, “Eau ede.” ");
INSERT INTO swp_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Abo i ene, “Agu u leama, natugu nimana leleana abo ea ai abo ea ribahelolom.” I leama arinai, to ie ai, abo waina i mosei to ie nom. ");
INSERT INTO swp_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Abo tamana Isaako i ribalau i ene, “Natugu e, u laoma gegesigu eai, u alagoiegu.” ");
INSERT INTO swp_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","To i laoma gegesina eai i alagoiei, to ana lulu panena i ataiei, abo i ribahelolo, i ene: “Ia ede, natugu panena ede nuura panena ia ede GUIAU i he’anio! ");
INSERT INTO swp_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Eaubada galewa wabumarina arinai abo i ainauiaim, eo tano masurina uauana lailaina eo sitona aiaina peina, eo waina hinage, ");
INSERT INTO swp_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Hari tatao abo enam se paisoa, basileia abo se taba’ohuim. Em tataoyao oa abo tanuagadi ede, eo sinam nanatunayao arim eai abo se turibono. Tau ribahebaaeam, ia abo se hebaaea aririei, eo tau ribahelolom abo se helolo aririei!” ");
INSERT INTO swp_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isaako, Iakobo i hedebasae lautom, tamana Isaako matana eai i pesalau, na nige baeaona Isoa ie lage ena abaailoea eai i laoma. ");
INSERT INTO swp_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ia hinage aiai anihu i abinonohayao, i leama tamana arinai. I ribalau tamana arinai i ene, “Ehei, u toro, hage natum ena ailoea aiaina u ai, abo u ribahelologu!” ");
INSERT INTO swp_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Tamana Isaako i ene, “Oa eai?” Ia i ene, “Hede eau natum labasi bagunaegu, Isoa.” ");
INSERT INTO swp_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaako abo i tabutabubu ariariri, i ene, “Eai meta sarai i ailoea to i leama, oa soram, na ea aihe’ohiyao eo hinage ea ribaheloloyao? Mamohoi, ia hinage abo se helolo!” ");
INSERT INTO swp_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Isoa tamana ena riba i ataei abo ie dou ma arina lailaina, ena dou i kalapi ariri, i ribalau tamana arinai i ene, “Aioi, tamagu e, eau hinage u ribahelologu!” ");
INSERT INTO swp_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Na i ene, “Em tau ena laulau boraborana eai i laoma oa em helolo ribana i abiyao, i lea’o.” ");
INSERT INTO swp_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Isoa i ene, “Esana se atai dudurai ‘Iakobo,’ paana ina malabui egu tupo i girihai. Egu ealahou ainauiana i girihai, abotai u ita egu helolo ribana i girihai hinage! Nige ribahelolo esau enagu?” ");
INSERT INTO swp_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaako i ene, “Ia ea hetoroyao am tanuaga, ena tataoyao gamagaridi eo moseyao ena heaheari eai se lau, sitona aiaina eo waina arinai ea bousini. Abo enam saha ea leawa, natugu e?” ");
INSERT INTO swp_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Isoa i ribalau tamana arinai i ene, “Tamagu e, em ribahelolo esega dumaduma mo, wa? U hedebasaegu, eau hinage, aioi, tamagu e!” Isoa abo arinana i helai to i dou lailai. ");
INSERT INTO swp_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Abo tamana Isaako ena riba i heuio i ene: “U ita em abamia ede tanoubu masurina oa abo u miasuaraei, wabumarina galewa eai i laoma abo u miasuaraei. ");
INSERT INTO swp_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Em elepa debana eai abo u mia, em tau abo u heayaiyei; na abotai abo u earigabaeiuioim ena oibahe gedugedum eai abo u oigodu.” ");
INSERT INTO swp_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Isoa Iakobo i hewaiunuei, riba lolona arinai tamana i ribaheloloei debana eai, arinai Isoa nuana eai i ene, “Doudou asubenadi tamagu enana, se hanahanauma; muridi eai abo egu tau Iakobo ea unui.” ");
INSERT INTO swp_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Na Isoa natuna taubaguna wa ena riba se ribataubigaedi sinana Rebeka arinai; to esau i hetamari ena taumurita Iakobo i eogaiama, i ribalau ia arinai, i ene, “U ita, em tau Isoa bena i unuim ena abahenuabigauiona. ");
INSERT INTO swp_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ehei, natugu, arinagu ta u awaabiei, u torohai u dago eau lougu Labana arinai, Harana eai. ");
INSERT INTO swp_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ia arinai u mia begana i lau e em tau ana ouyalayala lailaina ta ie taru. ");
INSERT INTO swp_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","I lau e em tau ena ouyalayala i lautom eo em abi arinai wa nuana se hui; paana saha abo asubena esegana eai taumiu labui ea gabaemiu?” ");
INSERT INTO swp_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Abo Rebeka i ribalau Isaako arinai i ene, “Egu mauri ea tausiololoei Hito sisinedi debadi eai. Ena Iakobo Hito sinena esau i tawasorai, eanua ta sinena esau wa, abo egu mauri aniona saha?” ");
INSERT INTO swp_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Abo Isaako Iakobo i eogai i ribahelolo, abo i lauhesom i ene “Taba nige Kanana sinena esau u tawasorai. ");
INSERT INTO swp_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","U torohai u lau Padana‐arama eai, sinam tamana Betuela, ena asa eai, nei eai Labana, sinam louna wa, natuna esau u abi u tawasorai. ");
INSERT INTO swp_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Eaubada Gigibori‐aririna i ainauiaim, uauam i helai, i hegamagari, abo u hemala boga lailai aririna. ");
INSERT INTO swp_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Aberahama ribahelolona taba i leawa arim eai wa, ma’am isimurita hinage, bena em aba‐mia tanodi abo u abidi enamyao, isi ede Eaubada Aberahama i mosei wa!” ");
INSERT INTO swp_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Doha ina Isaako Iakobo i hetamari ie lau, to ie lau Padana‐arama eai, Labana arinai Betuela natuna, Arama tauna wa, ia Iakobo eo Isoa sinadi, Rebeka, louna. ");
INSERT INTO swp_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Isoa ie ita hede Isaako Iakobo i riba helolo, eo i hetamari ie lau Padana‐arama, nei eai bena monena i abi, eo i ribahelolo hinage i heriba, “Tabu Kanana sinena esau u tawasorai.” ");
INSERT INTO swp_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Eo hinage Iakobo tamana eo sinana i awa abieidi to ie lau Padana‐arama eai. ");
INSERT INTO swp_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Arinai Isoa i italobai hede Kanana sisinedi tamana Isaako nige i henuadi, ");
INSERT INTO swp_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","To Isoa ie lau Isamaela eai, monena esau ie abi, ia ede Mahalate, Isamaela, Aberahama natuna tau wa, natuna siu, eo Nebaiota louna: eo monenayao headi i heesegaidi. ");
INSERT INTO swp_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Iakobo Biera‐siba i laugabaei, eo Harana hesabana i laulau, ");
INSERT INTO swp_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","ie lage dimo esau arinai ie mia meta maionana, paana mahana i duio. Dimo ne we’una esau ie abi uruna eai ie tore, i aiunuaei to nei eai ie eno. ");
INSERT INTO swp_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Na i enosuai, paipeo tano eai se hetoro ie sae e galewa eai ie lage, na nei eai Eaubada ena aneru paipeo arinai se sae eo se dobi. ");
INSERT INTO swp_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Abo GUIAU dedeana eai i totoro, eo i ene, “Eau GUIAU ede, tamam Aberahama ena Eaubada, eo Isaako ena Eaubada, ina tano ta potana eai ue eno wa abo ea mosei oa arim eai, eo am isimurita aridi eai. ");
INSERT INTO swp_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Am isimurita abo doha tanoubu muamuana abo eanua maudoina se hemonau tupo mahana ena aba‐dui, eo mahana ena aba dalasae, tupo bauri, eo tupo eawana, eo oa debam eai, eo am isimurita debadi eai, abo tanoubu eai ta boga gamagaridi abo se helolodi. ");
INSERT INTO swp_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","U ita, Eau maem, abo ea itawataim em abalau haedi eai, abo ea woeauioim ina tano eai ta. Taba nige ea laugabaem i lau e saha ea ribaei ea hemamohoiei.” ");
INSERT INTO swp_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Iakobo i eno siliata, i ene, “Mamohoi GUIAU ia ina dimo eai ta, na nige ea nuatui.” ");
INSERT INTO swp_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Abo i matausi i ene, “Dimo ta i didiga ariri! Mamohoi Eaubada ena numa ede ina ta, ina galewa aba‐lusorana!” ");
INSERT INTO swp_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Iakobo i toro heuheula maratomtom gagirina eai, we’u i ai’unuaei wa ie abi, i hetoro doha du, eausi i hegoi potana eai. ");
INSERT INTO swp_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Dimo ne esana ie tore Beteli na dimo ne eanuana bagubagunana eai wa esana Lusa. ");
INSERT INTO swp_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Iakobo abo i riba aigora i ene, “Ena Eaubada abo maegu eo dobila eai ta ea laulau arinai abo i itawataigu, eo aiai i leama ea ai, eo lulu ea lui, ");
INSERT INTO swp_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","eo ea lageuio tamagu ena numa eai ma nuabigagu abo GUIAU ea abi egu Eaubada. ");
INSERT INTO swp_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Eo we’u ta ea hetoro doha du, abo Eaubada ena numa, eo ginauri gamagaridi u ledima abo lausoisoi hesaudoudoina enam abo ea leawa.” ");
INSERT INTO swp_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Iakobo ena lauwasi eai ie lau e ie lage tupo aruabu tataodi edi oea eai. ");
INSERT INTO swp_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","I itaitalau na goila huana oea esau eai ie ita, to nei mamoe eawoidi haiona gegesina eai se eno paana goila huana eai ne se henomdi. ");
INSERT INTO swp_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Mamoe eawoidi nei eai se henau gogoidi, abo tau itawataidi we’u se buihesuara, mamoe se henomdi, abo we’una se toreuioi huana awana eai. ");
INSERT INTO swp_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Iakobo i hesioedi, “Egu tataoyao e, omi haedi au laoma?” Ediba, “Ai Harana eai ai laoma.” ");
INSERT INTO swp_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","I hesioedi, “Labana abina aue ata, ia Nahora nutuna?” Si ene, “Ia abina aie ata.” ");
INSERT INTO swp_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","I ene, “Ia edohana, i lolo wa?” Si ene, “I lolo, na u ita nei, natuna Rahela i laolaoma, ena mamoe i woeawoeaidima.” ");
INSERT INTO swp_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","I ene, “Au ita, sora ina ta asusubenalai, na nige suisui edi huia woeagogoidima; besi mamoe au henomdi abo au woeauioidi au heaibaidi.” ");
INSERT INTO swp_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Na si ene, “Taba nige’e. Sora gamagaridi se woealageedima we’u se buihai huana awana eai, abotai abo ai henomdi.” ");
INSERT INTO swp_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ma’ediyao sora ma ribaribadi, na Rahela ie lage tamana ena mamoe ma’enayao, paana ia tautitawataidi ede. ");
INSERT INTO swp_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Iakobo Rahela ie ita, sinana louna Labana wa natuna siu, eo sinana louna Labana ena mamoe i itadi, Iakobo ie sae we’u huana guduna i buihai, eo sinana louna Labana ena mamoe eawoina adi goila i henomdi. ");
INSERT INTO swp_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Abo Iakobo Rahela i alagoiei, eo i dou ma arina lailaina. ");
INSERT INTO swp_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Iakobo Rahela i heriba i ene ia tamana ana boga tauna esau, eo ia Rebeka natuna, arinai siu wa ie tau ie lau tamana i heriba. ");
INSERT INTO swp_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labana Iakobo wasana i ataiei ia louna natuna wa, abo i aitautau bena i hailobai, i haitalagadoi, eo i alagoiei, eo i woeai ena numa eai. Ginauri gamagaridi ta Iakobo Labana i heriba. ");
INSERT INTO swp_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Labana abo i ribalau ia arinai i ene, “Mamohoi ariri, oa siadagu eo bulumagu!” Abo nawalai esega sorasorana arinai ie mia. ");
INSERT INTO swp_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Labana abo i ribalau Iakobo arinai i ene, “Paana oa agu boga tauna esau, arinai abo enagu u paisoa gaibu mo? U heribagu abo am maisa saha?” ");
INSERT INTO swp_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labana nanatunayao sisine labui, taubaguna esana Lea, taumurita esana Rahela. ");
INSERT INTO swp_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea matana se beruberu, na Rahela mo ana ao i lolo ariri, eo ma anabela. ");
INSERT INTO swp_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Iakobo Rahela i gadosisiei, to i ene, “Abo borimai haligigi‐labui enam ea paisoa natum taumurita Rahela maisana.” ");
INSERT INTO swp_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labana i ene, “I lolo mo ea leawa arim eai, nige tau esau arinai; arigu eai u mia.” ");
INSERT INTO swp_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Arinai Iakobo i paisoa borimai haligigi‐labui Rahela debana eai; na ia arinai amnana doha asubena hisahisawaidi mo paana siu wa i gadosisi aririei. ");
INSERT INTO swp_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Abo Iakobo i ribalau Labana arinai i ene, “Monegu ne u leama bena ea lau arinai paana egu huia ea he’ohidio.” ");
INSERT INTO swp_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Arinai eanua ne tataodi Labana i he’oigogoidi eo mataasi se ginauri. ");
INSERT INTO swp_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Na maimailahi eai natuna Lea ede i woeai Iakobo arinai to arinai ie lau. ");
INSERT INTO swp_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Labana ena heaheari sinena Silepa i mosei natuna Lea arinai bena i abi ana heaheari.) ");
INSERT INTO swp_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Mara ie tom abo Iakobo ie ita, omi hede Lea, to i ribalau Labana arinai i ene, “Saha ue abi arigu eai ta? Rahela debana eai enam ea paisoa, e nige’e? Paana saha u boraegu ina?” ");
INSERT INTO swp_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labana i ene, “Ai ema eanua laulauna eai taba nige ai abi doha nei, taba nige taumurita se mosei bagunai abotai taubaguna. ");
INSERT INTO swp_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Teina ta ena sabati sorasorana u he’ohi abo esau ea leawa, maisana borimai haligigi‐labui abo hinage enagu u paisoa.” ");
INSERT INTO swp_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Iakobo i awaabi, ena sabati sorasorana i he’ohi, abo Labana natuna Rahela i mosei ie abi monena. ");
INSERT INTO swp_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Abo Labana ena heaheari sinena Bilaha i mosei natuna Rahela arinai abo ena heaheari.) ");
INSERT INTO swp_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Iakobo hinage Rahela arinai ie lau, na Rahela mo i gadosisi aririei, abo Lea, eo Labana enana i paisoa uio borimai haligigi‐labui. ");
INSERT INTO swp_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","GUIAU i itayo’o, Lea se hewaiunuei, arinai abo i abiabi, na Rahela i agari. ");
INSERT INTO swp_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea ie boga eo natuna tau i labasi, eo esana ie tore Reubena, to i ene, “Paana GUIAU egu amamna i itayao, besi abo monegu i godosisiegu.” ");
INSERT INTO swp_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","I bogauio, natuna tau esau i labasi, i ene, “Paana GUIAU i ataieyao, se hewaiunuegu, arinai natugu tau esau hinage i leama,” To esana ie tore Simiona. ");
INSERT INTO swp_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Hinage i bogauio natuna tau esau i labasi, i ene, “Abotai monegu abo i patulaoma arigu eai, paana nanatunayao tatao haiona hede ea labasidio.” Arinai esana ie tore Levi. ");
INSERT INTO swp_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Abo i bogauio natuna tau i labasi, i ene, “Abotai abo GUIAU ea hedebasaei.” To esana ie tore Iuda. Abo i labalaba lautom. ");
INSERT INTO swp_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rahela ie ita ia nige merumeru i labasidi Iakobo arinai ena doga i aiaromagigiriei, i ribalau Iakobo arinai i ene: “Merumeru u ledima, e besi ea mate!” ");
INSERT INTO swp_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Iakobo i ouyalayala Rahela arinai to i ene, “Eau bena Eaubada ena aba‐toro eai ea totoro, ia ede bogam uauana i nuahi?” ");
INSERT INTO swp_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Abo Rahela i ene, “Te, egu heaheari sinena Bilaha wa, u lau arinai merumeru i labasidi eau nuanuagu eai, abo nanatuguyao ea abidi ia arinai.” ");
INSERT INTO swp_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Arinai ena heaheari sinena Bilaha i mosei ie abi monena, eo Iakobo ie lau arinai. ");
INSERT INTO swp_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Abo Bilaha ie boga, eo Iakobo arinai natuna tau i labasi. ");
INSERT INTO swp_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Abo Rahela i ene, “Eaubada i heduduraigu’o, arinagu hinage i ataieyao to natugu tau i leama.” Arinai esana ie tore Dani. ");
INSERT INTO swp_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rahela ena heaheari sinena Bilaha i bogauio, eo Iakobo natuna helabuina i labasi. ");
INSERT INTO swp_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rahela abo i ene, “Haiabi lailai arinai ea haiabi maegu doga, hinage ea saepoi ina.” Arinai esana ie tore Napatali. ");
INSERT INTO swp_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea i itayao i labalaba lautom arinai ena heaheari sinena Silepa i woeai i mosei Iakobo bena i abi monena. ");
INSERT INTO swp_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Abotai Silepa Lea ena heaheari sinena wa Iakobo natuna tau i labasi. ");
INSERT INTO swp_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea i ene, “I lolo ariri!” Arinai esana ie tore Gada. ");
INSERT INTO swp_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Lea ena heaheari sinena Silepa abo Iakobo natuna tau helabuina i labasi. ");
INSERT INTO swp_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Abo Lea i ene, “Egu kode ina! Paana sisine abo esagu se ribaei ‘Kode’.” Arinai esana ie tore Asa. ");
INSERT INTO swp_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Sitona masurina huiana eai Reubena ie lau to gadosisi uauadi headi i lobaidi oea eai i ledima sinana Lea arinai. Abo Rahela Lea arinai ie riba i ene, “Ea aibodaim taba natum ena gadosisi uauadi headi u ledima.” ");
INSERT INTO swp_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Na ia wa i heuio i ene, “U ene ginauri gagirina mo monegu arigu eai u woeahesuara, eo abo natugu ana uaua u abidi hinage?” Rahela i ene, “Besi maiona ta arim eai abo i eno, natum ana uaua maisadi.” ");
INSERT INTO swp_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Iakobo maimailahi eai oea eai i laoma Lea i pesa i hailobai, i ene, “Abo u laoma arigu eai paana ea sagenaim’o, natum ena gadosisi uauadi aridi eai maisana ea tore?” To maiona eai ne ia maena se eno. ");
INSERT INTO swp_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Eaubada Lea i ataiei, arinai ede ie boga to Iakobo natuna hehaligigina i labasi. ");
INSERT INTO swp_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lea i ene, “Eaubada egu maisa i leama’o, paana egu heaheari sinena ea mosei monegu arinai.” Abo esana ie tore Isakara. ");
INSERT INTO swp_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Abo Lea i bogauio to Iakobo natuna tau hehaligigi‐esegana i labasi. ");
INSERT INTO swp_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Abo Lea i ene, “Eaubada egu murihoi maisana arinai i ainauaigu, abotai monegu abo i heasisiegu, paana nanatunayao tatao haligigi‐esega enana ea labasidi.” To merumeru esana ie tore Sebulona. ");
INSERT INTO swp_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Murina eai natuna siu i labasi esana ie tore Daina. ");
INSERT INTO swp_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Abotai abo Eaubada Rahela i nuatui, eo i ataiei to i abiabi. ");
INSERT INTO swp_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ia hinage ie boga eo natuna tau i labasi, to i ene, “Eaubada egu taumaeamaea i abihai.” ");
INSERT INTO swp_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","To esana ie tore Iosepa, i ene, “Taba GUIAU natugu esau mo i leama!” ");
INSERT INTO swp_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rahela Iosepa i labasiyao, abo Iakobo i ribalau Labana arinai, enaba, “U hetamarigu, ea uio egu aba‐mia mamohoina eai, eo egu eanua tahunuana arinai. ");
INSERT INTO swp_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Moneguyao eo nanatuguyao, debadi eai ea heayaiyem ta u ledima, to u buigabaegu, paana egu heaheari paisoana enam abina u ata’o.” ");
INSERT INTO swp_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Na Labana i ribalau arinai, i ene, “Besi abo ea ribaei, heiheinoi headi aridi eai ea italabaiyao, hede oa debam eai GUIAU i ainauia aririegu. ");
INSERT INTO swp_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Em maisa saha u ribaei abo ea leawa.” ");
INSERT INTO swp_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Iakobo ena riba i heuio i ene, “Oabom abina u ata’o, egu abiheayayem ana ao, eo em bulumakau edi laulolo eau nimagu eai. ");
INSERT INTO swp_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Paana sora nige ea laoma wa, em gogo i gagiri ariri, na abotai i lai ariri: aitea tupo ea lau hede GUIAU i ainauiaim. Na auiana abo eaubom nanatuguyao enadi ea paisoa?” ");
INSERT INTO swp_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labana i ene, “Saha bena ea leawa?” Iakobo i ene, “Taba nige saha u leama: teina mo enagu u ginauri, eau abo mamoe eawoina ea itawataiuioi eo ea heaiuioi, ");
INSERT INTO swp_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Wauta bena em suisui eawoina wa ea taudadaidi, arinai mamoe wieadi uriuridi eo mamoe nanatudi dubadubadi ea woeahaidi, eo goti hinage uriuridi eo tupona se dubaduba ea abidi hinage, temeta mo abo egu maisa? ");
INSERT INTO swp_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Arinai egu abidudulai abo i masaraha, huiana ne u laoma egu maisa u nonoi. Goti boeadi eai aisegadi nige uriuridi, eo mamoe aisegadi nige dubadubadi ena arigu eai u lobaidi abo u ene ea aieaharidi.” ");
INSERT INTO swp_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labana i ene, “I lolo! Em riba ta lauwatai.” ");
INSERT INTO swp_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Na asubenana eai ne Labana goti tamoadi gamagaridi wieadi uriuridi, eo bawesinadi gamagaridi wieadi uriuridi, eo gamagaridi se posiposi eo se dubaduba, eo mamoe nanatudiyao dubadubadi, i abihaidi i toredi nanatunayao tatao nimadi eai bena se itawataidi. ");
INSERT INTO swp_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","To i woeahesuaradi edana lohana asubena haiona lauwasina ia eo Iakobo duaduaridi eai, na eawoina hagahagana wa Labana enana, isi Iakobo i heaidi. ");
INSERT INTO swp_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Abo Iakobo oeagi headi lagadi eo opidi tupodi i opahaidi bena posiposi i masaraha. ");
INSERT INTO swp_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Eo oeaoeagi tupodi se opadi wa i toredi mamoe edi aba henomdi eai, arinai eawoidi se laolaoma se nomnom. Se laoma se nom, to meta nanatudiyao edi huia hetubudi, ");
INSERT INTO swp_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","arinai oeaoeagi uriuridi wa matadi eai eawoidi nanatudiyao se hetubudi, to edi huia labalaba eai nanatudiyao se labasidi wa wieadi uriuridi mo, eo headi tupodi se dubaduba. ");
INSERT INTO swp_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Abo Iakobo mamoe nanatudiyao i torehesuaradi, uriuridi eawoidi i hesanalaedi dubadubadi gamagaridi Labana eawoina arinai: eo ia ena eawoi i torehesuaradi eo Labana ena mamoe eawoina aridi eai nige se heboridi. ");
INSERT INTO swp_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Eawoina eai wa mamoe e goti adiadidiridi edi huia bena nanatudiyao se hetubudi Iakobo wau oeaoeagi uriuridi i toredi matadi eai edi aba nomnom eai, bena metai oeaoeagi wa matadi eai nanatudiyao se hetubudi, ");
INSERT INTO swp_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Eawoina wa tauberuberudi oeaoeagi wa nige matadi eai i toredi arinai abo beruberudi nanatudiyao isi ede Labana enanayao, adiadidiridi mo isi wa Iakobo enanayao. ");
INSERT INTO swp_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Arinai tau ta i hemala taumonamonaune, ena mamoe eawoidi se gamagari, eo ena heaheari sisinedi eo ena heaheari tataodi, eo ena kamela eo ena asini. ");
INSERT INTO swp_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Iakobo riba i ataiei Labana nanatunayao si ene, “Tamamai ena gogo Iakobo i abihe’ohi, eo ena gogo lailaina ta ena abalaoma ede tamamai enana wa.” ");
INSERT INTO swp_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Iakobo abo ie ita Labana nige ana ao se lolo ia arinai doha bagubagunana eai wa. ");
INSERT INTO swp_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Abo GUIAU i ribalau Iakobo arinai i ene, “U uio tamamyao edi eanua eai, eau abo maem.” ");
INSERT INTO swp_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Arinai Iakobo Rahela eo Lea i eogaidi oea eai wa arinai ena mamoe eawoidi se miamia. ");
INSERT INTO swp_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","I ribalau aridi eai i ene, “Ea itayao tamamiu nige i nualoloegu doha bagubaguna eai wa. Taiede tamagu ena Eaubada ia tausaguigu. ");
INSERT INTO swp_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Au nuatuiyao tamamiu enana ea paisoa ma adidiridigu ie ohi, ");
INSERT INTO swp_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Iamo i boraigu ma saudoudoi egu maisa ie bui, na Eaubada i gudugudui to nige i hebaaeagu. ");
INSERT INTO swp_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ena i ene, ‘Em maisa ede mamoe tupodi se dubaduba, tupodi se posiposi,’ maesega gamagaridi se labalaba doha nei. Ena i ene, ‘Em maisa ede mamoe uriuridi’ abo eawoina maudoina nanatudiyao uriuridi se labasidi. ");
INSERT INTO swp_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Arinai Eaubada tamamiu ena bulumakau i abihaidi i ledima arigu eai. ");
INSERT INTO swp_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Edi huia hemohemone eai matagu ea helabaisinidi, eo enosuai eai goti tamoadi taukamposisae bawesinadi aridi eai ea itadi uriuridi aha’ahadi, eo tupodi se posiposi, eo headi uriuridi. ");
INSERT INTO swp_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Abo Eaubada ena aneru i ribalaoma arigu eai enosuai eai wa, i ene, ‘Iakobo’ to ea ne, ‘Eau ede ina.’ ");
INSERT INTO swp_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","To i ene, ‘Matam u helabaisini u ita goti tamoadi tau kamposisae eawoina dageladi eai isi ede uriuridi eo tupodi se dubaduba, tupodi se posiposi eo useuseadi paana Labana ena abi gamagamagari arim eai ea itadio. ");
INSERT INTO swp_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Eau Beteli Eaubadana, temeta we’u duna enagu u hetoro eo u he’eausi eo em aigora u aigoraei arigu eai. Aboina u torohai eanua ta u torohaigabaei, eo u uio aba‐labasim tanona eai.’” ");
INSERT INTO swp_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Abo Rahela eo Lea ena riba se heauoi si ene, “Tamamai ena numa eai, ema tupo e ema gogo saha? ");
INSERT INTO swp_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","I abimai doha laolaoma tataodi e nige’e? Paana i unegabaemai’o eo ema maisa monina i hepaisoa he’ohiyao. ");
INSERT INTO swp_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Gogo wa Eaubada tamamai arinai i abihai enamai ede, eo nanatumaiyao enadi; besi saha Eaubada i heitam abo u ginauri.” ");
INSERT INTO swp_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Arinai Iakobo i torohai, nanatunayao eo monenayao i hegerudi kamela potadi eai. ");
INSERT INTO swp_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Eo ena bulumakau eo ena suisui gamagaridi isi Padana‐arama eai i abidi wa, i woeahaidi bena se lau Kanana tehana eai tamana Isaako arinai. ");
INSERT INTO swp_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Labana wa i lao’o ena mamoe wieadi bena i aitom, na Rahela tamana ena numa oitaudi i aiyaharidi. ");
INSERT INTO swp_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Na Iakobo Labana, Arama tauna, i borai paana nige i heriba ena nuatu bena i dago. ");
INSERT INTO swp_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Na ie dago mo maena gogo maudoina. I torohai Euparate sagana i awasi, eo i lau dudurai Gileada hesabana, oea tupidi tehadi eai. ");
INSERT INTO swp_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Asubena hehaionana eai Labana se heriba si ene, “Iakobo i dago’o.” ");
INSERT INTO swp_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Arinai ana bogao tataodi i woeaidi se heula ia se hemuriwatai asubena haligigi‐labui boeadi eai, i lau e se lagelobai Gileada oea tupina eai. ");
INSERT INTO swp_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Abo Eaubada i taumasaraha Labana arinai, Arama tauna wa, maiona eai enosuai eai, i ribalau ia arinai i ene, “Em riba Iakobo arinai bena u komakomani, tabu u ribahelolo, eo tabu u ribahebaaea.” ");
INSERT INTO swp_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Abo Labana Iakobo i lagetawai. Iakobo ena numa‐lulu i hetoro oea tupina eai: Labana hinage ma ehanayao Gileada oeana eai se mia. ");
INSERT INTO swp_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Labana hinage i ribalau Iakobo arinai i ene, “Em nuatu saha to u torohai eamueamui doha meta, eo nanatuguyao sisine u laehesuaradi, eo u girihaidi doha tatao auaudi iala eai? ");
INSERT INTO swp_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Paana saha u dago eamueamui, u dagogabaegu, nige u heribagu bena abo ma kodegu eo ma nualologu ea hetamarimiu, wana eo boiatu eo huele aridi eai? ");
INSERT INTO swp_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Egu huia nige u leama bena abo tubuguyao tatao eo sisine ea alagoiedi eo ea lauaioniedi? Laulau eaueaure u ginauri! ");
INSERT INTO swp_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Nimagu ena gigibori gonoana taba ea hebaaeamiu; na boni tamam ena Eaubada i ribalaoma i ene, ‘U komakomani, tabu Iakobo u ribahelolo, eo tabu hinage u ribahebaaea.’ ");
INSERT INTO swp_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Mamohoi em gadosisi bena u torohai paana tamam ena numa u nuatu aririei, na paana saha egu oitau u aiyaharidi?” ");
INSERT INTO swp_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Abo Iakobo Labana i heuioi i ene, “Mata paana ede ea matausi, ea ene ata nanatumyao sisine u girihaidi nimagu eai. ");
INSERT INTO swp_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Eai nimana eai em oitau wa u lobaidi tabu i mauri. I lolo ehadayao matadi eai em ginauri u eo’oidi arigu eai eo u abiuioidi.” Paana Iakobo nige abina i ata Rahela oitau wa i aiyaharidio. ");
INSERT INTO swp_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Arinai Labana i lulau Iakobo ena numa‐lulu eai eo Lea enana hinage arinai, eo ena heaheari sisinedi edi numa‐lulu aridi eai i lulau. Na ginauri wa nige i lobaidi. Abo Lea ena numa‐lulu i pesagabaei, Rahela enana arinai i awasae. ");
INSERT INTO swp_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rahela oitau i abidi wa, na ababawa se tore kamela dagelana eai, boeana eai i toreamuidi, abo potadi eai ie bawa. Labana numa‐lulu alona eai i eo’o komakomani, na oitau wa nige i lobaidi. ");
INSERT INTO swp_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Abo Rahela i ribalau tamana arinai i ene, “Egu guiau tabu nuam i baaea, paana matam eai nige ea toro, na sisine adi iwala ea hearo.” To i eo’o asa eai, oitau wa nige i lobaidi. ");
INSERT INTO swp_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Iakobo i ouyalayala to Labana i dilai, eo i ribalau Labana arinai i ene, “Egu ponori saha, eo egu baaea aisana to ma ouyalayalam bena u toaigu ta? ");
INSERT INTO swp_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Egu gogo boeadi eai u eo’oeo’o na em numa ginauridi saha eo saha u lobaidi? Ginauri wa u torehemasarahadi ehaguyao, eo ehamyao matadi eai, abo se heduduraida. ");
INSERT INTO swp_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Borimai tau‐esega‐i‐mate boeadi eai ta miaesega, em mamoe bawesinadi eo em goti bawesinadi nanatudiyao nige se gabaedi, to em mamoe tamoadi nige ea aidi. ");
INSERT INTO swp_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Saha eo saha suisui manamanabaladi se unuidi nige ea lediwa arim eai, na eaubom ea hedudulaidi. Ena saha se aiyahari asubena eai e maiona eai u lauhesomgu bena ea hemaisa. ");
INSERT INTO swp_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Egu miamia ana ao doha ina, asubena eai gadomagu i hebaaeagu, eo maiona eai gogoma i abigu, nige begana ea eno. ");
INSERT INTO swp_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Borimai tau‐esega‐i‐mate em numa eai ea miamia, eo borimai saudoudoi‐hasi enam ea paipaisoa nanatumyao sisine debadi eai, abo hinage borimai haligigi‐esega em bulumakau debadi eai, eo masaudoudoi egu maisa u buidi. ");
INSERT INTO swp_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ena tamagu ena Eaubada, eo Aberahama ena Eaubada, eo Isaako ena Aba‐matausi Eaubadana nige maegu, abo wauta ma nimaahagu u hetamarigu. Na Eaubada egu amamna eo egu nima paisoa i itadio to boni i ribasuuim.” ");
INSERT INTO swp_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labana i heuio Iakobo arinai i ene, “Ina sisine ta eau nanatuguyao, eo ina merumeru ta eau tubuguyao, ina suisui eau egu suisui, eo ginauri gamagamagaridi matada eai meta eau enagu. Na saha abo wauta ea ginauri nanatuguyao sisine enadi, eo merumeru wa se labasidi enadi? ");
INSERT INTO swp_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Hage eda riba aigora ta abi oa eo eau abo i hemala eda aba‐italau oa eo eau duaduarida eai.” ");
INSERT INTO swp_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Arinai Iakobo we’u lailaina ie abi i hetoro, i hemala du. ");
INSERT INTO swp_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Eo Iakobo i ribalau ena dodogayao aridi eai i ene, “We’u au tanogogoidi.” To we’u se peidi, abo we’u peina potana eai se aiaigogo. ");
INSERT INTO swp_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Abo Labana esana ie tore Iega‐sahaduta na Iakobo esana ie tore Galeda. ");
INSERT INTO swp_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labana i ene, “Ina pei ta abo eda heiheinoi oa eo eau duaduarida eai wauta.” Arinai esana ie tore Galeda. ");
INSERT INTO swp_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Esana esau hinage Misepa, paana i ene, “GUIAU abo i itawataida eda aba‐mia udoi udoi aridi eai. ");
INSERT INTO swp_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ena nanatuguyao sisine u heamamnadi e ena monemyao headi u abidi, taba nige esau i ita, na Eaubada iabom tau‐itada ede.” ");
INSERT INTO swp_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Abo Labana ie ribalau Iakobo arinai i ene, “Ina we’u peina ta u ita, eo ina du ea hetoro ta oa eo eau duaduarida eai. ");
INSERT INTO swp_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ina pei ta abo eda heiheinoi, eo ina du ta hinage taba nige we’u peina eo ina du ta u dioidi bena u hebaaeagu. ");
INSERT INTO swp_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Aberahama ena Eaubada, eo Nahora ena Eaubada, eo tamadiyao edi Eaubada abo i heduduraida.” Abo Iakobo i riba aigora tamana Isaako ena Aba‐matausi Eaubadana debana eai. ");
INSERT INTO swp_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Abo Iakobo aitalasam ie gabu oea tupina eai eo ehanayao i eogaidi bena se aiai, arinai se aiaigogo, eo maiona maudoina se mia oea tupina eai. ");
INSERT INTO swp_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Abotai maratomtom begana Labana i toro, tubunayao eo nanatunayao sisine i alagoiedi eo i ribahelolodi, abo i torohaigabaedi, ie uio ena eanua eai. ");
INSERT INTO swp_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Iakobo i torohaiuio ena dobila i lauwatai, to Eaubada ena aneru ia se hailobai. ");
INSERT INTO swp_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ena huia itadi Iakobo i ene, “Ina Eaubada ena tauiala ede,” to eanua wa esana ie tore Mahanaima. ");
INSERT INTO swp_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Abo Iakobo ena heaheari tataodi i hetamaribagunaidi ena tau Isoa arinai, Seria eanuana eai, ia ede Edoma tanona eai. ");
INSERT INTO swp_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Doha ina i lauhesomdi i ene, “Ina doha abo au ribalau agu tanuaga Isoa arinai, ‘Em heaheari tauna Iakobo ena riba ede ina. Huia ku’uku’una ea miamia Labana arinai, abo nei eai ea miamia i laoma e wauta. ");
INSERT INTO swp_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Eau nimagu eai bulumakau, asini, mamoe eawoidi, heaheari tataodi eo sisinedi hinage: arinai riba ta ea hetamariawa egu guiau arim eai, bena nualolo ea lobai oa arim eai.’” ");
INSERT INTO swp_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Tatao i hetamaridi wa, se uioma Iakobo arinai si ene, “Aie lage em tau Isoa arinai, eo ia hinage i laolaoma bena i hailobaim, ana bodao tataodi handere hasi maenayao.” ");
INSERT INTO swp_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Iakobo i matausi ariri, eo i nuadubu, arinai mamoe eawoidi, eo bulumakau, eo kamela i peilabuiedi. ");
INSERT INTO swp_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","I ene, “Ena Isoa i laoma pele esega i lobai eo i hebaaea, pele esau wa abo i dago.” ");
INSERT INTO swp_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Abo Iakobo i ene, “Oa tamagu Aberahama ena Eaubada, eo tamagu Isaako ena Eaubada, egu GUIAU, oa u heribagu u ene, ‘U uio em eanua tahunuana, eo em tataoyao aridi eai abo hinage ea saguim’, ");
INSERT INTO swp_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","eau nige ea lolo abo em ainauia gagiliaririna arinai u ainauiaigu, em gadosisi otaotahaina eo em abi lolo u heita em heaheari tauna arinai; paana nabada egu tu’e mo nimagu eai na ina Ioridana sagana ta ea awasi, na ina huia ta ea laoma pele labui lailaidi nimagu eai. ");
INSERT INTO swp_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ea awanorilaowa bena egu tau nimana eai u abihemaurigu, ia ede Isoa nimana eai, paana ea matausi ata i laoma i hebaaeagogoimai, nanatuguyao ma sinadiyao. ");
INSERT INTO swp_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Abo hinage oa u ribaei u ene, ‘Mamohoi abo ea ainauiaim, eo am isimurita abo ea hegamagariaririedi doha gabogabo hasarina gelegelena wa nige tau esau abina i ata i hasiri.’” ");
INSERT INTO swp_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Meta maionana eai ne ie bawa nei eai: abo ginauri saha eo saha nimana eai i lobai tupona ie abi bena Isoa ena tau i ainauiai. ");
INSERT INTO swp_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Goti bawesinadi handere labui, goti tamoadi tau‐esega‐i‐mate, mamoe bawesinadi handere labui eo mamoe tamoadi tau‐esega‐i‐mate. ");
INSERT INTO swp_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Kamela bawesinadi ma nanatudiyao tau‐esega‐i‐mate‐saudoudoi, bulumakau bawesinadi tatao‐labui‐si‐mate, bulumakau tamoadi saudoudoi, asini bawesinadi tau‐esega‐i‐mate ma nanatudiyao saudoudoi. ");
INSERT INTO swp_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Abo i toredi ena heaheari tataodi nimadi eai, pele esau eo pele esau, eo i ribalau aridi eai i ene, “Au edabagunaegu, eo pele esau pele esau bena duaduaridi eai sorasoradi.” ");
INSERT INTO swp_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Abo bagubagunadi i lauhesomdi i ene, “Ena egu tau Isoa au hailobai, eo i hesiolaowa i ene, ‘Omi ede eai enanayao, eo haedi au laulau, eo ina suisui ta au woeadi meta eai enanayao?’ ");
INSERT INTO swp_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Abo au heuioi au ene, ‘Ina suisui ta em heaheari tauna Iakobo enanayao, eo isi ede ena ainauia ena guiau Isoa arim eai. Hinage u ita ia murimai eai i laolaoma.’” ");
INSERT INTO swp_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Pei helabuina tauwoeaina hinage doha i lauhesom, hehaionana hinage, abo tatao gamagaridi isi suisui eawoidi se lauwataidi i heribadi i ene, “Ena Isoa au lobai ina doha abo au ribalau arinai, ");
INSERT INTO swp_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","hinage abo au heriba, ‘U ita em heaheari tauna Iakobo murimai eai i laolaoma.’” Paana i ene, “Ainauia i bagunaegu abo arinai nuana ea helolo, murina eai abo matana ea ita, nuana doha meta ea ginauri abo nuana ea hebiga.” ");
INSERT INTO swp_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Arinai ainauia wa i baguna, na maiona ne ie bawa tatao gamagaridi boeadi eai. ");
INSERT INTO swp_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Abo maionana eai ie toro, monenayao labui, ena heaheari sisinedi labui, eo nanatunayao saudoudoi‐esega i woeaidi to Iakobo sagana se awasi. ");
INSERT INTO swp_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","I abidi i hetamaridi goila hari sanaawasi eai, eo ena ginauri gamagaridi hinage. ");
INSERT INTO swp_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Arinai Iakobo iabom ie bawa, eo tau esau maena se haipoipoi i lau e mara i uiari. ");
INSERT INTO swp_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Abo tau esau wa ie ita taba nige Iakobo i saetawatawai, arinai gotuna i abi’ita; to edi haiabi boeana Iakobo danana i tarumo. ");
INSERT INTO swp_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Abo i ene, “U abigabaegu paana mara i uiari.” Na Iakobo i ene, “Taba nige ea abigabaem i lau e em ribahelolo u leama enagu.” ");
INSERT INTO swp_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Abotai i hesioei i ene, “Esam ede eai?” I heuio i ene, “Iakobo.” ");
INSERT INTO swp_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Abo i ene, “Esam Iakobo abo se torebui Isaraela, paana oa doha wasawasa esau em gigibori ie lai Eaubada arinai, eo tatao aridi eai, eo hinage u saepoi.” ");
INSERT INTO swp_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Iakobo i hesiolau arinai i ene, “Ea aibodaim bena esam u heribagu.” Na i ene, “Paana saha esagu bena abina u ata?” Abo nei eai tau wa Iakobo i ribahelolo. ");
INSERT INTO swp_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Iakobo eanua wa esana ie tore Penuela paana i ene, “Inai Eaubada ea itayao, eo ai hai’itaita, na sora ma miagu.” ");
INSERT INTO swp_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Abotai Penuela i torohaigabaei mahana i daladalasae ie sina potana eai, na i laulaudae. ");
INSERT INTO swp_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ginauri ta debana eai Isaraela tataodi suisui gotudi bulumadi taba nige se aidi i laoma e wauta, paana Iakobo gotuna tau wa i abi’ita to danana i tarumo. ");
INSERT INTO swp_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Abotai Iakobo matana i helabaisinidi Isoa ie ita i laolaoma maenayao tatao handere hasi. Arinai merumeru i soiedi Lea enanayao, eo Rahela enanayao, eo edi heaheari sisinedi labui enadiyao. ");
INSERT INTO swp_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Heaheari sisinedi ma nanatudiyao i torebagunaidi, muridi eai Lea ma nanatunayao, abo Rahela eo Iosepa i toremuritaidi. ");
INSERT INTO swp_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Iakobo ia i edabagunaedi, ma haligigi‐labui i tabaohu tano eai i lau e i hanahanau ena tau arinai. ");
INSERT INTO swp_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Na Isoa i aitautau ia i hailobai i heaitalagadoi, i alagoiei, abo se haidoudou. ");
INSERT INTO swp_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","To Isoa matana i helabaisinidi sisine ma nanatudiyao i itadi abo i ene, “Ina aidimodi maemyao?” Iakobo i heuio, “Isi ede nanatuguyao Eaubada ena ainauia em heaheari tauna arinai.” ");
INSERT INTO swp_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Heaheari sisinedi hinage se hanahanau ma nanatudiyao se tabaohu. ");
INSERT INTO swp_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lea hinage ma nanatunayao se hanahanau se tabaohu, murina eai Iosepa i laoma gegesina eai, eo Rahela, eo se tabaohu hinage. ");
INSERT INTO swp_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Abo Isoa i hesio i ene, “Dodoga pelena lailaina wau ea hailobai aniona saha?” Iakobo i heuio i ene, “Bena abo arinai em nualolo ea hearo.” ");
INSERT INTO swp_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Na Isoa i ene, “Egu tau e, egu gogo gonogonoagu, saha eo saha oa nimam eai meta me u abididinidi.” ");
INSERT INTO swp_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","To Iakobo i ene, “Taba nige’e, ea awanorilaowa, taba nuam i lolo arigu eai, ina egu ainauia ta u abi, paana mamohoi ariri am ao ea ita ia ede doha Eaubada ana ao, eo hinage ma nualolom u hailobaigu ta. ");
INSERT INTO swp_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ea aibodaim bena ina egu ainauia ta u abi enam, paana Eaubada i ainauia aririegu, to egu gogo gonogonoagu.” I samasamadudui, abo Isoa ie abi. ");
INSERT INTO swp_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Abo i ene, “Hage ta torohai, na eau abo ea eda bagunaem.” ");
INSERT INTO swp_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Na Iakobo i ene, “Egu guiau e, abina u ata merumeru se lau beruberu, eo hinage egu mamoe, eo egu bulumakau ma nanatudiyao maeguyao, na ena huia esau se lauhesomdi bena se lau heula abo se mateohi. ");
INSERT INTO swp_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Egu guiau, ea aibodaim bena em heaheari tauna u bagunaei, abo eau ea lau benaibenai, suisui eo merumeru edi lau eai abo ea lau, i lau e ea lage Seira eai, oa egu guiau arim eai.” ");
INSERT INTO swp_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Isoa i ene, “Hage tatao hisahisawaidi nimagu eai abo ea laugabaedi arim eai.” Na Iakobo i ene, “Abo adi paisoa saha? Egu guiau e, bena nuam i lolo arigu eai.” ");
INSERT INTO swp_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Arinai nei asubenana ne Isoa ie uio Seira dobilana eai. ");
INSERT INTO swp_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Na Iakobo ie lau Sukota eai, nei eai ena numa i hetoro, eo ena suisui edi apa i ginauridi, abo eanua esana se tore Sukota. ");
INSERT INTO swp_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Iakobo Padana‐arama eai i laoma ie lage Seilem, Sekema ena eanua esau Kanana tanona eai, abo eanua matana eai ena apa lulu i hetoro. ");
INSERT INTO swp_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Oea wa, ena apa lulu aba‐hetorona i unehai Hamore nanatunayao aridi eai, ia Sekema tamana, maisana moni silver handere esega. ");
INSERT INTO swp_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Abo nei eai aitalasam hatahatana i hetoro, esana ie tore El‐Elohe‐Isaraela. ");
INSERT INTO swp_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Huia esau Daina, Lea natuna sine, Iakobo arinai ie abi wa, iabom ie pesa ie lau eanua hasahasaradi bena i itadi. ");
INSERT INTO swp_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Abo Sekema, ia Hiwi tauna, Hamore natuna, nei eanua ne wasawasa, ia Daina ie ita, to i abilau arinai, maena se enobili, to i hebaaea. ");
INSERT INTO swp_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Na ia nuana maudoina ie lau Daina arinai, Iakobo natuna sine, eo hasara wa i gadosisiei eo ena riba se biga arinai. ");
INSERT INTO swp_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Abo Sekema i ribalau tamana Hamore arinai i ene, “Ina hasara ta u abi monegu.” ");
INSERT INTO swp_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Iakobo abo i ataiei tau wa natuna Daina i hebaaea; ia nanatunayao tatao oea eai ena suisui se suidi, to ia awana ie gudu i lau e se uioma. ");
INSERT INTO swp_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Abo Hamore, Sekema tamana, ie lau Iakobo arinai bena se ribariba. ");
INSERT INTO swp_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Na Iakobo nanatunayao tatao oea eai wasa se ataiei to se laoma, nuadi se amamna, eo edi ouyalayala i lai ariri paana tau wa ginauri baaea mamohoina i ginauri Isaraela boeana eai, Iakobo natuna sine maena se enobili. Paana laulau doha nei tabu si ginauri. ");
INSERT INTO swp_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamore maenayao se oiriba, i ene, “Natugu tau, Sekema, natum sine gadohina i gadohie; ea aibodaim bena u mosei ia arinai bena abo monena. ");
INSERT INTO swp_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Abo ta haitawasora; omi nanatumiuyao sisine au ledima arimai eai, eo ai hinage abo nanatumaiyao sisine ai lediwa arimiu eai. ");
INSERT INTO swp_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Abo ta miagogo, oea lailaina matamiu eai; abo au miahai arinai, au paipaisoa, eo au uneune, eo arinai emi gogo au abidi.” ");
INSERT INTO swp_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sekema i ribalau Daina tamana eo loulounayao aridi eai ie ene, “Ea aibodaimiu bena nuamiu se lolo arigu eai, eo saha eo saha au ribaei abo ea leawa. ");
INSERT INTO swp_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Hasara wa maisana ena au henua au helai aririei, taiede abo ea leawa: ia mo hasara wa bena au leama ea tawasorai.” ");
INSERT INTO swp_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Na Iakobo nanatunayao tatao Sekema ma tamana Hamore se boraidi, mata paana Sekema wa loudi i hebaaea debana eai. ");
INSERT INTO swp_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Si ene, “Taba nige em nuatu ai lauwatai, paana nige abina ai ata loumai ai mosei tau esau nige se heperitome arinai, ata ginauri wa i hemala ema taumaeamaea. ");
INSERT INTO swp_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Na taba au abi doha ina abo ai eari, taba omi au hemala doha ai, eo tatao gamagarimiu se heperitomemiu. ");
INSERT INTO swp_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Taba laulau ta au abi, i lolo abo nanatumaiyao sisine ai lediwa, eo hinage nanatumiuyao sisine abo ai abidi, eo abo ai mia boeamiu eai, ta hemala boga esega. ");
INSERT INTO swp_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Na ena nige au henua ema riba ta au ataiei eo nige au eari heperitome arinai, loumai abo ai abi, ai lau.” ");
INSERT INTO swp_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Edi riba wa Hamore, ma natuna Sekema, i henualolodi. ");
INSERT INTO swp_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Abo hewari wa nige i bebeda edi riba i awaabiei, paana Iakobo natuna sine i gadosisiaririei. Ia tamana ena numa eai i sae ariri. ");
INSERT INTO swp_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamore eo natuna tau Sekema se lage edi eanua dobila lailaina wa arinai nei eai nuatu wa se hetoro eanua tataodi matadi eai, si ene, ");
INSERT INTO swp_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Ina tatao ta se nuabiga arida eai, arinai hage se mia eda eanua eai eo edi uneune paisoana se laelaei; paana eda eanua susuana gonoana enadi; abo edi hasara ta abidi ta tawasoraidi, ita hinage ede hasahasara abo ta mosedi aridi eai. ");
INSERT INTO swp_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ginauri esega mo se hetoro, na abo se eari bena abo se mia boeada eai, iaede bena ita gamagarida tatao abo se heperitomeda doha hinage isi. ");
INSERT INTO swp_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Abo edi bulumakau, edi gogo eo edi suisui gamagaridi abo se hemala enada — e nige’e? Na i lolo ginauri ta arinai ta eari abo se miahai boeada eai.” ");
INSERT INTO swp_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Tatao gamagaridi edi eanua se pesagabaei, Hamore eo Sekema edi riba se ataiewataidi, abo tatao gamagaridi nei eanua eai ne taumia se heperitomedi. ");
INSERT INTO swp_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Abo asubenana hehaionana eai, huiana wa tatao gamagaridi amnadi se baaea, Iakobo nanatunayao Simiona eo Levi, Daina loulounayao, edi elepa se abidi, ma nuakipikipidi se awasae eanua wa alona eai, tatao gamagaridi se unuidi. ");
INSERT INTO swp_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hamore hinage, ma natuna tau Sekema, se lau elepaidi, se unuidi, eo Daina, Sekema ena numa alona eai, se girihai to se pesa. ");
INSERT INTO swp_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Abotai Iakobo nanatunayao tatao se lusora tatao matematedi boeadi eai, eanua ena gogo se bahei, paana loudi wa se hebaaea. ");
INSERT INTO swp_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Edi mamoe eawoidi, edi bulumakau, edi asini, eo saha saha se itadi eanua eai wa, eo saha eo saha se itadi eanua murimurina eai. ");
INSERT INTO swp_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Edi gogo maudoina, eo nanatudiyao gagiridi, eo monediyao se girihaidi se laedi, eo ginauri maudoidi se lobaidi numa alodi eai se baheidi. ");
INSERT INTO swp_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Abo Iakobo i ribalau Simiona eo Levi aridi eai, i ene, “Paana saha doha ina au hebaaeagu, esagu hinage au hebaaea aririei eanua tataodi Perisi eo Kanana tataodi matadi eai? Eau nige ea gamagari, arinai isi abo se heoiesega, abo se laoma se ialaigu, abo se unuhemategu, agu bogaoyao maeguyao.” ");
INSERT INTO swp_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Na isi se ribaei si ene, “Mamohoi i lolo loumai i hebaaea gonogonoana doha ia sine baaea, e nige’e?” ");
INSERT INTO swp_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Abotai Eaubada i ribalau Iakobo arinai i ene, “U torohai u sae Beteli, abo nei eai u mia, abo Eaubada ena aitalasam hatahatana u ginauri, Eaubada ia wa i taumasaraha arim eai huiana eai wa em tau Isoa u dagogabaei.” ");
INSERT INTO swp_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Abotai Iakobo, ena numa taumiaidi eo isi gamagaridi maenayao se mia esega, i ribalau aridi eai i ene, “Oitau gamagaridi boeamiu eai se ota au torehesuaradi, eo au heaauioimiu, eo ami lulu aadi au luidi, ");
INSERT INTO swp_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","abo hage ta torohai ta sae Beteli eai, abo nei eai Eaubada ena aitalasam hatahatana ea ginauri, ia, huiana wa ea nuadubu ariri egu uura i ataiei, eo hinage egu abalau gamagaridi aridi eai ia maegu.” ");
INSERT INTO swp_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Arinai isi gamagaridi edi oitau udoi udoi, eo omo’omodi beadi eai se toredi, se toredi Iakobo nimana eai, abo Iakobo i wuidi oeagi lailaina esau paana eai, Sekema gegesina eai. ");
INSERT INTO swp_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Arinai edi lauwasi se lauei se lau, abo Eaubada matausina i tarudobi eanua se hetaiiri wa potadi eai, arinai Iakobo nanatunayao nige se henaudi. ");
INSERT INTO swp_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Abo Iakobo ie lage Lusa eai, ia ede Beteli, Kanana tanona eai wa ia eo ana bodao gamagaridi maenayao. ");
INSERT INTO swp_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Abo nei eai aitalasam hatahatana i hetoro, abo eanua esana ie tore El‐beteli, paana nei eai Eaubada i taumasaraha arinai huiana wa ena tau i dagogabaei. ");
INSERT INTO swp_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Na Debora, Rebeka tauabihelaina, ie mate, to se tore Beteli eai, oeagi lailai paana eai. Abo oea wa esana se tore Alona‐bakuta. ");
INSERT INTO swp_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Hinage Eaubada i taumasarahauio Iakobo arinai, huiana wa Padana‐arama i laugabaei abo nei eai i ribahelolo. ");
INSERT INTO swp_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Eaubada i heriba i ene, “Esam Iakobo. Esam me Iakobo i otawa, na esam abo Isaraela.” Arinai esana i atai Isaraela. ");
INSERT INTO swp_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Abo Eaubada i ribalau arinai i ene, “Eau Eaubada Gigibori‐aririna. Am isimurita abo se gamagari ariri. Basileia eo hinage basileia gamagaridi oa arim eai abo se laoma, eo oa tumam eai abo wasawasa se labasidi. ");
INSERT INTO swp_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Oea wa ea moseyao Aberahama eo Isaako aridi eai abo hinage oa enam, eo am isimurita hinage enadi.” ");
INSERT INTO swp_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Abo Eaubada edi aba‐ribariba wa i torohaigabaei. ");
INSERT INTO swp_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Arinai Iakobo du lailaina i hetoro edi aba‐ribariba oeana eai wa, ie ede we’u duna. Abo aitalasam nom‐nomna i hegoilaei potana eai, eo eausi hinage i hegoi. ");
INSERT INTO swp_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Eo Iakobo Eaubada maena edi aba‐ribariba dimona wa esana ie tore Beteli. ");
INSERT INTO swp_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Beteli se torohaigabaei nige baeaona abo se lage Eparata eai, na Rahela dagelana i amamna ariri to ana paisoa i pilipili ariri. ");
INSERT INTO swp_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Na paisoa pilipilina boeana eai, sine esau, ia tau abihelabalabana, i ribalau arinai i ene, “Tabu u matausi, ina natum tau abo hinage u labasi.” ");
INSERT INTO swp_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Na earuana bena i torohai, paana abo i odalele, kaimou esana ie tore Benoni, na tamana esana ie tore Beniamina. ");
INSERT INTO swp_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rahela i lautom to Eparata dobilana gegesina eai se tore, iaede Betelehema. ");
INSERT INTO swp_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Abo Iakobo du i hetoro bousana eai, Rahela ena bousa duna nei eai ie ota i laoma e ina asubena ta. ");
INSERT INTO swp_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Eo Isaraela i lauwasi ie lau, abo ena numa‐lulu i hetoro Edara numa lailaina wa dagelana eai. ");
INSERT INTO swp_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Abo Isaraela nei tupo eai ne ie mia, na huia esau Reubena i laoma Bilaha arinai, tamana monena esau wa, maena se enobili, abo Isaraela wasana i ataiei. Iakobo nanatunayao tatao saudoudoi‐labui. ");
INSERT INTO swp_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea nanatunayao tatao ede ina: Reubena, (Iakobo ena ealahou tau) Simiona, Levi, Iuda, Isakara, eo Sebulona. ");
INSERT INTO swp_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rahela nanatunayao tatao: Iosepa eo Beniamina. ");
INSERT INTO swp_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Bilaha, Rahela ena heaheari sinena, nanatunayao tatao: Dani, Napatali. ");
INSERT INTO swp_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Eo Silepa, Lea ena heaheari sinena, nanatunayao tatao: Gada eo Asa. Ina Iakobo nanatunayao tatao Padana‐arama eai se labasidi. ");
INSERT INTO swp_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Abotai Iakobo ie lage tamana Isaako arinai Mamare eai, Araba eanuana eai ia ede Heberona, Aberahama eo Isaako edi aba miamia. ");
INSERT INTO swp_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaako ena borimai handere esega eo tatao‐hasi‐se‐mate. ");
INSERT INTO swp_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Abo Isaako i tubahai to ie mate, na se tore ana bogaoyao boeadi eai. Ia i tautaubadao ao ena borimai se gamagariri ariri, to nanatunayao Isoa eo Iakobo se tore. ");
INSERT INTO swp_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Isoa ana isimurita ede ina, Isoa esana ede Edoma. ");
INSERT INTO swp_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Isoa monenayao Kanana hasahasaradi i abidi: Ada, Elona, Hito tauna natuna, eo Oholibama, Anaha natuna Sibiona, Hiwi tauna natuna. ");
INSERT INTO swp_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Eo Basemata, Isamaela natuna sine, Nebaiota louna. ");
INSERT INTO swp_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada Elipasi i labasi Isoa arinai, eo Basemata Reuela i labasi. ");
INSERT INTO swp_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama Ieusa eo Iaalama eo Kora i labasidi: isi ede Isoa nanatunayao tatao ia arinai se labasidi Kanana tanona eai. ");
INSERT INTO swp_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Abo Isoa monenayao ma nanatunayao tatao eo sisine eo ena numa tataodi gamagamagaridi ena bulumakau eo ena suisui gamagaridi, eo ena gogo gamagaridi i abidi Kanana eai, i laedi eanua esau eai bena ena tau Iakobo matana eai i lausuaraei. ");
INSERT INTO swp_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Paana edi gogo se lai ariri nige gonoana se mia esega, hinage tano wa arinai isi tau laolaoma wa nige gonoadi paana edi suisui se gamagari ariri. ");
INSERT INTO swp_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Arinai Isoa Seira oea tupidi eai ie mia, Isoa esana esau Edoma. ");
INSERT INTO swp_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Isoa, Edoma tataodi tamadi, Seira oeana eai ie mia, ana isimurita ede ina. ");
INSERT INTO swp_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Isoa nanatunayao tatao esadi ede ina, Elipasi, Ada, Isoa monena natuna tau; Reuela, Basemata, Isoa monena, natuna tau. ");
INSERT INTO swp_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elipasi nanatunayao tatao Temani, Omara, Sepo, Gatami eo Kenasi. ");
INSERT INTO swp_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Abo Isoa natuna Elipasi monena esau Timina, Amaleka i labasi. Isi ede Ada, Isoa monena, nanatunayao tatao ");
INSERT INTO swp_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reuela nanatunayao tatao ede ina: Nahata, Seraha, Sama eo Misa; isi ede Basemata Isoa monena nanatunayao tatao. ");
INSERT INTO swp_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Isoa monena Oholibama, ia Anaha natuna, Anaha wa Sibiona natuna Isoa arinai Ieusa, Iaalama eo Kora i labasidi. ");
INSERT INTO swp_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Isi ede Isoa nanatunayao edi babada; Elipasi, Isoa ena ealahou tau nanatunayao tatao ena babadayao Temani, Omara, Sepo, Kenasi, ");
INSERT INTO swp_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatami, eo Amaleka. Isi Elipasi ena babadayao Edoma tanona eai. Isi Ada nanatunayao tatao. ");
INSERT INTO swp_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Isoa natuna tau Reuela nanatunayao tatao ede ina: bada Nahata, bada Seraha, bada Sama, bada Misa. Isi babada ede Reuela arinai se laoma, Edoma tanona eai, Basemata Isoa monena nanatunayao tatao. ");
INSERT INTO swp_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Isoa monena Oholibama nanatunayao tatao ede ina: bada Ieusa, bada Ialaama, bada Kora, ina babada to Oholibama Isoa monena arinai se laoma, ia wa Anaha natuna sine. ");
INSERT INTO swp_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Isi ede Isoa, ie ede Edoma, nanatunayao tatao eo edi babadayao. ");
INSERT INTO swp_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Seira, Hori tauna, nanatunayao tatao, isi eanua wa taumiaidi, Lotana, Sobale, Sibiona eo Anaha. ");
INSERT INTO swp_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disoni, Esera, eo Disani, isi Hori tataodi edi babadayao, Seira nanatunayao Edoma tanona eai. ");
INSERT INTO swp_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotana nanatunayao Hori eo Hemani, eo Lotana louna ede Timina. ");
INSERT INTO swp_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobale nanatunayao ede ina: Aliwani, Manahata, Ebala, Sepo eo Onami. ");
INSERT INTO swp_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibiona nanatunayao ede ina: Aia, eo Anaha. Ina Anaha ta hosi i lobaidi barabara eai huiana wa tamana Sibiona ena asini i suidi. ");
INSERT INTO swp_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anaha nanatunayao ede ina: Disoni eo Oholibama, Anaha natuna sine. ");
INSERT INTO swp_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disoni nanatunayao ede ina: Hemidani, Esibani, Itirani eo Kerani. ");
INSERT INTO swp_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Esera nanatunayao ede ina: Bilihani, Saavani, eo Eikani. ");
INSERT INTO swp_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disani nanatunayao ede ina: Usa eo Arana. ");
INSERT INTO swp_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Hori tataodi edi babadayao ede ina: bada Lotana, bada Sobale, bada Sibiona, bada Anaha. ");
INSERT INTO swp_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Bada Disoni, bada Esera eo bada Disani; ina Hori tataodi Seira tanona edi babadayao. ");
INSERT INTO swp_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Abo wasawasa Edoma tanona se tanuagai ede ina, sora nige wasawasa esau Isaraela nanatunayao i tanuagaidi. ");
INSERT INTO swp_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, Beora natuna tau Edoma tanona i tanuagai, eo ena eanua esana ede Dinaba. ");
INSERT INTO swp_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela ie mate abo Iobaba, ia Seraha, Bosira tauna natuna i helaudamaei, i hemala wasawasa. ");
INSERT INTO swp_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Abo Iobaba ie mate to Husami, Temani tauna i helaudamai i hemala wasawasa. ");
INSERT INTO swp_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husami ie mate, lauhedamaina abo Hadadi, Bedadi natuna tau ia Midiani tataodi Moaba oeana eai i saepoidi, i hemala wasawasa. Ena eanua esana ede Avita. ");
INSERT INTO swp_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadadi i lautom abo Samala, Masareka tauna, i hemala wasawasa. ");
INSERT INTO swp_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samala i odalele abo Saulo, Rehobote sagasagana eai i laoma, i lauhedamai i hemala wasawasa. ");
INSERT INTO swp_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saulo i odalele abo Baal‐hanana, Akebore natuna tau, i hemala wasawasa. ");
INSERT INTO swp_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baal‐hanana, Akebore natuna tau i lautom, abo Hadara i helaudamai i hemala wasawasa: ena eanua esana Pau, monena esana Mehetabele, ia Matareda natuna sine, Matareda wa Mesahaba natuna sine. ");
INSERT INTO swp_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Isi ede babadayao esadi, Isoa arinai se laoma, adi bogaoyao, eo edi aba‐mia: bada Timina, bada Alawa, bada Ieteti. ");
INSERT INTO swp_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Bada Oholibama, bada Ela, bada Pinoni. ");
INSERT INTO swp_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Bada Kenasi, bada Temani, bada Mibisa. ");
INSERT INTO swp_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Bada Magadiela, eo bada Irami. Isi ede Edoma edi babadayao, esau esau edi tano eai se mia, ia ede Isoa tanona, ia Edoma tataodi tamadiyao. ");
INSERT INTO swp_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Iakobo i miahai Kanana tanona eai, eanua wa arinai tamana ia taulaolaoma mo. ");
INSERT INTO swp_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Iakobo ana isimurita ede ina. Iosepa maena tataoyao edi suisui se suidi, gama wa Bilaha eo Silepa nanatudiyao tatao maediyao, isi wa tamana monenayao. Abo Iosepa edi wasa baaea i leama tamana arinai. ");
INSERT INTO swp_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Na Isaraela Iosepa i gadosisi aririei nanatunayao boeadi eai, paana i tautaubadao se labasi, to ana lulu lohalohana esau i ginauri enana ma nima lohalohadi. ");
INSERT INTO swp_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Abo ena tataoyao se italobai, boeadi eai tamadi Iosepa i gadosisi aririei, arinai se hewaiunuei, eo taba nige se arina bigabiga arinai. ");
INSERT INTO swp_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Na Iosepa i enosuai, abo ena tataoyao i heribadi, to se hewaiunu aririei. ");
INSERT INTO swp_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","I ribalau aridi eai ie ene, “Ea aibodaimiu abo egu enosuai wasana au ataiei. ");
INSERT INTO swp_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Huia esau eda sitona ta augogoidi oea eai, abo eau egu augogo i toro dudurai, na omi enamiu se toro hetaiiri eo se duludobi eau egu augogo arinai.” ");
INSERT INTO swp_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Abo ena tataoyao si ene, “Mamohoi abo u saepoimai! Mamohoi abo u hemala ama tanuaga!” Arinai ena enosuai debana eai se hewaiunu aririei, eo ena riba debadi eai hinage. ");
INSERT INTO swp_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Iosepa i enosuaiuio, eo ena tataoyao ena enosuai ana ao i heribadi i ene, “Au ita, ea enosuaiuio, na doha ina, mahana eo nawarai, eo ipora saudoudoi esega se laoma se turibono arigu eai.” ");
INSERT INTO swp_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Abo tamana hinage i heriba, gonogonoana doha ena tataoyao i heribadi, na tamana i ribasuui, i ene, “Ina em enosuai ta aniona saha? Mamohoi eau, eo sinam eo em tataoyao abo ai laowa ai debatutu tano eai oa matam eai?” ");
INSERT INTO swp_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Iosepa ena tataoyao se aiaromagigiliei, na tamana mo ena riba wa i nuanuatuidi. ");
INSERT INTO swp_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ena tataoyao abo se lau Sekema hanahanauna eai tamadi ena mamoe eawoidi bena se suidi. ");
INSERT INTO swp_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Abo Isaraela i ribalau Iosepa arinai i ene, “Em tataoyao Sekema eai edi mamoe eawoidi se suidi e nige’e? U laoma abo ea hetamarim aridi eai.” To i ene, “Eau ede ina.” ");
INSERT INTO swp_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Iakobo hinage i ene, “Ea aibodaim bena u lau em tataoyao eo edi suisui u itadi, se lolo e nige’e, abo wasadi u uioyama.” Arinai i hetamari, Heberona gonuna wa i laugabaei ie lage Sekema eai. ");
INSERT INTO swp_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Abo tau esau i lobai Iosepa ie sae ie dobi oea eai, abo tau wa i hesiolau arinai, i ene, “Saha u eo’oeo’oi?” ");
INSERT INTO swp_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Iosepa i heuio, “Egu tataoyao ea eo’oidi, ea aibodaim abo u heribagu haedi edi mamoe eawoidi se suidi?” ");
INSERT INTO swp_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Tau wa i ene, “Ina tupo ta se torohaigabaeyao, paana edi riba ea ataiei si ene, ‘Hage ta torohai ta lau Dotana.’” Arinai Iosepa ena tatao i hemuriwataidi eo Dotana eai i lobaidi. ");
INSERT INTO swp_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Huiana wa se italaei eda lohaloha eai ia se ita, sora nige i hanahanauidi, se oiriba bena abo se unui. ");
INSERT INTO swp_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","To se ribalau esau esau arinai si ene, “Au ita, tau enosuai wa i laolaoma! ");
INSERT INTO swp_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Au laoma ta unui abo ta gabalaei duha lailai esau alona eai, abo ta ene, ‘Suisui manamanabalana esau ie ai,’ abo ta ita ena enosuai aniodi saha?” ");
INSERT INTO swp_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Reubena edi riba i ataiei, na i abihemauri isi nimadi eai, i ene, “Tabu ta unui!” ");
INSERT INTO swp_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Abo Reubena ie riba i ene, “Tabu osinana au hebolili, na au gabalaei ina duha alona eai barabara eai ta.” Paana i aipate bena Iosepa i abihai nimadi eai abo i moseuioi tamana arinai. ");
INSERT INTO swp_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Arinai ie tubu doha ina, Iosepa ie lage ena tataoyao aridi eai, ana lulu se opahai, lulu lohalohana i lui wa. ");
INSERT INTO swp_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Se abilau ia arinai se gabadobei duha lailai alona eai. Duha wa aha’ahana, nige goilana. ");
INSERT INTO swp_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Abotai se bawa adi aiai se aidi. Abo matadi se helabaisinidi, Isamaela tataodi gamagaridi se itadi, Gileada eai se laoma, edi kamela maediyao, muramura panepanedi udoi udoi se baheidi, se laedi Aigupito eai. ");
INSERT INTO swp_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Abo Iuda i ribalau ena tataoyao aridi eai i ene, “Saha lolona abo ta abi ena eda tau ta ta unui, eo osinana ta toreamui? ");
INSERT INTO swp_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","I lolo ta uneunei ina Isamaela tataodi aridi eai, eo tabu ta abilau arinai, paana ia eda tau ede, eo bulumada esega.” Abo ena tataoyao se eari. ");
INSERT INTO swp_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Midiani tauuneune se lage, abo Iosepa duha eai se tabeisini, eo se uneunei Isamaela tataodi aridi eai, maisana moni silver tau‐esega‐i‐mate, abotai Iosepa se laei Aigupito eai. ");
INSERT INTO swp_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Murina eai Reubena i uioma duha eai to ie ita, Iosepa duha eai nige’e, abo ana lulu i purisidi. ");
INSERT INTO swp_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Abo ie uio ena tataoyao aridi eai i ene, “Gama wa nei eai nige’e, to eau, abo haedi ea lau?” ");
INSERT INTO swp_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Iosepa ena lulu hinage se abi, eo goti natuna esau se unui, eo lulu wa se hedao osinana wa boeana eai. ");
INSERT INTO swp_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Abo lulu lohalohana ma nima lohalohadi se hetamarilaei tamadi arinai, si ene, “Ina ta ai lobai. Hage u ita, natum tau ana lulu e nige’e?” ");
INSERT INTO swp_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","To i nuatulobai eo i ene, “Ina ta natugu tau ana lulu ede, suisui manamanabalana esau ie ai, mamohoi Iosepa i purisigorigori!” ");
INSERT INTO swp_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Arinai Iakobo ana lulu i purisidi abo lulu medimediana duaduarina ea ie au, eo natuna i douei asubena gamagamagari. ");
INSERT INTO swp_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Abo nanatunayao gamagaridi tatao eo sisine se aipatei bena nuana se hebiga, na edi henuabiga nige i henua, na enaba, “Abo ma dougu na ea dobi bousa eai natugu tau arinai.” Doha ina tamana Iosepa sabina ie dou. ");
INSERT INTO swp_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Abo Midiani tataodi ia se uneunei Aigupito eai Potiparo arinai, Parao ena tau paisoa esau, ia tauiala edi kapena. ");
INSERT INTO swp_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Huiana eai ne Iuda ena tataoyao i lausuaraedi ie lau ie mia Adulama tauna esau esana Hira arinai. ");
INSERT INTO swp_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Nei eai Iuda Kanana tauna esau esana Sua natuna sine i hailobai to i tawasoraei. ");
INSERT INTO swp_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Abo ie boga natuna tau i labasi esana se tore Era. ");
INSERT INTO swp_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","I bogauio natuna tau i labasi esana se tore Onani. ");
INSERT INTO swp_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","I bogauio tau esau i labasi, esana ie tore Sela. Ia Kesiba eai na i labasi. ");
INSERT INTO swp_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Abo Iuda ena ealahou tau Era monena ie abi esana Tamara. ");
INSERT INTO swp_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","To Era, Iuda ena ealahou tau, i baaea GUIAU matana eai, to GUIAU i unuhemate. ");
INSERT INTO swp_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Abo Iuda i ribalau Onani arinai i ene, “Em tau ena wabu u tawasoraei, abo merumeru u hetubudi, bena em tau enanayao.” ");
INSERT INTO swp_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Na Onani abina ie ata merumeru taba nige ia nanatunayao tahunuadi, arinai huiana wa i lau ie eno ena tau ana wabu arinai, tuma wa i hebolili gaibui ata merumeru esau i hetubu ena tau enana. ");
INSERT INTO swp_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ina ena laulau ta GUIAU nuana i hebaaea, arinai Onani hinage GUIAU i unuhemate gonogonoana doha ena tau. ");
INSERT INTO swp_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Abo Iuda i ribalau bosiana Tamara arinai i ene, “Abo u mia wabuwabu tamam ena numa eai i lau e natugu tau Sela i lailai;” paana i ene, “Ata ia hinage i mate gonogonoana doha ena tataoyao.” To Tamara ie lau ie mia tamana ena numa eai. ");
INSERT INTO swp_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Eawalana ie lau abo Iuda monena, Sua natuna, i odalele na Iuda huiana nuana ie biga, ie sae ena mamoe wieadi tautomtom, Timinati eai, ia maena doga Hira, Adulama tauna. ");
INSERT INTO swp_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Abo Tamara se heriba, “U ataiei, bosiam ie sae Timinati eai ena mamoe wieadi i tomdi.” ");
INSERT INTO swp_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Arinai ena wabuwabu luludi i torehesuaradi, lulu esau arinai ana ao i buburi, eo hinage tauna ie suma ie lau ie bawa tupo masamasaraha eai, Timinati dobilana eai, paana Sela i itayao i lailaio, na nige se mosei arinai bena i tawasoraei. ");
INSERT INTO swp_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Huiana wa Iuda ie ita i ene bena ia sine baaeana paana matana i buburi. ");
INSERT INTO swp_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Abo i sinibui arinai i ene, “U laoma ta eno,” paana nige abina i ata ia bosiana. To i ene, “Saha abo arinai u hemaisagu, bena abo u laoma arigu eai ta?” ");
INSERT INTO swp_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Eo i ene, “Abo mamoe gagirina ea hetamariawa.” Sine wa i ene, “Em riba hesunuma heiheinoina saha, bena abo mamoe wa u hetemariama?” ");
INSERT INTO swp_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Iuda i ene, “Abo egu riba heiheinoina aisana?” Na sine wa i ene, “Em nimaau, ma mainana, eo em tu’e nimam eai.” Abo i mosedi arinai, na maena se eno, abo ia arinai ie boga. ");
INSERT INTO swp_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Abo i toro, ie lau, ena abobo i torehesuala, na ena wabuwabu luluna i luiuioi. ");
INSERT INTO swp_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Iuda mamoe gagirina i hetamarilaei arinai, ena doga Adulama tauna nimana eai, bena abo ena riba hesunuma heiheinoidi i abiuioidi sine wa nimana eai, na sine wa nige i lobai. ");
INSERT INTO swp_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Arinai meta eanua me tataodi i hesioedi i ene, “Sine baaeana wa haedi eai, ia inai ie bawa tupo masamasaharana eai?” Abo si ene, “Nige sine baaea esau ina tupo eai ta.” ");
INSERT INTO swp_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","To ie uio Iuda arinai i ene, “Nige gonoana ea lobai, eo hinage eanua tataodi si ene nige sine baaea esau nei tupo eai ne.” ");
INSERT INTO swp_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Iuda i ene, “Taiede, abo ginauri wa i abididinidi ata ta taumaeamaea. Mamoe ea hetamarilaei sine wa arinai na nige u lobai.” ");
INSERT INTO swp_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Nawarai haiona se lau na Iuda se heriba si ene, “Bosiam Tamara laulau baaea i ginauri, eo hinage ena laulau baaea debana eai ie boga.” Iuda i ene, “I lolo si woeaiama to si gabuunui.” ");
INSERT INTO swp_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Huiana wa se woeai, riba i hetamarilaei bosiana arinai i ene, “Ina ginauri ta aisega tau enana, tau wa ia i hebogagu.” Eo i ene, “Hage au ita ina ginauri ta meta eai enana, ina nimau ma mainana eo ina tu’e ta?” ");
INSERT INTO swp_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Abo Iuda i nuatulobaidi i ene, “Ia i dudurai, na eau nige, paana natugu tau Sela nige ea mosei i tawasorai.” To nige i uio arinai. ");
INSERT INTO swp_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ena huia haisu ie lage abo se ita godegode bogana eai. ");
INSERT INTO swp_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ena huia paipaisoa eai wa na bebe esau nimana i helulageyama, na sine tauabihelabalabana nimana eai maina buyabuyana ie au i ene, “Ina bebe ta ia taubaguna.” ");
INSERT INTO swp_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Abotai nimana i uioei, to ena tau i laoma baguna, abo i ene, “Edohana to u baguna?” Arinai esana se tore Paresi. ");
INSERT INTO swp_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Abo murina eai ena tau se labasi ia nimana eai maina buyabuyana, eo esana se tore Seraha. ");
INSERT INTO swp_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Iosepa se dobei Aigupito eai, eo Potiparo, Parao ena heaheari tauna esau, iala kapenana, Aigupito tauna, ia Isamaela tataodi aridi eai Iosepa i unehai, isi wa ia se dobei nei eai. ");
INSERT INTO swp_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Na GUIAU Iosepa maena, abo i hemala gogo tauna; abo hinage ie mia ana tanuaga Aigupito tauna ena numa eai. ");
INSERT INTO swp_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Abo ana tanuaga ie ita GUIAU maena, saha eo saha Iosepa i ginauridi, meta GUIAU i helolo nimana eai. ");
INSERT INTO swp_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Abo Iosepa ana tanuaga i henualolo eo i heayayei, to i hetoro tanuaga lailai ena numa alona eai, eo ena ginauri gamagamagaridi i toredi ia nimana eai. ");
INSERT INTO swp_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Huiana wa i hetoro tanuaga ena numa eai eo ena ginauri gamagamagaridi hinage arinai GUIAU Aigupito tauna ena numa i helolo Iosepa debana eai, eo GUIAU ena ainauia ie talu ena gogo maudoina potadi eai, numa eai eo oea eai. ");
INSERT INTO swp_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Eo Potiparo ena ginauri gamagaridi i toredi Iosepa nimana eai, eo nige ie mode ena ginauri saha eo saha aridi eai, na ana aiai mo arinai. Na Iosepa ana ao i lolo ariri ma anabela. ");
INSERT INTO swp_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Abo huia esau ana tanuaga monena matana i tulaei Iosepa arinai, i ene, “U laoma ta eno.” ");
INSERT INTO swp_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Na Iosepa i otaota, eo i ribalau ana tanuaga monena arinai i ene, “U ita, saha eo saha ina numa eai ta agu tanuaga nige i hasiridi, na ena gogo maudoina ie tore nimagu eai. ");
INSERT INTO swp_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Nige esau ina numa eai ta i saepoigu, eo hinage nige saha i nuahi arigu eai na oabom mo, paana oa monena. Edohana abo baaea lailai ta ea ginauri, eo Eaubada hinage nuana ea hebaaea?” ");
INSERT INTO swp_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Eawalana ie lau na asubena gamagamagari doha ina i ribalau Iosepa arinai, na ena riba wa nige i lauwatai bena maena si eno e bena i lau gegesina eai. ");
INSERT INTO swp_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Na huia esau doha ina ie tubu, Iosepa i awasae numaalo eai ana paisoa i ginaginauridi, eo numa tataodi gamagaridi numa eai nige’e. ");
INSERT INTO swp_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Na sine wa i abilau ana lulu arinai, i ene, “U laoma, ta eno!” Na ana lulu i laugabaei ia nimana eai na ie dago numa i pesagabaei. ");
INSERT INTO swp_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Abo sine wa ie ita ana lulu i laugabaei ia nimana eai na ie dago murimuri eai, ");
INSERT INTO swp_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","I eogalau ena numa tataodi aridi eai abo i heribadi i ene, “Hage au ita, ina Heberu tauna se woeaiama arida eai abo i awaeaueauleda; i laoma arigu eai bena abo ai eno, to ea eabalailai. ");
INSERT INTO swp_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Huiana wa arinagu i ataiei ea eabalailai abo ana lulu i laugabaei, arigu eai na ie dago, ie pesa.” ");
INSERT INTO swp_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ana lulu i tore gegesina eai i lau e ana tanuaga i uioma. ");
INSERT INTO swp_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Abo i ribalau ia arinai doha ina i ena, “Em heaheari Heberu tauna u woeaima wa, i laoma arigu eai bena i hebaaeagu; ");
INSERT INTO swp_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","na huiana eai wa arinagu ea helai ea eabaeaba abo ana lulu i laugabaei arigu eai eo ie dago ie pesa.” ");
INSERT INTO swp_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Abo ana tanuaga wa monena ena riba i ataiedi i ene, “Doha ina em heaheari tauna ena abiabi arigu eai,” i ouyalayala ariri. ");
INSERT INTO swp_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Abo Iosepa ana tanuaga i abilau Iosepa arinai ie tore numa masigiri eai, dimo wa haedi wasawasa ena tauauaudi se tutuguduidi, to ia nei eai numa masigiri eai. ");
INSERT INTO swp_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Na GUIAU Iosepa maena, eo i nuatoatoaei abo numa masigiri tauitawataina nuana i helolo ia arinai. ");
INSERT INTO swp_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Abo numa masigiri tauitawataina tauauau gamagaridi numa masigiri eai i toredi Iosepa nimana eai, eo saha eo saha nei eai se ginauridi ia tauitawataidi ede. ");
INSERT INTO swp_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Eo numa masigiri tautawataina nige i mode ginauri esau Iosepa nimana eai, paana GUIAU ia maena, eo ginauri gamagaridi i ginauridi GUIAU i helolodi. ");
INSERT INTO swp_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ina ginauri ta muridi eai Aigupito ena wasawasa ena bia taubaheina eo ena falawa tau gabugabu adi tanuaga Aigupito ena wasawasa nuana se hebaaea. ");
INSERT INTO swp_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Abo Parao i ouyalayala ana tanutanuaga labui aridi eai, ena bia taubaheina adi tanuaga arinai eo falawa taugabugabu adi tanuaga arinai. ");
INSERT INTO swp_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Arinai i audi i toredi iala kapenana ena numa eai numa masigiri eai, dimo wa ia ede Iosepa aba tutuguduina. ");
INSERT INTO swp_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Iala kapenana i toredi Iosepa nimana eai, eo i itawataidi, to se mialohaloha numa masigiri eai. ");
INSERT INTO swp_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Abo maiona esau arinai taudi labui enosuai se enosuaiei, esau esau ena enosuai aniona, Aigupito edi wasawasa ena bia taubaheina eo ena falawa taugabugabuna, isi numa masigiri eai se toredi wa. ");
INSERT INTO swp_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Maratomtom eai Iosepa i awasae aridi eai, na i itadi se nuadubu. ");
INSERT INTO swp_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Arinai i hesiolau isi wa Parao ena paisoa tanutanuagadi aridi eai maenayao ana tanuaga ena numatutugudu eai wa, i ene, “Wauta paana saha ami ao se porohe?” ");
INSERT INTO swp_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Abo ia se heuio si ene, “Enosuai esau ai enosuaiei, na nige tau esau bena aniona i heribamai.” Iosepa i ene, “Enosuai aniodi Eaubada nimana eai e nige’e? Ea aibodaimiu abo enosuai wa au heribagu.” ");
INSERT INTO swp_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Bia taubaheina ena enosuai Iosepa i heriba i ene, “Egu enosuai eai vine esau matagu eai, ");
INSERT INTO swp_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","eo vine wa laganayao haiona. Abotai se bogu, se taya, abo taya wa aridi eai uaua buinadi i toredi. ");
INSERT INTO swp_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Na Parao ena bia nimagu eai, eo vine uauadi ea abidi nimagu eai ea tamdi Parao ena bia arinai, abo bia wa ea toreuioi Parao nimana eai.” ");
INSERT INTO swp_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Abo Iosepa i heriba doha ina, “Ina aniona ede: vine laganayao haiona abo asubena haiona. ");
INSERT INTO swp_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ena asubena haiona se lau abo Parao urum i lausini eo i hetorouioim em abo toro eai, eo Parao ena bia abo u tore ia nimana eai, doha beabeana oa ena bia taubaheina wa. ");
INSERT INTO swp_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Na ena huia lolo u hearo hage u nuatuigu eo ea aibodaim bena em abilolo hemasaraha arigu eai, eo esagu u atai Parao matana eai, bena abo ina numa eai ta i woea hepesagu. ");
INSERT INTO swp_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Paana mamohoi Heberu tataodi edi tano eai se aiyaharigu se laeguma, eo inai hinage nige saha ea ginauri debana eai se toregu numa masigiri eai ta.” ");
INSERT INTO swp_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ena falawa taugabugabu adi tanuaga enosuai aniona i ataiei i lolo, ia hinage i ene, “Eau doha ina ea enosuai, urugu eai keke bosadi haiona. ");
INSERT INTO swp_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Bosa pota ariri eai aiai gabugabudi udoi udoi Parao ana, na manu se laoma bosa wa urugu eai aiai wa se aidi.” ");
INSERT INTO swp_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Abo Iosepa i heuio i ene, “Aniona ede ina; bosa haiona meta asubena haiona. ");
INSERT INTO swp_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ena asubena haiona se ohi, Parao abo i earigabaem na abo i heabasim oeagi ewana eai, abo manu se laoma bulumam se ai.” ");
INSERT INTO swp_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Asubenana hehaionana eai Parao ena huia labasi eai, ena heaheari tataodi gamagaridi adi mataasi i ginauri, eo ena bia taubaheina adi tanauaga, eo falawa taugabugabu adi tanuaga i earigabaedi ena heaheari tataodi boeadi eai. ");
INSERT INTO swp_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Abo ana paisoa i toreuio bia taubaheina adi tanuaga nimana eai, abo Parao ena bia i toreuio nimana eai, ");
INSERT INTO swp_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","na falawa taugabugabu adi tanuaga i hegadosoha gonogonoana doha Iosepa i ribaei. ");
INSERT INTO swp_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Na bia taubaheina adi tanauaga nige begana Iosepa i nuatui, na i nuahuiei. ");
INSERT INTO swp_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Abo borimai labui se laoo na Parao i enosuaiei, ia saga gegesina eai i totoro, ");
INSERT INTO swp_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Na bulumakau bawesinadi haligigi‐labui adi ao se lolo eo se tubu lolo, saga eai se gaiosaema abo goila gegesina eai se aibai. ");
INSERT INTO swp_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Murina eai abo bulumakau bawesinadi headi, haligigi‐labui, saga eai se gaiosaema isi adi ao se baaea, eo se eagaeaga ariri. Abo bulumakau bagubagunadi gegesidi eai se totoro saga wa laopana eai. ");
INSERT INTO swp_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Abo bulumakau baabaaeadi eo eagaeagadi bulumakau haligigi‐labui lolodi eo tubutubudi se ai heohidi. Arinai Parao i eno toro. ");
INSERT INTO swp_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Abo i enouio abo i enosuaiuio: na sitona aiaidi haligigi‐labui se ini pa’a esega arinai, lolodi eo lailaidi. ");
INSERT INTO swp_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Murina eai sitona aiaidi haligigi‐labui baabaaeadi se inisae, mana aruabu i hebaaeadi. ");
INSERT INTO swp_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Abo sitona aiaidi haligigi‐labui baabaaeadi wa, sitona aiaidi haligigi‐labui lolodi eo lailaidi wa se aiheohidi. Abo Parao i enotoro to ie ita enosuai mo. ");
INSERT INTO swp_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Abo maratomtom eai nuana ie mode, abo tautabusima tataodi gamagaridi Aigupito eai, eo tatao sonosonogadi gamagaridi i eogaidi, abo Parao ena enosuai i heribadi, na nige esau abina i ata enosuai wa aniodi i hemasarahadi Parao arinai. ");
INSERT INTO swp_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Arinai ena bia taubaheina adi tanuaga i ribalau Parao arinai i ene, “Egu ponori wauta ea italobaidi ");
INSERT INTO swp_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Parao ena heaheari tataodi aridi eai i ouyalayala arinai i tutuguduigu iala kapenana ena numa eai, eau eo falawa taugabugabu adi tanuaga hinage. ");
INSERT INTO swp_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Abo maiona esega eai ai enosuai eau eo ia, abo esau esau iabom ena enosuai aniona. ");
INSERT INTO swp_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Na hewari esau boeamai eai ia Heberu tauna, iala kapenana ena heaheari, abo ai ribalau ia arinai to ema enosuai aniodi i heribamai, esau esau iabom ena enosuai aniona i hemasaraha. ");
INSERT INTO swp_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Hinage gonogonoana doha ia i ribaei wa, meta ie tubu. Eau wasawasa wa i abiuioigu agu paisoa arinai, na esau wa i hegadosoha.” ");
INSERT INTO swp_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Abo Parao ie riba to Iosepa se eogai, numa masigiri eai se hepesa heuraeyama, i gaeagaeaom, ana lulu a’ana ie lui, abo i laoma Parao matana eai. ");
INSERT INTO swp_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","To Parao i ribalau Iosepa arinai i ene, “Enosuai esau ea enosuaiei, na nige tau esau abina i ata abo aniona i heribagu, na oa wasam ea ataiei gonoam enosuai aniodi u italobaidi.” ");
INSERT INTO swp_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Abo Iosepa Parao i heuio i ene, “Eau nige’e, na Eaubada iabom abo aniona lolona i hemasaraha Parao arinai.” ");
INSERT INTO swp_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Parao i ribalau Iosepa arinai, i ene, “Egu enosuai eai saga esau hasarina eai ea totoro. ");
INSERT INTO swp_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Na bulumakau bawesinadi haligigi‐labui lolodi eo tubutubudi saga eai se gaeosaema, abo lagau boeana eai se aibai. ");
INSERT INTO swp_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Murina eai bulumakau haligigi‐labui baabaaeadi eo eagaeagadi se gaeosaema, nige maesega ao baabaaeana doha meta ea ita Aigupito tanona maudoina boeana eai. ");
INSERT INTO swp_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Abo bulumakau baabaaeadi, eagaeagadi, wau bulumakau haligigi‐labui tubutubu lolodi wa se aiheohidi. ");
INSERT INTO swp_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Na se aiheohidi murina eai adi ao gonogonoadi, sora ma eagaeagadi doha bagubaguna eai wa. Abotai ea eno toro. ");
INSERT INTO swp_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Abo egu enosuai esau doha ina, sitona aiaidi haligigi‐labui se ini pa’a esega arinai, se lailai eo se lolo. ");
INSERT INTO swp_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Abo murina eai sitona aiaidi haligigi‐labui wowoeadi eo gagiridi mana aruabu i hebaaeadi wa, se inisaema. ");
INSERT INTO swp_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Na sitona gagiridi wa sitona haligigi‐labui lolodi wa se aidi; Ina riba ta ea mosei tautabutabusima aridi eai, na nige esau gonoana aniona wa i heribagu.” ");
INSERT INTO swp_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Iosepa i ribalau Parao arinai i ene, “Parao ena enosuai aniodi esega. Eaubada Parao i heita saha abo i ginauri. ");
INSERT INTO swp_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Bulumakau bawesinadi lolodi haligigi‐labui, borimai haligigi‐labui ede, eo sitona aiaidi lolodi haligigi‐labui borimai haligigi‐labui ede. Enosuai labui aniodi esega. ");
INSERT INTO swp_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Bulumakau bawesinadi haligigi‐labui eagaeagadi baabaaeadi isi borimai haligigi‐labui, abo sitona aiaidi mana i hebaaeadi wa, meta abo guriam lailai borimai haligigi‐labui boeadi eai. ");
INSERT INTO swp_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ina aniona ede gonogonoana doha Parao ea heriba: saha Eaubada abo i ginauri meta i heitayao Parao arinai. ");
INSERT INTO swp_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Au ita abo borimai haligigi‐labui matada eai abo aiai i lai ariri Aigupito boeana eai. ");
INSERT INTO swp_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Murina eai abo borimai haligigi‐labui se laolaoma boeadi eai abo guriam lailai. Na aiai lailai wa abo i tauyamui Aigupito dimona eai, paana guriam abo eanua i laugirihai. ");
INSERT INTO swp_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Aiai lailai wa hinage abo se hekau eanua maudoina boeana eai guriam lailai wa debana eai, paana abo i baaea ariri. ");
INSERT INTO swp_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Eaubada enosuai i helabui Parao arinai ia ede paana ginauri ta Eaubada i nuatu nonohai, eo nige baeaona abo i hemamohoiei. ");
INSERT INTO swp_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Hage abo Parao tau esau i eo’oi, tau sibasibana eo tau sonosonogana abo i hetoro Aigupito i tanuagai. ");
INSERT INTO swp_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Doha ina taba Parao i ginauri, abo tanutanuaga headi i hetorodi Aigupito eanuana eai abo borimai lolodi haligigi‐labui aiaidi lausoisoi hehaligigina se tore hesuara. ");
INSERT INTO swp_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Aiai se tanogogo borimai lolodi huiadi eai, sitona wa se torehesuara Parao ena riba arinai, abo aiai wa se torekomakomani eanua lailaidi boeadi eai. ");
INSERT INTO swp_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Aiai wa se torehesuara huia guriam ena borimai haligigi‐labui wa, abo se lagema Aigupito dimona eai. Bena abo eanua maudoina taba nige guriam debana eai se mate.” ");
INSERT INTO swp_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Nuatu wa i lolo ariri Parao matana eai, eo ena heaheari tataodi matadi eai hinage. ");
INSERT INTO swp_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Abo Parao i ribalau ena heaheari tataodi aridi eai, “Abo haedi tau esau ta lobai doha ina tau ta, ia nuana eai Eaubada Earuana ede?” ");
INSERT INTO swp_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","To Parao i ribalau Iosepa arinai, i ene, “Eaubada ina ginauri gamagaridi i heitam ta, arinai nuana taba nige tau esau ai lobai i sibasiba eo i sonoga doha oa. ");
INSERT INTO swp_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Arinai abo egu numa u tanuagai eo em riba abo i hemala laugagaeo egu eanua maudoina boeana eai. Eaubogu mo telona potana eai ea bawa, eaubogu abo ea saepoim.” ");
INSERT INTO swp_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Abo Parao i ribalau Iosepa arinai i ene, “U ita, oa ea hetorom, abo Aigupito maudoina u tanuagai.” ");
INSERT INTO swp_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Parao hinage ena nimaau nimana eai i abihai, eo i torelaei Iosepa nimana eai, eo lulu lolona arinai i helui, eo gadogado gold i hegadoi. ");
INSERT INTO swp_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Abo i heriba to ena kariota helabuina i gerui, abo tau eda bagunaena se eogaeoga, “Au turibono!” Eo i hetoro tanuaga lailai Aigupito maudoina boeana eai. ");
INSERT INTO swp_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Parao hinage i ribalau Iosepa arinai i ene, “Eau Parao, taba nige tau esau Aigupito boeana eai nimana e aena i lausinidi, na oa em riba mo arinai.” ");
INSERT INTO swp_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Abo Parao Iosepa esana ie tore Sapanata‐panea, eo monena i mosei Asenati, Potipera, Ona edi Kohena, natuna, Arinai Iosepa ie pesa ie lau Aigupito eanuana maudoina i taudadai. ");
INSERT INTO swp_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Huiana wa Iosepa i toro Parao matana eai Aigupito edi wasawasa, ena borimai tau‐esega‐i‐mate‐saudoudoi. Eo Iosepa Parao matana eai ie pesa ie lau abo Aigupito eanuana i taudadai. ");
INSERT INTO swp_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Borimai lolodi haligigi‐labui boeadi eai masuri i lai ariri. ");
INSERT INTO swp_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ina borimai haligigi‐labui boeadi eai aiai maudoina Aigupito eai i tanogogoi, eo i torehesuala eanua lailaidi alodi eai, eanua esau esau oeadi adi aiai i torehesuala eanua lailaidi boeadi eai. ");
INSERT INTO swp_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Abo sitona aiaidi Iosepa i peigogoidi doha gabogabo gelegelena, i lai ariariri, i lau e se hasiri asaeai, paana taba nige se nonoi. ");
INSERT INTO swp_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Sora nige huia guriam ie tubu Iosepa nanatunayao labui Asenati i labasidi, ia Potipera, Ona ena kohena, natuna sine. ");
INSERT INTO swp_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Abo Iosepa ena ealahou tau esana ie tore Manase, i ene, “Paana egu paisoa matemate, eo hinage tamagu ena numa tataodi Eaubada i henuahuiegu.” ");
INSERT INTO swp_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Abo helabuina esana ie tore Eparaima, i ene, “Paana Eaubada i hemasurigu egu amamna eanuana boeana eai.” ");
INSERT INTO swp_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","I lau e masuri borimaidi haligigi‐labui se ohi Aigupito tanona eai. ");
INSERT INTO swp_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Abotai guriam borimaidi haligigi‐labui se hetubu gonogonoana doha Iosepa i ribaei. Guriam wa eanua gamagaridi boeadi eai, na Aigupito eanuana boeana eai aiai ie ota. ");
INSERT INTO swp_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Huiana eai wa Aigupito eanuana maudoina i beruberu guriam debana eai, tatao se doulau Parao arinai bena aiai i mosedi, abo Parao i ribalau aridi eai, i ene, “Au lau Iosepa arinai, ia saha i ribaei abo au lauwatai.” ");
INSERT INTO swp_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Huiana eai wa guriam tanoubu maudoina i laugirihai abo Iosepa aiai aba‐peiauri i soedi, Aigupito tataodi aridi eai i uneunei, paana guriam i lai ariariri, Aigupito tanona eai. ");
INSERT INTO swp_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Abo eanua gamagaridi se laoma Aigupito eai Iosepa arinai, paana guriam wai i lai ariri tanoubu tupo gamagamagari eai. ");
INSERT INTO swp_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Abotai Iakobo i ataiei sitona Aigupito eai ie lai to i ribalau nanatunayao tatao aridi eai, i ene, “Paana saha au haimata‐itaitauioimiu?” ");
INSERT INTO swp_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Eo i ene, “Ea ataiei sitona Aigupito eai ie ota: au dobi nei eai ada au uneune, abo ta mauri eo taba nige ta mate.” ");
INSERT INTO swp_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Arinai Iosepa ena tataoyao saudoudoi se dobi Aigupito eai bena abo sitona se uneune. ");
INSERT INTO swp_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Na Iakobo Beniamina, Iosepa ena tau, nige i hetamari ena tatao maenayao, paana i ene, “Ata baaea esau i hearo.” ");
INSERT INTO swp_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Abo Isaraela nanatunayao tatao se laoma sitona se uneune dodoga headi tauuneune boeadi eai, paana guriam i lai ariri Kanana eai. ");
INSERT INTO swp_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Na Iosepa ia eanua ana tanuaga, eo hinage ia tauuneune eanua tataodi gamagaridi aridi eai: abo Iosepa ena tataoyao se laoma se tabaohu ia matana eai, adi ao se dobi tano eai. ");
INSERT INTO swp_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Iosepa ena tataoyao i itadi abo i nuatulobaidio, na ana ao ie tore doha i hekaudi, abo ena riba se oiura aridi eai, to i ene, “Haedi au laoma?” Abo se ene, “Kanana dimona eai ai laoma bena aiai ai uneunei.” ");
INSERT INTO swp_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Iosepa ena tataoyao i nuatulobaidio, na isi mo ia se hekau. ");
INSERT INTO swp_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Abotai Iosepa ena enosuai isi enadi i enosuaiedi wa i nuanuatuidi to i ribalau aridi eai i ene, “Omi tau itasipo, nuana eanua ena guriam bena au laoma au itasipoi.” ");
INSERT INTO swp_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Isi si ene, “Ema guiau e, nige’e, na em heaheari tataodi se laoma bena aiai se uneune. ");
INSERT INTO swp_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ai gamagarimai tau esega nanatunayao ai riba mamohoi tataomai, ai nige tau itaitasipo tataomai.” ");
INSERT INTO swp_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","To i heuio i ene, “Nige’e, au laoma bena eanua ena guriam au ita.” ");
INSERT INTO swp_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Abo si ene, “Ai em heaheari tataomai, ai tatao saudoudoi‐labui, tau esega nanatunayao ia Kanana dimona eai, na taumurita ia tamana arinai, na esau wa i mateo.” ");
INSERT INTO swp_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Na Iosepa i ribalau aridi eai i ene, “Ia ede doha wau ea ribaei wa, ea’ne omi ede tau itasipo. ");
INSERT INTO swp_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Doha ina abo ea lauitamiu, Parao ena mauri debana eai taba nige au pesa au lau, na taba emi goloa mo i laoma inai. ");
INSERT INTO swp_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Abo esau au hetamari i lau emi tau i woeaiyama, na omi abo se tutuguduimiu, bena emi riba se lauitadi riba mamohoi e nige’e. Ena ina ta nige au lauwatai, Parao maurina debana eai, abo ai nuatulobaimiu omi tauitaitasipo ede.” ");
INSERT INTO swp_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Abo i toregogoidi numa masigiri eai asubena haiona. ");
INSERT INTO swp_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Asubena hehaionana eai Iosepa i heribadi i ene, “Doha ina au ginauri abo au mauri. Eau Eaubada ea matausiei! ");
INSERT INTO swp_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ena emi riba riba mamohoina abo esau boeamiu eai si au emi numa masigiri eai ta, omi headi au torohai sitona au bahei au laei emi numa tataodi guriguriamdi adi. ");
INSERT INTO swp_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Na ami taumurita au woeaiyama arigu eai arinai abo emi riba au hemamohoiedi eo taba nige au mate.” Arinai ena riba se lauwatai. ");
INSERT INTO swp_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Abo esau esau se ribariba si ene, “Mamohoi ita ada gilu, eda tau debana eai, paana ena amamna lailai ta ita, na ena aiboda gadogadora nige ta ataiei, arinai ina ginauri pilipilina ta ta hearo.” ");
INSERT INTO swp_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Abo Reubena i heuioidi i ene, “Ea heribamiu e nige’e, ea ne tabu ina gama ta ta hebaaea, na omi nige au henua au ataiei? Arinai au ita ia osinana maisana ede ina potada eai.” ");
INSERT INTO swp_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Na nige abina se ata arinadi Iosepa i atailobai, paana tauribabui esau ena riba i ribabuidi. ");
INSERT INTO swp_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Abo Iosepa i lausuaraedi ie dou: ie uio aridi eai maenayao se ribariba, abo Simiona i abihai boeadi eai, abo matadi eai ie au. ");
INSERT INTO swp_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Murina eai ie riba to edi baeki se hemonaudi sitona arinai, abo hinage tau esa esa ena moni i toreuioi ena baeki eai, eo hinage bena dobila alaena se mosei aridi eai. Ina ta enadi se ginauri. ");
INSERT INTO swp_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Sitona baekidi wa se toresaedi asini potadi eai, to se torohai. ");
INSERT INTO swp_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Huiana wa esau ena baeki ie soe bena ena asini i heai aba aieawasi numana eai, ena moni wa i lobai paana baeki awana eai ie ota. ");
INSERT INTO swp_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","To i ribalau ena tataoyao aridi eai, i ene, “Egu moni se toreuioiyama to ia ede ina egu baeki eai!” Abo nuadi se welo, to se matausi ariri, esau esau se ribariba si ene, “Eaubada ena abiabi saha arida eai?” ");
INSERT INTO swp_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","To se lage tamadi Iakobo arinai Kanana tanona eai, abo se heriheriba saha eo saha se tubu aridi eai, si ene, ");
INSERT INTO swp_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Tau wa ia eanua ne guiauna ena riba i he’oiura arimai eai, eo i ene bena ai eanua ne tau‐itasipoina ede. ");
INSERT INTO swp_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","To ai heriba ai ene, ‘Ai riba mamohoi tataomai, ai nige tau‐itaitasipo. ");
INSERT INTO swp_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ai tataomai saudoudoi‐labui, tamamai esega, esega i mateo, na murimuritana ia wauta tamamai arinai Kanana tanona eai.’ ");
INSERT INTO swp_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Abo tau wa, eanua ne guiauna i heribamai i ene, ‘Doha ina abo abina ea ata omi ribamamohoi tataomiu e nige’e, abo emi tau esega au laugabaei inai arigu eai, eo aiai au bahei emi numa tataodi guriguriamdi adi, eo au lau. ");
INSERT INTO swp_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ami taumurita au woeaiyama arigu eai, arinai abo abina ea ata omi nige tauitaitasipo na omi ribamamohoi tataomiu, arinai abo emi tau ea leawauioi arimiu eai, hinage abo ina eanua eai ta gonoana abo au uneune.’” ");
INSERT INTO swp_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Huiana wa edi baeki se hegoigabaedi, aruadi se loi paana gamagaridi esau esau ena moni sumana wa ena baeki alona eai, abo isi ma tamadi moni sumadi wa se itadi se matausi ariri. ");
INSERT INTO swp_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Abo tamadi Iakobo i ribalau aridi eai i ene, “Nanatuguyao au abihaidi arigu eai! Iosepa ie mate, eo Simiona inai nige’e, na abo hinage Beniamina au abihesuara. Ginauri gamagaridi se lau baaea arigu eai!” ");
INSERT INTO swp_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Abo Reubena i ribalau tamana arinai i ene, “Ena nige ea woeauioiyama arim eai abo eau nanatuguyao labui abo u unuidi. U tore nimagu eai, na abo ea woeauioiyama arim eai.” ");
INSERT INTO swp_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Na i ene, “Taba nige natugu maemiu au dobi, paana ena tau ie mate, na iabom: ena saha i hearo emi abalau eai abo ma hougu eo ma dougu au woeadobegu mate dimona eai.” ");
INSERT INTO swp_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Na guriam i lai ariariri nei eanua eai ne. ");
INSERT INTO swp_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Abo eawalana ie lau, na sitona maudoina se leama Aigupito eai wa se aiheohi, to tamadi i ribalau aridi eai, i ene, “Au torohaiuio aiai ada begana au uneune.” ");
INSERT INTO swp_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Na Iuda i heriba i ene, “Tau wa i riba adidiri arimai eai, i ene ‘Taba nige agu ao au ita ena emi tau nige au woeaiyama.’” ");
INSERT INTO swp_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ena ema tau u abigabaei maemai ai lau abo ai dobi ama aiai ai uneune. ");
INSERT INTO swp_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Na ena ia nige u hetamari taba nige ai dobi; paana tau wa i ribaei, i ene, ‘Taba nige agu ao au ita ena emi tau nige au woeaiama.’” ");
INSERT INTO swp_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Abo Isaraela i ene, “Paana saha ina iwala ta au leama eo emi tau esau wasana au heriba?” ");
INSERT INTO swp_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","To si ene, “Tau wa i hesiodudulai arimai eai ema miamia eo ama bogaoyao wasadi, i ene, ‘Tamamiu sora ma miana, eo hinage emi tau esau e nige’e?’ Arinai ena hesio wa ai heuioidi. Edohana abo abina ai ata ena riba doha ina, ‘Emi tau au dobeiyama’?” ");
INSERT INTO swp_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Arinai Iuda i ribalau tamana Isaraela arinai i ene, “Gama wa u tore nimagu eai abo ai torohai ai lau, arinai abo ta mauri, taba nige ta mate, ai eo oa, eo nanatumaiyao gagiridi hinage. ");
INSERT INTO swp_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Abo u tore nimagu eai, eau egu porohe: ena nige ea woeauioi arim eai eo ea hetoro matam eai abo i lolo giluna ea bahei i lau e nige nosina. ");
INSERT INTO swp_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ena nige doha ina eda huia ta gabaei ina ta taba eda huia uioma helabuina ede.” ");
INSERT INTO swp_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Abo tamadi Isaraela i ribalau aridi eai, enaba, “Ena nige dobila esau, taiede, doha ina au lauwatai: eda eanua uauadi saesaedi emi baeki eai au usaidi, eo gamagarimiu tau wa ena ainauia au baheidi, eausi, eo amoamo, eo muramura panepanedi, eo badila adi ao labui. ");
INSERT INTO swp_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Eo moni au helabui nimamiu eai; moni wa se toreuioi emi baeki awadi eai au baheuioidi nimamiu eai, ata bena edi ponori. ");
INSERT INTO swp_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Emi tau hinage au woeai, au torohai, au uio tau wa arinai. ");
INSERT INTO swp_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Eo Eaubada Gigibori‐aririna i nuatoatoaimiu tau wa matana eai, abo emi tau esau u hetamariuioima, eo Beniamina hinage. Ena nanatuguyao se abihaidi arigu eai, taiede, se abihaidi.” ");
INSERT INTO swp_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Abo tatao ainauia se baheidi, eo moni wa nimadi eai se helabuidi eo Beniamina hinage se woeai abo se torohai se dobi Aigupito eai abo Iosepa matana eai se toro. ");
INSERT INTO swp_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Abo Iosepa Beniamina ie ita maenayao i ribalau ena numa tanugana arinai i ene, “Ina tatao ta abo u woeaidi egu numa eai, abo suisui au unui eo au abi nonoha, paana ina tatao ta asuasubenalai eai maeguyao abo ai aiai.” ");
INSERT INTO swp_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Abo tau wa Iosepa ena riba i lauwatai gonogonoana doha Iosepa i ribaei, eo tatao wa i woeaidi Iosepa ena numa eai. ");
INSERT INTO swp_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Tatao wa se matausi paana se heawasaedi Iosepa ena numa eai, to si ene, “Paana bagubaguna eai wa moni se toreuioidi eda baeki alodi eai, arinai se heawasaeda, bena abo ena huia i lobai abo i hegiluda, eo i auda, eo i abida ena taupaisoa, eo eda asini hinage.” ");
INSERT INTO swp_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Abo Iosepa ena numa tanuagana se hanahanau gegesina eai, abo maedi se ribariba numa dobilana eai, to si ene, ");
INSERT INTO swp_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Mamohoi taubada e, huia bagubaguna eai ai dobima bena aiai ai uneune, ");
INSERT INTO swp_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Abo ie tubu huiana eai wa aie lage aba‐aieawasi numana eai eo ema baeki ai soedi wa, gamagarimai, ema moni ai lobaidi ema baeki awadi eai, ema moni porohedi maudoidi arinai ai baheiuioidi nimamai eai. ");
INSERT INTO swp_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Arinai moni headi ai abidima nimamai eai aiai aba uneune. Nige abina ai ata eai ema moni i toreuioidi ema baeki alodi eai.” ");
INSERT INTO swp_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Arinai i ene, “Abo roni enamiu, tabu au matausi; emi Eaubada, tamamiu ena Eaubada, gogo wa ie tore emi baeki eai; emi moni ea abiyao.” Abo Simiona i woealaei aridi eai. ");
INSERT INTO swp_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Tau wa i laedi Iosepa ena numa eai, goila ie ledu enadi aedi aba deuridi. Abo edi asini hinage i heaidi. ");
INSERT INTO swp_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","To edi ainauia se nonohai Iosepa enana abo asubena‐lai eai i laoma. Paana se ataiei abo nei eai se aiai. ");
INSERT INTO swp_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Huiana eai wa Iosepa i awasae ena numa eai ainauia wa enana se bahei se leama numa eai abo se tabaohu tano eai ia matana eai. ");
INSERT INTO swp_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Abo i hesioedi i ene, “Edohamiu? Tamamiu i lolo, tautaubada wa wasana lahinai au heribagu wa? Ia sora ma miana?” ");
INSERT INTO swp_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","To se heuio si ene, “Tamamai, em heaheari tauna, amnana se lolo, ia sora ma miana.” Abo se duludobi ia matana eai se tabaohui. ");
INSERT INTO swp_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Abo matana i helabaisinidi ena tau Beniamina ie ita, sinana tahunuana natuna, to i ene, “Ina emi goloa ede e nige’e, wasana au heribagu wa?” Abo i ene, “Natugu e, Eaubada ena abilolo abo oa arim eai.” ");
INSERT INTO swp_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Arinai Iosepa i heura, bili i pesagabaei paana nuana ie lau ena tau arinai, to abadoudou i eooi. Arinai i awasae ena bili eai eo nei eai matasuluna se didi. ");
INSERT INTO swp_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Abo matana i deuri, ie pesa, i abididiniuioi, i ene, “Aiai au suasua.” ");
INSERT INTO swp_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Abo iabom ana se sua hesuala, eo isi isibom adi, abo Aigupito tataodi adi, isi maedi se aiaigogo, paana Aigupito tataodi nige maediyao Heberu tataodi se aiai esega, paana laulau me i baaea ariri Aigupito tataodi matadi eai. ");
INSERT INTO swp_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Abo se bawa matana eai, edi labasidi eai se heaigonogonoaiedi, taubaguna i lau e tau murita, abo tatao wa se haimatainoino, eo se no’o. ");
INSERT INTO swp_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Abo Iosepa wa, aiai wa se tore ia matana eai, tupona ie abi i hetamarilaei aridi eai, na Beniamina ana i helai ma haligigi, nige doha headi. Abo maedi se ainom eo se kode. ");
INSERT INTO swp_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Abo ena numa tauitawataina i lauhesom i ene, “Tatao edi baeki aiai arinai u hemonaudi, bena se monau komakomani, eo hinage tatao gamagaridi edi moni abo u toredi edi baeki awadi eai, ");
INSERT INTO swp_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Abo egu bia, bia silver lolo aririna tau murita ena baeki awana eai u tore, eo sitona monina hinage.” Eo ia Iosepa ena riba i lauwatai. ");
INSERT INTO swp_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Mara i uiari tatao wa se hetamaridi edi asini maediyao. ");
INSERT INTO swp_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Eanua edi huia pesagabaena, na sora nige se sigilau, Iosepa i ribalau ena numa tanuagana arinai i ene, “U toro, u torohai, tatao wa u hemuriwataidi, eo ena u lagetawaidi abo u ribalau aridi eai doha ina, ‘Paana saha lolo au hemaisa baaea arinai? Paana saha egu bia silver au aiyahari? ");
INSERT INTO swp_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ina ta ede agu tanuaga ena aba nomnom saesaena eo arinai hinage maraitom asubena saha ena bena i tubu abo arinai i nuatulobai. Mamohoi baaea lailai au ginauri!’” ");
INSERT INTO swp_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","To numa tanuaga wa i lagetawaidi, abo ina riba ta i heribadi. ");
INSERT INTO swp_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Abo si ene, “Paana saha egu guiau ina riba ta i ribaedi? Taba nige em heaheari tataodi doha ina se ginauri, nige ariariri. ");
INSERT INTO swp_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","U ita, moni wa ai lobaidi ema baeki awadi eai Kanana tanona eai ai uioidima, edohana abo em guiau ena numa eai ginauri silver eo gold ai aiyaharidi? ");
INSERT INTO swp_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ena em heaheari tauna esau arinai se lobai, i lolo abo i mate, na ai headi abo ai hemala egu guiau ena tatao auaudi.” ");
INSERT INTO swp_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Abo i ene, “I lolo emi riba ta lauwataidi, ia arinai bia wa se lobai abo egu heaheari tauna, na omi headi nige ami gilu.” ");
INSERT INTO swp_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Tatao gamagaridi edi baeki se toredobei heuraidi tano eai eo esau to esau ena baeki ie soe. ");
INSERT INTO swp_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Abo ie eo’o taubaguna arinai i hetubu ie dobi e taumurita arinai, to bia wa se lobai Beniamina ena baeki eai. ");
INSERT INTO swp_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","To adi lulu se purisidi, eo tatao gamagaridi se aiusauio esau esau edi asini potadi eai, abo se uio eanua eai. ");
INSERT INTO swp_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Abo Iuda maena tataoyao se laoma Iosepa ena numa eai na ia sora nei eai, to se gurisalaoba tano eai ia matana eai. ");
INSERT INTO swp_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","To Iosepa i ribalau aridi eai i ene, “Ina saha au ginauri? Nige abina au ata esau doha eau abo ginauri eamueamuidi ea nuatulobaidi?” ");
INSERT INTO swp_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Abo Iuda i ene, “Edohana abo ai ribalau egu guiau arim eai? Abo saha ai ribaei? Edohana abo ai hedudulaiuioimai oa matam eai? Ina em heaheari tataomai Eaubada ema baaea i hemasarahadi. U itamai, egu guiau ena heaheari tataomai, ai, eo hinage ia wa ena baeki wa alona eai bia se lobai?” ");
INSERT INTO swp_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Abo i ene, “Taba nige ariariri doha meta, na tau wa ia nimana eai bia ta se lobai, ia abo egu heaheari tauna, na omi ma nua tarumiu abo au uio tamamiu arinai.” ");
INSERT INTO swp_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Abo Iuda i hanahanau ia arinai, i ene, “O egu guiau e, em heaheari tauna i aiboda bena riba esau ea ribaei egu guiau beana eai, eo tabu nuam i alasi em heaheari tauna arinai; paana oa gonogonoana doha Parao. ");
INSERT INTO swp_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Egu guiau i hesiolaoma ena heaheari tataodi aridi eai, i ene, ‘Tamamiu e nige’e? Emi tau e nige’e?’ ");
INSERT INTO swp_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Abo egu guiau ai heriba ai ene, ‘Mamohoi ai tamamai, i tautaubada, eo ema taumurita ena huia tautaubada eai natuna gagirina. Ena tau hinage ie mate, na iabom ie mia sinana wa enana, eo tamana i gadosisie’. ");
INSERT INTO swp_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Abo em heaheari tataodi u heribadi, ‘Au dobeyama arigu eai bena abo matagu eai ea ita.’ ");
INSERT INTO swp_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","To egu guiau ai heriba, ‘Gama wa taba nige tamana i laugabaei, paana ena tamana i laugabaei abo tamana i mate.’ ");
INSERT INTO swp_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Abo oa em heaheari tataodi u heribadi, ‘Ena ami taumurita nige maemiu au dobima taba nige matagu au itauioi.’ ");
INSERT INTO swp_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Huiana wa aie lage em heaheari tauna tamamai arinai, egu guiau ena riba ai heribayao. ");
INSERT INTO swp_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Abo tamamai i ene, ‘Au dobiuio aiai ada begana au uneune.’ ");
INSERT INTO swp_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","To ai ene, ‘Taba nige ai dobi. Ena ama taumurita maemai abo ai dobi, paana taba nige tau wa ana ao ai ita ena ama taumurita nige maemai.’ ");
INSERT INTO swp_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Abo tamamai em heaheari tauna, i ribalaoma arinai eai i ene, ‘Abina au ata’o, monegu nanatuguyao labui i labasidi enaguyao; ");
INSERT INTO swp_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","esau i laugabaegu, to ea’ne nuana se purisigorigoriyao, eo nige ea itauioi. ");
INSERT INTO swp_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ena ina natugu ta hinage au abihai arigu eai eo baaea i hearo, abo ma hougu, eo ma dougu, au woeadobegu mate dimona eai.’ ");
INSERT INTO swp_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Arinai taba nige ea lage tamamai, em heaheari tauna, arinai ena gama wa nige maemai, paana ia ena mauri, eo gama wa ena mauri se auesegaidi. ");
INSERT INTO swp_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Abo i tubu doha ina, ena i ita gama wa nige maemai abo i mate, eo ai, em heaheari tataomai abo tamamai, em heaheari tauna, ma houna eo ma douna abo ai woeadobei mate dimona eai. ");
INSERT INTO swp_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Paana eau, em heaheari tauna, gama porohena ea bahei tamagu arinai, ea heriba ea’ne, ‘Ena nige ea woeauioiyama arim eai abo giruna ea bahei tamagu matana eai i lau e nige mosina.’ ");
INSERT INTO swp_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Arinai ea awanorilaowa bena em heaheari tauna i bawa gama wa helaudamaina bena egu guiau ena tauauau. Hewari ta ena tataoyao abo i hemuriwataidi. ");
INSERT INTO swp_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Paana edohana abo ea uio tamagu arinai ena gama wa nige maegu? Ata matagu eai ina iwala ta tamagu i hearo.” ");
INSERT INTO swp_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Abo nige gonoana bena Iosepa i abididiniuioi, isi gamagaridi tautorotoro gegesina eai matadi eai, to i eoga lailai, i ene, “Tatao gamagarimiu au pesagabaegu!” Arinai nige tau esau maena, abo Iosepa i hemasarahauioi ena tataoyao aridi eai. ");
INSERT INTO swp_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Abo i dou lailai, to Aigupito tataodi, eo Parao ena numa tataodi se ataiei. ");
INSERT INTO swp_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Abo Iosepa i ribalau ena tataoyao aridi eai, i ene, “Eau Iosepa! Tamagu sora ma miana?” Na ena tataoyao nige abina se ata se heuio paana se tagugu ma matausidi ia matana eai. ");
INSERT INTO swp_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Abo Iosepa i ribalau ena tataoyao aridi eai, i ene, “Ea aibodaimiu, au laoma gegesigu eai.” To se hanahanau arinai. Abo i ene, “Eau emi tau Iosepa, ia au uneune Aigupito aridi eai wa. ");
INSERT INTO swp_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Na tabu au nuadubu, eo tabu au ouyalayalauioimiu paana au uneuneguma inai, na Eaubada ia i hetamariguma inai bena abo ea hemaurimiu. ");
INSERT INTO swp_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ina borimai labui boeadi eai guriam lailai eanua eai hinage sora borimai haligigi se laolaoma boeadi eai taba nige tano giarina, eo taba nige masurina. ");
INSERT INTO swp_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Arinai Eaubada i hetamariguma bena omi eo ami isimurita au maumauri tanoubu eai, eo omi ea hemaurimiu abo au hemala basileia lailaina. ");
INSERT INTO swp_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Arinai omi nige au hetamariguma inai, na Eaubada mo, abo ia i hetorogu ea hemala Parao tamana, eo hinage ena numa guiauna, eo Aigupito eanuana maudoina eau tanuagana. ");
INSERT INTO swp_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Au heula au sae tamagu arinai abo au heriba au ene, ‘Doha ina natum Iosepa ie riba. Eaubada i hetorogu Aigupito maudoina guiauna; u dobima arigu eai, tabu u bebeda. ");
INSERT INTO swp_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Abo Gosena tanona eai au mia, abo oa gegesigu eai, oa eo nanatumyao, eo tubumyao, eo em mamoe eawoidi, em bulumakau, eo em ginauri gamagamagaridi. ");
INSERT INTO swp_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Abo nei eai ea heaim, paana borimai haligigi se ota boeadi eai guriam abo i laulau, ata oa, eo em numa tataodi, eo em ginauri gamagaridi deha lailai au hearo.’ ");
INSERT INTO swp_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Na mamohoi, matamiu eai au ita, eo egu tau Beniamina matana eai, hinage ie ita, ia ede eau awagu eai ea ribalaowa, ");
INSERT INTO swp_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Egu namanamari maudoina Aigupito eai wasana abo tamagu au heriba, eo saha eo saha inai aue ita; eo abo au heula tamagu au woeadobeyama inai.” ");
INSERT INTO swp_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Abo ena tau Beniamina i heaitalagadoi, ie dou, eo Beniamina hinage ia i heaitalagadoi eo ie dou arinai. ");
INSERT INTO swp_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Abo hinage ena tataoyao gamagaridi i alagoiedi eo matasuluna ie didi potadi eai: abo murina eai ena tataoyao maena se ribariba. ");
INSERT INTO swp_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ginauri ta wasadi se lage Parao ena numa eai, si ene, “Iosepa ena tataoyao se laoma’o,” abo Parao nuana i lolo ariri, maena heaheari tataodi hinage. ");
INSERT INTO swp_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Abo Parao i ribalau Iosepa arinai i ene, “Doha ina abo em tatayao u heribadi. ‘Ina doha au lauwatai, emi ginauri au usaidi emi asini potadi eai, eo au torohai au lau Kanana tanona eai. ");
INSERT INTO swp_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Tamamiu eo emi numa tataodi au abidi, eo au uioma arigu eai abo Aigupito tanona ena lolo aririna abo ea leawa, eo tanona aiaina lolona abo au ai. ");
INSERT INTO swp_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Abo au lauhesomdi, ‘Ina doha au lauwatai. Aigupito eanuana ena carts au abidi au laedi, nanatumiuyao gagiridi eo monemiuyao enadi, abo tamamiu au woeaiyama eo au laoma. ");
INSERT INTO swp_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Hinage tabu omi emi ginauri au nuatuda’oiedi, paana Aigupito tanona ena lolo maudoina ede omi enamiu.’” ");
INSERT INTO swp_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Arinai Isaraela nanatunayao se lauwatai, abo Iosepa carts i mosei aridi eai, gonogonoana doha Parao ena lauhesom, eo edi dobila alaena hinage i mosedi. ");
INSERT INTO swp_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Esau to esau ana lulu headi i mosedi aridi eai, na Beniamina arinai moni silver gamagarina handere haiona i mosedi, eo lulu haligigi hinage. ");
INSERT INTO swp_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Abo tamana arinai doha ina i hetamarilaei, asini saudoudoi, potadi eai Aigupito ena ginauri lolodi i usaidi, eo asini bawesinadi saudoudoi potadi eai sitona eo falawa eo hinage aiai headi tamana ena dobila alaena. ");
INSERT INTO swp_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Arinai ena tataoyao i hetamaridi se lau: abo doha ina i heribadi, “Au komakomanimiu, tabu dobila eai au lulu.” ");
INSERT INTO swp_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Aigupito se torohaigabaei se laoma Kanana dimona eai, tamadi Iakobo arinai. ");
INSERT INTO swp_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Abo se heriba si ene, “Iosepa sora ma miana, eo ia Aigupito eanuana maudoina i tanuagai.” To Iakobo aruana ie loi, paana nige i awamamohoiedi. ");
INSERT INTO swp_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Na huiana wa Iosepa ena riba gamagaridi se heriba, ia i heribadi wa, eo ena carts wa i itadi, iaede Iosepa i hetamarilaedi Iakobo ababaheina, arinai Iakobo earuana i uioma, i mauriuio. ");
INSERT INTO swp_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Abo Isaraela i ene, “Gonoana, natugu tau Iosepa sora ma miana. Abo ea lau ea ita, murina eai abo ea mate.” ");
INSERT INTO swp_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Isaraela ena lauwasi arinai i torohai, maena ginauri gamagaridi, abo i lagema Biera‐siba eai, nei eai hinage aitalasam i gabudi tamana Isaako ena Eaubada arinai. ");
INSERT INTO swp_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Abo maiona eai Eaubada i taumasaraha Isaraela arinai, i ribalau i ene, “Iakobo, Iakobo!” To i ene, “Eau ede ina.” ");
INSERT INTO swp_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Arinai i ene, “Eau Eaubada ede, tamam ena Eaubada, Tabu dobi Aigupito u matausiei, paana nei eai abo am boga ea helaiaririei. ");
INSERT INTO swp_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Eau maem abo ta dobi Aigupito eai abo mamohoi hinage ea woeaseuioema, eo em huia mate eai abo Iosepa nimana matam i gududi.” ");
INSERT INTO swp_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Arinai Iakobo Biera‐siba i torohaigabaei, abo Isaraela nanatunayao tamadi Iakobo se bahei, eo nanatudiyao gagiridi eo monediyao carts eai, Parao i mosedi wa, alodi eai. ");
INSERT INTO swp_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Eo edi suisui, eo edi ginauri gamagaridi se abidi Kanana tanona eai, abo se laoma Aigupito eai, Iakobo maena tumanayao gamagaridi. ");
INSERT INTO swp_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Nanatunayao tatao, eo isi hinage nanatudiyao tatao, nanatunayao sisine eo isi hinage nanatudiyao sisine, ana isimurita gamagamagaridi maenayao i woealaedi Aigupito eai. ");
INSERT INTO swp_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Isaraela ana isimurita, isi wa se lau Aigupito eai, esadi ede ina, Iakobo ma nanatunayao tatao: Reubena, Iakobo ena ealahou tau. ");
INSERT INTO swp_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Reubena nanatunayao tatao: Hanoka eo Palu, Heserona eo Kami. ");
INSERT INTO swp_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simiona nanatunayao tatao: Iemuela, Iamina, Ohada, Iakina, Sohara eo Saulo ia Kanana sinena esau natuna tau. ");
INSERT INTO swp_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi nanatunayao tatao: Geresona, Kohata eo Merari. ");
INSERT INTO swp_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Abo Iuda nanatunayao tatao: Era eo Onani, Sela, Paresi eo Seraha, na Era eo Onani Kanana tanona eai se lautom. Eo Paresi nanatunayao tatao ede: Heserona eo Hamula. ");
INSERT INTO swp_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakara nanatunayao tatao: Tola eo Puwa, Iobu eo Simirona. ");
INSERT INTO swp_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulona nanatunayao tatao: Seredi, Elona eo Ialele. ");
INSERT INTO swp_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Lea nanatunayao tatao Iakobo arinai i labasidi Padana‐arama eai ma natuna sine Daina, nanatunayao tatao eo nanatunayao sisine, ma tubunayao gamagaridi tau‐esega‐i‐mate‐saudoudoi‐haiona. ");
INSERT INTO swp_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gada nanatunayao tatao: Sipioni eo Hagi, Suni, Esiboni, Eri, Arodi eo Areli. ");
INSERT INTO swp_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asa nanatunayao tatao: Imina eo Isua, Isui, eo Beria, eo loudi Sera. Eo Beria nanatunayao Hebera eo Malikiela. ");
INSERT INTO swp_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Isi ede Silepa nanatunayao, Labana wa i moseyao Lea natuna sine arinai, eo nanatunayao saudoudoi‐haligigi‐esega i labasidi Iakobo arinai. ");
INSERT INTO swp_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Rahela, Iakobo monena, nanatunayao labui, Iosepa eo Beniamina. ");
INSERT INTO swp_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Iosepa arinai, ia Aigupito eai, nanatunayao tatao labui, Manase eo Eparaima, Asenati i labasidi, ia Potipera, Ona ena kohena, natuna sine. ");
INSERT INTO swp_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Abo Beniamina nanatunayao tatao: Bela eo Besa, Asabela, Gera, Neamani, Eli eo Rosa, Mupima eo Hupima eo Ade. ");
INSERT INTO swp_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Isi gamagaridi Rahela nanatunayao tatao i labasidi Iakobo arinai, gamagaridi saudoudoi‐hasi. ");
INSERT INTO swp_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dani natuna tau ede Husima. ");
INSERT INTO swp_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Napatali nanatunayao tatao: Iasele, Guni, Iesera, eo Silema. ");
INSERT INTO swp_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Bilaha hinage nanatunayao tatao: Labana wa i mosei natuna sine Rahela arinai. Iakobo arinai i labasidi, tatao gamagaridi haligigi‐labui. ");
INSERT INTO swp_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Abo dodoga gamagaridi Iakobo maena se lau Aigupito eai, ia i hetubudi wa, nanatunayao tatao monediyao nige se hasiri esegaidi, isi gamagaridi tatao‐haiona‐se‐mate‐haligigi‐esega. ");
INSERT INTO swp_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Abo Iosepa nanatunayao tatao ia arinai se labasidi Aigupito eai, dodoga labui. Arinai Iakobo ena numa tataodi gamagaridi se laoma Aigupito eai isi ede tatao‐haiona‐se‐mate‐saudoudoi. ");
INSERT INTO swp_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Iuda i hetamari matana eai Iosepa arinai bena Gosena dobilana i heita, to se laoma Gosena tanona eai. ");
INSERT INTO swp_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Abo Iosepa ena kariota i henonoha, eo ie sae Gosena eai tamana Isaraela bena i hailobai, i soralau ie matana, eai; abo ie haitalagadoi, eo gadona eai i doudou huia lohaloha. ");
INSERT INTO swp_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Abo Isaraela i ribalau Iosepa arinai i ene, “Gonoana wauta taba ea mate paana am ao ea itayao oa ma miam.” ");
INSERT INTO swp_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Abo Iosepa i ribalau ena tataoyao eo ena numa tataodi aridi eai, i ene, “Abo ea sae emi wasa ea mosei Parao arinai, doha ina abo ea heriba, ‘Egu tataoyao eo tamagu ena numa tataodi, isi nabada Kanana tanona eai wa, se laoma arigu eai. ");
INSERT INTO swp_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Tatao wa mamoe tauitawataidi, paana isi kamanidi adi paisoa suisui se suisuidi, arinai edi mamoe eawoidi eo edi bulumakau eo edi ginauri gamagaridi se abidima.’ ");
INSERT INTO swp_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ena Parao i eogaimiu i hesioemiu, ‘Ami paisoa saha?’ ");
INSERT INTO swp_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Abo au ene, ‘Ai em heaheari tataomai ama paisoa ede suisui ai suidi ema hewari huiana i laoma e wauta, ai eo hinage tamamaiyao.’ Doha ina abo Gosena tanona au abi omi enamiu, paana suisui tauitawata isi ede tatao biibiidi Aigupito tataodi matadi eai.” ");
INSERT INTO swp_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Abotai Iosepa i laoma Parao arinai i heriba i ene, “Tamagu eo egu tataoyao, edi mamoe, edi bulumakau, eo edi ginauri gamagaridi maediyao Kanana tanona se torohaigabaeyama, aboina se lage Gosena tanona eai.” ");
INSERT INTO swp_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Arinai ena tataoyao boeadi eai haligigi i abidi i hemasarahadi Parao matana eai. ");
INSERT INTO swp_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Abo Parao i ribalau ena tataoyao aridi eai i ene, “Ami paisoa saha?” To Parao se heriba si ene, “Ai em heaheari tataomai, ai suisui tauitawataidi ede, ai, eo tamamaiyao hinage.” ");
INSERT INTO swp_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Doha ina hinage Parao se heriba, “Ai laoma bena abo ai mia ina eanua eai ta, paana em heaheari tataodi edi suisui nige edi aba‐aibai, paana guriam i lai ariri Kanana tanona eai, arinai bena ai aibodalaowa abo em heaheari tataodi se miamia Gosena tanona eai.” ");
INSERT INTO swp_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Parao i ribalau Iosepa arinai i ene, “Tamam eo em tataoyao se laoma arim eai. ");
INSERT INTO swp_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Aigupito tanona maudoina oa matam eai, haedi tano lolo aririna nei eai abo tamam eo em tataoyao se mia: Gosena tanona eai abo se mia eo hinage ena boeadi eai tatao sibasibadi, isi abo u hetorodi egu suisui tauitawataidi.” ");
INSERT INTO swp_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Abo Iosepa tamana Iakobo i heawasae i woeai Parao matana eai, eo Iakobo Parao i ribahelolo. ");
INSERT INTO swp_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Parao i ribalau Iakobo arinai, i ene, “Em borimai hisa?” ");
INSERT INTO swp_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","To Iakobo i ribalau Parao arinai i ene, “Egu sae egu dobi borimaidi ede handere esega, eo tau‐esega‐i‐mate‐saudoudoi. Egu borimai asubenadi nige se gamagari, eo se baaea, eo sora nige ea lage tamaguyao edi sae edi dobi borimaidi aridi eai.” ");
INSERT INTO swp_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Abo Iakobo Parao i ribahelolo eo Parao matana i pesagabaei. ");
INSERT INTO swp_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Iosepa tamana eo ena tataoyao i hemiadi, edi tano i mosei aridi eai Aigupito tanana eai, tano lolo aririna eai, Ramese tanona eai doha Parao i lauhesom. ");
INSERT INTO swp_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Eo Iosepa aiai i mosei tamana eo ena tataoyao, eo tamana ena numa tataodi aridi eai, i he’ona gonogonoadi. ");
INSERT INTO swp_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Na nige begana aiai eanua boeana eai paana guriam i lai ariariri, to Aigupito eanuana maudoina, eo Kanana dimona eai, tatao se beruberu guriam wa debana eai. ");
INSERT INTO swp_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Abo Iosepa moni gamagaridi se lobaidi Aigupito eai eo Kanana eai i tanogogoidi, ia ede sitona wa maisana, to moni i laei Parao ena numa eai. ");
INSERT INTO swp_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Huiana ne arinai moni ie ohi ariri Aigupito eo Kanana eanuadi eai, Aigupito tataodi se laoma Iosepa arinai si ene, “Aiai u leama: paana saha oa matam eai abo ai mate? Ema moni i ohi ariri.” ");
INSERT INTO swp_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Abo Iosepa i ene, “Emi suisui au ledima abo helaudamaidi aiai ea lediwa, ena emi moni se ohi.” ");
INSERT INTO swp_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","To edi suisui se laedi Iosepa arinai, abo aiai i mosedi, hosi eo mamoe eo bulumakau eo asini helaudamaidi, abo borimai me aiaina i mosei edi suisui helaudamaidi. ");
INSERT INTO swp_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Borimai me ie ohi, abo borimai helabuina eai se laoma arinai si ene, “Taba nige ai toreyamui egu guiau arim eai, ema moni se ohi, eo egu guiau ema suisui oa u abidio, nige begana saha ie ota egu guiau matana eai, na taumai mo, eo hinage ema tano. ");
INSERT INTO swp_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Paana saha abo ai mate oa matam eai, ai eo ema tano hinage? Ai, eo ema tano u unehaimai aiai helaudamaidi, abo ai eo ema tano ai hemala Parao ena heaheari: eo lie hinage u leama, arinai abo ai mauri, taba nige ai mate, eo tano taba nige i hemala barabara.” ");
INSERT INTO swp_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Arinai Iosepa Aigupito tanona maudoina ie une Parao enana, paana Aigupito tataodi gamagaridi edi tano se uneunedi, paana guriam i abiaririedi. Arinai Aigupito tanona maudoina i hemala Parao enana. ");
INSERT INTO swp_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Abo tatao gamagaridi se hemala tauau’au tataodi Aigupito sigasigana esau eai, i lau e sigasigana esau eai. ");
INSERT INTO swp_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Na kohena isibom edi tano nige i unehaidi, paana kohena edi maisa Parao i mosei, eo arinai se aiai, arinai edi tano wa nige se unegabaedi. ");
INSERT INTO swp_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Abo Iosepa i ribalau tatao aridi eai enaba, “Aue ita wauta omi ea unehaimiu, eo emi tano ea unehaidi Parao enana. Ina emi lie ede, abo tano eai au umaidi. ");
INSERT INTO swp_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ena masuri huiana abo aiai wa lausoisoina hehaligigina au mosei Parao ana, na lausoisoidi hasi abo ami bena o ea liena, eo ami aiai, eo emi numa tataodi adi, eo nanatumiuyao gagiridi adi.” ");
INSERT INTO swp_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Abo si ene, “Mate eai u hemaurimai, nualolo bena ai lobai oa matam eai abo ai hemala Parao ena heaheari tataomai.” ");
INSERT INTO swp_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Arinai laugagaeo Iosepa i hetoro, Aigupito eanuana enana laugagaeo wa ie ota i laoma e wauta, ia ede sitona lausoisoina hehaligigina abo Parao enana. Na kohena tataodi edi tano isibom nige se hemala Parao enanayao. ");
INSERT INTO swp_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Abo Isaraela tataodi Aigupito tanona eai se mia, Gosena dimona eai, abo nei eai edi gogo se hegamagariaririedi, eo se tadada eo se hegamagariaririedi. ");
INSERT INTO swp_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Iakobo Aigupito eanuana eai ie mia borimai saudoudoi‐haligigi‐labui, abo ena borimai gamagaridi handere‐esega‐tatao‐labui‐se‐mate haligigi‐labui. ");
INSERT INTO swp_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Eo Isaraela ena mate huiana i hanahanaui to natuna Iosepa i eogai, i ribalau arinai enaba, “Ena nuam i lolo arigu eai ea aibodaim bena nimam u torelaei gotugu ubuna eai, eo em abiabi arigu eai bena mamohoina eo i lolo: tabu Aigupito eai u toregu. ");
INSERT INTO swp_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Tamaguyao boeadi eai abo ea eno: Aigupito eai abo u bahelaegu, isi ede aba toredi eai abo u toregu.” To i heuio, “Em riba abo ea lauwatai.” ");
INSERT INTO swp_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Eo i ene, “U riba aigora arigu eai.” Arinai i riba aigora. Eo Isaraela ena aba‐eno gegesina eai i tabaohu. ");
INSERT INTO swp_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Eawalana ie lau, esau Iosepa i heriba i ene, “Tamam i asiebo.” Arinai nanatunayao labui Manase eo Eparaima i woeaidi maenayao. ");
INSERT INTO swp_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Abo esau Iakobo i heriba, “Natum tau Iosepa i laolaoma.” Arinai Isaraela i headidiriuioi, eo ie bawa aba‐eno potana eai. ");
INSERT INTO swp_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Iakobo hinage i ribalau Iosepa arinai enaba, “Eaubada Gigibori‐aririna i taumasaraha arigu eai Lusa eai, Kanana tanona eai, eo i ribahelologu, ");
INSERT INTO swp_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","hinage i ribalaoma arigu eai i ene, ‘Mamohoi abo uauam ea helai eo ea hegamagari, eo arim eai tatao moutuana lailai: ina eanua ta abo ea mosei am isimurita enadi i lau e nige nosina.’ ");
INSERT INTO swp_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Abo nanatumyao tatao labui Eparaima eo Manase, Aigupito eai se labasidi enam sora nige ea laoma Aigupito eai, isi abo enaguyao. Gonogonoana doha Reubena eo Simiona isi hinage enaguyao. ");
INSERT INTO swp_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Murina eai nanatumyao headi u abidi, isi abo enamyao abo edi tataoyao esadi u torelaei aridi eai, eo maraitom asubena edi gogo hinage. ");
INSERT INTO swp_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Na eau mo, huiana wa Padana eai ea laoma, Rahela i odalele gegesigu eai Kanana dimona eai, Eparata hanahanauna eai, abo nei eai ea tore, Eparata, ia ede Betelehema, dobilana eai.” ");
INSERT INTO swp_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Abo Isaraela Iosepa nanatunayao i itadi i ene, “Isi ede aidimodi?” ");
INSERT INTO swp_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Iosepa i ribalau tamana arinai enaba, “Isi ede nanatuguyao tatao, aridi eai Eaubada i ainauiaigu ina eanua eai ta.” To i ene, “U woeaidima abo ea ribahelolodi.” ");
INSERT INTO swp_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Na Isaraela matana se gaugau paana i tautaubadao, to nige i ita komakomani. Arinai Iosepa i woeaidi ia gegesina eai, abo i alagoiedi eo i haitalagadoidi. ");
INSERT INTO swp_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Abo Isaraela i ribalau Iosepa arinai i ene, “Nige abina ea ata abo am ao ea itauioi, na Eaubada nanatumyao hinage i heitagu.” ");
INSERT INTO swp_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Arinai Iosepa i abihaidi nuanuana eai, eo i duludobi, ana ao ie dobi tano eai. ");
INSERT INTO swp_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Eo Iosepa i abilabuiedi, Eparaima nima tutuna eai ie abi i torelaei Isaraela tupo seuseurina eai, abo Manase ie abi nima seuseurina eai ie tore Isaraela tupo tutuna eai, i woeaidi gegesina eai. ");
INSERT INTO swp_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Abo Isaraela nima tutuna i helele i torelaei Eparaima uruna eai, ia tau murita wa, eo nima seuseurina ie tore Manase uruna eai, i nuatu dudulai arinai doha meta nimana i toredi, paana Manase ia taubaguna. ");
INSERT INTO swp_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Iosepa hinage i ribahelolo, i ene, “Eaubada, ia matana eai tamaguyao Aberahama eo Isaako se laulau, eo Eaubada ia i heaigu egu mauri huiana eai i laoma e ina asubena ta, ");
INSERT INTO swp_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Aneru wa ia baaea maudoina eai i abihemaurigu, ina merumeru ta i helolodi; esagu eo tamaguyao Aberahama eo Isaako esadi abo enadi; eo abo se hemala moutuana lailai tanoubu eai ta.” ");
INSERT INTO swp_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Huiana eai wa Iosepa ie ita tamana nimatutuna i toresae Eparaima uruna eai, nuana i hebaaea to i abihai abo i torelaei Manase uruna eai. ");
INSERT INTO swp_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Abo Iosepa i ribalau tamana arinai, i ene, “Tamagu, taba nige doha meta paana ina ealahou tau ede; nimatutum u torelaei ia uruna eai.” ");
INSERT INTO swp_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Na tamana i otaota i ene, “Abina ea atao, natugu, abina ea atao, ia hinage abo i hemala boga lailai, eo ia hinage abo ie sae; na mamohoi ana taumurita abo i sae ariri, eo pesipesinayao abo se hemala basileia gamagamagaridi.” ");
INSERT INTO swp_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Nei asubenana ne i ribahelolodi i ene, “Omi esamiu eai abo Isaraela tataodi se ribahelolodi si ene, ‘Eaubada i hetoromiu doha Eparaima eo Manase’”; arinai Eparaima i hebaguna, eo Manase i hemurita. ");
INSERT INTO swp_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Abo Isaraela Iosepa arinai enaba, “Egu mate i hanahanauma, na Eaubada abo maem, eo abo i woeauioim tamamyao edi tano eai. ");
INSERT INTO swp_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Hinage em tataoyao nige enadi, na oa mo arim eai oea esau ea ainauiaim, Amore tataodi aridi eai ea girihai egu alahia eo egu pidu aridi eai.” ");
INSERT INTO swp_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Iakobo nanatunayao tatao i eogaidi, i ene, “Au laomagogo, na maraitom asubena saha abo i tubu ea heribamiu. ");
INSERT INTO swp_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Au laomagogo au ataatai, omi Iakobo nanatunayao tatao, au ataatailau tamamiu Isaraela arinai. ");
INSERT INTO swp_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Reubena, oa egu ealahou tau, egu gigibori, eo egu adidiri aba‐hetubuna, bena nua sibasiba eo gigibori saesaedi oa enam. ");
INSERT INTO swp_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Na oa doha goila i butubutu, arinai taba nige u sae paana u awasae tamam ena aba‐eno eai; u hebii, — u soralau eau egu aba‐eno eai! ");
INSERT INTO swp_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simiona eo Levi maena tau gonogonoadi, edi alahia aridi eai baaea lailai se ginauridi. ");
INSERT INTO swp_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","O nuagu e, tabu u soralau edi aba‐riba eamueamui eai; O nuagu dudulaina e, tabu u patulau edi oigogo aridi eai; paana edi ouyalayala eai tatao se unuidi, eo edi nuatuuioidi eai bulumakau se hebaaeadi. ");
INSERT INTO swp_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Edi ouyalayala u hebaaea paana i didiga ariri; eo edi nuayalayala paana edi heamamna ie dio! Arinai abo ea tomgorigoridi Iakobo boeana eai, eo ea hetatagorigoridi Isaraela eai, ");
INSERT INTO swp_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Na oa Iuda, em tataoyao abo se hedebasaem, nimam abo u torelaei am waiunu gadodi eai; eo tamam nanatunayao abo se tabaohu oa matam eai. ");
INSERT INTO swp_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Iuda doha liona natuna; doha liona ana anihu se gamagari oa abo u sae, natugu, i aiyawasi, i otadobi doha liona tautaubadana; ena eno eai eai abo i hanoi? ");
INSERT INTO swp_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Wasawasa tu’ena taba nige Iuda arinai se laeihesuara, eo taba nige tanuaga tu’ena aena duaduaridi eai se abihai i lau e tanuagana i laoma, eo ia abo tatao gamagaridi se awaabiei. ");
INSERT INTO swp_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ena asini natuharihariuna abo i au vine eai, asini natuna wa ie au vine lolo ariaririna eai, ana lulu abo i deuridi waina eai, eo ena oma i heaadi vine uauana osinana eai. ");
INSERT INTO swp_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Matana se namanamari ariri nige doha waina, eo moana se posiposi ariri nige doha susu. ");
INSERT INTO swp_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulona ena aba‐mia ede gabogabo hasarina eai, abo ena tupo eai waga edi gadoa lolo, eo tanona sigasigana eai Sidona eai. ");
INSERT INTO swp_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakara doha asini adiadidirina, mamoe ganadi boeadi eai i otadobi; ");
INSERT INTO swp_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ie ita aiyawasi i lolo eo tano hinage i lolo; arinai dabayarona i dobei, eo i hemala heaheari tauna takisi tau torena. ");
INSERT INTO swp_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dani abo ena tataoyao i hedudulaidi doha Isaraela ana bodao headi. ");
INSERT INTO swp_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dani doha mota dobila eai, doha mota aiailetana abalau eai. Hosi aena i letaidi arinai taugeruna ie beu. ");
INSERT INTO swp_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","O GUIAU e, em abihemauri ea bagibagiei! ");
INSERT INTO swp_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gada ana waiunu abo se laoma se ialai, na ia abo murina eai i saetawatawaidi. ");
INSERT INTO swp_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asa abo i masuri, wasawasa ana aiai abo i ginauridi. ");
INSERT INTO swp_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Napatali ia suisui bawesinana yaiyairihaina nanatunayao abo se lolo ariri. ");
INSERT INTO swp_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Iosepa laga anianiona, laga anianiona goila bunabunawasina gegesina eai; laganayao se dausae gana potana eai. ");
INSERT INTO swp_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Pidu tautuna se hebaaea aririei, se tulau arinai paana se hewaiunuei; ");
INSERT INTO swp_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Na ia ena pidu i adidiri esegai, paana Iakobo ena Eaubada Gigiborina ia nimana eai (Mamoe Tauitawataina esana eai, ia Isaraela ena We’utau.) ");
INSERT INTO swp_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Tamam ena Eaubada ia tausaguim ede, eo Eaubada Giribori‐aririna ia abo i ainauiaim galewa ewana eai ena lolo aridi eai, eo gabogabo ubu eai ena lolo eo susu eo boga edi lolo hinage. ");
INSERT INTO swp_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Tamam ena ribahelolo se sae ariri tamaguyao edi ribahelolo se saepoidi, eo se ota esegaidi doha oea tupidi i lau e nige nosina; ribahelolo ta abo Iosepa uruna eai, ia debana eai se abihesuara ena tataoyao aridi eai. ");
INSERT INTO swp_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Beniamina abo i guriam doha luko, maratomtom eai abo suisui ie dom, eo maiona eai waiunu edi gogo i soiedi.” ");
INSERT INTO swp_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Isi ede Isaraela ana bogao saudoudoi‐labui, doha ina tamadi i ribalau aridi eai, eo i ribahelolodi, esau esau ena ribahelolo. ");
INSERT INTO swp_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Abo i lauhesomdi, i heribadi, “Nige baeaona abo u laegu tamaguyao aridi eai wa, Eperona, Hito tauna ena tano eai, ");
INSERT INTO swp_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Ia ede duha wa Makepela tanona eai, Mamare tupo mahana ena aba‐dalasae eai, Kanana tanona eai, iaede Aberahama i uneyao ma tanona Eperona Hito tauna arinai bena ena aba‐toretoretau. ");
INSERT INTO swp_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Nei eai Aberahama ma monena Saraha se toredi, nei eai Isaako ma monena Rebeka se toredi, nei eai hinage Lea ea totore. ");
INSERT INTO swp_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Duha ma tanona se uneyao Hito tataodi aridi eai.” ");
INSERT INTO swp_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Abo huiana wa Iakobo nanatunayao tatao i lauhesomdi ana sigana eai, aena i abisinidi aba‐eno potana eai, eawasina ie ohi, i tubahai, se laei ehanayao aridi eai. ");
INSERT INTO swp_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Iosepa i guridobi tamana matana eai, matasuluna se didi potana eai eo i alagoiei. ");
INSERT INTO swp_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Arinai Iosepa ena heaheari i lauhesomdi isi sinare taumuramura, bena tamana se he’eausi, arinai Isaraela se he’eausi. ");
INSERT INTO swp_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Asubena tatao‐labui‐se‐mate se ohi, ia enana iaede sinare he’eausina huiana dudulaina; eo Aigupito tataodi se dou asubena tatao‐haiona‐se‐mate eo saudoudoi. ");
INSERT INTO swp_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ena dou asubenadi se ohi, Iosepa i ribalau Parao ena numa tataodi aridi eai, i ene, “Ena nuamiu se lolo arigu eai doha ina abo Parao au heriba au ene: ");
INSERT INTO swp_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Tamagu i he’aigoragu i ene, “Nige baaeaona abo ea mate; egu bousa ea sara nonohaiyao Kanana tanona eai, abo nei eai au toregu.” Ea aiboda abo u abigabaegu ea sae tamagu ea tore, na abo ea uioma.’” ");
INSERT INTO swp_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Abo Parao i ene, “U sae tamam u tore gonogonoana doha em riba aigora arinai.” ");
INSERT INTO swp_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Arinai Iosepa ie sae tamana ie tore, maenayao Parao ena heaheari tataodi gamagaridi, eo ena numa tataodi saesaedi, eo Aigupito eanuana ena tanutanuaga gamagaridi. ");
INSERT INTO swp_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Eo Iosepa ana bogaoyao, eo ena tataoyao, eo tamana ena numa tataodi: nanatudiyao gagiridi isibom, eo edi mamoe, eo edi bulumakau se laugabaedi Gosena tanona eai. ");
INSERT INTO swp_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Maena kariota eo hosi taugerudi se sae, to boda wa i lai ariri. ");
INSERT INTO swp_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Se lage Atadi ena sitona aba‐giligilina eai, Ioridana tupo saesae eai, abo nei eai se doudou, se dou lailai ma nua amamnadi, eo asubena haligigi‐labui boeadi eai tamana i douei. ");
INSERT INTO swp_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Huiana wa Kanana tataodi, nei eanua ne taumiaidi, dou lailai wa se ita, Atadi ena sitona aba‐giligilina eai, si ene, “Ina dou ta i lai ariri Aigupito tataodi aridi eai.” Arinai tupo ne esana se tore Abela‐misiraime, ia ede Ioridana tupo dobidobina eai. ");
INSERT INTO swp_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Hinage Iakobo nanatunayao ena lauhesom aridi eai se awa’abiei. ");
INSERT INTO swp_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Nanatunayao tatao ia se laei Kanana tanona eai, se tore duha eai wa Makepela eai, Mamare tupo mahana ena aba dalasae eai, Kanana tanona eai, iaede Aberahama i uneyao ma tanona Eperona Hito tauna arinai bena ena aba toretoretau. ");
INSERT INTO swp_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Tamana ie tore murina eai Iosepa i uio Aigupito eai, maena tataoyao, eo isi gamagaridi maenayao se sae bena tamana se tore. ");
INSERT INTO swp_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Huiana Iosepa ena tataoyao se ita tamadi ie mate si ene, “Nuana abo Iosepa i hewaiunueda, abo i hemaisada baaea wa ta ginauri ia arinai debana eai.” ");
INSERT INTO swp_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Arinai heaheari esau se hetamarilaei Iosepa arinai, si ene, “Tamam sora nige i lautom ie riba doha ina, ");
INSERT INTO swp_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Abo au ribalau Iosepa arinai doha ina, “Em tataoyao edi baaea, eo edi ponori bena u ribagigiridi, paana mamohoi se abibaaeaim.” ’ Ai awanorilaowa tamada ena Eaubada ena heaheari tataodi edi baaea bena u ribagigiridi.” Doha ina se ribalau arinai, abo Iosepa matasuluna se didi. ");
INSERT INTO swp_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Abo ena tataoyao se lau se guridobi ia matana eai si ene, “U itamai ai em heaheari tataomai!” ");
INSERT INTO swp_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Arinai Iosepa i ene, “Tabu au matausi. Eau Eaubada ena aba‐toro eai? ");
INSERT INTO swp_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Mamohoi, omi mo nuatu hebaaeagu au nuatui, na Eaubada ena nuatu lolona mo, bena abo tatao gamagaridi i abihemauridi doha isi ede asubena ta. ");
INSERT INTO swp_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Tabu au matausi: omi ma nanatumiuyao abo ea he’aimiu.” Ina riba ta aridi eai nuadi i headidiridi eo nuadi i hebigadi. ");
INSERT INTO swp_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Iosepa ie mia Aigupito eai, ia eo tamana ena numa tataodi. Iosepa ena mauri borimaidi handere esega eo saudoudoi. ");
INSERT INTO swp_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Iosepa Eparaima nanatunayao, isi haiona i itadi; Manase hinage natuna tau Makira nanatunayao se tubusae Iosepa aena paana eai. ");
INSERT INTO swp_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Abo Iosepa i ribalau ena tataoyao aridi eai i ene, “Abo ea lautom, na Eaubada mamohoi abo i nuatuimiu, abo eanua eai ta i woeahaimiu eanua esau arinai, ena riba aigora wa Aberahama eo Isaako eo Iakobo aridi eai.” ");
INSERT INTO swp_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Iosepa hinage Isaraela tataodi i he’aigoradi i ene, “Abo Eaubada i nuatuimiu, eo siadagu abo au bahelaedi.” ");
INSERT INTO swp_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Abo Iosepa i tubahai, ena borimai handere esega eo saudoudoi, arinai se he’eausi, abo lasi esau alona eai se tore Aigupito eai. ");
INSERT INTO swp_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Isaraela nanatunayao tatao isi se laoma Aigupito eai Iakobo maedi, edi numa tataodi hinage maediyao, esadi ede ina: ");
INSERT INTO swp_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reubena, Simiona, Levi eo Iuda, ");
INSERT INTO swp_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakara, Sebulona eo Beniamina. ");
INSERT INTO swp_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dani eo Napatali, Gada eo Asa. ");
INSERT INTO swp_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Iakobo ana isimurita gamagaridi tatao‐haiona‐se‐mate‐saudoudoi: Iosepa ia i laoma nonohao Aigupito eai. ");
INSERT INTO swp_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Abo Iosepa ie mate ena tataoyao maenayao, eo ana isi gamagaridi. ");
INSERT INTO swp_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Na Isaraela ana isi murita se ua eo se tadada ariri; se tubu lailai eo se tubu adiadidiri, i lau e eanua se hemonau. ");
INSERT INTO swp_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Abotai Aigupito ena wasawasa harihariuna i toro, ia Iosepa nige i nuatui. ");
INSERT INTO swp_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ia i ribalau ena tatao aridi eai i ene, “Au ita, Isaraela nanatunayao se gamagari ariri eo se adidiri, ita nige doha. ");
INSERT INTO swp_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","I lolo isi edi tupo eai ta sanasanapu, ata se gamagari ariri, eo ena iala i hearoda ada waiunu se patalau aridi eai eo se ialaida, abo eda eanua se dagogabaei.” ");
INSERT INTO swp_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Arinai edi paisoa tauitawataidi se hetorodi abo se haemamnadi paisoa poroporohedi aridi eai: eo Parao ana aiai abapeigogo eanuadi se hetorodi, Pitomi eo Ramese. ");
INSERT INTO swp_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Na se heamamanada’oiedi, se gamagarida’oi, eo eanua se laugirihai. To Aigupito tataodi se nuabaaea, eo se matausi ariri Isaraela tataodi debadi eai. ");
INSERT INTO swp_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Arinai Isaraela tataodi adi paisoa se he’oiura aririei; ");
INSERT INTO swp_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Edi mauri se hekarapi paisoa pilipilina arinai, poahu eo brick paisoana, eo oea paisoadi udoi udoi aridi eai hinage: adi paisoa gamagaridi aridi eai wa se heporohe aririedi. ");
INSERT INTO swp_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Abo Aigupito edi wasawasa i ribalau Heberu edi tauabihelabalaba sisinedi aridi eai, esau esana Siparaha, esau esana Puaha, ");
INSERT INTO swp_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","I ene, “Ena Heberu sisinedi au abi‐helabalabadi, eo esau au ita abalabalaba hatana potana eai, ena tau ie abi abo au unui, na ena sine abo i mia.” ");
INSERT INTO swp_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Na tauabihelabalaba sisinedi Eaubada se matausiei, eo Aigupito wasawasana ena lauhesom nige se awaabiei, na merumeru tatao se hemauridi mo. ");
INSERT INTO swp_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","To Aigupito edi wasawasa tauabihelabalaba sisinedi i eogaidi i ribalau aridi eai i ene, “Paana saha doha ina au ginauri, na merumeru tatao au hemauridi?” ");
INSERT INTO swp_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Helabalaba sisinedi wa se ribalau Parao arinai si ene, “Paana Heberu sisinedi isi nige doha Aigupito sisinedi: paana se adidiri ariri, na sora nige tauabihelabalaba ie lage, na nanatudiyao se abidio.” ");
INSERT INTO swp_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","To Eaubada tauabihelabalaba sisinedi i abi komakomanidi, eo tatao wa se gamagari ariri, eo se tubu adidiri ariariri. ");
INSERT INTO swp_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Paana Eaubada se matausiei arinai tauabihelabalaba sisinedi isi hinage nanatudiyao i mosedi. ");
INSERT INTO swp_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","To Parao ena tatao gamagaridi i lauhesomdi i ene, “Heberu tataodi nanatudiyao tatao gamagaridi se labasidi abo au gabalaedi saga eai, na nanatudiyao sisine abo se mia.” ");
INSERT INTO swp_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Levi numana tauna esau monena ie hai ia Levi natuna sine esau. ");
INSERT INTO swp_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Sine wa i boga’o abo natuna tau i labasi, to huiana wa ie ita ana ao i lolo ariri, arinai i toreamui nawarai haiona. ");
INSERT INTO swp_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","I lau e nige gonoana bena i toreamuida’oiei to bosa esau i haturi leiaha arinai, abo tar arinai ie pati. Murina eai merumeru wa alona eai i he’eno, eo ie tore saga lagaudi boeadi eai, saga hasarina eai. ");
INSERT INTO swp_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Abo louna hanahanauna eai i totoro bena abina i ata abo saha i tubu arinai. ");
INSERT INTO swp_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Nige baeaona Parao natuna sine i dobima saga eai bena abo i aiduidui, eo ena heaheari sisinedi saga laopana eai se tautausi; bosa wa ie ita saga lagaudi boeadi eai, to ena heaheari sinena i hetamari ie abi ");
INSERT INTO swp_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Huiana wa ie so’e kaimou wa ie ita, to i doudou, arinai i nuatoatoaei, i ene, “Ina Heberu esau natuna!” ");
INSERT INTO swp_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Abo louna i ribalau Parao natuna sine arinai, enaba, “Taba ea lau Heberu sinena hesuhesusuna esau ea eogaiyama. Abo kaimou i hesusu oa enam?” ");
INSERT INTO swp_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Parao natuna i ene, “U lau,” to siu wa ie lau merumeru sinana i eogai. ");
INSERT INTO swp_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Abo Parao natuna sine i ribalau arinai i ene, “Merumeru ta u laei u hesusu eau enagu, abo maisana ea leawa.” To sine wa merumeru ie abi i hesusu. ");
INSERT INTO swp_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Merumeru hinage i tubusae, abo i leama Parao natuna sine arinai eo i hemala ia natuna. Esana hinage ie tore Mose, i ene, “Paana goila eai ea abisini.” ");
INSERT INTO swp_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Asubena esau, huiana wa Mose i lailaio ie pesa ie lau ena tataoyao aridi eai, eo adi bahebahe poroporohedi i itadi; abo Aigupito tauna esau ie ita Heberu tauna, ana boga tahunuana esau, i pidili. ");
INSERT INTO swp_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","I itasae, i itadobi, nige doga esau ie ita, arinai Aigupito tauna i eatu’unui, eo gelegele eai i toreamui. ");
INSERT INTO swp_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Asubena helabuina eai ie pesa ie lau, abo Heberu tataodi labui i itadi se haipoipoi, to i ribalau aisega tau i ponori wa arinai, i ene, “Paana saha em doga u laulubini?” ");
INSERT INTO swp_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ia i heuio i ene, “Eai i heterom ama tanuaga, e tau hedudulaimai? Em nuatu bena u unuigu doha Aigupito tauna ue unui, wa?” Abo Mose i matausi, eo i nuanuatu, “Omihede ginauri wa abina se ata’o.” ");
INSERT INTO swp_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Huiana wa Parao wasana i ataiei i aipate bena Mose i unui. Na Mose Parao i dagogabaei abo Midiani eanuana eai ie mia. Abo goila huana gegesina eai i bawadobi. ");
INSERT INTO swp_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Na Midiani edi kohena nanatunayao sisine haligigi‐labui se laoma se goila oi, eo aba‐nom se hemonaudi bena tamadi ena mamoe eawoidi goila se henomdi. ");
INSERT INTO swp_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Mamoe tauitawataidi se laoma se aihenauidi, na Mose i toro i saguidi, eo edi mamoe eawoidi goila i henomdi. ");
INSERT INTO swp_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Huiana wa se lage tamadi Reuela arinai i ene, “Edohana to wau au heurama?” ");
INSERT INTO swp_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Si ene, “Aigupito tauna esau mamoe tauitawataidi nimadi eai i lebohaimai, abo hinage goila ie oi, eo mamoe eawoina i henom.” ");
INSERT INTO swp_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","I ribalau nanatunayao hasahasaradi aridi ea i ene, “Ia haedi eai? Paana saha au laugabaei? Au eogaiyama abo falawa i ai.” ");
INSERT INTO swp_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Abo Mose nuana ie taru bena tau wa arinai i mia: abo natuna Sipora i mosei Mose arinai. ");
INSERT INTO swp_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Natuna tau i labasi, abo esana ie tore Geresoma, paana enaba, “Eau laolaoma tauna eanua udoi eai.” ");
INSERT INTO swp_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Borimai gamagari se lao’o na Aigupito ena wasawasa i mate’o, eo Isaraela tataodi se dou ariri edi auau debadi eai, eo se eoga lailai bena tausaguidi, abo edi lepalepa edi auau wa debadi eai se lage Eaubada arinai. ");
INSERT INTO swp_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Abo Eaubada edi lepalepa i ataiei, eo Eaubada ena ribahesunuma i henuaisini, Aberahama eo Isaako eo Iakobo aridi eai. ");
INSERT INTO swp_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Abo Eaubada Isaraela tataodi i itadi, eo hinage i nuanuatuidi. ");
INSERT INTO swp_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mose bosiana Ietero, Midiani edi kohena wa ena mamoe i itawataidi: to mamoe wa i woealaedi barabara tupo ealasi eai, eo i laoma Horeba eai, Eaubada ena oea tupina wa. ");
INSERT INTO swp_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Eo GUIAU ena aneru i taumasaraha ia arinai doha oeagi balelemna oeagi gagirina esau boeana eai, to i italau ie ita na oeagi wa i ala’ala na nige i alaheohi. ");
INSERT INTO swp_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Abo Mose i ene, “Besi ea utugesi ina ginauri lailaina ta bena ea ita, paana saha oeagi gagirina wa nige i alaheohi.” ");
INSERT INTO swp_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Huiana wa GUIAU ie ita i utu gesilau bena i aiewai oeagi boeana eai, Eaubada i eogalau ia arinai i ene, “Mose! Mose!” Abo i ene, “Eau ede ina.” ");
INSERT INTO swp_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Abotai i ene, “Tabu u hanahanauma, em aeum aem eai u abihaidi paana dimo wa potana eai u totoro me tano tabuna ede.” ");
INSERT INTO swp_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","To i ene, “Eau tamam ena Eaubada, Aberahama ena Eaubada, Isaako ena Eaubada, eo Iakobo ena Eaubada.” Abo Mose matana i buburi, paana i matausi, ata Eaubada i ita. ");
INSERT INTO swp_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Arinai GUIAU i ene, “Egu tatao Aigupito eai edi amamna ea itayao, eo edi lepalepa adi paisoa tanuagadiyao debadi eai ea ataiedio: edi nuadubu abina ea ata’o. ");
INSERT INTO swp_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ea laoma Aigupito tataodi nimadi eai bena ea lebohaidi, eo eanua eai ne bena abo arinai ea woeahaidi, eanua esau lolona magamagagana arinai eanua masumasurina; Kanana eo Hito eo, Amore, eo Perisi, eo Hiwi ea Iebusi tataodi edi eanua arinai. ");
INSERT INTO swp_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","U ita, Isaraela tataodi edi lepalepa i laoma arigu eai; eo edi amamna arinai Aigupito tataodi se heamamnadi ea itayao. ");
INSERT INTO swp_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Arinai u laoma, abo ea hetamarim Parao arinai bena egu tatao, Isaraela nanatunayao, abo Aigupito eai u woeahaidi.” ");
INSERT INTO swp_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Na Mose i ribalau Eaubada arinai i ene, “Eau ede eai bena abo ea lau Parao arinai, eo Isaraela nanatunayao Aigupito eai ea woeahaidi?” ");
INSERT INTO swp_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Eaubada i ene, “Mamohoi Eau abo maem; na ina ta abo em heiheinoi ia ede eai ea hetamarim: ena tatao wa Aigupito eai u woeahaidi, ina oea tupina ta arinai abo Eaubada au heayaiyei.” ");
INSERT INTO swp_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Abo Mose i ribalau Eaubada arinai i ene, “U ita ena ea laoma Isaraela tataodi aridi eai ea ribalau aridi eai ea’ne, ‘Tamamiuyao edi Eaubada i hetamariguma arimiu eai,’ abo se ribalaoma si ene, ‘Esana ede eai?’ abo saha ea heribadi?” ");
INSERT INTO swp_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Abo Eaubada i ribalau Mose arinai i ene, “EAU EDE EAU.” I ene, “Ina doha abo u ribalau Isaraela tataodi aridi eai, EAU EDE i hetamariguma arimiu eai.” ");
INSERT INTO swp_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Eaubada hinage i ribalau Mose arinai i ene, “Doha ina abo u ribalau Isaraela tataodi aridi eai, ‘GUIAU, tamamiuyao edi Eaubada, Aberahama ena Eaubada, Isaako ena Eaubada eo Iakobo ena Eaubada, ia i hetamariguma arimiu eai.’ Ina abo esagu i lau e nige nosina, eo ina esa ta arinai abo isi gamagamagari se nuanuatuigu. ");
INSERT INTO swp_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","U lau Isaraela tataodi edi babadayao u heoigogoidi u ribalau aridi eai, u ene, ‘GUIAU tamamiuyao edi Eaubada eo Aberahama ena Eaubada, Isaako ena Eaubada, eo Iakobo ena Eaubada, i taumasaraha arigu eai, i ene, “Ea nuanuatuimiu eo saha eo saha se ginauri arimiu eai Aigupito eai ea itayao: ");
INSERT INTO swp_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ea ribahesunuma Aigupito ena amamna aridi eai abo ea woeahaimiu, Kanana, Hito, Amore, Perisi, Hiwi eo Iebusi tataodi edi eanua arinai; eanua wa i masuri ariariri.’” ");
INSERT INTO swp_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Abo arinam se ataiei, oa eo Isaraela babadadi abo au lau Aigupito ena wasawasa arinai doha ina abo au heriba au ene, ‘GUIAU, Heberu tataodi edi Eaubada, maemai ai hailobai; arinai ai aibodalaowa bena u eairigabaemai abo ai lau asubena haiona lauwasina barabara eai, abo aitalasam ai gabudi GUIAU ema Eaubada arinai.’ ");
INSERT INTO swp_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Eau abina ea ata’o Aigupito ena wasawasa taba nige i eairigabaemiu taba se dudu mo nima gigiborina eai, ");
INSERT INTO swp_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","arinai abo nimagu ea helelelaei, abo Aigupito ea pidili egu laulau gigiboridi gamagaridi ea ginauridi aridi eai; ina ta murina eai abo i eairigabaemiu. ");
INSERT INTO swp_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Eo ina tatao ta Aigupito tataodi matadi eai henualolo abo ea leawa, arinai emi huia torohai eai taba nige ma nima’aha’ahamiu. ");
INSERT INTO swp_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Na sisine gamagaridi helena taumia tauna arinai, e sine esau ena numa arinai ie mia arinai, pasa silver eo gold abo se sagenaidi, eo lulu, abo aridi eai nanatumiuyao tatao eo sisinedi au heluidi. Aigupito tataodi edi ginauri lolo dumadumadi abo au girihaidi.” ");
INSERT INTO swp_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Abo Mose i heuoi i ene, “Na u ita, taba nige se awamamohoiegu, eo arinagu taba nige se ataiei: paana abo si ene, ‘GUIAU nige i taumasaraha arim eai.’” ");
INSERT INTO swp_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","To GUIAU i ribalau arinai i ene, “Meta me aisana nimam eai?” Eo i ene, “Tu’e.” ");
INSERT INTO swp_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","I ene, “U gabadobei tano eai,” to i gabadobei i hemala mota, eo Mose i dagogabaei. ");
INSERT INTO swp_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Abo GUIAU i ribalau Mose arinai i ene, “Nimam u helelelaei delena eai u abilau.” Arinai nimana i helelelaei i abilau, eo i hemala tu’euio nimana eai. ");
INSERT INTO swp_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“Bena tatao se awamamohoi GUIAU, tamadiyao edi Eaubada, Aberahama ena Eaubada, Isaako ena Eaubada, Iakobo ena Eaubada ia ede i taumasaraha arim eai.” ");
INSERT INTO swp_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","GUIAU hinage i ribauio arinai e ene, “Nimam u torelaei nuapoum eai.” To nimana i torelaei nuapouna eai, eo murina eai i abihai, abo ie ita nimana i lepela, i posiposi, i posiposi doha snow. ");
INSERT INTO swp_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Abo i ene, “Hage u toreuioi nuapoum eai.” Nimana ie toreuio nuapouna eai, abo i abihaiuioi ie ita, ana ao i abiuioi doha buluma mamohoina. ");
INSERT INTO swp_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","“Arinai, ena nige se awamamohiem eo heiheinoi bagubagunana nige se awamamohoiei, heiheinoi helabuina arinai abo se awamamohoiei. ");
INSERT INTO swp_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ena ina heiheinoi labui ta nige se awamamohoiedi, eo em riba nige se ataiei, abo goila saga eai u abi, eo u hegoilaei tano pitapitalina potana eai: abo goila wa saga eai ue abi wa abo i hemala osina tano pitapitalina potana eai.” ");
INSERT INTO swp_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Mose i ribalau GUIAU arinai i ene, “O Guiau e, eau nige tauribasibasiba, huia bagubagunana eai nige’e eo huiana wa u ribalaoma em heaheari arinai nige’e, na eau ea bebeda ribariba arinai eo memenagu i porohe.” ");
INSERT INTO swp_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Eo GUIAU i ribalau arinai, i ene, “Eai tau awana i ginauri? Eai tauuna’una, e taudo’odo’o, e taumatalala, eo tau matagibugibu i ginauridi? Iaede eau GUIAU e nige’e? ");
INSERT INTO swp_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Arinai abo u torohai, eau abo ea hemala awam eo saha ea heatam abo u ribaei.” ");
INSERT INTO swp_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Na i ene, “O Guiau e, ea aibodaim, taba doga esau u hetamari.” ");
INSERT INTO swp_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Abo GUIAU ena ouyalayala i lai ariri Mose arinai eo i ene, “Em tau Arona, Levi tauna, metai e nige: e? Abina ea ata i riba lolo. U ita, i laolaoma i hailobaim eo ena i itam abo i kode ariri. ");
INSERT INTO swp_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Abo u ribalau arinai, eo hinage abo riba u toredi awana eai. Eau abo ea hemala awam, eo ia awana, eo saha eo saha bena au ginauri abo ea heatamiu. ");
INSERT INTO swp_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ia abo i ribalau tatao aridi eai, ia abo awam, oa hinage abo ia arinai doha Eaubada. ");
INSERT INTO swp_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Nimam eai ina tu’e ta u abi abo arinai wau heiheinoi wa abo u ginauridi.” ");
INSERT INTO swp_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mose i uio Ietero, bosiana wa, arinai, i ribalau arinai, enaba, “Taba u earigabaegu ea uio ehaguyao Aigupito eai aridi eai, bena ea itadi, sora ma miadi, eo nige’e?” To Ietero i ribalau Mose arinai i ene, “U lau ma nuatarum.” ");
INSERT INTO swp_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Eo GUIAU i ribalau Mose arinai Midiani eai, i ene, “U uio Aigupito eai, paana tatao wa em mauri bena se helautom, wa, se mateo.” ");
INSERT INTO swp_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Arinai Mose monena ea nanatunayao tatao i abidi i hebawadi asini potadi eai, eo ie uio Aigupito tanona eai: eo Eaubada ena tu’e Mose ie abi nimana eai. ");
INSERT INTO swp_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","GUIAU hinage i ribalau Mose arinai i ene, “Ena u uio Aigupito eai abo laulau gigiboridi gamagaridi nimam eai ea toredi wa abo u ginauridi Parao matana eai: na nuana abo ea heoiura, taba nige tatao wa i eairigabaedi. ");
INSERT INTO swp_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Abo Parao u heriba, ‘GUIAU i ribaei i ene, Isaraela ede egu ealahou tau. ");
INSERT INTO swp_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","To ea heribamo, “Natugu tau u abigabaei, bena abo i heayaiyegu” na ena u nuahi, tabu i lau, u ita, abo natum tau em ealahou abo hinage ea unui’.” ");
INSERT INTO swp_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Abo ena aba aiyawasi dimona dobilana eai GUIAU Mose i hailobai, bena i unui. ");
INSERT INTO swp_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Abo Sipora sapaila ie abi, natuna tau i heperitome eo bulumana opina i gabalaei Mose aena eai, i ene, “Mamohoi, eau arigu eai, oa osinam monegu.” ");
INSERT INTO swp_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Arinai Eaubada Mose i abigabaei, na Sipora i ene, “Oa osinam monegu, heperitome debana eai.” ");
INSERT INTO swp_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","GUIAU i ribalau Arona arinai i ene, “U torohai u lau barabara eai Mose u hailobai.” To ie lau i hailobai Eaubada ena oea tupina eai, abo i alagoiei. ");
INSERT INTO swp_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Mose, GUIAU ena riba gamagaridi i mosei ia arinai eo heiheinoi gamagaridi i lauhesom bena i ginauridi wa, Arona i heriba. ");
INSERT INTO swp_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Abo Mose eo Arona se lau Isaraela edi babadayao gamagaridi se heoigogoidi, ");
INSERT INTO swp_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","eo GUIAU ena riba gamagaridi i ribaedi Mose arinai, Arona i ribaedi aridi eai, eo laulau gigiboridi gamagaridi hinage tatao matadi eai i ginauridi. ");
INSERT INTO swp_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Tatao hinage se awamamohoiei: huiana wa se ataiei GUIAU Isaraela tataodi i nuatuidi, eo edi amamna ie ita, se dulu dobi eo se aihelahui. ");
INSERT INTO swp_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Murina eai Mose eo Arona se laoma se ribalau Parao arinai si ene, “Doha ina GUIAU, Isaraela ena Eaubada i ribaei, ‘Egu tatao u abigabaedi abo barabara eai mataasi si ginauri enagu’” ");
INSERT INTO swp_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Na Parao i ene, “GUIAU ede eai bena arinana ea awaabiei, eo Isaraela tataodi ea abigabaedi? GUIAU wa ea hekau, eo Isaraela tataodi taba nige ea abigabaedi.” ");
INSERT INTO swp_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Abo si ene, “Heberu edi Eaubada i hailobaimai: ai aibodalaowa bena u abigabaemai ai lau asubena haiona lauwasina barabara eai, abo GUIAU ema Eaubada ena aitalasam ai ginauri, ata asiebo, eo elepa aridi eai i pidilimai.” ");
INSERT INTO swp_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Aigupito ena wasawasa i ribalau Mose eo Arona aridi eai i ene, “Paana saha tatao edi paisoa arinai au laehesuaradi? Au lau emi porohe au baheidi!” ");
INSERT INTO swp_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Eo Parao i ene, “Au ita, ina huia ta, eanua tataodi se gamagari ariri, eo omi adi paisoa aridi eai au heaieawasidi!” ");
INSERT INTO swp_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Abo nei asubenana eai ne paisoa tauitawata eo adi tanutanuaga i lauhesomdi i ene: ");
INSERT INTO swp_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Tabu lagau pitapitarina au mosei tatao aridi eai doha wau au ginauri wa, bena arinai bricks se ginauridi abo se lau isibom edi lagau pitapitarina se tanogogoidi. ");
INSERT INTO swp_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Na bricks gamagarina se ginauridi wa bena gonogonoana se ginauri: tabu ena gamagari au hegagiri, paana se miamiagaibui, arinai se doulaoma si ene, ‘U abigabaemai abo ai lau ema Eaubada ena aitalasam ai gubu.’ ");
INSERT INTO swp_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Tatao adi paisoa au heporohe, arinai abo se paisoa adidiri, eo tabu riba borabora aridi eai se mode.” ");
INSERT INTO swp_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Abo tatao edi paisoa tauitawataidi maedi tanutanuaga se pesa se ribalau tatao aridi eai, si ene, “Doha ina Parao ie riba, ‘Taba nige lagau pitapitarina ea leawa. ");
INSERT INTO swp_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Au lau omibom emi lagau pitapitarina haedi au lobai abo au abi, eo ami paisoa laina taba nige i gagiri.’” ");
INSERT INTO swp_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Arinai tatao se hetatagorigoridi Aigupito boeana eai bena lagau pitapitarina se tanogogoi paana lagau nonohana wa nige’e. ");
INSERT INTO swp_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Eo paisoa tanutanuagadi se hesomdi, si ene, “Emi asubena paisoana au ginauri he’ohi gonogonoana doha taba emi lagau nonohana wa.” ");
INSERT INTO swp_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Abo Isaraela edi babada, isi Parao ena paisoa tanutanuagadi se hetorodi wa, se pidilidi, to se oimuriedi si ena, “Paana saha emi bricks gamagarina lahi eo wau nige i lage gonogonoana doha beabeana?” ");
INSERT INTO swp_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Abo Isaraela tataodi edi babada se laoma se doulau Parao arinai, si ene, “Paana saha em heaheari tataodi u abidi doha ina? ");
INSERT INTO swp_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Lagau nige se mosei em heaheari tataodi aridi eai, na se ribalaoma si ene, ‘Bricks au ginauridi,’ eo u ita em heaheari tataodi se pidilidi; na giluna ede oa eo em tatao tahunuadi aridi eai.” ");
INSERT INTO swp_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Na i ene, “Au miamiagaibu, au miamiagaibu; arinai au ene, ‘U abigabaemai ai lau ema GUIAU ena aitalasam ai ginauri.’ ");
INSERT INTO swp_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Au lau au paisoa, taba nige lagau se lediwa, na emi bricks gamagarina abo gonogonoana.” ");
INSERT INTO swp_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Arinai Isaraela edi babada se italobai huia baaea mamohoi se hearo paana si ene, “Tabu asubena esega arinai emi bricks gamagarina i gagiri.” ");
INSERT INTO swp_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Huiana eai wa Parao matana se pesagabaei Mose eo Arona se hailobaidi, isi dobila eai se totoro. ");
INSERT INTO swp_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Abo se ribalau aridi eai, si ene, “GUIAU i itamiu eo abo i heduduraimiu paana ada ao au hebaaea Parao matana eai eo ena heaheari matadi eai, eo elepa aue tore nimadi eai bena abo arinai si unuida.” ");
INSERT INTO swp_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mose hinage ie uio GUIAU arinai, i ene, “GUIAU e, paana saha tatao ta u hebaaeadi? Paana aisana u hetamariguma wa? ");
INSERT INTO swp_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Paana huiana eai wa ea laoma Parao arinai, bena oa esam eai ea ribariba, tatao ta i hebaaeadi mo, na em tatao wa nige begana u lebohaidi.” ");
INSERT INTO swp_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","GUIAU abo i ribalau Mose arinai i ene, “Sora abo u ita saha abo ea ginauri Parao arinai: paana nimana adidirina eai abo i hetamari hepesadi, mamohoi ma nima adidirina abo ena eanua eai i aiduiedi.” ");
INSERT INTO swp_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Eaubada i ribalau Mose arinai i ene, “Eau Iehowa ede. ");
INSERT INTO swp_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ea taumasaraha Aberahama arinai, eo Isaako arinai, eo Iakobo arinai, eau esagu Eaubada Gigibori‐aririna, na esagu esau, Iehowa, isi nige abina se ata. ");
INSERT INTO swp_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Egu riba hesunuma ea hetoro aridi eai, bena Kanana tanona abo ea mosedi eanua wa arinai se mialaulau wa doha laolaoma tataodi. ");
INSERT INTO swp_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Hinage Isaraela tataodi edi lepalepa ea ataiedio, isi Aigupito tataodi se audidinidi wa. Egu riba hesunuma wa ea nuanuatui. ");
INSERT INTO swp_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Arinai abo u ribalau Isaraela tataodi aridi eai, abo u ene, ‘Eau Iehowa ede, eo Aigupito edi bahebahe poroporohedi eai abo ea lebohaimiu, edi auau aridi eai abo ea eairihaimiu, nimagu gigiborina eai, eo hinage pidipidili lailaidi aridi eai abo ea hemaurimiu. ");
INSERT INTO swp_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Abo ea abimiu egu tatao, eau abo emi Eaubada: abo hinage abina au ata eau Iehowa emi Eaubada, Aigupito tataodi edi auau poroporohedi wa aridi eai eau abo ea lebohaimiu. ");
INSERT INTO swp_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Abo ea woeaimiu eanua esau arinai ia ede ea ribahesunuma wa Aberahama, Isaako, eo Iakobo aridi eai, bena abo ea mosedi. Omi hinage arimiu eai abo ea leawa enamiu: eau Iehowa ede.” ");
INSERT INTO swp_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ina doha Mose i ribalau Isaraela tataodi aridi eai, na nige se henua bena Mose se ataiei, edi nuaamamna eo edi auau poroporohedi debadi eai. ");
INSERT INTO swp_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","GUIAU i ribalau Mose arinai, i ene: ");
INSERT INTO swp_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“U awasae Parao, Aigupito wasawasana arinai, u ribalau arinai bena abo Isaraela tataodi ena eanua eai i eairigabaedi.” ");
INSERT INTO swp_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Na Mose i ribalau GUIAU arinai i ene, “U ita Isaraela tataodi egu riba nige se ataiei, arinai mamohoi abo Parao i nuatuigu, eau ma sopagu porohedi wa?” ");
INSERT INTO swp_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Na GUIAU i ribalau Mose eo Arona aridi eai abo Isaraela eo Parao, Aigupito wasawasana wa bena se lauhesomdi, abo Isaraela tataodi wa Aigupito eai se woeahaidi. ");
INSERT INTO swp_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Adi bogao babadi ede ina; Reubena, Isaraela ena ealahou, nanatunayao tatao: Hanoka, Palu, Heserona eo Kami, isi ede Reubena ana bogayao. ");
INSERT INTO swp_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simiona nanatunayao tatao; Iemuela, Iamina, Ohada, Iakina, Sohara, eo Saulo Kanana sinena natuna; isi ede Simiona boganayao. ");
INSERT INTO swp_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Levi nanatunayao tatao esadi ede ina edi huia labasi aridi eai: Geresona, eo Kohata, eo Merari: eo Levi ena borimai gamagaridi handere esega, tau‐esega‐i‐mate saudoudoi‐haligigi‐labui. ");
INSERT INTO swp_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Geresona nanatunayao tatao, Libini eo Simi, bogadiyao aridi eai. ");
INSERT INTO swp_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kohata nanatunayao tatao: Amarama eo Isahara eo Heberona eo Usieli, eo Kohata ena mauri borimaina ede handere esega tau‐esega‐i‐mate‐saudoudoi‐haiona. ");
INSERT INTO swp_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Eo Merari nanatunayao tatao, Mahali eo Musi: isi Levi nanatunayao edi isi aridi eai. ");
INSERT INTO swp_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amarama tamana louna Iokebed ie abi monena, eo Arona eo Mose arinai i labasadi; eo Amarama ena mauri borimaina ede handere esega tau‐esega‐i‐mate‐saudoudoi‐labui. ");
INSERT INTO swp_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Isahara nanatunayao tatao: Kora, Nepegi, eo Sikiri. ");
INSERT INTO swp_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Usieli nanatunayao tatao: Misaela, Elisapano, eo Sitiri. ");
INSERT INTO swp_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Arona Elisiba i tawasorai, ia Aminadaba natuna sine eo Nahasona louna. Ia arinai Nadabi, Abihu, Eleasara, eo Itimara i labasidi. ");
INSERT INTO swp_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kora nanatunayao tatao: Asira, eo Elikana, eo Abisapi; isi ede Kora tataodi adi bogaoyao. ");
INSERT INTO swp_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleasara, Arona natuna tau ia Putieli natuna sine esau i tawasorai; Piniasi i labasi arinai. Isi ede Levi tamadiyao edi babada eo adi bogao hinage. ");
INSERT INTO swp_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Isi ede Arona eo Mose aridi eai wa GUIAU i ribalau i ene, “Isaraela tataodi moutuadi Aigupito eanuana eai abo au woeahaidi, ma adiboda.” ");
INSERT INTO swp_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Isi ede se ribalau Parao, Aigupito wasawasa arinai bena Isaraela Aigupito eai se woeahaidi wa. Isi ede ina Mose eo Arona. ");
INSERT INTO swp_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Asubenana eai ne GUIAU i ribalau Mose arinai Aigupito tanona eai. ");
INSERT INTO swp_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","GUIAU i ribalau Mose arinai i ene, “Eau GUIAU ede: saha eo saha ea heribam, oa Parao, Aigupito wasawasana wa, abo u heriba.” ");
INSERT INTO swp_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Na Mose i ribalau GUIAU arinai i ene, “U ita eau sopagu se porohe, edohana abo Parao i ataiegu?” ");
INSERT INTO swp_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","GUIAU i ribalau Mose arinai i ene, “U ita, abo ea hetorom doha Eaubada Parao arinai, eo em tau Arona abo em peroweta. ");
INSERT INTO swp_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Saha eo saha ea lauhesom meta abo u heriba: eo Arona em tau abo i ribalau Parao arinai bena Isaraela tataodi ena eanua eai i eairigabaedi. ");
INSERT INTO swp_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Na Parao nuana abo ea heoiura, na egu heiheinoi eo egu laulau gigiboridi abo ea hegamagaridi Aigupito eanuana eai. ");
INSERT INTO swp_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Parao taba nige em riba i ataiei, arinai abo nimagu ea torelaei Aigupito potana eai eo egu moutuana maudoina eo egu tatao, Isaraela nanatunayao Aigupito eai abo ea woeahaidi, pidipidili aridi eai. ");
INSERT INTO swp_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Aigupito tataodi abo abina se ata eau GUIAU ede, ena nimagu ea helelelaei Aigupito potana eai eo Isaraela tataodi boeadi eai ea woeahaidi.” ");
INSERT INTO swp_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Eo Mose eo Arona se lauwatai, doha GUIAU i lauhesomdi wa se ginauri. ");
INSERT INTO swp_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Mose ena borimai tatao‐hasi‐se‐mate, eo Arona ena borimai tatao‐hasi‐se‐mate‐haiona, huiana wa se ribalau Parao arinai. ");
INSERT INTO swp_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","GUIAU hinage i ribalau Mose eo Arona aridi eai i ene, ");
INSERT INTO swp_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Ena Parao i ribalaowa i ene, ‘Em laulau gigibori esau bena ea ita’: Abo Arona u heriba u ene, ‘Em tu’e u abi eo u gabadobei Parao matana eai bena abo i hemala mota.’” ");
INSERT INTO swp_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Arinai Mose eo Arona se lau Parao arinai saha eo saha GUIAU i lauhesomdi meta wa se ginauri. Arona ena tu’e i gabadobei Parao ena heaheari matadi eai to i hemala mote. ");
INSERT INTO swp_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Abo Parao tatao sonosonogadi eo tau tabutabusima i eogaidi, isi hinage Aigupito edi tatao sonosonogadi se ginauri gonogonoana edi sonoga eamueamuidi aridi eai. ");
INSERT INTO swp_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Gamagaridi edi tu’e se gabadobei eo se hemala mota. Na Arona ena tu’e isi edi tu’e i domdi. ");
INSERT INTO swp_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Parao mo nuana i oiura esegai eo taba nige i ataieidi, gonogonoana doha GUIAU i ribaei. ");
INSERT INTO swp_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Abo GUIAU i ribalau Mose arinai i ene, “Parao nuana i oiura esegai, tatao i nuahidi, taba nige i eairigabaedi. ");
INSERT INTO swp_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Maratomtom eai abo u lau Parao arinai, ena i pesa i lau goila: saga hasarina eai abo u lau bagibagiei, eo tu’e i hemala mota wa abo u abi nimam eai. ");
INSERT INTO swp_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Abo u heriba u ene, ‘GUIAU, Heberu edi Eaubada i hetamarigu arim eai, i ene, “Egu tatao u abigabaedi abo barabara eai se heayaiyegu; eo mamohoi, nei huiana ne i laoma e wauta nige u ataiei.” ");
INSERT INTO swp_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Doha ina GUIAU i ribaei, “Ina ta arinai abo u italobai, eau GUIAU ede: tu’e ta nimagu eai abo saga goiladi ea oiitadi, abo se hemala osina, ");
INSERT INTO swp_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","eama wa saga arona eai abo se mate, saga hinage abo se boha, abo Aigupito tataodi se subu, taba nige se nom.”’” ");
INSERT INTO swp_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Abo GUIAU Mose i heriba i ene, “Abo Arona u heriba ‘Em tu’e u abi eo nimam u helelelaei Aigupito goiladi gamagaridi potadi, eai, goila lailaidi eo goila ipudi gamagaridi potadi eai, bena abo se hemala osina: Aigupito eanuana maudoina eai abo hinage osina, ledu oeagi alodi eai, eo ledu we’u alodi eai.’” ");
INSERT INTO swp_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mose eo Arona se ginauri doha GUIAU i lauhesomdi. Parao matana eai eo ena heaheari gamagaridi matadi eai ena tu’e i lausini eo goila saga eai i oi’ita, abo saga goiladi gamagaridi se hemala osina. ");
INSERT INTO swp_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Abo goila eamadi se mate, eo saga hinage panena i baaea, to Aigupito tataodi saga goilana taba nige se nom: eo osina wa Aigupito eanuana maudoina boeana eai. ");
INSERT INTO swp_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Na Aigupito tataodi edi tau tabutabusima gonogonoana se ginauri edi sonoga eamueamuidi aridi eai, to Parao nuana i heoiura eo edi riba nige i ataiei, gonogonoana doha GUIAU i ribaei. ");
INSERT INTO swp_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Abo Parao ie uio, i awasae ena numa arona eai; ginauri ta nige nuana eai i toredi. ");
INSERT INTO swp_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Abo Aigupito tataodi saga gegesina eai goila se sara bena edi aba‐nom, paana nige gonoana bena saga goilana si nom. ");
INSERT INTO swp_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","GUIAU huiana wa saga wa i oi’ita asubena harigigilabui se laoo. ");
INSERT INTO swp_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","GUIAU i ribalau Mose arinai i ene, “U awasae Parao arinai eo u ribalau arinai, ‘GUIAU i ribaei doha ina, “Egu tatao u abigabaedi bena se heayaiyegu. ");
INSERT INTO swp_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ena u nuahidi taba nige se lau, u ita em eanua maudoina abo ea hebaaea so’u aridi eai. ");
INSERT INTO swp_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","So’u abo saga se hemonaubori‐borili, abo se lusoralau em heaheari edi numa eai, eo em tatao potadi eai, em um alodi eai, eo em falawa aba helahelasa alodi eai. ");
INSERT INTO swp_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","So’u hinage abo se saema oa potam eai, eo em tatao potadi eai eo em heaheari gamagaridi potadi eai.”’” ");
INSERT INTO swp_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Abo GUIAU i ribalau Mose arinai, i ene, “Arona u heriba, ‘Nimam eai em tu’e u helelelaei goila lailaidi eo gagiridi eo ipu hinage potadi eai, eo so’u u hesomdi se laoma Aigupito eanuana potana eai.’” ");
INSERT INTO swp_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Arinai Arona nimana i helelelaei Aigupito goiladi gamagaridi potadi eai, to so’u se saema eanua se lau girihai. ");
INSERT INTO swp_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Na tau tabutabusima edi sonoga eamueamuidi aridi eai gonogonoana se ginauri, eo so’u se ledima Aigupito eanuana eai. ");
INSERT INTO swp_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Abo Parao Mose eo Arona i eogaidi i ene, “Au aibodalau GUIAU arinai abo so’u i laeihesuaradi eai arigu eai eo egu tatao aridi eai; abo tatao wa ea eairigabaedi, abo se lau se aitalasam GUIAU arinai.” ");
INSERT INTO swp_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mose i ribalau Parao arinai i ene, “I lolo abo u lauhesomgu aisega huia eai bena ea aiboda enam, eo em heaheari enadi eo em tatao enadi, abo so’u gamagaridi se unuidi se laeihesuaradi oa arim eai eo emi numa aridi eai, abo saga eai mo abo se mia?” ");
INSERT INTO swp_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","To Parao i ene, “Maraitom abo.” Mose i ene, “I lolo em riba abo se lauwatai bena abina u ata nige esau doha GUIAU ema Eaubada. ");
INSERT INTO swp_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","So’u abo se laugabaem, em numa, em heaheari eo em tatao abo se laugabaedi, saga eai mo se mia.” ");
INSERT INTO swp_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Arinai Mose eo Arona Parao se pesagabaei, eo Mose ie eoga GUIAU arinai so’u debadi eai isi i ledima wa Parao arinai. ");
INSERT INTO swp_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","GUIAU i ginauri gonogonoana doha Mose i ribaei: so’u se mate’ohi numa eai, eo murimuri eai, eo oea eai. ");
INSERT INTO swp_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Se tanogogoidi se peidi aridi eai, eo eanua panena i baaea ariri. ");
INSERT INTO swp_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Na Parao ie ita ginauri baaea ie ohi, nige eawalana, nuana i he’oiura eo edi riba taba nige i ataiedi, gonogonoana doha GUIAU i ribaei. ");
INSERT INTO swp_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Abo GUIAU Mose i heriba, i ene, “Arona u heriba ‘Em tu’e u helelelaei tano mu’amu’ana u oi’ita abo i hemala ni’ini’iri Aigupito eanuana boeana eai.’” ");
INSERT INTO swp_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Doha meta se ginauri; Arona nimana tu’e maena i helelelaei tano mu’amu’ana i oi’ita abo i hemala ni’ini’iri tatao potadi eo suisui potadi eai; tano mu’amu’ana i hemala ni’ini’iri Aigupito eanuana maudoina boeana eai. ");
INSERT INTO swp_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Na tabutabusima edi sonoga eamueamuidi aridi eai se aipate bena ni’ini’iri se hetubudi, na se aipate asa: ni’ini’iri mo se ota tatao eo suisui potadi eai. ");
INSERT INTO swp_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Abo tau tabutabusima se ribalau Parao arinai si ene, “Ina Eaubada nimagigina ede!” Na Parao nuana i heoiura aririei nige i atailau aridi eai, gonogonoana doha GUIAU i ribaei. ");
INSERT INTO swp_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Arinai GUIAU i ribalau Mose arinai i ene, “Maratomtom eai u enotoro heura abo u lau Parao matana eai u toro, ia i pesama i lau goila eai wa, eo abo u ribalau arinai u ene, ‘Doha ina GUIAU i ribaei, “Egu tatao u abigabaedi bena abo se heayaiyegu. ");
INSERT INTO swp_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Na ena egu tatao wa nige u abigabaedi abo uloulo eawoidi ea hetamaridi omi potamiu eai, em heaheari potadi eai, eo em tatao potadi eai, eo emi numa alodi eai; abo Aigupito tataodi edi numa uloulo se hemonaudi, eo edi aba‐toro tanona hinage potana eai. ");
INSERT INTO swp_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Na nei asubenana ne Gosena eanuana eai, egu tatao edi aba‐mia wa, sigasiga abo ea tore, nei eai taba nige uloulo, bena abina u ata eau GUIAU ede tanoubu boeana eai. ");
INSERT INTO swp_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Abo sigasigana ea tore egu tatao eo oa em tatao duaduaridi eai, abo maraitom ina heiheinoi ta abo i masaraha.”’” ");
INSERT INTO swp_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","GUIAU hinage i ginauri: abo uloulo eawoidi lailaidi se luhulau Parao ena numa eai eo ena heaheari numadi eai; abo Aigupito eanuana maudoina boeana eai tano ie boha uloulo eawoidi debadi eai. ");
INSERT INTO swp_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Parao Mose eo Arona i eogaidi, i ene, “Au lau eo emi Eaubada ena aitalasam au gabu ina eanua eai ta.” ");
INSERT INTO swp_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Na Mose i ene, “Meta nige i dudulai, paana suisui wa Aigupito tataodi se subuidi wa isi abo ai heaitalasamdi GUIAU ema Eaubada arinai. Ena Aigupito tataodi matadi eai aitalasam biibiidi ai gabudi abo nige se lauwe’uimai? ");
INSERT INTO swp_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Abo ai lau barabara eai asubena haiona lauwasina GUIAU ema Eaubada ena aitalasam ai gabu, doha ia i lauhesommai.” ");
INSERT INTO swp_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Arinai Parao i ene, “Abo ea eairigabaemiu au lau barabara eai GUIAU emi Eaubada arinai bena au aitalasam; ginauri esega tabu au lau eda lohaloha eai. Enagu hinage bena au aiboda.” ");
INSERT INTO swp_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Eo Mose i ene, “Abo ea torohaigabaem, na abo ea aibodalau GUIAU arinai i bena uloulo wa maraitom abo Parao eo ena heaheari eo ena tatao abo se laugabaedi; ginauri esega eda tabu Parao ena laulau boraboradi i abiuioidi tatao wa bena i nuahidi taba nige se aitalasam GUIAU arinai.” ");
INSERT INTO swp_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","To Mose Parao i pesagabaei eo GUIAU i aibodalau arinai. ");
INSERT INTO swp_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Eo GUIAU i ginauri gonogonoana doha Mose i ribaei, uloulo eawoidi i abi hesuaradi Parao ena heaheari eo ena tatao aridi eai; nige esega i ota. ");
INSERT INTO swp_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Na Parao inata arinai hinage nuana i heoiura eo tatao wa nige i abigabaedi. ");
INSERT INTO swp_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Abo GUIAU i ribalau Mose arinai i ene, ‘U awasae Parao arinai doha ina abo u heriba, ‘GUIAU, Heberu tataodi edi Eaubada, doha ina i ribaei, “Egu tatao u abigabaedi bena abo se heayaiyegu. ");
INSERT INTO swp_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ena u nuahidi taba nige se lau, sora u abididinidi, ");
INSERT INTO swp_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","u ita GUIAU nimana abo i torelaei em suisui oea eai potadi eai, asini potadi eai kamela potadi eai eo mamoe potadi eai, iwala lailai abo se hearo. ");
INSERT INTO swp_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Na GUIAU abo i hineri Isaraela edi suisui eo Aigupito edi suisui boeadi eai, eo Isaraela enadi taba nige esau i mate.”’” ");
INSERT INTO swp_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","To GUIAU huia wa ie tore i ene, “Maraitom GUIAU ginauri wa abo i ginauri eanua boeana eai.” ");
INSERT INTO swp_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Maraitom GUIAU ginauri wa i ginauri, eo Aigupito ena suisui gamagaridi se mate: na Isaraela tataodi edi suisui boeadi eai nige esau i mate. ");
INSERT INTO swp_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Abo Parao i lauhetamari bena abina i ata, na, mamohoi, Isaraela edi suisui boeadi eai nige esau i mate. Parao mo nuana i heoiura, tatao taba nige i abigabaedi. ");
INSERT INTO swp_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","GUIAU i ribalau Mose eo Arona aridi eai, i ene, “Ginaha nimagogodi au abidi brick aba‐gabudi eai, eo Mose abo i gabasaei galewa eai Parao matana eai. ");
INSERT INTO swp_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Abo i hemala mu’amu’a gagairidi Aigupito eanuana maudoina boeana eai, hinage bonusinibu abo i malapai doha bonu tatao eo suisui potadi eai, Aigupito eanauana maudoina boeana eai. ");
INSERT INTO swp_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Arinai ginaha kiln wa arinai se abidi, eo se torolau Parao matana eai: eo Mose i gabasaedi galewa eai, to i hemala bonusinibu i malapai doha bonu tatao eo suisui potadi eai. ");
INSERT INTO swp_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Eo nige gonoana bena tau tabutabusima se toro Mose matana eai, paana bonu sinibu wa tau tabutabusima wa potadi eai eo Aigupito tataodi, gamagaridi potadi eai. ");
INSERT INTO swp_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Na GUIAU Parao nuana i he’oiura, eo taba nige i ataiedi gonogonoana doha GUIAU Mose i heriba wa. ");
INSERT INTO swp_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Abotai GUIAU i ribalau Mose arinai i ene, “Maratomtom eai u enotoro heura, abo u torolau Parao matana eai, abo u ribalau arinai, u ene, ‘Doha ina GUIAU Heberu tataodi edi Eaubada i ribaei, “Egu tatao u abigabaedi bena se heayaiyegu. ");
INSERT INTO swp_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Paana ina huia ta egu iwala gamagaridi abo ea hetamaridi oa potam eai, bena abo abina u ata tanoubu maudoina boeana eai nige esau doha eau. ");
INSERT INTO swp_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Paana gonoagu taba nimagu ea heleleleawa, abo oa eo em tatao ea oi’itamiu iwala arinai, eo tanoubu au mategabaei. ");
INSERT INTO swp_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Na ina nuatu ta debana eai ea abihemaurim, bena egu gigibori ea hemasaraha arim eai, eo abo esagu se wasaduaiei tanoubu maudoina boeana eai. ");
INSERT INTO swp_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Sora u hedebasaeuioim, eo egu tatao u hewaiunuedi arinai taba nige u abigabaedi? ");
INSERT INTO swp_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","U ita, maraitom, mahana sorasorana doha inata, abo nabu tupitupidi lailai dididigadi ea hetarudi, nige huia esau Aigupito eai doha nei, huia hetubuna eai i laoma e huia ta. ");
INSERT INTO swp_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Arinai u lauhetamari, se heura suisui se woeaidima, eo em ginauri gamagaridi oea eai hinage: paana tatao eo suisui gamagaridi se lobaidi oea eai eo nige se ledima numa eai, nabu tupitupidi wa abo i lubidi eo abo se mate.”’” ");
INSERT INTO swp_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Eai Parao ena heaheari boeadi eai, GUIAU ena riba i matausiei, ena heaheari eo ena suisui i hesomdi se heura se lau numa alodi eai. ");
INSERT INTO swp_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Eo ia wa GUIAU ena riba nige i nuatui ena heaheari eo ena suisui se laugabaedi oea eai. ");
INSERT INTO swp_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Abo GUIAU i ribalau Mose arinai i ene, “Nimam u helelesaei galewa eai abo nabu tupitupina i taru Aigupito eanuana maudoina boeana eai, tatao potadi eai eo suisui potadi eai, eo lagau gamagamagaridi Aigupito eanuana boeana eai.” ");
INSERT INTO swp_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Arinai Mose ena tu’e i helelesaei galewa eai, eo GUIAU palele eo nabu tupitupina i hetamari, eo namanamari ie dobi tano eai, eo GUIAU nabu tupitupina i hetaru Aigupito eanuana potana eai. ");
INSERT INTO swp_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Arinai nabu tupitupina ie taru, eo namanamari lailai didigana ie siliesegai nabu tupitupina boeana eai, Aigupito basileaiana ena aba‐tubu i laoma nei huia ne, nige doha meta se ita. ");
INSERT INTO swp_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Aigupito eanuana maudoina boeana eai nabu tupitupina wa ginauri gamagaridi oea eai i lubidobedi, tatao eo suisui: eo nabu tupitupina oea lagauna i lubidobei, eo oea oeagidi gamagaridi i eatugodugodudi. ");
INSERT INTO swp_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Gosena eanuana eai mo, Isaraela nanatunayao haedi edi aba‐mia wa, nige begana nabu tupitupina nei eai. ");
INSERT INTO swp_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Parao hinage Mose eo Arona i eogaidi i ribalau aridi eai, i ene, “Ina huia ta baaea ea ginauri: GUIAU ia i dudulai, na eau eo egu tatao ai ponori. ");
INSERT INTO swp_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Au aibodalau GUIAU arinai, paana palele lailai didigana eo nabu tupitupina gonoadi: eo abo ea abigabaemiu, taba nige inai au mia.” ");
INSERT INTO swp_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mose i ribalau arinai i ene, “Eanua ea pesagabaei ma’esega abo nimagu ea helelelaedi GUIAU arinai: palele abo i lautom eo taba nige nabu tupitupina i taruuio, bena abina u ata tanoubu ta GUIAU enana. ");
INSERT INTO swp_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Na abina ea ata oa eo em heaheari sora nige GUIAU Eaubada au matausiei.” ");
INSERT INTO swp_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Lulu aba‐haturina eo sitona ana ao esau se baaea ohi, paana sitona wa i anio, eo lulu aba‐haturina i liasi. ");
INSERT INTO swp_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Na sitona eo rye nige se baaea paana sora nige se inisae. ");
INSERT INTO swp_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Abo Mose Parao i laugabaei, eo eanua i torohaigabaei eo nimana i helelelaedi GUIAU arinai: to palele eo nabu tupitupidi se lautom, eo nabu i taru lautom tano potana eai. ");
INSERT INTO swp_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Na huiana wa Parao ie ita nabu tupitupidi eo palele se lautomo, ena baaea wa i abiuioi, nuana i heoiura, ia eo ena heaheari. ");
INSERT INTO swp_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Arinai Parao nuana i heoiura Isaraela tataodi taba nige i abigabaedi, gonogonoana doha GUIAU i ribaei Mose arinai. ");
INSERT INTO swp_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","GUIAU i ribalau Mose arinai i ene, “U awasae Parao arinai: ia nuana eo ena heaheari nuadi ea heoiuradi bena egu heiheinoi ta ea hemasarahadi isi matadi eai. ");
INSERT INTO swp_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Bena abo natum eo tubum beadi eai abo au wasaduaiei, edohana Aigupito tataodi ea abiliuliuaidi, eo egu heiheinoi ea ginauridi boeadi eai: bena abina au ata eau GUIAU ede.” ");
INSERT INTO swp_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Arinai Mose eo Arona se lau Parao arinai se heriba si ene, “Doha ina GUIAU, Heberu edi Eaubada i ribaei, ‘Abo ma hisa u awaeagalaegu, nige u nuatudobidobiuioim matagu eai? Egu tatao u abigabaedi bena se heayaiyegu. ");
INSERT INTO swp_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Paana ena egu tatao u nuahidi, nige u abigabaedi, maraitom abo madimadi ea ledima em tano eai. ");
INSERT INTO swp_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Eanua abo se lau girihai taba nige tano se ita: abo saha eo saha se otahai nabu tupitupidi wa nige i hebaaeadi meta abo se aidi, eo emi oeagi gamagamagaridi oea eai abo hinage se aidi. ");
INSERT INTO swp_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Madimadi abo em numa se hemonaudi eo em heaheari gamagaridi edi numa, eo Aigupito tataodi gamagaridi edi numa, doha nige tamamiuyao e tubumiuyao se ita edi huia labasadi eai i laoma e ina asubena ta.’” Abotai i sinibui Parao matana i pesagabaei. ");
INSERT INTO swp_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Arinai Parao ena heaheari se ribalau ia arinai, si ene, “Ina tau ta huia lohana hisa abo i iwalaida? Tatao wa u abigabaedi GUIAU edi Eaubada bena se heayaiyei: nige sora u italobai Aigupito i baaea’o?” ");
INSERT INTO swp_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Arinai Mose eo Arona se woeauioidima Parao arinai eo i heribadi, i ene, “Au lau GUIAU emi Eaubada au heayaiyei: na aidimodi abo se lau?” ");
INSERT INTO swp_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Eo Mose i ene, “Abo ai lau, maemaiyao ama isimurita eo ama isibaguna, nanatumaiyao tatao eo sisine, ema mamoe eawoidi eo ema bulumakau eawoidi, paana ema GUIAU enana abo ai mataasi.” ");
INSERT INTO swp_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Abo Parao i ene, “Mamohoi abo GUIAU maemiu ena omi eo nanatumiuyao gagiridi ea earigabaemiu! Au ita, i masaraha nuatu baaea esau au nuanuatui. ");
INSERT INTO swp_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Taba nige’e: Au lau, omi tatao lailaimiu mo omibom, GUIAU bena au heayaiyei, paana meta me au henua.” To se aihenaudi Parao matana eai. ");
INSERT INTO swp_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Arinai GUIAU i ribalau Mose arinai, i ene, “Nimam u helelelaei Aigupito eanuana potana eai bena madimadi si laoma Aigupito tanona eai, abo ginauri ini’inidi gamagaridi, saha eo saha nabu tupitupidi nige i hebaaeadi, abo se aidi.” ");
INSERT INTO swp_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","To Mose ena tu’e i helelelaei Aigupito eanuana potana eai, eo GUIAU mana eawana i hetoa dimo ne potana eai asubena maudoina ne boeana eai, eo maiona maudoina boeana eai; abo mara ie tom eawana madimadi i ledima. ");
INSERT INTO swp_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Eo madimadi se saema Aigupito eanuana maudoina potana eai, eo se otadobi Aigupito eanuana maudoina potana eai, madimadi eawoidi lailai didigadi ana ao doha beabeana sora nige se ita, eo taba nige se itauio. ");
INSERT INTO swp_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Eanua wa se laugirihai, to tano i dubaduba, eo lagau gamagaridi tano wa potana eai se aidi, eo oeagi uauadi, saha eo saha nabu tupitupidi wa nige i hebaaeadi se aidi. Nige begana ginauri ini’inina i ota oeagi e oea lagaudi aridi eai Aigupito eanuana maudoina boeana eai. ");
INSERT INTO swp_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Abo Parao Mose eo Arona i eogaheuraidi i ene, “GUIAU emi Eaubada baaea arinai ea ginauri, eo omi arimiu eai hinage. ");
INSERT INTO swp_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ea aibodaim bena egu baaea ina ma’esega ta, u ribagigiri, eo au aibodalau GUIAU emi Eaubada arinai ina mate ta bena i laehesuara.” ");
INSERT INTO swp_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","To Mose Parao i pesagabaei eo i aibodalau GUIAU arinai. ");
INSERT INTO swp_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Abo GUIAU mana adiadidirina ealasi eai i hetoa, abo madimadi i iuhi‐hesuaradi i laedi Gabogabo Buiabuiana arinai; nige madimadi esega ie ota Aigupito dimona maudoina boeana eai. ");
INSERT INTO swp_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Na GUIAU Parao nuana i heoiura, taba nige Isaraela tataodi i abigabaedi. ");
INSERT INTO swp_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","GUIAU hinage i ribalau Mose arinai i ene, “Nimam u helelelaei galewa eai bena abo masigiri Aigupito eanuana potana eai, masigiri mamohoi bena amnana si ataiei.” ");
INSERT INTO swp_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","To Mose nimana i helelesaei galewa eai, abo masigiri potopotona Aigupito dimona maudoina boeana eai asubena haiona. ");
INSERT INTO swp_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Nige esau esau se itaitauioidi, eo nige esau ena aba‐ota eai i toro asubena haiona, na Isaraela nanatunayao edi abamia eai mo ie mara. ");
INSERT INTO swp_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","To Parao Mose i eogai i ene, “Au lau emi GUIAU au heayaiyei, nanatumiuyao hinage maemiuyao. Na emi mamoe eo emi bulumakau mo taba nige se lau.” ");
INSERT INTO swp_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Na Mose i ene, “Suisui hinage abo au ledima nimamai eai, ema aba‐aitalasam eo ema aba‐gabugabu, aridi eai abo ai heaitalasamdi GUIAU ema Eaubada arinai. ");
INSERT INTO swp_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Ema suisui hinage abo maemai ai lau. Taba nige aegigi esega ai laugabaei, paana bena ai laedi, abo aridi eai GUIAU ema Eaubada abo ai heayaiyei; paana nige abina ai ata saha arinai ema GUIAU abo ai aihelahui i lau e aie lage eanua esau eai ne. ");
INSERT INTO swp_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Na GUIAU Parao nuana i heoiura, taba nige i abigabaedi. ");
INSERT INTO swp_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Abo Parao i ribalau Mose arinai i ene, “U lausuaraegu; u ita komakomani, tabu u awaseuioma matagu eai, paana asubenana wa arinai matagu u itauioi abo u mate!” ");
INSERT INTO swp_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Eo Mose i ene, “U ribadudurai: taba nige matam ea itauioi.” ");
INSERT INTO swp_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","GUIAU i ribalau Mose arinai i ene, “Iwala esega mo abo ea leama Parao potana eai eo Aigupito potana eai: murina eai abo i abigabaemiu: ena i abigabaemiu, abo i aiduyei esegaimiu. ");
INSERT INTO swp_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Abo ina u riba tatao beadi eai, bena tatao gamagaridi se aibodalau heledi tatao aridi eai pasa udoi udoi silver eo gold aridi eai se ginauridi.” ");
INSERT INTO swp_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Arinai GUIAU Aigupito tataodi nuadi i helolodi tatao wa aridi eai. Eo hinage tau wa, Mose, is sae ariariri Aigupito eanuana eai, Parao ena heaheari matadi eai, eo tatao matadi eai. ");
INSERT INTO swp_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Abo Mose i ene, “Doha ina GUIAU i ribaei, ‘Bulinuana eai abo ea pesa ea lau Aigupito duaduarina eai, ");
INSERT INTO swp_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","abo ealahou tatao gamagaridi Aigupito eanuana eai abo se mate. Parao ena ealahou tau, ia ede i bawa terona potana eai, i lau e heaheari sinena ia sitona aba‐bibina dagelana eai ena ealahou tau. Eo suisui hinage lababagunadi gamagaridi. ");
INSERT INTO swp_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Dou lailai abo ie tubu Aigupito eanuana maudoina boeana eai, sora nige doha nei se ataiei, eo abo taba nige se ataieiuioi. ");
INSERT INTO swp_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Na Isaraela tataodi aridi eai, tau e suisui, taba nige kedewa esau i talabou, bena abo au italobai GUIAU i heseri Aigupito tataodi eo Isaraela tataodi boeadi eai. ");
INSERT INTO swp_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Em heaheari gamagaridi abo se dobima arigu eai, se debatutu matagu eai, abo si ene, “U lausuara eo tatao gamagaridi isi tauhemuriwataim”: eo murina eai abo ea pesa.’” To Parao matana i pesagabaei ma ouyalayala‐aririna. ");
INSERT INTO swp_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","GUIAU hinage i ribalau Mose arinai i ene, “Parao taba nige em riba i ataiei, egu laulau gigiboridi bena se gamagari Aigupito tanona eai.” ");
INSERT INTO swp_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mose eo Arona laulau gigiboridi se ginauridi Parao matana eai; na GUIAU Parao nuana i heoiura, Isaraela tataodi taba nige i abigabaedi bena ena eanua se torohaigabaei. ");
INSERT INTO swp_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","GUIAU i ribalau Mose eo Arona aridi eai Aigupito eanuana eai, i ene: ");
INSERT INTO swp_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Ina nawarai ta arimiu eai abahetubuna, hinage nawarai headi. ");
INSERT INTO swp_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Isaraela tataodi au heoigogoidi au heribadi, ‘Ina nawarai ta asubena hesaudoudoina eai tatao gamagaridi abo mamoe natuna se abi, tamadi ena numa ena boga laina gonoana, numa esau esau ena mamoe. ");
INSERT INTO swp_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ena boga esau i gagiri ariri, nige gonoana bena mamoe se ai heohi abo ia eo helena taumia tauna mamoe se abi bena tatao gamagaridi au hasiridi abo se ai gonogonoadi: ");
INSERT INTO swp_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Em mamoe natuna taba nige gaina arinai, suisui tamoana ena borimai esega: mamoe e goti boeadi eai abo au abi. ");
INSERT INTO swp_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Abo au abididini i lau e ina nawarai ta ena asubena hesaudoudoi‐hasina, abo Isaraela moutuana maudoudoina maimailahi eai abo edi mamoe se unuidi. ");
INSERT INTO swp_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Abotai osina tupona abo se abi eo se hesau numa dobila dudi labui potadi eai, ia ede haedi edi aba‐aiai wa. ");
INSERT INTO swp_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Nei maionana eai ne buluma gabugabuna abo se ai, eo falawa nige ie sese, eo lagau karakarapidi maena abo se ai. ");
INSERT INTO swp_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Tabu idaidaina au ai eo tabu goila maena se riga, na gabugabuna mo; uruna eo eauna gamagarina boeana eai. ");
INSERT INTO swp_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Tabu begana i ota i lau maraitom. Ena sahaina ie ota maratomtom eai abo au gabu oeagi eai. ");
INSERT INTO swp_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Doha ina abo au ai: taumiu au taididinimiu, emi aemiu eai, eo em tu’e nimamiu eai: eo abo au ai heurai. Ina ta GUIAU ena pasova ede. ");
INSERT INTO swp_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Paana Aigupito eanuana maudoina abo ea taudadai nei maionana ne, abo tatao ealahoudi eo suisui lababagunadi abo ea unulabuiedi Aigupito boeana eai, tau eo suisui; eo Aigupito edi oitau gamagaridi abo ea hekilainodi. Eau GUIAU ede. ");
INSERT INTO swp_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Osina abo heiheinoi omi arimiu eai, eo numa wa, emi aba‐mia potadi eai: ena osina wa ea ita, abo ea hemurimiu eo taba nige iwala i oi’itamiu bena i unuimiu, huiana eai ne Aigupito eanuana abo ea hebaaea. ");
INSERT INTO swp_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“‘Ina asubena ta abo i hemala emi abahenuaisini, abo au heasisiei GUIAU ena mataasi. Ami isi gamagaridi aridi eai abo au heasisiei emi laugagaeo i lau e nige nosina. ");
INSERT INTO swp_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Asubena haligigi‐labui boeadi eai falawa nige ie sese abo au ai; asubena bagubagunana eai falawa wa ena aba‐sese emi numa eai abo au torohesuara, paana ena doga esau falawa sesesesena wa i aiaini asubena bagubagunana arinai i lau e asubena hehaligigi‐labuina eai abo Isaraela aridi eai doga wa se tomgabaei. ");
INSERT INTO swp_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Asubena bagubagunana eai oigogo tabuna abo au abi eo asubena hehaligigi‐labuina eai hinage abo oigogo tabuna; taba nige se paisoa asubenadi ne boeadi eai na saha eo saha gamagarimiu bena au ai meta mo abo au abi nonohai. ");
INSERT INTO swp_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Ina falawa ta nige i sese mataasina abo au abididini, paana ina asubena eai ta emi moutuana ea woeahaimiu Aigupito eanuana eai wa; arinai ina asubena ta abo au hetabuei isi gamagaridi aridi eai emi laugagaeo i lau e nige nosina. ");
INSERT INTO swp_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Nawarai bagubagunana eai, nawarai asubenana hesaudoudoi‐hasina maimailahina eai falawa nige ie sese abo au ai i lau e nawarai asubena tau‐esega‐i‐mate‐esega maimailahina eai. ");
INSERT INTO swp_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Asubena haligigi‐labui boeadi eai taba nige falawa ena aba‐sese se lobai emi numa eai, paana taba doga esau saha sesesesena ie ai, doga me abo se tomgabaei Isaraela moutuana aridi eai, ena ia taulaolaoma, e eanua tauna tahunuana. ");
INSERT INTO swp_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Saha eo saha ie sese tabu au ai: emi numa gamagaridi alodi eai falawa nige ie sese abo au ai.’” ");
INSERT INTO swp_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Mose Isaraela tataodi abo i eogaidi, i ribalau aridi eai, i ene, “Omibom emi mamoe au hineridi emi boga gonogonoadi eai, pasova ena mamoe abo au unui. ");
INSERT INTO swp_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Lagau augogona abo au abi au hedatudobei osina gaebana eai wa, abo dobila lauhebarana eo du labui au hesaudi osina arinai gaeba wa alona eai: eo tabu esau boeamiu eai ena numa i pesagabaei, i lau e mara i tom. ");
INSERT INTO swp_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Paana GUIAU abo i bayawa Aigupito tataodi abo i unuidi: na ena osina i ita dobila lauhebarana eai eo du labui aridi eai, dobila wa abo i hemuri, eo tauaiunu i gudugudui taba nige i awasae emi numa alodi eai bena i unuimiu. ");
INSERT INTO swp_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Ina laulau tabuna ta abo au laelaei emi laugagaeo omi enamiu, eo nanatumiuyao enadi, i lau e nige nosina. ");
INSERT INTO swp_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Huiana eai au laoma eanua eai wa GUIAU abo i leawa wa gonogonoana doha i riba hesunumamiu wa, ina abiabi ta abo au laelaei. ");
INSERT INTO swp_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Huiana wa arinai nanatumiuyao se ribalaoa arimiu eai si ene, ‘Ina abiabi ta aniona saha?’ ");
INSERT INTO swp_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Abo au ene, ‘Ina aitalasam ta ia ede GUIAU ena pasova, paana Isaraela tataodi edi numa Aigupito eai i hemuridi, huiana wa Aigupito tataodi i unuidi, na ai ema numa mo i hemuridi.’” Eo tatao wa se tabaohu eo se aihelahui. ");
INSERT INTO swp_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Arinai Isaraela se lau ginauri doha GUIAU Mose eo Arona i lauhesomdi, meta se lauwatai. ");
INSERT INTO swp_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Abo hinage bulinuana eai ealahou gamagaridi Aigupito eanuana eai GUIAU i unuidi, Parao terona potana eai ie bawa, ia ena ealahou, eo hinage tauauau numa masigiri eai ia ena ealahou, eo suisui lababagunadi gamagaridi hinage. ");
INSERT INTO swp_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Abo maiona eai Parao i eno toro, ia eo ena heaheari gamagaridi, eo Aigupito tataodi gamagaridi, abo dou lailai Aigupito boeana eai, paana nige numa esau mate i deha. ");
INSERT INTO swp_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Maiona eai Mose eo Arona i eogaidi i ene; “Au toro egu tatao au lausuaraedi, omi eo Isaraela tataodi maemiuyao: eo au lau GUIAU au heayaiyei doha au ribaei wa ");
INSERT INTO swp_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Emi mamoe eawoidi, eo emi suisui headi au abidi eo au lau, doha au ribaeyao, Na eau hinage bena au ribahelologu.” ");
INSERT INTO swp_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Aigupito tataodi tatao wa se duiedi bena edi eanua se torohaigabaei heurai, paana si ene, “Ai gamagarimai dodoga matematemai.” ");
INSERT INTO swp_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Arinai tatao adi falawa sora nige ie sese se bahei, eo edi aba‐helasa se audi edi lulu aridi eai, eo se toredi dabayalodi eai. ");
INSERT INTO swp_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Isaraela tataodi Mose ena riba se lauwatai, Aigupito tataodi aridi eai pasa gold eo silver ginauridi, eo lulu hinage se aibodaidi. ");
INSERT INTO swp_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Tatao wa hinage GUIAU nua lolo i mosedi Aigupito tataodi matadi eai, arinai saha eo saha se aibodaidi meta se mosedi. Doha ina Aigupito edi gogo se abidi. ");
INSERT INTO swp_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Eo Isaraela tataodi Ramese eai se lauwasi se lau Sukota eai, aedi eai se lau, tatao gamagaridi tausani handerehaligigi‐esega, eo sisine ma nanatudiyao. ");
INSERT INTO swp_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Dodoga headi hinage se lauheboriedi maediyao se lau esega, eo suisui gamagaridi, mamoe eawoidi eo bulumakau. ");
INSERT INTO swp_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Eo falawa nige ie sese wa Aigupito eai se bahei: paana Aigupito eai se aiduiedi, nige gonoana se bagibagi, aiai hinage nige se abinonohai. ");
INSERT INTO swp_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Na Isaraela tataodi edi mia lohana Aigupito eai ede borimai handere hasi tau‐esega‐i‐mate‐saudoudoi. ");
INSERT INTO swp_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Abo borimai handere hasi tau‐esega‐i‐mate‐saudoudoi sigasigadi eai meta asubena me arinai GUIAU ena moutuana lailaina Aigupito eanuana se torohaigabaei. ");
INSERT INTO swp_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ina maiona ta i hemala silasilawa maionana GUIAU arinai, huiana wa Aigupito eanuana se pesagabaei, arinai ina maiona ta i hemala silasilawa maionana Isaraela tataodi isidi gamagaridi boeadi eai. ");
INSERT INTO swp_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Abo GUIAU i ribalau Mose eo Arona aridi eai, i ene, “Ina ta pasova laugagaeona ede, tabu tau laolaoma i ai. ");
INSERT INTO swp_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Na tauauau gamagaridi moni eai au unehaidi abo se ai, na bena au heperitome bagunaidi. ");
INSERT INTO swp_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Laolaoma tauna e heaheari se hemaisa taba nige se ai. ");
INSERT INTO swp_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Numa esega arona eai abo au ai: tabu bulumana tupona au bahelaei numa murina eai: eo siadana tabu au eatugodu. ");
INSERT INTO swp_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Isaraela tataodi gamagaridi abiabi ta abo se abididini. ");
INSERT INTO swp_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Ena taulaolaoma esau i aitaumanaimiu eo i henua pasova mataasina GUIAU arinai bena i abilau arinai, ena tatao gamagaridi abo se heperitomedi, murina eai abo i hanahanauma eo i abilau arinai: eo ia abo doha tau esau se labasi ena eanua tahunuana eai; na eai to eai nige se heperitomedi taba nige se ai. ");
INSERT INTO swp_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Laugagaeo esega mo omi eanua tataomiu tahunuadi enamiu, eo tau laolaoma ia i miahai boeamiu eai enana.” ");
INSERT INTO swp_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Doha ina Isaraela tataodi gamagaridi se lauwatai: doha GUIAU Mose eo Arona i lauhesomdi meta se ginauriwatai. ");
INSERT INTO swp_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Abo meta asubena esegana me arinai GUIAU Isaraela tataodi moutuadi i woeahaidi Aigupito tanona eai. ");
INSERT INTO swp_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","GUIAU i ribalau Mose arinai, i ene, ");
INSERT INTO swp_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Ealahou tataodi gamagaridi u hetabuedi arigu eai; saha eo saha se labasi bagunadi Isaraela tataodi boeadi eai, tatao eo hinage suisui boeadi eai, isi enaguyao ede.” ");
INSERT INTO swp_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Abo Mose i ribalau tatao aridi, i ene, “Ina asubena ta abo au nuatui, asubena wa arinai Aigupito emi auau numana, au torohaigabaei paana nimana adidirina eai eanua ta arinai GUIAU i eairihaimiu. Falawa ie sese wa tabu se ai. ");
INSERT INTO swp_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ina asubena ta Abibi nawaraina eai abo au torohai. ");
INSERT INTO swp_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Eo huiana eai wa GUIAU abo i woeaimiu Kanana, Hito, Amore, Hiwi eo Iebusi edi tano eai, ia ie riba’aigora wa tamamiuyao aridi eai bena abo i mosedi, tano masumasurina, wa ina abiabi ta, ina nawarai ta arinai abo au abididini. ");
INSERT INTO swp_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Asubena haligigi‐labui boeadi eai falawa nige ie sese wa abo au ai, eo asubena hehaligigi‐labuina eai abo GUIAU ena mataasi. ");
INSERT INTO swp_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Asubena haligigi‐labui boeadi eai falawa nige ie sese wa abo se ai: falawa ena aba‐sese taba nige se ita arimiu eai emi tupo maudoina eai. ");
INSERT INTO swp_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Abo nei asubena eai ne abo natum tau u heriba u ene, ‘Matapaana ede saha GUIAU i ginauri enagu huiana wa Aigupito ea torohaigabaei.’ ");
INSERT INTO swp_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Abo i hemala doha heiheinoi nimam potana eai eo abahenuaisinimiu matamiu duaduaridi eai, bena GUIAU ena laugagaeo abo awam eai; paana GUIAU nimana gigiborina eai i woeahaimiu Aigupito eai. ");
INSERT INTO swp_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Ina laugagaeo ia abo au abididini ena huia se ribaei wa arinai borimai to borimai. ");
INSERT INTO swp_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Abo huiana eai wa GUIAU i woeaimiu Kanana tataodi edi eanua eai, doha ie riba’aigora omi eo tamamiuyao aridi eai bena abo i leawa arimiu eai. ");
INSERT INTO swp_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Saha eo saha se labasi bagunai abo au tore hesuara GUIAU enana. Suisui boeadi eai lababagunadi tamoadi abo GUIAU enanyao. ");
INSERT INTO swp_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Asini lababagunana abo mamoe arinai au hemaisa lauhedamaina, eo ena nige lauhedamaina abo gadona au oigodu: eo nanatumiuyao tatao ealahoudi abo hinage maisadi au lauhedamaidi. ");
INSERT INTO swp_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Abo huia matamiu eai ena natum i hesiolaowa i ene, “Ina ta aniona saha?’ abo u heriba, ‘GUIAU nimana adidirina eai Aigupito eai i woeahaimai auau numana eai. ");
INSERT INTO swp_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Paana huiana eai wa Parao ma nuaoiurana i nuahimai taba nige ai lau, GUIAU ealahou gamagaridi Aigupito eanuana eai i unuidi, ealahou tatao eo hinage suisui lababagunadi. Arinai suisui gamagaridi se labasi bagunaidi meta ea heaitalasamdi GUIAU arinai, eo nanatuguyao tatao edi ealahou meta maisadi ea helaudamaidi.’ ");
INSERT INTO swp_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Abo i hemala heiheinoi nimam potana eai eo matam labui duaduaridi eai, paana nimana gigiborina eai GUIAU Aigupito eai i woeahaimiu.” ");
INSERT INTO swp_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Huiana eai wa Parao tatao i abigabaedi, Eaubada i woeaidi Pilistia edi eanua dobilana eai, dobila wa hanahanauna eai, paana Eaubada i ene, “Ata tatao ena iala se ita abo nuadi se buidi eo se uio Aigupito.” ");
INSERT INTO swp_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Na Eaubada tatao wa i woeahetaiiridi barabara dobilana eai i dobi Gabogabo Buiabuiana eai. Eo Isaraela tataodi Aigupito se torohaigabaei wa, se nonoha iala arinai. ");
INSERT INTO swp_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mose hinage Iosepa siadana i abidi i bahelaedi, paana Iosepa Isaraela tataodi i heaigora komakomanidi, i ene, “Eaubada abo omi maemiu, abo siadagu inai wa abo au abihaidi au laedi maemiu.” ");
INSERT INTO swp_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Sukota se laugabaei edi lauwasi se lauei abo Etami eai edi numa‐lulu se hetorodi barabara dedeana eai. ");
INSERT INTO swp_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Asubena eai GUIAU i edabagunaedi, eada ana ao doha du arinai i woeaidi dobila eai, eo maiona eai oeagi alaalasina arinai marana doha du, bena i hemaradi, bena asubena eo maiona hinage abo se lauwasi. ");
INSERT INTO swp_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Asubena eada ana ao doha du, eo maiona eai oeagi alaalasina ana ao doha du tatao matadi eai wa nige i laugabaedi. ");
INSERT INTO swp_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","GUIAU i ribalau Mose arinai i ene, ");
INSERT INTO swp_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Isaraela tataodi u heribadi bena si uio, abo Pihahirota matana eai, Migidole eo gabogabo duaduaridi eai, Baal‐sepona matana eai gabogabo gegesina eai, nei abo emi numa‐lulu au hetorodi. ");
INSERT INTO swp_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Eo Parao Isaraela enadi abo i ribaei, ‘Isi se gege se sae se dobi eanua boeana eai, barabara abo i guduguduidi.’ ");
INSERT INTO swp_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Parao nuana abo ea heoiura arinai abo i hemuriwataidi, eo egu namanamarina Parao ma ena tauiala abo i dioidi, eo Aigupito tataodi abo abina se ata, eau GUIAU ede.” Abo se lauwatai. ");
INSERT INTO swp_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Huiana wa Aigupito edi wasawasa se heriba tatao wa se dago’o, Parao eo ena heaheari nuadi se buidi tatao wa aridi eai, to si ene, “Saha ina ta ginauri arinai Isaraela ta abigabaedi edi heaheari paisoana enada wa arinai?” ");
INSERT INTO swp_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Arinai ena kariota i henonohadi eo ena tauiala maenayao, ");
INSERT INTO swp_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Abo kariota lolo ariridi handere haligigi‐esega i abidi, eo Aigupito ena kariota gamagaridi headi, edi kapena gamagaridi se tanuagaidi wa maediyao. ");
INSERT INTO swp_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","GUIAU Parao, Aigupito edi wasawasa, nuana i heoiura, eo Isaraela tataodi i hemuriwataidi, bena i toaidi paana isi wa ma nuakipikipidi na se torohai. ");
INSERT INTO swp_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Aigupito tataodi wa se hemuriwataidi, Parao ena hosi eo ena kariota eo ena hosi taugeruidi, eo ena tauiala, abo se lobaidi edi aba‐aiawasi eai gabogabo gegesina eai Pihahirota gegesina eai, Baal‐sepona matana eai. ");
INSERT INTO swp_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Huiana eai wa Parao i hanahanau, Isaraela tataodi matadi se helabaisinidi to se ita, Aigupito tataodi se laoma hesabadi, arinai se matausi ariariri, eo Isaraela tataodi se eogalau GUIAU arinai. ");
INSERT INTO swp_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Se ribalau Mose arinai si ene, “Aigupito eanuana eai bousa nige’e, arinai u abihesuaramai bena barabara eai ai mate wa? Paana saha u abimai doha ina, eo Aigupito eai u woeahaimai? ");
INSERT INTO swp_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Aigupito eai ai heribam, e nige’e ai ene, ‘Tabu u hemodemai Aigupito tataodi abo ai heayaiyedi.’ I lolo mo Aigupito tataodi abo ai heayaiyedi, abotai barabara eai ai mate.” ");
INSERT INTO swp_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mose tatao abo i heribadi i ene, “Tabu au matausi, au toroadiadididiri, eo GUIAU ena abihemauri abo au ita, ia wauta abo i ginauri enamiu. Paana Aigupito tataodi wauta au itadi wa, taba nige au itauioidi. ");
INSERT INTO swp_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","GUIAU abo enamiu i iala, omi mo au monou.” ");
INSERT INTO swp_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","GUIAU hinage i ribalau Mose arinai i ene, “Paana saha au eogalaoma? Isaraela tataodi u heribadi bena se torohai se lau matadi eai. ");
INSERT INTO swp_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Oa em tu’e u lausini nimam u helelelaei gabogabo potana eai, abo u soiei, eo Isaraela tataodi tano pitapitalina potana eai abo se laulau gabogabo boeana eai. ");
INSERT INTO swp_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Na eau hinage Aigupito tataodi nuadi abo ea heoiuradi, arinai abo se hemuriwataidi, abo ma namanamarigu Parao ena tauiala, eo ena hosi taugeruidi abo ea saetawatawaidi. ");
INSERT INTO swp_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Aigupito tataodi abo abina si ata, eau GUIAU ede, hedebasae abo enagu, huiana eai wa Parao, eo ena kariota, eo ena hosi taugeruidi ea saepoidi.” ");
INSERT INTO swp_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Eaubada ena aneru, ia wa Isaraela moutuana i edabagunaedi wa, ie sigi ie uio muridi eai, abo eada ana ao doha du wa ena aba‐toro matadi eai wa, ie sigi ie uio muridi eai i toro. ");
INSERT INTO swp_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","I laoma i toro, Aigupito edi tauiala, eo Isaraela edi tauiala duaduaridi eai; i hemala eada eo masigiri Aigupito tataodi aridi eai, na Isaraela tataodi aridi eai maiona masigirina i hemara; arinai moutuadi wa nige se hanahanau esau esau gegesidi eai maiona maudoina boeana eai. ");
INSERT INTO swp_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Abo Mose nimana i helelelaei gabogabo potana eai eo GUIAU gabogabo i pipiniuioi mana aruabu arinai maiona maudoina boeana eai, eo gabogabo i hemala tano pitapitalina eo goila i soiedi. ");
INSERT INTO swp_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Arinai Isaraela tataodi se lau gabogabo boeana eai tano pitapitalina potana eai, goila wa se hemala gana aridi eai tupo tutudi eai eo tupo seuseuridi eai. ");
INSERT INTO swp_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Aigupito tataodi se henauwataidi bena se toaidi gabogabo duaduarina eai, Parao ena hosi, ena kariota, eo ena hosi taugeruidi gamagaridi. ");
INSERT INTO swp_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Abo maratomtom silasilawana eai eada eo oeagi alaalasina doha du wa arinai GUIAU ie itadobi, Aigupito edi tauiala potadi eai, eo Aigupito edi tauiala i hematausidi. ");
INSERT INTO swp_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Edi kariota aedi wa i hesopudi, nige gonoana bena se lau, arinai Aigupito tataodi si ene, “Hage Isaraela tataodi ta dagogabaedi, paana GUIAU i iala enadi na nige Aigupito tataodi enada.” ");
INSERT INTO swp_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","GUIAU i ribalau Mose arinai i ene, “Nimam u helelelaei gabogabo potana eai bena gabogabo abo i uioma Aigupito tataodi potadi eai, edi kariota potadi eai, eo edi hosi taugeruidi potadi eai ");
INSERT INTO swp_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Arinai Mose nimana i helelelaei gabogabo potana eai, eo ena mara i uiari gabogabo i didiuioma doha kamanina wa, abo Aigupito tataodi se dago matana eai, eo GUIAU Aigupito tataodi i saepoidi gabogabo duaduarina eai. ");
INSERT INTO swp_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Gabogabo hinage i uioma, kariota eo hosi taugeruidi eo Parao ena tauiala moutuana maudoina i hepututawaidi isi tauhemuriwataidi gabogabo boeana eai wa; nige begana esega i mia. ");
INSERT INTO swp_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Na Isaraela tataodi tano pitapitalina potana eai se laulau gabogabo boeana eai; goila wa doha edi gana tupo tutu eai, eo tupo seuseuri eai. ");
INSERT INTO swp_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Doha ina asubenana eai ne GUIAU Isaraela i tuahemauridi Aigupito tataodi nimadi eai; eo Isaraela tataodi Aigupito tataodi matematedi se itadi salagomgom eai. ");
INSERT INTO swp_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Arinai paisoa saesaena GUIAU ie abi Aigupito tataodi aridi eai. Isaraela se ita, arinai tatao wa GUIAU se matausiei, abo GUIAU se awamamohoiei, eo ena heaheari tauna Mose hinage. ");
INSERT INTO swp_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Arinai Mose eo Isaraela tataodi ina wana ta se wanai GUIAU arinai, si ene. “Abo GUIAU arinai ea wana paana ia ma namanamarina i saepoi; hosi ma taugeruina i heputuhaidi gabagabo eai. ");
INSERT INTO swp_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","GUIAU egu adidiri eo egu wana ede, ia hinage i hemala egu mauri; ina egu Eaubada ede, eo abo hedebasaei tamagu ena Eaubada, eo abo ea hedebasaei aririei. ");
INSERT INTO swp_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","GUIAU ia iala tauna ede; esana ede GUIAU. ");
INSERT INTO swp_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Parao ena kariota eo ena tauiala i heputuhaidi gabogabo eai, Eo ena kapena saesaedi Gabogabo Buiabuiana eai se salili. ");
INSERT INTO swp_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Dibori utu’utu se saehaidi; Se dobi gabotum eai doha we’u. ");
INSERT INTO swp_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Nima tutum, O GUIAU e, ma gigibori namanamarina, nima tutum, O GUIAU e, waiunu i hetamogorugorudi. ");
INSERT INTO swp_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Isi se toro bena se saepoim, em namanamari gigiborina eai u gabadobedi; em ouyalayala lailai didigana u torelaei i gabudi doha lagau pitapitalina. ");
INSERT INTO swp_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Eahuam adidirina eai goila i gogosaei, Dibori utu’utu se toro esega doha pei; gabogabo gabotumna duaduarina i oiura. ");
INSERT INTO swp_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Waiunu i ribaei, i ene, ‘Abo ea lauwataidi, abo ea lagewataidi, gogo abo ea soiei; egu henua aridi eai abo ea abiheohi. Egu elepa sumana eai abo ea niusi nimagu abo i unuhematedi.’ ");
INSERT INTO swp_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Em mana arinai i iuhilaei gabogabo i buburitawaidi; Se salili doha poasi goila lailaidi alodi eai. ");
INSERT INTO swp_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","O GUIAU e, eaubada udoi udoi boeadi eai, Eai doha oa tabuna ma namanamarina, em hewau gigigigiboridi nuamatausidi? ");
INSERT INTO swp_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Nima tutum u helelelaei, tano i domdi. ");
INSERT INTO swp_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Em gadosisi ota’otahaina debana eai tatao u hemauridi wa u edabagunaedi: em adidiri eai u woeaidi em aba‐mia tabuna arinai. ");
INSERT INTO swp_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Tatao se ataieiyao se tabutabubu; Pilistia tataodi amamna lailaidi se hearodi, ");
INSERT INTO swp_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edoma edi babadayao nuadi se heasiwolewoledi; Moaba edi tatao saesaedi se tabutabububu; Kanana tataodi nuadi se welo’o. ");
INSERT INTO swp_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Matausi lailai didigana ie beudobi potadi eai; nimam gigiborina eai isi se toreesegaidi doha we’u, i lau e em tatao se baeawa, O GUIAU e, i lau e tatao u hemauridi se baeawa’o. ");
INSERT INTO swp_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Oa abo u woealageedi em oea tupi tahunuana eai abo u umaidi, tupo wa O GUIAU e, oa u ginauri em aba‐mia, em aba‐mia tabuna, O GUIAU e, oa nimam eai u hetoro. ");
INSERT INTO swp_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","GUIAU ia abo wasawasa i lau e ana huia, ana tasi.” ");
INSERT INTO swp_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Parao ena hosi, ena kariota, eo ena hosi taugeruidi se lau gabogabo eai, abo GUIAU gabogabo i hedidiuioi potadi eai; na Isaraela tataodi gabogabo eai se laulau tano pitapitalina potana eai, gabogabo duaduarina eai. ");
INSERT INTO swp_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Abo Miriam, peroweta sinena, Arona louna, boieatu gagirina ie abi nimana eai, eo sisine gamagaridi se torohai se hemuriwatai, boieatu se oidi, eo se saga. ");
INSERT INTO swp_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Abo Miriam enadi ie wana: “GUIAU enana au wana, paana ma namanamarina i saepoiya’o. Hosi eo taugeruina i heputuhaidio gabogabo arona eai.” ");
INSERT INTO swp_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Arinai Mose Isaraela i woeaidi Gabogabo Buiabuiana se laugabaei; abo se soralau Sura barabarana eai se laulau, na nige goila se lobai. ");
INSERT INTO swp_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Huiana wa se lage Maraha eai, goilana taba nige se nom paana i karapi, arinai esana se tore Maraha. ");
INSERT INTO swp_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Abo tatao Mose se gadigadiguguei, si ene, “Abo saha ta nom?” ");
INSERT INTO swp_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Arinai i eogalau GUIAU arinai, to GUIAU oeagi esau i heita, taba i gabalaei goila alona eai, goila wa abo i amna. Nei eai GUIAU laugagaeo gamagaridi i mosedi, bena i lauitadi. ");
INSERT INTO swp_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","I ene, “Ena au ata’atai komakomani GUIAU emi Eaubada arinana arinai, eo saha i dudulai ia matana eai au ginauri, eo ena laugagaeo au nuatuidi eo ena laugagaeo au sogohidi, iwala gamagaridi ea hetamarilaedi Aigupito tataodi potadi eai taba nige au hearodi; paana eau GUIAU tauhemaurimiu ede.” ");
INSERT INTO swp_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Murina eai se lage Elima eai, nei eai bunubunuwasi saudoudoi‐labui, eo palm oeagidi tatao haiona‐se‐mate‐saudoudoi, to nei eai goila gegesina eai edi numa lulu se hetorodi. ");
INSERT INTO swp_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Elima se torohaigabei abo Isaraela moutuana lailaina se lage Sini barabarana eai. Elima eo Sinai duaduaridi eai, asubena hesaudoudoi‐haligigina eai, nawarai helabuina eai wa Aigupito se torohaigabaei murina eai. ");
INSERT INTO swp_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Abo Isaraela maudoina moutuana Mose eo Arona se gadigadiguguedi barabara eai. ");
INSERT INTO swp_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Eo Isaraela tataodi se ribalau aridi eai si ene, “I lolo to GUIAU nimana eai ai mate Aigupito eanuana eai, huiana eai wa aie bawa anihu gulewadi gegesidi eai, eo falawa arinai bogamai se sese; paana omi au woeaimai ina barabara eai ta bena moutuana maudoina ta au unuimai guriam debana eai!” ");
INSERT INTO swp_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","GUIAU abo i ribalau Mose arinai i ene, “Galewa eai abo falawa ea hetarudobi potamiu eai doha nabu, abo tatao se lau asubena esega ana se tanoi asubena gamagaridi eai, bena ea lauitadi, abo egu laugagaeo boeana eai se laulau e nige’e. ");
INSERT INTO swp_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Abo asubena hehaligigi‐esegana eai saha se tanoi abo se abinonoha, na asubena esega ana laina abo se helabui.” ");
INSERT INTO swp_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Eo Mose eo Arona se ribalau Isaraela tataodi gamagaridi aridi eai, “Maimailahi huiana eai abo abina au ata, ia GUIAU ede Aigupito eai i woeahaimiuo wa; ");
INSERT INTO swp_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","maratomtom eai GUIAU namanamarina abo au ita, paana emi gadigadigugu GUIAU arinai i ataiedio: na ai ede aidimodi, arinai ai arimai eai au gadigadiguguemai?” ");
INSERT INTO swp_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mose hinage i ene, “Abo au ita, ena GUIAU maimailahi huiadi eai buluma i leawa bena au ai, eo maratomtom eai falawa abo arinai bogamiu se sese; paana GUIAU emi gadigadigugu arinai au gadigadiguguei i ataiedio; na ai abo aidimodi? Emi gadigadigugu nige arimai eai, na GUIAU arinai.” ");
INSERT INTO swp_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Mose abo i ribalau Arona arinai, i ene, “Isaraela moutuana u heribadi, ‘Au hanahanauma GUIAU arinai paana emi gadigadigugu i ataiedio.’” ");
INSERT INTO swp_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Eo huiana wa Arona i ribalau Isaraela moutuana aridi eai, se italau barabara eai, hedeomi GUIAU namanamarina i taumasaraha eada boeana eai. ");
INSERT INTO swp_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","GUIAU abo i ribalau Mose arinai i ene, ");
INSERT INTO swp_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Isaraela edi gadigadigugu ea ataiedio; u ribalau aridi eai u ene, ‘Mahana ena bulumtaru eai abo anihu au ai, eo maratomtom eai falawa arinai abo bogamiu se sese, bena abina au ata eau GUIAU emi Eaubada ede.’” ");
INSERT INTO swp_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Maimailahi huiana eai manu gagiridi se saema eanua se hemonau, abo maratomtom wabumari edi aba‐mia i taruhetaiiri. ");
INSERT INTO swp_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ena wabumari i lao’o tano eai ginauri po’opo’odi doha ice tupidi gagagiridi tano potana eai se ota. ");
INSERT INTO swp_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Huiana wa taba Isaraela tataodi se se ita, se ribalau esau esau aridi eai si ene, “Ina ta saha?” paana nige abina se ata aisana. Arinai Mose i ribalau aridi eai i ene, “Ina falawa ede, GUIAU i leawa ami aiai. ");
INSERT INTO swp_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ina ginauri ta ede GUIAU enana i lauhesom i ene, ‘Gamagarimiu au tanoi abo ami gonogonoamiu, esega esega omer esega, gamagarimiu gonoamiu, abo au tanoi tatao gamagarimiu ami numa‐lulu eai gonogonoamiu.’” ");
INSERT INTO swp_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Arinai Isaraela tataodi se lauwatai, headi se tanoi ariri, headi begana mo. ");
INSERT INTO swp_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Na ena se nonoi esau esau ana omer arinai ia ie tano helai, nige begana saha ie ota, na ia begana mo i tanoi ia arinai gonoana; esau esau ia ana gonogonoana i tanoi. ");
INSERT INTO swp_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Eo Mose i heribadi, “Tabu otahaina au tore i lau maraitom.” ");
INSERT INTO swp_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Na Mose nige se ataiei, arinai headi, tupona se abitore i lau maraitom, na i motamota eo ie boha: arinai Mose i ouyalayalaidi. ");
INSERT INTO swp_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Maratomtom gamagari se tanoi esau esau gonogonoadi paana ena mahana i gigibori abo i welo. ");
INSERT INTO swp_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Asubena hehaligigi‐esegana eai falawa se tanoi wa laina se helabui, esau esau ana omer labui, moutuana edi babadayao se laoma Mose se heriba. ");
INSERT INTO swp_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","I ribalau aridi eai i ene, “GUIAU i ene, ‘Maraitom huia aiyawasi tabuna ede, GUIAU ena sabati tabuna; wauta saha au henua bena au gabu, eo otahaina maudoina abo au aitore au abididini i lau e maraitom.’” ");
INSERT INTO swp_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Abo se abididini i lau e maraitom, doha Mose i ribaei; eo nige ie boha eo nige i motamota. ");
INSERT INTO swp_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mose i ene, “Meta me au ai wauta, paana wauta ede GUIAU ena sabati: wauta taba nige falawa au lobai tano eai. ");
INSERT INTO swp_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Asubena haligigi‐esega boeadi eai, abo au tanoi, na asubena hehaligigi‐labuina eai, ia ede sabati, arinai taba nige’e.” ");
INSERT INTO swp_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","To asubena‐hehaligigi‐labuina eai tatao headi se pesa bena se tanoi, na nige se lobai. ");
INSERT INTO swp_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Eo GUIAU i ribalau Mose arinai, i ene, “Huia lohana saha abo egu lauhesom eo egu laugagaeo au awayagalaidi? ");
INSERT INTO swp_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ai ita, GUIAU sabati i leawao, arinai asubena hehaligigi‐esegana eai asubena labui ana falawa i leawa: au bawa tatao gamagarimiu, emi aba‐mia eai asubena hehaligigi‐labuina eai, tabu tau esau ena aba‐mia i torohaigabaei.” ");
INSERT INTO swp_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Arinai asubena hehaligigi‐labuina eai tatao se aiyawasi. ");
INSERT INTO swp_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Isaraela maudoina falawa wa esana se tore Manna, ana ao doha sitona tumana eo amnana doha keke amo’amo arinai se heboriridi. ");
INSERT INTO swp_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mose i ene, “Doha ina GUIAU i lauhesom, ‘Omer esega abo au abididini ami isi gamagaridi aridi eai falawa arinai ea heaimiu bena se ita, huiana eai wa Aigupito tanona arinai ea woeahaimiu.’” ");
INSERT INTO swp_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Eo Mose Arona i heriba i ene, “Gulewa u abi eo arinai manna omer esega au usai, eo abo au tore GUIAU matana eai bena se abididini ami isi gamagaridi aridi eai.” ");
INSERT INTO swp_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Doha GUIAU Mose i lauhesom wa, Arona ie tore Eaubada ena ribahesunuma heiheinoina wa matana eai bena nei eai i ota. ");
INSERT INTO swp_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Isaraela nanatunayao manna se ai borimai tatao‐labui‐se‐mate boeadi eai i lau e se lage eanua tatao se miayao wa arinai: manna se ai i lau e se lage Kanana eanuana dedeana eai. ");
INSERT INTO swp_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Omer ia ede epaha lausoisoina hesaudoudoina. ");
INSERT INTO swp_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Isaraela moutuana Sini barabarana se laugabaei se sigilau begana begana, GUIAU ena lauhesom arinai i lau e Repidim edi numa lulu se hetorodi. Na nei eai nige goila bena tatao se nom. ");
INSERT INTO swp_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Arinai tatao Mose se hegiru si ene, “Goila u leama bena ai nom.” Na Mose i ene, “Paana saha au hegirugu? Eo paana saha GUIAU au lau ita?” ");
INSERT INTO swp_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Na tatao nei eai se gadomagu ariri bena goila se nom, eo tatao Mose se monumonunuei, si ene, “Paana saha Aigupito eai u woeahaimai abo ai, eo nanatumaiyao eo ema suisui abo u unuimai gadomagu arinai?” ");
INSERT INTO swp_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Arinai Mose i eogalau GUIAU arinai, “Abo saha ea ginauri tatao ta aridi eai? Se nonoha begana abo se lauwe’uigu.” ");
INSERT INTO swp_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Eo GUIAU i ribalau Mose arinai i ene, “Tatao u bagunaedi Isaraela edi babadayao headi maemyao, eo nimam eai em tu’e wa u abi, tu’e wa arinai saga ue oi, na u lau. ");
INSERT INTO swp_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","U ita abo matam eai ea toro we’utau potana eai Horeba eai, we’u abo u oi’ita eo goila abo arinai i didima bena tatao se nom.” Mose hinage i ginauriwatai Isaraela edi babadayao matadi eai. ");
INSERT INTO swp_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Tupo ne esana ie tore Masa eo Meriba, Isaraela edi lauhegiru debana eai, eo paana GUIAU bena se lau ita, si ene, “GUIAU ia boeada eai, e nige’e?” ");
INSERT INTO swp_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Abo Amaleka tataodi se laoma eo Isaraela tataodi se ialaidi Repidim eai. ");
INSERT INTO swp_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Eo Mose i ribalau Iosua arinai i ene, “Tatao enamai u hineridi eo au torohai au lau Amaleka tataodi au ialaidi: maraitom abo oea tupina potana eai ea toro, Eaubada ena tu’e nimagu eai.” ");
INSERT INTO swp_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Arinai Iosua i lauwatai gonogonoana doha Mose i ribaei, eo Amaleka tataodi i ialaidi: abo Mose, Arona eo Hura se sae oea tupina eai. ");
INSERT INTO swp_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Abo ena Mose nimana i lausini Isaraela tataodi se adidiri, eo ena nimana i toredobei Amaleka tataodi se adidiri. ");
INSERT INTO swp_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Na Mose nimana se ape’ape, arinai we’u se abi se torelaei ena ababawa, eo i bawa potana eai, eo Arona eo Hura nimana se lausinidi esau tupo esau eai, esau tupo esau eai; abo nimana se adidiri esegai i lau e mahana ie dui. ");
INSERT INTO swp_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Eo Iosua elepa eai Amaleka tataodi i oidobedobedi. ");
INSERT INTO swp_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","GUIAU i ribalau Mose arinai i ene, “Ina ta abo u uridobei buka eai bena emi abahenuaisini, eo abo au hasiri Iosua beana eai, bena abo Amaleka tataodi esadi ea la’ahaigabaedi galewa ubuna eai.” ");
INSERT INTO swp_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mose aba‐aitalasam abo i hetoro, eo esana i atai, ‘GUIAU egu gora ede.’ ");
INSERT INTO swp_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","I ene, “Paana nimadi se lausinidi GUIAU se ialai arinai GUIAU Amaleka tataodi i ialaidi i lau e isina to isina.” ");
INSERT INTO swp_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Ietero, Midiani edi kohena, Mose bosiana wa saha eo saha Eaubada i ginauridi Mose eo Isaraela tataodi enadi i ataiedio, eo edohana GUIAU Isaraela tataodi Aigupito eai i woeahaidio. ");
INSERT INTO swp_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Ietero, Mose bosiana, Mose monena Sipora i abiuioi, paana Mose i hetamariuioi arinai. ");
INSERT INTO swp_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Nanatunayao tatao labui hinage, esau esana Geresoma (paana i ene, “Eau taulaolaoma eanua udoi eai,”) ");
INSERT INTO swp_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Eo esau esana Eliesera, (paana i ene, “Tamagu ena Eaubada agu sagu ede eo Parao ena elepa eai i abihemauriguo.”) ");
INSERT INTO swp_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Abo Ietero, Mose bosiana wa, ma nanatunayao tatao eo ma monena, se laoma barabara eai Mose arinai ia ede numa‐lulu eai ie mia, Eaubada ena oea tupina eai. ");
INSERT INTO swp_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","To riba i hetamarilau Mose arinai i ene, “Eau Ietero, bosiam wa, ea laoma arim eai, monem hinage ma nanatunayao labui.” ");
INSERT INTO swp_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Arinai Mose ie pesa ie lau bosiana i hailobai i debatutu arinai eo i alagoiei: esau esau se haihesiouioidi, “Edohamiu? Au lolo?” abo se awasae numa‐lulu alona eai. ");
INSERT INTO swp_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Abo Mose bosiana i heriba GUIAU ena abiabi saha eo saha Parao arinai, eo Aigupito tataodi aridi eai Isaraela tataodi debadi eai, eo pilipili gamagaridi se hearodi dobila eai wa, eo edohana GUIAU i abihemauridi. ");
INSERT INTO swp_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","GUIAU ena abilolo gamagaridi Isaraela tataodi aridi eai Ietero i nuawoiwoinaei, paana Aigupito nimadi eai i abihemauridi. ");
INSERT INTO swp_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Ietero hinage i ene, “Hedebasaena GUIAU arinai paana i hemaurimiuo Aigupito tataodi nimadi eai, eo hinage Parao nimana eai: Aigupito tataodi nimadi eai hinage tatao i hemauridio. ");
INSERT INTO swp_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Abotai wauta abina ea ata GUIAU i sae ariri abotai eaubada headi, paana tatao wa i hemauridi.” ");
INSERT INTO swp_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Arinai Ietero, Mose bosiana wa, aitalasam headi i ledima Eaubada arinai: eo Arona maena Isaraela babadayao gamagaridi gamagaridi se laoma bena Mose bosiana maedi falawa se ai Eaubada matana eai. ");
INSERT INTO swp_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Mara ie tom Mose ie bawa tatao i hedudulaidi eo tatao se totoro Mose matana eai maratomtom eai i lau e maimailahi. ");
INSERT INTO swp_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Huiana wa Mose bosiana ie ita saha eo saha i ginauridi tatao enadi, i ene, “Saha ina u ginauri tatao enadi? Paana saha oabom ue bawa eo tatao se torohetaiirim maratomtom eai i lau e maimailahi?” ");
INSERT INTO swp_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mose i ene, “Paana tatao wa se laoma arigu eai Eaubada ena nuatu bena se lobai. ");
INSERT INTO swp_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ena se haiabi se laoma arigu eai abo eau ea ribaheduduraidi, tau esau maena helena tau mia tauna aridi eai, eo Eaubada ena laugagaeo eo ena nuatu ea hemasarahadi aridi eai.” ");
INSERT INTO swp_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Mose bosiana i ene, “Ina em abiabi ta nige i lolo. ");
INSERT INTO swp_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Oa eo tatao maemyao, abo emi adidiri au heohi, paana ginauri ta i porohe ariri arimiu eai, nige gonoana oabom u bahei. ");
INSERT INTO swp_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Wauta arinagu u ataiei, abo ea riba hasahasaim, eo Eaubada abo maem. Oa abo u torolau Eaubada matana eai tatao enadi, eo edi aba‐haiabi wa abo u toredi Eaubada matana eai. ");
INSERT INTO swp_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Abiabi eo laugagaeo abo u heatadi eo hinage aisega dobila bena se ginauri abo u heitadi. ");
INSERT INTO swp_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Tatao sibasiba abo hinage u hineridi tatao gamagaridi isi bena Eaubada taumatausiena eo tatao laulau dudulai, gogo nua’oina bena se hewaiunuei; tatao abo u hetorodi, headi tatao tausani abo se tanuagaidi, headi tatao handere se tanuagaidi, headi tatao‐labui‐se‐mate‐saudoudoi abo se tanuagaidi, headi saudoudoi mo abo se tanuagaidi ");
INSERT INTO swp_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Isi huia gamagari abo tatao se hedudulaidi: pilipilidi lailaidi abo se lediwa arim eai, na pilipilidi gagiridi abo isibom se hedudulaidi doha ina abo am paisoa se hemamala abo porohe maemyao au bahei. ");
INSERT INTO swp_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ena doha ina u ginauri, eo Eaubada doha ina i lauhesom, abo u lauesegaim, taba nige u amna baaea, eo tatao gamagaridi abo se lau edi aba‐mia eai ma nuatarudi.” ");
INSERT INTO swp_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mose bosiana arinana i ataiei, eo saha i ribaei wa meta i lauwatai, ");
INSERT INTO swp_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Mose tatao sibasibadi Isaraela maudoina boeana eai i hineridi, i hetorodi tanutanuaga tatao boeadi eai, headi tausani se tanuagaidi, headi handere se tanuagaidi, headi tatao‐labui‐se‐mate‐saudoudoi, eo headi saudoudoi mo. ");
INSERT INTO swp_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Abo huia gamagari tatao se hedudulaidi; pilipili lailaidi se laedi Mose matana eai, na ginauri gagiridi isibom se hedudulaidi. ");
INSERT INTO swp_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Mose hinage bosiana i abigabaei ie lau; abo ena eanua tahunuana dobilana i lauwatai. ");
INSERT INTO swp_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Isaraela tataodi Aigupito eanuana se torohaigabaei nawarai harihariuna hehaionana eai asubena me arinai se lage Sinai barabarana eai. ");
INSERT INTO swp_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Huiana eai wa, Repidim se torohaigabaei eo se lage Sinai barabarana eai: edi numa‐lulu se hetorodi barabara eai: nei eai Isaraela edi numa‐lulu se hetorodi oea tupina matana eai. ");
INSERT INTO swp_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Abo Mose ie sae Eaubada arinai, eo GUIAU oea tupina eai i eogalau arinai i ene, “Doha ina abo u ribalau Iakobo numana eai, eo Isaraela tataodi abo u heribadi: ");
INSERT INTO swp_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Saha ea ginauri Aigupito tataodi aridi eai au itayao eo edohana ea baheimiu doha magesibu mabena potana eai, eo ea woeaimiu arigu eai. ");
INSERT INTO swp_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Arinai ena arinagu au awa’abiei, eo egu ribahesunuma au sogohididinidi, omi abo enaguyao dumadumadi tatao gamagaridi boeadi eai, paana tanoubu maudoina eau enagu ede. ");
INSERT INTO swp_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Omi abo kohena basileiana, eo boda tabuna. Riba wa ede ina bena u ribaei Isaraela nanatunayao aridi eai.” ");
INSERT INTO swp_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Arinai Mose i laoma tatao edi babadayao i eogaidi eo riba gamagaridi GUIAU i lauhesom wa, i hetorodi matadi eai. ");
INSERT INTO swp_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Abo tatao gamagaridi se heuio, si ene “Riba gamagaridi GUIAU i ribaedi meta abo ai lauwataidi.” Arinai Mose tatao edi riba i laedi GUIAU arinai. ");
INSERT INTO swp_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","GUIAU hinage i ribalau Mose arinai i ene, “U ita, abo ea laowa arim eai eada potopotona boeana eai, arinai ena ea ribalaowa arim eai abo tatao se ataiei, abo hinage se awamamhoiem i lau e nige nosina.” Mose tatao edi riba GUIAU i heriba. ");
INSERT INTO swp_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","GUIAU i ribalau Mose arinai, i ene, “U lau tatao u hetabuedi wau eo maraitom, eo adi lulu bena se deuridi, ");
INSERT INTO swp_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","abo asubena hehaionana eai bena se nonoha, paana asubena hehaionana eai GUIAU abo i dobima Sinai oea tupina eai tatao gamagaridi matadi eai. ");
INSERT INTO swp_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Abo gana u hetorohetaiiri tatao enadi, hinage abo u heribadi, ‘Au komakomanimiu, tabu au sae oea tupina eai, eo tabu dedeana au abi’ita: eai ena oea i abi’ita abo se unuhemate. ");
INSERT INTO swp_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Taba nige esau i abi’ita, na abo se lauwe’ui, e abo pidi se tu arinai: taba tau e suisui, taba nige i mauri’. Ena bogigi se iuhiheloha abo se laoma oea tupina arinai.” ");
INSERT INTO swp_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Arinai Mose oea tupina eai ie dobi tatao aridi eai, eo tatao i hetabuedi; eo isi hinage adi lulu se deuridi. ");
INSERT INTO swp_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Abo i ribalau tatao aridi eai, i ene, “Asubena hehaionana eai abo au nonoha; tabu sine au hanahanaui.” ");
INSERT INTO swp_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Asubena hehaionana eai maratomtom eai parele ie oi eo namanamari ie sili, eo oea tupina potana eai eada potopotona ie ota, eo hinage bogigi se iuhihelai aririei, arinai tatao gamagaridi edi numa eai se tabutabubu. ");
INSERT INTO swp_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Abo Mose tatao edi aba‐mia eai i woeahepesadi bena Eaubada se hailobai, eo oea tupina paana eai se toro. ");
INSERT INTO swp_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Asuasu Sinai oea tupina ie suma paana GUIAU oeagi ala’alasina eai ie dobi potana eai: asuasuna ie sae doha oeagi ala’alasina lailaina asuasuna, eo oea tupina maudoina i moimoiu. ");
INSERT INTO swp_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Huiana wa bogigi dagudaguna se helahelai da’oiei Mose i riba abo Eaubada i heuio arinana eai. ");
INSERT INTO swp_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","GUIAU i dobima Sinai oeana eai, oea tupina ewana eai, eo GUIAU Mose i eogai bena i sae oea tupina eai, arinai Mose ie sae. ");
INSERT INTO swp_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","GUIAU i ribalau Mose arinai, i ene, “U dobi tatao u ribahesanapudi, ata gana se oilopa bena se aiewalau GUIAU arinai eo gamagaridi ata se mate. ");
INSERT INTO swp_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Kohena hinage isi se hanahanau GUIAU arinai, bena se hetabu’uioidi ata maesega GUIAU i abilau aridi eai.” ");
INSERT INTO swp_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mose GUIAU i heriba i ene, “Tatao taba nige se saema Sinai oeana tupina eai, paana oa u lauhesomdi, u ene, ‘Oea tupina au ganai, eo au hetabuei.’” ");
INSERT INTO swp_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Arinai GUIAU i ribalau arinai i ene, “U lau, u dobi na abo au saema, Arona maem; na kohena eo tatao tabu gana se oilopa se saema GUIAU arinai ata maesega i oi’itadi.” ");
INSERT INTO swp_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","To Mose ie dobi tatao aridi eai, i heribadi. ");
INSERT INTO swp_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Eaubada riba gamagaridi ta i ribaedi, i ene, ");
INSERT INTO swp_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Eau GUIAU emi Eaubada ede, Aigupito tanona eai, auau numana eai, eau ea woeahaimiu. ");
INSERT INTO swp_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Em eaubada headi tabu u abidi, Eaubom mo. ");
INSERT INTO swp_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Tabu em oitau u ginauri ana ao doha galewa ewana eai ginaurina e tanoubu ginaurina, eo doha goila tano ubuna eai ginaurina: ");
INSERT INTO swp_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Tabu u taba’ohuidi e au heayaiyedi, paana eau GUIAU emi Eaubada, Eaubada aiaromagigilina ede; isi se hewaiunuegu edi baaea ea heawalaei nanatudiyao aridi eai i lau e isina hehaionana to isina hehasina. ");
INSERT INTO swp_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Na isi se gadosisiegu eo egu lauhesom se nanabuedi abo ea nuatoatoaidi i lau e isidi tausani. ");
INSERT INTO swp_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","GUIAU em Eaubada tabu esana u ataigaibui; ena esau GUIAU esana i ataigaibui Eaubada abo i hegiru. ");
INSERT INTO swp_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Sabati asubenana u nuatui, u hetabuei. ");
INSERT INTO swp_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Asubena haligigi‐esega abo wawari u abi, am paisoa gamagaridi u ginauridi; ");
INSERT INTO swp_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Na asubena hehaligigi‐labuina GUIAU em Eaubada ena sabati ede, tabu u paisoa arinai, oa eo natum tau, eo natum sine, em taupaisoa tau e sine, eo em suisui, eo am aitaumana em numa eai ie mia; ");
INSERT INTO swp_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","paana asubena haligigi‐esega boeadi eai GUIAU galewa eo tanoubu i ginauridi, gabogabo hinage, eo ginauri gamagaridi boeadi eai, abo asubena hehaligigi‐labuina eai i aiyawasi: arinai GUIAU asubena sabati i helolo eo i hetabuei. ");
INSERT INTO swp_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Oa tamam eo sinam u eogoeogoidi, em huia abo ie loha em oea eai GUIAU em Eaubada i leawa wa. ");
INSERT INTO swp_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Tau tabu u unui. ");
INSERT INTO swp_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Tabu u ganaganawari. ");
INSERT INTO swp_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Tabu u aiyahari. ");
INSERT INTO swp_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Helem taumia tauna tabu u hegirugaibui. ");
INSERT INTO swp_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Tabu nuam i lau helem taumia tauna ena numa eai, tabu nuam i lau helem taumia tauna monena arinai, e ena heaheari tauna arinai, e ena heaheari sinena arinai, e ena bulumakau, e ena asini, e ena ginauri gamagaridi aridi eai hinage tabu nuam se lauedi. ");
INSERT INTO swp_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Tatao gamagaridi se aiewalau parele eo namanamari eo bogigi daguguna eo oea tupi asuasuna arinai: se aiewalau to se matausi eo se tabububu abo se totoro eda lohaloha eai. ");
INSERT INTO swp_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Eo se ribalau Mose arinai, si ene, “Oa u ribalaoma arimai eai abo hinage ai ataiei na tabu Eaubada i ribalaoma arimai eai ata ai mate.” ");
INSERT INTO swp_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Arinai Mose tatao i heribadi, i ene, “Tabu au matausi, paana Eaubada i laoma i lauitamiu abo ia matausina matamiu eai, bena tabu baaea au abilau arinai.” ");
INSERT INTO swp_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Tatao hinage eda lohaloha eai se totoro, na Mose ia i hanahanau eada dubaduba potopotona gegesina eai, Eaubada nei eai ie mia. ");
INSERT INTO swp_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","GUIAU i ribalau Mose arinai i ene, “Doha ina abo u ribalau Isaraela tataodi aridi eai. ‘Omi omibom aue ita galewa eai ea ribalaowa arimiu eai. ");
INSERT INTO swp_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Tabu oitau gold eo silver au ginauridi, bena gonogonoadi doha eau; oitau silver eo gold enamiu tabu au ginauridi. ");
INSERT INTO swp_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Aba‐aitalasam tano arinai abo u ginauri enagu, eo potana eai em aitalasam gabugabudi, eo em labini aitalasamdi, em mamoe eo em bulumakau abo u heaitalasamdi: tupo gamagamagari aisega egu aba‐ribaena bena esagu se henuaisini, abo ea lage arim eai eo ea helolom. ");
INSERT INTO swp_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ena aba‐aitalasam enagu u ginauri we’u arinai, tabu we’u pidipididi aridi eai u ginauri: paana ena aba‐paisoa esau u lausini potana eai abo u hebi’i. ");
INSERT INTO swp_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Eo hinage paipeo arinai tabu u sae egu aba‐aitalasam eai, ata tauaha’aham i masaraha potana eai.’ ");
INSERT INTO swp_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Ina laugagaeo ta abo u hetorodi matadi eai: ");
INSERT INTO swp_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","ena Heberu tauauauna u unehai borimai haligigi‐esega abo i paisoa, na hehaligigi‐labuina eai abo u eairigabaei nige maisana. ");
INSERT INTO swp_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ena ma gologoloana ue abi abo ma gologoloana i torohai, ena maitawasora abo monena maena se torohai. ");
INSERT INTO swp_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ena ana tanuaga monena i mosei, monena ma nanatunayao abo ana tanuaga enanayao, na tau wa iabom abo i torohai. ");
INSERT INTO swp_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Na ena tauauau i riba masaraha i ene, ‘Agu tanuaga, eo monegu, eo nanatuguyao, ea gadosisiedi, nige ea henua bena se eairihaigu.’ ");
INSERT INTO swp_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Ana tanuaga abo i woeai Eaubada arinai, eo abo i leama dobila eai, eo dobila duna arinai, abo beana i gorilapai abagorilapai arinai; eo ena mauri huiana maudoina abo i heayaiyei. ");
INSERT INTO swp_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Ena tau esau natuna sine i unegabaei bena ia abo tauauau, taba nige se eairigabaei doha tatao tauauaudi. ");
INSERT INTO swp_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ena ana tanuaga nige nuana i helolo, eo nige ie abi iabom enana, abo gonoana se hemaisa eo se abiuio: nige i lolo i unegabaei hari eanua tataodi aridi eai; paana ia ena tupo nige i ginauri komakomani arinai. ");
INSERT INTO swp_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Eo taba i mosei natuna tau arinai abo i abi doha natuna sine. ");
INSERT INTO swp_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ena i tawasorauio, ana aiai, ana lulu, eo maitawasora miamiana abiabina tabu i hegagiri ia arinai. ");
INSERT INTO swp_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Na taba ina ginauri haiona nige i abidi, arinai i lolo sine wa abo i eairigabaei, taba nige maisana. ");
INSERT INTO swp_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Eai to eai tau esau i oi’ita to arinai ie mate, mamohoi ia abo se unui. ");
INSERT INTO swp_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Na ena nige i nahai, na Eaubada i torelaei ia nimana eai, abo dimo esau ea hineri bena ena abadago. ");
INSERT INTO swp_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Na ena tau esau nuana esega bena tau esau i oi’ita ma nuabaaeana i unui, abo egu aba‐aitalasam eai u laei hesuaraei, bena abo i mate. ");
INSERT INTO swp_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Eai to eai tamana e sinana i oi’itadi ia abo se unui. ");
INSERT INTO swp_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Eai to eai tau esau i aiyahari, eo i unegabaei, e taba nimana eai se lobai, abo se unui. ");
INSERT INTO swp_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Eai to eai tamana e sinana i ribahematedi mamohoi abo se unui. ");
INSERT INTO swp_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Ena tatao labui se lulu, eo esau ena doga i oi’ita we’u arinai, eo nige i mate, na aba‐eno eai mo i ota, ");
INSERT INTO swp_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ena i torouio i sae i dobi tu’e arinai, ia i oi’ita wa abo se eairigabaei, na ena huia gabaena debana eai abo i hemaisa, eo abo i riba bena se itawatai i lau e i lolo komakomani. ");
INSERT INTO swp_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Ena tau esau ena heaheari tauna e ena heaheari sinena i oi’ita oeagi arinai, to ia nimana eai ena heaheari wa i mate, mamohoi tau wa abo se hemaisa. ");
INSERT INTO swp_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Na ena heaheari tauna wa i mia asubena esega e labui, taba nige tanuaga se hemaisa, paana heaheari tauna wa ena gogo ede. ");
INSERT INTO swp_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Ena tatao labui se lulu eo sine bogabogana esau se heamamna to i boga tagodu, na nige baaea murina eai i hearo, mamohoi tauheamamnana maisa abo i tore gonogonoana doha sine wa monena i ribaei: tau hedudulai edi riba abo i lauwatai. ");
INSERT INTO swp_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Na taba baaea esau murina eai i hearo abo mauri se mosei ia maurina wa maisana. ");
INSERT INTO swp_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Mata helena mata maisana, moa helena moa maisana, nima helena nima maisana, ae helena ae maisana, ");
INSERT INTO swp_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","gabu helena gabu maisana, gai helena gai maisana, pidili helena pidili maisana. ");
INSERT INTO swp_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Ena tau esau ena tauauau matana i oi’ita, tau e sine, eo i hebaaea, tauauau abo i eairigabaei matana wa maisana. ");
INSERT INTO swp_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ena tauauau moana i oilosi, tau e sine, abo tauauau wa i eairigabaei moana debana eai. ");
INSERT INTO swp_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Ena bulumakau tau esau i gorihemate, bulumakau abo se lauwe’ui, na bulumana wa taba nige se ai, na tanuagana abo se eairigabaei. ");
INSERT INTO swp_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Na taba bulumakau kamanina, beabeana hinage dodoga i goridi, eo tanuagana se ribasanapuei na nige i tutugudui, eo tau e sine i unui, bulumakau wa abo se lauwe’ui eo tanauagana abo se unui. ");
INSERT INTO swp_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Taba ena mauri maisana se ribaei, tau wa maisa saha se ribaei abo i tore ena mauri maisana. ");
INSERT INTO swp_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ena tau esau natuna tau e natuna sine ie gori ena laugagaeo gonogonoana. ");
INSERT INTO swp_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ena bulumakau tauauau tau e sine ie gori bulumakau tanaugana moni silver sekela tau‐esega‐i‐mate‐saudoudoi abo i mosei tauauau tanuagana arinai, eo bulumakau wa abo se lauwe’ui. ");
INSERT INTO swp_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Ena tau esau duha ma awadabarina i laugabaei, e ena tau esau duha ie sara na nige awana i gudu, to bulumakau e asini i beu dobi alona eai, ");
INSERT INTO swp_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","duha tanuagana abo i hedudulai; moni abo i mosei suisui tanauagana arinai, na suisui matematena wa abo ia enana. ");
INSERT INTO swp_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Taba tau esau ena bulumakau doga esau ena bulumakau i hebaaea to ie mate, maumaurina wa abo se unegabaei eo maisana se soiei, suisui matematena hinage abo se soiei. ");
INSERT INTO swp_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","E taba abina se ata’o beabeana eai bulumakau ena kamani i gorigori, na tanauagana nige i tutugudui, bulumakau helena bulumakau maisana abo i hemaisa, eo suisui matematena wa abo ia enana. ");
INSERT INTO swp_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Ena tau esau bulumakau e mamoe i aiyahari eo i unui, e i unegabaei, abo bulumakau wa maisana bulumakau haligigi arinai abo i hedudulai, eo mamoe maisana hinage mamoe hasi arinai abo i hedudulai. ");
INSERT INTO swp_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","Tau aiyahari wa abo ena abiabigaibu i hedudulai; ena nige ena gogo, tau aiyahari wa abo se unegabaei ena abigaibu debana eai. Ena suisui i aiyahari wa se lobai ma maurina ia nimana eai, bulumakau e asini e mamoe, abo i hedudulai malabui. Ena tau aiyahari se lobai ma aiyaharina, to se lubi arinai i mate, taba nige osina giluna; na ena mara i uiariyao, eo hinage osinana se heboriri, abo hinage giluna. ");
INSERT INTO swp_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Ena tau esau oea esau e wine tanona esau ena riba eai suisui se ai, e ena suisui i eairigabaei bena doga esau ena oea eai i aibai, tau wa iabom ena oea masurina lolo aririna eai, e ena wine tanona masurina lolo aririna eai abo i hedudulai. ");
INSERT INTO swp_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Ena oea se gabu to nurinuri se ala, eo sitona se pei, e sitona sora nige se tom i gabu, ia oeagi ie gabu wa abo i hedudulai heohi. ");
INSERT INTO swp_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Ena tau esau moni e gogo i tore helena taumia tauna nimana eai bena i itawatai, na tau wa ena numa eai se aiyahari, ena tauaiyahari se lobai abo malabui i hemaisa. ");
INSERT INTO swp_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Na ena tauaiyahari wa nige se lobai, numa tanuagana wa abo i toro tauhedudulai matadi eai, bena se nuatulobai nimana i torelaei helena taumia ena gogo aridi eai, e nige’e. ");
INSERT INTO swp_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Ena pilipili saha, ena bulumakau, e asini, e mamoe, e lulu, e ginauri aisana i taueamui, eo doga esau i ene bena ia enana, abo tatao labui wa edi tupo se tore tauhedudulai matadi eai; abo aisega doga tauhedudulai wa se hegiru ia abo i hemaisa malabui helena taumiatauna arinai. ");
INSERT INTO swp_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Tabu tau esau ena asini, e ena bulumakau, e ena mamoe, e hari suisui, i tore helena taumia tauna nimana eai bena i itawatai, na ie mate, e se hebaaea, e se henau, eo nige esau i ita. ");
INSERT INTO swp_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Ena GUIAU matana eai i riba aigora nige i abilau helena taumia tauna ena gogo aridi eai, tanuagana abo ena riba aigora i awamamohoiei, eo taba nige i hemaisa. ");
INSERT INTO swp_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Na ena se aiyahari ia arinai abo i hedudulai tanauagana arinai. ");
INSERT INTO swp_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Na, ena suisui hemanabala i hebaaea, eo inata se hemasaraha komakomani, taba nige suisui se hebaaea wa maisana i tore. ");
INSERT INTO swp_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Tabu tau esau ginauri esana i sagenai helena taumia tauna arinai, eo se heamamna to ie mate, tanuagana nei eai nige’e, abo i hedudulai he’ohi. ");
INSERT INTO swp_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Na, ena tanuagana nei eai, nige hedudulaina: ena moni eai se sagenai maisana wa aba‐hedudulaina ede. ");
INSERT INTO swp_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Ena tau esau hasara nuanuasupuna i abi, ia sora nige se ribahepatu tau esau arinai, to ma’ena se eno, abo ena tawasora maisana i mosei, eo abo ia monena. ");
INSERT INTO swp_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Taba tamana i nuahi aririei tau wa arinai, abo hasara nuanuasupuna wa maisana i tore. ");
INSERT INTO swp_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Sine alaalawaina taba nige i mia. ");
INSERT INTO swp_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Eai to eai suisui ma’ena se eno abo se unui. ");
INSERT INTO swp_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Eai to eai eaubada udoi arinai i heaitalasam, na GUIAU iabom mo arinai, abo se unuhemate. ");
INSERT INTO swp_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Tabu hari eanua tauna au boraei, e au he’amamna, paana omi hinage laolaoma Aigupito eai. ");
INSERT INTO swp_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Tabu wabuwabu e dabudabure au heamamnadi. ");
INSERT INTO swp_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ena au heamamnadi, eo se dou saema arigu eai, eau hinage abo edi dou ea ataiedi. ");
INSERT INTO swp_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Egu ouyalayala abo i alasi, abo elepa eai ea unuimiu, monemmiuyao abo se hemala wabuwabu hinage eo nanatumiuyao abo dabudabure. ");
INSERT INTO swp_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Ena gogogesagesa tauna esau egu tatao boeadi eai moni i sagenai arim eai tabu nuam u he’oiura, doha ia tau abihagahaga, eo tabu i hemaisadioim. ");
INSERT INTO swp_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ena helem taumia tauna ena lulu ue abi bena ena ribahesunuma heiheinoina, mahana sora nige ie dui abo u moseuioi. ");
INSERT INTO swp_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Paana meta ena abobo esegana, tauna ana lulu, saha arinai abo i enoei? Ena i dousaema arigu eai abo ea ataiei paana egu nuatoatoa ie lai. ");
INSERT INTO swp_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Tabu Eaubada au ribahebaaea, eo tatao adi tanuaga tabu au ribahemate. ");
INSERT INTO swp_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Tabu au bebeda emi masuri ena lolo eo emi waina ena lolo bena au aitalalsamdi. “Emi ealahou tatao abo hinage au ledima arigu eai. ");
INSERT INTO swp_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Gonogonoana doha emi bulumakau eo emi mamoe aridi eai; asubena haligigi‐labui abo sinana arinai, na asubena hehaligigi‐haionana eai abo au leama arigu eai. ");
INSERT INTO swp_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Omi abo hetabu tataomiu eau arigu eai: arinai suisui bulumana oea eai se purisi tabu au ai. Abo au gabalaei kedewa aridi eai. ");
INSERT INTO swp_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Tabu ribaborabora u bahebahe’usei. Tabu taubaaea maem nuamiu esega bena oa tauitaita borabora. ");
INSERT INTO swp_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Tabu moutuana u lauwataidi bena baaea u ginauri, eo hinage abahedudulai eai moutuana tabu edi tupo eai u toro bena saha eo saha i dudulai u laei’udoiei. ");
INSERT INTO swp_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Gogogesagesa tauna hinage arinai tabu u hebiga aba‐hedudulaina eai. ");
INSERT INTO swp_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Ena em waiunu ena bulumakau e ena asini, ue ita i gegegegeusi, i lolo abo u woeaiuioi ia arinai. ");
INSERT INTO swp_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ena ia i hewaiunuem ena asini u ita ana bahebahe poroporohena i oitawai, eo bena u nuahiuioim na i ota, mamohoi mo abo u lau sagui. ");
INSERT INTO swp_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Gogogesagesa tauna ena pilipili heduduraina tabu u gudugudui. ");
INSERT INTO swp_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Hegiru borabora u lausuara aririei, eo tau nuasupusupu eo tau laulaudurai tabu u unuidi: paana tau baaea taba nige ea eairigabaei. ");
INSERT INTO swp_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Tabu nua’oi maisana u abi, paana nua’oi maisana tau matalala i hegibudi, eo debana eai tatao laulau dudurai abo se ribaborabora. ");
INSERT INTO swp_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Tabu laolaoma tauna u heamamna: mamohoi omi laolaoma tauna abina au ata’o, paana omi laolaoma tataodi Aigupito eanuana eai. ");
INSERT INTO swp_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Borimai haligigi‐esega boeadi eai em tano abo u umai, eo masurina abo u tanogogoi, ");
INSERT INTO swp_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","na borimai hehaligigi‐labuina eai abo i aiyawasi eo i mutawa em tatao gogogesagesa bena arinai se ai; eo saha se abitore nuura suisuidi abo se ai. Em abiabi gonogonoana hinage em waina tanona arinai, eo em olive oeana eai. ");
INSERT INTO swp_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Asubena haligigi‐esega boeadi eai abo u paisoa, eo asubena hehaligigi‐labuina eai abo u aiyawasi: em bulumakau eo em asini abo hinage se aiyawasi, em heaheari sinena natuna eo hari eanua tauna abo hinage edi amna lolo se abiuiodi. ");
INSERT INTO swp_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Saha eo saha ea heribamiu abo au komakomani: tabu eaubada headi esadi au ataidi, eo tabu hinage se ataiedi oa awam eai. ");
INSERT INTO swp_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Borimai boeana eai ma haiona egu mataasi abo u ginauridi. ");
INSERT INTO swp_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Falawa nige ie sese mataasina abo au abididini: asubena haligigi‐labui falawa nige i sese abo u ai doha ea lauhesom wa, huiana wa ea ribaei Abibi nawaraina eai, paana nawarai me arinai Aigupito au torohaigabaei. Tabu esau ma nima’aha’ahana i toro matagu eai. ");
INSERT INTO swp_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Masuri mataasina abo hinage u abididini oea eai am paisoa uauadi bagubagunadi, iaede oea eai u umaidi wa abo borimai anasigana eai em tanogogo mataasina huiana eai ne am paisoa uauadi oea eai tanogogoina. ");
INSERT INTO swp_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Borimai boeana eai mahaiona em tatao gamagaridi abo se toro masaraha Guiau EAUBADA matana eai. ");
INSERT INTO swp_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Egu aitalasam osinana tabu u leama falawa ie sese wa maena: egu mataasi momonana hinage tabu i ota maiona maudoina i lau e mara ie tom. ");
INSERT INTO swp_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Em oea uaua bagubagunadi lolo‐dumadumadi abo u ledima GUIAU em Eaubada ena numa eai. “Suisui natuna tabu u riga esegai sinana susuna boeana eai. ");
INSERT INTO swp_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“U ita, aneru esau abo ea hetamari matam eai bena dobila eai abo i ganaganaim, eo i woeaim eanua ea abinonohai wa arinai. ");
INSERT INTO swp_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Ia au nuatui komakomani, eo ena riba au awa’abiei, tabu au oipiliei, paana emi baaea taba nige i ribagigiri; paana esagu ia boeana eai. ");
INSERT INTO swp_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","“Na ena u ata’atai komakomani, eo ia arinana u awa’abiei em waiunu abo eau ea hewaiunuedi, eo isi se ialaim eau abo ea ialaidi. ");
INSERT INTO swp_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","“Egu aneru abo i edabagunaem, abo i woeaim Amore, Hito, Perisi, Kanana, Hiwi eo Iebusi tataodi aridi eai, abo nimagu eai ea saugabaedi. ");
INSERT INTO swp_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Edi eaubada tabu u taba’ohuidi, e u heayaiyedi na abo u oiheguri mamaohoiedi, eo edi we’u dudi abo u hetamagorugorudi. ");
INSERT INTO swp_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","GUIAU em Eaubada abo au heayaiyei, eo am falawa eo am goila abo ea ribahelolo, asiebo boeamiu eai abo hinage ea abihai. ");
INSERT INTO swp_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Taba nige esau em eanua eai i boga tagodu e i agari; abo em mauri asubenadi ea hegamagaridi. ");
INSERT INTO swp_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Egu matausi lailaididigana abo ea hetamari matam eai, tatao gamagaridi emi abalau eai abo ea hetatagorigoridi, am waiunu abo se dago tatadagedagela matam eai. ");
INSERT INTO swp_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Gumo abo ea hetamaridi matam eai bena Hiwi, Kanana eo Hito tataodi se aihenaudi. ");
INSERT INTO swp_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Taba nige borimai esega boeana eai ea aihenauidi ata eanua i hemala barabara, eo suisui manamanabaradi se gamagari ariri se hemala am waiunu. ");
INSERT INTO swp_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Benai benai abo ea henauidi matam eai, i lau e u tadada eo eanua u abi enam. ");
INSERT INTO swp_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Abo am sigasiga ea hetorodi Gabogabo Buiabuiana eai i lau e Pilistia edi gabogabo eai, eo hinage barabara i lau e saga eai, paana eanua tataodi abo ea lediwa nimam eai eo abo ea aihenauidi matam eai. ");
INSERT INTO swp_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Tabu em ribahesunuma u ginauri aridi eai, eo edi eaubada aridi eai. ");
INSERT INTO swp_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Taba nige em eanua eai se mia, ata se hebeum eo baaea u ginauri arigu eai; paana ena edi eaubada u heayaiyedi mamohoi abo i hemala sa’i arim eai.” ");
INSERT INTO swp_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","I ribalau Mose arinai i ene, “Au saema GUIAU arinai, oa eo Arona, Nadabi, eo Abihu, eo Isaraela babadayao tatao‐haiona‐se‐mate‐saudoudoi: eo eda lohaloha eai abo au aihelahui. ");
INSERT INTO swp_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Mose iabom abo GUIAU i hanahanaui, na isi taba nige se hanahanaui, tatao hinage taba nige maenayao se saema. ");
INSERT INTO swp_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mose i laoma tatao i heribadi saha eo saha GUIAU i ribaei, eo laugagaeo gamagaridi hinage; abo tatao gamagaridi se heuio arinadi esega, si ene, “Riba gamagaridi GUIAU i ribaedi meta abo ai lauwataidi.” ");
INSERT INTO swp_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Arinai Mose GUIAU ena riba gamagaridi i uridi, abo maratomtom ariri eai i enotoro eo aba‐aitalasam i hetoro oea paana eai, du saudoudoi‐labui hinage, Isaraela ana bogao enadi. ");
INSERT INTO swp_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Eo Isaraela edi hewahewari i hetamaridi, bena aitalasam gabugabudi, eo labini aitalasamdi, isi ede bulumakau, se heaitalasamdi GUIAU arinai. ");
INSERT INTO swp_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Eo Mose osina tupona ie abi ie tore gulewa alodi eai eo osina tupona i lausibusibuei aba’aitalasam potana eai. ");
INSERT INTO swp_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Murina eai ribahesunuma bukana ie abi eo i hasiri tatao edi ata’atai eai: to si ene, “Saha eo saha GUIAU i ribaedi meta abo ai ginauriwatai, eo abo ai awa’abiedi.” ");
INSERT INTO swp_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Eo Mose osina ie abi i lausibusibuei tatao potadi eai, i ene, “Au ita, ina ribahesunuma osinana ede, ia ede GUIAU i ginauriyao arimiu eai ina riba aridi eai.” ");
INSERT INTO swp_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Arinai Mose, Arona, Nadabi, Abihu eo Isaraela edi babadayao tatao‐haiona‐se‐mate‐saudoudoi se sae. ");
INSERT INTO swp_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Abo Isaraela edi Eaubada se ita, eo aena ubuna eai doha we’u matuna namanamarina, eo hinage i masaraha ariri doha galewa mamohoina. ");
INSERT INTO swp_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Nimana hinage nige i lausini Isaraela edi babadayao potadi eai, na Eaubada se ita, eo se ai eo se nom. ");
INSERT INTO swp_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","GUIAU abo i ribalau Mose arinai i ene, “U saema oea tupina eai, eo nei eai u bagibagi: eo we’u lailaidi tabatabadi abo ea lediwa, potadi eai lauhesom eo laugagaeo ea uridi wa, bena u lauheataedi.” ");
INSERT INTO swp_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Arinai Mose i torohai maena heaheari Iosua, eo Mose ie sae Eaubada ena oea tupina eai. ");
INSERT INTO swp_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","I ribalau babadayao aridi eai, hinage i ene, “Ina au bagibagiemai, i lau e ai uioma arimiu eai: au nuatui Arona eo Hura maemiuyao, ena esau ena pilipili saha abo i lau aridi eai. ");
INSERT INTO swp_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Arinai Mose ia sae oea tupina eai, eo eada wa arinai oea i buburi heohi. ");
INSERT INTO swp_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","GUIAU ena namanamari ie ota Sinai oea tupina eai, eo eada wa i buburi asubena haligigi‐esega. Abo asubena hehaligigi‐labuina eai eada wa boeana eai i eogalau Mose arinai. ");
INSERT INTO swp_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Na GUIAU ena namanamari ana ao Isaraela tataodi matadi eai doha oeagi ala’alabalebalelemna oea tupina potana eai. ");
INSERT INTO swp_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Eo Mose i soralau eada wa boeana eai, eo ie sae oea tupina eai. Mose hinage oea tupina eai wa ie mia asubena tatao‐labui‐se‐mate eo maiona tatao‐labui‐se‐mate. ");
INSERT INTO swp_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Mose, Guiau ena heaheari, ena mate murina eai, Guiau i ribalau Iosua, Nuna natuna, Mose ena heaheari arinai, i ene, ");
INSERT INTO swp_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Dimo gamagaridi aemiu aba utu ena, iaede ea lediva, doha Mose ea heriba va. ");
INSERT INTO swp_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Barabara, eo teina Lebanani eai ie tubu, i lau e saga lai Eupatari eai, Hitaiti edi tano gamagaridi, i lau e gabogabo lailai mahana ena aba dui va, emi geregere meta. ");
INSERT INTO swp_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Em mauri asubenadi gamagaridi taba nige tau esau matam eai i toro: doha eau Mose maedana, eau hinage maedam: taba nige ea boraim, taba nige ea nuagabaem. ");
INSERT INTO swp_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","U adidiri abo, eo u nuakipikipi: paana oea va teina tatao enadi abo u soi, doha tamadieao aridi eai ea aigoraeao, ea ne abo ea mosedi. ");
INSERT INTO swp_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Oa mo u adidiri abo, eo u nuakipikipi ariri, bena laugagaeo ohina egu heaheari Mose i lauhesom abo u abivataidi: laugagaeo va teha tutu, eo teha seuseuri tabu u lausuaraei, em aba lau gamagamagaridi eai abo u tubu bena. ");
INSERT INTO swp_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Teina laugagaeo bukana avam eai tabu i lautom: asubena to maieona, riba va u nuanuatuidi, abo u abivataidi hinage: abo em dobila i masaraha, eo em ginauri abo se loroesegai. ");
INSERT INTO swp_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Eau ea lauhesom va, e nigee? U adidiri abo, eo u nuakipikipi: tabu u matausi, tabu aruam se loi; paana ede Guiau em Eaubada maem, em aba lau gamagamagaridi ena. ");
INSERT INTO swp_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","11","Iosua edi babada i heribakomakomanidi, i ene, Aiai au abinonohai, asubena haiona matada eai Ioridano abo au gaeoavasi, oea va abo au abi, Guiau emi Euabada abo i reava enamiu. ");
INSERT INTO swp_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","15","Iosua i ribalau Reubena, eo Gada, eo Manasa boganaeao tupona aridi eai, i ene, Eaubada i heaiavasimiuo, emi tano i ledivao: monemiueao, eo nanatumiueao, eo emi sarai se ota va teina oea eai ta Mose i ledivao Ioridano teina teha eai: ma alahiamiu omi tauiala gamagarimiu au gaeoavasi emi tataoeao matadi eai, au saguidi i lau e, Guiau emi tataoeao i heaiavasidi hinage, edi tano hinage se abi Guiau emi Eaubada abo i mosedi. E, abotai abo au uioma, emi tupo eai au miakomani. ");
INSERT INTO swp_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","Isi Iosua se heuio, si ene, Ginauri gamagaridi u lauhesomai abo ai abidi: hari teha, hari teha u hetamarimai abo hinage ai lau. ");
INSERT INTO swp_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","Doha Mose ena riba gamagaridi ai ataiedi, em riba hinage abo ai ataiei: Guiau ema Eaubada abo maem, doha hinage ia Mose maena. ");
INSERT INTO swp_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","Eai to eai em laugagaeo i avaeagaraei, em riba gamagaridi aridi eai u lauhesomai nige i ataiedi, abo se unuhemate: oa mo u adidiri, eo u nuakipikipi abo. ");
INSERT INTO swp_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Iosua, Nuna natuna, Sitimi eai tatao labui i hetamarimodigaui, i ene, Au lau Ieriko eai, oea va au itasipoi. Isi se lau sine baaea esau, esana Rahaba, ena numa eai se lage, arinai se eno. ");
INSERT INTO swp_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Ieriko edi vasavasa se heriba si ene, Maieona ta tatao labui, Isaraela nanatunaeao se lagema, eda oea se itasipoi. ");
INSERT INTO swp_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","Ieriko edi vasavasa, headi i hetamaridi Rahaba arinai i ene, Tatao va se laoma em numa eai se avasae, u woeaidima, se laoma bena eda eanua se itasipoi. ");
INSERT INTO swp_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","Sine va taodi‐labui i laedi i toreamuidi, abo enaba, Tatao va se laoma arigu eai, edi aba laoma nige ea nuatui: ");
INSERT INTO swp_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","Dobila guduna edi huia gudugudui va, i maieonao tatao va se pesa murimuri eai: edi lau hinage nige ea nuatui: au hemurivataheulaidi; abo au hemuridi nuana. ");
INSERT INTO swp_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","Ia mo numa evana eai i woeaidi, eba, numa evana eai i torenonohaidi, boeana eai i toreamuidi. ");
INSERT INTO swp_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Tatao headi taodi‐labui va se hemuritaidi Ioridano edana eai, i lau e saga aba gaeoavasina eai: tau lau va se pesa eanua murimuri eai, gudu abo se gudui. ");
INSERT INTO swp_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Taodi‐labui sora nige se eno, sine va i avasae i laoma aridi eai numa evana eai. ");
INSERT INTO swp_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","I ribalau tatao aridi eai i ene, Ea nutuiao Guiau tano ta i leava, debamiu eai matausi lailai ai hearo, eanua ta tataodi se beruberu ariri paana se matausiemiu. ");
INSERT INTO swp_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","Vasa va ai ataieao doha Guiau Gabogabo Buiabuiana i hepitari matamiu eai, omi Aigupito eai au laoma va: emi laulau hinage Amoraiti edi vasavasa labui, Sihona eo Oga aridi eai, Ioridano hari teha eai, au hebaaeaaririedi va. ");
INSERT INTO swp_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Vau va ai ataieao atemai se taigari, eo nige tau esau arimai eai i adidiri, se matausiemiu: paana Guiau emi Eaubada ia gareva evana edi Eaubada, eo tanoubu hinage edi Eaubada. ");
INSERT INTO swp_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","Arinai ea aibodaimiu, Guiau debana eai arigu eai au aigora, doha ea bobodiemiu ta omi abo tamagu ena numa tataodi au nuatuidi hinage, heiheinoi mamohoi abo au reama. ");
INSERT INTO swp_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","Tamagu eo sinagu, rougueao eo egu dodogaeao, enadi tatao hinage abo au hemaurimai, mate eai abo au hemaurimai. ");
INSERT INTO swp_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Tatao va ia se heuio si ene, Ema mauri doha emi mauri, vau ema laoma paana taba nige u ribaribaemai va. Mamohoi Guiau oea ta i reama enamai abo ai nuatuim, mamohoi ema abi abo se loro mo arim eai. ");
INSERT INTO swp_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Arinai tomlapai eai i hedavedobedi: ena numa eanua ganana eai se abi, gana evana eai ie mia. ");
INSERT INTO swp_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","I ribalau aridi eai i ene, Au lau oea tupina eai au mia, ata tatao se henaumiu va se lobaimiu, nei eai asubena haiona au miaeamui, vau tatao va se lauo hesabamiu va se uioma, abotai abo emi dobila eai au lau. ");
INSERT INTO swp_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","Tatao va ia se heriba si ene, Vau aigora va ai aigora arim eai taba nige u hegirumai. ");
INSERT INTO swp_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","U nuatui ai laoma oea eai ta, tomlapai eai arinai u hedavedobemai teina maina buiabuia ta u auhepatui: tamam eo sinam, eo roumeao, tamam ena numa tataodi hinage, gamagaridi u heoigogodima arim eai. ");
INSERT INTO swp_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","E, esa, esa em numa eai i pesa murimuri eai i lau eda eai, ia osinana iabom i heboriri, ai nige ama giru: esa, eo esa maem numa eai aue mia ena nimadi eai se hebaaeadi ama giru meta ");
INSERT INTO swp_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Ema laoma paana ena u vasavasaei vau aigora va besi i ota va. ");
INSERT INTO swp_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","Ia abo i ene, Taiede, emi riba ta nuatuvatai. Abo i hetamaridi se lau: maina buiabuiana abo i auhepatunonohai tomlapai eai. ");
INSERT INTO swp_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Se lau e, abo se lage oea tupina eai, asubena haiona nei eai se mia, i lau e tauaihenau se uio: tauhenaudi va dobila se lau e, sigasigana eai, se eooasaaidi. ");
INSERT INTO swp_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Taodi‐labui abo se uio, oea tupina eai se leta, se gaeoavasi, se laoma Iosua, Nuna natuna arinai, vasa gamagaridi ia arinai se vasavasaei. ");
INSERT INTO swp_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","Se ribalau Iosua arinai si ene, Mamohoi, oea maudoudoina Guiau nimada eai i ledima, eanua tataodi gamagaridi debada eai se beruberu ariri. ");
INSERT INTO swp_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Mara ie uiari Iosua ie toro; Sitimi se laugabaei abo Ioridano eai se lagema, ia eo Isaraela nanatunaeao gamagaridi hinage, nei eai se bava, sora nige se gaeoavasi. ");
INSERT INTO swp_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Asubena haiona se ohi, edi babadaeao se lau edi oigogo boeadi eai: ");
INSERT INTO swp_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","Tatao se lauhesomdi, si ene, Guiau emi Eaubada ena ribahesunuma akena au ita, eo kohena eo Levi tataodi se bahebahei, dimo va arinai au bava au laugabaei ake va murina eai au lau. ");
INSERT INTO swp_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Tabu au lau gegesina eai, emi dobila abo i heitamiu: paana nabada va teina dobila eai ta nige au laulau arinai. ");
INSERT INTO swp_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Iosua i ribalau tatao aridi eai, i ene, Au hetabuemiu: maraitom laulau noonoodi Guiau abo i hetubudi boeamiu eai. ");
INSERT INTO swp_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Iosua i ribalau kohena tataodi aridi eai i ene, ribahesunuma akena au abi, tatao matadi au gaeoavasi. Isi ribahesunuma akena se abi tatao matadi eai se lau. ");
INSERT INTO swp_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Guiau i ribalau Iosua arinai, i ene, Vau ta Isaraela gamagaridi matadi eai abo ea hedebasaem, abo se nuatui doha eau Mose maena, eau hinage abo maem. ");
INSERT INTO swp_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Kohena tataodi ribahesunuma akena taubahebahei u lauhesomdi u ene, Ioridano goilana laopaana eai au lage, abo au totoro Ioridano eai. ");
INSERT INTO swp_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Iosua i ribalau Isaraela nanatunaeao aridi eai i ene, Au laoma, Guiau emi Eaubada ena riba au ataiei. ");
INSERT INTO swp_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","Teina ta arinai abo au nuatui Eaubada maumaurina maemiu: hari tatao, hari tatao, matamiu eai taba i henaudi, Kanana tataodi, eo Haivaiti, eo Peresaiti, eo Gegasaiti, eo Amoraiti, eo Gebusaiti, abo i hetatagorigoridi. ");
INSERT INTO swp_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","Ia ede tanoubu maudoudoina edi Guiau ena ribahesunuma akena Ioridano eai se heavasi matamiu eai. ");
INSERT INTO swp_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","Isaraela adi bogao aridi eai tatao saudoudoi‐labui au hetorodi, hari boga tau esau, hari boga tau esau. ");
INSERT INTO swp_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","Iosua tatao i heribadi i ene, kohena Guiau ena ake taubahebahei aedi se hebutadi Ioridano goilana eai, goila va abo i didilautom, i pei esega tupo saesaena eai. ");
INSERT INTO swp_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","Tatao edi numa se abihaidio bena Ioridano se gaeoavasi, kohena, matadi eai ake se bahei. ");
INSERT INTO swp_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","16","Ioridano goilana eai se lagema aedi se hebutadi, goila abo i didilautom, goila tupo dobidobi eai abo i guma: tatao abo se gaeoavasi Ieriko hanahanauna eai. ");
INSERT INTO swp_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Ioridano duaduarina eai kohena ake taubahebahei se totoro. Isaraela gamagaridi tano pitapitarina eai se gaeoavasi, i lau e, se gaeoavasiohi. ");
INSERT INTO swp_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","Tatao gamagaridi Ioridano eai se gaeoavasieao, Guiau i ribalau Iosua arinai, i ene. ");
INSERT INTO swp_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","Tatao saudoudoi‐labui u hetorodi hari bogao tau esega, hari bogao tau esega. ");
INSERT INTO swp_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","U lauhesomdi, u ene, Ioridano duaduarina eai kohena va edi aba totoro, veu saudoudoi‐labui au abidi, au bahedi, iboni emi aba eno au toredi. ");
INSERT INTO swp_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","Iosua tatao‐saudoudoi‐labui va i eogaidi, isi Isaraela nanatunaeao aridi eai i hetorodi va, hari bogao tau esega, hari bogao tau esega. ");
INSERT INTO swp_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","Iosua ie ribalau aridi eai, i ene, Guiau emi Eaubada ena ake matana eai au gaeoavasi, esau, esau ena veu dobaiarona eai i laei, doha Isaraela nanatunaeao adi bogao ta hasiridi: ");
INSERT INTO swp_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","Emi heiheinoi teina, maraitom‐asubena nanatumiueao se oimuri si ene, Teina veu aisana? ");
INSERT INTO swp_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","Abo au heuioidi, au ene, Guiau ena ribahesunuma akena se heavasi Ioridano eai, goila i didilautom, teina veu ta Isaraela nanatunaeao edi aba nuanuatuina i lau e, nige nosina. ");
INSERT INTO swp_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","Isaraela nanatunaeao Iosua ena riba se lauvataidi, Ioridano duaduarina eai veu saudoudoi‐labui se abidi, doha Guiau Iosua i heriba, adi bogao saudoudoi‐labui se hegonoahidi, se laedi edi aba eno eai, nei eai se toredi. ");
INSERT INTO swp_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","Iosua veu saudoudoi‐labui Ioridano duaduarina eai i tarinidi, kohena va ribahesunuma akena taubahebahei edi abo totoro va arinai se otahai, i laoma, i laoma e, huia ta. ");
INSERT INTO swp_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","Kohena ake taubahei Ioridano duaduarina eai se totoro i lau e, ginauri gamagaridi Guiau Iosua i lauhesom va tatao i heribaheohi, eo Mose hinage Iosua i lauhesom va i heribaheohidi: abo tatao se gaeoavasiheulai. ");
INSERT INTO swp_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","Tatao gamagaridi se gaeoavasiohieao abo Guiau ena ake se laei, eo kohena tataodi se gaeoavasi hinage tatao matadi eai. ");
INSERT INTO swp_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","Reubena nanatunaeao, eo Gada nanatunaeao, eo Manasa boganaeao tupona, Isaraela nanatunaeao matadi eai se gaeoavasi, doha Mose i heribadi. ");
INSERT INTO swp_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","Tatao tausani tatao‐labui Guiau matana eai se gaeoavasi, se lau Ieriko gonuna eai. ");
INSERT INTO swp_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","Nei asubenana ne Guiau Iosua i hedebasae Isaraela gamagaridi matadi eai, ia se heasisiei, doha Mose se heasisiei ena mauri asubena gamagaridi eai. ");
INSERT INTO swp_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","Guiau i ribalau Iosua arinai, i ene, ");
INSERT INTO swp_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","Kohena, ribahesunuma akena taubahebahei u lauhesomdi, isi Ioridano eai se gaeosaema. ");
INSERT INTO swp_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Arinai Iosua kohena i lauhesomdi, i ene, Ioridano eai au gaeosaema. ");
INSERT INTO swp_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","Kohena, Guiau ena ribahesunuma akena taubahebahei, Ioridano duaduarina eai se gaeosaema se totoro tano pitapitarina eai, Ioridano goilana edi dobila abo se lauvatai, laopaana se heboriri doha bagubaguna va. ");
INSERT INTO swp_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","Navarai heesegana eai, asubena hesaudoudoina eai, tatao Ioridano eai se gaeosaema Giligali eai se mia, Ieriko tupo aruabo eai. ");
INSERT INTO swp_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Veu va saudoudoi‐labui Ioridano eai se abidi va, Iosua Giligali eai i tarinidi. ");
INSERT INTO swp_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","I ribalau Isaraela nanatunaeao aridi eai i ene, Maraitom‐asubena nanatumiueao tamadi se oimuridi si ene, Teina veu aisadi? ");
INSERT INTO swp_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","Nanatumiueao abo au heribadi au ene, Teina Ioridano eai Isaraela tano pitapitarina eai se gaeoavasi. ");
INSERT INTO swp_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","Paana Guiau emi Eaubada, matamiu eai Ioridano goiladi i hegumadi, i lau e, au gaeoavasi, doha hinage Guiau emi Eaubada ena laulau matamai eai Gabogabo Buiabuia i hepitari i lau e, ai gaeoavasi: ");
INSERT INTO swp_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","Bena tatao gamagaridi tanoubu eai ta Guiau nimana abo se nuatui, si ene i didiga, omi hinage bena Guiau emi Eaubada au matausiei nige nosina. ");
INSERT INTO swp_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Amoraiti tataodi edi vasavasa gamagaridi Ioridano teha lalasi eai, so Kanana edi vasavasa gamagaridi hinage gabogabo tehana eai, vasa va se ataieao Guiau Isaraela nanatunaeao matadi eai Ioridano goiladi i hepitaridi, i lau e, se gaeoavasieao, nuadi se beruberu ariri, eo arudi se loi; Isaraela nanatunaeao se matausidi. ");
INSERT INTO swp_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","9","Isaraela nanatunaeao Aigupito se laugabaei se heperetomedio: isi gamagaridi barabara eai se mateo va. Isi Kanana taulagema barabara eai se labasidi sora nige se heperetomedi. Arinai Guiau i ribalau Iosua arinai i ene, Isaraela nanatunaeao u heperetomedi. Gamagaridi abo se heperetomedi. ");
INSERT INTO swp_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Isaraela nanatunaeao Giligali eai se miamia, asubena hesaudoudoi‐hasina eai pasova se ai Ieriko gonuna eai. ");
INSERT INTO swp_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Pasova se ai e, maraitom nei eanua godibuna se aidi, keki nige obue se tore hinage, eo godibu se gabu hinage nei asubenana eai. ");
INSERT INTO swp_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Maraitom hinage nei eanua godibuna se ai, mana abo i lautom, Isaraela nanatunaeao mana nige se aiuio: Kanana tanona aiaina meta borimai abo se aidi. ");
INSERT INTO swp_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Iosua Ieriko hanahanauna eai i toro, i sanaloro, tau esau i ita nuanuana eai i totoro ena elepa nimana eai i abi nonohai. Iosua i lau ia arinai, i ribalau i ene, Abo u saguimai e, ama vaiunu abo u saguidi? ");
INSERT INTO swp_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","I ene, Nigee, eau Guiau moutuana edi kapena ede ea laoma ta. Iosua tano eai ie guri matana eai i aihelahui, i ribalau ia arinai i ene, Egu Guiau ena heaheari arinai i ene edoha? ");
INSERT INTO swp_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Guiau moutuana edi kapena Iosua i heriba i ene, Em aeum u abihaidi: em aba toro ta ie tabuna. Iosua ena aeum i abihaidi. ");
INSERT INTO swp_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Ieriko gudadi se guduguduidi paana Isaraela nanatunaeao: nige tau esau i pesa, eo nige tau esau i avasae. ");
INSERT INTO swp_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Guiau i ribalau Iosua arinai i ene, Ieriko nimam eai abo ea reava, eo edi vasavasa hinage, edi tatao iala adidiri hinage. ");
INSERT INTO swp_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Omi tauiala gamagarimiu eanua va abo au hetaiiri. Asubena haligigi‐esega hinage eanua abo u hetaiiri. ");
INSERT INTO swp_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Kohena tataodi haligigi‐labui ake matana eai bogigi haligigi‐labui mamoe taumoana donadi se laedi: asubena hehaligigi‐labuina eai eanua abo au hetaiiri ma haligigi‐labui, kohena va bogigi se iuhidi. ");
INSERT INTO swp_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Isi mamoe donadi bogigidi se iuhidi adidiri, arinana au ataiei tatao gamagaridi abo se wowo adidiri: eanua ganana abo i beugorigoriesegai, tatao abo se avasae, esau, esau, matana eai i laududurai. ");
INSERT INTO swp_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Iosua, Nuna natuna, kohena i eogaidi i ribalau aridi eai i ene, Ribahesunuma akena au abihai, kohena haligigi‐labui au hetorodi bogigi mamoe donadi haligigilabui Guiau ena ake matana eai se laedi. ");
INSERT INTO swp_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Eo i ribalau tatao aridi eai i ene, Au lau eanua au hetaiiri, isi tatao ma alahiadi se lau Guiau ena ake matana eai. ");
INSERT INTO swp_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","Iosua tatao aridi eai i ribalautom abo kohena haligigi‐labui mamoe donadi bogigidi se abidi va Guiau matana eai se lau, bogigi se iuhidi: Guiau ena ribahesunuma akena i hemuridi. ");
INSERT INTO swp_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","Tauiala ma alahiadi, kohena bogigi se iuhidi matadi eai se lau, isi se murimurita ake murina eai se laoma, kohena va se baguna bogigi se iuhidi. ");
INSERT INTO swp_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Iosua tatao i lauhesomdi i ene, Tabu au wowo, tabu arinamiu, tabu avamiu au dabari i lau e, asubena esau ea heribamiu ea ne au wowo, e abo au wowo. ");
INSERT INTO swp_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Guiau ena ake eanua i hetaiiri ma esega: se uioma edi aba miamia eai, arinai se bava. ");
INSERT INTO swp_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","Mara‐ie‐tom Iosua i toro heuheula, kohena Guiau ena ake se abihai. ");
INSERT INTO swp_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","Kohena haligigi‐labui mamoe donadi bogigidi se abidi, huia gamagari se lau Guiau ena ake matana eai, bogigi se iuhidi: eo tatao ma alaalahiadi se bagubagunaedi, isi se murimuritama, Guiau ena ake murina eai se laoma, kohena se laulau, eo bogigi se iuhidi. ");
INSERT INTO swp_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Asubena helabuina eai ma esega eanua se hetaiiri abo se uio edi aba mia eai: hinage se abi doha nei asubena haligigi‐labui. ");
INSERT INTO swp_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Asubena hehaligigi‐labuina eai, mara‐ie‐tom se toro heuheula, ma haligigi‐esega eanua se hetaiiri, nei asubenana ne ma haligigi‐labui eanua se hetahetaiiri. ");
INSERT INTO swp_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Se hetaiiri ma haligigi‐labui va kohena bogigi abo se iuhidi, Iosua i ribalau tatao aridi eai i ene, Au wowo: Guiau eanua ta i reava. ");
INSERT INTO swp_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Eanua ta abo se goraei, eanua, eo ginauri gamagaridi boeana eai Guiau enana: Rahaba, sine baaea va, iabom abo i mauri, ia, eo helena tau mia gamagaridi hinage, paana tatao ta hetamaridi va i toreamuidi. ");
INSERT INTO swp_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","Au nuatui ginauri se goraidio tabu au abidi, ginauri baaea au abidi ata au baaea hinage, Isaraela maudoudoina ata au hebaaeadi hinage. ");
INSERT INTO swp_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Ario, eo auro, barasi, eo poasi kaputi gamagaridi Guiau arinai se hetabuedi: Guiau ena aba pei eai abo ta toredi. ");
INSERT INTO swp_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Kohena bogigi se iuhidi va, tatao abo se wowo: tatao bogigi arinadi, ea tatao se wowo adidiri arinadi se ataiei, eanua ganana i talopagorigori, arinai tatao eanua se avasae gaibui, esau, esau i lau dudurai matana eai, eanua va abo se girihai. ");
INSERT INTO swp_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Ginauri gamagaridi eanua eai se hebaaeadi, tau eo sine, hevahevari, eo tautaubada, bulumakau, eo mamoe, eo asina se lauelepaidi. ");
INSERT INTO swp_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Iosua tatao‐labui va nabada oea va se itasipoi, i heribadi i ene, Au avasae sine baaea va ena numa eai, sine va, eo ena ginauri gamagaridi au woealaei murimuri eai, doha ia arinai au aigorao. ");
INSERT INTO swp_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Hevahevari va, tauitasipo, se avasae numa alona eai Rahaba se woealaei murimuri eai: eo tamana, eo sinana hinage, eo rounaeao, eo ena ginauri gamagaridi, helena taumia gamagaridi se woealaedi murimuri eai, Isaraela edi aba mia murina eai se toredi. ");
INSERT INTO swp_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Eanua va oeagi alaalasina eai se gabu, eo ginauri gamagaridi boeana eai: ario, eo auro, eo barasi, eo poasi kaputi, Guiau ena numa aba peina eai se toredi. ");
INSERT INTO swp_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Iosua Rahaba, sine baaea, i abihemauri, tamana ena numa tataodi hinage, eo ena ginauri gamagaridi, Isaraela aridi eai ie mia i laoma, i laoma, e, teina asubena eai ta, paana tauitasipo Iosua i hetamaridi Ieriko bena se itasipoi, i toreamuidi. ");
INSERT INTO swp_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Nei huiana ne Iosua i lauhesomdi i ene, Ena tau esau maraitom asubena teina eanua, Ieriko, i abiuio, Guiau matana eai tau va abo i baaea, numa paadi i ginauri abo natuna taubaguna i taueamui, hinage dobila gududi i toredi natuna taumurita abo i taueamui. ");
INSERT INTO swp_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Guiau Iosua maena: oea se hetaiiri ia vasana se ribaribaei. ");
INSERT INTO swp_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","Isaraela nanatunaeao gora va laugagaeona se utusi: Akana, Kami natuna, Sabidi natuna, Seraha natuna, boga Iuda, ginauri se aigoraidi va esau i abi: Guiau Isaraela nanatunaeao i ouealaealaidi. ");
INSERT INTO swp_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","Ieriko eai Iosua tatao headi i hetamaridi se lau Eae eai, Bete‐avena hanahanauna eai, Betele teha aruabo eai. I heribadi i ene, Au sae abo oea au itasipoi. ");
INSERT INTO swp_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","Isi se uio Iosua arinai ia se heriba si ene, Tatao gamagaridi tabu se sae: tatao tausani labui, e tausani haiona abo se sae Eae abo se ialaidi, paisoa lailai tatao gamagaridi se sae, paana isi nige se gamagari. ");
INSERT INTO swp_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","Arinai tatao doha tausani haiona abo se sae nei eai: Eae tataodi matadi eai abo se dagogorigori. ");
INSERT INTO swp_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","Eae tataodi Isaraela tataodi 36 se unuidi: edi eanua va guduna eai i lau e Sibarima eai se dobi se henaudi, se unuidi: arinai tatao nuadi se vero, doha se hemala goila. ");
INSERT INTO swp_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","Iosua ana ruru i purisidi, matana eai i gurisalaoba tano eai Guiau ena ake nuanuana eai, I lau e i maimailahi, ia eo Isaraela edi babada hinage ahu urudi eai se tore. ");
INSERT INTO swp_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","Iosua i ene, Kapore, Guiau Eaubada e, saha hesabana teina tatao ta Ioridano eai au woeaidima Amoraiti tataodi nimadi eai u mosedi, bena u hebaaeamai? Eaubada e, i loro ena Ioridano hari teha eai ai miakomakomani. ");
INSERT INTO swp_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","Guiau e, abo ea ene edoha, Isaraela se dago adi vaiunu matadi eai? ");
INSERT INTO swp_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","Kanana tataodi, eo oea lailai ta taumiaidi vasa va abo se ataiei, isi abo se hetaiirimai, esamai tanoubu eai abo i lautom: saha esam lailai debana eai abo u ginauri? ");
INSERT INTO swp_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","Guiau i ribalau Iosua arinai i ene, U torohai: ue saha u ota matam eai doha nei? ");
INSERT INTO swp_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","Isaraela se abibaaeaemiu, egu riba hesunuma laugagaeona ea lauhesomdi va se utusi: mamohoi ginauri se goraedio se abidi, se aieahari, se boraauri hinage, ginauri va se tore edi gogo boeana eai. ");
INSERT INTO swp_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","Arinai ede Isaraela nanatunaeao nige se toro adi vaiunu matadi eai, adi vaiunu se dagogabaedi paana se baaea, taba nige ea saguuioimiu sora ginauri se aigoraei va boeamiu eai se gabaebagunaei. ");
INSERT INTO swp_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","U toro, tatao u heaadi, u ene, Au heaanonohaimiu i lau e maraitom: Guiau i ene ina doha, Isaraela e, ginauri se aigoraeao esau se abi edi gogo boeana eai taba nige au toro ami vaiunu matadi, eai, i lau e, ginauri va se aigoraeao boeamiu eai au abigabaei. ");
INSERT INTO swp_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","Maraitom hari boga, hari boga au laoma, boga esau Guiau i abi abo se oigogo, hari bada, hari bada, abo Vasavasa Guiau i abi, se laoma hari numa, hari numa, eo abo numa va Guiau i abi, abo se laoma hari tau, hari tau, ");
INSERT INTO swp_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","E, abo ia se abi ginauri va i abiao abo se gabu oeagi alaalasina eai, ia, eo ena ginauri gamagaridi hinage, paana Guiau ena ribahesunuma laugagaeona i utusi, Isaraela eai ena laulau eaueauri i abi. ");
INSERT INTO swp_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","Mara‐ie‐tom Iosua i torohai Isaraela i woeaidima hari boga, eo hari boga, abo Iuda boganaeao se abi. ");
INSERT INTO swp_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","Iuda edi Vasavasa i woeaidima, abo Vasavasa esau esana Saraiti se abi: Saraiti tataodi i woeaidima hari numa, hari numa, abo Sabidi se abi: ");
INSERT INTO swp_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","Sabidi ena numa tataodi i abidi, tau esau, tau esau, abo Akana se abi, Sabidi natuna, Seraha natuna, Iuda boganaeao. ");
INSERT INTO swp_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","Iosua i ribalau Akana arinai i ene Natugu e, Isaraela edi Guiau Eaubada u hedebasae, ia arinai em baaea ta u ribahemasaraha, em laulau aisana arigu eai u ribaei, tabu u toreamui. ");
INSERT INTO swp_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","Akana Iosua i heuio i ene, Mamohoi Isaraela edi Guiau matana eai ea baaea, egu laulau doha ede ina: ");
INSERT INTO swp_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","Ada vaiunu edi ginauri nimada eai se laoma va, Babalonia edi ruru lorona esau ea ita, eo ario sekela hanere labui, eo auro tupi esega, porohena sekela 50: ea henuaaririedi abo ea abidi: egu numa eai ea toreamuidi, ario va ubuna eai ea tore. ");
INSERT INTO swp_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","Tatao Iosua i hetamaridi se aitautau se lau ena numa ruru eai: ginauri va numa eai se toreamuidi, eo ario va ubuna eai. ");
INSERT INTO swp_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","Numa ruru va boeana eai se abidi, se laedi Iosua arinai, eo Isaraela nanatunaeao gamagaridi aridi eai, Guiau matana eai se toredi. ");
INSERT INTO swp_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","Iosua, Isaraela gamagari maenaeao Akana Seraha natuna se laei, eo ario hinage, eo ruru lorona va, eo auro tupina, ia nanatunaeao, tatao eo sisine, eo ena bulumakau, ena asina, eo ena mamoe, eo numa ruru hinage se laedi Akora gonuna eai. ");
INSERT INTO swp_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","Iosua i ene, Ue saha u hebaaeamai? Teina asubena ta Guiau oa hinage abo i hebaaeam: Isaraela gamagaridi veu eai ia se lauveui, abo oeagi alaalasina eai se gabudi, eo veu eai se lauveuidi. ");
INSERT INTO swp_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","Ia potana eai veu se tarini peina lailai, arinai se ota i laoma e, teina huia ta. Arinai Guiau ena ouealaeala i lausuara. Arinai hinage nei dimo ne esana se tore Akora gonuna, esana i ota i laoma e, huia ta. ");
INSERT INTO swp_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","Guiau i ribalau Iosua arinai, i ene, Tabu u matausi, tabu aruam se loi, u torohai tauiala gamagaridi maemeao au se Eae eai, Eae edi Vasavasa nimam eai abo ea reava, ena eanua tataodi hinage eo ena eanua, eo ena tano. ");
INSERT INTO swp_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","Eae, eo ena Vasavasa aridi eai au abi doha hinage au abi Ieriko eo ena Vasavasa aridi eai, gogo mo abo au abi gaibui omi enamiu; eanua murina eai au vese. ");
INSERT INTO swp_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","Iosua abo i torohai, iala tataodi gamagaridi maenaeao hinage, bena se sae Eae eai, se ialaidi, Iosua tataoadiadidiri 30,000 i hileidi maieona eai i hetamaridi, ");
INSERT INTO swp_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","I lauhesomdi, i ene. Au lau au bavaeamui eanua murimurina eai, tabu eanua au laugabaei ariri, gamagarimiu au bava nonohai. ");
INSERT INTO swp_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","Eau, eo tatao gamagaridi maegueao abo ai sae eanua ai abi: e, isi se pesama se laoma hesabamai doha lahinae va, abo ai dagogorigori matadi eai. ");
INSERT INTO swp_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","(Isi abo se laolaoma se henaumai) i lau e ai woeaidi eanua murimurina eai, si ene, se dago matada eai doha lahinae va; arinai bena ai dagoedi. ");
INSERT INTO swp_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","Omi emi aba vesei eai abo au torohai, eanua au girihai, paana Guiau emi Eaubada nimamiu eai eanua abo i reava. ");
INSERT INTO swp_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","Eanua va abo au girihai, eanua au gabu, doha Guiau ena laugagaeo i ene abo au gabu; au nuatui, ea lauhesomiuo. ");
INSERT INTO swp_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","Iosua abo i hetamaridi se lau, se lau Betele, eo Eae duaduaridi eai se bavaeamui Eae tupo lalasi eai: nei maieonana ne Iosua tatao boeadi eai ie mia. ");
INSERT INTO swp_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","Maraitomtom, mahana sora, Iosua i toro tatao i hasiridi, ia maena Isaraela edi babada se sae Eae tataodi matadi eai. ");
INSERT INTO swp_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","Tatao gamagaridi, tauiala gamagaridi maenaeao se sae se lage eanua hanahanauna eai, e, se abi numa Eae teha bauri eai: edi aba mia eo Eae arotauna duaduari eai. ");
INSERT INTO swp_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","Tatao 5000 i laedi Beteli eo Eae duaduari eai i hebavaeamuidi eanua tupo lalasi eai. ");
INSERT INTO swp_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","Tatao va se toredi, moutuadi va eanua teha bauri eai, eo tatao eanua teha lalasi eai se bavaeamui, Iosua maieona eai i dobi arotau gonuna duaduarina eai. ");
INSERT INTO swp_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","Eae edi Vasavasa Isaraela i itadi abo se toroheuheula, eanua tataodi se lau Isaraela se ialaidi, ia, eo ena eanua tataodi gamagaridi hinage, gonu eai se lauesega: tatao va se bavaeamui eanua murimurina eai nige se nuatuidi. ");
INSERT INTO swp_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","Iosua eo Isaraela gamagaridi se boraauridi, se woeawoeaidi arinai se dago barabara dobilana eai. ");
INSERT INTO swp_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","Eae tataodi adi sasagueao gamagaridi se eogaidi bena Isaraela se henaudi, Iosua se henau arinai eanua va se laugabaei. ");
INSERT INTO swp_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","Beteli eo Eae eai nige tau esega i mia, gamagaridi se lau Isaraela hesabadi: eanua se laugabaei, edi eanua dobiladi nige se gududi, Isaraela se aihenaudi, se lau. ");
INSERT INTO swp_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","Guiau i ribalau Iosua arinai, i ene, Alahia nimam eai u abiisini Eae matana eai, Eae nimam eai abo ea reava. Iosua alahia nimana eai abo i abiisini Eae matana eai. ");
INSERT INTO swp_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","Nimana i abiisini va tau vaseina edi aba bavaeamui eai se toroheuheula se aitautau, se avasae eanua eai, se girihai, se gabuheulai. ");
INSERT INTO swp_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","Eae tataodi abo se sinibui edi eanua asuasuna se ita i sae gareva eai, nige edi dobila bena se dago, se sae, se dobi, Isaraela se dago borabora va barabara eai abo se uio tauhenaudi matadi eai. ");
INSERT INTO swp_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","Iosua eo Isaraela gamagaridi se itaeao tauvesevesei eanua se girihaiao, eanua asuasuna i sae, se uio Eae tataodi se unuidi. ");
INSERT INTO swp_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","Isi hinage eanua eai se lage se laoma hesabadi: arinai Isaraela Eae tataodi se hetaiiridi hari teha, hari teha se unuidi, nige esega i mia, eo nige esega i dago. ");
INSERT INTO swp_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","Eae edi Vasavasa se toai abo se laei Iosua arinai. ");
INSERT INTO swp_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","Isaraela tataodi oea eai Eae tataodi se unuohidi barabara eai va se henaudi va, gamagaridi se lauelepaidi abo se mateohi, Isaraela gamagaridi abo se uio Eae eai, hinage tatao eanua eai se lauelepaidi. ");
INSERT INTO swp_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","Nei asubenana ne gamagaridi se mate, tatao eo sisine tausani saudoudoi‐labui, Eae tataodi abo se ohi. ");
INSERT INTO swp_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","Iosua nimana eai alahia i abiisini va nige i abiuio i lau e, Eae taumiaidi gamagaridi se unuheohidi. ");
INSERT INTO swp_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","Edi bulumakau, eo edi gogo mo Isaraela se abigaibuidi, doha riba va arinai Guiau Iosua i lauhesom va. ");
INSERT INTO swp_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","Iosua Eae i gabuohi, eanua va i hemala venu peina, i hebaaeaaririei i laoma e, huia ta. ");
INSERT INTO swp_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","Eae edi Vasavasa oeagi eai i hegadosoha i lau e, i maimailahi: mahana i dui Iosua abo i lauhesomdi i ene, Sinarena oeagi eai au abihai au gabalaei eanua dobila aba avaavasaena eai; arinai veu gamagaridi au tarinidi, hinage nei eai se ota i laoma e, huia ta. ");
INSERT INTO swp_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","Ebali tupina eai Iosua hatahata tabuna i ginauri Guiau Isaraela edi Eaubada arinai, ");
INSERT INTO swp_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","Doha Mose, Guiau ena heaheari, Isaraela nanatunaeao i lauhesomdi, doha Mose ena laugagaeo bukana eai se uri va, hatahata tabuna va veu tau maudoudoidi eai au ginauri, aridi eai nige tau esau poasi eai i paisoa: potana eai aitalasam gabugabudi Guiau arinai se ginauri: eo labini aitalasamdi hinage. ");
INSERT INTO swp_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","Mose ena laugagaeo, Isaraela matadi eai i uridi va, Iosua vau veu eai i urivataidi. ");
INSERT INTO swp_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","Isaraela gamagaridi, eo edi babada hinage, eo adi tanuaga, eo edi tauhekiraino, ake hari teha, hari teha eai se totoro: kohena, boga Levi, Guiau ena ribahesunuma akena se laei, laolaoma tataodi, eo headi boeadi eai se labasidi hinage, tupona Geresima tupina hasarina eai se totoro, eo tupona Ebali tupina hasarina eai: doha Mose Guiau ena heaheari i lauhesomnonohaidi, i ene, Isaraela tataodi arinai se aihelahuidi. ");
INSERT INTO swp_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","Murina eai laugagaeo ribadi gamagaridi i hasiridi, riba lorodi, eo riba hemahematausiedi, doha laugagaeo bukana eai riba gamagaridi se uridi. ");
INSERT INTO swp_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","Mose laugagaeo i lauhesomdi, nige riba esau Iosua i hebeu Isaraela tataodi aridi eai i hasiriheohidi, eo sisine, eo merumeru gagaridi, eo laolaoma tataodi maedi se sae, se dobi, riba va hinage se ataiedi. ");
INSERT INTO swp_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","Vasavasa gamagaridi Ioridano teina teha eai, headi oea tupidi eai, eo headi gonudi eai, eo gabogabo lailai hasarina eai, Lebanona tehana eai, Hitaite, eo Amoraiti, eo Kanana, eo Peresaiti, eo Haivaiti, eo Iebusaiti, isi vasa va se ataiei. ");
INSERT INTO swp_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","Abo se oigogo esega, bena Iosua eo Isaraela se ialaidi, nuadi esega mo. ");
INSERT INTO swp_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","Gibeona taumiaidi Iosua ena laulau Ieriko, eo Eae aridi eai, vasana se ataiei. ");
INSERT INTO swp_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","Edi nuatu borabora se nuatui arinai bena se hemala hari eanua tataodi, baeki beabeadi se toredi edi asina potadi eai, edi uaina opidi se abidi se beabea, eo se puripurisi, eo se bodibodi, ");
INSERT INTO swp_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","Aedi eai ae‐um beabeadi, eo se poasidi se abidi, ruru beabeadi se ruidi, edi areto hinage i kokoeagi, eo i pohupohu. ");
INSERT INTO swp_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","Isi se lau Iosua arinai, ena aba mia Giligali eai, se ribalau ia arinai, eo Isaraela aridi eai, si ene, Ema eanua eda roharoha eai ai laoma, bena ta labini. ");
INSERT INTO swp_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","Isaraela tataodi se ribalau vau Hitaiti tataodi aridi eai, si ene Nuana boeamai eai aue mia, edohana abo ta labini? ");
INSERT INTO swp_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","Se ribalau Iosua arinai, si ene, Em heaheari ai. Iosua aridi eai i ene, Omi haedi eai au laoma? ");
INSERT INTO swp_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","Se ribalau ia arinai si ene, Em heaheari oea esau eda roharoha eai se laoma, paana Guiau em Eaubada esana ai ataiei: ia vasalaulau ai ataieao, eo ena laulau gamagaridi Aigupito eai. ");
INSERT INTO swp_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","Ena abiabi gamagaridi hinage Amoraiti edi Vasavasa labui aridi eai, Ioridano hari tupo eai Sihona, Hesebona edi Vasavasa, eo Oga, Basana edi Vasavasa, Asatarota eai. ");
INSERT INTO swp_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","Arinai ema babada, eo ema eanua tataodi gama garidi se ribalaoma arimai eai, si ene, Emi adaadausi alaena nimamiu eai au abi, au laubagibagiedi, au ribalau aridi eai, au ene, Emi heaheari ai: ta labini. ");
INSERT INTO swp_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","Teina areto ta ema eda alaena ema numa eai ai abi ma gigiborina asubenana ne ai laoma arimiu eai, hage au ita i kokoeagi, eo i pohupohu: ");
INSERT INTO swp_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","Eo teina uaina iledi hinage ma harihariudi ai hemonaudi: eo teina ama ruru, eo ae‐um ta se beabea paana ema dobila i roha ariri. ");
INSERT INTO swp_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","Adi aiai ribana tatao se ataiei, nige se lau Guiau avana eai edi dobila se hesioi. ");
INSERT INTO swp_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","Iosua i ava‐ehaedi, eo se labini, to se abihemauridi; Isaraela edi vasavasa aridi eai se riba aigora aridi eai, ");
INSERT INTO swp_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","I lau e, asubena haiona se ohi vasa abo se ataiei isi heledi taumia, edi eanua hinage hanahanaudi eai. ");
INSERT INTO swp_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","Isaraela tataodi se lau, asubena hehaionana eai edi eanua eai se lage. Edi eanua va esadi ede Gibeona, eo Sepaira, Birota, eo Keriga‐gerimi. ");
INSERT INTO swp_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","Isaraela nanatunaeao nige se unuidi paana edi Vasavasa, Guiau, Isaraela edi Eaubada debana eai se aigora aridi eai. Isaraela gamagaridi edi vasavasa se monunuedi. ");
INSERT INTO swp_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","Vasavasa va se ribalau Isaraela aridi eai si ene, Aridi eai ai aigora, Guiau, Isaraela edi Eaubada, debana eai: tabu ta abilau aridi eai. ");
INSERT INTO swp_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","Teina mo ta abi aridi eai: ta abihemauridi baaea lailai ata ta hearo, paana aigora va arinai ta aigora aridi eai. ");
INSERT INTO swp_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","Vasavasa se ribalau aridi eai si ene, Abo ta abihemauridi: taiede isi abo Isaraela edi oeagi taugedari eai se lau, eo adi goila tauoioi eai se lau: doha hinage vasavasa va se heribadi. ");
INSERT INTO swp_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","Iosua i eogaidi i ribalau aridi eai, i ene, Omi saha au boraimai ta, au ene, ema eanua edadi se roha ariri, emi aba‐mia momohoi gegesimai eai? ");
INSERT INTO swp_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","Taiede abo au baaea, abo ai hepaisoaimiu, omi abo egu Eaubada ena numa oeagi taugedari, eo goila tauoioi eai au lau. ");
INSERT INTO swp_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","Iosua se heuio si ene, Mamohoi, ai em heaheari si heribamai si ene, Guiau, em Eaubada ena heaheari Mose i heriba oea maudoudoina abo se rediva, oea va taumiai hinage gamagaridi matamiu eai abo au unuidi, arinai ai matausiaririemiu, teina laulau ta hinage ai abi. ");
INSERT INTO swp_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","Taiede, ai ede ina nimam eai, oabom em abi sahu u ene i loro, eo i dudurai u abi arimai eai. ");
INSERT INTO swp_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","Arinai hinage Isaraela nanatunaeao nimadi eai i abihemauridi, nige se unuidi. ");
INSERT INTO swp_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","Nei asubenana ne Iosua i hetorodi Isaraela edi oeagi taugedari, eo adi goila tauoioi, eo Guiau ena hatahata tabuna oeagina eo goilana se abi, i laoma e, teina asubena ta, dimona edi aba‐paisoa hinage i heribadi. ");
INSERT INTO swp_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","Adonisedeka, Ierusalema edi Vasavasa, vasana i ataiei Iosua Eae i abi, eo i hebaaeaaririei: ena laulau Ieriko eo edi Vasavasa aridi eai, doha ede hinage ena laulau Eae eo edi Vasavasa aridi eai, Gibeona tataodi maedi Iosua se haiavaeha, eo se miamia Isaraela boeadi eai vasana hinage i ataiei: ");
INSERT INTO swp_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","Se matausi ariri paana Gibeona eanua lailai, eo Vasavasa ena eanua esau, Eae i gagiri, Gibeona tataodi hinage se adidiri ariri. ");
INSERT INTO swp_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","Arinai Adonisedeka, Ierusalema edi Vasavasa, headi i hetamaridi se lau Hohamu arinai, Heberona edi Vasavasa, eo Pirama arinai, Iamuta edi Vasavasa, eo Iapia arinai, Lakisi edi Vasavasa, eo Debira arinai, Egalona edi Vasavasa, i ene. ");
INSERT INTO swp_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","Au saema arigu eai, au saguigu bena Gibeona ta ialaidi, paana ede isi maena Iosua eo Isaraela nanatunaeao se haiavaehaei. ");
INSERT INTO swp_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","Arinai Amoraiti edi Vasavasa haligigi, Ierusalema edi Vasavasa, eo Heberona edi Vasavasa, eo Iamuta edi Vasavasa, eo Lakisi edi Vasavasa, eo Egalona edi Vasavasa, se lauheagogo, se sae, eo edi tauiala gamagaridi hinage, Gibeona matana eai se abi numa, se ialaidi. ");
INSERT INTO swp_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","Gibeona tataodi headi se hetamaridi Iosua arinai, Giligali eai, edi aba numa‐abi, si ene, Em heaheari debadi eai tabu nimam u nuahi: u saema heula u abihemaurimai, eo u saguimai paana Amoraiti edi Vasavasa gamagaridi oea tupidi eai se mia se oigogoesegama hesabamai. ");
INSERT INTO swp_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","Giligali eai Iosua i sae tauiala gamagaridi maenaeao, eo tauiala adidiri gamagaridi hinage. ");
INSERT INTO swp_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","Guiau i ribalau Iosua arinai i ene, Tabu u matausidi: isi nimam eai ea lediva: taba nige tau esau matam eai i toro. ");
INSERT INTO swp_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","Arinai Iosua i heula, maieona eai i lau e, mara‐i‐tom Giligali eai i sae. ");
INSERT INTO swp_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","Isaraela matadi eai Eaubada i hebaaeadi: Gibeona eai gamagaridi se unuidi, se henaudi Belehorana dobilana eai, Aseka eai hinage se unuidi, i lau e, se lage Makeda eai. ");
INSERT INTO swp_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","Isi Isaraela matadi eai se dagodago, se dobi Bete‐horana eai, Guiau gareva eai veu lailaidi i tudobedi potadi eai i lau e, Aseka eai, arinai se mate: tatao vau veu va aridi eai se mate se gamagari: isi Isaraela se lauelepaidi, nige doha. ");
INSERT INTO swp_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","Asubenana ne Guiau Amoraiti tataodi i mosedi Isaraela tataodi aridi eai Iosua i ribalau Guiau arinai, Isaraela matadi eai i ene, Mahana e u otaesegai Gibeona potana eai; eo navarai e Agaloni arotauna eai. ");
INSERT INTO swp_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","Mahana abo i otaesegai, eo navarai nige i dalasae hinage, i lau e tatao adi vaiunu se hemaisadi. Iasa ena buka eai vasa va se uri, e nigee? To mahana gareva duaduarina eai i otaesegai, asubena maudoudoina nige i dui. ");
INSERT INTO swp_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","Nige asubena esau mugamugaina eo murimuritana nei doha, tau esau arinana Guiau i ataiei: paana Guiau Isaraela i ialasaguidi. ");
INSERT INTO swp_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","Iosua Isaraela gamagaridi maenaeao se uio edi aba numa‐abi Giligali eai. ");
INSERT INTO swp_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","Vasavasa haligigi va se dago duhana esau eai Makeda eai se bavaeamui. ");
INSERT INTO swp_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","Iosua se heriba, si ene, Vasavasa haligigi va se lobaidi Makeda gudana eai. ");
INSERT INTO swp_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","Iosua abo i ene, Veu nabunabutuadi au buihai guda avana eai, tatao au hetorodi bena se itavataidi. ");
INSERT INTO swp_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","Omi tabu au bava inai, ami vaiunu au henaudi murina eai se dago au lubidi: edi eanua tabu se lagedi paana Guiau emi Eaubada nimamiu eai i lediva. ");
INSERT INTO swp_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","I lau e, Iosua eo Isaraela nanatunaeao se iala lautom, tatao se unuidi se gamagari ariri, doha se mate ohi, headi mo se mia se lau edi eanua se ganaidi. ");
INSERT INTO swp_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","Tatao gamagaridi se uio edi aba numa eai, Iosua arinai, Makeda eai, eo se labini, nige esau avana eai Isaraela i ribahebaaea. ");
INSERT INTO swp_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","Iosua abo i ene, guda avana au soe, Vasavasa haligigi duha eai abo au woeaidima arigu eai. ");
INSERT INTO swp_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","Ena riba se lauvatai, Vasavasa haligigi se woeaidima ia arinai: Ierusalema edi Vasavasa, eo Heberona edi Vasavasa, Iamuta edi Vasavasa, eo Lakisi edi Vasavasa, eo Egalona edi Vasavasa. ");
INSERT INTO swp_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","Teina Vasavasa se woeaidi Iosua arinai, Iosua Isaraela tataodi gamagaridi i eogaidi, edi iala kapena maena se lau ia i heribadi, i ene, au laoma gegesigu eai, aemiu teina Vasavasa gedugedudi eai au ututavaidi. Si laoma ia gegesina eai aedi gedugedudi eai se ututavaidi. ");
INSERT INTO swp_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","Iosua i heribadi i ene, Tabu au matausi, tabu aruamiu se loi, au adidiri eo au nuakipikipi, ina doha hinage Guiau abo i abi ami vaiunu gamagaridi aridi ena. ");
INSERT INTO swp_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","Murina eai Iosua i lubidi, eo i unuidi oeagi haligigi aridi eai i hegadosohadi, se ota i lau e, i maimailahi. ");
INSERT INTO swp_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","Mahana i dui Iosua i lauhesomdi, oeagi eai se abihaidi, se gabalaedi vau duha va alona eai, arinai se bavaeamui veu nabunabutuadi duha avana eai se toredi, hinage nei eai se ota i laoma e asubena ta. ");
INSERT INTO swp_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","Nei asubenana ne Iosua Makeda i abi i lauelepaidi, edi Vasavasa hinage i unui, isi tatao gamagaridi, nige esega i mia: ena laulau Makeda edi Vasavasa arinai doha hinage ena laulau Ieriko edi Vasavasa arinai. ");
INSERT INTO swp_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","Iosua eo Isaraela gamagaridi maenaeao Makeda se laugabaei se lau Libina, Libina se ialaidi. ");
INSERT INTO swp_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","Guiau Isaraela nimadi eai Libina i mosei, eo edi Vasavasa hinage: se lauelepaidi, tatao gamagaridi boeana eai si unuidi; nige tau esau arinai ie mia: ena laulau edi Vasavasa arinai doha hinage ena laulau Ieriko edi Vasavasa arinai. ");
INSERT INTO swp_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","Iosua, eo Isaraela gamagaridi maenaeao Libina se laugabaei, Lakisi eai se lagema matadi eai se abi‐numa, se ialaidi. ");
INSERT INTO swp_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","Guiau Lakisi Isaraela nimadi eai i mosei, asubena helabuina eai se abi se lauelepaidi, tatao gamagaridi hinage boeana eai se unuidi, doha edi laulau Libina eai. ");
INSERT INTO swp_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","Horama, Gesa edi Vasavasa abo i laoma Lakisi bena i saguidi: Iosua ia hinage, eo ena eanua tataodi i lauelepaidi nige esau i mia. ");
INSERT INTO swp_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","Iosua, eo Isaraela gamagaridi maenaeao Lakisi se laugabaei, Egalona eai se lagema, matadi eai se abi‐numa, eo se ialaidi. ");
INSERT INTO swp_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","Nei asubenana ne Egalona se abi, se lauelepaidi, tatao gamagaridi eanua boeana eai se unuheohidi, doha hinage edi laulau Lakisi aridi eai. ");
INSERT INTO swp_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","Iosua eo Isaraela gamagaridi maenaeao Egalona eai se sae, se lau Heberona eai se ialaidi. ");
INSERT INTO swp_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","Heberona se girihai, edi Vasavasa, eo edi eanua gamagaridi, eo tatao gamagaridi boeadi eai se lauelepaidi, nige tau esau ie mia, i hebaaeaaririedi tatao gamagaridi i unuidi, ena laulau doha hinage ena laulau Egalona aridi eai. ");
INSERT INTO swp_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","Iosua, eo Isaraela gamagaridi maenaeao abo se uio: se lagema Debiri eai se ialaidi ");
INSERT INTO swp_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","Debiri se girihai eo edi Vasavasa, eo edi eanua gamagaridi hinage: se lauelepaidi, tatao gamagaridi se unuidi, nige tau esau ie mia: ena laulau Debiri aridi eai eo edi Vasavasa arinai, doha hinage ena laulau va Libina aridi eai eo edi Vasavasa arinai. ");
INSERT INTO swp_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","To Iosua oea tupidi eanuadi i heguridi, eo eanua headi teha eavana eai eo gonu eanuadi, eo goila i bunubunuasi eanuadi, eo edi Vasavasa hinage, nige tau esau i mia, isi gamagaridi se eahua i unuhematedi, doha Guiau Isaraela edi Eaubada i lauhesomdi. ");
INSERT INTO swp_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","Iosua i lauelepaidi Kadesa‐banea sigasigana i lau e Gasa eai, eo Gosena oea maudoudoina eai i lau e Gibeona eai. ");
INSERT INTO swp_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","Teina Vasavasa gamagaridi, eo edi tano hinage huia esega Iosua i abidi paana ede Guiau, Isaraela edi Eaubada, Isaraela i ialasaguidi. ");
INSERT INTO swp_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","Iosua, eo Isaraela gamagaridi maenaeao se uio, edi aba numa‐abi Giligali eai. ");
INSERT INTO swp_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","Iabini, Hasoa edi Vasavasa va i ataiei headi i hetamaridi Iobaha, Madona edi Vasavasa, eo Simirona edi Vasavasa, eo Asapa edi Vasavasa aridi eai. ");
INSERT INTO swp_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","Vasavasa headi hinage oea tupi roharoha teha bauri eai, eo Vasavasa headi gonu eai Sinerota teha eavana eai, eo headi hinage arotau eai, eo Doa sigasigana eai, teha lalasi eai. ");
INSERT INTO swp_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","Eo Kanana teha aruabo, eo teha lalasi, eo Amoraiti, eo Hitaiti, eo Peresaiti, eo Iebusaiti oea tupidi eai, eo Haivaiti Hemoni ubuna eai, Misepa oeana eai. ");
INSERT INTO swp_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","Isi se lau, isi eo edi tauiala moutuadi hinage, tatao se gamagari, mamohoi isi doha geregere gabogabo hasarina eai se gamagari ariri, eo hosi, eo kariota se gamagari ariri. ");
INSERT INTO swp_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","Teina Vasavasa gamagaridi se oigogo‐esega se laoma se abi‐numa Meroma goilana eai, Isaraela bena se ialaidi. ");
INSERT INTO swp_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","Guiau i ribalau Iosua arinai i ene, Isi tabu u matausiedi; maraitom, mahana doha ede ina, se mateohi abo ea mosedi Isaraela matadi eai; edi hosi abo au nigoidi, edi kariota abo oeagi eai au gabudi. ");
INSERT INTO swp_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","Iosua abo i laoma, eo tauiala gamagaridi maenaeao, i hetagugudi Meroma goilana eai, se ialaidi. ");
INSERT INTO swp_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","Guiau Isaraela nimadi eai i mosedi, to se lauelepaidi, eo se henaudi se lau e Sidona eai se lage, eo Misirepota‐maima eai se lage, eo Misepa teha aruabo arotauna eai se lage, se lauelepaidi i lau e nige esega i mia. ");
INSERT INTO swp_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","Iosua Guiau ena riba gamagaridi i lauvataidi: edi hosi i nigoidi, eo edi kariota oeagi eai i gabudi. ");
INSERT INTO swp_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","Nei asubenana ne Iosua i uio abo Hasoa i girihai, elepa eai edi Vasavasa i unui: beabeana Hasoa va teina basileia gamagaridi i sae tavatavaidi. ");
INSERT INTO swp_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","Isi tatao gamagaridi boeana eai se lauelepaidi se unuhematedi: nige esau i mia i eahua: Hasoa hinage i gabu. ");
INSERT INTO swp_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","Vau Vasavasa va edi eanua gamagaridi, eo edi Vasavasa hinage Iosua i girihaidi i lauelepaidi, i hebaaeaaririedi, doha Mose, Guiau ena heaheari, i lauhesomdi. ");
INSERT INTO swp_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","Eanua lailai headi Isaraela sora nige se gabudi, Iosua Hasoa mo i gabu. ");
INSERT INTO swp_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","Teina eanua edi gogo, eo edi bulumakau, Isaraela nanatunaeao se abigaibuidi isi isibom edi ginauri: tatao mo gamagaridi se lauelepaidi, nige tau esau i mia i eahua. ");
INSERT INTO swp_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","Doha Guiau ena heaheari Mose i lauhesom, Mose hinage Iosua i lauhesom, Iosua hinage i abivatai: ginauri gamagaridi Guiau Mose i lauhesom va Iosua i abiheohidi. ");
INSERT INTO swp_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","Arinai Iosua oea i girihaiohi, oea tupidi, eo oea maudoudoina teha eavana eai, Gosena oeana maudoudoina, eo arotau eo gonu, eo Isaraela edi oea, eo edi gonu. ");
INSERT INTO swp_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","Halaki tupina eai i sae Seia eai, i lau e Balagada eai, Labanona arotauna eai, Heamona tupina ubuna eai: edi Vasavasa gamagaridi i abidi, i lauelepaidi, i unuidi hinage. ");
INSERT INTO swp_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","Teina Vasavasa gamagaridi aridi eai Iosua huia roharoha eai i ialaidi. ");
INSERT INTO swp_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","Nige eanua esau Isaraela maena se labini: Haivaiti tataodi isibom Gibeona taumiaidi: gamagaridi se ialaidi, eo se girihaidi. ");
INSERT INTO swp_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","Paana ede Guiau nuadi i heoiuradi, bena se laoma Isaraela se ialaidi, ia abo i hebaaeaaririedi, nige i nuatuidi; bena i hebaaeadi mo, doha Guiau Mose i lauhesom. ");
INSERT INTO swp_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","Nei huiana ne Iosua i laoma Anakimi tataodi bena i helautomdi oea tupidi eai, eo Heberona eai, Debiri hinage, eo Anabi, eo Iueda oea tupidi eai, eo Isaraela oea tupidi eai: Iosua i hebaaeaariedi, eo edi eanua hinage. ");
INSERT INTO swp_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","Isaraela nanatunaeao edi tano eai nige Anakimi esau i mia; headi mo se mia Gasa eai, eo Gati eai, eo Asidodi eai. ");
INSERT INTO swp_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","Tano maudoudoina Iosua i girihai, doha hinage riba gamagaridi Guiau i ribalau Mose arinai: Iosua abo i mosei Isaraela aridi eai, boga esau enana, eo boga esau enana, oea eai va se iala lautom. ");
INSERT INTO swp_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","5","Teina peina eai Vasavasa gamagaridi va Isaraela se unuidi, eo edi tano se girihaidi va esadi se uridi. Ioridano hari tupo eai, Sihona, Amoraiti edi Vasavasa, eo Oga, Basana edi Vasavasa. ");
INSERT INTO swp_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","Mose Guiau ena heaheari, eo Isaraela nanatunaeao se unuidi: Mose Guiau ena heaheari, edi tano i mosei Reubena, eo Gada, eo Manasa tupona aridi eai. ");
INSERT INTO swp_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","Iosua eo Isaraela nanatunaeao teina Vasavasa gamagaridi se unuidi Ioridano teina teha eai, teha lalasi, Balagada eai, Lebanona arotauna eai, i lau e Halaki tupina eai, i sae Seia eai: edi tano va Iosua abo i mosei Isaraela adi bogao aridi eai, hari boga enana, hari boga enana. ");
INSERT INTO swp_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","24","Ieriko edi Vasavasa, Eae edi Vasavasa, (Betele hanahanauna eai) Ierusalema edi Vasavasa, Heberona edi Vasavasa, Iamuta edi Vasavasa, Lakisi edi Vasavasa, Egalona edi Vasavasa, Gesa edi Vasavasa Debiri edi Vasavasa, Gederi edi Vasavasa, Hoama edi Vasavasa, Aradi edi Vasavasa, Libina edi Vasavasa, Adulama edi Vasavasa, Makeda edi Vasavasa, Betele edi Vasavasa, Tapua edi Vasavasa, Hepera edi Vasavasa, Apeka edi Vasavasa, Lasarona edi Vasavasa, Madona edi Vasavasa, Hasoa edi Vasavasa, Simirona merona edi Vasavasa, Asapa edi Vasavasa, Tanako edi Vasavasa, Megido edi Vasavasa, Kedesa edi Vasavasa, Tokanaim edi Vasavasa, Doa edi Vasavasa, Giligali edi Vasavasa, Tirisa edi Vasavasa, gamagaridi tauesega‐i‐mate‐saudoudoi‐esega. ");
INSERT INTO swp_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","Iosua i tautaubadao, ena borimai se gamagari: Guiau i ribalau ia arinai i ene, U tautaubadao, eo em borimai se gamagari, sora tano lailai nige au abiheohi. ");
INSERT INTO swp_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","6","Tano va sora nige se abi va anasigasiga Guiau Iosua i heriba. ");
INSERT INTO swp_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","Tano ta abo au soi boga haligigi‐hasi aridi eai, eo Manasa boganaeao tupona arinai. ");
INSERT INTO swp_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","Reubena, eo Gada, eo Manasa boganaeao tupona, edi oea se abiao, Mose i mosedi va, Ioridano hari teha eai, tupo aruabo eai, doha Mose Guiau ena heaheari i mosedi. ");
INSERT INTO swp_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","13","Vau Reubena, eo Gada, eo Manasa boganaeao tupona, edi oea sigasigadi Iosua i ribaedi. ");
INSERT INTO swp_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","Levi boganaeao mo oea nige i mosedi, Guiau, Isaraela edi Eaubada ena aitalasam oeagi alaalasina eai se ginauridi enadi meta, doha hinage i heribadi. ");
INSERT INTO swp_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","23","Reubena boganaeao edi oea sigasigadi se uridi. ");
INSERT INTO swp_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","28","Gada boganaeao edi oea sigasigadi se uridi. ");
INSERT INTO swp_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","32","Manasa boganaeao tupona edi oea sigasigadi se uridi. ");
INSERT INTO swp_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","Mose Levi boganaeao oea nige i mosedi, Guiau, Isaraela edi Eaubada, edi oea ede, doha hinage i heribadi. ");
INSERT INTO swp_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","Teina oea gamagaridi Isaraela nanatunaeao Kanana eai se abidi, Eleasa kohena tauna, eo Iosua Nuna natuna, eo Isaraela edi bogao edi babada se soi isi enadi. ");
INSERT INTO swp_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","Kelero eai se abidi doha Guiau Mose nimana eai i lauhesomdi, boga haligigi‐hasi enadi, eo boganaeao tupona. ");
INSERT INTO swp_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","Paana Mose boga labui eo tupona edi tano i mosedi Ioridano hari teha eai: Levi tataodi tano enadi nige i mosedi. ");
INSERT INTO swp_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","Paana Iosepa nanatunaeao boga labui, Manasa, eo Iperima, arinai Levi tataodi oea enadi nige se mosedi, edi eanua headi mo edi aba mia, eo eanua va murimuridi eai edi bulumakau, eo edi aba aibai. ");
INSERT INTO swp_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","Doha Guiau Mose i lauhesom, Isaraela nanatunaeao se ginauri, tano abo se soi. ");
INSERT INTO swp_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","Giligali eai Iuda nanatunaeao Iosua arinai se laoma: Kaleba Iepuna natuna, Kenese tauna, i ribalau ia arinai, i ene, Riba va Kadesa‐banea eai Guiau Mose. Eaubada tauna, i heriba va u nuatui, enagu i riba va. ");
INSERT INTO swp_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","Egu borimai tatao labui Mose, Guiau ena heaheari, Kadesa‐banea eai i hetamarigu oea va bena ea itasipoi; abo ea uio ia arinai nuagu ea hemasaraha. ");
INSERT INTO swp_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","Agu sasagueao maegu ai sae va tatao nuadi se hevelodi: eau Guiau egu Eaubada, ea hemurivatai ma nuagu i ohi. ");
INSERT INTO swp_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","Nei asubenana ne Mose i aigora i ene, Mamohoi, oea va arinai aem se utu abo em oea, eo am isimurita edi oea i lau e nige nosina, paana ma nuam i ohi Guiau em Eaubada u hemurivatai. ");
INSERT INTO swp_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","Hage u ita Guiau egu mauri i heroha, doha i ribaei, teina borimai 45, nabada va Guiau teina riba ta Mose i heriba, Isaraela nanatunaeao sora se tautausi barabara eai, teina asubena ta eau egu borimai 85. ");
INSERT INTO swp_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","Hinage teina asubena ta ea adidiri doha egu adidiri nei asubenana ne arinai Mose i hetamarigu, ea iala, eo ea pesa, eo ea avasae, egu adidiri ta doha egu adidiri nei huiana ne. ");
INSERT INTO swp_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","Arinai ea ne teina oea tupina ta u reama doha Guiau nei asubenana eai ie ribaei, paana nei asubenana ne u ataiei Anakimi metai, eo edi eanua se lai, eo se ganaidi: taiede ena Guiau maegu abo ea henaudi se lau, doha Guiau i ribaei. ");
INSERT INTO swp_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","Iosua ia i aihelahui, Kaleba, Iepuna natuna, Heberona i mosei ena oea. ");
INSERT INTO swp_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","Arinai Heberona, Kaleba, Iepuna natuna, Kenese tauna i abi i laoma e huia ta, paana Guiau, Isaraela edi Eaubada, i hemurivatai, ma nuana i ohi. ");
INSERT INTO swp_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","Heberona esana bagubaguna ede Kiriata‐araba, Araba Anaki tau adidiri esau esana, oea va boeana eai se labini. ");
INSERT INTO swp_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","12","Iuda boganaeao edi tano, hari bada, hari bada enadi se soi, Iuda edi tano sigasigadi se uridi. ");
INSERT INTO swp_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","Kaleba, Iepuna natuna, Iuda nanatunaeao edi oea tupona i mosei, doha Guiau Iosua i heriba, Araba Anaki tamana ena eanua, esana Heberona. ");
INSERT INTO swp_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","Kaleba, Anaki nanatunaeao haiona, Sesai, eo Aimano, eo Talemai i henaudi. ");
INSERT INTO swp_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","Ia abo i sae Debiri tataodi aridi eai: Debiri esana beabeana ede Kiriata‐sepa. ");
INSERT INTO swp_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","Kaleba i ene, Tau esau Kiriata‐sepa i lubi, eo i girihai, abo Akesa, natugu siu, ia monena ea mosei. ");
INSERT INTO swp_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","Otinielu, Kinasa natuna, eanua abo i girihai, abo Akesa i mosei ia monena. ");
INSERT INTO swp_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","Se tavasorao abo Akesa Otinielu i heriba bena tamana arinai oea gagirina esau i aiboda: ena asina eai i pesa: Kaleba i ribalau ia arinai i ene, saha bena u abi? ");
INSERT INTO swp_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","I heuio i ene, u hewoiwoinagu, oea esau tupo eavana u reamao, ea ne bena goila se bunubunuasi hinage u reama. Goila bunubunuasi tupo saesaena, eo tupo dobidobina abo i mosei ia arinai. ");
INSERT INTO swp_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","62","Iuda boganaeao hari bada, hari bada edi oea se soi eanua gamagaridi, eo oea sigasigadi se uridi. ");
INSERT INTO swp_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","Iebusaiti tataodi, Ierusalema taumiaidi, Iuda se aipateasa nige se henaudi: Iebusaiti tataodi, Iuda nanatunaeao maedi se miaesega Ierusalema eai, i laoma e teina huia ta. ");
INSERT INTO swp_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","11","Manasa edi tano sigasigana se uridi. ");
INSERT INTO swp_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","Manasa nanatunaeao eanua taumiaidi nige se hetatagorigoriohidi, nige abina se ata: Kanana tataodi oea eai se miahai. ");
INSERT INTO swp_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","Taiede Isaraela nanatunaeao se hetadadao, Kanana tataodi se hetaxiedi nige se hetatagorigoriohidi, ");
INSERT INTO swp_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","Iosepa nanatunaeao se ribalau Iosua arinai si ene, Paana saha tano esega mo u reama, eau ea sae, eo egu tatao se gamagari ariri, doha lahinae Guiau i hedebasaegu. ");
INSERT INTO swp_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","Iosua i heuio i ene, Ena mamohoi oa u sae, eo em tatao se gamagari, eo em tano Iperima eai nige susuana, abo u sae nuura eai, Peresaiti edi tano eai em oeagi u oidi. ");
INSERT INTO swp_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","Iosepa nanatunaeao si ene, Tupina nige gonogonoamai: Kanana tataodi gonu eai se mia edi kariota poasi se abidi, Betaseana tataodi, eo eanua headi hinage, eo isi se miahai Ieserela gonuna eai. ");
INSERT INTO swp_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","Iosua i ribalau Iosepa nanatunaeao Iperima eo Manasa aridi eai, i ene, Mamohoi u sae, u gamagari, eo u adidiri ariri: taba nige tano esega mo u abi. ");
INSERT INTO swp_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","Oea tupina abo enam: oeagi metai se gamagari abo u oidi, aniona abo enam: Kanana tataodi va edi kariota poasi se abidi va eo se adidiri, abo u henaudi, eo u hetatagorigoriohidi hinage. ");
INSERT INTO swp_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","Isaraela nanatunaeao moutuadi lailai maudoudoina Siloa eai se oigogo, numa bahebaheusi edi aba oigogo se hetoro. Oea va tataodi matadi eai se heiluedi. ");
INSERT INTO swp_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","Isaraela nanatunaeao boga haligigi‐labui sora edi tano nige se soiedi. ");
INSERT INTO swp_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","Iosua i ribalau Isaraela nanatunaeao aridi eai i ene, i lau e huia esana, emi beruberu abo i lautom, abo au lau tano au abi, Guiau tamamiueao edi Eaubada i reava va? ");
INSERT INTO swp_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","Hari boga, hari boga, tatao haiona, haiona, au hineridi, abo ea hetamaridi, se torohai se lau oea va se dioi, abo se soi gonogonoadi, e abo se uioma arigu eai. ");
INSERT INTO swp_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","Abo se soi haligigi‐labui: Iuda abo se miahai geregere eai teha eavana eai, boga Iosepa abo se miahai teha bauri eai. ");
INSERT INTO swp_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","Oea va abo au soi, haligigi‐labui, sigasigadi va abo au heribagu, Guiau emi Eaubada matana eai, enamiu abo ta hekelero. ");
INSERT INTO swp_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","Boga Levi mo nige edi tano, isi Guiau ena kohena eai se lau: eo Gada eo Reubena, eo Manasa tupona, enadi se abieao tupo aruabo eai, Ioridano hari teha eai, doha Mose Guiau ena heaheari, i mosedi. ");
INSERT INTO swp_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","Tatao va abo se torohai, se lau, Iosua i lauhesomdi i ene, tano sigasigadi au uridi, au lau tano au taudadai, au uri, abo au uioma arigu eai, Guiau matana eai Siloa eai enamiu abo ea hekelero. ");
INSERT INTO swp_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","Tatao va se lau oea va se taudadai, buka eai eanua haligigi‐labui se uridi, abo se uioma Iosua arinai, Siloa eai. ");
INSERT INTO swp_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","Guiau matana eai Iosua i hekelero, arinai Iosua tano i soi Isaraela nanatunaeao enadi. ");
INSERT INTO swp_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","28","Beniamina edi kelero se abi edi tano sigasigadi se uri komakomanidi, eo edi eanua headi hinage. ");
INSERT INTO swp_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","9","Simeona boganaeao kelero helabuina se abi, edi tano sigasigadi se uridi. ");
INSERT INTO swp_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","16","Sebulona boganaeao kelero hehaionana se abi, edi tano sigasigadi se uridi. ");
INSERT INTO swp_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","23","Isakara boganaeao kelero hehasina se abi, edi tano sigasigadi se uridi. ");
INSERT INTO swp_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","31","Asa boganaeao kelero hehaligigina se abi, edi tano sigasigana se uridi. ");
INSERT INTO swp_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","39","Napatali boganaeao hehaligigi‐esegana se abi, edi tano sigasigadi se uridi. ");
INSERT INTO swp_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","48","Dana boganaeao kelero hehaligigi‐labui se abi, edi tano sigasigadi se uridi. ");
INSERT INTO swp_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","Tano se soiheohi, Isaraela nanatunaeao abo tano se mosei Iosua, Nuna natuna arinai. ");
INSERT INTO swp_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","Doha Guiau i ribaei eanua va i aibodai Timinatisera, Iperima tupina eai se mosei ia arinai, eanua i ginauri, arinai abo i mia. ");
INSERT INTO swp_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","Tano ede teina se soi va: tausoina Eleasa kohena tauna, eo Iosua, Nuna natuna, eo Isaraela nanatunaeao, hari boga, hari boga, edi babada hinage, Siloa eai, Guiau matana eai se hekelero, se soi numa bahebaheusi dobilana eai. Oea va abo se soi lautom. ");
INSERT INTO swp_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","6","Guiau, Iosua i heriba eanua headi Isaraela nanatunaeao se hetorodi, tauaiunugaibu ena aba dago. Ena tau esau helena taumia i unuigaibu, nige nuana aiunu, abo i dago, eanua esau va edi aba dagodagolau arinai i lage, abo i mauri. ");
INSERT INTO swp_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","9","Eanua va se hineridi ede teina, esadi abadagodagolau eanuadi, Kedesa, Galilaia eai. Sekema, Iperima eai. Kirigata‐aba, Heberona eai. eo Ioridano hari teha eai, Besa, Reubena edi gonu eai. Ramota, Giliadi eai. Golani, Basana eai. ");
INSERT INTO swp_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","1","Levi boganaeao edi babadaeao abo se laoma Eleasa kohena tauna arinai, eo Iosua, Nuna natuna hinage arinai, eo Isaraela nanatunaeao hari boga, hari boga, tamadieao aridi eai; ");
INSERT INTO swp_vpl VALUES ("JS21_2","007_21_2","JOS","21","2","2","Siloa, Kanana eai se ribalau aridi eai, si ene, Mose avana eai, Guiau i lauhesomiu, i ene, ema eanua, ema aba mia au ledima, eo oea begana hanahanaudi eai hinage emi burumakau edi aba aibai. ");
INSERT INTO swp_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","Isaraela nanatunaeao edi tano tupona Levi tataodi se mosedi doha Guiau i lauhesomdi, eanua headi, eo tano begana eanua va hanahanaudi eai. ");
INSERT INTO swp_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","42","Levi tataodi edi eanua se mosedi esadi se lautoredi. ");
INSERT INTO swp_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","Guiau tano gamagari i mosei Isaraela aridi eai, doha i riba aigora tamadieao aridi eai, se abiao, eo arinai se miahai. ");
INSERT INTO swp_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","Guiau abo i heaiavasidi tupo saesae, eo tupo dobidobi, doha hinage tamadieao i riba aigora, adi vaiunu gamagaridi aridi eai nige tau esau matadi eai ie toro: Guiau nimadi eai adi vaiunu i mosedi. ");
INSERT INTO swp_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","Ginauri lorodi, Guiau Isaraela nanatunaeao i ribahesunumadi va, nige begana se dabu: gamagaridi se abiheohidi. ");
INSERT INTO swp_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","Iosua Reubena, eo Gada, eo Manasa boganaeao tupona i eogaidi. ");
INSERT INTO swp_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","I ribalau aridi eai, i ene, riba gamagaridi Mose, Guiau ena heaheari i lauhesomiu au sogohidio, riba gamagaridi hinage ea lauhesomiu aridi ena au avaabiegu. ");
INSERT INTO swp_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","Asubena gamagaridi emi tataoeao nige au laugabaedi i laoma e teina asubena ta, Guiau emi Eaubada ena riba arinai i lauhesomiu va au sogohidi. ");
INSERT INTO swp_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","Guiau, emi Eaubada, emi tataoeao abo i heaiavasidi doha hinage i ribahesunumadi: abo au uio emi numa ruru eai, eo emi tano va Mose Guiau ena heaheari i reava, Ioridano hari teha eai. ");
INSERT INTO swp_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","Riba va, eo laugagaeo, Mose, Guiau ena heaheari i rediva, au nuatukomanidi eo au abivataidi; Guiau, emi Eaubada, au gadosisiei, ena dobila gamagaridi au lauvataidi, ena laugagaeo au sogohidi, au patulau ia arinai, au heaeaiei, ma nuamiu eo ma earuamiu. ");
INSERT INTO swp_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","Iosua i aihelahuidi, abo i hetamaridi se lau: se lau edi numa ruru aridi eai. ");
INSERT INTO swp_vpl VALUES ("JS22_7","007_22_7","JOS","22","7","7","Manasa boganaeao tupona edi tano Mose Basana eai i mosedi: Manasa tupona esau edi tano Iosua i mosedi Ioridano teina teha eai, tupo lalasi eai, Iosua i hetamaridi hinage se lau edi numa ruru aridi eai, i aihelahuidi. ");
INSERT INTO swp_vpl VALUES ("JS22_8","007_22_8","JOS","22","8","8","I ribalau aridi eai i ene, au uio emi numa ruru aridi eai, emi gogo gamagari au laei, eo emi bulumakau gamagaridi, eo ario, eo auro, eo barasi, eo poasi, eo emi ruru gamagaridi: ami vaiunu edi gogo au girihai emi tataoeao maemiu au soiei. ");
INSERT INTO swp_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","Reubena nanatunaeao, eo Gada nanatunaeao, eo Manasa boganaeao tupona se uio, Siloa, Kanana eai, Isaraela nanatunaeao se laugabaedi, se lau Giliadi oeana eai, edi tano mamohoi eai, doha Guiau i ribaei Mose avana eai. ");
INSERT INTO swp_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","Isi abo se lage Ioridano sigasigana eai, Kanana oeana eai, Reubena nanatunaeao, eo Gada nanatunaeao, eo Manasa boganaeao tupona, hatahata tabuna se ginauri, hatahata va i lai ariri, ");
INSERT INTO swp_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","Isaraela nanatunaeao vasana se ataiei, nige se ataiei komakomani, si ene Reubena nanatunaeao, eo Gada nanatunaeao, eo Manasa boganaeao tupona, hatahata tabuna se abi Kanana hari tupo eai, Ioridano sigasigana eai, Isaraela nanatunaeao edi aba gaeoavasi eai. ");
INSERT INTO swp_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","Isaraela nanatunaeao se ataieao, maudoudoidi se oigogoesega Siloa eai, bena se sae se ialaidi. ");
INSERT INTO swp_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","Isaraela nanatunaeao Piniasi, Eleasa kohena natuna, se hetamari Reubena nanatunaeao, eo Gada nanatunaeao eo Manasa boganaeao tupona aridi eai. ");
INSERT INTO swp_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","Vasavasa nanatudieao saudoudoi maena, Isaraela hari boga, hari boga, Vasavasa nanatudio, Isaraela moutuadi edi Vasavasa esau, esau. ");
INSERT INTO swp_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","Abo se lagema Giliadi eai Reubena nanatunaeao, eo Gada nanatunaeao, eo Manasa boganaeao tupona aridi eai, se ribalau aridi eai, si ene. ");
INSERT INTO swp_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","Guiau nanatunaeao se ribagogoesega, si ene, Teina baaea ta aisana omi au abi Isaraela edi Guiau matana eai: teina asubena ta au lau suara Guiau nige au hemurivatai, hatahata tabuna au hetero bena asubena ta Guiau au nuagabaei? ");
INSERT INTO swp_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","Peoa eai baaea ta abi, au ene i gagiri; baaea eai va sora nige se heaada, i laoma teina asubena eai ta, hinage Guiau nanatunaeao moutuadi boeadi eai baaea lailai se hearo va. ");
INSERT INTO swp_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","Omi teina asubena eai ta au lau suara, Guiau nige au hemurivatai? Vau ta Guiau au avaeagaraei, maraitom Isaraela moutuadi maudoudoidi abo i ouealaealaedi. ");
INSERT INTO swp_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","Taiede ena au ene emi tano va arinai au mia i baaea, au gaeoavasi au lau Guiau ena tano eai, Guiau ena numa bahebaheusi ena aba mia, abo au miahai boeamai eai: tabu Guiau au isuevaei, eo tabu au isuevaemai hinage, doha hatahata esau au hetero Guiau eda Eaubada ena hatahata tabuna hasarina eai. ");
INSERT INTO swp_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","Akana, Seraha natuna ena baaea i abi, e nigee? Isaraela maudoudoidi arinai se ouealaealaedi, e nigee? nei tau ne nige iabom mo ie mate ena baaea debana eai. ");
INSERT INTO swp_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","Reubena nanatunaeao, eo Gada nanatunaeao, eo Manasa boganaeao tupona se heuio se ribalau Isaraela moutuadi edi babadaeao aridi eai, si ene, ");
INSERT INTO swp_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","Guiau, eaubada edi Eaubada, eaubada edi Eaubada i nuatui, hinage Isaraela abo se nuatui: ena Guiau ai avaeagaraei, eo ai nuagabaei (teina asubena ta tabu au nuatoatoaimai). ");
INSERT INTO swp_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","Hatahata tabuna va ai hetero bena Guiau ai lausuaraei, eo nige ai hemurivatai; bena sarai alagorugoru, eo aitalasam arinai ai toredi, e bena ema roni ainauiadi ai toredi, Guiau ia i nuatui. ");
INSERT INTO swp_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","Nigee, ai hetoro paana ai matausi, ai ene, Huia murida eai ata nanatumiueao abo se ribalau nanatumaieao aridi eai, si ene, Guiau Isaraela edi Eaubada au sahai? ");
INSERT INTO swp_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","Paana Guiau Ioridano doha sigasigana i tore duaduarida eai, ai ede ina, omi ede nei, omi Reubena nanatunaeao, eo Gada nanatunaeao arinai nige emi tupo: arinai abo nanatumiueao nanatumaieao se heberuberudi, Guiau nige se matausiei, abo se lautom. ");
INSERT INTO swp_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","Arinai ede ai ene, Hatahata tabuna enada ta hetero, alagorugoru, eo aitalasam nige ai nuatui. ");
INSERT INTO swp_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","Ema nuatu mo bena omi, eo ai, eda heiheinoi ede, eo ada isimurita edi heiheinoi hinage, ai bena Guiau ena heaeaiei ai abi, ema alagorugoru, eo ema aitalasam, eo ema roni ainauiadi: na huia murida eai nanatumiueao nanatumaieao aridi eai taba nige se ene, Guiau arinai omi nige emi saha. ");
INSERT INTO swp_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","Arinai ai ene huia murida eai taba arimai eai eo ama isimurita aridi eai si ene doha nei, ai ene, Guiau ena hatahata tabuna tamadaeao se ginauri ana ao au ita, nige se ginauri bena se alagorugoru, eo se aitalasam: eda heiheinoi mo enamai eo enamiu. ");
INSERT INTO swp_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","Eaubada bena i nuahimai Guiau tabu ai ouealaealaei asubena ta ai lau suaraei, eo ia nige ai hemurivatai, bena hatahata tabuna ai ginauri ema alagorugoru, eo ema aitalasam; Guiau eda Eaubada ena hatahata tabuna hasarina eai, ena numa bahebaheusi matana eai, se tore. ");
INSERT INTO swp_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","Piniasi, kohena tauna, eo Isaraela moutuadi maudoudoidi edi babada, eo edi Vasavasa maenaeao Reubena nanatunaeao, eo Gada nanatunaeao, eo Manasa nanatunaeao edi riba se ataiei, nuadi se loro. ");
INSERT INTO swp_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","Piniasi, Eleasa kohena tauna natuna, i ribalau Reubena nanatunaeao, eo Gada nanatunaeao, eo Manasa nanatunaeao aridi eai, i ene Vau asubena ta ai itaeao Guiau boeada eai i mia, paana teina baaea va nige au abi Guiau matana eai, Guiau nimana eai Isaraela nanatunaeao abo au abihemauridi. ");
INSERT INTO swp_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","Piniasi, Eleasa kohena natuna, eo Vasavasa maenaeao, Reubena nanatunaeao, eo Gada nanatunaeao, se laugabaedi, oea Giliadi eai se lau Kanana eai, Isaraela nanatunaeao aridi eai, Vasavasa se heribadi. ");
INSERT INTO swp_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","Isaraela nanatunaeao vasa va se ataiei abo nuadi se loro: Isaraela nanatunaeao Eaubada se aihelahui, nige se sae se ialaidi va, Reubena, eo Gada nanatudieao edi oea, edi aba mia hinage nige se hebaaea. ");
INSERT INTO swp_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","Reubena, eo Gada nanatudieao hatahata tabuna va esana se tore Ede, paana si ene hatahata va eda heiheinoi, Guiau ia Eaubada. ");
INSERT INTO swp_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","I lau e, huia muriaririna eai Guiau Isaraela i heaiavasidi, edi vaiunu se hetaiiridi, nige se hebaaeadi: Iosua abo i tautaubada, ena borimai se gamagari. ");
INSERT INTO swp_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","Iosua Isaraela maudoudoidi i eogaidi edi babada, eo edi vasavasa, edi tauhekiraino, adi tanuaga hinage, aridi eai i ribalau i ene, Ea tautaubadao, eo egu borimai se gamagari: ");
INSERT INTO swp_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","Guiau, emi Eaubada, ena laulau teina basileia gamagaridi aridi eai omi debamiu eai au itaeao: Guiau emi Eaubada emi iala i ialaidi. ");
INSERT INTO swp_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","Teina basileia kelero eai enamiu ea soi, ami bogao edi tano Ioridano ie tubu, basileia headi ea torehesuaradi, i lau gabogabo lailai eai, tupo lalasi eai. ");
INSERT INTO swp_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","Guiau, emi Eaubada, matamiu eai abo i helautomdi, abo i henaudi taba nige au itadi, tano va abo au abi enamiu, doha Guiau emi Eaubada i ribahesunumamiu va. ");
INSERT INTO swp_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","Au nuakipikipi abo, ginauri gamagari se uridi Mose ena laugagaeo bukana eai au sogohidi, eo au abivataidi, tabu au lau suaraidi, tabu au lau teha tutuna, e teha seuseurina. ");
INSERT INTO swp_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","Teina basileia headi se mia boeamiu eai va tabu u lau boeadi eai: eo edi eaubada esadi tabu au ataidi, tabu au aigora aridi eai, tabu au heaeaiedi, eo tabu au tabaohu nuanuadi eai. ");
INSERT INTO swp_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","Guiau, emi Eaubada, au patudidini arinai, doha emi laulau asubena ta. ");
INSERT INTO swp_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","Paana basileia lailaidi, eo adidiridi matamiu eai i hetatagorigoridi, nige tau esau i toro matamiu eai i laoma e asubena ta. ");
INSERT INTO swp_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","Tau esega arimiu eai, tausani esega abo i henaudi: paana ede Guiau, emi Eaubada, emi iala i ialaidi, doha hinage i ribahesunumamiu. ");
INSERT INTO swp_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","Au nuatukomakomaniuioimiu: Guiau emi Eaubada abo au gadosisiei. ");
INSERT INTO swp_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","Ata au sinibui, eo au patulau teina basileia headi boeamiu eai se mia aridi eai, eo au tavasoraidi, eo boeadi eai au sae, eo au dobi. ");
INSERT INTO swp_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","Eamoisa, abo au nuatui, Guiau, emi Eaubada, taba nige basileia esau matamiu eai abo i hetatagorigori, isi abo se miahai boeamiu eai doha sa e, eo lisilisimiu edi pidipidiri, eo matamiu edi nurinuri, i lau e, teina oea lorona, Guiau emi Eaubada i leava, arinai abo au mateohi. ");
INSERT INTO swp_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","Teina asubena ta tanoubu dobilana abo ea lauei: gamagarimiu nuamiu eai, eo earuamiu eai au nuatuiao, nige ginauri esega ue dabu, ginauri lorodi gamagaridi Guiau, emi Eaubada, i heribamiu: gamagaridi i ledivao enamiu; nige ginauri esega ue dabu. ");
INSERT INTO swp_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","Ginauri lorodi gamagaridi Guiau, emi Eaubada, i ribahesunumamiu va i ledivao; hinage doha, Guiau abo ginauri baaeadi gamagaridi i hetubudi arimiu eai, i lau e, oea lorona Guiau, emi Eaubada, i reava va arinai abo i hemateohimiu. ");
INSERT INTO swp_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","Ena Guiau, emi Eaubada, ena riba i ribahesunumamiu au utusi, eo au lau hari eaubada au heaeaiedi, eo au tabaohu nuanuadi eai, nei huiana ne Guiau ena ouealaeala arimiu eai abo ie hetubu, tano lorona eai i reava enamiu abo au mateheula. ");
INSERT INTO swp_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Iosua, Isaraela adi bogao gamagaridi Sekema eai i heoigogoidi; Isaraela edi babadaeao, eo edi vasavasaeao, eo edi taukirainoeao, eo edi tanuagaeao: Eaubada matana eai se laoma. ");
INSERT INTO swp_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Iosua i ribalau tatao gamagaridi aridi eai, i ene, Guiau, Isaraela edi Eaubada i ene ina doha, mumuga eai tamamiueao goila hari teha eai se miahai, ia ede Teraha, Aberahama tamana, eo Nahora tamana, hari eaubada se heaeaiedi. ");
INSERT INTO swp_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Tamamiu Aberahama goila hari teha eai ea abi, ea woeai Kanana oeana eai, i taudadai, tumanaeao ea helai, abo Isaako ea mosei ia arinai. ");
INSERT INTO swp_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","Isaako, Iakobo eo Isoa ea mosei: Seia tupina ea mosei Isoa arinai, arinai i mia, Iakobo maena nanatunaeao se dobi Aigupito eai. ");
INSERT INTO swp_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","Mose, eo Arona ea hetamaridi, Aigupito ea hebaaeadi doha egu laulau gamagaridi aridi eai: e murina eai ea woeaimiu murimuri eai. ");
INSERT INTO swp_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","Tamamiueao Aigupito eai murimuri eai ea woeadima: abo gabogabo eai au lagema: Aigupito tataodi tamamiueao edi kariota, eo edi tauiala hosi potadi eai se geru se henaumiu, i lau e Gabogabo Buiabuiana eai. ");
INSERT INTO swp_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","Se eogalau Guiau arinai, abo omi, eo Aigupito tataodi duaduarimiu eai masigiri ea hetubu, gabogabo hinage i saema, i buburidi, matamiu eai egu laulau Aigupito eai au itadi, huia roharoha barabara eai aue mia. ");
INSERT INTO swp_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","Ea woeaimiu, Amoraiti tataodi edi oea eai au lagema, Ioridano hari teha eai se mia: se ialaimiu, abo nimamiu eai ea toredi, edi oea bena au abi enamiu; matamiu eai ea hematedi. ");
INSERT INTO swp_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","Abotai Balaki, Sipoa natuna, Moaba edi Vasavasa i toro Isaraela i ialaidi headi i hetamaridi Balama, Beoa natuna, i eogai bena i hebaaeamiu. ");
INSERT INTO swp_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","Balama ena riba nige ea ataiei arinai i aihelahuimiu mo: ia nimana eai ea abihemaurimiu. ");
INSERT INTO swp_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","Ioridano abo au gaeoavasi, abo Ieriko eai au lage, Ieriko tataodi se ialaimiu; eo Amoraiti hinage, eo Peresaiti, eo Kanana, eo Hitaiti, eo Gagavaiti, eo Haivaiti tataodi se ialaimiu; isi nimamiu eai ea lediva. ");
INSERT INTO swp_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","Gumo ea hetamari i eda bagunaimiu, matamiu eai i hetatagorigoridi: Amoraiti edi vasavasa labui, emi elepa eai mo nigee, eo emi alahia eai nigee. ");
INSERT INTO swp_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","Oea va ea reava arinai nige au paipaisoai, eo eanua nige au ginauridi ea lediva, boeadi eai aue mia: oea va nige au umaidi hinage aridi eai ami aiai au abi au ai. ");
INSERT INTO swp_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","Arinai ede Guiau au matausiei, au heaeaiei ma nuamiu se ohi, au heaeaiei mamohoi: eaubada tamamiueao se heaeaiedi goila hari teha eai, eo Aigupito eai, au toresuaraidi; Guiau abo au heaeaiei. ");
INSERT INTO swp_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Ena au ene Guiau ta heaeaiei i baaea, teina asubena ta au nuatui, eai abo au heaeaiei: eaubada va tamamiueao se heaeaiedi goila hari teha eai, Amoraiti tataodi edi oea arinai au miahai edi eaubadaeao: eau mo, eo egu numa taumiaina, ai Guiau abo ai heaeaiei. ");
INSERT INTO swp_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Tatao abo se heuio si ene, Eaubada taba i nuahimai, Guiau abo ai nuagabaei bena hari eaubada ai heaeaiedi: ");
INSERT INTO swp_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","Guiau, ema Eaubada, ai, eo tamamaieao Aigupito eai i woeaidima, numa tutugudui eai ai laoma, heiheinoi lailaidi matamai eai i ginauridi, dobila gamagaridi eai ai laoma, eo tatao gamagaridi boeadi eai ai laoma, i itavataimai: ");
INSERT INTO swp_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Matamai eai hinage Guiau tatao gamagaridi i hetatagorigoridi, doha Amoraiti tataodi oea eai se mia: arinai ede ai hinage Guiau abo ai heaeaiei: paana ia ema Eaubada. ");
INSERT INTO swp_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","Iosua i ribalau tatao aridi eai i ene, Guiau taba nige au heaeaiei: paana ede ia Eaubada tabuna, eo ia Eaubada aiaromagigirina ede: laugagaeo au utusidi, eo emi baaea taba nige i ribagigiridi. ");
INSERT INTO swp_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","Ena Guiau au nuagabaei, hari eaubada, hari eaubada bena au heaeaiei abo i hebaaeamiu, eo i helautomiu, abiabi lorodi i abidi arimiu eai va abo se lautom. ");
INSERT INTO swp_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","Tatao abo si ene, Nigee, Guiau mo abo ai heaeaiei. ");
INSERT INTO swp_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","Iosua abo i ribalau tatao aridi eai i ene, Au witinesiuioimiu, Guiau au hineri, ia abo au heaeaiei. Si ene Ai witinesi ede. ");
INSERT INTO swp_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","I ene, hari eaubada boeamiu eai au gabaedi, Guiau Isaraela edi Eaubada nuamiu abo se lauei. ");
INSERT INTO swp_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","Tatao se ribalau Iosua arinai, si ene, Guiau eda Eaubada abo ai heaeaiei, ia arinana abo ai avaabiei. ");
INSERT INTO swp_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","Arinai nei asubena eai ne Iosua tatao i ribahesunumadi, laugagaeo, eo sanapu esau Sekema eai i toredi. ");
INSERT INTO swp_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","Iosua Eaubada ena laugagaeo bukana eai teina riba ta i uridi: veu tau lailai i abi, i hetoro oeagi paana eai, Guiau ena numa tabuna hasarina eai. ");
INSERT INTO swp_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","Iosua i ribalau tatao gamagaridi aridi eai, i ene, Au ita, arida eai teina veu ta abo eda witinesi: paana riba gamagaridi Guiau i ribalau arida eai i ataiei: arinai abo ia eda witinesi, ata emi Eaubada au morui. ");
INSERT INTO swp_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","Iosua tatao abo i hetamaridi se lau, esau, esau, i lau ena tano arinai. ");
INSERT INTO swp_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","Teina ginauri se ohi, e abotai abo Iosua, Nuna natuna, Guiau ena heaheari i odalele, ena borimai tataohaligigi‐se‐mate‐saudoudoi. ");
INSERT INTO swp_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","Ena tano Timinata‐sera sigasigana eai se tore, Iperima tupina eai, Gasa tupina, teha bauri eai. ");
INSERT INTO swp_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","Iosua ena huia eai Isaraela Guiau se heaeaiei, eo babadaeao gamagaridi Iosua se hemuri edi huia eai, isi Guiau ena paisoa gamagaridi i abidi Isaraela aridi eai, se nuatuiao. ");
INSERT INTO swp_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","Iosepa siadana va Isaraela nanatunaeao Aigupito eai se abidima Sekema eai se toredi, oea va Iakobo i uneune Sekema tamana, Hamora nanatunaeao aridi eai, maisana i mosedi ario tatao haligigi‐se‐mate va: oea va Iosepa nanatunaeao abo se abi enadi. ");
INSERT INTO swp_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","Eleasa, Aarona natuna abo i odalele: ia natuna Piniasi ena oea tupina eai se tore, oea va se mosei ia arinai, Iperima tupina eai. ");
INSERT INTO swp_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Tau wa ie kode ia laulau gewagewa tataodi edi ribahesanapu nige i laulauedi, baaea tataodi edi dobila eai nige i totoro, eo Eaubada tau‐alaliuliuwaena edi oigogo eai nige i patulau; ");
INSERT INTO swp_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","na GUIAU ena laugagaeo i kodei mo, eo i hasihasiri asubena to maiona. ");
INSERT INTO swp_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Ia doha oeagi esau saga gegesina eai se umai, ena huia ua eai aiaina abo ie tore, eo luguna taba nige se wowoea. Ginauri gamagaridi i ginauridi abo se lau lolo. ");
INSERT INTO swp_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Laulau gewagewa tataodi isi nige meta doha, isi doha sitona wenudi mana i eoho’eohoedi. ");
INSERT INTO swp_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Arinai ede laulau gewagewa tataodi hedudurai asubenana eai taba nige se toro, eo baaea tataodi taulaulau dudurai edi oigogo eai taba nige se toro. ");
INSERT INTO swp_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Paana GUIAU laulau dudurai tataodi i abi komakomanidi, na laulau gewagewa tataodi abo se tauyamui. ");
INSERT INTO swp_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Paana saha eanua gamagaridi taumiaidi se oioiriba, eo tatao se saha se nuanuatu gaibu mo? ");
INSERT INTO swp_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Tanoubu wasawasadi se totoro‐lelei, tanutanuaga hinage se oiribagogoesega GUIAU bena se laugudugudui eo ena heyausi tauna, si ene, ");
INSERT INTO swp_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","“Edi auau ta oimotudi, eo edi maina poasi ta gabahesuaradi!” ");
INSERT INTO swp_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Ia galewa eai ie mia abo i maruhi; GUIAU ia abo i alaliuliuwaedi. ");
INSERT INTO swp_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Abotai ma ouyalayalana abo i ribalau aridi eai, ena ouyalayala eai abo i hematausi aririedi, abo i ene, ");
INSERT INTO swp_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","“Eau egu wasawasa ea hetoroyao wa egu oea tabuna Siona tupina arinai.” ");
INSERT INTO swp_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","GUIAU ena laugagaeo ribana abo ea heribamiu: I ribalaoma i ene, “Oa natugu ede, wauta ea hemala oa tamam. ");
INSERT INTO swp_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","U aibodalaoma, abo eanua gamagaridi taumiaidi ea lediwa em gogo, eo tanoubu maudoudoina abo oa enam. ");
INSERT INTO swp_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Oa abo u hetamogorugorudi poasi tu’ena arinai, abo u oigorugoru hegahegagiridi doha gulewa.” ");
INSERT INTO swp_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Omi wasawasa e, bena au sibasiba; omi tanoubu tanutanuagamiu bena se ribahesanapumiu. ");
INSERT INTO swp_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Ma matausimiu GUIAU au heayaiyei, ma tabutabubumiu ");
INSERT INTO swp_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","aena au alagoiedi, ata i ouyalayala, eo dobila eai au mate, paana ena ouyalayala i heura ariariri. Tatao gamagaridi ena se dagolau ia arinai abo nuadi se kode. ");
INSERT INTO swp_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","GUIAU, tanuagamai e, tanoubu maudoina eai oa esam i sae ariariri! Galewa ewana eai oa namanamarim se wanai ");
INSERT INTO swp_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","kaimou gagiridi, taumadomado awadi eai, iala numana adiadidirina u hetoro em waiunu debadi eai, waiunu eo tauabigum em abahemonoudi. ");
INSERT INTO swp_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Ena ea itasae em galewa eai, oa nimagigim paisoadi, nawarai eo ipora hinage oa tautoredi; ");
INSERT INTO swp_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","tau ede saha bena oa u nuanuatui, eo tau natuna eai bena oa u abiloloei? ");
INSERT INTO swp_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Taiede oa u ginauri Eaubada ia begana mo i hemuri, eo namanamari eai eo heasisina eai ia u hekorona. ");
INSERT INTO swp_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Oa nimam eai ginauri gamagaridi u ginauridi wa u mosedio ia tanuagadi eai ie lau; ginauri gamagaridi ia aena ubudi eai ue toredi, ");
INSERT INTO swp_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","mamoe eo bulumakau gamagamagaridi, eo nuura suisuidi hinage, ");
INSERT INTO swp_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","ewa manudi eo gabogabo eamadi, eo ginauri gamagaridi gabogabo dobiladi eai se laulau. ");
INSERT INTO swp_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","GUIAU, tanuagamai e, tanoubu maudoina eai oa esam i sae ariariri! ");
INSERT INTO swp_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","GUIAU e, abo i lau e aitea huia? Abo u nuahuiegu i lau e ana huia ana tasi? I lau e aitea huia matam abo u buburi taba nige ea itam? ");
INSERT INTO swp_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","I lau e aitea huia abo nuagu eai amamna lailai, eo asubena to maiona abo nuadubu nuagu eai? I lau e aitea huia agu waiunu abo i saepoigu? ");
INSERT INTO swp_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","U italaoma eo u heuioegu, GUIAU e, egu Eaubada; matagu u hemaradi ata mate mamohoi enona ea enoei; ");
INSERT INTO swp_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","ata agu waiunu i ene, “Ea saepoiyao”; ata agu waiunu se kode paana egu tabutabubu debana eai. ");
INSERT INTO swp_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Na oa em gadosisi miatahitahina ea sunumaei, nuagu abo i kodelamposi em abihemauri debana eai. ");
INSERT INTO swp_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","GUIAU arinai abo ea wana, paana ia i ainauia aririegu. ");
INSERT INTO swp_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Taueauyaure ia i ribariba nuana eai i ene, “Eaubada nige’e.” Isi tatao bi’ibi’idi, edi laulau se manamanabara ariri, nige esau ena laulau i dudurai. ");
INSERT INTO swp_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","GUIAU ia galewa eai i itadobi tatao nanatudiyao aridi eai, bena i itadi eai to eai se mia dudurai, eai to eai Eaubada se eo’oi. ");
INSERT INTO swp_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Isi gamagaridi se gegege, isi gamagaridi edi miamia doha ie boha, nige esau i mia dudurai, nige’e, nige ariariri. ");
INSERT INTO swp_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Edi sonoga nige’e, tatao baabaaeadi ta, agu bogaoyao se aidi doha falawa se aiaini, eo nige se eogalau GUIAU arinai? ");
INSERT INTO swp_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Matausi lailai didiga abo se hearo paana Eaubada ia laulau dudurai tataodi edi tupo eai. ");
INSERT INTO swp_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Gogo gesagesa tauna ena nuatu isi bena se gudugudui, na ena abadago ede GUIAU. ");
INSERT INTO swp_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Taba Isaraela ena abihemauri Siona eai i pesama! Huiana wa GUIAU ena tataoyao edi gogo i hemaisauioidi Iakobo abo i kodelamposi, Isaraela abo nuana i lolo. ");
INSERT INTO swp_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","GUIAU e, eai gonoana i bawa oa em numalulu arinai? Eai abo i mia em oea tupi tabuna eai? ");
INSERT INTO swp_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Tau wa nige abahegiruna, eo laulau dudurai i laulauedi, ia hinage nuana eai riba mamohoi mo i ribaribaei; ");
INSERT INTO swp_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","ia wa memenana eai nige monumonunu, ena dodogayao nige i heamamna, eo helena‐taumia‐tauna nige i ribasagasagariei; ");
INSERT INTO swp_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","laulau gewagewa tauna i isuewaei, na GUIAU taumatausi tataodi ia abo i hedebasaedi; ena riba aigora i hemamohoiei piripiri boeana eai; ");
INSERT INTO swp_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","ia moni ena i mosehagahagaidi, taba nige hagahagana bena i abiuioi, hinage taba nige moni se mosei bena laulau dudurai tauna i hegirugaibui. Ia wa ena laulau doha ina, ia taba nige se hemoiu, nige ariariri. ");
INSERT INTO swp_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Eaubada e, bena oa u hemaurigu, paana ea dagolaowa oa arim eai. ");
INSERT INTO swp_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Ea ribalau GUIAU arinai ea ene, “Oa egu Guiau ede; egu lolo ede oabom mo arim eai.” ");
INSERT INTO swp_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Oa em hetabu tataodi isi heasisi tataodi ede, egu nualolo maudoina isi wa aridi eai. ");
INSERT INTO swp_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Tatao wa isi eaubada esau se hineri isibom edi nuadubu se helai; edi aitalasam osiosina taba nige ea hegoigabaedi, esadi taba nige ea abidi sopagu eai. ");
INSERT INTO swp_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","GUIAU ia egu hinehineri tupona ede, eo egu abanom, egu mauri ede oabom nimam eai. ");
INSERT INTO swp_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Dobila lolodi aridi eai u woeawoeaigu, mamohoi em ainauia enagu i sae ariri. ");
INSERT INTO swp_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","GUIAU ea ribatausaei ia tauribahesanapugu; maiona huiana eai hinage nuagu eai i heaheatagu. ");
INSERT INTO swp_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Huia gamagari GUIAU ea itadidini matagu eai, paana ia nima‐tutugu eai abo taba nige ea moiu. ");
INSERT INTO swp_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Arinai nuagu i lolo ariri, eo earuagu i kodelamposi, taugu hinage i ota komakomani. ");
INSERT INTO swp_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Paana oa taba nige u moselaegu Hade eai, eo taba nige u eari em hetabu tauna Duha lailai i ita. ");
INSERT INTO swp_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Mauri dobilana oa u heiheitagu; oa matam eai kode saesaena mo, nimatutum eai amna lolo mo, i lau e ana huia ana tasi. ");
INSERT INTO swp_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Eaubada ena namanamari galewa i ribahemasaraha, eo teha ewa eai nimana paisoana i wasawasaei. ");
INSERT INTO swp_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Asubena to asubena ena riba se hetamarilaei, eo maiona to maiona ena sonoga se ribahelai. ");
INSERT INTO swp_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Isi nige arinadi dagugudi, eo nige edi riba, memenadi nige dagugudi; ");
INSERT INTO swp_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","ia mo arinadi ie lau tanoubu maudoina boeana eai, edi riba hinage se lau tanoubu sigana eai. Duaduaridi eai mahana ena numalulu i hetoro, ");
INSERT INTO swp_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","ia doha tautawasora harihariu wa ena numa i torohaigabaei, doha tau adiadidirina ma kodena ena dobila i laulauwatai. ");
INSERT INTO swp_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Ena abadalasae ede galewa tupo esau eai, i hetahetaiiri i lau e ie lage galewa sigana eai; gigiborina arinai hinage taba nige ginauri saha i tauyamui. ");
INSERT INTO swp_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","GUIAU ena laugagaeo i lolo dumaduma, tau earuana i hemauriuioi; GUIAU ena abahemasaraha ribadi mamohoidi ede, tau nuasupusupuna i hesonoga. ");
INSERT INTO swp_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","GUIAU ena lauheata ribadi se dudurai, tatao nuadi se hekodedi; GUIAU ena lauhesom ie a’a esegai, tatao matadi se hemaradi. ");
INSERT INTO swp_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","GUIAU matausina ie a’a, i mia i lau e huia nige nosina; GUIAU ena hesanapu ribadi mamohoidi ede, eo se dudurai ariri. ");
INSERT INTO swp_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Ta henua aririedi abotai gold, gold gamagaridi lolololodi wa; edi amna amoamo ena amna i hemuri, amoamo wa noina eai i namnamtutu. ");
INSERT INTO swp_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Ribadi wa aridi eai em heaheari tauna se ribahesanapuei; sogohidi eai ainauiana abo i lai ariri. ");
INSERT INTO swp_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Aitea tau iabom ena baaea italobaina abina ie ata? Egu laulau baaeadi eamuyamuidi aridi eai bena oa u hea’agu. ");
INSERT INTO swp_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Oa em heaheari tauna ta bena nuasaesae baaeadi aridi eai u nuahi; tabu se tanuagaigu! Abotai abo ea toro dudurai, eo awayagara lailaina arinai taba nige edi abahegirugu. ");
INSERT INTO swp_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Taba awagu ribadi eo nuagu nuanuatuna oa matam eai bena se dudurai, GUIAU e, egu we’utau, eo tau unehemaurigu. ");
INSERT INTO swp_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Egu Eaubada e, egu Eaubada e, ue saha u nuagabaegu ta? Paana saha oa eda lohaloha eai, na nige u saguigu, egu dou nige u ataiei? ");
INSERT INTO swp_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Eaubada e, asubena huiadi eai ea dousaewa, na nige u heuio, maiona huiadi eai hinage, na nige aiawasi ea lobai. ");
INSERT INTO swp_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Iamo oa tabuna ede, oa se hebawam Isaraela edi aihelahui potadi eai. ");
INSERT INTO swp_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Tamamaiyao oa se sunumaem, se sunumaem arinai oa u lebohaidi. ");
INSERT INTO swp_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Se doulaowa, eo se mauri; oa se sunusunumaem, eo nige u laudobiedi. ");
INSERT INTO swp_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Na eau motamota mo na nige tau; tatao se subugu, dodoga se isuewaegu, ");
INSERT INTO swp_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Isi gamagaridi se itagu eo se alaliuliuwaegu, adi ao se hebaaeadi arigu eai, eo urudi se heodedi: ");
INSERT INTO swp_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","“Ena sunuma ie tore GUIAU arinai; besi ia i lebohai! Hage ia i saguhai, paana ena nualolo ia arinai!” ");
INSERT INTO swp_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Omihede oa ede sinagu bogana eai u abihaigu; sinagu susuna eai oa u itawataigu. ");
INSERT INTO swp_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Egu huia labasi eai i laoma e wauta oa u itawataigu, sinagu bogana eai i laoma e huia ta oa egu Eaubada ede. ");
INSERT INTO swp_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Tabu oa eda lohaloha eai, paana huia baaea i hanahanauma, eo nige doga esau bena i saguigu. ");
INSERT INTO swp_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Bulumakau tamoadi gamagaridi se torohetai’irigu; Basana edi bulumakau adiadidiridi se torohetai’irigu; ");
INSERT INTO swp_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","awadi se dabari helaidi matagu eai doha liona guriguriamdi, eo se doulailai. ");
INSERT INTO swp_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Amnagu ede doha goila se hegoigabaei, eo siadagu popodi se tarumo. Nuagu doha wax nuapougu eai ie welo; ");
INSERT INTO swp_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","adidirigu ie ohi, doha gulewa se oigoru, memenagu ie patu gaeagaeagu eai; mate mua’a mua’ana eai u he’enogu. ");
INSERT INTO swp_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Mamohoi kedewa se torohetai’ irigu, tatao manamanabaradi se torohetai’ irigu; nimagu eo aegu se aigoridi— ");
INSERT INTO swp_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","siadagu gamagaridi se hasiridi— tatao wa se aiai’ewaigu eo nuadi se lolo; ");
INSERT INTO swp_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","agu lulu se soiedi, eo agu lulu gamagaridi hinage se hekelerodi. ");
INSERT INTO swp_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Na oa, GUIAU e, tabu u mia eda lohaloha eai, oa agu sagu ede, u heurama u saguigu! ");
INSERT INTO swp_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Earuagu bena u saguhai elepa eai, kedewa edi gigibori eai hinage u abihemaurigu! ");
INSERT INTO swp_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Liona awana eai u hemaurigu, bulumakau manamanabaradi donadi eai earuagu nuanuadubuna bena u saguhai! ");
INSERT INTO swp_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Oa esam abo ea wasawasaei egu tataoyao aridi eai, tatao peledi boeadi eai abo ea aihelahuim: ");
INSERT INTO swp_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Omi, eai to eai GUIAU au matausiei, ia au aihelahui! Omi, Iakobo nanatunayao ia au ribapasipasiei, ia matausina nuamiu eai, omi Isaraela nanatunayao! ");
INSERT INTO swp_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Paana ia tau ai’iwala ana iwala nige i isuewaei eo nige i hewaiunuei; matana nige i toreamui arinai, na ena dou mo i ataiei. ");
INSERT INTO swp_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Moutuana matadi eai abo ea hedebasaem; egu riba aigora abo ea heduduraidi isi taumatausiem matadi eai. ");
INSERT INTO swp_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Tau gogogesagesa abo se aiai, eo abo bogadi se sese. Eai to eai ia se eo’oeo’oi abo GUIAU se hedebasaei! Bena se amna lolo i lau e nige nosina! ");
INSERT INTO swp_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Tanoubu tupo gamagamagari abo se henuaisini eo abo se sinibui GUIAU arinai; eanua gamagaridi taumiaidi abo se tabaohu ia arinai. ");
INSERT INTO swp_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Paana GUIAU ia wasawasa ede, eanua gamagaridi taumiaidi ia tanuagadi eai ie lau. ");
INSERT INTO swp_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Mamohoi ariri ia matana eai tanoubu taunuasaesae gamagaridi abo se tabaohui; isi gamagaridi se hemala tanouio ia arinai abo se tabaohu, isi hinage nige abina se ata se hemauriuioidi. ");
INSERT INTO swp_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Isimurita ia abo se heayaiyei; Guiau wasana tatao adi isimurita abo se heribadi, ");
INSERT INTO swp_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","ena mauri abo se wasaduaiei isi sora nige se labasidi aridi eai, ia ana paisoa ede meta. ");
INSERT INTO swp_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","GUIAU ia taumiataunigu doha mamoe tauitawataina; eau taba nige saha ea deha. ");
INSERT INTO swp_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Abaaibai lolodi eai i heotagu. Goila ipudi daumoridi gegesidi eai i woeaigu; ");
INSERT INTO swp_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","earuagu i hemauriuioi. Laulau dudurai dobiladi eai i woeawoeaigu, iabom esana debana eai. ");
INSERT INTO swp_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Ena mate gonuna masimasigirina eai ea lulau, taba nige baaea aisana ea matausiei; paana ede oa maidagu; em pidipidiri, eo em tu’e se henuabigagu. ");
INSERT INTO swp_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Hatahata enagu ue wese agu waiunuyao matadi eai; urugu u heyausi, egu bia i monau boriboriri. ");
INSERT INTO swp_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Mamohoi, abilolo eo nuatoatoa abo se hemuriwataigu egu mauri asubenadi gamagaridi eai; eo GUIAU ena numa eai eau abo ea miahai i lau e huia nige nosina. ");
INSERT INTO swp_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Tanoubu ma ginaurina gamagarina GUIAU enana ede, tanoubu eo isi taumiaina gamagaridi hinage. ");
INSERT INTO swp_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Paana ia iabom gabogabo potana eai i hetoro, eo goila ubu eai potadi eai i tore komakomani. ");
INSERT INTO swp_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Eai gonoana abo i dalasae GUIAU ena oea tupina eai? Eo eai ena eanua tabuna eai abo i toro? ");
INSERT INTO swp_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Ia wa ena nimana se a’a, eo nuana i a’a mamohoi hinage, ia wa nuana taba nige i sae ginauri borabora arinai, eo nige i aigora borabora. ");
INSERT INTO swp_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Ia GUIAU ena ainauia lolona abo i abi, eo nige abahegiruna ena mauri Eaubadana matana eai. ");
INSERT INTO swp_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Ia tau eo’oina isina adi ao ede ina, Iakobo ena Eaubada matana taueo’oina wa. ");
INSERT INTO swp_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Urumiu au lauisinidi, omi gana dobilamiu e! Omi se lauisinimiu, gudu lailaimiu beabeamiu e! Namanamari Wasawasana bena i lusorama! ");
INSERT INTO swp_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Wau namanamari Wasawasana wa eai? GUIAU ede, ma adidirina, ma gigiborina, GUIAU ia iala eai i gigibori wa! ");
INSERT INTO swp_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Urumiu au lauisinidi, omi gana dobilamiu e! Omi se lauisinimiu, gudu lailaimiu beabeamiu e! Namanamari Wasawasana bena i lusorama! ");
INSERT INTO swp_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Namanamari Wasawasana wa ia ede eai? Tauiala tataodi moutuadi GUIAUNA, ia ede namanamari Wasawasana! ");
INSERT INTO swp_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","GUIAU e, earuagu ea lauisini oa arim eai. ");
INSERT INTO swp_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Egu Eaubada e, egu sunuma ea tore’esegai oa arim eai, tabu se hetaumaeamaeagu agu waiunuyao tabu se saepoigu. ");
INSERT INTO swp_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Hedeomi, eai to eai se bagibagilaoa oa arim eai taba nige se taumaeamaea, na isi mo dodoga manamanabaradi i lolo isi se hetaumaeamaeadi. ");
INSERT INTO swp_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","GUIAU e, em laulau bena u heitagu; em dobila bena u heatagu. ");
INSERT INTO swp_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Em riba mamohoina bena arinai u woeaigu, eo u heatagu, paana oa egu mauri Eaubadana ede. Asubena lohaloha eai oa ea bagibagiem. ");
INSERT INTO swp_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","GUIAU e, em nuatoatoa tabu u nuahuiei, eo em gadosisi miatahitahina, mumuga eai ie mia i lau e nige nosina. ");
INSERT INTO swp_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Hewarigu laulaudi baabaaeadi tabu u henuaisinidi, e egu awayagara; oa em gadosisi miatahitahina mo arinai abo u nuatuigu, em abilolo debana eai, GUIAU e! ");
INSERT INTO swp_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","GUIAU i lolo eo i dudurai; arinai tatao baabaaeadi dobila i heitadi. ");
INSERT INTO swp_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Tau nuatudobidobiuioina dobila duduraina arinai i woeai, eo tau nuatudobidobiuioina ia ena eda i heata. ");
INSERT INTO swp_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","GUIAU ena abiabi gamagaridi aridi eai gadosisi miatahitahina eo riba hemamohoiena i hemasarahadi, isi, eai to eai ena ribahesunuma eo ena riba tabudi se sogohididinidi. ");
INSERT INTO swp_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Oa esam debana eai, GUIAU e, egu baaea giruna bena u ribagigiri, paana ie lai. ");
INSERT INTO swp_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Aitea tau ia GUIAU i matausiei? ia abo i heata aisega dobila bena i hineri. ");
INSERT INTO swp_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Ia abo i mia komakomani, taba nige saha i deha, eo nanatunayao edi tano abo se abi isi enadi. ");
INSERT INTO swp_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","GUIAU ena awa’eha i mosei isi ia se matausiei aridi eai ena ribahesunuma hinage i hemasaraha aridi eai. ");
INSERT INTO swp_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Matagu huia gamagari ea tusaei GUIAU arinai, aegu sai’i eai abo i abihaidi. ");
INSERT INTO swp_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","U sinibuima, eo u nuatoatoaegu, paana ede eaubom, nige agu sagu, eo ea amnabaaea. ");
INSERT INTO swp_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Nuagu ena amamna bena u laehesuara eo egu nuadubu eai bena u abiisinigu. ");
INSERT INTO swp_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Egu nuadubu eo agu iwala bena u nuatui, eo egu baaea gamagamagaridi bena u ribagigiridi. ");
INSERT INTO swp_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Agu waiunu gamagamagaridi bena u nuatuidi, edi hewaiunu hinage arigu eai i karapi ariri. ");
INSERT INTO swp_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Nuagu u itawatai, eo u saguhaigu; tabu se hetaumaeamaeagu, paana egu abadago ede oa. ");
INSERT INTO swp_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Egu miamia a’a eo egu laulau dudurai bena se ganaganaigu, paana ea bagibagilaoa oa arim eai. ");
INSERT INTO swp_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","GUIAU e, Isaraela ena lauita gamagaridi aridi eai oa bena u unehai. ");
INSERT INTO swp_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","GUIAU ia egu mara eo egu abamauri ede; eai abo ea matausiei? GUIAU ia egu mauri ena iala bonana ede; eai matausina abo ea matausi? ");
INSERT INTO swp_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Ena tatao manamanabaradi se ialaigu eo se aipate bena se unuigu, agu waiunu eo isi tau hebaaeagu, abo se alabesibesi eo abo se beu. ");
INSERT INTO swp_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Taba iala tataodi gamagaridi se hetaiirigu, taba nige aruagu i loi; taba hinage se ialaigu, nuagu taba nige se hemoiu. ");
INSERT INTO swp_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Ginauri esega dumaduma GUIAU arinai ea aibodai, abo hinage ea eo’owatai: ia ede bena GUIAU ena numa eai ea miamia egu mauri asubenadi gamagaridi eai, GUIAU ana ao lolo dumadumana bena eai itaitai, eo bena ena dubu alona eai ea aiaibodalau. ");
INSERT INTO swp_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Paana ede huia baaea eai ena abaailogulogu eai abo i toreamuigu; ena apa birigomna eai abo i buburigu, ia abo i abiisinigu we’utau saesaena potana eai i toregu. ");
INSERT INTO swp_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Abotai eau urugu abo se lauisini agu waiunuyao se toro hetaiirigu ea saetawatawaidi, arinai ena numa lulu eai aitalasam abo ea gabudi ma wowogu; abo ea wana, eo GUIAU abo ea aihelahui! ");
INSERT INTO swp_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","GUIAU e, ena ea eoga lailai bena u ataatai! Em abilolo bena u hemasara arigu eai, eo u heuioegu! ");
INSERT INTO swp_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","U ribaeyao u ene, “Matagu u eo’oi.” Nuagu i heuioem, i ene, “GUIAU e, matam abo ea eo’oi.” ");
INSERT INTO swp_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Tabu matam u woeoi arigu eai. Em heaheari tauna tabu u aiduiei ma ouyalayalam, tau saguigu ede oa. Tabu u gabahesuaragu, tabu u nuagabaegu, abihemaurigu Eaubadana e! ");
INSERT INTO swp_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Taba tamagu eo sinagu se otaotaegu wa, GUIAU abo i abi’isinigu. ");
INSERT INTO swp_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Oa em dobila u heatagu, GUIAU e, abalau masamasarahana eai u woeaigu agu waiunuyao debadi eai. ");
INSERT INTO swp_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Tabu u buigabaegu agu waiunu edi henuhenua aridi eai, paana tauribaribataubiga tataodi se toro bena se hebaaeagu, isi hinage heamamna laulaudi eahuadi eai. ");
INSERT INTO swp_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Ea awamamohoiei GUIAU ena abilolo abo ea ita tatao maumauridi edi eanua eai. ");
INSERT INTO swp_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","GUIAU u laubagibagiei; u adidiri, eo u nuakipikipi, hedeomi, GUIAU u laubagibagiei. ");
INSERT INTO swp_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","GUIAU e, egu abahomo ede oa, taba nige se hetaumaeamaeagu, nige ariariri; em laulau dudurai debana eai bena u lebohaigu! ");
INSERT INTO swp_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","U ataatailaoma arigu eai, u heurama u saguhaigu! Oa bena egu ababawayamui we’una, egu abamia adiadidirina abo arinai ea mauri! ");
INSERT INTO swp_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Mamohoi oa egu we’utau eo egu abamia adidirina; esam debana eai bena u woeaigu eo u eda bagunaegu. ");
INSERT INTO swp_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Siposipo se abinonoha eamuyamui enagu, bena arinai u eairihaigu, paana egu abahomo ede oa. ");
INSERT INTO swp_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Earuagu ta ea leawa oa nimam eai, GUIAU e, Eaubada mamohoina, oa u unehaiguo. ");
INSERT INTO swp_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Aidimodi oitau borabora se nuanuatuidi oa u hewaiunuedi; na eau GUIAU mo ea sunumaei. ");
INSERT INTO swp_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Abo ea kode ariri eo nuagu i lolo oa em gadosisi miatahitahina debana eai, paana egu amamna u itayao, egu lauita oa u nuatuidio, ");
INSERT INTO swp_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","na nige u moselaegu waiunu nimana eai, aegu mo u hetorodi eanua magamagagana eai. ");
INSERT INTO swp_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","GUIAU e, bena u nuatoatoaegu, paana ea ai’iwala; matagu i beruberuo nuadubu debana eai, nuagu eo taugu hinage. ");
INSERT INTO swp_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Paana nuadubu egu mauri i abiheohi, eo egu borimai gamagaridi eai hinage ea aiai’iwala. Egu adidiri ie ohi nuadubu debana eai, siadagu hinage se meimei. ");
INSERT INTO swp_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Ea hemala agu waiunuyao edi abaalaliuliuwa, helegu‐tau‐mia‐tataodi edi abamatamatausi, egu dodogayao edi abatabutabubu; aidobudi dobila eai se itagu abo se dagogabaegu. ");
INSERT INTO swp_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Se nuahuiegu doha tau matematena, agu ao doha gulewa tamotamogoruna. ");
INSERT INTO swp_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Agueamoisa, monumonunu gamagaridi ea ataiedi— tupo gamagari eai matausi lailai!— Se oioiribagogo bena se hebaaeagu, se nuatueamuyamui bena se unuigu. ");
INSERT INTO swp_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Na, GUIAU e, egu sunuma ede oa arim eai, ea ene, “Oa egu Eaubada ede.” ");
INSERT INTO swp_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Egu mauri asubenadi gamagaridi ede oa nimam eai; agu waiunuyao, eo tauheamamnagu nimadi eai bena oa u saguhaigu! ");
INSERT INTO swp_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Bena am ao u hesina em heaheari tauna potana eai; em gadosisi miatahitahina arinai bena u abihemaurigu! ");
INSERT INTO swp_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Tabu se hetaumaemaeagu GUIAU e, paana ea eogasaewa arim eai. Isi mo tatao manamanabaradi bena se hetaumaeamaeadi, bena se hetagugudi, eo se laedi Hade eai. ");
INSERT INTO swp_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Sopa boraboradi bena se unauna, aidobu tatao laulaududurai se ribahebaaeadi, nuasaesae eo isuewa debana eai. ");
INSERT INTO swp_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Em abilolo i lai ariariri u nonohai isi taumatausiem enadi, eo isi eai to eai se ailogulogu oa arim eai tatao matadi eai! ");
INSERT INTO swp_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Oa nuanuam eai u hebawayamuidi tatao edi nuatu hebahebaaea aridi eai; logulogum eai u ganaganaidi arina baaea aridi eai. ");
INSERT INTO swp_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","GUIAU abo se ribahelolo, paana ena gadosisi otaotahaina i hemasaraha enagu huiana ne lauita lailai ea hearo gonogonoana doha eanua se ialai. ");
INSERT INTO swp_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Ma nuaberuberugu ea ene, “Oa matam eai se henauhesuaragu!” Na oa egu awanori u ataiei huiana ne ea eogalaowa bena u saguigu. ");
INSERT INTO swp_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","GUIAU au gadosisiei, omi tau miatahitahina! GUIAU tausunumaena i ganahetai’iridi na taunuasaesae ena maisa i heporohe aririei. ");
INSERT INTO swp_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Au adidiri, eo hinage au nuakipikipi, Omi gamagarimiu, GUIAU taulaubagibagiena! ");
INSERT INTO swp_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Tau wa ena awayagara se ribagigiri, ena baaea se bubulitawai, ia ie kode! ");
INSERT INTO swp_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Tau wa nige ana giru GUIAU matana eai, earuana eai nige abiborabora, ia ie kode hinage! ");
INSERT INTO swp_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Huiana ne egu baaea nige ea hemasaraha, taugu se porohe ariri, asubena maudoina ea lepalepa. ");
INSERT INTO swp_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Asubena to maiona nimam potagu eai i porohe ariri, egu adidiri ie ohi, doha siwaro lailai eai gigibori huiana eai. ");
INSERT INTO swp_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Oa arim eai egu beaea ea hemasaraha, eo egu ponori nige ea toreamui; ea ene, “Egu awayagara wa abo ea ribahemasaraha GUIAU arinai,” abotai egu baaea giruna u ribagigiri. ");
INSERT INTO swp_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Arinai isi nuadi se ota esegai taba gamagaridi se uura arim eai; huia baaea eai, abaita ena huia didi eai, isi taba nige se hearo. ");
INSERT INTO swp_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Oa egu ababawayamui ede, piripiri aridi eai u ganahetaiirigu, aridi eai u lebohaigu. ");
INSERT INTO swp_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Abo ea heatam, em dobila abo ea heitam arinai bena u lau; abo ea lauhasahasaim, matagu ede oa potam eai. ");
INSERT INTO swp_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Oa tabu em abi doha hosi e doha mule, isi nige edi sibasiba; arinai se paidi, eo awadi eai abawoeawoeaidi se heapudidinidi bena abo se awa’abiem. ");
INSERT INTO swp_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Tau laulau gewagewa ena nua’amamna se gamagari ariri, na gadosisi miatahitahina GUIAU tausunumaena abo i hetaiiri. ");
INSERT INTO swp_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Au kode GUIAU arinai, eo nuamiu se lolo, omi dudurai tataomiu e, au eoga lailai, omi nuamiu se dudurai e! ");
INSERT INTO swp_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Au kode ariri GUIAU arinai, omi taulaulau dudurai! Tau dudurai i lolo i aiaihelahui. ");
INSERT INTO swp_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Huelele arinai GUIAU au aihelahui, huelele mainadi saudoudoi aridi eai enana au oioini! ");
INSERT INTO swp_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Wana harihariuna enana au wanai, au oi‐huelele komakomani ma arina lailaimiu! ");
INSERT INTO swp_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Paana GUIAU ena riba i dudurai; eo ana paisoa maudoina ie abi ma nuapai’ipai’ina. ");
INSERT INTO swp_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","I’ila lolo eo laulau dudurai i gadosisiedi; GUIAU ena gadosisi miatahitahina tanoubu i hemonau. ");
INSERT INTO swp_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","GUIAU ena riba arinai galewa tehana se hetubu, eo ena ginauri gamagaridi ia awana eahuana arinai. ");
INSERT INTO swp_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Gabogabo goilana i pei’esegai tupo esega eai, gabogabo ena aba ota eai ie tore. ");
INSERT INTO swp_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Tanoubu maudoina bena GUIAU se matausiei, tanoubu taumiaina ia bena se tabutabubuei! ");
INSERT INTO swp_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Paana ia ie riba, to ia ede: i lauhesom, abo i taumasaraha. ");
INSERT INTO swp_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","GUIAU eanua gamagaridi taumaiaidi edi sonoga i itasubudi; tatao bodadi edi nuanuatu i guduguduidi. ");
INSERT INTO swp_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","GUIAU ena ribahesanapu i otaesegai i lau e nige nosina, ia ena nuatu se miatahitahi isi gamagaridi aridi eai. ");
INSERT INTO swp_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Eanua taumiaidi wa se kode ariri taba edi Eaubada ede GUIAU, tatao wa isi i hileidio iabom enanayao. ");
INSERT INTO swp_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","GUIAU galewa eai i itadobima, tanoubu tataodi gamagaridi i itadi. ");
INSERT INTO swp_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","Ena ababawa telona potana eai i italau tanoubu taumiaina gamagaridi aridi eai, ");
INSERT INTO swp_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","ia wa gamagaridi nuadi ia i hetubudi, eo edi laulau gamagaridi i itasipoidi. ");
INSERT INTO swp_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Wasawasa esau ena tauiala gamagaridi taba nige se hemauri; tauiala nuakipikipina iabom ena adidiri lailaina eai taba nige i mauri. ");
INSERT INTO swp_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Iala hosina taba nige i saepoi, eo ena adidiri lailaina eai taba nige i hemauri. ");
INSERT INTO swp_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Mamohoi GUIAU matana ie lau eai tau matausiena arinai, eo eai to eai ia ena gadosisi otaotahaina se sunumaei, ");
INSERT INTO swp_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","bena earuadi mate eai abo i saguhaidi, eo guriam huiana eai abo i abihemauridi. ");
INSERT INTO swp_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Earuada GUIAU se laubagibagiei, ia ada sagu eo eda opea ede. ");
INSERT INTO swp_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Mamohoi, nuada se kode ia arinai, paana ia esana tabuna ta sunusunumaei. ");
INSERT INTO swp_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","GUIAU e, em gadosisi miatahitahina bena i ota ai potamai eai, paana ai ema sunuma ede oa arim eai. ");
INSERT INTO swp_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Huia gamagari GUIAU ea ribatausaei; aihelahuina awagu eai taba nige i lautom. ");
INSERT INTO swp_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Nuagu ena abaribapasipasi ede GUIAU; taunuatudobidobiuio abo se ataiei, eo se kode. ");
INSERT INTO swp_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Omi maeguyao GUIAU ta ribahelai, eo esana ta hedebasae gogo! ");
INSERT INTO swp_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Eau GUIAU ea eo’oi to i ataiegu, egu matausi gamagaridi boeadi eai i earihaigu. ");
INSERT INTO swp_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Au italau ia arinai abo au nuawoiwoina; abo ami ao taba nige se taumaeamaea. ");
INSERT INTO swp_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Gogogesagesa tauna ta ie eoga, to GUIAU ia i ataiei, eo ena amamna gamagaridi aridi eai i hemauri. ");
INSERT INTO swp_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","GUIAU ena aneru ia tau matausina tataodi i miahetaiiridi eo baaea eai i saguhaidi. ");
INSERT INTO swp_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Omi hage au ai’ita, abo au italobai GUIAU i lolo ede! Tausunusunumaena abo nuana i kode! ");
INSERT INTO swp_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","GUIAU au heasisiei, omi hetabu tataomiu e, paana ia tauheasisiena taba nige ena deha. ");
INSERT INTO swp_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Liona nanatudiyao se dabu to se guriam, na isi GUIAU tau eo’oina tataodi taba nige ginauri esa lolona se abisapuri. ");
INSERT INTO swp_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Merumeru tatao e, au laoma au ataatai arigu eai, GUIAU heasisina eau abo ea heatamiu. ");
INSERT INTO swp_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Aitea tau mauri i henua eo i henua ena mauri asubenadi bena se gamagari, bena lolo amnana i ataiei? ");
INSERT INTO swp_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Oa memenam u abididini tabu u riba baaea, sopam hinage borabora ribadi tabu se ribaedi. ");
INSERT INTO swp_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Laulau gewagewa u tausuaraei, laulau lolo mo u laulauei; loni u eo’oi, eo u miawatai. ");
INSERT INTO swp_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","GUIAU matana se italau laulau dudurai tataodi aridi eai, eo beana se tasoe edi eoga aridi eai. ");
INSERT INTO swp_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","GUIAU ana ao i laeudoiei laulau gewagewa tataodi aridi eai, abahenuaisinidi tanoubu eai i tomgabaedio. ");
INSERT INTO swp_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Laulau dudurai tataodi ena se eoga GUIAU i ataiedi, edi piripiri gamagaridi eai ia i saguhaidi. ");
INSERT INTO swp_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Ena tatao se nuaberuberu GUIAU i hanahanauidi, isi nuadi se tamogorugoru ia i hemauridi. ");
INSERT INTO swp_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Laulau dudurai tauna piripiri gamagaridi i hearodi, na gamagaridi boeadi eai GUIAU i saguhai. ");
INSERT INTO swp_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Ia siadana gamagaridi GUIAU i itawataidi; taba nige esau i tagodu. ");
INSERT INTO swp_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Laulau gewagewa tauna baaea eai abo se unuheboso, eo isi laulau dudurai tataodi tauhewaiunuedi abo se ribahematedi. ");
INSERT INTO swp_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","GUIAU ena heaheari tataodi abo i unehaidi, isi wa taubawayamui ia arinai, taba nige esau se ribahemate. ");
INSERT INTO swp_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Tabu nuam eai u hemodeuioim laulau baaea tataodi debadi eai, laulau ponori tataodi hinage tabu u aiaromagigiriedi! ");
INSERT INTO swp_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Paana nige baeaona abo se wowoea doha lagau, eo se kokoeagi doha ginauri iniinidi. ");
INSERT INTO swp_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","GUIAU mo au sunumaei, laulau lolodi mo au laulauedi, arinai emi oea eai abo au mia, ma nuatarumiu. ");
INSERT INTO swp_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","U hekodeuioim GUIAU arinai, eo oa nuam ena henuhenua ia abo i leawa. ");
INSERT INTO swp_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Em dobila GUIAU nimana eai u tore; ia u sunumaei, abo hinage i paisoa. ");
INSERT INTO swp_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Em laulau dudurai abo i hemasaraha doha mara, eo am ao duduraina doha asuasubenalai. ");
INSERT INTO swp_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","U heaiyawasiuioim GUIAU matana eai, eo u bagibagi ma nuapai’ipai’im; tabu nuam i mode paana esau ena dobila i lau lolo, ia laulau baaea wa i hetuhetubudi. ");
INSERT INTO swp_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Ouyalaya u helautom, eo nuaheura i otawa! Tabu hinage u nuamodemode, ata u hebaaea’uioim. ");
INSERT INTO swp_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Mata paana laulau baaea tataodi abo se tomgabaedi; na isi GUIAU ena nuatu se bagiwatai tanoubu abo se abi isi enadi. ");
INSERT INTO swp_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Huia ku’uku’u mo eo laulau gewagewa tauna abo i tauyamui, taba ena eanua eai se eo’oeo’oi, ia nei eai nige’e. ");
INSERT INTO swp_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Na manabiga tataodi tanoubu abo se abi isi enadi, ainauia lailai hinage abo se hearo eo arinai abo se kode. ");
INSERT INTO swp_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Tau laulau gewagewa i nuatu nonohai bena tau laulau dudurai i heamamna, eo hinage ia arinai moana i taburueahisi; ");
INSERT INTO swp_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","na Guiau tau baaea i marumaruhiei, paana ie ita ena huia i laolaoma. ");
INSERT INTO swp_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Tau laulau gewagewa elepa i niusihai, pidu hinage ie tu, bena gogogesagesa tauna i laudobei eo laulau dudurai tataodi bena i unuidi; ");
INSERT INTO swp_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","edi elepa abo i soralau isi isibom nuadi eai, edi pidu abo se hetagodudi. ");
INSERT INTO swp_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Tau dudurai ena gogo begana mo, i lolo ariri abotai laulau gewagewa tataodi edi gogo lailai didigadi. ");
INSERT INTO swp_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Paana tau gewagewa nimana abo se godudi, na GUIAU taududurai abo i abiisini. ");
INSERT INTO swp_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Tatao nige abahegirudi GUIAU edi huia abina i atao, edi gogo hinage abo se ota i lau e nige nosina. ");
INSERT INTO swp_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Huia piripiri eai taba nige se hetaumaeamaeadi, guriam asubenana eai hinage adi aiai abo i lai ariri. ");
INSERT INTO swp_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Na tatao baabaaeadi abo se tomgabaedi GUIAU ana waiunuyao isi doha oea liasina, se tauyamui— doha asuasu se tautauyamui ariri. ");
INSERT INTO swp_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Tau laulau gewagewa ginauri i sagesagenai, na taba nige i hemaisauioi, na tau laulau dudurai ena abi se lolo, to i aiainauia; ");
INSERT INTO swp_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","isi GUIAU i nualoloedi abo oea se abi enadi, na isi i ribahematedi abo se tomgabaedi. ");
INSERT INTO swp_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Tau lolo ena abalau GUIAU i nuatu nonohai, eo tau wa i nualolo arinai, abo i hetoro komakomani; ");
INSERT INTO swp_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","taba ie beu, taba nige i lau ariri, paana GUIAU i abilau nimana eai. ");
INSERT INTO swp_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Egu huia hewari eai i laoma e egu huia tautaubada, sora nige taududurai ea ita se nuagabaei, e nanatunayao falawa se aiaiboda. ");
INSERT INTO swp_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Ia huia gamagari i aiainauiasom, eo ia arinai se sagesagena. eo nanatunayao hinage tatao se henualoloedi. ");
INSERT INTO swp_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Baaea u torohaigabaei, lolo mo u abiwatai, arinai abo u miatahitahi i lau e nige nosina. ");
INSERT INTO swp_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Paana GUIAU abi dudurai mo i gadosisisiei; ena tau miatahitahi tataodi taba nige i nuagabaedi. Tau dudurai abo se ganaganai i lau e nige nosina, na tau gewagewa nanatunayao abo se tomgabaedi. ");
INSERT INTO swp_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Tau dudurai abo oea i abi enana, eo abo arinai i mia i lau e nige nosina. ");
INSERT INTO swp_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Tau dudurai awana eai riba sonoga i hepesadi, memenana abi dudurai i ribaribaedi. ");
INSERT INTO swp_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Ena GUIAU ena laugagaeo ia nuana eai; ena abalau eai taba nige i utusagigi. ");
INSERT INTO swp_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Tau gewagewa tau dudurai i itasipoi, eo i aipate bena i unui. ");
INSERT INTO swp_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","GUIAU taba nige i abigabaei ia nimana gigiborina eai, eo abahedudurai eai taba nige se hegiru. ");
INSERT INTO swp_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","GUIAU u bagibagiei, eo ena dobila u abididini, ia hinage abo i abiisinim, eanua abo oa enam; tau laulau gewagewa tauna abo u ita se tomgabaei. ");
INSERT INTO swp_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Tau laulau gewagewa ea ita i gigibori ariri, i sae ariri doha Lebanona maruwaina esau. ");
INSERT INTO swp_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Huia esau ea baeawa ea lau, na hedeomi, ia nei eai nige’e, ea eo’oi komakomani, na taba nige ea lobai. ");
INSERT INTO swp_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Tau nige abahegiruna u italau arinai, eo tau dudurai u ita, manabiga tauna abo ana isimurita. ");
INSERT INTO swp_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Na tau awayagara abo se unuidi, adi isi murita abo se tomgabaedi. ");
INSERT INTO swp_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Tatao duduraidi edi mauri abo se abi GUIAU arinai, huia baea eai edi abahomo ede ia arinai. ");
INSERT INTO swp_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","GUIAU i saguidi eo i lebohaidi, laulau gewagewa tataodi nimadi eai i lebohaidi eo i hemauridi, paana edi abaailogulogu ede ia arinai. ");
INSERT INTO swp_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Doha suisui nuura goila dididi i gadohiedi, eau hinage, Eaubada e, earuagu i gadohiem. ");
INSERT INTO swp_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Earuagu i gadomagu Eaubada arinai, Eaubada maumaurina arinai. Aitea huia abo ea laoma Eaubada ana ao abo ea ita? ");
INSERT INTO swp_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Agu aiai esega ede matasulugu asubena to maiona, eo tatao huia gamagari se hesiolaoma, “Em Eaubada ia haedi‐eai?” ");
INSERT INTO swp_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Ina ginauri ta ea henuaisini huiana wa nuagu ea soeauri; tatao bodadi maeguyao ea woeaidi, se hemuriwataigu Eaubada ena numa eai, aie wowo ma kodemai, eo aie wana ma lautoimai, moutuana lailai ai mataasi gogo. ");
INSERT INTO swp_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Earuagu e, paana saha u nuadobidobi, eo paana saha nuaboeagu eai u heunaboisaha? Eaubada u sunumaei; paana ia abo ea hedebasaeuioi, ia agu sagu ede ");
INSERT INTO swp_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","eo egu Eaubada. Earuagu i porohe ariri nuaboeagu eai arinai abo oa ea nuanuatuim, Ioridana eo Heremona eanuadi eai, Misara oea tupina eai hinage. ");
INSERT INTO swp_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Gabotum i eogalau gabotum esau arinai, em goila edi abadidi lailaidi dagugudi eai; em bagodu eo em butubutu gamagaridi se heputuhaigu. ");
INSERT INTO swp_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Asubena huiana eai GUIAU ena gadosisi miatahitahina i leama; eo maiona eai enana ea wawana, ea lauuura egu mauri Eaubadana arinai. ");
INSERT INTO swp_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Ea ribalau Eaubada arinai ia egu we’utau, “Paana saha u nuahuiegu ta? Paana saha ea nuanuadubu, waiunu ena hebahebaaea debana eai?” ");
INSERT INTO swp_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Agu waiunuyao edi hesom i hemala doha bonu lailai taugu eai, huia gamagamagari se ribalaoma si ene, “Em Eaubada haedi?” ");
INSERT INTO swp_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Earuagu e, paana saha u nuadobidobi, eo paana saha nuaboeagu eai u heunaboisaha? Eaubada u sunumaei; paana ia abo ea hedebasaeuioi, ia agu sagu ede, eo egu Eaubada. ");
INSERT INTO swp_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Egu laulau dudurai u hemasaraha, Eaubada e, eo enagu u toro ganamuri tataodi matadi eai; ao borabora eo laulau gewagewa tataodi nimadi eai u lebohaigu! ");
INSERT INTO swp_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Paana oa Eaubada egu aba ailogulogu ede; paana saha u gabahesuaragu? Paana saha ea nuadubu waiunu ena hebahebaaea debana eai? ");
INSERT INTO swp_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Em mara eo em riba mamohoina bena u hetamaridima bena abo se woeaigu, abo se woeaigu em oea tupi tabuna eo em abamia arinai! ");
INSERT INTO swp_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Murina eai abo ea lau Eaubada ena aitalasam hatahatana arinai, Eaubada egu abanuawoiwoina; eo abo ea aihelahuim huelele arinai, Eaubada e, egu Eaubada. ");
INSERT INTO swp_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Earuagu e, paana saha u nuadobidobi paana saha nuaboeagu eai u heunaboisaha? Eaubada u sunumaei, paana ia abo ea hedebasaeuioi, ia agu sagu ede eo egu Eaubada. ");
INSERT INTO swp_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Eaubada ia eda aba homo eo eda adidiri ede, tausaguheulaida baaea huiadi eai. ");
INSERT INTO swp_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Arinai taba nige ta matausi taba tanoubu ana ao ie bui, taba oea tupidi gabogabo nuanuana eai se tabutabubu, ");
INSERT INTO swp_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","taba butubutu dagugudi se lai ma puropurodi, eo taba oea tupidi se tabutabubu dagugu lailaina wa debana eai. ");
INSERT INTO swp_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Goila esau i dididi abo Eaubada ena eanua i hekode, Saesae Aririna ena aba mia tabuna meta. ");
INSERT INTO swp_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Eaubada ia duaduarina eai, ia taba nige se hemoiu, Eaubada ia abo i saguheulai. ");
INSERT INTO swp_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Etene se sagasagari, eanua udoi udoi se eoeo; arinana ie tore, na tanoubu ie welo. ");
INSERT INTO swp_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Tauiala moutuana GUIAUNA ia maeda, Iakobo ena Eaubada ita eda aba homo! ");
INSERT INTO swp_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Au laoma GUIAU ena paipaisoa au itadi, iabom i ginauridi tanoubu eai: ");
INSERT INTO swp_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Iala i helautomdi i lau e tanoubu sigana; welolo gigidi i hetagodudi, eo alahia i godudi, kariota oeagi eai i gabudi! ");
INSERT INTO swp_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","“Au monou, eo abina au ata eau mo Eaubada, Eau mo se lauisinigu eanua tataodi boeadi eai, Eau mo se lauisinigu tanoubu eai!” ");
INSERT INTO swp_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Tauiala moutuana GUIAUNA ia maeda, Iakobo ena Eaubada ita eda abahomo ede! ");
INSERT INTO swp_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Eaubada GUIAU, Gigiborina, i ribariba, eo tanoubu i eogalau arinai, mahana ena huia dalasae, i lau e ena huia dui. ");
INSERT INTO swp_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Siona, ana ao lolo dumadumana eai, Eaubada ena mara i hesinalaei. ");
INSERT INTO swp_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Eda Eaubada i laolaoma, taba nige i monou, ia matana eai doha oeagi i alabalebalelem, mana lailai didigana ia i lauhetaiiri. ");
INSERT INTO swp_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","I eogasae galewa ewana eai eo tanoubu eai hinage, bena ena tataoyao abo i heduduraidi. ");
INSERT INTO swp_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","“Tausunusunumaegu au heoigogoidima, isi aitalasam arinai edi aigora arigu eai se ginauri wa!” ");
INSERT INTO swp_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Galewa ia ena laulau dudurai se hemasaraha paana Eaubada iabom tauheduhedudurai ede! ");
INSERT INTO swp_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","“Egu tataoyao e, au ataatai abo ea ribariba, Isaraela e, emi baaea abo ea ribahemasaraha! Eau Eaubada ede, emi Eaubada. ");
INSERT INTO swp_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Emi aitalasam debadi eai taba nige ea hegirumiu; emi aitalasam gabugabudi matagu eai huia gamagamagari. ");
INSERT INTO swp_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Bulumakau tamoana emi numa eai taba nige ea nuatui, goti tamoana emi gana eai hinage nige’e. ");
INSERT INTO swp_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Paana nuura suisuidi gamagaridi eau enaguyao ede, bulumakau hinage oea tupidi tausani potadi eai. ");
INSERT INTO swp_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Galewa manudi gamagaridi hinage abidi ea ata’o, eo ginauri maumauridi gamagamagaridi oea eai isi eau enaguyao ede. ");
INSERT INTO swp_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","“Ena ea guriam, taba nige ea heribamiu; paana tanoubu maena ginauri gamagaridi eau enaguyao ede. ");
INSERT INTO swp_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Bulumakau bulumana eau ea aiaini, e nige’e? Goti osinana hinage ea nomnomi, e nige’e? ");
INSERT INTO swp_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Lautoi aitalasamna au heaitalasam Eaubada arinai, eo emi aigora au hemamohoiedi Saesae‐Aririna arinai; ");
INSERT INTO swp_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","huia baaea eai abo au eogalaoma eau hinage abo ea lebohaimiu, eo omi abo au hedebasaegu.” ");
INSERT INTO swp_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Na laulau gewagewa tataodi aridi eai Eaubada i ribalau, i ene: “Ami paisoa saha na egu lauhesom au hasihasiridi, eo egu ribahesunuma au abi sopamiu eai? ");
INSERT INTO swp_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Paana heduhedudurai au hewaiunuei, eo egu riba au gabaedi dagelamiu eai. ");
INSERT INTO swp_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Taba tauaiyahari au ita, au awaehalau arinai, tauganaganawari hinage maemiuyao au heboriesegaimiu. ");
INSERT INTO swp_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","“Awam u moselaei riba gewagewa arinai, memenam eai hinage u riba borabora. ");
INSERT INTO swp_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Ue bawa na em tau u ribahebaaea, sinam tahunuana natuna tau u ribahebaaea. ");
INSERT INTO swp_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Ina laulau ta u laulauedi, na eau ea monou; u ene bena eau gonogonoana doha oa. Abotai ea ribasuuim, eo giru wa ea tore oa matam eai. ");
INSERT INTO swp_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","“Ina ta au nuanuatui, omi aidobu Eaubada au nuahuiei, ata ea purisimiu, na nige esau bena i toro i saguhaimiu! ");
INSERT INTO swp_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Eai to eai lautoi i leama, ia ena heasisi enagu i hemasaraha; eai to eai ena dobila i hedudurai ia arinai Eaubada ena abihemauri abo ea hemasaraha.” ");
INSERT INTO swp_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Eaubada e, u nuatoatoaegu em gadosisi miatahitahina debana eai, em nuatoatoa lailai didigana debana eai egu awayagara bena u saugabaedi. ");
INSERT INTO swp_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Girugu bena u deurigabaei eo egu baaea arinai oa bena u hea’agu! ");
INSERT INTO swp_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Paana egu awayagara abidi ea ata’o, eo egu baaea hinage huia gamagari eau matagu eai i totoro. ");
INSERT INTO swp_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Oa, oabom, ea hebaaeam, saha i baaea oa matam eai, meta ea ginauriyao, arinai em riba se dudurai ariri, eo em hesanapu ribana nige abahegiruna. ");
INSERT INTO swp_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Mamohoi baaea boeana eai se labasigu, eo baaea eai hinage sinagu i abigu. ");
INSERT INTO swp_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Hedeomi, oa u henua bena ao mamohoi eau nuagu eai; arinai nuagu eamuyamuina eai bena sonoga oa u heatagu. ");
INSERT INTO swp_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Hyssop arinai u hea’agu, eau hinage abo arinai ea a’a; oa u deurigu, abo ea posiposi ariri abotai snow. ");
INSERT INTO swp_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Kode eo nualolo arinai oa u hemonaugu; siada wa oa u hetagodudi abo se kodelamposi. ");
INSERT INTO swp_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Egu baaea bena u hetauyamuidi oa matam eai, agu giru gamagarina bena u saugabaei. ");
INSERT INTO swp_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Eaubada e, nua a’a oa u hetubu eau nuagu eai, earua harihariuna eo duduraina u tore nuaboeagu eai. ");
INSERT INTO swp_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Oa matam eai tabu u gabahesuaragu eo em Earua Tabuna tabu u abihai arigu eai. ");
INSERT INTO swp_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Em abihemauri kodena bena oa u leamauioi, eo earua awaabina bena i bouisinigu. ");
INSERT INTO swp_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Abotai tauawayagara em laulau abo ea heatadi, eo tatao baabaaeadi abo se sinibui oa arim eai. ");
INSERT INTO swp_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Eaubada e, osina giruna arinai bena oa u saguhaigu, oa Eaubada egu mauri paana, eo memenagu oa em abihemauri abo i wana helai. ");
INSERT INTO swp_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Guiau e, sopagu oa u dabaridi, eo awagu aihelahuim abo i hemasaraha. ");
INSERT INTO swp_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Paana aitalasam taba nige oa i hekodem; ena aitalasam gabugabuna ea leawa, taba nige nuam i lolo. ");
INSERT INTO swp_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Aitalasam esega wa Eaubada i henua aririei iaede nua tamotamogoruna, nua tamotamogoruna, dobidobina, Eaubada e, taba nige u isuewaei. ");
INSERT INTO swp_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Em nualolo debana eai Siona bena oa u helolo; Ierusalema ganana abo u hetorouioidi, ");
INSERT INTO swp_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","abotai aitalasam duduraidi debadi eai abo u nuawoiwoina, aitalasam gabugabudi eo aitalasam gabugabudi maudoidi; bulumakau abo se heaitalasamdi em aitalasam hatahatana eai. ");
INSERT INTO swp_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Eaubada e, u nuatoatoaegu, u nuatoatoaegu ta, paana oa arim eai earuagu abo i ailogulogu; mabem logulogudi eai abo ea ailogulogu, i lau e sabom i lau’o. ");
INSERT INTO swp_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Ea eogalau Eaubada Saesae Aririna arinai, Eaubada arinai ia wa ena nuatu enagu i hemamohoiei. ");
INSERT INTO swp_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Galewa eai abasaguigu ia abo i hetamariama eo abo i hemaurigu, aidobu bena se ututawaigu abo i hetaumaeamaeadi. Eaubada ena gadosisi miatahitahina, eo ena riba hemamohoiena abo i hetamarilaei! ");
INSERT INTO swp_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Liona boeadi eai ea laulauota, isi se lelehi ariri bena tatao se aidi, moadi ede alahia eo pidu, memenadi alahia matamatadi ede. ");
INSERT INTO swp_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Eaubada e, oa abo u sae ariariri galewa ewana eai! Em namanamari tanoubu bena i hemonau! ");
INSERT INTO swp_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Hiana se gala nonohai aegu adi, ea nuaporohe ariri. Duha se sara eau egu dobila eai na isi, isibom se beudobi alona eai. ");
INSERT INTO swp_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Eaubada e, nuagu i otaesegai, nuagu i ota esegai. Abo ea wana eo salamo aridi eai abo ea hedebasaei! ");
INSERT INTO swp_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Earuagu, u enotoro! Baubau eo huelele, au enotoro! Mara i uiari abo ea hanoi! ");
INSERT INTO swp_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Guiau e, abo ea lautoiem, etene boeadi eai: aihelahuim abo ea wanaidi hari eanua tataodi boeadi eai. ");
INSERT INTO swp_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Paana em gadosisi miatahitahina ie sae doha galewa, am ao otaotahaina ie sae doha eada. ");
INSERT INTO swp_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Eaubada e, oa abo u sae ariariri galewa ewana eai! Em namanamari tanoubu bena i hemonau! ");
INSERT INTO swp_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Eaubada iabom earuagu i laubagibagiei ma monomonougu; ia arinai egu mauri i laolaoma. ");
INSERT INTO swp_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Ia iabom egu we’utau eo egu abamauri ede, egu numa adiadidirina; taba nige se hemoiugu, nige ariariri. ");
INSERT INTO swp_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","I lau e aitea huia abo tau au aipatei au oiheguri, omi gamagarimiu e, bena ia doha bilibili eoueouna, e gana beruberuna? ");
INSERT INTO swp_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Edi nuatu esega mo ede bena ena abatoro eai se oiheguri. Ao borabora se henua aririei. Awadi eai se ribalolo, na nuaboeadi eai se riba‐hemate. ");
INSERT INTO swp_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Eaubada iabom earuagu i laubagibagiei ma monomonougu; egu sunuma ede ia arinai. ");
INSERT INTO swp_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Ia iabom egu we’utau eo egu abamauri ede, egu numa adiadidirina; taba nige nuagu se heberuberu. ");
INSERT INTO swp_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Egu abamauri eo egu abadudurai ede Eaubada iabom arinai, ia egu we’utau adiadidirina eo egu abahomo ede. ");
INSERT INTO swp_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Egu dodogayao e, huia gamagamagari ia bena au sunumaei, nuamiu au hegoigabaedi ia matana eai. Eaubada ia eda aba ailogulogu ede. ");
INSERT INTO swp_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Tatao dobidobidi isi doha eahua mo, tatao saesaedi isi doha ginauri borabora; taba se nonoidi se mamara, mamohoi se mamara ariri abotai eahua. ");
INSERT INTO swp_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Tabu baaea maisana u nuatui, eo tabu em sunuma u torelaei aiyahari arinai; taba em gogo i helai, tabu nuam i lauei. ");
INSERT INTO swp_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Ma’esega Eaubada ie riba, malabui ina ta ea ataiei: iaede ina, gigibori Eaubada iabom enana, ");
INSERT INTO swp_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","gadosisi miatahitahina ede oabom arim eai, Guiau e, eo tau ena paipaisoa arinai abo oa u hemaisa. ");
INSERT INTO swp_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Eaubada e, oa egu Eaubada ede, eau ea eo’o’eo’oim, earuagu i gadomaguem; taugu maudoina i gadohiem, gonogonoana doha oea esau nige goilana, i pitari ariri eo i amnabaaea. ");
INSERT INTO swp_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Doha em abamia tabuna eai ea itamo, em gigibori eo em namanamari ea itadio. ");
INSERT INTO swp_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Paana oa em gadosisi miatahitahina i sae ariri abotai mauri, eau sopagu eai abo ea hedebasaem. ");
INSERT INTO swp_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Egu mauri asubenana lohana eai abo ea ribatausaei, eau nimagu abo ea lauisinidi, eo oa esam eai abo ea aiaiboda. ");
INSERT INTO swp_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Earuagu i mata’asi, gonogonoana doha siada aroarodi eo momona ea aiaini, eo awagu i hedebasaem ma kodegu, sopagu eai, ");
INSERT INTO swp_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","huiana eai wa egu abaeno eai ea nuanuatuim, maiona silasilawana eai ea nuanuatuim, ");
INSERT INTO swp_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","paana oa agu sagu ede, eo oa mabem loguloguna eai abo ea wana ma nuawoiwoinagu. ");
INSERT INTO swp_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Earuagu i patudidini arim eai, oa nima tutum i abiisinigu. ");
INSERT INTO swp_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Na aidobu se aipate egu mauri se hebaaea abo se dobi tano boeana eai; ");
INSERT INTO swp_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","abo se moselaedi elepa gigiborina eai, abo se hemala suisui nuura adi aiai. ");
INSERT INTO swp_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","na wasawasa abo Eaubada arinai i nuawoiwoina, isi gamagaridi ia debana eai se riba aigora, abo se kode lamposi; na tatao borabora awadi abo se gududi. ");
INSERT INTO swp_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Eaubada e, i lolo oa se hedebasaem Siona eai, oa arim eai hinage abo riba aigora se hemamohoiedi, ");
INSERT INTO swp_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","Oa uura tau ataiena! Oa arim eai tatao gamagaridi abo se laoma, ");
INSERT INTO swp_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","baaea giruna debana eai. Ena ema awayagara se saetawatawaimai, oa u ribagigiridi. ");
INSERT INTO swp_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Aisega tau oa u abihineri, u woeaieama em numa tabuna gegesina eai, ia i kode ariri! Em abamia ena lolo i hegonoahimai, oa em dubu tabuna! ");
INSERT INTO swp_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Laulau matamatausidi aridi eai oa u lebohaimai ema abamauri Eaubadana e, tanoubu sigasigadi gamagaridi edi abasunuma ede oa arim eai, gabogabo sigasigadi hinage. ");
INSERT INTO swp_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Oa em adidiri eai oea tupidi u hetubudi, oa gigibori ue lui; ");
INSERT INTO swp_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","gabogabo ena dagugu u hemonou, butubutu dagudaguguna; tatao hinage edi hetalagegagega; ");
INSERT INTO swp_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","arinai isi tanoubu sigasigadi eai se mia em heiheinoi ta se matausiedi; mahana ena aba dalasae eanuadi eo mahana ena aba dui eanuadi se wowo ma kodedi. ");
INSERT INTO swp_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Tanoubu u nuatui eo nabu u hetaru, eo u hemasuri aririei; Eaubada ena saga goila eai i monau, edi tuma u mosedi, paana oa u abinonohayao wa: ");
INSERT INTO swp_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Oea se giari nonohaidi adi goila u mosedi, padipadi u hesabusabu, nabu arinai tano u hebiga, eo ginauri ini’inidi u helolodi. ");
INSERT INTO swp_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Borimai huiana eai oea u hemasuri lolo aririei, em abalau gamagaridi eai masuri i lai ariri. ");
INSERT INTO swp_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Barabara eai hinage nabu ie taru, oea tupidi se kode lamposi. ");
INSERT INTO swp_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Oea abaaibai hinage mamoe eawoidi se hemonau, gonu hinage tuma arinai se hepasauioidi, se wowo eo se wanagogo kode debana eai! ");
INSERT INTO swp_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Eaubada taba i ainauiaida eo i heloloda eo matana marana i hesina potada eai — ");
INSERT INTO swp_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","oa em dobila tanoubu eai ta bena se ata, eo em abihemauri gigiborina eanua gamagaridi taumiaidi boeadi eai. ");
INSERT INTO swp_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Eaubada e, tanoubu tataodi taba oa se hedebasaem, tanoubu tataodi gamagaridi taba se hedebasaem! ");
INSERT INTO swp_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Eanua udoi udoi taumiaidi taba se kode, se wana ma kodedi, paana tanoubu tataodi duduraina eai oa u heduduraidi, tanoubu eanuadi udoi udoi taumiaidi oa abo u woeaidi. ");
INSERT INTO swp_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Eaubada e, tanoubu tataodi taba oa se hedebasaem, tanoubu tataodi gamagaridi taba se hedebasaem! ");
INSERT INTO swp_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Tano aiaina i tubuo; Eaubada, ita eda Eaubada, i helolodao. ");
INSERT INTO swp_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Eaubada i helolodao; tanoubu sigana gamagamagaridi ia abo se heasisiei! ");
INSERT INTO swp_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","GUIAU e, abo ea ailogulogu oa arim eai; taba nige se hetaumaeamaeagu, nige ariariri! ");
INSERT INTO swp_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Em laulau dudurai debana eai bena u saguhaigu eo u hemaurigu; beam eai u ataiegu, eo u hemaurigu! ");
INSERT INTO swp_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Oa bena egu we’utau aba ailoguloguna, egu numa adiadidirina, egu aba mauri, paana oa egu we’utau ede, eo egu aba mia adiadidirina. ");
INSERT INTO swp_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Egu Eaubada e, u lebohaigu tau baaea nimana eai, tau laulau gewagewa, eo tau manamanabara nimadi eai. ");
INSERT INTO swp_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Paana ede oa, Guiau e, oa egu sunuma ede, egu aba awamamohoi, ma hewarigu i laoma e wauta. ");
INSERT INTO swp_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Ea duihasari oa arim eai egu huia labasi eai i laoma e ina wauta, sinagu bogana eai oa u abihaigu. Egu hedebasae ede oa enam huia gamagamagari. ");
INSERT INTO swp_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Ea hemala tatao edi aba no’o; na oa egu aba homo adiadidirina ede. ");
INSERT INTO swp_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Aihelahuim awagu i hemonau huia gamagari, eo em namanamari hinage asubena lohaloha. ");
INSERT INTO swp_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Egu huia tautaubada eai tabu u abigabaegu, ena egu adidiri i dobidobi tabu u nuagabaegu. ");
INSERT INTO swp_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Paana agu waiunu se ribaribaegu, isi se itasipoigu, se oiribagogo, ");
INSERT INTO swp_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","si ene, “Eaubada tau ta i lausuaraei, ta henauwatai ta toai, paana nige doga esau bena i saguhai.” ");
INSERT INTO swp_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","Eaubada e, tabu u lausuara aririegu; egu Eaubada e, u heurama u saguigu! ");
INSERT INTO swp_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Isi tau hegirugu bena se hetaumaeamaeadi eo se hetauyamuidi; isuewa eo taumaeamaea bena i buburidi, isi se aipate se hebaaeagu wa. ");
INSERT INTO swp_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Na eau egu sunuma abo i otahai huia gamagamagari, oa hinage abo ea hedebasae aririem. ");
INSERT INTO swp_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Awagu eai em abidudurai abo ea ribaribaei, em abihemauri laulaudi asubena gamagamagari, paana se gamagari ariri, nige gonoana ea hasiridi. ");
INSERT INTO swp_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Guiau EAUBADA ena paipaisoa gigigigiboridi abo ea wasawasaedi; oa oabom em laulau dudurai abo ea hedebasaei. ");
INSERT INTO swp_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Eaubada e, egu hewari huiana eai oa u heaheatagu, i laoma e wauta em laulau gigigigiboridi ea wasaduaiedi. ");
INSERT INTO swp_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Arinai egu huia tautaubada eo egu huia uruhou eai, Eaubada e, tabu u abigabaegu, i lau e em adidiri ea wasaduaiei isimurita gamagari aridi eai. Em gigibori ");
INSERT INTO swp_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","eo em laulau dudurai, Eaubada e, se sae e galewa ewana eai. Oa em paipaisoa se lai ariri, Eaubada e, eai doha oa? ");
INSERT INTO swp_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Egu lauita lailaidi u hegamagari aririedi, na oa abo u hemauriuioigu; tano boeana eai abo u abiisiniuioigu. ");
INSERT INTO swp_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Heasisi enagu abo u helaiama, eo nuagu abo u hebigauioi. ");
INSERT INTO swp_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Baubau arinai abo ea hedebasaem em laulau lolodi debadi eai, egu Eaubada e; baubau eai abo ea aihelahuim ma wanagu, Isaraela edi Tabuna e. ");
INSERT INTO swp_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Ma kodegu abo sopagu se wowo, oa aihelahuim abo ea wanaidi; earuagu hinage, ia ede oa u unehai wa. ");
INSERT INTO swp_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Em haisagusagu duduraina memenagu abo i ribaribaei asubena lohaloha, paana ede isi se eo’oigu bena se heamamnagu wa, isi se hetaumaeamaeadi eo se isugaraedi. ");
INSERT INTO swp_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Mamohoi Eaubada ena abi se lolo tatao laulau dudurai aridi eai, tau nua’aa’aa aridi eai hinage. ");
INSERT INTO swp_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Na eau mo begana abo aegu se alabesibesi, aegu hanahanau abo se utusagigi. ");
INSERT INTO swp_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","Paana ede tau nuasaesae ea aiaromagigiriedi, huiana wa tau laulau gewagewa ena gogo ea i’ita. ");
INSERT INTO swp_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Paana isi nige begana amamna se hearo; se amna lolo mo eo se tubu lolo. ");
INSERT INTO swp_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Isi nige se ai’iwala doha tatao headi; pidipidiri nige se hearo doha tatao headi. ");
INSERT INTO swp_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Arinai nuasaesae i hemala adi gadogado; manamanabara i buburidi doha lulu. ");
INSERT INTO swp_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Se tubu lolo ariri arinai matadi se pou, nuatu eauyaule nuadi se hemonau boriboriridi. ");
INSERT INTO swp_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Se riba alaliuliuwa, eo se ribakarapi; tatao se riba hematausidi ma nuasaesaedi. ");
INSERT INTO swp_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Awadi eai galewa se hewaiunuei, eo se ribahetausaeuioidi tanoubu boeana eai. ");
INSERT INTO swp_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Arinai tatao se sinibui eo se ribatausaedi; edi ponori hinage nige se italobaidi. ");
INSERT INTO swp_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Eo si ene, “Mamohoi, Eaubada i nuatui? Saesae Aririna abina ie ata, e nige’e?” ");
INSERT INTO swp_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Mamohoi, tatao baabaaeadi ede ina; huia gamagari taba nige saha se deha, edi gogo mo se helahelai. ");
INSERT INTO swp_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Nuagu ea hea’a gaibui, eo nimagu ea deuridi gaibui laulau dudurai boeana eai: ");
INSERT INTO swp_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Paana asubena lohaloha eai pidipidiri mo ea hearodi, eo maratomtom gamagari maisa mo ea abidi. ");
INSERT INTO swp_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Taba ea ene, “Doha ina abo ea riba”, am isimurita abo ea woeaponoridi. ");
INSERT INTO swp_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Na ena ea aipate ina ginauri ta ea nuatulobai, i heamnabaaea aririegu, ");
INSERT INTO swp_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","i lau e ea awasaei Eaubada ena aba mia tabuna eai; abotai adi sigana ea italobai. ");
INSERT INTO swp_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Mamohoi tupo sagisagigi eai oa u hetorodi; abo u heguridi mate arinai. ");
INSERT INTO swp_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Maesega se hebaaea heohidi, matausi lailai arinai se ueagabaedi! ");
INSERT INTO swp_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Guiau e, isi doha enosuai mo, ena u enotoro, enosuai wa u isuewaei, ana ao doha tautau gaibu mo. ");
INSERT INTO swp_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Huiana eai wa ea nuakarapi, eo nuagu i amamna, ");
INSERT INTO swp_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","ea eauyaule eo ea supusupu, agu ao doha suisui manamanabarana oa matam eai. ");
INSERT INTO swp_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Taiede huia gamagari eau gegesim eai; nimatutugu u abididini. ");
INSERT INTO swp_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Em nuatu sibasibana arinai u woeaigu, eo maraitom asubena abo u heawasaegu em namanamari eai. ");
INSERT INTO swp_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Eai abo enagu galewa eai na oabom mo? Tanoubu eai hinage nige saha ea henua na oabom mo. ");
INSERT INTO swp_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Bulumagu eo nuagu se beruberu, na Eaubada nuagu ena aba adidiri eo egu gogo ede i lau e nige nosina. ");
INSERT INTO swp_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Hedeomi, tatao ena se miasuaraem abo se mate, tatao wa se boraboraim abo se mate. ");
INSERT INTO swp_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Na eau ea amna lolo ena ea hanahanau Eaubada gegesina eai; Guiau EAUBADA ea abiyao egu aba ailogulogu, abo em paipaisoa gamagaridi ea wasaduaiedi. ");
INSERT INTO swp_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","Isaraela taumiataunina e, u ataatai, oa Iosepa u woeai doha mamoe eawoina! Oa ue bawa serubim potadi eai, maram u hesinalaei ");
INSERT INTO swp_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Eparanaime, Beniamina eo Manase eai! Em gigibori u healabalebalelem eo u laoma u hemaurimai! ");
INSERT INTO swp_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Eaubada e, u hetorouioimai; matam u hesina potamai eai arinai abo ai mauri! ");
INSERT INTO swp_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","Tauiala moutuana edi GUIAU Eaubadana e, i lau e aitea huia abo u ouyalayala em tataoyao edi uura aridi eai? ");
INSERT INTO swp_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Matasulu mo u mosei adi aiai, matasulu hinage u henom aririedi. ");
INSERT INTO swp_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","U hetoromai helemai taumia edi aba alaliuliuwa; ema waiunu hinage isibom se marumaruhiemai. ");
INSERT INTO swp_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Tauiala moutuana Eaubadana e, u hetorouioimai; matam u hesina potamai eai arinai abo ai mauri! ");
INSERT INTO swp_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Aigupito eai vine esau oa u abiyama; eanua tataodi u aihenauidi, eo vine wa u umai. ");
INSERT INTO swp_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Tano enana u hea’a, lamna ie dobi, eo eanua maudoina i hemonau. ");
INSERT INTO swp_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Loguloguna oea tupidi i heoputawaidi, eo maruwai lailaidi lagadi aridi eai hinage; ");
INSERT INTO swp_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","lagadi i loloidi gabogabo eai, ini’inidi hinage se tulaedi Saga eai. ");
INSERT INTO swp_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Paana saha ganana u oiheguri, to taubaeawa gamagaridi uauana se losi? ");
INSERT INTO swp_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Sarai nuura i hebaaea eo oea suisuidi gamagaridi arinai se aibai. ");
INSERT INTO swp_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","Tauiala moutuana Eaubadana e, u sinibuiuioma! Galewa eai u itadobima, eo u ita; vine ta oa u itawatai, ");
INSERT INTO swp_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","lie wa oa nimatutum eai u umai wa. ");
INSERT INTO swp_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Se gabuyao oeagi alaalasina arinai, se oiheguriyao; i lolo am ao u hebaaea aridi eai, abo arinai se mate! ");
INSERT INTO swp_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Na bena oa nimam u torelaei nimatutum tauna wa potana eai; tau natuna oa u headidiri bena oabom enam! ");
INSERT INTO swp_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Abotai taba nige ai sinibui ai lausuaraem; Mauri u leama, abo oa esam eai ai aiaiboda! ");
INSERT INTO swp_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Bena u hetorouioimai, tauiala moutuana edi GUIAU Eaubadana e! matam u hesina potamai eai arinai abo ai mauri! ");
INSERT INTO swp_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Oa em abamia, i lolo ariariri tauiala moutuana GUIAUNA e! ");
INSERT INTO swp_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Hedeomi, earuagu i gadohi ariri eo i amna baaea GUIAU ena abamia bena i lage arinai; nuagu eo bulumagu se wana ma kodedi Eaubada maumaurina arinai. ");
INSERT INTO swp_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Manu gagiridi edi abamia se lobaidi, manu hinage se abinoi, bena nanatudiyao edi abaota, oa em aitalasam hatahatana, tauiala moutuana GUIAUNA e, egu Wasawasa eo egu Eaubada. ");
INSERT INTO swp_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Aidimo em numa eai se mia wa nuadi se kode, huia gamagari em aihelahui se wanaidi! ");
INSERT INTO swp_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Tatao wa edi adidiri se abi oa arim eai abo se kode ariri, isi nuadi eai Siona ena dobila saesaedi! ");
INSERT INTO swp_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Baka gonuna se luhudadai bena abo bunubunuasi dimona se saradi; nabu ena huia sora, na ie taru abo ipu i hemonaudi. ");
INSERT INTO swp_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Se adidiri, i lau e se adidiri ariri; hari eaubada edi Eaubada abo i taumasaraha Siona eai. ");
INSERT INTO swp_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Tauiala moutuana edi GUIAU Eaubadana e, egu uura u ataiei, beam bena i tasoe, Iakobo ena Eaubada e! ");
INSERT INTO swp_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Eaubada e, ema guiau wasawasa bena u italau arinai; bena u italau em heyausi tauna ana ao arinai! ");
INSERT INTO swp_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Taba asubena esega mo em dubu eai ea mia, meta i loro ariri, abotai asubena tausani hari tupo eai. Ea henua ariri bena eau dobila tauitawataina mo egu Eaubada ena numa eai, abotai tau laulau gewagewa ena numalulu eai ea miamia. ");
INSERT INTO swp_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Paana GUIAU Eaubada ia mahana eo opea ede, nualolo eo heasisi i mosei. Nige ginauri lolona esau GUIAU abo i nuahi, isi se mia dudurai aridi eai. ");
INSERT INTO swp_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Tauiala moutuana GUIAUNA e, aitea tau i sunusunumaem ia tau kode mamohoina ede! ");
INSERT INTO swp_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","GUIAU, oa em eanua u abiloloei, Iakobo ena gogo u moseuioi arinai. ");
INSERT INTO swp_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Em tataoyao adi giru u ribagigiridio; edi manamanabara gamagaridi u bubulitawaidio. ");
INSERT INTO swp_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Em ouyalayala u helautom; em nuayalayala gigigigiborina u torehesuara. ");
INSERT INTO swp_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Ema mauri Eaubadana e, bena u helolouioimai, em nuabaaea arimai eai hinage bena u torehesuara! ");
INSERT INTO swp_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Abo u ouyalayalaemai i lau e nige nosina? Em ouyalayala abo u tubei i lau e isi gamagari aridi eai? ");
INSERT INTO swp_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Taba nige u hemauriuioimai, bena em tataoyao se kode arim eai? ");
INSERT INTO swp_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","Em gadosisi miamiahaina bena u hemasaraha arimai eai, oe em mauri hinage bena abo u leama. ");
INSERT INTO swp_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Hage ea ata’atai Eaubada GUIAU ena riba arinai, paana abo i ribabigabiga ena tataoyao aridi eai, ena tau miatahitahi tataodi aridi eai, isi wa se nuabui ia arinai. ");
INSERT INTO swp_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Mamohoi ena abihemauri isi tau matausiena gamagaridi gegesidi eai, bena namanamari abo i otahai ita eda eanua eai. ");
INSERT INTO swp_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Gadosisi miatahitahina eo ao mamohoina se haihailobai, laulau dudurai eo loni se haitalagadoi. ");
INSERT INTO swp_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Ao mamohoi tano eai abo i inisae, laulau dudurai galewa eai abo i itadobi. ");
INSERT INTO swp_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Mamohoi saha eo saha i lolo GUIAU abo i leama, abotai eda tano aiaina abo i helai. ");
INSERT INTO swp_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Laulau dudurai ia abo se edabagunaei, eo ena dobila abo se sepa nonohai. ");
INSERT INTO swp_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Guiau e, ema aba miatahitahi ede oabom mo, isidi gamagamagari eai. ");
INSERT INTO swp_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Oea tupidi sora nige se tubu, tano eo tanoubu sora nige u hetubudi meta huiana ne i laoma e wauta, eo i lau e nige nosina oabom Eaubada. ");
INSERT INTO swp_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Oa tatao u hebuidi se hemala tanouio; u ene, “Tatao nanatudiyao gamagarimiu e, au uio!” ");
INSERT INTO swp_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Paana borimai tausani oa matam eai i lao’o doha lahi, hinage doha maiona esega silawana. ");
INSERT INTO swp_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Tatao u ueahaidi; isi doha enosuai mo, doha lei maratomtom eai i ini harihariu: ");
INSERT INTO swp_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","maratomtom eai ie ini eo ie tubu, maimailahi eai i wowoea eo ie mate. ");
INSERT INTO swp_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Paana em ouyalayala eai ai tauyamui; em nuabaaea i wuitawaimai. ");
INSERT INTO swp_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Ema laulau gewagewadi wa oa matam eai u hemasarahadi, ema lausapuri eamuyamuidi oa matam marana eai u hemasarahadio. ");
INSERT INTO swp_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Paana em nuabaaea eai ema asubena gamagaridi se laoma se lau, ema mauri borimaidi se lao’o doha eahua mo. ");
INSERT INTO swp_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Ema mauri borimaidi ai hasiridi tatao haiona se mate saudoudoi, e ibai adidirimai eai taba tatao hasi se mate ai lobaidi, na ma amna baaeamai eo ma ai’iwalamai mo, nige baeaona se ohi na ai loi ai lau hari teha eai. ");
INSERT INTO swp_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Em ouyalayala gigiborina eai abina ie ata, eo em ouyalayala eai i matausiei? ");
INSERT INTO swp_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Arinai ema asubena hasirina u heatamai abo nuasonoga ai lobai. ");
INSERT INTO swp_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","GUIAU e, u uioma! Tabu u boneawa! Em heaheari tataodi u nuatoataedi! ");
INSERT INTO swp_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Maratomtom huiadi eai nuamai u hebigadi em gadosisi miatahitahina arinai, abo ema asubena gamagaridi eai ai nualolo eo ai kode. ");
INSERT INTO swp_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Asubena gamagamagari u heamnabaaeamai wa, eo borimai gamagamagari hinage amamna aie ita wa gonogonoana abo hinage u hekodemai. ");
INSERT INTO swp_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Bena am paisoa i masaraha em heaheari tataodi aridi eai; em gigibori namanamarina nanatumyao aridi eai. ");
INSERT INTO swp_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","GUIAU ema Eaubada bena em nualolo i ota ai potamai eai, ema nimapaisoa hinage bena u helolodi, hedeomi, ema nimapaisoa oa bena u helolodi. ");
INSERT INTO swp_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Aitea tau ia Saesae‐Aririna loguloguna eai i miahai, ia Gigibori‐Aririna loguloguna eai i miatahitahi, ");
INSERT INTO swp_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","ia abo i ribalau GUIAU arinai i ene, “Egu aba dago lolona eo egu aba mia adiadidirina, egu Eaubada, egu sunuma ea tore esegai arim eai.” ");
INSERT INTO swp_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Paana ia manu siposipona arinai abo i saguhaim, asiebo baaea eai hinage; ");
INSERT INTO swp_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","goina eai abo i buburim, eo mabena ubuna eai em aba ailogulogu abo u lobai; ena riba hemamohoiena opea gagirina eo opea lailaina ede. ");
INSERT INTO swp_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Maiona hematausina ginaurina taba nige u matausiei, asubena eai pidu se tu hinage taba nige’e, ");
INSERT INTO swp_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","baaea lailai masigiri eai ie sae ie dobi taba nige u matausiei, asubenalai eai sabom i hebaaea hinage taba nige’e. ");
INSERT INTO swp_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Tausani gegesim eai abo se guri, tausani saudoudoi nimatutum eai hinage, na taba nige iwala wa i laoa oa gegesim eai. ");
INSERT INTO swp_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Matam eai mo abo u aiaiewa laulau gewagewa tataodi edi maisa abo u ita. ");
INSERT INTO swp_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Paana GUIAU ue abi em aba dago lolona, Saesae Aririna ia em abahomo ");
INSERT INTO swp_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","taba nige baaea esau i abi’itam, nige iwala saha i laoma oa em numalulu gegesina eai. ");
INSERT INTO swp_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Paana ia ena aneru abo i hetorodi se itawataim, em dobila gamagaridi eai abo se ganaganaim. ");
INSERT INTO swp_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Isi nimadi eai abo se abi’isinim, ata aem u hetupanei we’u eai. ");
INSERT INTO swp_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Liona eo mota abo u ututawaidi, ae aroarom eai liona natuna eo mota abo u ututawaidi. ");
INSERT INTO swp_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Paana ia gadosisi debana eai i patulaoma, eau abo ea lebohai; abo ea ganaganai, paana esagu abina ie ata. ");
INSERT INTO swp_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Ena i eogalaoma, abo ea heuio; huia baaea boeana eai eau abo gegesina eai, eau abo ea lebohai, eo abo ea heasisiei. ");
INSERT INTO swp_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Ena mauri abo ea heloha, eo abo ea henuabiga, egu abihemauri hinage eau abo ea heita. ");
INSERT INTO swp_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","GUIAU ia wasawasa ede; ia ana tepo wasawasana eai se helui; GUIAU se helui, adidirina ie lio. Mamohoi tanoubu i totoro adidiri; taba nige se hemoimoiu. ");
INSERT INTO swp_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Em terona mumuga eai se hetoro; oa mumuga ariri eai u mia nige nosina. ");
INSERT INTO swp_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","GUIAU e, dibori utu’utu se dagudagugu, dibori utu’utu arinadi se lauisinidi, dibori utu’utu balamumudi se helaidi. ");
INSERT INTO swp_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","GUIAU ini puripurina eai i gigibori ariri, ena gigibori dibori utu’utudi gamagaridi dagugudi i saetawatawaidi, gabogabo bagodudi edi gigibori i saetawatawaidi! ");
INSERT INTO swp_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Ena lauhesom ribadi isi ede mamohoi ariri; hetabuena i patulau em numa tabuna arinai, GUIAU e, i lau e nige nosina. ");
INSERT INTO swp_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Ehei, au laoma ta wana GUIAU arinai, ta wowo ma kodeda eda mauri we’utauna arinai! ");
INSERT INTO swp_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Ta laoma ia matana eai ma lautoida, ta wowo ma kodeda ia arinai, ta wana ia ta aihelahui! ");
INSERT INTO swp_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Paana ede GUIAU ia Eaubada lailaina, ia wasawasa lailai didigana, eaubada gamagaridi i saetawatawaidi. ");
INSERT INTO swp_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Tanoubu ubu aririna ia nimana eai, oea tupidi saesaedi hinage ia enanayao ede; ");
INSERT INTO swp_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Gabogabo ede ia enana, paana ia i hetubu, ia nimana eai tano pitapitarina i ginauri. ");
INSERT INTO swp_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Ehei, au laoma ta aihelahui eo ta tabaohui, ta turibono GUIAU matana eai, ia Tauhetubuda ede! ");
INSERT INTO swp_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Paana ia eda Eaubada, ita ena ganaalo tataoda eo ia nimana mamoedi. I lolo wauta arinana au ataiei! ");
INSERT INTO swp_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","Tabu nuamiu au heoiuradi doha Meriba eai, doha asubena wa Masa eai, barabara eai, ");
INSERT INTO swp_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","huiana wa tamamiuyao se lauitagu, eo se nohoigu, na agu paisoa se itayao. ");
INSERT INTO swp_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Borimai tatao labui se mate isi ne ea hewaiunuedi, eo ea ene, “Tatao ta nuadi eai se ponori ariri, eo egu laulau nige se nuatuidi.” ");
INSERT INTO swp_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Arinai ma ouyalayalagu ea riba aigora, bena taba nige se awasaei eau egu abaaiyawasi eai. ");
INSERT INTO swp_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Omi wana harihariuna au wanai GUIAU arinai! Tanoubu maudoina e, GUIAU arinai au wana! ");
INSERT INTO swp_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Au wana GUIAU arinai, ia esana au ribatausaei; ena abihemauri au hemasaraha, asubena to asubena. ");
INSERT INTO swp_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Tanoubu tataodi gamagaridi matadi eai ena namanamari au ribahemasaraha, ena heiheinoi gigiboridi tatao gamagaridi matadi eai! ");
INSERT INTO swp_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Paana GUIAU i lai ariri, ia aihelahuina hinage i lai ariri; eaubada udoi udoi i saetawatawaidi. ");
INSERT INTO swp_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Paana basileia udoi udoi edi eaubada ede oitau; na GUIAU ia galewa tauginaurina. ");
INSERT INTO swp_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Heasisi eo wasawasana ia matana eai, adidirina eo ao lolona ia ena abamia tabuna eai. ");
INSERT INTO swp_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","GUIAU enana au mosei, omi boga udoi udoi tataomiu e, GUIAU arinai namanamarina eo adidirina au mosei! ");
INSERT INTO swp_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Namanamarina GUIAU esana enana au mosei; ainauia au leama au awasaema ena dubu alona eai. ");
INSERT INTO swp_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","GUIAU au tabaohui, lulu tabudi au luidi, ia matana eai au tabutabubu, tanoubu tataomiu gamagarimiu e! ");
INSERT INTO swp_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Eanua gamagaridi taumiaidi au heribadi au ene, “GUIAU ia wasawasa ede! Mamohoi tanoubu se hetoro, taba nige i moimoiu; tanoubu tataodi ia i heduduraidi ma duduraina.” ");
INSERT INTO swp_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Galewa taba i kode, tanoubu taba i wowo, gabogabo taba i dagugu, eo taumiaina, ");
INSERT INTO swp_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","oea taba i kode, eo taumiaina hinage; abotai nuura oeagidi abo se wana ma kodedi, ");
INSERT INTO swp_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","GUIAU matana eai, paana ia ede i laoma, paana ia ede i laoma tanoubu i hedudurai ma laulau duduraina, eo tatao wa ma ao mamohoina. ");
INSERT INTO swp_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Tanoubu tataomiu gamagarimiu e, kode daguguna au ginauri GUIAU arinai! ");
INSERT INTO swp_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","GUIAU au heayaiyei ma kodekodemiu, au laoma ia matana eai ma wanamiu! ");
INSERT INTO swp_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Omi abo au nuatui, GUIAU ia Eaubada. Ia i ginaurida, ita ia enana; ita ia ena tataoyao, eo ita ia ena heaheai mamoena. ");
INSERT INTO swp_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Au lulau ena dobila eai ma lautoimiu, au lulau ena dubu alona eai ma hedebasaemiu! Ia au lautoiei, ia esana au ribatausaei! ");
INSERT INTO swp_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Paana GUIAU i lolo, ena gadosisi miatahitahina i ota esegai i lau e nige nosina, eo ena riba hemamohoiena i lau e hari isi to hari isi. ");
INSERT INTO swp_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Earuagu e, GUIAU u ribatausaei; nuagu maudoina e, ia esana tabuna u ribatausaei. ");
INSERT INTO swp_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Earuagu e, GUIAU u ribatausaei, eo ena ainauia gamagaridi tabu u nuahuiedi: ");
INSERT INTO swp_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","ia em laulau gewagewadi gamagaridi ie ribagigiridi, ia em iwala gamagaridi i helolodi, ");
INSERT INTO swp_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","em mauri ia mate Duhana eai i unehai, ia urum i heou gadosisi miatahitahina eo nuatoatoa arinai, ");
INSERT INTO swp_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","ia ginauri lolodi eai awam i hemonau i lau e em mauri sigana eai, arinai taum ena adidiri i heharihariu doha magesubu. ");
INSERT INTO swp_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","GUIAU abiabi dudurai i hemasaraha, isi gamagaridi se heamamnadi aridi eai. ");
INSERT INTO swp_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Ia ena dobila Mose i heata, ena paipaisoa hinage Isaraela tataodi gamagaridi i heatadi. ");
INSERT INTO swp_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","GUIAU ena nuatoatoa eo ena aiainauia ie lai, ena ouyalayala nige i abiheulai, ena gadosisi miatahitahina i helai mo ie lau. ");
INSERT INTO swp_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Ia taba nige huia gamagari i dilaida, ena ouyalayala taba nige i ota huia gamagari. ");
INSERT INTO swp_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Eda baaea maisadi nige i ledima, eo eda laulau gewagewadi hinage nige maisadi i ledima. ");
INSERT INTO swp_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Paana ede doha galewa tanoubu i saetawatawa aririei, doha ede meta ena gadosisi miatahitahina laina, ia tauheasisiena enadi. ");
INSERT INTO swp_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Lohana doha mahana ena abadalasae ie lau mahana ena abadui, lohana doha meta eda awayagara arida eai i abihesuaradi. ");
INSERT INTO swp_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Doha hinage tamana nanatunayao i nuatoatoaedi, GUIAU tauheasisiena tataodi nei doha abo i nuatoatoaedi. ");
INSERT INTO swp_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Paana edohana ena ginaginaurida ia abina i atao, i nuatuiyao ita doha tano muamuana. ");
INSERT INTO swp_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Na tau ia ena mauri asubenadi doha lei, e doha oea liasidi i maumauriei: ");
INSERT INTO swp_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","paana mana ie toa ede i eohoei i lao’o, ena abaota wa nige i itauioi. ");
INSERT INTO swp_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Na GUIAU ena godosisi miatahitahina mumuga ariri eai i laoma, otaotana i lau e nige nosina, ia tauheasisiena enadi, eo ena laulau dudurai isimuri to isimuri tataodi enadi, ");
INSERT INTO swp_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","isi ena laugagaeo taunanabuena enadi, eo ena lauheata ribadi taunuanuatuidi, eo taupaisoaidi enadi. ");
INSERT INTO swp_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","GUIAU ena terona galewa eai i abinonohai, eo tanoubu maudoina boeana eai ia wasawasa ede. ");
INSERT INTO swp_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","GUIAU au ribatausaei, omi ena aneru e, omi emi adidiri i lai ariri, ia ena lauhesom au nanabuedi, ena riba daguguna hinage au ataataiei! ");
INSERT INTO swp_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Ena tauiala tataomiu gamagarimiu e, galewa tehana eai, GUIAU au ribatausaei, ena heaheari tataomiu ena gadosisi au lauwatai, ia au ribatausaei! ");
INSERT INTO swp_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","GUIAU ena nima paisoa gamagarimiu e, omi ia au ribatausaei, eanua gamagaridi ia i tanuagaidi. Earuagu e, GUIAU u ribatausaei! ");
INSERT INTO swp_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","Earuagu e, GUIAU u ribatausaei! GUIAU e, egu Eaubada, oa u lai ariri! Heasisi eo wasawasana arinai se heluim, ");
INSERT INTO swp_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","oa mara eai u bubuliuioim, doha lulu, galewa ue wese doha numalulu, ");
INSERT INTO swp_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","oa em abamia ena tuaga u toredi goila potadi eai, ealoi u abidi em abageru, mana mabena potadi eai ue gerusae, ");
INSERT INTO swp_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","oa mana u abidi em tauwasa, oeagi ala’alana eo balebalelemna em heaheari ede. ");
INSERT INTO swp_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Tanoubu u hetoro ena du potadi eai, bena tabu se hemoiu i lau e nige nosina. ");
INSERT INTO swp_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Gabogabo arinai u buburi doha ena lulu; oea tupidi se salili goila gabotumna eai. ");
INSERT INTO swp_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Em riba su’u arinai goila se dago; em parere daguguna eai se loi. ");
INSERT INTO swp_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Oea tupidi eai se dididioidi se didi dobi gonu eai i lau e se lage teha eai wa oa u abinonohai enadi. ");
INSERT INTO swp_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Adi sigasiga ue tore, taba nige se hemuri, bena tabu huia esau tanoubu se hesalili. ");
INSERT INTO swp_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Gonu eai goila bunubunuwasina u hesito seama, se didilau oea duaduaridi eai, ");
INSERT INTO swp_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","se hemala nu’ura suisuidi gamagaridi edi aba nom, asini manamanabaradi gadodi se hebigadi. ");
INSERT INTO swp_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Gegesidi eai maragaibu manudi edi abamia se abidi, oeagi lagadi boeadi eai se wana. ");
INSERT INTO swp_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Em abamia ewa ariri eai oea tupidi adi goila u mosei, tanoubu ie sese am paisoa uauana arinai. ");
INSERT INTO swp_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Lei u he’ini suisui adi, oea uauadi hinage bena tau i umaidi, bena tano eai aiai i abi, ");
INSERT INTO swp_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","waina hinage abo tau nuana i hekode, eausi abo arinai ana ao i masaraha, falawa hinage abo tau nuana i headidiri. ");
INSERT INTO swp_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","GUIAU ena oeagi goila se henomaririedi, Lebanona ena tamonau ia i umaidi wa. ");
INSERT INTO swp_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Lagadi eai manu se abinoi; oeagi lailaidi eai hinage manu siari lohalohana ena noi i ginauri. ");
INSERT INTO swp_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Oea tupidi saesaedi goti manamanabaradi edi abalau, we’u lailaidi sibini edi aba bawayamui ede. ");
INSERT INTO swp_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Nawarai oa u ginauri abo borimai sorasoradi edi heiheinoi; mahana iabom ena huia dui abina ie ata. ");
INSERT INTO swp_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Masigiri u leama to i maiona, nu’ura suisuina gamagarina se dalapesama. ");
INSERT INTO swp_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Liona nanatudiyao se dou adi aiai sabidi adi aiai wa bena se eo’o Eaubada nimana eai. ");
INSERT INTO swp_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Mahana ena huia dalasae abo se uio, se ota edi duha eai. ");
INSERT INTO swp_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Tau ie pesa ie lau ena aba paisoa eai, i paipaisoa i lau e i maimailahi. ");
INSERT INTO swp_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","GUIAU e, nimam ginauridi ta’i se gamagari! Sonogam eai ginauri gamagaridi oa u hetubudi; tanoubu i monau nimam ginauridi aridi eai. ");
INSERT INTO swp_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Gabogabo kalau nei eai, ie lai eo i magaga, ginauri gamagaridi se hemonau, ginauri maumauridi, gagiridi eo lailaidi. ");
INSERT INTO swp_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Waga hinage se adau se lau, ulaulasi hinage u ginarui abo nei eai i aiaihea. ");
INSERT INTO swp_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Teina ginauri gamagaridi ta se italaowa arim eai, huia mamohoina eai aiai adi abo u mosedi. ");
INSERT INTO swp_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Ena u mosei aridi eai, se abi se ai; ena nimam u soe bogadi se sese ginauri lolodi aridi eai. ");
INSERT INTO swp_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Ena am ao u toreamui se heunaboisaha; ena eahuadi u abihaidi se mate, eo se uio tano muamuana arinai. ");
INSERT INTO swp_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Taba Earuam u hetamarilaei, se maumauri; tano ana ao u heharihariu. ");
INSERT INTO swp_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","GUIAU namanamarina bena i mia i lau e nige nosina! GUIAU bena i kode ariri ena nima paisoa aridi eai, ");
INSERT INTO swp_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","ia i italau tanoubu potana eai to tanoubu i tabutabubu, oea tupidi i abi’itadi to se asuasu! ");
INSERT INTO swp_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Egu mauri asubenana maudoina eai, GUIAU abo arinai ea wana, ma maumaurigu Eaubada abo ea hedebasaei wana arinai. ");
INSERT INTO swp_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Egu nuanuatu eai bena ia nuana ea helolo, paana ea nuawoiwoina GUIAU arinai. ");
INSERT INTO swp_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Taba tatao baaeadi se helautomdi tanoubu eai ta, taba tatao manamanabaradi se mateohi! Earuagu e, GUIAU u ribatausaei! GUIAU u aihelahui! ");
INSERT INTO swp_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","GUIAU ta lautoiei, paana ia i lolo; eo ena gadosisi miatahitahina i laulau i lau e nige nosina! ");
INSERT INTO swp_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Isi GUIAU i unehaidi wa bena se ribahemasaraha, isi wa iwala eai i unehaidi, ");
INSERT INTO swp_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","eo eanua udoi udoi eai i woeagogoidi, tupo mahana ena aba dalasae eai eo tupo mahana ena aba dui eai, tupo bauri eo tupo eawana eai. ");
INSERT INTO swp_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Headi barabara eai se sae se dobi, nige eanua se lobai bena arinai se mia; ");
INSERT INTO swp_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","se guriam eo se gadomagu, se nua beruberu ariri. ");
INSERT INTO swp_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Abo se doulau GUIAU arinai edi piripiri eai, eo i saguhaidi edi amamna eai; ");
INSERT INTO swp_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","dobila duduraina eai i woeaidi, i lau e eanua se lagelobai abo arinai se mia. ");
INSERT INTO swp_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","I lolo GUIAU se lautoiei ena gadosisi miatahitahina debana eai, ena abiabi lolo dumadumadi tatao nanatudiyao aridi eai! ");
INSERT INTO swp_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","Paana taugadomagu gadona i hebiga, eo tauguriam bogana i hesese ginauri lolodi aridi eai. ");
INSERT INTO swp_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Tatao headi masigiri eo nuadubu boeana eai se babawa, tau‐tutugudu amamna eo auau poasi eai, ");
INSERT INTO swp_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","paana Eaubada ena riba se oipiriedi, eo Saesae Aririna ena riba hesanapu se isuewaei. ");
INSERT INTO swp_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Se nuadobidobi paisoa oiurana debana eai; se guridobi na nige tausaguidi. ");
INSERT INTO swp_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Abo se doulau GUIAU arinai edi piripiri eai, eo i hemauridi edi amamna eai; ");
INSERT INTO swp_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","masigiri eai eo nuadubu eai ia i woeahaidi, eo edi auau ia i tomutusidi. ");
INSERT INTO swp_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","I lolo GUIAU se lautoiei ena gadosisi miatahitahina debana eai, ena abiabi lolo dumadumadi tatao nanatudiyao aridi eai! ");
INSERT INTO swp_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","Paana dobila gududi bronze i eatugorugorudi, gana poasi i tomutusilabuiedi. ");
INSERT INTO swp_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Headi se asiebo, matapaana edi laulau awayagara, eo edi manamanabara debadi eai amamna se hearodi; ");
INSERT INTO swp_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","aiai udoi udoi se nua’itaitaedi, eo mate dobilana guduna se hanahanaui. ");
INSERT INTO swp_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Abo se doulau GUIAU arinai edi piripiri eai, eo i hemauridi edi amamna eai; ");
INSERT INTO swp_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","ena riba i hetamarilaei to i helolodi, mate eai i abihemauridi. ");
INSERT INTO swp_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","I lolo GUIAU se lautoiei ena gadosisi miatahitahina debana eai, ena abiabi lolo dumadumadi tatao nanatudiyao aridi eai! ");
INSERT INTO swp_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Abo hinage lautoi aitalasamdi se moselaedi, eo ena laulau se wasawasaedi ma wana kodedi! ");
INSERT INTO swp_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Tatao headi waga eai se adau se lau gabogabo eai, adi paisoa se laelaei gabogabo lailai eai; ");
INSERT INTO swp_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","GUIAU ena laulau se itadi, ena abiabi lolo dumadumadi gabotum eai. ");
INSERT INTO swp_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Paana ia ena riba eai na mana baaea ie toa, gabogabo butubutuna i helaidi. ");
INSERT INTO swp_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Se sae e galewa, abotai se dobiuio gabotum, piripiri ta debana eai edi nuaadidiri ie welo; ");
INSERT INTO swp_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","se mataodeode, eo se utu’utu sagisagigi doha doga i nomeauyaure, eo nuadi se tupa. ");
INSERT INTO swp_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Abo se doulau GUIAU arinai edi piripiri eai, eo i hemauridi edi amamna eai. ");
INSERT INTO swp_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Abo mana baaea i hemotu eo gabogabo butubutudi se daumori. ");
INSERT INTO swp_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Abotai se kode ariri paana i daumori, to ia i woealaedi edi abalo se henua wa arinai. ");
INSERT INTO swp_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","I lolo GUIAU se lautoiei ena gadosisi miatahitahina debana eai, ena abiabi lolo dumadumadi tatao nanatudiyao aridi eai! ");
INSERT INTO swp_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","I lolo abo tatao edi oigogo eai ia se wasawasaei, babada edi oigogo eai hinage bena se hedebasaei. ");
INSERT INTO swp_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Sagasaga i abiitadi se guma doha barabara, goila bunubunuwasina i hemala tano pitapitarina, ");
INSERT INTO swp_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","oea masurina i abiita abo i hemala ariarita barabarana, taumiaina edi baaea debadi eai. ");
INSERT INTO swp_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Barabara i hebui i hemala goila ipuna, tano pitapitarina i hemala goila ena ababunubunuwasi. ");
INSERT INTO swp_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Nei eai tauguriam i hemiadi, edi eanua se hetoro abo arinai se mia; ");
INSERT INTO swp_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","edi oea se umaidi, vine hinage se umaidi, abotai se masuri lolo. ");
INSERT INTO swp_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Ia ena aiainauia debana eai se helaiuioi; edi suisui hinage taba nige gamagarina i gagiri. ");
INSERT INTO swp_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Ena Eaubada ena tataoyao se saetawatawaidi, eo nuadi se beruberu, hewaiunu, iwala e nuadubu debadi eai, ");
INSERT INTO swp_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","ena isuewa abo i hegoilaei wasawasa potadi eai eo i hetamaridi se laulau gaibu barabara nige dobiladi aridi eai; ");
INSERT INTO swp_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","na gogogesagesa tauna i lauisini lauita boeana eai, eo nanatunayao i hegamagaridi doha mamoe eawoina. ");
INSERT INTO swp_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Taududurai ie ita to nuana i lolo; na laulau gewagewa tataodi nige ariarinadi. ");
INSERT INTO swp_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Eai to eai i sonoga i lolo ginauridi ta i nuatudidinidi; i lolo GUIAU ena gadosisi miatahitahina bena se nuanuatui. ");
INSERT INTO swp_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","GUIAU i ribalau egu guiau arinai i ene, “Nimatutugu eai u bawa, i lau e am waiunuyao abo ea abidi se hemala aem ana bou.” ");
INSERT INTO swp_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Em gigibori tuena Siona eai GUIAU i hetamarilaei. Am waiunuyao boeadi eai oa abo tanuaga! ");
INSERT INTO swp_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Em tataoyao abo se moselaeiuiodi ma kodedi asubenana eai wa arinai em tauiala u woeaidi oea tupidi tabudi potadi eai. Maratomtom begana eai em isihariu doha wabumari abo se laoa arim eai. ");
INSERT INTO swp_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","GUIAU i riba aigora, eo taba nige nuana i bui, “Oa kohena ede, i lau e nige nosina, Melekisadeka dobilana u miawatai.” ");
INSERT INTO swp_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Guiau ia nimatutum eai; wasawasa abo i hetatagorigoridi ena ouyalayala asubenana eai. ");
INSERT INTO swp_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Eanua taumiaidi abo i heduduraidi, tatao sinaredi eanuadi abo se hemonaudi; babada abo i eatugorigoridi tanoubu maudoina potana eai. ");
INSERT INTO swp_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Saga gagirina dobila gegesina eai abo arinai i ainom; abotai uruna abo i lauisini. ");
INSERT INTO swp_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Nige ai enamai, GUIAU e, nige ai enamai, na oa esam namanamarina enana abo se moselaei, em gadosisi miatahitahina debana eai, eo em riba hemamohoiena debana eai hinage! ");
INSERT INTO swp_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Paana saha abo etene si ene, “Edi Eaubada ede haedi?” ");
INSERT INTO swp_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Ema Eaubada ia galewa eai; saha eo saha i henua meta mo i ginauridi. ");
INSERT INTO swp_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Isi edi oitau silver eo gold aridi eai se ginauridi, tau nimana ginaurina. ");
INSERT INTO swp_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Isi awadi, na nige se ribariba; isi matadi, na nige se itaita. ");
INSERT INTO swp_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Isi beadi, na nige saha se ataiei; isi isudi, na nige se panei. ");
INSERT INTO swp_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Isi nimadi, na nige se abi’ita; aedi hinage na nige se laulau; eo gadoliedi eai nige begana dagugudi. ");
INSERT INTO swp_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Tatao tauginauridi wa gonogonoana doha isi gamagaridi hinage eai to eai edi sunuma se torelaei aridi eai, ");
INSERT INTO swp_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","Isaraela e, GUIAU au sunumaei! Ia isi adi sagu eo edi opea ede. ");
INSERT INTO swp_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Arona numana e, emi sunuma au tore esegai GUIAU arinai! Ia isi adi sagu eo edi opea ede. ");
INSERT INTO swp_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Omi eai to eai GUIAU au matausiei, GUIAU au sunumaei! Ia isi adi sagu eo edi opea ede. ");
INSERT INTO swp_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","GUIAU ia i nuanuatuidaoieda; ia abo i heloloda; Isaraela numana abo i helolo; Arona numana abo i helolo. ");
INSERT INTO swp_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Isi GUIAU se matausiei abo i helolodi, dodoga gagiridi, eo dodoga lailaidi. ");
INSERT INTO swp_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","GUIAU emi gogo taba i helai, eo nanatumiuyao enadi hinage! ");
INSERT INTO swp_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Taba GUIAU i helolomiu, ia galewa eo tanoubu tau ginauridi! ");
INSERT INTO swp_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Galewa isi ede GUIAU ena galewa, na tanoubu mo i moseyao tatao nanatudiyao aridi eai. ");
INSERT INTO swp_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Tau matematena ia taba nige GUIAU i hedebasaei, gonogonoana hinage isi gamagaridi wa se dobi monomonou eai: ");
INSERT INTO swp_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","Na ita GUIAU abo ta ribatausaei ina wauta eo i lau e nige nosina. GUIAU au hedebasaei! ");
INSERT INTO swp_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","GUIAU ea gadosisiei paana eau arinagu eo egu aiaiboda ia i ataiedio. ");
INSERT INTO swp_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Ia i nonoha arinagu i ataiei, arinai egu mauri huiana maudoina eai abo ea eogalau arinai. ");
INSERT INTO swp_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Mate ena sai’i se wese hetaiirigu, Hade amamnadi se abigu; nuadubu eo amamna lailai ea hearodi. ");
INSERT INTO swp_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Abotai ea eogalau GUIAU esana ea atai: “GUIAU e, ea dousaewa, oa bena u abihemaurigu!” ");
INSERT INTO swp_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Ia abilolo eo laulau dudurai GUIAUNA ede; eda Eaubada ia nuatoatoa Eaubadana ede. ");
INSERT INTO swp_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Tau dobidobina GUIAU i ganaganai; huiana wa nuagu i dobidobi ia i lebohaigu. ");
INSERT INTO swp_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Nuagu e, u uio em abaaiyawasi eai; paana GUIAU i ainauia aririem. ");
INSERT INTO swp_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Mate eai u saguhaigu, matasulugu matagu eai u sauhai, aegu u headidiridi bena tabu ea alabesibesi. ");
INSERT INTO swp_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","GUIAU matana eai abo ea laulau tatao maumauridi oeana eai. ");
INSERT INTO swp_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Huiana wa ea ribaei ea ene, “Egu lauita i lai ariri”; na egu sunuma mo nige ea abigabaei. ");
INSERT INTO swp_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","Egu heunaboisaha eai ea ene, “Tatao gamagaridi se sunuma gaibu.” ");
INSERT INTO swp_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","Saha abo ea moselaei GUIAU arinai ena abilolo gamagarina arigu eai maisana? ");
INSERT INTO swp_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Mauri biana abo ea abiisini eo ea eogalau GUIAU arinai esana ea atai, ");
INSERT INTO swp_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","egu aigora abo ea hemamohoiedi GUIAU arinai, ena tataoyao gamagaridi matadi eai. ");
INSERT INTO swp_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Ena taumiutahitahi tataodi edi mate i sae ariri GUIAU matana eai. ");
INSERT INTO swp_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","GUIAU e, eau em heaheari tauna esau, eau em heaheari tauna, em heaheari sinena natuna, egu auau u eairihaidio. ");
INSERT INTO swp_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Lautoi aitalasamna abo ea moseleawa arim eai, eo abo ea eogalau GUIAU arinai esana ea atai. ");
INSERT INTO swp_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Egu riba aigora abo ea hemamohoiedi GUIAU arinai, ena tataoyao gamagaridi matadi eai, ");
INSERT INTO swp_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","GUIAU ena numa bau’ubau’una eai, boeam eai, Ierusalema e. GUIAU ta hedebasaei! ");
INSERT INTO swp_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","GUIAU ia egu gogo ede; ea ribahesunuma oa em riba abo ea sogohididinidi. ");
INSERT INTO swp_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Ma nua’esegagu em nualolo ea aiboda gadogadorai; em riba hesunuma debana eai bena u nuatoatoaegu. ");
INSERT INTO swp_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","Ena em abiabi ea nuanuatuidi, aegu ea toreuoidi em riba tabudi aridi eai; ");
INSERT INTO swp_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","Ea lelehi, taba nige ea bebeda em lauhesom bena ea nanabuedi. ");
INSERT INTO swp_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Laulau gewagewa tauna siposipo mainana arinai bena i sipoigu, na em laugagaeo taba nige ea nuahuiei. ");
INSERT INTO swp_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","Bulinuana eai ea toro ea lautoiem, em hesanapu ribadi duduraidi debadi eai. ");
INSERT INTO swp_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Tatao gamagaridi taumatausiem eau boeadi eai, isi gamagaridi em lauheata ribadi se nanabuedi. ");
INSERT INTO swp_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","GUIAU e, em gadosisi miatahitahina ta tanoubu i hemonauyao; em laugagaeo bena u heatagu! ");
INSERT INTO swp_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","Em abi se lolo em heaheari tauna arinai, GUIAU e, oa em riba debana eai. ");
INSERT INTO swp_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Sibasiba lolona eo sonoga oa bena u heatagu, paana em lauhesom ea awamamohoiedi. ");
INSERT INTO swp_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Huiana eai wa sora nige amamna ea hearo, ea lausuaraem; na ina huia ta em riba ea sogohididinidi. ");
INSERT INTO swp_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","Oa u lolo, em abiabi hinage se lolo; em laugagaeo bena u heatagu. ");
INSERT INTO swp_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","Etene tataodi riba borabora arinai se hebaaeagu, na eau ma nuagu i ohihai em lauheata ribadi ea abididinidi. ");
INSERT INTO swp_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Isi nuadi se potopoto doha momona, na eau em laugagaeo mo ea henua aririei. ");
INSERT INTO swp_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","Mamohoi i lolo ariri lauita ea hearodi; debana eai em laugagaeo ea italobaidi. ");
INSERT INTO swp_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Oa awam laugagaeona ie sae ariri arigu eai, abotai gold eo silver gamagamagaridi. ");
INSERT INTO swp_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","Em riba, GUIAU e, i otaesegai galewa eai, i lau e nige nosina. ");
INSERT INTO swp_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","Em riba u hemamohoiedi i lau e isi gamagaridi aridi eai; tanoubu u hetoro‐tahitahi, eo i otaesegai. ");
INSERT INTO swp_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Oa em riba debana eai wauta se totoro; paana ginauri gamagaridi oa em heaheari ede. ");
INSERT INTO swp_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Ena oa em laugagaeo nige i hekodegu, lauita boeana eai abo ea mate aririo. ");
INSERT INTO swp_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Oa em lauheata ribadi taba nige ea nuahuiedi, paana isi debadi eai u abihemaurigu. ");
INSERT INTO swp_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Eau oa enam, bena u abihemaurigu; paana oa em lauheata ribadi ea eo’eo’oidi. ");
INSERT INTO swp_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Laulau gewagewa tataodi se bagibagi bena se unuigu, na oa em riba tabudi mo ea nuanuatuidi. ");
INSERT INTO swp_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Laulau lolo dumadumadi adi sigasiga ea itadio, na oa em lauhesom mo i magaga ariariri. ");
INSERT INTO swp_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Em laugagaeo ea gadosisi aririei! Asubena maudoina eai i hemala egu abanuanuatu. ");
INSERT INTO swp_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Em lauhesom i hesonoga aririegu, agu waiunuyao nige doha, paana huia gamagari matagu eai i totoro. ");
INSERT INTO swp_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Ea sibasiba ariri abotai egu taulauheata, paana em riba tabudi egu aba nuanuatu ede. ");
INSERT INTO swp_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Ea sibasiba ariri abotai tautaubada, paana em lauheata ribadi ea nanabuedi. ");
INSERT INTO swp_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Aegu ea abididinidi tabu dobila gegewarina ea lauwatai, em riba mo bena ea awaabiei. ");
INSERT INTO swp_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Em ribahesanapu taba nige ea torehesuaradi, paana oa u heataguo. ");
INSERT INTO swp_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Em riba se amna ariri awagu eai, se amna ariri awagu eai abotai amoamo! ");
INSERT INTO swp_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Em lauheata ribadi aridi eai sibasiba ea lobai, to arinai dobila boraboradi gamagaridi ea hewaiunuedi. ");
INSERT INTO swp_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Oa em riba ede eau aegu ena lamepa, eo egu dobila ena mara. ");
INSERT INTO swp_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Eau ea aigorao, abo hinage ea hemamohoiei, em hesanapu ribadi duduraidi wa abo ea abiwataidi. ");
INSERT INTO swp_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Egu amamna se gamagari ariri; GUIAU e, oa u hemaurigu, gonogonoana doha ue ribaei wa! ");
INSERT INTO swp_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","GUIAU e, egu hedebasae aitalasamna awagu eai bena u abidi eo em hesanapu ribadi wa bena oa u heatagu. ");
INSERT INTO swp_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Egu mauri eau nimagu eai huia gamagamagari, na oa em laugagaeo nige esau ea nuahuiei. ");
INSERT INTO swp_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Laulau gewagewa tataodi sai’i se tore bena se sai’igu, na oa em lauheata ribadi taba nige ea lausuaraedi. ");
INSERT INTO swp_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Oa em riba tabudi ea abidi doha egu gogo i lau e nige nosina; mamohoi eau nuagu ena abakode meta. ");
INSERT INTO swp_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Eau nuagu ea toreyao em lauhesom ribadi ea lauwataidi huia gamagari, i lau e sigana eai. ");
INSERT INTO swp_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Oa em riba tabudi wa se sae ariri; arinai earuagu i sogohididinidi. ");
INSERT INTO swp_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Ena em riba se hemasaraha abo i hemaramai; tau supusupu i hesibasiba. ");
INSERT INTO swp_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Ma awadabarigu eawasigu ie ku’u, paana em lauhesom ribadi ea gadohiedi. ");
INSERT INTO swp_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","U sinibuima eo u nuatoatoaegu, paana oa kamanim isi esam tau gadosisiena aridi eai. ");
INSERT INTO swp_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Aegu u headidiridi em ribahesunuma debana eai, abo taba nige laulau gewagewa esau i saetawatawaigu. ");
INSERT INTO swp_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Tau ena hewahewaiunu arinai bena u unehaigu, abo em lauheata ribadi ea abiwataidi. ");
INSERT INTO swp_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Am ao bena u hesina em heaheari potana eai, eo em laugagaeo u heatagu. ");
INSERT INTO swp_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Eau matasulugu se dididi, mata paana tatao oa em laugagaeo nige se awaabiei. ");
INSERT INTO swp_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","GUIAU e, oa u dudurai, em hesanapu ribadi hinage se dudurai. ");
INSERT INTO swp_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Em riba tabudi u hetorodi laulau dudurai debadi eai. eo em riba hinage u hemamohoiedi. ");
INSERT INTO swp_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Egu nuaialayala i gabugu, paana agu waiunuyao em riba se nuahuiedi. ");
INSERT INTO swp_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Oa em ribahesunuma wa se lauitayao, eo em heaheari tauna i gadosisiei. ");
INSERT INTO swp_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Eau ea dobi ariri, to se isuewaegu, na oa em lauheata ribadi taba nige ea nuahuiedi. ");
INSERT INTO swp_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","Oa em laulau dudurai se dudurai i lau e nige nosina, eo oa em laugagaeo mamohoina ede. ");
INSERT INTO swp_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Piripiri eo amamna se abigu, na oa em lauhesom ribadi egu nuawoiwoina ede. ");
INSERT INTO swp_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Oa em riba tabudi se dudurai i lau e nige nosina; sonoga bena oa u leama abo ea mauri. ");
INSERT INTO swp_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Egu amamna bena u italau arinai eo bena u lebohaigu, paana oa em laugagaeo taba nige ea nuahuiei. ");
INSERT INTO swp_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Enagu u toro, u ribasaguigu, eo u unehaigu, mauri u leama em ribahesunuma debana eai. ");
INSERT INTO swp_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Laulau gewagewa tataodi taba nige se mauri, paana oa em laugagaeo nige se eo’o eo’oidi. ");
INSERT INTO swp_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","GUIAU e, oa em nuatoatoa i lai ariri; em laulau dudurai debana eai bena mauri u leama. ");
INSERT INTO swp_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Tauheamamnagu eo tauhewaiunuegu se gamagari, na oa em riba tabudi taba nige ea lausuaraedi. ");
INSERT INTO swp_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","Isi nige se awamamohoiem ea italau aridi eai ma nua’itaitagu; paana oa em lauhesom nige se awamamohoiedi. ");
INSERT INTO swp_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Abo u nuatui komakomani em lauheata ribadi ea gadosisiedi! Egu mauri bena u ganaganai em gadosisi miatahitahina debana eai. ");
INSERT INTO swp_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Em riba maudoina mamohoina ede; eo em hesanapu ribadi duduraidi gamagaridi abo se otahai i lau e nige nosina. ");
INSERT INTO swp_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","GUIAU e, egu dou bena i saewa arim eai; sonoga u leama gonogonoana doha u ribaei wa! ");
INSERT INTO swp_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Egu awanori bena i saewa oa matam eai; u saguhaigu gonogonoana doha u ribaei wa! ");
INSERT INTO swp_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","Eau sopagu eai ea hedebasaem paana oa em lauhesom ribadi u heatagu. ");
INSERT INTO swp_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Eau memenagu eai em riba abo ea wanai, paana oa em lauhesom ribadi gamagaridi se dudurai. ");
INSERT INTO swp_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Oa nimam taba i nonoha i saguigu, paana oa em lauheata ribadi wa ea abi hineridio. ");
INSERT INTO swp_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","GUIAU e, oa em abihemauri ea gadohi aririei, eo em laugagaeo egu aba kode ede. ");
INSERT INTO swp_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Eau earuagu bena i mauri, abo ea hedebasaem, eo em hesanapu ribadi bena se saguigu. ");
INSERT INTO swp_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Eau ea laupono doha mamoe ie gege wa; em heaheari tauna taba u eo’oi, paana em lauhesom ribadi nige esau ea nuahuiei. ");
INSERT INTO swp_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","Egu nuadobidobi boeana eai ea eogalau GUIAU arinai, bena i heuioegu: ");
INSERT INTO swp_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","“Sopa borabora aridi eai eo memena borabora aridi eai, GUIAU e, bena oa u saguhaigu.” ");
INSERT INTO swp_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","Oa memena borabora e, saha abo se moseleawa arim eai, eo saha abo se ginauri enam? ");
INSERT INTO swp_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Tauiala ena pidu matamatana, ma oeagi alaalasina! ");
INSERT INTO swp_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Ahani eau, paana Meseka eai ea miamia, Kedara ena numa lulu hinage boeadi eai ea miamia! ");
INSERT INTO swp_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Ea abimatemate paana ea mia ariri isi boeadi eai labini se hewaiunuei. ");
INSERT INTO swp_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Eau labini mo ea henua; na ena ea ribariba, isi iala mo se henua. ");
INSERT INTO swp_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Eau matugu abo ea tusaei oea tupidi eai. Aba saguigu haedi eai abo i laoma? ");
INSERT INTO swp_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Aba saguigu GUIAU arinai i laoma, ia ede galewa eo tanoubu tauginauridi. ");
INSERT INTO swp_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Ia abo aem i itawatai, taba nige i moiu, ia tauitawataim wa, taba nige i eno. ");
INSERT INTO swp_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","U ita, Isaraela tauitawataina ia matana taba nige se enoeno, eo taba nige i enomate. ");
INSERT INTO swp_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","GUIAU ia tauitawataim ede; GUIAU ia ede em abaailogulogu oa nimatutum eai. ");
INSERT INTO swp_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Mahana gigiborina taba nige i talaim asubena eai, eo nawarai hinage maiona eai taba nige’e. ");
INSERT INTO swp_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","GUIAU abo i itawataim piripiri gamagaridi boeadi eai; em mauri abo i itawatai. ");
INSERT INTO swp_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Em pesa eo em awaseuio GUIAU abo i itawataidi, ina huia ta ie lau e nige nosina. ");
INSERT INTO swp_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","Ea kode ariri huiana eai wa se heribagu, si ene, “Ta awasaei GUIAU ena numa eai!” ");
INSERT INTO swp_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","Aemai wa se totoro oa em dobila abalusoradi eai, Ierusalema e! ");
INSERT INTO swp_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Ierusalema se hetoro doha eanua wasawasana numana se adidiri eo se toro patupatu, ");
INSERT INTO swp_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","boga gamagaridi se saesaewa, isi ede GUIAU ana bogaoyao, doha Isaraela se lauhesom wa, lautoi se mosei GUIAU esana eai. ");
INSERT INTO swp_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Nei eai aba hedudurai aba bawadi saesaedi se toredi, aba bawadi saesaedi wa Davida numana enana. ");
INSERT INTO swp_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Ierusalema enana au aiboda bena loni abina i ata! “Isi taugadosisiem bena se laulolo! ");
INSERT INTO swp_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Em gana alodi eai bena loni nei eai, em numa lailaidi alodi eai bena nuataru!” ");
INSERT INTO swp_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Egu tataoyao eo egu dodogayao debadi eai abo ea ribaei, ea ene, “Loni enamiu!” ");
INSERT INTO swp_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","GUIAU ema Eaubada ena numa debana eai, oa em lolo abo ea eo’o eo’oi. ");
INSERT INTO swp_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","Taba GUIAU ia nige eda tupo eai, ―Isaraela abo si ene― ");
INSERT INTO swp_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","2","taba GUIAU ia nige eda tupo eai huiana eai wa tatao abo se toro se ialaida, ");
INSERT INTO swp_vpl VALUES ("PS124_3","020_124_3","PSA","124","3","3","abotai taba ma maumaurida se domda, huiana eai wa se ouyalayala aririeda; ");
INSERT INTO swp_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","huiana eai ne abaita taba i earuhaida, goila lailai abo i earuhaida; ");
INSERT INTO swp_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","goila ena didi adidiri abo i earutawaida. ");
INSERT INTO swp_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","GUIAU bena ta ribatausaei, paana nige i moselaeda doha moadi edi aba aipurisi! ");
INSERT INTO swp_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Ta dago doha manu sa’i tauginaurina ena sa’i arinai; sa’i i tagoduo, to ta dago’o! ");
INSERT INTO swp_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Aba saguida ede GUIAU esana eai, ia galewa eo tanoubu tauginauridi. ");
INSERT INTO swp_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Huiana eai wa GUIAU Siona ena lolo i heharihariu, ita ada ao doha tau enosuai. ");
INSERT INTO swp_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Abo maruhi awada i hemonaudi, eo memenada eai ta wowo ma kodeda. Abo eanua headi taumiaidi si ene, “GUIAU ginauri lailaidi enadi i ginauridi.” ");
INSERT INTO swp_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","GUIAU ginauri lailaidi enada i ginauridi; arinai ta kode ariri. ");
INSERT INTO swp_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Ema dobila bena u heharihariudi, GUIAU e, doha goila se dididi Negeb barabarana eai! ");
INSERT INTO swp_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Tatao wa tuma se lauhesuru ma matasurudi abotai abo se tanogogo eo se wowo ma kodedi! ");
INSERT INTO swp_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Ia ma douna i torohai, tuma i bahei bena i hesuru, abo i uioma ena numa eai ie wowo ma kodena, nimana eai sitona augogodi i baheidima. ");
INSERT INTO swp_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Ena GUIAU numa wa nige i hetoro, isi tauhetorona se paisoa asaeai. Ena GUIAU ia eanua wasawasa nige i silawai, tau aisilawa i silawa asa. ");
INSERT INTO swp_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Nige aniona ena u enotoro heura, eo u eno boneawa, paisoa porohena aiaina mo ue ai; isi i gadosisiedi taba nige saha se deha. ");
INSERT INTO swp_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","U ita, merumeru tatao GUIAU ena ainauia ede, boga uauana ia ena ainauia. ");
INSERT INTO swp_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Doha pidu tauiala nimana eai hewari huiana nanatunayao doha ede. ");
INSERT INTO swp_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Tau wa ie kode taba ena aba aiusa i monau! Taba nige se hetaumaeamaea huiana eai wa ma ana waiunuyao aba hedudurai eai se hailobai. ");
INSERT INTO swp_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","GUIAU e, eau duha alona eai ea doulaowa arim eai! ");
INSERT INTO swp_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","Guiau e, arinagu u ataiei! Beam bena i tasoe egu aiboda daguguna arinai! ");
INSERT INTO swp_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","GUIAU e, ena oa laulau gewagewadi u nuatudidinidi, Guiau e, eai gonoana abo i toro? ");
INSERT INTO swp_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Na baaea ribagigirina ede oa arim eai i laoma, arinai oa mo matausim abo se matausi. ");
INSERT INTO swp_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Eau GUIAU ea bagibagiei, earuagu hinage ia i bagibagiei, eo ia ena riba arinai ea sunusunuma; ");
INSERT INTO swp_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Eau earuagu Guiau i bagibagiei doha isi tausilasilawa maratomtom taubagibagiena, eau mo ea hemuridi, doha isi tausilasilawa maratomtom taubagibagiena eau mo ea hemuridi. ");
INSERT INTO swp_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","Isaraela e, u sunumalau GUIAU arinai! Paana GUIAU arinai ede gadosisi miatahitahina, eo ena abihemauri i lai ariariri. ");
INSERT INTO swp_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Ia hinage abo Isaraela i unehemauri ena laulau gewagewadi gamagaridi aridi eai. ");
INSERT INTO swp_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","GUIAU e, bena Davida u nuatui ma nualolom, lauita oioiuradi gamagaridi i hearodi; ");
INSERT INTO swp_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","ie riba aigora GUIAU arinai eo i ribahesunuma Iakobo ena Eaubada Gigiborina arinai, ");
INSERT INTO swp_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","“Taba nige ea awasae egu numa eai eo taba nige ea lau egu abaeno eai; ");
INSERT INTO swp_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","taba nige matagu ea hegibudi, eo taba nige matagu se enoeno. ");
INSERT INTO swp_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","na GUIAU ena numa abahetorona ea eooi i lau e ea lobai. Iakobo ena Eaubada Gigiborina ena abamia.” ");
INSERT INTO swp_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Ai ataiei Eparata eai, ai lobai Ia’ara ena oea eai. ");
INSERT INTO swp_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","“I lolo ta lau ena aba mia eai; aena ana bou arinai ta tabaohu!” ");
INSERT INTO swp_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","U toro, GUIAU e, u lau em aba aiyawasi dimona eai, oa, eo em gigibori akena maem. ");
INSERT INTO swp_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Em kohena bena laulau dudurai se luidi, eo tatao tabudi abo se wowo ma kodedi, ");
INSERT INTO swp_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Em heaheari tauna Davida debana eai oa em heyausi tauna tabu u otaotaei. ");
INSERT INTO swp_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","GUIAU aigora mamohoina i aigoraei Davida arinai eo ena riba wa i ota esegai: “Oa natum tau esau, oa taum eai i laoma, abo ea hebawa em terona potana eai. ");
INSERT INTO swp_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","Taba nanatumyao tatao egu ribahesunuma se sogohididini eo egu riba tabudi ea heatadi wa hinage, isi nanatudiyao oa em terona potana eai abo se bawa i lau e huia nige nosina.” ");
INSERT INTO swp_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","Paana ede GUIAU Siona i abihineri, i gadohiei abo ena aba miahai: ");
INSERT INTO swp_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","“Inata ede egu aba aiyawasi i lau e huia nige nosina; inai abo ea miatahitahi, paana ea gadohiei. ");
INSERT INTO swp_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Ana aiai abo ea helai aririei; ena gogogesagesa tataodi aiai eai abo ea hebogasesedi. ");
INSERT INTO swp_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","Ena kohena mauri arinai abo ea heluidi, ena taumiatahitahi tataodi abo se wowo makodedi. ");
INSERT INTO swp_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","Nei eai abo dona esau ea he’ini Davida enana; lamepa ea abinonohai egu heyausi tauna enana. ");
INSERT INTO swp_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","Ana waiunuyao mo abo ea heluidi taumaeamaea arinai, na ia iabom uruna eai ena korona namanamarina abo i sina.” ");
INSERT INTO swp_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Babilonia goilana gegesidi eai, ai bawa na ai doudou, huiana eai wa Siona ai nuanuatui. ");
INSERT INTO swp_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","Oeagi lagadi eai ema huelele ai heabasidi. ");
INSERT INTO swp_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","Nei eai isi tauitawataimai se riba bena enadi ai wana, eo isi tauheamamnamai se riba bena ai kode, si ene, “Siona wanana enamai au wana!” ");
INSERT INTO swp_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","Edohana abo GUIAU ena wana hari eanua eai ai wanai? ");
INSERT INTO swp_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","Ierusalema e, ena ea nuahuiem, i lolo nimatutugu taba i wowoea! ");
INSERT INTO swp_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","I lolo memenagu i patu esegai awagu potana eai, ena taba nige ea nuanuatuim ena taba nige Ierusalema ea tore bagunai egu kode saesae aririna nuagu eai! ");
INSERT INTO swp_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","GUIAU e, Edoma tataodi edi laulau bena u nuanuatui nei asubena na eai ne Ierusalema se saetawatawai, si ene, “Ta hebaaea auri, ta hebaaea auri! I dobi e paa eai!” ");
INSERT INTO swp_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","Babilonia natuna sine e, oa ede tauhebahebaaea! Ia tauhemaisam wa abo nuana i kode gonogonoana doha oa u ginauri arimai eai wa! ");
INSERT INTO swp_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","Ia wa eai nanatumyao i abidi abo i kode hinage i hetamogorugorudi malamalatete potana eai. ");
INSERT INTO swp_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","GUIAU e, eau nuagu u eo’oiyao, eo abigu u ata’o! ");
INSERT INTO swp_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Egu bawa eo egu toro abidi u ata’o; oa eda lohaloha eai egu nuanuatu u italobaidio. ");
INSERT INTO swp_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Egu dobila u itahetaiiri, eo egu otadobi hinage, egu laulau gamagaridi abidi ue ata. ");
INSERT INTO swp_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Sora nige riba esau memenagu eai, na oa, GUIAU e, abina u ata heohiyao. ");
INSERT INTO swp_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Oa u bagubagunaegu, eo u murimuritaegu, eo oa nimam u toresaei eau potagu eai. ");
INSERT INTO swp_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Sonoga meta doha no’ona nige gonoagu; i sae ariri, eau taba nige ea lage arinai. ");
INSERT INTO swp_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Oa Earuam ea dagogabaei abo ea lau haedi? E oa matam abo edohana egu dagodagogabaena? ");
INSERT INTO swp_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Eau taba ea sae galewa eai, oa nei eai! Taba Hade eai egu eba ea wese na oa hinage nei eai! ");
INSERT INTO swp_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Taba maratomtom mabena ea abi abo ea loi ea lau gabogabo sigana eai ea mia, ");
INSERT INTO swp_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","nei eai hinage oa nimam abo i woeaigu, eo nimatutum abo i abididinigu. ");
INSERT INTO swp_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Ena ea ene, “Masigiri taba i bubulitawaigu, eo mara arigu eai i hemala maiona,” ");
INSERT INTO swp_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","taiede masigiri oa arim eai nige i masigiri, maiona ie mara doha asubena; paana masigiri gonogonoana doha mara oa matam eai. ");
INSERT INTO swp_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Taugu boeana oa u ginauri, sinagu bogana eai eaugu gamagaridi oa u hepatuesegaidi. ");
INSERT INTO swp_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Ea hedebasaem, paana oa u nuamatamatausi eo oa no’ono’om. Nimam ginauridi hinage no’ono’odi. Oa abigu u ata ariri! ");
INSERT INTO swp_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Taugu nige i otayamui oa arim eai, huiana wa eamuyamui eai se ginaurigu, tano boeana eai se ginauri komakomanigu. ");
INSERT INTO swp_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Bulumagu sora nige se ginauri, oa matam se itaguo; oa em buka eai egu asubena gamagaridi se uri nonohaidio, huiana eai wa sora nige se labasigu. ");
INSERT INTO swp_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","Oa em nuatu se sae ariariri, GUIAU e! Se gamagari ariariri hinage! ");
INSERT INTO swp_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Ena ea hasiridi gamagarina gelegele i dioi. Ena ea enotoro oa hinage gegesigu eai. ");
INSERT INTO swp_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","Eaubada e, taba laulau gewagewa tataodi u unuidi mo, taba taunimaosina tataodi hinage se torohaigabaegu, ");
INSERT INTO swp_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","tatao wa ma nuatu baabaaeadi se awayagalaem, baaea debana eai se oioipiriem! ");
INSERT INTO swp_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","GUIAU e, isi oa se hewaiunuem eau hinage ea hewaiunuedi e nige’e? Isi hinage oa se ialaim, eau hinage ea isugaraedi e nige’e? ");
INSERT INTO swp_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Hewaiunu mamohoina arinai ea hewaiunuedi; ea itadi isi hinage eau agu waiunuyao. ");
INSERT INTO swp_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Eaubada e, bena u itaheohigu, nuagu hinage abina u ata. U lauitagu eo egu nuanuatu bena abidi u ata. ");
INSERT INTO swp_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","U ita taba laulau baaea aisana eau arigu eai, eo dobila miatahitahina bena arinai u woeawoeaigu! ");
INSERT INTO swp_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","Egu Eaubada e, eo egu Wasawasa, oa abo ea hatoem, oa esam abo ea ribatausaei i lau e huia nige nosina. ");
INSERT INTO swp_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Asubena gamagari eau abo ea ribatausaem, oa esam ea aihelahui i lau e nige nosina. ");
INSERT INTO swp_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","GUIAU ia i sae ariri, ia hedebasaena ie lai, eo saesaena nige tau esau gonoana i eo’oi. ");
INSERT INTO swp_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Isi esau isi esau aridi eai am paisoa abo se hedebasaei, em gigibori laulaudi se ribahemasarahadi. ");
INSERT INTO swp_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Em wasawasa ana ao lolona eo em gigibori namanamarina, eau nuagu eai abo ea nuanuatuidi. ");
INSERT INTO swp_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Oa em laulau matamatausidi ma gigiboridi, tatao abo se ribahemasarahadi, eo em abiabi saesaedi abo ea guguiaei. ");
INSERT INTO swp_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Oa em abilolo saesaena wasana abo se ribaribaei, em laulau duduraidi abo se wanawanaidi. ");
INSERT INTO swp_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","GUIAU ena ainauia i lai ariri eo ena nuatoatoa hinage, ena ouyalayala nige i heula, ena gadosisi miatahitahina hinage i lai ariri. ");
INSERT INTO swp_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","GUIAU ena abi se lolo tatao gamagaridi aridi eai, eo ginauri gamagaridi ia i hetubudi meta i nuatoatoaedi. ");
INSERT INTO swp_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","GUIAU e, nimam ginauridi gamagaridi wa abo se lautoiem, em taumiatahitahi tataodi gamagaridi abo se ribatausaem! ");
INSERT INTO swp_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Em basileia namanamarina abo se ribaei, eo em gigibori hinage, ");
INSERT INTO swp_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","tatao nanatudiyao em gigibori laulaudi abo se heatadi, eo em basileia ena namanamari hinage. ");
INSERT INTO swp_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Oa em basileia miatahitahi basileiana, em tanutanuagaimai i laulau hari isi to hari isi. GUIAU ena riba gamagaridi i hemamohoiedi, eo ena nuatoatoa i laulau ena abiabi gamagaridi aridi eai. ");
INSERT INTO swp_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Taubeu gamagaridi GUIAU i abi’isinidi, eo tatao dageladi se eou i abihetorodi. ");
INSERT INTO swp_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Mata gamagaridi se italaowa oa arim eai, eo oa adi aiai taumosedi huiana mamohoina eai. ");
INSERT INTO swp_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Oa nimam ue ala, ginauri gamagaridi edi henuhenua u mosedi. ");
INSERT INTO swp_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","GUIAU ena laulau gamagaridi se dudurai, eo ena abi gamagaridi ma nuatoatoana. ");
INSERT INTO swp_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","GUIAU tatao gamagaridi taueogalau i hanahanau‐aririedi, isi wa mamohoina eai taueogalau. ");
INSERT INTO swp_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Ia tauheasisiena tataodi gamagaridi i itawataidi, edi dou hinage i ataiei, eo i hemauridi. ");
INSERT INTO swp_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","GUIAU taugadosisiena tataodi gamagaridi i itawataidi; na laulau gewagewa tataodi abo i unuheohidi. ");
INSERT INTO swp_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Awagu eai GUIAU hedebasaena abo ea ribaei, buluma eai tatao gamagaridi ia esana tabuna taba se ribatausaei, i lau e huia nige nosina. ");
INSERT INTO swp_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","GUIAU au hedebasaei! Earuagu e, GUIAU u hedebasaei! ");
INSERT INTO swp_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Eau GUIAU abo ea hedebasaei i lau e egu mauri sigana; sora ma maumaurigu GUIAU hedebasaena abo ea wanai. ");
INSERT INTO swp_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Wasawasa tabu au sunumaedi, tanoubu tauna hinage tabu au sunumaei, ia arinai nige aba haisagusagu. ");
INSERT INTO swp_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Ia eawasina ie ohi abo i uio i hemala tanouio; meta asubenana ne ena nuatu se lautom. ");
INSERT INTO swp_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Tau ne ie kode, ia wa tausaguina ede Iakobo ena Eaubada, ena sunuma ie tore GUIAU ena Eaubada arinai, ");
INSERT INTO swp_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","ia galewa eo tanoubu tauginauridi gabogabo hinage, ma ginauri gamagamagarina; ena riba i otaesegai i lau e nige nosina; ");
INSERT INTO swp_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","abidudurai i hemasaraha isi se heamamnadi aridi eai; eo tau guriguriam ia aiai adi i mosedi. Tatao auaudi GUIAU i eairihaidi se lau; ");
INSERT INTO swp_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","GUIAU matagibugibu tataodi matadi i helaladi. Tatao nuadi se porohe nuadi i hemamaradi; GUIAU laulau‐dudurai tataodi i gadosisiedi. ");
INSERT INTO swp_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Taulaolaoma tataodi GUIAU i itawataidi; wabuwabu eo dabudabure i abididinidi; na laulau gewagewa tauna ena dobila i hetatagorigori. ");
INSERT INTO swp_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","GUIAU ena wasawasa huiana i laulau e nige nosina, Siona e, em Eaubada ta, i lau e hari isi to hari isi. GUIAU au hedebasaei! ");
INSERT INTO swp_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","GUIAU au hedebasaei! Galewa eai GUIAU au hedebasaei: ewa inipuripuri eai au hedebasaei! ");
INSERT INTO swp_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","Aneru gamagarimiu ia au hedebasaei, ana tauiala tataomiu gamagarimiu, galewa tehana eai, ia au hedebasaei! ");
INSERT INTO swp_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","Mahana eo nawarai e, ia au hedebasaei, ipora namanamarimiu e, ia au hedebasaei! ");
INSERT INTO swp_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","Galewa ewapuripurina eai, ia au hedebasaei, eo goila hinage galewa ewana eai! ");
INSERT INTO swp_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","GUIAU esana taba isi se hedebasaei, paana ia ie riba arinai ede isi wa se tubu. ");
INSERT INTO swp_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","Ia i hetorodi i lau e, nige nosina, adi sigasiga laugagaeona ie tore, taba nige se dioi. ");
INSERT INTO swp_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","Tanoubu eai GUIAU au hedebasaei: omi gabogabo taumia nabunabutuadi, eo gabotum gamagarina hinage, ");
INSERT INTO swp_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","oeagi alaalasi, nabu tupitupina, snow eo madagau, mana lailai woworina ia ena riba se hemamohoiei! ");
INSERT INTO swp_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","Oea tupidi lailaidi eo gagiridi, oeagi uauadi, maruai oeagidi gamagaridi, ");
INSERT INTO swp_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","nuura saraidi eo bulumakau gamagaridi, ginauri se daladalausi eo manu loiloiusidi! ");
INSERT INTO swp_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","Tanoubu wasawasadi eo tatao gamagaridi, eanua guiaudi eo tanoubu tauheduhedudurai gamagaridi! ");
INSERT INTO swp_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","Hewari eo hasara gamagaridi maediyao, tautaubada eo merumeru! ");
INSERT INTO swp_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","Isi GUIAU esana bena se hedebasaei, paana iabom esana i sae ariri; ia ana tepo lolona tanoubu eo galewa i saetawatawaidi. ");
INSERT INTO swp_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Ia ena boda tataodi edi dona i lauisini, ena taumiatahitahi tataodi gamagaridi edi aba‐hedebasaena, Isaraela bodana isi ede ia gegesina eai wa. GUIAU au hedebasaei! ");
INSERT INTO swp_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","GUIAU au hedebasaei! Eaubada ena abamia tabuna eai bena ia au hedebasaei, ena galewa tehana gigiborina eai ia au hedebasaei! ");
INSERT INTO swp_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Ena laulau gigiboridi debadi eai ia au hedebasaei, ena gigibori saesae‐aririna debana eai ia au hedebasaei! ");
INSERT INTO swp_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Bogigi dagudaguguna eai ia au hedebasaei, huelele eo baubau aridi eai ia au hedebasaei! ");
INSERT INTO swp_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Boiatu eo saga aridi eai ia au hedebasaei, huelele au iuhi eo baubau au oioini aridi eai ia au hedebasaei! ");
INSERT INTO swp_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","Pate aridi eai ia au hedebasaei, pate au oihelaidi abo arinai ia au hedebasaei! ");
INSERT INTO swp_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Ginauri gamagaridi se eahueahua bena ia se hedebasaei! GUIAU au hedebasaei! ");
INSERT INTO swp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iesu Keriso, Davida natuna, ia urutubunayao bukana ede. ");
INSERT INTO swp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aberahama Isaako i hetubu, Isaako Iakobo i hetubu, Iakobo Iuda ma ena tataoyao i hetubudi. ");
INSERT INTO swp_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Na Iuda Peresa eo Sera i hetubudi, Tamara arinai i abidi, Peresa Heserona i hetubu, Heserona Rama i hetubu, ");
INSERT INTO swp_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Rama Aminadaba i hetubu, Aminadaba Nasona i hetubu, Nasona Salamona i hetubu, ");
INSERT INTO swp_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salamona Boasa i hetubu, Rahaba arinai ie abi, Boasa Obeda i hetubu, Ruta arinai ie abi, Obeda Iese i hetubu, ");
INSERT INTO swp_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","na Iese Davida i hetubu, ia ede wasawasa. Davida Solomona i hetubu, Uria monena arinai, ");
INSERT INTO swp_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomona Rehoboama i hetubu, Rehoboama Abia i hetubu, Abia Asa i hetubu, ");
INSERT INTO swp_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa Iosapata i hetubu, Iosapata Iorama i hetubu, Iorama Usia i hetubu, ");
INSERT INTO swp_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia Iotama i hetubu, Iotama Ahasa i hetubu, Ahasa Hesekia i hetubu, ");
INSERT INTO swp_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia Manase i hetubu, Manase Amona i hetubu, Amona Iosia i hetubu, ");
INSERT INTO swp_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Iosia Iekonia maena tataoyao i hetubudi, huiana se toaidi se laedi Babulonia eai. ");
INSERT INTO swp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babulonia eai se laedi wa, murina eai Iekonia Salatiela i hetubu, Salatiela Serubabela i hetubu, ");
INSERT INTO swp_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabela Abiuda i hetubu, Abiuda Eliakima i hetubu, Eliakima Asora i hetubu, ");
INSERT INTO swp_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asora Sadoka i hetubu, Sadoka Akima i hetubu, Akima Eliuda i hetubu, ");
INSERT INTO swp_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliuda Eleasara i hetubu, Eleasara Matana i hetubu, Matana Iakobo i hetubu, ");
INSERT INTO swp_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Iakobo Iosepa, Maria monena, i hetubu, arinai abo Iesu, esana Keriso, ie tubuma. ");
INSERT INTO swp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Isidi gamagaridi Aberahama i hetubudi i lau e Davida arinai, isidi saudoudoi‐hasi, eo Davida ena huia eai i lau e se toaidi se laedi Babulonia eai, isidi saudoudoi‐hasi hinage, eo se laedi Babulonia i lau e Keriso arinai, isidi saudoudoi‐hasi. ");
INSERT INTO swp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Keriso edi huia labasina eai doha ede ina: ia sinana Maria Iosepa sora nige i tawasorai, taudi labui sora nige se mia esega, Earua Tabuna ia i heabiabi. ");
INSERT INTO swp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Monena Iosepa ia tau‐laulaududuraina, nige i henua tatao Maria se ita, bena i torehesuarayamuyamui. ");
INSERT INTO swp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Na ena nuatu i nuatudadaasa, enosuai eai Guiau ena aneru i taumasaraha ia arinai i ene, “Iosepa, Davida natuna e, tabu u matausi Maria monem u bodai, na Earua Tabuna ia i heabiabi; ");
INSERT INTO swp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","abo i haisu, natuna tau abo i labasi, esana abo u tore Iesu, paana ede tatao, ia enanayao, edi baaea eai abo i hemauridi.” ");
INSERT INTO swp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Teina ginauri gamagaridi ta se tubu, bena Guiau ena riba, peroveta awana eai wa, abo i tubu, doha i ene: ");
INSERT INTO swp_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Hage au ita, hasara nuanuasupuna esau abo ie boga, abo hinage i haisu, natuna‐tau abo i labasi, esana abo se tore Emanuela,” (Is. 7.14) (heaheasonina ede ina, Eaubada maeda.) (Is. 7, 8, 10) ");
INSERT INTO swp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Iosepa eno eai i siliata, abo i toro aneru ena riba wa i lauwatai, monena i woeai, ");
INSERT INTO swp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","na sora nige i bodai i lau e natuna‐tau i labasi, abo esana ie tore Iesu. ");
INSERT INTO swp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Iesu se labasi wa Betelehema eai, Iudea eai, Heroda wasawasa ena huia eai, tatao sonoga headi tupo aruabu eai se laoma, Ierusalema eai se lage si ene: ");
INSERT INTO swp_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Iudea edi wasawasa se labasiyao ia ede haedi? Tupo aruabu eai ena ipola ai itayao, ai laoma ia bena ai aihelahui.” ");
INSERT INTO swp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Heroda wasawasa riba wa i ataiei aruana ie loi, eo Ierusalema gamagamagari maenayao; ");
INSERT INTO swp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ia kohena lailaidi eo tatao edi tau‐uriuri gamagamagari i heoigogoidi i hetalaidi, Keriso haedi eai abo se labasi. ");
INSERT INTO swp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ia se heriba si ene, “Betelehema eai, Iudea eai, paana peroveta esau ie uri ina doha: ");
INSERT INTO swp_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Na oa Betelehema e, Iuda oeana eai ta, nige u gagiri ariri wasawasa Iuda aridi eai, paana ede oa guaguam eai Tanuaga abo i laoma, egu tataoyao Isaraela abo i tanuagaidi.’” (Mi. 5.2) ");
INSERT INTO swp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Heroda sonoga tataodi wa abo i eogamahimahihiedima, ipola edi huia itana wa i oimurikomakomanidi; ");
INSERT INTO swp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","abo i hetamaridi se lau Betelehema, i ene, “Au lau kaimou wa au eooi komakomani, ena au lobai au uioma au heribagu, abo hinage ea lau ia ea aihelahui.” ");
INSERT INTO swp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Wasawasa arinana se ataiei nonohai, abo se lau ipola wa tupo aruabu eai se ita wa, i eda‐bagunaedi, i lau e kaimou wa ena abamia potana eai i alasi. ");
INSERT INTO swp_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Isi ipola wa se ita abo se kode, se kode ariariri; ");
INSERT INTO swp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","na se lage numa alona eai, kaimou wa se ita, ma sinana Maria, arinai se tabaohu‐dobi ia se aihelahui. Edi ginauri se abihemasarahadi ia se ainauiai, gold, eo muramurapanepane, eo muro. ");
INSERT INTO swp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Enosuai eai Eaubada i ribahesanapuedi tabu se uio Heroda arinai, to se uio edi eanua hari dobila eai. ");
INSERT INTO swp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Isi se lauo, na aneru enosuai eai i taumasaraha Iosepa arinai i ene, “U torohai, kaimou me ma sinana u laedi, u dagoedi Aigupito eai, nei eai au mai i lau e abo ea heribam; paana Heroda kaimou me i eooi bena i unui.” ");
INSERT INTO swp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ia abo i torohai, kaimou ma sinana maiona eai i woeaidi, i laedi Aigupito eai, ");
INSERT INTO swp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","nei eai se mia i lau e Heroda ie mate. Arinai Guiau ena riba i ribaei wa peroveta awana eai, abo se hemamohoiei, si ene, “Aigupito eai natugu‐tau ea eogaiyama ede.” ");
INSERT INTO swp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Heroda abo i nuatu‐lobai, tatao sonoga omi‐hede se borai, abo i ouyalayala ariri, tatao headi i hetamaridi se lau Betelehema eo se tauhetaiiri, merumeru‐tatao gagiridi se unuidi, isi edi borimai labui, eo gamagaridi hinage edi borimai sora nige se helabui, lahinai i oimuri komakomani wa tatao sonoga aridi eai. ");
INSERT INTO swp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Abotai riba wa peroveta Ieremia i ribaei wa, se hemamohoiei, doha i ene: ");
INSERT INTO swp_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama, eanuana eai dou gurumoana ie sae, se ataiei, Rahela nanatunayao doudi ie dou, ia taba nige nuana i biga paana se tauyamui‐aririo.” (Iere 31.15) ");
INSERT INTO swp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Na huiana Heroda i mateo, Guiau ena aneru Iosepa enosuai eai i taumasaraha, Aigupito eai, i ene, ");
INSERT INTO swp_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“U torohai, gama gagirina me ma sinana u woeauioidi u laedi Isaraela oeana eai, isi gama gagirina se eooi bena se unui wa se mateo.” ");
INSERT INTO swp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ia abo i torohai, gama gagirina wa ma sinana i woeaidi Isaraela oeana eai se laoma. ");
INSERT INTO swp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ia wasa i ataiei Arekelao, Heroda natuna, tamana i helaudamai, ia ede wasawasa Iudea eai, bena i uio nei eai na i matausi; abo Eaubada enosuai eai i ribahesanapuei, arinai i lausuara Galilaia tehana eai. ");
INSERT INTO swp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ia abo i lage eanua esana Nasareta, arinai se mia, arinai ede peroveta edi riba esau se hemamohoiei, doha si ene, “Ia abo se ribaei Nasanasareta.” ");
INSERT INTO swp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nei asubenadi ne Ioane Bapatiso i laoma, Iudea barbarana eai i laulauguguia, ");
INSERT INTO swp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ena ribariba i ene, “Nuamiu au buidi, galewa basileiana i hanahanaumao.” ");
INSERT INTO swp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ia ede teina Isaia peroveta ie ribaei wa i ene: “Esau arinana barabara eai i eogaeoga, i ene, Guiau ena eda au abihetoanonohai, ena dobila au heduduraidi.” (Is. 40.3.) ");
INSERT INTO swp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ioane ana lulu kamela wuiana, ana auduaduari sarai opina ie lio; ana aiai madimadi eo amoamo nuura eai se lobai. ");
INSERT INTO swp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ierusalema tataodi eo Iudea tataodi gamagamagari se lau ia arinai, eo Ioridano hasarina taumiaidi hinage, ");
INSERT INTO swp_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","na Ioridano sagana eai ia i bapatisoidi, isi edi baaea se ribahemasarahadi. ");
INSERT INTO swp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ia abo Parisea eo Sadukea gamagaridi i itadi ena bapatiso hesabana se laoma, i ribalau aridi eai i ene, “Mota nanatudiyao e! Eai i heribanonohaimiuo ouyalayala i laolaoma bena au dagoei me? ");
INSERT INTO swp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nuabui uauana au hemasarahadi, ");
INSERT INTO swp_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","na tabu emi nuatu ina doha au ene, ‘Aberahama ai tamamai ede’; ea heribamiu Eaubada abina i ata ina we’u eai ta Aberahama nanatunayao i hetubudi. ");
INSERT INTO swp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Abo‐ina ilama se toreyao oeagi paadi eai, oeagi gamagaridi uadi nige se lolo abo se oiheguridi, se gabalaedi oeagi alaalasina boena eai. ");
INSERT INTO swp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Mamohoi eau goila eai ea hebapatisoimiu ta emi nuabui eai, na ia murigu eai i laoma ia mo i sae ariri ede, eau nige ea lolo ia ena ae‐um ea baheidi; ia Earua Tabuna ma‐alaalasina arinai abo i hebapatisoimiu. ");
INSERT INTO swp_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ena tapitapi nimana eai, ena sitona ena aba‐tapitapi matuna abo i tapitapi komakomani, sitona aiaina abo i tanogogoi i tore ena sanara eai, wenudi wa abo i gabu oeagi alaalasina eai, i lau e nige nosina.” ");
INSERT INTO swp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Iesu abotai Galilaia eai i laoma Ioridano eai, Ioane arinai, ia bena i hebapatisoi. ");
INSERT INTO swp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ioane bena i ribanuahi, i ene, “I lolo taba oa mo u hebapatisoigu, u laoma arigu eai, wa?” ");
INSERT INTO swp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Na Iesu ena riba i heuio i ene, “Taiede ta lauwatai; i lolo bena laulau dudurai gamagamagari ta abi‐heohidi.” Arinai abo ie eari. ");
INSERT INTO swp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Iesu se hebapatiso‐nonohaiyao, ma‐esega goila eai i gaeosaema, galewa abo i taigari ia matana eai, Eaubada ena Earua ie ita i dobima doha bunebune, ie toa ia potana eai; ");
INSERT INTO swp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","arina esau galewa eai i ribama, i ene, “Natuyogoyogoigu ede ina, ia arinai nuagu i lolo ariri.” ");
INSERT INTO swp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Earua Iesu abo i woeai barabara eai, diabolo ia bena i nohoi. ");
INSERT INTO swp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Asubena tatao‐labui‐se‐mate eo maiona tatao‐labui‐se‐mate i aiudi, abo i guriam. ");
INSERT INTO swp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Taunoho wa abo i laoma ia arinai i ene, “Ena oa Eaubada Natuna, teina we’u ta u heribadi abo se hemala areto.” ");
INSERT INTO swp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","I ribalau i ene, “Se uriyao si ene, ‘Tau taba nige areto eai mo i mauri, na riba gamagamagari eai hinage Eaubada awana eai se laoma.’” (Deu. 8.3). ");
INSERT INTO swp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Diabolo ia abo i woeai i laei eanua tabuna eai, i hetoro dubu lailai isu saesaena eai, ");
INSERT INTO swp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","abo i heriba i ene, “Ena oa Eaubada Natuna, hage u gabodobem; doha se uriyao si ene, ‘Ena aneru i hetorodi se itawataim;’ eo ‘Nimadi eai abo se abiisinim, ata aem u hetupanei we’u eai.’” ");
INSERT INTO swp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Iesu abo i ribalau i ene, “Hinage se uriyao si ene, ‘Guiau em Eaubada tabu u nohoi.’” ");
INSERT INTO swp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Hinage diabolo ia abo i woeai i laei oea tupi lohaloha‐aririna eai, tanoubu basileia gamagamagari ia i heita, itaitadi se lolo ariri; ");
INSERT INTO swp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","na i heriba i ene, “Teina ginauri gamagamagari ta abo ea lediwa, ena u tabaohuiguma, u aihelahuigu.” ");
INSERT INTO swp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Iesu abo i ribalau ia arinai i ene, “Satani e, u lausuara! se uriyao si ene, ‘Guiau em Eaubada iabom taba u aihelahui mo, ia iabom u heaeaiei ede.’” ");
INSERT INTO swp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Arinai abo diabolo ia i laugabaei, abotai aneru se laoma se bobodiei. ");
INSERT INTO swp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Iesu wasa i ataiei Ioane se toai se laei numamasigiri eai, abo i torohai i lau Galilaia; ");
INSERT INTO swp_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nasareta i laugabaei i laoma Kaperanauma eai ie mia, gabogabo hasarina eai, Sebulona eo Napatali edi oea sigasigadi eai, ");
INSERT INTO swp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","bena riba Isaia peroveta i ribaei abo se lauhetubu, i ene ina doha: ");
INSERT INTO swp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulona oeana eo Napatali oeana, teha gabogabo, Ioridano hari tehana eai, Galilaia, Murimuri‐tataodi enadi wa: ");
INSERT INTO swp_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","tatao, masigiri boeana eai se babawa, marana lailai se ita, isi hinage mate tehana eai se bawa, eo mate loguloguna eai, aridi eai mara i iuyari.” ");
INSERT INTO swp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nei huiana ne Iesu i lauguguia hetubu, i ene, “Nuamiu au buidi, paana galewa basileiana ede i hanahanaumao.” ");
INSERT INTO swp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iesu i tautausi Galilaia gabogabona hasarina eai, tataoyao labui i itadi, esau Simona, iaede esana se ribaei Petero, eo ena tau Anederea, hiana se galaei gabogabo eai; paana isi tauyamayama. ");
INSERT INTO swp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","I heribadi i ene, “Au hemuriwataiguma, abo ea hetoromiu au hemala tauyama, tatao abo au aitoa.” ");
INSERT INTO swp_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Maesega edi hiana se laugabaedi, ia se lauwatai. ");
INSERT INTO swp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Abo i laulau e, tau esau maena doga ie itadi, Iamesi Sebedaio natuna, eo ena tau Ioane, taudi labui ma tamadi, isi waga eai, edi hiana se eoma, na i eogaidi. ");
INSERT INTO swp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Maesega edi waga eo tamadi wa se laugabaedi, ia se lauwatai. ");
INSERT INTO swp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iesu Galilaia i lauhetaiiri, edi sunago alodi eai i laulauheata, basileia evaneliana i lauguguiai, tauaiaiiwala gamagamagari hinage tatao boeadi eai, i hemauridi. ");
INSERT INTO swp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Arinai ia wasana i tadada i lau e Suria i hetaiiri, tau‐asiasiebo gamagamagari, eo headi hari iwala, hari amamna, se hearodi se woeaidima ia arinai to i hemauridi. ");
INSERT INTO swp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Moutuadi lailai ia se lauwatai, Galilaia eai se laoma, eo Ierusalema hinage, eo Iudea, eo Ioridano hari teha eai. ");
INSERT INTO swp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Moutuadi wa i itadi, i dalasae oea, eai i bawabigabiga ena heaheatayao abo se laoma ia arinai. ");
INSERT INTO swp_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Awana i dabari i heatadi, i ene: ");
INSERT INTO swp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Tatao se nuatudobidobiuiodi nuadi abo se kode, galewa basileiana isi enadi. ");
INSERT INTO swp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Isi taunuanuadubu nuadi abo se kode paana ede abo se henuabigadi. ");
INSERT INTO swp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Tatao iila‐lolololodi nuadi abo se kode tanoubu abo se abi enadi. ");
INSERT INTO swp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Isi laulau‐dudurai arinai se guriam eo gadodi se magu, nuadi abo se kode, abo bogadi se sese. ");
INSERT INTO swp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Isi taunuatoatoa nuadi abo se kode, paana ede isi hinage abo se nuatoatoaidi. ");
INSERT INTO swp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Isi tau‐nua’aa’aa nuadi abo se kode, isi Eaubada abo se ita. ");
INSERT INTO swp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Isi taulaulaubiri nuadi abo se kode, isi abo esadi se ribaedi Eaubada nanatunayao. ");
INSERT INTO swp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Isi laulau dudurai debana eai se hebaaeadi, nuadi abo se kode galewa basileiana isi enadi. ");
INSERT INTO swp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Taba tatao se isugaraemiu, eo se hebaaeamiu eo wasamiu gamagaridi se hebaaeadi, se bora‐auridi, eau debagu eai, nuamiu abo se kode. ");
INSERT INTO swp_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Au kode, abo au kode ariri, emi maisa galewa eai ie lai, peroveta se mugamugaiemiu, isi hinage se hebaaeadi doha nei. ");
INSERT INTO swp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Omi tanoubu aritana; na taba arita i gouai edoha ena heahearitana? Abo nige ana abi, se gabaei mo, tatao abo se ututawatawai. ");
INSERT INTO swp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Omi tanoubu marana. Eanua oea tupina eai se hetoro taba nige i tauyamui. ");
INSERT INTO swp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Hinage lamepa nige se healasi abo gulewa eai se hebuitawai, se tore lamepa ena aba‐ota eai, abo tatao gamagaridi numa alona eai i hemaradi. ");
INSERT INTO swp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Hinage doha emi mara au hesinadi tatao matadi eai, emi abi lolodi se itadi arinai abo Tamamiu galewa eai se hedebasaei. ");
INSERT INTO swp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Tabu emi nuatu au ene ea laoma ta laugagaeo eo peroveta ea hebaaeadi; nige ea laoma ta ea hebaaeadi, ea hemamohoiedi mo. ");
INSERT INTO swp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mamohoi ea heribamiu ta, galewa eo tanoubu abo se lautom, iota esau eo riba gagiri‐konekonena esau laugagaeo eai, taba nige se lautom, i lau e ginauri gamagamagari so hemamohoiheohidi. ");
INSERT INTO swp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ena tau esau teina laugagaeo ta gagirina esega i utusi, eo tatao i heatadi se utusi, ia abo se ribadobedobei galewa basileiana eai; na ena tau esau i lauwataidi eo i heatadi, ia abo se riba‐tausaei galewa basileiana eai. ");
INSERT INTO swp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ea heribamiu ta ena emi laulau dudurai, tau‐uriuri eo Parisea edi laulau dudurai nige se hemuridi, taba nige au lusora galewa basileiana eai. ");
INSERT INTO swp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Au ataieyao tatao mumuga eai wa se heribadi si ene, ‘Tabu u aiunu; (Exod. 20.13) taba esa, esa i aiunu se laei aba‐hekiraino eai.’ ");
INSERT INTO swp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Eau ea heribamiu ea ene taba esa, esa ena tau esau i ouyalayalaei mo, ia hinage taba se laei aba‐hekiraino eai; eo esa, esa ena tau i riba‐hebaaeaei, ia taba se laei Sunederi matadi eai, eo esa, esa i ene, ‘Yauyaurem!’ ia taba Gehena alaalasina i matausiei. ");
INSERT INTO swp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ena taba em ainauia u peiauri dubu hatahatana tabuna eai, arinai abo nuam i sae eham esau u hebaaea, ");
INSERT INTO swp_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","em ainauia wa ue tore hatahata tabuna nuanuana eai, sora u laugabaei, u lau ma‐eham au hainuabiga baguna, abotai abo u laoma em ainauia u mose. ");
INSERT INTO swp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Em tau u heyalaei wa maidam au hainuabiga heuheula, sora dobila eai taumi labui au laulau esega lauhetala hesabana; ata em tau u heyalaei wa i laem tauhedudurai arinai, tauhedudurai abo i mosem tauitaitawata arinai, oa abo se tutuguduim. ");
INSERT INTO swp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mamohoi ea heribam ta, taba nige u lulagema i lau e sora em pene u hemaisaheohidi. ");
INSERT INTO swp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Au ataieyao tatao mumuga eai si ene, ‘Tabu u ganaganawari.’ (Exod. 20.14). ");
INSERT INTO swp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Na eau ea heribamiu ta ea ene taba tau esau sine esau i italau i lelehiei, ia nuana eai i ganawario. ");
INSERT INTO swp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ena mata tutum i hegurim u lamohai, u gabahesuara; i lolo matam esega u hebaaea, ata ma‐taum i ohihai abo se gabalaem Gehena eai. ");
INSERT INTO swp_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ena nima tutum i hegurim u tomgabaei; i lolo nimam esega u hebaaea, ata ma‐taum i ohihai abo se gabadobem Gehena eai. ");
INSERT INTO swp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Hinage si ene, ‘taba esa, esa monena i gegebiei, abo ena inawase pepana i mosei.’ (Deu. 24.1) ");
INSERT INTO swp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Na eau ea heribamiu ta ea ene, ena tau esau monena i gegebiei, sine wa nige i ganaganawari, arinai abo sine wa i heganaganawari; eo esa, esa sine se gegebiei wa i tawasorai, ia hinage abo i ganaganawari. ");
INSERT INTO swp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Hinage au ataieyao isi mumuga tataodi si ene, ‘Tabu au aigora borabora, (Exod. 20.7) na emi aigora Guiau arinai abo au hemamohoiei’, ");
INSERT INTO swp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Na eau ea heribamiu ta ea ene, Tabu au aigora, tabu galewa arinai, Eaubada ena terona meta, ");
INSERT INTO swp_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","tabu tanoubu arinai, aena ana bou meta, tabu Ierusalema arinai, wasawasa lailai ena eanua meta. ");
INSERT INTO swp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tabu u aigora urum arinai, nige abina u ata maiawana esega u heposiposi e u hedubaduba. ");
INSERT INTO swp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Em riba u ribaei mo u ene ‘E, E, e Nige’e, Nige’e,’ ina u helaidi ede baaea arinai i tubuma. ");
INSERT INTO swp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Au ataieyao isi si ene, ‘Mata helena mata maisana, mo’a helena mo’a maisana;’ (Ex. 21.24) ");
INSERT INTO swp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Na eau ea heribamiu ta ea ene, tau baaea i hebaaeam tabu u hemaisa; esa eo esa parea‐tutum ie wai, u sinibui parea esau hinage u mosei; ");
INSERT INTO swp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ena tau esau i woeaim tauhedudurai matana eai em pereue bena i abi, em pereue lohaloha u mosei hinage; ");
INSERT INTO swp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","taba esau i hetaladuim i ene u laoma ta lau maila esega, besi maila labui maem au lau. ");
INSERT INTO swp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tau esau saha i aiboda arim eai u mosei, esau saha bena i sagenai tabu u otaotaei. ");
INSERT INTO swp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Au ataieyao si ene, ‘Helem‐taumia u gadosisiei (Lev. 19.18) na em waiunu u aiouei.’ ");
INSERT INTO swp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ea heribamiu ta ea ene, Emi waiunu au gadosisiedi, isi se hebaaeamiu; eo se heamamnamiu, enadi au lau‐uura, ");
INSERT INTO swp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","arinai abo Tamamiu galewa eai nanatunayao omi; ena mahana i hesina tatao baaea eo tatao lolo potadi eai, eo nabu i hetaru taulaulau‐dudurai eo taulaulaugewagewa potadi eai. ");
INSERT INTO swp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Taba taugadosisiemiu mo au gadosisiedi, emi lolo saha? Telona tataodi meta doha se abi, e nige’e? ");
INSERT INTO swp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Taba ehamiuyao mo au aitoiedi, edohana tatao headi au hemuridi? Murimuri‐tataodi isi hinage se abi doha nei, e nige’e? ");
INSERT INTO swp_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Omi bena au lolo‐esegaimiu, doha Tamamiu galewa eai i lolodumaduma. ");
INSERT INTO swp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Au komanimiu emi laulau duduraidi nige au abidi tatao matadi eai, bena se itamiu; ata nige maisana au abi Tamamiu galewa eai wa arinai. ");
INSERT INTO swp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Em ainauia u mosei, tabu bogigi u iuhi nonohai, doha tatao borabora sunago alodi eai, eo dobiladi eai, bena tatao se itadi eo se hedebasaedi. Mamohoi ea heribamiu ta, isi maisana se abiyao. ");
INSERT INTO swp_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Na oa taba u ainauia, nima‐tutum ena abiabi tabu nima‐seuseurim i ita, ");
INSERT INTO swp_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","arinai em ainauia abo u mosemodigaui; Tamam i ita‐modigauiyao ia abo i hemaisa. ");
INSERT INTO swp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ena u uura hinage, tabu oa doha tatao borabora; paana isi edi gadosisi bena se totoro se uura sunago alodi eai, eo dobila konadi eai, tatao bena se itadi. Mamohoi ea heribamiu ta, isi maisadi se abiyao. ");
INSERT INTO swp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Na oa ena u lau‐uura, u lulau em biriutusi alona eai, dobila abo u gudu, u lau‐uura Tamam i mia‐modigau arinai; eo Tamam i ita‐modigaui, abo i ainauiaim. ");
INSERT INTO swp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Au laulau‐uura wa, tabu riba nige aniodi au ribaedi mo, doha hinage Murimuri tataodi; isi edi nuatu si ene riba se hegamagari abo se ataiei. ");
INSERT INTO swp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Omi tabu doha isi, sora nige au aiboda, Tamamiu i nuatuiyao abi saha, abi saha lolodi bena au abidi. ");
INSERT INTO swp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Ina doha au uura, au ene: Tamamai e, galewa eai, Esam se hetabuei, ");
INSERT INTO swp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Em basileia bena i laoma, Em nuatu tanoubu eai ta bena se lauwatai Doha galewa eai laulauna, ");
INSERT INTO swp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Aiai ama wau‐ta u leama; ");
INSERT INTO swp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ema baaea u nuatugabaedi, Doha hinage ai, tauhebaaeamai edi baaea ai nuatugabaedi; ");
INSERT INTO swp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ena noho ai hearo tabu u hesagugabaemai, Na baaea eai mo u hesaguhaimai. (Basileiana enam, gigiborina enam, tepo saesaena enam, ana huia, ana tasi, Amen.) ");
INSERT INTO swp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ena tatao edi baaea au ribagigiridi, Tamamiu galewa eai omi emi baaea abo hinage i ribagigiridi; ");
INSERT INTO swp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ena tatao edi baaea nige au ribagigiridi, Tamamiu omi emi baaea hinage taba nige i ribagigiridi. ");
INSERT INTO swp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Hinage taba au aiudi tabu omi doha tatao borabora matadi se welawelai, adi ao hinage se hebaaeadi, tatao, bena se itadi se aiudi. Mamohoi ea heribamiu ta, edi ainauia se abiyao. ");
INSERT INTO swp_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Na oa taba u aiudi, urum u heyausi, u mata bui hinage, ");
INSERT INTO swp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tatao taba nige bena se itam u aiudi wa, Tamam iabom ena abamiamodigau eai bena i itam; Tamam wa i itamodigaui abo i ainauiaim. ");
INSERT INTO swp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Emi gogo tabu au peigogoidi tanoubu eai ta, inai manumanu eo masi abo se hebaaeadi, eo tauaiaiyahari se lopa abo se aiyahari, ");
INSERT INTO swp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","na emi gogo galewa eai mo au peigogoidi, nei eai manumanu eo masi nige se hebaaeadi, eo hinage tauaiaiyahari nige se lopa se aiyahari. ");
INSERT INTO swp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Emi gogo abatoredi ede, nuamiu abo hinage nei eai. ");
INSERT INTO swp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Tauda lampana ede mata. Arinai ena matam i lau dudurai esega, taum i ohihai abo i mara gudui; ");
INSERT INTO swp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","taba matam i baaea, taum i ohihai abo i masigiri gudui. Taba marana boeam eai i masigiri, abo i masigiri dumaduma meta! ");
INSERT INTO swp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Nige tau esau abo tanuaga labui i heaeaiedi; esau abo i hewaiunuei, esau i gadosisiei, e esau i nuatuaririei, esau i isuewaei. Eaubada eo mamona taba nige au heaeai‐esegaidi. ");
INSERT INTO swp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Arinai ede ea heribamiu ta, tabu maurimiu au nuatudaoiei, saha abo au ai, saha abo au nom, saha abo au lui. Mauri mo i sae, aiai nige’e, tau hinage i sae, lulu nige’e, wa? ");
INSERT INTO swp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Galewa manudi hage au itadi: nige adi se uma, nige se lau‐oea, eo nige edi sanara, taiede Tamamiu galewa eai i heaidi. Omi isi au saetawatawaidi, e nige’e? ");
INSERT INTO swp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Omi esau taba i nuatudaoi, eai abo ena mauri huiana i heloha kubita esega? ");
INSERT INTO swp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Eo saha lulu au nuatudaoiei? Oea baiobaiodi hage au nuatuidi, isi nige se paisoa, nige se lulu‐haturi; ");
INSERT INTO swp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","hinage ea heribamiu ta, Solomona ana pasa lolodi eai ana ao nige i lolo doha hinage isi. ");
INSERT INTO swp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Taba Eaubada ina doha oea leidi i heluidi, wau ie ota, maraitom se gabu um boeana eai, omi abo nige i heluimiu wa, sunuma gagiri tataomiu e? ");
INSERT INTO swp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Arinai ede tabu emi nua‐mode au ene, ‘Saha abo ai aidi?’ e ‘Saha abo ai nomdi?’ e ‘Saha abo ai luidi?’ ");
INSERT INTO swp_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Teina ginauri gamagamagari ta Murimuri‐tataodi se eooyooidi ede; Tamamiu galewa eai i itayao teina ginauri gamagamagari ta nige au abidi. ");
INSERT INTO swp_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Na Eaubada ena basileia au eoobagunai, eo ena laulau‐duduraina hinage, abotai abo wau ginauri gamagaridi wa se heoiesegaidiwa. ");
INSERT INTO swp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Tabu maraitom enana u modei, sora maraitom iabom enana abo gonoana, maraitom ena baaea saha maraitom abo u nuatui. ");
INSERT INTO swp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Tabu u hegihegiru, ata oa hinage se hegirum. ");
INSERT INTO swp_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Giru wa arinai u hegiru arinai oa abo hinage se hegirum, eo nonoi wa arinai u nonoiei abo hinage se nonoiyawa arim eai. ");
INSERT INTO swp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ue saha muari u ita em tau matana eai, na oeagi oa matam eai nige u nuatui? ");
INSERT INTO swp_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Hinage edoha em ribariba em tau arinai u ene, ‘Muari matam eai me bena ea abihai,’ na oeagi sora oa matam eai ie ota? ");
INSERT INTO swp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Oa tauboraborasom, oeagi oa matam boeana eai u abihai bagunai, arinai abo u ita‐loloei em tau matana muarina abo u abihai. ");
INSERT INTO swp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ginauri tabuna tabu u mosei kedewa aridi eai, hinage tabu em giniuba matamatapoudi u gabaedi sarai aridi eai, ata aedi eai, se utu‐tawatawaidi, abo se sinibui se letaim. ");
INSERT INTO swp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“U aiboda, abo se leawa; u eoo, abo u lobai; u ipeipesi, dobila guduna abo se soeawa. ");
INSERT INTO swp_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Paana ia i aiaiboda abo i abi, eo ia i eoo abo i lobai, eo ia i ipeipesi ia arinai abo se soe. ");
INSERT INTO swp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Aitea tau arimiu eai, taba natuna falawa i aiboda, we’u abo i mosei, wa? ");
INSERT INTO swp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Taba eama i aiboda, mota abo i mosei? ");
INSERT INTO swp_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Taba omi, baaea tataomiuyao, abidi au atao ainauia lolodi au mosedi nanatumiuyao aridi eai, Tamamiu galewa eai iabom ginauri lolodi abo i mosei tauaiaiboda aridi eai, e nige’e? ");
INSERT INTO swp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Abiabidi gamagamagari u henua tatao se abidi arim eai, doha nei hinage u abidi isi aridi eai; teina ta laugagaeo eo peroveta ribadi ede. ");
INSERT INTO swp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Au lusoralau dobila gagirina arinai; paana dobila sorasorana ie lai, eo edana i magaga i lau e mate arinai, tatao gamagaridi abo se lulagelau arinai. ");
INSERT INTO swp_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Paana ede abalusoralauna i ahiahi, eo eda sausauaina mo i lau e mauri arinai, tatao hisahisawaidi mo se lobai. ");
INSERT INTO swp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Peroveta borabora au komanidi, se laowa arimiu eai adi lulu mamoe uiadi, boeadi eai doha luko aiailetadi. ");
INSERT INTO swp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Uauadi arinai abo au italobaidi. Malanurinuri eai tatao abo vine se abidi wa? eo popohauhau eai abo kuhou hinage se gigidi, wa? ");
INSERT INTO swp_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Iaede, oeagi lolodi uaua lolodi se toredi, na oeagi baaeadi uaua baaeadi se toredi. ");
INSERT INTO swp_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Oeagi lolona uaua baaeana taba nige i tore, oeagi baaeana hinage uaua lolona taba nige i tore. ");
INSERT INTO swp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Oeagi gamagaridi esau eo esau uaua lolodi nige se toredi se oiheguridi, abo se gabalaedi oeagi alaalasina boeana eai. ");
INSERT INTO swp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Arinai ede, uauadi eai abo au italobaidi. ");
INSERT INTO swp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Isi gamagaridi arigu eai si ene, ‘Guiau e, Guiau e,’ headi taba nige se lusora galewa basileiana eai, na iabom mo Tamagu galewa eai i mia ena nuatu i ginauriwatai. ");
INSERT INTO swp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nei asubenana ne gamagaridi abo se ribalaoma arigu eai si ene, ‘Guiau e, Guiau e, ai ede esam eai ai riba‐peroveta e nige’e, wa? Esam eai demoni ai aiduiedi e nige’e, wa? Esam eai laulau gigiboridi ai ginauridi e nige’e, wa?’ ");
INSERT INTO swp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Abo ea riba masaraha aridi eai ea ene, ‘Eau ea hekaumiu; omi baaea tauabidi, au lausuaraegu.’ ");
INSERT INTO swp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Esa eo esa teina egu riba ta i ataiedi, eo i lauwataidi, ea ene ia doha tausonosonogana esau, ena numa malamalatete potana eai i hetoro; ");
INSERT INTO swp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","nabu abo ie taru, eo abaita ie didi, eo mana ie toa, numa wa ie eai, nige i guri, paana ede malamalatete potana eai se hetoro. ");
INSERT INTO swp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Esa eo esa teina egu riba ta i ataiedi, eo nige i lauwataidi, abo se heaheasoniei ia tauyauyaurena, ena numa malageregere eai mo i hetoro; ");
INSERT INTO swp_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","nabu abo ie taru, eo abaita ie didi, eo mana ie toa, numa wa ie eai, abo ie guri; i tatagorigori ariri.” ");
INSERT INTO swp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iesu teina riba ta i riba lautom, tatao ena guguia se nooei, ");
INSERT INTO swp_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","paana ede i heatadi ena riba ma gigiborina, nige doha tau‐uriuri tataodi. ");
INSERT INTO swp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ia oea eai wa ie leta ie dobi, moutuadi lailai se hemuriwatai; ");
INSERT INTO swp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","lepera tauna esau i laoma ia arinai, i turibono ia matana eai, i ene, “Guiau e, ena u henua, oa abina u ata u heaagu.” ");
INSERT INTO swp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iesu nimana i loloilaei, tau wa i abiita, i ene, “Ea henua, oa abo u aa.” Maesega ana lepera ie uru. ");
INSERT INTO swp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Iesu ia i heriba i ene, “Tabu tau esau arinai u wasawasaei; u lau mo kohena arinai, ainauia Mose i ribaei wa u mosei, laulau ta u hemasaraha aridi eai.” (Lev. 14.4). ");
INSERT INTO swp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ia abo i lulage Kaperenauma eai, kenturion esau i laoma ia arinai, i awanoridaoi, ");
INSERT INTO swp_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","i ene, “Guiau e, Tauheaeaiegu numa eai ie ota i palisi, tauna se amamna ariri.” ");
INSERT INTO swp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Iesu ia i heriba, i ene, “Ea laowa, abo ea hemauri.” ");
INSERT INTO swp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kenturion i ribauio i ene, “Guiau e, eau nige ea lolo bena u laoma egu numa alona eai: em riba mo u ribaei, to egu heaeai tauna abo i mauri. ");
INSERT INTO swp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Eau hinage tanuaga esau ea heaeaiei, eo hinage tauiala tanuagadi ede eau: tau esau ea heriba ea ene, ‘U lau,’ abo i lau: ea heriba ea ene, ‘U laoma,’ abo i laoma: egu heaeai tauna arinai ea ene, ‘U ginauri,’ abo i ginauri.” ");
INSERT INTO swp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ena riba Iesu i ataiei ie noo, isi taulauwataina i heribadi i ene, “Mamohoi ea heribamiu ta, nige sunuma doha ina ea ita, Isaraela eai nige esau doha. ");
INSERT INTO swp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ea heribamiu ta, tatao gamagaridi teha aruabu, eo teha eahala abo se laoma maedi Aberahama, eo Isaako, eo Iakobo se bawabigabiga galewa basileiana eai. ");
INSERT INTO swp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Na basileia nanatunayao masigiri ariariri boeana eai abo se gabalaedi, nei eai abo se doudou, eo gadigadidi se taburuyahisidi.” ");
INSERT INTO swp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Iesu kenturion i heriba, i ene, “U lau, em sunuma wa abo ie tubu.” Ena heaeai tauna edi huia ribariba eai ne ie mauri. ");
INSERT INTO swp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Abotai abo Iesu i lagema Petero ena numa eai, ia bosiana i ita ie ota, tauna se gigibori ariri. ");
INSERT INTO swp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ia nimana i abiitalaei, ena gigibori i lautom: abo i toro i heaeaiedi. ");
INSERT INTO swp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","I maimailahio, demoni tauluidi gamagaridi se woeaidima ia arinai: ena riba eai earua i aiduiedi, eo isi hinage tauasiasiebo gamagamagari i hemauridi. ");
INSERT INTO swp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Arinai abo riba wa Isaia peroveta i ribaei, se hemamohoiei, i ene, “Eda beruberu ia i abihaidi, eo eda asiebo i bahedi.” (Is. 53.4). ");
INSERT INTO swp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Iesu moutuadi lailai i itadi, ia se lauwatai, i lauhesomdi bena abo se lau hari teha eai ne. ");
INSERT INTO swp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tauuriuri esau i laoma ia i heriba i ene, “Tanuagagu e, taba em abasae, em abadobi eai ea lauwataim.” ");
INSERT INTO swp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Iesu ia i heriba i ene “Alope edi guda, ewa manudi edi noi se abidi; na Tau Natuna uruna nige ena aba‐aiunuaena.” ");
INSERT INTO swp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Heaheata esau ia i heriba i ene, “Guiau e, bena ea lau tamagu ea tore bagunai.” ");
INSERT INTO swp_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Iesu ia i heriba i ene, “U lauwataiguma mo: taumatemate isibom edi taumatemate abo se toredi.” ");
INSERT INTO swp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ia abo i gerusae waga eai, ena heaheatayao ia se hemuriwatai. ");
INSERT INTO swp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Gabogabo eai mana lailai i lagelage, butubutu waga i poii: na ia ma‐enona. ");
INSERT INTO swp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ena heaheatayao se laoma ia se hanoi, si ene, “Guiau e, u hemaurida: ata ta mate.” ");
INSERT INTO swp_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ia i heribadi i ene, “Omi saha au matausini? emi sunuma i gagiri.” Ia abo i toro mana eo gabogabo i ribahetarudi: abo i daumori ariri. ");
INSERT INTO swp_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tatao wa se noo, si ene, “Tau ta edohana ina, mana eo gabogabo ena riba se ataiei!” ");
INSERT INTO swp_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ia abo ie duna hari teha eai Geresene oeana eai, tatao labui demoni se luidi maedi se hailobai, isi bousa eai se loama, se hemahemanabara ariri, arinai tatao nei dobila wa se laulaugabaei. ");
INSERT INTO swp_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Isi se eabayaba, si ene, “Oa Eaubada Natuna e, saha abo ai abi arim eai? Oa u laoma ina bena u heamamnanonohaimai?” ");
INSERT INTO swp_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Sarai eawoidi esau se dumuri eda lohaloha eai. ");
INSERT INTO swp_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Demoni ia se awanorini, si ene, “Ena u aiduiemai u hetamarihesuaramai nei sarai eawoidi ne boeadi eai.” ");
INSERT INTO swp_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ia abo i heribadi, i ene, “Au lau.” Abo se lulagema murimuri eai, eo se lulau sarai eawoidi boeadi eai; na eawoidi wa se ohihai abo se aitautau se dobi padipadi eai, se mate ohi gabogabo eai. ");
INSERT INTO swp_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Isi sarai tausuisuidi abo se dago, se laulau e eanua eai se lage, wasa wa se heribadi, eo demoni tauluidi wasana hinage. ");
INSERT INTO swp_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Eanua tataodi gamagamagari abo se laoma bena Iesu maedi se hailobai, ia se ita se aiboda adidiri ia arinai, si ene, “bena ama sigasiga ta u laugabaei.” ");
INSERT INTO swp_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ia waga eai ie geru ie lau hari sana awasi eai, abo ie lage ena eanua eai. ");
INSERT INTO swp_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Na, tau esau ena asiebo i palisi, ie ota hatahata eai, se baheiama: Iesu edi nuatu adidirina i itayao, asiebo palisi tauabina wa i heriba, i ene, “Natugu e, u kode mo; em baaea se ribagigiridio.” ");
INSERT INTO swp_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tauuriuri headi se heunaboisaha, si ene, “Tau ta Eaubada i arina baaeai.” ");
INSERT INTO swp_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Iesu, edi nuatu i nuatulobaiyao, i ene, “Saha baaeana au heunaboisahaei? ");
INSERT INTO swp_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Aitea i masamasaraha ede, ea ene, ‘Em baaea se ribagigiridi,’ e ea ene, ‘U torohai, u lau?’ ");
INSERT INTO swp_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Omi bena au ita Tau Natuna tanoubu eai ta, ia gigiborina eai, baaea i ribagigiridi (asiebo palisi tau‐abina i heriba, i ene), U torohai, em eba u nou, u lau em numa eai.” ");
INSERT INTO swp_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ia i torohai, i lau ena numa eai. ");
INSERT INTO swp_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Moutuadi se ita se matausi Eaubada se hedebasaei, ena gigibori nei doha i mosei tatao aridi eai. ");
INSERT INTO swp_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nei eai Iesu i torohai i lau, tau esau ie ita, esana Mataio, takisi numana eai i babawa, ia i heriba, i ene, “U lauwataiguma.” Ia abo i torohai, ia i hemuriwatai. ");
INSERT INTO swp_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Iesu i bawabigabiga, numa eai i aiai, eo takisitautano gamagamagari, eo tatao baabaaea se laoma Iesu maena heaheatayao maedi se bawagogo. ");
INSERT INTO swp_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Parisea abo se itadi, ena heaheatayao se heribadi si ene, “Tanuagamiu ie saha takisi tataodi, eo tatao baabaaea maedi se aiai esega?” ");
INSERT INTO swp_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Iesu riba wa i ataiei, i ene, “Taumaumauri doketa nige se abi, tauasiasiebo mo. ");
INSERT INTO swp_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Au lau teina riba ta aniona au eooi. ‘Eau nuatoatoa ea henua, aitalasm nige’e (Hos. 6.6):’ paana ede nige ea laoma taulaulau‐dudurai ea eogaidi, tatao baabaaeadi mo.” ");
INSERT INTO swp_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ioane ena heaheatayao abo se laoma Iesu arinai, si ene, “Ai, eo Parisea, huia gamagamagari ai aiaiudi, oaem heaheatayao se saha nige se aiaiudi hinage?” ");
INSERT INTO swp_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Iesu i heribadi i ene, “Wa, tautawasora harihariu ena heriam se nuadubu tautawasora maedi sora se miaesega? Na huiana abo i lagema, tautawasora harihariu abo se laesuara, nei asubenadi eai abo se aiaiudi.” ");
INSERT INTO swp_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nige tau esau lulu harihariuna i popoi lulu beabeana arinai, bena se bodigudui abo se tapurisi uio, lulu wa abo i tapurisi ariri. ");
INSERT INTO swp_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Hinage tatao waina harihariuna nige se hegoi sarai opina iledi beabeadi alodi eai, ata doha iledi wa se tapurisi, waina abo i boriri, eo iledi abo se baaea; na waina harihariuna se hegoi sarai opina iledi harihariudi alodi eai, abo se lolo labulabui.” ");
INSERT INTO swp_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Teina riba ta Iesu i heriheribadi, na sunago tanuagana esau i laoma ia i aihelahui, i ene. “Natugu siu ie mateo: na taba u laoma nimam u saosae ia potana eai, abo i mauri.” ");
INSERT INTO swp_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iesu abo i torohai, ia i lauwatai, ena heaheata maenayao hinage. ");
INSERT INTO swp_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Na, sine esau ana asiebo borimai saudoudoilabui osina ie didi, ia murina eai i moninihima ana lulu dedeana i heasailaei. ");
INSERT INTO swp_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ena nuatu i ene, “Ena ana lulu mo ea heasai, taugu abo se lolo.” ");
INSERT INTO swp_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Iesu abo i torobui sine wa i ita, i ene, “Natugu e, nuam i biga, oa sunusunumam eai taum se lolo’o”. ");
INSERT INTO swp_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Iesu abo i awasae sunago tanuagana ena numa eai tatao huelele se oioini i itadi, eo tatao se doudou. ");
INSERT INTO swp_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","I heribadi i ene, “Au pesagorigori; siu me nige i mate, ie eno mo.” Isi ia se marumaruhiei, eo se talatalawasiei. ");
INSERT INTO swp_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tatao wa se pesagorigori abo i lulau biri eai, siu nimana eai i abilau, ia abo i toro. ");
INSERT INTO swp_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Teina wasa ta ie lau nei oea ne i tauhetaiiri. ");
INSERT INTO swp_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Iesu nei dimo ne abo i laugabaei, taumatagibugibu labui ia se lauwatai, se eogayoga, si ene, “Davida natuna e, u nuatoatoaimai.” ");
INSERT INTO swp_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ia abo i awasae numa eai, taumatagibugibudi se laoma ia arinai: Iesu i heribadi, i ene, “Emi nuatu i adidiri au ene ina ta abina ea ata?” Se heriba si ene, “Guiau e, hedeona.” ");
INSERT INTO swp_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Isi matadi i abiitadi, i ene, “Emi sunuma doha meta arinai abo i tubu arimiu eai.” ");
INSERT INTO swp_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Matadi abo se lala; arinai abo Iesu awadi i tawaidi, i ene, “Wasa ta tabu tau esau i ataiei,” ");
INSERT INTO swp_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Isi abo se lau ia wasana se duai oea se hetaiiri. ");
INSERT INTO swp_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ma laudi, dobila eai tau unaunana, demoni ia se lui, se woeayama Iesu arinai. ");
INSERT INTO swp_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Demoni wa se aiduieyao, abo tauunaunana wa ie riba: moutuadi lailai se nooei, si ene, “Nabada wa, Isaraela eai laulau ina doha nige ta itaitai.” ");
INSERT INTO swp_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Parisea tataodi mo si ene, “Demoni edi wasawasa ena gigibori eai, arinai demoni i aiduiedi.” ");
INSERT INTO swp_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iesu edi eanua lailaidi, eo edi eanua gagiridi hinage gamagaridi i tautausidi, edi sunago alodi eai i lauheataedi, basileia wasa lolona i lauguguiaedi, asiebo eo iwala gamagamagari i hemauridi. ");
INSERT INTO swp_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Moutuadi lailai i itadi i nuatoatoaedi paana ede se nuadubu, eo se tatagorigori, doha mamoe nige taumiataunidi. ");
INSERT INTO swp_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ena heaheatayao abo i heribadi, i ene, “Aiai sunasuna se gamagari ariri: na tauabidi eseesegadi mo. ");
INSERT INTO swp_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Guiau, aiai wa tanuagana, arinai au uura bena taupaisoa headi i hetamaridi ana aiai sunasuna abo se abidi.” ");
INSERT INTO swp_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ena heaheatayao saudoudoi‐labui i eogaidi ia arinai, gigibori abo i mosei aridi eai earua biibiidi abo se guduguduidi eo se aiduiedi, eo asiebo, eo iwala gamagamagari abo se hemauridi. ");
INSERT INTO swp_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aposotolo saudoudoi‐labui wa esadi ede ina; Bagubagunana ede Simona, esana ede Petero, eo ana taumurita Anederea; Iamesi, Sebedaio natuna, eo ena tau Ioane. ");
INSERT INTO swp_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipo, eo Batolomaio; Toma, eo Mataio takisi tautano; Iamesi, Alepaia natuna, eo Tadaio; ");
INSERT INTO swp_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simona, Kanana tauna, eo Iuda Isakariota ia ede taumoruina wa. ");
INSERT INTO swp_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Isi tatao saudoudoi‐labui Iesu i hetamaridi, eo i lauhesomdi, i ene, “Etene edi eanua dobiladi tabu au lauwataidi, eo Samaria eanuadi hinage tabu au lulage aridi eai. ");
INSERT INTO swp_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mamoe se tatagorigori Isaraela numadi eai, au lau hesabadi. ");
INSERT INTO swp_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Au lau ma guguiamiu au ene, ‘Galewa basileiana i hanahanaumao.’ ");
INSERT INTO swp_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tauasiasiebo au hemauridi, lepera au heaadi, taumatemate au hetorouioidi, demoni au aiduiedi: ginauri gamagaridi aue abidi hinage au ainauiaidi nige maisadi. ");
INSERT INTO swp_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Tabu gold eo silver, eo pene au usaidi emi tobo eai. ");
INSERT INTO swp_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Emi lauwasi tobo tabu au laei, tabu pereue labui, tabu aeum, tabu tue hinage, paana ede taupaisoa ana aiai taba se mosei. ");
INSERT INTO swp_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ena eanua esa, eanua esa au lulage aridi eai, au lauhesio, eai nei eai ena abi se lolo; arinai au mia e abo au lau. ");
INSERT INTO swp_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ena au awasae numa esau alona eai, au lautoiedi. ");
INSERT INTO swp_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Numa wa ena edi abi se lolo, emi loni au tore aridi eai: ena edi abi nige se lolo, emi loni au abiuioi. ");
INSERT INTO swp_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Esa, esa nige i eogaisinimiu, emi riba hinage nige i ataiedi, ena numa, eo eanua me au laugabaedi, aemiu muaridi au oiluiluigabaedi. ");
INSERT INTO swp_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mamohoi, ea heribamiu ta, hedudurai asubenana eai Sodoma eo Gomora edi baaea nige si ene ie lai, doha wau eanua wa. ");
INSERT INTO swp_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Na, ea hetamarimiu ta omi doha mamoe luko boeadi eai; arinai abo au sonoga doha mota, au taubiga doha bunebune. ");
INSERT INTO swp_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tatao au komanidi; isi abo se laemiu kaunisila aridi eai, edi sunago alodi eai hinage abo se pidirimiu. ");
INSERT INTO swp_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Eau debagu eai abo se woeaimiu gavana eo wasawasa matadi eai, bena isi aridi eai, eo etene aridi eai hinage au hemasarahagu. ");
INSERT INTO swp_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Isi se toaimiu se laemiu wa, tabu emi nuatu au ene edoha emi ribariba: paana ede nei huia eai ne riba se leawa abo au ribaei. ");
INSERT INTO swp_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Paana ede omi nige au riba, Tamamiu ena Earua boeamiu eai, ia abo i riba. ");
INSERT INTO swp_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Taubaguna ana taumurita abo i mosei se unuhemate, eo tamana ia natuna abo hinage doha, merumeru abo tamadiyao eo sinadiyao se hewaiunuedi, abo se unuhematedi. ");
INSERT INTO swp_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tatao gamagaridi taba se hewaiunuemiu eau esagu debana eai: na ia i sogohididini i lau e anasigana eai, abo se hemauri. ");
INSERT INTO swp_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Taba teina eanua eai ta se heamamnamiu, au dago, au lau hari eanua: mamohoi ea heribamiu ta, Isaraela eanuadi sora nige au baeawaheohidi, Tau Natuna abo i lagema. ");
INSERT INTO swp_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Tauheaheata ana tanuaga nige i saepoi, eo tauheaeai ena guiau nige i saetawatawai. ");
INSERT INTO swp_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tauheaheata nuana i lolo ena si ene ia doha ana tanuaga: eo tau heaeai doha ena Guiau. Taba numa tanuagana esana se tore Belesebulo, ena numa tataodi hinage esadi nei doha se toredi, e nige’e? ");
INSERT INTO swp_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Arinai tabu au matausiedi: paana ede ginauri esana se hebuitawai, abotai abo i masaraha; eo se toreyamui, hinage abo se ita‐lobai. ");
INSERT INTO swp_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Riba wa ea heribamiu wa masigiri boeana eai, marana eai au ribaei; eo riba wa beamiu eai au ataiedi wa, numa ewadi eai au guguia hemasarahadi. ");
INSERT INTO swp_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Isi taumiu mo tauunuidi tabu au matausiedi, earuamiu unuina nige abina se ata: na ia mo au matausiei ede, earuamiu eo taumi taba i hebaaeaesegaidi gehena eai. ");
INSERT INTO swp_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Manu gagiridi labui se unedi maisadi pene esega, e nige’e wa? taba nige esau i beu tano eai, Tamamiu abo i ita. ");
INSERT INTO swp_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Urumiu maiawadi gamagamagari se hasiriheohidio. ");
INSERT INTO swp_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Arinai tabu au matausi, manu gagiridi gamagamagari nige se sae doha omi. ");
INSERT INTO swp_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ena tau esa, esa, i ribahemasarahagu tatao matadi eai, eau hinage ia abo ea ribahemasaraha Tamagu galewa eai ie mia, ia matana eai. ");
INSERT INTO swp_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ena esa, esa, i hareregu tatao matadi eai, eau hinage ia abo ea harere Tamagu galewa eai ie mia, ia matana eai. ");
INSERT INTO swp_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Tabu nuamiu au ene ea laoma tanoubu eai loni ea leama: loni taba nige ea leama, elepa mo. ");
INSERT INTO swp_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ea laoma ta bena tau ia tamana abo i hewaiunuei: natuna siu, sinana hinage bena i hewaiunuei: lawana hinage bosiana‐sine, bena i hewaiunuei. ");
INSERT INTO swp_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tau esau ena waiunuyao isi ede ena numa tataodi. (Mic. 7.6) ");
INSERT INTO swp_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ia tamana eo sinana i gadosisiedi, nige i gadosisiegu doha i gadosisiedi, ia nige gonoana agu sagu; ia natuna tau, eo natuna sine i gadosisiedi, nige i gadosisiegu doha i godosisiedi, ia nige i hedebasaegu. ");
INSERT INTO swp_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ia ena satauro nige i abiisini, abo i lauwataigu, ia nige i hedebasaegu. ");
INSERT INTO swp_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ia mauri i lobai, ena mauri abo i tauyamui, ia ena mauri i nuagabaei eau debagu eai ena mauri abo i lobai. ");
INSERT INTO swp_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ia i taubigaimiu i taubigaigu hinage, ia i taubigaigu tauhetamariguma hinage i taubigai. ");
INSERT INTO swp_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ia peroveta i taubigai peroveta esana eai, peroveta ainauiana abo i abi, ia taulaulau‐duduraina i taubigai taulaulau‐duduraina esana eai, taulaulau‐duduraina ainauiana abo i abi. ");
INSERT INTO swp_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ena tau esa, esa goila nomnom kaputi esau mo i mosei merumeru gagirina esau arinai heaheata esana eai, mamohoi ea heribamiu ta ia ainauiana taba nige ie dabu.” ");
INSERT INTO swp_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Iesu ena heaheatayao saudoudoi‐labui i lauhesomnonohaidi, nei dimo ne abo i laugabaei edi eanua eai bena i lauheata eo i lauguguia. ");
INSERT INTO swp_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Na, Ioane numa masigiri eai Keriso ana paisoa wasana i ataiei, ena heaheatayao labui i hetamaridi, ");
INSERT INTO swp_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Iesu arinai si ene, “Ia bena i laoma wa ia ede oa, e esau abo ai eooi?” ");
INSERT INTO swp_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Iesu arinadi i heuio, i ene, “Au lau ginauri wa au ataiedi, eo au itadi, Ioane au heitauioi au ene, ");
INSERT INTO swp_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Taumatagibugibu matadi se helaladi, taulaulaudae se tautausi, lepera tataodi se heaadi, tau beado’odo’o riba se ataiei, tau matemate se abihetorodi, eo taugogogesagesa wasa lolona se lauguguiaidi. ");
INSERT INTO swp_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Taba tau esa, eo esa nige i nuabaaea arigu eai, nuana abo i woiwoina.” ");
INSERT INTO swp_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ma laudi, na Iesu moutuadi Ioane ribana enadi i ribahetubu i ene, “Aue lau barabara eai wa saha bena au ita? Didiari esau mana i iuhihe’eoeo? ");
INSERT INTO swp_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Aue lau saha bena au ita? Tau esau ana lulu bigabigana i lui? hage isi lulu bigabigana se lui wasawasa edi numa eai se mia. ");
INSERT INTO swp_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Aue lau saha bena au ita? Peroveta wa? Hedeona, ea heribamiu ta, ia peroveta saesaena. ");
INSERT INTO swp_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ia ede teina, doha se uri wa si ene, ‘Hage, egu tauwasa matam eai ea hetamarimugaiem em dobila i abinonohai.’ ");
INSERT INTO swp_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Mamohoi, ea heribamiu ta, isi wa sisine se labasidi nige esau ie toro, Ioane Bapatiso mo ia i saetawatawai ede; na ia galewa basileiana eai i murimuritama Ioane Bapatiso abo i saetawatawai. ");
INSERT INTO swp_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ioane Bapatiso huiana eai, i laoma e huia ta, galewa basileiana se laugirihai, eo tatao adiadidiri edi adidiri eai se laugirihai. ");
INSERT INTO swp_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Peroveta gamagamagari eo laugagaeo hinage se ribaperoveta i laoma e Ioane huiana eai. ");
INSERT INTO swp_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ena au ataiei, Elia ede ina, ia ede si ene abo i laoma wa. ");
INSERT INTO swp_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ia beana eai i ataiei, abo i ataieididini. ");
INSERT INTO swp_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Teina isi ta saha arinai ea heaheasoniei? Doha ede merumeru se bawagogo abauneune eai, adi sasaguyao se eogaidi, si ene. ");
INSERT INTO swp_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Huelele aie iuhiawa, nige aue saga: ai dou nuanuadubuemiu, nige aue dou.’ ");
INSERT INTO swp_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ioane i laoma aiai nige ie ai, waina nige ie nom, abo si ene, ‘Demoni esau ia boeana eai.’ ");
INSERT INTO swp_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tau Natuna i laoma aiai ie ai, eo waina ie nom, abo si ene, ‘Au ita, tauaiaisom, eo waina taunomnomsom, takisi tautano eo tatao baabaaeadi ehadi.’ Sonoga nanatunayao aridi eai sonoga wa se hemasaraha.” ");
INSERT INTO swp_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Abotai abo eanua headi aridi eai ena laulau gigibori i hemasarahadi i ribasuuidi, paana ede nuadi nige se buidi. ");
INSERT INTO swp_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","I ene, “Kapore Korasina! Kapore Betesaida! paana ede laulau gigiboridi emi eanua eai se ginauridi wa, taba Turo eo Sidona eai se ginauridi isi nabada nuadi se buidi, eo baeki eo ahu se aiouiaedi. ");
INSERT INTO swp_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Teina ea heribamiu ta, hedudurai asubenana i lagema Turo eo Sidona taba nige se hegirudaoiedi, omi mo abo se hegirumiu. ");
INSERT INTO swp_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kaperenauma e hinage, oa se heawasaem galewa eai, abo u dobi hade eai: paana ede taba laulau gigiboridi se ginauridi Sodoma eai, doha se ginauridi em eanua eai, ia abo ie mia e huia ta. ");
INSERT INTO swp_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Teina ea heribamiu ta Hedudurai asubenana i lagema, Sodoma taba nige se hegirudaoiei, oa mo abo se hegirum.” ");
INSERT INTO swp_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nei huiana ne Iesu riba i heuio, i ene, “Tamagu, galewa eo tanoubu Guiauna e, ea lautoiem ta, paana teina ginauridi tatao sonoga, eo tatao sibasiba matadi eai u toreyamuidi: na kaimou aridi eai u hemasarahadi. ");
INSERT INTO swp_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Taiede Tamagu e: nei doha oa matam eai u ene i lolo. ");
INSERT INTO swp_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tamagu ginauri gamagamagari i ledima eau arigu eai: nige tau esau Natuna i itayao, Tamana iabom: hinage nige tau esau Tamana i itayao, Natuna iabom, eo ia hinage esa, eo esa, aridi eai Natuna wa ia i henua i hemasaraha. ");
INSERT INTO swp_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Omi gamagarimiu amnamiu se baaea, eo ami bahebahe se porohe, au laoma eau arigu eai, abo ea heaiyawasimiu. ");
INSERT INTO swp_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Egu oibahe au tore gedugedumiu eai, eo arigu eai au napuhai: paana ede eau ea dobidobiegu eo eau taumanamanabiga: earuamiu edi abaaiyawasi abo au lobai. ");
INSERT INTO swp_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Paana ede agu oibahe i masamasaraha, eo agu bahebahe i mamala.” ");
INSERT INTO swp_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nei huiana ne, sabate esau, Iesu i oilulau sitona oeadi eai; ena heaheatayao se guriam, arinai sitona aiaidi se wolahaidi, se aidi. ");
INSERT INTO swp_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Parisea abo se ita, ia se heriba si ene, “U ita, em heaheatayao sabate laugagaeona se utusi ne.” ");
INSERT INTO swp_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ia abo i heribadi i ene, “Davida ena laulau nige au hasiri wa? huia ne i guriam, eo ana sasaguyao hinage; ");
INSERT INTO swp_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ia i awasae Eaubada ena numa eai, areto i aiai, ia ma ana sasaguyao, laugagaeo se utusi, paana kohena tataodi isibom areto wa tauaidi ede. (1 Sam. 21.1-6). ");
INSERT INTO swp_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Laugagaeo eai hinage nige au hasiri wa, si ene, asubena sabate kohena tataodi dubu alodi eai sabate laugagaeona taba se utusi, nige se baaea? ");
INSERT INTO swp_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Na, ea heribamiu ta, ea ene, ginauri esau inai dubu wa ia i saetawatawai. ");
INSERT INTO swp_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Taba teina riba ta abina au ata, doha si ene, ‘Nuatoatoa ea henua, aitalasam nige’e,’ tatao nige adi giru taba nige au nuatu hebaaeadi. (Hos. 6.6) ");
INSERT INTO swp_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tau Natuna ia sabate ena Guiau ede.” ");
INSERT INTO swp_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nei dimo ne i laugabaei abo i awasae edi sunago alona eai. ");
INSERT INTO swp_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Na, tau esau nei eai nimana esau i tubu ea’eyaelua. Ia se oimurini si ene, “Huia sabate eai taba ta hemauri abo i lolo?” ia bena abo se hegiru. ");
INSERT INTO swp_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Iesu i heribadi i ene, “Aitea tau arimiu eai wa, ena mamoe esega dumaduma, asubena sabate eai ie beu hua eai, abo i abilau i abiisiniama, e nige’e wa? ");
INSERT INTO swp_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tau mamoe i saetawatawai. Arinai i lolo asubena sabate eai laulau lolo au laulauedi.” ");
INSERT INTO swp_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ia abo tau wa i heriba i ene, “Nimam u heleleama.” Nimana i helelelaei: i lolo’o, doha hinage nimana esau. ");
INSERT INTO swp_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Parisea abo se lulage ia abo se oiribaei, si ene, edoha edi abiabina ia taba se unui. ");
INSERT INTO swp_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Edi nuatu Iesu i itayao nei dimo ne abo i laugabaei: tatao gamagamagari ia se lauwatai: gamagaridi hinage i woisidi; ");
INSERT INTO swp_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ia abo i lauhesomdi, i ene ia tabu se wasawasaei. ");
INSERT INTO swp_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Arinai abo riba esau Isaia peroveta i ribaei si hemamohoiei, i ene, ");
INSERT INTO swp_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Egu heaeai tauna au ita, ia ea hinahinawai; ia ea gadoisiei, eo ea nualoloei: earuagu ea toresae ia potana eai: ia hedudurai Murimuri‐tataodi abo i heitadi. ");
INSERT INTO swp_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ia nige i haihaiawayagara, eo nige i sagasagari: dobila eai ia arinana taba nige esau i ataiei ");
INSERT INTO swp_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Didiari leleana taba nige i goduhai, oeagi gagirina taba nige i heboso, i lau e ena hedudurai eai se mauri. ");
INSERT INTO swp_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ia esana Murimuri‐tataodi abo se sunumawatai.” (Is. 41.8; 42.1). ");
INSERT INTO swp_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Abotai abo tau esau demoni i lui se woeaiama Iesu arinai, ia matana se gibu, eo i unauna hinage: Iesu ia i hemauri, arinai abo taumatagibugibu eo tauunauna wa ie riba, eo matana se lala. ");
INSERT INTO swp_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tatao gamagamagari se nooei, si ene, “Ina ta Davida natuna, e nige’e?” ");
INSERT INTO swp_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Parisea teina riba ta se ataiei, si ene, “Ina tau ta Belesebulo, demoni edi wasawasa, ena gigibori eai demoni wa i aiduiedi.” ");
INSERT INTO swp_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Iesu edi nuatu i nuatulobaiyao, arinai i heribadi, i ene, “Basileia ena isibom se haitoremuri abo se lautom: eo eanua, e numa, taba se haitoremuriuioidi abo nige se toro: ");
INSERT INTO swp_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Taba Satani, Satani i aiduiei iabom i haitoremuriuioi: ena basileia edohana abo i toro? ");
INSERT INTO swp_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Taba eau Belesebulo gigiborina eai demoni ea aiduiedi, omi nanatumiuyao eai gigiborina eai abo se aiduiedi hinage? Isi mo abo tauhegirumiu. ");
INSERT INTO swp_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Taba eau demoni ea aiduiedi Eaubada ena Earua gigiborina eai, Eaubada ena basileia ede i lageo omi potamiu eai. ");
INSERT INTO swp_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Tau adiadidiri ena numa edoha edi lulusaena ena ginauri abo se girihaidi, taba ena tauadiadidirina se aubagunai, abotai abo ena numa ginauridi se abidi. ");
INSERT INTO swp_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Taba tau nige i sagusaguigu ia abo i guduguduigu; taba tau nige i tanogogo‐saguigu abo i hetatagorigori. ");
INSERT INTO swp_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Arinai ea heribamiu ea ene, Tatao edi baaea gamagamagari, eo riba baaea hinage abo se ribagigiridi, na ena Earua Tabuna se riba baaeaei taba nige se ribagigiri. ");
INSERT INTO swp_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Taba tau esa, eo esa Tau Natuna i hebaaea, edi baaea wa abo se ribagigiri: taba tau esa, eo esa Earua Tabuna i hebaaea ena baaea taba nige se ribagigiri: ina tanoubu maurina eai ta, eo galewa maurina eai hinage. ");
INSERT INTO swp_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Oeagi lolona uauana hinage i lolo: oeagi baaeana uauana i baaea: oeagi abaitalobaina ede uauana. ");
INSERT INTO swp_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Omi mota nanatudiyao e, au baaea: edohana abo riba lolodi au ribaedi wa? Tau awana ribana nua i monau‐boriboriri arinai se tubuma. ");
INSERT INTO swp_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tau lolo ena ginauri lolodi abo i hemasarahadi, tau baaea ena ginauri baaeadi abo i hemasarahadi. ");
INSERT INTO swp_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ea heribamiu ta, Hedudurai asubenana eai riba gaibu gamagamagari tatao se ribaedi, abo se hemasarahadi, eo aridi eai se hegirudi. ");
INSERT INTO swp_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Emi riba abo se helolomiu: eo emi riba abo se hegirumiu hinage.” ");
INSERT INTO swp_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Arinai abo tauuriuri headi, eo Parisea headi Iesu se heriba si ene, “Tanuagamai e, heiheinoim esau bena ai ita.” ");
INSERT INTO swp_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ia arinadi i heuio i heribadi, i ene, “Isina baaeana, eo isina nige se sunusunuma, heiheinoina se eooi: taba nige heiheinoina esau se mosei na Iona peroveta mo heiheinoina wa. ");
INSERT INTO swp_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Doha ulaulasi Iona ie dom wa, bogana alona eai ie mia asubena haiona eo maiona haiona: doha ede Tau Natuna hinage i mia tano boeana eai asubena haiona eo maiona haiona. ");
INSERT INTO swp_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Hedudurai huiana eai Nineva tataodi abo se totoro teina isina ta maenayao, abo hinage se hegirudi: paana ede Iona ena lauguguia arinai nuadi se buidi: esau ede ina, Iona i saetawatawai. ");
INSERT INTO swp_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Hedudurai huiana eai tupo eawana edi wasawasa sine abo i toro teina isi ta maenayao abo hinage i hegirudi: ia tanoubu sigana eai i laoma bena Solomona ena sonoga i ataiei: esau ede ina, Solomona i saetawatawai. ");
INSERT INTO swp_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Earua bii tau esau nuana eai i laugabaei, i lau dimo pitapitari eai bena ena abaaieawasi i eooi, na nige i lobai. ");
INSERT INTO swp_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","E abo i ene, Abo ea uio egu numa eai arinai ea laoma ta: abo i laoma, ie ita numa ahaaha mo, eo se uiauiaauri, eo se deuri. ");
INSERT INTO swp_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ia abo i lau, maenayao earua baaea haligigilabui i laedi se lulau tau wa boeana eai, se miahai: lahinae tau wa ena baaea i gagiri, ina huia ta mo ie lai. Teina isina baaeana ta abo hinage doha nei.” ");
INSERT INTO swp_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Moutuana wa aridi eai ma ribaribana, sinana eo ena tataoyao murimuri eai se totoro, bena se ribalau ia arinai. ");
INSERT INTO swp_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tau esau ia i heriba i ene, “Sinam eo em tataoyao murimuri eai se totoro, si ene bena si ribalaowa.” ");
INSERT INTO swp_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Wau tau wa, tauheribana, arinana i heuio i ene, “Sinagu eai? eo egu tataoyao aidimodi?” ");
INSERT INTO swp_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ia nimana i helelelaei ena heaheatayao aridi eai to i ene, “Hage sinagu eo egu tataoyao au itadi. ");
INSERT INTO swp_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Eai to eai Tamagu galewa eai gadohina i gadohiei egu tau ede, eo lougu ede, eo sinagu ede.” ");
INSERT INTO swp_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nei asubenana ne Iesu numa i laugabaei, i dobi salagomgom eai i bawabigabiga. ");
INSERT INTO swp_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Moutuana lailai se oigogo ia arinai, arinai abo ie geru waga esau eai, ie bawabigabiga, moutuana lailai wa geregere eai se totoro. ");
INSERT INTO swp_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Riba gamagaridi aridi eai i heribaparaboledi, i ene, “Tuma tauhesuruna ie lau i hesuruauri. ");
INSERT INTO swp_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ia ma hesuhesuruna, tuma headi eda gegesina eai se beu to manu se laoma se aidi. ");
INSERT INTO swp_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Headi malatetapari eai se beu, tano i teriteri, se ini heuheula, paana tano nige ie buluma, ");
INSERT INTO swp_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","mahana abo i dalasae i sinaidi, nige lamdi, arinai se wowoea. ");
INSERT INTO swp_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Headi nurinuri boeadi eai se beu, nurinuri se ini se imaguduidi. ");
INSERT INTO swp_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Na, headi tano lolona eai se beu, abo se ua, headi sinau tatao‐haligigi‐si‐mate, headi sinau tatao‐haiona‐si‐mate, headi tau‐esega‐i‐mate‐saudoudoi. ");
INSERT INTO swp_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ia beana eai i ataiei, abo i ataieididini.” ");
INSERT INTO swp_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Heaheata se laoma, se ribalau ia arinai si ene, “Ue saha u heribaparaboledi ne?” ");
INSERT INTO swp_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Aridi eai arinadi i heuio i ene, “Galewa basileia sonogadi eamuyamuidi omi abina au ata, isi nige abina se ata. ");
INSERT INTO swp_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Eai to eai i abi enana hinage abo se mosei, enana abo se hegamagari; eai to eai nige i abi, enana begana abo se laeudoiei. ");
INSERT INTO swp_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Arinai ede aridi eai ea heribaparaboledi: paana se itaita taba nige se ita, eo se ataiei taba nige se ataiei, eo nige se nuatui. ");
INSERT INTO swp_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Riba peroveta Isaia i ribaei, aridi eai se hemamohoiei, doha i ene, ‘Se ataiei, ataiena taba nige abina se ata: se ita, itana taba nige se italobai. ");
INSERT INTO swp_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Teina tatao ta nuadi se porohe, beadi hinage se do’odo’o, matadi se hegibudi; ata huia esau matadi eai se italobai, eo beadi eai se atailobai, eo nuadi eai se nuatulobai, e abo nuadi se buidi eo ea hemauridi.’ (Is. 6.9-10). ");
INSERT INTO swp_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Omi matamiu se lolo, paana ede se ita; beamiu hinage paana ede se ataiei. ");
INSERT INTO swp_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ea heribamiu mamohoi, peroveta eo laulaududurai tataodi gamagaridi edi gadosisi esega bena teina ginauri ta se itadi doha omi au itadi, to nige se itadi eo teina ginauri ta au ataiedi isi hinage bena se ataiedi, nige se ataiedi. ");
INSERT INTO swp_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Tauhesuhesuruna ena parabole abo au ataiei. ");
INSERT INTO swp_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tau basileia ribana i ataiei, eo nige i nuatui, earua baaea abo i laoma riba wa se hesuru nuana eai i abihai i laei. Ia ede tuma se taru wa dobila gegesina eai. ");
INSERT INTO swp_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ia malatetepari eai tuma i abidi, ia ede riba wa i ataiei, eo ie kode hinage: ");
INSERT INTO swp_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Taiede iabom nige lamna, huia kuukuu mo ie dudu: e amamna eo baaea i hearodi riba wa debana eai, arinai abo nuana i beruberu. ");
INSERT INTO swp_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ia nurinuri boeadi eai tuma se taru wa ia ede riba wa i ataiei: tanoubu nuatudi, eo gogo gadosisidi boraboradi, riba wa arinai se hetaupurupuru, abo nige i ua. ");
INSERT INTO swp_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Na ia tano lolona eai uaua i abidi ia ede riba wa i ataiei, eo aniona i itayao: uaua gamagaridi abo i hemasarahadi, headi sinau tatao‐haligigi‐si‐mate, headi sinau tatao‐haiona‐si‐mate, headi tau‐esega‐i‐mate‐saudoudoi.” ");
INSERT INTO swp_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Parabole esau hinage abo i heribadi, i ene, “Galewa basileiana doha ede tau esau tuma lolodi ena oea eai i lauhesuru. ");
INSERT INTO swp_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tatao ma enodi ana waiunu i laoma sisania sitona boeadi eai i hesuruauridi, abo ie lau. ");
INSERT INTO swp_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tuma se kapokiarima, e abo sisania se taumasaraha hinage. ");
INSERT INTO swp_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Numa tanuagana ena heaheari tataodi se laoma se ribalau ia arinai si ene, ‘Taubada e, em oea eai tuma lolodi u umaidi e nige’e wa? sisania ne haedi se laolaoma?’ ");
INSERT INTO swp_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","I ribalau aridi eai i ene, ‘Waiunu esau ena laulau meta.’ Ena heaheari wa se ribalau ia arinai si ene, ‘U ene edoha, abo ai lau sisania ai laahaidi wa?’ ");
INSERT INTO swp_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","I ene, ‘Nige’e, ata sisania wa au laahaidi sitona hinage au laaesegaidi. ");
INSERT INTO swp_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Se ini labulabui i lau e se suna: aiai ena huia suna eai abo tauabidi ea heribadi ea ene, ‘Sisania au tanogogo bagunaedi au auaugogoidi au gabudi: sitona wa egu sanara eai au peiauridi.’” ");
INSERT INTO swp_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Parabole esau hinage i heribadi i ene, “Galewa basileiana doha ede sinapi tumana esega, tau esau ie abi, to ena oea eai i umai. ");
INSERT INTO swp_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tuma gamagaridi iabom i gagiri ariri: taiede i ini lailai, abo oeagi gagiridi i tubuhemuridi, doha i hemala oeagi lailai, malagaibu manudi se laoma se toalau lagana eai.” ");
INSERT INTO swp_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Parabole esau hinage i heribadi i ene, “Galewa basileiana doha ede yeast, sine esau i abi, falawa nonoi haiona boeadi eai i toreyamui, e abotai abo ie seseohi.” ");
INSERT INTO swp_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Teina ginauri gamagaridi parabole eai Iesu ie ribalau moutuana aridi eai: nige riba udoi, i ribaparabole mo. ");
INSERT INTO swp_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Peroveta i ribaei bena arinai se hemamohoiei si ene, “Parabole eai, awagu abo ea dabari: riba headi eamuyamuidi tanoubu huia hetubuna eai wa abo ea ribaedi.” (Psa. 78.2). ");
INSERT INTO swp_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Iesu moutuana i hetamaridi se lau, abo i awasae numa alona eai: ena heaheatayao se laoma ia arinai si ene, “Parabole sisania oeana eai wa u riba‐hemasarahayama.” ");
INSERT INTO swp_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ia abo i ribalau isi aridi eai i ene, “Ia tuma lolona i hesuru wa ia ede Tau Natuna. ");
INSERT INTO swp_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Oeana ede tanoubu: tuma lolodi basileia nanatunayao ede: sisania isi ede tau baaea nanatunayao. ");
INSERT INTO swp_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Waiunu tauhesuhesuruna ia ede diabolo: na ena huia suna tanoubu ena abalautom: na tau‐tanogogoi ede aneru. ");
INSERT INTO swp_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Sisania se tanogogoidi eo se gabudi oeagi alalasina eai: tanoubu ena huia lautom abo doha ede nei. ");
INSERT INTO swp_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tau Natuna ena aneru abo i hetamaridi, ena basileia eai ginauri gamagaridi se baaea, eo isi se laulaubaaea hinage, abo se tanogogoidi se gabaedi; ");
INSERT INTO swp_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","se gabalaedi oeagi alaalasina boeana eai: nei eai se doudou, eo moadi se taburuyahisidi. ");
INSERT INTO swp_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nei huiana ne laulau dudurai tataodi Tamadi ena basileia eai abo se namanamari doha mahana. Ia beana eai i ataiei, abo i ataieididini. ");
INSERT INTO swp_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Galewa basileiana hinage doha ede gogo esau i tauyamui oea eai, tau esau i lobai, abo i toreyamui, ma nualolona i lau ena ginauri gamagaridi i une gabaedi, abo oea wa ie une. ");
INSERT INTO swp_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Galewa basileiana hinage doha ede tau uneune esau, giniuba matamatapoudi i eooidi. ");
INSERT INTO swp_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Esau abo i lobai maisana i lai ariri, i lau ena ginauri maudoidi i unegabaedi, abo matapou wa ie une. ");
INSERT INTO swp_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Galewa basileiana hinage doha ede hiana, gabogabo eai se galaei, hari eama, hari eama gamagaridi se toaidi: ");
INSERT INTO swp_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ie monau, abo se gomosaei geregere eai; se bawa, lolodi abo se usaidi odi alodi eai, baaeadi abo se gabaedi. ");
INSERT INTO swp_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tanoubu ena huia lautom ia ede doha nei: aneru abo se laoma laulau‐baaea tataodi laulau‐dudurai tataodi se pei labuidi. ");
INSERT INTO swp_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Abo se gabalaedi oeagi alaalasina boeana eai: nei eai se doudou, eo moadi se taburuyahisidi.” ");
INSERT INTO swp_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Iesu i ribalau isi aridi eai, i ene, “Teina riba gamagaridi aniodi au itadio wa?” Ia se heriba si ene, “E.” ");
INSERT INTO swp_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Abo i ribalau isi aridi eai i ene, “Arinai tauuriuri gamagaridi se hemala galewa basileiana ena heaheatayao, isi doha numa tanuagana, ena gogo aridi eai ginauri harihariudi eo ginauri beabeadi i hemasarahadi.” ");
INSERT INTO swp_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Iesu nei parabole ne i riba lautom abo i laugabaedi. ");
INSERT INTO swp_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ia abo ie lage ena eanua tahunuana eai, edi sunago eai abo i lauheataedi, arinai se noo ariri, si ene, “Tau ta teina sonoga ta haedi i lealeama, eo teina laulau gigiboridi ta? ");
INSERT INTO swp_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Teina kamda natuna, e nige’e wa? Ia sinana ede Maria, e nige’e? Ena tataoyao ede Iamesi, eo Iose, eo Simona, eo Iudasi, e nige’e? ");
INSERT INTO swp_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ia lounayao hinage gamagaridi maedi ta miamia esega wa, e nige’e? Teina tau ta ginauridi ta haedi i abiabidima?” ");
INSERT INTO swp_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Isi ia abo se ouyalayalaei. Na Iesu abo i ribalau aridi eai, i ene, “Peroveta se heasisiei, ena eanua tahunuana eai mo nige’e, ena numa eai mo nige’e.” ");
INSERT INTO swp_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nei eai laulau gigibori nige i ginauri hegamagari paana ede ia nige se sunusunumaei. ");
INSERT INTO swp_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nei huiana ne Heroda tetarake, Iesu wasana lailai i ataiei. ");
INSERT INTO swp_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ia ena heaheariyao i heribadi, i ene, “Ina ta Ioane Bapatiso ede; ia mate eai i torouio, arinai ede laulau gigiboridi ta i hemasarahadi.” ");
INSERT INTO swp_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Nabada wa Heroda Ioane i toaiyao, eo i auyao, abo i tutugudui numa masigiri eai, ana mata paana ede Herodia, ena tau Pilipo monena. ");
INSERT INTO swp_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ioane ia i heriba i ene, “Ia ue abi arinai laugagaeo u utusi.” ");
INSERT INTO swp_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ia Ioane bena i unui, na tatao gamagaridi i matausiedi, paana ede isi si ene ia peroveta. ");
INSERT INTO swp_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Heroda edi huia labasina huiana eai, Herodia natuna siu ana taumana matadi eai ie saga, Heroda i henualolo. ");
INSERT INTO swp_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Arinai abo Heroda i ribahesunumalaei ma aigorana, i ene, ena ginauri saha, saha i aibodaidi, abo i mosei. ");
INSERT INTO swp_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Sinana siu wa i ribahasahasaiyao, arinai i ene, “Ioane Bapatiso uruuruna se usai gaeba eai u leama.” ");
INSERT INTO swp_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Wasawasa abo nuana i baaea; paana mo i aigorayao, eo isi maenayao se aiaisega debadi eai, arinai i hetaladuidi. ");
INSERT INTO swp_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","I hetamaridi, Ioane numa masigiri eai gadona se tom. ");
INSERT INTO swp_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ia uruuruna gaeba alona eai se leama se mosei siu wa arinai: ia abo i laei sinana arinai. ");
INSERT INTO swp_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ioane ena heaheatayao se laoma eaibarabarana se laei, se tore, abo se lau Iesu se heriba. ");
INSERT INTO swp_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iesu wasana i ataiei, nei eai i gerugabaei, i lau malatupama eai: ena lau wa tatao se ataiei, eanua se laugabaedi, ia se lauwatai. ");
INSERT INTO swp_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Iesu i lagema, moutuana lailai i itadi, i nuatoatoaidi, isi enadi tauasiasiebo i hemauridi. ");
INSERT INTO swp_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","I maimailahio abo ena heaheatayao se laoma ia arinai, si ene, “Malatupama ina, huiana i lauo: moutuadi ta u hetamaridi se laugorigori, se lau gougou headi aridi eai, aiai adi se uneune.” ");
INSERT INTO swp_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Iesu i heribadi, i ene, “Se lau se saha: aiai adi au mosedi.” ");
INSERT INTO swp_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ia se heriba, si ene, “Ina ama falawa haligigi mo, eo eama labui.” ");
INSERT INTO swp_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","I ene, “Au ledima arigu eai.” ");
INSERT INTO swp_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Moutuana wa i hetaladuidi se bawabigabiga lei potana eai. Falawa haligigi eo eama labui wa i abidi i itasae galewa eai i aihelahui, i ihidi, abo falawa wa i mosei ena heaheatayao aridi eai, isi abo se mosei tatao moutuana wa aridi eai. ");
INSERT INTO swp_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Isi gamagamagari se aiai, e bogadi se sese, mapuradi, se tanogogoidi bosa saudoudoi‐labui se monau. ");
INSERT INTO swp_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Isi tauaina nuana tatao tausani haligigi, sisine eo merumeru nige se hasiriesegaidi. ");
INSERT INTO swp_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Arinai abo Iesu ena heaheatayao i lauhesomdi bena waga eai abo se geru, se baguna hari sana awasi eai: ia moutuana lailai wa abo i hetamarigorigoridi. ");
INSERT INTO swp_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","I hetamarigorigoridio abo i dalasae oea esau arinai, i lausuara i lau‐uura; i maimailahi iabom nei eai. ");
INSERT INTO swp_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Waga wa gabogabo awaawasina eai wowori i hetahetaipiledi: mana i loaoa. ");
INSERT INTO swp_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Maiona boeana eai, mahana hasi, Iesu ie lau isi aridi eai, gabogabo potana eai ie lau. ");
INSERT INTO swp_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ena heaheatayao ia se ita i laulau gabogabo potana eai, aruadi se loi, si ene earuyarua esau nei: se matausi, se eabayaba. ");
INSERT INTO swp_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Arinai Iesu i heribalaedi, i ene, “Nuamiu se taru: eau ede, tabu au matausi.” ");
INSERT INTO swp_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petero ia arinana i heuio, i ene, “Guiau e, taba oa ede, u ribama abo ea laowa gabogabo potana eai.” ");
INSERT INTO swp_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","I ene, “U laoma.” Petero waga abo i pesagabaei, i laulau gabogabo potana eai, i lau Iesu arinai. ");
INSERT INTO swp_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ia mana lailai ie ita i matausi: abo i sariri, ie eaba, i ene, “Guiau e, u hemauriguma.” ");
INSERT INTO swp_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Arinai abo Iesu nimana i helelelaei, i abiisini, i ribalau ia arinai, i ene, “Oa nige u sunumaegu, ue saha nuam i ponoponousi?” ");
INSERT INTO swp_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Isi abo se lage waga eai, mana wa ie motu. ");
INSERT INTO swp_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Isi waga taugeruina ia se aihelahui, si ene, “Mamohoi, oa Eaubada Natuna ede.” ");
INSERT INTO swp_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Isi abo se duna hari sana awasi eai, se lage Genesereta oeana eai. ");
INSERT INTO swp_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nei eanua ne tataodi ia se nuatui, abo se lau hetamari se lau gougou gamagari aridi eai, tatao asiasiebo gamagamagari se laedi ia arinai. ");
INSERT INTO swp_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Isi ia se nuaoini bena ana lulu dedeana se abiita mo: gamagaridi hinage se abiitalaei abo se mauri. ");
INSERT INTO swp_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tauuriuri eo Parisea headi, Ierusalema tataodi, abo se laoma Iesu arinai, si ene, ");
INSERT INTO swp_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Mumuga tataodi edi riba em heaheatayao se saha se utusidi? Isi aiai se ai nige se nima deuri.” ");
INSERT INTO swp_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Iesu i ribalau isi aridi eai i ene, “Hinage aue saha emi riba mo aridi eai Eaubada ena laugagaeo au utusi? ");
INSERT INTO swp_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Paana ede Eaubada i hetaladui i ene, ‘Tamam eo sinam u taubigaidi’ (Ex. 20.12) eo hinage i ene, ‘Ia ena tamana eo sinana i arina baaeaidi ia abo i mate’ (Ex. 21.17). ");
INSERT INTO swp_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Omi au ene, ‘Taba esau, eo esau tamana eo sinana i heriba i ene, Ainauiana, ginauri saha eo saha bena au abidi arigu eai wa, eo ");
INSERT INTO swp_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","tamana eo sinana nige i taubigaidi, i lolo hinage.’ Emi laulau mo aridi eai Eaubada ena laugagaeo au hetaupurupurudi. ");
INSERT INTO swp_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Omi tataoboraborasom, Isaia i ribaperovetamamohoiemiu, i ene: ");
INSERT INTO swp_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Teina tatao ta sopadi eai mo se hedebasaegu: isi nuadi se lausuaraaririegu. ");
INSERT INTO swp_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Se aihelahu‐gaibuigu mo, tatao edi riba eo edi lau‐gagaeo se laulauheataedi’” ");
INSERT INTO swp_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Moutuana i eogalaedi i heribadi, i ene, “Au ataiei, eo au nuatui: ");
INSERT INTO swp_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Taba tau ginauri i toresaei awana eai taba nige i hebaaea: ginauri awana eai i lulagema meta tauhebaaeana ede.” ");
INSERT INTO swp_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ena heaheatayao se laoma ia arinai si ene, “U itayao teina riba ta Parisea se ataiei na se ouealayala?” ");
INSERT INTO swp_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ia i heribadi i ene, “Oeagi gamagaridi Tamagu nige i umaidi, abo se laahaidi. ");
INSERT INTO swp_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Se otawa taumatagibugibu ma heledi taumatagibugibu se woeaidi. Taba taumatagibugibu ma helena taumatagibugibu i woeai abo se beulabulabui hua eai.” ");
INSERT INTO swp_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petero ia arinana i heuio i ene, “Teina parabole ta u ribahasahasaimai.” ");
INSERT INTO swp_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Iesu i ene, “Omi hinage ma nuaponoponomiu mo? ");
INSERT INTO swp_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Sora nige abina aue ata ginauri esadi au toresaedi awamiu eai se dobi bogamiu eai abo au tarugabaedi. ");
INSERT INTO swp_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nei ginauridi ne tau awana eai se lulagema nuana eai se tubuma: isi mo tau wa se hebaaea. ");
INSERT INTO swp_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Paana ede nuatu baaeadi, eo aiaiunudi, eo ganaganawaridi, eo laulau niginigidi, eo aiaiyaharidi, eo ribaribagewadi, eo eaubada arinabaaeaina nua eai se saema. ");
INSERT INTO swp_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Teina ginauridi ta tau aba hebaaeana ede; na taba aiai se ai mo nige se nimadeuri, meta tau aba hebaaeana nige’e.” ");
INSERT INTO swp_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iesu nei dimo ne i laugabaei, ie lau Turo eo Sidona edi teha eai. ");
INSERT INTO swp_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nei tehana eai ne Kanana sinena esau i laoma ia arinai i eabayabaei i ene, “Guiau Davida natuna e, u nuatoatoaiguma: natugu siu diabolo esau i heouyalayalaei.” ");
INSERT INTO swp_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nige riba esau arinai sine wa arinana i heuio. Ena heaheatayao se laoma ia se nuaoini, si ene, “U aiduiei, i eabayabasom murida eai.” ");
INSERT INTO swp_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Isi arinadi i heuio i ene, “Se hetamariguma inai, boga Isaraela edi mamoe tautauyamui hesabadi mo.” ");
INSERT INTO swp_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Sine wa abo i laoma ia aena eai i gurisalaoba, i aiboda, i ene, “Guiau e, u saguigu.” ");
INSERT INTO swp_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iesu ia i heriba i ene, “Nige i dudurai merumeru adi falawa se abi se gabalaei kedewa aridi eai.” ");
INSERT INTO swp_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ia abo i ene, “Guiau e, mamohoi; taiede falawa mapuradi tanuagadi edi hatahata eai se beu, kedewa hinage se aiaidi.” ");
INSERT INTO swp_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Iesu ia arinana abo i heuio i ene, “Sine e, em sunuma i lai ariri: ginauri wa u gadosisiei wa abo u abiheohi.” Arinai abo ia natuna wa i mauri. ");
INSERT INTO swp_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nei tehana ne Iesu i laugabaei, Galilaia gabogabona hanahanauna eai ie lage: abo i dalasae oea esau eai, nei eai i bawabigabiga. ");
INSERT INTO swp_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Moutuadi lailai se laoma ia arinai, tatao laulaudaedi, eo tatao matagibugibudi, eo tatao unaunadi, eo tauaiaiiwala, eo hari asiebo, hari asiebo gamagaridi, hinage se woeaidima Iesu aena eai se hebawadi, ia abo i hemauridi. ");
INSERT INTO swp_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Arinai ede moutuadi wa se nooei, paana ede matadi eai tatao unaunadi se riba, eo tatao aiaiiwaladi se lolo, eo tatao laulaudaedi se lau toditodi, eo tatao matagibugibudi matadi se lala: isi Isaraela edi Eaubada abo se hedebasae. ");
INSERT INTO swp_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Iesu ena heaheatayao i eogaidima, aridi eai i ene, “Moutuana ta ea nuatoatoaidi isi asubena haiona arigu eai se mia, nige adi aiai: taba nige ea hetamaridi ma aiwesaridi, ata eda eai se aitu.” ");
INSERT INTO swp_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ena heaheatayao se ribalau ia arinai si ene, “Ina malatupama eai ta, haedi aiai gamagaridi abaabina, moutuana lailai ta abo ta hebogasesedi?” ");
INSERT INTO swp_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Iesu i ribalau isi aridi eai i ene, “Ami falawa wa hisa?” Si ene, “Haligigi‐labui mo, eo eama gagiridi hisahisadi mo.” ");
INSERT INTO swp_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Moutuana i hetaladuidi abo tano eai se bawabigabiga. ");
INSERT INTO swp_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Falawa haligigi‐labui, eo eama wa i abidi, i aihelahui, i ihidi, ena heaheatayao aridi eai i mosedi, ena heaheatayao hinage se mosedi moutuana wa aridi eai. ");
INSERT INTO swp_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Isi gamagaridi se aiai, e bogadi se sese: aiai mapurana se tanogogoi, bosa haligigi‐labui se usahemonaudi. ");
INSERT INTO swp_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Isi tauaina tatao tausani hasi, sisine eo merumeru hinage nige se hasiridi. ");
INSERT INTO swp_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Moutuana abo i hetamaridi, ia abo ie geru, ie lau Magadala oeana eai. ");
INSERT INTO swp_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisea eo Sadukea hinage abo se laoma ia se nohoi, si ene galewa heiheinoina bena abo i heitadi. ");
INSERT INTO swp_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ie ribalau isi aridi eai, i ene, “Maimailahi eai, au ene, ‘Abo i siwaro’: paana ede i aitala sabesabe. ");
INSERT INTO swp_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Eo maratomtom eai, au ene, ‘Wau ta abo ania i eabatutu’: paana ede ania i baaea. Omi tau boraborasom, galewa matana au nuatuiyao; na huiadi heiheinoidi abidi nige aue ata? ");
INSERT INTO swp_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Isi baaeana, eo isi ganaganawarina heiheinoina se eooi; heiheinoina taba nige se mosei aridi eai, na Iona peroveta, ia heiheinoina mo.” Ia abo i laugabaedi, i lau. ");
INSERT INTO swp_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ena heaheatayao se duna hari sana avasi eai, adi falawa nuadi se huiedi. ");
INSERT INTO swp_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Iesu i heribadi i ene, “Parisea eo Sadukea edi yeast au nuatui, au komakomanini.” ");
INSERT INTO swp_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Isi se heunaboisaha si ene, “Ena riba paana ede falawa wa nige ta abidima. ");
INSERT INTO swp_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Iesu edi nuatu i nuatuiyao, i heribadi, i ene, “Emi sunuma i gagiri, aue saha au heunaboisahausi, paana falawa nige au abidima? ");
INSERT INTO swp_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Omi sora abina nige au ata, sora nige au nuatui hinage, falawa haligigi eo tatao tausani haligigi eo bosa hisa au hemonaudi wa? ");
INSERT INTO swp_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Falawa haligigi‐labui, eo tatao tausani hasi, bosa hisa au tanogogoidi wa? ");
INSERT INTO swp_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Aue saha nige au nuatui egu riba ta nige falawa ribana, Parisea eo Sadukea mo edi yeast bena au komakomanidi?” ");
INSERT INTO swp_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Arinai abo nuadi se taigari, falawa ena yeast wa nige i ribaei bena se komakomanini, Parisea eo Sadukea mo edi laulauheata. ");
INSERT INTO swp_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iesu Kaisaria Pilipi ana siga eai i laoma, i oimurilau ena heaheatayao aridi eai, i ene, “Eau, Tau Natuna, tatao si ene eau eai?” ");
INSERT INTO swp_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Si ene, “Headi si ene Ioane Bapatiso eo headi si ene Elia, headi hinage si ene Ieremia, e peroveta wa esau.” ");
INSERT INTO swp_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","I ribalau aridi eai, i ene, “Omi au ene eau hede eai?” ");
INSERT INTO swp_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simona Petero ia arinana i heuio i ene, “Oa Keriso Eaubada maumaurina Natuna.” ");
INSERT INTO swp_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Iesu i ribalau ia arinai i ene, “Simona Ba‐Iona e, oa u lolo! Teina ta buluma dobilana eai nige se hemasaraha arim eai, na Tamagu mo galewa eai ie mia, teina ta i hemasaraha arim eai. ");
INSERT INTO swp_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ea heribam ta hinage, oa Petero, teina we’u ta potana eai egu ekalesia abo ea hetoro; mate gigiboridi taba nige se heguri. ");
INSERT INTO swp_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Galewa basileia kina abo ea lediwa saha eo saha tanoubu eai ta u audi, galewa eai hinage abo se audi: saha eo saha tanoubu eai ta u eairihaidi, galewa eai hinage abo se earihaidi.” ");
INSERT INTO swp_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ia ena heaheatayao awadi abo i tawaidi isi tabu tau esau se heriba si ene ia Iesu, Kerisona. ");
INSERT INTO swp_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nei huiana ne Iesu ena heaheatayao i ribahasahasainonohaidi, ia abo i lau Ierusalema eai, babada eo kohena babadadi, eo tauuriuri tataodi nimadi eai baaea gamagaridi abo i hearodi, abo hinage se unuhemate, na asubena hehaionana eai abo i torouio. ");
INSERT INTO swp_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petero Iesu abo i laehesuara, ia i ribasuui, i ene, “Guiau e, Eaubada matana eai taba nige’e! meta taba nige u hearodi.” ");
INSERT INTO swp_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","I sinibui i ribalau Petero arinai, i ene, “Oa Satani, u lau murigu eai, u guduguduigu ta, Eaubada ena nuatu nige u nuatuidi, tatao edi nuatu mo u nuatuidi.” ");
INSERT INTO swp_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Iesu abo i ribalau ena heaheatayao aridi eai, i ene, “Ena tau esau bena i hemuriwataigu, iabom i nuagabaeuioi, ena satauro i abiisini, i lauwataigu. ");
INSERT INTO swp_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Taba esau bena i mauri, ia maurina i nuatugabaei: taba esau debagu eai ia maurina i nuatugabaei, mauri wa abo i lobai. ");
INSERT INTO swp_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tau esau abo saha i abi, taba tanoubu ginauridi i abiheohidi, ia nuana mo abo i mate? Eo aisana abo i mosei ia maurina maisana? ");
INSERT INTO swp_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tau Natuna Tamana ana tepo saesaena eai abo i laoma, eo maena aneruyao hinage, tatao gamagaridi, esau eo esau se lolo, e se baaea, abo i hemaisadi, i hegonoahidi. ");
INSERT INTO swp_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mamohoi ea heribamiu ta, headi inai se totoro, mate sora taba nige se hearo, i lau e Tau Natuna se ita ena basileia eai i laoma.” ");
INSERT INTO swp_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Asubena haligigi‐esega se ohi, Iesu Petero eo Iamesi, eo ena tau Ioane i woeaudoiedi, se sae oea deba pogana eai. ");
INSERT INTO swp_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Isi matadi eai ie ori: ana ao udoi, matana i namanamari doha mahana, eo ana lulu se posiposi, doha marana. ");
INSERT INTO swp_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Arinai abo Mose, eo Elia se taumasaraha maedi se ribariba. ");
INSERT INTO swp_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petero i ribalau Iesu arinai, i ene, “Guiau e, i lolo inai mo ta mia: ena u henua apa haiona inai ta abidi: esau enam, esau Mose enana, eo esau Elia enana.” ");
INSERT INTO swp_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ina doha ena ribariba, abo eada namanamarina esau i poiitawaidi: arina esau eada boeana eai laoma i ene, “Natuyogoyogoigu ede teina, nuagu i helolo; ia au ataiei.” ");
INSERT INTO swp_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Heaheatayao riba wa se ataiei, se guridobi se debatutu tano eai, se matausi ariri. ");
INSERT INTO swp_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Iesu abo i laoma i abiisinidi, i ene, “Au torohai, tabu au matausi.” ");
INSERT INTO swp_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Isi matadi se helabaisinidi, nige tau esau se ita, Iesu mo iabom. ");
INSERT INTO swp_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Abo oea eai wa se leta se dobi, Iesu awadi i tawaidi, i ene, “Wau ginauri wa tabu tau esau au heriba, i lau e, Tau Natuna mate eai se hetorouioi.” ");
INSERT INTO swp_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ena heaheatayao se oimurilau ia arinai si ene, “Tauuriuri se saha si ene Elia taba i lagebagunama?” ");
INSERT INTO swp_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Iesu i ribalau isi aridi eai i ene, “Mamohoi, Elia abo i lagebagunama, abo hinage ginauri gamagamagari i heharihariudi. ");
INSERT INTO swp_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Na ea heribamiu ta, Elia i lagenonohamao, ia nige se nuatui, ia arinai, edi nuatu aisana, aisana se lauwataiyao. Doha ede hinage Tau Natuna abo nimadi eai se heamamna.” ");
INSERT INTO swp_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ena heaheatayao se nuatui Ioane Bapatiso ribana wa i heribadi. ");
INSERT INTO swp_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Abo se lulage moutuana aridi eai, tau esau i laoma ia arinai, i turibono, i ene, ");
INSERT INTO swp_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Guiau e, natugu tau u nuatoatoai: i auaulea, eo amnana i baaea ariri: huia gamagari ie guri oeagi alaalasina eai, eo huia gamagari i beu goila eai. ");
INSERT INTO swp_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ea woeaiama em heaheatayao aridi eai bena se abihemauri, nige abina se ata.” ");
INSERT INTO swp_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Iesu arinana i heuio i ene, “Omi isi ta au supusupu, eo au awayagara, huia lohaloha eau maemiu wa? eo huia lohaloha ea taubigaimiu wa? Ia au woeaiama arigu eai.” ");
INSERT INTO swp_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Iesu demoni i ribadebapogai, abo i lulage murimuri eai: gama wa nei awa ne arinai abo i mauri. ");
INSERT INTO swp_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ena heaheatayao abo se laumahimahihi se lau Iesu arinai, si ene, “Ie saha aiduiena nige abina ai ata?” ");
INSERT INTO swp_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Iesu i ribalau isi aridi eai i ene, “Paana nige au sunuma adidiri: mamohoi ea heribamiu ta ena emi sunuma au abi doha sinapi tumana esau, abo au ribalau teina oea ta arinai au ene, ‘U lau nei dimo eai,’ abo hinage i lau: taba nige ginauri esau abo au hekau. ");
INSERT INTO swp_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Teina doha uura eo aiudi aridi eai mo ta aiduiedi.” ");
INSERT INTO swp_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Isi se oioigogo Galilaia eai Iesu i ribalau aridi eai i ene, “Tau Natuna tatao nimadi eai abo se heabimosei. ");
INSERT INTO swp_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Arinai abo ia se unui, asubena hehaionana eai abo se hetorouioi.” Ena heaheatayao se nuadubu ariri. ");
INSERT INTO swp_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Se lage Kaperenauma eai takisi monina taupeigogoi se laoma Petero arinai, si ene, “Ami tanuaga takisi hinage abo i tore?” ");
INSERT INTO swp_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","I ene, “E.” Ia i awasaema numa‐alo eai Iesu i riba baguna i ene, “Simona e, em nuata saha? Tanoubu wasawasadi aidobudi aridi eai edi takisi monina se abi, nanatudiyao mamohoi aridi eai, e hari dodoga aridi eai?” ");
INSERT INTO swp_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petero i ene, “Hari dodoga aridi eai.” Iesu ia i heriba i ene, “Mamohoi, nanatudiyao mo nige’e. ");
INSERT INTO swp_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Taiede, ata ta henuaponoponodi, u lau gabogabo eai auri u tudobei, em eama u atuibagunai u abi: awana u gasi, moni esega abo u lobai: meta u laei u mosei aridi eai, enagu, eo enam.” ");
INSERT INTO swp_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Arinai abo ena heaheatayao se laoma Iesu arinai si ene, “Galewa basileiana eai, eai, abo i sae ariri?” ");
INSERT INTO swp_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Iesu merumeru gagirina esau i eogai, i hebawa boeadi eai. ");
INSERT INTO swp_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","I ene, “Mamohoi, ea heribamiu ta, ena nuamiu nige au buidi, eo ena nige au hemala merumeru gagiridi hinage, galewa basileiana taba nige au lusora arinai. ");
INSERT INTO swp_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Taba esa, eo esa, i nuatudobidobiuioi doha ina merumeru ta, ia abo i sae ariri galewa basileiana eai. ");
INSERT INTO swp_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Ena eai eo eai, esau doha ina merumeru gagirina ta esagu eai i oiami, iaede i oiamigu hinage. ");
INSERT INTO swp_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Teina merumeru gagiridi tausunumaegu wa eai eo eai esau i healabesibesi, i lolo taba we’u lailai ia gadona eai se au, abo se heputuhai gabotum eai. ");
INSERT INTO swp_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Kapore tanoubu, paana aba‐alabesibesina: alabesibesi taba se tubu, abo ahani tau wa arinai alabesibesi se tubu, kapore ia! ");
INSERT INTO swp_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Arinai ena nimam e aem se healabesibesim, u tomhaidi, u gabahesuaradi, i lolo ma laulaudaem eai, eo ma nimakuukuum eai, mauri u abi, ena nimam labui eo aem labui se tudobem oeagi alaalasina boeana eai, i lau e nige nosina. ");
INSERT INTO swp_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Eo ena matam i healabesibesim u lamohai, u gabahesuara: i lolo matam esega mauri u abi, ena matam labui abo se tudobem gehena oeagi alaalasina eai. ");
INSERT INTO swp_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Au komakomanimiu, merumeru gagiridi tabu esau au isuewaei: ea heribamiu ta, galewa eai isi anerudi Tamagu galewa eai ia matana huia gamagari se ita. ");
INSERT INTO swp_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“Tau Natuna i laoma isi se tautauyamui bena i hemauridi. ");
INSERT INTO swp_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Emi nuatu au ene edoha? Tau esau ena mamoe tatao‐haligigi‐se‐mate, esega ie gege, tau wa mamoe tatao‐hasi‐se‐mate‐saudoudoi‐haligigi‐hasi i laugabaedi, e nige’e wa, esau ie gege wa oea tupina eai i eooi? ");
INSERT INTO swp_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mamohoi ea heribamiu ta wau mamoe wa taba ena i lobai, arinai abo i kode ariri, mamoe tatao hasi‐se‐mate‐saudoudoi‐haligigi‐hasi nige se gege wa, nige i kodedaoiedi. ");
INSERT INTO swp_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Doha ede Tamamiu galewa eai ena nuatu i ene, Teina merumeru gagiridi ta tabu esau i tauyamui. ");
INSERT INTO swp_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Hinage ena em tau i hebaaeam, u lau ia arinai, ia eo oa, omibom mo, abo ena baaea u ribahasahasai: ena em riba i ataiei, em tau u hebiga. ");
INSERT INTO swp_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ena nige i ataiei, tau esega, e tatao labui maemyao au lau, tauribataubiga tatao labui, e haiona awadi eai riba gamagaridi se hemamohoiedi. ");
INSERT INTO swp_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ena edi riba hinage i awayagaraei abo ekalesia u heribadi: ena ekalesia edi riba nige i ataiei, taiede, nuam eai i hemala etene, eo i hemala telona. ");
INSERT INTO swp_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Mamohoi ea heribamiu ta, saha eo saha tanoubu eai ta au audi, galewa eai hinage abo se audi: saha eo saha tanoubu eai ta au eairihaidi, galewa eai hinage abo se eairihaidi. ");
INSERT INTO swp_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Arimiu eai ea ribauioi ta, ea ene, ena taumi labui tanoubu eai, nuamiu lelena esega ginauri esana au aibodai, Tamagu galewa eai abo i leawa. ");
INSERT INTO swp_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ena labui, haiona, taba se oigogoesega eau esagu eai, eau metai isi boeadi eai.” ");
INSERT INTO swp_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Petero abo i laoma ia arinai i ene, “Guiau e, egu tau ma‐hisa i hebahebaaeagu, eo ena baaea ea nuatugabaei? Ma‐haligigi‐labui?” ");
INSERT INTO swp_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Iesu i heribalaei i ene, “Ea heribam ta nige ma‐haligigi‐labui mo: ea ene ma‐tatao‐haiona‐se‐mate‐saudoudoi‐haligigi‐labui. ");
INSERT INTO swp_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Galewa basileiana doha ede eanua wasawasana esau ena tatao paisoa edi buka ginauridi i hesioidi. ");
INSERT INTO swp_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","I lau hesioidi, abo esau i laoma ia arinai, ana hagahaga taleni tausani saudoudoi nige i hemaisadi. ");
INSERT INTO swp_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ia nige ena gogo, arinai tanuagana i lauhesomdi tau wa se une, monena hinage, eo nanatunayao. eo ena ginauri gamagaridi, wau maisana wa. ");
INSERT INTO swp_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Taupaisoa wa i guridobi ia i tabaohui i ene, ‘Guiau e, agutoi, sora nuam i taru abotai abo ea hemaisaheohidi.’ ");
INSERT INTO swp_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tanuagana taupaisoa i nuatoatoai, abo i eairigabaei, eo ena buka wa i hedudurai mo. ");
INSERT INTO swp_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Wau taupaisoa wa, ie pesa murimuri eai, helena taupaisoa esau i lobai denari tatao‐haligigi‐se‐mate i mosehagahagaidi: ia i toai, gadona i lamosi, i ene, ‘Am haga wa maisadi u ledima.’ ");
INSERT INTO swp_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Helena taupaisoa i guridobi aena eai, i ribagadogadora ia arinai i ene, ‘Sora nuam ie taru abotai abo ea hemaisaheohidi.’ ");
INSERT INTO swp_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ia nige i ataiei i lau i heduiahalai numa masigiri eai, i lau e ana haga wa i hemaisadi. ");
INSERT INTO swp_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Helena taupaisoa tataodi wau laulau wa se ita nuadi se baaea ariri, se laoma ginauri gamagaridi adi tanuaga wa se heriba. ");
INSERT INTO swp_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ana tanuaga ia i eogai i ribalau ia arinai i ene, ‘Oa taupaisoa baaea e, am haga wa gamagaridi ea nuatugabaedi paana ede u awanorigu. ");
INSERT INTO swp_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Helem taupaisoa hinage ue saha ia nige u nuatoatoai, doha hinage eau ea nuatoatoaim ta?’ ");
INSERT INTO swp_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ana tanuaga i ouealayalaei abo i moselaei tauheamamna aridi eai i lau e ana haga i hemaisaheohidi. ");
INSERT INTO swp_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Hinage nei doha, Tamagu galewa eai abo i abi omi arimiu eai, esa to esa, ena nuam eai em tau ena baaea, esau eo esau, nige u nuatugabaedi.” ");
INSERT INTO swp_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","E, abotai Iesu wau riba wa i ribalautom, Galilaia i laugabaei, abo i laoma Iudea ana sigasiga eai, Ioridano hari teha eai. ");
INSERT INTO swp_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Moutuadi lailai ia se hemuriwatai: nei eai i hemauridi. ");
INSERT INTO swp_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Parisea hinage se laoma ia arinai, ia se nohoi, se ribalau ia arinai si ene, “Laugagaeo si ene edoha, tau, hari mata hari mata aridi eai, monena abo i inavasei, e nige’e?” ");
INSERT INTO swp_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","I ribalau aridi eai i ene, “Omi nige au hasiri si ene ia wa huia hetubudi eai i ginauridi, tau eo sine i ginauridi. ");
INSERT INTO swp_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Eo i ene, ‘Arinai ede tau tamana eo sinana abo i laugabaedi, abo i patulau monena arinai: isi taudi labui abo bulumadi esega mo?’ ");
INSERT INTO swp_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Arinai isi labui nige’e, isi buluma esega mo. Arinai ede, saha Eaubada i hepatuesegai tabu tau esau i abihesuaradi.” ");
INSERT INTO swp_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Isi ia si heriba si ene, “Na Mose ie saha i lauhesomdi i ene, inawasei pepana se abi abo sine wa i inawasei?” ");
INSERT INTO swp_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ie ribalau aridi eai i ene, “Nuamiu se oiura ariri, arinai Mose ie eari, monemiuyao abo au inawasedi: na huia bagubaguna eai wa nige doha nei. ");
INSERT INTO swp_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Hinage ea heribamiu ta, ea ene, eai eo eai monena i inawasei sine esau abo i tawasorai, ia i ganawari: eo eai eo eai sine se inawasei wa i tawasorai, ia hinage i ganawari. Taba sine i ganawari, taiede, taba se inawasei.” ");
INSERT INTO swp_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ena heaheatayao ia se heriba si ene, “Ena tau monena arinai doha nei, tawasora nige i lolo.” ");
INSERT INTO swp_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ia i heribadi i ene, “Tatao gamagari nige abina se ata riba ta se abi, isibom mo enadi, aridi eai se mosei. ");
INSERT INTO swp_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Headi sinadiyao bogadi eai isi eunauka: headi tatao se heeunaukadi: headi hinage, galewa basileiana debana eai isibom nuadi se eunauka. Taba esau abina i ata riba ta i abi, abo i abi.” ");
INSERT INTO swp_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Abo merumeru gagiridi se woeaidima ia arinai bena nimana i toresaedi potadi eai, eo i lau‐uura: na ena heaheatayao se ribamataedi. ");
INSERT INTO swp_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Iesu i ene, “Merumeru gagiridi au eari se laoma arigu eai, tabu au guduguduidi: galewa basileiana doha isi ede.” ");
INSERT INTO swp_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nimana i toresaedi potadi eai, nei dimo ne abo i laugabaei. ");
INSERT INTO swp_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Esau abo i laoma ia arinai i heriba i ene, “Tauheaheata lolona e, laulau lolona esana abo ea abi, arinai abo ea mauri nige nosina?” ");
INSERT INTO swp_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ia i heriba i ene, “Ue saha u awanorigu? Nige esau i lolo, esega mo, ia ede Eaubada: taba u ene bena u lage mauri boeana eai, laugagaeo u sogohididini.” ");
INSERT INTO swp_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ia arinai i ene, “Aitea?” Iesu i, ene, “Tabu u aiunu, Tabu u ganaganawari, Tabu u aiaiyahari. Helem taumia tabu u hegirugaibui. ");
INSERT INTO swp_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Tamam eo sinam u eogoeogoidi: eo Helem taumia u gadosisiei doha oabom u gadosisiuioim.” ");
INSERT INTO swp_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Hewari wa i ribalau ia arinai i ene, “Ma‐hewarigu eai wa i laoma ina ta, teina ginauri gamagaridi ea nanabuheohidio: ginauri esana ea hedeha?” ");
INSERT INTO swp_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iesu i ribalau ia arinai i ene, “U henua u lolo esegaim u lau em gogo gamagaridi u unegabagabaedi, u mosedi gogogesagesa tataodi aridi eai: em gogo galewa eai abo se ota, abo u laoma u hemuriwataiguma.” ");
INSERT INTO swp_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Na hewari wa, teina riba ta i ataiei, i lau‐suara, i nuadubu ariri: paana ede ena gogo se gamagari ariri. ");
INSERT INTO swp_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Iesu abo i ribalau ena heaheatayao aridi eai i ene, “Mamohoi, ea heribamiu ta, taumonamonaune bena i lusora Eaubada ena basileia eai, i hetahetalaahi. ");
INSERT INTO swp_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Hinage ea heribauioimiu ta, ea ene, kamela taba i lusora diu gudana eai, taumonamonaune mo Eaubada ena basileia dobilana eai bena i lusora abo i ahi.” ");
INSERT INTO swp_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ena heaheatayao ina riba ta se ataiei, se noo ariariri, si ene, “Taba nei doha, eai abo i mauri?” ");
INSERT INTO swp_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Na Iesu i ita lau aridi eai, abo i heribadi, i ene, “Tatao nige abina se ata: na Eaubada ginauri gamagamagari abidi ie ata.” ");
INSERT INTO swp_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Petero arinana i heuio i ene, “Ai ginauri gamagamagari ai nuagabaedi, ai hemuriwataim: saha abo ai abi?” ");
INSERT INTO swp_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Iesu i ribalau isi aridi eai i ene, “Mamohoi ea heribamiu ta, omi au hemuriwataiguma wa, huiana eai ginauri se hetubuharihariudi, Tau Natuna ma ana tepo i bawasae ena terona eai, omi hinage abo au bawasae terona saudoudoi‐labui eai, Isaraela adi bogao saudoudoi‐labui abo au heduduraidi. ");
INSERT INTO swp_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Tau esau, eo esau, numa i laugabaedi e, ena tataoyao e, lounayao e, tamana e, sinana e, monena e, nanatunayao e, oea e, eau debagu eai, ginauri gamagaridi taba i abidi, eo mauri nige nosina hinage abo i abi. ");
INSERT INTO swp_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Na gamagaridi headi se bagubaguna abo se murimurita: eo isi se murimurita abo se bagubaguna. ");
INSERT INTO swp_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Galewa basileiana doha ede tau esau ia numa tanuagana, mara‐tomtom eai abo i lau ena oea taupaisoaina i eoogogoidi. ");
INSERT INTO swp_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Taupaisoa headi maenayao nuadi lelena esega si ene asubena esega maisana denari esega, abo i hetamaridi, se lau ena vine gana alo eai. ");
INSERT INTO swp_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Mahana hehaionana eai hinage abo i uio, headi i itadi se totoro gaibu mo abauneune baubauna eai. ");
INSERT INTO swp_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ie ribalau aridi eai i ene, ‘Omi hinage au lau vine gana alo eai, maisana duduraina abo ea lediwa:’ Arinai isi abo se lau. ");
INSERT INTO swp_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Hinage mahana doha hehaligigi‐esegana, eo mahana hehaligigi‐hasina eai, ie uio, ena laulau esega mo nei doha. ");
INSERT INTO swp_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Eo mahana doha hesaudoudoi‐esegana eai abo i uio, headi hinage i itadi se totoro gaibu mo, ie ribalau aridi eai i ene, ‘Aue saha au totoro gaibu mo inai asubena lohaloha ta ie ohi?’ ");
INSERT INTO swp_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ia se heriba si ene, ‘Nige tauhepaisoamai.’ I ribalau aridi eai i ene, ‘Omi hinage au lau vine gana alo eai.’ ");
INSERT INTO swp_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","I maimailahi, vine oeana tanuagana tauitawataina i heriba i ene, ‘Tatao paisoa u eogaidima, edi maisa u mosedi, u hetubu taumurita aridi eai, i lau e taubaguna aridi eai.’ ");
INSERT INTO swp_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Isi mahana doha hesaudoudoi‐esegana eai se eogaidi wa se laoma, esa, eo esa, ena denari esega i abi. ");
INSERT INTO swp_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Isi taubagubaguna wa se laoma, edi nuatu si ene enadi abo se helai; isi hinage denari esega esega mo se abi. ");
INSERT INTO swp_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Isi se abiyao, numa tanuagana abo se gadigadiguguei, ");
INSERT INTO swp_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","si ene, ‘Teina ta taumuritama, mahana esega mo se paisoa, na u hemaisadi u heaigonogonoaimai, ai ai paisoa asubena lohaloha, eo mahana gigiborina eai.’ ");
INSERT INTO swp_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tau wa arinana i heuio i ene, ‘Ehagu e, nige ea boraim, taoda labui ta oiribao, e nige’e, ta ene denari esega mo? ");
INSERT INTO swp_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Enam me u abi, u lau em abalau eai: teina taumurimurita ta abo ea mosei doha hinage ea leawa. ");
INSERT INTO swp_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Eaubom egu ginauri taba nuagu abo ea lauwatai e nige’e? Matam se baaea paana egu abi se lolo?’ ");
INSERT INTO swp_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Taiede isi taumurimurita abo se bagubaguna, isi taubagubaguna abo se murimurita: gamagaridi se eogaidi, hisahisawaidi mo se abihilehileidi.” ");
INSERT INTO swp_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Iesu i sae Ierusalema, dobila eai ma launa heaheata saudoudoi‐labui i woeahesuaradi, i heribadi, ");
INSERT INTO swp_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","i ene, “Ta sae Ierusalema eai: Tau Natuna abo se heabimosei kohena lailaidi eo tauuriuri nimadi eai, abo se hegirunonohai abo i mate. ");
INSERT INTO swp_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ia abo se mosei Murimuri‐tataodi nimadi eai, abo se talatalawasiei, eo se pidiri, eo se hesatauro: asubena hehaionana eai abo i torouio.” ");
INSERT INTO swp_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sebedaio nanatunayao sinadi, nanatunayao labui maenayao abo se laoma Iesu arinai, i tabaohu ia arinai, ginauri esau i aiboda‐gadogadolaei. ");
INSERT INTO swp_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Iesu i ribalau ia arinai i ene, “Saha u henua?” Ia arinai i ene, “Em basileia eai, taba u riba, nanatuguyao labui ta esau nimatutum eai i bawa, eo esau nimaseuseurim eai.” ");
INSERT INTO swp_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Iesu i heuio i ene, “Au aiboda gaibu, nige au nuatui. Bia wa ea nonom ta, omi abina au ata au nom, eo bapatiso arinai se hebapatisoigu abo hinage se hebapatisoimiu wa?” Ia se heriba si ene, “Gonoamai.” ");
INSERT INTO swp_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ia abo i heribadi i ene, “Mamohoi egu bia wa abo au nom, bapatiso arinai se hebapatisoigu abo omi se hebapatisoimiu hinage: na nimatutugu eai se bawa, eo nimaseuseurigu eai, meta eau enagu nige’e, bena ea mosegaibui mo: headi, isibom enadi Tamagu i abinonohaiyao.” ");
INSERT INTO swp_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Saudoudoi wa se ataiei, taudi labui wa se ouyalayalaedi. ");
INSERT INTO swp_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Iesu i eogaidi i ene, “Au itayao Murimuri‐tataodi edi wasawasa tatao se lauhearidi, eo isi tatao babadadi hinage se lauhesomdi. ");
INSERT INTO swp_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tabu omi doha nei: esa, eo esa bena i saetawatawaimiu, ia abo enamiu taupaisoa eai i lau. ");
INSERT INTO swp_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Taba esa, eo esa bena abo emi bada, ia abo enamiu tauheaheari eai i lau. ");
INSERT INTO swp_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Doha hinage Tau Natuna nige i laoma bena ia se bobodiei, iabom mo tatao i bobodiedi, eo ena mauri i torehebiga tatao gamagaridi maisadi.” ");
INSERT INTO swp_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ieriko se laugabaei moutuana lailai ia se hemuriwatai. ");
INSERT INTO swp_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Taumatagibugibu labui se babawa dobila hasarina eai, isi wasana se ataiei Iesu i baeawaidi, se eogalau ia arinai si ene, “Guiau e, oa Davida natuna e, u nuatoatoaimai.” ");
INSERT INTO swp_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Moutuana wa se ribasuuidi si ene, “Au monou:” na se eogalailai si ene, “Guiau e, oa Davida natuna e, u nuatoatoaimai!” ");
INSERT INTO swp_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iesu abo i tarutoro i eogalau aridi eai, i ene, “Omi nuamiu saha, abo ea sahaimiu?” ");
INSERT INTO swp_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Si ene, “Guiau e, bena matamai se lala.” ");
INSERT INTO swp_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","To Iesu i nuatoatoaidi matadi i abiitadi: matadi ma‐esega abo se lala, abo ia se hemuriwatai. ");
INSERT INTO swp_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Isi Ierusalema se hanahanaui, Betepage eai se lage, Oliveta oeana eai, Iesu ena heaheatayao labui i hetamaridi. ");
INSERT INTO swp_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Aridi eai i ene, “Au lau meta eanua matamiu eai me, au lage asini esau se auiao abo au lobai, ma natuna hinage: au eairidi, au woeaidima. ");
INSERT INTO swp_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ena tau esau i ene saha eo saha, abo au ene, ‘Guiau bena i abidi;’ ia ma esega abo i hetamaridi.” ");
INSERT INTO swp_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ina laulau gamagaridi se abidi, riba wa peroveta i ribaei wa abo se tubu, i ene ina doha. ");
INSERT INTO swp_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Omi, Siona natuna siu au heriba, au ene, Hage u ita, em Wasawasa i lagema arim eai, i bulobulou, asini potana eai ie bawa, iaede asini natuna.” ");
INSERT INTO swp_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ena heaheatayao abo se lau, se abi doha Iesu i lauhesomdi wa. ");
INSERT INTO swp_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Asini ma natuna se woeaidima, adi lulu se lauwese potadi eai, ia abo se hebawasae potana eai. ");
INSERT INTO swp_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Moutuadi lailai adi lulu se lauwese dobila eai: eo headi oeagi lagadi se talahaidi hinage, se lauweseauri dobila eai. ");
INSERT INTO swp_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Moutuadi wa se bagubaguna, eo se murimurita, se eogayoga si ene, “Hosana, Davida Natuna arinai. Ia Guiau esana eai i lagema i lolo! Hosana galewa iniinipuripurina eai.” (Psa. 118.25, 26). ");
INSERT INTO swp_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ia Ierusalema eai i lagema, eanua tataodi se taguguohi, si ene, “Ina ta eai?” ");
INSERT INTO swp_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Moutuana si ene, “Ina ede Iesu, ia Nasareta Galilaia perovetana.” ");
INSERT INTO swp_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iesu i awasae Eaubada ena numa tabuna alona eai, tauuneune gamagaridi i aiduiedi, eo moni tauuneheduhedudu edi hatahata i ahalabuidi, isi bunebune tauuneune edi abababawa hinage doha. ");
INSERT INTO swp_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ie ribalau aridi eai, i ene, “Si uriyao, ‘Egu numa esana abo se tore uura numana’ (Is. 56.7): numa wa omi aue abi i hemala tauaiaigirihai edi abaoigogo.” (Iere. 7.11). ");
INSERT INTO swp_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Matagibugibu tataodi eo taulaulaudae se laoma ia arinai numa tabuna eai: ia i hemauridi. ");
INSERT INTO swp_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kohena lailaidi eo tauuriuri ena laulau gigiboridi se itadi eo, merumeru numa tabuna eai se eogayoga si ene, “Hosana, Davida Natuna arinai;” arinai nuadi se baaea ariri. ");
INSERT INTO swp_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Eo se ribalau ia arinai si ene, “Edi ribariba ne u ataiei?” Iesu ie ribalau aridi eai i ene, “Hedeona; omi nige au hasiri, ‘Kaimou eo merumeru madomadodi awadi eai aihelahui abo ea hemamohoi?’” (Psa. 8.2). ");
INSERT INTO swp_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ia abo i laugabaedi, ie lau eanua murimurina eai, ie lau Betania eai; arinai ie eno. ");
INSERT INTO swp_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mara‐ie‐tom ie uio eanua, abo i guriam. ");
INSERT INTO swp_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kuhou esau, dobila hasarina eai ie ita; ie lage arinai, aiaina nige i lobai, lugu ahaahana mo, ie ribalau arinai i ene, “Tabu aiaim i tore, i lau e, ana huia ana tasi.” Nige baeaona kuhou wa abo i wowoea. ");
INSERT INTO swp_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ena heaheatayao se ita se noo, si ene, “Kuhou wa nige eawalana i wowoeaohi!” ");
INSERT INTO swp_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Iesu arinadi i heuio i ene, “Mamohoi ea heribamiu ta, taba au sunuma, eo nuamiu nige se labulabui, omi wau kuhou abiabina wa abo meta doha emi abiabi, eo hinage ena au ribalau teina oea ta tupina arinai, au ene, ‘U lau suara, se tudobem gabogabo eai:’ abo ie tubu. ");
INSERT INTO swp_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ginauri gamagamagari saha eo saha uura eai au aibodaidi ma sunumamiu, abo au abidi.” ");
INSERT INTO swp_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Numa tabuna alona eai kohena lailaidi, eo eanua babadadi sora ma heaheatana na se lagema ia arinai, si ene, “Eai ena gigibori eai teina ginauri ta u ginauridi? Gigibori ta eai i leawa?” ");
INSERT INTO swp_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Iesu arinadi i heuio, ie ribalau aridi eai i ene. “Riba esau abo hinage ea hesio arimiu eai, enagu abo au ribama, abo hinage ea heribamiu teina gigiborina ta eai i leama. ");
INSERT INTO swp_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ioane ena bapatiso haedi ie abi? galewa eai, e tatao aridi eai?” Isi se heunaboisaha si ene, “Ena ta ene galewa eai i dobima, abo i ene, ‘Ie saha hede nige au ataiei?’ ");
INSERT INTO swp_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ena ta ene, ‘Tatao aridi eai,’ tatao ta matausiedi, paana tatao gamagaridi si ene Ioane ia peroveta.” ");
INSERT INTO swp_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Isi Iesu se heuio si ene, “Nige abina ai ata.” Aridi eai i ene, “Eau hinage nige ea heribamiu eai ena gigibori eai ina ginauri ta ea ginauridi. ");
INSERT INTO swp_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Nuamiu au ene edoha? Tau esau ia nanatunayao labui: i laoma taubaguna arinai i ene, ‘Natugu e, wau ta u lau egu oea eai u paisoa.’ ");
INSERT INTO swp_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ia arinana i heuio i ene, ‘Taba nige ea lau:’ abotai nuana ie bui, to abo ie lau. ");
INSERT INTO swp_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","I laoma taumurita arinai hinage, ena riba esega mo. Ia arinana i heuio i ene, ‘Taubada e, abo ea lau,’ to nige i lau. ");
INSERT INTO swp_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Taudi labui aitea tamana ena nuatu i lauwatai?” Si ene, “Taubaguna.” Iesu ie ribalau isi aridi eai i ene, “Mamohoi, ea heribamiu ta ea ene, telona tataodi, eo laulau‐baaea sisinedi Eaubada ena basileia abo se lusorabagunaemiu. ");
INSERT INTO swp_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Na, Ioane laulau‐dudurai dobilana eai i laoma arimiu eai, eo ia nige au sunumaei: telona tataodi eo laulau‐baaea sisinedi ia se sunusunumaei, au itayao, to murina eai nuamiu nige au buidi, ia bena au sunumaei. ");
INSERT INTO swp_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Parabole esau abo au ataiei: Numa tanuagana esau ena vine ganana i umai: i gana hetaiiri, vine abatomna ie sara, numa siwasiwa ie abi, abo i mosei tatao paisoa aridi eai, ia abo i lau eanua esau eda lohaloha eai. ");
INSERT INTO swp_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ena huia ua ie lage, ena heaheari tataodi i hetamaridi tatao paisoa wa aridi eai, oea wa aiaina bena se abidi. ");
INSERT INTO swp_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tatao paisoa ena heaheari tataodi se toaidi, esau se pidiri, eo esau se unui, eo esau se lauwe’ui. ");
INSERT INTO swp_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Abotai abo ena heaheari tataodi gamagaridi headi i hetamaridi: edi laulau esega mo aridi eai. ");
INSERT INTO swp_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Murina eai ia natuna abo i hetamari aridi eai, i ene, ‘Natugu abo se hemataei.’ ");
INSERT INTO swp_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tatao paisoa ia natuna se ita, se oioiriba si ene, ‘Oea tanuagana ede ina; ehei ta unui, ena oea ta abo ta girihai.’ ");
INSERT INTO swp_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ia abo se toai, se gabadioi vine ganana murimurina eai, abo se unuhemate. ");
INSERT INTO swp_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Vine ganana tanuagana abo i laoma, wau tatao paisoa abo i sahaidi?” ");
INSERT INTO swp_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ia arinai si ene, “Tatao baabaaeadi meta abo i unuhematedi, ena oea abo i moselaei hari tatao paisoa aridi eai, isi abo oea aiaina edi huia eai, abo se mosei ia arinai.” ");
INSERT INTO swp_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Iesu i ribalau aridi eai, i ene, “Omi, uriuri eai nige au hasiri wa, si ene, ‘We’u numa tauabidi se otaotaei, ia abo we’u tubeina eai ie lau: Guiau teina ie abi, ta itaitai, eo ta noonooei?’ ");
INSERT INTO swp_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Arinai ea ribalaowa arimiu eai ta, ea ene, Eaubada ena basileia arimiu eai, abo se abiuioi, abo se mosei hari basileia tataodi enadi, isi aiaina mamohoina abo se mosei. ");
INSERT INTO swp_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Eai to eai ina we’u ta potana eai se guridobi abo se tamogorugoru: eai to eai ina we’u ta taba i saidi, abo i hesarurugorigoridi.” ");
INSERT INTO swp_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kohena lailaidi eo Parisea tataodi ena parabole se ataiedi, se nuatulobai isi adi riba. ");
INSERT INTO swp_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ia bena se abilau se toai, moutuana se matausiedi, paana si ene ia peroveta. ");
INSERT INTO swp_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iesu arinadi i heuio i ribaparaboleuioidi i ene: ");
INSERT INTO swp_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Galewa basileiana doha ede wasawasa esau ia natuna abo i hetawasora. ");
INSERT INTO swp_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ena heaheari tataodi i hetamaridi tatao i ribaedi se eogaidi bena se laoma tawasora eai: se awayagara, nige se laoma. ");
INSERT INTO swp_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ena heaheari tataodi headi i hetamariuioidi, i ene, ‘Isi se ribaedi wa au heribadi, au ene, Agu aiai ea abinonohaidi: egu bulumakau, eo egu suisui saraidi se unuidio, ginauri gamagaridi se abinonohaidio: au laoma tawasora arinai.’ ");
INSERT INTO swp_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Isi se alaliuliua edi dobila udoidi mo se lauwataidi esau i lau ena oea, esau i lau ena sitoa. ");
INSERT INTO swp_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tatao hisahisawaidi se mia, ena heaheari tataodi se toaidi se hebaaeaaririedi, eo se unuhematedi. ");
INSERT INTO swp_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Wasawasa wa, wasana i ataiei, abo i ouyalayala: tauiala i hetamaridi, tauaiunu wa se unuidi, edi eanua hinage se gabugorigori. ");
INSERT INTO swp_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Abotai abo i ribalau ena heaheari tataodi aridi eai i ene, ‘Tawasora se abinonohaiyao, isi ea ribaedi wa nige se lolo. ");
INSERT INTO swp_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Au lau dobila lailaidi eai, isi gamagaridi au lobaidi, au heribadi abo se laoma tawasora eai.’ ");
INSERT INTO swp_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Heaheari wa abo se lau dobila lailaidi eai, isi gamagaridi se lobaidi se heoigogoidima, headi se baaea, headi se lolo: tawasora taumanana se gamagari. ");
INSERT INTO swp_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Wasawasa wa i awasae numa alona eai taumana bena i itadi, na tau esau nei eai ie ita, ena hetahetawasora luluna wa nige i lui: ");
INSERT INTO swp_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ie ribalau ia arinai i ene, ‘Ehagu e, ue saha u laoma inai hetahetawasora luluna nige u lui?’ Ia nige arinana. ");
INSERT INTO swp_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Wasawasa abo i ribalau heaheari wa aridi eai, i ene, ‘Nimana eo aena au auauidi, au laehesuara, au gabadobei masigiri boeana eai: nei eai abo se doudou, eo moadi se taburueahisidi.’ ");
INSERT INTO swp_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Na tatao gamagari se eogaidi, hisahisawaidi mo se abi hilehileidi.” ");
INSERT INTO swp_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Parisea tataodi abo se oioiriba edoha edi abiabina ena riba wa abo se hepiripiri. ");
INSERT INTO swp_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Edi heaheatayao, eo Herodiana tataodi headi se hetamaridi ia arinai si ene, “Tanuagamai e, ai itayao oa u dudurai mo, eo Eaubada ena dobila mamohoina u lauheataei, nige tau esau hinage u matausiei, paana ede taumonamonaune eo taugogogesagesa mo u nuatuidi gonogonoadi. ");
INSERT INTO swp_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","U heribamai, em nuatu saha? Laugagaeo i lolo wa si ene takisi monina se mosei Kaisara, e nige’e wa?” ");
INSERT INTO swp_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Edi baaea Iesu i nuatuiyao i ene, “Aue saha au nohoigu ta, omi tauboraborasom? ");
INSERT INTO swp_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takisi monina esau hage au heitagu.” Abo denari esega se leama ia arinai. ");
INSERT INTO swp_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ie ribalau aridi eai i ene, “Eai ana ao ina, eo eai ena uriuri?” ");
INSERT INTO swp_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ia arinai si ene, “Kaisara enana.” Abo i ribalau aridi eai i ene, “Kaisara ena ginauri au laei Kaisara arinai, eo Eaubada ena ginauri au laei Eaubada arinai.” ");
INSERT INTO swp_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Teina riba ta se ataiei se noonooei, ia se laugabaei se lau edi abalau eai. ");
INSERT INTO swp_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Wau asubenana eai wa Sadukea tataodi, isi si ene nige torouiona, se laoma ia arinai se oimuri. ");
INSERT INTO swp_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Si ene, “Tanuagamai e, Mose i ene, ‘Taba tau esau ie mate ia nige nanatunayao, ena tau ia wabuna abo i tawasorai, natuna taba se labasi abo si ene tau mate wa natuna.’ (Du. 25.5). ");
INSERT INTO swp_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Arimai eai tatao haligigi‐labui bogadi esega: taubaguna sine i tawasorai e ie mate, nige natuna, arinai wabuna wa i mosei ena tau ie hai. ");
INSERT INTO swp_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Helabuina hinage doha, eo hehaionana hinage, i lau e taiede hehaligigi‐labuina wabuna wa i tawasorai. ");
INSERT INTO swp_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Murina eai sine hinage ie mate. ");
INSERT INTO swp_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Torouio huiana i lagema sine wa, tataodi haligigi‐labui aitea monena ede? Isi gamagaridi ia se abi.” ");
INSERT INTO swp_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Iesu arinadi i heuio, i ribalau aridi eai i ene, “Au ponori, uriuri nige abidi au ata, eo Eaubada ena gigibori hinage nige abina au ata. ");
INSERT INTO swp_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Torouio huiana eai nige se tawasora, eo nige se hetahetawasoraidi, na isi galewa eai doha Eaubada ena aneru. ");
INSERT INTO swp_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Taumatemate se torouio ribana wa Eaubada i ribalaowa arimiu eai nige au hasiri wa, i ene. ");
INSERT INTO swp_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Eau Aberahama ena Eaubada, eo Isaako ena Eaubada, eo Iakobo ena Eaubada (Ex. 3.6)?’ Eaubada, taumatemate nige edi Eaubada, taumaumauri mo edi Eaubada.” ");
INSERT INTO swp_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Moutuana teina se ataiei, ena lauheata se noonooei. ");
INSERT INTO swp_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Parisea abo se ataiei ia Sadukea i ribahetuuridi, edi abaoigogo esega. ");
INSERT INTO swp_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Adi sagu esau, laugagaeo tauna, ia i hesiokamaliua, i ene, ");
INSERT INTO swp_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tanuagamai e, laugagaeo ribadi eai, aitea i saesae ariri?” ");
INSERT INTO swp_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Iesu i ribalau ia arinai i ene, “Guiau em Eaubada u gadosisiei ma nuam i ohi, eo ma earuam i ohi, eo ma nuanuatum i ohi (Deut. 6.5). ");
INSERT INTO swp_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Teina laugagaeo ta i baguna, eo i sae ariri. ");
INSERT INTO swp_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Helabuina hinage doha ede. Helem taumia u gadosisiei doha hinage oabom u gadosisiuioim (Lev. 19.18). ");
INSERT INTO swp_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Teina laugagaeo labui ta aridi eai laugagaeo gamagaridi, eo peroveta ribadi se heabasisaedi.” ");
INSERT INTO swp_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parisea tataodi ma oigogodi eai na Iesu i oimuridi, ");
INSERT INTO swp_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","i ene, “Emi nuatu au ene Keriso eai? Ia eai natuna?” Isi se ribalau ia arinai si ene, “Davida natuna.” ");
INSERT INTO swp_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ie ribalau aridi eai i ene, “Edoha Davida Earua Tabuna debana eai i awaguiauei, i ene, ");
INSERT INTO swp_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Guiau ie ribalau egu Guiau arinai, i ene, Nimatutugu eai u bawa i lau e em waiunuyao se hemala aem adi bou?’ (Psa. 110.1). ");
INSERT INTO swp_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ena Davida ia i awaguiauei, edohana au ene ia natuna?” ");
INSERT INTO swp_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nige tau esau heuiona abo abina i ata: eo wau asubena eai i lau e, taba nige esau i hesiouio ia arinai. ");
INSERT INTO swp_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Iesu abo i ribalau moutuana, eo ena heaheatayao hinage aridi eai, ");
INSERT INTO swp_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","I ene, “Tauuriuri eo Parisea tataodi Mose ena abababawa eai se bawa: ");
INSERT INTO swp_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ginauri gambgamagari, saha eo saha, se lauhesommiu si ene au abiwataidi, abo au abiwataidi: edi laulau mo tabu au laulauedi: awadi mo ribaribadi na taba nige se abiwataidi. ");
INSERT INTO swp_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Adi bahebahe poroporohedi se audi, se porohe ariri, se toresaedi tatao dabaearodi eai: isi nima gigidi nige esega se torelaei aridi eai. ");
INSERT INTO swp_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Na edi laulau gamagamagari se laulauedi bena tatao abo se itadi, edi pilateri se hemagagadi, eo adi lulu dedeadi se helaidi. ");
INSERT INTO swp_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mataasi eai biri saesaedi se henuadi: eo sunago alodi eai abababawa saesaedi hinage se henuadi, ");
INSERT INTO swp_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","abauneune eai edi nuatu bena tatao abo se laulautoiedi, eo bena tatao abo se awatanuaga aridi eai. ");
INSERT INTO swp_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Tabu au awatanuagauioimiu: ami tanuaga esega mo ede Keriso: omi gamagarimiu boga esega mo. ");
INSERT INTO swp_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tanoubu eai ta tabu tau esau au awatamaei: Tamamiu esega mo ia ede galewa eai. ");
INSERT INTO swp_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tabu se awatanuagaemiu hinage: ami Tanuaga esega mo, ia ede Keriso. ");
INSERT INTO swp_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ena arimiu eai esau i sae ariri, ia abo emi heaheari eai i lau. ");
INSERT INTO swp_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Eai to eai ia abo i hedebasaeuioi abo se ribahetamolubulubu: ia i ribahetamolubulubuuioi ia abo se hedebasaei. ");
INSERT INTO swp_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Tauuriuri eo Parisea tataomiu e, omi tauboraborasom, kapore omi! ouyalayala lailai abo au hearo! Galewa basileiana tatao matadi eai au gudugudui: omi nige au sora, eo isi hinage bena se lusora au lauguduguduidi. ");
INSERT INTO swp_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Tauuriuri eo Parisea tataomiu e, omi tauboraborasom, kapore omi! ouyalayala lailai abo au hearo! sisine wabuwabu edi numa au aigirihaidi, na emi borabora emi uura au heloha: arinai mate lailai abo au hearo. ");
INSERT INTO swp_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Tauuriuri eo Parisea tataomiu e, omi tauborabora, kapore omi! ouyalayala lailai abo au hearo: na gabogabo eo tanoubu au hetaiiri bena tau esega nuana au buihetaiiri, e au abi, ia abo au abi i hemala gehena natuna, abo i baaea ariri i dioimiu. ");
INSERT INTO swp_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Omi tauwoeawoea matagibugibumiu, kapore omi! ouyalayala lailai abo au hearo: au ene ‘Eai eo eai numa tabuna arinai se aigora meta nige aniona: na eai eo eai numa tabuna ena gold arinai se aigora, aigora mamohoina ede meta.’ ");
INSERT INTO swp_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Au eauyaure omi: eo ma matagibugibumiu: aitea i sae ariri, gold wa, e numa tabuna gold i hetabuei? ");
INSERT INTO swp_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Eo hinage au ene, ‘Eai eo eai abaaitalasamna arinai i aigora, nige aniona meta, na eai eo eai ainauia abaaitalasamna potana eai arinai i aigora, aigora mamohoina ede meta.’ ");
INSERT INTO swp_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Omi tauwoeawoeaidi, matamiu se gibugibu mo: aitea i sae ariri, ainauia wa, e abaaitalasamna ainauia wa i hetabuei? ");
INSERT INTO swp_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Arinai eai eo eai abaaitalasamna arinai i aigora, i aigora mamohoi, eo ginauri gamagaridi potana eai aridi eai i aigorai hinage. ");
INSERT INTO swp_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Eai eo eai numa tabuna arinai i aigora, i aigora mamohoi, eo ia arinai i aigora hinage numa tabuna boeana eai ie mia. ");
INSERT INTO swp_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ia hinage galewa arinai i aigora, Eaubada ena terona arinai i aigora, eo ia arinai hinage terona potana eai ie bawa. ");
INSERT INTO swp_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Tauuriuri eo Parisea tataomiu, omi tauboraborasom, kapore omi; ouyalayala lailai abo au hearo: omi mint, eo anise, eo kumino hesaudoudoidi eai Eaubada arinai au aiainauia na laugagaeo lailai, eo heduduraina, eo nuatoatoana, eo sunumawataina au nuagabaedi: i lolo teina au abidi eo meta headi me au abiesegaidi hinage. ");
INSERT INTO swp_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Omi tauwoeawoea, mata gibugibumiu, niiniili esau au hegoilisi‐gabaei, na kamela mo abo au dom. ");
INSERT INTO swp_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Tauuriuri eo Parisea tataomiu e, omi tauboraborasom, kapore omi! ouyalayala lailai abo au hearo: kaputi eo gaeba murimuridi au deuriheaadi, nuaboeadi eai mo aigirihai, eo baaea apeapesuiana se ota. ");
INSERT INTO swp_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Oa Parisea matagibugibum e, kaputi eo gaeba aloalodi u deuri bagunaedi, murimuridi abo hinage se aaesegaidi. ");
INSERT INTO swp_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Tauuriuri eo Parisea tataomiu e, omi tauboraborasom, kapore omi! ouyalayala lailai abo au hearo: omi doha bousa se hepoahu‐heposiposidi, isi murimuridi itaitadi se lolo, na boeadi eai taumatemate siadadi, eo bii gamagamagari se monau. ");
INSERT INTO swp_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Omi hinage doha ede tatao matadi eai emi laulau, opi murimurimiu eai mo se itadi si ene se dudurai, nuaboeamiu eai borabora eo baaea apeapesuiana se monau. ");
INSERT INTO swp_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Tauuriuri eo Parisea tataomiu e, omi tauboraborasom, kapore omi! ouyalayala lailai abo au hearo: paana peroveta edi bousa au abidi, eo tau laulaududurai tataodi edi bousa au hepasadi. ");
INSERT INTO swp_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Au ene, ‘Taba ai tamamaiyao edi huia eai wa ai mia, peroveta osinadi se heboriri taba nige ai saguidi. ");
INSERT INTO swp_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Arinai ede au ribataubigauioimiu; peroveta tauunuidi nanatudiyao omi. ");
INSERT INTO swp_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Tamamiuyao edi baaea sigasigadi omi au hemonaudi. ");
INSERT INTO swp_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Omi mota e, omi mota isidi e, gehena matena eai emi abadago ede saha? ");
INSERT INTO swp_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Arinai, hage, peroveta headi eo tatao sonoga, eo tauuriuri tataodi abo ea hetamaridiwa: headi abo au unuidi, eo au hesataurodi; headi emi sunago eai abo au pidiridi, hari eanua, hari eanua au henaudi abo au hebaaeadi. ");
INSERT INTO swp_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Laulau dudurai tataodi osinadi gamagari tanoubu eai se heboriridi abo se laoma debamiu eai, Abela laulaududurai tauna osinana arinai se hetubu, i laoma e Sakaria, Barakia natuna osinana, ia au unui wa dubu eo abaaitalasamna duaduaridi eai. ");
INSERT INTO swp_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mamohoi, ea heribamiu ta, teina baaea gamagaridi, isi ta abo se hearodi. ");
INSERT INTO swp_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ierusalema e, Ierusalema e, oa peroveta tauunuidi, eo headi wa se hetamaridiwa u lauwe’uidi, huia gamagari egu gadosisi bena nanatumyao ea heoigogoidi, doha kamkam nanatunayao mabena eai i obatawaidi, na omi au awayagara! ");
INSERT INTO swp_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Emi numa se laugabaei au abi, numa ahaahana mo. ");
INSERT INTO swp_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ea heribamiu ta ea ene, maraitom asubena taba nige au itauioigu, i lau e abo au ene, ‘Ia i lolo Guiau esana eai i laoma.’” ");
INSERT INTO swp_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesu dubu i laugabaei i lau murimuri eai: ena heaheatayao se laoma ia arinai dubu numadi bena ia se heita. ");
INSERT INTO swp_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Iesu i ribalau isi aridi eai i ene, “Teina ginauri gamagaridi nige au itadi wa? Mamohoi ea ribalaowa arimiu eai, taba nige we’u esau i ota we’u esau potana eai, abo se heboloheohidi.” ");
INSERT INTO swp_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Oliveta tupina eai ie bawa ena heaheatayao se lau mahimahihima, si ene, “U heribamai aitea huia eai ina ginauri ta abo se tubu? eo em uioma heiheinoina saha, eo tanoubu ena abalautom heiheinoina saha?” ");
INSERT INTO swp_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Iesu ie ribalau aridi eai i ene, “Au komakomanimiu, tabu tau esau i boraimiu. ");
INSERT INTO swp_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Gamagaridi abo se lagema eau esagu eai, abo si ene, ‘Eau Keriso ede,’ gamagaridi hinage abo se boraidi. ");
INSERT INTO swp_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Iala wasadi abo au ataiedi, eo iala ribadi hinage: tabu au nuadubu: teina ginauri gamagamagari abo se tubu baguna, e sigasigana sora. ");
INSERT INTO swp_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Basileia esau eo basileia esau se iala, eo basileia esau eo basileia esau se iala (Is. 19.2); eo hari teha, hari teha eai, guriam abo se tubu, eo moniinii abo se hetabutabubu. ");
INSERT INTO swp_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Teina ginauri gamagaridi ta aridi eai nuadubu ie tubu. ");
INSERT INTO swp_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Omi abo se woealaemiu se henuadubumiu, eo abo se unuhematemiu; hinage basileia gamagaridi eai se ouyalayalaemiu esagu debana eai. ");
INSERT INTO swp_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nei huiana ne gamagaridi abo se alabesibesi (Is. 8.15), esau esau se haihaimoruuioidi, esau esau se haihaiouyalayalauioidi hinage. ");
INSERT INTO swp_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Peroveta borabora gamagaridi abo se tubu, tatao gamagaridi abo se boraidi. ");
INSERT INTO swp_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Paana baaea wa se gamagari ariri, arinai abo gamagaridi edi gadosisi se gogoma. ");
INSERT INTO swp_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ia ie dudu mo i lau e sigasigana eai, abo i mauri. ");
INSERT INTO swp_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Teina basileia evaneliana tanoubu abo se lauguguiaheohi, hari tatao, hari tatao gamagaridi se ribahasahasaidi; abotai sigasigana abo i lagema. ");
INSERT INTO swp_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Arinai ena nuadubu baaeana wa au ita, doha Daniela peroveta i ribaei wa (Dan. 9.27), dimo tabuna eai i totoro (eai to eai i hasiri abo i nuatui): ");
INSERT INTO swp_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","nei huiana ne isi Iudea taumiaina abo se dago oea tupidi eai. ");
INSERT INTO swp_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ia numa ewana eai ie bawa tabu i pesama ena ginauri i abidi numa eai: ");
INSERT INTO swp_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","hinage ia oea eai tabu i uioma ana lulu i abidi. ");
INSERT INTO swp_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kapore sisine taubogaboga, eo nei asubenana ne sisine nanatudiyao se hemadodi! ");
INSERT INTO swp_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Au uura, bena emi huia dagodago eai ania nige se baaea, hinage asubena sabate nige’e. ");
INSERT INTO swp_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nei huiana ne nuadubu baaeana, nige baaea esau doha nei tanoubu se hetubu i laoma, i laoma, e teina huia ta, eo i lau e ana huia ana tasi (Dan. 12.1). ");
INSERT INTO swp_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Asubena wa ena nige se hekuudi, taba nige tau esau i mauri, na tatao hilehileidi debadi eai nei asubenana ne abo se hekuudi. ");
INSERT INTO swp_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ena tau esau i ribalaowa i ene, ‘Keriso ia ede ina, Keriso ia ede nei’; ena riba tabu au ataiwatai. ");
INSERT INTO swp_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Paana Keriso boraboradi abo se torohai, eo peroveta boraboradi hinage, isi heiheinoi eo noo lailaidi abo se hemasarahadi: mamohoi, ena abina se ata tatao hilehileidi wa abo se boraidi. ");
INSERT INTO swp_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Au nuatui, ea heribanonohaimiuo. ");
INSERT INTO swp_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Taba arimiu eai si ene, ‘Ia barabara eai ie mia’; tabu au lau arinai: taba hinage si ene, ‘ia i miayamui biriutusi eai’; riba wa tabu au ataiwatai. ");
INSERT INTO swp_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Doha namanamari i silima tupo aruabu eai, i lau e tupo ealasi eai: Tau Natuna ena laolaoma abo hinage doha ede meta. ");
INSERT INTO swp_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Sinare ena abaota eai magesubu lailai abo se tupagogoesegai. ");
INSERT INTO swp_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Nei huiana ne, nuadubu baaeana murina eai, maesega mahana abo i wahuwahuhuri, eo nawarai hinage taba nige i sina, eo ipora galewa eai abo se beuma, eo galewa gigiboridi abo se moimoiu (Isaia 13.10; 34.4). ");
INSERT INTO swp_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Arinai abo Tau Natuna ia heiheinoina galewa eai abo i masarahama: tanoubu hari boga, hari boga abo se doudou, Tau Natuna abo se ita galewa eada boeadi eai i laolaoma, ma gigiborina eo ma namanamari‐aririna (Dan. 7.13). ");
INSERT INTO swp_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ia ena aneru abo i hetamaridi, bogigi arinana lailai eai (Isa. 27.13), tatao hilehileidi, enanayao, mana edi abatoama hasi eai, galewa sigana esau i lau e galewa sigana esau eai, abo se heoigogoidima (Deu. 28.64; 30.4). ");
INSERT INTO swp_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Omi kuhou parabolena au nuatui: Lagana ma gubugubuna, lugudi i toredi, arinai au nuatui au ene, siwaro huiana i hanahanau. ");
INSERT INTO swp_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Omi hinage doha meta, wau ginauri gamagamagaridi abo au itadi, abo au nuatui, au ene, i hanahanaumao, iaede dobila hasaridi eai. ");
INSERT INTO swp_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mamohoi ea heribamiu ta, teina isi ta sora taba nige i lautom, teina ginauri gamagaridi se tubunonohai. ");
INSERT INTO swp_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Galewa eo tanoubu abo se lautom, na egu riba taba nige se lautom. ");
INSERT INTO swp_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Na asubena ne eo awa ne nige tau esau abina i ata, galewa anerudi hinage nige’e, na Tamagu iabom mo. ");
INSERT INTO swp_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Doha Noa asubenana eai wa (Gene. 7), Tau Natuna ena laolaoma abo doha ede. ");
INSERT INTO swp_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Asubenadi wa dibori utuutu sora nige ie tubu, se aiai eo se nomnom, se tawasora eo se hai, i lau e nei asubenana ne Noa i lulau waga eai. ");
INSERT INTO swp_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nige se nuatui i lau e dibori utuutu i lagema, gamagaridi i ealuhaidi; Tau Natuna hinage ena laolaoma abo doha meta. ");
INSERT INTO swp_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nei huiana ne tatao labui abo se mia oea eai, esau abo se abihai, eo esau abo se laugabaei. ");
INSERT INTO swp_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Sisine labui edi abagirigiri eai sitona abo se giri: esau abo se abihai, esau abo se laugabaei. ");
INSERT INTO swp_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Au nuatuhetete: awa wa nige au nuatui arinai emi Guiau i laoma. ");
INSERT INTO swp_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Teina au nuatui, ena numa tanuagana tauaiaigirihai ena huia lagema i nuatui, ia i silawahetete, ena numa taba nige se lopagorigori. ");
INSERT INTO swp_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Arinai omi hinage au nuatuhetoanonohai: awa wa nige au nuanuatui arinai Tau Natuna abo i laoma. ");
INSERT INTO swp_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Eai heaheari tauna i lolo, eo i sonoga, ena guiau ia i hetoro ena numa tanuagana, ia nanatunayao aiai huiadi adi i mosedi? ");
INSERT INTO swp_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Heaheari meta ena guiau ena huia lagema abo i lobai ena laulau nei doha, ia nuana i woiwoina. ");
INSERT INTO swp_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mamohoi ea heribamiu ta, ia abo heaheari wa i hetoro ena gogo gamagamagari tanuagadi eai ie lau. ");
INSERT INTO swp_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Taba heaheari tauna baaeana nuagadona mo i ene, ‘Egu guiau ena laoma i boneawa’. ");
INSERT INTO swp_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ana sasaguyao abo i laulaulubidi, tatao eauyaure aridi eai hinage i aiai, eo i aiainom; ");
INSERT INTO swp_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","heaheari wa ena guiau abo i laoma asubenana wa nige i nuanuatui: hinage awa eai wa nige se ribaei, ");
INSERT INTO swp_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ia abo i talautusihai, i hepatulaei tauborabora tataodi aridi eai: nei dimo eai ne abo se doudou eo moadi se taburuyahisidi. ");
INSERT INTO swp_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Galewa basileiana doha hasara nuanuasupudi saudoudoi, edi lamepa se abidi se lau tau‐bena‐i‐tawasora se laubagibagiei. ");
INSERT INTO swp_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Haligigi se sibasiba, na haligigi se supusupu. ");
INSERT INTO swp_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Isi tausupusupu wa edi lamepa se abidi, nige edi keresine. ");
INSERT INTO swp_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Isi tausibasiba wa edi lamepa se abidi eo edi keresine iledi hinage se abidi. ");
INSERT INTO swp_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tau‐bena‐i‐tawasora wa i boneawa, isi gamagaridi matadi se enoeno, arinai se eno. ");
INSERT INTO swp_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Bulinuana eai se hetalaneenee si ene, ‘Iei, tau‐bena‐i‐tawasora wa i laolaoma; au lau, au laubagibagiei.’ ");
INSERT INTO swp_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Hasara nuanuasupu gamagaridi abo se torohai, edi lamepa se ginauri nonohaidi. ");
INSERT INTO swp_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tausupusupu se ribalau tausibasiba aridi eai si ene, ‘Keresine ema bega au leama: ema lamepa se boso’o.’ ");
INSERT INTO swp_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Tausibasiba arinadi se heuio, si ene, ‘Nige’e; enamiu eai eo enamai eai ata nige gonogonoada: au lau tauuneune aridi eai, enamiu au uneune.’ ");
INSERT INTO swp_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Isi se lau se uneune wa, tau‐bena‐i‐tawasora wa i lagema; isi se abinonohao wa maenayao se lau tawasora eai: dobila abo se gudu. ");
INSERT INTO swp_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Murina eai hasara nuanuasupusupu headi wa se laoma, si ene, ‘Guiau e, Guiau e, ema dobila u soeama.’ ");
INSERT INTO swp_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Arinadi i heuio i ene, ‘Mamohoi, ea heribamiu ta, ea hekaumiu.’ ");
INSERT INTO swp_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Omi au nuatuhetoanonohai, asubenana eo awana Tau Natuna arinai i laoma nige abina au ata. ");
INSERT INTO swp_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Galewa basileiana doha ede tau esau i lau eanua eda lohaloha eai, ena heaheari tataodi i eogaidi, ena gogo gamagaridi i mosei nimadi eai. ");
INSERT INTO swp_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Esau taleni haligigi i mosei, eo esau labui, eo esau esega; tau esau, eo tau esau ena adidiri i heaigonogonoaiedi; ia abo ena adau i adauei. ");
INSERT INTO swp_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ia taleni haligigi wa i abidi i lau i paisoa arinai taleni haligigi hinage i hetubudi. ");
INSERT INTO swp_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ia labui i abidi, enana hinage i helai labui. ");
INSERT INTO swp_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Na ia esega ie abi wa ie lau tano ie sara, ena Guiau ena moni arinai i puruyamui. ");
INSERT INTO swp_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Huia lohaloha heaheari wa edi Guiau i laoma, aridi eai ena gogo i hesioedi. ");
INSERT INTO swp_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ia taleni haligigi i abidi wa i laoma haligigi i hetubudi wa hinage i ledima, i ene ‘Guiau e, taleni haligigi u ledima arigu eai wa: taleni haligigi hinage ea helaidi.’ ");
INSERT INTO swp_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ena Guiau ia arinai i ene, ‘U abiloloedi, oa heaheari lolona, eo em nuatu se dudurai; ginauri hisahisawaidi u komakomanidi, abo ea hetorom ginauri gamagaridi abo oa tanuagadi eai u lau: em Guiau ena kode abo i hekodem.’ ");
INSERT INTO swp_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ia hinage taleni labui i abidi wa i laoma i ene, ‘Guiau e, taleni labui u ledima wa; e labui hinage ea hetubudi.’ ");
INSERT INTO swp_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ena Guiau i ribalau ia arinai i ene, ‘U abiloloedi, oa heaheari lolona, eo em nuatu se dudurai: ginauri hisahisawaidi u komakomanidi, abo ea hetorom ginauri gamagaridi abo oa tanuagadi eai u lau: em Guiau ena kode abo i hekodem.’ ");
INSERT INTO swp_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ia taleni esega ie abi i laoma, i ene, ‘Guiau e, ea nuatuim oa tauawaawayagarana, em laulau enam u abigaibuidi mo, eo ginauri bena u tanogogoidi sora nige u lauhesurudi. ");
INSERT INTO swp_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Eo ea matausi, ea lau em taleni tano eai ea puruyamui: enam me u abiuioiawa.’ ");
INSERT INTO swp_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ena Guiau arinana i heuio i ene, ‘Oa heaheari baaeana, eo tauawaawabada, u nuatui wa egu laulau ginauri ea abigaibuidi mo, eo ginauri ea tanogogoauridi sora nige ea lauhesuru. ");
INSERT INTO swp_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ue saha egu moni nige u laei moni tauuneune aridi eai, abo ea uioma ta, egu moni ea abiuioi eo maisana hinage. ");
INSERT INTO swp_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Wau taleni wa ia arinai au abi, au laei abo saudoudoi tauabidi arinai au mosei. ");
INSERT INTO swp_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Paana ena tau esau eo tau esau i abi abo hinage se mosei, enana abo se gamagari ariri: ia ena nige i abi, enana begana abo hinage se abihai. ");
INSERT INTO swp_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Heaheari baaeana wa au gabalaei masigiri boeana eai wa: nei dimo eai ne se doudou, eo moadi se taburuyahisidi.’ ");
INSERT INTO swp_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Huiana Tau Natuna i laoma ma namanamarina, maena aneru hetahetabudi hinage, ia abo i bawasae ena terona namanamarina potana eai. ");
INSERT INTO swp_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ia nuanuana eai hari basileia, hari basileia tataodi se oigogo: ia abo i pei‐labuidi, doha mamoe taumiataunidi mamoe eo bokania i pei‐labuidi. ");
INSERT INTO swp_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ia abo mamoe i toredi ia nimatutuna eai, na bokania i toredi ia nimaseuseurina eai. ");
INSERT INTO swp_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Abo Wasawasa ie ribalau isi ia nimatutuna eai aridi eai, i ene, ‘Au laoma, omi Tamagu i nuawoiwoinaemiu, basileia mumuga eai tanoubu se hetubu se abi nonohaiao au abi enamiu. ");
INSERT INTO swp_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Paana ede ea guriam, agu aiai au leama; gadogu ie magu, goila eai au henomgu; eau taowawa, au taubigaigu; ");
INSERT INTO swp_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","nige agu lulu, au heluigu; ea asiebo, au itawataigu; eau numa masigiri eai ea mimia, hinage au laoma arigu eai.’ ");
INSERT INTO swp_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tatao laulaududuraidi wa abo se ribalau ia arinai, si ene, ‘Guiau e, huia esana ai itam u guriam, am aiai ai leawa, hinage gadom ie magu, goila ai leawa ue nom? ");
INSERT INTO swp_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Huia esana ai itam oa taowawa, ai taubigaim, nige am lulu, ai heluim? ");
INSERT INTO swp_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Huia esana ai itam u asiebo, eo numa masigiri eai u miamia, hinage aie laowa?’ ");
INSERT INTO swp_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Wasawasa abo i ribalau isi aridi eai, i ene, ‘Mamohoi ea heribamiu ta, egu tau i hegehegegepo arinai ina laulau ta au laulauedi wa, doha ede au laulauedi arigu eai.’ ");
INSERT INTO swp_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ia abo hinage i ribalau isi ia nimaseuseurina eai aridi eai, i ene, ‘Au lausuaraegu, au baaea ariri, au lau oeagi alaalasi nige nosina boeana eai, doha se ginauri nonohai diabolo maena aneru enadi: ");
INSERT INTO swp_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","paana ede ea guriam, agu aiai nige au leama; gadogu ie magu, agu goila nige au leduhieama au henomgu; ");
INSERT INTO swp_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","eau taowawa, nige au taubigaigu; nige agu lulu, lulu agu nige au leama; ea asiebo, eo numa masigiri eai se toregu, nige au laoma au itagu.’ ");
INSERT INTO swp_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Isi hinage abo se ribalau ia arinai si ene, ‘Guiau e, huia esana ai itam u guriam e gadom ie magu, e oa taowawa, e nige am lulu, e u asiebo, e numa masigiri eai u miamia, hinage nige ai taubigaim?’ ");
INSERT INTO swp_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ia abo i ribalau isi aridi eai i ene, ‘Mamohoi ea heribamiu ta, doha teina egu tau i hegehegegepo nige au taubigai, nige au taubigaigu hinage.’ ");
INSERT INTO swp_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Isi abo se lau abamate nige nosina eai; na tatao laulau‐dudurai abo se mauri nige nosina.” ");
INSERT INTO swp_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iesu teina riba gamagaridi ta i riba‐lautom, ie ribalau ena heaheatayao aridi eai, i ene, ");
INSERT INTO swp_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Au nuatuiyao imaisina abo pasova se mataasiei, eo Tau Natuna se moruhai se hesatauro.” ");
INSERT INTO swp_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kohena lailaidi, eo tauuriuri tataodi, eo eanua babadadi, se oigogo kohena saesaedaoina ena numa eai, ia esana ede Kaiapa. ");
INSERT INTO swp_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Se oioiriba bena Iesu se toaliuliuai, ia abo se unui. ");
INSERT INTO swp_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Na si ene, “Tabu mataasi eai ta, ata tatao se hetalagegagega.” ");
INSERT INTO swp_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Iesu Betania eai ie mia, Simona, lepera tauna, ena numa eai i bawa bigabiga i aiai, ");
INSERT INTO swp_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","sine esau i laoma ia arinai alabata lasina i abiama, eausi alona eai, maisana i lai ariri, i hegoilaei ia boruboruna eai. ");
INSERT INTO swp_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ena heaheatayao se ita, se siayau, si ene, “Sanapu sahasaha ina i gaba gaibui ta? ");
INSERT INTO swp_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Teina eausi ta taba se uneunei maisana lailai se abi, eo se mosei gogogesagesa tataodi aridi eai.” ");
INSERT INTO swp_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Iesu i ataiei abo i ribalau aridi eai, i ene, “Sine ta sahaina au hemode? Laulau lolona i laulauei arigu eai ta. ");
INSERT INTO swp_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Gogogesagesa tataodi huia gamagamagari maemiuyao se mia; eau nige huia gamagamagari maemiu. ");
INSERT INTO swp_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Teina eausi i hegoi taugu eai ta, edi toregu i nuatunonohaiyao. ");
INSERT INTO swp_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ea heribamiu ta mamohoi, hari eanua, hari eanua eai, teina evanelia ta se lauguguiaei i lau e tanoubu i ohihai, sine ta ena laulau hinage abo se ribaei, ia abo abahenuaisinina.” ");
INSERT INTO swp_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Saudoudoi‐labui wa esau, esana Iuda Isakariota, ie pesa ie lau kohena lailaidi aridi eai. ");
INSERT INTO swp_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ie ribalau isi aridi eai, i ene, “Egu saha abo au leama ia abo ea leawa?” Ana mohara se ribaei silver tau‐esega‐i‐mate‐soudoudoi. ");
INSERT INTO swp_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Arinai ena dobila i eooi bena Iesu abo i morui. ");
INSERT INTO swp_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Areto‐nige‐ie‐tubu mataasina asubena bagubagunana eai heaheatayao se laoma Iesu arinai si ene, “Ai lau haedi pasova em abaaina ai abihetoa nonohai?” ");
INSERT INTO swp_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ia i ene, “Au lau eanua eai tau esau arinai, au ene, ‘Tanuagada i ene, Egu huia i hanahanaumao: maegu heaheatayao pasova abo ai ai em numa eai.’” ");
INSERT INTO swp_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Heaheatayao Iesu ena riba se lauwatai: pasova se abihetoa nonohai. ");
INSERT INTO swp_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","I maimailahi maenayao saudoudoi‐labui se bawabigabiga. (Ioane 13.2-30 au hasiri.) ");
INSERT INTO swp_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Isi ma aiaidi, i ene, “Ea heribamiu ta mamohoi ami sagu esau abo i moruigu.” ");
INSERT INTO swp_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Isi abo se nuadubu ariri, esau, esau se ribalau ia arinai si ene, “Guiau e, eau wa?” ");
INSERT INTO swp_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Arinadi i heuio i ene, “Ena ia nimana eo nimagu ai hedatuesegaidi gaeba alona eai, ia taumoruigu ede. ");
INSERT INTO swp_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tau Natuna abo i lau doha wasana se uri nonohaiyao: tau wa Tau Natuna taumoruina ede, kapore ia nuaahaahanina, tau ne i lolo taba ia nige se labasi.” ");
INSERT INTO swp_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Iuda, taumoruina, ia arinana i heuio, i ene, “Tanuagagu e, eau wa?” Iesu ia arinai i ene, “Oa ede u ribaei.” ");
INSERT INTO swp_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Isi ma aiaidi, Iesu areto ie abi, i lautoi, i ihi, i mosei heaheatayao aridi eai, i ene, “Au abi au ai; taugu ede ina.” ");
INSERT INTO swp_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Bia ie abi, i lautoi, i mosei aridi eai, i ene, “Arinai gamagarimiu au nom; ");
INSERT INTO swp_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","osinagu ede ina gagaeo harihariuna eai, se heboriri tatao gamagaridi edi baaea abaribagigirina ede. ");
INSERT INTO swp_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ea heribamiu ta, vine masina taba nige ea nomuioi, i lau e asubenana eai eau maemiu abo ta nom‐esega Tamagu ena basileia eai.” (Ioane, 14.1-31 au hasiri.) ");
INSERT INTO swp_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Wana esau se wana nonohai, abo se lau murimuri eai. Oliveta tupina eai. (Ioane 15, 16, 17 au hasiri.) ");
INSERT INTO swp_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Iesu i ribalau aridi eai, i ene, “Ina maiona ta gamagarimiu debagu eai abo au alabesibesi: doha se uriyao, si ene, ‘Mamoe tauitawataidi ea lubi, mamoe eawoidi abo se tatagorigori’ (Zech. 13.7). ");
INSERT INTO swp_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ea torouio abotai abo ea bagunaemiu Galilaia eai.” ");
INSERT INTO swp_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petero i ribalau ia arinai i ene, “Tatao gamagaridi debam eai abo se alabesibesi, eau taba nige ea alabesibesi.” ");
INSERT INTO swp_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Iesu ia i heriba i ene, “Ea heribamiu ta mamohoi, ina maiona ta kamkam sora nige se dou, mahaiona abo u uharaegu.” ");
INSERT INTO swp_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petero i ribalau ia arinai i ene, “Eau maem abo ta mate esega, taba nige ea uharaem.” Nei doha hinage heaheatayao gamagaridi edi riba esega mo. ");
INSERT INTO swp_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Iesu maedi abo se lage dimo esau eai esana Getesemani, heaheatayao aridi eai i ene, “Inai au bawa, ea lau kalau nei eai ea lau‐uura.” ");
INSERT INTO swp_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Maenayao Petero eo Sebedaio nanatunayao labui i woeaidi, arinai abo i hetubu i nuadubu, eo nuana i porohe ariri. ");
INSERT INTO swp_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ie ribalau aridi eai i ene, “Amnagu i baaea ariri, ea nuadubu matemate: inai au bawa, maegu ta silasilawa.” ");
INSERT INTO swp_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ia abo i taulau, i guridobi debana ie tutu, i uura, i ene, “Tamagu e, ea ene bena bia ta u laeudoiei: taiede eau nige egu nuatu ea lauwatai: oabom mo em nuatu.” ");
INSERT INTO swp_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ia abo i laoma heaheatayao aridi eai, ma‐enodi i lobaidi, i ribalau Petero arinai, i ene, “Ie saha mahana esega maeguyao nige ta silasilawa? ");
INSERT INTO swp_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Au silasilawa, eo au uura, noho ata i hearomiu: earuamiu se eari, na bulumamiu se beruberu.” ");
INSERT INTO swp_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ma‐labui ie uio, i uura, i ene, “Tamagu e, taba bia ta nige u laeudoiei u ene bena ea nom, oabom nuam.” ");
INSERT INTO swp_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","I uioma abo i lobaiuioidi se eno‐matemateuio: isi matadi se porohe. ");
INSERT INTO swp_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","I laugabaedi, ie uio, ma‐haiona i uura, ena riba esega mo. ");
INSERT INTO swp_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Abotai abo i laoma ena heaheatayao aridi eai, i heribadi i ene, “Abo au eno‐eawasimiu; awa i hanahanaumao, Tau Natuna ia abo se morui se mosei tatao baaea nimadi eai. ");
INSERT INTO swp_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Au torohai ta lau: taumoruigu i lagemao.” ");
INSERT INTO swp_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ia ma ribaribana, Iuda, saudoudoi‐labui esau, i lagema moutuana lailai maenayao, ma elepadi, eo ma kebukebubudi, kohena lailaidi, eo eanua babadadi aridi eai se laoma. ");
INSERT INTO swp_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Taumoruina wa heiheinoi i heribadi i ene, “Ena esau ea alagoiei ne, iaede meta, au toai.” ");
INSERT INTO swp_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Abo i lagema Iesu arinai, i ene, “Guiau e, Eauedo!” Abo ia i alagoiei. ");
INSERT INTO swp_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Iesu i ribalau ia arinai i ene, “Ehagu e, saha hesabana u laoma ta?” Arinai abo se laoma, nimadi eai se abilau Iesu arinai, abo se laei. ");
INSERT INTO swp_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Iesu ana sagu esau nimana i loloi, ena elepa i nuisihai, kohena lailai ena heaheari esau i lau‐elepai beana i talahai. ");
INSERT INTO swp_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Iesu ie ribalau ia arinai i ene, “Em elepa u toreuioi ena abaota eai, paana isi gamagaridi se aielepa, elepa eai hinage abo se unuhematedi. ");
INSERT INTO swp_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","U nuatui, u ene bena nige egu nuatu abo ina ena ea lau‐uura Tamagu arinai, ia aneru legiona saudoudoi‐labui abo i hetamariesegaidima? ");
INSERT INTO swp_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ena meta doha uriuri tabudi abo edohana edi hemahemamohoiena, si ene taba meta doha.” ");
INSERT INTO swp_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nei awa ne arinai Iesu i ribalau moutuana aridi eai, i ene, “Au laoma au toaigu eau doha tauaiaiyahari ma elepamiu eo ma kebukebubumiu? Asubena gamagamagari numa tabuna eai ea bawa maemiu, ea laulauheata, nige au abilaoma arigu eai.” ");
INSERT INTO swp_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Teina ginauri gamagamagari se abidi peroveta edi uriuri bena abo se hemamohoiedi. Heaheata gamagari ia abo se nuagabaei, se dagogorigori. ");
INSERT INTO swp_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Isi wa Iesu se toai, abo se laei kohena lailai Kaiapa arinai, nei eai tauuriuri eo babadadi se oigogo. ");
INSERT INTO swp_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petero muri ariri eai Iesu i laulauwatai se lau kohena saesaedaoina ena numa eai, ia i luhu heaheari maenayao se bawabigabiga, i itaitawatailaei. ");
INSERT INTO swp_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kohena lailaidi, eo babadadi, eo sunaderi gamagaridi, Iesu ana mata borabora se eooidi, ia bena se unuhemate. ");
INSERT INTO swp_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Na nige se lobai: mataborabora gamagaridi tauribaedi se laoma, nige se lobai. Abotai abo mata borabora tauribaedi labui se laoma. ");
INSERT INTO swp_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Si ene, “Teina tau ta i ene, ‘Eaubada ena numa tabuna lopagorigorina abina ea ata, eo asubena haiona eai abo ea hetorouioi.’” ");
INSERT INTO swp_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kohena saesaedaoina i toro i ribalau ia arinai, i ene, “Oa nige arinam? Wau taudi labui wa se ribataubigaim, u ene edoha?” ");
INSERT INTO swp_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Iesu nige ariarinana. Kohena saesaedaoina ie ribalau ia arinai i ene, “Eaubada maumaurina debana eai ea hetaladuim ta, ena oa Keriso, Eaubada Natuna, u heribamai.” ");
INSERT INTO swp_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Iesu i ribalau ia arinai, i ene, “Oa ede u ribaei: taiede ea heribam ta ea ene, abotai Tau Natuna abo au ita gigibori nimatutuna eai ie bawa, galewa eadadi boeadi eai i laolaoma.” ");
INSERT INTO swp_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kohena saesaedaoina ana lulu i purisihaidi, i ene, “Eaubada i ribahebaaea, ana mata saha ta eooi? Eaubada i ribahebaaea au ataieyao. ");
INSERT INTO swp_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Emi nuatu saha?” Arinana se heuio si ene, “Ana mata nonohana, ia abo i mate.” ");
INSERT INTO swp_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ia matana se garigarisoi, ia se oioiahalai; headi ia se laulauwapai, ");
INSERT INTO swp_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Si ene, “Oa Keriso, u riba peroveta arimai eai, Eai i lubim?” ");
INSERT INTO swp_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petero numa lailai wa murimurina eai i babawa: siu esau i laoma ia arinai, i ene, “Oa hinage Iesu Galilaia maem?” ");
INSERT INTO swp_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Isi gamagaridi matadi eai ie uhara, i ene, “Em riba u ribaei nige ea itaitai.” ");
INSERT INTO swp_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ia abo i lau murimuri eai, dobila numana eai, siu esau ia ie ita isi nei eai i ribalau aridi eai i ene, “Teina tau ta hinage Iesu Nasareta maena.” ");
INSERT INTO swp_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Abo ie uhara uio, eo i arina baaea, i ene, “Tau me nige ea nuatui.” ");
INSERT INTO swp_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Abotai abo isi nei eai se totoro se laoma, se ribalau Petero arinai, si ene, “Mamohoi oa hinage adi sagu esau: arinam i hemasaraham.” ");
INSERT INTO swp_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Arinai abo i arina baaea ariri, i ene, “Tau me nige ea itaitai.” Maesega kamkam abo ie dou masaraha. ");
INSERT INTO swp_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petero Iesu ena riba wa nuana ie sae, ia i heriba wa i ene, “Kamkam sora nige ie dou, ma‐haiona abo u uharaegu.” I lulage murimuri eai, i dou matemate. ");
INSERT INTO swp_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mara‐ie‐tom kohena lailaidi, eo eanua babadadi gamagaridi se oioiriba Iesu bena se unui. ");
INSERT INTO swp_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ia abo se pai, se woealaei, se mosei gavana Ponotio Pilato arinai. ");
INSERT INTO swp_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Iuda, taumoruina wa, abo ie ita Iesu bena se unui, nuana i buibuini, silver tau‐i‐mate‐saudoudoi i uioedi kohena lailaidi eo babadai aridi eai. ");
INSERT INTO swp_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","I ene, “Eau ea baaea, tau ne ea moruhaiyawa nige ena baaea.” Si ene, “Taiede, ai nige’e, oabom.” ");
INSERT INTO swp_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Silver wa i gabalaedi numa tabuna alona eai, i laugabaedi, ie lau i gadosoha. ");
INSERT INTO swp_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kohena lailaidi silver se abidi, si ene, “Moni abatoredi eai taba nige ta toredi ata laugagaeo ta utusi, paana ede osina maisana.” ");
INSERT INTO swp_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Se oioiriba, abo gurewa tauginaurina ena oea aridi eai se une, laolaoma tataodi bena edi bousa. ");
INSERT INTO swp_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Arinai abo oea wa esana se tore, Osina oeana, i laoma e huia ta. ");
INSERT INTO swp_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Arinai peroveta Ieremia ena riba se hemamohoiei, i ene ina doha, “Silver tau‐i‐mate‐saudoudoi se abidi, ia maisana si ene gonogonoana, ia Isaraela nanatunayao maisana se ribaei. ");
INSERT INTO swp_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Gurewa tauginaurina ena oea aridi eai se mosei, doha Guiau i hetorogu” (Zech. 11.13). ");
INSERT INTO swp_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Iesu gavana matana eai i totoro: gavana i oimurini i ene, “Oa Iudea edi Wasawasa wa?” Iesu ia i heriba i ene, “Oa u ribaei.” ");
INSERT INTO swp_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kohena lailaidi, eo eanua babadadi ia se hegiru, ia nige arinana. ");
INSERT INTO swp_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilato abo i ribalau ia arinai i ene, “Ginauri gamagari aridi eai se hegirum ta nige u ataiei?” ");
INSERT INTO swp_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nige riba esau awana eai i heuio: arinai gavana i noo ariri. ");
INSERT INTO swp_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Gavana ena laulau, ina mataasi eai ta, tauauauna esau i eairihai, aitea tau wa tatao isibom se henua. ");
INSERT INTO swp_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nei eai tauauauna esau ia wasalaulau, esana Baraba. ");
INSERT INTO swp_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Isi abo se oigogo, Pilato ie ribalau aridi eai, i ene, “Eai au henua ede abo ea eairigabaeawa? Baraba, e Iesu esana ede Keriso?” ");
INSERT INTO swp_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","I nuatulobaiyao edi aiaromagigiri eai ia se moselaei. ");
INSERT INTO swp_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ia i bawasae abaheduhedudurai eai, ia monena tau esau i hetamari ia arinai, i ene, “Taulaulaududuraina me tabu u sahai: wau asubena ta ia ea enoliuliuaei, nuagu i hisihisili ariri.” ");
INSERT INTO swp_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kohena lailaidi eo babadadi moutuana se nuanuaoidi bena Baraba se awanorini, na Iesu bena se unui. ");
INSERT INTO swp_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gavana arinadi, abo i heuio, i ene, “Taudi labui ta aitea abo ea eairigabaeawa?” Si ene, “Baraba.” ");
INSERT INTO swp_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato i ribalau isi aridi eai, i ene, “Iesu se ribaei Keriso wa, edoha egu abiabina?” Gamagaridi se ribalau ia arinai si ene, “Ia abo se hesatauro.” ");
INSERT INTO swp_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Gavana i ene, “Paana saha? baaea esana ie abi?” Abo se eogalailai si ene, “Ia abo se hesatauro.” ");
INSERT INTO swp_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato i nuatuiyao ia awana taba nige se abi, eo se hetalagegagega, goila ie abi, moutuana wa matadi eai nimana i deuridi, i ene, “Tau laulaududuraina ta osinana se heboriri nige agu giru: omi omibom.” ");
INSERT INTO swp_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tatao gamagaridi ia arinana se heuio si ene, “Ia osinana potamai eai i ota, eo nanatumaiyao potadi eai hinage.” ");
INSERT INTO swp_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ia Baraba abo i eairihai i laei aridi eai: eo Iesu i pidirihemate nonohai, abo i mosei nimadi eai ia bena se hesatauro. ");
INSERT INTO swp_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gavana ena iala tataodi Iesu se laei edi abaoigogo birina eai, iala bodadi gamagamagari se oigogo ia arinai. ");
INSERT INTO swp_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ana lulu se abihaidi, lulu buiabuia arinai ia se helui. ");
INSERT INTO swp_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Oeagi nurinuridi arinai korona se haturi se heousaei ia uruna potana eai, eo didiari se tore ia nimatutuna eai: se turituribono ia matana eai, se liuliuaei, si ene, “Eauedo, Iudea edi Wasawasa e!” ");
INSERT INTO swp_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ia se garigarisoi, didiari wa se abi uruna eai se hotaei. ");
INSERT INTO swp_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Se liua lautom, abo lulu wa se abihai, ana lulu mamohoi mo se helui, se woealaei bena se hesatauro. ");
INSERT INTO swp_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Se lulage murimuri eai, Kurene tauna esau se lobai, esana Simona: ia se lauhesom ena satauro i bahei. ");
INSERT INTO swp_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Isi abo se lage dimo esau eai esana Gologota, heaheasonina ede, uruuru moiarudi. ");
INSERT INTO swp_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Isi vinega ma oeagi kalakalapina se heboriesegai se mosei bena i nom: i nom’ita abo i otaotaei. ");
INSERT INTO swp_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ia se hesatauro, ana lulu se soiedi, edi kelero se abi: peroveta ena riba bena arinai se hemamohoiei, doha i ene, “Agu lulu se soiedi, agu lulu arinai se hekelero.” ");
INSERT INTO swp_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nei eai se bawabigabiga ia se itaitai. ");
INSERT INTO swp_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Uruna ewana eai ana mata se tore, se urisae, si ene, “TEINA TA IESU IUDEA EDI WASAWASA.” ");
INSERT INTO swp_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tauaiaiyahari labui maenayao se hesatauroesegaidi, esau nimatutuna eai, esau nimaseuseurina eai. ");
INSERT INTO swp_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Isi se sae, se dobi se arina baaeaei eo se uruuruodei. ");
INSERT INTO swp_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Si ene, “Oa numa tabuna tauailopaina, eo asubena haiona eai bena u hetorouioi wa, hage u hemauriuioim. Taba oa Eaubada Natuna hage satauro eai me u pesadobima.” ");
INSERT INTO swp_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Hinage kohena lailaidi, eo tauuriuri tataodi, eo babadadi, ia se liuliuaei, si ene. ");
INSERT INTO swp_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Hari tatao mo i hemahemauridi: iabom hemauriuioina abina nige i ata. Ena ia Isaraela edi Wasawasa, satauro eai abo i pesadobima, ia abo ta sunusunumaei. ");
INSERT INTO swp_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Eaubada i nuatuwatai: Eaubada ia besi i abi abo i hemauri: paana i ene. ‘Eau Eaubada Natuna.’” ");
INSERT INTO swp_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tauaiaiyahari hinage maenayao se hesatauroesegaidi wa, edi riba esega mo. ");
INSERT INTO swp_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Awa haligigi‐esega i lau e awa haligigi‐hasi tanoubu i amumugudui. ");
INSERT INTO swp_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Awa haligigi‐hasi eai Iesu i eaba lailai, i ene, “Eli, Eli, lama sabatani?” heaheasonina ede, “Egu Eaubada, egu Eaubada, ue saha u nuagabaegu ta?” ");
INSERT INTO swp_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Headi nei eai se totoro, arinana se ataiei, si ene, “Tau me Elia i eogai.” ");
INSERT INTO swp_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Adi sagu esau i aitautau, baro ie abi, vinega i hemonau, didiari eai i auhepatu, i helelesae bena i nom. ");
INSERT INTO swp_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Isi headi si ene, “Sora i otawa, ta ita Elia abo i laoma i hemauri?” ");
INSERT INTO swp_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Iesu i eaba uio arinana lailai, abo i tubahai. ");
INSERT INTO swp_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Numa tabuna ana woeo i tapurisi labuini ewa eai ie dobi paa eai: tanoubu i tabutabubu, eo we’u se taigari. ");
INSERT INTO swp_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Taumatemate bousadi se taigari; hetabu tataodi gamagaridi headiyao se eno abo se torouio. ");
INSERT INTO swp_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bousadi eai se lulagema ia torouiona murina eai, eo se lau eanua tabuna eai, se taumasaraha tatao headi aridi eai. ");
INSERT INTO swp_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kenturion, ma ana sasaguyao Iesu se itawatai wa, tanoubu i tabutabubu se ita, eo wau, ginauri headi wa hinage, arinai se matausi ariri, si ene, “Mamohoi ina Eaubada Natuna ede!” ");
INSERT INTO swp_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nei eai hinage sisine gamagaridi muri ariri eai ia se itaitai: isi Galilaia eai Iesu se hemuriwataiama ia se tautaubigai. ");
INSERT INTO swp_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Isi ede Maria Magadala, eo Maria Iamesi maena Iose sinadi, eo Sebedaio nanatunayao sinadi. ");
INSERT INTO swp_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","I maimailahi, Arimatea tauna esau i laoma, ia taumonamonaune, esana ede Iosepa, ia hinage Iesu ena heaheata esau. ");
INSERT INTO swp_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ie lau Pilato arinai, Iesu sinarena wa i awanorini. Pilato abo i hetaladuidi sinarena se mosei ia arinai. ");
INSERT INTO swp_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Iosepa sinare wa i leao, lulu linen aa’aana arinai ie suma. ");
INSERT INTO swp_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ena bousa harihariuna alona eai ie tore, we’u eai duha se sara nonohaiyao: we’u nabunabutuana bousa wa se hebuigudui, ia abo i lau. ");
INSERT INTO swp_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Nei eai Maria Magadala, eo Maria esau bousa hasarina eai se babawa. ");
INSERT INTO swp_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Abinonoha asubenana mara‐ie‐tom, kohena lailai eo Parisea tataodi se tupagogoma Pilato arinai. ");
INSERT INTO swp_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Si ene, “Taubada e, nuamai se sae tauborabora me ma maurina ena ribariba i ene, ‘Asubena haiona murina eai abo ea torouio.’ ");
INSERT INTO swp_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Arinai u lauhesomdi bousa wa abo se itawataikomakomani i lau e asubena haiona wa se ohi, ata ena heaheatayao maiona eai se laumahimahihima, se laehesuara, abo tatao se heribadi si ene, ‘Mate eai i torouio:’ ata borabora murimuritana, borabora bagubagunana wa i saedioi.” ");
INSERT INTO swp_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato i ribalau aridi eai i ene, “Tauitaitawata tauiala au abidi au laedi: au lau bousa au gudu komakomani.” ");
INSERT INTO swp_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Abo se lau bousa wa se itasipoi komakomani, we’u wa se buigudulaei tauitaitawata se hetorodi se itawatai. ");
INSERT INTO swp_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabate wa ie ohi, asubena bagubagunana eai mara i uiari, Maria Magadala, eo Maria esau wa se laoma bousa bena se ita. ");
INSERT INTO swp_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Na moniinii tano i hetabutabubu ariri: paana Guiau ena aneru galewa eai i dobima, i laoma we’u wa bousa guduna eai i buihai, abo i bawabigabiga potana eai. ");
INSERT INTO swp_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ia ana ao doha namanamari, eo ana lulu ie posiposi doha sinou. ");
INSERT INTO swp_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tauitaitawataina ia se matausiei, eo se tabutabubuei, doha se hemala taumatemate. ");
INSERT INTO swp_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Aneru arinadi i heuio i ribalau sisine aridi eai i ene, “Tabu au matausi: ea nuatuiyao omi Iesu, ia se hesatauro wa, au eooi. ");
INSERT INTO swp_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ia inai nige’e: ia i toroo, doha i ribaeyao. Au laoma, Guiau edi abatorena ede au ita. ");
INSERT INTO swp_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Au lau heuheula, ena heaheatayao au heribadi ia mate eai i torouio’o: ia abo i bagunawa Galilaia eai; taiede ea heribamiu ede ina.” ");
INSERT INTO swp_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Isi se lauheuheula bousa wa se laugabaei nuadi se matamatausi eo se kode ariri: se aitautau bena ena heaheatayao wasana se heribadi. ");
INSERT INTO swp_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ma laudi ena heaheatayao bena wasana se heribadi, na Iesu i laubagibagiedi, i ene, “Eauedo!” Se laoma se abilau aena eai, ia se aihelahui. ");
INSERT INTO swp_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Iesu abo i ribalau aridi eai, i ene, “Tabu au matausi: au lau egu tataoyao au heribadi se lau Galilaia eai, nei eai abo se itagu.” ");
INSERT INTO swp_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ma laudi, na tauitaitawataina headi eanua eai se laoma, kohena lailaidi ginauri wa se tubu wa se heribadi. ");
INSERT INTO swp_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Maedi babada abo se oigogo, se oioiriba, moni lailai se mosei iala tataodi aridi eai. ");
INSERT INTO swp_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Si ene, “Omi abo au ene, ‘Maiona eai, ma enomai, ena heaheatayao se laoma se laemodigauiyao.’ ");
INSERT INTO swp_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ena wasa ta ie tubu gavana i ataiei, ai abo enamiu ai riba, arinai abo au lolo.” ");
INSERT INTO swp_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Arinai abo moni wa se abidi, doha wau se heatadi wa se abiwataidi: wau riba wa Iudea tataodi se ribaribaei i laoma e huia ta. ");
INSERT INTO swp_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Heaheata saudoudoi‐esega abo se lau Galilaia eai, oea tupina eai wa arinai Iesu i heribanonohaidio. ");
INSERT INTO swp_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ia abo se ita, se aihelahui: headi mo se heasaasaei. ");
INSERT INTO swp_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Iesu i laoma i ribalau isi aridi eai, i ene, “Gigiboridi gamagamagari se ledima arigu eai, galewa eai eo tanoubu eai hinage. ");
INSERT INTO swp_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Arinai abo au lau eanua gamagamagari au heatadi, au hebapatisoidi Tamana eo Natuna eo Earua Tabuna esana eai. ");
INSERT INTO swp_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Hari ginauri hari ginauri gamagamagaridi ea lauhesommiu ta, abiabiwataina au heatadi, na huia gamagamagari eau maemiu, i lau e tanoubu ana sigasiga eai.” Amen. ");
INSERT INTO swp_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Iesu Keriso, Eaubada Natuna, ena evanelia ina ie tubu. ");
INSERT INTO swp_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Doha peroveta edi uriuri eai si ene, “Egu tauwasa ea hetamarimugaiem, oa em eda i sepanonohai (Mal. 3.1); ");
INSERT INTO swp_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Esau arinana barabara eai i paipainawatai, i ene, Guiau ena eda au sepanonohai, eo ena eda au hedudurai” (Isa. 40.3). ");
INSERT INTO swp_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ioane barabara eai i hebahebapatiso, eo i guguia teina bapatiso eai ta bena nuadi se buidi, edi baaea abo se ribagigiridi. ");
INSERT INTO swp_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Iudea se ohihai, eo isi hinage Ierusalema taumiaina, se torohai se tupagogoma ia arinai, ia abo i hebapatisogogoidi Ioridana sagana eai, edi baaea abo se ribahemasarahadi. ");
INSERT INTO swp_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ioane ana lulu kamela wiana: ena nogi sarai opina, lokasi eo amoamo i aidi. ");
INSERT INTO swp_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ia i lauguguia, i ene, “Esau murigu eai i laoma i saetawatawaigu, eau nige ea lolo ea durudobi ia aena umna mainana ea eairi. ");
INSERT INTO swp_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Eau goila eai ea hebapatisoimiu ta, na ia Earua Tabuna arinai abo i hebapatisoimiu.” ");
INSERT INTO swp_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nei asubenana ne Iesu Nasareta Galilaia eai i laoma Ioane Ioridana eai i hebapatisoi. ");
INSERT INTO swp_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ia goila eai ma‐esega i gaeosaema, galewa ie ita i taigari, Earua ana ao doha bunebune i pesadobima ia potana eai. ");
INSERT INTO swp_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Arina esau galewa eai i laoma, i ene, “Oa Natuyogoyogoigu, nuagu u helolo ariri” (Ps. 2, Isa. 62). ");
INSERT INTO swp_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Abotai Earua Iesu i woeai i laei barabara eai. ");
INSERT INTO swp_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Asubena tatao‐labui‐si‐mate barabara eai Satani ia i nohoi, sarai aiailetadi aridi eai ie mia; aneru ia se bobodiei. ");
INSERT INTO swp_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ioane numa masigiri eai se tutuguduiyao abotai Iesu Galilaia eai i laoma Eaubada ena basileia wasa lolona i lauguguiaei. ");
INSERT INTO swp_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","I ene, “Huia wa i lagemao, Eaubada ena basileia i hanahanaumao; nuamiu au buidi, evanelia ta au awamamohoiei.” ");
INSERT INTO swp_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ia Galilaia gabogabona salagomgomna eai i laulau Simona ma ena tau Anederea edi hiana se galaei gabogabo eai: isi taudi labui tauyamayama. ");
INSERT INTO swp_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Iesu i heribalaedi i ene, “Au hemuriwataiguma, abo au hemala tatao tauyamayamaidi.” ");
INSERT INTO swp_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ma‐esega se torohai edi hiana se laugabaedi ia se hemuriwatai. ");
INSERT INTO swp_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ia i bagunalau Sebedaio nanatunayao Iamesi ma ena tau Ioane i itadi, isi hinage waga eai edi hiana se eome. ");
INSERT INTO swp_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ma‐esega i eogalaedi: isi tamadi Sebedaio ma ena tauhaiwawari waga eai se pesagabaedi, Iesu murina eai se lau. ");
INSERT INTO swp_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Isi Kaperenauma eai se lage: asubena Sabati eai i awasae sunago alona eai, i lauheata. ");
INSERT INTO swp_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ena lauheata se nooei: i ribahasahasaidi ma gigiborina, nige doha tauuriuri tataodi. ");
INSERT INTO swp_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Sunago wa alona eai tau esau earua biibii i lui, i eabayaba. ");
INSERT INTO swp_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","I ene, “U otaotaimai, oa saha arimai eai bena u abi? Iesu Nasareta e? Oa u laoma bena u hetatagorigorimai wa? Ea itam, oa Eaubada ena Hetabu Tauna ede.” ");
INSERT INTO swp_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iesu ia i siooei, i ene, “U monou, u lulagema.” ");
INSERT INTO swp_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Earua biibiina ia i basaaraaratei, eo i eabayaba lailai, i lulagema. ");
INSERT INTO swp_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Isi gamagaridi abo se noo, se heunaboisahaei, si ene, “Teina ginauri ta saha? Teina lauheata harihariuna ta saha? Ena gigibori eai earua biibiidi i ribahesomdi abo se hebigawatai.” ");
INSERT INTO swp_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nige baeaona ia wasana ie lau Galilaia i hetaiiriyama. ");
INSERT INTO swp_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Sunago eai se pesama, se awasae Simona ma ena tau Anederea edi numa eai, Iamesi eo Ioane maediyao. ");
INSERT INTO swp_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simona bosiana sine ie ota, tauna se gigibori ariri, arinai Iesu se heribalaei. ");
INSERT INTO swp_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","I laoma, i abilau ia nimana eai i abihetoro; arinai gigiborina wa i lautom, sine wa abo i haitalaidi. ");
INSERT INTO swp_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Maimailahi eai, mahana i duio, tauasiasiebo gamagaridi se woeaidima ia arinai, eo isi demoni se luidi hinage. ");
INSERT INTO swp_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Eanua tataodi gamagaridi se oigogoma dobila eai. ");
INSERT INTO swp_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tauasiasiebo udoi, udoi, gamagaridi i hemauridi, demoni hinage gamagaridi i aiduiedi, demoni wa nige arinadi paana ia se nuatuiyao. ");
INSERT INTO swp_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mara sora nige i iuiari Iesu i torohai ie pesa, ie lau malatupama eai, nei eai i lau‐uura. ");
INSERT INTO swp_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simona eo isi maenayao wa ia murina eai se lau. ");
INSERT INTO swp_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ia se lobai se ribalau ia arinai, si ene, “Tatao gamagaridi se eooim.” ");
INSERT INTO swp_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ie ribalau aridi eai, i ene, “Ta lau eanua headi hanahanau eai bena hinage nei eai ea lauguguia: hesabana ede ina ea laoma ta.” ");
INSERT INTO swp_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Galilaia se hetaiiri edi sunago alodi eai i lauguguia, demoni hinage i aiduiedi. ");
INSERT INTO swp_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Lepera tauna esau i laoma Iesu arinai ia turina ie bono ia nuanuana eai, i awanori gadogadora, i ene, “Taba u henua, oa heaagu abina u ata.” ");
INSERT INTO swp_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iesu ia i nuatoatoaei, nimana i helele, i abiitalaei, ie ribalau ia arinai, i ene, “Ea henua, oa abo u aa.” ");
INSERT INTO swp_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ie riba ina doha ma‐esega ana lepera i uruosi, na i aao. ");
INSERT INTO swp_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Iesu ia i ribahasahasai, abo i hetamari ie lau. ");
INSERT INTO swp_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","I ribalau arinai, i ene, “Tabu tau esau u heriba; u lau oabom u hemasaraham kohena tauna arinai, oa se heaam wa am nima abia u abi doha Mose i lauhesomda, laulau ede meta abo se ita. ");
INSERT INTO swp_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Na, ia mo ie pesa i ribahemasaraha, wasana i duai i hetadada, arinai Iesu nige i laumasaraha eanua eai, ia simalaleilei eai mo ie mia, isi dimo gamagaridi eai se laoma ia arinai.” ");
INSERT INTO swp_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Huiana nige eawalana Iesu i uio Kaperenauma; wasana abo ie lau, ia numa eai. ");
INSERT INTO swp_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Arinai tatao gamagaridi se oigogoma, numa nige susuana, numa dobilana hinage nige susuana, riba wa i guguiaei aridi eai. ");
INSERT INTO swp_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Isi abo se laoma ia arinai tau palisi esau se baheiama, taudi hasi taubaheiamana. ");
INSERT INTO swp_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Moutuana lailai se guduguduidi arinai nige edi aba laoma Iesu arinai, isi atohi se soelapai, se soeheohi, tau palisi wa ma hatahatana se hedawedobei. ");
INSERT INTO swp_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Iesu edi sunusunuma ie ita, ie ribalau taupalisi ne arinai, i ene, “Natugu e, baaeam se ribagigiridio.” ");
INSERT INTO swp_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tauuriuri tataodi headi nei eai se babawa nuadi eai se heunaboisahaei, si ene. ");
INSERT INTO swp_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Teina tau ta ie saha Eaubada ie ribabaaeai ina doha? Eai baaea ribagigirina abina ie ata, Eaubada iabom?” ");
INSERT INTO swp_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Edi heunaboisahausi Iesu earuana eai i lobaiyao, ie ribalau aridi eai i ene, “Teina ginauri ta sahana au heunaboisahaei? ");
INSERT INTO swp_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Aitea ribariba masarahana, tau palisi arinai ea ene, ‘Baaeam se ribagigiridi,’ e abo ea ene, ‘U toro, em aba‐eno u abi u lau?’ ");
INSERT INTO swp_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Omi abo au ita Tau Natuna tanoubu eai ta ia gigiborina eai baaea i ribagigiridi,” (ie ribalau taupalisi ne arinai) i ene, ");
INSERT INTO swp_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ea ribalaowa oa arim eai ea ene, ‘U toro, em aba eno u abiisini, u lau em numa eai.’” ");
INSERT INTO swp_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ia abo i torohai aba eno wa ie abiisini isi gamagaridi matadi eai ie lau; gamagaridi se nooei, eo Eaubada se hedebasaei, si ene, “Teina laulau ta nabada wa nige ta itaitai.” ");
INSERT INTO swp_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ia ie uio salagomgom eai tatao gamagaridi moutuadi se tupagogo ia arinai, ia abo i heatadi. ");
INSERT INTO swp_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ia ie baeawa, Levi, Alepaia natuna, ie ita, takisi edi ofesi aba paisoa eai i babawa, ie ribalau ia arinai, i ene, “U hemuriwataiguma.” Ia i torohai abo murina eai ie lau. ");
INSERT INTO swp_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Abotai Levi ena numa eai Iesu i babawa i aiai, telona tataodi gamagaridi Iesu maena heaheatayao se bawalau; se gamagari ariri, eo ia murina eai se lau. ");
INSERT INTO swp_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tauuriuri tataodi, to Parisea tataodi, Iesu se ita takisi tau‐tanogogo tataodi eo baaea tataodi maedi se aiai esega, se ribalau ena heaheatayao aridi eai, si ene, “Ia ie saha nei, telona tataodi eo baaea tataodi maedi se aiai esega, eo se nomgogo esega?” ");
INSERT INTO swp_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Iesu i ataieyao abo i ribalau aridi eai, i ene, “Tatao maumauridi doketa nige se nuatui, tatao asiasiebodi mo; eau nige ea laoma tatao laulaududurai ea eogaidi; tatao baabaaea mo nuadi abo se buidi.” ");
INSERT INTO swp_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ioane ena heaheatayao, eo Parisea edi heaheatayao se aiaiudi; isi se laoma ia arinai, si ene, “Ioane ena heaheatayao, eo Parisea edi heaheatayao ie saha se aiudi, na oa em heaheatayao nige se aiudi?” ");
INSERT INTO swp_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iesu ie ribalau isi aridi eai, i ene, “Tautawasora harihariu maedi se mia esega taba nige se aiudi. ");
INSERT INTO swp_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Asubenana ne abo i lagema tautawasora harihariu abo se laehesuara nei asubenana ne abo se aiudi. ");
INSERT INTO swp_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Nige tau esau lulu harihariuna i popoi lulu beabeana arinai: ata harihariuna se popoi lulu beabeana eai wa abo i tapurisi ariri. ");
INSERT INTO swp_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Hinage nige tau esau waina harihariuna i leduhi, sarai opina beabeana alona eai: ena doha meta waina harihariuna sarai opina i aipurisi, abo i boriri, sarai opina hinage abo i hebaaea. Na waina harihariuna se hegoi sarai opidi harihariudi alodi eai. ");
INSERT INTO swp_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabati eai i oiluhulau wheat oeana alona eai, eo ena heaheatayao, ma laulaudi, wheat aiaidi se aiworaidi. ");
INSERT INTO swp_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Parisea tataodi se ribalau ia arinai, si ene, “U ita edi laulau ne, se saha asubena sabati laugagaeona nige se nuatui?” ");
INSERT INTO swp_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ia ie ribalau isi aridi eai, i ene, “Davida ena laulau nige au hasiri wa, ma ana sasaguyao nei huiana ne se wesarimate? ");
INSERT INTO swp_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ia ie lusae Eaubada ena numa alona eai, Abiatara kohena wasawasa huiana eai, eo areto ie ai, heana hinage i mosei ana sasaguyao se ai, aiai tabuna, hari tatao nige se ai, kohena tataodi isibom mo se ai.” ");
INSERT INTO swp_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ia ie ribalau isi aridi eai, i ene, “Sabati se hetabuei tatao enadi: tatao Sabati enana nige’e: ");
INSERT INTO swp_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","arinai Tau Natuna ia Sabati tanuagana hinage.” ");
INSERT INTO swp_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ia i awaseuio sunago alona eai; tau esau nei eai nimana i tubu eaeyaelua. ");
INSERT INTO swp_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Isi ia se itadidini, tauna ne bena abo i hemauri asubena Sabati eai; ia bena abo arinai se hegiru. ");
INSERT INTO swp_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ia ie ribalau tau nimana i tubu eaeyaelua wa arinai, i ene, “U toro masarahama.” ");
INSERT INTO swp_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ia ie ribalau isi aridi eai, i ene, “Aitea laulau abo i lolo ede, asubena Sabati eai ta abihemauri e, ta aiunu?” Isi abo se monou. ");
INSERT INTO swp_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ia i matabarabara hetahetaiiridi ana ou i ealayala, ia nuana i amamna paana nuadi se oiura ariri, ie ribalau tauna ne arinai, i ene, “Nimam u heleleama.” Ia abo nimana i helelelaei: nimana wa i mauriuio doha hinage esau. ");
INSERT INTO swp_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Parisea tataodi se lau isi maedi Herodiana tataodi, ia se oiribaei edohana bena ia abo se unui. ");
INSERT INTO swp_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesu maena heaheatayao se lausuara se lau geregere eai. Galilaia tataodi to Iudea tataodi, moutuana lailai ia se hemuriwatai. ");
INSERT INTO swp_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Eo Ierusalema tataodi hinage, eo Idumea, eo Ioridana murina eai, eo Turia eo Sidona, se laoma ia arinai. ");
INSERT INTO swp_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ia ena heaheatayao i heribadi, i ene, waga gagirina se abi enana paana moutuana wa ata doha se hetauihiihiei. ");
INSERT INTO swp_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ia moutuana i hemahemauridi arinai tatao asiasiebo gamagaridi ia se lauihiihiei, bena ia se heasailaei. ");
INSERT INTO swp_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Eo earua biibiidi ia se ita se gurisalaoba ia nuanuana eai, se eogayoga, si ene, “Oa Eaubada Natuna ede.” ");
INSERT INTO swp_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ia abo i guguiaidi tabu ia se wasawasaei. ");
INSERT INTO swp_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Abo ie lau oea tupina esau eai, isi headi i henuadi i eogaidi, isi abo se laoma ia arinai. ");
INSERT INTO swp_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Tatao saudoudoi‐labui i hetorodi isi bena se laoma ia arinai maenayao se miamia, eo bena abo i hetamaridi se lauguguia. Ia gigiborina i mosei isi aridi eai, arinai tatao asiasiebo abo se hemauridi, eo demoni hinage abo se aiduiedi: ");
INSERT INTO swp_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Simona ia esana i torebui Petero: ");
INSERT INTO swp_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Iamesi maena tau Ioane, Sebedaio nanatunayao, esadi hinage i torebuidi Boanere, heaheasonina doha ede, parere nanatunayao. ");
INSERT INTO swp_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anederea eo, Pilipo eo, Batalomaio eo, Mataio eo, Toma eo, Iamesi Alepaio natuna eo, Tadaio eo, Simona Kanana tauna. ");
INSERT INTO swp_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Iuda Isakariota hinage, ia taumoruina ede: isi se lau numa esau alona eai. ");
INSERT INTO swp_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Moutuana se tupagogoma, arinai aiai nige begana se ai. ");
INSERT INTO swp_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ia ehanayao wasana se ataiei abo se lau ia bena se abinuahi, si ene, “Ia bena i eaueaure.” ");
INSERT INTO swp_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tauuriuri tataodi Ierusalema eai se dobima, si ene, “Belesebulo ia boeana eai, demoni edi wasawasa ena gigibori eai demoni i aiduiedi.” ");
INSERT INTO swp_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ia i eogaidi parabole headi i ribalau aridi eai, arinai i ene, “Satani edohana Satani i aiduiei? ");
INSERT INTO swp_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","25","Taba basileia esau tupona se haitoremuri, meta basileia ne nige i torotahitahi. Taba boga headi se haitoremuri, meta adi boga nige se torotahitahi. ");
INSERT INTO swp_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Taba Satani iabom i ialaiuioi, nuana labui, ia nige i torotahitahi, abo i lautom. ");
INSERT INTO swp_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nige tau esau i awasae gaibu mo tauoroorosiara ena numa eai ena gogo i girihaidi, tauoroorosiara wa i au mugaiei; abo ena numa ginauridi i girihaidi. ");
INSERT INTO swp_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ea heribamiu ta mamohoi, baaea gamagaridi, eo Eaubada ribahebaaeana tatao nanatudiyao aridi eai abo se nuatugabaedi. ");
INSERT INTO swp_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Na, ena tau esau Earua Tabuna i ribahebaaea, baaeana wa taba nige se nuatugabae, ia mate nige nosina abo i hearo.” ");
INSERT INTO swp_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Paana ede isi si ene, “Earua bii ie abi ia boeana eai.” ");
INSERT INTO swp_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ena tataoyao, eo sinana se lagema murimuri eai se totoro, tau esau se hetamari ia arinai, ia se eogai. ");
INSERT INTO swp_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Moutuana ia se bawahetaiiri, se ribalau ia arinai, si ene, “Sinam, eo em tataoyao murimuri eai se eooim.” ");
INSERT INTO swp_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ie ribalau isi aridi eai, i ene, “Sinagu eai? eo egu tataoyao aidimodi?” ");
INSERT INTO swp_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Isi ia se bawapaipaiei i matabarabaraidi, i ene, “Sinagu eo egu tataoyao ede ina! ");
INSERT INTO swp_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Eai to eai Eaubada ena nuatu se ginauriwatai egu tau ede, lougu ede, sinagu ede.” ");
INSERT INTO swp_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ia i heatauioidi geregere eai, moutuana lailai se tupagogoma ia arinai, ia waga potana eai i babawa, moutuana wa geregere eai se torogogo. ");
INSERT INTO swp_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ginauri gamagaridi i heatadi parabole eai, ena lauheata aridi eai i ene. ");
INSERT INTO swp_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Au ataiei, tauhesuhesuru ie lau tuma i hesuhesuru. ");
INSERT INTO swp_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","I hesuhesuru, headi se beu eda gegesina eai, malagaibu manudi se laoma se aidi. ");
INSERT INTO swp_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Headi se beu malatetepari eai, tano nige bulumana, se ini heuheula paana tano i earoyaro mo. ");
INSERT INTO swp_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mahana i dalasae se wowoea: nige lamdi, arinai se wowoea. ");
INSERT INTO swp_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Headi nuri boeadi eai se beu, nuri abo se ini, se ima, abo nige se ua. ");
INSERT INTO swp_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Headi hinage se beu tano lolona eai, se ini, abo se tubu se ua: headi tau‐esega‐i‐mate‐saudoudoi, headi tatao‐haiona‐se‐mate, eo headi tatao‐haligigi‐se‐mate.” ");
INSERT INTO swp_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ia i ribalau isi aridi eai, i ene, “Ia beana eai i ataiei, abo i ataieididini.” ");
INSERT INTO swp_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Iabom ie mia, isi headi maena heaheatayao saudoudoi‐labui ia gegesina eai se bawagogo ina parabole ta se hesioei ia arinai. ");
INSERT INTO swp_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ie ribalau aridi eai, i ene, “Eaubada ena basileia ginauri eamuyamuidi se hemasarahadi omi arimiu eai: isi murimuri tataodi ginauri gamagaridi parabole eai mo se heatadi. ");
INSERT INTO swp_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Isi se itaita taba nige se ita: isi se ataiei taba nige se ataiei, ata se heasibuiuioiama, eo isi baaeadi abo se ribagigiridi.” ");
INSERT INTO swp_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ia abo ie ribalau isi aridi eai, i ene, “Parabole ta teina nige au nuatui wa? Parabole gamagaridi abo edohana emi nuanuatuidi? ");
INSERT INTO swp_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tauhesuhesuru ia ede riba tauhesuhesuruna. ");
INSERT INTO swp_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tuma headi se beu eda gegesina eai, isi ede, riba se hesuhesuru, Satani i heulama, riba wa se hesuru nuadi eai i abihai, i laei. ");
INSERT INTO swp_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tuma headi se beu tano malatetepari eai; isi ede riba wa se ataiei, se abi ma nualolodi. ");
INSERT INTO swp_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Isi nuadi eai nige lamdi, se abi, nige baeaona tatao abo se hebaaeadi teina riba ta debana eai, se alabesibesi. ");
INSERT INTO swp_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Tuma headi nurinuri boeadi eai se beu, isi riba tauataiena. ");
INSERT INTO swp_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Tanoubu mo nuatudi, eo gogo gamagari nuadi se amnaedi, hari ginauri se gadosisidaoiedi, riba wa se hetaupurupuru, abo nige ie ua. ");
INSERT INTO swp_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tuma headi tano lolona eai se beu isi ede tauataiena riba wa se abi, abo ie ua, headi tauesega‐i‐mate‐saudoudoi, headi tatao‐haiona‐se‐mate, headi tatao‐haligigi‐se‐mate.” ");
INSERT INTO swp_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ia ie ribalau isi aridi eai, i ene, “Lamepa se leama abo se tore gulewa ubuna eai e abaeno ubuna eai wa? nige se tore ena aba ota tahunuana eai? ");
INSERT INTO swp_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ginauri gamagaridi tautauyamuidi, abo se hemasarahadi; ginauri gamagaridi se toreyamuidi abo se wasawasaedi. ");
INSERT INTO swp_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ena tau esau beana eai i ataiei, abo i ataieididini.” ");
INSERT INTO swp_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ia i ribalau isi aridi eai, i ene, “Au ataiei komakomani; nonoi wa arinai au nonoiei abo hinage se nonoiei arimiu eai, eo omi tauataiena enamiu abo se helaiawa. ");
INSERT INTO swp_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ia ie abi, enana abo se mosei, ia hinage nige ie abi, enana begana ie abi wa abo se laeudoiei.” ");
INSERT INTO swp_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ia abo i ene, “Eaubada ena basileia doha tau esau tuma i hesuhesuru tano eai. ");
INSERT INTO swp_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Maiona eai ie eno; asubena eai i toro, uaua i kapokiarima abo ie tubu, tuma ena iniini tau wa nige i nuatui edohana. ");
INSERT INTO swp_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tano iabom i abiheiniyama, i ini bagubaguna, abotai abo ie boga, e abotai abo sitona ie suna boga alona eai. ");
INSERT INTO swp_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Sitona aiaina abo ie suna, ia abo ie tom, paana masuri ie lage.” ");
INSERT INTO swp_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ia abo i ene, “Eaubada ena basileia ta saha arinai ta heaheasoniei? Ginauri esana abo arinai ta heaheasoniei? ");
INSERT INTO swp_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ia doha hinage sinapi tumana, esega se umai tano boeana eai, i gagiri ariri, tuma gamagaridi tano boeana eai iabom i gagiri ariri. ");
INSERT INTO swp_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Se umai, abo ie tubu lailai, oeagi gamagaridi ia abo i tubutawatawaidi, lagana lailaidi se ini, malagaibu manudi abo se toalau loguloguna eai.” ");
INSERT INTO swp_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Teina doha ena riba gamagaridi i heatadi parabole eai, isi edi sibasiba i heaigonogonoaiei. ");
INSERT INTO swp_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Riba parabole eai mo ie ribalau aridi eai; isibom mo se mia suara, riba aniodi abo i hemasarahadi ena heaheatayao aridi eai. ");
INSERT INTO swp_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Meta asubenana ne, maimailahina eai, Iesu ie ribalau aridi eai, i ene, “Ita ta awasi, ta lau hari sana awasi eai.” ");
INSERT INTO swp_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Isi tatao moutuana se hetamaridi se lau, ia se abi waga eai, isi maedi. Waga headi maedi se lau. ");
INSERT INTO swp_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mana lailai abo ie toa, butubutu i iniinisae waga alona eai, bena i monau. ");
INSERT INTO swp_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ia ie eno waga tupo lalaki eai, unua potana eai; ia abo se hanoi, se ribalau ia arinai si ene, “Tanuagamai e, ai ata doha aie mate, oa nige u nuatuimai?” ");
INSERT INTO swp_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ie toro, mana abo i ribahetaru, eo ie ribalau butubutu arinai, i ene, “Besi, u lautom!” Mana abo ie motu; i daumori ariri. ");
INSERT INTO swp_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ia abo ie ribalau isi aridi eai, i ene, “Saha au matausini? Edohana nige emi sunuma?” ");
INSERT INTO swp_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Isi abo se matausi ariri, edi ribariba si ene, “Ina tau ta tau sahasahaina, mana eo butubutu hede ia se awaabiei?” ");
INSERT INTO swp_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Isi abo se dunasae hari sana awasi eai, Geresene edi oea eai. ");
INSERT INTO swp_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ia waga i pesagabaei, tau esau earua biibii se lui bousa eai i laoma Iesu i hailobai. ");
INSERT INTO swp_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tau wa ena aba miamia bousa eai; eo nige tau esau abina ie ata bena i auaui, maina poasi eai hinage nige se auaui. ");
INSERT INTO swp_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Huia gamagari ia se pai, maina poasi eai se auaui, poasi abo i hetamotudi; nige tau esau abina i ata bena ia i hemanasa. ");
INSERT INTO swp_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Huia gamagamagari, maiona to asubena, ia oea eai, eo bousa eai i miamia, i eabayaba, eo sapaila ie abi i aisasaroiuioi. ");
INSERT INTO swp_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Na, Iesu ie ita ia eda lohaloha eai abo i aitautau i aihelahui. ");
INSERT INTO swp_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ie eaba lailai, i ene, “Iesu e, Eaubada saesaearirina Natuna e, abi saha abo ea abi arim eai? ea awanorilaowa Eaubada esana eai, tabu u heamamnagu.” ");
INSERT INTO swp_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Iesu ie ribalau ia arinai, i ene, “Earua biibii e, tau me u pesagabaeama.” ");
INSERT INTO swp_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Iesu i hesiolau ia arinai, i ene, “Esam eai?” Ia abo i heuio, i ene, “Eau esagu ede Legeona, paana ai gamagarimai hinage.” ");
INSERT INTO swp_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ia i awanoridaoi i ene tabu i aiduiedi ina eanua eai ta. ");
INSERT INTO swp_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Oea lalalai hanahanaudi eai sarai eawoidi lailai se dumudumuri. ");
INSERT INTO swp_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Demoni gamagaridi se awanorilau ia arinai, si ene, “U hetamarimai abo ai lulau tenei sarai eawoidi ne boeadi eai.” ");
INSERT INTO swp_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Iesu ie eari, Earua biibiidi gamagaridi abo se pesa se lulau sarai eawoidi boeadi eai: isi abo se aitautau, se leta, se dobi padipadi eai, se beugogo gabogabo eai, abo se galamosi. Isi tausani labui. ");
INSERT INTO swp_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Sarai wa tauheaheaidi abo se dago wasa wa se wasaduaiei eanua eai, eo gougou eai. Eanua tataodi abo se lau, laulau ne bena abo se ita. ");
INSERT INTO swp_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Isi Iesu arinai se lage, tau wa demoni se lui wa se ita ie bawabigabiga, eo lulu ie lui, hinage ie sabaauei; isi abo se matausi. ");
INSERT INTO swp_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Isi tauitana enadi se wasaduai, ia ena abiabina demoni tauluina wa arinai, eo sarai eawoidi wasana hinage. ");
INSERT INTO swp_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Isi abo se awanorilau Iesu arinai, edi eanua ne bena i laugabaei. ");
INSERT INTO swp_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ia waga eai ie awasae, demoni tauluina wa i awanorilau bena ia maena. ");
INSERT INTO swp_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Iesu nige ie eari, na ie ribalau ia arinai, i ene, “U lau em asa ehamyao aridi eai Eaubada ena gigibori i hemasaraha oa arim eai, eo i nuatoatoaim hinage, u heribadi.” ");
INSERT INTO swp_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ia abo i lau, Dekapoli eai Iesu ena gigibori i wasaduaiei, eo tatao gamagaridi se noo ariri. ");
INSERT INTO swp_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iesu ie geru waga eai ie uio hari sana awasi eai, tatao gamagaridi se tupagogoma ia arinai: ia gabogabo hasarina eai. ");
INSERT INTO swp_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Sunago tanuagana esau i laoma ia arinai esana Iairo; ia Iesu ie ita, ia abo i gurisalaoba Iesu aena eai. ");
INSERT INTO swp_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ia ie riba gadogadoralau ia arinai, i ene, “Natugu siu gagirina hanahanau ata ie mate; u laoma nimam u saolaei ia potana eai abo i lolo, ia abo i mauri.” ");
INSERT INTO swp_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Iesu maena se lau. Eo tatao gamagaridi ia se hemuriwatai, ia se heduheduiahalai. ");
INSERT INTO swp_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Sine esau ana asiebo osina i laulau miana borimai saudoudoi‐labui. ");
INSERT INTO swp_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Doketa gamagaridi se laoma ia arinai, arinai ena moni se heohi, ana asiebo nige i lautom, i laulaubodauioi hinage i helai. ");
INSERT INTO swp_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ia Iesu wasana i ataieyao, ia tatao moutuadi muridi eai i laoma, ia ana lulu i abiita. ");
INSERT INTO swp_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ia ena nuatu i ene, “Taba ena lulu mo ea abiita abo ea lolo.” ");
INSERT INTO swp_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Maesega ana asiebo osina i lautom; tauna eai amnana i ataiei ana iwala i tatapesa. ");
INSERT INTO swp_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Iesu i nuatulobai gigiborina i laulaei, i sinibuiuio tatao moutuadi aridi eai, i ene, “Agu lulu ta eai i abiitayama?” ");
INSERT INTO swp_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ena heaheatayao abo se ribalau ia arinai, si ene, “Tatao moutuadi ue itadi se aiheduheduiahalaim, saha ede u hesioi, u ene, ‘Eai ede i abiitaguma?’” ");
INSERT INTO swp_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Iesu abo i itahetaiiri sine wa ena laulau nei doha ie ita. ");
INSERT INTO swp_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Na, sine ne ie ita ena abiabi ia arinai i nuatulobai i matausi, eo i tabutabubu, ia abo i laoma i gurisalaobadobi Iesu nuanuana eai, ena laulau i ribahemasaraha. ");
INSERT INTO swp_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Iesu ie ribalau ia arinai, i ene, “Natugu sine e, oa em sunuma eai arinai ede u lolo; u lau ma nuabigam am iwala me it tatapesao.” ");
INSERT INTO swp_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ma ribaribana headi sunago tanuagana ena numa eai se laoma, si ene, “Natum siu wa i mateo; Tanuagada sahana u hemode?” ");
INSERT INTO swp_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Iesu teina riba ta i ataiei, ie ribalau sunago guiauna arinai, i ene, “Tabu u matausi, u awamamohoiei mo.” ");
INSERT INTO swp_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ia tatao ie ribanuahidi ia tabu se hemuriwatai, Petero mo, eo Iamesi, eo Iamesi ena tau, Ioane. ");
INSERT INTO swp_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ia abo ie lage sunago guiauna ena numa eai, isi se hetalalilolilousi i itadi, eo se doudou ariri hinage. ");
INSERT INTO swp_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ia i awasae numa alona eai, i ribalau aridi eai, i ene, “Saha au hetalaliloliloei, eo au doudoui? Siu me nige ie mate, ie eno mo.” ");
INSERT INTO swp_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Isi ia se marumaruhiei. Isi gamagaridi i aiduiedi se pesa murimuri eai; siuna ne tamana ma sinana ie woeaidi, ma ana sasaguyao hinage se lusae biri eai siuna ne ena aba ota eai. ");
INSERT INTO swp_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ia siu nimana eai ie abilau, i ribalau ia arinai, i ene, “Talita kumi,” heaheasonina ede, “Siu e, ea heribam ta, u toro.” ");
INSERT INTO swp_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Siuna ne i torohai, eo i laulau; ena borimai saudoudoi‐labui. Isi se nooariariri. ");
INSERT INTO swp_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ia isi i guguiaidi tabu se wasawasaei, eo i lauhesomdi, i ene, “Siu me aiai begana au mosei i ai.” ");
INSERT INTO swp_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Nei dimo ne i laugabaei abo i laoma ena eanua tahunuana eai; ena heaheatayao ia se hemuriwatai. ");
INSERT INTO swp_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Asubena Sabati esau i hearo, ia abo i hetubu i heatadi sunago alona eai tatao gamagaridi ena riba se ataiei, abo se noonooei, si ene, “Tau ta, teina ginauridi ta, haedi i abidi? Sonoga sahasaha ina se mosei ia arinai paisoa gigiborina teina ia nimana eai i ginauridi? ");
INSERT INTO swp_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Teina kamda natuna, e nige’e wa, Maria natuna, Iamesi ena tau, eo Iose, eo Iuda, eo Simona? Ia lounayao ita maeda ta miamia wa, e nige’e?” ");
INSERT INTO swp_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Na, Iesu i ribalau isi aridi eai, i ene, “Peroveta se heasisiei ena eanua tahunuana eai mo nige’e, ana bogao mo nige’e, ena asa eai mo nige’e.” ");
INSERT INTO swp_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Arinai nei eanua eai ena gigibori bena i hemasaraha nige abina i ata, tatao asiasiebo mo headi ia nimana i toresaei isi potadi eai i hemauridi. ");
INSERT INTO swp_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Isi edi awayagara i nooei. Ia ie lau eanua gougou gamagaridi eai, tatao i heaheatadi. ");
INSERT INTO swp_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Saudoudoi i eogaidi, labui to labui i hetamaridi, gigiborina i mosedi earua baaeadi abo se aiaiduiedi. ");
INSERT INTO swp_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ia abo i heribadi isi edi aitaumana gogo tobona tabu se bahei, tabu aiai, tabu moni tobo alona eai, tue ahaaha mo se abi. ");
INSERT INTO swp_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Aeum mo se audi; tabu pereue labui se luidi. ");
INSERT INTO swp_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ie ribalau aridi eai, i ene, “Dimona emi aba lusae numa alona eai arinai au mia, e, dimo wa abo au laugabaei. ");
INSERT INTO swp_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Eai to eai nige se oeamimiu, eo emi riba nige se ataiei, au lau na geregere se patu aemiu eai au oiluiluigabaedi, isi heiheinoidi. Mamohoi ea heribamiu ta, hedudurai asubenana eai Sodoma eo Gomara edi baaea si ene nige ie lai doha wau eanua wa.” ");
INSERT INTO swp_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Isi abo se lau, se lauguguia bena tatao nuadi abo se buidi. ");
INSERT INTO swp_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Demoni gamagaridi se aiduiedi: tauasiasiebo gamagaridi bunama eai se heausidi, eo se abihemauridi. ");
INSERT INTO swp_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Heroda, Wasawasa, Iesu wasana i ataiei, i ene, “Nuana Ioane Bapatiso ede ina, ia mate eai ie torouioma, arinai ede paisoa gigibori ia i hemasarahadi.” ");
INSERT INTO swp_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Headi si ene, “Nuana Elia”; eo headi si ene, “Nuana peroveta, doha hinage peroveta beabeana esau.” ");
INSERT INTO swp_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Heroda abo i ataiei, i ene, “Ia ede Ioane, ia gadona ea totom, mate eai i torouioma.” ");
INSERT INTO swp_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Paana Heroda i ribayao Ioane abo se toai, se au, numa tutugudu eai se tore, paana Heroda ena tau Pilipo monena, Herodia, i tawasorai. ");
INSERT INTO swp_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ioane ie ribalau Heroda arinai, i ene, “Laugagaeo u utusi, si ene, oa em tau monena tabu u tawasorai.” ");
INSERT INTO swp_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Arinai Herodia ia i ouyalayalaei, ia unuina i henua; nige ana mata paana. ");
INSERT INTO swp_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Heroda Ioane i matausiei, i italobai ia tau laulaududurai, eo ia hetabu tauna, ia Ioane i itawataikomakomani; ia ena riba i ataiei, nuana i tuditudi, nuana hinage i lolo. ");
INSERT INTO swp_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ena nuatu i nuatui, e, huiana ie lage Heroda ena huia labasi, ia mataasi i mataasiei maena guiau wasawasadi, eo Galilaia babadadi, ");
INSERT INTO swp_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodia natuna, siu, ia abo ie lau isi matadi eai ie saga, Heroda ma ana matagabanu nuadi se lolo, se kode ariri, arinai wasawasa ie ribalau siu ne arinai, i ene, “Oa em gadosisi aisana u awanorima, abo ea leawa.” ");
INSERT INTO swp_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ia ie riba, abo i aigora, i ene, “Ena arigu eai ginauri u gadosisiei, u ribaei, abo ea leawa enam, ena u henua egu basileia teina tehana esau enagu, tehana esau enam.” ");
INSERT INTO swp_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Siu ne abo ie lau sinana arinai i hesiolau, i ene, “Saha abo ea awanorini wa?” Ia i ene, “Ioane Bapatiso uruuruna.” ");
INSERT INTO swp_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ia abo i uioma heuheula guiauna ne arinai, i awanorilau, i ene, “Eau egu gadosisi ede teina, Ioane Bapatiso uruuruna abo u usaiama gaeba alona eai.” ");
INSERT INTO swp_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Wasawasa wa nuana i baaea ariri; na paana ana matagabanu ena aigora se ataieyao, arinai ede ia nige i talaoriori. ");
INSERT INTO swp_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Wasawasa tauaiaiunu esau ie heribalaei, i ene, “Ioane uruuruna u abiyama.” Ia abo ie lau numa tutugudu eai, ia gadona ie tomutusi. ");
INSERT INTO swp_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ia uruuruna i baheiama gaeba alona eai, i moselaei siuna ne arinai, siu ne i laei sinana arinai. ");
INSERT INTO swp_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ioane ena heaheatayao abo se ataiei, abo se laoma, eaibarabarana se bahei, bousa eai se tore. ");
INSERT INTO swp_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Apostolo tataodi se tupagogoesegaidima Iesu arinai, wasa gamagari ia se heriba, isi adi wawari, eo edi lauheata se wasaduaiei ia arinai. ");
INSERT INTO swp_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ia ie ribalau isi aridi eai, i ene, “Omibom au lausuarama, ta lau malatupama eai, ta aiyawasi sora.” Tatao gamagari se laoma na, se lau, se hemodedi nige edi huia bena se aiyawasi. ");
INSERT INTO swp_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Isi waga eai se geru mahimahihi, se lau malatupama eai. ");
INSERT INTO swp_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Isi edi aba lau ne tatao se ita, gamagaridi se nuatuiyao, eanua gamagamagari eai isi abo se aitautau, se lage bagunao, abo se tupagogoma ia arinai. ");
INSERT INTO swp_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Iesu abo ie dunasae moutuana lailai i itadi, eo i nuatoatoaidi, paana isi doha mamoe nige taumiataunidi; ia i hetubu ginauri gamagaridi i heatadi. ");
INSERT INTO swp_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mahana ie tarueo, ena heaheatayao se laoma ia arinai, si ene, “Malatupama ina mahana hede i duio ta. ");
INSERT INTO swp_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","U hetamaridi se lau eanua gougou eai, eo eanua hanahanau eai, aiai adi se uneune; isi aiai adi nige’e.” ");
INSERT INTO swp_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ia i heuio, ie ribalau aridi eai, i ene, “Aiai adi omi au mosedi.” Isi abo se ribalau ia arinai, si ene, “Denari tataosaudoudoi‐se‐mate taba ai abidi adi aiai ai uneune wa, abo ai mosedi se ai?” ");
INSERT INTO swp_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ia ie ribalau isi aridi eai, i ene, “Ami falawa wa hisa? Au lau au hasiridi.” Isi se hasiridi, abo si ene, “Haligigi, eo eama labui.” ");
INSERT INTO swp_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ia ie ribalau isi aridi eai, i ene, “Gamagaridi au hebawaporuporudi lei potana eai.” ");
INSERT INTO swp_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Isi abo se bawabigabiga, hari poru tatao haligigi se mate, hari poru tatao‐labui‐se‐mate‐saudoudoi. ");
INSERT INTO swp_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ia falawa haligigi i abidi, eo eama labui, i itaitasae galewa eai, i aihelahui; falawa abo i ihidi, abo i mosedi ena heaheatayao aridi eai, isi abo se peiauri moutuana lailai wa nuanuadi eai, eo eama labui hinage i soiedi isi gamagaridi adi. ");
INSERT INTO swp_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Isi gamagaridi se aiai, e, bogadi se sese. ");
INSERT INTO swp_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Isi falawa eo eama aitoredi se tanogogoidi, bosa saudoudoi‐labui se hemonaudi. ");
INSERT INTO swp_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Isi aiai tauaina nuana tatao tausani haligigi. ");
INSERT INTO swp_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ia ena heaheatayao i nuaoidi arinai se lau waga eai se geru baguna, se lau Betesaida eai, hari sana awasi eai, iabom ie mia moutuana i hetamaridi. ");
INSERT INTO swp_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ia i hetamaridi se lau, ia abo ie dalasae oea tupina esau eai, i lauuura. ");
INSERT INTO swp_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mahana ie duio, waga ie lau gabogabo duaduarina eai, ia iabom ie mia oea eai. ");
INSERT INTO swp_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ia i itadi, isi eare eai eawasidi se motu, mana ie toama matadi eai, bulinuana eai ie lau isi aridi eai, butubutu potadi eai, i laolaoma isi hasaridi eai. ");
INSERT INTO swp_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Isi ia se ita butubutu potana eai i laulau, isi edi nuatu, si ene bena earuyarua. Isi abo se eabayabaei; ");
INSERT INTO swp_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","isi gamagaridi ia se ita, se matausi ariariri. Ia ie ribalau isi aridi eai, i ene, “Nuamiu se taru: eau ede ina; tabu au matausi.” ");
INSERT INTO swp_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ia ie gerusae waga eai isi aridi eai, mana abo ie motu; isi abo se noo to se noo ariariri. ");
INSERT INTO swp_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Paana falawa gagiridi laulauna wa nige se nuatulobai, isi nuadi se oiura. ");
INSERT INTO swp_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Isi se lage hari sana awasi eai, Genesareta eanuana eai, nei eai se lopatu. ");
INSERT INTO swp_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Isi waga se pesagabei, tatao ia se italobai, ");
INSERT INTO swp_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","se aitautau, nei eanua eai eo eanua maudoudoina se hetaiiri, ena aba lage se ribaei, isi se ataiei, tauasiasiebo ma hatahatadi se laedi ia arinai. ");
INSERT INTO swp_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Eanua gamagamagari ia i baeawaidi, gougou eanuadi ealeba eai, eo eanua lailaidi; isi tauasiasiebo se ledima, baubau eai se hebawadi, se awanorilau ia arinai, ana lulu dedeana bena se abiita; isi gamagaridi ana lulu se abiita abo se mauri. ");
INSERT INTO swp_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parisea tataodi, eo tauuriuri tataodi headi Ierusalema eai se laoma, isi se oigogoma ia arinai. ");
INSERT INTO swp_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ena heaheatayao headi isi se itadi aiai se ai ma nima biibiidi, nige se nimadeuri, si ene se ponori. ");
INSERT INTO swp_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Paana Parisea tataodi, eo Iudea tataodi gamagaridi urutubu laulaudi se nanabuedi, aiai nige se ai gaibu mo, se nimadeuri baguna. ");
INSERT INTO swp_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Edi aba uneune eai isi se uioma ena nige se heaauioidi aiai nige se ai: laulau gamagaridi hinage isi se nanabuedi ina doha, bia, eo gulewa, eo bianomnom udoi, isi se deuridi. ");
INSERT INTO swp_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Parisea tataodi, eo tauuriuri tataodi se hesiolau ia arinai si ene, “Em heaheatayao urutubu laulaudi se saha nige se nanabuedi, isi adi aiai se aidi mo, nige se nimadeuri?” ");
INSERT INTO swp_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ia i heuio, ie ribalau aridi eai, i ene, “Omi tatao boraborasom, Isaia i heaheasoniemiu, doha ie uri, i ene, ‘Isi awadi eai mo se aihelahuigu, isi nuadi eai se tausuaraegu. ");
INSERT INTO swp_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Isi edi aihelahuigu nige ana ao, tatao edi laugagaeo mo se heaheatadi.’ (Isa. 29.13). ");
INSERT INTO swp_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Eaubada ena laugagaeo au torehesuaradi, tatao edi laugagaeo mo au abididinidi; eo ginauri gamagaridi nei doha au abiwataidi.’” ");
INSERT INTO swp_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ia i ribalau isi aridi eai, i ene, “Taiede, Eaubada ena laugagaeo au otaotaedi bena urutubumiu edi laugagaeo au sogohidi. ");
INSERT INTO swp_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mose i ribaeyao, i ene, ‘Tamam eo sinam u gigihebigadi’: (Ex. 20.12). eo i ene, ‘Esau tamana eo sinana ie ribahebaaeadi abo se unuhemate’: (Ex. 20.17). ");
INSERT INTO swp_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Omi emi ribaribana, au ene, ‘Ena tau ie ribalau tamana e sinana arinai i ene, Koban, ia ede ainauia, egu gadosisi, eo egu heasisi, eo egu gogo gamagari ea mosei Eaubada arinai, ea ainauiai’: ");
INSERT INTO swp_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Au ene taba tamana e sinana ia nige ie gigihebigadi, taiede, i lolo hinage. ");
INSERT INTO swp_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Omi ina doha urutubumiu mo edi laulau au abiwataidi, eo Eaubada ena riba au talaoriori: laulau gamagaridi ina doha au nanabuedi.” ");
INSERT INTO swp_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Moutuana wa i eogaidi se laoma ia arinai, abo ie ribalau isi aridi eai, i ene, “Omi gamagarimiu egu riba au ataiei, eo au nuatui: ");
INSERT INTO swp_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ginauri ina murimuri eai ta, tau ie domdi bogana alona eai ia nige se hebii; boeana eai se laoma temeta mo tau abo se hebii. ");
INSERT INTO swp_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ia beana eai i ataiei ia abo i ataiedidini.” ");
INSERT INTO swp_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ia abo i awasae numa alona eai moutuana wa i laugabaedi, ena heaheatayao parabole ta teina se oimuriei ia arinai. ");
INSERT INTO swp_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ia ie ribalau isi aridi eai, i ene, “Omi hinage ma supusupumiu? Nige au nuatui ginauri gamagari murimuri eai ta se domdi tau bogana alona eai, ia nige se heniginigi. ");
INSERT INTO swp_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nige se lau ia nuana boeana eai, bogana eai mo, aiai aba hinerina eai baaeana abo se gabaei?” ");
INSERT INTO swp_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Eo i ene, “Ginauri wa tau boeana eai se laoma, tau wa abo se hebii. ");
INSERT INTO swp_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tatao nuadi eai sanapu baaeadi se saema, mata’eo, eo inainana, eo aiunu, ");
INSERT INTO swp_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","eo aiyahari, eo aiaromagigiri, eo baaea gamagari, eo laulau borabora, eo nuatu bii, eo Eaubada se ribahebaaea, eo nuasaesae, eo eauyaure. ");
INSERT INTO swp_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Teina ginauri baaea gamagaridi nuadi eai se laoma tau aba heniginigina.” ");
INSERT INTO swp_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nei eai i torohai ie lau Turia eo Sidona anadai eai, eo ie awasae numa esau alona eai ena gadosisi tabu tau esau ia i ita: na ia nige i tauyamui. ");
INSERT INTO swp_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Sine esau, ia natuna siu gagirina, earua baaea ie lui, ia wasana i ataiei, abo ie laoma i tabaohu ia aena eai. ");
INSERT INTO swp_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Sine wa Heleni sinena, boga Penesia Suria: ia ie riba gadogadora ia arinai, ia demoni natuna siu ne arinai bena i aiduiei. ");
INSERT INTO swp_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Na, Iesu ie ribalau ia arinai, i ene, “Merumeru sora bogadi si sese baguna: taba merumeru adi aiai se gabalaei kedewa aridi eai, temeta doha nige i lolo.” ");
INSERT INTO swp_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Sine ne i heuio, ie ribalau ia arinai, i ene, “Guiau e, mamohoi, na merumeru adi aiai mapuradi taba se beu hatahata ubuna eai, kedewa hinage se aidi.” ");
INSERT INTO swp_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ia ie ribalau sine ne arinai, i ene, “U lau em asa eai, demoni wa natum siu boeana eai, i lauo murimuri eai, wau riba wa u ribaei debana eai.” ");
INSERT INTO swp_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ia abo ie lau ena numa eai, natuna siu ne ie ota taubiga ena aba eno eai, eo demoni i lauo murimuri eai. ");
INSERT INTO swp_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ia Turia eo Sidona adi sigasiga i laugabaedi, ie lau Dekapoli oea duaduarina eai, abo ie lage Galilaia gabogabona eai. ");
INSERT INTO swp_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Isi tau bea doodoona, eo arina wesawesasana se woeai ia arinai: isi abo se awanorilau ia arinai ia nimana bena i saosaei ia potana eai. ");
INSERT INTO swp_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Moutuana boeana eai i woeahai i laehesuara, ia nimana ie saolaei ia beana gudadi eai, i gariso, memenana abo i abiitalaei. ");
INSERT INTO swp_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ia i itaitasae galewa eai abo eawasina i tuhalei, abo i ribalau ia arinai, i ene, “Epata,” heaheasonina ede, “U malapai.” ");
INSERT INTO swp_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ia beana abo se malapai, memenana abo ie tabonosi, ia riba abo ie ribaei i masaraha. ");
INSERT INTO swp_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ia i guguiaidi, abo awadi i tawaidi: isi nige se ataiei, se wasaduaiei mo. ");
INSERT INTO swp_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Isi abo se noo ariariri, si ene, “Ginauri gamagaridi i ginauridi se lolo: tatao doodoodi to beadi i hemalapaidi, eo tatao unaunadi memenadi i hetabonosidi.” ");
INSERT INTO swp_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nei asubenana ne moutuana wa i lai ariri, isi nige adi aiai, Iesu ena heaheatayao i eogaidi, abo ie ribalau isi aridi eai, i ene, ");
INSERT INTO swp_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Moutuana lailai ta ea nuatoatoaedi paana isi asubena haiona eau arigu eai se mia, nige adi aiai. ");
INSERT INTO swp_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ena ea hetamaridi se lau edi eanua eai ma aiwesaridi, ata doha se aitu eda eai: headi edi eda se loloha.” ");
INSERT INTO swp_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","5","Ia ena heaheatayao ia se heuio si ene, “Barabara ina, aiai haedi aba abina moutuana lailai ta abo ta hegonoahidi?” Ia i hesiolau isi aridi eai, i ene, “Omi ami falawa wa hisa?” Isi si ene, “Haligigi‐labui.” ");
INSERT INTO swp_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ia tatao gamagaridi ie ribahesomdi se bawa tano eai: ia falawa haligigi‐labui wa i abidi, i aihelahui, abo i ihidi i mosedi ena heaheatayao aridi eai moutuana wa nuanuadi eai se peiauri, isi abo se soiedi. ");
INSERT INTO swp_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Isi eama gagiridi headi hinage se abidi; i aihelahui, abo ie ribahesomdi isi nuanuadi eai se peiauri. ");
INSERT INTO swp_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Isi se aiai, e, bogadi se sese; aiai mapulana isi abo se tanogogoi bosa haligigi‐labui. ");
INSERT INTO swp_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nuana tauaina tausani hasi: ia abo i hetamaridi isi abo se lau. ");
INSERT INTO swp_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ia maena heaheatayao waga esau eai se geru abo se dunasae Dalemanuta eai. ");
INSERT INTO swp_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Parisea tataodi se taulagema, se hesiolau ia arinai, galewa heiheinoina esau bena si eooi, arinai ia se nohoi. ");
INSERT INTO swp_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","I nuadubu, i ene, “Isi ta, saha heiheinoina si eooi? Ea heribamiu ta mamohoi, heiheinoi taba nige se mosei teina isi ta aridi eai.” ");
INSERT INTO swp_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ia i laugabaedi; ie geruuio waga eai, ie lau hari sana awasi eai. ");
INSERT INTO swp_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ia ena heaheatayao aiai nige se abi, nuadi se hui; isi adi falawa esega mo waga eai ie ota. ");
INSERT INTO swp_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Iesu i ribahesanapuedi, i ene, “Nanabumiu au nanabu, Parisea tataodi adi yeast, eo Heroda hinage ana yeast au itakomakomani.” ");
INSERT INTO swp_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Isi se nuatudadaasa, si ene, “Paana nige adi aiai.” ");
INSERT INTO swp_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Iesu edi nuatu i nuatui, ie ribalau isi aridi eai, i ene, “Ede saha au nuatudadaasaeai ina nige ami aiai ta? Ma supusupumiu, ma hekaumiu miana mo wa? Ede nuamiu masigirina miana mo wa? ");
INSERT INTO swp_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Omi matamiu! nige au ita? omi beamiu! nige au ataiei? (Iere 5.21) omi nige au nuatui? ");
INSERT INTO swp_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Falawa haligigi ea ihidi, tatao tausani haligigi ea mosedi se ai, aiai mapulana bosa hisa au usahemonaudi?” Isi si ene, “Saudoudoi‐labui.” ");
INSERT INTO swp_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Eo falawa haligigi‐labui, tatao tausani hasi se mosedi, aiai mapulana bosa hisa au usahemonaudi?” Isi si ene, “Haligigi‐labui.” ");
INSERT INTO swp_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ia ie ribalau isi aridi eai, i ene, “Omi aue saha nuamiu nige se masaraha?” ");
INSERT INTO swp_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ia Betesaida eai ie lage; tau matagibugibu esau se woeai ia arinai, se awanorilau bena ia i abiita. ");
INSERT INTO swp_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ia tau matagibugibuna nimana eai i abilau, ie woeai eanua murimurina eai: matana i garisoi, nimana i saosaei ia potana eai, i hesiolau ia ginauri ie ita? ");
INSERT INTO swp_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tau wa ie itaitasae ewa eai, i ene, “Tatao ea itadi adi ao doha hinage oeagi, se tautausi.” ");
INSERT INTO swp_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Iesu nimana i toreuioi ia matana eai; ia abo i itaitasae ewa eai, matana abo se lala, tatao gamagaridi abo i itakomakomanidi. ");
INSERT INTO swp_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Iesu ia abo i hetamari ie lau ena numa eai, i ene, “Tabu u lau eanua eai, riba ta eanua eai tabu tau esau u heriba.” ");
INSERT INTO swp_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Iesu ena heaheatayao se lau eanua gougou gamagaridi Kaisaria Pilipi eai; isi eda eai se lau, ia i hesiolau isi aridi eai, i ene, “Tatao si ene, eau ede eai?” ");
INSERT INTO swp_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Isi se heuio, si ene, “Headi si ene, Ioane Bapatiso: na headi si ene, Elia; headi si ene, Peroveta tauna esau.” ");
INSERT INTO swp_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ia ie ribalau isi aridi eai, i ene, “Na, omi au ene eau ede eai?” Petero ia i heuio, i ene, “Oa Keriso ede.” ");
INSERT INTO swp_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ia i guguiaidi ia ribana tabu tau esau si heriba. ");
INSERT INTO swp_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ia abo i hetubu i heatadi Tau Natuna amamna gamagaridi taba i hearodi, babada, eo kohena babadadi, eo tauuriuri tataodi, isi ia abo se otaotaei, abo hinage se unuhemate, i lau e asubena haiona abo ie torouio. ");
INSERT INTO swp_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Teina riba ta ie riba hemasaraha, Petero ia i woeahesuara, ia Iesu i ribasuuilaei. ");
INSERT INTO swp_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Iesu i sinibuima ie italau ena heaheatayao aridi eai, ia Petero i ribasuuilaei, i ene, “Oa Satani, u lau udoi wa murigu eai; Eaubada ena ginauri nige u nuatuidi, tatao mo edi ginauri.” ");
INSERT INTO swp_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ia ie ribalau tatao gamagari aridi eai, eo ena heaheatayao hinage, i ene, “Ena tau esau i hemuriwataigu, iabom i nuagabaeuioi, ena satauro i abiisini abo i hemuriwataigu. ");
INSERT INTO swp_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Iabom maurina i gadosisiei ia mauri taba nige ie ita; ia maurina i nuagabaei eau debagu eai, eo evanelia debana eai, ia abo i mauri mamohoi. ");
INSERT INTO swp_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Saha lolona abo tau ie abi, taba gogo gamagari tanoubu eai ta i abiheohidi, ia maurina hinage ie tauiamui? ");
INSERT INTO swp_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tau ena saha abo i mosei ia maurina maisana? ");
INSERT INTO swp_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ena isi, teina isina baaeana ta, se taumaeamaeaigu, eo eau egu riba se taumaeamaeaei, Tau Natuna isi hinage abo i taumaeamaeaidi, huiana i dobiuioma, Tamana ena namanamari arinai, maena aneru hetahetabudi hinage.” ");
INSERT INTO swp_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ia ie ribalau isi aridi eai, i ene, “Ea heribamiu ta mamohoi, headi inai se totoro, isi sora mate taba nige se hearo, Eaubada ena basileia ie lagema ma gigiborina isi abo se ita.” ");
INSERT INTO swp_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Asubena haligigi‐esega se ohi, Iesu Petero, eo Iamesi, eo Ioane ie woeasaedi, isibom, oea tupi lohaloha deba pogana eai: isi matadi eai ia matana se ori. ");
INSERT INTO swp_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ia ana lulu ie namanamari, ie posi ariariri, oma taudeurina tanoubu eai ta nige se heposiposi doha. ");
INSERT INTO swp_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Elia maena Mose se taulagema isi aridi eai: isi maedi Iesu se ribariba. ");
INSERT INTO swp_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petero ie ribalau Iesu arinai, i ene, “Tanuagamai e, i lolo inai mo ta mia: taba apa haiona ai abidi, esau enam, esau Mose enana, esau Elia enana.” ");
INSERT INTO swp_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ia ie riba napai mo, isi taudi se ihigori ariri. ");
INSERT INTO swp_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Eada esau isi i poiidi: arina esau eada boeana eai i lagema, i ene, “Natugu ea gadosisiei ede teina: ia au ataiei.” ");
INSERT INTO swp_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ma esega, isi abo se ita hetahetaiiri, nige tau se ita, Iesu iabom mo maedi isi hinage. ");
INSERT INTO swp_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Isi abo oea eai se leta se dobi, ia awadi i tawaidi wau ginauri wa se itadi wa tabu tau esau se heriba, i lau e, Tau Natuna mate eai abo i torouioma. ");
INSERT INTO swp_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Teina riba ta abo se nuatudidini, se nuatudadaasaeai, si ene, Mate eai torouiomana aisana? ");
INSERT INTO swp_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Isi se hesiolau ia arinai si ene, “Paana saha tauuriuri tataodi si ene, Elia taba ie lage baguna?” ");
INSERT INTO swp_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ia i heuio i ribalau isi aridi eai, i ene, “Mamohoi Elia i lage bagunama, ia abi gamagamagaridi abo i heharihariudi; hinage edoha se uriwatai, Tau Natuna amamna gamagamagaridi abo i hearodi, eo ia abo se isuewaei? ");
INSERT INTO swp_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Na, ea heribamiu ta Elia mamohoi i laomao, isi edi gadosisi ia arinai se abidio, doha hinage ia enana se urimaodai.” ");
INSERT INTO swp_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ia ie uioma ena heaheatayao aridi eai, moutuadi lailai i itadi se toro hetahetaiiridi, eo tauuriuri tataodi se hesihesiolau aridi eai. ");
INSERT INTO swp_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Moutuana wa ia se ita, isi aruadi se loi, se aitautau ia arinai, ia se lautoiei. ");
INSERT INTO swp_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ia ie hesiolau tauuriuri tataodi aridi eai i ene, “Saha au oiribaei isi aridi eai?” ");
INSERT INTO swp_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Moutuadi ne tauna esau ia i heuio, i ene, “Tau Heaheata e, natugu ea woeaiama oa arim eai, earua auaurea ia arinai; ");
INSERT INTO swp_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ia se basaalaalatei: awana i gosagosapuro, eo moana i taburuiahisi, ia tauna i eagayaga: ea ribalau em heaheatayao aridi eai bena se aiduiei, isi nige abina se ata.” ");
INSERT INTO swp_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iesu ia i heuio, i ene, “Kapore! sunuma gagiri isina ta, eau arimiu eai miamiagu, i lau e, aitea huia? Ea healapaipaimiu, i lau e aitea huia? Ia au woeaiama arigu eai.” ");
INSERT INTO swp_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ia abo se woeaiama ia arinai: ia Iesu i italaei ina earua ta gama wa ie basaalaalatei, ie guri dobi tano eai, ie boroborousi, awana i gosagosasapuro. ");
INSERT INTO swp_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Iesu i hesiolau ia tamana arinai, i ene, “Auiana teina asiebo ta ie tubu ia arinai?” I ene “Ma gagirina eai. ");
INSERT INTO swp_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Huia gamagari ia se gabaei oeagi boeana eai, eo goila eai hinage, bena abo ie mate wa; ena abina u ata u nuatoatoaimai, u saguimai.” ");
INSERT INTO swp_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Iesu ie ribalau ia arinai, i ene, “Taba u awamamohoiei: tau taba i awamamohoiei ginauri gamagaridi abidi i atao.” ");
INSERT INTO swp_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Gama ne tamana i eogalau ma matasuruna, i ene, “Guiau e, ea awamamohoiei: egu awamamohoi mo i beruberu arinai u saguigu.” ");
INSERT INTO swp_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Iesu moutuadi i itadi se aitautauma, earua bii ne i aiduiei, i ene, “Oa earua auaureana ta, eo doodoona, ea heribam ta u lau murimuri eai, tabu u luuio ia boeana eai.” ");
INSERT INTO swp_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Earua wa abo ie eoga, gama wa i basaalaalatei abo ie lau murimuri eai: merumeruna wa doha tau matematena, moutuana wa si ene, “I mate aririo.” ");
INSERT INTO swp_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Na, Iesu i abilau ia nimana eai, i abihetoro; ia abo i toro. ");
INSERT INTO swp_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ia i awasaema numa alona eai, ena heaheatayao se oimuri modigau ia arinai, si ene, “Paana saha ai aiduiena nige abina aie ata?” ");
INSERT INTO swp_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ia ie ribalau isi aridi eai, i ene, “Demoni ina doha nige se pesa gaibu murimuri eai, uura, eo aiudi aridi eai mo.” ");
INSERT INTO swp_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nei dimona ne abo se laugabaei, Galilaia eai se baeyawa; ia nige i henua ena lau bena tau esau i nuatui. ");
INSERT INTO swp_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ia ena heaheatayao i heatadi, ie ribalau isi aridi eai, i ene, “Tau Natuna ia abo se mosei tatao nimadi eai, ia bena abo se unuhemate; se unuiyao, abotai abo i torouio asubena hehaionana eai.” ");
INSERT INTO swp_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Teina riba ta se hekau, ia bena se oimuriei, na se matausi. ");
INSERT INTO swp_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ia ie lage Kaperenauma eai, numa alona eai ia i hesiolau isi aridi eai, i ene. “Omi saha au haiawayagaraei dobila eai?” ");
INSERT INTO swp_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Isi nige arinadi; isibom dobila eai se haiawayagara wa, eai isi aridi eai abo edi bada ede. ");
INSERT INTO swp_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ia ie bawa, saudoudoi‐labui i eogaidi; ie ribalau isi aridi eai, i ene, “Tau esau i henua bena i baguna, ia abo i murimurita, eo isi gamagaridi edi heaheari eai i lau.” ");
INSERT INTO swp_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Iesu merumeru gagirina esau ie abi, i torelaei duaduaridi eai: abo i labasi, i ribalau aridi eai, ");
INSERT INTO swp_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","i ene, “Ia merumeru gagirina ina doha i oiami eau esagu eai, ia i oiamigu hinage: tauoiamiguma nige eaubom i oiamigu, ia hinage Tauhetamariguma wa ie oiami.” ");
INSERT INTO swp_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ioane i heuio ia arinai, i ene, “Tanuagagu e, tau esau aie ita oa esam eai demoni ie aiduiedi; ia nige ie lauwataida; ia ai ribagigiri paana ia nige ie lauwataida.” ");
INSERT INTO swp_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Iesu i ene, “Ia tabu au ribagigiri: tau esau taba gigibori ta i laulauei eau esagu eai, taba nige i ribahebaaeagu. ");
INSERT INTO swp_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ena ia nige ie hetataguduguduida ita enada meta. ");
INSERT INTO swp_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ena esau, esau, goila nomnom biana esau i leawa eau esagu eai, paana oa Keriso enana; ea ribalaowa omi arimiu eai, mamohoi, ia maisana taba nige i deha. ");
INSERT INTO swp_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ena esau, esau, merumeru gagirina esau eau awagu tauabina i heguri, i lolo taba we’u lailai ia gadona eai se au, abo se tudobei gabogabo eai. ");
INSERT INTO swp_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Eo ena nimam i hegurim, u tomgabaei; i lolo nimam esega, mauri abo u abi, ena nimam labui masigiri boeana eai ue lage oeagi alaalasina boeana eai nige nosina. ");
INSERT INTO swp_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Nei dimona ne motamota nige se mate, eo oeagi nige se oiheboso. ");
INSERT INTO swp_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ena aem i hegurim, u tomgabaei: i lolo aem ie motu abo mauri u abi, ena aem labui masigiri boeana eai se tudobem oeagi nige ie boso boeana eai; ");
INSERT INTO swp_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","nei dimona ne motamota nige se mate, eo oeagi se oiheboso. ");
INSERT INTO swp_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ena matam i hegurim, u lamohai: i lolo matam esega Eaubada ena basileia eai u lage, matam labui oa abo se gabadobem oeagi nige se boso boeana eai: ");
INSERT INTO swp_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","nei dimona ne motamota nige se mate, eo oeagi nige se oiheboso. ");
INSERT INTO swp_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Gamagarimiu abo se hearitamiu oeagi alaalasina eai. ");
INSERT INTO swp_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Arita i lolo: ena aritana ne i tomatoma, edoha emi abiabina abo i aritauio. Arita i ota omi nuamiu eai, au hainua‐bigauioimiu.” ");
INSERT INTO swp_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ia abo i torohai ie lau Iudea ana siga eai, Ioridano tehana eai; moutuana se oigogouio ia arinai: ia i heatauioidi, ena laulau nei doha. ");
INSERT INTO swp_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Parisea tataodi se laoma ia arinai, se hesiolau, si ene, “Tau, ia laugagaeo ta i lauwatai ia monena taba i inawasei wa?” ");
INSERT INTO swp_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ia i heuio, ie ribalau aridi eai, i ene, “Mose saha i lauhesommiu wa?” ");
INSERT INTO swp_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Isi si ene, “Mose ie riba, inawase ribana se uri abo i inawase.” ");
INSERT INTO swp_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Iesu i heuio, ie ribalau isi aridi eai, i ene, “Omi nuamiu se oiura ariri arinai ede laugagaeo ta se uriyao. ");
INSERT INTO swp_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Mumuga eai, ena huia ginauridi Eaubada tau to sine i ginauridi. ");
INSERT INTO swp_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Paana ede meta tau, tamana eo sinana ie laugabaedi, ie patulau monena arinai: ");
INSERT INTO swp_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","isi taudi labui buluma esega mo, isi abo nige labui, na buluma esega mo. ");
INSERT INTO swp_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Saha wa Eaubada i hepatuesegaidi tatao tabu se torehesuaradi.” ");
INSERT INTO swp_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Numa alona eai teina riba ta ena heaheatayao se hesiouioi ia arinai. ");
INSERT INTO swp_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ia ie ribalau isi aridi eai, i ene, “Ia monena i inawasei esau i hai, ia abo i ganawari: ");
INSERT INTO swp_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ena sine hinage monena i inawasei, esau i hai, ia abo i ganawari.” ");
INSERT INTO swp_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Isi merumeru gagiridi se woeaidi ia arinai bena abo i abiitadi; ena heaheatayao merumeru tauwoeaidi se ribagigiridi. ");
INSERT INTO swp_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Iesu ie itadi, nuana i baaea ariri, ia i ribalau isi aridi eai, i ene, “Merumeru gagiridi taba se laoma eau arigu eai, tabu au guduguduidi: Eaubada ena basileia doha ede isi. ");
INSERT INTO swp_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ea heribamiu ta mamohoi, eai to eai Eaubada ena basileai ia nige ie abi doha merumeru gagirina, ia nige i lusora arinai.” ");
INSERT INTO swp_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ia abo i labaisinidi, ia nimana i saosaei isi potadi eai, i ribahelolodi. ");
INSERT INTO swp_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ia eda lai eai ie lau, tau esau i aitautau ia arinai, ia turina ie bono ia nuanuana eai, i hesiolau ia arinai, i ene, “Tanuagagu lolona e, eau egu abiabina edoha mauri nige nosina abo ea abi?” ");
INSERT INTO swp_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Iesu ie ribalau ia arinai, i ene, “Ue saha u ene eau ea lolo? Nige esau i lolo, Eaubada iabom. ");
INSERT INTO swp_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Laugagaeo u nuatuidi, tabu u matamatae’o, Tabu u aiunu, Tabu u aiyahari, Tabu u morui, Tabu u borabora, Oa tamam eo sinam u eogoyogoidi.” ");
INSERT INTO swp_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ia i heuio ia arinai, i ene, “Tanuagagu e, eau ma gagirigu i laoma e teina huia ta, teina laugagaeo ta ea nanabuheohidio.” ");
INSERT INTO swp_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iesu i italau ia arinai, ia i gadosisiei, eo i ene, “Ginauri esega mo nige u abi, u lau em aba lau eai, oa em gogo saha eo saha u unegabaedi u mosedi gogogesagesa enadi, oa em gogo galewa eai abo u abi; u laoma, em satauro u abiisini, u hemuriwataiguma.” ");
INSERT INTO swp_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nei riba ne i ataiei ie nuadubu, ia abo ie lau nuana i amamna, paana ia gogo gamagari tauna. ");
INSERT INTO swp_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iesu i itahetaiiri, ie ribalau ia ena heaheatayao aridi eai, i ene, “Gogo gamagari tataodi bena se lusora Eaubada ena basileia eai i piripiri ariri.” ");
INSERT INTO swp_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ia ena riba ena heaheatayao se nooei. Na, Iesu i heuiouioidi, i ribalau aridi eai, i ene, “Merumeru e, isi gogo tausunumaena bena Eaubada ena basileia eai se lusora i piripiri ariri. ");
INSERT INTO swp_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamela ie lusora mo diu gudana eai, taumonamonaune bena i lusora Eaubada ena basileia eai abo ie ahi.” ");
INSERT INTO swp_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Isi abo se noo ariariri, isi se heunaboisaha, si ene, “Eai abo i mauri?” ");
INSERT INTO swp_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iesu i italaedi, i ene, “Tatao abina nige se ata, ede Eaubada mo, Eaubada ia ginauri gamagaridi abidi ie ata.” ");
INSERT INTO swp_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petero abo ie ribalau ia arinai, i ene, “Ginauri gamagaridi ai laugabaedi ai hemuriwataim.” ");
INSERT INTO swp_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Iesu ia i heuio, i ene, “Ea heribamiu ta mamohoi, ena tau esau ena numa i laugabaei, eo ena tataoyao, eo lounayao, eo tamana, eo sinana, eo monena, eo nanatunayao, eo ena oea, eau debagu eai, eo evanelia debana eai, ");
INSERT INTO swp_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ia ginauri gamagaridi teina huia ta i abidi, numa, eo ena tataoyao, eo lounayao, eo sinanayao, eo nanatunayao, eo oea, ia se heamamna hinage; huia murina eai abo mauri nige nosina hinage i abi. ");
INSERT INTO swp_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Gamagaridi se bagubaguna abo se murimurita, isi se murimurita abo se bagubaguna.” ");
INSERT INTO swp_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Isi eda eai se lau Ierusalema; Iesu i bagubagunaedi; isi se noo; eo isi murina eai se laulau se matausi. Ia saudoudoi‐labui i abihesuaradi i hetubu i heribadi ginauri gamagaridi wa ia abo i hearodi. ");
INSERT INTO swp_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ia i ene, “Ta lau Ierusalema eai, Tau Natuna abo se moselaei kohena babadadi, eo tauuriuri tataodi aridi eai; isi ia abo se hegiru bena abo se unuhemate; eo abo se moselaei Murimuri‐tataodi aridi eai. ");
INSERT INTO swp_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Isi ia abo se alaliuliuaei, eo abo se pidiri, eo abo se garigarisoi, eo abo se unuhemate: asubena hehaionana eai ia abo i torouioma.” ");
INSERT INTO swp_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebedaio nanatunayao, Iamesi ma ena tau Ioane, se laoma ia arinai, si ene, “Tanuagamai e, ai ema gadosisi ai awanorilaowa oa arim ena bena u eari.” ");
INSERT INTO swp_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ia ie ribalau isi aridi eai, i ene, “Omi emi gadosisi saha abo ea leawa?” ");
INSERT INTO swp_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ia arinai si ene, “Teina ta u leama enamai; oa edi aba hedebasaem eai, ai ene bena esau nimatutum eai ie bawa, eo esau nimaseuseurim eai.” ");
INSERT INTO swp_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Na, Iesu i ribalau isi aridi eai, i ene, “Omi emi awanori ta abina nige au ata: taba bia ta ea nonom omi hinage abo au nom? bapatiso eau se hebapatisoigu omi hinage abo se hebapatisoimiu wa?” ");
INSERT INTO swp_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Isi abo se ribalau ia arinai, si ene, “Hedeona.” Iesu ie ribalau aridi eai, i ene, “Bia ta ea nonom omi hinage abo au nom; bapatiso arinai eau se hebapatisoigu omi hinage abo se hebapatisoimiu: ");
INSERT INTO swp_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","na tau nimatutugu eai ie bawa, eo tau nimaseuseurigu eai, eau nige ea mosei gaibui mo: isi isibom enadi wa se ginauri nonohaiyao” ");
INSERT INTO swp_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Saudoudoi wa riba ta se ataiei, isi se hetubu Iamesi ma ena tau Ioane se nuabaaeaedi. ");
INSERT INTO swp_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Iesu i eogaidi ia arinai, ie ribalau isi aridi eai, i ene, “Omi au itayao Murimuri‐tataodi edi guiau gamagaridi tatao se tanuagaidi, eo isi edi babada tatao se tanuagaidi hinage. ");
INSERT INTO swp_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Na omi tabu nei doha: ena esau i henua ia emi bada ia abo emi heaeai tauna eai ie lau. ");
INSERT INTO swp_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ena esau arimiu eai i henua bena ia i sae, ia abo gamagarimiu emi heaheari eai ie lau. ");
INSERT INTO swp_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Paana ede hinage, Tau Natuna i laoma nige ena heaheari tauna, iabom heaheari tauna eai ie lau; ia maurina hinage ie mosei tatao gamagaridi maisadi.” ");
INSERT INTO swp_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Isi abo se lage Ieriko eai; ia ma ena heaheatayao, eo tatao moutuadi hinage Ieriko se laugabaei, Baratimaio taumatagibugibu, Timaio natuna, ie bawa dobila lailai hasarina eai, i awaawanori. ");
INSERT INTO swp_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Wasana i ataiei Iesu Nasareta nei, ia i hetubu i eogalau, i ene, “Iesu e, Davida natuna, u nuatoatoaeguma!” ");
INSERT INTO swp_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Gamagaridi ia si siooei si ene, u monou: ia abo ie eoga lailai i ene, “Davida natuna e, u nuatoatoaeguma!” ");
INSERT INTO swp_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Iesu abo i tarutoro, i lauhesomdi ia se eogaiama. Isi abo taumatagibugibuna se eogalau ia arinai, si ene, “Tabu u nuadubu, u toro, i eogaim.” ");
INSERT INTO swp_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ia ana lulu i abigabaei, i torohai, i laoma Iesu arinai. ");
INSERT INTO swp_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Iesu i heuio ia arinai i ene, “Oaem gadosisi abo ea sahaim?” Taumatagibugibuna ne i ene, “Guiau e, eau matagu bena u helaladima.” ");
INSERT INTO swp_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Iesu i ribalau ia arinai, i ene, “U lau em aba lau eai, oa sunumam i helolom.” Arinai ia matana se lala, eo ia Iesu murina eai ie lau dobila eai. ");
INSERT INTO swp_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Isi abo se laoma Ierusalema se hanahanau, Betepage eo Betania eai se lage, Oliveta oeana eai, ia abo ena heaheatayao labui ie hetamarilaedi. ");
INSERT INTO swp_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ia ie ribalau aridi eai, i ene, “Omi au lau nei eanua gougouna eai ne, au lulagelau arinai, asini natuna se auauiao abo au ita, sora nige tau esau ie bawasae potana eai: au eairi abo au leama. ");
INSERT INTO swp_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ena tau esau i ribalaowa arimiu eai, i ene, ‘Saha au abi?’ au ene, ‘Guiau ena gadosisi teina; abo i hetamariuioi inai;’ ia abo i eari.” ");
INSERT INTO swp_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Isi se lau asini natuna se ita numa dobilana murimurina eai se auiao, eda labui edi aba saa eai, isi abo se eairi. ");
INSERT INTO swp_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Headi nei eai se totoro se ribalau aridi eai, si ene, “Iei, asini natuna sahana au eairi?” ");
INSERT INTO swp_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Iesu i ribahesomdi wa se heribadi; isi abo se eari. ");
INSERT INTO swp_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Asini natuna abo se leama Iesu arinai, edi oma se saosae potana eai. Iesu abo i bawasae arinai. ");
INSERT INTO swp_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Gamagaridi edi oma se lauwese dobila eai: headi hinage oeagi bagadi se talahaidi se lauwese dobila eai. ");
INSERT INTO swp_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Headi se baguna, eo headi se murita, se wowo, si ene, “Hosana: ia i laoma Guiau esana eai se helolo!” ");
INSERT INTO swp_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ita tamada Davida ena basileia i laolaoma Guiau esana eai se helolo: Hosana ini puripurina eai!” ");
INSERT INTO swp_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iesu i lulagelau Ierusalema eai, i lusae numa uura alona eai, ginauri gamagaridi i ita hetahetaiiriheohidi, i maimailahio arinai se pesa, ia maena saudoudoi‐labui se lau Betania eai. ");
INSERT INTO swp_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Maraietom isi Betania eai se lagema, ia abo i wesari. ");
INSERT INTO swp_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ia kuhou esau i ita eda lohaloha eai i uiawa: i laoma ie ita bena aiaina ewana eai, ede lugu ahaahana mo; aiaina huiana sora. ");
INSERT INTO swp_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Iesu i ribalau kuhou ne arinai, i ene, “Tabu tau esau aiaim i ai, i lau e, ana huia ana tasi.” Ia ena heaheatayao ena riba se ataiei. ");
INSERT INTO swp_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Isi abo se lagema Ierusalema eai; Iesu i lusae numa uura alona eai, ia abo tauuneune i aiduiedi si unelau, si unelaoma numa uura alona eai, moni tauune heduhedudu edi hatahata, eo bunebune tauuneune edi aba babawa abo i ahalabuidi. ");
INSERT INTO swp_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ia nige ie eari gogo abatoredi se bahei numa uura alona eai se lusora. ");
INSERT INTO swp_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ia abo i heatadi, i ene, “Isi se uriyao, ‘Eau egu numa se ribaei, eanua gamagamagari edi aba uura, e nige’e wa?’ Omi au abi i hemala duha, tatao aiaiyahari edi aba oigogo.” ");
INSERT INTO swp_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tauuriuri tataodi, eo kohena babadadi ena riba se ataiei, adi gui se oi ia bena se unui: isi ia se matausiei, paana ede tatao gamagaridi ena lauheata se nooei. ");
INSERT INTO swp_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","I maimailahi ia abo i lau eanua murimurina eai. ");
INSERT INTO swp_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Maratomtom eai isi abo se uio kuhou wa se ita ie wowoeaohi, eo lamna hinage. ");
INSERT INTO swp_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petero nuana ie sae, ie ribalau ia arinai, i ene, “Tanuagagu e, kuhou u ribahebaaea wa, i wowoeaohi.” ");
INSERT INTO swp_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Iesu ia i heuio, ie ribalau isi aridi eai, i ene, “Eaubada au sunusunumaei. ");
INSERT INTO swp_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ea heribamiu ta mamohoi, esau, esau, ie ribalau teina oea tupina ta arinai, “Oa abo u buihaim, u beudobi gabogabo boeana eai,’ eo ia nige nuana labui, na i nuatui riba i ribaei wa abo ie tubu, mamohoi, abo ie tubu hinage. ");
INSERT INTO swp_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Arinai ea heribamiu ta, ia ede ginauri gamagaridi au henuadi uura eai au awanoridi, au nuatui abo au abidi, eo abo au hearodi. ");
INSERT INTO swp_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ena au totoro au uura, eo headi se hebaaeamiu, isi edi baaea au nuatugabaedi, abotai abo omi emi baaea Tamamiu galewa eai ie mia abo i nuatugabaedi. ");
INSERT INTO swp_vpl VALUE